﻿USE sofia;
DROP TABLE IF EXISTS sofia.tgo_vpl;
CREATE TABLE tgo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tgo_vpl WRITE;
INSERT INTO tgo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","E rɨghendako moli, mbaŋaniye Loi va i vakathaŋgiya buruburu na yambaneke; ");
INSERT INTO tgo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","yambaneke va kokowae moli na mava bigi regha inawe. Vambe njighɨ eŋge vara ghawoke laghɨye na ina e momouwo tɨne, na Loi Une vama ina e njighɨko vwatae, i rorololoŋga. ");
INSERT INTO tgo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Amba Loi iŋa, “Manjamanjala u yomara e valɨvaŋgake iyake,” na e mbaŋako iyako manjamanjala i yomara. ");
INSERT INTO tgo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Loi i thuwe manjamanjalako na i warari kaiwae; amba i vakatha manjamanjala na i meghaghathɨ weya momouwo. ");
INSERT INTO tgo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Loi i rena manjamanjalako idae “ghararaghɨye” na momouwo “gougou.” I gou na kaero i ghɨviyava, na iyako mbaŋa regha. ");
INSERT INTO tgo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Iyako e ghereiye Loi iŋa, “Lughawoghawo u yomara e mbaŋake iyake, na i yomara, na i lighale mbwa yavoro na mbwa bodeke.” ");
INSERT INTO tgo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Me vakatha lughawoghawoko iyako na i mwanaghaghathɨ mbwake bodeke na mbwako yavoroko. Na i yomara ŋgoreiyeko. ");
INSERT INTO tgo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Loi i rena lughawoghawoko idae “buruburu.” I gou na kaero i ghɨviyava, na iyako mbaŋa mbaŋaiwoniye. ");
INSERT INTO tgo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Iyako e ghereiye Loi iŋa, “Mbwa bodeke u voruvavatha e valɨvaŋga regha, na bwadabwada u yomara.” Na i yomara ŋgoreiyeko. ");
INSERT INTO tgo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Loi i rena thelau momoe “yambane,” na mbwa ve voruvavathama na reghama “njighɨ.” Loi i thuwe iyako na i warariŋa. ");
INSERT INTO tgo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Amba Loi iŋa, “Bigibigike wolaghɨye, hu mbuthu e thelauko.” Vavana thɨ rau na e mbombounji e tɨnenjiko. Nana na umbwaumbwa tomethi ghanjiyamoyamo, na kaero ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","E yambaneke kaero nana na umbwaumbwa thɨ mbuthu na thɨ rau tomethi uneunenji na ghanjiyamoyamo. Loi i thuwe iyako na i warariŋa. ");
INSERT INTO tgo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","I gou na kaero i ghɨviyava, na iyako mbaŋa mbaŋatoniye. ");
INSERT INTO tgo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Amba Loi iŋa, “Manjamanjala hu yomara e buruburuko na i lighale ghararaghɨye weya gougou, na thɨ giya thuwai na theghathegha ghanjinono thaga kaiwanji, na mbaŋa na theghathegha regha na regha. ");
INSERT INTO tgo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Manjamanjalako thiyako thɨ yaku e buruburuko na thɨ giya manjamanjala e yambaneke.” Na i yomara ŋgoreiyeko. ");
INSERT INTO tgo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Loi i vakathaŋgiya manjamanjala laghɨlaghɨye theghewo, regha varae i mbaroŋa ghararaghɨye na regha manjala i mbaroŋa gougou, na vambe i vakathaŋgiva ghɨtara. ");
INSERT INTO tgo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","I bigirawevaoŋgi e buruburuko na thɨ giya manjamanjala e yambaneke. ");
INSERT INTO tgo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Thiye thɨ mbaroŋa ghararaghɨye na gougou na tembe thɨ lighaleva ghararaghɨye na gougou. Loi i thuwe iyako na i warariŋa. ");
INSERT INTO tgo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","I gou na kaero i ghɨviyava, na iyako mbaŋa mbaŋavarɨniye. ");
INSERT INTO tgo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Amba Loi iŋa, “Njighɨ na mbwa matemateko wolaghɨye hu yomara e njighɨko tɨne na e mbwako tɨne, na maa hu yomara na hu yoyo e buruburuko na yambaneke ghanjilughawoghawo.” ");
INSERT INTO tgo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Loi i vakathaŋgiya borogi laghɨlaghɨye na njighɨko matemate wolaghɨye e yawayawalinji na thɨ nyivɨnyivɨ, na maake wolaghɨye. Na budakaiya va i thuwe Loi i warariŋaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Loi i giya ghanjimwaewo na i dage weŋgi na thɨ ghambɨ rake na thɨ riyevanjara njighɨko tɨne, na i dage weŋgiya maako na tembe thɨ vakathava ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","I gou na kaero i ghɨviyava, na iyako mbaŋa mbaŋalimaniye. ");
INSERT INTO tgo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Amba Loi iŋa, “E yambaneke thetheghanɨke wolaghɨye hu yomara. Thetheghan mbwaeva na thetheghan thɨ li e gharenji vwatae na mbe vavanava thɨ loŋgaloŋga e thelau vwatae; thetheghan thiye mbwanjamɨŋgi inanji e njamnjam, tomethi ghanjiyamoyamo.” Na i yomara ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Loi va i vakathaŋgiya thetheghanɨko thiyako na mbe tomethi ghanjiyamoyamo, thetheghan mbwaeva na mbwanjamɨŋgi na thiye thɨ loŋga e gharenji vwatae. Na Loi i thuwe iyako na i warariŋa. ");
INSERT INTO tgo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Amba Loi iŋa, “Ra vakatha lolo e ghandayamoyamoke na ŋgoreiya ghinda, na mbala i mbaroŋaŋgiya borogi e njighɨko na maa thɨ yoyo, ŋgoreiya thetheghanɨke wolaghɨye, mbwaeva na mbwanjam, na thetheghan thɨ loŋgaloŋga e gharenji vwatae inanji e yambaneke.” ");
INSERT INTO tgo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Iya kaiwae Loi i vakatha lolo, na loloko iyako i vakatha ghamberegha e ŋgaliŋgaliya; i vakathaŋgiya ghɨmoru na wevo. ");
INSERT INTO tgo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Loi i giya ghanjimwaewo iŋa, “Hu ghambɨ rake na hu riyevanjara yambaneke na hu mbaroŋa. Hu mbaroŋaŋgiya borogi e njighɨko, maa thɨ yoyo na thetheghanɨko wolaghɨye thɨ loŋgaloŋga e thelauke vwatae.” ");
INSERT INTO tgo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Amba Loi iŋa, “Wo hu vandeŋe! Kaero ya vatomwe e ghemi the nana i mbuthu na ghanɨŋga na manjemanje thɨ rau na e uneunenji e yambaneke ghemi kaiwami na lemi ghamba ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Thetheghan, maa, na thetheghan thɨ li e gharenji vwatae na the bigi e yawayawaliye kaero ya vatomwe weŋgiya nana na umbwaumbwa ndamwandamwanji na thiye ghanji.” Na i yomara ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Loi i thuweŋgiya bigibigiko wolaghɨye va i vakathaŋgiko na i warariŋa. I gou na kaero i ghɨviyava, na iyako mbaŋa mbaŋawonaniye. ");
INSERT INTO tgo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","E mbaŋako iyako Loi kaero i vakathavaoŋgiya buruburu na yambane na bigibigiko wolaghɨye e tɨnenjiko. ");
INSERT INTO tgo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Mbaŋa mbaŋapirɨniye e tɨne Loi i towowe kaiwae kaero i vakathavaoŋgi vara le vakathako wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Iya kaiwae Loi i vabobomaŋa mbaŋa mbaŋapirɨniye kaiwae e mbaŋako iyako tɨne va i towowe ele kaiwoko iyava ele vakathako va i vakathaŋgiko. ");
INSERT INTO tgo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Buruburu na yambaneke ghanjivakavakatha va ŋgoreiye vara iyako. Mbaŋaniye Giya Loi i vakatha yambane na buruburu ");
INSERT INTO tgo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ma vamba nana thɨ mbuthu na tembe ŋgoreiyeva karakarava, kaiwae Giya Loi ma vamba i vakatha uye na i vatitiya thelauko, na mava lolo ina e yambaneke na i kaiwo e thelauko; ");
INSERT INTO tgo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ko iyemaeŋge thelauko ghewo va i voroma e thelauko tɨne na i vatitiya thelauko vwatae. ");
INSERT INTO tgo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Amba Giya Loi i mbana thelauko na i monje lolo ghɨmoruwe, ko amba i worawa ghae e mbothiye na i valawe ghandewendewekowe na e mbaŋako iyako loloma kaero e yawayawaliye. ");
INSERT INTO tgo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Giya Loi vama i vakatharawa uma regha e boimako, idae Iden, na i vaŋgurawa loloma me vakathama e umako tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Amba Giya Loi i vakatha umbwaumbwake wolaghɨye na thɨ mbuthuwe, vavana ghanjithuwathuwa i thovuye na vavana uneunenji i thovuye ghanɨŋga kaiwae. E umako tɨne yamoe moli, umbwaumbwa umboiwo thɨ ndeghathɨwe. Umbwara uneune i giya yawalɨ memeghabananiye na umbwara uneune i giya ghareghare thovuye na tharɨ kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Walaghɨta dura va i voru vaghɨliya na i vanjighɨnjighɨya umako iyako. I voruraŋgi na i voru ghavwala na duvarɨ. ");
INSERT INTO tgo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Dura idae Pison, i vorureŋa na i ru vanautuma idae Havila. Gol inawe. ");
INSERT INTO tgo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gol e valɨvaŋgako iyako i thovuye na tembe ŋgoreiyeva bigi regha ŋgoreiye meŋghwi na butiye thovuye moli na varɨvarɨ ghanjiyamoyamo thovuye moli na modanji laghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mbwako ghavwalarava idae Gihon, i voru na i ru e vanautuma idae Kus. ");
INSERT INTO tgo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Walaghɨtake ghavwalatonji idae Taigris; i voru reŋa e vanautuma Asiriya valɨvaŋga i vorovoro. Na mbwako ghavwalavarɨniye idae Yupreitis. ");
INSERT INTO tgo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Amba Giya Loi i vaŋgwa amalama na i vaŋgurawe e uma Iden, i kaiwoŋa na i njimbukiki. ");
INSERT INTO tgo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Giya Loi i dage weya amalama iŋa, “Umbwaumbwake wolaghɨye e umake tɨne i vatomwe, uneunenji mbema u ghanɨŋga eŋge; ");
INSERT INTO tgo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ko iyemaeŋge umbwana vara iya i giya ghareghare budakaiya i thovuye na budakaiya i tharɨ, ne u ndeghana une, kaiwae thembaŋa ne u ghan, e mbaŋako vara iyako ne u mare.” ");
INSERT INTO tgo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Amba Giya Loi iŋa, “Maa i thovuye amalake mbe ghamberegha eŋge i yaku. Mbema ya vakatha eŋge gharathalavu thovuye regha valɨkaiwae i thalavu.” ");
INSERT INTO tgo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Giya Loi kaero va i mbana thelau na i monjeŋgiya thetheghanɨke wolaghɨye na maa thɨ yoyo. I bigimenaŋgi weya amalama na mbala i rena idaidanji. The ida amalako va i ren iyako thetheghan na maako idaidanji. ");
INSERT INTO tgo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Amalako kaero i rena thetheghanɨke wolaghɨye na maa idaidanji na tembe ŋgoreiyeva mbwanjam wolaghɨye, ko iyemaeŋge maa regha mun ina e tɨnenjiko gharathalavu thovuye inawe. ");
INSERT INTO tgo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Amba Giya Loi i vakatha amalako i ghenetena nuwa na e mbaŋako iyako i woraŋgiya amalako ŋgaŋgaiye regha na kaero i monjenjoghava e mbunɨmaniyeko. ");
INSERT INTO tgo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Amba i monje wevo amalama e ŋgaŋgaiye iya me woraŋgiyama na i vaŋgumena weya amalama. ");
INSERT INTO tgo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Amalama iŋa, “Ko ambama ghino woyamoyamo vara iyake Wokɨniye i mena e wakɨniŋgu na mbunɨmaniye i mena e mbunɨmaniŋgu. Ya rena idae ‘wevo’ kaiwae ŋginauye na mbunɨmaniye i mena weya ghɨmoru.” ");
INSERT INTO tgo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Iya kaiwae ghɨmoru ne i iteteŋgiya tɨnae na ramae na i tubwe weiye levo na thɨ tabo na mbunɨma regha. ");
INSERT INTO tgo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mbe thenjighewoko vara thɨ bukabuka, ko iyemaeŋge mava thɨ vemonjina wanaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Thetheghanɨko wolaghɨye e tɨnenji, iya Giya Loi va i vakathaŋgiko, mwata iye i thimba moli e kwan. I dage weya wevoma iŋa, “Emunjoru Loi mendava i dageten e ghemi na mane hu ndeghan mun umbwa regha une e umake iyake tɨne?” ");
INSERT INTO tgo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Wevoma i gonjoghawe iŋa, “Mbema wo ghanɨŋga eŋge vara iya umbwaumbwake wolaghɨye e umake tɨne uneunenji, ");
INSERT INTO tgo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ko iyemaeŋge Loi mendava iŋa, ‘Umbwako iya vara i ndeghathɨ yamoeko moli ne hu ndeghana une, o ne hu ndevɨghathɨ; ne iwaeŋge hu mare.’” ");
INSERT INTO tgo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mwatama i dagewe iŋa, “Ma emunjoru ŋgoreiye; maane hu mare. ");
INSERT INTO tgo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kaiwae Loi i ghareghare, mbaŋa ne hu ghana umbwako iyako une, marami ne i bowoutu na ne ŋgoramiya amalaghɨniye, ne hu ghareghare thovuye na tharɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mbaŋa wevoma i thuwe umbwako ghayamoyamo i thovuye moli na maraeko i loghelogheŋa uneko na valɨkaiwae ghanɨŋga na tembe i wova nuwae na i renuwaŋa nuwaiya i thimba, iya kaiwae i mbana vavana na i ghan. Te vambe i giyava vavana weya le ghɨmoru na i ghan. ");
INSERT INTO tgo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Mbaŋa kaero thɨ ghan mbe thenjighewoko vara maranji i manjamanjala na thɨ vemonjina wanaŋgi. Thɨ ŋgiya umbwa idae fig ndamwandamwa na thɨ yabo riwanjikowe. ");
INSERT INTO tgo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Vama i ghanjighɨye amba amalama na levo thɨ loŋwa Giya Loi i loŋga na laiye e umako tɨne, iwaeŋge thɨ kubaro e umbwaumbwako rɨgherɨghenji e umako tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ko amba Giya Loi i kula weya amalama, “Aŋga inan?” ");
INSERT INTO tgo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","I gonjoghawe iŋa, “Ma loŋwa lain e umana tɨne na ya mararuŋge, kaiwae ya bukabuka.” ");
INSERT INTO tgo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Loi i dagewe iŋa, “Thela me dage e ghen na iŋa u bukabuka. Kaero mo ghana umbwama mendava ya dagetenɨma e ghen une?” ");
INSERT INTO tgo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Amalama i gonjoghawe iŋa, “Wevoma mendava u vaŋgugiyama e ghino, me giya umbwako une vavana e ghino na ya ghan.” ");
INSERT INTO tgo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Amba Giya Loi i dage weya wevoma iŋa, “Buda kaiwae mo vakatha iyake?” Wevoma i gonjoghawe iŋa, “Mwata me utuyaroŋgo na ya ghan.” ");
INSERT INTO tgo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Amba Giya Loi i dage weya mwatama iŋa, “Kaiwae mo vakatha kamwathɨke iyake, vuyowae tembene i njava e ghen: Mbwaeva na mbwanjamɨke wolaghɨye e tɨnenji mbe ghanɨmbereghana eŋge vara ne u vaidiya vuyowoke iyake. E mbaŋake vara iyake na i ghaoko, ne u li e gharen vwata na ne u ghana thelau vughauye yawalin ghambaŋa i ri rogha. ");
INSERT INTO tgo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ne ya vakathaŋge wein wevona na hu veroghereiye wanaŋga, na tembe ŋgoreiyeva orumburumbu na elaghɨniye orumburumbuye weŋgi mbaŋa muyaiko. Nevole ghen u gharɨ orumburumbuye regha gheghe daŋavwa, ko iyemaeŋge iye i tagaviya umbalɨn.” ");
INSERT INTO tgo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Weya wevoma, i dagewe iŋa, “Ne ya valaghɨyeŋa vɨrɨ e ghen mbaŋa ne u ghamba ŋgama, na ne u ghataŋa vɨrɨ mbaŋa ne u ghambɨŋgiya gamagai. Nuwanɨna mbene inawe vara len ghɨmoru ko iyemaeŋge iye ne i mbaroŋaŋge.” ");
INSERT INTO tgo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","I dage weya Adam iŋa, “Kaiwae mendava u loŋweghathɨgha len wevona ghalɨŋae, na u ghana umbwako une iya va ya dagetenɨko e ghen, va yaŋama, ‘Ne u ndeghana uneko.’ Ne ya gura thelauke na le rauko i vuyowo kaiwae len vakathako kaiwae. E mbaŋake iyake na i ghaoko tembene u rovurɨghegheva e kaiwo mbaŋake wolaghɨye ko amba hu ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","E thelauke nana na nana e lenji kinkin ne thɨ mbuthu, na ne u ghanɨŋgiya umbwathaŋarɨke uneunenji. ");
INSERT INTO tgo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ghairo mbene i dobu eto i dobu e ghawo amba ne u ghan valawe, gheghada tene u njoghava e thelau, kaiwae iyako va hu menawe na tembene hu njogha na hu tabo na thelauva.” ");
INSERT INTO tgo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam i rena levo idae Ive, kaiwae elaghɨniye gharɨgharɨke wolaghɨye e yawayawalinji tɨnanji. ");
INSERT INTO tgo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Amba Giya Loi i vakatha kwama thetheghan e njimwanji na i vanjimboŋgiya Adam na levowe. ");
INSERT INTO tgo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Amba Giya Loi mbe ghambereghaeŋge i renuwaŋa na iŋa, “Kaero ya ghareghare, mbaŋake thovuye na tharɨ ghaghareghare kaero inawe ŋgoreiya ghinda. Ne iwaeŋge i vilawalawa na tembe ve wova umbwako iya yawalɨko rɨghe une na i ghan, ko amba i roghabana na maa i mare.” ");
INSERT INTO tgo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Iya kaiwae Giya Loi i variyeraŋgiya e uma Iden tɨne, i raŋgi eto na i kaiwoŋa thelauko iyava i rikowe. ");
INSERT INTO tgo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mbaŋa i vakatha iyako na e ghereiye, amba Giya Loi i worawa buruburu nyaoniye regha idae “serupim” na ghalithɨ maraeko i ravalaŋa na i vilama vaghɨliya valɨvaŋgako iyako na i njimbukikiya umbwako iya yawalɨko rɨghe. ");
INSERT INTO tgo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam i ghenethaiya levo Ive, kaero i marabo na i ghamba nariye. Ive iŋa, “Giya Loi le thalavu e ghino na ya vaidiya ŋgama ghɨmoru.” Iya kaiwae i rena idae Kein. ");
INSERT INTO tgo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Muyai amba te i ghambɨva Kein ghaghae, idae Eibol. Eibol iye va i mbanɨŋgiya sip na Kein i kaiwo e uma. ");
INSERT INTO tgo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mbaŋa umako i tara, Kein i mbana umako une vavana na i bigimena na le mwaewo weya Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ko iyemaeŋge Eibol i mbana le sip virɨviva vavana na ghanjitabo vondɨvondɨ, na i vakatha le mwaewo. Giya Loi i worawa Eibol na le mwaewo e ghamwae, ");
INSERT INTO tgo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ko Kein eŋge na le mwaewo mava i warari kaiwae. Iya kaiwae Kein ghare i gaithɨ laghɨye moli na ghamwae i undu. ");
INSERT INTO tgo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Amba Giya Loi i dagewe, iŋa, “Buda kaiwae gharen i gaithɨ? Buda kaiwae nuwan i tharɨ? ");
INSERT INTO tgo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Thoŋgo u vakatha kamwathɨ thovuye uŋa eŋge maane ya wovatha len vakathana? Ko thoŋgo ma u vakatha kamwathɨ thovuye tharɨ maiya vara evasiwanɨna; nuwaiya i ru e ghen, ko mbe ghen vara u njimbukikiŋge.” ");
INSERT INTO tgo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Amba Kein i dage weya ghaghae Eibol iŋa, “Wou, ra wa e njamnjam bwaga.” Mbaŋa inanji gheko, Kein i unɨgha ghaghae Eibol na i tagavamare. ");
INSERT INTO tgo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Amba Giya Loi i vaito Kein iŋa, “Ghagha Eibol aŋga inae?” I gonjoghawe iŋa, “Maa ya ghareghare. Ghino maa Eibol gharanjimbunjimbu.” ");
INSERT INTO tgo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Giya Loi i dagewe iŋa, “Mo vakatha budakai? Wo u vandeŋeŋgo! Ghagha Eibol madɨbae i yawaru e thelauko tɨne na ghalɨŋae kaero i voro e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","E mbaŋake iyake vuyowo i vana e vwatan, na maa tene u kaiwova e thelauna iyana, kaiwae kaero i muna ghaghana madɨbae, na raŋaeŋgeva me yoghatho na i wovoŋgu mbaŋa mo unɨghɨ. Ne iwaeŋge ya vambeleyathuŋge e thivathivake iyake na ya vakatha ghanji ghakaiwo i vuyowo moli. ");
INSERT INTO tgo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mbaŋa ne u kaiwo e thelauna, maane ghanɨŋga i mbuthuwe. Ghen ma tene e ghambaghambanɨva. Yambaneke laghɨye gharandeloŋga ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kein i dage weya Giya Loi iŋa, “Vuyowoke iya u lithɨke e ghino i laghɨye moli na i kivwalaŋgo, maa valɨkaiwaŋgu ne ya ghataŋaghathɨ. ");
INSERT INTO tgo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Noroke kaero u variyeyathuŋgo na ma valɨkaiwangu ya thuweŋge. Na tembe ŋgoreiyeva thelauke laghɨye gharaloŋgatakwe, na thela ne i loŋgavaidiŋgo ne i tagavamareŋgo.” ");
INSERT INTO tgo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ko iyemaeŋge Giya Loi i gonjoghawe iŋa, “Ma valɨkaiwae. Thoŋgo lolo regha i tagavamareŋge ne modae i laghɨye kivwala mbaŋapirɨ na e vwataeova.” Amba Giya Loi i vakatha nono regha Kein e riwae na i giya vanuwovɨrɨ weŋgiya thavala ne thɨ vaidi na thava thɨ unɨghɨ. ");
INSERT INTO tgo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kein i roiteta Giya Loi, na i wa ve yaku e valɨvaŋga regha idae Nod, Iden valɨvaŋga i vorovoro. ");
INSERT INTO tgo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Mbaŋa gheviyeva e ghereiye Kein i ghe na levo i marabo, i ghamba narinji regha idae Inok. Amba i vatada ghemba laghɨye regha na nariyeko le ghaida. ");
INSERT INTO tgo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inok i ghambɨ weiye levo na narinji idae Irad, na Irad nariye Mehujael, Mehujael nariye Metuisela, na Metuisela nariye Lemeki. ");
INSERT INTO tgo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemeki le ovo theunyiwo, eunda idae Ada na eunda idae Jila. ");
INSERT INTO tgo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada nariye Jabal. ");
INSERT INTO tgo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Amalaghɨniye va i yakukai vara e ŋgolo thɨ vakatha e thetheghan njimwanji na thɨ njimbukikiŋgiya sip. Ghaghae nasiyeniye va idae Jubol, iye va i mwadiwokai vara hap na igo. ");
INSERT INTO tgo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Jila va i ghambɨva ŋgama ghɨmoru idae, Tubal-Kein, iye va i ŋambuŋambu brons na aiyan na i vakathaŋgiya kaiwo bigibiginiye. Tubal-Kein louye Naama. ");
INSERT INTO tgo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemeki i dage weŋgiya le ovo iŋa, “Ada na Jila, wo hu vandeŋeŋgo; Lemeki le ovo wo hu vandeŋe lo utuke. Kaero ma tagavamare amala regha kaiwae me vawonamboyaoŋa riwaŋgu, giya theghathegha kaiwae me vawonamboyoŋaŋgo. Thoŋgo Loi i lithɨ weya Kein gharatagavamare mbaŋapirɨ, ");
INSERT INTO tgo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","thoŋgo lolo regha i munje ne i tagavamareŋgo, ne ya lithɨwe mbaŋaepirɨ na mbaŋapirɨ na e vwataeva.” ");
INSERT INTO tgo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam mbowo i ghenava weiye levo, i marabo na i ghamba ŋgama ghɨmoru na Ive i rena idae Set, iŋa, “Loi i vatomwe e ghino na mbowo ya vaidiva ŋgama regha Eibol ghathɨghɨthɨghɨ, kaiwae Kein kaero va i tagavamare.” ");
INSERT INTO tgo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set vambe e nanariyeva, na va i rena idae Inos. Va e mbaŋako iyako na i ghaoko, gharɨgharɨ thɨ kururukai vara weya Giya Loi thɨŋa “Wo tarawe e ghen, Yawe.” ");
INSERT INTO tgo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iyake Adam orumburumbuye ghanjiriuriu. Mbaŋa Loi i vakatha lolo, va i vakatha tembe ŋgoreiyeva amalaghɨniyeko ghayamoyamo. ");
INSERT INTO tgo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I vakathaŋgi, ghɨmoru na wevo, i mwaewo weŋgi na i giya idanji “Gharɨgharɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Mbaŋa Adam ghatheghathegha vama i wo hothaŋarɨ na hweto (130), na mbowo thɨ ghambɨva narinji regha. Ghayamoyamo mbe ŋgora vara amalaghɨniye, na i rena idae Set. ");
INSERT INTO tgo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Mbaŋa Set i virɨ na e ghereiye, Adam yawaliye molao, i yaku theghathegha hoseriyewa (800). E lughawoghawoko iyako vambe thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam va i yaku vara theghathegha hoseriyesiwo na hweto (930), ko amba i mare eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Mbaŋa Set ghatheghathegha vama i wo hothaŋarɨ na umbolima (105) amba thɨ ghamba ŋgama ghɨmoru, idae Inos. ");
INSERT INTO tgo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Mbaŋa Inos i virɨ na e ghereiye, Set yawaliye vambe molaova, i yaku theghathegha hoseriyewa na umbopirɨ (807). E lughawoghawoko iyako vambe thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set va i yaku vara theghathegha hoseriyesiwo na hoyaworo na umboiwo (912), ko amba i mare eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mbaŋa Inos ghatheghathegha vama i wo hwesiwo (90) amba thɨ ghamba ŋgama ghɨmoru, idae Kenan. ");
INSERT INTO tgo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Mbaŋa Kenan i virɨ na e ghereiye, Inos yawaliye vambe molaova, i yaku theghathegha hoseriyewa na hoyaworo na umbolima (815). E lughawoghawoko iyako vambe thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Inos va i yaku vara theghathegha hoseriyesiwo na umbolima (905) ko amba i mare eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mbaŋa Kenan ghatheghathegha vama i wo hwepirɨ (70) amba thɨ ghamba ŋgama ghɨmoru, idae Mahalalel. ");
INSERT INTO tgo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mbaŋa Mahalalel i virɨ na e ghereiye, Kenan yawaliye vambe molaova, i yaku theghathegha hweseriyewa na hwevarɨ (840). E lughawoghawoko iyako vambe thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan va i yaku vara theghathegha hweseriyesiwo na hoyaworo (910) ko amba i mare eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mbaŋa Mahalalel ghatheghathegha vama i wo hwewona na umbolima (65) amba thɨ ghamba ŋgama ghɨmoru, idae Jered. ");
INSERT INTO tgo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mbaŋa Jered i virɨ na e ghereiye, Mahalalel yawaliye vambe molaova, i yaku theghathegha hweseriyewa na hweto (830). E lughawoghawoko iyako vambe thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel va i yaku vara theghathegha hweseriyewa na hwesiwo na umbolima (895), ko amba i mare eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mbaŋa Jered ghatheghathegha vama i wo hothaŋarɨ na hwewona na umboiwo (162) amba thɨ ghamba ŋgama ghɨmoru, idae Inok. ");
INSERT INTO tgo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Mbaŋa Inok i virɨ na e ghereiye, Jered yawaliye vambe molaova, i yaku theghathegha hweseriyewa (800). E lughawoghawoko iyako vambe thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jered va i yaku vara theghathegha hweseriyesiwo na hwewona na umboiwo (962), ko amba i mare eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mbaŋa Inok ghatheghathegha vama i wo hwewona na umbolima (65) ambama thɨ ghamba ŋgama ghɨmoru, idae Metuisela. ");
INSERT INTO tgo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mbaŋa Metuisela i virɨ na e ghereiye Inok i yaku na ghamwae vanaora weiye Loi theghathegha hweseriyeto (300) e tɨne na i ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Va i yaku na yawaliye le molamolao ŋgoreiya theghathegha hweseriyeto hwewona na umbolima (365). ");
INSERT INTO tgo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inok i yaku na ghamwae vanaora weiye Loi ghaghadɨ vambema i roghawe eŋge kaiwae Loi vama i vaŋgu. ");
INSERT INTO tgo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mbaŋa Metuisela ghatheghathegha vama i wo hothaŋarɨ hwewa na umbopirɨ (187) ambama thɨ ghamba ŋgama ghɨmoru, idae Lemeki. ");
INSERT INTO tgo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mbaŋa Lemeki i virɨ na e ghereiye Metuisela i yaku mbaŋa molao, theghathegha hweseriyepirɨ hwewa na umboiwo (782). E lughawoghawoko iyako vambe thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metuisela va i yaku vara theghathegha hweseriyesiwo hwewona na umbosiwo (969), ko amba i mare eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mbaŋa Lemeki ghatheghathegha vama i wo hothaŋarɨ hwewa na umboiwo (182) thɨ ghamba ŋgama ghɨmoru, ");
INSERT INTO tgo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","na iŋa, “E thelauke vara iya Giya Loi va i gurake, ŋgamake iyake ne i vatowoŋainda e vuyowoke tɨne,” iya kaiwae i rena idae Nowa. ");
INSERT INTO tgo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lemeki vambowo i yakuva theghathegha hweseriyelima hwesiwo na umbolima (595). E lughawoghawo iyako vambe thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemeki va i yaku vara theghathegha hweseriyepirɨ hwepirɨ na umbopirɨ (777), ko amba i mare eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowa vama ghatheghathegha hoseriyelima (500) iko, ko amba thɨ ghambɨŋgi le ŋgaŋga thenjigheto, mbe ghɨmoghɨmoruŋgi eŋge. Idaidanji Sem, Ham na Japet. ");
INSERT INTO tgo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Mbaŋa gharɨgharɨ kaero lemoyo e yambaneke na thɨ yala, thɨ ghambɨŋgiya wanakau lemoyo, ");
INSERT INTO tgo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","buruburu nyaoniyeŋgi thɨ thuwe ghanjiyamoyamoko thɨ thovuye moli, thɨ numweŋgi na thɨ tuthigiya vavana na thɨ vaŋguŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Amba Giya Loi iŋa, “Yawaliŋguke iyava ya valaweke weŋgi mane ya vatomwe weŋgi na lenji yaku molao kaiwae thiye mbunɨma na madibe. E mbaŋake iyake na i ghaoko yawalinji le molamolao mane i kivwala theghathegha hothaŋarɨ na hoiwo (120).” ");
INSERT INTO tgo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","E mbaŋaŋgiko thiyako Nepilim gharɨgharɨniye (ŋgoreiye Tuu na Varɨ) va inanji e yambaneke. Yambaneke wanakauniye vambe thɨ ghambɨva weinjiyaŋgiya buruburu nyaoniyeŋgi na lenji gamagai thɨ tabo na ghɨmbaghɨmbalaŋgi, thiye Nepilim gharɨgharɨniye. Thiye va thɨ vurɨgheghe na gaithɨ mara mbouyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mbaŋa Giya Loi i thuwe gharɨgharɨ lenji vakatha na lenji renuwaŋa e yambaneke mbema tharɨ eŋge vara mbaŋake wolaghɨye, ");
INSERT INTO tgo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","i vakatha nuwae i tharɨ na i renuwaŋa njogha kaiwae va i vakathaŋgi na i bigiraweŋgi e yambaneke. ");
INSERT INTO tgo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Iya kaiwae Giya Loi iŋa, “Mbemane ya mukuwoŋgi vara gharɨgharɨke wolaghɨye iyava ya vakatha na ya bigiraweŋgi e yambaneke na tembe ŋgoreiyeva thetheghan na maaŋgi. Ne ya vakatha iyake kaiwae ya renuwaŋa njogha va ya vakathaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ko iyemaeŋge Giya Loi va i warari Nowa ghathanavu kaiwae na i worawe e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Riuriuke iyake Nowa utuutuniye. Nowa le ŋgaŋga ghɨmoghɨmoru mbe thenjigheto eŋge, Sem, Ham na Jepet. Nowa maava i vakatha mun tharɨ na iye maa e ghawonjowe mun weya lolo regha. Va i yaku na ghamwae vanaora weiye Loi. ");
INSERT INTO tgo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ko iyemaeŋge gharɨgharɨ lenji vakatha maava i thovuye Loi e marae. Vambema ghanjikaiwo eŋge gaithɨ na tharɨ ghavakatha. ");
INSERT INTO tgo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Loi i thuwe yambaneke mbema tharɨ eŋge na gharɨgharɨ yawalinji na lenji vakatha mbe ŋgoreiye eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Iya kaiwae Loi i dage weya Nowa iŋa, “Ne ya vakowana yambaneke laghɨye. Ne ya mukuwo gharɨgharɨniye na matemate, kaiwae gharɨgharɨ ghanjithanavu na lenji vakatha raraitharɨ i riyevanjara. Emunjoru ne ya vakowana moli. ");
INSERT INTO tgo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Iyake kaiwae u vatada waŋga regha kaiwan. U kanjiya umbwa thovuye na u vatadɨwe. U vakatha woluwoluŋgi e tɨne na u ghabadɨ e tɨne na eto. ");
INSERT INTO tgo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ne u vatad na ŋgoreiya iyake: Waŋgako le molamolao 150 mita, le magamagaga 25 mita na le yavoyavoro 15 mita. ");
INSERT INTO tgo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","U vakatha waŋgako vwatae ghaŋgolo le didivoro hap mita. U vakatha mbwaŋaŋgila e ghadidiye na u vakatha yavweto, bode yamoe na yavoro. ");
INSERT INTO tgo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Wo u vandeŋe! Ne ya vakatha uye laghɨye i nja na yambane i thotho na i gaboŋgiya bigibigike wolaghɨye e yawayawalinji. Bigibigike wolaghɨye e yambane ne thiya marevao. ");
INSERT INTO tgo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ko ghino ne ya vakatha dagerawe regha weiŋgu ghen. Ghen na len wevo, le ŋgaŋga na lenji ovo ne weinaŋgi hu rakatha e waŋgana. ");
INSERT INTO tgo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ne u bigi ruwoŋgi e waŋgake thetheghanɨke wolaghɨye, theghewo iya, ghɨmoru na wevo; mbala thɨ yaku na mbe e yawayawalinji. ");
INSERT INTO tgo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Maaŋgike wolaghɨye tomethi na tomethi, na thetheghanɨke wolaghɨye tomethi na tomethi, na thiye thɨ loŋgaloŋga na thɨ li e thelau vwatae tomethi na tomethi, theghewo iya ne thɨ rakamena e ghen na weinaŋgi e waŋgana e yawayawalinji. ");
INSERT INTO tgo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tembe ŋgoreiyeva u mbana ghanɨŋga thaŋarɨke, ghen na thiye kaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowa i vakathaŋgiya bigibigiko wolaghɨye ŋgoreiya Loi me dagekowe. ");
INSERT INTO tgo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Giya Loi i dage weya Nowa iŋa, “U tha e waŋga, ghen, len wevo na len ŋgaŋga na lenji ovo, kaiwae kaero ya thuwe ghen vara ghanɨmbereghana u thovuye moli thake iyake e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","U mbanɨŋgiya thetheghan wevo na ghɨmoru thenjighepirɨ iya, iya va ya dage weŋga ne ya wovatha vowo kaiwae. U mbanɨŋgiya thetheghan yamoyamo wevo na ghɨmoru, iya maa valɨkaiwae vowo, kaiwae thɨ mbighɨ. ");
INSERT INTO tgo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Na tembe ŋgoreiyeva maaŋgi, wevo na ghɨmoru thenjighepirɨ iya. U vakatha ŋgoreiyake mbala thetheghan na maa yamoyamo regha na regha mbe e yawayawalinji na tembe thɨ rothirakava e yambaneke. ");
INSERT INTO tgo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mbaŋa mbaŋapirɨ e tɨne ne ya variye uye na i nja e yambaneke. Ne i uyevoreŋa mbaŋa mbaŋaevarɨ na gougouyevarɨ e tɨnenji. Iyake kaiwae lo renuwaŋa ŋgoreiye bigibigike wolaghɨye va ya vakathaŋgi ne ya mukuwoŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nowa i vakatha ŋgoreiya Giya Loi i utugiyakowe. ");
INSERT INTO tgo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowa ghatheghathegha vama i wo hweseriyewona (600) ambama iya yambaneke i thotho eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nowa na levo na le ŋgaŋga na lenji ovo thɨ tha e waŋgako na mbala maa thothoko i gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Thetheghanɨke wolaghɨye, thɨ mbighɨ na maa thɨ mbighɨ na tomethi yamoyamo, wevo na ghɨmoru, ");
INSERT INTO tgo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","thɨ rakatha e waŋgama weinji Nowa ŋgoreiya Loi va i dagemawe. ");
INSERT INTO tgo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mbaŋa theghepirɨ e ghereiye thothoma kaero i voro. ");
INSERT INTO tgo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mbaŋa Nowa ghatheghathegha hweseriyewona, manjala umboiwoniye ghambaŋa theyaworo na theghepirɨninji e tɨne, mbwake wolaghɨye rɨghenji e yambaneke raberabe thiya mavuvao na mbwa e buruburuko tembe ŋgoreiyeva, ");
INSERT INTO tgo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ko amba uye i nja e yambaneke mbaŋa mbaŋaevarɨ na gougouyevarɨ. ");
INSERT INTO tgo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","E mbaŋako iyako vara e tɨne Nowa na levo weinjiyaŋgiya lenji ŋgaŋga, Sem, Ham na Jepet na lenji ovo thɨ tha e waŋgama. ");
INSERT INTO tgo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Weinjiyaŋgi thɨ rakatha e waŋgama thetheghanɨke wolaghɨye, tomethi mbe ghanjiyamoyamo, mbwanjam na mbwaeva, thetheghan thɨ loŋga e gharenji vwata na maaŋgi mbe ŋgoreiyeva na bigibigi e vinevineinji. ");
INSERT INTO tgo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Thetheghanɨko wolaghɨye e yawayawalinji thɨ rakamena weya Nowa, theghewo iya, wevo na ghɨmoru na thɨ rakatha e waŋgama. ");
INSERT INTO tgo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Thetheghanɨke wolaghɨye e yawayawalinji, ghɨmoru na wevo Nowa va i vamboromboroŋa ŋgoreiya Loi le renuwaŋa, Nowa i rereghamba vara. Mbaŋa i ru e waŋgama amba Giya i kighɨ eŋge waŋgako ghambwaŋaŋgila. ");
INSERT INTO tgo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Thothoma kaero i thothovoreŋa mbaŋa mbaŋaevarɨ na kaero i dumwaga na i vakatha waŋgako i ghagha. ");
INSERT INTO tgo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mbwako ma i vorovorowo eŋge na kaero i ghagha loloŋga e vwatae. ");
INSERT INTO tgo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mbwako kaero ina yavoro moli na kaero i wovululuŋgiya ououko wolaghɨye e yambaneke. ");
INSERT INTO tgo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Vambema le didivoro eŋge tembema i wo eŋge mita theghepirɨ le ghenevoro e ououko molamolao vwatanji. ");
INSERT INTO tgo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Bigibigike wolaghɨye e yawayawalinji na inanji e yambaneke thiya marevaoma, thetheghan na gharɨgharɨ. ");
INSERT INTO tgo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Bigibigike wolaghɨye iya thɨ liliya yawalinji e yambaneke thiya marevao. ");
INSERT INTO tgo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Bigibigike wolaghɨye e yawayawalinji Giya Loi va i mukuwoŋgi — gharɨgharɨ, thetheghan thɨ loŋgaloŋga e yambaneke vwatae na ma thɨ yoyo, thiya marevao. Vama Nowa eŋge na thavala weiyaŋgi e waŋgako tɨne vambe nanjiwe. ");
INSERT INTO tgo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Thothoko va i voro na ghaghadɨko va i wo vara mbaŋa mbaŋathaŋarɨ na mbaŋaelima (150). ");
INSERT INTO tgo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Loi vambe i renuwaŋakiki vara Nowa na thetheghanɨma wolaghɨye, mbwanjam na mbwaeva, weiyaŋgi e waŋgako tɨne. Iwaeŋge i variya ndewendewe na i rowa, ko ambama thothoma i njoghanjogha. ");
INSERT INTO tgo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Mbwake wolaghɨye rɨghenji e yambaneke raberabe na mbwa e buruburu kaero thɨ vorutowo na uye tembe i uye towova ");
INSERT INTO tgo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","na thothoko kaero i njoghanjogha na tembe i wova mbaŋa mbaŋathaŋarɨ na mbaŋaelima, ");
INSERT INTO tgo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","na manjala umbopirɨ ghe mbaŋa mbaŋayaworo na mbaŋapirɨ e tɨne, waŋgama i rovala e ouou idanji Ararat regha vwatae. ");
INSERT INTO tgo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mbwama mbema le didinja eŋge gheghada manjala hoyaworoninji e tɨne. Mbaŋa i viva e tɨne ouou vwatavwatanji kaero thɨ yomara. ");
INSERT INTO tgo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mbaŋa mbaŋaevarɨ e ghereiye Nowa i vugha dedele va i vakatha e waŋgako ");
INSERT INTO tgo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na i variye waluwo manda. Vambema i yoyololoŋga eŋge gheghada mbwama i ma moli. ");
INSERT INTO tgo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Amba i variye bunebune manda na i wa ve thuwe thoŋgo kaero thelauko i mwa. ");
INSERT INTO tgo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ko kaiwae mbwa vamba i wovululu vara thelauko, bunebunema maava i ndevaidi mun le ghamba yovaro, iya kaiwae vama i yonjoghava weya Nowa e waŋgako. I tagavamomoya nɨmae, i wo bunebunema na i woruwo e waŋgako tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nowa i roroghagha mbaŋa theghepirɨ e ghereiye na mbowo i variyeva bunebunema. ");
INSERT INTO tgo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mbaŋa kaero yeghɨyeghɨyenja bunebunema i livutha olivɨ ndamwae amba i tagavwara eŋge. Nowa i ghareghare thelau kaero i mwa. ");
INSERT INTO tgo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mbowo i roroghaghava mbaŋa theghepirɨ e ghereiye, na mbowo i variyeva bunebunema, ko iyemaeŋge ande vama i yonjogha weya Nowa. ");
INSERT INTO tgo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Mbaŋa Nowa ghatheghathegha kaero i wo hweseriyewona na umbwara (601), mbaŋaniye manjala i viva ghe mbaŋako regha Nowa i rakayathu waŋgako vwatae, na i thuwe i mena i ghawoko, na iŋa, “Ko thelau kaero i mwa iyako!” ");
INSERT INTO tgo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Va manjala umboiwoninji ghe mbaŋa theiwo na theghepirɨ e tɨne yambaneke vambema i mwavao vara. ");
INSERT INTO tgo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Amba Loi i dage weya Nowa iŋa, ");
INSERT INTO tgo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ko ghen na len wevo na le ŋgaŋga na lenji ovo, hu rakaraŋgima e waŋgana tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Hu bigi raŋgiyaŋgima thetheghanɨna wolaghɨye na maaŋgina, mbalama thɨ ghambɨva togha na thɨ riyevanjara yambaneke laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kaero Nowa i raŋgi e waŋgama weiyaŋgiya levo, le ŋgaŋga na lenji ovo. ");
INSERT INTO tgo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Thetheghaŋgima wolaghɨye na maaŋgima thɨ rakaraŋgi e waŋgama, thegheiwo iya na tomethi ghanjiyamoyamo. Thetheghanɨke wolaghɨye iya thɨ loŋgaloŋga e yambaneke vwatae na maake wolaghɨye — tomethi e lenji wabwi na e ghanjiyamoyamoko thɨ rakarakaraŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Amba Nowa i vatada ghamba vowo Giya Loi kaiwae. I mbanɨŋgiya thetheghan na maa regha iya e wabwi regha na regha e tɨnenji, iya lenji kururu i vatomwe thɨ thovuye, na i ŋambuŋgi e ghamba vowoko. ");
INSERT INTO tgo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Giya Loi i warari butiyeko thovuye kaiwae na e ghareko iŋa, “Maa tene mbaŋa reghava ya vakowana yambaneke lolo le tharɨ kaiwae. Ya ghareghare lolo le renuwaŋa i tharɨ ghe mbaŋa ŋgama na i ghaoko. Ma tene mbaŋa reghava ya vakowanaŋgiya thetheghan e yawayawalinji ŋgoreiya mendava ya vakathako. ");
INSERT INTO tgo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Yambaneke mbene ŋgora vara iyake na i ghaoko, mbaŋake wolaghɨye ne ghanɨŋga ghakabu ghe mbaŋa na ghalolo ghe mbaŋa, ne njighɨnjighɨ ghe mbaŋa na meme ghe mbaŋa, ne varae i ndeghathɨ na uye ghe mbaŋa na ghararaghɨye na gougou. Thiyake mane mbaŋa regha thɨko.” ");
INSERT INTO tgo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Loi i mwaewo weya Nowa na le ŋgaŋga na iŋa, “Hu ghambɨ na lemi ŋgaŋga na lenji ŋgaŋgaova na thɨ riyevanjara yambaneke. ");
INSERT INTO tgo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Thetheghanɨke wolaghɨye, maa thɨ yoyo na borogi e njighɨko, na bigibigike wolaghɨye thɨ lili e gharenji e thelau vwatae ne thɨ mararuŋga. Kaero ya bigirawe e nɨmami ghare. ");
INSERT INTO tgo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bigibigike wolaghɨye thɨ nyivɨnyivɨ na e yawayawalinji ya vatomwe weŋga ghami, na tembe ŋgoreiyeva umbwaumbwa na nana ndamwanji vwivwivu, kaero ya vatomwevao weŋga na ghami. ");
INSERT INTO tgo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Ko iyemaeŋge ne hu ndeghana thetheghan mbunɨmaniye thoŋgo madɨbae mbe ina e tɨneko kaiwae madibe i giya yawalɨ. ");
INSERT INTO tgo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kaiwae madibe iye i vakatha bigi regha e yawayawaliye. Iya kaiwae thoŋgo thela i vakowana lolo yawaliye na i mare, vuyowae loloko iyako wone i mare, na tembe ŋgoreiyeva thetheghan i vakowana lolo yawaliye na i mare, thetheghanɨko iyako wone i mare. ");
INSERT INTO tgo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kaiwae va ya vakatha lolo mbe ghino vara e ŋgaliŋgaliyaŋgu, iya kaiwae thoŋgo lolo i unɨgha lolo regha loloko iyako tembene thɨ unɨghɨva. ");
INSERT INTO tgo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ko Nowa ghen na len ŋgaŋga, hu ghambɨraka mbala orumburumbumi thɨ yala na thɨ riyevanjara yambaneke.” ");
INSERT INTO tgo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Loi i dage weŋgiya Nowa na le ŋgaŋga iŋa, ");
INSERT INTO tgo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“E mbaŋake iyake ya vakatha lo dagerawe e ghemi na weŋgiya orumburumbu mbaŋa muyaiko, ");
INSERT INTO tgo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na tembe ŋgoreiyeva bigibigike wolaghɨye e yawayawalinji, maake wolaghɨye na thetheghanɨke wolaghɨye — mbema bigibigike wolaghɨye vara va hu rakaraŋgi e waŋgana weinaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","E utuutuŋgike thiyake ya vakatha lo dagerawe e ghemi: Ya dagerawe maa tene mbaŋa reghava ya vakatha yambaneke i thotho na i vakowana yawal; maa tene mbaŋa reghava thotho i vakowana yambaneke.” ");
INSERT INTO tgo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Loi iŋa, “Dageraweke iya ma vakatha e ghandalughawoghawoke na thetheghanɨke wolaghɨye e yawayawalinji, tha na tha kaiwanji ghanono iyake, ");
INSERT INTO tgo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ya worawa bwawo e ŋgalɨlɨko na iyake i tabo na nono lo dageraweke ghino na yambaneke ghandalughawoghawo. ");
INSERT INTO tgo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mbaŋa ya vakatha uye ghaŋgalɨlɨ na thɨ yomara e buruburuko na bwawo i thowo, ");
INSERT INTO tgo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ne i vanuwovɨrɨŋgo lo dageraweko weiŋgu ghemi na thetheghanɨke wolaghɨye e yawayawalinji na tomethi wabwi e ghandalughawoghawoke. Maa tene mbaŋa reghava mbwa thɨ thotho na thɨ vakowana yawal. ");
INSERT INTO tgo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nevole the mbaŋa ya thuwe bwawoko i thowo e ŋgalɨlɨko, ne ya renuwaŋakikiya dageraweko iya memeghabananiyeko ghino na bigibigike wolaghɨye e yawayawalinji na tomethi wabwi e yambaneke e ghandalughawoghawo.” ");
INSERT INTO tgo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Loi i dage weya Nowa iŋa, “Dageraweke iya ma vakathake ghino na yawal e yambane ghandalughawoghawo iya ghanono iyake.” ");
INSERT INTO tgo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowa na le ŋgaŋga va i raŋgi weiyaŋgi e waŋgako tɨne thiyake: Sem, Ham na Jepet. (Ham nariya Keinan.) ");
INSERT INTO tgo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nowa le ŋgaŋgake thenjighetoke thiyake iya orumburumbunji vara gharɨgharɨke wolaghɨye e yambaneke. ");
INSERT INTO tgo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa, iye va rakakaiwo e uma, va i kabukai vara waen. ");
INSERT INTO tgo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mbaŋa i muna waen, i wovaghawa umbaliye, i bigiyatho ghakwama na i ghena bukabuka ele yoŋathowathowa tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mbaŋa Ham, Keinan ramae, i thuwe ramae i ghena bukabuka, i njogha eto na ve utugiya weŋgiya oghaghaema thenjighewoma. ");
INSERT INTO tgo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Amba Sem na Jepet thɨ liya kwama ghayaboyabo, thɨ lirawe e vwatanji, thɨ loŋgaloŋgaŋa ghereinji na thɨ ru, ko amba thɨ liyabo ramanji. Ghamwanji va i njogha e ghereinji na mbala thava thɨ thuwe i ghenebukako. ");
INSERT INTO tgo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Mbaŋa Nowa i thuweiru na le renuwaŋa i rumwaru, i loŋwevaidiya budakai nariye me wo vala uyewe le vakathawe, ");
INSERT INTO tgo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","iŋa, “Vuyowo ne i mena weya Keinan! Iye nevole Sem na Jepet lenji rakakaiwobwagaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mbowo i dageva, “Tarawa i voro weya Giya Loi, iye Sem le Loi! Keinan nevole Sem le rakakaiwobwagaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Loi nevole i vakatha Jepet na le ghamba mbaro i laghɨye! Orumburumbuye nevole thɨ yaku na regha weinji Sem le wabwi! Keinan iye nevole Jepet le rakakaiwobwagaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Thothoko e ghereiye Nowa mbowo i yakuva theghathegha hweseriyeto na hwelima (350). ");
INSERT INTO tgo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Gha theghathegha vama i wo hweseriyesiwo na hwelima (950) amba i mare. ");
INSERT INTO tgo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Riuriuke iyake Nowa le ŋgaŋga — Sem, Ham na Jepet orumburumbunji utuutuninji. Thenjighetoke iyake va thɨ ghambɨ na lenji ŋgamaŋgama thothoko e ghereiye. ");
INSERT INTO tgo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jepet le ŋgaŋgaŋgiya: Goma, Magog, Madai, Javan, Tubal, Mesek na Tiras. ");
INSERT INTO tgo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goma le ŋgaŋgaŋgiya: Asɨkenas, Ripat na Togama. ");
INSERT INTO tgo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan le ŋgaŋgaŋgiya: Ilaisa, Tasis, Kiti na Roda. ");
INSERT INTO tgo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Gharɨgharɨke thiyake orumburumbunji thiya yaku e njighɨ ghadidiye na e raurauŋgi Meditareiniyan Njighɨ ele valɨvaŋga. (Thiyake Jepet orumburumbuyeŋgi.) Tomethi u na u na vanautumaŋgi thiya yaku, na wabwi na wabwi mbe ghalɨŋanji. ");
INSERT INTO tgo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham le ŋgaŋgaŋgiya: Kus, Ijipt, Put, na Keinan. ");
INSERT INTO tgo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus le ŋgaŋgaŋgiya: Siba, Havila, Sabta, Rama na Sabteka. Rama le ŋgaŋgaŋgiya: Siba na Didan. ");
INSERT INTO tgo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ko Kus nariye regha Nimrod. Iye va lolo vurɨvurɨghegheniye na ragagaithɨ e yambaneke. ");
INSERT INTO tgo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kaiwae Loi va i thalavu, iye va rawowoidi laghɨye na thovuye moli, iya kaiwae gharɨgharɨ mbaŋa thɨ utuŋa lolo regha, thɨŋa, “Iye ŋgoreiya Nimrod rawowoidi laghɨye na thovuye moli iye Loi va i thalavu.” ");
INSERT INTO tgo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Va i viva le ghamba mbaro Babilon, Uruk, Akad na Kalne inanji Babiloniya e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","I ri e valɨvaŋgako iyako amba i wa Asiriya na ve vatadɨŋgiya ghembaghembake thiyake: Ninive, Rehobot Irɨ, Kala ");
INSERT INTO tgo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Risen, ina Ninive na Kala e ghanjilughawoghawo, iye ghemba laghɨye regha. ");
INSERT INTO tgo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ijipt orumburumbuye iya gharɨgharɨniye thiya yaku e ghembaghembake thiyake: Lud, Anam, Lehab, Nepɨtu, ");
INSERT INTO tgo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patɨrus, Kaslu na Kurit. Pilistiya gharɨgharɨniye thiye thɨ rimbun Kaslu. ");
INSERT INTO tgo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Keinan nariye virɨ viva Saidon na Hiti i virɨ reghamba. ");
INSERT INTO tgo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Keinan vambe orumburumbuyeŋgiva gharɨgharɨŋgike thiyake: Jebusi, Amori, Gigasi, ");
INSERT INTO tgo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivi, Aki, Saini, ");
INSERT INTO tgo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Aved, Jemari na Hamati. Va muyai amba Keinan ghe u thɨ meila ");
INSERT INTO tgo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","na lenji valɨvaŋga, i ri Saidon ve wo Gera ele valɨvaŋga na ve wo Gaja, e boimako i wa Sodom, Gomora, Adma na Seboyim na gheghad Lasa. ");
INSERT INTO tgo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Gharɨgharɨŋgike thiyake Ham orumburumbuyeŋgi. Uuŋgike thiyeke vambe e lenji ghambayaku na mbe tomethi ghalɨŋanji. ");
INSERT INTO tgo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem iye ghaghae laghɨyeninji Jepet. Sem orumburumbuyeŋgiya Eba gharɨgharɨniyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem le ŋgaŋgaŋgiya: Ilam, Asur, Apaksad, Lud na Aram. ");
INSERT INTO tgo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram orumburumbuyeŋgiya: Us, Hul, Gethe na Mes. ");
INSERT INTO tgo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apaksad nariya Sila na Sila nariya Iba. ");
INSERT INTO tgo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Iba le ŋgamaŋgama thenjighewo: Regha idae Peleg, kaiwae amalaghɨniye va ghe mbaŋa e tɨne yambaneke gharɨgharɨniye thɨ meghaghathɨ na thɨ yala; na nariye theghewoniye idae Joktan. ");
INSERT INTO tgo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan orumburumbuyeŋgiya: Almoded, Selep, Hesamavet, Jera, ");
INSERT INTO tgo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO tgo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Siba, ");
INSERT INTO tgo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opi, Havila, na Jobab. Thiyake thɨ rimbun weya Joktan. ");
INSERT INTO tgo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Gharɨgharɨŋgike thiyake va vethɨ yayaku Mesa na Sepa e ghanjilughawoghawo, inanji e boimako na valɨvaŋgako iyako mbe bobokulu eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Gharɨgharɨke thiyake Sem orumburumbuyeŋgi. Thɨ yaku tomethi wabwi na u, na tomethi mbe lenji valɨvaŋga na ghalɨŋanji. ");
INSERT INTO tgo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Gharɨgharɨŋgike vara thiyake Nowa mbe orumburumbuyeŋgi eŋge, tomethi mbe ghambanji, tomethi mbe lenji wabwi na uu. Thothoko va e ghereiye vanautumake wolaghɨye e yambaneke va thɨ rimbun weŋgi vara Nowa le ŋgaŋga. ");
INSERT INTO tgo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Va e mbaŋako iyako yambaneke laghɨye ghalɨghalɨŋaniye va regha na lenji utuutu ghe loŋwaloŋwa regha. ");
INSERT INTO tgo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mbaŋa thɨ raka na i vorowoko vethɨ vaidiya malamo regha Babiloniya e tɨne na thɨ vatada ghambanjiwe. ");
INSERT INTO tgo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Kaero thɨ vedage weŋgi thɨŋa, “Wo hu rakamena! Ra vakathaŋgiya brik na ra ŋambuŋgi na thɨ vurɨgheghe.” Thɨ mbana brik (thelau) na thɨ vatavatadɨwe na thɨ monje valaweŋgi na i vurɨgheghe. ");
INSERT INTO tgo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Amba thɨŋa, “E mbaŋake iyake ra vatada ghemba laghɨye na ŋgolo regha i loŋga na i voro na molao, mbala ve wo buruburuko, mbala idanda ne i laghɨye. Ŋgoloke iyake i vakathainda thava ra meila e yambaneke laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Amba Giya Loi i njama na i thuwe ghembako laghɨye na ŋgoloko molao thɨ vatavatadɨko. ");
INSERT INTO tgo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Giya Loi iŋa, “Gharɨgharɨke thiyake kaero thiya mevathavatha na regha na ghalɨŋanji regha. Kaero thɨ worawa lenji vakathako iyako rɨghe. Nevole valɨkaiwanji budakaiya nuwanjiya thɨ vakatha. ");
INSERT INTO tgo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ra nja na vara vauneuneŋaŋgi na tomethi mbe ghalɨŋanji, mbala maa thɨ veloŋwa ghalɨŋanjiko gharumwaru.” ");
INSERT INTO tgo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Iya kaiwae Giya Loi i vakathaŋgi na thɨ meila e yambaneke laghɨye na thɨ viyatho ghembama laghɨye ghavatavatad. ");
INSERT INTO tgo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Iya kaiwae ghembako laghɨye iyako idae Babel, kaiwae gheko Giya Loi va i vauneuneŋa gharɨgharɨke wolaghɨye e yambaneke na gheko i vakathaŋgi na thɨ meila e yambaneke laghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Riuriuke iyake Sem orumburumbuye utuutuninji. Thothoko e ghereiye, theghathegha umboiwo vama iko na mbaŋaniye Sem ghatheghathegha vama i wo hwethaŋarɨ (100), i vaidiya nariye regha idae Apaksad. ");
INSERT INTO tgo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Iyako e ghereiye Sem mbowo i yaku va theghathegha hweseriyelima (500) na e tɨne mbowo thɨ laghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apaksad ghatheghathegha vama i wo hweto na umbolima (35) amba thɨ ghamba ŋgama ghɨmoru regha idae Sila. ");
INSERT INTO tgo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Iyako e ghereiye Apaksad i yaku theghathegha hweseriyevarɨ na umboto (403) na e tɨne mbowo thɨ laghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Mbaŋa Sila ghatheghathegha vama i wo hweto (30), thɨ ghamba ŋgama ghɨmoru regha idae Eba. ");
INSERT INTO tgo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Iyako e ghereiye Sila i yaku theghathegha hweseriyevarɨ na umboto (403), na e tɨnenji mbowo thɨ laghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Mbaŋa Eba ghatheghathegha hweto na umbovarɨ (34), thɨ ghamba ŋgama ghɨmoru regha idae Peleg. ");
INSERT INTO tgo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Iyako e ghereiye Eba i yaku theghathegha hweseriyevarɨ na hweto (430) na e tɨnenji mbowo thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Mbaŋa Peleg ghatheghathegha hweto (30), thɨ ghamba ŋgama ghɨmoru regha idae Riu. ");
INSERT INTO tgo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Iyako e ghereiye Peleg i yaku theghathegha hweseriyeiwo na umbosiwo (209) na e tɨnenji mbowo thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Mbaŋa Riu ghatheghathegha hweto na umboiwo (32), thɨ ghamba ŋgama ghɨmoru regha idae Serug. ");
INSERT INTO tgo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Iyako e ghereiye Riu i yaku theghathegha hweseriyeiwo na umbopirɨ (207) na e tɨnenji mbowo thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Mbaŋa Serug ghatheghathegha hweto (30), thɨ ghamba ŋgama ghɨmoru regha idae Naho. ");
INSERT INTO tgo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Iyako e ghereiye Serug i yaku theghathegha hweseriyeiwo (200) na e tɨnenji mbowo thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Mbaŋa Naho ghatheghathegha hoiwo na umbosiwo (29), thɨ ghamba ŋgama ghɨmoru regha idae Tira. ");
INSERT INTO tgo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Iyako e ghereiye Naho i yaku theghathegha hwethaŋarɨ, hoyaworo na umbosiwo (119) na e tɨnenji mbowo thɨ ghambɨŋgiva gamagai vavana. ");
INSERT INTO tgo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mbaŋa Tira vama ghatheghathegha hwepirɨ (70) e ghereiye amba thɨ ghambɨŋgiya Eibram, Naho na Haran. ");
INSERT INTO tgo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Iyake Tira orumburumbuye utuutuninji. Tira le ŋgaŋgaŋgiya Eibram, Naho na Haran. Haran nariya Lote. ");
INSERT INTO tgo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Mbaŋa Tira vamba e laghalagha nariye Haran kaero i mare e ghambae moli, Ur Babiloniya e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Eibram na ghaghae Naho va thɨ ghe. Eibram levo idae Serai na Naho levo idae Milika. Milika iye Haran yawarumbuye na ghaghae nasiyeniye Iska. ");
INSERT INTO tgo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Serai mava i ghambɨ, va i kwama. ");
INSERT INTO tgo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tira i vaŋguŋgiya nariye Eibram na rumbuye Lote, iye Haran nariye, na ghendiyae Serai, Eibram levo, na weiyaŋgi thɨ iteta Ur Babiloniya e tɨne na thɨ raka e valɨvaŋga regha idae Kenan. Ko iyemaeŋge thɨ raka gheghad Haran na thɨ yayaku gheko. ");
INSERT INTO tgo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tira va i mare gheko. Ghatheghathegha le ghanaghanagha hweseriyeiwo na umbolima (205). ");
INSERT INTO tgo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Amba Giya Loi i dage weya Eibram iŋa, “U iteteya vanautumana iya u rinawe, rama na len bodaboda na u wa e valɨvaŋga regha ne ya vatomwe e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ne ya vakathaŋge na vanautuma laghɨye regha ghen na ne ya mwaewo e ghen. Ne ya vakatha idan i laghɨye moli, na e ghen thovuyeke wolaghɨye ne i mena weŋgiya gharɨgharɨ. ");
INSERT INTO tgo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ne ya mwaewo weŋgiya thavala thɨ mwaewo e ghen, na ne ya gura thavala thɨ guraŋge, na yambaneke laghɨye gharɨgharɨniye ghanjimwaewoko ne i mena kaiwae ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Iya kaiwae Eibram i iteteya Haran ŋgoreiya Giya Loi le utuwe, weiye Lote. E mbaŋako iyako Eibram ghatheghathegha vama i wo hwepirɨ na umbolima (75). ");
INSERT INTO tgo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Eibram va i vaŋguŋgiya levo Serai, rumbuye Lote, na lenji bigibigi na thetheghanɨko wolaghɨye na tembe ŋgoreiyeva lenji rakakaiwoŋgiko wolaghɨye va thɨ vaŋguŋgi mbaŋa inanji Haran. Thɨ loŋga gheghad vethɨ vutha Kenan. Mbaŋa thɨ vutha Kenan, ");
INSERT INTO tgo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Eibram i ru vanautumako tɨne gheghad ve vutha e umbwa laghɨye regha inawe. Valɨvaŋgako iyako idae More, ghemba Sekem e tɨne. E mbaŋako iyako Kenan gharɨgharɨniye vambe thɨ yaku gheko. ");
INSERT INTO tgo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","E valɨvaŋgako iyako Giya Loi i yomara weya Eibram na i dagewe iŋa, “Vanautumake iyake iya ne ya wogiya weŋgiya orumburumbu.” Amba Eibram i vatada ghamba vowo Giya Loi kaiwae, ŋgora va i yomaramawe. ");
INSERT INTO tgo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Iyako e ghereiye Eibram i loŋga na i wa bobokulu e lenji valɨvaŋga, Betel valɨvaŋga i vorovoro. I vatada le yoŋathowathowa gheko. Betel va ina valɨvaŋga i njanja na Ai ina valɨvaŋga i vorovoro. Gheko i vatada ghamba vowo na i kururu weya Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Eibram mbowo i wareriva na i loŋga i ghemba Kenan valɨvaŋga yaghalako idae Negev. ");
INSERT INTO tgo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kenan e tɨne vunuvu laghɨye regha va i yomara. Iyako i vakatha Eibram i wa Ijipt na wo ve yaku gheko mbaŋa ubotu. ");
INSERT INTO tgo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Amba inanji e loŋga mborowa, ko vama thɨ vurɨthai eŋge Ijipt, Eibram i dage weya levo Serai iŋa, “Ya ghareghare, kaiwae wevo manɨuneya ghen, ");
INSERT INTO tgo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","mbaŋa Ijipt gharɨgharɨniye ne thɨ thuweŋge amba thɨŋa, ‘Levo iyako.’ Amba bayanbayan thɨ unɨghɨŋgo na thɨ ghakuŋge. ");
INSERT INTO tgo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mbala u dage weŋgi na uŋa lounɨna ghino, na mbala ghen kaiwan na thava thɨ unɨghɨŋgo na thɨ njimbukiki wagiyaweŋgo.” ");
INSERT INTO tgo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Mbaŋa thɨ vutha Ijipt, gharɨgharɨ e vanautumako thɨ thuwe Serai emunjora wevo manɨune eunda. ");
INSERT INTO tgo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mbaŋa Pero le rakakaiwo e raberabe thɨ thuwe elaghɨniye, thɨ mena Pero e marae na mbe thɨ taratarawa vara; iwaeŋge thɨ vaŋgumenawe ele ŋgoloko tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Serai kaiwae, Pero i njimbukiki wagiyaweya Eibram na i giya sip, gout, kau, doŋɨki, rakakaiwo na kamel we. ");
INSERT INTO tgo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ko kaiwae Pero va i vaŋguya Serai na i munjeva levo, iya kaiwae Giya Loi i vakatha na ghambwera i yomara weya Pero na le ŋgoloko gharayakuyaku. ");
INSERT INTO tgo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Amba Pero i wodu weya Eibram na wo i menawe. Mbaŋa i vuthawe kaero i vaito iŋa, “Mendava u vakatha budakai e ghino? Buda kaiwae mava u govambwara e ghino na uŋa len wevo? ");
INSERT INTO tgo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Buda kaiwae mendava uŋa loun, iwaeŋge mendava ya vaŋgu na yaŋava lo wevo? E mbaŋake iyake u vaŋgunjoghao len wovoke na mbema hu wareri vara!” ");
INSERT INTO tgo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pero iŋa na ragagaithɨ vavana vethɨ i yathu e kamwathɨ mborowa weiye levo Serai na lenji bigibigiko wolaghɨye thɨ iteta vanautumako iyako. ");
INSERT INTO tgo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Eibram na levo thɨ iteta Ijipt na thɨ njogha e ghereinji Negev e tɨne weinji Lote na lenji bigibigiko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","E mbaŋaŋgiko thiyako Eibram iye va mbema giya vwenyavwenya moli vara. Le sip, gout na kau lemoyo na tembe ŋgoreiyeva silva na gol. ");
INSERT INTO tgo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Weiyaŋgiya ghambandɨmbandɨ thɨ roiteta valɨvaŋgako iyako, thɨ mena thɨ yaku, thɨ ghao thɨ yaku, gheghad vethɨ vutha ŋgora va thɨ yakuma, Betel na Ai e ghanjilughawoghawo ");
INSERT INTO tgo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ŋgorava i vatada ghamba vowoma. Na gheko i kururu weya Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lote vambe ŋgoreiyeva. Va ele sip, gout na kau. Vambe ele ŋgamaŋgamava na ele rakakaiwo. ");
INSERT INTO tgo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kaiwae lenji thetheghan va lemoyo moli na nana mava i poku e valɨvaŋgako iyako na valɨkaiwae thenjighewoko thɨ yaku na regha. ");
INSERT INTO tgo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Iya kaiwae gaithɨ i yomara Eibram le thetheghan gharanjimbunjimbu na Lote le thetheghan gharanjimbunjimbu weŋgi. Eibram na Lote maava thɨ yaku na regha kaiwae nana maava i poku e valɨvaŋgako iyako lenji thetheghanɨko kaiwanji. (E mbaŋako iyako Kenan na Perisi gharɨgharɨniyeŋgi vambe thɨ yakuva gheko.) ");
INSERT INTO tgo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Iya kaiwae Eibram i dage weya Lote iŋa, “Thava me vatharɨ regha ina e ghanda lughawoghawoke o la thetheghanɨko ghanjiranjimbunjimbu e ghanjilughawoghawoko kaiwae rumbuŋgu moliya ghen. ");
INSERT INTO tgo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Wo ra vemeghaghathɨ weinda. U tuthiya the valɨvaŋga nuwaniya, u wa e valɨvaŋgana iyena na ghino ya wa e valɨvaŋga regha.” ");
INSERT INTO tgo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lote i ghɨmaratakwe na i thuwe malamo Jorɨdan ele valɨvaŋga na ve wo Sowa mbwa varɨve ŋgoreiya Giya Loi le uma Iden e tɨne na ŋgoreiyeva Ijipt thivathivaniye. (Giya Loi maa vamba i ŋambuŋgiya Sodoma na Gomora.) ");
INSERT INTO tgo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lote i tuthiya Jorɨdan malamoniyeko laghɨye. Kaero i wareri, i loŋga na i ghemba boimako. E mbaŋako iyako thɨ veiteteŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Eibram vambe i reyaku Kenan e tɨne na Lote i wa na i vatada le yoŋathowathowa Sodom evasiwae. ");
INSERT INTO tgo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom gharɨgharɨniye va thɨ tharɨ moli na thɨ vakatha tharɨ Giya Loi e marae. ");
INSERT INTO tgo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mbaŋa Lote kaero i wareri, Giya Loi i dage weya Eibram iŋa, “Ŋgora vara iya inanɨnawe, u ghɨmara ruwoko, u ghɨmara raŋgiwoko, u ghɨmara vorowoko na u ghɨmara njaoko. ");
INSERT INTO tgo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Iya vara valɨvaŋgana laghɨye iya u thuwena ne ya wogiya e ghen na orumburumbu, na nevole ghen len ghamba mbaro mbaŋake wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ne ya vakathaŋgiya orumburumbu thɨ mbuthu na lemoyo moli ŋgoranjiya yambaneke vughauye na maa valɨkaiwae lolo regha ne i vaona. ");
INSERT INTO tgo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","E mbaŋake iyake u loŋga vaghɨliya valɨvaŋgake laghɨye tɨne, kaiwae ne ya vatomwe e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Eibram i rake le yoŋathowathowama na ve yakuva e umbwaumbwa laghɨlaghɨye evasiwanji Memri ghadidiye Hebron e tɨne, na gheko i vatada ghamba vowo Giya Loi kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kiŋ theghevarɨ, Babiloniya ghakiŋ Amrapel, Ilasa ghakiŋ Ariyok, Ilam ghakiŋ Kedolaoma, na Goyim ghakiŋ Taidol. ");
INSERT INTO tgo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Thiyake vethɨ gaithɨ weinjiyaŋgiya Sodoma ghakiŋ Bera, Gomora ghakiŋ Besa, Adma ghakiŋ Saineb, Jeboyim ghakiŋ Simeba na Sowa (mbaŋake thɨ uno Bela) ghakiŋ. ");
INSERT INTO tgo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kiŋɨke theghelimake thiyake thɨ wabwi na regha e malamo regha idae Sidim (noroke idae Njighɨ Maremareniye Malamoniye). ");
INSERT INTO tgo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Theghathegha hoyaworo na umboiwo e tɨne kiŋɨke theghelimake va thɨ yaku Kiŋ Kedolaoma ele mbaro tɨne, ko iyemaeŋge theghathegha hoyaworo na umbotoninji e tɨne kaero thɨ botewo na maa thɨ giya ghamwaewowe. ");
INSERT INTO tgo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Theghathegha hoyaworo na umbovarɨ e tɨne Kedolaoma na le wabwiŋgi thɨ wabwi na regha, thɨ rakawa weinjiyaŋgiya lenji ragagaithɨ na thɨ kivwalaŋgiya Repa gharɨgharɨniye Asterot Kanaim e tɨne, Susa gharɨgharɨniye Ham e tɨne, Emi gharɨgharɨniye e malamo idae Kirayathaim, ");
INSERT INTO tgo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Hor gharɨgharɨniye e bobokulu inanji Seir ele valɨvaŋga. Va thɨ mbeleŋgi gheghad El Paran e vuruvuru vwatavwata ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Amba thɨ rakavaghɨle na thɨ rakamena Mispat (mbaŋake thɨ uno Kades). Thɨ kivwalaŋgiya Amalek gharɨgharɨniye na lenji ghamba mbaroko, na tembe ŋgoreiyeva Amori gharɨgharɨniye thɨ yayaku Heisason Tama. ");
INSERT INTO tgo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Amba Sodom ghakiŋ Bera, Gomora ghakiŋ Besa, Adma ghakiŋ Saineb, Seboyim ghakiŋ Simeba na Sowa (o Bela) ghakiŋ thɨ rakaraŋgi na thɨ vivatha gaithɨ kaiwae e malamo idae Sidim, ");
INSERT INTO tgo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","weinjiyaŋgiya Ilam ghakiŋ, Goyim ghakiŋ, Sina ghakiŋ na Elasa ghakiŋ, kiŋ theghevarɨ weinjiyaŋgiya kiŋ theghelima. ");
INSERT INTO tgo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","E malamoko iyako tɨne gogoga va lemoyowe na va thɨ riyevanjara e kolɨta, na mbaŋa Sodom na Gomora ghanjikiŋ weinjiyaŋgiya lenji ragagaithɨ thɨ rakavo vavana thɨ dimban e gogogako tɨnenji, na ghanji uneko wolaghɨye thɨ rakavo na i ru e bobokuluko rɨgherɨghenji. ");
INSERT INTO tgo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Amba kiŋɨŋgima theghevarɨma thɨ vurɨgheghema weinjiyaŋgiya lenji ragagaithɨ thɨ rakaru Sodoma na Gomora e tɨnenji na thɨ bigivao bigibigiko thovuthovuye wolaghɨye, ko amba thɨ rakanjogha e ghambaghambanji. ");
INSERT INTO tgo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Vambe thɨ vaŋguva Eibram rumbuye Lote na le bigibigiko wolaghɨye, kaiwae e mbaŋako iyako va ina i yaku Sodoma e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Amala regha, iyava thɨ rakavoma, i mena i vutha weya Eibram iye Hibru na i giya totowe budakai kaero me yomara. E mbaŋako iyako Eibram vambe i yaku e umbwaumbwa laghɨlaghɨye rɨgherɨghenji ghadidiye. Umbwaumbwake thiyake tanuwaganjiya Memri iya Amori loloniye regha, na weiyaŋgiya oghaghae Eskol na Ana va thɨ wabwi na regha weinji Eibram. Ko lenji renuwaŋa regha na thɨ vethalathalavuŋgi gaithɨ gha mbaŋa. ");
INSERT INTO tgo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Mbaŋa Eibram i loŋwe rumbuye kaero methɨ vaŋguŋgi na vethɨ mbaroŋaŋgi e vanautuma regha, i kulavathaŋgiya ragagaithɨ e ghayayaoko tɨne, lenji ghanaghanagha hoseriyeto na theyaworo na theghewa (318), na Memri na oghaghae. Amba thɨ rakareghamba weŋgi gheghad vethɨ vuthavaleŋgi e ghemba regha idae Den ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Gougoueŋge iyena Eibram i bigiraweŋgiya le ragagaithɨko e wabwiŋgi na thɨ gaithɨ weinjiyaŋgiya ghanjithɨghɨyako na thɨ kivwalaŋgi. Thɨ mbeleŋgi na vethɨ mbeleyathuŋgi Hoba Damasiko e ghaiwabuniyeko. ");
INSERT INTO tgo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Eibram i biginjoghavao bigibigiko wolaghɨye mendava thɨ kaivɨŋgi na i vaŋgunjogha rumbuye Lote na le bigibigiko wolaghɨye, na tembe ŋgoreiyeva wanakau vavana na mbe gharɨgharɨ vavanava. ");
INSERT INTO tgo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Mbaŋa Eibram i kivwala kiŋ Kedolaoma na vavanako va weiyaŋggiko na i njogha, Sodom ghakiŋ i raŋgi na thɨ lavolevole e malamo idae Save (idae regha Kiŋ le Malamo). ");
INSERT INTO tgo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Amba Melkisedek, iye Salem ghakiŋ, i bigimena bred na waen weya Eibram. Amalaghɨniye vambe Loi Ramevoro Moli le ravowovowova. ");
INSERT INTO tgo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","I mena na i mwaewo weya Eibram iŋa, “Eibram, Loi Ramevoro Moli ne i mwaewo e ghen. Iye buruburu na yambaneke ghanji ravakatha. ");
INSERT INTO tgo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Na tarawa i voro weya Loi Ramevoro Moli, iye me vatomweŋgiya ghan thɨghɨyaŋgina e nɨmanɨna ghare.” Amba Eibram i mbanɨvathavathaŋgi vara bigibigiko wolaghɨye menda ve kivwalaŋgiya kiŋɨma theghevarɨma, i vakatha vara wabwi yaworo, ko amba i giya wabwi regha weya Melkisedek. ");
INSERT INTO tgo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mbaŋa Eibram i vakathavao iyako, amba Sodom ghakiŋ iŋa, “U vatomweŋgi eŋge gharɨgharɨna e ghino, ko bigibigina eŋge mbe len bigibigiwo.” ");
INSERT INTO tgo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ko iyemaeŋge Eibram i gonjoghawe iŋa, “Ya livaira nɨmaŋgu na ya dagerawe weya Giya Loi Ramevoro Moli, iye buruburu na yambaneke ghanjiravakatha, na ya tholo, ");
INSERT INTO tgo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","maa tene ya wova bigi regha ghen kaiwan, othembe bigi nasi moli ŋgoreiya ghegha ghae ghathiyo, mbala maane u dage e ghino na uŋa, ‘Ghino menda ya vakatha Eibram na i vwenyavwenya.’ ");
INSERT INTO tgo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mane ya wo bigi regha ghino kaiwaŋgu, ko kaero ya wovatha eŋge budakaiya ragagaithɨ kaero menda thɨ ghan. Ko nuwaŋguiya eŋge wouneke mendava ya wabwike weiŋguyaŋgi, Ana, Eskol na Memri thɨ mbana budakai valɨkaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Vakathaŋgiko thiyako e ghereiye, Giya Loi ghalɨŋae i mena weya Eibram e vavaghare ghenelolo e tɨne. Giya Loi i dagewe iŋa, “Eibram, ne u ndemararu bigi regha, ghino len yagogha na ne ya giya modan laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ko iyemaeŋge Eibram i gonjoghawe iŋa, “O Loi Giya Laghɨye, ne u wogiya budakai e ghino, e mbaŋake iyake amba ma e lo ŋgaŋga? Eliyesa rara Damasiko iye mbe ghambereghaeŋge ne i rombaro e woyayaoke. ");
INSERT INTO tgo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Amba maa u vakathaime na e lama ŋgaŋga, iya kaiwae lo rakakaiwoke regha ne i rothɨŋgo.” ");
INSERT INTO tgo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Amba Giya Loi ghalɨŋae mbowo i menaweva iŋa, “Nandere! Iya len rakakaiwona Eliyesa mane i mbaroŋa ghan yayaona, mbe ghen vara madɨban iye ne ghan thɨghɨthɨghɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Giya Loi i vaŋguraŋgiya eto na i dagewe iŋa, “Wo u ghɨmaravoro e buruburuko na u mando na u vaonaŋgiya ghɨtarako, thoŋgo valɨkaiwan; orumburumbu nevole lenji ghanaghanagha ŋgora thiyako.” ");
INSERT INTO tgo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Eibram i worawa Giya Loi ghamidi, na le vakathako iyako kaiwae Giya Loi i warari laghɨye kaiwae na i wovarumwarumwaruŋa. ");
INSERT INTO tgo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Na tembe i dageweva iŋa, “Ghino Giya Loi iyava ya vaŋguraŋgiyaŋgena Ur Kalɨdiya thivathivaniye e tɨne, na ya vatomwe valɨvaŋgake iyake na ghamban.” ");
INSERT INTO tgo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ko Eibram i gonjoghawe iŋa, “O Giya Loi Laghɨye, ŋgoroŋga ne yaŋa na ya ghareghare valɨvaŋgake iyake ghino ne ya mbaroŋa?” ");
INSERT INTO tgo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Giya Loi i dagewe iŋa, “Wo u bigimenaŋgiya thetheghanɨke thiyake: kau botuwo umbwara, gout umbwara na sip ghɨmoru umbwara, ghanjitheghathegha umboto na maa manyiwo, bunebune manda na mbo manda.” ");
INSERT INTO tgo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Eibram i bigimenaŋgiya thetheghanɨma na maaŋgima, i bigimena weya Loi, i tagaviyaŋgi na gethɨwo iya, gethɨra valɨvaŋga, gethɨra valɨvaŋga, ko iyemaeŋge maaŋgima maa i tagaviyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Amba maa thetheghan gharaghanɨŋgi thɨ yonja weŋgiya borogima, ko iyemaeŋge Eibram i vagegeyathuŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mbaŋa ŋgoreiya tauya wovoŋgu, Giya Loi i vakatha Eibram i ghenetena nuwa, amba mouwo e maramararuwae regha i yomarawe. ");
INSERT INTO tgo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Amba Giya Loi i dagewe iŋa, “Emunjoru na valɨkaiwae u ghareghare iyake: orumburumbu nevole vethɨ mebwabwari e vanautuma regha. Nevole gharɨgharɨko gheko thɨ vakathaŋgi na thɨ kaiwo weŋgi na thɨ vaidiya vuyowo laghɨye moli theghathegha hweseriyevarɨ e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ko ghino tene ya lithɨgha iya vuyowoko iyako weŋgiya vanautumako iyako gharɨgharɨniye, iya thɨ giya vuyowoko weŋgi, na ne e ghereiye ko amba thɨ rakaraŋgi weiyaŋgiya madimadinjiko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ko iyemaeŋge, ghen ne yawalin molao moli, amba u garalawa wein len vanevane. ");
INSERT INTO tgo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Orumburumbu ne tha theghevarɨninji e tɨne amba thɨ rakanjoghamake gheke, kaiwae i viva wone ya thuwe vara Amori gharɨgharɨniye lenji tharɨko i laghɨye moli na ya giya vuyowo weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mbaŋa varae vama ve ronja na kaero i momouwo na e mbaŋako iyako uye vwarara weiye ŋiŋi munduwae i voro na theŋgi i ra na thɨ yomara na thɨ reŋa thetheghanɨma e ghanjilughawoghawo. ");
INSERT INTO tgo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","E mbaŋako iyako Giya Loi i vaemunjoruŋa le dagerawema weya Eibram na iŋa, “Weŋgiya orumburumbu ya vatomwa thivathivake iyake weŋgi. I ri Ijipt e walaghɨta i mena i wa ve wo walaghɨta Yupreitis. ");
INSERT INTO tgo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Gharɨgharɨke thiya inanji e valɨvaŋgake iyake, Keni gharɨgharɨniye, Kenis gharɨgharɨniye, Kadmon gharɨgharɨniye, ");
INSERT INTO tgo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het gharɨgharɨniye, Perisi gharɨgharɨniye, Repa gharɨgharɨniye, ");
INSERT INTO tgo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori gharɨgharɨniye, Keinan gharɨgharɨniye, Gigasi gharɨgharɨniye na Jebusi gharɨgharɨniye.” ");
INSERT INTO tgo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Serai, Eibram levo, mava valɨkaiwae i ghambɨ gamagai le ghɨmoruko kaiwae. Ko iyemaeŋge le rakakaiwo eunda, tɨnan Ijipt, idae Heiga, ");
INSERT INTO tgo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","iwaeŋge i dagewe le ghɨmoru Eibram iŋa, “Giya Loi i vakathaŋgo ma valɨkaiwaŋgu ya ghambɨ. Wo u ghena wein lo rakakaiwoko, mbwata ne i ghambɨ gamagai ghino kaiwaŋgu.” Eibram i varaeŋna levo Serai le renuwaŋako na i vakatha ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Lenji yakuyaku Kenan e tɨne vama i wo theghathegha hoyaworo, iwaeŋge Serai i vaŋgugiya le rakakaiwoma tɨnan Ijipt, Heiga, weya le ghɨmoru Eibram na levo eunda. ");
INSERT INTO tgo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Mbaŋa Eibram i ghenethaiya Heiga kaero i vaidiya ŋgama. Mbaŋa i ghareghare kaero e tete i vakatha i wovoreŋa ghamberegha na maa i yavwatatawana tanuwagae Serai. ");
INSERT INTO tgo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Amba Serai i dage weya le ghɨmoru Eibram iŋa, “Vuyowoke iya i voroke e ghino rɨghethora ghen. Mbaŋa mendava ya vaŋgugiya lo rakakaiwoko e ghen, na mbaŋake i ghareghare kaero e tete, i vakatha i wo vorevoreŋa na maa i yavwatata wanaŋgo. Giya Loi ghamberegha tembe i tuthi thela le tharɨ yake.” ");
INSERT INTO tgo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Amba Eibram i dage weya Serai iŋa, “Wo u thuwe, ghen u mbaroŋa iya len rakakaiwo wevona iyena. The renuwaŋa nuwaniya u vakathawe, ko u vakathawe.” Serai ghathanavu i tharɨwe moli, iya kaiwae Heiga i voitete. ");
INSERT INTO tgo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Giya Loi le nyao thovuye i vaidiya Heiga e mbwarowou regha ghadidiye ina e vuruvuru vwatavwata. Mbwarowouke iyake ina e kamwathɨ i wa Sur. ");
INSERT INTO tgo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Nyaoma thovuye i dagewe iŋa, “Heiga, Serai le rakakaiwo ghen, ko aŋga mo ri na ghamwan aŋga i yere?” I gonjoghawe iŋa, “Nuwaŋguiya ya voiteta tanuwagaŋguko.” ");
INSERT INTO tgo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Amba Giya Loi le nyao thovuye i dagewe iŋa, “U njogha weya tanuwaga Serai, na u ghambugha le mbarona.” ");
INSERT INTO tgo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nyaoma thovuye mbowo i dageweva iŋa, “Giya Loi nevole i vakathaŋge na orumburumbu lemoyo moli na mane valɨkaiwae lolo regha i vaonaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Giya Loi le nyao thovuye tembe i dageweva iŋa, “Ŋgamana iya e ŋgamoinɨna ŋgama ghɨmoru. Mbaŋa ne i virɨ ne u rena idae Ismel, kaiwae Giya Loi kaero i loŋwe iya len gharevɨrɨna. ");
INSERT INTO tgo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ko iyemaeŋge iya naruna iyena nevole le yakuyaku ŋgoreiya mbwanjam na maa valɨkaiwae ra thɨnɨra murumuru e ghamwa. Nevole thɨ vegaithɨ wanaŋgi weiyaŋgiya gharɨgharɨke wolaghɨye, i meghaghathɨ weŋgiya le bodaboda.” ");
INSERT INTO tgo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Heiga i unogiya Giya Loi iya me utuma weiye idae iŋa, “Ghen Loi u thuwathuwa e ghino,” iya kaiwae iŋa, “Kaero ma thuwe iya loloke i thuwathuwake e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Iya kaiwae mbwarowouko iyako idae Beya Lahai Roi, gharumwaru mbwarowouke iyake tanawagaya lolo e yawayawaliye i thuwathuwa e ghino. Ina Kades na Bered e ghanjilughawoghawo. ");
INSERT INTO tgo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Heiga i ghamba ŋgama ghɨmoru na Eibram i rena idae Ismel. ");
INSERT INTO tgo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","E mbaŋako iyako Eibram ghatheghathegha vama i wo hwewona. ");
INSERT INTO tgo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Mbaŋa Eibram vama ghatheghathegha i wo hwesiwo na umbosiwo, Giya Loi mbowo i yomaraweva na i dagewe iŋa, “Ghino Loi Vurɨvurɨghegheniye. Len yakuyaku mbe i thovuye vara e maraŋgu na thava tharɨ regha i mwenja riwanɨna. ");
INSERT INTO tgo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Amba ne ya vaemunjoruŋa lo dagerawema e ghen na nevole ya vakathaŋgiya orumburumbu lemoyo moli.” ");
INSERT INTO tgo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Eibram i dipoumu e thelauko vwatae na Loi i dagewe iŋa, ");
INSERT INTO tgo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ghino e lo valɨvaŋga lo dagerawe iyake e ghen, ghen vanautuma lemoyo rumbunjiya ghen. ");
INSERT INTO tgo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Idanɨna mama ne mbaŋa regha thɨŋa, ‘Eibram’, mbema ne thɨŋa vara ‘Eibraham,’ kaiwae ne ya vakathaŋge na orumburumbuŋgiya vanautuma lemoyo. ");
INSERT INTO tgo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ne ya vakathaŋge na orumburumbu lemoyo moli. Nevole ya vakathaŋgi na thɨ vakatha vanautuma lemoyo na kiŋɨŋgi ne thɨ rimbun e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ne ya renuwaŋakiki iya dageraweke iyake gha mbaŋa i ri rogha, ghino na ghen e ghanda lughawoghawoke, na tembe ŋgoreiyeva orumburumbu thako muyaiko na thiye orumburumbunjiva tha na tha mbaŋa muyaiko. Len Loi ghino mbe wombereghaeŋge na orumburumbu tembe ŋgoreiyeva. ");
INSERT INTO tgo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Valɨvaŋgake iya u mebwabwarikewe, mbema Kenan laghɨyeke vara, kaero ya vatomwe e ghen na orumburumbu mbaŋa muyaiko na lenji ghamba mbaro memeghabananiye, na ghino ne lenji Loi.” ");
INSERT INTO tgo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Loi mbowo i dageweva Eibraham iŋa, “Ko ghen e len valɨvaŋga, u njimbukiki wagiyawe iya lo dageraweke e ghen na orumburumbu tha na tha mbaŋa muyaiko nevole thɨ vakatha iya budakaiya noroke ya utugiya e ghen na u vakatha. ");
INSERT INTO tgo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ghen na orumburumbu tha na tha mbaŋa muyaiko ne hu ghambugha lo dageraweke, ne hu vakatha ŋgoreiye vara iyake: Ŋgama ghɨmoru regha na regha ne hu kitenɨyatho riwae mbothiye njimwae. ");
INSERT INTO tgo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ghɨmoghɨmoruna, mbema taulaghɨna vara ghemi, hu vakatha kamwathɨke iyake. Na iyake ne lo dageraweke, ghen na ghino e ghanda lughawoghawo, ghanono. ");
INSERT INTO tgo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Tha na tha mbaŋa i menamenako, gamagai ghɨmoghɨmoru ne thɨ virɨ na kaero thɨ yaku mbaŋa theghewa, ne hu kitena riwanji mbothiye njimwae. Len rakakaiwo thɨ virɨ e ghan yayaona tɨne na len rakakaiwo u vamodaŋgi weŋgiya gharɨgharɨ vavana, na maa thɨ rimbun e ghen, tembe u vakathava ŋgoreiye weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Thɨ virɨ e ghan yayaona tɨne o u vamodaŋgi e mani, ne u kitena riwanji mbothiye njimwae. Vakathake iya u vakatha e riwanɨna ne i vanuwovɨrɨŋge na u renuwaŋakikiya dageraweke iyake ghe mbaŋa i ri rogha. ");
INSERT INTO tgo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","The ghɨmoru regha thoŋgo ma thɨ kitena riwae mbothiye, loloko iyako ne i meraŋgi moli e wabwiko iyako tɨne, kaiwae kaero i rake dageraweko iyake ghe mbaro.” ");
INSERT INTO tgo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Loi tembe i dageweva Eibraham iŋa, “Weya len wevo Serai, mane te u unova idae Serai, idae togha ne u uno Sera. ");
INSERT INTO tgo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mbene ghareŋguwe vara na ne i ghamba ŋgama ghɨmoru kaiwan. Ne ya vakatha elaghɨniye na orumburumbuye thɨ vakatha vanautuma lemoyo, na kiŋ vavana ne thɨ rimbun weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Eibraham i dipoumu e thelauko vwatae, i vavɨra utuko iyako na tembe i dagewe ghamberegha iŋa, “Ne valɨkaiwaeya amalaghɨsarɨ ghatheghathegha kaero i wo hothaŋarɨ? Ne valɨkaiwae Sera, kaero i thanja moli, na ghatheghathegha kaero hwesiwo na tembe i laghambɨva ŋgama?” ");
INSERT INTO tgo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Iya kaiwae Eibraham i dage weya Loi iŋa, “Thoŋgo u worawe eŋge naruŋguko Ismel e ghamwan!” ");
INSERT INTO tgo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ko iyemaeŋge Loi i dagewe iŋa, “Ŋgoreiye, ko len wevo Sera ne i ghamba ŋgama ghɨmoru regha na ne u rena idae Aisake. Ne ya vaemunjoruŋa lo dagerawe weiŋgu. Dageraweke iyake ghe mbaŋa i ri rogha, amalaghɨniye na orumburumbuye mbaŋa muyaiko weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ko naruna Ismel kaiwae, kaero ma loŋwe iya len renuwaŋana. Tembene ya renuwaŋakikiva. Ne ya vakatha na i ghambɨ laghɨye, na ne ya mwaewowe na ya vakatha na orumburumbuye lemoyo. Le ŋgaŋga theyaworo na theghewo, thiye ne thɨ tabo na giyagiyaŋgi e lenji wabwiŋgi, na tembene ya vakathana orumburumbuye thɨ tabona vanautuma laghɨye reghava. ");
INSERT INTO tgo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ko iyemaeŋge lo vɨghathɨke weiŋgu Aisake, iya Sera ne i ghambɨna e mbaŋake iyake theghatheghako i menamenake, mbene ya vinjimbɨ vara.” ");
INSERT INTO tgo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mbaŋa i utuvao weiye Eibraham, kaero i njoghava. ");
INSERT INTO tgo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","E mbaŋako iyako tɨne, Eibraham i vaŋguya nariye Ismel na ghɨmoghɨmoruko wolaghɨye va thɨ virɨ e gheuko tɨne na tembe ŋgoreiyeva le rakakaiwo va i vamodaŋgi; ghɨmoghɨmoruko wolaghɨye na i kitena riwanji mbothiye njimwae, ŋgoreiya Loi me dagemawe. ");
INSERT INTO tgo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Amalaghɨniye Eibraham ghatheghathegha vama i wo hwesiwo na umbosiwo ko amba thɨ kiten eŋge riwa mbothiye njimwae, ");
INSERT INTO tgo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","na nariye Ismel ghatheghathegha vama i wo hoyaworo na umboto amba thɨ kiten eŋge riwae mbothiye njimwae. ");
INSERT INTO tgo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Eibraham na nariye Ismel mbe thenjighewo vara thɨ kitena riwanji mbothiye njimwae e mbaŋa iyako e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ghɨmoghɨmoruko wolaghɨye Eibraham e ghayayaoko tɨne na thavalava ŋgoreiya va i vamodo e mani e mbaŋako iyako tɨne thɨ tena riwanji mbothiye njimwae. ");
INSERT INTO tgo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mbaŋa regha theghatheghako iyako e tɨne mbaŋa varae mbema i vurɨgheghewe vara, Giya Loi i yomara weya Eibraham e umbwaumbwa laghɨlaghɨye rɨghenji Memri e tɨne; mbaŋaniye Eibraham i roraŋgi ele yoŋathowathowa ghathɨnɨmba thɨ taterawe. ");
INSERT INTO tgo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Eibraham i tagathɨna marae na i vaidiŋgiya amaamala thenjigheto thɨ ndeghathɨ e ghamwae. Mbaŋa i vaidiŋgi i yondovirɨ ele yoŋathowathowama tɨne, i raŋgi na ve thuweŋgi. Ghanji yavwatata kaiwae i kururu e ghamwanji. ");
INSERT INTO tgo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Amba iŋa, “Giyagiyana, thoŋgo u worawaweŋgo e ghamwami, thava hu iteta ghambaŋguke. ");
INSERT INTO tgo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Wo hu ndeghathɨ vara gheke na wo vathɨna mbwa na hu thavwiya gheghemina ko amba hu ronja e umbwana riburibuwae. ");
INSERT INTO tgo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Wo va bigimena ghanɨŋga seiwo na hu laghan na i thalavuŋga ko amba hu waova. Kaiwae mo hu yavwatata wanaŋgo na hu vutha e ghino iya kaiwae yala thalavuŋga.” Thɨ gonjoghawe thɨŋa, “I thovuye moli, u vakatha ŋgoreiya len renuwaŋana.” ");
INSERT INTO tgo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Eibraham mbema ghena nɨmaeŋge, i njogha ele yoŋathowathowa tɨne na i dage weya Sera iŋa, “Nɨman i maiya na u bigiya pwalawa ghayamoyamo thovuye mbambato, mbwata 20 kilo, na u vakatha bred.” ");
INSERT INTO tgo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","I yoruku weŋgiya le thetheghan na ve tuthiya kau nariye ghe tabo vondɨvondɨ, i vatomwe weya le rakakaiwo regha, i yoruku na ve vakatha ghanɨŋga kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Eibraham i bigimena milɨk kaero i lad, milɨk na kauma nariye methɨ vivatharawema na i bigirawe bwabwarima e maranji. Mbaŋa thɨ ghanɨŋga Eibraham mbe i ndeghathɨ evasiwanji e umbwako rɨghe. ");
INSERT INTO tgo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Thɨ vaito thɨŋa, “Len wevo Sera aŋga inae?” I gonjogha weŋgi iŋa, “Mbe ina e ŋgoloko tɨne.” ");
INSERT INTO tgo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Amba ghanjiuma regha i dagewe iŋa, “E mbaŋake vara noroke theghatheghake i menamenake tembene ya njoghamava e ghen na ne e mbaŋako iyako Sera ne i ghamba ŋgama ghɨmoru.” E ŋgoloko ghaghambaru, Sera vambe i ndegathɨwe vara, e ghereinji na i vandeŋe thɨ utuko. ");
INSERT INTO tgo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Eibraham na Sera vama thɨ thanja moli na Sera vama i kivwala ghatheghathegha valɨkaiwae i vaidiya ŋgama. ");
INSERT INTO tgo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Utuutuko iyako kaiwae Sera tembe i vavɨrɨva ghamberegha kaiwae va i renuwaŋa na iŋa, “Mbaŋake kaero maa elo vurɨgheghe na amalako kaero i amalaghɨsarɨ. Maa valɨkaiwae wo vaidiva ghambɨ warawaraniye.” ");
INSERT INTO tgo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Amba Giya Loi i dage weya Eibraham iŋa, “Buda kaiwae Sera i vavɨrɨ na iŋa, ‘Ne valɨkaiwae ya vaidiya ŋgama mbaŋake iya kaero ya thanjake?’ ");
INSERT INTO tgo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Thare bigi regha i vuyowo weya Giya Loi? Mbaŋa ne ya njoghama e ghen e mbaŋake iyake theghatheghake i menamenake, Sera ne i ghamba ŋgama ghɨmoru.” ");
INSERT INTO tgo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ko kaiwae Sera va weiye le mararu i kwan na iŋava maa me vavɨrɨ. Ko Giya Loi i dagewe iŋa, “Ko mbwana, mo vavɨrɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mbaŋa giyagiyama thɨ yondovirɨ na thɨ wareri, thɨ loŋga na ghamwanji i ghemba Sodom. Eibraham weiyaŋgi na ve ndeiyathuŋgi. Thɨ mena e valɨvaŋga regha e kamwathɨ mborowa amba maranji i nja Sodom. ");
INSERT INTO tgo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Amba Giya Loi mbe ghamberegha iŋa, “Mane ya wothuwele weya Eibraham budakaiya lo renuwaŋa ne ya vakatha. ");
INSERT INTO tgo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kaiwae Eibraham orumburumbuye, nevole thɨ tabo na vanautuma laghɨye na vurɨvurɨghegheniye regha. Na weya amalaghɨniye ne ghareŋgu weya vanautumake wolaghɨye e yambaneke vwatae. ");
INSERT INTO tgo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kaiwae ghino va ya tuthiya Eibraham na amalaghɨniye mbala i vavaghare mbaro weŋgiya le ŋgaŋga na orumburumbuye, mbala thɨ ghambugha ghino lo renuwaŋa na thɨ reŋa e kamwathɨ thovuye na budakaiya ghino ya warari kaiwae. Thoŋgo thɨ vakatha ŋgoreiyako ne ya vakatha ŋgoreiya budakai va ya dagera weya Eibraham.” ");
INSERT INTO tgo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Amba Giya Loi i dage weya Eibraham iŋa, “Kaero ya loŋwe Sodom na Gomora gharɨgharɨniye lenji vakatha vatharɨ weŋgiya gharɨgharɨ vavana na lenji randa kaero i voro e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mbowo ghino vara ya nja na va thuweŋgi na ya vaemunjoruŋa thoŋgo mbema emunjora lenji vakatha vatharɨko iyako, na mbala ya ghareghare mbema emunjora lenji vakathako i tharɨ moli.” ");
INSERT INTO tgo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Amaamalama thenjighewo thɨ loŋga na ghamwanji i ghemba Sodoma, ko iyemaeŋge Giya Loi vambe i rondeghathɨ vara weiye Eibraham. ");
INSERT INTO tgo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Eibraham i ndemena evasiwae na i dagewe iŋa, “Emunjora ne u mukuwoŋgiya gharɨgharɨ thovuthovuye weinjiyaŋgiya gharɨgharɨ raraitharɨ? ");
INSERT INTO tgo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ŋgoroŋga, thoŋgo iyelima gharɨgharɨ thovuthovuye inanji e ghembako tɨne, mbema ne u mukuwoŋgi vara ghembarako? Ko maane gharen i njao weŋgi iyelimako iya thovuthovuyeŋgiko inanjiko gheko? ");
INSERT INTO tgo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Mbwana maa valɨkaiwae ne u gaboŋgiya thovuthovuye weinjiyaŋgiya raraitharɨ. Maa valɨkaiwae moli! Maane u vakatha iyako. Thoŋgo u vakatha ŋgoreiye thovuthovuye ne thɨ vaidiya vuyowo weinjiyaŋgiya raraitharɨ. Mbema ma valɨkaiwae vara. Ghen ghanɨmbereghana yambaneke gharɨgharɨniyeke wolaghɨye ghanjiratuthi. Mbene u thuwe na i thovuye e maran amba u vakatha.” ");
INSERT INTO tgo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Giya Loi i gonjoghawe iŋa, “Thoŋgo ya vaidiŋgiya gharɨgharɨ thovuthovuye iyelima inanji gheko, thiye ne kaiwanji mane ya mukuwo ghembako iyako.” ");
INSERT INTO tgo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eibraham mbowo i naŋgoweva iŋa, “Kaiwae kaero ya ghamɨno lo vurɨghegheke valɨkaiwaŋgu ya utu e ghen renuwaŋako iyako kaiwae, nuwaŋguiya mbowo ya utuva e ghen, othembe ghino mbema lolo eŋge ya vwara e mbunɨma na madibe. ");
INSERT INTO tgo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Naka thoŋgo mbe iyevarɨ na theghelima eŋge gharɨgharɨ thovuthovuye, ne u mukuwo ghembarako kaiwae thovuthovuye theghelima kaero thɨ roraŋgi?” Giya Loi i gonjoghawe iŋa, “Othembe ne ya vaidiya thovuthovuye mbe iyevarɨ na theghelima eŋge, mane ya mukuwo ghembako iyako.” ");
INSERT INTO tgo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Eibraham mbowo i dageweva iŋa, “Ne ŋgoroŋga thoŋgo mbe iyevarɨ eŋge thovuthovuye inanji e ghembako tɨne?” I dagewe iŋa, “Mane ya mukuwo ghembako iyako othembe ne ya vaidi mbe iyevarɨ eŋge thovuthovuye inanji gheko.” ");
INSERT INTO tgo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eibraham iŋa, “Aee, Giya Loi thava u gaithɨ wanaŋgo, ko u vatomwe eŋge e ghino na mbowa ya vaitova. Ne u vakatha budakai thoŋgo mbe iyetoeŋge gharɨgharɨ thovuthovuye inanji gheko?” I gonjoghawe iŋa, “Mane ya vakatha bigi regha thoŋgo iyeto thovuthovuye inanji gheko.” ");
INSERT INTO tgo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eibraham iŋa, “Aee, giyana, u ghataŋaghathɨŋgo na mbowo ya utuva e ghen. Thoŋgo raŋama mbe theiwoko kaiwanji eŋge inanji gheko?” I gonjoghawe iŋa, “Theiwoko mane ya mukuwo ghembako iyako.” ");
INSERT INTO tgo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Eibraham mbowo i naŋgoweva iŋa, “Aee, ne u ndegaithɨ wanaŋgo, ko ma u vatomwe eŋge na ya lavaito vara mbaŋara. Naka mbema theyaworo eŋge thovuthovuye inanji Sodom tɨne?” I gonjoghawe iŋa, “Theyaworoko e idanji mane ya mukuwo ghembako iyako.” ");
INSERT INTO tgo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mbaŋa Giya Loi kaero i utuvao weiye Eibraham kaero i itete na iwa na Eibraham i njogha e ghambae. ");
INSERT INTO tgo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Vama yeghɨyeghɨye moli amba nyao thovuye theghewo vethɨ vutha Sodom. Lote va ina i yaku e ghembako ghamba ru. Mbaŋa i thuweŋgi, i yondovirɨ na i mena i kururu e thelauko vwatae e ghamwanji. ");
INSERT INTO tgo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","I dage weŋgi iŋa, “Giyagiyana, aee wo hu mena vara ru elo ŋgoloko na hu latowowe. Ne hu thavwiya gheghemi na wo ra laghena noroke gougou, na evole mbaŋambaŋa ko amba hu wava.” Thɨ gonjoghawe thɨŋa, “Maa valɨkaiwae, mbema wo ghena vara eto gheke ŋgora gharɨgharɨke lenji ghamba mevathavatha.” ");
INSERT INTO tgo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ko iyemaeŋge Lote mbe i rovurɨgheghe vara weŋgi gheghad thɨ varaeŋna le renuwaŋako na thɨ wa weinji ele ŋgolo. Mbaŋa vethɨ ru, Lote i vivatha ghanɨŋga, i ŋambu bred ma weiye isɨt na thɨ ghan. ");
INSERT INTO tgo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Giyagiyama theghewo vamba e laghalaghanji kaero ghɨmoghɨmoruko wolaghɨye Sodom e ghembako laghɨye tɨne, tabwagha na amalaghɨsarɨ, thɨ rakamena thɨ ndeghɨliŋa ŋgoloko. ");
INSERT INTO tgo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kaero thɨ kularu weya Lote thɨŋa, “Ghɨmoghɨmoruma theghewo iya me yeghɨyeghɨyenja na thɨ menama e ghen aŋga inanji? U vaŋguraŋgiyaŋgima etoke na mbala wo vakatha yathima thanavuniye weimaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lote i raŋgi eto na i thɨkiya thɨnɨmbama e ghereiye, ");
INSERT INTO tgo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","na iŋa, “Aee wouna, thava hu utuŋa thanavu raitharɨ ŋgoreiyena. ");
INSERT INTO tgo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ko thoŋgo lemi renuwaŋa ŋgoreiyena, lo ŋgaŋga theunyiwo, amba maa thɨ vavaghena. Wo ya vaŋguraŋgiyaŋgi e ghemi na the renuwaŋa nuwamiya hu vakatha weŋgi. Ko thava hu utuŋa tharɨ utuniye na i ghembeŋgiya giyagiyake thiyake, kaiwae kaero methɨ ru elo ŋgoloke na inanji elo gana tɨne.” ");
INSERT INTO tgo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ko iyemaeŋge thɨ gonjogha weya Lote thɨŋa, “U roiteta thɨnɨmbana. Ghen bwabwariya ghen! Thela ghen u munjekeva ne u utuveime the thanavuya ne wo vakatha? Nuwaniya wo vakatha vuyowo laghɨye e ghen na i kivwala ne wo vakatha weŋgi?” Thɨ mwanavewo Lote na thɨ ndethaiya thɨnɨmbama na thɨ munjeva thɨ tagaraka. ");
INSERT INTO tgo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ko iyemaeŋge nyaoma thovuthovuye e ŋgoloko tɨnema thɨ lawe Lote, thɨ mwana vaŋguruwo e ŋgoloko tɨne na thɨ tagatumo thɨnɨmbama. ");
INSERT INTO tgo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Amba thɨ vakathaŋgiya ghɨmoghɨmoruma, tabwagha na amalaghɨsarɨ, iya inanjima e mbwaŋaŋgilako na maramaranji thiya kwaghe, na mbala maa thɨ thuwe mbwaŋaŋgilako. ");
INSERT INTO tgo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nyaoma thovuye theghewoma thɨ vaito Lote thɨŋa, “Thare ghan mbandɨmbandɨ reghava ina e ghembake tɨne — ŋgoreiya len ŋgaŋga ghɨmoghɨmoru na wanakau, oghendiya o thelava e ghanuke tɨne? Thoŋgo ŋgoreiye e mbaŋake vara iyake u vaŋguraŋgiyaŋgi, ");
INSERT INTO tgo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kaiwae noroke wo mukuwo ghembake iyake. Giya Loi kaero i loŋwe gharɨgharɨ gharenji le vɨrɨ, ghembake iyake gharɨgharɨniye lenji tharɨ i laghɨye moli, iya kaiwae menda i variyeime na wo mena wo mukuwo.” ");
INSERT INTO tgo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lote i wa na ve dage weŋgiya ghɨmoghɨmoruma, iya le ŋgaŋga theunyiwoma thɨ munje thɨ vaŋguŋgi iŋa, “Hu yoruku na ra iteta ghembake iyake, kaiwae Giya Loi noroke i mukuwo ghembake iyake.” Ko iyemaeŋge oghendiyaya thɨŋava i vakatha goron. ");
INSERT INTO tgo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mbaŋa kaero i ghere buruburuko rɨghe, nyaoma thovuthovuye thenjighewo thɨ vavothaŋa Lote thɨŋa, “U yoruku! U vaŋguŋgiya len wevo na len ŋgaŋga theunyiwo iya inanjina gheke na hu vo, ne iwaeŋge hu vaidiya vuyowoke iya ghembake iyake ne thɨ vaidi.” ");
INSERT INTO tgo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lote va i roroghagha seiwo, ko iyemaeŋge kaiwae Giya Loi va ghare i njaweŋgi, nyaoŋgima thovuthovuye thɨ vaŋgu Lote, levo na le ŋgamaŋgama theunyiwo e nɨmanɨmanji na thɨ vaŋguraŋgiyaŋgi e ghembako tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mbaŋa kaero inanji eto, amalama regha i dage weŋgi iŋa, “Hu yoruku hu voiteta valɨvaŋgake iyake na hu vamora yawalɨmi. Ne hu ndeghɨmaranjogha e ghereimi na ne hu ndetowo e malamona tɨne. Hu ruku na i wa e ououko rɨgherɨghenji mbala maa hu vaidiya mukuwoko.” ");
INSERT INTO tgo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ko iyemaeŋge Lote i gonjogha weŋgi iŋa, “Aee wogiyagiya thovuthovuye, thava ŋgoreiyako. ");
INSERT INTO tgo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Kaero ghemi gharemi i nja weŋgo na ya vaidiya lemi thalavu laghɨye mohu vamora yawaliŋgu. Ko maa valɨkaiwaŋgu eŋge ya vo na i ruwoko e ououko rɨgherɨghenji, mbwatane mukuwoko i lavaidiŋgo na ya mare. ");
INSERT INTO tgo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mbe u thuwe ghemba nasiye iyako? Maa i bwagabwaga, valɨkaiwae ya vowawe na ya vamora yawaliŋguwe.” ");
INSERT INTO tgo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nyaoma thovuye i dagewe iŋa, “I thovuye, ne ya vakatha ŋgoreiya len renuwaŋana. Mane ya mukuwo iya ghemba ne vorunawe. ");
INSERT INTO tgo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ko mbema u wa eŋge, nɨman i maiya, kaiwae amba mane ya vakatha bigi regha gheghad vo vutha gheko.” (Kaiwae Lote va iŋa nasiye iya kaiwae ghembako idae Jowa.) ");
INSERT INTO tgo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mbaŋa Lote ve vutha Jowa varae kaero i yovoro. ");
INSERT INTO tgo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Amba Giya Loi i vakatha varɨvarɨ ndaŋaŋanje na sulpa i rara ŋgoreiya uyema i nja Sodom na Gomora. ");
INSERT INTO tgo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","E kamwathɨko iyako mbema i mukuwoŋgi vara ghembaghemba e valɨvaŋgako iyako. Ma tembe lolo reghava e yawayawaliye na tembe ŋgoreiyeva nana na umbwaumbwa. ");
INSERT INTO tgo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ko iyemaeŋge Lote levo i ghɨmaranjogha e ghereiye na kaero i gharavɨ na varɨ ŋgoreiya njighɨ. ");
INSERT INTO tgo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Eibraham i gheneiru yanɨmbaŋambaŋa na tembe i njoghava ŋgora menda i ndeghathɨ Giya Loi e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","I tagathɨna marae na i nja Sodom na Gomora na ghawoko laghɨye e malamoko tɨne. I thuwe mundu i ŋgothighevirɨ e valɨvaŋgako iyako, ŋgoreiya thɨ rɨmba njamɨra. ");
INSERT INTO tgo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ko mbaŋa Loi i mukuwoŋgiya ghembaghemba e malamoko iyako tɨne, i renuwaŋakikiya Eibraham na i vaŋguraŋgiya Lote vuyowoko e tɨne, na i mukuwoŋgiya ghembaghembako Lote va i yakuko weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kaiwae Lote va weiye le mararu Jowa e tɨne, weiyaŋgiya oyawarumbuyeŋgima theunyiwo, thɨ wa e ououko rɨgherɨghenji na vethɨ yaku e maŋgavarɨ. ");
INSERT INTO tgo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mbaŋa regha yawarumbuye laghɨyeniye i dage weya nasiyeniyema iŋa, “Kaiwae ramanda kaero i thanja, na ma ghɨmoghɨmoru nanji gheke na valɨkaiwae ra vaŋguŋgi, kaiwae yambaneke thanavuniye iyako, na ra ghambɨ weindaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ra vakatha ramanda na i muna waen laghɨye moli na i vakatha numounounowe, ko amba ra ghena weinda mbala ra ghambɨ weinda na gheuke mbe i mbele vara amalaghɨniye.” ");
INSERT INTO tgo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Gougouko iyako thɨ giya waen weya ramanji na i mun. Laghɨyeniye i ghena weiye. Kaiwae me muna waen laghɨye moli, maa ele ghareghare ŋgoroŋga yawarumbuye le vakathawe. ");
INSERT INTO tgo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mbaŋambaŋavena yawarumbuye laghɨyeniye i dage weya nasiyeniye iŋa, “Me gougou ma ghena weiŋgu ramanda. Noroke mbowo ra vakatha na i munɨva waen laghɨye, ko amba ghen vo ghena wein, mbala ra ghamba gamagai weinda na gheuko mbe i mbele vara amalaghɨniye.” ");
INSERT INTO tgo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Na gougouko iyako thɨ vakatha ramanji tembe i munɨva waen laghɨye moli, ko amba nasiyeniye i wa na ve ghena weiye. Kaiwae me muna waen laghɨye moli, maa ele ghareghare ŋgoroŋga yawarumbuye le vakathawe. ");
INSERT INTO tgo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lenji vakathako iyako une mbe theunyiwo vara thɨ thɨn. ");
INSERT INTO tgo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yawarumbuye laghɨyeniye i ghamba ŋgama ghɨmoru, na i rena idae Mowab. Iye orumburumbuyeŋgiya Mowab gharɨgharɨniye ");
INSERT INTO tgo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Yawarumbuye nasiyeniye vambe i ghambɨva ŋgama ghɨmoru, na i rena idae Ben-Ami. Iye orumburumbuyeŋgiya Amon gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","E mbaŋako iyako Eibraham i ri Memri na i loŋga na i wa Kenan e yaghalaniyeko, na ve yaku vara Kades na Sur e ghanjilughawoghawo, e ghemba regha idae Gera. ");
INSERT INTO tgo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Mbaŋa va ina gheko i dage weŋgiya gharɨgharɨ iŋava louya iya levo Sera. Iwaeŋge Abimelek, Gera ghakiŋ iŋa na Sera i menawe na i munjeva levo. ");
INSERT INTO tgo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Gougou regha Loi i yomara weya Abimelek ghenelolo e tɨne na i dagewe iŋa, “Emunjoru ne u mare kaiwae menda uŋa na thɨ vaŋgumena wevoke iyake e ghen. Elana iyana kaero i ghe.” ");
INSERT INTO tgo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ko iyemaeŋge Abimelek amba maa i ghenethaiya elako, iya kaiwae iŋa, “Loi, maa ya vakatha mun tharɨ. Ne uŋa na ya mare weiŋguyaŋgiya gharɨgharɨ ya mbaroŋaŋgike? ");
INSERT INTO tgo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Mbe Eibraham ghamberegha mendava i dage weŋgo iŋa, ‘Louya elako’, na elaghɨniye tembe iŋava, ‘Louya amalako’. Menda ya vakatha iyako weiye lo renuwaŋa thovuye na menda yaŋaeŋge lo vakathako i thovuye moli.” ");
INSERT INTO tgo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Amba Loi i dagewe ghenelolo e tɨne iŋa, “Ya ghareghare mo vakatha iyana weiye len renuwaŋa thovuye, iya kaiwae ma vakathaŋge ma valɨkaiwan u vakatha tharɨ e maraŋgu, na tembe ŋgoreiyeva ma vakathaŋge na ma mo ghena wein. ");
INSERT INTO tgo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","E mbaŋake iyake u vaŋgunjogha elana weya le ghɨmoru, kaiwae amalaghɨniye ghalɨŋaŋgu gharautu. Tene i naŋgo kaiwan mbala ma u mare. Ko iyemaeŋge thoŋgo maa u vaŋgu njogha weya le ghɨmoru, ghen na ghanɨyayaona ne huya mare.” ");
INSERT INTO tgo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Vambe mbaŋambaŋa Abimelek kaero i thuweiru, i kulavathaŋgiya le rakakaiwo e raberabe, na i utu giya bigibigiko wolaghɨye methɨ yomarawe, na i vakathaŋgi thɨ mararu laghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Amba Abimelek i kularuwo Eibraham na i dagewe iŋa, “Mbala thava mo vakatha ŋgoreiyake weime. Ma vakatha vatharɨ the bigi e ghen, iya i vakathaŋge na u womena vuyowoke iyake e ghino na elo ghamba mbaroke tɨne? Budakaiya mo vakatha maa lolo regha ne i vakatha e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek i vaito Eibraham iŋa, “Buda kaiwae mo vakatha ŋgoreiyake?” ");
INSERT INTO tgo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Eibraham i gonjoghawe iŋa, “Menda lo renuwaŋa yaŋaeŋgeva maa lolo regha ina gheke i yavwatatawana Loi, na ne iwaeŋge thɨ unɨghɨŋgo lo wevoke bayae. ");
INSERT INTO tgo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Emunjoru elaghɨniye louŋgu. Ramame regha weiŋgu, ko tɨnae eŋge mbe regha, na iyava ya vaŋguke. ");
INSERT INTO tgo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na mbaŋa Loi va i dage e ghino na ya iteta bwebwe ghambae na ya wa e valɨvaŋga regha, iwaeŋge ya dagewe yaŋa, ‘Thoŋgo gharen e ghino, mbaŋa regha na regha ra vaidiŋgiya gharɨgharɨ, mbala mbe uŋa vara, “Louŋgu.” ’” ");
INSERT INTO tgo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Amba Abimeleki i vaŋgunjogha Sera weya Eibraham na tembe i giyava ghamwaewa sip, kau na rakakaiwoŋgi ghɨmoghɨmoru na wanakau. ");
INSERT INTO tgo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki i dagewe iŋa, “Kaero u thuwe lo ghamba mbaroke, the valɨvaŋga nuwaniya u wa na vo yakuwe.” ");
INSERT INTO tgo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","I dage weya Sera iŋa, “Ya giya weya lou Eibraham silva gethɨserithaŋarɨ na i vaemunjoruŋa weŋgiya thavala weiŋji, mbema emunjoru maa e len tharɨ na taulaghɨke mbala thɨ ghareghare ma menda u vakatha tharɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Amba Eibraham i naŋgo weya Loi na Loi i vamoruŋgiya Abimeleki levo na le rakakaiwo wanakau na mbala valɨkaiwae mbowo thɨ ghambɨva gamagai, ");
INSERT INTO tgo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","kaiwae Abimeleki mendava i vaŋgwa Sera Eibraham levo, na ve ghena ele ŋgolo iya kaiwae Giya Loi i gokiŋgiya wanakau ele ŋgoloko tɨne, mbala maa valɨkaiwae thɨ ghambɨ. ");
INSERT INTO tgo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Giya Loi i worawa Sera e ghamwae ŋgoreiya va le dagerawe, na i vamboromboroŋa ŋgoroŋga va le dagerakowe. ");
INSERT INTO tgo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sera i thɨn na kaero gha mbaŋa i ghambɨ. I ghamba ŋgama ghɨmoru weiye Eibraham, mbaŋa kaero i amalaghɨsarɨ moli, ŋgoreiya Loi va le dagerakowe. ");
INSERT INTO tgo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Eibraham i rena ŋgamako Sera i ghambɨko idae Aisake. ");
INSERT INTO tgo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Mbaŋa theghewa e tɨne Eibraham i kitena Aisake riwae njimwae mbothiye ŋgoreiya Loi va i utugiyawe. ");
INSERT INTO tgo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Mbaŋa Aisake i virɨ Eibraham ghatheghathegha vama i wo hothaŋarɨ. ");
INSERT INTO tgo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sera iŋa, “Loi kaero i vakathaŋgo na ŋgoreiye, i woveŋgwa warari weiye lo vavɨrɨ na thavala ne thɨ loŋwa iyako ne thɨ vavɨrɨ budakai menda i yomara e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Na mbowo iŋava, “Thela mbala va i dage weya Eibraham na iŋava Sera valɨkaiwae i vathu ŋgama? Iyemaeŋge kaero ya ghambɨ weiŋgu mbaŋa kaero i amalaghɨsarɨ moli.” ");
INSERT INTO tgo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mbaŋa Aisake kaero i laghɨye na i rɨtena thu, Eibraham i vakatha vawarari ghathaga laghɨye regha. ");
INSERT INTO tgo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ko iyemaeŋge e vawarariko tɨne Sera i thuwe Heiga, tɨnan Ijipt, nariye weiye Eibraham, i vakatha goron weya Aisake, ");
INSERT INTO tgo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","iwaeŋge i dage weya Eibraham iŋa, “U variyeyathuŋgiya rakakaiwoko iyako weiye nariyeko. Ghino yaŋa nariyeko mane te i wova bigi regha e ghen. Naruŋguke Aisake ghamberegha moli ne i mbaroŋa ghanɨyayaona.” ");
INSERT INTO tgo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Renuwaŋako iyako i vakatha Eibraham i rerenuwaŋa laghɨye moli, kaiwae amalaghɨniye mbe nariyeva Ismel. ");
INSERT INTO tgo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ko amba Loi i dagewe iŋa, “Tha u rerenuwaŋa Sera le utuko e ghen kaiwae. U vakatha ŋgora iya le renuwaŋana, kaiwae orumburumbuma va ya dagerawema e ghen ne thɨ mena weya Aisake. ");
INSERT INTO tgo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ko iyemaeŋge iya Heiga nariyena ne ya vakathana orumburumbuye tembe lemoyova, kaiwae ghen mbe narun reghava.” ");
INSERT INTO tgo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Vambe mbaŋambaŋa Eibraham kaero i thuweiru, i mbana ghanɨŋga na mbwa ina e begi thetheghan njeniye, i bigirawe Heiga e ŋgɨleŋgɨle na i variyeyathu weiye nariyema. Heiga na nariye Ismel mbema thɨ loŋga takwe eŋge vara Beyasiba vuruvuruko vwatavwata. ");
INSERT INTO tgo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mbaŋa kaero thɨ munɨvao mbwama e begima, Heiga kaero i worawa ŋgamama e riburibu nasiye ");
INSERT INTO tgo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","na ve yaku seiwo bwagabwaga weya ŋgamama, kaiwae va le renuwaŋa iŋa, “Maa valɨkaiwaŋgu ya thuwe naruŋguke i mare.” Mbaŋa ve yakuyaku gheko, kaero i randa. ");
INSERT INTO tgo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ko mbaŋa Loi i loŋwe ŋgamama i randaranda, amba le nyao thovuye regha i kula na i njama weya Heiga iŋa, “Heiga, buda i gharɨŋge? Tha u mararu. Loi kaero i loŋweya iya ŋgamana i randa. ");
INSERT INTO tgo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","U wa na vo mwanavaira ŋgamako e nɨmae, kaiwae nevole ya vakathaŋgiya orumburumbuye thɨ tabo na vanautuma laghɨye regha.” ");
INSERT INTO tgo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Amba Loi i vakatha na i thuwe mbwarowou evasiwae. I wa iyana ve ghendɨvanjara mbwama ghabegi na i giya weya nariyema i mun. ");
INSERT INTO tgo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mbaŋa ŋgamako i tabo Loi vambe weiye vara. Lenji yakuyaku Paran e vuruvuru vwatavwata, Ismel i tabo na rawowoidi thovuye regha e mbwenara. ");
INSERT INTO tgo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Lenji yakuyaku e valɨvaŋgako iyako e tɨne, tɨnae i vaŋguya tɨnan Ijipt eunda na levo. ");
INSERT INTO tgo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Va e mbaŋako iyako Abimeleki weiye le ragagaithɨ lenji randeviva idae Pikol, thɨ wa weya Eibraham na Abimeleki iŋa, “Wein Loi e len vakathake wolaghɨye e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Iya kaiwae u tholo e maraŋgu Loi e marae, mane u vakatha tharɨ regha e ghino, lo ŋgaŋgake na orumburumbunji. Ŋgoreiye va ghino ya vakatha valaŋa vakatha thovuye weiye emunjoru e ghemi, ko ghen u dagerawe e ghino noroke tembene u vakatha ŋgoreiyeva e ghino na vanautumake iya u mebwabwarikewe.” ");
INSERT INTO tgo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Eibraham i gonjoghawe iŋa, “Kaero ya dagerawe Loi e marae.” ");
INSERT INTO tgo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Amba Eibraham i ghatiwogiya weya Abimeleki mbwarowou regha amalaghɨniye va i tɨghɨ, ko iyemaeŋge Abimeleki le rakakaiwo thɨ wogaithɨten. ");
INSERT INTO tgo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki i dagewe iŋa, “Maa ya ghareghare thela i vakatha thanavuna iyana. Ma mbaŋa regha u giya yanawaŋgu. Ambama iya vara noroke ma loŋwevaidike.” ");
INSERT INTO tgo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Iyake kaiwae Eibraham i bigimena sip na kau na i giya weya Abimeleki na mbe thenjighewoko vara thɨ vaemunjoruŋa lenji tubweko. ");
INSERT INTO tgo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Eibraham i ghethevakatha sip nanariye umbopirɨ wanakauŋgi, ");
INSERT INTO tgo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","na kaiwae Abimeleki i vaito Eibraham iŋa, “Buda kaiwae mo vakatha ŋgoreiyako?” ");
INSERT INTO tgo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eibraham i gonjoghawe iŋa, “U mbana sipɨke iya umbopirɨke weŋgo na i vaemunjoruŋa mbwarowouko iyako ghino va ya do.” ");
INSERT INTO tgo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Iya kaiwae ghembako iyako idae Beyasiba, kaiwae va gheko giyagiya thenjighewo thɨ vakatha lenji tubwekowe. ");
INSERT INTO tgo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mbaŋa thɨ vakatha lenji tubweko iyako Beyasiba e tɨne na e ghereiye, Abimeleki weiye Pikol, iye le ragagaithɨ lenji randeviva, thɨ njogha Pilistiya gharɨgharɨniye e lenji ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","E ghereinji Eibraham i kabwa umbwa regha idae isel Beyasiba. Na gheko i kururu weya Giya Loi, iye Loi Memeghabananiye. ");
INSERT INTO tgo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Eibraham i yaku Pilistiya e tɨne mbaŋa molao. ");
INSERT INTO tgo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Theghathegha umboviye e ghereiye Loi i mandoya Eibraham. I dagewe iŋa, “Eibraham!” Eibraham i gonjoghawe iŋa, “Mbe ghinoke.” ");
INSERT INTO tgo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Amba Loi iŋa, “U vaŋwa naruna, mbereghanaeŋge, Aisake, iya mbe gharenɨnawe vara, na wein hu wa e valɨvaŋga idae Moraiya. Vo vowoŋa gheko e ou regha ne ya vatomwe e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Vambe mbaŋambaŋa Eibraham kaero i thuweiru, i getha ndɨghe vowoko kaiwae, i dowe e doŋɨki vwata, i vaŋwa Aisake na le rakakaiwo theghewo weiyaŋgi. Kaero thɨ wareriŋa ghembako iya Loi menda i govatomwekowe. ");
INSERT INTO tgo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Mbaŋa theghetoninji e tɨne Eibraham i tagathɨna marae kaero i thuwe ouko amba bwagabwaga e ghamwanji. ");
INSERT INTO tgo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kaero i dage weŋgiya le rakakaiwoma iŋa, “Mbe hu yaku vara gheke weimi doŋɨkike na ghinoeŋge na Aisake vwo voro e ouko, na vwo kururuwe amba wo njoghama e ghemi.” ");
INSERT INTO tgo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eibraham i thɨna vowoma ghandɨghe na i thɨnɨrawe Aisake e ŋgɨleŋgɨle na amalaghɨniye i wo kaina na i yeŋge ndɨghe. E lenji loŋga tɨne ");
INSERT INTO tgo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisake i vaitoya ramae Eibraham iŋa, “Bwebwe?” Ramae i gonjoghawe iŋa, “Ŋgoroŋga naruŋgu?” Aisake iŋa, “Ndɨghe undɨundɨye na ndɨghe une maiyake, ko naka sip nariye vowoko kaiwae?” ");
INSERT INTO tgo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Eibraham i gonjoghawe iŋa, “Loi ghamberegha tene i wogiya regha weinda.” Kaero vethɨ loŋgaloŋgaova. ");
INSERT INTO tgo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Mbaŋa vethɨ vutha e valɨvaŋgako iya Loi mendava i vatomwekowe, kaero i vatad ghamba vowoma na i ghara ndɨghe undɨundɨye e vwatae. I ŋgara nariye Aisake gheghe na nɨmanɨmae na i wo na i worawe e ndɨghema vwatae. ");
INSERT INTO tgo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Eibraham i mwanavaira kainama na i munje i votena nariye nuwae. ");
INSERT INTO tgo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ko iyemaeŋge Giya Loi le nyao thovuye i kulanjamawe e buruburu iŋa, “Eibraham! Eibraham!” I gonjoghawe iŋa, “Mbe ghinoke.” ");
INSERT INTO tgo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Iŋa, “Ne u ndevakatha bigi reghawe. Mbaŋake kaero ya ghareghare u yavwatatawana Loi, kaiwae maa mo vaghareghare naruna iya gharenɨnawe e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Eibraham i ghɨmara ghewo i thuwe sip ghɨmoru i wona e ghasokisoki. I wa ve wo na i rothɨgha nariye Aisake, i vowo weya Loi. ");
INSERT INTO tgo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Iya kaiwae Eibraham i rena valɨvaŋgako iyako “Giya Loi Ne i Wogiya.” Othembe mbaŋake noroke gharɨgharɨ thɨŋa, “Giya Loi ele ou vwatae ne i wogiya.” ");
INSERT INTO tgo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mbaŋaiwoniye Giya Loi le nyao thovuye mbowo i kulaweva Eibraham e buruburu ");
INSERT INTO tgo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","iŋa, “Ghino Giya Loi ya tholo e idaŋgu na ya dagerawe e ghen, emunjora ne ghareŋgu e ghen kaiwae mo vakatha ŋgoreiyako na maa mo vaghareghare naruna ghamberegha moli. ");
INSERT INTO tgo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Emunjoru mbene ghareŋgu vara e ghen, na ne ya vakathaŋgiya orumburumbu lemoyo moli ŋgoranjiya ghɨtara e buruburuko na kerakera e njighɨko ghadidiye. Orumburumbu ne thɨ kivwalaŋgiya ghanjithɨghɨyaŋgi na tembe ŋgoreiyeva ghambaghambanji laghɨlaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Orumburumbu weŋgi ne ya mwaewo weŋgiya vanautumake wolaghɨye e yambaneke, kaiwae menda u ghambu lo renuwaŋake.” ");
INSERT INTO tgo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Amba Eibraham na nariye thɨ njogha weŋgiya rakakaiwoma, na thɨ rakanjogha na regha Beyasiba na Eibraham mbowo i yaku vara gheko. ");
INSERT INTO tgo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bigibigiko thiyako e ghereinji amba Eibraham i loŋwevaidiya ghaghae Neiho na levo Milika mbe thɨ ghambɨva. ");
INSERT INTO tgo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ujɨ iye virɨ viva, ghaghae Bajɨ, Kemuwel (nariya Aram), ");
INSERT INTO tgo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keised, Heijo, Pildas, Jidlap na Betuwel, ");
INSERT INTO tgo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","iye Rebeka ramae. Milika va i ghambɨŋgiya ghɨmoghɨmoruke iya theghewake weiya Neiho Eibraham ghaghae. ");
INSERT INTO tgo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Neiho le rakakaiwo na levo vaŋgavaŋga idae Riyuma vambe i ghambɨva weiye. Le ŋgaŋgaŋgiya Teba, Gaham, Tahas na Maka. ");
INSERT INTO tgo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera yawaliye le molamolao theghathegha hothaŋarɨ hoiwo na umbopirɨ (127). ");
INSERT INTO tgo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Va i mare Kiriyat Aba (mbaŋake thɨ uno idae Hebron) Kenan e tɨne, na Eibraham i nuwatharɨ laghɨye moli le mareko kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Amba Eibraham i roiteta levo riwae na ve thuweŋgiya Het gharɨgharɨniye na iŋa, ");
INSERT INTO tgo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Bwabwariya ghino ya yaku e tɨnemike. Hu vakuneŋa thelauke vuvura e ghino na mbala ya beku lo wevokowe.” ");
INSERT INTO tgo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Het gharɨgharɨniye thɨ gonjoghawe thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Amalana, wo u vandeŋeime. Wo worawa ghan midi na ghen randeviva vurɨvurɨghegheniye regha. The ghabubu thovuye regha ina gheke u tuthi na u bekwa len wevowe. Maa lolo regha ina gheke ne i vaghareghara le ghabubu e ghen na u bekwa len wevowe.” ");
INSERT INTO tgo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Amba Eibraham i yondovirɨ na i kururu e maranji, ");
INSERT INTO tgo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","na iŋa, “Thoŋgo hu warariŋa ya bekwa lo wevoke e lemi thelauke, ghino e idaŋgu wo hu utu weimi Eipron Soha nariye, ghino kaiwaŋgu ");
INSERT INTO tgo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","na mbala i vakuneŋa eŋge maŋgavarɨ regha e ghino ina Makpela. Maŋgavarɨko iyako amalaghɨniyewe ina ele umako mbothiye. Ŋgoroŋga modae, ne ya vamoda ŋgoreiye na lo ghamba beku kaka e tɨnemike.” ");
INSERT INTO tgo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","E mbaŋako iyako Eipron vambe ina gheko weiyaŋgiya ghauneko i vandeŋe Eibraham le utuko. Giyagiyako wolaghɨye methɨ rakamenako weiyaŋgi e ghamba mevathavatha ŋgora ghamba ruko, e maranji Eipron i thombeya Eibraham le renuwaŋako iŋa, ");
INSERT INTO tgo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Amalana, maa valɨkaiwae mbema ya vatomwe eŋge maŋgavarɨ, mbema weiye vara thelauna iya inanɨnawe. Wouneke wolaghɨye e maranji ya vatomwe e ghen na u bekwa len wevowe.” ");
INSERT INTO tgo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Eibraham mbowo i kururuva Het gharɨgharɨniye e maranji, ");
INSERT INTO tgo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","na i dage weya Eipron gheuneko e maranji iŋa, “Wo u vandeŋeŋgo. Mbemane ya vamoda vara thelauko iyako. U wovatha lo renuwaŋake na mbala ya wo lo wevo na va wobeku gheko.” ");
INSERT INTO tgo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eipron i gonjoghawe iŋa, ");
INSERT INTO tgo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Wo u vandeŋeŋgo, wo giya laghɨye, thelauko modae le ghanaghanagha silva gethɨseriyevarɨ (400). Ko buda kaiwae ghen na ghino ra rerenuwaŋa modo kaiwae. U vamodo e ghino na mbema u wa eŋge na vo bekwa len wevona.” ");
INSERT INTO tgo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eibraham i warariŋa iya modoko Eipron me woraŋgiyako. I wa ve sikeliya silvama gethɨseriyevarɨ (400) ŋgoreiya Eipron me woraŋgiyama gharɨgharɨko wolaghɨye e maranji. Thɨ sikeli ŋgoreiya rakunekune na ra vavamodo lenji vakatha e maket. ");
INSERT INTO tgo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Iyako ra thuwe va ŋgoroŋga na Eipron le thelau weiye maŋgavarɨ na umbwaumbwa nanji e tɨne ina Makpela, Memri valɨvaŋga i vorovoro, va i vakuneŋa ");
INSERT INTO tgo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","weya Eibraham na kaero le ghamba mbaro, le ghavalɨ Het e maranji iya vathɨ raka e ghamba mevathavathako. ");
INSERT INTO tgo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Vamodoko e ghereiye, Eibraham i bekwa levo Sera e maŋgavarɨko. Maŋgavarɨko ina Hebron Kenan e tɨne Memri valɨvaŋga i vorovoro. ");
INSERT INTO tgo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Iyako ra thuwe ŋgoroŋga na Eibraham va i wo thelauko iyako weiye maŋgavarɨko ina e tɨne na le ghabubu. Het loloniye i vakuneŋawe. ");
INSERT INTO tgo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Eibraham vama i amalaghɨsarɨ moli na Giya Loi vambe weiye vara ele vakatha nasiye na laghɨye e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Mbaŋa regha i dage weya le rakakaiwo, iye valɨghareghare, e ghayayaoko tɨne, iŋa, “U lirawa nɨman e vavaŋguke raberabe. ");
INSERT INTO tgo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nuwaŋguiya u tholo na u dagera weya Giya Loi, iye buruburu na yambane ghanji Loi, na mane u vaŋgwa tɨnan Kenan na naruŋguke levo. ");
INSERT INTO tgo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ko iyemaeŋge tembene u wa e ghambaŋgu moli weŋgiya lo bodaboda na vo vaŋgwa naruŋguke Aisake levo.” ");
INSERT INTO tgo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Eibraham le rakakaiwo i vaito iŋa, “Ko thoŋgo wevoko maa nuwaiya i njoghama weiŋgu? Ne ŋgoroŋga? Ne ya njoghama na ya vaŋgwa naruna na ya yovaŋgu e vanautumako iya u menakowe?” ");
INSERT INTO tgo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Eibraham i gonjoghawe iŋa, “U mando na thava u yovaŋgwa naruŋguke gheko. ");
INSERT INTO tgo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Giya Loi buruburu gha Loi, iye va i vaŋguraŋgiyaŋgo weŋgiya lo bodaboda na e vanarɨgheŋgu, amalaghɨniye va i dagerawe e ghino iŋa, ‘Weŋgiya orumburumbu ne ya vatomwe valɨvaŋgake iyake weŋgi.’ Amalaghɨniye tene i variye le nyao thovuye regha na i viva e ghen, amba ne valɨkaiwae u vaŋgwa naruŋguke levo gheko. ");
INSERT INTO tgo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Thoŋgo wevoko maa le renuwaŋa ŋgoreiye na u njoghamake wein, amba ne len dageraweke weŋgo mane e gharerenuwaŋa e ghino. Ko iyemaeŋge ma tembe gharerenuwaŋa na ne u yovaŋgwa naruŋguke gheko.” ");
INSERT INTO tgo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ko e mbaŋako iyako rakakaiwoma i lirawa nɨmae e ghagiyama vavae raberabe, amba i dagerawe na i tholo renuwaŋako iyako kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kaero rakakaiwoma i vivathaŋgiya ghagiyama le kamel hoyaworo na i wareri. I mbanɨŋgiya tomethi bigibigi thovuthovuye weya ghagiyama. I wareriŋa ghembama Neiho i yakumawe, ina Mesopoteimiya e ghaiwabuko. ");
INSERT INTO tgo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mbaŋa i vutha e ghembama e ghanjimbwa marae, i vakathaŋgiya kamelɨko thɨ ronja e thelauko vwatae. Iyako vama yeghɨyeghɨye na wanakau kaero ghanjimbaŋa thɨ mena thɨ guda mbwa. ");
INSERT INTO tgo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Amba i naŋgo iŋa, “Aee, Giya Loi, wo giyama Eibraham le Loi, u thalavuŋgo na noroke ya vamboromboroŋa lo renuwaŋake na u worawa wo giyako e ghamwan. ");
INSERT INTO tgo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kaero u thuweŋgo ya ndeghathɨ e mbwake ghadidiye na gagamaina e ghembako ne thɨ mena thɨ guda mbwa. ");
INSERT INTO tgo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mbaŋa ne ya dage weya eunda na yaŋa, ‘Aee, wo u ronja na ya muna ghan mbwana mun,’ na iŋa, ‘U mena u mun na wo ya vamunɨŋgiva len kamelɨna’ — mbala ya ghareghare wevoko iyako kaero mendava u tuthi Aisake levo. Iyake ne i vaghareŋgo emunjoru u worawa wo giyako e ghamwan.” ");
INSERT INTO tgo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Rakakaiwoma vamba i naŋgonaŋgo, Rebeka kaero i wovutha ghe mbwa variye. I worawe e ŋgɨleŋgɨle. Elaghɨniye Betuwel yawarumbuye. Amalake iyake Eibraham ghaghae Neiho nariye weiye Milika. ");
INSERT INTO tgo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka iye wevo manɨune eunda na thɨnabwethubwethuru. Va i wa ve guda mbwa e mbwarowouko na kaero i njoghava. ");
INSERT INTO tgo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Eibraham le rakakaiwoma iwaeŋge i rukureghambawe na iŋa, “U giyama ghan mbwana mun ya mun e ghan mbwana variye.” ");
INSERT INTO tgo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","I gonjoghawe iŋa, “Amalana, u mun,” kaero nɨmae i maya na i thɨn njoŋa e ŋgɨleŋgɨle, i ndeghathɨ na i mun. ");
INSERT INTO tgo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mbaŋa i munɨvao kaero Rebeka iŋa, “Wo va guduva len kamelɨke ghanjimbwa na ya vamunɨŋgiwe na valɨkaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Mbema ghena na nɨmaeŋge kaero i liŋgimban vuna mbwama thetheghanɨma e ghanjimbwa ghambae, i rukunjogha e mbwarowouma na mbowo ve guduva kamelɨko kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Amalama mbe i vonjimbughathɨ vara le vakathako, na i rerenuwaŋa thoŋgo emunjora Giya Loi i vamboromboroŋa le renuwaŋako. ");
INSERT INTO tgo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mbaŋa kamelɨko kaero thɨ munvao, rakakaiwoma kaero i woraŋgiya gol, mbothɨmbothɨ ghaghavatha, le vuyovuyowo grem ghewona, na nɨmae ghaghavatha tembe golɨva mbambaiwo thɨ laghɨye na i giyawe. ");
INSERT INTO tgo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Amba i vaito iŋa, “Thela yawarumbuya ghen? Thare valɨkaiwae ne wo ghena rama e le ŋgolo gougouke?” ");
INSERT INTO tgo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","I gonjoghawe iŋa, “Bwebwe idae Betuwel. Ramaya Neiho na tɨnaya Milika.” ");
INSERT INTO tgo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Na mbowo iŋava, “Ghamba ghena i laghɨye mbe inawe na thetheghan ghanji mbe inaweva.” ");
INSERT INTO tgo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Amba rakakaiwoma i ronja e gheghe vuvuye na i kururu weya Giya Loi, ");
INSERT INTO tgo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","iŋa, “Tarawa i voro weya Giya Loi, wo giya Eibraham le Loi. Kaero u vamboromboroŋa len dagerawe na weiye len ghare vatomwe u vamboromboroŋa wo giyako le naŋgo. Ghino kaiwaŋgu Giya Loi kaero mo viva e ghino elo loŋga na u vaŋgughɨdaghɨdaŋgo wo giyako le bodaboda weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Wevoma i rukunjogha e ghemba na i giya tɨnae le ŋgoloko gharayakuyaku yanawanji budakai me yomarawe. ");
INSERT INTO tgo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka louye idae Leiban. Mbaŋa i loŋwe totoma, i yoruku na ve thuweŋgiya gharɨgharɨma e mbwako ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Mbaŋa me thuwe mbothiye ghae na nɨmae ghae e nɨmae na me loŋwe budaiya louyeko me utuŋa amalako ghalɨŋae, i wa weya Eibraham le rakakaiwoko i ndeghathɨ kamelɨko evasiwanji e mbwako ghadidiye, ");
INSERT INTO tgo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","na i dagewe iŋa, “U mena ra wa e ghemba, amalana, ghen Giya Loi i woraweŋge e ghamwae. Buda kaiwae mbe u ndendeghathɨ vara gheke? Kaero ma vivatharaweya ŋgolo kaiwami na thetheghanɨna ghambanji.” ");
INSERT INTO tgo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mbaŋa vethɨ vutha e ŋgolo amalama na ghaune thɨ rakamwandɨ e ŋgolo na Leiban le rakakaiwo thɨ biginjoŋa bigibigi kamelɨko e vwatanji. Thɨ giya kamelɨko ghanji na thɨ guda mbwa amaamalama thɨ thavwiya ghenjiwe. ");
INSERT INTO tgo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kaero thɨ bigirawa ghanɨŋga e marae, ko iyemaeŋge Eibraham le rakakaiwoma iŋa, “Amba maa valɨkaiwae ya ghanɨŋga. I viva wo ya utuŋa e ghemi budakai kaiwae menda ya menake.” Leiban i gonjoghawe iŋa, “Ko u utugiyama weime len rɨghena na menda u menakena.” ");
INSERT INTO tgo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","I dage weŋgi iŋa, “Eibraham le rakakaiwo ghino. ");
INSERT INTO tgo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Giya Loi i mwaewo laghɨye weya wo giyako Eibraham, na kaero i vwenyavwenya laghɨye moli. Giya Loi i vakatha na e le sip, kau, silva na gol lemoyo moli na tembe ŋgoreiyeva le rakakaiwo ghɨmoghɨmoru na wanakau na le kamel na doŋɨki tembe lemoyova. ");
INSERT INTO tgo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Wo giyako levo kaero va i elaghɨsarɨ ko amba i laghamba ŋgama ghɨmoru weiye na bigibigiko wolaghɨye kaero i valawayawe. ");
INSERT INTO tgo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Menda wo giyako i vakathaŋgo na ya tholo ne ya dagerawe ne ya ghambugha le renuwaŋako. Iŋa, ‘Ne u ndetamwa naruŋguke levo gheko, Kenan wanakauniyeke e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ko iyemaeŋge u njogha weŋgiya bwebwe na mbe ghino lo bodaboda weŋgi, na vo vaŋgwa naruŋguke levowe.’ ");
INSERT INTO tgo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Amba ya govaito yaŋa, ‘Ŋgoroŋga ne yaŋa thoŋgo wevoko ne i botewa ya njoghamake weiŋgu?’ ");
INSERT INTO tgo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“I gonjogha e ghino iŋa, ‘Ko iyemaeŋge Giya Loi iya ghino mbaŋake wolaghɨye ya ghambugha le renuwaŋa, tene i variyeya le nyao thovuye na wein na i vakatha len loŋgana e uneune, na mbala valɨkaiwan u vaŋgwa wevo eunda e wo uu tɨne weŋgiya lo bodaboda. ");
INSERT INTO tgo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mbe bigi reghaeŋge vara ne i vakathaŋge na u meraŋgi e len dagerawena iyana e tɨne. Thoŋgo u wa weŋgiya lo bodaboda, na othembe maa thɨ vatomwa wevo e ghen na ne u njoghama nɨmanɨman wein len tholona ghen kaero u meraŋgi e gura.’ ");
INSERT INTO tgo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mbaŋa ma vutha e mbwarowouko ghadidiye, ma naŋgo na yaŋa, ‘Aee, Giya Loi, wo giyako Eibraham le Loi, thoŋgo len renuwaŋa ŋgoreiye, u vakatha lo loŋgake iyake emunjoru na e uneune. ");
INSERT INTO tgo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Kaero u thuweŋgo ya ndeghathɨ e mbwake iyake ghadidiye, thoŋgo thɨnabwethubwethuru eunda i mena i guda mbwa na mbaŋa ne ya dagewe na yaŋa, “Aee, ya muna ghan mbwana mun,” ");
INSERT INTO tgo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","na thoŋgo iŋa, “U mena u mun na va guda mbwa na ya vamunɨŋgiva len kamelɨna,” u vatomwe e ghino menda va ya tutha elaghɨniye wo giyako Eibraham nariye levo.’ ");
INSERT INTO tgo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Amba muyai ya naŋgovao e ghareŋgu, Rebeka i vutha weiye mbwa variye e ŋgɨleŋgɨle. I wa ve nja e mbwarowouko na ve guda mbwa na ya dagewe yaŋa, ‘Aee, ghan mbwana mun ya mun.’ ");
INSERT INTO tgo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Nɨmae i maya i thɨnɨnjoŋa e ŋgɨleŋgɨle na iŋa, ‘U mun na va vamunɨŋgiva len kamelɨko.’ Kaero ya mun na tembe ve vamunɨŋgiva kamelɨko. ");
INSERT INTO tgo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ya govaito yaŋa, ‘Thela yawarumbuye ghen?’ “Iŋa, ‘Betuwel yawarumbuya ghino, Neiho nariye weiye Milika.’ “Amba ya worawa mbothiye ghae na ya bigirawa nɨmae ghae e nɨmanɨmae, ");
INSERT INTO tgo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","amba ya ronja e ghegheŋgu vuvuye na ya kururu weya Giya Loi. E mbaŋako iyako ya taraweŋa Giya Loi, wo giya Eibraham le Loi, kaiwae menda i vaŋgughɨdaghɨdaŋgo weya wo giyako ghaghae ghambae, na e gheuu tɨne ya vaŋgwa nariyeko levowe. ");
INSERT INTO tgo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","E mbaŋake iyake thoŋgo emunjoru gharen i nja weya wo giyako, u utugiyama e ghino; thoŋgo nandere, tembe u utu giyamava e ghino mbala elo ghareghare na ya vakatha budakai na ya njogha.” ");
INSERT INTO tgo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Leiban na Betuwel thɨ gonjoghawe thɨŋa, “Giya Loi menda i vakatha renuwaŋa iyana e ghen. Ma valɨkaiwame tembe wo utuŋava bigi regha e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka mbe iya. U vaŋgu na wein hu wa, kaero wo vatomwe na ve vaŋgwa ghan giyana nariye, ŋgoreiya Giya Loi le renuwaŋana.” ");
INSERT INTO tgo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mbaŋa Eibraham le rakakaiwo i loŋwe lenji renuwaŋako i ronja e thelau vwatae na i vata ago weya Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Amba rakakaiwoma i bigiraŋgiya gol, silva, na kwamakwama na i giya weya Rebeka, na tembe i giyava bigibigi thovuthovuye weŋgiya Rebeka louye na tɨnae. ");
INSERT INTO tgo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ko amba Eibraham le rakakaiwoma na vavanava mendava weiyaŋgima, thiya ghanɨŋga na thɨ ghena gheko gougouko iyako. Mbaŋambaŋavena thɨ thuweiru, kaero i dage weŋgiya wevoko le bodaboda iŋa, “Hu variyeime ma wo njoghava wo giyamawe.” ");
INSERT INTO tgo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ko Rebeka louye na tɨnae thɨŋa, “Mbala wo layaku weime gheneyaworo na e ghereiye, ko amba wein hu wa.” ");
INSERT INTO tgo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ko iyemaeŋge i gonjogha weŋgi iŋa, “Thava tembe hu laweghathɨimeva. Kaero Giya Loi menda i vamboromboroŋa lo loŋgake. Mbema hu viyathuŋgo eŋge na ya njogha weya wo giyako.” ");
INSERT INTO tgo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Thɨ gonjoghawe thɨŋa, “Wo ra kulawe na ra vaito ŋgoroŋga elaghɨniye le renuwaŋa.” ");
INSERT INTO tgo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Iya kaiwae thɨ kulawe na thɨ vaito thɨŋa, “Thare nuwaniya wein amalake iyake?” I gonjogha weŋgi iŋa, “Lo renuwaŋa ŋgoreiye.” ");
INSERT INTO tgo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kaero le bodaboda thɨ variyeyathu Rebeka weiye gharanjimbunjimbu eunda weinji Eibraham le rakakaiwo na ghaune vavanava, thɨ rakanjogha Kenan. ");
INSERT INTO tgo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Thɨ giya Rebeka ghadagemwaewo thɨŋa, “Ghen, loume, nevole gharɨgharɨ mbunja ghalaghalamaŋgo lenji elaghɨ ghen! Ghen orumburumbu nevole thɨ kivwalaŋgiya ghanjithɨghɨyaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka na le rakakaiwo wanakau thɨ tha e lenji kamel, kaero thɨ wareri weinji Eibraham le rakakaiwo. ");
INSERT INTO tgo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisake va i ri Beya Lahai Roi na mbaŋako iyako i yaku Keinan e yaghalaniyeko e valɨvaŋga idae Negev. ");
INSERT INTO tgo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Yeghɨyeghɨye regha i raŋgi na mbe i loŋga weiye le rerenuwaŋa, na mbaŋa i tagathɨna marae, i thuweŋgiya kamel, amba inanji bwagabwaga, thɨ loŋga ghɨdaghɨda. ");
INSERT INTO tgo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Mbaŋa Rebeka i thuwe Aisake, mbema ghe na nɨmaeŋge, i nja ele kamelɨma, ");
INSERT INTO tgo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","na i vaitoya Eibraham le rakakaiwoma iŋa, “Thela iya amalake iya i loŋgaghɨdaghɨdaindake?” Rakakaiwoma i gonjoghawe iŋa, “Giyama ya kaiwomawe.” Rebeka i liya umbaliye ghayaboyabo na i yabo vulula ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Rakakaiwoma kaero i utuŋa bigibigi wolaghɨye weya Aisake mendava thɨ yomarawe ele loŋgako tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Aisake i vaŋgwa Rebeka na i vaŋguruwo tɨnae Sera va ele yoŋathowathowa tɨne. Kaero i vaŋgu na levo na vambe i gharethovuwe vara, ko ambama Aisake ghare i dinja tɨnae le mare na ghanuwatharɨ kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Eibraham mbowo i vaŋguva wevo eunda na levo, idae Ketura. ");
INSERT INTO tgo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","I ghambɨ weiye Eibraham na le ŋgaŋgaŋgiya Jimran, Joksan, Medan, Midiyan, Isɨbak na Sua. ");
INSERT INTO tgo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan le ŋgaŋgaŋgiya Siba na Didan. Didan orumburumbuyeŋgiya Asur gharɨgharɨniye, Letus gharɨgharɨniye na Leyum gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyan le ŋgaŋgaŋgiya Epa, Ipa, Hanok, Abida na Elda. Gharɨgharɨke thiyake Ketura orumburumbuyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Eibraham i valawe ghayayaoko laghɨye weya nariye Aisake. ");
INSERT INTO tgo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Eibraham vambe elaghalagha i giyava Sera ghaemaruwoŋgiko lenji ŋgaŋga ghɨmoghɨmoru ghanjimwaewo, na i variyeyathuŋgi na thɨ wa e boimako vethɨ yakuwe na thava thɨ yaku na regha weinji nariye Aisake. ");
INSERT INTO tgo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Eibraham yawaliye va i molao. Ghatheghathegha vama i wo hothaŋarɨ hwepirɨ na umbolima (175) amba i rumbo vuna ghandɨghe. ");
INSERT INTO tgo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Vama i amalaghɨsarɨ moli, amba i garalawa, ŋgoreiye eŋge orumburumbuyeko. ");
INSERT INTO tgo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Aisake na ghaghae Ismel thɨ bekwa ramanji Eibraham e maŋgavarɨma Makpela e tɨne, Memri ghadidiye. Maŋgavarɨko iyako ina e thelau regha Eibraham va i vamodo weya rara Het idae Eipron, Joha nariye. ");
INSERT INTO tgo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Eibraham vambe i bekwa levo Sera iya e maŋgavarɨko iyako. ");
INSERT INTO tgo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Eibraham le mare e ghereiye, Loi va i mwaewowe nariye Aisake. Na Aisake va i wa na ve yaku Beya Lahai Roi evasiwae. ");
INSERT INTO tgo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Iyake Eibraham nariye Ismel utuutuniye. Va i ghambɨ weiye Heiga tɨnan Ijipt, elaghɨniye Sera le rakakaiwobwaga. ");
INSERT INTO tgo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismel le ŋgaŋga iya idaidanjiyake: Nebaiyot, iye virɨviva, Keda, Adɨbil, Mibɨsam, ");
INSERT INTO tgo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misɨma, Dama, Mesa, ");
INSERT INTO tgo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Haded, Tema, Jeturɨ, Nepis na Kedema. ");
INSERT INTO tgo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wabwi theyaworo na theghewo orumburumbunjiŋgiya thiyake, na idaidanji te vambe thɨ renɨva ghambaghambanjiko na lenji kiyamuŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismel yawaliye le molamolao theghathegha hothaŋarɨ, hweto na umbopirɨ (137); ko amba i rumbo vuna ghandɨghe, ŋgoreiye eŋge orumburumbuyeko. ");
INSERT INTO tgo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Orumburumbuye va thɨ yaku Havila na Sur e ghanjilughawoghawo, Ijipt valɨvaŋga i vorovoro e boimako, i ghembeghembe Asiriya. Mava thɨ yaku na ghamwanji vanaora weinjiyaŋgiya Eibraham orumburumbuye vavanava. ");
INSERT INTO tgo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Utuutuke iyake Eibraham nariya Aisake utuniye. ");
INSERT INTO tgo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisake ghatheghathegha vama i wo hwevarɨ amba i ghe weiye Rebeka wevoko iyako Betuwel (rara Aram, Mesopoteimiya e tɨne) yawarumbuye, na elaghɨniye Leiban louye. ");
INSERT INTO tgo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Kaiwae Rebeka va i kwama, le ghɨmoru Aisake i naŋgo weya Giya Loi kaiwae. Giya Loi va i vamboromboro le naŋgoko na kaero i thɨn. ");
INSERT INTO tgo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kaiwae va gamwaruwoŋgi, gamagaiko thɨ vevovewoŋgi e ŋgamoiye, iya kaiwae iŋa, “Aee, buda kaiwae gamagaike thɨ vakatha kamwathɨke iyake e ghino?” Iwaeŋge ve tamweya gharumwaru weya Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Giya Loi i dagewe iŋa, “Vanautuma theghewo inanji e ŋgamoinɨna, gharɨgharɨna theghewona ne u ghambɨŋgi ne wabwi theghewoŋgi Nasiyeniyena le vurɨgheghe ne i kivwala laghɨyeniyena, Virɨvivana ne i kaiwo weya virɨ reghambana.” ");
INSERT INTO tgo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mbaŋa ŋgamoiye i njivun kaero i ghambɨŋgiya gamwaruworuwo ghɨmoghɨmoruŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Virɨviva va waranjaghanjagha na riwae vulivuliye ŋgoreiya kwama udauda, iya kaiwae thɨ rena idae Iso. ");
INSERT INTO tgo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Theghewoniye i virɨ, ko iyemaeŋge vambe i vinjimbɨ vara virɨ vivako ghe daŋavwa, iya kaiwae thɨ rena idae Jeikob. Aisake ghatheghathegha vama i wo hwewona (60) na mbaŋa Rebeka i ghambɨŋgiya gamagaiko theghewoko. ");
INSERT INTO tgo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Gamagaiko thɨ tabo na kaero bobomaŋgi, Iso iye ra wowoidi thovuye na masemburu na nuwanuwa woidi. Ko iyemaeŋge Jeikob iye va riwouda na vambe rara vara thotho. ");
INSERT INTO tgo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisake va i gharethovu weya Iso, kaiwae nuwae va i ghaŋgo weya thetheghanɨko va ve gabogaboko, ko Rebeka va i gharethovu weya Jeikob. ");
INSERT INTO tgo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mbaŋa regha Jeikob vama i gaga ghileghilema na Iso ghe mbaŋa vara i vuthawe, i mena e njamnjam. Ghare vama i basi. ");
INSERT INTO tgo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","I dage weya Jeikob iŋa, “Nɨman i maya na u giyama bigina sosorona seiwo ya ghan.” (Iya kaiwae va thɨ rena idae Idom.) ");
INSERT INTO tgo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jeikob i gonjoghawe iŋa, “Ne ya giya e ghen, thoŋgo u vatomwa virɨvivana ghe mbaro e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iso iŋa, “Kaero u thuweŋgo? Mbaŋa nasiye ya marenjaŋgu. Virɨ viva ghe mbaro ne i woveŋgwa budakai?” ");
INSERT INTO tgo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jeikob i gonjoghawe iŋa, “I viva wo u tholo na u dagerawe emunjoru ne u vatomwe virɨvivana ghe mbaro e ghino.” Iso kaero i tholo na i vatomwa virɨ vivama ghe mbaro weya Jeikob. ");
INSERT INTO tgo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Amba Jeikob i giya bred na ghileghilema weya Iso. I ghanɨŋga na i muna mbwa, ko amba i yondovirɨ na i wa. Iso mava i goru weya virɨ viva ghambaro. ");
INSERT INTO tgo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Va e mbaŋako iyako vunuvu regha i yomarava e valɨvaŋgako iyako, tembe ŋgoreiyeva Eibraham va ghe mbaŋa. Aisake i wa weya Abimeleki, Pilistiya lenji kiŋ, Gera e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Giya Loi i yomara weya Aisake na i dagewe iŋa, “Ne u ndewa Ijipt; mbe u yaku vara e valɨvaŋgana iyana e tɨne ŋgoreiya ya dagena e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mbe u yaku vara gheke na ghino mbene weiŋgu vara ghen na ne ya mwaewo e ghen. Iya thivathivake iyake ne ya wogiya e ghen na orumburumbu weŋgi. Ne ya vamboromboroŋa dagerawe va ya utura weya rama Eibraham. ");
INSERT INTO tgo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nevole ya giya e ghen orumburumbu lemoyo, lemoyo moli, ŋgoranjiya ghɨtara e buruburuko, na ne ya giya valɨvaŋgake laghɨye iyake weŋgi. Orumburumbu weŋgi vanautumake wolaghɨye ne thɨ naŋgo e ghino na ya mwaewo weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ne ya mwaewo e ghemi, kaiwae Eibraham va i ghambuŋgo na i njimbukikiya lo mbaro na budakaiya va ya utu giyawe.” ");
INSERT INTO tgo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Iya kaiwae Aisake va i yaku Gera. ");
INSERT INTO tgo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mbaŋa ghɨmoghɨmoru e ghembako iyako thɨ vaito levoko kaiwae, i gonjogha weŋgi iŋa, “Elake iyake, iye louŋgu.” Ma valɨkaiwae va iŋa levo kaiwae va i mararu, ne iwaeŋge ghɨmoghɨmoru e ghembako iyako thɨ unɨgha amalaghɨniye na thɨ vaŋgwa Rebeka. Elaghɨniye va wevo manɨune eunda. ");
INSERT INTO tgo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisake vama i yaku gheko mbaŋa molao, na mbaŋa regha Kiŋ Abimeleki i ghɨmaranja ele dedele amba i ghɨmaralambo Aisake na Rebeka thɨ vevanyamonaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Iwaeŋge Abimeleki i kularuwo Aisake na iŋa, “Ko mbema len wevo iyana! Buda kaiwae moŋake loun?” I gonjoghawe iŋa, “Me lo renuwaŋa yaŋa mbwata hu unɨghɨŋgo, thoŋgo yaŋa lo wevo.” ");
INSERT INTO tgo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kiŋ Abimeleki i dagewe iŋa, “Mo vakatha budakai weime? Thoŋgo ghɨmoruke regha me ghena weiye len wevona, ghime mbala wo monjina laghɨye, ko lama vakatha vatharɨke mbe rɨghe vara ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Amba Abimeleki i thɨnɨvathaŋgiya gharɨgharɨko wolaghɨye iŋa, “The lolothan i vakatha vatharɨ weya amalake iyake o weya levoke, loloko iyako ne kaka.” ");
INSERT INTO tgo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisake i kaiwo gheko na i kabu umauma, na e theghatheghako iyako i uloulo na i vatha ghanɨŋga lemoya, lemoya moli, kaiwae Giya Loi va i mwaewowe. ");
INSERT INTO tgo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Aisake i mbanɨvathavathaŋgiya bigibigiko wolaghɨye na e le vakathako iyako ma i vwenyevwenye laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Kaiwae va e le sip, gout na kau lemoyo na le rakakaiwo lemoyo, Pilistiya gharɨgharɨniye thɨ yamwanja kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Iya kaiwae thɨ tɨghɨ tomuŋgiya mbwako wolaghɨye ramae Eibraham vamba e yawayawaliye na le rakakaiwo thɨ doŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Iwaeŋge Abimeleki i dage weya Aisake iŋa, “U iteteime! Kaero len bigibigi na len rakakaiwo lemoyo moli, na kaero u laghɨye kivwalaime.” ");
INSERT INTO tgo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Iya kaiwae Aisake i wareri na ve vakatha le ghamba yaku e malamo idae Gera, na mbowo i yaku gheko mbaŋa ubotu. ");
INSERT INTO tgo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Le rakakaiwo mbowo thɨ tɨghɨ vairɨŋgiva, mbwaŋgima ramae va i tɨghɨŋgima vamba e yawayawaliyema na Pilistiya gharɨgharɨniye thɨ tɨghɨ tomuŋgima, mbaŋa Eibraham va i mare na e ghereiye. Aisake te vambe i renɨva idanjiko iya ramae va i renɨŋgiko. ");
INSERT INTO tgo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aisake le rakakaiwo thɨ tɨgha doda regha e malamoko iyako tɨne na thɨ tɨghɨ vaidiya mbwa. ");
INSERT INTO tgo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ko iyemaeŋge sip gharanjimbunjimbuŋgi Gera e tɨne thɨ wogaithɨ weinjiyaŋgiya Aisake le sip gharanjimbunjimbuŋgi na thɨŋa, “Mbwake iyake ghimewe.” Iya kaiwae Aisake i rena mbwako idae Esek, gharumwaru “Wogaithɨ”. ");
INSERT INTO tgo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Aisake le rakakaiwo mbowo thɨ tɨghɨva regha, na mbowo thɨ wogaithɨva kaiwae, iya kaiwae i ren idae Sitna, gharumwaru “Thɨghɨya”. ");
INSERT INTO tgo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","I roiteta iyako na mbowo i dova regha. Iyako mava e utuutuniye, iya kaiwae i ren idae Rehobot, gharumwaru “Vanathero”. Iŋa, “Mbaŋake iyake, Giya Loi le renuwaŋa ŋgoreiye na ne ra yaku e vanatheroke iyake, na ne ra madi moli.” ");
INSERT INTO tgo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mbaŋa gheviyeŋge e ghereiye Aisake i iteta valɨvaŋgako iyako na kaero i wa Beyasiba. ");
INSERT INTO tgo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Gougouko iyako Giya Loi i yomarawe na iŋa, “Ghino rama Eibraham le Loi, iya va i kururuwe. Tha u mararu bigi regha, ghino mbe weiŋgu vara ghen. Ne ya mwaewo e ghen na ya vakathaŋgi orumburumbu lemoyo moli kaiwae kaero va ya dagera weya lo rakakaiwo Eibraham.” ");
INSERT INTO tgo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Iya kaiwae Aisake i vatada ghamba vowo gheko na i kururu weya Giya Loi. Amba thɨ vatadaŋgi yoŋathowathowa gheko, na le rakakaiwo thɨ tɨgha mbwa regha gheko. ");
INSERT INTO tgo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Mbaŋa thɨ tɨgha mbwako, Abimeleki va i ri Gera weiye Ahusat, gharavanuwovɨrɨ na Pikol, iye ragagaithɨ lenji randeviva, thɨ mena weya Aisake. ");
INSERT INTO tgo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aisake i vaito iŋa, “Buda kaiwae mohu mena hu thuweŋgo, kaerova hu botewoŋgo, na hu vakathaŋgo ya iteta lemi vanautumana?” ");
INSERT INTO tgo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Thɨ gonjoghawe thɨŋa, “Mbaŋake kaero wo ghareghare ghen wein Giya Loi, na wo renuwaŋa valɨkaiwae ra vatadɨ la renuwaŋa regha e ghanda lughawoghawoke. Nuwameiya u dagera weime, ");
INSERT INTO tgo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","maa valɨkaiwae ne hu gaithɨ wanaime. Ghime va ghareme e ghemi iya kaiwae va wo variyeyathuŋga na hu wareri e numomalɨlɨ tɨne. Noroke kaero i manjamanjala weime, Giya Loi i mwaewo na ghare e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aisake i vakatha thaga laghɨye regha kaiwanji, na thiya ghanɨŋga na thɨ munumu. ");
INSERT INTO tgo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Vambe mbaŋambaŋa kaero regha iya i vakatha le dagerawe na i tholo. Aisake i ghaoleŋgi na kaero thɨ tabo na le vɨghathɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","E mbaŋako iyako Aisake le rakakaiwo, thɨ rakamena na thɨ utugiya mbwama methɨ doma utuniyewe. Thɨŋa, “Kaero mwo vaidiya mbwa.” ");
INSERT INTO tgo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I rena mbwako iyako idae Siba, gharumwaru “Tholo”. Iya kaiwae ghaghadɨ noroke ghembako ina e mbwako ghadidiyeko idae Beyasiba. ");
INSERT INTO tgo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Mbaŋa Iso ghatheghathegha vama i wo ghwevarɨ, i vaŋguŋgi Het wanakauniye theunyiwo — Judit, elaghɨniye Biri yawarumbuye, na Basimata, Elon yawarumbuye. ");
INSERT INTO tgo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Va thɨ vakathaŋgi Aisake na Rebeka maa thɨ ndewarariŋaŋgi mun. ");
INSERT INTO tgo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Mbaŋa Aisake vama i amalaghɨsarɨ na maramarae kaero thɨ tharɨ na maa valɨkaiwae i thuwe na thovuye, i variye utu weya nariye Iso we, iye virɨ viva, na i menawe, amba i vaito iŋa, “Naruŋgu?” I gonjoghawe iŋa, “Mbe ghinoke, bwebwe.” ");
INSERT INTO tgo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ramae Aisake i dagewe iŋa, “Wo u vandeŋeŋgo, kaero ya amalaghɨsarɨ na lo mare maa i bwagabwaga. ");
INSERT INTO tgo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Iyake kaiwae, u wo len mbwenarana, u wa e njamnjam vo woidi na u unɨgha thetheghan regha kaiwaŋgu. ");
INSERT INTO tgo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mbaŋa ne u wovutha, u vakatha ghanɨŋga thovuye regha kaiwaŋgu, iya vara nuwaŋguke nuwaiya moli, u thɨnɨmena e ghino na ya ghan. Ghanɨŋga ne ghereiye amba ya giya ghanɨmwaewona, ko amba muyai ya mare.” ");
INSERT INTO tgo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mbaŋa Aisake i utuutu weya Iso, Rebeka mbe i ndevandeŋe eŋge. Mbaŋa Iso kaero i wareri kaiwae na e ghereiye, ");
INSERT INTO tgo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","amba Rebeka i dage weya nariye Jeikob iŋa, “Wo u vandeŋeŋgo! Ma loŋwevaidiya rama Aisake i utu weya ghagha Iso, ");
INSERT INTO tgo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","meŋa, ‘Vo unɨgha thetheghan regha e njamnjam, u vivatha ghanɨŋga thovuye regha kaiwaŋgu na ya ghan, na e ghereiye Giya Loi e marae, amba ya giya ghanɨmwaewona, ko amba muyai ne ya mare.’ ");
INSERT INTO tgo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Iya kaiwae, naruŋgu, u vandeŋe ghalɨŋaŋguke na u vakatha ŋgoreiya ya utuŋake e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","U wa weŋgiya la thetheghanɨko na vo tuthiya gout tabwagha umboiwo, ghanjitabo vondɨvondɨ. U bigi mena na ya vivatha ghanɨŋga thovuye regha, iya vara rama nuwaiyako moli. ");
INSERT INTO tgo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mbala u yothɨn weya rama na ve ghan, na e ghereiye, amba i giya ghanɨmwaewo, ko amba muyai ne i mare.” ");
INSERT INTO tgo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ko iyemaeŋge Jeikob i dage weya tɨnae Rebeka iŋa, “Kaero u ghareghare Iso iye riwae vata vulivuliye na ghino njimwaŋguke i udauda. ");
INSERT INTO tgo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mbwata ne bwebwe i vinoya riwaŋguke na i ghareghare ya vakatha kwanɨwe, iwaeŋge tembe wombereghakeva ya womena wo gura na maa wo dagemwaewova.” ");
INSERT INTO tgo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tɨnae i gonjoghawe iŋa, “Naruŋgu, gurana iyana ne i nja e ghino, mbema u wa eŋge na vo vakatha ŋgoreiya maŋama na u bigimena goutɨko e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ko amba Jeikob i wa, ve gaboŋgiya goutɨma, i bigimena weya tɨnae na i vakatha ghanɨŋgama iya ramae Aisake nuwaiyama moli. ");
INSERT INTO tgo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Amba Rebeka i mbana nariye laghɨyeniye, Iso, ghaghavatha kwamaniye thovuthovuye moli vambe i mbanɨrawe wagiyawe e ŋgoloko tɨne na i vanjimbo nariye nasiyeniye, Jeikob we. ");
INSERT INTO tgo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","I bigiya goutɨma njimwanji na i bigirawe Jeikob e nɨmanɨmae na e numwe rɨghe ŋgoreiya ma vulivuliye i mbuthuwe. ");
INSERT INTO tgo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Kaero i thɨnɨgiya ghanɨŋgama ghamɨnaema thovuye weiye bred, iya me vakathama Jeikob we. ");
INSERT INTO tgo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jeikob kaero i wa ve ru weya ramae. I vutha iŋa, “Bwebwe.” I gonjoghawe iŋa, “Ŋgoroŋga, na thela ghen naruŋgu?” ");
INSERT INTO tgo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jeikob iŋa, “Ghino narun laghɨyeniye Iso. Kaero ma vakatha ŋgoreiya mo dagema e ghino. Ya naŋgo e ghen u thuweiru na u yaku na u ghanɨŋga. U ghana thetheghanɨma ma unɨghɨma mbunɨmaniye, na mbala u giya womwaewona e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ko iyemaeŋge Aisake i dagewe iŋa, “Naruŋgu, me ŋgoroŋga na mbema ghen na nɨman eŋge kaero u vaidiva thetheghanɨko?” Jeikob i gonjoghawe iŋa, “Kaiwae Giya Loi len Loi me thalavuŋgo na ma vaidi iya ma maya e njoghamake.” ");
INSERT INTO tgo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aisake i dage weya Jeikob iŋa, “Ya naŋgo e ghen na wo u romena evasiwaŋguke, na ya vɨghathɨgha riwanɨna na valɨkaiwae ya ghareghare mbema emunjora Iso ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jeikob i rotha amba ramae i bigirawe nɨmanɨmae e riwae, i vino ŋgolouya na i dagewe iŋa, “Ghalɨŋanɨna ghaloŋwaloŋwa ŋgoreiya Jeikob, ko iyemaeŋge nɨmanɨmanɨke ghamɨnae ŋgoreiya Iso.” ");
INSERT INTO tgo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Mava i ghareghare Jeikob iya amalaghɨniyeko, kaiwae nɨmanɨmaeko vata vulivuliye ŋgoreiya Iso. Vama i munje ma i giya vara ghamwaewo, ");
INSERT INTO tgo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ko injana mbowo i vaitova iŋa, “Mbema emunjora Iso iya ghenake?” I gonjoghawe iŋa, “Ko mbwana!” ");
INSERT INTO tgo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aisake i dagewe iŋa, “Wo u thɨnɨma ghanɨŋgama na wo ya ghan, ko amba muyai ya giya ghan mwaewo.” Jeikob i thɨnɨgiyawe, na tembe i giyaweva waen na i mun. ");
INSERT INTO tgo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Amba ramae iŋa, “Naruŋgu, u romena e ghadɨdɨŋguke moli na u vandamoŋgo.” ");
INSERT INTO tgo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Mbaŋa i romena evasiwae na i vandamo, ramae Aisake i naeya ghakwamako butiye, amba i giya ghamwaewo iŋa, “Naruŋguke butiye thovuye ŋgoreiya thelau regha Giya Loi i vakatha na veimaima na ndendewo. ");
INSERT INTO tgo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ya naŋgo weya Loi na ne i vakatha udubuya i njama e buruburu na i vakatha len umauma thɨ rau e ghanɨŋga thaŋarɨke, thovuthovuye na lemoyo moli; na tembe ŋgoreiyeva lemoyo wit na waen. ");
INSERT INTO tgo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ya naŋgo weya Loi na ne i vakatha vanautuma vavana thɨ kaiwo e ghen na tembe ŋgoreiyeva weŋgiya orumburumbu ne muyaiko, na ya naŋgo gharɨgharɨ vavana nevole thɨ yavwatata wanaŋge. Ya naŋgo weya Loi na nevole u tabo na giya weŋgiya len bodaboda, na tɨna le bodaboda nevole thɨ yavwatata wanaŋge. Ya naŋgo weya Loi na thavala nevole thɨ guraŋge ne thɨ vaidiya guraniye, na thavala nevole thɨ varemoliyaŋge ne thɨ vaidiya ghanjithovuye.” ");
INSERT INTO tgo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisake amba i giyavaoeŋge nariye Jeikob ghamwaewo, na mbaŋaniye amba i itete eŋge ramae, ghaghae Iso kaero ve rovuthaweva ramanji, i njoghama e woidi rɨghe. ");
INSERT INTO tgo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Tembe me vivathava ghanɨŋga ghamɨnae thovuye moli na i thɨnɨmena weya ramae. I ronja evasiwae na i dagewe iŋa, “Ya naŋgo e ghen, bwebwe, u thuweiru na u ghana ghanɨŋgake iya ma vakathake na ya thɨnɨmenake e ghen, na mbala u giyama womwaewona.” ");
INSERT INTO tgo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aisake i vaito iŋa, “Ko thela ghen?” Iŋa, “Ghino Iso, narun virɨviva.” ");
INSERT INTO tgo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Mbaŋa Aisake i loŋwetuthiya Iso ghalɨŋaeko, ghare i tagathɨn na riwaeko laghɨye i tage na i vaito iŋa, “Ko thelaeŋge iya me unɨgha thetheghanɨke na iya me thɨnɨmenake e ghino? Amba ma ghanɨvao eŋge ma iyava u yovuthake. Kaero ma giya mwaewo moumouniyewe, na maa valɨkaiwaŋgu ya wovɨvɨ. Emunjoru Giya Loi ne i mwaewowe.” ");
INSERT INTO tgo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Mbaŋa Iso i loŋwa utuutuko iyako weya ramae, i randa na ghalɨŋae laghɨye moli weiye le gharevɨrɨ laghɨye na i dage weya ramae iŋa, “Bwebwe, mbowo u giyamava iya mwaewona iyana e ghino!” ");
INSERT INTO tgo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Aisake i gonjoghawe iŋa, “Ghagha Jeikob me mena na i yaroŋgo. Kaero me mbanɨvao ghan mwaewoma.” ");
INSERT INTO tgo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iso iŋa, “Kaero mbaŋaiwoniye vara iyake. Va i yaroŋgokai na i wo weŋgo virɨvivake ghino lo ghamba ndeghathɨ. I thovuye moli eŋge idako Jeikob inawe. Wo u thuwe mbaŋake kaero me wo weŋgova wo mwaewoma. Thare mo goworawa mwaewo regha ghino kaiwaŋgu?” ");
INSERT INTO tgo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisake i gonjoghawe iŋa, “Kaero ma vakatha na iye ne ghan giya, na le bodabodako wolaghɨye le rakakaiwo. Kaero maŋa le umauma wit na waen ne veimaima na ndendewo. Ko tene ya utuŋava budakai e ghen, naruŋgu?” ");
INSERT INTO tgo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iso mbe i rorovurɨgheghe vara weya ramae: “Thare mwaewo reghava mbe inawe kaiwaŋgu, bwebwe? Mbowo u giyamava wo mwaewo, bwebwe!” Injana mbowo i randava ghalɨŋae laghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Amba Aisake i dagewe iŋa, “Mane udubuya i njama e buruburu kaiwan. Mane thelau veimaima na ndendewo kaiwan. ");
INSERT INTO tgo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Yawalin na len yakuyaku ghathovuye mbene inavara e len gaithɨna ghaghalithɨ. Nevole ghaghako le rakakaiwo ghen. Ko iyemaeŋge mbaŋa ne u goriwoyathu, kaero u goghale le mbaro ghaghambu.” ");
INSERT INTO tgo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iso i botewoyatho ghaghae Jeikob kaiwae ramanji kaerova i giya gha mwaewowe, iya kaiwae i renuwaŋa thuwole e ghare na iŋa, “Ramanda le mare na nuwotharɨniye gha mbaŋa e ghereiye amba ya unɨghɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ko iyemaeŋge mbaŋa Rebeka i loŋwevaidiya Iso le renuwaŋako, i kulavatha Jeikob na iŋa, “Naruŋgu, u thɨna thegheniŋguke. Ghagha Iso i rerenuwaŋa kaiwan na i munjeva ne i liya thoru e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Iya kaiwae, naruŋgu, u loŋweghathɨgha ghalɨŋaŋguke, na e mbaŋake vara iyake u vogha na u wa weya louŋgu Leiban, len ghai, Haran e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mbowo vo yaku gheko gheghad ghagha le ghatemuruko i morurunja, ");
INSERT INTO tgo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","na i renuwaŋa vaghalaweya budakai va u vakathawe, ko amba ya variye lolo regha i ghaona i vaŋgunjoghaŋge. Ŋgoroŋga yawaliŋguke ne ghathovuye thoŋgo ya thɨvaiŋgiya lo ŋgaŋgake mbe thenjighewoke vara e mbaŋa regha?” ");
INSERT INTO tgo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka i dage weya Aisake iŋa, “Riwaŋguke kaero i banewaŋgiya Iso le ovoŋgike. Thiye mbe vanautuma regha wanakauniyeŋgi. Thoŋgo Jeikob i vaŋgwa Het wevoniye eunda, yawaliŋguke ŋgoroŋga ne ghathovuye e ghino?” ");
INSERT INTO tgo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aisake i kula weya Jeikob na i varemoliya na i dage vurɨgheghewe, iŋa, “Ne u ndevaŋgwa wevo eunda e valɨvaŋgake iyake, Kenan e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mbaŋake vara u wareri na u wa Padan Aram. U wa weya rumbu Betuwel, na vo vaŋgwa wevo eunda gheko, len ghai Leiban yawarumbuye eunda. ");
INSERT INTO tgo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ya naŋgo weya Loi Vurɨvurɨghegheniye na ne i mwaewowe len ghena, na i vakatha len ŋgaŋga lemoyo, na mbala u tabo na vanautuma lemoyo rumbunji. ");
INSERT INTO tgo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ya naŋgo weya Loi na ne i dage mwaewo e ghen na weŋgiya orumburumbu muyaiko ŋgoreiya va i vakatha weya Eibraham. Mbala u mbaroŋa valɨvaŋgake iyake, iya kaero u mebwabwarikewe. Loi kaerova i vatomwe weya Eibraham.” ");
INSERT INTO tgo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kaero Aisake i variye Jeikob na i wa Padan Aram, i wa weya Leiban, Betuwel nariye. Amalake iyake iye rara Aram na Rebeka louye, Jeikob na Iso tɨnanji. ");
INSERT INTO tgo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iso i loŋwevaidiya Aisake kaerova i giya Jeikob ghamwaewo na i variye i wa Padan Aram na ve tamweya levowe. Na tembe i loŋwevaidiva, mbaŋa Aisake i giya ghamwaewo, i dagetenɨwe na thava ne i vaŋgwa tɨnan Kenan eunda na levo. ");
INSERT INTO tgo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Tevambe i loŋwevaidiva, Jeikob i ghambugha tɨnae na ramae na kaerova i wareri, i wa Padan Aram. ");
INSERT INTO tgo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Iso va i ghareghare ramae Aisake mava le renuwaŋa ŋgoreiye thɨ vaŋguŋgiya Kenan wanakauniye. ");
INSERT INTO tgo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Iya kaiwae i wa weya Ismel, Eibraham nariye, na mbowo ve vaŋguva yawarumbuye idae Mahalat, Nebaiyot louye. ");
INSERT INTO tgo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jeikob i iteta Beyasiba na kaero i loŋgaloŋgava Haran kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Vama i vutha e valɨvaŋga regha, na varae vama ve ronja, iya kaiwae wo i laghena gheko. I wo eŋge varɨ regha na umbaliye gha bubuthe kaero i ghena. ");
INSERT INTO tgo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Gougouko iyako i ghenelolowa ŋende regha i ndeghathɨ e yambaneke, i tubwembele na ve wo buruburuko, na Loi le nyao thovuthovuye thɨ rakarakavoro na thɨ rakarakanjawe. ");
INSERT INTO tgo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Amba i vaidiya Giya Loi i ndeghathɨ e vwatae na i dagewe iŋa, “Ghino Giya Loi, Eibraham na Aisake lenji Loi. Thelauke iya u ghenakewe ne ya wogiya e ghen na orumburumbu tha muyaiko. ");
INSERT INTO tgo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nevole lemoyo moliŋgi ŋgoranjiya yambaneke vughauye. Lenji ghamba mbaroke nevole thɨ valaghɨyeŋa, i njaoko, i vorowoko, e ghaiwabuko na e yaghalako. Weya ghen na orumburumbu weŋgi, ne ya mwaewo weŋgiya vanautumake wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na u renuwaŋakiki, ghino mbene weiŋgu vara ghen mbaŋake wolaghɨye. Ne ya njimbukikiŋge e the valɨvaŋga ne u wawe, tembene ya vaŋgunjoghaŋgeva e valɨvaŋgake iyake. Mane mbaŋa regha ya roiteteŋge na ne ya vakatha ŋgoreiye budakai va ya dagerawe e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Mbaŋa Jeikob i thuweiru, amba iŋa, “Mbema emunjoru Giya Loi ina gheke. Ina e valɨvaŋgake iyake, ko iyemaeŋge ghino maa ma ghareghare!” ");
INSERT INTO tgo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Va weiye le mararu na iŋa, “Mbema emunjoru valɨvaŋgake iyake maramararuwae! Valɨvaŋgake iyake Loi le ghamba yaku, na buruburu ghathɨnɨmba.” ");
INSERT INTO tgo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jeikob i thuweiru e mbaŋambaŋako iyako, i wo varɨma me umbaliyema ghabubuthe, i worawe na i ndevanavana na ghamba renuwaŋakiki kaiwae, na i woraŋgiya iyako valɨvaŋga boboma. Amba i liŋgiya bunama olivɨ e vwatae na i vabobomaŋa Loi kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Jeikob i uno valɨvaŋgako iyako Betel. (Ghemba va ina gheko idae Luji.) ");
INSERT INTO tgo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Amba Jeikob i vakatha dagerawe regha weya Giya Loi na iŋa, “Thoŋgo ghen, Giya Loi, mbene weiŋgu vara ghen na u njimbukikiŋgo elo loŋgaloŋgake e tɨne, na u giya ghanɨŋga na kwama e ghino, ");
INSERT INTO tgo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na u vaŋgunjoghaŋgo weya bwebwe weiŋgu lo vanevane, ko ghen emunjoru ne lo Loi. ");
INSERT INTO tgo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Iya renuwaŋakikike gha varɨ ma vamidike e valɨvaŋgake iyake, nevole ghamba kururu e ghen. Bigibigike wolaghɨye ne u giya e ghino, ne ya wonjogha e ghen wan tenɨt lo vowo.” ");
INSERT INTO tgo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jeikob kaero i wareriva. I loŋga na i ghemba boimako, Keinan valɨvaŋga i vorovoroko. Ghemba regha e boimako gharɨgharɨ thɨ yaku gheko. ");
INSERT INTO tgo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Mbaŋa regha mbe ele loŋga tɨne eŋge, i vutha e valɨvaŋga regha sip lenji ghamba ghan, mbwarowou regha inawe. I vutha vaidiŋgiya sip wabwito thɨ gheneghɨliŋa mbwarowouko. Thɨ roroghagha ghanjiranjimbunjimbu thɨ mena thɨ giya mbwa weŋgi. Mbwako va ina bode na ghagumogumo varɨ laghɨye regha. ");
INSERT INTO tgo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mbaŋa thetheghan ghanjiwabwiko wolaghɨye thɨ raka vuthavao, amba ranjimbunjimbuko thɨ vabulale vakatha varɨko e mbwarowouko ghae na thɨ giya mbwa weŋgiya thetheghanɨko. Mbaŋa thɨ vamunvaoŋgi kaero thɨ vabulale njoghava varɨko e mbwarowouko ghae. ");
INSERT INTO tgo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jeikob i vaitoŋgiya ranjimbunjimbu iŋa, “Wouna, ghemi aŋga hu rakamena?” Thɨ gonjoghawe thɨŋa, “Wo rakamena Haran.” ");
INSERT INTO tgo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I dage weŋgi iŋa, “Thare hu ghareghare Leiban iye Neiho rumbuye?” Thɨ gonjoghawe thɨŋa, “Mbwana. Wo ghareghare.” ");
INSERT INTO tgo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Amba Jeikob i vaitoŋgi iŋa, “Riwae i thovuye eŋge?” Thɨ gonjoghawe thɨŋa, “Mbwana. Wo u thuwe, yawarumbuye Reitiyel maiya vara, weiyaŋgiya sip.” ");
INSERT INTO tgo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jeikob i dage weŋgi iŋa, “Wo hu thuwe, amba raŋgela thɨ yo vara iyake. Buda kaiwae mo vaŋgumenaŋgiya sipɨna? Ma u lagiya eŋge mbwa weŋgi kaero u vaŋgu njoghaŋgiva na mbowo vethiya ghana ghanjinana.” ");
INSERT INTO tgo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ko iyemaeŋge thɨ gonjoghawe thɨŋa, “Mbowo wo roghaghaŋgiya ranjimbunjimbuko vavana na wo thɨ raka vutha weinjiyaŋgiya lenji sipɨko, amba mbaŋara wo vabulale vakatha varɨko e mbwarowouko ghae na wo giya mbwa weŋgiya thetheghanɨko.” ");
INSERT INTO tgo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mbaŋa Jeikob amba i utuutu, Reitiyel kaero i vutha weiyaŋgiya ramae le sip, kaiwae elaghɨniye ghakaiwo i njimbukikiŋgiya ramae le thetheghanɨko. ");
INSERT INTO tgo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Mbaŋa Jeikob i thuwe le ghɨna Reitiyel na le ghai Leiban le sipɨko, i wa e mbwarowouko ghadidiye, i vabulale vakatha varɨko e mbwarowouko ghae amba i giya mbwa weŋgiya thetheghanɨko. ");
INSERT INTO tgo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","I vakathavao i wa ve vandamo Reitiyel. Kaiwae va weiye le warari iwaeŋge i randa ghalɨŋae laghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","I dage weya Reitiyel iŋa, “Rebeka nariya ghino, ramana louye.” Mbaŋa Reitiyel i loŋwe iyako i rukunjogha na ve dage weya ramae. ");
INSERT INTO tgo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Mbaŋa Leiban i loŋwe ghabodo Jeikob utuniye me vutha gheko, i rukuwawe na ve thuwe. I vutha i thuwabo na i vandamo. I vaŋgu weiye thɨ wa e ŋgolo, na gheko amba Jeikob i utugiya bigibigiko wolaghɨyewe. ");
INSERT INTO tgo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Leiban i dagewe iŋa, “Mbema emunjoru, mbunɨma na madibena iya e ghenɨna iya e ghinoke.” Jeikob i yaku weiye Leiban na i thalavu. Manjala umbwara e ghereiye ");
INSERT INTO tgo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Leiban i dagewe iŋa, “Othembe raŋa lo boda ghen, thava u kaiwoke e ghino na maa e modamodan. U utu giyama e ghino, ne ŋgoroŋga na ya vamodoŋge?” ");
INSERT INTO tgo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leiban yawarumbuye theunyiwo, laghɨyeniye idae Leya na nasiyeniye idae Reitiyel. ");
INSERT INTO tgo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya ghayamoyamo vambema wevo eŋge, ko iyemaeŋge Reitiyel, elaghɨniye wevo manɨune moli. ");
INSERT INTO tgo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Reitiyel va i wo Jeikob nuwae na amalaghɨniye i gharethovuwe, iya kaiwae i dage weya Leiban iŋa, “Ne ya kaiwo theghathegha umbopirɨ kaiwan na ne u vaŋgu veŋgwa yawarumbuna nasiyeniye Reitiyel ya vaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Leiban i gonjoghawe iŋa, “I thovuye eŋge ne ya vaŋgu veŋge. Maa lo renuwaŋa na yaŋa ya vaŋguveya lolo reghava. I thovuye eŋge mbe ya yaku vara weiŋgu ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Iya kaiwae Jeikob va i kaiwo theghathegha umbopirɨ mbala valɨkaiwae i vaŋgwa Reitiyel. Ko iyemaeŋge mbaŋako molao iyako ghathuwathuwa weya Jeikob ŋgoreiya mbaŋa mbe gheviye eŋge kaiwae i gharethovu laghɨye moliwe. ");
INSERT INTO tgo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Theghathegha umbopirɨna e ghereiye Jeikob i dagewe Leiban iŋa, “U vaŋgu giyama lo wevona. Kaero mendava ya kaiwo theghathegha umbopirɨ kaiwan, na kaero nuwaŋguiya ya ghena weiŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kaero Leiban i vivatha ghe ghathaga na i kula vathavathaŋgiya gharɨgharɨko wolaghɨye e ghembako tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ko iyemaeŋge gougouko iyako Leiban i vaŋguruwo yawarumbuye Leya weya Jeikob na i ghena weiye (le renuwaŋa va iŋaeŋge Reitiyel). ");
INSERT INTO tgo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Gougouniyeko iyako Leiban i vaŋgugiya le rakakaiwo eunda idae Silpa weya yawarumbuye na le rakakaiwo. ");
INSERT INTO tgo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Va ighɨviya thewo na i manjala, Jeikob i thuweiru na i thuwe Leya, ghare i yo. Iwaeŋge i dage weya Leiban iŋa, “Budakaiya mo vakathake e ghino? Mendava ya kaiwo voreŋa theghathegha umbopirɨ e ghen Reitiyel kaiwae, ŋgoreiye? Budakai kaiwae na mo yaroŋgoke?” ");
INSERT INTO tgo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ko iyemaeŋge Leiban i dagewe iŋa, “Ghama thanavu e valɨvaŋgake iyake ma ŋgoreiye na wevo nasiyeniye i ghekai laghɨyeniye e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Iyemaeŋge, thoŋgo wo u vakathavao lemi gheke thaganiye wikike iyake, ko amba tembe wo vaŋgu veŋgeva yawarumbuŋguke eundake e ghen theghathegha umbopirɨva.” ");
INSERT INTO tgo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jeikob i vakatha ŋgoreiye. I vakathavao le gheko weiye Leya thaganiye e wikɨko umbwara tɨne, ko amba Leiban i vaŋgugiya yawarumbuye Reitiyel na levo. ");
INSERT INTO tgo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Leiban i vaŋwa le rakakaiwo wevo eunda na i vaŋgugiya weya Reitiyel na le rakakaiwo. Wevoko idae Bilha. ");
INSERT INTO tgo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","E mbaŋako iyako Jeikob i ghena weiye Reitiyel. Le gharethovu weya Reitiyel i laghɨye kivwala le gharethovu weya Leya, na iyake kaiwae mbowo i kaiwova theghathegha umbopirɨ weya Leiban. ");
INSERT INTO tgo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mbaŋa Giya Loi i thuwe Jeikob maa ghare weya Leya, i vakatha na i ghambɨ gamagai, iyemaeŋge Reitiyel va i kwama. ");
INSERT INTO tgo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya va i marabo na i ghamba ŋgama ghɨmoru. I rena idae Rubin, na iŋa, “Giya Loi i thuweŋgo ya gharevɨrɨ iya i woveŋgwa ŋgama ghɨmoruke. Mbwata ne mbaŋake amba ne lo ghɨmoruko i gharethovuŋgo.” ");
INSERT INTO tgo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Mbaŋa gheviye eŋge e ghereiye, Leya kaero i marabova na mbowo i ghambɨva ŋgama ghɨmoru, na iŋa, “Giya Loi kaero i loŋwa lo ghɨmoruke amba maa ghare weŋgo iya mbowo i woveŋgova ŋgama ghɨmoruke. Iya kaiwae ne ya rena idae Simiyon.” ");
INSERT INTO tgo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Mbaŋa seiwo eŋge mbowo i marabova na i ghambɨva ŋgama ghɨmoru. Iwaeŋge Leya iŋa, “Ghɨmoghɨmoru kaero theghetoninji vara iyake ya ghambɨ weiŋgu lo ghɨmoruko. E mbaŋake iyake ambane ghare vara weŋgo. I rena idae Livai.” ");
INSERT INTO tgo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Leya mbowo i marabova na mbaŋa i ghambɨ ŋgama ghɨmoruva, kaero iŋa, “E mbaŋake iyake ya tarawe Giya Loi.” I rena idae Juda. Iyako e ghereiye maa tembe i ghambɨva. ");
INSERT INTO tgo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mbaŋa Reitiyel i thuwe ghaghae Leya eŋge i ghambɨ gamagai weiye Jeikob na elaghɨniye nandere, iwaeŋge i yamwanja ghaghae kaiwae. I dage weya Jeikob iŋa, “U giyama gamagai weŋgo? Thoŋgo maa ra thiya gamagai, lo nuwatharɨke kaiwae ne ya mareke!” ");
INSERT INTO tgo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ko iyemaeŋge Jeikob weiye le ghatemuru i dage iŋa, “Ne ya vakatha budakai? Mbe Loi eŋge ghamberegha iya i vakathaeŋge na maa u ghambɨna, maa ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Amba i dagewe iŋa, “Ne ya vaŋgu veŋge lo rakakaiwoke Bilha. U ghambɨ wein na gamagaiko thiyako ghino kaiwaŋgu na weya elaghɨniye wo uuke ne i mbuthuwe.” ");
INSERT INTO tgo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kaero Reitiyel i vaŋgu giya le rakakaiwoko Bilha weya Jeikob na levo na i ghena weiye. ");
INSERT INTO tgo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Wevoko i marabo na i ghamba ŋgama ghɨmoru, Jeikob nariye. ");
INSERT INTO tgo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Amba Reitiyel iŋa, “Loi le vakathako i govambwara lo renuwaŋako i thovuye. I ghareghare budakai va nuwaŋguiya moli iya i wogiya ŋgama ghɨmoruke e ghino.” Iya kaiwae i rena idae Den. ");
INSERT INTO tgo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Thɨ yakuyakuva na Reitiyel le rakakaiwoko Bilha kaero i marabova na mbowo i ghambɨva ŋgama ghɨmoru weiye Jeikob. ");
INSERT INTO tgo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Amba Reitiyel iŋa, “Mbema lo rovurɨgheghe eŋge weiŋgu ghaghaŋguko Loi le mwaewoko kaiwae, na kaero ya vaidiya une.” Iya kaiwae i rena ŋgamako idae Napɨtalai (gha loŋwaloŋwa ŋgoreiye Hibru utuniye gharumwaru rovurɨgheghe). ");
INSERT INTO tgo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mbaŋa Leya i thuwe kaero maa i ghambɨva, iwaeŋge i vaŋgwa le rakakaiwoma, Silpa na i vaŋgu giya weya Jeikob na levo. ");
INSERT INTO tgo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Mbaŋa ubotu Silpa i ghambɨ weiye Jeikob nariye ŋgama ghɨmoru. ");
INSERT INTO tgo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Amba Leya iŋa, “Kaero ya mwaun.” Iya kaiwae i rena ŋgamako idae Gad. ");
INSERT INTO tgo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Theghathegha gheviyeŋge e ghereiye Leya le rakakaiwoma Silpa mbowo i ghambɨva ghɨmoru regha weiye Jeikob. ");
INSERT INTO tgo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Amba Leya iŋa, “Mbaŋake mbema ya warari vara. Wanakauke wolaghɨye ne thɨ utuŋaŋgo lo wararike kaiwae.” I rena ŋgamako idae Asa. ");
INSERT INTO tgo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Va mbaŋa regha wit ghambaŋa uloulo, Rubin i wa witɨko e ghanjiuma tɨne. Iwaeŋge ve vaidiya nana tarira. Gharɨgharɨ va e mbaŋako iyako thɨ renuwaŋa valɨkaiwae i thalavugha wevo i kwama na kaero i ghambɨva. Rubin i mbanɨmena weya tɨnae Leya. Reitiyel i dage weya Leya iŋa, “Aee, thare valɨkaiwae u giya nanako iya naruko me mban vavana e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ko iyemaeŋge Leya i gonjoghawe na iŋa, “Ko ana amba maa valɨkaiwan iya mendava u vaŋgwa weŋgo lo ghɨmoruke? Na injana mbowo nuwaniyava naruŋguke le nanake.” Reitiyel i gonjoghawe iŋa, “I thovuye eŋge, naruna le nanana modae, ya dagerawe noroke gougou u ghena wein Jeikob.” ");
INSERT INTO tgo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Vama yeghɨyeghɨye moli na Jeikob kaero i njoghanjoghamava, Leya ve lavolevole e witɨko e ghanjiuma. Kaero i dagewe iŋa, “Noroke gougou ya ghena weiŋgu ghen. Kaero ma vamodaŋge weya Leya. Ma mbana naruŋguko le nana na ya vamodaŋgewe.” Ko amba gougouko iyako Leya i ghena weiye. ");
INSERT INTO tgo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Loi kaero i wovatha Leya le renuwaŋako na i vakatha kaero i marabova. Weiye Jeikob i ghambɨ ŋgama ghɨmoru, theghelimaninji. ");
INSERT INTO tgo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Amba Leya iŋa, “Loi kaero i giya modaŋgu kaiwae va ya vaŋgugiya lo rakakaiwoko weya lo ghɨmoruko.” Iya kaiwae i rena nariyeko idae Isaka. ");
INSERT INTO tgo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya mbowo i marabova na i ghamba nariye theghewonaniye weiye Jeikob. ");
INSERT INTO tgo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leya iŋa, “Loi mendava i wogiya wo ghevawarari thovuye moli. Mbaŋake lo ghɨmoruko ne i yavwatata wanaŋgo kaiwae gamagai ghɨmoghɨmoru kaero theghewona vara ya ghambɨŋgi weiŋgu.” I rena ŋgamako iyako idae Sebulon. ");
INSERT INTO tgo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mbaŋa reghavena mbowo i marabova na i ghambɨ ŋgama wevo. I rena idae Daina. ");
INSERT INTO tgo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Amba Loi i renuwaŋakikiya Reitiyel. I loŋwe le naŋgoko na i vakatha valɨkaiwae i ghambɨ. ");
INSERT INTO tgo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Amba i marabo na i ghambɨ ŋgama ghɨmoru. Na iŋa, “Loi kaero i thouyatho lo monjinake kaiwae mbaŋake valɨkaiwaŋgu valɨkaiwae ya ghambɨŋgiya gamagai.” ");
INSERT INTO tgo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Reitiyel i rena nariyeko idae Josep, na iŋa, “Mbala Loi mbowo i lawogiyava ŋgama ghɨmoru regha e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Mbaŋa Reitiyel i ghamba Josep na i ghereiye, Jeikob i wa weya Leiban na ve dagewe iŋa, “Thare valɨkaiwae u vatomweŋgo na ma ya njoghava e ghambaŋgu, va ya rikowe? ");
INSERT INTO tgo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","U vaŋgugiyama lo ovoke na lo ŋgaŋgake, iyava ya kaiwo kaiwanji e ghen theghathegha hoyawora na umbovarɨ e tɨnenji. Mbaŋake ma u vatomwe eŋge kaero ya vaŋguŋgiya lo ŋgaŋgake na wo raka e vanarɨgheŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Leiban i dagewe iŋa, “Aee, amalana, thoŋgo va ya vawarariŋaŋge, mbowo ra yaku gheke weiŋgu ghen. Kaiwae kaero ya ghareghare kaiwae lo loiŋgike thɨ govwambwara e ghino, thovuye na mwaewo iya ya vaidike weya Loi, rɨghethoru moli kaiwae ghen inan gheke.” ");
INSERT INTO tgo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Na mbowa i gotubweva iŋa, “Ko u utugiyama e ghino, mbala ŋgoroŋga modan le laghɨlaghɨye ya giya e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Amba Jeikob i dagewe iŋa, “Kaero u ghareghare mbaŋa le molomolao lo kaiwo na ghathovuye e ghen. Len thetheghan thɨ yala na lemoyo moli ghino lo njimbukiki e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Na amba muyai va ya vutha e ghen, len thetheghanɨke vambe gheviye eŋge. Mbaŋake len thetheghanɨke thɨ ghambɨ raka na ma wabwi lemoya eŋge, na elo vakathake wolaghɨye e tɨnenji Loi i mwaewo laghɨye e ghen. Ko ne the mbaŋa eŋge amba ya vakatha budakai lo ŋgamaŋgamake kaiwanji?” ");
INSERT INTO tgo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Leiban i vaito iŋa, “Ne ya giya budakai e ghen?” Jeikob i gonjoghawe iŋa, “Ne u ndegiya bigi regha e ghino. Ko mbe bigi reghaeŋge ne u vakatha. Thoŋgo u vatomwe, mbowo ya njimbunjimbukikiŋgi vara len thetheghanɨko. ");
INSERT INTO tgo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Noroke wo u vatomwe e ghino na ya vaghetheŋgiya len thetheghanɨko. Ne ya vaghetheraŋgiyaŋgiya sip le ŋgaŋga bwedibwedi na sip na gout e ghanjithuwathuwa bwebwa. Thetheghanɨke thiyake ne ya mban, modaŋgu. ");
INSERT INTO tgo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mbaŋa muyaiko ne valɨkaiwan u ghethe vakatha thoŋgo lo vakatha e ghen i thovuye na emunjoru. Thoŋgo ne u thuwe gout ma e ghanjithuwathuwa na sip ma riwanji i bwedi, ne u ghareghare ma kaivɨ e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Leiban i dagewe iŋa, “Lo renuwaŋa ŋgoreiye. U vakatha ŋgoreiya moŋana.” ");
INSERT INTO tgo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Iyemaeŋge tembe e mbaŋaniyeva tɨne Leiban i wa weŋgiya thetheghanɨko na ve vaghetheraŋgiyaŋgiya gout takedi wolaghɨye e ghanjibwebwako, gout vavata wolaghɨye e ghanjibwebwa, thiya ghanjibwebwako kakaleva na sipɨko wolaghɨye iya riwanji i bwedi. I vaŋgugiya weŋgiya onanariye na thɨ njimbukikiŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Amba Leiban na onanariye thɨ takovaoŋgiya lenji thetheghanɨŋgima na thɨ wareriŋa valɨvaŋga regha, na i vakatha e ghalughawoghawo weya Jeikob. Le bwagabwaga ŋgoreiya mbaŋa thegheto loŋganiye. Na Jeikob vambe i ronjimbughathɨŋgiya Leiban le thetheghanɨko ghanji uneko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Iyemaeŋge Jeikob i wa ve mbana umbwaumbwa umboto idaidanji popula, almon, na plen, thɨ mbuthu e valɨvaŋgako iyako, yaŋgayaŋganji totogha. I thethe njimwanjimwanji vaŋga iya ghanjibwebwa kakalevako inanji e umbwako i raŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Amba Jeikob i bigirawe umbwaumbwako yaŋgayaŋganji, iya me thethe vaŋgako iya, e thetheghanɨko lenji ghamba mun mbwa tɨne. Jeikob va i ghareghare mbaŋa thetheghanɨko ne thɨ mena thɨ muna mbwako, gout takediko ne thɨ baba vavatako e vwatanji. ");
INSERT INTO tgo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Mbaŋa thɨ vakatha ŋgoreiyako na umbwaumbwako yaŋgayaŋganji nanasiye ina e ghamwanji, goutɨko thɨ ghambɨŋgiya totogha e ghanjibwebwa, e ghanji ŋginiŋginitɨ, na e ghanji gagaeton. ");
INSERT INTO tgo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jeikob i ghethe vakatha goutɨma lenji ŋgaŋga e ghanjibwebwama, na i vakathaŋgiya sip takediko thɨ baba vavatako e vwataŋi na yamwanji i ghemba goutɨko lenji ŋgaŋga. I vakatha ŋgoreiyako na i mbana le thetheghan na mbe i wabwi vakatha weya Leiban le thetheghanɨko. ");
INSERT INTO tgo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Mbaŋa thetheghanɨko vurɨgheghe ghɨmoghɨmoru thɨ baba vavatako e vwatavwatanji, kaero Jeikob i wa ve bigirawa umbwaumbwako yaŋgayaŋgae e ghanji mbwako ghamba ghadidiye e ghamwanji. Mbaŋa ghɨmoghɨmoru thɨ baba vavatako e vwatavwatanji, kaero thɨ thuwe umbwaumbwa yaŋgayaŋganji. ");
INSERT INTO tgo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ko iyemaeŋge Jeikob mava i bigirawa umbwaumbwako yaŋgayaŋganji thetheghanɨko thɨ njavovoko e yamwanji. E kamwathɨko iyako Jeikob i mbana thetheghan iya thɨ vurɨghegheko na Leiban i mbana iya thɨ njavovo. ");
INSERT INTO tgo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ele vakathako iyako i vakatha i vwenyevwenye laghɨye moli. Le sip na gout lemoyo moli, le kamel na le doŋɨki tembe lemoyova, na le rakakaiwo ghɨmoghɨmoru na wanakau tembe ŋgoreiyeva. ");
INSERT INTO tgo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jeikob i loŋwevaidiya Leiban le ŋgaŋga thɨ liliya ghautu. Thɨŋa, “Jeikob kaero i mbanɨvao bigibigiko wolaghɨye weya ramanda Leiban. I mbana ramanda le bigibigiko na i vakaiwoŋa na i vakatha ghamberegha i vwenyevwenye.” ");
INSERT INTO tgo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Na tembe ŋgoreiyeva, Jeikob i njimbuvaidi Leiban le vakathawe maa i mboromboro ŋgora le vakathawe va i vivako. ");
INSERT INTO tgo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Amba Loi i dagewa Jeikob iŋa, “U njogha e ghamban moli, iyava u rimbunɨkowe, iya len bodaboda nanjikowe noroke, na ya dagerawe mbene weiŋgu vara ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jeikob i variye toto weŋgiya Reitiyel na Leya na vethɨ thuwe e valɨvaŋga amalaghɨniye va inawe weiyaŋgiya thetheghan e lenji ghamba ghan nana. ");
INSERT INTO tgo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Mbaŋa thɨ vuthawe, amba i dage weŋgi iŋa, “Kaero ya njimbuvaidiya ramami le vakatha e ghino, maa ŋgoreiya va le vakatha e ghino mbaŋa va i vivako. Ko iyemaeŋge maa ya mararu, kaiwae Loi, iye bwebwe i kururuwe, maa i roiteteŋgo. Iye mbaŋake wolaghɨye mbe weiŋgu vara. ");
INSERT INTO tgo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ghemi kaero hu ghareghare va ya rovurɨgheghe laghɨye moli ya kaiwo ramami kaiwae, ");
INSERT INTO tgo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ko iyemaeŋge ramami le vakatha maa i emunjoru e ghino. I kwanɨyaroŋgo na ma i vamodo vakathaŋgo mbaŋa regha na regha. Iyemaeŋge Loi mava i vatomwewe na i vakatha vuyowo e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Thoŋgo Leiban va iŋa na ya mbanɨŋgiya thetheghanɨko e ghanjithuwathuwa na modaŋgu, mbala thetheghanɨko thɨ ghambɨ mbe e ghanjithuwathuwa eŋge. Ko iyemaeŋge thoŋgo va iŋa na ya mbanɨŋgiya e ghanjigagaeton na modaŋgu, thetheghanɨko mbene thɨ ghambɨŋgi eŋge e ghanjigagaeton na modaŋgu. ");
INSERT INTO tgo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kaero hu thuwe, Loi i mbana ramami le thetheghanɨko na i giya e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Mbaŋa regha mbaŋa thetheghanɨko ghanjimbaŋa thɨ vakatha gamagai, ya ghenelolawa ghenelolo regha. Bigiko va ya thuweko iyake. Mbe goutɨko ghɨmoghɨmoru eŋge e ghanji gagaetonɨko na bwebwebwako eŋge thɨ bababa thetheghan wanakauko e vwatanji. ");
INSERT INTO tgo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Gheneloloko e tɨne Loi le nyao thovuye i dage e ghino iŋa, ‘Jeikob.’ Ya gonjoghawe yaŋa, ‘Mbe ghinoke.’ ");
INSERT INTO tgo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kaero iŋa, ‘Wo u thuwe. Mbe goutɨna iya e ghanji gagaeton na e ghanjibwebwebwana eŋge iya thɨ bababa thetheghan wanakauna e vwatanji. Thɨ vakatha iyake kaiwae kaero ya thuwevao Leiban le vakathako wolaghɨye e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ghino Loi iyava ya yomarana e ghen Betel e tɨne. Na gheko u liŋgiya bunama olivɨ e varɨ na u vamidi woyavwatata kaiwae. Na tembe u vakathava dagerawe na u kururu e ghino Loi womberegha. Mbaŋake u vivatha len bigibigina na u njogha e ghambanɨna iyava u rinawe.’” ");
INSERT INTO tgo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Reitiyel na Leya thɨ gonjoghawe thɨŋa, “Thare the bigithan reghava ina ramameko e ghayayao tɨne ghime kaiwame? ");
INSERT INTO tgo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Thare le vakathako weinda ghamɨnae ŋgoreiya eto gharɨgharɨniye ghinda? Kaiwae maa mbe i vakuneŋainda eŋge, ko iyemaeŋge kaero i ghanɨvao mani iya len kaiwoko une. ");
INSERT INTO tgo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Emunjoru bigibigike wolaghɨye thiyake, iya Loi va i mban weya ramameko, kaero ghindawe na la ŋgamaŋgama kaiwanji. U vakatha budakaiya Loi i utugiyana e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Kaero Jeikob i vivatha na i wareri i njogha weya ramae Kenan e thivathivaniye. I takoŋgiya thetheghanɨko na le bigibigiko wolaghɨye va le yakuyaku Padan Aram e tɨne na i mban vathavatha. Le ovo na le ŋgamaŋgama thɨ rakatha e kamel vwatanji na amalaghɨniye i takoŋgiya thetheghanɨko na i viva e ghamwanji. ");
INSERT INTO tgo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mbaŋa Leiban kaero i wa na ve tena sip vulivuliye wul kaiwae, e ghereiye amba Reitiyel i kaiva ŋgoloko mbe ghaloi vatavatadɨ. Iyako mbe ramaewe. ");
INSERT INTO tgo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jeikob i ravunyivunyi weya Leiban rara Aram na mava i utugiyawe le wareriko utuniye. ");
INSERT INTO tgo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Iya kaiwae weiyaŋgiya le ovo, i vo bigiya le bigibigiko wolaghɨye. I lawa e walaghɨta laghɨye Yupreitis na i loŋgaŋa bobokulu thivathivaniye idae Giliyad. ");
INSERT INTO tgo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mbaŋa theghetoniye e tɨne Leiban amba i loŋwevaidi Jeikob kaero menda i vogha. ");
INSERT INTO tgo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","I vaŋguŋgiya le bodaboda ghɨmoghɨmoruko vavana na thɨ woreghamba weya Jeikob. Mbaŋa theghepirɨ e ghereiye i vuthavaleŋgi e bobokulu, Giliyad thivathivaniye ele valɨvaŋga. ");
INSERT INTO tgo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ko gougou eŋge ghenelolo e tɨne Loi i dage weya Leiban rara Aram iŋa, “Ya vanuwovɨrɨŋge. Thava ne u utu vatharɨ weya Jeikob.” ");
INSERT INTO tgo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jeikob i vatad le yoŋathowathowa e bobokulu vwatae Giliyad e tɨne. Na gheko Leiban i vuthavalewe. Weiyaŋgiya le wabwi thɨ vatad lenji yoŋathowathowa e valɨvaŋga regha evasiwanjiko. ");
INSERT INTO tgo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Leiban i dage weya Jeikob iŋa, “Mendava u vakatha budakai? Mendava u ravunyivunyi e ghino na u vovaŋguŋgiya yawarumbuŋgu theunyiwo ŋgoreiya wanakau thɨ laweŋgi gaithɨ e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Buda kaiwae mendava u ravunyivunyi e ghino na u vothuwole? Buda kaiwae maa mendava u dage e ghino, mbala valɨkaiwae ghino menda ya variyeŋga weiye warari, wothuwothu na thilo laiye? ");
INSERT INTO tgo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ma mendava u vatomwe e ghino na ya vandamo mwaewoŋgiya orumburumbuŋgu na otɨnatɨnanji. Emunjoru len vakathako maa weiye len renuwaŋa thovuye. ");
INSERT INTO tgo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Elo vurɨgheghe na valɨkaiwae ma vakatha vuyowo e ghen, ko iyemaeŋge me gougou rama le Loi i vanuwovɨrɨŋgo, iŋa, ‘Ne u ndeutuŋa utu regha weiye len ghare gaithɨ Jeikob we.’ ");
INSERT INTO tgo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","I thovuye eŋge kaero menda nuwanɨna nuwaiya u njogha e ghamban. Ko iyemaeŋge buda kaiwae mendava u lakaiva lo loiŋgike?” ");
INSERT INTO tgo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jeikob i gonjoghawe iŋa, “Va weiŋgu lo mararu kaiwae lo renuwaŋake va yaŋaeŋgeva mbwata ne u vothaŋaŋgo na u vaŋgu njoghaŋgiya oyawarumbuke e ghino. Iyake kaiwae va ya warerithuwole. ");
INSERT INTO tgo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ko iyemaeŋge thoŋgo u vaidiya the lolothan ina gheke mendava i mbana len loiŋgina, ne yaŋa na i mare. La bodaboda e maranji mbowo u tamwe ghanɨmbereghana. The bigi u vaidi ghenɨwe u mban.” Jeikob mava i ghareghare Reitiyel va i lakaiva Leiban le loiŋgiko. ");
INSERT INTO tgo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kaero Leiban ve tamwe Jeikob ele yoŋathowathowa na mbowo i wava we Leya le yoŋathowathowa na i wa weŋgiya le rakakaiwoma theunyiwoma, ko iyemaeŋge maa i vaidiya le loiŋgima. Amba i wava Reitiyel ele yoŋathowathowako. ");
INSERT INTO tgo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Reitiyel kaero me mbanuwo ŋgoloko ghaloiŋgima na i bigimban e kamelɨko gharathatha lenji ghamba yaku, na mbe i yaku e vwatae mbaŋa ramae i ruwe. Mbaŋa Leiban i tamwe ghatharaŋa yoŋathowathowako tɨne, ma i vaidi bigi regha mun. ");
INSERT INTO tgo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Reitiyel i dage weya ramae iŋa, “Wogiya laghɨye, thava gharen i gaithɨ wanaŋgo. Ma valɨkaiwaŋgu ya ndeghathɨ e maran; ya yaku e njamnjam.” Leiban me rovurɨgheghe e tamwe ko iyemaeŋge ma i vaidi mun le ŋgoloma ghaloiŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jeikob ghare i gaithɨ iwaeŋge i dage weya Leiban iŋa, “Ko va ya vakatha vara the tharɨ? Va ya rake the mbaro na i vatomwe e ghen iya u tamwe ghatharaŋgoke? ");
INSERT INTO tgo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kaiwae kaero mo tamweghatharaŋa lo bigibigike wolaghɨye, na mo vaidiya the bigi i mena e len ŋgoloma tɨne? U woraŋgiya gheke e ghamwandake, na ghen na ghino la gharɨgharɨke thɨ thuwe na thɨ ghethe thaghewoke kaiwanda. ");
INSERT INTO tgo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Theghathegha hoiwo ya yaku weiŋgu ghen. Ya njimbukiki wagiyawe len sip na gout na lenji ghambɨ mbe i thovuye eŋge vara. Tembe ŋgoreiyeva ma mbaŋa regha ya unɨgha len gout ghɨmoruna regha wo thalavu kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","The mbaŋa thoŋgo thetheghan mbwanjam regha i mena thɨvatharɨ kaiwae, mbe womberegha vara ya vamboromboro iya thɨ vatharɨko iyako. Iyemaeŋge thoŋgo i yomara ŋgoreiyako, u vavothaŋaŋgo na ya vamodo budakaiya va i ghawe gougou o ghararaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Yakuyakuke iyake va thɨ yomara e ghino elo njimbukiki weŋgiya len thetheghanɨko. Ghararaghɨye varae i tagavaŋaŋanyaŋgo na gougou njighɨnjighɨ kaiwae mbe ighɨviya iya eŋge e maraŋgu. ");
INSERT INTO tgo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Theghathegha hoiwo e tɨne vambe inanŋgu vara elen ŋgolona ŋgoreiye narunɨna ghino. Theghathegha hoyaworo na umbovarɨ e tɨne ya kaiwo yawarumbuke theunyiwoke kaiwanji na theghathegha umbowona len thetheghanɨna weŋgi. Ko othembe lo kaiwo va ŋgoreiyako, u vɨvɨva modaŋgu mbaŋa lemoyo. ");
INSERT INTO tgo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Thoŋgo rumbuŋgu Eibraham le Loi na Loiko iya bwebwe Aisake i kururukowe ma ina e ghino, emunjoru mbala menda u variye yathuŋgo kokowaŋgu. Ko iyemaeŋge Loi va i thuwe wovuyowoko na lo kaiwo vurɨghegheko kaiwan, iya kaiwae me gougou Loi i worawa ghan mbaro.” ");
INSERT INTO tgo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Leiban i thombeya Jeikob le utuutuko iŋa, “Wanakauke thiyake ghino lo ŋgaŋgaŋgi na tembe ŋgoreiyeva gamagaike thiyake ghino orumburumbuŋguŋgi na thetheghanɨke thiyake ghino lo thetheghan. Iya vara wolaghɨyeke u thuweŋgike mbe ghinowe eŋge. Iyemaeŋge e mbaŋake noroke ne ya vakatha budakai weŋgiya oyawarumbuŋguŋgike na gamagaike iyava thɨ ghambɨŋgike? ");
INSERT INTO tgo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nuwaŋguiya e mbaŋake iyake ghen na ghino ra vakatha dagerawe regha na Loi iye ghanda raghaghayawo e ghanda lughawoghawo.” ");
INSERT INTO tgo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kaero Jeikob i wo varɨ laghɨye regha na i vamidi na i tabo na nono, na i vanuwovɨrɨŋgi lenji dageraweko kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Amba Jeikob i dage weŋgiya le bodabodako iŋa, “Hu mbanɨvatha varɨvarɨ na hu wabwi na i voro.” Mbaŋa kaero thɨ vakathavao, amba Leiban na Jeikob thiya yaku na regha na thiya ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Leiban i rena wabwiko idae Jega Sahaduta (vaŋa Aram gharumwaru “vanuwovɨrɨ ghawabwi”), na Jeikob i rena idae Galid (vaŋa Kenan gharumwaru “vanuwovɨrɨ ghawabwi”). ");
INSERT INTO tgo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Leiban i dage weya Jeikob iŋa, “Varɨvarɨke ghawabwi iyake ne i vanuwovɨrɨinda dageraweke mara vakathake noroke.” Iya kaiwae Jeikob i rena idae Galid. ");
INSERT INTO tgo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Vambe thɨ renɨva idae Mijɨpa, kaiwae Leiban va iŋa, “Loi mbe ghamberegha vara i njimbukikinda na ra renuwaŋakikiya dageraweke iyake mbaŋa ne ra iteta valɨvaŋgake iyake. ");
INSERT INTO tgo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Thoŋgo ma u goru weŋgiya lo ŋgaŋgana theunyiwona, o thoŋgo u vaŋguŋgiva wanakau vavana weinjiyaŋgiya lo ŋgaŋgana, othembe ma lolo regha i utugiya weŋgo, wo u renuwaŋakiki eŋge Loi iye ghanda raghaghayawo e ghanda lughawoghawo.” ");
INSERT INTO tgo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Leiban tembe i dage weva Jeikob iŋa, “Wo u thuwe, varɨvarɨ wabwima iyake na varɨma i ndeghathɨma iyake. Kaero mara vakathaŋgi e ghandalughawoghaweke. ");
INSERT INTO tgo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Iya varɨvarɨke wabwike na iya i ndeghathɨke thiye ghandaraghaghayawo. Mane ya valaŋaniya wabwike na varɨke i ndeghathɨke na ya ghaona e len valɨvaŋgana na ya vakowanaŋge, na ghen tembe mane u valaŋaniyava wabwike na varɨke iya i ndeghathɨke na u mena e lo valɨvaŋgake na u vakowanaŋgo. ");
INSERT INTO tgo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Orumburumbunda lenji loiŋgi tembene thɨ ghethe thoŋgo ra renuwaŋakiki na ra vikikighathɨgha iya dageraweke iyake ghautuutuke wolaghɨye: thiye Eibraham le Loi na Neiho le loi.” Kaero Jeikob i tholo weya Loi iya ramae Aisake i mararuke e idae. ");
INSERT INTO tgo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","I vakatha vowo gheko e ouko vwatae amba i kula vathaŋgiya le bodabodako na thɨ ghana ghanɨŋgako iyako weinji. Ghanɨŋgako e ghereiye mbowo thɨ ghenava gheko. ");
INSERT INTO tgo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mbaŋambaŋa vena Leiban i thuweiru i vandamoŋgiya orumburumbuyeko na oyawarumbuyeŋgima na i mwaewo weŋgi. Amba i wareri na i njogha e ghambae. ");
INSERT INTO tgo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Mbaŋa Jeikob i loŋgaloŋga e kamwathɨ mborowae, Loi le nyao thovuthovuye vavana thɨ lavolevole. ");
INSERT INTO tgo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mbaŋa i thuweŋgi kaero iŋa, “Iyake Loi le ragagaithɨ lenji kiyamu.” Iya kaiwae Jeikob i rena ghembako idae Mahanaim. ");
INSERT INTO tgo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jeikob i variyeŋgiya ghevarivariye thɨ raka viva e ghamwae na vethɨ thuwe ghaghae Iso. Iye va ina Seir e vanautuma Idom e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jeikob i dage weŋgi na ne vethɨ utu weya Iso ŋgoreiyake: “Weya wogiya Iso. Len rakakaiwo Jeikob i variye utuutuke iyake e ghen. Vambe va yaku weya la ghai Leiban, na vambe va yaku vara gheko ghaghad noroke. ");
INSERT INTO tgo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mbaŋa inaŋgu e valɨvaŋgako iyako ya mban vathavathaŋgiya thetheghanɨke thiyake: burumwaka, doŋɨki, sip na gout. Na tembe ŋgoreiyeva gharɨgharɨke thiyeke: rakakaiwo ghɨmoghɨmoru na rakakaiwo wanakau. Mbaŋake ya variye utuutuke iyake i ghaona e ghen, Iso, ghen giya laghɨye, ya woraweŋgo e ghamwanɨna, thoŋgo u warari kaiwaŋgu valɨkaiwae ne u vaŋguvathaŋgo mbaŋa ne ya vutha e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mbaŋa ravarivariye va thɨ raka njoghama weya Jeikob kaero thɨ dagewe thɨŋa, “Mendava wo raka weya ghagha Iso, na mbaŋake kaero ina e kamwathɨ mborowa i loŋgaloŋga, i mena na i lavolevoleŋge. Iye weiyaŋgiya ghɨmoghɨmoru hoseriyevarɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Mbaŋa Jeikob i loŋwe utuutuko iyako i vakatha na i mararu laghɨye. Le renuwaŋa iŋaeŋgeva mbwata ne i mena na i vakatha thɨgha va le vakathamawe. Iwaeŋge i wabwiya gharɨgharɨko weiyaŋgiko na wabwiwo, na le thetheghanɨko, sip, gout, burumwaka na kamel, tembe ŋgoreiyeva. ");
INSERT INTO tgo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Le renuwaŋako iŋava, “Thoŋgo Iso i vutha weime na i gaithɨ, mbala i gaboŋgi eŋge wabwi regha na wabwi regha thɨ rakavo.” ");
INSERT INTO tgo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Amba Jeikob i naŋgo iŋa, “Aee, Giya Loi, ghen rumbuŋgu Eibraham le Loi, na bwebwe Aisake le Loi. O Giya Loi, ghen va u dage e ghino na uŋa, ‘U njogha e ghamban moli weŋgiya len bodaboda,’ na u dagerawe na bigibigike thovuthovuye wolaghɨye ne thɨ yomara e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mbe gharen vara e ghino. Mbaŋake wolaghɨye mbe inan vara evasiwaŋgu mbaŋa ne nuwaŋguiyaŋge. Othembe maa valɨkaiwaŋgu u vamboromboro bigibigike thovuthovuye wolaghɨye e ghino. Mbaŋa va ya ri gheke na ya gheoko na e Walaghɨta Jorɨdan vambe ya wo eŋge pwasike, ko iyemaeŋge mbaŋa ya njoghama, ya vwenyevwenye laghɨye moli na lo ŋgaŋga na thetheghan wabwi thegheiwo. ");
INSERT INTO tgo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Wo u thalavuŋgo na u vaŋguraŋgiyaŋgo ghaghaŋgu Iso e nɨmae ghare! Kaiwae ya mararu ne i mena i tagavamareŋgo, na tembe ŋgoreiyeva lo ovoke na gamagaike. ");
INSERT INTO tgo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ko iyemaeŋge va u dagerawe e ghino na uŋa, ne i thovuye e ghino na orumburumbuŋgu lemoyo ŋgoreiya kerakera e njighɨko ghadidiye, iya maa valɨkaiwae lolo regha i vaonako.” ");
INSERT INTO tgo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Gougou i ghena gheko. Mbaŋambaŋavena Jeikob i ghathe bigibigi vavana na ne i variye weya ghaghae Iso: ");
INSERT INTO tgo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","gout wanakau hoseriyeiwo (200) na hoiwo ghɨmoghɨmoru, hoseriyeiwo (200) sip wanakau na hoiwo ghɨmoghɨmoru, ");
INSERT INTO tgo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ghweto kamel wanakau weinjiyaŋgiya lenji ŋgaŋga, ghwevarɨ burumwaka wanakau na hoyaworo ghɨmoghɨmoru, na hoiwo doŋɨki wanakau na hoyaworo ghɨmoghɨmoru. ");
INSERT INTO tgo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Jeikob i vaŋguraweŋgiya thetheghanɨko e wabwi regha iya na le rakakaiwoko thɨ njimbukikiŋgi. Amba i dage weŋgi iŋa, “Hu raka viva e ghamwaŋgu. Wabwi regha iya mbe lemi loŋga na mbe e ghami lughawoghawo iya e lemi wabwina regha na regha.” ");
INSERT INTO tgo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kaero Jeikob i dage weya rakakaiwoko iya ne i vivako iŋa, “Mbaŋa ghaghaŋgu Iso i lavolevoleŋge na i vaitoŋge na iŋa, ‘Ko u mena weya the giyathan, aŋga ghamwan i reŋa, na thela le thetheghanɨŋgiya wolaghɨye thiyake?’ ");
INSERT INTO tgo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","na mbala u gonjoghawe na uŋa, ‘Ghen ghan mwaewo, wo giyana. Thɨ mena weya len rakakaiwo na valɨgharegharen ghagha Jeikob. Amalaghɨniye ghaamba. Mbe ina i rereghamba e ghereimeko.’” ");
INSERT INTO tgo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Tembe i utugiyava utuutuma me utugiyama weya wabwima i vivama; i utugiya weŋgiya wabwi theghewoniye, theghetoniye na wabwiko wolaghɨye, iŋa, “Tembene hu utuŋa ŋgoreiyeva iya ma utuŋakaiko weya Iso mbaŋa ne hu lavolevole.” ");
INSERT INTO tgo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Na Jeikob mbowo i dageva weŋgi iŋa, “Hu renuwaŋakiki na hu dagewe ‘len rakakaiwo valɨgharegharen Jeikob maiya i rereghamba e ghereimeko.’” Jeikob va i rerenuwaŋa na iŋa, “Mbala bigibigike thiyake thɨ wo nuwae na mbaŋa ne va vuthawe, mbwatane i numotena lo vakatha vatharɨmawe na i vaŋguvathaŋgo.” ");
INSERT INTO tgo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kaero Jeikob i variye mwaewoma e ghamwae, ko iyemaeŋge amalaghɨniye mbowo i roghenava e kiyamuko. ");
INSERT INTO tgo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Va gougouko iyako Jeikob i thuweiru na i vaŋguŋgiya le ovo theunyiwoma, le rakakaiwo wanakau theunyiwoma na le ŋgaŋga ghɨmoghɨmoru theyaworo na regha na i variyeŋgi na thɨ rakalawa e walaghɨta idae Jabok. ");
INSERT INTO tgo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Le vakathako iyako e ghereiye, Jeikob me mbana le bigibigiko wolaghɨye e kiyamuko na i variye weiyaŋgiya le rakakaiwoko e walaghɨtako valɨvaŋga, ");
INSERT INTO tgo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ko iyemaeŋge mbe ghamberegha i reyaku e kiyamuko. Amba lolo regha i yomarawe na i gaithɨ weiye. Thɨ velawelaweŋgi ghaghad i ghera buruburuko rɨghe. ");
INSERT INTO tgo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mbaŋa loloko i thuwe maa tembe valɨkaiwaeva i kivwala Jeikob, iwaeŋge i ŋge na i vovu lemwa. Ko iyemaeŋge Jeikob mbe i rovurɨgheghe vara na thɨ lawelawe weiye. ");
INSERT INTO tgo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Amba loloma i dage weya Jeikob iŋa, “U viyathuŋgo na ya wa, kaiwae kaero iya vara i ghɨviyake.” Jeikob i gonjoghawe iŋa, “Mane ya viyathuŋge ghaghad u giya wo mwaewo.” ");
INSERT INTO tgo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Loloko i vaito iŋa, “Idan thela?” I gonjoghawe iŋa, “Jeikob.” ");
INSERT INTO tgo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Loloko i dagewe iŋa, “Kaiwae mo rovurɨgheghe wein Loi na weinaŋgiya gharɨgharɨ, na mo ghataŋaghathɨ ghaghad le ghambako, mbaŋake ya vɨva idanɨna. Idan togha Isirel.” ");
INSERT INTO tgo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jeikob i dagewe iŋa, “Mbaŋake u unogiyama idanɨna e ghino.” Ko iyemaeŋge i gonjoghawe iŋa, “Buda kaiwae nuwaniya u ghareghare idaŋgu?” Amba i giya Jeikob ghamwaewa. ");
INSERT INTO tgo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Iya kaiwae Jeikob i rena valɨvaŋgako iyako idae Peniyel iŋa, “Kaiwae ma thuwe Loi na namoghawame weiŋgu ko iyemaeŋge mbe e yawayawaliŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Varae i yovoro Jeikob i iteta Peniyel, na i loŋga vaŋgeŋge kaiwae loloma menda i vovuya le mwa. ");
INSERT INTO tgo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Iyake kaiwae, noroke Isirel orumburumbuye maa thɨ ghana thetheghan mamandiye i vɨghatha le mwako, kaiwae va e mamandiyeko iyako iyava loloko va i ŋge Jeikob kowe. ");
INSERT INTO tgo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","E lenji loŋga e tɨne Jeikob i tagathɨna marae na i thuwe e ghamwanjiko, Iso, amba i menamenako weiyaŋgiya ghɨmoghɨmoru hoseriyevarɨ. Kaero i wabwiŋgiya le ŋgaŋga: Leya wabwira, Reitiyel wabwira na le rakakaiwo wanakau theunyiwoma wabwira. ");
INSERT INTO tgo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Jeikob i vaghetheŋgiya wabwiko ŋgoreiyake: le rakakaiwo wanakauma na lenji ŋgaŋga thɨ raka viva, e ghereinji Leya na le ŋgaŋga, na muyai moli Reitiyel na nariye Josep. ");
INSERT INTO tgo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jeikob ghamberegha i viva moli vara e ghamwanji na wo vevuthakai weya Iso. Mbaŋa kaero i loŋga thaiya Iso, i ronja e gheghe vuvuye i kururu na ghamwae i nja e thelauko vwatae mbaŋapirɨ mbaŋa i loŋgaloŋga thaiya ghaghae Iso. ");
INSERT INTO tgo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ko iyemaeŋge Iso i ruku na i ghemba Jeikob, i thuwobod i bigiyatho nɨmanɨmae e numwe na i vandamo. Lenji warari kaiwae thɨ vethuweŋgi na mbe theghewoko vara thɨ randa kaiwae warari i riyevanjaraŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Iso i tagathɨna marae na i thuweŋgiya wanakau na gamagai, kaero i vaito iŋa, “Thavala iya gharɨgharɨke weinaŋgike?” Jeikob i gonjoghawe iŋa, “Loi va i thovuye moli e ghino, iyava i giya gamagaike thiyake e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Rakakaiwo wanakauma thɨ raka vutha weinjiyaŋgiya lenji ŋgamaŋgama na thɨ kururuwe, ");
INSERT INTO tgo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","evasiwae Leya na le ŋgaŋga thɨ raka mena na thɨ kururuwe. Moumouniye Josep na Reitiyel thɨ mena na thɨ kururu weya Iso. ");
INSERT INTO tgo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iso i vaito Jeikob iŋa, “Buda kaiwae menda u variyeŋgiya thetheghanɨko thɨ raka viva e ghamwan iya menda ya lavolevoleŋgiko?” Jeikob i gonjoghawe iŋa, “Menda ya variyeŋgi e ghen, wogiya laghɨye, ghanɨmwaewo ne i vakatha na u warari kaiwaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ko iyemaeŋge Iso i gonjoghawe iŋa, “Kaero valɨkaiwaŋgu, ghaghaŋgu. Budakai menda u mban, mbe ghenɨwe.” ");
INSERT INTO tgo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jeikob i gonjoghawe iŋa, “Aee ghaghaŋgu, thava! Thoŋgo gharen ma gaithɨ wanaŋgo, ko u mbana mwaewona menda ya variyena e ghen. Mbala ya ghareghare gharen i nja weŋgo ŋgoreiye Loi va i wovatha na ghare i nja weŋgo. ");
INSERT INTO tgo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ago laghɨye e ghen, mbema u wovatha eŋge lo renuwaŋake na u mbana bigibigina mendava ya variyena e ghen. Na kaiwae Loi vambe ghare vara e ghino i vakathaŋgo lo bigibigi lemoyo na valɨkaiwaŋgu.” Jeikob i vavothaŋa ghaghae iya kaiwae Iso i wovatha na i mbana mwaewoko iyako. ");
INSERT INTO tgo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Iso i dage weya ghaghae Jeikob iŋa, “Ko ra wareri eŋge mbaŋake, na ghino ya viva e ghamwan.” ");
INSERT INTO tgo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ko iyemaeŋge Jeikob i dagewe iŋa, “Amalana, u ghareghare gamagai maa valɨkaiwanji thɨ maya e loŋga ŋgoreiya ghen len loŋgana. Na tembe ya rerenuwaŋava thetheghan thɨ ghambɨ totogha kaiwanji. Thoŋgo ya vakathaŋgi thɨ loŋga vurɨgheghe, mbene mbaŋa reghaeŋge e tɨne, kaero thiya marevao. ");
INSERT INTO tgo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Iya kaiwae ya naŋgo e ghen, amalana, u viva e ghamwaŋgu. Tembene seiwoseiwo ya rereghamba na gamagaike na thetheghanɨke ne thɨ loŋga lama loŋga, ghaghad ne va vutha e ghen Seir.” ");
INSERT INTO tgo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Iso i gonjoghawe iŋa, “I thovuye, thare ne ya iteteŋgi eŋge lo gharɨgharɨke vavana na thɨ thalavuŋge.” Ko iyemaeŋge Jeikob i gonjoghawe iŋa, “Ago laghɨye e ghen, wogiya laghɨye, kaero emunjoru mo vatomwe gharen e ghino na mo vaŋguvathaŋgo, na iyake mbe valɨkaiwaŋgu eŋge.” ");
INSERT INTO tgo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Iya kaiwae e mbaŋako iyako Iso i wareri na i njogha Seir. ");
INSERT INTO tgo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ko iyemaeŋge Jeikob ve vutha e ghemba regha idae Sakot. Gheko i vatada ŋgolowe kaiwanji na yoŋathowathowa thetheghanɨko kaiwanji. Iya kaiwae ghembako iyako idae Sukot. ");
INSERT INTO tgo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jeikob va i ri Padan Aram na le loŋga e tɨne mbaŋa eŋge i ghaŋgoghaŋgo, na e mbaŋake iyake i vutha ghemba laghɨye Sekem Kenan e tɨne weiye le thovuye. Mbowo i lakiyamu eŋge Sekem ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Va i vamodo thelauko iyako weŋgiya amala regha idae Heimo le ŋgaŋga ghɨmoghɨmoru. Modae le laghɨlaghɨye silva gethɨthaŋarɨ. Heimo nariye regha idae Sekem. ");
INSERT INTO tgo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Jeikob i vatad ghamba vowo gheko na i rena idae El Elohi Isirel. ");
INSERT INTO tgo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Va mbaŋa regha Daina, Jeikob na Leya yawarumbunji, i raŋgi na i wa ve thuweŋgiya Kenan wanakauniye vavana. ");
INSERT INTO tgo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mbaŋa Sekem, Heimo nariye, iye rara Hivi na valɨvaŋgako iyako gharandeviva, i thuwe Daina na nuwaeko ma nuwaiya vara moli. Iwaeŋge i vaŋgu na i vavurɨgheghe na i yathima weiye. ");
INSERT INTO tgo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ko iyemaeŋge vakathako iyako e ghereiye Sekem vambe gharewe vara Daina na nuwaiya i vaŋgu, iya kaiwae i utuwe weiye le gharethovu. ");
INSERT INTO tgo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekem i dage weya ramae Heimo iŋa, “Wo u vanamwe wevoko utuutuniye kaiwaŋgu na ya vaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Mbaŋa ubotu Jeikob i loŋwevaidiya yawarumbuye Daina utuniye, Sekem i vavurɨghegheŋa na i yathima weiye na i vakatha kaero i mbighɨ. Iyemaeŋge mbe i rokubaroŋa eŋge, kaiwae le ŋgaŋga ghɨmoghɨmoru vambe inanji e valɨvaŋga nana inawe thɨ njimbukikiŋgiya thetheghan. ");
INSERT INTO tgo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Iwaeŋge Heimo, Sekem ramae, i wa weya Jeikob na ve utuŋa Daina utuniye weiye. ");
INSERT INTO tgo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jeikob le ŋgaŋga thɨ loŋwe vakathako iyako utuniye mbaŋa thɨ ri e valɨvaŋgako iyako na thɨ njogha weya ramanji. Gharenji i yo weinji ghatemuru na gaithɨ, kaiwae Sekem i vakatha monjina weya Jeikob na le bodaboda mbaŋa i yathima weiye Daina. Vakathako iyako i tharɨ na mbala thava i vakatha. ");
INSERT INTO tgo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Mbaŋa Jeikob na le ŋgaŋga thɨ mevathavatha, Heimo i vamanjamanjalaŋa le menako rɨghe weŋgi iŋa, “Naruŋguko Sekem gharewe vara wevoko iya yawarumbunɨko, Daina. Aee, thare valɨkaiwae hu vatomwe na i vaŋgu. ");
INSERT INTO tgo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ghemi na ghime ra vanamwe ghe kaiwae noroke. Thoŋgo hu vatomwa oyawarumbumina weŋgiya ghama theghake na thɨ vaŋguŋgi, tembene wo vatomweva oyawarumbumeko weŋgiya ghami theghana thɨ vaŋguŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Valɨkaiwae hu yaku weime. The valɨvaŋga nuwamiya hu yakuwe vo hu yakuwe. Hu kunewe na hu vamodo lemi ghamba yakuyakuwe.” ");
INSERT INTO tgo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Amba Sekem i dage weŋgiya Daina ramae na olouye iŋa, “Aee, thoŋgo hu wovatha lo renuwaŋake ne ya giya e ghemi the bigiya nuwamiya e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Valɨkaiwae hu worawa lemi vathavoko na ghami mwaewo, le laghɨlaghɨye ŋgoreiya lemi renuwaŋana na ya mbanɨmena. The bigithan hu naŋgo ne ya wo mena. Mbema hu vaŋgugiyama eŋge wevoko na lo wevo.” ");
INSERT INTO tgo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ko iyemaeŋge Jeikob le ŋgaŋga mava thɨ utu emunjoru weŋgiya Sekem na ramae. Va nuwanjiya thɨ lithɨ weya Sekem budakaiya va le vakathako weya lounji Daina. ");
INSERT INTO tgo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Thɨ dage weŋgi thɨŋa, “Maa valɨkaiwae wo vakatha ŋgoreiyako. Mane wo vaŋgugiya loumeko weya ghɨmoru maa i wo kitenɨyathu thanavuniye. Iyako ne i vakatha ghamba monjina weime. ");
INSERT INTO tgo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mbe kamwathɨ regha eŋge na ne wo vatomwe e ghemi na ghɨmoghɨmoru e lemi valɨvaŋgana thɨ vaŋguŋgiya wanakau e lama valɨvaŋgake. Ghɨmoghɨmoru e lemi valɨvaŋgana wo thɨ wo kitenɨyathu thanavuniye na thɨ tabo ŋgoranjiya ghime. ");
INSERT INTO tgo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Thoŋgo ne hu vakatha ŋgoreiyako amba ne wo vatomwe e ghemi na hu vaŋguŋgiya wanakau weime na lemi ovo, na ghime tembe wo vaŋguŋgiva wanakau e lemi valɨvaŋgana. Amba ne wo yaku weimaŋgiya ghemi na ra tabo wabwi regha gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ko thoŋgo ghɨmoghɨmoruna maa thɨ warariŋa thɨ kitenɨyatho riwanji mbothiye njimwae, ne wo vaŋgwa loumeko na wo iteta lemi valɨvaŋgake.” ");
INSERT INTO tgo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Heimo na nariye Sekem thɨ warariŋa lenji utu vanamweko kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Na Sekem mbema ghe na nɨmae eŋge kaero ve vakatha budakaiya Jeikob le ŋgaŋga lenji woraŋgiya weŋgi, kaiwae va nuwaeko nuwaiya moli Jeikob yawarumbuye Daina. Amalaghɨniye vambe i viviva vara ramae Heimo ele renuwaŋako e ghayayaoko tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Iya kaiwae Heimo na nariye Sekem thɨ wa e lenji ghamba nivako, e ghembako ghaghambaru evasiwae na thɨ utu weŋgiya ghembako gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Thɨŋa, “Gharɨgharɨke thiyake thɨ thovuye moli na gharemalɨlɨ gharɨgharɨniyeŋgi. Valɨkaiwae ra vatomwe weŋgi ra yaku weindaŋgi e valɨvaŋgake iyake na ra kune weindaŋgi. Thelauko i laghɨye moli, valɨkaiwanda eŋge. Ghɨmoghɨmoru ela valɨvaŋgake thɨ vaŋguŋgiya wanakau weŋgi, na ghɨmoghɨmoru e lenji valɨvaŋgako thɨ vaŋguŋgiya wanakau ela valɨvaŋgake. ");
INSERT INTO tgo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Iyemaeŋge, mbene thɨ warariŋa eŋge ra yaku weindaŋgi na ra tabo na wabwi regha gharɨgharɨniyeŋgi thoŋgo ghɨmoghɨmoru ela valɨvaŋgake thɨ wo kitenɨyathu thanavuniye ŋgoreiya thiye. ");
INSERT INTO tgo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Thoŋgo ra varaeŋna, lenji bigibigiko wolaghɨye ne ghindawe; lenji thetheghanɨko wolaghɨye na the bigithanɨva ina weŋgi. Ko mbema ra vakatha eŋge lenji renuwaŋako na ne thɨ yaku e valɨvaŋgake iyake.” ");
INSERT INTO tgo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ghɨmoghɨmoruko wolaghɨye iyava thɨ raka iteta ghamba nivako thɨ wovathovuthovuyeŋa Heimo na nariye Sekem lenji utuko na ghɨmoghɨmoru wolaghɨye e ghembako tɨne thɨ wo kitenɨyathu thanavuniye. ");
INSERT INTO tgo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mbaŋa theghetoniye e tɨne, mbaŋa ghɨmoghɨmoru e ghembako tɨne riwanjiko mbothiye vamba thɨ thighathigha, kaero Jeikob le ŋgaŋga theghewo, Simiyon na Livai, Daina olouye, thɨ mbana lenji gaithɨ ghaghalithɨ, vethɨ ru e ghembako tɨne; mbaŋaniye ghembako maa e lenji ghareghare mun, na thɨ gabovaoŋgiya ghɨmoghɨmoruko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Tembe thɨ gaboŋgiva Heimo na nariye Sekem, na thɨ vaŋgwa Daina Sekem ele ŋgolo amba thɨ njogha. ");
INSERT INTO tgo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jeikob le ŋgaŋgama vavana thɨ raka ru e ghembako tɨne ŋgora ramaremareko riwanji, thɨ raka ru e ŋgoloŋgolo na thɨ mbana bigibigiko wolaghɨye. Lenji vakathako iyako thɨ lithɨgha budakai Sekem va le vakatha raitharɨ weya lounji Daina. ");
INSERT INTO tgo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Thɨ takoŋgiya lenji sip, gout, burumwaka na doŋɨki va inanji e ghembako tɨne na tembe ŋgoreiyeva wolaghɨyeko inanji eto e lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Thɨ bigivao lenji vwenyevwenyeko bigibiginiye wolaghɨye, na tembe ŋgoreiyeva wanakau na gamagai, na the bigiva inanji e ŋgoloŋgolo thɨ bigivao na iko. ");
INSERT INTO tgo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jeikob i dage weŋgiya Simiyon na Livai iŋa, “Mbaŋake kaero u vaŋguraweŋgo e vuyowo tɨne. Kenan gharɨgharɨniye na Perisi gharɨgharɨniye na the gharɨgharɨva inanji gheke ne thɨ botewoyathuŋgo. Na i ghao maa ghɨmoghɨmoru lemoyo nanji e ghino. Thoŋgo thɨ loŋwevaidiinda na thɨ wabwi na regha, na thɨ gaithɨ weinda ne valɨkaiwanji thɨ mukuwoinda.” ");
INSERT INTO tgo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ko iyemaeŋge thɨ gonjoghawe thɨŋa, “Ma tembe wo warariva Sekem le vakatha weya loumeko, ŋgoreiya wanakau thɨ vakuneŋa riwanji yathima e thanavuniye, iya kaiwae wo lithɨwe.” ");
INSERT INTO tgo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Amba Loi i dage weya Jeikob iŋa, “U yondo virɨ. U wa Betel na vo vatada len kiyamu gheko, ne tembe vo vatadɨva ghamba vowo weya Loi, iyava i yomarama e ghen mbaŋa va u vogha weya ghagha Iso.” ");
INSERT INTO tgo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jeikob i dage weŋgiya ghayayaoko gharɨgharɨniye na thavalava va weiyaŋgi iŋa, “Hu bigi raŋgiya loi kwanɨkwanɨna wolaghɨye iya hu kururuna weŋgi. Hu mban vathaŋgi na ra yathuŋgi. Hu njimboŋgiya kwama thɨ thɨna na hu vivathaŋga kururu kaiwae weya Loi. ");
INSERT INTO tgo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Hu vamayaŋa na ra raka Betel. Ne va vatada ghamba vowo gheko na ra kururu weya Loi, iye va i thalavuŋgo e wo vuyowo tɨne. Na amalaghɨniye vambe weiŋgu vara the valɨvaŋga va ya reŋawe.” ");
INSERT INTO tgo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kaero thɨ giya lenji loi kwanɨkwanɨma weya Jeikob na yanayanawanji ghae. Amba Jeikob i bekuŋgi e umbwa ouk raberabe Sekem ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mbaŋa Jeikob na le ŋgaŋga thiya wareri, mararu laghɨye i ru weŋgiya gharɨgharɨ e ghembaghemba evasiwanji na maa valɨkaiwanji thɨ woreghamba na thɨ gaithɨ weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jeikob na gharɨgharɨko wolaghɨye weiyaŋgiko thɨ raka vutha Luji (mbaŋake thɨ uno idako Betel) Kenan thivathivaniye e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Gheko i vatada ghamba vowo, na i rena idae El Betel kaiwae va gheko Loi i vatomwe ghamberegha weya Jeikob mbaŋa i vogha weya ghaghae Iso. ");
INSERT INTO tgo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Mbaŋa vambe thɨ yakuyaku Betel ghadidiye kaero Debora iye elaghɨsarɨ moli, i mare. Elaghɨniye va Rebeka gharanjimbunjimbu mbaŋa iye vamba ŋgama vara. Thɨ beku e umbwa Alon e rɨghe Betel na bode. Iya kaiwae thɨ uno idae “Umbwa Ouk Randarandaniye.” ");
INSERT INTO tgo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Mbaŋa Jeikob vama i iteta Padan Aram na i njogha Betel, Loi mbowo i yomaraweva na i giya ghamwaewo. ");
INSERT INTO tgo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Loi i dagewe iŋa, “Idan Jeikob, ko iyemaeŋge ma tembene mbaŋa reghava thɨ una idan Jeikob; ne idan Isirel.” Ko amba thɨ rena Jeikob idae “Isirel”. ");
INSERT INTO tgo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Amba Loi i dagewe iŋa, “Ghino Loi Vurɨghegheniye. U ghambɨrake na len ŋgaŋga lemoyo. Vanautuma ne thɨ rimbun e ghen, na orumburumbu e tɨnenji nevole kiŋ thɨ rakamenawe. ");
INSERT INTO tgo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Thelauko iyava ya dagerawe weya Eibraham na Aisake, tembe ya wogiyava e ghen. Tembene ya giyava iya thelauke iyake weŋgiya orumburumbu tha muyaiko.” ");
INSERT INTO tgo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mbaŋa Loi kaero i utuvao i roitete e valɨvaŋgako iyako. ");
INSERT INTO tgo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","E valɨvaŋgako vara iyako iya Loi me utukowe, Jeikob i vamidiya varɨwe. I liŋgiya waen na bunama i mena e olivɨ e vwatae na i vabobomaŋa Loi kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","I rena ghembako idae Betel. ");
INSERT INTO tgo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Mbaŋa gheviye e ghereiye Jeikob na le wabwi thɨ roiteta Betel. Eprat maa vama i bwagabwaga moli weŋgi, kaero Reitiyel ŋgamoiye i njivun na i rovurɨgheghe. ");
INSERT INTO tgo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mbaŋa vɨrɨko vama i vwe na i vwe, wevoko i thathalavukowe i dagewe iŋa, “Tha u gharelaghɨlaghɨ, mbowo ne u ghambɨva ŋgama ghɨmoru regha.” ");
INSERT INTO tgo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Reitiyel vama ghambaŋa i mare, ko iyemaeŋge amba muyai yawaliye iko i larena nariyeko idae Ben-Oni. Ko iyemaeŋge ramae Jeikob te vambe i rorenɨva idae Benjamin. ");
INSERT INTO tgo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Mbaŋa Reitiyel i mare thɨ beku e kamwathɨ i wa Eprat ghadidiye — noroke thɨ uno Betɨlehem. ");
INSERT INTO tgo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jeikob i vamidiya varɨ regha gheko na i tabo Reitiyel ghabubuyeko ghanono. Na varɨko iyako mbe inawe noroke. ");
INSERT INTO tgo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isirel (Jeikob idae togha Isirel) mbowo i loŋgaova Migɨdol Eda na seiwova, na gheko weiyaŋgiya le wabwi thɨ kiyamuwe. ");
INSERT INTO tgo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mbaŋa Isirel vamba ina e valɨvaŋgako iyako, amba Rubin i ru na i ghena weiye Bilha, ramae le rakakaiwo na levo eunda. Isirel i loŋwe vaidiya iyako na ghare i muru. Jeikob le ŋgaŋga lenji ghanaghanagha theyaworo na theghewo. ");
INSERT INTO tgo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya le ŋgaŋgaŋgiya: Rubin, Jeikob nariye virɨviva, Simiyon, Livai, Juda, Isaka na Sebulon. ");
INSERT INTO tgo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Reitiyel le ŋgaŋgaŋgiya: Josep na Benjamin. ");
INSERT INTO tgo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Reitiyel le rakakaiwo wevo, Bilha, le ŋgaŋgaŋgiya: Den na Napɨtalai. ");
INSERT INTO tgo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leya le rakakaiwo wevo, Silpa, le ŋgaŋgaŋgiya: Gad na Asa. Jeikob le ŋgaŋgake thiyake va thɨ ghambɨŋgi mbaŋa vamba ina Padan Aram. ");
INSERT INTO tgo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jeikob kaero i vutha weya ramae Aisake Memri e tɨne Kiriyat Aba ghadidiye. Mbaŋake iyake thɨ uno ghembako iyako idae Hebron. Eibraham na Aisake va thɨ yaku e valɨvaŋgako iyako. ");
INSERT INTO tgo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Aisake vama i amalaghɨsarɨ moli ghatheghathegha va i wo hothaŋarɨ na ghwewa (180) amba i garalawa weŋgiya orumburumbuye va thɨ mare vivako. Le ŋgaŋga Iso na Jeikob va thɨ beku. ");
INSERT INTO tgo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso orumburumbuye tha na tha utuutuninjiya iyake. Tembe idaeva Idom. ");
INSERT INTO tgo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso le ovo thiye Kenan wanakauniye. Le ovo theuto: Ada, Oholibama na Basimata. Ada ramae iye Het loloniye regha idae Elon. Oholibama ramae idae Ana na rumbuye ghɨmoru idae Sibiyon, iye Hivi loloniye. ");
INSERT INTO tgo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basimata ramae idae Ismel na louye idae Nebaiyot. ");
INSERT INTO tgo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Iso na le ovo thɨ ghambɨŋgi ghɨmoghɨmoruke thiyake. Ada i ghamba Elipas, Basimata i ghamba Riyuwel, ");
INSERT INTO tgo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","na Oholibama i ghambɨŋgiya Jeus, Jalam na Kora. Gamagaike thiyake le ovo thɨ ghambɨŋgi mbaŋa mbe inanji vara Kenan e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Iso i vaŋguŋgiya le ovo, le ŋgaŋga ghɨmoghɨmoru na wanakau, na gharɨgharɨko wolaghɨye e ghayayaoko tɨne, tembe ŋgoreiyeva le sip na gout, burumwaka na doŋɨki na le bigibigiko wolaghɨye va i mbanɨvathavatha Kenan e tɨne. I iteta valɨvaŋgako iyako na i wa e valɨvaŋga regha seiwo i bwagabwaga weya ghaghae Jeikob. ");
INSERT INTO tgo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iso na Jeikob lenji bigibigiko vama lemoyo moli na maa tembe valɨkaiwanjiva thɨ yaku na regha. Lenji thetheghanɨko va thɨ ghanagha moli na thelauko va thɨ yakuŋako mava nana i pokuwe lenji thetheghanɨko kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Iya kaiwae Iso, mbowo va thɨ unova idae Idom, ve yaku e bobokulu thivathivaniye idae Seir. ");
INSERT INTO tgo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iyake Iso orumburumbuye tha na tha utuutuninji. Amalaghɨniye Idom gharɨgharɨniye rumbunji, thiya yaku Seir, bobokulu thivathivaniye e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso le ŋgaŋga idanji thiyake: Elipas, Iso levo Ada nariye, na Riyuwel, Iso levo Basimata nariye. ");
INSERT INTO tgo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elipas le ŋgaŋgaŋgiya: Timan, Oma, Sepo, Gatam na Kenas. ");
INSERT INTO tgo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Iso nariye Elipas vambe le rakakaiwo wevova idae Timna. Vambe i ghambɨva weiye na nariye idae Amalek. Theghewonake thiyake Iso levo Ada orumburumbuyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Iso nariye Riyuwel le ŋgaŋga theghevarɨ: Nahat, Sera, Sama na Misa. Thiyake Iso levo Basimata orumburumbuyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iso levo Oholibama, iye Ana yawarumbuye na iye tembe Sibiyon rumbuyeva. Va i ghambɨ weiye Iso le ŋgaŋgaŋgiya thiyake: Jeus, Jalam na Kora. ");
INSERT INTO tgo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Idom gharɨgharɨniye na lenji randeviva thiya rimbun weya Iso thiyake: E tɨnenji va Elipas, iye Iso nariye virɨviva, orumburumbuyeŋgi. Randevivaŋgike thiyake: Timan, Oma, Sepo, Kenas, Kora, Gatam na Amalek. Thiyake Iso levo Ada orumburumbuyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Wabwike thiyake thɨ rimbun weya Iso nariye Riyuwel: Nahat, Sera, Sama na Misa. Thiye Iso levo Basimata orumburumbuyeŋgi. Te vambe thɨ yakuva Idom e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wabwike thiyake, Jeus, Jalam na Kora, va thɨ rimbun weya Iso levo Oholibama, iya tɨnae idae Ana. ");
INSERT INTO tgo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Thiyake va Iso onanariyeŋgi na wabwi regha na regha va thɨ rimbun weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Thiyake Seir orumburumbuyeŋgi thɨ mena wabwi Hor e tɨne, thiya yakukai e valɨvaŋgake iyake: Lotan, Sobal, Sibiyon, Ana, ");
INSERT INTO tgo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Esa, na Disan. Iya Seir orumburumbuyeke thiyake inanji Idom na thiye Hor gharɨgharɨniye lenji randevivaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan le ŋgaŋgaŋgiya ghɨmoghɨmoruke thiyake: Hori na Homam. Na Lotan louye idae Timna. ");
INSERT INTO tgo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal le ŋgaŋgaŋgiya ghɨmoghɨmoruke thiyake: Alvan, Manahat, Ibal, Sipo na Onam. ");
INSERT INTO tgo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibiyon le ŋgaŋga ghɨmoghɨmoruke thiyake: Aiya na Ana. Ana iye va i vaidiya mbwarowou i dayagha e vuruvuru vwatavwata e tɨne mbaŋaniye i njimbukikiŋgiya ramae Sibiyon le doŋɨki. ");
INSERT INTO tgo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana le ŋgaŋga thiyake: Dison na Oholibama, elaghɨniye Ana yawarumbuye. ");
INSERT INTO tgo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison le ŋgaŋga ghɨmoghɨmoruke thiyake: Hemdan, Esban, Itɨran na Karan. ");
INSERT INTO tgo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esa le ŋgaŋga ghɨmoghɨmoruke thiyake: Bilhan, Saavan na Akan. ");
INSERT INTO tgo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan le ŋgaŋga ghɨmoghɨmoruke thiyake: Us na Aran. ");
INSERT INTO tgo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Thiyake randevivaŋgi Hor gharɨgharɨniye e tɨnenji: Lotan, Sobal, Sibiyon, Ana, Dison, Esa, na Disan. Thiye va thɨ mbaro weŋgiya Hor gharɨgharɨniye Seir e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Amba muyai Isirel gharɨgharɨniye va e lenji kiŋ, Idom e tɨne kiŋ vama inanjiwe thɨ mbaro. Iya idaidanjiyake: ");
INSERT INTO tgo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, iye Beor nariye. Va ina e ghemba Dinhaba na i mbaro Idom e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Mbaŋa Bela i mare, Jobab iye Sera nariye i mena e ghemba idae Bosra kaero i rothɨghɨva. ");
INSERT INTO tgo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Mbaŋa Jobab i mare, Husam iye i ri e valɨvaŋga regha idae Timan kaero i rothɨghɨva. ");
INSERT INTO tgo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Mbaŋa Husam i mare, Haded, iye Beded nariye kaero i tabona kiŋɨva. Va i kivwalaŋgiya Midiyan gharɨgharɨniye Mowab e tɨne. Va i yaku e ghemba idae Avit na i mbarowe. ");
INSERT INTO tgo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Mbaŋa Haded i mare, Samla kaero i rothɨghɨva. Iye i mena e ghemba regha idae Masreka. ");
INSERT INTO tgo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Mbaŋa Samla i mare, Saul kaero i rothɨghɨva. Va i yaku e ghemba regha idae Rehobot ina e walaghɨta ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Mbaŋa Saul i mare, Baal-Hanan kaero i rothɨghɨva. Iye Akba nariye. ");
INSERT INTO tgo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Mbaŋa Baal-Hanan, Akba nariye, i mare, Haded kaero i rothɨghɨva na i tabo kiŋ. Va i yaku e ghemba regha idae Pau. Levo idae Mihitabel, Matred yawarumbuye na rumbuya Me-Saheb. ");
INSERT INTO tgo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Wabwike thiyake ghanji riuriu rɨgheya Iso. Lenji randevivaŋgi Timna, Alva, Jetet, Oholibama, Ela, Pinon, Kenas, Timan, Mibɨsa, Magɨdiyel na Iram. Thiyako thɨ yaku Idom e tɨne. Na ghambanji thivathivaniye idaidanji thɨ mena weya lenji randeviva idaidanji. Gharɨgharɨke thiyake ghanjiwabwi rɨghe Iso, Idom gharɨgharɨniye orumburumbunji. ");
INSERT INTO tgo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jeikob vambe i yakuyaku vara Kenan e tɨne ŋgoreiye ramae va i yakukowe. ");
INSERT INTO tgo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Utuutuke iyake Jeikob riuriuniye. Mbaŋa Josep ghatheghathegha vama i wo hoyaworo na umbopirɨ, i wa ve njimbukikiŋgiya sip na gout weiyaŋgiya oghaghae, Bilha na Silpa lenji ŋgaŋga weinji ramae Jeikob. Mbaŋa vavana Josep i utugiya weya ramanji, oghaghae lenji vakatha raitharɨ utuniye. ");
INSERT INTO tgo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isirel le gharethovu weya Josep i kivwala va le gharethovu weŋgiya le ŋgaŋgako vavana, kaiwae Josep va i virɨ mbaŋaniye amalaghɨniye kaero i amalaghɨsarɨ. Iya kaiwae ramanji va i vakatha ghakwama thovuye moli, molao na nɨmanɨma tembe molamolaova. ");
INSERT INTO tgo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mbaŋa oghaghaema thɨ thuwe ramanji mbe i gharethovuwe vara Josep na maa tembe reghava e tɨnenjiko, mbema thɨ botewoyathu vara na maa tembe ghalɨŋanji i thovuye weva. ");
INSERT INTO tgo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Gougou regha Josep i ghenelolo, na mbaŋa i utugiya weŋgiya oghaghaeko i vakathaŋgi ma thɨ botewayathu vara moli. ");
INSERT INTO tgo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","I dage weŋgi iŋa, “Wo hu vandeŋe gheneloloke iya menda ya gheneloloŋake. ");
INSERT INTO tgo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mendava inanda wit e ghauma tɨne, ra yavayavatha wit mbambara iya. Iwaeŋge witɨma mbambara iya ghino va ya yavathama i yondo virɨ na i ndevanavana ghamberegha. Ghemi lemi yavathama thɨ rakaghɨliŋa ghinokowe na thɨ kururuwe.” ");
INSERT INTO tgo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Oghaghaeko thɨ dagewe thɨŋa, “Ko uŋa eŋge ne u tabo na kiŋ na u mbaroŋainda?” I vakatha weiye lenji gharegaithɨ mbema thɨ botewoyathu vara le gheneloloko na le utuutuko kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Injana mbowa i gheneloloŋava ghenelolo regha na i utugiya weŋgiya oghaghaeko, iŋa, “Wo hu vandeŋeŋgo! Mbowa ma gheneloloŋava ghenelolo regha. E mbaŋako iyako varae, manjala na ghɨtara voghɨyaworo na voghɨra thɨ kururu e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Josep tembe i utugiyava le gheneloloko weya ramae, ko iyemaeŋge ramae i govwara ghamwae na iŋa, “The ghenelola iya u gheneloloŋake? Uŋa eŋge tɨna, oghaghaeko na ghino ne wo kururu e ghen na wo vakatha ghan yavwatata?” ");
INSERT INTO tgo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Josep oghaghae thɨ yamwanja kaiwae, ko iyemaeŋge ramae mbe i rerenuwaŋa vara gheneloloko kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mbaŋa regha Josep oghaghae vama thɨ rakao thɨ njimbukikiŋgiya ramanji le sip na gout na vethiya ghan Sekem ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Amba ramae i dage weya Josep, iŋa, “Kaero u ghareghare, oghaghama thɨ njimbukikiŋgiya sip na gout na thiya ghan Sekem ghadidiye. Wo u vandeŋeŋgo, ya variyeŋge na u wa weŋgi.” I gonjoghawe iŋa, “I thovuye moli.” ");
INSERT INTO tgo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kaero ramae i dagewe, iŋa, “U wa na vo thuwe thoŋgo riwanji mbe thovuye eŋge na thoŋgo sip na goutɨko mbe thɨ thovuye eŋge. Amba u njoghama na u utugiya utuninji weŋgo.” Amba Josep i wareri Hebron malamoniye e tɨne. Mbaŋa Josep ve vutha Sekem ele valɨvaŋga, ");
INSERT INTO tgo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","amala regha i vaidi i tamwetamwe loloŋga oghaghae thetheghanɨko e lenji ghamba ghan na i vaito iŋa, “Ko u tamweya budakai?” ");
INSERT INTO tgo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","I gonjoghawe iŋa, “Ya tamwetamwe weŋgiya oghaghaŋguno. Thɨ njimbukikiŋgiya sip na gout thiya ghan. Thare u ghareghare aŋga inanji?” ");
INSERT INTO tgo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Amalama i gonjoghawe iŋa, “Kaero mendava thɨ roiteta iya valɨvaŋgake iyake. Va ya loŋwe thɨŋa, ‘Ra raka Dotan.’” Josep i rereghamba weŋgi oghaghaema na ve vaidiŋgi Dotan ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ko mbaŋa thɨ thuwe Josep i menamenako na amba e ghalughawoghawo weŋgi, kaero thɨ vona ghae na nuwanjiya thɨ tagavamare. ");
INSERT INTO tgo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kaero thɨ vedage weŋgi thɨŋa, “Ahaa! Ragheneloloma maiya vara i menana. ");
INSERT INTO tgo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","E mbaŋake iyake ra tagavamare, na ra wokiyathumban e gogake iya ma mbwake inawe. Tene va rakwan na raŋa, ‘Thetheghan mbwanjam menda i ghan.’ Na wo ra thuweno budakai ne thɨ yomara ele gheneloloŋgiko.” ");
INSERT INTO tgo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mbaŋa Rubin i loŋwe utuutuko iyako i mando na i vamoru oghaghaeko e nɨmanji ghare. I dage weŋgi iŋa, “Thava ra tagavamare.” ");
INSERT INTO tgo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Mbowo i dageva weŋgi iŋa, “Thava madibe ina e nɨmamina. Mbema hu wokiyathunjoŋa eŋge e gogake iya maa mbwake inawe na mbe i yakuwe na thava tembe nɨmami i waweva.” Rubin i utu ŋgoreiyako kaiwae va le renuwaŋa nuwaiya i vamoru e nɨmanji na i vaŋgunjogha weya ramae. ");
INSERT INTO tgo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Mbaŋa Josep i vutha weŋgi oghaghae thɨ ndelawelawe e nɨmanji, thɨ thethe ghakwamama ghayaboyabo iya molaoma ramae va i vakatha wagiyawema na i njimbo. ");
INSERT INTO tgo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kaero thɨ wo na thɨ dunjoŋa gogama iya maa mbwama inawe. ");
INSERT INTO tgo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Oghaghaema kaero thiya ghanɨŋga. E lenji ghanɨŋgako tɨne thɨ tagathɨna maranji kaero thɨ thuweŋgiya Ismel gharɨgharɨniye vavana amba thɨ menamenako e lenji kamel. Thɨ rakamena Giliyad ele valɨvaŋga. Kamelɨko va thɨ doweŋgiya bigibigi butinji thovuye e vwatanji ŋgoreiya gam, balɨm na mer. Va vethɨ vakuneŋaŋgi Ijipt e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Amba Juda i dage weŋgiya oghaghaeko iŋa, “Ne ŋgoroŋga ghathovuyako weinda thoŋgo ra tagavamara ghaghandako, ra wothuwole riwaeko na ra ravunyivunyiya le mareko utuniye? ");
INSERT INTO tgo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ra vakuneŋa eŋge weŋgiya Ismel gharɨgharɨniye na thava tembe nɨmanda i waweva. Wo hu thuwe mbe ghindake vara ghaghanda na mbunɨma na madibeko iyako, iya weindake.” Amba thɨ varaeŋna na thɨ vakatha iyako. ");
INSERT INTO tgo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mbaŋa Midiya rakunekune vavana thɨ mena evasiwanji, kaero vethɨ momodɨ voreŋa ghaghanji Josep e gogama tɨne na thɨ vaŋgugiya weŋgiya Ismel gharɨgharɨniyema. Amaamalako thɨ giya modae le laghɨlaghɨye silva gethɨyeiwo. Amba thɨ vaŋgu na thɨ wa Ijipt. ");
INSERT INTO tgo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Amba Rubin i njogha weŋgi na i wa ve kela e gogama. Marae i nja Josep maa ina gheko. Ghatemuru kaiwae i mwanathethe ghakwama. ");
INSERT INTO tgo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","I njogha weŋgiya oghaghaema na iŋa, “Ŋgamama maa ina gheko? Ne ŋgoroŋga wo ghaŋgoghaŋgo?” ");
INSERT INTO tgo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Josep oghaghae thɨ unɨgha gout ghɨmoru umbwara, kaero thɨ liya ghakwamama ghayaboyabo na thɨ liutu goutɨko e madɨbae. ");
INSERT INTO tgo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Thɨ liya kwamako ghayaboyabo na vethɨ livatomwe weya ramanji. Kaero thɨŋa, “Mo vaidiya kwamake iyake. Mbowo u thuwe. Mbwata naru lema Josep ghakwama ghayaboyabo o nandere?” ");
INSERT INTO tgo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Mbaŋa Jeikob i thuwe wagiyawe kaero iŋa, “Naruŋguma Josep ghakwama ghayaboyabo iyake! Emunjora mbwanjam tagaithɨ mendava i tagavamare na i tenɨghan.” ");
INSERT INTO tgo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Weiye le nuwatharɨ laghɨye i mwana thetheŋgiya ghakwama, i njimbo kwama bwedibwedi e mborowae na i nuwatharɨ laghɨye mbaŋa molao nariye Josep kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Le ŋgaŋgako wolaghɨye thɨ raka menawe na thɨ munjeva thɨ vakatha gharemalɨlɨwe (thɨ thɨnɨnjoŋa ghare) na nuwatharɨko iko. Ko iyemaeŋge Jeikob i botewa na mbe i randaranda vara. I dage weŋgi iŋa, “Mbene weiŋgu vara lo nuwatharɨ na ya randaranda ghaghad ne ya mare na ya wa weŋgiya ramaremare, iya naruŋguko inawe.” ");
INSERT INTO tgo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mbaŋa Midiya rakunekune vethɨ raka vutha Ijipt, thɨ vakuneŋa weya Potipa. Amalake iyake iye Pero le rakakaiwo laghɨye regha. Amalaghɨniye iye gharagatɨgatɨ lenji randeviva. ");
INSERT INTO tgo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mbaŋa ubotu e ghereiye, Juda i iteteŋgiya ogaghae na i nja ve yaku weiye amala regha idae Hira e ghemba idae Adulam. ");
INSERT INTO tgo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Gheko Juda i thuwe wevo eunda tɨnan Kenan ramae idae Sua. I vaŋgu na i ghena weiye. ");
INSERT INTO tgo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Wevoko i marabo na i ghambɨ ŋgama ghɨmoru. I rena idae Er. ");
INSERT INTO tgo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Muyai mbowo i ghambɨva, na tembe ŋgama ghɨmoruva. I rena idae Onan. ");
INSERT INTO tgo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Injana mbowo i marabova na tembe i ghambɨva ŋgama ghɨmoru. I rena idae Sila. Ŋgamake iyake va ve virɨ e ghemba regha idae Kesib. ");
INSERT INTO tgo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mbaŋa Er kaero i thamatuwo, Juda nariye virɨviva, kaero ramae i tuthiya levo, idae Tama. ");
INSERT INTO tgo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ko iyemaeŋge Juda nariye virɨviva le vakatha mbema tharɨ eŋge vara Loi e marae. Iya kaiwae Loi i vakatha na i mare. ");
INSERT INTO tgo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Iwaeŋge Juda i dage weya nariye Onan, Er ghaghae, iŋa, “U vaŋgwa ghaghako laghɨyeniye ghembwiye na u vamboromboro ghanda thanavu me mena orumburumbunda weŋgi. Kaiwae mbe ghagha levo, mbala u ghambɨ wein ghaghako kaiwae.” ");
INSERT INTO tgo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ko iyemaeŋge Onan va i ghareghare gamagaiko ne thɨ ghambɨko weiye maane amalaghɨniye idae ina weŋgi; iya kaiwae mbaŋa i ghena weiye wambwiko riwaeko dimithiye i liŋgiyathu eto mbala wambwiko maa i marabo na i ghambɨ gamagai ghaghaema kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Le vakathako kaiwae Loi maa i warari iya kaiwae tembe i vakatha na i mareva. ");
INSERT INTO tgo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Amba Juda i dage weya ghendiyae Tama iŋa, “U njogha weya rama na len bodaboda na wo vo yaku weinaŋgi, ko thava ne u ghe, na naruŋguke Sila wo i thamatuwo.” Kaiwae le renuwaŋako va iŋa, “Ne iwaeŋge mbowo i mareva ŋgoreiya oghaghaeko.” Tama i vakatha ŋgoreiya Juda le renuwaŋako. ");
INSERT INTO tgo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mbaŋa molao kaero iko na e ghereiye Juda levo iye Sua yawarumbuye, i mare. Mbaŋa le nuwatharɨko ghambaŋa kaero iko, amba i voro Timɨna weŋgiya ghɨmoghɨmoru thɨ tena le sipɨko vulivulinji wul kaiwae. Hira, rara Adulam, Juda le nɨma, vambe weiyeva. ");
INSERT INTO tgo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mbaŋa lolo regha i dage weya Tama iŋa, “Ghendiyae Juda i wareri i wa Timɨna ve tena le sipɨko vulivulinji wul kaiwae,” ");
INSERT INTO tgo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","iwaeŋge i biginjoŋa wambwima kwamaniye, i liyabo riwae e kwama ulu ghayaboyabo na i wothuwole ghayamoyamo. Ko amba ve yaku e kamwathɨ ruru Enain, e kamwathɨ i voro Timɨna. Kaiwae vama i thuwe Sila kaero i thamatuwo, ko iyemaeŋge ghendiyae maa i vaŋgugiyawe na le ghɨmoru. ");
INSERT INTO tgo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Mbaŋa Juda i thuwe le renuwaŋa iŋaeŋge wevo i vavakuneŋa riwae, kaiwae i yabo ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kaiwae Juda mava ele ghareghare elako amalaghɨniye ghendiyae, iwaeŋge i loŋga ghembe e kamwathɨko ghadidiye na i dagewe iŋa, “U mena e mbaŋake iyake na ya ghena weiŋgu ghen.” Elako i gonjoghawe iŋa, “Ne u giya modaŋgu budakai?” ");
INSERT INTO tgo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","I dagewe iŋa, “Ne ya variya gout nariye elo sip na goutɨko tɨnenji.” Ko iyemaeŋge elako i gonjoghawe iŋa, “Thare valɨkaiwae u giyama bigi regha e ghino na ne i vaemunjoruŋa dagerawena ne u variya goutɨna nariye e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Juda i dagewe iŋa, “Nuwaniya ya woveŋge budakai?” I gonjoghawe iŋa, “Nuwaŋguiya ghan nonona weiye ghathiyona na pwasikena iya e nɨmanɨna.” Kaero i giyawe na i vamboromboro Juda le renuwaŋako. E vakathako iyako Tama i marabo. ");
INSERT INTO tgo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","E ghereiye Tama i njogha, i biginjoŋa ulu ghayaboyabo na kaero i njimbova wambwima kwamaniye. ");
INSERT INTO tgo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mbaŋa Juda ve vutha weŋgiya rakakaiwoma, i tuthiya gout nariye tabwagha regha, kaero i variye weiye le nɨma Hira na mbala ve biginjogha me le dagerawema i giya le bigibigima weya elama. Ko iyemaeŋge le nima maa ve vaidi. ");
INSERT INTO tgo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Iwaeŋge i vaitoŋgiya ghɨmoghɨmoru thiya yaku gheko iŋa, “Aŋga ina elama i vakuneŋa riwaema e yathima thanavuniye?” Thɨ thombenjoghawe, thɨŋa, “Ma wevo i vakuneŋa riwae ina gheke.” ");
INSERT INTO tgo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kaero i njoghava weya Juda na i dagewe iŋa, “Maa ma vaidi mun. Ghɨmoghɨmoru inanji e ghembako iyako methɨ dage e ghino thɨŋa, ‘Ma tembe wevo regha i vakuneŋa riwae iri gheke.’” ");
INSERT INTO tgo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda i gonjoghawe iŋa, “U viyathu na i mbana budakai menda ya giyanawe. Thava tembe ra tamwe mbeleva, ne iwaeŋge gharɨgharɨ thɨ loŋwevaidi na thɨ vavɨrɨinda. Kaero ma mando na ya vamboromboro le renuwaŋa na ma variye goutɨma, ko iyemaeŋge maa mo vaidi.” ");
INSERT INTO tgo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Manjala umboto e ghereiye lolo regha i utugiya weya Juda iŋa, “Ghendiyae Tama mendava i vakatha yathima thanavuniye, na mbaŋake kaero i marabo.” Juda iŋa, “Hu vaŋguraŋgiyama etoke na ra ŋambu vamare e ndɨghe.” ");
INSERT INTO tgo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ko iyemaeŋge mbaŋa vethɨ vaŋguraŋgiya kaero i variye totoke iyake weya ghendiyae iŋa, “Ghɨmoruke iya le bigibigiya thiyake iye va weiŋgu, iya maraboniyake.” Na i gotubweva iŋa, “Mbowo u thuwe bigibigike thiyake. Thela le bigibigi? Ghanono weiye ghathiyo na pwasike.” ");
INSERT INTO tgo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Mbaŋa Juda i thuwe bigibigiko theghetoko na i ghareghare amalaghɨniyewe, iwaeŋge iŋa, “Tama le vakatha i emunjoru, ko iyemaeŋge ghino lo tharɨ, kaiwae mava ya vaŋgugiya naruŋguko Sila weya elaghɨniye na le ghɨmoru.” Na ande teva i ghenareva weiye Tama. ");
INSERT INTO tgo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mbaŋa kaero ghambaŋa ghambɨ, ghɨmoghɨmoru theghewo gamwaruwoŋgi va inanji e ŋgamoiye. ");
INSERT INTO tgo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tama ele ghambɨko tɨne ŋgamako regha i liraŋgiya nɨmae regha, ravavaghambɨko eunda i li thiyo sosoro nasiye na i ŋgarɨ e nɨmaeko amba iŋa, “Ŋgamake iyake ne i virɨkai.” ");
INSERT INTO tgo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ko iyemaeŋge mbaŋa i liruwo njogha nɨmae ghaghaeko i virɨkai, iwaeŋge ravavaghambɨ iŋa, “Ko ana ghen u virɨviva weva ghaghana!” Iya kaiwae thɨ rena idae Peres. ");
INSERT INTO tgo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Amba ghaghaema thiyoma nasiye sosoro ina e nɨmae i virɨ, na thɨ rena idae Sera. ");
INSERT INTO tgo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Mbaŋaniye Ismel gharɨgharɨniye thɨ vamodo Josep kaero thɨ vaŋgu na vethɨ vaŋguvutha Ijipt e tɨne. Gheko kaero vethɨ vakuneŋava weya giya regha, Pero e raberabe, idae Potipa. Iye lolo laghɨye regha. Kiŋ Pero gharagatɨgatɨ lenji randeviva. ");
INSERT INTO tgo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Giya Loi vambe weiye vara Josep na i vakatha bigibigike wolaghɨye mbe i thovuye eŋge vara ele vakathako tɨne. Josep va i yaku na i kaiwo ghagiya Potipa e le ŋgolo tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mbaŋa Josep ghagiyako kaero i njimbuvaidiya le vakathako wolaghɨye e tɨne mbe i thovuye eŋge vara, i ghareghare Giya Loi va weiye na i vakatha le kaiwoko i thovuye moli; ");
INSERT INTO tgo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","i vakatha i warari laghɨye moli kaiwae na i worawe i tabo amalaghɨniye valɨnɨmae. Ghagiyako kaero i vatomwewe na i mbaroŋa bigibigiko wolaghɨye ele ŋgolo tɨne na bigibigiko wolaghɨye e ghayayaoko. ");
INSERT INTO tgo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mbaŋaniye vara Potipa i worawa Josep na i mbaroŋaŋgiya gharɨgharɨko wolaghɨye thiya kaiwo ele ŋgoloko na bigibigiko wolaghɨye e ghayayaoko tɨne, Giya Loi i vakatha amalako le bigibigiko wolaghɨye thiya thovuye moli. Giya Loi i mwaewo weŋgiya Potipa le bigibigiko wolaghɨye inanji ele ŋgoloko tɨne, na le umaumako thɨ madi. ");
INSERT INTO tgo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potipa i viyatho le bigibigiko wolaghɨye weya Josep i njimbukiki. Potipa maa tembe i rerenuwaŋava bigi regha kaiwae, mbema ghanɨŋgako eŋge vara iya i ghanɨko. Josep va thavɨndondo wamandondo na ghayamoyamo i thovuye na manɨune. ");
INSERT INTO tgo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Iwaeŋge i tagawo Potipa levo nuwae. Ko maa mbaŋa bwagabwaga kaero i dage weya Josep iŋa, “U mena va ghena weiŋgu ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ko iyemaeŋge Josep i botewa elako na i dagewe iŋa, “Wo giyako kaero menda i viyatho bigibigike wolaghɨye ele ŋgoloke tɨne na ghino ya mbaroŋa. Menda i vareminjeŋgo na ya njimbukikiya bigibigike wolaghɨye iya amalaghɨniyekewe. ");
INSERT INTO tgo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ma tembe lolo regha inava e ŋgoloke tɨne i laghɨye kivwalaŋgo. Amalako maa menda tembe i ravaghava bigi regha e ghino; mbe ghen eŋge vara, kaiwae levo ghen. Ne ŋgoroŋga na ya vakatha thanavu ŋgoreiyako na ya tharɨ Loi e marae?” ");
INSERT INTO tgo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Elako mbe i vothaŋa vara Josep mbaŋa regha na regha e tɨne, ko iyemaeŋge i botewayatho le naŋgokowe na maa i ghena weiye. I mando na i vaghaghaiŋa ghamberegha weya Potipa levo. ");
INSERT INTO tgo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Va mbaŋa regha Josep i ru e ŋgoloko tɨne na i vakatha ghakaiwowe. Le valɨrakakaiwo mava regha mun ina gheko. ");
INSERT INTO tgo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Iwaeŋge elako i laweghathɨ e ghakwama na i dagewe iŋa, “U mena ya ghena weiŋgu ghen.” Ko iyemaeŋge Josep i vogha raŋgi eto na i vogha iteta elako, mbe i rondelili eŋge ghakwama ghayaboyabo. ");
INSERT INTO tgo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mbaŋa i thuwe me iteta ghakwama ghayaboyabo na i voraŋgi eto, ");
INSERT INTO tgo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kaero i kula weŋgiya le ŋgoloko gharakakaiwo na i dage weŋgi iŋa, “Wo hu thuwe! Iya rara Hibruna iya lo ghɨmoruke va i vaŋgurawe e ŋgoloke i vakatha monjina laghɨye weinda. Me mena i ru elo woluwoluke tɨne na i munjeva i laweŋgo na i vakatha le renuwaŋa e ghino, ko iyemaeŋge ma mareŋwanji laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mbaŋa me loŋwe ma ŋwanjiko, i vogha raŋgi eto na i voiteta ghakwama ghayaboyabo evasiwaŋguke.” ");
INSERT INTO tgo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Elako mbe i vikikighathɨ vara kwamako ghaghad Josep ghagiyako i njoghama e ŋgoloko. ");
INSERT INTO tgo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Amba i utugiya utuutumawe iŋa, “Iya rara Hibru ŋgoloke gharakakaiwo mendava u vaŋgurawe e ŋgoloke me vakatha monjina e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ko iyemaeŋge mbaŋa ma mareŋwanji i vogha raŋgi eto na i iteta ghakwama ghayaboyabo evasiwaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mbaŋa amalako i loŋwe utuutuko iyako weya levo, ghare i gaithɨ laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Josep ghagiyako iŋa na vethɨ vaŋguruwo e thiyoko ŋgora thavala thɨ vakatha vatharɨ weya kiŋɨko na vethɨ ruwe. Ko iyemaeŋge mbaŋa Josep ina e thiyo tɨne, ");
INSERT INTO tgo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Giya Loi i mwaewowe na i thalavu. Iyako i wo thiyoko gharambarombaro nuwae na i warari kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Iya kaiwae thiyoko gharambarombaro i worawa Josep na i mbaroŋaŋgiya thavala inanji e thiyoko tɨne, na tembe ŋgoreiyeva e vakathako wolaghɨye gheko. ");
INSERT INTO tgo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Thiyoko gharambarombaro mava tembe i rerenuwaŋava the bigiya vama i vatomwe weya Josep na i njimbukiki, kaiwae Giya Loi vambe weiye vara na ele vakathako wolaghɨye Giya Loi i vakatha na i emunjoru. ");
INSERT INTO tgo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mbaŋa vavana e ghereiye, Ijipt ghakiŋ le rakakaiwo theghewo, regha kiŋɨko ghawaen gharavivatha na regha bred gharaŋambuŋambu — thɨ vakatha vatharɨ bigi regha kiŋɨko e marae na i vakatha maa i warari. ");
INSERT INTO tgo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Iwaeŋge ghare i gaithɨ wanaŋgi ");
INSERT INTO tgo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","na i dage weya gharagatɨgatɨko lenji randeviva i vaŋguruwoŋgi e thiyo. Thiyoko iyako iya Josep va inakowe. ");
INSERT INTO tgo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kiŋɨko gharagatɨgatɨ lenji randeviva i yovaŋguŋgi weya Josep na i dagewe i njimbukikiŋgi e bigibigiko wolaghɨye. Mbaŋa gheviye vama lenji yakuyaku gheko na e ghereiye, ");
INSERT INTO tgo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","mbe theghewoko vara — kiŋɨko ghawaen gharavivatha na ghabred gharaŋambuŋambu thɨ ghenelolo gougou mbe reghaeŋge. Lenji gheneloloko mbe tomethi ghanjirumwaru. ");
INSERT INTO tgo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mbaŋa Josep i mena weŋgi mbaŋambaŋako iyako i thuweŋgi thɨ yawowo. ");
INSERT INTO tgo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","I vaitoŋgi iŋa, “Buda kaiwae ghamiyamoyamo i yawowo noroke?” ");
INSERT INTO tgo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Thɨ gonjoghawe thɨŋa, “Mbe thamaghewoke vara mo ghenelolo gougou, ko iyemaeŋge maa lolo regha ina gheko na valɨkaiwae i vaghɨleŋgi.” Amba Josep i dage weŋgi iŋa, “Loi mbe ghambereghaeŋge valɨkaiwae i vaghaghɨleŋgiya ghenelolo. Wo hu utu giyama e ghino mo hu thuweŋgiya budakai.” ");
INSERT INTO tgo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kaero waenɨma gharavakatha i utugiya le gheneloloma weya Josep iŋa, “Lo gheneloloko e tɨne ma thuwe waen ghathiyo yaŋgara e ghamwaŋgu. ");
INSERT INTO tgo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Na e umbwarako iyako yaŋgayaŋga yaŋgato. Mbaŋa ndamwandamwaeko thɨ voviya kaero thɨ vunyenye, kaero vunyevunyeuyeko thɨ dobu na uneune thɨ yomara. ");
INSERT INTO tgo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pero ghakomu mena e nɨmaŋgu. Ya mbana uneuneko kaero ya imbɨ mban e komuko tɨne na ya thɨnɨrawe Pero e nɨmae.” ");
INSERT INTO tgo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josep i dagewe iŋa, “Len ghenelolona gharumwaru ŋgoreiyake. Yaŋgayaŋgaena yaŋgatona gharumwaru mbaŋa thegheto. ");
INSERT INTO tgo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mbaŋa thegheto e tɨne kiŋɨko ne iŋa na u raŋgi na u wawe. Ne u njogha na tembe vo vakathava kaiwoma va u vakavakathama. Tembe ne u vivathava kiŋɨko ghawaen na u giyawe. ");
INSERT INTO tgo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aee, wou, ago laghɨye e ghen, mbaŋa bigibigike wolaghɨye ne ve thovuye e ghen, u renuwaŋakikiŋgo na gharen e ghino. Mbala vo govambwaraŋgo weya kiŋɨna na valɨkaiwae tembe ya raŋgiva e thiyoke tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Wo u thuwe, gharɨgharɨ va thɨ vaŋgu kavɨŋgo Hibru e lenji valɨvaŋga na othembe gheke maa ya vakatha vatharɨ mun bigi regha na valɨkaiwae thɨ vaŋgu ruwoŋgo e thiyoke tɨne.” ");
INSERT INTO tgo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mbaŋa bredɨma gharaŋambuŋambu i loŋwevaidi Josep le vaghɨle gheneloloko i thovuye, tembe i dageweva Josep iŋa, “Ghino tembe ŋgoreiyeva, menda ya ghenelolo. Elo gheneloloko tɨne, ya bigiya nambonambo ŋgamwato e umbalɨŋgu, bred inanjiwe. ");
INSERT INTO tgo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","E vwatako vara tomethi ghanɨŋga ŋambuŋambu kiŋɨko kaiwae inanjiwe. Ko iyemaeŋge maa thɨ yonja na thɨ ghan mbaŋa mbe ina e umbalɨŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josep i dagewe iŋa, “Ghenelolona iyana gharumwaru ŋgoreiyake. Nambonambo ŋgamwatona iye mbaŋa thegheto. ");
INSERT INTO tgo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mbaŋa thegheto e tɨne Pero ne iŋa na thɨ vaŋguraŋgiyaŋge na thɨ yovaŋguŋge weya amalaghɨniye. Amba ne iŋa na thɨ kitena numonɨna na thɨ wovakwata riwanɨna e umbwa, na maa thɨ mena thɨ ghana mbunɨmanina.” ");
INSERT INTO tgo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Mbaŋa thegheto e ghereiye Pero le ghambɨ gharenuwaŋakiki. I vakatha thaganiye na i kula vathavathaŋgiya le rakakaiwoko wolaghɨye thɨ raka mena e thagako iyako tɨne. Kiŋɨko iŋa na thɨ vaŋgumena ghawaen gharavivatha na bred gharaŋambuŋambuma weya amalaghɨniye na le rakakaiwoko wolaghɨye e maranji. ");
INSERT INTO tgo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","I vaŋgunjogha ghawaenɨma gharavivatha ele ghamba kaiwoma na i njogha na tembe i vakathava kaiwoma va i vakavakathamawe, ");
INSERT INTO tgo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ko iyemaeŋge iŋa na thɨ wovakwata raŋambuŋambuma. Iyako va i yomara ŋgoreiya Josep va le utuutu weŋgi mbaŋa va i vaghɨle lenji gheneloloma. ");
INSERT INTO tgo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ko iyemaeŋge kiŋɨma ghawaen gharavivatha i renuwaŋa vaghalawe Josep. Mbema i renuwaŋa valawe vara. ");
INSERT INTO tgo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Theghathegha umboiwo vama thɨko na e ghereiye amba Pero i ghenelolo ghenelolo regha. E gheneloloko tɨne va i ndeghathɨ e Walaghɨta Nael ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","E mbaŋako iyako burumwaka umbopirɨ, ghanjitabo vondɨvondɨ na riwanji vunevune, thɨ raka voroma e walaghɨtako tɨne kaero thiya ghana nana gheko. ");
INSERT INTO tgo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","E ghereinji mbowo burumwaka umbopirɨva thɨ raka voro e walaghɨtako tɨne, ghanji tabo i nja na mbe ŋgaŋgainji eŋge. Thɨ raka mena na thɨ ndeghathɨ burumwakama vavanama evasiwanji e walaghɨtako ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kaero burumwakama iya ŋgaŋgainjima eŋge thɨ ghanɨŋgiya burumwakama ghanjitaboma vondɨvondɨ. Amba Pero i thuweiru. ");
INSERT INTO tgo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Injana mbowo i ghenava na tembe i ghenelolova. E tɨne i thuwe iyake: Wit siŋwepirɨ, ghanjiyamoyamo i thovuye moli na wokɨninji mbe regha eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Iyako e ghereiye wit siŋwepirɨ mbe thɨ thɨnɨ raŋgiyava — wakɨniye mbe nasiye na ndewendewe i mena e boimako i ŋambwa ndamwandamwaeko. ");
INSERT INTO tgo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Witɨko wakɨniyeko nanasiye thɨ mbanɨvoŋguŋgiya witɨma ghanjitaboma i thovuye na siŋwe laghɨlaghɨye. Amba Pero i thuweiruva na e mbaŋako iyako i ghareghare me ghenelolo. ");
INSERT INTO tgo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ighɨviya Pero ghayamoyamo maa i warari mun. Kaero i variye utu weŋgiya thavala manɨyeto na rathimbathimba Ijipt e tɨne na thɨ raka menawe. Pero i utugiya le gheneloloma weŋgi, ko iyemaeŋge maa tembe reghava valɨkaiwae i vaghɨlewe. ");
INSERT INTO tgo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Amba kiŋɨko ghawaenɨma gharavivatha i dage weya Pero iŋa, “Noroke ya renuwaŋakikiya lo tharɨ regha. ");
INSERT INTO tgo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Va mbaŋa regha gharen i gaithɨ wanaime weiŋgu raŋambuŋambuma, iwaeŋge u bigi ruwoime e thiyo ghan ragatɨgatɨma lenji randeviva ele ŋgolo. ");
INSERT INTO tgo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Gougou regha mbe thamaghewoko vara wo ghenelolo, na lama gheneloloko vambe tomethi ghanjirumwaru. ");
INSERT INTO tgo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Amala regha tabwagha va ina gheko. Iye Hibru loloniye, ghanɨragatɨgatɨna lenji randeviva va le rakakaiwo. Va wo utugiyawa lama gheneloloko na i vaghɨla ghanjirumwaruko weime. ");
INSERT INTO tgo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Bigibigiko wolaghɨye va i mboromboro ŋgoreiya va le varumwaruko weime. Ghino u vaŋgu njoghaŋgo e wo kaiwoko na wouko uŋa na thɨ kiten numwe na thɨ wovakwate riwae e umbwa.” ");
INSERT INTO tgo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pero i variya utu Josep kaiwae na mbema ghenji na nɨmanji eŋge vethɨ vaŋguraŋgiya e thiyoko tɨne. Ve kwe ghabathɨ na i njimbo kwama thovuye, kaero i wa ve ndeghathɨ Pero e marae. ");
INSERT INTO tgo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pero i dagewe iŋa, “Mendava ya ghenelola ghenelolo regha, na maa lolo regha i vaghɨle. Ko iyemaeŋge mendava ya loŋwevaidi ghen valɨkaiwan u vaghɨleŋgi ghenelolo ghanjirumwaru, iya kaiwae ma variye utu kaiwan.” ");
INSERT INTO tgo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josep i gonjoghawe iŋa, “Ghino maa valɨkaiwaŋgu ya vakatha, ko iyemaeŋge Loi ne i giya vaghɨle thovuye e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Amba Pero i dagewe iŋa, “Elo gheneloloko tɨne va ya ndeghathɨ e walaghɨta Nael ghadidiye, ");
INSERT INTO tgo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","na e mbaŋako iyako burumwaka umbopirɨ, ghanjitabo vondɨvondɨ na riwanji vunevune, thɨ rakavoroma e walaghɨtako tɨne na thiya ghana nana gheko. ");
INSERT INTO tgo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","E ghereinji mbowo burumwaka umbopirɨva thɨ raka voroma e walaghɨtako tɨne, ghanjitabo i nja na mbe ŋgaŋgainji eŋge. Maa tembe mbaŋa reghava ya thuweŋgiya burumwaka ghanjiyamoyamo raitharɨ moli ŋgoreiyako Ijipt laghɨyeko e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Burumwakama ŋgaŋgainjima eŋge thɨ ghanɨŋgiya burumwakama umbopirɨma iya ghanjitaboma vondɨvondɨ iya methɨ rakavorokaima. ");
INSERT INTO tgo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ko iyemaeŋge othembe thɨ ghanɨŋgiya vavanako ghanjitaboko mbe ŋgoreiye vara iyako. E ghereiye amba ya thuweiru.” ");
INSERT INTO tgo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Kaero ya gheneva. Na injana mbowo ya ghenelolova. E gheneloloko iyako ya thuwe wit siŋwepirɨ ghanjiyamoyamo i thovuye moli na wakɨninji mbe regha eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Iyako e ghereiye wit siŋwepirɨ mbowo thɨ thɨnɨ raŋgiyava — wakɨniye me nasiye na ndewendewe i mena e boimako i ŋambwa ndamwandamwaeko. ");
INSERT INTO tgo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Witɨko wokɨninjiko nasiye thɨ mbanɨvoŋguŋgiya witɨma ghanjitaboma i thovuye na siŋwe laghɨlaghɨye. Ma utugiya weŋgiya thavala manɨyetoŋgi, ko iyemaeŋge maa tembe reghava valɨkaiwae i vamanjamanjalaŋa e ghino.” ");
INSERT INTO tgo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Amba Josep i dage weya Pero iŋa, “Pero, len ghenelolona theghewona ghanjirumwaru mbe regha eŋge. Loi me vatomwe ghen budakai ne i vakatha. ");
INSERT INTO tgo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Iya burumwakana umbopirɨna ghanjitabo vondɨvondɨ, iyana theghathegha umbopirɨ. Na iya witɨna siŋwe laghɨlaghɨyena na thɨ thovuyena tembe theghathegha umbopirɨva; na ghanjirumwaru mbe regha eŋge. ");
INSERT INTO tgo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Iya burumwakana umbopirɨna na ŋgaŋgainjina eŋge na thɨ rakavoro muyaina na witɨna siŋwepirɨ wakɨninji mbe nasiye na uneune mbe nanasiye — iya ndewendewe i mena e boimako i ŋambu ndamwandamwaena — iyana theghathegha umbopirɨ ne vunuvu ghambaŋa.” ");
INSERT INTO tgo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ŋgora kaero ma utuma e ghen. Loi kaero me vatomwe e ghen budakaiya ne i vakatha. ");
INSERT INTO tgo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Theghathegha umbopirɨ e tɨne madi ne ghambaŋa Ijipt laghɨyeke e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ko iyemaeŋge ne e ghereiye theghathegha umbopirɨ vunuvu ghambaŋa. Madi ghatheghathegha nevole gharerenuwaŋa i ghawe gharɨgharɨ e nuwanji, kaiwae vunuvuko mbema ne i vakowana vara vanautumako laghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Madima ghambaŋa nevole thɨ renuwaŋa vaghalawe moli, kaiwae vunuvuko iya e ghereiyeko mbema ne i tharɨ moli vara. ");
INSERT INTO tgo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ghenelolona theghewo rɨghe kaiwae Loi nuwaiya hu ghareghare iyake ne i yomara, na ne i vakatha, maiya vara kenɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Iya kaiwae e mbaŋake iyake, Kiŋ Pero, u tuthiya amala regha nuwae i goi na i thimba, na u vaŋgurawe i mbaroŋa Ijipt laghɨyeke. ");
INSERT INTO tgo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Na tembe u tuthiŋgiva giyagiya vavanava na thɨ mbana wit weŋgiya gharɨgharɨ Ijipt laghɨyeke e tɨne mbaŋa madiko ghatheghathegha umbopirɨ e tɨnenji. Wone thɨ wabwi na wabwilima witɨko na thɨ mbana wabura weŋgiya gharɨgharɨko na thɨ mban ghaghathɨ. ");
INSERT INTO tgo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ne u giya giyagiyako ghanjimbaro na thɨ mbanɨ vatha ghanɨŋgako madiko e ghatheghathegha tɨnenji iya i menamenako. Ghen e idan thɨ vathe wit e ghanjiŋgoloŋgolo e ghembaghemba regha na regha tɨne na mbe maranjiwe vara. ");
INSERT INTO tgo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ghanɨŋgako iyako mbala i tabona thaŋwethaŋwe unmariye vanautumake kaiwae. Iyako ne ra vakaiwoŋa vunuvuko ghatheghathegha umbopirɨ e tɨne iya ne i ŋge Ijipt laghɨyeke. E kamwathɨke iyake amba ne ma bada i gaboŋgiya gharɨgharɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Renuwaŋako iyako ghathuwathuwa i thovuye weya Pero na le rakakaiwoko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kaero Pero i vaitoŋgi iŋa, “Thare valɨkaiwae ne ra vaidiya lolo regha ŋgoreiya amalake iyake, iya Loi uneke inawe?” ");
INSERT INTO tgo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Amba Pero i dage weya Josep iŋa, “Kaiwae Loi i vakathaŋge na u ghareghare iyake, maa tembe lolo reghava nuwae i goi na i thimba ŋgoreiya ghen. ");
INSERT INTO tgo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ne ya vaŋguraweŋge na u mbaroŋa lo vanautumake, na lo gharɨgharɨke wolaghɨye ne thɨ ghambugha len mbarona. Len mbarona le vurɨgheghe i mena mbe ghino eŋge e raberabeŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kaero Pero i dage weya Josep iŋa, “E mbaŋake iyake ya vaŋguraweŋge na u tabo gawana Ijipt laghɨyeke e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pero i woraŋgiya nɨmae kikiye ghae ghamba mbaroko ghanono inawe, na i worawe Josep e nɨmae kikiye. I vanjimbo e kwama thovuye moli na i wokitho numwe ghae gol. ");
INSERT INTO tgo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","I yambigiya weya Josep le sariyot theghewoniye i thawe na kiŋɨko gharagatɨgatɨ thɨ raka viva e ghamwae na thɨ vakatha ghayavwatata na thɨŋa, “Hu kururuwe! Hu kururuwe!” Pero kaero i tuthiya Josep na iye i tabo gawana Ijipt laghɨyeko tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Amba Pero i dagewe iŋa, “Ghino Pero, Ijipt lenji kiŋ, ko iyemaeŋge maa lolo regha Ijipt e tɨne ne i vakatha bigi regha ma u vatomwewe.” ");
INSERT INTO tgo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pero i rena Ijipt idaniye, Sepanat Peniya, weya Josep na i vaŋgugiya Asenat weya amalaghɨniye na levo. Elako iyako Potipa yawarumbuye, iye ghemba On lenji ravowovowo. Josep i vaghɨliya Ijipt laghɨyeko. ");
INSERT INTO tgo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josep ghatheghathegha vama i wo ghweto mbaŋaniye i ru i kaiwo weya Pero, Ijipt lenji kiŋ. Kaiwo e tɨne i roiteta Pero na i vaghɨliya Ijipt laghɨyeko. ");
INSERT INTO tgo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Madi ghatheghathegha umbopirɨ e tɨne thelauko ghanɨŋganiye i rau laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Wolaghɨyeko iyako Josep i mbanɨ vathavatha na i vathe e ghembaghembako. E ghemba regha na regha tɨne i vathe ghanɨŋga e valɨvaŋgako iyako. ");
INSERT INTO tgo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Witɨko va i laghɨye na i ghanagha moli maa valɨkaiwae Josep tembe i rɨghɨva ŋgoreiya kerakera e njighɨko ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Va e mbaŋako iyako na amba muyai vunuvuko ghatheghathegha thɨ mena, Josep le ŋgaŋga vama theghewo, thɨ ghambɨ weya Asenat, Potipa yawarumbuye iye On lenji ravowovowo. ");
INSERT INTO tgo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josep i rena nariye virɨviva idae Manase. Iŋa, “Kaiwae Loi i vakathaŋgo ya renuwaŋa vaghalawe wo vuyowoma wolaghɨye na bwebwe le bodaboda.” ");
INSERT INTO tgo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nariye theghewoniye i rena idae Ipɨreim, na iŋa, “Kaiwae Loi i vakathaŋgo ya ghambɨ e valɨvaŋga ya vaidiya vuyowowe.” ");
INSERT INTO tgo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Madima ghatheghathegha umbopirɨma kaero iko vara iyake, ");
INSERT INTO tgo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","na vunuvuma ghatheghathegha umbopirɨ i worawe rɨghe, ŋgoreiya Josep va le utuutuma. Vunuvuko iyako vambe ve wova vanautuma vavana, ko iyemaeŋge Ijipt laghɨyeko e tɨne ghanɨŋga vambe inawe. ");
INSERT INTO tgo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mbaŋa Ijipt gharɨgharɨniye thɨ ghamɨnoa vunuvuko ghamɨna, vethɨ goyawaru weya Pero ghanɨŋga kaiwae. I variyeŋgi na thɨ raka weya Josep na vethɨ vakatha budakaiya ne i utuŋa weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mbaŋa vunuvuko kaero i laghɨye moli na i wo vanautumako laghɨye, Josep kaero i vughɨŋgiya ghanɨŋgama ghaŋgoloŋgolo na i vakuneŋa wit weŋgiya Ijipt gharɨgharɨniye, kaiwae vunuvuko vama i vurɨgheghe moli Ijipt laghɨyeko e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Gharɨgharɨ vambe thɨ rakaraka menava e yambaneke laghɨye na thɨ vamodo wit weya Josep, kaiwae vunuvuko vambe i vurɨgheghe e valɨvaŋgake wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Mbaŋa Jeikob i loŋwe vaidiya wit ina Ijipt, kaero i dage weŋgiya le ŋgaŋga iŋa, “Buda kaiwae mane hu vakatha bigi regha? ");
INSERT INTO tgo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mendava ya loŋwevaidiya wit utuniye ina Ijipt. Hu raka gheko na vohu vamodo vavana kaiwanda, na valɨkaiwae i ndewoinda na thava raya mare.” ");
INSERT INTO tgo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Iwaeŋge Josep oghaghae theyaworoma thiya wareri, thɨ raka Ijipt na vethɨ bayama wit. ");
INSERT INTO tgo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ko iyemaeŋge Jeikob mava i variye Benjamin, Josep ghaghae nasiyeniye, na weiyaŋgi kaiwae ghare va i laghɨlaghɨye ne iwaeŋge tharɨ regha i yomarawe. ");
INSERT INTO tgo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kaero Isirel le ŋgaŋgako thiya wareri weinjiyaŋgiya gharɨgharɨ vavana vethiya bayama wit, kaiwae vunuvuko vambe i wova Kenan. ");
INSERT INTO tgo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","E mbaŋako iyako Josep iye gawana Ijipt e tɨne na amalaghɨniye iyava i vavakuneŋa wit weŋgiya gharɨgharɨ e yambaneke laghɨye. Josep oghaghae thɨ rakavuthana iwaeŋge thɨ mena thɨ kururuwe na ghamwanji i nja e thelauko vwatae. ");
INSERT INTO tgo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Mbaŋa Josep i thuweŋgiya oghaghaeko na kaero i tuthiŋgi, ko le vakathako eŋge ŋgoreiya mbe lolo regha. Le utuutuko va e ghamɨnae weŋgi. I vaitoŋgi iŋa, “Aŋga hu rakamena?” Thɨ gonjoghawe thɨŋa, “Wo rakamena Kenan na wo mena wo bayama ghanɨŋga.” ");
INSERT INTO tgo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josep eŋge kaero i tuthiŋgi na i ghareghare ghɨmoghɨmoruke thiyake amalaghɨniye oghaghae, ko thiye eŋge mava thɨ tuthi thela amalaghɨniye. ");
INSERT INTO tgo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Amba i renuwaŋakikiya le gheneloloŋgima kaiwanji, na i dage weŋgi iŋa, “Ghemi rakelakela ghemi! Menda hu mena na nuwamiya hu thuwe lama vanautumake le ghamba njavovo.” ");
INSERT INTO tgo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Thɨ gonjoghawe thɨŋa, “Nandere moli, amalana. Len rakakaiwo, menda wo mena wo bayama ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Mbe amala regha eŋge vara le ŋgaŋga ghime. Len rakakaiwo, wo utu emunjoru, na maa rakelakela ŋgoreiye ghime.” ");
INSERT INTO tgo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Josep mbowo i dageva weŋgi iŋa, “Nandere! Menda hu mena na nuwamiya hu thuwe lama vanautumake le ghamba njavovo.” ");
INSERT INTO tgo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ko iyemaeŋge thɨ gonjoghawe thɨŋa, “Len rakakaiwo, lama ghanaghanagha theyawora theghewo, amala regha le ŋgaŋgaŋgi ghime, amalaghɨniye iyake e valɨvaŋga idae Kenan. Nasiyenime mbe ina weiye ramame na regha kaero va i mare.” ");
INSERT INTO tgo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josep i gonjogha weŋgi iŋa, “Mbema ŋgoreiye iya maŋama weŋga: Ghemi rakelakela! ");
INSERT INTO tgo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ne ya vakatha kamwathɨ regha e ghemi na i vaemunjoruŋa lemi utuutuke mbema emunjoru. Kiŋ Pero e idae ya dage e ghemi, maa tembe ne hu iteteva Ijipt ghaghad ghaghami nasiyenimina i mena gheke. ");
INSERT INTO tgo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ghemina regha i njogha na ve vaŋguma. Taulaghɨna ghemi iya hu ronjoghana ne vohu yaku e thiyo tɨne, na wo thuwe thoŋgo lemi utuko i emunjoru. Thoŋgo nandere, Kiŋ Pero e idae, ghemi rakelakela.” ");
INSERT INTO tgo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Josep kaero ve vaŋguraweŋgi e thiyo na vethɨ yakuwe mbaŋa thegheto e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mbaŋa theghetoniyeko e tɨne Josep i dage weŋgi iŋa, “Kaiwae Loi ghamararu ina e ghino, hu vakatha renuwaŋake iyake ambane maa thɨ gaboŋga. ");
INSERT INTO tgo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Thoŋgo mbema emunjoru lemi utuutuke, hu vatomwe ghaghamina regha i ronjogha. Mbe i yaku vara e thiyoke tɨne, na wolaghɨyena ghemi, hu raka njogha. Hu biginjogha witɨko weŋgiya lemi bodaboda iya badana ne i gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ko mbaŋa ne hu njoghama hu vaŋguma ghaghamina nasiyenimina e ghino. Iyake ne i vaemunjoruŋa lemi utuutuma i emunjoru amba ne maa valɨkaiwae hu mare.” Thɨ vamboromboro iya renuwaŋako iyako. ");
INSERT INTO tgo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kaero thɨ vedage weŋgi thɨŋa, “Emunjoru, ra vaidiya vuyowoke iyake rɨghe moliya ghaghandama. Va ra thuwe ghavuyowoko na le naŋgo weinda thalavu kaiwae, ko iyemaeŋge mava ra wovatha le utuutuko, iya kaiwae ra vaidiya vuyowae e mbaŋa iyake budakaiya va la vakathawe.” ");
INSERT INTO tgo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubin i dage weŋgi iŋa, “Ŋgoroŋga va yaŋa e ghemi? Va yaŋa ne ra ndevakatha bigi reghawe, ko iyemaeŋge mava nuwamiya hu vandeŋeŋgo. Na mbaŋake budakaiya va la vakathawe ra vaidiya rereya.” ");
INSERT INTO tgo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Mbaŋa Josep i utu weŋgi, lolo regha i vaghɨle iya kaiwae mava e lenji ghareghare mun Josep i loŋwe na i ghareghare iya lenji utuutuko. ");
INSERT INTO tgo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","I roiteteŋgi na wo ve randa. Mbaŋa i njogha kaero i tuthiya Simion, na iŋa na thɨ ŋgarɨ e maranji. ");
INSERT INTO tgo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Josep kaero i dage weŋgiya le rakakaiwoko thɨ mbana wit e lenji begibegi na lenji manima tembe thɨ bigi mbanɨva regha na regha ele begi tɨne, e vwatae moli. Tembe thɨ giyava ghanji kamwathɨ kaiwae. Mbaŋa thɨ vakathavao, ");
INSERT INTO tgo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","kaero thɨ doweya witɨko e doŋɨkiko vwatanji na thiya wareri. ");
INSERT INTO tgo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","E valɨvaŋga regha va vethɨ laghenawe, iwaeŋge regha e tɨnenjiko i tateya le begi na i munje i mbana witɨko vavana na i ŋamweya le doŋɨkiko, iwaeŋge i vaidiya le manima ele begiko tɨne, e vwatae moli, ");
INSERT INTO tgo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","kaero i dage weŋgiya oghaghaema iŋa, “Lo manima tembe methɨ biginjoghava e ghino. Iyake, mbe iya elo begike tɨne.” Gharenji i tage weinji lenji gharelaghɨlaghɨ laghɨye na thɨ vevaitoŋgi thɨŋa, “Budakai iya Loi menda i vakathake weinda?” ");
INSERT INTO tgo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mbaŋa thɨ vutha weya ramanji Jeikob Kenan e tɨne, kaero thɨ utugiya weya bigibigiko wolaghɨye va thɨ yomara weŋgi. Thɨ dagewe thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Gawanako iya i mbaroko Ijipt e tɨne, mbaŋa va i utuko weime ghalɨŋaeko e larɨmbɨya na i vakathaime raŋaeŋgeva ghime rakelakela e vanautumako tɨne.” ");
INSERT INTO tgo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ko iyemaeŋge wo dagewe woŋa, “Ghime emunjora iya wo utuŋake, ghime maa rakelakela. ");
INSERT INTO tgo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Lama ghanaghanagha thamayaworo na thamaghewo, ramame mbe regha eŋge. Ghaghame regha kaerova i mare na nasiyenime ina Kenan weiye ramame.” ");
INSERT INTO tgo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Giyako i dage weime iŋa, “E kamwathɨke iyake valɨkaiwae ne ya vaemunjoruŋa na ya ghareghare mbema emunjoru iya mohu utuŋana. Ne hu roiteta ghaghamina regha gheke na wolaghɨyena ghemi hu biginjogha wit e ghambami weŋgiya lemi bodabodana iya badana i gharɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ko iyemaeŋge ne hunde renuwaŋa vaghalawe hu vaŋguma ghaghamina nasiyenimina, ne hu vaŋgumena e ghino. Ne e kamwathɨke iyake ya ghareghare ghemi maa rakelakela ŋgoreiye, emunjoru rautuutu emunjoru ghemi. Ambane ya vaŋgunjogha ghaghamike weŋga, na valɨkaiwami hu kune e valɨvaŋgake iyake.” ");
INSERT INTO tgo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mbaŋa thɨ tara raŋgiya lenji begibegiko uneunenji regha na regha thɨ vaidi le manima weiye ghambaema. Mbaŋa thɨ thuwe iyako weinji ramanji Jeikob gharenji i laghɨlaghɨye moli kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ramanji i dage weŋgi iŋa, “Thare nuwamiya ya thɨvaivao lo ŋgamaŋgamake wolaghɨye? Josep kaero nandere na Simiyon kaero nandere, na noroke kaero nuwamiyava hu vaŋgwa Benjamin. Bigibigike wolaghɨye kaero thɨ roghereiye wanaŋgo!” ");
INSERT INTO tgo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Amba Rubin i dage weya ramae iŋa, “Thoŋgo maa ya vaŋgunjoghama Benjamin e ghen, valɨkaiwae u gaboŋgiya lo ŋgaŋga theghewona. U viyathu e nɨmaŋguke ghare, na tembene ya vaŋgunjoghamava e ghen.” ");
INSERT INTO tgo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ko iyemaeŋge Jeikob iŋa, “Naruŋguke mane hu wa weimi gheko, ghaghae kaero i mare na ma ghamberegha eŋge e yawayawaliye. Thoŋgo bigi regha i yomarawe e lemi loŋgaloŋgana tɨne na i mare, kaiwae kaero ya amalaghɨsarɨ moli, lemi vakathana ne i vakatha gharevɨrɨ e ghino na i tagavamareŋgo.” ");
INSERT INTO tgo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","E mbaŋako iyako vunuvuko vamba i vurɨgheghe vara Kenan e le valɨvaŋga. ");
INSERT INTO tgo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Iya kaiwae mbaŋa kaero thɨ ghanɨvao witɨma va vethɨ vamodoma Ijipt, ramanji kaero i dage weŋgiva iŋa, “Mbowo hu njoghava na vohu vamodo ghanda seiwova.” ");
INSERT INTO tgo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ko iyemaeŋge Juda i dagewe iŋa, “Amalako mendava i utu vurɨgheghe weime iŋa, ‘Mane tembe hu thuweva ghamwaŋgu, thoŋgo maa hu vaŋgwa ghaghamina na weimi.’ ");
INSERT INTO tgo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Thoŋgo ne u variya Benjamin na weime, ne wo raka Ijipt na vo vamodo ghanɨŋga kaiwan. ");
INSERT INTO tgo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ko thoŋgo mane u variye na weime, mane wo raka kaiwae amalako va i dage weime na iŋa, ‘Maane tembe hu thuweva ghamwaŋgu, thoŋgo ma hu vaŋgwa ghaghamina na weimi.’” ");
INSERT INTO tgo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jeikob i dage weŋgi iŋa, “Buda kaiwae hu vakatha vuyowo laghɨye e ghino na mendava hu dage weya amalako ghaghami regha mbe ina weva?” ");
INSERT INTO tgo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Thɨ gonjoghawe thɨŋa, “Amalako vambe i vaito ghɨdaghɨda vara ghime kaiwame na lama bodaboda iŋa, ‘Ramami mbe e yawayawaliye? Thare ghaghami regha mbe inaweva?’ Mbema wo thombe eŋge iya le vaitoŋgiko. Ŋgoroŋga mbala mendava woŋa na wo ghareghare ne iŋa, ‘Hu vaŋgumena ghaghamina gheke’?” ");
INSERT INTO tgo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kaero Juda i dage weya ramae Isirel iŋa, “U variye ŋgama weiŋgu na wo wareri e mbaŋake iyake; ambane valɨkaiwae ghime, ghen na la ŋgamaŋgamake mbe e yawayawalinji na mane raya mare. ");
INSERT INTO tgo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ghino wombereghake ya dagerawe mane bigi regha mun i tharɨwe. U worawa vuyowoke wolaghɨye e ghino. Thoŋgo mane ya vaŋgunjoghama e ghen na ya vaŋgurawe e maran, ghawonjoweko ghino ne ya wo ghaghad yawaliŋgu. ");
INSERT INTO tgo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Wo u thuwe, thoŋgo mava wo roroghagha, mbala kaero mendava wo raka na wo njoghamava mbaŋaiwoniye.” ");
INSERT INTO tgo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Amba ramanji Isirel i dage weŋgi iŋa, “Thoŋgo mbema ŋgoreiya iyana, ko hu vakatha iyake: Hu bigiya thivathivake iyake une thovuthovuye vavana e lemi begibegiŋgina na hu yobigi weya amalana ŋgoreiya ghamwaewo — balɨm, ŋguyo, njambawo, mer, pistasiyo mbombouye, na almon. ");
INSERT INTO tgo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Hu mbana manima va hu mbanɨnjoghama, va ina e lemi begibegima tɨne e vwatae na hu mbanɨva vavana tembe le ghanaghanagha ŋgoreiyeva iyako, kaiwae manima iyava thɨ bigimban e lemi begibegina tembe hu bigi njoghava. Iyana mbwatava lolo regha i mban njoghathavwi. ");
INSERT INTO tgo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Hu vaŋgwa ghaghamina weimi na hu njogha weya amalana e mbaŋake iyake. ");
INSERT INTO tgo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ya naŋgo weya Loi vurɨghegheniye na i vakatha amalana ghare i nja weŋga na i vatomwe ghaghamina Benjamin na ne hu njoghama weimi. Ko e ghino, thoŋgo mbema emunjoru ya thɨvaiŋgiya lo ŋgaŋgake, mbema ya thɨvaiŋgi vara.” ");
INSERT INTO tgo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Iwaeŋge amaamalako thɨ mbana lenji mwaewoko thiyako na thɨ bigiya manima va thɨ mban njoghama na tembe valɨvagagava e vwatae. Na weinji Benjamin thɨ raka Ijipt, na vethɨ raka vuthawe vara Josep. ");
INSERT INTO tgo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Mbaŋa Josep i thuwe Benjamin kaero i dage weya rakakaiwoko iya i mbaro ele ŋgoloko iŋa, “U vaŋguŋgiya ghɨmoghɨmoruke thiyake na u yovaŋguŋgi elo ŋgoloko. Hu unɨgha thetheghan regha na hu vivatharawa ghanɨŋga. Ne ghararaghɨye mboro ya ghanɨŋga weiŋguyaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Amalama i vakatha ŋgoreiya Josep me dagemawe. I vaŋguŋgiya amaamalama na thɨ wa e ŋgolo. ");
INSERT INTO tgo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Amaamalama gharenji i laghɨlaghɨye mbaŋa thɨ wa e ŋgoloko. Lenji renuwaŋa thɨŋa, “Thɨ vaŋguinda na ra mena gheke kaiwae va thɨ bigimbanjogha manima ela begibegima. Nuwanjiya lenji vurɨgheghe i ghathɨinda kaero thɨ laweinda na le rakakaiwo ghinda na i mbanɨŋgiya la doŋɨkike.” ");
INSERT INTO tgo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Mbaŋa vethɨ vutha weya Josep le ŋgoloko e ghaghambaru, kaero thɨ dage weya ŋgoloko gha ranjimbunjimbu, thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Wo vata ago e ghen amalana, mbaŋa va wo menakaima gheke na wo vamodo ghanɨŋga, ");
INSERT INTO tgo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","na wo raka njogha, e kamwathɨ mborowae i gou weime na wo laghena. Gougouko iyako wo tateŋgiya lama begibegi na wo vaidiya manima iya mendava wo vamodo witɨkowe. Mbe iya varake. Mbowo mo mbanɨnjoghamava, ");
INSERT INTO tgo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","weiya vavanava e vwatae na wo vamodo ghanɨŋgawe. Maa tembe e lama ghareghareva va ŋgoroŋga na maniko tembe inanjiva e begibegiko tɨnenji.” ");
INSERT INTO tgo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Rakakaiwoma iya i mbaro Josep ele ŋgoloma i dage weŋgi iŋa, “Tha hu rerenuwaŋa kaiwae. Tha hu gharelaghɨlaghɨ. Lemi Loi, iye ramami le Loi mendava i giya manina iyana e ghemi, iya i bigimban e lemi begibegina. Lemi manima kaerova ya mban.” Amba i vaŋguraŋgiya Simiyon na i vaŋgugiya weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Rakakaiwoma i vaŋguruwoŋgiya amaamalama Josep ele ŋgoloke tɨne, i giya mbwa na thɨ thavwiya gheghenji na i ŋamweŋgiya lenji doŋɨkiko. ");
INSERT INTO tgo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kaero thɨ vivatha lenji mwaewoma Josep kaiwaema na mbala thɨ giyawe mbaŋa ne i njoghama ghararaghɨye mboro kaiwae me giya yanawanji Josep ne i mena i ghanɨŋga weiyaŋgi e lughawoghawoko iyako gheko. ");
INSERT INTO tgo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mbaŋa Josep i vutha weŋgi e ŋgoloko, thɨ bigiya mwaewoma methɨ mban menama e ŋgoloko na thɨ kururu e thelauko vwatae e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","I vaitoŋgi ghamɨnanji kaiwae na iŋa, “Ŋgoroŋga ramami, mendava huŋama kaero i amalaghɨsarɨ moli? Mbe inawe na amba e yawayawaliye?” ");
INSERT INTO tgo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Thɨ gonjoghawe thɨŋa, “Len rakakaiwo ramame, mbe e yawayawaliye na riwae mbe thovuye eŋge.” Na mbowo thɨ ronjava e ghenji vuvuye na thɨ kururu e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Mbaŋa i thuwe ghaghae Benjamin kaero i dage weŋgi iŋa, “Ghaghamike nasiyenimike iyava hu utuŋa utuniyeko weŋgo iya amalaghɨniyeke? Loi i dage mwaewo e ghen, naruŋgu.” ");
INSERT INTO tgo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Josep weiye le ghare vɨrɨ laghɨye mbaŋa i thuwe ghaghaeko, i ruku iteteŋgi na i wa mbe amalaghɨniye vara ele woluwolu tɨne na ve randawe. ");
INSERT INTO tgo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mbaŋa kaero me thavwiya ghamwae, i raŋgi na mbe i mbaroŋa vara ghamɨnaeko, kaero iŋa, “Hu theya ghanɨŋgana.” ");
INSERT INTO tgo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ghanɨŋga ghambaŋa Josep mbe le ghamba ghanɨŋga, oghaghae mbe lenji ghamba ghanɨŋga na Ijipt gharɨgharɨniye mbe lenji ghamba ghanɨŋga, kaiwae Ijipt gharɨgharɨniye thɨ ghɨmara njoŋanjoŋaŋgiya Hibru gharɨgharɨniye iya kaiwae maa thɨ ghanɨŋga weinjiyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Amaamalako va thɨ yaku na ghamwanji i ghemba Josep. Va thɨ yaku na ŋgoreiya ghanjitheghatheghako, i ri laghɨyeninji ghaghad nasiyeninji. Lenji yakuyakuko kaiwae gharenji iyo na thɨ vethuwethuweŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ghanjiko va thɨ the Josep ele ghamba ghanɨŋgako. Mbaŋa thɨ thembana ghanɨŋgako, Benjamin ghae i laghɨye moli — mbaŋalima vara thɨ themban na i laghɨye kivwalaŋgiya ghauneko. Thiya ghanɨŋga na thiya munumu weinji Josep ghaghadɨ thiya warari. ");
INSERT INTO tgo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Josep i dage weya le rakakaiwoko iya i mbaro ele ŋgoloko iŋa, “U mbana ghanɨŋga amala regha na regha ele begi na valɨkaiwae ne i bigi. E begi regha na regha e tɨne e vwatae moli u bigirawa regha na regha le mani. ");
INSERT INTO tgo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","U wo wo komuna iya silvana na u womban iya nasiyeninjina ele begi e tɨne weiye witɨna ghamani.” Kaero i vakatha ŋgoreiya Josep me dagemawe. ");
INSERT INTO tgo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ighɨviya rakerake le rakakaiwoŋgi thɨ variyeŋgi amaamalama na thiya wareri weinjiyaŋgiya lenji doŋɨki. ");
INSERT INTO tgo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Vama inanji e loŋga mborowae, ko maa vamba bwagabwaga e ghembako tɨne kaero Josep i dage weya le ŋgoloko gharanjimbunjimbu iŋa, “Hu rereghamba weŋgiya amaamalama. Mbaŋa ne vou vuthavaleŋgi, hu dage weŋgi, huŋa, ‘Buda kaiwae hu lithɨgha thovuye e tharɨ? ");
INSERT INTO tgo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Buda kaiwae mohu wokavɨ wo giyako ghakomu? Komuko iyako i vakaiwoŋa na i vaidiya bigibigi iya maa lolo regha i ghareghare vaghɨle ghenelolowe. Mbema mohu vakatha vara thanavu raitharɨ moli.’” ");
INSERT INTO tgo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mbaŋa i vuthavaleŋgi, i vathigiya Josep ghalɨŋaema weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ko iyemaeŋge thɨ dagewe thɨŋa, “Amalana, len utuutuna ŋgoreiyana ŋgoroŋga gharumwaru? Wo tholo e maran maa tembe valɨkaiwaeva wo vakatha vakatha ŋgoreiyana. ");
INSERT INTO tgo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","U ghareghare mendava wo mban njogha mani e lama begibegi tɨnenji e vwatae moli. Mbala buda kaiwae na wo kavɨ silva o gol e ghanɨgiyana ele ŋgolo? ");
INSERT INTO tgo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Amalana, thoŋgo ra vaidiya bigina iyana weya regha e tɨnemeke noroke i mare na taulaghɨke ghime wo tabo len rakakaiwobwaga.” ");
INSERT INTO tgo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","I dage weŋgi iŋa, “Ne ra vakatha ŋgoreiya moŋana. Ko iyemaeŋge mbe thela eŋge vara me wo komuko ne lo rakakaiwobwaga na taulaghɨna ghemi rakerakethu.” ");
INSERT INTO tgo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Mbe ghenji na nɨmanji eŋge thɨ bigi njoŋa lenji begibegi bode na regha na regha tembe i tate le begi. ");
INSERT INTO tgo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Amba rakakaiwoko i tamwe, i ri weya virɨvivako ghaghad nasiyeniyeko. Na komuko ve vaidi vara Benjamin ele begi tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Oghaghaeko wolaghɨye thɨ thetheŋgiya ghanjikwamakwama gharevɨrɨ kaiwae, kaero regha na regha i dowe njogha le doŋɨki na thɨ raka njogha Ijipt. ");
INSERT INTO tgo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Mbaŋa Juda na oghaghae thɨ raka vutha Josep vamba ina ele ŋgoloko. Taulaghɨko thɨ kururu na ghamwanji i nja e thelauko vwatae Josep e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","I dage weŋgi iŋa, “Budakai iya menda hu vakathake? Thare hu ghareghare lolo ŋgoreiya ghinoke valɨkaiwaŋgu ne ya vaidiya bigithan ma lolo reghava i ghareghare?” ");
INSERT INTO tgo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda i gonjoghawe iŋa, “Ŋgoroŋga ne woŋa e ghen, giya laghɨye? Ŋgoroŋga ne woŋa na wo vaemunjoruŋa e ghen mava wo vakatha vatharɨ weŋge? Loi tembe ghamberegha i woraŋgiya lama tharɨke. Iya kaiwae, amalana, taulaghɨke ghime, na thela iya komuko mena ele begi tɨne, len rakakaiwobwaga ghime.” ");
INSERT INTO tgo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ko iyemaeŋge Josep iŋa, “Maa valɨkaiwae ya vakatha iyana! Mbe thela eŋge vara komuko menawe, iye lo rakakaiwobwaga. Taulaghɨna ghemi hu raka njogha weya ramami weimi lemi gharemalɨlɨ.” ");
INSERT INTO tgo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Amba Juda i wa weya Josep na ve dagewe iŋa, “Ago laghɨye e ghen, giyana. Wo u vatomwe e ghino na ya woraŋgiya lo renuwaŋake. Gharen ne i ndegaithɨ wanaŋgo. Ya ghareghare u mboromboro wein Pero. ");
INSERT INTO tgo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Giya laghɨye, va u vaitoime na uŋa, ‘Thare e ramaramami o ghaghami reghava inawe?’ ");
INSERT INTO tgo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Wo gonjogha e ghen na woŋa, ‘Mbe e ramaramame, kaero i amalaghɨsarɨ, na ghaghame nasiyenime, vama i amalaghɨsarɨ amba i laghambɨ. Ŋgamako ghaghae laghɨyeniye kaero va i mare, tɨnanji regha. Ramae ghare mboro.’ ");
INSERT INTO tgo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Injana mbowo u dageva weime na uŋa, ‘Wo vohu vaŋguma na hu mena e ghino na wo ya thuwe.’ ");
INSERT INTO tgo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Na wo dage e ghen, giyana, woŋa, ‘Ŋgamako maa valɨkaiwaeva tene i roiteta ramae. Thoŋgo i vakatha ŋgoreiye ramae ne i mare.’ ");
INSERT INTO tgo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ko iyemaeŋge u dage weime uŋa, ‘Thoŋgo mane hu vaŋgu mena ghaghamina iya nasiyenimina, ko mane tembe hu mena hu ndeghathɨva e maraŋgu.’ ");
INSERT INTO tgo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Mbaŋa va wo njogha weya ramame wo utu giyawe budakai va u utugiya weime. ");
INSERT INTO tgo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Mbaŋa regha wo yakuyaku kaero ramame i dage weime iŋa, ‘Hu raka njogha na mbowo vohu vamodova ghanɨŋga seiwo.’ ");
INSERT INTO tgo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ko iyemaeŋge wo dagewe woŋa, ‘Mane wo raka. Thoŋgo mbe weime vara ghaghameko iya nasiyenimeko. Mane wo thuwe giyako ghamwae thoŋgo maa weime.’ ");
INSERT INTO tgo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Amba bwebwe i dage weime iŋa, ‘Kaero u ghareghare lo wevoko Reitiyel va i ghambɨŋgiya gamagai theghewo e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Regha kaerova i roiteteŋga na ya renuwaŋa thetheghan mbwanjam kaerova i tenɨghan, kaiwae maa tembe ya ndevaidiva mun ghaghad noroke. ");
INSERT INTO tgo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Na mbaŋake thoŋgo hu vaŋgwa ghaghaeke e ghino na vuyowo ve yomarawe, nuwatharɨniye ne i vakathaŋgo ya mare.’” ");
INSERT INTO tgo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Juda i gotubwe iŋa, “Iya kaiwae, giyana, mbaŋa ne wo njogha weya ramame, thoŋgo ŋgamake maa weime, mbaŋa ne i thuwe ŋgamake maa weime ne i mare. Yawaliye mboro iya ŋgamake iyake. Na kaiwae kaero i amalaghɨsarɨ moli gharevɨrɨko ne wo vakathakowe ne i unɨghɨ emunjoru. ");
INSERT INTO tgo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Wo u thuwe, ghino wombereghake mendava ya dagerawa yawaliŋguke weya bwebwe ŋgamake modae. Va ya dagewe na yaŋa, ‘Thoŋgo maa ya vaŋgu njoghama e ghen, vuyowoko wolaghɨye, bwebwe, e maran ya wo ghaghad yawaliŋgu.’ ");
INSERT INTO tgo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“E mbaŋake iyake, giyana, ghino eŋge ya yaku na ya tabo len rakakaiwobwaga, ya rothɨgha ŋgamake; na u viyathu i njogha weiyaŋgiya oghaghae. ");
INSERT INTO tgo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ne ŋgoroŋga na ya njogha weya bwebwe thoŋgo maa weiŋgu ŋgamake? Maa tembe nuwaŋguiya va thuwe vuyowoko ne i nja weya bwebweko.” ");
INSERT INTO tgo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","E mbaŋako iyako Josep maa tembe valɨkaiwaeva i ghataŋaghathɨgha ghamɨnaeko le rakakaiwoko wolaghɨye e maranji, iwaeŋge iŋa na thɨ raka iteta amalaghɨniye. Maa tembe lolo reghava va ina gheko, vambema amalaghɨniye eŋge na oghaghae, amba i govambwara thela amalaghɨniye weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Amba i randa na ghalɨŋae laghɨye. Ijipt gharɨgharɨniyeko thɨ loŋwe ghalɨŋae na utuniye tembe va vuthava kiŋɨko e ghayayao tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kaero Josep i dage weŋgiya oghaghaeko iŋa, “Josep ghino iyake. Bwebwe mbe e yawayawaliye?” Ko iyemaeŋge mbaŋa oghaghaeko thɨ loŋwe iyako maa valɨkaiwanji thɨ thombewe kaiwae gharenji va i tage laghɨye moli e marae. ");
INSERT INTO tgo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Amba Josep i dage weŋgi iŋa, “Hu raka mena evasiwaŋguke.” Thɨ vakatha ŋgoreiye na mbowo i dageva weŋgi iŋa, “Ghino ghaghamima Josep iyava hu vakuneŋama na i mena Ijipt. ");
INSERT INTO tgo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mbaŋake thava hu gharelaghɨlaghɨ na thava hu vegaithɨ wanaŋga kaiwae va hu vakuneŋaŋgo gheke. Loi va le renuwaŋa e tɨne na ya viva e ghamwami gheke na valɨkaiwae ya vamoru gharɨgharɨ yawalinji. ");
INSERT INTO tgo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kaero theghathegha umboiwo vara iyake, maa ghanɨŋga i ndembuthu mun e valɨvaŋgake iyake. Theghathegha umbolima amba inawe na e tɨne mane ghanɨŋga ghakabu o uloulo. ");
INSERT INTO tgo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ko iyake kaiwae Loi va i variyeŋgo e ghamwami gheke na valɨkaiwae orumburumbumi vavana mbe e yawayawalinji e yambaneke. Na i vamoru yawalɨmi e kamwathɨke iya ghamba rotaeleke tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Iya kaiwae, ghemi mava hu variyeŋgo gheke, ko iyemaeŋge Loi va i variyeŋgo. I vakathaŋgo ghino ŋgoreiye kiŋɨko ramae. I woraweŋgo ya mbaroŋa le vanautumake iyake, na ya mbaro Ijipt laghɨyeke. ");
INSERT INTO tgo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hu vamayaŋa na hu njogha weya bwebwe na hu dagewe huŋa, ‘Naru Josep ghalɨŋae ŋgoreiyake: Loi kaerova i vakathaŋgo giya laghɨye na ya mbaroŋa Ijipt laghɨyeke; hu vamayaŋa na hu mena. ");
INSERT INTO tgo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ne hu yaku e valɨvaŋga idae Gosen, na ne inami evasiwaŋgu, ghen, len ŋgaŋga, orumburumbu, len sip, len gout, len burumwaka, na len bigibigina wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mbaŋa ne inami gheko, mbene ya njimbukikiŋga vara. Kaiwae theghathegha umbolima amba inawe vunuvuke ne ve wo; na maa nuwaŋguiya ghen, le ŋgaŋga na len bigibigina wolaghɨye bada i gaboŋga.’” ");
INSERT INTO tgo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Josep i gotubwe iŋa, “Kaero hu thuwe taulaghɨna ghemi, na Benjamin, ghen tembe ŋgoreiyeva, mbema emunjora ghino Josep. ");
INSERT INTO tgo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Vohu utu giya weya bwebwe ŋgoroŋga wo yavwatata le laghɨlaghɨye Ijipt e tɨne, na tembe ŋgoreiyeva bigibigike wolaghɨye iya kaero hu thuweŋgike. Ko hu vamayaŋa eŋge hu vaŋgumena bwebwe gheke.” ");
INSERT INTO tgo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Amba Josep i bigirawa nɨmanɨmae Benjamin e vwatae na i randa; na Benjamin i thovuvu na tembe i randava. ");
INSERT INTO tgo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Josep tembe i vakathava ŋgoreiyako weŋgiya oghaghaeko regha na regha na i vandamoŋgi. Iyako e ghereiye amba thɨ utu weinji. ");
INSERT INTO tgo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mbaŋa Josep oghaghaeko lenji vutha Ijipt utuutuniye kaero ve wo kiŋɨko ghayayao, i vakatha kiŋɨko na ghambandɨmbandɨ thiya warari. ");
INSERT INTO tgo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pero i dage weya Josep iŋa, “U dage weŋgiya oghaghanɨna na thɨ raka njogha Kenan. ");
INSERT INTO tgo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","U dage weŋgi na vethɨ vaŋguma ramanji na lenji bodabodako wolaghɨye na thɨ raka njoghama gheke. Ne ya wogiya the thivathiva regha thovuye Ijipt e tɨneke, na the bigiya nuwanjiya ne i mboromboro weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“U dage weŋgi na thɨ momodɨŋgiya waŋga momod vavana Ijipt e tɨneke lenji ovo na gamagai nanasiye kaiwanji; na tembe thɨ vaŋgu menava ramanji weinji. ");
INSERT INTO tgo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","U dage weŋgi ne thɨ ndererenuwaŋa the bigibigiva kaiwanji. The bigibigi thovuthovuye inanji Ijipt e tɨne ne ra giya weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Isirel le ŋgaŋga thɨ vakatha ŋgoreiya me dagema weŋgi. Josep i giya waŋga momod vavana ŋgoreiya kiŋɨko meŋama, na ghanɨŋga kamwathɨ kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Tembe i giyava kwama togha regha iya weŋgi oghaghaeko, ko iyemaeŋge i giya silva gethɨseriyeto weya Benjamin na kwamakwama totogha yaŋgalima. ");
INSERT INTO tgo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","I variya doŋɨki hoyawora, thɨ dowa Ijipt bigibiginiye thovuthovuye na doŋɨki hoyaworo thɨ dowa wit na bred na ghanɨŋga lenji njoghamake kamwathɨ kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kaero i variye yathuŋgi oghaghaema na thɨ raka, na i thɨnɨmbuleŋgi iŋa, “Ne hu ndegaithɨ e kamwathɨ mborowa.” ");
INSERT INTO tgo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kaero thɨ raka iteta Ijipt na thɨ raka njogha weya ramanji Jeikob, Kenan e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Thɨ raka vutha kaero thɨ dage weya ramanji thɨŋa, “Josep mbe e yawayawaliye. Iye i mbaro Ijipt laghɨyeko.” Ramanji Jeikob ghare i yo laghɨye moli na maa i loŋweghathɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ko iyemaeŋge mbaŋa thɨ utugiya bigibigiko wolaghɨyewe, iya Josep mendava i utugiyama weŋgi, na mbaŋa i thuwe waŋga momodɨŋgiko iya Josep va i variyeko na thɨ dowewe, ko ambama ghare ve dinja. ");
INSERT INTO tgo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Na iŋa, “Meiye! Ko ana naruŋguma Josep mbe e yawayawaliye! Wo ya wa na va thuwe amba muyai ya mare.” ");
INSERT INTO tgo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jeikob kaero i wareriŋa Ijipt weiyaŋgiya ghambandɨmbandɨko wolaghɨye, na mbaŋa i vutha Beyasiba i lavakatha vowo weya ramae Aisake le Loi. ");
INSERT INTO tgo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Gougouniye Loi i utuwe e ghavatomwe tɨne iŋa, “Jeikob! Jeikob!” Jeikob i gonjoghawe iŋa, “Mbe ghinoke.” ");
INSERT INTO tgo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","I dagewe iŋa, “Ghino Loi, rama le Loi. Tha u mararu u wa Ijipt, ne ya vakathaŋgiya orumburumbu tha muyaiko thɨ tabo vanautuma laghɨye regha gheko. ");
INSERT INTO tgo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ghino ne weiŋgu ghen ra wa Ijipt, na tembene ya vaŋgu njoghaŋgiva orumburumbu tha muyaiko gheke. Josep ghamberegha e nɨmae ne i vuna maramaran mbaŋa ne u mare.” ");
INSERT INTO tgo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Amba Jeikob i wareriva Beyasiba e tɨne. Le ŋgaŋga thɨ vaŋgu doweŋgi weiyaŋgiya lenji ŋgaŋga nanasiye na lenji ovo e waŋga momodɨŋgina Pero va i variyeŋgi Ijipt kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Tevambe thɨ vaŋguŋgiva lenji thetheghanɨko na bigibigiko wolaghɨye va thɨ mban vathavatha Kenan e tɨne na tembe orumburumbuyekova wolaghɨye thɨ raka Ijipt. ");
INSERT INTO tgo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jeikob va i vaŋguŋgiya le ŋgaŋga, orumburumbuye ghɨmoghɨmoru, le ŋgaŋga wanakau, na orumburumbuye wanakau. ");
INSERT INTO tgo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jeikob le ŋgaŋga na orumburumbuye va thɨ ri Kenan na thɨ raka Ijipt idaidanji thiyake: Rubin, Jeikob nariye virɨviva. ");
INSERT INTO tgo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubin le ŋgaŋgaŋgiya: Hanok, Palu, Hesron na Kami. ");
INSERT INTO tgo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiyon le ŋgaŋgaŋgiya: Jemuel, Jamin, Ohad, Jakin, Soha na Saul iye tɨnae tɨnan Kenan. ");
INSERT INTO tgo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Livai le ŋgaŋgaŋgiya: Gereson, Kohat na Merari. ");
INSERT INTO tgo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juda le ŋgaŋgaŋgiya: Er, Onam, Sila, Peres na Sera. Ko iyemaeŋge Er na Onan vambe thɨ mare Kenan e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka le ŋgaŋgaŋgiya: Tola, Pua, Jasub na Simiron. ");
INSERT INTO tgo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon le ŋgaŋgaŋgiya: Sered, Elon na Jalil. ");
INSERT INTO tgo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ghɨmoghɨmoruke thiyake Leya va i ghambɨŋgi weiye Jeikob Padan Aram e tɨne weinji lounji Daina. Le ŋgaŋga ghɨmoghɨmoru na wanakau lenji ghanaghanagha theto na thegheto. ");
INSERT INTO tgo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad le ŋgaŋgaŋgiya: Sipon, Hagi, Suni, Esbon, Eri, Arodi na Areli. ");
INSERT INTO tgo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asa le ŋgaŋgaŋgiya: Imna, Isva, Isvi, na Beraiya. Lounji Sera. Beraiya le ŋgaŋgaŋgiya: Heba na Malɨkiyel. ");
INSERT INTO tgo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Gamagaike thiyake Silpa va i ghambɨŋgi weiye Jeikob. Wevoke iyake Leiban va i vaŋgugiya weya yawarumbuye Leya na le rakakaiwo. Lenji ghanaghanagha theyaworo na theghewona. ");
INSERT INTO tgo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jeikob levo Reitiyel le ŋgaŋgaŋgiya thiyake: Josep na Benjamin. ");
INSERT INTO tgo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ijipt e tɨne Josep ve ghambɨŋgiya Manase na Epreim weiye Asenat, Potipa yawarumbuye. Amalake iyake ravowovowo On e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin le ŋgaŋgaŋgiya: Bela, Beka, Asbel, Gera, Naaman, Ehi, Ros, Mapim, Hapim na Ad. ");
INSERT INTO tgo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ghɨmoghɨmoruke thiya Reitiyel va i ghambɨŋgi weiye Jeikob. Lenji ghanaghanagha theyaworo na theghevarɨ. ");
INSERT INTO tgo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Den nariya iyake: Hasim. ");
INSERT INTO tgo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napɨtalai le ŋgaŋgaŋgiya thiyake: Jasiyel, Guni, Jesa, na Silem. ");
INSERT INTO tgo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ghɨmoghɨmoruke thiyake Bilha va i ghambɨ weiye Jeikob. Leiban va i vaŋgugiya wevoke iyake weya yawarumbuye Reitiyel. Lenji ghanaghanagha theghepirɨ. ");
INSERT INTO tgo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Gharɨgharɨke vara wolaghɨye thiyake iyava thɨ rakake Ijipt weinji Jeikob mbe amalaghɨniye vara orumburumbuye moliŋgi. Lenji ghanaghanagha thewona na theghewona. Iyake ma i vaonaŋgiya le ŋgaŋga lenji ovo. ");
INSERT INTO tgo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Josep va i ghambɨŋgiya gamagai theghewo Ijipt e tɨne, i vakatha Jeikob le bodaboda va inanji Ijipt lenji ghanaghanagha thepirɨ. ");
INSERT INTO tgo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Mbaŋa kaero thɨ vurɨthaiya Ijipt, Jeikob i variye Juda e ghamwae na ve thuwe Josep mbala ve lavolevoleŋgi Gosen. Mbaŋa thɨ rakavutha gheko, ");
INSERT INTO tgo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josep kaero i thava ele waŋga momod na i wa Gosen ve lavolevoleya ramaewe. Mbaŋa thɨ vethuwethuweŋgi, Josep i bigiyatho nɨmanɨmae ramae Isirel e ŋgɨleŋgɨle na i randa mbaŋa molao moli. ");
INSERT INTO tgo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Amba Isirel i dage weya Josep iŋa, “Mbaŋake kaero valɨkaiwaŋgu ya mare. Kaero ya thuweŋge na ya ghareghare amba e yawayawalin.” ");
INSERT INTO tgo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Josep i dage weŋgiya oghaghae na ramae ghauuko gharɨgharɨniye iŋa, “Wo ya wa Pero na va utuwe, vaŋa, ‘Oghaghaŋguma na bwebwe ghauuko gharɨgharɨniye, va thiya yakuma Kenan kaero methɨ raka vutha weŋgo. ");
INSERT INTO tgo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ne va utugiyawe ghemi sip gharanjimbunjimbu, na hu njimbukikiŋgiya thetheghan — burumwaka, sip na gout lemoyo moli. Na menda hu vaŋgu menaŋgi — lemoyo moli weiye lemi bigibigiko wolaghɨye.’ ");
INSERT INTO tgo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mbaŋa Pero ne i kula vathaŋga na i vaitoŋga na iŋa, ‘Ghemi ghamikaiwo budakai?’ ");
INSERT INTO tgo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mbala hu gonjoghawe na huŋa, ‘Len rakakaiwo, mbaŋake wolaghɨye wo njimbukikiŋgiya burumwaka, sip na gout ŋgoreiya va mbe orumburumbume tha na tha va thɨ vakavakatha.’ Ne e kamwathɨke iyake ambane i vatomwe Gosen le valɨvaŋga na hu yakuwe. Kaiwae Ijipt gharɨgharɨniye thɨ botewoŋgiya sip gharanjimbunjimbu.” ");
INSERT INTO tgo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Josep i wa weya Pero na ve dagewe iŋa, “Bwebwe na oghaghaŋgu weinjiyaŋgiya lenji burumwaka, sip na gout na lenji bigibigiko wolaghɨye kaero mendama thɨ raka vutha, thɨ ri Kenan na mbaŋake inanji Gosen.” ");
INSERT INTO tgo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","I tuthiŋgiya oghaghae theghelima na i vaŋgu vamara weŋgiya Pero. ");
INSERT INTO tgo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kaero i vaitoŋgi, “Ghamikaiwo budakai?” Thɨ gonjoghawe thɨŋa, “Amalana, ghime sip gharanjimbunjimbu, ŋgorameŋgiya orumburumbume tha na tha. ");
INSERT INTO tgo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Mendava wo mena na wo wo layaku gheke, kaiwae vunuvuke kaero i vakatha dagabora Kenan e tɨne. Lama thetheghanɨko kaero maa e ghanjinana, iya kaiwae wo vata ago e ghen na wo wo layaku Gosen.” ");
INSERT INTO tgo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pero i dage weya Josep iŋa, “Rama na oghagha kaero methɨ vutha e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ijipt thivathivaniyeke laghɨye ina e nɨman ghare. U vaŋguraweŋgi Gosen ele valɨvaŋga, thivathiva thovuye moli. Na thoŋgo sip gharanjimbunjimbu thovuthovuye vavana inanji e tɨnenjina, u vaŋguraweŋgi na thɨ njimbukikiya lo sip na lo burumwakana.” ");
INSERT INTO tgo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Amba Josep i vaŋgu menava ramae Jeikob na i vaŋgurawe Pero e marae. Jeikob i giya Pero ghadagemwaewo ");
INSERT INTO tgo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","na Pero i vaito iŋa, “Ŋgoroŋga ghan theghathegha le laghɨlaghɨye?” ");
INSERT INTO tgo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jeikob i dagewe iŋa, “Yawaliŋguke ghayakuyaku mbe ya riye na ya nja eŋge e ghemba na ghemba theghathegha hothaŋarɨ na ghweto (130). Maa i ghanagha moli ko vuyowo eŋge va ina e tɨnenji. Maa ŋgoreiya orumburumbuŋgu ghanjitheghathegha me molao e lenji loŋgaloŋga tɨne.” ");
INSERT INTO tgo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Amba Jeikob mbowo i giyava Pero ghadagemwaewo na i itete. ");
INSERT INTO tgo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ŋgoreiya Kiŋ Pero me dagemawe, Josep i vaŋguraweŋgiya ramae na oghaghaeko e thivathiva thovuye Ijipt e tɨne e ghemba laghɨye Rameses ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josep i giya ghanɨŋga weŋgiya ramae, oghaghaeko na gharɨgharɨko wolaghɨye ŋgoreiye valɨkaiwanji. ");
INSERT INTO tgo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Vunuvuko vama i wo mbaŋa molao moli na e valɨvaŋgake wolaghɨye kaero maa ghanɨŋga. Gharɨgharɨ Ijipt na Kenan e tɨnenji bada kaiwae kaero maa e lenji vurɨgheghe. ");
INSERT INTO tgo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Mbaŋa gharɨgharɨ va thɨ vavamodo wit, Josep i mbana maniko wolaghɨye na i yomban Pero ele ŋgoloko. ");
INSERT INTO tgo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mbaŋa mani kaero iko weŋgiya gharɨgharɨ Ijipt na Kenan e tɨnenji, Ijipt gharɨgharɨniye thɨ raka mena weya Josep na thɨŋa, “U giya ghanɨŋga weime. Lama mani kaero iko. Buda kaiwae ne woya mare e maran?” ");
INSERT INTO tgo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josep i gonjogha weŋgi iŋa, “Hu bigima lemi thetheghanɨma. Ne ya giya ghanɨŋga e ghemi na modae, kaiwae lemi mani kaero iko.” ");
INSERT INTO tgo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kaero thɨ bigi menaŋgiya lenji thetheghan weya Josep na i giya ghanɨŋga weŋgi na modae. Thɨ bigi mena lenji hosɨ, sip, gout, burumwaka na doŋɨki. Theghatheghako iyako e tɨne i giya ghanɨŋga weŋgi lenji thetheghanɨko modae. ");
INSERT INTO tgo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Theghatheghako iyako iko na umbwarava e ghamwanjiko mbowo thɨ mena weva na thɨ dagewe thɨŋa, “Amalana, mane valɨkaiwame wo wothuwola iya emunjoruke iyake e ghen. Lama mani kaero iko na lama thetheghanɨma wolaghɨye kaero ghenɨwe. Maa tembe bigi reghava inawe na wo woveŋge, ma riwameke eŋge na lama thelau. ");
INSERT INTO tgo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Buda kaiwae ne woya mare e maranɨna, ghime na lama thelathelauke? U vamodoime na lama thelathelauko ghanɨŋga modae, na ghime weiye lama thelathelauko wo tabo rakakaiwobwaga weya Pero. U giya weiwo weime na wo kabu amba ne maa valɨkaiwae woya mare, na thelauko mbala maa i rorobwaga.” ");
INSERT INTO tgo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Josep i vamodovao thelauko wolaghɨye Ijipt e tɨne Pero kaiwae. Kaiwae vunuvuko vama i vakatha dagabora laghɨye i vakatha Ijipt gharɨgharɨniyeko wolaghɨye thɨ vakuneŋa lenji thelau. Na thelauko wolaghɨye kaero i tabo Pero le bigi. ");
INSERT INTO tgo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Josep i vakathaŋgiya gharɨgharɨ Ijipt e valɨvaŋga na valɨvaŋga thɨ tabo rakakaiwobwaga. ");
INSERT INTO tgo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Iyemaeŋge ravowovowo lenji thelau mava i vamodoŋgi, kaiwae Pero va i vamodoŋgi lenji kaiwoko kaiwae, na lenji maniko valɨkaiwanji thɨ vamodo ghanjiwe. ");
INSERT INTO tgo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Josep i dage weŋgiya gharɨgharɨko iŋa, “Wo hu thuwe, noroke kaero ya vamodoŋga — ghemi na lemi thelauna, Pero kaiwae. Noroke ya giya weiwo e ghemi na hu kabu e lemi umaumana. ");
INSERT INTO tgo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mbaŋa uloulo ghambaŋa, ne u wabwi na wabwilima. Wabwi regha i wa weya Pero na wabwi varɨ weiwo togha kaiwae, ghanɨŋga ghemi kaiwami, len ŋgolona gharɨgharɨniye kaiwanji na len ŋgamaŋgama kaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Gharɨgharɨko thɨ gonjoghawe thɨŋa, “Kaero menda u vamora yawalɨme. Na mendava u thovuye vara weime, amalana. Kaero wo tabo Pero le rakakaiwobwaga.” ");
INSERT INTO tgo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Josep i vakatha iyako kaero i tabo na i mbaro Ijipt e tɨne, va e mbaŋako iyako ghaghad noroke: Wabwilimako wabwi regha e bigibigiko wolaghɨye thɨ raka mena e thelauko Pero kaiwae. Ravowovowo lenji thelau vara mava i tabo Kiŋ Pero le bigi. ");
INSERT INTO tgo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isirel gharɨgharɨniye thɨ yayaku Gosen ele valɨvaŋga Ijipt e tɨne. Kaero lenji bigibigi lemoyo moli na lenji ŋgamaŋgama lemoyo moli. ");
INSERT INTO tgo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Theghathegha hoyaworo na umbopirɨ Jeikob i yaku Ijipt e tɨne na ghatheghathegha kaero i wo theghathegha hoseriyethaŋarɨ ghwevarɨ na umbopirɨ (147). ");
INSERT INTO tgo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mbaŋa Isirel ghambaŋa mare kaero i gheneghenetha, kaero i kula weya nariye Josep na i dagewe iŋa, “U lirawa nɨmanɨna e vavaŋguke e raberabe na u dagerawe mane u bekuŋgo Ijipt e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mbaŋa ne ya garalawa weŋgiya orumburumbuŋgu, u woraŋgiyaŋgo Ijipt e tɨne na vo bekuŋgo thiye evasiwanji.” Josep i gonjoghawe iŋa, “Ne ya vakatha ŋgoreiya moŋana.” ");
INSERT INTO tgo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jeikob i dagewe iŋa, “U dagerawe e ghino.” Josep i dagerawe e marae na ne i vakatha ŋgoreiye. Amba Isirel i ghenevadede le pwasike na i kururu weya Loi. ");
INSERT INTO tgo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Mbaŋa ubotu e ghereiye Josep i loŋwevaidiya ramae utuniye, i ghambwera. Iwaeŋge i vaŋguŋgiya le ŋgaŋgako theghewoko, Manase na Ipɨreim, weiyaŋgi thɨ wa weya ramae Jeikob. ");
INSERT INTO tgo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mbaŋa Josep i vutha, lolo regha ve dage weya Jeikob iŋa, “Naru Josep kaero me vutha, i mena i thuweŋge.” Kaiwae vama amalaghɨsarɨ i rovurɨgheghe i thuweiru na i yaku. ");
INSERT INTO tgo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jeikob i dage weya Josep iŋa, “Loi Vurɨvurɨghegheniye va i yomara e ghino Luji e tɨne Kenan ele valɨvaŋga na i mwaewo e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Na i dage e ghino iŋa, ‘Ne ya vakathaŋge na orumburumbu lemoyo na orumburumbuko thiyako nevole thɨ tabo vanautuma lemoyo. Na nevole ya giya thivathivake iyake na i meghabana weŋgi.’” ");
INSERT INTO tgo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Jeikob i gotubwe iŋa, “Josep, iya len ŋgaŋgana theghewona va thɨ virɨna Ijipt e tɨne amba muyai ya menake, Ipɨreim na Manase, ne thɨ tabo lo ŋgaŋga. Thiye ne ŋgoronjiya Rubin na Simiyon lo ŋgaŋgaŋgi moli. ");
INSERT INTO tgo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ko thoŋgo len ŋgaŋga vavanava thɨ roghambɨ e ghereinji, ghen len ŋgaŋga. Ko the valɨvaŋga Ipɨreim na Manase ne vethɨ yakuwe thiye ne inanjiwe. ");
INSERT INTO tgo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mbaŋa vama ya njoghanjoghama, ya ri Padan Aram, kaero iname Kenan ele valɨvaŋga, iwaeŋge Reitiyel i mare. E mbaŋako iyako wo loŋga na ghamwame i ghemba Eprat. Reitiyel le mareko kaiwae ghareŋgu i vɨrɨ laghɨye moli. Eprat e ghakamwathɨ ghadidiye ya bekuwe.” (Noroke Eprat idae Betɨlehem.) ");
INSERT INTO tgo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Mbaŋa Isirel i thuweŋgiya Josep le ŋgaŋgako kaero i vaito iŋa, “Thavalaŋgiya gamagaike thiyake?” ");
INSERT INTO tgo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josep i gonjogha weya ramae iŋa, “Ghino lo ŋgaŋgaŋgi. Loi va i giya e ghino gheke, Ijipt e tɨneke.” Amba Isirel i dagewe iŋa, “U vaŋgu menaŋgi e ghino na ya giya ghanjimwaewo.” ");
INSERT INTO tgo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Va e mbaŋako iyako Isirel maramarae kaero thɨ tharɨ kaiwae vama i amalaghɨsarɨ. Iwaeŋge Josep i vaŋgu menaŋgiya le ŋgaŋgama theghewoma evasiwae. Isirel i vandamoŋgi na i livatharaŋgwa nɨmanɨmae e mborowanji. ");
INSERT INTO tgo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isirel i dage weya Josep iŋa, “Lo renuwaŋa va yaŋa eŋge mane te mbaŋa reghava ya thuweŋge, ko iyemaeŋge mbaŋake Loi menda i vatomwe e ghino na ya thuweŋgiya len ŋgaŋgake.” ");
INSERT INTO tgo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Amba Josep i vaŋguraŋgiyaŋgi le ŋgaŋga ramae Isirel e gheghe na i kururu ghamwae i nja e thelauko vwatae weya ramae. ");
INSERT INTO tgo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josep i vaŋgurawa nariye Ipɨreim Isirel e moiyeko na Manase e uneko. ");
INSERT INTO tgo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ko iyemaeŋge Isirel i mban vagaghala nɨmanɨmae na nɨmae uneko i lirawe Ipɨreim e umbaliye, othembe raŋama iye virɨ reghamba na nɨmae moiyeko i lirawe Manase e umbaliye, amalaghɨniye virɨviva. ");
INSERT INTO tgo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Amba i giya Josep le ŋgaŋgako ghanjimwaewo iŋa, “Rumbuŋgu Eibraham na ramaŋgu Aisake va thɨ loŋgaloŋga Loi e ghamwae ŋgoreiye le renuwaŋa, na ghaghada mbaŋake noroke vara Loi i viva e ghino ŋgoreiye sip gharanjimbunjimbu i vaŋguŋgiya le sip. ");
INSERT INTO tgo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Nyaoko thovuye iya Loi va i variyeko, i njaŋanjaŋa e ghino na maava tharɨ regha i vakowanaŋgo. Ya naŋgo weya Loi na i giya gamagaike thiyake ghanji mwaewo. Ya naŋgo weya Loi gharɨgharɨ ne thɨ renuwaŋakikiŋgo kaiwae, Loi le vakathaŋgiko kaiwanji. Ya naŋgo weya Loi ne i vakatha lenji ŋgaŋga lemoyo na orumburumbunji lemoya e yambaneke laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mbaŋa Josep i thuwe ramae i lirawa nɨmae uneko Ipɨreim e umbaliye ghare i muruwana, iwaeŋge i liya ramae nɨmaeko Ipɨreim e umbaliye na i lirawe Manase e umbaliye. ");
INSERT INTO tgo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Josep i dage weya ramae iŋa, “Maa ŋgoreiyana, bwebwe. Manase iye virɨviva. U lira unenɨna e umbaliye.” ");
INSERT INTO tgo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ko iyemaeŋge ramae i botewo na iŋa, “Ya ghareghare, naruŋgu, ya ghareghare budakaiya ya vakavakatha. Manase orumburumbuye tha muyaiko nevole thɨ tabo vanautuma laghɨye regha. Ko iyemaeŋge ghaghae nasiyeniyeko nevole i laghɨye kivwala amalaghɨniye, na orumburumbuye tha muyaiko nevole thɨ tabo vanautuma laghɨlaghɨyeŋgi.” ");
INSERT INTO tgo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kaero i giya ghanjimwaewo e mbaŋako iyako, iŋa, “Mbaŋa Isirel gharɨgharɨniye ne thɨ vegiya ghanjimwaewo ne thɨŋa: ‘Loi valɨkaiwae i vakathaŋga ŋgoreiya Ipɨreim na Manase.’” E kamwathɨko iyako i vakatha Ipɨreim i laghɨye kivwala Manase. ");
INSERT INTO tgo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Amba Isirel i dage weya Josep iŋa, “Mbaŋa ma nasiye eŋge kaero ya mare. Ko iyemaeŋge Loi ne weiye ghemi na ne i vaŋgu njoghaŋga e valɨvaŋgako iya orumburumbumi va thɨ rikowe. ");
INSERT INTO tgo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","E ghen eŋge, maa oghaghaŋgina, kaero ya vatomwe thivathiva i thovuye moli, idae Sekem. Thivathivako iyako va ya wo weŋgiya Amori gharɨgharɨniye elo gaithɨ ghaghalithɨ na mbwenara.” ");
INSERT INTO tgo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Amba Jeikob i kula vathavathaŋgiya le ŋgaŋga na i dage weŋgi iŋa, “Hu roghɨliŋaŋgo na wo ya utu e ghemi nevole the bigithan i yomara e ghemi mbaŋa muyaiko. ");
INSERT INTO tgo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Wo hu rakamena na hu vandeŋe. Ghino ramami Isirel. ");
INSERT INTO tgo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubin, ghen naruŋgu virɨviva, ghen lo vurɨgheghe. Na naruŋgwa ghen mbaŋa vamba tabwagha vara ghino. Ghen u mevoro moli lo ŋgaŋgake wolaghɨye e tɨnenji. Ghen u vurɨgheghe laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ghen ŋgorana ŋgonuŋgo vorughala. Ko iyemaeŋge maane vole lolo laghɨye moliya ghen. Kaiwae va u vanaŋa rama ghandiye na maa u yavwatatawana rama le ghamba ghena. Iyake ghamba monjina laghɨye e ghino. ");
INSERT INTO tgo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiyon na ghaghae Livai, va thɨ vakaiwoŋa lenji gaithɨ ghaghalithɨ na thɨ gabowe. ");
INSERT INTO tgo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Maane ya ru e lenji utu thuwoleko. Maane ya metha weiŋguyaŋgi e lenji nivako. Kaiwae lenji gatemuru e tɨne thɨ gaboŋgiya gharɨgharɨ na thɨ vuŋgi okɨs ghegheŋji vuvuye mwadiwo kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ya naŋgo weya Loi na i gura lenji gaithɨko, kaiwae lenji gaithɨko i maramararu moli. Ne ya rake orumburumbunjiko na vethɨ yayaku Jeikob orumburumbuyeŋgi e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, oghaghaeke nevole thɨ taraweŋge. Ne u laweŋgiya ghan thɨghɨya e numonji. Oghaghana nevole thɨ kururu e ghen. ");
INSERT INTO tgo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda iye ŋgoreiya laiyon nariye. I unɨgha ghae na i njogha e ghambae. I vamomoya gheghe na i ghena. Maa lolo regha valɨkaiwae i vakaravoya riwae. ");
INSERT INTO tgo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Juda ghauu ghɨmoghɨmoruniye ne thɨ tabo kiŋ. Na orumburumbuye tha na tha nevole mbe thɨ mbarombaro vara. Vanautuma na vanautuma ne thɨ mwaewowe na thɨ kururuwe na thɨ ghambu. ");
INSERT INTO tgo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","I ŋgara le doŋɨki e vaen Na e yaŋgaeko thovuye moli i ŋgara doŋɨkiko nariyewe. Ne i thavwiya ghakwamakwama e waen sosoro. ");
INSERT INTO tgo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Maramarae thɨ bwedi kivwala waen, ŋiŋiye thɨ kaleva kivwala milɨk. ");
INSERT INTO tgo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon ne i yakuŋa njighɨ ghadidiye na ne i tabo vwaruvwaruru thovuye waŋgawaŋga kaiwanji. Le ghamba mbaro ne ve wo Saidon. ");
INSERT INTO tgo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka iye i vurɨgheghe ŋgoreiya doŋɨki. Mbaŋa riwae i bane ne i ghenethɨna ghaghadoweko. ");
INSERT INTO tgo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mbaŋa i thuwe le ghamba towoko i thovuye, na thelauko le thovuthovuye, amba i vathawo wakɨyeko na i thɨna ghabigiko. Thɨ vavurɨghegheŋa na i kaiwo ŋgoreiya rakakaiwobwaga. ");
INSERT INTO tgo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Den ne i mbaroŋaŋgiya le gharɨgharɨ ŋgoreiya iye wabwi regha Isirel e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Den iye ŋgoreiye mwata mamate e kamwathɨ ghadidiye. Iya i ghara hosɨko gheghe, na hosɨko i wokiyatho rathathako e ghereiye. ");
INSERT INTO tgo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Giya Loi, ya roroghagha len vamoru kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ramban bwagabwaga ne thɨ laweya Gad. Ko iyemaeŋge Gad ne i kivwalaŋgi na i vambeleyathuŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asa le thelau ne i rau na une i thovuye. Ne i thovuye moli na valɨkaiwae i mban na kiŋ ghae. ");
INSERT INTO tgo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napɨtalai iye ŋgoreiya diya wevo rakerakethu i ruku. I ghambɨŋgiya le ŋgaŋga thovuthovuye na manɨune. ");
INSERT INTO tgo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josep iye ŋgoreiya vaen i rau wagiyawe. Iye ŋgoreiya vaen i ndeghathɨ e mbwarowou ghadidiye. Iye ŋgoreiya vaen yaŋgayaŋgae i mbuthu valaŋaniye baba. ");
INSERT INTO tgo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ghanji thɨghɨya thɨ gaithɨwana weinji lenji ghatemuru. Thɨ ighaighaŋa e mbwenara na kinkin. ");
INSERT INTO tgo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ko iyemaeŋge Josep i du wagiyawe le kinko na mbwenarako. Nɨmanɨmaeko thɨ vurɨgheghe. Le vurɨghegheko i wo weya Jeikob le Loi Vurɨvurɨghegheniye. Le vurɨghegheko i wo weya Sip gharanjimbunjimbu, iye Isirel Varɨniye. ");
INSERT INTO tgo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Rama le Loi i thalavuŋge. Loi Vurɨvurɨghegheniye i mwaewo e ghen. I mwaewo e ghen e uye i njama e buruburu. I mwaewo e ghen e mbwa i voroma e thelauke tɨne. I mwaewo e ghen e thetheghan lemoyo na e gamagai. ");
INSERT INTO tgo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mwaewo i mena weya rama i kivwala mwaewo i mena e ouou teteuye. Thɨ kivwalaŋgiya bigibigi thovuthovuye thɨ mena e bobokulu thɨ meghabana. Valɨkaiwae mwaewoke thiyake thɨ yayaku Josep e umbaliye. Valɨkaiwae thɨ yaku loloko iya i meghaghathɨ weŋgiya oghaghaeko e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin ŋgoreiya mbugha njamnjam tagaithɨ. Mbaŋambaŋa i ghana budakai me unɨghɨ. Gougou i giya budakaiya me mban.” ");
INSERT INTO tgo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Thiyake Isirel wabwiniyeŋgi. Lenji ghanaghanagha theyaworo na theghewo. Iyake ghalɨŋae weŋgi mbaŋa i giya le ŋgaŋga regha na regha ghanjigomwaewa ŋgoreiya regha iya valɨkaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Amba Jeikob i dage weŋgiya le ŋgaŋga iŋa, “Mbaŋa ne ya garalawa na ya wa weŋgiya lo bodaboda kaerova thiya mare, tembene vohu bekuŋgova ŋgora bwebwe na oramae thɨ ghenawe. Ina e maŋgavarɨ, Eipron, iye rara Het le valɨvaŋga, ");
INSERT INTO tgo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ina Makpela, Memri e boimaniyeko, Kenan e tɨne. Eibraham va i vamodo maŋgavarɨko iyako weya Eipron na le ghabubu. ");
INSERT INTO tgo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Va thɨ bekuŋgiya Eibraham na levo Sera, Aisake na levo Rebeka, na vambe ya bekuva Leya iya e valɨvaŋgako iyako. ");
INSERT INTO tgo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Thelauko iyako na maŋgavarɨko, va thɨ vamodo weya rara Het. Ne vohu bekuŋgowe.” ");
INSERT INTO tgo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Mbaŋa Jeikob i giyavao le ŋgaŋgako ghanjimbaro, kaero i ghenava na e mbaŋako iyako i liya le waŋga. ");
INSERT INTO tgo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Mbaŋa Jeikob i mare Josep i ghenevala ramae e ghare vwatae na i randa na i vandamo ramae. ");
INSERT INTO tgo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","I dage weŋgiya kaka riwae gharavivatha thɨ varuvwa kaka e bunama iya valɨkaiwae i vakatha na thava i vwatha mbaŋa molao. ");
INSERT INTO tgo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Iya vakathako iyako va i wo mbaŋaevarɨ (40), mbe ghambaŋa le molamolao vara. Ijipt gharɨgharɨniye thɨ nuwatharɨ voreŋa mbaŋaepirɨ (70). ");
INSERT INTO tgo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mbaŋa nuwatharɨko ghambaŋa iko, Josep i dage weŋgiya Pero le rakakaiwo laghɨlaghɨye iŋa, “Ago laghɨye e ghemi, thoŋgo hu warariŋa lo renuwaŋake, vohu dage weya Pero kaiwaŋgu huŋa, ");
INSERT INTO tgo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Amba muyai Jeikob i mare, iŋa na Josep i dagerawe e marae na mbaŋa ramae ne i mare tembene i wova riwaeko na ve beku e maŋgavarɨ va i vivatharawe Kenan e tɨne. Ya vata ago laghɨye e ghemi hu vatomweŋgo ya wa va bekwa bwebwe amba ya njoghamava.’” ");
INSERT INTO tgo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pero iŋa, “U wa na vo vakatha ŋgoreiya va len dagerawenawe.” ");
INSERT INTO tgo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Josep kaero i wa na ve bekwa ramae. Pero le rakakaiwoko laghɨlaghɨyeko wolaghɨye, giyagiya moli na randeviva vavanava Ijipt e tɨne thɨ ghambugha Josep. ");
INSERT INTO tgo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Josep le ŋgoloko gharɨgharɨniyeko wolaghɨye na oghaghae vambe thɨ rakawava weinji. Ramae ghayayaoko gharɨgharɨniyeko wolaghɨye vambe thɨ rakawava. Va thɨ raka iteteŋgi mbe lenji ŋgaŋga eŋge, lenji sip, burumwaka na gout na thetheghan vavanava Gosen e tɨne. ");
INSERT INTO tgo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Waŋga momodɨ na hosɨ vambe weinjiyaŋgiva. Wabwi va laghɨye moliŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Mbaŋa thɨ raka vutha ŋgora thɨ ghatheghathe witɨkowe idae Atad, Jorɨdan valɨvaŋga i vorovoro, thiya randa na ghalɨŋanji laghɨye mbaŋa molao. Na gheko Josep mbowo i wova mbaŋa mbaŋapirɨ i nuwatharɨ ramae Jeikob kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Mbaŋa Kenan gharɨgharɨniye thɨ thuwe Ijipt gharɨgharɨniyeko thɨ nuwatharɨ Atad e tɨne, kaero thɨŋa, “Gharɨgharɨko thiyako mbema thɨ nuwatharɨ vara laghɨye moli.” Iya kaiwae valɨvaŋgako iyako thɨ rena idae Eibol Misraim (gha rumwaru Ijipt gharɨgharɨniye thɨ nuwatharɨ). ");
INSERT INTO tgo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","E kamwathɨko iyako Jeikob le ŋgaŋgako thɨ vakatha ŋgoreiya va le utuko weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kaero thɨ wo ramanji riwaeko na thɨ raka Kenan. Vethɨ beku e maŋgavarɨ regha ina Makpela, Memri valɨvaŋga i vorovoro. Thelauko iyako Eibraham va i vamodo weya Eipron, iye rara Het, na le ghabubu. ");
INSERT INTO tgo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mbaŋa Josep kaero i bekuvao ramae, kaero i njoghava Ijipt weiyaŋgiya oghaghae na gharɨgharɨko wolaghɨye iyava weiyaŋgiko ramae ghabekuko kaiwae. ");
INSERT INTO tgo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jeikob le mare e ghereiye, Josep oghaghae thɨ vatada renuwaŋa regha thɨŋa, “Ne ŋgoroŋga ra vakatha na raŋa thoŋgo Josep ne i botewoyathuinda na nuwaiya i lithɨ weinda tharɨko wolaghɨye va ra vakathakowe?” ");
INSERT INTO tgo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Iwaeŋge thɨ variye utu weya Josep thɨŋa, “Rama va i lauturawa utuutuke thiyake weime amba muyai i mare: ");
INSERT INTO tgo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Va i lautu weime, iya kaiwae wo naŋgo e ghen, thare valɨkaiwae u numoyatho lama tharɨ na vuyowoko wolaghɨye va wo vakatha e ghen. Mbaŋake u numotena rama le Loi le rakakaiwoŋgi.” Mbaŋa lenji utuutuko iyako ve vutha weya Josep, i randa. ");
INSERT INTO tgo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Amba oghaghaeko thɨ raka menawe na thɨ kururu e ghamwae na thɨŋa, “Ghime len rakakaiwobwaga.” ");
INSERT INTO tgo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ko iyemaeŋge Josep i dage weŋgi iŋa, “Tha hu mararu. Valɨkaiwaŋgu ne ya vakatha budakai iya, mbe Loi eŋge valɨkaiwae i vakatha. ");
INSERT INTO tgo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Lemi renuwaŋa va huŋa hu vakatha vatharɨ e ghino. Ko iyemaeŋge Loi i vɨvɨ e thovuye, na i vamboromboro budakaiya noroke i yomara. I vamoruŋgiya gharɨgharɨ lemoyo. ");
INSERT INTO tgo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Iya kaiwae tha weiye lemi gharelaghɨlaghɨ. Ghino ne ya njimbukikiŋga na lemi ŋgaŋgana tembe ŋgoreiyeva.” Kaero i vagharematuwoŋgi na e ghalɨŋae udauda i utu weŋgi. ");
INSERT INTO tgo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Josep va le yakuyaku Ijipt e tɨne weiyaŋgiya ramae ghayayaoko gharɨgharɨniye mbaŋa molao. Ghatheghathegha kaero i wo hothaŋarɨ na hoyaworo (110) amba i mare. ");
INSERT INTO tgo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josep va i thuweŋgiya Ipɨreim le ŋgaŋga na lenji ŋgaŋgava. Na tembe i thuweŋgiva Maki, Manase nariye, le ŋgaŋga thɨ tabo amalaghɨniye le bodaboda gamagainiye. ");
INSERT INTO tgo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Josep i dage weŋgiya oghaghaeko iŋa, “Wo mbaŋa mare maiya vara. Ko iyemaeŋge Loi mbene i njimbukikiŋga vara. Amalaghɨniye ne i vaŋguraŋgiyaŋga e valɨvaŋgake iyake na hu raka njogha e valɨvaŋga va i dagerawe weŋgiya Eibraham, Aisake na Jeikob.” ");
INSERT INTO tgo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Amba Josep i vakathaŋgiya oghaghae, Isirel le ŋgaŋga, na thɨ tholo. Iŋa, “Hu dagerawe e ghino, mbaŋa Loi ne i vaŋguraŋgiyaŋga na hu raka njogha e valɨvaŋgako iyako, ne hu bigiya wakɨwakɨniŋguke.” ");
INSERT INTO tgo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josep i mare Ijipt e tɨne na ghatheghathegha hothaŋarɨ na hoyaworo (110). Kaka riwae gharavivatha thɨ vivatha riwae beku kaiwae na thɨ woruwo kakako riwae e bogis tɨne gheko. ");
INSERT INTO tgo_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Mosese, Giya Loi le rakakaiwo, vama i mare na e ghereiye, amba Giya Loi i dagewe Josuwa, Nan nariye na Mosese va gharathalavu, iŋa, ");
INSERT INTO tgo_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Lo rakakaiwo Mosese kaero i mare. E mbaŋake iyake u vivatha weiniyaŋgi Isirel gharɨgharɨniyena wolaghɨye, hu raka lawa Walaghɨta Jorɨdan, na hu raka e thivathiva regha, mbaŋa nasiye amba ne ya wogiya weŋga. ");
INSERT INTO tgo_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","The valɨvaŋga ne vohu vurɨghathɨ e gheghemina kaero ya vatomwe e ghemi, ŋgoreiye va ya dagerawe Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Valɨvaŋgana wolaghɨye ne ya wogiya weŋga, iri e vuruvuru vwatavwata e yaghalako, i ruwoko e ghaiwabuniyeko ve wo Lebenon ououniye. Lemi valɨvaŋga ne ve wo Walaghɨta Iupreitis e boimako. I wo Hiti lenji valɨvaŋgako laghɨye na i njaoko e yalasiniyeko ve njogha Njighɨ Meditareiniyan ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Ma lolo regha ne i kivwalaŋge mbaŋa ambane e yawayawalin. Ne ya thalavuŋge ŋgora va ya thalavu Mosese, mane ya roiteteŋge, mbene weiŋgu vara ghen mbaŋake wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","U vurɨgheghe na u gharematuwo, kaiwae ghen iya ne u vaŋguŋgi gharɨgharɨke thiyake na vohu yaku e thivathivako iya va ya dagera weŋgi orumburumbumi. ");
INSERT INTO tgo_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","“Mbema u vurɨgheghe eŋge na gharenɨna i matuwo. U njimbukikiŋge na mbarona iya lo rakakaiwo Mosese va i wogiyana e ghen, u ghambu. Thava u goriwoyathu mbaro nasiye regha, mbala the bigithan u vakatha ne valɨkaiwan moli. ");
INSERT INTO tgo_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","U renuwaŋakiki na u vaona valaŋa Mbaro gha Buk. Gougou na ghararaghɨye u rerenuwaŋa kaiwae, mbala u vakatha wagiyawe bigibigike wolaghɨye va thɨ rorinjoŋaŋgi e tɨne. Mbala budakai u vakatha ne valɨkaiwan moli. ");
INSERT INTO tgo_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Kaero ma utuŋa e ghen. Mbema u vurɨgheghe eŋge na gharenɨna i matuwo. Thava u mararu na u gharelaghɨlaghɨ, kaiwae the valɨvaŋga ne u reŋawe, ghino Giya Loi len Loi mbene weiŋgu vara ghen.” ");
INSERT INTO tgo_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Josuwa i dage weŋgi gharɨgharɨko lenji randevivaŋgi, iŋa, ");
INSERT INTO tgo_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Hu raka weŋgi gharɨgharɨko e lenji kiyamu, na vohu giya yanawanji huŋa, ‘Hu vivathaŋa lemi bigibigi na ghami, kaiwae ma mbaŋa mbaŋato eŋge inawe, amba ra rakalawa Walaghɨta Jorɨdan na vara wo thivathivako iya Giya Loi la Loi ne i wogiya weinda na ghambanda.’” ");
INSERT INTO tgo_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Josuwa mbowo i dage weŋgiva uu Rubin, uu Gad na uu Manase vaŋgothiye, iŋa, ");
INSERT INTO tgo_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Hu renuwaŋakiki Giya Loi le rakakaiwo Mosese va le utuutu e ghemi, iŋa, ‘Giya Loi lemi Loi kaero i wogiya thelauke iyake e ghemi na valɨvaŋgake iyake ghambami.’ ");
INSERT INTO tgo_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Wo hu iteteŋgi lemi ovo, lemi ŋgaŋga na lemi thetheghan burumwaka, sip na gout gheke. Wo thɨ reyaku e thivathivake iya Mosese va i wogiyake e ghemi, Jorɨdan valɨvaŋga i vorovoro. Ko iyemaeŋge lemi ragagaithɨna wolaghɨye weinji lenji gaithɨna bigibiginiye wolaghɨye e nɨmanji, thɨ raka viva lenji valɨ Isirel e ghamwanji na vethɨ raka lawa Jorɨdan. Wo hu thalavuime, oghaghamike ghime, ");
INSERT INTO tgo_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ghaghadɨ Giya Loi ne i wogiya thivathiva weŋgi na vethɨ towowe, ŋgora va i vakatha e ghemi. Na ghaghadɨ thiye tembene vethɨ wova lenji thelau, Giya Loi lemi Loi ne i wogiya weŋgi. Iyako e ghereiye amba hu rakanjogha na vohu yakuŋa lemi thelau, iyava Giya Loi le rakakaiwo Mosese i wogiya weŋga, Jorɨdan valɨvaŋga e boimako ŋgora varaeko le ghamba yovoro.” ");
INSERT INTO tgo_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Amba thɨ gonjoghawe Josuwa, thɨŋa, “Budakai u utugiya weime ne wo vakatha ŋgoreiye. Na the valɨvaŋga u variyeimewe ne wo rakawe. ");
INSERT INTO tgo_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Ŋgora va wo ghambu Mosese ghalɨŋae, tembene wo ghambuŋgeva, thoŋgo Giya Loi len Loi weiye ghen ŋgora va weiye Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Thela thoŋgo i wovanjovanjoŋge na ma i ghambu ghalɨŋan ne wo tagavamare. Mbema u vurɨgheghe eŋge na gharenɨna i matuwo.” ");
INSERT INTO tgo_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Ghemba Sitim e tɨne, Josuwa, Nan nariye, i variye thuwoleŋgiya rakelakela theghewo, iŋa, “Hu wa na vohu ghaelawa Walaghɨtae Jorɨdan na vohu kelaŋa Kenan thivathivaniye, iyavara ghembana Jeriko.” Amba gharɨgharɨma theghewo vethɨ ghaelawa Jorɨdan na vethɨ ru Jeriko. Thɨ ru wevo rayathiyathima eunda, idae Reihab ele ŋgolo na thɨ ghenawe gougouko iyako. ");
INSERT INTO tgo_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Gharɨgharɨ vavana thɨ giya Jeriko lenji kiŋ yanawae, thɨŋa, “Me gougou Isirel gharɨgharɨniye vavana thɨ mena thɨ kela e ghembake tɨne.” ");
INSERT INTO tgo_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Kaero kiŋɨko i variyeŋgiya le ravarivariye weya Reihab, iŋa, “U vaŋguraŋgiyaŋgiya gharɨgharɨna menda thɨ ru e len ŋgolona tɨne, kaiwae thɨ mena thɨ kelaŋa ghembake laghɨye tɨne.” ");
INSERT INTO tgo_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","6","Amba muyai kiŋɨko le ravarivariye vethɨ vutha weya Reihab, mbe kaero me vaŋguvoreŋaŋgiya rakelakelama e ŋgoloko gha bwana yavoro moli na i vaŋguthuwoleŋgi e nana pɨlaks wakɨwakɨye raberabe. Iwaeŋge Reihab i dage weŋgiya ravarivariyeko, iŋa, “Emunjoru, gharɨgharɨna menda thɨ mena elo ŋgoloke, ko iyemaeŋge ma ya ghareghare aŋga menda thɨ mena. Menda ŋgora thela i ghaona kaero vethɨ raŋgi; ghamba ruko ghambaŋa vara thɨ kighɨ. Ma ya ghareghare aŋga menda thɨ reŋa. Ma hu vamayaŋa eŋge hu reghamba weŋgi. Mbwata ne valɨkaiwami hu la vuthavaidiŋgi.” ");
INSERT INTO tgo_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Kaero kiŋɨko le ravarivariye vethɨ raka raŋgi na e ghereinji amba thɨ ki ghamba ruko. Thɨ raka reghamba weŋgiya rakelakelama na vethɨ ghad vara e ghamba ghaeghaelawa Jorɨdan. ");
INSERT INTO tgo_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Amba muyai rakelakelama thɨ ghena, Reihab i wa ve voro weŋgi e ŋgoloko vwatae, ");
INSERT INTO tgo_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","na i dage weŋgi iŋa, “Ya ghareghare Loi kaero i giya valɨvaŋgake iyake weŋga, na gharɨgharɨke wolaghɨye ghime e ghembake iyake tɨne wo mararu laghɨye moli kaiwami. ");
INSERT INTO tgo_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Wo loŋwa utunimi mbaŋa va hu raka raŋgi Ijipt e tɨne na Giya i tagaviya Njighɨ Sosoro na i meme e ghamwami na hu raka lawawe. Na tembe wo loŋweva Amori lenji kiŋ theghewo Saihon na Og, weinjiyaŋgiya lenji gharɨgharɨ hu mukuwoŋgi Jorɨdan e boimaniyeko. ");
INSERT INTO tgo_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Mbaŋa wo loŋwa utunimi woya mararu laghɨye moli na lama vurɨghegheke wolaghɨye iko, kaiwae wo ghareghare Giya lemi Loi iye buruburu yavoroke na yambane ghanji Loi. ");
INSERT INTO tgo_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","E mbaŋake vara iyake hu tholo Giya e idae, na mbaŋa ne hu wo Jeriko, ne hu mwaewo weŋgiya lo bodabodake ŋgoreiya ghino ya mwaewo weŋga. ");
INSERT INTO tgo_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Wo hu utugiyama nono regha na ya ghareghare emunjoru weiŋguyaŋgiya bwebwe na nava, olouŋguko na oghaghaŋguko, weinjiyaŋgiya lenji ŋgaŋga mane hu mukuwoime, ko iyemaeŋge ne hu vamoruime mare e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Rakelakelako thɨ gonjoghawe thɨŋa, “Yawalimina ne modaya yawalɨmeke, thoŋgo mane wo vamboromboro lama dagera weŋge. Thoŋgo mane u giya lolo regha yanawae budakaiya wo vakavakathake, mbaŋa Giya Loi ne i wogiya valɨvaŋgake iyake weime ne wo mwaewo weŋga na wo vamoruŋga.” ");
INSERT INTO tgo_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Amba i vakuki njoŋaŋgiya ghewoko e thiyo, e dedele regha, kaiwae ŋgoloko va thɨ vatadɨ vatabo weiye ghembako gha gana. ");
INSERT INTO tgo_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Elako i dage weŋgi iŋa, “Hu wao e ououko rɨghenji, na thava kiŋɨko le ratamwetamwe thɨ vaidiŋga. Mbowo vohu kubaro gheko mbaŋa thegheto, ghaghad ghamiratamwetamweko thɨ raka njogha amba vohu raka reŋa e lemi kamwathɨko.” ");
INSERT INTO tgo_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Kaero ghɨmoghɨmoruko thɨ dage weya Reihab thɨŋa, “Ghime weime, dagerake iya moŋa na wo vakathake e ghen mane ŋgarɨime, mbene ghen vara u vakowana mbaroke iyake. ");
INSERT INTO tgo_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Mbaŋa ne wo ru e lemi valɨvaŋgake, u ŋgara thiyona sosoro iya mwo liveŋgena e dedeleke iya mo vakukinjoŋaimewe, na u vaŋguruwoŋgiya rama na tɨna, olou na len bodabodana wolaghɨye e len ŋgolona tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Thela thoŋgo i raŋgi e len ŋgolona tɨne na i mare, tembe ghamberegha i vaidiya le tharɨko modae, ghawonjowe mane i mena weime. Ko thoŋgo regha e len ŋgolona tɨne i vaidiya vuyowo, modae ghime ne wo vaidi. ");
INSERT INTO tgo_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Thoŋgo u utuutu menda wo mena budakai kaiwae, mane wo vamboromboro lama dagera e ghen.” ");
INSERT INTO tgo_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Reihab iŋa, “Kaero ŋgoreiye mohuŋana.” I variye yathuŋgi na elaghɨniye i liya thiyoma sosoro na i ŋgarɨ e dedeleko. ");
INSERT INTO tgo_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Mbaŋa thɨ wareri, thɨ wa e ououko rɨghenji na vethɨ yakuwe mbaŋa mbaŋato. Ratamwetamwema thɨ tamwe takwa valɨvaŋgako wolaghɨye na thɨ raka njogha ma thɨ ndevaidiŋgi mun. ");
INSERT INTO tgo_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Amba rakelakelama theghewo thɨ njama e bobokuluko, thɨ lawa Jorɨdan na thɨ njogha weya Josuwa. Thɨ utugiyawe bigibigiko wolaghɨye va thɨ yomarako weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Thɨ dage weya Josuwa thɨŋa, “Emunjoru Giya kaero i wogiya weinda ghembako laghɨye. Gharɨgharɨko wolaghɨye thɨ mararu laghɨye kaiwanda.” ");
INSERT INTO tgo_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Vambe mbaŋambaŋa, Josuwa na Isirel gharɨgharɨniyeko wolaghɨye thɨ raka iteta Sitim na thɨ raka e walaghɨta Jorɨdan ghadidiye. Mbowo thiya yaku eŋge gheko, thɨ roroghagha lenji rakalawa kaiwae. ");
INSERT INTO tgo_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Mbaŋa mbaŋato e ghereiye randevivako thɨ vaghɨliya kiyamuko laghɨye, ");
INSERT INTO tgo_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","na thɨ dage weŋgiya gharɨgharɨko, thɨŋa, “Mbaŋa ne hu thuwe ravowovowo thɨ thɨna Giya la Loi le Dagerawe gha Bogis, amba hu raka itete lemi kiyamuna, na hu raka reghamba weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Thiye ne thɨ viva weŋga kaiwae ma mbaŋa regha va hu rakaraka mena e valɨvaŋgake iyake. Ne hu ndevurɨthai Dagerake gha Bogis ghadidiye. Mbe e ghami lughawoghawo ŋgoreiye kilo mita regha.” ");
INSERT INTO tgo_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Josuwa i dage weŋgi gharɨgharɨko iŋa, “Hu vaboboma ghamimberegha, kaiwae evole Giya ne i vakathaŋgi vakatha amba rotaele vavana e tɨnendake.” ");
INSERT INTO tgo_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Amba Josuwa i dage weŋgi ravowovowoko iŋa, “Hu wora Dagerana gha Bogis e ŋgɨleŋgɨlemi na hu viva gharɨgharɨna e ghamwanji.” Kaero thɨ vakatha ŋgoreiye Josuwa le utu weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Giya Loi i dagewe Josuwa iŋa, “Noroke ya wora idan gha wovorovoroŋa rɨghe wabwi Isirel e maranji. Na mbala thɨ ghareghare ghino weiŋgu ghen ŋgora va weiŋgu Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","U dage weŋgi ravowovowona iya thɨ thɨna Dagerana gha Bogis, uŋa, ‘Mbaŋa ne hu vutha e Walaghɨta Jorɨdan ghadidiye, hu ghaenja na vohu ndethin e mbwako tɨne.’” ");
INSERT INTO tgo_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Kaero Josuwa i dage weŋgi Isirel gharɨgharɨniye, iŋa, “Wo hu raka mena gheke na ya utuŋa Giya la Loi ghalɨŋae na ra loŋwe. ");
INSERT INTO tgo_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Ne e kamwathɨke iyake amba hu ghareghare Loi e yawayawaliye ina weinda, na emunjoru amalaghɨniye ne i vagegeyathuŋgiya Kenan, Hiti, Hivi, Perisi, Gegasi, Amori na Jebusi gharɨgharɨniye kaiwami. ");
INSERT INTO tgo_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Wo hu thuwe, yambaneke laghɨye gha Giya le Dagerawe gha Bogis ne vethɨ wonjakai e ghamwami e Walaghɨta Jorɨdan. ");
INSERT INTO tgo_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Mbaŋake hu tuthiŋgi ghɨmoghɨmoru theyaworo na theghewo Isirel e gha uu regha na regha tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Na mbaŋaniye vara ravowovowoko ne thɨ kewe Giya Loi le Dagerako gha Bogis na vethɨ ghaenja e mbwako tɨne, ne i voru towo na i voru vavatha na regha.” ");
INSERT INTO tgo_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Mbaŋa Isirel vama thɨ raka itete kiyamuko na mathɨ raka ghembeya Jorɨdan, amba ravowovowoko thɨ kewa viva Dagerako gha Bogis, e ghamwanji. ");
INSERT INTO tgo_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Kaiwae uloulo va gha mbaŋa, uye tembe gha mbaŋava e valɨvaŋgako iyako, iya kaiwae ŋgonuŋgo va i voru e Walaghɨta Jorɨdan. Ko iyemaeŋge mbaŋa ravowovowoko va thɨ kewa Bogisɨko thɨ vurɨthai mbwako ghadidiye na thɨ vurɨutu e mbwako tɨne, ");
INSERT INTO tgo_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","mbaŋara mbwako i voru ndeghathɨ ŋgora va i voru njamakowe. Va i voru vavatha mbe bwagabwaga weŋgi e ghemba regha idae Adam, Jeretan ele valɨvaŋga, ko mbwako valɨvaŋga i raŋgiraŋgi na ve wo Njighɨ Maremareniye va i ma moli. Iyako va i vakatha gharɨgharɨko valɨkaiwanji thɨ raka lawa Jeriko ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Mbaŋa Isirel va thɨ rakarakalawa, ravowovowoko iyava thɨ kewa Giya le Dagerako gha Bogis mbe thɨ ndekikiyaŋa vara e thelau momoe Walaghɨta Jorɨdan e tɨne, ghaghad gharɨgharɨko wolaghɨye thɨ rakalawavao. ");
INSERT INTO tgo_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Mbaŋa Isirel vama thɨ rakalawavao, amba Giya i dagewe Josuwa, iŋa, ");
INSERT INTO tgo_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“U tuthiŋgiya ghɨmoghɨmoru theyaworo na theghewo, regha iya i mena e uu regha tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Na u dage weŋgi thɨ mbana varɨvarɨ varɨyaworo na varɨiwo e walaghɨtana yamoe moli, ŋgora vara ravowovowona thɨ ndeghathɨnawe. Thɨ mban na vethɨ bigirawe ŋgora vara ne vohu ghenanawe gougouke noroke.” ");
INSERT INTO tgo_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Amba Josuwa i kula vathaŋgi ghɨmoghɨmoruma theyaworo na theghewoma Isirel e tɨnenjima, regha iya uu regha e tɨne, ");
INSERT INTO tgo_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","na i dage weŋgi iŋa, “Hu raka na vohu rakanja Jorɨdan. Hu viva Giya Loi le Dagerana gha Bogis e ghamwae. Regha iya i wo varɨ regha na i wora e ŋgɨleŋgɨle, na varɨ regha iya i ndethɨ Isirel gha uu. ");
INSERT INTO tgo_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Varɨvarɨke thiyake nevole thɨ vanuwovɨrɨinda budakai Giya va i vakatha weinda. Thoŋgovole mbaŋa i menamenako na lemi ŋgaŋga thɨ vaitoŋga na thɨŋa, ‘Varɨvarɨke thiyake ŋgoroŋga ghanjirumwaru?’ ");
INSERT INTO tgo_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Kaero huŋa, ‘Va e mbaŋako iyako walaghɨta Jorɨdan i meme mbaŋa thɨ thɨnɨlawa Giya Loi le Dagera gha Bogis gheke.’ Varɨvarɨke thiyake ne i vavanuwovɨrɨŋgiya gharɨgharɨ Isirel tha na tha budakai va i yomara gheke.” ");
INSERT INTO tgo_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Ghɨmoghɨmoruko thɨ vamboromboro Josuwa le renuwaŋako ŋgoreiya Giya va i dage weya Josuwa. Va thɨ mbana varɨvarɨ varɨyaworo na varɨiwo e walaghɨta Jorɨdan yamoe moli, ŋgora uu Isirel lenji ghanaghanagha. Thɨ mban na vethɨ bigira ŋgora vara lenji kiyamuko inawe. ");
INSERT INTO tgo_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Josuwa vambe i bigirava varɨvarɨ varɨyaworo na varɨiwo e walaghɨtako yamoe, ŋgora vara ravowovowo va thɨ ndeghathɨwe na thɨ ndethɨna Dageraweko gha Bogis. (Varɨvarɨke thiyake mbe inanjiwe e mbaŋake iyake.) ");
INSERT INTO tgo_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Ravowovowoko vambe thɨ ndethin vara bogisɨko e walaghɨtako yamoe moli ghaghadɨ thɨ vakathavao bigibigiko wolaghɨye Giya Loi va i dage weya Josuwa na i dage weŋgiya gharɨgharɨko thɨ vakatha. Utuutuke wolaghɨye thiyake Mosese va i utugiya weya Josuwa. Gharɨgharɨko va thɨ vamayaŋa thɨ raka lawa e walaghɨtako. ");
INSERT INTO tgo_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Mbaŋa gharɨgharɨko wolaghɨye vama inanji valɨmbwa, na e maranji amba ravowovowoko thɨ thɨna Dagerako gha Bogis na thɨ viva gharɨgharɨko e ghamwanji. ");
INSERT INTO tgo_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Ghɨmoghɨmoru va inanji Rubin na Gad e ghanji uu tɨnenji na Manase gha uu vaŋgothiye tɨne, thɨ vivatha gaithɨ kaiwae na thɨ viva gharɨgharɨko wolaghɨye e ghamwanji, ŋgora Mosese va le utuutu weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Va lenji ghanaghanagha poti tausan (40,000) iyava thɨ raka lawa weinji Giya Loi na vethɨ raka vutha Jeriko malamoniye gaithɨ kaiwae. ");
INSERT INTO tgo_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","E mbaŋako iyako Giya Loi i vamidi Josuwa Isirel taulaghɨko e maranji, na thɨ yavwatatawana yawaliyeko gha mbaŋa wolaghɨye ŋgoreiya va thɨ yavwatatawana Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Amba Loi i dage weya Josuwa iŋa, ");
INSERT INTO tgo_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“U dage weŋgiya ravowovowona iya thɨ thɨna Dagerana gha Bogis, thɨ raka iteta Jorɨdan na thɨ voroma e malavwatake.” ");
INSERT INTO tgo_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Josuwa i vakatha ŋgoreiye, ");
INSERT INTO tgo_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","na mbaŋa ravowovowoko kaero inanji e malavwatako, amba mbwako i thothova, i voru na tembe ve vanatɨva vaŋga na vaŋga. ");
INSERT INTO tgo_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Theghathegha gha manjala i viva moli gha mbaŋa mbaŋayaworo e tɨne, gharɨgharɨko kaero thɨ raka lawa Jorɨdan na vethiya kiyamu e ghemba regha idae Gilgal ghadidiye, ina Jeriko e boimaniyeko. ");
INSERT INTO tgo_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Varɨvarɨma varɨyaworo na varɨiwo me thɨ mbanɨma e walaghɨta Jorɨdan tɨne, Josuwa i wabwi vatha e ghembako iyako. ");
INSERT INTO tgo_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Kaero Josuwa i dage weŋgiya Isirel gharɨgharɨniyeko iŋa, “Lemi ŋgaŋga mbaŋa muyaiko nevole thɨ vaitoŋga na thɨŋa, ‘Varɨvarɨke thiyake ŋgoroŋga ghanjirumwaru?’ ");
INSERT INTO tgo_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","hu dage weŋgi huŋa, ‘Varɨvarɨke thiyake thɨ vanuwovɨrɨinda va e mbaŋako iyako walaghɨta Jorɨdan i meme na ghime wo raka lawa e thelau momoe.’ ");
INSERT INTO tgo_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Ne hu utu ŋgora iyake, kaiwae Giya la Loi va i vakatha walaghɨta Jorɨdan i meme kaiwame na wo raka lawa, tembe ŋgoreiyeva va i vakatha Njighɨ Sosoro i meme na wo raka lawawe. ");
INSERT INTO tgo_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Va i vakatha ŋgora iyako mbala gharɨgharɨke wolaghɨye e yambaneke thɨ ghareghare Giya iye Ravurɨgheghe, na ghemi hu yavwatatawana Giya la Loi mbaŋake wolaghɨye.” ");
INSERT INTO tgo_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Mbaŋa Amori lenji kiŋɨŋgi, Jorɨdan e yalasiniyeko na Kenan lenji kiŋɨŋgi e Njighɨ Meditareiniyan ghadidiye, thɨ loŋwe toto, Giya Loi va i vakatha Jorɨdan i meme ghaghad Isirel gharɨgharɨniyeko wolaghɨye va thɨ raka lawavao valɨmbwa, i vakathaŋgi thɨ mararu na thɨ gharelaghɨlaghɨ laghɨye moli, ma tembe valɨkaiwanjiva thɨ gaithɨ weinjiyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Giya i dagewe Josuwa iŋa, “Hu piriya niboka na hu tena Isirel ghɨmoghɨmoruna riwanji mbothiye njimwae.” (Iyako va lenji vakatha mbaŋaiwoniye.) ");
INSERT INTO tgo_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Kaero Josuwa i vakatha ŋgoreiye Giya Loi me dagewe na thɨ tenɨŋgi Isirel ghɨmoghɨmoruko wolaghɨye riwanji mbothiye njimwa. Na thɨ rena ghembako iyako idae Njimwa Ghambaten. ");
INSERT INTO tgo_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","6","Mbaŋa Isirel va thɨ raka itete Ijipt, ghɨmoghɨmoruko wolaghɨye vama thɨ wo kitenɨyathu thanavuniye. Ko iyemaeŋge, va lenji loŋga e njamɨnjamɨbwaga na gamagainiye mava thɨ wo mun kitenɨyathu thanavuniye. Tembe ŋgoreiyeva, ghɨmoghɨmoruko iyava thɨ raka raŋgiko Ijipt, na ghanji theghatheghako vama valɨkaiwae gaithɨ, va thiya marevao, kaiwae mava thɨ ghambugha Giya Loi le mbaro. Loi va i lithɨ weŋgi ŋgora va le tholoko, thiye mane vethɨ vaidi thivathivako iya bigithaŋarɨke veimaima na ndendewo, iya Loi va i dagerako weŋgi orumburumbunji. ");
INSERT INTO tgo_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Josuwa va i la vakatha kitenɨyathu thanavuniye weŋgi thako togha Gilgal e tɨne, kaiwae oramanji mava thɨ loŋweghathɨ Giya Loi na thɨ vakatha kitenɨyathu thanavuniye weŋgi mbaŋa va e lenji loŋga tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Mbaŋa ghɨmoghɨmoruko wolaghɨye vama thɨ wo kitenɨyathu, taulaghɨko mbowo thiya yaku e lenji kiyamuko ghaghad ghanji tenɨtoko i moi. ");
INSERT INTO tgo_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Giya Loi i dagewe Josuwa, iŋa, “Noroke kaero ya tagayathu lemi mebwabwari na rakakaiwobwaga monjinaniye Ijipt va thɨ vakatha weŋga.” Iya kaiwae, thɨ rena ghembako idae Gilgal. Idako iyako mbe inawe noroke. ");
INSERT INTO tgo_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Mbaŋa Isirel vamba inanji Gilgal, Jeriko malamoniye e tɨne, kaero thɨ vakatha Thaga Valaŋani gha renuwaŋakiki, manjala gha mbaŋa mbaŋayaworo na mbaŋavarɨ yeghɨyeghɨyeniye. ");
INSERT INTO tgo_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Thaga Valaŋani vakathaniye e ghereiye na mbaŋambaŋava, kaero thɨ raka vethɨ vugha bali uneune e umauma tɨnenji Kenan tɨne. Thɨ kaghaege vavana, vavana thɨ voŋgoŋgo na thɨ vakatha bred ma weiye isɨt. Va e mbaŋako iyako thɨ ghanɨkai vara Kenan ghanɨŋganiye. ");
INSERT INTO tgo_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Mbaŋaniye vara thɨ ghana Kenan ghanɨŋganiye, Giya Loi i vatowaŋa mana iri e buruburu. Isirel gharɨgharɨniye ma tembe thɨ ndevaidiva mun. E mbaŋako iyako na iwa e ghamwanjiko thɨ ghana ghanɨŋga thɨ kabu Kenan e thivathivaniye. ");
INSERT INTO tgo_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Mbaŋa regha Josuwa va ina Jeriko ghadidiye na mbaŋa i tagathɨna marae kaero i thuwe ghɨmoru regha i ndendeghathɨ e ghamwae. Le gaithɨ gha ghalɨthɨ vama i mwanagita e ghambae na i ndewo e nɨmae. Josuwa i ndetha e ghadɨdɨye na i vaito iŋa, “Ghen ghama rathalavu regha e gaithɨke o ghama thɨghɨya?” ");
INSERT INTO tgo_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Amalako iŋa, “Nandere, ghino ma ragagaithɨ regha o ghami thɨghɨya, ko iyemaeŋge ghino Giya Loi le ragagaithɨ lenji randeviva. Iya kaiwae ma menake.” Josuwa weiye le yavwatata i wovakururuwo ghamwae i nja e thelauko vwatae na i kururuwe, iŋa, “Amalana, ghino len rakakaiwo. Nuwaniya ya vakatha budakai?” ");
INSERT INTO tgo_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Kaero Giya Loi le ragagaithɨma lenji randeviva i dagewe Josuwa iŋa, “U bigi raŋgiya gheghenɨna ghae, kaiwae thelauna iya u ndendeghathɨnawe i boboma.” Josuwa i vakatha ŋgoreiya va i dagekowe. ");
INSERT INTO tgo_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Jeriko iye ghemba laghɨye na va thɨ gana vaghɨliya. Gha thɨnɨmbaŋgiko wolaghɨye va thɨ ki vaoŋgi na mbe e ghanji ragatɨgatɨ na thava Isirel thɨ raka ru. Na tembe thɨ dage tenɨva thava tembe lolo regha i ruva o i raŋgi e ghembako tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Amba Giya Loi i dage weya Josuwa iŋa, “Wo u thuwe, kaero ya worawa Jeriko e nɨmanɨna ghare, weiye gha kiŋɨko na ragagaithɨ vurɨvurɨghegheniyeko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Mbaŋa regha na regha, ghen na len ragagaithɨna wolaghɨye ne hu loŋga vaghɨliya Jeriko, mbaŋara iya mbaŋa theghewona e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Mbaŋa ghepirɨniye e tɨne, ravowovowo theghepirɨ ne thɨ mbana ghanji mema vwarapirɨ, iya sipɨna ghanji sokisoki, na thɨ ndeviva Dagerawena e gha Bogis ghamwae. Ghemi na ravowovowona ne hu loŋga vaghɨliya ghemba mbaŋapirɨ na thiye thɨ uwiuwiya memaŋgina. ");
INSERT INTO tgo_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Mbaŋa ne hu loŋwe thɨ uwiya memako molao, taulaghɨna ghemi hu yaro na ghalɨŋami laghɨye. Ne mbaŋara ganana i mavɨrɨ na ragagaithɨna wolaghɨye thɨ raka ru ŋgora regha na regha inanjiwe.” ");
INSERT INTO tgo_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Kaero Josuwa, Nan nariye i kula vathaŋgiya ravowovowoko na i dage weŋgi, iŋa, “Hu thɨna Giya Loi le Dagerako gha Bogis, na hu thɨnɨra e ŋgɨleŋgɨlemi na ghamunena theghepirɨ thɨ bigiya mema, thɨ viva Bogisɨna e ghamwae na thɨ viva e ghemi.” ");
INSERT INTO tgo_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Josuwa i dage weŋgiya gharɨgharɨko iŋa, “Ra raka na vara ndevaghɨliya Jeriko. Ragagaithɨna vavana thɨ raka viva Bogisɨko e ghamwae.” ");
INSERT INTO tgo_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Mbaŋa Josuwa i utuvao weŋgiya gharɨgharɨko kaero ravowovowoko theghepirɨ thɨ viva Giya Loi le Dagerako gha Bogis ghamwae na thɨ uwiuwiya lenji memako. ");
INSERT INTO tgo_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Ragagaithɨ vavana thɨ raka viva memako gha rauwiuwi e ghamwanji na vavana thɨ raka reghamba Bogisɨko e ghereiye. E mbaŋako iyako mema lenji randa eŋge. ");
INSERT INTO tgo_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Ko iyemaeŋge Josuwa i dage weŋgiya gharɨgharɨko, iŋa, “Ne hu ndeyaro, tha ghalɨŋami laghɨye, na ne hu ndegugwa utu regha, ghaghad ne the mbaŋa ya dage e ghemi yaŋa, hu yaro, ko amba hu yaro na ghalɨŋami laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","E mbaŋako iyako rakewakewama kaero thɨ kewa vaghɨliya ghembako, Giya Loi le Dagerawe gha Bogis e mbaŋako iyako ŋgoreiya Josuwa me le utuutu weŋgi, amba thɨ raka njogha e lenji kiyamuko na vethɨ ghenawe gougouko iyako. ");
INSERT INTO tgo_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Ighɨviya, mbe mbaŋambaŋa Josuwa i thuweiru, kaero ravowovowoko thɨ kewava Giya Loi le Dageraweko gha Bogis. ");
INSERT INTO tgo_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Ravowovowoko theghepirɨ iya thɨ uwiuwiya memako thɨ viva Bogisɨko e ghamwae na ragagaithɨ vavana thɨ loŋga viva rauwiuwi memako e ghamwanji na vavana Bogisɨko e ghereiye. E mbaŋako iyako mema mbe lenji randa eŋge. ");
INSERT INTO tgo_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Mbaŋa theghewoniyeko e tɨne tembe thɨ vaghɨliyava ghembako mbaŋara na mbowo thɨ njoghava e kiyamuko. Mbaŋa theghewona e tɨnenji va thɨ vakavakatha ŋgora iyako. ");
INSERT INTO tgo_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Mbaŋa mbaŋapirɨniye e tɨne, ighɨviya rakaraka, Isirel thɨ raka thuweiru na vethɨ raka vaghɨliya Jeriko mbaŋapirɨ. Lenji vaghɨliyako iyako ŋgoreiya va thɨ vakavakatha mbaŋawonama e tɨne, ko va e mbaŋako iyako tɨne mbaŋapirɨ vara va thɨ vaghɨliya ghembako. ");
INSERT INTO tgo_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Vaghɨliya mbaŋapirɨninji e tɨne, ravowovowo thɨ uwiya lenji memako — thɨ uwi na molao, amba Josuwa i dage weŋgiya gharɨgharɨko iŋa, “Hu yaro, kaiwae Giya Loi kaero i wogiya ghembake iyake e ghemi. ");
INSERT INTO tgo_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Ghembake na bigibigike wolaghɨye e tɨneke, gharɨgharɨniye, lenji thetheghan na lenji bigibigiko wolaghɨye ra mukuwoŋgi, kaiwae Loi le renuwaŋa ŋgoreiye. Ko iyemaeŋge Reihab — wevo rayathiyathima na le ŋgolona gha rayakuyaku wolaghɨye ne hu ndevakowanaŋgi, kaiwae va i vaŋgu thuweleŋgiya la rakelakelama. ");
INSERT INTO tgo_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Budakai Loi va iŋa ne ra mukuwo, tene hu ndewova regha, ne iwaeŋge tembe ghamimberegha hu vakatha ghami vuyowo, ko amba vuyowoko iyako i lawa ela kiyamuko na i mukuwoinda. ");
INSERT INTO tgo_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Bigibigiko wolaghɨye thɨ vakatha e silva, gol, kopa na aiyan ra bigi vakatha na ra vabobomaŋa Giya Loi kaiwae na ra bigira bigibigi e ghambanji Loi ele ŋgoloko tɨne.” ");
INSERT INTO tgo_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Mbaŋa ravowovowoko thɨ uwighathɨgha memaŋgiko na gharɨgharɨko thɨ loŋwe amba thɨ yaro na ghalɨŋanji laghɨye. E mbaŋako vara iyako Jeriko gha gana i mavɨrɨ. Ragagaithɨko wolaghɨye thɨ raka ru ŋgora vara va inanjikowe na thɨ wo ghembako. ");
INSERT INTO tgo_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Va mbema thɨ mukuwo vara ghembako. E lenji gaithɨko gha ghalithɨ thɨ gaboŋgiya ghɨmoghɨmoru, wanakau, gamagai, amalaghɨsarɨ, yalaghɨsarɨ, lenji burumwaka, sip na doŋɨki, thɨ mukuwoŋgi moli. ");
INSERT INTO tgo_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Amba Josuwa i dage weŋgiya rakelakelama theghewoma iŋa, “Hu wa Reihab ele ŋgolokona tɨne na vohu vaŋguraŋgiyaŋgi gha mbandɨmbandɨ na gharɨgharɨna wolaghɨye ele ŋgolona tɨne ŋgora va lemi dageranawe.” ");
INSERT INTO tgo_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Amba thetheghama iyava vethɨ kelaŋa Jerikoma thɨ wa na vethɨ vaŋguŋgiya Reihab weiyaŋgiya ramae na tɨnae, olouye na gha uuko gharɨgharɨniye wolaghɨye na vethɨ vaŋguraweŋgi Isirel e lenji kiyamuko ghadidiye eto. ");
INSERT INTO tgo_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Amba thɨ woŋambu ghembako laghɨye weiye bigibiginiyeko wolaghɨye. Ko iyemaeŋge bigibigi va thɨ vakathaŋgi e gol, silva, kopa, brons na aiyan, thɨ bigi na vethɨ bigiraweŋgi e ghambanji Giya Loi ele ŋgolo tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Ko iyemaeŋge Josuwa i vamora Reihab na le bodabodako wolaghɨye, kaiwae va i vaŋgu thuweleŋgiya ghɨmoghɨmoruma iyava vethɨ kelama Jeriko. Reihab orumburumbuye mbe inanji wabwi Isirel e tɨnenji noroke. ");
INSERT INTO tgo_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","E mbaŋako iyako Josuwa i tholo na iŋa, “Thela nevole i mando na i vatadɨ vaira Jeriko, Giya Loi nevole i gura. Thela thoŋgo i mando na i wora ganako rɨghe gha mbaghɨmbaghɨ, nariye gamau nevole i mare. Thela thoŋgo i vatada ghamba ruruko, nariye virɨ reghamba nevole i mare.” ");
INSERT INTO tgo_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Giya Loi vambe weiye vara Josuwa, i vakatha utuniye i lalu Kenani laghɨyeko e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Giya Loi le mbaro Isirel kaiwanji mbaŋa va thɨ mena thɨ mukuwo Jeriko mava thɨ ghambu. E tɨnenjiko amala regha idae Eikan iyava i kivwala mbaroko iyako, iwaeŋge Giya Loi le ghatemuru laghɨye i yomara weŋgiya Isirel. Eikan iye Kami nariye na Jabdi rumbuye. Jabdi i mena Jera e gha uu tɨne, na iye Juda le wabwi loloniye regha. ");
INSERT INTO tgo_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Josuwa i variyeŋgiya ghɨmoghɨmoru vavana thɨ ri Jeriko na thɨ wa Ai. Ghembake iyake ina Betel boimaniyeko, ghemba reghava idae Bet Aven ghadidiye. Josuwa i dage weŋgi, iŋa, “Hu wa na vohu kelaŋa ŋgoroŋga thelauna gha ghawo.” Mbaŋa vama vethɨ vakathavao iyako, ");
INSERT INTO tgo_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","thɨ njogha na thɨ utu giya weya Josuwa, thɨŋa, “Ma ghemba laghɨye ŋgoreiye. Ma valɨkaiwae taulaghɨke ghinda vara gaithɨwe. Mbema u variyeŋgi eŋge tu o tɨri tausan ghɨmoghɨmoru na vethɨ gaithɨwe.” ");
INSERT INTO tgo_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Iya kaiwae mbe tɨri tausan eŋge thɨ raka na vethɨ gaithɨ Ai, ko iyemaeŋge gharɨgharɨ Ai e tɨne thɨ kivwalaŋgi na thɨ raka vo njogha e ghereinji. ");
INSERT INTO tgo_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Ghɨmoghɨmoru Ai e tɨne thɨ vagegeŋgi e ghembako gha ghamba ruru, na thɨ raka njoŋa yamwa varɨvarɨye na thɨ gaboŋgiya Isirel ragagaithɨ theto na theghewona. E mbaŋako iyako Isirel ragagaithɨko ma e lenji vurɨgheghe na thɨ vo weinji lenji mararu. ");
INSERT INTO tgo_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Amba Josuwa i mwana thethe gha kwama na i dipoumu e thelauko vwatae ŋgora Giya Loi le Dageraweko gha Bogis ghadidiye, na mbe ŋgora vara iyako ghaghad yeghɨyeghɨye. Isirel giyagiyaniye vambe thɨ vakathava ŋgoreiye na thɨ mbanɨyatha vugha e umbalɨnji. Lenji vakathako va i woraŋgiya lenji nuwatharɨko. ");
INSERT INTO tgo_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Kaero Josuwa iŋa, “Oo, Giya Loi vurɨvurɨghegheniye! Buda kaiwae vara na menda u vaŋgu valawaime Jorɨdan valɨmbwake? Menda u vakatha iyako na u vaŋgu giyaime weŋgiya Amori gharɨgharɨniye na thɨ mukuwoime? Oo, Thoŋgo mbema menda wo ya yaku eŋge Jorɨdan valɨmbwa i lawalawaoko! ");
INSERT INTO tgo_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","O Giya Loi, ŋgoroŋga ne yaŋa? Lama ragagaithɨke kaero menda thɨ rakavo weŋgiya ghama rathɨghɨyako. ");
INSERT INTO tgo_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Kenan gharɨgharɨniye na vanautumake iyake gharɨgharɨniye wolaghɨye ne thɨ loŋwa iyake utuniye, amba thɨ raka mena thɨ gabovaoime. Ne u vakatha budakai na idan mbe i laghɨlaghɨye vara?” ");
INSERT INTO tgo_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Giya Loi i dage weya Josuwa iŋa, “U yondo virɨ! U vakatha budakai iya u dipoumu e thelauna vwatae? ");
INSERT INTO tgo_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Isirel menda thɨ vakatha tharɨ. Mava thɨ ghambugha lo mbaro va ya dage weŋgi Jeriko kaiwae, yaŋa mbaŋa ne hu ru Jeriko e tɨne, hu mukuwo bigibigiko wolaghɨye, ko iyemaeŋge mendava thɨ mbana vavana. Mendava thɨ kwan na thɨ mbanɨŋgiya bigibigike thiyake vavana na thɨ thuwoleŋgi e lenji bigibigiko tɨnetɨnenji. ");
INSERT INTO tgo_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Isirel tembe ghanjimberegha menda thɨ vakatha ghanjivuyowo, iya kaiwae ma valɨkaiwanji menda thɨ ndeghathɨ vurɨgheghe na thɨ gaithɨ njogha weŋgiya ghanji rathɨghɨyako, mbema thɨ raka vo eŋge. Ma tembene ya thalavuŋgava ghaghad ne hu mukuwo bigibigina wolaghɨye iya va ya dagetenɨna e ghemi, ko iyemaeŋge menda hu mbanɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“U wa vo dage weŋgiya gharɨgharɨna thɨ vanamwe riwanji ghanjimberegha na thɨ vivatha thɨ raka mena e ghino evole mbaŋambaŋa. Vo dage weŋgi ghino, Giya Loi Isirel lenji Loi, yaŋa, ‘Isirel gharɨgharɨniye, va ya dage e ghemi na hu mukuwo bigibigiko wolaghɨye Jeriko e tɨne. Ko iyemaeŋge hu mbanɨŋgiya bigibigiko thiyako vavana, iyava yaŋake hu mukuwoŋgi. Hu bigiyathuŋgi ambane valɨkaiwami hu ndeghathɨ vurɨgheghe na hu kivwalaŋgiya ghami thɨghɨyako.’ ");
INSERT INTO tgo_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","U dage weŋgi na evole mbaŋambaŋa ne thɨ rakamena e (Dageraweko gha Bogis) ghadidiye e wabwi regha na regha. The wabwi ne (ya tuthi) Giya Loi i tuthi, uu na uu thɨ raka raŋgi e wabwiko tɨne, the uu Giya Loi i tuthi amaamala na lenji ŋgaŋga/gha yayaoko gharɨgharɨniye ne thɨ raka raŋgi e uuko tɨne; the amala Giya Loi ne i tuthi amaamalako na lenji ŋgaŋga/ghanjiyayao gharɨgharɨniye e tɨnenji ne i raŋgi ");
INSERT INTO tgo_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","amalana iyana kaero i (thɨ) vaidi mukuwoko bigibiginiye vavana inawe ne i mare, weiyaŋgiya le ŋgaŋga/gha yayaoko bigibiginiyeko wolaghɨye, kaiwae kaero i womena monjina laghɨye Isirel weŋgi na i raka lo mbaro.” ");
INSERT INTO tgo_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","I ghɨviyava, vambe mbaŋambaŋa moli Josuwa kaero i kula vathaŋgiya Isirel thɨ raka mena e wabwi na wabwi, na uu regha iya thɨ mena Giya Loi e ghamwae, na i ghatha raŋgiya Juda gha wabwi. ");
INSERT INTO tgo_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Josuwa i kula vathaŋgiya Juda gha wabwiko, na uu regha iya thɨ raka raŋgi, na uuko e tɨnenji Giya Loi i ghatha raŋgiya Jera gha uu. Josuwa kaero i kula vathaŋgiva Jera gha uu e tɨne amaamala na lenji ŋgaŋga; na amala regha iya na le ŋgaŋga thɨ raka na Giya Loi i ghatha raŋgiya Jabdi na le ŋgaŋga. ");
INSERT INTO tgo_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Josuwa mbowo i kula vathaŋgiva Jabdi le ŋgaŋga na amaamala regha iya i raŋgi, na Giya Loi i ghatha Eikan iye Kami nariye na Jabdi rumbuye. ");
INSERT INTO tgo_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Amba Josuwa i dage weya Eikan iŋa, “Naruŋgu, u wovavwenyevwenyeŋa Giya Loi, iye Isirel lenji Loi, na u tarawe. U utu giyama e ghino budakai mendava u vakatha. Ne u nderavunyivunyiya bigi regha e ghino.” ");
INSERT INTO tgo_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Eikan i gonjoghawe iŋa, “Emunjoru, kaero mendava ya vakatha tharɨ Giya Loi, Isirel lenji Loi e marae. Tharɨke va ya vakathake iyake: ");
INSERT INTO tgo_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Mbaŋa mukuwoko e tɨne, ya thuwa kwama thovuye regha i mena Babilon, silva le vuyovuyowo mbala vama i wo paeb paun (pound), na gol vuvura le vuyovuyowo i kivwala wan paun (pound). Va mbema thɨ wo vara nuwaŋgu, iya kaiwae va ya mbanɨŋgi. Ne vohu vaidiŋgi elo ŋgoloko tɨne, va ya beku na silva ve ghena bode.” ");
INSERT INTO tgo_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Amba Josuwa i variyeŋgiya ravarivariye vavana, thɨ ruku na i wa Eikan ele ŋgoloko, na vethɨ vaidi ŋgoreiya me le utuma weŋgi. Silva va ina bode. ");
INSERT INTO tgo_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Thɨ bigi raŋgiya e yaŋathowathowako na thɨ bigi wa weya Josuwa na Isirel gharɨgharɨniyeko weŋgi, na thɨ bigirawe Giya Loi e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Amba Josuwa weiyaŋgiya Isirel gharɨgharɨniyeko thɨ vaŋgwa Eikan, thɨ mbana silvako, kwamako, golɨko, weiyaŋgiya le ŋgaŋga, oyawarumbuye, le burumwaka, le doŋɨki, le sip, le ŋgoloko, na bigibigiko wolaghɨye e gha yayaoko tɨne. Amba thɨ yotakoŋgi e gunugu idae Gunugu Vuyowo. ");
INSERT INTO tgo_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Na gheko Josuwa i dagewe iŋa, “Buda kaiwae menda u womena vuyowoke iyake weinda? E mbaŋake iyake Giya Loi ne i womena vuyowoke iyake e ghen.” Amba gharɨgharɨko wolaghɨye thɨ tagavamara Eikan e varɨvarɨ, na tembe thɨ tagavamareŋgiva le ŋgaŋgako na le bigibigiko wolaghɨye na thɨ ŋambuŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Thɨ wabwi vatha varɨvarɨ Eikan e vwatae, na noroke mbe inawe. Iya kaiwae valɨvaŋgako iyako mbe idae vara Gunugu Vuyowo. Giya Loi ma tembe i ghare gaithɨva weŋgiya Isirel gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Amba Giya Loi i dage weya Josuwa iŋa, “Tha u mararu, na tha u gharelaghɨlaghɨ. U takoŋgiya len ragagaithɨna wolaghɨye, hu raka voro na vohu gaithɨ Ai. Kaero ya vaŋgura Ai gha kiŋ e nɨman ghare, weiyaŋgiya le gharɨgharɨko, ghambaeko na le thelauko ne ghenɨwe. ");
INSERT INTO tgo_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Ne u vakatha weya Ai na gha kiŋɨko ŋgora va u vakatha weya Jeriko na gha kiŋ, ko iyemaeŋge e mbaŋake iyake valɨkaiwami hu mbana bigibiginiyeko, na thetheghan ghemi regha na regha kaiwami. U vaŋgu thuwoleŋgiya len ragagaithɨna vavana e ghembana ghereiye, mbala hu vathinɨna gharenji na thɨ munje thɨ rakaraŋgi gaithɨ kaiwae, amba len ragagaithɨna e ghembana ghereiye thɨ raka raŋgi na thɨ gaithɨ.” ");
INSERT INTO tgo_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Kaero Josuwa i vivatha na i voro weiyaŋgiya le ragagaithɨko na vethɨ gaithɨ Ai. I gatha raŋgiyaŋgiya le ragagaithɨ yamwa lenji ghanaghanagha teti tausan (30,000) na i variye yathuŋgi gougouko iyako, ");
INSERT INTO tgo_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","na i dage weŋgi iŋa, “Wo hu vandeŋe wagiyawe. Huya kubaro e ghembana valɨvaŋga, ko thava bwagabwaga moli, na mbe hu vivatha gaithɨ kaiwae. ");
INSERT INTO tgo_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Ghino na ragagaithɨke wolaghɨye iya weiŋguyaŋgike mbene wo raka voro vara e ghembako, na mbaŋa ragagaithɨ e ghembako ne thɨ gaithɨ weime ŋgora va thɨ vakathama, ne wo raka vo. ");
INSERT INTO tgo_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Mbala thɨ renuwaŋa na thiŋava, ‘Isirel ragagaithɨko thɨ rakavo weinda ŋgora va thɨ vakathama.’ Ne thɨ raka mbeleime, ne wo vakathaŋgi na thɨ raka iteta ghembana. ");
INSERT INTO tgo_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Ko amba ghemi ghami dauya vara iyako hu raka raŋgi e lemi ghamba kubarona, na hu wo ghembana. Giya la Loi ne i wogiya e ghemi. ");
INSERT INTO tgo_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Mbaŋa ne hu rakaru e ghembana tɨne, hu woŋambu, ŋgora Giya Loi va le renuwaŋa. Hu ghambugha iya ghalɨŋaŋguke iyake.” ");
INSERT INTO tgo_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Kaero Josuwa i variye yathuŋgiya ragagaithɨma, na mbowo vethɨ roroghagha ŋgora lenji ghamba kubaroko — Ai e yalasiniyeko, Ai na Betel ghanjilughawoghawo. Josuwa va mbowo i roghenava e kiyamuko gougouko iyako. ");
INSERT INTO tgo_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","I ghɨviyava — mbe mbaŋambaŋa Josuwa kaero i thuweiru na i kula vathaŋgiya ragagaithɨko wolaghɨye. Amba amalaghɨniye weiyayaŋgiya Isirel lenji randevivako, thɨ viva weŋgiya ragagaithɨko na vethɨ gaithɨ Ai. ");
INSERT INTO tgo_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Mbe thɨ loŋga ghɨdaghɨdaŋa vara ghamba ruko laghɨye e ghembako tɨne na thɨ vakatha lenji kiyamu e ghaiwabuniyeko na gunugu ina Ai na thiye ghanji lughawoghawo. ");
INSERT INTO tgo_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Josuwa vambe i wabwivathava le ragagaithɨ lenji ghanaghanagha paeb tausan (5,000) na thiya kubaro Ai e yalasiniyeko, Ai na Betel e ghanji lughawoghawo. ");
INSERT INTO tgo_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Josuwa i ghatha vakatha le ragagaithɨko gaithɨ kaiwae — wabwi laghɨyeniye va inanji e ghembako ghaiwabuniye na vavanako e yalasiniyeko. Josuwa ghamberegha va mbowo njoghava e lenji kiyamu gougouko iyako, Jorɨdan e malamoniye. ");
INSERT INTO tgo_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Mbaŋa Ai gha kiŋ i thuweŋgiya Isirel lenji ragagaithɨko, mbema ghe na nɨma eŋge weiyaŋgiya le ragagaithɨ thɨ raka raŋgi na ghamwanji i ghembeya Jorɨdan, ŋgora va thɨ gaithɨkaima weinjiyaŋgiya Isirel ragagaithɨ. Ko iyemaeŋge mava i ghareghare ragagaithɨko e ghembako ghereiye ne thɨ gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Josuwa na le ragagaithɨko mbema thɨ kwanɨ eŋge, thɨ ruku na i ghembeya njamnjamɨko thɨ munjeva mbala ghanji rathɨghɨyako thɨŋa kaero methɨ kivwalaŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Gharɨgharɨko wolaghɨye Ai e tɨne, thavala valɨkaiwanji gaithɨ, thɨ raka raŋgi na tembe thɨ raka mbeleŋgiva Josuwa na le ragagaithɨko na i vakatha vama ghanji lughawoghawo laghɨye weya ghembako. ");
INSERT INTO tgo_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Ghɨmoghɨmoruko wolaghɨye Ai na Betel e tɨnenji kaero thɨ raka raŋgivao na thɨ iteta ghembako. Ghembako ghamba ruruko va i mavura na, ma tembe ragagaithɨ regha inaweva na i rogaithɨten. ");
INSERT INTO tgo_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Amba Giya Loi i dage weya Josuwa iŋa, “U wo len gaithɨna gha kin na maraena i ghembeya Ai; kaero ya worawa ghemba e nɨmanɨna ghare.” Josuwa i vakatha ŋgora Giya Loi va i dagewe, ");
INSERT INTO tgo_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","na mbaŋaniye vara Josuwa i vakatha iyako, ragagaithɨma va thiya kubaroma thɨ yondovirɨ, mbema ghenji na nɨmanji eŋge thɨ rakaru na thɨ wo ghembako, na thɨ woŋambu. ");
INSERT INTO tgo_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Ai ragagaithɨ vethɨ gaithɨ matavɨ na maranji i njogha, amba thɨ thuweya mundu i voro e ŋgalɨlɨko. Ma tembe kamwathɨ reghava na valɨkaiwanji thɨ vo reŋawe, kaiwae Isirel ragagaithɨ iya va thɨ rakavo na i ghembeya Jorɨdan njamnjamniyeko, thɨ raka matavɨ amba thɨ gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Mbaŋa Josuwa na le ragagaithɨko va thɨ thuweya munduko thɨ ghareghare lenji valɨragagaithɨma kaero methɨ wo ghembako, thɨ raka matavɨ eŋge kaero thɨ ghene ŋgoruru Ai lenji ragagaithɨko. ");
INSERT INTO tgo_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Isirel lenji ragagaithɨ va inanji e ghembako tɨne thɨ raka na i ghembeŋgiya Ai ragagaithɨ, iya kaiwae kaero inanji vara Isirel ragagaithɨ wabwi theghewo e ghanji lughawoghawo, na ma tembe valɨkaiwaeva Ai le ragagaithɨ regha i vo raŋgi e yawayawaliye. Thɨ gabovaoŋgi na iko. ");
INSERT INTO tgo_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Vambe Ai gha kiŋ ghamberegha eŋge e yawayawaliye. Ragagaithɨko thɨ yalawe na vethɨ vaŋgugiya weya Josuwa. ");
INSERT INTO tgo_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Isirel mbema thɨ gabovaoŋgi vara ghanji rathɨghɨyako Jorɨdan malamoniye e tɨne, ko amba thɨ raka njogha Ai na tembe thɨ gabovaoŋgiva thavala va inanji gheko. ");
INSERT INTO tgo_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Ai gharɨgharɨniye lenji ghanaghanagha tuwel tausan (12,000) ghɨmoghɨmoru na wanakau. ");
INSERT INTO tgo_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Josuwa mava i wonjaniya gaithɨko gha kin, vambe inawe vara e nɨmae ghaghad va thɨ mukuwoŋgiya gharɨgharɨko wolaghɨye va thiya yaku gheko. ");
INSERT INTO tgo_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Ko iyemaeŋge Isirel gharɨgharɨniye va thɨ takoŋgiya thetheghan na the bigibigiva va thɨ mbanɨŋgi mbe thiye kaiwanji. Iyako Giya Loi va i dage weya Josuwa na thɨ vakatha. ");
INSERT INTO tgo_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Josuwa va i woŋambwa Ai. Ghembako mbe ina vara e mukuwo tɨne ghaghad noroke iya ya roriya riuriuniyeke. ");
INSERT INTO tgo_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Josuwa iŋa na thɨ tagavamara Ai gha kiŋ na thɨ wovakwata riwae e umbwa ghaghad yeghɨyeghɨye. Vama ŋgoreiya tauya wovoŋgu, iŋa na ragagaithɨko vethɨ wokiyathu e ghembako ghamba ruru na thɨ variya riwaeko e varɨvarɨ — wabwi laghɨye moli. Varɨvarɨko gha wabwiko vambe i nawe mbaŋa thɨ roriya riuriuke iyake. ");
INSERT INTO tgo_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","31","Mbaŋa vavana e ghereiye Josuwa na Isirel gharɨgharɨniye vethɨ raka voro e Ou Ibol. Mbaŋa vethɨ raka vutha gheko Josuwa i dage weŋgiya ghɨmoghɨmoruko vavana iŋa, “Hu vatada ghamba vowo weya Giya la Loi. Hu vatadɨ ŋgoreiye vavaghare ina Mosese ele Mbaro tɨne. Mosese, Giya Loi le rakakaiwo va iŋa, ghambavowo gha vatavatadɨ ne hu vatadɨ e varɨvarɨ ma thɨ tenɨŋgi na thɨ vanamwe ghadɨdɨnji e aiyan.” Amba thɨ vatada ghamba vowoma. Gharɨgharɨko wolaghɨye thɨ giya lenji vowo thetheghan mbwanambwanaŋgi weya Giya Loi na thɨ ŋambu vaoŋgi, tembe ŋgoreiyeva thɨ vowoŋa vɨghathɨ vowoniyewe. ");
INSERT INTO tgo_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Gheko, Isirel gharɨgharɨniyeko wolaghɨye e maranji Josuwa i rori valawe Mosese le Mbaroko iyava i rori e varɨvarɨ va i vanamwe ghanji yamoyamo. ");
INSERT INTO tgo_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Isirel gharɨgharɨniye thɨ mevathavatha na thɨ ndeghathɨ e wabwi theghewo, weinjiyaŋgiya lenji randevivaŋgi, rambarombaro, raghathaghatha na bwabwari thiya ndeghathɨ e wabwiko theghewoko tɨnenji, na Dagerawe gha Bogis ina e ghanji lughawoghawo. Wabwi regha iya vaŋga na vaŋga na Dagerawe gha Bogis ina e ghanji lughawoghawo. Wabwi regha ghereinji i ghemba Ou Ibol na regha ghereinji i ghembeya Ou Gerijim. Livai le wabwi e tɨne, ravowovowoko thɨ ndekewa Dagerawe gha Bogis na thɨ ndeghathɨ e lenji ghamba ndeghathɨ vaŋga na vaŋga. Giya Loi le rakakaiwo, Mosese va i dage na thɨ vakatha ŋgoreiye iyako, mbaŋa ne thɨ mena na thɨ wo ghanji dagemwaewo. ");
INSERT INTO tgo_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Josuwa ghalɨŋae laghɨye, i vaona Mbaroko wolaghɨye e gha buk tɨne, iya va i utuŋa dagemwaewoko na gurako ŋgoreiye va thɨ rorinjoŋa Mbaroko e gha buk tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Josuwa i vaonavao mbaroko wolaghɨye Mosese va i rori njoŋa, weŋgiya Isirel gharɨgharɨniyeko wolaghɨye, weŋgiya wanakau, gamagai na bwabwari iyava thiya yaku e tɨnenjiko. ");
INSERT INTO tgo_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Mbaŋa kiŋɨŋgiko wolaghɨye inanji Jorɨdan e yalasiniyeko, thɨ loŋwa Isirel lenji vurɨgheghe utuniye weinjiyaŋgiya Ai na Jeriko — thiye thɨ yakuŋa bobokuluko vwatavwatanji, thiye inanji e bobokuluko rɨgherɨghenji, na thiye thiya roŋgalai Njighɨ Meditareiniyan ghadidiye na tembe ŋgoreiyeva kiŋɨŋgi inanji e ghaiwabuko vewo Lebenon — kiŋɨŋgike thiyake gharɨgharɨ wabwike thiyake lenji kiŋɨŋgi — Hiti, Amori, Kenani, Perisi, Hivi na Jebusi. ");
INSERT INTO tgo_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Kiŋɨŋgike thiyake thɨ wabwi vathavathaŋgi lenji ragagaithɨ na regha na lenji rɨghe regha — nuwanjiya thɨ kivwalaŋgiya Josuwa na Isirel gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Ko iyemaeŋge, mbaŋa Gibiyon gharɨgharɨniye, thiye Hivi, thɨ loŋwe budakai Josuwa va i vakatha weŋgiya Jeriko na Ai, ");
INSERT INTO tgo_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","iwaeŋge nuwanjiya thɨ valogha nuwae. Kaero thɨ vakatha ŋgoreiyake: thɨ mbana ghanɨŋga e begibegi teteuye thɨ bigi vala doŋɨki e vwatavwatanji weiye waen varivariye tembe teteuyeva na thɨ ŋgiya valevaleweŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Gharɨgharɨko tembe thɨ njimboŋgiva kwamakwama teteuye na gheghenji ghae teteuye thɨ ŋgiya valevaleweŋgi. Na bred va thɨ mban kaero i vurɨgheghe na i wado. ");
INSERT INTO tgo_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Amba ravarivariyeko thiya wareri thɨ raka weŋgiya Josuwa na Isirel ghɨmoghɨmoruniye inanji e lenji kiyamu Gilgal e tɨne, na vethɨ dage weŋgi thɨŋa, “Wo raka mena e vanautuma bwagabwaga moli. Nuwameiya hu vakatha dagerawe regha weime.” ");
INSERT INTO tgo_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Isirel ghɨmoghɨmoruniye thɨ dage weŋgi thɨŋa, “Buda kaiwae na ne wo vakatha dagerawe e ghemi? Mbwata mbema hu yaku evasiwameke.” ");
INSERT INTO tgo_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Thɨ dage weya Josuwa thɨŋa, “Ghime len rakakaiwo.” Ko iyemaeŋge Josuwa i vaitoŋgi iŋa, “Thavala ghemi na aŋga hu raka mena?” ");
INSERT INTO tgo_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Thɨ gonjoghawe e riuriuke iyake, “Wo raka mena e vanautuma bwagabwaga moli amalana, kaiwae kaero wo loŋwa Giya lemi Loi le vakathana utuniye. Kaerova wo loŋwa bigibigike wolaghɨye va i vakathaŋgi Ijipt e tɨne ");
INSERT INTO tgo_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","na budakai va i vakatha weŋgiya Amori lenji kiŋ theghewo Jorɨdan valɨvaŋga i vorovoro — Kiŋ Saihon, Hesbon gha kiŋ na Kiŋ Og, Basan gha kiŋ va i yaku Astarot. ");
INSERT INTO tgo_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Iya kaiwae lama randevivaŋgi na gharɨgharɨko wolaghɨye thiya yaku e vanautumako iyako tɨne thɨ dage weime thɨŋa, ‘Hu mbana ghanɨŋga lemi loŋgaloŋgana kaiwae. Vohu vutha weŋgi na hu utu weimiyaŋgi huŋa, “Ghime lemi rakakaiwo. Hu vakatha dagerawe weime.” ’ ");
INSERT INTO tgo_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Wo hu thuwa ghama bredɨke. Mbaŋa mendava wo iteta ghemba na wo mena wo thuweŋga, vamba i dade vara. Ko wo hu thuwe! Kaero i vurɨgheghe na i wado. ");
INSERT INTO tgo_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Mbaŋa va wo guduŋgiya waenɨke varivariye, vambe totogha vara. Ko wo hu thuwe! Kaero thɨ mamaviya. Ghama kwamakwamake na ghegheme ghae kaero thɨ teteuye kaiwae ghɨnaghake molao moli.” ");
INSERT INTO tgo_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Isirel ghɨmoghɨmoruniye vavana thɨ mbana ghanɨŋgama vavana na thɨ ghan, ko iyemaeŋge mava thɨ vaito gha rumwaru weya Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Josuwa i vakatha vɨghathɨ gha dagerawe weiyaŋgiya Gibiyon gharɨgharɨniyeko, amba i variye yathuŋgi. Wabwi Isirel ghanjigiyagiya thɨ tholo na thɨ vikiki ghathɨgha dageraweko iyako. ");
INSERT INTO tgo_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Mbaŋa thegheto e ghereiye Isirel thɨ loŋwe vaidi Gibiyon gharɨgharɨniye va thɨ yaroŋgi, ko mbema thɨ yaku vara evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Amba Isirel thɨ raka iteta Gilgal na thiya wareri. Mbaŋa thegheto e ghereiye kaero vethɨ raka vutha e ghembaghembako iya gharɨgharɨko va thiya yakuwe. E ghembaghembake thiyake: Gibiyon, Kepira, Biyarot, na Kiriyat Jeyarim. ");
INSERT INTO tgo_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Ko iyemaeŋge Isirel mava thɨ gaboŋgiya gharɨgharɨko thiyako, kaiwae lenji rambarombaroko kaero mendava thɨ tholo Giya Loi Isirel lenji Loi e idae. Isirel wabwiko laghɨye thɨ liya rambarombaroko ghanjiutu lenji vakathako iyako kaiwae. ");
INSERT INTO tgo_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Ko iyemaeŋge thɨ dage weŋgi thɨŋa, “Kaero mendava wo tholo Giya Loi, Isirel lenji Loi e idae. Mbaŋake ma valɨkaiwae ra vakatha vɨrɨ weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Ra viyathuŋgi kaiwae kaero mendava wo dagarawe weŋgi, kaiwae thoŋgo ra gaboŋgi, Giya Loi le ghatemuru ne i nja weinda.” ");
INSERT INTO tgo_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Thɨ gotubwe thɨŋa, “Hu viyathuŋgi mbe thiya yaku, ko ne thɨ tabo eŋge ndɨghe gha ragethɨŋgi na mbwa gha raguduŋgi, Isirel taulaghɨke kaiwanda.” Iya kaiwae rambarombaroko lenji dagerawe i mboromboro. ");
INSERT INTO tgo_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Josuwa iŋa na thɨ vaŋgu menaŋgiya Gibiyon gharɨgharɨniye weya amalaghɨniye na i vaitoŋgi, iŋa, “Buda kaiwae va hu mena hu kwanɨyaroime, huŋa, hu raka mena e vanautuma bwagabwaga moli, thela i wo mbema hu yaku vara evasiwame. ");
INSERT INTO tgo_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Mbaŋake kaero Loi i guraŋga. Mbaŋake wolaghɨye ne hu gethɨgetha ndɨghe na hu guduguda mbwa Isirel lenji Loi le ŋgolo kaiwae.” ");
INSERT INTO tgo_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Thɨ gonjogha weya Josuwa thɨŋa, “Amalana, mendava wo vakatha iyana, kaiwae kaerova wo loŋwe emunjoru moli, Giya len Loi kaerova i dagera weya le rakakaiwo Mosese, ne i gabovaoŋgiya gharɨgharɨko wolaghɨye na i wogiya thelauke laghɨye e ghemi. Va wo rerenuwaŋa laghɨye moli yawalɨme kaiwae, wo mararu iya kaiwae va wo vakatha iyana. ");
INSERT INTO tgo_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Kaero iname e nɨman ghare mbaŋake. U vakatha weime the bigi u renuwaŋa i rumwaru e ghen.” ");
INSERT INTO tgo_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Iya kaiwae Josuwa i dage tenɨŋgiya Isirel gharɨgharɨniye na thava thɨ gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","E mbaŋako vara iyako Josuwa i vakatha Gibiyon gharɨgharɨniye thɨ tabo rakakaiwobwaga. Thɨ gethɨgetha ndɨghe na thɨ guduguda mbwa wabwi Isirel kaiwanji na Giya Loi le ŋgolo, ghamba vowoko kaiwae ŋgoreiye Giya Loi i tuthi ne vethɨ kururuwe. Mbe thɨ vakavakatha vara iyake ghaghad noroke. ");
INSERT INTO tgo_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Mbaŋa Adoni-Sedek i loŋwe vaidi Josuwa kaero mendava i wo Ai na i mukuwo na i tagavamare gha kiŋ, ŋgoreiya va i vakatha weya Jeriko na gha kiŋ. Na tembe i loŋweva Gibiyon gharɨgharɨniye thɨ vakatha dagerawe na thɨ vanevane weinjiyaŋgi na thiya yaku e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Iwaeŋge amalaghɨniye na le gharɨgharɨ Jerusalem e tɨne gharenji iyo laghɨye moli kaiwae Gibiyon iye ghemba laghɨye na i kivwalaŋgi ghembaghemba va inanji gheko, na vambe i laghɨye kivwalava Ai, na gha ragagaithɨko va thɨ thovuyeŋa gaithɨ. ");
INSERT INTO tgo_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Kaero Adoni-Sedek i variye totoke iyake weŋgiya Kiŋ Hoham Hebron gha kiŋ, Kiŋ Piram Jamut gha kiŋ, Kiŋ Japiya Lakis gha kiŋ, na Kiŋ Debi Eglon gha kiŋ, ");
INSERT INTO tgo_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","iŋa, “Hu raka mena hu thalavuŋgo na vara gaithɨ Gibiyon, kaiwae gharɨgharɨ e ghembako iyako kaero mendava thɨ vakatha vanevane yakuyakuniye weinjiyaŋgi Josuwa na Isirel gharɨgharɨniye.” ");
INSERT INTO tgo_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Amba Amori gha kiŋɨŋgi theghelimake thiyake: Jerusalem gha kiŋ, Hebron gha kiŋ, Jamut gha kiŋ, Lakis gha kiŋ, na Eglon gha kiŋ, lenji ragagaithɨko thɨ wabwi na regha na vethɨ raka vaghɨliya Gibiyon na thɨ gaithɨ weinjiyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Iyako kaiwae Gibiyon gharɨgharɨniye thɨ variye toto i wawe Josuwa e lenji kiyamuko Gilgal e tɨne. Totoko iŋa, “Amalana, kaiwae kaero wo tabona lemi rakakaiwo, mbaŋake nuwameiya u thalavuime, na thava hu viyathuime. Amori lenji kiŋɨŋgi, e vanautumako iya bobokuluko lemoyowe, kaero menda thɨ wabwi na regha na thɨ raka mena thɨ gaithɨ weime.” ");
INSERT INTO tgo_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Kaero Josuwa na le ragagaithɨko wolaghɨye, na le ragagaithɨ thovuthovuye, thiya wareri Gilgal na thɨ raka voro gheko. ");
INSERT INTO tgo_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Giya Loi i dagewe Josuwa, iŋa, “Thava u mararuŋgi. Kaero ya takoraweŋgi e nɨman ghare. Ma tembe reghava valɨkaiwae ne i gaithɨ njogha e ghen.” ");
INSERT INTO tgo_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Gougouko iyako Josuwa na le ragagaithɨ thɨ rakari Gilgal na vethɨ raka vutha Gibiyon. Kaiwae Amori lenji ragagaithɨko mava e lenji ghareghare mun, gharenji va iyo mbaŋa Isirel thɨ raka vutha na thɨ gaithɨ weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Giya Loi i vakathaŋgi Amori thɨ gharelaghɨlaghɨ laghɨye mbaŋa thɨ thuweŋgi Isirel ragagaithɨko thɨ gaithɨ weŋgi. Isirel ragagaithɨko thɨ gaboŋgi vavana Gibiyon ele valɨvaŋga na thɨ mbeleŋgi thɨ raka njoŋa ou Bet Horon ghadidiye na mbe thɨ mbelekikiŋgi vara e yaghalako na vethɨ ghad Ajeka na Makeda. ");
INSERT INTO tgo_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Mbaŋa va e lenji voko tɨne weŋgi Isirel ragagaithɨ na thɨ raka njoŋa ouko ghadidiye, amba Giya Loi i birinjoŋa varɨvarɨ laghɨlaghɨye thiya dobu nja e buruburu na thɨ gaboŋgi ghaghad thɨ rakavutha Ajeka. Varɨvarɨko va thɨ gaboŋgi gharɨgharɨ lemoyo moli, i kivwala Isirel ragagaithɨ va thɨ gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Va e mbaŋako vara iya Giya Loi i vakathaŋgi Isirel na thɨ kivwalaŋgi Amori gharɨgharɨniye, Isirel e maranji amba Josuwa i naŋgo weya Giya Loi, iŋa, “Varaena, mbe u ndeghathɨ vara Gibiyon e vwataena; Manjalana, tembe u ndeghathɨva e Malamo Aijalon vwata.” ");
INSERT INTO tgo_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Iya kaiwae varaeko i ndeghathɨ na manjalako tembe i ndeghathɨva, ghaghad Isirel thɨ kivwalaŋgi raghanjithɨghɨyako. Utuutuke thiyake thɨ rorinjogha e Buk idae Jasa. Varaeko va i ndeghathɨ yamoe moli e buruburuko, na mava veronja vorivori, ŋgoreiya mbaŋa regha le molamolao. ");
INSERT INTO tgo_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Va i vivako, noroke na i ghaoko ma tembe mbaŋa regha ŋgoreiyeva iyako, mbaŋa Giya Loi i thombeya mbema lolo eŋge le naŋgo ŋgora iyako. Kaiwae Giya Loi vambe weiyaŋgi vara Isirel na thɨ gaithɨ. ");
INSERT INTO tgo_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Iyake e ghereiye amba Josuwa weiyaŋgi Isirel thɨ raka njogha e lenji kiyamu Gilgal e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Iyemaeŋge, Amori lenji kiŋ theghelima va thɨ raka vo na vethiya kubaro e maŋgavarɨ Makeda e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Mbaŋa Josuwa i loŋwe vaidi kiŋɨke theghelima thɨ kubaro e maŋgavarɨ na kaero methɨ vaidiŋgi, ");
INSERT INTO tgo_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","amba iŋa, “Hu vabulale voreŋa varɨvarɨ laghɨlaghɨye vavana e maŋgavarɨna ghae, na hu vaŋguraweŋgi ragatɨgatɨ vavanawe. ");
INSERT INTO tgo_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Ko iyemaeŋge mbe hu mbelekikiŋgi vara iya ghami rathɨghɨyana vavana. Thava hu viyathuŋgi na vethiya vo ru e ghambaghambanji tɨnenji.” ");
INSERT INTO tgo_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Othembe Josuwa na Isirel ragagaithɨ thɨ gaboŋgi ghanjiune laghɨyeniye, ko iyemaeŋge vaona lolo va vethiya vo ru e ghambaghambanji ghanji gana tɨnenji na ma valɨkaiwanji thɨ gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Ragagaithɨko wolaghɨye thɨ raka njoghawe Josuwa, ma regha mun i vaidi vuyowo e kiyamuko, Makeda e tɨne. Ma tembe lolo reghava ghalɨŋae i ruuruu Isirel gharɨgharɨniye weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Amba Josuwa iŋa, “Hu mwanathewo maŋgavarɨna ghae, na hu vaŋgu menaŋgi kiŋɨna theghelima weŋgo.” ");
INSERT INTO tgo_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Kaero thɨ vaŋguwaŋgi kiŋɨko theghelima weya Josuwa — Jerusalem gha kiŋ, Hebron gha kiŋ, Jamut gha kiŋ, Lakis gha kiŋ, na Eglon gha kiŋ. ");
INSERT INTO tgo_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Mbaŋa vethɨ vaŋgugiyaŋgi weya Josuwa, amba i kula vathaŋgi Isirel ghɨmoghɨmoruniyeko wolaghɨye, na i dage weŋgi ragagaithɨko lenji randevivaŋgi, iŋa, “Hu raka mena gheke na hu vuruvala e kiŋɨŋgike thiyake numonumonji.” Amba thɨ raka raŋgi na thɨ vuruvala e numonumonji. ");
INSERT INTO tgo_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Josuwa i dage weŋgi iŋa, “Thava hu mararu na hu gharelaghɨlaghɨ. Hu vurɨgheghe eŋge na weimi lemi gharematuwo. Kaiwae Giya Loi ne i vakatha ŋgora iyake weŋgi ghami rathɨghɨyake wolaghɨye iya mo hu gaithɨko weimiyaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Kaero Josuwa iŋa na thɨ gaboŋgi kiŋɨko na thɨ bigi kithoŋgi e umbwaumbwa umbolima, na mbe thɨ kwatekwate vara gheko ghaghad yeghɨyeghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Varae ve ronja amba Josuwa i dage weŋgi na thɨ biginjoŋa riwanjiko e umbwaumbwako na vethɨ biriyathuŋgi e maŋgavarɨma va thiya kubaromawe. E maŋgavarɨko ghae thɨ bigirawe varɨvarɨ laghɨlaghɨyewe, na mbe inanjiwe e mbaŋake iyake. ");
INSERT INTO tgo_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","E mbaŋako iyako Josuwa i wo ghemba Makeda na gha kiŋ. I gabovaoŋgi gharɨgharɨniyeko wolaghɨye na ma tembe reghava e yawayawaliye. Va i vakathawe Makeda gha kiŋ ŋgora va i vakathawe Jeriko gha kiŋ. ");
INSERT INTO tgo_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Iyako e ghereiye, amba Josuwa na le ragagaithɨ thɨ raka na mbowo vethɨ gaithɨva Libɨna. ");
INSERT INTO tgo_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Giya Loi vamba i wogiyava ghembako iyako weŋgi Isirel. Ghembako gharɨgharɨniye wolaghɨye va thɨ gabovaoŋgi, ma tembe reghava e yawayawaliye. Na va thɨ vakathawe gha kiŋɨko ŋgoreiye va thɨ vakathawe Jeriko gha kiŋ. ");
INSERT INTO tgo_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Iyake e ghereiye, Josuwa na le ragagaithɨ thɨ raka itete Libɨna na thɨ raka Lakis. Thɨ raka vaghɨliya ghembako iyako amba thɨ gaithɨwe. ");
INSERT INTO tgo_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Mbaŋa theghewoniye e tɨne, Giya Loi i wora ghemba Lakis, Isirel e nɨmanji ghare. Gharɨgharɨko wolaghɨye e ghembako tɨne thɨ gabovaoŋgi ŋgora va thɨ vakatha weŋgi Libɨna gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Iyemaeŋge Horam, Geja gha kiŋ i voroma na i munjeva i thalavuŋgi Lakis, ko iyemaeŋge Josuwa i kivwalaŋgi weiyaŋgi le ragagaithɨ — i gabovaoŋgi na ma tembe reghava e yawayawaliye. ");
INSERT INTO tgo_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Josuwa na le ragagaithɨ thɨ raka itete Lakis na vethɨ gaithɨ Eglon. Thɨ raka vutha thɨ ndevaghɨliya na thɨ gaithɨ weinjiyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Va e mbaŋako iyako thɨ kivwalaŋgi na thɨ gabovaoŋgi gharɨgharɨniyeko wolaghɨye, ŋgora va thɨ vakatha weŋgi ghemba Lakis. ");
INSERT INTO tgo_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Josuwa na le ragagaithɨ thɨ raka itete Eglon na thɨ raka voro e bobokuluŋgi na vethɨ raka vutha Hebron, amba thɨ gaithɨ gheko ");
INSERT INTO tgo_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","na thɨ kivwalaŋgi. Thɨ unɨghɨ gha kiŋ na gharɨgharɨko wolaghɨye e ghembako iyako, tembe ŋgoreiyeva ghembaghemba nanasiye evasiwanji. Ma tembe thɨ iteteva lolo regha e yawayawaliye. Thɨ vakatha ŋgora methɨ vakatha Eglon e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Josuwa na le ragagaithɨ thɨ raka vaghɨle na thɨ gaithɨ weŋgi Debi, ");
INSERT INTO tgo_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","thɨ kivwalaŋgi weiye gha kiŋ na ghembaghemba nanasiye evasiwaeva. Thɨ gabovaoŋgi gharɨgharɨniyeko wolaghɨye. Josuwa va i vakathawe Debi na gha kiŋ ŋgora va i vakatha weŋgi Hebron na Lakis ghanji kiŋɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","41","Kenani yaghalaniye, valɨvaŋgako laghɨye iyako, Josuwa na le ragagaithɨ kaero thɨ wo. Thɨ kivwalaŋgi kiŋɨko iya thɨ mbaroŋaŋgi ghembaghemba e bobokuluko vanautumaniye: vuruvuru vwatavwatae e yaghalako, bobokulu malamoniyeŋgi, e yalasiko, na bobokuluko ghadighadidiji valɨvaŋga e boimako. Josuwa i viva weŋgi le ragagaithɨko Kades Baniya e tɨne e yaghalako, ghaghad Gaja e njighɨ ghadidiye. Va i viva weŋgi Gosen ele valɨvaŋga na ve wo Gibiyon e ghaiwabuko. ");
INSERT INTO tgo_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Josuwa va i kivwalaŋgi kiŋɨŋgiko na lenji ghamba mbaroko e mbaŋako iyako. Va valɨkaiwae i vakatha iyako kaiwae Giya Loi, Isirel lenji Loi, va i gaithɨ le gharɨgharɨko kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Iyako e ghereiye amba Josuwa na le ragagaithɨko thɨ raka njogha e lenji kiyamu Gilgal e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Mbaŋa Isirel lenji vurɨgheghe e gaithɨko totoniye ve vuthawe Kiŋ Jabim, Heijo e tɨne, iwaeŋge i variye utu i wawe Kiŋ Jobab, Madon e tɨne, na tembe i wa weŋgiva kiŋ inanji Simiron na Akɨsap, ");
INSERT INTO tgo_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","na kiŋ vavanava inanji e bobokulu vanautumaniye, e ghaiwabuko, na i wa Jorɨdan e malamoniye, Galili e yaghalaniyeko e ououko rɨgherɨghenji, na e ghembaghemba thɨ roŋgalai e njighɨ ghadidiye Dor ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","Tembe i variyeva utu i wa weŋgi Kenani gharɨgharɨniye inanji Jorɨdan valɨvaŋga na valɨvaŋga, weiŋgiya Amori, Hiti Perisi, Jebusi inanji e bobokulu vanautumaniye, na tembe i wa weŋgiva Hivi inanji thiya yaku e Ou Hemon rɨghe Mijɨpa ele valɨvaŋga. ");
INSERT INTO tgo_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Thɨ raka mena weinjiyaŋgi lenji ragagaithɨ lemoyo moli lenji ghanaghanagha ŋgoreiya kerakerako e njighɨko ghadidiye. Vavana va thɨ rakatha e waŋga momodɨŋgi na vavana thiya loŋga. ");
INSERT INTO tgo_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Kiŋɨŋgike thiyake thɨ wabwi vatha lenji ragagaithɨko wolaghɨye na regha na thɨ kiyamu e mbwa idae Merom, amba thɨ gaithɨ weinjiyaŋgi Isirel. ");
INSERT INTO tgo_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Giya Loi i dagewe Josuwa iŋa, “Thava u mararuŋgi, kaiwae ne ŋgora vara iyake evole, Ghino Giya Loi ne ya gabovaoŋgi. Len ragaithɨ ne thɨ vakathaŋgi lenji hosɨŋgi thiya kuvokuvo na thɨ ŋambuŋgi lenji waŋga momodɨna wolaghɨye.” ");
INSERT INTO tgo_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Kaero Josuwa na le ragagaithɨko wolaghɨye thɨ raka vethɨ vathin gharenji na thɨ gaithɨ weinjiyaŋgi e mbwa Merom. ");
INSERT INTO tgo_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Giya Loi i vakatha Isirel na thɨ kivwalaŋgi e gaithɨko. Thɨ rakambeleŋgi e ghaiwabuko ghaghad Misrepot Maim na Saidon, na i vorowoko e boimako ve wo gunugu idae Mijɨpa. Gaithɨko vambe i mbele vara na ghanji rathɨyako na ko ma tembe reghava e yawayawaliye. ");
INSERT INTO tgo_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Josuwa i vakatha weŋgi budakai Giya Loi va le utumawe: i vakathaŋgiya lenji hosɨko thiya kuvokuvo na i ŋambuŋgiya lenji waŋga momodɨko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Va e mbaŋako iyako Heijo gha kiŋɨko i mbaroŋa ghamba rothanavuko thiyako e vanautumako iyako. Vama thɨ gaithɨvao e ghembaghembako thiyako amba Josuwa na le ragagaithɨ thɨ raka na vethɨ gaithɨ Heijo. Thɨ wo ghembako iyako, thɨ unɨgha gha kiŋɨko na ");
INSERT INTO tgo_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","thɨ gabovaoŋgiya gharɨgharɨniyeko wolaghɨye, na thɨ woŋambu ghembako. ");
INSERT INTO tgo_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Josuwa i mbanɨvaoŋgiya ghembaghembako thiyako na gha kiŋɨŋgiko na i gabovaoŋgiya gharɨgharɨniyeko wolaghɨye, ŋgoreiya Giya Loi le rakakaiwo Mosese va le utuutuwe. ");
INSERT INTO tgo_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Iyemaeŋge Isirel mava thɨ ŋambuŋgiya ŋgoloŋgolo va thɨ vatadɨŋgi ŋgorava nja ghambae, ko mbe Heijo eŋge Josuwa va i woŋambu. ");
INSERT INTO tgo_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Isirel gharɨgharɨniye va thɨ bigiŋgiya bigibigi thovuthovuye e ghembaghembako iyako tɨnenji na thetheghan ŋgora sip, burumwaka na gout, mbe thiye kaiwanji. Ko iyemaeŋge gharɨgharɨniyeko wolaghɨye va thɨ gabovaoŋgi, ma tembe reghava e yawayawaliye thɨ itete. ");
INSERT INTO tgo_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Budakai Giya Loi va i utu giya weya le rakakaiwo Mosese, Mosese te vambe i utu valaweva Josuwa na i vakatha ŋgoreiye. Josuwa va i ghambu na i vamboromboro Giya Loi le renuwaŋa. Va i vakatha bigibigiko wolaghɨye Mosese va i utu giyawe. ");
INSERT INTO tgo_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Josuwa va i wo thelauko laghɨye iyako, ghamba mbaroŋgike thiyake: vanautuma e bobokuluŋgi na e ouou rɨgherɨghenji, valɨvaŋga ghaiwabuko na yaghalako, Gosen le valɨvaŋgako laghɨye na vanautuma e vuruvuru vwatavwatae e yaghalako na tembe ŋgoreiyeva Jorɨdan malamoniye. ");
INSERT INTO tgo_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","Vanautumako iya ve wo ou Halak valɨvaŋga e yaghalako Idom ghadidiye, ve wo Baalgad e ghaiwabuko, Lebenon e malamoniye Ou Hemon e yaghalaniyeko. ");
INSERT INTO tgo_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Josuwa i gaithɨ weiyaŋgiya kiŋɨŋgiko e vanautumako mbaŋa molao na i gabovaoŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Mbe Gibiyon gharɨgharɨniye eŋge vara thɨ vakatha malɨlɨ yakuyakuniye gha dagerawe weinjiyaŋgiya Isirel gharɨgharɨniye. E ghembako iyako Hivi vavana inanjiwe. Ko ghembaghembako wolaghɨye va thɨ gaithɨwe na thɨ gabovaoŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Iya vanautumake thiyake Giya Loi va i vakatha thɨ ghatemuru laghɨye na mbe thɨ gaithɨ vurɨgheghe vara weinjiyaŋgiya Isirel ghaghadi Isirel thɨ kivwalaŋgi na thɨ gabovaoŋgi ma weinji mun lenji gharevɨrɨ kaiwanji. Va thɨ vakatha ŋgoreiye Giya Loi le dagerawe weya Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Josuwa vambe i mukuwoŋgiva wabwi vurɨvurɨghegheniye regha idanji Anak. Wabwike iyake va thiya yaku e ghembaghembake thiyake — Hebron, Debi, Anab na tembe ŋgoreiyeva vavana va inanji e ououko, e vanautuma Juda na Isirel tɨnenji. Josuwa va i mukuwoŋgi na ghambaghambanjiko tembe ŋgoreiyeva. ");
INSERT INTO tgo_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Ma tembe Anak reghava i yakuyaku e vanautumako iyako tɨne, vambe gheviyeŋge inanji thiya yaku Gaja, Gat na Asɨdod. ");
INSERT INTO tgo_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Josuwa i wo vanautumako laghɨye iyako, ŋgoreiye Giya Loi va le utuutu weya Mosese, ne i wogiya weŋgiya Isirel gharɨgharɨniye ghambanji. Amba i tagaviyaviya thelauko na vuvura iya, uu regha iya e tɨnenjiko kaiwanji. E mbaŋako iyako amba gharɨgharɨko thɨ towo e gaithɨ. ");
INSERT INTO tgo_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","Isirel gharɨgharɨniye kaerova thɨ gaithɨ na thɨ kivwalaŋgiya gharɨgharɨ thiya yaku Jorɨdan valɨvaŋga e boimako, ve wo Anoni gunuguniye na i mena Jorɨdan gunuguniye na i wa e ghaiwabuko ve wo Ou Hemon. E valɨvaŋgako iyako va thɨ kivwalaŋgiya kiŋ theghewo. ");
INSERT INTO tgo_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Kiŋɨko regha idae Saihon, amalaghɨniye va i yaku Hesbon na i mbaroŋaŋgiya Amori gharɨgharɨniye. Le ghambambaro i ri Aroerɨ, ghembake iyake ina Anoni gunuguniye gha teghala, na i ri e gunuguko yamwae na vewo Walaghɨta Jabok, Amon ghanji teghala, iyako Giliyad lenji thelau valɨmboro. ");
INSERT INTO tgo_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Le ghamba mbaroko ghaghad Walaghɨta Jorɨdan gunuguniye valɨvaŋga e boimako, i ri Njighɨ Galili e yaghalako na i wa Njighɨ Maremareniye. Tembe i mbaroŋava thelauko iya Njighɨ Maremareniye e boimako, iri Bet Jesimot, e yaghalaniyeko, na ve wo Ou Pisga rɨghe. ");
INSERT INTO tgo_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Mosese na Isirel gharɨgharɨniye vambe, thɨ kivwalava Basan lenji kiŋ — idae Kiŋ Og. Iye va kiŋ vurɨvurɨghegheniye na moumouniye wabwi Repa e tɨnenji. Va i mbaro weŋgiya Astarot na Edrei. ");
INSERT INTO tgo_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","Kiŋɨke iyake va i mbaroŋa valɨvaŋga ghaiwabuko ve wo Ou Hemon e boimako na ve wo ghemba idae Saleka. Va i mbaroŋa Basan le valɨvaŋgako laghɨye na ve wo valɨvaŋga e boimako — Gesu na Maka e lenji valɨvaŋga. Le ghamba mbaroko mboro tembe ve wova Giliyad valɨvaŋga e yaghalako ghaghad Kiŋ Saihon — Hesbon lenji kiŋ gha ghadɨko. ");
INSERT INTO tgo_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Kiŋɨke theghewoke thiyake Mosese na Isirel gharɨgharɨniye va thɨ kivwalaŋgi. Mosese, Giya Loi le rakakaiwo va i wogiya kiŋɨko lenji ghamba mbaroŋgiko weŋgiya wabwike thiyake: Rubin le wabwi, Gad le wabwi na Manase le wabwi vaŋgothiye valɨvaŋga, na i tabo lenji ghamba yaku. ");
INSERT INTO tgo_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Josuwa na Isirel gharɨgharɨniye thɨ kivwalaŋgiya kiŋɨko wolaghɨye inanji e ghamba mbaroŋgi Jorɨdan e yalasiniyeko. Thɨ kivwalaŋgiya kiŋɨŋgiko iri e ghemba idae Balgad, Lebenon e gunuguniye, ghaghad Ou Halak e yaghalako Idom le ghamba mbaro ghadidiye. Josuwa i tagaviyaviya thelauko iyako na i vatomwe weŋgi — vuvura iya uu regha. ");
INSERT INTO tgo_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Iya thelauko Josuwa va i tagaviyaviya na i vatomweko weŋgi Isirel, tembe i wova vanautumako bobokuluniye, e bobokuluko rɨgherɨghenji valɨvaŋga e yalasiniyeko, Jorɨdan bobokuluniye na bobokulu rɨgherɨghenji, na valɨvaŋga e boimako, na vuruvuru vwatavwatae e yaghalako. Iya valɨvaŋgako thiyako gharɨgharɨ wabwike thiyake va thiya yakuwe: wabwi Hiti, Amori, Kenani, Perisi, Hivi, na Jebusi. ");
INSERT INTO tgo_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","Isirel gharɨgharɨniye thɨ kivwalaŋgiya kiŋɨke e ghembaghembake thiyake: Jeriko gha kiŋ Ai gha kiŋ (ina Betel ghadidiye) ");
INSERT INTO tgo_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","Jerusalem gha kiŋ Hebron gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","Jamut gha kiŋ Lakis gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","Eglon gha kiŋ Geja gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","Debi gha kiŋ Geda gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","Homa gha kiŋ Arad gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","Libɨna gha kiŋ Adulam gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","Makeda gha kiŋ Betel gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","Tapua gha kiŋ Hepa gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","Apek gha kiŋ Lasaron gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","Madon gha kiŋ Hajo gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","Simiron Meron gha kiŋ Akɨsap gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","Tanak gha kiŋ Megido gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","Kades gha kiŋ Jokneyam ina Kamel gha kiŋ ");
INSERT INTO tgo_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","Dor gha kiŋ (ina Napot Dor) Goyim gha kiŋ ina Gilgal ");
INSERT INTO tgo_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","Tija gha kiŋ. Lenji ghanaghanagha theto na regha (31). ");
INSERT INTO tgo_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","E mbaŋako iyako Josuwa kaero i amalaghɨsarɨ moli. Amba Giya Loi i dagewe, iŋa, “Kaero u amalaghɨsarɨ moli, ko iyemaeŋge thelau laghɨye mbe inawe ma mba hu wo. ");
INSERT INTO tgo_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","“Valɨvaŋgake thiyake amba ma hu wo: Pilistiya le ghamba mbaroko laghɨye na Gesu le ghamba mbaroŋgi, ");
INSERT INTO tgo_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","iri e Walaghɨta Saihorɨ Ijipt valɨvaŋga e boimako, i wa e ghaiwabuko na ve wo Ekron gha teghala, iye Kenan le ghamba mbaro. Pilistiya gha kiŋɨke theghelima thiya yaku e ghembaghembake thiyake: Gaja, Asɨdod, Eskelon, Gat na Ekron, na vavanava iyaŋgaiye Avi lenji ghamba mbaro. ");
INSERT INTO tgo_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","Valɨvaŋga e yaghalako, Kenani lenji valɨvaŋgako laghɨye, iri Mera, Saidon lenji valɨvaŋgako ve wo Apek, Amori ghanji teghala. ");
INSERT INTO tgo_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","Gebal lenji valɨvaŋgako laghɨye; Lebenon laghɨyeko valɨvaŋga e boimako, iri Baalgad Ou Hemon raberabe na ve wo Lebo Hamat. ");
INSERT INTO tgo_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","“Tembe ŋgoreiyeva Saidon gharɨgharɨniye lenji ghamba mbaroko laghɨye, iya thiya yaku e bobokuluko vanautumaniye, Lebenon Ououniye na Misrepot Maim e ghanji lughawoghawo. Ghino ne ya vagege raŋgiyaŋgi gharɨgharɨke thiyake na Isirel gharɨgharɨniye thɨ raka ru e ghamba mbaroko thiyako. U renuwaŋakiki na u tagaviyaviya thelauke iyake na u giya weŋgiya Isirel gharɨgharɨniye na lenji ghamba yakuyaku ŋgora va ya utuma e ghen. ");
INSERT INTO tgo_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","Koino! Mbaŋake u tagaviyaviya thelauke na u giya weŋgiya uu theghesiwona na Manase gha uu vaŋgothiye.” ");
INSERT INTO tgo_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Uu Manase vaŋgothiye, uu Rubin na uu Gad kaerova thɨ wo lenji ghamba yakuyaku. Mosese, iye Giya Loi le rakakaiwo, va i wogiya weŋgi Jorɨdan valɨvaŋga e boimako. ");
INSERT INTO tgo_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Lenji ghamba yakuyakuko ve wo Aroerɨ, Anoni gunuguniye le ghambaghadɨ na ghemba ina e gunuguko iyako gha lughawoghawo na malamoko laghɨye iri Medeba na ve wo Dibon. ");
INSERT INTO tgo_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","I wa ve wo vara Amon le valɨvaŋga ghaghadi, na i mbanɨvao ghembaghemba Kiŋ Saihon va i mbaroŋaŋgi, iye Amori lenji kiŋ mbaŋa va i yaku Hesbon e tɨne na i mbarowe. ");
INSERT INTO tgo_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Vambe i wova Giliyad, Gesu na Maka lenji valɨvaŋga. Ou Hemon le valɨvaŋgako laghɨye na Basan le valɨvaŋgako laghɨye ghaghadi Saleka. ");
INSERT INTO tgo_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","Na tembe ve wova Kiŋ Og le ghamba mbaroko laghɨye, iye wabwi Repa moumouniye na va i mbaro Astarot na Edrei e tɨnenji. Mosese va i kivwalaŋgiya gharɨgharɨke thiyake na i vagege raŋgiyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Ko iyemaeŋge Isirel gharɨgharɨniye mava thɨ vagege raŋgiyaŋgiya Gesu na Maka gharɨgharɨniye; thiye mbe inanji Isirel e tɨnenji noroke. ");
INSERT INTO tgo_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Ko iyemaeŋge Mosese mava i wogiya thelau regha weŋgiya Livai le wabwi. Ŋgoreiya Giya Loi va le utuutu weya Mosese, thiye lenji yakuyaku kaiwae va i mena weŋgiya gharɨgharɨ lenji vowo mbaŋa thɨ bigirawe na thɨ ŋambu na i vorowe Giya Isirel lenji Loi. ");
INSERT INTO tgo_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","Mosese va i giya ghamba yakuyakuke iyake weŋgiya uu na uu, uu Rubin e tɨne: ");
INSERT INTO tgo_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Lenji ghamba yakuyakuko va ve wo Aroerɨ, Anoni Gunuguniye gha teghala, na ghemba reghava ina e gunuguko gha lughawoghawo, na tembe ve wova malomaloŋako laghɨye i vaghɨliya Medeba. ");
INSERT INTO tgo_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","Hesbon tembe i ruva weiyaŋgiya ghembaghembako wolaghɨye e malamoko: Dibon, Bamot Baal, Bet Baalmiyon, ");
INSERT INTO tgo_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","Jahas, Kedemot, Mepat, ");
INSERT INTO tgo_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","Kiriyataim, Sibma, Jeret Saha ina e bobokulu regha, e gunuguko tɨne, ");
INSERT INTO tgo_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","Betɨpeo, Ou Pisga maloŋaloŋaniyeŋgi, na Bet Jesimot. ");
INSERT INTO tgo_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","I wo ghembaghembako wolaghɨye e malamoko na Amori lenji kiŋ, Saihon le ghamba mbaroko laghɨye, iye va i mbaro Hesbon e tɨne. Mosese va i kivwala, tembe ŋgoreiyeva Midiya gha rambarombaroke wolaghɨye thiyeke: Evi, Rekem, Ju, Hu, na Reba. Thiyeke iyake va thɨ mbaroŋa valɨvaŋgako iyako Kiŋ Saihon kaiwae. ");
INSERT INTO tgo_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","Weiyaŋgiya gharɨgharɨke thiyake, Balaam Beor nariye iye manɨyeto, Isirel gharɨgharɨniye vambe thɨ unɨghɨva. ");
INSERT INTO tgo_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","Jorɨdan yalasiniyeko i tabo na uu Rubin lenji ghamba yakuyaku na ghanji teghala. Ghembaghemba nanasiye na laghɨlaghɨye va thɨ giya weŋgiya Rubin le wabwi, uu na uu lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","Mosese va i giya ghamba yakuyakuke iyake weŋgiya wabwi na wabwi, uu Gad e tɨne: ");
INSERT INTO tgo_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Lenji ghamba yakuyakuko, Jaje na ghembaghembako laghɨlaghɨye wolaghɨye Giliyad e tɨne, na Amon lenji thelau vaŋgothiye na ve wo Aroerɨ, Raba boimaniyeko. ");
INSERT INTO tgo_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","Lenji ghamba yakuyaku iri Hesbon ve wo Ramat Mijɨpa na Betonim, iri Mahanaim na ve wo Deba gha ghadɨko. ");
INSERT INTO tgo_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","Jorɨdan Malamoniye e tɨne i wo Bet Haram, Bet Nimra, Sukot na Japon, Kiŋ Saihon le ghamba mbaro va i yaku Hesbon. Walaghɨtae Jorɨdan e yalasiniyeko iye ghanji teghala, na e ghaiwabuko ve wo Njighɨ Galili. ");
INSERT INTO tgo_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","Ghembaghemba laghɨlaghɨye na nanasiyeke thiyake va thɨ giya weŋgiya wabwi na wabwi, uu Gad e tɨne na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","Mosese va i wogiya thelauko iyako valɨvaŋga weŋgiya wabwi na wabwi, uu Manase vaŋgothiye na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Thelauko iyako iri Mahanaim na i wo e ghaiwabuko. I wo Basan laghɨyeko na tembe ŋgoreiyeva ghembaghemba nanasiye ghembaewona, iyava mbaŋa regha Jai i kivwalaŋgi na i wo valɨvaŋgako iyako. Va mbaŋa regha Kiŋ Og, Basan e tɨne i mbaroŋa iya valɨvaŋgako iyako. ");
INSERT INTO tgo_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","Va i wo Giliyad vaŋgothiye regha na tembe ŋgoreiyeva Astarot na Edrei. Ghembaghembake thiyake Kiŋ Og va i yaku Basan le ghamba mbaroko ghembaghembaniye laghɨlaghɨye. Iya valɨvaŋgako iyako va i wogiya weya uu Maki, iye Manase nariye. ");
INSERT INTO tgo_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","Mosese va i giya thelauko iyako ŋgoreiye varako Jeriko na Jorɨdan valɨvaŋga i vorovoro mbaŋa va ina Mowab e malamoniye. ");
INSERT INTO tgo_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Ko iyemaeŋge Mosese mava i wogiya mun thelau regha weŋgiya Livai le wabwi. Va iŋa, lenji yakuyaku kaiwae ne i mena weŋgiya Isirel gharɨgharɨniye mbaŋa ne thɨ vakatha vowo weya Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Iyake i govambwara va ŋgoroŋga na thɨ giya Kenan thelauniyeko — Jorɨdan yalasiniyeko thɨ wogiya weŋgiya Isirel gharɨgharɨniye. Eliyesa iye ravowovowo, Josuwa Nan nariye na Isirel uu theyaworo na theghewo lenji randevivaŋgi, thɨ giya thelauko weŋgi Isirel gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Mbaŋa va thɨ giya ghamba yakuyaku weŋgi wabwi na wabwi, uu theghesiwo na uu Manase vaŋgothiye weŋgi, va thɨ duda varɨ na varɨko le govambwara thɨ vakatha ŋgoreiye, ŋgora Giya Loi vama i utu giyawe Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","4","Mosese kaerova i giya ghamba yakuyaku weŋgi uu theghewo na uu reghava vaŋgothiye, Jorɨdan valɨvaŋga e boimako. (Josep orumburumbuye va uu theghewo: Manase na Ipɨreim.) Iyemaeŋge, Mosese mava i wogiya ghamba yakuyaku regha weŋgi uu Livai e valɨvaŋgako iyako. Ko vambe i vatomwe eŋge thiya yaku e ghembaghemba laghɨlaghɨye na umauma inanjiwe lenji thetheghanɨko lenji ghamba ghan nana. ");
INSERT INTO tgo_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Isirel gharɨgharɨniye va thɨ giya lenji thelauko e valɨvaŋgako iyako ŋgoreiye vara iyako, ŋgora Giya Loi vama i utu giya weya Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Mbaŋa regha gharɨgharɨ vavana Juda e gha uu tɨne thɨ raka menawe Josuwa mbaŋa vamba inanji Gilgal e tɨne. Gharɨgharɨke thiyake regha, Keleb Jepune nariye na i mena uu Keni e tɨne, i dagewe Josuwa iŋa, “Kaero u ghareghare ŋgoroŋga Giya Loi va i dagewe Mosese, Loi le lolo, ghen na ghino kaiwanda mbaŋa va inanda Kades Beniya e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Ghino wo theghathegha vama i wo ghwevarɨ mbaŋa Giya Loi le rakakaiwo, Mosese va i variyeŋgo Kades Beniya e tɨne ya raŋgi na ya mena ya ghewaŋa budakai ina e thelauke iyake tɨne. Mbaŋa ya njoghawe, ya wonjogha toto emunjoruwe amalaghɨniye budakai va ya thuwe e maraŋgu. ");
INSERT INTO tgo_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Ko iyemaeŋge wouneko va weiŋguyaŋgiko thɨ vakatha gharelaghɨlaghɨ laghɨye weŋgi gharɨgharɨko wolaghɨye. Iyemaeŋge, ghino ya vareminje moli Giya lo Loi. ");
INSERT INTO tgo_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Iya kaiwae Mosese i tholo na i dagera e ghino, iŋa, ‘Iya vara thelauna mendava vo loŋganawe nevole ghen na orumburumbu tha na tha lenji ghamba yakuyaku mbaŋake wolaghɨye, kaiwae mendava u ghambu na u vareminja Giya lo Loi e gharenɨna laghɨye.’” ");
INSERT INTO tgo_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","“Wo u thuwe, noroke kaero theghathegha kaero ghwevarɨ na umbolima iko mbaŋa Giya Loi va i utu giya utuutuko iyako weya Mosese. Va e mbaŋako iyako Isirel gharɨgharɨniye vamba thɨ rakaraka loloŋga e vuruvuru vwatavwatae, na Giya Loi, ŋgoreiye va le dagerawe, i vakathaŋgo mbe e yawayawaliŋgu ghaghadɨ noroke. Wo u thuweŋgo noroke! Wo theghathegha kaero i wo ghwewa na umbolima (85) ");
INSERT INTO tgo_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","na lo vurɨgheghe noroke mbe ŋgora vara Mosese vamba e yawayawaliye na i variyeŋgo ya mena gheke. Lo vurɨghegheke mbe valɨkaiwaŋgu eŋge ya wa gaithɨ kaiwae o ya vakathava the bigithan. ");
INSERT INTO tgo_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Iya kaiwae noroke mau vatomwe eŋge weŋgo vanautumake e ououniyeke iya Giya Loi va i dagerake weŋgo va e mbaŋako iyako. Kaerova wo utu giya e ghen gharɨgharɨ laghɨlaghɨye idanji Anak inanji gheko, na ghembaghembako ghanji gana mbe thɨ vurɨgheghe eŋge. Ko iyemaeŋge Giya Loi ne i thalavuŋgo na ya vagege raŋgiyaŋgi ŋgoreiya va iŋako.” ");
INSERT INTO tgo_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Josuwa i wogiyawe Keleb, Jepune nariye gha dagemwaewo na i wogiya ghambae idae Hebron na le ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Hebron mbe Keleb, Jepune rara Keni nariye orumburumbuye lenji ghamba yakuyaku vara, kaiwae va i vareminje na i ghambu Giya Loi, Isirel lenji Loi. ");
INSERT INTO tgo_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Hebron vambe idae Kiriyat Aba, iye va lolo laghɨye regha wabwi Anak e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Thelauko iya wabwi na wabwi va thɨ wo Juda le uu e tɨne le laghɨlaghɨye ŋgoreiyake: Thelauko iyako i wo ghaghad Idom le ghamba mbaroko na ve wo vuruvuru vwatavwata idae Jin e yaghalako. ");
INSERT INTO tgo_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Iya teghalako valɨvaŋga e yaghalako ve wo Njighɨ Maremareniye ghaghadiko. ");
INSERT INTO tgo_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","I reŋa e yaghalaniyeko, iri Akrabim Ghambareŋa na ve wo Jin. I ruku reŋa Kades Beniya e yaghalaniyeko, i ghathara Hesron i voro Ada, i loŋga na i ghembaya Kaka. ");
INSERT INTO tgo_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","I loŋga na i ghembeya Asimon na i mbele mbwa regha ŋgora Ijipt ghaghadɨko, na ve wo Njighɨ Meditareiniyan. Iyake vanautumako ghaghad vara iyako, valɨvaŋga e yaghalako. ");
INSERT INTO tgo_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","Njighɨ Maremareniye e boimako iye teghala, i voro ve wo Jorɨdan na i mena i wo ŋgora i varaŋgikowe. Ghaiwabuko gha teghala i ri gheko ");
INSERT INTO tgo_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","i wa ve wo Bet Hogɨla, i reŋa Jorɨdan Malamoniye e ghaiwabuniyeko, na i voro ve wo Varɨ Bohan (Bohan iye Rubin va nariye). ");
INSERT INTO tgo_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Teghalako i ri Ako Malamoniye i voro Debi, na i loŋga na i ghembeya ghaiwabuko, Gilgal gha ghaoko, amba i ghembeya Adumim Ghambareŋa, valɨvaŋga e yaghalaniyeko. Amba i wa ve wo En Semes mbwaniyeŋgi na ve raŋgi En Rogel. ");
INSERT INTO tgo_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","Amba i mbeleya Hinom Malamoniye, i reŋa e bobokulu regha e yaghalaniyeko ŋgora Jebusi va thɨ vatada ghambanji laghɨyewe — Jerusalem. Teghalako i voro e bobokulu regha vwatae, Hinom Malamoniye e tɨne valɨvaŋga e yalasiko, na Repa Malamoniye gha teghala, e ghaiwabuko. ");
INSERT INTO tgo_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","Amba teghalako e ouko vwatae i loŋga na i ghemba Mbwa Nepɨtowa na ve raŋgi e ghembaghemba laghɨlaghɨye Ou Epron ghadidiye. Gheko amba i loŋga na i ghemba Baala (o Kiriyat Jeyarim). ");
INSERT INTO tgo_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","Teghalako i vaghɨliya Bala e yalasiniyeko na ve wo Ou Seir, i ghathara Ou Jeyarim (Kesalon), i ghembeghembeya ghaiwabuko na i njaoko Bet Semes na i roiteta Timɨna. ");
INSERT INTO tgo_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","Teghalako i wa ve reŋa Ekron bobokuluniye e ghaiwabuko. I loŋga na i ghembeya Sikeron, i iteta Ou Bala na ve wo Jabɨnil. Teghalako ve raŋgi vara e Njighɨ Meditareiniyan. ");
INSERT INTO tgo_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Teghala e yalasiko, iye Njighɨ Meditareiniyan weiye njighɨko ghadidiye. Iya vara teghalaŋgike thiyake e tɨnenji, Juda gha uu gharɨgharɨniye thiya yakuwe. ");
INSERT INTO tgo_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Ŋgoreiya Giya Loi va i utu giya weya Josuwa, iya valɨvaŋgako va i wogiya weya Juda, ghadidiye regha i vatomwe weya Keleb Jepune nariye, i mena uu Juda e tɨne. Keleb va i wo ghemba idae Hebron. Ghembake iyake Aba, Anak ramae ghambae. ");
INSERT INTO tgo_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Keleb i vagege raŋgiyaŋgiya Anak orumburumbuye e ghembako tɨne — wabwi Sesai, Ahiman, na Talɨmai. ");
INSERT INTO tgo_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Amba i wareri gheko na ve gaithɨ weŋgiya gharɨgharɨ thiya yaku Debi e tɨne (ghembake iyake vambe idae Kiriyat Sepa). ");
INSERT INTO tgo_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Keleb iŋa, “Thela thoŋgo i kivwalaŋgiya Kiriyat Sepa na i wo ghembako ne ya vaŋgu giya yawarumbuŋguke, Akɨsa, weya amalaghɨniye na i vaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Otɨniyel, iye Keleb ghaghae Kenas nariye, va i kivwalaŋgiya ghembako iyako, iya kaiwae Keleb i vaŋgu giya yawarumbuye Akɨsa weya amalaghɨniye na i vaŋgu. ");
INSERT INTO tgo_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Mbaŋa ghe gha mbaŋa Akɨsa i mena weya Otɨniyel, amba Otɨniyel i dagewe na i naŋgoya thelau, ghamba kaiwo weya ramae. Mbaŋa Akɨsa i nja ele doŋɨkiko, Keleb i vaito iŋa, “Ne ya vakatha budakai kaiwan?” ");
INSERT INTO tgo_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","I gonjoghawe, iŋa, “Kaero mendava u wogiya thelau e ghino ina e valɨvaŋga ma mbwa inawe. Iya kaiwae nuwaŋguiya mbwarowou vavana.” Kaero Keleb i giyawe mbwarowou theghewo — regha yavoro na regha bode. ");
INSERT INTO tgo_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","Iya thelauke iyake Juda le wabwi, uu na uu va thɨ wo na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","Ghembaghemba laghɨlaghɨye thɨ rotan e yaghalako thiye kaiwanji, va inanji ŋgora Idom gha teghalako, thiye iyake: Kabɨjil, Eda, Jagu, ");
INSERT INTO tgo_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","Kina, Dimona, Adada, ");
INSERT INTO tgo_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","Kades, Hajo, Itɨnan, ");
INSERT INTO tgo_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","Jip, Telem, Beyalot, ");
INSERT INTO tgo_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","Hajo Hadata, Kiriyot Hesron (o Hajo) ");
INSERT INTO tgo_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","Amam, Sema, Molada, ");
INSERT INTO tgo_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","Haja Gada, Hesmon, Betɨpelet, ");
INSERT INTO tgo_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","Haja Sual, Beyasiba, Bijiyotiya, ");
INSERT INTO tgo_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","Baala, Iyim, Ejem, ");
INSERT INTO tgo_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","Elɨtolad, Kesil, Homa, ");
INSERT INTO tgo_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","Jikɨlag, Madɨmana, Sanɨsana, ");
INSERT INTO tgo_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","Lebaot, Silhim, Ain, na Rimon. Ghembaghemba laghɨlaghɨye lenji ghanaghanagha vara ghembayeiwo na ghambasiwo weinjiyaŋjiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","Ghembaghemba inanji e ououko rɨgherɨghenji thiyake: Estaol, Jora, Asɨna, ");
INSERT INTO tgo_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","Janoa, En Ganim, Tapua, Enam, ");
INSERT INTO tgo_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","Jamut, Adulam, Soko, Ajeka, ");
INSERT INTO tgo_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","Saaraim, Aditaim, Gedera na Gaderotaim. Ghembaghemba laghɨlaghɨye lenji ghanaghanagha vara ghembayaworo na ghembavarɨ weinjiyaŋgiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","ghembaghembake thiyake vambe inanjiva gheko: Jenan, Hadasa, Migɨdal Gad, ");
INSERT INTO tgo_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","Dileyan, Mijɨpa, Jokɨtil, ");
INSERT INTO tgo_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","Lakis, Bojɨkat, Eglon, ");
INSERT INTO tgo_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","Kabon, Lamas, Kitɨlis, ");
INSERT INTO tgo_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","Gederot, Betɨdagon, Naama, na Makeda. Ghembaghemba laghɨlaghɨye lenji ghanaghanagha vara ghembayaworo na ghembawona weinjiyaŋgiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","Ghembaghembake thiyake vambe inanji weva: Libɨna, Eta, Asan, ");
INSERT INTO tgo_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","Ipɨta, Asɨna, Nejib, ");
INSERT INTO tgo_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","Keila, Akɨjib, na Maresa. Ghembaghemba laghɨlaghɨye lenji ghanaghanagha vara ghembasiwo weinjiyaŋgiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","Ghembaghembake thiyake vambe inanji weva: Ghemba laghɨye Ekron weiyaŋgiya ghembaghemba nanasiye, ");
INSERT INTO tgo_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","na ghembaghembako laghɨlaghɨye na nanasiye wolaghɨye Asɨdod ghadidiye, i ri Ekron na ve wo Njighɨ Meditareiniyan. ");
INSERT INTO tgo_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","Ghembaghembake laghɨlaghɨye thiyake vambe inanji weva: Asɨdod na Gaja, weinjiyaŋgiya ghembaghemba nanasiye ve wo Ijipt gha teghalako, e mbwa regha na Njighɨ Meditareiniyan ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","E bobokuluko vanautumaniye vambe iyava ghembaghembake thiyake inanjiwe: Sami, Jati, Soko, ");
INSERT INTO tgo_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","Dana, Kiriyat Sepa, (o Debi), ");
INSERT INTO tgo_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","Anab, Esɨtemo, Anim, ");
INSERT INTO tgo_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","Gosen, Holon, na Gilo. Ghembaghemba laghɨlaghɨye ghembayaworo na ghembara, weinjiyaŋgiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","Ghembaghembake thiyake vambe inanjiva gheko: Arab, Duma, Esan, ");
INSERT INTO tgo_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","Janim, Bet Tapua, Apeka, ");
INSERT INTO tgo_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","Humta, Hebron, na Jiyo: ghembaghemba laghɨlaghɨye ghembasiwo, weinjiyaŋgiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","Ghembaghembake thiyake vambe inanjiva gheko: Mayon, Kamel, Jip, Juta, ");
INSERT INTO tgo_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","Jesɨril, Jokɨdim, Janoa, ");
INSERT INTO tgo_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","Kein, Gibeya na Timɨna. Ghembaghemba laghɨlaghɨye lenji ghanaghanagha vara ghembayaworo, weinjiyaŋgiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","Ghembaghembake thiyake vambe inanjiva gheko: Halhul, Betɨju, Gedo, ");
INSERT INTO tgo_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","Marat, Betanot, na Eltekon. Ghembaghemba laghɨlaghɨye lenji ghanaghanagha ghembawona, weinjiyaŋgiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","Ghembaghembake thiyake vambe inanjiva gheko: Kiriyat Baal (o Kiriyat Jeyarim), na Raba. Ghembaghemba laghɨlaghɨye ghembaiwo weinjiyaŋgiya ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","E vuruvuru vwatavwatae ghembaghembake thiyake va inanjiwe: Bet Araba, Midin, Sekaka, ");
INSERT INTO tgo_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","Nibɨsan, Njighɨ Ghembaniye na En Gedi. Ghembaghembake laghɨlaghɨye thiyake, lenji ghanaghanagha vara ghembawona, weinjiyaŋgiya ghembaghemba nanasiye evasiwanjiva. ");
INSERT INTO tgo_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Ko iyemaeŋge Juda gha uu gharɨgharɨniye mava valɨkaiwanji thɨ vagege raŋgiyaŋgiya Jebusi gharɨgharɨniye. Gharɨgharɨke thiyake va thiya yaku Jerusalem tɨne. Jebusi vambe inanji gheko thiya yaku weinjiyaŋgiya Juda gha uu gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","Thelauko ghaghad iya Josep orumburumbuyeko va thɨ wo na lenji ghamba yakuyaku e yaghalako, iri Jeriko mbwarowouniyeŋgi valɨvaŋga e boimako, e Walaghɨta Jorɨdan ghadidiye. Amba i iteta Jeriko i loŋga na i ghembeya ghaiwabuko e vuruvuru vwatavwata, i ghathara e bobokulu vanautumaniye na ve wo Betel. ");
INSERT INTO tgo_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","Iri Betel i wa Luji, i wa Atarot Ada, iya Arɨk gharɨgharɨniye thiya yakuwe. ");
INSERT INTO tgo_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","Kaero i loŋga na i ghembeya yalasiko na ve wo Jepɨlet gharɨgharɨniye lenji ghamba yaku, tembema ve wo eŋge Bet Horon Bode na i wa Geja na ghaghadɨ Njighɨ Meditareiniyan. ");
INSERT INTO tgo_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","Josep orumburumbuye, uu Ipɨreim na uu Manase vaŋgothiye va thɨ wo thelauke iyake na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","Iyake uu Ipɨreim, wabwi na wabwi lenji ghamba yakuyaku: Ghanji teghala iri Atarot Ada i loŋga na i ghembeya boimako, i wa ve wo Bet Horon Yavoro, ");
INSERT INTO tgo_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","na gheko ve wo Njighɨ Meditareiniyan. Mikɨmetat va ina e ghaiwabuko. Iri gheko na valɨvaŋga e boimako, teghalako i mwavathawo na i ghembeya Taanat Sailo. Na iteteŋa iyako na i loŋga ghembeya boimako na ve wo Janoa. ");
INSERT INTO tgo_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","Amba iri Janoa na i loŋga na i nja i wa Atarot na Nara, ve wo Jeriko, ghaghad Jorɨdan. ");
INSERT INTO tgo_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","Teghalako i loŋga na i njaoko iri Tapua, ve wo mbwarowou Kana na ghaghad Njighɨ Meditareiniyan. Iya thelauke iyake va i wogiya weŋgiya wabwi na wabwi, Ipɨreim gha uu e tɨne na lenji ghamba yakuyaku, ");
INSERT INTO tgo_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","weiye ghembaghemba nanasiye vavanava, iyava inanji uu Manase e lenji ghamba yakuyaku tɨne, ko iyemaeŋge vama i wogiya weŋgiya uu Ipɨreim. ");
INSERT INTO tgo_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Ko iyemaeŋge mava thɨ vagege raŋgiyaŋgi Kenan gharɨgharɨniye iya va thiya yakuko Geja. Vambe thiya yaku vara weinjiyaŋgi ghaghad mbaŋake iyake, ko iyemaeŋge thɨ vavothaŋaŋgi na thɨ tabo lenji rakakaiwobwagaŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","Thelauko regha iya Jorɨdan valɨvaŋga e yalasiko va i giya weŋgiya tari vavana, thɨ raka mena Manase gha uu e tɨne. Manase iye Josep nariye laghɨyeniye. Maki iye Giliyad ramae, Manase le ŋgamaŋgama laghɨyeninji na iye ragagaithɨ thovuye regha, iya kaiwae Giliyad na Basan, Jorɨdan valɨvaŋga e boimako va i wo na le ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","Thelau ina Jorɨdan valɨvaŋga e yalasiko va i giya weŋgiya wabwi na wabwi, Manase e gha uu tɨne, iyava vavanake thiyake; Abiyesa, Helek, Asriyel, Sekem, Hepa, na Semida. Thiyake ghɨmoghɨmoru thɨ raka mena Manase e gha uu tɨne, iye Josep nariye na thiye tari regha na regha umbalɨnji. ");
INSERT INTO tgo_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","Jelopehad, Hepe nariye, na Hepe iye Giliyad nariye, na Giliyad iye Mekiri nariye, na Mekiri iye Manase nariye. Jelopehad mava ele ŋgaŋga ghɨmoghɨmoru, ko iyemaeŋge vambe i ghambɨŋgi eŋge wanakau theulima. Idaidanji thiyake: Mala, Nowa, Hogɨla, Milika, na Tija. ");
INSERT INTO tgo_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","Wanakauke thiyake thɨ raka weya Eliyesa, iye ravowovowo, Josuwa Nan nariye na randevivaŋgi, na thɨŋa, “Giya Loi kaerova i dage weya Mosese ne hu wogiya weime, tembe ŋgoreiyeva lama bodabodako ghɨmoghɨmoruko, thelauke iyake regha lama ghamba yakuyaku.” Kaero ŋgoreiya Giya Loi va i uturawe, thɨ wogiya thelau regha weŋgi, ŋgoreiya va thɨ giya weŋgiya lenji bodaboda ghɨmoghɨmoruko. ");
INSERT INTO tgo_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","6","Iyako kaiwae Josuwa i giya Manase orumburumbuye ghɨmoghɨmoru na wanakau thelau vuvuyaworo Walaghɨtae Jorɨdan valɨvaŋga e yalasiko na ghamba mbaro theghewo; Giliyad na Basan valɨvaŋga e boimako. ");
INSERT INTO tgo_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","Uu Manase lenji ghamba yakuyaku iri Asa ele valɨvaŋga ve wo Mikɨmetat, Sekem valɨvaŋga e boimako. Teghalako i wa e yaghalako na ve wo En-Tapua ŋgora gharɨgharɨ thiya yakuwe. ");
INSERT INTO tgo_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","Thelauko iya i vaghɨliya Tapua, mbe Manase le thelau, ko iyemaeŋge ghembako Tapua, iya e teghalako tɨne, Epreim orumburumbuye weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","10","Gad, e yaghalako i mbeleya mbwa regha — Kana i voru na i njaoko na ve varaŋgi Meditareiniyan. Manase le valɨvaŋga ina e mbwa Kana valɨvaŋga ghaiwabuko, ko iyemaeŋge e yaghalako ghembaghemba laghɨlaghɨye vavana inanjiwe, uu Ipɨreim weŋgi, othembe va ina Manase ele valɨvaŋga tɨne. E ghaiwabuko Manase weiye uu Asa ghanjighad regha, na e ghaiwabuko na boimako Manase gha teghalako regha weiye wabwi Isaka. ");
INSERT INTO tgo_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","Isaka na Asa e lenji valɨvaŋgako tɨne ghembaghemba laghɨlaghɨye vavana nanjiwe, uu Manase weŋgi. Ghembaghembake thiyake: Bet San na Ibɨliyam, na ghembaghemba nanasiye evasiwanjiva, tembe ŋgoreiyeva Dor (ina e njighɨko ghadidiye), Endo, Tanak, Megido, na ghembaghemba nanasiye evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Iyemaeŋge Manase gha uu gharɨgharɨniye ma va valɨkaiwanji thiya yaku e ghembaghembako thiyako tɨnenji, kaiwae Kenani gharɨgharɨniye vambe thɨ rovurɨghegheŋa vara thiya yaku weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Othembe Isirel gharɨgharɨniye vama thɨ mbuthu na thɨ vurɨgheghe mava thɨ vagege raŋgiyaŋgi, vama thɨ vakathaŋgi eŋge rakakaiwobwaga weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","Josep orumburumbuye thɨ dage weya Josuwa, thɨŋa, “Buda kaiwae mbe u wogiya eŋge weime thelau vuvura na lama ghamba yakuyaku? Lama wabwike i laghɨye moli kaiwae Giya Loi i mwaewo weime.” ");
INSERT INTO tgo_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Josuwa i gonjogha weŋgi iŋa, “Thoŋgo lemi wabwi kaero i laghɨye moli na bobokuluna vanautumaniye, iya uu Ipɨreim lenji ghamba yakuyakuna i nasiye moli, ko hu raka e njamnjamɨko na vohu guriya thelau kaiwami, iya Perisi na Repa lenji ghamba yakuyakuko e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Josep orumburumbuye thɨ gonjoghawe thɨŋa, “Vanautumako e ououniyeko ma valɨkaiwame, na Kenani gharɨgharɨniye iya thiya yaku e malamoŋgiko lenji waŋga momodɨ thɨ vakathaŋgi e aiyan. Iya thiya yakuko Bet San na ghembaghemba evasiwanjiva na thavala thiya yaku Jesɨril e Malamoniye.” ");
INSERT INTO tgo_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Josuwa i dage weŋgiya uu Ipɨreim na uu Manase valɨvaŋga e yalasiko, iŋa, “Kaero wabwi laghɨye moliya ghemi na hu vurɨgheghe moli. Ne hu wo lemi thelau ma e vwataeva. ");
INSERT INTO tgo_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Vanautumako e ououniyeko ne hu wo, othembe iye njamnjamɨbwaga. Ne hu guri, hu iku na hu wo lemi ghamba yakuyaku e valɨvaŋga regha na ve wo valɨvaŋga regha. Iya Kenani gharɨgharɨniyeko ne hu vagege raŋgiyaŋgi, othembe lenji waŋga momodɨŋgi ŋginaunjiya aiyan na thiye tembe gharɨgharɨ vurɨghegheŋgiva.” ");
INSERT INTO tgo_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Mbaŋa kaero thɨ kivalaŋgiya gharɨgharɨko wolaghɨye e thelauko iyako tɨne na e ghereiye, amba Isirel wabwiko laghɨye thɨ mevathavatha Sailo e tɨne na thɨ vatada Mevathavatha Ŋgoloniye gheko. ");
INSERT INTO tgo_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Isirel gharɨgharɨniye uu theghepirɨ vamba inanjiwe, ma vamba e lenji ghamba yakuyaku e thelauko iyako tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Josuwa i vaitoŋgiya Isirel gharɨgharɨniye, iŋa, “Ne hu roroghagha mbaŋa le molomolao ŋgoroŋga, amba muyai hu raka ru na hu wo thelauko iya Giya Loi, orumburumbumi lenji Loi, vama i wogiyako e ghemi? ");
INSERT INTO tgo_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Hu tuthiŋgiya ghɨmoghɨmoru thegheto wabwi regha iya e tɨne. Ne ya variyeŋgi thɨ raka na vethɨ rɨghɨya thelauko na thɨ tenɨŋgi e wabwi regha iya. Amba thɨ raka njoghama e ghino. ");
INSERT INTO tgo_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Ne hu tena thelauko na vuvupirɨ. Juda mbe i yaku ele valɨvaŋgako e ghaiwabuko. ");
INSERT INTO tgo_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Hu rori njoŋa lemi vavanamwe thelau utuutuniye na hu limena e ghino. Amba ne ya du varɨvarɨke varɨiwoke kaiwami Giya la Loi e marae. ");
INSERT INTO tgo_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","Iyemaeŋge uu Livai mane thɨ wo lenji ghamba yakuyaku regha e tɨnemina, lenji yakuyaku kaiwae, thiye ne thɨ tabo ravowovowo weya Giya Loi. Na tembe ŋgoreiyeva wabwike thiyake: Gad, Rubin na Manase vaŋgothiye kaerova thɨ wogiya lenji ghamba yakuyaku Jorɨdan valɨvaŋga e boimako. Mosese Giya Loi le rakakaiwo vama i wogiya weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Kaero ghɨmoghɨmoruma thɨ raka na vethɨ rɨghɨya thelauko mbaŋa Josuwa i utuvao utuutuke iyake weŋgi: “Hu raka na vohu rɨghɨya thelauna na hu rori njoŋa utuutuniye. Amba hu raka njoghama e ghino, na ya du varɨvarɨke varɨiwoke Giya Loi e marae kaiwami gheke — Sailo e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Kaero ghɨmoghɨmoruma thɨ raka na vethɨ vakatha ŋgoreiya me utugiyama weŋgi. Thɨ rori njogha utuutuniyeko ŋgoroŋga methɨ giya na thɨŋa e uu theghepirɨko na tembe ŋgorava ghembaghemba regha na regha. Amba thɨ raka njogha weya Josuwa e lenji kiyamu Sailo e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Amba Josuwa i du varɨvarɨ varɨiwo Giya Loi e marae kaiwanji Sailo e tɨne, na i govambwara thelauko gha tagaviyaviya weŋgiya Isirel, uu na uu iya ma mba e lenji ghamba yakuyakuko. ");
INSERT INTO tgo_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Varɨvarɨma varɨiwoma thɨ woraŋgiyakai vara wabwi Benjamin, uu na uu. Lenji ghamba yakuyaku Josuwa i wogiya weŋgi va ina uu Juda na uu Josep ghanjilughawoghawo. ");
INSERT INTO tgo_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","E ghaiwabuko ghanji teghala iri Jorɨdan, i voroŋa malomaloŋa Jeriko e ghaiwabuniyeko, i loŋga na i wa e yalasiko, i ghathara e bobokulu vanautumaniye, na ve raŋgi e vuruvuru vwatavwatae Bet Aven e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","Iri gheko i lawa ve wo malomaloŋa, Luji (idae regha Betel) e yaghalako na i wa ve nja Atarot Ada, i voroŋa ou regha e yaghalako, Bet Horon Bode/Raberabe. ");
INSERT INTO tgo_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","E bobokuluko i loŋga na i ghembeya Bet Horon e yaghalako, teghalako i wa e yaghalako valɨvaŋga e yalasiko na ve raŋgi Kiriyat Baal (o Kiriyat Jeyarim), ghembake iyake Juda gha uu ghambanji. Iyako ghanji teghala valɨvaŋga e yalasiko. ");
INSERT INTO tgo_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","Teghala valɨvaŋga e yaghalako iri Kiriyat Jeyarim ina e yalasiko na ve raŋgi e mbwarowou Nepɨtowa. ");
INSERT INTO tgo_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","I wa ve nja e ouko rɨghe na ghamwa i nja e Malamo Hinom, Malamo Repa ghaiwabuniyeko. I loŋga na ghemba yaghalako i ghathara Hinom Malamoniye, Jebusi ghadidiye e yaghalaniyeko na i ghembeya En Rogel. ");
INSERT INTO tgo_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","Teghalako i mwanavathawo, i loŋga na i ghemba ghaiwabuko ve wo En Semes na mbowa i wava ve wo Gelilot Adumim Pas/Ghambareŋa valɨvaŋgava. Teghalako i loŋga i nja ve wo Varɨ Bohan — Bohan iye va Rubin nariye. ");
INSERT INTO tgo_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","Iri gheko, teghalako i loŋga na i ghembeya ghemba Bet Araba ghaiwabuko ghaghadɨ na i nja Walaghɨtae Jorɨdan gunuguniye. ");
INSERT INTO tgo_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","Amba i loŋga na i ghembeya Bet Hogɨla gharere vwatae valɨvaŋga ghaiwabuko na ve raŋgi e garoworu regha Njighɨ Maremareniye e ghaiwabuko, Jorɨdan ve varaŋgikowe e yaghalako. I yake teghala e yaghalako. ");
INSERT INTO tgo_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","Jorɨdan i tabo na teghala valɨvaŋga e boimako. Thiyake Benjamin gha wabwi, uu na uu va thɨ wo na lenji ghamba yakuyaku ghanjighadɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","Wabwi Benjamin, uu na uu va thɨ mbana ghembaghembake laghɨlaghɨye thiyake: Jeriko, Bet Hogɨla, Emek Keji, ");
INSERT INTO tgo_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","Bet Araba, Jemaraim, Betel, ");
INSERT INTO tgo_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","Avi, Para, Opɨra, ");
INSERT INTO tgo_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","Kepara Amon, Opɨni na Geba. Ghembaghemba laghɨlaghɨye ghambayaworo na ghembaiwo na ghembaghemba nanasiyeva evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","Ghembaghembake thiyake tembe ŋgoreiyeva: Gibiyon, Rama, Berot, ");
INSERT INTO tgo_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","Mijɨpa, Kepira, Moja, ");
INSERT INTO tgo_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","Rekem, Ipel, Tarala, ");
INSERT INTO tgo_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","Jela, Haelep, Jebu (o Jerusalem), Gibeya na Kiriyat Jeyarim. Ghembaghemba laghɨlaghɨye ghembayaworo na ghembavarɨ na ghembaghemba nanasiye vavanava evasiwanji. Thelauke iyake uu na uu Benjamin e gha wabwi tɨne va thɨ wo na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Varɨvarɨma varɨiwoma thɨ govambwara wabwi theghewoniye iye Simiyon gha wabwi, uu na uu thɨ mena na thɨ wogiya lenji ghamba yakuyaku. Lenji ghamba yakuyakuko va ina wabwi Juda lenji thelau e tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","Ghembaghembake thiyake va inanji e tɨne: Beyasiba, Molada, ");
INSERT INTO tgo_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","Haja Sual, Baala, Ejem, ");
INSERT INTO tgo_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","Elɨtolad, Betul, Homa, ");
INSERT INTO tgo_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","Jikɨlag, Bet Makabot, Haja Susa, ");
INSERT INTO tgo_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","Bet Lebaot na Saruhen. Ghembaghemba laghɨlaghɨye ghembayaworo na ghembato na ghembaghemba nanasiye evasiwanjiva. ");
INSERT INTO tgo_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","Ghembaghembake thiyake tembe ŋgoreiyeva: Ain, Rimon, Eta, na Asan. Ghembaghemba laghɨlaghɨye ghembavarɨ na nanasiye tembe evasiwanjiva. ");
INSERT INTO tgo_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","Ghembaghembako laghɨlaghɨye na nanasiye evasiwanjiko i wa ve wo Baalat Beya (o Rama), ina valɨvaŋga e yaghalako. Thelauke iyake uu na uu Simiyon e gha wabwi tɨne thɨ wo na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","Kaiwae wabwi Juda lenji ghamba yakuyaku va i laghɨye kivwalaŋgi, iya kaiwae va thɨ wogiya valɨvaŋga regha weŋgiya Simiyon gha wabwi. ");
INSERT INTO tgo_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Varɨvarɨma varɨiwoma thɨ woraŋgiya Sebulon gha wabwi, uu na uu thɨ wogiya lenji ghamba yakuyaku. Ghamba yakuyakuko iyako va i wa ve wo Sarid. ");
INSERT INTO tgo_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","Gheko teghalako i loŋga na i ghembeya yalasiko na ve wo Marala, ve laweya Dabeset na mbwa Jokɨneyam valɨvaŋga e boimako. ");
INSERT INTO tgo_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","Sarid valɨvaŋga regha teghalako i loŋga na i wa e boimako na ve wo Kisɨlot Tabor ghaghad, amba i wa Daberat na i voro Japiya. ");
INSERT INTO tgo_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","Mbowo i ghaova e boimako na gheko ve wo Gat Hepa na Et Kajin, i mwanavathawo na i ghembeya Neya gha ghawoko i loŋga na i ghembeya Rimon. ");
INSERT INTO tgo_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","E ghaiwabuko, teghalako i loŋga na i ghembeya Hanaton, na ve ghad Ipɨta El malamoniye. ");
INSERT INTO tgo_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","Na ghembaghembake thiyake tembe inanjiweva: Katat, Nahalal, Simiron, Aidala, na Betɨlehem: ghembaghemba laghɨlaghɨye ghembayaworo na ghembaiwo na ghembaghemba nanasiye evasiwanjiva. ");
INSERT INTO tgo_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","Ghembaghembake laghɨlaghɨye thiyake na ghembaghemba nanasiye e thelauke iyake tɨne, uu na uu Sebulon e gha wabwi tɨne thɨ wo na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Varɨvarɨma varɨiwoma thɨ woraŋgiya wabwi Isaka, uu na uu thɨ tabo wabwivarɨnji thɨ wo lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","Ghamba yakuyakuko iyako i wo Jejɨril, Kesulot, Sunem, ");
INSERT INTO tgo_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","Haparaim, Siyon, Anaharat, ");
INSERT INTO tgo_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","Rabit, Kisiyon, Ebes, ");
INSERT INTO tgo_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","Remet, En Ganim, En-Hada, Betɨpajejɨ, ");
INSERT INTO tgo_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","teghalako tembe ve wova Tabo, Sahajuma na Bet Semes, na Jorɨdan iye teghala. Ghembaghemba laghɨlaghɨye ghembayaworo na ghembawona weiye ghembaghemba nanasiyeva evasiwanji. ");
INSERT INTO tgo_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","Iyake Isaka gha wabwi, uu na uu lenji ghamba yakuyaku, iya ghembaghembake laghɨlaghɨye na ghembaghemba nanasiye thiyake. ");
INSERT INTO tgo_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Varɨvarɨma varɨiwoma thɨ woraŋgiya Asa gha wabwi, uu na uu thɨ tabo wabwilimaninji thɨ wogiya lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","Lenji ghamba yakuyakuko va i mbanɨŋgiya: Helɨkat, Hali, Beten, Akɨsap, ");
INSERT INTO tgo_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","Alam Melek, Amad, na Misal. Teghala valɨvaŋga e yalasiko i mbanɨŋgiya Kamel, na Siho Libɨnat. ");
INSERT INTO tgo_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","Amba i mwanavathawo na i loŋga na i vorowoko e boimako, ghamwae i ghembeya Bet Dagon, ve wo Sebulon na Ipɨta El Malamoniye, na iwa e ghaiwabuko ve wo Bet Emek na Neiyel. Mbowo i loŋga na i ghembeva ghaiwabuko ve wo Kabul, ");
INSERT INTO tgo_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","Ebron Rehob, Hamon, na Kana ghaghad Saidon. ");
INSERT INTO tgo_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","Ghamba ghadɨko ve njogha na ghamwae i ghembeya Rama na ve wova Taiya — ghemba gha gana vurɨvurɨghegheniye. Amba i loŋga na i ghembeya Hosa, e yalasiko na ve ghad Njighɨ Meditareiniyan. Tembe i wova Akɨjib, ");
INSERT INTO tgo_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","Uma, Apek, na Rehob. Ghembaghemba laghɨlaghɨye ghembayeiwo na ghembaiwo na ghembaghemba nanasiye evasiwanjiva. ");
INSERT INTO tgo_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","Ghembaghembake laghɨlaghɨye na nanasiye thiyake inanji e thelauko iya uu na uu, Asa e gha wabwi tɨne thɨ wo na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Varɨvarɨma varɨiwoma thɨ woraŋgiya Napɨtalai gha wabwi, uu na uu thɨ tabo wabwiwonaninji thɨ wogiya lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","Teghalako va iri Helep ve wo umbwa laghɨye ouk ina e ou regha, Jaananim e tɨne, i wa Adami-Nekeb na ve wo Jabɨnil, ve lawa Lakam na gha teghala Jorɨdan. ");
INSERT INTO tgo_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","Gheko, teghalako i loŋga na i njaoko e yalasiko i wa Ajɨnot Tabo, amba i wa Hukok, ve wo Sebulon e yaghalako, Asa e yalasiko na Jorɨdan e boimako. ");
INSERT INTO tgo_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","Ghembaghemba laghɨlaghɨye e ghanjigana thiyake: Jidim, Je, Hamat, Rakat, Kiniret, ");
INSERT INTO tgo_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","Adama, Rama, Hajo, ");
INSERT INTO tgo_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","Kades, Edrei, En Hajo, ");
INSERT INTO tgo_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","Yiron, Migɨdal El, Horem, Betanat na Bet Semes. Ghembaghemba laghɨlaghɨye ghembayaworo na ghembasiwo na ghembaghemba nanasiye evasiwanjiva. ");
INSERT INTO tgo_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","Ghembaghemba laghɨlaghɨye na nanasiye thiyake va inanji e thelauke iyake tɨne uu na uu, Napɨtalai gha wabwi thɨ wo na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Varɨvarɨma varɨiwoma thɨ woraŋgiya Den gha wabwi, uu na uu thɨ tabo wabwipirɨninji thɨ wogiya lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","Ghamba yakuyakuko iyako va i wo Jora, Estaol, Ir Semes, ");
INSERT INTO tgo_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","Salbim, Aijalon, Itɨla, ");
INSERT INTO tgo_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","Elon, Timɨna, Ekron, ");
INSERT INTO tgo_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","Elɨteke, Gibeton, Baalat, ");
INSERT INTO tgo_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","Jehud, Beneberak, Gat-Rimon, ");
INSERT INTO tgo_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","Me Jakon na Rakon tembe ŋgoreiyeva ghambambaro, Jopa ele valɨvaŋga. ");
INSERT INTO tgo_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","Ko iyemaeŋge mbaŋa Den le wabwi gharɨgharɨniye thɨ thɨvaiya lenji ghamba yakuyakuko, thɨ raka na vethɨ gaithɨ Les na thɨ kivwalaŋgi. Thɨ gaboŋgiya gharɨgharɨko na thɨ wo lenji ghamba yakuyaku. Thiya yaku gheko na thɨ wogiya ghembako idae togha Den, rumbunji Den le ghaida. ");
INSERT INTO tgo_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","Ghembaghembake laghɨlaghɨye na nanasiye thiyake uu na uu, Den e gha wabwi tɨne thɨ wo na lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","Mbaŋa Isirel lenji randevivaŋgiko kaero thɨ giyavao thelauko iyako weŋgiya uu na uu, wabwi Isirel e tɨnenji, amba thɨ wogiyava Josuwa Nan nariye le ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","Ŋgoreiya Giya Loi va i utu giya weŋgi, thɨ wogiya weya Josuwa ghemba laghɨye regha, Timɨnat Sera ina uu Epreim e lenji ghamba yakuyaku, e bobokuluko vanautumaniye. Va i vatada ghembako iyako na i yakuwe. ");
INSERT INTO tgo_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Eliyesa iye ravowovowo, Josuwa Nan nariye, na randevivaŋgi Isirel uu na uu e tɨnenji thɨ giya thelauko iyako ŋgoreiya varɨvarɨko varɨiwoko lenji govambwara Giya Loi le renuwaŋa Sailo e tɨne, e ghamba ruru Mevathavatha Ŋgoloniye ghadidiye. Va e kamwathɨke iyake thɨ tenɨvao thelauko iyako. ");
INSERT INTO tgo_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Amba Giya Loi i dage weya Josuwa iŋa, ");
INSERT INTO tgo_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“U dage weŋgiya Isirel gharɨgharɨniye thɨ tuthiŋgiya ghembaghemba ghamba kubaro ŋgoreiye vama ya utugiya weya Mosese na i utu giya e ghen. ");
INSERT INTO tgo_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","Iyako mbala the lolothan, i unɨghɨ thavwiya lolo regha, i vo na ve yakuwe na i vo iteta thela thoŋgo i tamwetamwewe lithɨ kaiwae.” ");
INSERT INTO tgo_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","“Mbaŋa ne ve vo vutha e ghambako iyako regha, wone ve ndeghathɨ e ghamba ruruko na i utu giya le rɨgheko weŋgiya ghembako giyagiyaniye budakai me yomarawe. Amba ne thɨ vatomwe i ru e ghembako tɨne na thɨ wogiya le ghamba yaku na ve yakuwe. ");
INSERT INTO tgo_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","Thoŋgo thela nuwaiya i lithɨ, na i mbele na ve vutha e ghembako iyako, giyagiyako ne thɨ ndevaŋgu giyaŋge, mbala thɨ vaŋguthuwoleŋge, kaiwae eŋge mo unɨghɨ thavwiya ghanuko, ma me wein len gharegaithɨ. ");
INSERT INTO tgo_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Loloko mbowo ne i yaku gheko ghaghad ne i ndeghathɨ kot e marae na ghaghad kotɨko gha ravakatha — iye ravowovowo laghɨye i mare. Amba loloko iyako i njogha e ghambae, ghembako iyava i vorikowe.” ");
INSERT INTO tgo_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Kaero thɨ vakatha ŋgoreiya iyako. Jorɨdan valɨvaŋga i njanja e yalasiko thɨ tuthiŋgiya ghembaghembake thiyake: Kades, Galili e tɨne — bobokulu vanautumaniye na wabwi Napɨtalai lenji ghamba yakuyaku, Sekem ina e bobokulu vanautumaniye, uu Epreim e lenji ghamba yakuyaku na Hebron ina e bobokulu vanautumaniye, uu Juda e lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Jorɨdan valɨvaŋga i vorovoro e boimako, Jeriko malamoniye e vuruvuru vwatavwatae valɨvaŋga e boimako ghembaghembaniye thiyake: Beja ina wabwi Rubin lenji ghamba yakuyaku e tɨne, Ramot Giliyad e tɨne; wabwi Gad lenji ghamba yakuyaku e tɨne; na Golan, ina Basan e tɨne, wabwi Manase e lenji ghamba yakuyaku tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Ghembaghembake laghɨlaghɨye thiyake ghamba thowa Isirel gharɨgharɨniyeko wolaghɨye na the lolothanɨva iye bwabwari, i yaku e tɨnenjiko kaiwanji. The lolothan thoŋgo i unɨghɨ thavwiya lolo regha ne ve thowa weya iyako. I thowa weya the lolothan thoŋgo i tamwetamwe na ne i lithɨwe. Mane i lithɨwe ghaghadi loloko iyako i ndeghathɨ kot e marae. ");
INSERT INTO tgo_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Amba wabwi Livai, uu na uu lenji randevivaŋgi, thɨ raka mena weŋgiya Eliyesa iye ravowovowo, Josuwa Nan nariye na Isirel uu na uu e wabwi regha na regha tɨnenji lenji randevivaŋgi, ");
INSERT INTO tgo_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","Sailo, Kenani e tɨne, thɨŋa, “Giya Loi va i utura weya Mosese, iŋa, ‘Hu giya ghembaghemba weime woya yakuwe na lama thetheghanɨke lenji ghamba ghan evasiwanji.’” ");
INSERT INTO tgo_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Ŋgoreiya Giya Loi va i dagerako, Isirel gharɨgharɨniye thɨ wogiya weŋgi wabwi Livai ghembaghemba vavana na lenji ghamba yakuyaku tembe ŋgoreiyeva lenji thetheghanɨko lenji ghamba ghan e lenji thelauko tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","Livai gha wabwi e tɨne, Kohat gha uu va thɨ wokaiya lenji ghamba yakuyaku. Uu na uu va thɨ rimbun weya Eron, thiye va ravowovowoŋgi na thɨ wo lenji ghamba yakuyaku ghembayaworo na ghembato weŋgiya wabwike thiyake — Juda, Simiyon na Benjamin. ");
INSERT INTO tgo_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","Kohat gha uu e tɨne vavanakova, thɨ wo lenji ghamba yakuyaku ghembayaworo weŋgiya wabwi Ipɨreim, Den na Manase, i ghembeghembeya yalasiko. ");
INSERT INTO tgo_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","Uu Gereson va thɨ wogiya weŋgi ghembaghemba ghembayaworo na ghembato e wabwike thiyake lenji ghamba yakuyaku e tɨne: Isaka, Asa, Napɨtalai na Epreim valɨvaŋga e boimako. ");
INSERT INTO tgo_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","Uu Merari va thɨ wogiya weŋgiya ghembaghemba ghembayaworo na ghembaiwo e wabwike thiyake lenji ghamba yakuyaku e tɨne: Rubin, Gad na Sebulon. ");
INSERT INTO tgo_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","E varɨvarɨke varɨiwoke lenji woraŋgiya e tɨne, Isirel gharɨgharɨniye thɨ wogiya ghembaghembake thiyake na thetheghan lenji ghamba ghan, wabwi Livai weŋgi ŋgora Giya Loi va le utuutu weya Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","Wabwi Juda na Simion lenji ghamba yakuyaku e tɨne va thɨ giya ghembaghembake idaidanji thiyake: ");
INSERT INTO tgo_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","weŋgiya Eron orumburumbuye, thiye thɨ rimbun Kohat gha uu tɨne, iye i rimbun weya Livai. Thiye va thɨ giyakaiya lenji ghamba yakuyaku ŋgoreiya varɨvarɨma lenji woraŋgiya. ");
INSERT INTO tgo_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","Va thɨ giya weŋgiya ghembaghemba thiyake: Kiriyat Aba (o Hebron) na thetheghan lenji ghamba ghan e ghadidiye. Va ina e bobokuluko vanautumaniye, wabwi Juda lenji ghamba yakuyaku e tɨne (Aba iye Anak nariye). ");
INSERT INTO tgo_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","Ko iyemaeŋge ghembako laghɨye iyako na thetheghanɨko lenji ghamba ghan weiye ghembaghemba nanasiye evasiwae kaerova Keleb Jepune nariye i wo le ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","Vama thɨ wogiya Hebron (iye ghemba laghɨye ratagavamare lenji ghamba kubaro) na e vwata mbowo thɨ giyava thiyake weŋgiya Eron orumburumbuye: Libɨna, ");
INSERT INTO tgo_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","Jati, Estemowa, ");
INSERT INTO tgo_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","Holon, Debi, ");
INSERT INTO tgo_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","Ain, Juta na Bet Semes, weiye thetheghan lenji ghamba ghan. Ghembasiwoko thiyake inanji wabwi Juda na Simiyon e lenji ghamba yakuyaku tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","Wabwi Benjamin e lenji ghamba yakuyaku tɨne thɨ giya ghembaghembake thiyake weŋgi: Gibiyon, Geba, ");
INSERT INTO tgo_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","Anatot na Alɨmon weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","Iya ghembayaworo na ghembatoke thiyake na thetheghan lenji ghamba ghan, thɨ giya weŋgiya ravowovowo thɨ rimbun weya Eron. ");
INSERT INTO tgo_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","Kohat gha uu vavanava thɨ giya ghembaghemba laghɨlaghɨye na lenji ghamba yakuyaku, wabwi Ipɨreim lenji ghamba yakuyaku e tɨne. Iya ghembaghembake thiyake: ");
INSERT INTO tgo_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","inanji e bobokulu vanautumaniye, wabwi Ipɨreim lenji ghamba yakuyaku e tɨne: thɨ wogiya Sekem (ratagavamare lenji ghamba kubaro) na Geja, ");
INSERT INTO tgo_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","Kibɨjaim na Bet Horon, ghembavarɨ weiye thetheghan lenji ghamba ghanɨ. ");
INSERT INTO tgo_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","Na tembe ŋgoreiyeva wabwi Den lenji ghamba yakuyaku e tɨne thɨ wo Elɨteke, Gibeton, ");
INSERT INTO tgo_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","Aijalon na Gat Rimon, ghembavarɨ weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","Manase gha wabwi lenji valɨvaŋga e yalasiko, thɨ wo Tanak na Gat Rimon, ghembaiwo weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","Iya vara ghembayaworoke thiyake weinji thetheghan lenji ghamba ghan, uu Kohat thɨ mban lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","Mbowo uu reghava, Gereson i rimbun Livai e ghawabwi tɨne thɨ mbana lenji ghamba yakuyaku wabwi Manase, e boimako lenji ghamba yakuyaku tɨne ghembaghembake thiyake: Golan ina Basan e tɨne (ratagavamare lenji ghamba kubaro) na Be Estera, ghembaiwo weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","Wabwi Isaka lenji ghamba yakuyaku e tɨne thɨ mbana ghembaghemba ghembavarɨke thiyake: Kisiyon, Daberat, ");
INSERT INTO tgo_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","Jamut na En Ganim, weiye thetheghan lenji ghamba ghanɨ. ");
INSERT INTO tgo_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","Wabwi Asa lenji ghamba yakuyaku e tɨne thɨ mbana ghembavarɨke thiyake: Misal, Abɨdon, ");
INSERT INTO tgo_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","Helɨka na Rehob, weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","Wabwi Napɨtalai lenji ghamba yakuyaku e tɨne thɨ mbana ghembatoke thiyake: Kades, Galili e tɨne, weiye thetheghan lenji ghamba ghanɨ (ratagavamare lenji ghamba kubaro), Hamot Do, na Katan, weiye thetheghan lenji ghamba ghanɨ. ");
INSERT INTO tgo_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","Uu regha na regha Gereson e tɨne, thɨ mbanɨŋgiya ghembayaworo na ghembato, weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","Wabwi Livai e tɨne uu vavanakova — Merari gha uu thɨ mbana ghembavarɨ weŋgiya wabwi Sebulon lenji ghamba yakuyaku e tɨne. Ghembaghembake thiyake: Jokɨneyam, Kata, ");
INSERT INTO tgo_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","Dimɨna na Nahalal, weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","Wabwi Rubin lenji ghamba yakuyaku e tɨne thɨ mbana ghembavarɨke thiyake: Beja, Jahajɨ, ");
INSERT INTO tgo_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","Kedemot na Mepat, weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","Wabwi Gad lenji ghamba yakuyaku e tɨne thɨ mbana ghembavarɨke thiyake: Ramot ina Galili e tɨne, weiye thetheghan lenji ghamba ghan (ratagavamare lenji ghamba kubaro), Mahanaim, ");
INSERT INTO tgo_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","Hesbon na Jaje, weiye thetheghan lenji ghamba ghan. ");
INSERT INTO tgo_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","Wabwi Merari thɨ mbana lenji ghamba yakuyaku ghembayaworo na ghembaiwo. ");
INSERT INTO tgo_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Ghembaghembako iya tari Livai lenji ghamba yakuyaku, inanji Isirel gharɨgharɨniye e lenji ghamba yakuyaku tɨne ghembaevarɨ na ghembawa, weiye thetheghan lenji ghamba ghan e ghadɨdɨnji. ");
INSERT INTO tgo_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","Ghemba regha na regha thetheghan lenji ghamba ghan vambe inanjiva e ghadɨdɨnji; iyake emunjoru e ghemba regha na regha tɨne. ");
INSERT INTO tgo_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Kaero Giya Loi i wogiya thelauko iyava i tholo na i dagerawe weŋgiya Isirel gharɨgharɨniye orumburumbunji. Mbaŋa kaero thɨ wo ghamba yakuyakuko iyako amba thiya roghabanawe. ");
INSERT INTO tgo_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Giya Loi i vakatha lenji yakuyaku i thovuye na thɨ vanevane e valɨvaŋgako laghɨye iyako e tɨne, iya Giya Loi vama i dagerako weŋgiya orumburumbunji ne i wogiya weŋgi. Ma tembe ghanjithɨghɨyaŋgiko regha i yondo virɨ na i gaithɨva weŋgi, kaiwae Giya Loi kaerova i vakathaŋgi na thɨ kivwalavaoŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Giya Loi i vamboromboro le dagerako wolaghɨye iyava i dagerako weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Amba Josuwa i kula vathaŋgiya wabwi Rubin, wabwi Gad na wabwi Manase vaŋgothiye, ");
INSERT INTO tgo_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","na i dage weŋgi iŋa, “Kaero mendava hu vakathavao bigibigike wolaghɨye, Giya Loi le rakakaiwo Mosese va i dage e ghemi na hu vakathaŋgi, na tembe ŋgoreiyeva hu ghambugha bigibigike wolaghɨye ghino va ya utuŋa na hu vakatha. ");
INSERT INTO tgo_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Kaero mbaŋa molao moli ghaghad vara mbaŋake iyake, ma mbaŋa regha hu goriwoyathuŋgiya lemi valɨ bodaboda Isirel gharɨgharɨniye. Iyemaeŋge, mendava hu vamboromboro budakaiya Giya lemi Loi va i wogiya e ghemi na hu vakatha. ");
INSERT INTO tgo_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Mbaŋake iyake Giya lemi Loi kaero i wogiya towo weŋgiya lemi valɨ bodabodake ŋgoreiya va le dagerawe. Hu raka njogha e lemi ghamba yakuyaku, e thelauko iyava Giya Loi le rakakaiwo, Mosese vama i wogiyako e ghemi Jorɨdan valɨvaŋga e boimako. ");
INSERT INTO tgo_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Ko iyemaeŋge mbe hu njimbukiki wagiyawe budakaiya Giya Loi va utuŋa e ghemi, hu vakatha na hu ghambugha mbaroko Giya Loi le rakakaiwo va i utugiya e ghemi. Va iŋa, ‘Hu gharethova Giya lemi Loi e gharemina laghɨye na e unemina laghɨye.’” ");
INSERT INTO tgo_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","Amba Josuwa i giya ghanjidagemwaewo na i variyeŋgi thɨ raka njogha e lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","Weŋgiya wabwi Manase vaŋgothiye regha Mosese vama i wogiya lenji ghamba yakuyaku Jorɨdan valɨvaŋga e boimako, na weŋgi vaŋgothiye, Josuwa va i wogiya lenji ghamba yakuyaku Jorɨdan valɨvaŋga e yalasiko weinjiyaŋgiya lenji valɨ bodaboda. Mbaŋa kaero i giyavao ghanjidagemwaewo, i variyeŋgi na ");
INSERT INTO tgo_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","iŋa, “Hu raka njogha e lemi ghamba yakuyaku weiye lemi bigibigi lemoyo moli, lemi thetheghan lemoyo moli, lemi silva, gol, brons na aiyan, na kwamakwamama lemoyo moli. Mbe vohu vegiya lemi bigibigina weŋgiya lemi valɨ bodaboda iya mendava hu mban weŋgiya ghami rathɨghɨyaŋgina.” ");
INSERT INTO tgo_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Kaero gharɨgharɨko thiye wabwi Rubin, wabwi Gad na wabwi Manase vaŋgothiye e boimako thɨ vewareriŋa lenji ghamba yakuyaku. Thɨ raka iteteŋaŋgiya lenji valɨ Isirel gharɨgharɨniye Sailo, Kenani e thelauniye, na thɨ wareriŋa mbe thiye lenji thelau ina Giliyad e thelauniye tɨne, iya vama thɨ woko ŋgoreiya Giya Loi vama i dage weya Mosese. ");
INSERT INTO tgo_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Mbaŋa wabwi Rubin, wabwi Gad na wabwi Manase vaŋgothiye e boimako thɨ raka vutha Gelilot, ina Jorɨdan valɨvaŋga e yalasiko, kaero thɨ vatada ghamba vowo laghɨye regha na gha yamoyamo i thovuye gheko e walaghɨtako ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","Mbaŋa lenji valɨ Isirel gharɨgharɨniyeko thɨ loŋwe vaidiya iyako, thɨŋa, “Wo hu vandeŋe! Gharɨgharɨma wabwi Rubin, wabwi Gad na wabwi Manase e boimako kaero thɨ vatada ghamba vowo Gelilot e tɨne, Jorɨdan ghadidiye ghinda ela valɨvaŋgake.” ");
INSERT INTO tgo_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","Amba ghɨmoghɨmoruko wolaghɨye e uuko wolaghɨye valɨvaŋga e yalasiko thɨ raka vathavatha Sailo e tɨne, na vethɨ gaithɨ weinjiyaŋgiya wabwiko theghewo na Manase vaŋgothiye iya weinjiyaŋgi valɨvaŋga e boimako. ");
INSERT INTO tgo_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","14","Amba gharɨgharɨ inanji wabwi theyaworoma e tɨnenji thɨ variyeŋgiya gharɨgharɨ vavana weŋgiya wabwi Rubin, wabwi Gad na wabwi Manase i vorovoro e thelau Giliyad tɨne. Va thɨ variya Pinehas, Eliyesa ravowovowo nariye, weiyaŋgiya randeviva regha iya e uu regha na regha tɨne. Iya uu regha na regha lenji randeviva theyaworoke thiyake, ghanji yavwatata i laghɨye e uu regha na regha tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Mbaŋa thɨ raka mena Giliyad ele valɨvaŋga, weŋgiya wabwi Rubin, wabwi Gad na wabwi Manase i vorovoro, amba thɨ utu weŋgi thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“Giya Loi le gharɨgharɨ e idanji wo utu weŋga. Buda kaiwae hu goriwoyathu Giya Loi na hu vatada ghamba vowo mbe ghemi kaiwami? Buda kaiwae na hu botewayathu Isirel lenji Loi na hu vakatha tharɨ ŋgoreiyako? ");
INSERT INTO tgo_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","Wo hu renuwaŋa tharɨma va ra vakatha Peyo e tɨne, na ghambwera raitharɨ regha i yomara na i gaboŋgiya gharɨgharɨ lemoyo moli. Iyako kaiwae mbaŋake mbe ra vavaidiya vuyowae. Ko amba ma valɨkaiwanda iya tharɨko iyako? ");
INSERT INTO tgo_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Na e mbaŋake iyake kaero hu botewava Giya Loi gha ghambu? Thoŋgo hu goriwoyathu Giya Loi noroke, mbe evole vara ma i ghatemuru weŋgiya Isirel gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Thoŋgo thelauna iya va hu wona ma valɨkaiwae hu kururuwe, hu raka mena Giya Loi ele thelauko tɨne iya le Mevathavathako Ŋgoloniye inawe, na hu mbana thelau vavana e tɨnemeko. Ko iyemaeŋge thava hu goriwoyathu Giya Loi na hu goriwoyathuime na hu vatada ghamba vowo mbe ghemi kaiwami, naka ghamba vowoko iya Giya la Loi kaiwaeko, iya kaero inakowe. ");
INSERT INTO tgo_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Hu renuwaŋakiki mbaŋa Eikan Jera nariye mava i ghambugha mbaro. Giya Loi va i dage weinda na iŋa, ‘Hu mukuwo bigibigina wolaghɨye, e ghembana laghɨye Jeriko e tɨne.’ Iyako kaiwae Giya Loi i wogiya vuyowo taulaghɨke weinda. Eikan le vakathako raitharɨ kaiwae maa vambe ghamberegha eŋge i vaidiya mare.” ");
INSERT INTO tgo_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Amba wabwi Rubin, wabwi Gad na wabwi Manase vaŋgothiye e boimako thɨ giya lenji thombe weŋgiya randeviva wabwi regha na regha weŋgi, na uu regha na regha valɨvaŋga e yalasiko e tɨnenji, thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“Loi mbe Reghaeŋge Vurɨvurɨghegheniye! Iye Giya! Loi mbe Reghaeŋge Vurɨvurɨghegheniye! Iye Giya! I ghareghare buda kaiwae menda wo vakatha iyake, na nuwameiya ghemi tembe hu ghareghareva! Thoŋgo menda wo goriwoyathu na ma wo vatada lama loŋweghathɨ weya Giya Loi, mbema hu gabovaoime eŋge! ");
INSERT INTO tgo_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","Thoŋgo ma menda wo ghambugha Giya Loi na wo vatada ghamamberegha lama ghamba vowo na wo ŋambu lama vowowe, o wo vakaiwoŋa lama mwaewo wit mbombouyewe o lama mwaewo vɨghathɨ vowoniye, hu viyathu na Giya Loi tembe ghamberegha i giya vuyowo weime.” ");
INSERT INTO tgo_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","“Nandere! Menda wo vakatha iyake kaiwae wo mararu ne iwaeŋge mbaŋa i menamenako orumburumbumi tha muyaiko ne thɨ dage weŋgiya ghime orumburumbume na thɨŋa, ‘Budakai vara ne hu vakatha weya Giya, Isirel le Loi? ");
INSERT INTO tgo_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Amalaghɨniye va i vakatha Jorɨdan i tabo teghala weinda, ghime na ghemi uu Rubin na uu Gad. Ma tembe valɨkaiwamiva hu vakatha bigi regha weya Giya Loi.’ Mbwatavole orumburumbumi thɨ vakatha orumburumbume thɨ viyathu Giya Loi gha mararu.” ");
INSERT INTO tgo_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“Iya kaiwae woŋa, ‘Wo ra vatada ghamba vowo, ko ma woŋa mwaewo ghamba ŋambu o vowo kaiwae.’ ");
INSERT INTO tgo_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","Ko iyake, ŋgoreiya nono ghime na ghemi e ghanda lughawoghawo na tha na tha muyaiko, mbema emunjoru wo kururu weya Giya Loi e Mevathavatha Ŋgoloniye boboma weiye mwaewo gha ghambu kaiwae, na weiye vowo na vɨghathɨ ghanjimwaewa kaiwaeva. Ambane mbaŋa muyaiko orumburumbumi mane valɨkaiwanji thɨ dage weŋgiya ghime orumburumbume na thɨŋa, ‘Ma tembe valɨkaiwamiva hu vakatha bigi regha weya Giya Loi.’” ");
INSERT INTO tgo_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","“Va lama renuwaŋa woŋa, ‘Thoŋgo nevole i yomara ŋgoreiyako, orumburumbume valɨkaiwanji ne thɨ thombe weŋgi ŋgoreiyake: Wo hu thuwe! Orumburumbume tha mevivako va thɨ vatada ghamba vowo Giya Loi kaiwae. Mava mwaewo ghanjighamba ŋambu o vowo kaiwae, ko iyemaeŋge ŋgoreiya nono ghime na ghemi e ghanda lughawoghawo.’ ");
INSERT INTO tgo_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","“Emunjoru ma tembe valɨkaiwameva wo goriwoyathu Giya Loi o wo viyathu gha ghambu noroke na wo vatada ghamba ŋambu vowo mwaewoŋgi, wit na vowoŋgi kaiwanji. Mane valɨkaiwae wo vatada tembe ghamba vowo reghava, nakama ghamba vowoko Giya La Loi kaiwae iya i ndeghathɨ Mevathavatha Ŋgoloniye e ghamwaeko.” ");
INSERT INTO tgo_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Mbaŋa Pinehas iye ravowovowo, na randeviva laghɨlaghɨye theyaworo va thɨ raka menako weinji e uu regha na regha valɨvaŋga e yalasiko, randeviva regha na regha e wabwi regha na regha e tɨnenji, thɨ vandeŋe budakaiya wabwi Rubin, wabwi Gad na wabwi Manase vaŋgothiye e boimako lenji utuutuko, kaero thɨ wovatha. ");
INSERT INTO tgo_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Pinehas, iye Eliyesa ravorovoro nariye, i dage weŋgiya wabwi Rubin, Gad na Manase vaŋgothiye, iŋa, “Mbaŋake kaero wo ghareghare Giya Loi iye weinda, kaiwae ma menda hu goriwoyathu e kamwathɨke iyake. Kaero menda hu vamoruŋgiya Isirel gharɨgharɨniye Giya Loi ele ghatemuru tɨne.” ");
INSERT INTO tgo_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Amba Pinehas na randevivaŋgima thɨ raka iteteŋgiya wabwi Rubin na wabwi Gad gharɨgharɨniye e thelau Giliyad tɨne na thɨ raka njogha Kenani ele valɨvaŋga, weŋgiya Isirel gharɨgharɨniye na thɨ utu giya toto weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Weinji lenji warari thɨ vandeŋe lenji utuutuko na thɨ tarawe Loi. Na ma tembe thɨ utuŋava thɨ gaithɨ weinjiyaŋgiya wabwi Rubin na wabwi Gad gharɨgharɨniye na thɨ mukuwo lenji ghamba yakuyakuko. ");
INSERT INTO tgo_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Wabwi Rubin na wabwi Gad gharɨgharɨniye thɨ uno ghamba vowoko iyako idae “Nono e ghanda lughawoghawoke,” Giya iye Loi. ");
INSERT INTO tgo_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Mbaŋa molao moli kaero iko, Giya Loi i giya vanevane weŋgiya Isirel gharɨgharɨniye na thɨ towo weŋgiya ghanji rathɨghɨyako wolaghɨye evasiwanjiko. E mbaŋako iyako Josuwa kaero i amalaghɨsarɨ moli, ");
INSERT INTO tgo_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","kaero i kula vathaŋgiya Isirel uu na uu lenji randevivaŋgiko wolaghɨye: ghanjigiyagiyako, lenji randevivaŋgiko, kot gha ravakathaŋgi na gharɨgharɨ lenji rakakaiwoŋgi, na i dage weŋgi iŋa, “Kaero ya amalaghɨsarɨ moli wo theghathegha kaero i laghɨye e mbaŋake iyake. ");
INSERT INTO tgo_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Kaerova hu thuwevao bigibigike wolaghɨye Giya lemi Loi va i vakatha weŋgiya vanautumake wolaghɨye kaiwami. Giya lemi Loi va i gaithɨ ghemi kaiwami. ");
INSERT INTO tgo_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Kaerova ya wogiya e ghemi uu na uu thelauko laghɨye Jorɨdan valɨvaŋga e boimako ghaghad Njighɨ Meditareiniyan, valɨvaŋga e yalasiko, na lemi ghamba yakuyaku. Vama ya wogiya e ghemi thelauko laghɨye vanautuma na vanautuma lenji ghamba yakuyaku iya vama ra kivwalaŋgiko, na tembe ŋgoreiyeva the vanautumaŋgi amba mava ra kivwalaŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Giya lemi Loi ne i vakathaŋgi thɨ voiteteŋga, na ne i vambele yathuŋgi na ghemi hu rakaru. Ne hu wo lenji ghamba yakuyaku ŋgoreiya Giya lemi Loi va le dagera weŋga. ");
INSERT INTO tgo_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“Iya kaiwae, mbe hu ghambu na hu vakatha wagiyawe bigibigina wolaghɨye kaerova thɨ rori njoŋa Mosese e le Mbaro gha buk tɨne. Ne hu ndeghamaraviyathu valɨvaŋga regha. ");
INSERT INTO tgo_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Ne hu ndevɨghathɨ weimiyaŋgiya gharɨgharɨko iya mbe inanji e tɨnemina, na ne hu ndetholo lenji loiko e idaidanji, ne hu ndekururu o naŋgo weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Iyemaeŋge, mbe hu vikikighathɨ vara Giya Loi ŋgoreiya va hu vakavakatha ghaghad noroke. ");
INSERT INTO tgo_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“Giya Loi kaero i vagege yathuŋgiya vanautuma laghɨlaghɨye na vurɨvurɨghegheŋgi e ghamwami, na hu rakarakaru, na ma tembe regha valɨkaiwaeva i gaithɨ weŋga. ");
INSERT INTO tgo_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","The lolothan e tɨnemina, valɨkaiwae i vakatha hweserithaŋarɨ thɨ raka vo, kaiwae Giya lemi Loi iye i gaithɨ kaiwami, ŋgoreiya va le dagerawe. ");
INSERT INTO tgo_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Mbe hu njimbukiki wagiyawe na hu gharethovuwe Giya lemi Loi. ");
INSERT INTO tgo_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“Ko iyemaeŋge thoŋgo hu ndeghereiyewana na hu tubwe weimiyaŋgiya vanautumako thiyako gharɨgharɨniye iya mbe inanji e tɨnemina, na hu veghe weimiyaŋgi, ");
INSERT INTO tgo_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","amba ne hu ghareghare Giya lemi Loi mane tembe i vagege raŋgiyaŋgiva gharɨgharɨko thiyako, na ghemi hu wo lenji ghamba yakuyakuko. Iyemaeŋge, ne thɨ tabo lemi ghamba dobuŋgi, ŋgoreiya ghaithɨ o doda kaiwami na virɨniye ŋgoreiya gheyabɨyabɨbɨ e wakɨnimi, na mbɨthɨmbɨthɨ maramara e marami, ghaghad ma tembene ghemina regha i yakuyakuva e thelauke thovuye iya Giya lemi Loi vama i wogiyake e ghemi. ");
INSERT INTO tgo_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“Wo mbaŋa mare maiya vara. Taulaghɨna ghemi hu ghareghare e gharemi na e unemi Giya lemi Loi kaerova i giya e ghemi bigibigike thovuthovuye wolaghɨye iyava i dageraweko. Dagerawe regha na regha va i vakatha i vamboromboro, ma tembe reghava i tagavakwara. ");
INSERT INTO tgo_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Ko iyemaeŋge ŋgoreiya va i vamboromboro dageraweko thovuthovuye wolaghɨye e ghemi, tembene i vakathava ŋgoreiye e the tharɨ hu vakatha na i vamararuŋga ghaghad ne i mukuwoŋga e thelauke thovuye iyava i wogiyake e ghemi. ");
INSERT INTO tgo_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Thoŋgo hu kivwala Giya lemi Loi le dagerawe iyava va utu giyana e ghemi, na ma vohu kaiwo weva loi vavana na hu kururu weŋgi, Giya le ghatemuru ne i yomara e ghemi, na mane mbaŋa molao ma huya marevao e thelauke thovuye iya va i wogiyake e ghemi.” ");
INSERT INTO tgo_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Josuwa i kula vathaŋgi Isirel gha uuko wolaghɨye na thɨ raka mena thɨ mevathavatha Sekem e tɨne. Mbaŋa thɨ raka vuthavao, i ghatha raŋgiyaŋgi ghanji giyagiyako, lenji randevivaŋgi, kot gha ravakathaŋgi na Isirel lenji rakakaiwo laghɨlaghɨye na thɨ raka mena na thiya ndeghathɨ Giya Loi ele Yoŋathowathowa Boboma ghamwae. ");
INSERT INTO tgo_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Amba Josuwa i dage weŋgi gharɨgharɨko wolaghɨye, iŋa, “Giya Loi, Isirel lenji Loi ghalɨŋae ŋgora iyake, ‘Mbaŋa mevivako olemi tatanakau va thiya yaku e Walaghɨta Iupreitis valɨvaŋga e boimako na thɨ kururu weŋgi loi kwanɨkwan. Lemi tatanakauko thiyako regha va idae Tira, Eibraham na Naho ramanji. ");
INSERT INTO tgo_vpl VALUES ("JS24_3a","007_24_3a","JOS","24","3a","3a","Ko iyemaeŋge va ya vaŋguraŋgiya lemi tanakau Eibraham, Iupreitis valɨvaŋga e boimako na ya vaŋgughatharaŋa e thelauko laghɨye, Kenani tɨne. Ya giyawe orumburumbuye lemoyo.’” ");
INSERT INTO tgo_vpl VALUES ("JS24_3b","007_24_3b","JOS","24","3b","3b","Ya wogiyawe nariye idae Aisake, ");
INSERT INTO tgo_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","na weya Aisake ya giya le ŋgaŋga theghewo — Jeikob na Iso. Ya wogiyawe Iso vanautuma e ououniye idae Idom na le ghamba yakuyaku, ko iyemaeŋge Jeikob na le ŋgamaŋgama va thɨ raka Ijipt. ");
INSERT INTO tgo_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Va mbaŋa reghava ya variyeŋgi Mosese na Eron, amba ya giya vuyowo laghɨye weŋgi Ijipt gharɨgharɨniye, na ya vaŋgu raŋgiyaŋga. ");
INSERT INTO tgo_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Mbaŋa va ya vaŋgu raŋgiyaŋgi orumburumbumi Ijipt e tɨne, Ijipt lenji ragagaithɨ thɨ raka reghamba weŋgi e waŋga momod na hosɨ ghanjirathatha lemoyo, ghaghad thɨ raka mena Njighɨ Sosoro ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Ko iyemaeŋge orumburumbumi thɨ kula voro weya Giya Loi thalavu kaiwae na i variye momouwo e ghemi na thiye ghami lughawoghawo. I vakatha njighɨko na i bebe varɨvarɨŋgi. Kaero hu ghareghare va ya vakatha budakai weŋgi Ijipt gharɨgharɨniye. Amba hu yayaku e vuruvuru vwatavwata mbaŋa molao moli. ");
INSERT INTO tgo_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Amba ya vaŋgu menaŋga Amori e lenji thelau, iyava thiya yaku Jorɨdan valɨvaŋga e boimako. Va thɨ gaithɨ weŋga, ko iyemaeŋge ya vakathaŋga na hu vurɨgheghe kivwalaŋgi. Ya mukuwoŋgi e ghamwami na hu wo lenji thelauko lemi ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Amba Balak Jipo nariye, iye Mowab lenji kiŋ, i vivatha na i gaithɨ weŋga. I variye utuwe Balaam Beo nariye na i naŋgowe i guraŋga. ");
INSERT INTO tgo_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Ko iyemaeŋge mava ya vatomwewe na i guraŋga, vambema i giyagiya eŋge ghami dage mwaewo na ya vaŋgu raŋgiyaŋga Balak e nɨmae ghare. ");
INSERT INTO tgo_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“‘Amba hu raka lawa Jorɨdan na hu raka voro Jeriko. Ghɨmoghɨmoru e ghembako iyako thɨ gaithɨ weŋga, na tembe ŋgoreiyeva wabwi Amori, wabwi Perisi, wabwi Kenani, wabwi Hiti, wabwi Gegasi, wabwi Hivi na wabwi Jebusi, ko iyemaeŋge ya vakathaŋga na hu kivwalavaoŋgi. ");
INSERT INTO tgo_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","E ghamwami va ya vathɨna gharenji, na valɨkaiwae hu kivwalaŋgi Amori lenji kiŋ theghewo. Mava hu vakatha iyako mbe ghemi e lemi gaithɨ gha ghalithɨ na mbwenara. ");
INSERT INTO tgo_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","“‘Va ya wogiya e ghemi thelauko iya mava hu ndekabu mun ghanɨŋgawe na ghembaghemba mava hu vatadɨŋgi. Mbaŋake kaero huya yaku e tɨnenji na hu ghana vaen uneunenji na olivɨ uneunenji iya mava hu kabuŋgi.’ ");
INSERT INTO tgo_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“Iya kaiwae, mbaŋake iyake mbe hu yavwatatawana Giya Loi na hu kaiwowe weiye yawalɨmina laghɨye na lemi gharevatomwe emunjoru. Hu bigi yathuŋgi loina iya orumburumbumi va thɨ kurukururu weŋgi Masepoteimiya na Ijipt e tɨnenji, na hu kaiwowe Giya Loi mbe ghamberegha eŋge. ");
INSERT INTO tgo_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Thoŋgo Giya Loi gha ghambu ma i laghɨye e gharemina, mbe noroke vara hu ghatha vakatha the loi ne hu kaiwowe, loiŋgiko iya orumburumbumi va thɨ kurukururu weŋgi Masepoteimiya e tɨne, o loiŋgi iya Amori gharɨgharɨniye thɨ kururuke weŋgi, iya lenji thelau huya yakuwe mbaŋake. Ko iyemaeŋge ghino na lo ŋgoloke gharayakuyaku ne wo ghambu Giya Loi.” ");
INSERT INTO tgo_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Gharɨgharɨko thɨ gonjoghawe, thɨŋa, “Ma valɨkaiwae tembe wo roiteteva Giya Loi na wo ghambu loi vavana! ");
INSERT INTO tgo_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Giya Loi lama Loi ghamberegha va i vaŋguraŋgiyaŋgi orumburumbume na ghime mbaŋa va wo tabona rakakaiwobwaga Ijipt e tɨne, na wo thuweŋgi vakatha amba rotaele laghɨlaghɨye va i vakathaŋgi. Va i njimbukiki wagiyaweime na i gana tenɨtenime weŋgi gharɨgharɨ e vanautumako wolaghɨye iyava wo raka ru e tɨnenjiko. ");
INSERT INTO tgo_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Giya Loi va i vagege raŋgiyaŋgi vanautumako wolaghɨye e ghamwame tembe ŋgoreiyeva Amori gharɨgharɨniye iyava thiya yaku gheko. Iya kaiwae ghime tembe ŋgoreiyeva ne wo ghambu Giya Loi; kaiwae iye lama Loi.” ");
INSERT INTO tgo_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Josuwa i dage weŋgi gharɨgharɨko na iŋa, “Mbwata mane valɨkaiwami hu ghambu Giya Loi. Iye i boboma, na iye Loi yamwayamwakabuniye. Lemi goriwoyathu na lemi tharɨna wolaghɨye mane i numoten. ");
INSERT INTO tgo_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Thoŋgo hu roitete Giya Loi na mavohu kaiwo weŋgiva gharɨgharɨ vavana lenji loi vatavatadɨ, ne i gaithɨ wanaŋga na i giya vuyowo weŋga. Ne i mukuwoŋga moli othembe va i thovuye moli e ghemi.” ");
INSERT INTO tgo_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Ko iyemaeŋge gharɨgharɨko wolaghɨye thɨ dagewe Josuwa, thɨŋa, “Nandere! Ne wo ghambu Giya Loi.” ");
INSERT INTO tgo_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Josuwa i dage weŋgi, iŋa, “Tembene ghamimbereghanava hu utuŋa emunjoru va hu tuthi ne hu ghambu Giya Loi.” Thɨ gonjoghawe thɨŋa, “Mbwana, mbe ghamamberegha vara wo utuŋaime.” ");
INSERT INTO tgo_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Amba Josuwa, iŋa, “Mbaŋake hu bigiyathuvao gharɨgharɨna vavana lenji loiŋgi iya inanjina weŋga na hu vatomweŋga emunjoru weya Giya Loi, Isirel lenji Loi.” ");
INSERT INTO tgo_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Gharɨgharɨko thɨŋa, “Ne wo kaiwowe Giya Loi la Loi na wo ghambu.” ");
INSERT INTO tgo_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","E mbaŋako iyako Josuwa i ndeghathɨ gharɨgharɨko kaiwanji na i vakatha dagerawe thiye na Giya Loi e ghanjilughawoghawo Sekem e tɨne, na tembe ghekova i vakatha mbaro vavana na gharɨgharɨko ne thɨ ghambu. ");
INSERT INTO tgo_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Josuwa i rori njogha utuutuŋgiko thiyako Giya Loi le Mbaro gha Buk tɨne. Amba i wo varɨ laghɨye regha na i worawe e umbwa ouk raberabe, Giya Loi le Mevathavatha Ŋgoloniye evasiwae. ");
INSERT INTO tgo_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Kaero Josuwa i dage weŋgi gharɨgharɨko, iŋa, “Varɨke iyake ne i tabo na ghanda rautuutu, kaiwae me loŋwevao utuutuko wolaghɨye Giya Loi me utuŋako weinda. Iyake ne i tabo ghami rautuutu na i vakathaŋga thava hu goriwoyathu lemi Loi.” ");
INSERT INTO tgo_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Amba Josuwa i variye yathuŋgi gharɨgharɨko wolaghɨye, uu na uu e lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Bigibigiko wolaghɨye thiyako e ghereinji, Josuwa Nan nariye i mare, gha theghathegha vama i wo hothaŋarɨ na hoyaworo. ");
INSERT INTO tgo_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Vambe thɨ beku amalaghɨniye ele thelau Timɨna Sera e tɨne, e vanautuma ououniye uu Epreim lenji ghamba yakuyaku e tɨne, Ou Gaas e ghaiwabuniyeko. ");
INSERT INTO tgo_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Isirel gharɨgharɨniye va thɨ ghambu Giya Loi mbaŋa Josuwa na randevivaŋgiko, iyava thɨ thuwevao bigibigiko wolaghɨye Giya Loi va i vakathako weŋgi Isirel gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Mevivako Isirel gharɨgharɨniye lenji tanakau regha Jeikob, va i vamodo thelau vuvura weŋgiya Hamo le ŋgamaŋgama ghɨmoghɨmoru, modae le laghɨlaghɨye silva ghethɨthaŋarɨ. Mbaŋa Isirel gharɨgharɨniye thɨ raka iteta Ijipt, thila mbana lenji tanakau regha, Josep wakɨwakɨye. Vambe thɨ mbanɨmba loloŋga vara e lenji loŋgaloŋgako wolaghɨye tɨne. E mbaŋako vara iyako thɨ beku e thelauko iya vuvurako iyako tɨne, iya Jeikob va i vamodoko Sekem e tɨne. Thelauko iyako Josep orumburumbuye lenji ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Eliyesa, Eron rumbuye vambe i mareva na thɨ beku e ghemba idae Gibeya. Ghembake iyake ina e vanautuma e ououniye uu Epreim lenji ghamba yakuyaku e tɨne. Ghembako iyako vama thɨ wogiyawe Eliyesa nariye, Pinehas. ");
INSERT INTO tgo_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Va e mbaŋako iyako, mbaŋaniya giyagiya ghanji mbaŋa thɨ mbaro, dagabora i yomara e vanautumako iyako tɨne. Iya kaiwae amala regha rara Betɨlehem, Juda e tɨne, weiyaŋgiya levo na le ŋgaŋga theghewo, thɨ gara na wo vethɨ yaku vanautuma regha idae Mowab na vethɨ meghala vuyowoko iyako gheko. ");
INSERT INTO tgo_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Amalake idae Elimelek, levo idae Naomi na lenji ŋgaŋga theghewo, idaidanji Malon na Kiliyon. Thiye uu Eprat, thɨ mena Betɨlehem, Juda e tɨne. Va thɨ wa Mowab na mbowo vethɨ yaku mbaŋa ubotu gheko. ");
INSERT INTO tgo_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Mbaŋa inanji gheko Elimelek i mare, na Naomi mbema ghamberegha eŋge weiyaŋgiya le ŋgaŋgama theghewoma. ");
INSERT INTO tgo_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ghɨmoghɨmoruke thiyake va vethɨ ghe gheko — thɨ vaŋguŋgiya Mowab wanakauniye theunyiwo. Eunda idae Opa na eunda idae Rut. Lenji yakuyaku gheko vama i wo ŋgoreiya theghathegha hoyaworo, ");
INSERT INTO tgo_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","na Malon na Kiliyon tembe thɨ mareva. Naomi vambema ghamberegha eŋge vara, le ŋgaŋgama kaero nandereŋgi na le ghɨmoru tembe ŋgoreiyeva. ");
INSERT INTO tgo_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Mbaŋa Naomi amba ina Mowab e tɨne, kaero i loŋwa toto ghambae gharɨgharɨniye utuninji, Giya Loi kaero i mwaewo weŋgiya le bodaboda, na ghanɨŋga kaero veimaimava weŋgi. Iya kaiwae Naomi na oyawanyiye thɨ vivatha na thɨ roiteta Mowab. ");
INSERT INTO tgo_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Weiyaŋgiya oyawanyiyema theunyiwoma, Naomi i iteta ghembama va thɨ yakumawe, i reŋa e kamwathɨma iya i wa na ve raŋgima Judiya. ");
INSERT INTO tgo_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ko iyemaeŋge e kamwathɨ mborowae, amba Naomi i dage weŋgiya oyawanyiyema iŋa, “Ghemi themiunyiwona hu njogha e ghambamina na hu yaku weimiyaŋgiya lemi bodaboda. Ya naŋgo weya Loi na ne ghare weŋga ŋgoreiya ghemi va gharemi weŋgo na weŋgiya thiyema vama thɨ marema. ");
INSERT INTO tgo_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Na tembe ya naŋgo weva Giya Loi na ne i vakathaŋga tembe hu lagheva na hu yaku weimiyaŋgiya lemi ghɨmoghɨmoru.” Naomi i mwanambiyeŋgi e ghareghare na i mwaewoŋgi. Weinji lenji gharevɨrɨ thɨ randa na ghalɨŋanji laghɨye ");
INSERT INTO tgo_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","na thɨŋa, “Thava ŋgoreiyana! Weime eŋge ghen na ra wa weŋgiya len bodaboda.” ");
INSERT INTO tgo_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ko iyemaeŋge Naomi i gonjogha weŋgi iŋa, “Oyawanyiŋgu, mbema i thovuye moli vara hu njogha. Buda kaiwae nuwamiya weiŋguyaŋgiya ghemi? Ne valɨkaiwae tembe ya ghambɨŋgiva ghɨmoghɨmoru, thɨ thegha matuwo na tembe hu vaŋguŋgiva? ");
INSERT INTO tgo_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Mbema hu njogha eŋge, oyawanyiŋgu. Kaero yalaghɨsarɨ moliya ghino na ma valɨkaiwaŋgu tembe ya gheva. Na othembe thoŋgo amba valɨkaiwaŋgu ya vaidiya ŋgama, na thoŋgo ya ghena weiŋgu lo ghɨmoru gougouke noroke na ya vaidiya ŋgama, ");
INSERT INTO tgo_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ne valɨkaiwae mbowo hu dagetenɨŋga e ghe na wo hu roroghagha ghaghad thɨ thegha matuwo? Oyawanyiŋgu, hu ghareghare iyake ma valɨkaiwae. Budakai va i yomara e ghino i maŋga kivwala budakai i yomara weŋga. Kaiwae Lo Giya Loi kaero i roghereiye wanaŋgo na vuyowoke iyake i laghɨye moli weŋgo.” ");
INSERT INTO tgo_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Iyake i vakathaŋgi na mbowo thɨ randava. Amba Opa i mwanavatha yawanyiye e ghareghare na i ghawole, ko iyemaeŋge Rut i thovuvu Naomi. ");
INSERT INTO tgo_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi i dagewa Rut iŋa, “Wo u thuwe, len ghaghe kaero i njogha weŋgiya le bodaboda na weŋgiya le loi i kururu weŋgi. Ghen tembe ŋgoreiyeva, u njogha wein.” ");
INSERT INTO tgo_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ko iyemaeŋge Rut i gonjoghawe iŋa, “Thava u vavothaŋaŋgo na ya roiteteŋge. Mbema u vatomwe eŋge na weiŋgu ghen. Ne the valɨvaŋga u wawe, ya wawe, na ne the valɨvaŋga vo yakuwe, va yakuwe. Len gharɨgharɨ lo gharɨgharɨ, na len Loi lo Loi. ");
INSERT INTO tgo_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","The valɨvaŋga vo marewe ne va marewe na thɨ bekuŋgowe. Giya Loi le lithɨ laghɨye moli e ghino thoŋgo ya roiteteŋge; ko mbe mare eŋge vara ne i vakathainda ra meghaghathɨ.” ");
INSERT INTO tgo_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Mbaŋa Naomi i thuwa Rut le vothako, ma tembe i rovurɨghegheva e variye njoghawe. ");
INSERT INTO tgo_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Elaelama theunyiwoma kaero vethɨ loloŋgaova ghaghad vethɨ vutha Betɨlehem. Mbaŋa thɨ vutha, gharɨgharɨ gharenji iyo kaiwanji na wanakau thɨŋa, “Mbema emunjora Naomi iya elaghɨniyeko?” ");
INSERT INTO tgo_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","I dage weŋgi iŋa, “Thava hu uno idaŋgu Naomi, huŋa eŋge ‘Mara,’ kaiwae Loi Vurɨvurɨghegheniye i vakatha yawaliŋgu ghamɨnae mbema maŋga eŋge. ");
INSERT INTO tgo_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Va ya roitetake lo bigibigi veimaima, ko iyemaeŋge Giya Loi i vaŋgunjoghaŋgo kokowaŋgu. Buda kaiwae hu uno idaŋgu Warawarariniye, na mbaŋake Loi Vurɨvurɨghegheniye kaero i roghereiye wanaŋgo na ya vaidiya vuyowae!” ");
INSERT INTO tgo_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Iyake i woraŋgiya va ŋgoroŋga na Naomi i roiteta Mowab na i njogha Betɨlehem weiye Rut tɨnan Mowab. E mbaŋako iyako bali uloulo amba i wora eŋge rɨghe. ");
INSERT INTO tgo_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Amala regha ina Betɨlehem, ina Naomi le ghɨmoru Elimelek e ghauu tɨne. Idae Bowas, na amalake iyake iye giya vwenyevwenye regha. ");
INSERT INTO tgo_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Rut, iye tɨnan Mowab i dage weya Naomi iŋa, “Thare u vatomweŋgo na ya wa e umako tɨne na va mbana bali iya rakakaiwoko thɨ ten na thɨ mban iteteko. The rakakaiwo ne ghare i njaweŋgo na i varaeŋna e ghino amba ya kaiwo e ghereiye.” Naomi i gonjoghawe iŋa, “U wa na vo vakatha ŋgoreiye, yawanyiŋgu.” ");
INSERT INTO tgo_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Iya kaiwae Rut i wa e umako tɨne, i rereghamba weŋgiya rakakaiwoko, na i mbana baliko thɨ roitetako e ghereinji. Rut va i minjanuwae, thela i wo Bowas, iye i mena Elimelek e ghauu tɨne, iya le bali ghauma i kaiwokowe. ");
INSERT INTO tgo_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Amba ma i mwelumweluŋguya kaero Bowas i vutha, i ri Betɨlehem. I ŋaevairɨŋgiya le rakakaiwo iŋa, “Weimi Giya Loi.” Thɨ gonjoghawe thɨŋa, “Giya Loi i mwaewo e ghen.” ");
INSERT INTO tgo_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bowas i vaito le rakakaiwoko lenji randeviva iŋa, “Elako tabwako i mena thela e ghauu tɨne?” ");
INSERT INTO tgo_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Rakakaiwoko lenji randeviva i gonjoghawe iŋa, “Iye tɨnan Mowab. Naomi va i njoghamake weiye, va thɨ ri Mowab. ");
INSERT INTO tgo_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Me naŋgo e ghino na ya vatomwewe i rereghamba weŋgiya rakakaiwoko i mbanɨmba reghamba bali rakakaiwoko thɨ mban itete. Me kaiwo wa mbe mbaŋambaŋa ghaghad mbaŋake, na mbe mbaŋa ubotu eŋge me roru e riburibuko na i towowe.” ");
INSERT INTO tgo_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Amba Bowas i dage weya Rut iŋa, “Elana, wo u vandeŋeŋgo. Ne u ndewa e uma reghava na vo mbana baliwe, mbe u mbanɨmba vara e umake iyake. Mbe u yaku vara gheke weinaŋgiya wanakauke thiyake. ");
INSERT INTO tgo_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Mbe u njimbukiki wagiyawe vara kaiwoke iya e balike ghauma tɨne, iya ghɨmoghɨmoruko thɨ kaiwowe, na u ghambuŋgiya wanakauna iya thɨ mban reŋanawe. Kaero ma dage weŋgiya iya ghɨmoghɨmoruko na ne thɨ ndevakatha vakatha vatharɨ regha e ghen. Na thembaŋa ne mbwa i gharɨŋge u wa na vo mun e mbwako varivariye iya ghɨmoghɨmoruko methɨ gudurawe.” ");
INSERT INTO tgo_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Iyake kaiwae Rut i kururu na ghamwae ve thukumwa thelau, na i dage weya Bowas iŋa, “Budakai kaiwae na u rerenuwaŋa laghɨye kaiwaŋgu? Budakai kaiwae na gharen weya ghawora loloniye?” ");
INSERT INTO tgo_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bowas i gonjoghawe iŋa, “Kaero ya loŋwevao utuutunin na ŋgoroŋga len vakatha thovuye weya yawanyinɨko mbaŋa len ghɨmoru i mare iteteŋge. Ya ghareghare va ŋgoroŋga na u roiteteŋgiya rama na tɨna na ghembako iyava madɨbanɨko i dobuwe, na va ŋgoroŋga na u mena na kaero u yakuva gharɨgharɨ mava mbaŋa regha u ghareghareŋgi e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ya naŋgo weya Giya Loi na ne i giya njogha e ghen len vakathako kaiwae. Na modoko iyako mbala veimaima na ndendewo weya Giya Loi, iye Isirel lenji Loi, na amalaghɨniye ŋgoreiya ma, e vineiye raberabe kaero menda u mena na u vaidiya vwarɨvwarɨrɨwe.” ");
INSERT INTO tgo_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut i gonjoghawe iŋa, “Ghan thanavu mbema i thovuye vara e ghino, ghino ghen len rakakaiwo, amalana. Mo utu e ghalɨŋa udauda i mwanavairɨŋgo, othembe len rakakaiwona wanakauko thɨ laghɨye kivwalaŋgo.” ");
INSERT INTO tgo_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Mbaŋa ghanɨŋga ghambaŋa, Bowas i dage weya Rut iŋa, “U mena ra ghanɨŋga. U wo bredɨke na u woutu e mbwake monyomonyoke.” I yaku weiyaŋgiya rakakaiwoko amba Bowas mbowo i giyava bali vwalavwala vavanawe. I ghanɨŋga na kaero valɨkaiwae, ko vavana vambe inawe. ");
INSERT INTO tgo_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Mbaŋa Rut kaero me wao na ve mbanɨmba bali, Bowas i rodage weŋgiya le rakakaiwo ghɨmoghɨmoruko iŋa, “Hu viyathu na i mbana bali, othembe i mban ŋgoreiya kaero yavayavathaŋgiko, ne hu ndeguva utu omathaŋaghad. ");
INSERT INTO tgo_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Mbala hu bigiraŋgiya eŋge bali vavana e mbambarana iya hu tenɨŋgina e tɨnenji, hu roitete na elaghɨniye i rombanɨŋgi. Ko iyemaeŋge ne hu ndedagetenɨwe.” ");
INSERT INTO tgo_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut i mbanɨmbanɨvatha balima ghaghad varae ve ronja. Mbaŋa i wo umbwa na i ŋge baliko varivariye e wokiwokiyeko na i yaruvatha mbombouyeko, va i wo epa, raŋa ghemidima vethethiŋo ŋgamwara. ");
INSERT INTO tgo_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Rut i biginjogha bali e ghemba, na i vatomwe weya yawanyiye ŋgoroŋga baliko le laghɨlaghɨye me mban. Na tembe i giya weva Naomi ghanɨŋgama me ghanɨvarema. ");
INSERT INTO tgo_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Yawanyiye i vaito iŋa, “Noroke aŋga mo mbana bali? Thela ele bali ghauma mo kaiwowe? Ya naŋgo na Loi mbala i mwaewo weya giyako iyako iya me thalavuŋgena noroke.” Rut i dage weya yawanyiye iŋa, “Amalako iya ma kaiwo ele umako tɨne idae Bowas.” ");
INSERT INTO tgo_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi i dagewe iŋa, “Ya naŋgo Giya Loi iye ghare weŋgiya thavala e yawayawalinji na ramaremare ma mbaŋa regha iko, i mwaewo weya amalako iyako.” Na mbowo i gotubweva iŋa, “Amalana iyena la boda regha na iye ŋgoreiya ghanda rathalavu, valɨkaiwae ne i njimbukikinda.” ");
INSERT INTO tgo_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rut iŋa, “Na tembe me dageva e ghino na iŋa, ‘Mbe u mena u kakaiwo vara weinaŋgiya lo rakakaiwoke ghaghad thɨ uloulovao elo balike.’” ");
INSERT INTO tgo_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi i dage weya yawanyiye Rut iŋa, “Ŋgoreiye, wou yawanyiŋgu, mbala ma rakakaiwo e bali ghanji umauma vavana thɨ mena thɨ vakatha vuyowo e ghen, thoŋgo kaero u wava e bali ghauma reghava. I thovuye moli mbe u kaiwo vara weinaŋgiya wanakauna iya Bowas ele balina ghauma tɨne.” ");
INSERT INTO tgo_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Iya kaiwae Rut mbe i kakaiwo vara e baliko ghauma tɨne. Mbe ina vara rakakaiwoko wanakauko evasiwanji ghaghad thɨ uloulovao bali na wit. Na Rut mbe i yaku vara weiye yawanyiye. ");
INSERT INTO tgo_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Va mbaŋa regha amba Naomi i dage weya yawanyiye Rut iŋa, “Wo ya tamweya kamwathɨ na thoŋgo valɨkaiwaŋgu ya tuthiya ghɨmoru regha na u vaŋgu mbala len yakuyaku i thovuye na wein len warari. ");
INSERT INTO tgo_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","U renuwaŋakikiya Bowas, iya mendava vo kaiwo weinaŋgiya le rakakaiwo wanakauma. Iye ghanda rathalavu la ghɨmoru ghanjiuu loloniye. Wo u vandeŋeŋgo. Noroke gougou ina balima ghaghamba vwaravwara i vwara balima na i ghetha varivariye na ndamwandamwa weiye mbombouye. ");
INSERT INTO tgo_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Iya kaiwae nuwaŋguiya u thithu, u ghavatha na u worawa bunama e riwan. U njimbo kwama thovuye, amba u wa ŋgora i vwaravwara na i ghetha balikowe, ko iyemaeŋge mbaŋa ne inan gheko mbe u vakatha wagiyaweŋge vara na thava i ghareghareŋge ghaghad ne munumu na ghanɨŋga e ghereiye. ");
INSERT INTO tgo_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","U njimbu vakatha mbaŋa ne ve ghena. Mbala u wa na vo ronja evasiwae, u livaira thogana e gheghena na u ghena evasiwae. Tene i dage e ghen ŋgoroŋga ne u vakatha na uŋa.” ");
INSERT INTO tgo_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut i gonjoghawe iŋa, “Ne ya vakatha ŋgoreiya mo utuŋana.” ");
INSERT INTO tgo_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kaero Rut i wareri i wa e ghamba vwaravwara bali na i vakatha ŋgoreiya yawanyiye me utumawe. ");
INSERT INTO tgo_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Mbaŋa Bowas i ghanɨvao na i munɨvao, ghare i warari laghɨye. I wa ŋgoreiya baliko ghawabwi ghadidiye na ve ghenawe. Rut tembe seiwo seiwo vara i wawe, i tatethara gheghe kaero i ghena. ");
INSERT INTO tgo_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Mbala vama i wo gougou mborowae, amba Bowas i raraghana ghare, i ghenevaghɨle na mara i wa e gheghe, ghare i yo mbaŋa i thuwa wevo eunda i ghena e gheghe. ");
INSERT INTO tgo_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Bowas i vaito iŋa, “Thela ghen?” I gonjoghawe iŋa, “Ghino Rut, len rakakaiwo. Kaiwae ghɨmoruko va ya vaŋgukaiko le boda ghen na ghen ghamarathalavu valɨkaiwae tembe u njimbukikiŋgova.” ");
INSERT INTO tgo_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","I gonjoghawe iŋa, “Ya naŋgo weya Giya Loi na i mwaewo e ghen, elana. Ghan thanavuke iya u vakathake e ghino noroke i kivwala ghan thanavu iya u vakavakatha weya yawanyinɨna. Ma mo tamweya ghɨmoru amba thegha ndamwandamwa na nuwaniya u vaŋgu, othembe i vwenyevwenye o mbinyembinyeŋgu? ");
INSERT INTO tgo_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ko mbaŋake, Rut, thava u gharelaghɨlaghɨ, kaiwae gharɨgharɨko wolaghɨye e ghembako thɨ ghareghare euriya ghen na ghino ne ya vakatha bigibigike wolaghɨye kaiwan. ");
INSERT INTO tgo_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Emunjora ghino lo boda iya ghɨmoruna va u vaŋgukaina na mbaro iŋa ghino ya njimbukikiŋge, ko iyemaeŋge ghɨmoru regha yawanyinɨna le boda na iye ma i bwagabwaga moli e ghen ŋgoreiya ghino. ");
INSERT INTO tgo_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Mbowo u yaku vara gheke gougouke iyake na ne mbaŋambaŋa amba vara thuwe na ra vanamwe weinda. Thoŋgo le renuwaŋa ŋgoreiye na i varaeŋna i njimbukikiŋge, i thovuye; ko thoŋgo ma le renuwaŋa ŋgoreiye, ya dagerawe Giya Loi e marae, ne ya wo vuyowoko iyako. Iya kaiwae u ghena vara gheke ghaghad ne ighɨviya.” ");
INSERT INTO tgo_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rut mbowo i ghena gheko ghaghad ighɨviya rakaraka, ko iyemaeŋge va i thuweiru amba maramomouwo na mbala ma lolo regha i thuwe, kaiwae Bowas maŋa ma nuwaiya lolo regha i ghareghare mena gheko. ");
INSERT INTO tgo_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bowas i dagewe iŋa, “U liraŋgiya ghan kwamana ghayaboyabo na u livamomoya gheke.” I vakatha ŋgoreiye, amba Bowas i liŋgiya bali e tɨne, le vuyovuyowo mbalavama 30 kilogram. I thalavu i thɨnɨvairɨ amba amalaghɨniye i njogha e ghembako tɨne. ");
INSERT INTO tgo_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Mbaŋa Rut i njoghama weya yawanyiye, kaero yawanyiye i vaito iŋa, “Ŋgoroŋga me le vakatha e ghen, elana?” Rut i utugiyavaowe bigibigiko wolaghɨye Bowas me le vakathakowe. ");
INSERT INTO tgo_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","I gotubwe iŋa, “Na balike i laghɨye moli ŋgoreiye vara iyake me giya weŋgo na iŋa thava ya njoghama e ghen kokowaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomi i gonjoghawe iŋa, “Rut, tha u rerenuwaŋa, mbema u yaku eŋge na u roroghagha ŋgoroŋga ne une ve yomara. Bowas mane i yaku noroke ghaghad ne ve vanamwe renuwaŋana iyana.” ");
INSERT INTO tgo_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Amba Bowas i wa ŋgoreiye ghembako ghaghambaru, iye ghamba mevathavatha, na ve yakuwe. Amba Elimelek le bodama iya i rothɨgha amalaghɨniye, amalama Bowas me utuŋa utuniyema, i mena e ghadidiye, na Bowas i dagewe iŋa, “Amalana, wo u mena u yaku gheke.” I wa iyena kaero ve ronja. ");
INSERT INTO tgo_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Bowas i vaŋguvathaŋgiva ghembako gharandeviva theyaworo na vethɨ yayaku gheko weinjiyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Amba i dage weya le bodama iŋa, “Kaiwae Naomi kaero menda i njoghama Mowab e tɨne, nuwaiya i vakuneŋa thelau vuvura, iya la bodama Elimelek va i mare itetema. ");
INSERT INTO tgo_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ma renuwaŋa valɨkaiwae u ghareghareya iyake iya kaiwae ma womena renuwaŋa iyake e ghen. Mbaŋake iyake thoŋgo nuwaniya u vamodonjogha randevivaŋgike thiyake e maranji. Ko thoŋgo ma nuwaniya, u woveŋgoma len renuwaŋa, kaiwae vavamodonjogha ele valɨvaŋga i viva moli ghen ko amba ghino.” Amalama i gonjoghawe iŋa, “Ne ya vamodonjogha.” ");
INSERT INTO tgo_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ko amba Bowas i dagewe iŋa, “The mbaŋa ne u vamodanjogha thelauko iyako, kaero ŋgoreiye ne u vaŋgwa Rut iye wambwi tɨnan Mowab na len wevo, na mbala hu ghambɨŋgiya gamagai wein na thelauna iyena i yaku weŋgiya ghembwiyena le ŋgaŋga.” ");
INSERT INTO tgo_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Amalako i gonjoghawe iŋa, “Kaiwae ŋgoreiyeva iyana, ma valɨkaiwaŋgu ya vakatha ŋgoreiya la boda vakavakathaniye kaiwae ne i vakathaŋge na iwaeŋge lo ghamba mbaro ma i laghɨye. Ghen eŋge u vamodonjogha; ghino ma valɨkaiwaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Me vivako Isirel gharɨgharɨniye me lenji vakatha ŋgoreiyake mbaŋa methɨ vakuneŋa o thɨ vegiya weŋgiya bigibigi: ravavakune iye ne i bigiraŋgiya gheghe ghae na i giya weya ravavamodo. Iyake va ghanji thanavu na i vaemunjoruŋa renuwaŋako iyako kaero thɨ vanamwe. ");
INSERT INTO tgo_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kaiwae ŋgoreiyako, mbaŋa amalako iŋa, “U vamodanjogha,” i bigiraŋgiya gheghe ghae na i giya weya Bowas. ");
INSERT INTO tgo_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Amba Bowas i dage weŋgiya randevivaŋgiko na thavalava va inanji gheko iŋa, “Noroke taulaghɨna ghemi e marami kaero ne ya vamodonjogha bigibigiko wolaghɨye weya Naomi; Elimelek le bigibigi na tembe ŋgoreiyeva Kiliyon na Malon lenji bigibigi. ");
INSERT INTO tgo_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Tembe ŋgoreiyeva Rut iye tɨnan Mowab, Malon ghembwiye, iye kaero lo wevo. Iya kaiwae bigibigiko wolaghɨye mbene i yaku wevara Malon le ŋgaŋga, na Elimelek gheuuko mbala mbe i mbuthumbuthu vara e ghabodako tɨnenji e ghambaeko. Ghemi ne hu utuŋa utuutuke iyake weŋgiya gharɨgharɨke wolaghɨye.” ");
INSERT INTO tgo_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Randevivaŋgiko na vavanava thɨŋa, “Ŋgoreiye, ghime wo thuwe na ne wo utuŋa. Wo naŋgo weya Giya Loi na ne i vakatha wevona iyana, iya i mena e len ŋgolona na nevole ŋgoreiya Reitiyel na Leya, thiye wabwi Isirel otɨnatɨnanji. Tembe wo naŋgo weva Giya Loi na mbala i vakathaŋge na u vwenyevwenye uu Eprat e tɨne na giya vwenyevwenye ghen Betɨlehem e tɨne. ");
INSERT INTO tgo_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Giya Loi ne i vakatha wevoko iyako na ne hu ghamba gamagai na ne thɨ vakatha ghanuuna idae laghɨye ŋgoreiya Peres gheuu, Juda na Tamar narinji.” ");
INSERT INTO tgo_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Iyako e ghereiye Bowas i vaŋgwa Rut na levo. Bowas i ghenethaiya levo Rut na Giya Loi i mwaewowe i vaidiya ŋgama. I ghambɨkaiya ŋgama ghɨmoru. ");
INSERT INTO tgo_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Wanakau Betɨlehem e tɨne thɨ dage weya Naomi thɨŋa, “Taulaghɨke ghinda ra tarawe Giya Loi, kaiwae kaero le renuwaŋa ŋgoreiye na noroke rumbun ŋgama ghɨmoru, iye nevole i njimbukikiŋge. Wo naŋgo weya Giya Loi na ŋgamana iyena nevole idae i laghɨye Isirel gharɨgharɨniye e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Yawanyin na valɨghareghare mbe ghare vara e ghen, na le vakathako iyako e ghen i kaitotowo, i kivwala wevo i ghambɨŋgiya gamagai ghɨmoghɨmoru theghepirɨ. Na kaero ne i ghamba ŋgama ghɨmoru kaiwan, na iye nevole i njimbukikiŋge mbaŋa nevolema u yalaghɨsarɨ moli.” ");
INSERT INTO tgo_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Amba Naomi i wo ŋgamako e nɨmanɨmaeko, i mwanambiye e ghareghare na mbe gharewe vara. ");
INSERT INTO tgo_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Wanakauko e ghembako iyako tɨne thɨŋa, “Naomi kaero rumbuye ŋgama ghɨmoru.” Thɨ rena idae Obedi. Iye Jese ramae na Deivid ramaya Jese. ");
INSERT INTO tgo_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Gharɨgharɨke thiyake Deivid orumburumbuye, i ri weya Peres i mena ghaghad Deivid: Peres nariya Hesron, ");
INSERT INTO tgo_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron nariya Ram, Ram nariya Aminadab, ");
INSERT INTO tgo_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab nariya Nason, Nason nariya Salmon, ");
INSERT INTO tgo_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon nariya Bowas, Bowas nariya Obedi, ");
INSERT INTO tgo_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedi nariya Jese, Jese nariya Deivid. ");
INSERT INTO tgo_vpl VALUES ("AM1_1","031_1_1","AMO","1","1","1","Utuutuke thiyake Emos ghalɨŋae, iye sip gharanjimbunjimbu, i mena Tekoa. Theghathegha umboiwo amba muyai ragheragheghe, mbaŋaniye Ujaiya iye va Juda lenji kiŋ na Jerobowam Johoas nariye iye Isirel lenji kiŋ, Loi i utugiya utuutuke thiyake weya Emos Isirel kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("AM1_2","031_1_2","AMO","1","2","2","Emos iŋa: “Giya Loi ghalɨŋae laiye laghɨye moli i mena Saiyon na e larɨmbɨya i mena Jerusalem e tɨne, sip lenji ghamba ghan thɨ mare na ou Kamel vwatae nana thiya mareyawowo.” ");
INSERT INTO tgo_vpl VALUES ("AM1_3","031_1_3","AMO","1","3","3","Giya Loi iŋa ŋgoreiyake: “Kaiwae Damasiko gharɨgharɨniye thɨ vakatha valaŋa tharɨ mane ya mwana njogha lo ghatemuruke. Kaiwae thɨ giya vɨrɨ laghɨye weŋgi Giliyad gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("AM1_4","031_1_4","AMO","1","4","4","Iya kaiwae ne ya vakatha ndɨghe i nda Kiŋ Hajael le ŋgolo na tembe ve wova Kiŋ Benhaded le ŋgoloŋgolo vurɨvurɨghegheniye. ");
INSERT INTO tgo_vpl VALUES ("AM1_5","031_1_5","AMO","1","5","5","Ne ya ŋgoŋgo vwowona ghembana laghɨye Damasiko gha thɨnɨmba ŋginaŋginauye; na ne ya mukuwo kiŋɨko iya i yaku e Malamo Aven tɨne, na thela iya i mbaro Betidan e tɨne. Siriya gharɨgharɨniye ne thɨ vaŋguŋgi na vethɨ mebwabwari Kirɨ e tɨne,” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM1_6","031_1_6","AMO","1","6","6","Giya Loi iŋa ŋgora iyake: “Kaiwae Gaja gharɨgharɨniye thɨ vakatha valaŋa tharɨ mane ya mwana njogha lo ghatemuruke, kaiwae thɨ takovaoŋgi vanautuma regha na vethɨ vaŋguraweŋgi na thɨ mebwabwari Idom e tɨne. ");
INSERT INTO tgo_vpl VALUES ("AM1_7","031_1_7","AMO","1","7","7","Iya kaiwae ne ya vakatha ndɨghe na i nda Gaja gha ganako na ve wo gha ŋgolo vurɨvurɨghegheko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("AM1_8","031_1_8","AMO","1","8","8","Ne ya mukuwo Asɨdod gha kiŋ na thela iya i mbaro Eskelon e tɨne. Ekron mbene thɨ li vara nɨmaŋguke na vewo Pilistiya gharɨgharɨniye thavala mbe i nanjiwe.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM1_9","031_1_9","AMO","1","9","9","Giya Loi iŋa ŋgora iyake: “Kaiwae Taiya gharɨgharɨniye thɨ vakatha valaŋa tharɨ mane ya mwana njogha lo ghatemuruke weŋgi, kaiwae thɨ takovaoŋgi vanautuma regha na vethɨ vaŋguraweŋgi na thɨ mebwabwari Idom e tɨne na ma thɨ ghambu vɨghathɨ gha dagerawe va thɨ vakatha. ");
INSERT INTO tgo_vpl VALUES ("AM1_10","031_1_10","AMO","1","10","10","Iya kaiwae ne ya vakatha ndɨghe na i nda Taiya gha ganako na i nda weiye gha ŋgoloŋgolo vurɨvurɨghegheniyeko wolaghɨye.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM1_11","031_1_11","AMO","1","11","11","Giya Loi iŋa ŋgora iyake: “Kaiwae Idom gharɨgharɨniye thɨ vakatha valaŋa tharɨ mane ya mwana njogha lo ghatemuruke weŋgi, kaiwae thɨ woidiŋa ŋgiya lenji bodaboda Isirel gharɨgharɨniye e gaithɨ gha ghalithɨ, na ma tembe gharenjiva weŋgi. Lenji ghatemuruko ma ele ghambako na tene thɨ viyathuva. ");
INSERT INTO tgo_vpl VALUES ("AM1_12","031_1_12","AMO","1","12","12","Iya kaiwae ne ya vakatha ndɨghe i nja Teman na i ŋambu yathu Bosra le ŋgolo vurɨvurɨghegheniye.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM1_13","031_1_13","AMO","1","13","13","Giya Loi iŋa ŋgora iyake: “Kaiwae Amon gharɨgharɨniye thɨ vakatha valaŋa tharɨ, mane ya mwana njogha lo ghatemuruke weŋgi. Kaiwae e lenji gaithɨ tɨne thɨ gaboŋgi na thɨ viyaŋgiya maramarabo Giliyad ele valɨvaŋga tɨne nuwanjiya thɨ valaghɨyeŋa lenji ghamba mbaroko. ");
INSERT INTO tgo_vpl VALUES ("AM1_14","031_1_14","AMO","1","14","14","Iya kaiwae ne ya vakatha ndɨghe i nja Raba e gha ganako na i ŋambu gha ŋgoloko vurɨvurɨghegheniyeko wolaghɨye. Ambane gaithɨ gha mbaŋa weiye yaro, na gaithɨko ma i vurɨgheghe eŋge ŋgoreiye ndewendewe vurɨvurɨghegheniye. ");
INSERT INTO tgo_vpl VALUES ("AM1_15","031_1_15","AMO","1","15","15","Raba gha kiŋ na giyagiyaniyeko ne vethɨ mebwabwari e valɨvaŋga regha.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM2_1","031_2_1","AMO","2","1","1","Giya Loi iŋa ŋgora iyake: “Kaiwae Mowab gharɨgharɨniye thɨ vakatha valaŋa tharɨ mane ya mwana njogha lo ghatemuruke weŋgi. Kaiwae va thɨ tɨghɨvoreŋa Idom lenji kiŋ wokiwokiniye na thɨ ŋambu. (Ŋgoreiye ghɨmu.) ");
INSERT INTO tgo_vpl VALUES ("AM2_2","031_2_2","AMO","2","2","2","Iya kaiwae ne ya variya ŋɨghe Mowab, na i ŋambwa Kiriyot gha ŋgoloŋgolo vurɨvurɨghegheniyeko wolaghɨye. Na Mowab gharɨgharɨniye ne thiya mare mbaŋa thɨ loŋwe gaithɨ laiye na ragagaithɨ thɨ yaro na mema ghalɨŋanji. ");
INSERT INTO tgo_vpl VALUES ("AM2_3","031_2_3","AMO","2","3","3","Ne ya unɨgha Mowab gharambarombaro na gha randevivako wolaghɨye.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM2_4","031_2_4","AMO","2","4","4","Giya Loi iŋa ŋgora iyake: “Kaiwae Juda gharɨgharɨniye thɨ vakatha valaŋa tharɨ, mane ya mwana njogha lo ghatemuruke weŋgi, kaiwae va thɨ botewayatho lo vavaghare na ma thɨ ghambugha lo mbaro, na kaiwae thɨ ghambu thavwiŋgiya loi kwanɨkwan/vatavatadɨ orumburumbunji va thɨ ghambuŋgi. ");
INSERT INTO tgo_vpl VALUES ("AM2_5","031_2_5","AMO","2","5","5","Iya kaiwae ne ya variya ndɨghe i nja Juda na i nda Jerusalem gha ŋgoloŋgolo vurɨvurɨghegheniye.” ");
INSERT INTO tgo_vpl VALUES ("AM2_6","031_2_6","AMO","2","6","6","Giya Loi iŋa ŋgoreiyake: “Kaiwae Isirel gharɨgharɨniye thɨ vakatha valaŋa tharɨ mane ya mwana njogha lo ghatemuru weŋgi, kaiwae vo thɨ vakuneŋa ŋgiya ghɨmoghɨmoru rumwarumwaruniye na thɨ tabo rakakaiwobwaga kaiwae ma valɨkaiwanji thɨ vamodo ghanji ghaga, na mbinyembinyeŋgu iya ma valɨkaiwanji thɨ vamoda ghanji ghaga nasiye gheghenji/gheghe ghae modae. ");
INSERT INTO tgo_vpl VALUES ("AM2_7","031_2_7","AMO","2","7","7","Thɨ vuruvaulule ŋgiya ranjavovo na ma e lenji vurɨgheghe, na thɨ ghɨmararawe ŋgiya mbinyembinyeŋgu. Amala weiye ramae thɨ loŋga weinji rakakaiwo bwaga mbe yeunda eŋge, na ma thɨ yavwatata wanaŋgo. ");
INSERT INTO tgo_vpl VALUES ("AM2_8","031_2_8","AMO","2","8","8","E lenji ghamba kururuŋgi ghɨmoghɨmoru Thɨ ghena e kwamakwama thɨ mban weŋgiya mbinyembinyeŋgu iya thaŋwethaŋwe winyimariyeko. Lenji Loi ele Ŋgolo Boboma thɨ muna waen thɨ mbana weŋgiya thavala e ghanji ghaga mane ina weŋgi. ");
INSERT INTO tgo_vpl VALUES ("AM2_9","031_2_9","AMO","2","9","9","Iyemaeŋge ya mukuwo ŋgiya Amori gharɨgharɨniye e maranji/ghamwanji, ghɨmoghɨmoruko iya lenji molamolao ŋgoreiya umbwa sida na lenji vurɨvurɨgheghe ŋgoreiya umbwa ouk. ");
INSERT INTO tgo_vpl VALUES ("AM2_10","031_2_10","AMO","2","10","10","Va ya vaŋgu raŋgiyaŋga Ijipt e tɨne na ya viva e ghemi e njamnjam bwa theghathegha ghwevarɨ e tɨne na ya giya Amori lenji thelauke e ghemi lemi ghamba yakuyaku. ");
INSERT INTO tgo_vpl VALUES ("AM2_11","031_2_11","AMO","2","11","11","Va ya tuthi ŋgiya lemi ŋgaŋgana vavana thɨ tabo ghalɨŋae gharautu na thethegha vavana thɨ tabo Najarait. I emunjorako, Isirel gharɨgharɨniye?” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM2_12","031_2_12","AMO","2","12","12","Giya Loi mbowo iŋava: “Ko iyemaeŋge u vakatha ŋgiya Najarait thɨ muna waen na u dagetenɨŋgiya ghalɨŋae gharautu thava thɨ utuŋa ghalɨŋaŋgu. ");
INSERT INTO tgo_vpl VALUES ("AM2_13","031_2_13","AMO","2","13","13","Iya kaiwae ne ya mbiye njoŋaŋge e thelauko ŋgoreiya waŋga momod i mbiye njoŋa mbaŋa thɨ dowevanjara e wit. ");
INSERT INTO tgo_vpl VALUES ("AM2_14","031_2_14","AMO","2","14","14","Ghemi iya hu maya e rukurukuna mane hu voitete, thavala thɨ vurɨgheghe ne thɨ njavovo na ragagaithɨ vurɨvurɨghegheniye mane valɨkaiwanji thɨ ndetenɨtena ghanjimberegha. ");
INSERT INTO tgo_vpl VALUES ("AM2_15","031_2_15","AMO","2","15","15","Thela i gaithɨ e mbwenara mane i ndeghathɨ ele ghamba ndeghathɨ, thavala thɨ vurɨgheghe mane thɨ vogha, thavala thɨ gaithɨ e hosɨ mane thɨ vogha e yawayawalinji. ");
INSERT INTO tgo_vpl VALUES ("AM2_16","031_2_16","AMO","2","16","16","Thela ragagaithɨ vurɨvurɨghegheniye nevole e mbaŋako iyako i bigiyatho le gaithɨ bigibiginiye na i voghɨ.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM3_1","031_3_1","AMO","3","1","1","Wo hu vandeŋe Giya Loi ghalɨŋaeke, ghemi Isirel gharɨgharɨniye, ghemi iyava i vaŋgu raŋgiyaŋgana Ijipt e tɨne. ");
INSERT INTO tgo_vpl VALUES ("AM3_2","031_3_2","AMO","3","2","2","Giya Loi iŋa, “E vanautumake wolaghɨye e tɨnenji mbe ghen eŋge vara va ya tuthiŋge, iya kaiwae len tharɨna wolaghɨye kaiwanji ne ya lithɨ e ghen.” ");
INSERT INTO tgo_vpl VALUES ("AM3_3","031_3_3","AMO","3","3","3","Emos i gotubwe, iŋa, “Thare ghɨmoghɨmoru theghewo thɨ loŋga na regha thoŋgo ma methɨ worawa lenji renuwaŋa regha? ");
INSERT INTO tgo_vpl VALUES ("AM3_4","031_3_4","AMO","3","4","4","Thare laiyon i volenjaŋaŋa e njamnjamɨko thoŋgo ma i vaidiya thae/borogi? Thare ne i volenjaŋaŋa e ghambaeko thoŋgo ma i yalawe mun ghae/gha borogi? ");
INSERT INTO tgo_vpl VALUES ("AM3_5","031_3_5","AMO","3","5","5","Thare maa i yonja e manɨvanjako thoŋgo ma ghanɨŋga ina e ighathɨko vuruvurumara? Thare ighathɨko i tagavairɨ thoŋgo ma bigi regha i tagavu? ");
INSERT INTO tgo_vpl VALUES ("AM3_6","031_3_6","AMO","3","6","6","Thare gaithɨ gha mema ne i randa/thɨ wiya gaithɨ mema i ghembako tɨne na mane i vakatha ŋgiya gharɨgharɨ thiye mararu? Thare thɨ vatharɨ regha ne i yomara e ghembako tɨne thoŋgo ma Giya Loi i vakatha na i yomara? ");
INSERT INTO tgo_vpl VALUES ("AM3_7","031_3_7","AMO","3","7","7","Giya Loi ma mbaŋa regha i vakatha bigi regha, i viva wo i woraŋgiya le renuwaŋako weŋgiya le rakakaiwo, ghalɨŋae gharautu. ");
INSERT INTO tgo_vpl VALUES ("AM3_8","031_3_8","AMO","3","8","8","Mbaŋa laiyon i volenjaŋaŋa thela mane i mararu? Mbaŋa Giya ne i utu thela ne i utu raŋgiya ghalɨŋaeko? ");
INSERT INTO tgo_vpl VALUES ("AM3_9","031_3_9","AMO","3","9","9","Hu utu weŋgiya thavala thiya yaku e ŋgoloŋgolo vurɨvurɨghegheniye Asɨdod na Ijipt e tɨnenji, huŋa: ‘Hu mevathavatha e ouou vwatanji Sameriya ghadidiye na wo hu ghewo mevatharɨ laghɨye e tɨnenjiko na gharɨgharɨko mbe lenji vakatha raraitharɨ e tɨnenjiko.’” ");
INSERT INTO tgo_vpl VALUES ("AM3_10","031_3_10","AMO","3","10","10","Giya Loi iŋa, “Gharɨgharɨke thiyake ma thɨ ghareghare mun ŋgoroŋga thɨŋa na thɨ vakatha thovuye; Iya thɨ vathuwole ŋgiya bigibigi e lenji ŋgoloŋgolo vurɨvurɨghegheniye tɨnenji iyava thɨ mbanɨŋgi e gabo na e thɨvatharɨko.” ");
INSERT INTO tgo_vpl VALUES ("AM3_11","031_3_11","AMO","3","11","11","Iya kaiwae Giya Loi tembe iŋava ŋgoreiyake: “Ghan thɨghɨya ne i wo len ghamba yakuyakuna na i mukuwo len ghamba vurɨvurɨghegheŋgi na thɨ bigivao lemi ŋgoloŋgolo vurɨvurɨghegheniye bigibiginiye.” ");
INSERT INTO tgo_vpl VALUES ("AM3_12","031_3_12","AMO","3","12","12","Giya Loi iŋa: “Ŋgoreiya sip gharanjimbunjimbu i mban njogha sip gheghe gɨgɨiwo, o mbe yanawae eŋge laiyon me ghanɨvare. Isirel gharɨgharɨniye nevole thɨ vamoruŋgi tembe ŋgoreiyevako; na ma tembene bigi reghava inawe, mbe ghamba ghena ŋginauye na gheghe ghethɨra eŋge. ");
INSERT INTO tgo_vpl VALUES ("AM3_13","031_3_13","AMO","3","13","13","Wo u vandeŋe, na u vanuwovɨrɨŋgiya Jeikob orumburumbuye,” Giya Loi Vurɨvurɨghegheniye iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM3_14","031_3_14","AMO","3","14","14","“Ne mbaŋa ya lithɨ weŋgiya Isirel gharɨgharɨniye lenji tharɨko kaiwae, ne ya mukuwo ghamba vowo Betel e tɨne, ghamba vowoko ghadighadiye ne thɨ mamabebe na thɨ dobu bode. ");
INSERT INTO tgo_vpl VALUES ("AM3_15","031_3_15","AMO","3","15","15","Ne ya rake vawowona lenji ŋgoloŋgolo thotho na yoŋathowathowa ŋgoloŋgolo thɨ vatadɨŋgi na i ndalandala ne thɨ marakerake, na ŋgoloŋgolo laghɨlaghɨye ne thɨko moli.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM4_1","031_4_1","AMO","4","1","1","Wo hu vandeŋe iyake, ghemi Sameriya wanakauniye, iya ghami tabona vondɨvondɨ ŋgoreiya burumwaka i ghan wagiyawe na gha tabo vondɨvondɨ. Basan e tɨne, iya hu vuruvaululeŋgiya ranjavovo na hu ghɨmararaweŋgiya mbinyembinyeŋgu na hu dage weŋgiya lemi ghɨmoghɨmoru thɨ giyagiya waen weŋga hu munumu. ");
INSERT INTO tgo_vpl VALUES ("AM4_2","031_4_2","AMO","4","2","2","Giya Loi Memevoroniye, ele boboma tɨne, i dagerawe iŋa, “Mbaŋa emunjoru ne i mena ne mbaŋaniye thɨ momodɨŋgi e uku, taulaghɨna ghemi ne ŋgoramiya borogi, ina e uku. ");
INSERT INTO tgo_vpl VALUES ("AM4_3","031_4_3","AMO","4","3","3","Na ghemi regha na regha ne i raŋgiya the goga i maviya e (ghembana gha) ganana na thɨ duŋge na i ghemba Hemon.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM4_4","031_4_4","AMO","4","4","4","Giya Loi iŋa, “Isirel gharɨgharɨniye hu raka e ghemba boboma Betel na hu vakatha tharɨ, hu raka Gilgal na tembe vohu vakathava tharɨ. Hu bigimena lemi vowo mbaŋambaŋa regha na regha, lemi vivathana wabwi yaworona iya hu bigimena wabwi regha Loi kaiwae, mbaŋa theghetoninji iya e tɨne. ");
INSERT INTO tgo_vpl VALUES ("AM4_5","031_4_5","AMO","4","5","5","Hu ŋamwo bred na lemi vata ago vowoniye (weya Loi), weiye lemi nemo hu bigimena lemi vata ago mwaewoniye, hu utu raŋgiya na hu wovoreŋaŋga vakathako iyako ghamɨnamina kaero i ghaŋgowe.” Giya Loi ghalɨŋa. ");
INSERT INTO tgo_vpl VALUES ("AM4_6","031_4_6","AMO","4","6","6","“Ya vakathaŋga hu ghae e ghembaghemba regha na regha, na ma ghanɨŋga e lemi valɨvaŋgana laghɨye, iyemaeŋge ma hu raka njoghama e ghino.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM4_7","031_4_7","AMO","4","7","7","“Na tembe ya vakathava na uye ma i nja e ghemi mbaŋa uloulo gha mbaŋa amba manjala umboto i nawe. Ya vakatha uye i nja e ghamba regha ko iyemaeŋge e ghemba reghava ya laweghathɨ. Uma regha uye i njawe, ko iyemaeŋge uma reghava na uye i njawe ghanɨŋga thiya mare. ");
INSERT INTO tgo_vpl VALUES ("AM4_8","031_4_8","AMO","4","8","8","Gharɨgharɨ e ghembaghemba vavana thɨ thɨmbun na ŋgela mbwa kaiwae ko iyemaeŋge ma i ghanagha na valɨkaiwae i ndewoŋgi. Iyemaeŋge na hu raka njoghama e ghino.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM4_9","031_4_9","AMO","4","9","9","“Ya vakatha ndewendewe dayadayaghaniye na mwatamwata thɨ vakowana lemi umauma/ghami na vaen ghanji umauma, na bibita thɨ raka raŋgi thɨ ghanɨŋgiya ghami manjemanje fig na olivɨ. Iyemaeŋge ma hu raka njoghama e ghino.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM4_10","031_4_10","AMO","4","10","10","“Ya vakatha vuyowo laghɨye i yomara e ghemi ŋgoreiya va ya vakatha Ijipt e tɨne. Ya gaboŋgiya lemi ragagaithɨ tabogha e gaithɨ gha ghalithɨ, weiye lemi hosɨŋgi va hu mbanɨŋgi gaithɨ e tɨne. Ya vakatha lemi kiyamuna butiye i mboŋa thiriya mbothɨmi yathiyathiye. Iyemaeŋge ma hu raka njoghama e ghino.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM4_11","031_4_11","AMO","4","11","11","“Ya mukuwoŋgiya ghemi vavana ŋgoreiye va ya mukuwoŋgiya Sodoma na Gomora. Ghemi va ŋgoramiya umbwa i rara na thɨ woraŋgiya e ndɨghe une. Iyemaeŋge ma hu raka njoghama e ghino.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM4_12","031_4_12","AMO","4","12","12","“Iya kaiwae ne ya vakatha iyake, Isirel, na kaiwae ne ya vakatha iyake e ghen, u vivatha na ne u vaidiya Loi le lithɨ, O Isirel. ");
INSERT INTO tgo_vpl VALUES ("AM4_13","031_4_13","AMO","4","13","13","Iye va i monja ouou, na i vakatha ŋgiya ndewendewe na i woraŋgiya le renuwaŋa weŋgiya gharɨgharɨ. Iye i vɨva mbaŋambaŋa i wa e gougou, iye i mbaroŋa yambaneke laghɨye Giya Loi Vurɨvurɨghegheniye amalaghɨniye idae.” ");
INSERT INTO tgo_vpl VALUES ("AM5_1","031_5_1","AMO","5","1","1","Wo hu vandeŋe utuutuke iyake, ghemi Isirel gharɨgharɨniye, iya nuwotharɨke wothuniye, ghino Emos, ya wothuŋake e ghemi. ");
INSERT INTO tgo_vpl VALUES ("AM5_2","031_5_2","AMO","5","2","2","“Isirel iye thɨnabwethubwethuru kaero i dobu, ma tembe i thuweiruva. I ghene ghabana ele thelauko vwatae na ma tene lolo regha i vaŋgu thuweiruva.” ");
INSERT INTO tgo_vpl VALUES ("AM5_3","031_5_3","AMO","5","3","3","Giya Loi Memevoroniye iŋa ŋgoreiyake: “The ghemba laghɨye Isirel e tɨne i variye ŋgiya ragagaithɨ munɨserithaŋarɨ, ko iyemaeŋge mbe/ma munɨthaŋarɨ eŋge thɨ raka njogha; na ghembe laghɨye reghava i variye ŋgiya munɨthaŋarɨ, ko iyemaeŋge mbe/ma theyaworo eŋge thɨ raka njogha.” ");
INSERT INTO tgo_vpl VALUES ("AM5_4","031_5_4","AMO","5","4","4","Giya Loi iŋa ŋgoreiyake weŋgiya Isirel gharɨgharɨniye: “Hu raka njoghama e ghino, amba ne e yawayawalɨmi. ");
INSERT INTO tgo_vpl VALUES ("AM5_5","031_5_5","AMO","5","5","5","Ne hunde raka Beyasiba na vohu kururuwe. Ne hunde mande na hu tamwe vaidiŋgo Betel e tɨne — Betel iye ne nandere moli. Ne hunde raka Gilgal — gharɨgharɨniye ne vethɨ mebwabwari e vanautuma regha.” ");
INSERT INTO tgo_vpl VALUES ("AM5_6","031_5_6","AMO","5","6","6","Hu raka weya Giya Loi, na mbala mbe e yawayawalɨmi. Thoŋgo ma hu rakawe ne i njama ŋgoreiya ndɨghe laghɨye i rara weŋgiya Isirel gharɨgharɨniye. Ndɨgheko ne i ŋambu ŋgiya Betel gharɨgharɨniye, na tembe valɨkaiwaeva lolo regha i vun. ");
INSERT INTO tgo_vpl VALUES ("AM5_7","031_5_7","AMO","5","7","7","O ghemi, iya hu vɨva mbaroko thovuye na i tabo bigi maŋgemaŋgeniye na hu botewayatho iyaŋganiya i rumwaru. ");
INSERT INTO tgo_vpl VALUES ("AM5_8","031_5_8","AMO","5","8","8","Giya Loi i vakatha ghɨtara e njighɨnjighɨ ghamba mbaŋa na dayagha ghamba mbaŋa. Iye i vɨva mbaŋambaŋa i wa e gougou, na ghararaghɨye i wa e gougou. Iye i kukla voreŋa mbwa/njighɨ e njighɨko tɨne na i liŋgi e yambaneke. Iye idae Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("AM5_9","031_5_9","AMO","5","9","9","Iye i womena mukuwo weŋgiya thavala thɨ vurɨgheghe na ve nja weŋgiya lenji ŋgoloŋgolo vurɨvurɨghegheniye. ");
INSERT INTO tgo_vpl VALUES ("AM5_10","031_5_10","AMO","5","10","10","Ghemi hu botewayatho thela i ŋgiwetho tharɨ utuniye e kot/niva, na hu botewayatho thela i utuutu emunjoru. ");
INSERT INTO tgo_vpl VALUES ("AM5_11","031_5_11","AMO","5","11","11","Hu goriwoyathu mbinyembinyeŋgu na hu naŋguŋgwa lenji wit. Iya kaiwae, othembe hu vatad ŋgiya ŋgoloŋgolo thovuthovuye e varɨvarɨ mane huya yakuwe, othembe hu kabwa waen gha uma thovuthovuye, mane hu muna waen e nɨkinjiko. ");
INSERT INTO tgo_vpl VALUES ("AM5_12","031_5_12","AMO","5","12","12","Kaiwae ya ghareghare lemi tharɨna i laghɨye moli, na lemi vakatha vatharɨ i ghanagha. Hu vakatha vatharɨ weya lolo rumwarumwaruniye, na u vavaloghe na hu ndeganegane mbinyembinyeŋgu le kot e tɨne. ");
INSERT INTO tgo_vpl VALUES ("AM5_13","031_5_13","AMO","5","13","13","Iya kaiwae thela hu goriwoyathu iye i manabu na i rokubaro iya e tharɨke ghanji mbaŋa iyako tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("AM5_14","031_5_14","AMO","5","14","14","Hu tamweya thovuye, na thava tharɨ, amba ne e yawayawalɨmi. Na mbala Giya Loi Vurɨvurɨghegheniye i thalavuŋga, ŋgoreiya mbaŋake wolaghɨye huŋama iye weimi. ");
INSERT INTO tgo_vpl VALUES ("AM5_15","031_5_15","AMO","5","15","15","Hu botewayatho tharɨ, na hu gharethovuwa thovuye, na hu vakatha na thovuye ko e tɨnenji. Mbwata ambane Giya Loi Vurɨvurɨghegheniye iya amba e yawayawalinjiko. ");
INSERT INTO tgo_vpl VALUES ("AM5_16","031_5_16","AMO","5","16","16","Iya kaiwae Giya Loi, Giya Loi Vurɨvurɨghegheniye iŋa: “Mbene randa eŋge e kamwakamwathɨko wolaghɨye, na raŋa vetho laghɨye e ghamba mevathavathako wolaghɨye. Ne thɨ kula weŋgiya rakakaiwo e umauma thɨ raka mena thiya randa, na thɨ vamodoŋgiya gharɨgharɨ thɨ raka mena thiya randa kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("AM5_17","031_5_17","AMO","5","17","17","E waenɨko ghanji umaumako wolaghɨye mbene randa eŋge Iyake ne thɨ yomara kaiwae ne ya mena ya giya vuyowo e ghemi.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM5_18","031_5_18","AMO","5","18","18","Aleu! Nevole hu thovuyaona, iye thavala ghemi iya nuwamina mbe i nawe vara Giya Loi gha mbaŋa gatheko. Buda kaiwae nuwamiya Giya Loi gha mbaŋako i mena? Mbaŋako iyako ne momouwo, mane manjamanjala. ");
INSERT INTO tgo_vpl VALUES ("AM5_19","031_5_19","AMO","5","19","19","Nevole ŋgoreiya amala regha i vogha weya laiyon na ma ve lavolevoleva beya, na tembe ŋgoreiyeva ve ru ele ŋgolo i liraweya nɨmae e babako na kaero mwata mamate i gharɨva. ");
INSERT INTO tgo_vpl VALUES ("AM5_20","031_5_20","AMO","5","20","20","Ko uŋa eŋge Giya Loi gha mbaŋa mane i momouwo na ma manjamanjala i nawe? Mbwana i momouwo ma manjamanjalaniye. ");
INSERT INTO tgo_vpl VALUES ("AM5_21","031_5_21","AMO","5","21","21","Giya Loi iŋa, “Ya botewa, ya botewayathu moli, iya lemi kururuna thaganiyeŋgi na lemi mevathavatha thɨ vakatha ghambwera e ghino. ");
INSERT INTO tgo_vpl VALUES ("AM5_22","031_5_22","AMO","5","22","22","Othembe hu bigi mena mwaewo ghanɨŋga vowo ŋambuŋambu kaiwae na mwaewo wit vowo kaiwae mena ya wovatha. Othembe ne hu womena thetheghan gha tabo vondɨvondɨ lemi mwaewo vɨghathɨ vowoniye mane ya wovatha. ");
INSERT INTO tgo_vpl VALUES ("AM5_23","031_5_23","AMO","5","23","23","Hu viyatho ghami wothuŋgina hu wothuwothuna mane ya vandeŋe lemi hapɨna ghalɨŋae. ");
INSERT INTO tgo_vpl VALUES ("AM5_24","031_5_24","AMO","5","24","24","Ko iyemaeŋge mbe hu vakatha na thovuye weŋgiya mbinyembinyeŋgu ŋgoreiya imba mbe i voruvoru vara, na hu vakatha thanavu rumwarumwaruniye ŋgoreiya i voru valaŋa. ");
INSERT INTO tgo_vpl VALUES ("AM5_25","031_5_25","AMO","5","25","25","Isirel gharɨgharɨniye, mara ya noŋguŋga vowo na waewa e ghemi theghathegha ghwevarɨko e tɨne iyava ya vivako e ghemi e njamnjamɨbwagako. ");
INSERT INTO tgo_vpl VALUES ("AM5_26","031_5_26","AMO","5","26","26","Ko iyemaeŋge mbaŋake, kaiwae kaero hu kururu weya vatavatadɨ Sakut, lemi kiŋ loi, na tembe ŋgoreiyeva Kaiwan, lemi ghɨtara loi, ne hu bigiŋgiya iya loi vatavatadɨŋgina thiyana ");
INSERT INTO tgo_vpl VALUES ("AM5_27","031_5_27","AMO","5","27","27","mbaŋa ne ya vaŋguŋga vohu mebwabwari e valɨvaŋga Damasiko, na vaŋga/ghereiyeko.” Giya (Loi) iŋa, iye idae Loi Vurɨvurɨghegheniye. ");
INSERT INTO tgo_vpl VALUES ("AM6_1","031_6_1","AMO","6","1","1","Aleu! Ne hu thovuyeona, ghemi iya riwamina i uda Saiyon e tɨne na ghemi hu yayaku Sameriya na hu vaidi malɨlɨ. Ghemi gharɨgharɨ laghɨlaghɨye Isirel e tɨne, iya thavala ghemi gharɨgharɨ thɨ rakaraka weŋgi thalavu kaiwae. ");
INSERT INTO tgo_vpl VALUES ("AM6_2","031_6_2","AMO","6","2","2","Hu dage weŋgi gharɨgharɨna: wo hu raka na vohu thuwe ghembana idae Kalne, na mbowo hu waova e ghembana laghɨye idae Hamat, na mbowo hu ghaova vohu nja e ghembana idae Gat ina Pilistiya e tɨne. Thare thiyeko va thɨ thovuye kivwalaŋgiya Juda na Isirel lenji ghamba mbaro? Thare lenji vanautumako le laghɨlaghɨye i kivwala gheminawe? ");
INSERT INTO tgo_vpl VALUES ("AM6_3","031_6_3","AMO","6","3","3","Hu mwana ghaghatha mukuwo gha mbaŋa na hu mwana vatha tharɨ gha mbaŋa ne i mbaro. ");
INSERT INTO tgo_vpl VALUES ("AM6_4","031_6_4","AMO","6","4","4","Aleu! Ne hu thovuyeona, ghemi thavala hu romataleŋarawe e ghamba yaku thovuye moli na huya ghanɨthɨgha e burumwaka na sip lenji ŋgamaŋgama ghanji tabo vondɨvondɨ. ");
INSERT INTO tgo_vpl VALUES ("AM6_5","031_6_5","AMO","6","5","5","Nuwamina nuwaiya hu iiya wothu, ŋgoreiye Deivid va i vakatha, na hu wothuŋa weiye hap. ");
INSERT INTO tgo_vpl VALUES ("AM6_6","031_6_6","AMO","6","6","6","Hu muna waen iya i riyevanjara ghami ndeghɨna laghɨlaghɨye na hu vaghana bunama butinji thovuthovuye e riwamina, ko iyemaeŋge e gharemina ma hu gharevɨrɨŋa vuyowoko iya ne i nja weŋgi Josep orumburumbuye. ");
INSERT INTO tgo_vpl VALUES ("AM6_7","031_6_7","AMO","6","7","7","Iya kaiwae ghemi ne vohu mebwabwarikai vara e vanautuma regha; lemi riyemataleŋa e ghamba ghena thovuye moli na lemi ghan thɨgha kaero iko. ");
INSERT INTO tgo_vpl VALUES ("AM6_8","031_6_8","AMO","6","8","8","Giya (Loi) Memevoroniye i tholo weya ghamberegha Giya Loi Vurɨvurɨghegheniye iŋa: “Ya botewoyathu Isirel gharɨgharɨniye lenji nemo, ya botewoyathu lenji ŋgoloŋgolo laghɨlaghɨye ne ya giya ghambanji laghɨye na bigibigiko wolaghɨye e tɨneko weŋgiya ghanji thɨghɨya.” ");
INSERT INTO tgo_vpl VALUES ("AM6_9","031_6_9","AMO","6","9","9","Thoŋgo gharɨgharɨ theyaworo inanji e ŋgolo regha tɨne, thiye tembene thɨ mareva. ");
INSERT INTO tgo_vpl VALUES ("AM6_10","031_6_10","AMO","6","10","10","Na thoŋgo loloko i mareko le boda i mena i woraŋgiya riwaeko, na i kula ruu weya thela mbe ina e ŋgoloko tɨne i kubaro, iŋa, “Thare lolo regha mbe inava ghena wein?” Thoŋgo iŋa, “Nandere.” Ko amba i gonjoghawe na iŋa, “U rokubaro! Ra njimbukiki na thava tembe ra unova Giya Loi idae.” ");
INSERT INTO tgo_vpl VALUES ("AM6_11","031_6_11","AMO","6","11","11","Kaiwae Giya Loi ne iŋa na ŋgolo laghɨye ne i dobu na i rakevawowona, na ŋgolo nasiye i maŋgɨla. ");
INSERT INTO tgo_vpl VALUES ("AM6_12","031_6_12","AMO","6","12","12","Hosɨ thare valɨkaiwanji thɨ ruku reŋa e varɨvarɨ vwatanji? Thare gharɨgharɨ thɨ vakatha uma e njighɨko tɨne? Ko iyemaeŋge hu vɨva emunjoru i tabo mamate na rumwaru gha vakatha une i wa e umbwa une maŋgamaŋga. ");
INSERT INTO tgo_vpl VALUES ("AM6_13","031_6_13","AMO","6","13","13","Nuwamina mbema i loghe vara kaiwae menda u gaithɨ vurɨgheghe na hu wo ghembana idae Lo Deba, Na hu wovoreŋa ghamberegha huŋa, Mbe ghime e lama vurɨgheghe e tɨne wo wo ghemba Kanaim. ");
INSERT INTO tgo_vpl VALUES ("AM6_14","031_6_14","AMO","6","14","14","Ko iyemaeŋge Giya Loi Vurɨvurɨghegheniye iŋa, “Ne ya vakatha vanautuma regha thɨ mena thɨ gaithɨ weŋga O ghemi Isirel gharɨgharɨniye ne thɨ vakatha vuyowo e ghemi iri Hamat na ve wo gunugu Araba.” ");
INSERT INTO tgo_vpl VALUES ("AM7_1","031_7_1","AMO","7","1","1","Giya Loi Memevoroniye i woraŋgiya vatomweke iyake e ghino. E tɨne ya thuwe i vakatha bibita lemoyo moli, mbaŋaniye vara rakakaiwo amba thɨ tenɨ eŋge wit kiŋ kaiwae. Na tembe e mbaŋaniyeva weiwo togha amba thɨ yovoro eŋge. ");
INSERT INTO tgo_vpl VALUES ("AM7_2","031_7_2","AMO","7","2","2","E lo thuweko ya thuwe bibitako thɨ ghanɨvaoŋgiya nanako wolaghɨye, amba yaŋa, “Giya Loi Memevoroniye, u numotenɨŋgi len gharɨgharɨ. Ne ŋgoroŋga na mbe e yawayawalinji? (E maran) thiye nanasiye moliŋgi na thɨ njavovo.” ");
INSERT INTO tgo_vpl VALUES ("AM7_3","031_7_3","AMO","7","3","3","Amba Giya Loi i vɨva le renuwaŋa na iŋa, “Budakai mo thuwena mane i yomara ŋgoreiye.” ");
INSERT INTO tgo_vpl VALUES ("AM7_4","031_7_4","AMO","7","4","4","Giya Loi Memevoroniye tembe i woraŋgiyava vatomwe regha e ghino. E tɨne ya thuwe i vakatha varaeko dayaghawa i vurɨgheghe moli na i giya vuyowo weŋgiya gharɨgharɨko. Dayaghako i vakatha njighɨ na mbwa e yambaneke raberabe i mame na i vakatha thelauko ŋgoreiya vugha. ");
INSERT INTO tgo_vpl VALUES ("AM7_5","031_7_5","AMO","7","5","5","Amba ya dagewe yaŋa, “Meiye Giya Loi. Ne ŋgoroŋga na len gharɨgharɨ mbe e yawayawalinji? (E maran) thiye nanasiye moliŋgi na thɨ njavovo.” ");
INSERT INTO tgo_vpl VALUES ("AM7_6","031_7_6","AMO","7","6","6","Giya Loi Memevoroniye i vɨva le renuwaŋa na iŋa, “Budakai mo thuwe mane i yomara ŋgoreiye.” ");
INSERT INTO tgo_vpl VALUES ("AM7_7","031_7_7","AMO","7","7","7","Giya Loi Memevoroniye mbowo i woraŋgiyava vatomwe regha e ghino. E tɨne ya thuwe i ndeghathɨ e dumodumo ghadidiye va thɨ vatad, thɨ vakaiwoŋa rumwaru gha gherughɨrughɨ, na va i ndethɨna rumwaru gha gherughɨrughɨ e nɨmae. ");
INSERT INTO tgo_vpl VALUES ("AM7_8","031_7_8","AMO","7","8","8","I vaitoŋgo iŋa, “Emos, u thuwe budakai?” Ya gonjoghawe, yaŋa, “Rumwaru gha gherughɨrughɨ.” Amba iŋa, “Ya vakaiwoŋa rumwaru gha gherughɨrughɨ na i woraŋgiya lo gharɨgharɨ ŋgoranjiya dumodumo ma thɨ mboromboro. Mane tembe ya vɨvɨva le renuwaŋa iya nuwaŋguiya ya lithɨko weŋgi. ");
INSERT INTO tgo_vpl VALUES ("AM7_9","031_7_9","AMO","7","9","9","“The valɨvaŋga Aisake orumburumbuye thɨ kururuwe ne ya mukuwo. The valɨvaŋga thɨ boboma Isirel e tɨne ne ya vakowana ne ya gaithɨ na ya kivwala Kiŋ Jerobowam.” ");
INSERT INTO tgo_vpl VALUES ("AM7_10","031_7_10","AMO","7","10","10","Amba Amajaiya, iye Betel gha ravowovowo i variye toto weya Jerobowam, iye Isirel gha kiŋ, iŋa, “Emos i von thuwole ghan gharɨgharɨna e tɨnenji. Le utuutuna mane gharɨgharɨ thɨ goriwoyathu, ne i mukuwo vanautumana. ");
INSERT INTO tgo_vpl VALUES ("AM7_11","031_7_11","AMO","7","11","11","Iŋa ŋgora iyake, ‘Jerobowam ne i mare e gaithɨ tɨne, na ne thɨ vaŋguŋgi Isirel gharɨgharɨniye na thɨ raka itete lenji ghamba yakuyaku na vethɨ mebwabwari e vanautuma regha.’” ");
INSERT INTO tgo_vpl VALUES ("AM7_12","031_7_12","AMO","7","12","12","Amba Amajaiya i dagewe Emos, iŋa, “Wo u itete valɨvaŋgake iyake, ghen vavaghare gharathuwe! Wo u njogha Juda na vo utuŋa Giya Loi ghalɨŋae gheko, na thiyena tene thɨ giya ghanɨŋga e ghen. ");
INSERT INTO tgo_vpl VALUES ("AM7_13","031_7_13","AMO","7","13","13","Thava u utuŋa Giya Loi ghalɨŋae gheke, Betel e tɨneke. Gheke kiŋɨke le ghamba kururu, na vanautumake laghɨye lenji ghamba kururu.” ");
INSERT INTO tgo_vpl VALUES ("AM7_14","031_7_14","AMO","7","14","14","Emos i gonjogha weya Amajaiya, iŋa, “Ghino ma ghalɨŋae gharautu regha, iya thavala thɨ utuŋa Loi ghalɨŋaeko na thɨ ghana uneko. Ghino sip gharanjimbukiki, na tembe ya njimbukikiva manjemanje idanji fig. ");
INSERT INTO tgo_vpl VALUES ("AM7_15","031_7_15","AMO","7","15","15","Ko iyemaeŋge Giya Loi mbeghamberegha vara i vaŋgu raŋgiyaŋgo e wo kaiwoko tɨne — ghino sip gharanjimbunjimbu — na i dage e ghino ya wa na va utuŋa ghalɨŋae weŋgi le gharɨgharɨ Isirel.” ");
INSERT INTO tgo_vpl VALUES ("AM7_16","031_7_16","AMO","7","16","16","“Iya kaiwae wo u vandeŋe Giya Loi ghalɨŋae mbaŋake, moŋa, ‘Thava vo utuŋa utuutuna iyana weŋgiya Isirel gharɨgharɨniye, na thava vo vavaghareŋa weŋgiya wabwi Aisake.’ ");
INSERT INTO tgo_vpl VALUES ("AM7_17","031_7_17","AMO","7","17","17","Kaiwae mo utu ŋgoreiyako, Giya Loi iŋa, ‘Len ŋgamaŋgama ne thɨ mare gaithɨ e tɨne, len ghamba yakuyakuna/vanautumana ne thɨ kivwalaŋgi e gaithɨ, na len ghamba yakuyakuna ne thɨ tagaviyaviya na thɨ giya weŋgi thavala thɨ kivwalaŋge e gaithɨ, len wevona ne i vakuneŋa riwae e ghamban na tɨne, na ghen ne thɨ vaŋguŋge na tene vo mare e vanautuma mbe regha. Mbwana, Isirel gharɨgharɨniye ne thɨ vaŋguŋgi na vethɨ mebwabwari e vanautuma regha.’” ");
INSERT INTO tgo_vpl VALUES ("AM8_1","031_8_1","AMO","8","1","1","Gheke Giya Loi Memevoroniye tembe i vatomweva vavaghare regha e ghino; iyako manjemanje uneune inanji e nambo tɨne. ");
INSERT INTO tgo_vpl VALUES ("AM8_2","031_8_2","AMO","8","2","2","Iwaeŋge Giya Loi i vaito Emos, iŋa, “U thuwe budakai?” Emos i gonjoghawe, iŋa, “Manjemanje uneune.” Amba Giya Loi i dage e ghino, iŋa, “Mbaŋa kaero iko lo gharɨgharɨ Isirel kaiwanji. Mane tembe ya vɨvɨva lo renuwaŋa iya nuwaŋguiya ya lithɨko weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("AM8_3","031_8_3","AMO","8","3","3","Giya Memevoroniye iŋa, “Ne e mbaŋako iyako wanakau thɨ wothuwothu e Ŋgolo Boboma tɨne ne i tabo randa. Ramaremare riwanji ne lemoyo moli na ne thɨ yathuŋgi eto. Huya rokubaro!” ");
INSERT INTO tgo_vpl VALUES ("AM8_4","031_8_4","AMO","8","4","4","Wo hu vandeŋe iyake, giyagiyana ghemi iya hu vuruvaululeŋgiya ranjavovo na hu munjeva hu mukuwoŋgi mbinyembinyeŋgu e vanautumake iyake tɨne. ");
INSERT INTO tgo_vpl VALUES ("AM8_5","031_8_5","AMO","8","5","5","E nuwamina huŋa, “The mbaŋa Manjala Togha gha mbaŋa iko na kaero vo vakuneŋava wit. Na thembaŋa Sabat veko na voya vakuneva?” Mbala vo wovoroŋa witɨko yaŋunjawae modae, na wo vakaivɨŋaŋgi ravavamodo e gherughɨrughɨ kwanɨkwan. ");
INSERT INTO tgo_vpl VALUES ("AM8_6","031_8_6","AMO","8","6","6","Ne ra vamodoŋgiya mbinyembinyeŋgu na thɨ tabo rakakaiwobwaga kaiwae ma valɨkaiwanji thɨ vamodo ghanji ghagako, othembe thoŋgo ghagako nasiye ŋgoreiye ghegha ghae modae. ");
INSERT INTO tgo_vpl VALUES ("AM8_7","031_8_7","AMO","8","7","7","Giya Loi, iya Isirel le ghamba sirariko kaero i dagerawe iŋa: “Emunjoru mane ya renuwaŋa vaghawe lenji vakathako raraitharɨ.” ");
INSERT INTO tgo_vpl VALUES ("AM8_8","031_8_8","AMO","8","8","8","Iyake kaiwae yambaneke ne i mbarɨmbarɨrɨ na gharɨgharɨke wolaghɨye ne thiya randa. Vanautumake laghɨye ne i ragheragheghe; ne i voro na i nja ŋgoreiya Walaghɨta Nael Ijipt e tɨne. ");
INSERT INTO tgo_vpl VALUES ("AM8_9","031_8_9","AMO","8","9","9","Giya Loi Memevoroniye iŋa, “Ne ya vakatha varae i ghawe ghararaghɨye mboro na yambaneke i momouwo ghararaghɨye. ");
INSERT INTO tgo_vpl VALUES ("AM8_10","031_8_10","AMO","8","10","10","Ne ya vakathaŋga e lemi thagana tɨne ma huya warari, ko mbema nuwatharɨ eŋge. Na ya vɨva ghami wothu vawarari na iwa e nuwatharɨ. Ne ya vakatha taulaghɨna ghemi umbalɨmina thiya vwata, na ya vakathaŋga hu njimbo kwama bwedibwedi. Ne ya vakatha mbaŋako iyako ŋgoreiye lolo regha i nuwatharɨŋa nariye mbe regha eŋge vara i mare kaiwae, na bigibigike wolaghɨye ne thɨ yomara mbe weiye eŋge nuwotharɨ laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("AM8_11","031_8_11","AMO","8","11","11","Giya Loi Memevoroniye iŋa, “Mbaŋa ma iya i menamenake, mbaŋaniye ne ya vakatha na vunuvu i yomara e valɨvaŋgana iyana. Ma vunuvu ghanɨŋga kaiwae o mbwa, ko iyemaeŋge vunuvu Loi ghalɨŋae kaiwae. ");
INSERT INTO tgo_vpl VALUES ("AM8_12","031_8_12","AMO","8","12","12","Gharɨgharɨ ne thiya loŋga, iri e Njighɨ Maremareniye i wo Njighɨ Meditareiniyan, na vethɨ vaghɨliye e ghaiwabuko na vewo e boimako. Ne thɨ tamwe tako valɨvaŋgake wolaghɨye Giya Loi ghalɨŋae kaiwae, ko iyemaeŋge mane thɨ vaidi. ");
INSERT INTO tgo_vpl VALUES ("AM8_13","031_8_13","AMO","8","13","13","Othembe ne e mbaŋako iyako, ghɨmoghɨmoru na wanakau ghanji yamoyamo thovuye ne ghare thavwathavwa i nja weŋgi mbwa kaiwae. ");
INSERT INTO tgo_vpl VALUES ("AM8_14","031_8_14","AMO","8","14","14","Gharɨgharɨko thiyako iya thɨ tholo weŋgi loi vatavatadɨ Sameriya e tɨne, thɨŋa, ‘loi vatavatadɨ Dan e idae,’ o ‘loi vatavatadɨ Beyasiba gha loi idae,’ gharɨgharɨke thiyake ne thɨ dobu na ma tembe thɨ thuweiruva.” ");
INSERT INTO tgo_vpl VALUES ("AM9_1","031_9_1","AMO","9","1","1","Ma thuwe Giya Loi i ndeghathɨ e ghamba vowo ghadidiye na i dage e ghino iŋa: “U ŋge Ŋgolo Boboma gha tu iya yamoena. U ŋge vurɨgheghe moli na ŋgolona laghɨye i mbarɨrɨ ŋgolouya. U taga ŋgɨlaŋgɨlaŋgi na thɨ dobu gharɨgharɨna e umbalɨnji. Ne ya gaboŋgiya thavala mbe inanji e gaithɨ tɨne. Mane regha i vo, mane regha i voghawe. ");
INSERT INTO tgo_vpl VALUES ("AM9_2","031_9_2","AMO","9","2","2","Othembe ne thɨ tɨgha doda i nja thambe, nɨmaŋguke ne i bigi voreŋaŋgi gheko. Othembe ne thɨ raka voro e buruburu ne ya bigi njoŋaŋgi. ");
INSERT INTO tgo_vpl VALUES ("AM9_3","031_9_3","AMO","9","3","3","Othembe ne vethɨ kubaro e ou Kamel vwatae, ne ya tamweŋgi na ya laweŋgi. Othembe ne thɨ kubaro e maraŋgu e njighɨko tɨne bode moli, ne ya dage weya njighɨko thetheghanɨniye thɨ gharɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("AM9_4","031_9_4","AMO","9","4","4","Othembe thoŋgo ghanji rathɨghɨya thɨ vaŋguŋgi na vethɨ mebwabwari e vanautuma regha, ne yaŋa na thɨ gaboŋgi e gaithɨ gha ghalithɨ. Maraŋgu mbene i na vara weŋgi; na ne thɨ vaidiya mbwara, ma thovuye.” ");
INSERT INTO tgo_vpl VALUES ("AM9_5","031_9_5","AMO","9","5","5","Mbaŋa Giya Loi Vurɨvurɨghegheniye i vɨghathɨgha yambaneke, ne i mbarɨmbarɨrɨ na gharɨgharɨ thɨ raŋiŋgiya thavala thiya mare. Yambaneke laghɨye ne i thotho ŋgoreiya Walaghɨta Nael, na ne i dobu ŋgoreiye Nael ina Ijipt. ");
INSERT INTO tgo_vpl VALUES ("AM9_6","031_9_6","AMO","9","6","6","Giya Loi Vurɨvurɨghegheniye i vatadɨ le ŋgolo e buruburuko na i vakatha gha yayaoko e yambaneke. I kula voreŋa mbwa e njighɨko tɨne na i liŋgi yathu e yambaneke vwata. Amalaghɨniye idae Giya. ");
INSERT INTO tgo_vpl VALUES ("AM9_7","031_9_7","AMO","9","7","7","Giya Loi iŋa, “O Isirel gharɨgharɨniye, ghemi e maraŋgu hu mboromboro weimiyaŋgiya Itiyopiya gharɨgharɨniye. Va ya vaŋgu raŋgiyaŋgi Isirel gharɨgharɨniye Ijipt e tɨne, Pilistiya gharɨgharɨniye Krit e tɨne na Siriya gharɨgharɨniye Kirɨ e tɨne. ");
INSERT INTO tgo_vpl VALUES ("AM9_8","031_9_8","AMO","9","8","8","Emunjoru Giya Loi Ravurɨgheghe marae mbe ina vara weŋgi vanautumako raitharɨ Isirel. Ne ya mukuwoŋgi e yambaneke vwatae, ko iyemaeŋge Jeikob orumburumbuye mane ya mukuwo vaoŋgi.” Giya Loi iŋa. ");
INSERT INTO tgo_vpl VALUES ("AM9_9","031_9_9","AMO","9","9","9","“Ne ya variye ghalɨŋaŋgu na thɨ (loloŋgiya) Isirel gharɨgharɨniye ŋgoreiya thɨ (lolo) muthu e (lolo) na ma wokɨwokɨye mun thɨ dobu. Ne ya (lolo) na ya vaŋgu raŋgiyaŋgiya gharɨgharɨ raraitharɨ vanautumake wolaghɨye e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("AM9_10","031_9_10","AMO","9","10","10","Tharɨ gha ravakathako wolaghɨye ne thɨ gabovaoŋgi e gaithɨ gha ghalithɨ — iya thavala thɨŋa, ‘Loi mane i vatomwe tharɨ i mena evasiwanda.’” ");
INSERT INTO tgo_vpl VALUES ("AM9_11","031_9_11","AMO","9","11","11","Giya Loi iŋa, “Ne e mbaŋako iyako tɨne ne ya vatadɨ njogha Deivid le ghamba mbaro kaiwae kaero ŋgoreiye ŋgolo i dobu na i marakaraka. Ne ya vatadɨ njogha gha ganako. Ne ya vatadɨ njogha na tembe ŋgoreiyeva va i vivako. ");
INSERT INTO tgo_vpl VALUES ("AM9_12","031_9_12","AMO","9","12","12","Na mbala Isirel gharɨgharɨniye thɨ kivwalaŋgi Idom na budakai mbe ina e ghamba mbaroko tɨne na vanautumako wolaghɨye iya mbaŋa regha va thɨ tabo lo ghamba mbaro.” Giya Loi ghalɨŋae ŋgoreiye iyako iyava i vakatha thiya yomara. ");
INSERT INTO tgo_vpl VALUES ("AM9_13","031_9_13","AMO","9","13","13","Giya Loi iŋa, “Wo hu thuwe, mbaŋa ma iya i menamenake mbaŋaniye thelauko ne i thovuye na i madi. Ghanɨŋga ne thɨ maya thɨ mweghe e umaumako tɨnenji. Uloulo na kabu ne thɨ vembelembeleŋgi, waen uneune ne lemoyo na gharɨgharɨ ma valɨkaiwanji thɨ imbɨvao. Waen uneune nɨkinji ne thɨ voru njogha e ououko thɨ kabuŋgikowe na i voru njogha e bobokuluŋgiko. ");
INSERT INTO tgo_vpl VALUES ("AM9_14","031_9_14","AMO","9","14","14","Ne ya vaŋgu njoghaŋgi lo gharɨgharɨ Isirel thɨ raka njogha e lenji ghamba yakuyaku. Ne thɨ vatadɨ njoghaŋgi ghembaghembako na thiya yakuwe, ne thɨ kabuŋgiya waen na thɨ muna nɨkinji, ne thɨ kabuŋgi umauma na thɨ ghanɨŋgi budakai thɨ kabuŋgi. ");
INSERT INTO tgo_vpl VALUES ("AM9_15","031_9_15","AMO","9","15","15","Ne ya bigiraweŋga e lemi ghamba yakuyaku iyava ya giyana e ghemi na ma tene thɨ vaŋgu raŋgiyaŋgava.” Giya lemi Loi ghalɨŋa iyako. ");
INSERT INTO tgo_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Va mbaŋa regha Giya Loi ghalɨŋae i mena weya Jona Amitai nariye. ");
INSERT INTO tgo_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","I dagewe iŋa, “U yondovirɨ Jona, na e ghembako laghɨye Ninive e tɨne, u dage weŋgi lenji tharɨ i laghɨye moli na tene ya mukuwoŋgi.” ");
INSERT INTO tgo_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ko iyemaeŋge Jona i voiteta Giya Loi na ma i wareriŋava ghemba regha idae Tasis. I wareri na i wa Jopa, na gheko ve vaidiya waŋga regha kaero ghambaŋa vara i wareri Tasis kaiwae. Jona i wa ve vamodo waŋgako, kaero i thawe na i wa Tasis kaiwae i munjeva i voiteta Giya Loi. ");
INSERT INTO tgo_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Amba Giya Loi i variya ndewendewe vurɨvurɨghegheniye regha na i nja weŋgi e ghɨnagha mborowa. Ndewendeweko le vurɨgheghe kaiwae waŋgako vama ina vara e tharɨ tɨne. ");
INSERT INTO tgo_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Gharelaghɨlaghɨ kaiwae waŋgako gharakakaiwo regha na regha tembe i goyawaru weya le loi thalavu kaiwae. Lenji renuwaŋa thɨ munjeva thɨ vamayaŋa waŋgako e vuyowoko tɨne, thɨ mbana doweko vavana thɨ yathu e njighɨko tɨne. Ko iyemaeŋge e mbaŋako iyako Jona vambe ina e waŋgako gharɨghe, e tɨne bode i ghenetena yawaliye. ");
INSERT INTO tgo_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Waŋgako ghakapɨtan i nja na ve vaidi na i dagewe iŋa, “Ko iya ŋgoroŋga mbe len ghenaeŋge e waŋgako tɨne? U thuweiru na wo u naŋgo weya len loi. Mbwata ne ghare i nja weinda na ma valɨkaiwae raya mare.” ");
INSERT INTO tgo_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Waŋgako gharakakaiwo thɨ vedage weŋgi thɨŋa, “Wo ra tamwe thela le tharɨ kaiwae iya ra vaidiya vuyowoke iyake. Wo ra vakatha bigi regha ŋgoreiye sula.” Mbaŋa thɨ vakatha iyako ve nja weya Jona. ");
INSERT INTO tgo_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Iya kaiwae thɨ vaito thɨŋa, “E mbaŋake iyake wo u utu giyama weime, thela le tharɨ kaiwae na iya vuyowoke iyake i yomara weinda? U vakatha budakai gheke? The vanautuma loloniya ghen? The wabwi loloniya ghen?” ");
INSERT INTO tgo_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","I gonjogha weŋgi iŋa, “Hibru loloniya ghino na ya kururu weya Giya Loi, Loi ina e buruburu, iye va i vakatha njighɨ na thelau.” ");
INSERT INTO tgo_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Waŋgako gharakakaiwo thɨ gharelaghɨlaghɨ laghɨye moli na thɨ dagewe thɨŋa, “Budakaiya iya mo vakathake?” (Thɨ ghareghare mendava i vo weya Giya Loi kaiwae me utu giya weŋgi.) ");
INSERT INTO tgo_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Lenji utuutuko e tɨne ndewendeweko ma i vurɨgheghe na i vurɨgheghe eŋge. Iya kaiwae thɨ vaito thɨŋa, “Ne wo vakatha budakai e ghen na mbala ndewendeweko i rowo towo na ghime yawalɨme?” ");
INSERT INTO tgo_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Jona i gonjogha weŋgi iŋa, “Hu woŋgo na hu duutuŋgo e njighɨke tɨne, ambane tad i ghagha. Ya ghareghare ghino kaiwaŋgu iya hu vaidiya vuyowoke iyake.” ");
INSERT INTO tgo_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Iyemaeŋge waŋgako gharakakaiwo thɨ wodo na thɨ munjeva thɨ goru vanatɨna — thɨ rovurɨgheghe laghɨye moli, ko iyemaeŋge ndewendeweko vama i vurɨgheghe eŋge na vanatɨna ma i bwagabwaga moli eŋge weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Iya kaiwae thɨ goyawaru weya Jona le Loi thɨŋa, “Aee Giya Loi, wo naŋgo e ghen thava ne u lithɨ e ghime e mare kaiwae ne wo vakowana loloke iya ma ghawonjoweke yawaliye. Ghen mbe ghanɨmbereghana vara iya len renuwaŋa vakathake thiyake thɨ yomara.” ");
INSERT INTO tgo_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Thɨ wovaira Jona e nɨmanɨmanji na thɨ wokiyathuutu e njighɨko tɨne. E mbaŋako iyako tad i ghagha. ");
INSERT INTO tgo_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Iyako i vathaŋgiya waŋgako gharakakaiwo thɨ mararu laghɨye moli weya Giya Loi iya kaiwae thɨ vakatha vowo na i vorowe na thɨ vakatha ŋgoreiye lenji dagerawe. ");
INSERT INTO tgo_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Ko iyemaeŋge Jona kaiwae, Giya Loi i vivatharawa borogi laghɨye regha na i wovoŋgwa Jona. Jona va ina e borogiko ŋgamoiye ghararaghɨye thegheto na gougou gheneto. ");
INSERT INTO tgo_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Maya borogiko e ŋgamoiye tɨne, Jona i naŋgo weya Giya Loi le Loi. ");
INSERT INTO tgo_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Iŋa: “Mbaŋa inaŋgu vuyowo laghɨye e tɨne, na ya una Giya Loi idan, kaero u thalavuŋgo. Bode moli ramaremare e ghambanji, ya una idan thalavu kaiwae, na u loŋwa ghalɨŋaŋgu. ");
INSERT INTO tgo_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","U duutuŋgo e ŋambuwoko tɨne bode moli, njighɨ i vaghɨliyaŋgo, len bagodu laghɨlaghɨye thɨ bebe e vwataŋgu. ");
INSERT INTO tgo_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Lo renuwaŋa yaŋaeŋge kaero mendava u kitenɨyathuŋgo e ghen ko tembene ya thuweva len Ŋgolo Boboma. ");
INSERT INTO tgo_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Mbwa i wovululuŋgo na i wovoŋguŋgo; na njighɨ i garubu riwaŋguke laghɨye, na njighɨko wolewaniye i ghavwa umbalɨŋgu. ");
INSERT INTO tgo_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ya nja e ŋambuwokote e ououko rɨgherɨghenji e valɨvaŋgake iya ghathɨnɨmbako ma mbaŋa regha i mavu. Ko iyemaeŋge ghen, wo Giya Loi, lo Loi, u vaŋgunjoghaŋgo e yawayawaliŋgu bode moli e ŋambuwoko tɨne. ");
INSERT INTO tgo_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Mbaŋa ya ghamɨno yawaliŋgu kaero ne iko, amba ya renuwaŋakikiŋge na ya naŋgo e ghen, o Giya Loi na e len Ŋgolo Bobomana e tɨne u loŋwa ghalɨŋaŋgu. ");
INSERT INTO tgo_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Thavala thɨ goru weya vatavatadɨŋgi na ma e ghanji thovuye, kaero thɨ roiteteŋge na gharen ma i nja weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ko iyemaeŋge ne ya wothu taraweŋge; ne ya vakatha vowo na i voro e ghen na ya vakatha ŋgoreiya va lo dagerawe e ghen. Vamoru i mena weya Giya Loi!” ");
INSERT INTO tgo_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Amba Giya Loi i vakatha borogima na i thegharaŋgiya Jona e njighɨko ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Amba Giya Loi mbaŋaiwoniyeva i dage weva Jona, ");
INSERT INTO tgo_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","iŋa, “U wa Ninive, iya ghembako laghɨye iyako na vo utuŋa totoke iya ya utuveŋgeke.” ");
INSERT INTO tgo_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Jona i ghambugha Giya Loi le renuwaŋa na i wa Ninive, iya ghembako laghɨye iyako. I wo mbaŋa thegheto amba lolo regha i loŋga e tɨne na ve wo valɨghadidiye. ");
INSERT INTO tgo_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Mbaŋa i viva moli i ŋgalauwa e ghembako laghɨye tɨne. I utuŋa iŋa, “Ne mbaŋa mbaŋaevarɨ e tɨne Ninive ne i mukuwo moli.” ");
INSERT INTO tgo_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ninive gharɨgharɨniye thɨ loŋweghathɨgha Loi le utu iya Jona me utugiya weŋgi, iya kaiwae thɨŋa valɨkaiwae gharɨgharɨke wolaghɨye thɨ mbemba, iri thavala thɨ laghɨye na thɨ mevoro gheghad gharɨgharɨ ma e idaidanji na thɨ njimbo kwama mbe ghayamoyamo ŋgoreiye ela le ghɨmoru i mareiteteŋa, na iyako i woraŋgiya kaero thɨ roiteteŋgiya lenji tharɨ na thɨ ndeghereiye wanaŋgi. ");
INSERT INTO tgo_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Mbaŋa ghembako ghakiŋ i loŋwa iyako, i yondovirɨ ele ghamba mbaroko weiye vwenyevwenye kwamaniye na i linjoŋa ghakwamako amba i liya kwama ŋgoreiye wambwi kwamaniye na ve ronja e vugha vwatae. ");
INSERT INTO tgo_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Amba i variya ghalɨŋae weŋgiya gharɨgharɨko wolaghɨye Ninive e tɨne iŋa, “Kiŋ na ghalɨŋae gharaghambɨ thɨ variya utuke iyake weŋga, ŋgoreiyake: Thava lolo regha, thava kau, sip na gout thɨ ghanɨŋga o thɨ muna mbwa. ");
INSERT INTO tgo_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Gharɨgharɨke wolaghɨye na thetheghan thɨ njimbo kwama ghanjiyamoyamo ŋgoreiye wambwi kwamaniye. Gharɨgharɨke wolaghɨye thɨ naŋgo vurɨgheghe weiye lenji gharevatomwe weya Loi, na thɨ roiteteŋgiya ghanjithanavu raraitharɨ na lenji vakatha raraitharɨ. ");
INSERT INTO tgo_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Mbwatane Loi i vɨva le renuwaŋa na le ghareghaithɨko iko, ghare i nja weinda na mbala ma i mukuwoinda.” ");
INSERT INTO tgo_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Mbaŋa Loi i thuwa lenji vakathako, kaero thɨ roiteteŋgi ghanjithanavu raraitharɨ, i vɨva le renuwaŋa na le ghareghaithɨko iko na ma i mukuwoŋgi ŋgoreiya va iŋa ne i vakatha weŋgi. ");
INSERT INTO tgo_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ko iyemaeŋge Jona va weiye le ghatemuru laghɨye moli iyako kaiwae weiye le gaithɨ. ");
INSERT INTO tgo_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Iya kaiwae i naŋgo weya Giya Loi iŋa, “Giya Loi, amba muyai ya iteta ghambaŋgu, thare va ya dage e ghen na len vakatha ŋgoreiye vara iyako? Iyako kaiwae va ya rovurɨghegheŋa na ya vogha na ya wa Tasis (Spein). Ya ghareghare ghen gharethovu na mwaewo gha Loi. Mbaŋake wolaghɨye u ghataŋaghathɨ, mbaŋake wolaghɨye gharenɨwe, na mbaŋake wolaghɨye valɨkaiwan u vɨva len renuwaŋa na ma giya vuyowo. ");
INSERT INTO tgo_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Iya kaiwae, Giya Loi, mbema u li eŋge yawaliŋguke, valɨkaiwae moliya ya mare na thava e yawayawaliŋgu.” ");
INSERT INTO tgo_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ko iyemaeŋge Giya Loi i gonjoghawe iŋa, “Ma e len rɨghe na iya gharenɨna i gaithɨ.” ");
INSERT INTO tgo_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jona i wareri na i wa e ghembako valɨvaŋga e boimako na ve yakuwe. I vatada yoŋathowathowa regha na i yaku e riburibuye, na i roroghagha; nuwaiya i thuwe budakai ne i yomara e ghembako iyako. ");
INSERT INTO tgo_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Amba Giya Loi i vakatha umbwa regha i mbuthu voro Jona evasiwae na i giya ghambaghambaluwae na i vakatha ghamɨnae i thovuye moli. Jona i warari laghɨye umbwako iyako kaiwae. ");
INSERT INTO tgo_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ko va mbaŋambaŋava moli Loi iŋa na mwatamwata thɨ ghana umbwama na i mare. ");
INSERT INTO tgo_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Varae vama i yovoro na e ghereiye Loi i vakatha boima dayadayaghaniye i rowo na i vakatha Jona mbalavama marae i tatailo kaiwae varaeko va i ŋge umbaliye na i dayagha. Iya kaiwae iŋa, “Thoŋgo mbema ya mare eŋge. Valɨkaiwae moliya ya mare na thava e yawayawaliŋgu.” ");
INSERT INTO tgo_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ko iyemaeŋge Loi i dagewe iŋa, “Ma e len rɨghe vara na gharen i gaithɨ umbwako kaiwae.” Jona i gonjoghawe iŋa, “Mbe elo rɨghe na kaiwae ghareŋgu i gaithɨ — ya gaithɨ laghɨye laghɨye moli iya kaiwae nuwaŋguiya mbema ya mare vara.” ");
INSERT INTO tgo_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Ko iyemaeŋge Giya Loi i dagewe iŋa, “Iya umbwako menda i mbuthuko na gougoura na kaero i mareva, ma menda u vakatha bigi reghawe na ma menda u vakatha na i mbuthu, iwaeŋge gharen i njawe. ");
INSERT INTO tgo_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ŋgoroŋga na mbe ghareŋgu wevara iya ghembako laghɨye Ninive. Kaiwae e tɨne gharɨgharɨ lenji ghanaghanagha i kivwala wan handred tuwenɨti tausan gharɨgharɨ ma valɨkaiwanji thɨ ghareghare thovuye na tharɨ inanjiwe, na tembe ŋgoreiyeva thetheghanɨŋgi lemoyo.” ");
INSERT INTO tgo_vpl VALUES ("ZP2_3","037_2_3","ZEP","2","3","3","Ghemi gharɨgharɨna wolaghɨye inami Juda thavala hu gharenja, na hu kururuwe Giya Loi, na hu ghambu budakai va i utuŋa. Hu mando hu vakatha budakai i rumwaru na hu gharenja. Thoŋgo hu vakatha iyako, Giya Loi ne i ndeganaŋga mbaŋa ne i vakowanaŋgi gharɨgharɨ. ");
INSERT INTO tgo_vpl VALUES ("ZP3_12","037_3_12","ZEP","3","12","12","Giya Loi iŋa, “Thavala amba e yawayawalinji inanji Isirel ne thɨ tabo na mbinyembinyeŋgu na thɨ matabubu; thiye gharɨgharɨ thavala ne thɨ vareminjeŋgo. ");
INSERT INTO tgo_vpl VALUES ("ZP3_13","037_3_13","ZEP","3","13","13","Gharɨgharɨ amba e laghalaghanji inanji Isirel tɨne mane thɨ vakatha the bigi i tharɨ; mane thɨ utukwan o mane thɨ kwanɨyaroŋgi gharɨgharɨ e lenji utuutu. Thiye ne thɨ ghanɨŋga na thɨ ghena wagiyawe, kaiwae ma lolo regha ne i vakathaŋgi na thɨ mararu.” ");
INSERT INTO tgo_vpl VALUES ("ZP3_14","037_3_14","ZEP","3","14","14","Ghemi gharɨgharɨ thavala hu yayaku Jerusalem na ghembaghemba vavanava Isirel tɨne, hu wothu na hu yaro laghɨye! Hu warari weiye gharemina laghɨye, ");
INSERT INTO tgo_vpl VALUES ("ZP3_15","037_3_15","ZEP","3","15","15","kaiwae Giya Loi ne i ravagha vuyowo e ghemi, na ne i variyeyathuŋgiya ghami thɨghɨyaŋgina! Na Giya Loi ghamberegha Isirel lenji kiŋ ne i yaku weinda, na ma tene hu mararuva lolo regha i vakowanainda. ");
INSERT INTO tgo_vpl VALUES ("ZP3_16","037_3_16","ZEP","3","16","16","E mbaŋako iyako ne thɨ dage weŋga Jerusalem, thɨŋa, “Thava hu mararu, Saiyon. Na thava hu njavovo na ghamɨnami i ghenenja na ma valɨkaiwae hu vakatha mun bigi regha. ");
INSERT INTO tgo_vpl VALUES ("ZP3_17","037_3_17","ZEP","3","17","17","kaiwae Giya Loi lemi Loi iye i yaku e ghami lughawoghawona. Iye ragagaithɨ vurɨvurɨghegheniye, na ne i vamoruŋga. Giya Loi ne i warari laghɨye kaiwami, kaiwae i gharethovuŋga, mane i vakathaŋga na hu mararu; ne i wothu laghɨye na i warari ghemi kaiwami.” ");
INSERT INTO tgo_vpl VALUES ("ZP3_18","037_3_18","ZEP","3","18","18","Giya Loi iŋa, “Ghemi gharɨgharɨ va hu numotharɨ na hu monjina kaiwae mava valɨkaiwami hu vakatha lemi kururuna thaganiyeŋgi; ko ne ya vakathaŋga na ma tene hu monjinava.” ");
INSERT INTO tgo_vpl VALUES ("ML1_8","040_1_8","MAL","1","8","8","Thare lolo rameyambaneke i kaiva Loi? Iyemaeŋge u kaivaŋgo. Ko u vaito ŋgoroŋga wokaivɨŋge na woŋa? E giyanjogha na mwaewo. ");
INSERT INTO tgo_vpl VALUES ("ML1_9","040_1_9","MAL","1","9","9","Ghemi inami gura e raberabe, ghemi yambaneke laghɨye, kaiwae u vakaiviŋaŋgo. ");
INSERT INTO tgo_vpl VALUES ("ML1_10","040_1_10","MAL","1","10","10","Giya Loi Ravurɨgheghe mbowo iŋava, “Nuwaŋguke nuwaiya moli ghemi na regha i vandegana Ŋgolo Kururu ghathɨnɨmba na mbala ma valɨkaiwami hu bigi lemi wogiya ma e ghathovuye. Ma ya warariŋa e ghemi. Mane ya wovatha lemi wogiya hu womena weŋgo.” ");
INSERT INTO tgo_vpl VALUES ("ML1_14","040_1_14","MAL","1","14","14","The lolo i dagerawe ne i vowoŋa thetheghan ghɨmoru thovuye e ghino, i mena e le thetheghanɨko tɨnenji, ko iyemaeŋge ma i wogiyava raitharɨ weŋgo. Thoŋgo thela i vakatha iyako iye rakwan na ne ya gura, kaiwae ghino kiŋ laghɨye; ghino nyao thovuthovuye lenji randeviva na gharɨgharɨ e vanautuma vavanava ne thɨ yavwatata wanaŋgo. ");
INSERT INTO tgo_vpl VALUES ("ML2_1","040_2_1","MAL","2","1","1","“Na mbaŋake ghemi ravowovowo, ghami dage vavurɨgheghe iyake. ");
INSERT INTO tgo_vpl VALUES ("ML2_2","040_2_2","MAL","2","2","2","Mbe hu yavwatata wanaŋgo e lemi vakathana. Thoŋgo ma hu vandeŋe budakai ya utuŋa weŋga, ne ya womena gura e ghemi. Ne ya guraŋga, na ne ya gura the bigibigi iya hu vaidi ghami thovuyenawe. Emunjoru kaero va ya worawe gura weŋgi, kaiwae ma wo yavwatata laghɨye ina weŋga.” ");
INSERT INTO tgo_vpl VALUES ("ML2_8","040_2_8","MAL","2","8","8","“Ko ghemi ravowovowo kaero hu viyathu vakatha iya ghino nuwaŋguiya ghemi hu vakatha. Budakai va hu vaghareŋgi kaero i thova gharɨgharɨ lemoyo nuwanji na thɨ vakatha tharɨ. Kaero hu botewo dageraweko iya va ya vakatha weiŋguyaŋgi Livai orumburumbuye mbaŋa mevivako. ");
INSERT INTO tgo_vpl VALUES ("ML2_9","040_2_9","MAL","2","9","9","Iya kaiwae kaero va ya vakatha gharɨgharɨ lemoya thɨ ndeghereiye wanaŋga, na ya vakathaŋga na hu monjina, kaiwae ma hu ghambuŋgo. Mbaŋa hu vavaghare lo mbaro weŋgi gharɨgharɨ, ma hu vakatha gharɨgharɨko wolaghɨye thɨ mboromboro. ");
INSERT INTO tgo_vpl VALUES ("ML2_10","040_2_10","MAL","2","10","10","“Taulaghɨke ghinda ramanda emunjoru mbe ghamberegha eŋge e buruburu. Emunjoru taulaghɨke ghinda mbema Loi regha eŋge va i vakathainda. Ko buda kaiwae ghemi vavana ma hu ghambu Giya Loi le dagerawe weiyaŋgi orumburumbunda, kaiwae ma hu ve vakatha weŋga budakai va huŋa ne hu vakatha.” ");
INSERT INTO tgo_vpl VALUES ("ML4_1","040_4_1","MAL","4","1","1","Iyake budakai nyao lenji randeviva iŋa, tene mbaŋa regha i mena na ne ya vaghetheŋgi gharɨgharɨ na ya giya vuyowo weŋgi. Mbaŋako iyako ne i yomara ŋgoreiye ndɨghe dayaghawae laghɨye moli. E mbaŋako iyako gharɨgharɨ tawosirari na tharɨ gharavakathaŋgi ne thɨnda ŋgoreiye winjiwinji i nda. Na ma tembe i nda vareva bigi regha mun. ");
INSERT INTO tgo_vpl VALUES ("ML4_2","040_4_2","MAL","4","2","2","Ko ghemi thavala woyavwatata ina e ghemi, loloko iya ne i vamoruŋgako ne i mena e ghemi ŋgoreiye mbaŋambaŋa varaeniye i mbɨle, na i vakathaŋga na hu rumwaru, ne i vamoruŋga na i njimbukikiŋga ŋgoreiye maa i njimbukikigiya le ŋgamaŋgama e vinevineiyeko raberabe. Mbaŋa ne i mena, ne hu warari laghɨye moli, ŋgoreiye burumwaka le ŋgaŋga totogha thɨ raŋgi e ghanji gana tɨne na thɨ wa e nana thovuye, thɨ pitopito weiye lenji warari laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iyake Jisas Krais orumburumbuye utuutuninji. Jisas Krais iye Deivid rumbuye, Deivid iye Eibraham rumbuye. ");
INSERT INTO tgo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibraham nariya Aisake, Aisake nariya Jeikob, Jeikob le ŋgaŋgaŋgiya Juda na oghaghae, ");
INSERT INTO tgo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda le ŋgaŋgaŋgiya Peres na Seal, tɨnanjiya Tama, Peres nariya Hesɨron, Hesɨron nariya Ram, ");
INSERT INTO tgo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram nariya Aminadab, Aminadab nariya Nason, Nason nariya Salmon, ");
INSERT INTO tgo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon nariya Bowasa, tɨnaya Reihab, Bowasa nariya Obedi, tɨnaya Rut, Obedi nariya Jese, ");
INSERT INTO tgo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese nariya Kiŋ Deivid. Deivid nariya Solomon, tɨnae iye Uraiya va i vaŋgukai, ");
INSERT INTO tgo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon nariya Rehobowam, Rehobowam nariya Abaija, Abaija nariya Asa, ");
INSERT INTO tgo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nariya Jehosapat, Jehosapat nariya Joram, Joram nariya Usaiya, ");
INSERT INTO tgo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiya nariya Jotam, Jotam nariya Eihas, Eihas nariya Hejekaiya, ");
INSERT INTO tgo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hejekaiya nariya Manase, Manase nariya Emon, Emon nariya Josaiya, ");
INSERT INTO tgo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiya le ŋgaŋgaŋgiya Jekonaiya na oghaghae, mbaŋaniye Babilon va thɨ mena thɨ kivwalaŋgiya Isirel na thɨ vaŋguŋgi vethiya yaku Babilon. ");
INSERT INTO tgo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Va thɨ vaŋguŋgiya Isirel na vethɨ vaŋguraweŋgi Babilon na e ghereiye: Jekonaiya nariya Seyatiyel, Seyatiyel nariya Serubabol, ");
INSERT INTO tgo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabol nariya Abiyuda, Abiyuda nariya Ilaiyakim, Ilaiyakim nariya Eiso, ");
INSERT INTO tgo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eiso nariya Sedok, Sedok nariya Akim, Akim nariya Eliudɨ, ");
INSERT INTO tgo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudɨ nariya Eliyesa, Eliyesa nariya Meitan, Meitan nariya Jeikob, ");
INSERT INTO tgo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","na Jeikob nariya Josep Meri le ghɨmoru, iyava i ghamba Jisas, iya raŋake Mesaiya. ");
INSERT INTO tgo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","I mena weya Eibraham ghaghad Deivid tha theyaworo na theghevarɨ, Deivid na ghaghad va thɨ vaŋguŋgiya Isirel na thɨ raka Babilon, tha theyaworo na theghevarɨ na va e mbaŋako iyako na gheghad Mesaiya i virɨ tha theyaworo na theghevarɨ. ");
INSERT INTO tgo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais le virɨ va ŋgora iyake. Tɨnae Meri ghaghaivaun weiye Josep, ko ma vamba thɨ ghe kaero i marabo Nyao Boboma le vurɨgheghe kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kaiwae Josep, Meri ghaghaivaun, iye ghathanavu va i thovuye, mava nuwaiya i vakatha na i monjina. Josep le renuwaŋa thuwele nuwaiya thɨ yawo weiye. ");
INSERT INTO tgo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ko le renuwaŋa thuweleko iyako e ghereiye Giya Loi le nyao thovuye i njawe ghenelolo e tɨne na i dagewe iŋa, “Josep, Deivid rumbuye, tha u mararu na u vaŋgwa Meri na len wevo, maraboke iyake i mena weya Nyao Boboma. ");
INSERT INTO tgo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ne i ghamba ŋgama ghɨmoru na ne u uno idae Jisas, kaiwae ne i vamoruŋgiya le gharɨgharɨ lenji tharɨ e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Thiyake thɨ yomara na thɨ vaemunjoruŋa ŋgoroŋga Giya Loi va i utugiya weya ghalɨŋae gharautu, ");
INSERT INTO tgo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Thɨnabwethubwethuru nevole i marabo na i ghamba ŋgama ghɨmoru na nevole thɨ rena idae Imanuwel.” Imanuwel gharumwaru “Loi iye weinda”. ");
INSERT INTO tgo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mbaŋa Josep i thuweiru, i vakatha ŋgoreiya Giya Loi le nyao thovuye me dagemawe i vaŋgwa Meri na levo. ");
INSERT INTO tgo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ko ma vamba i ndeloŋga mun weiye Meri gheghada i ghamba ŋgamako na Josep i rena idae Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisas va i virɨ Betɨlehem Judiya e tɨne, Herod ghambaŋa i mbaro. Jisas le virɨ e ghereiye rathimbathimba ghɨmoghɨmoru e boimako thɨ mena Jerusalem ");
INSERT INTO tgo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","na thɨ vaito thɨŋa, “Aŋga inae Jiu lenji kiŋ amba menda i virɨke? Mendava wo vaidiya ghaghɨtara e boimako na nuwameiya wo mena wo kururuwe.” ");
INSERT INTO tgo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mbaŋa Kiŋ Herod i loŋweya utuke iyake i vakatha ghare i gaithɨ laghɨye, na Jerusalem gharayakuyakuko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herod i kula vathavathaŋgiya ravowovowo laghɨlaghɨye na mbaro gharavavaghare, na i vaitoŋgi iŋa, “Mesaiya, aŋga mbala i virɨ?” ");
INSERT INTO tgo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Thɨ dagewe thɨŋa, “Betɨlehem, Judiya e tɨne, iyake kaiwae Loi ghalɨŋae gharautu va i rori: ");
INSERT INTO tgo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ko ghen, Betɨlehem, Judiya e thivathivaniye tɨne, u laghɨye moli, kaiwae e ghen randeviva ne i yomara, na ne i ndeviva weŋgiya lo gharɨgharɨ Isirel.’” ");
INSERT INTO tgo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Amba Herod i kula thuweleŋgiya rathimbathimbama na thɨ niva weinji na i vaitoŋgi va thembaŋa vara ghɨtarako i yomara. ");
INSERT INTO tgo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I variyeŋgi Betɨlehem na iŋa, “Hu wa na vou tamwe wagiyawe ŋgamana. Thembaŋa vou vaidi, hu mena hu giya yanawaŋgu na ghino tembe ya wa na va kururuweva.” ");
INSERT INTO tgo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mbaŋa thɨ iteta Herod ma vethɨ loŋgaloŋga na mbowo thɨ vaidiva ghɨtarama mendava thɨ vaidima e boimako, i viva e ghamwanji gheghad i mena i ndeghathɨ ŋgora ŋgamama inawe e vwatae. ");
INSERT INTO tgo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mbaŋa thɨ thuweya ghɨtarako thɨ warari laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Thɨ ru e ŋgolo tɨne na thɨ vaidiya ŋgamama weiye tɨnae Meri. Thɨ ronja e ghenji vuvuye na thɨ kururuwe. Thɨ tateŋgiya lenji vethe nasiye na thɨ bigiraŋgiya lenji mwaewo, gol, preŋkinisenɨs na mer. ");
INSERT INTO tgo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Vanuwovɨrɨ i mena weŋgi ghenelolo e tɨne, na thava te thɨ njogha weva Herod. Vama thɨ reŋava e kamwathɨ regha na thɨ njogha e ghambanji. ");
INSERT INTO tgo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mbaŋa vama rathimbathimbama thɨ wareri amba Giya Loi le nyao thovuye i yomara weya Josep ghenelolo e tɨne na i dagewe iŋa, “U yondo, Josep, u vaŋguŋgiya ŋgamana na tɨnae na hu vowa Ijipt. Vou yaku gheko gheghad ne ya dage weŋga amba hu njoghama, kaiwae Herod le ragagaithɨ ne thɨ tamweya ŋgamana na nuwanjiya thɨ unɨghɨ.” ");
INSERT INTO tgo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep i thuweiru i vaŋguŋgiya ŋgamama na tɨnae gougouko iyako na thɨ wa Ijipt. ");
INSERT INTO tgo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Vethɨ yaku ghaghad Herod i mare. Iyako i yomara na i vaemunjoruŋa ŋgoroŋga Giya Loi va i utugiya weya ghalɨŋae gharautu iŋa, “Ijipt e tɨne ya kularaŋgiya naruŋgu.” ");
INSERT INTO tgo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mbaŋa Herod i ghareghare rathimbathimbama thɨ yaro, ghare i gaithɨ laghɨye moli. Amba i variyeŋgiya le ragagaithɨ na thɨ gaboŋgiya gamagai ghɨmoghɨmoru Betɨlehem na ele valɨvaŋgako wolaghɨye, thiye ghanjitheghathegha umboiwo na e raberabe. Va i vakatha ŋgorako kaiwae va i gorugoru weya ŋgoroŋga rathimbathimbama lenji woraŋgiya na ghɨtarama le yomara. ");
INSERT INTO tgo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Va ŋgorako na Jeremaiya le utu i tabo na emunjoru. ");
INSERT INTO tgo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Iŋa: “Thɨ loŋweya ghalɨghalɨŋa regha Ramae ele valɨvaŋga, raŋivetho weiye nuwatharɨ. Reitiyel i raŋiŋgiya le ŋgaŋga, ma nuwaiya thɨ vawarariŋa kaiwae kaero thɨ mare.” ");
INSERT INTO tgo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod va le mare e ghereiye, Giya Loi le nyao thovuye i yomarawe Josep e ghenelolo, Ijipt e tɨne, ");
INSERT INTO tgo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","na i dagewe iŋa, “U yondo u vaŋguŋgiya ŋgamana na tɨnae na hu wa Isirel e thivathivaniye kaiwae thiyema va thɨ mando na thɨ munjeva thɨ unɨgha ŋgamana kaero thɨ mare.” ");
INSERT INTO tgo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josep i thuweiru i vaŋguŋgiya ŋgamama na tɨnae na thɨ wa Isirel e thivathivaniye. ");
INSERT INTO tgo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ko mbaŋa Josep i loŋweya Akiulas i methɨgha ramae Herod Judiya e tɨne, i mararu na i wa gheko. Loi i dagewe e ghenelolo na thɨ wa Galili ele valɨvaŋga, ");
INSERT INTO tgo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","na thɨ wa na vethɨ yaku e ghemba regha idae Nasaret. Iyake i vaemunjoruŋa Loi ghalɨŋae gharautuŋgi va thɨ utuŋa: “Ne thɨŋa rara Nasaret.” ");
INSERT INTO tgo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Va e mbaŋaŋgiko thiyako Jon Rabapɨtaiso i mena Judiya e njamnjamɨniye na i vavagharewe ");
INSERT INTO tgo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","iŋa, “Hu uturaŋgiya lemi tharɨ na hu roiteteŋgi, kaiwae Loi le ghamba mbaro ghambaŋa maiyavara.” ");
INSERT INTO tgo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon iya utuniya Loi ghalɨŋae gharautu, Aiseya va i utuŋama, iyava iŋake, “Lolo regha i kulakula e njamnjam, ‘Hu vivatha kamwathɨ Giya kaiwae; hu varumwaru kamwathɨ amalaghɨniye kaiwae na mbala i reŋawe!’” ");
INSERT INTO tgo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ghakwama va thɨ vakatha kamel vulivuliye. Mborowae gheva thetheghan njimwae na i ghanɨŋgiya bibita na ŋguyo. ");
INSERT INTO tgo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Gharɨgharɨ thɨ rakamenawe, vavana thɨ rakamena Jerusalem, vavana Judiya ele valɨvaŋgako laghɨye na vavana thɨ rakamena e vanautumako laghɨye e Walaghɨta Jorɨdan ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Thɨ uturaŋgiya lenji tharɨ na Jon i bapɨtaisoŋgi Jorɨdan. ");
INSERT INTO tgo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ko iyemaeŋge mbaŋa i thuweŋgiya Parisi na Sadusi thɨ rakamenawe bapɨtaiso kaiwae, i dage weŋgi iŋa, “Ghemi mwata raraitharɨ ghemi! Thela i dage e ghemi na hu munjeva ne hu voiteta Loi le ghatemuruko vuyowae iya i menamenako? ");
INSERT INTO tgo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hu vaemunjoruŋa e lemi vakathana kaero hu uturaŋgiya lemi tharɨ na hu roiteteŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na thava lemi renuwaŋa hu munjeva ne hu voiteta vuyowoko iyako kaiwae huŋa, ‘Ghime rumbuma Eibraham.’ Ya dage e ghemi, Loi valɨkaiwae i mbanɨŋgiya varɨvarɨke thiyake na i vakathaŋgiya Eibraham orumburumbuye. ");
INSERT INTO tgo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","E mbaŋake iyake kelumo kaero ina vara e umbwaumbwa rɨgherɨghenji. Umbwa regha na regha ma i rau na thovuye ne i ikuyathu na i bigiyathu e ndɨghe une.” ");
INSERT INTO tgo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ghino ya bapɨtaisoŋga e mbwa na i vatomwe kaero hu uturaŋgiya lemi tharɨ na hu roiteteŋgi, ko iya loloko i rereghamba e ghereiŋguke, iye ne i bapɨtaisoŋga e Nyao Boboma na e ndɨghe une. Ma elo thovuye na valɨkaiwaŋgu ne ya bigiya gheghe ghae. ");
INSERT INTO tgo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Le savɨrɨ wit kaiwae kaero ina e nɨmae, ne i ghatha mbombouyeko weiye wokiwokiniyeko. Ne i mbana mbombouyeko na i vathe e ghaŋgolo na wokiwokiniyeko i ŋambu e ndɨgheko iya ma mbaŋa regha ne i mareko.” ");
INSERT INTO tgo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","E mbaŋako iyako e tɨne Jisas i ri Galili na i wa Jorɨdan, na i bapɨtaiso weya Jon. ");
INSERT INTO tgo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jon i munjeva ne i vɨva Jisas le renuwaŋa, i dagewe, iŋa, “Ghen eŋge mbala u bapɨtaisoŋgo, na ghen mo menava e ghino?” ");
INSERT INTO tgo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ko Jisas i gonjoghawe, iŋa, “Mbowo ŋgoreiyako e mbaŋake iyake, kaiwae e kamwathɨke iyake ne ra vakatha Loi le renuwaŋa thovuye.” Jon i wovathovuthovuyeŋa. ");
INSERT INTO tgo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mbaŋa i bapɨtaisovao na i voro e mbwako ghadidiye, e mbaŋako iyako buruburu i mavu na i thuweya Nyao Boboma i njamawe ŋgoreiya bunebune. ");
INSERT INTO tgo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Amba ghalɨghalɨŋa i mena e buruburu iŋa, “Loloke iyake naruŋgu moli gharegharethovuniye. I vakathaŋgo ya warari laghɨye moli.” ");
INSERT INTO tgo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Amba Nyao Boboma i yo vaŋgwa Jisas e njamnjam vurɨvurɨ vwatavwata na Seitan ve vatanathethaŋa. ");
INSERT INTO tgo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na kaiwae vama gheneyevarɨ ve yaku e njamnjam na ve mbeya ghanɨŋga naŋgo kaiwae, ko e mbaŋako iyako amba bada i gharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Amba ratanathethama i menawe na i dagewe iŋa, “Thoŋgo Loi Nariya ghen, u ŋaerambeŋgiya varɨvarɨke thiyake thɨ gharavɨ na bred.” ");
INSERT INTO tgo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisas i gonjoghawe iŋa, “Buk Boboma iŋa, ‘Ma mbene bred eŋge i ndewo lolo yawaliye, ko iyemaeŋge budakaiya Loi i utuŋa iye i ndewo lolo yawaliye.’” ");
INSERT INTO tgo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Amba Seitan i yovaŋgu Jerusalem, i vaŋgurawe vara e Ŋgolo Boboma vwatae yavoro moli, ");
INSERT INTO tgo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na i dagewe iŋa, “Thoŋgo Loi Nariya ghen, u pito ghena, kaiwae Buk Boboma iŋa, “‘Loi ne i variyeŋgiya le nyao thovuthovuye kaiwan, na thɨ njimbukiki wagiyaweŋge, ne thɨ mwanavairɨŋge e nɨmanji, mbala ma vo ŋge gheghen e varɨ.’” ");
INSERT INTO tgo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas i gonjoghawe iŋa, “Buk Boboma tembe iŋava, ‘Tha lolo regha i mando na i woraweya Giya le Loi mando e tɨne.’” ");
INSERT INTO tgo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seitan mbowo i yovaŋguva na ve vaŋgurawe e ou vwatae yavoro moli, na i vatomwe weya ghamba mbaroke wolaghɨye e yambaneke, lenji laghɨlaghɨye na lenji thovuye. ");
INSERT INTO tgo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","I dagewe iŋa, “Iya vara ghamba mbaroko wolaghɨye thiyako ne ya vatomwe e ghen thoŋgo u ronja na u kururu e ghino.” ");
INSERT INTO tgo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Amba Jisas i dagewe iŋa, “U wa Seitan! Buk Boboma iŋa, ‘U kururu weya Giya len Loi ghamberegha na ghamberegha moli u ghambu!’” ");
INSERT INTO tgo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amba Seitan i itete na nyao thovuthovuye thɨ mena thɨ giya thalavuwe. ");
INSERT INTO tgo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mbaŋa Jisas i loŋwe Jon utuniye kaero ina e thiyo, i njogha Galili, ");
INSERT INTO tgo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","na i iteta Nasaret i wa ve yaku Kapenaom. Ghembake iyake ina Galili Njighɨniye ghadidiye, uu Sebulon na Napɨtalai e lenji valɨvaŋga. ");
INSERT INTO tgo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Va i vakatha ŋgoraiyako na i vaemunjoruŋa ŋgoroŋga Loi ghalɨŋae gharautu, Aiseya, ghalɨŋae iya iŋake, ");
INSERT INTO tgo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Uu Sebulon na Napɨtalai e lenji valɨvaŋga tɨne, valɨvaŋgako iya kamwathɨko i wa e njighɨko, e valɨvaŋga Walaghɨta Jorɨdan i vorovoro e tɨne, na Galili e tɨne, thiye ma Jiu thiya yakuwe: ");
INSERT INTO tgo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","gharɨgharɨko iya thiya yaku e momouwoko va thɨ thuweya manjamanjala laghɨye, thiye thiya yaku mare e momouwowae tɨne manjamanjala ne i woya weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mbaŋaniye Jisas i woraweya le vavaghare rɨghe, i dage weŋgi iŋa, “Hu uturaŋgiya lemi tharɨ na hu roitete, kaiwae Loi le ghamba mbaro maiyavara!” ");
INSERT INTO tgo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mbaŋa Jisas i ŋgalai Galili Njighɨniye ghadidiye, i vaidiŋgiya raiwo na ghaghae, Saimon idae regha Pita na ghaghae Endru, thɨ duda ghina kaiwae thiye raboroborogi. ");
INSERT INTO tgo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I dage weŋgi iŋa, “Hu mena hu ghambuŋgo na ya vavaghareŋga ghemi gharɨgharɨ ghanjirakosi.” ");
INSERT INTO tgo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","E mbaŋako iyako thɨ iteteŋgiya lenji ghina na thɨ ghambu. ");
INSERT INTO tgo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","I loŋga ghaova seiwo, mbowo i vaidiŋgiva raiwo na ghaghae, Jemes Sebedi nariye na ghaghae Jon, inanji e waŋga weinji ramanji Sebedi, thɨ vavanamweŋgiya lenji ghina. Jisas i kula weŋgi, ");
INSERT INTO tgo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na e mbaŋako iyako thɨ iteta waŋga na ramanji Sebedi, na thɨ ghambu. ");
INSERT INTO tgo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas i vaghɨliya Galili laghɨyeko, i vavaghare e ŋgolo kururu tɨnenji, i utuŋa Toto Thovuye Loi le ghamba mbaro utuniye na i thawariŋgiya tomethi gida na ghambwera weŋgiya gharɨgharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Toto amalaghɨniye utuutuniye i lalo Siriya laghɨyeko na gharɨgharɨ thɨ bigimena weya Jisas gharɨgharɨko wolaghɨye tomethi ghanjighambwera, thiye thɨ ghataŋa vɨrɨ laghɨye, thavala nyao raraitharɨ ina weŋgi, thavala thɨ vaidiya vuyowo ŋgoreiya riwanji i gheroro na kuvokuvoŋgi, na i thawariŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iya kaiwae wabwi laghɨlaghɨye thɨ rakambele. Vavana thɨ rakamena Galili na e Ghembaghemba Ghembayaworo, vavana Jerusalem, vavana Judiya na vavana thɨ rakamena Jorɨdan valɨvaŋga i vorovoro. ");
INSERT INTO tgo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas va i thuweŋgiya wabwi laghɨye amba i voro e bobokulu regha, na mbaŋa i ronja gharaghambu thɨ rakamenawe na thɨ meghɨliŋa. ");
INSERT INTO tgo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Amba i vavaghare weŋgiya wabwiko laghɨye, iŋa: ");
INSERT INTO tgo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Loi ghare weŋgiya thavala mbinyembinyeŋgu e unenji tɨne, kaiwae le ghamba mbaro kaero ina weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Loi ghare weŋgiya thavala thɨ numotharɨ, kaiwae ne i gogonja nuwanji.” ");
INSERT INTO tgo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Loi ghare weŋgiya thavala thɨ gharenja, kaiwae ne i wogiya yambaneke laghɨye weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Loi ghare weŋgiya thavala e yawalinjiko thɨ badaŋa laghɨye na thɨ vakatha ŋgoreiya Loi le renuwaŋa, kaiwae Loi ne i vatabo na i vamboromboro laghɨye moli weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Loi ghare weŋgiya thavala thɨ gharevɨrɨ gharɨgharɨ vavana kaiwanji, kaiwae ne i gharevɨrɨ weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Loi ghare weŋgiya thavala gharenjiko laghɨye i thɨna, kaiwae ne thɨ thuweya Loi.” ");
INSERT INTO tgo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Loi ghare weŋgiya thavala thɨ vevakathaŋa gharemalɨlɨ weŋgi, kaiwae ne iŋa thiye le ŋgaŋga.” ");
INSERT INTO tgo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Loi ghare weŋgiya thavala thɨ vaidiya vuyowo weŋgiya gharɨgharɨ kaiwae ghanjithanavu i rumwaru, kaiwae Loi le ghamba mbaro kaero ina weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ghareŋgu weŋga ghemi mbaŋa gharɨgharɨ ne thɨ goviya ghamwami, mbaŋa thɨ vakatha vuyowo weŋga, na mbaŋa thɨ utu kwanɨkwan kaiwami kaiwae hu ghambuŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mbe hu warari na nuwami i loghe kaiwae modami laghɨye mbe ina e buruburu. Kaiwae ghalɨŋaŋgu gharautuŋgi me vivako vambe thɨ vakathava vuyowo ŋgoranjiŋgiya thiyako weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ghemi ghamithanavu e yambaneke ŋgoreiya njighɨ le kaiwo. Iya kaiwae thoŋgo njighɨ le vurɨgheghe iko na ma ma e ghamɨghamɨnae, ma te kamwathɨ reghava na valɨkaiwae ra vakatha na ghamɨnaeko i njogha. Kaero i tharɨ na ma ma e ghathovuye, ra wokiyathu gharɨgharɨ thɨ vurɨghɨya.” ");
INSERT INTO tgo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ghemi yambaneke ghamanjamanjala. Thoŋgo thɨ vakatha ghemba regha e ou vwatae gharɨgharɨke taulaghɨ ne thɨ thuwe. ");
INSERT INTO tgo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma mbaŋa regha lolo i rɨmba lemp na i wo uye na i woyabowe, ko ne i thɨnɨrawe e tebol vwatae na i vamanjamanjalaŋaŋgiya gharɨgharɨko wolaghɨye e ŋgoloko tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ghemi tembe ŋgoreiyeva, lemi manjamanjalana i woya weŋgiya gharɨgharɨ mbala thɨ thuweya lemi vakatha na thovuye na thɨ taraweŋa Ramami iye ina e buruburu.” ");
INSERT INTO tgo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Thava lemi renuwaŋa huŋava ya mena na ya rakayathu Mosese le mbaro na Loi ghalɨŋae gharautu lenji vavaghare. Ma ya mena rakayathu kaiwae, ya mena na ya vaemunjoruŋaŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya dage emunjoru e ghemi, gheghada buruburu na yambaneke ne thɨko, mane utu nasiye regha ina e Mbaroko tɨne ne iko gheghada wolaghɨyeko thɨ tabo na emunjoru. ");
INSERT INTO tgo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Thoŋgo lolo regha i raka mbaroŋgike thiyake na iŋa ma e ghanjithovuye, othembe mbaro nasiye regha ina e mbaroŋgike tɨnenji, na i vaghareŋgiya ghaune vavana na thɨ vakatha ŋgoreiye, iye ne i roreghamba moli Loi ele ghamba mbaro tɨne. Ko thela i ghambugha mbaro na i vaghareŋgiya gharɨgharɨ na thɨ vakatha ŋgoreiye, iye ne i roviva Loi ele ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iya kaiwae, ya dage e ghemi, ghamithanavuna iya hu ghambugha Loi le mbarona thoŋgo ma i kivwalaŋgiya Mbaro gharavavaghare na Parisi, ma valɨkaiwami ne hu ru Loi ele ghamba mbaro tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kaero hu ghareghare Mosese le mbaro va i mena weŋgiya orumburumbumi, iya iŋake, ‘Tha u gabo. Thela i gabo ne i vaidiya vuyowae.’ ");
INSERT INTO tgo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ko ghino ya dage e ghemi, thela ghare i gaithɨwana ghaghae ne i vaidiya vuyowae, thela i utuvatharɨ ghaghae kaiwae ne ve kot Jiu e lenji mbaro laghɨye na thela ne iŋa, ‘Kabaleya ghen!’ valɨkaiwae ne vo nda e ndɨghe Gehena.” ");
INSERT INTO tgo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Iya kaiwae thoŋgo u womena len mwaewo e ŋgolo boboma tɨne vowo kaiwae weya Loi, na amba u renuwaŋa vaidiya ghagha ghare va i gaithɨ wanaŋge bigi regha kaiwae, ");
INSERT INTO tgo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","u iteta len mwaewona e ghamba vowona ghadidiye na wo u njogha na vou vakatha na namoghamwami wein, amba u njogha na vo giya len mwaewona weya Loi.” ");
INSERT INTO tgo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Thoŋgo lolo regha i wonjoweŋge bigi regha kaiwae na i yovaŋguŋge na vo kot, u yoruku na u vanamwe wonjoweko iyako wein amba muyai vou vutha e ghamba kot. Thoŋgo nandere, ne i yovaŋguŋge na ve vaŋguraweŋge kot gharavakatha e marae na iye i vaŋgugiyaŋge weya thiyo gharanjimbunjimbu na ve vaŋguruwoŋge e thiyo. ");
INSERT INTO tgo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya dage emunjoru e ghen, mane u raŋgi ghaghada ne u vamodovao ghanɨghagako iyako.” ");
INSERT INTO tgo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kaero hu ghareghare Mosese le mbaro iŋa ŋgoraiyake, ‘Tha u yathima wein lolo regha levo.’ ");
INSERT INTO tgo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ko ghino ya dage e ghemi, thoŋgo thela i thuweya wevo regha na nuwaeko nuwaiya moli, iyako ŋgoreiya kaero i yathima weiye ele renuwaŋako tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Thoŋgo maranɨna iya e unena i vakathaŋge na u vakatha tharɨ u vovavuthuyathu. I thovuye eŋge u wokiyathu riwana ŋginauye regha na thava ne thɨ wokiyathu riwana laghɨye Gehena. ");
INSERT INTO tgo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tembe ŋgoreiyeva, thoŋgo nɨmanɨna iya unena i vakathaŋge na u vakatha tharɨ, u kitenɨyathu. I thovuye moliya u kitenɨyathu riwana ŋginauye regha na thava ne thɨ wokiyathu riwana laghɨye Gehena.” ");
INSERT INTO tgo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mosese le mbaro iŋa, ‘Thela thoŋgo nuwaiya i botewo levo, wo i rorinjoŋa le botewoko utuutuniye e peipa na i ligiya weya wevoko.’ ");
INSERT INTO tgo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ko ghino ya dage e ghemi, thoŋgo lolo regha i yawo weiye levo, othembe wevoko ma i yathima, thoŋgo wevo i gheva, loloko le tharɨ kaiwae wevoko i tabo na rayathiyathima. Tembe ŋgoreiyeva, the loloko iya i vaŋguko wevoko iye tembe i yathimava.” ");
INSERT INTO tgo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tembe hu ghareghareva Mosese le mbaro va thɨ utugiya weŋgiya orumburumbumi, iya iŋake, ‘Tha u raka len tholona. U vakatha ŋgoreiya len dagerawe weya Loi.’ ");
INSERT INTO tgo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ko ghino ya dage e ghemi, tha mbaŋa regha u tholo na u uno buruburu idae kaiwae Loi le ghamba yaku iyako. ");
INSERT INTO tgo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Thava u uno yambaneke, kaiwae gheghe ghaghambalirawe iyako. Thava u uno Jerusalem, kaiwae Kiŋ laghɨye le ghamba yaku iyako, ");
INSERT INTO tgo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","na thava u tholo e umbalɨna, kaiwae ma valɨkaiwan ne uŋa na umbalɨna ndamwandamwa yaŋgara i kaleva na uŋana yaŋgara i bwedi. ");
INSERT INTO tgo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ma huŋaeŋge, ‘Ŋgoreiye’ o ‘Nandere.’ Thoŋgo hu guva utu regha iyana i mena weya Seitan.” ");
INSERT INTO tgo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kaero hu ghareghare Mosese le mbaro iŋa ŋgoreiyake, ‘Thoŋgo lolo regha i vakowana gheu regha marae voghɨra, modae tembe thɨ vakowanava amalaghɨniye marae voghɨra. Thoŋgo i tagabeba gheuko ŋiŋiye regha modae tembe thɨ tagabebeva ŋiŋiye regha.’ ");
INSERT INTO tgo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ko ghino ya dage e ghemi, thoŋgo lolo regha i vakatha vatharɨ e ghen, thava u lithɨ. Thoŋgo lolo regha i tagaleva galagalanɨna iya e unena, u vatomwe weya valɨgalagalanɨna tembe i tagalevava. ");
INSERT INTO tgo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na tembe ŋgoreiyeva, thoŋgo lolo regha i vaŋguraweŋge e kot na i munjeva i vakathaŋge na u ligiya weya ghanɨkwamana iya riwana ghayaboyabo, tembe u ligiyaweva ghanɨkwamana ghayaboyabo. ");
INSERT INTO tgo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Thoŋgo ragagaithɨ regha i vavurɨghegheŋaŋge na u bigiya ghabigi le bwagabwaga ŋgoreiye mael regha, u bigi na ma u waova na vewo mael theghewo. ");
INSERT INTO tgo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","U wogiya weya lolo regha thebigiya nuwaiya e ghen, na thoŋgo lolo regha i naŋgoya bigi regha e ghen na i vakaiwoŋa thava u vagharegharewe.” ");
INSERT INTO tgo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kaero hu ghareghare Mosese le mbaro iŋa ŋgoreiyake, ‘U gharethovu weŋgiya ghanune, u botewo moliŋgiya ghanɨthɨghɨya.’ ");
INSERT INTO tgo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ko ghino ya dage e ghemi, hu gharethovu weŋgiya ghamithɨghɨya na thavala thɨ vakatha vuyowo weŋga hu naŋgo kaiwanji, ");
INSERT INTO tgo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","mbala gharɨgharɨ thɨ ghareghare ghemi Loi ina e buruburu le ŋgamaŋgama ghemi. Kaiwae i vakatha varae na i mbɨle weŋgiya gharɨgharɨ thovuthovuye na gharɨgharɨ raraitharɨ, na i vakatha uye i nja weŋgiya thavala ghanjithanavu i rumwaru na thavala ghanjithanavu i tharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Buda kaiwae Loi ne i giya modami thoŋgo mbe hu gharethovu weŋgi eŋge thavala thɨ gharethovu weŋga? Takis gharamban tembe thɨ vakathava ŋgoreiyako othembe thiye ma gharɨgharɨ thovuthovuyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Thoŋgo mbe hu gharethovu weŋgi eŋge lemi bodaboda, lemi vakathana ma i kivwala gharɨgharɨke taulaghɨ lenji vakatha. Thavala ma thɨ loŋweghathɨ tembe thɨ vakavakathava iyako. ");
INSERT INTO tgo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ghemi ghamithanavuna wolaghɨye i thovuye ŋgoreiya Ramami e buruburu ghathanavu i thovuye moli.” ");
INSERT INTO tgo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tha mbaŋa regha hu vakatha vakatha thovuye regha gharɨgharɨ e maranji na huŋava mbala thɨ thuweya lemi vakathana. Thoŋgo hu vakatha ŋgoreiyako, mane hu vaidi modami thovuye weya Ramami e buruburu.” ");
INSERT INTO tgo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Iya kaiwae, mbaŋa ne u giya bigi regha weŋgiya mbinyembinyeŋgu, tha u ghavwareyathu ŋgoreiye rakwan lenji vakatha e ŋgolo kururu tɨne na e kamwathɨŋgiko kaiwae nuwanjiya gharɨgharɨ thɨ taraweŋgi. Ya dage emunjoru e ghen, kaero thɨ mbanɨvao modanji. ");
INSERT INTO tgo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ko mbaŋa ne u giya bigi regha weŋgiya mbinyembinyeŋgu, thava nɨmanɨna iya moina i ghareghareya nɨmanɨna iya unena le vakatha, ");
INSERT INTO tgo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","mbala ma lolo regha i ghareghare mo wogiya budakai. Rama e buruburu iye i thuweya iya len vakatha thuwelena, na iye ne i giya modan.” ");
INSERT INTO tgo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mbaŋa hu naŋgo thava ŋgoreiya rakwan lenji vakatha. Thiye nuwanjiya thɨ ndeghathɨ na thɨ naŋgo e ŋgolo kururu na e kamwathɨ ghavwaghavwalaŋgi, kaiwae nuwanjiya gharɨgharɨ thɨ thuweŋgi. Ya dage emunjoru e ghemi, kaero thɨ mbanɨvao modanji. ");
INSERT INTO tgo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ko mbaŋa u naŋgo, u ru e woluwolu tɨne, u kiya thɨnɨmba na u naŋgo weya Rama, iye ma ra thuwe. Rama e buruburu iye i thuwevao thebigiya u vakatha thuwelena ne i giya modan.” ");
INSERT INTO tgo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mbaŋa ne hu naŋgo, tha mbema hu vara dagedage eŋge na hu govɨgova dage ma e ghanjirumwaru ŋgoreiya thavala ma thɨ loŋweghathɨgha Loi lenji vakatha. Thiye thɨ munjeva Loi ne i loŋweya lenji naŋgoko na i vakatha ŋgoreiye kaiwae lenji naŋgoko i molao. ");
INSERT INTO tgo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tha hu vakatha ŋgoraiyako, kaiwae thebigiya nuwamiya Ramami Loi kaero i ghareghare amba muyai hu naŋgowe. ");
INSERT INTO tgo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mbala hu naŋgo na ŋgora iyake: ‘Ramame e buruburu, wo yavwatatawana idan boboma, ");
INSERT INTO tgo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","len ghamba mbarona i mena weime, len renuwaŋana wo vakatha e yambaneke ŋgoreiya thɨ vakavakatha e buruburu. ");
INSERT INTO tgo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","U giya weime noroke ghanɨŋganiye. ");
INSERT INTO tgo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","U numotenɨŋgiya lama tharɨ, ŋgoreiya ghime kaero wo numoyathuŋgiya gharɨgharɨ lenji tharɨ weime. ");
INSERT INTO tgo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tha u vakathaime na wo ru tanathetha e tɨne, ko u vamoruime eŋge tharɨ e tɨne. Kaiwae ghen rambarombaro, ghen u vurɨgheghe na ghen giya laghɨye, mbaŋake wolaghɨye ma ele ghambako. Mbwana! Ŋgoreiye!’” ");
INSERT INTO tgo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kaiwae thoŋgo hu numoyathuŋgiya gharɨgharɨ lenji tharɨ weŋga, ambane Ramami e buruburu i numotenɨŋgiya lemi tharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ko thoŋgo ma hu numoyathuŋgiya gharɨgharɨ lenji tharɨ, Ramami tembe ŋgoreiyeva, mane i numotenɨŋgiya lemi tharɨ.” ");
INSERT INTO tgo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mbaŋa ne hu mbeya ghanɨŋga naŋgo kaiwae, tha ghamiyamoyamo i nuwanuwatharɨ, ŋgoreiya rakwan lenji vakatha. Ya dage emunjoru e ghemi, kaero thɨ mbanɨvao modanji. ");
INSERT INTO tgo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mbaŋa ne u mbeya ghanɨŋga naŋgo kaiwae, u thavwiya ghamwan na u woraweya bunama e umbalɨn, ");
INSERT INTO tgo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mbala gharɨgharɨ ma thɨ ghareghare u mbeya ghanɨŋga, ko mbe Rama eŋge e buruburu ghamberegha, iye i rothuwele, iye i thuwevao bigi regha na regha u vakatha thuwele, ne i giya modan.” ");
INSERT INTO tgo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tha hu mbanɨvathavatha bigibigi kaiwami e yambaneke, thaŋge ne i thɨnɨten na i vwatha, na rakaivɨ ne thɨ ru na thɨ kaivɨ. ");
INSERT INTO tgo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ko iyemaeŋge hu mbanɨvathavatha gogomwau kaiwami e buruburu, kaiwae thaŋge mane i thɨnɨten na i vwatha, na rakaivɨ mane thɨ ru na thɨ kaivɨ. ");
INSERT INTO tgo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kaiwae the bigithan i laghɨye e ghen, gharena tembe inaweva. ");
INSERT INTO tgo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Marandake ŋgora manjamanjala riwandake kaiwae. Thoŋgo maramaramina thɨ thovuye riwamina laghɨye tembe ŋgoreiyeva manjamanjala i riyevanjara. ");
INSERT INTO tgo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ko thoŋgo thɨ tharɨ, riwamina tembe ŋgoreiyeva, momouwo i riyevanjara. Thoŋgo manjamanjalana e gharemina i momouwo, o ma momouwo, i laghɨye yo!” ");
INSERT INTO tgo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ma valɨkaiwae lolo regha ne i tabo na rakakaiwo weŋgiya giyagiya theghewo. Thoŋgo valɨkaiwae, ne i gharethovu weya regha na i botewoyathu reghava, o i botewoyathu regha na i gharethovu reghava. Tembe ŋgoreiyeva ma mbaŋara vara u kaiwo weŋgiya Loi na mani.” ");
INSERT INTO tgo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Iya kaiwae ya dage e ghemi, tha hu rerenuwaŋa budakai ne hu ghan o hu mun na i tubwe yawalimi. Tha hu rerenuwaŋa kwama kaiwae ne hu njimbo na i vakatha riwamina i dayagha. Yawalɨ gharerenuwaŋa i laghɨye kivwala ghanɨŋga na riwandake gharerenuwaŋa i laghɨye kivwala kwama, ŋgoreiye ae? ");
INSERT INTO tgo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Wo hu rerenuwaŋa ma kaiwanji. Ma thɨ kaiwo, ma thɨ uloulo na ma thɨ vathe; ko iyemaeŋge Loi Rama e buruburu i njimbukikiŋgi. Ghemi hu laghɨye kivwalaŋgiya ma ae? ");
INSERT INTO tgo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ghemi ma regha valɨkaiwae ne i rerenuwaŋa na seiwova i vakatha yawaliyeko na molao.” ");
INSERT INTO tgo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Na buda kaiwae hu rerenuwaŋa kwama kaiwae? Wo hu thuweya jin inanji e njamnjam, ma thɨ kaiwo na ma thɨ ŋgiya ghanjikwama. ");
INSERT INTO tgo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ko ya dage e ghemi, othembe Kiŋ Solomon, le bigibigi va i ghanagha moli, ghakwamakwama thovuthovuye moli, mava ghanjiyamoyamo ŋgoreiye vara jinɨke thiyake regha. ");
INSERT INTO tgo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Loi i vanjimboŋgiya nana ŋgoreiyako, na nanako iyako noroke i mbuthumbuthu, ko evole i mare na thɨ ŋambu e ndɨghe une. Iya kaiwae hu ghareghare wagiyawe iye ne i vanjimboŋga. Ghemi lemi loŋweghathɨ nasiye moli. ");
INSERT INTO tgo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iya kaiwae tha hu rerenuwaŋa na huŋa, ‘Ne wo ghana budakai?’ o ‘Ne wo muna budakai?’ o ‘Ne wo njimbo budakai?’ ");
INSERT INTO tgo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Thavala ma thɨ loŋweghathɨ thɨ tamweŋgiya bigibigi ŋgoranjiyako, ko iyemaeŋge Ramami e buruburu kaero i ghareghare ghemi nuwamiya bigibigiko thiyako. ");
INSERT INTO tgo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ko wo hu tamwekaiya Loi le ghamba mbaro na hu vakatha ŋgoreiya le renuwaŋa, amba ne i giyava e ghemi iya bigibigiko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iya kaiwae tha hu rerenuwaŋa evole kaiwae, kaiwae budakai ne i yomara weŋga evole, evole mbe kaiwae. Mbaŋa regha na regha mbe ghavuyowo. Thava te hu vatabova vuyowoko iyako.” ");
INSERT INTO tgo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tha hu wovatharɨtharɨŋaŋgiya ghamune, ne iwaeŋge Loi i wovatharɨtharɨŋaŋga. ");
INSERT INTO tgo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Loi le wovatharɨtharɨ weŋga ne i mboromboro weiye lemi wovatharɨtharɨ weŋgiya ghamunena. Lemi vakathako gharɨgharɨ weŋgi tembene i vakathava ŋgoreiye weŋga. ");
INSERT INTO tgo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Buda kaiwae u thuweya ŋuthuŋuthuna ghanuna e marae, ko iyemaeŋge ma u thuweya umbwana laghɨye iya ghen e maranɨna? ");
INSERT INTO tgo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Thoŋgo umbwa laghɨye ina e maranɨna, ŋgoroŋgaeŋge na u dage weya ghanuna, ‘Ne ya woraŋgiya ŋuthuŋuthuna e maranɨna?’ ");
INSERT INTO tgo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Taukwana ghen! I viva wo u woraŋgiya umbwana ghen e maranɨna na maranɨna i manjamanjala amba valɨkaiwae ne u woraŋgiya ŋuthuŋuthuna ghanuna e marae.” ");
INSERT INTO tgo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tha hu giya bigi boboma weŋgiya mbughambugha, ne iwaeŋge thɨ ndevɨ na thɨ gharɨŋga. Tha hu wokiyathu lemi bigi thovuye mbombo e ghamwanji, ne thɨ vurɨghɨya.” ");
INSERT INTO tgo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Hu naŋgo weya Loi na i giya weŋga; hu tamwe na hu vaidi; hu dɨghɨdɨghɨ na thɨnɨmba i vu weŋga. ");
INSERT INTO tgo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaiwae thela thoŋgo i naŋgowe ne i wo, thela thoŋgo i tamwe ne i vaidi, na thela thoŋgo i dɨghɨdɨghɨ thɨnɨmba ne i mavuwe.” ");
INSERT INTO tgo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ŋgoroŋga, thoŋgo ghemina regha nariye i naŋgo ghanɨŋgawe, ne i wogiya varɨwe? ");
INSERT INTO tgo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O thoŋgo i naŋgo weya borogi, ne i giya mwatawe? ");
INSERT INTO tgo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Othembe gharɨgharɨ raraithara ghemi, ko iyemaeŋge mbaŋake wolaghɨye hu giyagiya bigibigi thovuthovuye weŋgiya lemi ŋgaŋga. Iya kaiwae ra ghareghare wagiyawe, Ramanda e buruburu i giya bigibigi thovuthovuye weŋgiya thavala thɨ naŋgowe.” ");
INSERT INTO tgo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Budakaiya nuwamiya gharɨgharɨ thɨ vakatha e ghemi, hu vakathava weŋgi kaiwae Mosese le mbaro na Loi ghalɨŋae gharautu lenji vavaghare ŋgoreiya iyako.” ");
INSERT INTO tgo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Hu ru e ghamba runa iya i mbɨmbɨthana, kaiwae Gehena ghaghamba ru i magaga na ghakamwathɨ i laghɨye, na gharɨgharɨ lemoyo thɨ rakareŋawe. ");
INSERT INTO tgo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ko yawalɨ ghaghamba ru i mbɨmbɨtha na kamwathɨniye nasiye na thegheviye eŋge thɨ vaidi.” ");
INSERT INTO tgo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Hu njimbukikiŋga, gharɨgharɨ vavana ne thɨ utu kwanɨkwan, ne thɨŋava thiye Loi ghalɨŋae gharautuŋgi. Ghanjiyamoyamo ne ŋgoreiya sip udauda, ko iyemaeŋge e gharenjiko ŋgoreiya mbugha njamnjam. ");
INSERT INTO tgo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Une tene hu thuweya ve raŋgi e lenji vakathako. Waen une mane vo vu e tatata tɨnetɨne, ae? Kopi une mane vo vu e kavwala, ae? ");
INSERT INTO tgo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tembe ŋgoreiyeva, umbwa thovuye ne i rau ne une thovuye na umbwa raitharɨ i rau ne une raitharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Umbwa thovuye ma valɨkaiwae une i tharɨ na umbwa raitharɨ ma valɨkaiwae une i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","The umbwa i rau na une ma i thovuye, thɨ kitenɨyathu na thɨ bigiŋambu e ndɨghe une. ");
INSERT INTO tgo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ambane hu ghareghareŋgi e lenji vakathaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ma gharɨgharɨke wolaghɨye iya thɨ dageke e ghino, ‘Giya, Giya,’ ne thɨ rakaruvao Loi ele ghamba mbaro tɨne, ko thela i vakatha ŋgoreiya Bwebwe e buruburu le renuwaŋa iye ne ve ru. ");
INSERT INTO tgo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mbaŋa ele ghambako gharɨgharɨ lemoyo ne thɨŋa ‘Giya, Giya, e idan wo utuŋa Loi ghalɨŋae, e idan woŋa na nyao raraitharɨ thɨ rakaraŋgi na e idan wo vakathaŋgiya vakatha ghamba rotaele laghɨlaghɨye.’ ");
INSERT INTO tgo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Amba ne ya dage weŋgi, ‘Ma ya ghareghareŋga. Hu roiteteŋgo, ghemi tharɨ gharavakatha.’” ");
INSERT INTO tgo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Iya kaiwae thela i loŋweya lo utuke na i vakatha ŋgoreiye, iye ŋgoreiya amalama le renuwaŋama va i thovuye na i vatada le ŋgoloma e varɨ vwatae. ");
INSERT INTO tgo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Uyevwelaghɨ i nja, ŋgonuŋgo i voru na ndewendewe i rowo vurɨgheghe e ŋgoloko iyako, ko iyemaeŋge mava i mambun kaiwae va i vatad e varɨ vwatae. ");
INSERT INTO tgo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ko thela i loŋweya lo utuke na ma i vakatha ŋgoreiye, iye ŋgoreiya amalama le renuwaŋama mava i thovuye na i vatada le ŋgoloma e kerakera vwatae. ");
INSERT INTO tgo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Uyevwelaghɨ i nja, ŋgonuŋgo i voru na ndewendewe i rowo vurɨgheghe e ŋgoloko iyako, i mambun na laiye laghɨye moli.” ");
INSERT INTO tgo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mbaŋa Jisas i utuvao utuutuke thiyake, le vavaghareko kaiwae i wo gharɨgharɨ nuwanji. ");
INSERT INTO tgo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Le vavaghare ma ŋgoreiya mbaro gharavavaghare, kaiwae i vavaghare weiye mbaro. ");
INSERT INTO tgo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mbaŋa Jisas i njama e ouko ghadidiye, wabwi laghɨye thɨ rakambele. ");
INSERT INTO tgo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Amala i ghataŋa lepelo i mena na i ronja e gheghe vuvuye Jisas e ghamwae na iŋa, “Giyana, thoŋgo nuwaniya, u vakathaŋgo na ya thovuye.” ");
INSERT INTO tgo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisas i livamomoya nɨmae na i vɨghathɨgha amalama amba iŋa, “Nuwaŋguke nuwaiya, riwana i thovuye!” E mbaŋako iyako lepeloma iko. ");
INSERT INTO tgo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisas i dagewe, “Wo u vandeŋeŋgo! Ne u ndeutuŋa iyake weya lolo regha. U wawe vara ravowovowo na ve thuweŋge. U bigiya ma manyiwo na vo vowo weya Loi ŋgoreiya Mosese le mbaro na gharɨgharɨ thɨ ghareghare emunjoru riwana kaero i thovuye.” ");
INSERT INTO tgo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mbaŋa Jisas i ru Kapenaom, Rom lenji ragagaithɨ gharandeviva i mena weya Jisas na i naŋgowe thalavu kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Iŋa, “Amalana, lo rakakaiwo i ghambwera, mbe ina e ŋgolo i ghenaghena. Riwaeko i kuvokuvo na i vɨrɨ laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas i dagewe, “Ra wao na va thawari.” ");
INSERT INTO tgo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ragagaithɨma lenji randeviva i gonjoghawe, iŋa, “Thava, Amalana. Ma elo thovuye ya vaŋguŋge na u mena elo ŋgolo. Mbema uŋaeŋge na lo rakakaiwoko kaero riwae i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ya ghareghare ghen valɨkaiwan kaiwae ya yaku randeviva laghɨlaghɨye e lenji mbaro tɨne na ghino ragagaithɨ mbe inanjiva e raberabeŋgu. Thoŋgo ya dage weya regha, ‘U wa,’ ne i wa, na ya dage weya regha, ‘U mena,’ ne i mena, na thoŋgo ya dage weya lo rakakaiwoko, ‘U vakatha iyake,’ ne i vakatha.” ");
INSERT INTO tgo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mbaŋa Jisas i loŋweya iyake, ghare i yo na i dage weŋgiya thiyeko thɨ rereghambakowe, “Ya dage emunjoru e ghemi, ma ya ndevaidi mun lolo regha le loŋweghathɨ le laghɨlaghɨye ŋgoraiyake Isirel gharɨgharɨniye e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya dage e ghemi, thɨ ghanagha ne thɨ mena yavorowoko na bodeoko weinjiyaŋgiya Eibraham, Aisake na Jeikob, thiya yaku e lenji ghamba yaku Loi ele thaga, ele ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ko Isirel gharɨgharɨniye lemoyo, thiye Loi va i vivathaŋa le ghamba mbaro kaiwanji, ne thɨ bigiyathu raŋgiyaŋgi eto e momouwoko na thɨ randa na thɨ rɨghɨmbiya ŋiŋinji.” ");
INSERT INTO tgo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Amba Jisas i dage weya ragagaithɨma lenji randeviva, iŋa, “U njogha! Ne ŋgoreiya iya len loŋweghathɨna.” E mbaŋako iyako le rakakaiwoma riwae i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mbaŋa Jisas i ru Pita ele ŋgolo, i vaidiya Pita mboriyae i ghambwera na mbe ina vara e ghambae riwae i dayagha na i ghena. ");
INSERT INTO tgo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","I vɨghathɨgha nɨmae na dayaghama ikowe, amba i thuweiru na i vaŋamweŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Varae vama ve ronja amba thɨ bigimenaŋgiya gharɨgharɨ lemoyo nyao raraitharɨ va inanji weŋgi weya Jisas. Vambema i dage eŋge nyaoko raraitharɨ kaero thɨ rakaraŋgi na i thawariŋgiya ghambweghambwera. ");
INSERT INTO tgo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","I vakatha ŋgoraiyako na i vaemunjoruŋa ŋgoroŋga Loi ghalɨŋae gharautu, Aiseya le utu, iya iŋake, “Iye i vaŋguraŋgiyainda ghambwera e tɨne na i woraŋgiya ghandagida.” ");
INSERT INTO tgo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mbaŋa i thuweya wabwi laghɨye thɨ meghɨliŋa, i dage weŋgiya gharaghambu na thɨ womalawa e valɨvaŋga regha. ");
INSERT INTO tgo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mbaro gharavavaghare regha i menawe na i dagewe, iŋa, “Ravavaghare, aŋga ne u reŋa mbene ya ghambuŋge vara.” ");
INSERT INTO tgo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas i gonjoghawe iŋa, “Mbugha lavalavarɨ mbe e lenji goga, na ma mbe e unyiunyinji. Ko Lolo Nariye ma e ghambaghambae na ne i vatowoŋa riwaewe.” ");
INSERT INTO tgo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Lolo reghava, iye Jisas gharaghambu regha, i dage weya Jisas iŋa, “Giyana, wo u vatomweŋgo na va beku bwebwe.” ");
INSERT INTO tgo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisas i gonjoghawe, “U ghambuŋgo. Ramaremare tembe thɨ bekuŋgiya lenji ramaremare.” ");
INSERT INTO tgo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas na gharaghambu thɨ tha e waŋga na thɨ wareri. ");
INSERT INTO tgo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma mbaŋa molao ndewendewe laghɨye i rowo e njighɨko tɨne i vakatha bagodu i vana e waŋga na i nja e waŋga tɨne. Ko Jisas va i ghenelaŋa. ");
INSERT INTO tgo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gharaghambuma thɨ wa vethɨ yavairɨ, thɨŋa, “Amalana, u vamoruime! Noroke woya munja.” ");
INSERT INTO tgo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Amba i dage weŋgi iŋa, “Buda kaiwae hu mararu? Lemi loŋweghathɨ ma i laghɨye.” Amba i thuweiru na i dage weya ndewendewe na bagodu thɨ towo na mbaŋara tad laghɨye i ghagha. ");
INSERT INTO tgo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Gharɨgharɨma weiyaŋgima gharenji i yo na thɨ vedage weŋgi thɨŋa, “The loloke, othembe ndewendewe na bagodu thɨ loŋweghathɨ ghalɨŋae?” ");
INSERT INTO tgo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mbaŋa Jisas vama i wamalawa valɨmbwa na i tan e valɨvaŋganiye iya Gadala gharɨgharɨniye thɨ yakukowe. Gheko i vaidiŋgiya amaamala thenjighewo nyao raraitharɨ ina weŋgi thɨ raŋgima e ghabughabubuko. Ghanjithanavu va i tharɨ moli na i vakatha gharɨgharɨ ma thɨ rakarakareŋa e kamwathɨko iyako. ");
INSERT INTO tgo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","E mbaŋako iyako thɨ kulawe na ghalɨŋanji i laghɨye, “Loi Nariye ghen. Nuwaniya u vakatha budakai weime? Nuwaniya u lithɨ weime, ko iyemaeŋge amba ma lithɨ ghambaŋa?” ");
INSERT INTO tgo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mbombo naura mava inanji bwagabwaga weŋgi, va thiya nuve. ");
INSERT INTO tgo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nyaoma raraitharɨ thɨ naŋgowe, thɨŋa, “Thoŋgo u variye raŋgiyaime, u variyeime na voru weŋgiya mbomboko.” ");
INSERT INTO tgo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","I dage weŋgi, “Hu raka!” Thɨ raŋgi na vethɨ ru weŋgiya mbomboma. Mbomboma mbe naura vara thɨ rakanjaniya dagedagema, mbaŋara e njighɨ, na vethiya munja. ");
INSERT INTO tgo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mbomboma gharanjimbunjimbu thɨ rakavo na vethɨ vutha e ghemba. Vethɨ utugiya bigibigiko wolaghɨye na tembe ŋgoreiyeva budakai me yomara weŋgiya amaamalama nyaoma raraitharɨ inanji weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gharɨgharɨko wolaghɨye e ghembako tɨne thɨ rakaraŋgi weya Jisas. Mbaŋa thɨ thuwe, thɨ naŋgowe na i iteteŋa lenji valɨvaŋgako iyako. ");
INSERT INTO tgo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas i tha e waŋga na i wamalawa, i njogha e ghambae. ");
INSERT INTO tgo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amba gharɨgharɨ vavana thɨ womena thegha reghawe i kuvokuvo na vambe i ghena vara e ghambae ghavwarara. Mbaŋa i thuweya lenji loŋweghathɨko, i dage weya thegha i kuvokuvoma, “Naruŋgu, ghen gharena i matuwo! Len tharɨna kaero ya numoten.” ");
INSERT INTO tgo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mbaro gharavavaghare vavana thɨ veutu weŋgi thɨŋa, “Amalake iyake i munjeva iye Loi. Mbema i utuvatharɨ vara weya Loi.” ");
INSERT INTO tgo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas i ghareghareya lenji renuwaŋako, iya kaiwae i dage weŋgi iŋa, “Buda kaiwae tharɨ gharerenuwaŋa ina e gharemina? ");
INSERT INTO tgo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Iyaŋganiya ghautuutu i maya, ‘Len tharɨna kaero ya numoten,’ o yaŋa, ‘U yondovirɨ na u loŋga’? ");
INSERT INTO tgo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ya vaemunjoruŋa e ghemi, Lolo Nariye ele vurɨgheghe e yambaneke na valɨkaiwae i numotena tharɨ.” Amba i dage weya theghako kuvokuvoko, “U yondo, u bigiya ghambana ghavwarara na u wa e len ŋgolo!” ");
INSERT INTO tgo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Amba theghama i yondovirɨ na i wa ele ŋgolo. ");
INSERT INTO tgo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mbaŋa wabwima thɨ thuwe, i wo nuwanji na thɨ taraweŋa Loi kaiwae i giya mbaro ŋgoranjiyako weŋgiya gharɨgharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas i iteta ghembako iyako na ma ve loŋgaloŋga amba i vaidiya amala regha idae Matiu; iye takis gharamban, ina ele ghamba kaiwo. I dagewe, “U ghambuŋgo.” Matiu i yondovirɨ na i ghambu. ");
INSERT INTO tgo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mbaŋa Jisas i ghanɨŋga Matiu ele ŋgolo, takis gharamban na gharɨgharɨ raraitharɨ, thɨ rakamena na thiya yaku weinjiyaŋgiya Jisas na gharaghambu na thiya ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi vavana thɨ thuwe iyake, thɨ dage weŋgiya gharaghambu thɨŋa, “Buda kaiwae lemi ravavaghare i ghanɨŋga weiyaŋgiya takis gharamban na gharɨgharɨ raraitharɨ?” ");
INSERT INTO tgo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mbaŋa Jisas i loŋwevaidi utuke iyake amba iŋa, “Thavala riwanji thovuye ma nuwanjiya rathawathawari, mbe ghambweghambweraeŋge nuwanjiya. ");
INSERT INTO tgo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hu wa na vou tamweya utuke iyake gharumwaru; iya iŋake, ‘Ghino nuwaŋguiya gharenja ko ma nuwaŋguiya vowo.’ Kaiwae mava ya mena na ya kula weŋgiya thavala thɨ rumwaru, ya mena tharɨ gharavakatha kaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jon Rabapɨtaiso gharaghambu thɨ mena thɨ vaito Jisas thɨŋa, “Buda kaiwae ghime weimaŋgiya Parisi wo mbeya ghanɨŋga mbaŋa vavana, ko ghanɨraghambu nandere?” ");
INSERT INTO tgo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas i gonjogha weŋgi, “Thare valɨkaiwae ghe gharaghaghayawo ne thiya randa mbaŋa ragheghe ghɨmoru mbe inawe vara weiyaŋgi? Nandere! Ko mbaŋa tene i mena ambane thɨ vaŋgu weŋgiya ragheghe ghɨmoru ko amba thɨ mbeya ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ma lolo regha ne i liya kwama nasiye togha na i ŋgiyagana kwama teuyewe i bowotu, kaiwae mbaŋa ne i thavwi na i livamo toghako i mwanavatha ma i vakathaeŋge na i bowotu laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ma valɨkaiwae lolo regha i liŋgiya waen togha e variye teuye thɨ vakatha thetheghan njimwae. Thoŋgo ŋgoreiye, waenɨko ne le vurɨgheghe kaiwae na i topo amba waenɨko i maliŋgi na variyeko i tharɨ. Ko waen togha i liŋgi e variye togha na mbe theghewoko vara thɨ thovuye.” ");
INSERT INTO tgo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas vamba i utuutu, Jiu lenji randeviva regha i mena i ronja e gheghe vuvuye e ghamwae na iŋa, “Yawarumbuŋguno amba me mare eŋge. U mena. U liraweya nɨmanɨna e riwae na yawaliye i njogha.” ");
INSERT INTO tgo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jisas i yondovirɨ na i ghambu weiyaŋgiya gharaghambu. ");
INSERT INTO tgo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ela eunda i ghataŋa voruvoru theghathegha hoyaworo na umboiwo, i mena Jisas e ghereiye na i vɨghathɨgha ghakwama mbothiye. ");
INSERT INTO tgo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Le renuwaŋa va iŋa, “Thoŋgo mbema ya vɨghathɨ eŋge gha kwamako, woghambwerake ne iko.” ");
INSERT INTO tgo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas i ndevaghɨle na i thuwe amba iŋa, “Yawarumbuŋgu, gharena i matuwo! Len loŋweghathɨna i vamoruŋge.” E mbaŋako iyako ghambwerama ikowe. ");
INSERT INTO tgo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mbaŋa Jisas i ru randevivama ele ŋgolo, i thuweŋgiya igo gharawiwi na wabwi laghɨye thiya raŋi karere i laghɨye, ");
INSERT INTO tgo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","amba i dage weŋgi iŋa, “Taulaghɨna ghemi hu rakaraŋgi. Wevona ma i mare, mbema i ghena eŋge.” Taulaghɨko thɨ vavɨrɨ. ");
INSERT INTO tgo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ko mbaŋa thɨ variye raŋgiyaŋgiya gharɨgharɨko eto, Jisas i ru wevoko ele ghamba ghena, i yalawe e nɨmae na i thuweiru. ");
INSERT INTO tgo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Totoko iyako i lalo valɨvaŋgako iyako. ");
INSERT INTO tgo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas i iteta ghembako iyako na ma ina e loŋga mborowa, amba amaamala thenjighewo thɨ kulakula reghambawe, thɨŋa, “Deivid rumbuye, gharen i nja weime.” ");
INSERT INTO tgo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mbaŋa i ru e ŋgolo tɨne, amaamalama maranjima i kwaghe thɨ menawe na i vaitoŋgi, “Thare hu loŋweghathɨ valɨkaiwaŋgu ya vamoruŋga?” Thɨŋa, “Ŋgoreiye amalana.” ");
INSERT INTO tgo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Amba i vɨghathɨgha maramaranji na iŋa, “Ne i yomara e ghemi ŋgoreiya lemi loŋweghathɨna.” ");
INSERT INTO tgo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kaero valɨkaiwae thɨ thuwe, Jisas i dage vavurɨgheghe weŋgi iŋa, “Ne hu ndeutuŋa weya lolo regha.” ");
INSERT INTO tgo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ko iyemaeŋge mbaŋa thɨ wa, vethɨ utuŋa Jisas utuutuniye e valɨvaŋgako iyako. ");
INSERT INTO tgo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Vama thɨ wareri vara, gharɨgharɨ vavana kaero thɨ womenava amala regha weya Jisas. Nyao raitharɨ va inawe na i vakatha ma e ghalɨghalɨŋae. ");
INSERT INTO tgo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mbaŋa Jisas i dage weya nyaoko raitharɨ na i raŋgi, amalama kaero i utuutuva. Gharɨgharɨko wolaghɨye gharenji i yo, thɨŋa, “Ma mbaŋa regha ra thuweya bigi regha ŋgoreiya iyake Isirel e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ko Parisi thɨŋa, “Nyao raraitharɨ lenji randeviva i giya vurɨgheghewe iya i variye raŋgiyaŋgiya nyaona raraitharɨ.” ");
INSERT INTO tgo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas i vaghɨliya ghembaghemba laghɨlaghɨye na nanasiyeko wolaghɨye. I vavaghare Jiu e lenji ŋgolo kururu tɨne na i utuŋa Toto Thovuye Loi le ghamba mbaro kaiwae, na i thawariŋgiya gida na ghambwera tomethi. ");
INSERT INTO tgo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mbaŋa i thuweŋgiya wabwi laghɨye ghare i nja weŋgi kaiwae riwanji i karavovo na ma e ghanjirathalavu, ŋgoranjiya sip ma e ghanjiranjimbunjimbu. ");
INSERT INTO tgo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Amba i dage weŋgiya gharaghambu, “Gharɨgharɨke thiyake ŋgoranjiya uma laghɨye kaero i tara ko rakakaiwo ma thɨ ghanagha. ");
INSERT INTO tgo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iya kaiwae hu naŋgo weya Giya, iye umako tanuwagae na i variyeŋgiya rakakaiwo na thɨ uloulo.” ");
INSERT INTO tgo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas i kula vathavathaŋgiya gharaghambu theyaworo na theghewo na i giya mbaro weŋgi na valɨkaiwanji thɨ variye raŋgiyaŋgiya nyao raraitharɨ na thɨ thawariŋgiya gharɨgharɨ thɨ ghataŋa tomethi gida na ghambwera. ");
INSERT INTO tgo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ghalɨŋae gharaghambɨ theyaworo na theghewoko thiyako: iviva, Saimon, idae regha Pita, na ghaghae Endru; Jemes Sebedi nariye na ghaghae Jon; ");
INSERT INTO tgo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip na Batolomiu; Tomas na Matiu iye takis gharamban; Jemes Alipiyos nariye na Tadiyas; ");
INSERT INTO tgo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon iye i mena e wabwi regha idanji Jilot na Judas Isakariyot, iye Jisas ghaliliva. ");
INSERT INTO tgo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas i variyeŋgiya gharɨgharɨke theyaworo na theghewoke thiyake. I giya vavurɨgheghe weŋgi, iŋa, “Thava ne hu wa thiye ma Jiu gharɨgharɨniye e lenji valɨvaŋga o Sameriya gharɨgharɨniye e ghambaghambanji. ");
INSERT INTO tgo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ko, mbe hu wa eŋge weŋgiya sip raghaweghawe, thiye Isirel gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hu wa vou utu weŋgi, huŋa, ‘Loi le ghamba mbaro ghe mbaŋa maiyavara.’ ");
INSERT INTO tgo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hu vamoruŋgiya ghambweghambwera, huŋa na ramaremare thɨ thuweiru, hu thawariŋgiya thɨ ghataŋa lepelo na hu variye raŋgiyaŋgiya nyao raraitharɨ. Kaero hu wo ma e modamodae, ko ghemieŋge hu wogiya bwaga ma e modamodae. ");
INSERT INTO tgo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tha hu bigiya gol, silva o kopa mani e lemi vethe nasiye tɨne; ");
INSERT INTO tgo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","tha hu bigiya bigibigi ghanjinambo lemi loŋgaloŋgana kaiwae, tha hu liya ghamikwama ghayaboyabo yaŋgarava, o ghemi ghae, o lemi pwasike. Tha hu rerenuwaŋa bigi regha kaiwae, kaiwae rakakaiwo ghambaro iye ne thɨ njimbukiki. ");
INSERT INTO tgo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mbaŋa ne hu ru e ghemba o ghemba nasiye regha, hu tamweya lolo thovuye regha e ghembana tɨne. Hu yaku weimi gheghada hu iteta ghembana iyana. ");
INSERT INTO tgo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mbaŋa ne hu ru e ŋgolo tɨne, huŋa ‘Loi i mwaewo weŋga.’ ");
INSERT INTO tgo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Thoŋgo gharɨgharɨ e ŋgolona iyana thɨ warari kaiwami, lemi dage mwaewoko yakuyaku thovuye kaiwae i meghabana gheko. Ko thoŋgo ma thɨ warari kaiwami lemi dage mwaewona mbe ghemieŋge hu vaidiya ghathovuye na thiye nandere. ");
INSERT INTO tgo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Thoŋgo gharɨgharɨ e ŋgoloko o e ghembako iyako ma thɨ kula vathaŋga o ma thɨ loŋweya lemi utuna, hu iteta ŋgolona o ghembana iyana na hu tagavughethu vugha e gheghemina. ");
INSERT INTO tgo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya dage emunjoru e ghemi, mbaŋa Loi le ghatha ghambaŋa ne i giya vuyowo laghɨye weŋgiya Sodoma na Gomora ko iyemaeŋge laghɨye moli gharɨgharɨ ghembana iyana ne thɨ vaidi. ");
INSERT INTO tgo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ya variyeŋga ŋgoreiya sip thɨ rakaru mbugha lavalavarɨ e tɨnenji. Ghemi mbe hu thimba ŋgoreiya mwata na mbe ghamithanavu i ghenenja ŋgoreiya bunebune. ");
INSERT INTO tgo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Hu njimbukikiŋga ghamimberegha, kaiwae gharɨgharɨ vavana ne thiya laweŋga na thɨ vaŋguŋga vohu kot. Ne thɨ liya thiyo i vurɨgheghe na thɨ yabɨbɨŋgawe e lenji ŋgolo kururu tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Idaŋgu kaiwae ne thɨ vaŋguŋga na thɨ vaŋguraweŋga rambarombaro na kiŋ e maranji na hu utuŋa Toto Thovuye weŋgi na tembe ŋgoreiyeva thiye ma Jiu gharɨgharɨniye weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mbaŋa ne thɨ vaŋguŋga kot kaiwae, thava hu rerenuwaŋa ŋgoroŋga ne vohu utu na huŋa o ŋgoroŋga ne vohuŋa. Kaiwae ne e mbaŋako iyako the utu nuwamiya ne hu utuŋa Loi ne i woveŋga. ");
INSERT INTO tgo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kaiwae utuŋgina iya ne hu utuŋaŋgina ma ghamimberegha lemi utu, Ramami e buruburu ghamberegha Une ina e ghemi iya ne i utuna. ");
INSERT INTO tgo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Amaamala vavana ne thɨ vaŋgugiya oghaghanji weŋgiya rambarombaro na thɨ gaboŋgi, na gamagai oramanji ne thɨ vakatha ŋgoreiye weŋgiya lenji ŋgaŋga. Gamagai vavana ne thɨ ndeghereiye wanaŋgiya otatanji na oramanji na thɨ vaŋgugiya weŋgiya rambarombaro na thɨ gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Idaŋgu kaiwae gharɨgharɨke wolaghɨye ne thɨ botewoyathuŋga, ko thela thoŋgo i vurɨgheghe na i ghataŋaghathɨ ne le ghambako Loi i vamora yawaliye. ");
INSERT INTO tgo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mbaŋa ne thɨ vakatha vuyowo weŋga e ghemba regha, hu vo na ma hu wava e ghemba regha. Ya dage emunjoru e ghemi, amba mane hu vakathavao ghamikaiwo Isirel e ghembaghembaniyeko wolaghɨye kaero Lolo Nariye i mena. ");
INSERT INTO tgo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ma ravavaona regha ne i kivwala le ravavaghare; ma rakakaiwo ne i kivwala ghagiyako. ");
INSERT INTO tgo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","I thovuye eŋge ravavaona i tabo na ŋgoreiya le ravavaghare na rakakaiwo ŋgoreiya ghagiya. Ŋgolo tanuwagae ghino, thoŋgo thɨ uno idaŋgu Bilɨsabul ghemi lo ŋgoloko gharɨgharɨniye ghemi, ne thɨ rena ida raraitharɨ moli na ghemi idaidami. ");
INSERT INTO tgo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Tha hu mararuŋgiya gharɨgharɨ, kaiwae budakaiya i rothuwele tene Loi i woraŋgiya e manjamanjala, na budakaiya e ghayaboyabo tene i tatethewo. ");
INSERT INTO tgo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Budakai ya utuŋa weŋga e momouwo, hu utuŋa e manjamanjala; budakai ya vaŋaewiŋa weŋga hu utuŋa na ghalɨŋami laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tha hu mararuŋgiya gharɨgharɨ, mbene thɨ tagavamareŋge lolo riwae, ko ma valɨkaiwanji thɨ tagavamare lolo une. Hu mararu eŋge Loi, iye valɨkaiwae i vakowana lolo riwae na une Gehena. ");
INSERT INTO tgo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Toeya gethɨra valɨkaiwae thɨ vamodo ma nanasiye manyiwo, ŋgoreiye? Ko iyemaeŋge mane manda i dobu e thelau vwatae na Ramanda ma i ghareghare. ");
INSERT INTO tgo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na ghemi mbe ŋgoreiyeva, umbalimina ndamwandamwae wolaghɨye kaero i vaonavao. ");
INSERT INTO tgo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iya kaiwae tha hu mararu. Ghemi hu laghɨye kivwalaŋgiya make nanasiye wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Thela thoŋgo i woraŋgiya gharɨgharɨ e maranji na iŋa iye woraghambu, ghino tembe ŋgoreiyeva, ne ya vakatha ŋgoreiye weya Bwebwe e buruburu. ");
INSERT INTO tgo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ko thela thoŋgo iŋa ma i ghareghareŋgo gharɨgharɨ e maranji, ghino tembe ŋgoreiyeva, ne yaŋa ma ya ghareghare Bwebwe e buruburu e marae. ");
INSERT INTO tgo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Thava lemi renuwaŋa huŋava ya mena e yambaneke na ya womena vanevane. Nandere. Ma ya womena vanevane, ko iyemaeŋge ya mena na mbala gaithɨ i yomara. ");
INSERT INTO tgo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ya mena na ya vakatha wabwi, ghɨmoru i ndeghereiyewana ramae, wevo i ndeghereiyewana tɨnae, na ghɨmoruko levo i ndeghereiyewana yawanyiye. ");
INSERT INTO tgo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ghɨmoru ghathɨghɨyaŋgi laghɨye moli, iye mbe le bodabodaŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Thela i mwaewo laghɨye weŋgiya tɨnae na ramae na ma i mwaewo laghɨye weŋgo iye ma valɨkaiwae i tabo na woraghambu. Thela i mwaewo laghɨye weya nariye, ghɨmoru o wevo, na ma i mwaewo laghɨye weŋgo iye ma valɨkaiwae i tabo na woraghambu. ");
INSERT INTO tgo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Thoŋgo thela ma i wo ghamberegha ghakros na i ghambuŋgo, iye ma valɨkaiwae i tabo na woraghambu. ");
INSERT INTO tgo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Thela thoŋgo nuwaiya i vamora yawaliye, ne i thɨvai. Thela thoŋgo i vatomweya yawaliye ghino kaiwaŋgu, ne i vaidiya yawalɨ memeghabananiye. ");
INSERT INTO tgo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Thela i kula vathaŋga, ŋgoreiya i kulavathaŋgo, na thela i kulavathaŋgo ŋgoreiya i kulavatha thela va i variyeŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Thela i kulavatha Loi ghalɨŋae gharautu, kaiwae iye Loi ghalɨŋae gharautu, ne i vaidiya modae ŋgoreiya Loi ghalɨŋae gharautu modae; na thela i kulavatha lolo ghathanavu thovuye kaiwae loloko iyako iye lolo thovuye, ne i vaidiya modae ŋgoreiya lolo ghathanavu thovuye modae. ");
INSERT INTO tgo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Thela i thɨnɨgiya mbwa weya nanasiyeŋgike thiyake regha na i mun kaiwae iye woraghambu, ya dage emunjoru e ghemi, ne e modamodae.” ");
INSERT INTO tgo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mbaŋa Jisas i giya vavurɨgheghe weŋgiya gharaghambu theyaworo na theghewo na e ghereiye, i iteta ghembako iyako na i wa Jiu e ghambaghambanji vavana ve vavaghare weŋgiya gharɨgharɨ gheko. ");
INSERT INTO tgo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon Rabapɨtaiso i loŋweya Krais le vakatha utuniye e thiyo tɨne, i variyeŋgiya gharaghambu ");
INSERT INTO tgo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","weya Jisas na thɨ vaito, thɨŋa, “Ghen mbema iya Jon va i utuŋa iŋa tene i mena o wo roroghaghaweva lolo regha?” ");
INSERT INTO tgo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas i gonjogha weŋgi iŋa, “Hu njogha na vohu utugiya weya Jon, budakaiya kaero hu thuwe na hu loŋwe: ");
INSERT INTO tgo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","maramaranji i kwaghe kaero thɨ thuwe, kuvokuvo kaero thɨ loŋga, thavala thɨ ghataŋa lepelo kaero riwanji i thovuye, yanawanji i kule thɨ loŋwe, ramaremare thɨ thuweiru na mbinyembinyeŋgu thɨ loŋweya Toto Thovuye iya thɨ vavaghare weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na tembe hu utugiyaweva iyake: Loi ghare weya lolo iya ma i roiteta ghino kaiwaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mbaŋa Jon gharaghambu thɨ rakarakanjogha, Jisas i utu weŋgiya wabwiko Jon kaiwae. Iŋa, “Mbaŋa va hu wa weya Jon e njamnjam, va nuwamiya hu thuweya budakai? Va hu wa gheko na vambema nuwamiya eŋge hu thuweya ndewendeweko i uvathawo wuŋgiwuŋgiko? ");
INSERT INTO tgo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Thoŋgo nandere, va hu wa eŋge na vohu thuweya budakai? Amala regha i njimbo kwama ghayamoyamo i thovuye? Nandere, thavala thɨ njimbo kwama thovuye thɨ yaku kiŋ e lenji ŋgolo. ");
INSERT INTO tgo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ko va vohu thuwe eŋge budakai? Loi ghalɨŋae gharautu? Ŋgoreiye, ya dage e ghemi, va vohu thuweya lolo regha iye Loi ghalɨŋae gharautu na ma e vwatanjiwova. ");
INSERT INTO tgo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Amalaghɨniye kaiwae iyava ghalɨŋae gharautu regha i rorina, iya iŋake Loi iŋa, ‘Ne ya variya ghalɨŋaŋgu gharautu e ghamwan, iye i vivatharaweya kamwathɨ ghen kaiwan.’” ");
INSERT INTO tgo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ya dage emunjoru e ghemi, iya vara taulaghɨyake thɨ yomara e yambaneke mamba regha i laghɨye kivwala Jon Rabapɨtaiso. Ko thela idae nasiye moli Loi ele ghamba mbaro tɨne, iye i laghɨye kivwala Jon. ");
INSERT INTO tgo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","I ri e mbaŋaniye Jon va i utuŋa Loi ghalɨŋae na gheghada mbaŋake noroke, gharɨgharɨ raraitharɨ thɨ munjeva thɨ vakaiwoŋa lenji vurɨgheghe na thɨ mando na thɨ wo Loi le ghamba mbaro. ");
INSERT INTO tgo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mosese le Mbaro na Loi ghalɨŋae gharautu va thɨ utuŋa Loi le ghamba mbaro utuniye i mena gheghada Jon ghambaŋa. ");
INSERT INTO tgo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Thoŋgo nuwamiya hu loŋweghathɨgha iyake, mbema Jon utuniye iyava gharautu regha iŋa Ilaija ne i njoghama. ");
INSERT INTO tgo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Thoŋgo e yanayanawami hu vandeŋe wagiyawe ghalɨŋaŋguke.” ");
INSERT INTO tgo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ŋgoroŋga ne yaŋa thake noroke kaiwanji? Ya dage e ghemi, thiye ŋgoranjiya gamagai thiya yaku e ghamba maket, thɨ kulakula weŋgiya ghanjiune, thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Wo wiya ghe ghaigo, ko ma hu thari. Wo wothuŋa nuwatharɨ wothuniye ko iyemaeŋge ma hu randa.’” ");
INSERT INTO tgo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Gharɨgharɨ thake noroke ŋgoranjiya gamagaiko thiyako tavwa ghɨthaŋgi kaiwae mbaŋa Jon va i mena, mbaŋa vavana i mbeya ghanɨŋga naŋgo kaiwae na mava i muna waen na gharɨgharɨ thɨŋa, ‘Nyao raitharɨ inawe.’ ");
INSERT INTO tgo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ko mbaŋa Lolo Nariye i mena, i ghanɨŋga na i munumu, na gharɨgharɨ thɨŋa, ‘Loloke iyake ŋgaŋganirɨ na waen gharamun; iye takis gharamban na thiye ma Jiu ghanjiu.’ Ko thimba i mena weya Loi ne ra thuweya gharɨgharɨ lenji vakatha i woraŋgiya na ra wovaemuemunjoruŋa.” ");
INSERT INTO tgo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas va i wovatharɨtharɨŋaŋgiya gharɨgharɨ e ghembaghembako iyava i vakatha vara vakathako i ghanagha weŋgi, kaiwae gharɨgharɨ mava thɨ uturaŋgiya lenji tharɨ na thɨ roitete. ");
INSERT INTO tgo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Aleu! Korasin, nevole hu thovuyaona! Aleu! Betɨsaida, nevole hu thovuyaona! Thoŋgo vakathaŋgike ghamba rotaele iyava ya vakathaŋgina weŋga ya vakathaeŋge Taiya na Saidon weŋgi, mbala vambe teuye, thɨ njimbo kwama thɨ vakatha thetheghan vulivuliye na thɨ vavughe riwanji e vugha na i woraŋgiya kaero thɨ uturaŋgiya lenji tharɨ na thɨ roiteteŋgi na Loi i numotenɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ko ya dage e ghemi, mbaŋa Loi ne ghambaŋa ghatha Taiya na Saidon ne thɨ vaidiya vuyowo seiwo ko ghemi ne hu vaidiya vuyowo laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na ghen Kapenaom, thava hu renuwaŋa Loi ne i yavwatata wanaŋga e buruburu. Loi ne i wokiyathuŋga vohu nja Hedesi. Thoŋgo vakathaŋgike ghamba rotaele iyava ya vakathaŋgina weŋga va thɨ vakatha Sodoma, mbala mbe inawe e mbaŋake noroke. ");
INSERT INTO tgo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ya dage e ghemi, mbaŋa ele ghambako, Loi ne i lithɨ e ghemi vuyowo laghɨye moli, ko va i lithɨ weŋgiya Sodoma ma vuyowo laghɨye moli.” ");
INSERT INTO tgo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","E mbaŋako iyako Jisas iŋa, “Ya taraweŋaŋge, Bwebwe, Giya ghen e buruburu na e yambaneke, kaiwae u wothuwela bigibigike thiyake weŋgiya rathimbathimba na thavala lenji ghareghare i laghɨye na kaero u woraŋgiya weŋgiya thavala amba lenji renuwaŋa ŋgoreiya gamagai. ");
INSERT INTO tgo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ŋgoreiye Bwebwe, kaiwae len renuwaŋana va ŋgoreiyako iya u vakathako.” ");
INSERT INTO tgo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Bwebwe vama i giyavao weŋgo ghareghareke wolaghɨye. Ma lolo regha i ghareghare Nariye, mbe Bwebwe eŋge, na ma lolo regha i ghareghare Bwebwe, mbe Nariyeke eŋge ghino, na thavala ya tuthiŋgi na ya woraŋgiya weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ghemi hu mena weŋgo thavala riwami i bane na ghamibigi i vuyowo, na ya vatowoŋaŋga. ");
INSERT INTO tgo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bigike iya ya woveŋgake, hu wo! Na hu varevareŋgo! Kaiwae ghino wothanavu i ghenenja na i udauda na hu vaidiya towowe. ");
INSERT INTO tgo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bigike iya ya woveŋgake i maya na doweke iya ne ya giyake e ghemi ma e vuyovuyowae.” ");
INSERT INTO tgo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","E mbaŋako iyako, Sabat regha Jisas i ghathara wit e ghauma. Bada i gharɨŋgiya gharaghambu, amba thɨ vugha wit uneune na thɨ ghan. ");
INSERT INTO tgo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mbaŋa Parisi thɨ thuweŋgi amba thɨ dage weya Jisas, thɨŋa, “Wo u thuwe, ghanɨraghambu ma thɨ ghambugha Sabat ghambaro.” ");
INSERT INTO tgo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisas i gonjogha weŋgi iŋa, “Ko ma hu ndevaona mun Deivid utuutuniye, mbaŋa va weiyaŋgiya ghaune na bada i gharɨŋgi? ");
INSERT INTO tgo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Va ve ru Loi ele ŋgolo tɨne na ravowovowo i giya bred bobomawe, i raŋgi na thɨ ghan weiyaŋgiya ghauneko. Bredɨko iyako va thɨ ghan othembe mbaro i dageten weŋgi, mbe ravowovowo eŋge kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O ma hu vaona Mosese le Mbaro, iya iŋake Sabat regha na regha ravowovowo thɨ kaiwo e Ŋgolo Boboma tɨne? Iyako kaero thɨ raka Sabat ghambaro iyemaeŋge ma thɨ vakatha tharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ya dage e ghemi, bigi regha ina gheke, iye i kivwala Ŋgolo Boboma. ");
INSERT INTO tgo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ma hu ghareghare utuutuke thiyake ghanjirumwaru, iya iŋake, ‘Ghino nuwaŋguiya gharenja thanavuniye, ma nuwaŋguiya vowo.’ Thoŋgo hu ghareghare wagiyawe utuutuke thiyake ghanjirumwaru mbala ma hu wovatharɨtharɨŋaŋgiya gharɨgharɨke thiya ma thɨ vakatha tharɨke. ");
INSERT INTO tgo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kaiwae Lolo Nariye iye Sabat ghagiya.” ");
INSERT INTO tgo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas i iteta iyako na ve ru e lenji ŋgolo kururu tɨne, ");
INSERT INTO tgo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","na gheko, amala regha inawe, nɨmae i kuvokuvo. Gharɨgharɨ vavana va inanji gheko, nuwanjiya thɨ wonjoweya Jisas le vakatha vatharɨ kaiwae. Thɨ vaito, thɨŋa, “Ŋgoroŋga, la mbaro i vatomwe na i thovuye eŋge ra vamora lolo Sabat e tɨne o nandere?” ");
INSERT INTO tgo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","I dage weŋgi, iŋa “Thoŋgo ghemi regha le sip regha i dobu e goga Sabat e tɨne, ma i thovuyewe ne i yalawe na i wovoreŋa? ");
INSERT INTO tgo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Emunjoru sip bigi laghɨye, ko iyemaeŋge lolo iye bigi laghɨye moli. Iya kaiwae la Mbaro i vatomweŋge weinda ra vakatha vakatha thovuye Sabat e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Amba i dage weya amalama, iŋa “U livamomoya nɨmanɨna.” I livamomoya nɨmaeko na kaero i thovuyeva ŋgoreiya reghako. ");
INSERT INTO tgo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Parisi thɨ rakaraŋgi na vethɨ rerenuwaŋa ŋgoroŋga ne thɨŋa na thɨ unɨghɨ. ");
INSERT INTO tgo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas vama i ghareghare lenji renuwaŋako, i iteta ghembako iyako na gharɨgharɨ lemoyo thɨ ghambu. Ghambweghambwerako wolaghɨye va inanji e wabwiko tɨne, i thawarivaoŋgi, ");
INSERT INTO tgo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","i dage vurɨgheghe weŋgi na thava thɨ utuŋa utuniye thela amalaghɨniye. ");
INSERT INTO tgo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Va i vakatha ŋgoreiyako na i vaemunjoruŋa ŋgoroŋga Loi va iŋa weya ghalɨŋae gharautu, Aiseya. ");
INSERT INTO tgo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Iŋa: “Lo rakakaiwo iyake. Iye va ya tuthi. Ya gharethovu na ya warari laghɨye kaiwae. Ne ya wogiya uneŋgukewe, na iye ne i utuŋa lo renuwaŋa thovuye weŋgiya gharɨgharɨke wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mane i wogaithɨ weiyaŋgiya gharɨgharɨ na mane i kulakula. Mane i utu na ghalɨŋae laghɨlaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mane i yanji wanaŋgiya thavala thɨ njavovo, na thavala riwanji ma ele vurɨgheghe mane i vakowanaŋgi. Ne i kaiwo gheghada Loi le ghamba mbaro thovuye i kivwalaŋgiya bigibigike wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Amalaghɨniye e idae gharɨgharɨke wolaghɨye lenji vareminje ne inawe.” ");
INSERT INTO tgo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Gharɨgharɨ vavana thɨ womena amala regha maramara thɨ kwaghe na ma e ghalɨghalɨŋae, kaiwae nyao raitharɨ va inawe. Jisas i thawari ambama ghalɨŋae i mavu na kaero i thuweva. ");
INSERT INTO tgo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gharɨgharɨko wolaghɨye gharenji i yo na thɨŋa, “Mbwata iye Deivid Rumbuye, ae?” ");
INSERT INTO tgo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ko mbaŋa Parisi thɨ loŋweya iyako, thɨŋa, “I variyeraŋgiya nyao raraitharɨ kaiwae nyao raraitharɨ ghanjigiya Bilɨsabul i giya vurɨgheghewe na i vakatha ŋgoreiye.” ");
INSERT INTO tgo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas i ghareghare lenji renuwaŋako na i dage weŋgi, iŋa “Ghamba mbaro regha thoŋgo thɨ vakatha wabwi na wabwi na thɨ vegaithɨ weŋgi, ghamba mbaroko iyako mane i wo mbaŋa molao. Na ghemba regha o ŋgolo regha, thoŋgo thɨ vakatha wabwi na wabwi na thɨ vegaithɨ weŋgi ne thɨ dobu moli. ");
INSERT INTO tgo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Thoŋgo Seitan i variyeraŋgiya le nyao raitharɨ na i vakatha wabwi ele ghamba mbaro tɨne amba thɨ vegaithɨ weŋgi, le ghamba mbaroko ne i ko moli. ");
INSERT INTO tgo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ghemi huŋa ya variyeraŋgiya nyao raraitharɨ kaiwae Seitan i giya vurɨgheghe e ghino, na thela i giya vurɨgheghe weŋgiya ghamiraghambu na thɨ variye raŋgiyaŋgiya nyao raraitharɨ? Ghamiraghambu lenji vakatha i woraŋgiya lemi kwanɨna. ");
INSERT INTO tgo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ko thoŋgo Loi Une le vurɨgheghe e tɨne na ya variyeraŋgiya nyao raraitharɨ, iyake i vaemunjoruŋa Loi le ghamba mbaro kaero i mena weŋga.” ");
INSERT INTO tgo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ma valɨkaiwae lolo regha i ru amala vurɨgheghe regha ele ŋgolo na i kaiva le bigibigi thoŋgo iviva ma i yalawekai na i ŋgarɨghathɨ e thiyo, amba muyai i kaiva le bigibigiko e ŋgoloko tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Thela ma weiŋgu iye wothɨghɨya, na thela ma weiŋgu wo mbanvathavatha gharɨgharɨ iye i vagevagegeyathu. ");
INSERT INTO tgo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iya kaiwae ya dage e ghemi, thela i vakatha tharɨ na i utuvatharɨ weya Loi, ne i numoten, ko thela thoŋgo i utuvatharɨ weya Nyao Boboma, Loi mane i numotena le tharɨko iyako. ");
INSERT INTO tgo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Thela thoŋgo i utuvatharɨ weya Lolo Nariye, Loi ne i numoten, ko thela thoŋgo i utuvatharɨ weya Nyao Boboma, Loi mane i numoten e mbaŋake iyake o mbaŋa i menamenako.” ");
INSERT INTO tgo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Thoŋgo umbwa thovuye, une tembe thovuyeva. Thoŋgo umbwa raitharɨ, une tembe raitharɨva. Umbwa, uneko i woraŋgi, umbwa thovuye o raitharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ghemi ŋgoramiya mwata! Ma valɨkaiwami hu utuŋa utu thovuye kaiwae gharɨgharɨ raraithara ghemi! Kaiwae budakaiya i riyevanjara gharendake, iya ve raŋgi e ghaendake. ");
INSERT INTO tgo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lolo thovuye i woraŋgiya bigi thovuye kaiwae thovuyeko iyako i mena e ghare. Lolo raitharɨ i woraŋgiya bigi raitharɨ kaiwae tharɨko iyako i mena e ghare.” ");
INSERT INTO tgo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ya dage e ghemi, mbaŋa Loi ne ghambaŋa i ghathaŋgiya gharɨgharɨ, lolo regha na regha ne ve kot weya Loi utuko raraitharɨ wolaghɨye iya i utuŋaŋgiko kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Thoŋgo e ghalɨŋamina lemi utu i thovuye Loi ne i wovathovuthovuyeŋaŋga. Thoŋgo e ghalɨŋamina lemi utu raraitharɨ Loi ne i wovatharɨtharɨŋaŋga.” ");
INSERT INTO tgo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Amba Parisi na Mbaro gharavavaghare vavana thɨ dage weya Jisas, thɨŋa “Ravavaghare, nuwameiya u vakatha vakatha ghamba rotaele regha na wo thuwe mbala wo ghareghare u mena weya Loi.” ");
INSERT INTO tgo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisas i gonjogha weŋgi iŋa, “Tha raraithara ghemi na hu roiteta Loi ghathanavu. Nuwamiya ya vakatha nono ghamba rotaele. Ko mane ya vakatha nono regha kaiwami. Nono ghamba rotaele mbe reghaeŋge Loi ne i giya weŋga, iyava i vakatha weya ghalɨŋae gharautu, Jona. ");
INSERT INTO tgo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kaiwae Jona va ina borogi e ŋgamoiye mbaŋa thegheto na gougou thegheto, tembene ŋgoreiyeva Lolo Nariye, mbaŋa thegheto na gougou thegheto ne ve yaku e thelau tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mbaŋa Loi ghambaŋa i ghathaŋgiya gharɨgharɨ, Ninive gharɨgharɨniye ne thɨ rakayondo thɨ wovatharɨtharɨŋaŋgiya thake iyake, kaiwae va thɨ loŋwe Jona le vavaghare, thɨ uturaŋgiya lenji tharɨ na thɨ roitete, na mbaŋake lolo regha ina gheke iye i laghɨye kivwala Jona. ");
INSERT INTO tgo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mbaŋa Loi ne ghambaŋa i ghathaŋgiya gharɨgharɨ, kwin i mena e yaghalako ne i yondo na i wovatharɨtharɨŋaŋga, kaiwae i ri e ghemba bwagabwaga moli na i mena i vandeŋe Solomon le thimba. Na mbaŋake lolo regha ina gheke i laghɨye kivwala Solomon na thake iyake ma thɨ goruwe.” ");
INSERT INTO tgo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mbaŋa nyao raitharɨ i raŋgi weya lolo regha, i wa ve loŋgatakwa njamnjamɨko tɨne ma mbwaniye, i tamweya le ghamba towo, ko iyemaeŋge ma i vaidiya regha. ");
INSERT INTO tgo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Amba iŋa, ‘Wo ya njogha ŋgora lo ghamba yakuma ma rimawe.’ Mbaŋa i njogha, i thuweya le ghamba yakuko kaero thɨ wanji wagiyawe na bigibigiko wolaghɨye e tɨneko thɨ vakatha wagiyawe, ko iyemaeŋge kokowae. ");
INSERT INTO tgo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Amba i wa na ve vaŋguŋgiva nyao thenjighepirɨ, thɨ tharɨ moli, thɨ kivwala amalaghɨniye. Thɨ ru na thɨ yaku gheko. Loloko iyako le yakuyaku va i viva i tharɨ, ko e mbaŋako iyako i tharɨ laghɨye moli. Iyake ne ŋgoreiye weŋga, ghemi thake raraitharɨ iyake.” ");
INSERT INTO tgo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas vamba i utuutu weŋgiya wabwi, tɨnae na oghaghae ma inanji eto thɨ ndeghathɨ, thɨ tamwetamwewe kaiwae nuwanjiya thɨ utuwe. ");
INSERT INTO tgo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Amba lolo regha i dagewe iŋa, “Amalana, tɨna na oghagha iya thɨ ndeghathɨ etoke, nuwanjiya thɨ utu e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisas i gonjoghawe iŋa, “Ko nava thela na oghaghaŋguŋgiya thavala?” ");
INSERT INTO tgo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","I liya nɨmae na i thɨvatomweŋgiya gharaghambu, na iŋa, “Wo hu thuwe! Thiyake, nava na oghaghaŋgu. ");
INSERT INTO tgo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Thela thoŋgo i vakatha Bwebwe e buruburu le renuwaŋa iye ghaghaŋgu, louŋgu na tɨnaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mbaŋako iyako e tɨne, Jisas i raŋgi e ŋgoloko tɨne, i wa e njighɨko ghadidiye na ve yakuwe. ");
INSERT INTO tgo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wabwi laghɨye moli thɨ rakavathavatha na thɨ rovaghɨliya, iya kaiwae i tha e waŋga regha na i yakuwe, ko gharɨgharɨko va thiya ndeghathɨ e njighɨko ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mbe i goghaimbaeŋge na i utuŋa bigibigi i ghanagha weŋgi. Iŋa, “Mbaŋa regha amala regha i wa ele uma na ve yathu weiwo. ");
INSERT INTO tgo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mbaŋa i yathu vavana thɨ unja e kamwathɨ mara, ma thɨ mena thɨ ghanɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Vavana vethɨ unja e thelau ele varɨvarɨ ko ghanjithelauko mava i poku. Va thɨ maya e mbuthu, kaiwae ghanjithelauko mava i poku. ");
INSERT INTO tgo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ko mbaŋa varae i yovoro na i mbɨle, dayaghawae kaiwae i ŋambuŋgi na i mareyawowo kaiwae wathelilinji ma vamba ina bwagabwaga. ");
INSERT INTO tgo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Weiwo vavana vethɨ unja ŋgora nana raraitharɨ kaero inanjiwe, nanako thiyako lenji mbuthu i maya na thɨ vwariŋgiya witɨma. ");
INSERT INTO tgo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mbombouye vavana va vethɨ unja e thelau thovuye na thɨ rau. Tomethi uneunenji, vavana uneunenji voghɨthaŋarɨ (100), vavana voghɨyewona (60) na vavana voghɨyeto (30). ");
INSERT INTO tgo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Thoŋgo e yanayanawami hu vandeŋe wagiyawe ghalɨŋaŋguke.” ");
INSERT INTO tgo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Gharaghambu thɨ menawe na thɨ vaito, thɨŋa “Buda kaiwae mbe u goghaimbaeŋge mbaŋa u utu weŋgiya gharɨgharɨ?” ");
INSERT INTO tgo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisas i gonjogha weŋgi iŋa, “Loi le ghamba mbaro gharerenuwaŋa va i rothuwele kaero i woraŋgiya weŋga, ko ma vamba i woraŋgiya weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Thela ele ghareghare Loi ne i vatabowe na Loi ghaghareghare i laghɨye moliwe; ko thela ma Loi ghaghareghare inawe, othembe seiwo moli ele ghareghare, Loi ne i woraŋgivaowe. ");
INSERT INTO tgo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lo rɨghe iya ya utu na mbe ya goghaimbake eŋge weŋgi, kaiwae thɨ ghaghayawo, ko iyemaeŋge ma thɨ ghewovaidi, na thɨ vandeŋe, ko iyemaeŋge ma thɨ loŋwe wagiyawe na thɨ ghareghare. ");
INSERT INTO tgo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Thiyeke weŋgi, Aiseya, Loi ghalɨŋae gharautu ghalɨŋae i tabo na emunjoru, iya iŋake, Mbe hu vandevandeŋa, ko iyemaeŋge ma hu ghareghare, mbe hu ghaghayawo, ko iyemaeŋge ma hu ghewovaidi. ");
INSERT INTO tgo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kaiwae gharɨgharɨke thiyake gharenji i vurɨgheghe, thɨ vowiya yanawanji, na thɨ kɨkɨmare kaiwae thɨ botewo ghathuwathuwa. Thɨ vakatha ŋgoreiye mbala ma thɨ thuwe e maranji, ma thɨ loŋwe e yanawanji o thɨ ghareghare e gharenji, na thɨ numonjogha e ghino na ya thawariŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ko ghemi, i thovuye moli kaiwae marami i manjamanjala na yanawami i bowotu. ");
INSERT INTO tgo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ya dage emunjoru e ghemi, Loi ghalɨŋae gharautuŋgi na gharɨgharɨ thɨ ghambugha Loi ghathanavu va nuwanjiya moli thɨ thuwe budakaiya kaero hu thuwe na thɨ loŋwe budakaiya kaero hu loŋwe, ko mava valɨkaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Wo hu vandeŋe ya vamanjamanjalaŋa rayathu weiwo ghagoghaimba na hu loŋwe. ");
INSERT INTO tgo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mbaŋa lolo regha i loŋweya Loi le ghamba mbaro utuniye na ma i ghareghare gharumwaru, Seitan ne i mena na i mbana budakai va thɨ kabu e ghareko. Weiwoke iyake iyava vethɨ unja e kamwathɨma mara. ");
INSERT INTO tgo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Weiwoma iyava vethɨ unja e thelauma ele varɨvarɨma, thiyake ŋgoreiya gharɨgharɨ thɨ loŋweya utu thovuye na e mbaŋako iyako thɨ wo utuko iyako weiye lenji warari, ");
INSERT INTO tgo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ko iyemaeŋge ma thɨ rerenuwaŋa kaiwae na mbe mbaŋa ubotu eŋge i yaku kaiwae watheliliye ma i nja bode. Mbaŋa thɨ vaidiya vuyowo o gharɨgharɨ vavana thɨ vakathaŋgi na thɨ vaidiya vɨrɨ utuko thovuye kaiwae, e mbaŋako iyako kaero thɨ dobu. ");
INSERT INTO tgo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Weiwoma iyava vethɨ unja ŋgora nanama raraitharɨ inanjiwe, thiyake ŋgoranjiya gharɨgharɨ thɨ loŋweya utu thovuye ko iyemaeŋge yambaneke renuwaŋaniye i vagaghala nuwanji na nuwanjiko i ghaŋgo weya gogomwau na nuwanjiya lemoyo, iyake kaiwae, mane thɨ mbuthu na thɨ rau. ");
INSERT INTO tgo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Weiwoma iyava vethɨ unja e thelauma thovuye, thiyake ŋgoranjiya gharɨgharɨ thɨ loŋweya utu thovuye na thɨ ghareghare ŋgoroŋga gharumwaru; thɨ rau, vavana uneune voghɨthaŋarɨ (100), vavana voghɨyewona (60) na vavana voghɨyeto (30).” ");
INSERT INTO tgo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas mbowo i utuŋava goghaimba regha weŋgi, iŋa, “Loi le ghamba mbaro ŋgoreiya iyake. Amala regha i yathu wit mbombouye thovuthovuye ele uma. ");
INSERT INTO tgo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gougou regha gharɨgharɨko va thiya ghena amba amalama ghathɨghɨya i mena i ru e umama tɨne na i yathu nana raitharɨ mbombouye e witɨma tɨnenji na i wa. ");
INSERT INTO tgo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mbaŋa witɨma i mbuthu na kaero i woraweya le rau rɨghe, nanama raraitharɨ kaero thɨ yomarava.” ");
INSERT INTO tgo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Amalama le rakakaiwo thɨ menawe na thɨŋa, ‘Amalana, va u yathu wit mbombouye thovuye e len umako tɨne, na nanako raraitharɨ aŋga thɨ mena?’” ");
INSERT INTO tgo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“I dage weŋgi, iŋa ‘Wothɨghɨya regha nuwaiya i vakatha tharɨ e ghino iya i vakatha iyana.’ Rakakaiwoma thɨ vaito thɨŋa, ‘Thare nuwaniya ghime wo wa na vo mutuyathu?’” ");
INSERT INTO tgo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Iŋa, ‘Thava, kaiwae mbaŋa ne vou muta nanana raraitharɨ ne hu therɨvairɨthavwi weiye witɨna.’” ");
INSERT INTO tgo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Wo thɨ mbuthu na regha weiye witɨna gheghada mbaŋa witɨna ne i mweghe na ra vughɨ. Ne e mbaŋako iyako ya dage weŋgiya ravathevatheko, ‘Hu mutukaiya nanana raraitharɨ na hu yavathaŋgi, tene ra ŋambuŋgi, ko amba hu mbana witɨna na hu vathe e ghaŋgolona.’” ");
INSERT INTO tgo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas mbowo i utuŋava goghaimba regha weŋgi, iŋa, “Loi le ghamba mbaro ŋgoreiya umbwa regha idae masɨted mbouye, amala regha va i wo na i wokabu ele uma tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbouyeke iyake weiwoke wolaghɨye mbombounji nasiyeninji moli. Ko mbaŋa i mbuthu na laghɨye, i kivwalaŋgiya bigibigiko wolaghɨye e umako tɨne. I tabo na umbwa regha na make wolaghɨye thɨ mena thɨ vakatha unyinji e yaŋgayaŋgako.” ");
INSERT INTO tgo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas mbowo i utuŋava goghaimba regha weŋgi, iŋa, “Loi le ghamba mbaro ŋgoreiya isɨt. Wevo eunda i thɨn mbe nasiye eŋge na i basi weiye pwalawa, uye vwarato, isɨtɨko i kaiwo na i ruvao e pwalawako laghɨye tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas i goghaimba mbaŋa me utuŋa bigibigike wolaghɨye thiyake weŋgiya gharɨgharɨ. Mava te i reŋava e kamwathɨ regha na i utuŋa bigi regha weŋgi mbe goghaimbaeŋge. ");
INSERT INTO tgo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iyake i vaemunjoruŋa ŋgoroŋga Loi ghalɨŋae gharautu va iŋa ne i yomara, iya iŋake: Ne ya utu mbene ya goghaimbaeŋge, mbe goghaimbaeŋge ne ya woraŋgiya weŋgi the bigiya i rothuwele mbaŋa va i vakatha yambaneke na ghaghada noroke. ");
INSERT INTO tgo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas i iteteŋgiya wabwima na i ru e ŋgolo tɨne. Gharaghambu thɨ menawe na thɨŋa, “U vamanjamanjalaŋa weime nanama raraitharɨ i mbuthu e umama tɨne ghagoghaimba.” ");
INSERT INTO tgo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I gonjogha weŋgi iŋa, “Loloko iya i yathu witɨko mbombouye thovuye iye Lolo Nariye. ");
INSERT INTO tgo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Uma iye yambaneke, na weiwo thovuye thiye Loi le ghamba mbaro gharɨgharɨniye. Nana raraitharɨ thiye Seitan le gharɨgharɨŋgi, ");
INSERT INTO tgo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","na loloko iya nuwaiya i vakatha tharɨko, iya i kabu nanako raraitharɨ iye Seitan. Vathe ghambaŋa iye mbaŋa le ghambako, na ravathevathe thiye nyao thovuthovuye.” ");
INSERT INTO tgo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Kaiwae thɨ muta nana raraitharɨ na thɨ ŋambu e ndɨghe, nevole ŋgoreiya iyako mbaŋa ne ele ghambako. ");
INSERT INTO tgo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lolo Nariye ne i variyeŋgiya le nyao thovuthovuye na thɨ mutuyathuŋgiya thavala thɨ vakathaŋgiya gharɨgharɨ vavana na thɨ vakatha tharɨ na thanavu raraitharɨ gharavakathaŋgi. Taulaghɨŋgiko ne thɨ mutuyathuŋgi ele ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ne thɨ bigiyathuruwoŋgi e ndɨghe laghɨye moli une na vethɨ randa na thɨ rɨghɨmbiye ŋiŋinji. ");
INSERT INTO tgo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amba thavala ghanjithanavu i thovuye, manjamanjalawanji ne ŋgoreiya varae manjamanjalawae Ramanji ele ghamba mbaro tɨne. Thoŋgo e yanayanawami hu vandeŋe ghalɨŋaŋguke.” ");
INSERT INTO tgo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Loi le ghamba mbaro ŋgoreiya gogomwau thovuye thɨ wole e uma tɨne na thɨ mareitete. Amala regha i vaidi na mbowo i wolenjoghava. Weiye le warari laghɨye moli gogomwauko iyako kaiwae, amba i wa na ve vakuneŋa le bigibigiko wolaghɨye, i mbana mani na i vamodo umakowe.” ");
INSERT INTO tgo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Loi le ghamba mbaro tembe ŋgoreiyeva iyake. Bigibigi gharakune regha i tamweŋgiya ŋgile thovuye moli. ");
INSERT INTO tgo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mbaŋa regha i vaidiya regha, i thovuye moli na modae i laghɨye moli, amba i wa, ve vakuneŋaŋgiya le bigibigiko wolaghɨye na i vamodo ŋgileko iyako.” ");
INSERT INTO tgo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Loi le ghamba mbaro tembe ŋgoreiyeva ghina thɨ lirawe e njighɨko tɨne, na thɨ wo borogi tomethi. ");
INSERT INTO tgo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mbaŋa i riyevanjara, thɨ momodɨvoreŋa e njighɨko ghadidiye, thiya yaku amba thɨ ghatha. Borogi thovuthovuye thɨ mbanɨŋgi e kwaekwae na raraitharɨ thɨ bigiyathu. ");
INSERT INTO tgo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nevole ŋgoreiyako mbaŋa ne ele ghambako. Nyao thovuthovuye ne thɨ rakamena na thɨ ghatha raŋgiyaŋgiya raraitharɨ thovuthovuyeko e tɨnenji, ");
INSERT INTO tgo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na thɨ bigiyathuruwoŋgi e ndɨghe laghɨye moli une na vethɨ randa na thɨ rɨghɨmbiye ŋiŋinji.” ");
INSERT INTO tgo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas i vaitoŋgi, iŋa “Thare nuwami i manjamanjala bigibigike thiyake kaiwanji?” Thɨŋa, “Ŋgoreiye.” ");
INSERT INTO tgo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","I dage weŋgi, iŋa “Iya kaiwae mbaro gharavavaghare, iya thiye kaero thɨ tabo na Loi le ghamba mbaro gharaghambuŋgi, thiye ŋgoranjiya ŋgolo tanuwagae i bigiraŋgiya bigibigi totogha na teteuye ele woluwolu tɨne na i bigirawe eto.” ");
INSERT INTO tgo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mbaŋa Jisas i utuvaoŋgiya goghaimbaŋgike thiyake amba i iteta ghembako iyako. ");
INSERT INTO tgo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","I njogha e ghambae na i vavaghare e lenji ŋgolo kururu tɨne. Gharenji i yo le vavaghareko kaiwae na thɨŋa, “Le ghareghareko aŋga i mena? Ŋgoroŋga na valɨkaiwae i vakatha vakathaŋgike ghamba rotaele thiyake?” ");
INSERT INTO tgo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Mbema kapentama nariya iyako, ae? Tɨnaya Meri, ae? Oghaghaeŋgiya Jemes, Josep, Saimon na Judas. ");
INSERT INTO tgo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Oloulouye mbe ra yaku gheke weindaŋgi, ŋgoreiye ae? Aŋga mendava i wo le ghareghareko na le vurɨghegheko?” ");
INSERT INTO tgo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iya kaiwae gharenji i gaithɨwana na thɨ botewoyathu. Jisas i dage weŋgi, iŋa “Gharɨgharɨ thɨ yavwatatawana Loi ghalɨŋae gharautu e ghembaghembako wolaghɨye, ko ghambae gharɨgharɨniye na le bodaboda ma thɨ yavwatatawana.” ");
INSERT INTO tgo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma i vakatha vakatha ghamba rotaele lemoyo gheko kaiwae ma thɨ loŋweghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E mbaŋako iyako, Herod, iye Galili gharambarombaro i loŋweya Jisas le vakatha utuutuniye. ");
INSERT INTO tgo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","I dage weŋgiya le rakakaiwo e raberabe iŋa, “Loloko iyako mbema emunjoru Jon Rabapɨtaiso, i thuweiru na tembe e yawayawaliyeva. Iya kaiwae valɨkaiwae i vakathaŋgiya vakatha ghamba rotaele ŋgoranjiyako.” ");
INSERT INTO tgo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kaiwae Herod va i viwe ghagha Pilip levo Herodiyas na i ghe weiye, Jon vambe i vathivalaŋa wevara, iŋa, “Ghanda Mbaro ma i vatomwe e ghen na u vaŋgwa Herodiyas!” Iyako kaiwae, Herod va iŋa na thɨ yalawe Jon, thɨ ŋgarɨ na thɨ woruwo e thiyo. ");
INSERT INTO tgo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod va nuwaiya iŋa na Jon i mare, ko va i mararuŋgiya Jiu kaiwae va thɨŋa Jon iye Loi ghalɨŋae gharautu. ");
INSERT INTO tgo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mbaŋa Herod i vakatha le virɨ gharenuwaŋakiki ghanɨŋganiye, Herodiyas yawarumbuye i thari wabwiko e maranji, i vakatha Herod i warari laghɨye, ");
INSERT INTO tgo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","na i tholo e maranji iŋa, “Ya dagerawe e maran, the bigiya ne u naŋgo e ghino ne ya woveŋge.” ");
INSERT INTO tgo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ŋgoreiya tɨnae me le woraŋgiyawe, i dage weya Herod iŋa, “E mbaŋake iyake u woraweya Jon Rabapɨtaiso umbaliye e gaeba tɨne na u woveŋgoma.” ");
INSERT INTO tgo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kiŋɨma nuwae i tharɨ, ko kaiwae kaero me tholo na i dagerawe le valɨgiyagiyako e maranji, iŋa na thɨ vakatha ŋgoreiya wevoko le renuwaŋa. ");
INSERT INTO tgo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","I variyeŋgiya le rakakaiwo na vethɨ kitena Jon numwe e thiyo tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Thɨ thɨnɨmena umbaliye e gaeba na thɨ thɨnɨgiya weya wevoma na i yothɨn weya tɨnae. ");
INSERT INTO tgo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jon gharaghambu thɨ rakamena thɨ wo Jon riwae na thɨ wobeku; amba thɨ wa vethɨ utugiya utuniye weya Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mbaŋa Jisas i loŋweya Jon utuutuniye, i tha e waŋga ghamberegha na i iteta ghembako iyako, i wa e valɨvaŋga ma gharɨgharɨniye. Gharɨgharɨ thɨ loŋweya toto Jisas kaero me wa, thɨ rakaiteteŋgiya ghambaghambanji, thɨ loŋga e gheghenji na thɨ rakareghambawe. ");
INSERT INTO tgo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas i nja e waŋgama na mbaŋa i thuweya wabwiko laghɨye, ghare i vɨrɨ laghɨye moli kaiwanji na i thawariŋgiya lenji ghambweghambweraŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mbaŋa vama yeghɨyeghɨye, gharaghambu thɨ rakamenawe na thɨ dagewe, thɨŋa, “Vanatherowoke, na kaero yeghɨyeghɨye moli. U variyeŋgiya gharɨgharɨna na tembe thiye vethɨ vamodo ghanji e ghembaghemba.” ");
INSERT INTO tgo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisas iŋa, “Thava thɨ raka. Ghemi hu giya ghanɨŋga weŋgi na thɨ ghan.” ");
INSERT INTO tgo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Thɨ dagewe, thɨŋa, “Bredɨma mbe mbumbulima eŋge na borogi umboiwo ina weime.” ");
INSERT INTO tgo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iŋa, “Hu bigimena gheke.” ");
INSERT INTO tgo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","I dage weŋgiya gharɨgharɨko na thiya yaku e nanako vwatavwata, amba i mbana bredɨma mbumbulimama na borogima umboiwo, i ghɨmara voro e buruburu na i vata ago weya Loi ghanɨŋgako kaiwae. I njiviyaviya bredɨma, i giya weŋgiya gharaghambuma na thɨ giya weŋgiya gharɨgharɨma. ");
INSERT INTO tgo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Taulaghɨko thiya ghanɨŋga na valɨkaiwanji. Amba gharaghambuko thɨ mbana ghanɨŋgama vaŋgovaŋgothiye na thɨ mbanɨvanjaraŋgiya nambonambo ŋgamwayaworo na ŋgamwaiwo. ");
INSERT INTO tgo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iya vara taulaghɨko va thiya ghanɨŋgako ghɨmoghɨmoru lenji ghanaghanagha paeb tausan na wanakau na gamagai e vwatanjiva. ");
INSERT INTO tgo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Amba Jisas i dage weŋgiya gharaghambu na thɨ rakatha e waŋgama thɨ viva e ghamwae Galili Njighɨniye ele valɨvaŋga regha, na i variyeŋgiya gharɨgharɨ thɨ rakanjogha e ghambanji. ");
INSERT INTO tgo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","I variyeŋgiya gharɨgharɨ na e ghereiye ghamberegha i voro e ou ghadidiye na i naŋgowe. Vama i gou na Jisas ina gheko ghamberegha; ");
INSERT INTO tgo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na e mbaŋako iyako waŋgama vama ina eto na bagodu i vauneuneŋa kaiwae thɨ womana i ghemba ndewendeweko marae. ");
INSERT INTO tgo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ighɨviya rakaraka Jisas i loŋga e njighɨ vwatae i mena weŋgiya gharaghambu. ");
INSERT INTO tgo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mbaŋa thɨ thuweya i loŋga e njighɨko vwatae thɨ mararu laghɨye moli. Thɨŋava, “Kaka!” na thɨ yaro weiye lenji mararu laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisas i dage weŋgi e mbaŋako iyako, iŋa, “Tha huya mararu! Ghino! Ghino!” ");
INSERT INTO tgo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Amba Pita i dagewe, iŋa, “Amalana, thoŋgo emunjoru ghen, u dage na ya nja ya loŋga ghaona e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisas i gonjoghawe, iŋa, “U mena!” Pita i ghaenja na i loŋga ghemba Jisas e njighɨko vwatae. ");
INSERT INTO tgo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ko mbaŋa i thuweya ndewendeweko le vurɨgheghe i mararu na mbalama i munja amba i goyawaru, iŋa, “Amalana! U thalavuŋgo!” ");
INSERT INTO tgo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","E mbaŋako iyako Jisas i tagavamomoya nɨmanɨmae i yalawe, i vikiki amba i dagewe, iŋa, “Len loŋweghathɨ i nasiye. Buda kaiwae mo numoghegheiwo?” ");
INSERT INTO tgo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Vambe thenjighewoko vara thɨ vana e waŋgama na ndewendewema i mare. ");
INSERT INTO tgo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Amba gharaghambuko e waŋgako thɨ kururu weya Jisas na thɨŋa, “Mbema emunjoru Loi Nariya ghen!” ");
INSERT INTO tgo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Thɨ golawa Galili Njighɨniye e ghereiye na thɨ mena thɨ goru Genesaret. ");
INSERT INTO tgo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gharɨgharɨ thɨ thuwe na thɨ ghareghare amalaghɨniye Jisas, amba thɨ variya toto e ghembaghemba e valɨvaŋgako iyako na thɨ bigimenaŋgiya ghambweghambwera. ");
INSERT INTO tgo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Thɨ naŋgowe na thoŋgo i vatomwe, ghambweghambwerako ma thɨ vɨghathɨ eŋge ghakwamako mbothiye, na taulaghɨko iyava thɨ vɨghathɨko riwanji i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisi na mbaro gharavavaghare vavana thɨ ri Jerusalem, thɨ wa weya Jisas na thɨ vaito, thɨŋa ");
INSERT INTO tgo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Buda kaiwae ghanɨraghambuke ma thɨ ghambugha budakaiya orumburumbunda va thɨ valawe weinda? Kaiwae mbaŋa thɨ ghanɨŋga ma thɨ thavwiya nɨmanɨmanji, ŋgoreiya la kururu le woraŋgiya weinda.” ");
INSERT INTO tgo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas i gonjogha weŋgi iŋa, “Na ghemi buda kaiwae ma hu ghambugha budakaiya Loi va i dage weinda na ra vakatha ŋgoreiye, ko mbe hu ghambu eŋge mbe ghemi ghamithanavu? ");
INSERT INTO tgo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaiwae Loi iŋa, ‘Mbe hu yavwatata wanaŋgiya rama na tɨna.’ Na tembe iŋava, ‘Thela i utuvatharɨ ramae na tɨnae weŋgi, thɨ tagavamare.’ ");
INSERT INTO tgo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ko iyemaeŋge ghemi lemi vavaghare ŋgoreiyake: huŋa thoŋgo lolo le bigibigi lemoyo valɨkaiwae i thalavuŋgiya tɨnae na ramae, ko mbe i thovuye eŋge thoŋgo ma i giya weŋgi na ma i yavwatata wanaŋgi. Na tembe huŋava valɨkaiwae ne i dage weŋgi na iŋa, ‘Bigibigi mendava ya bigirawe kaiwami, kaero mendava ya dagerawe Loi kaiwae, mane ya giya weŋga.’ ");
INSERT INTO tgo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hu utu ŋgoreiyako kaero hu kivwala Loi le mbaro na mbe hu goruweŋge lemi vavagharena iya i mena weŋgiya o rumburumbumina. ");
INSERT INTO tgo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Taukwana ghemi! Aiseya, Loi ghalɨŋae gharautu, va i utuŋa emunjoru, ghemi utunimi: ");
INSERT INTO tgo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Loi iŋa, Gharɨgharɨke thiyake e ghaenjike njimwae thɨ yavwatata wanaŋgo, ko gharenjiko i bwagabwaga moli e ghino. ");
INSERT INTO tgo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lenji kururu weŋgo ŋgoreiya bigi bwabwaga, thɨ vavaghareŋa gharɨgharɨ lenji renuwaŋa na thɨŋava Loi le mbaro.” ");
INSERT INTO tgo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas i kula vathavathaŋgiya gharɨgharɨ na i dage weŋgi, iŋa, “Hu vandeŋeŋgo na nuwamina i rumwaru. ");
INSERT INTO tgo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Budakai i ru e ghaendake ma i vambɨghɨyainda, ko budakai i raŋgima e ghaendake, iyake i vambɨghɨyainda.” ");
INSERT INTO tgo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Gharaghambu thɨ menawe na thɨŋa, “Thare u ghareghare, Parisi gharenji me gaithɨ len utuna kaiwae?” ");
INSERT INTO tgo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisas i gonjogha weŋgi iŋa, “Bigibigike wolaghɨye iya Bwebwe e buruburu ma va i kabuŋgi ne thɨ mutuyathuŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tha hu rerenuwaŋa kaiwanji! Thiye ŋgoranjiya gharɨgharɨ maranji i kwaghe na thɨ mando na thɨ viva weŋgiya ghanjiune vavana. Thoŋgo lolo regha marae i kwaghe i viva weya tembe marae i kwagheva, mbene thenjighewoko vara thɨ dobu e goga.” ");
INSERT INTO tgo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita i dagewe, iŋa, “U vamanjamanjalaŋa goghaimbake iyake weime.” ");
INSERT INTO tgo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisas i dage weŋgi, iŋa, “Ko woraghambuke ghemi nuwami mbe ma i manjamanjalava? ");
INSERT INTO tgo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma hu ghareghare? Budakai i ru e ghaendake i nja e ŋgamoinda na ve raŋgi ele kamwathɨ. ");
INSERT INTO tgo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ko budakai i raŋgima e ghaendake i mena e gharenda. Iyake i vambɨghɨyainda. ");
INSERT INTO tgo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kaiwae i raŋgima e gharenda ŋgoranji: renuwaŋa raraitharɨ, gabo, yathima, dubwara, kaivɨ, utu kwanɨkwan na ra liya ghandau ghautu. ");
INSERT INTO tgo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Thiyake thɨ vambɨghɨyainda, ko ma ra thavwiya nɨmanda na ra ghanɨŋga ma i vambɨghɨyainda.” ");
INSERT INTO tgo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas i iteta ghembako iyako na i wa Taiya na Saidon e lenji valɨvaŋga. ");
INSERT INTO tgo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kenani wevoniye eunda, i yaku e valɨvaŋgako iyako, i mena weya Jisas. I kulakula, iŋa, “Amalana, Deivid Rumbuye, gharen i njaweŋgo! Nyao raitharɨ ina weya yawarumbuŋguno, i vakatha na i vɨrɨ laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ko Jisas ma va i ndegonjogha mun. Gharaghambu thɨ mena evasiwae na thɨ naŋgo vurɨgheghewe, thɨŋa, “U variyeyathu wevoko, kaiwae i kulakula reghamba weinda.” ");
INSERT INTO tgo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisas iŋa, “Loi va i variyeŋgo mbe wabwi Isirel eŋge kaiwanji. Thiye ŋgoranjiya sip ma e ghanjiranjimbunjimbu.” ");
INSERT INTO tgo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Elako i mena i ronja e gheghe vuvuye e ghamwae na iŋa, “Amalana, u thalavuŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","I gonjoghawe, iŋa, “Ma valɨkaiwae ra wo gamagai ghanji na ra wokiyathu weŋgiya mbughambugha. Mbwata ma valɨkaiwae ya thalavuŋge.” ");
INSERT INTO tgo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Elama iŋa, “Ŋgoreiye amalana. Ko iyemaeŋge mbughambugha thɨ ghana ghanɨŋga murimuriye thɨ dobu tanuwaganji ele ghamba ghanɨŋga raberabe. Iya kaiwae valɨkaiwae u thalavuŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Amba Jisas iŋa, “Elana, len loŋweghathɨna i laghɨye. Kaero ŋgoreiya len renuwaŋana.” E mbaŋako iyako yawarumbuyema riwae i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas i iteta ghembako iyako na i ŋgalai Galili Njighɨniye ghadidiye. I voro e ou vwatae na i yaku. ");
INSERT INTO tgo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wabwi laghɨye thɨ rakamenawe, thɨ bigimenaŋgiya ghambweghambwera, thiye thɨ kuvokuvo, maranji i kwaghe, ghenji na nɨmanji i tharɨ, thiye ma e ghalɨghalɨŋanji na vavanava. Thɨ bigiraweŋgi Jisas e ghamwae na i thawariŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gharɨgharɨma gharenji i yo laghɨye kaiwae thɨ thuweya ghalɨŋanjima i tharɨ kaero thɨ utu, ghenji na nɨmanji i tharɨ riwanji i thovuye, kuvokuvo thɨ loŋga wagiyawe na maranji i kwaghe kaero thɨ thuwe. Iya kaiwae thɨ taraweŋa Isirel lenji Loi. ");
INSERT INTO tgo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas i kula vathaŋgiya gharaghambu, amba iŋa, “Ghareŋgu i vɨrɨ gharɨgharɨke thiyake kaiwanji, kaiwae mbaŋa mbaŋato kaero ra yaku weindaŋgi na kaero ma e ghanji. Ma nuwaŋguiya ya variyenjoghaŋgi mbe ŋgamoŋgamoinji eŋge, ne iwaeŋge ghare thavwathavwavo i nja weŋgi e kamwathɨ mborowa.” ");
INSERT INTO tgo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gharaghambu thɨ vaito thɨŋa, “Vanatherowoke; aŋgane ra vaidiya ghanɨŋga i ghanagha na ra vaghanɨŋgiya wabwike laghɨye?” ");
INSERT INTO tgo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisas i vaitoŋgi, iŋa, “Bred mbumbuviye na weŋga?” Thɨŋa, “Mbumbupirɨ na borogi nanasiye umboviye.” ");
INSERT INTO tgo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","I dage weŋgiya wabwima na thiya yaku e thelauko vwatae, ");
INSERT INTO tgo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","amba i mbana bredɨma mbumbupirɨma na borogima, i vata ago weya Loi, i njiviyaviya na i giya weŋgiya gharaghambuma na thiye thɨ giya weŋgiya wabwima. ");
INSERT INTO tgo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Taulaghɨko thiya ghanɨŋga na valɨkaiwanji. Amba gharaghambuko thɨ mbanɨŋgiya methɨ ghanɨvareŋgima na thɨ mban vanjaraŋgiya nambonambo ŋgamwapirɨ. ");
INSERT INTO tgo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","E ghanɨŋgako iyako tɨne ghɨmoghɨmoru lenji ghanaghanagha po tausan, ko wanakau na gamagai ma va thɨ vaonaŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Amba Jisas i variyeŋgi na thɨ raka. Amalaghɨniye i tha e waŋga na i wa Magadan ele valɨvaŋga. ");
INSERT INTO tgo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi na Sadusi vavana thɨ mena weya Jisas na nuwanjiya thɨ mando. Amba thɨ dagewe thɨŋa, “Wo u vakatha vakatha ghamba rotaele regha na mbala i vaemunjoruŋa emunjoru Loi le vurɨgheghe ina e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jisas i gonjogha weŋgi iŋa, “Mbaŋa varaeko ve ronja, kaero huŋa, ‘Evole mara thovuye kaiwae buruburuko i soro,’ ");
INSERT INTO tgo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","na mbaŋambaŋa moli huŋa, ‘Noroke i uye kaiwae buruburuko i soro na i bwedi.’ Valɨkaiwae mbema hu thuweŋge buruburuko ghayamoyamo kaero hu ghareghare budakai ne i yomara, ko iyemaeŋge ma valɨkaiwami hu vamanjamanjalaŋa budakai thɨ yoyomara e mbaŋake iyake. ");
INSERT INTO tgo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ghemi thake iyake raraitharɨ ghemi, na hu roiteta Loi ghathanavu. Nuwamiya ya vakatha nono ghamba rotaele kaiwami. Ko mane ya vakatha nono regha kaiwami. Nono ghamba rotaele mbe iyaeŋge Loi ne i giya weŋga, iyava i vakatha weya Jona.” Jisas i iteteŋaŋgi na i wa. ");
INSERT INTO tgo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Vama inanji valɨmbwa, ko gharaghambu va thɨ renuwaŋa vaghalawe, ma va thɨ bigiya bred. ");
INSERT INTO tgo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas i dage weŋgi iŋa, “Hu njimbukiki wagiyawe! Hu njimbukiki wagiyaweŋga Parisi na Sadusi lenji isɨt kaiwae.” ");
INSERT INTO tgo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gharaghambu thɨ veutu weŋgi, thɨŋa, “Meŋa ŋgoraiyako kaiwae ma mara ndewo mun bred.” ");
INSERT INTO tgo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas vama i ghareghareya lenji utuko amba i dage weŋgi, iŋa, “Lemi loŋweghathɨna ma i laghɨye! Buda kaiwae hu veutu weŋga bred kaiwae? ");
INSERT INTO tgo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ko nuwamina mamba i rumwaru? Thare hu renuwaŋakiki bredɨma mbumbulima, va ya njiviyaviya na ghɨmoghɨmoru paeb tausan thɨ ghan, na thɨ ghanɨvareŋgi e nambonambo ŋgamwaviye hu mbanɨvanjaraŋgi? ");
INSERT INTO tgo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na thare hu renuwaŋakikiya bredɨma mbumbupirɨma, va ya njiviyaviya na po tausan ghɨmoghɨmoru thɨ ghan, na thɨ ghanɨvareŋgi e nambonambo ŋgamwaviye hu mbanɨvanjaraŋgi? ");
INSERT INTO tgo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ŋgoroŋgaeŋge na ma nuwamina i rumwaruŋa, ghino ma, ma utuutu weŋga bred kaiwae? Hu njimbukikiŋga Parisi na Sadusi lenji isɨt kaiwae!” ");
INSERT INTO tgo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gharaghambu ambama nuwanji i rumwaru Jisas ma iŋa thɨ njimbukikiŋgi bred ghaisɨt kaiwae, ko iŋa eŋge thɨ njimbukikiŋgi Parisi na Sadusi lenji vavaghare kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mbaŋa Jisas i wa Sisariya Pilipai ele valɨvaŋga amba i dage weŋgiya gharaghambu iŋa, “Gharɨgharɨ thɨŋa thela Lolo Nariye?” ");
INSERT INTO tgo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Thɨ gonjoghawe, thɨŋa, “Vavana thɨŋa Jon Rabapɨtaiso, vavana thɨŋa Ilaija, na vavana thɨŋa Jeremaiya o Loi ghalɨŋae gharautu regha.” ");
INSERT INTO tgo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I vaitoŋgi, iŋa, “Ko naka ghemi? Huŋa thela ghino?” ");
INSERT INTO tgo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita i gonjoghawe iŋa, “Ghen Krais ghen, Loi e yawayawaliye Nariye.” ");
INSERT INTO tgo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisas iŋa, “Loi i mwaewo weŋge, Saimon Jona nariye! Kaiwae renuwaŋana iyana ma i mena weya rameyambaneke regha, Bwebwe e buruburu i woveŋge. ");
INSERT INTO tgo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya dage weŋge, ghen Pita, na e varɨke iyake vwatae ya vatada lo ekelesiya wabwi na Seitan le wabwi ma e lenji vurɨgheghe na ne thɨ kivwala. ");
INSERT INTO tgo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ya thɨnɨgiya Loi le ghamba mbaro gheki e ghen na e len vurɨgheghe. The vakatha ne u dageten e yambaneke Loi ne i dageten e buruburu, na the vakatha ne u vatomwe e yambaneke Loi ne i vatomwe e buruburu.” ");
INSERT INTO tgo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Amba i dage vavurɨgheghe weŋgiya gharaghambu na thava thɨ utugiya weya lolo regha na thɨŋa iye Krais. ");
INSERT INTO tgo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","E mbaŋako iyako Jisas i utukai vara weŋgiya gharaghambu iŋa, “Wo ya wa Jerusalem na randeviva, ravowovowo laghɨlaghɨye na mbaro gharavavaghare thɨ vakatha vuyowo laghɨye e ghino. Ne thɨ vakathaŋgo na ya mare na mbaŋa theghetoninji e tɨne kaero ya thuweiruva.” ");
INSERT INTO tgo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita i vaŋgwa Jisas na mbe thiye eŋge amba i dagewe iŋa, “Amalana, Loi thava i vatomwe na ŋgoreiye! Bigike iyake thava ne i yomara e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas i ndevaghɨle na i dage weya Pita, iŋa, “U mena e ghereiŋguke, Seitan! Ghen ŋgorana ghamba thalatɨva e ghino, len renuwaŋana ma i reŋa Loi ele renuwaŋa, i reŋa gharɨgharɨ e lenji renuwaŋa.” ");
INSERT INTO tgo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Amba Jisas i dage weŋgiya gharaghambu, iŋa, “Thoŋgo thela nuwaiya i ghambuŋgo, tembe ghamberegha i botewo iya nuwaeko nuwaiya i vakatha na i wovaira ghakros na i wo na i ghambuŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iya kaiwae thela tembe ghamberegha nuwaiya i vamora yawaliye, ne i thɨvaghawa yawaliye, na thela ne i thɨvaghawa yawaliye ghino kaiwaŋgu ne i vaidiya yawalɨ memeghabananiye. ");
INSERT INTO tgo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ŋgoroŋga ghathovuye thoŋgo lolo regha i wo yambaneke laghɨye na i mbaroŋa, ko iyemaeŋge i thɨvaiya yawalɨ memeghabananiye? Ne i wo budakai na i vamodanjogha yawaliyekowe? ");
INSERT INTO tgo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kaiwae Lolo Nariye ne i mena weiye Ramae le vurɨgheghe, weiyaŋgiya le Nyao Thovuthovuye, na i vamodo lolo regha na regha ŋgoreiya le kaiwo. ");
INSERT INTO tgo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya dage emunjoru e ghemi, gharɨgharɨ vavana inanji gheke thiye wo ne thɨ thuweya Lolo Nariye i mena weiye le mbaro e yambaneke amba muyai thɨ mare.” ");
INSERT INTO tgo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mbaŋa theghewona e ghereiye Jisas i vaŋguŋgiya Pita, Jemes na ghaghae Jon, i viva weŋgi na thɨ voro e ou molao regha mbe thiye eŋge vara. ");
INSERT INTO tgo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","E maranji Jisas ghayamoyamo i ghenevaghɨle, ghamwae i ndalandala ŋgoreiye varae mara mbouye na ghakwama kakaleva na marambwelambwelawae. ");
INSERT INTO tgo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Amba Mosese na Ilaija thɨ yomara na thɨ thuweŋgi e maranji thɨ utu weinji Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita i dagewe Jisas, iŋa, “Amalana, i thovuye inanda gheke! Thoŋgo nuwaniya ne ya vatada yoŋathowathowa ŋgoloto gheke, ŋgolora ghen, ŋgolora Mosese, na ŋgolora Ilaija.” ");
INSERT INTO tgo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mbaŋa i utuutu ŋgalɨlɨ marambwelambwelawae i ghavo tomuŋgi na Loi i dage e ŋgalɨlɨko, iŋa, “Iyake Naruŋgu valɨghareghareŋgu, i vakathaŋgo ya warari laghɨye moli. Hu vandeŋe wagiyawe!” ");
INSERT INTO tgo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mbaŋa gharaghambuko thenjighetoko thɨ loŋweya ghalɨghalɨŋako thɨ mararu laghɨye moli, thɨ dobu na ghamwanji i nja e thelauko vwatae. ");
INSERT INTO tgo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas i mena weŋgi i vɨghathɨŋgi na iŋa, “Hu thuweiru, tha hu mararu!” ");
INSERT INTO tgo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Thɨ ghɨmara voro na ma thɨ vaidi eŋge Jisas ghamberegha. ");
INSERT INTO tgo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jisas na gharaghambuma thenjighetoma thɨ njama e ouko, i dage vurɨgheghe weŋgi, iŋa, “Mbala hu ravunyivunyiya bigiko mohu thuwe e ouko vwatae. Ne hu utuŋa weŋgiya gharɨgharɨ thembaŋa Lolo Nariye ne le mare na le thuweiru e ghereiye.” ");
INSERT INTO tgo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Amba gharaghambu thɨ vaito thɨŋa, “Buda kaiwae mbaro gharavavaghareŋgi thɨŋava Ilaija ne i menakai amba muyai Mesaiya i mena?” ");
INSERT INTO tgo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisas i gonjogha weŋgi iŋa, “Emunjoru Ilaija ne i menakai na i vanamwe bigibigike wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ko iyemaeŋge, ya dage e ghemi, Ilaija kaero mendava i mena na mava thɨ ghareghare thela amalaghɨniye, ko va thɨ vakatha thambo renuwaŋa nuwanjiya thɨ vakathawe. Tembene thɨ vakathava vɨrɨ ŋgoreiyako e ghino, Lolo Nariye.” ");
INSERT INTO tgo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Amba gharaghambu nuwanji i manjamanjala na thɨŋa, “Ko ana me utuuta Jon Rabapɨtaiso utuniye iya meŋake, ‘Ilaija kaero mendava i mena.’” ");
INSERT INTO tgo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mbaŋa thɨ njogha weŋgiya wabwima laghɨye, amba amala regha i mena weya Jisas, i ronja e ghe vuvuye e ghamwae ");
INSERT INTO tgo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na iŋa, “Amalana, u gharevɨrɨ naruŋguko kaiwae, kaiwae umbaliye e ghagida na mbaŋa i ghanagha maramara thɨ ndeghathɨ na i dobu e ndɨghe une o e mbwa tɨne na i vɨrɨ laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma vaŋgumena weŋgiya ghanɨraghambuke, ko ma valɨkaiwanji methɨ thawari.” ");
INSERT INTO tgo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas iŋa, “Ghemi thake iyake ma e lemi loŋweghathɨ na ghamithanavu raraitharɨ. Ŋgoroŋga mbaŋa le molamolao ne ya yaku weiŋguyaŋgiya ghemi? Ŋgoroŋga mbaŋa le molamolao ne ya ghataŋaghathɨŋga? Hu vaŋgumena weŋgo!” ");
INSERT INTO tgo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisas i dage vurɨgheghe weya nyaoma raitharɨ na i raŋgi weya theghama, na e mbaŋako iyako riwae i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Amba gharaghambu mbe thɨye eŋge thɨ menawe na thɨ vaito thɨŋa, “Buda kaiwae ghime ma me valɨkaiwame wo dagewe nyaoko raitharɨ na i raŋgi?” ");
INSERT INTO tgo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jisas i gonjogha weŋgi iŋa, “Kaiwae lemi loŋweghathɨna ma i laghɨye. Ya dage emunjoru weŋga, thoŋgo e lemi loŋweghathɨ, othembe nasiye moli ŋgoreiya umbwama masɨtedɨma mbouye, valɨkaiwami hu dage weya ouke iyake, ‘U roiteta ghambana u wa gheko,’ ne i vakatha ŋgoreiye. Thoŋgo e lemi loŋweghathɨ ma bigi regha ne i vuyowo weŋga. ");
INSERT INTO tgo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ko nyao raitharɨ ŋgorako mane i raŋgi bwaga, mbene ra naŋgo na ra ghataŋaghathɨgha bada naŋgoko kaiwae ambane ŋgoreiye.” ");
INSERT INTO tgo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mbaŋa gharaghambu thɨ mevathavatha Galili amba Jisas i dage weŋgi, iŋa, “Mbaŋa nasiye thɨ vaŋguraweya Lolo Nariye gharɨgharɨ e nɨmanji, ");
INSERT INTO tgo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na thɨ tagavamare, ko mbaŋa theghetoniye e tɨne kaero i thuweiruva.” Gharaghambu va thɨ loŋweya iyako nuwanji i tharɨ laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mbaŋa vama thɨ mena Kapenaom, Ŋgolo Boboma ghatakis gharamban thɨ mena thɨ vaito Pita, “Lemi Ravavagharena thare i vamodo takis Ŋgolo Boboma kaiwae?” ");
INSERT INTO tgo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita iŋa, “Ŋgoreiye.” Mbaŋa Pita ve ru e ŋgolo tɨne, Jisas i dagekaiwe iŋa, “Saimon, ŋgoroŋga len renuwaŋa? Mbaŋa yambaneke ghakiŋ thɨ mbana takis, ŋgoroŋga thɨ mban weŋgiya onanarinji o gharɨgharɨ ma lenji bodaboda weŋgi?” ");
INSERT INTO tgo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita iŋa, “Gharɨgharɨ ma lenji bodaboda weŋgi.” Jisas iŋa, “Onanarinji mane thɨ vamodo takis. Tembe ŋgoreiyeva, ghino mbala mbe ma ya vamodova Bwebwe le ŋgolo ghatakis. ");
INSERT INTO tgo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ko ma nuwandaiya ra vakatha Ŋgolo Boboma ghatakis gharamban na gharenji i gaithɨ weinda, ma u wa eŋge e njighɨ na vo liyathu len thiyo. The borogiya u kosikai vara, u wo na u tate ghaena na u vaidiya mani, i ghanagha na ne valɨkaiwae ghen na ghino la takis Ŋgolo Boboma kaiwae. U mban na vo vamodowe.” ");
INSERT INTO tgo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Va e mbaŋako iyako Jisas gharaghambu thɨ menawe na thɨ vaito thɨŋa, “Thela idae i laghɨye Loi ele ghamba mbaro tɨne?” ");
INSERT INTO tgo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","I kula weya ŋgama nasiye regha na i ndeghathɨ gharaghambu e tɨnenji, ");
INSERT INTO tgo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","amba iŋa, “Ya dage emunjoru e ghemi, thoŋgo ma hu vɨva ghamithanavu na ŋgoramiya ŋgama nasiye, mane vohu ru Loi ele ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Thela thoŋgo ghathanavu i ghenenja ŋgoreiya ŋgamake iyake, iye idae i laghɨye Loi ele ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na thela thoŋgo i kulavatha ŋgama regha ŋgora iyake e idaŋgu, ŋgoreiya i kulavathaŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Thoŋgo ra wo varɨ laghɨye na ra ŋgara loloko iyako e numwe na ra wokiyathu e ŋambuwoko tɨne, lithɨko iyako i laghɨye. Ko iyemaeŋge Loi ne i giya lolo regha ghalithɨ i laghɨye moli thoŋgo i vakatha ŋgama ŋgoreiyake regha i vakatha tharɨ na ma i loŋweghathɨŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","O, yambane! Yambaneke i tharɨ kaiwae bigibigi lemoyo inanji e yambaneke i vakathaŋgiya gharɨgharɨ thɨ vakatha tharɨ. Emunjoru bigibigike thiyake thɨ yoyomara, ko loloko iya i vakathaŋgi na thɨ yoyomarako Loi ne i lithɨwe laghɨye moli.” ");
INSERT INTO tgo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Thoŋgo gheghenɨna o nɨmanɨna i vakathaŋge na u vakatha tharɨ, u kitenɨyathu. I thovuye eŋge thoŋgo ma e gheghen na nɨmanɨman na u vaidiya yawalɨ memeghabananiye. Thava nɨmanɨmanɨna theghewona na gheghenɨna theghewona thɨ wokiyathuruwoŋge e ndɨgheko iya i meghabanako e tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na thoŋgo maranɨna regha i vakathaŋge na u vakatha tharɨ, u vovavuthuyathu na u wokiyathu. I thovuye moli maran mbe voghɨra eŋge na u vaidiya yawalɨ memeghabananiye, na thava maramaranɨna voghɨwona thɨ wokiyathuruwoŋge Gehena, iya ndɨghe memeghabananiye e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hu njimbukikiŋga, tha hu njimbunjoŋanjoŋaŋgiya gamagai ŋgoreiye reghake iyake. Ya dage e ghemi lenji nyao thovuthovuye e buruburu, mbaŋake wolaghɨye thiya yaku Bwebwe e ghamwae e buruburu. ");
INSERT INTO tgo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Lolo Nariya Ghino ya mena ya vamoruŋgiya gharɨgharɨ thiya ghawe.” ");
INSERT INTO tgo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ŋgoroŋga lemi renuwaŋa? Thoŋgo lolo regha ele sip hothaŋarɨ na regha i ghawe, ne i vakatha budakai? Ne i iteteŋgiya iyesiwo na umbosiwo e ou vwatae na i wa ve tamweya iya me ghaweko. ");
INSERT INTO tgo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya dage emunjoru e ghemi, mbaŋa ne i vaidi, le warari i laghɨye moli i kivwala le warari iyesiwo na umbosiwo kaiwanji iya ma thɨ ghaweko. ");
INSERT INTO tgo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tembe ŋgoreiyeva Ramami e buruburu ma le renuwaŋa ŋgoreiya nanasiyeke ŋgoranjiyake regha i ghawe.” ");
INSERT INTO tgo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Thoŋgo ghagha i vakatha thanavu raitharɨ e ghen, u wawe na mbe themighewona eŋge, na u woraŋgiya le tharɨna. Thoŋgo i wovatha len utuna, kaero ghamwami vanaorava wein. ");
INSERT INTO tgo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ko thoŋgo ma i wovatha ghalɨŋana, u vaŋgwa lolo reghava o theghewo, weinaŋgi, mbala the bigibigi u woraŋgiyawe themighewoko o themigheto hu vaemunjoruŋa, iyake ŋgoreiya Mosese le Mbaro i woraŋgiya weinda. ");
INSERT INTO tgo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Thoŋgo ma i goru weya ghalɨŋanji, u wa vo woraŋgiya weŋgiya ekelesiya, na thoŋgo ma i wovatha ekelesiya lenji renuwaŋa, hu vakathawe ŋgoreiya iye lolo raitharɨ o takis gharamban regha.” ");
INSERT INTO tgo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ya dage emunjoru e ghemi, the vakatha ne hu dageten e yambaneke Loi ne i dageten e buruburu, na the vakatha ne hu vatomwe e yambaneke Loi ne i vatomwe e buruburu.” ");
INSERT INTO tgo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mbowo ya dageva e ghemi, e yambaneke thoŋgo themighewo lemi renuwaŋa regha na hu naŋgo bigi regha kaiwae, Bwebwe e buruburu ne i vakatha kaiwami. ");
INSERT INTO tgo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kaiwae thoŋgo themighewo o themigheto hu mevathavatha e idaŋgu, ghino mbe inaŋguwe.” ");
INSERT INTO tgo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Amba Pita i mena weya Jisas na i vaito iŋa, “Amalana, thoŋgo ghaghaŋgu i vakatha tharɨ e ghino, mbaŋaviye ne ya nuwoyathu le tharɨko? Mbe mbaŋapirɨ eŋge?” ");
INSERT INTO tgo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas i gonjoghawe iŋa, “Thava mbe mbaŋapirɨ eŋge, mbaŋathaŋarɨ na mbaŋake wolaghɨye.” ");
INSERT INTO tgo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iya kaiwae Loi le ghamba mbaro ŋgora iyake: Kiŋ regha va nuwaiya i tamweya le rakakaiwo ghanjighaga. ");
INSERT INTO tgo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mbaŋa i woraweya le tamweko rɨghe, thɨ vaŋgumena ghɨmoru reghawe, gheghaga i laghɨye moli ŋgoreiya miliyon Kina. ");
INSERT INTO tgo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma va valɨkaiwae i vamodo, ghagiyama iŋa na amalaghɨniye, levo na le ŋgaŋga na lenji bigibigiko wolaghɨye, thɨ vavakuneŋaŋgi na thɨ tabo na rakakaiwobwaga, i mbana maniko na i vamodo gheghagakowe.” ");
INSERT INTO tgo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Rakakaiwoma i ronja e gheghe vuvuye e ghamwae na i naŋgo vurɨgheghewe iŋa, ‘U ghataŋaghathɨ na wo u roroghagha, tene ya vamodonjoghavao.’ ");
INSERT INTO tgo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ghagiyama i gharevɨrɨ kaiwae amba i rakayathu gheghagama na i dagewe ma tene i vamodova.” ");
INSERT INTO tgo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ko mbaŋa rakakaiwoko iyako i raŋgi, i vaidiya mbe le valɨrakakaiwo reghava. Va i ghaga weya amalaghɨniye, iya me raŋgima, ko mava i laghɨye ŋgoreiya Kina ghɨviyeŋge. I yalawe e numwe na iŋa, ‘U vamodo manina va u ghagana weŋgo!’” ");
INSERT INTO tgo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Le valɨrakakaiwoma i ronja e gheghe vuvuye e ghamwae na i naŋgo vurɨgheghewe iŋa, ‘U ghataŋaghathɨ na wo u roroghagha, tene ya vamodonjoghavao.’” ");
INSERT INTO tgo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ko iyemaeŋge va i botewo na iŋa na thɨ vaŋguruwo e thiyo gheghada i vamodo ghaghagako. ");
INSERT INTO tgo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Rakakaiwoma vavanava thɨ thuweya ghanjiuko le vakatha weya gheuko na nuwanji i tharɨ laghɨye kaiwae. Thɨ wa weya giyama na vethɨ utugiya bigibigiko wolaghɨyewe.” ");
INSERT INTO tgo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Amba ghanjigiyama i kula ruwo rakaiwoma na iŋa, ‘Ghen rakakaiwo raithara ghen. Ghanɨghagama wolaghɨye e ghino kaero ya nuwoyathu ŋgoreiya me len naŋgo ma e ghino. ");
INSERT INTO tgo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mbala gharen me nja weya ghanuna ŋgoreiya ghino, ghareŋgu me njaweŋge.’ ");
INSERT INTO tgo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ghagiyama ghare i gaithɨ laghɨye, i vaŋgugiya na ve yaku e thiyo gheghada i vamodavao gheghagako.” ");
INSERT INTO tgo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisas iŋa, “Bwebwe e buruburu ne i vakatha ŋgoreiyako weŋga, taulaghɨna ghemi, thoŋgo ma hu numoyathuŋgiya ghamunena lenji tharɨ e gharemina.” ");
INSERT INTO tgo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mbaŋa Jisas i utuvao utuutuke thiyake, i iteta Galili le valɨvaŋga na i wa Judiya ele valɨvaŋga, e Walaghɨta Jorɨdan valɨvaŋga i vorovoro. ");
INSERT INTO tgo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wabwi laghɨye thɨ rakambele na i thawariŋgiya ghambweghambwera e wabwiko iyako tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi vavana thɨ menawe na thɨ munjeva thɨ mando, thɨ vaito thɨŋa, “Thare la mbaro i vatomwe na valɨkaiwae lolo regha i yawo weiye levo na rɨghe mbe amalaghɨniye i ghareghare?” ");
INSERT INTO tgo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I gonjogha weŋgi iŋa, “Mbe hu vaona Buk Boboma iya iŋake, ‘Va i rikowe Ravakavakatha i vakathaŋgiya ghɨmoru na wevo.’ ");
INSERT INTO tgo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tembe iŋava, ‘Iyake kaiwae ghɨmoru i iteteŋgiya ramae na tɨnae, i tubwe weiye levo, na thenjighewoko ŋgoranjiya ririwo regha.’ ");
INSERT INTO tgo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ma methɨ tabona gharɨgharɨ thenjighewo, nandere. Kaero thɨ tabona ririwo regha. Iya kaiwae budakaiya Loi vama i tubwe, thava te lolo reghava i rakayathu.” ");
INSERT INTO tgo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisi mbowo thɨ vaitova, thɨŋa, “Ghen mo utuna ŋgorana, buda kaiwae eŋge Mosese va i woraweya mbaro, thoŋgo ghɨmoru nuwaiya i botewo levo, wo i vakathakaiya botewo ghapeipa na i ligiya weya levo, amba muyai i variyeyathu.” ");
INSERT INTO tgo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas i gonjogha weŋgi, iŋa “Mosese va i vatomweya yawo kaiwae gharemi i vurɨgheghe. Ko va i rikowe ma va ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya dage e ghemi, thoŋgo lolo regha i yawo weiye levo, othembe wevoko ma i yathima, na kaero i vaŋguva wevo togha, amalaghɨniye i yathima.” ");
INSERT INTO tgo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Gharaghambu thɨ dagewe, thɨŋa, “Thoŋgo ghe ghambaro ŋgoreiyako, i thovuye moli thava ra ghe.” ");
INSERT INTO tgo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisas i dage weŋgi, “Lemi renuwaŋana iyena ma gharɨgharɨke taulaghɨ kaiwanji, ko mbe iyaeŋge thavala Loi kaero i giya weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gharɨgharɨ vavana ma valɨkaiwae thɨ ghe kaiwae vambe thɨ virɨghambɨ. Vavana ma thɨ ghe kaiwae gharɨgharɨ thɨ vakathaŋgi na ma valɨkaiwanji. Vavana ma thɨ ghe kaiwae tembe ghanjimberegha thɨ dagetenɨŋgi Loi le ghamba mbaro kaiwae. Thela thoŋgo valɨkaiwae i wo renuwaŋake iyake, amba i wo.” ");
INSERT INTO tgo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gharɨgharɨ vavana thɨ bigimenaŋgiya gamagai weya Jisas, na i bigirawe nɨmanɨmae weŋgi na i naŋgo kaiwanji, ko iyemaeŋge gharaghambu thɨ ŋaelɨmbiya weŋgiya gharɨgharɨko. ");
INSERT INTO tgo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisas iŋa, “Hu vatomweŋgiya gamagai na thɨ rakamena weŋgo, thava hu dagetenɨŋgi, kaiwae Loi le ghamba mbaro ina weŋgiya gharɨgharɨ ŋgoranjiya thiyena.” ");
INSERT INTO tgo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","I bigirawe nɨmanɨmae e riwanji na i naŋgo weya Ramae ghare weŋgi amba i iteta ghembako iyako. ");
INSERT INTO tgo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mbaŋa regha amala regha i mena weya Jisas na i vaito, iŋa, “Ravavaghare, thambo vakatha thovuye ne ya vakatha na ya vaidiya yawalɨ memeghabananiye?” ");
INSERT INTO tgo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisas i dagewe, iŋa, “Buda kaiwae u vaitoŋgo thovuye kaiwae? Mbe lolo reghaeŋge vara iye i thovuye. Thoŋgo nuwaniya u vaidiya yawalɨ memeghabananiye, u ghambuŋgiya Loi le mbaro.” ");
INSERT INTO tgo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Amalama i vaito, iŋa, “The mbaroŋgi?” Jisas i gonjoghawe, iŋa, “Tha u gabo, tha u yathima, tha u kaivɨ, tha u wonjowe bwagabwaga, ");
INSERT INTO tgo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","u yavwatata wanaŋgiya rama na tɨna, na u gharethovu weya ghanu ŋgoreiya u gharethovu e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Amalama i dagewe, “Mbaroŋgike wolaghɨye thiyake kaero ya ghambuvaoŋgi. Budakai mbowo i kwarava e ghino?” ");
INSERT INTO tgo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas i dagewe, iŋa, “Thoŋgo nuwaniya u rumwaru moli, u wa vo vakuneŋaŋgiya len bigibigina, u giya manina weŋgiya mbinyembinyeŋgu; amba ne u vwenyevwenye e buruburu, na u mena u ghambuŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mbaŋa i loŋweya utuko iyako, i wa weiye le nuwatharɨ laghɨye, kaiwae le gogomwau i laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jisas i dage weŋgiya gharaghambu, iŋa, “Ya dage emunjoru e ghemi, ravwenyevwenye le ru ne i vuyowo Loi ele ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mbowo ya dageva e ghemi, i vuyowo moli weya kamel na i komughathara e nyilɨ yathiye, ko i vuyowo laghɨye moli weya ravwenyevwenye le ru Loi ele ghamba mbaro tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mbaŋa gharaghambuko thɨ loŋweya iyake, gharenji i yo laghɨye moli na thɨ vaito, thɨŋa, “Thela eŋge ne i vaidiya vamoru?” ");
INSERT INTO tgo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas i vonjimbughathɨŋgi na iŋa, “Iyake, gharɨgharɨ ma valɨkaiwanji, ko Loi iye valɨkaiwae bigibigike wolaghɨye.” ");
INSERT INTO tgo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita i dagewe iŋa, “Wo u thuwe, wo iteteŋgiya bigibigike wolaghɨye na wo ghambuŋge. Budakai ne ina gheko kaiwame?” ");
INSERT INTO tgo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas i dage weŋgi iŋa, “Ya dage emunjoru e ghemi ne e yambane togha, mbaŋa Lolo Nariye ne i yaku ele ghamba yaku vwenyevwenye ghemi woraghambu themiyaworo na themighewona, ne hu yaku e ghamba yaku theyaworo na theghewo na hu mbaroŋgiya uu theyaworo na theghewo Isirel e tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na thela i iteta le ŋgolo, oghaghae, oloulouye, ramae, tɨnae, le ŋgaŋga, na le thelau idaŋgu kaiwae, ne i vaidiya bigibigiko thiyako laghɨye moli na e vwataeva, na i vaidiya yawalɨ memeghabananiye. ");
INSERT INTO tgo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ko thavala noroke thɨ laghɨye na thɨ viva ne thɨ muyai na thavala noroke thɨ nasiye na thɨ muyai ne thɨ viva.” ");
INSERT INTO tgo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Loi le ghamba mbaro ŋgoreiyake. Amala regha, vambe mbaŋambaŋa ma i raŋgi na i tamweŋgiya gharɨgharɨ, i naŋgoŋgi na thɨ kaiwo ele waenɨko ghanjiuma. ");
INSERT INTO tgo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Amalama iŋa ne i vamodaŋgi ŋgoreiya mbaŋa regha modae, silva gethɨra. Gharɨgharɨma lenji renuwaŋa ŋgoreiye amba i variyeŋgi waenɨma e ghauma tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mbaŋa ghalughawoghawo ŋgoreiya naen klok amalama mbowo i raŋgiva, i wa e ghamba maket. I vaidiŋgiya gharɨgharɨ vavana thiya yaku bwaga ma e ghanjikaiwo, ");
INSERT INTO tgo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","i dage weŋgi, iŋa, “Ghemi ŋgoreiye, vou kaiwo elo waenɨko ghanjiuma. Ne ya vamodo wagiyaweŋga ŋgoreiya renuwaŋa iŋa na mane ya vakatha vatharɨ weŋga.” ");
INSERT INTO tgo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kaero thɨ wa. Ghararaghɨye mboro na tɨri klok i wa na tembe ve vakatha va ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mbala vama i wo paeb klok, amalama mbowo i wava e ghamba maketɨma na ve vaidiŋgiya gharɨgharɨ vavana thɨ ndendeghathɨ. I vaitoŋgi iŋa, “Buda kaiwae huya ndeghathɨ ghena? Mbaŋake laghɨye mohuya ndebwagabwaga moli.” ");
INSERT INTO tgo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Thɨ gonjoghawe, thɨŋa, “Kaiwae ma lolo regha me giya kaiwo weime.” I dage weŋgi, “Hu wa na vou kaiwo elo waenɨko ghanjiuma.” ");
INSERT INTO tgo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Vama yeghɨyeghɨye moli amba umama tanuwagae i dage weya rakakaiwoko ghanjiranjimbunjimbu iŋa, “U kula weŋgiya rakakaiwoko na u giya modanji. U giyakai weŋgiya ma kula reghambama na vo giyavun weŋgiya ma kulakaiŋgima.” ");
INSERT INTO tgo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Thiye methɨ kaiwo reghambama, ŋgoreiya paeb klok ele valɨvaŋga, thɨ mena na i giya modanji ŋgoreiya mbaŋa regha modae, silva gethɨra iya. ");
INSERT INTO tgo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mbaŋa thiyema methɨ kaiwokaima thɨ mena, thɨ munjeva ne modanji i divoro, ko iyemaeŋge thɨ mban tembe ŋgoreiyeva mbaŋa regha modae, silva gethɨra iya lolo regha. ");
INSERT INTO tgo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mbaŋa thɨ mbana modanji, thɨ liya umama tanuwagae ghautu, ");
INSERT INTO tgo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","thɨŋa, “Gharɨgharɨke iya mo vaŋguŋgike muyai, methɨ kaiwo mbaŋa ubotu moli na mo giya modanji mboromboro weimaŋgi, ko iyemaeŋge ghime mo vaidiya vuyowo laghɨye, mo vakatha mbaŋa regha ghakaiwo na wo ghataŋaghathɨgha varae le vurɨgheghe weime.” ");
INSERT INTO tgo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ko umama tanuwagae i dage weya ghanjiu regha iŋa, “Wou, ma ma vakatha vatharɨ e ghen. Mo warariŋa u kaiwo mbaŋa regha na modan silva gethɨra. ");
INSERT INTO tgo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","U mbana modana na u wa. Nuwaŋguiya ya giya loloke iya ma vaŋgureghambake modae mboromboro weiye ma giyana e ghen. ");
INSERT INTO tgo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ko ma valɨkaiwaŋgu wombereghake ya vakatha lo manike ŋgoreiya lo renuwaŋake? Ma valɨkaiwae u yamwanja kaiwae ghino ya mwaewo weŋgiya gharɨgharɨ.” ");
INSERT INTO tgo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iya kaiwae Jisas i govun, iŋa, “Thavala noroke thɨ viva ne thɨ rereghamba na thavala noroke thɨ rereghamba ne thɨ viva.” ");
INSERT INTO tgo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas i loŋgaloŋga Jerusalem kaiwae, i vaŋguŋgiya gharaghambu na mbe thiye eŋge na i layo utuutu weŋgi iŋa, ");
INSERT INTO tgo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kaero ra loŋgaloŋga Jerusalem kaiwae, na gheko ne thɨ vaŋgugiya Lolo Nariye weŋgiya ravowovowo laghɨlaghɨye na mbaro gharavavaghare. Ne thɨ vakatha ghambaro na i mare, ");
INSERT INTO tgo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","na thɨ vaŋgugiya weŋgiya thiye ma Jiu gharɨgharɨniye na thɨ utuvatharɨ kaiwae, thɨ yabɨbɨ na thɨ ŋge e kros vwatae. Ko mbaŋa ne theghetoniye e tɨne kaero i thuweiru na ma e yawayawaliyeva.” ");
INSERT INTO tgo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Amba Sebedi le ŋgaŋgama thenjighewoma tɨnanji i mena weya Jisas weiyaŋgi, i ronja e gheghe vuvuye e ghamwae na i naŋgowe. ");
INSERT INTO tgo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisas i dagewe, iŋa, “Nuwaniya budakai?” Iŋa, “Nuwaŋguiya u dagerawe e ghino, mbaŋa ne inan e len ghamba mbaro tɨne, lo ŋgaŋgake thenjighewoke thiyake; regha ne i yaku e unena na regha e moina.” ");
INSERT INTO tgo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisas i dage weŋgi, iŋa, “Ma hu ghareghare, hu naŋgo weya budakai. Valɨkaiwami ne hu mun e vɨrɨke ghakom iya ghino ne ya munɨkewe?” Thɨ gonjoghawe, thɨŋa, “Ŋgoreiye, valɨkaiwame eŋge.” ");
INSERT INTO tgo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I dage weŋgi, iŋa, “Emunjoru, tene hu mun e wokomuke, ko ma valɨkaiwaŋgu yaŋa thela i yaku e uneŋguke na thela e moiŋguke. Ghamba yakuke thiyake Bwebwe va i vivatharawe, thavala i tuthiŋgi kaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mbaŋa gharaghambuma theyaworoma thɨ loŋweya iyake gharenji i gaithɨwanaŋgiya ghewoko na ghaghae. ");
INSERT INTO tgo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisas i kula vathaŋgi, mbema taulaghɨko vara na iŋa, “Kaero hu ghareghare, thiye ma Jiu lenji rambarombaro thɨ mbaroŋaŋgi na lenji randeviva lenji vurɨgheghe i varinjoŋaŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ko ghemi, thava ŋgoramiya iyako. Thela thoŋgo nuwaiya iye lolo laghɨye e tɨnemina, iye wo i tabo na lemi rakakaiwo. ");
INSERT INTO tgo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Thela thoŋgo nuwaiya i ndeviva weŋga wo i tabo na lemi rakakaiwobwaga, ");
INSERT INTO tgo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ŋgoreiya Lolo Nariye, mava i mena na mbala thɨ kaiwo kaiwae, ko i mena na i kaiwo gharɨgharɨ kaiwanji na i vatomwe yawaliye i vamodonjoghaŋgi e lenji tharɨ tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mbaŋa Jisas na gharaghambu thɨ iteta Jeriko, wabwi laghɨye thɨ rakareghamba weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E mbaŋako iyako, gharɨgharɨ thenjighewo, maranji i kwaghe, thɨ yaku e kamwathɨko ghadidiye. Mbaŋa thɨ loŋweya Jisas i mena na ma i vaiteteŋgi, thɨ kula thɨŋa, “Amalana, Deivid Rumbuye, gharen i nja weime.” ");
INSERT INTO tgo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wabwima thɨ ŋaevwaŋaŋgi na thɨ dage weŋgi thɨ rokubaro. Ko iyemaeŋge thɨ kula na ghalɨŋanji ma laghɨye eŋge, “Amalana, Deivid Rumbuye, gharen i nja weime.” ");
INSERT INTO tgo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas i ndeghathɨ na i kula weŋgi iŋa, “Nuwamiya ya vakatha budakai kaiwami?” ");
INSERT INTO tgo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Thɨ gonjoghawe, thɨŋa, “Amalana, nuwameiya u vakatha maramarameke thɨ thovuye na kaero wo thuweva.” ");
INSERT INTO tgo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas ghare i nja weŋgi na i vɨghathɨgha maramaranji. E mbaŋako iyako kaero thɨ thuweva na thɨ ghambu. ");
INSERT INTO tgo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas na gharaghambu vama thɨ vurɨthaiya Jerusalem, thɨ mena Betepage, Olivɨ ghanji Ou ghembaniye regha; amba i variyeŋgiya gharaghambu thenjighewo e ghamwanji, ");
INSERT INTO tgo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iŋa, “Hu wa na vou ru e ghembana e ghamwamina. Ne hu thuweya doŋɨki regha thɨ ŋgarɨghathɨ weiye nariye. Hu raka ghathiyona na hu vaŋguma weiye nariyena. ");
INSERT INTO tgo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Thoŋgo lolo regha i vaitoŋga, hu dagewe huŋa, ‘Giya nuwaiya,’ na tene i variyeŋgi e mbaŋako iyako.” ");
INSERT INTO tgo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iyake va i yomara na i vaemunjoruŋa Loi ghalɨŋae gharautu ghalɨŋae iya iŋake: ");
INSERT INTO tgo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Hu giya Saiyon gharɨgharɨniye yanawanji: Wo hu thuwe, lemi kiŋ maiya i ghaona weŋga. Iye ghathanavu i ghenenja, i tha e doŋɨki, i tha doŋɨki nariye e vwatae. ");
INSERT INTO tgo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gharaghambuma thɨ wa na vethɨ vakatha ŋgoreiya me dagema weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Thɨ vaŋgumenaŋgiya doŋɨkima na nariye, thɨ bigiraweya ghanjikwama ghayaboyabo nariye e vwatae na Jisas i tha. ");
INSERT INTO tgo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wabwi laghɨye thɨ tateŋgiya ghanjikwama e kamwathɨko mara na vavana thɨ tenɨŋgiya umbwaumbwa ndamwandamwae na thɨ bigirawe. ");
INSERT INTO tgo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Gharɨgharɨko iyava thɨ rakavivako na thiyeko iyava thɨ rakareghambako thɨ kula, thɨŋa: Hosana! Ra taraweŋa Deivid Rumbuye! Loi gharewe iya i mena Giya e idae! Hosana! Ra taraweŋa Loi, iye i mevoro moli! ");
INSERT INTO tgo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mbaŋa Jisas i ru Jerusalem, gharɨgharɨko wolaghɨye gharenji i tagathɨn na thɨ vaito, thɨŋa, “Thelako?” ");
INSERT INTO tgo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wabwima thɨ gonjogha weŋgi, thɨŋa, “Loi ghalɨŋae gharautu, Jisas, i mena Nasaret, Galili ghembaniye regha.” ");
INSERT INTO tgo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas i ru e Ŋgolo Boboma ghayayao tɨne na i vagege raŋgiyaŋgiya rakunekune, i mwanavevewoŋgiya yao gharaten lenji tebol na tembe ŋgoreiyeva thiye va thɨ vakuneŋaŋgiya bunebune, lenji ghamba yaku. ");
INSERT INTO tgo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","I dage weŋgi iŋa, “Thɨ rori Buk Boboma e tɨne Loi iŋa, ‘Lo ŋgoloke ne thɨ una idae ŋgolo ghamba naŋgo,’ ko iyemaeŋge ghemi hu vakatha ŋgoreiya rakaivɨ lenji ghamba kubaro.” ");
INSERT INTO tgo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Gharɨgharɨ maramaranji i kwaghe na vavana gheghenji thiya tharɨ thɨ rakamenawe e Ŋgolo Bobomako tɨne na i thawariŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko mbaŋa ravowovowo laghɨlaghɨye na mbaro gharavavaghare thɨ thuwe vakathako thovuye i vakathaŋgi na gamagai thɨ kulakula e Ŋgolo Bobomako tɨne, thɨŋa, “Hosana! Ra taraweŋa Deivid Rumbuye,” gharenji i gaithɨwana Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Thɨ dagewe, thɨŋa, “Thare u loŋwe, ŋgoroŋga gamagaiko thɨŋa?” Jisas i gonjogha weŋgi, iŋa, “Ŋgoreiye. Mbe hu ndevaona mun bukuke iya iŋake, ‘O Loi, u vavaghareŋgiya gamagai na mbala gamagai nanasiye thɨ taraweŋaŋge.’” ");
INSERT INTO tgo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisas i iteteŋgi na i raŋgi Jerusalem e tɨne, i wa Betani ve ghenawe. ");
INSERT INTO tgo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mbaŋambaŋa moli Jisas i njogha Jerusalem. E kamwathɨ mborowa bada i gharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I thuweya umbwa regha e kamwathɨko ghadidiye, idae fig, i ru na i yanyi, ko iyemaeŋge ma e uneune mbe ndamwandamwae eŋge. I dage weya umbwama iŋa, “Ma tene mbaŋa reghava u rau!” E mbaŋako iyako umbwama i mareyawowo. ");
INSERT INTO tgo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mbaŋa gharaghambu thɨ thuwe gharenji i yo. Thɨ vaito, thɨŋa, “Me ŋgoroŋga na umbwako le mare i maya?” ");
INSERT INTO tgo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas i gonjogha weŋgi iŋa, “Ya dage emunjoru e ghemi, thoŋgo hu loŋweghathɨ na ma hu numoghegheiwo, valɨkaiwamiya hu vakatha ŋgoreiya ma vakatha weya umbwako. Ma mbe iyako eŋge, valɨkaiwamiya ne hu dage weya ou, ‘U wa na vo dobu e njighɨko tɨne,’ ne i vakatha ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Thoŋgo hu loŋweghathɨ, the bigiya ne hu naŋgo weya Loi ne hu vaidi.” ");
INSERT INTO tgo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mbaŋa Jisas i ru e Ŋgolo Boboma ghayayao tɨne na i vavaghare, ravowovowo laghɨlaghɨye na randevivaŋgi thɨ menawe na thɨ vaito, thɨŋa, “U vata thela ele mbaro vwatae na u vakathaŋgiya bigibigike thiyake? Thela i giya vurɨgheghe e ghen?” ");
INSERT INTO tgo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas i gonjogha weŋgi iŋa, “Ghino tembe ŋgoreiyeva, wo ya vaitoŋga vaito regha na thoŋgo hu wogiya ghathombe e ghino, ghino tembe ŋgoreiyeva ne ya utuŋa e ghemi ya vata thela ele mbaro vwatae na ya vakathaŋgiya bigibigike thiyake. ");
INSERT INTO tgo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon le rɨghe na i bapɨtaiso, i mena weya Loi o i mena weŋgiya gharɨgharɨ?” Mbe thiye eŋge thɨ veutu weŋgi, thɨŋa, “Thoŋgo raŋa, ‘I mena weya Loi’ ne iŋa, ‘Buda kaiwae na mava hu loŋweghathɨgha Jon?’ ");
INSERT INTO tgo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ko thoŋgo raŋa, ‘I mena weŋgiya gharɨgharɨ,’ ra mararuŋgiya gharɨgharɨ, kaiwae thɨ ghareghare Jon iye Loi ghalɨŋae gharautu.” ");
INSERT INTO tgo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iya kaiwae thɨ gonjogha weya Jisas, thɨŋa, “Ma wo ghareghare.” I dage weŋgi, iŋa, “Ghino tembe ŋgoreiyeva, mane ya utuŋa e ghemi, ya vata thela e vwatae na ya vakathaŋgiya bigibigike thiyake.” ");
INSERT INTO tgo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas i gotubwe iŋa, “Ŋgoroŋga lemi renuwaŋa? Amala regha le ŋgaŋga thenjighewo. I wa weya virɨviva na ve dagewe, iŋa ‘Naruŋgu, noroke u wa na vo kaiwo e uma.’ ");
INSERT INTO tgo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","I gonjogha weya ramae iŋa, ‘Ya botewo,’ ko va muyai i vɨva le renuwaŋa na i wa. ");
INSERT INTO tgo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Amalama i wa weya nariyema regha na ve dagewe tembe ŋgoreiyeva me dage weya virɨvivama. Nariyema iŋa, ‘Ŋgoreiye Bwebwe, tene ya wa,’ ko iyemaeŋge ma va i wa. ");
INSERT INTO tgo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Thenjighewoko, thela i vakatha ŋgoreiya ramanji le renuwaŋa?” Thɨŋa, “Iya virɨvivama.” Jisas i dage weŋgi iŋa, “Ya dage emunjoru e ghemi, takis gharamban na wanakau thɨ mbana riwanji modae, thiye hu rerenuwaŋa kaero thɨ vurɨmban Loi le ghamba mbaro e ghakamwathɨ. Valɨkaiwanjiya ne thɨ ru ko iyemaeŋge ghemi mane hu ru. ");
INSERT INTO tgo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kaiwae Jon Rabapɨtaiso va i mena weŋga, i vaghareŋga thanavu thovuye ghakamwathɨ na ma hu loŋweghathɨ, ko takis gharamban na wanakau thɨ mbana riwanji modae, thiye eŋge thɨ loŋweghathɨ. Othembe va hu thuweŋgi thɨ vakatha ŋgoreiyako, ko mava hu vɨva ghamithanavu na hu loŋweghathɨgha Jon le utuko.” ");
INSERT INTO tgo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas iŋa, “Mbowo ya utuŋava goghaimba regha na hu loŋwe: Lolo regha va i kabu waen ghauma, i gana vaghɨliya, i vakatha doda waen ghamba i imbɨimbɨ, na i vatada ŋgolo regha, umako gharanjimbunjimbu lenji ghamba yaku. I vakatha ŋgoreiyako, amba i vatomwe weŋgiya gharɨgharɨ vavana na thɨ vakaiwoŋa amalaghɨniye kaiwae. Na amalaghɨniye i wa e valɨvaŋga regha. ");
INSERT INTO tgo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Mbaŋa kaero ghambaŋa thɨ vu, umama tanuwagae i variyeŋgiya le rakakaiwo weŋgiya umama gharanjimbunjimbu na vethɨ mbana uneune amalaghɨniye kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Umama gharanjimbunjimbu thiya laweŋgiya rakakaiwoma, thɨ ŋgeŋgeŋa regha, thɨ tagavamara regha na thɨ biriya regha e varɨ. ");
INSERT INTO tgo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Amalama mbowo i variyeŋgiva le rakakaiwo vavana, seiwo i kivwala me vivama. Thɨ vakatha weŋgi tembe ŋgoreiyeva methɨ vivama. ");
INSERT INTO tgo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Muyai moli i variya nariye weŋgi na iŋa, ‘Ne thɨ yavwatatawana naruŋguke.’ ");
INSERT INTO tgo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ko mbaŋa ranjimbunjimbuma thɨ thuweya nariyeko, thɨŋa, ‘Umake tanuwagae nariya iyako. Amalaghɨniye ne i rombaroŋa umake ramae e ghereiye. Hu mena ra tagavamare na mbalama ra mbaroŋava iya le umake.’ ");
INSERT INTO tgo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Thɨ yalawe, thɨ wokiyathuraŋgiya e gana ghereiye na thɨ tagavamare.” ");
INSERT INTO tgo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisas i vaitoŋgi iŋa, “Mbaŋa ne umama tanuwagae i njoghama, ne i vakatha budakai weŋgiya umako gharanjimbunjimbu?” ");
INSERT INTO tgo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jiu lenji randevivaŋgima thɨŋa, “Ne i gaboŋgiya gharɨgharɨko raraitharɨ na i vatomweya le umako weŋgiya gharɨgharɨ totogha thɨ njimbukiki, mbala i mweghe na thɨ vu, thɨ vakatha wagiyawe uneuneko amalaghɨniye kaiwae na vethɨ giyawe.” ");
INSERT INTO tgo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas i dage weŋgi, iŋa, “Mbe hu ndevaona mun ŋgoroŋga Buk Boboma iŋa? Varɨke iya ŋgoloke gharavatavatad va thɨ botewo na i tabo mbaghɨmbaghɨ. Iyake Giya le vakatha, na ghathuwathuwa i thovuye na i wo nuwanda.” ");
INSERT INTO tgo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jisas mbowo i dageva weŋgi iŋa, “Ya dage e ghemi, Loi ne i wo le ghamba mbarona ghathovuye weŋga na i wogiya weŋgiya the vanautuma gharɨgharɨniye iya ne e yawalinjiko uneune i woraŋgiya i thovuyeŋa Loi le ghamba mbaro. ");
INSERT INTO tgo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Thela ne i dobu e varɨke iyake vwatae ne i tagamunumunuwo, na thoŋgo varɨke iyake i dobu lolo regha e vwatae ne i tagavwathavwatha.” ");
INSERT INTO tgo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mbaŋa ravowovowo laghɨlaghɨye na Parisi thɨ loŋweya Jisas le goghaimbaŋgiko, thɨ ghareghare i utuutu thiye kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Thɨ mando na thɨ munjeva thɨ yalawe ko iyemaeŋge thɨ mararuŋgiya wabwiko kaiwae thɨŋa iye Loi ghalɨŋae gharautu. ");
INSERT INTO tgo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas mbowo i goghaimbava weŋgiya gharɨgharɨma methɨ vaitoma iŋa, ");
INSERT INTO tgo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Loi le ghamba mbaro ŋgoreiya kiŋ regha, i vakatha thaga nariye le ghe kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","I variyeŋgiya le rakakaiwo, thɨ wa na vethɨ butu weŋgiya thavala ghanjikula ina e gheko ghathaga rɨghe, ko iyemaeŋge thɨ botewo na thɨ rakamena.” ");
INSERT INTO tgo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Mbowo i variyeŋgiva le rakakaiwo vavana iŋa, ‘Vou dage weŋgiya thavala mendava ya mwanavathaŋgi, vouŋa ghanɨŋga kaero i vivathavao, burumwaka va thɨ vivatharawe thagake kaiwae kaero thɨ gaboŋgi na bigibigike wolaghɨye kaero thɨko. Ma hu mena eŋge e thagake rɨghe.’” ");
INSERT INTO tgo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ko thiye ma va thɨ goru weya renuwaŋako iyako na thɨ wa ŋgoreiya lenji renuwaŋa. Regha i wa ele uma tɨne, regha i wa ele sitowa ");
INSERT INTO tgo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na vavana thɨ yalaweŋgiya rakakaiwoŋgima, thɨ gaboŋgi, na thɨ tagavamareŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kiŋɨma i gaithɨ laghɨye moli, i variyeŋgiya le ragagaithɨ, thɨ gaboŋgiya gharɨgharɨko iyava thɨ gaboŋgiya le rakakaiwoma na thɨ woŋambu ghambanjiko.” ");
INSERT INTO tgo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Amba i dage weŋgiya le rakakaiwo, iŋa, ‘Ghe ghathaga kaero ya vivathavao, ko thavala mendava ya kula weŋgi ma thɨ goru weya lo kulake. ");
INSERT INTO tgo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hu wa e kamwathɨ ghavwaghavwala na thavala hu vaidiŋgi, hu dage weŋgi na thɨ mena e thagake rɨghe.’ ");
INSERT INTO tgo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Rakakaiwoma thɨ wa e kamwathɨŋgiko na gharɨgharɨko wolaghɨye iya thɨ vaidiŋgiko, thovuthovuye o raraitharɨ, thɨ vaŋguŋgi, gheko ghathaga ghaŋgolo i riyevanjara.” ");
INSERT INTO tgo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ko mbaŋa kiŋɨma i ru thagako e ghaŋgolo tɨne na i thuweŋgiya gharɨgharɨko, i njimbuvaidiya amala regha ma va i njimbo ghe ghakwama. ");
INSERT INTO tgo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","I vaito iŋa, ‘Wou, ŋgoroŋga mo mena u ruke na ma mo njimbo ghe ghakwama?’ Amalama ma e ghalɨghalɨŋae. ");
INSERT INTO tgo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Amba kiŋɨma i dage weŋgiya le rakakaiwoma iŋa, ‘Hu ŋgara nɨmanɨmae na gheghe na hu wokiyathuraŋgiya eto e momouwoko tɨne ve randarandawe na i rɨghɨmbiya ŋiŋiye.’” ");
INSERT INTO tgo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas i govun iŋa, “Loi i kula weŋgiya gharɨgharɨ lemoyo, ko mbe thegheviye eŋge i tuthiŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Amba Parisi thɨ iteta Jisas na thɨ raka vethɨ rerenuwaŋa ŋgoroŋga ne thɨŋa na thɨ vakatha ghawonjowe ele utuutuko. ");
INSERT INTO tgo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Parisi thɨ variyeŋgiya ghanjiraghambu vavanawe Jisas weinjiyaŋgiya gharɨgharɨ vavana thiye thɨ ghambugha Herod le wabwi gharɨgharɨniye. Thɨŋa, “Ravavaghare, wo ghareghare u utuŋa emunjoru na len vavaghare Loi le renuwaŋa gharɨgharɨ kaiwanji i rumwaru. Ma u goru weya ŋgoroŋga gharɨgharɨ lenji renuwaŋa kaiwae ma u goru weya ŋgoroŋga lolo le thimba o le laghɨlaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ŋgoroŋga ghen len renuwaŋa, wo u utugiyama weime. Mbaro i dage ŋgoreiye na wo vamodo takisi weya Sisa o nandere?” ");
INSERT INTO tgo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisas kaero i ghareghareya lenji renuwaŋako raraitharɨ iya kaiwae i dage weŋgi iŋa, “Taukwana ghemi! Buda kaiwae hu munjeva hu mando na hu wonjoweŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wo hu wovatomwe weŋgo manike iya hu vavamodo takisikowe.” Thɨ wo gethɨra na thɨ mena thɨ wogiyawe, ");
INSERT INTO tgo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","amba i vaitoŋgi iŋa, “Thela ŋgaliŋgaliya na idae iya e manike?” ");
INSERT INTO tgo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Thɨŋa, “Sisa.” Jisas i dage weŋgi iŋa, “Sisa le bigibigi hu giyawa Sisa na Loi le bigibigi hu giyawa Loi.” ");
INSERT INTO tgo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mbaŋa thɨ loŋweya iyake, gharenji i yo, thɨ itete na thɨ rakawa. ");
INSERT INTO tgo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mbaŋako iyako e tɨne Sadusi, thiye ma thɨ loŋweghathɨgha ramaremare tene thɨ thuweiruva, thɨ mena weya Jisas na thɨ vaito ");
INSERT INTO tgo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","thɨŋa, “Ravavaghare, Mosese iŋa thoŋgo amala regha i ghe, ma ele ŋgaŋga na i mare, ghaghae ma i rovaŋguva ghɨmbwiyeko. Thoŋgo i ghambɨ weiye, gamagaiko thiyako ghaghaeko va i mareko le ŋgaŋga. ");
INSERT INTO tgo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Amala regha weiyaŋgiya oghaghae, thenjighepirɨ vara, tɨnanji na ramanji regha. Laghɨyeninji va i ghe na i mare, ma ele ŋgaŋga na ghembwiyeko ghaghae kaero i rovaŋguva. ");
INSERT INTO tgo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ghaghae theghewoniye te vambe ŋgoreiyeva, theghetoninji ŋgoreiye gheghada thenjighepirɨko thɨ vaidi ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Muyai moli elaghɨniye i mare. ");
INSERT INTO tgo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ne mbaŋa ramaremare thɨ thuweiru na e yawayawalinjiva, thela ne i ghe weiye, kaiwae mbe thenjighepirɨko vara va thɨ vaŋgu?” ");
INSERT INTO tgo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas i gonjogha weŋgi iŋa, “Kaero hu vurɨthavwiya kamwathɨ, kaiwae ma hu ghareghareya Buk Boboma le woraŋgiya ŋgoroŋga gharumwaru na budakaiya Loi valɨkaiwae i vakatha. ");
INSERT INTO tgo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kaiwae mbaŋa ne ramaremare thɨ thuweiru na tembe e yawayawalinjiva vama tembene thɨ gheva, thiye ne ŋgoranjiya nyao thovuthovuye e buruburu. ");
INSERT INTO tgo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ramaremare lenji thuweiru na e yawayawalinji utuniye, ma hu vaona ŋgoroŋga Loi va i utuŋa weŋga? Iŋa, ");
INSERT INTO tgo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ghino Eibraham, Aisake na Jeikob lenji Loi.’ Loi va iŋa ŋgoreiyako mbala ra ghareghare gharɨgharɨke thiyake kaerova thɨ mare ko iyemaeŋge mbe e yawayawalinjiva. Loi, iye ma ramaremare lenji Loi ŋgoreiye, nandere, mbe thiye eŋge e yawayawalinji lenji Loi.” ");
INSERT INTO tgo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mbaŋa wabwiko thɨ loŋweya iyake, gharenji i yo le vavaghareko kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ko mbaŋa Parisi thɨ loŋweya Jisas i thombe Sadusi lenji vaito na i vakatha ma e ghalɨghalɨŋanji, thɨ mena thɨ wabwi na regha. ");
INSERT INTO tgo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ghanjiu regha, mbaro gharavavaghare i munjeva i mando Jisas e vaito regha, ");
INSERT INTO tgo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","iŋa, “Ravavaghare, the mbaro i laghɨye vara moli Mosese le mbaro e tɨne?” ");
INSERT INTO tgo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas i gonjoghawe iŋa, “‘U gharethovu weya Giya len Loi e gharena laghɨye, e unena laghɨye na e len renuwaŋana laghɨye.’ ");
INSERT INTO tgo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iyake mbaro laghɨye na iviva moli. ");
INSERT INTO tgo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mbaro theghewoniye mbe laghɨyeva ŋgora iyake, iŋa, ‘U gharethovu weya ghanu ŋgoreiya u gharethovu e ghen.’ ");
INSERT INTO tgo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosese le mbaroko wolaghɨye na Loi ghalɨŋae gharautu lenji vavaghareŋgi, thɨ ndeghathɨwe iya mbaroke theghewoke thiyake.” ");
INSERT INTO tgo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mbaŋa Parisi thɨ meghɨliŋa Jisas, amba i vaitoŋgi iŋa, ");
INSERT INTO tgo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ŋgoroŋga lemi rerenuwaŋa Mesaiya kaiwae? Iye thela rumbuye?” Thɨŋa, “Iye Deivid rumbuye.” ");
INSERT INTO tgo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisas mbowo i vaitoŋgiva iŋa, “Ŋgoroŋgaeŋge na Nyao Boboma i vakatha Deivid i wovagiyagiyaŋa Mesaiya? Kaiwae Deivid iŋa, ");
INSERT INTO tgo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Giya Loi i dagewe wo Giya iŋa: U yaku valɨvaŋga e uneŋguke ghaghad ne ya biginjoŋaŋgiya ghanɨthɨghɨya e gheghen raberabe.’ ");
INSERT INTO tgo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Thoŋgo Deivid i una Mesaiya ‘wo Giya,’ ŋgoroŋgaeŋge na Mesaiya iye Deivid rumbuye?” ");
INSERT INTO tgo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma te lolo reghava valɨkaiwae i thombewe na kaiwae thɨ ghareghare ma valɨkaiwae thɨ kwanɨyaro, ma te mbaŋa reghava lolo regha i giya vaito weya Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Amba Jisas i dage weŋgiya wabwima na gharaghambuma, iŋa, ");
INSERT INTO tgo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mbaro gharavavaghare na Parisi thiye thɨ ghareghare wagiyawe Mosese le mbaro na valɨkaiwanjiya thɨ vamanjamanjalaŋa. ");
INSERT INTO tgo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iya kaiwae, hu vandeŋekikiya ghalɨŋanjiko na hu ghambugha lenji utuko wolaghɨye, ko iyemaeŋge thava hu vakatha ŋgoreiya lenji vakathako kaiwae budakaiya thɨ vakatha, ma mboromboro weiye lenji utuko. ");
INSERT INTO tgo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lenji mbaro i ghanagha moli ne thɨ giya weŋga na hu bigi, ko iyemaeŋge thiye mane nɨmanji gɨgɨra regha i nja na i thalavuŋga na hu wo vuyowoko iyako.” ");
INSERT INTO tgo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Thɨ vakathaŋgiya bigibigike wolaghɨye mbala gharɨgharɨ thɨ thuweŋgi. Nambonambo ŋgamwaiwo, thɨ vakathaŋgi na i laghɨye moli, Buk Boboma rɨgherɨghe vavana inanjiwe. Ŋgamwara thɨ ŋgarɨ e ghamwanji na ŋgamwara e nɨmanji mborowa. Tembe ŋgoreiyeva, ghanjikwama mbothiye ghabithabitha thɨ vakathaŋgi na molamolao. ");
INSERT INTO tgo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Thaga e tɨne nuwanjiya vethɨ yaku ŋgora gharɨgharɨko laghɨlaghɨye lenji ghamba yaku na e lenji ŋgolo kururu tɨne vethɨ yaku e ghamba yaku thovuye gharɨgharɨ e ghamwanji. ");
INSERT INTO tgo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Thoŋgo gharɨgharɨ thɨ vaidiŋgi e kamwathɨ, nuwanjiya gharɨgharɨko weiye lenji yavwatata thɨ dage mwaewo weŋgi na thɨŋa ‘Ravavaghare’ weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Thava ghamunena thɨ dage weŋga na thɨŋa, ‘Ravavaghare’ kaiwae ghami Ravavaghare mbe ghambereghaeŋge na taulaghɨna ghemi mbe oghaghami eŋge iya ghamunena. ");
INSERT INTO tgo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tha hu una lolo regha e yambaneke na huŋa ramami kaiwae Ramami mbe ghambereghaeŋge ina e buruburu. ");
INSERT INTO tgo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Thava gharɨgharɨ thɨ dage weŋga na thɨŋa, ‘Randeviva’ kaiwae lemi randeviva ghamberegha, iye Mesaiya. ");
INSERT INTO tgo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Thela thoŋgo iye i laghɨye e tɨnemina, iye i tabo na lemi rakakaiwo. ");
INSERT INTO tgo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Thela thoŋgo ghamberegha tembe i wovoreŋa Loi ne i wonjoŋa, na thela i wonjoŋa ghamberegha, Loi ne i wovoreŋa.” ");
INSERT INTO tgo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Aleu, mbaro gharavavaghare na Parisi! Taukwana ghemi! Nevole hu thovuyaona, kaiwae hu kiya Loi le ghamba mbaro ghakamwathɨ gharɨgharɨ e ghamwanji na hu botewo hu ru na thavala nuwanjiya thɨ ru hu ndegana lenji kamwathɨ.” ");
INSERT INTO tgo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Aleu, mbaro gharavavaghare na Parisi! Taukwana ghemi! Nevole hu thovuyaona! Hu bigiya bigibigike wolaghɨye weŋgiya wambwiwambwi na hu mbaroŋaŋgi. Lemi naŋgo gharɨgharɨ e maranji i molao mbala thɨ vandeŋeŋga. Lemi vakathake thiyake kaiwanji ne hu vaidiya lithɨ laghɨye moli.” ");
INSERT INTO tgo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Aleu, mbaro gharavavaghare na Parisi! Taukwana ghemi! Nevole hu thovuyaona! Vou ghɨnagha na hu loŋgatakweya vanautumake wolaghɨye. Hu mando na hu utuvɨva lolo regha nuwae na i kururu weya Loi ŋgoreiya lemi kamwathɨna. Mbaŋa i loŋweghathɨŋga, hu vakatha na i tabona Gehena loloniye moli ŋgoreiye ghemi.” ");
INSERT INTO tgo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Aleu, ghemi randeviva raraitharɨ na marami i kwaghe! Nevole hu thovuyaona! Ghemi huŋa, ‘Thoŋgo lolo regha i tholo na i una Ŋgolo Boboma, i thovuye eŋge thoŋgo ma i ghambugha dageraweko iyako; ko thoŋgo lolo regha i tholo na i una golɨko e Ŋgolo Boboma tɨne, ma i thovuyewe thoŋgo ma i ghambugha dageraweko iyako.’ ");
INSERT INTO tgo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Unouna ghemi na marami i kwaghe! Iyaŋganiya bigi laghɨye, gol o Ŋgolo Boboma iya i vakatha golɨko na i boboma? ");
INSERT INTO tgo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ghemi tembe huŋava, ‘Thoŋgo lolo regha i tholo na i una varɨko iya ghamba vowoko, i thovuyewe eŋge thoŋgo ma i ghambugha dageraweko iyako; ko thoŋgo lolo regha i tholo na i una wogiyako iya vowoko kaiwae, ma i thovuyewe thoŋgo ma i ghambugha dageraweko iyako!’ ");
INSERT INTO tgo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ghemi marami i kwaghe! Iyaŋganiya bigi laghɨye wogiya o ghamba vowoko iya i vakatha wogiyako na i boboma. ");
INSERT INTO tgo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iya kaiwae, mbaŋa thoŋgo lolo regha i tholo na i una ghamba vowoko, i tholo e ghamba vowoko weiye wogiyako iya vowoko kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tembe ŋgoreiyeva, mbaŋa thoŋgo lolo regha i tholo na i una Ŋgolo Boboma, i tholo e Ŋgolo Boboma na Loi, ina i yaku gheko. ");
INSERT INTO tgo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na mbaŋa thoŋgo lolo regha i tholo na i una buruburu, i tholo ele ghamba yaku thovuye na weiye Loi ghamberegha.” ");
INSERT INTO tgo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aleu, mbaro gharavavaghare na Parisi! Taukwana ghemi! Nevole hu thovuyaona! Ghanɨŋga ŋgoreiya utha, njambao na sele, hu vakatha wabwi na wabwiyaworo na hu giya wabwira weya Loi lemi mwaewo, ŋgoreiya mbaro i woraŋgiya. Othembe hu ghambu wagiyawe mbaroko iyako, ko iyemaeŋge hu renuwaŋa valaweya mbaro laghɨlaghɨye na ma hu ghambuŋgi. Mbaro ŋgoranjiya thiyake: la vakatha i rumwaru weŋgiya gharɨgharɨ, gharenda i njaweŋgiya ghandaune na ra ghambuvao Loi. Mbala hu ghambuŋgiya mbaroke thiyake na tembe ŋgoreiyeva ghanɨŋga ghanjimbaro hu ghambuŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ghemi randeviva raraitharɨ na marami i kwaghe! Mbaro nanasiye hu ghambu wagiyaweŋgi, ko iyemaeŋge mbaro laghɨlaghɨye hu renuwaŋa valaweŋgi. Hu woraŋgiya mbilambila e ghamimbwana, ko iyemaeŋge ma hu thuwe kamel mbe umbwara vara hu kovululu weiye ghamimbwana.” ");
INSERT INTO tgo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Aleu, mbaro gharavavaghare na Parisi! Taukwana ghemi! Nevole hu thovuyaona! Ghemi ŋgoramiya gharɨgharɨ thɨ thavwi wagiyawe kom na gaeba vwatanji, ko iyemaeŋge ma thɨ thavwiya tɨnenji. Hu vakatha wagiyaweya vwatanji ko votha na kurakura thɨ riyevanjaraŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ghemi Parisi marami i kwaghe! I viva wo hu thavwi wagiyaweya kom na gaeba tɨnenji ambane vwatanji i thɨna.” ");
INSERT INTO tgo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Aleu, mbaro gharavavaghare na Parisi! Taukwana ghemi! Nevole hu thovuyaona! Ghemi ŋgoramiya ghabubu, thɨ vanamwe vwatae na thɨ kabu jin. Ghayamoyamo i thovuye, ko e tɨneko kaka wokiwokiniye na vwatha i riyevanjara. ");
INSERT INTO tgo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ghemi ŋgoreiye, eto gharɨgharɨ thɨ thuweŋga ŋgoreiya gharɨgharɨ thovuthovuye, ko e gharemina kwan na thanavu raraitharɨ i riyevanjara.” ");
INSERT INTO tgo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Aleu, mbaro gharavavaghare na Parisi! Taukwana ghemi! Nevole hu thovuyaona! Hu vatadɨŋgiya Loi ghalɨŋae gharautu ghabubunji na hu vabithabithaŋaŋgiya gharɨgharɨko me vivako, thiye ghanjithanavu va i rumwaru, ghabubunji, ");
INSERT INTO tgo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","na huŋa thoŋgova hu yaku orumburumbunda e ghanjimbaŋa, mbala mava hu vakatha ŋgoreiya va thɨ vakatha na ma hu gaboŋgiya Loi ghalɨŋae gharautuŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ko iyemaeŋge tembe ghamimberegha hu woraŋgiyaŋga, mbema gheminani orumburumbumiŋgiya iya thiye va thɨ gaboŋgiya Loi ghalɨŋae gharautu. ");
INSERT INTO tgo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ko mbema hu rombele eŋge iya thanavuna orumburumbumi va thɨ vakavakathanawe. Na ne hu vaidiya ghamilithɨwe.” ");
INSERT INTO tgo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ghemi ŋgoramiya mwata na mwata le ŋgaŋga ghemi! Ma tene hu ghaeruva, ghemi kaero inami Gehena. ");
INSERT INTO tgo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iya kaiwae ya dage e ghemi, ne ya variyeŋgiya Loi ghalɨŋae gharautu, rathimbathimba laghɨlaghɨye na ravavaghare e ghemi. Ne hu gaboŋgiya vavana, hu rokrosiŋgiya vavana, hu yabɨbɨŋgiya vavana e ŋgolo kururu tɨne na hu vagevagege loloŋga weŋgi e ghemba na ghemba. ");
INSERT INTO tgo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iyake kaiwae, ne hu vaidiya lithɨ gabo gharɨgharɨ thovuthovuye kaiwanji. Va thɨ unɨghɨkaivara Eibol na i mena le ghambako ghemi Jiu hu unɨghɨ Sakaraiya Barakaiya nariye, e Ŋgolo Boboma na ghamba vowo ghanjilughawoghawo e tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya dage emunjoru e ghemi, vakathako thiyako wolaghɨye ghalithɨ ne i nja weŋga, ghemi thake iyake.” ");
INSERT INTO tgo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O, o Jerusalem ee Jerusalem! Ghemi va hu gaboŋgiya Loi ghalɨŋae gharautu na hu tagavavamareŋgi e varɨ thavala Loi va i variyeŋgi weŋga. Mbaŋa i ghanagha nuwaŋguiya ya mbanvathavathaŋgiya ghanɨrayakuyaku ŋgoreiya kamkam manɨwevo i thogaramuramuŋgiya le ŋgaŋga e vineiye, ko iyemaeŋge ma nuwamiya ya vakatha weŋga. ");
INSERT INTO tgo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Loi ne i garaiteta ghambami na ma kokowa eŋge. ");
INSERT INTO tgo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kaiwae ya dage e ghemi, ma tene hu thuweŋgova gheghada mbaŋa ne huŋa, ‘Loi ghare weya loloke iya i mena Giya Loi e idaeke.’” ");
INSERT INTO tgo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas vama i iteteŋa Ŋgolo Boboma ghayayao mbaŋaniye gharaghambu thɨ menawe na thɨ vatomweya Ŋgolo Bobomako ŋgoloŋgoloniyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iŋa, “Ŋgoreiye, iya hu thuweŋgiya bigibigiko wolaghɨye. Ya dage emunjoru e ghemi, mavole varɨ regha ne i ndeghathɨ ele ghamba ndeghathɨko, wolaghɨyeko nevole thɨ bigiyathuvao bode.” ");
INSERT INTO tgo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas va i yaku Olivɨ e ghanji Ou mbe ghambereghaeŋge na gharaghambu thɨ rakamenawe. Thɨ vaito, thɨŋa, “U utugiya weime ne thembaŋa bigibigike thiyake iya mo utuŋama weime thɨ yomara na thambo nono ne i woraŋgiya weime mbaŋa ne len mena na yambaneke le ghambako?” ");
INSERT INTO tgo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisas i gonjogha weŋgi, iŋa, “Hu njimbukiki wagiyaweŋga, tha lolo regha i yaroŋga. ");
INSERT INTO tgo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kaiwae gharɨgharɨ i ghanagha ne thɨ mena e idaŋgu na thɨŋa, ‘Ghino Mesaiya!’ na ne thɨ yaroŋgiya gharɨgharɨ i ghanagha. ");
INSERT INTO tgo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ne hu loŋweŋgiya vanautuma lenji gaithɨ utuniye na toto gaithɨ kaiwae, ko ne hu ndemararu. Bigibigike thiyake ne thɨ yomara, ko ma ghanjirumwaru ŋgoreiye mbaŋa kaero le ghambako. ");
INSERT INTO tgo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vanautuma ne thɨ vegaithɨ weŋgi; rambarombaro ne thɨ vegaithɨ weŋgi. Nevole vunuvu na ragheragheghe lemoyo e yambaneke laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bigibigike wolaghɨye thiyake ŋgoreiya wevo ŋgamoiye i njivunɨkai vara ghambɨ kaiwae.” ");
INSERT INTO tgo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nevole thɨ laweŋga na thɨ vaŋgugiyaŋga weŋgiya rambarombaro na thɨ gaboŋga. Gharɨgharɨke wolaghɨye ne thɨ botewoyathuŋga idaŋgu kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","E mbaŋako iyako gharɨgharɨ lemoyo ne thɨ botewo lenji loŋweghathɨ na ne thɨ vevatomweŋgi na thɨ vebotewoŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Loi ghalɨŋae gharautu kwanɨkwan lemoyo ne thɨ rakaraŋgi na thɨ yaroŋgiya gharɨgharɨ lemoyo. ");
INSERT INTO tgo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kaiwae tharɨ ghavakatha ne i mbuthu na i yala, gharɨgharɨ lemoyo lenji gharethovu ne i nasiye weŋgiya lenji valɨgharɨgharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ko thela ne i ghataŋaghathɨŋgiya vuyowoke thiyake na gheghada le ghambako ne i vaidiya vamoru. ");
INSERT INTO tgo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na Totoke Thovuye iyake Loi le ghamba mbaro utuutuniye ne thɨ vavaghareŋa e yambaneke laghɨye na gharɨgharɨke wolaghɨye thɨ ghareghare amba muyai mbaŋa le ghambako i mena.” ");
INSERT INTO tgo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mbaŋa ne hu thuweya bigiko i vambɨghɨya Ŋgolo Boboma na i vakatha gharɨgharɨ thɨ roitetako, na i ndeghathɨ ŋgoreiye ma valɨkaiwae i ndeghathɨwe, iya Loi ghalɨŋae gharautu Daniyel va i utuŋama. (Ghemi bukuke iyake gharavavaona wo hu rerenuwaŋa ghaghadɨ nuwamina i rumwaruŋa utuke iyake!) ");
INSERT INTO tgo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","E mbaŋako iyako thavala inanji Judiya e tɨne thɨ rakavo na thɨ wa e ououko rɨgherɨghenji. ");
INSERT INTO tgo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lolo ina ele ŋgolo vwatae na i nja thava i ru e ŋgolo tɨne na i wo bigi regha. Mbema i vo eŋge. ");
INSERT INTO tgo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na lolo i kakaiwo e uma tɨne ne i ndenjogha e ghemba na i liya ghakwama ghayaboyabo. ");
INSERT INTO tgo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ne e mbaŋaŋgiko thiyako, ne i vuyowo laghɨye moli weŋgiya wanakau maramarabo na wanakau weinjiyaŋgiya gamagai amba thɨ thuthu! ");
INSERT INTO tgo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hu naŋgo weya Loi mbala ma hu vo mbaŋa ne njighɨnjighɨ ghambaŋa o ne Sabat. ");
INSERT INTO tgo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Vuyowo ne e mbaŋako iyako ne i laghɨye, i laghɨye moli. Na vuyowoko ŋgoranjiyako ma mbaŋa regha i yomara e yambaneke va i rikowe gheghada noroke, na ma tene ŋgoreiyeva mbaŋa muyai. ");
INSERT INTO tgo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Thoŋgo ma Loi i wonjoŋa mbaŋa le molamolao, mbala ma lolo regha i moru. Ko le tututhi gharɨgharɨniye kaiwae, Loi ne i wonjoŋa vuyowo ghambaŋa le molamolao.” ");
INSERT INTO tgo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Thoŋgo lolo regha i dage e ghemi iŋa, ‘Wo hu thuwe, Mesaiya maiya!’ o ‘Maiyako!’ ne hu ndeloŋweghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kaiwae Mesaiya kwanɨkwan na Loi ghalɨŋae gharautu kwanɨkwan ne thɨ rakaraŋgi na thɨ vakathaŋgiya vakatha ghamba rotaele i ghanagha na thɨ wo gharɨgharɨ nuwanji, na thɨ munje tembe thɨ wova Loi le tututhi gharɨgharɨniye nuwanji. ");
INSERT INTO tgo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wo hu thuwe, amba ŋgaŋgagha kaero ya giya yanawami.” ");
INSERT INTO tgo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Thoŋgo lolo regha i dage weŋga iŋa, ‘Maiyako, e njamnjam bwaga!’ Thava hu wa gheko. O thoŋgo iŋa, ‘Mbeiya e ŋgoloke,’ ne hu ndeloŋweghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kaiwae Lolo Nariye le mena ne ŋgoreiya i vilamema, i vilame yavorowoko na manjamanjalawae i wa ve wo bodeoko.” ");
INSERT INTO tgo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Bigi maremare aŋga inae ma rawowoidi thɨ rakavathavathawe.” ");
INSERT INTO tgo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Vuyowo e mbaŋaŋgiko thiyako e ghereiye varae mara ne i momouwo, manjala mane i mbɨle, ghɨtara ne thɨ dobu e buruburu na buruburu matemate ne thiya nyivɨvao. ");
INSERT INTO tgo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Amba Lolo Nariye le mena ghanono ne i yomara e buruburu, na gharɨgharɨke wolaghɨye e yambaneke thiya randa, mbaŋa ne thɨ thuweya Lolo Nariye i njama e ŋgalɨlɨ vwatanji, weiye le vurɨgheghe na vwenyevwenye laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ne thɨ wiya mema na ghalɨŋae laghɨye moli amba i variyeŋgiya le nyao thovuthovuye e yambaneke ghadidiye gethɨvarɨ na thɨ vaŋguvathavathaŋgiya le tututhi gharɨgharɨniye e yambaneke mbothiye regha gheghada valɨmbothiye.” ");
INSERT INTO tgo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Lemi ghamba ghareghare thovuye hu wo weya umbwa fig. Mbaŋa hu thuwe ndamwandamwa thɨ thalavwara, hu ghareghareya mbaŋa nasiye thuwai ghambaŋa. ");
INSERT INTO tgo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tembe ŋgoreiyeva, mbaŋa ne hu thuweŋgiya bigibigike thiyake thɨ yoyomara, hu ghareghare le njoghama ghambaŋa ma bwagabwaga, maiyavara. ");
INSERT INTO tgo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya dage emunjoru e ghemi thake iyake mamba ne thiya marevao ghaghad bigibigike wolaghɨye thiyake thɨ yomara. ");
INSERT INTO tgo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Buruburu na yambane ne thɨko, ko ghalɨŋaŋguke mane iko.” ");
INSERT INTO tgo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ma lolo regha i ghareghare thembaŋa na the lughawoghawo Lolo Nariye ne i menawe. Nyao thovuthovuye e buruburu ma thɨ ghareghare, Nariye ma i ghareghare, mbe Ramae ghamberegha eŋge i ghareghare ne thembaŋa. ");
INSERT INTO tgo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ghaghad thembaŋa Lolo Nariye ne i mena, gharɨgharɨ ne lenji vakatha ŋgoreiya thɨ vakatha Nowa va ghambaŋa. ");
INSERT INTO tgo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Va e mbaŋaŋgiko thiyako amba muyai ŋgonuŋgo i voru na i thotho, gharɨgharɨ thɨ ghanɨŋga na thɨ munumu, ghɨmoghɨmoru na wanakau thɨ ghe, ghaghad vara e mbaŋaniye Nowa i tha e waŋgama. ");
INSERT INTO tgo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma va thɨ ghareghare, ŋgonuŋgo na thotho raitharɨ regha maiyavara e ghamwanjina. I mena na i gabovaoŋgi. Iyako ne ŋgoreiye mbaŋa Lolo Nariye ne le mena. ");
INSERT INTO tgo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","E mbaŋako iyako ghɨmoghɨmoru thenjighewo ne thɨ kaiwo e uma tɨne: regha ne thɨ yovaŋgu, na regha ne thɨ itete. ");
INSERT INTO tgo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wanakau theunyiwo ne inanji wit ghamba vakatha thɨ vwaŋgoŋgo wit: eunda ne thɨ yovaŋgu na eunda ne thɨ itete. ");
INSERT INTO tgo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iya kaiwae hu njaŋanja, kaiwae ma hu ghareghare thembaŋa ghami Giya ne i mena. ");
INSERT INTO tgo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hu renuwaŋakikiya iyake: thoŋgo ŋgolo tanuwagae va i ghareghareya thembaŋa ghalughawoghawo rakaivɨ ne i vuthawe, ne i njaŋanjaŋa ele ŋgoloko na rakaivɨko tha i ruwe. ");
INSERT INTO tgo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ghemi tembe ŋgoreiyeva hu vivatha na mbema hu roroghagha eŋge, kaiwae Lolo Nariye ne i mena e lughawoghawo, ma hu ghareghare ne i menawe.” ");
INSERT INTO tgo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ghemi mbala ŋgoramiya rakakaiwo i manabu na e ghavareminje iya ghagiya i worawe na i njimbukikiŋgiya rakakaiwo na i giya ghanji, ghanɨŋga e ghambaŋa moli. ");
INSERT INTO tgo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ne i thovuye moli weya rakakaiwoko iyako thoŋgo ghagiya i vutha na i vaidiya i vakatha ŋgoraiyako. ");
INSERT INTO tgo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya dage emunjoru e ghemi, ne i worawe na i mbaroŋaŋgiya le bigibigiko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko thoŋgo iye rakakaiwo raitharɨ ne i renuwaŋa e ghare na iŋa, ‘O giyama mane i vutha rukuruku,’ ");
INSERT INTO tgo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","amba i yabɨbɨŋgiya le valɨrakakaiwoko na i ghanɨŋga na i munumu weiyaŋgiya ramunumu. ");
INSERT INTO tgo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mbaŋa regha rakakaiwoma ghagiya i njoghama, i vathɨna ghare kaiwae rakakaiwoma mane i ghareghare thembaŋa na the lughawoghawo giyama ne i njoghamawe. ");
INSERT INTO tgo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ghagiya ne i vutha i ŋge na i tagavotagamenawe, na i vaŋgurawe gharɨgharɨ raraitharɨ na rakwanɨŋgi e lenji lithɨ ghembaniye, ghakaiwo randa na thɨ rɨghɨmbiya ŋiŋiye.” ");
INSERT INTO tgo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Amba i dage weŋgi iŋa, “E mbaŋako iyako Loi le ghamba mbaro le mena ne ŋgoreiyake. Gagamaina theuyawora thɨ bigiya lenji lemp, thɨ wa na vethɨ roghagha ragheghe ghɨmoru ele ŋgolo ghadidiye. Thɨ roroghaghawe gheghada ragheghe ghɨmoru i njoghama weiye ragheghe wevo na i vaŋguruwoŋgi e ŋgolo tɨne. ");
INSERT INTO tgo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Theulima unounoŋgi na theulima thɨ manabu. ");
INSERT INTO tgo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Unounoŋgima thɨ bigiya lenji lemp, ko ma va thɨ guda ghembwa seiwova, ");
INSERT INTO tgo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ko iyemaeŋge manabuŋgima va thɨ bigiŋgiya lenji lemp weiye ghembwa e variye. ");
INSERT INTO tgo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ragheghe ghɨmoru le vutha va i vuyowo iwaeŋge wanakauma maranji i gaboŋgi na thiya ghenelaŋa.” ");
INSERT INTO tgo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Vama gougou mboro amba lolo regha i mena i kula iŋa, ‘Ragheghe ghɨmoru ma iyake! Hu mena na hu thuwe.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Gagamainama thɨ rakathuweiru na thɨ vakatha wagiyaweŋgiya lenji lemp. ");
INSERT INTO tgo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Amba unounoma thɨ dage weŋgiya manabuma thɨŋa, ‘Hu giyama lemi mbwana seiwo weime kaiwae lama lempɨŋgike ma ma e ghanjimbwa na kaero iya vara thiya mareke.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Thɨ gonjogha weŋgi thɨŋa, ‘Nandere. Ghemi na ghime ma valɨkaiwanda. Wo hu wa e ghamba vamodoko na vou vamodo kaiwami.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ko vamba thɨ loŋgaloŋga mbwa ghavamodo kaiwae, ragheghe ghɨmoru kaero i vutha. Gagamainama va thɨ vivatha wagiyawema thɨ ru weinji ragheghema e thaga tɨne, amba thɨ kiya thɨnɨmba.” ");
INSERT INTO tgo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Muyai gagamaina unounoma thɨ vutha na thɨŋa, ‘Amalana, amalana, u vugha thɨnɨmbana wo ruwo.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Amalama i gonjogha weŋgi, iŋa, ‘Ya dage emunjoru e ghemi, ma ya ghareghareŋga.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Iya kaiwae hu njimbukikiŋga, kaiwae ma hu ghareghare thembaŋa o the lughawoghawo ghamigiya ne i menawe.” ");
INSERT INTO tgo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“E mbaŋako iyako Loi le ghamba mbaro le mena ne ŋgoreiya amala regha i wareriŋa valɨvaŋga regha. I kula vathaŋgiya le rakakaiwo na i giya le bigibigiko weŋgi thɨ njimbukiki. ");
INSERT INTO tgo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I giyawa regha paeb tausan kina, theghewoniye tu tausan kina na theghetoniye wan tausan kina. I giya ŋgoreiya regha na regha le ghareghare le laghɨlaghɨye, amba muyai i wareri. ");
INSERT INTO tgo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Amalama me mbana paeb tausanɨma i wa e mbaŋako iyako na ve vakaiwoŋa na tembe i vaidiva paeb tausan kina. ");
INSERT INTO tgo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Amalama me mbana tu tausanɨma i vakatha ŋgoreiye na tembe i vaidiva tu tausan kina. ");
INSERT INTO tgo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ko amalama me mbana wan tausanɨma, i wa ve tɨgha doda e thelau na i beku ghagiyama le maniwe.” ");
INSERT INTO tgo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Vama mbaŋa molao amba giyama i njogha, i dage weŋgi na thɨ utugiyawe ŋgoroŋga va thɨ vakaiwoŋa na thɨŋa le maniko. ");
INSERT INTO tgo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Amalama iyava i mbana paeb tausanɨma weiye mbowo paeb tausanɨva e vwatae i mena i giyawe na i dagewe iŋa, ‘Amalana, va u giya paeb tausan e ghino. Wo u thuwe, vama ya vaidiva paeb tausan.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Giyama i dagewe, iŋa, ‘I thovuye moli! Rakakaiwo thovuye na emunjoru ghen. Bigibigi ma thɨ ghanagha u njimbukiki wagiyaweŋgi. Ne ya woraweŋge na u njimbukikiŋgiya bigibigi thɨ ghanagha. U mena weiŋgu ghen ra warari.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Amalama va i mbana tu tausanɨma i mena na iŋa, ‘Amalana, va u giya tu tausan e ghino. Wo u thuwe, vama ya rovaidiva tu tausan.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Giyama i dagewe, iŋa, ‘I thovuye moli! Rakakaiwo thovuye na emunjoru ghen. Bigibigi ma thɨ ghanagha u njimbukiki wagiyaweŋgi. Ne ya woraweŋge u njimbukikiŋgiya bigibigi thɨ ghanagha. U mena weiŋgu ghen ra warari.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Amba amalama va i mbana wan tausanɨma i mena iŋa, ‘Amalana, ya ghareghare len mbaro i vurɨgheghe kaiwae thebigiya ma va u ghavo u tɨghɨ na u vathe e len ŋgolo. Gharɨgharɨ vavana lenji kaiwo une ghen u mban. ");
INSERT INTO tgo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iya kaiwae va ya mararu na ya wa na va beku len manina e thelau. Wo u thuwe len manima mbe iya, ya biginjogha e ghen.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Giyama i dagewe iŋa, ‘Rakakaiwo raitharɨ na njavovo ghen. Kaero u ghareghare, thebigiya ma va ya ghavo ya tɨghɨ na ya vathe elo ŋgolo na gharɨgharɨ vavana lenji kaiwo une ghino ya mban. ");
INSERT INTO tgo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ko iyake, mbalava vo bigiraweya lo manike e beŋɨk na thɨ vakaiwoŋa na mbaŋa ya njoghama ya mban njogha weiye vavanava e vwatae.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“I dage weŋgiya rakakaiwo vavanava, iŋa, ‘Hu bigiya maninawe na hu bigigiya weya amalana iya ten tausana inawe. ");
INSERT INTO tgo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Thela i vakaiwoŋa wagiyaweya ghabebeko, ghino ya vatabowe na iye veimaima. Ko iyemaeŋge weya thela ma e ghavareminje, othembe nasiye moli inawe, ya bigivaowe. ");
INSERT INTO tgo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ko iya rakakaiwoke raitharɨ iyake, hu wokiyathu eto, e mouwoko tɨne na ghakaiwo randa na i rɨghɨmbiya ŋiŋiye.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mbaŋa Lolo Nariye ne i mena weiyaŋgi nyaoko thovuthovuye wolaghɨye, na amalaghɨniye i tabo na kiŋ, ne i yaku ele ghamba yaku thovuye na i mbaro. ");
INSERT INTO tgo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yambaneke laghɨye gharɨgharɨniye ne thɨ mevathavatha e marae na i vaghathaŋgi na wabwi theghewo, ŋgoreiya sip gharanjimbunjimbu i ghathaŋgiya sip na gout tomethi lenji yaku. ");
INSERT INTO tgo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne i bigiraweŋgiya sip e une na gout e moiye.” ");
INSERT INTO tgo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Amba Kiŋ i dage weŋgiya gharɨgharɨ inanji e uneko iŋa, ‘Hu rakamena, thavala ghemi Bwebwe i mwaewo weŋga. Hu mena hu rakaru ele ghamba mbaroke, iyava i vivatharaweke kaiwami mbaŋa va i vakatha yambaneke. ");
INSERT INTO tgo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kaiwae bada i gharɨŋgo na hu giya ghanɨŋga e ghino, mbwa i gharɨŋgo na hu giya e ghino na ya mun, bobwariya ghino na hu kulavoreŋaŋgo e lemi ŋgolo, ");
INSERT INTO tgo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ya bukabuka na hu giya kwama weŋgo, ya ghambwera na hu njimbukikiŋgo, inaŋgu e thiyo na hu mena hu thuweŋgo.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Amba gharɨgharɨko thovuthovuye ne thɨ gonjoghawe thɨŋa, ‘Amalana, thembaŋa va wo thuweŋge bada i gharɨŋge na wo giya ghanɨŋga na u ghan, o mbwa i gharɨŋge na wo giya mbwa e ghen? ");
INSERT INTO tgo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na thembaŋa va wo thuweŋge u mebobwari na wo kulavoreŋaŋge, o u bukabuka na wo ligiya kwama na u njimbo? ");
INSERT INTO tgo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na va thembaŋa wo thuweŋge u ghambwera o inan e thiyo na wo ghaona wo thuweŋge?’” ");
INSERT INTO tgo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Kiŋ ne i gonjogha weŋgi iŋa, ‘Ya dage emunjoru e ghemi, thembaŋa thoŋgo hu vakatha bigi regha weya oghaghaŋguŋgike regha iya idae ma i laghɨye, ŋgoreiya hu vakatha weŋgo.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Amba ne i dage weŋgiya thiye inanji e moiyeko iŋa, ‘Hu rakaiteteŋgo, ghemi iya valɨkaiwae hu vaidiya lithɨ weya Loi. Hu rakawa e ndɨgheko une iya memeghabananiyeko, iyava Loi i vivatharaweko Seitan na le nyao kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kaiwae bada i gharɨŋgo na ma hu giya ghanɨŋga weŋgo, mbwa i gharɨŋgo na ma hu giya mbwa weŋgo, ");
INSERT INTO tgo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","bobwariya ghino na ma hu kulavoreŋaŋgo e lemi ŋgolo, ya bukabuka na ma hu giya kwama weŋgo, ya ghambwera na inaŋgu e thiyo na ma hu mena hu njimbukikiŋgo.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Thiye tembe thɨ thombeweva thɨŋa, ‘Amalana, va thembaŋa wo thuweŋge bada o mbwa i gharɨŋge, o u mebobwari o u bukabuka o inan e thiyo, na ma wo thalavuŋge?’” ");
INSERT INTO tgo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ne i thombe weŋgi na iŋa, ‘Ya dage emunjoru e ghemi, thembaŋa hu botewo hu thalavugha oghaghaŋguŋgike iya nanasiyeke thiyake iya hu yaŋgiwanaŋgike regha ŋgoreiya hu botewo hu thalavuŋgo.’” ");
INSERT INTO tgo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Thiyake ne vethɨ vaidiya vuyowoko iya ma mbaŋa regha ne i koko na gharɨgharɨ thovuthovuye ne vethɨ vaidiya yawalɨ moli.” ");
INSERT INTO tgo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mbaŋa Jisas i utuvao utuutuko wolaghɨye, i dage weŋgiya gharaghambu, iŋa, ");
INSERT INTO tgo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kaero hu ghareghare, mbaŋa ma theghewo eŋge kaero Thaga Valaŋani ghambaŋa, na ne e mbaŋako iyako tɨne thɨ vaŋgugiya Lolo Nariye na thɨ ŋge e kros.” ");
INSERT INTO tgo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","E mbaŋako iyako ravowovowo laghɨlaghɨye na Jiu lenji randevivaŋgi thɨ mevathavatha ravowovowo laghɨlaghɨye lenji randeviva idae Kaiyapas ele ŋgolo ");
INSERT INTO tgo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","na thɨ vona Jisas ghae ŋgoroŋga ne thɨŋa na thɨ yalawe thuwele na thɨ tagavamare. ");
INSERT INTO tgo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Thɨŋa, “Thava ra vakatha e thagake iyake tɨne, ne iwaeŋge gharɨgharɨ gharenji i muru na thɨ gaithɨ.” ");
INSERT INTO tgo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas vamba i yaku Betani Saimon ele ŋgolo, iye va i ghataŋa lepelo. ");
INSERT INTO tgo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wevo eunda i menawe, i thɨna bodɨla alabasita vwarara, bunama butiye thovuye na modae laghɨye inawe. Mbaŋa Jisas vamba i ghanɨŋga, i liŋgiya bunamama e umbaliye. ");
INSERT INTO tgo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ko mbaŋa gharaghambuko thɨ thuweya iyako gharenji i gaithɨ. Thɨŋa, “Buda kaiwae i vakowana bunamako? ");
INSERT INTO tgo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Thoŋgo ra vakuneŋa bunamako iyako ne ra vaidiya mani laghɨye na ra giya weŋgiya mbinyembinyeŋgu.” ");
INSERT INTO tgo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas i ghareghareya lenji renuwaŋako, amba i dage weŋgi, “Buda kaiwae hu liya wevoke ghautu? Vakatha thovuye moli iya me vakathake weŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mbaŋake wolaghɨye ne weimiyaŋgiya mbinyembinyeŋgu ko ghino mane weiŋguyaŋgiya ghemi mbaŋake wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Me ruvuya bunamake iyake e riwaŋgu. Iyako ŋgoreiye kaero me vivatha riwaŋgu beku kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya dage emunjoru e ghemi, nevole thembaŋa thɨ vavaghareŋa Totoke Thovuye iyake e yambaneke laghɨye, budakaiya wevoke iyake me vakatha gharɨgharɨ ne thɨ utuŋa na thɨ renuwaŋakikiya elaghɨniye.” ");
INSERT INTO tgo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Amba gharaghambuko theyaworo na theghewoko regha, idae Judas Isakariyot, i wa weŋgiya ravowovowo laghɨlaghɨye ");
INSERT INTO tgo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na iŋa, “Ne hu wogiya budakai weŋgo thoŋgo ya vatomweya Jisas weŋga na hu yalawe?” Thɨ vaona silva gethɨyeto (30) na mbala thɨ giya modae. ");
INSERT INTO tgo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","E mbaŋako iyako na i voro Judas i tamwetamweya kamwathɨ, ŋgoroŋga ne iŋa na i vatomwe weŋgi na thɨ yalawe. ");
INSERT INTO tgo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mbaŋa iviva moli Bred ma weiye isɨt ghathaga ghambaŋa, gharaghambu thɨ menawe na thɨ vaito thɨŋa, “Nuwaniya wo wa e the valɨvaŋga na vo vivatharaweya Thaga Valaŋani ghanɨŋganiye kaiwan?” ");
INSERT INTO tgo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","I gonjogha weŋgi iŋa, “Hu wa vohu ru Jerusalem e tɨne, weya amala regha, na hu dagewe huŋa, ‘Ravavaghare iŋa: Wombaŋa maiyavara. Weiŋguyaŋgiya woraghambuke wo vakatha Thaga Valaŋani ghanɨŋganiye e len ŋgolona.’” ");
INSERT INTO tgo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gharaghambuma thɨ vakatha ŋgoreiya me dagema weŋgi na thɨ vivatharaweya Thaga Valaŋani ghanɨŋganiyewe. ");
INSERT INTO tgo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Vama gougou amba Jisas weiyaŋgiya gharaghambuma theyaworo na theghewoma thiya yaku na thiya ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ghanɨŋga e tɨne Jisas i dage weŋgi iŋa, “Ya dage emunjoru e ghemi, regha ina e tɨnemike ne i vatomweŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Gharenji i vɨrɨ laghɨye na thɨ dagewe, regha na regha iya i vaito iŋa, “Amalana, ma ghino ŋgoreiye, ae?” ");
INSERT INTO tgo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisas i gonjogha weŋgi iŋa, “Ghemina regha iya me wouta ghabredɨna weiŋgu e gaeba regha, iye ne i vatomweŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lolo Nariye ne i mare ŋgoreiya Buk Boboma le woraŋgiya, ko loloko iya ne i vatomweya Lolo Nariye ne i vaidiya vuyowae. I thovuye moliwa loloko iyako thoŋgo tɨnae ma va i ghambɨ eŋge.” ");
INSERT INTO tgo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Amba Judas, iya ne i vatomweya Jisas, iŋa, “Ravavaghare, ma ghino ŋgoreiye, ae?” Jisas i dagewe, iŋa, “Kaero mo utuŋa na len utuna emunjoru.” ");
INSERT INTO tgo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mbaŋa thiya ghanɨŋga, Jisas i wo bred mbumbura, i vata ago weya Loi, i njiviyaviya na i giya weŋgiya gharaghambuma, na iŋa, “Hu wo na hu ghan. Iyake riwaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Amba i thɨna kom na tembe i vata ago weva Loi, i thɨnɨgiya weŋgi, na iŋa, “Taulaghɨna ghemi hu mun, ");
INSERT INTO tgo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","waenɨke iyake madɨbaŋgu iye i vaemunjoruŋa dagerawe togha. I voruraŋgi na mbala Loi i numotena gharɨgharɨ lemoyo lenji tharɨ. ");
INSERT INTO tgo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya dage e ghemi, ma tene ya munɨva waenɨke iyake gheghada ne ya munɨva waen togha weiŋguyaŋgiya ghemi Bwebwe ele ghamba mbaro tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mbaŋa thɨ wothuvao wothu yaŋgara, thɨ rakaraŋgi na thɨ raka Olivɨ e ghanji Ou. ");
INSERT INTO tgo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Amba Jisas i dage weŋgi iŋa, “Gougouke noroke taulaghɨna ghemi ne hu vo iteteŋgo, kaiwae Buk Boboma iŋa, ‘Ne ya unɨgha sip ghanjiranjimbunjimbu na sip thɨ rakavo.’ ");
INSERT INTO tgo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ko amba Loi ne i vakathaŋgo na ya thuweiru na e yawayawaliŋgu, ne ya viva e ghamwami Galili.” ");
INSERT INTO tgo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita i gonjoghawe iŋa, “Othembe taulaghɨke ne thɨ rakavo, ghino mane ya voiteteŋge.” ");
INSERT INTO tgo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisas i dagewe, iŋa, “Ya dage emunjoru e ghen, noroke gougou amba muyai kamkam i dage mbaŋaiwo, mbaŋato ne uŋa ma u ghareghareŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita i dagewe iŋa, “Mane yaŋa ma ya ghareghareŋge, othembe thoŋgo ne ya mare weiŋgu ghen.” Gharaghambuko wolaghɨye thɨ gorereya. ");
INSERT INTO tgo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas weiyaŋgiya gharaghambu thɨ wa e valɨvaŋga idae Getesemani, amba i dage weŋgi iŋa, “Huya yaku gheke, na ya wa na va naŋgo gheko.” ");
INSERT INTO tgo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","I vaŋguŋgiya Pita na Sebedi le ŋgaŋgama thenjighewoma. Ghare i vɨrɨ laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Amba i dage weŋgi, iŋa, “Ghareŋgu i vɨrɨ laghɨye moli, mbalama i tagavamareŋgo. Hu yaku gheke na hu njaŋanjaŋa.” ");
INSERT INTO tgo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I loŋga ghaova seiwo, i dipoumu e thelauko vwatae na i naŋgo iŋa, “Bwebwe, thoŋgo valɨkaiwae, u vakathaŋgo na vuyowoke ghandeghɨ iyake thava i mena weŋgo. Ko iyemaeŋge thava u vakatha ghino lo renuwaŋa, u vakatha eŋge ghen len renuwaŋa.” ");
INSERT INTO tgo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Amba i njogha weŋgiya gharaghambuma thenjighetoma na i vaidiŋgi thiya ghena. I dage weya Pita, iŋa, “Ko ma valɨkaiwae hu njaŋanjaŋa lughawoghawo regha? ");
INSERT INTO tgo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hu njaŋanjaŋa na hu naŋgo, mbala ma hu ru tanathetha e tɨne. Ghare nuwaiya, ko ririwo i njavovo.” ");
INSERT INTO tgo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mbowo i wava mbaŋaiwoniye na ve naŋgo iŋa, “Bwebwe, thoŋgo len renuwaŋa ya muna vuyowoke ghakom iyake na ma valɨkaiwae i iteteŋgo, ko mbema u vakatha ŋgoreiye iya len renuwaŋana.” ");
INSERT INTO tgo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mbaŋa i njoghama, tembe i vaidiŋgiva thɨ ghenelaŋa, kaiwae mara ghenaghena i gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","I iteteŋgi na mbowo ve naŋgova mbaŋatoninji. I naŋgo na tembe ŋgoreiyeva me naŋgoma. ");
INSERT INTO tgo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mbowo i njogha weŋgiva gharaghambuma na i dage weŋgi iŋa, “Ko amba hu ghenaghena vara mbaŋake molao? Wo hu thuwe, mbaŋa kaero iko; e mbaŋake vara thɨ vaŋguraweya Lolo Nariye tharɨ gharavakatha e nɨmanji ghare. ");
INSERT INTO tgo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hu yondo na ra raka. Wo hu thuwe, loloma wolilivama maiyavara i menana!” ");
INSERT INTO tgo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas vamba i utuutu kaero Judas, gharaghambuma theyaworo na theghewoma regha, i vutha weiyaŋgiya wabwi laghɨye regha, thɨ mbanɨŋgiya gaithɨ ghaghalithɨ na umbwaumbwa uboubotu. Gharɨgharɨke thiyake, ravowovowo laghɨlaghɨye na Jiu lenji randeviva methɨ variyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lilivama vama i giya nono weŋgi, iŋa, “The lolo ne ya vandamo, ee amalaghɨniye; hu yalawe.” ");
INSERT INTO tgo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas i vamwandɨ weya Jisas na iŋa, “Ago laghɨye Ravavaghare!” Na i vandamo. ");
INSERT INTO tgo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas i dagewe, “Wou, budakai kaiwae mo menake u vakatha.” Gharɨgharɨma thɨ rakamena na thɨ yalawe. ");
INSERT INTO tgo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gharaghambuma regha i mwanagita le gaithɨ ghaghalithɨ e ghambae na i gothethe ravowovowo laghɨlaghɨye lenji randeviva le rakakaiwo regha yanawae. ");
INSERT INTO tgo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisas i dagewe iŋa, “U woraweya len gaithɨna ghaghalithɨ e ghambae, kaiwae thela thoŋgo i gaithɨ e ghalithɨ ne thɨ unɨghɨ e ghalithɨ. ");
INSERT INTO tgo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ko ma hu ghareghare valɨkaiwaŋgu moli ya kula weya Bwebwe thalavu kaiwae na e mbaŋako iyako, i variyeŋgiya le nyao thovuthovuye ghanjiwabwi laghɨlaghɨye kaiwaŋgu? ");
INSERT INTO tgo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ko thoŋgo ya vakatha ŋgoreiyako mane i vaemunjoruŋa Buk Boboma le utu, iya i woraŋgiya budakaiya kaero i yomara e mbaŋake iyake.” ");
INSERT INTO tgo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","E mbaŋako iyako Jisas i dage weŋgiya wabwima iŋa, “Mouŋa eŋge rakaiva ghino iya mohu mbanɨŋgiya gaithɨ na ghaghalithɨ na umbwaumbwa uboubotu na hu mena hu yalaweŋgo? Mbaŋa regha na regha ya yaku e Ŋgolo Boboma tɨne na ya vavaghare, ma va hu yalaweŋgo. ");
INSERT INTO tgo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bigibigike wolaghɨye thiyake thɨ yomara na thɨ vaemunjoruŋa budakaiya Loi ghalɨŋae gharautu va thɨ rori Buk Boboma e tɨne.” E mbaŋako iyako gharaghambu thɨ voiteteŋa. ");
INSERT INTO tgo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Thiyema methɨ yalawe Jisas thɨ yovaŋgu Kaiyapas ele ŋgolo, iye ravowovowo laghɨlaghɨye lenji randeviva. Mbaro gharavavaghare na Jiu lenji randeviva vama thɨ mevathavatha gheko. ");
INSERT INTO tgo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita i rereghamba weya Jisas, vambe ina bwagabwaga, ghaghad thɨ vutha ravowovowo laghɨlaghɨye lenji randeviva e ghayayao. Pita i ru e yayaoko tɨne na i yaku weiyaŋgiya ragatɨgatɨ. Nuwaiya i thuwe ne thɨ vakatha budakai weya Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ravowovowo laghɨlaghɨye weinjiyaŋgiya Jiu lenji rambarombaro Jiu e lenji kot laghɨye tɨne, thɨ tamweŋgiya utu kwanɨkwan Jisas ghawonjowe kaiwae, mbala lenji rɨghe na thɨ unɨgha Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko iyemaeŋge ma thɨ ndevaidi mun, othembe rautu kwanɨkwan vavana thɨ mena thɨ utuŋaŋgiya lenji kwanɨŋgi. Muyai amba thenjighewo thɨ mena, ");
INSERT INTO tgo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na thɨŋa, “Amalake iyake iŋava valɨkaiwae ne i rakayathu Loi le Ŋgolo Boboma na mbaŋa thegheto e tɨne kaero i vatadɨva.” ");
INSERT INTO tgo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Amba ravowovowo laghɨlaghɨye lenji randeviva i yondovirɨ na i dage weya Jisas iŋa, “Ko mane u gonjogha lenji utuko ghathɨthɨ? Ŋgoroŋga lenji utuko gharumwaru e ghen?” ");
INSERT INTO tgo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ko iyemaeŋge Jisas ma i ndeutu mun. Ravowovowo laghɨlaghɨye lenji randeviva i dagewe iŋa, “Loi e yawayawaliye e idae ya naŋgo e ghen na u dage weime, thoŋgo emunjoru ghen Mesaiya, Loi Nariye.” ");
INSERT INTO tgo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas i gonjoghawe iŋa, “Ŋgoreiye iya moŋana. Ko ya dage e ghemi, mbaŋa i menamenako ne hu thuwe Lolo Nariye, ne i yaku Loi Vurɨgheghe e une na i njama e ŋgalɨlɨko e buruburu.” ");
INSERT INTO tgo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ravowovowo laghɨlaghɨye lenji randeviva i mwanathethe ghakwama ghatemuru kaiwae na iŋa, “I utuvatharɨ Loi kaiwae. Ma te nuwandaiyava gharɨgharɨ vavana thɨ utu kaiwae. Kaero mohu loŋweya le utuko, me utuvatharɨ weya Loi. ");
INSERT INTO tgo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ŋgoroŋga lemi renuwaŋa?” Thɨ gonjoghawe thɨŋa, “Valɨkaiwae moliya i mare!” ");
INSERT INTO tgo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Amba thɨ njoŋgovuna ghamwae na thɨ ŋge. Vavana thɨ tagaleva ");
INSERT INTO tgo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na thɨŋa, “Mesaiya ghen? U dage weime thoŋgo Loi ghalɨŋae gharautu ghen, thela me ŋgeŋgeŋaŋgena.” ");
INSERT INTO tgo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita vambe ina e yayaoko tɨne amba rakakaiwo eunda i menawe na i dagewe iŋa, “Ghen ŋgoreiye, vambe weinɨva Jisas rara Galili.” ");
INSERT INTO tgo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gharɨgharɨko taulaghɨ e maranji i roro iŋa, “Ma ya ghareghare budakaiya utuniye u utuutuna.” ");
INSERT INTO tgo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Seiwo i loŋgaraŋgi ŋgoreiya yayaoko ghaghamba ru, rakakaiwo eunda i thuweya Pita i amba i dage weŋgiya gharɨgharɨko inanjiko gheko iŋa, “Amalake iyake va weiye Jisas rara Nasaret.” ");
INSERT INTO tgo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mbaŋaiwoniye Pita i roro iŋa ma i ghareghare Jisas. I tholo iŋa, “Ma ya ghareghare iya lolona iyana.” ");
INSERT INTO tgo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mbaŋa ma molao, gharɨgharɨma thiya ndeghathɨma gheko thɨ mena weya Pita na thɨŋa, “Mbema emunjoru Jisas ghauneko regha ghen, kaiwae ghalɨŋanɨna ghaŋgumi i woraŋgiya, ghen rara Galili.” ");
INSERT INTO tgo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita i tholomundu iŋa, “Ya dage emunjoru. Loloko iyako ma ya ghareghare. Loi i lithɨ e ghino thoŋgo ma ya utuŋa emunjoru.” E mbaŋako iyako kamkam i kula, ");
INSERT INTO tgo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","amba Pita i renuwaŋakiki Jisas ghalɨŋaema: “Amba muyai kamkam i kula; mbaŋato ne uŋa ma u ghareghareŋgo.” Pita i raŋgi eto na ve randa laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Vambe mbaŋambaŋa moli ravowovowo laghɨlaghɨye na Jiu ghanjigiyagiya thɨ vakatha lenji mbaro Jisas le mare kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Thɨ ŋgarɨ na thɨ yovaŋgu weya Pailat, Rom ghagawana. ");
INSERT INTO tgo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mbaŋa Judas, Jisas ghaliliva, i loŋwevaidiya Jisas vama thɨŋa ne i mare, i nuwonjogha na i biginjogha mani gethiyeto weŋgiya ravowovowo laghɨlaghɨye na giyagiya vavana. ");
INSERT INTO tgo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas i dage weŋgi, iŋa, “Ma vakatha tharɨ kaiwae ma vatomweya amala ma ele tharɨ na thɨ unɨghɨ.” Thɨ dagewe, thɨŋa, “Ma wo rerenuwaŋa kaiwae. Tembe ghen ghanɨmberegha.” ");
INSERT INTO tgo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas i bigiyathu manima e Ŋgolo Boboma tɨne na i wa na ve gadesowo. ");
INSERT INTO tgo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Amba ravowovowo laghɨlaghɨye thɨ mbana manima na thɨŋa, “Manike iyake madibe inawe na la mbaro i dageten ra bigirawe weiye Ŋgolo Boboma ghamani.” ");
INSERT INTO tgo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Thɨ vakatha manima ghambaro, thɨ mban na thɨ vamodo thelauwe bobwari lenji ghabubu kaiwae. Thɨ vamodo weya uye gharamonjemonje. ");
INSERT INTO tgo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iya kaiwae thelauko iyako thɨ una idae Madibe Thelauniye gheghada noroke. ");
INSERT INTO tgo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mbaŋa va thɨ vakatha iyako, Loi ghalɨŋae gharautu, Jeremaiya, le utu i tabo na emunjoru, iŋa, “Thɨ mbana silva gethɨyeto (30), Isirel gharɨgharɨniye vavana va thɨ vatomwe na loloko iyako ghavanjo ");
INSERT INTO tgo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na thɨ vamodo uyema gharamonjemonje le thelauwe, ŋgoreiya Loi le utu weŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas i ndeghathɨ Pailat e ghamwae, iye Rom ghagawana, amba i vaito iŋa, “Ghen Jiu lenji kiŋa ghen?” Jisas i gonjoghawe iŋa, “Ŋgoreiya iya moŋana.” ");
INSERT INTO tgo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ko iyemaeŋge mbaŋa ravowovowo laghɨlaghɨye na Jiu ghanjigiyagiya methɨ wonjowe ma me ndegolambo mun. ");
INSERT INTO tgo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Amba Pailat i dagewe iŋa, “Thare u loŋwe bigibigi lemoyo kaiwanji iya thɨ wonjoweŋgenawe?” ");
INSERT INTO tgo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ko Jisas mava i gonjogha lenji utuko mun, iya kaiwae Pailat ghare va i yo. ");
INSERT INTO tgo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Theghathagha regha na regha Thaga Valaŋani e tɨne, rayakuyaku e thiyo regha iya gharɨgharɨ thɨ tuthigiya weya Pailat na i vaŋguraŋgiya kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E mbaŋako iyako amala regha va ina e thiyo, idae Barabas, amalaghɨniye ghathanavu raitharɨ moli. ");
INSERT INTO tgo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mbaŋa wabwi laghɨye thɨ mevathavatha amba Pailat i vaitoŋgi iŋa, “Thela nuwamiya ya rakayathu kaiwami? Barabas o Jisas iya thɨŋake Mesaiya?” ");
INSERT INTO tgo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I dage ŋgoreiyako kaiwae va i ghareghare wagiyawe Jiu lenji randeviva thɨ yamwakabu Jisas kaiwae iyava thɨ vaŋgugiyakowe. ");
INSERT INTO tgo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat vamba ina e ghamba kot kaero levo i variya toto iŋa: “Lolona iyana ma ele tharɨ. Ne u ndevakatha bigi reghawe kaiwae me gougou ma ghenelola gheneloloniye na i vakathaŋgo ya mararu laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ravowovowo laghɨlaghɨye na Jiu ghanjigiyagiya thɨ vokomukomuŋgi wabwiko laghɨye na thɨ naŋgo weya Pailat i rakayathu Barabas na iŋa na thɨ unɨgha Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailat i vaitoŋgi iŋa, “Iya thenjighewoke, thela nuwamiya ya rakayathu kaiwami?” Thɨŋa, “Barabas.” ");
INSERT INTO tgo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mbowo i vaitoŋgiva iŋa, “Ne ya vakatha budakai weya Jisas iya thɨŋake Mesaiya?” Taulaghɨko thɨŋa, “U rokros!” ");
INSERT INTO tgo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat i vaitoŋgi iŋa, “Ko loloke iyake va i vakatha vara thambo tharɨ?” Ma thɨ kula na ghalɨŋanji laghɨye eŋge thɨŋa, “U rokros!” ");
INSERT INTO tgo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat vama i ghareghare ma te valɨkaiwaeva i vakatha renuwaŋa regha na wabwiko laghɨye mbalavama thɨ vakatha gaithɨ, amba i thɨna mbwa na i thavwiya nɨmae wabwiko laghɨye e maranji na iŋa, “Loloke iyake le mare wonjoweniye thava ne i mena weŋgo. Tembe hu kwalavi.” ");
INSERT INTO tgo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Taulaghɨko thɨŋa, “Le marena wonjoweniye i mena weime na lama ŋgaŋga weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Amba Pailat i rakayathu Barabas kaiwanji na iŋa na ragagaithɨ thɨ liya thiyo weiye bigibigi vurɨgheghe nanji e thiyoko na thɨ yabɨbɨwe amba i vaŋgugiya weŋgi na thɨ ŋge e kros. ");
INSERT INTO tgo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pailat le ragagaithɨ thɨ yovaŋguya Jisas e gawana ele ŋgolo ghayayao amba ragagaithɨko wolaghɨye thɨ mevathavatha na thɨ meghɨliŋa Jisas. ");
INSERT INTO tgo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Thɨ bigiraŋgiya ghakwama na thɨ vanjimbo e kwama sosoro na molao, ŋgoreiya kiŋ ghakwama. ");
INSERT INTO tgo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Thɨ vona umbwa ele kinkin yaŋgae na thɨ thɨnɨrawe e umbaliye na thɨ wo umbwa na thɨ worawe e nɨmaeko e uneko, ŋgoreiya kiŋ ghavakavakatha amba thɨ ronja e ghenji vuvuye na thɨ vatabweruŋa thɨŋa, “O Jiu lenji Kiŋ, len mbaro ne i meghabana!” ");
INSERT INTO tgo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Thɨ njoŋgovunɨvun na thɨ wo umbwama na thɨ ŋgeŋgeŋa umbaliye. ");
INSERT INTO tgo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mbaŋa thɨ vatabweruŋako na e ghereiye, thɨ liraŋgiya kwamama sosoroma na thɨ vanjimbo amalaghɨniye e ghakwamaŋgima. Amba thɨ vaŋguraŋgiya na thɨ yovaŋgu vethɨ rokros. ");
INSERT INTO tgo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mbaŋa vama vethɨ vaŋguraŋgiya na ma vethɨ loŋgaloŋga amba thɨ lavolevola lolo regha, rara Sairin idae Saimon. Ragagaithɨma thɨ vavurɨghegheŋa na i wo Jisas ghakros. ");
INSERT INTO tgo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Thɨ vutha e valɨvaŋga regha idae Golgota. Golgota gharumwaru ŋgoreiya “Boutouto Ghambae”. ");
INSERT INTO tgo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bigi regha iye i maŋge thɨ liŋgirawe weiye waen thɨ thɨnɨgiya weya Jisas na i mun. Mbaŋa i ghamɨno na i maŋge, i botewoyathu. ");
INSERT INTO tgo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mbaŋa thɨ ŋge e krosɨko vwatae, amba thɨ wobwiya ghakwamakwamama. Thɨ mbana varɨvarɨ na thɨ mwadiwo mwadiwo reghawe. Thela thoŋgo i wo varɨko iya e ghanonoko amba i tuthi iyaŋganiya i bigi. ");
INSERT INTO tgo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Amba thiya yaku gheko na thɨ njimbukiki. ");
INSERT INTO tgo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Thɨ liya ghawonjoweko, vama thɨ rori, na thɨ ŋge e umbaliye na yavoro, iŋa, Iyake Jisas, Jiu lenji Kiŋ. ");
INSERT INTO tgo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Thɨ rokrosiŋgiya rakaivɨ thenjighewo weiyaŋgi, regha e une na regha e moiye. ");
INSERT INTO tgo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gharɨgharɨ thɨ rakarakareŋa evasiwae thɨ wovanukunukuya umbalinji na thɨ goviyaviya ghamwae, ");
INSERT INTO tgo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","thɨŋa, “Va uŋa ne u tagarakaraka Ŋgolo Boboma na mbaŋa thegheto e tɨne kaero u vatadɨva. Thoŋgo Loi Nariya ghen, tembe u vamora ghanɨmberegha. U roiteta krosɨna na u njama.” ");
INSERT INTO tgo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ravowovowo laghɨlaghɨye, mbaro gharavavaghareŋgi na Jiu ghanjigiyagiya vambe thɨ goviyaviyava ghamwae ŋgoreiyake. ");
INSERT INTO tgo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Thɨŋa, “I vamoruŋgiya gharɨgharɨ mbe vavana, ko ma valɨkaiwae i vamoru ghamberegha! Iye Israel lenji Kiŋ, ae? Tembe ghamberegha i njama e krosɨko, ambane wo loŋweghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I vareminja Loi. Wo ra thuweno, thare Loi ne i thalavu, kaiwae iŋa, ‘Loi Nariya Ghino!’” ");
INSERT INTO tgo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Rakaivɨŋgiko iyava thɨ rokrosiŋgiko weiyaŋgi, thiye vambe thɨ yaŋgiwanava ŋgora iyako. ");
INSERT INTO tgo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ghararaghɨye mboro ghaghad tɨri klok, vanautumako laghɨye i mouwo. ");
INSERT INTO tgo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tɨri klok ele valɨvaŋga Jisas i kula na ghalɨŋae laghɨye iŋa, “Eloi, Eloi, lama sabakɨtani?” gharumwaru “Lo Loi, Lo Loi, buda kaiwae u iteteŋaŋgo?” ");
INSERT INTO tgo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gharɨgharɨko iyava thiya ndeghathɨko gheko thɨ loŋweya iyako na vavana thɨŋa, “I kula weya Ilaija iyako.” ");
INSERT INTO tgo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","E mbaŋako iyako, regha i ruku na i liya vune i liutu e waen monyomonyo na i lira e umbwa mbothiye, amba i livoreŋa na Jisas i mun. ");
INSERT INTO tgo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ko iyemaeŋge vavana thɨŋa, “Wo ra roroghagha! Wo ra thuweno, mbwata ne Ilaija i mena na i vamoru.” ");
INSERT INTO tgo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas mbowo i kulava na ghalɨŋae laghɨye amba i vatomweya yawaliye na i mare. ");
INSERT INTO tgo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Amba kwama va i ganatena woluwolu bobomako moli e Ŋgolo Boboma tɨne, i mathethe wa yavoro na ve wo bode, thelauko i mbarimbariri na varɨvarɨ thɨ raraviyaviya. ");
INSERT INTO tgo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ghabughabubu thɨ mavu na Loi le gharɨgharɨ vama thiya marekai thɨ rakathuweiru na e yawayawalinji. ");
INSERT INTO tgo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Thɨ rakaiteteŋgiya ghabughabubu na Jisas le thuweiru mare e ghereiye, vethɨ rakaru Jerusalem na vethɨ rakaraŋgi weŋgiya gharɨgharɨ lemoyo. ");
INSERT INTO tgo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mbaŋa ragagaithɨko na lenji randeviva, va inanji gheko thɨ njimbukikiya Jisas, thɨ ghamɨnogha ghembako i ragheghe na thɨ thuweŋgiya bigibigiko wolaghɨye iyava thɨ yomarako, thɨ mararu laghɨye na thɨŋa, “Mbema emunjoru iye Loi Nariye.” ");
INSERT INTO tgo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wanakau i ghanagha vambe inanjiva gheko. Vambe thɨ ndeghathɨ bwagabwaga na thɨ ghewoŋa Jisas. Thiye va thɨ ghambugha Jisas Galili na thɨ njimbukiki. ");
INSERT INTO tgo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","E tɨnenji Meri tɨnan Magadala, Meri Jemes na Josep tɨnanji na Sebedi le ŋgaŋga tɨnanji. ");
INSERT INTO tgo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mbaŋa vama yeghɨyeghɨye amba amala ragogomwau regha i vutha, idae Josep. Amalake iyake i mena Arɨmathiya na iye vambe Jisas gharaghambuva. ");
INSERT INTO tgo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I wa weya Pailat na ve naŋgo Jisas riwaekowe. Amba Pailat iŋa na thɨ wogiyawe. ");
INSERT INTO tgo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep i wo na i liya kwama togha i ghavowe, ");
INSERT INTO tgo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","amba i worawe ele ghabubu togha tɨne, vamba i tɨghɨruwoeŋge e varɨ e bobokulu regha. I vabulaleya varɨ laghɨye regha na i rogana ghaekowe, amba i iteteŋa. ");
INSERT INTO tgo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri tɨnan Magadala na le ghaida Meri eundava inanji gheko, thɨ yaku na ghamwanji i ghemba ghabubuko. ");
INSERT INTO tgo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mbaŋambaŋa Satade, Jiu lenji Sabat, ravowovowo laghɨlaghɨye na Parisi lenji wabwi thɨ rakawa Pailat. ");
INSERT INTO tgo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Thɨ dagewe thɨŋa, “Amalana, wo renuwaŋakikiya rakwanɨko iyako, mbaŋa vamba e laghalagha va iŋa, ‘Mbaŋa thegheto e ghereiye kaero ya thuweiruva.’ ");
INSERT INTO tgo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","U dage na ragagaithɨ vethɨ njimbukikiya ghabubuko ghaghad mbaŋa thegheto, mbala gharaghambuŋgiko ma valɨkaiwanji thɨ wa na vethɨ wokava riwaeko, na thɨ dage weŋgiya gharɨgharɨ, thɨŋa, ‘Kaero me thuweiruva e mare.’ Kwanɨke iyake ne i laghɨye kivwala kwanɨma i vivama.” ");
INSERT INTO tgo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat i dage weŋgi iŋa, “I thovuye, hu vaŋguŋgiya lo ragagaithɨna vavana na vou vaŋguraweŋgi na thɨ njimbukiki wagiyaweya ghabubuko.” ");
INSERT INTO tgo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Thɨ wa na vethɨ liya thiyo yaŋgara na thɨ ŋgarɨghathɨgha varɨko weiye ghabubuko ghadidiye na lenji nono ambama thɨ vaŋguraweŋgiya ragagaithɨ na thɨ njimbukiki. ");
INSERT INTO tgo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jiu lenji Sabat kaero iko na Sande mbaŋambaŋa moli, Meri tɨnan Magadala na le ghaida Meri reghava thɨ wa vethɨ kela e ghabubuko. ");
INSERT INTO tgo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ragheragheghe laghɨye regha i yomara, na Loi le nyao thovuye regha i mena e buruburu, i vabulaleyathu varɨma na i yaku e vwatae. ");
INSERT INTO tgo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ghamwae va i ndalandala ŋgora i vilamema na ghakwama i kakaleva ŋgora ghinama ree. ");
INSERT INTO tgo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ghabubuko gharagatɨgatɨ thɨ mararu laghɨye na thɨ tage thɨ dobu e thelauko vwatae, ma e laghalaghanji ŋgoranjiya thɨ marema. ");
INSERT INTO tgo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ko nyaoma thovuye i dage weŋgiya wanakauma iŋa, “Tha hu mararu! Ya ghareghare hu tamweya Jisas, iya mendava thɨ rokros. ");
INSERT INTO tgo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ma ina gheke, kaero me thuweiru, ŋgoreiya va le dagerawema. Wo hu mena hu thuwe menda thɨ worawemawe. ");
INSERT INTO tgo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hu rukunjogha na vou dage weŋgiya gharaghambuma, vouŋa, ‘Jisas kaero me thuweiru e mare na i viva weŋga Galili. Ne vou vaidi gheko’. Hu renuwaŋakikiya ŋgoroŋga maŋama e ghemi!” ");
INSERT INTO tgo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wanakauma thɨ yoruku na thɨ iteta ghabubuma weinji lenji mararu, ko iyemaeŋge warari laghɨye i riyevanjaraŋgi. Thɨ ruku na vethɨ utugiya weŋgiya gharaghambuma. ");
INSERT INTO tgo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","E kamwathɨ mborowa Jisas i vwara weŋgiya wanakauma na i dage weŋgi iŋa, “Ago laghɨye weŋga.” Thɨ menawe, thɨ ronja e ghenji vuvuye, thɨ vɨghathɨgha gheghe na thɨ kururuwe. ");
INSERT INTO tgo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas i dage weŋgi iŋa, “Tha hu mararu. Hu wa na vou dage weŋgiya oghaghaŋguna na thɨ raka Galili, tene vethɨ thuweŋgo gheko.” ");
INSERT INTO tgo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wanakauma vama inanji e kamwathɨ mborowa, amba ragagaithɨma iyava thɨ njimbukikiya ghabubukoma, vavana thɨ njogha Jerusalem na vethɨ utugiya weŋgiya ravowovowo laghɨlaghɨye bigibigiko wolaghɨye iya methɨ yomarako. ");
INSERT INTO tgo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ravowovowo laghɨlaghɨye thɨ niva weinjiyaŋgiya Jiu lenji randeviva na thɨ vakatha lenji mbaro regha na thɨ giya mani laghɨye weŋgiya ragagaithɨ. ");
INSERT INTO tgo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Na thɨŋa, “Hu dage weŋgiya gharɨgharɨ huŋa, ‘Mo ghenelaŋa gougou na gharaghambu thɨ mena thɨ wokaiva Jisas riwae.’ ");
INSERT INTO tgo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Thoŋgo Pailat i loŋweya totoke iyake, ghime tene wo varumwara nuwae na ghemi mane hu vaidiya vuyowae.” ");
INSERT INTO tgo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ragagaithɨma thɨ mbana manima na thɨ vakatha ŋgoreiya methɨ dagema weŋgi. Jiu gharɨgharɨniye thɨ ndethɨna utuke iya thɨŋake, Jisas, gharaghambu thɨ wokava riwae, ghaghada noroke. ");
INSERT INTO tgo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisas gharaghambu theyaworo na regha vethɨ voro e ou regha Galili ŋgoreiya Jisas va i dagema weŋgi na thɨ wawe. ");
INSERT INTO tgo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mbaŋa thɨ thuwe thɨ kururuwe, vavana thɨ numoghegheiwo. ");
INSERT INTO tgo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas i mena na i dage weŋgi, iŋa, “Bwebwe vama i woveŋgo vurɨgheghe na ya mbaroŋaŋgiya bigibigike wolaghɨye e buruburu na e yambaneke. ");
INSERT INTO tgo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iyake kaiwae hu wa weŋgiya gharɨgharɨke wolaghɨye e vanautumake wolaghɨye na hu vakathaŋgi na woraghambuŋgi, hu bapɨtaisoŋgi Ramanda e idae, Nariye na Nyao Boboma e idae. ");
INSERT INTO tgo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","U vavaghareŋgi na thɨ ghambugha bigibigike wolaghɨye ŋgoreiya va ya dagema weŋga. Na hu renuwaŋakiki iyake, ghino weiŋguyaŋgiya ghemi mbaŋake wolaghɨye gheghada yambaneke le ghambako.” ");
INSERT INTO tgo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Utuutuke iyake Toto Thovuye Jisas Krais, Loi Nariye utuniye. I ri weya toto gharawo ŋgoreiya Aiseya, Loi ghalɨŋae gharautu va i rori Loi iŋa, “Ne ya variya toto gharawo e ghamwan na i vivatha kamwathɨ kaiwan. ");
INSERT INTO tgo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lolo regha i kulakula e njamnjam: ‘Hu vivatha kamwathɨ Giya kaiwae na hu varumwaru na mbala i reŋawe.’” ");
INSERT INTO tgo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Totoke gharawo iye Jon Rabapɨtaiso. I yaku e njamnjam na i vavaghare weŋgiya gharɨgharɨ thɨ uturaŋgiya lenji tharɨ na thɨ roiteteŋgi, amba Loi i numotenɨŋgi. Amba thɨ bapɨtaiso. ");
INSERT INTO tgo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gharɨgharɨ lemoyo Judiya na Jerusalem e tɨne thɨ rakarakamena weya Jon. Thɨ uturaŋgiya lenji tharɨ na i bapɨtaisoŋgi e Walaghɨta Jorɨdan. Na lenji bapɨtaisoko i vatomwe kaero thɨ vakatha ŋgoreiye Jon le vavaghare. ");
INSERT INTO tgo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ghakwama thɨ vakatha kamel vulivuliye. Mborowae gheva thetheghan njimwae. I ghanɨŋgiya bibita na ŋguyo. ");
INSERT INTO tgo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Le utu ŋgorake: “Loloko iya i rereghamba e ghereiŋguke iye i vurɨgheghe kivwalaŋgo. Ghino, ma elo thovuye na valɨkaiwaŋgu ya kururu na ya raka gheghe ghae. ");
INSERT INTO tgo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ya bapɨtaisoŋga e mbwa ko iye ne i bapɨtaisoŋga e Nyao Boboma.” ");
INSERT INTO tgo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","E mbaŋako iyako e tɨne Jisas i ri Nasaret Galili e tɨne na i wa weya Jon, na iye i bapɨtaiso Jorɨdan. ");
INSERT INTO tgo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mbaŋa Jisas i voro e mbwako ghadidiye i vaidiya buruburu i mavu na Nyao Boboma i njawe ŋgoreiya bunebune. ");
INSERT INTO tgo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Amba ghalɨghalɨŋa regha i mena e buruburu iŋa, “Ghen naruŋgu moli gharegharethovuniye, i vakathaŋgo ya warari laghɨye moli.” ");
INSERT INTO tgo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","E mbaŋako iyako Nyao Boboma i vakatha na i wa e njamnjam vurɨvurɨ vwatavwata. ");
INSERT INTO tgo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na ve yaku gheko gheneyevarɨ. Seitan i vatanathethaŋa. Va weiyaŋgiya njamnjam thetheghanɨniye, ko Loi le nyao thovuthovuye thɨ mena na thɨ giya thalavuwe. ");
INSERT INTO tgo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mbaŋa vama thɨ woruwo Jon e thiyo na e ghereiye, Jisas i wa Galili na i vavaghare Toto Thovuye i mena weya Loi, ");
INSERT INTO tgo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","iŋa, “Mbaŋa kaero ina gheke, Loi le ghamba mbaro maiyavara; hu uturaŋgiya lemi tharɨna na hu roiteteŋgi na hu loŋweghathɨgha Toto Thovuye.” ");
INSERT INTO tgo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Va mbaŋa regha Jisas i ŋgalai Galili Njighɨniye ghadidiye na i vaidiŋgiya raboroborogi theghewo, Saimon na ghaghae Endru, thɨ duda ghina kaiwae thiye raboroborogi. ");
INSERT INTO tgo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas i dage weŋgi iŋa, “Hu mena hu ghambuŋgo na ya vavaghareŋga ghemi gharɨgharɨ ghanjirakosi.” ");
INSERT INTO tgo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","E mbaŋako iyako thɨ iteteŋgiya lenji ghina na thɨ ghambu. ");
INSERT INTO tgo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","I loŋga ghaova seiwo i vaidiya Jemes, Sebedi nariye, na ghaghae Jon. Thiye va inanji e lenji waŋga thɨ vavanamweŋgiya lenji ghina. ");
INSERT INTO tgo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E mbaŋako iyako i kula weŋgi, thɨ iteta ramanji Sebedi e waŋga weiyaŋgiya lenji rakakaiwo, na thɨ ghambu. ");
INSERT INTO tgo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mbaŋa Jisas na gharaghambu thɨ vutha Kapenaom, Sabat e tɨne Jisas i ru Jiu e lenji ŋgolo kururu na i vavagharewe. ");
INSERT INTO tgo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Gharɨgharɨko iyava thɨ vandeŋeko gharenji i yo laghɨye le vavaghare kaiwae, kaiwae mava ŋgoreiya mbaro gharavavaghare, ko i vavaghare weiye mbaro. ");
INSERT INTO tgo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","E mbaŋako iyako amala ina gheko nyao raitharɨ inawe, va ina Jiu e lenji ŋgolo kururuko tɨne i yaro iŋa, ");
INSERT INTO tgo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ne u vakatha vara budakai weime, Jisas rara Nasaret? Mo mena gheke na nuwaniya u vakowanaime? Kaero ya ghareghareŋge, ghen Raboboma Loi va i variye.” ");
INSERT INTO tgo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisas i ŋaelɨmbiya weya nyaoko raitharɨ iŋa, “Meiye, na u iteteŋa amalana!” ");
INSERT INTO tgo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nyaoko raitharɨ i vandindi laghɨye amalako, i yaro laghɨye moli na i raŋgiwe. ");
INSERT INTO tgo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Taulaghɨko gharenji i yo laghɨye na thɨ veutu weŋgi thɨŋa, “Budakaiyake? Iyake vavaghare togha. Amalake i vavaghareŋa renuwaŋa emunjoru na totoghaŋgi, na i vakatha weiye le mbaro, i dage vurɨgheghe weŋgiya nyao raraitharɨ na thɨ loŋweghathɨ.” ");
INSERT INTO tgo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Toto amalaghɨniye kaiwae i vaghɨliya Galili tɨneko laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mbaŋa Jisas na gharaghambu thɨ roiteta ŋgolo kururuko, weinjiyaŋgiya Jemes na Jon, amba vethɨ ru Saimon na Endru e lenji ŋgolo. ");
INSERT INTO tgo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon mboriyae i ghambwera, na mbe ina vara e ghambae riwae i dayagha na i ghena. Jisas vambe i vutha vara kaero thɨ utugiyawe. ");
INSERT INTO tgo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I ruwe, i yalawe e nɨmae na i thalavu i thuweiru. Ghambwerama i iteteŋa na i vaŋamweŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Varae vama ve ronja na kaero i mouwo na Sabat kaero iko, gharɨgharɨ thɨ bigimena weya Jisas ghambweghambwera na thavala nyao raitharɨ ina weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gharɨgharɨko taulaghɨ e ghembako tɨne thɨ mevathavatha e ŋgoloko mbothiye. ");
INSERT INTO tgo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Gharɨgharɨ i ghanagha thɨ ghambweraŋa ghambwera thaŋarɨ Jisas i thawarivaoŋgi. Vambe i variye raŋgiyaŋgiva nyao raraitharɨ weŋgiya gharɨgharɨ. Mava i vatomwe na thɨ dagewe kaiwae va thɨ ghareghare thela amalaghɨniye, na iye i mena weya Loi. ");
INSERT INTO tgo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","I liwiya ndayathɨ Jisas i thuweiru, i iteta ŋgolo na ghembako, i wa e valɨvaŋga ma gharɨgharɨ nanjiwe na ve naŋgowe. ");
INSERT INTO tgo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ko iyemaeŋge e ghereiye Saimon na ghaune thɨ rakaraŋgi na thɨ tamwe. ");
INSERT INTO tgo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mbaŋa thɨ vaidi, thɨ dagewe thɨŋa, “Gharɨgharɨko wolaghɨye thɨ tamwetamwe e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ko Jisas i gonjogha weŋgi iŋa, “Ra raka e ghembaghemba vavanava e valɨvaŋgake iyake na tembe va vavaghareweva. Iyake iyava kaiwae na ya mena.” ");
INSERT INTO tgo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iya kaiwae i vaghɨliya Galili laghɨyeko, i vavaghareŋa Toto Thovuye e kururu ŋgoloŋgoloniyeko tɨnenji na i variye raŋgiyaŋgiya nyao raraitharɨ. ");
INSERT INTO tgo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Amala regha i ghataŋa lepelo, va i mena weya Jisas i ronja e gheghe vuvuye e ghamwae na i naŋgowe iŋa, “Thoŋgo nuwaniya, u vakathaŋgo na ya thovuye.” ");
INSERT INTO tgo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas ghare i vɨrɨ kaiwae, i livamomoya nɨmae na i vɨghathɨgha amalako. I dagewe iŋa, “Nuwaŋguke nuwaiya, riwana i thovuye!” ");
INSERT INTO tgo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","E mbaŋako iyako ghaghambwerama iko na riwae i thɨna. ");
INSERT INTO tgo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Amba i dage vurɨgheghewe na i variyeyathu e mbaŋako iyako, ");
INSERT INTO tgo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","na iŋa, “Wo u vandeŋe, ne u ndeutuŋa weya lolo regha, u wawe vara ravowovowo na tembe ghanɨmberegha vo vatomweŋgewe na vo vowo riwana le thɨna kaiwae ŋgoreiya Mosese le mbaro, na i vaemunjoruŋa weŋgiya gharɨgharɨ riwan kaero i thɨna.” ");
INSERT INTO tgo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ko amalako i wa na ve utuutu weŋgiya gharɨgharɨ budakai me yomarawe. Iya kaiwae Jisas ma valɨkaiwae i ru e ghemba laghɨye gharɨgharɨ lemoyo inanjiwe. I yaku eto e ghemba ma gharɨgharɨniye, ko iyemaeŋge gharɨgharɨ thɨ menawe Galili laghɨyeko e tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mbaŋa amba gheviye eŋge e ghereiye Jisas i njogha Kapenaom, gharɨgharɨ thɨ loŋweya toto kaero ina e ŋgolo tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Woye laghɨye moli thɨ mevathavatha. Thɨ riyevanjara ŋgolo tɨne na ghae, amba i utuŋa Toto Thovuye weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mbaŋaniye ghɨmoghɨmoru theghevarɨ thɨ wovutha amala i kuvokuvo ele ghamba ghena weya Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kaiwae wabwi i laghɨye moli, ma valɨkaiwanji thɨ womena weya Jisas iya kaiwae thɨ vakatha doda e ŋgoloko vwatae i rukughɨdaghɨda Jisas. Mbaŋa vama thɨ vakatha doda, thɨ wonjaniya amalakowe, i ghena e da. ");
INSERT INTO tgo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas i thuwe lenji loŋweghathɨko le laghɨlaghɨye, i dage weya kuvokuvoko iŋa, “Amalana, ya numotena len tharɨna wolaghɨye.” ");
INSERT INTO tgo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","E mbaŋako iyako mbaro gharavavaghare vavana thiya yaku gheko thɨ rerenuwaŋa e gharenji thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Buda kaiwae amalake i utu ŋgoreiyako? Amalake i kivwala Loi na i utuvatharɨwe! Ma te lolo reghava ne i numotena tharɨ, Loi ghamberegha moli.” ");
INSERT INTO tgo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","E mbaŋako iyako Jisas i ghareghare ŋgoroŋga lenji renuwaŋa thuweleko, kaero i dage weŋgi iŋa, “Buda kaiwae hu rerenuwaŋa ŋgoreiyake? ");
INSERT INTO tgo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Iyaŋganiya ghautuutu i maya, ‘Len tharɨna kaero ya numoten,’ o yaŋa, ‘U yondovirɨ, u bigiya ghambana ghavwarara na u loŋga’? ");
INSERT INTO tgo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ya vaemunjoruŋa e ghemi, Lolo Nariye ele mbaro e yambaneke na valɨkaiwae i numotena tharɨ.” Amba i dage weya amalako kuvokuvoko iŋa, ");
INSERT INTO tgo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ya dage e ghen, u yondo, u bigiya ghambana ghavwarara na u wa e len ŋgolo!” ");
INSERT INTO tgo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Taulaghɨko e maranji i yondovirɨ, i mbana ghambae ghavwarara na i loŋgaraŋgi. Gharenji i yo laghɨye moli na thɨ taraweŋa Loi thɨŋa, “Ma mbaŋa regha wo thuwathuwa ŋgoraiyako va i vivako.” ");
INSERT INTO tgo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas vambowo i njoghava Galili Njighɨniye ghadidiye amba wabwi laghɨye thɨ menawe na i vavaghare weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","I loŋgaghao na i vaidiya Livai, Alipiyos nariye, i yaku e takis ghaopis, na i dagewe iŋa, “U ghambuŋgo.” Livai i yondovirɨ na i ghambu. ");
INSERT INTO tgo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mbaŋa gheviye Jisas i ghanɨŋga Livai ele ŋgolo. Takis gharambanɨmba na gharɨgharɨ raraitharɨ thɨ mbela Jisas, thɨ ghanagha thɨ rakaru weŋgi weiyaŋgiya gharaghambu e ghanɨŋgako. ");
INSERT INTO tgo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mbaro gharavavaghare vavana, thiye Parisi, thɨ thuwe Jisas i ghanɨŋga weiyaŋgiya gharɨgharɨ raraitharɨ na takis gharamban, thɨ dage weŋgiya gharaghambu thɨŋa, “Buda kaiwae i ghanɨŋga weiyaŋgiya gharɨgharɨ raraitharɨ na takis gharamban?” ");
INSERT INTO tgo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mbaŋa Jisas i loŋwevaidi amba iŋa, “Thavala riwanji i thovuye ma nuwanjiya rathawathawari, ko mbe ghambweghambweraeŋge nuwanjiya. Ma ya mena ya kula weŋgiya thavala thɨ rumwaru, ko ya mena tharɨ gharavakatha kaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Va mbaŋa regha Jon Rabapɨtaiso gharaghambu na Parisi thɨ mbeya ghanɨŋga ŋgoreiye lenji kururu ghakamwathɨ. Gharɨgharɨ vavana thɨ mena weya Jisas na thɨ vaito thɨŋa, “Buda kaiwae Jon gharaghambu na Parisi ghanjiraghambu thɨ mbemba, ko ghen ghanɨraghambu nandere?” ");
INSERT INTO tgo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas i dage weŋgi iŋa, “Thare valɨkaiwae ghe gharaghaghayawo thɨ mbeya ghanɨŋga mbaŋa ragheghe ghɨmoru mbe inawe vara weiyaŋgi? Ma valɨkaiwae! Mbaŋa ragheghe ghɨmoru mbe ina vara weiyaŋgi mane thɨ vakatha iyako. ");
INSERT INTO tgo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ko mbaŋa ne i mena, nevole thɨ vaŋgu weŋgiya ragheghe ghɨmoru, mbaŋako iyako amba thɨ mbemba.” ");
INSERT INTO tgo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mbowo i gotubweva iŋa, “Ma lolo regha ne i liya kwama nasiye togha na i ŋgiyagana kwama teuyewe i bowotu, kaiwae mbaŋa ne i thavwi na i livamo toghako ne i mwanavatha na i vakatha teuyeko na i mathethe na i bowoutu laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na tembe ŋgoreiyeva, ma lolo regha i liŋgiya waen togha e variye teuye thɨ vakatha thetheghan njimwae, waenɨko ne le vurɨgheghe kaiwae na i topo, waen i maliŋgi na variyeko i tharɨ. Iyemaeŋge waen togha i liŋgi e variye togha.” I dage ŋgoreiye ma valɨkaiwae ra wovatabo vavaghare teuye weiye vavaghare togha. ");
INSERT INTO tgo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Va Sabat regha Jisas i ghathara wit e ghauma. Gharaghambu e lenji loŋga tɨne thɨ lavugha wit uneune. ");
INSERT INTO tgo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisi thɨ dage weya Jisas thɨŋa, “Wo u thuwe, buda kaiwae ghanɨraghambu mbaro i dageten e Sabat na thɨ vakatha?” ");
INSERT INTO tgo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisas i dage weŋgi iŋa, “Thare mbaŋa regha hu vaona Deivid va i vakatha budakai mbaŋa bada i gharɨŋgi weiyaŋgiya ghaune? ");
INSERT INTO tgo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Va i ru Loi ele ŋgolo na i ghana bred boboma. Iyake va i yomara mbaŋa Abiyata iye va ravowovowo laghɨye. Mbaro vambe i vatomweŋge ravowovowo weŋgi thɨ ghana bredɨko iyako, ko Deivid va i ghan na tevambe i giya weŋgiya ghaune.” ");
INSERT INTO tgo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisas iŋa, “Buda kaiwae Loi i vakatha Sabat? Va i vakatha na i mbaroŋaŋgiya gharɨgharɨ? Nandere moli! Ko iyemaeŋge va i vakatha Sabat mbala valɨkaiwae thɨ towowe e lenji kaiwo tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iya kaiwae ghino Lolo Nariye — Ghino Sabat ghagiya. Elo mbaro na valɨkaiwae yaŋa gharɨgharɨ thɨ vakatha budakai Sabat e tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Amba Jisas tembe ve ruva Jiu e lenji ŋgolo kururu tɨne, na amala regha inawe nɨmae i kuvokuvo. ");
INSERT INTO tgo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Gharɨgharɨ vavana va inanji gheko thɨ njimbukiki na thɨ thuwe thare ne i thawariya amalako e Sabat na mbala thɨ wonjowe. ");
INSERT INTO tgo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas i dage weya amalako iŋa, “U yondo na u mena u ndeghathɨ gheke.” ");
INSERT INTO tgo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jisas i vaitoŋgi iŋa, “Budakaiya la mbaro i vatomwe weinda na ra vakatha e Sabat? Ra vakatha thovuye o ra vakatha tharɨ? Ra vamoru lolo yawaliye o ra vakowana?” Gharɨgharɨko thiya rokubaro. ");
INSERT INTO tgo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas i ghɨmaratako weŋgi weiye le gaithɨ, ko vambe ghare i vɨrɨva kaiwanji kaiwae gharenjiko i vurɨgheghe laghɨye, amba i dage weya amalako iŋa, “U livamomoya nɨmanɨna.” I livamomoya nɨmaeko na kaero i thovuyeva. ");
INSERT INTO tgo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisi thɨ raka iteta Jiu lenji ŋgolo kururu na e mbaŋako iyako thɨ niva weinjiyaŋgiya gharɨgharɨ thɨ ghambugha Herod le mbaro, thɨ tamwe kamwathɨ na thɨ unɨgha Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas na gharaghambu thɨ raka e Galili Njighɨniye ghadidiye na wabwi laghɨye thɨ rakamena Galili thɨ rakambele, vavana vambe thɨ rakamenava Judiya, ");
INSERT INTO tgo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumeya ele valɨvaŋga na Jorɨdan valɨvaŋga i vorovoro na Taiya na Saidon mbe e lenji valɨvaŋgava. Gharɨgharɨ e ghembaghembake thiyake thɨ raka menawe kaiwae va thɨ loŋweya le vakathako utuniye. ");
INSERT INTO tgo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Wabwiko va laghɨye moli iya kaiwae Jisas i dage weŋgiya gharaghambuko thɨ yambi ruwovamuna waŋgako na i rovalawe mbala gharɨgharɨ ma thɨ romenawe moli. ");
INSERT INTO tgo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Vama i thawariŋgiya gharɨgharɨ lemoyo iya kaiwae thiye e ghanjighambwera nuwanjiya thɨ rovurɨgheghe na thɨ ghathara e wabwiko tɨne thɨ mena thɨ vɨghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na thembaŋa gharɨgharɨ nyao raitharɨ ina weŋgi thɨ thuwe, thɨ dobu e ghamwae na thɨ dage ghalɨŋanji laghɨye thɨŋa, “Oo! Ghen Loi Nariye.” ");
INSERT INTO tgo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ko iyemaeŋge Jisas i dage vurɨgheghe weŋgi na ne thɨ ndeutugiya weya lolo regha thela amalaghɨniye. ");
INSERT INTO tgo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mbaŋa Jisas i voro e ou nasiye i kula vathavathaŋgiya ghɨmoghɨmoru va nuwaiyaŋgi. Thɨ raka menawe, ");
INSERT INTO tgo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","na i tuthiŋgiya theyaworo na theghewo, na i uno idanji ghalɨŋae gharaghambɨ. Jisas i dage weŋgi iŋa, “Ma tuthiŋga na hu ghambuŋgo. Ne ya variyeŋga na vohu utuŋa ghalɨŋaŋgu, ");
INSERT INTO tgo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na ne elo mbaro ghavurɨgheghe tɨne na hu variye raŋgiyaŋgiya nyao raraitharɨ.” ");
INSERT INTO tgo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Theyaworo na theghewoke thiyake iya va i tuthiŋgike: Saimon (Jisas va i rena Pita), ");
INSERT INTO tgo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemes Sebedi nariye na ghaghae Jon (va i uno idanji, Bowanje, gharumwaru ŋgoreiye gharetaitai), ");
INSERT INTO tgo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endru, Pilip, Batolomiu, Matiu, Tomas, Jemes Alipiyos nariye, Tadiyas, Saimon iye i mena e wabwi regha idanji Jilot, ");
INSERT INTO tgo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Judas Isakariyot, iye Jisas ghaliliva. ");
INSERT INTO tgo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas i njogha na i ru e ŋgolo tɨne na wabwi laghɨye mbowo thɨ mevathavathava, Jisas na gharaghambu mava e ghanjimbaŋa na valɨkaiwae thɨ ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mbaŋa le bodaboda thɨ loŋwe iyake, thɨ wa na vethɨ yalaweghathɨ kaiwae gharɨgharɨ thɨŋa, “Umbaliye i ghawe.” ");
INSERT INTO tgo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mbaro gharavavaghare vavana thɨ mena Jerusalem thɨ utuŋa thɨŋa, “Nyao raraitharɨ ghanjigiya Bilɨsabul inawe! Nyao raraitharɨ lenji randeviva iya i giya vurɨgheghekowe na i variye raŋgiyaŋgiya nyaoko raraitharɨ.” ");
INSERT INTO tgo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lenji utuko kaiwae, Jisas i kula vathaŋgi na thɨ raka menawe amba i goghaimba na i veŋgi iŋa: “Ŋgoroŋga ne Seitan iŋa na i variyeraŋgiya ghamberegha? ");
INSERT INTO tgo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Thoŋgo ghamba mbaro regha tembe ghamberegha i yondo na i giya wabwi na thɨ vegaithɨ weŋgi, ghamba mbaroko iyako ne i dobu. ");
INSERT INTO tgo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na thoŋgo ŋgolo regha gharɨgharɨniye thɨ rakayondo na thɨ vegaithɨ weŋgi, ŋgolo iyako gharɨgharɨniye ne nandereŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na thoŋgo Seitan i vakatha wabwi ele ghamba mbaro tɨne na thɨ vegaithɨ weŋgi, mane te i vurɨghegheva, ne i dobu na kaero iko.” ");
INSERT INTO tgo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ma lolo regha valɨkaiwae i ru amala vurɨgheghe ele ŋgolo na i kaiva le bigibigi e ŋgoloko tɨne. Thoŋgo nuwaiya wo i yalawekai, i ŋgarɨghathɨ e thiyo, ko amba i kaiva le bigibigi e ŋgoloko tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ya dage emunjoru e ghemi, gharɨgharɨ lenji tharɨ na lenji utuvatharɨ weya Loi, Loi i numotenɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ko thela i utuvatharɨ weya Nyao Boboma, Loi ma tene i numotenɨva loloko iyako; kaiwae i vakatha tharɨ iya Loi ma mbaŋa regha tene i numotenɨva.” ");
INSERT INTO tgo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas iŋa ŋgoreiyako kaiwae gharɨgharɨ va thɨŋa, “Nyao raitharɨ inawe.” ");
INSERT INTO tgo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Amba Jisas tɨnae na oghaghae thɨ vutha. Thɨ ndeghathɨ eto na thɨ variya utu kaiwae nuwanjiya i raŋgi na thɨ utu weinji. ");
INSERT INTO tgo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wabwi laghɨye va thɨ roghɨliŋa, thɨ dagewe thɨŋa, “Tɨna na oghagha thiye etoke thɨ vavaito kaiwan.” ");
INSERT INTO tgo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisas i gonjogha weŋgi iŋa, “Nava thela na oghaghaŋguŋgiya thavala?” ");
INSERT INTO tgo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I thuweŋgiya gharɨgharɨko iya va thɨ roghɨliŋako, na iŋa, “Wo hu thuwe! Thiyake nava na oghaghaŋgu! ");
INSERT INTO tgo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Thela thoŋgo i vakatha Loi le renuwaŋa iye ghaghaŋgu, louŋgu na tɨnaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas vambowo i vavaghareva e Galili Njighɨniye ghadidiye. Wabwiko iyava thɨ meghɨliŋako i laghɨye moli iya kaiwae va i tha e waŋga na i rovalawe. I ghagharaŋgi seiwo na wabwiko laghɨye thiya yaku e malavwata. ");
INSERT INTO tgo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Va i vavaghareŋgiya bigibigi i ghanagha. Vambe i goghaimba eŋge. I dage weŋgi iŋa, ");
INSERT INTO tgo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Hu vandeŋe! Amala regha i wa na ve yathu le weiwo. ");
INSERT INTO tgo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mbaŋa i yathu le weiwoko e umako vavana thɨ dobu e kamwathɨ mara na ma thɨ mena thɨ ghanɨŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Vavana thɨ unja e thelau ele varɨvarɨ na mava thelauko i poku, na ŋgorava thɨŋama kaero thɨ yovoro kaiwae thelauko mava i poku. ");
INSERT INTO tgo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mbaŋa varae i ŋge thelauko na i dayagha kaero thɨ mare kaiwae wathelilinji ma vamba ina bwagabwaga. ");
INSERT INTO tgo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Weiwo vavana i yathu ŋgora nana raraitharɨ inanjiwe. Nanako raraitharɨ lenji mbuthu i maya na thɨ vwariŋgi na ma thɨ rau. ");
INSERT INTO tgo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ko weiwo vavana va thɨ unja e thelau thovuye, thɨ mbuthu wagiyawe na thɨ rau na uneunenji lenji ghanaghanagha i tomethi, vavana voghɨyeto (30), vavana voghɨyewona (60) na vavana voghɨthaŋarɨ (100).” ");
INSERT INTO tgo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas iŋa, “Thoŋgo e yanayanawami hu vandeŋe wagiyaweya ghalɨŋaŋguke.” ");
INSERT INTO tgo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mbaŋa Jisas vambe ghamberegha eŋge, gharɨgharɨko iyava thɨ vandeŋeko vavana thɨ menawe weinjiyaŋgiya gharaghambuko theyaworo na theghewoko. Thɨ dagewe na i vamanjamanjalaŋa goghaimbako weŋgi. Jisas i dage weŋgi iŋa, ");
INSERT INTO tgo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","“E ghemi Loi le ghamba mbaro gharenuwaŋa thuwele kaero i woraŋgiya weŋga. Ko thavala ma inanji Loi ele wabwi Loi le ghamba mbaro emunjoru utuutuniye thɨ loŋwe e goghaimba. ");
INSERT INTO tgo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kaiwae Buk Teuye iŋa, ‘Othembe ne thɨ njimbukiki mane thɨ thuwe; ne thɨ vandeŋe mane thɨ ghareghare. Kaiwae thoŋgo thɨ thuwe na thɨ ghareghare thɨ roiteteŋgiya lenji tharɨ, thɨ goru weya Loi, na ne i numotenɨŋgiya lenji tharɨ.’” ");
INSERT INTO tgo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Amba Jisas i vaitoŋgi iŋa, “Ma hu ghareghare goghaimbake iyake? Ŋgoroŋga ne huŋa eŋge na hu ghareghareŋgiya goghaimbako wolaghɨye?” ");
INSERT INTO tgo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jisas iŋa, “Wo ya vamanjamanjalaŋa weŋga, rakabu weiwo ŋgora i kabu Loi ghalɨŋae. ");
INSERT INTO tgo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gharɨgharɨ vavana ŋgoranjiya weiwo thɨ dobu e kamwathɨ mara; e mbaŋako iyako thɨ loŋweya Loi ghalɨŋae, Seitan i mena na i woraŋgiya weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Vavana ŋgoranjiya weiwo thɨ dobu e thelau ele varɨvarɨ. E mbaŋako iyako thɨ loŋweya Toto Thovuye, thɨ wovatha weinji lenji warari. ");
INSERT INTO tgo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ko ma i ru moli e gharenji ŋgora nana ma e wathewatheliliye thovuye na ma thɨ yaku mbaŋa molao. Mbaŋa vuyowo ne i vutha weŋgi o gharɨgharɨ thɨ botewoŋgi Toto Thovuye kaiwae, e mbaŋako iyako thɨ dobu. ");
INSERT INTO tgo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Vavana ŋgoranjiŋgiya weiwo thɨ dobu ŋgora nana raraitharɨ inanjiwe. Gharɨgharɨke thiyake thɨ loŋweya Loi ghalɨŋae, ");
INSERT INTO tgo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ko yambaneke renuwaŋaniye i vagaghala nuwanji na nuwanjiko i ghaŋgo weya gogomwau na nuwanjiya lemoyo, iyake kaiwae ma te thɨ goruweva Loi ghalɨŋae. Thiye ŋgoranjiŋgiya weiwo ma e uneune. ");
INSERT INTO tgo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ko gharɨgharɨ vavana ŋgoranjiya weiwo thɨ dobu e thelau thovuye. Thɨ loŋweya Loi ghalɨŋae, thɨ loŋweghathɨ na thɨ worawe e gharenji na i rau; vavana voghɨyeto (30), vavana voghɨyewona (60) na vavana voghɨthaŋarɨ (100).” ");
INSERT INTO tgo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas i vaitoŋgi iŋa, “Thare mbaŋa regha lolo regha i thɨnɨruwo kadɨŋeŋe na i thɨnɨrawe e uye tɨne o e tebol ghamba ghena raberabe? Ma i thɨnɨvakwate? ");
INSERT INTO tgo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Budakaiya i rothuwele tene Loi i woraŋgiya e manjamanjala, na budakaiya e ghayaboyabo tene i tatethewo. ");
INSERT INTO tgo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Thoŋgo e yanayanawami, hu vandeŋe wagiyawe ghalɨŋaŋguke na hu ghareghare!” ");
INSERT INTO tgo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Hu vakaiwoŋa yanayanawamina na hu vandeŋe wagiyawe; kaiwae thoŋgo hu vandeŋe na hu ghambu, amba ne valɨkaiwami hu ghareghare wagiyawe. Thela i ghareghare othembe mbema seiwo eŋge, weya amalaghɨniye Loi ne i woraŋgiyawe laghɨye. Ko the lolo ma ele ghareghare othembe the utu i loŋwe ne i ghawewe. ");
INSERT INTO tgo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iyake ŋgoreiye, thoŋgo u wo ne i giya e ghen ma e vwataeva, ko thoŋgo ma u wo mun, ne u thɨvaivao iyana othembe budakai ina e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas vambowo i dageva weŋgi iŋa, “Loi le ghamba mbaro ŋgoreiya amala regha i raŋgi na ve yathu weiwo ele uma tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","I njogha gougou na i ghena ghararaghɨye i kaiwo mbaŋa regha na regha, weiwoko i yovoro na i mbuthu, ko ma i ghareghare eŋge ŋgoroŋga le mbuthumbuthu. ");
INSERT INTO tgo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Weiwoko tembe ghamberegha i mbuthu e thelauko na i rau: i viva mborowae, vunyenyeuye amba muyai uneune thɨ rakaraŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mbaŋa uneune thɨ mweghe i wo le kaina na ve tenɨwe kaiwae kaero ghambaŋa.” ");
INSERT INTO tgo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas mbowo i dage weŋgiva iŋa, “Mbowo ya utugiyava utuutu regha e ghemi, na i manjamanjala e ghemi ŋgoroŋga Loi le ghamba mbaro ghayamoyamo. ");
INSERT INTO tgo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ŋgoreiya masɨted mbouye le mbuthumbuthu. Weiwoke wolaghɨye thɨ kabukabu e uma nasiyeninji moli. ");
INSERT INTO tgo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mbaŋa thɨ wokabu na i mbuthu, i mbuthu kivwalaŋgiya ghanɨŋgako wolaghɨye e umako tɨne. Yaŋgayaŋgae laghɨlaghɨye na ma thɨ yoyo valɨkaiwae thɨ vakatha unyinji e riburibuwae.” ");
INSERT INTO tgo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas va i vavaghareŋaŋgiya goghaimba i ghanagha ŋgoranjiya iyake weŋgiya gharɨgharɨ, na valɨkaiwae nuwanjiko i manjamanjalawe. ");
INSERT INTO tgo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Vambe i goghaimba eŋge iyava i utu weŋgiya gharɨgharɨko, ko mbaŋa vambe thiye eŋge weiyaŋgiya gharaghambuko i vamanjamanjalaŋa bigibigiko wolaghɨye weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Va yeghɨyeghɨye e mbaŋako iyako i dage weŋgiya gharaghambu iŋa, “Ra lawaoko valɨmbwako.” ");
INSERT INTO tgo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Thɨ iteteŋgi wabwi laghɨye, thɨ tha e waŋgako Jisas vama inakowe na weinji. Waŋga vavana vambe weinjiyaŋgiva. ");
INSERT INTO tgo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Amba ndewendewe laghɨye i rowo, bagodu i vana e waŋga na i nja e waŋgate na mbalavama thɨ dama. ");
INSERT INTO tgo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas ina e waŋgako tɨne i ghena e waŋgako gharɨghe na i wara umbaliye e bubuthe. Gharaghambu thɨ yavairɨ na thɨ dagewe thɨŋa, “Ravavaghare, thare u rerenuwaŋa kaiwanda, mbaŋa nasiye raya mare!” ");
INSERT INTO tgo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisas i thuweiru na i dage weŋgiya ndewendewe na bagoduko iŋa, “Hu towo! Hu ndeghathɨ!” Mbaŋara ndewendewe na bagodu thɨ towo na tad laghɨye i ghagha. ");
INSERT INTO tgo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Amba Jisas i dage weŋgi iŋa, “Buda kaiwae hu mararu? Ma e lemi loŋweghathɨ?” ");
INSERT INTO tgo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Thɨ mararu laghɨye moli na thɨ vedage weŋgi thɨŋa, “Thelake? Othembe ndewendewe na bagodu thɨ loŋweghathɨ ghalɨŋae.” ");
INSERT INTO tgo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas na gharaghambu va vethɨ vuthava Galili Njighɨniye ele valɨvaŋga regha iya Gerasa gharɨgharɨniye va thɨ yakukowe. ");
INSERT INTO tgo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mbaŋa i iteta waŋga amala regha i rukuraŋgimawe e ghabughabubuko. Amalake nyao raitharɨ inawe ");
INSERT INTO tgo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","na i yaku e ghabubuko. I vurɨgheghe laghɨye moli na ma valɨkaiwae lolo regha i ŋgarɨghathɨ othembe thɨ ŋgarɨ e sen. ");
INSERT INTO tgo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mbaŋa i ghanagha gharɨgharɨ thɨ ŋgara nɨmanɨma na gheghe e sen, ko mbaŋa regha na regha thɨ vakatha i bebeŋgiya senɨŋgiko e nɨmanɨmako na i bebevowowona senɨŋgiko e ghegheko. Ma lolo regha valɨkaiwae i laweghathɨ na i mbaroŋa. ");
INSERT INTO tgo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ghararaghɨye na gougou i loŋgatakweŋgiya ghabughabubu na e bobokulu vwatavwatanji, i yaroyaro na i tena riwariwae e varɨvarɨ. ");
INSERT INTO tgo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Vamba ina bwagabwaga kaero i vaidiya Jisas; i ruku na i mena i kururu e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Mbaŋako iyako Jisas i dagewe iŋa, “Nyao raitharɨ, u raŋgi weya amalana!” Nyaoko raitharɨ i yaro ghalɨŋae laghɨye iŋa, “Jisas, Loi Ramevoro Moli Nariye! Nuwaniya budakai ina e ghino? Loi e idae ya naŋgo e ghen ne u ndevakatha vɨrɨ laghɨye e ghino.” ");
INSERT INTO tgo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisas i vaito iŋa, “Idan thela?” Amalako i gonjoghawe iŋa, “Idaŋgu woye laghɨye moli — kaiwae lamamoyo moli.” ");
INSERT INTO tgo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","I naŋgo vurɨgheghe weya Jisas na thava i variye raŋgiyaŋgi e valɨvaŋgako iyako tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mbombo naura inanji thiya nuve e bobokulu regha ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nyaoko raraitharɨ mbowo thɨ naŋgoweva thɨŋa, “U variyeime weŋgiya mbomboko na vo ru weŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iya kaiwae Jisas i vatomweŋgi i variyeŋgiya nyaoko raraitharɨ thɨ rakaraŋgi weya amalako na thɨ rakaru weŋgiya mbomboko. Mbomboko naura lenji ghanaghanagha mbalavama i wo tu tausan thɨ rakanjaniya bobokuluko ghadidiye na vethiya munja e njighɨ. ");
INSERT INTO tgo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mbaŋa mbomboko gharanjimbunjimbu thɨ thuwe iyako, thɨ rakavo na vethɨ ututako ghembako laghɨye na e umauma tɨnetɨnenji. Iya kaiwae gharɨgharɨ lemoyo thɨ raka na vethɨ thuwe budakai me yomara. ");
INSERT INTO tgo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mbaŋa thɨ rakamena weya Jisas, thɨ vaidiya amalako nyaoma raraitharɨ menanjiwe. I yaku gheko, i njimbo ri na umbaliye kaero i thovuye; na taulaghɨko thiya mararu laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Thavala inanjiwe thɨ utugiya gharɨgharɨko weŋgi ŋgoroŋga nyaoko raraitharɨ methɨ rakaraŋgi weya amalako na budakai me gharɨŋgiya mbomboma. ");
INSERT INTO tgo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mbaŋa thɨ loŋwevaidi thɨ naŋgo vurɨgheghe weya Jisas na i iteteŋa lenji valɨvaŋgako. ");
INSERT INTO tgo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mbaŋa Jisas vama i tha vara e waŋgako amba amalako nyaoma raraitharɨ menanjiwe i naŋgo vurɨgheghewe na i wa weiye. ");
INSERT INTO tgo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ko Jisas mava i vatomwe. Iyemaeŋge i dagewe iŋa, “U njogha e ghamban weŋgiya len bodaboda na voutu weŋgi ŋgoroŋga Giya le vakatha na le gharevɨrɨ le laghɨlaghɨye e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Amalako i iteteŋgi na i ruvao e ghembaghembama ghembayaworoma, i utuŋa bigibigiko laghɨlaghɨye budakai Jisas me vakathakowe. Taulaghɨko thɨ loŋwe na gharenji i yo laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas na gharaghambu thɨ njogha Galili Njighɨniye valɨvaŋga. Woye laghɨye thɨ meghɨliŋa. ");
INSERT INTO tgo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Amala regha idae Jairas, iye ŋgolo kururu gharambarombaro regha, i vutha. Mbaŋa i thuwe Jisas i dobu e gheghe, ");
INSERT INTO tgo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na i naŋgo weiye ghare le vatomwe weya Jisas iŋa, “Yawarumbuŋgu nasiye i ghambwera laghɨye moli. Nuwaŋguiya weiŋgu ghen vo bigiraweya nɨmanɨmanɨna e vwatae na riwae i thovuye, thava i mare.” ");
INSERT INTO tgo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Amba Jisas i wa weiye. Gharɨgharɨ lemoyo moli weinji, vavana e njawanjawaeŋgi, vavana e ghamwae na vavana e ghereiye. ");
INSERT INTO tgo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ela eunda i ghataŋa voruvoru theghathegha hoyaworo na umboiwo e tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Rathawathawari i ghanagha va thɨ mando na thɨ thawari. I thɨvaivao le bigibigi weŋgi, ko iyemaeŋge ma riwae i thovuye, vama i vurɨgheghe eŋge. ");
INSERT INTO tgo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Vama i loŋweya Jisas le vakatha utuutuniye, iya kaiwae i ghathara wabwiko e tɨnenji Jisas e ghereiye, ");
INSERT INTO tgo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","na tembe i dageweva ghamberegha iŋa, “Thoŋgo ma ya vɨghathɨ eŋge ghakwamako, wo ghambwerake ne iko.” ");
INSERT INTO tgo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","I vɨghathɨgha ghakwamako na e mbaŋako iyako voruvoruko iko na i ghamɨno riwaeko e tɨne ghaghambwerako kaero iko. ");
INSERT INTO tgo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","E mbaŋako iyako Jisas i ghamɨno vurɨgheghe vama i raŋgiwe, iya kaiwae i matavɨ weŋgiya wabwiko na i vaito iŋa, “Thela me vɨghathɨgha wo kwamake?” ");
INSERT INTO tgo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Gharaghambuko thɨ gonjoghawe thɨŋa, “Wo u thuwe wabwi laghɨye moli thɨ ndeghɨliŋaŋge, na buda kaiwae uŋa, ‘Thela me vɨghathɨŋgo?’” ");
INSERT INTO tgo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ko Jisas i ghɨmaratakwa ghadidiye, nuwaiya i vaidiya thela me vɨghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Elako vama i ghareghare budakai me yomarawe, i mena weya Jisas weiye le mararu na le gharelaghɨlaghɨ, i ronja e gheghe vuvuye Jisas e gheghe na i utugiyawe utuutuniyeko wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas i dagewe iŋa, “Yawarumbuŋgu, len loŋweghathɨ kaero i vamoruŋge. U wa wein len gharemalɨlɨ. Ghanɨvɨrɨ kaero iko.” ");
INSERT INTO tgo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas vamba i utuutu weya elako gharɨgharɨ vavana kaero thɨ vutha, thɨ mena Jairas ele ŋgolo na thɨ dagewe thɨŋa, “Yawarumbuma kaero me mare. Buda kaiwae u rombelembela Ravavagharena?” ");
INSERT INTO tgo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mbaŋa i loŋwevaidi lenji utuko, mava i goruwe, ko i dagewe iŋa, “Tha u mararu, ma u loŋweghathɨ eŋge.” ");
INSERT INTO tgo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mbaŋa thɨ wareri, ma tembe i vatomweva lolo regha na weiye, vambe Pita eŋge Jemes na ghaghae Jon. ");
INSERT INTO tgo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mbaŋa thɨ vutha Jairas ele ŋgolo Jisas i vaidiya numounouno na i loŋweya thiya randa na thɨ raŋivetho laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I ru na i dage weŋgi iŋa, “Buda ghanumounounoke? Buda kaiwae huya randa? Ŋgamake ma i mare, mbema i ghena eŋge!” ");
INSERT INTO tgo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Taulaghɨko thɨ vavɨra Jisas. I dage vurɨgheghe weŋgi na thɨ rakaraŋgi e ŋgoloko, amba i vaŋguŋgiya ŋgamako ramae na tɨnae na gharaghambu theghetoko, na thɨ ru ŋgorava ŋgamako inawe. ");
INSERT INTO tgo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","I vɨghathɨ e nɨmae na i dagewe iŋa, “Talitha kum,” gharumwaru, “Wevo nasiye, ya dage e ghen, u thuweiru!” ");
INSERT INTO tgo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","E mbaŋako iyako wevoko i thuweiru na i loŋga (ghatheghathegha va hoyaworo na umboiwo), na e mbaŋaniye gharenji i yo laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ko Jisas i dage vurɨgheghe weŋgi thava thɨ utugiya weya lolo regha budakaiya me vakathawe. Amba iŋa, “Hu giya ghanɨŋgawe!” ");
INSERT INTO tgo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas va i iteta ghembako iyako na i njogha weiyaŋgiya gharaghambu e ghambae moli. ");
INSERT INTO tgo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat e tɨne i vavaghare Jiu e lenji ŋgolo kururu tɨne. Gharɨgharɨ lemoyo va inanji gheko na mbaŋa thɨ loŋweya le vavaghareko gharenji i yo laghɨye na thɨŋa, “Amalake iyake, aŋga mendava ve wo ghareghareke thiyake? Thambo thimbake na aŋga mendava ve wo na i vakathaŋgiya vakathake ghamba rotaele thiyake? ");
INSERT INTO tgo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mbema kapentama iyana, Meri nariye na oghaghae Jemes, Josep, Judas na Saimon. Oloulouye mbe inanji gheke.” Gharenji i gaithɨwana na thɨ botewoyathu. ");
INSERT INTO tgo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iya kaiwae Jisas i dage weŋgi iŋa, “Gharɨgharɨ e valɨvaŋgake wolaghɨye thɨ yavwatatawana Loi ghalɨŋae gharautu, ko ghambae gharɨgharɨniye, gheuu gharɨgharɨniye na le bodaboda mava thɨ yavwatatawana.” ");
INSERT INTO tgo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kaiwae ma thɨ loŋweghathɨ, ma valɨkaiwae i vakatha mun vakatha ghamba rotaele regha gheko ko vambe i lirawe eŋge nɨmae ghambweghambwera vavana e riwanji na riwanji i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ghare i yo laghɨye kaiwae mava e lenji loŋweghathɨ. Amba Jisas i wa e ghembaghemba e valɨvaŋgako iyako na i vavaghare weŋgiya gharɨgharɨ. ");
INSERT INTO tgo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisas i kula vathavathaŋgiya gharaghambu theyaworo na theghewo na i variyeŋgi, theghewo iya. I giya mbaro weŋgi na valɨkaiwae thɨ variye raŋgiyaŋgiya nyao raraitharɨ weŋgiya gharɨgharɨ. ");
INSERT INTO tgo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","I dage weŋgi iŋa, “E lemi loŋgana tɨne, ne hu ndewo bigi reghava, ghanɨŋga o raloŋgaloŋga lenji nambo o mani, mbe pwasike eŋge. ");
INSERT INTO tgo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hu njimbo gheghemi ghae, ko ne hu ndeliya kwama yaŋgarava.” ");
INSERT INTO tgo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tembe i dageva weŋgi iŋa, “Mbaŋa vohu vutha e ghemba na thɨ kula vathaŋga, hu yaku e ŋgoloko iyako ghaghad hu itete ghembako iyako. ");
INSERT INTO tgo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Thoŋgo hu vutha e ghemba na gharɨgharɨ ma thɨ kula vathaŋga o ma thɨ loŋweya lemi utu, hu iteta ghembana iyana. Mbaŋa hu iteteŋa hu tagavughethu vughana e gheghemina. Iyake ne i vanuwovɨrɨŋgi Loi i botewoyathuŋgi kaiwae ma thɨ loŋweya lemi utuna.” ");
INSERT INTO tgo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Thɨ rakaraŋgi na thɨ vavaghare mbala gharɨgharɨ thɨ uturaŋgiya lenji tharɨ na thɨ roiteteŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Thɨ variye raŋgiyaŋgiya nyao raraitharɨ na thɨ liŋgiya bunama idae olivɨ ghambweghambwera e riwanji na riwanji i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kiŋ Herod i loŋweya Jisas le kaiwo utuutuniye, kaiwae utuniye vama i vaghɨliya Galili laghɨyeko. Ko iyemaeŋge Jisas utuniye gharɨgharɨ vavana thɨŋa, “Jon Rabapɨtaiso kaero mendava i thuweiru na ma e yawayawaliyeva. Iya kaiwae vurɨgheghe inawe na i vakathaŋgiya vakathake ghamba rotaele thiyake.” ");
INSERT INTO tgo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vavana thɨŋa, “Iye Ilaija.” Na vavana mbe thɨŋava, “Iye Loi ghalɨŋae gharautu, ŋgoreiya va Loi ghalɨŋae gharautu i vivako.” ");
INSERT INTO tgo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mbaŋa Herod i loŋweya Jisas utuniye kaero iŋa, “Jon Rabapɨtaiso iyako! Va yaŋa na thɨ kitena numwema, ko mendava i thuweiru na kaero e yawayawaliyeva.” ");
INSERT INTO tgo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod i loŋweghathɨ iyake kaiwae va mbaŋa regha i variyeŋgiya ragagaithɨ na thɨ yalaweya Jon, thɨ ŋgarɨ na thɨ woruwo e thiyo. Herod va i vakatha ŋgoreiyako Herodiyas kaiwae, kaiwae vama i vaŋgu othembe elaghɨniye ghaghae Pilip levo. ");
INSERT INTO tgo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon iye va i vathivalaŋa weya Herod iŋa, “Ma mbaro i vatomwe na u vaŋgwa ghaghanɨna levo!” ");
INSERT INTO tgo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Iya kaiwae Herodiyas ghare i gaithɨwana Jon na nuwaiya i unɨghɨ, ko mava valɨkaiwae, ");
INSERT INTO tgo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kaiwae Herod va i mararu Jon na i ghareghare iye lolo rumwarumwaruniye na i boboma; vambema i njimbukikiya eŋge. Mbaŋa regha na regha Herod mbe i loŋwa Jon othembe ghare mava i warariŋa na ma i ghareghare mbala ne i vakatha. ");
INSERT INTO tgo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mbaŋa regha amba Herodiyas ghambaŋa thovuye regha i mena na i unɨgha Jon. E mbaŋako iyako Herod i vakatha le ghambɨ gharenuwaŋakiki ghathaga, amalaghɨniye lenji rakakaiwo laghɨlaghɨye, ragagaithɨ lenji randevivaŋgi na Galili giyagiyaniye kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiyas yawarumbuye i mena i ru na i thari. Herod na giyagiyako methɨ rakaruko e thagako thɨ warari laghɨye le thariko kaiwae. Amba Herod i dagewe iŋa, “The bigiya nuwaniya ne u naŋgo e ghino ya wogiya e ghen!” ");
INSERT INTO tgo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Amba i tholo iŋa, “Ya dage e ghen, thebigiya ne u naŋgoŋa, othembe lo ghamba mbaroke mboro ne ya woveŋge.” ");
INSERT INTO tgo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Amba wevoko i raŋgi na ve vaito tɨnae iŋa, “Ne ya naŋgo weya budakai kiŋɨkowe?” Tɨnae i gonjoghawe iŋa, “Jon Rabapɨtaiso umbaliye.” ");
INSERT INTO tgo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","E mbaŋako iyako wevoko i rukunjogha weya kiŋɨko na veŋa, “Nuwaŋguiya e mbaŋake iyake u kitena Jon Rabapɨtaiso numwe na u womena umbaliye e gaeba.” ");
INSERT INTO tgo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Iyake i vakatha Kiŋ Herod nuwae i tharɨ laghɨye moli, ko mava valɨkaiwae i gotena le renuwaŋako kaiwae kaero me tholo giyagiyako inanji e thagako iyako e maranji. ");
INSERT INTO tgo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","E mbaŋako iyako i variya le ragagaithɨ regha na i dagewe ve wo Jon umbaliye na i woma. Ragagaithɨko i wa na ve kitena Jon numwe e thiyo tɨne, ");
INSERT INTO tgo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","amba i womban umbaliye e gaeba, i thɨnɨmena na i thɨnɨgiya weya wevoko na ve thɨnɨgiya weya tɨnae. ");
INSERT INTO tgo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mbaŋa Jon gharaghambu thɨ loŋweya iyake, thɨ mena thɨ wo riwae na thɨ beku. ");
INSERT INTO tgo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mbaŋa ghalɨŋaeko gharaghambɨ va i variyeŋgima thɨ rakanjogha, thɨ mevathavatha weinji Jisas, na thɨ utugiya lenji vakatha na vavaghareko utuniye. ");
INSERT INTO tgo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gharɨgharɨ thɨ ghanagha thɨ rakamena na thɨ raka. Jisas na gharaghambu ma e ghanjimbaŋa na valɨkaiwae thɨ ghanɨŋga. Iya kaiwae i dage weŋgi iŋa, “Wo ra raka e valɨvaŋga regha, mbe ghinda eŋge, na wo vara towowe.” ");
INSERT INTO tgo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Amba thɨ rakatha e waŋga mbe thiye eŋge na thɨ raka e valɨvaŋga ma gharɨgharɨniye. ");
INSERT INTO tgo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ko iyemaeŋge gharɨgharɨ i ghanagha e valɨvaŋgake wolaghɨye thɨ thuweŋgi na thɨ ghareghare thavalaŋgiyako, iya kaiwae mbema ghenji na nɨmanji eŋge, thɨ raka ŋgalai e Galili Njighɨniye ghadidiye na vethɨ vuthakai, muyai amba Jisas na gharaghambu thɨ womaru. ");
INSERT INTO tgo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mbaŋa Jisas i nja e waŋga na i thuwe wabwi laghɨye, ghare i vɨrɨ laghɨye moli kaiwanji kaiwae ŋgoranjiya sip ma e ghanjiranjimbunjimbu. Iya kaiwae i vavaghareŋa bigibigi i ghanagha weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yeghɨyeghɨye e mbaŋako iyako, gharaghambu thɨ mena thɨ dagewe thɨŋa, “Kaero yeghɨyeghɨye moli na vanatherowo iyake. ");
INSERT INTO tgo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","U variyeŋgiya gharɨgharɨna, u dage weŋgi na thɨ raka e ghembaghemba nanasiye e valɨvaŋgake iyake na tembe thiye thɨ tamweya ghanji, thɨ vamodo na thɨ ghan.” ");
INSERT INTO tgo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ko iyemaeŋge Jisas i gonjogha weŋgi iŋa, “Ghemi hu giya ghanɨŋga weŋgi na thɨ ghan!” Gharenji i yo laghɨye moli na thɨ vaito thɨŋa, “Thare nuwaniyaime vo giya mani gethɨseriyeiwo (200) na wo vamodo ghanɨŋgawe na wo vaŋamweŋgiwe?” ");
INSERT INTO tgo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisas i vaitoŋgi iŋa, “Bred mbumbuviye na weŋga? Hu wa na vohu thuwe.” Mbaŋa vethɨ thuwe, thɨ dagewe thɨŋa, “Bred mbumbulima na borogi umboiwo.” ");
INSERT INTO tgo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Amba Jisas i dage weŋgiya gharaghambuko iŋa, “Hu dage weŋgiya gharɨgharɨna thɨ mevathavatha e wabwi nanasiye na thiya yaku e nanana vwatavwata.” ");
INSERT INTO tgo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gharɨgharɨko thiya yaku wagiyawe e wabwi nanasiye. Wabwi vavana munɨthaŋarɨ (100) iya na wabwi vavana munɨyelima (50) iya. ");
INSERT INTO tgo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Amba Jisas i mbanɨŋgiya bredɨko mbumbulimako na borogiko umboiwoko, i ghɨmara voro e buruburu na i vata ago weya Loi ghanɨŋgako kaiwae. I njiviyaviya bredɨko mbumbulimako na i giya weŋgiya gharaghambuko na thɨ giya weŋgiya gharɨgharɨko. Vambe i njiviyaviyava borogiko umboiwo na i giya weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Taulaghɨko thiya ghanɨŋga na valɨkaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Amba gharaghambu thɨ mbanɨvanjaraŋgiya nambonambo ŋgamwayaworo na ŋgamwaiwo bred na borogiko methɨ ghanɨvareŋgiko. ");
INSERT INTO tgo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ghɨmoghɨmoruko va thiya ghanɨŋgako lenji ghanaghanagha paeb tausan. ");
INSERT INTO tgo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Va e mbaŋako iyako i variyeŋgiya gharaghambu thɨ tha e waŋga na thɨ womaviva e ghamwae Betɨsaida, Galili Njighɨniye valɨvaŋga regha na amalaghɨniye wo i variyeŋgiya gharɨgharɨko na thɨ raka. ");
INSERT INTO tgo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I ghawoloŋgiyana e ghereiye, i voro e ou ghadidiye na i naŋgowe. ");
INSERT INTO tgo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Vama i limomouwo na waŋgama vama inanji e njighɨko ghalughawoghawo na Jisas amba ina vanatɨna ghamberegha. ");
INSERT INTO tgo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","I thuwe gharaghambuko thɨ rovurɨgheghe e wodo kaiwae va thɨ wodo na i ghemba ndewendeweko ghamwae. Vama ghanono ighɨviya rakaraka Jisas i loŋga e njighɨ vwatae na i mena weŋgi. Mbalavama i lareŋa weŋgi, ");
INSERT INTO tgo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ko mbaŋa va thɨ vaidiya i loŋgaloŋga e njighɨko vwatae, thɨŋa eŋge kaka, iwaeŋge thɨ yaro, ");
INSERT INTO tgo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kaiwae taulaghɨko va thɨ thuwe na thɨ mararu. Ko e mbaŋako iyako Jisas i dage weŋgi iŋa, “Tha ghanjigharelaghɨlaghɨ! Tha huya mararu! Ghino Jisas!” ");
INSERT INTO tgo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Amba i tha e waŋgako weiyaŋgi na ndewendeweko i mare. Vama i wo vara gharaghambuko nuwanji, ");
INSERT INTO tgo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kaiwae othembe va thɨ thuwe i mbana bred mbumbulima na i vaŋamweŋgiya wabwi laghɨyewe ma vamba nuwanjiko i rumwaruŋa thela Jisas, kaiwae gharenjiko vamba i vurɨgheghe. ");
INSERT INTO tgo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Vama thɨ golawa valɨmbwa na vethɨ goru vanatɨna e ghemba regha idae Genesaret na thɨ sowo lenji waŋgakowe. ");
INSERT INTO tgo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mbaŋa thɨ rakanja e waŋgako gharɨgharɨ kaero thɨ ghareghare Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Amba gharɨgharɨ thɨ yoruku na thɨ raka e ghembaghemba e vanautumako iyako tɨne, thɨ bigiŋgiya ghambweghambwera weinjiyaŋgiya lenji ghamba ghena na vethɨ loŋwevaidiya Jisas utuniye aŋga inae na thɨ yobigiwe. ");
INSERT INTO tgo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","E the valɨvaŋga Jisas va ve vuthawe, e ghembaghemba nanasiye na laghɨlaghɨye na the valɨvaŋga gharɨgharɨ inanjiwe, gharɨgharɨ thɨ bigimenaŋgiya ghanjiune thiya ghambwera ŋgora ghamba me vathavatha na thɨ naŋgo vurɨgheghewe thɨŋa, “Thare u vatomwe na ghambweghambwerake thɨ vɨghathɨgha ghanɨkwamana mbothiye?” Thavala va thɨ vɨghathɨ, taulaghɨko riwanji i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mbaŋa regha Parisi na mbaro gharavavaghare vavana thɨ mena Jerusalem na thɨ meghɨliŋa Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Thɨ thuweŋgiya Jisas gharaghambu vavana thiya ghanɨŋga mava thɨ thavwiya nɨmanɨmanji ŋgoreiya ghanjithanavu. ");
INSERT INTO tgo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kaiwae thiye Parisi na Jiu taulaghɨko thɨ ghambugha ŋgoroŋga orumburumbunji va thɨ valawe weŋgi. Amba mane thɨ ghanɨŋga ghaghada ne thɨ thavwiya nɨmanji ŋgoreiya ghanjithanavu. ");
INSERT INTO tgo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mbaŋa thɨ njogha e ghamba maket, amba mane thɨ ghanɨŋga ghaghad ne thɨ thavwiya ghanjimberegha ŋgoreiye ghanjithanavuke iyake. Tembe ŋgoreiyeva thanavu i ghanagha thɨ ghambu thɨ mena weŋgiya orumburumbunji, ŋgoreiya ndeghɨ, uye na gaeba ghanjighethavwi. ");
INSERT INTO tgo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Amba Parisi na mbaro gharavavaghare thɨ vaito Jisas thɨŋa, “Buda kaiwae ghanɨraghambuna ma thɨ ghambugha ŋgoroŋga orumburumbunda va thɨ valawe weinda, iyemaeŋge ma thɨ thavwiya nɨmanɨmanji kaero thiya ghanɨŋga?” ");
INSERT INTO tgo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisas i gonjogha weŋgi iŋa, “Aiseya va i utuŋake mbema emunjoru. Mamimina ghavwalaiwo ŋgoreiya va i rori: “‘Loi iŋa “Gharɨgharɨke thiyake e ghaenjike njimwae thɨ yavwatata wanaŋgo, ko gharenjiko i bwagabwaga moli e ghino. ");
INSERT INTO tgo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma thɨ kururu emunjoru e ghino, thɨ vavaghareŋa gharɨgharɨ lenji renuwaŋa na thɨŋava Loi le mbaro.” ’” ");
INSERT INTO tgo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Amba Jisas iŋa, “Hu gheneviyathu Loi le mbaro, na hu vikiki eŋge mbaroŋgina iya gharɨgharɨna thɨ vakatha.” ");
INSERT INTO tgo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na Jisas i gotubwe iŋa, “Mbema hu thimba vara, iya hu botewo Loi le mbaroke na hu vikikighathɨ eŋge ghemi ghamivavaghare. ");
INSERT INTO tgo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wo hu thuwe! Mosese i giya Loi le mbaro weinda iŋa, ‘U yavwatata wanaŋgiya tɨna na rama,’ na reghava ‘Thela i utuvatharɨ weŋgiya tɨnae na ramae valɨkaiwae moliya i mare.’ ");
INSERT INTO tgo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ko ghemi hu munjeva huŋa i thovuye eŋge thoŋgo lolo regha i dage weŋgiya tɨnae na ramae iŋa: ‘Ma munje ya giya bigibigi vavana weŋga na i thalavuŋga, ko mbaŋake kaero ma dagerawe weya Loi’. ");
INSERT INTO tgo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mane hu vatomwe na te i vakathava bigi regha tɨnae na ramae kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","E kamwathɨke iyake hu vavagharena iya hu valawe weŋgiya ghamunena huŋava Loi le mbaro ma e ghathovuye. Na bigibigi thɨ ghanagha ŋgoranjiyake hu vakathaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas i kula vathavathaŋgiya gharɨgharɨ lemoyo na mbowo thɨ rakamenaweva, na iŋa, “Taulaghɨna ghemi, hu vandeŋeŋgo na hu ghareghare budakaiya ne ya utuŋake weŋga. ");
INSERT INTO tgo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Thebigiya ra ghan ma i vambɨghɨyainda, ko budakai i raŋgima e ghaendake, iyake i vambɨghɨyainda.” ");
INSERT INTO tgo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jisas iŋa, “Thoŋgo e yanayanawami hu vandeŋe wagiyawe ghalɨŋaŋguke na hu ghareghare.” ");
INSERT INTO tgo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mbaŋa i iteteŋaŋgiya wabwiko na i ru e ŋgolo tɨne amba gharaghambuko thɨ naŋgowe na i vamanjamanjalaŋa goghaimba iyako weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisas i dage weŋgi iŋa, “Ko amba ma nuwamina i manjamanjalaŋa? Amba ma hu ghareghare, budakai lolo i ghan ma valɨkaiwae i vakatha i mbighɨ? ");
INSERT INTO tgo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kaiwae ma venja lolo e ghare, nandere, venja eŋge e ŋgamoiye na ve reŋa mbe ele kamwathɨ na ve raŋgi.” (Iya kaiwae mbema ra ghanɨŋgaeŋge.) ");
INSERT INTO tgo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na mbowo iŋava, “Budakai i raŋgima e gharendake, iyako i vambɨghɨyainda. ");
INSERT INTO tgo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kaiwae i mena maya e gharenda na i raŋgi, ŋgoranji: renuwaŋa raraitharɨ, vavaghena, kaivɨ, gabo, yathima, ");
INSERT INTO tgo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","votha, vakatha thanavu raitharɨ, utu kwanɨkwan, rokiwodowodo, yamwakabu, utu rere, wovorevoreŋa, na unouno. ");
INSERT INTO tgo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Thanavuke raraitharɨ wolaghɨye thiyake thɨ raŋgima lolo e ghare, thiyake thɨ vambɨghɨyainda.” ");
INSERT INTO tgo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Amba Jisas i iteteŋa ghembako iyako na i wa Taiya ele valɨvaŋga. I ru e ŋgolo regha tɨne na ma nuwaiya lolo regha i ghareghare ina gheko, ko ma valɨkaiwae i kubaro. ");
INSERT INTO tgo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ela eunda, ma Jiu, va i virɨ Poenisiya ele valɨvaŋga Siriya e tɨne. Elako yawarumbuye nyao raitharɨ inawe. I loŋweya Jisas utuniye na i menawe e mbaŋako iyako i ronja e gheghe vuvuye. I naŋgo vurɨgheghewe iŋa, “Thare valɨkaiwae, u variyeraŋgiya nyaoko raitharɨ yawarumbuŋgukowe!” ");
INSERT INTO tgo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ko Jisas i utuŋa Jiu utuninji iya iŋake, “Wo ra ŋamwekaiŋgiya gamagai. Ma valɨkaiwae ra wo gamagai ghanji na ra wokiyathu weŋgiya mbughambugha.” ");
INSERT INTO tgo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","I gonjoghawe iŋa, “Amalana, othembe mbughambugha thɨ ghana gamagai ghanji murimuriye e ghamba ghanɨŋga raberabe.” ");
INSERT INTO tgo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iya kaiwae Jisas i dagewe iŋa, “Kaiwae len gonjoghana len loŋweghathɨ i woraŋgiya, u njogha e ŋgolo. Nyaoma raitharɨ kaero me raŋgi weya yawarumbuma.” ");
INSERT INTO tgo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","I njogha e ŋgolo na i vaidiya yawarumbuye riwae kaero i thovuye na i ghena e ghamba, nyaoma raitharɨ kaero me raŋgiwe. ");
INSERT INTO tgo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Amba Jisas i iteta Taiya le valɨvaŋga, i ghathara Saidon na Ghembaghemba Ghembayaworo e lenji valɨvaŋga na i wa venja Galili Njighɨniye. ");
INSERT INTO tgo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Gharɨgharɨ vavana thɨ womenawe amala regha yanawae i kule na ma valɨkaiwae i utu. Thɨ naŋgo vurɨgheghe weya Jisas na i bigiraweya nɨmanɨmae e vwatae. ");
INSERT INTO tgo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Amba Jisas i vaŋguiteteŋgiya wabwiko na ghamberegha moli, i bigiraweya nɨmae lɨkelɨkeke amalako e yanayanawae na i njoŋgo na i vɨghathɨ amalako e mamiye. ");
INSERT INTO tgo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Amba Jisas i ghɨmara voro e buruburu, i momao laghɨye na i dage weya amalako iŋa, “Epɨpatha,” gharumwaru, “U mavu!” ");
INSERT INTO tgo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","E mbaŋako iyako amalako yanayanawae na ghalɨŋae thɨ mavu amba i utu na ghalɨŋae i manjamanjala. ");
INSERT INTO tgo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Amba Jisas i dageten weŋgiya gharɨgharɨ na ne thɨ ndeutugiya weya lolo regha. I vurɨgheghe na i dageten weŋgi, ko mbaŋa regha na regha ma thɨ rena thɨ utuŋa eŋge budakaiya me vakatha. ");
INSERT INTO tgo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Taulaghɨko iya va thɨ vandeŋeko gharenji i yo laghɨye moli, thɨŋa, “Bigibigike wolaghɨye amalake iyake i vakathaŋgi i thovuye. Mbe i thawariŋgiva gharɨgharɨ ma thɨ loŋwe na gharɨgharɨ ma e ghalɨghalɨŋanji.” ");
INSERT INTO tgo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ma va mbaŋa molao e ghereiye wabwi laghɨye thɨ mevathavatha. Kaiwae ghanji vama iko, Jisas i kula vathaŋgiya gharaghambu na i dage weŋgi iŋa, ");
INSERT INTO tgo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ghareŋgu i vɨrɨ gharɨgharɨke thiyake kaiwanji, kaiwae mbaŋa mbaŋato weiŋguyaŋgi na ghanji kaero iko. ");
INSERT INTO tgo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Thoŋgo ya variyeŋgi na thɨ njogha e ghemba na ma ya vaŋamweŋgi, ne ghare thavwathavwavo i nja weŋgi e kamwathɨ mborowa kaiwae vavana ghambanji bwagabwaga.” ");
INSERT INTO tgo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Gharaghambu thɨ vaito thɨŋa, “Aŋga ne ra vaidiya ghanɨŋga laghɨye na valɨkaiwae ra vaŋamweŋgiya gharɨgharɨke wolaghɨye thiyake? Vanatherowoke iyake.” ");
INSERT INTO tgo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Amba Jisas i vaitoŋgi iŋa, “Bred mbumbuviye na weŋga?” Thɨŋa, “Mbumbupirɨ.” ");
INSERT INTO tgo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","I dage weŋgiya wabwima na thiya yaku bode. Amba i mbana bredɨko mbumbupirɨko na i vata ago weya Loi, i njiviyaviya na i giya weŋgiya gharaghambuko na thɨ giya weŋgiya wabwima, na gharaghambuko thɨ vakatha ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vambe e ghanjiborogi nanasiye seiwova. Jisas i vata ago kaiwae na i dage weŋgiya gharaghambuko tembe thɨ giyava. ");
INSERT INTO tgo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Taulaghɨko thiya ghanɨŋga na valɨkaiwanji. Amba gharaghambuko thɨ mbanɨŋgiya methɨ ghanɨvareŋgima na thɨ mban vanjaraŋgiya nambonambo ŋgamwapirɨ. ");
INSERT INTO tgo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iyava thiya ghanɨŋgako ghɨmoghɨmoru lenji ghanaghanagha po tausan. Amba i variyeŋgi na thɨ raka, ");
INSERT INTO tgo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na e mbaŋako iyako weiyaŋgiya gharaghambu thɨ tha e waŋga na thɨ golawa thɨ wa Dalamanuta ele valɨvaŋga. ");
INSERT INTO tgo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mbaŋa Parisi vavana thɨ loŋwevaidiya Jisas ina gheko thɨ mena thɨ wogaithɨ weinji. Va nuwanjiya thɨ mando iyava thɨ dagewe na thɨŋa, “U vakatha vakatha ghamba rotaele regha na wo thuwe, na wo ghareghare emunjoru len vurɨgheghena i mena weya Loi o nandere.” ");
INSERT INTO tgo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas le renuwaŋa i vuyowo, i thɨnɨnjoŋa ghatenuwanuwa, na iŋa, “Buda kaiwae ghemi thake iyake ghemi nuwami ya vakatha vakatha ghamba rotaele regha kaiwami na hu thuwe? Ya dage emunjoru e ghemi, mane ya vakatha vakatha regha kaiwami!” ");
INSERT INTO tgo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Amba i iteteŋgi, na ve tha e waŋgako na ma thɨ gonjoghava e valɨvaŋga regha. ");
INSERT INTO tgo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ko iyemaeŋge gharaghambu thɨ renuwaŋa vaghalawe na ma thɨ mbana bred i ghanagha, vambe mbumbura eŋge ina e waŋgako. ");
INSERT INTO tgo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas i dage vavurɨgheghe weŋgi iŋa, “Hu njimbukiki wagiyawe! Hu njimbukiki wagiyaweŋga Parisi lenji isɨt na Herod le isɨt kaiwae!” ");
INSERT INTO tgo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gharaghambu thɨ veutu weŋgi thɨŋa, “Me utu ŋgoreiyako kaiwae ma mara ndewo mun bred.” ");
INSERT INTO tgo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas va i ghareghare gharaghambuko lenji vethoko rɨghe iwaeŋge i vaitoŋgi iŋa, “Buda kaiwae hu veutu weŋga bred kaiwae? Ko nuwamina mamba i rumwaru? Mbema emunjoru gharemi thɨ vuyowo! ");
INSERT INTO tgo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","‘Mbe e maramarami — ma hu thuwe? Na mbe e yanayanawami — ma hu loŋwe?’ Ko ma hu renuwaŋakiki ");
INSERT INTO tgo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mbaŋa va ya njiviyaviya bredɨma mbumbulimama gharɨgharɨma paeb tausan kaiwanji? Nambonambo ŋgamwaviye va hu mbanɨvanjaraŋgi e ghanjima vaŋgovaŋgothiye?” Thɨŋa, “Ŋgamwayaworo na ŋgamwaiwo.” ");
INSERT INTO tgo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na i gotubwe iŋa, “Na mbaŋa va ya njiviyaviya bredɨma mbumbupirɨma gharɨgharɨma po tausanɨma kaiwanji, nambonambo ŋgamwaviye va hu mbanɨvanjaraŋgi e ghanɨŋgama vaŋgovaŋgothiye?” Thɨ gonjoghawe thɨŋa, “Ŋgamwapirɨ.” ");
INSERT INTO tgo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jisas i dage weŋgi iŋa, “Ko amba ma nuwamina i rumwaru? Iya vakathaŋgiko ghamba rotaele va ya vakathaŋgiko thɨ woraŋgiya ya mena weya Loi.” ");
INSERT INTO tgo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Amba va thɨ womaru eŋge Betɨsaida kaero gharɨgharɨ vavana thɨ womena amala marae i kwaghe weya Jisas thɨ naŋgo vurɨgheghewe i vɨghathɨ na marae kaero i thovuye. ");
INSERT INTO tgo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas i vaŋgwa amalako maraeko i kwaghe e nɨmae na i vaŋguiteta ghembako. I njoŋgovuna marae amba i yabo e nɨmanɨmaeko na mbaŋa i ban kaero i vaito iŋa, “Thare u thuwe bigi regha?” ");
INSERT INTO tgo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Amalako kaero i thuwe na iŋa, “Ŋgoreiye, ya thuweŋgiya gharɨgharɨ ko ghanjithuwathuwa ŋgoreiya umbwaumbwama, thɨ rakaraka loloŋga eŋge.” ");
INSERT INTO tgo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas mbowo i bigiraweva nɨmanɨmae amalako e maramarae. Mbaŋaniye i ghɨmaratako i thuwe wagiyaweŋgiya bigibigiko wolaghɨye, maramaraeko kaero thɨ thovuyeva. ");
INSERT INTO tgo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisas i variye i wa ele ŋgolo na i dagewe iŋa, “Ne u ndewa e ghembana tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Amba Jisas na gharaghambu thɨ raka e ghembaghemba nanasiye Sisariya Pilipai ghadidiye. I vaitoŋgi e kamwathɨ mborowa iŋa, “Ko gharɨgharɨ thɨŋa thela ghino?” ");
INSERT INTO tgo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Thɨ gonjoghawe thɨŋa, “Vavana thɨŋa Jon Rabapɨtaiso, vavana thɨŋa Ilaija na vavana thɨŋa Loi ghalɨŋae gharautu regha i njoghama.” ");
INSERT INTO tgo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Amba i vaitoŋgi iŋa, “Na ghemi huŋa thela ghino?” Pita i gonjoghawe iŋa, “Ghen Krais ghen.” ");
INSERT INTO tgo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jisas i dage vurɨgheghe weŋgiya gharaghambuko na ne thɨ ndeutugiya weya lolo regha, thela amalaghɨniye. ");
INSERT INTO tgo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas i utuŋa le mare utuutuniye weŋgiya gharaghambu iŋa, “Lolo Nariye ghino ne ya vaidiŋgiya vuyowo i ghanagha na Jiu lenji randeviva, ravowovowo laghɨlaghɨye na mbaro gharavavaghare ne thɨ botewoŋgo, na ne thɨ tagavamareŋgo, na mbaŋa theghetoninji e tɨne kaero ya thuweiruva.” ");
INSERT INTO tgo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Va i vamanjamanjalaŋa wagiyawe weŋgiya iya utuke iyake. Amba Pita i vaŋguiteteŋgiya ghauneko na i dagetenɨwe thava i utuŋaŋgiya utuutu ŋgoranjiŋgiyako. ");
INSERT INTO tgo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amba Jisas i ndevɨ na i thuweŋgiya gharaghambuko, na i ŋaelɨmbiya weya Pita iŋa, “U mena e ghereiŋguke, Seitan! Len renuwaŋana ma i reŋa Loi ele renuwaŋa, i reŋa gharɨgharɨ e lenji renuwaŋa.” ");
INSERT INTO tgo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Amba Jisas i kula vathavathaŋgiya wabwiko laghɨye weiyaŋgiya gharaghambu na i dage weŋgi iŋa, “Thoŋgo thela nuwaiya i ghambuŋgo, tembe ghamberegha i botewo iya nuwaeko nuwaiya i vakatha na i wovaira ghakros na i wo, amba i ghambuŋgo othembe vuyowo o mare. ");
INSERT INTO tgo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kaiwae thela thoŋgo nuwaiya i vamora yawaliye, ne i thɨvaghawa yawaliye, ko thela thoŋgo i vatomweya yawaliye ghino kaiwaŋgu na Toto Thovuye kaiwae ne i vaidiya yawalɨ memeghabananiye. ");
INSERT INTO tgo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ŋgoroŋga ghathovuye thoŋgo lolo regha i wo yambaneke laghɨye na i mbaroŋa, ko iyemaeŋge i thɨvaiya yawalɨ memeghabananiye? ");
INSERT INTO tgo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ne i wo budakai na i vamodanjogha yawaliyekowe? Nandere moli! ");
INSERT INTO tgo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kaiwae thoŋgo lolo regha i monjina wanaŋgo na i monjina wanaŋgiya ghalɨŋaŋguke e thake iya ragoriwoyathu na unounoke thiyake e tɨnenji, Ghino Lolo Nariye tembene ya monjinawanava mbaŋa ne ya njoghama weiŋgu Bwebwe le vwenyevwenye na weiŋguyaŋgiya nyao boboma.” ");
INSERT INTO tgo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Amba Jisas i dage weŋgi iŋa, “Ya dage emunjoru e ghemi, gharɨgharɨ vavana inanji gheke amba muyai thɨ mare wone thɨ thuweya Loi le mbaroko ghavurɨgheghe i woraweya rɨghe.” ");
INSERT INTO tgo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mbaŋa theghewona e ghereiye Jisas i vaŋguŋgiya Pita, Jemes na Jon, i viva weŋgi, na thɨ voro e ou molao regha mbe thiye eŋge. E maranji, Jisas ghayamoyamo i ghenevaghɨle, ");
INSERT INTO tgo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ghakwama i kaleva moli na i ndalandala. Le kakaleva i kivwala thela e yambaneke ne i thavwiya kwama na le kakaleva. ");
INSERT INTO tgo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Amba gharaghambuko theghetoko thɨ thuweŋgiya Ilaija na Mosese thɨ yomara, thɨ utu weinji Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita i dage weya Jisas iŋa, “Ravavaghare, i thovuye eŋge vara inanda gheke. Ne wo vakathaŋgiya yoŋathowathowa ŋgoloto, ŋgolora ghen, ŋgolora Mosese na ŋgolora Ilaija.” ");
INSERT INTO tgo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","I utu ŋgoreiyako kaiwae va thɨ mararu laghɨye, Pita mava i ghareghare ŋgoroŋga me utu na iŋa. ");
INSERT INTO tgo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Amba ŋgalɨlɨ ghambaghambaluwae i ganaŋgi na ghalɨghalɨŋa regha i mena e ŋgalɨlɨko e tɨne iŋa, “Iyake Naruŋgu, valɨghareghareŋgu moli. Hu vandeŋe wagiyawe.” ");
INSERT INTO tgo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","E mbaŋako iyako thɨ ghɨmaratako, ko mava te thɨ thuweva lolo regha, Jisas ghamberegha. ");
INSERT INTO tgo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mbaŋa va thɨ njamanjama e ouko, Jisas i dage vurɨgheghe weŋgi iŋa, “Ne hu ndeutugiya weya lolo regha iya bigiko mohu thuweko, ghaghada Lolo Nariye ne i thuweiru e mare tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Thɨ ghambugha ghalɨŋama na vambe thiye eŋge thɨ vevaitoŋgi ŋgoroŋga “thuweiru e mare” gharumwaru. ");
INSERT INTO tgo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Amba thɨ vaito Jisas thɨŋa, “Buda kaiwae mbaro gharavavaghare thɨŋa Ilaija ne i menakai amba muyai Mesaiya i mena?” ");
INSERT INTO tgo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisas i gonjogha weŋgi iŋa, “Emunjoru Ilaija ne i menakai na i vanamwe bigibigike wolaghɨye. Ko iyemaeŋge, buda kaiwae buk iŋa Lolo Nariye ne i vaidiya vuyowo laghɨye na thɨ botewoyathu? ");
INSERT INTO tgo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko ya dage e ghemi, Ilaija kaerova i mena na gharɨgharɨ thɨ vakatha thambo renuwaŋa nuwanjiya thɨ vakathawe, ŋgoreiya Buk Boboma Teuye le govambwara amalaghɨniye kaiwae.” ");
INSERT INTO tgo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mbaŋa Jisas na gharaghambuko theghetoko thɨ vutha weŋgiya gharaghambuma vavana, thɨ thuwe wabwi laghɨye thɨ roghɨliŋaŋgi na mbaro gharavavaghare vavana. Va thɨ wogaithɨ weinjiyaŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mbaŋa gharɨgharɨko thɨ thuwe Jisas, gharenji i yo laghɨye moli, thɨ rukuwe na thɨ dage mwaewowe. ");
INSERT INTO tgo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Amba Jisas i vaitoŋgiya gharaghambuko iŋa, “Hu wogaithɨŋa budakai weimiyaŋgiya mbaro gharavavaghare?” ");
INSERT INTO tgo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Amala regha e wabwiko tɨne i gonjoghawe iŋa, “Ravavaghare, ma vaŋgumena naruŋguke e ghen kaiwae nyao raitharɨ inawe na ma e ghalɨghalɨŋae. ");
INSERT INTO tgo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Thembaŋa nyaoko raitharɨ i mbaroŋa, i wokiyathu e thelau vwatae, njoŋgonjoŋgo i raŋgi e ghae, i rɨghɨmbiya ŋiŋiye na riwaeko laghɨye thɨ gheroro. Ma naŋgo weŋgiya ghanɨraghambuke na thɨ dage weya nyaoke raitharɨ i raŋgi, ko iyemaeŋge ma valɨkaiwanji methɨ vakatha.” ");
INSERT INTO tgo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas i dage weŋgi iŋa, “Ghemi ma e lemi loŋweghathɨ! Ŋgoroŋga mbaŋa le molamolao wo ya yaku weiŋguyaŋgiya ghemi? Ŋgoroŋga mbaŋa le molamolao ya ghataŋaghathɨŋga? Hu vaŋgumena weŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Thɨ vaŋgumena theghako weya Jisas. Mbaŋa nyaoko raitharɨ i thuwe Jisas, i vakatha theghako na riwae i mwanavatha na i dobu e thelauko vwatae na i bulabulale loloŋga na njoŋgonjoŋgo i raŋgi e ghae. ");
INSERT INTO tgo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas i vaito ramae iŋa, “Ŋgoroŋga mbaŋa le molamolao nyaoko raitharɨ le yaku weya theghako?” I gonjoghawe iŋa, “Vambe ŋgama vara. ");
INSERT INTO tgo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mbaŋa i ghanagha nyaoma raitharɨ i mando na i unɨghɨ, i wokiyathu e ndɨghe une o e mbwa tɨne. U gharevɨrɨŋaime na u thalavuime, thoŋgo valɨkaiwan.” ");
INSERT INTO tgo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisas iŋa, “Ŋgoroŋga len utuna gharumwaru, moŋana, ‘Thoŋgo valɨkaiwan’? Kaiwae bigibigike wolaghɨye valɨkaiwae weya thelolo i loŋweghathɨgha Loi.” ");
INSERT INTO tgo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ŋgamako ramae e mbaŋako iyako i utu na ghalɨŋae laghɨye iŋa, “Ya loŋweghathɨ, ko ma i laghɨye. U thalavuŋgo na lo loŋweghathɨke i laghɨye.” ");
INSERT INTO tgo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mbaŋa Jisas vama i thuweŋgiya wabwiko ma i laghɨye eŋge, i dage weya nyaoko raitharɨ iŋa, “Ghen kule na kwaghe nyaoniye, ya dage e ghen na u raŋgima weya theghana na ma tene u ruweva mbaŋa regha.” ");
INSERT INTO tgo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nyaoko raitharɨ i yaro i vandindiya theghako riwae na i raŋgi. Ghayamoyamo ŋgoreiya i mare, iya kaiwae thɨ ghanagha thɨŋa, “I mare.” ");
INSERT INTO tgo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ko Jisas i vɨghathɨgha theghako nɨmae, i thalavu na i thuweiru, na i yondovirɨ. ");
INSERT INTO tgo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iyake e ghereiye Jisas i ru e ŋgolo tɨne. Gharaghambuko thɨ vaito thuwele thɨŋa, “Buda kaiwae ma valɨkaiwae mo variyeraŋgiya nyaoko raitharɨ?” ");
INSERT INTO tgo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisas i gonjogha weŋgi iŋa, “Ghakamwathɨ mbereghaeŋge, thoŋgo nuwamiya hu variyeraŋgiya nyao raitharɨ ŋgoreiyako, wo hu naŋgo weya Loi.” ");
INSERT INTO tgo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas na gharaghambu thɨ iteta valɨvaŋgako iyako na thɨ ghathara Galili. Jisas ma nuwaiya lolo regha i ghareghare aŋga inae, ");
INSERT INTO tgo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kaiwae i vavaghare weŋgiya gharaghambuko iŋa: “Lolo Nariye ne thɨ yalawe na thɨ unɨghɨ. Ko iyemaeŋge mbaŋa mbaŋatoniye e tɨne kaero i thuweiruva.” ");
INSERT INTO tgo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ko iyemaeŋge ma nuwanji i manjamanjala ŋgoroŋga le vavaghareko gharumwaru, na thɨ mararu thɨ vaito amalaghɨniye. ");
INSERT INTO tgo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Amba Jisas na gharaghambu thɨ raka mena Kapenaom, na mbaŋa vama thɨ ru e ŋgolo tɨne amba i vaitoŋgiya gharaghambuko iŋa, “Mohu wogaithɨŋa buda kaiwae e kamwathɨko mborowa?” ");
INSERT INTO tgo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","E lenji loŋga mborowae methɨ wogaithɨŋa thela ina e tɨnenjiko iye laghɨye, iya kaiwae thɨ monjina na thɨ rokubaro. ");
INSERT INTO tgo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisas i yaku na i kula vathavathaŋgiya gharaghambuko theyaworo na theghewoko na i dage weŋgi iŋa, “Thoŋgo thela nuwaiya i tabona laghɨye Loi e marae tembe i wonjoŋa ghamberegha na i muyai moli, na i tabo na rakakaiwo weŋgiya ghauneko.” ");
INSERT INTO tgo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jisas i vaŋgwa ŋgama nasiye regha na i vaŋgurawe i ndeghathɨ e tɨnenji. I tagavagaghala nɨmae ŋgamako e mborowae amba i dage weŋgi iŋa, ");
INSERT INTO tgo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Thela thoŋgo i kulavatha ŋgama regha ŋgora iyake e idaŋgu, iye i kulavathaŋgo; na thela thoŋgo i kulavathaŋgo, mambe i kulavatha eŋge ghino, tembe i kulavathava thela i variyeŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon i dagewe iŋa, “Ravavaghare, wo vaidiya amala regha i variye raŋgiyaŋgiya nyao raraitharɨ e idan. Na wo mando na wo dagetenɨwe kaiwae iye ma weinda.” ");
INSERT INTO tgo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas i dage weŋgi iŋa, “Thava hu dagetenɨwe, kaiwae ma valɨkaiwae lolo regha i vakatha vakatha ghamba rotaele regha e idaŋgu na e mbaŋako iyako kaero i utuŋava utu raraitharɨ kaiwaŋgu. ");
INSERT INTO tgo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kaiwae thela ma iye ghandathɨghɨya iye ghandau. ");
INSERT INTO tgo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ya dage emunjoru e ghemi, thela thoŋgo i thɨnɨgiya mbwa e ghemi na hu mun kaiwae ghemi woraghambu, emunjoru ne e modamodae.” ");
INSERT INTO tgo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","I gotubwe na iŋa, “Thoŋgo ra wo varɨ laghɨye na ra ŋgara loloko iyako e numwe na ra wokiyathu e ŋambuwoko tɨne, lithɨko iyako i laghɨye. Ko iyemaeŋge Loi ne i giya lolo regha ghalithɨ i laghɨye moli thoŋgo i vakatha ŋgama ŋgoreiyake regha i vakatha tharɨ na ma i loŋweghathɨŋgo. ");
INSERT INTO tgo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na thoŋgo nɨmanɨna i vakathaŋge na u vakatha tharɨ, u kitenɨyathu! I thovuye moli thoŋgo nɨman regha nandere na u vaidiya yawalɨ memeghabananiye, na thava nɨmanɨmanɨna theghewona na u wa vo ru Gehena, e ndɨgheko iya i meghabanako e tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","E ghembako iyako uleulema iya thɨ uleŋgiya gharɨgharɨma mane thɨ mare, na ndɨghema iya thɨ ndamawe mane mbaŋa regha i mare.” ");
INSERT INTO tgo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Na thoŋgo gheghenɨna regha i vakathaŋge na u vakatha tharɨ, u kitenɨyathu! I thovuye moli thoŋgo gheghen regha nandere na u vaidiya yawalɨ memeghabananiye, na thava gheghenɨna theghewo na vethɨ wokiyathu ruwoŋge Gehena e tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","E ghembako iyako uleulema iya thɨ uleŋgiya gharɨgharɨma mane thɨ mare, na ndɨghema iya thɨ ndamawe mane mbaŋa regha i mare. ");
INSERT INTO tgo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na thoŋgo maranɨna regha i vakathaŋge na u vakatha tharɨ, u vovavuthuyathu! I thovuye eŋge thoŋgo vo ru Loi ele ghamba mbaro wein maranɨna voghɨra eŋge, na thava maramaranɨna voghɨwo na vethɨ wokiyathuruwoŋge Gehena. ");
INSERT INTO tgo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","E ghembako iyako uleulema iya thɨ uleŋgiya gharɨgharɨma mane thɨ mare, na ndɨghema iya thɨ ndamawe mane mbaŋa regha i mare.” ");
INSERT INTO tgo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jisas mbowo i utuŋava ghanjithanavu kaiwae iŋa, “Gharɨgharɨke wolaghɨye ne thɨ ghamɨno tomethi vuyowo laghɨye ŋgoreiya ndɨghe, na thiyake thɨ woraŋgiya ghanjithanavu, i thovuye o i tharɨ. Ŋgoreiya vowo thɨ woraweya njighɨ na i vanamwe na i thɨna. ");
INSERT INTO tgo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Njighɨ iye i thovuye, ko thoŋgo njighɨko ghamɨnae ma ŋgoreiya njighɨ, ma te kamwathɨ reghava na valɨkaiwae ra vakatha na ghamɨnae i njogha. Iya kaiwae ghamithanavu ne ŋgoreiye njighɨ mbe e ghamɨghamɨnae na ghemi regha na regha hu yaku na ghamwami vanaora weimiyaŋgiya ghamunena.” ");
INSERT INTO tgo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Amba Jisas i iteteŋa ghembako iyako na i wa Judiya ele valɨvaŋga amba ve lawa e Walaghɨta Jorɨdan na i wa valɨvaŋga i vorovoro. Wabwi laghɨye mbowo thɨ raka menaweva na i vavaghare weŋgi ŋgora mbaŋake wolaghɨye i vakavakathama. ");
INSERT INTO tgo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi vavana thɨ menawe na thɨ munje thɨ mando. Thɨ vaito thɨŋa, “Thare la mbaro i vatomweya amala regha na i yawo weiye levo?” ");
INSERT INTO tgo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas i gonjogha weŋgi e vaito iŋa, “The mbaro Mosese va i giya weŋga?” ");
INSERT INTO tgo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Thɨ dagewe thɨŋa, “Mosese i vatomweya amala i liya yawo ghapeipa i vakatha na i ligiya weya levo na i variyeyathu.” ");
INSERT INTO tgo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisas i dage weŋgi iŋa, “Mosese va i roriya mbaroke iyake kaiwami kaiwae gharemina i vurɨgheghe. ");
INSERT INTO tgo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko hu renuwaŋakiki e rɨghendako, mbaŋa Loi va i vakatha yambaneke na buruburu, i vakatha ghɨmoru na wevo. ");
INSERT INTO tgo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Na ‘Iyake kaiwae ghɨmoru i iteteŋaŋgiya ramae na tɨnae, i tubwe weiye levo, ");
INSERT INTO tgo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na theghewoko thɨ tabo na ririwo regha.’ Ma te thɨ tabo na theghewova, nandere, thɨ tabo na regha moli. ");
INSERT INTO tgo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iya kaiwae budakaiya Loi vama i tubwe, thava te lolo reghava i rakayathu.” ");
INSERT INTO tgo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mbaŋa thɨ njogha thɨ ru e ŋgoloko tɨne gharaghambu thɨ vaito bigike iyake kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas i dage weŋgi iŋa, “Thoŋgo lolo regha i yawo weiye levo na kaero i vaŋguva wevo eunda iye kaero i yathima. ");
INSERT INTO tgo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tembe ŋgoreiyeva, thoŋgo wevo eunda i yawo weiye le ghɨmoru na kaero i vaŋguva ghɨmoru regha iye kaero i yathima.” ");
INSERT INTO tgo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gharɨgharɨ vavana va thɨ bigimenaŋgiya gamagai weya Jisas na i vɨghathɨŋgi e nɨmanɨmae na i naŋgo kaiwanji, ko iyemaeŋge gharaghambuko thɨ ŋaevwaŋaŋgiya gharɨgharɨko iya thɨ bigimenaŋgiko. ");
INSERT INTO tgo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mbaŋa Jisas i loŋweya iyake ghare i gaithɨ wanaŋgi na i dage weŋgiya gharaghambuko iŋa, “Hu vatomweŋgi na thɨ rakamena weŋgo, thava hu dagetenɨŋgi, kaiwae Loi le ghamba mbaro ina weŋgiya gharɨgharɨ ŋgoranjiya thiyena. ");
INSERT INTO tgo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya dage emunjoru e ghemi, thela ma i wo Loi le mbaro ŋgoreiya ŋgama, mane i ru Loi ele ghamba mbaro tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Amba i mbanɨŋgi i bigiraweya nɨmanɨmae e riwanji na i naŋgo weya Ramae ghare weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mbaŋa Jisas vama ve loŋgaloŋga amba amala regha i rukuŋa, i ronja e gheghe vuvuye e ghamwae na i dagewe iŋa, “Ravavaghare thovuye, ne ya vakatha budakai na ya vaidiya yawalɨ memeghabananiye?” ");
INSERT INTO tgo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas i gonjoghawe iŋa, “Buda kaiwae uŋa ghino ya thovuye? Ma lolo regha i thovuye, Loi ghamberegha moli. ");
INSERT INTO tgo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Len vaitona kaiwae, u ghareghare Mosese le mbaro ŋgoroŋga iŋa: ‘Tha u gabo, tha u yathima, tha u kaivɨ, tha u wonjowe bwagabwaga, tha u valogha lolo nuwae mbala u mban le bigibigi, u yavwatata wanaŋgiya rama na tɨna.’” ");
INSERT INTO tgo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Amalako i dagewe iŋa, “Ravavaghare, mbaŋa vamba thegha vara ghino kaero ya ghambuŋgiya mbarona thiyena.” ");
INSERT INTO tgo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas i vonjimbughathɨ na gharewe, amba iŋa, “Ma bigi regha eŋge ne u vakatha. U wa na vo vakuneŋaŋgiya len bigibigina wolaghɨye na u giya manina weŋgiya mbinyembinyeŋgu. Amba ne u vwenyevwenye e buruburu, amba u njoghama na u ghambuŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mbaŋa amalako i loŋweya iyake, ghamwae i raraŋgɨlaŋgɨla weiye le nuwatharɨ, kaiwae le gogomwau i laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Amba Jisas i ghɨmara ghɨliŋaŋgiya gharaghambuko kaero i dage weŋgi iŋa, “I vuyowo moli weŋgiya gharɨgharɨ thɨ vwenyevwenye lenji ru Loi ele ghamba mbaro tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Gharaghambuko gharenji i yo utuutuko thiyako kaiwanji, ko iyemaeŋge Jisas mbowo i dageva weŋgi iŋa, “Lo ŋgaŋga, i vuyowo moli weŋgiya gharɨgharɨ lenji ru Loi ele ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","I vuyowo moli weya kamel na i komughathara e nyilɨ yathiye, ko i vuyowo laghɨye moli weya lolo ravwenyevwenye le ru Loi ele ghamba mbaro tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Amba gharaghambuko gharenji i yo laghɨye moli na thɨ vedage weŋgi thɨŋa, “Thela eŋge ne i vaidiya vamoru!” ");
INSERT INTO tgo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas marae i ghembeŋgi na i gonjogha iŋa, “Lolo ma valɨkaiwae ne i vamora ghamberegha; ko Loi valɨkaiwae i vakatha, kaiwae Loi valɨkaiwae i vakathaŋgiya bigibigike wolaghɨye.” ");
INSERT INTO tgo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Amba Pita i dagewe iŋa, “Wo u thuwe, wo iteteŋgiya bigibigike wolaghɨye na wo ghambuŋge.” ");
INSERT INTO tgo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisas i dage weŋgi iŋa, “Ŋgoreiye, na ya dage emunjoru e ghemi, thelolo i iteteŋa ghambae, oghaghae, olouye, tɨnae, ramae, le ŋgaŋga o le thelau idaŋgu kaiwae na Toto Thovuye kaiwae, ");
INSERT INTO tgo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ne i vaidiya laghɨye moli e mbaŋake thiyake. Ne i vaidiya le ŋgoloŋgolo, oghaghae, oloulouye, otɨnatɨnae, le ŋgaŋga na le thelau thɨ ghanagha na i laghɨye moli — na weiye bigibigike thiyake tembene gharɨgharɨ thɨ botewova na thɨ vakatha vatharɨwe, amba mbaŋa ne i menamenako i vaidiya yawalɨ memeghabananiye. ");
INSERT INTO tgo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ko thavala noroke thɨ laghɨye na thɨ viva ne thɨ muyai na thavala noroke thɨ nasiye na thɨ muyai ne thɨ viva.” ");
INSERT INTO tgo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Amba Jisas na gharaghambu inanji e kamwathɨ i voro Jerusalem; i viva gharaghambuko e ghamwanji. Gharenji i yo laghɨye; na gharɨgharɨko va thɨ raka reghambako thɨ mararu. E mbaŋako iyako i vaŋguŋgiya gharaghambuko theyaworo na theghewoko na i utu thuwele weŋgi budakai ne i yomarawe. ");
INSERT INTO tgo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I dage weŋgi iŋa, “Hu vandeŋe, ra rakavoro Jerusalem na gheko lolo regha ne i vatomwe Lolo Nariye weŋgiya ravowovowo laghɨlaghɨye na mbaro gharavavaghare, ne thɨ vakatha ghambaro le mare kaiwae, amba thɨ vaŋgugiya weŋgiya thiye ma Jiu gharɨgharɨniye, ");
INSERT INTO tgo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","na thɨ vatabweyaruŋa, thɨ njoŋgo vun, thɨ ŋge na thɨ tagavamare; ko mbaŋa theghetoniye e tɨne kaero i thuweiru na e yawayawaliyeva.” ");
INSERT INTO tgo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Amba Jemes na Jon, Sebedi le ŋgaŋga, thɨ mena weya Jisas na thɨ dagewe thɨŋa, “Ravavaghare, nuwameiya u vakatha bigi regha kaiwame.” ");
INSERT INTO tgo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisas i vaitoŋgi iŋa, “Nuwamiya ya vakatha budakai kaiwami?” ");
INSERT INTO tgo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Thɨ gonjoghawe thɨŋa, “Mbaŋa ne ghanɨmbaŋa u mbaro weŋgiya gharɨgharɨ, ne u vatomwe weime, thamaghewoke, na wo yaku weime ghen, regha e unena na regha e moina na wo mbaro weime ghen.” ");
INSERT INTO tgo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ko iyemaeŋge Jisas i dage weŋgi iŋa, “Ma hu ghareghare budakaiya hu naŋgona. Valɨkaiwamiya hu muna vɨrɨke ghakom iya ghino ne ya munɨkewe? Na valɨkaiwamiya ne hu bapɨtaiso ŋgora ne ghino ya bapɨtaisoke, e vɨrɨ laghɨye moli na mare?” ");
INSERT INTO tgo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Thɨ gonjoghawe thɨŋa, “Ŋgoreiye. Valɨkaiwame eŋge.” Iya kaiwae Jisas i dage weŋgi iŋa, “Emunjoru ne hu muna vɨrɨke ghakom ŋgoreiya ghino ya mun na hu bapɨtaiso e vɨrɨ laghɨye na mare ŋgoreiye ghino. ");
INSERT INTO tgo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ko iyemaeŋge ghino ma valɨkaiwae ya tuthiya thela ne i yaku e uneŋguke na thela i yaku e moiŋguke mbaŋa ne ya mbaro. Ghamba yakuŋgike thiyake Loi ne i wogiya weŋgiya thavala va i vivathanawe kaiwanji.” ");
INSERT INTO tgo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mbaŋa gharaghambuko theyaworo thɨ loŋweya iyake gharenji i gaithɨwanaŋgiya Jemes na Jon. ");
INSERT INTO tgo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Amba Jisas i kula vathaŋgiya gharaghambuko wolaghɨye na iŋa, “Hu ghareghare, thiye ma Jiu gharɨgharɨniye lenji rambarombaro thɨ mbaroŋaŋgi na lenji randeviva lenji vurɨgheghe i vikikiŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ko ghemi thava ŋgoramiya iyako. Thela thoŋgo nuwaiya iye lolo laghɨye e tɨnemina, iye wo i tabo na lemi rakakaiwo. ");
INSERT INTO tgo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na thela thoŋgo nuwaiya i ndeviva weŋga wo i tabo na lemi rakakaiwobwaga. ");
INSERT INTO tgo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mbe ŋgoreiyeva Lolo Nariye, mava i mena na mbala thɨ kaiwo kaiwae, ko i mena na i kaiwo gharɨgharɨ kaiwanji, i vatomweya yawaliye, i vamodonjoghaŋgi e lenji tharɨ tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas na gharaghambu kaero thɨ vutha Jeriko na mbaŋa vama thɨ warewareri vara weinjiyaŋgiya wabwi laghɨye, kaero amala maramarae thɨ kwaghe na vata le naŋgo, idae Batimiyos, Timiyos nariye, vambe i yaku e kamwathɨko ghadidiye. ");
INSERT INTO tgo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mbaŋa i loŋweya Jisas rara Nasaret iya i reŋa e ghadidiye, ko amba i kula iŋa, “Jisas! Deivid rumbuye! Gharen i njaoweŋgo!” ");
INSERT INTO tgo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gharɨgharɨ lemoyo thɨ marakawana na thɨ dagewe i towo. Ko iyemaeŋge i kula na ghalɨŋae ma laghɨye eŋge iŋa, “Deivid rumbuye, gharen i njaoweŋgo!” ");
INSERT INTO tgo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas i ndeghathɨ kaero iŋa, “Hu kulamawe na i mena.” Kaero gharɨgharɨko thɨ kula weya amalako maramarako thɨ kwaghe thɨŋa, “Nuwan i loghe! U yondo virɨ! I kula e ghen.” ");
INSERT INTO tgo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","I liyathu ghakwama ghayaboyabo, i yondopito na i mena weya Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Amba Jisas i vaito iŋa, “Nuwaniya ya vakatha budakai kaiwan?” I gonjoghawe iŋa, “Ravavaghare, nuwaŋguiya maramaraŋguke thɨ thovuye na ma ya thuweva.” ");
INSERT INTO tgo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas i dagewe iŋa, “U wa, maramaranɨna kaero thɨ thovuye kaiwae u loŋweghathɨ.” E mbaŋako iyako, Batimiyos kaero i thuweva na i rereghamba weya Jisas e kamwathɨko. ");
INSERT INTO tgo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mbaŋa vama thɨ vurɨthaiya Jerusalem, Betepage na Betani ghadidinji, Olivɨ e ghanji Ou, Jisas i variyeŋgiya gharaghambu theghewo e ghamwanji, ");
INSERT INTO tgo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na i dage weŋgi iŋa, “Hu wa e ghembana e ghamwamina. Mbaŋaniye vara vohu ru gheko, ne hu vaidiya doŋɨki nariye thɨ ŋgarɨrawe na ma mbaŋa regha lolo i thawe. Hu raka na hu vaŋgumena gheke. ");
INSERT INTO tgo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Thoŋgo lolo regha i vaitoŋga na iŋa, ‘Buda kaiwae hu vakathake?’ hu dagewe huŋa, ‘Giya nuwaiya na tene i variye njoghamava gheke mbaŋa ubotu.’” ");
INSERT INTO tgo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kaero thɨ wa na vethɨ vaidiya doŋkima nariye e kamwathɨ ghadidiye, thɨ ŋgarɨ e ŋgolo ghathɨnɨmba. Thɨ rakaraka ghathiyoko, ");
INSERT INTO tgo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","na gharɨgharɨ vavana inanji gheko thɨ vaitoŋgi thɨŋa, “Hu vakatha budakai hu raka doŋkina nariye?” ");
INSERT INTO tgo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Thɨ gonjogha weŋgi ŋgoreiya ŋgoroŋga Jisas me utugiyama weŋgi, na gharɨgharɨko thɨ viyathuŋgi na thɨ wa. ");
INSERT INTO tgo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Thɨ vaŋgumena doŋkiko weya Jisas, thɨ bigiyathu ghanjikwama ghayaboyabo e thetheghanɨko vwatae na Jisas i thawe. ");
INSERT INTO tgo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gharɨgharɨ lemoyo thɨ bigiraweŋgiya ghanjikwama ghayaboyabo e kamwathɨko marae na vavana thɨ bigiraweya umbwaumbwa yaŋgayaŋga e ndamwandamwanji methɨ tenɨŋgi e umauma tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Gharɨgharɨ vavana thɨ raka viva na vavana thɨ raka reghamba thɨ yaro na thɨŋa, “Hosana! Loi ghare weya amalaghɨniye iya i mena Giya e idaeke. ");
INSERT INTO tgo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Loi ghare weya Deivid rumbuye iya i menake na i mbaro weinda! Hosana Ramevoro Moliwe.” ");
INSERT INTO tgo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mbaŋa vama i vutha Jerusalem, i wa ve ru e Ŋgolo Boboma na i thuweŋgiya bigibigiko wolaghɨye. Ko iyemaeŋge vama yeghɨyeghɨye moli weiyaŋgiya gharaghambuko theyaworo na theghewo thɨ raka Betani. ");
INSERT INTO tgo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Va i ghɨviya, thɨ ri Betani na thɨ njogha Jerusalem, bada i ghara Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I thuwe umbwa regha idae fig. Vamba ina bwagabwaga na i thuwe ndamwandamwaeko i poku moli. I wa na ve kelaŋa thoŋgo e uneune. Mbaŋa i mena e rɨghe na i thuwe mbe ndamwandamwa eŋge, kaiwae ma vamba ghambaŋa rau. ");
INSERT INTO tgo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisas i dage weya umbwako iŋa, “Ma tene lolo regha i ghanɨva unen mbaŋa regha!” Gharaghambuko va thɨ loŋweya iya utuutuko iyako. ");
INSERT INTO tgo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mbaŋa thɨ vutha Jerusalem, Jisas ve ru e Ŋgolo Boboma ghayayao tɨne na i vagege raŋgiyaŋgiya thavala thɨ vavamodo na thɨ vavakune e Ŋgolo Boboma tɨne. I mwana vevewoŋgiya yao gharaten lenji tebol na bunebune gharakune lenji ghamba yaku. ");
INSERT INTO tgo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","I dageten weŋgiya gharɨgharɨ na thava te thɨ bigighatharava bigi regha kune kaiwae e Ŋgolo Boboma ghayayaoko tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Amba Jisas i vavaghare weŋgiya gharɨgharɨ iŋa, “Va thɨ rori Buk Boboma e tɨne, Loi iŋa, ‘Lo ŋgolo ne thɨ uno idae ŋgolo ghamba naŋgo, gharɨgharɨ e vanautumake wolaghɨye kaiwanji.’ Ko ghemi hu vakatha ŋgoreiye rakaivɨ lenji ghamba kubaro!” ");
INSERT INTO tgo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mbaŋa ravowovowo laghɨlaghɨye na mbaro gharavavaghare thɨ loŋweya iyake, thɨ tamweya kamwathɨ ne ŋgoroŋga na thɨ unɨgha Jisas. Ko kaiwae le vavaghareko va i wo wabwiko nuwanji i vakatha ravowovowo laghɨlaghɨye na mbaro gharavavaghare thɨ mararu Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Vama yeghɨyeghɨye, Jisas na gharaghambu thɨ iteta Jerusalem. ");
INSERT INTO tgo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mbaŋambaŋa vena thɨ loŋgaloŋga e kamwathɨko Jerusalem kaiwae amba thɨ thuweya figɨko i mare, i ri e ndamwae na ve nja e wathewatheliliye. ");
INSERT INTO tgo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita i renuwaŋakikiya menda Jisas le utuutuma kaero i dagewe iŋa, “Ravavaghare, wo u thuwe, umbwako menda u gurako kaero i mareyawowo!” ");
INSERT INTO tgo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisas i gonjogha weŋgi iŋa, “Hu loŋweghathɨgha Loi. ");
INSERT INTO tgo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ya dage emunjoru e ghemi, thela ne i dage weya ouke iyake na i wa ve dobu e njighɨko tɨne na ma i numoghegheiwo e ghare, ko iyemaeŋge i loŋweghathɨgha ŋgoroŋga meŋa ne i yomara, ne ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iya kaiwae ya dage e ghemi: Mbaŋa ne hu naŋgo weya Loi na hu naŋgowe bigi regha kaiwae, hu loŋweghathɨ emunjoru ne hu vaidi. Thoŋgo hu vakatha ŋgoreiye, Loi ne i wogiya weŋga. ");
INSERT INTO tgo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ko iyemaeŋge mbaŋa hu naŋgo, hu numoyathu lolo regha le tharɨ e ghemi, ambane Ramami e buruburu i numotena lemi tharɨ. ");
INSERT INTO tgo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ko iyemaeŋge thoŋgo ma hu numoyathuŋgiya gharɨgharɨ vavana lenji tharɨ, mane Ramami e buruburu i numotena lemi tharɨŋgina.” ");
INSERT INTO tgo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisas na gharaghambu vambowo vethɨ vuthava Jerusalem. Mbaŋa i loŋgaloŋga e Ŋgolo Bobomako ghayayao tɨne, ravowovowo laghɨlaghɨye, mbaro gharavavaghare na giyagiya vavanava thɨ rakamenawe, ");
INSERT INTO tgo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na thɨ vaito thɨŋa, “U vata thela ele mbaro vwatae iya u vakathaŋgiya bigibigike thiyake? Thela i dage e ghen na u vakathaŋgi?” ");
INSERT INTO tgo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas i gonjogha weŋgi iŋa, “Wo ya vaitoŋga vaito regha na thoŋgo hu wogiya ghathombe e ghino, amba ya utuŋa weŋga ya vata thela e vwatae na ya vakathaŋgiya bigibigike thiyake. ");
INSERT INTO tgo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon le rɨghe i bapɨtaiso, i mena weya Loi o i mena weŋgiya gharɨgharɨ?” ");
INSERT INTO tgo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mbe thiye eŋge thɨ veutu weŋgi thɨŋa, “Thoŋgo raŋa, ‘I mena weya Loi’, ne iŋa, ‘Buda kaiwae mava hu loŋweghathɨgha Jon?’ ");
INSERT INTO tgo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ko thoŋgo raŋa, ‘I mena weŋgiya gharɨgharɨ—’” (Va thɨ mararuŋgiya gharɨgharɨ, kaiwae gharɨgharɨko wolaghɨye thɨ loŋweghathɨ emunjoru Jon iye Loi ghalɨŋae gharautu.) ");
INSERT INTO tgo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iya kaiwae thɨ gonjogha weya Jisas thɨŋa, “Ma wo ghareghare.” Iya kaiwae Jisas i dage weŋgi iŋa, “Ghino tembe ŋgoreiyeva, ma ne ya utuveŋga, ya vata thela e vwatae na ya vakathaŋgiya bigibigike thiyake.” ");
INSERT INTO tgo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Amba Jisas i utu weŋgi e goghaimba iŋa, “Lolo regha va i kabu waen ghauma, i gana vaghɨliya, i vakatha doda waen ghamba i imbɨimbɨ, na i vatada ŋgolo regha, umako gharanjimbunjimbu lenji ghamba yaku. I vakatha ŋgoreiyako, amba i vatomwe weŋgiya gharɨgharɨ vavana na thɨ vakaiwoŋa amalaghɨniye kaiwae. Amba amalaghɨniye i wa ve ghɨnagha e vanautuma regha. ");
INSERT INTO tgo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mbaŋa kaero ghambaŋa thɨ vu, umako tanuwagae i variya le rakakaiwo regha weŋgiya gharanjimbunjimbuko na ve bigiya uneune vavana weŋgi amalaghɨniye kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ranjimbunjimbuko thɨ yalaweya rakakaiwoko, thɨ tagavotagamenawe na thɨ variye njogha nɨmanɨma. ");
INSERT INTO tgo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mbowo i variyeva le rakakaiwo regha, ranjimbunjimbuko thɨ ŋge e umbaliye na thɨ vakatha ghamba monjina moliwe. ");
INSERT INTO tgo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Umako tanuwagae mbowo i variyeva le rakakaiwo regha ko iyemaeŋge thɨ tagavamare. Va thɨ vakatha weŋgiya vavana tembe ŋgorava iyako, vavana thɨ ŋgeŋgeŋaŋgi na vavana thɨ tagavavamareŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Vama reghaeŋge vara moli mbe inawe, nariye na valɨghareghare moli. Muyai moli amba i variye weŋgiya umako gharanjimbunjimbu na iŋa, ‘Ya ghareghare ne thɨ yavwatatawana naruŋguke.’” ");
INSERT INTO tgo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ko iyemaeŋge umako gharanjimbunjimbu thɨ vedage weŋgi thɨŋa, ‘Umake tanuwagae nariye maiya i menake. Iye ne i rombaroŋa umake ramae e ghereiye. Hu rakamena ra tagavamare na mbalama ra mbaroŋava iya le umake!’ ");
INSERT INTO tgo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Amba thɨ yalawe na thɨ tagavamare, na thɨ wokiyathuraŋgiya e gana ghereiye.” ");
INSERT INTO tgo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisas i govaito iŋa, “Umako tanuwagae ne i vakatha budakai? Ne i mena i gaboŋgi na ma i vatomweva umako weŋgiya gharɨgharɨ vavana. ");
INSERT INTO tgo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Vambe hu vaona Buk Boboma le utu Mesaiya kaiwae, iya iŋake, ‘Varɨke iya ŋgoloke gharavatavatad thɨ botewo, kaero i tabo na ghambaghɨmbaghɨ. ");
INSERT INTO tgo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iyake Giya nɨmae muiye na ghayamoyamo i thovuye moli e maranda.’” Jisas i utu ŋgoreiyake na utuke thiyake i vatomwe thavala thɨ botewo Loi nariye. ");
INSERT INTO tgo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Amba Jiu lenji randeviva nuwanjiya thɨ yalawe kaiwae va thɨ ghareghare goghaimbako iyako thiye ghanjigoghaimba. Ko iyemaeŋge thɨ mararuŋgiya wabwiko laghɨye, iya kaiwae thɨ roitete na thɨ rakawa. ");
INSERT INTO tgo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Amba thɨ variyeŋgiya Parisi vavana na Herod le wabwi gharɨgharɨniye vavana weya Jisas thɨ munje thɨ vaito na thɨ vakatha ghawonjowe ele utuutuko. ");
INSERT INTO tgo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mbaŋa thɨ menawe kaero thɨ dagewe thɨŋa, “Ravavaghare, wo ghareghare u utuŋa emunjoru na ma u goru weya ŋgoroŋga gharɨgharɨ lenji renuwaŋa. Ma u goruwe ŋgoroŋga lolo le thimba o le laghɨlaghɨye, ko emunjoru u vavaghareŋa Loi le renuwaŋa gharɨgharɨ kaiwanji. U utugiya weime, ŋgoroŋga, la mbaro i vatomwe weime na wo vamodo takis weya Sisa, o nandere? ");
INSERT INTO tgo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wo vamodo o thava wo vamodo?” Ko Jisas kaero i thuwe lenji kwanɨko na i gonjogha weŋgi iŋa, “Buda kaiwae hu munje hu mandoŋgo? Wo hu woma manina gethɨra na ya thuwe.” ");
INSERT INTO tgo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Thɨ womena gethɨrawe na i vatomwe weŋgi, i vaitoŋgi iŋa, “Thela ŋgaliŋgaliya na idayake?” Thɨ gonjoghawe thɨŋa, “Sisa.” ");
INSERT INTO tgo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Amba Jisas i dage weŋgi iŋa, “Sisa le bigibigi hu wogiya weya Sisa na Loi le bigibigi hu wogiya weya Loi.” Na Jisas le utuko i wo nuwanji. ");
INSERT INTO tgo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Amba Sadusi, thiye ma thɨ loŋweghathɨ ramaremare tembene thɨ thuweiruva, vavana thɨ rakawa weya Jisas na thɨ vaito thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ravavaghare, Mosese va i roriya mbaroke iyake kaiwanda, iya iŋake, ‘Thoŋgo amala i mare iteta levo ko ma i ghambɨ weiye, ghaghae ma i rovaŋguva ghɨmbwiyeko. Thoŋgo i ghambɨ weiye, gamagaiko thiyako ghaghaeko va i mareko le ŋgaŋga.’ ");
INSERT INTO tgo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mbaŋa regha amala regha na oghaghae; va theghepirɨ vara, tɨnanji na ramanji regha. Laghɨyeninji va i ghe na amba ma thɨ ghambɨ weiye kaero i mare itetava levo. ");
INSERT INTO tgo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ghaghae theghewoniye i rovaŋgu na tembe ma i ghambɨva weiye kaero i mare. Theghetoninji vambe ŋgoreiyeva, kamwathɨko iyako te vambe i yomaraweva. ");
INSERT INTO tgo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Vambe ŋgoreiye varako taulaghɨko weŋgi. Theghepirɨko va thɨ vaŋgwa elako na thiya marevao ma thɨ ghambɨ weinji. Va ele ghambako elaghɨniye i mare. ");
INSERT INTO tgo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ko mbaŋa ne ramaremare thɨ thuweiru na e yawayawalinjiva, thela ne i ghe weiye, kaiwae vambe theghepirɨko vara thɨ vaŋgu?” ");
INSERT INTO tgo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas i gonjogha weŋgi iŋa, “Kaero hu vurɨthavwiya kamwathɨ, kaiwae ma hu ghareghare Buk Boboma le woraŋgiya ŋgoroŋga gharumwaru na budakaiya Loi valɨkaiwae i vakatha. ");
INSERT INTO tgo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kaiwae mbaŋa ramaremare ne thɨ thuweiru na tembe e yawayawalinjiva, ma tembene thɨ gheva, thiye ne ŋgoranjiya nyao thovuthovuye e buruburu. ");
INSERT INTO tgo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iya ramaremare tembene thɨ thuweiruva kaiwanji: mbe hu ndevaona mun Mosese le rorori, utuutuma iyava ndɨghema i ra e umbwaumbwama ndamwandamwa utuniye? Eibraham, Aisake, na Jeikob vama thɨ mare na mbaŋa molao e ghereiye amba Loi i dage weya Mosese, iŋa ‘Ghino Eibraham le Loi, Aisake le Loi, na Jeikob le Loi.’ ");
INSERT INTO tgo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Iye ma ramaremare lenji Loi, nandere. Iye gharɨgharɨ e yawayawalinji lenji Loi. Ghemi hu kwan, hu vurɨthavwi moli.” ");
INSERT INTO tgo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mbaro gharavavaghare reghava ina gheko, i vandeŋe e lenji utuko. I thuweya Jisas le thombe weŋgiya Sadusiko i thovuye, i mena i vaito iŋa, “The mbaro i laghɨye vara moli?” ");
INSERT INTO tgo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas i gonjoghawe iŋa, “Mbaro laghɨye moli iyake: ‘Hu vandeŋe, ghemi wabwi Isirel! Giya la Loi, ghamberegha moli iye Giya. ");
INSERT INTO tgo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Hu gharethovu Giya lemi Loi, e gharemina laghɨye, e unemina laghɨye, e lemi renuwaŋana laghɨye, na e lemi vurɨgheghena laghɨye.’ ");
INSERT INTO tgo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mbaro laghɨye moli theghewoniye iyake: U gharethovu weya ghanu ŋgoreiya u gharethovu e ghen. Ma te mbaro reghava i laghɨye kivwala iya theghewoke thiyake.” ");
INSERT INTO tgo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mbaroko gharavavaghare i dage weya Jisas iŋa, “I thovuye moli, Ravavaghare! Emunjoru ŋgoreiya moŋana Giya iye Loi mbe ghamberegha eŋge na ma te Loi reghava, ghamberegha moli. ");
INSERT INTO tgo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na ra gharethovu Loi e gharendake laghɨye na e la renuwaŋake laghɨye na e la vurɨghegheke laghɨye. Thiyake thɨ laghɨye kivwala ra wogiya thetheghan mbwanambwana moli e ghamba vowo na vowo vavanava weva Loi.” ");
INSERT INTO tgo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas i thuweya le thombeko thɨ thovuye moli na i dagewe iŋa, “Ma inan bwagabwaga Loi ele ghamba mbaro tɨne.” Iyake e ghereiye taulaghɨko ma te thɨ vaitova Jisas kaiwae thɨ ghareghare ma valɨkaiwae thɨ kwanɨyaro. ");
INSERT INTO tgo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mbaŋa Jisas i vavaghare e Ŋgolo Boboma ghayayao tɨne amba i vaitoŋgiya gharɨgharɨ iŋa, “Ŋgoroŋga na iya mbaroko gharavavaghare thɨŋa Mesaiya iye Deivid rumbuye? ");
INSERT INTO tgo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mbaŋa me vivako Nyao Boboma i vakatha Deivid iyava iŋake, ‘Giya Loi i dage weya wo Giya iŋa: “U yaku valɨvaŋga e uneŋguke ghaghad ya biginjoŋaŋgiya ghanɨthɨghɨya e gheghen raberabe.” ’” ");
INSERT INTO tgo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Deivid ghamberegha i una Mesaiya ‘Giya’. Ŋgoroŋga eŋge na iye Deivid rumbuye?” Na wabwiko laghɨye thɨ vandeŋe weinji lenji warari. ");
INSERT INTO tgo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na Jisas ele vavaghare tɨne iŋa, “Hu njimbukikiŋga weŋgiya mbaro gharavavaghare. Thiye nuwanjiya thɨ njimbo ghanjikwama molamolao na thɨ ndeloŋga na thoŋgo thɨ lavolevoleŋgiya gharɨgharɨ nuwanjiya weiye lenji yavwatata thɨ dage mwaewo weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jiu e lenji ŋgolo kururu tɨne, thiye nuwanjiya thɨ roviva gharɨgharɨ e ghamwanji, na thaga e tɨne nuwanjiya vethɨ yaku ŋgora gharɨgharɨ laghɨlaghɨye lenji ghamba yaku. ");
INSERT INTO tgo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Thɨ yabo wambwiwambwi maranji na thɨ mbaroŋaŋgiya lenji ŋgoloŋgolo na lenji bigibigi, na kaiwae nuwanjiya thɨ yabo lenji vakathaŋgiko thɨ vakatha naŋgo molamolao gharɨgharɨ e maranji. Ko iyemaeŋge lenji vakathako kaiwae ne thɨ vaidiya vuyowo laghɨye moli.” E utuutuke thiyake Jisas i vanuwovɨrɨŋgi mbaro gharavavaghare kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E Ŋgolo Boboma tɨne Jisas i yaku e mani ghamba bigirawe ghadidiye na i njimbukikiya gharɨgharɨ thɨ bigibigirawa mani. Gharɨgharɨ lenji bigibigi i ghanagha thɨ bigiraweya mani i ghanagha. ");
INSERT INTO tgo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Amba wambwi eunda, mbinyembinyeŋgu, i mena na i bigiraweya toeya gethiwo rere. ");
INSERT INTO tgo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","I kula vathaŋgiya gharaghambu na i dage weŋgi iŋa, “Ya dage emunjoru e ghemi, wambwiko iya mbinyembinyeŋguko me bigiraweko i laghɨye kivwala vara iya taulaghɨko methɨ bigirawe. ");
INSERT INTO tgo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kaiwae vavana methɨ bigiraweya mani vavana na laghɨyeniye mbe inawe, ko elaghɨniye, kaiwae iye mbinyembinyeŋgu, le manima wolaghɨye ghae modae maiyavara me bigirawe vunuko.” ");
INSERT INTO tgo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mbaŋa Jisas i raŋgima e Ŋgolo Bobomako ghayayao tɨne gharaghambu regha i dagewe iŋa, “Ravavaghare, wo u thuweŋgiya ŋgoloŋgoloke laghɨlaghɨye na varɨvarɨke laghɨlaghɨye va thɨ vatadakowe! Mbema ghanjiyamoyamo i thovuye vara moli.” ");
INSERT INTO tgo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisas i gonjoghawe iŋa, “Iya u thuweŋgiya ŋgoloŋgoloko laghɨlaghɨye thiyako, mavole varɨ regha i ndeghathɨ ele ghamba ndeghathɨ. Wolaghɨyeko nevole thɨ bigiyathuvao na iko.” ");
INSERT INTO tgo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mbaŋa Jisas ve yaku Olivɨ e ghanji Ou, e Ŋgolo Boboma na valɨmbwa amba Pita, Jemes, Jon na Endru, mbe thiye eŋge, thɨ vaito thuwele thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“U utugiya weime, thembaŋa vara na bigibigiko mo utuŋaŋgiko ne thɨ yomara? Na ghanjinono ne ŋgoroŋga i ghaŋgo?” ");
INSERT INTO tgo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisas i dage weŋgi iŋa, “Hu njimbukiki wagiyaweŋga, tha lolo regha i yaroŋga. ");
INSERT INTO tgo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kaiwae gharɨgharɨ i ghanagha ne thɨ mena e idaŋgu na thɨŋa, ‘Ghino Mesaiya!’ na ne thɨ yaroŋgiya gharɨgharɨ lemoyo. ");
INSERT INTO tgo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nono reghava iyake. Ne hu loŋweŋgiya vanautuma lenji gaithɨ utuniye na toto gaithɨ kaiwae, ko hu ndemararu. Bigibigike ŋgoranjiyake ne thɨ yomara, ko iyemaeŋge mbaŋa le ghambako amba mane i mena. ");
INSERT INTO tgo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vanautuma ne thɨ vegaithɨ weŋgi; rambarombaro ne thɨ vegaithɨ weŋgi. Nevole vunuvu na ragheragheghe lemoyo e yambaneke laghɨye. Vuyowoke thiyake ne thɨ yomara ŋgoreiya ŋgama i vwara ghatambwa na vɨrɨniye.” ");
INSERT INTO tgo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ghemi tembe ghamimberegha hu njimbukiki. Ne thɨ yalaweŋga na thɨ vaŋguŋga na vohu kot. Ne vethɨ gaboŋga e lenji ŋgolo kururu tɨne; ne thɨ vakatha na hu ndeghathɨ rambarombaro na kiŋ e ghamwanji idaŋgu kaiwae na hu utuŋa weŋgiya Toto Thovuye. ");
INSERT INTO tgo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ko amba muyai yambaneke le ghambako wone lo gharɨgharɨ thɨ utuŋa Toto Thovuye e yambaneke laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na mbaŋa ne thɨ yalaweŋga na thɨ yovaŋguŋga kot kaiwae, gharemi ne i ndegaithɨ lemi utu kaiwae amba muyai kot ghambaŋa. Mbaŋa ne ghamimbaŋa utu, hu utuŋaŋgiya thedage iya ne i yomara e nuwamina. Kaiwae dageŋgina ne hu utuŋaŋgina ma ghanɨmbereghana ghalɨŋami; ne thɨ mena weya Nyao Boboma. ");
INSERT INTO tgo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Amaamala vavana ne thɨ vatomweŋgiya oghaghanji na thɨ gaboŋgi, na gamagai oramanjiŋgi ne thɨ vakatha weŋgiya lenji ŋgaŋga ŋgoreiye. Gamagai vavana ne thɨ ndeghereiye wanaŋgiya otatanji na oramanji na thɨ vakathaŋgi na thɨ gaboŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ghino kaiwaŋgu taulaghɨ ne thɨ botewoyathuŋga. Ko the lolo i ghataŋaghathɨ ghaghada ne le ghambako Loi i vamora yawaliye.” ");
INSERT INTO tgo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mbaŋa ne hu thuweya bigiko i vambɨghɨya Ŋgolo Boboma na i vakatha gharɨgharɨ thɨ roitetako, na i ndeghathɨ ŋgoreiye ma valɨkaiwae i ndeghathɨwe.” (Ghemi buk iyake gharavavaona wo hu rerenuwaŋa ghaghadɨ nuwamina i rumwaruŋa utuke iyake!) “Mbaŋaniye thavala inanji Judiya thɨ vo weya e ououko rɨghenji. ");
INSERT INTO tgo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Thoŋgo lolo regha ina ele ŋgolo vwatae ne i nderu ele ŋgolo tɨne, i wo le bigi regha na i yowo weiye. ");
INSERT INTO tgo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Lolo regha ina e uma tɨne ne i ndenjogha ele ŋgolo na i liya ghakwama ghayaboyabo. ");
INSERT INTO tgo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ne e mbaŋaŋgiko thiyako ne i vuyowo laghɨye moli weŋgiya wanakau thiya marabo na wanakau weinjiyaŋgiya gamagai amba thɨ thuthu. ");
INSERT INTO tgo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hu naŋgo weya Loi na bigibigike thiyake ne thɨ ndeyomara mbaŋa njighɨnjighɨ ghambaŋa. ");
INSERT INTO tgo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vuyowo ne e mbaŋako iyako ne i laghɨye, i laghɨye moli. Na vuyowoko ŋgoranjiyako ma mbaŋa regha i yomara e yambaneke va i rikowe gheghada noroke, na ma tene ŋgoreiyeva mbaŋa muyai. ");
INSERT INTO tgo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Thoŋgo ma Loi i wonjaniya mbaŋa le molamolao, mbala ma lolo regha i moru. Ko le tututhi gharɨgharɨniye kaiwae, Loi kaero i wonjoŋa vuyowo ghambaŋa le molamolao.” ");
INSERT INTO tgo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Thoŋgo lolo regha i dage e ghen, ‘Wo u thuwe, Mesaiya maiya!’ o ‘Wo u thuwe, maiyako!’, ne u ndeloŋweghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kaiwae Mesaiya kwanɨkwan na Loi ghalɨŋae gharautu kwanɨkwan ne thɨ rakaraŋgi. Ne thɨ vakathaŋgiya vakatha ghamba rotaele, na thɨ wo gharɨgharɨ nuwanji na thɨ munje tembe thɨ wova Loi le tututhi gharɨgharɨniye nuwanji. ");
INSERT INTO tgo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hu njimbukikiŋga! Kaero ma utuveŋga bigibigike wolaghɨye amba muyai thɨ yomara.” ");
INSERT INTO tgo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ko iyemaeŋge ne e mbaŋako thiyako, vuyowoko e ghereiye varae mara ne i momouwo, manjala mane i mbɨle, ");
INSERT INTO tgo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ghɨtara ne thɨ dobu na buruburu matemate ne thɨ nyivɨvao. ");
INSERT INTO tgo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Amba Lolo Nariye i yomara na thɨ thuwe. Ne i njama e ŋgalɨlɨko weiye vurɨgheghe laghɨye na vwenyevwenye. ");
INSERT INTO tgo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ne i variyeŋgiya le nyao thovuthovuye e yambaneke ghadidiye gethɨvarɨ na thɨ vaŋguvathavathaŋgiya le tututhi gharɨgharɨniye e yambaneke mbothiye regha gheghada valɨmbothiye.” ");
INSERT INTO tgo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Umbwa fig i woveŋga goghaimba thovuye. Mbaŋa yaŋgayaŋga amba ma thɨ vurɨgheghe na ndamwandamwa togha thɨ thalavwara u ghareghareya thuwai ghambaŋa kaero ma bwagabwaga. ");
INSERT INTO tgo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tembe ŋgoreiyeva, mbaŋa ne hu thuweŋgiya bigibigike thiyake thɨ yoyomara ne hu ghareghare le njoghama ghambaŋa kaero ma bwagabwaga, maiyavara. ");
INSERT INTO tgo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya dage emunjoru e ghemi, thake iyake mamba ne thiya marevao ghaghad bigibigike wolaghɨye thiyake thɨ yomara. ");
INSERT INTO tgo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Buruburu na yambane ne thɨko, ko ghalɨŋaŋguke mane iko.” ");
INSERT INTO tgo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ko iyemaeŋge ma lolo regha i ghareghare thembaŋa o the lughawoghawo vara Lolo Nariye ne i menawe. Buruburu nyaoniye thovuthovuye ma thɨ ghareghare na mbe ŋgoreiyeva Loi Nariye; ko mbe Ramae ghamberegha eŋge i ghareghare ne thembaŋa. ");
INSERT INTO tgo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hu njimbukikiŋga na hu njaŋanjaŋa, kaiwae ma hu ghareghare thembaŋa ne i menawe. ");
INSERT INTO tgo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ne ŋgoreiya lolo regha i iteta le ŋgolo na i wa ve ghɨnagha. I bigiraweŋgiya le rakakaiwo na thɨ njimbukiki. Regha na regha mbe ghakaiwo amba i dage weya thɨnɨmba gharanjimbunjimbu na i njaŋanjaŋa le njoghama kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iya kaiwae hu njaŋanja, kaiwae ma hu ghareghare thembaŋa ŋgolo tanuwaga, ne i vutha — ne yeghɨyeghɨyenja, o gougou mborowa, o kamkam i dagedage, o varae i maremuyaghɨ. ");
INSERT INTO tgo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Thoŋgo i vutha vararaŋga, ne i ndevaidiŋga hu ghenelaŋa. ");
INSERT INTO tgo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Budakaiya ya utuveŋga tembe ŋgoreiyeva ya utuveŋgiya gharɨgharɨke wolaghɨye: Hu njaŋanjaŋa!” ");
INSERT INTO tgo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Vama mbaŋa theghewo eŋge kaero Thaga Valaŋani na Bred ma weiye isɨt ghanjithaga. Ravowovowo laghɨlaghɨye na mbaro gharavavaghare thɨ vona Jisas ghae na nuwanjiya thɨ yalawe thuwele na thɨ unɨghɨ. ");
INSERT INTO tgo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Thɨŋa, “Ma valɨkaiwae ra vakatha e thagake tɨne ne iwaeŋge gharɨgharɨ gharenji i muru na thɨ gaithɨ.” ");
INSERT INTO tgo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas ina Betani Saimon ele ŋgolo. Amalake iyake va i ghataŋa lepelo. Mbaŋa Jisas i ghanɨŋga weiyaŋgi wevo eunda i menawe, i thɨna bodɨla alabasita vwarara bunama inawe. Bunamake iyake idae nad na modae laghɨye moli. I mwanabeba bodɨlako numwe kaero i liŋgiya bunamako Jisas e umbaliye. ");
INSERT INTO tgo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ko iyemaeŋge gharɨgharɨ va inanji gheko, vavana weinji lenji ghatemuru thɨ vedage weŋgi thɨŋa, “Ŋgoroŋga ghathovuye bunama modae laghɨye i kaiwo ŋgorako? ");
INSERT INTO tgo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bunamake mbalava i vakuneŋa na valɨkaiwae modae i lareŋawe theghathegha umbwara modae na i giya weŋgiya mbinyembinyeŋgu.” Mbema thɨ vethowana vara laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ko iyemaeŋge Jisas i dage weŋgi iŋa, “Hu viyathu! Tembe ghamberegha! Buda kaiwae hu liya ghautu? Me vakatha bigi thovuye e ghino. ");
INSERT INTO tgo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kaiwae mbaŋake wolaghɨye ne weimiyaŋgiya mbinyembinyeŋgu, na thembaŋa nuwamina nuwaiya valɨkaiwae hu thalavuŋgi. Ko iyemaeŋge mane weiŋguyaŋgiya ghemi gheke mbaŋake wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kaiwae me vakatha budakaiya me valɨkaiwae, kaero me varuvuŋgo amba muyai ne mbaŋa i mena beku kaiwae. ");
INSERT INTO tgo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya dage emunjoru e ghemi, aŋgavole thɨ vavaghareŋa Toto Thovuye e yambaneke laghɨye, budakaiya wevoke iyake me vakatha gharɨgharɨ ne thɨ utuŋa na thɨ renuwaŋakikiya elaghɨniye.” ");
INSERT INTO tgo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Amba Judas Isakariyot, gharaghambuko theyaworo na theghewoko regha, i wa weŋgiya ravowovowo laghɨlaghɨye kaiwae nuwaiya i vatomweya Jisas weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na mbaŋa thɨ loŋweya iyako nuwanji i loghe na thɨ dagerawa modae. Amba i tamweya kamwathɨ thovuye na i vatomwe weŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mbaŋa iviva moli Bred ma weiye isɨt ghathaga ghambaŋa, mbaŋaniye thɨ gaboŋgiya sip nariye Thaga Valaŋani ghanɨŋganiye kaiwae, gharaghambu thɨ dagewe thɨŋa, “Nuwaniya aŋga wo wa na vo vivatha Thaga Valaŋani ghanɨŋganiye kaiwan?” ");
INSERT INTO tgo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jisas i variyeŋgiya gharaghambu theghewo iŋa, “Hu wa vohu ru e ghembana tɨne, na amala i thɨna mbwa e mbwa variye ne i lavolevoleŋga. Hu mbele, ");
INSERT INTO tgo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","na the ŋgolo ve ruwe, hu dage weya ŋgolona tanuwagae huŋa, ‘Ravavaghare i vaito: Iyaŋganiya woluwolu bobwari kaiwaŋgu na ne ya ghana Thaga Valaŋani ghanɨŋganiye weiŋguyaŋgiya woraghambuke?’ ");
INSERT INTO tgo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na ne i vatomwe weŋga woluwolu laghɨye ina yavoro na ghanɨŋga bigibiginiye kaero inanjiwe; ghena hu vakatharawa ghanɨŋganawe.” ");
INSERT INTO tgo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Gharaghambuko thɨ wa na vethɨ ru e ghembako tɨne, na vethɨ vaidi ŋgoreiya me dagema weŋgi; na thɨ vivatharaweya Thaga Valaŋani ghanɨŋganiyewe. ");
INSERT INTO tgo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Vama gougou e mbaŋako iyako Jisas i mena weiyaŋgiya gharaghambuko theyaworo na theghewo. ");
INSERT INTO tgo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ghanɨŋga e tɨne Jisas iŋa, “Ya dage emunjoru e ghemi, regha ghemi iya ya ghanɨŋgake weiŋguyaŋgiya ghemi, ne i vatomweŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Gharenji i vɨrɨ laghɨye na thɨ dagewe, regha na regha iya i vaito iŋa, “Amalana, ma ghino ŋgoreiye, ae?” ");
INSERT INTO tgo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisas i dage weŋgi iŋa, “Ghemina iya themiyaworo na themighewona regha, iya i wouta ghabredɨna weiŋgu e gaeba regha. ");
INSERT INTO tgo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Lolo Nariye ne i mare ŋgoreiya Buk Boboma le woraŋgiya, ko iyemaeŋge loloko iya ne i vatomweya Lolo Nariye ne i vaidiya vuyowae. I thovuye moliwa loloko iyako thoŋgo tɨnae ma va i ghambɨ eŋge.” ");
INSERT INTO tgo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mbaŋa thiya ghanɨŋga, Jisas i wo bred mbumbura, i vata ago weya Loi, i mwanaviya na i giya weŋgiya gharaghambuko, na iŋa, “Hu wo na hu ghan. Iyake riwaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na i thɨna kom na tembe i vata ago weva Loi, i thɨnɨgiya weŋgi na thiya mun. ");
INSERT INTO tgo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Amba i dage weŋgi iŋa, “Waenɨke iyake madɨbaŋgu, iye i vaemunjoruŋa dagerawe togha. I voruraŋgi gharɨgharɨ lemoyo kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya dage emunjoru e ghemi, ma tene ya munɨva waenɨke iyake ghaghada ne ya munɨva waen togha Loi ele ghamba mbaro tɨne.” ");
INSERT INTO tgo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mbaŋa thɨ wothuvao wothu yaŋgara thɨ rakaraŋgi na thɨ raka Olivɨ e ghanji Ou. ");
INSERT INTO tgo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas i dage weŋgi iŋa, “Taulaghɨna ghemi ne hu iteteŋgo, kaiwae Buk Boboma iŋa, ‘Ne ya unɨgha sip ghanjiranjimbunjimbu na sip thɨ rakavo.’ ");
INSERT INTO tgo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ko amba Loi ne i vakathaŋgo na ya thuweiru, na ya viva e ghamwami Galili.” ");
INSERT INTO tgo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita i gonjoghawe iŋa, “Othembe taulaghɨke ne thɨ rakavo, ghino ma ŋgoreiye.” ");
INSERT INTO tgo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas i dagewe iŋa, “Ya dage emunjoru e ghen, amba muyai kamkam i dage mbaŋaiwo noroke gougou, mbaŋato ne uŋa ma u ghareghareŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita i gonjoghawe weiye ghalɨŋae vurɨgheghe iŋa, “Mane yaŋa ma ya ghareghareŋge, othembe thoŋgo ya mare weiŋgu ghen.” Na taulaghɨko thɨ utuŋa ŋgoreiye. ");
INSERT INTO tgo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mbaŋa Jisas na gharaghambu thɨ mena e Olivɨ ghauma idae Getesemani, i dage weŋgi iŋa, “Huya yaku gheke, na wo va naŋgo.” ");
INSERT INTO tgo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","I vaŋguŋgiya Pita, Jemes na Jon weiyaŋgi. Jisas ghare i vɨrɨ laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Amba i dage weŋgi iŋa, “Ghareŋguke i vɨrɨ laghɨye moli, mbalama i tagavamareŋgo. Hu yaku gheke na hu njaŋanjaŋa.” ");
INSERT INTO tgo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I loŋga ghaova seiwo, i dipoumu e thelauko vwatae na i naŋgo thoŋgo valɨkaiwae thava i ru vuyowoko iyako e tɨne. ");
INSERT INTO tgo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iŋa, “Bwebwe, Bwebwe! Bigibigike wolaghɨye valɨkaiwan. Thoŋgo nuwaniya, u thɨna vuyowoke ghandeghɨ e ghino. Ko iyemaeŋge thava u vakatha ghino lo renuwaŋa, u vakathaeŋge ghen len renuwaŋa.” ");
INSERT INTO tgo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I njoghama na i vaidiŋgi thiya ghena, na i dage weya Pita iŋa, “Saimon, ko hu ghenelaŋava? Ma valɨkaiwae hu yaku na hu njaŋanjaŋa lughawoghawo regha?” ");
INSERT INTO tgo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Amba i dage weŋgi iŋa, “Hu njaŋanjaŋa na hu naŋgo, mbala ma hu ru tanathetha e tɨne. Ghare nuwaiya, ko ririwo i njavovo.” ");
INSERT INTO tgo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jisas i wa na mbowo ve naŋgova na i naŋgo na tembe ŋgoreiyeva me naŋgokaima. ");
INSERT INTO tgo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na mbowo i njoghama weŋgiva gharaghambuma i vaidi tembe thɨ ghenelaŋava kaiwae mara ghenaghena i gaboŋgi. Na ma thɨ ghareghare ŋgoroŋga thɨŋawe. ");
INSERT INTO tgo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mbaŋa i njoghamava mbaŋatoninji, i dage weŋgi iŋa, “Ko amba hu ghenaghena vara mbaŋake molao? Thama ghanjighena! Mbaŋa kaero iko; e mbaŋake vara thɨ vaŋguraweya Lolo Nariye tharɨ gharavakatha e nɨmanji ghare. ");
INSERT INTO tgo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hu yondo na ra raka. Wo hu thuwe, loloma wolilivama maiyavara i menana!” ");
INSERT INTO tgo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas vamba i utuutu kaero Judas, gharaghambuma theyaworo na theghewoma regha, i vutha weiyaŋgiya wabwi laghɨye regha. Thɨ mbanɨŋgiya gaithɨ ghaghalithɨ na umbwaumbwa uboubotu. Ravowovowo laghɨlaghɨye, mbaro gharavavaghare na giyagiya vavanava methɨ variyeŋgi. ");
INSERT INTO tgo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lilivama vama i giya nono weŋgi iŋa, “The lolo ne ya vandamo, ee amalaghɨniye. Hu yalawe na mbe weimi vara hu yovaŋgu.” ");
INSERT INTO tgo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mbaŋa Judas i vutha, i mwandɨwe Jisas na iŋa, “Ravavaghare!” Na i vandamo. ");
INSERT INTO tgo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iya kaiwae thɨ yalawe e nɨmanji na thɨ vikiki. ");
INSERT INTO tgo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ko gharɨgharɨko va thɨ ndeghathɨko regha i mwanagita le gaithɨ ghaghalithɨ e ghambae na i gothethe ravowovowo laghɨlaghɨye lenji randeviva le rakakaiwo yanawae. ");
INSERT INTO tgo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisas i dage weŋgiya wabwima iŋa, “Mohuŋa eŋge rakaiva ghino iya mohu mbanɨŋgiya gaithɨna ghaghalithɨ na umbwaumbwa uboubotu na hu mena hu yalaweŋgo? ");
INSERT INTO tgo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mbaŋa regha na regha weiŋguyaŋgiya ghemi ya vavaghare e Ŋgolo Boboma na mava hu yalaweŋgo. Ko iyemaeŋge iyake i vaemunjoruŋa Buk Boboma.” ");
INSERT INTO tgo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Amba gharaghambuko thɨ voiteteŋa. ");
INSERT INTO tgo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Amala regha, amba tabwagha, vambe i njimbo eŋge kwama yaŋgara. I rereghamba weya Jisas. Wabwiko thɨ munje thɨ yalawe, ");
INSERT INTO tgo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ko i vo bukabuka, na i iteta ghakwama e ghereiye. ");
INSERT INTO tgo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Thɨ yovaŋguya Jisas ravowovowo laghɨlaghɨye lenji randeviva ele ŋgolo ŋgora vama ravowovowo, giyagiya na mbaro gharavavaghare inanjiwe. ");
INSERT INTO tgo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na Pita i rereghamba, vambe ina bwagabwaga na ve ru ravowovowo laghɨlaghɨye lenji randeviva le ŋgolo e ghayayao. I ru na i yaku weiyaŋgiya rakakaiwo na i mwa ndɨghe. ");
INSERT INTO tgo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ravowovowo laghɨlaghɨye na rambarombaro Jiu e lenji kot laghɨye tɨne thɨ mando na thɨ tamweya gharɨgharɨ valɨkaiwanji thɨ utu kaiwae na i mare, ko ma thɨ ndevaidi mun. ");
INSERT INTO tgo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Thɨ ghanagha thɨ utu kwanɨkwan kaiwae, ko lenji utuko ma mboromboro. ");
INSERT INTO tgo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Amba vavana thɨ yondo na thɨ utuŋa kwanɨke iyake kaiwae thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Va wo loŋweya iŋa, ‘Ne ya raka Ŋgolo Bobomake iyava gharɨgharɨke thɨ vatad na mbaŋa thegheto e tɨne kaero ya vatadɨva regha ma gharɨgharɨ thɨ vatad e nɨmanji!’” ");
INSERT INTO tgo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ko iyemaeŋge lenji utuko ma mboromboro. ");
INSERT INTO tgo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ravowovowo laghɨlaghɨye lenji randeviva i yondo e maranji na i dage weya Jisas iŋa, “Ko mane u gonjogha lenji utuko ghathɨthɨ? Ŋgoroŋga lenji utuko gharumwaru e ghen?” ");
INSERT INTO tgo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ko Jisas mava i ndegolambo mun. Ravowovowo laghɨlaghɨye lenji randeviva mbowo i vaitova iŋa, “Ghen Mesaiya, iya taulaghɨke ra yavwatatawanake Nariye?” ");
INSERT INTO tgo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas iŋa, “Ŋgoreiye, na ne hu thuwe Lolo Nariye i yaku Loi Vurɨgheghe e uneko na i njama e ŋgalɨlɨŋgiko e buruburu.” ");
INSERT INTO tgo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ravowovowo laghɨlaghɨye lenji randeviva i mwanathethe ghakwama ghatemuru kaiwae na iŋa, “Ma te nuwandaiyava gharɨgharɨ vavana thɨ utu kaiwae. Kaero mohu loŋweya le utuko, me utuvatharɨ weya Loi. ");
INSERT INTO tgo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ŋgoroŋga lemi renuwaŋa?” Taulaghɨko thɨŋa: “Valɨkaiwae moliya i mare!” ");
INSERT INTO tgo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Amba vavana thɨ njoŋgovun na thɨ ŋgarɨgana marae na thɨ ŋge e nɨmanji na thɨ vatabweyaruŋa thɨŋa, “Thoŋgo ghalɨŋae gharautu ghen, u dage weime thela me ŋgeŋgena.” Ragagaithɨ thɨ vaŋgu na thɨ levalevaŋa. ");
INSERT INTO tgo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita vambe ina bode e ŋgoloko ghayayao amba ravowovowo laghɨlaghɨye lenji randeviva le rakakaiwo eunda i mena ŋgora Pita inamawe. ");
INSERT INTO tgo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mbaŋa i thuwe Pita i mwamwa ndɨgheko, mbe i vonjimbughathɨ vara na i dagewe iŋa, “Ghen ŋgoreiye, vambe weinɨva Jisas rara Nasaret.” ");
INSERT INTO tgo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ko iyemaeŋge Pita i roro iŋa, “Ma ya ghareghare na ma nuwaŋgu i rumwaruŋa budakai utuniya u utuutuna.” Amba i wa iyena ve raŋgi e ghamba raŋgiko. E mbaŋaniye amba kamkam i kula. ");
INSERT INTO tgo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mbaŋa wevoma vambowo i vaidiva ŋgora ghamba raŋgima na i dage weŋgiya gharɨgharɨko thɨ ndeghathɨ gheko iŋa, “Amalake iyake Jisas gharaghambu regha.” ");
INSERT INTO tgo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ko iyemaeŋge Pita vambowo i rorova iŋa ma i ghareghare. Mbaŋa ubotu e ghereiye gharɨgharɨma va thɨ ndeghathɨma mbowo thɨ dageweva, “Emunjoru ghen ghanjiu regha ghen, kaiwae rara Galiliya ghen.” ");
INSERT INTO tgo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita i tholomundu na iŋa, “Ya dage emunjoru Loi e marae ma ya ghareghare iya lolona hu utuuta utuniyena. Thoŋgo ma ya utuŋa emunjoru Loi i lithɨ e ghino.” ");
INSERT INTO tgo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","E mbaŋako iyako kamkam i kula mbaŋaiwoniye, na Pita i renuwaŋakiki ŋgoroŋga Jisas meŋamawe, “Amba muyai kamkam i kula mbaŋaiwoniye, mbaŋato ne uŋa ma u ghareghareŋgo.” Amba Pita ghamɨnae i ghenenja moli na i randa laghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Vambe mbaŋambaŋa ravowovowo laghɨlaghɨye weinjiyaŋgiya Jiu ghanjigiyagiya, mbaro gharavavaghare na ghanjiune vavanava Jiu e lenji kot laghɨye thɨ woraweya lenji mbaro. Thɨ ŋgara Jisas thɨ yovaŋgu weya Pailat. ");
INSERT INTO tgo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat i vaito iŋa, “Ghen Jiu lenji kiŋ?” Jisas i gonjoghawe iŋa, “Ŋgoreiya iya moŋana.” ");
INSERT INTO tgo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ravowovowo laghɨlaghɨye thɨ wonjoweya Jisas va i vakathaŋgiya bigibigi raraitharɨ i ghanagha. ");
INSERT INTO tgo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailat vambowo i vaitova iŋa, “Mane u thombe? Wo u thuwe, thɨ wonjoweŋge e vakatha raraitharɨ i ghanagha.” ");
INSERT INTO tgo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ko iyemaeŋge Jisas ma i ndegonjogha mun i vakatha Pailat ghare i yo. ");
INSERT INTO tgo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Theghathagha regha na regha Thaga Valaŋani e tɨne Pailat i vaŋguvaŋguraŋgiya rayakuyaku e thiyo regha iya Jiu thɨ tuthigiyawe. ");
INSERT INTO tgo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","E mbaŋako iyako amala regha idae Barabas ina e thiyo tɨne weiyaŋgiya gharɨgharɨ vavanava. Va thɨ gaithɨ weinjiyaŋgiya Rom gharambarombaro na thɨ unɨgha lolo regha. ");
INSERT INTO tgo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mbaŋa wabwi laghɨye thɨ mevathavatha, kaero thɨ naŋgo weya Pailat i vakatha weŋgi ŋgoreiya i vakavakatha theghathegha regha na regha e mbaŋako iyako. ");
INSERT INTO tgo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat i vaitoŋgi iŋa, “Nuwamiya ya rakayathu Jiu lenji kiŋ kaiwami?” ");
INSERT INTO tgo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat i ghareghare wagiyawe ravowovowo laghɨlaghɨye thɨ yamwakabu na gharenji i gaithɨwana Jisas kaiwae gharɨgharɨko taulaghɨ nuwanjiya iya kaiwae thɨ vaŋgugiyawe. ");
INSERT INTO tgo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ko ravowovowo laghɨlaghɨye thɨ vokumukumuŋgiya wabwiko laghɨye na thɨ dage weya Pailat na i rakayathu eŋge Barabas. ");
INSERT INTO tgo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat mbowo i vaitoŋgiva wabwiko iŋa, “Ne ya vakatha budakai weya reghake iya huŋake Jiu lenji kiŋ?” ");
INSERT INTO tgo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Thɨ kula njoghawe thɨŋa, “U rokros!” ");
INSERT INTO tgo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ko Pailat i vaitoŋgi iŋa, “Buda kaiwae vara na ne ya vakatha iyako? Va i vakatha the tharɨ?” Thɨ kula na ghalɨŋanji ma i laghɨye eŋge, “U rokros!” ");
INSERT INTO tgo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kaiwae Pailat nuwaiya i vakathaŋgi na thɨ warari, i vakatha Barabas na i raŋgi e thiyo kaiwanji, amba i vakatha Jisas na thɨ yabɨbɨ na i vaŋgugiya weŋgiya ragagaithɨ na thɨ ŋge e kros. ");
INSERT INTO tgo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ragagaithɨ thɨ yovaŋguya Jisas gawana ele ŋgolo ghayayao na thɨ kula vathavathaŋgiya ghanjiuneko wolaghɨye thɨ meghɨliŋa Jisas. ");
INSERT INTO tgo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Thɨ liya kwama molao sosoro na thɨ vanjimbowe, na thɨ vona umbwa ele kinkin yaŋgae na thɨ thɨnɨrawe e umbaliye. ");
INSERT INTO tgo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Amba thɨ vakatha ŋgoreiya yavwatata ghavakavakathawe na thɨŋa, “O Jiu lenji Kiŋ, len mbaro ne i meghabana!” ");
INSERT INTO tgo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Thɨ wo umbwa na thɨ ŋgeŋgeŋa umbaliye, thɨ njoŋgovunɨvun na thɨ ronja e ghenji vuvuye thɨ kururu. ");
INSERT INTO tgo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mbaŋa thɨ vatabweruŋako na e ghereiye, thɨ liraŋgiya kwamako sosoro na thɨ vanjimbo mbe amalaghɨniye ghakwamako. Amba thɨ vaŋguraŋgiya na thɨ yovaŋgu vethɨ rokros. ");
INSERT INTO tgo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","E kamwathɨ mborowa thɨ lavolevola amala regha idae Saimon, rara Sairin, va i mena eto na ma i ruma e ghembako tɨne. Ragagaithɨko thɨ vavurɨghegheŋa na i wo Jisas ghakros. Amalaghɨniye le ŋgaŋgaŋgiya Aleksanda na Rupas. ");
INSERT INTO tgo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Thɨ yovaŋguya Jisas e bobokulu idae Golgota (gharumwaru Boutouto Ghambae). ");
INSERT INTO tgo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Thɨ thɨnɨgiya weya waen va thɨ liŋgirawe weiye mbwa regha idae mer, ko mava i mun. ");
INSERT INTO tgo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mbaŋa thɨ ŋge e krosɨko vwatae, amba thɨ wobwiya ghakwamakwama. Thɨ mbana varɨvarɨ na thɨ mwadiwoŋa mwadiwo reghawe. Thela thoŋgo i wo varɨko iya e ghanonoko amba i tuthi iyaŋganiya i bigi. ");
INSERT INTO tgo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mbaŋambaŋa, varae vama naen klok thɨ ŋge Jisas e kros vwatae. ");
INSERT INTO tgo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ghawonjowe rɨghethoru va thɨ rori na thɨ ŋge umbaliye ina yavoro iŋa, Jiu Lenji Kiŋ. ");
INSERT INTO tgo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Vambe thɨ rokrosiŋgiva rakaivɨ theghewo. Regha e une na regha e moiye. ");
INSERT INTO tgo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Gharɨgharɨ thɨ rakarakareŋa evasiwae thɨ wovanukunukuya umbalinji na thɨ goviyaviya ghamwae, thɨŋa, “Ae, va uŋa ne u tagarakaraka Ŋgolo Boboma na mbaŋa thegheto e tɨne kaero u vatadɨva. ");
INSERT INTO tgo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tembe u vamora ghanɨmberegha. U roiteta krosɨna u njama!” ");
INSERT INTO tgo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ravowovowo laghɨlaghɨye na mbaro gharavavaghare tembe thɨ goviyaviyava ghamwae thɨŋa, “Va i vamoruŋgiya gharɨgharɨ vavana, ko ma valɨkaiwae i vamoru ghamberegha! ");
INSERT INTO tgo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wo ra thuweno Mesaiya, Isirel lenji kiŋ, i njama e krosɨko ko ambane ra thuwe na wo loŋweghathɨ.” ");
INSERT INTO tgo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ghararaghɨye mboro vanautumako laghɨye i mouwo. Na i wo ghaghad tɨri klok. ");
INSERT INTO tgo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Vama tɨri klok amba Jisas i kula na ghalɨŋae laghɨye iŋa, “Eloi, Eloi, lama sabakɨtani,” gharumwaru ŋgoreiye, “Lo Loi, lo Loi, buda kaiwae u iteteŋaŋgo?” ");
INSERT INTO tgo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Gharɨgharɨ vavana va thiya ndeghathɨ gheko thɨ loŋwethavwiya ghalɨŋae na thɨŋa, “Wo hu vandeŋe, i kula weya Ilaija iyako.” ");
INSERT INTO tgo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Regha i yoruku weiye vune, i liutu e waen monyomonyo, i lirawe e umbwa mbothiye na i livoreŋa Jisas e ghae, na iŋa, “Wo ra roroghagha na ra thuwe thare Ilaija ne i mena na i wonjoŋa e krosɨko!” ");
INSERT INTO tgo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amba Jisas i randa na ghalɨŋae laghɨye moli, na i liya yawaliye. ");
INSERT INTO tgo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mbaŋako iyako kwama va i ganatena woluwolu bobomako moli e Ŋgolo Boboma tɨne i mathethe wa yavoro na ve wo bode. ");
INSERT INTO tgo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ragagaithɨ lenji randeviva i ndeghathɨ e ghamwae, i thuweya Jisas le mareko na iŋa, “Mbema emunjoru iye Loi Nariye!” ");
INSERT INTO tgo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Elaela vavana va inanji gheko. Vambe thɨ ndeghathɨ bwagabwaga na thɨ njimbukikiya Jisas. Inanji e tɨnenji Meri tɨnan Magadala, le ghaida Meri Jemes vamba iyovole eŋge na Joses tɨnanji na Salome. ");
INSERT INTO tgo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wanakauke thiyake va thɨ ghambugha Jisas mbaŋa ina Galili na thɨ thalavu e ghanɨŋga na bigibigi vavanava. Wanakau vavanava va thɨ rakawe weinji Jerusalem vambe inanjiva gheko. ");
INSERT INTO tgo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Vama yeghɨyeghɨye na kaiwae mbaŋa ghamba vivatha Sabat kaiwae, ");
INSERT INTO tgo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep rara Arɨmathiya, iye Jiu lenji kot laghɨye loloniye regha. Ghayavwatata i laghɨye na vambe i roroghaghava Loi ghambaŋa mbaro kaiwae. Ghare i matuwo i wa weya Pailat na ve naŋgo weya Jisas riwaekowe. ");
INSERT INTO tgo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ghare i yo mbaŋa i loŋweya iyako. I kula weya ragagaithɨ lenji randeviva na i vaito thoŋgo Jisas mbe kaero me mare. ");
INSERT INTO tgo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mbaŋa i loŋweya ragagaithɨko lenji randevivako le utu iŋa Jisas kaero me mare, Pailat i vatomweya riwaeko weya Josep. ");
INSERT INTO tgo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep i vamoda kwama kakaleva yaŋgara modae laghɨye, i wonjoŋa Jisas riwaeko na i ghavowe. I wo na ve worawe ele ghabubu va thɨ tɨghɨ e varɨ regha ŋgora maŋgavarɨma. Amba i vabulale varɨ laghɨye regha na i wogana ghaekowe. ");
INSERT INTO tgo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri tɨnan Magadala na Meri Joses tɨnae thɨ njimbukiki na thɨ thuwe wagiyawe aŋga methɨ woraweya Jisas riwae. ");
INSERT INTO tgo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jiu lenji Sabat iko na e ghereiye Meri tɨnan Magadala, Meri Jemes tɨnae na Salome va thɨ vamoda bunama butiye laghɨye na i thovuye. Nuwanjiya thɨ wa na vethɨ varuvo Jisas riwaemawe. ");
INSERT INTO tgo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Vambe mbaŋambaŋa e Sande, varae vama i yovoro amba thɨ wa e ghabubuko. ");
INSERT INTO tgo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","E kamwathɨ mborowa thɨ vedage weŋgi thɨŋa, “Thela ne i vabulale varɨma e ghabubuko ghae kaiwanda?” ");
INSERT INTO tgo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ko iyemaeŋge mbaŋa thɨ vutha thɨ tagathɨna maranji na thɨ thuwe varɨko kaiwae laghɨye moli, kaero methɨ vabulale vakatha. ");
INSERT INTO tgo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mbaŋa thɨ rakaru e ghabubuko tɨne, vethɨ vaidiya amala regha tabwagha, i yaku e valɨvaŋga une na i njimbo kwama molao kakaleva. Gharenji i tagathɨn laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","I dage weŋgi, “Gharemi tha i tage. Ya ghareghare hu tamwe Jisas rara Nasaret, iye amba mendake thɨ rokros. Kaero me thuweiru na ma ina gheke. Wo hu thuwe ghambaeke mendava thɨ worakewe! ");
INSERT INTO tgo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ko hu njogha na vohu dage weŋgiya gharaghambuma na Pita mbe ŋgoreiyeva. Huŋa ‘Kaero i viva e ghamwami Galili. Ne vohu vaidi gheko, ŋgorava le utuutuma weŋga.’” ");
INSERT INTO tgo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Thɨ rakaraŋgi na thɨ voiteta ghabubuko weinji lenji mararu na lenji gharelaghɨlaghɨ laghɨye. Ma vethɨ ndeutu mun weŋgiya gharɨgharɨ kaiwae thiya mararu. ");
INSERT INTO tgo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande mbaŋambaŋa moli, Jisas le thuweiru e mare e ghereiye, i yomarakai weya Meri tɨnan Magadala, iyava i variye raŋgiyaŋgiya nyaoma raraitharɨ theghepirɨmawe. ");
INSERT INTO tgo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","I wa weŋgiya Jisas gharaghambuko iyava weiyaŋgiko na ve utugiya weŋgi. Vambe inanjiwe nuwanji i tharɨ na thiya randa. ");
INSERT INTO tgo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ko mbaŋa thɨ loŋwe Meri iŋa, “Jisas kaero me thuweiru na ma thuwe e maraŋgu,” ma thɨ loŋweghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Iyake e ghereiye, Jisas i yomara weŋgiya gharaghambu theghewo na ghayamoyamo vambe regha, mbaŋa va mbema vethɨ loŋga eŋge eto. ");
INSERT INTO tgo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mbaŋa thɨ ghareghare amalaghɨniye amba thɨ njogha na vethɨ utugiya weŋgiya gharaghambuko, ko iyemaeŋge mava thɨ loŋweghathɨ. ");
INSERT INTO tgo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mbaŋa reghava i yomara weŋgiya gharaghambu theyaworo na regha, mbaŋaniye vara thiya ghanɨŋga. Jisas i ŋaebaruru wanaŋgi kaiwae mava thɨ loŋweghathɨ na mbe ŋgoreiyeva gharenji le vurɨgheghe kaiwae, kaiwae mava thɨ loŋweghathɨŋgiya thavala va thɨ thuwe le thuweiru e ghereiye. ");
INSERT INTO tgo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jisas i dage weŋgi iŋa, “Hu rakaraŋgi e yambaneke laghɨye na vohu vavaghareŋa Toto Thovuye weŋgiya gharɨgharɨke wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Thela ne i loŋweghathɨ na i bapɨtaiso Loi ne i vamora yawaliye, ko thela ma i loŋweghathɨ Loi ne i giya vuyowo weya loloko iyako. ");
INSERT INTO tgo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Thavala ne thɨ loŋweghathɨ, Loi ne i giya vurɨgheghe weŋgi na thɨ vakathaŋgiya vakatha ghamba rotaele i ghanagha. E idaŋgu ne thɨ variye raŋgiyaŋgiya nyao raraitharɨ weŋgiya gharɨgharɨ, ne thɨ utu e ghalɨghalɨŋa totogha vavanava. ");
INSERT INTO tgo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Thoŋgo ne thɨ yalaweŋgiya mwatamwata raraitharɨ o thɨ muna mamate, mane i thɨvatharɨŋgi. Ne thɨ bigiraweya nɨmanɨmanji ghambweghambwera e riwanji na riwanji i thovuye.” ");
INSERT INTO tgo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mbaŋa Giya Jisas i utuvao weŋgi amba Loi i vakatha na i voro e buruburu na i yaku Loi e une e ghamba yavwatata. ");
INSERT INTO tgo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Gharaghambu thɨ rakaraŋgi na vethɨ vavaghareŋa Toto Thovuye weŋgiya gharɨgharɨ e valɨvaŋgake wolaghɨye. Giya Jisas i thalavuŋgi na i vakatha lenji vavaghare emunjoru weŋgiya gharɨgharɨ kaiwae va thɨ thuwe vakathaŋgiko ghamba rotaele thɨ vakathako e maranji. ");
INSERT INTO tgo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kaiwae gharɨgharɨ lemoyo vama thɨ rorinjoŋa bigibigike wolaghɨye iyava thɨ yomara e tɨnemike kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Vambe thɨ ghambu vara thavala va thɨ thuwe e maranjiko lenji utuutuko. Na kaiwae va thɨ thuwe e maranji mbaŋaniye va i woraweya le kaiwo rɨghewe, na thiye ŋgoranjiya Loi le utuutu gharakakaiwo, iyava thɨ utugiya utuutuke thiyake weime. ");
INSERT INTO tgo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Iya kaiwae mbe ghino womberegha vara ya ghatha vakatha bigibigike wolaghɨye thiyake va i woraweya rɨghekowe. Nuwaŋguiya ya ghatha na ya bigirawe na vakatha na ya rorinjoŋa ghen giya laghɨye Tiyopilos kaiwan. ");
INSERT INTO tgo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ya vakatha iyake na mbala u ghareghare bigibigina va thɨ vaghareŋgena i emunjoru. ");
INSERT INTO tgo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mbaŋa Herod va ghambaŋa kiŋ Judiya, amala regha va ravowovowo idae Sakaraiya na iye i mena Abaija ele wabwi tɨne. Levo idae Elisabet na elaghɨniye Eron rumbuye. ");
INSERT INTO tgo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vambe theghewo vara ghanjithanavu i rumwaru Loi e marae na va thɨ ghambugha Loi le mbaro na ghathanavu. ");
INSERT INTO tgo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mava e lenji ŋgaŋga kaiwae Elisabet va i kwama na vama thɨ thanja moli. ");
INSERT INTO tgo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mbaŋa Sakaraiya le wabwi ghanjimbaŋa kaiwo, amalaghɨniye vambe inawe i vakavakatha ravowovowo ghanjikaiwo Loi e marae. ");
INSERT INTO tgo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kaiwae ravowovowo mbe ghanjithanavu ŋgoreiye, thɨ mwadiwo e varɨ na i nja weya Sakaraiya, ve ru e Ŋgolo Boboma tɨne na i ŋambu inisenɨs na i vowo weya Loi. ");
INSERT INTO tgo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mbaŋa inisenɨs ghambaŋa ŋambu wabwi laghɨye mbe inanji eto thiya naŋgo. ");
INSERT INTO tgo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Loi le nyao thovuye regha i yomara weya Sakaraiya e mbaŋako iyako na i ndeghathɨ inisenɨs ghaghamba ŋambuŋambuko valɨvaŋga e uneko. ");
INSERT INTO tgo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mbaŋa Sakaraiya i thuwe nyaoko thovuye ghare i yo weiye le gharelaghɨlaghɨ. ");
INSERT INTO tgo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ko iyemaeŋge nyaoko thovuye i dagewe iŋa, “Sakaraiya, tha u mararu, kaiwae Loi kaero i wovatha len naŋgona. Len wevo Elisabet ne i vaidiya ŋgama ghɨmoru na ne u rena idae Jon. ");
INSERT INTO tgo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ne hu warari laghɨye moli weiye lemi nuwathovuye na le ghambɨ ne i vakathaŋgiya gharɨgharɨ lemoyo thɨ warari. ");
INSERT INTO tgo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Na idae ne i laghɨye Loi e marae, na Nyao Boboma ne i riyevanjara mbaŋa amba mane i virɨ, na mane i muna waen o the mbwa i vurɨgheghe. ");
INSERT INTO tgo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na Isirel gharɨgharɨniye thɨ ghanagha, ne i vaŋgunjoghaŋgi weya Giya lenji Loi. ");
INSERT INTO tgo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ne i viva Giya e ghamwae, ghathanavu na le vurɨgheghe ne ŋgoreiya Ilaija. Ne i vakathaŋgiya gamagai oramanji gharenji weŋgiya lenji ŋgaŋga na i vabe thavala ma thɨ ghambu Loi le renuwaŋa na thɨ ghambugha gharɨgharɨ rumwarumwaruniye lenji renuwaŋa na i vivathara weŋgiya gharɨgharɨ Giya le mena kaiwae.” ");
INSERT INTO tgo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amba Sakaraiya i dage weya nyaoko thovuye iŋa, “Ŋgoroŋga ne yaŋa na ya ghareghare iyake emunjoru? Kaiwae kaero ya thanja moli na lo wevoko tembe ŋgoreiyeva.” ");
INSERT INTO tgo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nyaoko thovuye i gonjoghawe iŋa, “Ghino Gaberiyel na ya ndeghathɨ Loi e ghamwae. Me variyeŋgo na ya mena ya utu e ghen na ya utuveŋga totoke thovuye iyake. ");
INSERT INTO tgo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wo u thuwe kaiwae ma mo loŋweghathɨgha lo utuke, amba mane e ghalɨghalɨŋan na mane valɨkaiwan u utu ghaghada mbaŋaniye bigibigike thiyake ne thɨ yomara ŋgoreiya ma utugiyama e ghen ne e ghanjimbaŋa moli.” ");
INSERT INTO tgo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","E mbaŋako iyako gharɨgharɨma thɨ roroghagha weya Sakaraiya na thɨ rerenuwaŋa thɨŋa, “Buda kaiwae i wo mbaŋa molao e Ŋgolo Bobomako tɨne?” ");
INSERT INTO tgo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mbaŋa i raŋgi, ma valɨkaiwae i utu weŋgi na kaero thɨ ghareghare me vaidiya vatomwe regha e Ŋgolo Bobomako tɨne. Ma vama i utu, vama i vakatha eŋge nono weŋgi e nɨmanɨmae. ");
INSERT INTO tgo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mbaŋa ghambaŋa kaiwo iko e Ŋgolo Bobomako tɨne, kaero i njogha ele ŋgolo. ");
INSERT INTO tgo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mava mbaŋa bwagabwaga levo Elisabet i marabo na manjala umbolima e tɨne vambe i rokubaro vara e lenji ŋgoloko tɨne. ");
INSERT INTO tgo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet iŋa, “E mbaŋake iyake Loi kaero i thalavuŋgo e kamwathɨke iyake. Giya kaero i thalavuŋgo na i wokiyathu lo monjina gharɨgharɨ e maranji.” ");
INSERT INTO tgo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ghamanjala umbowonaninji e tɨne, Loi i variya nyao thovuye Gaberiyel Nasaret, Galili ele valɨvaŋga tɨne, ");
INSERT INTO tgo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","weya thɨnabwethubwethuru eunda vama ghadagerawe weiye amala regha idae Josep iye Deivid rumbuye. Thɨnabwethubwethuruke idae Meri. ");
INSERT INTO tgo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nyaoko thovuye i wa na ve dagewe iŋa, “Ago Meri, Giya ghare laghɨye e ghen na iye wein.” ");
INSERT INTO tgo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri i gharelaghɨlaghɨ laghɨye nyaoko thovuye ghalɨŋaewe na i rerenuwaŋa laghɨye dagemwaewoko iyako kaiwae. ");
INSERT INTO tgo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ko iyemaeŋge nyaoko thovuye i dagewe iŋa, “Tha u mararu, Meri, Loi i woraweŋge e ghamwae. ");
INSERT INTO tgo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ne u marabo na u ghamba ŋgama ghɨmoru na ne u rena idae Jisas. ");
INSERT INTO tgo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ne i laghɨye moli na ne thɨ uno, Ramevoro Moli Nariye. Giya Loi ne i wogiya weya rumbuye Deivid le ghamba yaku, ");
INSERT INTO tgo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","na ne i mbaro Jeikob orumburumbuye weŋgi na le ghamba mbaro mane ele ghambako.” ");
INSERT INTO tgo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri i vaito nyaoko thovuye iŋa, “Ne ŋgoroŋga na ya vaidiya ŋgama amba thɨnabwethubwethuruya ghino?” ");
INSERT INTO tgo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nyaoko thovuye i gonjoghawe iŋa, “Nyao Boboma ne i nja e ghen na Ramevoro Moli le vurɨgheghe i yaboŋge. Iya kaiwae ne u ghamba narunɨna boboma, ne idae Loi Nariye. ");
INSERT INTO tgo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wo u thuwe, u renuwaŋakikiya len bodama Elisabet, kaero i thanja na va thɨŋa i kwama, kaero i marabo na mbaŋake ghamanjala umbowona. ");
INSERT INTO tgo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kaiwae ma bigi regha i vuyowo weya Loi valɨkaiwae Loi i vakatha.” ");
INSERT INTO tgo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri i gonjoghawe iŋa, “Giya le rakakaiwo ghino. Ma i vakathaeŋge ŋgoreiya mo utuŋana e ghino.” Amba nyaoko thovuye i iteteŋa. ");
INSERT INTO tgo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","E mbaŋako iyako Meri i vivatha, na i yoruku i wa e ghemba regha e ououniye Judiya e tɨne. ");
INSERT INTO tgo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","I vutha na i ru Sakaraiya ele ŋgolo na i dage mwaewo weya Elisabet. ");
INSERT INTO tgo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mbaŋa Elisabet i loŋweya Meri le dagemwaewo ŋgamako i ghenenyivɨ e ŋgamoiye na Nyao Boboma i riyevanjara Elisabet. ");
INSERT INTO tgo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","I dage na ghalɨŋae laghɨye iŋa, “Wanakauke wolaghɨye e tɨnenji Loi ghare e ghen na ghandagemwaewona i kivwala wanakauke wolaghɨye ghanjidagemwaewo, na tembe ghare weva ŋgamana ne u ghambɨna. ");
INSERT INTO tgo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ko me ŋgoroŋgaeŋge na ghen wo Giya tɨnae mo vakatha wo yavwatata laghɨye na mo mena u thuweŋgo? ");
INSERT INTO tgo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mbaŋa len dagemwaewona me dimban e yanawaŋgu, ŋgamake e ŋgamoiŋguke i ghenenyivɨ weiye le warari. ");
INSERT INTO tgo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ŋgoreiye, u warari kaiwae u loŋweghathɨgha ŋgoroŋga Giya le dagerawe e ghen kaero ne i tabo na emunjoru.” ");
INSERT INTO tgo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meri iŋa, Ghareŋguke i taraweŋa Giya, ");
INSERT INTO tgo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na uneŋguke i warari laghɨye weya Loi wo Ravamoru, ");
INSERT INTO tgo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kaiwae i renuwaŋakikiya le rakakaiwo ma e idaidae. Noroke na mbaŋa thɨ menamenako tha na tha ne thɨ uno idaŋgu, “Wevo warawarariniye”, ");
INSERT INTO tgo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kaiwae Loi Vurɨgheghe i vakatha bigibigi laghɨlaghɨye kaiwaŋgu. Iye ghamberegha i boboma. ");
INSERT INTO tgo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Le ghare vɨrɨ i laghɨye weŋgiya tha na tha thavala thɨ yavwatatawana. ");
INSERT INTO tgo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E nɨmae i vakatha vakatha laghɨlaghɨye moli na i vagegeyathuŋgiya thavala thɨ wovorevoreŋa ghanjimberegha e gharenji. ");
INSERT INTO tgo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kaerova i wonjoŋaŋgiya giyagiya laghɨlaghɨye e ghambanji na i wovoreŋaŋgiya thavala ma e idaidanji. ");
INSERT INTO tgo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I giya bigibigi thovuthovuye weŋgiya thavala bada i gharɨŋgi na i vathaŋgiya ravwenyevwenye nɨmanɨmanji. ");
INSERT INTO tgo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kaerova i mena i thalavugha le rakakaiwo wabwi Isirel, na ma i renuwaŋa valawe i gharevɨrɨŋaŋgi, ");
INSERT INTO tgo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ŋgoreiya va le dagerawe weŋgiya orumburumbunda, ŋgoreiya va le dagerawe, iya i gharevɨrɨ weŋgiya Eibraham na orumburumbuye tha na tha. ");
INSERT INTO tgo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri va i yaku weiye Elisabet mbaŋa le molamolao ŋgoreiya manjala umboto amba i njogha e ghambae. ");
INSERT INTO tgo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mbaŋa Elisabet ŋgamoiye i njivun, i ghamba ŋgama ghɨmoru, ");
INSERT INTO tgo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","na mbaŋa ghaune na le bodaboda thɨ loŋweya ŋgoroŋga Giya i woraŋgiya le gharevɨrɨ laghɨye weya Elisabet, thɨ warari laghɨye weinji. ");
INSERT INTO tgo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mbaŋa theghewaninji e tɨne thɨ mena na thɨ kitena ŋgamako riwae njimwae mbothiye na thɨ munje thɨ rena idae Sakaraiya, ramaya idae. ");
INSERT INTO tgo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ko iyemaeŋge tɨnae ghalɨŋae i maya na iŋa, “Nandere! Idae Jon.” ");
INSERT INTO tgo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Thɨ dagewe thɨŋa, “Ma lolo regha len bodabodake e tɨnenji idae ŋgora iyana.” ");
INSERT INTO tgo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Thɨ vakatha nono weya ramae na nuwanjiya the ida ne i worawe na ŋgamako idae. ");
INSERT INTO tgo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaraiya i naŋgo weya bigi ghamba rorori na i roriya iyake, “Idae Jon.” Na taulaghɨko gharenji i yo. ");
INSERT INTO tgo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","E mbaŋako vara iyako Sakaraiya ghalɨŋae i mavu na mamiye i nyivɨnyivɨ amba i utu na i taraweŋa Loi. ");
INSERT INTO tgo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ghanjiuneko wolaghɨye thɨ thuwe iyako na i vakatha thɨ gharelaghɨlaghɨ laghɨye moli. Amba bigibigike wolaghɨye thiyake utuninji i lalo ghembaghembako wolaghɨye e ououninji Judiya e tɨne. ");
INSERT INTO tgo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Gharɨgharɨko wolaghɨye va thɨ loŋweya totoko iyako thɨ rerenuwaŋa kaiwae na thɨŋa, “Ŋgoroŋga nevole ŋgamako iyako gharerenuwaŋa? Kaiwae vambe weiya vara Giya le vurɨgheghe.” ");
INSERT INTO tgo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nyao Boboma va i riyevanjara ramae Sakaraiya amba i utuŋa Loi ghalɨŋae iŋa: ");
INSERT INTO tgo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ra taraweŋa Giya iye Isirel lenji Loi, kaiwae kaero menda i mena ghinda le gharɨgharɨ kaiwanda, i thalavuinda na i rakayathuinda, ");
INSERT INTO tgo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","na i wogiya vamoru ghakin mara mbouye kaiwanda le rakakaiwo Deivid orumburumbuye e tɨnenji. ");
INSERT INTO tgo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mbaŋa va i vivako ghalɨŋae gharautu boboma thɨ vathiya utuutuke iyake, ");
INSERT INTO tgo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","va i dagerawe ghandaravamoru na ne i vamoruinda weŋgiya ghandathɨghɨya, na thavala thɨ botewoinda e nɨmanji ghare. ");
INSERT INTO tgo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Va iŋa ne i gharevɨrɨŋaŋgiya orumburumbunda na i renuwaŋakikiya le dagerawe boboma. ");
INSERT INTO tgo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Va i tholo na i dagerawe weya rumbunda Eibraham ");
INSERT INTO tgo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na iŋa ne i vamoruinda weŋgiya ghandathɨghɨya na i vakathainda rakaiwowe ma weinda la mararu ");
INSERT INTO tgo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","e yawalɨ boboma na e thanavu rumwaru e marae e mbaŋake wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ghen, naruŋgu, ne idan Ramevoro Moli ghalɨŋae gharautu, kaiwae ne u viva Giya e ghamwae na u vivatha kamwathɨ kaiwae. ");
INSERT INTO tgo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na kaiwae ne u vakathaŋgi thɨ ghareghareya Giya le vamoru, na i numotenɨŋgi lenji tharɨ e tɨne, ");
INSERT INTO tgo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kaiwae Loi i gharevɨrɨ laghɨye moli na ghathanavu i udauda kaiwanda, na i vakatha manjamanjala ŋgoreiya varaema i yovoro na manjamanjalawae i njama weinda e buruburuko ");
INSERT INTO tgo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na i giya manjamanjala weŋgiya thavala thɨ yayaku e momouwo na yawalinji i mare, na i vatomwe weinda yawalɨ na vanevane ghanjikamwathɨ.” ");
INSERT INTO tgo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ŋgamama i tabotabo na une i vurɨvurɨgheghe na ve yaku e njamnjam ghaghada mbaŋa i woraweya le kaiwo rɨghe weŋgiya wabwi Isirel. ");
INSERT INTO tgo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Va e mbaŋaŋgiko thiyako Sisa Ogastas i worawe le mbaro na thɨ wo vavaona Rom ele ghamba mbaro tɨne. ");
INSERT INTO tgo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Vavaonako iyako ambama thɨ wokai vara mbaŋa Koniliyos ghambaŋa gawana Siriya e tɨne. ");
INSERT INTO tgo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Taulaghɨko va thɨ raka, regha na regha vambe i wa e vanarɨghe moli na ve roriya idaewe. ");
INSERT INTO tgo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep i ri Nasaret Galili e tɨne na i wa Betɨlehem Judiya e tɨne. Ghembako iyako Deivid vanarɨghe na Josep va i wawe kaiwae iye Deivid rumbuye. ");
INSERT INTO tgo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep va ve rorinjoŋa idae weiye Meri, iye vama ghadagerawe weiye Meri vama ghanono ghambɨ. ");
INSERT INTO tgo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na mbaŋa va inanji gheko, Meri ghambaŋa i ghamba nariyeko. ");
INSERT INTO tgo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","I ghambɨkai vara nariye ŋgama ghɨmoru, i ghavo riwae e kwama na i worawe kau e lenji ghamba ghanɨŋga, kaiwae ma vama ŋgolo bobwari regha kokowae ina gheko kaiwanji. ");
INSERT INTO tgo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","E valɨvaŋgako iyako sip gharanjimbunjimbu vavana va inanjiwe e ghembako valɨvaŋga regha, thɨ njimbukikiŋgiya lenji sip gougou. ");
INSERT INTO tgo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Giya le nyao thovuye regha i yomara weŋgi, amba Giya le vwenyevwenye manjamanjalawae i vakeke vaghɨliyaŋgi na thɨ mararu laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ko iyemaeŋge nyaoko thovuye i dage weŋgi iŋa, “Thava hu mararu! Wo hu thuwe, ya womena warari laghɨye na wararike iyake ne i womena warari laghɨye weŋgiya gharɨgharɨke wolaghɨye. ");
INSERT INTO tgo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","E gougouke noroke, Deivid e ghambae ghami Ravamoru i virɨ, iye Mesaiya na Giya. ");
INSERT INTO tgo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ghanono ŋgoreiyake weŋga: Ne hu thuwe ŋgama gunagunagha regha thɨ ghavo riwae e kwama na i ghena kau e lenji ghamba ghanɨŋga.” ");
INSERT INTO tgo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","E mbaŋako iyako rameburuburu lemoyo moli thɨ yomara na thɨ tataraweŋa Loi weinji nyaoma thovuye thɨŋa, ");
INSERT INTO tgo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wovavwenyevwenye i voro weya Loi, iye i mevoro moli e buruburu, na e yambaneke Loi le gharemalɨlɨ weŋgiya gharɨgharɨ amalaghɨniye i warariŋaŋgi.” ");
INSERT INTO tgo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mbaŋa vama nyaoma thovuthovuye thɨ rakaiteteŋgi na thɨ rakanjogha e buruburu, sipɨma gharanjimbunjimbu thɨ vedage weŋgi thɨŋa, “Ra raka Betɨlehem na wo vara thuwe bigike iya me yomarake, iya Giya me utugiya utuniyeke weinda.” ");
INSERT INTO tgo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Vambema ghenji na nɨmanji eŋge vethɨ tamwe vaidiya Meri na Josep na ŋgamama nasiye i ghena kau e lenji ghamba ghanɨŋga. ");
INSERT INTO tgo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mbaŋa thɨ thuwe ŋgamama tembe thɨ vathigiyava weŋgi budakaiya nyaoma thovuthovuye lenji woraŋgiya weŋgi ŋgamako utuniye. ");
INSERT INTO tgo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Thavala va thɨ loŋwe sipɨko gharanjimbunjimbu lenji utu gharenji i yo laghɨye, ");
INSERT INTO tgo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ko iyemaeŋge Meri ghare i thalavwayaŋa bigibigike thiyake kaiwanji na i worawe e ghare. ");
INSERT INTO tgo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sip gharanjimbunjimbu thɨ rakanjogha, thɨ wovavwenyevwenyeŋa na thɨ taraweŋa Loi, lenji loŋwe na lenji thuweko kaiwae, ŋgoreiya nyao thovuye le woraŋgiya weŋgi. ");
INSERT INTO tgo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mbaŋa theghewaniye e tɨne, kaero valɨkaiwae na thɨ kitena ŋgamako riwae njimwae, thɨ rena idae Jisas, ŋgoreiya nyao thovuye va le woraŋgiya weya Meri mbaŋa ma vamba i marabo. ");
INSERT INTO tgo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mbaŋa vama Josep na Meri ghanjimbaŋa thɨ vakatha riwanji i thɨna ŋgoreiya Mosese le Mbaro i woraŋgiya, thɨ wo ŋgamama na weinji thɨ voro Jerusalem na thɨ vatomwe weya Giya, ");
INSERT INTO tgo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ŋgoreiya Giya le mbaro thɨ rori Buk Boboma e tɨne iŋa, “Gamau ghɨmoghɨmoruna wolaghɨye hu vabobomaŋgi weya Giya.” ");
INSERT INTO tgo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tembe ŋgoreiyeva thɨ mbana bunebune manyiwo o mbo manyiwo na thɨ vowowe ŋgoreiya Giya le mbaro i woraŋgiya. ");
INSERT INTO tgo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Amala regha va ina Jerusalem idae Simiyon. Iye va i rumwaru na i ghambugha Loi. Nyao Boboma va inawe. Vambe i roroghagha vara thembaŋa Isirel gharɨgharɨniye thɨ vaidiya vamoru. ");
INSERT INTO tgo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nyaoko Boboma le woraŋgiyawe, mamba ne i vaidiya ghakula ghaghada i thuwe Ravamoru iye Loi va i dagerawe. ");
INSERT INTO tgo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ŋgoreiya Nyao Boboma le woraŋgiyawe, Simiyon ve ru e Ŋgolo Boboma tɨne, na mbaŋa Josep na Meri thɨ woruwo ŋgamako Jisas na thɨ vakathawe ŋgoreiya ghanjithanavu na lenji mbaro le woraŋgiya weŋgi, ");
INSERT INTO tgo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyon i wo ŋgamako na i worawe e nɨmanɨmae amba i tarawe Loi iŋa, ");
INSERT INTO tgo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Giya Laghɨye, kaero ŋgoreiya len dagerawema, e mbaŋake iyake u vatomweya len rakakaiwo na i garalawa weiye gharemalɨlɨ, ");
INSERT INTO tgo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kaiwae e maraŋguke kaero ya thuwe len vamoru, ");
INSERT INTO tgo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","va u vivatharawe gharɨgharɨke wolaghɨye e maranji. ");
INSERT INTO tgo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iye manjamanjala na ne i woya weŋgiya thiye ma Jiu, na ne i vavwenyevwenyaŋgiya len gharɨgharɨ Isirel.” ");
INSERT INTO tgo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ŋgamako ramae na tɨnae thɨ ndetaele budakaiya Simiyon va i utuŋa ŋgamako kaiwae. ");
INSERT INTO tgo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Amba Simiyon i naŋgo weya Loi na ghare weŋgi na i dage weya Meri iŋa, “Ŋgamake iyake gharerenuwaŋa ŋgoreiya ne i vakathaŋgiya gharɨgharɨ lemoyo thɨ dobu na gharɨgharɨ lemoyo thɨ yondovirɨ Isirel e tɨne. Iye ne nono i mena weya Loi na gharɨgharɨ lemoyo ne thɨ utuvatharɨwe, ");
INSERT INTO tgo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na amalaghɨniye kaiwae gharɨgharɨ lemoyo lenji renuwaŋa thuwele ne thɨ rakaraŋgi e manjamanjala. Ne vɨrɨ ghamɨnae ŋgoreiya gaithɨ ghaghalithɨ ne i vweya gharena.” ");
INSERT INTO tgo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yalaghɨsarɨ eunda idae Ana, Penuwel yawarumbuye na i mena Asa e gheuu tɨne. Iye Loi ghalɨŋae gharautu. Le ghe e ghereiye, theghathegha vambe umbopirɨ eŋge i yaku weiye le ghɨmoru ");
INSERT INTO tgo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kaero i wambwiva ghaghada mbaŋako iyako ghatheghathegha kaero i wo ghwewa na umbovarɨ. Ma mbaŋa regha i iteta Ŋgolo Boboma, ghararaghɨye na gougou i kururu weya Loi, i mbeya ghanɨŋga na i naŋgonaŋgo. ");
INSERT INTO tgo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Va e mbaŋako iyako i vuthawe, i vata ago weya Loi na i utuŋa ŋgamako utuutuniye weŋgiya gharɨgharɨke wolaghɨye thiye va thɨ roroghagha thembaŋa Loi ne i unuyathu Jerusalem e vuyowo tɨne. ");
INSERT INTO tgo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mbaŋa Josep na Meri thɨ vakathavao bigibigiko wolaghɨye ŋgoreiya Giya le Mbaro gharerenuwaŋa, kaero thɨ njoghava e ghambanji, Nasaret, Galili e tɨne. ");
INSERT INTO tgo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ŋgamako i tabo na laghɨye na i vurɨgheghe, thimba i riyevanjara na Loi le gharemwaewo inawe. ");
INSERT INTO tgo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Theghathagha regha na regha e tɨne tɨnae na ramae thɨ wawa Jerusalem Thaga Valaŋani kaiwae. ");
INSERT INTO tgo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mbaŋa vama ghatheghathegha hoyaworo na umboiwo, tembe thɨ wava ŋgoreiye thɨ vakavakathama. ");
INSERT INTO tgo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Thaga e ghereiye, tɨnae na ramae thɨ wareriŋa ghambanji, ko iyemaeŋge Jisas vambe ina Jerusalem. Tɨnae na ramae mava thɨ ghareghare iyako. ");
INSERT INTO tgo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lenji renuwaŋa thɨŋa eŋge vama weinji. Mbaŋako iyako yeghɨyeghɨyeniye amba thɨ tamwe. Thɨ tamwe weŋgiya lenji bodaboda na ghanjiune vavana. ");
INSERT INTO tgo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ko iyemaeŋge ma thɨ vaidi, iya kaiwae tembe thɨ njoghava Jerusalem na vethɨ tamwewe. ");
INSERT INTO tgo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mbaŋa thegheto e ghereiye amba thɨ vaidi e Ŋgolo Boboma tɨne weiyaŋgiya mbaro gharavavaghare vavana i vandeŋeŋgi na i giyagiya vaito weŋgi. ");
INSERT INTO tgo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Taulaghɨko gharenji i yo le ghareghare na le gonjoghako kaiwae. ");
INSERT INTO tgo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tɨnae na ramae gharenji i yo mbaŋa thɨ vaidi. Tɨnae i dagewe iŋa, “Naruŋgu, buda kaiwae u vakatha weime ŋgorako? Ghino na rama wo rerenuwaŋa laghɨye kaiwan, wo tamwetamwe e ghen.” ");
INSERT INTO tgo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","I dage weŋgi iŋa, “Buda kaiwae hu tamwetamwe weŋgo? Ma hu ghareghare valɨkaiwae inaŋgu bwebwe ele ŋgolo?” ");
INSERT INTO tgo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ko iyemaeŋge ma nuwanji i manjamanjala ŋgoroŋga meŋako weŋgi. ");
INSERT INTO tgo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Amba i wa weiyaŋgi, thɨ njogha Nasaret na i ghambugha ghalɨŋanji. Ko tɨnae vambe i renuwaŋakiki vara bigibigiko thiyako na i worawe e ghare. ");
INSERT INTO tgo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas i tabo na laghɨye, i thimba na i vakatha Loi i warari kaiwae na tembe ŋgoreiye thavala thɨ ghareghare. ");
INSERT INTO tgo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibiriyas Sisa ghambaŋa mbaro, theghathegha hoyaworo na umbolimaninji e tɨne, Pontiyas Pailat iye Judiya ghagawana, Herod iye Galili gharambarombaro na ghaghae Pilip i mbaro Itureya na Tɨrokonitis e lenji valɨvaŋga na Lisaniyas iye i mbaro Abilini, ");
INSERT INTO tgo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na e mbaŋako iyako Anas na Kaiyapas thiye ravowovowo laghɨlaghɨye lenji randevivaŋgi. E mbaŋako iyako Loi ghalɨŋae i mena weya Jon, Sakaraiya nariye, ina e njamnjam. ");
INSERT INTO tgo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Va i vaghɨliya Jorɨdan ele valɨvaŋgako tɨne na i vavaghare weŋgiya gharɨgharɨ thɨ uturaŋgiya lenji tharɨ na thɨ roiteteŋgi na Loi i numotena lenji tharɨ. Amba thɨ bapɨtaiso, ");
INSERT INTO tgo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ŋgoreiya Aiseya, Loi ghalɨŋae gharautu va i rori ele utu iŋa, “Lolo regha i kulakula e njamnjam, ‘Hu vivatha kamwathɨ Giya kaiwae, na hu varumwaru na mbala i reŋawe! ");
INSERT INTO tgo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tholowo regha na regha hu tɨghɨyomuŋgi, na ouou na bobokulu hu mbunɨyathuŋgi na i rumwaru. Kamwathɨ thɨ godugodu hu vanamweŋgi na gotɨthaŋarɨ hu laloŋgi, ");
INSERT INTO tgo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","na gharɨgharɨke wolaghɨye mbala thɨ vaidiya Loi le vamoru.’” ");
INSERT INTO tgo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","I dage weŋgiya wabwiko laghɨye va thɨ rakamenakowe bapɨtaiso kaiwae iŋa, “Ghemi mwata raraitharɨ ghemi! Thela i dage e ghemi na hu munjeva ne hu voiteta Loi le ghatemuruko vuyowae iya i menamenako? ");
INSERT INTO tgo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hu vaemunjoruŋa e lemi vakathana kaero hu uturaŋgiya lemi tharɨ na hu roiteteŋgi na thava huŋa, ‘Loi mane i giya vuyowo weime. Ghime Eibraham orumburumbuya ghime.’ Ya dage e ghemi, Loi valɨkaiwae i mbanɨŋgiya varɨvarɨke thiyake na i vakathaŋgiya Eibraham orumburumbuye. ");
INSERT INTO tgo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","E mbaŋake iyake kelumo kaero ina vara e umbwaumbwa rɨgherɨghenji. Umbwa regha na regha ma i rau na thovuye ne i ikuyathu na i bigiyathu e ndɨghe une.” ");
INSERT INTO tgo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wabwiko thɨ vaito, thɨŋa, “Ko ne wo vakathaeŋge budakai?” ");
INSERT INTO tgo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon i gonjogha weŋgi iŋa, “Thela ghakwama ghayaboyabo yaŋgaiwo, valɨkaiwae i ligiya yaŋgara weya thela ma e ghakwama ghayaboyabo, na thela e ghae tembe i vakatha ŋgoreiyeva.” ");
INSERT INTO tgo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis gharamban vavana thɨ rakamena bapɨtaiso kaiwae, thɨ govaito thɨŋa, “Ravavaghare, ne wo vakatha budakai?” ");
INSERT INTO tgo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I dage weŋgi iŋa, “Thava hu mban na hu kivwala ŋgoreiya ghamighadɨna.” ");
INSERT INTO tgo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ragagaithɨ vavana tembe thɨ vaitova thɨŋa, “Naka ghime? Ne wo vakatha budakai?” I gonjogha weŋgi iŋa, “Tha hu rovurɨgheghe na hu vakaivɨŋa lolo regha na hu wonjowebwagaŋgi tharɨ e ghavakatha mbala hu kaivɨŋgi. Nuwamina i loghe eŋge modamina kaiwae.” ");
INSERT INTO tgo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gharɨgharɨ kaero thɨ rerenuwaŋa na lenji renuwaŋa e gharenjiko kaero i ruku, thɨŋava Jon iye mbwata Mesaiya. ");
INSERT INTO tgo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon i gonjogha weŋgi iŋa, “Ghino ya bapɨtaisoŋga e mbwa, ko iyemaeŋge loloko iya i menamenako iye i vurɨgheghe kivwalaŋgo. Ghino ma elo thovuye na valɨkaiwaŋgu ne ya rakayathu gheghe ghae. Iye ne i bapɨtaisoŋga e Nyao Boboma na e ndɨghe une. ");
INSERT INTO tgo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Le savɨrɨ wit kaiwae kaero ina e nɨmae, ne i ghatha mbombouyeko weiye wokiwokiniyeko. Ne i mbana mbombouyeko na i vathe e ghaŋgolo na wokiwokiniyeko i ŋambu e ndɨgheko iya ma mbaŋa regha ne i mareko.” ");
INSERT INTO tgo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","E utuutu ŋgoranjiyako i ghanagha Jon i vakaiwoŋaŋgi na i vavurɨghegheŋgiya gharɨgharɨ na i vavaghare weŋgiya Toto Thovuye. ");
INSERT INTO tgo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ko iyemaeŋge Jon i goviya Herod ghamwae, kaiwae i vaŋgwa Herodiyas ghaghae levo, na kaiwae vambe i vakathaŋgiva tharɨ lemoyo. ");
INSERT INTO tgo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tharɨŋgiko thiyako e vwatanji, Herod tembe i vakathava tharɨ laghɨye regha, i woruwo Jon e thiyo. ");
INSERT INTO tgo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mbaŋa gharɨgharɨko wolaghɨyeko va thɨ bapɨtaiso na Jisas tevambe i bapɨtaisova. Mbaŋa va i naŋgonaŋgo, buruburu i mavu, ");
INSERT INTO tgo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Nyao Boboma i njawe ŋgoreiya bunebune. Amba ghalɨghalɨŋa regha i njama e buruburu iŋa, “Ghen naruŋgu gharegharethovuniye, u vakatha ya warari laghɨye moli.” ");
INSERT INTO tgo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mbaŋa Jisas ghatheghathegha vama ŋgoreiye ghweto amba i woraweya le kaiwo rɨghe. Gharɨgharɨ thɨ renuwaŋa amalaghɨniye ramaya Josep, Josep ramaya Heli, ");
INSERT INTO tgo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ramaya Matat, Matat ramaya Livai, Livai ramaya Melɨki, Melɨki ramaya Janai, Janai ramaya Josep, ");
INSERT INTO tgo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ramaya Matataiyas, Matataiyas ramaya Emos, Emos ramaya Neiham, Neiham ramaya Esli, Esli ramaya Nagai, ");
INSERT INTO tgo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ramaya Maathɨ, Maathɨ ramaya Matataiyas, Matataiyas ramaya Semein, Semein ramaya Josek, Josek ramaya Joda, ");
INSERT INTO tgo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ramaya Joanan, Joanan ramaya Risa, Risa ramaya Serubabol, Serubabol ramaya Salatiyel, Salatiyel ramaya Niri, ");
INSERT INTO tgo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri ramaya Melɨki, Melɨki ramaya Adi, Adi ramaya Kosam, Kosam ramaya Elmadam, Elmadam ramaya Erɨ, ");
INSERT INTO tgo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erɨ ramaya Josuwa, Josuwa ramaya Eliyesa, Eliyesa ramaya Jorim, Jorim ramaya Matat, Matat ramaya Livai, ");
INSERT INTO tgo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai ramaya Simiyon, Simiyon ramaya Juda, Juda ramaya Josep, Josep ramaya Jonam, Jonam ramaya Ilaiyakim, ");
INSERT INTO tgo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ilaiyakim ramaya Meliya, Meliya ramaya Mena, Mena ramaya Matatha, Matatha ramaya Neitan, Neitan ramaya Deivid, ");
INSERT INTO tgo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deivid ramaya Jese, Jese ramaya Obedi, Obedi ramaya Bowasa, Bowasa ramaya Salmon, Salmon ramaya Nason, ");
INSERT INTO tgo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ramaya Aminadab, Aminadab ramaya Adɨmin, Adɨmin ramaya Anai, Anai ramaya Hesɨron, Hesɨron ramaya Peres, Peres ramaya Juda, ");
INSERT INTO tgo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ramaya Jeikob, Jeikob ramaya Aisake, Aisake ramaya Eibraham, Eibraham ramaya Tira, Tira ramaya Neiho, ");
INSERT INTO tgo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neiho ramaya Serug, Serug ramaya Riu, Riu ramaya Peleg, Peleg ramaya Eberɨ, Eberɨ ramaya Sila, ");
INSERT INTO tgo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila ramaya Keinan, Keinan ramaya Apaksad, Apaksad ramaya Sem, Sem ramaya Nowa, Nowa ramaya Lemek, ");
INSERT INTO tgo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek ramaya Metuisela, Metuisela ramaya Inok, Inok ramaya Jered, Jered ramaya Malaliyel, Malaliyel ramaya Keinan, ");
INSERT INTO tgo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinan ramaya Inos, Inos ramaya Set, Set ramaya Adam, Adam ramaya Loi. ");
INSERT INTO tgo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisas, Nyao Boboma i riyevanjara, i njoghama e Walaghɨta Jorɨdan na Nyao Boboma i yovaŋgu e njamnjam vurɨvurɨ vwatavwata, ");
INSERT INTO tgo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","amba Seitan ve vatanathethaŋawe gheneyevarɨ e tɨne. E mbaŋako thiyako mava i ndeghanɨŋga mun, na gheneyevarɨko e ghereinji amba bada i gharɨ. ");
INSERT INTO tgo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seitan i dagewe iŋa, “Thoŋgo Loi Nariya ghen, u ŋaerambeya varɨke i gharavɨ na bred.” ");
INSERT INTO tgo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas i gonjoghawe iŋa, “Buk Boboma iŋa, ‘Lolo ma mbene bred eŋge i ndewo lolo yawaliye.’” ");
INSERT INTO tgo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mbaŋa ubotu Seitan i vaŋguvoreŋa ghemba yavoro moli, na i vatomwe weya ghamba mbaroko wolaghɨye e yambaneke, ");
INSERT INTO tgo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","na i dagewe iŋa, “Ne ya vatomwe e ghen ghamba mbaroko wolaghɨye thiyako na u mbaroŋaŋgi weiye lenji vwenyevwenyeko wolaghɨye. Kaerova i vatomwe weŋgo, na ne ya vatomwe weya the lolothan nuwaŋguiya ya vatomwewe. ");
INSERT INTO tgo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iya kaiwae thoŋgo u kururu e ghino, wolaghɨyeko ne ya vatomwe e ghen.” ");
INSERT INTO tgo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas i gonjoghawe iŋa, “Gharorori ŋgoreiyake, ‘U kururu weya Giya len Loi ghamberegha na ghamberegha moli u ghambu.’” ");
INSERT INTO tgo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Amba Seitan i yovaŋgu Jerusalem na i vaŋgurawe vara e Ŋgolo Boboma vwatae yavoro moli, na i dagewe iŋa, “Thoŋgo Loi Nariya ghen, u pito ghena. ");
INSERT INTO tgo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kaiwae Buk Boboma iŋa: ‘Loi ne i variyeŋgiya le nyao thovuthovuye kaiwan na thɨ njimbukiki wagiyaweŋge, ");
INSERT INTO tgo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ne thɨ mwanavairɨŋge e nɨmanji mbala ma vo ŋge gheghen e varɨ.’” ");
INSERT INTO tgo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ko iyemaeŋge Jisas i dagewe iŋa, “Buk Boboma iŋa, ‘Tha lolo regha i mando na i woraweya Giya le Loi mando e tɨne.’” ");
INSERT INTO tgo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mbaŋa Seitan vama le tanathethako iko weya Jisas, amba i iteteŋa ghaghad ghambaŋa thovuye reghava. ");
INSERT INTO tgo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Amba Jisas i ghambu Nyao Boboma ghalɨŋae na i njogha Galili ele valɨvaŋga Nyao Boboma i riyevanjara, na toto amalaghɨniye kaiwae i lalo valɨvaŋgako laghɨye. ");
INSERT INTO tgo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Va i vavaghare Jiu e lenji ŋgolo kururu tɨnenji na gharɨgharɨko wolaghɨye thɨ taraweŋa. ");
INSERT INTO tgo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","I mena Nasaret, va i tabowe, na Sabat ghambaŋa i ru Jiu e lenji ŋgolo kururu tɨne ŋgoreiya vambe i vakavakatha. I yondovirɨ na i vaona buk, ");
INSERT INTO tgo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","thɨ thɨnɨgiya weya Loi ghalɨŋae gharautu, Aiseya le buk. I tate na i vaidiya utuutuke thiyake: ");
INSERT INTO tgo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Giya Une ina e ghino, kaiwae kaerova i tuthiŋgo na ya womena Toto Thovuye weŋgiya mbinyembinyeŋgu. Va i variyeŋgo na ya uturaŋgiya unuyathu utuniye weŋgiya thavala thɨ vanɨŋgi, na thavala maranji thɨ tharɨ kaero thɨ thuweva na ya unuyathuŋgiya thavala thɨ njimbu njoŋanjoŋaŋgi, ");
INSERT INTO tgo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na ya uturaŋgiya mbaŋake Giya ne i vamoruŋgiya le gharɨgharɨ.” ");
INSERT INTO tgo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas i vaonavao, i vona bukuko na i thɨnɨgiya njogha weya ŋgolo kururu gharanjimbunjimbu amba i ronja. Gharɨgharɨko wolaghɨye e ŋgoloko tɨne mbe thɨ vonjimbughathɨ vara. ");
INSERT INTO tgo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","I dage weŋgi iŋa, “Utuutuke iya e bukuke iyake kaero i tabona emunjoru e mbaŋake noroke ŋgoreiya me lemi loŋwena.” ");
INSERT INTO tgo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Taulaghɨko thɨ wovathovuthovuyeŋa na gharenji i yo laghɨye utuutuko thovuthovuye thɨ raŋgiraŋgi e ghaeko. Thɨŋa, “Ma Josep nariyeko, ae?” ");
INSERT INTO tgo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","I dage weŋgi iŋa, “Ya ghareghare ne hu guveŋgwa goghaimbake iyake, ne huŋa, ‘Rathawathawari, tembe u thawariya ghanɨmbereghana.’ Vakavakatha ghamba rotaele wo loŋwe va u vakatha Kapenaom, tembe u vakathava gheke, e ghambanɨke moli.” ");
INSERT INTO tgo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jisas i gotubwe iŋa, “Ya dage emunjoru e ghemi, gharɨgharɨ thɨ botewo Loi ghalɨŋae gharautu thoŋgo iye ghambanji loloniye. ");
INSERT INTO tgo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ya vaemunjoruŋa e ghemi, Ilaija va e ghambaŋa tɨne, theghathegha umboto na vaŋgothiye mava i ndeuye mun Isirel e tɨne. Iyake va i vakatha vunuvu laghɨye e valɨvaŋgako iyako. Othembe raŋama wambwiwambwi lemoyo va inanji Isirel e mbaŋako iyako, ");
INSERT INTO tgo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ko iyemaeŋge Loi mava i variya Ilaija weya eunda Isirel e tɨne, ko vambe i variye eŋge weya wambwi eunda, va ina Jerepat, Saidon ele valɨvaŋga, iye ma Isirel wevoniye. ");
INSERT INTO tgo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na gharɨgharɨ lemoyo va inanji Isirel, thɨ ghataŋa lepelo, Loi ghalɨŋae gharautu, Ilaisa ghambaŋa e tɨne, ko iyemaeŋge Ilaisa mava i thawari mun regha, vambe i thawari eŋge Naaman rara Siriya.” ");
INSERT INTO tgo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mbaŋa gharɨgharɨko e ŋgolo kururuko tɨne thɨ loŋwe iyako, gharenji i gaithɨ laghɨye moli. ");
INSERT INTO tgo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Thɨ rakayondo, thɨ lawe Jisas e nɨmanji na thɨ vaŋguiteta ghembako. Thɨ yovaŋgu e ou vwatae, iyava thɨ vatada ghembakowe. Lenji renuwaŋa va thɨŋa eŋge ne thɨ du na i yonjoŋa ouko ghadidiye. ");
INSERT INTO tgo_vpl VAL