﻿USE sofia;
DROP TABLE IF EXISTS sofia.tglulb_vpl;
CREATE TABLE tglulb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tglulb_vpl WRITE;
INSERT INTO tglulb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Noong simula nilikha ng Diyos ang langit at ang lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ang lupa ay walang anyo at walang laman. Ang kadiliman ay nasa ibabaw ng kalaliman. Ang Espiritu ng Diyos ay kumikilos sa ibabaw ng katubigan. ");
INSERT INTO tglulb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Sinabi ng Diyos, ''Magkaroon ng liwanag” at nagkaroon ng liwanag. ");
INSERT INTO tglulb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nakita ng Diyos na ang liwanag ay kaaya-aya. Hiniwalay niya ang liwanag mula sa kadiliman. ");
INSERT INTO tglulb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tinawag ng Diyos ang liwanag na “araw,” at ang kadiliman ay tinawag niyang “gabi”. Naggabi at nag-umaga, ito ang unang araw. ");
INSERT INTO tglulb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Sinabi ng Diyos, “Magkaroon ng puwang sa pagitan ng mga tubig, at hayaang ihiwalay nito ang tubig mula sa tubig.” ");
INSERT INTO tglulb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ginawa ng Diyos ang puwang at hiniwalay niya ang tubig na nasa silong ng kalawakan mula sa tubig na nasa ibabaw ng kalawakan. At nagkagayon nga. ");
INSERT INTO tglulb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Tinawag ng Diyos ang puwang na “langit.” Naggabi at nag-umaga, ito ang ikalawang araw. ");
INSERT INTO tglulb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Sinabi ng Diyos, “Hayaang ang katubigang nasa ilalim ng langit ay sama-samang magtipon sa isang lugar, at hayaang lumitaw ang tuyong lupain.” At nagkagayon nga. ");
INSERT INTO tglulb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tinawag ng Diyos ang tuyong lupain na “lupa” at ang natipong tubig ay tinawag niyang “dagat.” Nakita niyang ito ay kaaya-aya. ");
INSERT INTO tglulb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Sinabi ng Diyos, “Hayaang tumubo ang halaman sa lupa: mga pananim na nagbibigay ng buto at mga namumungang punong kahoy na kung saan ang buto nito'y nasa loob ng kanyang bunga, ayon sa kanyang sariling uri.” At nagkagayon nga. ");
INSERT INTO tglulb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tinubuan ng halaman ang lupa, mga pananim na nagbibigay ng buto mula sa kanilang uri, at mga namumungang punong kahoy na taglay nito ang buto, mula sa kanilang uri. Nakita ng Diyos na ito ay kaaya-aya. ");
INSERT INTO tglulb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Naggabi at nag-umaga, ito ang ikatlong araw. ");
INSERT INTO tglulb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Sinabi ng Diyos, “Hayaang magkaroon ng mga liwanag sa langit upang ihiwalay ang araw mula sa gabi. At hayaan silang maging mga palatandaan, para sa mga panahon, para sa mga araw at sa mga taon. ");
INSERT INTO tglulb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Hayaan silang maging mga liwanag sa langit upang magbigay liwanag sa ibabaw ng mundo.” At nagkagayon nga. ");
INSERT INTO tglulb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ginawa ng Diyos ang dalawang malaking mga liwanag, ang mas malaking liwanag upang pamunuan ang araw, at ang mas maliit na liwanag upang pamunuan ang gabi. Ginawa rin niya ang mga bituin. ");
INSERT INTO tglulb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Inilagay sila ng Diyos sa langit upang magbigay liwanag sa ibabaw ng mundo, ");
INSERT INTO tglulb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","upang pamunuan ang buong araw at ang buong gabi, at upang ihiwalay ang liwanag sa kadiliman. Nakita ng Diyos na ito ay kaaya-aya. ");
INSERT INTO tglulb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Naggabi at nag-umaga, ito ang ikaapat na araw. ");
INSERT INTO tglulb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Sinabi ng Diyos, “Hayaang mapuno ang katubigan ng lahat ng uri ng buhay na nilalang na ginawa ko, mapuno ang himpapawid ng mga ibong lumilipad sa ibabaw ng lupa. ” ");
INSERT INTO tglulb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kaya’t nilikha ng Diyos ang malalaking nilalang na naninirahan sa dagat, gayon din ang bawat buhay na nilikha ayon sa kanyang uri, mga nilalang na kumikilos at nagkukumpol sa katubigan, at bawat mga ibong may pakpak ayon sa kanyang uri. Nakita ng Diyos na ito ay kaaya-aya. ");
INSERT INTO tglulb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Pinagpala sila ng Diyos, sinasabing, “Maging mabunga kayo at magpakarami, punuin niyo ang katubigan sa mga dagat. Hayaang dumami ang mga ibon sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Naggabi at nag-umaga, ito ang ikalimang araw. ");
INSERT INTO tglulb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Sinabi ng Diyos, “Hayaang magdulot ang mundo ng buhay na mga nilalang, bawat isa ayon sa kanyang sariling uri, mga hayop, mga gumagapang na bagay, at mga mababangis na hayop ng mundo, bawat isa nito ayon sa kanyang sariling uri”. Nagkagayon nga. ");
INSERT INTO tglulb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ginawa ng Diyos ang mga mababangis na hayop sa mundo ayon sa kanilang uri, ang mga hayop ayon sa kanilang mga uri, at lahat ng bagay na gumagapang sa ibabaw ng lupa ayon sa kanyang uri. Nakita niya na ito ay kaaya-aya. ");
INSERT INTO tglulb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Sinabi ng Diyos, “Gawin natin ang tao ayon sa ating wangis, ayon sa ating larawan. Hayaan silang mamahala sa isda sa dagat, sa mga ibon sa langit, sa mga hayop, sa buong mundo, at sa lahat ng gumagapang na bagay na gumagapang sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nilikha ng Diyos ang tao ayon sa kanyang sariling wangis. Ayon sa kanyang wangis nilikha niya siya. Lalaki at babae nilikha niya sila. ");
INSERT INTO tglulb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Pinagpala sila ng Diyos at sinabihan silang, “Maging mabunga kayo, at magpakarami. Punuin niyo ang mundo, at supilin ito. Maging tagapamahala kayo sa isda sa dagat, sa mga ibon sa langit, at sa lahat ng buhay na bagay na kumikilos sa ibabaw ng mundo.” ");
INSERT INTO tglulb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Sinabi ng Diyos, “Tingnan ninyo, ibinigay ko sa inyo ang bawat pananim na nagbibigay ng buto na nasa ibabaw ng buong mundo, at bawat punong-kahoy kasama ang bungang may buto sa loob nito. Sila ay magiging pagkain ninyo. ");
INSERT INTO tglulb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Sa bawa't hayop sa mundo, sa bawat ibon sa kalangitan, at sa lahat ng bagay na gumagapang sa ibabaw ng mundo, at sa bawat nilikhang may hininga ng buhay ibinigay ko ang bawat luntiang halaman para maging pagkain.” At nagkagayon nga. ");
INSERT INTO tglulb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nakita ng Diyos ang lahat ng bagay na kanyang ginawa. Pagmasdan, ito ay napakabuti. Naggabi at nag-umaga, ito ang ika anim araw. ");
INSERT INTO tglulb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kaya’t ang kalangitan at ang mundo ay natapos, at ang lahat ng buhay na mga bagay na pumuno sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Sa ikapitong araw dumating ang Diyos sa pagtatapos ng gawain na kanyang ginawa, at siya ay nagpahinga sa ikapitong araw mula sa lahat niyang gawain. ");
INSERT INTO tglulb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Pinagpala ng Diyos ang ikapitong araw at ginawang banal ito, dahil doon siya nagpahinga mula sa lahat ng gawain na kanyang nagawa sa kanyang paglikha. ");
INSERT INTO tglulb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","to ang mga kaganapan ukol sa kalangitan at sa mundo, nang sila ay nilikha, sa araw na ginawa ni Yahweh na Diyos ang lupa at ang kalangitan. ");
INSERT INTO tglulb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Wala pang halamang bukid ang nasa mundo, at wala pang pananim ng bukid ang tumutubo, sapagkat hindi pa dinulot ni Yahweh na Diyos na umulan sa ibabaw ng mundo, at walang taong bubungkal ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pero umakyat ang hamog mula sa mundo at diniligan ang buong ibabaw ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Si Yahweh na Diyos ay ginawa ang tao mula sa alabok ng lupa, at hiningahan ang mga butas ng kanyang ilong ng hininga ng buhay, at ang tao ay naging buhay na nilalang. ");
INSERT INTO tglulb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nagtanim si Yahweh na Diyos ng isang hardin pasilangan, sa Eden, at doon niya inilagay ang taong kanyang nilikha. ");
INSERT INTO tglulb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mula sa lupa Pinatubo ni Yahweh na Diyos ang bawat punong kaaya-aya sa paningin at mabuti para sa pagkain. Kasama rito ang puno ng buhay na nasa gitna ng hardin, at ang puno ng kaalaman ng mabuti at masama. ");
INSERT INTO tglulb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Lumabas ang isang ilog sa Eden para diligan ang hardin. Mula roon ito ay nahati at naging apat na ilog. ");
INSERT INTO tglulb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ang pangalan ng unang ilog ay Pishon. Iyon ang umaagos sa buong lupain ng Havila, kung saan mayroong ginto. ");
INSERT INTO tglulb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ang ginto sa lupang iyon ay mabuti. Mayroon ding bedelio at ang batong onise. ");
INSERT INTO tglulb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ang pangalan ng pangalawang ilog ay Gihon. Ang isang ito ay umaagos sa buong lupain ng Cush. ");
INSERT INTO tglulb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ang pangalan ng pangatlong ilog ay Tigris, na umaagos sa silangan ng Asshur. Ang pang-apat na ilog ay ang Eufrates. ");
INSERT INTO tglulb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kinuha ni Yahweh na Diyos ang lalaki at inilagay siya sa hardin ng Eden upang trabahuin at alagaan ito. ");
INSERT INTO tglulb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Inutusan ni Yahweh na Diyos ang lalaki, sinasabing, “Mula sa bawat puno sa hardin ay malaya kang makakakain. ");
INSERT INTO tglulb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Pero mula sa puno ng kaalaman ng mabuti at masama ay hindi ka maaaring kumain, sapagkat sa araw na kumain ka mula roon, ikaw ay tiyak na mamamatay.” ");
INSERT INTO tglulb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Pagkatapos sinabi ni Yahweh na Diyos, “Hindi mabuti na ang lalaki ay nag-iisa. Gagawa ako ng katuwang na babagay para sa kanya.” ");
INSERT INTO tglulb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Mula sa lupa ginawa ni Yahweh na Diyos ang bawat hayop sa bukid at bawat ibon sa langit. Pagkatapos dinala niya sila sa lalaki upang makita kung ano ang itatawag niya sa kanila. Anuman ang itinawag ng lalaki sa bawat buhay na nilikha, iyon ang kanyang pangalan. ");
INSERT INTO tglulb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ang lalaki ay nagbigay ng mga pangalan para sa lahat ng mga hayop, sa lahat ng mga ibon sa langit, at sa bawat mabangis na hayop sa bukid. Pero para sa lalaki mismo ay walang nahanap na katuwang na babagay para sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Dinulot ni Yahweh na Diyos na makatulog nang mahimbing ang lalaki, kaya nakatulog ang lalaki. Kumuha si Yahweh na Diyos ng isa sa kanyang mga tadyang at isinara ang laman kung saan niya kinuha ang tadyang. ");
INSERT INTO tglulb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Sa pamamagitan ng tadyang na kinuha ni Yahweh na Diyos mula sa lalaki, ginawa niya ang babae at dinala siya sa lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Sinabi ng lalaki, “Sa oras na ito, ito ang buto ng aking mga buto, at laman ng aking laman. Tatawagin siyang 'babae', dahil kinuha siya sa lalaki.” ");
INSERT INTO tglulb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kaya iiwan ng lalaki ang kanyang ama at ang kanyang ina, makikipag-isa siya sa kanyang asawa, at sila ay magiging isang laman. ");
INSERT INTO tglulb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Kapwa sila hubad, ang lalaki at ang kanyang asawa, pero hindi sila nahihiya. ");
INSERT INTO tglulb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ngayon ang ahas ay higit na tuso kaysa sa anumang ibang mabangis na hayop sa bukid na ginawa ni Yahweh na Diyos. Sinabi niya sa babae, “Talaga bang sinabi ng Diyos, “Hindi kayo dapat kumain mula sa anumang puno ng hardin?” ");
INSERT INTO tglulb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Sinabi ng babae sa ahas, “Maaari naming kainin ang bunga mula sa mga puno ng hardin, ");
INSERT INTO tglulb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","pero tungkol sa bunga ng puno na nasa gitna ng hardin, sinabi ng Diyos, “Hindi ninyo maaaring kainin ito, ni hindi ninyo ito maaaring hawakan, o mamamatay kayo.'” ");
INSERT INTO tglulb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Sinabi ng ahas sa babae, “Tiyak na hindi kayo mamamatay. ");
INSERT INTO tglulb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Dahil alam ng Diyos na sa araw na kainin ninyo ito mabubuksan ang inyong mga mata, at kayo ay magiging tulad ng Diyos, na nakaaalam ng mabuti at masama.” ");
INSERT INTO tglulb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","At nang nakita ng babae na ang puno ay mabuti para sa pagkain at kaaya-aya sa paningin, at ang puno ay kanais-nais para gawing matalino ang isang tao, kumuha siya ng bunga nito at kinain ito. At binigyan niya ang kanyang asawa na kasama niya, at kinain niya ito. ");
INSERT INTO tglulb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Parehong nabuksan ang kanilang mga mata, at nalaman nilang sila ay hubad. Pinagsama-sama nilang tinahi ang mga dahon ng igos at gumawa ng mga pantakip para sa kanilang mga sarili. ");
INSERT INTO tglulb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Narinig nila ang tunog ni Yahweh na Diyos na naglalakad sa hardin sa kalamigan ng araw, kaya ang lalaki at ang kanyang asawa ay nagtago mula sa presensya ni Yahweh na Diyos sa mga punong-kahoy ng hardin. ");
INSERT INTO tglulb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tinawag ni Yahweh na Diyos ang lalaki at sinabi sa kanya, “Nasaan ka?” ");
INSERT INTO tglulb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Sinabi ng lalaki, “Narinig kita sa hardin, at natakot ako, dahil ako ay hubad. Kaya itinago ko ang aking sarili.” ");
INSERT INTO tglulb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Sinabi ng Diyos, “Sinong nagsabi sa iyo na ikaw ay hubad? Kumain ka ba mula sa punong iniutos kong huwag mong kakainan?” ");
INSERT INTO tglulb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Sinabi ng lalaki, “Ang babae na ibinigay mo sa akin, binigyan niya ako ng bunga mula sa puno at kinain ko ito.” ");
INSERT INTO tglulb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Sinabi ni Yahweh na Diyos sa babae, “Ano ba itong ginawa mo?” Sinabi ng babae, “Nilinlang ako ng ahas, at kumain ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Sinabi ni Yahweh na Diyos sa ahas, “Dahil ginawa mo ito, sumpain ka sa lahat ng mga hayop at sa lahat ng mababangis na hayop sa bukid. Gagapang ka sa pamamagitan ng iyong tiyan at alikabok ang iyong kakainin sa lahat ng araw ng iyong buhay. ");
INSERT INTO tglulb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Maglalagay ako ng poot sa pagitan mo at ng babae, at sa pagitan ng iyong binhi at ng kanyang binhi. Dudurugin niya ang iyong ulo, at tutuklawin mo ang kanyang sakong.” ");
INSERT INTO tglulb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Sinabi niya sa babae, “Higit kong patitindihin ang sakit mo sa panganganak; sa sakit ka magsisilang ng mga anak. Ang iyong pagnanais ay para sa iyong asawa, subalit pamumunuan ka niya.” ");
INSERT INTO tglulb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Sinabi niya kay Adan, “Dahil nakinig ka sa boses ng iyong asawa, at kumain mula sa puno, kung alin ay iniutos ko sa iyo, nang sinabi kong, “Hindi kayo maaaring kumain mula rito,' sinumpa ang lupa dahil sa iyo; sa matinding pagpapagal kakain ka mula rito sa lahat ng mga araw ng iyong buhay. ");
INSERT INTO tglulb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ito ay tutubuan ng mga tinik at mga damo para sa iyo, at kakainin mo ang mga pananim sa bukid. ");
INSERT INTO tglulb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kakain ka ng tinapay sa pamamagitan ng pawis ng iyong mukha, hanggang ikaw ay bumalik sa lupa, dahil kinuha ka mula rito. Dahil ikaw ay alikabok, at sa alikabok ka rin babalik.” ");
INSERT INTO tglulb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tinawag ng lalaki ang kanyang asawa sa pangalang Eva dahil siya ang ina ng lahat ng mga nabubuhay. ");
INSERT INTO tglulb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Gumawa si Yahweh na Diyos ng mga kasuotang balat para kay Adan at para sa kanyang asawa at dinamitan sila. ");
INSERT INTO tglulb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Sinabi ni Yahweh na Diyos, “Ngayon ang tao ay naging tulad na natin, na nakaaaalam ng mabuti at masama. Ngayon hindi siya dapat pahintulutang abutin ng kanyang kamay, at kumuha mula sa puno ng buhay at kumain nito, at mabuhay nang walang hanggan.” ");
INSERT INTO tglulb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kaya pinalabas sila ni Yahweh na Diyos mula sa hardin ng Eden, para bungkalin ang lupa kung saan siya kinuha. ");
INSERT INTO tglulb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kaya pinalabas ng Diyos ang lalaki mula sa hardin, at nilagay niya ang querubin sa silangan ng hardin ng Eden, at isang nagliliyab na espada na umiikot sa bawat panig, upang bantayan ang daan patungo sa puno ng buhay. ");
INSERT INTO tglulb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ang lalaki ay sumiping sa kanyang asawang si Eva. Siya ay nabuntis at isinilang niya si Cain. Sinabi niya, “Nagkaroon ako ng lalaki sa tulong ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Pagkatapos ay isinilang niya ang lalaking kapatid nitong si Abel. Naging pastol si Abel, pero si Cain ay nagbungkal ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","At nangyari na sa paglipas ng panahon dinala ni Cain ang ilan sa bunga ng lupa bilang handog kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Si Abel naman ay nagdala ng ilan sa panganay ng kanyang kawan at ilan sa taba. Tinanggap ni Yahweh si Abel at ang kanyang handog, ");
INSERT INTO tglulb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","pero hindi niya tinanggap si Cain at ang kanyang handog. Kaya lubhang nagalit si Cain, at sumimangot siya. ");
INSERT INTO tglulb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Sinabi ni Yahweh kay Cain, “Bakit ka nagagalit at bakit ka sumisimangot? ");
INSERT INTO tglulb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kung gagawin mo ang tama, hindi ka ba tatanggapin? Pero kung hindi mo ginagawa ang tama, ang kasalanan ay nag-aabang sa pinto at ninanais na mamahala sa iyo, subalit dapat mo itong pamunuan.” ");
INSERT INTO tglulb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kinausap ni Cain si Abel na kanyang kapatid. At nangyari na habang sila ay nasa bukid, tumindig si Cain laban sa kanyang kapatid na si Abel at pinatay niya ito. ");
INSERT INTO tglulb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Pagkatapos sinabi ni Yahweh kay Cain, “Nasaan ang iyong kapatid na si Abel?” Sinabi niya, “Hindi ko alam. Tagapangalaga ba ako ng aking kapatid?” ");
INSERT INTO tglulb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Sinabi ni Yahweh, “Ano ang ginawa mo? Tumatawag sa akin ang dugo ng iyong kapatid mula sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ngayon isinumpa ka mula sa lupa, na nagbukas ng bunganga nito upang tanggapin ang dugo ng iyong kapatid mula sa iyong kamay. ");
INSERT INTO tglulb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kapag ikaw ay magbubungkal ng lupa, mula ngayon hindi na nito isusuko sa iyo ang kanyang lakas. Magiging palaboy at pagala-gala ka sa mundo.” ");
INSERT INTO tglulb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Sinabi ni Cain kay Yahweh, “Ang parusa ko ay higit kaysa sa aking makakaya. ");
INSERT INTO tglulb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Sa katunayan, itinaboy mo ako sa araw na ito mula sa lupang ito, at ako ay itatago mula sa iyong mukha. Magiging palaboy ako at pagala-gala sa mundo, at kung sinuman ang makasusumpong sa akin ay papatayin ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Sinabi ni Yahweh sa kanya, “Kung sinuman ang papatay kay Cain, makapitong beses siyang gagantihan.” Kaya nilagyan ni Yahweh ng palatandaan si Cain upang sinumang makasumpong sa kanya, hindi siya lulusubin ng taong iyon. ");
INSERT INTO tglulb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaya umalis si Cain mula sa presensya ni Yahweh at nanirahan sa lupain ng Nod, sa silangan ng Eden. ");
INSERT INTO tglulb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Sinipingan ni Cain ang kanyang asawa at nabuntis ito. Isinilang niya si Enoc. Nagtatag siya ng isang lungsod at pinangalanan niya ito sunod sa kanyang anak na si Enoc. ");
INSERT INTO tglulb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kay Enoc isinilang si Irad. Si Irad ang naging ama ni Mehujael. Si Mehujael ang naging ama ni Metusael. Si Metusael ang naging ama ni Lamec. ");
INSERT INTO tglulb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Si Lamec ay kumuha ng dalawang asawa para sa kanyang sarili: ang pangalan ng isa ay si Ada, at ang pangalan ng isa pa ay si Zilla. ");
INSERT INTO tglulb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Isinilang ni Ada si Jabal. Siya ay ama ng lahat ng nakatira sa mga tolda na may mga alagang hayop. ");
INSERT INTO tglulb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ang pangalan ng kanyang kapatid na lalaki ay Jubal. Siya ang ama ng lahat ng mga manunugtog ng alpa at plauta. ");
INSERT INTO tglulb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Si Zilla naman, naging anak niya si Tubal Cain, ang nagpapanday ng mga kagamitang tanso at bakal. Ang babaeng kapatid ni Tubal Cain ay si Naama. ");
INSERT INTO tglulb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Sinabi ni Lamec sa kanyang dalawang asawa, “Ada at Zilla dinggin ninyo ang aking tinig; kayong mga asawa ni Lamec, makinig kayo sa sasabihin ko. Nakapatay ako ng isang tao dahil sinugatan ako, isang binata dahil sa pananakit sa akin. ");
INSERT INTO tglulb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kung ipaghihiganti si Cain ng makapitong ulit, sa gayon si Lamec ay ipaghihiganti ng pitumpu't-pitong ulit.” ");
INSERT INTO tglulb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Si Adan ay muling sumiping sa kanyang asawa, at siya ay nagkaanak ng isa pang anak na lalaki. Tinawag niya itong Set at sinabing, “Binigyan muli ako ng Diyos ng anak na lalaki kapalit ni Abel, dahil pinatay siya ni Cain.” ");
INSERT INTO tglulb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Si Set ay nagkaroon ng anak na lalaki at tinawag niya itong Enos. Sa panahong iyon ang mga tao ay nagsimulang tumawag sa pangalan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ito ang talaan ng mga kaapu-apuhan ni Adan. Sa araw na nilikha ng Diyos ang sangkatauhan, ginawa niya sila ayon sa kanyang wangis. ");
INSERT INTO tglulb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Nilikha niya silang lalaki at babae. Pinagpala niya sila at pinangalanan silang sangkatauhan nang sila ay likhain. ");
INSERT INTO tglulb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Nang nabuhay si Adan ng 130 taon, siya ay naging ama ng isang anak na lalaki na ayon sa kanyang sariling wangis, sunod sa kanyang larawan, at pinangalanan niya itong Set. ");
INSERT INTO tglulb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Pagkatapos na si Adan ay naging ama ni Set, nabuhay siya ng walondaang taon. Siya ay naging ama ng higit na marami pang mga anak na lalaki at mga anak babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nabuhay si Adan ng 930 taon, at pagkatapos siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Nang nabuhay si Set ng 105 taon, siya ay naging ama ni Enos. ");
INSERT INTO tglulb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Pagkatapos na siya ay naging ama ni Enos, nabuhay siya ng 807 taon at naging ama ng mas marami pang mga anak na lalaki at mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nabuhay si Set ng 912 taon, at pagkatapos siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Nang nabuhay si Enos ng siyamnapung taon, naging ama siya ni Kenan. ");
INSERT INTO tglulb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Pagkatapos na siya ay naging ama ni Kenan, si Enos ay nabuhay ng 815 taon. Siya ay naging ama ng mas marami pang mga anak na lalaki at mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nabuhay si Enos ng 905 taon, at pagkatapos siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Nang nabuhay si Kenan ng pitumpung taon, siya ay naging ama ni Mahalalel. ");
INSERT INTO tglulb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Pagkatapos na siya ay naging ama ni Mahalalel, nabuhay si Kenan ng 840 taon. Siya ay naging ama ng mas marami pang mga anak na lalaki at mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Nabuhay si Kenan ng 910 taon at pagkatapos siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Nang nabuhay si Mahalalel ng animnapu't limang taon, siya ay naging ama ni Jared. ");
INSERT INTO tglulb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Pagkatapos na siya ay naging ama ni Jared, nabuhay si Mahalalel ng 830 taon. Siya ay naging ama ng mas marami pang mga anak na lalaki at mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Nabuhay si Mahalalel ng 895 taon at pagkatapos siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Nang nabuhay si Jared ng 162 taon, siya ay naging ama ni Enoc. ");
INSERT INTO tglulb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Pagkatapos niyang naging ama ni Enoc, nabuhay si Jared ng walong daang taon. Siya ay naging ama ng mas marami pang mga anak na lalaki at mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Nabuhay si Jared ng 962 taon, at pagkatapos siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Nang nabuhay si Enoc ng animnapu't limang taon, siya ay naging ama ni Metusalem. ");
INSERT INTO tglulb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Lumakad si Enoc na kasama ang Diyos sa tatlong daang taon pagkatapos na siya ay naging ama ni Metusalem. Siya ay naging ama ng mas marami pang mga anak na lalaki at mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Nabuhay si Enoc ng 365 taon. ");
INSERT INTO tglulb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Lumakad si Enoc na kasama ang Diyos, at pagkatapos siya ay nawala, dahil kinuha siya ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Nang nabuhay si Metusalem ng 187 taon, siya ay naging ama ni Lamec. ");
INSERT INTO tglulb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Pagkatapos na siya ay naging ama ni Lamec, nabuhay si Metusalem ng 782 taon. Siya ay naging ama ng mas marami pang mga anak na lalaki at mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Nabuhay si Metusalem ng 969 taon. Pagkatapos siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Nang nabuhay si Lamec ng 182 taon, siya ay naging ama ng isang lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Tinawag niya siya sa pangalang Noe, sinabing, “Ang isang ito ang magbibigay kapahingahan sa atin mula sa ating trabaho at mula sa kapaguran ng ating mga kamay, na dapat nating gawin dahil sa lupang isinumpa ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nabuhay si Lamec ng 595 taon pagkatapos na siya ay naging ama ni Noe. Siya ay naging ama ng mas marami pang mga anak na lalaki at mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Nabuhay si Lamec ng 777 taon. Pagkatapos siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Matapos mabuhay ni Noe ng limandaang taon, siya ay naging ama nina Sem, Ham at Jafet. ");
INSERT INTO tglulb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","At nangyari na nang nagsimulang dumami ang sangkatauhan sa mundo at ang mga anak na babae ay isinilang sa kanila, ");
INSERT INTO tglulb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","na nakita ng mga anak na lalaki ng Diyos na kaakit-akit ang mga anak na babae ng sangkatauhan. Kumuha sila ng mga asawa para sa kanilang sarili, kahit sino sa kanila na mapili nila. ");
INSERT INTO tglulb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Sinabi ni Yahweh, “Ang aking espiritu ay hindi mananatili sa sangkatauhan magpakailanman, sapagkat sila ay laman. Mabubuhay sila ng 120 taon.” ");
INSERT INTO tglulb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Nasa mundo ang mga higante noong mga araw na iyon, at ganun din pagkatapos. Ito ay nangyari nang pinakasalan ng mga anak na lalaki ng Diyos ang mga anak na babae ng tao, at nagkaroon sila ng mga anak sa kanila. Ito ang mga malalakas na tao noong unang panahon, at mga lalaking kilala. ");
INSERT INTO tglulb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nakita ni Yahweh ang labis na kasamaan ng sangkatauhan sa mundo, at ang bawat pagkahilig ng kanilang puso ay patuloy na kasamaan lamang. ");
INSERT INTO tglulb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Nalungkot si Yahweh na ginawa niya ang sangkatauhan sa mundo, at ito ay nagdulot ng dalamhati sa kanyang puso. ");
INSERT INTO tglulb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kaya sinabi ni Yahweh, “Lilipulin ko ang sangkatauhang nilikha ko mula sa ibabaw ng mundo; kapwa ang sangkatauhan at ang higit na malalaking mga hayop, at gumagapang na mga bagay sa lupa at mga ibon sa kalangitan, dahil pinagsisihan kong ginawa ko sila.” ");
INSERT INTO tglulb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero nakasumpong si Noe ng pagtatangi sa mata ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ito ang mga pangyayari patungkol kay Noe. Matuwid, at walang kapintasan si Noe sa gitna ng mga tao sa kanyang kapanahunan. Lumakad si Noe kasama ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Naging ama siya ng tatlong mga anak na lalaki: Sem, Ham at Jafet. ");
INSERT INTO tglulb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ang mundo ay masama sa harapan ng Diyos, at ito'y puno ng karahasan. ");
INSERT INTO tglulb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nakita ng Diyos ang mundo; masdan, ito ay masama, dahil lahat ng laman ay pinasama ang kanilang gawi sa ibabaw ng mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Sinabi ng Diyos kay Noe, “Nakikita kong panahon na upang bigyang wakas ang lahat ng laman, sapagkat napuno na ng karahasan ang mundo sa pamamagitan nila. Katunayan, wawasakin ko sila kasama ng mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Gumawa ka para sa iyong sarili ng arka mula sa kahoy ng saypres. Gumawa ka ng mga silid sa arka, takpan mo ito ng aspalto sa loob at labas. ");
INSERT INTO tglulb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ganito mo ito gagawin: tatlong daang kubit ang haba ng arka, limampung kubit ang luwag nito, at tatlumpung kubit ang taas nito. ");
INSERT INTO tglulb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gumawa ka ng bubong para sa arka, at tapusin mo ito sa isang kubit mula sa itaas ng tagiliran. Maglagay ka ng pinto sa gilid ng arka at gumawa ka ng ilalim, pangalawa, at pangatlong palapag. ");
INSERT INTO tglulb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Makinig ka, malapit ko nang ipadala ang baha ng mga tubig sa mundo, upang lipulin ang lahat ng laman na may hininga ng buhay dito mula sa silong ng langit. Lahat ng bagay na nasa mundo ay mamamatay. ");
INSERT INTO tglulb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Subalit itatatag ko ang aking tipan sa iyo. Papasok ka sa arka, ikaw, at ang iyong mga anak na lalaki, iyong asawa at mga asawa ng iyong mga anak. ");
INSERT INTO tglulb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mula sa bawat nabubuhay na nilalang ng lahat ng laman, dalawa ng bawat uri ang dapat mong dalhin sa arka, upang mananatili silang buhay kasama mo, kapwa lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mga ibon ayon sa kanilang uri, at ang mga malalaking hayop ayon sa kanilang uri, bawat gumagapang na bagay sa lupa ayon sa kanyang uri, dalawa ng bawat uri ay pupunta sa iyo, upang panatilihin silang buhay. ");
INSERT INTO tglulb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tipunin mo para sa sarili mo ang bawat uri ng pagkaing makakain at itabi ito, para maging pagkain para sa iyo at sa kanila.” ");
INSERT INTO tglulb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kaya ginawa ito ni Noe. Ginawa niya ito, ayon sa lahat ng inutos ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Sinabi ni Yahweh kay Noe, “Halika, ikaw at lahat ng iyong sambahayan sa arka, sapagkat sa salinlahing ito nakita ko na ikaw ay matuwid sa aking harapan. ");
INSERT INTO tglulb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Sa bawat malinis na hayop magdala ka ng pitong lalaki at pitong babae. At sa mga hayop na hindi malinis, magdala ka ng dalawa, ang lalaki at kanyang kapares. ");
INSERT INTO tglulb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Gayundin ang mga ibon sa kalangitan, magdala ka ng pitong lalaki at pitong babae, upang mapanatili ang kanilang mga supling sa ibabaw ng buong mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pagkalipas ng pitong araw idudulot kong umulan sa mundo sa loob ng apatnapung araw at apatnapung gabi. Lilipulin ko mula sa ibabaw ng lupa ang bawat buhay na nilalang na aking ginawa.” ");
INSERT INTO tglulb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ginawa ni Noe ang lahat ng iniutos ni Yahweh sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Si Noe ay anim na raang taong gulang nang dumating ang baha sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Si Noe, ang kanyang mga anak na lalaki, ang kanyang asawa, at ang mga asawa ng kanyang mga anak na lalaki ay sama-samang pumasok sa arka dahil sa mga tubig ng baha. ");
INSERT INTO tglulb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ang mga malinis at hindi malinis na mga hayop, mga ibon, at lahat ng mga gumagapang sa lupa, ");
INSERT INTO tglulb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","dala-dalawa, lalaki at babae, ang pumunta kay Noe at pumasok sa arka, ayon sa iniutos ng Diyos kay Noe. ");
INSERT INTO tglulb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Nangyari na matapos ang pitong araw, dumating ang tubig ng baha sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Sa ika-anim na raang taon ng buhay ni Noe, sa pangalawang buwan sa ikalabimpitong araw ng buwan, sa parehong araw, ang lahat ng mga bukal ng kailaliman ay sumambulat, at ang mga bintana ng langit ay nabuksan. ");
INSERT INTO tglulb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nagsimulang umulan sa mundo sa loob ng apatnapung araw at apatnapung gabi. ");
INSERT INTO tglulb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Sa araw ding iyon si Noe at ang kanyang mga anak na lalaki, na sina Sem, Ham, at Jafet, at ang asawa ni Noe, at ang tatlong asawa ng kanyang mga anak na lalaki ay kasama niyang pumasok sa arka. ");
INSERT INTO tglulb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Pumasok sila kasama ang bawat mababangis na hayop ayon sa kanilang uri, at bawat klase ng alagang mga hayop ayon sa kanilang uri, at bawat gumagapang na bagay na gumagapang sa mundo ayon sa kanilang uri, at bawat klase ng ibon ayon sa kanilang uri, bawat uri ng nilikha na may mga pakpak. ");
INSERT INTO tglulb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Dalawa sa lahat ng laman na may hininga ng buhay ay pumunta kay Noe at pumasok sa arka. ");
INSERT INTO tglulb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ang mga hayop na pumasok ay lalaki at babae ng lahat ng laman; pumasok sila gaya ng iniutos ng Diyos sa kanya. Pagkatapos isinara ni Yahweh ang pintuan sa likod nila. ");
INSERT INTO tglulb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Pagkatapos dumating ang baha sa mundo sa loob ng apatnapung araw, at tumaas ang tubig at binuhat ang arka. Umangat ito mula sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Rumagasa ang tubig at lubhang tumaas sa mundo, at lumutang ang arka sa ibabaw ng tubig. ");
INSERT INTO tglulb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ang tubig ay buong lakas na tumaas nang tumaas sa mundo. Tinakpan nilang tuluyan ang lahat ng matataas na mga bundok na nasa silong ng buong langit. ");
INSERT INTO tglulb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tumaas ang mga tubig ng labinlimang kubit sa ibabaw ng mga tuktok ng mga bundok. ");
INSERT INTO tglulb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Namatay ang lahat ng mga nabubuhay na nilalang na gumagalaw sa ibabaw ng mundo: ang mga ibon, ang mga alagang hayop, ang mga mababangis na hayop, lahat ng nagkukumpol na mga nilikha na nagkumpol sa ibabaw ng mundo, at lahat ng sangkatauhan. ");
INSERT INTO tglulb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Lahat ng nilalang na may hininga nang espiritu ng buhay sa kanilang ilong, lahat ng nasa tuyong lupa, nangamatay. ");
INSERT INTO tglulb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kaya bawat buhay na bagay na nasa ibabaw ng mundo ay nalipol, mula sa sangkatauhan hanggang sa malalaking mga hayop, mga gumagapang na mga bagay, at mga ibon sa himpapawid. Nawasak silang lahat mula sa mundo. Tanging si Noe at ang kanyang mga kasama sa arka ang natira. ");
INSERT INTO tglulb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nangibabaw ang tubig sa mundo sa loob ng isandaan at limampung araw. ");
INSERT INTO tglulb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Isinaalang-alang ng Diyos si Noe, lahat ng mga mababangis na hayop, at lahat ng alagang mga hayop na kasama niya sa arka. Ginawa ng Diyos na umihip ang isang hangin sa ibabaw ng mundo, at nagsimulang humupa ang tubig. ");
INSERT INTO tglulb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ang mga bukal sa ilalim at ang mga bintana ng langit ay nagsara, at tumigil ang pag-ulan. ");
INSERT INTO tglulb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ang mga tubig baha ay nagpatuloy na humupa mula sa mundo. At pagkalipas ng isandaan at limampung araw, ang tubig ay lubhang nabawasan. ");
INSERT INTO tglulb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Sumadsad ang arka sa ikapitong buwan, sa ikalabimpitong araw ng buwan, sa ibabaw ng mga bundok ng Ararat. ");
INSERT INTO tglulb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ang tubig ay nagpatuloy na humupa hanggang sa ikasampung buwan. Sa unang araw ng buwan, ang mga tuktok ng mga bundok ay lumitaw. ");
INSERT INTO tglulb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","At nangyari pagkaraan ng apatnapung araw na binuksan ni Noe ang bintana ng arka na kanyang ginawa. ");
INSERT INTO tglulb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Nagpalipad siya ng isang uwak at ito ay nagparoo't nagparito hanggang sa natuyo ang tubig mula sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Pagkatapos ay nagpalipad siya ng isang kalapati upang tingnan kung ang tubig ay humupa na mula sa ibabaw ng lupa, ");
INSERT INTO tglulb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","pero ang kalapati ay walang nakitang lugar upang ipahinga ang kanyang paa, at bumalik ito sa kanya sa arka, dahil natatakpan pa rin ng tubig ang buong mundo. Iniabot niya ng kanyang kamay, at kinuha at dinala niya ito kasama niya sa arka. ");
INSERT INTO tglulb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Naghintay siya ng pito pang mga araw at pinalipad niyang muli ang kalapati mula sa arka. ");
INSERT INTO tglulb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Bumalik ang kalapati sa kanya kinagabihan. Masdan! Sa kanyang bibig ay may sariwang pitas ng dahon ng olibo. Kaya nalaman ni Noe na ang tubig ay humupa mula sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Naghintay siya ng pito pang araw, at pinalipad niyang muli ang kalapati. Hindi na ito muling bumalik sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nangyari na sa ika-anim na raan at isang taon, sa unang buwan, sa unang araw ng buwan, na natuyo na ang mga tubig mula sa mundo. Inalis ni Noe ang takip ng arka, tumingin sa labas, at masdan, nakita niya ang ibabaw ng lupa ay tuyo na. ");
INSERT INTO tglulb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Sa pangalawang buwan ng ikadalawampu't pitong araw ng buwan, ang mundo ay tuyo na. ");
INSERT INTO tglulb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Sinabi ng Diyos kay Noe, ");
INSERT INTO tglulb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Lumabas ka sa arka, ikaw, ang iyong asawa, ang iyong mga anak na lalaki, at ang mga asawa ng iyong mga anak na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Dalhin mo palabas ang bawat buhay na nilalang ng lahat ng laman na kasama mo, pati na ang mga ibon, ang mga alagang hayop, at ang bawat gumagapang na bagay na gumagapang sa ibabaw ng mundo, upang sila ay lumaganap sa buong mundo, maging mabunga, at magpakarami sa mundo.” ");
INSERT INTO tglulb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kaya lumabas si Noe kasama ang kanyang mga anak na lalaki, kanyang asawa, at mga asawa ng kanyang mga anak na lalaki na kasama niya. ");
INSERT INTO tglulb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Bawat buhay na nilikha, bawat gumagapang na bagay, at bawat ibon, lahat ng bagay na gumagalaw sa mundo, ayon sa kanilang mga pamilya, ay umalis sa arka. ");
INSERT INTO tglulb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Gumawa ng altar si Noe para kay Yahweh. Kumuha siya ng ilang malinis na hayop at ilang malinis na ibon, at naghandog ng handog na susunugin sa altar. ");
INSERT INTO tglulb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Naamoy ni Yahweh ang kaaya-ayang halimuyak at sinabi niya sa kanyang puso, “Hindi ko na muling susumpain ang lupa dahil sa sangkatauhan, kahit na ang ninanais ng kanilang mga puso ay masama mula sa pagkabata. Ni muli kong wawasakin ang lahat ng may buhay, tulad nang ginawa ko. ");
INSERT INTO tglulb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Habang ang mundo ay nananatili, ang panahon ng pagtatanim at pag-aani, lamig at init, tag-araw at tagginaw, at ang araw at gabi ay hindi hihinto.” ");
INSERT INTO tglulb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","At pinagpala ng Diyos si Noe at ang kanyang mga anak na lalaki, at sinabi sa kanila, “Maging mabunga kayo, magpakarami, at punuin ang mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ang takot at ang sindak sa inyo ay mapupunta sa bawat nabubuhay na hayop sa mundo, sa bawat ibon sa langit, sa lahat ng bagay na nasa lupa, at sa lahat ng isda sa karagatan. Ibinigay ko ang mga ito sa inyong kamay. ");
INSERT INTO tglulb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Magiging pagkain para sa inyo ang bawat gumagalaw na bagay na nabubuhay. Tulad nang ibinigay ko sa inyo ang mga luntiang halaman, ngayon ibinigay ko na ang bawat bagay sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Subalit hindi ninyo dapat kainin ang karneng may buhay pa—iyon ay ang dugo nito—na narito. ");
INSERT INTO tglulb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Subalit para sa iyong dugo, ang buhay na nasa iyong dugo, hihingin ko ang kabayaran. Mula sa kamay ng bawat hayop hihingin ko ito. Mula sa kamay ng sinumang tao, iyon ay, mula sa kamay na pumatay ng kanyang kapatid, aking hihingin ang pagsusulit sa buhay ng taong ito. ");
INSERT INTO tglulb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Sinuman ang magpapadanak ng dugo ng tao, sa pamamagitan ng tao dadanak ang dugo niya, sapagkat ayon sa wangis ng Diyos ay nilalang niya ang tao. ");
INSERT INTO tglulb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Para sa inyo, maging mabunga kayo at magpakarami, lumaganap kayo sa buong mundo at magpakarami rito.” ");
INSERT INTO tglulb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","At nakipag-usap ang Diyos kay Noe at sa kanyang mga anak na kasama niya, sinabing, ");
INSERT INTO tglulb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Samantala ako, makinig kayo! Itatatag ko ang kasunduan sa inyo at sa inyong mga kaapu-apuhang susunod sa inyo, ");
INSERT INTO tglulb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","at sa bawat nabubuhay na nilalang na kasama ninyo, pati mga ibon at mga alagang hayop, at bawat nilalang sa mundo na kasama ninyo, mula sa lahat ng lumabas sa arka, hanggang sa bawat nabubuhay na nilalang sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Sa pamamagitan nito itinatatag ko ang aking kasunduan sa inyo, na hindi na kailanman ang lahat ng laman ay muling mawawasak sa pamamagitan ng tubig baha. Hindi na kailanman muling magkakaroon ng bahang sisira sa mundo.” ");
INSERT INTO tglulb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Sinabi ng Diyos, “Ito ang palatandaan ng kasunduang aking gagawin sa pagitan ko at ninyo at sa bawat nabubuhay na nilalang na kasama ninyo, sa lahat ng hinaharap na salinlahi: ");
INSERT INTO tglulb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Inilagay ko ang aking bahaghari sa ulap, at ito ang palatandaan ng kasunduan sa pagitan ko at ng mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ito ay mangyayari kapag dinadala ko ang ulap sa ibabaw ng mundo at ang bahaghari ay natatanaw sa ulap, ");
INSERT INTO tglulb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","sa gayon isasaisip ko ang aking kasunduan sa pagitan ko at ninyo, at sa bawat nabubuhay na nilalang ng lahat ng laman. Ang mga tubig ay hindi kailanman muling magiging bahang wawasak sa lahat ng laman. ");
INSERT INTO tglulb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ang bahag-hari ay mapapaloob sa mga ulap at makikita ko ito, upang gunitain ang walang hangang kasunduan sa pagitan ng Diyos at bawat nabubuhay na nilalang ng lahat ng laman na nasa mundo.” ");
INSERT INTO tglulb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","At sinabi ng Diyos kay Noe, “Ito ang palatandaan ng aking kasunduan na aking itinatag sa pagitan ko at ng lahat ng laman na nasa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ang mga anak ni Noe na lumabas sa arka ay sina Sem, Ham at Jafet. At si Ham ay ama ni Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ito ang tatlong anak ni Noe, at mula sa mga ito dumami ang tao sa buong mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nagsimulang maging magsasaka si Noe, at nagtanim siya ng ubasan. ");
INSERT INTO tglulb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Uminom siya ng kaunting alak at nalasing. Siya ay nakahigang walang damit sa kanyang tolda. ");
INSERT INTO tglulb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Pagkatapos si Ham, na ama ni Canaan, ay nakita ang kahubaran ng kanyang ama at sinabi ito sa kanyang dalawang kapatid na nasa labas. ");
INSERT INTO tglulb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kaya kumuha si Sem at Jafet ng damit at inilagay ito sa parehong balikat nila, at patalikod na lumakad at tinakpan ang kahubaran ng kanilang ama. Ang kanilang mga mukha ay lumihis sa ibang direksyon, kaya hindi nila nakita ang kahubaran ng kanilang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nang nagising si Noe mula sa kanyang kalasingan, nalaman niya kung ano ang ginawa ng kanyang bunsong anak na lalaki sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Kaya sinabi niya, “Sumpain si Canaan. Maging isang lingkod sana siya sa mga lingkod ng kanyang mga kapatid.” ");
INSERT INTO tglulb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Sinabi rin niya, “Nawa si Yahweh, ang Diyos ni Shem, ay pagpalain at nawa si Canaan ay kanyang maging lingkod. ");
INSERT INTO tglulb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Palawakin nawa ng Diyos si Jafet, at hayaan siyang gumawa ng kanyang tahanan sa mga tolda ni Shem. Maging alipin nawa niya si Canaan.” ");
INSERT INTO tglulb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Matapos ang baha, nabuhay si Noe ng tatlondaan at limampung taon. ");
INSERT INTO tglulb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nabuhay si Noe sa loob ng siyam na raan at limampung taon, at siya ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ito ang mga kaapu-apuhan ng mga anak na lalaki ni Noe, iyon ay, sina Sem, Ham at Jafet. Nagkaanak sila ng mga lalaki pagkatapos ng baha. ");
INSERT INTO tglulb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ang mga anak na lalaki ni Japet ay sina Gomer, Magog, Madai, Javan, Tubal, Meshec at Tiras. ");
INSERT INTO tglulb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ang mga anak na lalaki ni Gomer ay sina Askenaz, Rifat, Togarma. ");
INSERT INTO tglulb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ang mga anak na lalaki ni Jovan ay sina Elisha, Tarsis, Kitim at Dodanim. ");
INSERT INTO tglulb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Mula sa mga ito humiwalay ang mga taong taga baybay-dagat at umalis papunta sa kani-kanilang mga lupain, bawat isa ay may sariling wika, ayon sa kanilang mga angkan, ayon sa kanilang mga bansa. ");
INSERT INTO tglulb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ang mga anak na lalaki ni Ham ay sina Cus, Mizraim, Put, at Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ang mga anak na lalaki ni Cus ay sina Seba, Havila, Sabta, Raama at Sabteca. Ang mga anak na lalaki ni Raama ay sina Sheba at Didan. ");
INSERT INTO tglulb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Si Cus ang naging ama ni Nimrod, ang naging kauna-unahang manlulupig sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Siya ay isang mahusay na mangangaso sa harapan ni Yahweh. Kaya ang mga ito'y sinabi, “Tulad ni Nimrod, na mahusay na mangangaso sa harapan ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ang naunang mga sentro ng kanyang kaharian ay ang Babel, Eric, Acad at Calne, sa lupain ng Sinar. ");
INSERT INTO tglulb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mula sa lupaing iyon siya ay pumunta sa Asiria at tinatag ang Nineve, Rehoboth Ir, Cale, ");
INSERT INTO tglulb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","at Resen, na nasa pagitan ng Nineve at Cale. Ito ay malaking lungsod. ");
INSERT INTO tglulb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Si Mizraim ang naging ama ng mga Ludites, mga Anamites, mga Lehabites, mga Napthuhites, ");
INSERT INTO tglulb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ng mga Pathrusites, mga Casluhites (kung kanino nagmula ang mga Filisteo), at mga Caphtorites. ");
INSERT INTO tglulb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Si Canaan ang naging ama ni Sidon, na kanyang panganay, at ni Heth, ");
INSERT INTO tglulb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","gayundin ng mga Jebuseo, ng mga Amoreo, ng mga Gergeseo, ");
INSERT INTO tglulb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ng mga Hivita, ng mga Araceo, ng mga Sineo, ");
INSERT INTO tglulb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ng mga Arvadeo, ng mga Zemareo at ng mga Hamateo. Pagkatapos kumalat ang mga angkan ng mga Cananeo. ");
INSERT INTO tglulb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ang hangganan ng mga Cananeo ay mula sa Sidon, sa direksyon ng Gerar, hanggang sa Gaza, at habang ang isa ay patungong Sodoma, Gomorra, Adma, at Zeboim, hanggang sa Lasha. ");
INSERT INTO tglulb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ito ang mga anak na lalaki ni Ham, ayon sa kanilang mga angkan, ayon sa kanilang mga wika, sa kanilang mga lupain, at sa kanilang mga bansa. ");
INSERT INTO tglulb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Nagkaanak din ng mga lalaki si Sem, ang nakatatandang kapatid na lalaki ni Jafet. Si Sem din ang ninuno ng lahat ng tao sa Eber. ");
INSERT INTO tglulb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ang mga anak na lalaki ni Sem ay sina Elam, Asshur, Arfaxad, Lud, at Aram. ");
INSERT INTO tglulb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ang mga anak na lalaki ni Aram ay sina Uz, Hul, Gether, at Meshec. ");
INSERT INTO tglulb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Si Arfaxad ang naging ama ni Shela, at si Shela ang naging ama ni Eber. ");
INSERT INTO tglulb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Si Eber ay may dalawang anak na lalaki. Ang pangalan ng isa ay Peleg, dahil sa kanyang panahon nahati ang mundo. Ang pangalan ng kanyang lalaking kapatid ay Joktan. ");
INSERT INTO tglulb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Si Joktan ang naging ama nina Almodad, Sheleph, Hazarmavet, Jerah, ");
INSERT INTO tglulb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO tglulb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO tglulb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, at Jobab. Ang lahat ng mga ito ay anak ni Joktan. ");
INSERT INTO tglulb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ang kanilang nasasakupan ay mula sa Mesha, hangang sa Sephar, ang bundok ng Silangan. ");
INSERT INTO tglulb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ito ang mga anak ni Sem, ayon sa kanilang mga angkan at sa kanilang mga wika, sa kanilang mga lupain, ayon sa kanilang mga bansa. ");
INSERT INTO tglulb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ito ang mga angkan ng mga anak na lalaki ni Noe, ayon sa kanilang mga tala ng angkan, ng kanilang mga bansa. Mula sa mga ito nagkahiwalay ang mga bansa at kumalat sa mundo matapos ang baha. ");
INSERT INTO tglulb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ngayon ang buong mundo ay gumagamit ng iisang wika at parehong mga salita. ");
INSERT INTO tglulb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Sa kanilang paglalakbay sa silangan, nakatagpo sila ng isang kapatagan sa lupain ng Shinar at doon sila nanirahan. ");
INSERT INTO tglulb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Sinabi nila sa isa’t isa, “Halikayo, gumawa tayo ng mga laryo at lutuin nating mabuti.” Laryo ang gamit nila sa halip na bato at alkitran bilang semento. ");
INSERT INTO tglulb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Sinabi nila, “Halikayo, magtayo tayo ng isang lungsod at isang tore para sa atin kung saan ang tuktok ay aabot hanggang langit, at gumawa tayo ng pangalan para sa ating mga sarili. Kung hindi natin gagawin ito, magkakawatak-watak tayo sa buong mundo.” ");
INSERT INTO tglulb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kaya bumaba si Yahweh para tingnan ang lungsod at ang toreng itinayo ng mga kaapu-apuhan ni Adan. ");
INSERT INTO tglulb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Sinabi ni Yahweh, “Tingnan ninyo, sila ay iisang bayan na may iisang wika, at sinisimulan nilang gawin ito! Hindi magtatagal lahat ng gusto nilang gawin ay hindi na magiging imposible para sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Halikayo, bumaba tayo at lituhin natin ang kanilang wika roon, para hindi nila maintindihan ang isa’t isa. ");
INSERT INTO tglulb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kaya ikinalat sila ni Yahweh mula roon tungo sa lahat ng dako ng mundo at huminto sila sa pagtatayo ng lungsod. ");
INSERT INTO tglulb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kaya, pinangalanan itong Babel, dahil doon nilito ni Yahweh ang wika ng buong mundo at mula roon ikinalat sila ni Yahweh sa iba’t ibang dako ng mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ito ang mga kaapu-apuhan ni Sem. Si Sem ay isandaang taong gulang, at naging ama ni Arfaxad dalawang taon matapos ang baha. ");
INSERT INTO tglulb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Si Sem ay nabuhay ng limandaang taon matapos siyang naging ama ni Arfaxad. Naging ama rin siya ng iba pang mga anak na lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Nang tatlumpu't-limang taon na si Arfaxad, siya ay naging ama ni Selah. ");
INSERT INTO tglulb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nabuhay pa si Arfaxad ng 403 taon matapos siyang maging ama ni Selah, at naging ama pa ng ibang anak na lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Nang tatlumpung taon na si Selah, siya ay naging ama ni Eber. ");
INSERT INTO tglulb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nabuhay pa si Selah ng 403 taon matapos siyang maging ama ni Eber at naging ama pa ibang anak na lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Nang tatlumpu't-apat na taon si Eber, siya ay naging ama ni Peleg. ");
INSERT INTO tglulb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nabuhay pa si Eber ng 430 taon matapos siyang maging ama ni Peleg. Siya ay naging ama rin ng iba pang mga anak na lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Nang tatlumpung taon na si Peleg, siya ay naging ama ni Reu. ");
INSERT INTO tglulb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nabuhay pa si Peleg ng 209 taon matapos siyang maging ama ni Peleg. Siya ay naging ama rin ng iba pang mga anak na lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Nang tatlumpu't dalawang taon na si Reu, siya ay naging ama ni Serug. ");
INSERT INTO tglulb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nabuhay pa si Reu ng 207 taon matapos siyang maging ama ni Serug. Siya ay naging ama rin ng iba pang mga anak na lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Nang tatlumpung taon na si Serug, siya ay naging ama ni Nahor. ");
INSERT INTO tglulb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Si Serug ay nabuhay pa ng dalawandaang taon matapos siyang maging ama ni Nahor. Siya ay naging ama rin ng iba pang mga anak na lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nang dalawampu't-siyam na taon na si Nahor, siya ay naging ama ni Terah. ");
INSERT INTO tglulb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nabuhay pa si Nahor ng 119 taon matapos siyang maging ama ni Terah. Siya ay naging ama rin ng iba pang mga anak na lalaki at babae. ");
INSERT INTO tglulb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Matapos mamuhay si Terah ng pitumpung taon, siya ay naging ama ni Abram, Nahor, and Haran. ");
INSERT INTO tglulb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ngayon ito ang mga kaapu-apuhan ni Terah. Si Terah ay naging ama nina Abram, Nahor, at Haran, at si Haran ay naging ama ni Lot. ");
INSERT INTO tglulb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Namatay si Haran sa piling ng kaniyang amang si Terah sa lupain na kaniyang sinilangan, sa Ur ng mga Caldeo. ");
INSERT INTO tglulb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Kumuha ng mga asawa sina Abram at Nahor. Ang pangalan ng asawa ni Abram ay Sarai at ang pangalan ng asawa ni Nahor ay Milcah, anak na babae ni Haran, na ama ni Milcah at Iscah. ");
INSERT INTO tglulb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ngayon si Sarai ay baog; siya ay walang anak ");
INSERT INTO tglulb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Kinuha ni Terah ang anak niyang si Abram, si Lot na anak ng kaniyang anak na si Haran, Sarai na kaniyang manugang, asawa ng kaniyang anak na si Abram, at sama-sama nilang iniwan ang Ur ng mga Caldeo, para pumunta sa lupain ng Canaan. Pero sila ay dumating sa Haran at nanatili roon. ");
INSERT INTO tglulb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Nabuhay pa si Terah ng 205 na taon at pagkatapos ay namatay sa Haran. ");
INSERT INTO tglulb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ngayon sinabi ni Yahweh kay Abram, “Humayo ka mula sa iyong bansa, at mula sa iyong mga kamag-anak, at mula sa sambahayan ng iyong ama, sa lupaing ipakikita ko sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Gagawin kitang isang dakilang bansa, at pagpapalain kita, at gagawin kong dakila ang iyong pangalan at ikaw ay magiging isang pagpapala. ");
INSERT INTO tglulb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Pagpapalain ko ang magpapala sa iyo, pero sinuman ang maninira sa iyo ay susumpain ko. Sa pamamagitan mo, ang lahat ng mga pamilya sa buong mundo ay pagpapalain.” ");
INSERT INTO tglulb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kaya humayo si Abram, gaya ng sinabi ni Yahweh na kaniyang gawin, at sumama si Lot sa kaniya. Pitumpu't-limang taong gulang si Abram nang umalis siya sa Haran. ");
INSERT INTO tglulb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Isinama ni Abram si Sarai, na kaniyang asawa, si Lot, na anak na lalaki ng kaniyang kapatid, lahat ng mga ari-arian na kanilang naipon, at mga nakuha nilang mga tauhan sa Haran. Umalis sila patungo sa lupain ng Canaan, at pumunta sa lupain ng Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Naglakbay si Abram hanggang sa Shekem sa kakahuyan ng Moreh. Sa panahong iyon ang mga Cananeo ang naninirahan sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nagpakita si Yahweh kay Abram, at sinabing, “Ibibigay ko ang lupaing ito sa iyong mga kaapu-apuhan.” Kaya nagtayo roon si Abram ng altar para kay Yahweh, na nagpakita sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mula roon siya ay lumipat sa bulubunduking bayan sa silangan ng Bethel, kung saan niya itinayo ang kaniyang tolda, na ang Bethel ay nasa kanluran at ang Ai ay nasa silangan. Doon nagtayo siya ng altar para kay Yahweh at tumawag sa pangalan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Pagkatapos nagpatuloy si Abram sa paglalakbay patungong Negeb. ");
INSERT INTO tglulb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nagkaroon ng taggutom sa lupain, kaya bumaba si Abram papunta sa Ehipto para manirahan doon, dahil matindi ang taggutom sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Nang siya ay papasok na sa Ehipto, sinabi niya sa kaniyang asawang si Sarai, “Tingnan mo, alam kong ikaw ay isang magandang babae. ");
INSERT INTO tglulb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kapag nakita ka ng mga taga-Ehipto sasabihin nilang, 'Ito ay kaniyang asawa,' at ako ay papatayin nila, pero hahayaan ka nilang mabuhay. ");
INSERT INTO tglulb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sabihin mong ikaw ay kapatid kong babae, para mapabuti ako ng dahil sa iyo, at maliligtas ang buhay ko dahil sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Nang papasok na si Abram sa Ehipto, nakita ng mga taga-Ehipto na napakaganda ni Sarai. ");
INSERT INTO tglulb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Nakita siya ng mga prinsepe ng Paraon, at pinuri siya kay Paraon, at dinala ang babae sa sambahayan ng Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pinakitunguhan nang mabuti ni Paraon si Abram alang-alang sa kaniya, at binigyan siya ng mga tupa, mga baka, mga lalaking asno, mga lalaki at babaeng lingkod, mga babaeng asno, at mga kamelyo. ");
INSERT INTO tglulb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pagkatapos pinahirapan ni Yahweh ang Paraon at ang kaniyang sambahayan ng mga matinding salot dahil kay Sarai, na asawa ni Abram. ");
INSERT INTO tglulb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pinatawag ng Paraon si Abram, at sinabing, “Ano itong ginawa mo sa akin? Bakit hindi mo sinabi sa akin na siya ay iyong asawa? ");
INSERT INTO tglulb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Bakit mo sinabing, 'Siya ay kapatid ko,' kaya kinuha ko siya na maging asawa ko? Kaya ngayon, narito ang iyong asawa. Isama mo siya, at umalis na kayo.” ");
INSERT INTO tglulb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pagkatapos, binigyan ng utos ng Paraon ang kaniyang mga tauhan patungkol sa kaniya, at siya ay pinaalis nila, kasama ang kaniyang asawa at ang lahat ng mayroon siya. ");
INSERT INTO tglulb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Kaya umalis si Abram sa Ehipto at pumunta sa Negeb, siya, ang kaniyang asawa, at ang lahat ng mayroon siya. Sumama rin si Lot sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ngayon si Abram ay napakayaman na sa mga hayop, pilak, at ginto. ");
INSERT INTO tglulb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nagpatuloy siya sa kaniyang paglalakbay mula sa Negeb patungong Bethel, sa lugar kung saan naroon ang kaniyang tolda noon, sa pagitan ng Bethel at Ai. ");
INSERT INTO tglulb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Pumunta siya sa lugar kung saan niya dating itinayo ang altar. Dito tumawag siya sa pangalan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ngayon si Lot, na kasama ni Abram sa paglalakbay, ay mayroon ding mga kawan, mga alagang hayop at mga tolda. ");
INSERT INTO tglulb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Dahil ang kanilang mga ari-arian ay napakarami, hindi na kayang tugunan ng lupain ang kanilang pangangailangan na manirahang magkasama, kaya hindi na sila maaaring magsama. ");
INSERT INTO tglulb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","At isa pa, mayroon ng pagtatalo sa pagitan ng mga pastol ng mga hayop ni Abram at ng mga pastol ng mga hayop ni Lot. Naninirahan ang mga Cananeo at Perezeo sa lupain nang panahong iyon. ");
INSERT INTO tglulb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kaya sinabi ni Abram kay Lot, “Huwag nating hayaan na magkaroon ng alitan sa pagitan nating dalawa at sa pagitan ng iyong mga pastol at ng aking mga pastol; kung tutuusin, tayo ay magkapamilya. ");
INSERT INTO tglulb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Hindi ba nasa harap mo ang buong lupain? Humayo ka at ihiwalay mo ang iyong sarili sa akin. Kung pupunta ka sa kaliwa, pupunta naman ako sa kanan. O kung pupunta ka sa kanan, pupunta naman ako sa kaliwa. ");
INSERT INTO tglulb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kaya tumingin si Lot sa paligid at nakitang sagana sa tubig ang buong kapatagan ng Jordan hanggang sa Zoar, katulad ng hardin ni Yahweh, katulad ng lupain sa Ehipto. Ito ay bago pa nilipol ni Yahweh ang Sodoma at Gomorrah. ");
INSERT INTO tglulb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kaya pinili ni Lot ang lahat ng kapatagan ng Jordan para sa kaniyang sarili at naglakbay sa silangan at naghiwalay na ang magkakamag-anak. ");
INSERT INTO tglulb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Nanirahan si Abram sa lupain ng Canaan, at si Lot ay nanirahan naman sa mga lungsod ng kapatagan. Nagtayo siya ng kaniyang mga tolda hindi kalayuan sa Sodoma. ");
INSERT INTO tglulb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ngayon napakasama ng mga kalalakihan ng Sodoma at namumuhay sila laban kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sinabi ni Yahweh kay Abram pagkatapos lumayo ni Lot sa kaniya, “Tumingin ka mula sa kinatatayuan mo, sa hilaga, timog, silangan at kanluran. ");
INSERT INTO tglulb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Lahat ng lupaing ito na nakikita mo, ibibigay ko sa iyo at sa iyong mga kaapu-apuhan magpakailanman. ");
INSERT INTO tglulb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","At gagawin kong kasindami ng alikabok sa lupa ang iyong mga kaapu-apuhan, kaya kung mabibilang ng isang tao ang alikabok ng mundo, sa gayon ay mabibilang din ang mga kaapu-apuhan mo. ");
INSERT INTO tglulb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tumindig ka, lakarin mo ang kahabaan at kalawakan ng lupain, dahil ibibigay ko ito sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kaya binuhat ni Abram ang kaniyang tolda, pumunta siya at nanirahan sa may mga kakahuyan ng Mamre, na nasa Hebron, at doon nagtayo ng isang altar para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nangyari na sa mga araw nina Amrafel, hari ng Sinar, Ariok, hari ng Elasar, Kedorlaomer, hari ng Elam, at Tidal, hari ng Goyim, ");
INSERT INTO tglulb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","na nakipagdigma sila laban kina Bera, hari ng Sodoma, Birsha, hari ng Gomorra, Shinab, hari ng Adma, Shemeber, hari ng Zeboim, at sa hari ng Bela (tinatawag ding Zoar). ");
INSERT INTO tglulb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ang limang mga hari ay nagsama-sama sa Lambak ng Sidim (na tinatawag ding Dagat Asin). ");
INSERT INTO tglulb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Labindalawang taon silang nanilbihan kay Kedorlaomer, pero naghimagsik sila sa ika-labintatlong taon. ");
INSERT INTO tglulb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Pagkatapos sa ikalabing apat na taon, dumating at nilusob nina Kedorlaomer at ng mga haring kasama niya ang mga Refaita sa Astarot Karnaim, ang mga Zuzita sa Ham, ang mga Emita sa Save-Kiryatam, ");
INSERT INTO tglulb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","at ang mga Horeo sa kanilang bulubunduking bansa ng Seir, hanggang sa El Paran, na malapit sa desyerto. ");
INSERT INTO tglulb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Pagkatapos lumiko sila at dumating sa Enmispat (tinatawag ding Kades), at tinalo ang lahat ng bansa ng mga Amalekita, pati na ang mga Amoreo na nanirahan sa Hasason Tamar. ");
INSERT INTO tglulb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Pagkatapos lumabas at naghanda para sa digmaan ang hari ng Sodoma, ang hari ng Gomorra, ang hari ng Adma, ang hari ng Zeboim, at ang hari ng Bela (tinatawag ding Zoar), ");
INSERT INTO tglulb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","laban kina Kedolaomer, hari ng Elam, Tidal, hari ng Goyim, Amrafel, hari ng Sinar, Arioc, hari ng Elasar; apat na mga hari laban sa lima. ");
INSERT INTO tglulb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ngayon puno ng mga hukay na may alkitran ang lambak ng Sidim, at nang tumakas ang mga hari ng Sodoma at Gomorra, nahulog sila roon. Tumakas ang mga natira patungo sa mga kabundukan. ");
INSERT INTO tglulb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kaya kinuha ng kaaway ang lahat ng mga kagamitan ng Sodoma at Gomorra at ang lahat ng kanilang mga panustos, at nagpatuloy sa kanilang landas. ");
INSERT INTO tglulb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Nang umalis sila, dinala rin nila si Lot, ang anak ng kapatid ni Abram na naninirahan sa Sodoma, kasama ang lahat ng kaniyang mga ari-arian. ");
INSERT INTO tglulb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Pumunta at nagsalaysay ang isang nakatakas kay Abram na Hebreo. Naninirahan siya sa may mga kakahuyan na pagmamay-ari ni Mamre, na Amoreo, kapatid nina Escol at Aner, na pawang mga kakampi ni Abram. ");
INSERT INTO tglulb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ngayon nang marinig ni Abram na nabihag ng mga kaaway ang kaniyang kamag-anak, pinangunahan niya ang kaniyang tatlong daan at labing walong sinanay na tauhan, na ipinanganak sa kaniyang sambahayan, at tinugis niya sila hanggang sa Dan. ");
INSERT INTO tglulb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kinagabihan hinati niya ang kaniyang mga tauhan laban sa kanila at nilusob sila, at hinabol sila hanggang sa Hoba na nasa hilaga ng Damasco. ");
INSERT INTO tglulb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Pagkatapos dinala niya ang lahat ng mga ari-arian, at dinala rin niya ang kaniyang kamag-anak na si Lot at ang kaniyang mga kagamitan, pati na rin ang mga kababaihan at ang iba pang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Matapos bumalik ni Abram mula sa pagtalo kina Kedorlaomer at sa mga hari na kasama niya, ang hari ng Sodoma ay lumabas para salubungin siya sa lambak ng Save (tinatawag ding Lambak ng Hari). ");
INSERT INTO tglulb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Naglabas si Melquisedec, hari ng Salem, ng tinapay at alak. Siya ay pari ng Kataastaasang Diyos. ");
INSERT INTO tglulb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Siya ay kaniyang pinagpala na nagsasabing, “Pagpalain ka Abram ng Kataastaasang Diyos, Manlilikha ng langit at lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Pagpalain ang Kataastaasang Diyos, na siyang nagbigay ng iyong mga kaaway sa iyong kamay.” Pagkatapos ibinigay ni Abram sa kaniya ang ikasampu ng lahat ng kaniyang pag-aari. ");
INSERT INTO tglulb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sinabi ng hari ng Sodoma kay Abram, “Ibigay mo sa akin ang mga tao, at kunin mo ang mga kagamitan para sa iyong sarili.” ");
INSERT INTO tglulb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Sinabi ni Abram sa hari ng Sodoma, “Itinaas ko ang aking kamay kay Yahweh, sa Kataastaasang Diyos, Manlilikha ng langit at lupa, ");
INSERT INTO tglulb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","na hindi ako kukuha ng sinulid, sintas ng sandalyas, o anumang sa iyo, para ikaw ay hindi kailanman makapagsabing, “Ako ang nagpayaman kay Abram.' ");
INSERT INTO tglulb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Wala akong kukunin maliban sa kung anong nakain ng mga kabataang lalaki at ang bahagi ng mga lalaking sumama sa akin. Hayaang mong kunin nina Aner, Escol, at Mamre ang kanilang bahagi.” ");
INSERT INTO tglulb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Pagkatapos ng mga bagay na ito dumating kay Abram ang salita ni Yahweh sa isang pangitain, na nagsasabing, “Huwag kang matakot, Abram! Ako ang iyong panangga at iyong pinakadakilang gantimpala.” ");
INSERT INTO tglulb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Sinabi ni Abram, “Panginoong Yahweh, ano ang ibibigay mo sa akin, yamang nagpapatuloy akong walang anak, at ang tagapagmana ng aking bahay ay si Eliezer ng Damascus?” ");
INSERT INTO tglulb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Sinabi ni Abram, “Dahil hindi mo ako binigyan ng anak, tingnan mo, ang katiwala ng aking bahay ay siyang aking tagapagmana.” ");
INSERT INTO tglulb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Pagkatapos, narito, dumating ang salita ni Yahweh, nagsasabing “Ang taong ito ay hindi mo magiging tagapagmana; sa halip manggagaling sa inyong sariling katawan ang siyang magiging tagapagmana mo.” ");
INSERT INTO tglulb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Pagkatapos siya ay dinala niya sa labas, at sinabing, “Tumingala ka sa langit, at bilangin mo ang mga bituin, kung kaya mo silang bilangin.” Pagkatapos sinabi niya sa kaniya,” Ganoon din karami ang iyong magiging mga kaapu-apuhan.” ");
INSERT INTO tglulb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Naniwala siya kay Yahweh, at itinuring ito sa kaniya bilang pagiging matuwid. ");
INSERT INTO tglulb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Sinabi niya sa kaniya, “Ako si Yahweh na nagdala sa iyo palabas ng Ur ng mga Caldeo, para ibigay sa iyo ang lupaing ito para manahin ito.” ");
INSERT INTO tglulb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Sinabi niya, “Panginoong Yahweh, paano ko malalaman na mamanahin ko ito?” ");
INSERT INTO tglulb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Pagkatapos sinabi niya sa kaniya, “Dalhan mo ako ng tatlong taong gulang na baka, tatlong taong gulang na babaeng kambing at tatlong taong gulang na lalaking tupa, isang kalapati at isang batang pitson.” ");
INSERT INTO tglulb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Dinala niya sa kaniya lahat ng ito, at hinati ang ito sa dalawa, at nilapag sa magkabilang bahagi ang bawat kalahati, pero hindi niya hinati ang mga ibon. ");
INSERT INTO tglulb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nang bumaba ang mga ibong mandaragit para kainin ang mga patay na hayop, itinaboy sila ni Abram papalayo. ");
INSERT INTO tglulb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Pagkatapos nang palubog na ang araw, nakatulog nang mahimbing si Abram, at masdan, siya ay nilukuban ng isang malalim at nakakapangilabot na kadiliman. ");
INSERT INTO tglulb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Pagkatapos sinabi ni Yahweh kay Abram, “Alamin mong tiyak na ang iyong mga kaapu-apuhan ay magiging dayuhan sa lupaing hindi kanila, at sila ay gagawing alipin at aapihin sa loob ng apatnaraang taon. ");
INSERT INTO tglulb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Hahatulan ko ang bansang iyon na paglilingkuran nila, at pagkatapos sila ay lalabas na may saganang mga ari-arian. ");
INSERT INTO tglulb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pero ikaw ay pupunta sa iyong mga ama nang payapa, at ikaw ay ililibing sa angkop na katandaan. ");
INSERT INTO tglulb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Sa ikaapat na salinlahi sila ay muling babalik dito, dahil ang mga kasalanan ng mga Amorito ay hindi pa nakaabot sa sukdulan nito.” ");
INSERT INTO tglulb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nang lumubog na ang araw at dumilim, masdan, isang umuusok na banga at umaapoy na sulo ang dumaan sa pagitan ng mga piraso. ");
INSERT INTO tglulb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Sa araw na iyon gumawa si Yahweh ng tipan kay Abram, na nagsasabing, “Ibinibigay ko sa iyong kaapu-apuhan ang lupaing ito, mula sa ilog ng Ehipto patungo sa dakilang ilog ng Eufrates, ang Eufrates— ");
INSERT INTO tglulb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ang mga Cenio, ang mga Cenizeo, ang mga Kadmoneo, ");
INSERT INTO tglulb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ang mga Heteo, ang mga Perezeo, ang mga Refiata, ");
INSERT INTO tglulb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ang mga Amoreo, ang mga Cananeo, ang mga Gergeseo at mga Jebuseo.” ");
INSERT INTO tglulb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ngayon si Sarai, asawa ni Abram, ay hindi nagkaanak sa kaniya, pero mayroon siyang babaeng lingkod, taga-Ehipto, na ang pangalan ay Agar. ");
INSERT INTO tglulb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kaya sinabi ni Sarai kay Abram, “Tingnan mo, pinanatili ako ni Yahweh na walang anak. Sipingan mo ang aking lingkod. Baka sakaling magkaroon ako ng anak sa pamamagitan niya.” Nakinig si Abram sa sinabi ni Sarai. ");
INSERT INTO tglulb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Iyon ay matapos na si Abram ay nanirahan ng sampung taon sa lupain ng Canaan nang ibinigay ni Sarai, asawa ni Abram, si Agar, na kaniyang lingkod na taga-Ehipto, sa kaniyang asawa bilang asawa. ");
INSERT INTO tglulb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kaya nagkaroon siya ng kaugnayan kay Agar, at nabuntis siya. At nang makita niyang nabuntis siya, tiningnan niya ng may pag-aalipusta ang kaniyang among babae. ");
INSERT INTO tglulb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Pagkatapos sinabi ni Sarai kay Abram, “Ang kamaliang ito sa akin ay dahil sa iyo. Ibinigay ko ang aking babaeng lingkod sa iyong mga bisig, at nang makita niyang siya ay nabuntis, hinamak niya ako sa kaniyang paningin. Hayaan mong si Yahweh ang humatol sa pagitan natin. ");
INSERT INTO tglulb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Pero sinabi ni Abram kay Sarai, “Tingnan mo, nasa iyong kapangyarihan ang iyong babaeng lingkod, gawin mo sa kaniya ang iniisip mong pinakamabuti.” Kaya pinagmalupitan siya ni Sarai, at siya ay tumakas mula sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ang anghel ni Yahweh ay nakita siya sa isang bukal ng tubig sa ilang, ang bukal na matatagpuan sa daan patungong Shur. ");
INSERT INTO tglulb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Sinabi niya, “Agar, alipin ni Sarai, saan ka nanggaling at saan ka pupunta?” Sinabi niya, “Tumakas ako mula sa aking among babae na si Sarai”. ");
INSERT INTO tglulb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Sinabi sa kaniya ng anghel ni Yahweh, “Bumalik ka sa iyong among babae, at sumailalim ka sa kaniyang kapangyarihan”. ");
INSERT INTO tglulb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Pagkatapos sinabi ng anghel ni Yahweh sa kaniya, “Labis kong pararamihin ang iyong mga kaapu-apuhan para maging napakarami nila para bilangin. ");
INSERT INTO tglulb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Sinabi rin sa kaniya ng anghel ni Yahweh, “Tingnan mo, ikaw ay buntis, at manganganak ka ng isang anak na lalaki, at pangangalanan mo siyang Ismael, dahil narinig ni Yahweh ang iyong paghihirap”. ");
INSERT INTO tglulb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Siya ay magiging isang lalaking mistulang mabangis na asno. Magiging kalaban siya ng bawat tao at bawat tao ay magiging kalaban niya at mamumuhay siyang hiwalay sa kaniyang mga kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Pagkatapos binigay niya ang pangalang ito kay Yahweh na nangusap sa kaniya, “Ikaw ang Diyos na nakakakita sa akin,” dahil sinabi niya, “Talaga bang patuloy akong makakakita, kahit na pagkatapos niya akong nakita?” ");
INSERT INTO tglulb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Dahil dito tinawag na Beerlahairoi ang balon; masdan, naroon ito sa pagitan ng Kades at Bered. ");
INSERT INTO tglulb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nanganak si Agar ng anak na lalaki ni Abram, at pinangalanan ni Abram ang kaniyang anak, na isinilang ni Agar, na Ismael. ");
INSERT INTO tglulb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Si Abram ay walumpu't-anim na taong gulang nang isilang ni Agar si Ismael para kay Abram. ");
INSERT INTO tglulb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Nang siyamnapu't-siyam na taong gulang na si Abram, nagpakita si Yahweh sa kanya at sinabing, “Ako ang Diyos na makapangyarihan. Lumakad ka sa akin at mamuhay ka nang matuwid. ");
INSERT INTO tglulb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Pagkatapos pagtitibayin ko ang aking tipan sa pagitan natin, at lubos kitang pararamihin.” ");
INSERT INTO tglulb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Nagpatirapa si Abram na nakasayad ang mukha sa lupa at nangusap ang Diyos sa kanya, sinabing, ");
INSERT INTO tglulb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Para sa akin, masdan mo, ang aking tipan ay sumasaiyo. Ikaw ay magiging ama ng napakamaraming bansa. ");
INSERT INTO tglulb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ang pangalan mo ay magiging Abraham, at hindi na Abram—dahil itinalaga kita na maging ama ng napakamaraming bansa. ");
INSERT INTO tglulb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Pamumungahin kita nang lubos, at magmumula sa iyo ang maraming bansa, at ang mga magiging hari ay magmumula rin sayo. ");
INSERT INTO tglulb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Magtatatag ako ng tipan sa pagitan natin at sa iyong mga magiging kaapu-apuhan, hanggang sa kanilang buong salinlahi, para sa isang walang hanggang tipan, na ako ang magiging Diyos mo at ng mga susunod mong mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ibibigay ko sayo at sa mga susunod mong kaapu-apuhan, ang lupain kung saan ka naninirahan, lahat ng lupain sa Canaan, para sa walang hanggang pag-aari at ako ang magiging Diyos nila.” ");
INSERT INTO tglulb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Pagkatapos sinabi ng Diyos kay Abraham, “Para sayo, dapat mong ingatan ang aking tipan, ikaw at ang susunod mong kaapu-apuhan hanggang sa kanilang buong salinlahi. ");
INSERT INTO tglulb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ito ang aking tipan sa pagitan ko at sa pagitan mo at sa susunod mong mga kaapu-apuhan na dapat mong ingatan: Lahat ng lalaki sa inyo ay dapat matuli. ");
INSERT INTO tglulb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Dapat kayong matuli sa laman ng iyong balat, at ito ang magiging palatandaan ng tipan sa pagitan ko at pagitan mo. ");
INSERT INTO tglulb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Bawat lalaki sa inyo ay dapat na matuli pagsapit ng ikawalong araw na gulang, maging sa mga susunod ninyong salinlahi. Kasama rito ang mga ipinanganak sa iyong sambahayan, pati na ang nabili ng salapi mula sa mga dayuhan na hindi kasama sa iyong mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Siya na ipinanganak sa iyong sambahayan, at nabili ng iyong salapi ay dapat matuli. Sa gayon ang aking tipan ay mapapasaiyong laman para sa walang hanggang tipan. ");
INSERT INTO tglulb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Sinuman sa mga hindi tuli ang hindi tinuli sa laman ng kaniyang balat ay ihihiwalay mula sa kanyang sambayahan. Sinira niya ang aking tipan. ");
INSERT INTO tglulb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Sinabi ng Diyos kay Abraham, “Tungkol naman kay Sarai na iyong asawa, hindi na Sarai ang itatawag mo sa kanya. Sa halip, Sarah ang kanyang magiging pangalan. ");
INSERT INTO tglulb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Pagpapalain ko siya at bibigyan kita ng anak na lalaki sa pamamagitan niya. Pagpapalain ko siya, at siya ang magiging ina ng mga bansa. Ang mga hari ng mga tao ay magmumula sa kanya.” ");
INSERT INTO tglulb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Pagkatapos nagpatirapa si Abraham na nakasayad ang mukha, at tumawa, at sinabi sa kanyang puso, “Maaari bang magkaanak ang isang taong isandaang taong gulang na? At magkakaanak pa ba si Sarah, gayong siyamnapung taong gulang na siya? ");
INSERT INTO tglulb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Sinabi pa ni Abraham sa Diyos, “Nawa mabuhay si Ismael sa iyong harapan!” ");
INSERT INTO tglulb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Sinabi ng Diyos, “Hindi, si Sarah na iyong asawa ay magdadalang-tao ng anak na lalaki, at pangalanan mo siyang Isaac. Magtatatag ako ng tipan sa kanya, bilang walang hanggang tipan sa mga susunod niyang mga magiging kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tungkol naman kay Ismael, narinig kita. Pagmasdan mo, pinagpapala ko siya ngayon at pamumungahin ko siya, at pararamihin ko siya nang masagana. Siya ay magiging ama ng labindalawang mga pinuno ng mga lipi, at gagawin ko siyang isang malaking bansa. ");
INSERT INTO tglulb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pero itatatag ko ang aking tipan kay Isaac, na siyang isisilang ni Sarah sa ganitong oras sa susunod na taon.” ");
INSERT INTO tglulb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Nang siya ay tapos ng makipag-usap sa kanya, umakyat ang Diyos mula kay Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Pagkatapos, kinuha ni Abraham ang kanyang anak na si Ismael at lahat ng ipinanganak sa kanyang sambahayan, at lahat ng mga nabili niya sa kanyang salapi, bawat lalaki na kabilang sa mga tauhan ng sambahayan ni Abraham, at tinuli sa laman ng kanilang balat sa parehong araw, gaya ng sinabi ng Diyos sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Natuli si Abraham sa laman ng kanyang balat nang siya ay siyamnapu't-siyam na taong gulang. ");
INSERT INTO tglulb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","At natuli si Ismael sa laman ng kanyang balat nang siya ay labing tatlong taong gulang. ");
INSERT INTO tglulb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Sa magkaparehong araw, parehong natuli si Abraham at si Ismael na kanyang anak. ");
INSERT INTO tglulb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Lahat ng lalaki sa kanyang sambahayan ay natuli rin kasama niya, pati na ang mga ipinanganak sa sambahayan, at ang mga nabili ng salapi mula sa dayuhan. ");
INSERT INTO tglulb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Habang nakaupo siya sa pintuan ng tolda sa kainitan ng araw, nagpakita si Yahweh kay Abraham sa mga kakahuyan ni Mamre. ");
INSERT INTO tglulb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Tumingala siya at naroon, nakita niya ang tatlong lalaki na nakatayo sa harap niya. Nang makita sila ni Abraham, tumakbo siya mula sa pintuan ng tolda, para salubungin sila at yumukod siya sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Sinabi niya, “Panginoon, kung nakasumpong ako ng biyaya sa iyong paningin, huwag kang umalis at iwan ang iyong lingkod. ");
INSERT INTO tglulb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Hayaan ninyong maidala ang kaunting tubig, mahugasan ang inyong mga paa, at makapagpahinga kayo sa ilalim ng punong kahoy. ");
INSERT INTO tglulb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Hayaan ninyong dalhan ko kayo ng kaunting pagkain, at nang manumbalik ang inyong lakas. Pagkatapos maaari na kayong tumuloy sa pupuntahan ninyo dahil naparito na kayo sa inyong lingkod.” Sinabi nila, “Gawin mo ang sinabi mo.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Pagkatapos dali-daling pumunta si Abraham sa tolda ni Sarah at sinabi, “Bilisan mo, magdala ka ng tatlong takal ng harina, masahin mo ito, at gawing tinapay.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Pagkatapos tumakbo si Abraham sa kawan, kumuha siya ng guyang mainam at maayos at ibinigay ito sa lingkod, at nagmadali siyang ihanda ito. ");
INSERT INTO tglulb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kumuha siya ng mantikilya at gatas, at ang guya na naihanda at nilagay ang pagkain sa harap nila. At tumayo siya sa ilalim ng puno habang sila ay kumakain. ");
INSERT INTO tglulb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Sinabi nila sa kanya, “Nasaan ang iyong asawa na si Sarah?” Sumagot siya, “Naroon sa loob ng tolda.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Sinabi niya, “Makatitiyak ka na babalik ako sa iyo sa tagsibol at makikita mo, magkakaroon ng anak na lalaki ang iyong asawa na si Sarah.” Nakikinig si Sarah sa pintuan ng tolda na nasa likod ni Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ngayon matanda na nga sina Abraham at Sarah, talagang napakatanda na at nalampasan na ni Sarah ang edad kung saan hindi na maaaring magkaanak pa ang isang babae. ");
INSERT INTO tglulb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kaya tinawanan ni Sarah ang kaniyang sarili at sinabing,” “Ngayong matanda na ako, magkakaroon pa ba ako ng kasiyahan, gayong ang panginoon ko ay matanda na rin?” ");
INSERT INTO tglulb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Sinabi ni Yahweh kay Abraham, “Bakit tumawa si Sarah at sinabing, 'Magkakaanak pa batalaga ako gayong matanda na ako?' ");
INSERT INTO tglulb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Mayroon bang mahirap para kay Yahweh? Pagsapit ng itinakda kong panahon, sa tagsibol, babalik ako sa iyo. Sa ganitong oras sa susunod na taon, si Sarah ay magkakaroon ng anak na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Pagkatapos, itinanggi ni Sarah ito at sinabing, “Hindi ako tumawa,” dahil siya ay natakot. Sumagot si Yahweh, “Hindi, tumawa ka.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Pagkatapos tumayo ang mga lalaki para umalis at tumingin pababa patungong Sodoma. Sumama si Abraham sa kanila para ihatid sila sa pagpapatuloy ng kanilang paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Pero sinabi ni Yahweh, “Dapat ko bang itago kay Abraham ang gagawin ko, ");
INSERT INTO tglulb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","gayong tiyak na magiging dakila at makapangyarihang bansa si Abraham, at pagpapalain ang lahat ng bansa sa daigdig sa pamamagitan niya? ");
INSERT INTO tglulb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Dahil pinili ko siya para maturuan ang kanyang mga anak pati na ang sambahayan na susunod sa kanya na mapanatili ang kaparaanan ni Yahweh, na gumawa ng matuwid at makatarungan, nang sa gayon maibibigay ni Yahweh kay Abraham ang sinabi niya sa kanya.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Pagkatapos sinabi ni Yahweh, “Dahil napakarami ng paratang laban sa Sodoma at Gomora, at napakalubha na ng kanilang kasalanan, ");
INSERT INTO tglulb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","bababa ako ngayon doon at titingnan ko kung kasingsama sila gaya ng paratang sa kanila na sinabi sa akin. Kung hindi man, malalaman ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Pagkatapos ang mga lalaki ay umalis mula roon at pumunta patungo sa Sodoma, pero nanatiling nakatayo si Abraham sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Pagtapos lumapit si Abraham at sinabi, “Lilipulin mo ba ang matuwid kasama ang makasalanan? ");
INSERT INTO tglulb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Marahil mayroong limampung matuwid sa loob ng lungsod. Lilipulin niyo ba ito at hindi ililigtas ang lugar alang-alang sa kapakanan ng limampung matuwid na naroon? ");
INSERT INTO tglulb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Malayong gawin mo ang mga bagay na ito, na patayin ang mga matuwid kasama ang makasalanan, at ituring ang mga matuwid gaya ng mga makasalanan. Malayong gawin mo ito! Hindi ba gagawin ng Hukom ng buong mundo kung ano ang makatarungan?” ");
INSERT INTO tglulb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Sinabi ni Yahweh, “Kung may nakita kang limampung matuwid sa lungsod na iyon, ililigtas ko ang buong lugar para sa kanila.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Sumagot si Abraham at sinabi, “Tingnan mo ang aking ginawa, nangahas akong makipag-usap sa aking Panginoon, kahit na alikabok at abo lamang ako! ");
INSERT INTO tglulb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Paano kung nabawasan ng lima ang limampung matuwid? Wawasakin mo ba ang buong lungsod dahil nabawasan ng lima? At sinabi niya, “Hindi ko ito wawasakin kung may mahanap akong apatnapu't lima.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Muli siyang nakipag-usap sa kanya at sinabing, “Paano kung apatnapu ang makita roon? Sumagot siya, “Alang-alang sa apatnapu, hindi ko ito gagawin.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Sinabi niya, “Pakiusap, huwag kayong magagalit Panginoon, para makapagsalita ako. Kung sakali na tatlumpu ang mahanap doon? “Sinabi ng Diyos, “Hindi ko ito gagawin kung may mahanap akong tatlumpu doon.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Sinabi niya, “Tingnan mo, nangahas akong makipag-usap sa aking Panginoon! Marahil dalawampu ang makita roon.” Tumugon siya, “Hindi ko ito gagawin alang-alang sa dalawampu.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Sinabi niya, “Pakiusap, huwag kayong magalit, Panginoon, sasabihin ko ito sa huling pagkakataon. Marahil sampu ang makita roon.” At sinabi niya, “Hindi ko ito wawasakin alang-alang sa sampung natira.” ");
INSERT INTO tglulb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Nagtungo na si Yahweh sa kaniyang paroroonan matapos siyang makipag-usap kay Abraham, at bumalik na si Abraham sa kanyang tahanan. ");
INSERT INTO tglulb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Dumating ang dalawang anghel sa Sodoma sa gabi, habang nakaupo si Lot sa tarangkahan ng Sodoma. Nakita sila ni Lot, tumayo siya upang salubungin sila, at nagpatirapa na nakasayad ang mukha sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Sinabi niya, “Nakikiusap ako aking mga panginoon, kayo ay pumunta muna sa bahay ng inyong lingkod at manatili ng magdamag at hugasan ang inyong mga paa. Pagkatapos, maaari na kayong bumangon nang maaga at pumunta sa inyong pupuntahan.” At sinabi nila, “Hindi, magpapalipas na lang kami ng gabi sa liwasan ng bayan. ");
INSERT INTO tglulb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pero pinilit niya sila kaya sumama sila sa kanya, at pumasok sila sa kanyang bahay. Naghanda siya ng makakain nila at nagluto ng tinapay na walang pampaalsa at sila ay kumain. ");
INSERT INTO tglulb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Pero bago sila humiga, pinaligiran ng mga kalalakihan sa lungsod, mga kalalakihan sa Sodoma, bata at matanda sa lahat ng sulok ng bayan, ang bahay niya, lahat ng kalalakihan sa bawat bahagi ng lungsod. ");
INSERT INTO tglulb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Tinawag nila si Lot at sinabi, “Nasaan ang mga lalaking pumasok sa inyo ngayong gabi? Dalhin mo sila sa amin para masipingan namin sila. ");
INSERT INTO tglulb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kaya lumabas si Lot sa kanyang bahay at sinara ang pinto sa likuran niya. ");
INSERT INTO tglulb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Sinabi niya sa kanila, “Nagmamakaawa ako sa inyo, mga kapatid ko, huwag kayong gumawa ng kasamaan. ");
INSERT INTO tglulb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tingnan ninyo, narito ang aking dalawang anak na babae na hindi pa nasisipingan ng sinumang lalaki. Hayaan ninyo, nakikiusap ako, na dalhin ko sila sa inyo at gawin ninyo sa kanila ang katanggap-tanggap sa inyong mga mata. Huwag lang dito sa mga lalaking ito dahil sila ay nasa loob ng aking pamamahay.” ");
INSERT INTO tglulb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sabi nila, “Tumabi ka!” Sinabi rin nila, “Ang taong ito ay dumating dito sa ating lugar bilang isang dayuhan at ngayon siya ay naging hukom natin! Mas malala pa ang gagawin namin sa iyo kaysa sa kanila.” Tinulak nila nang malakas ang lalaki, si Lot, at lumapit para sirain ang pinto. ");
INSERT INTO tglulb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pero inabot ng mga lalaki ng kanilang mga kamay si Lot at dinala sa loob ng bahay kasama nila at sinara ang pinto. ");
INSERT INTO tglulb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","At doon naman sa mga tao na nasa labas ng pinto ng bahay, inatake sila ng mga panauhin ni Lot at ginawang bulag, ang mga bata pati matatanda, kaya nahirapan silang makita ang pinto ng bahay. ");
INSERT INTO tglulb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Pagkatapos, sinabi ng mga lalaki kay Lot, “Mayroon ka pa bang ibang kasama rito? Mga manugang, mga anak na lalaki at babae at kung sino pa mang mga kasamahan mo sa lungsod, ilabas mo na sila rito. ");
INSERT INTO tglulb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Wawasakin na namin ang lugar na ito, dahil napakarami na ng paratang sa kanila sa harap ni Yahweh, kaya pinadala niya kami para wasakin ito.” ");
INSERT INTO tglulb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lumabas si Lot at kinausap niya ang kanyang mga manugang, ang mga lalaki na nangakong pakakasalan ang kanyang mga anak na babae, at sinabi, “Bilis, umalis na kayo sa lugar na ito, dahil wawasakin na ni Yahweh ang lungsod.” Pero para sa kanyang mga manugang, tila ba nagbibiro lang siya. ");
INSERT INTO tglulb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Nang mag-uumaga na, inudyakan ng mga anghel si Lot at sinabi, “Umalis ka na, kunin mo ang iyong asawa at dalawang anak na babae na narito, para hindi kayo maisama sa kaparusahan ng lungsod.” ");
INSERT INTO tglulb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Pero nag-alinlangan siya. Kaya hinawakan ng mga lalaki ang kanyang kamay, at ang kamay ng kanyang asawa, at mga kamay ng kanyang dalawang anak na babae, dahil mahabagin si Yahweh sa kanya. Sila ay inilabas nila, at dinala sa labas ng lungsod. ");
INSERT INTO tglulb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Nang nailabas na sila, sinabi ng isa sa mga lalaki, “Tumakbo na kayo para sa inyong mga buhay! Huwag kayong lilingon o manatili saanman sa kapatagan. Magsitakas kayo patungo sa mga bundok para hindi kayo malipol. ");
INSERT INTO tglulb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Sinabi ni Lot sa kanila.” Hindi, pakiusap aking mga panginoon! ");
INSERT INTO tglulb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ang inyong lingkod ay nakatanggap ng pabor sa inyong paningin at pinakitaan ninyo kami ng dakilang kagandahang-loob sa pagligtas sa aking buhay, pero hindi ako makakatakas sa mga bundok dahil aabutan din ako ng sakuna at mamamatay ako.. ");
INSERT INTO tglulb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tingnan ninyo, ang lungsod banda roon ay malapit at maliit lamang para makatakas kayo. Pakiusap, hayaan ninyo akong makatakas doon (diba maliit lamang iyon?), at ang buhay ko ay maliligtas.” ");
INSERT INTO tglulb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Sinabi niya sa kanya, “Sige, pagbibigyan ko rin ang kahilingang ito, hindi ko rin wawasakin ang lungsod na nabanggit mo. ");
INSERT INTO tglulb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Bilisan mo! Tumakas ka na patungo roon, dahil hindi ko magagawa ang anumang bagay hangga't hindi ka nakararating doon.” Kaya tinawag na Zoar ang lungsod na ito. ");
INSERT INTO tglulb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mataas na ang araw sa mundo nang narating ni Lot ang Zoar. ");
INSERT INTO tglulb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Pagkatapos, nagpaulan sa Sodoma at Gomora ng asupre at apoy si Yahweh mula sa kalangitan. ");
INSERT INTO tglulb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Winasak niya ang mga lungsod na iyon, at lahat ng kapatagan at lahat ng naninirahan sa mga lungsod, pati na ang mga pananim na tumutubo sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pero lumingon ang asawa ni Lot na nasa likod niya at siya ay naging isang haligi ng asin. ");
INSERT INTO tglulb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Bumangon si Abraham nang maaga at nagpunta sa lugar kung saan siya tumayo sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Tumingin siya sa baba sa Sodoma at Gomora at sa lahat ng lupain ng kapatagan. Nakita niya at namasdan ang usok na umaakyat mula sa lupa na katulad ng usok sa isang pugon. ");
INSERT INTO tglulb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kaya matapos wasakin ng Diyos ang mga lungsod sa kapatagan, naalala ng Diyos si Abraham. Inilabas niya si Lot mula sa gitna ng kapahamakan ng winasak niya ang mga lungsod kung saan nanirahan si Lot. ");
INSERT INTO tglulb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Pero nagpunta si Lot paakyat mula sa Zoar para manirahan sa kabundukan kasama ang kanyang dalawang anak na babae dahil natakot siyang manirahan sa Zoar. Kaya nanirahan siya sa loob ng kuweba kasama ng kanyang dalawang anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Sinabi ng nakakatanda sa nakababata, “Matanda na ang ating ama at wala ng lalaki sa lugar na ito na sisiping sa atin katulad ng kinagawian ng mga tao sa buong mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Halika ating painumin ng alak ang ating ama at sisipingan natin siya para mapalawig natin ang kaapu-apuhan ng ating ama. ");
INSERT INTO tglulb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kaya, pinainom nila ang kanilang ama ng alak ng gabing iyon. Pagkatapos, pumasok ang nakatatanda at sumiping sa kanyang ama; hindi niya alam kung kailan siya humiga, ni kung kailan siya bumangon. ");
INSERT INTO tglulb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kinabukasan, sinabi ng nakakatanda sa nakababata, “Makinig ka, sinipingan ko kagabi ang aking ama. Painumin ulit natin siya ng alak ngayong gabi, at ikaw naman ang papasok at sisiping sa kanya para mapalawig natin ang lahi ng ating ama.” ");
INSERT INTO tglulb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kaya ng gabing iyon, muli nilang pinainom ng alak ang kanilang ama, pumasok at sumiping sa kanya ang nakababata. Hindi niya alam kung kailan siya humiga ni kung kailan siya bumangon. ");
INSERT INTO tglulb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kaya nabuntis ang parehong anak na babae ni Lot sa pamamagitan ng kanilang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ang nakakatanda ay nanganak ng isang lalaki at pinangalanan siyang Moab. Siya ang naging ninuno ng mga Moabita hanggang sa kasalukuyan. ");
INSERT INTO tglulb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","At sa nakababatang anak na babae, siya rin ay nanganak ng isang lalaki, at pinangalanan siyang Ben Ammi. Naging ninuno siya ng mga mamamayan ng Ammon hanggang sa kasalukuyan. ");
INSERT INTO tglulb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Naglakbay si Abraham mula roon patungo sa lupain ng Negeb, at nanirahan sa pagitan ng Kadesh at Sur. Isa siyang dayuhan na naninirahan sa Gerar. ");
INSERT INTO tglulb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Sinabi ni Abraham patungkol sa kanyang asawa na si Sarah, “Kapatid ko siya.” Kaya nagpadala si Abimelech hari ng Gerar, ng kanyang mga tauhan at kinuha nila si Sarah. ");
INSERT INTO tglulb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pero kinagabihan, pumunta ang Diyos kay Abimelech sa kanyang panaginip at sinabi sa kanya, “Masdan mo, ikaw ay mamamatay dahil sa babae na kinuha mo dahil siya ay asawa ng lalaki.” ");
INSERT INTO tglulb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ngayon, hindi nilapitan ni Abimelech si Sarah at sinabi niya, “Panginoon, papatayin mo rin ba ang matuwid na bansa? ");
INSERT INTO tglulb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hindi ba sinabi niya mismo sa akin, 'Kapatid ko siya?'Kahit si Sarah, sinabi niya rin mismo sa akin na, 'Kapatid ko siya.' Nagawa ko ito sa katapatan ng aking puso at kamusmusan ng aking mga kamay.” ");
INSERT INTO tglulb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Pagkatapos, sinabi ng Diyos sa kanya sa panaginip, “Oo, alam ko na sa katapatan ng iyong puso na nagawa mo ito at hindi ko hinayaang magkasala ka sa akin. Kaya hindi ko hinayaang mahawakan mo siya. ");
INSERT INTO tglulb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kaya ibalik mo ang asawa ng lalaki, dahil siya ay isang propeta. Ipananalangin ka niya at mabubuhay ka. Pero kung hindi mo siya ibabalik, alam mo na ikaw at ang lahat ng nasa iyo ay tiyak na mamamatay.” ");
INSERT INTO tglulb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Bumangon si Abimelech nang maaga at pinapunta ang lahat ng kanyang lingkod sa kanya. Sinabi niya ang lahat ng mga bagay na ito sa kanila, at matinding takot ang naramdaman ng kanyang mga lingkod. ");
INSERT INTO tglulb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Pagkatapos, tinawag ni Abimelech si Abraham at sinabi sa kanya,” Ano itong ginawa mo sa amin? Paano ako nagkasala sa iyo, na nagdala ka sa akin at sa aking kaharian ng matinding kasalanan? Ginawa mo sa akin ang hindi dapat gawin.” ");
INSERT INTO tglulb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Sinabi ni Abimelech kay Abraham, “Ano ang nagtulak sa iyo na gawin mo ang bagay na ito?” ");
INSERT INTO tglulb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Sumagot si Abraham, “Dahil naisip ko, 'Tiyak na walang kinatatakutan na Diyos ang mga tao sa lugar na ito at papatayin nila ako dahil sa aking asawa.' ");
INSERT INTO tglulb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Bukod pa rito, tunay na siya ay kapatid ko, ang anak na babae ng aking ama, pero hindi anak ng aking ina; at siya ay aking naging asawa. ");
INSERT INTO tglulb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Nang pinaalis ako ng Diyos sa bahay ng aking ama at naglakbay mula sa ibat-ibang lugar, sinabi ko kanya, 'Dapat mong ipakita ang katapatang ito sa akin bilang aking asawa: Sa bawat lugar na pupuntahan natin, sabihin mo na “'Kapatid ko siya.'''' ");
INSERT INTO tglulb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Pagkatapos, kumuha si Abimelech ng mga tupa at mga baka, mga aliping lalaki at mga babae at ibinigay ang mga ito kay Abraham. Pagkatapos, ibinalik niya sa kanya si Sarah na asawa ni Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Sinabi ni Abimelech, “Tingnan mo, nasa harapan mo ang lupain ko. Manirahan ka kung saan mo naisin. ");
INSERT INTO tglulb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kay Sarah sinabi niya. “Tingnan mo, binigyan ko ang iyong kapatid ng isang libong piraso ng pilak. Pantakip ito sa mga kamalian laban sa iyo sa mga mata ng lahat ng kasama mo, at sa harapan ng lahat, tuluyan kang ginawang matuwid.” ");
INSERT INTO tglulb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Pagkatapos, nanalangin si Abraham sa Diyos at pinagaling ng Diyos si Abimelech, ang kanyang asawa, at kanyang mga babaeng alipin para sila ay tuluyan ng magkaroon ng anak. ");
INSERT INTO tglulb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Dahil hinayaan ni Yahweh na ganap na hindi magkaanak ang lahat ng mga babae sa sambayanan ni Abimelech, dahil kay Sarah, na asawa ni Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Binigyang pansin ni Yahweh si Sara gaya ng sinabi niya at tinupad ni Yahweh ang kanyang pangako kay Sara. ");
INSERT INTO tglulb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nabuntis at nagsilang ng isang anak na lalaki si Sara para kay Abraham sa kanyang katandaan, sa itinakdang panahong sinabi ng Diyos sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Pinangalanan ni Abraham bilang Isaac ang kanyang anak na lalaki, siya na isinilang sa kaniya, na isinilang ni Sara para sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tinuli ni Abraham ang kanyang anak na si Isaac nang ito ay walong araw na gulang, ayon sa iniutos ng Diyos sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Si Abraham ay isandaang taong gulang nang isilang si Isaac sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sinabi ni Sara, “Pinatawa ako ng Diyos; tatawa ang bawat isang makakarinig kasama ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sinabi rin niya, “Sinong makapagsasabi kay Abraham na si Sara ay magaalaga ng mga anak, at gayunpaman nagsilang ako sa kanya ng isang anak na lalaki sa kanyang katandaan!” ");
INSERT INTO tglulb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Lumaki ang bata at hiniwalay na sa kanyang ina, at naghanda si Abraham ng isang malaking pagdiriwang sa araw na hiniwalay na si Isaac sa kayang ina. ");
INSERT INTO tglulb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nakita ni Sara na nangungutya ang anak ni Agar na taga-Ehipto, na isinilang niya kay Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kaya sinabi niya kay Abraham, “Palayasin mo ang babaeng aliping ito kasama ang kanyang anak: dahil hindi magiging tagapagmana ang anak ng babaeng aliping iyan kasama ng anak kong si Isaac.” ");
INSERT INTO tglulb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ang bagay na ito ay labis na nagpalungkot kay Abraham dahil sa kanyang anak. ");
INSERT INTO tglulb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ngunit sinabi ng Diyos kay Abraham, “Huwag kang malungkot dahil sa batang lalaki, at dahil sa iyong babaeng lingkod. Pakinggan mo ang lahat ng sinasabi niya tungkol sa bagay na ito, dahil sa pamamagitan ni Isaac makikilala ang mga kaapu-apuhan mo. ");
INSERT INTO tglulb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Gagawin ko ring isang bansa ang anak ng babaeng lingkod, dahil siya ay iyong anak. ");
INSERT INTO tglulb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Maagang bumangon si Abraham, kumuha siya ng tinapay at isang lalagyang tubig at nilagay ito sa balikat ni Agar. Dinala niya ang batang lalaki sa kanya at pinaalis siya. Umalis siya at nagpagala-gala sa ilang na lugar ng Beer-seba. ");
INSERT INTO tglulb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Pagkaubos ng tubig sa lalagyang balat, iniwan niya ang bata sa ilalim ng isang mababang puno. ");
INSERT INTO tglulb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Pagkatapos umalis siya at naupo sa di kalayuan mula sa kanya, na parang isang tudla ng pana ang layo, dahil ang sabi niya, “Huwag ko sanang makita ang kamatayan ng bata.” Habang nakaupo siya roon sa kabila ng bata, nilakasan niya ang kaniyang boses at humagulgol siya sa iyak. ");
INSERT INTO tglulb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Narinig ng Diyos ang boses ng bata, at tumawag ang anghel ng Diyos kay Agar mula sa langit, at sinabi sa kanya, “Anong gumagambala sa iyo, Agar? Huwag kang matakot, sapagkat narinig ng Diyos ang boses ng bata mula sa kanyang kinaroroonan. ");
INSERT INTO tglulb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tumayo ka, ibangon mo ang bata at patatagin siya; sapagkat gagawin ko siyang isang dakilang bansa.” ");
INSERT INTO tglulb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Pagkatapos minulat ng Diyos ang mga mata ni Agar at nakakita siya ng isang balon ng tubig. Pinuntahan niya ito at pinuno ng tubig ang lalagyang gawa sa balat at pinainom ang bata. ");
INSERT INTO tglulb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Sinamahan ng Diyos ang bata, at lumaki siya. Nanirahan siya sa ilang at naging isang mamamana. ");
INSERT INTO tglulb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Namuhay siya sa ilang ng Paran, at kumuha ng mapapangasawa niya ang kaniyang ina mula sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Sa panahong iyon kinausap nila Abimelek at Ficol na kapitan ng kanyang hukbo si Abraham at sinabing, “Kasama mo ang Diyos sa lahat ng iyong ginagawa. ");
INSERT INTO tglulb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kaya ngayon manumpa ka sa Diyos, na hindi mo ako gagawan ng masama, ni ang aking mga anak, ni ang aking mga kaapu-apuhan. Ipakita mo sa akin at sa lupain kung saan ka naninirahan ang parehong katapatan sa kasunduan na ipinakita ko sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","“Nangangako ako” sagot ni Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Nagreklamo rin si Abraham kay Abimelek patungkol sa balon ng tubig na inagaw mula sa kanya ng mga lingkod ni Abimelek. ");
INSERT INTO tglulb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Sinabi ni Abimelek, “Hindi ko alam kung sino ang gumawa ng bagay na ito. Hindi mo ito sinabi sa akin liban ngayon; hindi ko ito narining kundi ngayon.” ");
INSERT INTO tglulb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kaya kumuha si Abraham ng tupa at mga lalaking baka at binigay ang mga ito kay Abimelek, at gumawa ang dalawa ng isang kasunduan. ");
INSERT INTO tglulb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Pagkatapos nagbukod si Abraham ng pitong mga babaeng tupa ng kawan. ");
INSERT INTO tglulb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Sinabi ni Abimelek kay Abraham, “Anong kahulugan nitong pitong babaeng tupang ibinukod mo?” ");
INSERT INTO tglulb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Sumagot siya, “Matatanggap mo mula sa aking kamay itong pitong babaing tupa, upang maging saksi para sa akin, na hinukay ko ang balong ito.” ");
INSERT INTO tglulb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kaya tinawag niya ang lugar na iyong Beer-seba, dahil doon sila kapwa nagsumpaan ng isang kasunduan. ");
INSERT INTO tglulb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Gumawa sila ng isang kasunduan sa Beer-seba, at pagkatapos bumalik si Abimelek at Ficol, ang kapitan ng kanyang hukbo sa lupain ng mga Filisteo. ");
INSERT INTO tglulb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nagtanim si Abraham ng puno ng tamarisko sa Beer-seba. Doon sinamba niya si Yahweh, ang Diyos na walang hanggan. ");
INSERT INTO tglulb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Namalagi si Abraham bilang isang dayuhan sa lupain ng mga Filisteo nang maraming araw. ");
INSERT INTO tglulb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nangyari na pagkatapos ng mga bagay na ito na sinubok ng Diyos si Abraham. Sinabi niya sa kanya, “Abraham!” Sumagot si Abraham, “Narito ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Pagkatapos sinabi ng Diyos, “Kunin mo ang iyong anak, ang kaisa-isa mong anak, na iyong minamahal, si Isaac, at pumunta ka sa lupain ng Moria. Ialay mo siya roon bilang handog na susunugin sa ibabaw ng isa sa mga bundok na ituturo ko sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kaya maagang bumangon kinaumagahan si Abraham, inihanda ang kanyang asno, at isinama ang dalawa sa kanyang mga kabataang lalaki, kasama si Isaac na kanyang anak. Nagsibak siya ng kahoy para sa handog na susunugin, at naglakbay patungo sa lugar na sinabi ng Diyos sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sa ikatlong araw, tumingala si Abraham at natanaw niya ang lugar sa kalayuan. ");
INSERT INTO tglulb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Sinabi ni Abraham sa kanyang mga kabataang lalaki, “Manatili kayo rito kasama ang asno, at pupunta ako roon kasama ang bata. Sasamba kami at muling babalik sa inyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Pagkatapos kinuha ni Abraham ang kahoy para sa handog na susunugin at ipinapasan ito kay Isaac na kanyang anak. Dinala niya sa kanyang kamay ang apoy at ang kutsilyo; at kapwa silang umalis na magkasama. ");
INSERT INTO tglulb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Kinausap ni Isaac si Abraham na kaniyang ama at sinabing, “Aking ama,” at sumagot si Abraham, “Narito ako, aking anak.” Sinabi niya, “Narito, ang apoy at ang kahoy, ngunit nasaan ang tupa para sa handog na susunugin?” ");
INSERT INTO tglulb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Sinabi ni Abraham, “Ang Diyos mismo ang magbibigay ng tupa para sa handog na susunugin, aking anak.” Kaya sila ay nagpatuloy nang magkasama. ");
INSERT INTO tglulb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Nang dumating sila sa lugar na sinabi ng Diyos sa kanya, gumawa si Abraham ng isang altar at inilatag niya ang kahoy dito. Pagkatapos tinalian ni Abraham si Isaac na kanyang anak, at inilagay niya ito sa altar, sa ibabaw ng kahoy. ");
INSERT INTO tglulb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Iniunat ni Abraham ang kanyang kamay na hawak ang kutsilyo para patayin ang kanyang anak. ");
INSERT INTO tglulb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Pero tinawag siya ng anghel ni Yahweh mula sa langit at sinabing, “Abraham, Abraham!” at sinabi niya, “Narito ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Sinabi niya, “Huwag mong pagbuhatan ng kamay, ni gumawa ng anuman para saktan siya, sapagkat ngayon alam kong may takot ka sa Diyos, nakikita kong hindi mo ipinagkait ang iyong anak, ang iyong kaisa-isang anak na si Isaac sa akin. ");
INSERT INTO tglulb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Tumingala si Abraham nang biglang, may isang tupa sa likuran niya ang sumabit ang sungay sa mga halaman. Pinuntahan at kinuha ni Abraham ang tupa at inalay ito bilang handog na susunugin sa Diyos sa halip na ang kanyang anak. ");
INSERT INTO tglulb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kaya tinawag ni Abraham ang lugar na iyon na, “Si Yahweh ang magbibigay,” at tinatwag din hanggang sa araw na ito, “Sa bundok ni Yaweh, ito ay ibibigay.” ");
INSERT INTO tglulb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tinawag ng anghel ni Yahweh si Abraham sa ikalawang pagkakataon mula sa langit ");
INSERT INTO tglulb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","at sinabing—ito ay isang kapahayagan mula kay Yahweh, “Nangangako ako sa aking sarili na dahil ginawa mo ang bagay na ito, at dahil hindi mo ipinagkait ang iyong anak, ang iyong kaisa-isang anak, ");
INSERT INTO tglulb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","tiyak na pagpapalain kita at labis kong pararamihin ang iyong mga kaapu-apuhan gaya ng bituin sa kalangitan, at gaya ng buhangin sa dalampasigan; at aangkinin ng iyong mga kaapu-apuhan ang tarangkahan ng kanilang mga kaaway. ");
INSERT INTO tglulb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Sa pamamagitan ng iyong anak, ang lahat ng mga bansa sa mundo ay pagpapalain, dahil sinunod mo ang aking tinig. ");
INSERT INTO tglulb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kaya bumalik si Abraham sa kanyang mga tauhan, at umalis sila at magkakasamang pumunta sa Beer-seba, at nanirahan siya sa Beer-seba. ");
INSERT INTO tglulb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nangyari na pagkatapos ng mga bagay na ito, sinabihan si Abraham, “Nagkaroon din ng mga anak si Milca, sa iyong kapatid na si Nahor. ");
INSERT INTO tglulb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Sila ay sina Hus ang kanyang panganay, si Buz na kapatid niya, si Kemuel na ama ni Aram, ");
INSERT INTO tglulb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildas, Jidlaf, at Bethuel. ");
INSERT INTO tglulb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Si Bethuel ay naging ama ni Rebeca. May walong anak na isinilang si Milca kay Nahor, na kapatid ni Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nagsilang din si Reumah ang pangalan ng isa pang asawa ni Nahor, sina Tebah, Gaham, Tahas at Maaca. ");
INSERT INTO tglulb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nabuhay si Sara ng isandaan at dalawampu't-pitong taon. Ito ang mga taon ng buhay ni Sara. ");
INSERT INTO tglulb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Namatay si Sara sa Kiriat Arba, iyon ay, Hebron, sa lupain ng Canaan. Nagluksa at umiyak si Abraham para kay Sara. ");
INSERT INTO tglulb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Pagkatapos, tumayo si Abraham at umalis mula sa namatay niyang asawa, at nakipag-usap sa mga anak na lalaki ni Het, na nagsabing, ");
INSERT INTO tglulb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ako ay isang dayuhan sa inyo. Pakiusap bigyan ninyo ako ng isang ari-arian para gawing libingan dito, para mailibing ko ang aking patay.” ");
INSERT INTO tglulb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Sumagot ang mga anak ni Heth kay Abraham, nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Makinig ka sa amin, aking panginoon. Ikaw ay prinsipe ng Diyos sa amin. Ilibing mo ang iyong patay sa aming piling mga libingan. Wala sa amin ang magkakait sa iyo ng libingan, para ilibing ang iyong patay.” ");
INSERT INTO tglulb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tumayo si Abraham at yumuko sa mga mamamayan ng lupain, sa mga anak ni Het. ");
INSERT INTO tglulb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Nagsalita siya sa kanila, na nagsabing, “Kung sumasang-ayon kayo na dapat kong ilibing ang aking patay, dinggin ninyo ako at pakiusapan si Efron na anak ni Zohar, para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Pakiusapan ninyo siyang ipagbili sa akin ang kuweba ng Makpela, na kanyang pagmamay-ari, na nasa dulo ng kanyang bukid. Para sa buong halaga hayaan niyang ipagbili ito sa akin nang hayagan bilang ari-arian para gawing libingan.” ");
INSERT INTO tglulb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ngayon nakaupo si Efron kasama ang mga anak ni Het, at sumagot si Efron ang Heteo kay Abraham habang naririnig ng mga anak ni Het at ng lahat ng mga taong pumunta sa loob ng tarangkahan ng siyudad, na nagsabing, ");
INSERT INTO tglulb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hindi, aking panginoon, pakinggan mo ako. Ibibigay ko sa iyo ang bukid, at ang kuwebang narito. Ibibigay ko ito sa iyo, sa harapan ng mga anak ng aking mga kababayan. Ibibigay ko ito sa iyo para mapaglibingan ng iyong patay.” ");
INSERT INTO tglulb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Pagkatapos yumuko si Abraham sa harapan ng mga mamamayan ng lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Kinausap niya si Ephron na naririnig ng mga tao sa lupain, na nagsasabing, “Ngunit kung papayag ka, pakiusap dinggin mo ako. Babayaran ko ang bukid. Tanggapin mo ang pera mula sa akin, at doon ko ililibing ang aking patay.” ");
INSERT INTO tglulb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Sumagot si Ephron kay Abraham, na nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Pakiusap, aking panginoon, makinig ka sa akin. Ang pirasong lupain na nagkakahalagang apatnaraang shekel ng pilak, ano ba ito sa pagitan natin? Ilibing mo na ang iyong patay.” ");
INSERT INTO tglulb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Nakinig si Abraham kay Efron at tinimbang ni Abraham sa harap ni Efron ang halaga ng pilak na kanyang sinasabi na naririnig ng mga anak ni Het, apatnaraang shekel ng pilak, ayon sa pamantayang panukat ng mga mangangalakal. ");
INSERT INTO tglulb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kaya ang bukid ni Ephron, na nasa Macpela, na katabi ng Mamre, ang bukid, ang kuweba na nasa loob nito, at ang lahat ng mga punong naroon sa bukid at lahat ng nasa palibot ng hangganan, ay ipinasa ");
INSERT INTO tglulb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kay Abraham sa pamamagitan ng pagbili sa harapan ng mga anak ni Het, at sa harapan ng lahat ng mga pumunta sa loob ng tarangkahan ng lungsod. ");
INSERT INTO tglulb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Pagkatapos nito, inilibing ni Abraham ang kanyang asawang si Sara sa kuweba sa bukid ng Macpela, na katabi ng Mamre, iyon ay, Hebron, sa lupain ng Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kaya ang bukid at ang kuwebang naroon ay naipasa kay Abraham mula sa mga anak ni Het bilang ari-arian upang gawing libingan. ");
INSERT INTO tglulb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ngayon, matanda na si Abraham at pinagpala ni Yahweh si Abraham sa lahat ng mga bagay. ");
INSERT INTO tglulb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Sinabi ni Abraham sa kanyang lingkod, ang pinakamatanda sa kanyang sambahayan, ang kaniyang katiwala sa lahat ng pag-aari niya, “Ilagay mo ang iyong kamay sa ilalim ng aking hita ");
INSERT INTO tglulb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","at pasusumpain kita kay Yahweh, ang Diyos ng langit at ang Diyos ng lupa, na hindi ka kukuha ng asawa para sa aking anak na lalaki mula sa mga anak na babae ng mga Cananeo, kung saan ako nanahan. ");
INSERT INTO tglulb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ngunit pumunta ka sa aking bansa, at sa aking mga kamag-anak, at kumuha ng isang asawa para sa aking anak na si Isaac.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Sinabi ng lingkod sa kanya, “Paano kung hindi pamayag na sumama sa akin ang babae papunta sa lupaing ito? Dapat ko bang dalhin pabalik ang iyong anak sa lupain kung saan ka nanggaling? ");
INSERT INTO tglulb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Sinabi ni Abraham sa kanya, “Tiyakin mong hindi mo dadalhin ang aking anak pabalik doon! ");
INSERT INTO tglulb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Si Yahweh, ang Diyos ng langit, na kumuha sa akin mula sa tahanan ng aking ama at mula sa lupain ng aking mga kamag-anak, siya na taimtim na nangako sa aking, 'Ibibigay ko ang lupaing ito sa iyong supling,' ipapadala niya ang kanyang anghel para manguna sa iyo, at kukuha ka ng asawa para sa aking anak mula roon. ");
INSERT INTO tglulb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ngunit kung hindi papayag ang babae na sumunod sa iyo, kung gayon magiging malaya ka mula sa kasunduang kong ito. Huwag mo lang dalhin pabalik doon ang aking anak. ");
INSERT INTO tglulb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kaya niligay ng lingkod ni Abraham ang kanyang kamay sa ilalim ng hita ng kanyang among si Abraham at nanumpa sa kanya patungkol sa bagay na ito. ");
INSERT INTO tglulb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kinuha ng lingkod ang sampung kamelyo ng kanyang amo at umalis. Nagdala rin siya ng lahat ng uri ng mga regalo mula sa kanyang amo. Umalis siya at pumunta sa rehiyon ng Aram Naharaim, sa siyudad ni Nahor. ");
INSERT INTO tglulb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pinaluhod niya ang mga kamelyo sa gilid ng balon ng tubig sa labas ng siyudad. Gabi na iyon, ang oras na lumalabas ang mga babae upang sumalok ng tubig. ");
INSERT INTO tglulb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Pagkatapos sinabi niya, “Yahweh, Diyos ng aking among si Abraham, bigyan mo ako ngayon ng tagumpay at ipakita ang iyong tipan ng katapatan sa aking among si Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Masdan, narito akong nakatayo sa tabi ng bukal ng tubig, at dumarating ang mga babaing anak ng mga tao ng siyudad upang sumalok ng tubig. ");
INSERT INTO tglulb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ganito nawa ang mangyari. Kapag sabihin ko sa isang dalaga, 'Pakiusap ibaba mo ang iyong pitsel upang makainom ako,' at sabihin niya sa akin, 'Uminom ka, at paiinumin ko rin ang iyong mga kamelyo,' pagkatapos ay hayaang siya na nga ang babaing iyong itinakda para sa iyong lingkod na si Isaac. Sa pamamgitan nito malalaman kong nagpakita ka ng tipan ng katapatan sa aking amo.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Nangyari na bago paman siya natapos sa pagsasalita, masdan, lumabas si Rebeca na may dalang pitsel ng tubig sa kanyang balikat. Ipinanganak si Rebeca kay Bethuel na lalaking anak ni Milca, na asawa ni Nahor, na lalaking kapatid ni Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ang dalaga ay napakaganda at isang birhen. Wala pang lalaki ang sumiping sa kanya. Pumunta ang babae sa bukal at pinuno ang kanyang pitsel, at umahon. ");
INSERT INTO tglulb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Tumakbo ang lingkod upang salubungin siya at sinabing, “Pakiusap bigyan mo ako ng kaunting inuming tubig mula sa iyong pitsel. ");
INSERT INTO tglulb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Sinabi niya, “Uminon ka, aking amo,” at agad niyang ibinaba ang pitsel na nasa kanyang kamay, at pinainom siya. ");
INSERT INTO tglulb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nang natapos niya siyang painumin, sinabi niya, sasalok din ako ng tubig para sa iyong mga kamelyo, hanggang sa makainom na ang lahat. ");
INSERT INTO tglulb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kaya nagmadali siya at ibinuhos ang laman ng kanyang pitsel papunta sa inuman ng mga hayop, at tumakbong muli patungo sa balon upang sumalok ng tubig, at sumalok ng tubig para sa lahat ng kanyang mga kamelyo. ");
INSERT INTO tglulb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tahimik na pinanood siya ng lalaki upang makita kung pinagpala ni Yahweh ang kanyang paglalakbay o hindi. ");
INSERT INTO tglulb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Nang natapos sa pag-inom ang mga kamelyo, inilabas ng lalaki ang isang gintong singsing sa ilong na tumitimbang ng kalahating siklo, at dalawang gintong pulseras para sa kanyang mga braso na tumitimbang ng sampung siklo ");
INSERT INTO tglulb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","at nagtanong, “Kaninong anak ka? Pakiusap sabihin mo sa akin, mayroon bang silid ang bahay ng ama mo na maaari naming pagpalipasan ng gabi?” ");
INSERT INTO tglulb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Sinabi niya sa kanya, “Anak ako ni Bethuel na lalaking anak ni Milcah, na ipinanganak niya kay Nahor.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Sinabi rin niya sa kanya, “Marami kami ng kapwa dayami at pagkain ng hayop, at may silid din para kayo magpalipas ng gabi.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Pagkatapos yumuko ang lalaki at sumamba kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Sinabi niya, “Pagpalain si Yahweh, ang Diyos ng aking among si Abraham, na hindi pinabayaan ang kanyang tipan ng katapatan at kanyang pagiging mapagkakatiwalaan patungo sa aking amo. Para sa akin, tuwiran akong pinangunahan ni Yahweh sa bahay ng mga kamag-anak ng aking amo.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Pagkatapos tumakbo ang dalaga at sinabi sa sambahayan ng kanyang ina ang tungkol sa lahat ng bagay na ito. ");
INSERT INTO tglulb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ngayon si Rebeca ay mayroong isang kapatid na lalaki, at ang pangalan niya ay Laban. Tumakbo si Laban papunta sa lalaki na naroon sa labas sa daan sa tabi ng bukal. ");
INSERT INTO tglulb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Nang nakita niya ang singsing sa ilong at ang mga pulseras na nasa kamay ng kanyang kapatid na babae, at nang narinig niya ang mga salita ni Rebeca na kanyang kapatid, “Ito ang sinabi ng lalaki sa akin,” pumunta siya sa lalaki, at masdan, nakatayo siya sa tabi ng mga kamelyong nasa bukal. ");
INSERT INTO tglulb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","At sinabi ni laban, “Halika, ikaw na pinagpala ni Yahweh. Bakit ka nakatayo riyan sa labas? Inihanda ko ang bahay, at isang lugar para sa mga kamelyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kaya pumunta ang lalaki sa bahay at diniskargahan niya ng mga kamelyo. Binigyan ang mga kamelyo ng dayami at pagkain ng hayop, naglaan ng tubig upang hugasan ang kanyang mga paa at ang mga paa ng mga lalaking kasama niya. ");
INSERT INTO tglulb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Naglapag sila ng pagkain sa harapan niya upang kainin, ngunit sinabi niya, “Hindi ako kakain hanggang sa masabi ko ang kailangan kong sabihin.” Kaya sinabi ni Laban, “Magsalita ka”. ");
INSERT INTO tglulb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Sinabi niya, “Lingkod ako ni Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Pinagpala ng lubos ni Yahweh ang aking amo at naging dakila siya. Binigyan siya ng mga kawan at mga pangkat ng hayop, pilak at ginto, mga lingkod na lalaki at mga lingkod na babae, at mga kamelyo at mga asno. ");
INSERT INTO tglulb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Si Sara, ang asawa ng aking amo, ay nagsilang ng isang anak na lalaki sa aking amo nang siya ay matanda na, at ibinigay niya ang lahat ng kanyang mga aria-arian sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pinanumpa ako ng aking amo, nagsasabing, “Hindi ka dapat kumuha ng isang asawa para aking anak mula sa mga babaeng anak ng mga Cananeo, sa lupaing ginagawa kong tahanan. ");
INSERT INTO tglulb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Sa halip, dapat kang pumunta sa pamilya ng aking ama, at sa aking mga kamag-anak, at kumaha ng isang asawa para sa aking anak.' ");
INSERT INTO tglulb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Sinabi ko sa aking amo, 'Baka hindi susunod sa akin ang babae.' ");
INSERT INTO tglulb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ngunit sinabi niya sa akin, 'Si Yahweh, na aking sinusunod, ay magpapadala ng kanyang anghel na makakasama mo at siya ay papatnubayan ang landas mo, upang makakakuha ka ng isang asawa para sa aking anak mula sa aking mga kamag-anak at mula sa linya na pamilya ng aking ama. ");
INSERT INTO tglulb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ngunit magiging malaya ka lamang mula sa aking tagubilin kung darating ka sa aking mga kamag-anak at hindi nila siya ibibigay sa iyo. Sa gayon magiging malaya ka mula sa aking kasunduan.' ");
INSERT INTO tglulb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kaya dumating ako ngayon sa bukal, at sinabi, 'O Yahweh, Dios ng aking among si Abraham, pakiusap, kung tunay na nais mong magtagumpay ang aking paglalakbay— ");
INSERT INTO tglulb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","narito ako, nakatayo sa gilid ng bukal ng tubig—hayaang ang babaing lumabas para sumalok ng tubig, ang babaing sasabihan kong, “Pakiusap bigyan mo ako ng kaunting tubig mula sa iyong pitsel upang inumin,” ");
INSERT INTO tglulb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ang babaing magsasabi sa akin, “Uminom ka, at sasalok din ako ng tubig para sa iyong mga kamelyo”—hayaang siya na nga ang babaing pinili mo, Yahweh, para sa anak ng aking amo.' ");
INSERT INTO tglulb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Bago pa man ako natapos mangusap sa aking puso, masdan, lumabas si Rebeca dala ang pitsel na pasan sa kanyang balikat at bumaba patungong bukal at sumalok ng tubig. Kaya sinabi ko sa kanya, 'Pakiusap bigyan mo ako ng maiinom.' ");
INSERT INTO tglulb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Agad niyang ibinaba ang kanyang pitsel mula sa kanyang balikat, at nagsabing, “Uminom ka, at bibigyan ko rin ng tubig ang iyong mga kamelyo.' Kaya uminom ako, at pinainom niya rin ang mga kamelyo. ");
INSERT INTO tglulb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Tinanong ko siya at sinabing, 'Kaninong anak ka?' Sinabi niya, 'Ang babaing anak ni Bethuel, na lalaking anak ni Nahor, na isinilang ni Milcah sa kanya.' Pagkatapos inilagay ko ang singsing sa kanyang ilong at ang pulseras sa kanyang mga braso. ");
INSERT INTO tglulb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Pagkatapos lumuhod ako at sinamba si Yahweh, at pinagpala si Yahweh, ang Diyos ng aking among si Abraham, ang siyang nanguna sa akin sa tamang landas upang matagpuan ang babaing anak ng kamag-anak ng aking amo para sa kanyang anak. ");
INSERT INTO tglulb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kaya ngayon, kung handa kayong pakitunguhan ang aking amo ng pampamilyang katapatan at pagtitiwala, sabihin ninyo sa akin. Ngunit kung hindi, sabihin ninyo sa akin, upang lumiko ako sa kanang kamay, o sa kaliwa.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Pagkatapos sumagot si Laban at Bethuel at sinabing, “Ang bagay na ito ay nagmula kay Yahweh; hindi kami makapagsasabi sa iyo ng masama o mabuti. ");
INSERT INTO tglulb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Masdan, nasa harapan mo si Rebeca. Dalhin mo siya at humayo, upang siya ay maging asawa ng anak ng iyong amo, gaya ng sinabi ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Nang narinig ng lingkod ni Abraham ang lahat ng kanilang mga salita, iniyuko niya pababa ang kanyang sarili sa lupa kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Inilabas ng lingkod ang mga kagamitang pilak at mga kagamitang ginto, at damit, at binigay ang mga ito kay Rebeca. Nagbigay din siya ng mga mamahaling regalo sa kapatid niyang lalaki at sa kanyang ina. ");
INSERT INTO tglulb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Pagkatapos kumain at uminom siya at ang mga lalaking kasama niya. Nanatili sila roon magdamag, at nang bumangon sila sa umaga, sinabi niya, “Ipadala na ninyo ako sa aking amo.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Sinabi ng kanyang kapatid na lalaki at ng kanyang ina, “Hayaan mo munang manatili kasama namin ang dalaga ng mga ilang araw pa, kahit sampu. Pagkatapos niyan maaari na siyang umalis.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ngunit sinabi niya sa kanila, “Huwag ninyo akong hadlangan, yamang pinagpala ni Yahweh ang aking landas. Ipadala na ninyo ako sa aking landas upang makapunta sa aking amo.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Sinabi nila, “Tatawagin namin ang dalaga at tatanungin siya.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kaya tinawag nila si Rebeca at tinanong siya, “Sasama ka ba sa lalaking ito?” Sumagot siya, “Sasama ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kaya pinadala nila ang kanilang kapatid na si Rebeca, kasama ang kanyang babaing lingkod, sa kanyang paglalakbay kasama ang lingkod ni Abraham at kanyang mga kasamahang lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Pinagpala nila si Rebeca, at sinabi sa kanya, “Aming kapatid, nawa maging ina ka ng mga libu-libo ng sampung libo, at nawa ang iyong mga kaapu-apuhan ay angkinin ang tarangkahan ng mga galit sa kanila.” ");
INSERT INTO tglulb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Pagkatapos tumayo si Rebeca, at siya at ang kanyang mga lingkod na babae ay sumakay sa mga kamelyo, at sumunod sa lalaki. Kaya kinuha ng lingkod si Rebeca, at lumakad na sa kanyang landas. ");
INSERT INTO tglulb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ngayon naninirahan si Isaac sa Negev, at kababalik lang galing Beerhalohai. ");
INSERT INTO tglulb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lumabas si Isaac upang magnilaynilay sa bukid sa gabi. Nang tumingala siya at nakita, masdan, mayroong mga kamelyong parating! ");
INSERT INTO tglulb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tumingin si Rebeca, at nang nakita niya si Isaac, tumalon siya pababa mula sa kamelyo. ");
INSERT INTO tglulb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Sinabi niya sa lingkod, sino iyong lalaking naglalakad sa bukid upang salubungin tayo?” Sinabi ng lingkod, “Iyon ang aking amo.” Kaya kinuha niya ang kanyang belo, at tinakpan ang sarili. ");
INSERT INTO tglulb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Isinalaysay ng lingkod kay Isaac ang lahat ng mga bagay na kanyang ginawa. ");
INSERT INTO tglulb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Pagkatapos dinala ni Isaac si Rebeca sa loob tolda ng kanyang inang si Sara at kinuha si Rebeca, at siya ay naging kanyang asawa, at siya ay minahal niya. Kaya naginhawahan si Isaac matapos ang kamatayan ng kanyang ina. ");
INSERT INTO tglulb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Kumuha ng isa pang asawa si Abraham; ang kanyang pangalan ay Keturah. ");
INSERT INTO tglulb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Isinilang niya sina Zimran, Jokshan, Medan, Midian, Ishbak, at si Shuah. ");
INSERT INTO tglulb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Si Jokshan ay naging ama nina Sheba at Dedan. Ang mga kaapu-apuhan ni Dedan ay ang lahi ng Assyria, ang lahi ng Letush at ang lahi ng Leum. ");
INSERT INTO tglulb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ang mga anak na lalaki ni Midian ay sina Ephah, Epher Hanoch, Abida at si Eldaah. Lahat ng mga ito ay mga kaapu-apuhan ni Keturah. ");
INSERT INTO tglulb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibinigay ni Abraham ang lahat ng kanyang pag-aari kay Isaac. ");
INSERT INTO tglulb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Subalit, habang siya ay nabubuhay pa, nagbigay siya ng mga regalo sa kanyang mga anak na lalaki sa kanyang mga kerida at pinadala sila sa lupain ng silangan, malayo mula sa kanyang anak na si Isaac. ");
INSERT INTO tglulb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ito ang naging mga araw ng mga taon sa buhay ni Abraham na kanyang ibinuhay, 175 na mga taon. ");
INSERT INTO tglulb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Inihinga ni Abraham ang kanyang huli at namatay sa isang kalugud-lugud na katandaan, isang matandang lalaking puno ng buhay. At siya ay natipon sa kanyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Sina Isaac at Ismael, na kanyang mga anak, ay inilibing siya sa kuweba ng Macpela, sa lupain ni Epron na anak na lalaki ni Zohar na mga anak ni Heth, na malapit sa Mamre. ");
INSERT INTO tglulb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ang lupang ito ay binili ni Abraham mula sa mga anak na lalaki ni Heth. Si Abraham ay inilibing doon kasama ng kanyang asawang si Sara. ");
INSERT INTO tglulb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pagkatapos ng kamatayan ni Abraham, pinagpala ng Diyos si Isaac na kanyang anak, at si Isaac ay nanirahan malapit sa Beer-lahai-roi. ");
INSERT INTO tglulb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ngayon ang mga ito ay ang mga kaapu-apuhan ni Ismael, na anak na lalaki ni Abraham, kay Hagar na taga Ehipto, na lingkod ni Sara, nagsilang mula kay Abraham. ");
INSERT INTO tglulb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ang mga ito ay ang mga pangalan ng mga anak na lalaki ni Ismael, ayon sa pagkakasunud-sunud ng kapanganakan: Nebayot—ang panganay ni Ismael, Kedar, Abdeel, Mibsam, ");
INSERT INTO tglulb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO tglulb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafis at Kedama. ");
INSERT INTO tglulb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ito ang mga anak na lalaki ni Ismael, at ang mga ito ay ang kanilang mga pangalan, ayon sa kanilang mga nayon, at sa kanilang mga kampo; labindalawang prinsipe ayon sa kanilang mga tribu. ");
INSERT INTO tglulb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ang mga ito ay ang mga taon sa buhay ni Ismael, 137 na mga taon: inihinga niya ang kanyang huli at namatay, at natipon sa kanyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Sila ay nanirahan mula sa Havila hanggang Shur, na malapit sa Ehipto, nagkaisa sila na pumunta sa Assyria. Nanirahan silang may poot sa bawat isa. ");
INSERT INTO tglulb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ang mga ito ay ang mga pangyayari patungkol kay Isaac, na anak na lalaki ni Abraham: Si Abraham ang naging ama ni Isaac. ");
INSERT INTO tglulb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Si Isaac ay apatnapung taong gulang nang mapangasawa niya si Rebeca, na anak na babae ni Bethuel ang Arameo ng Padan-aram, ang kapatid na babae ni Laban na Arameo. ");
INSERT INTO tglulb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nagdasal si Isaac kay Yahweh para sa kanyang asawa dahil wala itong anak, at sinagot ni Yahweh ang kanyang dasal, at si Rebeca na kanyang asawa ay nabuntis. ");
INSERT INTO tglulb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ang mga bata ay magkasamang nagtunggali sa loob niya at sinabi niya, “Bakit ito nangyayari sa akin?” Tinanong niya si Yahweh tungkol dito. ");
INSERT INTO tglulb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Sinabi ni Yahweh sa kanya, “Dalawang bansa ang nasa iyong sinapupunan, at dalawang bayan ang mahihiwalay mula sa iyong loob. Isang bayan ang magiging mas malakas kaysa sa isa, at ang nakatatanda ay maglilingkod sa nakababata.” ");
INSERT INTO tglulb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nang oras na para siya ay manganak, masdan mo, mayroong kambal sa kanyang sinapupunan. ");
INSERT INTO tglulb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","At ang unang lumabas ay nababalutan ng pula gaya ng mabalahibong damit. Tinawag nila siya sa kanyang pangalan na Esau. ");
INSERT INTO tglulb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Pagkatapos noon, ang kanyang kapatid ay lumabas. Ang kanyang kamay ay nakakapit sa sakong ni Esau. Siya ay tinawag na Jacob. Si Isaac ay animnapung taong gulang nang ang kanyang asawa ay nagsilang sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ang mga bata ay lumaki na, at si Esau ay naging mahusay na mangangaso, isang taong sanay sa gubat; subalit si Jacob ay isang tahimik na tao, na ginugugul ang kanyang oras sa mga tolda. ");
INSERT INTO tglulb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ngayon minahal ni Isaac si Esau dahil nakakain nya ang mga hayop na kanyang nahuli, subalit si Rebeca ay minahal si Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Si Jacob ay nagluto ng nilaga. Dumating si Esau mula sa gubat, at siya ay nanghihina sa gutom. ");
INSERT INTO tglulb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Sinabi ni Esau kay Jacob, “Pakainin mo ako niyang mapulang nilaga. Pakiusap, ako ay pagod!” Kaya iyon ang dahilan na ang kanyang pangalan ay tinawag na Edom. ");
INSERT INTO tglulb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Sinabi ni Jacob, “Ipagbili mo muna sa akin ang iyong karapatan bilang panganay.” ");
INSERT INTO tglulb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Sabi ni Esau “Tingnan mo, ako ay halos mamamatay na. Ano ang kabutihan ng karapatan ng unang isinilang sa akin?” ");
INSERT INTO tglulb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Sinabi ni Jacob, “Manumpa ka muna sa akin.” Kaya sumumpa si Esau at sa ganung paraan ipinagbili niya kay Jacob ang kanyang karapatan ng unang pagkasilang. ");
INSERT INTO tglulb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Binigyan ni Jacob si Esau ng tinapay at nilagang mga lentil. Siya ay kumain at uminom, pagkatapos ay tumayo at nagpatuloy sa kanyang lakad. Sa ganitong paraan kinamuhian ni Esau ang kanyang karapatan ng unang isinilang. ");
INSERT INTO tglulb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ngayon, may taggutom sa lupain, bukod pa sa naunang taggutom na nagkaroon sa panahon ni Abraham. Pumunta si Isaac kay Abimelec, ang hari ng Filisteo sa Gerar. ");
INSERT INTO tglulb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ngayon nagpakita si Yahweh sa kanya at sinabi, “Huwag kang pumunta sa Ehipto; tumira ka sa lugar na sinabi ko na iyong pagtirhan. ");
INSERT INTO tglulb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Manatili ka sa lugar na ito, at ako ay sumasainyo at pagpapalain ko kayo; para sa iyo at sa iyong mga kaapu-apuhan, ibibigay ko ang lahat ng mga lupaing ito, at tutuparin ko ang panunumpa na aking sinumpaan kay Abraham na iyong ama. ");
INSERT INTO tglulb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Pararamihin ko ang iyong mga kaapu-apuhan gaya ng mga bituin sa langit, at ibibigay sa iyong mga kaapu-apuhan ang lahat na mga lupaing ito. Sa pamamagitan ng iyong mga kaapu-apuhan ang lahat ng bansa sa lupa ay pagpapalain. ");
INSERT INTO tglulb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Gagawin ko ito dahil sinunod ni Abraham ang aking utos at sinunod niya ang aking mga tagubilin, mga utos ko at mga batas ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kaya namalagi si Isaac sa Gerar. ");
INSERT INTO tglulb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Nang tanungin siya ng mga kalalakihan sa lugar tungkol sa kanyang asawa, sinabi nya, “Siya ay aking kapatid na babae.” Natakot siyang sabihin, “Siya ay aking asawa,” dahil naisip niya, “Ang mga lalaki sa lugar na ito ay papatayin ako para makuha si Rebeca dahil napakaganda niya.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Pagkatapos, nagtagal si Isaac doon, Si Abimelec ang hari ng mga Filisteo ay nagkataong tumingin sa labas sa bintana. Nakita niya, masdan, si Isaac na nilalambing si Rebeca, na kanyang asawa. ");
INSERT INTO tglulb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ipinatawag ni Abimelec si Isaac sa kanya at sinabi, “Tingnan mo, tiyak nga na siya ay iyong asawa. Bakit mo sinabi, 'Siya ay aking kapatid na babae'?” Sinabi ni Isaac sa kanya, “Dahil naisip ko na maaring mayroong pumatay sa akin para makuha siya.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Sinabi ni Abimelec, “Ano itong ginawa mo sa amin? Maaring may taong madaling sumiping sa iyong asawa, at madala mo sa amin ang pagkakasala.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kaya binalaan ni Abimelec ang lahat ng mga tao at sinabi, “Kung sino man ang gumalaw sa taong ito o sa kanyang asawa ay tiyak na malalagay sa kamatayan.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nagtanim si Isaac sa lupaing iyon at umani sa parehong taon ng isang sandaang beses, dahil pinagpala siya ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Naging mayaman siya, at lumago ng higit-higit pa hanggang siya ay naging napakadakila. ");
INSERT INTO tglulb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Mayroon siyang maraming tupa at mga baka, at isang malaking sambahayan. Ang mga Filisteo ay kinaiinggitan siya. ");
INSERT INTO tglulb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ngayon ang lahat ng mga balon na hinukay ng mga lingkod ng kanyang ama sa panahon ni Abraham, na hininto ng mga Palestina sa pamamagitan ng pag-tambak ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Sinabi ni Abimelec kay Isaac, “Umalis ka palayo sa amin, dahil mas makapangyarihan ka kaysa sa amin.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kaya umalis si Isaac mula doon at namalagi sa lambak ng Gerar, at nanirahan doon. ");
INSERT INTO tglulb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Muling hinukay ni Isaac ang mga balon ng tubig, na hinukay nila noong panahon ni Abraham na kanyang ama. Pinahinto sila ng mga Filisteo pagkatapos mamatay ni Abraham. Tinawag ni Isaac ang mga balon sa parehong mga pangalan na binigay ng kanyang ama dito. ");
INSERT INTO tglulb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Nang naghukay ang mga lingkod ni Isaac sa lambak, nakita nila doon ang isang balong dumadaloy ang tubig. ");
INSERT INTO tglulb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ang mga pastol na lalaki ng Gerar ay nakipag-away sa mga pastol na lalaki ni Isaac, at sinabi “Ang tubig na ito ay sa amin.” Kaya tinawag ni Isaac ang balon na iyon na “Esek,” dahil nakipag-away sila sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Pagkatapos naghukay sila ng isa pang balon, at nag-away rin sila nito, kaya binigyan niya ito ng pangalang “Sitnah.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Umalis siya doon at naghukay muli ng isa pang balon, subalit hindi na nila pinag-awayan ang isang iyon. Kaya tinawag niya itong Rehobot, at sinabi niya, “Ngayon ay gumawa si Yahweh ng kaluwagan sa amin, at tayo ay sasagana sa lupa.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Pagkatapos pumunta si Isaac mula doon patungong Beer-seba. ");
INSERT INTO tglulb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nagpakita si Yahweh sa kanya sa gabi ring iyon at sinabing, “Ako ang Diyos ng iyong amang si Abraham. Huwag kang matakot, sapagkat ako ay kasama mo at pagpapalain kita at pararamihin ang iyong mga kaapu-apuhan, alang-alang sa aking lingkod na si Abraham.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Nagtayo si Isaac ng altar doon at tumawag sa pangalan ni Yahweh. Nagtindig siya ng tolda doon, at ang kanyang mga lingkod ay naghukay ng balon. ");
INSERT INTO tglulb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Pagkatapos si Abimelec ay pumunta sa kanya mula sa Gerar, kasama si Ahuzat, kanyang kaibigan, at si Picol, ang kapitan ng kanyang hukbo. ");
INSERT INTO tglulb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Sinabi ni Isaac sa kanila, “Bakit kayo naparito sa akin, samantalang galit kayo sa akin at pinaalis ninyo ako palayo sa inyo?” ");
INSERT INTO tglulb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","At sinabi nila, “Malinaw naming nakita na si Yahweh ay iyong kasama. Kaya napagpasyahan namin na dapat ay mayroong sumpaan sa pagitan natin, oo, sa pagitan mo at sa amin. Kaya gagawa kami ng tipan sa iyo, ");
INSERT INTO tglulb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","na hindi mo kami sasaktan, gaya ng hindi namin pananakit sa iyo, at sa pakikitungo namin ng mabuti sa iyo at sa pagpapaalis namin sa iyo ng mapayapa. Tunay nga, ikaw ay pinagpala ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kaya gumawa si Isaac ng pista para sa kanila, at sila ay kumain at uminom. ");
INSERT INTO tglulb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Bumangon sila ng maaga kinabukasan at sila ay nagsumpaan sa bawat isa. Pagkatapos pinaalis sila ni Isaac, at siya ay iniwan nila ng mapayapa. ");
INSERT INTO tglulb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nang araw ding iyon dumating ang mga lingkod ni Isaac at sinabi sa kanya tungkol sa balong kanilang hinukay. Sinabi nila, “Nakakita kami ng tubig”, ");
INSERT INTO tglulb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Tinawag niya ang balon na Seba, kaya ang pangalan ng lungsod na iyon ay Beer-seba hanggang sa araw na ito. ");
INSERT INTO tglulb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Nang si Esau ay apatnapung taong gulang na, siya ay nag-asawa, si Judit ang anak ni Beeri na mga anak ni Heth, at saka si Basemat ang anak na babae ni Elon na mga anak ni Heth. ");
INSERT INTO tglulb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Sila ay nagdala ng kalungkutan kay Isaac at Rebeca. ");
INSERT INTO tglulb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Nang matanda na si Isaac at ang kanyang mga mata ay malabo na kaya hindi na siya makakita, tinawag niya ang nakatatandang anak niyang si Esau. Sinabi niya, “Anak ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Sumagot ito, “Narito po ako.” Sinabi niya rito, “Tumingin ka rito, matanda na ako. Hindi ko alam ang araw ng aking kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kaya kunin mo ang iyong mga sandata, ang iyong sisidlan ng palaso at pana at mangaso ka sa bukid para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Gawan mo ako ng masarap na pagkain na gusto ko at dalhin mo iyon sa akin para makain ko iyon at pagpalain ka bago ako mamatay.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ngayon narinig ni Rebeca nang kausapin ni Isaac si Esau na kanyang anak. Nagpunta si Esau sa bukid para mangaso ng hayop at dalhin ito pauwi. ");
INSERT INTO tglulb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Kinausap ni Rebeca si Jacob na kanyang anak at sinabi, “Tumingin ka rito, narinig kong kinausap ng iyong ama ang kapatid mong si Esau. Sinabi niya ");
INSERT INTO tglulb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Dalhan mo ako ng pinangasong hayop at gawan ako ng masarap na pagkain, upang kainin ko ito at pagpapalain ka sa harap ni Yahweh bago ang aking kamatayan.' ");
INSERT INTO tglulb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kaya ngayon, anak ko, sundin mo ang tinig ko habang inuutusan kita. ");
INSERT INTO tglulb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pumunta ka sa kawan at dalhan mo ako ng dalawang batang kambing; at magluluto ako ng masarap na pagkain para sa ama mo, na katulad ng gusto niya. ");
INSERT INTO tglulb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Dadalhin mo ito sa kanya para kainin upang ikaw ay pagpalain niya bago ang kanyang kamatayan.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Sinabi ni Jacob sa kanyang inang si Rebeca, “Tingnan ninyo, ang kapatid kong si Esau ay mabalahibo, at ako ay makinis na tao. ");
INSERT INTO tglulb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Malamang himasin ako ng ama ko, at ako ay magmimistulang manlilinlang sa kanya. Magdadala ako ng isang sumpa sa aking sarili at hindi pagpapala.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sinabi sa kanya ng kanyang ina, “Anak ko, hayaan mong mapunta sa akin ang anumang sumpa. Basta sundin mo ang tinig ko, at umalis ka, at dalhin mo ang mga iyon sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kaya kinuha ni Jacob ang dalawang batang kambing at dinala ang mga ito sa kanyang ina, at ang kanyang ina ay gumawa ng masarap na pagkain katulad ng gusto ng kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kinuha ni Rebeca ang pinakamagandang damit ni Esau, na nakatatandang anak niya, na nasa kanya sa bahay, at ipinasuot ito kay Jacob, na nakababatang anak niya. ");
INSERT INTO tglulb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Inilagay niya ang balat ng batang kambing sa mga kamay niya at sa makinis na bahagi ng leeg niya. ");
INSERT INTO tglulb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Inilagay niya ang inihanda niyang masarap na pagkain at ang tinapay sa kamay ng anak niyang si Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Pumunta si Jacob sa kanyang ama at nagsabi, “Ama ko.” Sinabi niya, “Narito ako; sino ka, anak ko?” ");
INSERT INTO tglulb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Sinabi ni Jacob sa kanyang ama, “Ako si Esau na unang anak mo; nagawa ko na ang sinabi mo sa akin. Umupo ka at kainin ang aking napangaso upang pagpalain mo ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Sinabi ni Isaac sa kanyang anak, “Paano mo itong natagpuan nang napakabilis, anak ko?” Sinabi niya, “Dahil si Yahweh na iyong Diyos ay dinala ito sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Sinabi ni Isaac kay Jacob, “Lumapit ka upang mahimas kita at malaman kung ikaw ang tunay kong anak na si Esau o hindi.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Pumunta si Jacob sa kanyang amang si Isaac, at hinimas siya ni Isaac at sinabi niya, “Ang tinig ay tinig ni Jacob, ngunit ang mga kamay ay mga kamay ni Esau. ");
INSERT INTO tglulb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Hindi siya nakilala ni Isaac dahil ang kanyang mga kamay ay mabalahibo, katulad ng mga kamay ng kapatid niyang si Esau, kaya pinagpala siya ni Isaac. ");
INSERT INTO tglulb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Sinabi niya, “Ikaw ba talaga ang anak kong si Esau?” Sumagot siya, “Ako nga.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Sinabi ni Isaac, “Dalhin mo sa akin ang pagkain at kakainin ko ang napangaso mo upang mapagpala kita.” Dinala ni Jacob sa kanya ang pagkain. Kumain si Isaac, at dinalhan siya ni Jacob ng alak, at siya ay uminom. ");
INSERT INTO tglulb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Sinabi ng kanyang amang si Isaac, “Lumapit ka sa akin at hagkan mo ako, anak ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Lumapit si Jacob at hinalikan siya, at naamoy niya ang amoy ng kanyang damit at pinagpala siya. Sinabi nya, “Tingnan mo, ang amoy ng aking anak ay katulad ng amoy ng isang bukid na pinagpala ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nawa bigyan ka ng Diyos ng isang bahagi ng hamog ng langit, isang bahagi ng katabaan ng lupa, at masaganang mga butil at bagong alak. ");
INSERT INTO tglulb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nawa ang mga tao ay maglingkod sa iyo at yumuko sa iyo ang mga bansa. Maging amo ka ng iyong mga kapatid na lalaki, at nawa ang mga anak ng iyong ina ay yumuko sa iyo. Nawa ang bawat isang sumumpa sa iyo ay sumpain; at nawa ang bawat isang magpala sa iyo ay pagpalain.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Matapos pagpalain ni Isaac si Jacob, at bahagya pa siyang lumayo sa presensya ng ama niyang si Isaac, noon naman dumating ang kapatid niyang si Esau mula sa pangangaso. ");
INSERT INTO tglulb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Gumawa rin siya ng masarap na pagkain at dinala iyon sa kanyang ama. Sinabi niya, “Ama, bumangon ka at kainin mo ang ilan sa napangaso ng iyong anak upang mapagpala mo ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ang kanyang amang si Isaac ay nagsabi sa kanya, “Sino ka?” Sinabi niya, “Ako ang anak mo, ang unang anak mong si Esau.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nanginig nang matindi si Isaac at nagsabi, “Sino pala iyon na nangaso ng hayop na ito at dinala sa akin? Kinain ko lahat ito bago ka dumating, at pinagpala ko siya. Tunay nga, siya ay pagpapalain.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Nang marinig ni Esau ang mga salita ng kanyang ama, siya ay umiyak nang napakalakas at umiyak ng may kapaitan, sinabi sa kanyang ama, “Ako rin, pagpalain mo ako, ama ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Sinabi ni Isaac, “Mapanlilinlang na naparito ang kapatid mo at inagaw ang iyong pagpapala.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Sinabi ni Esau, “Hindi ba tama lang na pinangalanan siyang Jacob? Dahil dinaya niya ako sa dalawang pagkakataong ito. Inagaw niya ang aking karapatan ng isinilang at tingnan mo, ngayon ay inagaw niya ang aking pagpapala.” At sinabi niya, “Wala ka bang naitabing pagpapala para sa akin?” ");
INSERT INTO tglulb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Sumagot si Isaac at sinabi kay Esau, “Tingnan mo, nagawa ko na siyang amo mo at naibigay ko na sa kanya ang lahat ng mga kapatid niya bilang alipin. At nabigyan ko siya ng butil at bagong alak. Ano pa ang magagawa ko para sa iyo, anak ko?” ");
INSERT INTO tglulb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Sinabi ni Esau sa kanyang ama, “Wala ka bang kahit isang pagpapala sa akin, ama ko? Pagpalain mo ako, ako rin, ama ko.” Umiyak nang malakas si Esau. ");
INSERT INTO tglulb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Sumagot ang kanyang amang si Isaac at sinabi sa kanya, “Tingnan mo, ang lugar na pinaninirahan mo ay magiging malayo sa kayamanan ng mundo, malayo sa hamog ng langit sa itaas. ");
INSERT INTO tglulb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mabubuhay ka sa pamamagitan ng iyong espada, at paglilingkuran mo ang iyong kapatid na lalaki. Subalit kapag magrebelde ka, maaalog mo ang kanyang pamatok mula sa iyong leeg.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Nagalit si Esau kay Jacob dahil sa pagpapalang binigay ng kanilang ama sa kanya. Sinabi niya sa kanyang puso, “Malapit na ang mga araw ng pagluluksa para sa aking ama; pagkatapos niyon papatayin ko ang kapatid kong si Jacob.” ");
INSERT INTO tglulb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ang mga salita ni Esau na nakatatanda niyang anak ay nasabi kay Rebeca. Kaya nagpadala at tinawag niya si Jacob na nakababatang anak niya at sinabi rito, “Tingnan mo, ang kapatid mong si Esau ay inaaliw ang kanyang sarili sa pagbabalak na patayin ka. ");
INSERT INTO tglulb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kaya ngayon, anak ko, sundin mo ako at tumakas ka papunta kay Laban, na kapatid kong lalaki, sa Haran. ");
INSERT INTO tglulb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Manatili ka nang ilang araw sa piling niya, hanggang sa humupa ang galit ng kapatid mo, ");
INSERT INTO tglulb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","hanggang mawala ang galit ng kapatid mo sa iyo, at malimutan niya ang ginawa mo sa kanya. Pagkatapos magpapadala ako at ibabalik ka mula roon. Bakit kailangang kapwa kayong mawala sa akin sa isang araw?” ");
INSERT INTO tglulb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Sinabi ni Rebeca kay Isaac, “Ako ay pinanghihinaan sa buhay dahil sa mga anak na babae ni Heth. Kung kunin ni Esau na asawa ang isa sa mga anak ni Heth, tulad ng mga kababaihang ito, ilan sa mga anak na babae ng lupain, ano pa ang kabuluhan ng buhay ko?” ");
INSERT INTO tglulb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tinawag ni Isaac si Jacob, pinagpala siya at inutusan, “Hindi ka dapat kumuha ng asawa mula sa kababaihang taga-Cananeo. ");
INSERT INTO tglulb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tumayo ka, pumunta ka sa Paddan-aram, sa bahay ni Bethuel na ama ng iyong ina, at kumuha ka ng asawa mula roon, sa isa sa mga anak ni Laban, na kapatid ng iyong ina. ");
INSERT INTO tglulb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Pagpalain ka nawa ng Makapangyarihang Diyos, pamungahin ka at paramihin, para dumami ang iyong lahi. ");
INSERT INTO tglulb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ibigay niya nawa sa iyo ang pagpapala ni Abraham, sa iyo, at sa mga susunod mong kaapu-apuhan, para manahin mo ang lupain kung saan ka naninirahan, na ibinigay ng Diyos kay Abraham.” ");
INSERT INTO tglulb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kaya pinaalis ni Isaac si Jacob. Pumunta si Jacob sa Paddan-aram, kay Laban na anak ni Bethuel na Aramean, kapatid ni Rebeca na ina nina Esau at Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ngayon nakita ni Esau na pinagpala ni Isaac si Jacob at pinapunta siya sa Paddan-aram para kumuha ng asawa roon. Nakita rin niya na pinagpala siya ni Isaac at binigyan siya ng utos, na nagsasabing, “Hindi ka dapat kumuha ng asawa mula sa kababaihan ng Canaan.” ");
INSERT INTO tglulb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nakita rin ni Esau na sinunod ni Jacob ang kanyang ama at ina, at nagpunta sa Paddan-aram. ");
INSERT INTO tglulb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Nakita ni Esau na hindi nalugod ang kaniyang amang si Isaac sa mga kababaihan ng Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kaya nagpunta siya kay Ismael, at kinuha, bukod pa sa mga asawang mayroon siya, si Mahalath na anak ni Ismael, anak ni Abraham, kapatid na babae ni Nabaioth, para maging asawa niya. ");
INSERT INTO tglulb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Nilisan ni Jacob ang Beer-seba at nagpunta sa Haran. ");
INSERT INTO tglulb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Dumating siya sa isang lugar at nanatili roon buong gabi, dahil lumubog na ang araw. Kumuha siya ng isang bato sa lugar na iyon, inilagay iyon sa ilalim ng kanyang ulo at nahiga sa lugar na iyon para matulog. ");
INSERT INTO tglulb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Siya ay nanaginip at nakakita ng hagdanang itinayo sa mundo. Ang tuktok nito ay umaabot sa langit at ang mga anghel ng Diyos ay akyat-panaog doon. ");
INSERT INTO tglulb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Masdan, si Yahweh ay nakatayo sa ibabaw niyon at nagsabi, “Ako si Yahweh, ang Diyos ni Abraham na iyong ama, at ang Diyos ni Isaac. Ang lupang hinihigaan mo, ibibigay ko sa iyo at sa iyong mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ang iyong mga kaapu-apuhan ay magiging tulad ng alikabok sa mundo, at ikaw ay kakalat sa kanluran, sa silangan, sa hilaga, at sa timog. Sa iyo at iyong mga kaapu-apuhan, ang lahat ng mga pamilya sa mundo ay pagpapalain. ");
INSERT INTO tglulb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Masdan mo, kasama mo ako, iingatan kita saan ka man magpunta. Dadalhin kitang muli sa lupaing ito; dahil hindi kita iiwan. Tutuparin ko ang lahat ng naipangako ko sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Si Jacob ay nagising mula sa kanyang pagtulog at sinabi nya, “Tunay nga na si Yahweh ay nasa lugar na ito, at hindi ko iyon alam.” ");
INSERT INTO tglulb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Natakot siya at nagsabi, “Nakakikilabot naman ang lugar na ito! Ito ay walang iba kundi ang tahanan ng Diyos. Ito ang tarangkahan ng langit.” ");
INSERT INTO tglulb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Bumangon si Jacob kinaumagahan at kinuha ang batong inilagay niya sa ilalim ng kaniyang ulo. Itinayo niya ito bilang isang haligi at nagbuhos ng langis sa ibabaw nito. ");
INSERT INTO tglulb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tinawag niya ang pangalan ng lugar na iyon na Bethel, pero ang dating pangalan ng lungsod na iyon ay Luz. ");
INSERT INTO tglulb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Si Jacob ay sumumpa ng isang panata na nagsasabing, “Kung ang Diyos ay kasama ko at pangangalagaan ako sa daang ito na aking nilalakaran, at bibigyan ako ng tinapay para kainin, at mga damit para suutin, ");
INSERT INTO tglulb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nang sa gayon matiwasay akong makabalik sa bahay ng aking ama, pagkatapos si Yahweh ay magiging Diyos ko. ");
INSERT INTO tglulb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Pagkatapos ang batong ito na itinayo ko bilang isang haligi ay magiging banal na bato. Mula sa lahat ng ibinigay mo sa akin, tiyak na ibabalik ko sa iyo ang ikasampung bahagi.” ");
INSERT INTO tglulb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Pagkatapos nagpatuloy si Jacob sa kanyang paglalakbay at nakarating sa lupain ng mga mamamayan sa silangan. ");
INSERT INTO tglulb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Nang siya ay nagmasid, mayroon siyang nakitang balon sa bukid, at nakita niya, na may tatlong mga kawan ng tupa na namamahinga sa paligid nito. Dahil mula sa balong iyon pinapainom nila ang mga kawan, at ang bato sa bunganga ng balon ay malaki. ");
INSERT INTO tglulb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kapag sama-samang napagtipon ang lahat ng mga kawan doon, igugulong ng mga pastol ang bato mula sa bunganga ng balon at paiinumin ang mga tupa, at pagkatapos ibabalik muli ang bato sa bunganga ng balon, pabalik sa kinalalagyan nito. ");
INSERT INTO tglulb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Sinabi ni Jacob sa kanila, “Mga kapatid ko, saan kayo nanggaling?” At sinabi nila, “Kami ay nanggaling sa Haran”. ");
INSERT INTO tglulb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Sinabi niya sa kanila, “Kilala ba ninyo si Laban na anak ni Nahor?” At sinabi nila, “Kilala namin siya”. ");
INSERT INTO tglulb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Sinabi niya sa kanila “Mabuti ba ang kalagayan niya?” Sinabi nila, “Mabuti naman siya, at, tumingin ka roon, si Raquel na kanyang anak ay paparating kasama ang mga tupa.” ");
INSERT INTO tglulb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Sinabi ni Jacob, “Tingnan mo, ito katanghaliang-tapat. Hindi pa oras para sa mga kawan na sama-samang tipunin. Painumin ninyo ang mga tupa at pagkatapos umalis kayo at hayaan silang manginain ng damo.” ");
INSERT INTO tglulb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Sinabi nila, “Hindi namin sila mapapainum hangga't hindi pa sama-samang natitipon ang mga kawan. Saka pa lamang igugulong ng mga kalalakihan ang bato mula sa bunganga ng balon, at paiinumin namin ang mga tupa.” ");
INSERT INTO tglulb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Habang si Jacob ay nakikipag-usap pa rin sa kanila, dumating si Raquel kasama ang mga tupa ng kanyang ama, dahil inaalagaan niya ang mga ito. ");
INSERT INTO tglulb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Nang makita ni Jacob si Raquel, anak na babae ni Laban, kapatid na lalaki ng kanyang ina, lumapit si Jacob, pinagulung ang bato mula sa bunganga ng balon, at pinainom ang kawan ni Laban, na kapatid ng kanyang ina. ");
INSERT INTO tglulb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Hinalikan ni Jacob si Raquel at umiyak ng malakas. ");
INSERT INTO tglulb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Sinabi ni Jacob kay Raquel na siya ay kamag-anak ng kanyang ama, at siya ay anak ni Rebeca. Pagkatapos tumakbo si Raquel at sinabi niya sa kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nang marinig ni Laban ang balita tungkol kay Jacob na anak ng kanyang kapatid na babae, siya ay tumakbo para salubungin siya, yakapin, halikan at dalhin sa kanyang bahay. Sinabi ni Jacob kay Laban ang lahat ng mga bagay na ito. ");
INSERT INTO tglulb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Sinabi ni Laban sa kanya, “Tunay nga na ikaw ay aking buto at laman,” Pagkataposnanatili si Jacob sa piling niya ng isang buwan. ");
INSERT INTO tglulb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Pagkatapos sinabi ni Laban kay Jacob, “Pagsisilbihan mo ba ako sa wala dahil kamag-anak mo ako? Sabihin mo sa akin, ano ang iyong magiging kabayaran?” ");
INSERT INTO tglulb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ngayon si Laban ay may dalawang anak na babae. Ang pangalan ng nakatatanda ay Lea at ang pangalan ng nakababatang kapatid ay Raquel. ");
INSERT INTO tglulb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Si Lea ay may mapupungay na mga mata, pero si Raquel ay maganda sa anyo at itsura. ");
INSERT INTO tglulb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Minahal ni Jacob si Raquel, kaya sinabi niya, “Maninilbihan ako sa iyo ng pitong taon para kay Raquel, ang iyong nakababatang anak na babae.” ");
INSERT INTO tglulb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Sinabi si Laban, “Mas mabuti na ibigay ko siya sa iyo, kaysa ibigay ko siya sa ibang lalaki. Manatili ka sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kaya naninilbihan si Jacob ng pitong taon para kay Raquel; at tila ang mga ito ay parang iilang araw lamang sa kanya, dahil sa pagmamahal na mayroon siya sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Pagkatapos sinabi ni Jacob kay Laban, “Ibigay mo na ang aking asawa, dahil ang mga araw ko ay natapos na—para mapakasalan ko na siya!” ");
INSERT INTO tglulb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kaya tinipon ni Laban ang lahat ng mga lalaki sa lugar at nagpista. ");
INSERT INTO tglulb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Kinagabihan, kinuha ni Laban si Lea na kanyang anak at dinala kay Jacob, na siyang sumiping sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Binigay rin ni Laban ang kanyang babaeng lingkod na si Zilpa sa kanyang anak na si Lea, para maging lingkod niya. ");
INSERT INTO tglulb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kinaumagahan, nagulat siya, dahil si Lea ang kasama niya! Sinabi ni Jacob kay Laban, “Ano ba itong ginawa mo sa akin?” Hindi ba nanilbihan ako sa iyo para kay Raquel? Bakit dinaya mo ako?” ");
INSERT INTO tglulb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Sinabi ni Laban, “Hindi namin kaugalian na ibigay ang nakababatang anak na babae bago ang panganay. ");
INSERT INTO tglulb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tapusin mo ang isang linggong kasalan sa anak kong ito, at ibibigay rin namin sa iyo ang isa bilang kapalit ng iyong paninilbihan sa akin ng karagdagang pitong taon.” ");
INSERT INTO tglulb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kaya ginawa iyon ni Jacob, at natapos ang isang linggo para kay Lea. Pagkatapos ay ibinigay ni Laban sa kanya si Raquel bilang kanyang asawa rin. ");
INSERT INTO tglulb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ibinigay rin ni Laban si Bilha sa kanyang anak na babaeng si Raquel, para maging lingkod. ");
INSERT INTO tglulb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Kaya pinakasalan ni Jacob si Raquel, dahil minahal niya si Raquel nang mas higit pa kay Lea. Kaya nanilbihan si Jacob kay Laban ng karagdagang pitong taon. ");
INSERT INTO tglulb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nakita ni Yahweh na si Lea ay hindi minahal, kaya binuksan niya ang kanyang sinapupunan, pero si Raquel ay walang anak. ");
INSERT INTO tglulb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Si Lea ay nagdalang-tao at nagsilang ng isang batang lalaki, at pinangalanan niyang Ruben. Sinabi niya, “Dahil nakita ni Yahweh ang aking paghihirap; tiyak ngayon na mamahalin na ako ng aking asawa. ");
INSERT INTO tglulb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Pagkatapos muli siyang nagdalang-tao at nagsilang ng lalaki. Sinabi niya, “Dahil narinig ni Yahweh na hindi ako minahal, kaya binigyan din niya ako ng anak na lalaki,” at pinangalanan niya itong Simeon. ");
INSERT INTO tglulb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Pagkatapos nagdalang-tao siya muli at nagsilang ng lalaki. Sinabi niya, “Ngayon, sa pagkakataong ito, ang aking asawa ay magiging malapit na sa akin dahil nakapagsilang ako para sa kanya ng tatlong lalaki.” Kaya nga ang kanyang pangalan ay tinawag na Levi. ");
INSERT INTO tglulb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nagdalang-tao siya muli at nagsilang ng lalaki. Sinabi niya, “Sa pagkakataong ito pupurihin ko si Yahweh.” Kaya nga pinangalanan niya itong Juda; Pagkatapos huminto na siya sa pagkakaroon ng anak. ");
INSERT INTO tglulb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nang makita ni Raquel na wala siyang naging anak kay Jacob, si Raquel ay nainggit sa kanyang kapatid na babae. Sinabi niya kay Jacob, “Bigyan mo ako ng mga anak, o mamamatay ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ang galit ni Jacob ay nagsiklab laban kay Raquel. Sinabi niya, “Nasa lugar ba ako ng Dios, na pumigil sa iyo na magkaanak?” ");
INSERT INTO tglulb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Sinabi niya, “Tingnan mo, iyan ang aking lingkod na si Bilha. Sipingan mo siya para magkaroon siya ng mga anak sa aking mga tuhod, at ako ay magkakaroon ng mga anak sa pamamagitan niya.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kaya binigay niya ang kanyang lingkod na si Bilha bilang asawa at sinipingan siya ni Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Nagdalang-tao si Bilha at nagsilang ng anak na lalaki kay Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Sinabi ni Raquel, “Narinig ako ng Diyos. Tiyak na narinig niya ang aking tinig at binigyan ako ng isang anak. Kaya nga, pinangalanan niya itong Dan. ");
INSERT INTO tglulb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Si Bilha, ang lingkod ni Raquel, ay nagdalang-tao muli at nagsilang kay Jacob ng pangalawang anak. ");
INSERT INTO tglulb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Sinabi ni Raquel, “Sa matinding pakikipagbuno, nakipagbuno ako sa aking kapatid at ako ay nanaig.” Siya ay pinangalanan niyang Nephtali. ");
INSERT INTO tglulb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Nang nakita ni Lea na natigil na siya sa pagkakaroon ng anak, kinuha niya si Zilpa, ang kanyang lingkod, at ibinigay kay Jacob bilang asawa. ");
INSERT INTO tglulb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Si Zilpa, na lingkod ni Lea, ay nagsilang ng lalaki kay Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Sinabi ni Lea, “Ito ay napakapalad!” Kaya siya ay pinangalanan niyang Gad. ");
INSERT INTO tglulb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Pagkatapos si Zilpa, lingkod ni Lea, ay nagsilang kay Jacob ng pangalawang anak. ");
INSERT INTO tglulb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Sinabi ni Lea, “Masaya ako! Dahil ang mga anak na babae ay tatawagin akong masaya.” Kaya siya ay pinangalanan niyang Asher. ");
INSERT INTO tglulb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Pumunta si Ruben nang panahon ng pag-ani ang trigo at nakakita ng mga halaman ng mendreik. Dinala niya ito sa kanyang inang si Lea. Pagkatapos sinabi ni Raquel kay Lea, “Bigyan mo ako ilan sa mga halaman ng mendreik ng iyong anak.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sinabi ni Lea kay Raquel, “Maliit na bagay lang ba sa iyo na kinuha mo ang aking asawa? Ngayon gusto mo namang kunin din ang mga halaman ng mendreik ng aking anak?” Sinabi ni Raquel, “Matutulog siya kasama mo ngayong gabi, bilang kapalit sa mga halaman ng mendreik ng iyong anak.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nanggaling si Jacob sa kanyang sakahan kinagabihan. Lumabas si Lea para salubungin siya at sinabi, “Kailangan mong matulog kasama ko ngayong gabi, dahil inupahan kita sa pamamagitan ng mga halaman na mendreik ng aking anak.” Kaya natulog si Jacob kasama ni Lea nang gabing iyon. ");
INSERT INTO tglulb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dininig ng Diyos si Lea, at nagdalang tao siya at nagsilang ng ikalimang anak nila ni Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Sinabi ni Lea, “Ibinigay ng Diyos sa akin ang aking mga kabayaran, dahil ibinigay ko sa aking asawa ang aking babaeng lingkod.” Siya ay pinangalanan niyang Isacar. ");
INSERT INTO tglulb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Muling nagdalang-tao si Lea at nagsilang kay Jacob ng ikaanim na anak. ");
INSERT INTO tglulb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Sinabi ni Lea, “Binigyan ako ng Diyos ng magandang regalo. Ngayon, pararangalan na ako ng aking asawa, dahil nagsilang ako ng anim na batang lalaki sa kanya.” Siya ay pinangalanan niyang Zebulon. ");
INSERT INTO tglulb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Pagkatapos nagsilang siya ng batang babae at siya ay pinangalanan niyang Dina. ");
INSERT INTO tglulb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Naalala ng Diyos si Raquel at dininig siya. Dinulot niya na siya ay mabuntis. ");
INSERT INTO tglulb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nagdalang-tao siya at nagsilang ng isang anak na lalaki. Sinabi niya, “Inalis ng Diyos ang aking kahihiyan.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Siya ay pinangalanan niyang Jose, na nagsasabing, “Si Yahweh ay nagdagdag sa akin ng lalaking anak.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Pagkatapos isilang ni Raquel si Jose, sinabi ni Jacob kay Laban, “Ipadala mo ako sa malayo, para ako ay makapunta sa sarili kong tahanan at sa aking bansa. ");
INSERT INTO tglulb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ibigay mo sa akin ang aking mga asawa at mga anak na dahilan ng aking paninilbihan sa iyo, at hayaan mo akong umalis dahil alam mo naman ang paglilingkod na ibinigay ko sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Sinabi ni Laban sa kanya, “Kung nakahanap ako ng pabor sa iyong mga mata ngayon, maghintay ka muna, dahil nalaman ko sa aking pagdarasal na pinagpala ako ni Yahweh para sa iyong kapakanan.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Pagkatapos sinabi niya, “Sabihin mo kung magkano ang iyong kabayaran at babayaran ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Sinabi ni Jacob sa kanya, “Alam mo kung paano ako nanilbihan sa iyo at alam mo kung paano lumago ang iyong mga hayop. ");
INSERT INTO tglulb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Dahil kakaunti lang ang mayroon ka bago ako dumating, at dumami ito nang dumami. Pinagpala ka ni Yahweh saan man ako nagtrabaho. Ngayon kailan naman ako maghahanda para sa aking sariling sambahayan?” ");
INSERT INTO tglulb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Kaya sinabi ni Laban, “Ano ang ibabayad ko sa iyo?” Sinabi ni Jacob, “Hindi mo ako bibigyan ng anumang bagay. Kung gagawin mo ang bagay na ito para sa akin, pakakainin ko ulit at iingatan ang iyong mga kawan. ");
INSERT INTO tglulb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hayaan mo akong lumakad doon sa iyong mga kawan ngayon, aalisin ko ang bawat may batik at may dungis na tupa, at lahat ng mga itim sa iyong mga tupa, at ang mga may dungis at batik sa mga kambing. Ito ang aking magiging kabayaran. ");
INSERT INTO tglulb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ang aking katapatan ang magpapatunay para sa akin kalaunan, kapag pupunta ka para tingnan ang aking kabayaran. Lahat na mga walang batik, walang dungis sa mga kambing, at itim sa mga tupa, kung mayroon mang makita na nasa akin, ay ituturing na ninakaw.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Sinabi ni Laban, “Pumapayag ako. Mangyayari ang mga ito ayon sa sinabi mo.” ");
INSERT INTO tglulb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Sa araw na iyon inalis ni Laban ang lahat ng mga lalaking kambing na may guhit at dungis, at ang lahat ng mga babaeng kambing na may batik at dungis, ang lahat na may puti, at ang lahat ng mga itim sa mga tupa, at ibinigay niya ito sa kamay ng kanyang mga anak na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Naglagay din si Laban ng tatlong araw na paglalakbay sa pagitan ng kanyang sarili at kay Jacob. Kaya si Jacob ay nagsikap na alagaan ang natitirang kawan ni Laban. ");
INSERT INTO tglulb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kumuha si Jacob ng sariwang pinutol na mga sanga ng sariwang alamo, at ng almendro at ng kastanong punongkahoy, at binalatan sila ng puting guhit, at pinalitaw ang puting loob ng kahoy na nasa mga patpat. ");
INSERT INTO tglulb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Pagkatapos inilagay niya ang binalatang patpat sa harap ng mga kawan, sa harap ng patubigan kung saan ang mga kawan ay umiinom. Nabubuntis sila sa tuwing sila ay umiinom. ");
INSERT INTO tglulb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ang mga kawan ay nagparami sa harap ng mga patpat; at ang mga kawan ay nanganak ng may guhit, may batik, at may dungis na bata. ");
INSERT INTO tglulb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Si Jacob ay naghiwalay sa mga babaeng tupa, at hinarap ang kanilang mga mukha sa mga hayop na may guhit at lahat ng itim na tupa sa kawan ni Laban. Pagkatapos, ihiniwalay niya ang kaniyang mga kawan at hindi na sila isinama kailanman sa kawan ni Laban. ");
INSERT INTO tglulb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sa tuwing nagpaparami ang mga malalakas na tupa sa kawan, nilalagay ni Jacob ang mga patpat sa may patubigan sa harapan ng mga mata ng kawan, para mabuntis sila sa gitna ng mga patpat. ");
INSERT INTO tglulb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pero kapag dumating ang mahihinang hayop sa kawan, hindi niya inilalagay ang mga patpat sa kanilang harapan. Kaya ang mga mahihinang hayop ay kay Laban, at ang mga malalakas ay kay Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Naging masagana ang lalaki. Mayroon siyang maraming mga kawan, mga babaeng at lalaking lingkod, mga kamelyo at mga asno. ");
INSERT INTO tglulb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ngayon narinig ni Jacob ang mga salita ng mga anak ni Laban, na sinabi nila, “Kinuha ni Jacob ang lahat na mga pag-aari ng ating ninuno, at galing sa mga pag-aari ng ating ninuno ang lahat nang nakuha niyang kayamanan.” ");
INSERT INTO tglulb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nakita ni Jacob ang anyo ng mukha ni Laban. Nakita niya na nagbago ang kanyang pakikitungo sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Pagkatapos sinabi ni Yahweh kay Jacob, “Bumalik ka sa lupain ng iyong mga ninuno at sa iyong mga kamag-anak, at ako'y makakasama mo.” ");
INSERT INTO tglulb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Pinatawag at pinapunta ni Jacob sina Raquel at Lea sa bukid sa kanyang kawan ");
INSERT INTO tglulb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","at sinabi sa kanila, “Nakita kong nagbago ang pakikitungo ng inyong ama sa akin, ngunit ang Diyos ng aking ama ay kasama ko. ");
INSERT INTO tglulb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Alam ninyong pinaglingkuran ko ang inyong ama ng buong lakas ko. ");
INSERT INTO tglulb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Nilinlang ako ng inyong ama at pinalitan ng sampung beses ang sahod ko, ngunit hindi siya pinahintulutan ng Diyos na ako'y masaktan. ");
INSERT INTO tglulb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nang sinabi niya, 'Ang batik-batik na mga hayop ang ibibigay kong sahod sa iyo,' sa gayon ang lahat ng buong kawan ay nagsilang ng mga batang batik-batik. At nang sinabi niya, 'Ang mga guhitan ang iyong magiging sahod,' sa gayon ang lahat ng buong kawan ay nagsilang ng mga batang guhitan. ");
INSERT INTO tglulb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Sa ganitong paraan kinuha ng Diyos ang mga alagang hayop ng inyong ama at ibinigay sila sa akin. ");
INSERT INTO tglulb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Minsan sa panahon ng pagpaparami, nakita ko sa isang panaginip ang mga lalaking kambing na nakikipagtalik sa kawan. Ang mga lalaking kambing ay mga guhitan, batik-batik at may butlig. ");
INSERT INTO tglulb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Sinabi sa akin ng anghel ng Diyos sa panaginip, “Jacob.' Sumagot ako, 'Narito ako.' ");
INSERT INTO tglulb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Sabi niya, 'Imulat mo ang iyong mga mata at tingnan mo ang lahat ng mga lalaking kambing na nagpaparami sa kawan. Sila ay mga guhitan, may batik-batik at may batik, sapagkat nakita ko ang lahat ng bagay na ginagawa ni Laban sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ako ang Diyos ng Bethel, kung saan mo binuhusan ng langis ang isang haligi, kung saan ka gumawa ng isang panata sa akin. Ngayon, tumindig ka at lisanin ang lupaing ito at bumalik sa lupain ng iyong kapanganakan.”' ");
INSERT INTO tglulb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Sumagot sina Raquel at Lea at sinabi sa kanya, “Mayroon ba kaming makukuhang anumang pamana sa bahay ng aming ama? ");
INSERT INTO tglulb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Hindi ba itinuring niya tayo bilang mga dayuhan? Sapagkat ipinagbili niya tayo at tuluyang inubos ang ating pera. ");
INSERT INTO tglulb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Dahil lahat ng kayamanang kinuha ng Diyos sa ating ama ngayo’y sa atin na at sa ating mga anak. Kaya ngayon, anumang sinabi ng Diyos sa iyo, gawin mo.” ");
INSERT INTO tglulb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Pagkatapos bumangon si Jacob at pinasakay ang kanyang mga anak at mga asawa sa mga kamelyo. ");
INSERT INTO tglulb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Pinauna niya ang kanyang mga alagang hayop, kasabay ng lahat ng kanyang mga ari-arian, pati na ang mga alagang hayop na nakuha niya sa Paddan Aram. Pagkatapos humayo siya patungo sa lupain ng Canaan sa kanyang amang si Isaac. ");
INSERT INTO tglulb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Nang umalis si Laban para gupitan ang kanyang mga tupa, ninakaw naman ni Raquel ang diyos ng sambahayan ng kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nilinlang din ni Jacob si Laban na Aramean, sa hindi pagsasabing aalis siya. ");
INSERT INTO tglulb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Kaya tumakas siya dala lahat ng mayroon siya at nagmamadaling tumawid sa Ilog, patungo sa dako ng burol na bansa ng Galaad. ");
INSERT INTO tglulb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Sa ikatlong araw, nalaman ni Laban na tumakas si Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kaya dinala niya ang kanyang mga kamag-anak at tinugis siya sa pitong araw na paglalakbay. Naabutan siya sa burol na bansa ng Galaad. ");
INSERT INTO tglulb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ngayon nagpakita ang Diyos kay Laban na Aramean sa isang panaginip sa gabi at sinabi sa kanya, “Mag-ingat kang magsalita kay Jacob, kahit masama man o mabuti.” ");
INSERT INTO tglulb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Naunahan ni Laban si Jacob. Ngayon itinayo ni Jacob ang kanyang tolda sa burol na bansa. Nagkampo rin si Laban at ang kanyang mga kamag-anak sa burol na bansa ng Galaad. ");
INSERT INTO tglulb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Sinabi ni Laban kay Jacob, “Ano ang ginawa mo, na nilinlang mo ako at tinangay ang aking mga anak na babae na parang mga bilanggo sa digmaan? ");
INSERT INTO tglulb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Bakit ka tumakas nang palihim at nilinlang ako at hindi mo man lang ako sinabihan. Pinaalis sana kita nang may pagdiriwang, at may mga awitin, may tamborin at may mga alpa. ");
INSERT INTO tglulb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hindi mo ako pinayagang halikan ang aking mga apong lalaki at babae upang makapagpaalam. Gumawa ka ng kamangmangan. ");
INSERT INTO tglulb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nasa kapangyarihan ko ang gawan kayo ng masama, ngunit ang Diyos ng inyong ama ay nakipag-usap sa akin kagabi at sinabi, 'Mag-ingat kang magsalita laban kay Jacob masama man o mabuti.' ");
INSERT INTO tglulb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","At ngayon, lumayo ka dahil labis ka nang nangulila sa bahay ng iyong ama. Ngunit bakit mo ninakaw ang aking mga diyos?” ");
INSERT INTO tglulb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Sumagot si Jacob at sinabi kay Laban, “Dahil natatakot ako at ang akala ko na kukunin mo ang iyong mga anak na bababe mula sa akin nang sapilitan kaya umalis ako nang palihim. ");
INSERT INTO tglulb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kung sino man ang nagnakaw ng iyong mga diyos-diyosan ay hindi na patuloy na mabubuhay. Sa harap ng ating mga kamag-anak, alamin mo kung anong mayroon sa akin ang sa iyo at kunin mo.” Pagkat hindi alam ni Jacob na si Raquel ang nagnakaw sa mga iyon. ");
INSERT INTO tglulb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Pumunta si Laban sa tolda ni Jacob, sa tolda ni Lea at sa tolda ng dalawang babaeng alipin, ngunit hindi niya natagpuan ang mga ito. Pumunta siya sa tolda ni Lea at pumasok sa tolda ni Raquel. ");
INSERT INTO tglulb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ngayon kinuha ni Raquel ang diyos ng sambahayan, nilagay niya ang mga ito sa upuan sa likod ng kamelyo at inupuan niya. Hinanapan ni Laban ang buong tolda, ngunit hindi niya ito natagpuan. ");
INSERT INTO tglulb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Sinabi ni Raquel sa kanyang ama, “Huwag kang magalit, aking panginoon, sapagkat hindi ako makakatayo sa kinauupuan ko dahil sa ako ay may buwanang dalaw.” Kaya naghanap siya ngunit hindi niya natagpuan ang kanyang pansambahayang diyos. ");
INSERT INTO tglulb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Nagalit si Jacob at nakipagtalo kay Laban. Sinabi niya sa kanya, “Ano ba ang atraso ko? Ano ba ang kasalanan ko, na pinag-iinitan mo akong habulin? ");
INSERT INTO tglulb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Hinanapan mo na ang lahat ng aking ari-arian. Anong natagpuan mong iyong mga pansambahayang bagay? Ilagay ang mga iyon dito sa harap ng ating mga kamag-anak, upang humatol sila sa pagitan nating dalawa. ");
INSERT INTO tglulb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Kasama ninyo ako sa loob ng dalawampung taon. Ang inyong mga babaeng tupa at babaeng kambing ay hindi nakunan, ni kumain ako ng anumang lalaking tupa mula sa iyong mga kawan. ");
INSERT INTO tglulb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Anuman ang nilapa ng mga mababangis na hayop hindi ko dinala sa iyo. Sa halip, inako ko ang pagkawala nito. Palagi mo akong pinagbayad sa mga nawawalang hayop, kahit na ninakaw sa araw o ninakaw sa gabi. ");
INSERT INTO tglulb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Naroon ako; sa araw pinahirapan ako ng init, at ng nagyeyelong hamog sa gabi; at nagtiis ako nang walang tulog. ");
INSERT INTO tglulb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nitong dalawampung taon ay nasa inyong sambahayan mo ako. Nagtrabaho ako ng labing-apat na taon para sa dalawa mong anak na babae, at anim na taon para sa iyong kawan. Binago mo ang aking sahod ng sampung beses. ");
INSERT INTO tglulb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kung ang Diyos na sinasamba ng aking ama, ang Diyos ni Abraham, at ang isang kinatatakutan ni Isaac ay kasama ko, tiyak na ngayon pinaalis mo na sana akong walang dala. Nakita ng Diyos ang aking kaapihan at kung gaano kabigat ako nagtrabaho, at pagsabihan ka niya kagabi.” ");
INSERT INTO tglulb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Sumagot si Laban kay Jacob. ''Ang mga anak na babae ay aking mga anak na babae, ang mga apo ay aking mga apo, ang mga kawan ay aking mga kawan. Lahat ng nakita mo ay akin. Ngunit ano ba ang gagawin ko ngayon sa aking mga anak na babae at sa magiging anak nila na kanilang isinilang? ");
INSERT INTO tglulb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kaya ngayon, gagawa tayo ng isang kasunduan, ikaw at ako, at hayaang maging saksi ito sa pagitan mo at sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kaya kumuha si Jacob ng isang bato at itinayo bilang isang haligi. ");
INSERT INTO tglulb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Sinabi ni Jacob sa kanyang mga kamag-anak, “Magtipon kayo ng mga bato.” Kaya kumuha sila ng mga bato at gumawa ng isang tumpok. Pagkatapos doon sila kumain sa may tumpok. ");
INSERT INTO tglulb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Tinawag ni Laban itong Jegar-sahaduta, ngunit tinawag ni Jacob itong Galeed. ");
INSERT INTO tglulb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Sinabi ni Laban, “Ang mga tumpok na ito ang isang saksi sa pagitan ko at sa iyo ngayon.” Kaya ang pangalan ay tinawag na Galeed. ");
INSERT INTO tglulb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Tinawag din itong Mizpah, dahil sinabi ni Laban, “Nawa si Yahweh ang magbantay sa pagitan mo at ako, kung hindi natin nakikita ang isa't isa. ");
INSERT INTO tglulb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kung abusuhin mo ang aking mga anak, o kumuha ka ng ibang mga asawa maliban sa mga anak ko, bagamat wala tayong kasama, tingnan mo, ang Diyos ang saksi sa pagitan mo at ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Sinabi ni Laban kay Jacob, “Tingnan mo ang tumpok na ito at tingnan ang poste, kung saan itinakda ko sa pagitan mo at ako. ");
INSERT INTO tglulb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ang poste na ito ay isang saksi, at ang haligi ay isang saksi, na hindi ako lalampas sa tumpok na ito patungo sa iyo, at hindi ka lalampas sa tumpok na ito at sa haliging ito patungo sa akin, para gumawa ng pinsala. ");
INSERT INTO tglulb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nawa'y ang Diyos ni Abraham, at ang Diyos ni Nahor, ang Diyos ng kanilang ama, ang humatol sa pagitan natin.” Nanumpa si Jacob sa Diyos, na kinatatakutan ng kanyang amang si Isaac. ");
INSERT INTO tglulb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Nag-alok ng isang alay si Jacob sa bundok at tinawag ang kanyang mga kamag-anak para kumain. Kumain sila at nanatili sila sa bundok buong gabi. ");
INSERT INTO tglulb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Madaling araw pa bumangon si Laban, hinalikan ang kanyang mga apong lalaki at mga anak na babae at pinagpala sila. Pagkatapos umalis si Laban at bumalik sa kanyang tahanan. ");
INSERT INTO tglulb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Humayo na rin si Jacob, at sinalubong siya ng mga anghel ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Nang makita sila ni Jacob, sinabi niya, “Ito ang kampo ng Diyos,” kaya tinawag niya ang lugar na iyon na Mahanaim. ");
INSERT INTO tglulb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nagpadala si Jacob ng mga mensahero para sa kanyang kapatid na si Esau, sa lupain ng Seir, sa rehiyon ng Edom. ");
INSERT INTO tglulb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Inutusan niya sila at sinabing, “Ito ang sasabihin ninyo sa aking panginoon na si Esau: “Ito ang sinasabi ng iyong alipin na si Jacob: 'Naninirahan ako kapiling ni Laban hanggang ngayon. ");
INSERT INTO tglulb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mayroon akong mga baka, mga asno, at mga kawan, babae at lalaking mga alipin. Nagpadala ako para sabihin ito sa aking panginoon, upang makasumpong ako ng pabor sa iyong paningin.”' ");
INSERT INTO tglulb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Bumalik ang mga mensahero kay Jacob at sinabi, “Pumunta kami sa iyong kapatid na si Esau. Paparito siya upang makipagkita sa iyo at may kasama siyang apat na daang tao.” ");
INSERT INTO tglulb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Labis na natakot at nababahala si Jacob. Kaya hinati niya ang mga taong kasama sa dalawang kampo pati ang mga kawan, mga pangkat ng mga hayop at mga kamelyo. ");
INSERT INTO tglulb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Sinabi niya, “Kapag sinalakay ni Esau ang isang kampo, ang naiwang kampo ay makakatakas.” ");
INSERT INTO tglulb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Sinabi ni Jacob, “Diyos ng aking amang si Abraham, Diyos ng aking amang si Isaac, Yahweh, na siyang nagsabi sa akin, 'Bumalik ka sa iyong bansa at sa iyong mga kamag-anak at pasasaganain kita,' ");
INSERT INTO tglulb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Hindi ako karapat-dapat sa lahat ng iyong mga gawa ng tipan ng katapatan at lahat ng pagtitiwalang ginawa mo para sa iyong lingkod. Dahil tungkod ko lamang ang dala ko nang tumawid dito sa Jordan, at ngayon naging dalawang kampo ako. ");
INSERT INTO tglulb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Pakiusap iligtas mo ako sa kamay ng aking kapatid, sa kamay ni Esau, sapagkat natatakot ako sa kanya, na darating siya at sasalakayin ako at mga ina na kasama ang kanilang mga anak. ");
INSERT INTO tglulb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ngunit sinabi mo, “Tiyak na gagawin kitang masagana. Gagawin ko ang iyong mga kaapu-apuhan na parang buhangin ng dagat, na hindi kayang bilangin dahil sa kanilang dami.”'' ");
INSERT INTO tglulb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nanatili doon si Jacob sa gabing iyon. Kumuha siya ng ilan sa kung anong mayroon siya bilang regalo kay Esau, na kanyang kapatid: ");
INSERT INTO tglulb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","dalawandaang babaeng kambing at dalawampung lalaking kambing, dalawandaang babaeng tupa at dalawampung lalaking tupa, ");
INSERT INTO tglulb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tatlumpung gatasang kamelyo at kanilang mga bisiro, apatnapung baka at sampung toro, dalawampung babaeng asno at sampung lalaking asno. ");
INSERT INTO tglulb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ang mga ito ay ipinadala niya sa kanyang mga lingkod, bawat kawan ayon sa sarili nito. Sinabi niya sa kanyang mga lingkod, “Mauna kayo sa akin at maglagay ng puwang sa paggitan ng bawat mga kawan.” ");
INSERT INTO tglulb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Inutusan niya ang unang lingkod, na nagsasabing, “Kapag salubungin kayo ng aking kapatid at tanungin kayo, na nagsasabing, 'Kanino kayo nabibilang? Saan kayo pupunta? At kanino naman itong mga hayop sa harap ninyo?' ");
INSERT INTO tglulb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Sa gayon sasabihin mong, 'Sila ay kay Jacob na iyong lingkod. Sila ay regalong pinadala sa aking among si Esau. At tingnan ninyo, siya ay paparating din kasunod namin.”' ");
INSERT INTO tglulb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nagbigay din si Jacob ng tagubilin sa pangalawang pangkat, sa pangatlo, at sa lahat ng taong nakasunod sa kawan. Sinabi niya, “Ganun din ang sasabihin ninyo kay Esau kapag nakasalubong ninyo siya. ");
INSERT INTO tglulb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Sasabihin din ninyo, 'Ang iyong lingkod na si Jacob ay darating kasunod namin.''' Pagkat naisip niya, “Mapapalubag ko siya sa mga regalong pinapadala kong nauna sa akin. Sa gayon maya-maya, kapag nagkita kami, marahil tatanggapin niya ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kaya nauna sa kanya ang mga regalo. Siya mismo ay nanatili sa kampo nang gabing iyon. ");
INSERT INTO tglulb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Bumangon si Jacob sa kalagitnaan ng gabi, at dinala ang kanyang dalawang asawa, kanyang dalawang babaeng alipin, at ang kanyang labing isang mga anak. Pinadala niya sila sa kabila ng sapa ng Jabbok. ");
INSERT INTO tglulb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Sa ganitong paraan pinadala niya sila sa kabila ng ilog kasama ang lahat ng kanyang mga ari-arian. ");
INSERT INTO tglulb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Mag-isang naiwan si Jacob, at may taong nakipagbuno sa kanya hanggang madaling araw. ");
INSERT INTO tglulb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nang makita ng tao na hindi niya siya kayang talunin, hinampas niya ang balakang ni Jacob. Napilayan ang balakang ni Jacob sa pakikipagbuno niya sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Sinabi ng tao, “Pahintulutan mo akong umalis, pagkat mag-uumaga na.” Sabi ni Jacob, “Hindi kita pahihintulutang umalis maliban kung pagpalain mo ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Sinabi ng tao sa kanya, “Ano ang pangalan mo?” Sinabi ni Jacob, “Jacob.” ");
INSERT INTO tglulb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Sinabi ng tao, “Ang pangalan mo ay hindi na tatawaging Jacob, sa halip, Israel na. Sapagkat nakipaglaban ka sa Diyos at sa tao at nanaig ka.” ");
INSERT INTO tglulb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Tinanong siya ni Jacob, “Pakiusap sabihin mo sa akin ang iyong pangalan.” Sinabi nito, “Bakit mo tinatanong ang aking pangalan?” Pagkatapos siya ay kanyang pinagpala. ");
INSERT INTO tglulb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Tinawag ni Jacob ang lugar na iyon na Peniel sapagkat ang sabi niya, “Nakita ko ang mukha ng Diyos nang harapan, at iniligtas ang buhay ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Sinikatan ng araw si Jacob habang dumadaan siya sa Peniel. Paika-ika siya dahil sa kanyang balakang. ");
INSERT INTO tglulb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kaya hanggang ngayon ang bayan ng Israel ay hindi kumakain ng mga litid ng balakang na nasa dugtong ng balakang, dahil ang taong pumilay sa mga litid ng balakang na nasa habang inaalis sa puwesto ang balakang ni Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Tumingala si Jacob at masdan, paparating si Esau, at kasama niya ang apatnaraang lalaki. Hinati ni Jacob ang mga bata kina Lea, Raquel at sa dalawang babaeng alipin. ");
INSERT INTO tglulb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Pagkatapos inilagay niya ang mga babaeng alipin at ang kanilang mga anak sa harapan, kasunod si Lea at ang kanyang mga anak, at kasunod si Raquel at si Jose ang pinakahuli sa lahat. ");
INSERT INTO tglulb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Siya mismo ang nauna sa kanila. Yumukod siya ng pitong beses, hanggang makalapit siya sa kanyang kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tumakbo si Esau para salubungin siya, niyakap siya, niyapos ang kanyang leeg, at hinalikan siya. Pagkatapos sila'y nag-iyakan. ");
INSERT INTO tglulb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Nang tumingala si Esau, nakita niya ang mga babae at mga bata. Sinabi niya, “Sino itong mga taong kasama mo?” Sinabi ni Jacob, “Ang mga anak na malugod na ipinagkaloob ng Diyos sa iyong lingkod.” ");
INSERT INTO tglulb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Pagkatapos ang mga babaeng alipin ay lumapit kasama ang kanilang mga anak, at sila'y yumukod. ");
INSERT INTO tglulb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Sunod na lumapit si Lea at ang kanyang mga anak at yumukod. Sa huli, si Jose at si Raquel ay lumapit at yumukod. ");
INSERT INTO tglulb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Sinabi ni Esau, “Anong ibig mong sabihin sa lahat ng mga pangkat na nasalubong ko?” Sinabi ni Jacob, “Upang makasumpong ako ng pabor sa paningin ng aking panginoon.” ");
INSERT INTO tglulb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Sinabi ni Esau, “Mayroon na akong sapat, kapatid ko. Itago mo na kung ano ang mayroon ka para sa iyong sarili.” ");
INSERT INTO tglulb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Sinabi ni Jacob, “Hindi, pakiusap, kung nakasumpong ako ng pabor sa iyong paningin, sa gayon tanggapin mo ang aking regalo mula sa aking kamay, dahil tunay, nakita ko ang iyong mukha at kahalintulad nito ang pagkakita sa mukha ng Diyos, at tinanggap mo ako. ");
INSERT INTO tglulb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Pakiusap tanggapin mo ang aking mga regalong dinala ko sa iyo, dahil malugod akong pinakitunguhan ng Diyos, at dahil mayroon na akong sapat.” Kaya pinilit siya ni Jacob, at tinanggap naman ito ni Esau. ");
INSERT INTO tglulb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Pagkatapos sinabi ni Esau, “Lumakad na tayo. Mauuna ako sa inyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Sinabi ni Jacob sa kanya, “Nalalaman ng aking panginoon na ang mga bata ay musmos pa lang, at ang mga tupa at mga baka ay nagpapasuso ng kanilang mga anak. Kung sila'y pipiliting maglakad ng mabilis kahit isang araw lang, ang lahat ng mga hayop ay mamamatay.” ");
INSERT INTO tglulb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Pakiusap ko mauna na ang aking panginoon sa kanyang lingkod. Maglalakbay ako ng mabagal, ayon sa hakbang ng aking mga alagang hayop na nasa harapan ko, at ayon sa hakbang ng mga bata, hanggang makarating ako sa aking panginoon sa Seir.” ");
INSERT INTO tglulb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Sinabi ni Esau, “Hayaan mong ipaiwan ko sa iyo ang ilan sa mga kasama kong tauhan.” Subalit sinabi ni Jacob, “Bakit mo gagawin iyan? Ang aking panginoon ay naging mabait nang sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kaya sa araw na iyon nagsimula si Esau na bumalik sa Seir. ");
INSERT INTO tglulb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Naglakbay si Jacob papuntang Sucot, iginawa ang kanyang sarili ng bahay, at gumawa ng mga silungan para sa kanyang mga alagang hayop. Kaya tinawag ang pangalan ng lugar na Sucot. ");
INSERT INTO tglulb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Nang dumating si Jacob mula sa Paddan Aram, ligtas siyang nakarating sa lungsod ng Sechem, na nasa lupain ng Canaan. Nagkampo siya malapit sa lungsod. ");
INSERT INTO tglulb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Pagkatapos binili niya ang kapirasong lupa kung saan niya itinayo ang kanyang tolda mula sa mga anak na lalaki ni Hamor, na ama ni Sechem, sa halagang isandaang piraso ng pilak. ");
INSERT INTO tglulb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nagtayo siya roon ng altar at tinawag itong El Elohe Israel. ");
INSERT INTO tglulb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ngayon si Dina, na babaeng anak ni Lea kay Jacob ay lumabas para makilala ang mga dalaga ng lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nakita siya ni Sechem, na anak ni Hamor na Hevita ang prinsipe ng lupain at hinila siya, nilapastangan at hinalay. ");
INSERT INTO tglulb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Naakit siya kay Dina, na anak ni Jacob. Minahal niya ang dalaga at magiliw na kinausap siya. ");
INSERT INTO tglulb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kinausap ni Sechem ang kanyang amang si Hamor, sinabing, “Kunin mo ang dalagang ito para sa akin upang maging asawa ko.” ");
INSERT INTO tglulb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ngayon narinig ni Jacob na dinungisan niya si Dina na kanyang anak. Nasa bukid ang kanyang mga anak na lalaki kasama ng kanyang mga alagang hayop, kaya nanahimik si Jacob hanggang sa dumating sila. ");
INSERT INTO tglulb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Pumunta kay Jacob si Hamor na ama ni Sechem. ");
INSERT INTO tglulb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Dumating ang mga anak na lalaki ni Jacob na galing sa bukid nang marinig nila ang nangyari. Nasaktan ang mga lalaki. Labis silang nagalit dahil pinahiya nila ang Israel sa pagpupumilit sa kanyang sarili sa anak na babae ni Jacob, dahil ang bagay na iyon ay hindi dapat ginawa. ");
INSERT INTO tglulb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Nakipag-usap si Hamor sa kanila at sinabing, “Iniibig ng aking anak na si Sechem ang iyong anak na babae. Pakiusap ibigay mo siya sa kanya bilang asawa. ");
INSERT INTO tglulb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Makipag-asawa kayo sa amin, ibigay mo ang mga anak mong babae sa amin, at kunin ninyo ang mga anak naming babae para sa inyong sarili. ");
INSERT INTO tglulb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Maninirahan kayo sa amin, at magiging bukas ang lupain para sa inyo para manirahan at makipagkalakalan, at makakuha ng ari-arian.” ");
INSERT INTO tglulb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sinabi ni Sechem sa kanyang ama at sa kanyang mga kapatid na lalaki, “Hayaan ninyong makasumpong ako ng pabor mula sa inyong mga mata, at anuman ang sabihin ninyo sa akin ay ibibigay ko. ");
INSERT INTO tglulb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Hingiin ninyo sa akin gaano man kalaki ang dote at ragalong naisin ninyo, at ibibigay ko ang anumang sabihin ninyo sa akin, ngunit ibigay ninyo ang dalaga bilang asawa.” ");
INSERT INTO tglulb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sumagot ang mga anak na lalaki ni Jacob kay Sechem at kay Hamor na kanyang ama na may panlilinlang, sapagkat dinungisan ni Sechem si Dina na kanilang kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Sinabi nila sa kanila, “Hindi namin magagawa ang bagay na ito, ang pagbibigay ng aming kapatid na babae sa sinumang hindi tuli; sapagkat iyan ay magiging kahihiyan sa amin. ");
INSERT INTO tglulb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sa kondisyong ito lamang kami makikipagkasundo sa inyo: kung magpapatuli kayo kagaya namin, kung ang bawat lalaki sa inyo ay tutuliin. ");
INSERT INTO tglulb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Sa gayon ibibigay namin ang aming mga anak na babae sa inyo, at kukunin namin ang inyong mga anak na babae para sa aming sarili, at makipamuhay kami sa inyo at tayo ay magiging isang bayan. ");
INSERT INTO tglulb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ngunit kung hindi kayo makikinig sa amin at magpatuli, sa gayon kukunin namin ang aming kapatid at aalis kami.” ");
INSERT INTO tglulb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kinalugdan ni Hamor at ng kanyang anak na si Sechem ang kanilang mga sinabi. ");
INSERT INTO tglulb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Hindi na nag-atubili ang binatang gawin kung ano ang sinabi nila, dahil siya ay nalugod sa anak na babae ni Jacob, at dahil siya ang pinakamarangal na tao sa buong sambahayan ng kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Pumunta si Hamor at Sechem sa kanyang anak sa tarangkahan ng kanilang siyudad at nakipag-usap sa mga kalalakihan ng kanilang siyudad na sinasabing, ");
INSERT INTO tglulb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ang mga taong ito ay namumuhay ng payapa kasama natin, kaya hayaan natin silang mamuhay sa lupain at mangalakal dito, dahil tunay na ang lupain ay malawak na sapat para sa kanila. Kunin natin ang mga anak nilang babae bilang mga asawa, at ibigay natin sa kanila ang ating mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Sa ganitong kondisyon lamang papayag ang mga kalalakihan na manirahan kasama natin at tayo'y maging isang bayan: kung tutuliin ang bawat lalaki sa atin, tulad ng sila ay tuli. ");
INSERT INTO tglulb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Hindi ba maaaring ang kanilang mga alagang hayop at ang kanilang ari-arian—lahat ng kanilang mga hayop ay magiging atin? Kaya makipagkasundo tayo sa kanila, at maninirahan sila kasama natin.” ");
INSERT INTO tglulb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Lahat ng mga lalaki ng lungsod ay nakinig kay Hamor at Sechem, na kanyang anak. Nagpatuli ang bawat lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Sa ikatlong araw, nang matindi ang sakit ng sugat nila, ang dalawa sa mga anak na lalaki ni Jacob, sina Simeon at Levi na mga kapatid ni Dina, ang kanilang espada at pumunta sa lungsod na walang bantay, at pinatay ang lahat ng mga kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Pinatay nila si Hamor at Sechem na kanyang anak, sa pamamagitan ng talim ng espada. Kinuha nila si Dina mula sa bahay ni Sechem at umalis. ");
INSERT INTO tglulb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ang ibang anak na lalaki ni Jacob ay pumunta sa mga patay na katawan at ninakawan nila ang siyudad, dahil nilapastangan ng mga tao ang kanilang kapatid na babae. ");
INSERT INTO tglulb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Kinuha nila ang kanilang mga kawan, mga pangkat ng hayop, mga asno at lahat ng bagay na nasa siyudad at nakapalibot na mga bukid kasama ");
INSERT INTO tglulb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ang lahat ng kanilang kayamanan. Hinuli nila ang lahat ng kanilang mga anak at mga asawa. Kinuha nila maging ang lahat ng bagay na nasa mga bahay. ");
INSERT INTO tglulb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Sinabi ni Jacob kay Simeon at Levi, “Nagdala kayo ng gulo sa akin upang bumaho ako sa mga naninirahan sa lupain, sa mga Cananeo at mga Perezeo. Kakaunti na lamang ang aking bilang. Kung iipunin nila ang kanilang mga sarili laban sa akin at lulusubin ako, malilipol ako, ako at ang aking sambahayan. ");
INSERT INTO tglulb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ngunit sinabi ni Simeon at Levi, “Maari bang pakitunguhan ni Sechem ang aming kapatid na katulad ng babaeng bayaran?” ");
INSERT INTO tglulb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Sinabi ng Diyos kay Jacob, “Humayo ka, pumunta ka sa Betel, at manatili roon. Gumawa ng altar doon sa Diyos, na nagpakita sa iyo nang ikaw ay tumakas mula kay Esau na iyong kapatid.” ");
INSERT INTO tglulb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Pagkatapos sinabi ni Jacob sa kaniyang sambahayan at sa lahat ng kasama niya, “Ilayo ang mga dayuhang diyos na kapiling ninyo, linisin ang inyong mga sarili, at palitan ang inyong mga damit. ");
INSERT INTO tglulb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pagkatapos umalis tayo at pumunta sa Betel. Magtatayo ako ng altar doon sa Diyos, na sumagot sa akin sa araw ng aking paghihinagpis, at naging kasama ko saan man ako pumaroon.” ");
INSERT INTO tglulb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kaya ibinigay nila kay Jacob ang lahat ng dayuhang mga diyos na nasa kanilang mga kamay at mga hikaw na nasa kanilang mga tainga. Inilibing ni Jacob ang mga ito sa ilalim ng puno ng kakayuhayng malapit sa Sequem. ");
INSERT INTO tglulb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Habang naglalakbay sila, ginawa ng Diyos na masindak ang mga siyudad na nakapaligid sa kanila, kaya hindi hinabol ng mga taong iyon ang mga anak ni Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kaya dumatingsi Jacob sa Luz (iyon ay, Betel), na nasa lupain ng Canaan, siya at ang lahat ng mga taong kasama niya. ");
INSERT INTO tglulb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Siya ay gumawa ng altar doon at tinawag ang lugar na El Betel, dahil doon inihayag ng Diyos ng kanyang sarili sa kanya, nang tumatakas siya mula sa kanyang kapati. ");
INSERT INTO tglulb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Namatay si Debora, na tagapag-alaga ni Rebeka. Inilibing siya mula Betel sa ilalim ng kakayuhang puno, kaya tinawag itong Allon Bacuth. ");
INSERT INTO tglulb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nang si Jacob ay dumating mula sa Paddan Aram, nagpakitaang muli ang Diyos sa kanya at pinagpala siya. ");
INSERT INTO tglulb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Sinabi ng Diyos sa kaniya “Ang pangalan mo ay Jacob, ngunit ang iyong pangalan mo ay hindi na tatawaging Jacob. Ang pangalan mo ay magiging Israel.” Kaya tinawag ng Diyos ang kanyang pangalang Israel. ");
INSERT INTO tglulb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Sinabi ng Diyos sa kanya, “Ako ang Makapangyarihang Diyos. Maging mabunga ka at magpakarami. Isang bansa at samahan ng mga bansa ang manggagaling sa iyo, at mga hari ang magiging mga kaapu-apuhan mo. ");
INSERT INTO tglulb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ang lupaing ibinigay ko kina Abraham at Isaac, ibibigay ko sa iyo. Sa iyong mga kaapu-apuhang susunod sa iyo akin ding ibibigay ang lupain.” ");
INSERT INTO tglulb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Umalis ang Diyos paakyat mula sa kanya sa lugar kung saan nakipag-usap siya sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Si Nagtayo si Jacob ng haligi sa lugar kung saan nangusap sa kanya ang Diyos, isang haliging bato. Nagbuhos siya ng handog na inumin at nagbuhos ng langis doon. ");
INSERT INTO tglulb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Pinangalanan ni Jacob ang lugar kung saan nangusap sa kanya ang Diyos, na Betel. ");
INSERT INTO tglulb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Naglakbay pa sila mula sa Betel. Habang may kalayuan pa sila mula Eprath, nakaramdam na si Raquel ng panganganak. ");
INSERT INTO tglulb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nakaranas siya ng matinding hirap sa panganganak. Habang siya ay nasa pinakamatinding kahirapan sa panganganak, sinabi ng hilot sa kanya “Huwag kang matakot, dahil ngayon magkakaroon ka ng isa pang anak na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Habang naghihingalo siya, kasabay ng kanyang huling hininga pinangalanan niya siyang Benoni, ngunit ang kaniyang ama ay tinawag siyang Benjamin. ");
INSERT INTO tglulb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Namatay si Raquel at inilibing sa daan papunta sa Eprat (iyon ay, Betlehem). ");
INSERT INTO tglulb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nagtayo si Jacob ng isang haligi sa ibabaw ng kanyang libingan. Iyon ang palatandaan ng libingan ni Raquel hanggang sa araw na ito. ");
INSERT INTO tglulb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Si Israel ay naglakbay pa at itinayo ang kaniyang tolda sa ibayo ng Migdal Eder. ");
INSERT INTO tglulb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Habang nakatira si Israel pa sa lupaing iyon, sumiping si Reuben kay Bilha na ibang asawa kanyang ama, at narinig ito ni Israel. Ngayon si Jacob ay may labindalawang anak na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ang kanyang mga anak na lalaki kay Lea ay sina Reuben, panganay ni Jacob, at si Simeon, Levi, Juda, Isacar, at Zebulun. ");
INSERT INTO tglulb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ang kanyang mga anak na lalaki kay Raquel ay sina Jose at Benjamin. ");
INSERT INTO tglulb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ang kanyang mga anak na lalaki kay Bilha, na babaeng lingkod ni Raquel, ay sina Dan at Neftali. ");
INSERT INTO tglulb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ang mga anak na lalaki ni Zilpa, na babaeng lingkod ni Lea, ay sina Gad at Asher. Lahat ng mga ito ay mga anak na lalaki ni Jacob na ipinanganak sa kanya sa Paddan Aram. ");
INSERT INTO tglulb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Si Jacob ay pumunta kay Isaac, na kanyang ama, sa Mamre sa Kiriath Arba (pareho sa Hebron), kung saan nanirahan sina Abraham at Isaac. ");
INSERT INTO tglulb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Nabuhay si Isaac sa loob ng isandaan at walumpung taon. ");
INSERT INTO tglulb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Inihinga ni Isaacs ang kanyang huli at siya ay namatay, at tinipon siya sa kanyang mga ninuno, isang matandang lalaking ganap ang mga araw. Inilibing siya ng kanyang mga anak na sina Esau at Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ito ang mga kaapu-apuhan ni Esau (tinatawag ding Edom). ");
INSERT INTO tglulb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Kinuha ni Esau ang kanyang mga asawa mula sa mga Cananeo. Ito ang mga asawa niya: Si Ada na anak na babae ni Elon na Heteo; si Aholibama na anak na babae ni Ana, na apong babae ni Zibeon na Hivita; ");
INSERT INTO tglulb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","at Basemat, anak na babae ni Ismael, na kapatid na babae ni Nebayot. ");
INSERT INTO tglulb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Isinilang ni Ada si Elifaz kay Esau, at si Basemat ay isinilang si Reuel. ");
INSERT INTO tglulb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Isinilang ni Aholibama sina Jeus, Jalam at Korah. Ito ang mga anak na lalaki ni Esau na ipinanganak sa kanya sa lupain ng Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Dinala ni Esau ang kanyang mga asawa, mga anak na lalaki, mga anak na babae, lahat ng mga kabilang sa kanyang sambahayan, kanyang mga alagang hayop—lahat ng kanyang mga hayop, at lahat ng kanyang mga ari-arian, na tinipon niya sa lupain ng Canaan, at pumunta sa lupaing malayo sa kanyang kapatid na si Jacob. ");
INSERT INTO tglulb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ginawa niya ito dahil ang ari-arian nila ay napakarami para manatili silang magkasama. Ang lupain kung saan sila nanirahan ay hindi sila kayang itaguyod dahil sa kanilang mga alagang hayop. ");
INSERT INTO tglulb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kaya nga si Esau, na tinatawag ding Edom, ay nanirahan sa bansang burol ng Seir. ");
INSERT INTO tglulb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ang sumusunod ay ang mga kaapu-apuhan ni Esau, ang ninuno ng mga Edomita sa bansang burol ng Seir. ");
INSERT INTO tglulb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ito ang mga pangalan ng mga lalaking anak ni Esau: Si Elifaz na lalaking anak ni Ada, asawa ni Esau; Si Reuel na lalaking anak ni Basemat, asawa ni Esau. ");
INSERT INTO tglulb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ang mga lalaking anak ni Elifaz ay sina Teman, Omar, Zefo, Galam, at Kenaz. ");
INSERT INTO tglulb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ipinanganak si Amalek ni Timna, na ibang asawa ni Elifaz, na lalaking anak ni Esau. Ito ang mga lalaking apo ni Ada, asawa ni Esau. ");
INSERT INTO tglulb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ito ang mga lalaking anak ni Reuel: Sina Nahat, Zera, Shammah, at Miza. Ito ang mga lalaking apo ni Basemat, asawa ni Esau. ");
INSERT INTO tglulb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ito ang mga lalaking anak ni Aholibama, asawa ni Esau, na babaeng anak ni Ana at babaeng apo ni Zibeon. Ipinanganak niya para kay Esau sina Jeus, Jalam, at Korah. ");
INSERT INTO tglulb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ito ang mga angkan kasama sa mga kaapu-apuhan ni Esau: ang mga kaapu-apuhan ni Elifaz, na panganay na anak ni Esau: sina Teman, Omar, Zefo, Kenaz, ");
INSERT INTO tglulb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, at Amalek. Ito ang mga angkang nanggaling kay Elifaz sa lupain ng Edom. Mga apo sila ni Ada. ");
INSERT INTO tglulb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ito ang mga angkang mula kay Reuel, anak ni Esau: sina Nahat, Zera, Shammah, Miza. Ito ang mga angkang mula kay Reuel sa lupain ng Edom. Sila ang mga lalaking apo ni Basemat, asawa ni Esau. ");
INSERT INTO tglulb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ito ang mga angkan ni Aholibama, asawa ni Esau: sina Jeus, Jalam, Kora. Ito ang mga angkang nagmula sa asawa ni Esau na si Aholibama, babaeng anak ni Ana. ");
INSERT INTO tglulb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ito ang mga lalaking anak ni Esau, at ito ang kanilang mga angkan. ");
INSERT INTO tglulb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ito ang mga lalaking anak ni Seir na Horeo, na mga naninirahan sa lupain: sina Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO tglulb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, at Disan. Ito ay mga angkan ng mga Horeo, na mga naninirahan sa Seir sa lupain ng Edom. ");
INSERT INTO tglulb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ang mga lalaking anak ni Lotan ay sina Hori at Heman, at si Timna ang babaeng kapatid ni Lotan. ");
INSERT INTO tglulb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ito ang mga lalaking anak ni Sobal: sina Alvan, Manahat, Ebal, Zefo, at Onam. ");
INSERT INTO tglulb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ito ang mga lalaking anak ni Zibeon: si Aya at Ana. Ito ang Ana na nakahanap sa mainit na bukal sa kagubatan, habang nagpapastol siya ng mga asno ni Zibeon na kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ito ang mga anak ni Ana: Sina Dishon at Aholibama, na babaeng anak ni Ana. ");
INSERT INTO tglulb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ito ang mga lalaking anak ni Dishon: Sina Hemdan, Esban, Itran, at Keran. ");
INSERT INTO tglulb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ito ang mga lalaking anak ni Ezer: sina Bilhan, Zaavan, at Akan. ");
INSERT INTO tglulb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ito ang mga lalaking anak ni Dishan: sina Uz at Aran. ");
INSERT INTO tglulb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ito ang mga angkan ng mga Horeo: ang Lotan, Shobal, Zibeon, at Ana, ");
INSERT INTO tglulb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, Dishan: ito ang mga angkan ng mga Horeo, ayon sa kanilang mga talaan ng angkan sa lupain ng Seir. ");
INSERT INTO tglulb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ito ang mga hari na namahala sa lupain ng Edom bago pa man mamahala ang sinumang hari sa mga Israelita: ");
INSERT INTO tglulb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Si Bela na lalaking anak ni Beor, ay namahala sa Edom, at ang pangalan ng kanyang siyudad ay Dinaba. ");
INSERT INTO tglulb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Nang mamatay si Bela, saka naman si Jobab lalaking anak ni Zerah ng Bozra, ang namahala bilang kahalili niya. ");
INSERT INTO tglulb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Nang namatay si Jobab, si Husham na mula sa lupain ng mga Temaneo ang nagharing kahalili niya. ");
INSERT INTO tglulb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Nang mamatay si Husham, si Hadad na lalaking anak ni Bedad, na tumalo sa mga Midianita sa lupain ng Moab, ang nagharing kahalili niya. Ang pangalan ng kanyang siyudad ay Avit. ");
INSERT INTO tglulb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Nang namatay si Hadad, si Samla naman ng Masreka ang nagharing kahalili niya. ");
INSERT INTO tglulb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Nang mamatay si Samla, si Saul ng Rehobot na tagatabing-ilog ang naghari kahalili niya. ");
INSERT INTO tglulb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Nang mamatay si Saul, si Baal Hanan naman na lalaking anak ni Acbor ang nagharing kahalili niya. ");
INSERT INTO tglulb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Nang si Baal Hanan na lalaking anak ni Acbor, ay mamatay, si Hadar naman ang nagharing kahalili niya. Ang pangalan ng kanyang siyudad ay Pau. Ang pangalan ng kanyang asawa ay Mehetabel, babaeng anak ni Matred, na babaeng apo ni Me Zahab. ");
INSERT INTO tglulb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ito ang mga pangalan ng mga pinuno ng mga angkang nagmula sa lahi ni Esau, ayon sa kanilang mga angkan at kanilang mga rehiyon, sa kanilang mga pangalan: sina Timna, Alva, Jetet, ");
INSERT INTO tglulb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinon, ");
INSERT INTO tglulb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO tglulb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, at Iram. Ito ang mga pangulo ng angkan ng Edom, ayon sa kanilang pamayanan sa lupaing inagkin nila. Ito si Esau, ang ama ng mga Edomita. ");
INSERT INTO tglulb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Nanirahan si Jacob sa lupain kung saan naroon ang kanyang ama, sa lupain ng Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ito ang mga pangyayari tungkol kay Jacob. Nang labimpitong taong gulang pa lang si Jose, nagbabantay siya ng kawan kasama ang kanyang mga kapatid. Kasama niya ang mga anak na lalaki ni Bilhah at mga anak na lalaki ni Zilpah, mga asawa nang kanyang ama. Nagdala si Jose ng hindi kanais-nais na balita tungkol sa kanila sa kanilang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Minahal ni Israel si Jose nang mas higit sa lahat ng kanyang anak na lalaki dahil siya ang anak niya sa katandaan. Ginawan siya nang isang magandang damit. ");
INSERT INTO tglulb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nakita ng kanyang mga kapatid ang pagmamahal ng kanilang ama na mas higit kaysa sa lahat niyang kapatid na lalaki. Siya ay kinamuhian nila at hindi nakikipag-usap nang maayos. ");
INSERT INTO tglulb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nanaginip si Jose ng isang panaginip, at sinabi niya sa kanyang mga kapatid ang tungkol dito. Lalo pa nila siyang kinamuhia. ");
INSERT INTO tglulb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Sinabi niya sa kanila, “Pakiusap makinig kayo sa panaginip na aking napanaginipan. ");
INSERT INTO tglulb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Masdan ninyo, itinatali natin ang mga bigkis ng mga butil sa bukid at masdan ninyo, tumayo ang aking bigkis at tumuwid, at masdan ninyo, pumalibot ang inyong mga bigkis at yumuko sa aking bigkis. ");
INSERT INTO tglulb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Sinabi sa kanya ng kanyang mga kapatid, “Magiging hari ka ba talaga namin? Mamumuno ka sa amin? “Lalo siyang kinamuhian dahil sa kanyang mga panaginip at sa kanyang mga salita. ");
INSERT INTO tglulb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nanaginip siya ulit ng panaginip at sinabi niya ito sa kanyang mga kapatid. Sinabi niya, “Tingnan ninyo, nanaginip ako ng ibang panaginip: Ang araw at ang buwan at labing-isang bituin ay yumuko pababa sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Sinabi niya ito sa kanyang ama pati sa kanyang mga kapatid, at pinagsabihan siya ng kanyang ama. Sinabi niya sa kanya, “Ano itong panaginip na napaginipan mo? Talaga bang lalapit ang iyong ina, ako at ang mga kapatid mo para yumuko sa iyo sa lupa?” ");
INSERT INTO tglulb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nainggit sa kanya ang kanyang mga kapatid, pero ang kanyang ama ay itinago ang bagay sa kanyang isip. ");
INSERT INTO tglulb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Umalis ang mga kapatid ni Jose upang magpastol ng kawan ng kanilang ama sa Sechem. ");
INSERT INTO tglulb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Sinabi ni Jacob kay Jose, “Hindi ba nagpapastol ng kawan ang iyong mga kapatid sa Sechem? Halika, at ipapadala kita sa kanila.” Sinabi ni Jose sa kanya, “Nakahanda ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Sinabi niya sa kanya, “Umalis ka na ngayon, tingnan mo kung maayos ang mga kapatid mo at maayos ang mga kawan, at balitaan mo ako.” Kaya pinadala siya ni Jacob sa lambak ng Hebron, at nagpunta si Jose sa Sichem. ");
INSERT INTO tglulb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","May isang taong nakakita kay Jose. Masdan mo, si Jose ay pagala-gala sa isang bukid. Tinanong siya ng isang lalaki, “Ano ang hinahanap mo?” ");
INSERT INTO tglulb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Sinabi ni Jose, “Hinahanap ko ang aking mga kapatid. Pakiusap, sabihin mo sa akin kung saan nila nagpapastol ang kawan.” ");
INSERT INTO tglulb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Sinabi ng lalaki, “Umalis na sila sa lugar na ito, narinig ko silang nagsabi na, “Pumunta tayo sa Dotan. Pinuntahan ni Jose ang kanyang mga kapatid at natagpuan sila sa Dotan. ");
INSERT INTO tglulb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nakita nila si Jose mula sa di kalayuan, at bago siya makalapit sa kanila, nakapagplano na sila laban sa kanya para patayin siya. ");
INSERT INTO tglulb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Sinabi ng kanyang mga kapatid sa bawat isa, “Tingnan niyo, Papalapit na ang taong mapanaginipin. ");
INSERT INTO tglulb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Halikayo, kung ganon, patayin na natin siya at ihulog siya sa isa sa mga balon. Sabihin natin, 'Sinakmal siya ng isang mabangis na hayop.' Tingnan natin kung anong mangyayari sa kanyang mga panaginip.” ");
INSERT INTO tglulb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Narinig ito ni Reuben at iniligtas siya mula sa kanilang kamay. Sinabi niya, “Huwag nating kunin ang kanyang buhay.” ");
INSERT INTO tglulb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Sinabi ni Reuben sa kanila, “Huwag magpadanak ng dugo. Itapon siya sa balong ito sa deserto, ngunit huwag ninyo siyang hawakan”— upang mailigtas niya siya sa kanilang kamay para maibalik siya sa kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Nangyari na nang dumating si Jose sa kanyang mga kapatid, hinubad sa kaniya ang magandang damit. ");
INSERT INTO tglulb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Dinala siya at itinapon siya sa loob ng balon. Walang laman ang balon ni wala itong tubig. ");
INSERT INTO tglulb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Umupo sila para kumain ng tinapay. Tumingala sila at tumingin, at masdan, may paparating na isang karawan ng mga Ismaelita mula sa Gilead, kasama ang kanilang mga kamelyo na may dala-dalang mga sahog at balsamo at mira. Naglalakbay sila ay para dalhin ang mga iyon pababa sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Sabi ni Juda sa kanyang mga kapatid, “Anong pakinabang nito kung papatayin ang ating kapatid at pagtakpan ang kanyang dugo? ");
INSERT INTO tglulb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Halina kayo, at ipagbili natin siya sa mga Ismaelita, at huwag natin siyang pagbuhatan ng kamay. Dahil siya ay ating kapatid, ating laman. Pinakinggan siya ng kanyang mga kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Dumaan ang mga mangangalakal na Midianita. Inihaon si Jose ng kanyang mga kapatid at iniakyat pataas mula sa balon. Ipinagbili nila si Jose sa mga Ismaelita para sa dalawampung pirasong pilak. Dinala si Jose ng mga Ismaelita sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Bumalik si Reuben sa balon, at masdan, wala na si Jose sa loob ng balon. Pinunit niya ang kanyang damit. ");
INSERT INTO tglulb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Bumalik siya sa kanyang mga kapatid at sinabi, “Nasaan na ang bata? At ako, saan ako paparoon?” ");
INSERT INTO tglulb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kumatay sila ang isang kambing at pagkatapos kinuha nila ang damit ni Jose at sinawsaw ito sa dugo. ");
INSERT INTO tglulb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Pagkatapos, dinala nila ito sa kanilang ama at sinabi, “Nakita namin ito. Pakiusap tingnan mo kung ito ang damit ng inyong anak o hindi?” ");
INSERT INTO tglulb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nakilala ito ni Jacob at sinabi, “Ito ay damit ng aking anak. Sinakmal siya ng isang mabangis na hayop. Tiyak na nagkawasak-wasak ang katawan ni Jose.” ");
INSERT INTO tglulb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Pinunit ni Jacob ang kanyang mga damit at naglagay siya ng sako sa kanyang balakang. Nagluksa siya para sa kanyang anak ng maraming araw. ");
INSERT INTO tglulb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ang lahat ng kanyang mga anak na lalaki at babae ay pumunta para aliwin siya ngunit tumanggi siyang magpaaliw. Sabi niya, “Talagang bababa ako sa sheol na nagluluksa para sa aking anak.” Nanangis ang kanyang ama para kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ipinagbili siya ng mga Midianita sa Ehipto kay Potipar, isang opisyal ni Paraon, na kapitan ng bantay. ");
INSERT INTO tglulb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Dumating ang panahon na iniwan ni Juda ang kanyang mga kapatid na lalaki at tumira sa isang Adullamita, na ang pangalan ay Hira. ");
INSERT INTO tglulb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nakilala niya si Sua na anak ng Cananeo na lalaki na ang pangalan ay Sua. Pinakasalan niya at sinipingan niya. ");
INSERT INTO tglulb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Siya ay nabuntis at nagkaroon ng anak na lalaki. Siya ay pinangalanan Er. ");
INSERT INTO tglulb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nabuntis ulit siya at nagkaroon ng isang anak na lalaki. Tinawag niya siyang Onan. ");
INSERT INTO tglulb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nagkaroon ulit siya ng isang anak at tinawag siya sa pangalang Selah. Ito ay sa Kizib kung saan siya ipinanganak. ");
INSERT INTO tglulb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Nakahanap si Juda ng isang asawa para kay Er, panganay niya. Ang pangalan niya ay Tamar. ");
INSERT INTO tglulb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ang panganay niyang anak na si Er ay napakasama sa paningin ni Yahweh. Pinatay siya ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Sinabi ni Juda kay Onan, “Sumiping ka kasama ng asawa ng iyong kapatid na lalaki. Gawin mo ang tungkulin bilang isang kapatid na lalaki, at palakihin mo ang isang bata para sa iyong kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Alam na ni Onan na ang bata ay hindi kanya. Kapag sumisiping siya kasama ng asawa ng kanyang kapatid na lalaki, tinatapon niya sa lupa ang kanyang semilya upang hindi siya magkaroon ng anak para sa kanyang kapatid na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ang ginawa niya ay naging masama sa paningin ni Yahweh. Pinatay din siya ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Pagkatapos sinabi ni Juda kay Tamar, na kanyang manugang, “Manatili kang biyuda sa bahay ng iyong ama hanggang sa lumaki si Selah na aking anak.” Dahil sa isip niya, “Baka mamatay din siya katulad ng kanyang mga kapatid.” Umalis si Tamar at nanirahan sa bahay ng kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Pagkatapos ng mahabang panahon, ang anak na babae ni Sua na asawa ni Juda ay namatay. Si Juda ay naaliw at pumunta pataas sa kanyang mga manggugupit ng balahibo ng tupa sa Timnat, siya at ang kanyang kaibigan na si Hira na isang Adullamita. ");
INSERT INTO tglulb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Nasabihan si Tamar, “Tingnan mo, ang iyong biyenan na lalaki ay pupunta pataas sa Timnat upang gupitan ang balahibo ng kanyang mga tupa.” ");
INSERT INTO tglulb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Hinubad niya ang damit sa pagkabalo at tinakpan ang kanyang sarili ng isang belo at ibinalot ang sarili. Umupo siya sa tarangkahan ng Enaim, sa tabi ng daan patungong Timnat. Dahil nakita niyang si Selah ay lumaki na ngunit hindi siya binigay bilang asawa niya. ");
INSERT INTO tglulb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Nang makita siya ni Juda naisip niya na siya ay isang babaeng bayaran dahil tinakpan niya ang kanyang mukha. ");
INSERT INTO tglulb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Pumunta siya sa kanya sa tabing daan at sinabi, “Halika, pakiusap hayaan mo akong sumiping sa iyo.”- Dahil di niya alam na siya ang manugang niya- at sinabi niya, “Anong ibibigay mo sa akin para sipingan kita?” ");
INSERT INTO tglulb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Sinabi niya, “Papadalhan kita ng isang batang kambing na mula sa kawan.” Sinabi niya, “Maaari mo ba akong bigyan ng isang sangla hanggang maipadala mo ito?” ");
INSERT INTO tglulb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Sinabi niya, “Anong sangla ang maaari kong ibigay sa iyo?” At sinabi niya, “Ang inyong selyo at kordon, at ang tungkod na nasa iyong kamay.” Ibinigay ito sa kanya at sinipingan siya. Siya ay nabuntis sa pamamagitan niya. ");
INSERT INTO tglulb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tumindig si Tamar at umalis palayo. Inalis niya ang kanyang belo at isinuot ang damit sa kanyang pagkabalo. ");
INSERT INTO tglulb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ipinadala ni Juda ang batang kambing mula sa kawan kasama ang kanyang kaibigan na Adullamita para tanggapin ang sangla na mula sa kamay ng babae, ngunit hindi na niya siya nakita. ");
INSERT INTO tglulb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Pagkatapos nito ay tinanong ng Adullamita ang mga lalaki sa lugar, “Nasaan na ang kultong babaeng bayaran na nasa Enaim sa tabing daan? “Sinabi nila, wala namang kultong babaeng bayaran dito.” ");
INSERT INTO tglulb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Bumalik siya kay Juda at sinabi, “Hindi ko siya nakita. Maging ang mga lalaki sa lugar ay nagsabi, 'Walang naging kultong babaeng bayaran dito. ");
INSERT INTO tglulb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Sinabi ni Juda, “Hayaan mong itago niya ang mga bagay, baka malagay tayo sa kahihiyan. Totoo nga, ipinadala ko ang batang kambing, ngunit hindi mo siya natagpuan.” ");
INSERT INTO tglulb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Dumating ang panahon, pagkalipas ng tatlong buwan na sinabi kay Juda, “Ang iyong manugang na si Tamar ay naging babaeng bayaran, at totoo nga, siya ay nabuntis sa dahil doon.” Sinabi ni Juda, “Siya'y ilabas upang sunugin.” ");
INSERT INTO tglulb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Nang siya ay dinala palabas, nagpadala siya ng mensahe para sa kanyang biyenan na lalaki, “Dahil sa lalaking nagmamay-ari nito nabuntis ako.” Sabi niya, “Pakiusap alamin ninyo kung kaninong selyo, mga kordon at tungkod ito.” ");
INSERT INTO tglulb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nakilala ni Juda ang mga ito at sinabi, “Siya ay mas matuwid kaysa sa akin, dahil hindi ko siya ibinigay bilang isang asawa kay Selah, na aking anak na lalaki.” Siya ay hindi na muling sumiping sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Nang siya ay manganganak na, masdan, kambal ang nasa kanyang sinapupunan. ");
INSERT INTO tglulb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Nang nanganganak na siya, may isang naglabas ng kamay, at kinuha ng komadrona ang isang pulang sinulid at itinali ito sa kanyang kamay at sinabi, “Ito ang unang lumabas.” ");
INSERT INTO tglulb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","nang inurong niya ang kanyang kamay, at masdan, ang kapatid niyang lalaki ay unang lumabas. Ang komandrona ay nagsabi, “Paano ka nakalabas!” At pinangalanan siyang Perez. ");
INSERT INTO tglulb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Pagkatapos ang kapatid niya ay lumabas, na mayroong pulang sinulid sa kanyang kamay, at Zera ang ipinangalan sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Dinala si Jose pababa sa Ehipto. Binili siya ni Potipar, na isang opisyal at kapitan ng mga bantay ni Paraon at isang taga-Ehipto, mula sa mga Ismaelita, na nagdala sa kanya doon. ");
INSERT INTO tglulb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Si Yahweh ay kasama ni Jose at siya'y naging mayamang tao. Nanirahan siya sa bahay ng kanyang amo na taga-Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nakita ng kanyang amo na kasama niya si Yahweh at lahat ng ginawa niya ay pinasagana ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nakitaan si Jose ng pabor sa kanyang paningin. Pinaglingkuran niya si Potipar. Ginawa ni Potipar na tagapangasiwa si Jose ng kanyang bahay, at lahat ng nasa kanya, nilagay niya lahat sa ilalim ng kanyang pangangalaga. ");
INSERT INTO tglulb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Dumating ang panahon na ginawa siyang tagapangasiwa ng kanyang bahay at sa lahat ng kanyang pagmamay-ari, kaya pinagpala ni Yahweh ang buong bahay ng taga-Ehipto dahil kay Jose. Ang pagpapala ni Yahweh ay nasa lahat ng bagay na pagmamay-ari ni Potipar sa kanyang bahay at sa kanyang bukid. ");
INSERT INTO tglulb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Inilagay ni Potipar ang lahat ng nasa kanya sa ilalim ng pangangalaga ni Jose. Hindi na niya kailangan mag-isip tungkol sa anumang bagay maliban sa pagkain na kinakain niya. Ngayon si Jose ay matipuno at kaakit-akit. ");
INSERT INTO tglulb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Dumating ang panahon na pinagnanasaan si Jose ng asawa ng kanyang amo. Sinabi niya, “Sumiping ka sa akin”. ");
INSERT INTO tglulb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ngunit tinanggihan niya ito at sabay sabi sa asawa ng kanyang amo, “Tingnan mo, ang amo ko ay di-nagbigay pansin sa kung ano ang pinaggagawa ko dito sa bahay, at nilagay niya lahat ng kanyang pag-aari sa ilalim ng aking pangangalaga. ");
INSERT INTO tglulb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Walang mas nakakataas sa pamamahay na ito maliban sa akin. Wala siyang anumang pinagkait sa akin maliban sa iyo, dahil ikaw ang asawa niya. Paano ko kaya magagawa itong malaking kasamaan at magkakasala laban sa Diyos?” ");
INSERT INTO tglulb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kinausap niya si Jose sa bawat araw, ngunit tumanggi pa rin siya na sipingan siya o para makasama siya. ");
INSERT INTO tglulb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Dumating ang isang araw na pumunta siya sa bahay para gawin ang kanyang gawain. Walang sinuman sa mga lalaki sa bahay ang naroon sa bahay. ");
INSERT INTO tglulb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Siya ay hinablot niya sa pamamagitan ng kanyang damit at sinabi, “Sipingan mo ako.” Naiwanan niya ang kanyang damit sa kanyang kamay, lumayo, at nagpunta sa labas. ");
INSERT INTO tglulb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Dumating ang panahon, nang makita niya na naiwanan ni Jose ang kanyang damit sa kanyang kamay at lumayo palabas, ");
INSERT INTO tglulb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tinawag niya ang mga lalaki sa kanyang bahay at sinabi sa kanila, “Tingnan ninyo, nagdala si Potipar ng isang Hebreo para hamakin tayo. Pinuntahan niya ako para sipingan ako, at ako ay sumigaw. ");
INSERT INTO tglulb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Dumating ang panahon nang marinig niya akong sumigaw, naiwan niya ang kanyang damit sa akin, lumayo, at pumunta sa labas.” ");
INSERT INTO tglulb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tinabi niya ang damit hanggang sa makauwi ang kanyang amo sa bahay. ");
INSERT INTO tglulb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Sinabi niya sa kanya ang paliwanag na ito, “Ang lingkod na Hebreo na dinala mo sa amin ay nagpunta sa akin para hamakin ako. ");
INSERT INTO tglulb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Nang sumigaw ako, iniwan niya ang kanyang damit sa akin at lumayo palabas.” ");
INSERT INTO tglulb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Dumating ang panahon, nang marinig ng kanyang amo ang pagpapaliwanag ng kanyang asawa sa kanya, “Ito ang ginawa ng iyong lingkod sa akin,” siya ay naging labis na galit. ");
INSERT INTO tglulb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kinuha si Jose ng kanyang amo at siya ay nilagay sa bilangguan, ang lugar na kung saan nakakulong ang mga bilanggo ng hari. Siya ay naroon sa bilangguan. ");
INSERT INTO tglulb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ngunit si Yahweh ay kasama ni Jose at siya ay nagpakita katapatan sa tipan sa kanya. Siya ay binigyan niya ng kagandahang-loob sa paningin ng bantay ng kulungan. ");
INSERT INTO tglulb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Binigay ng bantay ng kulangan sa kamay ni Jose ang pamamahala sa lahat ng bilanggo sa kulungan. Kahit anong gawin nila roon, si Jose ang namamahala. ");
INSERT INTO tglulb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wala ng inaalalang anuman ang bantay ng kulungan na nasa kamay ni Jose, dahil si Yahweh ay kasama niya. Kahit anong gawin niya, pinasagana siya ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Dumating ang panahon pagkatapos ng mga bagay na ito, ang tagahawak ng saro at ang panadero ng hari ng Ehipto ay nagkasala sa kanilang amo, na hari ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Galit si Paraon sa dalawa niyang mga opisyal, ang punong tagahawak ng saro at ang punong panadero. ");
INSERT INTO tglulb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Sila ay nilagay niya sa kulungan sa pangangasiwa ng kapitan ng mga bantay, sa parehong kulungan kung saan nakabilanggo si Jose. ");
INSERT INTO tglulb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tinalaga ng kapitan ng mga bantay si Jose na maging tagapaglingkod nila. Nananatili silang nakabilanggo sa kaunting panahon. ");
INSERT INTO tglulb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pareho silang nanaginip ng isang panaginip—ang tagahawak ng saro at ang panadero ng hari ng Ehipto na nakakulong sa bilangguan—bawat isa ay may sariling panaginip sa parehong gabi, at bawat panaginip ay mayroong sariling paliwanag. ");
INSERT INTO tglulb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kinaumagahan, dumating si Jose sa kanila at sila ay nakita niya. Masdan, sila ay malungkot. ");
INSERT INTO tglulb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Tinanong niya ang mga opisyal ni Paraon na kasama niya sa pagbabantay sa bahay ng kanyang amo, nagsasabing, “Bakit kayo labis na malungkot ngayong araw na ito?” ");
INSERT INTO tglulb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Sinabi nila sa kanya, “Pareho kaming nanaginip ng isang panaginip at wala ni isa ang makapagpaliwanag nito.” Sinabi ni Jose sa kanila, “Hindi ba ang mga pagpapaliwanag ay nabibilang sa Diyos? Pakiusap, sabihin niyo sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Sinabi ng punong tagahawak ng saro kay Jose ang kanyang panaginip. Sinabi niya sa kanya, “Sa aking panaginip, narito, isang puno ng ubas ay nasa harapan ko. ");
INSERT INTO tglulb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Sa puno ng ubas ay may tatlong mga sanga. Habang ito ay sumisibol, ang mga bulaklak nito ay lumabas at ang mga buwig ng ubas ay nahinog. ");
INSERT INTO tglulb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nasa kamay ko ang saro ni Paraon. Kinuha ko ang mga ubas at piniga ko ito sa saro ni Paraon, at nilagay ko ang saro sa kamay ni Paraon.” ");
INSERT INTO tglulb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Sinabi ni Jose sa kanya, “Ito ang paliwanag nito. Ang tatlong mga sanga ay tatlong mga araw. ");
INSERT INTO tglulb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Sa loob ng tatlong mga araw, itataas ni Paraon ang iyong ulo at ibabalik ka niya sa iyong katungkulan. Ilalagay mo ang saro ni Paraon sa kanyang kamay, katulad noong ikaw pa ang kanyang tagahawak ng saro. ");
INSERT INTO tglulb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ngunit isipin mo ako kung ikaw ay mapabuti na, at pakiusap pakitaan mo ako ng kagandahang loob. Banggitin mo ako kay Paraon at palabasin ako sa bilangguang ito. ");
INSERT INTO tglulb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Dahil ang totoo ako ay inagaw palabas sa lupain ng mga Hebreo. Dito naman ay wala akong ginawa para ilagay nila ako sa bartolinang ito.” ");
INSERT INTO tglulb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nang makita ng punong panadero na ang paliwanag ay kaaya-aya, sinabi niya kay Jose, “Nagkaroon din ako ng panaginip at narito, tatlong mga sisidlan ng tinapay ang nasa aking ulo. ");
INSERT INTO tglulb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ang nasa taas na sisidlan ay lahat ng mga uri ng mga pagkain na naluto para kay Paraon, ngunit kinain ito ng mga ibon palabas ng sisidlan na nasa aking ulo.” ");
INSERT INTO tglulb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Sumagot si Jose at sinabi, “Ito ang paliwanag. Ang tatlong mga basket ay tatlong mga araw. ");
INSERT INTO tglulb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Sa loob ng tatlong mga araw ay itataas ni Paraon ang iyong ulo at bibitayin ka sa puno. Kakainin ng mga ibon ang iyong laman.” ");
INSERT INTO tglulb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Dumating ang panahon sa ikatlong araw ay ang kaarawan ni Paraon. Gumawa siya ng salu-salo para sa lahat ng kanyang mga lingkod. Siya ay nagbigay ng natatanging pansin sa punong tagahawak ng saro at sa punong panadero, na mas higit sa lahat ng iba niyang mga lingkod. ");
INSERT INTO tglulb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Binalik niya ang punong tagahawak ng saro sa kanyang pananagutan, at muli niyang nilagay ang saro sa kamay ni Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ngunit binitay niya ang punong panadero gaya ng paliwanag ni Jose sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ganoon pa man ay hindi naalala ng punong tagahawak ng saro na tulungan si Jose. Sa halip, kinalimutan niya ang tungkol sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nangyari na pagkatapos ng dalawang buong taon, na nagkaroon si Paraon ng panaginip. Masdan, nakatayo siya sa tabi ng Ilog Nilo. ");
INSERT INTO tglulb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Masdan, may pitong bakang kanais-nais at matataba ang umahon mula sa Nilo, at nanginain sila sa mga tambo. ");
INSERT INTO tglulb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Masdan, may pitong iba pang mga bakang hindi kanais-nais at payat ang umahon kasunod nila sa Nilo. Tumayo sila katabi ng ibang mga baka sa pampang ng ilog. ");
INSERT INTO tglulb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Pagkatapos, kinain ng pitong hindi kanais-nais at payat na baka ang pitong kanais-nais at matabang baka. Pagkatapos, nagising si Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Natulog siya at nanaginip sa pangalawang pagkakataon. Masdan, pitong uhay ng butil ang tumubo sa isang tangkay, malulusog at mabubuti. ");
INSERT INTO tglulb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Masdan, pitong uhay, payat at nilanta ng silangang hangin ang umusbong kasunod nila. ");
INSERT INTO tglulb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Nilunok ng mga payat na uhay ang pitong malulusog at buong uhay. Gumising si Paraon at masdan, iyon ay panaginip. ");
INSERT INTO tglulb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kinaumagahan ay nabagabag ang kaniyang espiritu. Pinapunta niya at pinatawag ang lahat ng mga salamangkero at mga pantas ng Ehipto. Sinabi sa kanila ni Paraon ng kaniyang mga panaginip, pero walang ni isa ang makapagpaliwanag ng mga iyon kay Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Pagkatapos sinabi ng punong tagahawak ng saro kay Paraon, “Ngayon naiisip ko ang aking mga pagkukulang. ");
INSERT INTO tglulb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nagalit si Paraon sa kaniyang mga lingkod, at inilagay ako sa pangangalaga sa bahay ng kapitan ng mga bantay, ang punong panadero at ako. ");
INSERT INTO tglulb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nanaginip kami ng isang panaginip sa parehong gabi, siya at ako. Nanaginip kami bawat tao ayon sa paliwanag ng kaniyang panaginip. ");
INSERT INTO tglulb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Doon kasama namin ang isang binatang Hebreo, na isang lingkod ng kapitan ng mga bantay. Sinabi namin sa kaniya at pinaliwanag niya sa amin ang aming mga panaginip. Ipinaliwanag niya sa bawat isa sa amin na ayon sa aming panaginip. ");
INSERT INTO tglulb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nangyari na kung ano ang ipinaliwanag niya sa amin, iyon ang nangyari. Binalik ako ni Paraon sa aking tungkulin, pero ang isa ay kaniyang binitay.” ");
INSERT INTO tglulb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pagkatapos pinadala at pinatawag ni Paraon si Jose. Mabilis nila siyang inilabas mula sa piitan. Inahitan niya ang kaniyang sarili, pinalitan ang kaniyang damit, at pumunta kay Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Sinabi ni Paraon kay Jose, “Mayroon akong panaginip pero walang tagapagpaliwanag nito. Pero narinig ko ang tungkol sa iyo, na kapag makarinig ka ng panaginip ay maipapaliwanag mo ito. ” ");
INSERT INTO tglulb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Sinagot ni Jose si Paraon, sinabing, “Hindi ito nasa akin. Ang Diyos ang sasagot kay Paraon na may kagandahang loob.” ");
INSERT INTO tglulb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Nagsalita si Paraon kay Jose, “Sa panaginip ko, masdan, nakatayo ako sa pampang ng Nilo. ");
INSERT INTO tglulb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Masdan, pitong mga bakang matataba at kanais-nais ang umahon mula sa Nilo at nanginain sila sa mga tambo. ");
INSERT INTO tglulb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Masdan, pitong ibang mga bakang mahihina, hindi kanais-nais at payat ang umahon kasunod nila. Hindi kailanman ako nakakita sa buong lupain ng Ehipto ng ganoong pagka hindi kanais-nais na katulad nila. ");
INSERT INTO tglulb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kinain ng payat at hindi kanais-nais na mga baka ang unang pitong matatabang mga baka. ");
INSERT INTO tglulb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Nang matapos nilang kainin ang mga ito, hindi malalamang sila ay kinain nila, dahil sa sila ay nanatiling hindi kanais-nais tulad ng dati. Pagkatapos nagising ako. ");
INSERT INTO tglulb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Tumingin ako sa aking panaginip at masdan, pitong uhay ang umusbong sa isang tangkay, puno at mabubuti. ");
INSERT INTO tglulb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Masdan, pito pang mga uhay, lanta, payat at nilanta ng silangang hangin, ang umusbong kasunod nila. ");
INSERT INTO tglulb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Nilunok ng mga payat na uhay ang pitong mabubuting uhay. Sinabi ko itong mga panaginip na ito sa mga salamangkero, pero walang ni isa ang makapagpaliwanag nito sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Sinabi ni Jose kay Paraon, “Ang mga panaginip ni Paraon ay magkatulad. Kung ano ang gagawin ng Diyos, ipinahayag na niya kay Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ang pitong mga mabubuting baka ay pitong taon at ang pitong mga mabubuting uhay ay pitong taon. Ang mga panaginip ay magkatulad. ");
INSERT INTO tglulb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","At ang pitong payat at hindi kanais-nais na mga baka na umahon kasunod nila ay pitong taon, at saka ang pitong payat na uhay na nilanta ng silangang hangin ay magiging pitong taon ng taggutom. ");
INSERT INTO tglulb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Iyon ang bagay na sinabi ko kay Paraon. Kung ano ang gagawin ng Diyos ipinakita na niya kay Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Tingnan mo, pitong taon ng dakilang kasaganahan ang darating sa buong lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Pitong taon ng taggutom ay darating pagkatapos nila at lahat ng kasaganahan ay makakalimutan sa lupain ng Ehipto at ang taggutom ay wawasak sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ang kasaganahan ay hindi na maaalala sa lupain dahil sa taggutom na susunod, dahil ito ay magiging napakalala. ");
INSERT INTO tglulb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ang panaginip ay inulit kay Paraon sa kadahilanang ang mga bagay ay itinatag na ng Diyos at hindi magtatagal ay gagawin ito ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ngayon hayaang maghanap si Paraon ng taong marunong at matalino, at ilagay siya sa pamamahala sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Hayaan si Paraon na gawin ito: hayaan siyang humirang ng mga tagapangasiwa sa lupain. Hayaan silang kumuha ng ikalima sa mga pananim ng Ehipto sa pitong saganang taon. ");
INSERT INTO tglulb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Hayaan silang tipunin lahat ng pagkain ng mga paparating na mabubuting taon. Hayaan silang mag-imbak ng mga butil sa ilalim ng kapangyarihan ni Paraon para sa pagkain sa mga siyudad. Hayaan silang bantayan ito. ");
INSERT INTO tglulb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ang pagkain ay magiging panustos sa lupain para sa pitong taong taggutom na mangyayari sa lupain ng Ehipto. Sa ganitong paran ang lupain ay hindi mawawasak dahil sa taggutom.” ");
INSERT INTO tglulb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ang payong ito ay mabuti sa mga mata ni Paraon at sa mga mata ng lahat ng kaniyang mga lingkod. ");
INSERT INTO tglulb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Sinabi ni Paraon sa kaniyang mga lingkod, “Makakasumpong kaya tayo ng ganitong tao, na kinakasihan ng Espiritu ng Diyos?” ");
INSERT INTO tglulb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kaya sinabi ni Paraon kay Jose, “Dahil pinakita ng Diyos ang lahat ng ito sa iyo, wala ng ibang marunong at matalinong tulad mo. ");
INSERT INTO tglulb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Mangingibabaw ka sa aking bahay at ayon sa salita mo pamamahalaan ang lahat ng tauhan ko. Tanging sa trono lamang ako ay magiging higit na mataas kaysa sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Sinabi ni Paraon kay Jose, “Tingnan mo, inilagay kita sa itaas ng buong lupain ng Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tinanggal ni Paraon ang kaniyang singsing na pantatak mula sa kaniyang kamay at nilagay niya ito sa kamay ni Jose. Binihisan niya siya ng mga damit na pinong lino at nilagyan ng gintong kuwintas sa kaniyang leeg. ");
INSERT INTO tglulb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Pinasakay niya siya sa ikalawang karo na pag-aari niya. Sumigaw ang mga lalaki sa harapan niya, “Ibaluktot ang tuhod.” Nilagay siya ni Paraon sa itaas ng lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Sinabi ni Paraon kay Jose, “Ako si Paraon at maliban sa iyo, walang taong magtataas ng kaniyang kamay o kaniyang paa sa lahat ng lupain ng Ehipto. ” ");
INSERT INTO tglulb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Tinawag ni Paraon ang pangalan ni Jose na “Zafenat-panea.” Binigay niya si Asenat, ang anak na babae ni Potifera na pari ng On, para maging asawa. Ang kapangyarihan ni Jose ay nasa itaas ng buong Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Si Jose ay tatlumpung taong gulang nang tumayo siya sa harap ni Paraon, hari ng Ehipto. Lumabas si Jose mula sa presensya ni Paraon at pumunta sa buong lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sa pitong mabiyayang taon ang lupain ay nagbunga nang masagana. ");
INSERT INTO tglulb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Tinipon niya lahat ng pagkaing nasa lupain ng Ehipto ng pitong taon at inilagay ang pagkain sa mga siyudad. Inilagay niya sa bawat siyudad ang pagkain galing sa mga bukid na nakapaligid dito. ");
INSERT INTO tglulb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Inimbak ni Jose ang mga butil na parang buhangin ng dagat, na sa kalabisan ay tumigil na siya sa pagbilang dahil ito ay hindi mabilang. ");
INSERT INTO tglulb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","May dalawang anak na lalaki si Jose bago dumating ang mga taon ng taggutom, na isinilang para sa kaniya ni Asenat, ang anak na babae ni Potifera na pari ng On. ");
INSERT INTO tglulb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Tinawag ni Jose ang pangalan ng kaniyang panganay na Manases, at sinabi niya, “Ginawa ng Diyos na makalimutan ko ang lahat ng aking mga bagabag at lahat ng sambahayan ng aking ama.” ");
INSERT INTO tglulb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Tinawag niya ang pangalan ng kaniyang pangalawang anak na Efraim, dahil sinabi niya, “Ginawa akong mabunga ng Diyos sa lupain ng aking dalamhati.” ");
INSERT INTO tglulb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ang pitong saganang mga taon na nasa lupain ng Ehipto ay natapos na. ");
INSERT INTO tglulb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ang pitong taon ng taggutom ay nagsimula, ayon sa nasabi ni Jose. Mayroong taggutom sa lahat ng mga lupain, pero sa lahat ng lupain ng Ehipto ay mayroong pagkain. ");
INSERT INTO tglulb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nang ang buong lupain ng Ehipto ay gutom na gutom na, tumawag ng malakas ang mga tao kay Paraon para sa pagkain. Sinabi ni Paraon sa lahat ng mga taga Ehipto, “Pumunta kayo kay Jose at gawin ang anumang sabihin niya.” ");
INSERT INTO tglulb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ang taggutom ay nasa buong lupain. Binuksan ni Jose ang lahat ng mga kamalig at nagbenta sa mga taga-Ehipto. Ang taggutom ay napakatindi sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ang buong mundo ay pumupunta sa Ehipto upang bumili ng butil kay Jose dahil ang taggutom ay matindi sa buong mundo. ");
INSERT INTO tglulb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ngayon, napagalaman ni Jacob na may butil sa Ehipto. Sinabi niya sa kanyang mga anak na lalaki, “Bakit kayo nakatingin sa isa't isa?” ");
INSERT INTO tglulb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Sinabi niya, “Tingnan niyo ito, narinig kong mayroong butil sa Ehipto. Bumaba kayo doon at bumili para sa atin mula doon para tayo ay mabuhay at hindi mamatay.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ang sampung lalaking kapatid ni Jose ay bumaba para bumili ng butil mula sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ngunit si Benjamin, na kapatid ni Jose, ay hindi ipinasama ni Jacob sa kaniyang mga lalaking kapatid, dahil sinabi niya, “Baka may kapahamakang maaaring mangyari sa kanya.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ang mga lalaking anak ni Israel ay dumating para bumili kasama ng mga dumating, dahil ang taggutom ay nasa lupain ng Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ngayon si Jose ang gobernador sa buong lupain. Siya ang nagbebenta sa lahat ng tao sa lupain. Dumating ang mga lalaking kapatid ni Jose at nagpatirapa sila sa kanyang harapan. ");
INSERT INTO tglulb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Nakita ni Jose ang kanyang mga lalaking kapatid at nakilala niya ang mga ito, ngunit nagpanggap siya sa kanila at nagsalita ng marahas sa kanila. Sinabi niya sa kanila, “Saan kayo nanggaling?” Sinabi nila, “Mula po sa lupain ng Canaan para bumili ng pagkain.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nakilala ni Jose ang kanyang mga lalaking kapatid ngunit siya ay hindi nila nakilala. ");
INSERT INTO tglulb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Naalala ni Jose ang mga naging panaginip niya patungkol sa kanila. Sinabi niya sa kanila, “Kayo ay mga ispiya. Dumayo kayo para tingnan ang mga bahagi ng lupain na hindi nababantayan.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Sinabi nila sa kanya, “Hindi po, aking panginoon. Ang inyong mga lingkod ay dumating para bumili ng pagkain. ");
INSERT INTO tglulb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kaming lahat ay mga lalaking anak ng iisang tao. Kami ay tapat na mga lalaki. Ang mga lingkod po ninyo ay hindi mga ispiya.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Sinabi niya sa kanila, “Hindi, kayo ay dumating para tingnan ang mga hindi nababantayang mga bahagi ng lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Sinabi nila, “Kami na iyong mga lingkod ay labindalawang magkakapatid na lalaki, mga anak ng isang tao sa lupain ng Canaan. Makikita ninyo, ang bunso ngayong araw ay kapiling ng aming ama, at isang kapatid na lalaki ay hindi na nabubuhay.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Sinabi ni Jose sa kanila. “Iyon na nga ang sinasabi ko sa inyo; kayo'y mga ispiya. ");
INSERT INTO tglulb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Sa pamamagitan nito kayo ay masusubok. Sa pamamagitan ng buhay ni Paraon, hindi kayo aalis dito, maliban na lang kung pupunta rito ang bunso ninyong kapatid na lalaki ");
INSERT INTO tglulb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ipadala ninyo ang isa sa inyo at hayaan ninyong kunin niya ang inyong kapatid. Mananatili kayo sa kulungan, upang masubukan ang inyong mga salita, kung mayroon bang katotohanan sa inyo, o sa buhay ni Paraon tiyak na mga ispiya kayo.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Silang lahat ay isinailalim niya sa pagkakabilanggo sa loob ng tatlong araw. ");
INSERT INTO tglulb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sinabi sa kanila ni Jose sa ikatlong araw. “Gawin ninyo ito at mabuhay, dahil takot ako sa Diyos. ");
INSERT INTO tglulb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kung kayo ay mga lalaking tapat, hayaan ang isa sa inyong mga lalaking kapatid na makulong sa bilangguang ito, ngunit pumunta kayo, magdala kayo ng butil para sa taggutom ng inyong mga tahanan. ");
INSERT INTO tglulb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Dalhin ninyo ang inyong bunsong kapatid na lalaki sa akin para ang inyong salita ay mapatunayan at hindi kayo mamamatay.” Kaya ginawa nga nila ito. ");
INSERT INTO tglulb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Sinabi nila sa isa't-isa, “Tayo ay tunay na nagkasala tungkol sa ating lalaking kapatid dahil nakita natin ang paghihinagpis ng kanyang kaluluwa nang siya ay magmakaawa sa atin at hindi tayo nakinig. Dahil doon ang kabalisahan ay dinaranas natin.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Sinagot sila ni Reuben, “Hindi ba sinabi ko sa inyo, 'Huwag magkasala laban sa bata,' ngunit hindi kayo nakinig? Tingnan ninyo ngayon, ang kanyang dugo ay hinihingi sa atin.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Hindi nila alam na naiintindihan sila ni Jose, dahil may isang tagapagsalin na namamagitan sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Siya ay tumalikod sa kanila at nanangis. Bumalik siya at nagsalita sa kanila. Kinuha niya si Simeon mula sa piling nila at iginapos siya habang sila ay nakatingin. ");
INSERT INTO tglulb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Pagkatapos ay inutusan ni Jose ang kanyang mga lingkod na punuin ng butil ang mga bayong ng kaniyang mga kapatid, at ilagay ang pera ng bawat lalaki pabalik sa kanilang mga sako, at bigyan sila ng mga kakailanganin para sa paglalakbay. Ginawa ito para sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Pinasanan ng mga magkakapatid ng butil ang kanilang mga asno at sila'y umalis na roon. ");
INSERT INTO tglulb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Habang ang isa sa kanila ay nagbubukas ng kanyang sako para ipakain sa kanyang asno sa isang lugar-panuluyan, nakita niya ang kanyang pera. At narito, nasa bukana ito ng kanyang sako. ");
INSERT INTO tglulb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Sinabi niya sa kanyang mga lalaking kapatid, “Ang aking salapi ay naibalik sa akin. Tingnan ninyo itong nasa aking sako.” At ang kanilang mga puso ay nangabagabag at ang lahat ay nanginig. Sinabi nila, “Ano itong ginawa sa atin ng Diyos?” ");
INSERT INTO tglulb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pumunta sila kay Jacob, na kanilang ama sa lupain ng Canaan at sinabi nila ang lahat ng nangyari sa kanila. Sinabi nila, ");
INSERT INTO tglulb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ang lalaking panginoon ng lupain ay marahas na nagsalita sa amin at inisip niyang kami ay mga tiktik sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Sinabi namin sa kanya, 'Kami po ay mga lalaking tapat. Hindi po kami mga tikitk. ");
INSERT INTO tglulb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kami po ay labindalawang magkakapatid, mga lalaking anak ng aming ama. Ang isa ay hindi na po nabubuhay, at ang bunso ay kapiling ng aming ama ngayong araw sa lupain ng Canaan.' ");
INSERT INTO tglulb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Sinabi sa amin ng lalaking panginoon ng lupain, 'Sa pamamagitan nito malalaman ko na kayo ay mga lalaking tapat. Iwan ninyo sa akin ang isa sa inyong kapatid na lalaki, kumuha kayo ng butil para sa tag-gutom sa inyong mga tahanan, at humayo na kayo sa inyong daan. ");
INSERT INTO tglulb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Dalhin ninyo ang inyong bunsong kapatid sa akin. Pagkatapos nito ay malalaman ko na hindi nga kayo mga tiktik, ngunit mga taong tapat. Pagkatapos ay papalayain ko ang inyong lalaking kapatid, at maaari na kayong mangalakal sa lupain.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Dumating ang panahon habang inaalis nila ang laman ng kanilang mga sako, at narito nga, ang mga lalagyan ng pilak ng bawat isa ay nasa kanilang sako. Nang makita nila at ng kanilang ama ang mga lalagyan ng pilak, sila ay natakot. ");
INSERT INTO tglulb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Sinabi sa kanila ni Jacob na kanilang ama sa, “Inialis ninyo sa akin ang aking mga anak. Hindi na nabubuhay si Jose, si Simeon ay wala na, at kukunin pa ninyo si Benjamin palayo. Lahat ng ito ay laban sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Si Reuben ay nagsalita sa kanyang ama, na nagsasabing. “Maaari mong patayin ang dalawa kong anak kung hindi ko maibalik sa iyo si Benjamin. Ilagay mo siya sa aking mga kamay, at muli ko siyang dadalhin sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Sinabi ni Jacob, “Ang aking anak ay hindi pupunta pababa kasama ninyo. Dahil ang kanyang kapatid na lalaki ay patay na at siya na lamang ang mag-isang naiwan. Kapag may kapahamakang nangyari sa kanya sa daan kung saan kayo pupunta, tuluyan mo nang ibababa ang pagka-abo ng aking buhok kasama ng kalungkutan sa sheol.” ");
INSERT INTO tglulb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Matindi na ang taggutom sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Dumating ang panahon nang maubos na nilang kainin ang butil na kinuha nila mula sa Ehipto, sinabi ng kanilang ama, “Humayo kayong muli at bumili ng pagkain natin. ");
INSERT INTO tglulb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Sinabi sa kanya ni Juda “Mahigpit kaming binalaan ng lalaki, 'Hindi ninyo makikita ang aking mukha maliban na lamang kung kasama ninyo ang iyong kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kung hahayaan mong isama namin ang aming kapatid, bababa kami at bibili ng pagkain para sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ngunit kung hindi mo siya ipapasama, hindi kami bababa. Dahil sinabi ng lalaki sa amin, “Hindi ninyo makikita ang aking mukha maliban na lamang kung kasama ninyo ang inyong kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Sinabi ni Israel, “Bakit mo ako pinakikitunguhan ng masama sa pamamagitan ng pagsasabi sa taong iyon na meron pa kayong isang kapatid?” ");
INSERT INTO tglulb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Sinabi nila, “Nagtanong ang lalaki ng mga bagay tungkol sa amin at sa ating pamilya. Sinabi niya, 'Buhay pa ba ang iyong ama? Mayroon pa ba kayong ibang kapatid?' Sinagot namin siya ayon sa mga tanong na ito. Paano namin malalaman na sasabihin niyang, “Dalhin mo dito ang iyong kapatid?” ");
INSERT INTO tglulb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Sinabi ni Judah sa kanyang ama, “Ipadala mo ang batang lalaki sa amin. Tatayo kami at aalis upang mabuhay kami at hindi mamatay, kapwa kami, ikaw, at ang aming mga anak. ");
INSERT INTO tglulb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ako ang mananagot sa kanya. Ako ang pananagutin mo. Kung hindi ko siya maibabalik sa iyo at maihaharap sa iyo hayaan mong ako ang masisi habang buhay. ");
INSERT INTO tglulb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kung hindi kami maaantala, sigurado ngayon nakabalik na kami dito nang pangalawang beses”. ");
INSERT INTO tglulb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Sinabi ng kanilang ama na si Israel, “Kung ganoon, gawin ninyo ito ngayon. Kumuha kayo ng mga pinaka magandang produkto sa ating lupain sa inyong mga sisidlan. Magdala kayo ng regalo sa taong iyon: tulad ng balsamo at pulot-pukyutan, pabango at mirra, pili at almendra. ");
INSERT INTO tglulb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Doblehin ninyo ang perang dala ninyo. Ang perang naisuli mula sa pagbukas ng inyong mga sako, dalhin ninyo ulit sa inyong mga kamay. Baka isa lang itong pagkakamali. ");
INSERT INTO tglulb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Dalhin rin ang inyong kapatid na lalaki. Tumayo at pumunta kayo ulit sa taong iyon. ");
INSERT INTO tglulb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nawa'y kaawaan kayo ng Makapangyarihang Diyos sa harap ng taong iyon, upang palayain niya sa inyo ang iba niyong mga kapatid at si Benjamin. Kung ako'y nagdadalamhati sa aking mga anak, ako'y nagdadalamhati. ");
INSERT INTO tglulb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","At dinala ng mga lalaki ang regalong iyon. Kumuha sila ng dobleng salapi sa kanilang mga kamay at si Benjamin. Tumayo sila, pumunta pababa sa Ehipto, at tumayo sa harapan ni Jose. ");
INSERT INTO tglulb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Nang makita ni Jose na kasama nila si Benjamin, sinabi niya sa katiwala ng kanyang bahay, “Dalhin mo ang mga lalaki sa bahay, kumatay kayo ng hayop at ihanda ito, dahil ang mga lalaki ay kakain kasama ko ngayong tanghalian. ");
INSERT INTO tglulb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ginawa ng katiwala ang sinabi ni Jose. Dinala niya ang mga lalaki sa bahay ni Jose. ");
INSERT INTO tglulb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Natakot ang mga lalaki dahil sila ay dinala sa bahay ni Jose. Sinabi nila, “Ito ay dahil sa perang isinauli sa aming mga sako sa unang pagkakataon na pumunta kami dito, para makahanap siya ng pagkakataon laban sa amin. Maaari niya kaming hulihin at gawin lipin, at kunin ang aming mga asno. ");
INSERT INTO tglulb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Nilapitan nila ang katiwala ng bahay ni Jose, at siya ay kinausap nila sa may pintuan ng bahay, ");
INSERT INTO tglulb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","sinabing, “Aking amo, noong unang pagkakataon na pumunta kami dito ay para bumili ng pagkain. ");
INSERT INTO tglulb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Nangyari na, nang makarating na kami sa lugar kung saan kami ay pansamantalang nakatira, na binuksan namin ang aming mga sako, at, tingnan, ang bawat pera ng tao ay nandoon sa bukasan ng kanilang sako, ang aming pera na sakto ang halaga. Ibinalik namin ito sa aming mga kamay. ");
INSERT INTO tglulb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ang ibang pera ay dinala rin namin sa aming kamay para bumili ng pagkain. Hindi namin alam kung sino ang naglagay ng pera sa aming mga sako.” ");
INSERT INTO tglulb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Sinabi ng katiwala, “Ang kapayapaan ay sumainyo, huwag kayong matakot. Ang inyong Diyos at ang Diyos ng inyong ama ang maaaring naglagay ng pera sa inyong mga sako. Natanggap ang iyong pera.” Inilabas naman ng katiwala si Simeon sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Dinala ng katiwala ang mga lalaki sa bahay ni Jose. Binigyan niya ito ng tubig, at hinugasan nila ang kanilang mga paa. Binigyan niya ng mga pagkain ang kanilang mga asno. ");
INSERT INTO tglulb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Inihanda nila ang mga regalo sa pagdating ni Jose sa tanghali, sapagkat narinig nila na sila ay kakain doon. ");
INSERT INTO tglulb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Nang dumating si Jose sa bahay, dinala nila ang mga regalo na nasa kamay nila doon sa bahay, at sila'y yumuko sa harapan niya sa sahig. ");
INSERT INTO tglulb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Tinanong niya sila tungkol sa kanilang kalagayan at nagsabing, “Mabuti ba ang kalagayan ng inyong ama, ang matanda na inyong binabanggit? Buhay pa ba siya?” ");
INSERT INTO tglulb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Sila ay nagsalita, “Ang iyong lingkod ang aming ama ay mabuti naman. Siya ay buhay pa.” Sila ay dumapa at yumuko. ");
INSERT INTO tglulb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Itinuon niya ang kanyang mga mata pataas at nakita si Benjamin ang kanyang kapatid na lalaki, ang anak ng kanyang ina, na nagsasabing, “Ito ba ang sinasabi mong nakababatang kapatid mo na iyong binabanggit sa akin? Sinabi niya, “Ang Diyos ay maging maawain sa iyo, aking anak”. ");
INSERT INTO tglulb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Nagmamadali si Jose na lumabas sa loob, dahil labis siyang naantig tungkol sa kanyang kapatid na lalaki. Naghanap siya ng lugar upang iyakan. Pumunta siya sa kanyang silid at doon umiyak. ");
INSERT INTO tglulb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Naghilamos siya at lumabas. Pinigilan niya ang kanyang sarili, na nagsasabing “Ihain na ang pagkain”. ");
INSERT INTO tglulb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Pinagsilbihan ng mga lingkod si Jose na siya lang at ang kanyang mga kapatid na lalaki na sila lang. Ang mga taga-Ehipto ay kumain doon kasama niya ng sila-sila lang dahil ang taga-Ehipto ay hindi kumakain ng tinapay kasama ng mga Hebreo, dahil ito ay hindi katanggap-tanggap sa mga taga-Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ang mga kapatid niya ay umupo sa tapat niya, ang panganay ayon sa kanyang karapatan, at ang pinaka bata ayon sa kanyang pagkabata. Ang mga lalaki ay sama-samang namangha. ");
INSERT INTO tglulb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nagpadala si Jose ng mga parte sa kanila mula sa pagkain na nasa harapan niya. Pero ang parte ng kay Benjamin ay limang beses ang dami kaysa sa kanyang mga kapatid. Sila'y nag inuman at nagpakasaya na kasama niya. ");
INSERT INTO tglulb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Inatasan ni Jose ang katiwala ng kanyang bahay, sinabing, “Punuin mo ang sako ng mga lalaki ng pagkain, hangga't sa makakaya nilang buhatin, at ilagay ang bawat pera ng lalaki sa ibabaw ng kanyang sako. ");
INSERT INTO tglulb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ilagay ang aking baso, ang pilak na baso, sa ibabaw ng sako ng bunso, at ganoon din ang kanyang pera para sa butil.” Ginawa ng katiwala ang sinabi ni Jose. ");
INSERT INTO tglulb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nang nagbubukang-liwayway na, at ang mga lalaki ay pinaalis na, sila at ang kanilang mga asno. ");
INSERT INTO tglulb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Nang sila ay nakalabas sa lungsod subalit hindi pa nakakalayo, sinabi ni Jose sa kanyang katiwala, “Tumayo ka, sundan mo ang mga lalaki, at kung maabutan mo sila, sabihin mo sa kanila, 'Bakit ninyo sinuklian ng kasamaan ang kabutihan? ");
INSERT INTO tglulb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hindi ba ito ang baso mula sa iniinuman ng aking amo, at ang baso na ginagamit niya para sa kanyang panghuhula? Gumawa kayo ng masama, ang bagay na ito na inyong ginawa.”' ");
INSERT INTO tglulb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Naabutan sila ng katiwala at sinabi ang mga salitang ito sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Sinabi nila sa kanya, “Bakit po sinasabi ng aking amo ang ganitong mga salita? Malayong gawin ng inyong mga lingkod ang bagay na iyan. ");
INSERT INTO tglulb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tingnan ninyo, ang pera na nakita sa aming mga sako, ay muli naming dinala sa inyo sa labas ng lupain ng Canaan. Paano naman namin nanakawin mula sa tahanan ng inyong amo ang pilak o ginto? ");
INSERT INTO tglulb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kung sinuman sa inyong lingkod ang makitaan, hayaan mo siyang mamatay, at kami rin ay magiging mga alipin ng aming amo.” ");
INSERT INTO tglulb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Sinabi ng katiwala, “Ngayon rin hayaang magkaganoon ayon sa iyong mga salita. Siya na mahanapan ng baso ay magiging alipin ko, at ang iyong mga kapatid ay mapapawalangsala.” ");
INSERT INTO tglulb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","At nagmamadali ang bawat lalaki at dinala ang kanilang sako pababa sa lupa, at binuksan ng bawat lalaki ang kanilang mga sako. ");
INSERT INTO tglulb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Naghanap ang katiwala. Nagsimula siya sa pinaka-panganay at natapos sa bunso, at nahanap ang baso sa sako ni Benjamin. ");
INSERT INTO tglulb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Pagkatapos pinunit nila ang kanilang mga damit. Nilagay ng bawat lalaki ang kanilang asno at bumalik sa lungsod. ");
INSERT INTO tglulb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Si Juda at ang kanyang mga kapatid ay pumunta sa tahanan ni Jose. Siya ay nanatili pa roon, at sila'y yumuko sa lupa sa harapan nito. ");
INSERT INTO tglulb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Sinabi ni Jose sa kanila, “Ano itong ginagawa ninyo? Hindi ba ninyo alam na ang lalaking tulad ko ay bihasa sa panghuhula?” ");
INSERT INTO tglulb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Sinabi ni Juda, “Ano ang maari naming sabihin sa inyo aming amo? O kaya, paano namin maipagtatanggol ang aming sarili? Nalaman ng Diyos ang kasalanan ng iyong mga lingkod. Tingnan ninyo, kami ay alipin na ng aming amo, kami at siyang nahanapan ng baso.” ");
INSERT INTO tglulb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Sinabi ni Jose, “Malayong gawin ko iyan. Ang lalaking nahanapan ng baso sa kanyang kamay, ang lalaking iyon rin ang magiging alipin ko, subalit ang mga iba ay makakauwi na ng mapayapa sa inyong ama.” ");
INSERT INTO tglulb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Pagkatapos lumapit si Juda sa kanya at sinabing, “Aking amo pakiusap, pahintulutan po ninyo akong makapagsalita sa pandinig ng aking amo, at huwag hayaang umapoy sa galit laban sa iyong alipin, sapagkat katulad ka ni Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ang aking amo ay nagtanong sa kanyang mga lingkod, sinasabing, 'Mayroon pa ba kayong ama o kapatid? ");
INSERT INTO tglulb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","At sinabi namin sa aming amo, 'Mayroon kaming matandang ama, at anak niya sa kanyang katandaan, isang bunso. At patay na ang kanyang kuya, at siya ay nag-iisa na lamang na naiwan mula sa kanyang ina, at mahal na mahal siya ng kanyang ama.' ");
INSERT INTO tglulb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","At sinabi mo sa iyong mga lingkod, 'Dalhin ninyo siya rito sa akin para makita ko siya.' ");
INSERT INTO tglulb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","At sinabi namin sa aming amo, 'Hindi kayang iwan ng bata ang kanyang ama. Sapagkat kung iiwan niya ang kaniyang ama ikamamatay ito ng kanyang ama.' ");
INSERT INTO tglulb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","At sinabi mo sa iyong mga lingkod, 'Kung hindi ninyo kasama pababa ang bunso ninyong kapatid, hindi na ninyo muli makikita ang aking mukha.' ");
INSERT INTO tglulb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","At nangyari nga nang kami ay nakabalik sa aking ama na iyong mga lingkod, isinalaysay namin sa kanya ang mga salita ng aming amo. ");
INSERT INTO tglulb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","At sinabi ng aming ama, 'Umalis kayo muli, bumili kayo ng ilang makakain.' ");
INSERT INTO tglulb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","At sinabi namin, 'Hindi na kami makabababa. Kung kasama namin ang aming nakababatang kapatid, kami ay makakaalis pababa, sapagkat hindi na kami hahayaan na makita pa muli ang mukha ng lalaki kung hindi namin kasama ang bunso naming kapatid.' ");
INSERT INTO tglulb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Sinabi ng aking ama na iyong lingkod, 'Alam ninyong dalawa lamang ang ipinanganak ng aking asawa. ");
INSERT INTO tglulb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","At ang isa ay nawala mula sa akin at sinabi ko. “Talaga ngang siya ay nagkapira-piraso, at hindi ko na siya nakita mula noon.” ");
INSERT INTO tglulb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","At kung kukunin rin ninyo itong isa sa akin at muling mapahamak, dadalhin ninyo ako sa katandaan na puno ng dalamhati sa kamatayan.' ");
INSERT INTO tglulb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Kaya ngayon, kung pupunta ako sa aking ama na inyong alipin, at hindi ko kasama ang bata, sapagkat ang kanyang buhay ay karugtong na ng buhay ng batang lalaki, ");
INSERT INTO tglulb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","kapag ito ay nangyari, na hindi niya makita na kasama namin ang bata siguradong ikamamatay niya ito. At ang iyong alipin ay magiging dahilan ng pagdurusa ng ama ng iyong alipin sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Sapagkat ang iyong alipin ang katiyakan sa bata para sa aking ama at sinabi kong, 'Kung hindi ko madadala ang bata sa iyo, papasanin ko ang kasalanan magpakailanman sa aking ama. ");
INSERT INTO tglulb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kaya ngayon, ako po ay nagmamakaawa hayaang manatili ang iyong lingkod sa halip na ang bata ang maging alipin ng aking amo, at hayaang makabalik ang bata kasama ng kanyang mga kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Sapagkat paano ako makakabalik sa aking ama kung hindi ko kasama ang bata? Natatakot akong makita ang masamang mangyayari sa aking ama.” ");
INSERT INTO tglulb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Pagkatapos hindi nakapagpigil si Jose sa kanyang sarili sa harapan ng lahat ng mga lingkod na nakatayo sa kanyang tabi. Sinabi niya ng malakas, “Iwanan ninyo akong lahat.” Kaya walang lingkod na nakatayo sa tabi niya nang siya ay nagpakilala sa kanyang mga kapatid na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Umiyak siya ng malakas, narinig ito ng mga taga-Ehipto at ang tahanan ng Paraon ay nakarinig ito. ");
INSERT INTO tglulb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Sinabi ni Jose sa kanyang mga kapatid na lalaki, “Ako si Jose. Buhay pa ba ang aking ama?” Ang kanyang mga kapatid na lalaki ay hindi makasagot sa kanya, sapagkat sila ay nabigla sa kanyang presensiya. ");
INSERT INTO tglulb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Pagkatapos sinabi ni Jose sa kanyang mga kapatid na lalaki, “Pakiusap, lumapit kayo sa akin.” Lumapit sila. Sinabi niya, “Ako si Jose ang inyong kapatid na lalaki, na inyong ipinagbili sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","At ngayon huwag kayong magdalamhati o magalit sa inyong mga sarili na ipinagbili ninyo ako dito, sapagkat nauna na akong ipinadala ng Diyos sa inyo upang pangalagaan ang buhay ninyo. ");
INSERT INTO tglulb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nasa tagtuyot ang lupain nitong mga dalawang taon at magkakaroon pa nang limang dagdag na mga taon na walang pag-aararo o walang ani. ");
INSERT INTO tglulb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nauna na akong ipinadala ng Diyos sa inyo upang pangalagaan kayo bilang mga nalalabi dito sa mundo at nang mapanatili kayong buhay sa pamamagitan ng dakilang kaligtasan. ");
INSERT INTO tglulb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kaya ngayon, hindi kayo ang nagpadala sa akin dito kung hindi ang Diyos, at ginawa niya akong ama ng Paraon, amo ng lahat ng kanyang tahanan, at pinuno ng lahat ng lupain sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Magmadali kayo at umakyat patungo sa aking ama at sabihin sa kanya 'Ito ang sinabi ng inyong anak na si Jose, ginawa ako ng Diyos na amo ng buong Ehipto. Bumaba ka dito sa akin at huwag mag-atubili. ");
INSERT INTO tglulb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Maninirahan ka sa lupain ng Gosen at nang ikaw ay mapalapit sa akin, ikaw at ang iyong mga anak at ang mga anak ng iyong mga anak, at ang iyong mga hayop at ang iyong mga baka, at ang lahat ng nasa iyo. ");
INSERT INTO tglulb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Tutustusan kita doon sapagkat mayroon pang limang mga taon na tagtuyot upang hindi ka humantong sa kahirapan, ikaw, ang iyong tahanan, at ang lahat ng nasa iyo.' ");
INSERT INTO tglulb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Tingnan ninyo, nakikita ng inyong mga mata, at mga mata ng aking kapatid na lalaki na si Benjamin, na itong aking bibig ang nakikipag-usap sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Sasabihin ninyo sa aking ama ang tungkol sa lahat ng aking kapangyarihan sa Ehipto, at ang lahat ng inyong mga nakita. Magmamadali kayo at dalhin ang aking ama dito.” ");
INSERT INTO tglulb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Niyakap niya ang kanyang kapatid na si Benjamin sa leeg at umiyak, at si Benjamin ay umiyak sa kanyang leeg. ");
INSERT INTO tglulb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Hinagkan niya ang lahat ng kanyang mga lalaking kapatid at umiyak sa kanila. Pagkatapos noon nakipag-usap sa kanya ang kanyang mga kapatid na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ang balita tungkol dito ay sinabi sa bahay ng Paraon: “Dumating ang mga lalaking kapatid ni Jose.” Ito ay labis na ikinalugod ng Paraon at ng kanyang mga lingkod. ");
INSERT INTO tglulb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Sinabi ng Paraon kay Jose, “Sabihin mo sa iyong mga lalaking kapatid, 'Gawin ito: lagyan ninyo ang inyong mga hayop at pumunta sa lupain ng Canaan. ");
INSERT INTO tglulb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Kunin ninyo ang inyong ama at ang inyong mga sambahayan at pumunta sa akin. Ibibigay ko sa inyo ang kasaganahan ng lupain ng Ehipto, at kakainin ninyo ang taba ng lupain.' ");
INSERT INTO tglulb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kayo ngayon ay inuutusan ko kayo 'Gawin ninyo ito, kumuha kayo ng mga karitela mula sa lupain ng Ehipto para sa inyong mga anak at mga asawa. Kunin ninyo ang inyong ama at pumarito. ");
INSERT INTO tglulb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Huwag na kayong mag-alala tungkol sa inyong mga ari-arian, sapagkat sa inyo na ang kasaganahan ng lahat ng lupain sa Ehipto.'” ");
INSERT INTO tglulb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ginawa ito ng mga anak ni Israel. Binigayan sila ni Jose ng mga karitela, ayon sa utos ng Paraon at binigyan sila ng mga panustos para sa paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Sa kanilang lahat nagbigay siya sa bawat tao ng mga pampalit na damit, ngunit kay Benjamin nagbigay siya ng tatlong daang mga piraso ng pilak at limang mga pampalit na damit. ");
INSERT INTO tglulb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ito ang kanyang ipinadala para sa kanyang ama: Sampung mga asno na may kargang magandang mga kagamitan ng Ehipto, at sampung babaeng mga asno na may karga na mga butil, tinapay, at iba pang mga gamit para sa kanilang ama para sa paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kaya pinadala niya ng papalayo ang kanyang mga lalaking kapatid at sila ay umalis. Sinabi niya sa kanila, “Tiyakin ninyo na huwag kayong mag-aaway sa paglalakbay”. ");
INSERT INTO tglulb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Umalis sila mula sa Ehipto at dumating sa lupain ng Canaan, kay Jacob na kanilang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Sinabi nila sa kaniya, “Buhay pa si Jose at siya ang namumuno sa buong lupain ng Ehipto”. At ang kanyang puso ay namangha, sapagkat hindi niya sila pinaniniwalaan. ");
INSERT INTO tglulb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Sinabi nila sa kanya ang lahat ng mga salita ni Jose na kanyang sinabi sa kanila. Muling nabuhay ang espiritu ni Jacob na kanilang ama nang makita ni Jacob ang mga karitela na ipinadala ni Jose na magdadala sa kanya,. ");
INSERT INTO tglulb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Sinabi ni Israel, “Sapat na ito. Buhay pa ang aking anak na si Jose. Pupunta ako at makikipagkita sa kanya bago ako mamatay.” ");
INSERT INTO tglulb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Naglakbay si Israel dala lahat ng mayroon siya at nagtungo sa Beer-seba. Nag-alay siya roon ng mga handog sa Diyos ng kanyang amang si Isaac. ");
INSERT INTO tglulb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nangusap ang Diyos kay Israel sa pamamagitan ng pangitain sa gabi, na sinasabing, “Jacob, Jacob.” Sinabi niya, “Narito ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Sinabi niya, “Ako ang Diyos, ang Diyos ng iyong ama. Huwag kang matakot na bumaba patungong Ehipto, dahil doon kita gagawing isang dakilang bansa. ");
INSERT INTO tglulb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Bababa ako kasama mo sa Ehipto at tunay na ibabalik kitang muli. Isasara ni Jose ang iyong mga mata sa pamamagitan ng kanyang sariling kamay.” ");
INSERT INTO tglulb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Bumangon si Jacob mula sa Beer-seba. Isinakay ng mga anak na lalaki ni Israel si Jacob na kanilang ama, ang kanilang mga anak, at ang kanilang mga asawa sa mga kariton na ipinadala ng Paraon para magdala sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Dinala nila ang kanilang mga alagang hayop at mga ari-arian na naipon nila sa lupain ng Canaan. Pumunta si Jacob sa Ehipto at ang lahat ng kanyang mga kaapu-apuhan kasama niya. ");
INSERT INTO tglulb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Dinala niya kasama sa Ehipto ang kanyang mga anak na lalaki, at kanyang mga apong lalaki, kanyang mga anak na babae at kanyang mga apong babae, at lahat ng kanyang mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ito ang mga pangalan ng mga anak ni Israel na dumating sa Ehipto, si Jacob at ang kanyang mga anak na lalaki: si Ruben, panganay na anak ni Jacob; ");
INSERT INTO tglulb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","mga anak na lalaki ni Ruben na sina Enoc, Fallu, Hezron at Carmi; ");
INSERT INTO tglulb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","mga anak ni Simeon sina Jemuel, Jamin, Ohad, Jaquin, Zohar at Saul, na mga anak na lalaki ng babaeng taga-Canaan; ");
INSERT INTO tglulb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","mga anak na lalaki ni Levi na sina Gershon, Coat at Merari; ");
INSERT INTO tglulb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","mga anak na lalaki ni Juda: sina Er, Onan, Sela, Fares at Zara, (pero namatay si Er at Onan sa lupain ng Canaan. At ang mga anak na lalaki ni Fares, sina Hezron at Hamul); ");
INSERT INTO tglulb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ang mga anak na lalaki ni Isacar: sina Tola, Pua, Job, at Simron; ");
INSERT INTO tglulb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ang mga anak na lalaki ni Zabulun: sina Sered, Elon, at Jahleel ");
INSERT INTO tglulb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(ito ang mga anak na lalaki ni Lea na ipinanganak kay Jacob sa Paddan Aram, kabilang ang anak niyang babae na si Dina. Ang bilang ng lahat ng kanyang mga anak na lalaki at mga anak na babae ay tatlumpu't tatlo); ");
INSERT INTO tglulb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ang mga anak na lalaki ni Gad, sina Zifion, Hagui at Suni, Ezbon, Eri, Arodi, at Areli; ");
INSERT INTO tglulb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ang mga anak na lalaki ni Aser, sina Jimna at Isua, Isui at Beria, at si Sera na kanilang kapatid na babae; ang mga anak na lalaki ni Beria, sina Heber at Malquiel ");
INSERT INTO tglulb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(ito ang mga anak na lalaki ni Zilpa, na ibinigay ni Laban sa kanyang anak na babae na si Lea. Ito ang mga ipinanganak niya kay Jacob— labing-anim lahat); ");
INSERT INTO tglulb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ang mga anak na lalaki ni Jacob kay Raquel na kanyang asawa—sina Jose and Benjamin. ");
INSERT INTO tglulb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","(sa Ehipto ipinanganak sina Manases at Efraim kay Jose at Asenath, anak na babae ni Potifera na pari ng On); ");
INSERT INTO tglulb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ang mga anak na lalaki ni Benjamin, sina Bela, Bequer, Ashbel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, at Ard ");
INSERT INTO tglulb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(ito ang mga anak na lalaki ni Raquel na ipinanganak kay Jacob. Ang mga taong ito ay labing-apat lahat); ");
INSERT INTO tglulb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ang anak na lalaki ni Dan, si Husim; ");
INSERT INTO tglulb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ang mga anak na lalaki ni Neftali, sina Jahzeel, Guni, Jeser, and Silem ");
INSERT INTO tglulb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(ito ang mga anak na lalaki ni Jacob kay Bilha na ibinigay ni Laban kay Raquel na kanyang anak na babae. Ang mga taong ito ay pito lahat. ");
INSERT INTO tglulb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Lahat ng mga taong dumating kasama ni Jacob sa Ehipto na kanyang mga kapu-apuhan, bukod sa kanyang mga manugang na babae ay animnapu't anim lahat. ");
INSERT INTO tglulb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ang dalawang lalaking anak ni Jose na ipinanganak sa kanya sa Ehipto ay dalawa. Lahat ng tao sa bahay ni Jacob na pumunta sa Ehipto ay pitumpo lahat. ");
INSERT INTO tglulb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Naunang ipinadala ni Jacob si Juda papunta kay Jose upang ituro sa kanya ang daan patungong Gosen at sila ay pumunta sa lupain ng Gosen. ");
INSERT INTO tglulb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Inihanda ni Jose ang kanyang karwahe at umakyat para salubungin si Israel na kanyang ama sa Gosen. Siya ay nakita niya, niyapos ang kanyang leeg at humagulgol sa kanyang leeg ng matagal. ");
INSERT INTO tglulb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Sinabi ni Israel kay Jose, “Ngayon hayaan mo na akong mamatay, yamang nakita ko na ang iyong mukha, na ikaw ay buhay pa.” ");
INSERT INTO tglulb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Sinabi ni Jose sa kanyang mga kapatid na lalaki at sa bahay ng kanyang ama, “Aakyat ako at sasabihin kay Paraon na, 'Ang aking mga lalaking kapatid at ang tahanan ng aking ama na nasa lupain ng Canaan ay pumunta sa akin. ");
INSERT INTO tglulb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ang mga lalaki ay mga pastol dahil sila ay tagapag-alaga ng kanilang mga alagang hayop. Dinala nila ang kanilang mga kawan, mga baka at lahat ng mayroon sila.' ");
INSERT INTO tglulb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Darating ang oras, kapag tinawag at tinanong kayo ng Paraon, 'Ano ang inyong hanap-buhay?' ");
INSERT INTO tglulb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","sabihin ninyo dapat na, 'Ang inyong mga lingkod ay tagapag-alaga ng mga hayop mula sa aming kabataan hanggang ngayon, kami at ang aming mga ninuno.' Gawin ninyo ito para kayo ay maaring manirahan sa lupain ng Gosen, dahil ang bawat pastol ay kasuklam-suklam sa mga taga-Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Pagkatapos pumasok si Jose at sinabi sa Paraon, “Ang aking ama at ang aking mga kapatid na lalaki, ang kanilang mga hayop, ang kanilang mga alagang kawan, at ang lahat ng kanilang pagmamay-ari, ay dumating na galing sa lupain ng Canaan. Tingnan mo, sila ay nasa lupain na ng Gosen. ");
INSERT INTO tglulb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Sinama niya ang lima sa kanyang mga kapatid na lalaki at ipinakilala sila sa Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Sinabi ng Paraon sa kanyang mga kapatid na lalaki, “Ano ang hanapbuhay ninyo?” Sinabi nila sa Paraon, “Ang iyong mga lingkod ay mga pastol, katulad ng aming mga ninuno. ");
INSERT INTO tglulb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Pagkatapos sinabi nila kay Paraon, “Pumunta kami bilang pansamantalang mamamayan sa lupain. Wala ng pastulan para sa mga hayop ng inyong mga lingkod, dahil malubha na ang taggutom sa lupain ng Canaan. Kaya ngayon, pakiusap hayaan niyo ang iyong mga lingkod na manirahan sa lupain ng Gosen.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pagkatapos nagsalita ang Paraon kay Jose, at sinabing, “Ang iyong ama at ang iyong mga kapatid na lalaki ay pumunta sa iyo, ");
INSERT INTO tglulb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ang lupain ng Ehipto ay nasa harapan mo. Patirahin mo ang iyong ama at ang iyong mga kapatid na lalaki sa pinakamainam na rehiyon, sa lupain ng Gosen. Kung may kakilala kang mga lalaki mula sa kanila na may kakayahan, ilagay mo sila bilang tagapamahala sa aking mga alagang hayop.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Pagkatapos dinala ni Jose ang kanyang ama na si Jacob at ipinakilala siya sa Paraon. Pinagpala ni Jacob si Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Sinabi ng Paraon kay Jacob, “Gaano ka na katagal nabubuhay?” ");
INSERT INTO tglulb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Sinabi ni Jacob kay Paraon, “Ang mga taon ng aking mga paglalakbay ay isandaan at tatlumpu. Ang mga taon ng aking buhay ay maikli at masakit. Hindi ito kasintagal ng aking mga ninuno.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Pagkatapos pinagpala ni Jacob ang Paraon at umalis mula sa kanyang harapan. ");
INSERT INTO tglulb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Pagkatapos pinatira ni Jose ang kanyang ama at ang kanyang mga kapatid na lalaki. Binigyan niya sila ng lupain sa Ehipto, ang pinakamainam na lupain, sa lupain ng Rameses, ayon sa utos ng Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Binigyan ni Jose ng pagkain ang kanyang ama, mga kapatid, at lahat ng sambahayan ng kanyang ama, ayon sa bilang ng kanilang kasama sa bahay. ");
INSERT INTO tglulb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ngayon wala ng pagkain sa lahat ng lupain; dahil malubha na ang taggutom. Ang lupain ng Ehipto at ang lupain ng Canaan ay nakatiwangwang dahil sa taggutom. ");
INSERT INTO tglulb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Naipon ni Jose ang lahat ng salaping nasa lupain ng Ehipto at sa lupain ng Canaan, sa pamamagitan ng pagbebenta ng butil sa mga mamamayan. Pagkatapos dinala ni Jose ang salapi sa palasyo ng Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Nang naubos na ang lahat ng salapi sa mga lupain ng Ehipto at Canaan, lahat ng mga taga-Ehipto ay pumunta kay Jose at sinabing, “Bigyan mo kami ng pagkain! Bakit kami mamamatay sa iyong harapan dahil ubos na ang aming salapi? ");
INSERT INTO tglulb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Sinabi ni Jose, “Kung wala na kayong salapi, dalhin ninyo ang inyong mga hayop at bibigyan ko kayo ng pagkain bilang kapalit ng inyong mga alagang hayop.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kaya dinala nila ang kanilang mga alagang hayop kay Jose. Binigyan sila ni Jose ng pagkain bilang kapalit ng kanilang mga kabayo, mga hayop, mga kawan, at mga asno. Pinakain niya sila ng tinapay kapalit ng kanilang mga hayop sa taon na iyon. ");
INSERT INTO tglulb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Nang natapos ang taong iyon, pumunta sila sa kanya nang sumunod na taon at sinabi sa kanya, “Hindi kami magtatago sa aming amo na ubos na ang lahat ng aming salapi, at ang mga baka pag-aari na ng aming amo. Wala ng natira pa sa paningin ng aming amo, maliban sa aming katawan at ang aming lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Bakit kami mamamatay sa harap ng iyong mga mata, kami at ang aming lupain? Bilhin mo kami at ang aming lupain kapalit ng pagkain, at kami at ang aming lupain ay magiging mga lingkod ni Paraon. Bigyan mo kami ng binhi para mabuhay kami at hindi mamatay, at ang aming lupain ay hindi mapababayan. ");
INSERT INTO tglulb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kaya nabili ni Jose ang buong lupain ng Ehipto para sa Paraon. Ibinenta ng bawat mamamayan ng Ehipto ang kanilang mga bukid, dahil napakalubha na ng taggutom. Sa paraang ito, ang lupain ay naging pag-aari na ng Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Tungkol naman sa mga tao, ginawa niya silang alipin mula sa dulong hangganan ng Ehipto hanggang sa kabilang dulo. ");
INSERT INTO tglulb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ang lupain lamang ng mga pari ang hindi nabili ni Jose dahil ang mga pari ay binibigyan ng rasyon. Kumakain sila mula sa rasyon na ibinibigay ng Paraon sa kanila. Kaya hindi nila ipinagbili ang kanilang lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Pagkatapos sinabi ni Jose sa mga tao, “Masdan ninyo, binili ko kayo at ang inyong lupain sa araw na ito para sa Paraon. Ngayon narito ang mga binhi para sa inyo, at tatamnan niyo ang lupain. ");
INSERT INTO tglulb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sa anihan, magbigay kayo ng ikalimang bahagi sa Paraon, at ang apat na bahagi ay para sa inyong sarili, para sa binhi ng lupain at para pagkain ng inyong sambahayan at inyong mga anak.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Sinabi nila, “Iniligtas mo ang buhay namin. Sana ay maging kalugod-lugod kami sa iyong mga mata. Kami ay magiging mga alipin ng Paraon.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kaya ginawa itong kautusan ni Jose na umiiral pa rin sa lupain ng Ehipto hanggang sa araw na ito, na ang ikalimang bahagi ay magiging pag-aari ng Paraon. Ang lupain lang ng mga pari ang hindi napunta sa Paraon. ");
INSERT INTO tglulb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Kaya si Israel ay nanirahan sa lupain ng Ehipto, sa lupain ng Goshen. Ang kanyang mga tao roon ay nakakuha ng mga ari-arian. Sila ay mabunga at dumami ng lubos. ");
INSERT INTO tglulb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Si Jacob ay tumira sa Ehipto ng labimpitong taon, kaya ang mga taon ng buhay ni Jacob ay isandaan at apatnapu't pitong taon. ");
INSERT INTO tglulb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Nang malapit na ang oras ng kamatayan ni Israel, tinawag niya ang kanyang anak na si Jose at sinabihan siyang, “Kung ngayon ako ay kalugod-lugod sa iyong paningin, ilagay mo ang iyong kamay sa ilalim ng aking hita, at pakitaan mo ako ng katapatan at pagiging mapagkakatiwalaan. Pakiusap huwag mo akong ilibing sa Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Pagtulog ko kasama ng aking mga ama, ilabas mo ako sa Ehipto at ilibing sa libingan ng aking mga ninuno.” Sinabi ni Jose, “Gagawin ko ang sinabi mo.” ");
INSERT INTO tglulb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Sinabi ni Israel, “Mangako ka sa akin,” at si Jose ay nangako sa kanya. Pagkatapos yumuko si Israel sa ulunan ng kanyang higaan. ");
INSERT INTO tglulb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","At nangyari na pagkatapos ng mga bagay na ito, may nagsabi kay Jose, “Tingnan mo, maysakit ang iyong ama.” Kaya kinuha niya ang kanyang dalawang anak na lalaki, sina Manasses at Efraim. ");
INSERT INTO tglulb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Nang sinabihan si Jacob, “Tingnan mo, ang iyong anak na si Jose ay dumating para makita ka,” Nag-ipon ng lakas si Israel at umupo sa kanyang higaan. ");
INSERT INTO tglulb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Sinabi ni Jacob kay Jose, “Nagpakita sa aking ang makapangyarihang Diyos sa Luz sa lupain ng Canaan. Binasbasan niya ako ");
INSERT INTO tglulb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","at sinabi sa akin, 'Tingnan mo, palalaguin kita, at pararamihin kita. Gagawin kitang kapulungan sa mga bansa. Ibibigay ko ang lupaing ito sa iyong mga kaapu-apuhan bilang isang walang hanggang pag-aari.' ");
INSERT INTO tglulb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","At ngayon ang dalawa mong anak na lalaki na ipinanganak sa iyo mula sa lupain ng Ehipto bago ako dumating dito, sila ay akin. Sina Efraim at Manasses ay magiging akin, tulad nina Ruben at Simeon na akin. ");
INSERT INTO tglulb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ang susunod na mga anak mo pagkatapos nila ay magiging iyo; sila ay nakalista sa ilalim ng mga pangalan ng kanilang mga kapatid sa kanilang mana. ");
INSERT INTO tglulb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Pero para sa akin, nang dumating ako mula sa Paddan, sa aking kalungkutan namatay si Raquel sa lupain ng Canaan sa daan nang ako ay pabalik, habang may kaunting kalayuan pa papunta sa Efrata. Inilibing ko siya roon sa daanan patungo sa Efrata (ito ay Bethlehem).” ");
INSERT INTO tglulb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Nang nakita ni Israel ang mga anak na lalaki ni Jose, sinabi niya. “Kanino ang mga ito?” ");
INSERT INTO tglulb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Sinabi ni Jose sa kanyang ama, “Sila ang mga anak kong lalaki, na ibinigay sa akin ng Diyos dito.” Sinabi ni Israel, “Dalhin mo sila sa akin para mabasbasan ko sila.” ");
INSERT INTO tglulb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ngayon ang mga mata ni Israel ay malabo na dahil sa kanyang katandaan, kaya hindi na siya nakakakita. Kaya dinala sila ni Jose malapit sa kanya, at hinagkan sila at niyakap. ");
INSERT INTO tglulb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Sinabi ni Israel kay Jose, “Hindi ko kailanman inasahang makikitang muli ang iyong mukha, pero ipinahintulot pa ng Diyos na makita ko ang iyong mga anak.” ");
INSERT INTO tglulb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kinuha sila ni Jose mula sa pagitan ng mga tuhod ni Jacob, at saka yumuko na nakasayad ang mukha sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Kapwa sila kinuha ni Jose, si Efraim sa kanyang kanang kamay sa may bandang kaliwang kamay ni Israel, at si Manasses sa kanyang kaliwang kamay sa may bandang kanang kamay ni Israel, at dinala sila malapit sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Inabot ni Israel ang kanyang kanang kamay at inilagay sa ulo ni Efraim, na siyang mas bata, at ang kanyang kaliwang kamay sa ulo ni Manasses. Pinagsalungat niya ang kanyang mga kamay, dahil si Manasses ang panganay. ");
INSERT INTO tglulb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Binasbasan ni Israel si Jose, na nagsasabing, “And Diyos na kasama ng aking amang si Abraham at si Isaac, ang Diyos na nag-alaga sa akin sa araw na ito, ");
INSERT INTO tglulb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ang anghel na nagbantay sa akin mula sa lahat ng kapahamakan, nawa ay pagpalain niya ang mga kabataang ito. Nawa ang pangalan ko ay ipangalan sa kanila, at ang pangalan ng aking amang sina Abraham at Isaac. Nawa lumago sila at maging napakarami sa mundo.” ");
INSERT INTO tglulb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Nang nakita ni Jose ang kanyang ama na nilagay ang kanyang kanang kamay sa ulo ni Efraim, ikinasama niya ng loob ito. Kinuha niya ang kamay ng kanyang ama upang ilipat mula sa ulo ni Efraim sa ulo ni Manasses. ");
INSERT INTO tglulb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Sinabi ni Jose sa kanyang ama, “Hindi aking ama; ito po ang panganay. Ilagay mo ang iyong kanang kamay sa kanyang ulo.” ");
INSERT INTO tglulb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tumanggi ang kanyang ama at nagsabi, “Alam ko, anak, alam ko, siya ay magiging isang lahi, at siya rin ay magiging dakilang mga lahi. Pero ang kanyang nakababatang kapatid ay magiging mas dakila pa kaysa sa kanya, at ang kanyang mga kaapu-apuhan ay magiging maraming mga bansa.” ");
INSERT INTO tglulb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Binasbasan sila ni Israel sa araw na iyon sa mga salitang ito, “Ang mga mamamayan sa Israel ay magpapahayag ng pagpapala sa pamamagitan ng inyong mga pangalan na nagsasabing, 'Nawa gawin ng Diyos na maging tulad ni Efraim at Manasses'.” Sa ganitong paraan, inuna ni Israel si Efraim bago si Manasses. ");
INSERT INTO tglulb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Sinabi ni Israel kay Jose, “Tingnan mo, malapit na akong mamatay, pero kasama ninyo ang Diyos, at dadalhin kayo pabalik sa lupain ng inyong mga ama. ");
INSERT INTO tglulb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sa iyo, bilang isang nakahihigit sa iyong mga kapatid, ibibigay ko ang bundok na libis na nakuha ko mula sa Amoreo sa pamamagitan ng aking tabak at aking pana.” ");
INSERT INTO tglulb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Pagkatapos tinawag ni Jacob ang kanyang mga anak na lalaki, at sinabi: “Magsama-sama kayo, para sabihin ko kung ano ang mangyayari sa inyo sa hinaharap. ");
INSERT INTO tglulb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Magpulong kayo at makinig, kayong mga anak na lalaki ni Jacob. Makinig kayo kay Israel, ang inyong ama. ");
INSERT INTO tglulb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, ikaw ang aking panganay, aking lakas, at ang simula ng aking kalakasan, katangi-tangi ang dangal at katangi-tangi ang kapangyarihan. ");
INSERT INTO tglulb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Katulad ng hindi mapipigilan na matuling agos ng tubig, hindi ka magkakaroon ng katanyagan, dahil sumampa ka sa kama ng iyong ama. Dinungisan mo ito; sumampa ka sa aking higaan. ");
INSERT INTO tglulb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Sina Simeon at Levi ay magkapatid. Mga armas na marahas ang kanilang mga tabak. ");
INSERT INTO tglulb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O aking kaluluwa, huwag kayong pumunta sa kanilang konseho, huwag kayong makiisa sa kanilang pagpupulong, dahil labis ang karangalan ng aking puso para dito. Papatay sila ng mga tao dahil sa kanilang galit. Pipilayan nila ang baka para sa kanilang kasiyahan. ");
INSERT INTO tglulb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nawa sumpain ang kanilang galit, dahil ito ay mabagsik—at ang kanilang matinding galit, dahil ito ay malupit. Hahatiin ko sila kay Jacob at ikakalat ko sila sa Israel. ");
INSERT INTO tglulb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, pupurihin ka ng iyong mga kapatid na lalaki. Ang iyong kamay ay nasa leeg ng iyong mga kaaway. Yuyuko sa iyo ang mga anak na lalaki ng iyong ama. ");
INSERT INTO tglulb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Si Juda ay isang batang leon. Anak ko, tapos ka na sa iyong mga biktima. Yumuko siya, yumukod siya katulad ng leon, katulad ng leona. Sino ang hahamon na gisingin siya? ");
INSERT INTO tglulb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Hindi mawawala ang setro sa Juda, kahit ang tungkod ng pinuno mula sa pagitan ng kanyang mga paa, hanggang dumating ang Silo. Susunod ang mga bansa sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Pagkatali ng kanyang batang kabayo sa puno ng ubas at ng batang asno sa piling puno ng ubas, nilabhan niya ang kanyang mga kasuotan ng alak at ang kanyang balabal sa dugo ng mga ubas. ");
INSERT INTO tglulb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ang mata niya ay magiging kasing itim ng alak, at ang kanyang ngipin ay kasing puti ng gatas. ");
INSERT INTO tglulb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Titira si Zebulon sa tabing-dagat. Magiging daungan siya ng mga barko at aabot ang kanyang hangganan sa Sidon. ");
INSERT INTO tglulb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Malakas na asno si Isacar na nakahiga sa gitna ng tupahan. ");
INSERT INTO tglulb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nakakakita siya ng mabuting lugar na pagpahingahan at kaaya-ayang lupain. Iyuyukod niya ang kanyang balikat para pumasan at naging isang alipin para sa tungkulin. ");
INSERT INTO tglulb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Hahatulan ni Dan ang kanyang mga tao bilang isa sa mga lipi ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Magiging tulad ng ahas si Dan sa gilid ng daan, isang nakalalasong ahas sa daan na nanunuklaw ng mga sakong ng kabayo, upang mahulog ng patalikod ang kanyang sakay. ");
INSERT INTO tglulb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Maghihintay ako sa iyong pagliligtas, Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Si Gad—lulusubin siya ng mga mananalakay, pero sasalakay siya sa kanilang mga sakong. ");
INSERT INTO tglulb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Magiging masagana ang pagkain ni Aser, at magbibigay siya ng mga pagkain sa maharlika. ");
INSERT INTO tglulb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Si Nephtali ay isang malayang babaeng usa; magkakaroon siya ng magandang mumunting mga usa. ");
INSERT INTO tglulb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Si Jose ay magiging mabungang sanga, isang mabungang sanga malapit sa batis at aakyat sa pader ang mga sanga. ");
INSERT INTO tglulb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Lulusubin siya, papanain at guguluhin ng mga namamana. ");
INSERT INTO tglulb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pero mananatili ang kanyang pana, at magiging dalubhasa ang kanilang mga kamay dahil sa mga kamay ng Makapangyarihan kay Jacob, dahil sa pangalan ng Pastol, at ang Bato ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Dahil ang Diyos ng iyong ama, na siyang tutulong sa iyo, at dahil sa makapangyarihang Diyos na siyang magbabasbas sa iyo ng pagpapala sa kalangitan, mga pagpapala sa kailaliman na nasa ibaba, mga pagpapala sa mga dibdib at sinapupunan. ");
INSERT INTO tglulb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mas malaki pa ang mga pagpapala ng iyong ama kaysa sa mga sinaunang bundok o kanais-nais na mga bagay ng walang hanggang mga burol. Sila ay nasa ulo ni Jose, pagpapala na kokorona sa ulo ng isang prinsipe na nakakataas sa kanyang mga kapatid. ");
INSERT INTO tglulb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Gutom na lobo si Benjamin. Lalamunin niya ang kanyang nahuli sa umaga, at hahatiin niya ang mga nakaw sa gabi.” ");
INSERT INTO tglulb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ito ang mga labindalawang lipi ng Israel. Ito ang sinabi ng kanilang ama nang sila ay pinagpala niya. Bawat isa ay pinagpala niya ng nararapat na pagpapala. ");
INSERT INTO tglulb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Tinuruan niya sila at sinabihang, “Ako nga ay pupunta na sa aking mga tao. Ilibing ninyo ako kasama ng aking mga ninuno sa kuweba na nasa bukid ni Efron ang Heteo, ");
INSERT INTO tglulb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","sa kuweba na nasa bukid ng Macpela, na malapit sa Mamre sa lupain ng Canaan, ang bukid na binili ni Abraham kay sa Efron ang Heteo para maging libingan. ");
INSERT INTO tglulb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Doon inilibing si Abraham at Sara na kanyang asawa; inilibing nila roon si Isaac at Rebeca na kanyang asawa; at inilibing ko roon si Lea. ");
INSERT INTO tglulb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Binili ang bukid at ang kuweba rito mula sa mga Heth.” ");
INSERT INTO tglulb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nang matapos ni Jacob ang kanyang mga tagubilin sa kanyang mga anak na lalaki, iniunat niya ang kanyang mga paa sa kama at inihinga ang huling hininga, at pumunta sa kanyang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Pagkatapos niyakap ni Jose ang mukha ng kaniyang ama, nagdalamhati siya at hinalikan niya siya. ");
INSERT INTO tglulb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Inutusan ni Jose ang kanyang mga lingkod na manggagamot na embalsamuhin ang kanyang ama. Kaya inembalsamo ng mga manggagamot si Israel. ");
INSERT INTO tglulb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ginawa nila ito ng apatnapung araw, dahil iyon ang ganap na panahon ng pag-eembalsamo. Umiyak ang mga taga-Ehipto ng pitumpung araw. ");
INSERT INTO tglulb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Nang matapos ang mga araw ng pag-iyak, nakipag-usap si Jose sa hukuman ng Paraon at sinabing, “Kung ngayon may nahanap akong pabor sa iyong mga mata, pakiusap, kausapin mo si Paraon, sabihing, ");
INSERT INTO tglulb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'Pinanumpa ako sa aking ama, sinabing, “Tingnan mo, malapit na akong mamatay, Ilibing mo ako sa aking libingan na hinukay ko doon sa lupain ng Canaan. Doon mo ako ilibing.” Ngayon hayaan ninyo akong umakyat at ilibing ang aking ama, at pagkatapos ay babalik din ako.” ");
INSERT INTO tglulb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Sumagot ang Paraon, “Lumakad ka at ilibing ang iyong ama, tulad ng ipinanumpa niya sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Umakyat si Jose para ilibing ang kanyang ama. Kasama niyang umakyat ang lahat ng mga opisyal ng Paraon, ang mga tagapayo sa kanyang sambahayan, at ang lahat ng mga nakakatandang opisyal sa lupain ng Ehipto, ");
INSERT INTO tglulb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","kasama lahat ng sambahayan ni Jose at kanyang mga kapatid, at sambahayan ng kanyang ama. Pero iniwan nila ang mga bata, kanilang mga kawan, at ang kanilang mga kalipunan, sa lupain ng Gosen. ");
INSERT INTO tglulb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Pumunta kasama niya ang mga karwahe at mga mangangabayo. Ito ay isang napakalaking pulutong ng tao. ");
INSERT INTO tglulb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Nang sila ay dumating sa giikan ni Atad na nasa kabilang dako ng Jordan, sila ay nagluksa ng napakatindi at napakalungkot na pagdadalamhati. Doon si Jose ay nagluksa ng pitong araw para sa kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Nang nakita ng mga nananahan sa lupaing yaon, ng mga Cananeo, ang pagluluksa sa giikan ni Atad, kanilang sinabi, “Ito ay isang napakalungkot na pagluluksa ng mga Ehipto.” Kaya ang pangalang itinawag sa lugar na iyon ay Abel-Mizraim, na nasa kabilang dako ng Jordan. ");
INSERT INTO tglulb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kaya ginawa ng kanyang mga anak kay Jacob ang ayon sa inihabilin niya sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Dinala siya ng kanyang mga anak sa lupain ng Canaan at inilibing siya sa kuweba sa bukid ng Macpela, malapit sa Mamre. Binili ni Abraham ang kuweba na may bukid para maging lugar na paglilibingan. Binili niya ito kay Ephron na Hetheo. ");
INSERT INTO tglulb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Matapos niyang ilibing ang kanyang ama, bumalik si Jose patungong Ehipto, siya, kasama ang kanyang mga kapatid na lalaki, siya, at lahat ng sumama sa kaniya sa paglilibing sa kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nang nakita ng mga kapatid na lalaki ni Jose na ang kanilang ama ay patay na, sinabi nila, “Paano kung si Jose ay may dinadala pang sama ng loob at nais niyang pagbayarin tayo ng buo para sa lahat ng kasamaan na ginawa natin sa kanya?” ");
INSERT INTO tglulb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kaya nagpadala sila ng mensahe kay Jose, na nagsasabing, “Nagbigay ng mga tagubilin ang iyong ama bago siya mamatay, na nagsasabing. ");
INSERT INTO tglulb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Ganito ang sabihin ninyo kay Jose, “Pakiusap patawarin mo ang kasalanan ng iyong mga kapatid at ang kamalian na kanilang nagawa nang pinagmalupitan ka nila.” Ngayon pakiusap patawarin mo ang mga lingkod ng Diyos ng iyong ama. Si Jose ay umiyak nang dinala ang mensahe sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Nagpunta rin ang kanyang mga kapatid na lalaki at nagpatirapa sa harap niya. Sinabi nila, “Tingnan mo, kami ay iyong mga lingkod.” ");
INSERT INTO tglulb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pero sinagot sila ni Jose, “Huwag kayong matakot. Nasa lugar ba ako ng Diyos? ");
INSERT INTO tglulb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","At para sa inyo, ninais niyo na ipahamak ako, pero ninais ng Diyos ito para sa kabutihan, para pag-ingatan ang buhay ng maraming tao, gaya ng nakikita ninyo ngayon. ");
INSERT INTO tglulb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kaya ngayon huwag kayong matakot. Paglalaanan ko kayo at ang inyong mga anak.” Inaliw niya sila sa paraang ito at nakipag-usap ng may kagandahang-loob sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nanirahan si Jose sa Ehipto, kasama ng sambahayan ng kanyang ama. Nabuhay siya ng isandaan at sampung taon. ");
INSERT INTO tglulb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Nakita ni Jose ang mga anak ni Efraim hanggang sa ikatlong salinlahi. Nakita niya rin ang mga anak ni Makir na anak ni Manases. Sila ay “ipinanganak sa kanyang mga tuhod.” ");
INSERT INTO tglulb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Sinabi ni Jose sa kanyang mga kapatid, “Malapit na akong mamatay; pero tiyak na pupuntahan kayo ng Diyos at pangungunahan kayo palabas ng lupaing ito papunta sa lupain na kanyang ipinangakong ibibigay kay Abraham, kay Isaac at kay Jacob.” ");
INSERT INTO tglulb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Pagkatapos ipinasumpa ni Jose ang mga anak ni Israel. Sinabi niya, “Tiyak na pupuntahan kayo ng Diyos. Sa panahong iyon kailangan ninyong dalhin ang aking mga buto mula rito.” ");
INSERT INTO tglulb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kaya namatay si Jose sa gulang na isandaan at sampung taon. Pagkatapos siyang embalsamuhin, siya ay inilagay nila sa isang kabaong sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ito ang mga pangalan ng mga anak na lalaki ni Israel na sumama kay Jacob sa Ehipto, bawat isa sa kanilang sambahayan ay: ");
INSERT INTO tglulb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi at Juda. ");
INSERT INTO tglulb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zebulun, at Benjamin, ");
INSERT INTO tglulb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftali, Gad at Asher. ");
INSERT INTO tglulb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Lahat ng ipinanganak mula kay Jacob ay pitumpu ang bilang. Si Jose ay nasa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Pagkatapos si Jose, lahat ng kaniyang mga lalaking kapatid, at lahat ng salinlahing iyon ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ang mga Israelita ay naging mabunga, lubhang dumami ang bilang at naging napakalakas; ang lupain ay napuno nila. ");
INSERT INTO tglulb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Pagkatapos isang bagong hari ang namahala sa Ehipto, na walang pakialam sa alaala ni Jose. ");
INSERT INTO tglulb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Sinabi niya sa kaniyang bayan “Tingnan ninyo ang mga Israelita; mas marami pa sila at malalakas pa kaysa sa atin. ");
INSERT INTO tglulb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tara na, makipag-ugnayan tayo nang may karunungan sa kanila. Kundi patuloy silang dadami, at kung magkaroon ng digmaan, sasama sila sa ating mga kaaway, makikipaglaban sa atin at aalis sa lupain.” ");
INSERT INTO tglulb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kaya naglagay sila ng mahihigpit na tagapangasiwa sa kanila para apihin sila ng mabibigat na trabaho. Nagtayo ang mga Israelita ng lungsod imbakan para kay Paraon: Pitom at Rameses. ");
INSERT INTO tglulb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Habang inaapi sila ng mga taga-Ehipto, mas dumarami ang bilang ng mga Israelita at kumakalat. Kaya sinimulan ng mga taga-Ehipto para mangamba ang mga Israelita. ");
INSERT INTO tglulb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Pinagtatrabaho ng mabagsik ng mga taga-Ehipto ang mga Israelita. ");
INSERT INTO tglulb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ginawa nilang masaklap ang kanilang buhay na may kasamang mabibigat na paglilingkod sa tisa at laryo, at sa lahat ng uri ng gawain sa mga bukid. Lahat na kailangan nilang gawain ay mahirap. ");
INSERT INTO tglulb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Pagkatapos ang hari ng Ehipto ay nakipag-usap sa Hebreong mga komadrona; ang pangalan ng isa ay si Sifra, at ang isa ay si Pua. ");
INSERT INTO tglulb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Sinabi niya, “Kung tutulong kayo sa mga Hebreong babae sa paanakan, pagmasdan ninyo kapag sila ay manganganak. Kapag ang sanggol ay lalaki, patayin ninyo; pero kung ito ay babae, siya ay mabubuhay.” ");
INSERT INTO tglulb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pero ang mga hilot ay natakot sa Diyos at hindi nila ginawa ang iniutos ng hari ng Ehipto; sa halip, pinabayaan nilang mabuhay ang mga lalaking sanggol. ");
INSERT INTO tglulb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Pinatawag ng hari ng Ehipto ang mga komadrona at sinabi sa kanila, “Bakit pinabayaan ninyo na mabuhay ang mga lalaking sanggol?” ");
INSERT INTO tglulb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Sumagot ang mga hilot kay Paraon, “Ang mga babaeng Hebreo ay hindi tulad ng mga babaeng taga-Ehipto; sila ay masigla at tapos nang manganak bago dumating ang komadrona.” ");
INSERT INTO tglulb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Pinangalagaan ng Diyos ang mga komadrona. Ang mga tao ay dumarami ang bilang at naging napakalakas. ");
INSERT INTO tglulb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Dahil may takot ang mga komadrona sa Diyos, binigyan sila ng kanilang sariling pamilya. ");
INSERT INTO tglulb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Inutusan ni Paraon ang lahat ng kaniyang mga tao, “Kailangan ninyong itapon sa ilog bawat lalaki na ipinanganak, pero pabayaan ninyong mabuhay ang bawat babae.” ");
INSERT INTO tglulb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ngayon isang lalaki sa lipi ng mga Levi ang nakapag-asawa ng isang babaeng Levi. ");
INSERT INTO tglulb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nabuntis ang babae at nagsilang ng isang anak na lalaki. Nang makita niya na malusog ang bata, itinago niya ito ng tatlong buwan. ");
INSERT INTO tglulb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pero nang hindi na siya maitago nila, kumuha siya ng isang basket na papirus at sinelyohan ito ng aspalto at alkitran. Pagkatapos nilagay niya dito ang bata at inilagay ito sa mga tambo sa tubig sa tabi ng ilog. ");
INSERT INTO tglulb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ang kaniyang kapatid na babae ay nakatayo sa may hindi kalayuan para tingnan kung anong mangyayari sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ang anak na babae ni Paraon ay nagpunta sa ilog para maligo doon habang naglalakad ang kaniyang mga katulong sa tabing ilog. Nakita niya ang basket kasama ng mga tambo at pinapuntahan niya sa kaniyang katulong para kunin ito. ");
INSERT INTO tglulb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Nang buksan niya ito, nakita niya ang bata. Masdan ito, ang bata ay umiiyak. Siya ay nahabag sa kaniya at sinabing, “Ito ay tiyak na isa sa mga sanggol ng mga Hebreo.” ");
INSERT INTO tglulb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Pagkatapos sinabi ng kapatid na babae ng bata sa anak na babae ni Paraon, “Maaari ba akong pumunta at kumuha ng isang babaeng Hebreo para alagaan ang sanggol para sa iyo?” ");
INSERT INTO tglulb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Sinabi ng anak na babae ni Paraon sa kaniya, “Pumunta ka”. Kaya nagpunta ang batang babae at kinuha ang ina ng sanggol. ");
INSERT INTO tglulb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Sinabi ng anak na babae ni Paraon sa ina ng bata, “Kunin mo ang sanggol na ito at alagaan mo siya para sa akin, at bibigyan kita ng mga kabayaran.” Kaya kinuha ng babae ang sanggol at inalagaan siya. ");
INSERT INTO tglulb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nang lumaki na ang sanggol, siya ay dinala niya sa anak na babae ni Paraon, at siya ay naging lalaking anak niya. Pinangalanan niya siyang Moises at sinabing, “Dahil inahon kita mula sa tubig” ");
INSERT INTO tglulb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Nang lumaki na si Moises, pumunta siya sa kaniyang bayan at inobserbahan ang kanilang mahirap na gawain. Nakita niya ang isang taga-Ehipto na sinasaktan ang isang Hebreo, isa sa kaniyang sariling bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Lumingon siya sa magkabilang banda, at nang makita niya na walang tao doon, pinatay niya ang taga-Ehipto at tinago ang kaniyang katawan sa buhangin. ");
INSERT INTO tglulb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Lumabas siya nang sumunod na araw, at, nakita ang dalawang Hebreo na nag-aaway. Sinabi niya sa isang may sala, “Bakit mo sinasaktan ang iyong kasamahan?” ");
INSERT INTO tglulb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Pero sinabi ng lalaki “Sino ang gumawa sa iyong pinuno at hatulan kami? Pinaplano mo ba akong patayin gaya ng iyong pagpatay sa taga-Ehipto?” Pagkatapos natakot si Moises at sinabing, “Anuman ang ginawa ko ay tiyak na nalaman ng iba.” ");
INSERT INTO tglulb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ngayon nang marinig ni Paraon ang tungkol dito, sinubukan niyang patayin si Moises. Pero tumakas si Moises mula kay Paraon at nanatili sa lupain ng Midian. Umupo siya doon sa tabi ng isang balon. ");
INSERT INTO tglulb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ngayon ang pari ng Midian ay mayroong pitong anak na babae. Dumating sila, umigib ng tubig, at pinuno ang mga labangan para painumin ang kawan ng kanilang ama. ");
INSERT INTO tglulb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Dumating ang mga pastol at sinubukang palayasin sila, pero lumapit si Moises at tinulungan sila. Pagkatapos pinainom niya ang kanilang mga kawan. ");
INSERT INTO tglulb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Nang pumunta ang mga babae kay Reuel na kanilang ama, sinabi niya, “Bakit maaga kayong nakauwi ngayong araw?” ");
INSERT INTO tglulb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Sinabi nila, “Tinulungan kami ng isang taga-Ehipto mula sa mga pastol. Ipinag-igib pa nga niya kami ng tubig at pinainom ang mga kawan.” ");
INSERT INTO tglulb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Sinabi niya sa kaniyang mga anak na babae, “Kaya nasaan siya? Bakit ninyo iniwan ang lalaki? Tawagin ninyo siya para makasabay natin siyang kumain.” ");
INSERT INTO tglulb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Sumang-ayon si Moises na manatili siya kasama ang lalaki, na binigay rin ang kaniyang anak na babae na si Zipora para mapangasawa. ");
INSERT INTO tglulb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Siya ay nagsilang ng anak na lalaki, at pinangalanan siya ni Moises na Gersom; sinabi niya, “Ako ay naging isang mamamayan sa isang dayuhang lupain.” ");
INSERT INTO tglulb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Lumipas ang isang mahabang panahon, ang hari ng Ehipto ay namatay. Ang mga Israelita ay dumaing dahil sa kanilang pagkaalipin. Sila ay humingi ng tulong, at ang kanilang daing ay nakarating sa Diyos dahil sa kanilang pagkaalipin. ");
INSERT INTO tglulb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nang marinig ng Diyos ang kanilang mga daing, inalala ng Diyos ang kaniyang tipan kay Abraham, kay Isaac, at kay Jacob. ");
INSERT INTO tglulb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nakita ng Diyos ang mga Israelita, at naunawaan niya ang kanilang kalagayan. ");
INSERT INTO tglulb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ngayon si Moises ay nagpapastol pa rin ng kawan ng biyenan niyang si Jetro, ang pari ng Midian. Pinangunahan ni Moises ang kawan sa malayong dako ng ilang at dumating sa Horeb, ang bundok ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Doon ang anghel ni Yahweh ay nagpakita sa kaniya sa isang nagliliyab na apoy sa mababang puno. Tumingin si Moises at nakita na nagliliyab ang puno pero ito ay hindi nasusunog. ");
INSERT INTO tglulb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Sinabi ni Moises, “Lilingon ako at titingnan ang kahanga-hangang bagay na ito, bakit ang puno ay hindi nasusunog.” ");
INSERT INTO tglulb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Nang makita ni Yahweh na lumingon si Moises para tingnan, tumawag ang Diyos sa kaniya mula sa mababang puno at sinabi, “Moises, Moises.” Sinabi ni Moises, “Narito po ako.” ");
INSERT INTO tglulb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Sinabi ng Diyos, “Huwag kang lumapit! Hubarin mo ang sapatos sa iyong mga paa, dahil ang lugar na kinatatayuan mo ay lupang inilaan sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Dagdag pa niya, “Ako ang Diyos ng iyong ama, ang Diyos ni Abraham, ang Diyos ni Isaac, at ang Diyos ni Jacob.” Pagkatapos tinakpan ni Moises ang kaniyang mukha, dahil takot siyang tumingin sa Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Sinabi ni Yahweh, “Tunay na nakita ko ang pagdurusa ng aking bayan na nasa Ehipto. Narinig ko ang kanilang pagsigaw dahil sa kanilang mahihigpit na tagapangasiwa, dahil alam ko ang tungkol sa kanilang pagdurusa. ");
INSERT INTO tglulb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Bumaba ako para palayain sila mula sa kapangyarihan ng mga taga-Ehipto at dalhin sila mula sa lupaing iyon patungo sa mabuti at malawak na lupain, sa isang lupaing dinadaluyan ng gatas at pulot; sa rehiyon ng mga Cananeo, Heteo, Amoreo, Perezeo, Hivita, at mga Jebuseo. ");
INSERT INTO tglulb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ngayon ang mga pagsigaw ng bayan ng Israel ay nakarating sa akin. Bukod dito, nakita ko ang pagmamalupit na dulot ng mga taga-Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kaya ngayon, ipapadala kita kay Paraon para dalhin mo ang aking bayan, ang mga Israelita, palabas mula sa Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Pero sinabi ni Moises sa Diyos, “Sino ba ako, na dapat akong magpunta kay Paraon at dalhin ang mga Israelita mula sa Ehipto?” ");
INSERT INTO tglulb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Sumagot ang Diyos, “Ako ay tiyak na makakasama mo. Ito ang magiging palatandaan na pinadala kita. Kapag nailabas mo ang bayan mula sa Ehipto, sasambahin ninyo ako sa bundok na ito.” ");
INSERT INTO tglulb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Sinabi ni Moises sa Diyos, “Pagpunta ko sa mga Israelita at sabihin sa kanilang, 'Ang Diyos ng inyong mga ninuno ay pinadala ako sa inyo,' at kung sabihin nila sa akin, 'Ano ang pangalan niya?' ano ang dapat kong sabihin sa kanila?” ");
INSERT INTO tglulb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Sinabi ng Diyos kay Moises, “AKO AY SI AKO.” Sabi ng Diyos, “Dapat mong sabihin sa mga Israelita, 'SI AKO ang nagpadala sa akin sa inyo.'” ");
INSERT INTO tglulb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Sinabi rin ng Diyos kay Moises, “Dapat mong sabihin sa mga Israelita, 'Si Yahweh, ang Diyos ng inyong mga ninuno, ang Diyos ni Abraham, ang Diyos ni Isaac, ang Diyos ni Jacob, ay nagpadala sa akin sa inyo. Ito ang aking pangalan magpakailanman, at ganito ako mapapanatili sa isipan ng lahat ng mga salinlahi.' ");
INSERT INTO tglulb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Lumakad ka at sama-samang tipunin ang mga nakatatanda ng Israel. Sabihin sa kanila, 'si Yahweh, ang Diyos ng inyong mga ninuno, ang Diyos ni Abraham, ni Isaac, at ni Jacob, ay nagpakita sa akin at nagsabi, “Tunay ngang napagmasdan ko kayo at nakita ang ginawa sa inyo sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nangako akong kukunin kayo mula sa pagmamalupit sa Ehipto patungo sa lupain ng mga Cananeo, Heteo, Amoreo, Perezeo, Hivita, at mga Jebuseo, isang lupaing dinadaluyan ng gatas at pulot. ");
INSERT INTO tglulb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Makikinig sila sa iyo. Ikaw at ang mga nakatatanda ng Israel ay dapat pumunta sa hari ng Ehipto, at dapat mong sabihin sa kaniya, 'Si Yahweh, ang Diyos ng mga Hebreo ay kinatagpo kami. Kaya ngayon hayaan mo kaming maglakbay ng tatlong araw sa ilang, para makapaghandog kami kay Yahweh, na aming Diyos.' ");
INSERT INTO tglulb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pero nalalaman ko na ang hari ng Ehipto ay hindi kayo papayagang umalis, maliban na ang kamay niya ay pilitin. ");
INSERT INTO tglulb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Iaabot ko ang kamay ko at sasalakayin ang mga taga-Ehipto ng mga himalang gagawin ko sa gitna nila. Pagkatapos niyon, papayagan niya kayong umalis. ");
INSERT INTO tglulb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Bibigyan ko ang mga taong ito ng pabor mula sa mga taga-Ehipto, kaya sa pag-alis ninyo, hindi kayo aalis na walang dala. ");
INSERT INTO tglulb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Bawat babae ay hihingi ng pilak at gintong alahas at mga damit mula sa kapitbahay na taga-Ehipto at sinumang babaeng nanatili sa bahay ng mga kapitbahay niya. Ilalagay ninyo ang mga iyon sa inyong mga anak na lalaki at babae. Sa paraang ito ay lolooban ninyo ang mga taga-Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Sumagot si Moises, “Pero paano kung hindi sila maniwala o makinig sa akin pero sa halip na sabihin, 'Si Yahweh ay hindi nagpakita sa iyo'?” ");
INSERT INTO tglulb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Sinabi ni Yahweh sa kaniya, “Ano iyang nasa kamay mo?” Sinabi ni Moises, “Isang tungkod.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Sinabi ni Yahweh, “Ihagis mo ito sa lupa.” Inihagis ito ni Moises sa lupa, at ito ay naging isang ahas. Tumakbo si Moises palayo dito. ");
INSERT INTO tglulb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Sinabi ni Yahweh kay Moises, “Damputin mo at hawakan ito sa buntot.” Kaya dinampot niya at hinawakan ang ahas. Naging tungkod ito muli sa kaniyang kamay. ");
INSERT INTO tglulb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Ito ay para maniwala sila na si Yahweh, ang Diyos ng kanilang mga ninuno, ang Diyos ni Abraham, ang Diyos ni Isaac, at ang Diyos ni Jacob, ang nagpakita sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Sinabi rin ni Yahweh sa kaniya, “Ngayon ilagay mo ang iyong kamay sa loob ng iyong balabal.” Kaya inilagay ni Moises ang kaniyang kamay sa loob ng kaniyang balabal. Nang ilabas niya ito, namasdan, na ang kaniyang kamay ay naging ketong, kasing puti ng niyebe. ");
INSERT INTO tglulb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Sinabi ni Yahweh, “Ilagay mo ulit ang iyong kamay sa loob ng iyong balabal.” Kaya inilagay ni Moises ang kaniyang kamay sa loob ng kaniyang balabal, at ng inilabas niya ito, nakita niya na naging malusog ito muli, tulad ng kaniyang ibang laman. ");
INSERT INTO tglulb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Sinabi ni Yahweh, “Kung hindi sila maniniwala sa iyo—kung hindi nila bibigyang pansin ang unang palatandaan ng aking kapangyarihan o maniniwala dito, pagkatapos paniniwalaan nila ang ikalawang palatandaan. ");
INSERT INTO tglulb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","At kung hindi sila maniniwala kahit sa dalawang palatandaan ng aking kapangyarihan, o makikinig sa iyo, pagkatapos kumuha ka ng kaunting tubig mula sa ilog at ibuhos ito sa tuyong lupa. Ang tubig na iyong kinuha ay magiging dugo sa tuyong lupa.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Pagkatapos sinabi ni Moises kay Yahweh, “Panginoon, hindi ako naging magaling manalita, kahit pa noong nakaraan o ni mula ng nakipag-usap ka sa iyong lingkod. Mahina ako sa pananalita at mahina ang dila.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Sinabi ni Yahweh sa kaniya, “Sino ba itong gumawa ng bibig ng tao? Sino bang gumawa sa taong pipi o bingi, nakakakita o bulag? Hindi ba ako, si Yahweh? ");
INSERT INTO tglulb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Kaya ngayon lumakad ka at kasama mo ako sa iyong pananalita at tuturuan kita kung ano ang sasabihin.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Pero sinabi ni Moises, “Panginoon, pakiusap magpadala ka nalang ng iba, sinuman ang gusto mong ipadala.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Pagkatapos nagalit si Yahweh kay Moises. Sinabi niya, “Ano kaya kung si Aaron, ang iyong kapatid na Levita? Alam ko na nakakapagsalita siya ng maayos. Bukod dito, paparating siya para makipagkita sa iyo, at kapag nakita ka niya, magsasaya ang kaniyang puso. ");
INSERT INTO tglulb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Makikipag-usap ka sa kaniya at ilalagay mo sa kaniyang bibig ang mga salita na dapat sabihin. Ako ay mapapasa iyong bibig at sa kaniyang bibig, at ipapakita ko sa inyo kung ano ang gagawin. ");
INSERT INTO tglulb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Magsasalita siya sa mga tao para sa iyo. Siya ang magiging tagapagsalita mo, at ikaw sa kaniya ay magiging tulad ko, parang Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Dadalhin mo ang tungkod na ito sa iyong kamay. Sa pamamagitan nito gagawin mo ang mga palatandaan.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kaya bumalik si Moises kay Jetro ang kaniyang biyenang lalaki, at sinabi sa kaniya, “Payagan mo akong umalis para makabalik sa aking mga kamag-anak na nasa Ehipto at makita ko kung buhay pa ba sila.” Sinabi ni Jetro kay Moises, “Lumakad ka nang may kapayapaan.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Sinabi ni Yahweh kay Moises sa Midian, “Lumakad ka, bumalik ka sa Ehipto, dahil lahat ng mga taong nagnanais kunin ang iyong buhay ay patay na.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Dinala ni Moises ang kaniyang asawa at mga anak na lalaki at isinakay niya sila sa asno. Bumalik siya sa lupain ng Ehipto, at dinala niya ang tungkod ng Diyos na nasa kaniyang kamay. ");
INSERT INTO tglulb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Sinabi ni Yahweh kay Moises, “Kung babalik ka sa Ehipto, siguraduhin mong gawin sa harapan ni Paraon ang lahat ng mga kababalaghan na inilagay ko sa iyong kapangyarihan. Pero patitigasin ko ang kaniyang puso, at hindi niya paaalisin ang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kailangan mong sabihin kay Paraon, 'Ito ang sinasabi ni Yahweh: ang Israel ay aking anak, ang aking panganay, ");
INSERT INTO tglulb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","At sasabihin ko sa iyo, “Payagan mo ang aking anak na umalis, kaya siya ay sasamba sa akin.” Pero dahil ikaw ay tumangging paalisin siya, tiyak na papatayin ko ang iyong anak, ang iyong panganay.”' ");
INSERT INTO tglulb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ngayon habang nasa daan, nang huminto sila para sa gabi, si Yahweh ay nakipagkita kay Moises at sinubukang patayin siya. ");
INSERT INTO tglulb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Pagkatapos kumuha si Zepora ng batong matulis at pinutol niya ang unahang balat ng kaniyang anak na lalaki, at inilapat ito sa paa ni Moises. Pagkatapos sinabi niya, “Sigurado ako na ikaw ang lalaking ikakasal sa akin sa pamamagitan ng dugo.” ");
INSERT INTO tglulb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Kaya hinayaan siya ni Yahweh na mag-isa. Sinabi niya, “Ikaw ang lalaking ikakasal sa dugo” dahil sa pagtutuli. ");
INSERT INTO tglulb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Sinabi ni Yahweh kay Aaron, “Pumunta ka doon sa ilang para makipagkita kay Moises.” Pumunta si Aaron, at nakipagkita sa kaniya sa bundok ng Diyos, at hinalikan siya. ");
INSERT INTO tglulb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Sinabi ni Moises kay Aaron ang lahat ng mga salita ni Yahweh na ipinadala niya para sabihin at tungkol sa lahat ng mga palatandaan ng kapangyarihan ni Yahweh na iniutos niya na kaniyang gagawin. ");
INSERT INTO tglulb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Pagkatapos pumunta at tinipon nina Moises at Aaron ang lahat ng mga nakatatanda ng mga Israelita. ");
INSERT INTO tglulb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Sinabi ni Aaron ang lahat ng mga salita na sinabi ni Yahweh kay Moises. Ipinakita niya rin ang mga palatandaan ng kapangyarihan ni Yahweh sa paningin ng mga tao. ");
INSERT INTO tglulb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Naniwala ang mga tao. Nang marinig nila na si Yahweh ay nag-oobserba sa mga Israelita at nakita niya ang kanilang pagkaalipin, pagkatapos iniyuko nila ang kanilang mga ulo at sinamba siya. ");
INSERT INTO tglulb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Nang matapos ang mga bagay na ito, pumunta sina Moises at Aaron kay Paraon at sinabi, “Ito ang sinabi ni Yahweh, ang Diyos ng Israel, sinabing: 'Pabayaan mong umalis ang aking bayan, para magkaroon sila ng pagdiriwang para sa akin doon sa ilang.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Sinabi ni Paraon, “Sino si Yahweh? Bakit ako makikinig sa kaniyang tinig at hahayaang umalis ang Israel? Hindi ko kilala si Yahweh; bukod dito, hindi ko papayagang umalis ang Israel.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Sinabi nila. “Ang Diyos ng mga Hebreo ay nakipagkita sa amin. Payagan mo kaming umalis at maglakbay ng tatlong araw doon sa ilang at mag-alay kay Yahweh na aming Diyos para hindi niya kami salakayin ng salot o may espada.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pero sinabi ng hari ng Ehipto sa kanila, “Moises at Aaron, bakit ninyo pinapaalis ang mga tao sa kanilang gawain? Bumalik kayo sa inyong gawain.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Sinabi rin niya, “Marami ng mga taong Hebreo ngayon sa aming lupain, at papatigilin mo sila sa kanilang gawain.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Sa araw ding iyon, nagbigay ng utos si Paraon sa mga katiwala at mga mahihigpit na tagapangasiwa. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Hindi tulad noon, hindi na ninyo kailanman bibigyan ang mga tao ng dayami para gawing mga laryo. Pabayaan ninyong magtipon ng para sa kanilang sarili. ");
INSERT INTO tglulb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Gayun pa man, dapat pa rin ninyong hihingiin sa kanila ang parehong bilang ng mga laryo na ginawa nila noon. Huwag ninyong tanggapin ang anumang kakaunti, dahil sila ay tamad. Kaya nga sila ay tumatawag at sinasabing, 'Payagan ninyo kaming umalis at mag-alay sa aming Diyos.' ");
INSERT INTO tglulb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Dagdagan pa ang mga gawain ng mga kalalakihan para magpatuloy sila rito at hindi na papansinin ang mapanlinlang na mga salita.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kaya ang mga mahihigpit na tagapangasiwa at katiwala ay lumabas at pinaalam sa mga tao. Sinabi nila, ''Ito ang sinasabi ni Paraon: 'Hindi na ako kailanman magbibigay ng kahit anong dayami sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kayo na sa inyong sarili ang umalis at kumuha ng dayami kahit saan ninyo ito mahahanap, pero ang inyong gawain ay hindi mababawasan.”' ");
INSERT INTO tglulb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kaya ang bayan ay nagsikalat sa buong lupain ng Ehipto para maka-ipon ng mga pinagputulan para sa dayami. ");
INSERT INTO tglulb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Palagi silang hinihimok ng mahihigpit na tagapangasiwa at sinasabing, “Tapusin ninyo ang inyong trabaho, sa panahon na maibigay ang dayami sa inyo.”' ");
INSERT INTO tglulb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Binubugbog ng mga mahihigpit na tagapangasiwa ni Paraon ang mga katiwala na Israelita, iyon ding taong nilalagay nila bilang pinuno sa mga manggagawa. Palaging tinatanong ng mga mahihigpit na tagapangasiwa sa kanila, “Bakit hindi ninyo naibibigay ang lahat ng hinihinging laryo sa inyo, maski kahapon at ngayon, na dati ninyong ginagawa?” ");
INSERT INTO tglulb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Kaya pumunta ang mga Israelitang katiwala kay Paraon at tumawag sa kaniya. Sinabi nila, “Bakit sa ganitong paraan ang pakikitungo mo sa iyong mga lingkod? ");
INSERT INTO tglulb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Wala nang dayaming binibigay sa iyong mga lingkod, pero sinasabi pa rin nila sa amin, 'Gumawa kayo ng mga laryo!' Kami, ang iyong mga lingkod, ay binubugbog maski ngayon, pero kagagawan ito ng sarili mong bayan.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pero sinabi ni Paraon, “Kayo ay mga tamad! Kayo ay mga tamad! Sabi niyo, 'Payagan mo kaming umalis para makapag-alay kay Yahweh.' ");
INSERT INTO tglulb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kaya ngayon bumalik na kayo sa trabaho. Wala nang dayami ang ibibigay sa inyo, pero gagawa pa rin kayo ng parehong bilang ng mga laryo.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nakita ng mga Israelitang katiwala na sila ay nasa panganib nang sinabihan silang, “Hindi ninyo babawasan ang araw-araw na bilang ng mga laryo.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Nakipagkita sila kina Moises at Aaron na nakatayo sa labas ng palasyo, papalayo kay Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Sinabi nila kina Moises at Aaron, “Nawa tingnan kayo ni Yahweh at paparusahan kayo, dahil ginawa ninyo kaming maging hindi kanais-nais sa paningin ni Paraon at sa kaniyang mga lingkod. Inilagay ninyo ang espada sa kanilang kamay para patayin kami.” ");
INSERT INTO tglulb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Bumalik si Moises kay Yahweh at sinabi, “Panginoon, bakit mo idinulot ang panganib sa mga taong ito? Bakit mo pala ako ipinadala? ");
INSERT INTO tglulb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sa simula pa lang na pumunta ako kay Paraon para magsalita sa kaniya sa iyong pangalan, idinulot niya ang panganib para sa mga taong ito, at hindi mo pinalaya ang iyong bayan.” ");
INSERT INTO tglulb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Pagkatapos sinabi ni Yahweh kay Moises, “Ngayon makikita mo kung ano ang gagawin ko kay Paraon. Makikita mo ito, dahil hahayaan niya na sila ay umalis dahil sa aking malakas na kamay. Dahil sa kamay kong makapangyarihan, sila ay kaniyang palalayasin sa kaniyang lupain.” ");
INSERT INTO tglulb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Kinausap ng Diyos si Moises at sinabi sa kaniya, “Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nagpakita ako kay Abraham, kay Isaac, at kay Jacob bilang Diyos na Makapangyarihan; pero sa pamamagitan ng aking pangalang Yahweh, ay hindi ako nahayag sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Itinatag ko rin sa kanila ang aking tipan, para ibigay sa kanila ang lupain ng Canaan, ang lupain na kung saan sila ay nanirahan bilang hindi mamamayan, ang lupain kung saan sila ay lumibot. ");
INSERT INTO tglulb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Dagdag pa doon, narinig ko ang mga daing ng mga Israelita na siyang inalipin ng mga taga-Ehipto, at inalala ko ang aking tipan sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kaya, sabihin sa mga Israelita, 'Ako si Yahweh. Dadalhin ko kayo palabas mula sa pagkaalipin sa ilalim ng mga taga-Ehipto, at palalayain ko kayo mula sa kanilang kapangyarihan. Kayo ay aking ililigtas sa pagpapakita ng aking kapangyarihan, at makapangyarihang mga gawa ng paghatol. ");
INSERT INTO tglulb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Dadalhin ko kayo sa aking sarili bilang aking bayan, at ako ay inyong magiging Diyos. Malalaman ninyo na ako si Yahweh, ang inyong Diyos, na nagdala sa inyo palabas mula sa pagkaalipin sa ilalim ng mga taga-Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Dadalhin ko kayo sa lupain na aking sinumpaan para ibigay kay Abraham, kay Isaac, at kay Jacob. Ibibigay ko ito sa inyo bilang isang pag-aari. Ako si Yahweh.'” ");
INSERT INTO tglulb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Nang sinabi ito ni Moises sa mga Israelita, ayaw nilang makinig sa kaniya dahil sa pagkasira ng kanilang loob dahil sa lupit ng kanilang pagkaalipin. ");
INSERT INTO tglulb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Kaya nakipag-usap si Yahweh kay Moises at sinabing, ");
INSERT INTO tglulb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Pumunta ka at sabihan si Paraon, ang hari ng Ehipto, na hayaang umalis ang bayan ng Israel mula sa kaniyang lupain.” ");
INSERT INTO tglulb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Sinabi ni Moises kay Yahweh, “Kung ang mga Israelita ay hindi nakinig sa akin, bakit makikinig si Paraon sa akin, gayong hindi ako magaling sa pagsasalita?” ");
INSERT INTO tglulb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Nagsalita si Yahweh kay Moises at kay Aaron. Nagbigay siya ng kautusan para sa mga Israelita at para kay Paraon, ang hari ng Ehipto, na dalahin ang mga Israelita palabas sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ito ay ang mga pinuno sa mga bahay ng kanilang mga ama. Mga anak na lalaki ni Ruben, ang panganay ni Israel, sina Hanoch, si Phallu, si Hezron, at si Carmi. Ang mga ito ay ang angkan ng mga ninuno ni Ruben. ");
INSERT INTO tglulb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ang mga anak na lalaki ni Simeon ay sina Jemuel, si Jamin, si Ohad, si Jachin, si Zohar, at si Shaul—ang anak na lalaki sa isang babaeng Cananeo. Ang mga ito ay ang angkan ng mga ninuno ni Simeon. ");
INSERT INTO tglulb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Narito ang naitalang mga pangalan ng mga anak na lalaki ni Levi, kasama ng kanilang mga kaapu-apuhan. Sila ay sina Gerson, Kohath, at Merari. Nabuhay si Levi hanggang siya ay 137 taong gulang. ");
INSERT INTO tglulb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ang mga anak na lalaki ni Gerson ay sina Libni at Shimi. ");
INSERT INTO tglulb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ang mga anak na lalaki ni Kohath ay sina Amram, Izhar, Hebron at Uzziel. Si Kohath ay nabuhay hanggang siya ay 133 taong gulang. ");
INSERT INTO tglulb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ang mga anak na lalaki ni Merari ay sina Mahali at Musi. Ang mga ito ang naging mga ninunong angkan ng mga Levita, kasama ng kanilang mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Napangasawa ni Amram si Jochebed, ang kapatid na bababe ng kaniyang ama. Ipinanganak niya sina Aaron at Moises. Si Amram ay nabuhay ng 137 taon at pagkatapos ay namatay. ");
INSERT INTO tglulb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ang mga anak na lalaki ni Izhar ay sina Korah, Nepheg, at Zithri. ");
INSERT INTO tglulb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ang mga anak na lalaki ni Uzziel ay sina Misael, si Elzaphan, at si Zithri. ");
INSERT INTO tglulb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Napangasawa ni Aaron si Elisheba, anak na babae ni Aminadab, na kapatid na babae ni Naashon. Ipinanganak niya sina Nadab at Abiu, si Eleazar at Ithamar. ");
INSERT INTO tglulb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ang mga anak na lalaki ni Cora ay sina, Assir, Elcana, at Abiasaph. Ito ang mga ninunong angkan ng mga Corita. ");
INSERT INTO tglulb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Si Eleazar, na anak na lalaki ni Aaron, ay napangasawa ang isa sa mga anak na babae ni Putiel. Ipinanganak niya si Finehas. Ito ang mga pinuno sa bahay ng mga ama sa gitna ng mga Levita, kabilang ng kanilang mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ang dalawang lalaking ito ay sina Aaron at Moises kung kanino sinabi ni Yahweh, “Dalhin palabas ang mga Israelita mula sa lupain ng Ehipto, sa pamamagitan ng kanilang mga pangkat ng mga lalaking mandirigma.” ");
INSERT INTO tglulb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Nakipag-usap si Aaron at si Moises kay Paraon, ang hari ng Ehipto, para pahintulutan silang mailabas ang mga Israelita mula sa Ehipto. Ang mga ito pa rin ay sina Moises at Aaron. ");
INSERT INTO tglulb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Nang nagsalita si Yahweh kay Moises sa lupain ng Ehipto, ");
INSERT INTO tglulb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","sinabi niya sa kaniya, “Ako si Yahweh. Sabihin mo kay Paraon, ang hari ng Ehipto, lahat ng sasabihin ko sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Pero sinabi ni Moises kay Yahweh, “Hindi ako magaling sa pagsasalita, kaya bakit makikinig si Paraon sa akin?” ");
INSERT INTO tglulb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Sinabi ni Yahweh kay Moises, “Tingnan mo, ginawa kitang parang isang diyos kay Paraon. Si Aaron na iyong kapatid ang magiging propeta mo. ");
INSERT INTO tglulb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Sasabihin mo ang lahat ng inutos kong sabihin mo. Ang kapatid mong si Aaron ay makikipag-usap kay Paraon para payagan niya ang bayan ng Israel na umalis mula sa kaniyang lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pero patitigasin ko ang puso ni Paraon, at magpapakita ako ng maraming palatandaan ng aking kapangyarihan, maraming kamangha-mangha, sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pero si Paraon ay hindi makikinig sa iyo, kaya ilalagay ko ang kamay ko sa Ehipto at ilalabas ang aking mga pangkat ng mandirigmang kalalakihan, aking bayan, ang mga kaapu-apuhan ni Israel, palabas sa lupain ng Ehipto sa pamamagitan ng dakilang mga gawa ng pagpaparusa. ");
INSERT INTO tglulb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Malalaman ng mga taga-Ehipto na ako si Yahweh kapag iniabot ko ang aking kamay sa Ehipto at inilabas ang mga Israelita mula sa kanila.” ");
INSERT INTO tglulb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ginawa iyon nina Moises at Aaron; ginawa nila tulad ng inutos ni Yahweh sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Si Moises ay walumpung taong gulang, at si Aaaron ay walumpu't tatlong taong gulang nang nakipag-usap sila kay Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Sinabi ni Yahweh kina Moises at Aaron, ");
INSERT INTO tglulb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kapag sinabi ni Paraon sa inyo, 'Gumawa kayo ng isang himala,' sa gayon sasabihin mo kay Aaron, 'Kunin mo ang iyong tungkod at itapon sa harap ni Paraon, para ito ay maging isang ahas.'” ");
INSERT INTO tglulb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Pagkatapos pumunta sina Moises at Aaron kay Paraon, at ginawa nila ayon sa inutos ni Yahweh. Tinapon ni Aaron ang kaniyang tungkod sa harapan ni Paraon at kaniyang mga lingkod, at ito ay naging isang ahas. ");
INSERT INTO tglulb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pagkatapos tinawag din ni Paraon ang kaniyang mga matatalino at salamangkero. Gumawa sila ng kaparehong bagay sa kanilang salamangka. ");
INSERT INTO tglulb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Bawat isang lalaki ay itinapon ang kaniyang tungkod at ang mga tungkod ay naging mga ahas. Pero ang tungkod ni Aaron ay nilamon ng kanilang mga ahas. ");
INSERT INTO tglulb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ang puso ni Paraon ay tumigas, at hindi siya nakinig, tulad ng naunang pinahayag ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Sinabi ni Yahweh kay Moises, “Matigas ang puso ni Paraon, at tumatanggi siyang payagang umalis ang ang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pumunta ka kay Paraon sa umaga kapag lumabas siya papunta sa tubig. Tumayo ka sa pampang ng ilog para salabungin siya, at hawakan ang tungkod na naging ahas sa iyong kamay. ");
INSERT INTO tglulb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Sabihin mo sa kaniya, 'Si Yahweh, ang Diyos ng mga Hebreo ay pinadala ako sa iyo para sabihin, “Payagan mong umalis ang aking bayan, para sambahin nila ako sa ilang. Hanggang ngayon ay hindi ka nakikinig.” ");
INSERT INTO tglulb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Sinasabi ito ni Yahweh: “Sa pamamagitan nito ay makikilala mong ako si Yahweh. Hahampasin ko ang tubig ng Ilog Nilo ng tungkod na nasa kamay ko, at ang tubig ay magiging dugo. ");
INSERT INTO tglulb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ang mga isda na nasa ilog ay mamamatay, at ang ilog ay mangangamoy. Ang mga taga-Ehipto ay hindi makakainom ng tubig mula sa ilog.” ");
INSERT INTO tglulb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Pagkatapos sinabi ni Yahweh kay Moises, “Sabihin mo kay Aaron, 'Kunin mo ang iyong tungkod at iabot mo ang kamay mo sa dako ng mga tubig ng Ehipto, sa dako ng kanilang mga ilog, mga batis, mga lawa, at lahat ng mga tubigan, para ang kanilang tubig ay maging dugo. Gawin mo ito para magkaroon ng dugo sa lahat ng buong lupain ng Ehipto, kahit na sa lalagyang kahoy at bato.'” ");
INSERT INTO tglulb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ginawa nina Moises at Aaron ayon sa inutos ni Yahweh. Itinaas ni Aaron ang tungkod at hinampas ang tubig sa ilog, sa paningin nina Paraon at ng kaniyang mga lingkod. Lahat ng tubig sa ilog ay naging dugo. ");
INSERT INTO tglulb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ang mga isda sa ilog ay namatay, at ang ilog ay nagsimulang mangamoy. Hindi makainom ang mga taga-Ehipto ng tubig mula sa ilog, at ang dugo ay nasa lahat ng dako sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pero ang mga salamangkero ng Ehipto ay gumawa ng kaparehong bagay sa kanilang salamangka. Kaya ang puso ni Paraon ay tumigas, at tumanggi siyang makinig kay Moises at Aaron, tulad ng sinabi ni Yahweh na mangyayari. ");
INSERT INTO tglulb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pagkatapos tumalikod si Paraon at nagpunta sa kaniyang bahay. Hindi man lamang niya binigyang pansin ito. ");
INSERT INTO tglulb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Lahat ng mga taga-Ehipto ay naghukay sa palibot ng ilog para sa tubig na maiinom, pero hindi nila mainom ang mismong tubig ng ilog. ");
INSERT INTO tglulb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pitong araw ang lumipas matapos salakayin ni Yahweh ang ilog. ");
INSERT INTO tglulb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Pagkatapos sinabi ni Yahweh kay Moises, “Puntahan mo si Paraon at sabihin mo sa kaniya, 'Ito ang sinabi ni 'Yahweh: “Hayaan mong umalis ang aking bayan para sila ay sumamba sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kung tatanggi ka na paalisin sila, pararanasin ko ang iyong buong bansa ng mga salot na palaka. ");
INSERT INTO tglulb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mapupuno ang ilog ng mga palaka. Aahon sila at papasok sa iyong bahay, sa iyong silid tulugan, at sa iyong higaan. Pupunta sila sa mga bahay ng iyong mga lingkod. Sila ay pupunta sa iyong bayan, sa iyong mga hurno, sa iyong mga masahang mangkok. ");
INSERT INTO tglulb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Sasalakay ang mga palaka sa iyo, sa iyong mga tauhan, at sa lahat ng iyong mga lingkod.\"”' ");
INSERT INTO tglulb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Sinabi ni Yahweh kay Moises, “Sabihin mo kay Aaron, 'Iunat mo ang iyong kamay at ang iyong tungkod sa ibabaw ng mga ilog, sa mga sapa at sa mga tubigan at dalhin mo ang mga palaka doon sa lupain ng Ehipto.”' ");
INSERT INTO tglulb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Inunat ni Aaron ang kaniyang kamay sa ibabaw ng mga tubig ng Ehipto, at nagsilabasan ang mga palaka at linukob ang lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pero ang mga salamangkero ay gumawa ng katulad din nito gamit ang kanilang mga salamangka: nagdala rin sila ng mga palaka sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pagkatapos tinawag ni Paraon sina Moises at Aaron at sinabi, “Manalangin kayo kay Yahweh para paalisin niya ang mga palaka mula sa akin at sa aking bayan. Pagkatapos hahayaan ko ang mga tao na umalis, para maghandog sa kaniya.” ");
INSERT INTO tglulb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Sinabi ni Moises kay Paraon, “Maaari kang magkaroon ng pribilehiyo na sabihan ako kung kailan ako magdasal para sa iyo, sa iyong mga lingkod at sa iyong bayan, para ang mga palaka ay mawala mula sa iyo at sa iyong mga bahay at manatili lamang doon sa ilog.” ");
INSERT INTO tglulb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Sinabi ni Paraon, “Bukas.” Sinabi ni Moises, “Mangyayari ayon sa sinabi mo, para malaman mo na walang ibang katulad ni Yahweh, ang aming Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Aalis ang mga palaka mula sa iyo, sa iyong mga bahay, sa iyong mga lingkod, at sa iyong bayan. Mananatili lamang ang mga ito sa ilog.” ");
INSERT INTO tglulb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Umalis sina Moises at Aaron mula kay Paraon. Pagkatapos tumawag si Moises kay Yahweh tungkol sa mga palaka na dinala niya roon kay Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ginawa ni Yahweh ang hiningi ni Moises: ang mga palaka ay namatay sa loob ng mga bahay, mga patyo, at sa mga parang. ");
INSERT INTO tglulb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Tinipon ito ng mga tao sa tambakan at nangamoy ang lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero nang nakita ni Paraon na mayroon doong kaginhawahan, pinatigas niya ang kaniyang puso at hindi siya nakinig kina Moises at Aaron, tulad ng kung ano ang sinabi ni Yahweh na gagawin niya. ");
INSERT INTO tglulb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Sinabi ni Yahweh kay Moises, “Sabihin mo kay Aaron, 'Iunat mo ang iyong tungkod at hampasin mo ang alikabok sa lupa, para ito ay maging niknik sa lahat ng lupain ng Ehipto.”' ");
INSERT INTO tglulb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ginawa nila ito: Iniunat ni Aaron ang kaniyang kamay at ang kaniyang tungkod. Hinampas niya ang alikabok sa lupa. Dumating ang mga niknik sa mga tao at sa mga hayop. Lahat ng mga alikabok sa lupa ay naging niknik sa buong lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ang mga salamangkero ay nagsubok gamit ang kanilang salamangka para makagawa ng niknik, pero hindi sila nakagawa. May mga niknik sa mga tao at mga hayop. ");
INSERT INTO tglulb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Pagkatapos sinabi ng mga salamamgkero kay Paraon, “Ito ang daliri ng Diyos” Pero ang puso ni Paraon ay pinatigas, kaya tumanggi siyang makinig sa kanila. Tulad ito ng sinabi ni Yahweh na gagawin ni Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Sinabi ni Yahweh kay Moises, “Gumising ka ng maaga at tumayo sa harapan ni Paraon habang siya ay papunta ng ilog. Sabihin mo sa kaniya, 'Ito ang sinabi ni Yahweh: “Hayaan mong umalis ang aking bayan para sila ay sumamba sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pero kung hindi mo paaalisin ang aking bayan, magpapadala ako ng mga kuyog ng langaw sa iyo, sa iyong mga lingkod, at sa iyong mga tauhan, at sa iyong mga bahay. Ang mga bahay ng mga taga-Ehipto ay mapupuno ng mga kuyog ng langaw, at kahit sa lupa kung saan sila nakatayo ay mapupuno ng mga langaw. ");
INSERT INTO tglulb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pero sa araw na iyon ituturing kong kakaiba ang lupain ng Gosen, ang lupain kung saan naninirahan ang aking bayan, para walang mga kuyog ng langaw ang paparoon. Ito ay mangyayari para iyong malaman na ako si Yahweh sa kalagitnaan ng lupaing ito. ");
INSERT INTO tglulb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Gagawa ako ng pagkakakilanlan sa pagitan ng aking bayan at ng iyong bayan. Itong tanda ng aking kapangyarihan ay magaganap bukas.”” ");
INSERT INTO tglulb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ginawa nga ito ni Yahweh, at ang makakapal na mga kuyog ng langaw ay dumating sa bahay ni Paraon at sa mga bahay ng kaniyang mga lingkod. Sa buong lupain ng Ehipto, ang lupain ay nasalanta dahil sa mga kuyog ng langaw. ");
INSERT INTO tglulb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Tinawag ni Paraon sina Moises at Aaron at sinabi, “Lumakad kayo, mag-alay kayo sa inyong Diyos dito sa aming sariling lupa.” ");
INSERT INTO tglulb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Sinabi ni Moises, “Hindi tama sa amin na gawin iyan, dahil ang mga handog na aming ginagawa para kay Yahweh na aming Diyos ay karumal-dumal para sa mga taga Ehipto. Kapag gumawa kami ng pag-aalay na karumal-dumal sa paningin ng mga taga-Ehipto, hindi ba nila kami babatuhin? ");
INSERT INTO tglulb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Hindi, ito ay tatlong araw na paglalakbay patungong ilang na aming gagawin, para makapag-alay kay Yahweh na aming Diyos, ayon sa kaniyang iniutos sa amin.” ");
INSERT INTO tglulb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Sinabi ni Paraon, “Papayag ako na umalis kayo at maghandog kay Yahweh na inyong Diyos doon sa ilang. Huwag lamang kayong pumunta sa napakalayo. At ipanalangin ninyo ako.” ");
INSERT INTO tglulb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Sinabi ni Moises, “Pagkaalis na pagkaalis ko mula sa iyo, mananalangin ako kay Yahweh na ang mga kuyog ng langaw ay aalis mula sa inyo, Paraon, at sa iyong mga lingkod at sa bayan mo bukas. Pero ikaw ay hindi na dapat manlinlang sa pamamagitan ng hindi pagpaalis sa aking bayan para maghandog kay Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Umalis si Moises mula kay Paraon at nanalangin kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ginawa ni Yahweh ang hiniling ni Moises: Inalis niya ang mga kuyog ng langaw mula kay Paraon, sa kaniyang mga lingkod, at sa kaniyang bayan. Wala ni isa ang natira. ");
INSERT INTO tglulb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pero sa panahong ito pinatigas pa rin ni Paraon ang kaniyang puso, at hindi niya pinayagang umalis ang bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Pagkatapos sinabi ni Yahweh kay Moises, “Pumunta ka kay Paraon at sabihin sa kaniya, 'ang sabi ni Yahweh, ang Diyos ng mga Hebreo: “Hayaang umalis ang aking bayan, para sila ay sumamba sa akin”. ");
INSERT INTO tglulb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Pero kung ikaw ay tatanggi na paalisin sila, kung patuloy mo silang panatilihin, ");
INSERT INTO tglulb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","pagkatapos ang kamay ni Yahweh ay nasa inyong mga baka na nasa bukirin at sa mga kabayo, mga asno, mga kamelyo, mga kawan at mga tupa at magdudulot ito ng isang matinding sakit. ");
INSERT INTO tglulb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ituturing ni Yahweh na magkaiba ang mga baka ng mga Israelita at ang mga baka ng taga-Ehipto: walang hayop na pag-aari ng mga Israelita ang mamamatay. ");
INSERT INTO tglulb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nagtakda si Yahweh ng isang panahon; kaniyang sinabi, “Gagawin ko bukas ang bagay na ito sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ito ang ginawa ni Yahweh sa sumunod na araw: namatay ang lahat ng mga baka sa Ehipto. Pero wala ni isa sa mga hayop ng mga Israelita ang namatay, wala ni isang hayop. ");
INSERT INTO tglulb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nagsaliksik si Paraon, at nakita, wala ni isang hayop ng mga Israelita ang namatay. Pero matigas ang kaniyang puso, kaya hindi niya hinayaang umalis ang bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Pagkatapos sinabi ni Yahweh kay Moises at kay Aaron, “Kumuha kayo ng ilang dakot ng mga abo mula sa isang hurno. Ikaw, Moises, dapat mong ihagis ang mga abo sa hangin habang nanonood si Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Magiging pinong alikabok na kakalat sa buong lupain ng Ehipto. Magdudulot ng mga pigsa at pamamaga na siyang kakalat sa mga tao at mga hayop sa buong lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kaya kumuha si Moises at Aaron ng mga abo na mula sa isang hurno at tumayo sa harapan ni Paraon. Pagkatapos, inihagis ni Moises ang mga abo sa hangin. Nagdulot ang mga abo ng pigsa at pamamaga na siyang kumalat sa mga tao at mga hayop. ");
INSERT INTO tglulb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Hindi mapigilan ng mga salamangkero si Moises dahil sa mga pigsa; dahil nagkaroon din sila ng mga pigsa maging ang lahat ng ibang mga taga-Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pinatigas ni Yahweh ang puso ni Paraon, kaya hindi nakinig si Paraon kina Moises at Aaron. Ito mismo ang sinabi ni Yahweh kay Moises na gagawin ng Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Pagkatapos sinabi ni Yahweh kay Moises, “Gumising ka ng maaga, tumayo ka sa harapan ni Paraon, at sabihin sa kaniya, 'si Yahweh, ang Diyos ng mga Hebreo, sinasabi ito: “Hayaan mong umalis ang aking bayan para maari silang sumamba sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Sa oras na ito ipapadala ko ang lahat ng mga salot sa iyo mismo, sa iyong mga lingkod at sa iyong bayan. Gagawin ko ito para malaman mo na walang sinuman ang katulad ko dito sa buong mundo. ");
INSERT INTO tglulb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Sa ngayon maaari kung iunat ang aking kamay at lusubin ka at ang iyong bayan ng sakit, at kayo ay lipulin mula sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Pero sa ganitong kadahilanan hinayaan ko kayong makaligtas: para maipakita ang aking kapangyarihan, nang sa ganoon maipahayag ko sa lahat ng panig ng mundo ang aking pangalan. ");
INSERT INTO tglulb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Patuloy mong itinataas ang iyong sarili laban sa aking bayan sa pamamagitan ng hindi mo pagpayag na paalisin sila. ");
INSERT INTO tglulb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Makinig! Bukas sa ganito ring oras magdadala ako ng isang napakalakas na ulang may yelo, pangyayari na hindi pa nakikita sa Ehipto mula sa unang araw nito hanggang ngayon. ");
INSERT INTO tglulb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kaya ngayon, magpadala ka ng mga lalaki at ipunin sa ligtas na lugar ang iyong mga baka at ang lahat ng mayroon ka sa iyong bukid sa ligtas na lugar. Ang bawat tao at hayop na nasa bukid at hindi dinala sa bahay—babagsak sa kanila ang ulang may yelo, at mamamatay sila.”'” ");
INSERT INTO tglulb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Pagkatapos ang mga lingkod ni Paraon na naniwala sa mensahe ni Yahweh, ay nagmadali na dalhin ang kanilang mga alipin at mga baka sa kanilang mga bahay. ");
INSERT INTO tglulb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pero ang mga hindi magseryoso ng mensahe ni Yahweh ay iiwan ang kanilang mga alipin at mga baka sa mga bukid. ");
INSERT INTO tglulb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Pagkatapos sinabi ni Yahweh kay Moises, “Iunat mo ang iyong kamay patungo sa kalangitan para magkaroon ng ulang may yelo sa lahat ng lupain ng Ehipto, sa bayan, sa mga hayop at sa lahat ng mga halaman sa mga bukid sa buong lupain ng Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Iniunat ni Moises ang kaniyang tungkod patungo sa kalangitan, at nagpadala si Yahweh ng kulog, ulang may yelo at kidlat sa lupa. Pinaulanan din niya ng yelo ang lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Kaya nagkaroon ng ulan at kidlat na may kasamang yelong ulan, napakalubha, bagay na hindi pa nangyayari sa buong lupain ng Ehipto mula nang ito ay maging isang bansa. ");
INSERT INTO tglulb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Sa buong lupain ng Ehipto, tumama ang ulang ay yelo sa lahat ng bagay na nasa mga bukid, sa kapwa mga tao at mga hayop. Tumama ito sa bawat halaman na nasa mga bukid at sinira ang bawat punongkahoy. ");
INSERT INTO tglulb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Doon lamang sa lupain ng Gosen, kung saan nakatira ang mga Israelita, hindi umulan ng yelo. ");
INSERT INTO tglulb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pagkatapos nagpadala ang Paraon ng mga tao para ipatawag sina Moises at Aaron. Sinabi niya sa kanila, “Nagkasala ako sa oras na ito. Si Yahweh ay matuwid at ako at ang aking bayan ay masasama. ");
INSERT INTO tglulb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Magdasal kayo kay Yahweh, dahil ang napakalakas na mga kidlat at ulang may yelo ay sobra na. Papaalisin ko na kayo at hindi na kayo titira dito. ");
INSERT INTO tglulb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Sinabi ni Moises sa kaniya, “Sa oras na umalis ako sa lungsod, ilalatag ko ang aking mga kamay kay Yahweh. Titigil na ang kulog at wala ng anumang ulang may yelo. Sa ganitong paraan malalaman mo na pag-aari ni Yahweh ang mundo. ");
INSERT INTO tglulb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero para sa iyo at sa iyong mga lingkod, alam ko na hindi niyo talaga ginagalang si Yahweh na Diyos.” ");
INSERT INTO tglulb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ngayon ang mga lino at sebada ay nasira, dahil ang uhay magulang na sa tangkay at namumulaklak na ang lino. ");
INSERT INTO tglulb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pero ang trigo at ang espelta ay hindi nasalanta dahil huli itong tumubo. ");
INSERT INTO tglulb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Nang umalis si Moises kay Paraon at sa lungsod, inilatag niya ang kaniyang mga kamay kay Yahweh; tumigil ang kulog at ulang may yelo, at ang ulan ay hindi na bumuhos pa. ");
INSERT INTO tglulb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Nang nakita ni Paraon na ang ulan, ang ulang may yeloo at kulog ay humupa na, muling nagkasala siya at pinatigas ang kaniyang puso, kasama ang kaniyang mga lingkod. ");
INSERT INTO tglulb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Pinatigas ang puso ni Paraon, kaya hindi niya pinayagang umalis ang bayan ng Israel. Ito ang paraan na sinabi ni Yahweh kay Moises na ito ang gagawin ni Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Sinabi ni Yahweh kay Moises, “Puntahan mo ang Paraon, dahil pinatigas ko ang kaniyang puso at ang mga puso ng kaniyang mga lingkod. Ginawa ko ito para maipakita ang mga palatandaan ng aking kapangyarihan sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ginawa ko rin ito para maikuwento mo sa iyong mga anak at mga apo ang mga bagay na ginawa ko, kung paano ko pinagmalupitan ang Ehipto, at kung paano ko binigay ang iba't-ibang mga palatandaan ng aking kapangyarihan sa kanila. Sa ganitong paraan malalaman mo na ako si Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kaya pumunta sina Moises at Aaron sa Paraon at sinabi sa kaniya, “Sinabi ito ni Yahweh, ang Diyos ng mga Hebreo: 'Hanggang kailan mo tatanggihan ang pagpapakumbaba ng iyong sarili sa aking harapan? Hayaan mo nang umalis ang aking bayan para sumamba sila sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Pero kung tatanggihan mo na paalisin ang aking bayan, makinig ka, bukas magpapadala ako ng mga balang sa iyong lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tatakpan nila ang ibabaw ng lupain nang wala ni isang makakakita ng lupa. Kakainin nila ang mga tira ng anumang nakaligtas mula sa ulang may yelo. Kakainin din nila ang bawat puno na tumutubo para sa inyo sa mga bukid. ");
INSERT INTO tglulb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Pupunuin nila ang inyong mga tahanan, iyong lahat ng mga lingkod, at lahat ng mga taga-Ehipto—bagay na hindi pa kailanman nakita ng iyong ama maging ng iyong lolo, hindi pa kailanman nasaksihan mula noong araw na nasa mundo na sila hanggang sa kasalukuyan.'” Pagkatapos umalis si Moises at lumabas mula sa harap ni Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Sinabi ng mga lingkod ni Paraon sa kaniya, “Gaano ba katagal na magiging pahamak ang taong ito sa atin? Hayaan mo nang umalis ang mga Israelita para makasamba kay Yahweh na kanilang Diyos. Hindi mo pa ba napagtanto na wasak na ang Ehipto?” ");
INSERT INTO tglulb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Muling dinala sina Moises at Aaron sa Paraon, na siyang nagsabi sa kanila, “Sige, sambahin ninyo si Yahweh na inyong Diyos. Pero anong klaseng mga tao ba ang aalis?” ");
INSERT INTO tglulb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Sinabi ni Moises, “Aalis kami na kasama ang aming mga kabataan at ang aming mga matatanda, kasama ang aming mga anak na lalaki at mga anak na babae. Dadalhin din namin ang mga kawan at mga baka, dahil kailangan naming magdiwang para kay Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Sinabi ng Paraon sa kanila, “Nawa'y samahan nga kayo ni Yahweh, kung sakali na paaalisin ko kayo at ang inyong maliliit na mga bata. Tingnan niyo, may sa kasamaan kayong iniisip. ");
INSERT INTO tglulb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hindi! Lumakad kayo, ang mga lalaki lamang na nasa inyo at sambahin si Yahweh, dahil iyan ang gusto ninyo.” Pagkatapos pinaalis sina Moises at Aaron sa harapan ni Paraon. ");
INSERT INTO tglulb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Pagkatapos sinabi ni Yahweh kay Moises, “Iunat mo ang iyong mga kamay at ituon sa buong lupain ng Ehipto, at sa mga balang para lusubin nila ang lupain ng Ehipto at kainin ang bawat tanim na naroroon, lahat ng mga natira mula sa ulang may yelo.” ");
INSERT INTO tglulb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Iniunat ni Moises ng kaniyang tungkod sa buong lupain ng Ehipto, at nagdala si Yahweh ng silangang hangin sa lupain sa buong araw na iyon at sa buong gabi. Kinaumagahan, nagdala ang silangang hangin ng mga balang. ");
INSERT INTO tglulb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Pumunta ang mga balang sa buong lupain ng Ehipto at pinugaran ang lahat ng bahagi nito. Napakaraming mga balang na kailanman ay hindi pa nakarating sa lupain at hindi na mauulit pa. ");
INSERT INTO tglulb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tinakpan nila ang ibabaw ng buong lupain sa gayon nagdilim ito. Kinain nila ang bawat halaman na nasa lupain at ang lahat ng bunga ng mga punongkahoy na natira ng ulang may yelo. Walang natirang buhay na berdeng halaman o anumang punongkahoy o halaman sa mga bukid sa lahat ng lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pagkatapos mabilis na pinatawag ng Paraon sina Moises at Aaron at sinabing, “Nagkasala ako laban kay Yahweh na inyong Diyos at laban sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kaya ngayon, patawarin ninyo ako sa aking kasalanan sa oras na ito, at idalangin ninyo kay Yahweh na inyong Diyos na kaniyang alisin ang kamatayang ito mula sa akin.” ");
INSERT INTO tglulb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kaya lumabas si Moises mula sa harap ng Paraon at nanalangin kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Dinala ni Yahweh ang napakalakas na kanlurang hangin na dumampot sa mga balang at itinangay sila patungo sa Dagat ng mga Tambo; Wala ni isang balang ang natira sa buong lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero pinatigas ni Yahweh ang puso ni Paraon, at hindi pinaalis ni Paraon ang mga Israelita. ");
INSERT INTO tglulb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Pagkatapos sinabi ni Yahweh kay Moises, “Iunat mo ang iyong kamay patungo sa kalangitan, para magkaroon ng kadiliman sa buong lupain ng Ehipto, kadiliman na maaaring madama.” ");
INSERT INTO tglulb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Iniunat ni Moises ang kaniyang kamay patungo sa kalangitan at nagkaroon ng makapal na kadiliman sa buong lupain ng Ehipto sa loob ng tatlong araw. ");
INSERT INTO tglulb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wala ni isang nakakakita ng sinuman; wala ni isang lumisan sa kanilang mga tirahan sa loob ng tatlong araw. Pero, mayroong ilaw ang lahat ng mga Israelita, sa lugar kung saan sila nakatira. ");
INSERT INTO tglulb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pinatawag ng Paraon si Moises at sinabing, “Lumakad kayo at sambahin si Yahweh. Maaari na ring sumama sa inyo maging ang inyong mga pamilya, pero dapat maiwan ang inyong mga kawan at mga grupo ng mga hayop.” ");
INSERT INTO tglulb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pero sinabi ni Moises, “Kailangan mo rin magbigay ng mga hayop para sa mga alay at sunog na mga handog para maihandog namin kay Yahweh na aming Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Kailangan din naming isama ang aming mga baka; wala ni isang paa nila ang maiiwan, dahil kailangan namin silang dalhin para sa pagsamba kay Yahweh na aming Diyos. Dahil hindi namin alam kung ano ang aming kakailanganin sa pagsamba kay Yahweh hanggang sa makarating kami roon.” ");
INSERT INTO tglulb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero pinatigas ni Yahweh ang puso ng Paraon at hindi niya sila hinayaang umalis. Sinabi ng Paraon kay Moises, ");
INSERT INTO tglulb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","“Lumayo kayo sa akin! Mag-ingat sa isang bagay, nang hindi mo na ako muling makita, dahil sa araw na makita mo ang aking mukha, mamamatay ka.” ");
INSERT INTO tglulb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Sinabi ni Moises, “Ikaw na mismo ang nagsalita. Hindi ko na muling makikita ang iyong mukha.” ");
INSERT INTO tglulb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Pagkatapos sinabi ni Yahweh kay Moises, “Mayroon pa rin akong isang salot na dadalhin kay Paraon at sa Ehipto. Pagkatapos niyan, papayagan na niya kayong makaalis mula rito. Kapag ganap na pinayagan na niya kayong makaalis, itataboy niya kayo ng tuluyan. ");
INSERT INTO tglulb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Turuan mo ang mga tao na ang bawat mga lalaki at babae ay humingi sa kanilang kapitbahay ng mga hiyas na pilak at mga hiyas na ginto.” ");
INSERT INTO tglulb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ngayon ginawang masabik ni Yahweh ang mga taga-Ehipto para malugod ang mga Israelita. Bukod dito, ang tauhan ni Moises ay talagang kahanga-hanga sa paningin ng mga alipin ni Paraon at mga tao sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Sinabi ni Moises. “Ito ang mga sinabi ni Yahweh: 'Pupunta ako sa buong Ehipto ng hating gabi. ");
INSERT INTO tglulb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Mamamatay ang lahat ng panganay sa lupain ng Ehipto, mula sa panganay ni Paraon, na nakaupo sa kaniyang trono, hanggang sa panganay ng aliping babae na siyang nasa likod ng gilingan ng trigo nito, at sa lahat ng panganay ng mga baka. ");
INSERT INTO tglulb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Pagkatapos magkakaroon ng isang matinding iyakan sa buong lupain ng Ehipto, tulad ng hindi pa kailanman nangyari at hindi na kailanman mangyayaring muli. ");
INSERT INTO tglulb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero kahit hindi tumahol ang isang aso laban sa alinmang taga-Israel, sinuman laban sa tao o hayop. Sa ganitong paraan malalaman ninyo ang pagkakaiba ng pagtrato ko sa mga taga-Ehipto at sa mga Israelita.' ");
INSERT INTO tglulb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Lahat ng mga alipin mong ito, Paraon ay magpapakumbaba at luluhod sa akin. Sasabihin nila, 'Umalis na kayo at sa lahat ng mga taong sumusunod sa iyo!' Pagkatapos lalabas ako.” Pagkatapos umalis siya mula kay Paraon na may matinding galit. ");
INSERT INTO tglulb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Sinabi ni Yahweh kay Moises, “Hindi makikinig si Paraon sa iyo. Ito ay mangyari para makagawa ako ng maraming kamangha-manghang mga bagay sa lupain ng Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ginawa lahat nina Moises at Aaron ang mga kababalaghan sa harapan ni Paraon. Pero pinatigas ni Yahweh ang puso ni Paraon, at hindi pinayagan ni Paraon na makaalis ang mga Israelita sa kaniyang lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nakipag-usap si Yahweh kina Moises at Aaron sa lupain ng Ehipto. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Para sa inyo, ang buwan na ito ay magiging simula ng mga buwan, ang unang buwan ng taon sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Sabihan ang kapulungan ng Israel, 'Sa ikasampung araw ng buwan na ito dapat kumuha ang bawat isa ng isang tupa o batang kambing para sa kanilang mga sarili, gagawin ito ng bawat pamilya, isang tupa para sa bawat sambahayan. ");
INSERT INTO tglulb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kung ang sambahayan ay napakaliit para sa isang tupa, ang tao at sa kaniyang kapitbahay ay kukuha ng tupa o karne ng batang kambing na sapat para sa bilang ng tao. Dapat ito ay sapat para sa bawat isa na kakain, kaya kailangan nilang kumuha ng sapat na karne para ipakain sa kanilang lahat. ");
INSERT INTO tglulb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ang inyong tupa o batang kambing ay dapat walang kapintasan, isang taong gulang na lalaki. Maaari ninyong kunin ang isa sa tupa o mga kambing. ");
INSERT INTO tglulb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Kailangan ninyong ingatan ito hanggang sa ikalabing-apat na araw sa buwan na iyon. Pagkatapos kailangang papatayin ang mga hayop na ito ng buong kapulungan ng Israel sa takip-silim. ");
INSERT INTO tglulb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kailangan ninyong kumuha ng ilang dugo at ipahid sa dalawang magkabilang poste ng pintuan at sa itaas ng balangkas ng pintuan ng mga bahay na kung saan kakainin ninyo ang karne. ");
INSERT INTO tglulb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Dapat ninyong kainin ang karne sa gabing iyon, pagkatapos na ihawin ito sa apoy. Kainin ninyo ito ng may tinapay na walang lebadura, kasama ang mga mapapait na damong-gamot. ");
INSERT INTO tglulb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Huwag ninyong kainin itong hilaw o pinakuluan sa tubig. Sa halip, ihawin ninyo ito sa apoy kasama ang ulo, mga binti at ng lamang-loob. ");
INSERT INTO tglulb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Huwag ninyong hayaan na may matira nito hanggang umaga. Dapat ninyong sunugin ito anuman ang natira sa umaga. ");
INSERT INTO tglulb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ganito dapat kung paano ninyo ito kakainin: Suot ang inyong sinturon sa inyong baywang, ang inyong mga sapatos sa inyong paa, at inyong tungkod sa kamay. Kailangan ninyong kainin ito ng mabilisan. Ito ang Paskua ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Sinabi ito ni Yahweh: Pupunta ako sa buong lupain ng Ehipto sa gabing iyon at sasalakayin ang lahat ng mga panganay na anak ng tao at ng hayop sa lupain ng Ehipto. Dadalhin ko ang kaparusahan sa lahat ng mga diyos ng Ehipto. Ako ay si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ang dugo ay magiging isang palatandaan sa inyong mga tahanan para sa pagdating ko sa inyo. Kapag nakita ko ang dugo, lalagpasan ko lang kayo kapag sinalakay ko ang lupain ng Ehipto. Ang salot na ito ay hindi dadapo sa inyo at wawasak sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ang araw na ito ay magiging araw ng pag-alaala para sa inyo, kung saan dapat ninyong sundin bilang isang pista para kay Yahweh. Ito ay mananatiling isang batas para sa inyo, sa lahat ng inyong mga salinlahi, na dapat ninyong sundin ngayong araw. ");
INSERT INTO tglulb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kakain kayo ng tinapay na walang lebadura sa loob ng pitong araw. Sa unang araw aalisin ninyo ang lebadura mula sa inyong mga tahanan. Ang sinumang kakain ng may lebadurang tinapay mula sa unang araw at hanggang sa ika-pitong araw, ang taong ito ay dapat itiwalag mula sa Israel. ");
INSERT INTO tglulb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Sa unang araw magkakaroon ng isang pagpupulong para ilaan sa akin, at sa ika-pitong araw magkakaroon ng ibang ganoong pagtitipon. Walang trabahong gagawin sa mga araw na ito, maliban sa pagluluto para sa makakain ng lahat. Iyon lang dapat ang trabaho na maaari ninyong gawin. ");
INSERT INTO tglulb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Dapat ninyong pagmasdan ang Pista ng Tinapay na walang Lebadura dahil sa araw na ito dadalhin ko ang inyong bayan, armadong grupo sa armadong grupo, palabas sa lupain ng Ehipto. Kaya dapat ninyong sundin ang araw na ito sa lahat ng salinlahi ng inyong bayan. Ito ay mananatiling isang batas para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Dapat kayong kumain ng tinapay na walang lebadura mula sa takipsilim ng ikalabing-apat na araw ng unang buwan ng taon, hanggang sa takipsilim ng ikadalawampu't isang araw ng buwan. ");
INSERT INTO tglulb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sa loob ng pitong araw na ito, dapat walang lebadura ang makikita sa loob ng inyong mga tahanan. Kung sinuman ang kakain ng tinapay na may lebadura ay dapat itiwalag sa komunidad ng Israel, kahit na ang taong iyon ay isang dayuhan o isang taong ipinanganak sa inyong lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Dapat kayong kumain ng walang lebadura. Saanman kayo manirahan, dapat kayong kumain ng tinapay na walang lebadura.'” ");
INSERT INTO tglulb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Pagkatapos ipinatawag lahat ni Moises ang mga matatanda sa Israel at sinabi sa kanila, “Lumakad kayo at pumili ng mga tupa o mga maliliit na kambing na sapat para maipakain sa inyong mga pamilya at papatayin ang Paskuang tupa. ");
INSERT INTO tglulb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Pagkatapos kumuha ng isang bigkis ng hisopo at isawsaw sa dugo na nasa isang palanggana. Ipahid ang dugo na nasa palanggana sa itaas ng balangkas ng pinto sa dalawang magkabilang poste. Wala sa inyo ni isa ang lalabas ng pintuan ng kaniyang tahanan hanggang sa umaga. ");
INSERT INTO tglulb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Dahil si Yahweh ay dadaan para salakayin ang mga taga-Ehipto. Kapag nakita niya ang dugo sa itaas ng inyong balangkas at sa dalawang magkabilang poste, lalagpasan niya lamang ang inyong pintuan at hindi niya pahihintulutan ang tagawasak na makapasok sa inyong tahanan para kayo ay salakayin. ");
INSERT INTO tglulb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Dapat ninyong ipagdiwang ang pangyayaring ito. Ito ay mananatiling isang batas para sa inyo at sa inyong mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kung kayo ay papasok sa lupain na ibibigay ni Yahweh sa inyo, tulad ng ipinangako niyang gagawin, dapat ninyong sundin ang pagsambang gawain na ito. ");
INSERT INTO tglulb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kapag nagtanong ang inyong mga anak, 'Ano ang ibig sabihin ng kilos na pag-sambang ito?' ");
INSERT INTO tglulb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","At dapat ninyong sabihin, 'Ito ay sakripisyo sa Paskua ni Yahweh, dahil nilagpasan lang ni Yahweh ang mga tahanan ng mga Israelita sa Ehipto nang sinalakay niya ang mga taga-Ehipto. Pinalaya niya ang aming sambahayan.”' Pagkatapos ang bayan ay yumuko at sumamba kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Umalis ang mga Israelita at ganap na ginawa kung ano ang iniutos ni Yahweh kina Moises at Aaron. ");
INSERT INTO tglulb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ito ay nangyari ng hatinggabi ng sinalakay ni Yahweh ang lahat ng panganay sa lupain ng Ehipto, mula sa panganay ni Paraon, na nakaupo sa kaniyang trono, hangang sa panganay ng taong nasa kulungan at sa lahat ng panganay ng mga baka. ");
INSERT INTO tglulb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Nagising si Paraon sa gabing iyon—siya, at ang lahat ng kaniyang alipin, at lahat ng mga taga-Ehipto. Nagkaroon ng malakas na pagdadalamhati sa Ehipto, dahil wala ni isang tahanan ang naroroon ang walang namatay. ");
INSERT INTO tglulb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pinatawag ni Paraon sina Moises at Aaron sa gabing iyon at sinabing, “Tumayo kayo at lumayas mula sa bayan ko, kayo at ang mga Israelita. Umalis na kayo, at sumamba kay Yahweh, gaya ng sinabi ninyo na nais ninyong gawin. ");
INSERT INTO tglulb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Kunin na ninyo ang mga alagang hayop at mga kawan, tulad ng sinabi ninyo, at alis na, at pagpalain ninyo rin ako.” ");
INSERT INTO tglulb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ang mga taga-Ehipto ay nasa isang matinding pagmamadali para ipadala sila palabas ng lupain, dahil sinabi nila, “Lahat tayo ay taong patay na.” ");
INSERT INTO tglulb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kaya kinuha ng mga tao ang kanilang masa na walang idinagdag na lebadura. Ang kanilang pinagmamasahang mangkok ay binalot nila sa kanilang mga damit na nakalagay sa kanilang mga balikat. ");
INSERT INTO tglulb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ginawa ngayon ng bayang Israelita ang ayon sa sinabi ni Moises sa kanila. Humingi sila sa mga taga-Ehipto ng mga hiyas na pilak, ginto at damit. ");
INSERT INTO tglulb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ginawang sabik ni Yahweh ang mga taga-Ehipto para malugod ang mga Israelita. Kaya binigay ng mga taga-Ehipto ang anumang hingin nila. Sa ganitong paraan, nakuha ng mga Israelita ang yaman ng mga taga-Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Naglakbay ang mga Israelita mula sa Rameses hanggang Sucot. Ang kanilang bilang ay 600, 000 na mga lalaki, dagdag pa rito ang mga babae at mga bata. ");
INSERT INTO tglulb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Isang halu-halong pangkat ng hindi Israelita ay sumama rin sa kanila, kasama ang kanilang mga alagang hayop at mga kawan, isang malaking bilang ng mga baka. ");
INSERT INTO tglulb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Naghurno sila ng tinapay na walang lebadura sa ilalim ng masa na dinala nila mula sa Ehipto. Ito ay walang lebadura dahil sila ay pinalayas sa Ehipto at hindi maaaring ipagpaliban ang paghahanda ng pagkain. ");
INSERT INTO tglulb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ang mga Israelita ay nanirahan sa Ehipto sa loob ng 430 na taon. ");
INSERT INTO tglulb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Matapos ang 430 na taon, sa araw ding iyon, lahat ng mga armadong grupo ni Yahweh ay umalis palabas mula sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ito ay isang gabing dapat manatiling gising, para ilabas sila ni Yahweh mula sa lupain ng Ehipto. Ito ay gabi ni Yahweh na dapat ipagdiwang ng lahat ng mga Israelita sa lahat ng salinlahi ng kanilang bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Sinabi ni Yahweh kina Moises at Aaron, “Ito ang mga alituntunin para sa Paskua: walang dayuhan ang maaaring makibahagi sa pagkain na ito. ");
INSERT INTO tglulb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Kahit na, ang bawat alipin ng mga Israelita, na binili ng pera, ay maaaring makakain nito matapos ninyo silang tuliin. ");
INSERT INTO tglulb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Hindi makakain ang mga dayuhan at upahang lingkod ng alinmang pagkain. ");
INSERT INTO tglulb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Dapat kainin ang pagkain sa isang bahay. Huwag kayong magdadala ng anumang karne sa labas ng inyong bahay, at hindi ninyo dapat baliin ang kahit anumang buto nito. ");
INSERT INTO tglulb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Dapat obsebahan ng lahat ng mga komunidad ng Israel ang pagdiriwang. ");
INSERT INTO tglulb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Kapag maninirahan ang isang dayuhan sa inyo at gustong obserbahan ang Paskua para kay Yahweh, lahat ng kaniyang lalaking kamag-anak ay dapat tuliin. Pagkatapos siya ay maaaring dumating at sundin ito. Siya ay magiging katulad ng mga taong ipinanganak sa lupain. Ganun pa man, walang sinumang taong hindi tuli ang makakakain ng anumang pagkain. ");
INSERT INTO tglulb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Parehong batas ang siyang gagamitin sa kapwa katutubo o dayuhan na naninirahan kasama ninyong lahat.” ");
INSERT INTO tglulb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Kaya sinunod ng lahat ng mga Israelita nang lubusan ang iniutos ni Yahweh kina Moises at Aaron. ");
INSERT INTO tglulb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Dumating ang araw na iyon na dinala ni Yahweh ang Israel palabas sa lupain ng Ehipto sa pamamagitan ng kanilang mga armadong grupo. ");
INSERT INTO tglulb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nagsalita si Yahweh kay Moises at sinabing, ");
INSERT INTO tglulb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ilaan sa akin ang lahat ng mga panganay, ang bawat panganay na lalaki ng mga Israelita, kapwa mula sa mga tao at sa mga hayop. Pagmamay-ari ko ang mga panganay.” ");
INSERT INTO tglulb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Sinabi ni Moises sa mga tao, “Alalahanin ninyo ang araw na ito, ang araw kung saan kayo nakalabas mula sa Ehipto, nakalabas mula sa bahay ng pagkakaalipin, dahil nakalabas kayo mula sa lugar na ito sa pamamagitan ng malakas na kamay ni Yahweh. Walang tinapay na may halong lebadura ang kakainin. ");
INSERT INTO tglulb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Lalabas kayo mula sa Ehipto sa araw na ito, sa buwan ng Abib. ");
INSERT INTO tglulb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Dapat ninyong sundin ang ganitong pamamaraan ng pagsamba sa buwan na ito kapag dinala na kayo ni Yahweh sa lupain ng mga Cananeo, Heteo, Amoreo, Hivita at Jebuseo, ang lupain na kaniyang ipinangako na ibibigay sa inyong mga ninuno, isang lupain na umaagos ng gatas at pulot. ");
INSERT INTO tglulb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sa loob ng pitong araw dapat kayong kumain ng tinapay na walang lebadura; Sa ikapitong araw magkakaroon ng pista sa karangalan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tinapay na walang lebadura ang dapat kainin sa loob ng pitong araw; dapat walang tinapay na may lebadura ang makikita sa gitna ninyo. Dapat walang lebadurang makikita sa inyo sa loob ng inyong mga kinasasakupan. ");
INSERT INTO tglulb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Sa araw na iyon sasabihan ninyo ang inyong mga anak, 'Dahil ito ang ginawa ni Yahweh para sa akin nang lumabas ako mula sa Ehipto.' ");
INSERT INTO tglulb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Magsisilbi itong paalala para sa inyo sa inyong kamay, at isang paalala sa inyong noo. Para mapasainyong bibig itong batas ni Yahweh, dahil nakalabas kayo mula sa Ehipto sa pamamagitan ng malakas na kamay ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kaya dapat ninyong sundin ang batas na ito sa itinakdang panahon taun-taon. ");
INSERT INTO tglulb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Kapag dadalhin na kayo ni Yahweh sa lupain ng Cananeo, na kaniyang ipinangako sa inyo at sa inyong mga ninuno, at kapag ibinigay niya na ang lupain sa inyo, ");
INSERT INTO tglulb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kinakailangan ninyong ilaan sa kaniya ang lahat ng inyong mga panganay na anak at ang lahat ng mga unang ipinanganak ng inyong mga hayop. Kay Yahweh ang mga lalaki. ");
INSERT INTO tglulb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kailangan mong bilhin pabalik ang bawat unang ipinanganak na asno kasama ang isang tupa. Kapag hindi mo ito bibilhin pabalik, dapat mong baliin ang leeg nito. Pero ang bawat panganay sa inyong mga lalaki sa lahat ng inyong mga anak na lalaki—kailangan ninyo silang bilhin pabalik. ");
INSERT INTO tglulb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Sa darating na panahon, kapag nagtanong ang iyong anak na lalaki, “Ano ang ibig sabihin nito?' pagkatapos sabihin mo sa kaniya, 'Nakalabas tayo mula sa Ehipto sa pamamagitan ng lakas ng kamay ni Yahweh, mula sa bahay ng pagkaalipin. ");
INSERT INTO tglulb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Nang nagmamatigas na tinanggihan ng Paraon ang pagpapaalis sa amin, pinatay ni Yahweh ang lahat ng mga panganay sa buong lupain ng Ehipto, kapwa panganay na anak ng mga tao at ang panganay na anak ng mga hayop. Kung kaya bakit ako nag-aalay kay Yahweh ng mga panganay ng bawat hayop, at kung kaya bakit ko binibili pabalik ang aking mga panganay na lalaki.' ");
INSERT INTO tglulb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Magiging paalala ito sa iyong mga kamay, at paalala sa iyong noo, dahil nakalabas tayo mula sa Ehipto sa pamamagitan ng lakas ng kamay ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Nang pinayagan ni Paraon na umalis ang mga tao, hindi sila pinangunahan ng Diyos sa landas patungo sa lupain ng mga Palestina, kahit pa malapit ang lupain. Dahil sinabi ng Diyos, “Marahil magbabago ang mga tao ng kanilang mga isipan kapag nakaranas sila ng digmaan at pagkatapos babalik sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kaya pinatnubayan ng Diyos ang mga tao paikot sa may ilang patungo sa Dagat ng mga Tambo. Umakyat ang mga Israelita papalabas mula sa Ehipto na armado para sa pakikipaglaban. ");
INSERT INTO tglulb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Dinala ni Moises ang mga buto ni Jose, dahil taimtim na pinanumpa ni Jose ang mga Israelita at sinabing, “Siguradong ililigtas kayo ng Diyos, at kailangan ninyong dalhin papalayo ang aking mga buto kasama ninyo.” ");
INSERT INTO tglulb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Naglakbay ang mga Israelita mula sa Sucot at nagkampo sa Etam sa paligid ng ilang. ");
INSERT INTO tglulb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Sumabay si Yahweh sa kanila bilang isang haligi na ulap sa umaga para manguna sa kanilang landas. At sa gabi bilang isang haligi na apoy para bigyan sila ng ilaw. ");
INSERT INTO tglulb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Hindi inaalis ni Yahweh mula sa harapan ng mga tao ang pang-araw na haligi na ulap maging ang pang-gabi na haligi na apoy. ");
INSERT INTO tglulb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kinausap ni Yahweh si Moises: ");
INSERT INTO tglulb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Sabihin mo sa mga Israelita na sila ay bumalik at magkampo sa Pi Hahirot, sa pagitan ng Migdol at ng dagat, bago ang Baal Zefon. Kayo ay magkakampo sa tabing dagat at sa tapat ng Pi Hahirot. ");
INSERT INTO tglulb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Sasabihin ni Paraon ang tungkol sa mga Israelita, 'Naliligaw sila sa mga lupain. Sinara sila ng ilang. ");
INSERT INTO tglulb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Papatigasin ko ang puso ni Paraon, at hahabulin ko sila. Makakakuha ako ng parangal dahil kay Paraon at sa kaniyang mga hukbo. Malalaman ng mga taga-Ehipto na ako ay si Yahweh.” Kaya ang mga Israelita ay nagkampo dahil sa iniutos sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Nang sinabihan ng hari ng Ehipto na ang mga Israelita ay nakatakas, ang isipan ni Paraon at ng kaniyang mga lingkod ay bumaliktad laban sa bayan. Sinabi nila, “Anong ginawa natin at hinayaan nating makalaya ang mga Israelita mula sa pagtrabaho para sa atin?” ");
INSERT INTO tglulb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pagkatapos kinuha ni Paraon ang kaniyang karwahe at kasama niya ang kaniyang mga hukbo. ");
INSERT INTO tglulb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Isinama niya ang piniling animnaraang karwahe at ang lahat ng ibang mga karwahe ng Ehipto, ang lahat ng mga pinuno sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Pinatigas ni Yahweh ang puso ni Paraon, hari ng Ehipto, at hinabol niya ang mga Israelita. Ngayon nakaalis ang mga Israelita nang matagumpay. ");
INSERT INTO tglulb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Pero hinabol sila ng mga taga-Ehipto kasama ng kanilang mga kabayo at mga karwahe, mga nangangabayo at ang kaniyang mga hukbo. Inabutan nila ang mga Israelita na nagkakampo sa tabing dagat ng Pi Hahirot, bago ang Baal Zefon. ");
INSERT INTO tglulb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Nang malapit na si Paraon, ang mga Israelita ay tumingala at nabigla. Naglalakad ang mga taga-Ehipto patungo sa kanila at sila ay natakot. Umiyak ang mga Israelita kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Sinabi nila kay Moises, “Dahil wala na bang mapaglilibingan sa amin sa Ehipto kaya mo kami dinala sa ilang para dito mamatay? Bakit itinuring mo kami ng ganito, dinala mo kami palabas sa Ehipto? ");
INSERT INTO tglulb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Hindi ba ito ang sinabi namin sa iyo sa Ehipto? Sinabi namin sa iyo, 'Iwanan kami dito, para makapagtrabaho kami sa mga taga-Ehipto. Mas mabuti pa sa amin ang magtrabaho para sa kanila kaysa kami ay mamatay dito sa ilang.”' ");
INSERT INTO tglulb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Sinabi ni Moises sa mga tao, “Huwag kayong matakot. Manatili at tingnan ninyo ang pagliligtas ni Yahweh na ibibigay sa inyo ngayon. Dahil hindi ninyo na makikita muli ang mga taga-Ehipto na nakikita ninyo ngayon. ");
INSERT INTO tglulb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Si Yahweh ay makikipaglaban para sa inyo, at kailangan lang ninyong manatili. ");
INSERT INTO tglulb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Pagkatapos sinabi ni Yahweh kay Moises, “Bakit ikaw, Moises, patuloy na tumatawag sa akin? Sabihan mo ang mga Israelita na magpatuloy sa pagsulong. ");
INSERT INTO tglulb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Itaas mo ang iyong tungkod, iunat mo sa pamamagitan ng iyong kamay sa ibabaw ng dagat at hatiin mo ito sa dalawa, para ang bayan ng Israel ay makarating sa dagat sa tuyong lupa. ");
INSERT INTO tglulb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Tandaan mo na patitigasin ko ang puso ng mga taga-Ehipto para sila ay tugisin. Makakakuha ako ng parangal dahil kay Paraon at sa lahat ng kaniyang hukbo, mga karwahe at ang kaniyang mga nangangabayo. ");
INSERT INTO tglulb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Pagkatapos malalaman ng mga taga-Ehipto na ako ay si Yahweh at makakakuha ako ng karangalan nang dahil kay Paraon, sa kaniyang mga karwahe at sa kaniyang mga nangangabayo.” ");
INSERT INTO tglulb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ang anghel ng Diyos, ang siyang pumunta sa mga Israelita, kumilos at nagpunta sa kanilang likuran. Ang haligi ng ulap ay kumilos mula sa kanila at pumunta at tumayo sa kanilang likuran. ");
INSERT INTO tglulb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Dumating ang ulap sa pagitan ng kampo ng Ehipto at sa kampo ng Israel. Isang madilim na ulap sa mga taga-Ehipto pero inilawan naman ang gabi para sa mga Israelita. Kaya hindi nakalapit ang isang panig sa kabila buong gabi. ");
INSERT INTO tglulb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Iniunat ni Moises ang kaniyang kamay sa ibabaw ng dagat. Pinabalik ni Yahweh ang dagat sa pamamagitan ng isang malakas na hanging silangan sa buong gabing iyon at ginawang tuyong lupa. Sa ganitong paraan nahati ang tubig. ");
INSERT INTO tglulb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ang mga Israelita ay pumunta sa gitna ng dagat sa tuyong lupa. Ang tubig ay nag-anyong pader para sa kanila sa kanilang kanang kamay at sa kanilang kaliwa. ");
INSERT INTO tglulb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Tinugis sila ng mga taga-Ehipto. Pinuntahan sila sa gitna ng dagat—lahat ng mga kabayo ni Paraon, mga karwahe at mga nangangabayo. ");
INSERT INTO tglulb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Pero kinaumagahan, si Yahweh ay tumingin mula sa ibaba sa mga hukbo ng Ehipto sa pamamagitan ng haligi ng apoy at ulap. Nagdulot siya ng pagkabahala sa mga taga-Ehipto ");
INSERT INTO tglulb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ang gulong ng kanilang mga karwahe ay nabaon, at ang mga nangangabayo ay nahirapang magpatakbo. Kaya sinabi ng mga taga-Ehipto, “Tumakas na tayo mula sa Israel, dahil si Yahweh ay lumalaban para sa kanila laban sa atin. ");
INSERT INTO tglulb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Sinabi ni Yahweh kay Moises, “Iunat mo ang iyong kamay sa ibabaw ng dagat para ang tubig ay bumalik sa mga taga-Ehipto, kanilang mga karwahe at sa kanilang mga nangangabayo. ");
INSERT INTO tglulb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kaya iniunat ni Moises ang kaniyang kamay sa ibabaw ng dagat at ito ay bumalik sa dating anyo bago lumitaw ang umaga. Ang mga taga-Ehipto ay tumakas sa dagat, at dinala sila ni Yahweh sa gitna nito. ");
INSERT INTO tglulb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Bumalik ang tubig at bumalot sa mga karwahe ni Paraon, mga nangangabayo at ang lahat ng kaniyang mga hukbo na sumunod sa mga karwahe papuntang dagat. Wala ni isa ang nakaligtas. ");
INSERT INTO tglulb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Gayunman, naglakad ang mga Israelita sa tuyong lupa sa gitna ng dagat. Ang tubig ay naging isang pader para sa kanila sa kanang kamay at sa kanilang kaliwa. ");
INSERT INTO tglulb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Iniligtas ni Yahweh ang Israel sa araw na iyon sa kamay ng mga taga-Ehipto, at nakita ng Israel ang mga patay na mga taga-Ehipto sa dalampasigan. ");
INSERT INTO tglulb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Nang makita ng Israel ang kapangyarihan ni Yahweh na ginamit laban sa mga taga-Ehipto, pinarangalan ng mga tao si Yahweh, at sila ay nagtiwala kay Yahweh at sa kaniyang lingkod na si Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Pagkatapos inawit nina Moises at ng bayan ng Israel ang awiting ito para kay Yahweh. Inawit nila, “Umaawit ako kay Yahweh, dahil sa maluwalhating tagumpay; ang kabayo at ang tagasakay nito ay itinapon sa dagat. ");
INSERT INTO tglulb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Si Yahweh ang aking lakas at awitin, at siya ang aking naging kaligtasan. Ito ang aking Diyos, at siya ay aking pupurihin, Diyos ng aking ama, at siya ay aking dadakilain. ");
INSERT INTO tglulb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Si Yahweh ay isang mandirigma; Yahweh ang pangalan niya. ");
INSERT INTO tglulb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ang mga karwahe at hukbo ng Paraon, sa dagat ay kaniyang itinapon. Ang mga piniling opisyal ni Paraon, sa Dagat ng mga Tambo sila ay nalunod. ");
INSERT INTO tglulb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Sila ay tinabunan ng kailaliman; sila ay tumungo sa kailaliman na tulad ng isang bato. ");
INSERT INTO tglulb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ang iyong kanang kamay, Yahweh, ay maluwalhati sa kapangyarihan; ang iyong kanang kamay, Yahweh, ang dumurog sa mga kaaway. ");
INSERT INTO tglulb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Sa dakilang kaluwalhatian iyong ibinabagsak ang mga bumabangon laban sa iyo. Inilabas mo ang iyong poot; tinupok mo sila gaya ng pinaggapasan. ");
INSERT INTO tglulb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Sa pamamagitan ng bugso ng butas ng iyong ilong ang mga tubig ay nagtipon; ang mga dumadaloy na tubig ay tumayong matuwid na isang bunton; ang malalim na tubig ay namuo sa puso ng dagat. ");
INSERT INTO tglulb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Sinabi ng kaaway, 'Hahabol ako, mangunguna ako, ipamamahagi ko ang nasamsam ko; masisiyahan sila sa ang aking ninanais; Bubunutin ko ang aking espada; ang aking kamay ang sisira sa kanila.' ");
INSERT INTO tglulb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pero ipinaihip mo ang iyong hangin at tinakpan sila ng dagat; at sa malakas na mga tubig lumubog sila na parang tingga. ");
INSERT INTO tglulb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Sino ang katulad mo, Yahweh, sa mga diyos? Sino ang katulad mo, maluwalhati sa kabanalan, sa mga pagpupuri pinaparangalan, na gumagawa ng mga himala? ");
INSERT INTO tglulb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Iniunat mo ang iyong kanang kamay, at sila ay nilamon ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Sa iyong katapatan sa tipan pinangunahan mo ang mga tao na iyong sinagip. Sa iyong kalakasan sila ay iyong pinangunahan patungo sa banal na lugar kung saan ka naninirahan. ");
INSERT INTO tglulb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Narinig ng bayan, at sila ay nanginginig; takot ang babalot sa mga naninirahan sa Filistia. ");
INSERT INTO tglulb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Pagkatapos ang mga pinuno ng Edom ay matatakot; ang mga sundalo ng Moab ay mayayanig; lahat ng naninirahan sa Canaan ay maglalaho. ");
INSERT INTO tglulb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ang kilabot at pangamba ay mapapasakanila. Dahil sa kapangyarihan ng iyong bisig, sila ay hindi iimik na parang bato hanggang sa makaraan ang iyong bayan, Yahweh— hanggang sa makaraan ang sinagip mong bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Dadalhin mo sila at itatanim sila sa bundok na iyong pinamana, ang lugar, Yahweh, na iyong ginawa para manirahan, ang santuwaryo, aming Panginoon, na itinayo ng iyong mga kamay. ");
INSERT INTO tglulb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Maghahari si Yahweh sa magpakailanman pa man.” ");
INSERT INTO tglulb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Dahil lumakad ang mga kabayo ni Paraon kasama ng kaniyang mga karwahe at mga mangangabayo sa dagat. Dinala pabalik ni Yahweh ang mga tubig ng dagat sa kanila. Pero ang mga Israelita ay naglakad sa gitna ng dagat sa mga tuyong lupa. ");
INSERT INTO tglulb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Si Miriam, ang babaeng propeta, na kapatid na babae ni Aaron, ay dumampot ng tamburin, at lumabas ang lahat ng mga kababaihan na may mga tamburin, sabay na sumasayaw kasama niya. ");
INSERT INTO tglulb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Inawit ni Miriam sa kanila: “Umawit kay Yahweh, dahil siya ay maluwalhating nagtagumpay. Itinapon niya sa dagat ang kabayo at ang kaniyang mangangabayo.” ");
INSERT INTO tglulb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Pagkatapos pinangunahan ni Moises ang Israel pasulong mula dagat ng mga Tambo. Lumabas sila sa ilang ng Shur. Naglakbay sila ng tatlong araw sa loob ng ilang at walang nahanap na tubig. ");
INSERT INTO tglulb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Pagkatapos nakarating sila sa Mara, pero hindi nila mainom ang tubig doon dahil mapait ito. Kaya tinawag nilang Mara ang lugar na iyon. ");
INSERT INTO tglulb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kaya nagreklamo ang mga tao kay Moises at sinabing, “Ano ang aming iinumin?.” ");
INSERT INTO tglulb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Umiyak si Moises kay Yahweh at may ipinakitang puno si Yahweh sa kaniya. Hinagis ito ni Moises sa tubig at naging matamis na maiinom ang tubig. Sa lugar na iyon nagbigay si Yahweh sa kanila ng mahigpit na kautusan at doon din niya sila sinubukan. ");
INSERT INTO tglulb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Sinabi niya, “Kung papakinggan ninyong mabuti ang tinig ni Yahweh na inyong Diyos, at gagawin kung ano ang tama sa aking mga mata, at kung makikinig kayo sa mga kautusan ko at susundin ang lahat ng mga batas ko—hindi ako maglalagay sa inyo ng anumang mga sakit na inilagay ko sa mga taga-Ehipto, dahil ako ay si Yahweh na nagpapagaling sa inyo.” ");
INSERT INTO tglulb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Pagkatapos dumating ang mga tao sa Elim, kung saan mayroong labing-dalawang bukal ng tubig at pitumpung puno ng palma. Nagkampo sila doon sa may tubig. ");
INSERT INTO tglulb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Naglakbay ang mga tao mula sa Elim, at ang lahat ng komunidad ng mga Israelita ay nakarating sa ilang ng Sin, na nasa gitna ng Elim at Sinai, sa ikalabinlimang araw ng ikalawang buwan pagkatapos ng kanilang pag-alis sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ang buong komunidad ng mga Israelita ay nagreklamo laban kina Moises at Aaron sa ilang. ");
INSERT INTO tglulb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Sinabi sa kanila ng mga Israelita, “Kung namatay na lang sana kami sa kamay ni Yahweh sa lupain ng Ehipto nang kami ay nakaupo sa tabi ng mga palayok ng karne at kumakain ng tinapay hanggang sa mabusog. Pagkat dinala ninyo kami palabas dito sa ilang para patayin sa gutom ang aming buong komunidad.” ");
INSERT INTO tglulb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Pagkatapos sinabi ni Yahweh kay Moises, “Magpapaulan ako ng tinapay mula sa langit para sa inyo. Ang mga tao ay lalabas at magtitipon ng pang isang araw na bahagi sa bawat araw para masubukan ko sila para makita kung sila ay lalakad o hindi sa aking batas. ");
INSERT INTO tglulb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mangyayari na sa ikaanim na araw, na magtitipon sila ng makalawang dami ng kung ano ang tinipon nila sa bawat naunang araw, at lulutuin nila kung ano ang dala nila.” ");
INSERT INTO tglulb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Pagkatapos ay sinabi nina Moises at Aaron sa lahat ng bayan ng Israel, “Sa gabi ay malalaman ninyong si Yahweh ang siyang nagdala sa inyo palabas mula sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Sa umaga ay makikita ninyo ang kaluwalhatian ni Yahweh, dahil naririnig niya ang inyong pagrereklamo laban sa kaniya. Sino ba kami para kayo ay magreklamo laban sa amin?” ");
INSERT INTO tglulb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Sinabi rin ni Moises, “Malalaman ninyo ito kapag binigyan kayo ni Yahweh ng karne sa gabi at tinapay sa umaga na sagana—dahil narinig niya ang mga reklamo na sinabi ninyo laban sa kanya. Sino ba si Aaron at ako? Ang inyong mga reklamo ay hindi laban sa amin; ang mga iyon ay laban kay Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Sinabi ni Moises kay Aaron, “Sabihin mo sa lahat ng komunidad ng bayan ng Israel, 'Lumapit kayo kay Yahweh, dahil narinig niya ang inyong mga reklamo.'” ");
INSERT INTO tglulb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Nangyari na habang nagsasalita si Aaron sa buong komunidad ng bayan ng Israel, tumingin sila sa dako ng ilang, at pagmasdan, ang kaluwalhatian ni Yahweh ay lumitaw sa ulap. ");
INSERT INTO tglulb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Pagkatapos sinabi ni Yahweh kay Moises, ");
INSERT INTO tglulb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Narinig ko ang mga reklamo ng bayan ng Israel. Kausapin mo sila at sabihin, 'Sa gabi ay kakain kayo ng karne, at sa umaga ay mabubusog kayo ng tinapay. Pagkatapos malalaman ninyong ako ay si Yahweh, na inyong Diyos.'” ");
INSERT INTO tglulb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nangyari sa gabi na may dumating na mga pugo at natabunan ang kampo. Sa umaga ang hamog ay nalatag sa palibot ng kampo. ");
INSERT INTO tglulb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Pagkawala ng hamog, doon sa ibabaw ng ilang ay may mga manipis na mumunting piraso na parang namuong hamog sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Nang makita iyon ng bayan ng Israel, sinabi nila sa isa't isa, “Ano ito?” Hindi nila alam kung ano iyon. Sinabi ni Moises sa kanila, “Iyan ang tinapay na bigay ni Yahweh sa inyo para kainin. ");
INSERT INTO tglulb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ito ang utos na ibinigay ni Yahweh sa inyo: 'Kayo ay dapat magtipon, bawat isa sa inyo, ng dami na kailangan ninyong kainin, isang omer sa bawat tao mula sa bilang ng inyong mga tao. Ganito ninyo titipunin iyon: Magtipon ng tama lang para kainin ng bawat taong naninirahan sa inyong tolda.'” ");
INSERT INTO tglulb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ginawa iyon ng bayan ng Israel. Ang ilan ay nagtipon ng mas marami, ang ilan ay nagtipon ng mas kaunti. ");
INSERT INTO tglulb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nang sukatin nila iyon sa sukat ng omer, ang mga nagtipon ng mas marami ay walang anumang natira, ang mga nagtipon ng mas kaunti ay hindi nagkulang. Bawat tao ay nagtipon ng tama lamang para mapunan ang kanilang pangangailangan. ");
INSERT INTO tglulb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Pagkatapos sinabi ni Moises sa kanila, “Walang isa sa inyo ang dapat magtira ng anuman niyon hanggang umaga. ");
INSERT INTO tglulb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","“Pero hindi sila nakinig kay Moises. Ang ilan sa kanila ay nagtira ng kaunti nito hanggang umaga, pero ito ay inuod at bumaho. Kaya nagalit sa kanila si Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Sila ay nagtipon niyon kada umaga. Bawat tao ay nagtipon ng tama lang kainin para sa araw na iyon. Nang uminit ang araw, ito ay natunaw. ");
INSERT INTO tglulb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Nangyari na sa ikaanim na araw nagtipon sila ng dobleng dami ng tinapay, dalawang omer para sa bawat tao. Lahat ng mga pinuno ng komunidad ay pumunta at sinabi ito kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Sinabi niya sa kanila, “Ito ang sinabi ni Yahweh: 'Bukas ay isang taimtim na pamamahinga, isang banal na Araw ng Pamamahinga para sa karangalan ni Yahweh. Maghurno kayo ng gusto ninyong hurnuin at maglaga ng gusto ninyong ilaga. Ang lahat nang matira, itabi ninyo para sa inyong mga sarili hanggang umaga.'” ");
INSERT INTO tglulb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kaya itinabi nila ito hanggang umaga, katulad ng tagubilin ni Moises. Ito ay hindi bumaho ni nagkaroon ng anumang uod. ");
INSERT INTO tglulb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Sinabi ni Moises, “Kainin ang pagkaing ito ngayon, pagkat ngayon ay isang araw na inilaan bilang Araw ng Pamamahinga para parangalan si Yahweh. Ngayon hindi kayo makakahanap nito sa mga bukid. ");
INSERT INTO tglulb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Magtitipon kayo nito sa loob ng anim na araw, pero ang ikapitong araw ay Araw ng Pamamahinga. Sa Araw ng Pamamahinga ay walang manna.” ");
INSERT INTO tglulb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Nangyari na sa ikapitong araw may ilan sa mga tao ang lumabas para magtipon ng manna, pero wala silang nahanap. ");
INSERT INTO tglulb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Pagkatapos sinabi ni Yahweh kay Moises, “Gaano katagal kayong tatangging sundin ang aking mga kautusan at mga batas? ");
INSERT INTO tglulb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Tingnan ninyo, Ako, si Yahweh ang nagbigay ng Araw ng Pamamahinga sa inyo. Kaya sa ikaanim na araw ay binibigyan ko kayo ng tinapay para sa dalawang araw. Bawat isa sa inyo ay dapat manatili sa kanyang sariling lugar; walang dapat lumabas mula sa kaniyang lugar sa ikapitong araw.” ");
INSERT INTO tglulb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kaya nagpahinga ang mga tao sa ikapitong araw. ");
INSERT INTO tglulb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Tinawag ng mga tao ng Israel ang pagkaing iyon na “manna.” Ito ay maputi tulad ng buto ng kulantro at ang lasa ay parang apa na ginawang may pulot. ");
INSERT INTO tglulb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Sinabi ni Moises, “Ito ang inutos ni Yahweh: 'Hayaang itago ang isang omer na manna para sa kabuuan ng salinlahi ng inyong bayan para ang inyong mga kaapu-apuhan ay maaring makita ang tinapay na pinakain ko sa inyo sa ilang, matapos na ilabas ko kayo mula sa lupain ng Ehipto.'” ");
INSERT INTO tglulb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Sinabi ni Moises kay Aaron, “Kumuha ka ng palayok at maglagay ng isang omer ng manna sa loob nito. Panatilihin ito sa harap ni Yahweh para itago para sa buong salinlahi ng bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Katulad ng inutos ni Yahweh kay Moises, itinago iyon ni Aaron katabi ng mga kautusang tipan sa loob ng kaban. ");
INSERT INTO tglulb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Kumain ng manna ang bayan ng Israel sa loob ng apatnapung taon hanggang sa makarating sila sa lupaing may naninirahan. Kumain sila nito hanggang sa makarating sila sa mga hangganan ng lupain ng Canaan. ");
INSERT INTO tglulb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ngayon ang omer ay ikasampung bahagi ng epa. ");
INSERT INTO tglulb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Naglakbay ang buong komunidad ng mga Israelita mula sa ilang ng Sin, ayon sa mga tagubilin ni Yahweh. Nagkampo sila sa Rephidim, pero walang tubig na maiinom para sa mga tao. ");
INSERT INTO tglulb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kaya sinisi ng mga tao si Moises dahil sa kanilang kalagayan at sinabing, “Bigyan mo kami ng tubig na maiinom.” Sinabi ni Moises, “Bakit kayo makikipagtalo sa akin?” Bakit sinusubok ninyo si Yahweh?” ");
INSERT INTO tglulb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Labis na nauuhaw ang mga tao, at nagreklamo laban kay Moises. Sinabi nila, “Bakit dinala mo kami palabas sa Ehipto? Para patayin kami at ang aming mga anak pati mga baka sa pagkauhaw?” ");
INSERT INTO tglulb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kaya dumaing si Moises kay Yahweh, “Ano ba ang dapat kong gawin sa mga taong ito? Halos handa na silang batuhin ako.” ");
INSERT INTO tglulb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Sinabi ni Yahweh kay Moises, “Mauna ka sa mga tao at magdala ka ng ilan sa mga nakatatanda ng Israel. Dalhin mo ang tungkod na inihampas mo sa ilog at umalis ka. ");
INSERT INTO tglulb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Tatayo ako sa harapan mo doon sa ibabaw ng bato sa Horeb, at papaluin mo ang bato. Lalabas ang tubig mula dito para inumin ng mga tao. Pagkatapos ginawa ito ni Moises sa paningin ng mga nakatatanda ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Tinawag niya ang lugar na iyon na Massah at Meribah dahil sa pagrereklamo ng mga Israelita at dahil sinubukan nila ang Diyos sa pamamagitan ng pagsabing, “Kasama ba natin si Yahweh o hindi?” ");
INSERT INTO tglulb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Pagkatapos dumating at nilusob ng isang hukbo ng mga Amalekita ang Israel sa Rephidim. ");
INSERT INTO tglulb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Kaya sinabi ni Moises kay Josue, “Pumili ka ng ilan sa mga lalaki at umalis ka. Labanan mo si Amalek. Tatayo ako bukas sa ibabaw ng burol na hawak ang tungkod ng Diyos sa aking kamay.” ");
INSERT INTO tglulb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kaya nakipaglaban si Josue sa Amalek ayon sa tagubilin ni Moises sa kaniya, habang sina Moises, Aaron at Hur ay umakyat sa ibabaw ng burol. ");
INSERT INTO tglulb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Nananalo ang mga Israelita, habang itinataas ni Moises ang kaniyang mga kamay, kapag ipinagpapahinga niya ang kaniyang mga kamay, nagsisimulang manalo ang mga Amalek. ");
INSERT INTO tglulb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Nang bumigat na ang mga kamay ni Moises, kumuha sina Aaron at Hur ng bato at inilagay ito sa ilalim niya para makaupo siya. Sa parehong pagkakataon, itinaas ni Aaron at Hur ang mga kamay ni Moises, isang tao ang nasa tabi niya at ang isa naman ay nasa kabilang banda niya. Kaya nanatiling nakataas ang mga kamay ni Moises hanggang sa palubog na ang araw. ");
INSERT INTO tglulb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kaya natalo ni Josue ang mga Amalekita sa pamamagitan ng espada. ");
INSERT INTO tglulb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Sinabi ni Yahweh kay Moises, “Isulat mo ito sa isang libro at basahin mo na naririnig ni Josue dahil ganap kong tatanggalin ang alaala ng Amalek mula sa ilalim ng kalangitan.” ");
INSERT INTO tglulb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Pagkatapos gumawa si Moises ng altar at tinawag niya itong “Si Yahweh ang aking bandila.” ");
INSERT INTO tglulb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ginawa niya ito, dahil sinabi niya, “Pinangako ni Yahweh na makikipaglaban siya kay Amalek mula sa mga salinlahi hanggang sa mga susunod pang salinlahi.” ");
INSERT INTO tglulb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","18 Narinig ni Jetro na pari ng Midian, na biyenan na lalaki ni Moises ang lahat ng ginawa ng Diyos kay Moises at sa mga Israelita na kaniyang bayan. Narinig niya na dinala ni Yahweh palabas sa Ehipto ang Israel. ");
INSERT INTO tglulb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Kinuha ni Jetro na biyenan ni Moises si Zippora na asawa ni Moises, matapos niyang pabalikin sa kanilang tahanan. ");
INSERT INTO tglulb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","At ang kaniyang dalawang anak na lalaki; Ang Pangalan ng isa niyang anak ay si Gersom, dahil sinabi ni Moises, “Naging dayuhan ako sa isang dayuhang lupain.” ");
INSERT INTO tglulb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ang isa niyang anak ay pinangalanang Eliezer, dahil sinabi ni Moises, “Ang Diyos ng aking ninuno ay aking saklolo. Niligtas niya ako mula sa espada ni Paraon.” ");
INSERT INTO tglulb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Dumating si Jetro, na biyenan ni Moises, kasama ang mga anak na lalaki at asawa ni Moises sa ilang kung saan sila nagkampo sa bundok ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Sinabi niya kay Moises, “Ako na iyong biyenan na si Jetro, kasama ang iyong asawa at ang kaniyang dalawang anak na lalaki ay pupunta sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Lumabas si Moises para salubungin ang kaniyang biyenan na lalaki, yumuko at hinalikan siya. Nagtanungan sila tungkol sa kapakanan ng isa't-isa at pagkatapos pumasok sila sa tolda. ");
INSERT INTO tglulb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Isinalaysay ni Moises sa kaniyang biyenan na lalaki ang lahat ng ginawa ni Yahweh kay Paraon at sa mga taga-Ehipto alang-alang sa kapakanan ng Israel, tungkol sa lahat ng mga paghihirap na dumating sa kanilang paglalakbay, at kung paano sila niligtas ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nagalak si Jetro sa kabila ng lahat ng mabuting nagawa ni Yahweh para sa Israel, dahil niligtas sila ni Yahweh mula sa kamay ng mga taga-Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Sinabi ni Jetro, “Purihin nawa si Yahweh, dahil niligtas niya kayo mula sa kamay ng mga taga-Ehipto at mula sa kamay ng Paraon, at pinalaya niya ang bayan mula sa kamay ng mga taga-Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ngayon alam ko na si Yahweh ay dakila kaysa lahat ng mga diyos, dahil niligtas ng Diyos ang kaniyang bayan nang pinagmalupitan ng mga taga-Ehipto ang mga Israelita. ");
INSERT INTO tglulb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Nagdala si Jetro, na biyenan na lalaki ni Moises, ng sinunog na handog at alay para sa Diyos. Nagpunta si Aaron at lahat ng mga nakatatanda ng Israel para kumain kasama ang biyenan na lalaki ni Moises sa harap ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kinabukasan umupo si Moises para hatulan ang mga tao. Tumayo ang mga tao sa palibot ni Moises, mula umaga hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Nang nakita ni Jetro ang lahat ng ginawa ni Moises para sa bayan, sinabi niya, “Ano ba itong ginawa mo sa bayan? Bakit nauupo kang mag-isa at ang lahat ng tao ay nakatayo na nakapalibot sa iyo mula umaga hanggang gabi?” ");
INSERT INTO tglulb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Sinabi ni Moises sa kaniyang biyenan na lalaki, “Lumapit ang mga tao sa akin para hingin ang direksyon ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Pumupunta sila sa akin kapag nagtatalo sila. Hinahatulan ko ang pagitan ng bawat isa, at itinuturo ko sa kanila ang mga kautusan at mga batas ng Diyos.” ");
INSERT INTO tglulb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Sinabi ni Jetro kay Moises, “Hindi mabuti ang iyong ginagawa. ");
INSERT INTO tglulb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tiyak na manghihina ka, ikaw at ang lahat ng taong pumupunta sa iyo, dahil ang pasanin na ito ay labis na napakabigat para sa iyo. Hindi mo ito kayang gawin sa pamamagitan ng iyong sarili. ");
INSERT INTO tglulb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Makinig ka sa akin. Bibigyan kita ng payo, at sumaiyo ang Diyos, dahil ikaw ang kinatawan ng tao sa Diyos, at ikaw ang nagdadala ng kanilang mga pagtatalo sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Dapat mong ituro sa kanila ang kaniyang mga kautusan at mga batas. Dapat mong ipakita sa kanila ang daang nararapat lakaran at gawain ang nararapat. ");
INSERT INTO tglulb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","At saka, dapat pumili ka ng mga lalaking bihasa mula sa lahat ng mga tao, mga lalaking may takot sa Diyos, mga lalaking mapagpatotoo na napopoot sa hindi makatarungan. Dapat ilagay mo sila sa mga tao para maging mga pinuno na nangangasiwa sa libu-libo, daan-daan, lima-limampu at sampu-sampo. ");
INSERT INTO tglulb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Hahatulan nila ang mga tao sa lahat ng kaugaliang pamamaraan na mga kaso, pero dadalhin nila ang mga mabibigat na mga kaso sa iyo. Sila na ang hahatol sa mga maliliit na mga kaso. Sa ganyang paraan, magiging magaan para sa iyo, at dadalhin nila ang pasanin kasama mo. ");
INSERT INTO tglulb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kung gagawin mo ito, at kung inatasan ka ng Diyos na gawin ito, hindi ka mahihirapan at makakauwi na nasisiyahan ang bayan sa kanilang tahanan.” ");
INSERT INTO tglulb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Kaya nakinig si Moises sa mga salita ng kaniyang biyenan na lalaki at ginawa ang lahat ng kaniyang sinabi. ");
INSERT INTO tglulb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Pinili ni Moises ang mga lalaking bihasa mula sa lahat ng Israel at ginawa silang mga pinuno ng mga taong, tagapangasiwa sa libu-libo, daan-daan, lima-limampu, at sampu-sampo. ");
INSERT INTO tglulb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Hinatulan nila ang mga tao sa mga karaniwang pangyayari. Dinala nila kay Moises ang mabigat na mga kaso, pero sila na mismo ang humahatol sa mga maliliit na mga kaso. ");
INSERT INTO tglulb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Pagkatapos hinayaan ni Moises na umalis ang kaniyang biyenan na lalaki, at bumalik si Jetro sa kaniyang sariling lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Sa ikatlong buwan, pagkatapos lumabas ang bayan ng Israel mula sa lupain ng Ehipto, sa parehong araw, nakarating sila sa ilang ng Sinai. ");
INSERT INTO tglulb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Pagkatapos nilang lisanin ang Rephidim at pumunta sa ilang ng Sinai, nagkampo sila sa ilang sa harapan ng bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Umakyat si Moises sa Diyos. Tinawag siya ni Yahweh mula sa bundok at sinabi, “Kailangan mong sabihin sa bahay ni Jacob, sa bayan ng Israel: ");
INSERT INTO tglulb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Nakita mo ang aking ginawa sa mga taga-Ehipto, kung paano ko kayo inakay sa pakpak ng agila at dinala kayo para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ngayon pagkatapos, kung susundin at pakikinggan ninyo ang aking tinig at iingatan ang aking kasunduan, kung gayon, magiging katangi-tanging pag-aari kita mula sa lahat ng mga tao, dahil ang buong daigdig ay akin. ");
INSERT INTO tglulb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ikaw ay magiging kaharian ng mga pari at isang banal na bayan para sa akin. Ito ang mga salitang dapat mong sabihin sa bayan ng Israel.” ");
INSERT INTO tglulb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kaya bumaba si Moises at ipinatawag ang mga nakatatanda ng Israel. Itinakda niya sa kanila ang lahat ng salita ni Yahweh na inutos sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Lahat ng tao ay magkakasabay na sumagot at sinabing, “Gagawin namin ang lahat ng sinabi ni Yahweh.” Pagkatapos ipinarating ni Moises ang mga salita ng mga tao kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Sinabi ni Yahweh kay Moises, “Lalapit ako sa iyo sa isang makapal na ulap para maaaring marinig ng mga tao kapag ako ay nakikipag-usap sa iyo at maaari ring maniwala sila sa iyo habang panahon.” Pagkatapos, inilahad ni Moises ang salita ng mga tao kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Sinabi ni Yahweh kay Moises, “Puntahan mo ang mga tao. Ngayon at bukas kailangan mong ihandog sila sa akin at hugasan nila ang kanilang mga damit. ");
INSERT INTO tglulb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Maging handa sa ikatlong araw, dahil sa ikatlong araw Ako, si Yahweh ay bababa sa Bundok Sinai. ");
INSERT INTO tglulb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Dapat kang maglagay ng hangganan sa palibot ng bundok para sa mga tao. Sabihin sa kanila, ''Mag-ingat na hindi sila aakyat ng bundok o hahawakan ang hangganan. Siguradong mailalagay sa kamatayan ang sinumang hahawak sa bundok.' ");
INSERT INTO tglulb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Walang sinumang hahawak sa ganoong tao. Kundi, kailangan siyang batuhin o panain. Kahit ito man ay isang tao o isang hayop, dapat siyang mailagay sa kamatayan. Kapag tumunog na ang trumpeta ng isang mahabang tunog maaari na silang lumapit pataas sa paanan ng bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Pagkatapos bumaba si Moises mula sa bundok patungo sa mga tao. Inihandog niya ang mga tao kay Yahweh, at hinugasan nila ang kanilang mga damit. ");
INSERT INTO tglulb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Sinabi niya sa mga tao, “Maging handa sa ikatlong araw; huwag kayong lalapit sa inyong mga asawa.” ");
INSERT INTO tglulb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Sa ikatlong araw, nang umagang iyon, mayroon kulog at kidlat at isang makapal na ulap sa itaas ng bundok at ang tunog ng isang napakalakas na trumpeta. Nanginig ang lahat ng tao na nasa kampo. ");
INSERT INTO tglulb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Dinala ni Moises palabas sa kampo ang lahat ng tao para makipagkita sa Diyos at nakatayo sila sa paanan ng bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Lubusang nababalutan ng usok ang Bundok ng Sinai dahil kay Yahweh na bumaba doon na may apoy at usok. Pumaitaas ang usok katulad ng usok ng isang pugon at marahas na nabulabog ang buong bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Nang palakas ng palakas ang tunog ng trumpeta, nagsalita si Moises, at sinagot siya ng Diyos sa isang boses. ");
INSERT INTO tglulb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Bumaba si Yahweh sa Bundok ng Sinai, mula sa tuktok ng bundok at kaniyang tinawag si Moises sa tuktok. Kaya umakyat si Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Sinabi ni Yahweh kay Moises, “Bumaba ka at balaan mo ang mga tao na huwag sumuway sa akin para tumingin, o marami sa kanila ang mamamatay. ");
INSERT INTO tglulb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hayaan ang mga pari na lumapit din sa akin at itakda ang kanilang sarili na humiwalay, ihanda ang kanilang sarili sa aking pagdating para hindi ko sila salakayin.” ");
INSERT INTO tglulb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Sinabi ni Moises kay Yahweh, “Hindi makakaakyat ang mga tao sa bundok, ito ang inutos mo sa amin: 'Maglagay ng mga hangganan sa palibot ng bundok at ihandog ito kay Yahweh.''' ");
INSERT INTO tglulb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Sinabi ni Yahweh sa kaniya, “Lakad ka, bumaba sa bundok, at isama mo paakyat si Aaron na kasama mo, pero huwag mong payagan ang mga pari at ang mga tao na tanggalin ang bakod para pumunta sa akin, kung hindi sasalakayin ko sila. ");
INSERT INTO tglulb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kaya bumaba si Moises sa mga tao at nakipag-usap sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Sinabi ng Diyos ang mga salitang ito: ");
INSERT INTO tglulb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ako ay si Yahweh, inyong Diyos, ang naglabas sa inyo mula sa lupain ng Ehipto, mula sa labas ng bahay ng pagkaalipin. ");
INSERT INTO tglulb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Dapat wala kang ibang diyos sa harapan ko. ");
INSERT INTO tglulb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Huwag dapat kayong gumawa para sa sarili ninyo ng isang inukit na larawan ni kahalintulad ng anumang bagay na nasa itaas ng langit, o sa lupa na nasa ilalim, o sa tubig na nasa ibaba. ");
INSERT INTO tglulb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Huwag dapat kayong yuyukod sa kanila o sambahin sila, dahil Ako, si Yahweh na inyong Diyos, ay selosong Diyos. Paparusahan ko ang kasamaan ng mga ninuno sa pamamagitan ng pagpapadala ng kaparusahan sa mga kaapu-apuhan, patungo sa ikatlo at ikaapat na salinlahi sa mga galit sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pero magpapakita ako ng katapatan sa tipan sa libu-libong mga nagmamahal sa akin at susunod sa aking mga utos. ");
INSERT INTO tglulb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Hindi ninyo dapat kunin ang pangalan ko, si Yahweh ang inyong Diyos, sa walang kabuluhan, dahil hindi ko ituturing na walang pagkakakasala ang sinumang kukuha ng pangalan ko sa walang kabuluhan. ");
INSERT INTO tglulb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Alalahanin ninyo ang Araw ng Pamamahinga, ihandog ninyo ito sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Dapat magtrabaho kayo at gawin ang lahat ng gawain sa loob ng anim na araw. ");
INSERT INTO tglulb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Pero ang ikapitong araw, ay isang Araw ng Pamamahinga para sa akin, si Yahweh ang inyong Diyos. Dito dapat walang gagawa ng anumang gawain, ikaw, ni ang iyong anak na lalaki, ni ang iyong anak na babae, ni iyong lalaking lingkod, ni iyong babaeng lingkod, ni iyong baka, ni ang dayuhan na nasa loob ng iyong mga tarangkahan. ");
INSERT INTO tglulb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Dahil sa ikaanim na araw Ako, si Yahweh, ang lumikha ng langit, lupa at dagat at lahat ng bagay na nasa loob nito at nagpahinga sa ikapitong araw. Kaya nga Ako, si Yahweh, ay pinagpala ang Araw ng Pamamahinga at inihandog ito sa aking sarili. ");
INSERT INTO tglulb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Igalang ninyo ang inyong ama at inyong ina, para maaari kang manirahanng mahabang panahon sa lupain na ibibigay ko sa inyo Ako, si Yahweh, ang inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Hindi kayo dapat pumatay ng sinuman. ");
INSERT INTO tglulb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Hindi kayo dapat mangalunya. ");
INSERT INTO tglulb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Hindi kayo dapat magnakaw mula kaninuman. ");
INSERT INTO tglulb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Hindi kayo dapat magbigay ng maling patotoo laban sa iyong kapwa. ");
INSERT INTO tglulb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Hindi ninyo dapat kainggitan ang bahay ng iyong kapwa; hindi ninyo dapat kainggitan ang asawa ng iyong kapwa, ang kaniyang lingkod na lalaki, ang kaniyang lingkod na babae, ang kaniyang baka, kaniyang asno o anumang bagay na pag-aari ng kapwa mo.” ");
INSERT INTO tglulb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nakita ng mga tao ang pagkulog at ang pagkidlat at narinig ang tunog ng trumpeta at nakitang umuusok ang bundok. Nang makita ito ng mga tao, nanginig sila at tumayo sa malayo. ");
INSERT INTO tglulb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Sinabi nila kay Moises, “Makipag-usap ka sa amin at kami'y makikinig; pero huwag mong payagan makipag- usap sa amin ang Diyos, o lahat kami ay mamamatay.” ");
INSERT INTO tglulb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Sinabi ni Moises sa mga tao, “Huwag kayong matakot, dahil bumaba ang Diyos para kayo ay subukin para ang karangalan na nasa kaniya ay mapasainyo at para hindi kayo magkasala.” ");
INSERT INTO tglulb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Kaya ang mga tao ay tumayo sa malayo at lumapit si Moises tungo sa makapal na kadiliman kung saan naroon ang Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Sinabi ni Yahweh kay Moises, “Ito ang sasabihin mo sa mga Israelita: 'Nakita mo na nakipag-usap ako sa iyo mula sa langit. ");
INSERT INTO tglulb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Huwag kang gagawa para sa sarili mo ng anumang mga diyos kasama ko, mga diyos ng pilak o diyos ng ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kailangan gumawa ka ng isang makalupang altar para sa akin at kailangang ihain mo itong mga handog na susunugin, mga handog ng pagtipon-tipon, tupa at mga baka. Sa bawat lugar na kung saan pararangalan ang pangalan ko, pupuntahan at pagpapalain kita. ");
INSERT INTO tglulb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kung igagawa mo ako ng isang altar mula sa bato, huwag mong itatayo mula sa hinati na mga bato, kapag ginamit mo ang iyong mga kasangkapan para dito, dinumihan mo ito. ");
INSERT INTO tglulb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Huwag kang aakyat sa mga baitang patungo sa aking altar; ito ay hahadlang sa iyo mula sa paglantad ng pribadong bahagi ng iyong katawan.'” ");
INSERT INTO tglulb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ngayon ito ang mga kautusan na dapat mong igawad sa harapan nila: ");
INSERT INTO tglulb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kung bibili ka ng isang lingkod na Hebreo, maninilbilhan siya sa iyo sa loob ng anim na taon at sa ikapitong taon makakaalis siya nang malaya at walang babayaran na anumang bagay. ");
INSERT INTO tglulb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kung dumating siyang mag-isa, aalis siyang malaya mag-isa; kung siya ay may asawa, aalis kasama niyang malaya ang kaniyang asawa. ");
INSERT INTO tglulb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kung ang kaniyang amo ang siyang nagbigay ng asawa para sa kaniya at nagkaanak sila ng mga lalaki o mga babae, ang asawa at ang kaniyang mga anak ay pag-aari ng kaniyang amo at dapat umalis siyang malaya mag-isa. ");
INSERT INTO tglulb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Pero kung malinaw na sinasabi ng lingkod, “Mahal ko ang aking amo, aking asawa at aking mga anak; hindi ako aalis na malaya,” ");
INSERT INTO tglulb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","pagkatapos dadalhin siya ng kaniyang amo sa Diyos. Dadalhin siya ng kaniyang amo sa pintuan o sa haligi ng pintuan at kailangang butasan ang kaniyang tainga ng kaniyang amo gamit ang isang pambutas. Pagkatapos ang lingkod ay maninilbihan sa kaniya ng buong buhay niya. ");
INSERT INTO tglulb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Kung ipinagbili ng isang lalaki ang kaniyang anak na babae na maging lingkod na babae, hindi siya makakaalis na malaya gaya ng mga lingkod na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kung hindi malulugod ang kaniyang amo, na siyang nagtalaga para sa kaniyang sarili, kinakailangan na ipatubos niya siya. Wala siyang karapatan na ipagbili ito sa mga taong dayuhan. Siya ay walang ganoong karapatan, yamang siya ay tinatrato niya ng pandaraya. ");
INSERT INTO tglulb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kung itatalaga siya ng kaniyang amo bilang asawa para sa kaniyang anak na lalaki, dapat ituring niya siya na parang anak niya rin na babae. ");
INSERT INTO tglulb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kung kukuha ng isa pang asawa ang amo para sa kaniyang sarili, hindi niya dapat bawasan ang kaniyang pagkain, damit o ang kaniyang karapatan bilang asawa. ");
INSERT INTO tglulb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Pero kung hindi niya maibibigay ang tatlong bagay na ito para sa kaniya, makakaalis siyang malaya at walang babayaran na anumang pera. ");
INSERT INTO tglulb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Sinumang manakit ng isang tao at ito ay namatay, ang taong iyon ay siguraduhing malalagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kung hindi ito ginawa ng tao na may paghahanda, sa halip hindi ito sinadya, pipili ako ng lugar kung saan maaari siyang tumakas. ");
INSERT INTO tglulb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Kung ang isang tao ay sinadyang lusubin ang kaniyang kapitbahay para patayin siya sa mapanlinlang, pagkatapos dapat mo siyang kunin, kahit kung siya ay nasa altar ng Diyos, kaya maaari siyang mamatay. ");
INSERT INTO tglulb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Sinumang manakit sa kaniyang ama o ina ay dapat siguradong malagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Sinumang dumukot ng isang tao at ito ay kaniyang ipinagbili, o ang tao ay natagpuan sa kaniyang pangangalaga, ang taong dumukot ay dapat siguradong malagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Sinumang sumpain ang kaniyang ama o kaniyang ina ay dapat siguradong malagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Kung mag-aaway ang mga lalaki at may isang taong manakit ng iba tao na gamit ang bato o ang kaniyang kamao, at ang taong iyon ay hindi namatay, pero nanatiling nakahiga; ");
INSERT INTO tglulb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","pagkatapos kung ito'y gumaling na at maaring makalakad gamit ang kaniyang tungkod, ang taong nanakit sa kaniya ay dapat magbayad sa nasayang nitong panahon; dapat din itong magbayad para sa kaniyang ganap na gagaling. Pero ang taong iyon ay mapapawalang-sala. ");
INSERT INTO tglulb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Kung sinaktan ng isang tao ang kaniyang lingkod na lalaki o ang kaniyang lingkod na babae gamit ang kaniyang tungkod, at kung ang lingkod ay namatay dahil sa pagkakapalo, ang taong iyon ay dapat siguradong maparusahan. ");
INSERT INTO tglulb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Gayunpaman, kung ang lingkod ay nabuhay ng isang araw o dalawa, ang amo ay hindi na dapat maparusahan, dahil siya rin ang magdurusa sa kawalan ng lingkod. ");
INSERT INTO tglulb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Kung nag-aaway ang mga lalaki at makasakit ng isang babaeng buntis at nakunan siya, pero wala nang ibang sugat sa kaniya, pagkatapos ang taong salarin ay dapat magmulta; kung may mga hinihingi ang asawa ng babae mula sa kaniya, dapat siyang magbayad ayon sa napagpasyahan ng mga hukom. ");
INSERT INTO tglulb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero kung mayroong malubhang sugat, pagkatapos kailangan mong magbigay ng buhay para sa buhay, ");
INSERT INTO tglulb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mata para sa mata, ngipin para sa ngipin, kamay para sa kamay, paa para sa paa, ");
INSERT INTO tglulb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","paso para sa paso, sugat para sa sugat o pasa para sa pasa. ");
INSERT INTO tglulb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Kung suntukin ng isang lalaki ang mata ng kaniyang lingkod na lalaki o lingkod na babae at nasira ito, dapat palayain niya ang lingkod katumbas para sa kaniyang mata. ");
INSERT INTO tglulb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kung suntukin niya at nabunutan ng isang ngipin ang kaniyang lingkod na lalaki o lingkod na babae, dapat palayain niya ang lingkod bilang bayad para sa ngipin. ");
INSERT INTO tglulb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Kung suwagin ng baka ang isang lalaki o isang babae at namatay ito, dapat batuhin ang baka, at hindi dapat kainin ang laman nito; pero mapapawalang sala ang may-ari ng baka. ");
INSERT INTO tglulb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero kung may ugaling pagsuwag dati pa ang baka at binigyan ng babala ang may-ari nito, at hindi niya ito ikinulong, at nakapatay ang baka ng isang lalaki o isang babae, kinakailangang batuhin ang baka. Dapat ding patayin ang may-ari nito. ");
INSERT INTO tglulb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kung kinakailangan ang kabayaran para sa kaniyang buhay, dapat niyang bayaran ang anumang kailangan niyang bayaran. ");
INSERT INTO tglulb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kung sinuwag ng baka ang anak na lalaki o anak na babae ng isang lalaki, dapat gawin ng may-ari ng baka ang hinihingi ng kautusang ito. ");
INSERT INTO tglulb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kung sinuwag ng baka ang isang lingkod na lalaki o lingkod na babae, dapat magbayad ang may-ari ng baka ng tatlumpung sekel na pilak, at dapat batuhin ang baka. ");
INSERT INTO tglulb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Kung magbubukas ng isang hukay ang isang lalaki, o kung humukay ng isang hukay ang isang lalaki, at hindi niya ito tinakpan at may nahulog na baka o asno sa loob nito, ");
INSERT INTO tglulb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","kailangan bayaran ng may-ari ng hukay ang nawala. Kailangan magbigay siya ng pera sa may-ari ng namatay na hayop at magiging kaniya ang namatay na hayop. ");
INSERT INTO tglulb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kung saktan ng baka ng isang tao ang baka ng ibang tao kaya namatay ito, kailangan nilang ipagbili ang buhay na baka at paghatian nila ang halaga nito, kailangan din nilang paghatian ang patay na baka. ");
INSERT INTO tglulb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pero kung nalaman na ang baka ay may ugaling nanunuwag sa nakaraan, at hindi ito kinulong ng may-ari, dapat siguraduhin siyang magbayad ng baka para sa baka at ang namatay na hayop ay magiging kaniyang pag-aari. ");
INSERT INTO tglulb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kung magnakaw ang isang lalaki ng isang baka o isang tupa at pinatay niya o ipinagbili ito, pagkatapos dapat siyang magbayad ng limang baka para sa isang baka, at apat na tupa para sa isang tupa. ");
INSERT INTO tglulb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kung ang magnanakaw ay natagpuang naninira, at kung nasaktan at siya ay namatay, sa ganoong kaso walang sinuman ang ituturing na may sala sa kaniyang kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Pero kung sumikat ang araw bago niya sinira, salang pagpatay ng tao ang ipapataw sa taong pumatay sa kaniya. Ang magnanakaw ay dapat gumawa ng pagbabayad-pinsala. Kung wala siyang pag-aari, pagkatapos dapat siyang ipagbili dahil sa kaniyang pagnanakaw. ");
INSERT INTO tglulb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Kung ang ninakaw na hayop ay natagpuang buhay sa kaniyang pag-aari, maging ito ay isang asno, o isang tupa, dapat siyang magbayad ng doble. ");
INSERT INTO tglulb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Kung magpapastol ang isang lalaki ng kaniyang mga baka sa isang bukid o sa ubasan at hinayaang nakakawala ang kaniyang hayop, at kumain ito sa bukid ng ibang tao, dapat siyang gumawa ng pagbabayad-pinsala mula sa pinakamainam sa kaniyang sariling bukid at mula sa pinakamainam sa kaniyang sariling ubasan. ");
INSERT INTO tglulb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Kung kumalat ang apoy at kumalat sa mga tinik kaya ang mga nakasalansan na butil, o nakatayo na butil, o ang bukid ay natupok, siya na nagsimula ng apoy ay dapat siguraduhing gumawa ng pagbabayad-pinsala. ");
INSERT INTO tglulb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kung magbibigay ng pera o ari-arian ang isang lalaki sa kaniyang kapitbahay para sa ligtas na pag-iingat, at kung ito ay ninakaw mula sa bahay ng lalaki, kung natagpuan ang magnanakaw, ang magnanakaw na iyon ay dapat magbayad ng doble. ");
INSERT INTO tglulb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pero kung ang magnanakaw ay hindi natagpuan, pagkatapos ang may-ari ng bahay ay dapat humarap sa mga hukom para tingnan kung nilagay niya ang kaniyang sariling kamay sa pag-aari ng kaniyang kapitbahay. ");
INSERT INTO tglulb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Sa bawat pagtatalo tungkol sa isang bagay, maging ito ay baka, asno, tupa, damit o anumang nawawalang bagay tungkol sa kung alin ang sinasabi ng isa, “Kabilang ito sa akin,” ang pag-aangkin ng dalawang panig ay kailangang humarap sa mga hukom. Ang taong makitaan ng mga hukom na siyang may sala ay dapat magbayad ng doble sa kaniyang kapitbahay. ");
INSERT INTO tglulb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Kung magbibigay ng isang asno, isang baka, isang tupa o anumang hayop ang isang lalaki sa kaniyang kapitbahay para pangalagaan, at kung ito ay namatay o nasaktan o natangay ito nang walang sinumang nakakita, ");
INSERT INTO tglulb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","isang panunumpa kay Yahweh ang dapat nilang gawin, kung walang isang tao na naglagay sa kaniyang kamay sa pagmamay-ari ng kaniyang kapitbahay. Kailangang tanggapin ng may-ari ito at ang isa ay hindi na kailangang gumawa ng pagbabayad-pinsala. ");
INSERT INTO tglulb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pero kung ninakaw ito mula sa kaniya, ang isa ay dapat gumawa ng pagbabayad-pinsala sa may-ari para dito. ");
INSERT INTO tglulb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kung ang hayop ay nagkagutay-gutay, hayaan na dalhin ng isang tao ang hayop bilang katibayan. Hindi siya kailangang magbayad kung anuman ang nasira. ");
INSERT INTO tglulb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kung hihiram ang isang tao ng anumang hayop mula sa kaniyang kapitbahay at ang hayop ay nasaktan o namatay na hindi ito kasama ng may-ari, ang ibang tao ay dapat siguraduhing gumawa ng pagbabayad-pinsala. ");
INSERT INTO tglulb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pero kung ang may-ari ay kasama nito, ang ibang tao ay hindi na kailangan magbayad; kung inupahan ang hayop, ito ay babayaran sa pamamagitan ng kaniyang bayad paupahan. ");
INSERT INTO tglulb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kung inaakit ng isang lalaki ang isang babaeng birhen na wala pang kasunduang magpakasal at kung siya ay kaniyang sinipingan, dapat siguraduhin niyang gawing asawa ang babae sa pamamagitan ng pagbabayad ng kasal-kayamanan na kinakailangan para dito. ");
INSERT INTO tglulb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kung ang kaniyang ama ay ganap na tumangging ibigay siya sa lalaki, ang lalaki ay dapat magbayad ng pera katumbas sa bayad-kayamanan ng mga birhen. ");
INSERT INTO tglulb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Hindi ninyo dapat hayaang mabuhay ang isang babaeng mangkukulam. ");
INSERT INTO tglulb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Sinumang sumiping sa isang hayop ay dapat siguradong malalagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Sinumang magsasakripisyo sa anumang diyos maliban kay Yahweh ay dapat ganap na wasakin. ");
INSERT INTO tglulb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Huwag dapat ninyong gawan ng masama ang isang dayuhan o pagmalupitan siya, dahil naging mga dayuhan din kayo sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Huwag dapat ninyong apihin ang sinumang balo o mga batang ulila sa ama. ");
INSERT INTO tglulb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kung sasaktan ninyo sila, at kung tumawag sila sa akin, na si Yahweh, siguradong pakikinggan ko ang kanilang tawag. ");
INSERT INTO tglulb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Magliliyab ang aking galit, at papatayin ko kayo sa pamamagitan ng espada; ang inyong mga asawa ay magiging balo, at ang inyong mga anak ay magiging ulila sa ama. ");
INSERT INTO tglulb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Kung magpapahiram kayo ng pera sa sinuman sa aking mga tao sa gitna ninyo na mga mahihirap, hindi kayo dapat matulad sa isang nagpapatubo sa kaniya o singilin siya ng may tubo. ");
INSERT INTO tglulb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kung kukunin ninyo ang damit ng inyong kapitbahay bilang pangako, dapat ninyong isauli ito sa kaniya bago lumubog ang araw, ");
INSERT INTO tglulb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","dahil iyon lamang ang kaniyang tanging pantakip; ito ay ang kaniyang damit para sa kaniyang katawan. Ano pa ang kaniyang ipangtutulog? Kapag tumawag siya sa akin, pakikinggan ko siya, dahil ako ay mahabagin. ");
INSERT INTO tglulb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Hindi dapat ninyo ako nilalapastangan, ako na inyong Diyos, ni sumpain ang namumuno sa inyong bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Hindi dapat ninyo ipagkait ang inyong mga handog mula sa inyong ani o sa inyong pisaan ng ubas. Dapat ninyong ibigay sa akin ang panganay ng inyong mga anak na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Dapat din ninyong gawin sa inyong mga baka at sa inyong tupa. Dahil sa loob ng pitong araw mananatili sila sa kanilang mga ina, pero sa loob ng ikawalong araw dapat ninyong ibigay sila sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Kayo ay magiging bayan na ibubukod para sa akin. Kaya huwag dapat kayong kumain ng anumang karne na ginutay-gutay ng mga hayop sa bukid. Sa halip, dapat ninyong itapon ito sa mga aso. ");
INSERT INTO tglulb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Hindi ka dapat magbigay ng isang maling ulat tungkol sa sinuman. Huwag makianib sa taong masama para maging saksi na hindi tapat. ");
INSERT INTO tglulb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Hindi mo dapat sundin ang karamihan ng tao para gumawa ng kasamaan, ni maaari kang sumaksi habang pumapanig kasama ang karamihan ng tao para ilihis ang katarungan. ");
INSERT INTO tglulb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Hindi ka dapat sumang-ayon sa isang taong dukha sa kaniyang kaso sa batas. ");
INSERT INTO tglulb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Kung makasalubong mo ang naligaw na baka ng iyong kaaway o ang kaniyang asno, dapat mo itong ibalik sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kung makita mo ang asno ng sinumang napopoot sa iyo na bumagsak sa lupa ang karga nito, hindi mo dapat iwanan ang taong iyon. Dapat siguraduhin mong tulungan siya kasama ang kaniyang asno. ");
INSERT INTO tglulb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Hindi mo dapat ilihis ang katarungan kapag ito ay dapat pumunta sa iyong bayan sa isang lalaking dukha na may kaso. ");
INSERT INTO tglulb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Huwag kang makianib sa iba na gumagawa ng maling mga paratang, at huwag kang pumatay ng inosente o banal, dahil hindi ko ipapawalang sala ang masama. ");
INSERT INTO tglulb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Huwag kumukuha ng suhol, dahil ang suhol ang bumubulag sa mga taong nakakakita, at inililihis ang mga salita ng mga taong tapat. ");
INSERT INTO tglulb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Huwag mo dapat apihin ang dayuhan, dahil alam mo ang buhay ng isang dayuhan, dahil naging mga dayuhan kayo sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Sa loob ng anim na taon magtatanim ka ng buto sa iyong lupain at iipunin ang mga naani. ");
INSERT INTO tglulb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Pero sa ikapitong taon lilinangin mo ito nang walang araro at hahayaan, para ang mahihirap sa gitna ninyo ay makakain. Kung ano ang kanilang iniwan, ang mga mababangis na hayop ang kakain. Gagawin mo rin ito sa iyong ubasan at sa iyong halamanang olibo. ");
INSERT INTO tglulb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sa loob ng anim na araw magtatrabaho ka, pero sa ikapitong araw dapat kang magpahinga. Gawin mo ito para makapagpahinga ang iyong baka at asno, at para ang iyong anak na lalaki ng lingkod na babae at anumang dayuhan ay maaaring makapagpahinga at maging masigla. ");
INSERT INTO tglulb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Bigyang-pansin ang lahat ng bagay na aking sinabi sa iyo. Huwag mong banggitin ang mga pangalan ng ibang mga diyos, o ni hayaang marinig ang kanilang mga pangalan mula sa iyong bibig. ");
INSERT INTO tglulb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Dapat kang maglakbay para magdaos ng isang pista para sa akin tatlong beses sa bawat taon. ");
INSERT INTO tglulb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ipagdiwang mo ang Pista ng Tinapay na Walang Lebadura. Bilang aking utos sa iyo, kakain ka ng tinapay na walang lebadura sa loob ng pitong araw. Sa panahong iyon, magpapakita ka sa aking harapan sa buwan ng Abib, na itinakda para sa layuning ito. Sa buwang ito lumabas ka galing Ehipto. Pero hindi ka dapat magpakita sa aking harapan na walang-dala. ");
INSERT INTO tglulb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Dapat ipagdiwang mo ang Pista ng Pag-aani, ang unang mga bunga ng iyong pinagtrabahuhan nang nagtanim ka ng buto sa iyong bukirin. At saka dapat mong ipagdiwang ang Pista ng Pagtitipon sa katapusan ng taon, kapag nalikom ninyo ang iyong inani mula sa bukirin. ");
INSERT INTO tglulb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Dapat magpakita ang lahat ng iyong mga kalalakihan sa harapan ko, si Yahweh, tatlong beses sa bawat taon. ");
INSERT INTO tglulb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Dapat huwag mong ialay ang dugo na galing sa mga handog na ginawa para sa akin kasama ang tinapay na may lamang lebadura. Ang taba na galing sa mga handog ng aking mga kapistahan ay hindi dapat manatili ng buong gabi hanggang sa kinaumagahan. ");
INSERT INTO tglulb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Dapat ninyong dalhin ang unang mga prutas na piling-pili galing sa inyong lupain sa aking bahay, ang templo ni Yahweh na inyong Diyos. Dapat huwag mong ilalaga ang batang kambing sa gatas ng kaniyang ina. ");
INSERT INTO tglulb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Magpapadala ako ng anghel sa unahan mo para bantayan ka sa iyong landas, at para dalhin ka sa lugar na aking inihanda. ");
INSERT INTO tglulb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Maging mapagmatyag ka sa kaniya at sundin mo siya. Huwag mo siyang galitin, dahil hindi ka niya patatawarin sa iyong mga pagsuway. Ang pangalan ko ay nasa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kung talagang susundin mo ang kaniyang tinig at gagawin ang lahat ng bagay na sinabi ko sa iyo, sa gayon magiging kaaway ko ang iyong mga kaaway at kalaban para sa iyong mga kalaban. ");
INSERT INTO tglulb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Pangungunahan ka ng aking anghel at dadalhin ka niya sa mga Amoreo, Perezeo, Cananeo, Heveo at Jebuseo. Wawasakin ko sila. ");
INSERT INTO tglulb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Hindi ka dapat yumuko sa kanilang mga diyos, sambahin sila, o gawin ang tulad ng kanilang ginagawa. Sa halip, dapat mong tuluyang patalsikin sila at basagin ang kanilang sagradong batong mga haligi ng pira-piraso. ");
INSERT INTO tglulb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Dapat sambahin ninyo ako, si Yahweh na iyong Diyos. Kung gagawin mo, pagpapalain ko ang iyong tinapay at tubig. Aalisin ko ang karamdaman mula sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Walang babae na magiging baog o makukunan sa iyong lupain. Bibigyan kita ng mahabang buhay. ");
INSERT INTO tglulb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ako mismo ang magpapadala ng takot sa akin para sa mga taong naroon sa lupain kung saan ka susulong. Papatayin ko lahat ang mga taong makakasalubong mo. Gagawin ko ang lahat mong mga kaaway na babalik sa kanilang landas na may takot. ");
INSERT INTO tglulb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Magpapadala ako ng mga putakti sa unahan mo para palayasin ang mga Heveo, Cananeo, at ang mga Heteo sa harapan mo. ");
INSERT INTO tglulb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Hindi ko sila itataboy mula sa harapan mo sa loob ng isang taon, o ang lupain ay magiging napabayaan, at ang mga mababangis na hayop ay magiging napakarami para sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Sa halip, palalayasin ko sila ng paunti-unti mula sa harapan mo hanggang ikaw ay maging mabunga at manahin ang lupain. ");
INSERT INTO tglulb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Itatakda ko ang iyong mga hangganan mula sa Dagat ng mga Tambo patungo sa Dagat ng Palestina, at mula sa ilang patungo sa Ilog Eufrates. Ibibigay ko sa iyo ang tagumpay laban sa mga naninirahan sa lupain. Palalayasin mo sila sa harapan mo. ");
INSERT INTO tglulb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Huwag kang gumawa ng kasunduan sa kanila o sa kanilang diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Hindi sila dapat manirahan sa iyong lupain o gagawin ka nilang makasalanan laban sa akin. Kung sambahin mo ang kanilang diyos, siguradong ito ay magiging bitag para sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Pagkatapos sinabi ni Yahweh kay Moises, “Umakyat ka papunta sa akin- ikaw, Aaron, Nadab, Abihu, at pitumpung mga nakatatanda ng Israelita, at sambahin ako sa kalayuan. ");
INSERT INTO tglulb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Si Moises lamang ang maaring lumapit sa akin. Ang iba ay hindi dapat lumapit, ni maaring sumama paakyat ang mga tao sa kaniya.” ");
INSERT INTO tglulb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Pumunta si Moises sa mga tao at sinabi ang lahat ng mga salita ni Yahweh at mga palatuntunan. Sumagot ang lahat ng mga tao na may isang tinig at sinabing, “Gagawin namin ang lahat ng mga salita na sinabi ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Pagkatapos sinulat ni Moises ang lahat ng mga salita ni Yahweh. Umagang-umaga, nagtayo si Moses ng altar sa paanan ng bundok at inayos ang labing dalawang mga haligi na bato, kaya ang mga batong iyon ang siyang kumatawan sa labing dalawang lipi ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Nagpadala siya ng ilang mga binatang Israelita para mag-alay ng mga sinunog na handog at mag-alay ng sama-samang handog na mga baka para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Kinuha ni Moises ang kalahati ng dugo at nilagay sa loob ng mga palanggana, iniwisik ang natirang kalahati sa ibabaw ng altar. ");
INSERT INTO tglulb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kinuha niya Ang Aklat ng Tipan at binasa ito ng malakas sa mga tao. Sinabi nila, “Gagawin namin ang lahat ng sinabi ni Yahweh. Magiging masunurin kami.” ");
INSERT INTO tglulb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Pagkatapos kinuha ni Moises ang dugo at iniwisik ito sa mga tao. Sinabi niya, “Ito ang dugo ng tipan na ginawa ni Yahweh para sa inyo sa pamamagitan ng pagbibigay sa inyo ng pangakong ito kasama ang lahat ng mga salitang ito. ");
INSERT INTO tglulb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Pagkatapos sina Moises, Aaron, Nadab, Abihu, at pitumpu sa mga nakatatanda ng Israel ay umakyat sa bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Nakita nila ang Diyos ng Israel. Sa ilalim ng kaniyang mga paa mayroong semento na gawa sa sapirong bato, na kasing linaw ng mismong langit. ");
INSERT INTO tglulb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Hindi inilagay ng Diyos isang kamay sa galit sa mga pinuno ng Israelita. Nakita nila ang Diyos, at kumain at uminom sila. ");
INSERT INTO tglulb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Sinabi ni Yahweh kay Moises, “Umakyat ka papunta sa akin sa bundok at manatili ka doon. Ibibigay ko sa iyo ang mga tipak ng bato at ang batas at mga utos na aking sinulat, para ituro mo sa kanila.” ");
INSERT INTO tglulb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Kaya lumakad si Moises kasama ang kaniyang utusan na si Josue at inakyat ang bundok ng Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Sinabi ni Moises sa mga nakatatanda, “Manatili kayo dito at hintayin ninyo kami hanggang makabalik kami sa inyo. Sina Aaron at Hur ay kasama ninyo. Kung sinuman ang mayroong pagtatalo, hayaan mo siyang pumunta sa kanila.” ");
INSERT INTO tglulb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kaya umakyat si Moises papunta sa bundok, at tinakpan ito ng ulap. ");
INSERT INTO tglulb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Nanahan ang kaluwalhatian ni Yahweh sa Bundok ng Sinai, at tinakpan ito ng ulap sa loob ng anim na araw. Sa ikapitong araw tinawag niya si Moises mula sa loob ng ulap. ");
INSERT INTO tglulb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ang anyo ng kaluwalhatian ni Yahweh ay katulad ng isang apoy na tumutupok sa ibabaw ng bundok sa mga mata ng mga Israelita. ");
INSERT INTO tglulb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Pumasok si Moises sa ulap at umakyat sa bundok. Naroon siya sa ibabaw ng bundok nang apatnapung araw at apatnapung gabi. ");
INSERT INTO tglulb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Sinabi ni Yahweh kay Moises, ");
INSERT INTO tglulb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Sabihin sa mga Israelita na kumuha ng isang handog para sa akin mula sa bawat tao na hinikayat ng maluwag sa kalooban. Dapat ninyong tanggapin ang mga handog na ito para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ito ang mga handog na dapat ninyong tanggapin mula sa kanila: ginto, pilak, at tanso; ");
INSERT INTO tglulb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","asul, lila, at matingkad na pulang lana; pinong lino; mga buhok ng kambing; ");
INSERT INTO tglulb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","mga tininang pulang balat ng lalaking tupa at balat ng hayop na nakatira sa dagat; kahoy ng akasya; ");
INSERT INTO tglulb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","langis para sa mga ilawan ng santuwaryo; pampalasa para sa langis na pangpahid at ang mahalimuyak na insenso; ");
INSERT INTO tglulb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mga oniks na bato at ibang mga mamahaling bato na ilalagay sa epod at baluti. ");
INSERT INTO tglulb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Hayaan silang gumawa ng isang santuwaryo para manirahan ako sa gitna nila. ");
INSERT INTO tglulb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Dapat ninyong gawin ito ng ganap habang ipinapakita ko sa iyo ang mga plano para sa tabernakulo at sa lahat nitong kagamitan. ");
INSERT INTO tglulb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Sila ay gagawa ng isang kaban ng kahoy na akasya. Ang haba dapat nito ay dalawa at kalahating mga kubit; ang lapad nito ay magiging isang kubit at kalahati; at ang taas nito ay magiging isang kubit at kalahati. ");
INSERT INTO tglulb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Dapat mo itong balutin sa loob at labas sa purong ginto, at dapat mo itong gawan ng isang hangganang ginto sa paligid ng ibabaw nito. ");
INSERT INTO tglulb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Dapat kayong magmolde ng apat na gintong argolya para rito, at ilagay sila sa apat na paanan ng kaban, kasama ang dalawang argolya sa isang gilid nito, at dalawang argolya sa ibang gilid. ");
INSERT INTO tglulb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Dapat kayong gumawa ng mga baras ng kahoy na akasya at balutan ito ng ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Dapat ninyong ilagay ang mga baras doon sa mga argolya sa mga gilid ng kaban, para madala ang kaban. ");
INSERT INTO tglulb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ang mga baras ay dapat manatili sa mga argolya ng kaban; hindi dapat sila kunin mula rito. ");
INSERT INTO tglulb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Dapat ninyong ilagay sa kaban ang tipan ng kautusan na ibibigay ko sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Dapat kayong gumawa ng takip ng isang luklukan ng awa ng purong ginto. Ang haba nito ay dapat dalawa at kalahating mga kubit, at ang lapad nito ay dapat isang kubit at kalahati. ");
INSERT INTO tglulb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Dapat kayong gumawa ng dalawang kerubin ng gintong pinanday para sa dalawang mga dulo ng takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Gumawa ng isang kerubin para sa isang dulo ng takip ng luklukan ng awa, at ang ibang kerubin para sa kabilang dulo. Sila ay dapat maging gawa bilang isang baluti kasama ang takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Nakabuka dapat ang mga pakpak ng kerubin pataas at nilukuban ang takip ng luklukan ng awa sa pagitan nila. Ang kerubin ay dapat nakaharap sa isat-isa at nakatingin patungo sa gitna ng takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Dapat ninyong ilagay ang takip ng luklukan ng awa sa ibabaw ng kaban, at dapat ninyong ilagay sa kaban ang tipan ng kautusan na ibibigay ko sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ito ang kaban na kung saan ako ay makikipagkita sa iyo. Makikipag-usap ako sa iyo mula sa aking kinalalagyan sa ibabaw ng takip ng luklukan ng awa. Ito ay magmula sa pagitan ng dalawang kerubin sa ibabaw ng kaban ng patunay na ako ay makikipag-usap sa iyo tungkol sa lahat ng mga utos na ibibigay ko sa iyo para sa mga Israelita. ");
INSERT INTO tglulb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Dapat kayong gumawa ng isang mesa ng kahoy na akasya. Ang haba nito ay dapat dalawang kubit; ang lapad nito ay dapat isang kubit, at ang taas nito ay dapat isang kubit at kalahati. ");
INSERT INTO tglulb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Dapat balutan ninyo ito ng purong ginto at lagyan ng gintong dulo sa paligid ng ibabaw. ");
INSERT INTO tglulb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Dapat kayong gumawa ng isang kalakip na balangkas para dito na may isang dangkal ang lapad, kasama ng kalakip na hangganan na ginto para sa balangkas. ");
INSERT INTO tglulb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Dapat gumawa kayo para dito ng apat na argolya na ginto at ikabit ang mga argolya sa apat na kanto, na kung saan ang apat na paa ay naroon. ");
INSERT INTO tglulb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ang mga argolya ay dapat nakakabit sa gilid para magbigay ng mga lugar para sa mga baras, nang sa gayon ay mabubuhat ang mesa. ");
INSERT INTO tglulb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Dapat kayong gumawa ng mga baras galing sa kahoy na akasya at balutan sila ng ginto para ang mesa ay maaaring buhatin nila. ");
INSERT INTO tglulb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Dapat kayong gumawa ng mga pinggan, mga kutsara, mga pitsel, at mga mangkok para gamitin sa pagbuhos ng inuming mga handog. Dapat gawin ninyo sila ng purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Dapat palagi ninyong ilagay ang tinapay ng presensya sa mesa na nasa harapan ko. ");
INSERT INTO tglulb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Dapat kayong gumawa ng isang ilawan ng purong gintong pinanday. Ang ilawan ay gagawin na may paanan at poste. Ang mga tasa nito, ang mga madahong paanan, at ang mga bulaklak nito ay gawa lahat sa isang pirasong kalakip nito. ");
INSERT INTO tglulb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Anim na mga sanga na dapat pahabain palabas mula sa mga gilid nito-tatlong mga sanga na dapat pahabain mula sa isang gilid, at tatlong mga sanga ng ilawan ay dapat pahabain mula sa kabilang gilid. ");
INSERT INTO tglulb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ang unang sanga ay dapat may tatlong mga tasa na ginawa katulad ng almendro na mga bulaklak, kasama ang isang madahong paanan at isang bulaklak, at tatlong mga tasa ginawa na katulad ng almendro na mga bulaklak na nasa ibang sanga, kasama ang isang madahong paanan at isang bulaklak. Dapat kapareho ito sa lahat ng anim na sanga na hahaba palabas mula sa ilawan. ");
INSERT INTO tglulb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Sa sariling ilawan, ang gitnang katawan ng poste, apat dapat ang mga tasang gawa tulad ng almendro na mga bulaklak, kasama ng kanilang madahong paanan at ang mga bulaklak. ");
INSERT INTO tglulb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Dapat may isang madahong paanan sa unang pares ng mga sanga—gawa bilang isang piraso na kasama nito, at ang isang madahong paanan sa ilalim ng pangalawang pares ng mga sanga—ginawa rin bilang isang piraso kasama nito. Sa parehong paraan dapat mayroong isang madahong paanan sa ilalim ng pangatlong pares ng mga sanga, ginawa bilang isang piraso na kasama nito. Ito ay dapat kapareho ng lahat ng anim na sanga na palabas mula sa ilawan. ");
INSERT INTO tglulb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ang kanilang mga madahong paanan at mga sanga ay dapat maging isang piraso kasama nito, isang piraso ng pinalong yari sa purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Dapat kayong gumawa ng ilawan at ang pitong ilaw nito, at ilagay ang mga ilaw nito para sila ay magbigay ng liwanag mula dito. ");
INSERT INTO tglulb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ang mga sipit at ang kanilang mga bandeha ay dapat ginawa sa purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Gumamit ng isang talentong purong ginto na ang timbang ay 34 kilo sa paggawa ng ilawan at mga kagamitan nito. ");
INSERT INTO tglulb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Siguraduhin na gagawin sila mula sa modelo na ipinapakita sa inyo sa ibabaw ng bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Dapat gumawa ka ng tabernakulo na may sampung kurtina na yari sa pinong lino na kulay asul, lila, at matingkad na pulang lana na may disenyong kerubin. Gagawin ito ng mahusay na manggagawang lalaki. ");
INSERT INTO tglulb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ang haba ay dalawampu't walong kubit, ang lapad ay apat na kubit. Dapat magkaparehong sukat ang lahat ng mga kurtina. ");
INSERT INTO tglulb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Dapat pagdugtungin ang limang kurtina, at ang ibang limang kurtina ay dapat idugtong sa bawat isa. ");
INSERT INTO tglulb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Dapat gumawa ka ng asul na silo sa labas ng gilid ng kurtina sa isang pangkat. Gayundin, dapat kang gumawa ng pareho ng gilid sa dulo ng kurtina sa pangalawang pangkat. ");
INSERT INTO tglulb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Dapat kang gumawa ng limampung silo sa unang kurtina, at dapat kang gumawa ng limampung silo sa dulo ng kurtina sa pangalawang pangkat. Gawin ito para ang mga silo ay maging magkasalungat sa bawat isa. ");
INSERT INTO tglulb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Dapat kang gumawa ng limampung panghawak na ginto at pagdugtungin ang mga kurtina kasama ito kaya ang tabernakulo ay magiging buo. ");
INSERT INTO tglulb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Dapat kang gumawa ng mga kurtinang balahibo ng kambing para sa isang tolda na pantakip sa itaas ng tabernakulo. Dapat kang gumawa ng labing-isa sa mga kurtinang ito. ");
INSERT INTO tglulb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ang haba ng bawat kurtina ay dapat tatlumpung kubit, at ang lapad ng bawat kurtina ay dapat apat na kubit. Dapat parehong sukat ang bawat isa sa labing-isang kurtina. ");
INSERT INTO tglulb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Dapat pagdugtungin mo ang limang kurtina at ang ibang anim na kurtina sa bawat isa. Dapat doblehin mo ang ikaanim na kurtina sa harap ng tolda. ");
INSERT INTO tglulb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Dapat kang gumawa ng limampung silo sa gilid ng dulo ng kurtina sa unang pangkat at limampung silo sa gilid ng dulo na magdugtong sa pangalawang pangkat. ");
INSERT INTO tglulb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Dapat kang gumawa ng limampung tansong panghawak at ilagay ang mga ito sa mga silo. Pagkatapos dapat mong pagdugtungin ng magkakasama ang mga tolda na pantakip para maging isa. ");
INSERT INTO tglulb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ang naiwang kalahating kurtina, iyan ay, ang naiwang nakalaylay na bahagi galing sa mga kurtina ng tolda, dapat nakasabit sa likod ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Dapat magkaroon ng isang kubit sa isang bahagi ng kurtina, at sa isang kubit din sa ibang bahaging kurtina—na ang naiwang haba ng toldang kurtina ay dapat lumaylay sa mga gilid ng tabernakulo sa isang gilid at sa kabilang gilid, para takpan ito. ");
INSERT INTO tglulb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Dapat kang gumawa ng pantakip sa tabernakulo ng balat ng lalaking tupa na kinulayan ng pula, at ibang pantakip na yari sa balat para sa itaas nito. ");
INSERT INTO tglulb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Dapat kang gumawa ng mga patayong tabla na yari sa akasyang kahoy para sa tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ang haba ng bawat tabla ay dapat sampung kubit, at ang lapad ay dapat isa at kalahating kubit. ");
INSERT INTO tglulb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Dapat may dalawang nakausli sa bawat tabla para maidugtong ang mga tabla sa bawat isa. Gagawin mo ang lahat ng mga tabla sa tabernakulo sa ganitong pamamaraan. ");
INSERT INTO tglulb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kapag gagawa ka ng mga tabla para sa tabernakulo, dapat kang gumawa ng dalawampung tabla sa bawat timog na bahagi. ");
INSERT INTO tglulb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Dapat kang gumawa ng apatnapung pilak na mga pundasyon sa dalawampung tabla. Dapat may dalawang pundasyon sa isang tabla na may dalawang patungan, at ganoon din ang dalawang pundasyon sa ilalim ng bawat ibang tabla na may dalawang patungan. ");
INSERT INTO tglulb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Para sa pangalawang gilid ng tabernakulo, sa hilagang bahagi, dapat kang gumawa ng dalawampung tabla ");
INSERT INTO tglulb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","at apatnapung pilak na pundasyon. Dapat may dalawang pundasyon sa unang tabla at dalawang pundasyon sa sumunod na tabla at sa susunod pa. ");
INSERT INTO tglulb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Dapat kang gumawa ng anim na tabla, para sa dakong likuran ng kanlurang gilid ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Dapat kang gumawa ng dalawang tabla sa likuran ng mga sulok ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Dapat magkahiwalay ang mga tablang ito sa ilalim, pero magkadugtong sa itaas sa parehong bilog na metal. Dapat sa ganitong paraan sa parehong likuran ng mga sulok. ");
INSERT INTO tglulb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Dapat may walong tabla, kasama ng mga pilak na pundasyon. Dapat mayroong labing-anim sa lahat ng pundasyon, dalawang pundasyon sa unang tabla, dalawang pundasyon sa ilalim ng sunod na tabla, at ganoon din sa susunod. ");
INSERT INTO tglulb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Dapat kang gumawa ng mga pahalang na haligi na yari sa akasyang kahoy—lima para sa mga tabla ng isang gilid ng tabernakulo, ");
INSERT INTO tglulb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","limang pahalang na haligi sa kabilang gilid ng tabernakulo, at limang pahalang na haligi para sa dakong likuran ng kanluran ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ang pahalang na haligi sa gitna ng mga tabla, iyan ay, kalagitnaang pataas, dapat umabot sa magkabilang dulo. ");
INSERT INTO tglulb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Dapat mong balutin ng ginto ang mga tabla. Dapat kang gumawa ng kanilang mga gintong bilog na metal, para ang mga ito ay magsilbing hawakan para sa mga pahalang na haligi, at dapat balutin mo ng ginto ang mga baras. ");
INSERT INTO tglulb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Dapat mong itayo ang tabernakulo sa pamamagitan ng pagsunod sa plano na pinakita sa iyo sa bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Dapat kang gumawa ng kurtina na may asul, lila at matingkad na pulang lana, na may disenyong kerubin, gawa ito ng mahusay na manggagawang lalaki. ");
INSERT INTO tglulb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Dapat isabit mo ito sa limang poste ng akasya na kahoy na binalot ng ginto. Dapat ang mga poste ay may mga kawit na gintong pangkat sa apat na pundasyong pilak. ");
INSERT INTO tglulb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Dapat isabit mo ang kurtina sa mga panghawak, at dapat mong dalhin ang kautusang tipan ng kaban. Ihihiwalay ng kurtina ang banal na lugar sa kabanal-banalang lugar. ");
INSERT INTO tglulb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Dapat mong ilagay ang takip ng luklukan ng awa sa kautusang tipan ng kaban, na makikita sa kabanal-banalang lugar. ");
INSERT INTO tglulb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Dapat mong ilagay ang mesa sa labas ng kurtina. Dapat mong ilagay ang ilawan na kasalungat ng mesa sa timog na bahagi ng tabernakulo. Ang mesa ay dapat nasa hilagang bahagi. ");
INSERT INTO tglulb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Dapat kang gumawa ng pabitin sa pasukan ng tabernakulo. Dapat mong gawing asul, lila, matingkad na pulang bagay, at pinong pinulupot ng lino, ang gawa ng taga-burda. ");
INSERT INTO tglulb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Dapat kang gumawa ng mga limang poste ng akasya at balutin ito ng ginto. Ang kanilang mga kawit ay ginto at limang tansong pundasyon para sa mga ito. ");
INSERT INTO tglulb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Dapat kang gumawa ng altar mula sa kahoy ng akasya, limang kubit ang haba at limang kubit ang luwag. Dapat ang altar ay parisukat na may tatlong kubit na taas. ");
INSERT INTO tglulb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Dapat kang gumawa ng karugtong na apat na mga sulok ng parisukat na mga anyong sungay. Gagawin ang mga sungay bilang isang bahagi ng altar, at dapat mong balutin ito ng tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Dapat kang gumawa ng kasangkapan para sa altar, mga palayok para sa abo at gayundin ang mga pala, mga palanggana, mga tinidor para sa karne at mga lalagyan ng apoy. Dapat mong gawin ang lahat ng mga kagamitan mula sa tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Dapat kang gumawa ng rehas na bakal para sa altar, tanso ang sangkap. Gumawa ng tansong argolya sa bawat apat na mga sulok ng rehas na bakal. ");
INSERT INTO tglulb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Dapat kang maglagay ng rehas sa ilalim ng pasamano ng altar, kalahatian pababa hanggang ilalim. ");
INSERT INTO tglulb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Dapat kang gumawa ng mga poste para sa altar, mga poste na kahoy ng akasya, at dapat mong balutin ang mga ito ng tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Dapat mailagay ang mga poste sa mga argolya, at ang mga poste ay dapat nasa dalawang tagiliran ng altar, para madala ito. ");
INSERT INTO tglulb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Dapat mong gawin ang altar na may guwang, na yari sa mga makapal na tabla. Dapat mong gawin ito sa paraan na ipinakita sa iyo sa bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Dapat kang gumawa ng isang patyo para sa tabernakulo. Dapat may mga nakasabit sa bahaging timog ng patyo, mga nakasabit na pinong pinulupot na lino na isang daang kubit ang haba. ");
INSERT INTO tglulb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Dapat ang mga nakasabit ay may dalawampung mga poste, na may dalawampung tansong mga pundasyon. Dapat mayroon ding mga kawit na nakadugtong sa mga poste, at gayundin sa pilak na mga baras. ");
INSERT INTO tglulb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Gayundin naman sa tabi ng hilagang bahagi, dapat mayroong mga nakasabit na isang daang kubit ang haba na may dalawampung mga poste, dalawampung tansong mga pundasyon, mga kawit na nakadugtong sa mga poste, at pilak na mga baras. ");
INSERT INTO tglulb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Sa tabi ng patyo sa kanlurang bahagi dapat mayroong kurtinang limampung kubit ang haba. Dapat mayroong sampung mga poste at sampung mga pundasyon. ");
INSERT INTO tglulb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ang patyo ay dapat ding limampung kubit ang haba sa silangang bahagi. ");
INSERT INTO tglulb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ang mga nakasabit para sa isang dako ng pasukan ay dapat labinlimang kubit ang haba. Dapat mayroon silang tatlong mga poste na may tatlong mga pundasyon, ");
INSERT INTO tglulb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ang ibang bahagi rin ay dapat mayroong mga nakasabit na labinlimang kubit ang haba. Dapat mayroon silang tatlong mga poste at tatlong mga pundasyon. ");
INSERT INTO tglulb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ang tarangkahan ng patyo ay dapat mayroong isang kurtina na dalawampung kubit ang haba. Ang kurtina ay dapat ginawa sa asul, lila at matingkad na pulang bagay at pinong pinulupot na lino, ang gawa ng isang taga-burda. Dapat mayroong apat na mga poste na may apat na mga pundasyon. ");
INSERT INTO tglulb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ang lahat ng mga poste ng patyo ay dapat mayroong pilak na mga baras, pilak na mga kalawit at tansong mga pundasyon. ");
INSERT INTO tglulb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ang haba ng patyo ay dapat isang daang kubit, ang lapad ay limampung kubit at ang taas ay limang kubit na may pinong pinulupot na lino ang lahat ng mga nakasabit sa tabi at ang mga pundasyon ay tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Lahat ng kasangkapan na gagamitin sa tabernakulo at ang lahat ng mga tulos ng tolda para sa tabernakulo at patyo ay dapat gawa sa tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Dapat mong utusan ang mga Israelita na magdala ng purong langis ng pinisang olibo para sa ilawan para magpapatuloy itong masunog. ");
INSERT INTO tglulb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Sa tolda ng pagpupulong, sa labas ng kurtina na nasa harapan ng tipan ng kautusan, si Aaron at kaniyang mga anak na lalaki ay dapat panatilihin ang mga ilawan mula sa gabi hanggang sa umaga sa harapan ni Yahweh. Ang utos na ito ay magiging isang walang hanggang kautusan magpakailanman sa buong mga salinlahi sa bansa ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Tawagin mo ang iyong kapatid na si Aaron at ang kaniyang mga anak na lalaki na sina Nadab, Abihu, Eleazar, at Itamar mula sa mga Israelita para maglingkod sila sa akin bilang mga pari. ");
INSERT INTO tglulb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Dapat kang gumawa ng kasuotan para kay Aaron, na iyong kapatid, na inihandog para sa akin. Ang kasuotang ito ay magiging kaniyang karangalan at kagandahan. ");
INSERT INTO tglulb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Dapat mong sabihin sa lahat ng mga tao nang may katalinuhan sa puso, pinuno ko sila ng espiritu ng karunungan, para makagawa sila ng mga kasuotan ni Aaron para itakda siyang nakahiwalay para maglingkod sa akin bilang pari. ");
INSERT INTO tglulb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ang mga kasuotan na dapat nilang gawin ay isang baluti, isang efod, isang balabal, isang kasuotang gawa sa habi, isang turbante at isang sintas. Dapat nilang gawin ang mga kasuotang ito para ihandog sa akin. Ito ay para sa iyong kapatid na si Aaron at sa kaniyang mga anak na lalaki para maaari silang maglingkod sa akin bilang mga pari. ");
INSERT INTO tglulb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Dapat gumamit ang mga manggagawang lalaki ng pinong lino na ginto, asul, lilak at matingkad na pula. ");
INSERT INTO tglulb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Dapat silang gumawa ng efod na ginto, asul, lilak at matingkad na pulang lana, at ng pinulupot na pinong lino. Dapat gawa ito ng isang bihasang manggagawang lalaki. ");
INSERT INTO tglulb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Dapat mayroon itong dalawang pirasong pambalikat na nakakabit sa itaas ng dalawang sulok. ");
INSERT INTO tglulb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ang makinis na habing sinturon ay dapat kagaya ng efod; dapat gawa ito sa isang piraso kasama ng efod, na gawa sa nakapilipit na pinong lino na ginto, asul, lilak, at matingkad na pula. ");
INSERT INTO tglulb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Dapat kang kumuha ng dalawang batong oniks at iukit dito ang mga pangalan ng labindalawang anak na lalaki ni Israel. ");
INSERT INTO tglulb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Anim sa kanilang mga pangalan ay dapat nasa isang bato, at ang anim na pangalan dapat ay nasa ibang bato, ayon sa kanilang kapanganakan. ");
INSERT INTO tglulb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Sa pamamagitan ng gawa ng mang-uukit ng bato, kagaya ng pag-ukit sa isang selyo, dapat mong ipaukit ang dalawang bato kasama ng mga pangalan ng labindalawang anak na lalaki ni Israel. Dapat mong ilagay ang mga bato sa lalagyang ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Dapat mong ilagay ang dalawang bato sa mga pirasong pambalikat ng efod, para maging mga bato para magpapaalala kay Yahweh sa mga anak na lalaki ni Israel. Si Aaron ang magdadala ng kanilang mga pangalan sa harap ni Yahweh sa kaniyang dalawang balikat bilang isang paalala sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Dapat kang gumawa ng mga lalagyang ginto ");
INSERT INTO tglulb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","at dalawang mga tinirintas na kadena sa purong ginto kagaya ng mga tali, at dapat mong ikabit ang mga kadena sa mga lalagyan. ");
INSERT INTO tglulb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Dapat kang gumawa ng isang baluti para sa paggawa ng desisyon, ang gawa ng isang bihasang manggagawang lalaki, gaya ng pagkakagawa ng efod. Gawin ito sa ginto, sa asul, lilak, at matingkad na pulang lana, at sa pinong lino. ");
INSERT INTO tglulb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ito ay parisukat. Dapat mong tiklupin ng doble ang baluti. Dapat isang dangkal ang haba at isang dangkal ang lapad nito. ");
INSERT INTO tglulb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Dapat mong ilagay ito sa apat na hanay ng mahalagang mga bato. Ang unang hanay ay dapat may isang rubi, isang topaz, at isang karbungko. ");
INSERT INTO tglulb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ang ikalawang hanay ay dapat may isang esmeralda, isang sapiro, at isang dyamante. ");
INSERT INTO tglulb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ang pangatlong hanay ay dapat may isang hasinto, isang agata, at isang amatista. ");
INSERT INTO tglulb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ang pang-apat na hanay ay dapat may isang berilo, isang oniks, at isang haspe. Dapat nakakabit ito sa mga lalagyang ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Dapat ang mga bato ay nakaayos ayon sa mga pangalan ng labindalawang anak na lalaki ni Israel, bawat pangalan na magkakasunod-sunod. Dapat katulad sila sa nakaukit ng isang selyong singsing, bawat pangalan ay tumatayo bilang isa sa mga labindalawang lipi. ");
INSERT INTO tglulb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Dapat kang gumawa sa baluti ng mga kadena kagaya ng mga tali, tinirintas na gawa sa purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Dapat kang gumawa ng dalawang singsing na ginto para sa baluti at kailangang ikabit ang mga ito sa dalawang dulo ng baluti. ");
INSERT INTO tglulb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Dapat mong ikabit ang dalawang kadenang ginto sa dalawang kanto ng baluti. ");
INSERT INTO tglulb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Dapat ikabit mo ang kabilang dulo ng dalawang kadenang tinirintas sa dalawang lalagyan. Pagkatapos dapat ikabit mo ang mga ito sa dalawang pambalikat sa harap ng efod. ");
INSERT INTO tglulb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Dapat kang gumawa ng dalawang singsing na ginto, at dapat ilagay mo ang mga ito sa kabila ng dalawang kanto ng baluti, sa dulo ito bago sa panloob na hangganan. ");
INSERT INTO tglulb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Dapat kang gumawa ng dalawa pang singsing na ginto, at dapat mong ikabit ito sa ilalim ng dalawang pambalikat sa harap ng efod, malapit ito sa pinagtahian sa itaas ng pinong habing sintas sa baywang ng efod. ");
INSERT INTO tglulb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Dapat talian ang baluti sa bawat mga singsing nito patungo sa mga singsing ng epod sa pamamagitan ng isang asul na tali, para ito ay maikabit sa itaas lamang ng habing sinturon sa baywang ng efod. Para hindi na matanggal ang baluti mula sa efod. ");
INSERT INTO tglulb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Kapag si Aaron ay papasok sa banal na lugar, dapat dalhin niya ang mga pangalan ng mga labindalawang anak na lalaki ni Israel sa baluti para gumawa ng mga desisyon sa kaniyang puso. Magsisilbi ito bilang isang palagiang paalala kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Dapat ang Urim at Tummim ay ilagay sa baluti para sa paggawa ng mga desisyon. Ang mga ito ay dapat nasa dibdib ni Aaron kapag siya ay pupunta sa harap ni Yahweh, dapat palaging dala ni Aaron sa kaniyang dibdib ang paggawa ng mga desisyon para sa mga Israelita sa harap ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Dapat kang gumawa ng balabal ng epod na lahat ay galing sa telang lilak. ");
INSERT INTO tglulb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Dapat mayroon itong isang bukasan sa gitna para sa ulo. Dapat habiin ang gilid ng bukasan paikot para hindi ito mapunit. Dapat gawa ito ng isang manghahabi. ");
INSERT INTO tglulb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Sa dulo ng laylayan, dapat kang gumawa ng mga granada na asul, lilak, at matingkad na pulang tali sa lahat ng palibot. Mga gintong kampanilya ay dapat paikot sa pagitan nila. ");
INSERT INTO tglulb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Dapat mayroong isang gintong kampanilya at isang granada, isang gintong kampanilya at isang granada na magkakasunod-sunod sa palibot ng laylayan ng balabal. ");
INSERT INTO tglulb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Dapat isuot ni Aaron ang balabal kapag maglilingkod siya, para marinig ang tunog nito kapag papasok siya sa banal na lugar sa harap ni Yahweh at kapag aalis siya. Nang sa gayon, hindi siya mamamatay. ");
INSERT INTO tglulb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Dapat kang gumawa ng plato sa purong gintong at iukit dito, katulad ng nakaukit sa isang selyo, HANDOG KAY YAHWEH. ");
INSERT INTO tglulb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Dapat mong ikabit ang plato na ito sa isang asul na tali patungo sa harap ng turbante. ");
INSERT INTO tglulb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Dapat nasa noo ito ni Aaron; dapat palaging siyang magdadala ng anumang pagkakasala na nakakabit sa pag-aalay ng banal na mga regalo ng mga Israelita na handog kay Yahweh. Dapat ang turbante ay palaging nasa noo niya para tanggapin ni Yahweh ang kanilang mga regalo. ");
INSERT INTO tglulb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Dapat kang gumawa ng kasuotang gawa sa pinong lino, at dapat kang gumawa ng isang turbante na pinong lino. Dapat ka ring gumawa ng isang sintas, na gawa ng isang taga-burda. ");
INSERT INTO tglulb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Para sa mga anak na lalaki ni Aaron gumawa ka ng mga kasuotan, mga sintas, at mga bandana, para sa kanilang karangalan at kagandahan. ");
INSERT INTO tglulb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Dapat mong damitan si Aaron na iyong kapatid, at ang kaniyang mga anak na lalaki na kasama niya. Dapat mo silang buhusan ng langis, italaga sila, at ihandog sila sa akin, para maglingkod sila sa akin bilang mga pari. ");
INSERT INTO tglulb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Dapat mo silang igawa ng mga linong salawal para matakpan ang kanilang mga pribadong parte, salawal para takpan sila mula sa baywang hanggang sa mga hita. ");
INSERT INTO tglulb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Dapat isuot ito ni Aaron at ng kaniyang mga anak na lalaki kapag papasok sila sa tolda ng pagpupulong o kapag lalapit sila sa altar para maglingkod sa banal na lugar. Dapat nila itong gawin para hindi sila magdala ng pagkakasala at mamatay. Mananatili itong isang alituntunin para kay Aaron at sa kaniyang mga kaapu-apuhan kasunod niya. ");
INSERT INTO tglulb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ngayon ito ang dapat mong gawin sa pagtatalaga sa kanila sa akin para sila ay makapaglingkod bilang mga pari. Kumuha ka ng isang batang toro at dalawang lalaking tupa na walang bahid, ");
INSERT INTO tglulb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","tinapay na walang lebadura, at mamon na walang lebadurang hinalong langis. At saka kumuha ka ng apa na walang lebadurang pinahiran ng langis. Gawin mo ang mga apa gamit ang pino na trigong harina. ");
INSERT INTO tglulb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Dapat mo itong ilagay sa isang buslo, dalhin ang mga ito sa buslo, at ihandog mo kasama ang toro at dalawang lalaking tupa. ");
INSERT INTO tglulb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Dapat mong iharap si Aaron at ang kaniyang mga anak na lalaki sa pasukan ng tolda ng pagpupulong. Dapat mong paliguan si Aaron at ang kaniyang mga anak na lalaki sa tubig. ");
INSERT INTO tglulb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Dapat kang kumuha ng mga damit at damitan si Aaron kasama ang kapa, ang balabal ng efod, ang efod, at ang baluti, kabitan ng makinis na habing sinturon ng efod na nakapalibot sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Dapat mong itakda ang turbante sa kaniyang ulo at ilagay ang banal na korona sa turbante. ");
INSERT INTO tglulb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Pagkatapos kumuha ng pambasbas na langis at ibuhos sa kaniyang ulo, at sa ganitong paraan siya babasbasan. ");
INSERT INTO tglulb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Dapat mong dalhin ang kaniyang mga anak na lalaki at ilagay ang mga kapa sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Dapat mong damitan si Aaron at ang kaniyang mga anak na lalaki na may kasamang mga sintas at ilagay ang kanilang pamigkis sa ulo. Ang gawain ng pagkapari ay mabibilang na sa kanila sa pamamagitan ng palagiang batas. Sa ganitong paraan dapat mong gawing banal si Aaron at ang kaniyang mga anak na lalaki para sa kanilang paglilingkod sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Dapat mong dalhin lahat ng toro sa harap ng tolda ng pagpupulong, at ipatong ang kamay ni Aaron at ang kamay ng kaniyang mga anak na lalaki sa ulo nito. ");
INSERT INTO tglulb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Dapat mong patayin ang mga toro sa aking harapan, si Yahweh, sa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Dapat mong kunin ang ilang dugo ng toro at ilagay mo ito sa sungay ng altar gamit ang iyong daliri, at dapat mong ibuhos ang natirang dugo sa paanan ng altar. ");
INSERT INTO tglulb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Dapat mong kunin ang lahat ng taba na nakatakip sa mga lamang-loob, at saka kumuha ng panakip sa atay at sa dalawang lapay na may kasamang taba na nasa kanila; sunugin ang lahat ng ito sa altar. ");
INSERT INTO tglulb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero ang laman ng mga toro, at ang balat at dumi, sunugin mo ito sa labas ng kampo. Ito ay handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Dapat mo ring kunin ang isang lalaking tupa, at ipatong ang kamay ni Aaron at ang mga kamay ng kaniyang mga anak na lalaki sa ulo nito. ");
INSERT INTO tglulb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Dapat mong patayin ang lalaking tupa. Pagkatapos kunin ang dugo at isaboy ito sa magkabilang gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Dapat mong hiwain ang lalaking tupa na pira-piraso at hugasan ang mga lamang-loob at ang mga binti, at ilagay mo ang lamang-loob, sabay ng pira-piraso at kasama ang ulo nito, ");
INSERT INTO tglulb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","sa altar. Pagkatapos sunugin ang buong lalaking tupa. Ito ay maging sinunog na handog sa akin, si Yahweh. Ito ay magdudulot ng matamis na halimuyak sa akin; ito ay magiging isang handog sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Dapat mong kunin ang iba pang lalaking tupa, at ipatong ang kamay ni Aaron at ang mga kamay ng kaniyang mga anak na lalaki sa ulo nito. ");
INSERT INTO tglulb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Pagkatapos dapat mong patayin ang lalaking tupa at kunin ang ilan sa dugo nito. Ilagay ito sa dulo ng kanang tainga ni Aaron, at sa dulo ng kanang tainga ng kaniyang mga anak na lalaki, sa hinlalaki ng kanilang kanang kamay, at sa hinlalaki ng kanilang kanang paa. Pagkatapos isaboy ang dugo sa magkabilang gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Dapat mong kunin ang ilan sa mga dugo na nasa altar at ilan sa binasbasang langis, at isaboy ang lahat ng ito kay Aaron at sa kaniyang mga damit, at saka sa kaniyang mga anak na lalaki at sa kanilang mga damit. Ilalaan si Aaron para sa akin, at ang kaniyang mga damit, kasama niya ang kaniyang mga anak na lalaki at mga damit ng kaniyang mga anak na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Dapat mong kunin ang mga lalaking tupa, ang taba ng buntot, ang taba na nakatakip sa lamang-loob, ang panakip sa atay, ang dalawang lapay, at ang kanang hita—dahil ang lalaking tupang ito ay para sa pagtatalaga sa mga pari para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kumuha ng isang tinapay, isang mamon ng tinapay na gawa sa langis, at isang apa sa labas ng buslo ng tinapay na walang lebadura na sa aking harapan, si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Dapat mong ilagay ang mga ito sa kamay ni Aaron at sa kamay ng kaniyang mga anak na lalaki. Dapat nilang itaas ito sa aking harapan, si Yahweh, at ipapakita nila ito bilang paghahandog sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Dapat mong kunin ang mga pagkain galing sa kanilang mga kamay at sunugin ito sa altar kasama ang handog na susunugin. Ito ay magbibigay ng matamis na halimuyak sa akin; ito ay handog na gawa sa apoy. ");
INSERT INTO tglulb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Dapat kang kumuha ng dibdib ng lalaking tupa na handog ni Aaron at itaas ito at ipapakita ito bilang handog para sa akin, si Yahweh. Pagkatapos ito ang bahagi na inyong kakainin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Dapat mong ihandog sa akin ang dibdib ng paghahandog na itinaas na matayog at ang hita ng paghahandog na ipinapakita— dibdib na itinaas at ang hita na ipinakita, kapwa nanggaling sa lalaking tupa para sa pagpapatunay kay Aaron at sa kaniyang mga anak na lalaki sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ang mga bahagi ng laman na ito, na ibinigay ng mga Israelita, ay kailangang mabibilang kay Aaron at sa kaniyang mga kaapu-apuhan magpakailanman. Sa pamamalakad para sa mga handog sa pagtitipon, ito ay maging handog para sa mga pari na kinuha mula sa mga handog ng mga Israelita na mga handog na ipinakita sa akin, si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Ang banal na mga damit ni Aaron ay dapat na isantabi para sa kaniyang mga anak na lalaki na susunod sa kaniya. Dapat silang basbasan at italaga ang mga ito sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ang pari na susunod sa kaniya mula sa kaniyang mga anak na lalaki, na nanggaling sa tolda ng pagpupulong para ako ay paglingkuran sa banal na lugar, ay kanilang isuot ang ganoong mga damit sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Dapat mong kunin ang lalaking tupa para sa pagtatalaga sa mga pari para sa akin at pakuluan ang laman nito sa banal na lugar. ");
INSERT INTO tglulb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Kakainin ni Aaron at ng kaniyang mga anak na lalaki ang laman ng lalaking tupa at tinapay na nakalagay sa buslo sa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Dapat nilang kainin ang laman at tinapay na binigay para pambayad ng kasalanan nila at sa pagtatalaga sa kanila, para ilaan sa akin. Walang ibang kakain ng pagkain, dahil dapat nila itong ituring na banal at ilaan para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kung alinman sa laman ng itinalagang handog, o alinman sa tinapay ay maiwan sa susunod na umaga, dapat sunugin na ninyo ito. Hindi ito dapat kainin dahil ito ay itinalaga na sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Sa ganitong paraan, sa pagsunod sa lahat ng iniutos ko sa iyo na gawin, dapat mong pakitunguhan si Aaron at ang kaniyang mga anak na lalaki. Dapat kang kumuha ng pitong araw para italaga sila sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Bawat araw dapat kang maghandog ng toro bilang isang handog pambayad para sa kasalanan. Dalisayin mo ang altar sa pamamagitan ng paggamit ng pambayad para sa kasalanan nito, at kailangan mo itong buhusan ng langis para sa pagtatalaga sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Sa pitong araw dapat kang gumawa ng pambayad para sa kasalanan para sa altar at italaga ito kay Yahweh. Pagkatapos ang altar ay ganap na italaga sa akin. Anumang paghahawak sa altar ay ibubukod para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Dapat kang maghandog palagi ng dalawang tupa na isang taon ang gulang doon sa altar araw-araw. ");
INSERT INTO tglulb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Dapat kang maghandog ng isang tupa sa umaga, at ang isang tupa ay ihandog mo sa paglubog ng araw. ");
INSERT INTO tglulb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kasama ang unang tupa, maghandog ng ikasampu ng epa ng pinong harina na hinaluan ng ikaapat na bahagi ng hin ng langis galing sa pinigang olibo, at ang ikaapat na bahagi ng hin ng alak bilang inuming handog. ");
INSERT INTO tglulb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Dapat kang maghandog ng pangalawang tupa sa paglubog ng araw. Dapat kang maghandog ng pagkaing butil sa umaga at parehong inuming handog. Ang mga ito ay magdudulot ng matamis na halimuyak sa akin; ito ang magiging handog na gawa para sa akin sa apoy. ");
INSERT INTO tglulb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ang mga ito ay magiging palagiang handog na susunugin sa buong salinlahi ng inyong bayan. Dapat mong gawin ang mga ito sa pasukan ng tolda ng pagpupulong sa aking harapan, si Yahweh, kung saan ako makikipagkita para makipag-usap sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Doon kung saan ako makikipagkita sa mga Israelita; ang tolda ay ihihiwalay para sa akin sa aking kaluwalhatian. ");
INSERT INTO tglulb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Itatalaga ko ang tolda ng pagpupulong at ang altar para ang mga ito ay mabilang sa akin lamang. Itatalaga ko rin si Aaron at ang kaniyang mga anak na lalaki para maglingkod sa akin bilang mga pari. ");
INSERT INTO tglulb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Maninirahan ako kasama ng mga Israelita at kanilang magiging Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Malalaman nila na ako si Yahweh, ang kanilang Diyos, na kumuha sa kanila palabas mula sa lupain ng Ehipto kaya ako ay maninirahan kasama nila. Ako si Yahweh, kanilang Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Dapat kang gumawa ng altar para magsunog ng insenso. Dapat mong gawin ito sa kahoy ng akasya. ");
INSERT INTO tglulb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ang haba nito ay dapat isang kubit, at ang lapad nito ay isang kubit. Ito ay dapat maging parisukat, at ang taas nito ay dapat dalawang kubit. Ang mga sungay nito ay dapat gawin bilang kaisang piraso nito. ");
INSERT INTO tglulb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Dapat mong balutin ang altar ng insenso sa purong ginto—ang tuktok nito, ang mga gilid nito, at ang mga sungay nito. Dapat kang gumawa ng isang hangganang ginto sa palibot para dito. ");
INSERT INTO tglulb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Dapat kang gumawa ng dalawang argolyang ginto para maisama dito sa ibaba ng hangganan nito sa dalawang magkabilang bahagi nito. Ang mga argolya ay dapat maging mga lalagyan ng mga baras para madala ang altar. ");
INSERT INTO tglulb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Dapat ninyong gawin ang mga baras sa kahoy ng akasya, at dapat ninyong balutin ang mga ito sa ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Dapat ninyong ilagay ang altar ng insenso bago sa kurtina na nasa kaban ng mga kautusang tipan. Ito ay bago sa takip ng luklukan ng awa na nasa ibabaw ng kaban ng mga kautusang tipan, kung saan ako ay makikipagtagpo sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Dapat si Aaron ang magsunog ng mabangong insenso sa tuwing umaga. Dapat niyang sunugin ito kapag inaayos niya ang mga lampara. ");
INSERT INTO tglulb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kapag sisindihan ni Aaron ang mga lampara muli sa gabi, dapat siyang magsunog ng insenso sa altar ng insenso. Dapat itong maging isang palagiang pagsusunog ng insenso sa harap ko, si Yahweh, sa buong salinlahi ng inyong bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Pero kayo ay mag-aalay ng walang ibang insenso sa altar ng insenso, o anumang pagsusunog ng alay o handog na pagkaing butil. Dapat mong buhusan ng walang inuming handog dito. ");
INSERT INTO tglulb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Dapat si Aaron ay gumawa ng luklukan ng awa sa mga sungay ng altar ng insenso minsan sa isang taon. Dapat niyang gawin ito gamit ang dugo ng handog para sa pagbayad ng kasalanan. Ang punong pari ang siyang dapat na gumawa nito sa buong salinlahi ng inyong lahi. Ang pag-aalay na ito ay ganap na ilaan sa akin, si Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Nagsalita si Yahweh kay Moises at sinabing, ");
INSERT INTO tglulb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Kapag kumuha ka ng isang talaan ng mga Israelita, pagkatapos ang bawat tao ay dapat magbigay ng pangtubos para sa kaniyang buhay kay Yahweh. Dapat mong gawin ito pagkatapos mo silang bilangin, para walang maging salot sa kanila kapag binibilang mo sila. ");
INSERT INTO tglulb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ang bawat isa na nabilang sa talaan ay magbabayad ng kalahating pilak na sekel, ayon sa timbang ng sekel ng santuwaryo (isang sekel ay kapareho ng dalawampung gera). Itong kalahating sekel ay magiging alay sa akin, si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ang bawat isa na nabilang, mula dalawampung taong gulang at pataas, ay dapat magbigay nitong alay sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Kapag magbibigay ang mga tao nitong alay sa akin para gumawa ng pambayad sa kasalanan para sa kanilang mga buhay, ang mayayaman ay hindi dapat magbigay ng higit pa sa kalahating sekel, at ang mga mahihirap ay hindi dapat magbigay ng kulang. ");
INSERT INTO tglulb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Dapat mong tanggapin itong perang pambayad sa kasalanan mula sa mga Israelita at dapat mong ilaan ito para sa gawain sa tolda ng pagpupulong. Ito ay dapat maging isang paalala sa mga Israelita sa akin, para gumawa ng pangtubos ng kasalanan para sa inyong mga buhay.” ");
INSERT INTO tglulb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Nagsalita si Yahweh kay Moises at sinabi, ");
INSERT INTO tglulb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Dapat ka ring gumawa ng isang malaking tansong palanggana na mayroong tansong tuntungan, isang palanggana para hugasan. Dapat mo itong ilagay sa pagitan ng tolda ng pagpupulong at ng altar, at kailangan mo itong lagyan ng tubig. ");
INSERT INTO tglulb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Si Aaron at kaniyang mga anak na lalaki ay dapat maghugas ng kanilang mga kamay at kanilang mga paa ng tubig nito. ");
INSERT INTO tglulb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kapag pumasok sila sa tolda ng pagpupulong o kapag lumalapit sila sa altar para maglingkod sa akin sa pagsusunog ng handog, dapat silang maghugas ng tubig sa gayon ay hindi sila mamatay. ");
INSERT INTO tglulb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Dapat nilang hugasan ang kanilang mga kamay at paa para hindi sila mamatay. Dapat itong maging palagiang batas para kay Aaron at sa kaniyang mga kaapu-apuhan sa buong salinlahi ng kanilang bayan.” ");
INSERT INTO tglulb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Nagsalita si Yahweh kay Moises at sinabi, ");
INSERT INTO tglulb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Kunin mo itong mga pinong pampalasa: limandaang sekel ng umaagos na mira, 250 sekel ng matamis na halimuyak na kanela, 250 sekel ng matamis na halimuyak na tubo, ");
INSERT INTO tglulb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","limandaang sekel ng kassia, sinukat sa timbang ng sekel ng santuwaryo, at isang hin ng langis ng olibo. ");
INSERT INTO tglulb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Dapat kang gumawa ng banal na langis ng pagpapahid kasama ang mga sangkap na ito, ang gawa ng tagapagpabango. Ito ay magiging banal na langis ng pagpapahid, inilaan para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Dapat mong basbasan ang tolda ng pagpupulong ng langis na ito, gayon din sa kaban ng kautusang tipan, ");
INSERT INTO tglulb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ang mesa at ang lahat ng mga kasangkapan nito, ang tuntungan ng ilaw at ng kasangkapan nito, ang altar ng insenso, ");
INSERT INTO tglulb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ang altar para sa sinunog na mga alay kasama ng lahat ng mga kasangkapan nito, at ang palanggana kasama ng kaniyang tuntungan. ");
INSERT INTO tglulb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Dapat mong ilaan ang mga ito sa akin para ang mga ito ay ganap na mailaan sa akin. Ang anumang humawak sa kanila ay ibubukod din para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Dapat mong basbasan si Aaron at ang kaniyang mga anak na lalaki at ilaan mo sila sa akin para sila ay maglingkod sa akin bilang mga pari. ");
INSERT INTO tglulb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Dapat mong sabihin sa mga Israelita, 'Ito dapat ang langis ng pagpapahid na inilaan kay Yahweh sa buong salinlahi ng iyong bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ito ay hindi dapat mailapat sa balat ng mga tao, o gumawa man lang kayo sa alinmang langis na kaparehong sangkap, dahil inilaan ito kay Yahweh. Dapat mong isaalang-alang ito sa ganitong paraan. ");
INSERT INTO tglulb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ang sinumang gumawa ng pabango gaya nito, o kung sinumang maglagay ng alinman nito sa isang tao, ang taong iyon ay dapat alisin sa kaniyang bayan.” ");
INSERT INTO tglulb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Sinabi ni Yahweh kay Moises, “Kumuha ng mga pampalasa—estacte, onycha, at galbano—matamis na mga pampalasa kasama ng purong kamanyang, ang bawat isa ay magsindami. ");
INSERT INTO tglulb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Gawin ito sa paraan ng insenso, hinalo ng isang tagapagpabango, pinalasa ng asin, puro at inilaan sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Gigilingin mo ito sa napakapinong paghalo. Maglagay ng bahagi nito sa harap ng kaban ng mga kautusang tipan, na nasa tolda ng pagpupulong, kung saan ako ay makikipagtagpo sa inyo. Ituturing mo ito bilang ganap na pag-aalay sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Bilang para sa insensong ito na iyong gagawin, hindi ka dapat gumawa ng anumang kaparehong mga sangkap para sa iyong sarili. Ito ay dapat maging pinakabanal sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ang sinumang gumawa ng anumang gaya nito para gamitin bilang pabango ay dapat alisin mula sa kaniyang bayan.” ");
INSERT INTO tglulb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Nagsalita si Yahweh kay Moises, ");
INSERT INTO tglulb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Tingnan mo, tinawag ko sa pangalan si Bezalel anak na lalaki ni Uri na anak na lalaki ni Hur, mula sa lipi ni Juda. ");
INSERT INTO tglulb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Pinuno ko si Bezalel ng aking Espiritu, para bigyan siya ng karunungan, pang-unawa, at kaalaman, para sa lahat ng uri ng gawain, ");
INSERT INTO tglulb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","para gumawa ng pang-sining na mga disenyo at para sa paggawa sa ginto, pilak, at tanso; ");
INSERT INTO tglulb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","para rin sa pagputol at paglagay ng mga bato at para sa pang-ukit ng kahoy-para gawin ang lahat ng uri ng gawain. ");
INSERT INTO tglulb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Bukod sa kaniya, hinirang ko si Oholiab anak na lalaki ni Ahisamach, mula sa lipi ni Dan. Nilagyan ko ng kasanayan ang mga puso ng mga matalinong tao kaya magagawa nila ang lahat ng pag-uutos ko sa iyo. Kabilang dito ");
INSERT INTO tglulb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ang tolda ng pagpupulong, ang kaban ng tipan ng kautusan, ang takip ng luklukan ng awa na nasa kaban, at ang lahat na kasangkapan ng tolda- ");
INSERT INTO tglulb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ang mesa at ang mga kagamitan nito, ang purong ilawan kasama ang mga kagamitan nito, ang altar ng incenso, ");
INSERT INTO tglulb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ang altar para sa mga sinunog na handog kasama ang lahat ng kasangkapan nito, at ang malaking palanggana kasama ang paanan nito. ");
INSERT INTO tglulb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Kabilang din dito ang hinabing pinong pananamit, ang mga banal na pananamit para kay Aaron ang pari at sa kaniyang mga anak na lalaki, na nakalaan para sa akin kaya sila ay maglilingkod bilang mga pari. ");
INSERT INTO tglulb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Kabilang din ang langis na pangpahid at ang mabangong insenso para sa banal na lugar. Gagawin ng mga manggagawang ito ang lahat ng bagay na aking inutos sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Nagsalita si Yahweh kay Moises, ");
INSERT INTO tglulb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Sabihin mo sa mga Israelita: 'Dapat ninyong panatilihing tiyak ang mga Araw ng Pamamahinga ni Yahweh, dahil ito ang magiging tanda sa pagitan niya at sa inyo sa buong salinlahi ng iyong bayan kaya malalaman ninyo na siya ay si Yahweh, siyang nagtakda sa iyo para sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Kaya dapat ninyong panatiliin ang Araw ng Pamamahinga, para dapat ninyong ituring ito bilang banal, na nakalaan para sa kaniya. Bawat isa na dumungis dito ay dapat talagang mamatay. Kung sinuman ang gumagawa sa Araw ng Pamamahinga, ang taong iyan ay tiyak na dapat putulin mula sa kaniyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ang gawain ay natapos ng anim na araw, pero ang ikapitong araw ay magiging isang Araw ng Pamamahinga ng ganap na pamamahinga, banal, nakalaan para sa karangalan ni Yahweh. Sinuman ang gumagawa ng kahit anong gawain sa Araw ng Pamamahinga ay dapat siguraduhing malagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Kaya ang mga Israelita ay dapat panatilihin ang Araw ng Pamamahinga. Dapat nilang suriin ito saanman sa salinlahi ng kanilang bayan bilang isang palagiang batas. ");
INSERT INTO tglulb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ang Araw ng Pamamahinga ay laging magiging isang tanda sa pagitan ni Yahweh at ng mga Israelita, dahil sa anim na araw na ginawa ni Yahweh ang langit at lupa, at sa ikapitong araw siya ay nagpahinga at naginhawaan.”' ");
INSERT INTO tglulb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Nang matapos makipag-usap ni Yahweh kay Moises sa bundok ng Sinai, binigyan niya siya ng dalawang tipak ng bato ng tipan ng mga kautusan, gawa sa bato, nakasulat sa pamamagitan ng kaniyang sariling kamay. ");
INSERT INTO tglulb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Nang makita ng mga tao na si Moises ay natagalang bumaba sa bundok, nagtipon sila sa paligid ni Aaron at sinabi sa kaniya, “Halika, igawa mo kami ng diyos-diyosan na mangunguna sa amin. Dahil itong si Moises, ang taong nagdala sa amin palabas sa lupain ng Ehipto, hindi namin alam kung ano ang nangyari sa kaniya.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Kaya sinabi ni Aaron sa kanila, “Kunin ninyo ang mga gintong hikaw sa mga tainga ng inyong mga asawa at sa mga tainga ng inyong mga anak na lalaki at sa mga anak na babae at dalhin ang mga ito sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kinuhang lahat ng mga tao ang mga gintong hikaw na nasa kanilang mga tainga at dinala ang mga ito kay Aaron. ");
INSERT INTO tglulb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Natanggap niya ang ginto mula sa kanila, niyari ito sa isang molde, at ginawa ito sa isang minoldeng guya. Pagkatapos sinabi ng mga tao, “Israel, ito ang inyong diyos na nagdala sa inyo palabas sa lupain ng Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Nang nakita ito ni Aaron, nagtayo siya ng isang altar sa harap ng guya at ginawa sa isang pagpapahayag, sinabi niya, “Bukas magkakaroon ng pagdiriwang sa karangalan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kinabukasan gumising ng maaga ang mga tao at nag-alay ng mga sinunog na handog at sama-samang nagdala ng mga alay. Pagkatapos sila ay umupo para kumain at uminom, at pagkatapos tumindig para makipag-inuman sa mahalay na pagdiriwang. ");
INSERT INTO tglulb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Pagkatapos nagsalita si Yahweh kay Moises, “Umalis ka agad, dahil sa iyong bayan, na nagdala palabas sa lupain ng Ehipto, naging masama ang kanilang mga sarili. ");
INSERT INTO tglulb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Mabilis silang umalis sa daan na aking inutos sa kanila. Nagmolde sila para sa kanilang sarili ng isang guya at sumamba dito at naghandog dito. Sinabi nila, 'Israel, “Ito ang inyong diyos na nagdala palabas sa lupain ng Egipto.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Pagkatapos sinabi ni Yahweh kay Moises, “Nakita ko ang bayang ito. Tingnan mo, sila ay mga taong mapagmatigas. ");
INSERT INTO tglulb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Kaya pagkatapos, huwag mong subukang pigilan ko. Ang aking galit ay sisiklab laban sa kanila, kaya wawasakin ko sila. “Pagkatapos gagawa ako ng isang dakilang bansa mula sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pero sinubukang huminahon ni Moises si Yahweh na kaniyang Diyos. Sinabi niya, “Yahweh, bakit ang inyong galit ay sumiklab laban sa iyong bayan, na nagdala palabas sa lupain ng Ehipto na may dakilang kapangyarihan at may malakas na kamay? ");
INSERT INTO tglulb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Bakit kailangang sabihin ng mga taga-Ehipto, “Pinangunahan niya sila nang may masamang layunin, para patayin sila sa mga bundok at para wasakin sila sa ibabaw ng mundo? Magbalik ka mula sa iyong nagsusumiklab na galit at mahabag ang loob mula sa kaparusahan ng iyong bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Alalahanin mo sina Abraham at Isaac at Israel, iyong mga lingkod, na siyang sumumpa sa pamamagitan ng iyong sarili mismo at sinabi sa kanila, “Gagawin ko ang iyong mga kaapu-apuhan na kasing dami ng mga bituin sa kalangitan, at bibigyan ko ang iyong mga kaapu-apuhan lahat ng lupaing aking sinabi. Mamanahin nila ito magpakailanman.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Pagkatapos nahabag si Yahweh mula sa kaparusahan na kaniyang sinabi na dapat pahirapan ang kaniyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Pagkatapos tumalikod si Moises at bumaba sa bundok, dala-dala ang dalawang tipak ng bato ng tipan ng kautusan sa kaniyang kamay. Ang mga tipak ng bato ay may nakasulat sa magkabilang gilid, sa harap at sa likuran. ");
INSERT INTO tglulb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ang mga tipak ng bato ay sariling gawa ng Diyos, at ang mga sulat ay sariling sulat ng Diyos, inukit sa mga tipak ng bato. ");
INSERT INTO tglulb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Nang marinig ni Josue ang ingay ng mga tao na humihiyaw, sinabi niya kay Moises, “May ingay ng labanan doon sa kampo.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pero sinabi ni Moises, “Hindi ito tunog ng isang tagumpay at hindi tunog ng natatalong mga tao, pero ang tunog ng umaawit ang aking naririnig.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Nang dumating si Moises sa kampo, nakita niya ang guya at ang mga taong nagsasayawan. Siya ay lubhang nagalit. Itinapon niya ang mga tipak ng bato na nasa kaniyang mga kamay, at nabiyak ang mga ito sa ibaba ng bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kinuha niya ang guya na ginawa ng mga tao, sinunog ito, dinurog ito para maging abo at ibinuhos ito sa tubig. Pagkatapos ipinainom niya ito sa bayan ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Pagkatapos sinabi ni Moises kay Aaron, “Ano ang ginawa ng mga taong ito sa iyo, na dinala mo ang ganyang dakilang kasalanan sa kanila?” ");
INSERT INTO tglulb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Sinabi ni Aaron, “Huwag mong hayaan ang iyong galit ay sumiklab, aking panginoon. Alam mo ang mga taong ito, kung paano sila gumagawa ng kasamaan. ");
INSERT INTO tglulb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Sinabi nila sa akin, igawa mo kami ng diyos na mangunguna sa amin. Dahil itong si Moises, ang taong nagdala palabas sa amin sa lupain ng Ehipto. hindi namin alam kung ano ang nangyari sa kaniya.' ");
INSERT INTO tglulb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kaya sinabi ko sa kanila, 'Kung sinuman ang mayroong anumang ginto, hayaang tanggalin niya ito. Binigay nila sa akin ang ginto at itinapon ko ito sa apoy, at ito ay naging isang guya.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Nakita ni Moises ang mga tao ay tumatakbo ng marahas, dahil hinayaan ni Aaron sila ay mawalan ng pagpipigil, para tuksuhin ang kanilang mga kaaway. ");
INSERT INTO tglulb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Pagkatapos tumayo si Moises sa pasukan ng kampo at sinabi, “Sinuman ang nasa panig ni Yahweh, pumunta sa akin.” Lahat ng mga Levita ay nagtipon sa paligid niya, ");
INSERT INTO tglulb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Sinabi niya sa kanila, “Yahweh, ang Diyos ng Israelita, sanasabi ito, 'Hayaang ang bawat lalaki ay ikabit ang kaniyang espada sa kaniyang gilid at magbalik at bumalik mula sa pasukan hanggang pasukan ng buong kampo, at patayin ang kaniyang kapatid na lalaki, kaniyang kasamahan at kaniyang kapitbahay.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ginawa ng mga Levita ang inutos ni Moises. Sa araw na iyon ay mahigit tatlong libong lalaki mula sa bayan ang namatay, ");
INSERT INTO tglulb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Sinabi ni Moises sa mga Levita, “Itinalaga kayo sa paglilingkod kay Yahweh sa araw na ito, dahil bawat isa sa inyo ay kumilos laban sa kaniyang anak na kaniyang kapatid na lalaki, kaya bibigyan kayo ni Yahweh ng pagpapala sa araw na ito.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kinabukasan sinabi ni Moises sa mga tao, “Nakagawa kayo ng isang dakilang kasalanan. Ngayon aakyat ako kay Yahweh. Marahil maari akong gumawa ng pambayad sa inyong pagkakasala.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Bumalik si Moises kay Yahweh at sinabing, “Naku, ang mga taong ito ay nakagawa ng malaking kasalanan at gumawa ng kanilang mga sariling gintong diyos-diyosan. ");
INSERT INTO tglulb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Pero ngayon, pakiusap patawarin mo ang kanilang kasalanan; pero kung hindi ninyo gagawin, pawiin mo ako sa aklat na iyong isinulat.” ");
INSERT INTO tglulb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Sinabi ni Yahweh kay Moises, “Kung sinuman ang nagkasala laban sa akin, ang taong iyon ay papawiin ko sa aking aklat. ");
INSERT INTO tglulb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Kaya ngayon lumakad ka, pangunahan mo ang bayan papunta sa lugar na sinabi ko sa iyo. Tingnan, ang aking anghel ang mangunguna sa inyo. Pero sa araw na parusahan ko sila, paparusahan ko sila dahil sa kanilang pagkakasala. ");
INSERT INTO tglulb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Pagkatapos nagpadala si Yahweh ng salot sa bayan dahil gumawa sila ng guya, ang isa na ginawa ni Aaron. ");
INSERT INTO tglulb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kinausap ni Yahweh si Moises, “Umalis ka rito, kayo at ang bayan na dinala mo palabas mula sa lupain ng Ehipto. Puntahan mo ang lupain na kung saan ipinangako ko kina Abraham, Isaac, at Jacob, nang aking sinabi, 'Ibibigay ko ito sa inyong mga kaapu-apuhan.' ");
INSERT INTO tglulb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ipapadala ko ang isang anghel sa inyo, at itataboy ko palabas ang mga Cananaeo, Amoreo, Heteo, Perezeo, Hivita, at Jebuseo. ");
INSERT INTO tglulb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Puntahan mo ang lupain na iyon, kung saan dumadaloy ang gatas at pulot, pero hindi ako sasama sa inyo, dahil kayo ay isang bayang matitigas ang ulo. Baka lang wasakin kayo sa daan.” ");
INSERT INTO tglulb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Nang marinig ng mga tao ang mga nakakagambalang salitang ito, sila ay nagluksa, at walang ni isa man ang nagsuot ng anumang alahas. ");
INSERT INTO tglulb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Sinabi ni Yahweh kay Moises, “Sabihin mo sa mga Israelita, 'Kayo ay isang bayang matitigas ang ulo. Kung sasama ako sa inyo kahit sandali lamang, wawasakin ko kayo. Kaya ngayon, alisin ninyo ang inyong mga alahas kaya makakapagpasya ako kung ano ang gagawin ko sa inyo.''' ");
INSERT INTO tglulb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kaya walang suot na alahas ang mga Israelita pasulong mula sa Bundok Horeb. ");
INSERT INTO tglulb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Kinuha ni Moises ang isang tolda at itinayo ito sa labas ng kampo, nang may kalayuan sa kampo. Tinawag niya itong tolda ng pagpupulong. Ang sinumang magtanong kay Yahweh ng anumang bagay ay lalabas ng tolda ng pagpupulong, sa labas ng kampo. ");
INSERT INTO tglulb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Sa tuwing lalabas si Moises sa tolda, lahat ng tao ay tumatayo sa harap ng pasukan ng kanilang tolda at tinitingnan si Moises hanggang siya ay makapasok sa loob. ");
INSERT INTO tglulb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kapag pumapasok si Moises sa tolda, ang haliging ulap ay bumababa at nananatili sa labas ng tolda, at nagsasalita si Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kapag nakita ng mga tao ang haliging ulap na nananatili sa pasukan ng tolda, sila ay tumatayo at sumasamba, bawat lalaki sa kanilang sariling pasukan ng tolda. ");
INSERT INTO tglulb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kinakausap ni Yahweh si Moises ng harap-harapan, tulad ng isang lalaking nakikipag-usap sa kaniyang kaibigan. Pagkatapos bumabalik si Moises sa kampo, pero ang kaniyang lingkod na si Josue anak ni Nun, isang binata, ay nananatili sa tolda. ");
INSERT INTO tglulb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Sinabi ni Moises kay Yahweh, “Tingnan mo, sinasabi mo sa akin, 'Dalhin mo ang mga taong ito sa kanilang paglalakbay,' pero hindi mo pinaalam sa akin kung sino ang ipapadala mo na kasama ko. Sinabi mo, 'Nakikilala mo ako sa pangalan, at ikaw din ang nakatagpo ng pabor sa aking paningin.' ");
INSERT INTO tglulb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ngayon kung ako ay nakatagpo ng pabor sa iyong paningin, ipakita mo sa akin ang iyong mga paraan nang sa ganon ay makilala kita at patuloy na makatagpo ng pabor sa iyong paningin. Tandaan mo ang bayang ito ay iyong bayan. ");
INSERT INTO tglulb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Sumagot si Yahweh, “Ang sarili kong presensiya ay sasama sa iyo, at bibigyan kita ng pahinga.” ");
INSERT INTO tglulb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Sinabi ni Moises sa kaniya, “Kung ang inyong presensiya ay hindi sasama sa amin, huwag mo kaming alisin mula rito. ");
INSERT INTO tglulb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Dahil kung hindi, paano malalaman na ako ay nakatagpo ng pabor sa iyong paningin, ako at ang inyong bayan? Hindi ba nararapat lamang na sumama ka sa amin para ako at ang iyong bayan ay maiba mula sa lahat ng ibang bayan na nasa ibabaw ng mundo? ");
INSERT INTO tglulb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Sinabi ni Yahweh kay Moises, “Gagawin ko din ang bagay na ito na iyong hiniling, dahil ikaw ang nakatagpo ng pabor sa aking paningin, at nakikilalamo ako sa pangalan.” ");
INSERT INTO tglulb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Sinabi ni Moises, “Pakiusap ipakita mo sa akin ang inyong kaluwalhatian.” ");
INSERT INTO tglulb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Sinabi ni Yahweh, “Gagawin ko ang lahat ng aking kabutihan sa inyo, at ipapahayag ko ang aking pangalang 'Yahweh' sa inyo. Magiging maawain ako sa kaninoman na magiging maawain, at magpapakita ako ng habag sa kaninoman na magpapakita ng habag.” ");
INSERT INTO tglulb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pero sinabi ni Yahweh, “Hindi mo maaring makita ang aking mukha, dahil walang sinuman ang maaaring makakita sa akin at mabuhay.” ");
INSERT INTO tglulb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Sinabi ni Yahweh, “Tingnan mo, dito ang isang lugar sa pamamagitan ko; tatayo ka sa batong ito. ");
INSERT INTO tglulb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Habang dumaraan ang aking kaluwalhatian, ilalagay kita sa siwang ng bato at tatakpan kita gamit ang kamay ko hanggang sa makaraan ako. ");
INSERT INTO tglulb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Pagkatapos aalisin ko ang aking kamay, at makikita mo ang aking likuran, pero hindi mo makikita ang aking mukha. ");
INSERT INTO tglulb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Sinabi ni Yahweh kay Moises, “Pumutol ka ng dalawang tipak ng bato katulad ng mga naunang tipak. Isusulat ko sa mga tipak na ito ang mga salita na nasa mga naunang tipak, ang tipak na iyong binasag. ");
INSERT INTO tglulb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Maghanda ka sa umaga at umakyat ka sa Bundok ng Sinai, at ipakita mo roon ang iyong sarili sa akin sa tuktok ng bundok. ");
INSERT INTO tglulb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Walang sinumang aakyat kasama mo. Huwag mong hayaang kahit sino na makita kahit saan sa bundok. Walang mga kawan o pangkat ng mga hayop ang dapat manginain sa harap ng bundok”. ");
INSERT INTO tglulb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kaya pumutol si Moises ng dalawang tipak ng bato katulad sa mga nauna, at maaga siyang bumangon sa umaga at umakyat sa Bundok Sinai, ayon sa tagubilin ni Yahweh sa kaniya. Kinarga ni Moises ang mga tipak ng bato na nasa kaniyang kamay. ");
INSERT INTO tglulb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Bumaba si Yahweh sa ulap at tumayo doon kasama si Moises, at binigkas niya ang pangalang “Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Dumaan si Yahweh sa kaniya at inihayag, “Yahweh, Yahweh, ang Diyos ay maawain at mapagbigay-loob, hindi madaling magalit, at nag-uumapaw sa katapatan ng tipan at mapagkakatiwalaan, ");
INSERT INTO tglulb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","pinananatili ang katapatan ng tipan para sa libu-libong mga salinlahi, nagpapatawad sa mga kasamaan, mga pagsuway at mga pagkakasala. Pero gagawin niyang walang kasalanan ang nagkasala. Magdadala siya ng parusa sa kasalanan ng ama sa kanilang mga anak at anak ng kanilang mga anak, hanggang sa pangatlo at pang-apat na salinlahi.” ");
INSERT INTO tglulb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Iniyuko agad ni Moses ang kaniyang ulo sa lupa at sumamba. ");
INSERT INTO tglulb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“Pagkatapos sinabi niya, “Kung ako ngayon ay nakatagpo ng pabor sa inyong paningin, Panginoon ko, pakiusap sumama kayo sa amin, dahil ang mga taong ito ay matigas ang ulo. Ipagpaumanhin ang aming kalapastanganan at ang aming kasalanan, at dalhin mo kami bilang iyong pamana. ");
INSERT INTO tglulb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Sabi ni Yahweh, “Tingnan mo, gagawa ako ng tipan. Sa harap ng lahat ng iyong bayan, gagawa ako ng kamangha-mangha na hindi pa nagagawa sa buong sanlibutan o kahit sa anumang bansa. Ang lahat ng tao na kasama mo ay makakakita ng aking mga gawa, dahil ito ay nakakatakot na bagay na ginagawa ko kasama kayo. ");
INSERT INTO tglulb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Sundin ninyo kung ano ang iuutos ko sa inyo ngayon. Palalayasin ko sa harap ninyo ang mga Amoreo, Cananeo, Heteo, Perezeo, Hivita, at mga Jebuseo. ");
INSERT INTO tglulb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Mag-ingat kayo na hindi makagawa ng tipan sa mga naninirahan sa lupain kung saan kayo ay pupunta, o magiging patibong sila sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Sa halip, dapat ninyong sirain ang kanilang mga altar, wasakin ang kanilang mga banal na haliging bato at putulin ang mga poste ni Asera. ");
INSERT INTO tglulb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Hindi kayo dapat sumamba ng ibang diyos, dahil ako lang, si Yahweh, ang may pangalang 'Mapanibugho,' ako ang mapanibughong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Mag-ingat kayo na hindi makagawa ng tipan sa mga naninirahan sa lupain, nang ginawa nilang bayaran ang kanilang mga sarili sa kanilang mga diyos at maghandog sa kanilang diyos, at sinuman ang magyaya sa inyo at kakainin niyo ang ilan sa knailang handog. ");
INSERT INTO tglulb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kahit kunin ninyo ang ilan sa kanilang mga anak na babae para sa inyong mga anak na lalaki, at ang kaniyang mga anak na babae ay gawing bayaran ang kanilang sarili sa kanilang mga diyos, at ang inyong mga anak na lalaki ay gagawin nilang bayaran ang kanilang sarili para sa kanilang diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Huwag kayong gumawa ng mga diyus-diyosan para sa inyong sarili na gawa sa tinunaw na metal. ");
INSERT INTO tglulb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Dapat ninyong ipagdiwang ang Pista ng Walang Lebadurang Tinapay. Tulad ng aking iniutos sa inyo, kailangan ninyong kainin ang tinapay na walang lebadura sa loob ng pitong araw at sa takdang panahon sa buwan ng Abib, dahil sa buwan ng Abib kayo ay lumabas mula Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ang lahat ng panganay ay akin, bawat panganay ng inyong mga toro, maging ang mga baka at tupa. ");
INSERT INTO tglulb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Dapat ninyong bilhin muli ang panganay na asno kasama ang kordero, pero kung hindi ninyo ito bibilhin ulit, kailangan baliin ninyo ang leeg nito. Dapat ninyong bilhin muli ang lahat ng panganay ninyong anak na lalaki. Walang haharap sa akin kahit isa na walang dala. ");
INSERT INTO tglulb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Maaari kayong magtrabaho sa loob ng anim na araw, pero sa ikapitong araw kailangan ninyong magpahinga. Kahit na sa panahon ng pagbubungkal ng lupa at pag-aani, kailangan ninyong magpahinga. ");
INSERT INTO tglulb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Dapat ninyong ipagdiwang ang Pista ng mga linggo kasama ang unang pag-aani ng trigo, at dapat ninyong ipagdiwang ang Pista ng Pagtitipon sa huling araw ng taon. ");
INSERT INTO tglulb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Dapat haharap sa akin ang lahat ng inyong lalaki, si Yahweh na Diyos ng Israel, tatlong beses sa bawat taon. ");
INSERT INTO tglulb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Dahil palalayasin ko ang mga bansa sa harap ninyo at palalawakin ang inyong hangganan. Walang sinumang maghahangad na sakupin ang inyong lupain at kukuha nito kapag kayo ay haharap sa akin, Yahweh, ang inyong Diyos, tatlong beses sa bawat taon. ");
INSERT INTO tglulb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Hindi ninyo dapat ialay ang dugo ng aking handog nang may anumang lebadura, ni anumang karne mula sa handog sa Pista ng Paskua ang matira sa umaga. ");
INSERT INTO tglulb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Dapat ninyong dalhin sa aking bahay ang pinakamagandang unang aning prutas mula sa inyong mga bukid. Hindi ninyo dapat ilaga ang batang kambing sa gatas ng ina nito.” ");
INSERT INTO tglulb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Sinabi ni Yahweh kay Moises, “Isulat mo itong mga salita dahil ipinapangako ko ang aking sarili ng mga salitang ito na aking sinabi, at gumawa ng tipan sa inyo at sa Israel.” ");
INSERT INTO tglulb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Naroon si Moises kasama si Yahweh ng apatnapung araw at gabi; hindi siya kumain ng kahit anong pagkain o uminom ng tubig. Isinulat niya sa mga tipak ang mga salita ng tipan, ang Sampung Utos. ");
INSERT INTO tglulb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Nang makababa si Moises galing sa Bundok ng Sinai dala ang dalawang tipak ng mga utos ng tipan sa kaniyang kamay, hindi niya alam na ang balat ng kaniyang mukha ay lumiwanag habang nakikipag-usap siya sa Diyos. ");
INSERT INTO tglulb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Nang makita ni Aaron at ng mga Israelita si Moises, ang balat ng kaniyang mukha ay lumiliwanag, at natakot silang lumapit sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pero tinawag sila ni Moises, at si Aaron at ang lahat ng pinuno sa komunidad ay lumapit sa kaniya. Pagkatapos nakipag-usap si Moises sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Pagkatapos nito, ang lahat ng mga tao sa Israel ay lumapit kay Moises, at sinabi niya sa kanila ang lahat ng utos na ibinigay ni Yahweh sa kaniya sa Bundok ng Sinai. ");
INSERT INTO tglulb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Nang natapos makipag-usap ni Moises sa kanila, naglagay siya ng takip sa kaniyang mukha. ");
INSERT INTO tglulb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Sa tuwing pupunta si Moises kay Yahweh para kausapin siya, inaalis niya ang takip. Pagkatapos ibabalik niya ang takip sa tuwing siya ay aalis. Lalabas siya sa kaniyang tolda at sasabihin sa mga Israelita kung ano ang mga naging tagubilin sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Nakita ng mga Israelita ang mukha ni Moises na nagliliwanag. Pagkatapos ilalagay niya muli ang takip sa kaniyang mukha hanggang sa bumalik siya sa loob para makipag-usap kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Tinipon ni Moises ang lahat ng mga mamamayang Israelita at sinabi sa kanila, “Ito ang mga bagay na iniutos ni Yahweh na gagawin ninyo. ");
INSERT INTO tglulb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sa ikaanim na araw ang lahat ng gawain ay maaaring nagawa na, ngunit sa inyo, ang ikapitong araw ay dapat na banal na araw, ang Araw ng Pamamahinga ng ganap na pamamahinga, na banal kay Yahweh. Ang sinumang gagawa ng anumang gawain sa araw na iyon ay papatayin. ");
INSERT INTO tglulb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Hindi kayo dapat magsisindi ng apoy saan man sa inyong mga tahanan sa Araw ng Pamamahinga.” ");
INSERT INTO tglulb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Nangusap si Moises sa lahat ng mga mamamayang Israelita, sinabing, “Ito ang bagay na iniutos ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Magdala ng handog para kay Yahweh, lahat kayo na may bukas na puso. Magdala ng handog kay Yahweh—ginto, pilak, tanso, ");
INSERT INTO tglulb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","asul, lila, at pulang tela at pinong lino; balahibo ng kambing; ");
INSERT INTO tglulb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","balat ng lalaking tupa na kinulayan ng pula, balat ng dugong; kahoy na akasya; ");
INSERT INTO tglulb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","langis para sa ilawan ng santuwaryo, panghalo para sa langis na pampahid at ang mabangong insenso, ");
INSERT INTO tglulb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","batong onise at iba pang mahalagang bato na ilalagay sa efod at baluting pangdibdib. ");
INSERT INTO tglulb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Bawat bihasang lalaki sa inyo ay pumunta at gawin ang lahat na iniutos ni Yahweh— ");
INSERT INTO tglulb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ang tabernakulo kasama ng tolda nito, ang pantakip nito, mga kawit nito, mga tabla, mga tukod, mga haligi at mga tuntungan; ");
INSERT INTO tglulb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","gayundin ang kaban kasama ng mga haligi nito, ang takip ng luklukan ng awa, at ang kurtina para matakpan ito. ");
INSERT INTO tglulb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Dinala nila ang mesa kasama ng mga haligi nito, lahat ng mga kagamitan nito at ang tinapay ng presensya; ");
INSERT INTO tglulb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ang ilawan para sa mga ilaw, mga palamuti nito, mga ilaw nito, at ang langis para sa mga ilaw; ");
INSERT INTO tglulb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ang altar ng insenso at ang mga haligi nito, ang pampahid na langis at ang mabangong insenso; ang pambitin para sa pasukan ng tabernakulo; ");
INSERT INTO tglulb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ang altar para sa sinunog na handog na may rehas na bakal na tanso at ang haligi nito at mga kagamitan, at ang malaking palanggana kasama ng tuntungan nito. ");
INSERT INTO tglulb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Dinala nila ang mga pambitin para sa patyo kasama ng kaniyang mga haligi at mga tuntungan, at ang kurtina para sa pasukan ng patyo; ");
INSERT INTO tglulb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","at ang mga tulos ng tolda para sa tabernakulo at patyo kasama ang mga lubid nito. ");
INSERT INTO tglulb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Dinala nila ang mga mainam na hinabing kasuotan para sa paglilingkod sa banal na lugar, ang banal na kasuotan para kay Aaron na pari at kaniyang mga anak na lalaki para sila ay maglingkod bilang pari.” ");
INSERT INTO tglulb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Pagkatapos ang lahat ng mga lipi ng Israel ay umalis mula sa harapan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Bawat isa na ang puso ay napukaw at ang kaniyang espiritu ay naging handang pumunta at nagdala ng handog kay Yahweh para sa paggawa ng tabernakulo, lahat ng bagay na gagamitin sa paglilingkod nito, at para sa banal na kasuotan. ");
INSERT INTO tglulb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Pumunta sila kasama ang mga lalaki at mga babae, lahat na may pusong handa. Nagdala sila ng mga panusok, mga hikaw, mga singsing, at mga palamuti, lahat ng uri ng gintong alahas. Iniharap nilang lahat ang mga alay na ginto kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bawat isa na may asul, lila, o pulang tela, pinong lino, balahibo ng kambing, mga balat ng lalaking tupa na kinulayan ng pula o mga balat ng dugong ay dinala nila. ");
INSERT INTO tglulb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Gumagawa ang bawat isa ng handog na pilak o tanso at dinala ito bilang handog kay Yahweh, at bawat isa na may kahoy na akasya para magamit sa anumang gawain ay dinala ito. ");
INSERT INTO tglulb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ang bawat bihasang babae ay naghabi gamit ang kaniyang mga kamay at dinala ang kaniyang hinabi—asul, lila, o pulang sinulid, o pinong lino. ");
INSERT INTO tglulb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Lahat ng babae na ang mga puso ay pumukaw sa kanila at may kahusayan ay naghabi ng buhok ng kambing. ");
INSERT INTO tglulb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ang mga pinuno ay nagdala ng batong oniks at iba pang mahalagang bato para ilagay sa epod at sa baluti; ");
INSERT INTO tglulb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Nagdala sila ng panghalo at langis para sa ilawan, para sa pangpahid na langis, at para sa mabangong insenso. ");
INSERT INTO tglulb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ang mga Israelita ay kusang-loob na nagdala ng handog kay Yahweh; ang bawat lalaki at babae na may pusong handa ay nagdala ng mga kagamitan para sa lahat ng gawain na iniutos ni Yahweh sa pamamagitan ni Moises na gagawin. ");
INSERT INTO tglulb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Sinabi ni Moises sa mga Israelita, “Tingnan ninyo, tinawag ni Yahweh sa pangalan si Bezalel na anak ni Uri, anak na lalaki ni Hur, mula sa lipi ni Juda. ");
INSERT INTO tglulb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Pinuspos niya si Bezalel ng kaniyang Espiritu, para bigyan siya ng karunungan, pang-unawa at kaalaman sa lahat ng gawaing pansining, ");
INSERT INTO tglulb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","para gumawa ng masining na disenyo na gawa sa ginto, pilak at tanso; ");
INSERT INTO tglulb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","gayundin ang pagputol at paglagay ng mga bato at pag-ukit sa kahoy—sa paggawa ng lahat ng uri ng disenyo at gawaing pansining. ");
INSERT INTO tglulb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Inilagay niya sa kaniyang puso para magturo, siya at si Oholiab na anak ni Ahisamac, mula sa lipi ni Dan. ");
INSERT INTO tglulb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Sila ay pinuspos niya ng kakayahan para gumawa ng lahat ng uri ng gawain, para maging taga-gawa ng sining, mga mag-uukit, tagaburda ng asul, lila at pinong lino, at bilang manghahabi. Sila ay manggagawa ng sining sa lahat ng uri ng gawain at sila ay masining na mga taga-disenyo. ");
INSERT INTO tglulb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Kaya si Bezalel at Oholiab ay magtatrabaho, gayundin ang bawat pusong may karunungan na ipinagkalooban ni Yahweh ng kakayahan at pang-unawa na malaman kung paano gumawa ng banal na lugar, na sumusunod sa mga tagubilin na ibinigay sa inyo na gagawin.” ");
INSERT INTO tglulb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Tinawag ni Moises sina Bezalel, Oholiab, at ang lahat ng taong bihasa na sa kaniyang pag-iisip ay pinagkalooban ni Yahweh ng kahusayan, at ang kanilang puso na napukaw ang kalooban na lumapit at gumawa ng gawain. ");
INSERT INTO tglulb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Tinanggap nila mula kay Moises ang lahat ng handog na dinala ng mga Israelita sa paggawa ng banal na lugar. Patuloy ang mga tao sa pagdadala ng mga handog na kusang-loob sa bawat umaga. ");
INSERT INTO tglulb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Kaya ang lahat ng mga taong bihasa na gumagawa sa banal na lugar ay lumapit kay Moises mula sa paggawa ng kanilang mga gawain. ");
INSERT INTO tglulb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Sinabi ni Moises, “Ang mga tao ay nagdadala ng labis sa paggawa ng gawain ayon sa iniutos ni Yahweh na ating gagawin.” ");
INSERT INTO tglulb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kaya ang tagubilin ni Moises na wala ni isa sa kampo ang magdala ng anumang mga handog para sa paggawa ng banal na lugar. Kaya ang mga tao ay huminto na sa pagdadala ng mga handog. ");
INSERT INTO tglulb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Mayroon na silang labis-labis na mga kagamitan para sa lahat ng gawain. ");
INSERT INTO tglulb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Kaya ang lahat ng manggagawa sa gitna nila ay itinayo ng tabernakulo na may sampung kurtina na gawa sa pinong lino at asul, lila, at matingkad na pulang lana na may disenyong kerubin. Ito ang ginawa ni Bezalel, ang napakahusay na manggagawa. ");
INSERT INTO tglulb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ang haba ng bawat kurtina ay dalawampu't walong kubit, ang lapad ay apat na kubit. Lahat ng mga kurtina ay magkakatulad ang sukat. ");
INSERT INTO tglulb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pinagsama ni Bezalel ang limang kurtina sa bawat isa, at ang lima pa ay pinagsama din sa bawat isa. ");
INSERT INTO tglulb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Gumawa siya ng mga silong asul sa sidsid ng bawat piraso ng kurtina, at ganon din sa sidsid ng ikalawang piraso ng kurtina. ");
INSERT INTO tglulb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Gumawa siya ng limampung silo sa naunang kurtina at limampung silo sa sidsid ng ikalawang kurtina. Kaya ang dalawang kurtina ay magkasalungat sa bawat isa. ");
INSERT INTO tglulb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Gumawa siya ng limampung gintong kawit at pinagsama ang mga kurtina kaya ang tabernakulo ay nabuo. ");
INSERT INTO tglulb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Gumawa si Bezalel ng kurtina na gawa sa buhok ng kambing para sa tolda sa ibabaw ng tabernakulo; gumawa siya ng labing isang kurtinang kagaya nito. ");
INSERT INTO tglulb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ang haba ng bawat kurtina ay tatlumpung kubit, at ang lapad ng bawat kurtina ay apat na kubit. Bawat isa sa labing-isang kurtina ay magkapareho ang sukat. ");
INSERT INTO tglulb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Pinagsama niya ang limang kurtina sa bawat isa at gayundin ang iba pang anim na kurtina sa bawat isa. ");
INSERT INTO tglulb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Gumawa siya ng limampung silo sa sidsid ng dulong kurtina sa naunang piraso, at limampung silo sa bandang sidsid ng dulong kurtina na pinagsama ng ikalawang piraso. ");
INSERT INTO tglulb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Gumawa si Bezalel ng limampung tansong kawit para pagsamahin ang mga tolda para ito ay maging isa. ");
INSERT INTO tglulb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Gumawa siya ng pantakip sa tabernakulo na gawa sa balat ng lalaking tupa na kinulayan ng pula, isa pang pantakip na mainam na balat para sa ibabaw niyon. ");
INSERT INTO tglulb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Gumawa si Bezalel ng patayong tabla na gawa sa kahoy na akasya para sa tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ang haba ng bawat tabla ay sampung kubit, at ang lapad ng mga ito ay isa't kalahating kubit. ");
INSERT INTO tglulb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","May dalawang usli sa bawat tabla para pagsamahin ang bawat isa. Ginawa niya ang lahat ng tabla ng tabernakulo sa pamamagitan nito. ");
INSERT INTO tglulb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Sa paraang ito ginawa niya ang mga tabla para sa tabernakulo. Ginawa niya ang dalawampung tabla para sa timog na bahagi. ");
INSERT INTO tglulb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Gumawa si Bezalel ng apatnapung pilak na tuntungan na suotan ng dalawampung tabla. May dalawang patungan sa ilalim ng naunang tabla na maging dalawang tuntungan, at gayundin ang dalawang tuntungan sa ilalim ng bawat iba pang tabla para sa kanilang dalawang tuntungan. ");
INSERT INTO tglulb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Para sa ikalawang gilid ng tabernakulo, sa silangang bahagi, gumawa siya ng dalawampung tabla. ");
INSERT INTO tglulb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","At ang kanilang apatnapung pilak na tuntungan. May dalawang tuntungan sa ilalim ng naunang tabla, dalawang tuntungan sa ilalim ng kasunod na tabla, at sa sumunod pa. ");
INSERT INTO tglulb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Para sa bandang likuran ng tabernakulo sa gawing kanluran, gumawa si Bezalel ng anim na tabla. ");
INSERT INTO tglulb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Gumawa siya ng dalawang tabla para sa likurang sulok ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ang mga tabla ay nahiwalay sa ilalim, pero pinagsama sa itaas sa iisang argolya. Ganito ginawa ang para sa dalawang sulok na nasa likuran. Mayroong walong tabla, kasama ng kanilang pilak na tuntungan. ");
INSERT INTO tglulb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Mayroong bilang na labing anim na tuntungan lahat, dalawang tuntungan sa ilalim ng naunang tabla, dalawang tuntungan sa ilalim ng kasunod na tabla, at sa kasunod pa. ");
INSERT INTO tglulb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Gumawa si Bezalel ng pahalang na haligi na gawa sa kahoy ng akasya—lima para sa mga tabla sa isang gilid ng tabernakulo, ");
INSERT INTO tglulb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","limang pahalang na haligi para sa mga tabla sa kabilang gilid ng tabernakulo, at limang mga pahalang na haligi para sa mga tabla ng likurang gilid ng tabernakulo patungong kanluran. ");
INSERT INTO tglulb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ginawa niya ang pahalang na haligi sa gitna ng mga tabla, iyon ay, kalahati pataas, para umabot sa dulo hanggang dulo. ");
INSERT INTO tglulb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Tinakpan niya ang mga tabla ng ginto. Ginawa niya ang kanilang mga gintong argolya, para ang mga ito ay magsilbing panghawak ng mga tubo, at kaniyang binalot ng ginto ang mga rehas. ");
INSERT INTO tglulb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Gumawa si Bezalel ng kurtinang asul, lila, at pulang lana, at pinong lino na may mga disenyo ng kerubim, ang gawa ng mahusay na manggagawa. ");
INSERT INTO tglulb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Gumawa siya ng apat na haligi ng kahoy na akasya para sa kurtina, at tinakpan niya ang mga ito ng ginto. Gumawa rin siya ng mga gintong kawit para sa mga haligi, at kaniyang ipinagbubo ng apat na tuntungang pilak. ");
INSERT INTO tglulb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Gumawa siya ng pabitin para sa pasukan ng tolda. Gawa ito sa asul, lila, at pulang lana, na ginagamitan ng pinong lino, na gawa ng isang magbuburda. ");
INSERT INTO tglulb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Gumawa din siya ng limang mga haligi na may mga kawit na may pabitin. Tinakpan niya ang ibabaw at ang mga dulo nito ng ginto. Ang limang tuntungan ng mga ito ay gawa sa tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Gumawa si Bezalel ng kaban sa kahoy ng akasya. Ang haba nito ay dalawa at kalahating kubit; ang lapad nito ay isa at kalahating kubit at ang taas nito ay isa at kalahating kubit. ");
INSERT INTO tglulb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Binalutan niya ang loob at labas nito ng purong ginto at ginawan niya ito ng gintong hangganan na nakapalibot sa ibabaw nito. ");
INSERT INTO tglulb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Siya ay naghulma ng apat na mga singsing na ginto para sa apat na paa nito, na mayroong dalawang singsing sa isang gilid nito, at dalawang singsing sa kabilang gilid. ");
INSERT INTO tglulb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Gumawa siya ng mga poste sa kahoy ng akasya at binalutan ang mga ito ng ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Nilagay niya ang mga poste sa mga singsing na nasa mga gilid ng kaban, para mabuhat ang kaban. ");
INSERT INTO tglulb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Gumawa siya ng takip ng luklukan ng awa na purong ginto. Ang haba nito ay dalawa at kalahating kubit at ang lapad ay isa at kalahating kubit. ");
INSERT INTO tglulb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Gumawa si Bezalel ng dalawang kerubim na minartilyong ginto para sa dalawang dulo ng takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Isang kerubim ay para sa isang dulo ng takip ng luklukan ng awa, at ibang kerubin ay para sa ibang dulo. Ginawa sila bilang isang piraso kasama ng takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Binuka ng kerubim ang kanilang mga pakpak pataas at nagbibigay lilim sa takip ng luklukan ng awa kasama nila. Nakaharap ang kerubim sa bawat isa at nakatingin patungo sa gitna ng takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Gumawa si Bezalel ng mesa sa kahoy ng akasya. Ang haba nito ay dalawang kubit, ang lapad nito ay isang kubit at ang taas nito ay isa at kalahating kubit. ");
INSERT INTO tglulb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Binalutan niya ito ng purong ginto at nilagyan ng isang hangganan na purong ginto sa paligid ng ibabaw. ");
INSERT INTO tglulb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Gumawa siya ng nakapaligid na balangkas nito na isang dapal ang lapad na mayroong kalapit na gintong hangganan para sa balangkas. ");
INSERT INTO tglulb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Nagmolde siya ng apat na singsing na ginto at ikinabit ang mga singsing sa apat na sulok, kung saan naroon ang apat na mga paa. ");
INSERT INTO tglulb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ang mga singsing ay nakakabit sa balangkas para magbigay ng lugar para sa mga poste, para mabuhat ang mesa. ");
INSERT INTO tglulb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ginawa niya ang mga poste mula sa kahoy ng akasya at binalutan ang mga ito ng ginto, para mabuhat ang mesa. ");
INSERT INTO tglulb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Gumawa siya ng mga bagay na dapat nasa mesa—ang mga pinggan, mga kutsara, ang mga mangkok at mga pitsel na gagamitin para ibuhos ang mga handog. Ginawa niya ang mga ito ng purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Gumawa siya ng ilawan na purong minartilyong ginto. Gumawa siya ng ilawan kasama ng tuntungan at baras nito. Ang mga baso nito, ang madahong tuntungan nito at mga bulaklak nito ay ginawa lahat sa isang piraso na kasama nito. ");
INSERT INTO tglulb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Anim na mga sanga ang pinahaba mula sa gilid nito—tatlong mga sanga ang pinahaba sa isang gilid at tatlong sanga ng ilawan ang pinahaba mula sa kabilang gilid. ");
INSERT INTO tglulb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ang unang sanga ay may tatlong baso na ginawa gaya ng bulaklak ng almendra, mayroong madahong tuntungan at bulaklak, at tatlong baso na ginawa katulad ng bulaklak ng almendra sa kabilang sanga na may madahong tuntungan at isang bulaklak. Ito ay katulad sa lahat ng anim na mga sangang pinahaba mula sa ilawan. ");
INSERT INTO tglulb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Sa mismong ilawan, ang gitnang baras, mayroong apat na baso ginawa katulad ng mga bulaklak ng almendra kasama ng kanilang mga madahong tuntungan at ang mga bulaklak. ");
INSERT INTO tglulb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Mayroong madahong tuntungan sa ilalim ng unang pares ng mga sanga—ginawang isang piraso ito, at isang madahong tuntungan sa pangalawang pares ng mga sanga—ginawa ring isang piraso ito. Sa parehong paraan ay mayroong madahong tuntungan sa ilalim ng pangatlong pares ng mga sanga, ginawang isang piraso ito. Magkatulad ito sa lahat ng anim na mga sangang pinahaba mula sa ilawan. ");
INSERT INTO tglulb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ang kanilang mga madahong tuntungan at mga sanga lahat ay isang piraso ito, isang bahaging pinalong trabaho ng purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Gumawa si Bezalel ng ilawan at pitong mga ilawan nito, mga panipit nito at kanilang mga bandeha ng purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ginawa niya ang ilawan at mga kagamitan sa isang talento ng purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Gumawa si Bezalel ng altar ng insenso. Ginawa niya ito mula sa kahoy ng akasya. Ang haba nito ay isang kubit, at ang lapad ay isang kubit. Iyon ay parisukat at ang taas nito ay dalawang kubit. Ang mga sungay nito ay ginawa bilang isang piraso na kasama nito. ");
INSERT INTO tglulb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Binalutan niya ang altar ng insenso ng purong ginto—ang ibabaw, mga gilid nito, at mga sungay nito. Gumawa rin siya ng nakapalibot na gintong hangganan para dito. ");
INSERT INTO tglulb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Gumawa siya ng dalawang gintong mga singsing para isama ito sa ilalim ng hangganan sa dalawang magkabilang mga gilid nito. Ang mga singsing ay tagahawak sa mga poste para mabuhat ang altar. ");
INSERT INTO tglulb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Gumawa siya ng mga poste sa kahoy ng akasya at binalutan niya sila ng ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ginawa niya ang banal na pangpahid na langis at ang purong pabango ng insenso, ang trabaho ng tagapagpabango. ");
INSERT INTO tglulb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Gumawa si Bezalel ng altar para sa mga handog na susunugin sa kahoy ng akasya. Iyon ay limang kubit ang haba at limang kubit ang lapad—isang parisukat—at tatlong kubit ang taas. ");
INSERT INTO tglulb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ginawan niya ng mga karugtong sa apat nitong kanto na kahugis ng mga sungay ng kapong baka. Ang mga sungay ay ginawa sa isang piraso na kasama ang altar at binalutan niya ito ng tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ginawa niya ang lahat na kagamitan para sa altar—palayok para sa mga abo, mga pala, mga palanggana, mga tinidor ng karne, at mga lalagyan ng apoy. Ginawa niya ang lahat ng kagamitang ito sa tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Gumawa siya ng rehas na bakal para sa altar, isang naayos na nagkakabit-kabit na tanso na ilalagay sa ilalim ng baytang, kalagitnaan pababa sa ilalim. ");
INSERT INTO tglulb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Nagmolde siya ng apat na singsing para sa apat ng mga kanto ng tanso na rehas na bakal, bilang tagahawak sa mga poste. ");
INSERT INTO tglulb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Gumawa si Bezalel ng mga poste sa kahoy ng akasya at binalutan ang mga ito ng tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Nilagay niya ang mga poste sa mga singsing sa mga gilid ng altar, para buhatin ito. Ginawa niya ang altar na banal, mula sa makapal na mga tabla. ");
INSERT INTO tglulb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Gumawa si Bezalel ng malaking palangganang tanso kasama ng tansong patungan. Ginawa niya ang palanggana mula sa mga salamin na pag-aari ng mga babaeng naglingkod sa pasukan sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ginawa rin niya ang patyo. Ang mga nakabitin sa timog na bahagi ng patyo ay pinong lino, isandaang kubit ang haba. ");
INSERT INTO tglulb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ang mga nakabitin ay mayroong dalawampung mga poste, kasama ng dalawampung mga tuntungang tanso. Mayroong mga kawit na nakadikit sa mga poste, at gayundin ang mga pilak na baras. ");
INSERT INTO tglulb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Gayundin naman sa bandang hilagang bahagi, mayroong mga nakabiting isandaang kubit ang haba kasama ng dalawampung mga poste, dalawampung mga tungtungang tanso, dinikit ang mga kawit sa mga poste, at mga pilak na baras. ");
INSERT INTO tglulb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ang mga nakabitin sa kanlurang bahagi ay limampung kubit ang haba, kasama ng sampung mga poste at mga tuntungan. Ang mga kawit at mga baras ng poste ay pilak. ");
INSERT INTO tglulb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ang patyo rin ay limampung kubit ang haba sa silangan bahagi. ");
INSERT INTO tglulb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ang mga nakabitin sa isang bahagi ng pasukan ay labinlimang kubit ang haba. Mayroon silang tatlong mga poste kasama ng tatlong mga tuntungan. ");
INSERT INTO tglulb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Sa kabilang bahagi ng pasukan ng hukuman ay may nakabitin ding labinlimang kubit ang haba, kasama ng tatlong mga poste at tatlong mga tuntungan. ");
INSERT INTO tglulb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Lahat ng mga nakabitin sa palibot ng patyo ay gawa sa pinong lino. ");
INSERT INTO tglulb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ang mga tuntungan para sa mga poste ay gawa sa tanso. Ang mga kawit at mga baras para sa mga poste ay gawa sa pilak, at ang tabing para sa mga ibabaw ng mga poste ay gawa rin sa pilak. Ang lahat ng mga poste ng patyo ay binalutan ng pilak. ");
INSERT INTO tglulb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ang kurtina ng tarangkahan ng patyo ay dalawampung kubit ang haba. Ang kurtina ay gawa sa asul, lila, at matingkad na pulang lino, pinong pinulupot na lino, at dalawampung kubit ang haba. Iyon ay dalawampung kubit ang haba at limang kubit ang taas, katulad ng mga kurtina ng patyo. ");
INSERT INTO tglulb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ito ay mayroong apat na tansong mga tuntungan at mga kawit na pilak. Ang tabing ng kanilang ibabaw at ang mga baras nito ay gawa sa pilak. ");
INSERT INTO tglulb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ang lahat ng mga tulos ng tolda para sa tabernakulo at patyo ay gawa sa tanso. ");
INSERT INTO tglulb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ito ang talaan ng pag-aari ng tabernakulo, ang tabernakulo ng kautusang kasunduan, gaya ng ito ay kinuha sa pagsunod sa mga tagubilin ni Moises. Iyon ay ang trabaho ng mga Levita sa ilalim ng pamamahala ni Itamar na anak na lalaki ni Aaron na pari. ");
INSERT INTO tglulb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Si Bezalel na anak na lalaki ni Uri, na anak na lalaki ni Hur, mula sa lipi ng Juda, ang gumawa ng lahat na iniutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Si Oholiab na anak na lalaki ni Ahisamach, mula sa lipi ni Dan, nagtrabaho kasama ni Bezalel bilang tagapag-ukit, bilang isang bihasang manggagawa at bilang mangbuburda ng asul, lila, matingkad na pulang lana, at pinong lino. ");
INSERT INTO tglulb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ang lahat ng ginto na ginamit para sa proyekto, sa lahat ng trabaho na karugtong sa banal na lugar—ang ginto na mula sa handog na tinanghal—ay dalawampu't siyam na talento at 730 sekel, sinukat ng pamantayan ng sekel ng santuwaryo. ");
INSERT INTO tglulb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ang pilak na binigay ng kumunidad ay nagtitimbang ng isandaang talento at 1, 775 sekel, ayon sa sekel ng santuwaryo, ");
INSERT INTO tglulb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","o isang beka bawat lalaki, na kalahati ng sekel, sinukat ng sekel ng santuwaryo. Ang bilang na ito ay umabot sa batayan na ang bawat tao na nabilang sa sensus, ang mga dalawampung taong gulang at nakatatanda—603, 550 kalalakihan lahat. ");
INSERT INTO tglulb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Isandaang talento ng pilak ay minolde para sa tuntungan ng banal na lugar at ang tuntungan ng mga kurtina: isandaan tuntungan, isang talento sa bawat tuntungan. ");
INSERT INTO tglulb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Sa natitirang 1, 775 sekel ng pilak, ginawa ni Bezalel ang mga kawit at ginawa ang mga baras para sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ang mga tanso na galing sa handog ay nagtitimbang ng pitumpong mga talento at 2, 400 mga sekel. ");
INSERT INTO tglulb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Gamit nito ginawa niya ang mga tuntungan para sa pasukan papunta sa tolda ng pagpupulong, ang tansong altar, tansong rehas na bakal nito, lahat ng kagamitan para sa altar, ");
INSERT INTO tglulb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ang mga tuntungan para sa patyo, ang mga tuntungan sa pasukan ng patyo, lahat ng mga tulos ng tolda para sa tabernakulo, at lahat ng mga tulos ng tolda para sa patyo. ");
INSERT INTO tglulb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Gamit ang asul, lila at pulang tela, sila ay nakagawa ng mga pinong hinabing kasuotan para sa paglilingkod sa banal na lugar. Ginawa nila ang mga kasuotan ni Aaron para sa banal na lugar, ayon sa iniutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ginawa ni Bezalel ang efod na ginto, na asul, lila, at matingkad na pulang lana, at ng pinong pinulupot na lino. ");
INSERT INTO tglulb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nagpanday sila ng mga pinanipis na ginto at ginupit nila ang mga alambre, para magawa ito sa asul, lila at matingkad na pulang lana, at para sa pinong lino, ang trabaho ng isang mahusay na manggagawa. ");
INSERT INTO tglulb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Gumawa sila ng mga pang-balikat na piraso para sa efod, na nakakabit sa dalawang itaas na kanto nito. ");
INSERT INTO tglulb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ang pinong nahabing sinturon nito ay katulad ng efod; gawa ito sa isang piraso kasama ang efod, na gawa sa pinong pinulupot na linong ginto, asul, lila, at pula, katulad ng inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Inukit nila ang mga batong oniks, na kalakip sa lagayan ng ginto, iniayos kasama ang inukitan na parang nasa isang pantatak, at inukitan ng mga pangalan ng labing-dalawang anak na lalaki ni Israel. ");
INSERT INTO tglulb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Inilagay ito ni Bezalel sa balikat na piraso ng efod, bilang mga bato para alalahanin ni Yahweh ang labing-dalawang anak na lalaki ni Israel, ayon sa inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ginawa niya ang baluti, gawain ng bihasang manggagawa, inihugis katulad ng efod. Ginawa ito sa pamamagitan ng ginto, asul, lila at pulang tela, at ng pinong lino. ");
INSERT INTO tglulb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ito ay parisukat. Itiniklop nila ang baluti ng dalawang ulit. Ito ay isang dipang haba at isang dipang lapad. ");
INSERT INTO tglulb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Iniayos nila ito sa apat na hanay ng mahahalagang mga bato. Ang unang hanay ay may isang rubi, isang topaz, at isang garnet. ");
INSERT INTO tglulb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ang ikalawang hanay ay may isang esmeralda, isang safira, at isang dyamante. ");
INSERT INTO tglulb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ang ikatlong hanay ay may jacinto, isang agate, at isang ametista. ");
INSERT INTO tglulb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ang ikaapat na hanay ay may beryl, isang oniks, at isang jasper. Ang mga bato ay ikinabit sa may gintong lalagyan. ");
INSERT INTO tglulb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ang mga bato ay nakaayos ayon sa mga pangalan ng labindalawang anak na lalaki ni Israel, ang bawat isa ay inayos ayon sa pangalan. Ang mga ito ay mistulang mga inukit na nakalagay sa pangselyong singsing, bawat pangalan ay kumakatawan para sa isa sa labindalawang lipi. ");
INSERT INTO tglulb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Sa baluti gumawa sila ng mga kadena na katulad ng tali, tinirintas ng purong ginto. ");
INSERT INTO tglulb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Gumawa sila ng dalawang lalagyan ng ginto at dalawang singsing na ginto, at nagkabit sila ng dalawang singsing sa dalawang sulok ng baluti. ");
INSERT INTO tglulb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Inilagay nila ang dalawang tinirintas na kadenang ginto sa dalawang singsing sa bawat gilid ng baluti. ");
INSERT INTO tglulb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ikinabit nila ang ibang dalawang dulo ng tinirintas na mga kadena sa dalawang lalagyan. Ikinabit nila ito sa pang-balikat na piraso ng efod sa may harapan nito. ");
INSERT INTO tglulb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Gumawa sila ng dalawang mga singsing na ginto at inilagay nila ang mga ito sa dalawang sulok ng baluti, sa may gilid katabi ng panloob na hangganan. ");
INSERT INTO tglulb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Gumawa sila ng dalawa pang singsing na ginto at ikinabit ang mga ito sa ibaba ng dalawang pang-balikat na piraso ng harap ng efod, malapit sa tahi nito sa itaas ng pinong nahabing sinturon ng efod. ");
INSERT INTO tglulb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Itinali nila ang baluti gamit ang singsing nito sa singsing ng efod na may asul na tali, kaya ito ay maidugtong sa bandang taas ng mainam na tinahing sinturon ng efod. Ito rin ang baluti na hindi matanggal sa pagkakadugtong mula sa efod. Ginawa ito ayon sa inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Si Bezalel ay gumawa ng balabal ng efod na tunay na gawa sa telang lila, ginawa ng isang manghahabi. ");
INSERT INTO tglulb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Sa gitna ay mayroon itong bukasan para sa ulo. Ang bukasan ay may hinabing gilid na paikot para hindi ito mapunit. ");
INSERT INTO tglulb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Sa may ilalim na tupi, gumawa sila ng pomegranteng asul, lila at pulang tali at pinong lino. ");
INSERT INTO tglulb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Gumawa sila ng mga kampananilya sa purong ginto, at inilagay nila ang mga kampanilya sa pagitan ng mga prutas na granada sa paligid ng ilalim na dulo ng gilid ng balabal, sa pagitan ng mga prutas na granada— ");
INSERT INTO tglulb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","isang kampanilya at isang prutas na granada, isang kampanilya at isang prutas na granada—sa gilid ng balabal para kay Aaron na paglilingkuran niya. Ito ay ayon sa inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ginawa nila ang mahabang panlabas na kasuotan para kay Aaron at sa kaniyang mga anak na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Gumawa sila ng turbante na yari sa pinong lino, mga ginayak na pamigkis sa ulo na gawa sa pinong lino, ang linong damit pang-ilalim na pinong lino, ");
INSERT INTO tglulb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","at ang sintas naman sa baywang na yari sa pinong lino at ng asul, lila, at matingkad na pulang tali, gawa ng isang tagaburda. Ito ay ayon sa inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ginawa nila ang plaka ng banal na korona na purong ginto; inukit nila ito, katulad ng pag-ukit sa isang selyo, INILAAN KAY YAHWEH. ");
INSERT INTO tglulb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ikinabit nila sa turbante ang isang asul na tali sa taas ng turbante. Ito ay ayon sa inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Kaya ang gawain sa tabernakulo, ang tolda ng pagpupulong, ay natapos. Ginawa ng bayan ng Israel ang lahat ng bagay. Sumunod sila sa lahat ng tagubilin na ibinigay ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Dinala nila ang tabernakulo kay Moises- ang tolda at lahat ng mga kagamitan nito, mga kawit, mga tabla, mga tubo, mga poste, at mga tuntungan; ");
INSERT INTO tglulb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ang pantakip na mga balat ng kambing na pinapula, pantakip na balat ng dugong, at ang kurtina na tatabingan ");
INSERT INTO tglulb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ang mga kaban ng kautusang tipan, ganoon din ang mga baras at ng takip na lulukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Dinala nila ang mesa, lahat ng mga kagamitan nito, at tinapay ng presensya; ");
INSERT INTO tglulb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ang ilawang purong ginto at mga ilawan na nakahanay, kasama ng mga kagamitan nito at ang langis para sa mga ilawan; ");
INSERT INTO tglulb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ang gintong altar, ang pangpahid na langis at ang mabangong insenso; ang nakabitin para sa pasukan ng tabernakulo; ");
INSERT INTO tglulb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ang tansong altar kasama ng tansong parilya at mga baras at kagamitan at ang malaking palanggana kasama ng patungan nito. ");
INSERT INTO tglulb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Dinala nila ang mga pangsabit para sa patyo kasama ng mga poste at patungan, at ng kurtina para sa pasukan ng bulwagan; ang mga tali nito at mga pako ng tolda; at lahat ng mga kagamitan para sa paglilingkod sa tabernakulo, ang tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Dinala nila ang mga pinong natahing kasuotan para sa paglilingkod sa banal na lugar, ang banal na kasuotan para kay Aaron na pari at kaniyang mga anak na lalaki, para sila ay maglingkod bilang mga pari. ");
INSERT INTO tglulb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Kaya nagawa ng bayan ng Israel ang lahat ng gawain ayon sa inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Pinagmasdan lahat ni Moises ang mga nagawa, at, masdan ito, nagawa nila ito. Ayon sa inutos ni Yahweh, sa pamamaraang iyon nagawa nila ito. Pagkatapos sila ay pinagpala ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","At nagsalita si Yahweh kay Moises at sinabi, ");
INSERT INTO tglulb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Sa unang araw ng unang buwan ng bagong taon dapat mong itayo ang tabernakulo, ang tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Dapat mong ilagay doon ang kaban ng mga tipan ng kautusan, at dapat mong tabingan ang kaban gamit ang kurtina. ");
INSERT INTO tglulb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Dapat mong dalhin ang mesa at ilagay ng maayos ang mga bagay na nakapaloob doon. Pagkatapos dapat mong ipasok ang ilawan at isaayos ang mga lampara. ");
INSERT INTO tglulb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Dapat mong ilagay ang gintong insenso sa altar s harap ng kaban ng tipan ng kautusan, at dapat mong ilagay ang kurtina sa pasukan ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Dapat mong ilagay ang altar para sa mga sinunog na alay sa harapan ng pasukan ng tabernakulo, ang tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Dapat mong ilagay ang malaking palanggana sa pagitan ng tolda ng pagpupulong at altar, at dapat mong lagyan ng tubig iyon. ");
INSERT INTO tglulb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Dapat mong ayusin ang patyo sa palibot nito, at dapat mong ibitin ang kurtina sa pasukan ng patyo. ");
INSERT INTO tglulb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Dapat mong kunin ang pangpahid na langis at pahiran ang tabernakulo at ang lahat ng bagay na naroon. Dapat mong ilaan ito at ang lahat ng mga kagamitan para sa akin; pagkatapos ito ay magiging banal. ");
INSERT INTO tglulb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Dapat mong pahiran ang altar para sa sinunog na handog at lahat ng mga kagamitan nito. Dapat mong ilaan ang altar sa akin, at ito ay magiging buong ilaan sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Dapat mong pahiran ang tansong palanggana at ang patungan nito, at ilaan ito sa akin. ");
INSERT INTO tglulb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Dapat mong dalhin si Aaron at ang kaniyang mga anak na lalaki sa pasukan ng tolda ng pagpupulong, at dapat mong hugasan sila ng tubig. ");
INSERT INTO tglulb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","damitan mo si Aaron ng mga kasuotan na nailaan sa akin, pahiran mo siya, at ilaan mo siya sa akin ng sa ganoon siya ay makapaglingkod sa akin bilang aking pari. ");
INSERT INTO tglulb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Dadalhin mo ang kaniyang mga anak na lalaki at dadamitan mo sila ng balabal. ");
INSERT INTO tglulb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Dapat mong pahiran sila gaya ng pangpahid mo sa kanilang ama kaya makapaglilingkod sila sa akin bilang mga pari. Ang pagpapahid sa kanila ay magdudulot sa kanila na maging palagian ang kanilang pagpapari sa buong salinlahi ng kanilang bayan.” ");
INSERT INTO tglulb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ito ang ginawa ni Moises; sumunod siya sa lahat ng iniutos ni Yahweh. Ginawa niya ang lahat ng mga ito. ");
INSERT INTO tglulb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kaya ang tabernakulo ay naitayo noong unang araw ng unang buwan ng ikalawang taon. ");
INSERT INTO tglulb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Itinayo ni Moises ang tabernakulo, inilagay ang mga tuntungan nito sa kanilang mga lugar, inilagay ang mga tabla, ikinabit ang mga tubo, at itinayo ang mga haligi at poste. ");
INSERT INTO tglulb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Inilatag niya ang pantakip sa ibabaw ng tabernakulo at naglagay ng tolda sa ibabaw nito, ayon sa inutos ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Kinuha niya ang mga tipan ng kautusan at inilagay ito sa loob ng kaban. Inilagay niya din ang mga baras sa kaban at inilagay ang takip ng luklukan ng awa doon. ");
INSERT INTO tglulb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Dinala niya ang kaban sa loob ng tabernakulo. Iniayos niya ang kurtina para ito ay magtabing sa kaban ng mga tipan ng kautusan, ayon sa inutos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Inilagay niya ang mesa papasok sa tolda ng pagpupulong, sa may hilagang bahagi ng tabernakulo, sa labas ng kurtina. ");
INSERT INTO tglulb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Inilagay niya sa ayos tinapay sa mesa sa tapat ni Yahweh, ayon sa inutos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Inilagay niya ang ilawan sa loob ng tolda ng pagpupulong, sa kabila mula sa mesa, sa gawing timog ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Sinindihan niya ang mga ilaw sa tapat ni Yahweh, ayon sa inutos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Inilagay niya ang gintong altar ng insenso sa loob ng tolda ng pagpupulong sa harap ng kurtina. ");
INSERT INTO tglulb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Nagsunog siya doon ng pabangong insenso, ayon sa inutos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Isinabit niya ang kurtina sa pasukan ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Inilagay niya ang altar para sa sinunog na handog sa pasukan ng tabernakulo, ang tolda ng pagpupulong. Inihandog niya doon ang sinunog na handog at butil na handog, ayon sa inutos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Inilagay niya ang palanggana sa gitna ng tolda ng pagpupulong at ng altar, at naglagay siya ng tubig dito para sa paghuhugas. ");
INSERT INTO tglulb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Si Moises, Aaron at kaniyang mga anak ay naghugas ng kanilang mga kamay at kanilang mga paa sa palanggana. ");
INSERT INTO tglulb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Sa tuwing sila ay papasok sa tolda ng pagtitipon at sa tuwing pupunta sila pataas ng altar. Hinuhugasan nila ang kanilang mga sarili, ayon sa inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Iniayos ni Moises ang patyo sa paligid ng tabernakulo at ng altar. Iniayos niya ang kurtina sa pasukan ng patyo. Sa paraang ito, tinapos ni Moises ang mga gawa. ");
INSERT INTO tglulb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Pagkatapos binalot ng ulap ang tolda ng pagpupulong, at napuno ng kaluwalhatian ni Yahweh ang tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Hindi makapasok si Moises sa tolda ng pagpupulong dahil ang ulap ay palaging naroon, at dahil pinuno ng kaluwalhatian ni Yahweh ang tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kahit na ang ulap ay umalis sa ibabaw ng tabernakulo, ang bayan ng Israel ay magpapatuloy sa kanilang paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pero kung hindi tumaas ang ulap mula sa tabernakulo, pagkatapos ang bayan ay hindi makakapaglakbay. Sila ay mananatili hanggang sa ito ay tumaas. ");
INSERT INTO tglulb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Dahil ang ulap ni Yahweh ay nasa taas ng tabernakulo kapag umaga, at ang kaniyang apoy ay nasa itaas nito kapag gabi, sa patag na tanawin ng lahat ng bayan ng Israel sa buo nilang paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Tinawag ni Yahweh si Moises at kinausap siya mula sa tolda ng pagpupulong, sinasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Kausapin mo ang bayan ng Israel at sabihin sa kanila, 'Kapag sinumang tao mula sa inyo ang magdadala ng isang handog kay Yahweh, dalhin bilang inyong handog ang isa sa inyong mga hayop, alinman mula sa pangkat ng mga hayop o mula sa kawan. ");
INSERT INTO tglulb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kung ang kaniyang handog ay isang handog na susunugin mula sa pangkat ng mga hayop, dapat niyang ihandog ang isang lalaking hayop na walang dungis. Ihahandog niya ito sa pasukan ng tolda ng pagpupulong, para maaari itong tanggapin sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ipapatong niya ang kaniyang kamay sa ulo ng handog na susunugin, at pagkatapos tatanggapin ito sa ngalan niya para gawing kabayaran ng kasalanan para sa kanyang sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Pagkatapos dapat niyang patayin ang toro sa harapan ni Yahweh. Ang mga anak na lalaki ni Aaron, ang mga pari, ihahandog ang dugo at isasaboy ito sa altar na nasa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Pagkatapos dapat niyang balatan ang handog na susunugin at pagpira-pirasuhin ito. ");
INSERT INTO tglulb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Pagkatapos ilalagay ng mga anak na lalaki ni Aaron na pari ang apoy sa ibabaw ng altar at maglalagay ng kahoy para palakasin ang apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ilalagay ng mga anak na lalaki ni Aaron, na mga pari, ang mga piraso, ang ulo at ang taba nang maayos sa kahoy na nasa apoy na nasa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Pero dapat niyang hugasan ng tubig ang mga lamang-loob at ang mga binti nito. Pagkatapos susunugin ng pari ang lahat ng bagay sa altar bilang isang handog na susunugin. Magbibigay ito sa akin ng mabangong halimuyak; magiging isang handog ito na ginawa sa akin sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kung mula sa kawan ang kaniyang handog para sa handog na susunugin, isa sa mga tupa o isa sa mga kambing, isang lalaking walang kapintasan ang dapat niyang ihandog. ");
INSERT INTO tglulb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Dapat niya patayin ito sa hilagang dako ng altar sa harapan ni Yahweh. Isasaboy ng mga anak na lalaki ni Aaron, na mga pari, ang dugo nito sa bawat gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Pagkatapos dapat niyang pagpira-pirasuhin ito, kasama ang ulo at ang taba nito, at ilalatag ang mga iyon ng pari sa kahoy na nasa apoy, na nasa altar, ");
INSERT INTO tglulb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","subalit dapat niyang hugasan ng tubig ang mga lamang-loob at ang mga binti. Pagkatapos ihahandog ng pari ang kabuuan, at susunugin ito sa altar. Ito ay isang handog na susunugin, at magbibigay ito ng mabangong halimuyak para kay Yahweh; isang handog ito na ginawa sa kanya sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Kung ang handog niya kay Yahweh ay isang sinunog na handog na mga ibon, sa gayon dapat niyang dalhin bilang kaniyang handog ang alinman sa isang kalapati o batang ibon. ");
INSERT INTO tglulb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Dapat itong dalhin ng pari sa altar, pilipitin ang ulo nito, at sunugin ito sa altar. Pagkatapos dapat patuluin lahat ng dugo nito sa gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Dapat niyang alisin ang balun-balunan kasama ang mga laman nito, at itapon ito sa tabi ng altar sa silangang dako, sa lugar para sa mga abo. ");
INSERT INTO tglulb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Dapat niyang biyakin ito hawak ang mga pakpak, pero hindi niya ito dapat hatiin sa dalawang bahagi. Pagkatapos susunugin ito ng pari sa altar, sa kahoy na nasa apoy. Magiging isang handog na susunugin ito, at magbibigay ito ng mabangong halimuyak para kay Yahweh; magiging isang handog ito na ginawa sa kanya sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Kapag magdadala ang sinuman ng isang butil na handog kay Yahweh, dapat pinong harina ang kaniyang handog, at bubuhusan niya ito ng langis at lalagyan ito ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Dadalhin niya ang handog sa mga anak na lalaki ni Aaron ang mga pari, at doon kukuha ang pari ng isang dakot ng pinong harina kasama ang langis at ang insensong naroon. Pagkatapos susunugin ng pari ang handog sa altar para alalahaning may pagpapasalamat ang tungkol sa kabutihan ni Yahweh. Magbibigay ito ng mabangong halimuyak para kay Yahweh; magiging isang handog ito na ginawa sa kanya sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Mabibilang kina Aaron at sa kaniyang mga anak na lalaki ang anumang natirang butil na handog. Ganap na inilaan ito kay Yahweh mula sa mga handog kay Yahweh na ginawa sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Kapag naghahandog kayo ng isang butil na handog na walang pampaalsa na hinurno sa isang pugon, dapat malambot na tinapay ito na gawa sa pinong harinang hinaluan ng langis, o matigas na tinapay na walang pampaalsa, na pinahiran ng langis. ");
INSERT INTO tglulb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kung hinurno ang inyong butil na handog sa isang lapad na kawaling bakal, dapat gawa ito sa pinong harina na walang pampaalsang hinaluan ng langis. ");
INSERT INTO tglulb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Hahatiin ninyo ito sa pira-piraso at bubuhusan ito ng langis. Isang butil na handog ito. ");
INSERT INTO tglulb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kung niluto sa isang kawali ang inyong butil na handog, dapat gawa ito sa pinong harina at langis. ");
INSERT INTO tglulb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Dapat ninyong dalhin kay Yahweh ang butil na handog na ginawa mula sa mga bagay na ito, at idudulog ito sa pari, na siyang magdadala nito sa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Pagkatapos kukuha ang pari ng ilan mula sa butil na handog upang alalahaning may pagpapasalamat ang tungkol sa kabutihan ni Yahweh, at susunugin niya ito sa altar. Magiging isang handog ito sa pamamagitan ng apoy, at magbibigay ito ng mabangong halimuyak para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Mabibilang kina Aaron at sa kaniyang mga anak na lalaki ang anumang natira sa butil na handog. Ganap na inilaan ito kay Yahweh mula sa mga handog kay Yahweh na ginawa sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Walang butil na handog na inyong ihahandog kay Yahweh ang gagawing may pampaalsa, dahil hindi kayo dapat magsunog ng pampaalsa, ni anumang pulot, bilang handog na ginawa kay Yahweh sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ihahandog ninyo ang mga ito kay Yahweh bilang isang handog ng unang mga bunga, pero hindi gagamitin ang mga iyon upang magbigay ng mabangong halimuyak sa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Dapat ninyong timplahan ng asin ang bawat butil ninyong handog. Hindi ninyo kailanman dapat hayaang mawala ang asin ng kasunduan ng inyong Diyos mula sa inyong butil na handog. Kasama ng lahat ng inyong mga handog dapat maghandog kayo ng asin. ");
INSERT INTO tglulb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Kung maghahandog kayo kay Yahweh ng unang mga bunga ng isang butil na handog, maghandog ng sariwang butil na sinangag sa apoy at pagkatapos dinurog upang maging pagkain. ");
INSERT INTO tglulb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Pagkatapos dapat ninyong lagyan ito ng langis at insenso. Isang butil na handog ito. ");
INSERT INTO tglulb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Pagkatapos susunugin ng pari ang bahagi ng dinurog na butil at langis at insenso para alalahaning may pagpapasalamat ang tungkol sa kabutihan ni Yahweh. Isang handog ito na ginawa kay Yahweh sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Kung mag-alay ang isang tao ng isang handog para sa pagtitipon-tipon ng isang hayop mula sa grupo ng mga hayop, maging lalaki o babae, dapat siyang mag-alay ng isang hayop na walang kapintasan sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ipapatong niya ang kaniyang kamay sa ulo ng kaniyang handog at papatayin ito sa pintuan ng tolda ng pagpupulong. Pagkatapos isasaboy ng mga anak ni Aaron na lalaki na mga pari ang dugo nito sa mga gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Iaalay ng lalaki ang handog kay Yahweh na isang alay para sa pagtitipon-tipon sa pamamagitan ng apoy. Ang tabang bumabalot o nakadikit sa lamang-loob, ");
INSERT INTO tglulb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","at ang dalawang bato at ang tabang nasa mga puson, at ang taba ng atay, kasama ang mga bato—aalisin niya ang lahat ng ito. ");
INSERT INTO tglulb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Susunugin iyon ng mga anak ni Aaron na lalaki sa ibabaw ng altar kasama ang handog na susunugin, na naroon sa kahoy na nasa apoy. Magbibigay ito ng mabangong samyo para kay Yahweh; magiging handog ito na gawa para sa kanya sa pamamagitan ng apoy. ");
INSERT INTO tglulb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Kapag ang alay na handog ng lalaki sa isang pagtitipon-tipon para kay Yahweh ay mula sa kawan; lalaki o babae, dapat siyang maghandog ng isang alay na walang kapintasan. ");
INSERT INTO tglulb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kapag maghandog siya ng isang tupa para sa kaniyang alay, pagkatapos dapat niyang ihandog ito sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Ipapatong niya ang kaniyang kamay sa ulo ng kaniyang alay at papatayin ito sa harapan ng tolda ng pagpupulong. Pagkatapos isasaboy ng mga anak na lalaki ni Aaron ang dugo nito sa mga gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Maghahandog ang lalaki ng alay ng mga handog para sa pagtitipon-tipon bilang isang handog na gawa sa pamamagitan ng apoy kay Yahweh. Aalisin ang taba, ang buong taba ng buntot hanggang sa gulugod, at ang tabang bumabalot sa lamang-loob at ang lahat ng tabang malapit sa lamang-loob, ");
INSERT INTO tglulb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","at ang dalawang bato at ang tabang nasa mga ito, na nasa mga puson at ang taba ng atay, kasama ang mga bato— aalisin niya ang lahat ng ito. ");
INSERT INTO tglulb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","At susunugin ng pari ang lahat ng ito sa altar bilang isang pagkaing handog na gawa sa apoy kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","At kung ang handog ng lalaki ay isang kambing, kung gayon ihahandog niya ito sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Dapat niyang ipatong ang kaniyang kamay sa ulo ng kambing at patayin ito sa harapan ng tolda ng pagpupulong. Pagkatapos isasaboy ng mga anak na lalaki ni Aaron ang dugo nito sa mga gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ihahandog ng lalaki ang kaniyang alay kay Yahweh na gawa sa pamamagitan ng apoy. Aalisin niya ang tabang bumabalot sa lamang-loob, at ang lahat ng tabang malapit sa lamang-loob. ");
INSERT INTO tglulb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Aalisin niya rin ang dalawang bato at ang taba na nasa mga ito, na nasa mga puson at ang taba ng atay kasama ang mga bato. ");
INSERT INTO tglulb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Susunugin ng pari ang lahat ng iyon bilang isang pagkaing handog na gawa sa pamamagitan ng apoy, para magbigay ng isang mabangong samyo. Pag-aari ni Yahweh ang lahat ng taba. ");
INSERT INTO tglulb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Magiging isang permanenteng batas ito sa lahat ng mga salinlahi ng inyong bayan sa bawat lugar na gagawan ninyo ng inyong bahay, na dapat hindi kayo kakain ng taba o dugo.”' ");
INSERT INTO tglulb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Nagsalita si Yahweh kay Moises, sinasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Sabihin mo sa bayan ng Israel, 'Kapag nagkasala ang sinuman na hindi sinasadyang magkasala, sa paggawa ng alinmang bagay na inutos ni Yahweh na huwag gawin, at kung nakagawa siya ng isang bagay na ipinagbabawal, dapat gawin ang sumusunod. ");
INSERT INTO tglulb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Kung ang punong pari ang siyang nagkasala para magdala ng kasalanan sa mga tao, sa gayon hayaan siyang maghandog para sa kasalanang ginawa niya ng isang batang toro na walang kapintasan kay Yahweh bilang isang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Dapat niyang dalhin ang toro sa pasukan ng tolda ng pagpupulong sa harapan ni Yahweh, ipatong ang kaniyang kamay sa ulo nito, at patayin ang toro sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Kukuha ang hinirang na pari ng kaunting dugo ng toro at dadalhin ito sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Isasawsaw ng pari ang kanyang daliri sa dugo at iwiwisik ang kaunti nito ng pitong beses sa harapan ni Yahweh, sa harap ng kurtina ng kabanal-banalang lugar. ");
INSERT INTO tglulb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","At ilalagay ng pari ang kaunting dugo sa mga sungay ng altar ng mabangong insenso sa harapan ni Yahweh, na nasa tolda ng pagpupulong, at ibubuhos niya ang lahat ng natirang dugo ng toro sa paanan ng altar para sa mga handog na susunugin, na nasa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Aalisin niya ang lahat ng taba sa torong panghandog para sa kasalanan; ang tabang bumabalot sa mga lamang loob, lahat ng tabang nakadikit sa mga panloob na bahagi, ");
INSERT INTO tglulb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ang dalawang bato at ang taba na nasa mga ito, na nasa puson, at ang umbok ng atay, kasama ang mga bato— aalisin niya itong lahat. ");
INSERT INTO tglulb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Aalisin niya ang lahat ng ito, gaya ng kaniyang pag-alis nito mula sa torong alay ng handog para sa kapayapaan. Pagkatapos susunugin ng pari ang mga bahaging ito sa altar para sa mga handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ang balat ng toro at anumang natirang laman, kasama ang ulo at ang mga binti at ang mga panloob na bahagi at ang dumi nito, ");
INSERT INTO tglulb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ang lahat ng natirang bahagi ng toro—bibitbitin niya ang lahat ng bahaging ito sa labas ng kampo sa isang lugar na nilinis nila para sa akin, kung saan nila binubuhos ang mga abo; susunugin nila ang mga bahaging iyon doon sa kahoy. Dapat nilang sunugin ang mga bahaging iyon kung saan nila binubuhos ang mga abo. ");
INSERT INTO tglulb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Kung nagkasala ang buong kapulungan ng Israel nang hindi sinasadya, at hindi alam ng kapulungan na nagkasala sila at nakagawa ng anumang mga bagay na inutos ni Yahweh na huwag gawin, at kung nagkasala sila, ");
INSERT INTO tglulb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","pagkatapos, kapag naging hayag ang kasalanang ginawa nila, sa gayon dapat maghandog ang kapulungan ng isang batang toro bilang isang handog para sa kasalanan at dalhin ito sa harap ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ipapatong ng mga nakatatanda ng kapulungan ang kanilang mga kamay sa ulo ng toro sa harap ni Yahweh, at papatayin ang toro sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Dadalhin ng hinirang na pari ang kaunting dugo ng toro sa tolda ng pagpupulong, ");
INSERT INTO tglulb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","at isasawsaw ng pari ang kaniyang daliri sa dugo at iwiwisik ito nang pitong beses sa harapan ni Yahweh, sa harap ng kurtina. ");
INSERT INTO tglulb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Maglalagay siya ng kaunting dugo sa mga sungay ng altar na nasa harapan ni Yahweh, na nasa tolda ng pagpupulong, at ibubuhos niya ang lahat ng dugo sa paanan ng altar para sa mga handog na susunugin, na nasa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Aalisin niya ang lahat ng taba mula rito at susunugin ito sa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ganyan ang dapat niyang gawin sa toro. Gaya ng kaniyang ginawa sa torong handog para sa kasalanan, gayon din ang kaniyang gagawin sa torong ito, at gagawa ang pari ng pambayad ng kasalanan para sa mga tao, at papatawarin sila. ");
INSERT INTO tglulb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Bubuhatin niya ang toro sa labas ng kampo at susunugin ito gaya ng pagsunog niya sa unang toro. Ito ang handog para sa kasalanan para sa kapulungan. ");
INSERT INTO tglulb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Kapag nagkasala ang isang namumuno nang hindi sinasadya, sa paggawa ng anuman sa lahat ng mga bagay na inutos ni Yahweh na kanyang Diyos na huwag gawin, at kung nagkasala siya, ");
INSERT INTO tglulb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","pagkatapos kung ipinaalam sa kaniya ang kasalanang kaniyang ginawa, dapat siyang magdala para sa kaniyang alay ng isang kambing, isang lalaking walang kapintasan. ");
INSERT INTO tglulb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ipapatong niya ang kaniyang kamay sa ulo ng kambing at papatayin ito sa lugar kung saan nila pinapatay ang mga handog na susunugin sa harapan ni Yahweh. Isa itong handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kukunin ng pari ang dugo ng handog para sa kasalanan sa pamamagitan ng kaniyang daliri at ilalagay ito sa mga sungay ng altar para sa mga handog na susunugin, at ibubuhos niya ang dugo nito sa paanan ng altar ng handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Susunugin niya ang lahat ng taba sa altar, gaya ng taba ng alay ng mga handog para sa kapayapaan. Gagawa ang pari para sa ikapagpapatawad ng namumuno patungkol sa kaniyang kasalanan, at papatawarin ang namumuno. ");
INSERT INTO tglulb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Kung nagkasala ang sinuman sa mga karaniwang tao nang hindi sinasadya, sa paggawa ng anumang mga bagay na inutos ni Yahweh na huwag gawin, at kung nagkasala siya, ");
INSERT INTO tglulb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","pagkatapos kung alam niya ang kasalanang nagawa niya, sa gayon magdadala siya ng isang kambing para sa kaniyang alay, isang babaeng walang kapintasan, para sa kasalanang ginawa niya. ");
INSERT INTO tglulb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ipapatong niya ang kaniyang kamay sa ulo ng handog para sa kasalanan at papatayin ang handog para sa kasalanan sa lugar ng susunuging handog. ");
INSERT INTO tglulb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kukuha ang pari ng kaunting dugo gamit ang kaniyang daliri at ilalagay ito sa mga sungay ng altar para sa mga handog na susunugin. Ibubuhos niya ang lahat ng natirang dugo sa paanan ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Aalisin niya ang lahat ng taba, gaya ng pag-alis ng taba mula sa alay ng mga handog para sa kapayapaan. Susunugin ito ng pari sa altar upang magdulot ng isang matamis na samyo para kay Yahweh. Gagawa ang pari ng kabayaran ng kasalanan para sa tao, at papatawarin siya. ");
INSERT INTO tglulb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Kung magdadala ang isang tao ng isang kordero bilang alay niya para sa isang handog sa kasalanan, dadalhin niya ang isang babaeng walang kapintasan. ");
INSERT INTO tglulb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ipapatong niya ang kaniyang kamay sa ulo ng handog para sa kasalanan at papatayin ito para sa isang handog sa kasalanan sa lugar kung saan nila pinapatay ang handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kukuha ang pari ng kaunting dugo sa handog para sa kasalanan gamit ang kaniyang daliri at ilalagay ito sa mga sungay ng altar bilang mga handog na susunugin, at ibubuhos niya ang lahat ng dugo nito sa paanan ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Aalisin niya ang lahat ng taba, gaya ng ang taba ng kordero ay inalis mula sa alay ng mga handog para sa kapayapaan, at susunugin ito ng pari sa altar sa ibabaw ng mga handog ni Yahweh na gawa sa apoy. Gagawa ang pari ng pambayad ng kasalanan para sa kaniya para sa kasalanang ginawa niya, at papatawarin ang tao. ");
INSERT INTO tglulb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Kung magkasala ang sinuman dahil tumanggi siyang magpatotoo nang nakasaksi siya tungkol sa isang bagay na kung saan kinakailangan niyang magpatotoo, kahit na nakita niya ito o narinig ang tungkol dito, mayroon siyang pananagutan. ");
INSERT INTO tglulb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","O kung sinuman ang makakahipo ng anumang bagay na itinalaga ng Diyos bilang marumi, maging patay na katawan ito ng isang marumi na mabangis na hayop o katawan ng anumang mga hayop na patay, o gumagapang na hayop, kahit na hindi sinasadyang mahipo ito ng tao, siya ay marumi at nagkasala. ");
INSERT INTO tglulb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","O kung makakahawak siya ng karumihan ng isang tao, kung anumang karumihang iyon, at kung hindi niya alam ito, sa gayon magkakasala siya kapag nalaman niya ang tungkol dito. ");
INSERT INTO tglulb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","O kung sinuman ay sumumpa nang padalus-dalos sa pamamagitan ng kaniyang mga labi upang gumawa ng masama, o gumawa ng mabuti, anumang sumpa ang binitiwan ng isang tao nang padalus-dalos ng may isang panunumpa, kahit na hindi niya alam ito, kapag nalaman niya ang tungkol dito, kung gayon ay magkakasala siya, sa anumang mga bagay na ito. ");
INSERT INTO tglulb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Kapag nagkasala ang isang tao sa anumang mga bagay na ito, dapat ipagtapat niya ang anumang kasalanan na kaniyang nagawa. ");
INSERT INTO tglulb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Pagkatapos dapat niyang dalhin kay Yahweh ang kaniyang handog na pambayad sa kasalanan para sa kasalanang nagawa niya, isang babaeng hayop mula sa kawan, alinman sa isang tupa o isang kambing, para sa isang handog para sa kasalanan, at gagawa ang pari para sa ikapapatawad niya ukol sa kaniyang kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kung hindi niya kayang bumili ng isang tupa, kung gayon maaari niyang dalhin kay Yahweh bilang kaniyang handog na pambayad sa kasalanan ang dalawang kalapati o dalawang batang kalapati, isa para sa handog para sa kasalanan at ang isa para sa isang handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Dapat niyang dalhin ang mga ito sa pari, na ihahandog ang isa para sa isang handog para sa kasalanan—pipilipitin niya ang ulo nito mula sa leeg pero hindi niya tuluyang tatanggalin ito mula sa katawan. ");
INSERT INTO tglulb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Pagkatapos isasaboy niya sa gilid ng altar ang kaunting dugo ng handog pambayad para sa kasalanan, at ibubuhos niya ang natitirang dugo sa pundasyon ng altar. Ito ay isang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Pagkatapos dapat niyang ihandog ang pangalawang ibon bilang isang handog na susunugin, gaya ng inilarawan sa mga tagubilin, at gagawa ang pari ng kabayaran ng kasalanan para sa kaniya para sa nagawa niyang kasalanan, at patatawarin ang tao. ");
INSERT INTO tglulb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ngunit kung hindi niya kayang bumili ng dalawang kalapati o dalawang batang kalapati, kung gayon dapat dalhin niya bilang kaniyang alay para sa kaniyang kasalanan ang isang ikasampu ng isang epa ng pinong harina para sa handog para sa kasalanan. Hindi niya dapat lagyan ito ng langis o kahit anong insenso, dahil ito ay isang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Dapat niya dalhin ito sa pari, at kukuha ang pari ng isang dakot nito para isipin nang may pasasalamat tungkol sa kabutihan ni Yahweh at pagkatapos sunugin ito sa ibabaw ng altar, sa ibabaw ng mga handog na gawa sa pamamagitan ng apoy para kay Yahweh. Ito ay isang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Gagawa ang pari sa ikapapatawad ng anumang kasalanan na nagawa ng tao, at ang taong iyon ay patatawarin. Magiging pag-aari ng pari ang mga natira mula sa handog, gaya din ng handog na butil.”' ");
INSERT INTO tglulb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Pagkatapos nagsalita si Yahweh kay Moises, na nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Kung sinuman ay lumabag sa isang utos at nagkasala laban sa mga bagay na pagmamay-ari ni Yahweh, ngunit nagawa nang hindi sinasadya, kung gayon dapat dalhin niya kay Yahweh ang kaniyang handog na pambayad kasalanan. Dapat isang lalaking tupa na walang dungis mula sa kawan ang handog na ito; dapat tasahin ang halaga nito sa pilak na sekel—ang sekel ng santuwaryo—bilang handog na pambayad sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Dapat niya bigyan ng kasiyahan si Yahweh para sa kaniyang nagawang mali kaugnay sa kung ano ang banal, at dapat niya itong dagdagan ng ikalima at ibigay ito sa pari. Pagkatapos gagawa ang pari ng kabayaran sa kasalanan para sa kanya kasama ang lalaking tupa na handog na pambayad kasalanan, at patatawarin ang taong iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kung nagkasala ang isang tao at gumawa ng anumang bagay na iniutos ni Yahweh na hindi dapat gawin, kahit na hindi niya alam ito, nagkasala pa rin siya at dapat niya dalhin ang kaniyang sariling pagkakasala. ");
INSERT INTO tglulb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Dapat niyang dalhin ang isang lalaking tupa na walang kapintasan mula sa kawan, katumbas ng kasalukuyang halaga, bilang isang handog na pambayad sa kasalanan sa pari. Pagkatapos gagawa ang pari ng pambayad sa kasalanan para sa kanya ukol sa kanyang nagawang kasalanan, na kung saan hindi niya alam, at siya ay papatawarin. ");
INSERT INTO tglulb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Isang handog ito na pambayad sa kasalanan, at tiyak na nagkasala siya sa harap ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Nagsalita si Yahweh kay Moises, na nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Kung sinuman ang nagkasala at lumabag sa isang utos laban kay Yahweh, tulad ng sinungaling na pakikitungo sa kaniyang kapwa hinggil sa isang bagay na ipinagkatiwala sa kaniya, o kung nililinlang o ninanakawan niya, o pinahihirapan ang kaniyang kapwa, ");
INSERT INTO tglulb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","o nakakita ng isang bagay na nawala ng kaniyang kapwa at nagsinungaling tungkol dito, at nanumpa sa pagsisinungaling, o sa mga bagay na katulad nito na nagkasala ang mga tao, ");
INSERT INTO tglulb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","kung gayon, mangyayari na kung nagkasala siya at may kasalanan, na dapat niyang ibalik anuman ang kaniyang kinuha sa pamamagitan ng pagnanakaw o pang-aapi o pagkuha ng kung ano ang ipinagkatiwala sa kaniya o ang nawalang bagay na nakita niya. ");
INSERT INTO tglulb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","O kung nagsinungaling siya tungkol sa anumang bagay, dapat niyang ibalik ito nang buo at dapat dagdagan ng ikalima para bayaran siya na kung kanino ito inutang, sa araw na nakitaan siya na may kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Pagkatapos dapat niya dalhin kay Yahweh ang kaniyang handog na pambayad para sa kasalanan: isang lalaking tupa mula sa kawan na walang dungis na nagkakahalaga ng kasalukuyang halaga, bilang isang handog na pambayad para sa kasalanan sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Para sa kaniya ay gagawa ang pari ng isang pambayad para sa kasalanan sa harap ni Yahweh, at patatawarin siya ukol sa anumang kasalanang ginawa niya.” ");
INSERT INTO tglulb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Pagkatapos nagsalita si Yahweh kay Moises, na nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Utusan mo si Aaron at ang kaniyang mga anak na lalaki, at sabihin mo, 'Ito ang batas ng handog na susunugin: Dapat nasa ibabaw ng dapog ng altar ang handog na susunugin sa buong gabi hanggang umaga, at pananatilihing umaapoy ang apoy ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Isusuot ng pari ang kaniyang linong mga damit, at isusuot niya ang kaniyang linong mga damit na panloob. Kukunin niya ang naiwang mga abo pagkatapos na natupok ng apoy ang handog na pambayad para sa kasalanan sa ibabaw ng altar, at ilalagay niya ang mga abo sa gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Huhubarin niya ang kaniyang mga damit at isusuot ang ibang mga damit para dalhin ang mga abo sa labas ng kampo patungo sa isang lugar na malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Pananatilihing umaapoy ang apoy sa ibabaw ng altar. Hindi ito dapat mamatay, at ang pari ay magsusunog ng kahoy sa ibabaw nito tuwing umaga. Aayusin niya ang handog na pambayad para sa kasalanan ayon sa pangangailangan nito, at kaniyang susunugin dito ang taba ng mga handog pangkapayapaan. ");
INSERT INTO tglulb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Dapat patuloy na panatilihing umaapoy ang apoy sa ibabaw ng altar. Hindi ito dapat mamatay. ");
INSERT INTO tglulb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ito ang batas ng handog na pagkaing butil. Ihahandog ito ng mga anak na lalaki ni Aaron sa harap ni Yahweh sa harapan ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kukuha ang pari ng isang dakot ng pinong harina sa handog na pagkaing butil at sa langis at sa insenso na nasa handog na pagkaing butil, at susunugin niya ito sa altar para magpalabas ng isang mabangong samyo para isipin at magpasalamat tungkol sa kabutihan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kakainin ni Aaron at ng kaniyang mga anak na lalaki ang anumang natira sa handog. Dapat ito kainin nang walang pampaalsa sa isang banal na lugar. Kakainin nila ito sa patyo ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Hindi ito dapat ihurno nang may pampaalsa. Ibinigay ko ito bilang kanilang bahagi sa aking mga handog na gawa sa pamamagitan ng apoy. Pinakabanal ito, gaya ng handog para sa kasalanan at ng handog na pambayad para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Para sa lahat na panahong darating sa lahat ng mga salinlahi ng iyong bayan, maaaring makakain nito bilang kaniyang bahagi ang anumang lalaki na nagmumula kay Aaron, kinuha mula sa mga handog kay Yahweh na gawa sa pamamagitan ng apoy. Magiging banal ang sinumang humipo ng mga ito.”' ");
INSERT INTO tglulb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Kaya muling nagsalita si Yahweh kay Moises, na nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ito ang handog ni Aaron at ng kaniyang mga anak na lalaki, na kanilang ihahandog kay Yahweh sa araw na kung kailan papahiran ng langis ang bawat anak na lalaki: isang ikasampung bahagi ng isang ephah ng pinong harina bilang isang karaniwang handog na pagkaing butil, kalahati nito sa umaga at kalahati nito sa gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Gagawin ito sa isang panghurnong kawali na may langis. Kapag nababad na ito, dadalhin mo ito sa loob. Sa inihurnong pira-piraso ihahandog mo ang handog na pagkaing butil para magpalabas ng mabangong samyo para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ang anak na lalaki ng punong pari na siyang magiging bagong punong pari mula sa kaniyang mga anak na lalaki ang siyang mag-aalay nito. Gaya ng iniutos magpakailanman, susunugin ang lahat ng mga ito para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Lubusang susunugin ng pari ang bawat handog na pagkaing butil. Hindi ito dapat kainin.” ");
INSERT INTO tglulb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Muling nagsalita si Yahweh kay Moises, na nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Kausapin mo si Aaron at ang kaniyang mga anak na lalaki, na nagsasabing, 'Ito ang batas ng handog para sa kasalanan: Dapat patayin ang handog para sa kasalanan sa lugar na kung saan pinatay ang handog na susunugin sa harap ni Yahweh. Ito ay pinakabanal. ");
INSERT INTO tglulb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kakainin ito ng pari na naghandog nito para sa kasalanan. Dapat ito kainin sa isang banal na lugar sa patyo ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Magiging banal ang anumang makakahawak ng mga karneng ito, at kung naiwisik ang dugo sa anumang damit, dapat ninyong labahan ito, ang bahagi na tinilamsikan, sa isang banal na lugar. ");
INSERT INTO tglulb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Pero dapat basagin ang kaldero na pinakuluan nito. Kung pinakuluan ito sa isang tansong kaldero, dapat kuskusin ito at hugasan sa malinis na tubig. ");
INSERT INTO tglulb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Maaaring kainin ng sinumang lalaki mula sa mga pari ang ilan sa mga ito dahil ito ay pinakabanal. ");
INSERT INTO tglulb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","At walang handog para sa kasalanan ang dapat kainin mula sa kung saan anumang dugo ay dinala sa loob ng tolda ng pagpupulong para makagawa sa ikapapatawad ng kasalanan sa banal na lugar. Dapat itong sunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ito ang batas ng handog na pambayad para sa kasalanan. Pinakabanal ito. ");
INSERT INTO tglulb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Dapat nila patayin ang handog na pambayad para sa kasalanan sa lugar ng pagpatay dito, at dapat isaboy nila ang dugo nito sa bawat gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ihahandog ang lahat ng taba nito: ang taba ng buntot, ang taba na nasa panloob na mga bahagi, ");
INSERT INTO tglulb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ang dalawang bato at ang taba na nasa mga ito, na kasunod sa mga puson, at ang bumalot sa atay, kasama ang mga bato—dapat tanggalin ang lahat ng ito. ");
INSERT INTO tglulb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Dapat sunugin ng pari ang mga bahagi sa altar bilang isang handog na sinunog sa apoy para kay Yahweh. Ito ang handog na pambayad para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Bawat lalaki na kabilang sa mga pari ay maaaring kumain ng bahagi ng handog na ito. Dapat kainin ito sa isang banal na lugar dahil pinakabanal ito. ");
INSERT INTO tglulb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ang handog para sa kasalanan ay katulad ng handog na pambayad para sa kasalanan. Parehong batas ang ginagamit sa dalawang ito. Nabibilang ang mga ito sa pari na siyang gumawa ng pambayad para sa kasalanan sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ang pari na siyang naghahandog ng kanino mang handog na sinunog ay maaaring ilaan para sa kaniyang sarili ang balat ng handog na iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Bawat handog na pagkaing butil na inihurno sa isang hurno, at ang bawat handog na niluto sa isang kawali o sa isang kawaling panghurno ay mabibilang sa pari na siyang naghahandog nito. ");
INSERT INTO tglulb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Bawat handog na pagkaing butil, kahit tuyo o hinaluan ng langis, parehong mabibilang sa lahat ng mga kaapu-apuhan ni Aaron. ");
INSERT INTO tglulb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ito ang batas ng alay na handog para sa kapayapaan na ihahandog ng mga tao kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kung sinuman ang maghahandog nito para magbigay ng mga pasasalamat, kung gayon dapat niya ihandog ito kasama ng isang alay na mga tinapay na ginawa na walang pampaalsa, ngunit hinaluan ng langis, mga tinapay na ginawa na walang pampaalsa, ngunit pinahiran ng langis, at ang mga tinapay na ginawa gamit ang pinong harina na hinaluan ng langis. ");
INSERT INTO tglulb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pati rin ang para sa layunin ng pagbibigay ng mga pasasalamat, dapat ihandog niya kasama ang kaniyang handog na para sa kapayapaan ang mga tinapay na niluto na may pampaalsa. ");
INSERT INTO tglulb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ihahandog niya ang isa sa bawat uri ng mga alay bilang isang handog na idudulog kay Yahweh. Magiging pag-aari ito ng mga pari na siyang nagsaboy ng dugo ng mga handog para sa kapayapaan sa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ang taong naghahandog ng isang handog para sa kapayapaan para sa layunin ng pagbibigay ng mga pasasalamat ay dapat kainin ang karne na kanyang handog sa araw ng pag-alay. Wala siyang dapat itira na anuman nito hanggang sa susunod na umaga. ");
INSERT INTO tglulb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ngunit kung ang alay na kaniyang handog ay para sa layunin ng isang panata, o para sa isang layunin ng pagkukusang-loob na handog, kakainin dapat ang karne sa araw na kaniyang ihahandog ang kanyang alay, pero kung anuman ang natira nito ay maaaring kainin kinabukasan. ");
INSERT INTO tglulb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Subalit, kung anumang karne ng alay na natira sa ikatlong araw ay dapat sunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kung anuman sa karne ng alay ng tao na handog para sa kapayapaan ay kinain sa ikatlong araw, hindi ito tatanggapin, ni bibigyang pagkilala ang taong naghandog nito. Ito ay magiging isang kasuklam-suklam na bagay, at ang tao na siyang kumain nito ay dadalhin ang pagkakasala ng kaniyang kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Anumang karne na madikit sa maruming bagay ay hindi dapat kainin. Dapat itong sunugin. Ganoon din sa natirang karne, sinuman ang malinis ay maaaring kumain nito. ");
INSERT INTO tglulb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Subalit, ang taong marumi na kumain sa anumang karne mula sa alay ng isang handog para sa kapayapaan na pag-aari ni Yahweh—dapat itiwalag ang taong iyon mula sa kaniyang mga kababayan. ");
INSERT INTO tglulb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kung sinuman ang makahahawak ng anumang bagay na marumi—kahit ang taong walang kalinisan, o hayop na hindi malinis, o alin mang hindi malinis at nakapandidiring bagay, at kung kinain niya ang ilan sa karne na isang alay na handog para sa kapayapaan na pag-aari ni Yahweh, dapat itiwalag ang taong iyon mula sa kaniyang mga kababayan.”' ");
INSERT INTO tglulb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Pagkatapos nangusap si Yahweh kay Moises, sinasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Kausapin mo ang bayan ng Israel at sabihin, 'Hindi kayo dapat kumain ng taba ng isang baka o tupa o kambing. ");
INSERT INTO tglulb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ang taba ng isang hayop na namatay na hindi naalay, o ang taba ng isang hayop na nilapang mga mababangis na hayop, maaaring gamitin para sa ibang mga layunin, pero tiyak na hindi ninyo dapat kainin ito. ");
INSERT INTO tglulb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Sinuman ang kumain ng taba ng isang hayop na maaaring ihandog ng mga lalaki bilang isang alay na susunugin sa apoy para kay Yahweh, dapat itiwalag ang taong iyon mula sa kaniyang mga lahi. ");
INSERT INTO tglulb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Hindi dapat kayo kumain ng anumang dugo sa anuman sa inyong mga bahay, mula man ito sa isang ibon o sa isang hayop. ");
INSERT INTO tglulb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Sinuman ang kumain ng anumang dugo, dapat itiwalag ang taong iyon mula sa kaniyang mga kababayan.”' ");
INSERT INTO tglulb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Kaya nangusap si Yahweh kay Moises at sinabi, ");
INSERT INTO tglulb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Kausapin mo ang bayan ng Israel at sabihin, 'Sino man ang maghandog ng alay ng isang handog para sa kapayapaan para kay Yahweh ay dapat magdala ng bahagi ng kaniyang alay para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ang handog para kay Yahweh na susunugin sa apoy, dapat ang kaniyang sariling mga kamay ang magdala nito. Dapat niya dalhin ang taba kasama ang dibdib, para ang dibdib ay maging isang handog na maitaas sa harapan ni Yahweh at idulog sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Dapat sunugin ng pari ang taba sa altar, pero ang dibdib ay ikakaloob kay Aaron at sa kaniyang mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Dapat ibigay ninyo ang kanang hita sa pari bilang isang handog na idinulog mula sa alay ng inyong handog para sa kapayapaan. ");
INSERT INTO tglulb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ang pari, isa sa mga kaapu-apuhan ni Aaron, ang naghandog ng dugo ng mga handog para sa kapayapaan at ang taba—magkakaroon siya ng kanang hita bilang kaniyang bahagi sa handog. ");
INSERT INTO tglulb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Dahil kinuha ko ang handog na dibdib at hita na itinaas at idinulog sa akin, at ibinigay ko ang mga ito kay Aaron, ang pinakapunong pari at sa kaniyang mga kaapu-apuhan; patuloy itong magiging kanilang bahagi mula sa mga alay na handog para sa kapayapaan na ginawa ng bayan ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ito ay bahagi para kay Aaron at sa kaniyang mga kaapu-apuhan mula sa mga handog para kay Yahweh na sinunog sa apoy, sa araw na iniharap sila ni Moises para maglingkod kay Yahweh sa gawain ng pari. ");
INSERT INTO tglulb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ito ang mga bahagi na iniutos ni Yahweh na ibigay sa kanila mula sa bayan ng Israel, sa araw na kaniyang hinirang ang mga pari. Patuloy itong magiging kanilang bahagi sa lahat ng mga salinlahi. ");
INSERT INTO tglulb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ito ang batas ng sinunog na handog, handog na pagkaing butil, handog para sa kasalanan, handog na pambayad para sa kasalanan, handog na pagpapabanal, at alay na handog para sa kapayapaan, ");
INSERT INTO tglulb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","kung saan ibinigay ni Yahweh ang mga utos kay Moises sa Bundok Sinai sa araw na kaniyang iniutusan ang bayan ng Israel na maghandog ng kanilang mga alay kay Yahweh sa ilang g Sinai.”' ");
INSERT INTO tglulb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Nagsalita si Yahweh kay Moises, sinasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Isama mo si Aaron at ang kaniyang mga anak na lalaki, ang mga kasuotan at ang langis na pampahid, ang toro para sa mga paghahandog sa kasalanan, ang dalawang lalaking tupa, at ang basket ng tinapay na walang pampaalsa. ");
INSERT INTO tglulb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Tipunin ang lahat ng kapulungan sa pasukan patungo sa tolda ng pagpupulong.” ");
INSERT INTO tglulb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Kaya ginawa ni Moises ang ipinag-utos ni Yahweh sa kaniya, at sama-samang dumating ang kapulungan sa pasukan patungo sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Pagkatapos sinabi ni Moises sa kapulungan, “Ito ang ipinag-utos ni Yahweh na dapat gawin.” ");
INSERT INTO tglulb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Dinala ni Moises si Aaron at ang kaniyang mga anak na lalaki at hinugasan sila ng tubig. ");
INSERT INTO tglulb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Inilagay niya kay Aaron ang tunika at itinali ang kabitan sa palibot sa kaniyang baywang, binihisan siya ng kasuotan at inilagay ang efod sa kaniya, at pagkatapos itinali niya ang efod sa palibot niya kasama ng kabitan na hinabi nang pino at itinali ito sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Inilagay niya ang baluti sa kaniya, at sa baluti inilagay niya ang Urim at Tummim. ");
INSERT INTO tglulb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Inilapat niya ang turbante sa ibabaw ng kaniyang ulo, at sa ibabaw ng turbante, sa harapan, inilagay niya ang gintong plato, ang banal na korona, ayon sa ipinag-utos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Kinuha ni Moises ang pampahid na langis, pinahiran ang tabernakulo at ang lahat ng bagay sa loob nito, at inihandog ang mga ito kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Winisikan niya ng langis ang ibabaw ng altar ng pitong ulit, at pinahiran ang altar at ang lahat nitong kagamitan, at ang panghugas na palanggana at ang patungan nito, para ihandog ang mga ito kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Binuhusan niya ng kaunting pampahid na langis ang ulo ni Aaron at pinahiran siya para ihandog siya kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Dinala ni Moises ang mga anak na lalaki ni Aaron at binihisan sila ng mga tunika; itinali niya ang mga kabitan sa palibot ng kanilang mga baywang at ibinalot ng lino na damit sa palibot ng kanilang mga ulo, ayon sa ipinag-utos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Dinala ni Moises ang torong handog para sa kasalanan, at si Aaron at ang kaniyang mga anak na lalaki ay ipinatong ang kanilang mga kamay sa ulo ng toro na kanilang dinala para ihandog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Pinatay niya ito, at kinuha niya ang dugo at inilagay niya ito sa mga sungay ng altar gamit ang kaniyang daliri, nilinisan ang altar, binuhusan ng dugo ang patungan ng altar, at ibinukod ito para sa Diyos para sa kabayaran ng kasalanan para dito. ");
INSERT INTO tglulb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Kinuha niya ang lahat ng taba sa laman-loob, ang bumabalot sa atay, at ang dalawang bato at ang kanilang taba, at sinunog ni Moises ang lahat ng ito sa ibabaw ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Pero ang toro, balat nito, karne nito, at dumi nito ay sinunog niya sa labas ng kampo, gaya ng iniutos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Inalay ni Moises ang lalaking tupa para sa handog na susunugin, at ipinatong ni Aaron at ng kaniyang mga anak na lalaki ang kanilang mga kamay sa ulo ng lalaking tupa. ");
INSERT INTO tglulb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Pinatay niya ito at isinaboy ang dugo nito sa bawat gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Hiniwa niya ang lalaking tupa nang pira-piraso at sinunog ang ulo at ang mga piraso at ang taba. ");
INSERT INTO tglulb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Hinugasan niya ang laman loob at ang mga binti sa pamamagitan ng tubig, at kaniyang sinunog ang isang buong lalaking tupa sa ibabaw ng altar. Ito ay isang handog na susunugin at naglalabas ng mabangong halimuyak, isang paghahandog na gawa sa pamamagitan ng apoy para kay Yahweh inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Pagkatapos iniharap ni Moises ang ibang tupa, ang tupang lalaki ng pagtatalaga, at ipinatong ni Aaron at ng kaniyang mga anak na lalaki ang kanilang mga kamay sa ibabaw ng ulo ng lalaking tupa. ");
INSERT INTO tglulb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Pinatay ito ni Aaron at kumuha si Moises ng kaunting dugo nito at inilagay ito sa dulo ng kanang tainga ni Aaron, sa hinlalaki ng kaniyang kanang kamay at sa hinlalaki ng kaniyang kanang paa. ");
INSERT INTO tglulb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Dinala niya ang mga anak na lalaki ni Aaron, at inilagay niya ang kaunting dugo sa ibabaw ng dulo ng kanilang kanang tainga, sa hinlalaki ng kanilang kanang kamay, at sa hinlalaki ng kanilang kanang paa. Pagkatapos isinaboy ni Moises ang dugo nito sa bawat gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Kinuha niya ang taba, ang taba ng buntot, ang lahat ng taba sa mga laman-loob, ang bumabalot sa atay at ang dalawang bato at ang kanang hita. ");
INSERT INTO tglulb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Mula sa basket ng tinapay na walang na walang pampaalsa at isang nilangisan na tinapay at isang barkilyos, at inilagay ang mga ito sa ibabaw ng taba at sa kanang hita. ");
INSERT INTO tglulb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Inilagay niya ang lahat ng ito sa mga kamay ni Aaron at sa mga kamay ng kaniyang mga anak na lalaki, itinaas ang mga ito bilang isang paghahandog sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Kaya kinuha ni Moises ang mga ito mula sa kanilang mga kamay at sinunog ang mga ito sa ibabaw ng altar para sa mga handog na susunugin. Ang mga ito'y isang handog ng pagtatalaga at naglabas ng mabangong halimuyak. Ito ay isang paghahandog na ginawa sa pamamagitan ng apoy para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Kinuha si Moises ang dibdib at itinaas ito bilang isang handog kay Yahweh. Ito ang bahagi ni Moises sa tupang lalaki para sa pantalaga sa pari, ayon sa ipinag-utos ni Yahweh sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Kumuha si Moises ng kaunting pampahid na langis at dugo na nasa ibabaw ng altar; iwinisik niya ang mga ito kay Aaron, sa kaniyang mga damit, sa kaniyang mga anak na lalaki, at sa mga damit ng kaniyang mga anak na lalaki. Sa ganitong paraan inihandog niya si Aaron at ang kaniyang mga damit, at kaniyang mga anak na lalaki at ang kanilang mga damit kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Kaya sinabi ni Moises kay Aaron at sa kaniyang mga anak na lalaki, “Pakuluan ninyo ang karne sa pasukan ng tolda ng pagpupulong, at doon kainin ito at ang tinapay na nasa basket ng pagtatalaga, ayon sa aking ipinag-utos, na nagsasabing, 'Sina Aaron at ang kaniyang mga anak na lalaki ang kakain nito. ");
INSERT INTO tglulb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kung anuman ang matitira sa karne at sa tinapay dapat mo itong sunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","At hindidapat kayo lumabas mula sa pasukan ng tolda ng pagpupulong sa loob ng pitong araw, hanggang sa matapos ninyo ang mga araw ng inyong pagtatalaga. Dahil itatalaga kayo ni Yahweh sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Kung anuman ang nagawa sa araw na ito -Si Yahweh ang nag-utos na gawin para pantubos para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mananatili kayo araw at gabi sa pasukan ng tolda ng pagtitipon sa loob ng pitong araw at susundin ang utos ni Yahweh, para hindi kayo mamatay, dahil ito ang ipinag-utos sa akin. ");
INSERT INTO tglulb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Kaya sinunod ni Aaron at ng kaniyang mga anak na lalaki ang lahat ng mga bagay na ipinag-utos ni Yahweh sa kanila sa pamamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sa ikawalong araw tinawag ni Moises si Aaron at kaniyang mga anak na lalaki at ang mga nakatatanda ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Sinabi niya kay Aaron, “Kumuha ka ng isang guya mula sa kawan para sa handog para sa kasalanan, at isang tupang lalaki na walang dungis para sa handog na susunugin, at ialay ang mga ito sa harap Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Dapat makipag-usap ka sa bayan ng Israel at sabihin, 'Kumuha kayo ng isang lalaking kambing bilang isang handog para sa kasalanan at isang guya at isang tupa, parehong isang taong gulang at walang kapansanan, para sa isang handog na susunugin; ");
INSERT INTO tglulb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","kumuha rin ng isang bakang lalaki at isang tupang lalaki para sa mga handog para sa kapayapaan para ialay sa harapan ni Yahweh, at isang handog na pagkaing butil na hinaluan ng langis, dahil sa araw na ito magpapakita sa inyo si Yahweh.'” ");
INSERT INTO tglulb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Kaya dinala nila ang lahat ng iniutos ni Moises sa tolda ng pagpupulong, at lumapit ang buong kapulungan ng Israel at tumayo sa harap ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Pagkatapos sinabi ni Moises, “Ito ang iniutos ni Yahweh na inyong gawin, para maihayag sa inyo ang kaniyang kaluwaltian.” ");
INSERT INTO tglulb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Sinabi ni Moises kay Aaron, “Lumapit ka sa altar at ialay ang iyong handog para sa kasalanan at handog na susunugin, at gumawa ng kabayaran sa kasalanan para sa iyong sarili at para sa mga tao, at ihandog ang alay para sa mga tao bilang kabayaran ng kasalanan para sa kanila, tulad ng iniutos ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Kaya lumapit si Aaron sa altar at pinatay ang guya bilang handog para sa kasalanan, na para sa kaniyang sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Dinala ng mga lalaking anak ni Aaron ang dugo sa kaniya, at isinawsaw niya ang kaniyang daliri dito at inilagay ito sa mga sungay ng altar; pagkatapos ibinuhos niya ang dugo sa paanan ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Gayunman, sinunog niya ang taba, ang mga bato, at ang balot ng atay sa ibabaw ng altar bilang isang handog para sa kasalanan, tulad ng iniutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","At sinunog niya ang laman at ang balat sa labas ng kampo. ");
INSERT INTO tglulb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Pinatay ni Aaron ang handog na susunugin, at ibinigay sa kaniya ng kaniyang mga anak na lalaki ang dugo, na kaniyang iwinisik sa bawat gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Pagkatapos ibinigay nila sa kaniya ang handog na susunugin, piraso bawat piraso, kasama ang ulo, at sinunog niya ang mga ito sa ibabaw ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Hinugasan niya ang mga panloob na bahagi at ang mga binti at sinunog ang mga ito sa ibabaw ng handog na susunugin sa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Idinulog ni Aaron ang alay ng mga tao-isang kambing, pagkatapos kinuha ito bilang alay para sa kanilang kasalanan at pinatay ito; inialay niya ito para sa kasalanan, gaya ng kaniyang ginawa sa unang kambing. ");
INSERT INTO tglulb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Idinulog niya ang handog na susunugin at inihandog ito ayon sa iniutos ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Idinulog niya ang handog na pagkaing butil; pinuno niya ang kaniyang kamay nito at sinunog ito sa ibabaw ng altar, kasama ang pang-umagang handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Pinatay niya rin ang kapong baka at ang tupang lalaki, ang alay bilang handog para sa kapayapaan, na para sa mga tao. Ibinigay ng mga anak na lalaki ni Aaron ang dugo sa kaniya, na iwinisik niya sa bawat gilid ng altar. ");
INSERT INTO tglulb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Gayunman, ang taba ng toro at ang tupang lalaki, ang taba ng buntot, ang taba na nakabalot sa mga laman loob, ang mga bato, at ang balot sa atay— ");
INSERT INTO tglulb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","inilagay nila ang mga ito sa mga dibdib, at pagkatapos sinunog ni Aaron ang taba sa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Itinaas ni Aaron ang mga dibdib at ang kanang hita bilang isang handog sa harapan ni Yahweh at idinulog ang mga ito sa kaniya, tulad ng iniutos ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Pagkatapos itinaas ni Aaron ang kaniyang mga kamay sa mga tao at pinagpala sila; pagkatapos bumaba siya mula sa paghahandog ng handog para sa kasalanan, ang handog na susunugin, at ang handog para sa kapayapaan. ");
INSERT INTO tglulb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Pumasok sina Moises at Aaron sa loob ng tolda ng pagpupulong, pagkatapos lumabas ulit at pinagpala ang mga tao, at nagpakita ang kaluwalhatian ni Yahweh sa lahat ng mga tao. ");
INSERT INTO tglulb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Lumabas ang apoy mula kay Yahweh at tinupok ang handog na susunugin at ang taba sa altar. Nang makita ito ng lahat ng mga tao, sumigaw sila at nagpatirapa. ");
INSERT INTO tglulb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Kumuha ng kani-kaniyang insensaryo sina Nadab at Abihu na mga anak ni Aaron, nilagyan ito ng apoy at saka insenso. Pagkatapos naghandog sila ng hindi karapat-dapat na apoy sa harapan ni Yahweh na hindi niya iniutos sa kanila na ihandog. ");
INSERT INTO tglulb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kaya lumabas ang apoy mula sa harapan ni Yahweh at sila ay nilamon at namatay sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Pagkatapos sinabi ni Moises kay Aaron, “Ito ang tinutukoy ni Yahweh nang sinabi niyang, 'Ihahayag ko ang aking kabanalan sa sinumang lalapit sa akin. Luluwalhatiin ako sa harapan ng lahat ng mga tao.'” Walang kahit anong sinabi si Aaron. ");
INSERT INTO tglulb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Tinawag ni Moises sina Misael at Elzafan na mga anak na lalaki ni Uziel na tiyuhin ni Aaron at sinabi sa kanilang, “Halikayo rito at dalhin ang inyong mga kapatid palabas ng kampo mula sa tabernakulo.” ");
INSERT INTO tglulb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Kaya lumapit sila at binuhat sila, na suot pa rin ang kanilang pang paring tunika, palabas ng kampo ayon sa iniutos ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Pagkatapos sinabi ni Moises kay Aaron at kay Eleazar at kay Itamar na kaniyang mga anak na lalaki, “Huwag ninyong hayaan ang buhok sa inyong mga ulo na nakalugay, at huwag punitin ang inyong mga damit, para hindi kayo mamatay at para hindi mapoot si Yahweh sa buong kapulungan. Pero hayaan ninyo ang inyong mga kamag-anak, ang buong bahay ng Israel ang magluksa para sa mga sinunog ng apoy ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Hindi kayo maaaring lumabas mula sa pasukan ng tolda ng pagpupulong o kayo ay mamamatay, dahil ang pambasbas na langis ni Yahweh ay nasa inyo.” Kaya sumunod sila ayon sa mga iniutos ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Nangusap si Yahweh kay Aaron, sinabing, ");
INSERT INTO tglulb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Huwag uminom ng alak o matapang na inumin, ikaw, ni ang iyong mga anak na lalaki na natitirang kasama mo, para kapag pumasok ka sa tolda ng pagpupulong hindi kayo mamatay. Ito ay permanenteng batas sa buong salinlahi ng iyong mga mamamayan, ");
INSERT INTO tglulb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","para maibukod ang banal sa pangkaraniwan, at ang marumi sa malinis, ");
INSERT INTO tglulb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","para maituro mo sa mga mamamayan ng Israel ang lahat ng batas na iniutos ni Yahweh sa pamamagitan ni Moises.” ");
INSERT INTO tglulb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Nakipag-usap si Moises kay Aaron at kay Eleazar at kay Itamar, na kaniyang natitirang mga anak na lalaki, “Kunin ang mga handog na pagkaing butil na natira mula sa mga handog kay Yahweh na ginawa sa pamamagitan ng apoy, at kainin ito nang walang pampaalsa sa tabi ng altar, dahil ito ang pinakabanal. ");
INSERT INTO tglulb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Dapat ninyong kainin ito sa isang banal na lugar, dahil ito ay bahaging para sa iyo at bahagi ng iyong mga anak na lalaki sa mga handog para kay Yahweh na ginawa sa pamamagitan ng apoy, dahil ito ang iniutos sa akin na sabihin sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ang dibdib na itinaas bilang handog at ang hita na idinulog kay Yahweh—ang mga ito ay dapat ninyong kainin sa isang malinis na lugar na katanggap-tanggap sa Diyos. Dapat kainin mo at ng iyong mga anak na lalaki at mga anak na babae ang mga bahaging iyon, dahil ibinigay ang mga iyon bilang iyong bahagi at bahagi ng iyong mga anak na lalaki mula sa mga alay ng handog sa pagtitipon-tipon ng bayan ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ang hita na isang handog na inialay kay Yahweh at ang dibdib na bahagi na itinaas bilang isang handog—dapat nilang dalhin ang mga iyon kasama ng mga handog na taba na ginawa sa pamamagitan ng apoy, para itaas ang mga ito at idulog bilang isang handog kay Yahweh. Magiging sa iyo at sa iyong mga anak na lalaki na kasama mo ang mga ito bilang isang bahagi magpakailanman ayon sa iniutos ni Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Pagkatapos tinanong ni Moises ang tungkol sa kambing na handog para sa kasalanan, at nalaman na ito ay nasunog na. Kaya nagalit siya kina Eleazar at Itamar, ang mga natitirang anak na lalaki ni Aaron; sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Bakit hindi ninyo kinain ang handog para sa kasalanan sa lugar ng tabernakulo, yamang ito ang pinakabanal, at ibinigay ito ni Yahweh para maalis ang kasalanan ng buong kapulungan, na maging kabayaran para sa kanilang kasalanan sa kaniyang harapan? ");
INSERT INTO tglulb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tingnan ninyo, ang dugo nito ay hindi dinala sa loob ng tabernakulo, kaya dapat talagang kinain ninyo ito sa lugar ng tabernakulo, ayon sa iniutos ko.” ");
INSERT INTO tglulb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Pagkatapos sumagot si Aaron kay Moises, “Tingnan mo, ngayon ginawa nila ang kanilang handog para sa kasalanan at handog na susunugin sa harapan ni Yahweh, at ang bagay na ito ay nangyari sa akin ngayon. Kung kinain ko ang handog para sa kasalanan ngayon, magiging kaaya-aya ba ito sa paningin ni Yahweh?” ");
INSERT INTO tglulb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Nang marinig iyon ni Moises, siya ay nasiyahan. ");
INSERT INTO tglulb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Nagsalita si Yahweh kay Moises at kay Aaron, nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Magsalita kayo sa bayan ng Israel, sabihin ninyo, ' ito ang mga bagay na buhay na maaari ninyong kainin sa lahat ng mga hayop na nasa ibabaw ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Maaari ninyong kainin ang alinmang hayop na hati ang kuko at gayundin ang ngumunguya ng pagkain. ");
INSERT INTO tglulb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Gayunman, ang ilang mga hayop maging ang ngumunguya ng pagkain o may hati ang kuko, hindi ninyo dapat kainin ang mga ito, mga hayop tulad ng kamelyo, dahil ngumunguya ito ng pagkain ngunit hindi hati ang kuko. Kaya marumi ang kamelyo para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Gayundin ang liebre na nakatira sa batuhan: dahil ngumunguya ito ng pagkain ngunit hindi hati ang kuko, marumi rin ito para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","At ang kuneho: dahil ngumunguya ito ng pagkain ngunit hindi hati ang kuko, marumi ito para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","At ang baboy kahit hati ang kuko, hindi ito ngumunguya, kaya marumi ito para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Hindi ninyo dapat kainin alinman sa kanilang karne, ni hawakan ang kanilang patay na katawan. Marumi ang mga ito para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ang mga hayop na nabubuhay sa tubig na maaari ninyong kainin ay iyong may mga palikpik at may mga kaliskis, maging nasa karagatan man o nasa mga ilog. ");
INSERT INTO tglulb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ngunit lahat ng mga nabubuhay na nilikha na walang mga palikpik at kaliskis na nasa karagatan o mga ilog, kasama ang lahat ng mga gumagalaw na nasa tubig at lahat ng mga nabubuhay na nilikha na nasa tubig—maging kasuklam-suklam ang mga ito para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Dahil ang mga ito ay dapat kasuklaman, hindi ninyo dapat kainin ang kanilang laman; gayundin, dapat kasuklaman ang mga patay na katawan ng mga ito. ");
INSERT INTO tglulb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Anumang mga walang mga palikpik o mga kaliskis na nasa tubig ay dapat ninyong kasuklaman. ");
INSERT INTO tglulb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ito ang mga ibong dapat ninyong kasuklaman at hindi dapat kainin: ang agila, ang buwitre. ");
INSERT INTO tglulb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ang halkon, anumang uri ng palkon, ");
INSERT INTO tglulb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","bawat uri ng uwak, ");
INSERT INTO tglulb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ang kuwagong may sungay at ang malaking kuwago, ang tagak at ang anumang uri ng lawin. ");
INSERT INTO tglulb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Dapat din ninyong kasuklaman ang maliit na kuwago at ang malaking kuwago, ang maninisid-isda, ");
INSERT INTO tglulb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ang puting kuwago at kuwagong kamalig, ang ibong ospri, ");
INSERT INTO tglulb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ang tagak, anumang uri ng bakaw, ang ubabila at gayundin ang paniki. ");
INSERT INTO tglulb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Dapat ninyong kasuklaman ang lahat ng lumilipad na kulisap na lumalakad gamit ang mga paa. ");
INSERT INTO tglulb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Gayunman maaari ninyong kainin alinman sa lumilipad na mga kulisap na lumalakad din gamit ang paa, kung may mga binti sila sa itaas ang kanilang mga paa, na ginagamit upang tumalon sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","At maaari rin ninyong kainin ang anumang uri ng balang, lukton, kuliglig o tipaklong. ");
INSERT INTO tglulb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ngunit dapat ninyong kasuklaman ang lahat ng lumilipad na mga kulisap na may apat na paa. ");
INSERT INTO tglulb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Magiging marumi kayo hanggang sa gabi kung hahawakan ninyo ang patay na katawan ng isa sa mga ito. ");
INSERT INTO tglulb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Dapat labhan ang damit ng sinumang pumulot ng isa sa mga patay na katawan ng mga ito at manatiling marumi hanggang sa gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Marumi para sa inyo ang bawat hayop na hindi ganap na nahati ang kuko o hindi ngumunguya ng pagkain. Magiging marumi ang bawat isa na hahawak sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Marumi para sa inyo ang anumang naglalakad sa mga pangamot nito sa lahat ng hayop na lumalakad gamit ang lahat na apat na paa. Magiging marumi hanggang sa gabi ang sinumang humawak sa ganoong patay na katawan. ");
INSERT INTO tglulb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Dapat labhan ang kaniyang mga damit at maging marumi hanggang sa gabi ang sinumang pumulot sa ganoong patay na katawan. Marumi para sa inyo ang mga hayop na ito. ");
INSERT INTO tglulb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Sa mga hayop na gumagapang sa lupa, ito ang mga hayop na magiging marumi para sa inyo: ang bubuwit, ang daga, bawat uri ng malalaking butiki, ");
INSERT INTO tglulb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ang tuko, ang bayawak, ang butiki, ang bubuli at ang hunyango. ");
INSERT INTO tglulb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Sa lahat ng mga hayop na gumagapang, ito ang mga hayop na magiging marumi para sa inyo. Sinumang humawak sa mga ito kapag namatay, magiging marumi hanggang sa gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","At kung alinman sa mga ito ang namatay at nahulog sa anumang bagay, magiging marumi ang bagay na iyon, kahit gawa ito sa kahoy, tela, balat o telang magaspang. Anuman ito at anuman ang mga gamit nito, dapat itong ilagay sa tubig; magiging marumi ito hanggang sa gabi. Pagkatapos magiging malinis na ito. ");
INSERT INTO tglulb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Sapagka't bawat palayok na mahulugan ng anumang maruming hayop, magiging marumi anuman ang nasa palayok, at dapat ninyong wasakin ang palayok na iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Lahat ng malinis na pagkain at pinahihintulutang kainin, ngunit kung nabuhusan ng tubig mula sa isang maruming palayok, sa gayon magiging marumi ito. At anumang bagay na maaaring maiinom mula sa bawat palayok ay magiging marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Magiging marumi ang lahat ng bagay na mabagsakan ng anumang bahagi ng patay na katawan ng maruming hayop, kahit isang pugon ito o mga lutuang palayok. Dapat itong basagin sa pira-piraso. Marumi ito at dapat maging marumi para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Mananatiling malinis ang Isang bukal o hukay kung saan naiipon ang inuming tubig kung mahulog ang ganoong mga nilalang dito. Ngunit kung sinumang humawak sa patay na katawan ng isang maruming hayop sa tubig, magiging marumi siya. ");
INSERT INTO tglulb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kung anumang bahagi ng isang maruming patay na katawan ang nahulog sa mga butong itatanim, mananatiling malinis ang mga butong iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ngunit kung nabasa ng tubig ang mga buto at kung anumang bahagi ng isang maruming patay na katawan ang nahulog doon, sa gayon magiging marumi ang mga ito para sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Kung mamamatay ang anumang hayop na maaari ninyong kainin, sa gayon ay magiging marumi hanggang sa gabi ang sinumang humawak sa katawan ng patay na hayop. ");
INSERT INTO tglulb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","At kung sinuman ang kumain sa katawan ng patay na hayop na iyon ay lalabhan niya ang kaniyang damit at magiging marumi hangggang gabi. At sinumang pumulot sa gayong patay na hayop ay dapat niyang labhan ang kaniyang mga damit at magiging marumi hanggang sa gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Ang bawat hayop na gumagapang sa lupa ay kasuklaman ninyo, hindi ito dapat kainin. ");
INSERT INTO tglulb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Anumang gumagapang gamit ang kanilang tiyan at anumang lumalakad gamit ang kanilang apat na paa o anumang may maraming paa—ang lahat ng mga hayop na gumagapang sa lupa, hindi ninyo dapat kainin ang mga ito, dahil sila ay kinasusuklaman. ");
INSERT INTO tglulb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Hindi ninyo dapat gawing marumi ang inyong sarili sa anumang nabubuhay na mga nilalang na gumapang; hindi ninyo dapat gawing marumi ang inyong sarili dahil sa kanila, na dapat kayong gawing marumi sa pamamagitan nila. ");
INSERT INTO tglulb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Dahil ako si Yahweh na inyong Diyos. Samakatuwid ialay ang inyong sarili sa akin at magpakabanal dahil ako ay banal. Hindi ninyo dapat dungisan ang inyong sarili sa anumang uri ng hayop na gumagalaw sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Dahil ako si Yahweh, na naglabas sa inyo mula sa lupain ng Ehipto, para maging inyong Diyos. Samakatuwid dapat kayong maging banal, dahil ako ay banal. ");
INSERT INTO tglulb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ito ang batas tungkol sa mga hayop, sa mga ibon, bawat nabubuhay na nilalang na gumagalaw sa mga tubig at ang bawat nilalang na mga gumagapang sa lupa, ");
INSERT INTO tglulb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","kung saan gagawa ng pagkakaiba sa pagitan ng marumi at ng malinis, at sa pagitan ng nabubuhay na mga bagay na maaaring kainin at ang nabubuhay na mga bagay na hindi maaaring kainin” ");
INSERT INTO tglulb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Sinabi ni Yahweh kay Moises, ");
INSERT INTO tglulb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Kausapin ang mga tao ng Israel, sabihin, 'kung nabuntis ang isang babae at nanganak ng isang batang lalaki, sa gayon siya ay magiging marumi sa loob ng pitong araw, halos katulad ng siya'y marumi noong mga araw ng kaniyang buwanang pagdurugo. ");
INSERT INTO tglulb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sa ikawalong araw dapat tuliin ang laman na natatakpan ng balat ng isang sanggol na lalaki. ");
INSERT INTO tglulb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Pagkatapos magpapatuloy ang paglilinis ng ina mula sa kaniyang pagdurugo sa loob ng tatlumput-tatlong araw. Dapat hindi siya hahawak ng anumang banal na bagay o pupunta sa loob ng tabernakulo habang hindi tapos ang mga araw ng kaniyang paglilinis. ");
INSERT INTO tglulb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ngunit kung manganganak siya ng isang sanggol na babae, sa gayon magiging marumi siya sa loob ng dalawang linggo, gaya nang siya ay nasa panahon ng kaniyang pagdurugo. Pagkatapos magpapatuloy ang paglilinis ng ina sa loob ng animnaput-anim na araw. ");
INSERT INTO tglulb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Kapag natapos ang mga araw ng kanyang paglilinis, para sa isang anak na lalaki o isang anak na babae, dapat siyang magdala ng isang taong gulang na tupa bilang isang handog na susunugin at isang batang batu-bato o kalapati bilang isang handog para sa kasalanan, sa pasukan ng tolda ng pagtitipon, para sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Pagkatapos ay ihahandog niya ito sa harapan ni Yahweh at gagawa ng pambayad ng kasalanan para sa kaniya at malilinis siya mula sa kaniyang pagdurugo. Ito ay ang batas tungkol sa isang babae na magsisilang sinuman sa dalawa isang lalaki o isang batang babae. ");
INSERT INTO tglulb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kung siya ay walang kakayahang bumili ng isang tupa, kung gayon dapat siyang kumuha ng dalawang kalapati o dalawang batang batu-bato, isa bilang isang handog na susunugin at ang iba bilang isang handog para sa kasalanan, at ang pari gagawa ng pambayad ng kasalanan para sa kaniya; pagkatapos magiging malinis siya.'” ");
INSERT INTO tglulb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Nakipag-usap si Yahweh kay Moises at kay Aaron, na nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Kung sinuman ang may pamamaga o galis o maputing batik sa balat ng kanyang katawan, at naging nakakahawa at may isang sakit sa balat ang kanyang katawan, sa ganun kailangan siyang dalhin kay Aaron ang punong pari, o sa isa sa kaniyang mga anak na lalaking mga pari. ");
INSERT INTO tglulb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Pagkatapos ay susuriin ng pari ang sakit sa balat ng kanyang katawan. Kung ang buhok sa bahaging may sakit ay naging puti, at kung ang sakit ay makikitang malalim kaysa balat lang, sa ganun iyon ay isang nakakahawang sakit. Pagkatapos siyang suriin ng pari, kailangan niyang ipahayag na siya ay marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kung ang maliwanag na batik sa kanyang balat ay puti, at ang itsura nito ay hindi mas malalim kaysa balat, at kung ang buhok sa bahaging may sakit ay hindi maging puti, kung gayon kailangang ilayo ng pari ang may sakit sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sa ikapitong araw, kailangan siyang suriin ng pari upang makita kung sa palagay niya ay hindi malala ang sakit, at kung ito ay hindi kumalat sa balat. Kapag wala siya nito, kung gayon kailangan siyang ilayo ng pari ng karagdagang pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Susuriin ulit siya ng pari sa ikapitong araw upang makita kung ang karamdaman ay mas bumuti at hindi kumalat ng mas malawak sa balat. Kapag wala siya nito, kung gayon sasabihin ng pari na siya ay malinis. Ito ay isang pantal. Kailangan niyang labhan ang kanyang mga damit, at pagkatapos siya ay malinis na. ");
INSERT INTO tglulb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pero kung ang pantal ay kumalat sa balat pagkatapos niyang ipakita ang kanyang sarili sa pari para sa kanyang paglilinis, kailangan niya muling ipakita ang kanyang sarili sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Susuriin siya ng pari para makita kung ang pantal ay kumalat ng mas malawak sa balat. Kung kumalat ito, kung gayon ay dapat siyang ipahayag ng pari na marumi. Ito ay isang nakakahawang sakit. ");
INSERT INTO tglulb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Kapag ang nakakahawang sakit sa balat ay nasa sinuman, kung gayon ay kailangan siyang dalhin sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Susuriin siya ng pari upang makita kung may puting pamamaga sa balat, kung ang buhok ay naging puti, o kung may hilaw na laman sa pamamaga. ");
INSERT INTO tglulb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Kung naroon iyon, sa gayon ito ay isang malubhang sakit sa balat, at dapat ipahayag ng pari na siya ay marumi. Hindi na siya ihihiwalay, dahil siya ay marumi na. ");
INSERT INTO tglulb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kung ang sakit ay malawak na ang pagkalat sa balat at natatakpan na ang buong balat ng taong may sakit mula sa kanyang ulo hanggang sa kanyang paa, hangga't nakikita iyon ng pari, ");
INSERT INTO tglulb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kung gayon kailangang suriin siya ng pari upang makita kung ang sakit ay bumalot sa buo niyang katawan. Kapag mayroon nito, kung gayon ay dapat ipahayag ng pari na ang taong may sakit ay malinis. Kung lahat ng ito ay naging puti, kung gayon ay malinis siya. ");
INSERT INTO tglulb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ngunit kung hilaw na laman ang makita sa kanya, siya ay magiging marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Dapat tingnan ng pari ang hilaw na laman at ipahayag siyang marumi dahil ang hilaw na laman ay marumi. Iyon ay isang nakakahawang sakit. ");
INSERT INTO tglulb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ngunit kung ang hilaw na laman ay maging puti muli, kung gayon ay dapat pumunta ang tao sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Susuriin siya ng pari para makita kung ang laman ay naging puti. Kung nagkagayon ipapahayag ng pari na ang taong iyon ay malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kung ang tao ay may pigsa sa balat at gumaling ito, ");
INSERT INTO tglulb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","at sa bahagi ng pigsa ay mayroong puting pamamaga o isang malinaw na batik, namumulang-puti, kung gayon ay kailangan itong ipakita sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Susuriin ito ng pari upang makita kung ito ay mas malalim sa balat, at kung ang buhok doon ay naging puti. Kung gayon, dapat ipahayag ng pari na siya ay marumi. Ito ay isang nakakahawang sakit, kapag ito ay namuo sa bahagi kung nasaan ang pigsa. ");
INSERT INTO tglulb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ngunit kung sinuri ng pari ito at makita na walang puting buhok dito, at iyon ay wala sa ilalim ng balat kundi kumupas na, sa ganun kailangang ihiwalay siya ng pari sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kapag kumalat iyon sa balat, kung gayon ay dapat siyang ipahayag ng pari na marumi. Ito ay isang nakakahawang sakit. ");
INSERT INTO tglulb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ngunit kapag nanatili ang malinaw na batik sa bahagi nito at hindi kumalat, kung gayon ito ay peklat ng pigsa, at dapat siyang ipahayag ng pari na malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Kapag ang balat ay may paso at ang hilaw na laman ng paso ay maging isang namumulang-puti o puting batik, ");
INSERT INTO tglulb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kung ganun susuriin ito ng pari para makita kung ang buhok sa batik na iyon ay naging puti, at kung ito ay nagpapakitang mas malalim kaysa sa balat. Kapag mayroon nito, sa ganun iyon ay nakakahawang sakit. Kumalat na ito palabas sa paso, at dapat ipahayag siya ng pari na marumi. Ito ay isang nakakahawang sakit. ");
INSERT INTO tglulb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ngunit kung susuriin iyon ng pari at makitang walang puting buhok sa batik, at iyon ay wala sa ilalim ng balat ngunit kumupas, kung gayon ay dapat siyang ihiwalay ng pari sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pagkatapos ay dapat siyang suriin ng pari sa ikapitong araw. Kung iyon ay kumalat ng malawak sa balat, kung gayon ay dapat ipahayag ng pari na siya na siya ay marumi. Ito ay isang nakakahawang sakit. ");
INSERT INTO tglulb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kung ang batik ay manatili sa bahaging iyon at hindi kumalat sa balat ngunit kumupas, kung gayon ito ay isang pamamaga mula sa paso, at dapat siyang ipahayag ng pari na malinis, dahil hindi ito mas higit sa peklat ng paso. ");
INSERT INTO tglulb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Kung ang isang lalaki o babae ay may nakakahawang sakit sa ulo o baba, ");
INSERT INTO tglulb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kung gayon kailangang suriin ng pari ang tao para sa isang nakakahawang sakit upang makita kung ito ay nagmimistulang mas malalim kaysa balat, at kung mayroong dilaw, manipis na buhok dito. Kung mayroon, kung gayon kailangan siyang ipahayag ng pari na marumi. Ito ay isang pangangati, isang nakakahawang sakit sa ulo o sa baba. ");
INSERT INTO tglulb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kung ang pari ay susuriin ang pangangating sakit at makitang wala ito sa ilalim ng balat, at kung walang itim na buhok doon, kung gayon ang pari ay ihihiwalay ang taong may pangangating sakit sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Susuriin ng pari ang sakit sa ikapitong araw upang makita kung kumalat ito. Kung walang dilaw na buhok, at kung ang sakit ay lumilitaw na hanggang balat lang ang lalim, ");
INSERT INTO tglulb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","kung gayon kailangan siyang ahitan, ngunit ang may sakit na bahagi ay hindi dapat ahitan, at kailangang ihiwalay ng pari ang tao na may pangangating sakit sa loob ng karagdagang pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Susuriin ng pari ang sakit sa ikapitong araw para makita kung ito ay huminto na sa pagkalat sa balat. Kung ito ay lumilitaw na hindi mas malalim kaysa balat, kung gayonn kailangan siyang ipahayag ng pari na malinis. Kailangang labhan ng tao ang kanyang mga damit, at sa gayon siya ay magiging malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ngunit kung ang pangangating sakit ay kumalat ng malawak sa balat pagkatapos na ang pari ay sabihin na siya ay malinis, ");
INSERT INTO tglulb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kung ganun kailangan siyang suriin ulit ng pari. Kung ang sakit ay kumalat sa balat, ang pari ay hindi na kailangang humanap ng dilaw na buhok. Ang tao ay marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ngunit kung sa tingin ng pari ang pangangating sakit ay huminto sa pagkalat at maitim na buhok ay tumubo sa bahagi, kung gayon ang sakit ay gumaling. Siya ay malinis, at kailangan siyang ipahayag ng pari na malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Kung isang lalaki o isang babae ay mayroong puting mga batik sa balat, ");
INSERT INTO tglulb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kung gayon ay dapat suriin ng pari ang tao para makita kung ang mga batik ay kulay abo, na kung saan isa lamang itong pantal na kumalat mula sa balat. Siya ay malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Kung ang buhok ng isang lalaki ay nalagas mula sa kanyang ulo, siya ay kalbo, ngunit siya ay malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","At kung ang kanyang buhok ay nalagas mula sa harapang bahagi ng kanyang ulo, at kung ang kanyang noo ay kalbo, siya ay malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ngunit kung mayroon isang namumulang-puting sugat sa kanyang kalbong ulo o noo, ito ay isang nakakahawang sakit na lumitaw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kung gayon ay dapat siyang suriin ng pari para makita kung ang pamamaga ng maysakit na bahagi sa kanyang kalbong ulo o noo ay namumulang-puti, kagaya ng itsura ng isang nakakahawang sakit sa balat. ");
INSERT INTO tglulb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Kapag mayroon nito, kung gayon ay mayroon siyang nakakahawang sakit at siya ay marumi. Dapat siguraduhin ng pari na ipahayag na marumi siya dahil sa kanyang sakit sa kanyang ulo. ");
INSERT INTO tglulb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ang tao na mayroong nakakahawang sakit ay kailangang magsuot ng mga punit na damit, ang kanyang buhok ay kailangang nakalugay, at dapat niyang takpan ang kanyang mukha hanggang sa kanyang ilong at sumigaw, 'Marumi, marumi.' ");
INSERT INTO tglulb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Sa lahat ng araw na siya ay mayroong nakakahawang sakit siya ay magiging marumi. Dahil siya ay marumi na may isang sakit na maaaring makahawa, siya ay dapat mamuhay ng mag-isa. Dapat siyang mamuhay sa labas ng kampo. ");
INSERT INTO tglulb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ang isang kasuotang narumihan ng amag, maging ito ay lana o linong kasuotan, ");
INSERT INTO tglulb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","o anumang bagay na lana o sinulsing mula sa lana o lino, o balat o alinmang bagay na gawa sa balat— ");
INSERT INTO tglulb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","kung may isang maberde o namumulang dumi sa kasuotan, ang balat, ang hinabi o sinulsing bagay, o anumang bagay na gawa sa balat, kung ganun ito ay isang amag na kumalat; dapat itong ipakita sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Dapat suriin ng pari ang bagay para sa amag; dapat niyang ihiwalay ang anuman na mayroong amag sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Dapat niya muling suriin ang amag sa ikapitong araw. Kapag ito ay kumalat sa kasuotan o anumang hinabi o sinulsing gawa sa lana o linong bagay, o balat o alinmang bagay na kung saan balat ang ginagamit, kung gayon ito ay mapanganib na amag, at ang bagay ay marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Dapat niyang sunugin ang kasuotan, o anumang bagay na hinabi o sinulsi mula sa lana o linong bagay, o balat o alinmang bagay na gawa sa balat, anuman na kung saan ang mapanganib na amag ay makita, dahil ito ay magdadala ng sakit. Ang bagay ay dapat lubusang sunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Kung sinuri ng pari ang bagay at makita na ang amag ay hindi kumalat sa kasuotan o bagay na hinabi o sinulsi mula sa lana o lino, o balat na mga bagay, ");
INSERT INTO tglulb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","kung gayon iuutos niya sa kanila na labahan ang bagay kung saan nakita ang amag, at dapat niya itong ihiwalay sa loob ng karagdagang pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Pagkatapos ay susuriin ng pari ang bagay na inamag pagkatapos itong malabhan. Kung ang amag ay hindi nagbago ng kulay, kahit na hindi ito kumalat, ito ay marumi. Dapat mong sunugin ang bagay, maging saan ito nahawaan ng amag. ");
INSERT INTO tglulb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Kung sinuri ng pari ang bagay, at kung ang amag ay kumupas pagkatapos itong malabhan, kung gayon dapat niyang punitin ang nahawahang bahagi mula sa kasuotan o mula sa balat, o mula sa hinabi o sinulsing bagay. ");
INSERT INTO tglulb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kapag ang amag ay makita parin sa kasuotan, sa hinabi man o sa sinulsing bagay, o sa kahit anong bagay na balat, kumakalat ito. Dapat mong sunugin ang anumang bagay na mayroong amag. ");
INSERT INTO tglulb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ang kasuotan o anumang bagay na hinabi o sinulsing mula sa lana o linong bagay, o balat o anumang bagay na gawa sa balat—kung lalabhan mo ang bagay at ang amag ay mawala, kung gayon ang bagay ay kailangang malabhan sa ikalawang pagkakataon, at ito ay magiging malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ito ang batas tungkol sa amag sa isang kasuotan ng lana o lino, o anumang hinabi o sinulsing mula sa lana o linong bagay, o balat o anumang gawa sa balat, para maaari ninyong ipahayag na ito ay malinis o marumi.” ");
INSERT INTO tglulb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Nakipag-usap si Yahweh kay Moises, nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ito ang magiging batas para sa may sakit na tao sa araw ng kanyang paglilinis. Dapat siyang dalhin sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Lalabas ang pari sa kampo para suriin ang isang tao para makita kung ang nakakahawang sakit sa balat ay gumaling. ");
INSERT INTO tglulb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Pagkatapos ay iuutos ng pari sa taong lilinisin na dapat kumuha ng dalawang buhay na ibon, kahoy na cedar, matingkad na pulang sinulid, at isopo. ");
INSERT INTO tglulb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Uutusan siya ng pari na patayin ang isa sa mga ibon sa ibabaw ng tubig-tabang na nasa isang palayok. ");
INSERT INTO tglulb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Pagkatapos ay kukunin ng pari ang buhay na ibon at ang kahoy na cedar, at ang matingkad na pulang sinulid at ang isopo, at kanyang isasawsaw ang lahat ng mga bagay na ito, kasama ang buhay na ibon, sa dugo ng ibon na pinatay sa ibabaw ng tubig-tabang. ");
INSERT INTO tglulb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Pagkatapos ay iwiwisik ng pari ang tubig na ito nang pitong beses sa taong lilinisin mula sa sakit, at pagkatapos ay ihahayag ng pari na siya ay maging malinis. Pagkatapos ay pakakawalan ng pari ang buhay na ibon sa mga lantad na kabukiran. ");
INSERT INTO tglulb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ang taong nilinis ay lalabhan ang kanyang mga damit, aahitin lahat ng kanyang buhok, at paliliguan ang kanyang sarili sa tubig, at pagkatapos siya ay magiging malinis. Pagkatapos ay kailangan niyang pumasaok sa loob ng kampo, pero siya ay titira sa labas ng kanyang tolda sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sa ikapitong araw kailangan niya ring ahitin ang kanyang balbas at mga kilay. Kailangan niyang ahitan ang lahat ng kanyang buhok, at kailangan niyang labhan ang kanyang mga damit at paliguan ang kanyang sarili sa tubig; sa gayon magiging malinis siya. ");
INSERT INTO tglulb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sa ikawalong araw dapat siyang kumuha ng dalawang lalaking tupa na walang kapintasan, isang babaeng tupa na isang taon na walang kapintasan at tatlong ikasampung bahagi ng isang epa ng pinong harina na hinaluan ng langis bilang isang handog na pagkaing butil, at isang sisidlan na may langis. ");
INSERT INTO tglulb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ang pari na naglinis sa kanya ay patatayuin ang taong lilinisin, kasama ng mga bagay na iyon, sa harap ni Yahweh sa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kukunin ng pari ang isa sa mga lalaking tupa at iaalay ito bilang isang paghahandog sa pagkakasala, kasama ang lalagyan na may langis; itataas niya ang mga ito bilang isang handog sa harap ni Yahweh at iaalay ang mga ito sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Dapat niyang patayin ang lalaking tupa sa lugar na kung saan nila pinatay ang handog para sa kasalanan at ang mga handog na susunugin, sa lugar ng tabernakulo, sapagkat ang handog para sa kasalanan ay pag-aari ng pari, pati na ang handog para sa kasalanan, dahil ito ay pinakabanal. ");
INSERT INTO tglulb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kukuha ang pari ng kaunting dugo sa alay ng pagkakasala at ilalagay ito sa dulo ng kanang tainga ng taong lilinisin, sa hinlalaki ng kanyang kanang kamay, at sa malaking daliri ng kanyang kanang paa. ");
INSERT INTO tglulb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Pagkatapos ay kukuha ang pari ng langis mula sa sisidlan na may langis at ibubuhos ito sa palad ng kanyang kaliwang kamay, ");
INSERT INTO tglulb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","at isasawsaw ang kanyang kanang daliri sa langis na nasa kanyang kaliwang kamay, at iwiwisik ang kaunting langis gamit ang kanyang daliri ng pitong ulit sa harap ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ilalagay ng pari ang natitirang mga langis sa kanyang kamay sa dulo ng kanang tainga ng taong lilinisin, sa hinlalaki ng kanyang kanang kamay, at sa malaking daliri ng kanyang kanang paa. Kailangan niyang ilagay ang langis na ito sa ibabaw ng dugo na mula sa handog na pambayad ng kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","At sa natitirang langis na nasa kamay ng pari, ilalagay niya ito sa ulo ng tao na lilinisin, at gagawa ang pari ng pambayad kasalanan sa kanya sa harap ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Pagkatapos ihahandog ng pari ang handog para sa kasalanan at gagawa ng pambayad kasalanan para sa kanya na lilinisin dahil sa kanyang karumihan, at pagkatapos papatayin niya ang handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Pagkatapos ihahandog ng pari ang handog na susunugin at ang handog na pagkaing butil sa altar. Gagawa ang pari ng pambayad kasalanan para sa tao, at pagkatapos magiging malinis siya. ");
INSERT INTO tglulb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Gayunman, kung ang tao ay mahirap at walang kakayahang makakuha ng mga alay na ito, maaari siyang kumuha ng isang lalaking tupa bilang isang alay sa pagkakasala para itataas at iaalay kay Yahweh upang gawing kabayaran sa kanyang sarili, at isang ikasampung bahagi ng isang epa ng pinong harina na hinaluan ng langis bilang isang handog na pagkaing butil, at isang sisidlan na may langis, ");
INSERT INTO tglulb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","kasama ng dalawang kalapati, at dalawang mga batang kalapati, na kaya niyang kunin; ang isang ibon ay maging isang handog para sa kasalanan at ang isa ay isang handog ng susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Sa ikawalong araw kailangan niyang dalhin ang mga ito para sa kanyang paglilinis sa pari, sa pasukan ng tolda ng pagpupulong, sa harap ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Pagkatapos kukunin ng pari ang tupa para sa pag-aalay ng pagkakasala at sisidlan na may langis, at itataas niya ang mga ito bilang isang handog kay Yahweh at iaalay ang mga ito sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Papatayin niya ang tupa para sa handog na pambayad ng kasalanan, at kukuha siya ng kaunting dugo sa pag-aalay ng pagkakasala at ilalagay ito sa dulo ng kanang tainga ng isang lilinisin, sa hinlalaki ng kanyang kanang kamay, at sa malaking daliri ng kanyang kanang paa. ");
INSERT INTO tglulb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Pagkatapos magbubuhos ang pari ng kaunting langis sa palad ng kanyang kaliwang kamay, ");
INSERT INTO tglulb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","at kanyang iwiwisik gamit ang kanyang kanang kamay ang kaunting langis na nasa kanyang kaliwang kamay ng pitong beses sa harap ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Pagkatapos maglalagay ang pari ng kaunting langis na nasa kanyang kamay doon sa dulo ng tainga ng isang lilinisin, sa hinlalaki ng kanyang kanang kamay, at sa malaking daliri ng kanyang kanang paa, parehong mga lugar kung saan niya inilagay ang dugo ng alay ng pagkakasala. ");
INSERT INTO tglulb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ilalagay niya ang natitirang langis na nasa kanyang kamay sa ulo ng taong lilinisin, para gumawa ng pambayad kasalanan para sa kanya sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Dapat niyang ihandog ang isa sa mga kalapati o mga batu-bato, na nakayang kunin ng tao— ");
INSERT INTO tglulb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","isa bilang isang handog para sa kasalanan at ang isa ay bilang isang handog na pambayad ng kasalanan, kasama ng handog na pagkaing butil. Pagkatapos gagawa ng pambayad kasalanan ang pari para sa isang lilinisin sa harap ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ito ang batas para sa isang tao na kung saan ay mayroong nakakahawang sakit sa balat, siyang hindi makayanan ang mga pamantayan sa paghahandog para sa kanyang paglilinis.” ");
INSERT INTO tglulb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Nakipag-usap si Yahweh kay Moises at kay Aaron, nagsasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Nang nagpunta kayo sa lupain ng Canaan kung saan ibinigay ko sa inyo bilang isang pag-aari, at kung maglalagay ako ng amag na kakalat sa isang bahay sa lupain ng inyong pag-aari, ");
INSERT INTO tglulb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","sa gayon ang nagmamay-ari ng bahay ay kailangang pumunta at sabihin sa pari. Dapat niyang sabihin, 'Tila mayroon isang bagay na katulad ng amag sa aking bahay.' ");
INSERT INTO tglulb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Sa gayon ay iuutos ng pari na lisanin nila ang bahay bago siya pumasok upang makita ang katunayan ng amag, upang walang anumang bagay sa bahay ang magiging marumi. Pagkatapos kailangan pumasok ng pari upang makita ang bahay. ");
INSERT INTO tglulb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Kailangan niyang suriin ang amag upang makita kung ito ay nasa mga pader ng bahay, at upang makita kung ito ay lumalabas na maberde o mamula-mula sa mga lubak sa mga ibabaw ng pader. ");
INSERT INTO tglulb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Kung ang bahay ay mayroong amag, lalabas ng bahay ang pari at sasarhan ang pinto ng bahay sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Pagkatapos babalik uli ang pari sa ikapitong araw at susuriin ito para makita kung kumalat ang amag sa mga dingding ng bahay. ");
INSERT INTO tglulb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Kung mayroon ito, iuutos ng pari na tatanggalin nila ang mga bato na kung saan nakita ang amag at itapon ang mga ito sa isang maruming lugar sa labas ng lungsod. ");
INSERT INTO tglulb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Iuutos niya na dapat kukuskusin lahat ng mga dingding na nasa loob ng bahay, at kailangan nilang kunin ang nahawaang gamit na kinuskos palabas ng lungsod at itambak ito sa maruming lugar. ");
INSERT INTO tglulb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Kailangan nilang kunin ang ibang mga bato at ilagay ang mga ito sa lugar ng mga bato na tinanggal, at dapat silang gumamit ng bagong luad upang tapalan ang bahay. ");
INSERT INTO tglulb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Kung bumalik ulit ang amag at kumalat sa bahay na kung saan tinanggal ang mga bato at kinuskos ang mga dingding at pagkatapos muling tinapalan, ");
INSERT INTO tglulb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kung gayon ang pari ay kailangan pumasok at suriin ang bahay upang makita kung ang amag ay kumalat sa bahay. Kung mayroon ito, kung gayon ito ay mapaminsalang amag, at ang bahay ay marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Dapat gibain ang bahay. Ang mga bato, troso, at lahat ng mga panapal ng bahay ay kailangan dalhin palabas ng lungsod papunta sa maruming lugar. ");
INSERT INTO tglulb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Bilang karagdagan, sinumang pupunta sa bahay sa panahong sinarhan ito ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Sinuman ang matutulog sa bahay ay kailangan niyang labhan ang kanyang mga damit, ang sinuman ang kumain sa bahay ay kailangan niyang labhan ang kanyang mga damit. ");
INSERT INTO tglulb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Kung papasok ang pari sa bahay upang suriin ito para makita kung ang amag ay kumalat sa bahay matapos tapalan ang bahay, pagkatapos, kung ang amag ay nawala, ihahayag niya na ang bahay ay malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Pagkatapos ang pari ay dapat kumuha ng dalawang ibon upang linisan ang bahay, at kahoy na cedar, at matingkad na pulang sinulid, at isopo. ");
INSERT INTO tglulb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Papatayin niya ang isa sa mga ibon sa ibabaw ng tubig-tabang sa isang palayok. ");
INSERT INTO tglulb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Kukunin niya ang kahoy na cedar, ang hisopo, ang matingkad na pulang sinulid, at ang buhay na ibon, at isasawsaw ang mga ito sa dugo ng pinatay na ibon, patungo sa tubig-tabang, at wiwisikan ang bahay ng pitong beses. ");
INSERT INTO tglulb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Lilinisin niya ang bahay sa pamamagitan ng dugo ng ibon at ng tubig-tabang, kasama ng buhay na ibon, kahoy na cedar, ang isopo, at ang matingkad na pulang sinulid. ");
INSERT INTO tglulb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Pero hahayaan niya ang buhay na ibon na lumabas ng lungsod papunta sa mga lantad na bukirin. Sa ganitong paraan kailangan niyang gumawa ng pambayad kasalanan para sa bahay, at ito ay magiging malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ito ang batas sa lahat ng uri ng nakakahawang sakit sa balat at mga bagay na nagdudulot ng ganoong sakit, at para sa isang pangangati, ");
INSERT INTO tglulb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","at para sa amag sa damit at sa loob ng isang bahay, ");
INSERT INTO tglulb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","para sa pamamaga, para sa isang pantal, at para sa isang makintab na batik, ");
INSERT INTO tglulb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","upang malaman kapag alin man sa mga ito ay marumi o kapag ito ay malinis. Ito ang batas para sa mga nakakahawang sakit sa balat at amag.” ");
INSERT INTO tglulb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Kinausap ni Yahweh sina Moises at Aaron, sinabing, ");
INSERT INTO tglulb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Kausapin ang mga mamamayan ng Israel, at sabihin sa kanila, 'Kapag sinumang lalaki na nagkaroon ng isang likidong may impeksyon na lumabas sa kaniyang katawan, siya ay nagiging marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ang kaniyang karumihan ay dahil sa likidong mayroong impeksyon na ito. Kahit ang kaniyang katawan ay dinadaluyan ng likido, o tumigil na, ito ay marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Bawat higaan na kaniyang hinigaan ay magiging marumi, at lahat ng bagay na kaniyang inupuan ay magiging marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Sinuman ang humawak sa kaniyang higaan ay dapat niyang labhan ang kaniyang mga damit at paliguan ang kaniyang sarili ng tubig, at maging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Sinuman ang umupo sa anumang bagay na inuupuan ng lalaking dinadaluyan ng likidong mayroong impeksyon, dapat labhan ng taong iyon ang kaniyang mga damit at paliguan ang kaniyang sarili ng tubig, at siya ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","At sinumang humawak sa katawan ng isang may tumutulong likidong may impeksyon ay dapat niyang labhan ang kaniyang mga damit at paliguan ang kaniyang sarili ng tubig, at maging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Kapag ang taong mayroong tumutulong likido ay dumura sa sinumang malinis, kung gayon dapat labhan ng taong iyon ang kaniyang mga damit at paliguan ang kaniyang sarili ng tubig, at siya ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Alinmang upuan sa likod ng kabayo na sinakyan ng mayroong isang daloy ay magiging marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ang sinumang humawak sa anumang bagay na napasailalim ng taong iyon ay magiging marumi hanggang gabi, at sinumang magdala ng mga bagay na iyon ay dapat niyang labhan ang kaniyang mga damit at paliguan ang kaniyang sarili ng tubig; siya ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ang sinuman na nagkaroon ng ganoong tulo ay humawak na hindi muna niya hinugasan ang kaniyang mga kamay ng tubig, dapat labahan ng taong hinawakan ang kaniyang mga damit at paliguan ang kaniyang sarili ng tubig at siya ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Anumang palayok na luad na hinawakan ng may tulo na likido ay dapat basagin, at dapat hugasan ng tubig ang bawat sisidlang kahoy. ");
INSERT INTO tglulb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Kapag siya na nagkatulo ay nilinis na mula sa kaniyang tulo, kung gayon ay dapat siyang bumilang ng pitong araw para sa kaniyang paglilinis; pagkatapos dapat niyang labhan ang kaniyang mga damit at paliguan ang kaniyang sarili ng umaagos na tubig. Pagkatapos siya ay magiging malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Sa ikawalong araw dapat siyang kumuha ng dalawang kalapati o dalawang batu-batoi at dapat siyang pumunta kay Yahweh sa pasukan ng tolda ng pagpupulong; doon ay dapat niyang ibigay ang mga ibon sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Dapat ihandog ng pari ang mga ito, ang isa bilang handog para sa kasalanan at ang isa bilang handog na susunugin, at ang pari ang dapat gumawa ng pambayad ng kasalanan sa harap ni Yahweh para sa kanyang tulo. ");
INSERT INTO tglulb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Kung ang similya ng sinumang lalaki ay kusang lumabas mula sa kaniya, sa gayon ay dapat niyang paliguan ang kaniyang buong katawan sa tubig; siya ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Dapat malabhan ng tubig ang bawat kasuotan o balat ng hayop na nagkaroon ng similya; ito ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","At kapag ang isang babae at isang lalaki ay nagsiping at nagkaroon ng paglilipat ng similya sa babae, dapat paliguan nila pareho ang kanilang mga sarili ng tubig; sila ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Kapag dinudugo ang isang babae, magpapatuloy ang kaniyang karumihan ng pitong araw, at sinumang gumalaw sa kaniya ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Bawat bagay na kaniyang hinigaan sa loob ng kaniyang kabuwanang dalaw ay magiging marumi; lahat ng bagay na kaniyang inupuan ay magiging marumi din. ");
INSERT INTO tglulb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Sinumang humawak ng kaniyang higaan ay dapat labhan ang kaniyang mga damit at paliguan ang kaniyang sarili sa tubig; magiging marumi hanggang gabi ang taong iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Sinumang makahawak sa anumang bagay na kanyang inupuan ay dapat niyang labhan ang kaniyang mga damit at paliguan ang kaniyang sarili ng tubig; ang taong iyon ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kahit ito ay sa higaan o sa alinmang bagay na kaniyang inupuan, kung hawakan niya ito, ang taong iyon ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kung sinumang lalaki ang sumiping sa kanya, at kung ang kaniyang maruming daloy ay mapasayad sa kaniya, magiging marumi siya ng pitong araw. Bawat higaan na kaniyang hinigaan ay magiging marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Kung ang isang babae ay nagkaroon ng pagdurugo ng maraming araw na hindi sa panahon ng kaniyang kabuwanang dalaw, o kapag siya ay mayroong siyang pagdurugo na lagpas pa sa kaniyang kabuwanang dalaw, sa panahon ng mga araw ng pag-agos ng kaniyang karumihan, siya ay parang nasa panahon ng kaniyang kabuwanang dalaw. Siya ay marumi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ang bawat higaan na kaniyang hinigaan sa panahon ng kaniyang pagdurugo ay magiging kagaya ng higaan na kaniyang hinigaan sa panahon ng kaniyang kabuwanang dalaw para sa kaniya, at bawat bagay na kaniyang inupuan ay magiging marumi, tulad ng karumihan ng kaniyang kabuwanang dalaw. ");
INSERT INTO tglulb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","At sinumang gumalaw ng alinmang mga bagay na iyon ay magiging marumi; dapat niyang labhan ang kaniyang mga damit at paliguan ang kaniyang sarili ng tubig, at siya ay magiging marumi hanggang gabi. ");
INSERT INTO tglulb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Pero kung siya ay nalinisan mula sa kaniyang pagdurugo, kung gayon siya ay magbilang ng pitong araw at pagkatapos nito siya ay magiging malinis. ");
INSERT INTO tglulb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Sa ikawalong araw ay kukuha siya ng dalawang kalapati o dalawang batu-bato at dadalhin ang mga ito sa pari sa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Iaalay ng pari ang isang ibon bilang handog para sa kasalanan at ang isa bilang handog na susunugin, at siya ay gagawa ng pambayad para sa kanyang kasalanan sa harap ni Yahweh para sa maruming pag-agos ng dugo. ");
INSERT INTO tglulb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ganito dapat kung paano ninyo ihiwalay ang mga taong Israelita mula sa kanilang karumihan, nang sa gayon ay hindi sila mamatay sanhi ng kanilang karumihan, sa pamamagitan ng pagdungis ng aking tabernakulo, kung saan ako nanirahan sa piling nila. ");
INSERT INTO tglulb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ito ang mga alituntunin para sa sinumang mayroong tulo ng likido, para sa sinumang lalaki na nilalabasan ng kanyang similya at nagdulot sa kanyang maging marumi, ");
INSERT INTO tglulb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","para sa sinumang babaeng mayroong kabuwanang dalaw, para sa sinumang nilalabasan ng likido, kahit pa lalaki o babae, at para sa sinumang lalaki na sumiping sa maruming babae.'” ");
INSERT INTO tglulb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Nakipagusap si Yahweh kay Moises—pagkatapos ito ng kamatayan ng dalawang anak na lalaki ni Aaron, kung saan lumapit sila kay Yahweh at namatay. ");
INSERT INTO tglulb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Sinabi ni Yahweh kay Moises, “Kausapin mo si Aaron na iyong kapatid at sabihin na huwag siyang pumunta kahit anong oras patungo sa loob ng pinakabanal na lugar sa loob ng kurtina, sa harapan ng takip na luklukan ng awa na nasa kaban. Kapag ginawa niya, mamamatay siya, sapagkat magpapakita ako sa ulap sa ibabaw ng takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Kaya ganito dapat pumunta si Aaron sa loob ng pinakabanal na lugar. Dapat siyang pumasok na may isang batang toro bilang isang handog para sa kasalanan at isang lalaking tupa bilang isang handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Dapat siyang magsuot ng banal na linong tunika, at dapat siyang magsuot ng linong mga damit pangloob sa kanyang sarili, at dapat siyang magsuot ng linong sintas sa baywang at linong turbante. Ito ay mga banal na damit. Dapat niyang paliguan ang kanyang katawan sa tubig at damitan ang kanyang sarili ng mga damit na ito. ");
INSERT INTO tglulb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Dapat siyang kumuha mula sa kapulungan ng mga tao ng Israel ng dalawang lalaking kambing bilang isang handog para sa kasalanan at isang lalaking tupa bilang isang handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Sa gayon ay dapat ipakita ni Aaron ang toro bilang handog para sa kasalanan, kung saan maging para sa kanya, sa pambayad ng kasalanan para sa kanya at sa kaniyang pamilya. ");
INSERT INTO tglulb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Pagkatapos ay dapat niyang kunin ang dalawang kambing at ilagay sila sa harapan ni Yahweh sa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Pagkatapos ay dapat magpalabunutan si Aaron para sa dalawang kambing, ang isang mabubunot para kay Yahweh, at ang ibang mabubunot ay para sa hantungan ng sisi. ");
INSERT INTO tglulb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Dapat iharap ni Aaron ang kambing kung saan nahulog ang palabunutan para kay Yahweh, at ihandog ang kambing bilang isang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Subalit ang kambing na kung saan tumapat ang palabunutan ay dapat dalhing buhay kay Yahweh, upang gawing pambayad sa kasalanan sa pamamagitan ng pagpapadala nito palayo bilang isang hantungan ng sisi patungong ilang. ");
INSERT INTO tglulb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Kung ganoon dapat iharap ni Aaron ang toro para sa handog para sa kasalanan, na kung alin ay magiging para sa kanyang sarili. Dapat siyang gumawa ng pambayad sa kasalanan para sa kanyang sarili at sa kanyang pamilya, kung gayon dapat niyang patayin ang toro bilang isang handog para sa kasalanan para sa kanyang sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Dapat kumuha si Aaron ng isang sensaryo na puno ng mga uling na may apoy mula sa altar sa harapan ni Yahweh, na puno ng giniling na pinong-pinong mabangong insenso ang mga kamay niya, at dadalhin ang mga bagay na ito sa loob ng kurtina. ");
INSERT INTO tglulb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Dapat niyang ilagay doon ang insenso sa ibabaw ng apoy sa harapan ni Yahweh upang maaaring tumakip ang ulap mula sa insenso sa luklukan ng awa sa ibabaw ng tipan ng mga batas. Dapat niya itong gawin upang hindi siya mamatay. ");
INSERT INTO tglulb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Pagkatapos dapat siyang kumuha ng konting dugo ng toro at iwisik ito gamit ang kanyang daliri sa harapan ng takip ng luklukan ng awa. Dapat niyang iwisik ang konting dugo gamit ang kanyang daliri ng pitong beses sa harapan ng takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Pagkatapos ay dapat niyang patayin ang kambing para sa handog para sa kasalanan na para sa mga tao at dalhin ang dugo nito sa loob ng kurtina. Doon dapat niyang gawin sa dugo katulad ng ginawa niya sa dugo ng toro: dapat niya itong iwisik sa takip ng luklukan ng awa at sa harapan ng takip ng luklukan ng awa. ");
INSERT INTO tglulb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Dapat gumawa siya ng pambayad kasalanan para sa banal na lugar dahil sa maruming mga gawain ng mga tao ng Israel, at dahil sa kanilang paghihimagsik at lahat ng kanilang mga kasalanan. Dapat din niyang gawin ito para sa tolda ng pagpupulong, kung saan namumuhay si Yahweh sa kanilang kalagitnaan, sa harap ng kanilang maruruming mga gawain. ");
INSERT INTO tglulb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Walang sinuman ang dapat nasa loob ng tolda ng pagpupulong kapag papasok si Aaron upang gumawa ng pambayad kasalanan sa pinakabanal na lugar, at hanggang sa lumabas siya at matapos ang paggawa ng pambayad kasalanan sa kaniyang sarili at sa kaniyang pamilya, at para sa lahat ng kapulungan ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Dapat siyang lumabas sa altar na nasa harapan ni Yahweh at gawin ang pambayad kasalanan para dito, at dapat siyang kumuha ng kaunting dugo ng toro at kaunting dugo ng kambing at ilagay ito sa mga sungay ng altar sa lahat ng palibot. ");
INSERT INTO tglulb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Dapat niyang wisikan ng kaunting dugo ang ibabaw nito gamit ang kanyang daliri ng pitong beses upang malinisan ito at maialay ito kay Yahweh, palayo mula sa maruming mga gawain ng mga tao ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Kapag natapos na niya ang pagbabayad kasalanan para sa pinakabanal na lugar, ang tolda ng pagpupulong, ang altar, dapat niyang ipakita ang buhay na kambing. ");
INSERT INTO tglulb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Kailangang ipatong ni Aaron ang kaniyang dalawang kamay sa ulo ng buhay na kambing at ipagtapat sa kaniya ang lahat ng kasamaan ng mga tao sa Israel, lahat ng kanilang paghihimagsik, at lahat ng kanilang mga kasalanan. Pagkatapos ay dapat niyang ilagay ang pagkakasalang iyon sa ulo ng kambing at ipadala ang kambing sa pangangalaga ng isang tao na handang akayin ang kambing sa ilang. ");
INSERT INTO tglulb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Dapat dalhing mag-isa ng kambing ang kasalanan ng mga tao patungo sa isang liblib na lugar. Doon sa ilang, dapat pakawalan ng tao ang kambing. ");
INSERT INTO tglulb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Pagkatapos ay dapat bumalik si Aaron sa tolda ng pagpupulong at hubarin ang linong mga damit na kanyang isinuot bago pumunta sa pinaka banal na lugar, at kailangan niyang iwanan ang mga damit na iyon doon. ");
INSERT INTO tglulb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Kailangan niyang paliguan ang kanyang katawan sa tubig sa isang banal na lugar, at magbihis ng kanyang pangkaraniwang kasuotan; pagkatapos ay kailangan niyang lumabas at ialay ang kanyang handog na susunugin at ang handog na susunugin para sa mga tao, at sa ganitong paraan ay makagawa ng pambayad kasalanan sa kanyang sarili at para sa mga tao. ");
INSERT INTO tglulb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Dapat niyang sunugin ang taba ng handog ng kasalanan sa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ang lalaking nagpalaya sa kambing na pakakawalan ay kailangang labhan ang kanyang mga damit at paliguan ang kanyang katawan sa tubig; pagkatapos niyon, maaari na siyang bumalik sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ang toro para sa handog sa kasalanan at ang kambing para sa handog ng kasalanan, na ang dugo nito ay dinala sa loob para gawing pambayad kasalanan sa banal na lugar, ay dapat dalhin sa labas ng kampo. Doon kailangan nilang sunugin ang kanilang mga balat, laman, at dumi nito. ");
INSERT INTO tglulb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Kailangang labhan ng taong nagsunog ng mga bahaging iyon ang kanyang mga damit at paliguan ang kanyang katawan sa tubig; pagkatapos niyon; maaari na siyang bumalik sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Palaging magiging isang tuntunin ito para sa inyo na sa ikapitong buwan, sa ikasampung araw ng buwan, dapat niyong magpakumbaba at walang gagawing trabaho, maski isang katutubo o isang dayuhan na namumuhay sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Dahil ang araw na ito ang pambayad kasalanan na gagawin para sa inyo, para kayo ay malinisan mula sa lahat ng inyong mga kasalanan nang sa gayon kayo ay maging malinis sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ito ay isang dakilang Araw ng Pamamahinga para sa inyo, at kailangan ninyong magpakumbaba sa inyong mga sarili at walang gagawing trabaho. Ito ay palaging magiging isang tuntunin sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ang punong pari, ang isang papahiran at itatalagang maging punong pari sa lugar ng kanyang ama, ay kailangang gawin ang pambayad kasalanan nito at isusuot ang linong mga damit, iyon ay, ang banal na mga damit. ");
INSERT INTO tglulb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Kailangan niyang gumawa ng pambayad kasalanan para sa pinaka banal na lugar; kailangan niyang gumawa ng pambayad kasalanan para sa tolda ng pagpupulong at para sa altar, at kailangan niyang gumawa ng pambayad kasalanan para sa mga pari at para sa lahat ng mga tao ng kapulungan. ");
INSERT INTO tglulb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ito ay palaging magiging isang tuntunin para sa inyo, para gawing pambayad kasalanan para sa mga tao ng Israel ng dahil sa lahat ng kanilang mga kasalanan, isang beses sa bawat taon.” At ginawa ito gaya ng utos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Kinausap ni Yahweh si Moises, sinabing, ");
INSERT INTO tglulb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Makipag usap kay Aaron at kanyang mga anak na lalaki, at sa lahat ng mamamayan ng Israel. Sabihin sa kanila kung ano ang inutos ni Yahweh: ");
INSERT INTO tglulb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","'Ang sinumang tao na mula sa Israel na pumatay ng isang lalaking baka, tupa, o kambing sa loob ng kampo, o sa labas ng kampo, upang ialay ito— ");
INSERT INTO tglulb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","kung hindi niya ito dadalhin sa pasukan ng tolda ng pagpupulong upang ihandog bilang isang alay para kay Yahweh sa harap ng kanyang tabernakulo, ang taong iyon ay nagkasala na sa pagdanak ng dugo. Pinadanak niya ang dugo, at dapat ng itiwalag ang taong iyon mula sa kanyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ang layunin ng kautusang ito ay upang dalhin ng mga mamamayan ng Israel ang kanilang mga alay para kay Yahweh sa pasukan ng tolda ng pagpupulong, upang ialay ng pari bilang handog ng pagtitipon-tipon para kay Yahweh, sa halip na mag handog ng mga alay sa isang lantad na bukid. ");
INSERT INTO tglulb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Isasaboy ng pari ang dugo sa altar ni Yahweh sa pasukan ng tolda ng pagpupulong; susunugin niya ang taba nito para makagawa ng isang mahalimuyak na amoy para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Hindi na dapat maghandog ang mga tao ng kanilang mga alay sa kambing na mga diosdiosan, kung saan kumikilos sila tulad ng mga bayarang babae. Ito ay magiging isang permanenteng batas para sa kanila hanggang sa katapusan ng kanilang salinlahi.' ");
INSERT INTO tglulb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Dapat mong sabihin sa kanila, 'Sinumang tao ng Israel, o sinumang dayuhang nakatira sa kanila, na maghahandog ng isang alay na susunugin bilang handog. ");
INSERT INTO tglulb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","at hindi ito dinala sa pasukan ng tolda ng pagpupulong upang ihandog ito para kay Yahweh, dapat na itiwalag ang taong iyon mula sa kanyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","At sinuman sa Israel, o sinumang dayuhang naninirahan sa kanila, na kumain ng kahit anong dugo, itatalikod ko ang aking mukha laban sa mga taong iyon, sa sinumang kumain ng dugo; ititiwalag ko siya mula sa kanyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Sapagkat ang buhay ng isang hayop ay nasa dugo nito. Ibinigay ko ang dugo nito sa inyo upang gawing pambayad ng kasalanan sa altar para sa inyong mga buhay, dahil ang dugong ito ang ginagawang pambayad ng kasalanan, sapagkat ang dugo ay pambayad ng kasalanan para sa buhay. ");
INSERT INTO tglulb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Kaya sinabi ko sa bayan ng Israel na walang sinuman sa inyo ang dapat kumain ng dugo, ni sinumang dayuhan na naninirahan kasama ninyo ang maaaring kumain nito. ");
INSERT INTO tglulb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","At sinumang mamamayan ng Israel, o sinumang mga dayuhang naninirahan sa kanila, na nangaso at pumatay ng isang hayop o ibon na maaaring kainin, dapat patuluin ng taong iyon ang dugo nito at takpan ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Sapagkat ang buhay ng bawat nilalang ay ang dugo nito. Kaya sinabi ko sa bayan ng Israel, “Hindi ninyo dapat kainin ang dugo ng anumang nilalang, sapagkat ang buhay ng bawat nilalang ay ang dugo nito. Dapat na itiwalag ang sinumang kumain nito.” ");
INSERT INTO tglulb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Bawat tao na kumain ng isang patay na hayop o ginutay-gutay ng mga mababangis na hayop, maging ang taong iyon ay katutubo o isang dayuhang naninirahan kasama ninyo, dapat niyang labahan ang kanyang mga damit at paliguan ang kanyang sarili sa tubig, at patuloy siyang marumi hanggang gabi. Pagkatapos nito magiging malinis na siya. ");
INSERT INTO tglulb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Subalit kung hindi niya nilabhan ang kanyang mga damit o pinaliguhan ang kanyang katawan, kung gayon dapat siyang managot sa kanyang kasalanan.'” ");
INSERT INTO tglulb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Kinausap ni Yahweh si Moises, sinabing, ");
INSERT INTO tglulb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Kausapin mo ang bayan ng Israel at sabihin sa kanila, 'Ako si Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Hindi ninyo dapat gawin ang mga bagay na ginagawa ng mga tao sa Ehipto, kung saan dati kayong nanirahan. At hindi ninyo dapat gawin ang mga bagay na ginagawa ng mga tao sa Canaan, sa lupain na pagdadalhan ko sa inyo. Huwag ninyong sundin ang kanilang mga kaugalian. ");
INSERT INTO tglulb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ang aking mga batas ang dapat ninyong gawin, at ang aking mga kautusan ang dapat ninyong sundin, para lumakad kayo dito, dahil Ako si Yahweh ang inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Kaya dapat ninyong sundin ang aking mga utos at aking mga batas. Kung susunod ang isang tao sa mga ito, mabubuhay siya dahil sa mga ito. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Walang sinuman ang dapat na sumiping sa malapit na kamag-anak niya. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Huwag ninyong lapastanganin ang inyong ama sa pagsiping sa inyong ina. Siya ay inyong ina! Hindi ninyo siya dapat lapastanganin. ");
INSERT INTO tglulb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Huwag kayong sumiping sa alinmang mga asawa ng inyong ama; hindi ninyo dapat lapastanganin ang inyong ama tulad nito. ");
INSERT INTO tglulb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Huwag sumiping sa sinuman sa inyong mga kapatid na babae, maging siya ay anak na babae ng inyong ama o anak na babae ng inyong ina, maging siya ay lumaki sa inyong tahanan o malayo mula sa inyo. Hindi dapat kayo sumiping sa inyong mga kapatid na babae. ");
INSERT INTO tglulb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Huwag kayong sumiping sa anak na babae ng inyong anak na lalaki o sa anak na babae ng inyong anak na babae. Magiging sarili ninyong kahihiyan iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Huwag kayong sumiping sa babaeng anak ng asawa ng inyong ama. Siya ay inyong kapatid, at hindi dapat kayo sumiping sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Huwag sumiping sa babaeng kapatid ng inyong ama. Siya ay isang malapit na kamag-anak ng inyong ama. ");
INSERT INTO tglulb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Huwag kayong sumiping sa babaeng kapatid ng inyong ina. Siya ay malapit na kamag-anak ng inyong ina. ");
INSERT INTO tglulb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Huwag ninyong alisan ng dangal ang kapatid na lalaki ng inyong ama sa pagsiping sa kanyang asawa. Huwag ninyo siyang lapitan para sa ganoong layunin; siya ay inyong tiyahin. ");
INSERT INTO tglulb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Huwag kayong sumiping sa inyong manugang na babae. Siya ay asawa ng inyong anak na lalaki; huwag siyang sipingan. ");
INSERT INTO tglulb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Huwag kayong sumiping sa asawa ng inyong kapatid na lalaki; huwag ninyo siyang lapastanganin sa ganitong paraan. ");
INSERT INTO tglulb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Huwag kayong sumiping sa isang babae at sa kanyang anak na babae, o sa babaeng anak ng kanyang anak na lalaki o sa babaeng anak ng kanyang anak na babae. Malapit na mga kamag-anak niya ang mga ito, at ang pagsiping sa kanila ay masama. ");
INSERT INTO tglulb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Hindi ninyo dapat pakasalan ang kapatid na babae ng inyong asawa bilang pangalawang asawa at sumiping sa kanya habang buhay pa ang una ninyong asawa. ");
INSERT INTO tglulb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Huwag kayong sumiping sa isang babae habang siya ay may regla. Siya ay marumi sa panahong iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Huwag kayong sumiping sa asawa ng inyong kapit-bahay at dungisan ang inyong sarili sa kanya sa ganitong paraan. ");
INSERT INTO tglulb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Hindi ninyo dapat ibigay ang sinuman sa inyong mga anak upang idaan sa apoy, upang ialay ninyo sila kay Molec, sapagkat hindi ninyo dapat lapastanganin ang pangalan ng inyong Diyos. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Huwag sumiping sa ibang kalalakihan gaya sa isang babae. Napakasama nito. ");
INSERT INTO tglulb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Huwag kayong sumiping sa alinmang hayop at dungisan ang inyong sarili dahil dito. Walang babae ang dapat na mag-isip na sumiping sa alinmang hayop. Ito ay kabuktutan. ");
INSERT INTO tglulb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Huwag ninyong dungisan ang inyong mga sarili sa mga paraang ito, sapagkat sa lahat ng mga paraang ito nadungisan ang mga bansa, mga bansang itataboy ko mula sa inyong harapan. ");
INSERT INTO tglulb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Naging marungis ang lupain, kaya pinarusahan ko ang kanilang kasalanan, at isinuka ng lupain ang mga naninirahan dito. ");
INSERT INTO tglulb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Kaya, dapat kayong sumunod sa aking mga utos at mga batas, at hindi ninyo dapat gawin ang alinman sa mga kasuklam-suklam na mga bagay na ito, maging katutubong Israelita o dayuhang naninirahan kasama ninyo. ");
INSERT INTO tglulb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Sapagkat ito ang mga kasamaang ginawa ng mga tao sa lupain, mga dating nanirahan dito bago kayo, at ngayon marungis na ang lupain. ");
INSERT INTO tglulb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Kaya mag-ingat kayo para hindi rin isuka kagaya ng mga taong nauna sa inyo.. ");
INSERT INTO tglulb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ititiwalag sa kanilang mga tao ang sinumang gumawa ng mga kasuklam-suklam na mga bagay na ito. ");
INSERT INTO tglulb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Kaya dapat ninyong ingatan ang aking kautusan upang hindi makagawa ng alinmang kasuklam-suklam na mga kaugalian na ginawa nila dito bago kayo, upang hindi ninyo madungisan ang inyong mga sarili dahil sa mga iyon. Ako si Yahweh na inyong Diyos.” ");
INSERT INTO tglulb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Kinausap ni Yahweh si Moises, sinabing, ");
INSERT INTO tglulb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Makipag-usap sa lahat ng kapulungan ng mga tao ng Israel at sabihin sa kanila, 'Kailangan ninyong maging banal, sapagkat ako ay banal, ako si Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Dapat gumalang ang bawat isa sa kanyang ina at kanyang ama, at dapat ninyong panatiliin ang araw ng aking pamamahinga. Ako si Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Huwag ng bumaling sa mga walang kuwentang diyus-diyosan, ni gumawa ng diyus-diyosan na gawa sa metal para sa inyong sarili. Ako si Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Kapag kayo ay nag-alay ng handog para sa pagtitipon kay Yahweh, dapat ninyong ihandog ito upang maaari kayong tanggapin. ");
INSERT INTO tglulb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Dapat itong kainin sa mismong araw nang ito ay inihandog, o sa susunod na araw. Kung may matira hanggang sa ikatlong araw, dapat na itong sunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Marumi na ito kung kakainin sa ikatlong araw. Hindi na dapat ito maaring tanggapin, ");
INSERT INTO tglulb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ngunit kung sinuman ang kumain nito ay dapat managot sa kanyang kasalanan sapagkat dinungisan niya ang inihandog kay Yahweh. Dapat na itiwalag ang taong iyon mula sa kanyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Kapag inani ninyo ang mga pananim sa inyong lupain, hindi ninyo dapat anihin ang lahat ng sulok ng inyong bukirin, ni ipunin ang lahat ng bunga ng inyong ani. ");
INSERT INTO tglulb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Hindi ninyo dapat ipunin ang bawat ubas mula sa inyong ubasan, ni ipunin ang mga ubas na nahulog sa lupa sa inyong ubasan. Dapat ninyong iwan ang mga ito para sa mahihirap at para sa dayuhan. Ako si Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Huwag magnakaw. Huwag magsinungaling. Huwag linlangin ang bawat isa. ");
INSERT INTO tglulb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Huwag manumpa ng kasinungalingan gamit ang aking pangalan at huwag lapastanganin pangalan ng inyong Diyos. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Huwag ninyong apihin ang inyong kapit-bahay o pagnakawan sila. Ang bayad ng isang inupahang tagapaglingkod ay hindi dapat manatili sa inyo ng buong gabi hanggang umaga. ");
INSERT INTO tglulb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Huwag isumpa ang bingi o lagyan ng isang harang sa harapan ng bulag. Sa halip, dapat ninyong katakutan ang inyong Diyos. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Huwag idulot na ang paghataol ay maging kasinungalingan. Hindi dapat kayo magpakita ng pagtatangi sa sinuman dahil siya ay mahirap, at hindi dapat kayo magpakita ng pagtatangi sa sinuman sapagkat siya ay mahalaga. Sa halip, maghusga ng matuwid sa inyong kapwa. ");
INSERT INTO tglulb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Huwag maglibot sa pagkalat ng maling tsismis sa inyong mga bayan, nguni't protektahan ang buhay ng inyong kapwa. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Huwag kamuhian ang inyong kapatid sa inyong puso. Dapat ninyong pagsabihan nang tapat ang inyong kapwa upang hindi kayo magkasala dahil sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Huwag maghiganti o magtanim ng sama ng loob laban sa sinuman sa inyong kapwa, nguni't sa halip mahalin ninyo ang inyong kapwa gaya ng inyong sarili. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Dapat ninyong ingatan ang aking mga utos. Huwag subukang palahian ang inyong mga hayop ng iba't ibang uri ng mga hayop. Huwag ihalo ang dalawang magkaibang uri ng buto kapag nagtatanim sa inyong kabukiran. Huwag magsuot ng damit na gawa sa dalawang uri ng materyal na magkasama. ");
INSERT INTO tglulb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ang sinumang sumiping sa isang aliping babae na nakapangako ng ikasal sa isang lalaki, subalit hindi pa natubos o naibigay ang kanyang kalayaan, sila ay dapat maparusahan. Hindi dapat sila ipapatay sapagkat hindi siya malaya. ");
INSERT INTO tglulb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Dapat dalhin ng lalaking iyon ang kanyang handog na pambayad ng kasalanan kay Yahweh sa pasukan ng tolda ng pagtitipon—isang lalaking tupa bilang isang alay na pambayad ng kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Pagkatapos gagawa ng pambayad ng kasalanan ang pari para sa kanya sa papamagitan ng lalaking tupa sa harapan ni Yahweh, para sa kasalanan na nagawa niya. Pagkatapos mapapatawad ang kasalanan na kanyang nagawa. ");
INSERT INTO tglulb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kapag pumunta kayo sa lupain at magtanim ng lahat ng uri ng mga puno para makain, kung gayon dapat ninyong ituring ang bunga na kanilang nakuha bilang pinagbabawal na kainin. Dapat ipagbawal ang bunga sa inyo ng tatlong taon. Hindi dapat itong kainin. ");
INSERT INTO tglulb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Subalit sa ikaapat na taon lahat ng bunga ay magiging banal, na isang papuring handog kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Sa ikalimang taon maaari na ninyong kainin ang bunga, kinakailangang maghintay upang higit pang magbunga ang puno. Ako si Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Huwag kumain ng anumang karne na may dugo pa nito. Huwag yayong sumangguni sa mga espiritu tungkol sa hinaharap, at huwag kayong maghangad na makontrol ang iba sa pamamagitan ng mga kahima-himalang kapangyarihan. ");
INSERT INTO tglulb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Huwag sumunod sa mga gawain ng pagano tulad ng pag-ahit sa kanilang magkabilaang ulo o pagputol sa kanilang gilid mula sa kanilang balbas. ");
INSERT INTO tglulb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Huwag ninyong sugatan ang inyong katawan para sa patay o maglagay ng tatu sa inyong katawan. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Huwag ninyong idulot sa kahihiyan ang inyong anak na babae para maging babaeng bayaran, o babagsak sa prostitusyon ang bansa ay mapupuno ng kasamaan. ");
INSERT INTO tglulb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Dapat ninyong panatiliin ang araw ng aking pamamahinga at igalang ang santuwaryo ng aking tabernakulo. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Huwag bumaling sa mga nakikipag usap sa mga patay o sa mga espiritu. Huwag hanapin ang mga ito, o dudungisan lang nila kayo. Ako si Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Dapat kayong tumayo sa harapan ng taong may puting buhok at igalang ang presensiya ng isang matandang tao. Dapat ninyong katakutan ang inyong Diyos. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Kung naninirahan ang isang dayuhan sa inyong lupain, huwag dapat kayong gumawa ng anumang mali sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ang naninirahang dayuhan sa inyo ay dapat maging tulad ninyong katutubong Israelita na kasama ninyong naninirahan, at dapat ninyo siyang mahalin tulad ng inyong sarili, sapagkat naging mga dayuhan kayo sa lupain ng Ehipto. Ako si Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Huwag gumamit ng mga maling sukatan kapag nagsusukat ng haba, bigat, o dami. ");
INSERT INTO tglulb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Dapat gumamit lamang kayo ng mga tamang timbangan, mga tamang pabigat, isang tamang epa, at isang tamang hin. Ako si Yahweh na inyong Diyos, na siyang nagdala sa inyo palabas sa lupain ng Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Dapat ninyong sundin ang lahat ng aking mga kautusan at lahat ng aking mga batas, at gawin ang mga ito. Ako si Yahweh.”” ");
INSERT INTO tglulb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Nakipag-usap si Yahweh kay Moises, na sinasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Sabihin sa bayan ng Israel, 'Sinuman sa mga mamamayan ng Israel, o sinumang dayuhan na namumuhay sa Israel na magbigay ng sinuman sa kanyang mga anak kay Molec, ay tiyak na papatayin. Dapat siyang batuhin ng mga tao sa lupain gamit ang mga bato. ");
INSERT INTO tglulb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Haharap din ako laban sa taong iyon at tatanggalin siya mula sa kanyang mga tao dahil ibinigay niya ang kanyang anak kay Molec, upang dungisan ang aking banal na lugar at lapastanganin ang aking banal na pangalan. ");
INSERT INTO tglulb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kung ipipikit ng mga tao sa lupain ang kanilang mga mata sa lalaking iyon kapag ibinigay ang sinuman sa kanyang mga anak kay Molec, kung hindi nila pinatay, ");
INSERT INTO tglulb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","sa gayon ako mismo ang haharap laban sa taong iyon at sa kanyang angkan, at tatanggalin ko siya at bawat isa pang gagamitin sa masama ang kanyang sarili para gumanap bilang isang babaeng bayaran kay Molec. ");
INSERT INTO tglulb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ang isang taong pumupunta sa mga nakikipag-usap sa patay, o sa mga nakikipag-usap sa mga espiritu para isama ang kanilang sarili ssa kanila, haharap ako laban sa taong iyon; tatanggalin ko siya mula sa kanyang bayan. ");
INSERT INTO tglulb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Kaya ialay ninyo ang inyong mga sarili kay Yahweh at maging banal, dahil ako si Yahweh ang inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Dapat ninyong sundin ang aking mga utos at isagawa ang mga ito. Ako si Yahweh, na siyang nagtatalaga sa inyo para sa aking sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ang lahat na sumusumpa sa kanyang ama o sa kanyang ina ay tiyak na papatayin. Isinumpa niya ang kanyang ama o ang kanyang ina, kaya siya ay nagkasala at karapat-dapat mamatay. ");
INSERT INTO tglulb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ang taong gumagawa ng pangangalunya sa asawa ng ibang lalaki, iyon ay, sinumang gumagawa ng pangangalunya sa asawa ng kanyang kapitbahay—ang nakikiapid na lalaki at ang nakikiapid na babae ay tiyak na kapwa papatayin. ");
INSERT INTO tglulb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ang lalaking sumisiping sa asawa ng kanyang ama para makipagtalik sa kanya ay nagdulot ng kahihiyan sa kanyang sariling ama. Kapwa ang anak na lalaki at ang asawa ng kanyang ama ay tiyak na papatayin. Sila ay nagkasala at karapat-dapat mamatay. ");
INSERT INTO tglulb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kung sipingan ng isang lalaki ang kanyang manugang na babae, tiyak na kapwa silang dapat patayin. Nakagawa sila ng kabuktutan. Sila ay nagkasala at karapat-dapat mamatay. ");
INSERT INTO tglulb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kapag sumiping ang isang lalaki sa kapwa lalaki, tulad ng sa isang babae, pareho silang nakagawa ng kasuklam-suklam na bagay. Tiyak na dapat silang patayin. Sila ay nagkasala at karapat-dapat mamatay. ");
INSERT INTO tglulb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Kung pakasalan ng isang lalaki ang isang babae at pakasalan din ang kanyang ina, ito ay kasamaan. Dapat silang sunugin, kapwa siya at ang mga babae, upang hindi magkaroon ng kasamaan sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Kung sumiping ang isang lalaki sa isang hayop, tiyak na dapat siyang patayin, at dapat ninyong patayin ang hayop. ");
INSERT INTO tglulb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kung lumapit ang isang babae sa anumang hayop para sipingan ito, dapat ninyong patayin ang babae at ang hayop. Tiyak na dapat silang patayin. Sila ay nagkasala at karapat-dapat mamatay. ");
INSERT INTO tglulb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Kung sumiping ang isang lalaki sa kanyang kapatid na babae, alinman sa anak na babae ng kanyang ama o alinman sa anak na babae ng kanyang ina—kung sumiping siya sa babae at ang babae sa kanya, ito ay isang kahiya-hiyang bagay. Dapat silang alisin mula sa presensiya ng kanyang mga tao, dahil sumiping siya sa kanyang kapatid na babae. Dapat niyang dalhin ang kanyang kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kung sipingan ng isang lalaki ang isang babae sa panahon ng kanyang pagreregla at nakipagtalik sa kaniya, binuksan niya ang agusan ng kanyang dugo, ang pinagmumulan ng kanyang dugo. Kapwa ang lalaki at babae ay dapat alisin mula sa kanilang bayan. ");
INSERT INTO tglulb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Hindi ninyo dapat sipingan ang kapatid na babae ng inyong ina, ni kapatid na babae ng inyong ama, dahil ipapahiya ninyo ang inyong malapit na kamag-anak. Dapat ninyong dalhin ang sarili ninyong kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Kung sipingan ng isang lalaki ang asawa ng kanyang tiyuhin, ipinahiya niya ang kanyang tiyuhin. Dapat nilang dalhin ang sarili nilang kasalanan at mamatay ng walang anak. ");
INSERT INTO tglulb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Kung pakasalan ng isang lalaki ang asawa ng kanyang kapatid na lalaki, ito ay kalaswaan dahil nagkaroon siya ng kaugnayang lumalabag sa kasal ng kanyang kapatid na lalaki, at hindi sila magkakaanak. ");
INSERT INTO tglulb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Kaya dapat ninyong sundin ang lahat ng aking mga batas at lahat ng aking mga utos; dapat ninyong sundin ang mga ito sa gayon hindi kayo isusuka ng lupain kung saan ko kayo dadalhin para manirahan. ");
INSERT INTO tglulb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Hindi kayo dapat mamuhay sa mga kaugalian ng mga bansang itataboy ko sa harapan ninyo, dahil ginawa nila ang lahat ng mga bagay na ito, at kinamumuhian ko ang mga ito. ");
INSERT INTO tglulb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Sinabi ko sa inyo, “Mamanahin ninyo ang kanilang lupain; ibibigay ko ito sa inyo para angkinin, isang lupaing dinadaluyan ng gatas at pulot. Ako si Yahweh na inyong Diyos, na siyang naghiwalay sa inyo mula sa ibang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Kaya dapat ninyong kilalanin ang kaibahan ng malinis na mga hayop at ng marumi, at kaibahan ng maruming mga ibon at ang malinis. Huwag dapat ninyong dungisan ang inyong mga sarili ng mga maruming hayop o mga ibon o anumang nilikhang gumagapang sa lupa, na inihiwalay ko bilang marumi mula sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kayo ay dapat maging banal, dahil Ako, si Yahweh, ay banal, at ibinukod ko kayo mula sa ibang mga tao, dahil kayo ay aking pag-aari. ");
INSERT INTO tglulb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Tiyak na dapat patayin ang isang lalaki o isang babaeng nakikipag-usap sa patay o nakikipag-usap sa mga espiritu. Dapat silang batuhin ng mga tao gamit ang mga bato. Sila ay nagkasala at nararapat mamatay.”' ");
INSERT INTO tglulb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Sinabi ni Yahweh kay Moises: “Nagsalita sa mga pari, ang mga anak na lalaki ni Aaron, at kanilang sinabi, 'Walang isa sa inyo ang gagawing hindi malinis ang kaniyang sarili para sa mga namatay sa kaniyang mga tao, ");
INSERT INTO tglulb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","maliban para sa isang malapit na kamag-anak—para sa kaniyang ina at ama, para sa kaniyang anak na lalaki at babae, o para sa kaniyang kapatid ");
INSERT INTO tglulb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o para sa isang birheng kapatid na babae na nasa kaniyang bahay at walang asawa. Para sa kaniya maari niyang gawing hindi malinis ang kaniyang sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ngunit hindi niya dapat gawing hindi malinis ang kanyang sarili dahil sa ibang kamag-anak, upang dungisan ang kanyang sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Hindi dapat mag-ahit ang mga pari ng kanilang mga ulo o ahitin ang mga gilid ng kanilang balbas, o sugatan ang kanilang katawan. ");
INSERT INTO tglulb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Dapat silang ibukod para sa kanilang Diyos, at hindi ipahiya ang pangalan ng kanilang Diyos, dahil ang mga pari ang naghahandog ng mga alay kay Yahweh sa pamamagitan ng apoy, ang “pagkain” ng kanilang Diyos. Kaya dapat silang ibukod. ");
INSERT INTO tglulb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Hindi sila dapat mag-asawa ng sinumang babaeng bayaran at nadungisan, at hindi sila dapat mag-asawa ng isang babaeng hiwalay mula sa kaniyang asawa, sapagkat ibinukod sila para sa kanilang Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Dapat mo siyang ihandog sapagkat nag-aalay siya ng “pagkain” mula sa inyong Diyos. Dapat siyang maging banal sa iyong paningin, dahil Ako, si Yahweh, na siyang naghandog sa inyo sa aking sarili, ay banal din. ");
INSERT INTO tglulb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Sinumang anak na babae ng pari ang dudungis sa kanyang sarili sa pamamagitan ng pagiging isang babaeng bayaran ay ipinapahiya ang kaniyang ama. Dapat siyang sunugin. ");
INSERT INTO tglulb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Siya na punong pari sa kanyang mga kapatid na lalaki, kung kaninong ulo ibinuhos ang panghirang na langis, at ginawang banal upang magsuot ng mga natatanging kasuotan ng punong pari, ay hindi dapat guluhin ang kanyang buhok o punitin ang kanyang mga damit. ");
INSERT INTO tglulb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Hindi siya dapat pumunta kahit saan na mayroong isang patay na katawan at dungisan ang kanyang sarili, kahit para sa kanyang ama o sa kanyang ina. ");
INSERT INTO tglulb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Hindi dapat iiwan ng punong pari ang dako ng santuwaryo ng tabernakulo o lapastanganin ang santuwaryo ng kaniyang Diyos, dahil ginawa siyang banal bilang punong pari sa pamamagitan ng panghirang na langis ng kanyang Diyos. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Dapat mag-asawa ang punong pari ng isang birhen bilang kanyang asawa. ");
INSERT INTO tglulb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Hindi siya dapat mag-asawa ng isang balo, isang babaeng hiwalay sa asawa, o isang babaeng bayaran. Hindi siya dapat mag-asawa ng ganitong mga uri ng babae. Maaari lang siyang mag-asawa ng isang birhen mula sa kaniyang sariling lahi. ");
INSERT INTO tglulb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Dapat niyang sundin ang mga patakarang ito, upang hindi niya madungisan ang kaniyang mga anak sa kaniyang lahi, sapagkat Ako si Yahweh, na naghandog sa kaniya para sa aking sarili.''' ");
INSERT INTO tglulb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Sinabi ni Yahweh kay Moises, sinasabi, ");
INSERT INTO tglulb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“sabihin kay Aaron at sabihin niya, 'Sinuman sa iyong mga kaapu-apuhan hanggang sa buong salinlahi nila ang may kapansanan sa katawan, hindi siya dapat lumapit upang ihandog ang 'pagkain' ng kanyang Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Hindi dapat lumapit kay Yahweh ang sinumang taong may kapansanan sa katawan, gaya ng isang taong bulag, isang taong pilay, isa na ang anyo ay nasira o pumangit, ");
INSERT INTO tglulb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","isang taong pilay ang kamay o paa, ");
INSERT INTO tglulb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kuba o taong unano, o isang taong may kapansanan sa kanyang mga mata, o may isang sakit, pamamaga, galis, o napinsala ang mga pribadong bahagi. ");
INSERT INTO tglulb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Walang tao sa mga kaapu-apuhan ni Aaron na pari na may kapansanan ang katawan na maaaring lumapit upang magsagawa ng mga paghahandog sa pamamagitan ng apoy para kay Yahweh. Ang isang taong iyon ay may kapansanan sa katawan; hindi siya dapat lumapit upang ihandog ang 'pagkain' ng kanyang Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Maaari niyang kainin ang pagkain ng kanyang Diyos, maging ang ilan sa mga kabanalbanalan o ilan sa banal. ");
INSERT INTO tglulb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Gayunman, hindi siya dapat pumasok sa loob ng kurtina o lumapit sa altar, dahil siya ay may kapansanan sa katawan, upang hindi niya madungisan ang aking banal na lugar, dahil ako si Yahweh, ang siyang naghandog sa kanila para sa aking sarili.''' ");
INSERT INTO tglulb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Kaya sinabi ni Moises ang mga salitang ito kay Aaron, sa kanyang mga anak na lalaki, at sa lahat ng mga tao ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Sinabi ni Yahweh kay Moises, sinasabi, ");
INSERT INTO tglulb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Sabihin kay Aaron at sa kaniyang mga anak na lalaki, pagsabihan silang lumayo mula sa mga bagay na banal ng mga tao ng Israel, na inihahandog nila sa akin. Hindi nila dapat lapastanganin ang aking banal na pangalan. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Sabihin sa kanila, 'Sinuman sa inyong mga kaapu-apuhan sa buong angkan ng inyong mga tao na marumi kapag lumapit siya sa mga banal na bagay na inihandog ng mga tao ng Israel kay Yahweh, dapat ihiwalay ang taong iyon mula sa harap ko. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Wala sa mga kaapu-apuhan ni Aaron na may nakakahawang sakit sa balat, o isang impeksiyong dumadaloy mula sa kaniyang katawan, ang maaaring kumain ng alinman sa mga alay na ginawa para kay Yahweh hanggang siya ay malinis. Sinuman ang hahawak sa anumang bagay na marumi sa pamamagitan ng paghawak sa patay, o sa pamamagitan ng paghawak sa isang lalaking may daloy ng semilya, ");
INSERT INTO tglulb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o sinumang hahawak ng anumang hayop na gumagapang na nagpaparumi sa kaniya, o sinumang tao na nagpaparumi sa kanya, maging anumang uri ng karumihang ito— ");
INSERT INTO tglulb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","pagkatapos ang pari na hahawak sa anumang marumi ay magiging marumi hanggang gabi. Hindi siya dapat kumain ng anumang mga banal na bagay, maliban lang kung pinaliguan niya ang kanyang katawan sa tubig. ");
INSERT INTO tglulb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Kapag lumubog na ang araw, magiging malinis siya. Maaari siyang kumain mula sa banal na mga bagay pagkatapos ng paglubog ng araw, dahil ang mga ito ay kaniyang pagkain. ");
INSERT INTO tglulb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Hindi siya dapat kumain ng anumang bagay na natagpuang patay o pinatay ng mga mababangis na hayop, kung saan madudungisan niya ang kanyang sarili. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Dapat sumunod ang mga pari sa mga tagubilin ko, o magkakasala sila at maaaring mamatay dahil sa paglapastangan sa akin. Ako si Yahweh, na siyang naghahandog sa kanila sa aking sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Walang sinumang hindi kapamilya ng pari, maging ang mga bisita ng isang pari o kaniyang mga inupahang tagapaglingkod ang maaaring kumain ng anumang bagay na banal. ");
INSERT INTO tglulb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ngunit kung bumili ang isang pari ng alipin sa kaniyang sariling pera, maaaring kumain ang aliping iyan mula sa mga bagay na inihiwalay para kay Yahweh. At ang mga miyembro sa pamilya ng pari at mga aliping ipinanganak sa kaniyang bahay, maaari din silang kumain kasama niya mula sa mga bagay na iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kung ikinasal sa isang hindi pari ang anak na babae ng isang pari, hindi siya maaaring kumain ng anumang banal na ambag na mga handog. ");
INSERT INTO tglulb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ngunit kung isang balo ang anak na babae ng pari, o hiwalay, at kung wala siyang anak, at kung babalik siya upang manirahan sa bahay ng kanyang ama gaya noong kanyang kabataan, maaari siyang kumain mula sa pagkain ng kanyang ama. Ngunit walang sinumang hindi pamilya ng pari ang maaaring kumain mula sa pagkain ng pari. ");
INSERT INTO tglulb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Kung kumain ang isang tao ng isang banal na pagkain na hindi ito nalalaman, dapat niyang bayaran ang pari para rito; dapat niyang dagdagan ng ikalimang bahagi ito at ibalik ito sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Hindi dapat bastusin ng mga tao ng Israel ang mga bagay na banal na itinaas at inihandog kay Yahweh, ");
INSERT INTO tglulb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","at idudulot ang kanilang sarili upang dalhin ang kasalanang gagawin silang may sala sa pagkain ng banal na pagkain, dahil ako si Yahweh, na siyang naghahandog sa kanila sa aking sarili.”' ");
INSERT INTO tglulb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Sinabi ni Yahweh kay Moises, sinasabi, ");
INSERT INTO tglulb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Sabihin kay Aaron at sa kaniyang mga anak na lalaki, at lahat ng mga tao ng Israel. Sabihin sa kanila, 'Sinumang Israelita, o isang banyaga na naninirahan sa Israel, kapag maghahandog sila ng isang alay— kahit na ito ay para tuparin ang isang panata o kahit na ito ay isang kusang handog, o maghahandog sila kay Yahweh ng isang handog na susunugin, ");
INSERT INTO tglulb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kung ito ay tatanggapin, dapat silang maghandog ng isang lalaking hayop na walang kapintasan mula sa baka, tupa, o mga kambing. ");
INSERT INTO tglulb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Pero hindi ninyo dapat ialay ang anumang may kapintasan. Hindi ko ito tatanggapin sa ngalan ninyo. ");
INSERT INTO tglulb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Sinumang maghandog ng alay para sa pagtitipon-tipon ng handog mula sa maraming tao o sa kawan ni Yahweh para tuparin ang isang panata, o bilang isang kusang handog, dapat wala itong kapintasan para tanggapin. Dapat walang depekto ang hayop. ");
INSERT INTO tglulb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Hindi kayo dapat maghandog ng mga hayop na bulag, baldado, o lumpo, o mayroong mga kulugo, mga sugat, o mga galis. Hindi ninyo dapat ihandog ang mga ito kay Yahweh bilang alay sa pamamagitan ng apoy sa altar. ");
INSERT INTO tglulb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Maaari ninyong ihandog bilang kusang handog ang isang lalaking baka o kordero na sira ang anyo o maliit, ngunit ang isang handog na katulad niyan ay hindi tatanggapin para sa isang panata. ");
INSERT INTO tglulb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Huwag maghandog kay Yahweh ng mga hayop na may bugbog, durog, sira o hiwa sa mga pampaanak na bahagi. Huwag ihandog ang mga ito sa inyong lupain, ");
INSERT INTO tglulb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","at huwag tanggapin ang mga ito mula sa kamay ng isang dayuhan bilang pagkaing inihandog sa Diyos, dahil may mga depekto o kapintasan sa mga ito. Hindi ko tatanggapin ang mga ito sa ngalan ninyo. ");
INSERT INTO tglulb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Nakipag-usap si Yahweh kay Moises at sinabi, ");
INSERT INTO tglulb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Kapag ipinanganak ang isang guya o isang tupa o isang kambing, dapat itong manatili sa kaniyang ina ng pitong araw. Pagkatapos mula sa walong araw, maaaring tanggapin ito bilang isang alay para sa isang handog na gawa sa apoy kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Huwag pumatay ng isang baka o tupang babae kasama ang kaniyang anak, sa ganitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kapag mag-aalay kayo ng isang handog ng pasasalamat kay Yahweh, dapat kayong mag-alay nito sa isang katanggap-tanggap na paraan. ");
INSERT INTO tglulb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Dapat itong kainin sa ganitong araw na inihandog ito. Hindi kayo dapat magtira nito hanggang sa susunod na umaga. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Kaya dapat ninyong sundin ang aking mga kautusan at tuparin ang mga ito. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Huwag dapat ninyong ilagay sa kahihiyan ang aking banal na pangalan. Dapat akong kilalanin bilang banal ng mga bayan ng Israel. Ako si Yahweh na inaalay ko sa inyong sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","na siyang naglabas sa inyo sa lupain ng Ehipto, upang maging inyong Diyos. Ako si Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Kinausap ni Yahweh si Moises: ");
INSERT INTO tglulb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Kausapin mo ang bayan ng Israel, at sabihin sa kanila, 'Ang itinalagang mga pista para kay Yahweh, kung saan dapat ninyong ipahayag bilang banal na mga pagpupulong, ay karaniwang mga pista sa akin. ");
INSERT INTO tglulb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Maaari kayong magtrabaho sa loob ng anim na araw, ngunit sa ikapitong araw ay isang ganap na Araw ng Pamamahinga, isang banal na pagpupulong. Dapat hindi kayo magtatrabaho sapagkat ito ay isang Araw ng Pamamahinga para kay Yahweh sa lahat ng mga lugar kung saan kayo nakatira. ");
INSERT INTO tglulb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ito ay ang mga itinalagang pista ni Yahweh, ang banal na mga pagpupulong na dapat ninyong ipahayag ayon sa kanilang itinalagang mga panahon: ");
INSERT INTO tglulb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Sa unang buwan, sa ikalabing-apat na araw ng buwan sa takipsilim, ay Paskuwa ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Sa ikalabing-limang araw sa parehong buwan ay ang Pista ng Tinapay na Walang Lebadura para kay Yahweh. Dapat ninyong kainin ang tinapay na walang lebadura sa loob ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Sa unang araw mayroon kayong isang pagpupulong na inihandog kay Yahweh, dapat hindi kayo gagawa ng karaniwang trabaho. ");
INSERT INTO tglulb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Dapat kayong mag-alay ng isang handog na gawa sa pamamagitan ng apoy para kay Yahweh sa loob ng pitong araw. Ang ikapitong araw ay isang pagpupulong na inihandog para kay Yahweh na kung saan dapat hindi kayo gagawa ng karaniwang trabaho.'” ");
INSERT INTO tglulb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Kinausap ni Yahweh si Moises, sinasabi, ");
INSERT INTO tglulb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Kausapin mo ang mga bayan ng Israelita at sabihin sa kanila, 'Kapag dumating kayo sa loob ng lupain na ibibigay ko sa inyo, at kapag ginapas ninyo ang ani nito, sa gayon dapat dalhin ninyo sa pari ang isang tali ng mga unang prutas nito. ");
INSERT INTO tglulb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Itataas niya ang tali sa harap ni Yahweh at idulog ito kay Yahweh, upang tanggapin ito para sa ngalan mo. Ito ay sa araw pagkatapos ng Araw ng Pamamahinga na itataas ito ng pari at idudulog ito sa akin. ");
INSERT INTO tglulb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Kapag sa araw na itinaas ninyo ang tali at idinulog ito sa akin, dapat ninyong ihandog ang isang taong gulang na lalaking tupa at walang dungis bilang isang handog na susunugin para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Dapat ang handog na pagkaing butil dalawang ikapu ng isang epah ng pinong harina na hinaluan ng langis, isang handog na ginawa sa pamamagitan ng apoy para kay Yahweh, para magpalabas ito ng isang mabangong amoy, at kasama dito ang isang inuming handog na alak, sa ikaapat na bahagi ng isang hin. ");
INSERT INTO tglulb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Dapat hindi kayo kakain ng tinapay, ni inihaw o sariwang butil, hanggang sa parehong araw ng inyong pagdadala itong handog sa inyong Diyos. Magiging isang permanenteng batas ito hanggang sa katapusan ng inyong mga angkan, sa bawat lugar ng inyong titirhan. ");
INSERT INTO tglulb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Magbibilang kayo kinabukasan mula sa Araw ng Pamamahinga, mula sa araw ng dinala ninyo ang tali na paghahandog para itaas at idinulog, pitong buong linggo, pitong Araw ng Pamamahinga, ");
INSERT INTO tglulb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","hanggang ang araw pagkatapos ang ikapitong Araw ng Pamamahinga. Iyon ay, dapat kayong bumilang ng limampung araw. Pagkatapos dapat ninyong ialay ang isang handog ng bagong butil kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Dapat ninyong ilabas sa inyong mga bahay ang dalawang tinapay na ginawa mula sa dalawang ikapu ng isang epah. Dapat ginawa ang mga ito mula sa pinong harina at inihurno kasama ang lebadura; isang paghahandog ang mga ito mula sa unang mga prutas na itataas at idinulog kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Dapat ninyong idulog kasama ang tinapay, pitong tupa isang taong gulang at walang dungis, isang batang toro, at dalawang lalaking tupa. Dapat itong maging isang handog na susunugin para kay Yahweh, kasama ang kanilang handog ng pagkaing butil at kanilang mga inuming handog, isang paghahandog na ginawa sa pamamagitan ng apoy at maglalabas ng isang mabangong amoy para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Maghahandog kayo ng isang lalaking kambing para sa isang handog para sa kasalanan, at dalawang tupang lalaki na isang taong gulang para isang alay, bilang mga handog ng pagtitipon-tipon. ");
INSERT INTO tglulb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Dapat itataas ng pari ang mga ito sa harapan ni Yahweh, kasama ang tinapay sa unang mga prutas, at idulog ang mga ito sa kanya bilang isang paghahandog kasama ang dalawang tupa. Mga banal na handog ito kay Yahweh para sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Dapat gumawa kayo ng isang pahayag sa parehong araw na iyon. Magkakaroon ng isang banal na pagpupulong, at dapat hindi kayo gagawa ng karaniwang trabaho. Magiging isang permanenteng batas ito hanggang sa katapusan ng inyong mga salinlahi sa lahat ng mga lugar kung saan kayo nakatira. ");
INSERT INTO tglulb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Kapag gagapasin ninyo ang ani ng inyong lupain, dapat hindi ninyo gagapasin nang lubos ang mga sulok ng inyong mga bukirin, at dapat hindi ninyo iipunin ang mga naipon ninyong ani. Dapat ninyong iwanan ang mga ito para sa mga mahihirap at para sa mga dayuhan. Ako ay Yahweh na inyong Diyos.'” ");
INSERT INTO tglulb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Kinausap ni Yahweh si Moises, sinasabi, ");
INSERT INTO tglulb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Kausapin ang bayan ng Israel at sabihin, 'Sa ikapitong buwan, ang unang araw ng buwan na iyon magiging isang mataimtim na pahinga para sa inyo, isang alaala sa pamamagitan ng pag-ihip ng mga trumpeta, at isang banal na pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Dapat hindi kayo gagawa ng karaniwang trabaho, at dapat ninyong ialay ang isang handog na ginawa sa pamamagitan ng apoy kay Yahweh.'” ");
INSERT INTO tglulb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Pagkatapos kinausap ni Yahweh si Moises, sinasabi, ");
INSERT INTO tglulb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ngayon ang ika-sampung araw ng ikapitong buwan magiging Araw ng Pambayad ng Kasalanan. Dapat magiging isang pagpupulong na inilaan kay Yahweh, dapat magpakumbaba kayo at gumawa ng isang handog na inialay sa pamamagitan ng apoy para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Dapat hindi kayo magtatrabaho sa araw na iyon sapagkat ito ay ang Araw ng Pambayad ng Kasalanan, upang gawin ang pambayad ng kasalanan para sa inyong mga sarili sa harapan ni Yahweh na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ang sinumang hindi magpapakumbaba ng kaniyang sarili sa araw na iyon dapat ihiwalay mula sa kaniyang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ang sinumang gagawa ng trabaho sa araw na iyon, Ako, Yahweh, lilipulin ko siya mula sa kanyang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Dapat hindi kayo gagawa ng kahit anong trabaho sa araw na iyon. Magiging isang permanenteng batas ito hanggang sa katapusan ng inyong mga salinlahi sa lahat ng mga lugar kung saan kayo nakatira. ");
INSERT INTO tglulb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Dapat ang araw na ito ay maging isang mataimtim na Araw ng Pamamahinga para sa inyo, at magpakumbaba kayo sa ikasiyam na buwan. Mula sa gabi hanggang sa susunod na gabi dapat ninyong panatilihin ang Araw ng inyong Pamamahinga.' ");
INSERT INTO tglulb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Kinausap ni Yahweh si Moises, sinasabi, ");
INSERT INTO tglulb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Kausapin ang mga bayan ng Israel, sinasabi, 'Sa ikalabing-limang araw ng ikapitong buwan magiging Pista ng mga Kanlungan para kay Yahweh. Magtatagal ito ng pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Dapat magkaroon ng isang banal na pagpupulong sa unang araw. Dapat hindi kayo gagawa ng karaniwang trabaho. ");
INSERT INTO tglulb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Sa loob ng pitong araw dapat kayong maghandog ng isang alay na ginawa sa pamamagitan ng apoy para kay Yahweh. Sa ikawalong araw dapat magkaroon ng isang banal na pagpupulong, at dapat kayong gumawa ng isang alay na ihahandog sa pamamagitan ng apoy para kay Yahweh. Ito ay isang mataimtin na pagpupulong, at hindi kayo gagawa kahit anong karaniwang trabaho. ");
INSERT INTO tglulb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Ito ay ang itinalagang mga pista para kay Yahweh, na dapat ninyong ipahayag bilang banal na mga pagpupulong para maghandog ng alay na ginawa sa pamamagitan ng apoy para kay Yahweh, isang handog na susunugin at isang handog na pagkaing butil, mga alay at mga inuming handog, isa sa bawat araw nito. ");
INSERT INTO tglulb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Mga pistang ito'y magiging dagdag sa mga Araw ng Pamamahinga para kay Yahweh at inyong mga regalo, lahat ninyong mga panata at lahat ninyong kusang loob na mga handog na inyong ibibigay kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Tungkol sa Pista ng mga Kanlungan, sa ikalabing-limang araw ng ikapitong buwan, kapag inipon ninyo ang mga prutas ng mga lupain, dapat ninyong panatilihin ang pista ni Yahweh sa loob ng pitong araw. Ang unang araw magiging isang mataimtim na pahinga, at ang ikawalong araw magiging isa ring mataimtim na pahinga. ");
INSERT INTO tglulb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Sa unang araw dapat magdala kayo ng pinakamainam na prutas mula sa mga puno, mga sanga ng mga puno ng palma, at madahong mga sanga na mayabong sa mga puno, at mga puno mula sa batis, at magsasaya kayo sa harapan ni Yahweh na inyong Diyos sa pitong araw. ");
INSERT INTO tglulb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Sa pitong araw ng bawat taon, dapat ninyong ipagdiwang itong pista para kay Yahweh. Magiging permanenteng batas ito hanggang sa katapusan ng inyong mga salinlahi sa lahat ng mga lugar kung saan kayo nakatira. Dapat ninyong ipagdiwang itong pista sa ikapitong buwan. ");
INSERT INTO tglulb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Dapat kayong manirahan sa maliliit na mga kanlungan sa loob ng pitong araw. Lahat ng likas na ipinanganak na mga Israelita dapat tumira sa maliliit na mga kanlungan sa loob ng pitong araw, ");
INSERT INTO tglulb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","para ang inyong mga kaapu-apuhan, angkan sa mga angkan, maaaring malaman kung papaano ko ginawa ang mga bayan ng Israel na manirahan sa ganoong mga kanlungan nang inilabas ko sila sa lupain ng Ehipto. Ako si Yahweh ang inyong Diyos,'” ");
INSERT INTO tglulb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Sa ganitong paraan, ipinahayag ni Moises sa mga bayan ng Israel ang itinalagang kapistahan para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Kinausap ni Yahweh si Moises, sinasabi, ");
INSERT INTO tglulb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Utusan ang mga bayan ng Israel para magdala sa iyo ng dalisay na langis na hinalo mula sa mga olibo para sa langis ng inyong mga lampara, para laging nasusunog ang mga ito at magbigay ng liwanag. ");
INSERT INTO tglulb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Sa labas ng kurtina bago ang mga tipan ng kautusan sa tolda ng pagpupulong, si Aaron ay dapat tuloy-tuloy, mula gabi hanggang umaga, panatilihing naka-ilaw ang lampara sa harap ni Yahweh. Ito ay laging magiging isang batas sa buong angkan ng iyong mga tao. ");
INSERT INTO tglulb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ang punong pari ang dapat na magpanatiling nakailaw ang mga lampara sa harap ni Yahweh, ang mga lampara sa ilawan ng gintong dalisay. ");
INSERT INTO tglulb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Dapat kang kumuha ng pinong harina at magluluto ng labindalawang tinapay dito. Dapat na maging dalawang ikasampung ephah sa bawat tinapay. ");
INSERT INTO tglulb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Pagkatapos dapat mong ayusin ang mga ito sa dalawang linya, anim sa bawat linya, sa mesa ng gintong dalisay sa harap ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Dapat maglagay ng isang purong insenso sa tabi ng bawat linya ng mga tinapay bilang isang simbolo ng mga tinapay. Susunugin ang insensong ito para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Bawat Araw ng Pamamahinga ang punong pari ang dapat na palaging maglagay ng tinapay sa harap ni Yahweh, sa ngalan ng mga tao ng Israel. Bilang isang tanda ng walang hanggang tipan. ");
INSERT INTO tglulb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ang pag-aalay na ito ay para kay Aaron at ng kanyang mga anak na lalaki. Dapat nilang kainin ito sa isang lugar na banal, dahil ganap na inilaan ito sa kanya, yamang kinuha ito mula sa mga alay para kay Yahweh na gawa sa apoy.” ");
INSERT INTO tglulb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ngayon nangyari na ang anak na lalaki ng isang babaeng Israelita, na ang ama ay isang taga-Ehipto, sumama sa mga bayan ng Israel. Itong anak na lalaki ng isang babaeng Israelita ay nakipag-away sa isang lalaking Israelita sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ang anak na lalaki ng babaeng Israelita ay nilapastangan ang pangalan ni Yahweh at nilait ang Diyos, kaya dinala siya ng mga tao kay Moises. Ang pangalan ng kanyang ina ay Shelomith, ang anak na babae ni Dibri, mula sa lipi ni Dan. ");
INSERT INTO tglulb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ikinulong siya hanggang ang hatol ni Yahweh ay ipahayag sa kanilang pasya. ");
INSERT INTO tglulb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Pagkatapos kinausap ni Yahweh si Moises, sinabi, ");
INSERT INTO tglulb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Dalhin sa labas ng kampo ang taong nilait ang Diyos. Lahat ng nakarinig sa kaniya ay dapat ipatong ang kanilang kamay sa kanyang ulo, at pagkatapos dapat siyang batuhin ng buong kapulungan. ");
INSERT INTO tglulb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Dapat mong ipaliwanag sa mga tao ng Israel at sabihin, 'Sinumang lumait sa kaniyang Diyos ay dapat dalhin ang kaniyang pagkakasala. ");
INSERT INTO tglulb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Siya na nilapastanganan ang pangalan ni Yahweh ay tiyak na malalagay sa kamatayan. Lahat ng kapulungan ay tiyak na dapat siyang batuhin, kahit pa nga siya ay isang dayuhan o isang dayuhang Israelita. Kung sinuman ang lumapastangan sa pangalan ni Yahweh, dapat siyang malagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","At ang sinomang pumatay ng isang tao ay tiyak na dapat ilagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Siya na pumatay ng hayop ng iba ay dapat bayaran ito, buhay sa buhay. ");
INSERT INTO tglulb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Kapag sinugatan ng isang tao ang kaniyang kapit-bahay, dapat din gawin sa kaniya ang ginawa niya sa kanyang kapit-bahay: ");
INSERT INTO tglulb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","bali sa bali, mata sa mata, ngipin sa ngipin. Bilang siya ay nakagawa ng pinsala sa isang tao, iyon din ang dapat gawin sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Sinuman ang pumatay ng isang hayop ay dapat itong bayaran, at sinuman ang pumatay ng isang tao ay dapat malagay sa kamatayan. ");
INSERT INTO tglulb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Dapat kang magkaroon ng magkatulad na batas para sa kapwa dayuhan at dayuhang Israelita, dahil ako si Yahweh na inyong Diyos.'” ");
INSERT INTO tglulb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Kaya kinausap ni Moises ang mga tao ng Israel, at dinala ng mga tao ang lalaki sa labas ng kampo, na siyang lumait kay Yahweh. Binato nila siya ng mga bato. Sinunod ng mga tao ng Israel ang utos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Nakipag-usap si Yahweh kay Moises sa Bundok Sinai, na sinasabing, ");
INSERT INTO tglulb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Makipag-usap ka sa mga tao ng Israel at sabihin sa kanila, 'Kapag dumating kayo sa lupaing ibibigay ko sa inyo, sa gayon dapat na magpatupad ang lupain ng isang Araw ng Pamamahinga para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Dapat ninyong taniman ang inyong bukid sa loob ng anim na taon, at sa loob ng anim na taon dapat ninyong putulan ang ubasan at tipunin ang mga bunga. ");
INSERT INTO tglulb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Subalit sa ikapitong taon, isang Araw ng Pamamahinga ng taimtim na pahinga para sa lupa ang dapat ipatupad, isang Araw ng Pamamahinga para kay Yahweh. Hindi ninyo dapat taniman ang inyong bukid o putulan ang inyong ubasan. ");
INSERT INTO tglulb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Hindi kayo dapat magsagawa ng isinaayos na pag-aani ng anumang tumutubong mag-isa, at hindi kayo dapat magsagawa ng isinaayos na pag-aani ng anumang ubas na tumutubo sa mga hindi pinutulang baging ninyo. Ito ay magiging isang taon ng taimtim na pahinga para sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Anuman ang tumubo sa hindi sinakang lupa sa panahon ng taon ng Araw ng Pamamahinga ay magiging pagkain para sa inyo. Kayo, ang inyong mga lalaki at babaeng lingkod, ang inyong mga upahang lingkod at ang mga dayuhang naninirahan kasama ninyo ay maaaring magtipon ng pagkain. ");
INSERT INTO tglulb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","At ang inyong mga alagang hayop at saka mga mababangis na hayop ay maaaring kainin anuman ang tumubo sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Dapat kayong bumilang ng pitong taon ng mga Araw ng Pamamahinga, iyon ay, pitong ulit na pitong taon, upang magkaroon ng pitong mga Araw ng Pamamahingang taon, na binubuo ng apatnapu't siyam na taon. ");
INSERT INTO tglulb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Pagkatapos dapat kayong umihip ng maingay na trumpeta sa lahat ng dako sa ikasampung araw ng ikapitong buwan. Sa Araw ng Pagbabayad ng Kasalanan dapat kayong umihip ng isang trumpeta sa kabuuan ng lahat ng inyong lupain. ");
INSERT INTO tglulb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Dapat ninyong italaga ang ikalimampung taon kay Yahweh at magpahayag ng kalayaan sa buong lupain para sa lahat ng naninirahan dito. Magiging isang Paglaya ito para sa inyo, kung saan dapat ibalik ang mga ari-arian at mga alipin sa kanilang mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ang ikalimampung taon ay magiging isang Paglaya para sa inyo. Hindi kayo dapat magtanim o gumawa ng isinaayos na pag-aani. Kainin anuman ang tumutubong mag-isa, at tipunin ang mga ubas na tumutubo sa hindi pinutulang mga baging. ");
INSERT INTO tglulb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Dahil isang Paglaya iyon, na magiging banal para sa inyo. Dapat ninyong kainin ang bungang tumutubong mag-isa mula sa kabukiran. ");
INSERT INTO tglulb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Dapat ninyong ibalik ang bawat isa sa kanyang sariling ari-arian sa Taon ng Paglaya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Kung magbebenta kayo ng anumang lupa sa inyong kapit-bahay o bibili ng anumang lupa mula sa inyong kapit-bahay, hindi ninyo dapat dayain o gawan ng masama ang isa't isa. ");
INSERT INTO tglulb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kung bibili kayo ng lupa mula sa inyong kapit-bahay, isaalang-alang ang bilang ng mga taon at mga pananim na maaaring anihin hanggang sa susunod na Paglaya. Dapat din iyong isaalang-alang ng inyong kapit-bahay na nagbebenta ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ang higit na malaking bilang ng taon hanggang sa susunod na Paglaya ay magdaragdag sa halaga ng lupa, at ang higit na maliit na bilang ng taon hanggang sa susunod na Paglaya ay magbabawas sa halaga, dahil ang bilang ng pag-aani na idudulot ng lupa para sa bagong may-ari ay may kaugnayan sa bilang ng mga taon bago ang susunod na Paglaya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Hindi ninyo dapat dayain o gawan ng masama ang isa't isa; sa halip, dapat ninyong parangalan ang inyong Diyos, sapagkat ako ay Yahweh, na inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Kaya nga dapat ninyong sundin ang aking mga kautusan, ingatan ang aking mga batas, at tuparin ang mga iyon. Sa gayon ligtas kayong mamumuhay sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Mamumunga ang lupain, at kakain kayo hanggang mabusog at ligtas na mamumuhay roon. ");
INSERT INTO tglulb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Maaaring sabihin ninyo, “Anong kakainin namin sa panahon ng ikapitong taon? Masdan, hindi kami makakapagtanim o makakapagtipon ng bunga.” ");
INSERT INTO tglulb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Iuutos kong dumating sa inyo ang aking pagpapala sa ikaanim na taon, at magbibigay ito ng aning sapat para sa tatlong taon. ");
INSERT INTO tglulb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Magtatanim kayo sa ikawalong taon at patuloy na kakain mula sa bunga ng mga nakaraang taon at mga itinagong pagkain. Hanggang sa dumating ang ani ng ikasiyam na taon, makakakain kayo mula sa mga pagkaing itinago sa mga nakaraang taon. ");
INSERT INTO tglulb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Hindi dapat ipagbili ang lupa sa bagong permanenteng may-ari, dahil sa akin ang lupa. Kayong lahat ay mga dayuhan at pansamantalang naninirahan sa aking lupain. ");
INSERT INTO tglulb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Dapat ninyong sundin ang karapatan ng pagtubos para sa lahat ng lupang makamtan ninyo; dapat ninyong payagang muling bilhin ang lupa ng pamilya ng kung kanino ninyo ito binili. ");
INSERT INTO tglulb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Kung naging mahirap ang kapwa ninyo Israelita at dahil doon ipinagbili ang ilan sa kanyang ari-arian, sa gayon maaaring bilhin muli ng pinakamalapit niyang kamag-anak ang ari-ariang ipinagbili niya sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kung ang isang tao ay walang kamag-anak para tumubos ng kanyang ari-arian, subalit kung umunlad siya at may kakayahang tubusin ito, ");
INSERT INTO tglulb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","sa gayon maaari niyang kuwentahin ang mga taon mula nang ipinagbili ang lupa at bayaran ang nalalabi sa tao na kung kanino niya ito ipinagbili. Pagkatapos maaari siyang bumalik sa kanyang sariling ari-arian. ");
INSERT INTO tglulb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Subalit kung hindi niya kayang bawiin ang lupa para sa kanyang sarili, sa gayon mananatili ang lupang ipinagbili niya sa pagmamay-ari ng bumili nito hanggang sa Taon ng Paglaya. Sa Taon ng Paglaya, ibabalik ang lupa sa taong nagbenta nito, at babalik ang tunay na may-ari sa kanyang ari-arian. ");
INSERT INTO tglulb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kung ang isang tao ay magbebenta ng isang bahay sa isang pinaderang siyudad, sa gayon maaari niya itong bilhin muli sa loob ng isang buong taon matapos na ipagbili ito. Sa loob na isang buong taon magkakaroon siya ng karapatan ng pagtubos. ");
INSERT INTO tglulb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kung hindi matubos ang bahay sa loob ng isang buong taon, sa gayon ang bahay na nasa pinaderang siyudad ay magiging permanenteng ari-arian ng taong bumili nito, sa kabuuan ng mga salinhlahi ng kanyang mga kaapu-apuhan. Hindi na ibabalik ang bahay na iyon sa Paglaya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Subalit ang mga bahay sa mga bayan na walang pader sa palibot ng mga iyon ay magiging ari-ariang may kaugnayan sa mga bukirin ng bansa. Maaaring bilhin muli ang mga iyon, at dapat ibalik ang mga iyon sa panahon ng paglaya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Gayunman, ang mga bahay na pagmamay-ari ng mga Levita sa kanilang mga siyudad ay maaaring tubusin sa anumang oras. ");
INSERT INTO tglulb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kung hindi tutubusin ng isa sa mga Levita ang bahay na ipinagbili niya, sa gayon dapat ibalik ang bahay na ipinagbili sa siyudad kung saan ito naroon sa Paglaya, dahil ang mga bahay sa mga siyudad ng mga Levita ay ari-arian nila sa gitna ng mga tao ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Subalit hindi maaring ipagbili ang mga bukid sa palibot ng kanilang mga siyudad dahil ang mga iyon ay permanenteng ari-arian ng mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Kung naging mahirap ang kapwa kababayan ninyo, kung kaya hindi na niya kayang itaguyod ang kanyang sarili, sa gayon dapat ninyo siyang tulungan tulad ng tutulungan ang isang dayuhan o sino pa mang naninirahan bilang tagalabas na kasama ninyo. ");
INSERT INTO tglulb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Huwag siyang singilin ng tubo o subukang kumita mula sa kanya sa anumang paraan, ngunit parangalan ang inyong Diyos upang ang kapatid ninyo ay makapanatiling namumuhay kasama ninyo. ");
INSERT INTO tglulb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Hindi ninyo siya dapat bigyan ng pautang na pera at patawan ng tubo, ni pagbilhan ng iyong pagkain upang kumita. ");
INSERT INTO tglulb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ako ay Yahweh na inyong Diyos na naglabas sa inyo mula sa lupain ng Ehipto, upang ibigay ko sa inyo ang lupain ng Canaan, at upang ako ay maging Diyos ninyo. ");
INSERT INTO tglulb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Kung maging mahirap ang kapwa kababayan ninyo at ipagbili ang kanyang sarili sa inyo, hindi ninyo siya dapat pagtrabahuhin tulad ng isang alipin. ");
INSERT INTO tglulb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ituring siyang isang upahang lingkod. Dapat siyang maging tulad ng isang taong pansamantalang naninirahan kasama ninyo. Maglilingkod siya sa inyo hanggang sa Taon ng Paglaya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Pagkatapos aalis siya mula sa inyo, siya at ang kanyang mga anak na kasama niya, at babalik siya sa kanyang sariling pamilya at sa ari-arian ng kanyang ama. ");
INSERT INTO tglulb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Sapagkat mga lingkod ko sila na inilabas ko mula sa lupain ng Ehipto. Hindi sila ipagbibili bilang mga alipin. ");
INSERT INTO tglulb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Hindi ninyo sila dapat pamunuan nang malupit, subalit dapat ninyong parangalan ang inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Para sa inyong mga aliping lalaki at babae, na maaari ninyong makuha mula sa mga bansang naninirahan sa palibot ninyo, maaari kayong bumili ng mga alipin mula sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Maaari rin kayong bumili ng mga alipin sa mga dayuhang naninirahan kasama ninyo, iyon ay, mula sa kanilang mga pamilyang kasama ninyo, mga batang ipinanganak sa inyong lupain. Maaari ninyo silang maging ari-arian. ");
INSERT INTO tglulb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Maaari ninyong ibigay ang ganyang mga alipin bilang isang pamana sa inyong mga anak na kasunod ninyo, para panghawakan bilang ari-arian. Mula sa kanila ay maaari kayong palaging bumili ng inyong mga alipin, ngunit hindi ninyo dapat pamunuan ang mga tao ng Israel nang may pagmamalupit. ");
INSERT INTO tglulb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Kung isang dayuhan o isang taong pansamantalang naninirahan kasama ninyo ang naging mayaman, at kung isa sa mga kapwa ninyo Israelita ang naging mahirap at ipagbili ang kanyang sarili sa dayuhang iyon, o sa isang tao sa pamilya ng isang dayuhan, ");
INSERT INTO tglulb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","matapos na ang inyong kapwa Israelita ay nabili, maaari siyang muling bilhin. Isang tao sa kanyang pamilya ang maaaring tumubos sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Marahil ang tiyuhin ng tao o anak ng kanyang tiyuhin ang siyang tutubos sa kanya, o sinumang malapit na kamag-anak niya mula sa kanyang pamilya. O, kung naging maunlad siya, maaari niyang tubusin ang kanyang sarili. ");
INSERT INTO tglulb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Dapat siyang makipagtawaran sa taong bumili sa kanya; dapat niyang bilangin ang mga taon mula sa taong ipinagbili niya ang kanyang sarili sa nakabili sa kanya hanggang sa Taon ng Paglaya. Ang halaga ng kanyang katubusan ay dapat kuwentahin alinsunod sa halagang ibabayad sa isang upahang lingkod, para sa bilang ng mga taon na maaari siyang patuloy na magtrabaho para sa bumili sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kung may maraming taon pang natitira hanggang sa Paglaya, dapat siyang magbalik bayad bilang halaga para sa kanyang katubusan ng isang katumbas na dami ng perang angkop sa bilang ng mga taong iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kung may ilang taon na lamang tungo sa Taon ng Paglaya, sa gayon ay dapat siyang makipagtawaran sa nakabili sa kanya upang ipakita ang bilang ng mga taong natitira bago ang Paglaya, at dapat siyang magbayad para sa kanyang katubusan alinsunod sa bilang ng mga taon. ");
INSERT INTO tglulb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Dapat siyang ituring bilang isang taong inuupahan taun-taon. Dapat ninyong tiyaking hindi siya mapagmalupitan. ");
INSERT INTO tglulb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Kung hindi siya matutubos sa mga paraang ito, dapat siyang maglingkod hanggang sa Taon ng Paglaya, siya at ang kanyang mga anak na kasama niya. ");
INSERT INTO tglulb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Para sa akin ang mga tao ng Israel ay mga lingkod. Mga lingkod ko sila na inilabas ko mula sa lupain ng Ehipto. Ako ay Yahweh na inyong Diyos.'” ");
INSERT INTO tglulb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Dapat huwag kayong gumawa ng mga rebulto, ni hindi kayo magtatayo ng mga nililok na mga larawan o isang sagradong batong haligi at dapat huwag kayong maglagay sa inyong lupain ng anumang hinulma na imaheng bato na inyong yuyukudan, sapagkat ako si Yahweh na inyong Dios. ");
INSERT INTO tglulb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Dapat ninyong isagawa ang aking mga Araw ng Pamamahinga at parangalan ang aking santuwaryo. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Kung lalakad kayo sa aking mga batas at isaisip ang aking mga utos at susundin ang mga ito, ");
INSERT INTO tglulb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Sa gayon bibigyan ko kayo ng ulan sa kapanahunan nito; mapapakinabangan ang lupain at magbibigay ang mga punong kahoy sa bukid ng kanilang mga bunga. ");
INSERT INTO tglulb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Magpapatuloy ang inyong paggiik hanggang sa panahon ng aning ubas at aabot ang aning ubas hanggang sa panahon ng pagtatanim. Kakainin ninyo ang inyong tinapay ng sagana at mamumuhay ng ligtas sa ginawa ninyong tahanan sa lupain; ");
INSERT INTO tglulb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Magbibigay ako ng kapayapaan sa lupain; hihiga kayo ng walang kahit na anong kinatatakutan. Aalisin ko ang mga mababangis na hayop mula sa lupain at hindi dadaan ang espada sa inyong lupain. ");
INSERT INTO tglulb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Hahabulin ninyo ang inyong mga kaaway at babagsak sila sa inyong harapan sa pamamagitan ng espada. ");
INSERT INTO tglulb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Hahabulin ng lima sa inyo ang isang daan at hahabulin ng isang daan sa inyo ang sampung libo; babagsak ang inyong mga kaaway sa inyong harapan sa pamamagitan ng espada. ");
INSERT INTO tglulb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Titingnan ko kayo ng may pagkampi at gagawin ko kayong mabunga at pararamihin kayo; Itatatag ko ang aking tipan sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Kakain kayo ng pagkaing inimbak ng mahabang panahon. Kakailanganin ninyong ilabas ang inyong inimbak na pagkain dahil kakailanganin ninyo ng lugar para sa bagong ani. ");
INSERT INTO tglulb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ilalagay ko ang aking tabernakulo sa inyo at hindi ko kayo itatakwil. ");
INSERT INTO tglulb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Maglalakad ako kasama ninyo, magiging Diyos ninyo at magiging bayan ko kayo. ");
INSERT INTO tglulb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ako si Yahweh na inyong Dios na nagdala sa inyo palabas mula sa lupain ng Ehipto, nang sa ganoon hindi na nila kayo magiging mga alipin. Winasak ko ang mga rehas ng inyong yugo at pinalakad kayo ng matuwid. ");
INSERT INTO tglulb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Pero kung hindi kayo makikinig sa akin at hindi sumunod sa lahat ng mga utos na ito, ");
INSERT INTO tglulb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","at kung tatanggihan ninyo ang aking mga kautusan at kung kamumuhian ang aking mga batas, na hindi ninyo susundin ang lahat ng aking mga utos, pero susuwayin ko ang tipan— ");
INSERT INTO tglulb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","—kung gagawin ninyo ang mga bagay na ito, ay gagawin ko ito sa inyo: pahihirapan ko kayo ng katakot-takot, sisirain ang mga mata at unti-unting uubusin ang inyong buhay ng mga sakit at lagnat. Magtatanim kayo ng inyong mga binhi para sa wala, dahil ang inyong mga kaaway ang kakain ng bunga ng mga ito. ");
INSERT INTO tglulb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Tatalikuran ko kayo at dadaigin kayo ng inyong mga kaaway. Pamumunuan kayo ng mga taong galit sa inyo at tatakas kayo kahit walang humahabol sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Kung hindi kayo makikinig sa aking mga utos, ay paparusahan ko kayo ng pitong beses ang tindi para sa inyong mga kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Babaliin ko ang inyong pinagmamalaking kapangyarihan. Gagawin ko ang langit sa inyong itaas na parang bakal at ang inyong lupain na parang tanso. ");
INSERT INTO tglulb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mauubos ang inyong lakas para sa wala, sapagkat hindi magkakaroon ang inyong lupa ng ani at hindi mamumunga ang inyong mga punong kahoy na nasa lupain. ");
INSERT INTO tglulb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Kung maglalakad kayo laban sa akin at hindi makikinig sa akin, magdadala ako sa inyo ng pitong beses pang palo na katumbas ng inyong mga kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Magpapadala ako ng mapanganib na mga hayop laban sa inyo na magnanakaw ng inyong mga anak, lilipol ng inyong mga baka at magpapakaunti ng inyong bilang. Kaya magiging pinabayaan ang inyong mga daanan. ");
INSERT INTO tglulb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Kung sa lahat ng ito, hindi niyo pa rin tinatanggap ang aking pagtuturo, sa halip nagpatuloy na lumakad laban sa akin, ");
INSERT INTO tglulb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Pagkatapos lalakad din ako laban sa inyo. Ako mismo ang magpapatama sa inyo ng pitong beses na palo para sa inyong mga kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Magdadala ako ng espada sa inyo na gagawa ng paghihiganti dahil sa pagsuway sa aking mga utos. Maiipon kayo sa loob ng inyong mga siyudad at magpapadala ako ng mga sakit sa inyo doon at matatalo kayo sa pamamagitan ng kapangyarihan ng inyong kaaway. ");
INSERT INTO tglulb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kapag puputulin ko ang tustos ng inyong pagkain, sampung mga kababaihan ang makakaluto ng inyong tinapay sa isang hurnohan, at ipamamahagi nila ang inyong tinapay ayon sa timbang. Kakain kayo ngunit hindi mabubusog. ");
INSERT INTO tglulb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Kung hindi kayo makikinig sa akin kahit pa na may mga ganitong bagay, at sa halip patuloy na lumakad laban sa akin, ");
INSERT INTO tglulb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ay lalakad ako laban sa inyo sa galit at paparusahan ko kayo ng kahit pitong beses pang ulit na katumbas ng inyong mga kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Kakainin ninyo ang laman ng inyong mga anak na lalaki; kakainin ninyo ang laman ng inyong mga anak na babae. ");
INSERT INTO tglulb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Gigibain ko ang inyong mga altar, puputulin ko ang inyong mga altar ng insenso, at itatapon ang inyong mga bangkay sa ibabaw ng bangkay ng inyong mga diyos-diyosan, at ako mismo, kasusuklaman kayo. ");
INSERT INTO tglulb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Gagawin kong sira-sirang lugar ang inyong mga lungsod at sisirain ang inyong mga santuwaryo. Hindi ako malulugod sa samyo ng inyong mga handog. ");
INSERT INTO tglulb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Sisirain ko ang lupain. Sobrang mabibigla ang inyong mga kaaway na naninirahan doon sa pagkakasira. ");
INSERT INTO tglulb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ikakalat ko kayo sa mga bansa, at bubunutin ko ang aking espada at susundan kayo. Pababayaan ang inyong lupain at magiging sira-sira inyong mga lungsod. ");
INSERT INTO tglulb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Pagkatapos magsasaya ang lupain sa mga Araw ng Pamamahinga nito hangga't nananatili itong pinabayaan at nasa lupain kayo ng inyong mga kaaway. Sa panahong iyon, mamamahinga ang lupain at magpapakasaya sa mga Araw ng Pamamahinga nito. ");
INSERT INTO tglulb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Hangga't nananatili itong pinabayaan, maangkin nito ang pamamahinga, pamamahinga na hindi nito naangkin sa inyong mga Araw ng Pamamahinga, noong nanirahan kayo sa lupaing iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","At para doon sa mga natira sa inyo sa mga lupain ng mga kaaway, magpapadala ako ng takot sa inyong mga puso na kahit pa na sa tunog ng isang dahon na hinihipan sa hangin, magugulantang kayo at tatakas kayo na parang tinatakasan ninyo ang espada. Babagsak kayo kahit na wala namang humahabol sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Madadaganan ninyo ang isa't isa na parang tinatakbuhan ninyo ang espada, kahit na wala namang humahabol sa inyo. Hindi kayo magkakaroon ng kapangyarihan na tumayo sa harap ng inyong mga kaaway. ");
INSERT INTO tglulb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Maglalaho kayo sa mga nabibilang na mga bansa, at ang lupain mismo ng inyong mga kaaway ang lalamon sa inyo. ");
INSERT INTO tglulb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","'Yung mga natitira sa inyo, mabubulok sa kanilang mga kasalanan doon sa mga lupain ng inyong mga kaaway, at dahil sa kasalanan ng kanilang mga ama, mabubulok din sila. ");
INSERT INTO tglulb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ngunit kung aamin sila sa kanilang mga kasalanan at sa kasalanan ng kanilang mga ama, at sa kanilang kataksilan na pagiging hindi tapat sa akin at sa kanilang paglalakad laban sa akin— ");
INSERT INTO tglulb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","na nagdulot sa akin upang talikuran sila at ibigay sila sa lupain ng kanilang mga kaaway—kung magpapakumbaba ang kanilang hindi pa tuli na mga puso, at kung tatanggapin nila ang kaparusahan ng kanilang mga kasalanan, ");
INSERT INTO tglulb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ay isasaisip ko ang aking kasunduan kay Jacob, aking kasunduan kay Isaac, at ang aking kasunduan kay Abraham; gayun din, na isasaisip ko ang lupain. ");
INSERT INTO tglulb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Pinabayaan nila ang lupain, nang sa ikalugod nito ang mga Araw ng Pamamahinga hangga't nananatili itong pinabayaan nila. Kinailangan nilang pagbayaran ang kaparusahan para sa kanilang mga kasalanan sapagkat sila mismo ang tumanggi sa aking mga iniatas at namuhi sa aking mga batas. ");
INSERT INTO tglulb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Pero sa kabila ng lahat ng ito, kapag nasa lupain sila ng kanilang mga kaaway, hindi ko sila kamumuhian na tuluyan silang lipulin at hindi puputulin ang aking tipan sa kanila, sapagkat ako si Yahweh na kanilang Diyos. ");
INSERT INTO tglulb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Pero para sa kanilang kapakanan isasaisip ko ang tipan sa kanilang mga ninuno, na siyang aking dinala palabas mula sa lupain ng Ehipto na nasaksihan ng mga bansa, upang ako ay maging Diyos nila. Ako si Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ito ang mga utos, kautusan, at mga batas na ginawa ni Yahweh sa pagitan ng kanyang sarili at ng mga tao ng Israel sa Bundok Sinai sa pamamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Nangusap si Yahweh kay Moises at sinabi, ");
INSERT INTO tglulb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Magsalita ka sa mga tao ng Israel at sabihin sa kanila, 'Kapag gagawa ang isang tao ng isang natatanging panata na nangangailangang gumamit siya ng isang pamantayang halaga ng isang tao na ilalaan niya kay Yahweh, gamitin ang sumusunod na mga halaga. ");
INSERT INTO tglulb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ang inyong pamantayang halaga para sa isang lalaki mula dalawampu hanggang animnapung taong gulang ay dapat limampung siklo ng pilak, batay sa siklo ng santuwaryo. ");
INSERT INTO tglulb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ang inyong pamantayang halaga para sa isang babae sa parehong gulang ay dapat tatlumpung siklo. ");
INSERT INTO tglulb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Mula limang taon hanggang dalawampung taong gulang ang inyong pamantayang halaga ay dapat dalawampung siklo para sa lalaki, at sampung siklo para sa babae. ");
INSERT INTO tglulb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Mula isang buwang gulang hanggang limang taon ang inyong pamantayang halaga ay dapat limang siklo ng pilak para sa isang lalaki, at tatlong siklo ng pilak para sa isang babae. ");
INSERT INTO tglulb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Mula animnapung taong gulang pataas ang inyong pamantayang halaga para sa isang lalaki ay dapat labin limang siklo, at sampung siklo para sa isang babae. ");
INSERT INTO tglulb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Pero kung ang taong gumawa ng panata ay hindi makabayad ng pamantayang halaga, kung gayon dapat iharap sa pari ang taong ibinigay, at bibigyang halaga ng pari ang taong iyon sa pamamagitan ng halagang makakaya ng isang gumagawa ng panata. ");
INSERT INTO tglulb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Kung gusto ng isang tao na mag-alay ng isang hayop kay Yahweh, at kung tatanggapin ito ni Yahweh, sa gayon ang hayop na iyon ay ilalaan sa kanya. ");
INSERT INTO tglulb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Hindi dapat baguhin o palitan ng isang tao ang isang hayop na iyon, isang mabuti para sa isang masama o isang masama para sa isang mabuti. Kung gagawin niyang baguhin ang isa para sa iba, sa gayon parehong mga hayop at ang isa na ipinagpalit ay magiging banal. ");
INSERT INTO tglulb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Gayunman, kung ang panunumpa ng isang tao na ibigay kay Yahweh ay totoong marumi, kung kaya hindi ito tatanggapin ni Yahweh, sa gayon dapat dalhin ng tao ang hayop sa isang pari. ");
INSERT INTO tglulb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Bibigyang halaga ito ng pari, sa pamamagitan ng halaga ng hayop sa pamilihan. Anuman ang halaga na ibinigay ng pari sa hayop, iyon ang magiging halaga nito. ");
INSERT INTO tglulb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","At kung nais ng may-ari na tubusin ito, ang ikalima ng halaga nito ay idadagdag sa pantubos na presyo nito. ");
INSERT INTO tglulb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Kung ninanais ng isang tao na ilaan ang kaniyang bahay para ibukod para kay Yahweh, sa gayon tatantiyahin ng pari ang halaga nito. Anuman ang ibibigay na halaga ng pari dito, iyon ang magiging halaga nito. ");
INSERT INTO tglulb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Pero kung ilalaan ng may-ari ang kaniyang tahanan at katagalan ninais na tubusin ito, ang ikalima ng halaga nito ay idadagdag sa pantubos na presyo, at pagkatapos magiging kaniyang muli ang bahay. ");
INSERT INTO tglulb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Kung ninanais ng isang tao na ilaan kay Yahweh ang ilan sa kaniyang lupa, sa gayon ang pagtataya ng halaga nito ay gagawin alinsunod sa halaga ng binhing kinakailangan upang itanim dito. Magkakahalaga ng limampung siklo ng pilak ang isang homer ng sebada. ");
INSERT INTO tglulb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kung ilalaan niya ang kaniyang bukid sa panahon ng Taon ng Paglaya, ang tinatayang halaga ay mananatili. ");
INSERT INTO tglulb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pero kung ilalaan niya ang kaniyang bukid pagkatapos ng Paglaya, sa gayon dapat kwentahin ng pari ang halaga ng lupa ayon sa bilang ng mga taon na natitira hanggang sa susunod na Taon ng Paglaya, at dapat bawasan ang tinatayang halaga. ");
INSERT INTO tglulb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kung ang taong naglaan ng bukid ay nagnanais na tubusin ito, sa gayon dapat siyang magdagdag ng ikalima sa tinatayang halaga, at ito ay magiging kaniyang muli. ");
INSERT INTO tglulb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kung hindi niya tutubusin ang bukid, o kung ipagbili niya ang bukid sa ibang tao, hindi na ito matutubos kailanman. ");
INSERT INTO tglulb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Sa halip, ang bukid, kapag ibinalik ito sa Paglaya, magiging isang banal na regalo kay Yahweh, katulad ng bukid na ganap na ibinigay kay Yahweh. Mabibilang ito sa pari. ");
INSERT INTO tglulb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Kung ilalaan ng isang tao kay Yahweh ang bukid na kanyang binili, pero ang bukid na iyon ay hindi bahagi ng lupain ng kanyang pamilya, ");
INSERT INTO tglulb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","pagkatapos aalamin ng pari ang tinatayang halaga hanggang sa Taon ng Paglaya, at dapat bayaran ng tao ang halaga sa araw na iyon bilang isang banal na regalo kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Sa Taon ng Paglaya, ibabalik ang bukid sa tao kung kanino ito binili, sa may-ari ng lupa. ");
INSERT INTO tglulb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Dapat na itakda ang lahat ng mga tinatayang mga halaga ayon sa timbang ng santuwaryong siklo. Dalawampung gera ang dapat na katumbas ng isang siklo. ");
INSERT INTO tglulb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Pero ang unang anak ng mga hayop ay nabibilang na kay Yahweh at walang tao ang maaaring maglaan nito—maging lalaking baka o tupa—sapagkat ito ay nabibilang kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kung ito ay isang maruming hayop, maaaring bilhin itong muli ng may-ari sa tinatayang halaga, at dapat na idagdag ang ikalima sa halagang iyon. Kung hindi tinubos ang hayop, sa gayon ipagbibili ito sa itinakdang halaga. ");
INSERT INTO tglulb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Gayunman, walang taong maglalaan kay Yahweh mula sa anumang bagay na mayroon siya, maging tao o hayop, o lupa ng kanyang pamilya, na maaaring ipagbili o tinubos. Bawat inilaan na bagay ay banal kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Walang pantubos ang maaaring ibayad para sa taong ibinukod para patayin. Dapat patayin ang taong iyon. ");
INSERT INTO tglulb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Lahat ng ikapu ng lupain, maging tumubong butil sa lupa o bunga mula sa mga puno, ay kay Yahweh. Banal ito kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kung tutubusin ng isang tao ang alinman sa kanyang ikapu, dapat siyang magdagdag ng ikalima sa halaga nito. ");
INSERT INTO tglulb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Para sa lahat ng ikapu ng grupo ng mga hayop o ang kawan, anuman ang dumaan sa ilalim ng tungkod ng pastol, dapat ilaan kay Yahweh ang ikasampu. ");
INSERT INTO tglulb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Hindi dapat humanap ang pastol ng higit na mabuti o higit na masamang mga hayop, at hindi niya maaaring ipagpalit ang isa para sa iba. Kung papalitan man niya ito, magiging banal ang parehong mga hayop at iyon na kung saan ito ipinagpalit. Hindi ito matutubos.”' ");
INSERT INTO tglulb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ito ang mga utos na ibinigay ni Yahweh kay Moises sa Bundok Sinai para sa mga bayan ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Nagsalita si Yahweh kay Moises sa tolda ng pagpupulong sa ilang ng Sinai. Nangyari ito sa unang araw ng ikalawang buwan sa loob ng ikalawang taon matapos na makalabas ang mga tao ng Israel mula sa lupain ng Ehipto. Sinabi ni Yahweh, ");
INSERT INTO tglulb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Magsagawa ka ng isang pagbibilang sa lahat ng kalalakihan ng Israel sa bawat angkan, sa mga pamilya ng kanilang mga ama. Bilangin mo sila ayon sa kanilang mga pangalan. Bilangin mo ang bawat lalaki, ang bawat lalaking ");
INSERT INTO tglulb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","dalawampung taong gulang pataas. Bilangin mo ang lahat ng maaaring makipaglaban bilang mga kawal para sa Israel. Dapat ninyong itala ni Aaron ang bilang ng mga kalalakihan sa kanilang armadong mga grupo. ");
INSERT INTO tglulb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ang isang lalaki mula sa bawat tribu, ang isang ulo ng angkan ay dapat maglingkod sa iyo bilang pinuno ng tribu. Dapat pangunahan ng bawat pinuno ang mga kalalakihang makikipaglaban para sa kaniyang tribu. ");
INSERT INTO tglulb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ito ang mga pangalan ng mga pinunong dapat makipaglaban na kasama mo: Mula sa tribu ni Ruben, si Elizur na anak na lalaki ni Sedeur; ");
INSERT INTO tglulb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","sa tribu ni Simeon, si Selumiel na anak na lalaki ni Zurisaddai; ");
INSERT INTO tglulb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","mula sa tribu ni Juda, si Naason na anak na lalaki ni Aminadab; ");
INSERT INTO tglulb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","mula sa tribu ni Isacar, si Natanael na anak na lalaki ni Zuar; ");
INSERT INTO tglulb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","mula sa tribu ni Zebulon, si Eliab na anak na lalaki ni Helon; ");
INSERT INTO tglulb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","mula sa tribu ni Efraim na anak na lalaki ni Jose ay si Elisama na anak na lalaki ni Ammiud; mula sa tribu ni Manases, si Gamaliel na anak na lalaki ni Pedasur; ");
INSERT INTO tglulb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","mula sa tribu ni Benjamin na anak na lalaki ni Jose ay si Abidan na anak na lalaki ni Gideon; ");
INSERT INTO tglulb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","mula sa tribu ni Dan, si Ahiezer na anak na lalaki ni Ammisaddai; ");
INSERT INTO tglulb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","mula sa tribu ni Aser, si Pagiel na anak na lalaki ni Okran; ");
INSERT INTO tglulb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","mula sa tribu ni Gad, si Eliasaf na anak na lalaki ni Deuel; ");
INSERT INTO tglulb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","at mula sa tribu ni Neftali, si Ahira na anak na lalaki ni Enan. ");
INSERT INTO tglulb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ito ang mga lalaking pinili mula sa mga tao. Pinangunahan nila ang mga tribu ng kanilang mga ninuno. Sila ang mga pinuno ng mga angkan sa Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ang mga lalaking ito ay kinuha nina Moises at Aaron, na kanilang naitala sa pamamagitan ng pangalan, ");
INSERT INTO tglulb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","at sa tabi ng mga lalaking ito, tinipon nila ang lahat ng mga kalalakihan ng Israel sa unang araw ng ikalawang buwan. At bawat lalaking dalawampung taong gulang pataas ay kinilala ang kaniyang kanunu-nunuan. Dapat niyang pangalanan ang mga angkan at ang mga pamilyang nagmula sa kaniyang mga ninuno. ");
INSERT INTO tglulb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Pagkatapos, itinala ni Moises ang kanilang mga bilang sa ilang ng Sinai, gaya ng inuutos ni Yahweh na kaniyang gawin. ");
INSERT INTO tglulb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Mula sa mga kaapu-apuhan ni Ruben, panganay na anak ni Israel, binilang nila ang lahat ng mga pangalan ng lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","46, 500 na kalalakihan ang nabilang nila mula sa tribu ni Ruben. ");
INSERT INTO tglulb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Mula sa mga kaapu-apuhan ni Simeon ay binilang nila ang lahat ng pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","59, 300 na kalalakihan ang nabilang nila mula sa tribu ni Simeon. ");
INSERT INTO tglulb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Mula sa mga kaapu-apuhan ni Gad ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","45, 650 na kalalakihan ang nabilang nila mula sa tribu ni Gad. ");
INSERT INTO tglulb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Mula sa mga kaapu-apuhan ni Juda ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","74, 600 na kalalakihan ang nabilang nila mula sa tribu ni Juda. ");
INSERT INTO tglulb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Mula sa mga kaapu-apuhan ni Isacar ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","54, 400 na kalalakihan ang nabilang nila mula sa tribu ni Isacar. ");
INSERT INTO tglulb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Mula sa mga kaapu-apuhan ni Zebulon ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","57, 400 na kalalakihan ang nabilang nila mula sa tribu ni Zebulon. ");
INSERT INTO tglulb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Mula sa mga kaapu-apuhan ni Efraim na anak na lalaki Jose ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","40, 500 na kalalakihan ang nabilang nila mula sa tribu ni Efraim. ");
INSERT INTO tglulb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Mula sa mga kaapu-apuhan ni Manases ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","32, 200 na kalalakihan ang nabilang nila mula sa tribu ni Manases. ");
INSERT INTO tglulb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Mula sa mga kaapu-apuhan ni Benjamin ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","35, 400 na kalalakihan ang nabilang nila mula sa tribu ni Benjamin. ");
INSERT INTO tglulb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Mula sa mga kaapu-apuhan ni Dan ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","62, 700 ang nabilang nila mula sa tribu ni Dan. ");
INSERT INTO tglulb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Mula sa mga kaapu-apuhan ni Aser ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41",", 500 na kalalakihan ang nabilang nila mula sa tribu ni Aser. ");
INSERT INTO tglulb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Mula sa mga kaapu-apuhan ni Neftali ay binilang nila ang lahat ng mga pangalan ng bawat lalaking dalawampung taong gulang pataas na kayang pumunta sa digmaan, mula sa mga talaan ng mga angkan ng kanilang ninuno at mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","53, 400 ang nabilang nila mula sa tribu ni Neftali. ");
INSERT INTO tglulb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Binilang nina Moises at Aaron ang lahat ng mga lalaking ito, kasama ang labindalawang kalalakihang namumuno sa labindalawang tribu ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Kaya lahat ng kalalakihan sa Israel mula sa dalawampung taong gulang pataas, lahat nang maaaring makipaglaban sa digmaan ay binilang nila sa bawat kanilang mga pamilya. ");
INSERT INTO tglulb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","603, 550 na kalalakihan ang nabilang nila. ");
INSERT INTO tglulb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ngunit hindi na nila binilang ang mga kalalakihang nagmula kay Levi, ");
INSERT INTO tglulb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","dahil sinabi ni Yahweh kay Moises, ");
INSERT INTO tglulb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Hindi mo dapat bilangin ang tribu ni Levi o isama sila sa kabuuang bilang ng mga tao sa Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Sa halip, italaga mo ang mga Levita na ingatan ang tabernakulo ng toldang tipanan, at ingatan ang buong kagamitan sa loob ng tabernakulo at sa lahat ng kagamitang naroon. Dapat buhatin ng mga Levita ang tabernakulo at dapat nilang dalhin ang mga kagamitan sa nito. Dapat nilang ingatan ang tabernakulo at itayo ang kanilang kampo sa paligid nito. ");
INSERT INTO tglulb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kapag ang tabernakulo ay ililipat na sa ibang lugar, dapat itong ibaba ng mga Levita. Kapag ang tabernakulo ay itatayo, dapat itong itayo ng mga Levita. At ang sinumang dayuhang lalapit sa tabernakulo ay dapat patayin. ");
INSERT INTO tglulb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Kapag itatayo ng mga tao ng Israel ang kanilang mga tolda, dapat itong gawin ng bawat lalaki malapit sa bandilang nabibilang sa kaniyang armadong grupo. ");
INSERT INTO tglulb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Gayon pa man, dapat itayo ng mga Levita ang kanilang mga tolda sa paligid ng tabernakulo ng toldang tipanan upang hindi bumaba ang aking galit sa mga tao ng Israel. Dapat ingatan ng mga Levita ang tabernakulo ng toldang tipanan.” ");
INSERT INTO tglulb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ginawa ng mga tao ng Israel ang lahat ng mga bagay na ito. Ginawa nila ang lahat na inutos ni Yahweh sa pamamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Muling nagsalita si Yahweh kina Moises at Aaron. Kaniyang sinabi, ");
INSERT INTO tglulb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Ang bawat kaapu-apuhan ng mga Israelita ay dapat magkampo sa palibot ng bandila ng kaniyang armadong grupong nabibilang sa hukbo at sa palibot ng pinakamaliit na watawat na palatandaan sa kaniyang tribu. Ang kanilang mga kampo ay dapat nakaharap sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Dapat magkampo ang mga lalaking nabibilang sa kampo ni Juda kasama ang kanilang armadong grupo sa palibot ng bandila ni Juda, sa silangan ng tolda ng pagpupulong, kung saan sumisikat ang araw. Si Naason na anak ni Amminadab ang dapat mamuno sa hukbo ni Juda. ");
INSERT INTO tglulb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ang hukbo ni Juda ay may 74, 600 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Dapat magkampo ang tribu ni Isacar kasunod ni Juda. Si Nethanael na anak ni Zuar ang dapat mamuno sa hukbo ni Isacar. ");
INSERT INTO tglulb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ang hukbo ni Isacar ay may 54, 400 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Dapat magkampo ang tribu ni Zebulon kasunod ng kampo ni Isacar. Si Eliab na anak ni Helon ang dapat mamuno sa hukbo ni Zebulun. ");
INSERT INTO tglulb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ang hukbo ni Zebulon ay may 57, 400 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ang lahat ng hukbong nagkampo kasama si Juda ay 186, 400 na kalalakihan. Sila ang dapat maunang lumabas mula sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Dapat magkampo ang mga hubo sa katimugang bahagi sa palibot ng bandila ni Ruben. Si Elizur na anak ni Shedeur ang dapat mamuno sa hukbo ni Ruben. ");
INSERT INTO tglulb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ang hukbo ni Ruben ay may 46, 500 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Dapat magkampo ang tribu ni Simeon kasunod ni Ruben. Si Selumiel na anak ni Zurisaddai ang dapat mamuno sa hukbo ni Simeon. ");
INSERT INTO tglulb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ang hukbo ni Simeon ay may 59, 300 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Sumunod ang tribu ni Gad. Si Eliasaf na anak ni Deuel ang dapat mamuno sa hukbo ni Gad. ");
INSERT INTO tglulb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ang hukbo ni Gad ay may 45, 650 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ang lahat ng mga hukbong dapat magkampong kasama ni Ruben ay may bilang na 151, 450 na kalalakihan. Sila ang dapat pangalawang lumabas mula sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Susunod, dapat lumabas mula sa kampo ang tolda ng pagpupulong kasama ng mga Levita sa gitna ng lahat ng kampo. Dapat lalabas sila mula sa kampo sa parehong pagkakaayos gaya ng kanilang pagpasok sa loob ng kampo. Ang bawat lalaki ay dapat nasa kaniyang kinalalagyan, sa tabi ng kaniyang bandila. ");
INSERT INTO tglulb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Dapat magkampo ang hukbo ng Efraim sa dakong kanluran ng tolda ng pagpupulong. Si Elishama na anak ni Ammiud ang dapat mamuno sa hukbo ng Efraim. ");
INSERT INTO tglulb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ang hukbo ng Efraim ay may 40, 500 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Dapat ang tribu ni Manases ang magkampong kasunod ng Efraim. Si Gamaliel na anak ni Pedasur ang dapat mamuno sa hukbo ni Manases. ");
INSERT INTO tglulb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ang hukbo ng Manases ay may 32, 200 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Susunod ang tribu ni Benjamin. Si Abidan na anak ni Gideon ang dapat mamuno sa hukbo ni Benjamin. ");
INSERT INTO tglulb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ang hukbo ni Manases ay may 35, 400 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Lahat ng mga hukbong nagkampong kasama ni Efraim ay may bilang na 108, 100 na kalalakihan. Sila ang pangatlong dapat lumabas mula sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dapat magkampo ang hukbo ni Dan sa palibot ng kaniyang bandila sa dakong hilaga ng tabernakulo. Si Ahieser na anak ni Ammisaddai ang dapat mamuno sa mga kaapu-apuhan ni Dan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ang hukbo ni Dan ay may 62, 700 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Dapat magkampo ang tribu ni Aser kasunod ni Dan. Si Pagiel na anak ni Okran ang dapat mamuno sa mga kaapu-apuhan ni Aser. ");
INSERT INTO tglulb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ang hukbo ni Aser ay may 41, 500 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ang sumunod ay ang tribu ni Neftali. Si Ahira na anak ni Enan ang dapat mamuno sa mga kaapu-apuhan ni Neftali. ");
INSERT INTO tglulb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ang hukbo ni Neftali ay may 53, 400 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Lahat ng mga hukbong nagkampong kasama ni Dan ay may bilang na 157, 600 na kalalakihan. Sila ang dapat mahuling lumabas mula sa kanilangkampo kasama ang kanilang bandila.” ");
INSERT INTO tglulb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Naibilang nina Moises at Aaron ayon sa mga angkan ng kanilang ninuno ang 603, 550 na kalalakihan sa mga hukbo ng mga Israelita. ");
INSERT INTO tglulb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ngunit hindi naibilang nina Moises at Aaron ang mga Levita sa mga tao ng Israel. Ito ay ayon sa iniutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ginawa ng mga Israelita ang lahat ng bagay na ipinag-utos ni Yahweh kay Moises. Nagkampo sila sa tabi ng kanilang mga bandila. Lumabas sila mula sa kampo ayon sa kanilang mga angkan, batay sa pagkakasunod ng mga angkan nga kanilang mga ninuno. ");
INSERT INTO tglulb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ngayon ito ang kasaysayan ng mga kaapu-apuhan nina Aaron at Moises nang kausapin ni Yahweh si Moises sa Bundok Sinai. ");
INSERT INTO tglulb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ang mga pangalan ng mga Anak na lalaki ni Aaron ay sina Nadab ang panganay, at Abihu, Eleazar, at Itamar. ");
INSERT INTO tglulb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ito ang mga pangalan ng mga anak na lalaki ni Aaron, ang mga paring pinahiran ng langis at siyang itinalaga upang maglingkod bilang mga pari. ");
INSERT INTO tglulb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ngunit namatay sa harapan ni Yahweh sina Nadab at Abihu nang naghandog sila kay Yahweh ng hindi katanggap-tanggap na apoy sa ilang ng Sinai. Walang mga anak sina Nadab at Abihu, kaya sina Eleazar at Itamar lamang ang naglingkod bilang mga pari kasama ni Aaron na kanilang ama. ");
INSERT INTO tglulb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Nagsalita si Yahweh kay Moises Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Dalhin mo ang tribu ni Levi at iharap sila kay Aaron na pari para matulungan nila siya. ");
INSERT INTO tglulb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Dapat nilang isagawa ang tungkulin sa pangalan ni Aaron at ang buong sambayanan sa harap ng tolda ng pagpupulong. Dapat silang maglingkod sa tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Dapat nilang ingatan ang lahat ng mga kasangkapan sa tolda ng pagpupulong, at dapat nilang tulungan ang mga tribu ng Israel upang isagawa ang paglilingkod sa tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Dapat mong ibigay ang mga Levita kay Aaron at sa kaniyang mga anak na lalaki. Ganap silang ibinigay upang tulungan siyang maglingkod sa mga tao ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Dapat mong hirangin sina Aaron at ang kaniyang mga anak na lalaki bilang mga pari, ngunit sinumang dayuhang lalapit ay dapat patayin.” ");
INSERT INTO tglulb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Tingnan mo, kinuha ko ang mga Levita mula sa mga tao ng Israel. Ginawa ko ito sa halip na kunin ang bawat panganay na lalaki na ipinanganak mula sa mga tao ng Israel. Pag-aari ko ang mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Pag-aari ko ang lahat ng mga panganay. Sa araw na sasalakayin ko ang lahat ng panganay sa lupain ng Ehipto, inilaan ko para sa aking sarili ang lahat ng panganay sa Israel, kapwa mga tao at mga hayop. Sila ay pag-aari ko. Ako si Yahweh.” ");
INSERT INTO tglulb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Nagsalita si Yahweh kay Moises sa ilang ng Sinai. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Bilangin mo ang mga kaapu-apuhan ni Levi sa bawat pamilya, sa mga tahanan ng kanilang mga ninuno. Bilangin mo ang bawat lalaki na isang buwang gulang at pataas.” ");
INSERT INTO tglulb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Sila ay binilang ni Moises, bilang pagsunod sa atas na ibinigay sa kanila ng salita ni Yahweh, gaya ng iniutos sa kaniya ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ang mga pangalan ng mga anak na lalaki ni Levi ay sina Gerson, Kohat, at Merari. ");
INSERT INTO tglulb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ang mga angkan na nagmumula sa mga anak na lalaki ni Gerson ay sina Libni at Shimei. ");
INSERT INTO tglulb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ang mga angkan na nagmumula sa mga anak na lalaki ni Kohat ay sina, Amram, Izar, Hebron, at Uziel. ");
INSERT INTO tglulb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ang mga angkan na nagmumula sa mga anak na lalaki ni Merari ay sina Mahali at Musi. Ito ang mga angkan ng mga Levita, na nakatala angkan sa angkan. ");
INSERT INTO tglulb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ang mga angkan ng mga Libnita at ng mga Shimeita ay nagmula kay Gerson. Ito ang mga angkan ng mga Gersonita. ");
INSERT INTO tglulb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Lahat ng mga lalaki mula sa isang buwang gulang at pataas ay binilang, na may kabuuang bilang na 7, 500. ");
INSERT INTO tglulb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Dapat magkampo ang angkan ng mga Gersonita sa dakong kanluran ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Dapat pangunahan ni Eliasaf na anak na lalaki ni Lael ang angkan ng kaapu-apuhan ng mga Gersonita. ");
INSERT INTO tglulb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Dapat ingatan ng pamilya ni Gerson ang mga kurtina ng tabernakulo sa ilalim ng panlabas na mga takip ng tolda ng pagpupulong. Dapat nilang ingatan ang tolda, ang mala-toldang pantakip, at ang kurtina para sa pasukan patungo sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Dapat nilang ingatan ang mga tabing sa patyo, ang kurtina sa pasukan ng patyo—ang patyo na nakapalibot sa santuwaryo at ang altar. Dapat nilang ingatan ang mga lubid ng tolda ng pagpupulong at para sa lahat ng bagay na nasa loob nito. ");
INSERT INTO tglulb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ang mga angkan na ito ay nagmula kay Kohat: ang angkan ng mga Amramita, ang angkan ng mga Izarita, ang angkan ng mga Hebronita, at ang angkan ng mga Uzielita. Ang mga angkan na ito ay nabibilang sa mga Kohatita. ");
INSERT INTO tglulb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","8, 600 na mga lalaki ang nabilang na may edad isang buwang gulang at pataas upang mag-ingat sa mga bagay na pag-aari ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Dapat magkampo ang mga pamilya ng mga kaapu-apuhan ni Kohat sa dakong timog ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Dapat pangunahan ni Elizafan na anak na lalaki ni Uziel ang mga angkan ng mga Kohatita. ");
INSERT INTO tglulb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Dapat nilang ingatan ang kaban, ang mesa, ang ilawan, ang mga altar, ang mga sagradong bagay na ginagamit sa kanilang paglilingkod, ang kurtina, at ang lahat ng gawain sa palibot nito. ");
INSERT INTO tglulb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Dapat pangunahan ni Eleazar na anak na lalaki ni Aaron na pari ang mga kalalakihang namumuno sa mga Levita. Dapat niyang pangasiwaan ang mga lalaking nag-iingat sa banal na lugar. ");
INSERT INTO tglulb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Dalawang angkan ang nagmula kay Merari: ang angkan ng mga Mahlita at ang angkan ng mga Musita. Ang mga angkan na ito ay nagmula kay Merari. ");
INSERT INTO tglulb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","6, 200 na mga lalaki ang nabilang na may edad isang buwang gulang at pataas. ");
INSERT INTO tglulb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Dapat pangunahan ni Zuriel na anak na lalaki ni Abihail ang mga angkan ni Merari. Dapat silang magkampo sa dakong hilaga ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Dapat ingatan ng mga kaapu-apuhan ni Merari ang mga tabla ng tabernakulo, ang mga pahalang na haligi, mga poste, mga patungan, lahat ng mga kagamitang metal, at lahat ng bagay na kaugnay sa mga ito, kabilang ");
INSERT INTO tglulb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ang mga haligi at mga poste ng patyo na nakapalibot sa tabernakulo, kasama ang mga patungan ng poste ng mga ito, mga tulos, at mga lubid. ");
INSERT INTO tglulb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Dapat magkampo sina Moses at Aaron at ang kaniyang mga anak na lalaki sa dakong silangan ng tabernakulo, sa harapan ng tolda ng pagpupulong, sa dakong sinisikatan ng araw. Sila ang mamahala para sa katuparan ng kanilang mga tungkulin sa santuwaryo at sa mga tungkulin ng mga tao ng Israel. Dapat patayin ang sinumang dayuhan na lalapit sa santuwaryo. ");
INSERT INTO tglulb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Binilang nina Moises at Aaron ang lahat ng mga lalaki sa mga angkan ni Levi na may edad isang buwang gulang at pataas, gaya ng iniutos ni Yahweh. Dalawampu't dalawang libong kalalakihan ang nabilang nila. ");
INSERT INTO tglulb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Sinabi ni Yahweh kay Moises, “Bilangin mo ang lahat ng panganay na mga lalaki sa mga tao ng Israel na may edad isang buwang gulang at pataas. Ilista mo ang kanilang mga pangalan. ");
INSERT INTO tglulb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Dapat mong kunin ang mga Levita para sa akin sa halip na ang lahat ng mga panganay ng mga tao ng Israel. Ako si Yahweh. At dapat mong kunin ang alagang hayop ng mga Levita sa halip na ang lahat ng panganay na alagang hayop ng mga kaapu-apuhan ni Israel.” ");
INSERT INTO tglulb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Binilang ni Moises ang lahat ng panganay na mga tao ng Israel gaya ng iniutos ni Yahweh na gawin niya. ");
INSERT INTO tglulb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Binilang niya ang lahat ng mga panganay na mga lalaki ayon sa kanilang pangalan, na may edad isang buwang gulang at pataas. 22, 273 na kalalakihan ang nabilang niya. ");
INSERT INTO tglulb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Muling nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Kunin mo ang mga Levita sa halip na ang lahat ng panganay sa mga tao ng Israel. At kunin mo ang alagang hayop ng mga Levita sa halip na ang alagang hayop ng mga tao. Ang mga Levita ay pag-aari ko. Ako si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Dapat kang mangolekta ng limang siklo para sa pantubos ng bawat isa sa 273 panganay ng mga tao ng Israel na humigit sa bilang ng mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Dapat mong gamitin ang siklo ng santuwaryo bilang iyong pamantayang timbang. Ang siklo ay katumbas ng dalawampung gera. ");
INSERT INTO tglulb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Dapat mong ibigay ang halaga ng pantubos na iyong binayaran kay Aaron at sa kanyang mga anak na lalaki.” ");
INSERT INTO tglulb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Kaya tinipon ni Moises ang pambayad ng pantubos mula sa mga taong humigit sa bilang ng mga natubos ng mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Tinipon ni Moises ang mga pera mula sa panganay na anak ng mga tao ng Israel. Nakaipon siya ng 1, 365 na siklo, na tumitimbang sa siklo ng santuwaryo. ");
INSERT INTO tglulb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ibinigay ni Moises ang pantubos na pera kay Aaron at sa kanyang mga anak na lalaki. Ginawa ni Moises ang lahat ng bagay na sinabi sa kanya upang gawin sa pamamagitan ng mga salita ni Yahweh, gaya ng iniutos sa kanya ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Nagsalita si Yahweh kina Moises at Aaron. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Magsagawa kayo ng isang pagtatala sa mga lalaking kaapu-apuhan ni Kohat na nagmula sa mga Levita, sa pamamagitan ng kanilang mga angkan at ng mga pamilya ng kanilang ninuno. ");
INSERT INTO tglulb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Bilangin ninyo ang lahat ng kalalakihan na tatlumpu hanggang limampung taong gulang. ");
INSERT INTO tglulb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Dapat sumali ang kalalakihang ito sa samahan para maglingkod sa tolda ng pagpupulong. Dapat pangalagaan ng mga kaapu-apuhan ni Kohat ang pinakasagradong mga bagay na inilaan para sa akin sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kapag naghahanda ang kampo para umabante, dapat pumunta si Aaron at ang kaniyang mga anak na lalaki sa tolda, ibaba ang kurtina na naghihiwalay sa pinakabanal na lugar mula sa banal na lugar, at itakip ito sa kaban ng tipan. ");
INSERT INTO tglulb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Dapat nilang takpan ang kaban ng mga balat ng dugong. Dapat silang maglatag ng asul na tela sa taas nito. Dapat nilang ilagay ang mga pasanan sa pagbubuhat nito. ");
INSERT INTO tglulb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Dapat silang maglatag ng isang asul na tela sa mesa ng tinapay ng presensya. Sa ibabaw nito, dapat nilang ilagay ang mga pinggan, mga kutsara, mga mangkok, at mga banga para sa pagbubuhos. Dapat palaging nasa mesa ang tinapay. ");
INSERT INTO tglulb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Dapat nilang takpan ang mga ito ng isang matingkad na pulang tela at muli ng mga balat ng dugong. Dapat nilang ilagay ang mga pasanan sa pagbubuhat sa mesa. ");
INSERT INTO tglulb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Dapat silang kumuha ng isang asul na tela at takpan ang patungan ng ilawan, kasama ng mga ilawan nito, mga sipit, mga sisidlan ng abo, at lahat ng mga banga ng langis para sa mga ilawan. ");
INSERT INTO tglulb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Dapat nilang takpan ang patungan ng ilawan at ang lahat ng mga kasangkapan nito ng mga balat ng dugong, at dapat nilang ilagay ito sa balangkas na binubuhat. ");
INSERT INTO tglulb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Dapat nilang ilatag ang isang asul na tela sa gintong altar. Dapat nilang takpan ito ng mga balat ng dugong, at pagkatapos ay ilagay ang mga pasanan sa pagbubuhat. ");
INSERT INTO tglulb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Dapat nilang dalhin ang lahat ng kasangkasapan para sa gawain sa loob ng banal na lugar at balutin ito ng isang asul na tela. Dapat nilang takpan ito ng mga balat ng dugong at ilagay ang kasangkapan sa balangkas na binubuhat. ");
INSERT INTO tglulb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Dapat nilang alisin ang mga abo mula sa altar at maglatag ng isang lilang tela sa altar. ");
INSERT INTO tglulb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Dapat nilang ilagay ang lahat ng kasangkapan sa balangkas na binubuhat na ginagamit nila sa paggawa ng altar. Ang mga bagay na ito ay ang mga kawali, mga tinidor, mga pala, mga mangkok, at lahat ng ibang kasangkapan para sa altar. Dapat nilang takpan ang altar ng mga balat ng dugong at pagkatapos ay ilagay ang mga pasanan sa pagbubuhat. ");
INSERT INTO tglulb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Kapag ganap na natakpan ni Aaron at ng kaniyang mga anak na lalaki ang banal na lugar at lahat ng mga kasangkapan nito, at kapag umabante ang kampo, dapat pumunta ang mga kaapu-apuhan ni Kohat upang dalhin ang banal na lugar. Kapag hinawakan nila ang mga sagradong kasangkapan, dapat silang mamatay. Ito ang gawain ng mga kaapu-apuhan ni Kohat, upang dalhin ang mga gamit sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Dapat pangalagaan ni paring Eleazar na anak na lalaki ni Aaron ang langis para sa ilaw. Dapat niyang pangasiwaan ang pangangalaga ng matamis na insenso, ang palagiang handog na butil, ang pampahid na langis, ang buong tabernakulo at lahat ng narito, ang sagradong mga kagamitan at mga artikulo.” ");
INSERT INTO tglulb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Nagsalita si Yahweh kina Moises at Aaron. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Huwag hayaan ang mga angkan ng mga tribu ni Kohat na maalis mula sa mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ipangtanggol ninyo sila sa paggawa nito, upang sila ay mabuhay at hindi mamamatay. Kapag nilapitan nila ang pinakabanal na mga bagay ");
INSERT INTO tglulb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","hindi sila dapat pumasok upang tingnan ang banal na lugar kahit sandali, kasi kung gagawin nila, dapat silang mamatay. Dapat pumasok sina Aaron at ang kaniyang mga anak na lalaki at pagkatapos, dapat italaga nina Aaron at ng kaniyang mga anak na lalaki ang bawat Kohatita sa kaniyang gawain, sa kaniyang natatanging mga tungkulin.” ");
INSERT INTO tglulb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Nagsalita muli si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Gumawa ka rin ng isang pagtatala ng mga kaapu-apuhan ni Gerson, ayon sa mga pamilya ng kanilang ninuno, ayon sa kanilang mga angkan. ");
INSERT INTO tglulb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Bilangin mo iyong mga tatlumpu hanggang limampung taong gulang. Bilangin mo silang lahat na sasali sa samahan upang maglingkod sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ito ay ang gawain ng mga angkan ng Gersonita, kapag sila ay naglilingkod at anuman ang kanilang binubuhat. ");
INSERT INTO tglulb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Dapat nilang dalhin ang mga kurtina ng tabernakulo, ang tolda ng pagpupulong, ang mga pantakip nito, ang pantakip na balat ng dugong na nakalagay dito, at ang mga kurtina para sa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Dapat nilang dalhin ang mga kurtina ng patyo, ang kurtina para sa daanan sa tarangkahan ng patyo, na malapit sa tabernakulo at malapit sa altar, ang mga lubid nito, at lahat ng mga kasangkapan para sa kanilang paglilingkod. Anuman ang kailangang gawin sa mga bagay na ito, dapat nilang gawin ito. ");
INSERT INTO tglulb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Dapat pamahalaan nila Aaron at ng kaniyang mga anak na lalaki ang lahat ng paglilingkod ng mga kaapu-apuhan ng mga Gersonita, sa bawat bagay na kanilang ililipat, at sa lahat ng kanilang paglilingkod. Dapat mo silang italaga sa lahat ng kanilang mga tungkulin. ");
INSERT INTO tglulb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ito ay ang paglilingkod ng mga angkan ng mga kaapu-apuhan ng mga Gersonita para sa tolda ng pagpupulong. Ang pari na si Itamar na anak na lalaki ni Aaron ang dapat na manguna sa kanilang paglilingkod. ");
INSERT INTO tglulb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Dapat mong bilangin ang mga kaapu-apuhan ni Merari ayon sa kanilang mga angkan, at iayos mo sila ayon sa mga pamilya ng kanilang ninuno, ");
INSERT INTO tglulb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","mula tatlumpung taong gulang pataas hanggang limampung taong gulang. Bilangin mo bawat isa na sasali sa samahan at maglilingkod sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ito ay ang kanilang tungkulin at kanilang gawain sa lahat ng kanilang paglilingkod para sa tolda ng pagpupulong. Dapat nilang pangalagaan ang pagbabalangkas ng tabernakulo, mga pahalang na haligi nito, mga poste, at mga patungan, ");
INSERT INTO tglulb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","kasama ng mga poste ng patyo sa palibot ng tabernakulo, ang mga patungan ng mga ito, mga tulos na pako, at ang mga lubid nito, kasama ang mga metal ng mga ito. Itala sa kanilang pangalan ang mga bagay na dapat nilang dalhin. ");
INSERT INTO tglulb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ito ay ang paglilingkod ng mga angkan ng mga kaapu-apuhan ni Merari, anuman ang kanilang gagawin para sa tolda ng pagpupulong, sa ilalim ng pamamahala n paring Itamar na anak na lalaki ni Aaron.” ");
INSERT INTO tglulb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Binilang nina Moises, Aaron at ng mga pinuno ng mga sambayanan ang mga kaapu-apuhan ng mga Kohatita ayon sa mga angkan ng mga pamilya ng kanilang ninuno. ");
INSERT INTO tglulb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Binilang sila mula tatlumpung taong gulang pataas hanggang limampung taong gulang. Binilang nila ang bawat isa na sasali sa samahan para maglingkod sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Binilang nila ang 2, 750 na kalalakihan ayon sa kanilang mga angkan. ");
INSERT INTO tglulb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Binilang nina Moises at Aaron ang lahat ng kalalakihan sa mga angkan at mga pamilya ng mga Kohatita na siyang naglilingkod sa tolda ng pagpupulong. Sa pag-gawa nito, sinunod nila ang iniutos ni Yahweh na kanilang gawin sa pamamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Binilang ang mga kaapu-apuhan ni Gerson sa kanilang mga angkan, ayon sa mga pamilya ng kanilang ninuno, ");
INSERT INTO tglulb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","mula tatlumpu hanggang limampung taong gulang, bawat isa na sasali sa samahan para maglingkod sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Lahat ng kalalakihan, binilang ayon sa kanilang mga angkan at mga pamilya ng kanilang ninuno, sa bilang na 2, 630. ");
INSERT INTO tglulb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Binilang nina Moises at Aaron ang mga angkan ng mga kaapu-apuhan ni Gerson na maglilingkod sa tolda ng pagpupulong. Sa paggawa nito, sinunod nila ang iniutos ni Yahweh sa kanila na gawin sa pamamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Binilang ang mga kaapu-apuhan ni Merari sa kanilang angkan ayon sa mga pamilya ng kanilang ninuno, ");
INSERT INTO tglulb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","mula tatlumpu hanggang limampung taong gulang, bawat isa na sasali sa samahan para maglingkod sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Lahat ng kalalakihan, nabilang ayon sa kanilang mga angkan at mga pamilya ng kanilang mga ninuno, sa bilang na 3, 200. ");
INSERT INTO tglulb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Binilang nina Moises at Aaron ang lahat ng kalalakihang ito, ang mga kaapu-apuhan ni Merari. Sa paggawa nito, sinunod nila ang iniutos ni Yahweh sa kanila na gawin sa pamamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Kaya binilang nina Moises, Aaron, at ng mga pinuno ng Israel ang lahat ng Levita ayon sa kanilang angkan sa mga pamilya ng kanilang ninuno ");
INSERT INTO tglulb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","mula tatlumpu hanggang limampung taong gulang. Binilang nila ang bawat isa na gagawa ng mga gawain sa tabernakulo, at sinumang magdadala at mamamahala ng mga kagamitan sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Nabilang nila ang 8, 580 na kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Sa utos ni Yahweh, binilang ni Moises ang bawat lalaki, patuloy na bilang ang bawat-isa ayon sa uri ng gawaing naitilaga sa kaniya upang gawin niya. Binilang niya ang bawat-isa sa uri ng tungkulin na kanyang pasanin. Sa paggawa nito, sinunod nila ang utos ni Yahweh na kanilang gawin sa pamamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Utusan mo ang mga tao ng Israel na paalisin mula sa kampo ang lahat ng may nakakahawang sakit sa balat, at lahat ng may tumutulong sugat, at ang sinumang marumi sa pamamagitan ng paghawak ng isang patay na katawan. ");
INSERT INTO tglulb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Maging lalaki o babae, dapat paalisin ninyo sila sa kampo. Hindi nila dapat dungisan ang kampo, dahil naninirahan ako dito.” ");
INSERT INTO tglulb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Kaya ginawa ito ng mga tao ng Israel. Pinaalis nila sila sa kampo, gaya ng inutos ni Yahweh kay Moises. Sinunod ng mga tao ng Israel si Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Muling nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Magsalita ka sa mga tao ng Israel. Kapag nakagawa ang isang lalaki o babae ng anumang kasalanang tulad ng ginagawa ng mga tao sa isa't isa, at hindi tapat sa akin, ang taong iyon ay nagkasala. ");
INSERT INTO tglulb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Kung gayon, dapat niyang aminin ang kasalanang kaniyang nagawa. Dapat niyang ganap na bayaran ang halaga ng kaniyang pagkakasala at dagdagan ang halaga ng higit sa ikalimang bahagi. Dapat niyang ibigay ito sa isang taong nakagawan niya ng kamalian. ");
INSERT INTO tglulb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ngunit kung ang taong nagawan niya ng kamalian ay walang malapit na kamag-anak upang tumanggap ng bayad, dapat niyang bayaran ang halaga para sa kaniyang pagkakasala sa akin sa pamamagitan ng isang pari, kasama ang isang lalaking tupa upang pambayad sala para sa kaniyang sarili. ");
INSERT INTO tglulb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Bawat handog na idinulog sa isang pari mula sa lahat ng sagradong bagay, ang mga bagay na inilaan ng mga tao ng Israel para sa akin ay mapapabilang sa paring iyon. ");
INSERT INTO tglulb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Mapapabilang sa pari ang bawat sagradong bagay na pag-aari ng mga tao. Mapapabilang sa paring iyon ang anumang ibibigay ng isang tao sa pari.” ");
INSERT INTO tglulb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Muling nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Magsalita ka sa mga tao ng Israel. Sabihin mo sa kanila, 'Ipagpalagay na tumalikod ang isang asawang babae at nagkasala laban sa kaniyang asawang lalaki. ");
INSERT INTO tglulb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Pagkatapos, ipagpalagay na ang isang lalaki ay nakipagtalik sa kaniya. Sa ganitong kalagayan, nadungisan siya. Kahit na hindi ito nakita ng kaniyang asawang lalaki o nalaman ang tungkol dito, at kahit wala ni isa ang nakahuli sa kaniya sa kaganapan at wala ni isa ang makapagpatotoo laban sa kaniya, ");
INSERT INTO tglulb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","gayon pa man, maaaring ipaalam ng isang espiritu ng pagseselos sa asawang lalaki na ang kaniyang asawang ay nadungisan. Gayunman, ang espiritu ng pagseselos ay maaaring iparating sa isang lalaki na ang kaniyang asawa ay hindi nadungisan. ");
INSERT INTO tglulb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Sa ganitong mga kalagayan, dapat dalhin ng lalaki ang kaniyang asawa sa pari. Dapat magdala ng isang inuming handog ang asawang lalaki para sa kaniyang asawa. Dapat magdala siya ng isang ikasampu ng isang epa ng sebadang harina. Dapat hindi niya ito buhusan ng langis o kamanyang dahil ito ay isang handog na butil ng pagseselos, isang handog na butil na maaaring tagaturo ng kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Ang pari ay dapat ilapit ang babae at iharap siya kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Dapat kumuha ang pari ng isang tapayan ng banal na tubig at kumuha ng alikabok mula sa sahig ng tabernakulo. Dapat niyang ilagay ang alikabok sa tubig. ");
INSERT INTO tglulb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Dapat iharap ng pari ang babae kay Yahweh. Dapat alisin ng babae ang takip ng kaniyang ulo at alisin ang tali ng kaniyang buhok. Dapat ilagay ng pari sa kaniyang mga kamay ang handog na butil bilang isang pahiwatig. Ito ang handog na butil ng pagseselos. Dapat hawakan ng pari sa kaniyang kamay ang mapait na tubig na may alikabok na magdadala ng isang sumpa sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Dapat panumpain siya ng pari ng isang panunumpa. Dapat niyang sabihin sa babae, “Kung walang lalaking nakipagtalik sa iyo, at kung hindi ka naligaw at nakagawa ng kalaswaan, tiyak na ikaw ay magiging malaya mula sa mapait na tubig na ito na magdadala ng isang sumpa. ");
INSERT INTO tglulb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ngunit kung ikaw ay isang babae na nasa ilalim ng kaniyang asawa, naligaw, kung nadungisan ka, at kung nakipagtalik sa iyo ang ilang lalaki...” ");
INSERT INTO tglulb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Dapat panumpain ng pari ang babae ng isang panunumpa na magdadala ng isang sumpa sa kaniya, at pagkatapos, dapat siyang patuloy na kausapin ang babae,”... at gagawin kang isang isinumpa ni Yahweh na ipapakita sa iyong mga tao na maging ganoon. Mangyayari ito kung pahihintulutan ni Yahweh ang iyong hita na mabulok at mamaga ang iyong tiyan. ");
INSERT INTO tglulb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ang tubig na ito na nagdadala ng sumpa ay pupunta sa iyong tiyan, mamaga ang iyong tiyan, at mabubulok ang iyong mga hita.” Isasagot dapat ng babae, “Oo, mangyari nawa ito kung ako ay nagkasala.” ");
INSERT INTO tglulb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Dapat Isulat ng pari ang mga sumpang ito sa isang kasulatang binalumbon, at pagkatapos, dapat niyang hugasan ang mga sumpang isinulat sa mapait na tubig. ");
INSERT INTO tglulb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ipapainom ng pari ang mapait na tubig sa babaeng magdadala ng sumpa. Papasok sa kaniya at magiging mapait ang tubig na magdadala ng sumpa. ");
INSERT INTO tglulb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Dapat kumuha ang pari ng handog na butil ng pagseselos mula sa kamay ng babae. Dapat niyang itaas ang handog na butil sa harap ni Yahweh at dalhin ito sa altar. ");
INSERT INTO tglulb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Dapat kumuha ng isang dakot ng handog na butil, isang bahagi nito, at sunugin ito sa altar. Pagkatapos, dapat niyang ibigay sa babae ang mapait na tubig upang inumin. ");
INSERT INTO tglulb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kapag bibigyan niya ang babae ng tubig upang inumin, kung nadungisan siya dahil nakagawa siya ng isang kasalanan laban sa kaniyang asawang lalaki, ang tubig na magdadala ng sumpa ay papasok sa kaniya at magiging mapait. Mamamaga ang kaniyang tiyan at mabubulok ang kaniyang hita. Isusumpa ang babae sa gitna kaniyang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ngunit kung hindi nadungisan ang babae at kung malinis siya, dapat siyang maging malaya. Maaari siyang magkaroon ng mga anak. ");
INSERT INTO tglulb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ito ay ang batas ng pagseselos. Ito ay ang batas para sa isang babaeng lumayo mula sa kaniyang asawa at nadungisan. ");
INSERT INTO tglulb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Ito ang batas para sa isang lalaki na may espiritu ng pagseselos kapag nagseselos siya sa kaniyang asawa. Dapat niyang dalhin ang babae sa harap ni Yahweh, at dapat gawin ng pari sa kaniya ang lahat ng bagay na inilalarawan ng batas na ito ng pagseselos. ");
INSERT INTO tglulb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Magiging malaya ang lalaki mula sa pagkakasala sapgkat dinala niyaang kaniyang asawa sa pari. Ang babae ay dapat niyang dalhin ang anumang kasalanang maaaring nasa kaniya.'” ");
INSERT INTO tglulb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Magsalita ka sa mga tao ng Israel. Sabihin mo sa kanila, “Kapag ang isang lalaki o isang babae ay ibinukod niya ang kaniyang sarili kay Yahweh kasama ang isang natatanging panata ng isang Nazareo, ");
INSERT INTO tglulb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","dapat niyang ilayo ang kaniyang sarili mula sa alak at matapang na inumin. Dapat hindi siya iinom ng suka na gawa mula sa alak o mula sa matapang na inumin. Dapat hindi siya iinom ng anumang katas ng ubas o kakain ng sariwang mga ubas o mga pasas. ");
INSERT INTO tglulb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Sa lahat ng araw na siya ay ibinukod sa akin, dapat wala siyang kakaining anumang bagay na gawa mula sa mga ubas, kabilang ang lahat ng bagay na gawa mula sa mga buto hanggang sa kanilang mga balat. ");
INSERT INTO tglulb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Sa buong panahon ng kaniyang panata ng pagbubukod, walang labaha ang gagamitin sa kaniyang ulo hanggang sa mga araw ng kaniyang pagbubukod kay Yahweh ay matupad. Dapat siyang ihandog kay Yahweh. Dapat niyang hayaang humaba ang buhok sa kaniyang ulo. ");
INSERT INTO tglulb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Sa buong panahon na ibubukod niya ang kaniyang sarili kay Yahweh, dapat hindi siya lalapit sa isang patay na katawan. ");
INSERT INTO tglulb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Dapat hindi niya dudumihan ang kaniyang sarili kahit na para sa kaniyang ama, ina, kapatid na lalaki, o sa kapatid na babae, kung sila ay namatay. Ito ay dahil ibinukod siya para sa Diyos, gaya ng maaaring makita ng lahat sa pamamagitan ng kaniyang mahabang buhok. ");
INSERT INTO tglulb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Sa buong panahon ng kaniyang pagbubukod siya ay banal, nakalaan para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Kung biglang namatay ang isang tao sa tabi niya at dudungisan ang kaniyang naibukod na pagkatao, sa gayon, dapat niyang ahitan ang kaniyang ulo sa araw ng kaniyang paglilinis na kung saan dapat pagkatapos ng pitong araw. Sa araw na iyon, dapat niyang ahitan ang kaniyang ulo. ");
INSERT INTO tglulb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Sa ikawalong araw, dapat niyang dalhin ang dalawang kalapati o dalawang batang kalapati sa pari sa pasukan patungo sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ang pari ay dapat maghandog ng isang ibon bilang handog sa kasalanan at ang isang ibon bilang handog na susunugin. Ito ay pambayad para sa kaniya dahil nagkasala siya sa pamamagitan ng pagiging malapit sa patay na katawan. Dapat muli niyang ihandog ang kaniyang sarili kay Yahweh sa araw ding iyon. ");
INSERT INTO tglulb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Dapat muli niyang ihandog ang kaniyang sarili kay Yahweh sa panahon ng kaniyang pagbubukod. Dapat niyang dalhin ang isang lalaking tupa na isang taong gulang bilang isang pag-aalay sa pagkakasala. Hindi dapat ibilang ang mga araw bago niya nadungisan ang kanyiang sarili, dahil nadungisan siya habang siya ay ibinukod para sa Diyos. ");
INSERT INTO tglulb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ito ang batas tungkol sa Nazareo para kapag natapos na ang panahon ng kaniyang pagbubukod. Dapat siyang dalhin sa pasukan sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Dapat niyang idulog ang kaniyang handog kay Yahweh. Dapat niyang ialay bilang isang handog na susunugin ang isang lalaking tupa na isang taong gulang at walang kapintasan. Dapat magdala siya ng isang babaeng tupa bilang handog para sa kasalanan na isang taong gulang at walang kapintasan. Dapat magdala siya ng isang lalaking tupa na walang dungis bilang handog para sa pagtitipon-tipon. ");
INSERT INTO tglulb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Dapat magdala rin siya ng isang buslo ng tinapay na ginawa na walang pampaalsa, mga tinapay ng pinong harina na hinaluan ng langis, mga wafer na tinapay na walang pampaalsa na pinahiran ng langis, kasama ang kanilang handog na butil at mga handog na inumin. ");
INSERT INTO tglulb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Dapat idulog ng pari ang mga ito sa harap ni Yahweh. Dapat niyang ialay ang kaniyang handog para sa kasalanan at handog na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Kasama ang buslo ng tinapay na walang lebadura, dapat niyang idulog ang isang lalaking tupa bilang isang alay, ang handog sa pagtitipon-tipon kay Yahweh. Dapat idulog din ng pari ang handog na butil at ang handog na inumin. ");
INSERT INTO tglulb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Dapat ahitan ng Nazareo ang kaniyang ulo na nagpapahiwatig ng kaniyang pagkabukod sa Diyos sa pasukan patungo sa tolda ng pagpupulong. Dapat niyang kunin ang buhok mula sa kaniyang ulo at ilagay ito sa apoy sa ilalim ng paghahandog ng mga handog sa pagtitipon-tipon. ");
INSERT INTO tglulb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Dapat kunin ng pari ang pinakuluang balikat ng lalaking tupa, isang tinapay na walang pampaalsa mula sa buslo, at isang wafer na tinapay na walang pampaalsa. Dapat niyang ilagay ang mga ito sa kamay ng Nazareo pagkatapos niyang ahitan ang kaniyang ulo na nagpapahiwatig ng pagkabukod. ");
INSERT INTO tglulb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Dapat itaas ng pari ang mga ito bilang isang handog sa harap ni Yahweh at idulog ang mga ito sa kaniya. Ito ay banal na pagkain na nakalaan para sa pari, kasama ang dibdib na itinaas at ang hita na inihandog. Pagkatapos nito, maaari nang uminom ng alak ang Nazareo. ");
INSERT INTO tglulb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ito ang batas para sa Nazareo na nagpapanata ng kaniyang alay kay Yahweh para sa kaniyang pagkabukod. Kahit ano pa ang maaari niyang ibigay, dapat niyang panatilihin ang kaniyang tungkulin ng panata na kaniyang kinuha, upang panatilihin ang pangakong nakalakip sa pamamagitan ng batas para sa Nazareo.'” ");
INSERT INTO tglulb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Muling nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Kausapin mo si Aaron at ang kaniyang mga anak na lalaki. Sabihin mo, 'Dapat ninyong pagpalain ang mga tao ng Israel sa ganitong paraan. Dapat ninyong sabihin sa kaniya, ");
INSERT INTO tglulb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Pagpalain ka nawa ni Yahweh at ingatan. ");
INSERT INTO tglulb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Pasisikatin nawa ni Yahweh ang kaniyang liwanag sa iyo, titingin sa iyo, at mahabag sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Tingnan ka nawa si Yahweh nang may kabutihang loob at bigyan ka ng kapayapaan.'” ");
INSERT INTO tglulb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Sa ganitong paraan dapat nilang ibigay ang aking pangalan sa mga tao ng Israel. At pagpapalain ko sila.” ");
INSERT INTO tglulb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Sa araw na natapos ni Moises ang tabernakulo, binuhusan niya ito ng langis at itinalaga ito kay Yahweh, kasama ang lahat kagamitan. Ganoon din ang ginawa niya sa altar at lahat ng kagamitan nito. Binuhusan niya ng langis ang mga ito at itinalaga kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Sa araw na iyon, nag-alay ng mga handog ang mga pinuno ng Israel, ang mga pangulo ng mga pamilya ng kanilang ninuno. Ang mga taong ito ang nangunguna sa mga tribu. Pinamahalaan nila ang pagbibilang ng mga kalalakihan sa sensus. ");
INSERT INTO tglulb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Dinala nila ang kanilang mga handog sa harapan ni Yahweh. Nagdala sila ng anim na karitong may takip at labindalawang lalaking baka. Nagdala sila ng isang kariton para sa bawat dalawang pinuno, at nagdala ang bawat pinuno ng isang lalaking baka. Idinulog nila ang mga bagay na ito sa harapan ng tabernakulo. ");
INSERT INTO tglulb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Pagkatapos, kinausap ni Yahweh si Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Tanggapin mo ang mga handog mula sa kanila at gamitin ang mga handog para sa gawain sa tolda ng pagpupulong. Ibigay mo ang mga handog sa mga Levita, sa bawat isa ayon sa kailangan ng kaniyang gawain.” ");
INSERT INTO tglulb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Kinuha ni Moises ang mga kariton at ang mga lalaking baka, at ibinigay niya ang mga ito sa mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ibinigay niya ang dalawang kariton at apat na lalaking baka sa mga kaapu-apuhan ni Gerson, dahil sa kailangan ng kanilang gawain. ");
INSERT INTO tglulb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ibinigay niya ang apat na kariton at walong lalaking baka sa mga kaapu-apuhan ni Merari, sa pangangalaga ni Itamar na anak na lalaki ni Aaron na pari. Ginawa niya ito dahil sa kailangan ng kanilang gawain. ");
INSERT INTO tglulb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ngunit wala siyang ibinigay sa mga bagay na iyon sa mga kaapu-apuhan ni Kohat, dahil sa kanila ang mga gawaing nauukol sa mga bagay na nabibilang kay Yahweh na kanilang papasanin sa kanilang mga balikat. ");
INSERT INTO tglulb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Inialay ng mga pinuno ang kanilang mga handog para sa pagtatalaga ng altar sa araw na binuhusan ni Moises ng langis ang altar. Inialay ng mga pinuno ang kanilang mga handog sa harapan ng altar. ");
INSERT INTO tglulb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Sinabi ni Yahweh kay Moises, “Dapat ialay ng bawat pinuno ang kaniyang handog sa kaniyang sariling araw para sa pagtatalaga ng altar.” ");
INSERT INTO tglulb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Sa unang araw, inihandog ni Naason na anak ni Aminadab mula sa tribu ni Juda ang kaniyang handog. ");
INSERT INTO tglulb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ng pinong harina na hinaluan ng langis para sa handog na butil ang mga bagay na ito. ");
INSERT INTO tglulb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, na puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking kordero bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Nagbigay siya ng isang lalaking kambing bilang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking kordero na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Naason na anak ni Amminadab. ");
INSERT INTO tglulb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Sa ikalawang araw, inihandog ni Nathanael na anak ni Zuar na pinuno ng tribu ni Isacar ang kaniyang handog. ");
INSERT INTO tglulb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Inialay niya bilang kaniyang handog ang isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, na puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Nagbigay siya ng isang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Nethanael na anak ni Zuar. ");
INSERT INTO tglulb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Sa ikatlong araw, nag-alay ng kaniyang handog si Eliab na anak ni Helon, pinuno ng mga kaapu-apuhan ni Zebulon. ");
INSERT INTO tglulb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, na puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang isang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Nagbigay siya ng isang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Eliab na anak ni Helon. ");
INSERT INTO tglulb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Sa ikaapat na araw, nag-alay ng kaniyang handog si Elizur na anak ni Sedeur, pinuno ng mga kaapu-apuhan ni Ruben. ");
INSERT INTO tglulb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, na puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Nagbigay siya ng isang lalaking kambing bilang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Elizur na anak ni Sedeur. ");
INSERT INTO tglulb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Sa ikalimang araw, nag-alay ng kaniyang handog si Shelumiel na anak ni Zurisaddai, pinuno ng mga kaapu-apuhan ni Simeon. ");
INSERT INTO tglulb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, na puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Nagbigay siya ng isang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Selumiel na anak ni Zurisaddai. ");
INSERT INTO tglulb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Sa ikaanim na araw, nag-alay ng kaniyang handog si Eliasaf na anak ni Deuel, pinuno ng mga kaapu-apuhan ni Gad. ");
INSERT INTO tglulb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, na puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Nagbigay siya ng isang lalaking kambing bilang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay para sa handog para sa pagtitipon-tipon. Ito ang alay ni Eliasaf na anak ni Deuel. ");
INSERT INTO tglulb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Sa ikapitong araw, nag-alay ng kaniyang handog si Elishama na anak ni Ammiud, pinuno ng mga kaapu-apuhan ni Efraim. ");
INSERT INTO tglulb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, na puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Nagbigay siya ng isang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Elishama na anak ni Ammiud. ");
INSERT INTO tglulb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Sa ikawalong araw, nag-alay ng kaniyang handog si Gamaliel na anak ni Pedasur, pinuno ng mga kaapu-apuhan ni Manases. ");
INSERT INTO tglulb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, puno ng insenso.. ");
INSERT INTO tglulb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Nagbigay siya ng isang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Gamaliel na anak ni Pedahzur. ");
INSERT INTO tglulb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Sa ikasiyam na araw, nag-alay ng kaniyang handog si Abidan na anak ni Gideon, pinuno ng mga kaapu-apuhan ni Benjamin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na pagkaing butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Nagbigay siya ng isang lalaking kambing bilang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Abidan na anak ni Gideon. ");
INSERT INTO tglulb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Sa ikasampung araw, nag-alay ng kaniyang handog si Ahiezer na anak ni Ammisaddai, pinuno ng mga kaapu-apuhan ni Dan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na pagkaing butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Nagbigay siya ng isang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Ahiezer na anak ni Ammisaddai. ");
INSERT INTO tglulb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Sa ikalabing isang araw, nag-alay ng kaniyang handog si Pagiel na anak ni Okran, pinuno ng mga kaapu-apuhan ni Aser. ");
INSERT INTO tglulb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Nagbigay siya ng isang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Pagiel na anak ni Okran. ");
INSERT INTO tglulb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Sa ikalabindalawang araw, nag-alay ng kaniyang handog si Ahira na anak ni Enan, pinuno ng mga kaapu-apuhan ni Neftali. ");
INSERT INTO tglulb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ang kaniyang handog ay isang pilak na pinggan na tumitimbang ng 130 siklo at isang mangkok na pilak na tumitimbang ng pitumpung siklo, ayon sa pamantayang timbang ng santuwaryong siklo. Kapwa puno ang mga bagay na ito ng pinong harina na hinaluan ng langis para sa handog na butil. ");
INSERT INTO tglulb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Nagbigay din siya ng isang gintong pinggan na tumitimbang ng sampung siklo, na puno ng insenso. ");
INSERT INTO tglulb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Nagbigay siya ng isang batang toro, isang lalaking tupa at isang taong gulang na lalaking tupa bilang alay na susunugin. ");
INSERT INTO tglulb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Nagbigay siya ng isang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Nagbigay siya ng dalawang lalaking baka, limang lalaking tupa, limang lalaking kambing, at limang lalaking tupa na isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Ito ang alay ni Ahira na anak ni Enan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Itinalaga ng mga pinuno ng Israel ang lahat ng bagay na ito sa araw na binuhusan ni Moises ng langis ang altar. Naglaan sila ng labindalawang pilak na pinggan, labindalawang mangkok na pilak at labindalawang gintong pinggan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Bawat pilak na pinggan ay tumitimbang ng 130 siklo at bawat mangkok ay tumitimbang ng pitumpung siklo. Tumitimbang ng 2, 400 siklo ang lahat ng lalagyang pilak, ayon sa pamantayang timbang ng santuwaryong siklo. ");
INSERT INTO tglulb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Bawat isa sa labindalawang gintong pinggan, na puno ng insenso ay tumitimbang ng sampung siklo ayon sa pamantayang timbang ng santuwaryong siklo. Lahat ng gintong pinggan ay tumitimbang ng 120 siklo. ");
INSERT INTO tglulb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Itinalaga nila ang labindalawang batang toro, labindalawang lalaking tupa at labindalawang lalaking tupa na isang taong gulang bilang alay na susunugin. Ibinigay nila ang kanilang handog na butil. Ibinigay nila ang labindalawang lalaking kambing bilang alay para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Mula sa lahat ng kanilang mga alagang hayop, nagbigay sila ng dalawampu't apat na toro, animnapung lalaking tupa, animnapung lalaking kambing at animnapung lalaking tupang isang taong gulang, bilang alay na handog para sa pagtitipon-tipon. Para ito sa paglalaan ng altar, nang binuhusan ito ng langis. ");
INSERT INTO tglulb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Nang pumasok si Moises sa tolda ng pagpupulong upang makipag-usap kay Yahweh, narinig niya ang kaniyang tinig na kinakausap siya. Kinausap siya ni Yahweh mula sa itaas ng takip ng luklukan ng awa na nasa kaban ng tipan, mula sa gitna ng dalawang kerubim. Nakipag-usap siya sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Kausapin mo si Aaron. Sabihin mo sa kaniya, 'Dapat magbigay ng liwanag ang pitong ilawan sa harapan ng patungan ng ilaw kapag sinindihan mo ang mga ito.''' ");
INSERT INTO tglulb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ginawa ito ni Aaron. Sinindihan niya ang mga ilawan na nasa patungan ng ilawan upang magbigay ng liwanag sa harapan nito, gaya ng inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ginawa ang patungan ng ilawan sa ganitong paraan: Ipinakita ni Yahweh kay Moises ang huwaran para rito: pinanday na ginto mula sa paanan hanggang sa itaas nito, kasama ang mga basong pinanday na parang mga bulaklak. ");
INSERT INTO tglulb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Muling nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Kunin mo ang mga Levita mula sa mga tao ng Israel at gawin mo silang dalisay. ");
INSERT INTO tglulb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Gawin mo ito sa kanila upang gawin silang malinis: Iwisik mo sa kanila ang tubig na panlinis ng kasalanan. Paahitan mo sa kanila ang kanilang buong katawan, palabhan mo ang kanilang mga damit, at sa ganitong paraan gawing malinis ang kanilang sarili. ");
INSERT INTO tglulb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Pagkatapos pakuhain mo sila ng isang batang toro at ng handog butil ng pinong harinang hinaluan ng langis. Pakuhain mo sila ng isa pang batang toro bilang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Idulog mo ang mga Levita sa harapan ng tolda ng pagpupulong, at tipunin mo ang buong sambayanan ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Idulog mo ang mga Levita sa aking harapan, ni Yahweh. Dapat ipatong ng mga tao ng Israel ang kanilang mga kamay sa mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Dapat ihandog ni Aaron ang mga Levita sa aking harapan, idulog mo sila na para bang itinaas sila sa kaniyang harapan, sa ngalan ng mga tao ng Israel. Dapat niyang gawin ito upang makapaglingkod sa akin ang mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Dapat ipatong ng mga Levita ang kanilang mga kamay sa ulo ng mga toro. Dapat kang maghandog ng isang toro bilang alay para sa kasalanan at ang ibang toro bilang alay na susunugin sa akin, upang ibayad sa kasalanan ng mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Idulog mo ang mga Levita sa harapan ni Aaron at sa harapan ng kaniyang mga anak, at itaas mo sila sa akin bilang handog. ");
INSERT INTO tglulb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Sa ganitong paraan dapat mong ihiwalay ang mga Levita mula sa mga tao ng Israel. Mapapabilang sa akin ang mga Levita. ");
INSERT INTO tglulb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Pagkatapos nito, dapat pumasok ang mga Levita upang maglingkod sa tolda ng pagpupulong. Dapat gawin mo silang dalisay. Dapat mo silang itaas sa akin bilang handog. ");
INSERT INTO tglulb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Gawin mo ito, dahil akin silang lahat mula sa mga tao ng Israel. Sila ang magiging kapalit ng bawat batang lalaking unang ipapanganak, ang panganay sa lahat ng kaapu-apuhan ng Israel. Kinuha ko ang mga Levita para sa aking sarili. ");
INSERT INTO tglulb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Sa akin ang lahat ng panganay mula sa mga tao ng Israel, kapwa mga tao at mga hayop. Sa araw na kinuha ko ang mga buhay ng lahat ng panganay sa lupain ng Ehipto, inilaan ko sila para sa aking sarili. ");
INSERT INTO tglulb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Kinuha ko ang mga Levita mula sa mga tao ng Israel sa halip na ang lahat ng panganay. ");
INSERT INTO tglulb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ibinigay ko ang mga Levita bilang isang regalo kay Aaron at sa kaniyang mga anak na lalaki. Kinuha ko sila mula sa mga tao ng Israel upang gawin ang gawain ng mga tao ng Israel sa tolda ng pagpupulong. Ibinigay ko sila upang magbayad ng kasalanan para sa mga tao ng Israel upang walang salot ang pipinsala sa mga tao kapag lumapit sila sa banal na lugar.” ");
INSERT INTO tglulb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ginawa ito nina Moises, Aaron, at ng buong sambayanan ng Israel kasama ang mga Levita. Ginawa nila ang lahat ng bagay na inutos ni Yahweh kay Moises ukol sa mga Levita. Ginawa ito ng mga tao ng Israel na kasama nila. ");
INSERT INTO tglulb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ginawang dalisay ng mga Levita ang kanilang sarili mula sa kasalanan sa pamamagitan ng paglalaba ng kanilang mga damit. Idinulog sila ni Aaron bilang isang handog kay Yahweh at ibinayad sila sa kasalanan para sa kanila, upang gawin silang dalisay. ");
INSERT INTO tglulb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Pagkatapos nito, pumasok ang mga Levita upang isagawa ang kanilang paglilingkod sa tolda ng pagpupulong sa harapan ni Aaron at sa harapan ng kaniyang mga anak na lalaki. Ito ang inutos ni Yahweh kay Moises tungkol sa mga Levita. Pinakitunguhan nila ang mga Levita sa ganitong paraan. ");
INSERT INTO tglulb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Muling nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Ang lahat ng ito ay para sa mga Levitang dalawampu't-limang taong gulang pataas. Dapat silang sumama sa mga samahan upang maglingkod sa tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Dapat silang tumigil sa paglilingkod sa paraang ganito sa gulang na limampung taon. Sa edad na iyan, hindi na sila dapat maglingkod pa. ");
INSERT INTO tglulb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Maaari nilang tulungan ang kanilang mga kapatid na patuloy na gumagawa sa tolda ng pagpupulong, ngunit hindi na sila dapat maglingkod pa. Dapat mong atasan ang mga Levita sa lahat ng bagay na ito.” ");
INSERT INTO tglulb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Nagsalita si Yahweh kay Moises sa ilang ng Sinai, sa unang buwan ng ikalawang taon matapos silang makalabas mula sa lupain ng Ehipto. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Hayaan mong panatilihin ng mga tao ng Israel ang Paskua sa nakatakdang panahon nito sa bawat taon. ");
INSERT INTO tglulb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Sa paglubog ng araw sa ikalabing-apat na araw ng buwang ito, dapat ninyong ipagdiwang ang Paskua sa nakatakdang panahon nito sa bawat taon. Dapat ninyong panatilihin ito, sundin ang lahat ng alituntunin at sumunod sa lahat ng utos na kaugnay rito.” ");
INSERT INTO tglulb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Kaya sinabi ni Moises sa mga tao ng Israel na dapat nilang panatilihin ang Pagdiriwang ng Paskua. ");
INSERT INTO tglulb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Kaya ipinagdiwangi nila ang Paskua sa unang buwan, sa gabi ng ikalabing-apat na araw ng buwan, sa ilang ng Sinai. Sinunod ng mga tao ng Israel ang lahat ng bagay na iniutos ni Yahweh kay Moises na kaniyang gawin. ");
INSERT INTO tglulb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","May ilang kalalakihang naging marumi sa pamamagitan ng patay na katawan ng isang tao. Hindi nila magawang ipagdiwang ang Paskua sa araw ding iyon, pinuntahan nila sina Moises at Aaron sa parehong araw na iyon. ");
INSERT INTO tglulb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Sinabi ng mga lalaking iyon kay Moises, “Marumi kami dahil sa patay na katawan ng isang tao. Bakit mo kami pinipigilan sa pag-aalay ng handog kay Yahweh sa panahon panahon ng bawat taon sa mga tao ng Israel?” ");
INSERT INTO tglulb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Sinabi ni Moises sa kanila, “Hintayin ninyo na marinig ko kung ano ang itatagubilin ni Yahweh tungkol sa inyo.” ");
INSERT INTO tglulb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Magsalita ka sa mga tao ng Israel. Sabihin mo, ''Kung sinuman sa inyo o sa inyong mga kaapu-apuhan ay marumi dahil sa isang patay na katawan, o nasa isang mahabang paglalakabay, maaari pa rin niyang ipagdiwang ang Paskua para kay Yahweh.' ");
INSERT INTO tglulb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Dapat nilang ipagdiwang ang Paskua sa ikalawang buwan sa gabi ng ikalabing-apat na araw. Dapat nilang kainin ito kasama ng tinapay na walang pampaalsa at mga gulay na mapait. ");
INSERT INTO tglulb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Wala silang dapat ititira nito hanggang sa umaga, ni dapat nilang baliin ang isang buto ng mga hayop. Dapat nilang sundin ang lahat ng alituntunin para sa Paskua. ");
INSERT INTO tglulb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ngunit sinumang taong malinis at wala sa isang paglalakbay, ngunit nabigong ipagdiwang ang Paskua, dapat itiwalag ang taong iyon mula sa kaniyang mga tao dahil hindi siya nag-alay ng handog na inatas ni Yahweh sa nakatakdang panahon ng bawat taon. Dapat dalhin ng taong iyon ang kaniyang kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Kung nakikitira ang isang dayuhan sa inyo at ipinagdiriwang ang Paskua sa karangalan ni Yahweh, dapat niyang panatilihin ito at gawin lahat ng kaniyang iniuutos, sinusunod ang mga alituntunin ng Paskua at sinusunod ang mga batas para rito. Dapat kayong magkaroon ng parehong batas para sa dayuhan at para sa lahat ng ipinanganak sa lupain.” ");
INSERT INTO tglulb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Sa araw na itinayo ang tabernakulo, binalot ng ulap ang tabernakulo, ang tolda ng kautusang tipan. Sa gabi nasa itaas ng tabernakulo ang ulap. Nagpakita ito na parang apoy hanggang sa umaga. ");
INSERT INTO tglulb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Nagpatuloy ito sa paraang ganito. Binalot ng ulap ang tabernakulo at nagpakita na parang apoy sa gabi. ");
INSERT INTO tglulb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Sa tuwing tumataas ang ulap mula sa ibabaw ng tolda, naghahanda sa paglalakbay ang mga tao ng Israel. Sa tuwing titiigil ang ulap, nagkakampo ang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Sa utos ni Yahweh, naglalakbay ang mga tao ng Israel, at sa kaniyang utos, nagkakampo sila. Habang nakatigil ang ulap sa ibabaw ng tabernakulo, nananatili sila sa kanilang kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kapag nananatili ang ulap sa tabernakulo ng maraming araw, maaaring sundin ng mga tao ng Israel ang mga tagubilin ni Yahweh at huwag maglakbay. ");
INSERT INTO tglulb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Minsan nananatili ang ulap ng kaunting araw sa tabernakulo. Sa panahong iyon, susundin nila ang utos ni Yahweh—magkakampo sila at maglalakbay muli sa kaniyang utos. ");
INSERT INTO tglulb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Minsan naroroon ang ulap sa kampo mula gabi hanggang sa umaga. Kapag tumataas ang ulap sa umaga, maglalakbay sila. Kung magpapatuloy ito ng isang araw at isang gabi, kapag tumaas lamang ang ulap na sila ay magpapatuloy sa paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kahit nananatili ang ulap sa tabernakulo ng dalawang araw, isang buwan o isang taon, habang nananatili ito roon, mananatili ang mga tao ng Israel sa kanilang kampo at hindi maglalakbay. Ngunit kapag tumaas ang ulap, nagpapatuloy sila sa kanilang paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Maaari silang magkampo sa utos ni Yahweh at maglalakaby sa kaniyang utos. Sinusunod nila ang utos ni Yahweh sa pamamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Gumawa ka ng dalawang trumpetang pilak. Pandayin mo ang pilak upang makagawa ng mga ito. Dapat gamitin mo ang mga trumpeta upang tawagin ang sambayanan nang sama-sama at upang sabihin sa sambayanang ilipat ang kanilang mga kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Dapat hipan ng mga pari ang mga trumpeta upang tipunin ang buong sambayanan sa iyong harapan sa pasukan ng tolda ng pagpupulong. ");
INSERT INTO tglulb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kung isang trumpeta lamang ang hihipan ng mga pari, ang mga pinuno, ang mga pangulo ng mga angkan ng Israel ay dapat magkatipon sa iyo. ");
INSERT INTO tglulb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kapag humihip ka ng isang malakas na hudyat, ang mga kampo sa silangang dako ay dapat nilang simulan ang paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kapag humihip kayo ng isang malakas na hudyat sa pangalawang pagkakaton, ang mga kampo sa katimugang dako ay dapat nilang simulan ang kanilang paglalakbay. Dapat humihip sila ng isang malakas na hudyat para sa kanilang mga paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Kapag nagtitipun-tipon ang sambayanan, hipan mo ang mga trumpeta, ngunit mahina. ");
INSERT INTO tglulb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Dapat hipan ng mga lalaking anak ni Aaron na mga pari, ang mga trumpeta. Palagi itong magiging isang kautusan para sa inyo sa kabuuan ng salinlahi ng inyong mga tao. ");
INSERT INTO tglulb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Kapag pumunta kayo sa digmaan sa inyong lupain laban sa isang kaaway na nagmamalupit sa inyo, dapat kayong magpatunog ng isang hudyat gamit ang mga trumpeta. Ako, si Yahweh, ang inyong Diyos, aalalahanin ko kayo at ililigtas mula sa inyong mga kaaway. ");
INSERT INTO tglulb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Gayundin, sa oras ng pagdiriwang, kapwa ang inyong karaniwang mga pagdiriwang at sa simula ng mga buwan, dapat hipan ninyo ang mga trumpeta sa karangalan ng inyong mga alay na susunugin at sa mga alay para sa inyong handog para sa pagtitipon-tipon. Magsisilbi itong alaala ninyo sa akin, na inyong Diyos. Ako si Yahweh, na inyong Diyos.” ");
INSERT INTO tglulb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Sa ikalawang taon, sa ikalawang buwan, sa ikadalawampung araw ng buwan, ang ulap ay tumaas mula sa tabernakulo ng toldang tipanan. ");
INSERT INTO tglulb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Patuloy ang mga tao ng Israel sa kanilang paglalakbay mula sa ilang ng Sinai. Huminto ang ulap sa ilang ng Paran. ");
INSERT INTO tglulb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Nagawa nila ang kanilang unang paglalakbay, sinusunod nila ang utos ni Yahweh na kaniyang ibinigay sa pamagitan ni Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ang kampong nasa ilalim ng bandila ng mga kaapu-apuhan ni Juda ang unang lumabas, inilabas nila ang kani-kanilang mga hukbo. Si Naason na anak ni Aminadab ang nanguna sa hukbo ni Juda. ");
INSERT INTO tglulb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Si Nathanel na anak ni Zuar ang nanguna sa hukbo ng tribu ng mga kaapu-apuhan ni Isacar. ");
INSERT INTO tglulb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Si Eliab na anak ni Helon ang nanguna sa hukbo ng tribui ng mga kaapu-apuhan ni Zebulun. ");
INSERT INTO tglulb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ang mga kaapu-apuhan nina Gerson at Merari, na siyang nangalaga sa tabernakulo, ang kumuha sa tabernakulo at inihanda para sa kanilang paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Sumunod, ang mga hukbo na nasa ilalim ng bandila ng kampo ni Ruben ang humayo sa kanilang paglalabay. Si Elizur na anak ni Seduer ang nanguna sa hukbo ni Ruben. ");
INSERT INTO tglulb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Si Selumiel na anak ni Zurisaddai ang nanguna sa hukbo ng tribu ng mga kaapu-apuhan ni Simeon. ");
INSERT INTO tglulb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Si Eliasaf na anak ni Deuel ang nanguna sa hukbo ng tribu ng mga kaapu-apuhan ni Gad. ");
INSERT INTO tglulb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Humayo ang mga tribu ni Kohatita. Dinala nila ang kagamitan ng banal na santuwaryo. Nagtayo ang iba ng kanilang tabernakulo bago dumating ang mga Kohatita sa kasunod na kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ang mga hukbo na nasa ilalim ng bandila ng mga kaapu-apuhan ni Efraim ang sumunod na humayo. Si Elisama na lalaking anak ni Ammiud ang nanguna sa hukbo ni Efraim. ");
INSERT INTO tglulb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Si Gamaliel na lalaking anak ni Pedasur ang nanguna sa hukbo ng tribu ng mga kaapu-apuhan ni Manases. ");
INSERT INTO tglulb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Si Abidan na lalaking anak ni Gideon ang nanguna sa hukbo ng tribu ng mga kaapu-apuhan ni Benjamin. ");
INSERT INTO tglulb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ang mga hukbong nagkampo sa ilalim ng bandila ng kaapu-apuhan ni Dan ang huling lumabas. Si Ahieser na lalaking anak ni Amisaddai ang nanguna sa hukbo ni Dan. ");
INSERT INTO tglulb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Si Pagiel na lalaking anak ni Okran ang nanguna sa hukbo ng tribu ng mga kaapu-apuhan ni Aser. ");
INSERT INTO tglulb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Si Ahira na lalaking anak ni Enan ang nanguna sa hukbo ng tribu ng mga kaapu-apuhan ni Neftali. ");
INSERT INTO tglulb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ito ang paraan ng mga hukbo ng mga tao ng Israel sa paghayo sa kanilang paglalakbay. ");
INSERT INTO tglulb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Nagsalita si Moises kay Hobab na lalaking anak ni Ruel na Medianita. Si Ruel ay ama ng asawa ni Moises. Nagsalita si Moises kay Hobab at sinabi, “Maglalakbay kami sa isang lugar na inilarawan ni Yahweh. Sinabi ni Yahweh, 'Ibibigay ko ito sa inyo.' Sumama ka sa amin at gagawan ka namin ng mabuti. Ipinangako ni Yahweh na gagawa siya ng mabuti sa Israel.” ");
INSERT INTO tglulb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ngunit sinabi ni Hobab kay Moises, “Hindi ako sasama sa inyo. Pupunta ako sa aking sariling lupain at sa aking sariling mga tao.” ");
INSERT INTO tglulb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","At sumagot si Moises, “Pakiusap, huwag mo kaming iwan. Alam mo kung paano magkampo sa ilang. Dapat bantayan mo kami. ");
INSERT INTO tglulb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kung sasama ka sa amin, gagawin namin sa iyo ang parehong kabutihang ginawa ni Yahweh sa amin.” ");
INSERT INTO tglulb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Naglakbay sila sa loob ng tatlong araw mula sa bundok ni Yahweh. Nauna sa kanila ang kaban ng tipan ni Yahweh nang tatlong araw upang maghanap ng lugar na maaari nilang mapagpahingahan. ");
INSERT INTO tglulb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Nasa itaas nila ang ulap ni Yahweh sa araw habang naglalakbay sila. ");
INSERT INTO tglulb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sa tuwing ilalabas ang kaban, sasabihin ni Moises, “Tumindig ka, Yahweh. Ikalat mo ang iyong mga kaaway. Palayasin mo ang mga taong napopoot sa iyo.” ");
INSERT INTO tglulb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Sa tuwing hihinto ang kaban, sasabihin ni Moises, “Bumalik ka, Yahweh, sa libu-libong Israelita.” ");
INSERT INTO tglulb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ngayon nagreklamo ang mga tao tungkol sa kanilang mga kabalisahan habang nakikinig si Yahweh. Narinig ni Yahweh ang mga tao at nagalit. Nagliyab sa kanila ang apoy na mula kay Yahweh at tinupok ang ilang bahagi ng kampo sa mga gilid nito. ");
INSERT INTO tglulb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Pagkatapos tumawag ang mga tao kay Moises, kaya nanalangin si Moises kay Yahweh, at huminto ang apoy. ");
INSERT INTO tglulb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Pinangalanan ang lugar na iyon na Tabera, sapagkat nagliyab ang apoy ni Yahweh sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ilang dayuhan ang nagsimulang magkampo kasama ang mga kaapu-apuhan ng Israel. Gusto nilang kumain ng masasarap na pagkain. Pagkatapos nagsimulang umiyak ang mga tao ng Israel at sinabi, “Sino ang magbibigay sa atin ng karne na kakainin? ");
INSERT INTO tglulb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Naaalala namin ang isda na kinain namin nang libre sa Ehipto, ang mga pipino, mga pakwan, mga dahon ng sibuyas o lasuna, ang mga sibuyas, at bawang. ");
INSERT INTO tglulb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ngayon nanghihina kami. Wala kaming makitang makakain kundi manna.” ");
INSERT INTO tglulb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ang manna ay kahalintulad ng buto ng kulantro. Ito ay parang dagta. ");
INSERT INTO tglulb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ang mga tao ay naglalakad sa paligid at tinitipon ito. Ginigiling nila ito sa mga gilingan, binabayo ito sa mga bayuhan, pinakukuluan ito sa mga palayok, at ginagawang keyk. Ang lasa nito ay parang sariwang langis ng olibo. ");
INSERT INTO tglulb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kapag bumaba ang hamog sa kampo sa gabi, bumabagsak din ang manna. ");
INSERT INTO tglulb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Narinig ni Moises ang iyakan ng mga tao sa kanilang mga pamilya, at ang bawat lalaki ay naroon sa pasukan sa kaniyang tolda. Labis na nagalit si Yahweh, at sa mga mata ni Moises ang pagrereklamo nila ay mali. ");
INSERT INTO tglulb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Sinabi ni Moises kay Yahweh, “Bakit mo pinakitunguhan ang iyong lingkod ng masama? Bakit hindi ka nasisiyahan sa akin? Ipinapasan mo sa akin ang pasanin ng lahat ng taong ito. Ipinagbuntis ko ba ang lahat ng mga taong ito? ");
INSERT INTO tglulb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ako ba ang nagsilang sa kanila upang sabihin mo sa akin, 'Dalhin mo sila sa iyong kandungan tulad ng pagdadala ng isang ama sa isang sanggol?' Kailangan ko ba silang dalhin sa lupain na iyong ipinangako sa kanilang mga ninuno upang ibigay sa kanila? ");
INSERT INTO tglulb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Saan ako makakahanap ng karne na ibibigay ko sa lahat ng taong ito? Umiiyak sila sa aking harapan at sinasabin, 'Bigyan mo kami ng karneng kakainin.' ");
INSERT INTO tglulb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Hindi ko na madalang mag-isa ang mga taong ito. Sobra na sila para sa akin. ");
INSERT INTO tglulb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Yamang pinakikitunguhan mo ako sa ganitong paraan, patayin mo na ako ngayon, kung mabait ka sa akin, at alisin ang aking paghihirap.” ");
INSERT INTO tglulb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Sinabi ni Yahweh kay Moises, “Dalhin mo sa akin ang pitumpung nakakatanda ng Israel. Tiyaking sila ang mga nakakatanda at mga opisyal ng mga tao. Dalhin mo sila sa tolda ng pagpupulong upang tumayo roong kasama mo. ");
INSERT INTO tglulb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Bababa ako at kakausapin ko kayo roon. Kukunin ko ang ilan sa Espiritu na nasa iyo at ilalagay ko ito sa kanila. Dadalhin nila ang pagpapahirap ng mga tao kasama mo. Hindi mo na dadalhin itong mag-isa. ");
INSERT INTO tglulb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Sabihin mo sa mga tao, 'Italaga ninyo ang inyong mga sarili kay Yahweh bukas. Tunay na kakakain kayo ng karne, sapagkat umiyak kayo sa pandinig ni Yahweh. Sinabi ninyo, “Sino ang magbibigay sa atin ng karne upang ating kainin? Naging mabuti ito para sa atin sa Ehipto.” Kaya bibigyan kayo ni Yahweh ng karne, at kakainin ninyo ito. ");
INSERT INTO tglulb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hindi lamang kayo kakain ng karne sa loob ng isang araw, sa dalawang araw, sa limang araw, sa sampung araw, o sa dalawampung araw, ");
INSERT INTO tglulb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ngunit kakain kayo ng karne sa loob ng buong isang buwan hanggang sa ito ay lumabas sa inyong mga ilong. Ito ang magpapadiri sa inyo dahil itinakwil ninyo si Yahweh, na siyang kasama ninyo. Umiyak kayo sa kaniyang harapan. Sinabi ninyo, “Bakit pa natin iniwan ang Ehipto?'''''' ");
INSERT INTO tglulb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Pagkatapos sinabi ni Moises, “Kasama ko ang 600, 000 na katao, at sinabi mo, 'Bibigyan ko sila ng karne sa loob ng isang buong buwan.' ");
INSERT INTO tglulb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Papatay ba kami ng kawan ng mga tupa at kawan ng mga baka upang magkasya sa kanila? Huhulihin ba namin ang lahat ng isda sa karagatan upang magkasya sa kanila?'' ");
INSERT INTO tglulb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Sinabi ni Yahweh kay Moises, “Maiksi ba ang kamay ko? Ngayon makikita mo kung totoo ang aking salita.'' ");
INSERT INTO tglulb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Lumabas si Moises sa tolda at sinabi niya sa mga tao ang mga salita ni Yahweh. Tinipon niya ang pitumpu sa mga nakakatanda ng mga tao at pumalibot sila sa tolda. ");
INSERT INTO tglulb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Bumaba si Yahweh sa ulap at nagsalita kay Moises. Kinuha ni Yahweh ang ilan sa Espiritu na naroon kay Moises at nilagay ito sa pitumpung nakakatanda. Nang tumahan ang Espiritu sa kanila, nagpahayag sila, ngunit sa pagkakataong iyon lamang at hindi na naulit pa. ");
INSERT INTO tglulb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Dalawang lalaking nagngangalang Eldab at Medad ang naiwan sa kampo. Tumahan din sa kanila ang Espiritu. Nakasulat ang kanilang pangalan sa listahan, ngunit hindi sila lumabas sa tolda. Gayon pa man, nagpahayag sila sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Isang binatang nasa kampo ang tumakbo at sinabi kay Moises, “Sina Eldad at Medad ay nagpapahayag sa kampo.” ");
INSERT INTO tglulb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Si Josue na lalaking anak ni Nun, ang tagapangasiwa ni Moises, ang isa sa mga lalaking pinili ang nagsabi kay Moises, “Aking among Moises, pigilan mo sila.” ");
INSERT INTO tglulb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Sinabi ni Moises sa kaniya, “Naninibugho ka ba para sa kapakanan ko? Nais kong lahat ng tao ni Yahweh ay mga propeta at ilagay niya ang kaniyang Espiritu sa kanilang lahat!'' ");
INSERT INTO tglulb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","At bumalik sa kampo si Moises at ang mga nakakatanda ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Pagkatapos, isang hangin ang dumating mula kay Yahweh at nagdala ng pugo mula sa dagat. Bumagsak ang mga ito malapit sa kampo, na may isang araw na paglalakbay sa isang dako at isang araw na paglalakbay sa kabilang dako. Pumalibot ang mga pugo sa kampo na may dalawang siko ang taas mula sa lupa. ");
INSERT INTO tglulb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ang mga tao ay abala sa paghuhuli sa mga pugo ng buong araw, buong gabi, at sa sumunod na araw. Walang nanghuli ng mas kaunti sa sampung homer ng pugo. Ibinahagi nila ang mga pugo sa buong kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Habang nasa pagitan pa ng kanilang ngipin ang karne, habang nginunguya nila ito, nagalit si Yahweh sa kanila. Pinadalhan niya ang mga tao ng isang napakatinding sakit. ");
INSERT INTO tglulb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Pinangalanan ang lugar na iyon na Kibrot-hataava dahil doon nila inilibing ang mga taong nanabik sa karne. ");
INSERT INTO tglulb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Mula sa Kibrot-hataava, naglakbay ang mga tao patungong Hazerot, kung saan sila nanatili. ");
INSERT INTO tglulb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Pagkatapos, nagsalita sina Miriam at Aaron laban kay Moises dahil sa isang babaeng taga-Cus na napangasawa niya. ");
INSERT INTO tglulb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Sinabi nila, “Kay Moises lamang ba nagsalita si Yahweh? Hindi rin ba siya nagsalita sa amin?” Ngayon narinig ni Yahweh kung ano ang kanilang sinabi. ");
INSERT INTO tglulb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ngayon ang lalaking si Moises ay lubos na mapagpakumbaba, higit pa sa sinuman sa mundo. ");
INSERT INTO tglulb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Agad-agad nagsalita si Yahweh kay Moises, Aaron at Miriam: “Lumabas kayong tatlo, sa tolda ng pagpupulong.” Kaya lumabas silang tatlo. ");
INSERT INTO tglulb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Pagkatapos, bumaba si Yahweh sa isang haligi ng ulap. Tumayo siya sa pasukan ng tolda at tinawag sina Aaron at Miriam. Kapwa sila lumapit. ");
INSERT INTO tglulb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Sinabi ni Yahweh, “Ngayon makinig kayo sa aking mga salita. Kapag kasama ninyo ang aking propeta, inihahayag ko ang aking sarili sa kaniya sa mga pangitain at nagsasalita ako sa kaniya sa mga panaginip. ");
INSERT INTO tglulb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Hindi ganyan ang aking lingkod na si Moises. Matapat siya sa lahat ng aking sambahayan. ");
INSERT INTO tglulb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Tuwiran akong nagsasalita kay Moises, hindi sa pamamagitan ng mga pangitain o mga bugtong. Nakikita niya ang aking anyo. Kaya bakit hindi kayo takot na magsalita laban sa aking lingkod, laban kay Moises?” ");
INSERT INTO tglulb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nag-alab ang galit ni Yahweh laban sa kanila at iniwan niya sila. ");
INSERT INTO tglulb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Pumaitaas ang ulap mula sa ibabaw ng tolda, at biglang naging ketongin si Miriam—pumuti siya kagaya ng niyebe. Nang lumingon si Aaron kay Miriam, nakita niya na nagkaroon siya ng ketong. ");
INSERT INTO tglulb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Sinabi ni Aaron kay Moises, “Oh aking panginoon, pakiusap, huwag mong ipataw ang kasalanang ito laban sa amin. Nagsalita kami nang may kahangalan, at nagkasala kami. ");
INSERT INTO tglulb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Pakiusap huwag siyang hayaang matulad sa isang patay na bagong silang na naubos ang kalahati ng laman nang lumabas mula sa sinapupunan ng kaniyang ina.” ");
INSERT INTO tglulb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Kaya tumawag si Moises kay Yahweh. Sinabi niya, “Pakiusap pagalingin mo siya, oh Diyos, pakiusap.” ");
INSERT INTO tglulb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Sinabi ni Yahweh kay Moises, “Kung duraan ng kaniyang ama ang kaniyang mukha, mapapahiya siya sa loob ng pitong araw. Huwag ninyo siyang papasukin sa kampo sa loob ng pitong araw. Pagkatapos nito, papasukin siyang muli.” ");
INSERT INTO tglulb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Kaya pinanatili si Miriam sa labas ng kampo sa loob ng pitong araw. Hindi naglakbay ang mga tao hanggang sa makabalik siya sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Pagkatapos nito, naglakbay ang mga tao mula Hazerot at nagkampo sa ilang ng Paran. ");
INSERT INTO tglulb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Pagkatapos, nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Magpadala ka ng ilang kalalakihan upang suriin ang lupain ng Canaan na aking ibinigay sa mga tao ng Israel. Magpadala ka ng isang lalaki mula sa bawat tribu ng kanilang mga ninuno. Dapat pinuno ang bawat lalaki sa kanilang mga grupo.” ");
INSERT INTO tglulb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ipinadala sila ni Moises mula sa ilang ng Paran, upang masunod nila ang utos ni Yahweh. Lahat sila ay mga pinuno sa mga tao ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ito ang kanilang mga pangalan: mula sa tribu ni Ruben, Sammua na lalaking anak ni Zaccur. ");
INSERT INTO tglulb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Mula sa tribu ni Simeon, si Safat na lalaking anak ni Hori. ");
INSERT INTO tglulb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Mula sa tribu ni Juda, si Caleb na lalaking anak ni Jefune. ");
INSERT INTO tglulb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Mula sa tribu ni Isacar, si Igal na lalaking anak ni Jose. ");
INSERT INTO tglulb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Mula sa tribu ni Efraim, si Hosea na lalaking anak ni Nun. ");
INSERT INTO tglulb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Mula sa tribu ni Benjamin, si Palti na lalaking anak ni Rafu. ");
INSERT INTO tglulb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Mula sa tribu ni Zebulon, Gadiel na lalaking anak ni Sodi. ");
INSERT INTO tglulb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Mula sa mga kaapu-apuhan ni Jose na nagngangalang: Gaddi na anak ni Susi mula sa tribu ni Manases, ");
INSERT INTO tglulb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Mula sa tribu ni Dan, si Ammiel na lalaking anak ni Gemalli. ");
INSERT INTO tglulb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Mula sa tribu ni Aser, si Setur na lalaking anak ni Micael. ");
INSERT INTO tglulb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Mula sa tribu ni Neftali, si Nahabi na lalaking anak ni Vapsi. ");
INSERT INTO tglulb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Mula sa tribu ni Gad, si Geuel na lalaking anak ni Maki. ");
INSERT INTO tglulb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ito ang mga pangalan ng mga lalaking ipinadala ni Moises upang suriin ang lupain. Tinawag ni Moises si Hosea na lalaking anak ni Nun sa pangalang Josue. ");
INSERT INTO tglulb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ipinadala sila ni Moises upang suriin ang lupain ng Canaan. Sinabi niya sa kanila, “Pumunta kayo sa Negev at umakyat kayo sa maburol na lugar. ");
INSERT INTO tglulb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Suriin ninyo ang lupain upang makita kung ano ang katulad nito. Matiyagan ninyo ang mga taong nakatira roon, kung malakas o mahihina sila, at kung kaunti o marami sila. ");
INSERT INTO tglulb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Tingnan kung anong uri ng lupain ang kanilang tinitirhan. Ito ba ay maganda o hindi? Anong klase ng mga lungsod ang naroon? Tulad ba ito ng mga kampo o ang mga ito ba ay pinatibay na lungsod? ");
INSERT INTO tglulb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Tingnan kung anong uri ng lupa, kung ito ba ay mainam para sa pagpapalago ng pananim o hindi, at kung may mga puno roon o wala. Maging matapang at mag-uwi kayo ng mga bunga ng lupa.” Ngayon ay panahon para sa mga unang hinog na ubas. ");
INSERT INTO tglulb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Kaya umakyat ang mga kalalakihan at sinuri ang lupain mula sa ilang ng Sin hanggang Rehob, malapit sa Lebo Hamat. ");
INSERT INTO tglulb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Umakyat sila mula sa Negev at dumating sa Hebron. Naroon ang mga Ahiman, Sesai, at Talmai, mga angkan na nagmula kay Anak. Ngayon, ang Hebron ay itinayo, pitong taon na bago ang Zoan sa Ehipto. ");
INSERT INTO tglulb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Nang dumating sila sa lambak ng Escol, pumutol sila ng isang sangang may kumpol ng ubas. Pinasan nila ito sa isang tungkod sa pagitan ng dalawa sa kanilang pangkat. Nagdala rin sila ng mga bunga ng granada at igos. ");
INSERT INTO tglulb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Pinangalanan ang lugar na iyon na lambak ng Escol, dahil sa kumpol ng ubas na pinutol ng mga Israelita doon. ");
INSERT INTO tglulb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Bumalik sila pagkalipas ng apatnapung araw mula sa pagsusuri sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Bumalik sila kina Moises, Aaron at sa buong sambayanan ng Israel sa ilang ng Paran sa Kades. Nagdala sila ng ulat sa kanila at sa buong sambayanan, at ipinakita sa kanila ang bunga na nagmula sa lupain. ");
INSERT INTO tglulb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Sinabi nila kay Moises, “Narating namin ang lupain kung saan mo kami ipinadala. Tunay na dinadaluyan ito ng gatas at pulot-pukyutan. Narito ang ilan sa mga bunga mula roon. ");
INSERT INTO tglulb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Gayunman, ang mga taong nagtayo ng kanilang tahanan doon ay malalakas. Pinatibay at napakalawak ng kanilang mga lungsod. Nakita rin namin doon ang mga kaapu-apuhan ni Anak. Nakatira ang mga Amalekita sa Negev. ");
INSERT INTO tglulb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Naroon ang mga tahanan ng mga Hiteo, Jebuseo, at mga Amoreo sa burol na lugar. Naninirahan ang mga Cananeo malapit sa dagat at sa tabi ng Ilog Jordan.” ");
INSERT INTO tglulb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Sinubukan ni Caleb na palakasin ang loob ng mga taong nakapalibot kay Moises. Sinabi niya, “Lusubin natin nang minsanan at kunin ito, dahil kayang-kaya nating sakupin ito.” ");
INSERT INTO tglulb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ngunit sinabi ng ibang kalalakihang pumunta kasama niya, “Hindi natin kayang lusubin ang mga tao dahil mas malakas sila kaysa sa atin.” ");
INSERT INTO tglulb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Kaya ikinalat nila ang nakakapanghina ng loob na ulat sa mga tao ng Israel tungkol sa lupain na kanilang sinuri. Sinabi nila, “Ang lupain na aming tiningnan ay isang lupaing umuubos ng mga mamamayan nito. Matatangkad ang lahat ng mga taong nakita namin doon. ");
INSERT INTO tglulb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nakita namin doon ang mga higante, mga kaapu-apuhan ni Anak, mga taong nagmula sa mga higante. Para kaming mga tipaklong sa aming paningin kung ihambing sa kanila, at maaaring ganoon din kami sa kanilang paningin.” ");
INSERT INTO tglulb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Umiyak nang malakas ang sambayanan sa gabing iyon. ");
INSERT INTO tglulb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Pinuna ng lahat ng mga tao ng Israel sina Moises at Aaron. Sinabi ng buong sambayanan sa kanila, “Nais naming kami ay namatay na lang sa lupain ng Ehipto, o dito sa ilang! ");
INSERT INTO tglulb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Bakit tayo dinala ni Yahweh sa lupaing ito upang mamatay sa pamamagitan ng espada? Ang ating mga asawa at mga maliliit na anak ay magiging mga biktima. Hindi ba mas mabuti para sa atin na bumalik sa Ehipto?” ");
INSERT INTO tglulb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Sinabi nila sa bawat isa, “Pumili tayo ng isa pang pinuno at bumalik tayo sa Ehipto.” ");
INSERT INTO tglulb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","At nagpatirapa sina Moises at Aaron sa harapan ng buong kapulungan ng sambayanan ng mga tao ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Si Josue na anak na lalaki ni Nun at si Caleb na anak na lalaki ni Jefune ay pinunit ang kanilang mga damit, ang ilan sa mga ipinadala upang suriin ang lupain. ");
INSERT INTO tglulb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Nagsalita sila sa buong sambayanan ng mga tao ng Israel. Sinabi nila, “Isang napakabuting lupain ang aming dinaanan at siniyasat. ");
INSERT INTO tglulb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kung nalulugod si Yahweh sa atin, sa gayon dadalhin niya tayo sa lupaing ito at ibibigay ito sa atin. Dinadaluyan ang lupain ng gatas at pulot-pukyutan. ");
INSERT INTO tglulb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ngunit huwag kayong maghimagsik laban kay Yahweh at huwag kayong matakot sa mga tao ng lupain. Uubusin natin sila na kasindali ng pagkain. Maaalis mula sa kanila ang kanilang pananggalang, dahil kasama natin si Yahweh. Huwag ninyo silang katakutan.” ");
INSERT INTO tglulb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ngunit tinangka ng buong sambayanan na pagbabatuhin sila hanggang mamatay. Pagkatapos, lumitaw ang kaluwalhatian ni Yahweh sa tolda ng pagpupulong sa lahat ng mga tao ng Israel. ");
INSERT INTO tglulb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Sinabi ni Yahweh kay Moises, “Hanggang kailan ba ako kamumuhian ng mga taong ito? Hanggang kailan sila mabibigong magtiwala sa akin, sa kabila ng lahat ng palatandaan ng aking kapangyarihan na aking ginawa sa kanila? ");
INSERT INTO tglulb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Lulusubin ko sila ng salot, hindi ko sila pamamanahan at gagawa ako mula sa iyong angkan ng isang bansa na magiging higit na dakila at mas malakas kaysa sa kanila.” ");
INSERT INTO tglulb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Sinabi ni Moises kay Yahweh, “Kung gagawin mo ito, maririnig ng mga taga-Ehipto ang tungkol dito, dahil sinagip mo ang mga tao mula sa kanila sa pamamagitan ng iyong kapangyarihan. ");
INSERT INTO tglulb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Sasabihin nila ito sa mga naninirahan sa lupain. Maririnig nila na ikaw, Yahweh ay kapiling ng mga taong ito, dahil nakita ka nila nang harapan. Nasa itaas ng iyong mga tao ang iyong ulap. Pinangungunahan mo sila sa isang haligi ng ulap sa araw at isang haligi ng apoy sa gabi. ");
INSERT INTO tglulb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ngayon, kung papatayin mo ang mga taong ito gaya ng isang tao, ang mga bansang nakarinig sa iyong katanyagan ay magsasalita at sasabihin, ");
INSERT INTO tglulb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","'Dahil hindi magawang dalhin ni Yahweh ang mga taong ito sa lupaing kaniyang ipinangakong ibigay sa kanila, pinatay niya sila sa ilang.' ");
INSERT INTO tglulb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ngayon, nagmamakaawa ako sa iyo, gamitin mo ang iyong dakilang kapangyarihan. Sapagkat sinabi mo, ");
INSERT INTO tglulb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","banayad si Yahweh kung magalit at sagana sa tipan ng katapatan. Pinapatawad niya ang kasamaan at pagsuway. Hindi siya magpapawalang sala kapag dadalhin niya ang parusa ng kasalanan ng mga ninuno sa kanilang mga kaapu-apuhan, hanggang sa ikatlo at ikaapat na salinlahi.' ");
INSERT INTO tglulb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Patawad, nakikiusap ako sa iyo, itong kasalanan ng mga tao dahil sa kadakilaan ng iyong tipan ng katapatan, tulad ng palagi mong pagpapatawad sa mga taong ito mula sa panahong nasa Ehipto sila hanggang ngayon.” ");
INSERT INTO tglulb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Sinabi ni Yahweh, “Pinatawad ko na sila ayon sa iyong kahilingan, ");
INSERT INTO tglulb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ngunit totoo, habang nabubuhay ako at habang napupuno ang buong mundo ng aking kaluwalhatian, ");
INSERT INTO tglulb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","lahat ng mga taong iyon na nakakita ng aking kaluwalhatian at sa mga palatandaan ng aking kapangyarihang ginawa ko sa Ehipto at sa ilang—tinutukso pa rin nila ako ng sampung beses at hindi nakinig sa aking tinig. ");
INSERT INTO tglulb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Kaya sinabi kong tiyak na hindi nila makikita ang lupaing aking ipinangako sa kanilang mga ninuno. Wala ni isa sa kanilang namuhi sa akin ang makakakita nito, ");
INSERT INTO tglulb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","maliban kay Caleb na aking lingkod, dahil mayroon siyang ibang espiritu. Sinunod niya ako ng ganap; Dadalhin ko siya sa lupaing kaniyang pinuntahan upang suriin. Aangkinin ito ng kaniyang mga kaapu-apuhan. ");
INSERT INTO tglulb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Ngayon nakatira ang mga Amalekita at mga Cananeo sa lambak.) Bukas lumiko kayo at pumunta sa ilang sa pamamagitan ng daan ng Dagat ng mga Tambo.” ");
INSERT INTO tglulb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Nagsalita si Yahweh kay Moises at kay Aaron. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Hanggang kailan ko ba dapat tiisin itong masamang sambayanang bumabatikos sa akin? Narinig ko ang mga pagrereklamo ng mga tao ng Israel laban sa akin. ");
INSERT INTO tglulb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sabihin mo sa kanila, 'Dahil ako ay buhay,' sinabi ni Yahweh, 'ayon sa sinabi mo sa aking pandinig, gagawin ko ito sa inyo: ");
INSERT INTO tglulb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Babagsak ang inyong mga patay na katawan sa ilang na ito, lahat kayong nagreklamo laban sa akin, kayong nabilang na sa sensus, ang kabuoang bilang ng mga tao mula sa dalawampung taon pataas. ");
INSERT INTO tglulb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Tiyak na hindi kayo makakapunta sa lupaing aking ipinangako upang gawin ninyong tahanan, maliban kay Caleb na lalaking anak ni Jefune at Josue na lalaking anak ni Nun. ");
INSERT INTO tglulb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ngunit ang inyong mga maliliit na anak na sinasabi ninyong magiging mga biktima, dadalhin ko sila sa lupain. Mararanasan nila ang lupaing inyong tinanggihan! ");
INSERT INTO tglulb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","At para sa inyo, babagsak sa ilang na ito ang mga patay ninyong katawan. ");
INSERT INTO tglulb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Magiging pagala-gala ang inyong mga anak sa ilang sa loob ng apatnapung taon. Dapat nilang dalhin ang bunga ng inyong paghihimagsik hanggang sa patayin ng ilang ang inyong mga katawan. ");
INSERT INTO tglulb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Tulad ng bilang ng mga araw na sinuri ninyo ang lupain—apatnapung araw, dapat din ninyong dalhin ang bunga ng inyong mga kasalanan sa loob ng apatnapung taon—isang taon sa bawat araw at dapat ninyong malaman kung ano ang katulad ng maging aking kaaway. ");
INSERT INTO tglulb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Akong, si Yahweh, ang nagsalita. Tiyak na gagawin ko ito sa buong masamang sambayanang ito na nagtipun-tipon laban sa akin. Mauubos sila sa ilang na ito. Dito sila mamamatay.'” ");
INSERT INTO tglulb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Kaya namatay lahat ng lalaking ipinadala ni Moises upang tingnan ang lupain sa pamamagitan ng salot sa harapan ni Yahweh. Ito ang mga lalaking bumalik at nagdala ng isang masamang ulat tungkol sa lupain. Sila ang nagdulot sa buong sambayanan na magreklamo laban kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mula sa mga lalaking pumunta upang tingnan ang lupain, tanging si Josue na anak na lalaki ni Nun at si Caleb na anak na lalaki ni Jefune ang natirang buhay. ");
INSERT INTO tglulb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Nang iulat ni Moises ang mga salitang ito sa lahat ng tao ng Israel, nagluksa sila ng napakatindi. ");
INSERT INTO tglulb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Bumangon sila nang maaga at pumunta sa tuktok ng bundok at sinabi, “Tingnan mo, narito kami at pupunta kami sa lugar na ipinangako ni Yahweh, sapagkat nagkasala kami.” ");
INSERT INTO tglulb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ngunit sinabi ni Moises, “Bakit sinusuway ninyo ngayon ang utos ni Yahweh? Hindi kayo magtatagumpay. ");
INSERT INTO tglulb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Huwag kayong umalis, dahil hindi ninyo kasama si Yahweh upang pigilan kayo mula sa pagkakatalo sa pamamagitan ng inyong mga kaaway. ");
INSERT INTO tglulb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Nandoon ang mga Amalekita at mga Cananeo at mamamatay kayo sa pamamagitan ng espada dahil tumalikod kayo mula sa pagsunod kay Yahweh. Kaya hindi niya kayo sasamahan.” ");
INSERT INTO tglulb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ngunit nagpumilit silang umakyat sa maburol na lugar; gayunpaman, hindi umalis si Moises ni ang kaban ng tipan ni Yahweh mula sa kampo. ");
INSERT INTO tglulb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Bumaba ang mga Amalekita at gayundin ang mga Cananeo na nakatira sa mga burol na iyon. Nilusob nila ang mga Israelita at tinalo silang lahat hanggang sa daan patungo ng Horma. ");
INSERT INTO tglulb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Pagkatapos, nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Magsalita ka sa mga tao ng Israel at sabihin mo sa kanila, 'Kapag pumasok kayo sa lupain kung saan kayo maninirahan, na ibibigay ni Yahweh sa inyo— ");
INSERT INTO tglulb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","at kapag maghandog kayo ng isang handog sa pamamagitan ng apoy para sa kaniya—maging isang alay na susunugin, o isang alay para sa isang panata o isang kusang handog, o isang handog sa inyong mga pagdiriwang, upang magdulot ng isang mabangong halimuyak para kay Yahweh mula sa kawan o pangkat ng hayop— ");
INSERT INTO tglulb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","dapat maghandog kay Yahweh ang isang taong nagdadala ng alay ng isang handog na butil ng ikasampu na epa ng pinong harinang hinaluan ng ikaapat na hin ng langis. ");
INSERT INTO tglulb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Dapat din kayong maghanda ng ikaapat na hin ng alak bilang inuming handog. Gawin ninyo ito kasama ang alay na susunugin o kasama ang alay ng bawat batang tupa. ");
INSERT INTO tglulb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kung maghahandog kayo ng isang lalaking tupa, dapat kayong maghanda ng isang handog na butil ng dalawang ikasampu ng isang epa ng pinong harinang hinaluan ng ikatatlo ng isang hin ng langis bilang handog. ");
INSERT INTO tglulb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Para sa inuming handog, dapat kayong maghandog ng ikatlo ng isang hin ng alak. Magdudulot ito ng isang mabangong halimuyak para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kapag maghanda kayo ng isang toro bilang alay na susunugin o bilang isang alay upang tuparin ang isang panata, o alay para sa pagtitipon-tipon kay Yahweh, ");
INSERT INTO tglulb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","sa gayon dapat kayong maghandog kasama ng toro ang isang handog na butil ng tatlong ikasampu ng isang epa ng pinong harinang hinaluan ng kalahating hin ng langis. ");
INSERT INTO tglulb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Dapat kayong maghandog bilang inuming handog ng kalahating hin ng alak, bilang isang handog na pinaraan sa apoy, upang magdulot ng mabangong halimuyak para kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Dapat mangyari ito sa ganitong paraan para sa bawat toro, para sa bawat lalaking tupa, at para sa bawat lalaking batang mga tupa o mga batang kambing. ");
INSERT INTO tglulb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ang bawat alay na inyong ihahanda at ihahandog ay dapat ninyong gawin ayon sa inilarawan dito. ");
INSERT INTO tglulb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Dapat gawin ng lahat ng katutubong Israelita ang mga bagay na ito sa ganitong paraan, kapag nagdadala ang sinuman ng isang handog na pinaraan sa apoy, upang magdulot ng mabangong halimuyak na kalugud-lugod kay Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Kung naninirahan ang isang dayuhan kasama ninyo, o sinumang nakikitira sa inyo sa buong salinlahi ng inyong mga tao, dapat siyang maghandog ng isang handog na pinaraan sa apoy, upang magdulot ng isang mabangong halimuyak para kay Yahweh. Dapat siyang kumilos gaya ng inyong pagkilos. ");
INSERT INTO tglulb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Dapat may parehong batas lamang para sa sambayanan at para sa dayuhang nakikitira sa inyo, isang palagiang batas sa buong salinlahi ng inyong mga tao. Kung ano kayo, gayundin dapat ang mga manlalakbay na naninirahan kasama ninyo. Dapat siyang kumilos gaya ng inyong pagkilos sa harapan ni Yahweh. ");
INSERT INTO tglulb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ang parehong batas at kautusan ang dapat masunod sa inyo at sa mga dayuhang naninirahang kasama ninyo.”' ");
INSERT INTO tglulb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Muling nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Magsalita ka sa mga tao ng Israel at sabihin mo sa kanila, 'Kapag dumating kayo sa lupain kung saan ko kayo dadalhin, ");
INSERT INTO tglulb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","kapag kakainin ninyo ang pagkaing nagmula sa lupain, dapat kayong maghandog ng isang handog at idulog ito sa akin. ");
INSERT INTO tglulb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Mula sa una ng inyong masang harina, dapat kayong maghandog ng isang tinapay upang itaas ito bilang isang itinaas na handog mula sa giikang palapag. Dapat ninyong itaas ito sa ganitong paraan. ");
INSERT INTO tglulb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dapat kayong magbigay sa akin ng isang itinaas na handog sa buong salinlahi ng inyong mga tao mula sa una ng inyong masang harina. ");
INSERT INTO tglulb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Minsan magkakasala kayo nang hindi sinasadya, kapag hindi ninyo sinunod ang lahat ng utos na ito na sinabi ko kay Moises— ");
INSERT INTO tglulb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","lahat ng bagay na inutos ko sa inyo sa pamamagitan ni Moises mula sa araw na sinimulan kong bigyan kayo ng mga utos at hanggang sa buong salinlahi ng inyong mga tao. ");
INSERT INTO tglulb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Patungkol sa hindi sinasadyang kasalanan na hindi alam ng buong sambayanan, dapat maghandog ang buong sambayanan ng isang batang toro bilang alay na susunugin upang magdulot ng isang mabangong halimuyak para kay Yahweh. Kalakip nito, dapat maghandog ng isang handog na butil at inuming handog, ayon sa iniutos ng batas, at isang lalaking kambing bilang isang handog para sa kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Dapat gumawa ang pari ng pagbabayad ng kasalanan para sa lahat ng sambayanan ng Israel. Patatawarin sila dahil ang kasalanan ay isang pagkakamali. Dinala nila ang kanilang alay, ang isang handog para sa akin na pinaraan sa apoy. Dinala nila ang kanilang handog para sa kasalanan sa aking harapan para sa kanilang pagkakamali. ");
INSERT INTO tglulb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","At patatawarin ang lahat ng sambayanan ng Israel, at ang mga dayuhang naninirahan kasama nila, dahil nagkasala ang lahat ng tao nang hindi sinasadya. ");
INSERT INTO tglulb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kung nagkakasala ang isang tao nang hindi sinasadya, dapat siyang maghandog ng isang babaeng kambing na isang taong gulang bilang handog para sa kaniyang kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Dapat maghandog ang pari ng pambayad ng kasalanan sa harapan ni Yahweh para sa taong nagkasala nang hindi sinasadya. Patatawarin ang taong iyon kapag maghandog ng pambayad ng kasalanan. ");
INSERT INTO tglulb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Dapat magkaroon kayo ng parehong batas para sa isang nakagawa ng anumang bagay nang hindi sinasadya, ang parehong batas para sa taong katutubo sa mga tao ng Israel at para sa mga dayuhang naninirahan sa kanila. ");
INSERT INTO tglulb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ngunit ang taong nakagawa ng anumang bagay sa pagsuway, maging katutubo siya o isang dayuhan, nilalapastangan niya ako. Dapat itiwalag ang taong iyon mula sa kaniyang mga tao.. ");
INSERT INTO tglulb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Dahil sinuway niya ang aking salita at nilabag ang aking utos, dapat itiwalag nang ganap ang taong iyon. Nasa kaniya ang kasalanan.” ");
INSERT INTO tglulb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Habang nasa ilang ang mga tao ng Israel, nakasumpong sila ng isang lalaking namumulot ng kahoy sa araw ng Pamamahinga. ");
INSERT INTO tglulb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Dinala siya ng mga taong nakakita sa kaniya kina Moises, Aaron, at sa buong sambayanan. ");
INSERT INTO tglulb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ibinilanggo nila siya dahil hindi pa naipahayag kung ano ang dapat gawin sa kaniya. ");
INSERT INTO tglulb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Pagkatapos, sinabi ni Yahweh kay Moises, “Dapat patayin ang lalaki. Dapat siyang batuhin ng buong sambayanan sa labas ng kampo.” ");
INSERT INTO tglulb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kaya dinala siya ng buong sambayanan sa labas ng kampo at pinagbababato siya hanggang mamatay gaya ng inutos ni Yahweh kay Moises. ");
INSERT INTO tglulb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Muling nagsalita si Yahweh kay Moises. Sinabi niya, ");
INSERT INTO tglulb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Magsalita ka sa mga kaapu-apuhan ng Israel at utusan silang gumawa ng mga palawit para sa kanilang mga sarili upang isabit mula sa mga dulo ng kanilang mga damit, upang isabit ang mga ito mula sa bawat dulo sa pamamagitan ng isang taling asul. Dapat nilang gawin ito sa kabuuan ng salinlahi ng kanilang mga tao. ");
INSERT INTO tglulb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Magiging isang natatanging paalala ito sa inyo, kapag makita ninyo ito, sa lahat ng aking mga utos, upang tuparin ang mga ito para hindi ninyo sundin ang inyong sariling puso at sariling mga mata, na kung saan kumilos kayo dati tulad ng mga mangangalunya. ");
INSERT INTO tglulb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Gawin ninyo ito upang maisaisip ninyo at masunod ang lahat kong utos, at upang maaari kayong maging banal, inilaan para sa akin, ang inyong Diyos. ");
INSERT INTO tglulb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ako si Yahweh ang inyong Diyos, na siyang naglabas sa inyo mula sa lupain ng Ehipto, upang maging Diyos ninyo. Ako si Yahweh ang inyong Diyos.” ");
INSERT INTO tglulb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ngayon si Korah na anak na lalaki ni Izar na anak na lalaki ni Kohat na anak na lalaki ni Levi, kasama ni Datan at Abiram na mga anak na lalaki ni Eliab, at si On na anak na lalaki ni Pelet, ang mga kaapu-apuan ni Ruben ay tinipon ng ilang kalalakihan. ");
INSERT INTO tglulb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Tumindig sila laban kay Moises, kasama ng ibang kalalakihan mula sa mga tao ng Israel, dalawang daan at limampung pinuno ng sambayanan na mga tanyag na kasapi sa sambayanan. ");
INSERT INTO tglulb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Nagkatipon sila upang harapin sina Moises at Aaron. Sinabi nila sa kanila, “Kumukuha kayo nang labis para sa inyong mga sarili. Ang buong sambayanan ay banal, inilaan kay Yahweh, ang bawat isa sa kanila, at si Yahweh ay kasama nila. Bakit ninyo inaangat ang inyong mga sarili sa ibabaw ng natitirang sambayanan ni Yahweh?” ");
INSERT INTO tglulb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Nang marinig iyon ni Moises, nagpatirapa siya. ");
INSERT INTO tglulb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Nagsalita siya kay Korah at sa lahat ng kaniyang pangkat; sinabi niya, “Sa kinaumagahan, ipapakita ni Yahweh kung sino ang kaniya, at kung sino ang inilaan kay Yahweh. Dadalhin niya sa kaniya ang taong pipiliin niya. Dadalhin siya ni Yahweh sa kaniyang sarili. ");
INSERT INTO tglulb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Gawin ninyo ito, Korah at lahat ng iyong pangkat. Kumuha kayo ng mga insensaryo ");
INSERT INTO tglulb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","bukas at lagyan ninyo ng apoy at insenso ang mga ito sa harap ni Yahweh. Ang taong pipiliin ni Yahweh, ang taong iyon ay ilalaan kay Yahweh. Malayo na ang inyong narating, kayong mga kaapu-apuan ni Levi.” ");
INSERT INTO tglulb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Muli, sinabi ni Moises kay Korah, “Ngayon ay makinig kayo, kayong mga kaapu-apuan ni Levi: ");
INSERT INTO tglulb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ito ba ay isang maliit na bagay para sa inyo na inilaan kayo ng Diyos ng Israel mula sa sambayanan ng Israel, upang palapitin kayo sa kaniya, upang magtrabaho sa tabernakulo ni Yahweh, at upang tumayo sa harapan ng sambayanan para maglingkod sa kanila? ");
INSERT INTO tglulb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Dinala niya kayo ng malapitan, at lahat ng inyong mga kamag-anak, ang mga kaapu-apuan ni Levi ay kasama ninyo, ngunit ninanasa din ninyo ang pagkapari! ");
INS