﻿USE sofia;
DROP TABLE IF EXISTS sofia.tgk_vpl;
CREATE TABLE tgk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tgk_vpl WRITE;
INSERT INTO tgk_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2"," Замоне, ки дар сарзамини Исроил доварон ҳукмронӣ мекарданд, гуруснагии сахте ба миён омад. Ҳамзамон дар деҳаи Байт-Лаҳми вилояти Яҳудия Элимелех ном марде зиндагӣ мекард, ки аз авлоди Эфротиён буд. Рӯзе ӯ ҳамроҳи ҳамсараш Ноомӣ ва ду писараш Маҳлон ва Килъон ба сарзамини Мӯоб кӯчида рафт, то дар он ҷо зиндагӣ кунад. ");
INSERT INTO tgk_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Аммо пас аз чанд вақт Элимелех — шавҳари Ноомӣ аз олам чашм пӯшида, ӯро бо ду писараш танҳо гузошт. ");
INSERT INTO tgk_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Писаронаш духтарони мӯобиро ба занӣ гирифтанд, ки номи яке Орфо ва дигаре Рут буд. Баъди даҳ соле, ки онҳо дар он ҷо умр ба сар бурданд, ");
INSERT INTO tgk_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Маҳлон ва Килъон низ аз олам гузаштанд. Инак, Ноомӣ бешавҳару беписар монд. ");
INSERT INTO tgk_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Пас аз муддате Ноомӣ шунид, ки Худованд ба халқи худ баракати ҳосили фаровон додааст. Ӯ бо занони писаронаш бархост, то ки Мӯобро тарк кунад. ");
INSERT INTO tgk_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ҳамроҳи ду келинаш ҷойи зисти худро гузошта, ба роҳ баромад, то ба Яҳудия баргардад. ");
INSERT INTO tgk_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Аммо дар роҳ Ноомӣ ба онҳо гуфт: «Ба хонаҳои модаронатон баргардед. Бигзор Худованд ба ивази некиҳое, ки ба ман ва фарзандони раҳматиам кардед, ба шумо некӣ кунад. ");
INSERT INTO tgk_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Дуо мекунам, ки ҳардуятон боз ба шавҳар бароед ва шуморо дар он хона хуш бипазиранд». Пас Ноомӣ хайрухушкунон онҳоро бӯсид. Аммо онҳо гиря карда ");
INSERT INTO tgk_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","гуфтанд: «Не, мо ҳамроҳатон назди халқи шумо меравем». ");
INSERT INTO tgk_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ноомӣ дар ҷавоб гуфт: «Духтаронам, шумо бояд баргардед. Чаро ҳамроҳи ман будан мехоҳед? Оё ман метавонам боз соҳиби писароне шавам, ки шуморо ба занӣ гиранд? ");
INSERT INTO tgk_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Духтаронам, ман барои дубора шавҳар кардан пир шудаам, барои ҳамин ба хонаҳои худ баргардед. Ҳатто агар чунин имкон бошаду ман ҳамин шаб шавҳар карда писардор шавам ҳам, ");
INSERT INTO tgk_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","оё шумо то ба воя расидани онҳо сабр мекунед? Ин хел шумо шавҳар карда наметавонед. Не, духтаронам, шумо медонед, ки ин номумкин аст. Ранҷу азобе, ки дорам, бароятон беҳад вазнин аст, чунки Худованд бар зидди ман аст». ");
INSERT INTO tgk_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Онҳо боз бо овози баланд гиря карданд. Сипас Орфо хушдоманашро бӯсида, бо ӯ хайрухуш карда рафт, аммо Рут бо ӯ монд. ");
INSERT INTO tgk_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Ноомӣ ба ӯ гуфт: «Бубин, Орфо ба назди қавми худ ва худоёни худ бармегардад, ту ҳам ҳамроҳи ӯ бирав». ");
INSERT INTO tgk_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Аммо Рут илтиҷо кард: «Маро маҷбур накунед, ки аз пешатон равам. Иҷозат диҳед, ҳамроҳатон истам. Ҳар ҷойе ки равед, ман ҳам меравам. Ҳар ҷойе ки зиндагӣ кунед, ман ҳам он ҷо зиндагӣ мекунам. Халқи шумо халқи ман ва Худои шумо Худои ман мешавад. ");
INSERT INTO tgk_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ҳар ҷое ки бимиред, ман ҳам ҳамон ҷой хоҳам мурд ва дар он ҷой маро низ гӯр хоҳанд кард. Агар чизе ғайр аз марг маро аз шумо ҷудо кунад, Худо ба балои бад гирифторам кунад». ");
INSERT INTO tgk_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ноомӣ чун фаҳмид, ки Рут аз гапаш намегардад, дигар чизе нагуфт. ");
INSERT INTO tgk_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ҳамин тавр, онҳо роҳи худро давом доданд ва ба шаҳри Байт-Лаҳм расиданд. Ҳангоме онҳо ба шаҳр даромаданд, мардум аз дидани онҳо ба ҳаяҷон омаданду занон чунин мегуфтанд: «Наход ин Ноомӣ бошад?» ");
INSERT INTO tgk_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ноомӣ дар ҷавоб гуфт: «Худои Таоло ҳаёти маро хеле талху ғамнок кардааст, барои ҳамин маро дигар Ноомӣ (яъне форам) нагӯед, балки Мора (яъне талх) бигӯед. ");
INSERT INTO tgk_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Вақте ки аз ин ҷо баромада рафтам, ҳама чиз доштам, аммо Худованд маро бо дасти холӣ баргардонд. Чаро маро Ноомӣ мегӯед, ҳол он ки Худованд маро ба чунин мусибат гирифтор кардааст ва Худои Таоло маро бадбахт намудааст?» ");
INSERT INTO tgk_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Инак, Ноомӣ ҳамроҳи келинаш Рут аз сарзамини Мӯоб баргашт. Ҳангоме ки онҳо ба шаҳри Байт-Лаҳм расиданд, мавсими дарави ҷав нав сар шуда буд. ");
INSERT INTO tgk_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ноомӣ хешованде дошт, ки номаш Бӯаз буд. Бӯаз марди сарватманду баобрӯ аз қабилаи шавҳараш Элимелех буд. ");
INSERT INTO tgk_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Рӯзе Рут ба Ноомӣ гуфт: «Иҷозат диҳед, ба киштзорҳои гирду атроф равам, шояд ягон кас ба ман раҳм карда гузорад, ки хӯшаҳои аз паси даравгарон ба замин афтодаро чинам». Ноомӣ ҷавоб дод: «Бирав, духтарам». ");
INSERT INTO tgk_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Пас Рут ба киштзоре рафта, аз қафои даравгарон хӯшаҳои афтодаро мечид. Бо амри тасодуф он киштзор ба Бӯаз, ки аз қабилаи Элимелех буд, тааллуқ доштааст. ");
INSERT INTO tgk_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Пас аз муддате Бӯаз аз деҳаи Байт-Лаҳм омад ва бо коргарон салому алейк карда гуфт: «Худованд ёратон бод!» Онҳо дар ҷавоб гуфтанд: «Раҳмат, Худованд шуморо баракат диҳад!» ");
INSERT INTO tgk_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Бӯаз аз саркори даравгарон пурсид: «Он зани ҷавон кист?» ");
INSERT INTO tgk_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Саркор ҷавоб дод: «Ин зани ҷавон ҳамон мӯобӣ аст, ки ҳамроҳи Ноомӣ аз кишвари Мӯоб омадааст. ");
INSERT INTO tgk_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ӯ аз ман иҷозат пурсид, ки аз қафои даравгарон хӯшаҳои ба замин афтодаро чинад. Ӯ аз субҳ то ин дам машғули кор аст, танҳо як бор дар зери соябон каме истироҳат кард». ");
INSERT INTO tgk_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Он гоҳ Бӯаз ба Рут гуфт: «Духтарам, гӯш кун, барои хӯшачинӣ ба майдонҳои дигар нарав, балки дар ҳамин ҷо бо занон истода, кор кун. ");
INSERT INTO tgk_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ба онҳо нигоҳ кун, ҳар ҷое ки онҳо дарав кунанд, ту ҳам аз қафои онҳо рав. Ман ба мардикорони худ амр додам, ки ба ту даст нарасонанд. Агар ташна шавӣ, рафта аз кӯзаҳое, ки хизматгоронам об пур мекунанд, бинӯш». ");
INSERT INTO tgk_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Рут то замин ба Бӯаз таъзим карда, гуфт: «Чаро шумо ба ман ин хел ғамхорӣ мекунед? Чаро ба як шахси бегона ин қадар меҳрубон ҳастед?» ");
INSERT INTO tgk_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Бӯаз дар ҷавоб гуфт: «Ҳар он чӣ ту баъди марги шавҳарат дар ҳаққи хушдоманат кардӣ, ба гӯшам расид. Медонам, ки падару модар ва ватани худро монда омадӣ, то дар байни халқи ношинос зиндагӣ кунӣ. ");
INSERT INTO tgk_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Худованд барои корҳои кардаат ба ту файзу баракат диҳад. Бигзор Худованд, Худои Исроил, ки назди Ӯ омадаӣ, туро дар паноҳаш нигоҳ дорад ва ба ту мукофот ато намояд». ");
INSERT INTO tgk_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Рут дар ҷавоб гуфт: «Эй хоҷаи меҳрубон, маро аз марҳамати худ дар оянда ҳам маҳрум накунед. Шумо ба ман, ки ҳатто канизатон нестам, суханони нек гуфта, тасаллӣ додед». ");
INSERT INTO tgk_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Дар вақти хӯрокхӯрӣ Бӯаз ба Рут гуфт: «Биё, хӯрок хӯр. Нонатро ба шираи ангур тар карда хӯр». Пас Рут дар назди даравгарон нишаст ва Бӯаз ба ӯ гандумбирён дод. Рут то серӣ хӯрду боз боқӣ монд. ");
INSERT INTO tgk_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Чун Рут бархоста, ба хӯшачинӣ сар кард, Бӯаз ба даравгарони худ амр дода гуфт: «Агар ӯ байни хӯшаҳои баста хӯша чинад ҳам, ба ӯ чизе нагӯед ва кордор нашавед. Баръакс, каме аз хӯшаҳои басташуда низ ба рӯйи замин бирезед, то ӯ бичинад». ");
INSERT INTO tgk_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Рут то бегоҳ дар он киштзор хӯша чид. Вақте хӯшаҳоро бикӯфт, тақрибан дувоздаҳ кило ҷави тоза ба даст овард. ");
INSERT INTO tgk_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Рут онро бо худ ба шаҳр овард ва хушдоманаш дид, ки чӣ қадар ҷав ҷамъ кардааст. Ӯ боқимондаи хӯроки худро низ ба Ноомӣ дод. ");
INSERT INTO tgk_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ноомӣ аз ӯ пурсид: «Аз куҷо ҳамаи инро ҷамъ овардӣ? Дар кадом киштзор кор кардӣ? Худо касеро, ки ба ту ин қадар ғамхорӣ кардааст, баракат диҳад!» Рут ба хушдоманаш гуфт, ки дар киштзори Бӯаз ном марде кор кардааст. ");
INSERT INTO tgk_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ноомӣ ба Рут гуфт: «Худованд Бӯазро баракат диҳад! Ӯ марҳамати худро аз мо ва аз мурдагон дареғ надоштааст». Ӯ боз илова кард: «Он мард яке аз хешони наздики мост, ки бояд сарпарастиамонро ба ӯҳда бигирад». ");
INSERT INTO tgk_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Пас аз он Рут гуфт: «Ӯ ҳатто ба ман гуфт, ки бо коргаронаш то тамом шудани мавсими дарав дар киштзори ӯ хӯша чинам». ");
INSERT INTO tgk_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ноомӣ ба Рут гуфт: «Бале, духтарам, ҳамроҳи занон дар киштзори Бӯаз кор кунӣ, беҳтар аст. Агар ба ҷойи дигар равӣ, мумкин коргарон ба ту даст расонанд». ");
INSERT INTO tgk_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Бо ҳамин, Рут то охири мавсими дарави гандуму ҷав бо канизони Бӯаз ҷамъоварии ғалларо давом медод ва бо хушдоманаш зиндагӣ мекард. ");
INSERT INTO tgk_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Боре Ноомӣ, хушдомани Рут, ба ӯ гуфт: «Духтарам, ман бояд бароят паноҳгоҳе пайдо кунам, то ки ту бароҳат бошӣ. ");
INSERT INTO tgk_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ҳамон Бӯаз, ки ту ҳамроҳи хизматгоронаш кор кардӣ, хеши мост. Акнун гӯш кун. Ӯ имшаб дар хирмангоҳ ҷав бод мекунад. ");
INSERT INTO tgk_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ту худатро тоза бишӯй, каме атр бизан ва либоси беҳтаринатро пӯшида, ба хирманҷо рав. Аммо то хӯрдану нӯшиданро тамом накунад, худро ба ӯ нишон надеҳ. ");
INSERT INTO tgk_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Вақте ки хоб меравад, ҷойи хобашро фаҳм, ки дар куҷост. Он гоҳ ба назди ӯ рафта, кӯрпаи ӯро аз рӯйи пойҳояш кушода, назди пойҳояш хоб кун. Пас худи ӯ мегӯяд, ки чӣ бояд кунӣ». ");
INSERT INTO tgk_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Рут дар ҷавоб гуфт: «Ҳамаи гуфтаҳоятро иҷро мекунам». ");
INSERT INTO tgk_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Пас Рут ба хирманҷо рафта, ҳамон тавре ки хушдоманаш фармуда буд, амал кард. ");
INSERT INTO tgk_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Вақте ки Бӯаз хӯрдану нӯшиданро тамом кард, хушҳол шуд ва назди охирин хирмани ҷав рафта, хобид. Рут оҳиста ба ӯ наздик шуд ва як гӯшаи кӯрпаи ӯро бардошта, дар поёни пойи Бӯаз дароз кашид. ");
INSERT INTO tgk_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Нисфи шаб Бӯаз ногаҳон аз хоб бедор шуд ва чун дид, ки зане дар поёни пойҳояш хобидааст, ҳайрон шуд. ");
INSERT INTO tgk_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Бӯаз «Ту кистӣ?» гуфта пурсид. Рут ҷавоб дод: «Ман канизи шумо, Рут ҳастам. Шумо ки хеши наздиктарини мо ҳастед, хоҳиш мекунам, сарпарастии маро ба ӯҳда гиред». ");
INSERT INTO tgk_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Бӯаз гуфт: «Духтарам, Худованд туро баракат диҳад. Ин кори неке, ки ҳоло кардӣ, аз коре, ки пештар карда будӣ, бузургтар аст. Ту метавонистӣ аз қафои ҷавонмардони бой ё камбағал равӣ, вале ин корро накардӣ. ");
INSERT INTO tgk_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Духтарам, дигар натарс, ҳама хоҳишатро иҷро мекунам. Тамоми мардуми шаҳр медонанд, ки ту зани баномусӣ. ");
INSERT INTO tgk_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Дуруст аст, ки ман — хеши ту, вале аз ман дида, боз хеши наздиктар ҳаст. ");
INSERT INTO tgk_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Шабона ин ҷо бимон. Фардо субҳ мефаҳмам, ки оё ӯ ҳимояи туро ба ӯҳда мегирад ё не. Агар бигирад, хуб аст, вагарна ба Худои зинда қасам, ки худам туро мегирам. Ҳоло то саҳар ин ҷо хоб кун». ");
INSERT INTO tgk_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Пас Рут то саҳар дар поёни пойҳои Бӯаз хобид. Аммо, чашми рӯз ҳанӯз накафида, аз хоб бедор шуд. Бӯаз намехост, ки касе ба хирманҷо омадани занро бифаҳмад. ");
INSERT INTO tgk_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ӯ ба Рут гуфт: «Рӯймолатро ба рӯйи замин паҳн кун». Рут ҳамин тавр кард. Бӯаз дар он тақрибан 25 кило ҷав рехт ва онро ба китфи Рут гузошт. Баъд худ ба шаҳр рафт. ");
INSERT INTO tgk_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ҳангоме ки Рут ба назди хушдоманаш омад, Ноомӣ аз ӯ пурсид: «Хуб, чӣ гап, духтарам?» Рут ҳамаи ҳодисаро гуфт, ки Бӯаз барои ӯ чӣ кор кард ");
INSERT INTO tgk_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","ва илова намуд: «Бӯаз ба ман гуфт, ки набояд бо дастони холӣ ба назди ту баргардам. Ӯ ҳамаи ин ҷавро ба ман дод». ");
INSERT INTO tgk_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ноомӣ ба ӯ гуфт: «Ҳоло сабр кун, духтарам, ки натиҷаи ин кор чӣ мешавад, зеро ин шахс то ин масъаларо имрӯз ҳал накунад, ором намешавад». ");
INSERT INTO tgk_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Он гоҳ Бӯаз ба назди дарвозаи шаҳр рафта, он ҷо нишаст. Вақте ҳамон хешованде, ки дар борааш гуфта буд, аз он ҷо мегузашт, Бӯаз ӯро садо карда гуфт: «Эй дӯстам, биё ин ҷо бишин». Ӯ омада, он ҷо нишаст. ");
INSERT INTO tgk_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Сипас Бӯаз даҳ нафарро аз роҳбарони шаҳр даъват намуда, аз онҳо хоҳиш кард, ки он ҷо нишинанд. Вақте онҳо ба ҷойҳои худ гузаштанд, ");
INSERT INTO tgk_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Бӯаз ба хешаш муроҷиат намуд: «Ҳоло Ноомӣ аз сарзамини Мӯоб баргаштааст ва мехоҳад заминеро, ки аз они хеши мо — Элимелех аст, фурӯшад. ");
INSERT INTO tgk_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Фикр кардам, ки ман бояд ин хабарро дар ҳузури ин ҷо нишастагон ва дар ҳузури роҳбарони халқи ман ба ту расонам, то он заминро бихарӣ. Агар харидан нахоҳӣ, ба ман бигӯй, то ки ман донам, чун ҳаққи хариди он заминро аввал ту дорӣ, баъд аз ту ман метавонам онро бихарам». Он шахс гуфт: «Ман онро мехарам». ");
INSERT INTO tgk_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Он гоҳ Бӯаз гуфт: «Хуб, ҳангоми харидани замини Ноомӣ ту бояд Рути мӯобиро, ки шавҳараш аз олам гузаштааст, ба занӣ бигирӣ. Ба ин восита вақте кӯдакдор шуда, соҳиби меросхӯр мегардед, мероси шавҳараш аз байн намеравад». ");
INSERT INTO tgk_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Он мард дар ҷавоб гуфт: «Ман он заминро харида наметавонам, чунки агар бихарам, молу мулки худро зери хатар мегузорам. Ту ӯро гир, чунки ман ин корро карда наметавонам». ");
INSERT INTO tgk_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Давраҳои пеш дар Исроил чунин расм буд, ки ҳангоми харидуфурӯш ё додугирифт барои тасдиқи ҳамон амал як кас пойафзоли худро кашида, ба каси дигар медод. Дар Исроил ин тарзи қонунӣ гардонидани ҳамон кор ҳисоб мешуд. ");
INSERT INTO tgk_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Пас ҳамон хеш пойафзоли худро кашида, ба Бӯаз гуфт: «Ту онро бихар». ");
INSERT INTO tgk_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Он гоҳ Бӯаз ба роҳбарон ва ба ҳозирин рӯй овард: «Шумо акнун шоҳид ҳастед, ки ман заминҳоеро, ки аз они Элимелех, Килъон ва Маҳлон аст, аз Ноомӣ мехарам. ");
INSERT INTO tgk_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Инчунин Рути мӯобиро, ки зани Маҳлон буд, ба занӣ мегирам, то ки замини он шахс барои аҳли оилаи ӯ боқӣ бимонад ва номаш дар хонадону зодгоҳаш аз байн наравад. Шумо имрӯз шоҳид ҳастед». ");
INSERT INTO tgk_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Он гоҳ роҳбарон ва мардуме, ки дар назди дарвоза ҷамъ омада буданд, тасдиқ карданд: «Бале, мо шоҳид ҳастем. Худованд ҳамсаратро монанди занони Яъқуб — Роҳел ва Леё гардонад. Ин занон барои ӯ фарзандони зиёдро ба дунё оварданд. Дар байни Эфротиён сарват ба даст орӣ ва номат дар деҳаи Байт-Лаҳм машҳур гардад. ");
INSERT INTO tgk_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Фарзандоне, ки Худованд аз ин зани ҷавон ба ту ато мефармояд, хонадони туро мисли хонадони Форас бисозанд, ки Томор ӯро барои Яҳудо таваллуд карда буд». ");
INSERT INTO tgk_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Пас аз он Бӯаз Рутро ба занӣ гирифта, бо ӯ ҳамбистар шуд ва Худованд ӯро баракат доду Рут ҳомиладор шуда, писаре ба дунё овард. ");
INSERT INTO tgk_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Занони шаҳр ба Ноомӣ мегуфтанд: «Худоро шукр, ки Ӯ туро бе меросхӯре, ки нигаҳбонат мешавад, нагузошт! Бигзор номи ин кӯдак дар Исроил машҳур гардад! ");
INSERT INTO tgk_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ӯ акнун бароят зиндагии наве хоҳад бахшид ва атои айёми пириат хоҳад буд, зеро ӯро келинат, ки туро дӯст медорад ва бароят аз ҳафт писар ҳам беҳтар аст, ба дунё овардааст». ");
INSERT INTO tgk_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ноомӣ он кӯдакро ба оғӯш гирифта, парасторӣ мекард. ");
INSERT INTO tgk_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Занони ҳамсоя мегуфтанд: «Ноомӣ писардор шуд» ва ба кӯдак Убид ном ниҳоданд. Убид падари ҳамон Йисой аст, ки падари Довуд буд. ");
INSERT INTO tgk_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Авлоди Форас инҳоянд: Форас падари Ҳесрӯн, ");
INSERT INTO tgk_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Ҳесрӯн падари Ром, Ром падари Аминодоб, ");
INSERT INTO tgk_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Аминодоб падари Наҳшӯн, Наҳшӯн падари Салмӯн, ");
INSERT INTO tgk_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Салмӯн падари Бӯаз, Бӯаз падари Убид, ");
INSERT INTO tgk_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Убид падари Йисой ва Йисой падари Довуд буд. ");
INSERT INTO tgk_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Замони ҳукмронии шоҳ Аҳашверӯш буд, ҳамон шоҳ, ки бар яксаду бисту ҳафт вилоят, аз Ҳиндустон сар карда, то Эфиопия подшоҳӣ мекард. ");
INSERT INTO tgk_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","Он рӯзҳо ӯ сарзаминашро аз тахти шоҳонаи худ, ки дар қалъаи Шушан буд, роҳбарӣ менамуд. ");
INSERT INTO tgk_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Соли сеюми подшоҳияш шоҳ барои ҳамаи мансабдорону дарбориён зиёфат дод. Дар он сарлашкарони сарзамини форсу модҳо, мирон ва ҳокимони вилоятҳо иштирок доштанд. ");
INSERT INTO tgk_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Ӯ сарвати фаровони шоҳигарии худ ва шукӯҳу шаҳомати бузургиашро муддати дуру дароз, дар давоми шаш моҳ, ба меҳмононаш намоиш медод. ");
INSERT INTO tgk_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Пас аз тамом шудани зиёфати якум шоҳ барои ҳамаи сокинони қалъаи Шушан, чи камбағалу чи сарватманд, зиёфати дуюм дод. Он дар боғи девордори қасри шоҳ ҳафт шабонарӯз давом намуд. ");
INSERT INTO tgk_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Дар ин боғ пардаҳо аз матоъҳои пахтагини сафеду осмонранг бо бандҳои қиматбаҳои сафеду бунафшранг аз ҳалқаҳои нуқрагин гузаронида шуда, ба сутунҳои мармарин овезон буданд. Катҳои тиллоию нуқрагинро болои фарши мармарӣ, садафӣ ва аз дигар сангҳои қиматбаҳои сурху сиёҳ тайёршуда, қатор гузошта буданд. ");
INSERT INTO tgk_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Хизматгорон шаробро дар зарфҳои тиллоие, ки яке аз дигаре фарқ дошт, меоварданд. Шароби шоҳона аз сабаби бойигарии подшоҳ фаровон буд ва ");
INSERT INTO tgk_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","мувофиқи қонун ҳар кас, чи қадаре ки мехост, менӯшид, зеро шоҳ ба ходимонаш фармуда буд, ки бо хости ҳар кас амал намоянд. ");
INSERT INTO tgk_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Зани подшоҳ — малика Ваштӣ низ дар қасри шоҳ Аҳашверӯш барои занон зиёфат медод. ");
INSERT INTO tgk_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Дар рӯзи ҳафтуми зиёфат подшоҳ аз нӯшидани шароб андак маст шуда, ба ҳафт хизматгорони шахсияш — Меҳумон, Бизто, Ҳарбӯно, Бинто, Абанто, Зетар ва Каркас, фармон дод, ");
INSERT INTO tgk_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","ки малика Ваштиро наздаш биёранд. Занаш ҳусни зебо дошт ва шоҳ хост, ки малика тоҷ бар сар пеши меҳмонон биёяд, то зебоии ӯро ба ҳама намоиш диҳад. ");
INSERT INTO tgk_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Лекин чун хизматгорон рафта, ба малика фармони шоҳро расониданд, малика амрашро рад карду ба зиёфат наомад. ");
INSERT INTO tgk_vpl VALUES ("ET1_13","018_1_13","EST","1","13","14","Шоҳ Аҳашверӯш аз ин рафтори малика огоҳ шуда, ба хашм омаду хеле оташин гардид. Аз рӯйи одаташ ӯ ба ситорашиносонаш — Каршено, Шетор, Адмото, Таршиш, Мерес, Марсено ва Мемухон муроҷиат карда, маслиҳат пурсид. Ин мансабдорони сарзамини Форсу Модай қонуну қоида ва анъанаҳоро медонистанд. Азбаски онҳо вазифаҳои баландтаринро соҳиб буданд, иҷозати назди подшоҳ даромадан доштанд. Подшоҳ аз онҳо пурсид: ");
INSERT INTO tgk_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","«Малика Ваштӣ ба фармони шоҳ, ки хизматгорон ба вай расониданд, итоат накард. Мувофиқи қонун ҷазои ӯ чист?» ");
INSERT INTO tgk_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Яке аз маслиҳатгарон — Мемухон дар ҳузури шоҳ ва мансабдорон гуфт: «Малика Ваштӣ на танҳо ба подшоҳ, балки ба ҳамаи мансабдорону тамоми мардуми вилоятҳои подшоҳ Аҳашверӯш беҳурматӣ нишон дод. ");
INSERT INTO tgk_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Зеро чунин гуфтугузор мешавад, ки малика Ваштӣ фармони подшоҳро рад карда, наздаш наомад. Занон инро фаҳмида шавҳарони худро писанд намекунанд. ");
INSERT INTO tgk_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Худи ҳамин рӯз занони мансабдорони Форсу Модай, ки аз ин воқеа хабардор мешаванд, ба шавҳарони худ низ инро нақл мекунанд. Сипас дар оилаҳо хашму ғазаб ва беҳурматӣ зиёд хоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Бинобар ин, агар ба подшоҳ писанд ояд, фармон бароварда шавад, ки Ваштӣ дигар ҳеҷ гоҳ ба назди подшоҳ надарояд. Бигузор подшоҳ вазифаи ӯро ба зани дигаре, ки аз вай беҳтар аст, диҳад. Ин фармон дар қонуни ивазнашавандаи Форсу Модай ҷо шавад. ");
INSERT INTO tgk_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Вақте ки фармони шоҳ дар тамоми сарзамини бузургаш паҳн мешавад, боиси он мегардад, ки ҳар як зан дар ҳар хонавода, чи камбағалу чи сарватманд, шавҳари худро ҳурмат кунад». ");
INSERT INTO tgk_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Маслиҳати Мемухон ба ҳама писанд омаду подшоҳ аз пайи иҷрои он шуд. ");
INSERT INTO tgk_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Ӯ фармонро бо хати ҳар як вилояту забони ҳар як халқ навишта фиристод, то ҳар мард дар хонаи худ хӯҷаини оила бошаду бо забони халқаш гап занад. ");
INSERT INTO tgk_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Баъд аз чанд вақт, чун ғазаби шоҳ Аҳашверӯш паст шуд, ӯ Ваштиро бо кори кардааш ва фармони дар ҳаққи ӯ баровардаашро ба ёд овард. ");
INSERT INTO tgk_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Инро дида, хизматгорони шахсияш ба ӯ гуфтанд: «Бигзор барои шоҳ духтарони ҷавону зеборо ҷустуҷӯ намоянд. ");
INSERT INTO tgk_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Барои ин шоҳ ба тамоми вилоятҳои шоҳигариаш шахсони махсусро таъин кунад, то ки онҳо ҳамаи духтарони ҷавону соҳибҷамолро дар ҳарамсаройи қалъаи Шушан ҷамъ оваранд. Сипас онҳоро ба дасти Ҳейга — нигаҳбони занони шоҳ супорида, ба онҳо маводи ороиши занона бидиҳанд. ");
INSERT INTO tgk_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Бигзор ҳамон духтаре, ки ба подшоҳ хуш меояд, ба ҷойи Ваштӣ малика шавад». Пешниҳод ба подшоҳ маъқул шуд ва ӯ ҳамон тавр амал кард. ");
INSERT INTO tgk_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Инак, дар қалъаи Шушан марди яҳудие бо номи Мордахай, ки писари Ёир буд, мезист. Ёир писари Шимъӣ буд ва Шимъӣ писари Киш, аз хонаводаи Бинёмин. ");
INSERT INTO tgk_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","Аслан Киш дар шаҳри Уршалим зиндагӣ мекард. Аммо Набукаднесар — шоҳи сарзамини Бобил чандин сол пеш Уршалимро хароб карда, шоҳи Яҳудия Еконёро ба асирӣ гирифта буд. Дар он вақт Киш — бобокалони Мордахай низ, ҳамроҳи дигар асирон оварда шуд. ");
INSERT INTO tgk_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Мордахай духтархонде дошт, ки фарзанди амакаш буд. Пас аз вафоти падару модари духтар Мордахай ӯро гирифта, калон карда буд. Ӯ Ҳадаса ном дошт, лекин номи форсияш Эстер буд. Вай қаду қомати мавзун ва чеҳраи зебо дошт. ");
INSERT INTO tgk_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Вақте ки фармони шоҳ эълон шуду духтарони зиёдеро ба қалъаи Шушан оварда, ба дасти Ҳейга — нигаҳбони занон супориданд, Эстер ҳам дар байни онҳо буд. Вай низ дар қасри подшоҳӣ таҳти назорати Ҳейга қарор гирифт. ");
INSERT INTO tgk_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Ситораи духтар ба Ҳейга маъқул шуду Ҳейга дарҳол ба Эстер маводи ороишию хӯроки ба ӯ хосро дод. Инчунин ҳафт канизони дарбориро ба Эстер супориду ӯро бо канизонаш ба ҷойи беҳтарини хонаи занон гузаронд. ");
INSERT INTO tgk_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Мувофиқи амри Мордахай Эстер ба касе дар бораи аз миллати яҳудӣ буданаш ва оилаи худ ҳарф намезад. ");
INSERT INTO tgk_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Ҳар рӯз Мордахай назди хонаи занон мегашт, то ки аз ҳолу кори Эстер хабар ёбад. ");
INSERT INTO tgk_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Пеш аз назди шоҳ Аҳашверӯш даромадан, ба ҳар духтар дувоздаҳ моҳ барои тайёрӣ дидан мӯҳлат дода мешуд; ӯ шаш моҳ бо равғанҳои хушбӯй ва шаш моҳи дигар бо атрҳову молиданиҳои гуногуни занона худро орову торо медод. ");
INSERT INTO tgk_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Сипас духтар дар навбати худ, назди шоҳ медаромад. Ҳангоми назди шоҳ рафтан ҳар чизеро, ки духтар талаб мекард, медоданд, то ки аз хонаи занон ба хонаи шоҳ барад. ");
INSERT INTO tgk_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Духтар бегоҳӣ ба назди шоҳ мерафту саҳарӣ ба хонаи занҳои дигар баргашта, таҳти назорати Шаашғоз, ки нигаҳбони занони дигар буд, меистод. Вай ба назди шоҳ дуюмбора намеомад, магар ин ки ба шоҳ хуш ояду ӯро бо номаш даъват кунад. ");
INSERT INTO tgk_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Акнун навбати ба назди шоҳ даромадан ба Эстер ҳам расид: ҳамон Эстери духтари Абиҳоили амаки Мордахай, ки Мордахай ӯро ҳамчун духтараш калон карда буд. Вай бо худ танҳо чизҳои пешниҳодкардаи Ҳейгаро гирифт. Инак, ҳама ба Эстер бо чашми нек менигаристанд. ");
INSERT INTO tgk_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Зимистони соли ҳафтуми ҳукмронии шоҳ, Эстерро ба назди шоҳ Аҳашверӯш ба қаср оварданду ");
INSERT INTO tgk_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","вай Эстерро бештар аз ҳамаи занон дӯст дошт ва нисбат ба духтарони дигар ситорааш ба дили шоҳ бештар рост омад. Шоҳ ба сари Эстер тоҷи шоҳигарӣ гузошта, ӯро ба ҷойи Ваштӣ малика эълон намуд. ");
INSERT INTO tgk_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Он гоҳ шоҳ ба хотири Эстер барои ҳамаи мансабдорону дарбориён зиёфат доду дар ҳамаи вилоятҳо пули андозро кам карда, ба таври шоҳона тӯҳфаҳо тақсим карда дод. ");
INSERT INTO tgk_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Вақте ки бори дуюм духтаронро ҷамъ карданд, Мордахай дар дарбори шоҳ хизмат менамуд. ");
INSERT INTO tgk_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Эстер бошад, дар бораи хешовандону халқи худ, чунон ки падархондаш Мордахай ба вай амр дода буд, ба касе чизе нагуфт. Ӯ ба монанди давраи кӯдакӣ ҳамаи гуфтаҳои Мордахайро гӯш мекард. ");
INSERT INTO tgk_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Рӯзе, ҳангоме ки Мордахай дар дарбор хизмат мекард, ду дарбон — Биғтон ва Тораш ба қаҳр омада, мехостанд шоҳро кушанд. ");
INSERT INTO tgk_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Мордахай аз ин хабардор шуда, ба малика Эстер расонид ва ӯ ба шоҳ аз номи Мордахай ҳодисаро нақл кард. ");
INSERT INTO tgk_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Баъд аз тафтиши ҳодиса фаҳмиданд, ки ҳақиқатан дарбонон чунин нақша кашида будаанд. Пас онҳоро дастгир карда, ба дор овехтанду тамоми ҳодиса дар ҳузури шоҳ дар китоби ёддоштҳо навишта шуд. ");
INSERT INTO tgk_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Пас аз чанд вақт шоҳ Аҳашверӯш ба Ҳаман — писари Ҳамдотой аз насли Аҷоҷ, вазифаи баланд дода, ӯро болои ҳамаи мансабдорон сарвазир гузошт. ");
INSERT INTO tgk_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Мувофиқи фармони шоҳ ҳамаи дарбориёне, ки дар қаср хизмат мекарданд, ба Ҳаман таъзим карда, зону мезаданд. Аммо Мордахай на таъзим мекарду на зону мезад. ");
INSERT INTO tgk_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Дарбориён аз Мордахай мепурсиданд: «Эй! Барои чӣ ту фармони шоҳро иҷро намекунӣ?» ");
INSERT INTO tgk_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Онҳо ҳар рӯз инро ба ӯ мегуфтанду лекин вай ба гапашон ҳеҷ аҳамият намедод. Мордахай гуфта буд, ки ӯ яҳудӣ аст. Аз ин рӯ, дарбориён корҳои Мордахайро ба Ҳаман расониданд, то бубинанд, ки оё Мордахай дар гапаш меистад ё не. ");
INSERT INTO tgk_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Вақте Ҳаман дид, ки Мордахай пеши вай на таъзим мекунаду на зону мезанад, сахт ба ғазаб омад. ");
INSERT INTO tgk_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Лекин куштани танҳо Мордахайро барои худ басанда нашуморид. Ба Ҳаман гуфта буданд, ки Мордахай аз кадом халқ аст. Барои ҳамин Ҳаман нақшаи нобуд кардани тамоми халқи яҳудӣ, яъне халқи Мордахайро кашид, ки дар саросари шоҳигарии Аҳашверӯш зиндагӣ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Баҳори соли дувоздаҳуми ҳукмронии шоҳ Аҳашверӯш, дар пеши Ҳаман барои интихоби рӯз ва моҳи беҳтарини нобуд кардани яҳудиён қуръа (яъне пур бо забони форсии қадим) партофтанд. Қуръа ба ҳафтуми марти соли оянда афтод. ");
INSERT INTO tgk_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Сипас Ҳаман ба шоҳ Аҳашверӯш гуфт: «Халқе ҳаст, ки дар ҳамаи вилоятҳои сарзамини шоҳ, байни мардум пароканда шудаасту аз дигарон худро ҷудо мекунад. Урфу одаташон аз дигар халқҳо фарқ дорад ва ба қонуну қоидаи шоҳ гӯш намедиҳанд. Бинобар ин, бар манфиати шоҳ нест, ки онҳоро тоқат кунад. ");
INSERT INTO tgk_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Агар ба шоҳ писанд афтад, бигузор фармоне барорад, ки ин халқ пурра нобуд шавад. Ман бошам, ба дасти хизматгорони шоҳ сию панҷ ҳазор кило нуқра медиҳам, то ки ба хазинаи шоҳ гузоранд». ");
INSERT INTO tgk_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Инак, шоҳ ангуштаринро, ки мӯҳри расмиаш буд, аз дасташ кашида ба Ҳаман — писари Ҳамдотои аҷоҷӣ, душмани яҳудиён дода, гуфт: ");
INSERT INTO tgk_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","«Пулро ба худат мон ва ҳар чи ки мехоҳӣ, бо ин халқ бикун». ");
INSERT INTO tgk_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Сипас ҳабдаҳуми апрел котибони шоҳро ҷамъ карданд. Онҳо фармонро аз рӯйи ҳамаи гуфтаҳои Ҳаман бо хати ҳар як вилоят ва бо забони ҳар як халқ, ба ҳокимони вилоятҳои подшоҳ, ҳокимони ноҳияҳо ва ба мирони халқҳо навиштанд. Фармонро аз номи шоҳ Аҳашверӯш навишта, бо ангуштаринаш мӯҳр заданд. ");
INSERT INTO tgk_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Хабаррасонон номаҳои тайёршударо ба ҳамаи вилоятҳои шоҳ бурданд. Дар номаҳо навишта шуда буд, ки ҳамаи яҳудиён, пиру ҷавон ва занону кӯдаконро дар муддати як рӯз — ҳафтуми марти соли оянда кушта, несту нобуд гардонанд. Илова бар ин, ҳамаи дороияшонро бо зӯрӣ кашида гиранд. ");
INSERT INTO tgk_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Нақша чунин буд, ки нусхаи ин ҳуҷҷат ҳамчун қонун дар ҳар вилоят бароварда, ба ҳамаи халқҳо эълон шавад, то ки онҳо барои он рӯз тайёрӣ бинанд. ");
INSERT INTO tgk_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Хабаррасонон бо фармони шоҳ зуд равона шуданду ҳамзамон онро дар қалъаи Шушан эълон карданд. Подшоҳ бо Ҳаман нишаста, шароб менӯшиданд, лекин сокинони шаҳри Шушан ҳайрону саргардон шуданд. ");
INSERT INTO tgk_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Мордахай аз ин ҳодиса хабардор шуда, мотам гирифт. Либосашро даронида, ҷомаи азодорӣ пӯшиду хокистар ба сараш пошид ва дар шаҳр гашта, гиряву фиғони баланд бардошт. ");
INSERT INTO tgk_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Ӯ фақат то назди дарвозаи подшоҳ омад, зеро азодор ҳуқуқ надошт ба қаср дарояд. ");
INSERT INTO tgk_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Ҳамзамон дар ҳар вилояте, ки амр ва фармони подшоҳ расид, ҳамин хел ғаму андӯҳи азиме байни яҳудиён буд. Онҳо гиряву нола карда, рӯза гирифтанду аксарияташон болои матои дурушт ва хокистар дароз кашиданд. ");
INSERT INTO tgk_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Вақте канизону хоҷасароёни Эстер ба ӯ аз ҳолати Мордахай хабар доданд, малика хеле хавотир гашта, ҷигархун шуд. Эстер ба Мордахай либос фиристод, то ки ба ҷойи либоси азодориаш бипӯшад, вале Мордахай онро қабул накард. ");
INSERT INTO tgk_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Он гоҳ Эстер Ҳатох — хоҷасароеро, ки шоҳ барои хизматаш дода буд, ҷеғ зада, ба назди Мордахай фиристод, то фаҳмад, ки ҳамаи ин чӣ маъно дорад ва барои чист. ");
INSERT INTO tgk_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Ҳатох ба майдони шаҳр, ки назди дарвозаи қаср воқеъ буд, ба пеши Мордахай рафт. ");
INSERT INTO tgk_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Мордахай дар бораи воқеаи бо вай рӯйдода ва миқдори муайяни нуқрае, ки Ҳаман барои несту нобуд кардани яҳудиён ба хазинаи шоҳ ваъда кардааст, ба ӯ нақл кард. ");
INSERT INTO tgk_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Баъд нусхаи фармони шоҳро дар бораи нобуд кардани яҳудиён, ки дар Шушан баромада буд, ба Ҳатох дод, то ба Эстер нишон диҳаду фаҳмонад. Инчунин Эстерро вазифадор кунад, ки ба назди шоҳ даромада, барои халқаш зорию тавалло намояд. ");
INSERT INTO tgk_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Пас Ҳатох омада, суханони Мордахайро ба Эстер нақл кард. ");
INSERT INTO tgk_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Эстер Ҳатохро боз назди Мордахай фиристод, то бигӯяд: ");
INSERT INTO tgk_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","«Ҳамаи дарбориён ва мардуми тамоми вилоятҳо медонанд, ки ба қисми дарунии қасри подшоҳ бе даъват даромадан манъ аст. Хоҳ мард бошад, хоҳ зан, агар бе даъвати шоҳ ба наздаш дарояд, мувофиқи қонун кушта хоҳад шуд. Танҳо дар як ҳолат зинда мондан мумкин, ба шарте ки шоҳ асои тиллоияшро сӯйи шахси даъватнашуда дароз кунад. Маро бошад, шоҳ ба наздаш сӣ рӯз боз даъват накардааст». ");
INSERT INTO tgk_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Суханони Эстерро ба Мордахай расонданд. ");
INSERT INTO tgk_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","Мордахай дар ҷавоби Эстер гуфт: «Фикр накун, ки дар хонаи шоҳ танҳо ту аз байни яҳудиён наҷот меёбӣ. ");
INSERT INTO tgk_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Агар ту дар ин вақт хомӯш бимонӣ, наҷот ва халосӣ барои яҳудиён аз тарафи дигар меояд. Лекин ту ва хонадони падарат нобуд мешавед. Кӣ медонад, шояд барои ҳамин вақт ту малика интихоб шуда бошӣ». ");
INSERT INTO tgk_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Пас Эстер дар ҷавоб ба Мордахай гуфт: ");
INSERT INTO tgk_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","«Бирав, ҳамаи яҳудиёни Шушанро ҷамъ кун ва барои ман се шабонарӯз рӯза гиред. Шабу рӯз ҳеҷ чиз нахӯреду нанӯшед, ман ҳам бо канизонам рӯза мегирам. Баъд аз се рӯз, агарчи ин бар зидди қонун аст, ба назди шоҳ медароям ва агар бимирам, ба тақдирам тан медиҳам». ");
INSERT INTO tgk_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Бо ҳамин, Мордахай рафта, ҳамаи фармоишҳои Эстерро иҷро кард. ");
INSERT INTO tgk_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Дар рӯзи сеюми рӯзадорӣ малика Эстер либосҳои шоҳонаашро пӯшид. Ӯ ба қисми дарунии қаср, ки дар рӯ ба рӯйи толори подшоҳ буд, даромада, истод. Подшоҳ дар толори шоҳона бар тахти шоҳӣ менишаст ва тахти ӯ дар рӯ ба рӯйи даромадгоҳ буд. ");
INSERT INTO tgk_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Вақте дид, ки малика дар қисми дарунӣ истодааст, ба назараш писанд афтод. Шоҳ асои тиллоияшро дароз карду Эстер омада, дасташро ба нӯги он расонд. ");
INSERT INTO tgk_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","«Чӣ шуд, малика Эстер? Чӣ ҳодиса рӯй дод? Хоҳиши ту чист? Ҳатто агар то нисфи подшоҳиямро талаб кунӣ, ба ту медиҳам». ");
INSERT INTO tgk_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","«Агар подшоҳ хоҳад, имрӯз бо Ҳаман ба зиёфате, ки ман барои шоҳ тайёр кардаам, биёянд». ");
INSERT INTO tgk_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Шоҳ ба хизматгоронаш гуфт: «Ҳаманро зуд рафта, биёред, то ки хоҳиши Эстерро иҷро намоем». Ҳамин тавр, шоҳ ва Ҳаман ба зиёфати малика Эстер рафтанд. ");
INSERT INTO tgk_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Вақте ки онҳо май менӯшиданд, шоҳ аз Эстер боз як бори дигар пурсид: «Хоҳишат чист? Он иҷро хоҳад шуд. Чӣ дархосте дорӣ? Ҳатто агар то нисфи подшоҳиямро талаб кунӣ, ба ту медиҳам». ");
INSERT INTO tgk_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Эстер ҷавоб дод: «Хоҳиш ва дархости ман ин аст: ");
INSERT INTO tgk_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","агар ба назари подшоҳ писанд ояду хоҳад, ки хоҳишамро қонеъ ва дархостамро иҷро намояд, бигзор шоҳ ва Ҳаман боз ба зиёфати дигар биёянд, ки ман барои онҳо пагоҳ тайёр мекунам. Ҳангоми он зиёфат хоҳишамро ба подшоҳ хоҳам гуфт». ");
INSERT INTO tgk_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Ҳамон рӯз Ҳаман хушҳолу хурсанд шуда, баромада рафт. Ҳангоми баромадан Мордахайро дар дарбор дида, пай бурд, ки ӯ ба ҳурмати вай аз ҷояш намехезад. Ҳаман аз муносибати Мордахай сахт ба ғазаб омад. ");
INSERT INTO tgk_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Ба ҳар ҳол вай базӯр худро дошта, ба хона рафт. Дар хона занаш — Зареш ва дӯстонашро ҷамъ оварда, ");
INSERT INTO tgk_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","ба онҳо аз бойигарии бузурги худ ва писарони бисёраш худнамоӣ мекард. Инчунин аз он ки чӣ қадар шоҳ ӯро бузург гардонду аз мансабдорон ва дарбориёни дигар баланд гузошт, худситоӣ менамуд. ");
INSERT INTO tgk_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","«Ва на танҳо ин, — илова намуд ӯ. — Ман ягона одаме мебошам, ки малика Эстер барои шоҳро дар зиёфаташ ҳамроҳӣ намудан даъват кард. Пагоҳ вай ману шоҳро боз даъват намудааст. ");
INSERT INTO tgk_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Лекин бо вуҷуди ҳамаи ин, фақат дар он вақт қаноатманд мешавам, ки дигар Мордахайи яҳудиро дар дарбор набинам». ");
INSERT INTO tgk_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Занаш Зареш ва ҳамаи дӯстонаш ба вай маслиҳат доданд: «Фармон бидеҳ, ки як дори бисту се метр баланд бисозанду пагоҳ саҳар аз подшоҳ хоҳиш кун, ки Мордахайро дар он овезанд. Сипас ҳамроҳи шоҳ хушу хурсандона ба зиёфат бирав». Ҳаман пешниҳодро маъқул карда, фармон дод, ки дорро тайёр кунанд. ");
INSERT INTO tgk_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Худи ҳамон шаб хоби подшоҳ парид. Бинобар ин фармон дод, ки китоби ёддоштҳоро оварда, дар наздаш хонанд. ");
INSERT INTO tgk_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Ҳангоме ки китобро мехонданд, дар он қайде ёфт шуд, ки чӣ тавр Мордахай дар бораи нақшаи куштори подшоҳ хабар дода буд (ҳамон нақшаи куштори шоҳ, ки дарбонон — Биғтон ва Тораш кашида буданд). ");
INSERT INTO tgk_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","«Ба Мордахай барои ин кораш чӣ мукофот дода шуд?» — пурсид шоҳ. «Ҳеҷ чиз», — ҷавоб доданд хизматгоронаш. ");
INSERT INTO tgk_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Шоҳ пурсид: «Назди дар ягон кас ҳаст?» Ҳаман бошад, ҳозиракак ба қисми берунии қаср даромада буд, то ки бо шоҳ дар бораи овехтани Мордахай дар дори тайёршуда гуфтугӯ кунад. ");
INSERT INTO tgk_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Хизматгорон дар ҷавоб ба шоҳ гуфтанд: «Ана, Ҳаман омадааст». «Бигзор дарояд», — фармон дод шоҳ. ");
INSERT INTO tgk_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Чун Ҳаман даромад, шоҳ аз ӯ пурсид: «Барои нафаре, ки шоҳ сарбаланду ифтихорманд гардондан мехоҳад, чӣ бояд кард?» Ҳаман бошад ба худ фикр кард: «Оё ба ғайр аз ман боз касе ҳаст, ки подшоҳ мехост ифтихорманд гардонад? Албатта не». ");
INSERT INTO tgk_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Аз ин рӯ, ба подшоҳ гуфт: «Барои нафаре, ки подшоҳ мехоҳад ифтихорманд гардонад, ");
INSERT INTO tgk_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","ҷомаи шоҳонаи подшоҳ, ки худи шоҳ пӯшидааст, оварда шавад. Инчунин асперо бо тоҷи шоҳона бар сар, ки худи шоҳ дар он савор шудааст, биёранд. ");
INSERT INTO tgk_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Сипас, ҳамаи ин чизҳо ба яке аз мансабдорони олимартабаи шоҳ дода шавад. Бигзор ӯ касеро, ки шоҳ сарбаланд гардондан мехоҳад, ҷомаи шоҳона пӯшонад. Инчунин ӯро болои асп дар маркази шаҳр бигардонаду пешопеш роҳ рафта, эълон намояд: „Мукофоти шахсеро, ки шоҳ сарбаланд гардондан мехоҳад, бубинед!“». ");
INSERT INTO tgk_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","«Худи ҳозир рафта, ҷомаву аспро бигир ва чунон ки гуфтӣ, ҳамон тавр барои Мордахайи яҳудӣ, ки дар дарбор хизмат мекунад, бикун, — амр кард подшоҳ. — Ҳеҷ чизро аз гуфтаҳоят фаромӯш накун». ");
INSERT INTO tgk_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Ҳамин тавр, Ҳаман ҷомаву аспро гирифт. Ҷомаро ба Мордахай пӯшониду вайро дар асп савор карда, дар маркази шаҳр гардонид. Инчунин пешопеши ӯ эълон намуда, фарёд кард: «Мукофоти шахсеро, ки шоҳ сарбаланд гардондан мехоҳад, бубинед!» ");
INSERT INTO tgk_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Баъд аз ин Мордахай ба дарбори подшоҳ баргашт. Ҳаман бошад рӯяшро аз шарм пӯшида, зуд ба хона шитофт. ");
INSERT INTO tgk_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Дар хона воқеаи бо вай рӯйдодаро ба занаш — Зареш ва дӯстонаш нақл кард. Сипас занаш бо он дӯстони хирадмандаш ба ӯ гуфтанд: «Азбаски Мордахай, ки бар вай дигар қудрат надорӣ, яҳудӣ аст, бар зидди ӯ истодагарӣ карда наметавонӣ. Ту, бешубҳа, шикаст хоҳӣ хӯрд!» ");
INSERT INTO tgk_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Ҳангоме ки онҳо ҳанӯз бо ӯ сӯҳбат мекарданд, хизматгорони шоҳ омада, зуд Ҳаманро ба зиёфати Эстер бурданд. ");
INSERT INTO tgk_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Ҳамин тавр, подшоҳ ва Ҳаман ба зиёфати дуюми малика Эстер рафтанд. ");
INSERT INTO tgk_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Ҳангоме ки онҳо май менӯшиданд, подшоҳ бори дигар аз малика пурсид: «Хоҳишат чист? Он иҷро хоҳад шуд. Бигӯй, чӣ дархосте дорӣ? Ҳатто агар то нисфи подшоҳиямро талаб кунӣ, ба ту дода мешавад». ");
INSERT INTO tgk_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Малика ҷавоб дод: «Эй подшоҳ, агар писанди назари шумо бошам ва маъқул донед, илтиҷо менамоям, ки ҷони ману халқамро наҷот диҳед. ");
INSERT INTO tgk_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Агар мо фақат ҳамчун ғулом фурӯхта мешудем, хомӯш мемондаму чизе намегуфтам, чунки подшоҳро бо чунин дархост халалдор кардан раво нест. Лекин сабаб дар он аст, ки ман бо халқам ба куштану несту нобуд шудан фурӯхта шудаем». ");
INSERT INTO tgk_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Подшоҳ аз малика пурсид: «Кист он одам?! Куҷост он нафаре, ки ба чунин коре ҷуръат намудааст?!» ");
INSERT INTO tgk_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Эстер хитоб кард: «Душмани ашаддӣ ҳамин Ҳамани бадкор аст!» Инро шунида, Ҳаман назди подшоҳ ва малика ба даҳшат афтод. ");
INSERT INTO tgk_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Подшоҳ оташин шуда, аз ҷояш хесту аз зиёфат баромада, ба боғи қаср рафт. Чун Ҳаман ҳис кард, ки шоҳ ӯро нобуд кардан мехоҳад, назди малика истод, то барои халосии ҷонаш ӯро илтиҷо намояд. ");
INSERT INTO tgk_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Ӯ худро бо зорию тавалло болои кати Эстер партофта буд, ки подшоҳ аз боғи қаср баргашт. Подшоҳ дод зад: «Вай ҳатто ҷуръат мекунад, ки дар ҳузури ман ба номуси малика расад?!» Ҳамин ки подшоҳ инро гуфт, рӯйи Ҳаманро пӯшониданд. ");
INSERT INTO tgk_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Пас Ҳарбӯно — яке аз хизматгорони шахсии шоҳ, ки он ҷо буд, гуфт: «Инак, дори бисту семетра дар ҳавлии Ҳаман тайёр аст. Вай онро барои Мордахай, ки барои шоҳ кори нек карда буд, сохтааст». Подшоҳ амр дод: «Худашро ба ҳамон дор овезед!» ");
INSERT INTO tgk_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Ҳамин тавр, Ҳаманро дар доре, ки ӯ барои Мордахай сохта буд, овехтанд. Сипас ғазаби подшоҳ паст шуд. ");
INSERT INTO tgk_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Худи ҳамон рӯз шоҳ Аҳашверӯш молу мулк ва чизу чораи Ҳаман — душмани яҳудиёнро ба малика Эстер дод. Мордахай акнун назди подшоҳ даромад, зеро Эстер ба шоҳ гуфт, ки онҳо хешанд. ");
INSERT INTO tgk_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Баъдан подшоҳ ангуштаринашро, ки аз Ҳаман гирифта шуда буд, аз дасташ кашида, ба дасти Мордахай супорид. Эстер бошад Мордахайро бар дороии Ҳаман ҷавобгар намуд. ");
INSERT INTO tgk_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Малика Эстер бори дигар бо подшоҳ гап зада, худро пеши пояш партофту гиря кард. Ӯ зорию тавалло намуд, ки нақшаи бади зидди яҳудиён тайёркардаи Ҳаманро бекор намояд. ");
INSERT INTO tgk_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Сипас подшоҳ асои тиллоияшро ба Эстер дароз кард ва ӯ аз ҷояш бархоста, назди шоҳ истод. ");
INSERT INTO tgk_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","«Агар ин кор ба подшоҳ дуруст намояду дар назари шоҳ эътибор дошта бошам, — илтиҷо кард малика, — бигзор қонун барояд, ки ҳамаи номаҳои Ҳаман, писари Ҳамдотои аҷоҷӣ, ки барои нобуд кардани яҳудиёни ҳамаи вилоятҳои подшоҳ навишта буд, бекор карда шаванд. ");
INSERT INTO tgk_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Чӣ тавр ба ин балое, ки ба сари халқам меояд, тоб оварам? Нобудшавии оилаамро чӣ гуна тоқат кунам?» ");
INSERT INTO tgk_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Подшоҳ ба малика Эстер ва Мордахайи яҳудӣ гуфт: «Азбаски Ҳаман ба халқи яҳудиён ҳуҷум кард, ӯро ба дор овехтанд ва дороияшро аллакай ба Эстер додам. ");
INSERT INTO tgk_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Акнун аз номи подшоҳ қонуни нав оид ба яҳудиён, чӣ тавре ки дуруст мешуморед, бинависеду онро бо ангуштарини шоҳ мӯҳр бизанед. Ҳар қонуне, ки аз номи шоҳ навишта, бо ангуштаринаш мӯҳр зада шуда бошад, бекор карда намешавад». ");
INSERT INTO tgk_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Сипас бисту панҷуми июн котибони шоҳ даъват шуданд. Онҳо фармонро оид ба яҳудиён, аз рӯйи ҳамаи гуфтаҳои Мордахай бо хати ҳар як вилоят ва бо забони ҳар як халқ, ба ҳокимону мирони яксаду бисту ҳафт вилоят — аз Ҳиндустон то Эфиопия навиштанд. Фармон ба яҳудиён низ бо хату забони худашон навишта шуд. ");
INSERT INTO tgk_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Фармонро аз номи шоҳ Аҳашверӯш навишта, бо ангуштаринаш мӯҳр заданд. Мордахай онҳоро бо дасти хабаррасонҳо фиристод, ки ба аспҳои тездави махсус барои шоҳ парварида саворӣ буданд. ");
INSERT INTO tgk_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Фармони шоҳ ба яҳудиён ҳуқуқ дод, ки дар ҳар шаҳр барои муҳофизати худ ҷамъ шаванд. Ҳар қувваи мусаллаҳ аз ҳар халқ ё вилоят, ки ба онҳо ҳуҷум кунад, бо занону кӯдаконашон кушта, несту нобуд карда шавад. Илова бар ин ҳамаи дороияшонро бо зӯрӣ кашида гиранд. ");
INSERT INTO tgk_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Рӯзе ки ин амр бояд дар тамоми вилоятҳо иҷро шавад, ҳафтуми марти соли оянда буд. ");
INSERT INTO tgk_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Нақша чунин буд, ки нусхаи ин ҳуҷҷат ҳамчун қонун дар ҳар вилоят бароварда, ба ҳамаи халқҳо эълон шавад, то ки ҳамон рӯз яҳудиён барои аз душманонашон қасос гирифтан тайёр бошанд. ");
INSERT INTO tgk_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Хабаррасонҳо бо фармони шоҳ, дар аспҳои тездави подшоҳ савор шуда, зуд равона шуданду ҳамзамон онро дар қалъаи Шушан эълон карданд. ");
INSERT INTO tgk_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Мордахай бо либоси шоҳонаи кабуду сафед дар тан, тоҷи калони бо тилло орододашуда ва болопӯши бунафшранги қиматбаҳо аз назди шоҳ баромад. Дар Шушан садои шодию хурсандии сокинон баланд шуд. ");
INSERT INTO tgk_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Барои яҳудиён ин рӯзи пирӯзӣ, хурсандию шодмонӣ буд ва онҳоро дар ҳама ҷо эҳтиром мекарданд. ");
INSERT INTO tgk_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Ба ҳар вилояту шаҳр, ки амру фармони шоҳ расид, иду базми шодмонӣ байни яҳудиён барпо шуд. Бисёр ғайрияҳудиёни он сарзамин аз халқи Мордахай метарсиданду аз ин сабаб эълон намуданд, ки дини яҳудиро қабул карданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Ҳафтуми март фармони шоҳ бояд иҷро мешуд. Ҳамон рӯз душманони яҳудиён умед доштанд, ки бар яҳудиён ғолиб меоянд, лекин баръакси ҳодиса рӯй дод. Дар асл яҳудиён бар душманонашон ғолиб баромаданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Яҳудиён дар шаҳрҳояшон дар ҳамаи вилоятҳои сарзамини шоҳ ҷамъ омаданд, то ба онҳое, ки маргашонро мехостанд, ҳуҷум намоянд. Азбаски тарс аз яҳудиён ҳамаи халқҳоро фаро гирифта буд, ҳеҷ кас бар зидди онҳо истодагарӣ карда натавонист. ");
INSERT INTO tgk_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Тарс аз Мордахай ҳамаи мирони халқҳо, ҳокимони вилоятҳову ноҳияҳо ва хизматгорони дарбори шоҳро фаро гирифта буд ва аз ин сабаб онҳо яҳудиёнро дастгирӣ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Охир ба Мордахай вазифаи баланд доданду шӯҳраташ дар тамоми сарзамин паҳн шуд ва қудрати ӯ рӯз ба рӯз меафзуд. ");
INSERT INTO tgk_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Ҳамин тавр, яҳудиён, ҳар чи ки хостанд, бо душманони худ карданд. Бо шамшер ҳамаи онҳоро зада куштанд ва несту нобуд намуданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Дар худи қалъаи шоҳ яҳудиён панҷсад нафарро куштанд. ");
INSERT INTO tgk_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","Онҳо инчунин Паршандато Далфӯн Аспото ");
INSERT INTO tgk_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","Пӯрото, Адалё, Аридото ");
INSERT INTO tgk_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","Паршамто, Арисой, Аридой ва Вайзото ном ҷавонмардонро куштанд. ");
INSERT INTO tgk_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","Инҳо даҳ писарони Ҳаман ибни Ҳамдотой, душмани яҳудиён буданд. Вале ба чизу чора ва молу мулкашон даст нарасониданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Худи ҳамон рӯз дар бораи шумораи одамони дар Шушан кушташуда ба шоҳ ҳисобот дода шуд. ");
INSERT INTO tgk_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Баъд шоҳ ба Эстер гуфт: «Дар худи қалъаи Шушан яҳудиён панҷсад нафар ва даҳ писари Ҳаманро куштанд. Дар дигар вилоятҳо чӣ кор карда бошанд? Акнун бигӯ, дархости ту чист? Он иҷро хоҳад шуд. Хоҳишат чист? Ба ту дода хоҳад шуд». ");
INSERT INTO tgk_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","«Агар ба шоҳ писанд афтад, — ҷавоб дод Эстер, — бигзор ба яҳудиён дар Шушан иҷозат дода шавад, ки пагоҳ низ аз рӯйи қонуни имрӯза амал намоянд. Илова бар ин, мурдаҳои даҳ писари Ҳаман ба дор овехта шаванд». ");
INSERT INTO tgk_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Ҳамин тавр, шоҳ амр дод, ки ин фармон иҷро шавад. Онро дар Шушан эълон намуданду мурдаҳои даҳ писари Ҳаман ба дор овехта шуданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Яҳудиён дар Шушан низ ҳаштуми март ҷамъ шуда, дар он ҷо сесад нафарро куштанд, лекин ба чизу чора ва молу мулкашон даст нарасониданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Дар ин ҳангом, яҳудиёни дигар дар вилоятҳои подшоҳ низ ҷамъ шуданд, то ки худро муҳофизат намуда, аз душманонашон халос шаванд. Яҳудиён ҳафтоду панҷ ҳазор нафар душманони худро куштанд, лекин ба чизу чора ва молу мулкашон даст нарасониданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Ҳамаи ин ҳафтуми март рӯй дод. Ҳаштуми март онҳо истироҳат карда, онро ба рӯзи базму шодмонӣ табдил доданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Лекин дар шаҳри Шушан яҳудиён барои худро муҳофизат намудан ҳам рӯзи ҳафтум ва ҳам ҳаштум ҷамъ шуданду рӯзи нӯҳумро ба базму шодмонӣ бахшиданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Барои ҳамин яҳудиёни деҳотӣ ҳаштуми мартро ҳар сол ҳамчун рӯзи шодмонӣ ва базм ҷашн мегиранд ва дар ин рӯз ба якдигар хӯрок мефиристанд. ");
INSERT INTO tgk_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Мордахай ин ҳодисаҳоро ба қайд гирифт ва ба ҳамаи яҳудиёни дуру наздики ҳамаи вилоятҳои подшоҳ Аҳашверӯш мактубҳо фиристод. ");
INSERT INTO tgk_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","Дар мактубҳо аз онҳо хоҳиш кард, ки ҳар сол рӯзҳои ҳаштуму нӯҳуми март ҳамчун ид ");
INSERT INTO tgk_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","бо базму шодмонӣ, фиристодани хӯрок ба якдигар ва додани тӯҳфаҳо ба камбағалон ҷашн гирифта шавад. Ин барои ёдбуди замонест, ки яҳудиён аз душманонашон халос шуда, ғамашон ба шодӣ ва мотамашон ба хурсандӣ табдил ёфта буд. ");
INSERT INTO tgk_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Ҳамин тавр, яҳудиён ба Мордахай гӯш карда, қарор доданд, ки идро чун анъана қабул намоянду ҳамасола ҷашн бигиранд. ");
INSERT INTO tgk_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Онҳо ба хотир меоварданд, ки Ҳаман писари Ҳамдотои аҷоҷӣ, ки душмани ҳамаи яҳудиён буд, яҳудиёнро куштанӣ шуда, барои несту нобуд сохтани онҳо қуръа (яъне пур) партофт. ");
INSERT INTO tgk_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Аммо ҳангоме Эстер назди подшоҳ даромад, ӯ фармон баровард, то нақшаи баде, ки Ҳаман барои яҳудиён тайёр карда буд, бар сари худаш омада, бо писаронаш ба дор овехта шавад. ");
INSERT INTO tgk_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Барои ҳамин ин идро Пурим, ки маънояш «қуръа» аст, номиданд. Ҳамин тавр, бо сабаби номаҳои Мордахай ва он чӣ онҳо аз сар гузарониданд, ");
INSERT INTO tgk_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","яҳудиён қарор доданд, ки ин анъанаро расман қабул кунанду ҳамасола ин ду рӯзро худашон, фарзандонашон ва онҳое ки дини яҳудиро қабул мекунанд, бояд қайд кунанд. Онро бояд дар вақту соати барои он муайяншуда, мувофиқи он чи ки навишта шуд, бе ягон мамоният ҷашн бигиранд. ");
INSERT INTO tgk_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Ин рӯзҳо бояд аз насл ба насл дар ҳар оила, вилоят ва шаҳр ба хотир оварда, нигоҳ дошта шавад. Ҷашн гирифтани рӯзҳои иди Пурим ҳеҷ гоҳ аз тарафи яҳудиён манъ карда нашавад ва ёди он аз байни наслҳои онҳо наравад. ");
INSERT INTO tgk_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Пас аз он Эстер — духтари Абиҳоил ҳамроҳи Мордахайи яҳудӣ бо тамоми қудрат мактуби дигарро навиштанд, то ки мактуби дуюмро дар бораи Пурим тасдиқ намоянд. ");
INSERT INTO tgk_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Нусхаҳои мактуби дигар бо суханони сулҳу осоиштагӣ ба ҳамаи яҳудиёни яксаду бисту ҳафт вилояти сарзамини шоҳ Аҳашверӯш фиристода шуданд. ");
INSERT INTO tgk_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Ин мактубҳо рӯзҳои Пуримро тасдиқ карданд, то ки дар рӯзи муайяншуда ҷашн гирифта шаванд, чунон ки Мордахай ва малика Эстер барояшон таъин карда буданд. Одамон қарор доданд, ки ин идро ҳамчун идҳои дигари рӯзаю нолаашон, ки барои худ ва наслҳояшон таъин карда буданд, ҷашн гиранд. ");
INSERT INTO tgk_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Ҳамин тавр, фармони малика Эстер анъанаҳои Пуримро тасдиқ намуд ва он дар китоб навишта шуд. ");
INSERT INTO tgk_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Сипас подшоҳ Аҳашверӯш тамоми сарзамин, ҳатто ҷазираҳои дурро ба андоз супоридан водор намуд. ");
INSERT INTO tgk_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Ҳамаи дастовардҳои калони подшоҳ ва бузургдошти Мордахай, ки шоҳ ӯро ба ин дараҷа расонд, дар Китоби Таърихи Подшоҳони Модай ва Форс навишта шудаанд. ");
INSERT INTO tgk_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Хуллас, Мордахайи яҳудӣ баъд аз подшоҳ Аҳашверӯш шахси дуввум буд. Вай дар байни яҳудиён одами бузург ҳисоб меёфту байни хешу табораш эҳтироми баланд дошт. Ин аз он сабаб буд, ки ӯ барои манфиати халқаш кор мекард ва барои беҳбудии ҳамаи яҳудиён баромад менамуд. ");
INSERT INTO tgk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Аҷдодони Исои Масеҳ, ки аз насли шоҳ Довуд ва аз насли Иброҳим мебошад, инҳоянд: ");
INSERT INTO tgk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","5","Аз замони Иброҳим то шоҳ Довуд инҳо гузаштаанд: Иброҳим, писараш Исҳоқ, писари Исҳоқ Ёқуб, писарони Ёқуб Яҳудо ва бародаронаш, писарони Яҳудо Форасу Зораҳ (модари онҳо Томор буд), писари Форас Ҳесрӯн, писари Ҳесрӯн Ром, писари Ром Аминодоб, писари Аминодоб Наҳшӯн, писари Наҳшӯн Салмӯн, писари Салмӯн Бӯаз (модари ӯ Роҳоб буд), писари Бӯаз Убид (модари ӯ Рут буд), писари Убид Йисой ва писари Йисой шоҳ Довуд. ");
INSERT INTO tgk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","11","Аз шоҳ Довуд то замони ба шаҳри Бобил асир шуда рафтани халқи Исроил инҳо гузаштаанд: Довуд, писараш Сулаймон (модари Сулаймон пештара зани Уриё буд), писари Сулаймон Раҳабъом, писари Раҳабъом Абиё, писари Абиё Осо, писари Осо Еҳӯшофот, писари Еҳӯшофот Еҳӯром, писари Еҳӯром Узиё, писари Узиё Ютом, писари Ютом Оҳоз, писари Оҳоз Ҳизқиё, писари Ҳизқиё Менашше, писари Менашше Омӯн, писари Омӯн Юшиё ва писарони Юшиё Еконеву бародаронаш. Дар ин вақт исроилиён асир гашта ба шаҳри Бобил бурда шуданд. ");
INSERT INTO tgk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Аз замони ба Бобил асир шуда рафтани исроилиён то таваллуди Исо инҳо гузаштаанд: Еконё, писараш Шаалтиил, писари Шаалтиил Зарубобил, писари Зарубобил Абиҳуд, писари Абиҳуд Элёқим, писари Элёқим Озур, писари Озур Содӯқ, писари Содӯқ Ёкин, писари Ёкин Элиҳуд, писари Элиҳуд Элъозор, писари Элъозор Маттон, писари Маттон Ёқуб ва писари Ёқуб Юсуф, ки шавҳари Марям буд. Аз Марям Исо таваллуд ёфт, ки Масеҳ, яъне Таъиншудаи Худо номида шуд. ");
INSERT INTO tgk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Инак, аз Иброҳим сар карда то Довуд ҳамагӣ чордаҳ насл ва аз Довуд то замони ба Бобил асир шуда рафтани исроилиён чордаҳ насл ва аз замони асирӣ то таваллуди Масеҳ чордаҳ насл гузаштааст. ");
INSERT INTO tgk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Таваллуди Исои Масеҳ ин тавр рӯй додааст: Марям, модари Исо, номзади Юсуф буд, аммо пеш аз он ки онҳо зану шавҳар шаванд, дар шиками ӯ бо қудрати Рӯҳи Муқаддас кӯдак пайдо шуд. ");
INSERT INTO tgk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Азбаски Юсуф одами нек буд, нахост, ки Марямро дар пеши мардум ошкор сохта шарманда кунад. Барои ҳамин ӯ ният кард, ки пинҳонӣ аз вай ҷудо шавад. ");
INSERT INTO tgk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ҳангоме ки ӯ чунин фикр дошт, фариштаи Худованд дар хобаш аён шуда, ба ӯ гуфт: «Эй Юсуфи насли Довуд! Аз гирифтани Марям ба занӣ натарс, чунки ин кӯдак дар шиками вай бо қудрати Рӯҳи Муқаддас пайдо шудааст. ");
INSERT INTO tgk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ӯ Писаре таваллуд хоҳад кард ва ту ба Ӯ бояд Исо ном гузорӣ, чунки Ӯ халқи худро аз дасти гуноҳҳояшон наҷот хоҳад дод». ");
INSERT INTO tgk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ҳамаи ин воқеа барои ба амал омадани гуфтаҳои Худо, ки аллакай ба воситаи пайғамбар пешгӯӣ шуда буданд, рӯй дод: ");
INSERT INTO tgk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Духтаре ҳомиладор мешавад ва Писаре таваллуд мекунад, ки ба Ӯ Имонуил (Маънои ин ном „Худо бо мо“ аст) ном медиҳанд». ");
INSERT INTO tgk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Вақте Юсуф аз хоб бедор шуд, фармони фариштаи Худовандро иҷро кард, яъне Марямро ба занӣ гирифт. ");
INSERT INTO tgk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Аммо то вақти таваллуд шудани Писар бо Марям ҳамхоб нашуд. Ҳангоме ки Писар таваллуд шуд, Юсуф Ӯро Исо номид. ");
INSERT INTO tgk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Исо дар замони ҳукмронии подшоҳ Ҳиродус, дар деҳаи Байт-Лаҳми ноҳияи Яҳудия ба дунё омад. Баъд аз таваллуди Ӯ якчанд ситорашиносон аз сарзамини Шарқ ба шаҳри Ерусалим омада, ");
INSERT INTO tgk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","пурсиданд: «Куҷост он кӯдаки навзоде, ки Шоҳи Яҳудиён мешавад? Мо дидем, чӣ хел ситораи Ӯ аз тарафи шарқ баромад ва омадем, то ки ба Ӯ саҷда кунем». ");
INSERT INTO tgk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ҳангоме ки подшоҳ Ҳиродус ин суханонро шунид, безобита шуд ва баробари ӯ тамоми сокинони Ерусалим ҳам ошуфта гаштанд. ");
INSERT INTO tgk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Он гоҳ Ҳиродус ҳамаи сардорони рӯҳонӣ ва шариатдононро наздаш хонда, аз онҳо пурсид: «Таъиншудаи Худо дар куҷо бояд таваллуд ёбад?» ");
INSERT INTO tgk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Онҳо дар ҷавоб гуфтанд: «Дар Байт-Лаҳми ноҳияи Яҳудия, чунки дар яке аз китобҳои пайғамбарон чунин навишта шудааст: ");
INSERT INTO tgk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","„Эй Байт-Лаҳм, ки дар вилояти Яҳудия ҳастӣ, ту аз дигар шаҳрҳои бузурги Яҳудия ҳеҷ камӣ надорӣ, зеро аз байни зодаҳои ту сарваре мебарояд, ки барои халқи Исроили Ман монанди чӯпон мешавад“». ");
INSERT INTO tgk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Сипас, Ҳиродус ситорашиносонро даъват намуда, бо онҳо танҳо ба танҳо сӯҳбат кард. Ҳангоми сӯҳбат аз онҳо вақти аниқи пайдошавии он ситораро фаҳмида гирифт. ");
INSERT INTO tgk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Баъд онҳоро ба Байт-Лаҳм равона карда гуфт: «Биравед ва дар бораи он кӯдак бодиққат пурсуҷӯ кунед. Ҳамин ки Ӯро ёфтед, маро низ огоҳ созед, то ки ман ҳам рафта ба Ӯ саҷда кунам». ");
INSERT INTO tgk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Баъд аз сӯҳбат бо шоҳ ситорашиносон аз он ҷо ба сафар баромаданд. Дар аснои роҳ онҳо боз ҳамон ситораро диданд, ки аз тарафи шарқ баромада буд. Ситора пешопеши онҳо мерафт ва оқибат дар болои он ҷое, ки кӯдак буд, бозистод. ");
INSERT INTO tgk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Аз барои ин ситора шодии онҳо ҳадду каноре надошт. ");
INSERT INTO tgk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ситорашиносон ба хона даромаданд ва кӯдакро ҳамроҳи модараш Марям дидан замон таъзим намуда, ба кӯдак саҷда карданд. Онҳо тӯҳфаҳои арзандаро, ки аз тилло, атри қиматбаҳо ва ширеши хушбӯй барои дудкарданӣ иборат буданд, аз сандуқҳояшон гирифта ба Ӯ ҳадя намуданд. ");
INSERT INTO tgk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Дар хобашон бошад, Худо огоҳ кард, ки назди Ҳиродус барнагарданд, аз ин рӯ онҳо бо дигар роҳ ба ватанашон баргаштанд. ");
INSERT INTO tgk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Баъд аз рафтани ситорашиносон фариштаи Худованд дар хоби Юсуф зоҳир шуда, ба ӯ гуфт: «Эй Юсуф! Бархезу кӯдак ва модарашро гирифта, ба Миср бигурез. То вақте ки ба ту баро нагӯям, дар ҳамон ҷо бимон. Чунки Ҳиродус бо нияти куштан кӯдакро кофтуков мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Юсуф аз хоб бедор шуда, кӯдак ва занашро гирифта, дар бевақтии шаб ба Миср раҳсипор мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Дар он ҷо онҳо то вафоти Ҳиродус мемонанд. Худованд пештар ба забони пайғамбар гуфта буд, ки «Ман аз Миср Писарамро ҷеғ задам». Ана барои иҷро шудани ин гуфтаҳо ҳамаи ин ҳодиса рӯй дод. ");
INSERT INTO tgk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Вақте Ҳиродус фаҳмид, ки ситорашиносон ӯро фиреб доданд, сахт хашмгин шуд ва фармон дод, ки дар Байт-Лаҳм ва атрофи он ҳамаи писарбачаҳои синни дусола ва аз дусола поёнро кушанд. Чунки аз ситорашиносон вақти пайдошавии ситораро дониста буд. ");
INSERT INTO tgk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ҳамин тавр он чи Ирмиё пайғамбар пешгӯӣ карда буд, ба амал омад: ");
INSERT INTO tgk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Садое дар шаҳри Ромо ба гӯш мерасад, Ки садои гиряву фиғон аст. Роҳел барои фарзандонаш мегиряд ва тасаллӣ ёфта наметавонад, азбаски онҳо мурдаанд». ");
INSERT INTO tgk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Вақте ки Ҳиродус аз олам чашм пӯшид, фариштаи Худованд дар Миср ба хоби Юсуф даромад ");
INSERT INTO tgk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ва гуфт: «Эй Юсуф! Бархез, кӯдак ва модари Вайро гирифта, ба сарзамини Исроил баргард, зеро касоне, ки Ӯро куштанӣ буданд, мурданд». ");
INSERT INTO tgk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Инак, Юсуф бархеста, кӯдак ва модари Вайро гирифт ва ба Исроил баргашт. ");
INSERT INTO tgk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Лекин ӯ шунид, ки дар Яҳудия ба ҷои Ҳиродус писараш Аркилоус подшоҳӣ мекунад ва тарсид, ки ба он ҷо биравад. Баъд дар хобаш аён шуд, ки он ҷо наравад, бинобар ин онҳо роҳи вилояти Ҷалилро пеш гирифтанд. ");
INSERT INTO tgk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Пайғамбарон аллакай дар бораи Масеҳ пешгӯӣ карда гуфта буданд, ки «Ӯро Носирӣ хоҳанд номид». Ана барои иҷро шудани ин гуфтаҳо Юсуф бо оилааш дар шаҳри Носира сокин шуд. ");
INSERT INTO tgk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Вақте расид, ки марде бо номи Яҳёи Таъмиддиҳанда ба биёбони Яҳудия рафта, мардумро насиҳат карда мегуфт: ");
INSERT INTO tgk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Тавба кунед ва аз гуноҳҳоятон даст кашед, чунки подшоҳии Худо наздик аст». ");
INSERT INTO tgk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Яҳё ҳамонест, ки Ишаъё пайғамбар дар борааш гуфта буд: «Касе дар биёбон фарёд зада мегӯяд: Барои Худованд роҳ тайёр кунед! Онро рост намоед!» ");
INSERT INTO tgk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Яҳё дар тан либоси аз пашми шутур ва камарбанди чармӣ дошт, хӯрокаш бошад, малаху асали саҳроӣ буд. ");
INSERT INTO tgk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Мардум аз шаҳри Ерусалиму аз саросари Яҳудия ва аз тамоми гирду атрофи дарёи Урдун ба назди Яҳё меомаданд. ");
INSERT INTO tgk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Онҳо ба гуноҳҳои худ иқрор мешуданд ва Яҳё онҳоро дар дарёи Урдун таъмид медод. ");
INSERT INTO tgk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Инчунин бисёр одамони гурӯҳҳои динии фарисиёну саддуқиён барои таъмид ёфтан назди Яҳё омаданд. Яҳё омада истодани онҳоро дида, ба онҳо гуфт: «Эй морони маккор! Кӣ ба шумо гуфт, ки аз ҷазои дарпешистодаи Худо гурехта метавонед? ");
INSERT INTO tgk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Ҳатто фикр накунед, ки ба сабаби аз насли Иброҳим буданатон, ҷазо намебинед. Зеро ба шумо мегӯям, ки Худо аз ҳамин сангҳо барои Иброҳим насл ба вуҷуд оварда метавонад. Пас, чун дарахти мевадоре, ки меваи хуб медиҳад, дар амал нишон диҳед, ки ҳақиқатан тавба кардаед. ");
INSERT INTO tgk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Теша аллакай бар решаи дарахтон гузошта шудааст ва ҳар дарахте, ки меваи хуб намеоварад, бурида ба оташ партофта мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ман шуморо бо об таъмид медиҳам, ҳамчун шаҳодати он ки шумо тавба кардаед, аммо касе, ки баъд аз ман меояд, шуморо бо Рӯҳи Муқаддас ва бо оташ таъмид хоҳад дод. Ӯ аз ман басо тавонотар аст. Ман ҳатто лоиқи он нестам, ки ба кафши Вай патак шавам. ");
INSERT INTO tgk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Дар дасти Ӯ бел барои бод кардани гандум тайёр аст. Ӯ хирманашро тоза карда, гандуми худро ба анбор ҷамъ хоҳад кард, вале каҳро дар оташи хомӯшнашаванда месӯзонад». ");
INSERT INTO tgk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Дар ин вақт Исо аз вилояти Ҷалил назди дарёи Урдун омад, то ки аз Яҳё таъмид бигирад. ");
INSERT INTO tgk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Лекин Яҳё Ӯро аз ин кор боздоштанӣ шуда гуфт: «Исо, ин ман бояд аз Ту таъмид бигирам, Ту бошӣ, назди ман омадӣ!» ");
INSERT INTO tgk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Исо ба вай ҷавоб дод: «Бигузор ҳоло ин корро кунем, чунки аз рӯи хости Худо ин кори дуруст аст». Он гоҳ Яҳё розӣ шуд. ");
INSERT INTO tgk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ҳамин ки Исо таъмид ёфта, аз об баромад, дарҳол осмон кушода шуд ва Ӯ Рӯҳи Худоро дид, ки мисли кабӯтар ба поён фаромада дар болои Ӯ қарор гирифт. ");
INSERT INTO tgk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Сипас аз осмон нидое омад: «Ин Писари азизи Ман аст ва Ман аз Ӯ хеле хушнудам». ");
INSERT INTO tgk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Баъд аз ин воқеа Рӯҳи Муқаддас Исоро ба биёбон бурд, то ки иблис Ӯро биозмояд. ");
INSERT INTO tgk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Давоми чил шабу чил рӯз Исо рӯза дошт ва гурусна монд. ");
INSERT INTO tgk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Он гоҳ иблиси васвасакор назди Ӯ омада гуфт: «Ту Писари Худо ҳастӣ-ку, пас ба ин сангҳо фармон деҳ, ки нон шаванд». ");
INSERT INTO tgk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Лекин Исо ҷавоб гардонда гуфт: «Не, зеро дар навиштаҷот гуфта шудааст, ки инсон на фақат бо хӯрдани нон зинда аст, балки бо ҳар сухане, ки Худо мегӯяд». ");
INSERT INTO tgk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Сипас, иблис Исоро ба шаҳри муқаддас Ерусалим бурда, ба нуқтаи баландтарини Хонаи Худо гузошт ");
INSERT INTO tgk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ва ба Ӯ гуфт: «Ту Писари Худо ҳастӣ-ку, пас, худро аз ин ҷо поён парто. Охир дар навиштаҷот гуфта шудааст, ки „Худо ба фариштагони худ дар бораи Ту фармон хоҳад дод ва онҳо Туро бар болои дастонашон хоҳанд бардошт, то ки поят ба санге назанад“». ");
INSERT INTO tgk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","«Не! — ҷавоб дод Исо, — чунки дар навиштаҷот боз гуфта шудааст, ки мо набояд Худованд Худои худро бисанҷем». ");
INSERT INTO tgk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Баъд аз ин иблис Исоро ба болои кӯҳи хеле баланд бурд ва ҳамаи мамлакатҳои ҷаҳонро бо тамоми шукӯҳашон ба Ӯ нишон дода ");
INSERT INTO tgk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","гуфт: «Агар ба ман саҷда карда, маро парастиш намоӣ, ҳамаи инро ба Ту медиҳам». ");
INSERT INTO tgk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Исо ба ӯ гуфт: «Дур шав аз Ман, шайтон! Чунки дар навиштаҷот гуфта шудааст, ки мо бояд Худованд Худои худро бипарастем ва фақат ба Ӯ хизмат кунем». ");
INSERT INTO tgk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Он гоҳ иблис Исоро монда рафту фариштагон омада, ба Исо хизмат карданд. ");
INSERT INTO tgk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Дертар Яҳёро дастгир мекунанду ин хабар ба гӯши Исо мерасад ва Ӯ ба шаҳри Носираи вилояти Ҷалил меравад. ");
INSERT INTO tgk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Баъд барои истиқомат кардан, Исо аз Носира ба шаҳри Кафарнаҳум, ки дар назди кӯли Ҷалил ва дар ноҳияҳои Забулуну Нафтолӣ ҷойгир шудааст, меравад. ");
INSERT INTO tgk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ҳамин тавр суханони Ишаъё пайғамбар ба амал омаданд, ки гуфта буд: ");
INSERT INTO tgk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Эй ноҳияи Забулун ва Нафтолии дар сӯи кӯл, дар тарафи дигари дарёи Урдун ҷойгирбуда, вилояти Ҷалили ғайрияҳудиён ҳастӣ! ");
INSERT INTO tgk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Мардуме, ки дар торикии гуноҳ зиндагӣ мекарданд, равшании дурахшонро диданд ва бар онҳое, ки дар ин ноҳия таҳти сояи марг мезистанд, равшанӣ дурахшид». ");
INSERT INTO tgk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Аз ҳамин вақт Исо ба эълон кардани чунин пайғоми худ оғоз намуд: «Тавба кунед ва аз гуноҳҳоятон даст кашед, чунки подшоҳии Худо наздик аст!» ");
INSERT INTO tgk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ҳангоме ки Исо дар соҳили кӯли Ҷалил роҳ мерафт, ба кӯл тӯр андохта истодани ду бародар: Шимъӯн, ки ӯро боз Петрус меномиданд ва бародараш Андриёсро дид, чунки онҳо моҳигир буданд. ");
INSERT INTO tgk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Исо ба онҳо гуфт: «Омада Маро пайравӣ кунед, то ба ҷои моҳӣ ҷамъ кардани мардумро ба шумо омӯзам». ");
INSERT INTO tgk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Дарҳол онҳо тӯрҳои худро монда, Ӯро пайравӣ карданд. ");
INSERT INTO tgk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Исо роҳи худро давом медод, ки ду бародари дигар, Ёқуб ва Юҳанноро дид. Онҳо бо падарашон Забдой дар қаиқ буданд ва тӯрҳои худро таъмир мекарданд. Исо онҳоро низ даъват кард ");
INSERT INTO tgk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ва дарҳол онҳо қаиқ ва падарашонро монда, Ӯро пайравӣ карданд. ");
INSERT INTO tgk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Исо ба тамоми вилояти Ҷалил рафта, дар ибодатхонаҳо мардумро таълим медод, хабари хушро дар бораи подшоҳии Худо эълон мекард ва ба ҳар дарду бемории одамон шифо мебахшид. ");
INSERT INTO tgk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Аз ин сабаб овозаи Ӯ дар тамоми сарзамини Сурия низ паҳн мешуд ва мардум ба наздаш ҳамаи дардмандонро, ки ҳар гуна беморӣ доштанд, меоварданд. Дар байни онҳо девонагон, беморони эпилепсия ва шалҳо низ буданд ва Исо онҳоро шифо бахшид. ");
INSERT INTO tgk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Бинобар ин мардуми бениҳоят бисёре аз Ҷалилу Даҳ Шаҳр, аз Ерусалиму Яҳудия ва аз сарзамини он тарафи дарёи Урдун омада, аз пайи Исо мерафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Исо ин тӯдаи одамонро дида, ба болои теппае баромад ва дар ҳамон ҷо нишаст. Ҳангоме ки шогирдонаш дар гирди Ӯ ҷамъ омаданд, ");
INSERT INTO tgk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ӯ ба таълим додан оғоз кард: ");
INSERT INTO tgk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Хушбахтанд касоне, ки мӯҳтоҷи Худо буданашонро медонанд, чунки Худо дар ҳаёташон подшоҳӣ мекунад! ");
INSERT INTO tgk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Хушбахтанд касоне, ки ғаму андӯҳ доранд, зеро Худо онҳоро тасаллӣ медиҳад! ");
INSERT INTO tgk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Хушбахтанд касоне, ки хоксору дастнигари Худо ҳастанд, зеро онҳо ба рӯи замин ҳукмрон мешаванд! ");
INSERT INTO tgk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Хушбахтанд касоне, ки аз таҳти дил иҷро шудани хости Худоро мехоҳанд, зеро Худо хости онҳоро пурра иҷро мекунад! ");
INSERT INTO tgk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Хушбахтанд касоне, ки нисбати дигарон раҳму шафқат доранд, зеро Худо ба онҳо низ раҳму шафқат хоҳад кард! ");
INSERT INTO tgk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Хушбахтанд касоне, ки дилашон пурра ба Худо дода шудааст, зеро онҳо дар ҳузури Худо хоҳанд шуд! ");
INSERT INTO tgk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Хушбахтанд касоне, ки одамонро оштӣ мекунонанд, зеро Худо онҳоро фарзандони худ хоҳад хонд! ");
INSERT INTO tgk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Хушбахтанд касоне, ки ҳангоми иҷро кардани хости Худо азоб дода мешаванд, зеро Худо дар ҳаёташон подшоҳӣ мекунад! ");
INSERT INTO tgk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Хушбахтед шумо, вақте ки мардум аз барои Ман шуморо дашном ва азоб медиҳанд ва дар ҳаққатон бо тӯҳмат ҳар гуна сухани бад мегӯянд. ");
INSERT INTO tgk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Он гоҳ шоду хуррам бошед, зеро Худо дар осмон бароятон мукофоти калон дорад. Одамон пайғамбаронро низ, ки пеш аз шумо буданд, ҳамин тавр азоб медоданд. ");
INSERT INTO tgk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Шумо ҳамчун намак барои одамони ҷаҳон ҳастед. Вале агар намак сифаташро гум кунад, магар онро боз шӯр карда мешавад? Не, аз вай дигар фоидае нест. Онро фақат мепартоянд ва он зери по мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Шумо ҳамчун нур барои одамони ҷаҳон намоён ҳастед. Шаҳре, ки дар болои кӯҳ бино шудааст, нонамоён буда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Инчунин ҳеҷ кас чароғро даргиронда, ба таги тағора намегузорад, баръакс, онро ба чароғпоя мемонад, то ба ҳар касе, ки дар хона аст, равшанӣ диҳад. ");
INSERT INTO tgk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Пас, бигзор нури шумо ҳам ба одамон равшанӣ диҳад, то ки онҳо корҳои неки шуморо дида, ба Падаратон, ки дар осмон аст, раҳмат гӯянд. ");
INSERT INTO tgk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Фикр накунед, ки Ман барои вайрон кардани шариати Мӯсо ва таълимоти пайғамбарон омадаам. Ман на барои вайрон кардан, балки барои ба амал овардани онҳо омадаам. ");
INSERT INTO tgk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ба ростӣ ба шумо мегӯям, ҳанӯз ки замину осмон ҳаст, то мақсади ин шариат пурра амалӣ нагардад, ягон рах ё нуқтае аз ҳарфи он нест намешавад. ");
INSERT INTO tgk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Инак, ҳар касе, ки хурдтарин фармоиши Худоро вайрон кунаду ба дигарон низ ҳаминро таълим диҳад, дар подшоҳии Худо хурдтарин шумурда хоҳад шуд. Ва баръакс, ҳар касе, ки ин фармоишро иҷро кунад ва ба дигарон айнан ҳамин чизро ёд диҳад, дар подшоҳии Худо бузург шумурда хоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Зеро ба шумо мегӯям, ки агар ҳатто аз шариатдонону фарисиён дида хости Худоро пурратар иҷро накунед, ҳаргиз ба подшоҳии Худо дохил намешавед. ");
INSERT INTO tgk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Шумо шунидаед, ки ба гузаштагон гуфта шуда буд, ки одамкуш нашаванд, инчунин „ҳар касе, ки одам мекушад, ба ҷавобгарӣ кашида мешавад“. ");
INSERT INTO tgk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Аммо Ман ҳоло мегӯям, ки агар касе ба бародаре қаҳру ғазаб кунад, ба ҷавобгарӣ кашида мешавад ва агар ба бародаре „бефаҳм“ гӯяд, дар назди суди болотар ҷавоб медиҳад ва агар „аҳмақ“ гӯяд, сазовори оташи дӯзах мегардад. ");
INSERT INTO tgk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Пас вақте ки шумо дар назди қурбонгоҳ ба Худо ҳадя оварданӣ мешаведу ба хотир меоред, ки бародаратон аз шумо норозигӣ дорад, бояд ");
INSERT INTO tgk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ҳадяатонро дар як тарафи қурбонгоҳ гузошта, дарҳол назди ҳамон бародаратон равед ва бо ӯ оштӣ шавед. Баъд аз ин омада ҳадяатонро тақдим намоед. ");
INSERT INTO tgk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Агар касе даъво карда, шуморо ба суд кашад, пеш аз суд зуд бо вай масъалаатонро ҳал намоед. Вагарна кор ба судшавӣ рафта расад, даъвогаратон метавонад шуморо ба дасти қозӣ супорад, қозӣ бошад ба дасти сарбоз ва шумо ҳабс шуданатон мумкин. ");
INSERT INTO tgk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ба ростӣ мегӯям, то охирин тангаи майдатаринро надиҳед, ҳаргиз аз ҳабс намебароед. ");
INSERT INTO tgk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Шумо чунин гуфтаҳоро шунидаед „Бо ҳеҷ кас алоқаи беникоҳ накун“. ");
INSERT INTO tgk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Аммо Ман ҳоло мегӯям, ҳар кас ки ба зан нигоҳ карда, дар хаёлаш бо ӯ ҳамбистар шудан хоҳад, аллакай дар дили худ чунин гуноҳро мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Пас, агар чашми ростатон шуморо ба гуноҳ кардан водор созад, онро канда партоед! Бароятон беҳтар аст, ки аз ягон узви бадан маҳрум шавед, назар ба он ки тамоми баданатон ба дӯзах партофта шавад. ");
INSERT INTO tgk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Инчунин агар дасти ростатон шуморо ба гуноҳ кардан водор созад, онро бурида партоед! Бароятон беҳтар аст, ки аз ягон узви баданатон маҳрум шавед, назар ба он ки тамоми баданатон ба дӯзах биафтад. ");
INSERT INTO tgk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Боз чунин гуфтаҳоро шунидаед, ки „Ҳар марде, ки аз занаш ҷудо мешавад, бояд ба ӯ талоқнома навишта диҳад“. ");
INSERT INTO tgk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Лекин Ман ҳоло ба шумо мегӯям, агар мард аз зани худ бо ягон сабаб, ба ғайр аз хиёнати вай, ҷудо шаваду занаш ба дигар кас ба шавҳар барояд, ин мард дар алоқаи беникоҳи занаш айбдор мешавад. Инчунин марде, ки бо зани ҷудошуда хонадор мешавад, гуноҳи алоқаи беникоҳро мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Шумо боз шунидаед, ки ба гузаштагон гуфта шуда буд, ки „қасами бардурӯғ нахӯранд, аммо ҳар қавлро, ки ба Худованд додаанд, иҷро намоянд“. ");
INSERT INTO tgk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Лекин Ман ҳоло ба шумо мегӯям, ки тамоман қасам нахӯред, на бо осмон, чунки тахти Худо дар он ҷост, ");
INSERT INTO tgk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","на бо замин, чунки пойҳои Ӯ дар он ҷо қарор доранд, на бо шаҳри Ерусалим, чунки ин шаҳри Худо-Шоҳи бузург аст. ");
INSERT INTO tgk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Бо сари худ ҳам қасам нахӯред, чунки як тори мӯятонро сафед ё сиёҳ ҳам карда наметавонед. ");
INSERT INTO tgk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Бигзор „бале“ гуфтани шумо дар ҳақиқат „бале“ бошад ва „не“ гуфтани шумо „не“ бошад, вале он чи зиёдатӣ мегӯед аз Шахси Бад бармеояд. ");
INSERT INTO tgk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Шумо чунин гуфтаҳоро шунидаед: „Чашм бар ивази чашм медиҳеду дандон бар ивази дандон“. ");
INSERT INTO tgk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Лекин Ман ҳоло ба шумо мегӯям, ки ба каси бад муқобилат накунед. Баръакс, агар касе ба тарафи рости рӯятон занад, тарафи чапи рӯятонро ҳам ба ӯ гардонед. ");
INSERT INTO tgk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Агар касе ба шумо даъво карда, куртаатонро гирифтанӣ бошад, ҷомаатонро ҳам ба ӯ бидиҳед. ");
INSERT INTO tgk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Агар касе шуморо маҷбур кунад, ки як километр роҳ равед, ду километр бо ӯ роҳ равед. ");
INSERT INTO tgk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Вақте ки касе аз шумо чизе талаб мекунад, онро ба ӯ бидиҳед ва аз шумо қарз гирифтанӣ шаванд, не нагӯед. ");
INSERT INTO tgk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Шумо чунин гуфтаҳоро шунидаед: „Ҳар шахсеро, ки наздики шумо аст, дӯст бидореду душманатонро бад бинед“. ");
INSERT INTO tgk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Лекин Ман ҳоло ба шумо мегӯям, ки душманонатонро дӯст бидоред, лаънаткунандагони худро баракат диҳед, ба касоне, ки шуморо бад мебинанд, некӣ кунед ва барои онҳое, ки шуморо азоб медиҳанд, дуо хонед, ");
INSERT INTO tgk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","то нишон диҳед, ки фарзандони Падари осмониатон ҳастед. Чунки Ӯ ба офтоб амр медиҳад, ки ҳам ба бадкорон ва ҳам ба накӯкорон равшанӣ кунад, инчунин боронро ҳам ба бадкорон ва ҳам ба накӯкорон мефиристад. ");
INSERT INTO tgk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Пас, агар шумо фақат касонеро дӯст доред, ки шуморо дӯст медоранд, чаро мукофот мегирифтаед? Магар андозгирони беинсоф низ ҳамин тавр рафтор намекунанд? ");
INSERT INTO tgk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ва агар фақат ба бародарони худ салом диҳед, аз дигарон дида чӣ кори бузургтаре мекунед? Беимонон низ ҳамин тавр рафтор мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Бинобар ин шумо беайбу нуқсон бошед монанди Падари осмонии худ, ки беайбу нуқсон аст». ");
INSERT INTO tgk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Исо суханонашро давом дода гуфт: «Зинҳор корҳои худофармударо намоишкорона дар пеши назари халқ накунед. Вагарна аз Падари осмониатон мукофот намегиред. ");
INSERT INTO tgk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Яъне, вақте ки садақа медиҳед, ба монанди одамони дурӯя ба ҳама овоза накунед. Онҳо дар ибодатхонаҳо ва дар сари кӯчаҳо садақа доданашонро эълон менамоянд, то ки мардум онҳоро таъриф кунанд. Ба ростӣ ба шумо мегӯям, онҳо аллакай мукофоти худро гирифтаанд. ");
INSERT INTO tgk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Аммо, ҳангоме ки шумо садақа медиҳед, бигзор дасти ростатон аз кори дасти чапатон огоҳ нашавад, ");
INSERT INTO tgk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","то ки садақаи шумо пинҳон монад. Он гоҳ Падари шумо, ки чизҳои пинҳониро мебинад, ба шумо мукофот медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Вақте ки дуо мекунед ба одамони дурӯя монанд нашавед! Онҳо дар ибодатхонаю чорраҳаҳо истода дуо хонданро дӯст медоранд, то ки ҳама онҳоро бинанд. Ба ростӣ ба шумо мегӯям, онҳо аллакай мукофоти худро гирифтаанд. ");
INSERT INTO tgk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Аммо, ҳангоме ки шумо дуо мехонед, ба хонаатон даромада, дарро пӯшед ва ба Падаратон, ки нонамоён аст, дуо кунед. Он гоҳ Падари шумо, ки чизҳои пинҳониро мебинад, ба шумо мукофот медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Дар вақти дуохонӣ низ мисли ғайрияҳудиён рафтор накунед. Онҳо дар дуо бисёр гапҳои беҳуда мегӯянд, чун фикр мекунанд, ки агар дуру дароз гап зананд, дуояшон шунида мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ба монанди онҳо дуо накунед, зеро Падаратон ҳанӯз пеш аз пурсиданатон медонад, ки ба шумо чӣ лозим аст. ");
INSERT INTO tgk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Пас шумо ин тавр бояд дуо кунед: Эй Падари мо, ки дар осмон ҳастӣ, Шаъну шараф бод ба номи муқаддаси Ту. ");
INSERT INTO tgk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Бигзор подшоҳии Ту барқарор гардад ва хости Ту, ки дар осмон иҷро мешавад, дар замин низ иҷро шавад. ");
INSERT INTO tgk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ба мо ризқу рӯзии имрӯзаамонро деҳ ");
INSERT INTO tgk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ва корҳои нодурусти моро бубахш, чи тавре ки мо низ онҳоеро мебахшем, ки бо мо нодуруст рафтор мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Моро ба озмоиш дучор накун, балки аз дасти Шахси Бад халос намо. ");
INSERT INTO tgk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Инак, агар шумо одамонеро, ки дар ҳаққи шумо рафтори нодуруст мекунанд, бубахшед, Падари осмониатон ҳам корҳои нодурусти шуморо хоҳад бахшид. ");
INSERT INTO tgk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Вале агар шумо дигаронро набахшед, Падари шумо ҳам корҳои нодурустатонро нахоҳад бахшид. ");
INSERT INTO tgk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Боз вақте ки рӯза мегиред, ба одамони дурӯя монанд шуда, чеҳраи рӯятонро ғамзада вонамуд накунед, чунки дурӯяҳо намуди зоҳириашонро беэътибор мемонанд, то дигарон бинанд, ки онҳо рӯза гирифтаанд. Ба ростӣ ба шумо мегӯям, ки онҳо аллакай мукофоти худро гирифтаанд. ");
INSERT INTO tgk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Лекин, вақте ки шумо рӯза мегиред, дасту рӯятонро шуста, мӯйҳоятонро шона кунед, ");
INSERT INTO tgk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","то ба ғайр аз Падаратон, ки нонамоён аст, дигар ҳеҷ кас рӯза гирифтани шуморо нафаҳмад. Он гоҳ Падари шумо, ки чизҳои пинҳониро мебинад, ба шумо мукофот хоҳад дод. ");
INSERT INTO tgk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Дар замин барои худ бойигарӣ ҷамъ накунед, ки дар ин ҷо куяву занг мезанад ва ғоратгарон зада даромада, онро медузданд. ");
INSERT INTO tgk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Баръакс, мукофоти Худоро ба даст оред, ки бароятон дар осмон нигоҳ дошта мешавад. Ана чунин бойигариро на куяву занг мезанаду на ғоратгарон зада даромада, медузданд. ");
INSERT INTO tgk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Зеро ба он ҷое, ки бойигарӣ доред, дилатон кашол аст. ");
INSERT INTO tgk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Чашм барои бадан ҳамчун чароғ аст. Пас агар чашматон солим бошад, тамоми баданатонро равшанӣ пур мекунад, ");
INSERT INTO tgk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","аммо агар чашматон солим набошад, тамоми баданатонро торикӣ пур мекунад. Дар ин сурат, агар равшанӣ дар даруни шумо дар асл торикӣ бошад, эҳ, пас он чи хел торикии зулмот аст! ");
INSERT INTO tgk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ҳеҷ кас якбора ба ду хоҷа хизмат карда наметавонад, чунки ё якеашро дӯст медораду дигарашро бад мебинад, ё ба яке вафодор мемонаду дигарашро писанд намекунад. Шумо низ наметавонед ҳам бандаи Худо бошеду ҳам бандаи пул. ");
INSERT INTO tgk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Бинобар ин ба шумо мегӯям, на ташвиши зиндагиатонро кунед, ки чӣ мехӯреду чӣ менӯшед ва на ғами баданро хӯред, ки чӣ мепӯшед. Магар зиндагӣ фақат аз хӯроку бадан аз пӯшок иборат аст? ");
INSERT INTO tgk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ба паррандаҳо нигоҳ кунед: онҳо на кишту кор мекунанду на ҳосил ҷамъ мекунанд ва на ба анборҳо ҳосилро захира мекунанд, ҳол он ки Падари осмониатон онҳоро мехӯронад. Магар шумо аз паррандаҳо арзиши баландтар надоред? ");
INSERT INTO tgk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Кадоме аз шумо бо ғам хӯрдан як лаҳзаи умратонро дарозтар карда метавонед? ");
INSERT INTO tgk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Барои сарулибос ҳам чӣ ғам мехӯред? Ба нашъунамои савсанҳои саҳро нигоҳ кунед: онҳо на меҳнат мекунанду на мересанд, ");
INSERT INTO tgk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","лекин ба шумо мегӯям, ки ҳатто шоҳ Сулаймон бо тамоми ҳашамату бойигариаш мисли яке аз онҳо либоси зебое напӯшидааст. ");
INSERT INTO tgk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Пас, агар Худо алаферо, ки имрӯз дар саҳро ҳасту пагоҳ ба танӯр партофта мешавад, ҳамин тавр пӯшонад, наход шуморо, эй сустимонҳо, аз онҳо чанд маротиба зиёдтар напӯшонад? ");
INSERT INTO tgk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Барои ҳамин ғам хӯрдану ташвиш кашиданро бас кунед ва нагӯед, ки „Мо чӣ мехӯрда бошем?“ ё „чӣ менӯшида бошем?“ ё „чӣ мепӯшида бошем?“ ");
INSERT INTO tgk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Чунки халқҳои дигар аз пайи ҳамаи ин чизҳо мебошанд. Падари осмониатон бошад, медонад, ки шумо ба ҳамаи он эҳтиёҷ доред. ");
INSERT INTO tgk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Шумо дар навбати аввал ҷӯяндаи подшоҳии Худо ва иҷрошавии хости Ӯ бошед ва Ӯ ҳамаи ин чизҳоро низ ба шумо медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Аз ин рӯ, ғами рӯзи ояндаро нахӯред, фардо ташвишҳои худро дорад. Ба ҳар рӯз ташвиши худи ҳамон рӯз басанда аст». ");
INSERT INTO tgk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Исо давом дода гуфт: «Дигаронро айбдор ҳисоб накунед, то ки шумо айбдор ҳисоб нашавед. ");
INSERT INTO tgk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Зеро чи хеле ки дигаронро айбдор ҳисоб кунед, ҳамон тавр шумо айбдор ҳисоб карда мешавед ва бо кадом санги тарозу баркашед, бо ҳамон санг ба шумо баркашида мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Чаро шумо хасро дар чашми бародаратон мебинеду чӯберо, ки дар чашми худатон ҳаст, ҳис намекунед? ");
INSERT INTO tgk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Чӣ хел ҷуръат карда ба бародаратон гуфта метавонед, ки „Иҷозат деҳ хасро аз чашмат берун кунам“, ҳол он ки дар чашми худатон чӯб доред? ");
INSERT INTO tgk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Эй дурӯяҳо! Аввал чӯбро аз чашми худатон дур кунед, он гоҳ дурусттар дида метавонед, ки чӣ хел хасро аз чашми бародаратон бароред. ");
INSERT INTO tgk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Чизеро ки муқаддас аст ба сагон надиҳед, вагарна онҳо рӯ гардонда ба шумо ҳамла меоваранд. Ва гавҳари худро пеши пойҳои хукон напартоед, вагарна онро поймол мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Талаб кунед ва ба шумо дода мешавад, биҷӯед ва пайдо мекунед, дарро бикӯбед ва он ба рӯятон кушода мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Чун ҳар кӣ талаб мекунад, ба даст меорад, ҳар кӣ меҷӯяд, пайдо мекунад ва ҳар кас ки дарро мекӯбад, он ба рӯяш кушода мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ана, аз байни шумо кадом падар агар писараш нон талаб кунад, ба вай санг медиҳад? ");
INSERT INTO tgk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ё агар моҳӣ талаб кунад, ба вай мори заҳрдор медиҳад? ");
INSERT INTO tgk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Пас, агар шумо бо тамоми дилсиёҳиатон ба фарзандони худ чӣ тавр чизҳои хуб доданро медониста бошед, наход Падари шумо, ки дар осмон аст, ба каси талабкарда чанд маротиба зиёдтар чизҳои хуб надиҳад?! ");
INSERT INTO tgk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Чӣ гуна рафторро аз дигарон нисбати худ дидан хоҳед, ҳамон тавр аввал худи шумо нисбати онҳо рафтор кунед. Зеро мағзи шариати Мӯсо ва гуфтаҳои пайғамбарон дар ҳамин аст. ");
INSERT INTO tgk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Аз дарвозаи танг гузаред, чунки дарвозаи васеъ ва роҳи осонгузар шуморо ба ҳалокат меоварад ва бисёр касон аз он мегузаранд. ");
INSERT INTO tgk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Лекин ба ҳаёти абадӣ шуморо дарвозаи басо тангу роҳи мушкилгузар меоварад ва кам касон онро меёбанд. ");
INSERT INTO tgk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Аз пайғамбарони бардурӯғ эҳтиёт шавед, онҳо ба назди шумо бо намуди гӯсфандони беозор меоянд, аммо дар ботин онҳо гургони дарранда ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Шумо онҳоро аз амалиёташон мешиносед. Охир аз буттаи хор ангур ё анҷир намечинанд-ку. ");
INSERT INTO tgk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ҳар дарахти солим меваи хуб медиҳад ва меваи бад дода наметавонад, вале дарахти касал меваи бад медиҳад ва меваи хуб дода наметавонад. ");
INSERT INTO tgk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ҳамаи дарахтоне, ки меваи хуб намеоваранд, бурида ба оташ партофта мешаванд. ");
INSERT INTO tgk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Хуллас, пайғамбарони бардурӯғро низ шумо аз маҳсули амалашон мешиносед. ");
INSERT INTO tgk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","На ҳама касоне, ки Маро доимо Худованди худ меноманд, ба подшоҳии Худо дохил мешаванд, балки фақат онҳое, ки хости Падари дар осмон будаамро иҷро мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ҳангоме ки рӯзи ҷавобдиҳӣ фаро мерасад, мардуми зиёд ба Ман мегӯянд: „Эй Худованд! Магар мо аз номи Ту пайғоми Худоро ба одамон эълон намекардем? Магар аз номи Ту девҳоро намерондем ва магар аз номи Ту бисёр мӯъҷизаҳоро нишон намедодем?“ ");
INSERT INTO tgk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Он гоҳ Ман ба рӯяшон мегӯям: „Эй бадкорон! Ман шуморо ҳеҷ гоҳ намешинохтам. Дур шавед аз наздам“. ");
INSERT INTO tgk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Инак, ҳар касе, ки ҳамаи ин гуфтаҳои Маро мешунаваду онҳоро иҷро мекунад, монанди бинокори дурандешест, ки хонаашро дар болои санг сохта буд. ");
INSERT INTO tgk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Баъд борон бориду обхезӣ шуд ва шамоли сахт хеста, бо шиддат бар он хона вазид, лекин хона фурӯ нарафт, чунки дар болои санг сохта шуда буд. ");
INSERT INTO tgk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Вале ҳар касе, ки ҳамаи гуфтаҳои Маро мешунаваду онҳоро иҷро намекунад, монанди бинокори беақлест, ки хонаашро дар болои хок сохта буд. ");
INSERT INTO tgk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Баъд борон бориду обхезӣ шуд ва шамоли сахт хеста, бо шиддат бар он хона вазид ва хона фурӯ рафта, ба замин яксон шуд». ");
INSERT INTO tgk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Исо суханони худро ба охир расонда буд, ки тамоми халқ қоил монданд, ");
INSERT INTO tgk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","зеро Ӯ на ба монанди шариатдонон, балки чун шахси боқудрат онҳоро таълим медод. ");
INSERT INTO tgk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Вақте ки Исо аз болои теппа поён фаромад, одамон тӯда-тӯда ҳамроҳи Ӯ рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Дар ин мобайн як марди махаве назди Исо омаду ба Ӯ таъзим карда гуфт: «Хоҷа, агар хоҳӣ, метавонӣ маро пок созӣ». ");
INSERT INTO tgk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Он гоҳ Исо дасташро ба ӯ расонда гуфт: «Албатта, мехоҳам, пок шав!» ва он мард дарҳол аз касалии махав пок гашт. ");
INSERT INTO tgk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Исо ба ӯ боз гуфт: «Дар ин бора зинҳор ба ҳеҷ кас нагӯй, балки рост назди рӯҳонӣ рафта, худро нишон деҳ. Баъд, чӣ тавре ки Мӯсо фармудааст, қурбонӣ бикун, то ба мардум шаҳодате гардад». ");
INSERT INTO tgk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Сипас Исо ба деҳаи Кафарнаҳум ворид шуд, ки ба наздаш як сардори лашкаре омад ва ба зорию илтиҷо даромада ");
INSERT INTO tgk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","гуфт: «Хоҷаам, хизматгорам аз ҳаракат монда, дар хона рӯи ҷойгаҳ хобидааст. Ӯ дар оташи дард сӯхта истодааст». ");
INSERT INTO tgk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","«Ман рафта ӯро сиҳат мекунам», — гуфт Исо. ");
INSERT INTO tgk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Аммо сардори лашкар ҷавоб дод: «Хоҷа! Ман лоиқи он нестам, ки аз остонаи дарам гузаред. Шумо фақат як амр диҳед ва хизматгорам шифо хоҳад ёфт. ");
INSERT INTO tgk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Охир ман як фармонбардор ҳастам ва зери итоати худ низ сарбозонро дорам. Вақте ки ба яке „бирав“ мегӯям, меравад, ба дигаре „биё“ мегӯям, меояд ва агар ба ғуломам „фалон корро бикун“ гӯям, ӯ албатта он корро иҷро мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Аз шунидани ин суханон Исо ҳайрон шуд ва ба мардуми аз пасаш омадаистода гуфт: «Ба ростӣ ба шумо мегӯям, ки ҳатто дар байни исроилиён касеро надидам, ки чунин имони сахт дошта бошад. ");
INSERT INTO tgk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ба шумо мегӯям, бисёр касон аз ҳар гӯшаву канори дунё омада, дар подшоҳии Худо бо Иброҳиму Исҳоқу Ёқуб дар сари як дастархон хоҳанд нишаст. ");
INSERT INTO tgk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Аммо онҳое, ки бояд дар подшоҳии Худо мешуданд, ба торикии берун партофта мешаванд, ки дар он ҷо одамон аз дард дандон ба дандон зада гиря мекунанд». ");
INSERT INTO tgk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Баъд ба сардори лашкар гуфт: «Бирав! Чи тавре ки имон доштӣ, ҳамон тавр мешавад». Ҳамон замон хизматгор шифо ёфт. ");
INSERT INTO tgk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Вақте ки Исо ба хонаи Петрус даромад, хушдомани Петрусро бо таби баланд, рӯи ҷойгаҳ хобида дид. ");
INSERT INTO tgk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Исо ба дасти вай даст расонд, ки табаш паст шуд ва зан аз ҷояш хеста, бо меҳмондорӣ кардани Ӯ машғул шуд. ");
INSERT INTO tgk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Он бегоҳ одамон бисёр девонагонро назди Исо оварданд ва Исо амр дода, рӯҳҳои нопокро аз онҳо берун ронд ва ҳамаи беморонро низ шифо бахшид. ");
INSERT INTO tgk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ишаъё пайғамбар пештар гуфта буд: «Ӯ ҳамаи касалиҳоямонро аз мо гирифт ва ҳамаи бемориҳоямонро ба дӯши худ бардошт». Барои ба амал омадани ин суханон ҳамаи ин ҳодисаҳо рӯй доданд. ");
INSERT INTO tgk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Боре Исо дар гирдаш ҷамъ шудани одамони зиёдро дида, ба шогирдонаш гуфт, ки ба дигар тарафи кӯл мераванд. ");
INSERT INTO tgk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Дар ҳамин вақт як шариатдон наздаш омада гуфт: «Устод, ман дар ҳама ҷо Шуморо пайравӣ мекунам». ");
INSERT INTO tgk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Исо ба ӯ ҷавоб дод: «Рӯбоҳон хона ва мурғони ҳаво лона доранд, аммо Ман, Фарзанди Инсон ҷое надорам, ки сарамро монда дам гирам». ");
INSERT INTO tgk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Дигаре аз ҷумлаи пайравон гуфт: «Хоҷаам! Иҷозат диҳед аввал рафта, мурдаи падарамро ба хок супорам». ");
INSERT INTO tgk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Лекин Исо ба вай ҷавоб гардонда гуфт: «Аз паси Ман биё ва бимон, ки мурдагон мурдаҳои худро ба хок супоранд». ");
INSERT INTO tgk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Он гоҳ шогирдон Исоро пайравӣ карда, якҷоя бо Ӯ ба қаиқ савор шуданд. ");
INSERT INTO tgk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Дар қаиқ Исо хоб мерафт, ки ногаҳон дар кӯл тӯфони сахте бархост ва аз шиддати мавҷҳо қаиқ қариб ғарқ мешуд. ");
INSERT INTO tgk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Шогирдон омада, Исоро бедор карданд ва гуфтанд: «Хоҷа! Наҷот деҳ! Ҳалок мешавем!» ");
INSERT INTO tgk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Исо ҷавоб дод: «Чӣ ин қадар метарсед? Ҳой, сустимонон!» Баъд бархеста шамолу мавҷҳоро таъна зад, дарҳол дар ҳама ҷо оромии том ҳукмфармо шуд. ");
INSERT INTO tgk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Онҳо бошанд, ҳайрон монда мегуфтанд: «Ин чӣ хел одам аст, ки ҳатто шамолу мавҷҳо ба Ӯ итоат мекунанд?» ");
INSERT INTO tgk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ҳангоме ки Исо ба тарафи дигари кӯл, ба вилояти Ҷадариён расид, ду девонае аз қабристон берун баромада бо Исо рӯ ба рӯ шуданд. Онҳо чунон бадхашм буданд, ки касе ҷуръати аз он роҳ гузаштанро надошт. ");
INSERT INTO tgk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Онҳо Исоро дида дод заданд: «Эй Писари Худо, Ту ба мо чӣ кор дорӣ? Ту омадӣ, ки моро пеш аз мӯҳлат азоб диҳӣ?» ");
INSERT INTO tgk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Дар масофае аз онҳо галаи калони хукон мечарид. ");
INSERT INTO tgk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Пас девҳо Исоро тавалло карда гуфтанд: «Агар моро берун карданӣ бошӣ, ба даруни он галаи хукон бифирист». ");
INSERT INTO tgk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Исо ба онҳо «Дароед» гуфт ва онҳо аз он одамон берун баромада, ба галаи хукон даромаданд. Фавран тамоми гала давон-давон худро аз ҷарии назди соҳил ба кӯл партофта, дар об ғарқ шуд. ");
INSERT INTO tgk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Хукбонон бошанд, аз он ҷо ба деҳа гурехта, ин воқеаро, аз он ҷумла ҳодисаи бо ду девона рӯй додаро ба ҳама нақл карданд. ");
INSERT INTO tgk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Инак, тамоми аҳли деҳа барои бо Исо вохӯрдан аз деҳа берун омаданд. Вақте Ӯро диданд, зориву тавалло карданд, ки аз сарзаминашон биравад. ");
INSERT INTO tgk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Исо ба қаиқ савор шуд ва аз кӯл гузашта ба шаҳри худ баргашта буд, ки ");
INSERT INTO tgk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","чанд нафаре ба наздаш шалеро бо ҷойгаҳаш бардошта оварданд. Исо то чӣ андоза эътиқод доштани онҳоро дида, ба шал гуфт: «Додар, натарс! Гуноҳҳоят бахшида шудаанд». ");
INSERT INTO tgk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Дар айни ҳол якчанд шариатдон аз дил гузаронданд: «Ин одам суханони кофирона мегӯяд». ");
INSERT INTO tgk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Исо фикри онҳоро фаҳмида гуфт: «Чаро дар дилҳои худ ба фикрҳои бад ҷой медиҳед? ");
INSERT INTO tgk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Кадомаш осонтар аст: гуфтани он, ки „гуноҳҳои ту бахшида шуданд“ ё гуфтани он, ки „бархез ва роҳ гард“? ");
INSERT INTO tgk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Пас, Ман ба шумо исбот мекунам, ки Фарзанди Инсон дар рӯи замин қудрати бахшидани гуноҳҳоро дорад, — сипас ба шал нигариста гуфт, — Бархез, ҷойгаҳатро бардошта ба хонаат рав!» ");
INSERT INTO tgk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Он мард аз ҷояш хеста ба хонааш равона шуд. ");
INSERT INTO tgk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Мардум аз дидани ин ҳодиса ба тарсу ваҳм афтода Худоро, ки ба инсон чунин қудрат додааст, ситоиш карданд. ");
INSERT INTO tgk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Вақте ки Исо аз он ҷо ба роҳ даромад, мардеро бо номи Матто дид, ки дар корхонаи андозҷамъкунӣ менишаст. Исо ба вай гуфт: «Биё, пайрави Ман шав». Матто бархесту аз паси Ӯ равона шуд. ");
INSERT INTO tgk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Вақте ки Исо ва шогирдонаш ба сари дастархон нишастанд, бисёр андозгирон ва дигар одамоне, ки гунаҳкор ҳисоб мешуданд, низ ба он хона даромада ба онҳо ҳамроҳ шуданд. ");
INSERT INTO tgk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Баъзе аз фарисиён инро дида, ба шогирдони Исо гуфтанд: «Чаро устоди шумо бо андозгирону гунаҳкорон аз як дастархон хӯрок мехӯрад?» ");
INSERT INTO tgk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Исо ин суханонро шунида, ҷавоб дод: «Ба табиб на одамони солим, балки беморон мӯҳтоҷанд. ");
INSERT INTO tgk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Рафта фаҳмед, ки чунин гуфтаҳои навиштаҷот чӣ маъно доранд: „Ман мехоҳам, ки одамон раҳму шафқат нишон диҳанд, на қурбониҳо оваранд“. Хуллас, Ман ҳам барои он омадаам, ки на накӯкорон, балки гунаҳкоронро даъват намоям». ");
INSERT INTO tgk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Сипас, баъзе аз шогирдони Яҳёи Таъмиддиҳанда ба Исо наздик шуда гуфтанд: «Чаро мо ва фарисиён одатан рӯза мегирему шогирдони Шумо не?» ");
INSERT INTO tgk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Исо ба онҳо ҷавоб дод: «Оё дӯстони домод дар ҷашни арӯсӣ, модоме ки домод бо онҳост, ғамгин мешаванд? Албатта не. Вале вақте мерасад, ки домод аз байнашон гирифта мешавад ва он гоҳ онҳо низ рӯза мегиранд. ");
INSERT INTO tgk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Охир ҳеҷ кас ба либоси кӯҳна аз матои нав ямоқ намекунад, чунки ямоқ дарида, ҷои он боз ҳам аёнтар мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Инчунин шароби навтайёршударо ба машки чармини кӯҳна намерезанд, чунки ҳангоми ба ҷӯш омадани шароб машк медараду шароб мерезад ва машк низ аз кор мебарояд. Баръакс, шароби навтайёршударо ба машки нав мерезанд, он гоҳ на шароб барбод мераваду на машк». ");
INSERT INTO tgk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ҳанӯз Исо суханонашро давом медод, ки марде аз ҷумлаи сардорон ба наздаш омад ва ба Ӯ таъзим карда гуфт: «Ҳозиракак духтарам мурд, аммо агар биёеду ба вай даст гузоред, вай зинда мешавад». ");
INSERT INTO tgk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Исо аз ҷояш хеста, бо шогирдонаш ҳамроҳи ӯ рафт. ");
INSERT INTO tgk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Як зане, ки дувоздаҳ сол боз касалии хунравӣ дошт, аз дилаш гузаронда буд, ки ақаллан ба ҷомаи Исо даст расонад, шифо меёбад. Бо ҳамин ният ӯ аз қафо ба Исои роҳ рафтаистода наздик шуду ба домани ҷомааш даст расонд. ");
INSERT INTO tgk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Исо ба қафояш рӯй гардонду занро дида, гуфт: «Эй зан, натарс! Туро имонат шифо дод». Худи ҳамон замон зан шифо ёфт. ");
INSERT INTO tgk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Баъд Исо ба хонаи он сардор даромада, найнавозони барои азо омада ва мардуми гирёнро дида, ");
INSERT INTO tgk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","гуфт: «Ҳамаатон аз ин ҷо равед! Духтар намурдааст, фақат хобидааст». Онҳо бошанд, Исоро масхара карданд. ");
INSERT INTO tgk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Аммо баъд аз он ки мардум берун баромаданд, Исо ба хонае, ки духтарак он ҷо буд, даромада, дасти ӯро гирифт ва духтарак бархест. ");
INSERT INTO tgk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ин хабар дар тамоми он сарзамин паҳн гашт. ");
INSERT INTO tgk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Исо он ҷойро монда, ба роҳ даромада буд, ки ду марди нобино аз дунболи Ӯ равон шуда фарёд мезаданд: «Эй Насли Довуд! Ба мо раҳм кунед!» ");
INSERT INTO tgk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Вақте ки Исо ба хона даромад, он ду нобино ҳам ба наздаш омаданд. Исо аз онҳо пурсид: «Боварӣ доред, ки Ман шуморо шифо дода метавонам?» «Бале, Хоҷа!» — ҷавоб доданд онҳо. ");
INSERT INTO tgk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Он гоҳ Исо ба чашмонашон даст расонда гуфт: «Аз рӯи имонатон ҳамин тавр шавад», ");
INSERT INTO tgk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ва чашмони онҳо бино гаштанд. Исо онҳоро қатъӣ огоҳ кард, ки дар бораи ин ҳодиса зинҳор ба касе чизе нагӯянд. ");
INSERT INTO tgk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Онҳо аз он ҷо баромада рафтанду, баръакс, дар тамоми он сарзамин дар бораи Ӯ овоза паҳн карданд. ");
INSERT INTO tgk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ҳанӯз он ду мард дур нарафта, якчанд кас ба пеши Исо мардеро оварданд, ки аз сабаби дев доштанаш, гунг буд. ");
INSERT INTO tgk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Лекин, вақте ки Исо аз он мард девро берун кард, мард ба гап даромад ва мардум бо изҳори ҳайрат хитоб мекарданд: «Ҳаргиз чунин ҳодисаро дар Исроил надида будем!» ");
INSERT INTO tgk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Аммо фарисиён мегуфтанд, ки Исо девҳоро бо қудрати худи сардори девҳо берун мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Исо бошад, ба ҳамаи шаҳру деҳот рафта, дар ибодатхонаҳо халқро таълим медод, хабари хушро дар бораи подшоҳии Худо эълон мекард ва ҳар дарду касалии одамонро шифо мебахшид. ");
INSERT INTO tgk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Вақте ки Исо ба мардум нигоҳ мекард, ба ҳоли онҳо раҳмаш меомад, чунки онҳо монанди гӯсфандони бе чӯпон, сарсону саргардон ва ночору нотавон буданд. ");
INSERT INTO tgk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Пас Исо ба шогирдонаш гуфт: «Ҳосили дарав фаровон аст, вале коргарон намерасанд. ");
INSERT INTO tgk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Аз ин рӯ, аз соҳиби ҳосил илтимос кунед, ки барои ғундоштани ҳосилаш коргаронро фиристад». ");
INSERT INTO tgk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Исо ба наздаш дувоздаҳ шогирдашро даъват карда, ба онҳо қудрат дод, ки рӯҳҳои нопокро берун кунанд ва ҳар дарду касалии одамонро шифо диҳанд. ");
INSERT INTO tgk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ана номҳои он дувоздаҳ вакилаш: аввалин Шимъӯн (ӯро боз Петрус меномиданд), бародари Шимъӯн Андриёс, баъд бародарон Ёқуб ва Юҳанно, ки писарони Забдой буданд, ");
INSERT INTO tgk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Филиппус ва Барталмо, Тумо ва Матто (он ки андоз ҷамъ мекард), Ёқуби писари Ҳалфӣ ва Таддо, ");
INSERT INTO tgk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Шимъӯни Ватандӯст ва Яҳудои Исқарют, ки баъдтар ба Исо хиёнат мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Исо ба ин дувоздаҳ нафар вазифа дода, ба иҷро намудани он фиристод. Ӯ ин тавр гуфт: «Ба назди халқҳои ғайрияҳудӣ наравед ва ба шаҳрҳои сомариён надароед, ");
INSERT INTO tgk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","балки назди халқи Исроил, ки монанди гӯсфандони гумроҳшуда ҳастанд, рафта ");
INSERT INTO tgk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","эълон кунед, ки подшоҳии Худо наздик аст. ");
INSERT INTO tgk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Беморонро шифо диҳед, мурдагонро зинда кунед, махавиёнро пок созед ва девҳоро берун кунед. Ин қудрат ба шумо бепул дода шудааст, пас шумо низ инро бепул кунед. ");
INSERT INTO tgk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Вақте ки ба сафар мебароед, бо худ дар камарбандатон на тангаҳои тиллову нуқра ва на тангаҳои мисин гиред, ");
INSERT INTO tgk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","на борхалтаву на асо ва на либоси иловагиву на пойафзол гиред, зеро меҳнаткаш сазовори таъминот аст. ");
INSERT INTO tgk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ҳангоме ки ба ягон шаҳр ё қишлоқ медароед, одами шоистаро суроғ кунед ва то рӯзи аз он ҷо рафтанатон дар хонаи ӯ бимонед. ");
INSERT INTO tgk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Баробари ба он хона даромадан салом диҳед. ");
INSERT INTO tgk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Агар он хонадон шуморо нағз қабул кунад, барояшон баракат талаб кунед, дар акси ҳол, бигузор баракататон ба худатон баргардад. ");
INSERT INTO tgk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Вале агар ҳеҷ кас шуморо қабул накунад ё ба суханонатон гӯш надиҳад, он хонадон ё шаҳрро тарк карда истода, ҳамчун нишонаи огоҳӣ чангу хокашро аз поятон биафшонед. ");
INSERT INTO tgk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ба ростӣ ба шумо мегӯям, дар рӯзи ҷазо аҳволи шаҳрвандони бадкирдори Садӯм ва Амӯро аз ҳоли он шаҳр сабуктар хоҳад буд. ");
INSERT INTO tgk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Инак, Ман шуморо ба назди одамон, гӯё гӯсфандонро ба байни гургҳо мефиристам. Мисли мор ҳушёру мисли кабӯтар безиён бошед. ");
INSERT INTO tgk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Аз одамон эҳтиёт шавед, чунки онҳо шуморо дастгир карда, назди шӯрои калонҳо мебаранд ва дар ибодатхонаҳо қамчинкорӣ мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ба хотири Маро пайравӣ карданатон шуморо дар назди ҳокимону подшоҳон ба ҷавобгарӣ мекашанд, то ки дар пеши онҳо ва ғайрияҳудиён дар бораи Ман шаҳодат диҳед. ");
INSERT INTO tgk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ҳангоме ки шуморо назди шӯрои олӣ мебаранд, ғам нахӯред, ки ба онҳо чӣ бояд гӯед ё чӣ тавр бояд сухан ронед, чунки дар он вақт суханоне, ки бояд гӯед, ба дилатон андохта мешаванд. ");
INSERT INTO tgk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Он гоҳ на ин ки шумо, балки Рӯҳи Падари осмониатон ба воситаи шумо сухан меронад. ");
INSERT INTO tgk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Дар он айём бародар бародари худро ба қатл мерасонад ва инчунин падар фарзанди худро. Фарзандон ба падару модари худ муқобил мебароянд ва онҳоро ба дасти марг месупоранд. ");
INSERT INTO tgk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ба сабаби Маро пайравӣ карданатон ҳама шуморо бад мебинанд. Вале агар шумо то ба охир расидани азобу уқубатҳо ба Ман вафодор монед, наҷот хоҳед ёфт. ");
INSERT INTO tgk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Вақте ки шуморо азоб доданӣ шуда дар як шаҳр дунболагирӣ кунанд, ба шаҳри дигар гурезед. Ба ростӣ ба шумо мегӯям, ҳанӯз шумо ба ҳамаи шаҳрҳои Исроил нарафта Фарзанди Инсон меояд. ");
INSERT INTO tgk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Шогирд аз устодаш баландтар нест, инчунин хизматгор аз хоҷааш. ");
INSERT INTO tgk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Барои шогирд басанда аст, ки монанди устодаш шавад ва барои хизматгор кофист, ки монанди хоҷааш шавад. Агар сардори хонадонро Баал-Забул, сардори девҳо номида бошанд, пас аъзоёни хонадонро чӣ қадар бадтар меноманд. ");
INSERT INTO tgk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Аз ин рӯ, аз одамон натарсед. Зеро ҳеҷ чизи пӯшидае нест, ки ошкор нашавад ва ҳеҷ чизи пинҳоне нест, ки маълум нагардад. ");
INSERT INTO tgk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Он чи Ман ба шумо махфӣ мегӯям, кушоду равшан гӯед ва он чи дар пичиррос мешунавед, аз болои боми хонаҳо эълон намоед. ");
INSERT INTO tgk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Аз одамон натарсед, ки онҳо ҷисмро мекушанду ҷонро кушта наметавонанд. Балки аз шахсе тарсед, ки ҳам ҷон ва ҳам ҷисмро дар дӯзах нобуд карда метавонад. ");
INSERT INTO tgk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Арзиши ду гунҷишк як танга аст, аммо ҳатто яктои он ба замин намеафтад, ки Падаратон аз он хабардор набошад. ");
INSERT INTO tgk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Аз они шумо бошад, мӯйҳои саратон ҳам ба ҳисоб гирифта шудаанд. ");
INSERT INTO tgk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Бинобар ин натарсед, шумо аз бисёр гунҷишкҳо ҳам қиматтар ҳастед. ");
INSERT INTO tgk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Пас, ҳар кӣ дар пеши мардум мегӯяд, ки пайрави Ман аст, Ман низ дар назди Падари осмониам пайрави Ман буданашро тасдиқ мекунам. ");
INSERT INTO tgk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Лекин ҳар кӣ дар пеши мардум Маро рад мекунад, Ман низ ӯро дар назди Падари осмониам рад мекунам. ");
INSERT INTO tgk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Фикр накунед, ки Ман барои ба замин овардани сулҳ омадаам. Ман барои сулҳ не, балки барои овардани шамшери зиддият омадаам. ");
INSERT INTO tgk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ман омадаам, ки писарро ба падар, духтарро ба модар, келинро ба хушдоманаш зид гузорам. ");
INSERT INTO tgk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Худи аъзои хонадони одам душманони ӯ хоҳанд буд. ");
INSERT INTO tgk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Касе ки падар ё модари худро аз Ман бештар дӯст медорад, лоиқи шогирди Ман шудан нест. Инчунин, касе ки писар ё духтари худро аз Ман бештар дӯст медорад, лоиқи шогирди Ман шудан нест. ");
INSERT INTO tgk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Касе ки Маро пайравӣ карданӣ шуда бо худ салиби азобу маргашро нагирад, лоиқи шогирди Ман шудан нест. ");
INSERT INTO tgk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Касе ки ҳаёташро нигоҳ доштан мехоҳад, онро аз даст медиҳад, вале касе ки ба хотири Ман ҳаёташро фидо мекунад, онро нигоҳ медорад. ");
INSERT INTO tgk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Касе ки шуморо қабул мекунад, дар асл Маро қабул мекунад ва касе ки Маро қабул мекунад, дар асл шахсеро, ки Маро фиристодааст, қабул мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Касе ки пайғамбарро ба хотири пайғамбар буданаш қабул мекунад, мукофоти пайғамбаронаро хоҳад гирифт. Касе ки одами накӯкорро ба хотири накӯкор буданаш қабул мекунад, мукофоти накӯкоронро хоҳад гирифт. ");
INSERT INTO tgk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ҳамчунин, касе ки ба яке аз пайравони хурдтарини Ман ба хотири шогирд буданаш ақаллан як пиёла оби хунук диҳад, ба ростӣ ба шумо мегӯям, бе мукофот нахоҳад монд». ");
INSERT INTO tgk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Баъд аз ба дувоздаҳ шогирд вазифа додан Исо аз он ҷо ба шаҳрҳои гирду атроф барои таълим додан ва эълон кардани хушхабар равона шуд. ");
INSERT INTO tgk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Вақте ки Яҳёи Таъмиддиҳанда дар ҳабсхона менишаст, хабари корнамоии Исои Масеҳ ба гӯшаш расид. Он гоҳ ӯ чанд нафар шогирдашро назди Исо фиристод. ");
INSERT INTO tgk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Онҳо омада аз Исо пурсиданд: «Оё Шумо ҳамон шахсе ҳастед, ки омаданашро пешгӯӣ карда буданд ё мо бояд мунтазири каси дигар бошем?» ");
INSERT INTO tgk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Исо ба онҳо дар ҷавоб гуфт: «Он чӣ мешунаведу мебинед, рафта ба Яҳё нақл бикунед. ");
INSERT INTO tgk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Яъне бигӯед, ки чашмони кӯрон бино мешаваду лангон роҳ мегарданд, махавиён пок мешаванду карҳо мешунаванд, мурдаҳо аз нав зинда мешаванд ва ба бенавоён хушхабар эълон карда мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Пас, хушбахт аст касе, ки дар ҳаққи Ман шакку шубҳа намекунад». ");
INSERT INTO tgk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ҳангоме ки шогирдони Яҳё ба роҳ даромаданд, Исо ба мардум дар бораи Яҳё суханашро оғоз кард: «Назди Яҳё ба биёбон барои дидани чӣ рафта будед? Барои дидани қамише, ки аз вазидани бод меҷунбад? ");
INSERT INTO tgk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Бигӯед, чаро рафта будед? Магар барои дидани одаме, ки либоси бошукӯҳ мепӯшад? Охир, онҳое, ки либоси бошукӯҳ мепӯшанд, дар қасрҳо зиндагӣ мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Хуллас, барои чӣ рафта будед? Барои дидани пайғамбар? Дуруст, аммо ба шумо мегӯям, ки шумо каси бузургтар аз пайғамбарро дидаед. ");
INSERT INTO tgk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Яҳё ҳамон як одам, ки Худо дар борааш дар навиштаҷот гуфта буд: „Ана, Ман пешопеши Ту як одамамро мефиристам, то ба омаданат роҳ тайёр кунад“. ");
INSERT INTO tgk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ба ростӣ ба шумо мегӯям, дар байни ҳамаи онҳое, ки аз модар ба дунё омадаанд, бузургтар аз Яҳёи Таъмиддиҳанда касе пайдо нашудааст. Аммо шахси хурдтарин дар подшоҳии Худо бузургтар аз Яҳё аст. ");
INSERT INTO tgk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Аз рӯзе, ки Яҳё ба эълон кардани пайғоми худ шурӯъ намуд, то ба имрӯз подшоҳии Худо аз зӯроварӣ азоб кашид ва одамони боқудрат онро зӯран ба даст оварданӣ ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Дар навиштаҷоти пайғамбарон ва шариати Мӯсо то замони Яҳё пешгӯиҳо омадаанд; ");
INSERT INTO tgk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","агар шумо ба гуфтаҳои онҳо бовар кардан хоҳед, Яҳё ҳамон Илёс пайғамбар аст, ки омаданашро пешгӯӣ карда буданд. ");
INSERT INTO tgk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ҳар кӣ Маро мешунавад, бигзор гӯш кунад! ");
INSERT INTO tgk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Хӯш, ин наслро бо кӣ муқоиса намоям? Онҳо монанди кӯдаконе ҳастанд, ки дар кӯча бозӣ мекунанду як гурӯҳи онҳо ба гурӯҳи дигар мегӯяд: ");
INSERT INTO tgk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","„Мо бароятон карнай навохтем, аммо шумо рақс накардед! Суруди мотам хондем, нагиристед“. ");
INSERT INTO tgk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Инак, Яҳё омада, рӯза медошт ва май наменӯшид, аммо ҳама мегуфтанд, ки ӯ дев дорад. ");
INSERT INTO tgk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Баъд Фарзанди Инсон омаду ҳам мехӯрад ва ҳам менӯшад, аммо ҳама мегӯянд: „Ана одами пурхӯру майзада, ҷӯраи андозгирони беинсофу рафиқи одамони радди маърака!“ Лекин ҳақ будани ҳикмати Худо аз натиҷаҳояш маълум мегардад». ");
INSERT INTO tgk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Аҳолии шаҳрҳое, ки дар он Исо мӯъҷизоти зиёд нишон дода буд, тавба накарданд ва аз гуноҳҳояшон даст накашиданд. Бинобар ин Исо онҳоро таъна зада гуфт: ");
INSERT INTO tgk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Эй аҳли Кӯрозину аҳли Байт-Сайдо, вой бар ҳоли шумо! Зеро агар он мӯъҷизоте, ки Ман дар байни шумо нишон додам, дар шаҳрҳои худобехабари Сур ва Сидун рӯй медоданд, одамони он кайҳо тавба карда, бар тан либоси дағал пӯшида мӯйканон нишон медоданд, ки онҳо аз гуноҳҳояшон даст кашидаанд. ");
INSERT INTO tgk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Лекин ҳаминро бидонед, ки дар рӯзи ҷазо аҳволи шаҳрвандони Сур ва Сидун аз ҳоли шумо сабуктар хоҳад буд! ");
INSERT INTO tgk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Инчунин шумо, эй аҳли Кафарнаҳум! Гумон мекунед, ки саратон то ба осмон мерасад, аммо шумо ба дӯзах партофта мешавед. Зеро, агар он мӯъҷизоте, ки Ман дар байни шумо нишон додам, дар шаҳри Садӯм рӯй медоданд, ин шаҳр то ҳол аз рӯи замин нест намешуд. ");
INSERT INTO tgk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Лекин ҳаминро бидонед, ки дар рӯзи ҷазо аҳволи шаҳрвандони Садӯм аз ҳоли шумо сабуктар хоҳад буд!» ");
INSERT INTO tgk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Сипас Исо гуфт: «Шукри Туро мекунам, эй Падар — Худованди замину осмон, ки он чи аз одамони маълумотноку хирадманд пинҳон кардӣ, ба одамони оддӣ ошкор намудаӣ. ");
INSERT INTO tgk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Оре, Падар, чунин буд хости Ту. ");
INSERT INTO tgk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Падарам ҳама чизро ба Ман додааст. Ба ғайр аз Падар дигар ҳеҷ кас Писарро нағз намешиносад. Инчунин, Падарро ҳеҷ кас нағз намешиносад, ғайр аз Писар ва онҳое, ки Писар интихоб кардааст, то барояшон Падарро зоҳир кунад. ");
INSERT INTO tgk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ҳамаи шумое, ки аз бори вазнин монда шудаед, ба назди Ман биёед ва Ман ба шумо оромӣ мебахшам. ");
INSERT INTO tgk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Чунончи барзагов барои андохтани юғ гардан мефурорад, шумо низ ба юғи Ман сар фуроред ва аз Ман таълим бигиред, чунки Ман нармдилу хоксор ҳастам, он гоҳ ҷони шумо оромӣ меёбад. ");
INSERT INTO tgk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Зеро таҳти юғи Ман будан осон аст ва боре, ки Ман медиҳам, сабук аст». ");
INSERT INTO tgk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Дере нагузашта, Исо аз назди киштзори гандум мегузашт. Ин рӯзи истироҳат буд ва шогирдонаш гурусна монда, хӯшаҳои гандумро меканданду донаҳояшро мехӯрданд. ");
INSERT INTO tgk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Инро дида баъзе аз фарисиён назди Исо омада гуфтанд: «Инро бинед-а, шогирдони Шумо кореро карда истодаанд, ки дар рӯзи истироҳат кардани он раво нест». ");
INSERT INTO tgk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Исо дар ҷавоб гуфт: «Магар шумо дар навиштаҷот нахондаед, ки шоҳ Довуд, вақте ки бо ҳамроҳонаш гурусна монд, чӣ кор карда буд? ");
INSERT INTO tgk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ӯ ба хонае, ки ҳузури Худоро дошт, даромада нони ба Худо тақдимшударо гирифту хӯрд. Ҳол он ки аз рӯи шариат ӯ ва ҳамроҳонаш ба ин ҳақ надоштанд, чунки фақат ба рӯҳониён хӯрдани он нон мумкин буд. ");
INSERT INTO tgk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ё наход дар шариати Мӯсо нахонда бошед, ки рӯҳониён ҳангоми дар Хонаи Худо иҷро кардани вазифаҳои худ, қоидаҳои рӯзи истироҳатро вайрон мекунанд, вале айбдор ҳисоб намешаванд? ");
INSERT INTO tgk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Аммо ҳаминро дониста бошед, ки чизи бузургтар аз Хонаи Худо дар ин ҷост. ");
INSERT INTO tgk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Дар навиштаҷот Худо гуфтааст: „Ман мехоҳам, ки одамон раҳму шафқат нишон диҳанд, на қурбониҳо оваранд“. Агар шумо маънои ин гуфтаҳоро мефаҳмидед, одамони беайбро айбдор намекардед. ");
INSERT INTO tgk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Охир Фарзанди Инсон соҳиби рӯзи истироҳат аст». ");
INSERT INTO tgk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Исо роҳашро давом дода ба ибодатхона рафт. ");
INSERT INTO tgk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Дар байни одамони он ҷо марде ҳузур дошт, ки дасташ хушк шуда буд. Баъзе аз ҳозирон, ки мехостанд ба сари Исо айб монанд, аз Исо пурсиданд: «Оё аз рӯи шариат дар рӯзи истироҳат одамро шифо додан мумкин аст?» ");
INSERT INTO tgk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Исо дар ҷавоб ба онҳо гуфт: «Фарз кардем, ки шумо як гӯсфанде дореду он ҳам бошад дар рӯзи истироҳат ба чоҳ меафтад. Наход шумо рафта, онро аз чоҳ кашида нагиред? ");
INSERT INTO tgk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Қадри инсон бошад аз гӯсфанд чӣ қадар баландтар аст. Пас, дар рӯзи истироҳат некӣ кардан равост». ");
INSERT INTO tgk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Баъд ба марди дасташ хушкшуда гуфт: «Дастатро дароз кун». Вай дасташро дароз кард, ки он мисли дасти дигараш сиппа-сиҳат шуд. ");
INSERT INTO tgk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Фарисиён бошанд, баромада рафтанд ва нақшаи куштани Исоро кашиданд. ");
INSERT INTO tgk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Исо аз нақшаи фарисиён огоҳ шуда, аз он маҳалла баромада рафт. Одамони зиёд низ аз паяш рафтанд ва Ӯ ҳамаи беморонро шифо дода, ");
INSERT INTO tgk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ба онҳо фармон дод, ки дар бораи Ӯ овоза паҳн накунанд. ");
INSERT INTO tgk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Инро Исо барои ба амал омадани суханони Худо кард, ки ба воситаи Ишаъё пайғамбар гуфта буд: ");
INSERT INTO tgk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ана он хизматгорам, ки Ман интихоб кардам. Ӯ роҳати ҷонам аст ва Ман Ӯро азиз медонам. Ман Рӯҳамро бар Ӯ мефиристам ва Ӯ ба ҳамаи халқҳо адолатамро эълон мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ӯ бо ҳеҷ кас муноқиша намекунад ё доду вой намебардорад, ё ҳеҷ кас дар кӯчаҳо бо овози баланд сухан гуфтани Ӯро намешунавад. ");
INSERT INTO tgk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ӯ касеро, ки мисли қамиши хамшуда аст, намешиканаду касеро, ки мисли пилтаи нимсӯхтаи чароғ аст, хомӯш намекунад, то даме ки пойдор намудани адолат ба Ӯ муяссар мегардад. ");
INSERT INTO tgk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ва ҳамаи халқҳои рӯи замин умеди наҷотро дар Ӯ мебинанд». ");
INSERT INTO tgk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Сипас ба назди Исо марди девонаеро оварданд, ки аз сабаби дев доштанаш кӯр ва гунг буд. Исо вайро шифо бахшид ва ӯ ҳам гап зада ва ҳам дида метавонистагӣ шуд. ");
INSERT INTO tgk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Тамоми мардум аз ин ҳодиса ба ҳайрат афтода мегуфтанд: «Шояд Ӯ ҳамон Насли Довуд бошад, ки мо интизораш ҳастем?» ");
INSERT INTO tgk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Лекин фарисиён инро шунида чунин мегуфтанд: «Ӯ бо қудрати Баал-Забул, сардори девҳо девҳоро берун мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Исо, ки аз фикрҳои фарисиён бохабар буд, ба онҳо гуфт: «Ҳар давлате, ки дар дохили худ аз ҳам ҷудо шуда ҷанг мекунад, ба зудӣ барҳам мехӯрад ва ҳар шаҳр ё хонаводае, ки дар дохили худ аз ҳам ҷудо шуда ҷанг мекунад, вайрон хоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Инак, агар шайтон худашро берун кунад, магар ин нишонаи он нест, ки ӯ дар дохили худ ба ду қисм ҷудо шудааст. Пас, наход ҳукмронии ӯ давом меёфта бошад? ");
INSERT INTO tgk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Аз гуфти шумо Ман девҳоро бо қудрати Баал-Забул берун мекунам, пас пайравони худатон-чӣ? Онҳо бо кадом қудрат берун мекунанд? Ана, амали онҳо исбот мекунад, ки шумо нодуруст фикр мекунед. ");
INSERT INTO tgk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Аммо, агар Ман бо қудрати Рӯҳи Худо девҳоро берун мекарда бошам, аз ин бармеояд, ки подшоҳии Худо аллакай ба ҳаёти шумо омадааст. ");
INSERT INTO tgk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Инчунин ҳеҷ кас наметавонад ба хонаи шахси пурзӯр зада даромада, молу мулкашро гирифта барад, то аввал дасту пои шахси пурзӯрро набандад. Ана баъд хонаашро ғорат карда метавонад. ");
INSERT INTO tgk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Касе ки тарафдори Ман нест, дар асл муқобили Ман аст ва касе ки дар ҷамъ овардани одамон ба Ман ёрӣ намедиҳад, дар асл онҳоро пароканда мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Аз ин рӯ, ба шумо мегӯям, ҳар гуноҳ ва сухани кофиронаи инсон барояш бахшида мешавад, вале касеро, ки бар зидди Рӯҳи Муқаддас сухани кофиронае мегӯяд, Худо ҳаргиз намебахшад. ");
INSERT INTO tgk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ҳар кас ки бар зидди Фарзанди Инсон сухан мегӯяд, бахшида мешавад, вале касе ки бар зидди Рӯҳи Муқаддас сухане мегӯяд, Худо ӯро дар ду дунё намебахшад. ");
INSERT INTO tgk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Худатон мулоҳиза кунед, дарахти солим меваи нағз медиҳад, дарахти касал бошад, меваи бад медиҳад. Пас, чӣ хел будани дарахт аз мевааш маълум мегардад. ");
INSERT INTO tgk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Эй морзодагони маккор! Чӣ хел шумо суханони нек гуфта метавонед, дар сурате ки худатон бад ҳастед. Охир, он чи дилатонро пур мекунад, баъд лабрез шуда аз забонатон берун мебарояд. ");
INSERT INTO tgk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Шахси нек аз хазинаи некаш чизҳои нек ва шахси бад аз хазинаи бадаш чизҳои бад берун меорад. ");
INSERT INTO tgk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ҳаминро дониста бошед, ки дар рӯзи ҷазо шумо барои ҳар сухани ноҳақе, ки гуфтаед, ҷавоб хоҳед дод. ");
INSERT INTO tgk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Чунки аз рӯи суханони худатон шумо ё беайб ва ё айбдор ҳисоб мешавед». ");
INSERT INTO tgk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Он гоҳ баъзе аз фарисиён ва шариатдонон ба Исо гуфтанд: «Устод, мехостем, ки ягон нишонае ба мо диҳед». ");
INSERT INTO tgk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Лекин Исо ҷавоб дод: «Эй насли одамони баду ба Худо бевафо! Шумо нишона талаб мекунед?! Бароятон ҳеҷ нишонае ғайр аз он чи бо Юнус пайғамбар рӯй дода буд, дода намешавад. ");
INSERT INTO tgk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Чи тавре ки Юнус се шабу се рӯзро дар шиками наҳанг гузаронда буд, ҳамон тавр Фарзанди Инсон се шабу се рӯзро зери хоки замин мегузаронад. ");
INSERT INTO tgk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Дар рӯзи ҷазо бошад, шаҳрвандони Нинве бархеста, насли шуморо айбдор мекунанд, зеро онҳо бо шунидани пайғоми Юнус тавба карданду аз гуноҳҳояшон даст кашиданд. Ҳол он ки чизи бузургтар аз Юнус дар ин ҷост! ");
INSERT INTO tgk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Дар рӯзи ҷазо маликаи сарзамини Сабо бархеста насли шуморо айбдор мекунад, зеро ӯ аз як гӯшаи дунё барои шунидани ҳикмати шоҳ Сулаймон омада буд. Ҳол он ки чизи бузургтар аз Сулаймон дар ин ҷост! ");
INSERT INTO tgk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Фарз кардем, рӯҳи нопок аз шахсе берун карда мешавад. Баъд ин рӯҳ бо нияти пайдо кардани манзили зист ҷойҳои беобро давр мезанаду онро намеёбад. ");
INSERT INTO tgk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ниҳоят худ ба худ мегӯяд: „Э, ба хонаи пештараам бармегардам“, — ва баргашта мебинад, ки ин хона холӣ ва ба тартиб овардаву рӯбучиншуда аст. ");
INSERT INTO tgk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Пас рӯҳи нопок рафта, ҳафт рӯҳи аз худаш ҳам бадтарро ҳамроҳаш гирифта меорад ва ҳамаи онҳо ба он хона даромада зиндагӣ мекунанд. Дар натиҷа аҳволи он шахс аз ҳолати аввалааш бадтар хоҳад буд. Айнан ҳамин ҳодиса бо одамони бади ин замон рӯй хоҳад дод». ");
INSERT INTO tgk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Исо ҳанӯз ба мардум сухан гуфтанро давом медод, ки модару бародаронаш омаданд. Онҳо берун аз хона истода, хоҳиш карданд, ки бо Исо гап зананд. ");
INSERT INTO tgk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Касе аз байни халқ ба Исо гуфт: «Устод, модар ва бародаронатон дар берун истодаанд ва мехоҳанд, ки бо Шумо гапзанон кунанд». ");
INSERT INTO tgk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Исо дар ҷавоб гуфт: «Модари Ман кист ва бародарони Ман кистанд?» ");
INSERT INTO tgk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Баъд бо дасташ сӯи шогирдонаш ишора карда, суханашро давом дод: «Ана инҳо модар ва бародарони Ман ҳастанд! ");
INSERT INTO tgk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Зеро ҳар касе, ки хости Падари осмониамро иҷро мекунад, бародар, хоҳар ва модари Ман аст». ");
INSERT INTO tgk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Худи ҳамон рӯз Исо аз хона баромаду барои таълим додани мардум сӯи кӯл рафт. ");
INSERT INTO tgk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Аммо дар гирдаш чунон одамони зиёд ҷамъ омаданд, ки Ӯ халқро дар соҳил монда, худаш ба қаиқе савор шуд. ");
INSERT INTO tgk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Исо ба онҳо бисёр чизҳоро бо масалҳо нақл карда мегуфт: «Рӯзе як деҳқон барои кишт кардан мебарояд. ");
INSERT INTO tgk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Вақте ки дона мепошад, як миқдори он ба пайраҳа меафтад ва паррандаҳо омада, онҳоро аз замин чида пок-покиза мехӯранд. ");
INSERT INTO tgk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Миқдори дигари он ба замини санглоху камхок меафтад. Аз сабаби чуқур набудани хоки замин онҳо зуд месабзанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Вале бо баромади офтоб майсаи навхез пажмурда шуда, аз сабаби решаи мустаҳкам надоштан хушк мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Миқдори дигараш ба замини хордор меафтад ва хорҳо қад кашида майсаи навсабзидаро пахш мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Лекин баъзе донаҳо ба замини хуби ҳосилхез афтода, баъзе сад, баъзе шаст ва баъзе сӣ баробар зиёдтар ҳосил медиҳанд». ");
INSERT INTO tgk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Боз гуфт: «Пас ҳар кӣ Маро мешунавад, бигзор гӯш кунад!» ");
INSERT INTO tgk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Баъдтар шогирдони Исо ба наздаш омада пурсиданд: «Чаро Шумо мардумро бо масалҳо таълим медиҳед?» ");
INSERT INTO tgk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ӯ ба онҳо ҷавоб дод: «Худо ба шумо имконияти фаҳмидани сирру асрори подшоҳии худро додааст, аммо аз онҳо ин чизҳо пинҳон ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Чунки ҳар кӣ чизе дорад, ба ӯ боз ва аз ҳад зиёд дода мешавад, аммо касе, ки надорад, ҳатто он андаке, ки дорад, аз ӯ кашида гирифта мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ана барои чӣ Ман ба онҳо бо масалҳо нақл мекунам: онҳо дида метавонанду намебинанд, шунида метавонанд, вале на мешунаванду на мефаҳманд. ");
INSERT INTO tgk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Ишаъё пайғамбар пешгӯӣ карда гуфта буд: „Ин одамон ҳарчанд гӯш кунанд ҳам, намефаҳманд; ҳарчанд нигоҳ кунанд ҳам, намебинанд, чунки ин одамон кундфаҳм шудаанд, гӯшҳояшон мадори шунидан надоранд ва чашмонашонро онҳо пӯшидаанд. Агар ин тавр намекарданд, чашмонашон дида, гӯшҳояшон шунида ва ақлашон дарк карда метавонист. Он гоҳ онҳо сӯи Ман — Худо рӯй меоварданд, то ки Ман онҳоро шифо диҳам“. Ин пешгӯӣ ҳақиқатан дар ҳаёти онҳо амалӣ мегардад. ");
INSERT INTO tgk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Шумо бошед, хушбахт ҳастед, чунки чашмонатон дида ва гӯшҳоятон шунида метавонанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ба ростӣ ба шумо мегӯям, ки бисёр пайғамбарон ва накӯкорон дар орзуи дидан ва шунидани он чи, ки шумо мебинед ва мешунавед, буданд. Вале онҳо на диданду на шуниданд. ");
INSERT INTO tgk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Хуб, маънои масалро дар бораи деҳқон гӯш кунед. ");
INSERT INTO tgk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ба пайраҳа афтодани донаҳо монанди он аст, ки баъзе касон каломро дар бораи подшоҳии Худо мешунаванду онро намефаҳманд. Шахси Бад омада каломи ба дили онҳо кошташударо кашида мегирад. ");
INSERT INTO tgk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ба замини санглох афтодани донаҳо монанди он аст, ки баъзе касон каломро мешунаванду дарҳол бо хушҳолӣ онро қабул мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Вале азбаски реша надоранд, муддати кӯтоҳ бардошт мекунанд. Баъд вақте ки аз барои калом ба душворӣ ва азоб дучор мешаванд, зуд имони худро аз даст медиҳанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ба замини хорзор афтодани донаҳо монанди он аст, ки баъзе касон каломро мешунаванд, аммо ғаму ташвиши зиндагӣ ва орзуи бойигарӣ каломро пахш менамояд ва дар натиҷа он ҳеҷ ҳосиле намеорад. ");
INSERT INTO tgk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Вале ба замини ҳосилхез афтодани донаҳо монанди он аст, ки баъзе касон каломро мешунаванду онро мефаҳманд. Ана онҳо баъзан сад, баъзан шаст ва баъзан сӣ баробар бештар самара медиҳанд». ");
INSERT INTO tgk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ӯ боз дигар масалро нақл карда гуфт: «Подшоҳии Худоро чунин тасвир кардан мумкин: шахсе ба заминаш донаҳои киштбобро мекорад. ");
INSERT INTO tgk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Лекин, вақте ки ҳама хоб мераванд, душман меояду дар байни гандум тухми алафи бегонаро пошида, меравад. ");
INSERT INTO tgk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Сипас, баробари сабзидаву сарак баровардани гандум, алафи бегона низ намоён мегардад. ");
INSERT INTO tgk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Хизматгорон назди соҳиби киштзор омада мегӯянд: „Хоҷа, шумо дар киштзоратон донаҳои гандумро кошта будеду ин алафи бегона аз куҷо пайдо шуд?“ ");
INSERT INTO tgk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ӯ ба онҳо ҷавоб дода мегӯяд: „Ин кори душман аст“. Хизматгорон боз мепурсанд: „Мехоҳед, ки мо рафта онҳоро канда партоем?“ ");
INSERT INTO tgk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","„Не, — мегӯяд соҳиби киштзор, — чунки алафи бегонаро канданӣ шуда мабодо боз баъзе гандумро ҳам канда напартоед. ");
INSERT INTO tgk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Бигзор, то вақти ҳосилғундорӣ ҳам гандум ва ҳам алафи бегона истад. Баъд ба даравгарон фармон медиҳам, ки аввал алафи бегонаро канда, даста карда сӯзонанд, сонӣ гандумро даравида, ба анборам ҷамъ кунанд“». ");
INSERT INTO tgk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Исо ба онҳо боз масали дигареро нақл карда гуфт: «Подшоҳии Худоро чунин тасвир кардан мумкин: шахсе донаи хардалро гирифта, дар замини худ мекорад. ");
INSERT INTO tgk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ин дона аз ҳамаи донаҳои дунё майдатарин мебошад, вале вақте ки он месабзад, аз ҳамаи гиёҳҳо калонтар шуда, ба дарахт мубаддал мегардад ва паррандаҳо омада, дар шохаҳои он лона месозанд». ");
INSERT INTO tgk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Масали дигаре, ки Вай ба онҳо нақл кард, ин буд: «Подшоҳии Худоро боз чунин тасвир кардан мумкин: Зане каме хамиртуруш мегираду бо як тағора орд омехта, хамир мекунад ва баъд тамоми хамир мерасад». ");
INSERT INTO tgk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Исо ҳамаи ин чизҳоро фақат бо масалҳо ба мардум нақл кард ва бе масал сухане ҳам ба онҳо нагуфт. ");
INSERT INTO tgk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Пайғамбаре чунин гуфта буд: «Ман ба онҳо бо масалҳо сухан меронам; Ман ба онҳо чизҳои аз аввали офариниш пинҳонбударо нақл мекунам». Барои амалӣ гаштани ин суханон Исо бо масалҳо гап мезад. ");
INSERT INTO tgk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Вақте ки Исо мардумро монда, ба хона рафт, шогирдонаш ба наздаш омада хоҳиш карданд, ки Ӯ масали дар бораи алафи бегона нақлкардаашро ба онҳо маънидод кунад. ");
INSERT INTO tgk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Вай дар ҷавоб гуфт: «Шахсе, ки донаҳои киштбобро мекорад, Фарзанди Инсон аст; ");
INSERT INTO tgk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","киштзор ин ҷаҳон аст; донаҳои гандум одамони аз они подшоҳии Худо ҳастанд; алафи бегона бошад, одамони аз они Шахси Бад ҳастанд; ");
INSERT INTO tgk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ва душмане, ки тухми алафи бегонаро мекорад, иблис мебошад. Вақти ҳосилғундорӣ охирзамон аст, даравгарон бошанд, фариштаҳоянд. ");
INSERT INTO tgk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Чи тавре ки алафи бегонаро ҷамъ карда, дар оташ месӯзонанд, айнан ҳамин тавр дар охирзамон рӯй медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Яъне Фарзанди Инсон фариштаҳои худро мефиристад, то ки ҳамаи бадкорон ва ҳамаи васвасакоронро аз дохили подшоҳии Вай ҷудо карда гирифта ");
INSERT INTO tgk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ба оташи сӯзон партоянд. Дар он ҷо бошад, одамон аз дард дандон ба дандон зада гиря мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Аммо накӯкорон дар подшоҳии Падарашон мисли офтоб медурахшанд. Пас ҳар кӣ Маро мешунавад, бигзор гӯш кунад! ");
INSERT INTO tgk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Подшоҳии Худоро чунин тасвир кардан мумкин: рӯзе як мардикор дар саҳро ганҷинаи касе пинҳонкардаро меёбаду онро боз пинҳон мекунад. Аз шодӣ ӯ рафта тамоми дороияшро мефурӯшаду ҳамон саҳроро мехарад. ");
INSERT INTO tgk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Подшоҳии Худоро боз ин тавр тасвир кардан мумкин: савдогаре марворидҳои зебо мекобаду мекобад ");
INSERT INTO tgk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ва ҳангоме ки марвориди аҷаб зеборо меёбад, рафта, тамоми молу мулкашро фурӯхта, онро мехарад. ");
INSERT INTO tgk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ана масали дигар, ки бо он подшоҳии Худоро тасвир кардан мумкин: якчанд моҳигир тӯрҳои худро ба кӯл мепартоянду ба тӯрашон ҳар гуна моҳиҳо меафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Вақте ки тӯрҳо пур аз моҳӣ мешаванд, моҳигирон онҳоро ба соҳил мекашанду нишаста моҳиҳоро ба нағзу бад ҷудо мекунанд; нағзашро ба сабадҳо меандозанду бадашро мепартоянд. ");
INSERT INTO tgk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Дар охирзамон низ ҳамин тавр рӯй медиҳад: фариштаҳо баромада, одамони бадкирдорро аз байни накӯкорон ҷудо мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Сонӣ одамони бадкирдорро ба оташи сӯзон мепартоянд, ки дар он ҷо одамон аз дард дандон ба дандон зада гиря мекунанд». ");
INSERT INTO tgk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Исо аз шогирдонаш пурсид: «Шумо ин гуфтаҳоямро фаҳмидед?» «Фаҳмидем», — ҷавоб доданд онҳо. ");
INSERT INTO tgk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ӯ давом дода гуфт: «Пас, ҳар шариатдоне, ки дар бораи подшоҳии Худо таълим ёфтааст, монанди соҳиби хона аст, ки аз анбори худ чизҳои нав ва кӯҳнаро берун мебарорад». ");
INSERT INTO tgk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Исо нақл кардани масалҳоро тамом карду аз он ҷо баромада ");
INSERT INTO tgk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ба диёраш баргашт. Ӯ дар ибодатхонаи он ҷо таълим медоду онҳое, ки таълимоташро мешуниданд, ангушти ҳайрат газида ба якдигар мегуфтанд: «Аз куҷо Вай ин қадар ҳикмат дорад-а?» «Қобилияти мӯъҷизакории Ӯ аз куҷо бошад-а? ");
INSERT INTO tgk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Магар Ӯ ҳамон Исои писари дуредгар нест, ки модараш Марям ва бародаронаш Ёқубу Юсуфу Шимъӯну Яҳудо ҳастанд? ");
INSERT INTO tgk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Магар ҳамаи хоҳаронаш дар шаҳри мо зиндагӣ намекунанд? Пас, аз куҷо Ӯ ин ҳикмату ин қудратро дорад?» ");
INSERT INTO tgk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Инак, онҳо дар ҳаққи Исо шакку шубҳа карданд. Ӯ бошад, ба онҳо гуфт: «Пайғамбар дар диёри худ ва дар байни хонадони худ қадр надорад, вале дар ҳама ҷои дигар ӯро бо эҳтиром қабул мекунанд». ");
INSERT INTO tgk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ва аз сабаби он ки онҳо ба Исо боварӣ надоштанд, Ӯ дар он ҷо кам мӯъҷиза кард. ");
INSERT INTO tgk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Дар он айём овоза дар бораи Исо то ба гӯши Ҳиродус, ки ҳокими вилояти Ҷалил буд, рафта расид. ");
INSERT INTO tgk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ҳиродус ба мансабдоронаш гуфт, ки дар асл ин Яҳёи Таъмиддиҳанда аст, ки аз нав зинда шудааст, барои ҳамин ҳам Ӯ чунин қудрати мӯъҷизакорӣ дорад. ");
INSERT INTO tgk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Пеш аз марги Яҳёи Таъмиддиҳанда Ҳиродус Ҳиродия, зани бародараш Филиппусро ба занӣ гирифта буд. Гаштаю баргашта Яҳё ба ӯ мегуфт: «Аз рӯи шариати мо ба шумо гирифтани зани бародаратон раво нест». Бинобар ин Ҳиродус фармон дод, ки Яҳёро дастгир кунанду дасту пояшро баста, ба ҳабс андозанд. ");
INSERT INTO tgk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ҳиродус мехост Яҳёро ба қатл расонад, аммо аз халқ метарсид, зеро халқ Яҳёро пайғамбар меҳисобид. ");
INSERT INTO tgk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Бо вуҷуди ин, боре дар ҷашнгирии рӯзи таваллуди Ҳиродус духтари Ҳиродия дар пеши меҳмонон рақсу бозӣ карда, Ҳиродусро чунон мафтун кард, ки ");
INSERT INTO tgk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ӯ қасам ёд карда ба духтар ваъда дод: «Ҳар чӣ аз ман талаб кунӣ, бароят медиҳам!» ");
INSERT INTO tgk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Духтар аз рӯи маслиҳати модараш гуфт: «Бароям сари Яҳёи Таъмиддиҳандаро дар рӯи табақе оварда диҳед». ");
INSERT INTO tgk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ҳоким ғамгин гашт, вале ба хотири ваъдаи дар пеши меҳмонон додааш, фармон дод, ки гуфти духтарро иҷро кунанд. ");
INSERT INTO tgk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ҷаллоди фиристодааш рафта, дар ҳабсхона сари Яҳёро аз танаш ҷудо кард ");
INSERT INTO tgk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ва дар рӯи табақе ба духтар оварда дод. Духтар бошад, онро ба дасти модараш супорид. ");
INSERT INTO tgk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Баъд аз ин шогирдони Яҳё омада, ҷасади ӯро бурда гӯрониданд ва ҳодисаи рӯйдодаро рафта ба Исо нақл карданд. ");
INSERT INTO tgk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ин ҳодисаро шунида, Исо ба қаиқ савор шуду худаш танҳо ба ҷои хилвате рафт. Мардум аз ин огоҳ шуданду аз шаҳрҳои худ баромада пиёда аз пайи Ӯ рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Вақте ки Исо ба соҳил фаромад, мардуми зиёдеро дида, ба ҳоли онҳо раҳмаш омад ва беморони дар байнашон бударо шифо дод. ");
INSERT INTO tgk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Рӯз ба охир мерасид ва шогирдони Исо ба наздаш омада гуфтанд: «Устод! Ин як ҷои беодам аст, рӯз дер шуд. Мардумро ҷавоб намедиҳед, ки ба қишлоқҳои гирду атроф рафта, барояшон хӯрокворӣ харанд?» ");
INSERT INTO tgk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","«Ба ҳеҷ ҷо рафтанашон лозим нест, — ҷавоб дод Вай. — Шумо ба онҳо хӯрок диҳед!» ");
INSERT INTO tgk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Онҳо гуфтанд: «Охир мо дар ин ҷо фақат панҷ нону ду моҳӣ дорем». ");
INSERT INTO tgk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","«Онҳоро ба Ман оварда диҳед», — гуфт Исо. ");
INSERT INTO tgk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ӯ ба мардум гуфт, ки рӯи сабза нишинанд. Баъд он панҷ нону ду моҳиро ба дасташ гирифта, ба осмон нигаристу аз Худо баракат талабид ва нонҳоро пора карда, ба шогирдонаш дод, то ки ба мардум тақсим карда диҳанд. ");
INSERT INTO tgk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ҳама то сер шудан хӯрданду шогирдон боз дувоздаҳ сабади пур аз нонпораҳо ҷамъ карданд. ");
INSERT INTO tgk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Шумораи онҳое, ки нону моҳӣ хӯрда буданд, ғайр аз занону кӯдакон, тақрибан панҷ ҳазор нафар буд. ");
INSERT INTO tgk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Сипас Исо ба шогирдонаш фармуд, ки ба қаиқ савор шаванду пешопеши Ӯ ба дигар тарафи кӯл раҳсипор шаванд, то худаш ҳам баъд аз мардумро ҷавоб доданаш назди онҳо биравад. ");
INSERT INTO tgk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Вақте ки Вай мардумро ҷавоб дод, барои дар танҳоӣ дуо кардан ба теппае баромад. Баъд аз нишасти офтоб ҳам Ӯ яккаву танҳо дар он ҷо буд. ");
INSERT INTO tgk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Қаиқ бошад, аз соҳил хеле дур рафта буд ва аз сабаби боди сахте, ки мухолифи он мевазид, мавҷҳои кӯл қаиқро алвонҷ медоданд. ");
INSERT INTO tgk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ҳанӯз чашми рӯз накафида, Исо рӯ-рӯи об қадамзанон ба тарафи шогирдонаш равона шуд. ");
INSERT INTO tgk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Шогирдон Исои дар рӯи об роҳ рафтаистодаро дида, «Ин арвоҳ! Арвоҳ!» гӯён аз тарсу ваҳм дод заданд. ");
INSERT INTO tgk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Аммо Ӯ зуд ба онҳо гуфт: «Натарсед! Ин Манам. Ором шавед». ");
INSERT INTO tgk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Он гоҳ Петрус овоз бароварда гуфт: «Хоҷа, агар дар ҳақиқат ин Ту бошӣ, ба ман амр намо, ки рӯ-рӯи об назди Ту биёям». ");
INSERT INTO tgk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","«Биё», — амр дод Ӯ. Инак, Петрус аз қаиқ баромада дар рӯи об қадам занон ба Исо наздик мешуд. ");
INSERT INTO tgk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Сахт вазидани шамолро дида тарсид ва қариб ғарқ шуда буд ки, фарёд зад: «Хоҷа, маро наҷот деҳ!» ");
INSERT INTO tgk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Исо зуд дасташро дароз карда, Петрусро дошта гирифт ва гуфт: «Ин қадар имонат суст аст? Чаро шубҳа кардӣ?» ");
INSERT INTO tgk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Бо ин суханон онҳо ба қаиқ савор шуданд ва шамол аз вазидан бозмонд. ");
INSERT INTO tgk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Он гоҳ онҳое, ки дар қаиқ нишаста буданд, ба Исо саҷда карда хитоб намуданд, ки Ӯ дар ҳақиқат Писари Худо аст. ");
INSERT INTO tgk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Онҳо аз кӯл гузашта, ба сарзамини Ҷинесор омада расиданд. ");
INSERT INTO tgk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Мардуми он ҷо Исоро шинохтанд ва ба гирду атрофи он сарзамин одамонро фиристоданд, то ки беморонро назди Ӯ гирифта биёранд. ");
INSERT INTO tgk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Онҳо аз Исо илтимос мекарданд, ки ақаллан ба лаби доманаш даст расонанд ва ҳар касе ки даст мерасонд, шифо меёфт. ");
INSERT INTO tgk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Сипас, ба назди Исо аз Ерусалим чанд нафаре аз фарисиёну шариатдонон омада пурсиданд: ");
INSERT INTO tgk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Чаро шогирдони Шумо урфу одатҳои аҷдодони моро вайрон мекунанд? Онҳо бетаҳорат сари дастархон мешинанд!» ");
INSERT INTO tgk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ӯ ҷавоб дод: «Худи шумо-чӣ? Чаро барои иҷро кардани урфу одатҳои худ шуда, фармудаҳои Худоро вайрон мекунед? ");
INSERT INTO tgk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Худо ба мо фармудааст: „Падару модари худро эҳтиром кунед“ ва „ҳар кӣ дар ҳаққи падар ё модараш сухани қабеҳ гӯяд, ҷазояш марг аст“. ");
INSERT INTO tgk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Шумо бошед, таълим медиҳед, ки агар касе ба падару модараш бо чизе ёрӣ расонда тавонад, вале ёрӣ нарасонда гӯяд, ки ман инро ба Худо мебахшам, ");
INSERT INTO tgk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","он гоҳ ҳоҷат нест, ки ба падараш изҳори эҳтиром кунад. Ҳамин тавр шумо барои риоя кардани урфу одатҳои худ шуда, фармудаҳои Худоро барҳам медиҳед. ");
INSERT INTO tgk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Эй одамони дурӯя! Ҳақ буд Ишаъё пайғамбар, вақте ки оид ба шумо пешгӯӣ карда гуфта буд: ");
INSERT INTO tgk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","„Худо мегӯяд: «Ин одамон бо суханонашон Маро таъриф мекунанд, вале дар асл дилашон аз Ман дур аст. ");
INSERT INTO tgk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Онҳо Маро бефоида парастиш мекунанд, чунки қонуну қоидаҳои инсониро „қонуни Худо“ гуфта таълим медиҳанд!»“». ");
INSERT INTO tgk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Баъд Исо мардумро ба наздаш ҷеғ зада гуфт: «Ҳамин чизро бидонед, ки ");
INSERT INTO tgk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","он чи аз даҳони одам ба дарунаш медарояд, ӯро ҳаром намекунад, балки он чи аз даҳонаш берун мебарояд, ӯро ҳаром мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Он гоҳ шогирдонаш ба Ӯ наздик шуда гуфтанд: «Медонед, фарисиён аз суханони Шумо ранҷиданд». ");
INSERT INTO tgk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Исо дар ҷавоб гуфт: «Ҳар гиёҳе, ки Падари осмониам нашинондааст, бо решааш канда партофта мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ба фарисиён аҳамият надиҳед. Онҳо худашон кӯр ҳастанду боз дигар кӯронро роҳнамоӣ мекунанд. Агар кӯр ба кӯри дигар роҳ нишон диҳад, ҳардуяшон рафта ба чоҳ меафтанд». ");
INSERT INTO tgk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Дар ин вақт Петрус ба Исо мегӯяд: «Ба мо маънои масали пештар овардаатонро шарҳ диҳед». ");
INSERT INTO tgk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ӯ ба онҳо мегӯяд: «Наход то ҳол нафаҳмида бошед? ");
INSERT INTO tgk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Магар намедонед, ки он чи шумо мехӯред, аз даҳон медарояду баъд аз меъда гузашта берун мебарояд? ");
INSERT INTO tgk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Лекин он чи аз даҳон мебарояд, одамро ҳаром мекунад, чунки он аз дили одам бармеояд. ");
INSERT INTO tgk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Зеро аз дил фикрҳои бад берун меоянд, ки сабаби одамкушӣ, алоқаи беникоҳ, фисқу фуҷур, дуздиву шаҳодати дурӯғдиҳӣ ва тӯҳматкунӣ мегарданд. ");
INSERT INTO tgk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ана ин чизҳо одамро ҳаром мекунанд. Аммо бетаҳорат ба сари дастархон нишастан одамро ҳаром намекунад». ");
INSERT INTO tgk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Исо аз он ҷо баромада, ба наздикиҳои шаҳрҳои Суру Сидун рафт. ");
INSERT INTO tgk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Инак, як зани канъонӣ, ки дар он маҳал зиндагӣ мекард, додзанон назди Исо рафта истода гуфт: «Эй Насли Довуд! Илтимос, Хоҷаам, ба ман раҳм кунед! Духтарам дев дорад ва аҳволаш бениҳоят вазнин аст». ");
INSERT INTO tgk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Аммо аз Исо садое ҳам набаромад. Шогирдонаш ба Ӯ наздик шуда, хоҳиш карда гуфтанд: «Ин зан доду войкунон аз дунболи мо омада истодааст. Ба вай гӯед, ки биравад!» ");
INSERT INTO tgk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Исо ҷавоб дод: «Ман фақат ба назди гӯсфандони гумроҳшуда — халқи Исроил фиристода шудаам!» ");
INSERT INTO tgk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Дар ин мобайн зан ба Ӯ расида омаду ба пеши пойҳояш худро партофта зориву илтиҷо кард: «Хоҷаам, ба ман ёрӣ диҳед!» ");
INSERT INTO tgk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Вай ҷавоб гардонд: «Нони фарзандонро гирифта ба сагон партофтан дуруст нест». ");
INSERT INTO tgk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","«Рост мегӯед, Хоҷаам, — гуфт дар ҷавоб зан, — лекин сагон ҳам нонрезаҳои аз дастархони соҳибашон боқимондаро мехӯранд-ку». ");
INSERT INTO tgk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Исо ба ин ҷавоби ӯ гуфт: «Имонат бениҳоят боқувват будааст, хоҳар! Он чи мехостӣ бароят иҷро мешавад». Худи ҳамон лаҳза духтари зан шифо ёфт. ");
INSERT INTO tgk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Исо он ҷойро тарк карду қад-қади кӯли Ҷалил рафта ба теппае баромада нишаст. ");
INSERT INTO tgk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ба назди Вай тӯда-тӯда одамон омада, бо худ одамони лангу маъюб, кӯру гунг ва боз дигар хел касалонро оварда пеши пойҳояш мегузоштанд ва Ӯ ҳамаи онҳоро шифо медод. ");
INSERT INTO tgk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Дар пеши назари ҳама гунгҳо гап задаву лангҳо роҳ рафтаву кӯрон дида метавонистагӣ шуданд, маъюбон сиҳат гаштанд. Инро дида ҳама ҳайрон монданд ва Худои Исроилро ситоиш карданд. ");
INSERT INTO tgk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Исо шогирдонашро ба наздаш даъват карда гуфт: «Ба ин одамон раҳмам меояд, онҳо се рӯз боз бо Ман ҳастанд ва ҳеҷ хӯрдание надоранд. Ман намехоҳам, ки онҳоро аз пеши худ гурусна ҷавоб диҳам, мабодо дар роҳ аз ҳол нараванд». ");
INSERT INTO tgk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Шогирдонаш ба Ӯ гуфтанд: «Дар ин биёбон мо аз куҷо ин қадар нон меёбем, ки ба чунин тӯдаи одамон расонда тавонем?» ");
INSERT INTO tgk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Исо дар навбати худ аз онҳо пурсид: «Шумо чанд нон доред?» «Ҳафтто, — ҷавоб доданд онҳо, — ва якчанд моҳии хурд ҳам дорем». ");
INSERT INTO tgk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ӯ мардумро фармуд, ки рӯи замин бишинанд. ");
INSERT INTO tgk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Баъд он ҳафт нону моҳиҳоро ба даст гирифта, Худоро шукргӯён онҳоро пора кард ва ба шогирдонаш дод. Шогирдонаш нонпораҳоро гирифта ба мардум тақсим карданд. ");
INSERT INTO tgk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ҳамаи то сер шудан хӯрданду шогирдон боз ҳафт сабади калон пур аз нонпораҳои боқимонда ҷамъ карданд. ");
INSERT INTO tgk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Шумораи онҳое, ки нону моҳӣ хӯрда буданд, ғайр аз занону кӯдакон, чор ҳазор нафар буд. ");
INSERT INTO tgk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Пас Исо мардумро ҷавоб дода, ба қаиқ савор шуду ба сарзамини Маҷдал раҳсипор гашт. ");
INSERT INTO tgk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Баъд аз чанд вақт ба назди Исо баъзе аз фарисиён ва саддуқиён омаданд. Онҳо Вайро озмуданӣ шуда, талаб намуданд, ки ба онҳо ягон нишонае аз ҷониби Худо диҳад. ");
INSERT INTO tgk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Аммо Исо дар ҷавоб гуфт: «Агар шомгоҳон осмон кушода бошад, шумо мегӯед, ки пагоҳ ҳавои нағз мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Агар субҳидам осмон тираву гирифта бошад, мегӯед, ки имрӯз шамолу боронгарӣ мешавад. Шумо нишонаҳои осмонро дида чӣ гуна шудани ҳаворо фаҳмида метавонеду нишонаҳои ҳозиразамонро дида, онҳоро муайян карда наметавонед. ");
INSERT INTO tgk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Фақат насли ба Худо бевафою бадон нишона меҷӯяд! Худо ба ин насл ҳеҷ нишонаи дигаре ба ғайр аз он ки бо Юнус пайғамбар рӯй додааст, намедиҳад». Инро гуфта Ӯ аз наздашон рафт. ");
INSERT INTO tgk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Вақте ки шогирдон ба дигар тарафи кӯл расида омаданд, диданд, ки бо худ нон гирифтанро фаромӯш кардаанд. ");
INSERT INTO tgk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Исо ба онҳо гуфт: «Ҳушёр бошед! Худро аз хамиртуруши фарисиёну саддуқиён эҳтиёт кунед». ");
INSERT INTO tgk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Он гоҳ шогирдонаш ба муҳокима даромада, ба якдигар мегуфтанд: «Ӯ аз сабаби бо худ нон нагирифтанамон инро гуфт». ");
INSERT INTO tgk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Лекин Исо аз муҳокимаи онҳо дарак дошт ва пурсид: «Ҳой, барои чӣ шумо набудани нонро бо якдигар муҳокима мекунед? Имонатон ин қадар суст аст?! ");
INSERT INTO tgk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Наход то ҳол ҳеҷ чиз нафаҳмида бошед? Магар он панҷ нонро дар ёд надоред, ки чӣ хел панҷ ҳазор нафар хӯрданду боз боқимондаашро дар чанд сабад ҷамъ кардед? ");
INSERT INTO tgk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ё он ҳафт нонро, ки чор ҳазор нафар хӯрданду боз боқимондаашро дар чанд сабади калон ҷамъ кардед? ");
INSERT INTO tgk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Чӣ тавр шумо намефаҳмед, ки Ман нонро дар назар надорам? Балки гуфтанӣ ҳастам, ки худро аз хамиртуруши фарисиён ва саддуқиён эҳтиёт кунед!» ");
INSERT INTO tgk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Он гоҳ шогирдон фаҳмиданд, ки Ӯ на аз хамиртуруши нон, балки аз таълимоти фарисиёну саддуқиён эҳтиёт шудани онҳоро дар назар дошт. ");
INSERT INTO tgk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Исо бо шогирдонаш ба маҳаллаи назди шаҳраки Қайсарияи Филиппус рафт. Дар он ҷо Ӯ ба онҳо савол дод: «Одамон дар бораи кӣ будани Фарзанди Инсон чӣ мегӯянд?» ");
INSERT INTO tgk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Онҳо ҷавоб дода гуфтанд: «Баъзеҳо мегӯянд, ки Ӯ Яҳёи Таъмиддиҳанда аст, қисми дигари одамон мегӯяд, ки Илёс ё Ирмиё ва ё яке аз дигар пайғамбарони гузашта омадааст». ");
INSERT INTO tgk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Исо аз онҳо пурсид: «Шумо чӣ? Шумо Маро кӣ мешуморед?» ");
INSERT INTO tgk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Шимъӯни Петрус ба Ӯ ҷавоб дод: «Ту ҳамон Таъиншуда ва Писари Худои зинда ҳастӣ». ");
INSERT INTO tgk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Он гоҳ Исо ба Петрус гуфт: «Чӣ хел хушбахт ҳастӣ, Шимъӯн, писари Юҳанно! Чунки инро ба ту на одамизод, балки Падари Ман, ки дар осмон аст, ошкор кардааст. ");
INSERT INTO tgk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Бинобар ин ба ту мегӯям, ки ту Петрус — санг ҳастӣ ва дар болои ин санг Ман ҷамоати имондорони худро пойдор менамоям ва онро ҳатто қувваҳои марг мағлуб карда наметавонанд. ");
INSERT INTO tgk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ман ба ту калидҳои подшоҳии Худоро медиҳам ва ҳар чиро, ки ту дар замин манъ кунӣ, Худо аз осмон онро манъ мекунад ва ба ҳар чӣ, ки иҷозат диҳӣ, Худо аз осмон ба он иҷозат медиҳад». ");
INSERT INTO tgk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Баъд Исо ба шогирдонаш қатъӣ таъкид кард, ки Таъиншудаи Худо будани Ӯро ба касе нагӯянд. ");
INSERT INTO tgk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Аз ҳамон вақт сар карда Ӯ ба шогирдонаш кушоду равшан мегуфт, ки бояд ба Ерусалим равад ва дар он ҷо аз дасти пирони қавм, сардорони рӯҳонӣ ва шариатдонон бисёр азоб мекашад. Оқибат Ӯ кушта мешавад, вале баъд аз се рӯз аз нав зинда мегардад. ");
INSERT INTO tgk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Петрус бошад, Исоро як сӯ бурда сарзаниш карда гуфт: «Худо нишон надиҳад! Эй Худованд, он чи гуфтӣ, бигзор ба сарат наояд!» ");
INSERT INTO tgk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Лекин Вай ба Петрус рӯй оварда гуфт: «Дур шав аз Ман, шайтон! Ту ба Ман халал расонда истодаӣ, чунки ту фикри Худоро надорӣ, балки фикри инсонӣ мекунӣ!» ");
INSERT INTO tgk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Он гоҳ Исо ба шогирдонаш гуфт: «Ҳар каси шумо, ки пайрави Ман шудан хоҳад, бояд аз манфиатҳои худ даст кашида, салиби азобу маргашро бардошта барад ва он гоҳ Маро пайравӣ кунад. ");
INSERT INTO tgk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Зеро касе, ки ҳаёташро нигоҳ доштан мехоҳад, онро аз даст медиҳад, вале ҳар касе, ки ба хотири Ман аз баҳри ҳаёти худаш мегузарад, ҳаёти абадӣ ба даст меоварад. ");
INSERT INTO tgk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ба одам чӣ фоидае дорад, ки тамоми дунёро ба даст овараду ҷонашро аз даст диҳад? Одамизод бар ивази ҷони худ ҳеҷ товоне дода наметавонад. ");
INSERT INTO tgk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Фарзанди Инсон бо шӯҳрату ҷалоле, ки Падараш ба Ӯ медиҳад, ҳамроҳи фариштаҳои худ меояд ва ба ҳама он чиро, ки мувофиқи амалашон сазовор мешаванд, медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ба ростӣ ба шумо мегӯям, дар ин ҷо чанд касе ҳастанд, ки ҳанӯз дар қайди ҳаёт буданашон мебинанд, ки чӣ тавр Фарзанди Инсон барои подшоҳӣ кардан меояд». ");
INSERT INTO tgk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Пас аз шаш рӯз Исо Петрус ва бародарон Ёқубу Юҳанноро ҳамроҳаш гирифта ба баландии кӯҳе бурд, ки он ҷо онҳо танҳо буданд. ");
INSERT INTO tgk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Баъд дар пеши назари шогирдон намуди зоҳирии Ӯ дигаргун шуд. Чеҳрааш монанди офтоб дурахшид, либосаш ҳам мисли равшании нур сап-сафед шуд. ");
INSERT INTO tgk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ногаҳон Мӯсо ва Илёс пайғамбар дар пеши назари шогирдон пайдо шуданд ва бо Исо сӯҳбат мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Петрус ба сухан даромада ба Исо гуфт: «Худовандо, чӣ хуб аст, ки мо ин ҷо ҳастем. Агар хоҳӣ ман дар ин ҷо се хайма месозам, яке барои Ту, дигаре барои Мӯсо ва сеюм барои Илёс». ");
INSERT INTO tgk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ҳанӯз вай суханашро тамом накарда, абри тобоне пайдо шуда, онҳоро бо сояаш фаро гирифт ва аз даруни он овозе шунида шуд: «Ин Писари азизи Ман аст ва Ман аз Ӯ хушнудам. Ӯро гӯш кунед». ");
INSERT INTO tgk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Аз шунидани ин овоз шогирдонро ваҳм фаро гирифт ва онҳо худро рӯи замин партофтанд. ");
INSERT INTO tgk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Аммо Исо ба наздашон омаду ба онҳо даст расонда гуфт: «Бархезед ва аз ҳеҷ чиз натарсед». ");
INSERT INTO tgk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Онҳо ба боло нигоҳ карданд ва ғайр аз Исо касеро надиданд. ");
INSERT INTO tgk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Аз кӯҳ поён фаромада истода Исо ба шогирдон фармуд, ки то Фарзанди Инсон мурда аз нав зинда нашавад, ба ҳеҷ кас аз чизи дидагиашон даҳон накушоянд. ");
INSERT INTO tgk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Он гоҳ шогирдон аз Ӯ пурсиданд: «Чаро шариатдонон мегӯянд, ки пеш аз Масеҳ бояд Илёс биёяд?» ");
INSERT INTO tgk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","«Дуруст, — ҷавоб дод Ӯ, — аввал бояд Илёс биёяд ва ҳама чизро барқарор намояд. ");
INSERT INTO tgk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ба шумо мегӯям, ки Илёс аллакай омадааст ва одамон вайро нашинохтанду ҳар коре, ки хостанд, бо вай карданд. Бо Фарзанди Инсон низ ҳамон тавр рафтор хоҳанд кард». ");
INSERT INTO tgk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Он вақт шогирдон фаҳмиданд, ки Исо Илёс гуфта Яҳёи Таъмиддиҳандаро дар назар дошт. ");
INSERT INTO tgk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ҳангоме ки онҳо назди мардум баргаштанд, марде пеши Исо омаду ба сари зону истода ");
INSERT INTO tgk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","гуфт: «Хоҷа, ба писарам раҳм бикун! Вай касалии эпилепсия дорад ва бениҳоят азоб мекашад. Аз ин рӯ, ӯ худро зуд-зуд ба оташ ё ба об мепартояд. ");
INSERT INTO tgk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Вайро ба назди шогирдонат овардам, лекин онҳо ӯро шифо дода натавонистанд». ");
INSERT INTO tgk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Исо ҷавоб дод: «Эй насли беимонону гумроҳон! То кай бо шумо бошам? То кай шуморо тоқат кунам? Канӣ, рафта бачаро ба наздам биёред!» ");
INSERT INTO tgk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Бачаро гирифта ба наздаш оварданд ва Ӯ ба дев фармон дод, ки аз бача берун барояд. Дев берун баромад ва бача худи ҳамон лаҳза сиҳат гашт. ");
INSERT INTO tgk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Сипас шогирдон аз мардум ҷудо шуда, пеши Исо омада пурсиданд: «Чаро мо девро берун карда натавонистем?» ");
INSERT INTO tgk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ӯ дар ҷавоб гуфт: «Аз барои сустии имонатон. Ба ростӣ ба шумо мегӯям, агар имонатон донаи хардал барин бошад, он гоҳ ба ин кӯҳ „Аз ин ҷо ба он ҷо гузар“ гӯед, кӯҳ мегузарад. Пас, бароятон ҳеҷ чиз имконнопазир намешавад. ");
INSERT INTO tgk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Аммо ин зот фақат бо дуо ва рӯза берун карда мешавад». ");
INSERT INTO tgk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ҳангоме ки шогирдон дар Ҷалил ҷамъ омаданд, Исо ба онҳо гуфт: «Фарзанди Инсон ба дасти одамон супорида мешавад ");
INSERT INTO tgk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ва онҳо Ӯро мекушанд, лекин дар рӯзи сеюм Ӯ аз нав зинда мегардад». Шогирдон аз шунидани ин суханон сахт ғамгин гаштанд. ");
INSERT INTO tgk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Вақте ки Исо бо шогирдонаш ба Кафарнаҳум омад, касоне ки барои Хонаи Худо андоз ҷамъ мекарданд, назди Петрус омада пурсиданд: «Магар устоди ту андоз намесупорад?» ");
INSERT INTO tgk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","«Албатта месупорад», — ҷавоб дод Петрус. Баъд Петрус ба хона даромад ва ҳанӯз ӯ даҳон накушода, Исо ба вай гуфт: «Шимъӯн, бигӯй, ба фикрат подшоҳон андозу хироҷро аз кӣ меситонанд? Аз шаҳрвандони худӣ ё бегона?» ");
INSERT INTO tgk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","«Аз бегона», — ҷавоб гардонд Петрус. «Пас, шаҳрвандони худӣ аз ин вазифа озоданд. ");
INSERT INTO tgk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Лекин барои наранҷонидани ин одамон сӯи кӯл рафта бо шасти моҳигирӣ сайд кун. Аз даҳони моҳии аввалине, ки сайд мекунӣ, тангаеро меёбӣ ва ин тангаро гирифта аз номи Ман ва худат андозро супор». ");
INSERT INTO tgk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Аз мобайн вақти зиёде нагузашта, ба пеши Исо шогирдонаш омада пурсиданд: «Дар подшоҳии Худо кӣ бузургтар аст?» ");
INSERT INTO tgk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Исо ба наздаш як кӯдакро хонда, ӯро дар пеши шогирдонаш гузошту ");
INSERT INTO tgk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ҷавоб дод: «Ба ростӣ ба шумо мегӯям, то тарзи фикррониатонро тағйир дода, монанди кӯдакон нашавед, ҳаргиз ба подшоҳии Худо дохил шуда наметавонед. ");
INSERT INTO tgk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Аз ин рӯ, он кас дар подшоҳии Худо бузургтар аст, ки худро монанди ин бача хоксор мегирад. ");
INSERT INTO tgk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ҳар касе ки чунин кӯдакро ба хотири номи Ман қабул мекунад, дар асл Маро қабул мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Лекин вой бар ҳоли касе, ки яке аз пайравони хурдтарини ба Ман боваркардаро аз роҳи имон занад. Барои вай беҳтар мешуд, ки ба гарданаш санги осиёбро баста, ба баҳри чуқур партоянд. ");
INSERT INTO tgk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Вой бар ҳоли одамони ин олам аз дасти васвасаҳо! Васвасаҳо ҳамеша пайдо мешаванд, вале вой бар ҳоли васвасакорон! ");
INSERT INTO tgk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Агар даст ё поят туро ба гуноҳ кардан водор созад, онро бурида парто, зеро бароят беҳтар аст, ки бе як даст ё пой буда, соҳиби ҳаёт шавӣ, аз он ки ду дасту пой дошта бошию ба оташи абадии дӯзах биафтӣ. ");
INSERT INTO tgk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Инчунин, агар чашмат туро ба гуноҳ кардан водор созад, онро канда парто, зеро бароят беҳтар аст, ки як чашм дошта бошию соҳиби ҳаёт шавӣ, аз он ки ду чашм дошта бошиву ба оташи дӯзах партофта шавӣ». ");
INSERT INTO tgk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ӯ суханашро давом дода гуфт: «Эҳтиёт бошед, ки ҳатто бо яке аз пайравони хурдтаринам хунукназарона рафтор накунед, зеро ба шумо мегӯям, ки фариштаҳои нигаҳбони онҳо ҳамеша дар назди Падари осмониам ҳузур дошта метавонанд. ");
INSERT INTO tgk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Фарз кардем, ки як мард сад сар гӯсфанд дораду якеаш аз рама ақиб монда роҳро гум мекунад. Он мард чӣ кор мекунад? Магар наваду нӯҳ гӯсфандро дар теппаҳои чарогоҳ монда ба ҷустуҷӯи гӯсфанди гумроҳшудааш намеравад? ");
INSERT INTO tgk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ва баъд аз ёфтанаш, ба ростӣ ба шумо мегӯям, ки барои ин гӯсфанд назар ба он наваду нӯҳ гӯсфанди гумроҳнашуда бештар хурсандӣ мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Падари осмонии шумо низ ҳаргиз намехоҳад, ки яке аз пайравони хурдтарини Ман гумроҳ шавад. ");
INSERT INTO tgk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Агар ягон бародаратон бар зидди яке аз шумо гуноҳ кунад, ба назди ҳамон бародар рафта, якка ба якка айбашро ба рӯяш гӯед, агар айбашро ба гардан гирад, донед, ки вайро аз нав ҳамчун бародар пайдо кардаед. ");
INSERT INTO tgk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Вале, агар ба гапатон гӯш надиҳад, рафта як ё ду бародари дигарро ҳамроҳатон биёред, то ҳақ будани суханатон бо ду ё се шоҳид исбот гардад. ");
INSERT INTO tgk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Агар ба гапи онҳо ҳам гӯш надиҳад, ба ҷамоати имондорон дар ин хусус гӯед. Аммо агар ба гапи тамоми ҷамоат низ гӯш надиҳад, бигзор вай бароятон ҳамчун андозгири беинсофу одами беимон бошад. ");
INSERT INTO tgk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ба ростӣ ба шумо мегӯям, ҳар чиро, ки шумо дар замин манъ кунед, Худо аз осмон онро манъ мекунад ва ба ҳар чӣ, ки иҷозат диҳед, Худо аз осмон ба он иҷозат медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Боз илова мекунам, агар дар замин ду каси шумо бо розигии якдигар барои ягон чиз дуо кунед, Падари осмониам ҳатман бароятон ҳамон чизро иҷро мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Зеро дар ҷое, ки ду ё се кас ба хотири номи Ман ҷамъ мешаванд, Ман ҳам дар байни онҳо мешавам». ");
INSERT INTO tgk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Баъдтар Петрус назди Исо омада пурсид: «Худованд, агар бародаре бар зидди ман гуноҳ кардан гирад, чанд маротиба вайро бахшиданам даркор? Ҳафт маротиба?» ");
INSERT INTO tgk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","«Не, — ҷавоб дод Ӯ. — Ҳафт маротиба нею ҳафтод карат ҳафт маротиба бубахш. ");
INSERT INTO tgk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Зеро подшоҳии Худоро чунин тасвир кардан мумкин: Рӯзе як подшоҳ хост, ки қарзҳои хизматгоронашро ба ҳисоб гирад. ");
INSERT INTO tgk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Вақте ки ҳисобу китобро сар кард, ба наздаш хизматгореро оварданд, ки аз шоҳ маблағи бениҳоят калоне қарздор буд. ");
INSERT INTO tgk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Азбаски хизматгор аз ӯҳдаи баргардондани қарз баромада наметавонист, шоҳ амр дод, ки ба ҷои товон ӯ бо зану фарзандонаш ва тамоми молу мулкаш фурӯхта шавад. ");
INSERT INTO tgk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Он хизматгор худро пеши пойҳои шоҳ партофта зорию тавалло карда гуфт: „Тақсирам, илтимос, ба ман мӯҳлат диҳед ва ман тамоми қарзамро бармегардонам“. ");
INSERT INTO tgk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Шоҳ ба ҳоли хизматгор раҳм карду қарзашро ба вай бахшида ҷавоб дод. ");
INSERT INTO tgk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Хизматгор бошад, берун баромада ҳамхизматашро дид. Ин ҳамхизматаш аз вай маблағи нисбатан камтаре қарздор буд. Вай аз гулӯи ҳамхизматаш дошта, ӯро буғӣ карда истода талаб кард, ки қарзашро гардонда диҳад. ");
INSERT INTO tgk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ҳамхизматаш худро ба рӯи замин партофта, ба зориву тавалло кардан даромад: „Илтимос, мӯҳлат деҳ ва ман албатта қарзамро бармегардонам“. ");
INSERT INTO tgk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Аммо хизматгор розӣ нашуда, ҳамхизматашро ба ҳабсхона супорид ва ӯ то қарзро гардонда надиҳад, ҳамон ҷо мемонд. ");
INSERT INTO tgk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Дигар хизматгорон ин ҳодисаро дида, сахт ранҷиданд ва рафта ба шоҳ буду шуди воқеаро нақл карданд. ");
INSERT INTO tgk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Шоҳ он хизматгорро ба наздаш хонда гуфт: „Эй хизматгори бад! Ту маро зориву тавалло кардӣ ва ман ба ту тамоми қарзатро бахшидам. ");
INSERT INTO tgk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ман ба ту раҳм кардам. Пас, ту ҳам бояд ба ҳамхизматат раҳм мекардӣ“. ");
INSERT INTO tgk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Шоҳ дар ғазаб шуда, амр дод, ки ин хизматгорро то пурра супоридани қарзаш ба ҳабс партоянд, то азобашро кашад. ");
INSERT INTO tgk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Хуллас, Падари осмониам низ то бародаратонро аз самими дил набахшед, бо ҳар яки шумо айнан ҳамин тавр рафтор мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Исо суханонашро ба охир расонда, аз вилояти Ҷалил сӯи сарзамини Яҳудия, ки дар дигар тарафи дарёи Урдун ҷойгир буд, раҳсипор шуд. ");
INSERT INTO tgk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Аз паси Ӯ тӯда-тӯдаи одамон низ рафтанд ва дар он ҷо Ӯ онҳоро шифо бахшид. ");
INSERT INTO tgk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Баъд чанд нафаре аз фарисиён Исоро озмуданӣ шуда, савол доданд: «Оё аз рӯи шариат мумкин аст, ки мард бо ҳар сабабе, ки хоҳад, аз занаш ҷудо шавад?» ");
INSERT INTO tgk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Исо дар ҷавоб ба онҳо гуфт: «Магар дар навиштаҷот нахондаед, ки „Офарандаи одамизод аз ибтидо онҳоро мард ва зан офаридааст“? ");
INSERT INTO tgk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Боз дар навиштаҷот гуфта шудааст, ки „Бинобар ин мард бояд аз падару модараш ҷудо шуда, бо ҳамсараш бипайвандад, то ки на ду нафар, балки як тан шаванд“. ");
INSERT INTO tgk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Акнун онҳо на ду тан, балки якто ҳастанд. Пас, бигзор касе зану шавҳарро аз ҳамдигар ҷудо накунад, зеро Худо он ду нафарро бо ҳам пайвастааст». ");
INSERT INTO tgk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Фарисиён боз саволе доданд: «Пас, чаро Мӯсо фармудааст, ки барои ҷудо шудан мард бояд ба занаш талоқномае навишта ҷавоб диҳад?» ");
INSERT INTO tgk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ӯ дар ҷавоб гуфт: «Ба сабаби сангдилиатон Мӯсо иҷозати ҷудо шуданро додааст, аммо аз аввал ин тавр набуд. ");
INSERT INTO tgk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ман ҳоло ба шумо мегӯям, агар марде бо ҳар сабабе (ғайр аз сабаби бевафоии занаш) аз занаш ҷудо шуда, зани дигар гирад, вай гуноҳи алоқаи беникоҳро мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Шогирдони Исо гуфтанд: «Устод, агар вазифаи шавҳар нисбат ба зан ин хел бошад, он гоҳ ба мард беҳтар аст, ки тамоман зан нагирад». ");
INSERT INTO tgk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","«На ҳама ин гуфтаҳоро қабул карда метавонанд, — ҷавоб дод Вай, — фақат касоне, ки Худо ба онҳо насиб гардондааст. ");
INSERT INTO tgk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Зеро мардон бо сабабҳои гуногун зан намегиранд: баъзеҳо мисли ахташуда таваллуд мешаванд, баъзеҳоро одамон ахта мекунанд ва баъзеҳо бо нияти ба Худо хизмат кардан зан намегиранд. Бигзор касе, ки ин гуфтаҳоро қабул карда метавонад, қабул кунад». ");
INSERT INTO tgk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Баъзе касон ба назди Исо кӯдаконро оварданд, то ки Ӯ ба сари онҳо даст гузошта барояшон дуо кунад. Шогирдон инро дида, онҳоро сарзаниш намуданд. ");
INSERT INTO tgk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Аммо Исо гуфт: «Монед, ки кӯдакон назди Ман оянд, пеши роҳи онҳоро нагиред, зеро Худо дар ҳаёти онҳое подшоҳӣ мекунад, ки мисли ин кӯдакон ҳастанд». ");
INSERT INTO tgk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Баъд бо нияти баракат додан ба сари кӯдакон даст гузошту аз он ҷо рафт. ");
INSERT INTO tgk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Боре як мард пеши Исо омада, аз ӯ пурсид: «Устод, барои ба даст овардани ҳаёти абадӣ чӣ некие бояд кунам?» ");
INSERT INTO tgk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ӯ ба мард ҷавоб дод: «Чаро аз Ман дар бораи чизи нек мепурсӣ? Фақат як кас нек аст. Агар хоҳӣ, ки ҳаёти абадӣ насибат гардад, фармоишҳоро риоя намо». ");
INSERT INTO tgk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","«Кадом фармоишҳоро?» — пурсид мард. Исо ба номбар кардани фармоишҳо даромада гуфт: «Одамкушӣ накун, алоқаи беникоҳ накун, дуздӣ накун, шаҳодати бардурӯғ надеҳ, ");
INSERT INTO tgk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","падару модаратро ҳурмату эҳтиром намо ва шахсеро, ки наздики ту аст, мисли худат дӯст бидор». ");
INSERT INTO tgk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ҷавонмард ҷавоб дод: «То ба имрӯз ҳамаи ин фармоишҳоро риоя кардаам. Ғайр аз ин боз чӣ карданам лозим аст?» ");
INSERT INTO tgk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Исо ба вай гуфт: «Агар хоҳӣ, ки комил бошӣ, рафта, тамоми молу мулкатро фурӯшу пулашро ба камбағалон тақсим бикун. Он гоҳ соҳиби мукофоти осмонӣ мегардӣ. Баъд омада, Маро пайравӣ намо». ");
INSERT INTO tgk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ҷавонмард хеле сарватманд буд, бинобар ҳамин бо шунидани ин суханон андӯҳгин гашта, аз он ҷо рафт. ");
INSERT INTO tgk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Он гоҳ Исо ба шогирдонаш гуфт: «Ба ростӣ ба шумо мегӯям, ки ба подшоҳии Худо дохил шудани шахси сарватманд бениҳоят душвор аст. ");
INSERT INTO tgk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Боз мегӯям, ки аз сӯрохи сӯзан гузаштани шутур осонтар аз он, ки шахси сарватманд ба подшоҳии Худо дохил шавад». ");
INSERT INTO tgk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Шунидани ин суханон шогирдонро ба ҳайрат оварду онҳо пурсиданд: «Пас кӣ наҷот ёфта метавонад?» ");
INSERT INTO tgk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Исо ба шогирдонаш бодиққат нигоҳ карда гуфт: «Ба инсон ин корро кардан ғайриимкон аст, вале бо Худо аз ӯҳдаи ҳар кор баромадан мумкин аст». ");
INSERT INTO tgk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Он гоҳ Петрус гуфт: «Ана, мо аз баҳри ҳама чиз баромада, Шуморо пайравӣ кардем. Пас насиби мо чист?» ");
INSERT INTO tgk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Исо ба онҳо ҷавоб дод: «Ба ростӣ ба шумо мегӯям, вақте ки давраи нав сар мешаваду Фарзанди Инсон бар тахти пуршукӯҳи худ менишинад, дувоздаҳ нафари шумо низ, ки Маро пайравӣ кардаед, бар тахтҳо нишаста ба дувоздаҳ қабилаи Исроил ҳукмронӣ хоҳед кард. ");
INSERT INTO tgk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Инчунин, ҳар касе ки барои Ман шуда аз баҳри хонаҳо, бародарон ё хоҳарон, падар ё модар, фарзандон ё заминҳояш гузашта бошад, ҳамаи инро сад маротиба зиёдтар пайдо мекунад ва дар оянда зиндагии абадӣ низ насибаш мегардад. ");
INSERT INTO tgk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Лекин бисёри онҳое, ки ҳоло дар сафи пеш ҳастанд, дар сафи ақиб мешаванд ва онҳое, ки дар сафи ақиб ҳастанд, дар сафи пеш мешаванд». ");
INSERT INTO tgk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Исо суханашро давом дода гуфт: «Подшоҳии Худоро чунин тасвир кардан мумкин: як заминдор барои ба токзораш киро кардани мардикорон саҳарии барвақт ба бозор баромад. ");
INSERT INTO tgk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ӯ якчанд мардикорро ёфта, онҳоро бо якдинорӣ ба рӯзи кориашон киро карду ба токзораш фиристод. ");
INSERT INTO tgk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Соати қариби нӯҳ вай боз ба бозор рафт ва дар он ҷо якчанд марди бекористодаро дида, ");
INSERT INTO tgk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ба онҳо гуфт: „Шумо ҳам ба токзори ман рафта кор кунед, баъд ман шуморо розӣ мекунам“. Онҳо рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Заминдор соатҳои тақрибан дувоздаҳ ва се низ рафта мардикоронро киро кард. ");
INSERT INTO tgk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Қариби соати панҷ буд, ки вай боз ба бозор рафт ва боз якчанд марди бекористодаро дида пурсид: „Чаро шумо тамоми рӯзатонро бе кор гузаронда истодаед?“ ");
INSERT INTO tgk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Онҳо дар ҷавоб гуфтанд: „Чунки ҳеҷ кас моро киро накард“. „Хайр, набошад, ба токзори ман рафта кор кунед“, — таклиф кард соҳиби токзор. ");
INSERT INTO tgk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Бо наздикшавии шом соҳиби токзор ба назоратчиаш гуфт: „Рафта мардикоронро ҷеғ зану аз онҳое, ки охирин киро кардам, сар карда то ба онҳое, ки аввал киро кардам, бо навбат музди корашонро деҳ“. ");
INSERT INTO tgk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Мардикороне, ки соати панҷ киро шуда буданд, ҳар кадоме якдинорӣ музд гирифтанд. ");
INSERT INTO tgk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Инак, онҳое, ки аввал киро шуда буданд, фикр карданд, ки бештар музд мегиранд, аммо бо расидани навбати онҳо, ҳар кадоме аз онҳо низ якдинорӣ гирифтанд. ");
INSERT INTO tgk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Онҳо пулашонро гирифта, аз соҳиби токзор шикоят карданд: ");
INSERT INTO tgk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","„Онҳое, ки охирин киро шуда буданд, фақат як соат кор карданд. Мо бошем, дар офтоби сӯзон рӯзи дароз арақи ҷабин рехта кор кардему шумо ба онҳо баробари мо музд додед!“ ");
INSERT INTO tgk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Лекин соҳиби токзор ба яке аз онҳо ҷавоб дода гуфт: „Ҳой, ҷӯра! Ман ҳаққатро нахӯрдаам. Магар худат розӣ нашудӣ, ки ба як рӯзи кориат як динор диҳам? ");
INSERT INTO tgk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ана, пулатро гиру ба хонаат рав. Ба ин марди охирин киро кардаам бошад, ман хостам баробари ту музд диҳам. ");
INSERT INTO tgk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Чӣ магар ман ҳақ надорам, чи хеле ки хоҳам, ҳамон хел пуламро сарф кунам? Ё ба саховатмандии ман ҳасад мебарӣ?“» ");
INSERT INTO tgk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Дар хотима Исо гуфт: «Пас, касоне, ки ҳоло дар сафи пеш истодаанд, дар сафи ақиб хоҳанд шуд ва касоне, ки ҳоло дар сафи ақиб ҳастанд, дар сафи пеш хоҳанд шуд». ");
INSERT INTO tgk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Исо ба сӯи Ерусалим роҳравон шогирдонашро ба як тарафе бурда танҳо ба онҳо гуфт: ");
INSERT INTO tgk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ана, мо ба Ерусалим рафта истодаем. Дар он ҷо Фарзанди Инсон ба дасти сардорони рӯҳонӣ ва шариатдонон супорида мешавад. Онҳо Ӯро ба марг маҳкум карда, ");
INSERT INTO tgk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ба дасти беимонон месупоранд. Беимонон бошанд, Ӯро масхараву қамчинкорӣ карда, оқибат ба салиб мехкӯб менамоянд. Лекин Вай дар рӯзи сеюм аз нав зинда мешавад». ");
INSERT INTO tgk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Дар ин миён зани Забдой бо ду писараш назди Исо омада, ба Ӯ таъзим карду чизе хоҳиш карданӣ шуд. ");
INSERT INTO tgk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Исо пурсид: «Ту чӣ мехоҳӣ?» «Мехоҳам, амр кунӣ, ки ҳангоми подшоҳӣ карданат писарони ман аз дасти чапу рости Ту бишинанд», — ҷавоб дод зан. ");
INSERT INTO tgk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Исо ба писарони зан гуфт: «Шумо намефаҳмед, ки чиро талаб карда истодаед. Магар аз он косаи азобе, ки Ман менӯшам, шумо нӯшида метавонед?» «Метавонем», — ҷавоб доданд онҳо. ");
INSERT INTO tgk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ӯ гуфт: «Бале, шумо дар ҳақиқат аз косаи Ман хоҳед нӯшид. Аммо ба интихоб кардани касоне, ки аз дасти чапу рости Ман мешинанд, ҳақ надорам. Ин ҷойҳо насиби онҳое мешаванд, ки Падарам барояшон тайёр кардааст». ");
INSERT INTO tgk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Даҳ шогирди дигар ин гуфтугӯйро шунида, ба ин ду бародар сахт қаҳрашон омад. ");
INSERT INTO tgk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Он гоҳ Исо ҳамаи онҳоро ба наздаш ҷеғ зада гуфт: «Шумо хуб медонед, ки подшоҳон ва ҳокимони халқҳо ба мардуми худ зӯроварӣ мекунанд ва ҳукмашонро бар онҳо мегузаронанд. ");
INSERT INTO tgk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Лекин дар байни шумо набояд ин тавр бошад. Баръакс, ҳар кас ки дар байни шумо бузург будан мехоҳад, бояд хизматгори дигарон бошад ");
INSERT INTO tgk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ва ҳар кас ки мехоҳад дар сафи пеш истад, бояд ғуломи дигарон бошад. ");
INSERT INTO tgk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Айнан чӣ тавре ки Фарзанди Инсон на барои он омадааст, ки касе ба Ӯ хизмат кунад, балки омад, то ки ба дигарон хизмат кунад ва барои нархи наҷоти бисёр одамонро супоридан ҷонашро фидо кунад». ");
INSERT INTO tgk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Баъдтар Исо бо шогирдонаш аз шаҳри Ериҳӯ ба роҳ баромада буд, ки мардуми зиёде аз пайи онҳо рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Воқеан ду нобиное дар канори роҳ менишастанд. Онҳо гузашта истодани Исоро шунида, зуд фарёд заданд: «Эй Насли Довуд! Эй Хоҷа ба мо раҳм кун!» ");
INSERT INTO tgk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Мардум бошанд, онҳоро сарзаниш карда мегуфтанд, ки хомӯш шаванд. Аммо онҳо боз баландтар дод зада мегуфтанд: «Эй Насли Довуд! Эй Хоҷа ба мо раҳм кун!» ");
INSERT INTO tgk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Исо аз роҳаш бозистода онҳоро ба наздаш хонд ва пурсид: «Шумо чӣ мехоҳед? Бароятон чӣ кор кунам?» ");
INSERT INTO tgk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Онҳо ҷавоб дода гуфтанд: «Хоҷа, мехоҳем, ки чашмонамонро бино кунед». ");
INSERT INTO tgk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Дили Исо ба ҳоли онҳо сӯхту ба чашмонашон даст гузошт. Худи ҳамон лаҳза чашмони он ду мард бино шуданд ва онҳо аз паси Исо рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Исо ва шогирдонаш ба шаҳри Ерусалим наздик шуда истода, ба деҳаи Байт-Фоҷии назди теппаи Зайтун расида омаданд. Пас, Ӯ ду шогирдашро пешопеши худ фиристода, ");
INSERT INTO tgk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ба онҳо чунин гуфт: «Ба қишлоқи дар пешистода равед ва ҳамин ки ба он ҷо рафта расидед, модахари басташудаеро якҷоя бо бачааш меёбед. Банди вайро кушоеду ҳардуяшро ба наздам биёред. ");
INSERT INTO tgk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Агар касе ягон гап занад, гӯед, ки онҳо ба Худованд даркор шуданд ва ӯ даррав ба бурдан иҷозат медиҳад». ");
INSERT INTO tgk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ин ҳодиса барои ба амал омадани суханони пайғамбар рӯй дод, ки чунин гуфта буд: ");
INSERT INTO tgk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Ба сокинони шаҳри Ерусалим бигӯед: „Ана, Шоҳи шумо ба наздатон омада истодааст. Шоҳи хоксор, ки харсавор, болои бачаи модахаре омада истодааст“». ");
INSERT INTO tgk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Инак, ду шогирдаш рафта гуфтаи Исоро иҷро карданд. ");
INSERT INTO tgk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Онҳо модахарро бо бачааш оварда, ҷомаҳои худро ба болои онҳо партофтанд ва Исо савор шуд. ");
INSERT INTO tgk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Мардуми зиёде, ки бо Исо буданд, ҷомаҳои худро пеши роҳи Ӯ пойандоз мекарданд, баъзеашон бошанд, навдаҳои дарахтонро бурида, аз рӯи иззат сари роҳаш мегузоштанд. ");
INSERT INTO tgk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Мардум аз пешу қафои Исо роҳравон бо овози баланд дод мезаданд: «Шаъну шараф ба Насли Довуд! Баракат ёбад касе, ки аз номи Худованд меояд! Шаъну шараф ба Худо дар осмон!» ");
INSERT INTO tgk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Вақте ки Ӯ ба Ерусалим ворид гашт тамоми шаҳр ба ҳаяҷон омад. Одамон «Ин кист?» гуфта мепурсиданд. ");
INSERT INTO tgk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Мардуме, ки аз пайи Исо меомаданд, ҷавоб медоданд, ки ин Исо пайғамбар аз шаҳри Носираи вилояти Ҷалил аст. ");
INSERT INTO tgk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Сипас, Исо ба ҳавлии Хонаи Худо даромада, ҳамаи онҳоеро, ки бо хариду фурӯш машғул буданд, аз он ҷо берун ронд. Мизҳои пуливазкунандагон ва курсиҳои кафтарфурӯшонро чаппа карда ");
INSERT INTO tgk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","гуфт: «Дар навиштаҷот гуфтаҳои Худо омадаанд, ки „Хонаи Ман ҷои дуогӯӣ номида мешавад“. Шумо бошед, онро ба паноҳгоҳи дуздон табдил додаед». ");
INSERT INTO tgk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Дар ин мобайн кӯрон ва лангон дар Хонаи Худо назди Исо омаданд ва Ӯ онҳоро шифо дод. ");
INSERT INTO tgk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Сардорони рӯҳонӣ ва шариатдонон бо дидани мӯъҷизаҳои аҷоиби Исо ва аз шунидани доди кӯдакон, ки дар Хонаи Худо «Шаъну шараф ба Насли Довуд!» мегуфтанд, ба ғазаб омаданд. ");
INSERT INTO tgk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Онҳо ба Вай гуфтанд: «Магар Ту намешунавӣ, ки кӯдакон чӣ гуфта истодаанд?» «Албатта мешунавам, — ҷавоб дод Исо ва илова кард, — Магар шумо дар навиштаҷот ин гуфтаҳоро нахондаед: „Забони кӯдакону тифлҳои ширхорро Ту асбоби ситоиши худ гардондӣ“?» ");
INSERT INTO tgk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Бо ин суханон Исо онҳоро тарк карду аз шаҳр берун шуда, ба деҳаи Байт-Ҳинӣ рафт ва шабро дар он ҷо гузаронд. ");
INSERT INTO tgk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Бомдодон Ӯ ба шаҳр баргашта истода буд, ки гурусна монд. ");
INSERT INTO tgk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Воқеан дар сари роҳаш дарахти анҷиреро дида, ба назди он омад. Аммо ба ғайр аз баргҳо дар он ҳеҷ чиз наёфта, ба дарахт гуфт: «Акнун, ту ҳаргиз мева нахоҳӣ дод». Фавран дарахт аз бехаш хушк шуд. ");
INSERT INTO tgk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Шогирдон ин ҳодисаро дида, бо тааҷҷуб пурсиданд: «Устод, чӣ хел шуд, ки дарахти анҷир якбора аз бехаш хушк шуд?» ");
INSERT INTO tgk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Исо ба онҳо ҷавоб дод: «Ба ростӣ ба шумо мегӯям, агар шумо бовар кунеду шубҳа надошта бошед, он гоҳ он кореро, ки Ман бо дарахти анҷир кардам, шумо ҳам карда метавонед. Ва на фақат ин корро, балки, агар шумо ҳатто ба кӯҳ гӯед, ки бархеста ба баҳр биафтад, сухани гуфтаатон иҷро мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Агар шумо бовар кунед, он гоҳ ҳар чӣ дар дуо талаб кунед, ба даст меоваред». ");
INSERT INTO tgk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Исо ба Хонаи Худо баргашта, машғули таълимдиҳӣ шуд, ки сардорони рӯҳонӣ ва пирони қавм ба наздаш омада пурсиданд: «Ту бо кадом ҳуқуқ чунин корҳоро мекунӣ? Кӣ ба Ту ин ҳаққу ҳуқуқро додааст?» ");
INSERT INTO tgk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Исо ба онҳо гуфт: «Ман ҳам ба шумо як саволе дорам. Агар ба он ҷавоб диҳед, он гоҳ мегӯям, ки бо кадом ҳуқуқ чунин корҳоро мекунам. ");
INSERT INTO tgk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Бигӯед, ба Яҳё кӣ ҳуқуқ дода буд, ки одамонро таъмид диҳад: Худо ё инсон?» Онҳо байни якдигар баҳс карда гуфтанд: «Агар „Худо дода буд“ гӯем, Ӯ мепурсад, ки чаро ба Яҳё бовар накардем. ");
INSERT INTO tgk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Аммо агар „инсон“ гӯем, халқ зидди мо мебарояд, чунки ба пайғамбар будани Яҳё эътиқод дорад». ");
INSERT INTO tgk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Оқибат, онҳо ба Исо «намедонем» гуфта ҷавоб доданд. Ӯ низ ба онҳо гуфт: «Пас, Ман ҳам ба шумо намегӯям, ки бо кадом ҳуқуқ ин корро мекунам». ");
INSERT INTO tgk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Исо суханашро давом дода гуфт: «Дар бораи ин ҳикоя чӣ фикр доред? Марде ду писар доштааст. Рӯзе вай пеши писари калониаш омада мегӯяд: „Писарам, имрӯз ба токзор рафта кор кун“. ");
INSERT INTO tgk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","30","Писараш бошад, „намеравам“ мегӯяд. Баъд падараш рафта, аз писари дуюмаш хоҳиш мекунад. Писари дуюмаш „хуб шудааст“ гуфта ҷавоб медиҳад. Лекин баъдтар писари калонӣ аз фикраш гашта ба токзор меравад. Писари дуюмаш бошад, намеравад». ");
INSERT INTO tgk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Исо аз сардорони рӯҳонӣ ва пирони қавм пурсид: «Инак, кадоме аз писарон хости падарашро иҷро кард?» «Писари калониаш», — ҷавоб доданд онҳо. Исо ба онҳо гуфт: «Ба ростӣ ба шумо мегӯям, ки одамони радди маърака, яъне андозгирон ва фоҳишаҳо пеш аз шумо ба подшоҳии Худо дохил шуда истодаанд. ");
INSERT INTO tgk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Зеро Яҳёи Таъмиддиҳанда ба назди халқамон барои роҳи ростро нишон додан омад, аммо шумо ба ӯ бовар накардед, андозгирон ва фоҳишаҳо бошанд, бовар карданд. Ҳатто баъд аз дидани ҳамаи ин шумо аз фикратон нагаштед ва бовар накардед. ");
INSERT INTO tgk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ба масали дигаре гӯш андозед, — гуфт ӯ. Як заминдор токзор бунёд карда, гирди онро девор мегирад. Барои фишурдани ангур ҳавз мекобад ва дидбонгоҳе месозад. Баъд токзорашро ба чанд нафаре иҷора медиҳаду хонаашро монда ба кишвари дигар сафар мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Бо фаро расидани вақти ҳосилғундорӣ соҳиби токзор барои гирифтани ҳаққи ҳосил хизматгоронашро назди иҷоракорон мефиристад. ");
INSERT INTO tgk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Аммо иҷоракорон хизматгорони ӯро дастгир карда, якеашро мезананд, дигареро мекушанд ва сеюмро сангсор мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Соҳиби токзор аз дафъаи аввал дида бештар хизматгоронашро мефиристад. Аммо иҷоракорон бо онҳо низ ҳамон тавр рафтор мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Оқибат, соҳиби токзор „писарамро ҳатман иззату эҳтиром мекунанд“ гуфта, писарашро назди онҳо мефиристад. ");
INSERT INTO tgk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Лекин иҷоракорон писарро дида, ба якдигар мегӯянд: „Вай меросхӯр аст! Биёед, ӯро мекушем ва ба меросаш соҳиб мешавем!“ ");
INSERT INTO tgk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Бо ин қарор онҳо писарро дастгир мекунанду вайро аз токзор берун бароварда мекушанд». ");
INSERT INTO tgk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Баъд Исо савол дод: «Хӯш, вақте ки худи соҳиби токзор бармегардад, бо ин иҷоракорон чӣ хел рафтор мекунад?» ");
INSERT INTO tgk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Онҳо дар ҷавоб гуфтанд: «Ҳатман он бадонро бераҳмона хоҳад кушт. Токзорро бошад, ба иҷоракорони дигар медиҳад, ки ҳаққи ҳосилашро дар вақташ медиҳанд». ");
INSERT INTO tgk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Исо ба онҳо гуфт: «Магар шумо дар навиштаҷот чунин гуфтаҳоро боре ҳам нахондаед: „Он сангеро, ки бинокорон нодаркор ҳисоб карда, як сӯ партофтанд, санги асосии таҳкурсии бино гардид. Ин кори Худованд аст ва ба назарамон аҷиб менамояд“? ");
INSERT INTO tgk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Бинобар ин, ба шумо мегӯям, ки имконияти аз они подшоҳии Худо будан аз шумо гирифта мешавад ва ба халқҳое дода мешавад, ки хости Худоро иҷро мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ҳар касе, ки ба болои он санг меғалтад, шикаста майда-майда мешавад, вале агар ин санг ба болои касе афтад, вайро маҷақ мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Сардорони рӯҳонӣ ва фарисиён масалҳои Исоро шунида, фаҳмиданд, ки Вай дар бораи онҳо нақл карда истодааст. ");
INSERT INTO tgk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Аз ин рӯ, онҳо кӯшиш карданд, ки Ӯро дастгир намоянд, аммо аз мардуми ҷамъомада метарсиданд, чунки онҳо Исоро пайғамбар ҳисоб мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Исо боз ба сардорони рӯҳонӣ ва пирони қавм рӯ оварда гуфт: ");
INSERT INTO tgk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Подшоҳии Худоро бо чунин масал тасвир кардан мумкин: подшоҳе писарашро хонадор карданӣ шуда, базм барпо мекунад ");
INSERT INTO tgk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ва хизматгоронашро барои даъват кардани меҳмонон мефиристад. Аммо даъватшудагон омадан нахостанд. ");
INSERT INTO tgk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Шоҳ дигар хизматгоронашро фиристода мегӯяд: „Рафта ба даъватшудагон гӯед, ки ба тӯй биёянд, чунки барзагову гӯсолаҳои беҳтарин аллакай кушта шудаанду ҳама чиз барои зиёфат тайёр аст“. ");
INSERT INTO tgk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Лекин даъватшудагон ба суханони хизматгорон эътибор надода, ҳар якеашон бо кори худашон машғул мешаванд: як қисмашон ба саҳроҳои худ мераванд, қисми дигарашон ба дӯконҳои худ, ");
INSERT INTO tgk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","баъзеашон бошанд, хизматгоронро дошта, латукӯб мекунанду мекушанд. ");
INSERT INTO tgk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Шоҳ ба қаҳру ғазаб омада, сарбозонашро назди он одамкушон мефиристад, ки онҳоро нобуд карда шаҳрашонро сӯзонанд. ");
INSERT INTO tgk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ба хизматгоронаш бошад, мегӯяд: „Зиёфати тӯй тайёр аст, аммо ин даъватшудагон садқаи зиёфатам шаванд. ");
INSERT INTO tgk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ҳоло ба кӯчаҳои серодам раведу чӣ қадар бисёртар одамонро ёфта тавонед, ҳамаашонро таклиф кунед“. ");
INSERT INTO tgk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Хизматгорон ба кӯчаҳо рафта, ҳар касеро, ки меёфтанд, баду некро фарқ накарда ба тӯйхона ҷамъ меоварданд. Оқибат тӯйхона пури одам шуд. ");
INSERT INTO tgk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Вақте ки шоҳ барои дидани меҳмонон ба тӯйхона медарояд, чашмаш ба марде меафтад, ки либосаш идона нест. ");
INSERT INTO tgk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","„Эй ҷӯра, — муроҷиат мекунад ба ӯ шоҳ, — чӣ тавр ту ба ин ҷо бе либоси идона даромада омадӣ?“ Вале он мард чӣ гуфтанашро намедонист. ");
INSERT INTO tgk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Он гоҳ шоҳ ба хизматгоронаш фармон дода мегӯяд: „Дасту пои ин мардро баста ба торикии берун партоед, ки дар он ҷо одамон аз дард дандон ба дандон зада гиря мекунанд“». ");
INSERT INTO tgk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Исо суханонашро хотима дода гуфт: «Донед, ки бисёр касон даъват шудаанд, лекин интихобшудагон кам ҳастанд». ");
INSERT INTO tgk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Он гоҳ фарисиён як тараф ҷамъ шуда, нақша кашиданд, ки чӣ тавр Исоро бо сухан ба дом афтонанд. ");
INSERT INTO tgk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Пас, онҳо чанд нафар аз шогирдонашон ва аъзоёни ҳизби ҳиродиёнро назди Ӯ фиристоданд. Фиристодашудагон гуфтанд: «Устод, мо медонем, ки Шумо ростқавл ҳастед ва ба мавқею дараҷаи одамон эътибор надода, бе хушомадгӯӣ роҳҳои Худоро аз рӯи ҳақиқат таълим медиҳед. ");
INSERT INTO tgk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Бигӯед, ба фикри Шумо, оё раво аст, ки мо ба императори Рум андозу хироҷ супорем ё не?» ");
INSERT INTO tgk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Исо, ки аз нияти бади онҳо бохабар буд, ҷавоб дод: «Ҳой, дурӯяҳо! Чаро Маро ба дом афтонданӣ ҳастед?! ");
INSERT INTO tgk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Канӣ, динори андоз месупоридагиро ба Ман оварда нишон диҳед-чӣ!» Онҳо динорро ба Исо нишон доданд ");
INSERT INTO tgk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ва Ӯ пурсид: «Дар он акс ва номи киро мебинед?» ");
INSERT INTO tgk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","«Императорро», — ҷавоб доданд онҳо. Он гоҳ Ӯ ба онҳо гуфт: «Он чи аз они император аст, бояд ба император баргардонда шавад ва он чи аз они Худост, ба Худо». ");
INSERT INTO tgk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Аз шунидани чунин ҷавоб онҳо бениҳоят ҳайрон шуданд ва бо ҳамин ҳолат аз наздаш рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Худи ҳамон рӯз баъзе аз саддуқиён (онҳо аз нав зиндашавиро инкор мекарданд) ба назди Исо омада, ба Вай чунин савол доданд: ");
INSERT INTO tgk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Устод, Мӯсо дар қонун ба мо чунин навиштааст, ки агар касе зан гираду фарзанд надида аз олам гузарад, бародараш бояд зани ӯро ба никоҳи худ дарорад ва фарзандони ба дунё омадаро ҳамчун насли бародари марҳумаш бидонад. ");
INSERT INTO tgk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Инак, бо мо ҳафт бародар буданд ва калониаш зан гирифт, аммо фарзанд надида аз олам чашм пӯшид. Он гоҳ бародари дуюм бевазанро ба никоҳаш даровард. ");
INSERT INTO tgk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Баъд бо бародари дуюм, сеюм ва то ҳафтум бо ҳамаашон айнан ҳамон ҳодиса рӯй дод. ");
INSERT INTO tgk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Оқибат зан ҳам вафот кард. ");
INSERT INTO tgk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Пас, рӯзе, ки мурдаҳо аз нав зинда мешаванд, вай зани кадоме аз ҳафт бародарон мешавад? Охир ҳамаи онҳо ӯро ба занӣ гирифта буданд!» ");
INSERT INTO tgk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Исо дар ҷавоб ба онҳо гуфт: «Шумо хато мекунед, чунки на мазмуни навиштаҷотро медонеду на қудрати Худоро. ");
INSERT INTO tgk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Зеро дар рӯзе, ки мурдаҳо аз нав зинда мешаванд, онҳо зан намегиранду шавҳар намекунанд, балки мисли фариштаҳои осмон мегарданд. ");
INSERT INTO tgk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Дар бораи аз нав зиндашавии мурдагон бошад, магар гуфтаҳои Худоро боре ҳам нахондаед, ки гуфтааст: ");
INSERT INTO tgk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","„Ман Худои Иброҳим, Худои Исҳоқ ва Худои Ёқуб ҳастам“. Ӯ на Худои мурдагон, балки Худои зиндагон аст». ");
INSERT INTO tgk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Мардум ин суханонро шунида аз таълимоти Ӯ дар тааҷҷуб монданд. ");
INSERT INTO tgk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Вақте фарисиён шуниданд, ки Исо саддуқиёнро бо ҷавоби худ забонкӯтоҳ кард, як гурӯҳ шуда омаданд. ");
INSERT INTO tgk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ва қонуншиносе аз байни онҳо барои озмудани Исо чунин савол дод: ");
INSERT INTO tgk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Устод, бигӯед, кадом қонуни шариат дар ҷои аввал меистад?» ");
INSERT INTO tgk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Исо ҷавоб дода гуфт: «Қонуни аввалин ва муҳимтарин чунин мебошад, ки „Худованд Худои худро бояд бо тамоми дилу ҷонамон ва бо тамоми ақлу ҳушамон дӯст бидорем“. ");
INSERT INTO tgk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Дуюмаш ҳам монанди он: „Ҳар шахсеро, ки наздики мост, бояд мисли худ дӯст бидорем“. ");
INSERT INTO tgk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ин ду қонун асоси тамоми шариати Мӯсо ва гуфтаҳои пайғамбарон аст». ");
INSERT INTO tgk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ҳанӯз ки фарисиён ҷамъ буданд, Исо аз онҳо пурсид: ");
INSERT INTO tgk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Шумо дар бораи Масеҳ, яъне Таъиншудаи Худо чӣ ақида доред? Ба фикратон Вай аз насли кист?» «Аз насли шоҳ Довуд», — ҷавоб доданд онҳо. ");
INSERT INTO tgk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ӯ боз пурсид: «Пас, чаро худи Довуд бо таъсири Рӯҳи Муқаддас Ӯро Худованд хондааст? Охир Довуд гуфта буд: ");
INSERT INTO tgk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","„Худованд ба Худованди ман гуфт: «То вақте ки душманонатро зери поят нагузорам, аз дасти ростам бишин»“. ");
INSERT INTO tgk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Агар Довуд Таъиншудаи Худоро „Худованд“ номида бошад, пас чӣ тавр Вай аз насли Довуд шуда метавонад?» ");
INSERT INTO tgk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Касе ба саволи Исо ҷавобе дода натавонист ва аз он лаҳза дигар ҳеҷ кас ҷуръат накард, ки ба Ӯ саволе диҳад. ");
INSERT INTO tgk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Сипас Исо ба мардум ва шогирдонаш гуфт: ");
INSERT INTO tgk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Шариатдонон ва фарисиён барои шарҳ додани шариати Мӯсо ҳақ доранд. ");
INSERT INTO tgk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Он чи онҳо шарҳ медиҳанд, гӯш кунед ва иҷро намоед. Бо вуҷуди ин, ба рафторашон тақлид накунед, чунки худи онҳо гуфтаҳояшонро иҷро намекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Онҳо борҳои гаронеро, ки бардоштанашон вазнин аст, ба дӯши одамон мегузоранд, аммо барои бардошта бурдани онҳо дасти ёрӣ ҳам дароз намекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Кору борашон фақат дар назди мардум худнамоӣ кардан аст. Ана, ба қуттичаҳои оятдори пешониашон нигоҳ кунед, чӣ хел васеанд! Ё ба пӯпакҳои домани либосашон нигоҳ кунед, чӣ хел дарозанд! ");
INSERT INTO tgk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Онҳо дар базмҳо болонишиниро нағз мебинанд ва дар ибодатхонаҳо ба ҷойҳои беҳтарин мешинанд. ");
INSERT INTO tgk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ба онҳо маъқул аст, ки халқ дар бозорҳо бо иззату эҳтиром онҳоро „устод“ гуфта саломашон диҳанд. ");
INSERT INTO tgk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Аммо шуморо набояд унвонҳои „устод“ диҳанд, зеро шумо барои якдигар бародар ҳисоб мешавед ва фақат як устод доред. ");
INSERT INTO tgk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Унвони „падар“-ро низ ба касе дар рӯи замин надиҳед, азбаски фақат як Падар дар осмон доред. ");
INSERT INTO tgk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Шуморо „раис“ ҳам набояд хонанд, чунки Масеҳ раиси яккаву ягонаи шумо аст. ");
INSERT INTO tgk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Каси бузургтарин дар байни шумо бояд хизматгоратон бошад. ");
INSERT INTO tgk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ҳар касе, ки худро калон мегирад, паст мешавад ва баръакс, ҳар касе, ки худро хоксор мегирад, сарбаланд мешавад». ");
INSERT INTO tgk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","«Вой бар ҳоли шумо, шариатдонону фарисиёни дурӯя! Чунки шумо дари подшоҳии Худоро ба рӯи одамон баста, на худатон аз он медароеду на ба дигарон, ки даромадан мехоҳанд, роҳ медиҳед. ");
INSERT INTO tgk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Вой бар ҳоли шумо, шариатдонону фарисиёни дурӯя! Чунки шумо бо баҳру хушкӣ роҳҳои дуру дароз тай менамоед, то ақаллан касеро пайдо кунед, ки ба дини шумо мегузашта бошад. Лекин, вақте ки чунин одамро пайдо мекунед, вайро аз худатон ду маротиба зиёдтар сазовори дӯзах мегардонед. ");
INSERT INTO tgk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Вой бар ҳоли шумо, роҳнамоёни кӯр! Шумо таълим медиҳед, ки агар касе ба Хонаи Худо қавлу қасам хӯрад, қасамаш эътибор надорад, аммо агар ба тиллое, ки дар Хонаи Худо ҳаст, қавлу қасам хӯрад, қавлашро ҳатман бояд иҷро кунад. ");
INSERT INTO tgk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Эй кӯрони беақл! Охир қадри чӣ баландтар аст: тилло ё ин ки Хонаи Худо, ки тиллои дар он бударо муқаддас мегардонад? ");
INSERT INTO tgk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Шумо боз таълим медиҳед, ки агар касе ба қурбонгоҳ қавлу қасам хӯрад, қасамаш эътибор надорад, аммо агар ба қурбонии болои қурбонгоҳбуда қавлу қасам хӯрад, қавлашро ҳатман бояд иҷро кунад. ");
INSERT INTO tgk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Эй кӯрон! Охир чӣ қадри бештаре дорад: қурбонӣ ё қурбонгоҳе, ки қурбониро муқаддас мегардонад? ");
INSERT INTO tgk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Инак, касе ки ба қурбонгоҳ қасам хӯрад, вай ҳам ба қурбонгоҳ ва ҳам ба ҳар қурбоние, ки болои он аст, қасам мехӯрад; ");
INSERT INTO tgk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ва касе ба Хонаи Худо қасам хӯрад, вай ҳам ба Хонаи Худо ва ҳам ба Худо, ки дар он ҷо макон дорад, қасам мехӯрад. ");
INSERT INTO tgk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Инчунин, касе ба осмон қасам хӯрад, вай ба тахти Худо ва ҳам ба касе, ки бар он тахт менишинад, қасам мехӯрад. ");
INSERT INTO tgk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Вой бар ҳоли шумо, шариатдонону фарисиёни дурӯя! Чунки шумо аз ҳосили зираву шибиту пудина ҳиссаи даҳумро месупоред, аммо таълимоти муҳимтарини шариатро дар бораи нишон додани адолат, раҳм ва вафодорӣ пурра риоя намекунед. Шумо мебоист ин қонунҳоро риоя мекардеду қонунҳои дигарро низ беэътибор намемондед. ");
INSERT INTO tgk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Эй роҳнамоёни кӯр! Шумо нӯшокиатонро аз дока мегузаронед, ки мабодо магас дар дарунаш набошад, аммо шутурро фурӯ мебаред. ");
INSERT INTO tgk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Вой бар ҳоли шумо, шариатдонону фарисиёни дурӯя! Чунки шумо беруни косаву пиёларо мешӯеду дарунашон бошад, аз он чизҳое, ки шумо бо зулму чашмгуруснагӣ ба даст овардаед, пур аст. ");
INSERT INTO tgk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Эй фарисиёни кӯр! Аввал даруни косаро аз ифлосӣ тоза кунед, он гоҳ беруни он ҳам тоза мешавад! ");
INSERT INTO tgk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Вой бар ҳоли шумо, шариатдонон ва фарисиёни дурӯя! Чунки шумо мисли мақбараҳои сафедкардашуда ҳастед, ки аз берун намуди хуб доранд, аммо дарунашон пур аз устухонҳои мурдаҳо ва ҳар гуна ифлосиҳост. ");
INSERT INTO tgk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Айнан ҳамин тавр намуди зоҳири шумо низ дар назари одамон ба накӯкорон монанд аст, аммо дарунатон пур аз дурӯягиву гуноҳ мебошад. ");
INSERT INTO tgk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Вой бар ҳоли шумо, шариатдонону фарисиёни дурӯя! Чунки шумо барои пайғамбарон ва накӯкорон мақбараҳои зебо сохта онҳоро оро медиҳед. ");
INSERT INTO tgk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Боз мегӯед, ки агар дар замонҳои аҷдодонатон зиндагӣ мекардед, ҳаргиз ҳамроҳи онҳо ба хунрезии пайғамбарон даст намезадед. ");
INSERT INTO tgk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Бо ин суханонатон бар зидди худ шаҳодат медиҳед, ки шумо дар ҳақиқат фарзандони ҳамон кушандагони пайғамбарон ҳастед. ");
INSERT INTO tgk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Хӯш, кори сар кардаи аҷдодонатонро ҳоло шумо ба охир расонед! ");
INSERT INTO tgk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Эй морон ва морзодагони маккор! Наход гумон кунед, ки аз ҳукми ба дӯзах рафтан халосӣ ёфта метавонед? ");
INSERT INTO tgk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Инак, ба шумо мегӯям, ки ба наздатон пайғамбарону ҳакимону муаллимонро мефиристам ва шумо баъзеи онҳоро мекушеду баъзеашонро ба салиб мехкӯб мекунед, баъзеашонро дар ибодатхонаҳои худ қамчинкорӣ карда, шаҳр ба шаҳр дунболагирӣ мекунед. ");
INSERT INTO tgk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ман онҳоро барои он мефиристам, ки ҷавобгарии марги ҳамаи одамони бегуноҳ, аз Ҳобили беайб сар карда то Закарёи писари Баракё, ки байни муқаддастарин ҷои Хонаи Худо ва қурбонгоҳ кушта шуда буд, ба гардани шумо афтад. ");
INSERT INTO tgk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ба ростӣ ба шумо мегӯям, ин насл барои ҳамаи ин кушторҳо ҷазо мебинад!» ");
INSERT INTO tgk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Исо суханонашро давом дода гуфт: «Эй Ерусалим, Ерусалим! Пайғамбаронро мекушиву онҳоеро, ки Худо ба наздат мефиристад, сангсор мекунӣ! Ман борҳо орзу доштам, мисли мурғе, ки чӯҷаҳояшро зери болҳояш ҷамъ мекунад, сокинонатро дар гирди худ ҷамъ оварам, вале ту роҳ надодӣ! ");
INSERT INTO tgk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Акнун Хонаи Худо дар ту холӣ ва бепарастор мемонад. ");
INSERT INTO tgk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ҳоло ба шумо мегӯям, ки минбаъд то „Баракат ёбад касе, ки аз номи Худованд меояд!“ нагӯед, Маро нахоҳед дид». ");
INSERT INTO tgk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Исо Хонаи Худоро тарк карда, ба роҳ баромада буд, ки шогирдонаш ба наздаш омаданду диққаташро ба биноҳои Хонаи Худо ҷалб карданӣ шуданд. ");
INSERT INTO tgk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ӯ ба онҳо гуфт: «Шумо ҳоло ин биноҳоро мебинед? Ба ростӣ ба шумо мегӯям, ки санг бар болои сангаш намонда, ҳамааш ба замин яксон мешавад». ");
INSERT INTO tgk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ҳангоме ки Исо ба теппаи Зайтун баромада нишаст, шогирдонаш дар танҳоӣ ба пеши Ӯ омада пурсиданд: «Ба мо бигӯед, ки ин ҳодиса кай рӯй медиҳад ва омадани Шумову наздикшавии охирзамонро аз кадом нишона мефаҳмем?» ");
INSERT INTO tgk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Исо дар ҷавоб ба онҳо гуфт: «Эҳтиёт шавед, ки мабодо касе шуморо гумроҳ накунад. ");
INSERT INTO tgk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Зеро бисёр касоне пайдо мешаванд, ки гӯё аз номи Ман омада бошанду „Ман Таъиншудаи Худо“ мегӯянд ва бисёр одамонро гумроҳ мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Шумо садоҳо ва овозаҳои ҷангҳоро мешунавед, лекин ба воҳима наафтед. Чунин ҳодисаҳо бояд рӯй диҳанд, вале ин маънои фаро расидани охирзамонро надорад. ");
INSERT INTO tgk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Як халқ бо халқи дигар ҷанг мекунад ва як давлат ба давлати дигар ҳуҷум мекунад. Дар ҳар ҷо қаҳтию гуруснагӣ ба амал меояд ва заминҷунбиҳо рӯй медиҳанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ҳамаи ин ҳодисаҳо монанди саршавии дарди зоидан мебошанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Баъд шуморо дастгир карда, азоб медиҳанд ва ҳатто ба дасти марг месупоранд. Ба сабаби Маро пайравӣ карданатон ҳамаи халқҳо ба шумо бо чашми нафрат нигоҳ мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Он гоҳ бисёр касон имонашонро аз даст медиҳанду ба якдигар хиёнат мекунанд ва якдигарро бад мебинанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Дар он айём пайғамбарони бардурӯғи зиёд пайдо мешаванд ва бисёр касонро гумроҳ мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Бадиву разилӣ то андозае меафзояд, ки дар дили бисёр одамон муҳаббат намемонад. ");
INSERT INTO tgk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Вале касе, ки то ба охир истодагарӣ намояд, наҷот хоҳад ёфт. ");
INSERT INTO tgk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ин хушхабар дар бораи подшоҳии Худо бошад, дар саросари дунё эълон карда мешавад, то ки ҳар халқ имконияти шунидани онро пайдо кунад. Танҳо баъд аз ин охирзамон меояд. ");
INSERT INTO tgk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Шумо дар ҷои муқаддас ҳамон „ифлосиҳоеро, ки Хонаи Худоро ҳаром мекунанд“ ва Дониёл пайғамбар дар бораашон пешгӯӣ карда буд, мебинед». (Бигзор хонанда бифаҳмад, ки ин чӣ маъно дорад). ");
INSERT INTO tgk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","«Он вақт, агар касе дар Яҳудия бошад, ба кӯҳистон гурезад. ");
INSERT INTO tgk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Агар касе дар болои бом бошад, барои гирифтани чизе аз хона поён нафарояд. ");
INSERT INTO tgk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Агар касе дар саҳро бошад, ҳатто барои гирифтани ҷома ҳам барнагардад. ");
INSERT INTO tgk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Вой бар ҳоли заноне, ки он рӯзҳо ҳомиладор хоҳанд буд ва модароне, ки кӯдаки ширхор хоҳанд дошт! ");
INSERT INTO tgk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Дуо кунед, ки гурехтани шумо ба зимистон ё рӯзи истироҳат рост наояд. ");
INSERT INTO tgk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Зеро азобу даҳшати он айём ба дараҷае мерасад, ки аз рӯзи офариниши дунё то ба имрӯз монанди он ҳеҷ рӯй надодааст ва дигар рӯй нахоҳад дод. ");
INSERT INTO tgk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Аммо Худо он рӯзҳои азобро кӯтоҳ кардааст, чунки агар кӯтоҳ намекард, дар рӯи замин касе зинда намемонд. Ба хотири интихобкардагонаш Худо он рӯзҳоро ҳатман кӯтоҳ хоҳад кард. ");
INSERT INTO tgk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Пас, агар касе ба шумо гӯяд, ки „Бинед, ана Таъиншудаи Худо дар ин ҷост!“ ё „Ӯ ана дар он ҷост!“, бовар накунед. ");
INSERT INTO tgk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Зеро одамоне пайдо мешаванд, ки худро Таъиншудаи Худо ва пайғамбар меноманд, аммо дар асл чунин нестанд. Онҳо ба фиреб додани ҳама ва ҳатто одамоне, ки Худо барои худ интихоб кардааст, кӯшиш карда, мӯъҷизаҳои аҷоибу ғароиб нишон медиҳанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ана, Ман пешакӣ шуморо огоҳ карда мондам. ");
INSERT INTO tgk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Агар одамон ба шумо гӯянд, ки „Бинед, Масеҳ дар биёбон аст!“, ба он ҷо наравед. Ё агар гӯянд, ки „Бинед, Вай дар ҷои пинҳонӣ аст!“, бовар накунед. ");
INSERT INTO tgk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Чунки омадани Фарзанди Инсон мисли дурахши барқе мешавад, ки тамоми осмонро аз шарқ то ба ғарб фаро мегирад. ");
INSERT INTO tgk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ҷои ҷасади мурда аз он маълум аст, ки паррандаҳои лошахӯр он ҷо гирд меоянд. ");
INSERT INTO tgk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Баъд аз азобу даҳшати он рӯзҳо фавран офтоб тира мегардад ва моҳ дигар равшанӣ намедиҳад, ситораҳо аз осмон поён меафтанд ва ҳама чиз дар осмон ба ҷунбиш меояд. ");
INSERT INTO tgk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Он вақт нишонаи омадани Фарзанди Инсон дар осмон намоён мегардад ва дар болои абр бо қудрат ва шӯҳрату ҷалол омадани Ӯро ҳамаи одамони рӯи замин дида гиряву нола мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Фарзанди Инсон фариштаҳои худро бо садои баланди карнай барои аз ҳар гӯшаву канори дунё ҷамъ кардани интихобкардагонаш мефиристад. ");
INSERT INTO tgk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Аз дарахти анҷир ибрат гиред. Ҳамин ки шохаҳояш муғча карда барг бароварданро сар кунанд, шумо аниқ медонед, ки ба қарибӣ тобистон меояд. ");
INSERT INTO tgk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Айнан ҳамин тавр, ҳангоме ки ба амал омадани ин ҳодисаҳоро мебинед, донед, ки вақт наздик, дар дами остона аст. ");
INSERT INTO tgk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ба ростӣ ба шумо мегӯям, ки ҳанӯз одамони ин насл аз олам нагузашта, ҳамаи ин ҳодисаҳо ба амал меоянд. ");
INSERT INTO tgk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Замину осмон нест мешаванд, аммо гуфтаҳои Ман то абад мемонанд. ");
INSERT INTO tgk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Лекин кай фаро расидани он рӯзу соатро ғайр аз Падар касе намедонад: на фариштаҳои осмон на Писар. ");
INSERT INTO tgk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ҳангоми омадани Фарзанди Инсон бошад, айнан ҳамон воқеае рӯй медиҳад, ки дар замони Нӯҳ пайғамбар рӯй дода буд. ");
INSERT INTO tgk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Дар он рӯзҳо ҳам пеш аз саршавии тӯфон ва обхезӣ одамон мехӯрданду менӯшиданд, зан мегирифтанду ба шавҳар мебаромаданд. То он рӯзе, ки Нӯҳ ба киштӣ даромад, ҳамин тавр давом медод. ");
INSERT INTO tgk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Баъд аз он ҳам одамон аз дунё бехабар буданд, то даме ки тӯфон сар шуду об ҳамаи онҳоро несту нобуд кард. Ҳангоми омадани Фарзанди Инсон низ чунин ҳодиса рӯй медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Он вақт ду кас дар саҳро кор мекунанд ва якеаш гирифта мешаваду дигараш мемонад. ");
INSERT INTO tgk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ду зан дар осиёб гандум орд мекунанд ва якеаш гирифта мешаваду дигараш мемонад. ");
INSERT INTO tgk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Пас, ҳушёр бошед, чунки рӯзи омадани Худовандатонро намедонед. ");
INSERT INTO tgk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Бидонед, ки агар соҳибхона вақти омадани дуздро донад, вай тамоми шаб бедор меистад ва намегузорад, ки дузд ба хонааш зада дарояд. ");
INSERT INTO tgk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Аз ин рӯ, шумо низ бояд ба омадани Фарзанди Инсон ҳамеша тайёр бошед, чунки Вай соате меояд, ки шумо мунтазираш нестед. ");
INSERT INTO tgk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Хизматгори бовафо ва дурандеш кист? Касест, ки соҳибаш ӯро дар хоҷагии худ назоратчӣ таъин мекунад ва ба хизматгорон дар вақташ тақсим карда додани хӯрокро ба ӯҳдааш мегузорад. ");
INSERT INTO tgk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Хушо хизматгоре, ки ӯро соҳибаш ҳангоми баргаштан дар сари иҷрои вазифааш меёбад. ");
INSERT INTO tgk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ба ростӣ ба шумо мегӯям, ки соҳибаш вайро бар тамоми молу мулкаш назоратчӣ таъин менамояд. ");
INSERT INTO tgk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Аммо агар вай хизматгори бад бошад, фикр мекунад, ки соҳибаш дер меояд ва ");
INSERT INTO tgk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","хизматгорони дигарро латукӯб карда, ҳамроҳи майзадаҳо машғули хӯрдану нӯшидан мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ана, дар вақту соате, ки хизматгор аз он бехабару мунтазираш нест, соҳибаш баргашта, ");
INSERT INTO tgk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ин хизматгорро ду пора мекунад ва вай ба ҷое, ки дурӯяҳо аз дард дандон ба дандон зада гиря мекунанд, партофта мешавад». ");
INSERT INTO tgk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Исо суханашро давом дода гуфт: «Подшоҳии Худоро чунин тасвир кардан мумкин: даҳ духтар чароғ ба даст гирифта, ба пешвози домод мебароянд. ");
INSERT INTO tgk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Панҷ нафари онҳо кӯтоҳандеш буданд, чунки дар вақти гирифтани чароғҳояшон равғани иловагӣ намегиранд. Аммо панҷ нафари дигарашон дурандеш буданду дар зарфҳо барои чароғҳояшон боз равғани иловагӣ мегиранд. ");
INSERT INTO tgk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Онҳо домодро мунтазир мешаванд, вале ӯ хеле дер мекунад ва духтарон пинак рафта, оқибат хобашон мебарад. ");
INSERT INTO tgk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Нисфи шаб садои баланд шунида мешавад: „Ана домод омада истодааст! Ӯро пешвоз гиред!“ ");
INSERT INTO tgk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Духтарон бедор шуда, зуд чароғҳояшонро тайёр мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Он гоҳ кӯтоҳандешон ба дурандешон мегӯянд: „Аз равғанатон камтар диҳед, вагарна чароғҳоямон хомӯш мешаванд“. ");
INSERT INTO tgk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","„Не, — ҷавоб медиҳанд дурандешон, — ин равған ба ҳамаамон намерасад. Беҳтараш рафта, аз дӯкон харида биёед“. ");
INSERT INTO tgk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Кӯтоҳандешон барои харидани равған сӯи дӯкон равона мешаванд. Онҳо рафтан замон домод ҳам расида меояд. Панҷ духтаре, ки ба пешвозаш тайёр буданд, ҳамроҳи домод ба тӯйхона медароянд ва дарҳои тӯйхона баста мешаванд. ");
INSERT INTO tgk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Дертар он панҷтои боқимонда ҳам расида меоянд ва дод мезананд: „Хоҷа, эй хоҷа! Дарҳоро бароямон кушоед!“ ");
INSERT INTO tgk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Аммо ӯ дар ҷавоб ба онҳо мегӯяд: „Ба ростӣ мегӯям, ки шуморо намешиносам“. ");
INSERT INTO tgk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Хуллас, — гуфт Исо, — ҳушёру бедор бошед, чунки вақту соати омадани Фарзанди Инсонро намедонед. ");
INSERT INTO tgk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Дар вақти подшоҳии Худо ҳодисае рӯй медиҳад, ки монанди ин масал аст: марде ба сафар баромаданӣ шуда хизматгоронашро ба наздаш даъват мекунад ва масъулияти идора кардани тамоми молу мулкашро ба ӯҳдаи онҳо мегузорад. ");
INSERT INTO tgk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Инчунин, ба ҳар хизматгор мувофиқи қобилияташ тангаҳои тилло медиҳад: ба якеаш панҷ ҳазор, ба дуюмаш ду ҳазор ва ба сеюмаш ҳазор танга. Баъд роҳи сафарро пеш мегирад. ");
INSERT INTO tgk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Хизматгоре, ки панҷ ҳазор танга гирифта буд, онҳоро зуд ба муомилот медарораду аз он панҷ ҳазори дигар фоида мебинад. ");
INSERT INTO tgk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Хизматгоре, ки ду ҳазор танга гирифта буд, низ ҳамин тавр амал карда боз ду ҳазори дигар фоида мебинад. ");
INSERT INTO tgk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Аммо хизматгоре, ки ҳазор танга гирифта буд, рафта чоҳе меканаду тангаҳои хоҷаашро дар ҳамон ҷо пинҳон мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Баъд аз гузаштани вақти зиёд хоҷаи он хизматгорон баргашта бо онҳо ҳисобу китоб мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Хизматгоре, ки панҷ ҳазор танга гирифта буд, омада ба хоҷааш тангаҳоро бо панҷ ҳазор фоидааш супорида мегӯяд: „Хоҷаам, шумо ба ман панҷ ҳазор тангаи тилло дода будед. Ана дар ин ҷо боз панҷ ҳазор фоидае, ки ба даст овардам“. ");
INSERT INTO tgk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","„Офарин, хизматгори неку вафодорам, — таъриф мекунад ӯро хоҷааш. — Ту дар иҷрои вазифаи хурд вафодориатро нишон додӣ, пас ба ту вазифаи калонро боварӣ мекунам. Биё, ба хурсандии ман шарик шав!“ ");
INSERT INTO tgk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Инчунин хизматгоре, ки ду ҳазор танга гирифта буд, даромада мегӯяд: „Хоҷаам, шумо ба ман ду ҳазор тангаи тилло дода будед. Ана дар ин ҷо боз ду ҳазор фоидае, ки ба даст овардам“. ");
INSERT INTO tgk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","„Офарин, хизматгори неку вафодорам, — таъриф мекунад ӯро хоҷааш. — Ту дар иҷрои вазифаи хурд вафодориатро нишон додӣ, пас ба ту вазифаи калонро боварӣ мекунам. Биё, ба хурсандии ман шарик шав!“ ");
INSERT INTO tgk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Он хизматгоре, ки ҳазор танга гирифта буд, низ ба пеш баромада мегӯяд: „Хоҷаам, ман медонистам, ки шумо одами сахтгир ҳастед; аз он ҷое, ки накоштаед, ҳосил ҷамъ мекунеду аз он ҷое, ки дон напошидаед, ғалла мегиред. ");
INSERT INTO tgk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ман аз тарс рафта тангаҳоятонро дар замин пинҳон кардам. Ана он пули шумо додагӣ“. ");
INSERT INTO tgk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","„Ту хизматгори баду танбал будаӣ! — ҷавоб медиҳад хоҷааш. — Ту медонистӣ, ки ман аз он ҷое, ки накоштаам, ҳосил ҷамъ мекунаму аз он ҷое, ки дон напошидаам, ғалла мегирам, ҳамин тавр не? ");
INSERT INTO tgk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Пас, ту бояд пули маро ба муомилот медодӣ ва ман ҳангоми баргаштанам пуламро бо фоидааш мегирифтам. ");
INSERT INTO tgk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ҳоло пулро аз вай гирифта ба хизматгоре диҳед, ки даҳ ҳазор танга дорад. ");
INSERT INTO tgk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Зеро ба ҳар касе, ки чизе дорад, боз ҳам ва аз ҳад зиёдтар дода мешавад. Лекин аз касе, ки ҳеҷ чиз надорад, ҳатто он чизи андаке, ки дорад, гирифта мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ин хизматгори нобакорро бошад, ба торикии берун партоед, ки дар он ҷо одамон аз дард дандон ба дандон зада гиря мекунанд“. ");
INSERT INTO tgk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Вақте ки Фарзанди Инсон ҳамчун Шоҳ ҳамроҳи ҳамаи фариштаҳо меояд, Ӯ бар тахти шоҳонаи худ мешинад ");
INSERT INTO tgk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ва ҳамаи халқиятҳои рӯи замин дар пеши Ӯ ҷамъ меоянд. Он гоҳ Вай мисли чӯпоне, ки гӯсфандонро аз бузҳо ҷудо мекарда бошад, одамонро ба ду тараф тақсим мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Одамони накӯкорро Вай аз тарафи дасти росташ мегузораду боқимондаҳоро аз тарафи дасти чапаш. ");
INSERT INTO tgk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Баъд Шоҳ ба одамони дар тарафи росташ буда мегӯяд: „Хуш омадед, шумо, ки Падарам баракат додааст! Омада дар подшоҳии Худо, ки аз вақти офариниш бароятон насиб гардидааст, баҳраву ҳаловат баред. ");
INSERT INTO tgk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Чунки вақте гурусна будам, ба Ман хӯрок додед, ташна будам, нӯшокӣ додед, бегона будам, Маро дар хонаатон меҳмон кардед, ");
INSERT INTO tgk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","бараҳна будам, ба Ман либос пӯшондед, бемор будам, ба Ман ғамхорӣ кардед ва дар ҳабс будам, Маро хабар гирифтед“. ");
INSERT INTO tgk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Накӯкорон бошанд, аз Ӯ мепурсанд: „Худованд, кай мо Туро гуруснаву ташна дида будем, ки бароят хӯроку нӯшокӣ дода бошем? ");
INSERT INTO tgk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ё кай Туро бегонаву бараҳна дида будем, ки меҳмон карда ба Ту либос пӯшонда бошем? ");
INSERT INTO tgk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Кай Туро бемор ё дар ҳабс дида будем, ки хабар гирифта бошем?“ ");
INSERT INTO tgk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Шоҳ ҷавоб медиҳад: „Ба ростӣ ба шумо мегӯям, ҳар дафъае, ки шумо ҳамаи инро ба яке аз одамони хурдтарини Ман мекардед, шумо инро ба Ман мекардед!“ ");
INSERT INTO tgk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Сипас ба одамони дар тарафи чапаш буда мегӯяд: „Дафъ шавед аз пеши назарам, лаънатиҳо! Гум шавед ба оташи абадие, ки барои иблис ва фариштаҳои вай тайёр шуда буд! ");
INSERT INTO tgk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Чунки вақте гурусна будам, хӯроке надодед, ташна будам, нӯшокӣ надодед, ");
INSERT INTO tgk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","бегона будам, дар хонаатон меҳмон накардед, бараҳна будам, ба Ман либос напӯшондед, бемор ва дар ҳабс будам, Маро хабар нагирифтед“. ");
INSERT INTO tgk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Он гоҳ онҳо ҳам мепурсанд: „Худованд, мо кай Туро гуруснаву ташна, бегонаву бараҳна ё бемору дар ҳабсхона дида будем, ки хизмат накарда бошем?“ ");
INSERT INTO tgk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Шоҳ ба онҳо ҷавоб медиҳад: „Ба ростӣ ба шумо мегӯям, ҳар дафъае, ки шумо ҳамаи инро ба яке аз одамони хурдтарини Ман намекардед, пас гӯё барои Ман накардаед“. ");
INSERT INTO tgk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ниҳоят, ин одамон ба ҷое меафтанд, ки то абад ҷазо мебинанд, аммо накӯкорон соҳиби ҳаёти абадӣ мешаванд». ");
INSERT INTO tgk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Исо таълим додани ҳамаи ин чизҳоро ба охир расонда, ба шогирдонаш гуфт: ");
INSERT INTO tgk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Чунон ки медонед, баъд аз ду рӯз ҷашнгирии рӯзи Балогардон сар мешавад. Он вақт Фарзанди Инсон ба дасти душманонаш таслим карда мешаваду Ӯро ба салиб мехкӯб мекунанд». ");
INSERT INTO tgk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Он гоҳ дар қасри Қаёфо ном сарвари рӯҳониён сардорони рӯҳонӣ ва пирони қавм ҷамъ омаданд. ");
INSERT INTO tgk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Онҳо нақша кашиданд, ки бо ҳила Исоро дастгир мекунанду Ӯро ба қатл мерасонанд. ");
INSERT INTO tgk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Аммо қарор карданд, ки ин корашонро дар рӯзҳои ид накунанд, чунки халқ шӯриш бардоштанаш мумкин буд. ");
INSERT INTO tgk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Исо он вақт дар деҳаи Байт-Ҳинӣ, дар хонаи Шимъӯн ном марде, ки пештар махав буд, меҳмон шуд. ");
INSERT INTO tgk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ҳангоми таомхӯрӣ ба назди Ӯ зане омад, ки дар даст як кӯзачаи сангини гаронбаҳои пур аз атри қиматбаҳо дошт. Вай он атрро ба сари Исо рехт. ");
INSERT INTO tgk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Шогирдон аз ин кори зан ба ғазаб омада гуфтанд: «Ин чӣ исрофкорист?! ");
INSERT INTO tgk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Охир ин атрро ба нархи қимат фурӯхта, пулашро ба камбағалон тақсим кардан мумкин буд!» ");
INSERT INTO tgk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Аммо Исо, ки аз суханони онҳо бохабар буд, гуфт: «Чаро ин занро ташвиш медиҳед? Ӯ бароям кори калон кард. ");
INSERT INTO tgk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Камбағалон ҳамеша бо шумо ҳастанд, вале Ман бо шумо ҳамеша намемонам. ");
INSERT INTO tgk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ин зан атрро ба танам рехта Маро ба гӯронидан тайёр кард. ");
INSERT INTO tgk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Хӯш, ба ростӣ ба шумо мегӯям, дар ҳар гӯшаву канори дунё, ки хушхабар эълон карда мешавад, кори кардаи ин занро барои ба ёд овардани ӯ нақл хоҳанд кард». ");
INSERT INTO tgk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Яке аз шогирдони Исо, ки Яҳудои Исқарют ном дошт, назди сардорони рӯҳонӣ рафта ");
INSERT INTO tgk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","пурсид: «Агар Исоро ба шумо таслим кунам, ба ман чӣ медиҳед?» Онҳо ба Яҳудо сӣ тангаи нуқра шумурда доданд. ");
INSERT INTO tgk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Аз ҳамон лаҳза сар карда, Яҳудо барои таслим кардани Исо фурсати қулай меҷуст. ");
INSERT INTO tgk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Рӯзи аввали иди Фатир шогирдони Исо ба наздаш омада пурсиданд: «Дар куҷо мехоҳед, ки бароятон дастархони иди Балогардонро тайёр намоем?» ");
INSERT INTO tgk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ӯ ба онҳо гуфт, ки ба шаҳр, назди фалон кас рафта гӯянд: «Устодамон мегӯяд, ки вақту соати Ӯ наздик омадааст ва Ӯ бо мо, шогирдонаш дар хонаи шумо иди Балогардонро қайд мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Шогирдон ҳамаи гуфтаҳои Исоро иҷро карда хӯроки иди Балогардонро тайёр намуданд. ");
INSERT INTO tgk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Бегоҳӣ Исо бо дувоздаҳ шогирдаш сари дастархон нишасту ");
INSERT INTO tgk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ҳангоми таомхӯрӣ гуфт: «Ба ростӣ ба шумо мегӯям, ки яке аз шумо ба Ман хиёнат мекунад». ");
INSERT INTO tgk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Шогирдонаш хеле ғамгин шуда, пайдарҳам ба пурсидан даромаданд: «Худованд, мабодо ин ман набошам?» ");
INSERT INTO tgk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ӯ дар ҷавоб гуфт: «Касе, ки луқмаашро ҳамроҳи Ман ба як коса тар мекунад, ба Ман хиёнат мекунад. ");
INSERT INTO tgk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Бо Фарзанди Инсон он чӣ дар навиштаҷот дар борааш навишта шудааст, рӯй медиҳад. Аммо вой бар ҳоли он касе, ки ба Фарзанди Инсон хиёнат мекунад. Барои вай беҳтар мешуд, ки ҳаргиз ба дунё наояд!» ");
INSERT INTO tgk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Яҳудои хиёнаткор ба сухан даромада гуфт: «Мабодо ман набошам, устод?» Исо дар ҷавоб гуфт: «Худат ҳамин тавр гуфтӣ». ");
INSERT INTO tgk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Онҳо хӯрдани хӯрокро давом медоданд, ки Исо нонро ба даст гирифта, шукргӯён баракат талабид. Баъд онро пора карда ба шогирдонаш тақсим намуду гуфт: «Нонро бигиреду бихӯред, ки ин бадани Ман аст». ");
INSERT INTO tgk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Пас косаро гирифта, шукри Худо карду онро ба шогирдонаш дода гуфт: «Ҳамаи шумо аз ин коса бинӯшед. ");
INSERT INTO tgk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ин хуни Ман аст, ки бо он Худо бо халқ аҳду паймон мебандад ва он барои бахшида шудани гуноҳҳои одамони зиёде рехта мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ба шумо мегӯям, акнун Ман аз меваи нави токи ангур ҳамроҳи шумо фақат дар подшоҳии Падарам хоҳам нӯшид, лекин то он рӯз ҳаргиз наменӯшам». ");
INSERT INTO tgk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Сипас онҳо Худоро ҳамду саногӯён ба теппаи Зайтун равона шуданд. ");
INSERT INTO tgk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Баъд Исо ба шогирдон гуфт: «Имшаб аз барои ҳодисае, ки бо Ман рӯй медиҳад, ҳамаи шумо пайравӣ кардани Маро бас мекунед, чунки дар навиштаҷот пешгӯйии Худо омадааст: „Чӯпонро мекушам ва гӯсфандони рама пароканда мешаванд“. ");
INSERT INTO tgk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Аммо, вақте ки аз нав зинда мешавам, пеш аз он ки шумо ба вилояти Ҷалил биравед, Ман ба он ҷо меравам». ");
INSERT INTO tgk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Петрус ба Вай эълон карда гуфт: «Агар аз барои ҳодисае, ки бо Шумо рӯй медиҳад, ҳама пайрави кардани Шуморо бас кунад ҳам, ман ҳаргиз ин корро намекунам». ");
INSERT INTO tgk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Исо ба ӯ гуфт: «Ба ростӣ ба ту мегӯям, худи имшаб, ҳанӯз хурӯс ҷеғ назада, ту се бор Маро инкор мекунӣ». ");
INSERT INTO tgk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Аммо Петрус гуфт: «Не, ҳатто агар бо Шумо мурданам лозим ояд, ҳаргиз инкор намекунам». Шогирдони дигар низ айнан ҳамин чизро гуфтанд. ");
INSERT INTO tgk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Исо ва шогирдонаш ба ҷое рафтанд, ки Ҷатсамон ном дошт ва Ӯ ба онҳо гуфт: «Шумо дар ҳамин ҷо бошед, Ман он сӯтар рафта дуо мекунам». ");
INSERT INTO tgk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Вай ҳамроҳаш Петрус ва ду писари Забдойро бурд. Дарду аламаш шиддат меёфт ва ");
INSERT INTO tgk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ӯ ба онҳо гуфт: «Аз шиддати ғаму ғусса ҷонам ба лаб расидааст. Ин ҷо бимонеду ҳамроҳи Ман бедор бошед». ");
INSERT INTO tgk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Инро гуфта Исо каме дуртар рафт ва худро рӯи замин партофта дуо кард: «Падарҷонам, агар илоҷе бошад, бигзор ин косаи азоб аз сари Ман дур шавад! Лекин бигзор на хости Ман, балки хости Ту иҷро шавад». ");
INSERT INTO tgk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Баъд Ӯ ба назди он се шогирдаш баргашта дид, ки онҳо хобидаанд. Он гоҳ ба Петрус гуфт: «Чӣ шумо ақаллан як соат ҳамроҳи Ман бедор истода натавонистед? ");
INSERT INTO tgk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ҳоло бедор бошеду дуо кунед, то ки ба васваса наафтед. Чунки рӯҳатон ба ин тайёр аст, аммо табиати инсониатон нотавон». ");
INSERT INTO tgk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Бори дигар Вай каме дуртар рафта дуо кард: «Падарҷонам, агар ғайр аз косаи азобро нӯшидан бароям дигар илоҷе набошад, пас, бигзор иродаи Ту иҷро шавад». ");
INSERT INTO tgk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Баъд баргашта омаду онҳоро боз дар хоб дид, чунки онҳо ҳатто чашмонашонро кушода наметавонистанд. ");
INSERT INTO tgk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Бори сеюм Вай онҳоро монда рафту айнан мисли пештара дуо кард. ");
INSERT INTO tgk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Сипас назди шогирдонаш баргашта гуфт: «Шумо ҳанӯз хоб рафта дам мегиред? Ана вақту соати он ҳам расид, ки Фарзанди Инсон ба дасти гунаҳкорон таслим карда мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Биёед, бархезед, меравем. Нигоҳ кунед, ана таслимкунандаи Ман ҳам наздик омад». ");
INSERT INTO tgk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ҳанӯз Ӯ суханашро тамом накарда, Яҳудо, яке аз дувоздаҳ шогирдаш ҳамроҳи як тӯдаи калони одамони чӯбу шамшер дар даст аз ҷониби сардорони рӯҳонӣ ва пирони қавм расида омад. ");
INSERT INTO tgk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Инак, хиёнаткор ба онҳо пешакӣ чунин шарт карда буд: «Бидонед, касеро, ки бӯсидам, ҳамон шахсест, ки бояд дастгир кунед». ");
INSERT INTO tgk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Яҳудо рост пеши Исо омада «Салом, устод» гӯён Ӯро бӯсид. ");
INSERT INTO tgk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Исо ба вай гуфт: «Ҷӯра, мақсадатро иҷро намо!» Он гоҳ он одамон Исоро дастгир карда дасту пояшро бастанд. ");
INSERT INTO tgk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ногаҳон яке аз ҳамроҳони Исо шамшерашро аз ғилоф кашида ба ғуломи сарвари рӯҳониён ҳамла оварду гӯшашро бурида партофт. ");
INSERT INTO tgk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Исо ба вай гуфт: «Шамшератро ба ҷояш гузор, чунки ҳар касе, ки шамшер ба даст мегирад, аз теғи шамшер мемирад. ");
INSERT INTO tgk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ё ба фикрат Ман аз Падарам мадад талаб карда наметавонам? Агар талаб кунам, Вай дарҳол зиёдтар аз дувоздаҳ лашкари фариштагонро мефиристад. ");
INSERT INTO tgk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Лекин гуфтаҳои навиштаҷот он гоҳ чӣ хел иҷро мешаванд, охир гуфта шудааст, ки ҳамааш ҳамин тавр бояд рӯй диҳад?» ");
INSERT INTO tgk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Баъд Исо ба он тӯдаи одамон гуфт: «Шумо магар Маро роҳзан гумон мебаред, ки барои дастгир карданам бо таёқу шамшерҳо омадаед? Ман ҳар рӯз дар Хонаи Худо нишаста таълим медодам, аммо шумо Маро дастгир намекардед. ");
INSERT INTO tgk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Вале ҳамаи ин ҳодисаҳо барои он рӯй доданд, ки пешгӯиҳои пайғамбарон, ки дар навиштаҷот омадаанд, иҷро шаванд». Он вақт ҳамаи шогирдонаш Ӯро танҳо монда гурехтанд. ");
INSERT INTO tgk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Сипас онҳое, ки Исоро дастгир карданд, Ӯро ба назди Қаёфо, сарвари рӯҳониён бурданд. Дар хонаи Қаёфо шариатдонону пирони қавм аллакай ҷамъ омада буданд. ");
INSERT INTO tgk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Петрус бошад, то ба назди ҳавлии сарвари рӯҳониён аз пайи Исо дар масофаи каме дуртар меомад. Вай ба даруни ҳавлӣ даромада, бо мақсади анҷоми корро дидан дар байни посбонон нишаст. ");
INSERT INTO tgk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Сардорони рӯҳонӣ ва дигар ҳамаи аъзоёни шӯро бо нияти ба қатл расондани Исо кӯшиш карданд, ки бар зидди Ӯ ягон далели дурӯғеро пайдо кунанд. ");
INSERT INTO tgk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Лекин ҳеҷ далеле ёфта наметавонистанд, гарчи бисёр касон ба пеш баромада, зидди Ӯ тӯҳмат мекарданд. Оқибат ду кас ба пеш қадам монда ");
INSERT INTO tgk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","гуфтанд: «Ин одам гуфта буд, ки Хонаи Худоро вайрон карда, онро дар мобайни се рӯз аз нав барпо карда метавонад». ");
INSERT INTO tgk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Бо шунидани ин суханон сарвари рӯҳониён аз ҷояш бархеста ба Исо гуфт: «Ба ин далеле, ки Туро айбдор мекунанд, ягон гапи гуфтанӣ дорӣ?» ");
INSERT INTO tgk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Вале Исо хомӯш буд. Бори дигар сарвари рӯҳониён ба Ӯ гуфт: «Ба Худои зинда бигӯ, ки Ту ҳамон Таъиншуда ва Писари Худо ҳастӣ?» ");
INSERT INTO tgk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Исо дар ҷавоб ба вай гуфт: «Худатон ҳамин тавр гуфтед. Аммо ҳаминро ба ҳамаи шумо мегӯям, ки минбаъд шумо Фарзанди Инсонро аз дасти рости Худои Пурқудрат нишаста ва дар болои абрҳои осмон омада истода хоҳед дид!» ");
INSERT INTO tgk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Он гоҳ сарвари рӯҳониён либоси танашро дарронда гуфт: «Ӯ суханони кофирона гуфт. Дигар ба мо ҳеҷ шоҳиде лозим ҳам нест! Шумо худатон ҳоло суханони кофиронаи Ӯро шунидед. ");
INSERT INTO tgk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Пас чӣ ҳукм мебароред?» «Ҷазояш марг», — ҷавоб доданд дигарон. ");
INSERT INTO tgk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Баъзеҳо ба рӯи Исо туф карда Ӯро мезаданд. Баъзеҳо торсакӣ зада ");
INSERT INTO tgk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","мегуфтанд: «Ҳой Масеҳ, Ту пайғамбарӣ-ку! Канӣ, гӯй-чи Туро кӣ зад?!» ");
INSERT INTO tgk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Петрус дар рӯи ҳавлӣ менишаст, ки яке аз канизакон ба наздаш омада гуфт: «Ту ҳам ба Исои Ҷалилӣ шарик будӣ». ");
INSERT INTO tgk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Аммо Петрус дар ҳузури ҳама суханони ӯро инкор карда гуфт: «Намефаҳмам, чӣ мегӯӣ». ");
INSERT INTO tgk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Сипас вай аз он ҷо назди дарвозаи ҳавлӣ равона шуд. Хизматгорзани дигаре низ ӯро дида ба одамони дар он ҷо истода гуфт: «Вай ҳамроҳи Исои Носирӣ буд». ");
INSERT INTO tgk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Петрус боз инкор карда гуфт: «Қасам мехӯрам, ки ин одамро намешиносам». ");
INSERT INTO tgk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Баъд аз муддате чанд мардоне, ки дар ҳамон ҷо буданд, назди Петрус омада гуфтанд: «Аниқ ту ҳам шарики онҳо ҳастӣ, чунки аз лаҳҷаат маълум аст». ");
INSERT INTO tgk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Вале Петрус қасамҳо хӯрда гуфт: «Ман ин одамро намешиносам». Ҳамин лаҳза хурӯс ҷеғ зад ");
INSERT INTO tgk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ва суханони Исо ба хотири Петрус омаданд. Ӯ гуфта буд, ки ҳанӯз хурӯс ҷеғ назада, вай се бор шинохтани Исоро инкор мекунад. Петрус аз ҳавлӣ берун баромада, зор-зор гиря кард. ");
INSERT INTO tgk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Пагоҳии барвақт ҳамаи сардорони рӯҳонӣ ва пирони қавм нақшаи ба дасти марг супоридани Исоро кашиданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Бо фармони онҳо дасту пои Исоро баста Ӯро аз ҳавлии Қаёфо бароварданд ва ба дасти Пилотус, ки ҳокими румӣ буд, супориданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Вақте Яҳудои хиёнаткор дид, ки Исо ба марг маҳкум шуд, аз кори кардааш тавба кард. Ӯ он сӣ тангаи нуқраро назди сардорони рӯҳонӣ ва пирон баргардонда оварду ");
INSERT INTO tgk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ба онҳо гуфт: «Ба марги ин одами беайб ман гунаҳкор, чунки Ӯро ман таслим кардам». Лекин онҳо ҷавоб доданд: «Ин ба мо чӣ дахл дорад? Ин кори худат». ");
INSERT INTO tgk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Яҳудо он сӣ тангаи нуқраро ба рӯи фарши Хонаи Худо партофту аз он ҷо баромада рафта худро овехт. ");
INSERT INTO tgk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Сардорони рӯҳонӣ он тангаҳоро чида гирифта қарор карданд, ки аз рӯи шариат ин пулро ба хазинаи Хонаи Худо андохтан мумкин нест, чунки бар ивази ин пул хуни одам рехта шудааст. ");
INSERT INTO tgk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Баъд бо розигии ҳама онҳо саҳрои кӯзагарро харида, аз он барои мусофирон қабристон сохтанӣ шуданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ана барои ҳамин он саҳро то ба имрӯз «Саҳрои Хун» номида мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ҳанӯз Ирмиё пайғамбар пешгӯӣ карда гуфта буд: «Аз рӯи фармоне, ки Худо ба ман гуфт, онҳо сӣ тангаи нуқраро, яъне ҳамон маблағе, ки халқи Исроил Ӯро баҳо доданд, гирифта ба харидани саҳрои кӯзагар сарф карданд». Пас, ин пешгӯӣ ба амал омад. ");
INSERT INTO tgk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Акнун, ки Исо дар назди ҳокими румӣ меистод, ҳоким аз Ӯ пурсид: «Магар Ту Шоҳи Яҳудиён ҳастӣ?» Исо ҷавоб дод: «Худатон ҳамин тавр мегӯед». ");
INSERT INTO tgk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Лекин, ҳангоме ки сардорони рӯҳонӣ ва пирон Ӯро айбдор мекарданд, Ӯ ҳеҷ ҷавобе намедод. ");
INSERT INTO tgk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Пас Пилотус ба Ӯ гуфт: «Магар намешунавӣ, ки Туро то чӣ андоза айбдор мекунанд?» ");
INSERT INTO tgk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Аммо Вай ҳатто ба яке аз ин айбдоркуниҳо ҷавобе надод. Ва ин боиси тааҷҷуби зиёди Пилотус гардид. ");
INSERT INTO tgk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ҳокими румӣ одате дошт, ки дар ҷашни ин ид маҳбусеро, ки халқ талаб мекард, озод намояд. ");
INSERT INTO tgk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Он вақт як маҳбуси номдоре буд, ки Бараббос ном дошт. ");
INSERT INTO tgk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Инак, ҳангоме ки мардум ҷамъ омаданд, Пилотус аз онҳо пурсид: «Киро мехоҳед, ки бароятон озод кунам: Бараббосро ё Исоеро, ки Таъиншудаи Худо меноманд?» ");
INSERT INTO tgk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Пилотус хуб медонист, ки Исоро аз рӯи ҳасад ба дасти ӯ супорида буданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ҳанӯз ҳоким дар курсии ҳукмбарорӣ менишаст, ки ҳамсараш ба ӯ чунин хабар фиристод: «Бар зидди ин одами бегуноҳ ҳеҷ коре накунед, чунки имшаб дар хобам ман аз барои Вай бисёр азоб кашидам». ");
INSERT INTO tgk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Дар ин мобайн сардорони рӯҳонӣ ва пирони қавм мардумро розӣ кунонданд, ки аз Пилотус озод кардани Бараббос ва ба қатл расондани Исоро талаб намоянд. ");
INSERT INTO tgk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Пилотус бори дигар аз мардум пурсид: «Аз ҳардуяшон киро мехоҳед, ки бароятон озод кунам?» «Бараббосро!» — ҷавоб доданд онҳо. ");
INSERT INTO tgk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","«Пас, бо Исое, ки Таъиншудаи Худо меноманд, чӣ кор кунам?» — боз аз онҳо пурсид Пилотус. «Ӯро мехкӯб кунед!» — бо як овоз ҷавоб доданд ҳамаи онҳо. ");
INSERT INTO tgk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Лекин Пилотус савол дода гуфт: «Чаро? Охир Вай чӣ бадие кардааст?» Мардум бошанд, бо буду шуди овозашон дод мезаданд: «Бигзор Ӯ ба салиб мехкӯб карда шавад!» ");
INSERT INTO tgk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Пилотус дид, ки дигар ҳеҷ чорае надорад, дар акси ҳол шӯриш сар шуданаш мумкин буд, дар пеши назари тамоми мардум об гирифта дастонашро шуста гуфт: «Ба хунрезии ин одам ман ҷавобгар нестам! Шумо худатон қарор кунед!» ");
INSERT INTO tgk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Тамоми мардум ҷавоб доданд: «Ба марги Ӯ мо ва фарзандонамон ҷавобгар ҳастем!» ");
INSERT INTO tgk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Бинобар ин Пилотус Бараббосро барояшон озод кард ва Исоро ба дасти сарбозон супорид, то ки Ӯро қамчинкорӣ намуда, ба салиб мехкӯб кунанд. ");
INSERT INTO tgk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Сарбозони ҳоким Исоро ба ҳавлии дарбор бурданд ва аскарони зиёд он ҷо гирд омаданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Онҳо Ӯро бараҳна карда ба танаш ҷомаи суп-сурхро пӯшонданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Баъд аз навдаҳои хор тоҷе бофта, ба сараш гузоштанду ба дасти росташ чӯб доданд. Онҳо масхаракунон «Зинда бод Шоҳи Яҳудиён!» гуфта дар пеши Ӯ ба сари зону меистоданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Сарбозон Исоро туфборон карда, бо чӯб ба сараш задан гирифтанд. ");
INSERT INTO tgk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Вақте ки онҳо масхара додани Ӯро бас карданд, ҷомаро аз танаш кашида, либоси худашро пӯшонданд. Сипас Ӯро барои ба салиб мехкӯб кардан бурданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Дар аснои роҳ онҳо бо Шимъӯн ном марди қуринӣ дучор омаданд ва ӯро маҷбур карданд, ки чӯби салиби Исоро бардошта барад. ");
INSERT INTO tgk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Вақте ки онҳо ба ҷое бо номи Ҷолҷото, ки маънояш «Ҷои косахонаи сар» аст, расида омаданд, ");
INSERT INTO tgk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","сарбозон ба Исо майи бо моддаи талх омехташударо доданд. Ӯ аз он чашида, дигар нанӯшид. ");
INSERT INTO tgk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Онҳо Ӯро ба салиб мехкӯб карданду либосашро байни худ тақсим карданӣ шуда, барои муайян намудани соҳибшавандаи либос, қуръа партофтанд. ");
INSERT INTO tgk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Сипас нишаста Вайро назорат карда истоданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Аз болои сари Исо айбномае бар Ӯ навишта шуда буд: «Ин Исо Шоҳи Яҳудиён аст». ");
INSERT INTO tgk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ҳамроҳи Ӯ ду дуздро низ дар салибҳои дигар аз тарафҳои чапу росташ мехкӯб карданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Одамоне, ки аз он ҷо мегузаштанд, сар ҷунбонда Исоро мазоқ карда ");
INSERT INTO tgk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","мегуфтанд: «Ту мегуфтӣ, ки Хонаи Худоро вайрон карда, дар мобайни се рӯз онро барпо карда метавонӣ? Канӣ, набошад худатро наҷот деҳ-чи! Агар Ту Писари Худо бошӣ, канӣ аз салиб поён фаро-чи!» ");
INSERT INTO tgk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Айнан ҳамин тавр сардорони рӯҳонӣ, шариатдонон ва пирон низ Исоро масхаракунон мегуфтанд: ");
INSERT INTO tgk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Дигаронро наҷот медоду худашро наҷот дода наметавонад. Ана Шоҳи Исроил. Агар Вай ҳоло аз салиб поён фарояд, мо ба Вай имон меоварем. ");
INSERT INTO tgk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ӯ ба Худо умед мебаст ва мегуфт, ки Писари Худо аст. Канӣ ҳоло мебинем, ки Худо Вайро наҷот додан мехоҳад ё не?!» ");
INSERT INTO tgk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ҳатто дуздоне, ки ҳамроҳаш ба салибҳо мехкӯб шуда буданд, монанди дигарон Ӯро таҳқир мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Нисфирӯзӣ буд, ки тамоми рӯи заминро торикӣ фаро гирифт ва се соат давом ёфт. ");
INSERT INTO tgk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Қариби соати сеюм Исо бо овози баланд дод зада гуфт: «Элӣ, Элӣ! Лама сабақтанӣ!», ки маънояш «Эй Худои Ман! Эй Худои Ман! Чаро Маро тарк кардӣ?!» аст. ");
INSERT INTO tgk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Баъзе аз ҳозирон суханони Ӯро шунида гуфтанд: «Ӯ Илёс пайғамбарро ҷеғ зада истодааст». ");
INSERT INTO tgk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Он гоҳ яке аз онҳо давида рафту латтаеро гирифта ба сирко тар намуд ва бо нӯги чӯб дароз карда онро ба Исо нӯшонданӣ шуд. ");
INSERT INTO tgk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Лекин дигарон гуфтанд, ки ӯ ин корро накунад, то бубинанд, ки оё Илёс омада Вайро наҷот медиҳад ё не. ");
INSERT INTO tgk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Исо бори дигар бо овози баланд дод зада ҷон дод. ");
INSERT INTO tgk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Инак, пардае, ки ҷои муқаддастарини Хонаи Худоро ҷудо мекард, аз боло то ба поёнаш дарида, ду пора шуд. Замин ба ҷунбиш омаду сангҳо ба қисмҳо тақсим шуданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Қабрҳо кушода шуданду ҷасадҳои бисёр одамони муқаддас аз нав зинда гаштанд. ");
INSERT INTO tgk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Баъд аз он ки Исо аз байни мурдагон боз зинда шуд, онҳо аз қабрҳои худ берун баромада ба Ерусалим, шаҳри муқаддас даромаданду бисёр касон онҳоро диданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Вақте сардори лашкар ва ҳамроҳонаш, ки Исоро назорат мекарданд, заминҷунбию дигар ҳодисаҳоро диданд, сахт тарсида гуфтанд, ки Исо дар ҳақиқат Писари Худо будааст. ");
INSERT INTO tgk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Бисёр заноне, ки дар Ҷалил ба Исо ҳамроҳ шуда ба Ӯ хизмат мекарданд, низ дар ҳамон ҷо буданд. Онҳо дар масофае истода, ба ҳамаи ин нигоҳ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Дар байни онҳо Марями Маҷдалия, Марями модари Ёқубу Юсуф ва боз ҳамсари Забдой буданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Бо фаро расидани шом аз шаҳри Аромот як марди сарватманде бо номи Юсуф омад. Ӯ ҳам шогирди Исо буд. ");
INSERT INTO tgk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Юсуф пеши Пилотус рафта, хоҳиш кард, ки ҷасади Исоро ба ӯ диҳанд. Пилотус фармон дод, ки ҷасадро ба ӯ диҳанд. ");
INSERT INTO tgk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Юсуф Вайро гирифта ба кафани тоза печонд ");
INSERT INTO tgk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ва ба қабри худ, ки навакак дар ғоре сохта шуда буд, гузошт. Баъд санги калонеро ба дари қабр ғелонда, аз он ҷо рафт. ");
INSERT INTO tgk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Дар рӯ ба рӯи он қабр Марями Маҷдалия ва дигар Марям нишаста буданд. ");
INSERT INTO tgk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Рӯзи дигар, ки рӯзи истироҳат буд, сардорони рӯҳонӣ ва фарисиён ҷамъ шуданду пеши Пилотус рафта ");
INSERT INTO tgk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ба ӯ гуфтанд: «Тақсир, ба хотири мо омад, ки он фиребгар ҳанӯз дар қайди ҳаёт буданаш гуфта буд, ки дар рӯзи сеюм баъд аз маргаш аз нав зинда мешавад. ");
INSERT INTO tgk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Бинобар ин фармон диҳед, ки қабри Ӯро то рӯзи сеюм посбонӣ кунанд, мабодо шогирдонаш омада ҷасадашро дузданду ба халқ овоза паҳн кунанд, ки Ӯ аз байни мурдагон зинда шудааст. Он гоҳ ин дурӯғ аз дурӯғи аввал дида бадтар мешавад». ");
INSERT INTO tgk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Пилотус ба онҳо гуфт: «Посбононро гиреду рафта, ба чи тарз ки тавонед, қабрро нигаҳбонӣ кунед». ");
INSERT INTO tgk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Инак, онҳо рафта, санги дари қабрро мӯҳр карданду барои нигаҳбонии он посбонон гузоштанд. ");
INSERT INTO tgk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Фардои рӯзи истироҳат, офтоб ҳанӯз набаромада, Марями Маҷдалия ва дигар Марям барои хабар гирифтани қабр ба роҳ баромаданд. ");
INSERT INTO tgk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ногаҳон заминҷунбии сахт ба вуҷуд омад, чунки фариштаи Худованд аз осмон поён фаромада, санги дари қабрро як тараф ғелонда, бар болояш нишаст. ");
INSERT INTO tgk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Намуди вай барқ барин буду либосаш монанди барф сап-сафед. ");
INSERT INTO tgk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Посбонон аз тарси ӯ дарақ-дарақ ларзида мурда барин ба рӯи замин дароз кашиданд. ");
INSERT INTO tgk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Фаришта бошад, ба он занон гуфт: «Натарсед, ман медонам, ки шумо Исои ба салиб мехкӯбшударо ҷустуҷӯ карда истодаед. ");
INSERT INTO tgk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Лекин Ӯ дар ин ҷо нест. Чунон ки Ӯ гуфта буд, айнан ҳамон тавр Вай зинда шуд. Ана омада ҷоеро, ки Ӯ гузошта шуда буд, бубинед. ");
INSERT INTO tgk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Акнун, зуд назди шогирдонаш рафта бигӯед, ки Исо аз байни мурдагон зинда шуда, акнун пешопеши онҳо ба Ҷалил меравад. Онҳо Ӯро дар он ҷо хоҳанд дид. Ана ин буд хабаре, ки ман ба шумо гуфтанӣ будам». ");
INSERT INTO tgk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Пас, он занон бо тарс, вале шодикунон саросема аз назди қабр сӯи шогирдон давида рафтанд, то ки ба онҳо нақл кунанд. ");
INSERT INTO tgk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Банохост Исо бо онҳо вохӯрда саломашон дод. Онҳо ба Вай наздик омаданду саҷда карданӣ шуда аз пойҳояш дошта гирифтанд. ");
INSERT INTO tgk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Исо ба онҳо гуфт, ки натарсанд, балки рафта ба бародаронаш гӯянд, ки онҳо ба Ҷалил раванд ва Ӯро дар он ҷо хоҳанд дид. ");
INSERT INTO tgk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Занон ба роҳ баромада буданд, ки баъзе аз посбонон ба шаҳр рафта тамоми воқеаи рӯйдодаро ба сардорони рӯҳонӣ ҳикоят карданд. ");
INSERT INTO tgk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Сардорони рӯҳонӣ барои маслиҳат кардан бо пирони қавм вохӯрданд ва баъд аз маслиҳат ба посбонон пули калон дода ");
INSERT INTO tgk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","гуфтанд: «Рафта ба мардум гӯед, ки шабона шогирдони Исо омаданду аз фурсати хоб буданатон истифода бурда, ҷасади Ӯро дуздида рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Агар ин хабар то ба гӯши ҳоким рафта расад, ғам нахӯред; мо ба ӯ гапамонро маъқул мекунонем». ");
INSERT INTO tgk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Посбонон пулро гирифтанду рафта, чунон ки онҳоро ёд доданд, ҳамон тавр карданд. Бинобар ҳамин яҳудиён ин ҳикояро то ба имрӯз мегуфтагӣ шуданд. ");
INSERT INTO tgk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Инак, он ёздаҳ шогирд ба Ҷалил рафта ба кӯҳе, ки Исо ба онҳо гуфта буд, баромаданд. ");
INSERT INTO tgk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Онҳо Ӯро дидан замон ба Ӯ саҷда карданд, аммо баъзеашон шубҳа доштанд. ");
INSERT INTO tgk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Исо ба шогирдонаш наздик шуда гуфт: «Тамоми ҳукму қудрат дар замину осмон ба ихтиёри Ман дода шудааст. ");
INSERT INTO tgk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Пас, равед ва ҳамаи халқҳои рӯи заминро ба Ман шогирд созед: онҳоро аз номи Падар, Писар ва Рӯҳи Муқаддас таъмид диҳед ");
INSERT INTO tgk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ва иҷро кардани ҳама чизеро, ки ба шумо фармудаам, ёд диҳед. Инак, Ман ҳамеша то охири замон бо шумо мемонам». ");
INSERT INTO tgk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Хушхабар дар бораи Исои Масеҳ, ки Писари Худо аст, чунин сар мешавад: ");
INSERT INTO tgk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Дар китоби Ишаъё пайғамбар суханони Худо омадаанд: «Ана, Ман пешопеши Ту як одамамро мефиристам, то ба омаданат роҳ тайёр кунад. ");
INSERT INTO tgk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Касе дар биёбон фарёд зада мегӯяд: „Барои Худованд роҳ тайёр кунед! Онро рост намоед!“». ");
INSERT INTO tgk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ин шахс Яҳё пайғамбар буд, ки ба биёбон омада, ба эълон кардан даромад, ки мардум барои бахшида шудани гуноҳҳояшон бояд тавба карда, аз гуноҳҳояшон даст кашанд ва таъмид бигиранд. ");
INSERT INTO tgk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Аҳолии шаҳри Ерусалим ва мардуми тамоми сарзамини Яҳудия пеши Яҳё ба биёбон меомаданд. Онҳо ба гуноҳҳои худ иқрор мешуданд ва Яҳё онҳоро дар дарёи Урдун таъмид медод. ");
INSERT INTO tgk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Яҳё либосе аз пашми шутур ва камарбанди чармӣ дошт. Хӯрокаш малаху асали саҳроӣ буд. ");
INSERT INTO tgk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ӯ ба мардум эълон карда мегуфт: «Аз паси ман як нафаре меояд, ки аз ман тавонотар аст. Вай он қадар тавоност, ки ман ҳатто сазовори хам шуда кушодани банди пойафзоли Ӯ нестам. ");
INSERT INTO tgk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ман шуморо бо об таъмид медиҳам, вале Ӯ шуморо бо Рӯҳи Муқаддас таъмид медиҳад». ");
INSERT INTO tgk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Рӯзе Исо аз шаҳри Носира, ки дар сарзамини Ҷалил буд, ба назди Яҳё рафт ва Яҳё Ӯро дар дарёи Урдун таъмид дод. ");
INSERT INTO tgk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Вақти аз об баромадан Исо дид, ки осмон кушода шуд ва Рӯҳи Муқаддас ба сурати кабӯтаре поён фаромада, дар болои Вай қарор гирифт. ");
INSERT INTO tgk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Сипас аз осмон овозе садо дод: «Ту Писари азизи Ман ҳастӣ ва Ман аз Ту хушнудам». ");
INSERT INTO tgk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Рӯҳи Муқаддас фавран Исоро ба биёбон равона кунонд. ");
INSERT INTO tgk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ӯ дар он ҷо чил рӯз монд ва иблис Ӯро меозмуд. Дар биёбон Исо дар байни ҳайвоноти ваҳшӣ буд ва фариштагон ба Ӯ хизмат мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Пас аз дастгир шудани Яҳё Исо ба сарзамини Ҷалил омад, то ки хушхабари Худоро ба мардум эълон бикунад. ");
INSERT INTO tgk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ӯ мегуфт: «Вақт фаро расид ва подшоҳии Худо наздик аст. Тавба карда, аз гуноҳҳоятон даст кашед ва ба ин хушхабар имон оваред». ");
INSERT INTO tgk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Рӯзе Исо аз назди кӯли Ҷалил мегузашт, ки ба об тӯр андохта истодани Шимъӯн ва бародари ӯ Андриёсро дид, чунки онҳо моҳигир буданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Исо ба онҳо гуфт: «Омада Маро пайравӣ кунед, то ба ҷои моҳӣ ҷамъ кардани мардумро ба шумо омӯзам». ");
INSERT INTO tgk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Дарҳол онҳо тӯрҳои худро монда, Ӯро пайравӣ карданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Каме дуртар рафта Исо писарони Забдойро дид, ки Ёқуб ва Юҳанно ном доштанд. Онҳо дар қаиқи худ тӯрҳои моҳигириро таъмир мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Дарҳол онҳоро даъват намуд ва онҳо падарашон Забдойро бо мардикорон дар қаиқ монда, Ӯро пайравӣ карданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Сипас онҳо ба шаҳри Кафарнаҳум омада, дар рӯзи истироҳат, ба ибодатхона рафтанд. Дар он ҷо Исо ба таълим додани мардум оғоз намуд. ");
INSERT INTO tgk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Мардум аз таълими Ӯ қоил монданд, чунки Ӯ бо қудрат таълим медод, ки шариатдонон ин тавр набуданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Айнан ҳамон вақт марде гирифтори рӯҳи нопок, ки дар ибодатхона буд, фарёд зад: ");
INSERT INTO tgk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Эй Исои Носирӣ, Ту ба мо чӣ кор дорӣ?! Магар барои нобуд кардани мо омадаӣ?! Туро медонам! Ту Шахси муқаддаси Худо ҳастӣ!» ");
INSERT INTO tgk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Вале Исо рӯҳи нопокро сарзаниш карда фармуд, ки хомӯш шавад ва аз даруни он одам берун барояд. ");
INSERT INTO tgk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Рӯҳи нопок ӯро ба замин афтонда, бо овози баланд фарёд заду аз вай берун шуд. ");
INSERT INTO tgk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ҳама дар ҳайрат монданд ва ба якдигар мегуфтанд: «Ин чист? Ин як таълимоти навест! Ӯ ҳатто ба рӯҳҳои нопок чунон боқудратона амр медиҳад, ки онҳо ба Вай итоат мекунанд?» ");
INSERT INTO tgk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Овозаи Исо зуд дар тамоми гӯшаву канори сарзамини Ҷалил паҳн шуд. ");
INSERT INTO tgk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ҳамин ки Исо аз ибодатхона баромад бо ҳамроҳии Ёқуб ва Юҳанно ба хонаи Шимъӯну Андриёс рафт. ");
INSERT INTO tgk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Вақте ба он ҷо расиданд, ба Исо зуд хабар доданд, ки хушдомани Шимъӯн таб карда, дар бистар хобидааст. ");
INSERT INTO tgk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Вай назди бемор омад ва аз дасташ гирифта, ӯро бархезонд. Таби бемор паст шуд ва ӯ машғули меҳмоннавозӣ гардид. ");
INSERT INTO tgk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ҳамон бегоҳ, ҳангоми нишасти офтоб мардум ҳамаи беморону девонагонро ба назди Исо оварданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Тамоми аҳолии шаҳр ҳам назди дари хонаи онҳо ҷамъ омаданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ӯ одамони зиёдро аз бемориҳои гуногун шифо дод, бисёр девҳоро берун кард ва нагузошт, ки девҳо чизе бигӯянд, зеро онҳо кӣ будани Ӯро медонистанд. ");
INSERT INTO tgk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Саҳарии барвақт, ҳанӯз субҳ надамида, Исо бархесту ба ҷои хилвате рафта, дуо кард. ");
INSERT INTO tgk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Шимъӯн ва ҳамроҳонаш бошанд, ба ҷустуҷӯи Исо баромаданд. ");
INSERT INTO tgk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ӯро ёфта, ба Вай гуфтанд: «Ҳама Шуморо ҷустуҷӯ мекунанд». ");
INSERT INTO tgk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Вале Исо гуфт: «Биёед, ба шаҳру деҳоти гирду атроф низ биравем, то ки Ман ба мардуми он ҷо ҳам хушхабарро эълон намоям, чунки барои иҷрои ҳамин кор Ман омадаам». ");
INSERT INTO tgk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Баъд Ӯ ба тамоми гӯшаву канори сарзамини Ҷалил сафар карда, дар ибодатхонаҳо мардумро таълим медод ва девҳоро аз одамон берун мекард. ");
INSERT INTO tgk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Рӯзе ба назди Исо марди махав омад. Вай ба зону нишаста зорӣ карда гуфт: «Агар хоҳед, метавонед маро пок созед». ");
INSERT INTO tgk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Дили Исо ба ҳоли мард сӯхт ва дасташро ба вай расонда гуфт: «Албатта, мехоҳам! Пок шав!» ");
INSERT INTO tgk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Фавран касалии мард нест шуда, баданаш пок гашт. ");
INSERT INTO tgk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Исо ӯро зуд ҷавоб дода таъкидкунон ");
INSERT INTO tgk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","гуфт: «Дар ин бора зинҳор ба ҳеҷ кас нагӯй, балки рост назди рӯҳонӣ рафта, худро нишон деҳ ва барои пок шудани худ, ҳамон тавре ки Мӯсо фармудааст, қурбонӣ бикун, то ба онҳо шаҳодате гардад». ");
INSERT INTO tgk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Вале он мард берун баромада ошкоро ин хабари хушро паҳн мекард. Барои ҳамин Исо дигар озодона ба шаҳр даромада натавонист, балки дар саҳро монд. Бо вуҷуди ин, мардум аз ҳама ҷо ба назди Ӯ меомаданд. ");
INSERT INTO tgk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Пас аз чанд рӯз Исо ба шаҳри Кафарнаҳум баргашт ва овозаи дар хона буданаш зуд дар ҳама ҷо паҳн шуд. ");
INSERT INTO tgk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Хона ва беруни он чунон пуродам шуд, ки ҳатто ҷои сӯзан афтодан намонда буд. Исо ба онҳо каломи Худоро таълим медод. ");
INSERT INTO tgk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ҳамин вақт боз одамоне омаданд, ки чор нафаре аз онҳо шалеро бо ҷойгаҳаш бардошта назди Исо меоварданд. ");
INSERT INTO tgk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Вале аз бисёрии мардум ба Ӯ наздик шуда натавониста, боми хонаро аз болои сари Исо кушоданд ва дар он шикофе карда, шалро якҷоя бо ҷойгаҳаш поён фароварданд. ");
INSERT INTO tgk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Исо имони онҳоро дида, ба шал гуфт: «Додар, гуноҳҳоят бахшида шуданд!» ");
INSERT INTO tgk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Баъзе аз шариатдононе, ки дар он ҷо нишаста буданд, аз дили худ чунин фикрҳо мегузаронданд: ");
INSERT INTO tgk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ӯ чаро чунин суханони кофирона мегӯяд! Ҳеҷ кас ба ғайр аз Худо гуноҳи инсонро бахшида наметавонад». ");
INSERT INTO tgk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Исо ҳамон лаҳза дар дилаш фикри онҳоро фаҳмида гуфт: «Чаро чунин фикрҳо доред? ");
INSERT INTO tgk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Кадомаш осонтар аст: ба шал гуфтани он ки „гуноҳҳои ту бахшида шуданд“ ё ки „бархез, ҷойгаҳатро бардошта роҳ гард?“ ");
INSERT INTO tgk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Пас, Ман ба шумо исбот мекунам, ки Фарзанди Инсон дар рӯи замин қудрати бахшидани гуноҳҳоро дорад». Сипас ба шал нигариста гуфт: ");
INSERT INTO tgk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ба ту мегӯям, бархез, ҷойгаҳатро бардошта ба хонаат рав». ");
INSERT INTO tgk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Он мард аз ҷояш хеста, фавран ҷойгаҳашро ҷамъ карду дар пеши назари мардуми дарҳайратмонда равона шуд. Ҳама Худоро ситоиш карда, ба якдигар мегуфтанд: «То ҳол монанди ин чизе надида будем!» ");
INSERT INTO tgk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Исо боз ба соҳили кӯл рафт. Мардум дар гирди Ӯ ҷамъ омаданд ва Ӯ онҳоро таълим дод. ");
INSERT INTO tgk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ҳангоме Исо роҳашро давом дод Левии писари Ҳалфиро дид, ки ба ҷамъоварии андозу хироҷ машғул буд, ба ӯ гуфт: «Биё, пайрави Ман шав». Левӣ бархест ва аз паси Ӯ равона шуд. ");
INSERT INTO tgk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Вақте ки Исо бо шогирдонаш дар хонаи Левӣ таом мехӯрд, бисёр андозгирон ва онҳое, ки гунаҳкор ҳисоб мешуданд, низ дар сари он дастархон буданд, чунки бисёриҳо аз пайи Исо мерафтанд. ");
INSERT INTO tgk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Баъзе шариатдонон, ки фарисӣ буданд, Исоро бо «гунаҳкорону» андозгирон дар сари як дастархон дида, ба шогирдони Ӯ гуфтанд: «Чаро Ӯ бо андозгирону гунаҳкорон аз як дастархон хӯрок мехӯрад?» ");
INSERT INTO tgk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Исо инро шунида, ба онҳо гуфт: «Ба табиб на одамони солим, балки беморон мӯҳтоҷанд. Ман ҳам барои он омадаам, ки на накӯкорон, балки гунаҳкоронро даъват намоям». ");
INSERT INTO tgk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Дар он айём ҳам пайравони Яҳё ва ҳам фарисиён рӯза гирифта буданд. Баъзе касон назди Исо омада пурсиданд: «Чаро пайравони Яҳё ва пайравони фарисиён рӯза мегиранду шогирдони Шумо намегиранд?» ");
INSERT INTO tgk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Исо ба онҳо гуфт: «Оё дӯстони домод дар ҷашни арӯсӣ, ки домод ҳанӯз ҳамроҳашон аст, рӯза мегиранд? То домод бо онҳост, онҳо рӯза гирифта наметавонанд? ");
INSERT INTO tgk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Вале вақте мерасад, ки домод аз байнашон гирифта мешавад ва он рӯз онҳо низ рӯза мегиранд. ");
INSERT INTO tgk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Касе аз матои нав ба либоси кӯҳна ямоқ намекунад. Чун кунад ямоқи нав аз либоси кӯҳна ҷудо шуда, ҷои даридаи он боз ҳам аёнтар мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Инчунин касе шароби навтайёршударо ба машки чармини кӯҳна намерезад, чун бирезад ҳангоми ба ҷӯш омадани шароб машк дарида, ҳам шароб мерезад ва ҳам худи машк аз кор мебарояд. Бинобар ин шароби навтайёршударо ба машки нав мерезанд». ");
INSERT INTO tgk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Як рӯзи истироҳат Исо ва шогирдонаш аз киштзори гандум мегузаштанд ва дар аснои роҳ шогирдон хӯшаҳои гандумро мечиданд. ");
INSERT INTO tgk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Баъзе аз фарисиён ба Исо гуфтанд: «Барои чӣ онҳо кори дар рӯзи истироҳат раво набударо мекунанд?» ");
INSERT INTO tgk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Исо дар ҷавоб гуфт: «Магар дар навиштаҷот нахондаед, ки шоҳ Довуд вақте ки бо ҳамроҳонаш гурусна монд ва эҳтиёҷ дошт, чӣ кор кард? ");
INSERT INTO tgk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Вақте ки Абётор сарвари рӯҳониён буд, Довуд ба хонае, ки ҳузури Худоро дошт, даромада, нони ба Худо тақдимшударо гирифта хӯрд ва ба ҳамроҳонаш низ дод. Ҳол он ки аз рӯи шариат фақат рӯҳониён ҳақ доштанд он нонро бихӯранд». ");
INSERT INTO tgk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Боз давом дод: «Рӯзи истироҳат барои инсон офарида шудааст, на инсон барои рӯзи истироҳат. ");
INSERT INTO tgk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Бинобар ин Фарзанди Инсон соҳиби ҳатто рӯзи истироҳат аст». ");
INSERT INTO tgk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Бори дигар Исо ба ибодатхона рафт ва дар он ҷо марди дасташ хушкшудае буд. ");
INSERT INTO tgk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Баъзе одамон Исоро мушоҳида мекарданд, ки оё он мардро дар рӯзи истироҳат шифо мебахшад ё не. Агар шифо бахшад, Ӯро айбдор кунанд. ");
INSERT INTO tgk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Исо ба он марди дасташ хушкшудае гуфт, ки дар назди ҳама рост истад. ");
INSERT INTO tgk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Сипас ба тарафи онҳо нигоҳ карда гуфт: «Ба фикри шумо дар рӯзи истироҳат чӣ равост: некӣ ё бадӣ кардан; наҷот додани ҷон ё нобуд кардани он?» Аммо онҳо хомӯш буданд. ");
INSERT INTO tgk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Исо бо ғазаб ба онҳо нигоҳ карду аз якравиашон ғамгин гашт ва ба он мард гуфт: «Дастатро дароз кун!» Вай дасташро дароз карду дасташ сиҳат шуд. ");
INSERT INTO tgk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Фарисиён аз ибодатхона баромада, зуд бо аъзоёни ҳизби ҳиродиён муҳокима карда, нақшаи куштани Исоро кашиданд. ");
INSERT INTO tgk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ҳангоме ки Исо бо шогирдонаш ба тарафи кӯл равона шуд, мардуми бисёре аз сарзамини Ҷалилу Яҳудия, ");
INSERT INTO tgk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","аз шаҳри Ерусалим, инчунин аз сарзамини Адӯму атрофи дарёи Урдун ва аз Суру Сидун аз паси Ӯ мерафтанд. Мардуми зиёд дар бораи корҳои Исо шунида, ба гирди Ӯ ҷамъ меомаданд. ");
INSERT INTO tgk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Аз сабаби бисёрии мардум Исо ба шогирдонаш фармуд, ки барояш қаиқе тайёр кунанд, то ки одамон Ӯро пахш накунанд. ");
INSERT INTO tgk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Азбаски Исо беморони зиёдеро шифо бахшида буд, ҳамаи беморон аз ҳар тараф Ӯро пахш мекарданд, то дасташон ба Ӯ расаду шифо ёбанд. ");
INSERT INTO tgk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Рӯҳҳои нопок баробари дидани Ӯ худро дар наздаш ба замин мепартофтанд ва фарёдзанон мегуфтанд: «Ту Писари Худо ҳастӣ!» ");
INSERT INTO tgk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Вале Исо бо таъкиди қатъӣ ба онҳо амр мекард, ки Ӯро маълум накунонанд. ");
INSERT INTO tgk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Сипас Исо ба баландие баромада, онҳоеро ки мехост, ба наздаш даъват кард ва онҳо омаданд. ");
INSERT INTO tgk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Баъд аз байни онҳо дувоздаҳ нафарро вакил таъин намуд, ки доимо бо Ӯ бошанд, то ки онҳоро барои ба мардум эълон кардани хушхабари Худо фиристад ");
INSERT INTO tgk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ва онҳо қудрати берун кардани девҳоро дошта бошанд. ");
INSERT INTO tgk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Он дувоздаҳ нафар инҳоянд: Шимъӯн, ки Исо ӯро Петрус меномид, ");
INSERT INTO tgk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ёқуб ва Юҳанно, ки писарони Забдой буданд ва Исо онҳоро «писарони раъд» меномид, ");
INSERT INTO tgk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Андриёс, Филиппус, Барталмо, Матто, Тумо, Ёқуб, ки писари Ҳалфӣ буд, Таддо, Шимъӯни Ватандӯст ");
INSERT INTO tgk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ва Яҳудои Исқарют, ки баъдтар ба Исо хиёнат мекунад. Баъд Исо ба хона рафт. ");
INSERT INTO tgk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Мардуми зиёде боз ҷамъ омадаанд, ки Ӯ ва шогирдонаш ҳатто фурсати хӯрок хӯрдан наёфтанд. ");
INSERT INTO tgk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Бо шунидани ин хабар аҳли оилаи Исо ба наздаш омада, хостанд Ӯро бо худ баранд, зеро одамон мегуфтанд, ки Ӯ аз ақл бегона шудааст. ");
INSERT INTO tgk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Гурӯҳе аз шариатдонон, ки аз Ерусалим омада буданд, чунин мегуфтанд: «Ӯ дар худ Баал-Забул, сардори девҳоро дорад ва бо қудрати вай девҳоро берун мекунад». ");
INSERT INTO tgk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Исо онҳоро ба наздаш даъват карда, бо масал гуфт: «Чӣ тавр шайтон худашро берун карда метавонад? ");
INSERT INTO tgk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Давлате, ки дар дохили худ аз ҳам ҷудо шуда ҷанг мекунад, устувор намемонад. ");
INSERT INTO tgk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Хонаводае, ки байни аъзоёнаш ҷудоӣ афтодааст, устувор намемонад. ");
INSERT INTO tgk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Агар шайтон бар зидди худаш биҷангад ва дар худ ҷудоӣ дошта бошад, устувор намемонад, балки нобуд мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ҳеҷ кас наметавонад ба хонаи шахси пурзӯр зада даромада, молу мулкашро гирифта барад, то аввал дасту пои шахси пурзӯрро набандад, ана баъд хонаашро ғорат карда метавонад. ");
INSERT INTO tgk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ба ростӣ ба шумо мегӯям, ҳар гуноҳе, ки инсон мекунад ва ҳар сухани кофиронае, ки мегӯяд, бахшида мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Вале агар касе бар зидди Рӯҳи Муқаддас сухани кофирона гӯяд, ҳаргиз бахшида намешавад ва ин гуноҳаш то абад хоҳад монд». ");
INSERT INTO tgk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ин суханонро Исо ба хотири он гуфт, ки баъзеҳо дар борааш «Ӯ дар худ рӯҳи нопок дорад» мегуфтанд. ");
INSERT INTO tgk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Он гоҳ модар ва бародарони Исо омада, дар берун истода, шахсеро фиристоданд, ки Ӯро даъват кунад. ");
INSERT INTO tgk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Исо дар байни мардум нишаста буд, ки онҳо ба Ӯ гуфтанд: «Модар ва бародарону хоҳаронатон дар берун истодаанд ва Шуморо мепурсанд». ");
INSERT INTO tgk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ӯ дар ҷавоб гуфт: «Модар ва бародарони Ман кистанд? — ");
INSERT INTO tgk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ва ба атрофиёнаш нигоҳе карду давом дод, — Ана, инҳо модар ва бародарони Ман ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ҳар кӣ хости Худоро ба ҷо орад, бародар, хоҳар ва модари Ман аст». ");
INSERT INTO tgk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Бори дигар Исо дар канори кӯл ба мардум таълим медод ва тӯда-тӯдаи одамон дар гирдаш ҷамъ омаданд. Бинобар ин Ӯ маҷбур шуд, ки ба қаиқ нишаста, аз кӯл ба мардуме, ки дар соҳил буд, сухан гӯяд. ");
INSERT INTO tgk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ӯ таълим додани бисёр чизҳоро ба онҳо бо масалҳо сар кард. Ӯ гуфт: ");
INSERT INTO tgk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Гӯш кунед! Рӯзе як деҳқон барои кишт кардан мебарояд. ");
INSERT INTO tgk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Вақте ки дона мепошад, як миқдори он ба пайраҳа меафтад ва паррандаҳо омада, онро аз замин чида пок-покиза мехӯранд. ");
INSERT INTO tgk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Миқдори дигари он ба замини санглоху камхок меафтад. Аз сабаби чуқур набудани хоки замин он зуд месабзад. ");
INSERT INTO tgk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Вале бо баромади офтоб майсаи навхез пажмурда шуда, аз сабаби решаи мустаҳкам надоштан хушк мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Як миқдори дигараш ба миёни хорҳо меафтад ва хорҳо қад кашида майсаи баромадаро пахш мекунанду намегузоранд, ки он ҳосил диҳад. ");
INSERT INTO tgk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Лекин як ҳиссаи донаҳо ба замини хуби ҳосилхез афтода, месабзад ва қад кашида сӣ, шаст ва сад баробар зиёдтар ҳосил медиҳад». ");
INSERT INTO tgk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Боз гуфт: «Пас ҳар кӣ Маро мешунавад, бигзор гӯш кунад!» ");
INSERT INTO tgk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Вақте ки Ӯ танҳо буд, он дувоздаҳ нафар ва пайравонаш аз Ӯ маънои масалро пурсиданд. ");
INSERT INTO tgk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Исо ҷавоб дод: «Худо ба шумо сирру асрори подшоҳии худро ошкор кардааст. Вале барои онҳое, ки бо мо нестанд, ҳама чиз бо мақолу масалҳо таълим дода мешавад, ");
INSERT INTO tgk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","то ки онҳо „бо чашмони худ нигоҳ кунанду набинанд, бо гӯшҳои худ шунаванду нафаҳманд ва сӯи Худо рӯ нагардонанд, то Худо гуноҳҳояшонро бубахшад“». ");
INSERT INTO tgk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Баъд аз онҳо пурсид: «Магар маънои ин масалро нафаҳмидед? Пас ҳамаи масалҳои дигарро чӣ тавр мефаҳмед? ");
INSERT INTO tgk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Деҳқон каломи Худоро мекорад. ");
INSERT INTO tgk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Он ҳиссаи донаҳо, ки ба пайраҳа меафтанд, монанди он аст, ки баъзе касон каломро мешунаванд, вале шайтон зуд омада, каломи дар дили онҳо кошта шударо медуздад. ");
INSERT INTO tgk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Донаҳои ба замини санглох афтода касоне мебошанд, ки каломро шунида, якбора бо хушҳолӣ онро қабул мекунанд, ");
INSERT INTO tgk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","вале азбаски реша надоранд, муддати кӯтоҳ бардошт мекунанд. Баъд вақте ки аз барои калом ба душворӣ ва азоб дучор мешаванд, зуд имони худро аз даст медиҳанд. ");
INSERT INTO tgk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Донаҳое, ки ба замини хорзор меафтанд, монанди он аст, ки баъзе касон каломро мешунаванд, ");
INSERT INTO tgk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","аммо ғаму ташвиши зиндагӣ, орзуи бойигарӣ ва майлу рағбат ба чизҳои дигар фикру хаёлашонро ба худ банд карда, каломро пахш менамоянд ва дар натиҷа онҳо ҳеҷ ҳосиле намеоранд. ");
INSERT INTO tgk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Вале донаҳое, ки ба замини ҳосилхез меафтанд, монанди он аст, ки баъзе касон каломро мешунаванду қабул мекунанд ва сӣ, шаст ва сад баробар бештар ҳосил медиҳанд». ");
INSERT INTO tgk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Баъд аз онҳо пурсид: «Магар чароғро барои он меоранд, ки зери тағора ё кате гузоранд? Оё онро ба чароғпоя намегузоранд? ");
INSERT INTO tgk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ҳамин тавр, ҳар чӣ пинҳон ва пӯшида аст, ошкор ва равшан мегардад. ");
INSERT INTO tgk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Пас, ҳар кӣ Маро мешунавад, бигзор гӯш кунад! ");
INSERT INTO tgk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Суханони мешунидаатонро бо диққат мулоҳиза намоед. Бо кадом санги тарозу шумо баркашед, бо ҳамон санги тарозу ва ҳатто зиёдтар аз он ба шумо баркашида мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Зеро ҳар кӣ чизе дорад, ба ӯ боз ҳам зиёдтар дода мешавад ва касе, ки надорад, ҳатто он андаке, ки дорад, аз ӯ кашида гирифта мешавад». ");
INSERT INTO tgk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Исо суханони худро давом дода гуфт: «Подшоҳии Худо монанди он аст, ки шахсе ба замин донаҳо мепошад ");
INSERT INTO tgk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ва шабҳо хоб мераваду рӯзҳо бедор мешавад, донаҳо бошанд, сабзида нашъунамо меёбанд. Вале он шахс намедонад, ки сабзиш чӣ тавр сурат мегирад. ");
INSERT INTO tgk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Чунки худи замин донаҳоро месабзонад. Аввал дона сабзида қад мекашад, баъд хӯша пайдо шуда, аз дона пур мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ҳамин ки хӯшаҳо пухта мерасанд, вай бо дос меояд, чунки мавсими ҳосил расидааст». ");
INSERT INTO tgk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Инчунин Исо гуфт: «Подшоҳии Худоро ба чӣ монанд кунем? Бо кадом масал онро шарҳ диҳем? ");
INSERT INTO tgk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Вай монанди донаи хардалест, ки ҳангоми коштан аз ҳамаи донаҳои рӯи замин майдатарин мебошад, ");
INSERT INTO tgk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","вале баъд аз кошта шудан, калон мешаваду аз ҳама гиёҳҳо баландтар мегардад ва шохаҳояш то андозае баланд мешаванд, ки паррандаҳо дар сояаш лона месозанд». ");
INSERT INTO tgk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ҳамин тавр, ба қадре ки мардум фаҳмида метавонист, Ӯ каломи Худоро ба тариқи чунин масалҳои зиёд баён мекард. ");
INSERT INTO tgk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Исо ба онҳо ҳама чизро бо масал таълим медод, вале маънои масалҳоро ба шогирдонаш дар танҳоӣ мефаҳмонд. ");
INSERT INTO tgk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Бегоҳии ҳамон рӯз Ӯ ба шогирдонаш гуфт: «Биёед, ба канори дигари кӯл гузарем». ");
INSERT INTO tgk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Сипас, онҳо мардуми дар соҳил ҷамъомадаро тарк карданд ва ба қаиқе, ки Исо дар он нишаста буд, савор шуда, ба роҳ даромаданд. Бо Ӯ қаиқҳои дигар ҳам равона шуданд. ");
INSERT INTO tgk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ногаҳон тӯфони сахте сар шуд. Мавҷҳо бо зарб ба қаиқ бармехӯрданд ва оқибат қаиқ аз об пур шуд. ");
INSERT INTO tgk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Аммо Исо дар қафои қаиқ сарашро ба болишт гузошта мехобид. Шогирдонаш Ӯро бедор карда гуфтанд: «Устод! Магар парво надоред, ки мо мемирем?!» ");
INSERT INTO tgk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ӯ бархест ва бодро таъна зада, ба кӯл фармон дод: «Хомӯш шав! Ором бош!» Ҳамон лаҳза бод аз вазидан бозмонд ва дар ҳама ҷо оромии том ҳукмфармо шуд. ");
INSERT INTO tgk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Исо ба шогирдонаш гуфт: «Чаро ин қадар тарсидед? Оё ҳоло ҳам боварӣ надоред?» ");
INSERT INTO tgk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Вале онҳо, дар ҳолате ки тарсу ҳарос тамоми вуҷудашонро фаро гирифта буд, ба якдигар мегуфтанд: «Ин кӣ аст, ки ҳатто бод ва кӯл ба Ӯ итоат мекунанд!» ");
INSERT INTO tgk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ҳамин тавр, Исо ва шогирдонаш ба тарафи дигари кӯл, ба сарзамини Ҷадариён расиданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ҳангоми ба соҳил фаромадани Исо, якбора як шахсе, ки гирифтори рӯҳи нопок буд, аз қабристон берун баромада, ба тарафи Ӯ давид. ");
INSERT INTO tgk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ин мард дар қабристон зиндагӣ мекард ва ҳеҷ кас ӯро бо занҷир ҳам баста, нигоҳ дошта наметавонист. ");
INSERT INTO tgk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Борҳо дасту пояшро бо занҷирҳо баста ва завлона карда буданд, вале ӯ завлонаҳоро шикаста, занҷирҳоро пора-пора мекард. Касе барои ром кардани вай қувват надошт. ");
INSERT INTO tgk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ӯ шабу рӯз доимо дар қабристон ва теппаҳо дод зада мегашту худро бо сангҳо зада, маҷрӯҳ мекард. ");
INSERT INTO tgk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Вақте ки ӯ Исоро аз дур дид, давон-давон ба наздаш омада саҷда кард. ");
INSERT INTO tgk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Исо ба вай фармон дод: «Эй рӯҳи нопок, аз ин мард берун шав». Вай бошад, бо тамоми овозаш фарёд зада гуфт: «Эй Исо, Писари Худои Таоло, ба ман чӣ кор дорӣ? Аз барои Худо маро азоб надеҳ!» ");
INSERT INTO tgk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Исо аз ӯ пурсид: «Номат чист?» Ӯ ҷавоб дод: «Номам Лашкар аст, чунки мо бисёрем». ");
INSERT INTO tgk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Вай аз Исо зорию тавалло кард, ки онҳоро аз он маҳалла берун накунад. ");
INSERT INTO tgk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ҳамин вақт як галаи калони хукон дар болои теппае мечарид. ");
INSERT INTO tgk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Рӯҳҳои нопок аз Исо хоҳиш карда гуфтанд: «Моро ба мобайни хукҳо фирист ва иҷозат деҳ, ки ба онҳо дохил шавем». ");
INSERT INTO tgk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Исо ба онҳо иҷозат дод. Он гоҳ рӯҳҳои нопок аз он мард берун баромада, дохили хукҳо шуданд. Тамоми галаи хукон, ки тақрибан ду ҳазор сар буд, аз баландӣ ҷаста худро ба кӯл партофта ғарқ шуданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Хукбонҳо бошанд, ба шаҳру деҳоти атроф гурехта, дар ҳама ҷо ин ҳодисаро ба мардум нақл карданд. Мардум берун баромаданд, то бубинанд, ки чӣ ҳодиса рӯй додааст. ");
INSERT INTO tgk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Пас онҳо дар гирди Исо ҷамъ омада, диданд, ки ҳамон девонае, ки гирифтори лашкари девҳо буд, акнун дар тан либос дораду бо ақли солим нишастааст ва хеле тарсиданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Шоҳидони ин воқеа, ҳодисаи бо девонаву хукҳо рӯйдодаро нақл мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Он гоҳ мардум аз Исо хоҳиш карданд, ки аз сарзаминашон биравад. ");
INSERT INTO tgk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ҳангоме ки Исо ба қаиқ савор мешуд, марде, ки пештар гирифтори девҳо буд, аз Вай илтимос кард, ки ӯро ҳам бо худ бубарад. ");
INSERT INTO tgk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Аммо Исо хоҳиши ӯро рад карда гуфт: «Ба хонаат баргард ва ба хешу таборат нақл кун, ки Худованд дар ҳаққи ту чӣ кор ва чӣ ғамхории бузурге кард». ");
INSERT INTO tgk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ӯ низ равона шуд ва дар тамоми гӯшаву канори Даҳ Шаҳр ба ҳама эълон карда мегуфт, ки Исо барояш чӣ кори бузурге кардааст ва ҳама аз шунидани ин дар ҳайрат мемонданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Исо ба қаиқ савор шуда, ба тарафи дигари кӯл рафт. Вақте ки ба соҳил расид, мардуми зиёде назди Ӯ ҷамъ омаданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Дар ҳамин вақт марде бо номи Ёир, ки яке аз сардорони ибодатхонаи он шаҳр буд, омада Исоро дидан замон, худро пеши пойҳои Ӯ партофт. ");
INSERT INTO tgk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ӯ зорикунон гуфт: «Духтарам дар дами марг аст. Аз Шумо хоҳиш мекунам, ки биёед ва дастатонро бар ӯ бигузоред, то шифо ёбаду зинда монад». ");
INSERT INTO tgk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Исо бо ӯ ба роҳ даромад ва аз паси онҳо мардуми бешуморе ҳам равона шуданд, ки аз ҳар тараф Исоро фишор медоданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Дар он ҷо як зане буд, ки дувоздаҳ сол боз касалии хунравӣ дошт. ");
INSERT INTO tgk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ҳарчанд вай аз муолиҷаи табибони зиёд дард кашида, тамоми дороияшро сарф карда буд, саломатиаш хуб намешуд. Баръакс, аҳволаш торафт бадтар мешуд. ");
INSERT INTO tgk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Вақте ки ӯ дар бораи Исо шунид, аз дилаш гузаронд: «Агар ақаллан ба либосаш даст расонам, шифо меёбам». Барои ҳамин он зан аз байни тӯдаи одамон гузашта, аз ақиб ба Исо наздик шуду ба ҷомааш даст расонд. ");
INSERT INTO tgk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Худи ҳамон лаҳза хунравиаш бозмонд ва ӯ ҳис кард, ки шифо ёфтааст. ");
INSERT INTO tgk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ҳамон лаҳза Исо низ ҳис кард, ки аз Ӯ қуввае берун рафт ва ба мардуми гирду атрофаш нигоҳ карда пурсид: «Кӣ ба ҷомаам даст расонд?» ");
INSERT INTO tgk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Шогирдонаш ба Ӯ гуфтанд: «Мебинед, ки ба Шумо аз ҳар тараф фишор меоранд ва боз мепурсед, ки ба Шумо кӣ даст расонд?» ");
INSERT INTO tgk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Вале Исо ба атрофиён нигоҳ мекард, то касеро, ки ба ҷомааш даст расонда буд, пайдо кунад. ");
INSERT INTO tgk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Зане, ки аз шифоёбиаш огоҳ буд, ҷуръат карда, тарсону ларзон ба Исо наздик омад ва худро пеши пойҳои Ӯ партофта, ҳақиқати ҳолро нақл кард. ");
INSERT INTO tgk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Исо ба ӯ гуфт: «Эй зан, туро имонат шифо дод! Рав ва дар амон бошу саломат гард!» ");
INSERT INTO tgk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ҳанӯз ки Ӯ гап мезад, чанд нафар аз хонаи Ёир хабар оварда, гуфтанд: «Духтаратон гузашт. Ба заҳмат додани устод дигар ҳоҷате нест». ");
INSERT INTO tgk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Исо инро шунида, ба сардори ибодатхона гуфт: «Натарс! Фақат имон дошта бош». ");
INSERT INTO tgk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Инро гуфт ва ба ғайр аз Петрус, Ёқуб ва бародари ӯ Юҳанно ба дигарон иҷозат надод, ки ҳамроҳаш бираванд. ");
INSERT INTO tgk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Вақте ба хонаи Ёир расиданд, диданд, ки одамони зиёде бо шӯру ғавғо гиряву нола мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Исо ба хона даромада ба онҳо гуфт: «Чаро шӯру ғавғо бардошта, гиря мекунед? Духтар намурдааст, фақат хобидааст». ");
INSERT INTO tgk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Бо шунидани ин суханон мардум ба ҳолаш хандиданд. Вале Исо ҳамаро берун карда, бо падару модари духтар ва ҳамроҳонаш ба хонае, ки духтар хобида буд, даромад. ");
INSERT INTO tgk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Исо дасти беморро гирифта гуфт: «Талита қуми!», ки маънояш «Эй духтар, бархез!» аст. ");
INSERT INTO tgk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Он духтар, ки дувоздаҳсола буд, зуд бархест ва ба роҳ гаштан даромад. Онҳо аз дидани ин дар ҳайрат монданд. ");
INSERT INTO tgk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Исо онҳоро ҷиддӣ таъкид карда гуфт, ки ин воқеаро ба касе нагӯянд ва хоҳиш кард, ки ба духтар хӯрок бидиҳанд. ");
INSERT INTO tgk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Исо бо шогирдонаш аз он ҷо баромада, ба шаҳри Носира, ки дар он ҷо ба воя расида буд, баргашт. ");
INSERT INTO tgk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Рӯзи истироҳат Ӯ дар ибодатхона ба таълим додани мардум шурӯъ кард. Бисёр касоне, ки Ӯро мешуниданд, ба ҳайрат афтода, чунин мегуфтанд: «Аз куҷо Вай ҳамаи ин чизҳоро дорад? Ин чӣ ҳикмате ба Ӯ дода шудааст? Чӣ хел мӯъҷизаҳои бузург бо дастони Ӯ иҷро шудаанд? ");
INSERT INTO tgk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Магар Ӯ ҳамон дуредгар нест, ки модараш Марям, бародаронаш Ёқуб, Юшо, Яҳудо ва Шимъӯн ҳастанд ва хоҳаронаш ҳам дар байни мо зиндагӣ мекунанд?» Пас Ӯро рад карданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Исо ба онҳо гуфт: «Пайғамбар беифтихор намешавад, магар ин ки дар диёр, байни хешон ва хонадони худ қадр надорад». ");
INSERT INTO tgk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Бинобар ин Исо дар он шаҳр мӯъҷизаи бузурге нишон дода натавонист, танҳо ба чанд бемор даст расонда, онҳоро шифо дод. ");
INSERT INTO tgk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ӯ аз беимонии онҳо дар ҳайрат буд. Исо ба деҳоти атроф рафта, мардумро таълим медод. ");
INSERT INTO tgk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Вай дувоздаҳ вакилашро ба пешаш даъват кард ва ба онҳо қудрати ба рӯҳҳои нопок амр карданро дода, ҷуфт-ҷуфт ба ҳар тараф фиристод. ");
INSERT INTO tgk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ӯ ба онҳо фармуд: «Ба ғайр аз асо ҳамроҳи худ чизе нагиред: на хӯрок, на борхалта, на ҳамёни пул ва на либоси иловагӣ. Танҳо пойафзоли оддӣ бипӯшед. ");
INSERT INTO tgk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ба ҳар ҷое, ки расидед, то вақти рафтанатон фақат дар як хона бимонед ва онро иваз накунед. ");
INSERT INTO tgk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Агар дар он ҷо шуморо қабул накунанд ва ба суханони шумо гӯш надиҳанд, аз он ҷо биравед ва чанги он ҷойро аз пойҳои худ биафшонед, то шаҳодати айбдор будани онҳо гардад». ");
INSERT INTO tgk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Пас онҳо рафта, эълон мекарданд, ки ҳама бояд тавба карда ба Худованд рӯй оваранд. ");
INSERT INTO tgk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Онҳо девҳои зиёдеро берун карда, бисёр беморонро бо молидани равған шифо бахшиданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Шоҳ Ҳиродус аз ин корҳо бохабар шуд, чунки номи Исо дар ҳама ҷо шӯҳрат меёфт. Баъзеҳо дар бораи Исо мегуфтанд, ки ин Яҳёи Таъмиддиҳанда зинда шудааст ва барои ҳамин ҳам чунин қудрати мӯъҷизакорӣ дар ҳаёташ амал мекунад. ");
INSERT INTO tgk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Баъзеи дигарон мегуфтанд, ки ин Илёс пайғамбар аст. Қисми дигари одамон мегуфтанд, ки Ӯ яке аз пайғамбарони давраҳои қадим аст. ");
INSERT INTO tgk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Аммо вақте Ҳиродус инро шунид, гуфт: «Ин Яҳё аст, ки ман сарашро аз танаш ҷудо карда будам ва ҳоло ӯ аз нав зинда шудааст». ");
INSERT INTO tgk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Зеро чунин ҳодиса рӯй дода буд: Ҳиродус ба занӣ Ҳиродияро, ки зани бародараш Филиппус буд, гирифт. Барои ҳамин Яҳё ба Ҳиродус мегуфт: «Хонадоршавии шумо бо Ҳиродия, ки зани бародаратон аст, раво нест». Аз ин рӯ, Ҳиродус як даста одамонро барои дастгир кардани Яҳё фиристод. Онҳо ӯро дастгир карда, баста ба ҳабс андохтанд. ");
INSERT INTO tgk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Дар дили Ҳиродия зидди Яҳё кина пайдо шуд ва ӯ хост, ки Яҳёро бикушад, лекин ин корро карда наметавонист, ");
INSERT INTO tgk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","чунки Ҳиродус аз Яҳё метарсид. Вай медонист, ки Яҳё марди худотарс ва муқаддас аст, барои ҳамин ҳам ӯро эҳтиёт мекард. Гарчанде суханони Яҳё ӯро нороҳат мекарданд, ба ҳар ҳол онҳоро гӯш кардан барояш маъқул буд. ");
INSERT INTO tgk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Рӯзе барои Ҳиродия фурсати муносибе фаро расид: Ҳиродус дар рӯзи таваллуди худ зиёфате ороста, ҳамаи мансабдорон, сарлашкарон ва мардуми баобрӯи сарзамини Ҷалилро даъват намуд. ");
INSERT INTO tgk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Вақте ки духтари Ҳиродия ба базм омада рақсид, ӯ Ҳиродус ва меҳмононашро мафтун кард. Аз ин рӯ, Ҳиродус ба вай гуфт: «Ҳар чӣ аз ман талаб кунӣ, бароят медиҳам». ");
INSERT INTO tgk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Подшоҳ Ҳиродус қасам хӯрда гуфт: «Ҳар чӣ ки пурсӣ медиҳам, то ҳатто нисфи мамлакатамро». ");
INSERT INTO tgk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Духтар рафта аз модараш маслиҳат пурсид, ки чӣ талаб кунад. Ҳиродия ҷавоб дод: «Сари Яҳёи Таъмиддиҳандаро талаб кун». ");
INSERT INTO tgk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Духтар базудӣ назди шоҳ омада гуфт: «Мехоҳам, ки худи ҳозир сари Яҳёи Таъмиддиҳандаро дар рӯи табақе ба ман ҳадя кунед». ");
INSERT INTO tgk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Шоҳ хеле ғамгин шуд, вале аз барои қасами хӯрдааш ва меҳмононаш хоҳиши духтарро рад кардан нахост. ");
INSERT INTO tgk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Бинобар ин шоҳ даррав ба ҷаллод фармуд, ки сари Яҳёро барояш гирифта биёрад. Ҷаллод ба ҳабсхона рафта, сари Яҳёро аз танаш ҷудо карду ");
INSERT INTO tgk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","рӯи табақ гузошта ба духтар оварда дод. Духтар бошад, онро ба модараш дод. ");
INSERT INTO tgk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ҳангоме ки шогирдони Яҳё аз ин хабар ёфтанд, омада, ҷасади ӯро гирифтанду бурда гӯронданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Вакилон ба назди Исо баргашта кори кардаашон ва ба мардум чизи таълим додаашонро нақл карданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Азбаски рафтуомади мардум чунон зиёд буд, ки Исо ва вакилонаш ҳатто фурсати хӯрок хӯрдан надоштанд, Исо ба онҳо гуфт: «Танҳо худатон биёед, ки ҷои хилвате биравем ва каме истироҳат кунед». ");
INSERT INTO tgk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Пас, ба қаиқ савор шуда, худашон танҳо ба ҷои хилвате рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Бисёр одамон рафтани онҳоро диданд ва онҳоро шинохта, аз ҳар қишлоқ пиёда аз пасашон шитофтанду пеш аз онҳо ба он маҳал омада расиданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Вақте ки Исо ба соҳил фаромад, мардуми зиёдеро дида, ба ҳолашон раҳмаш омад, зеро ки онҳо монанди гӯсфандони бе чӯпон буданд ва ба онҳо таълим додани чизҳои зиёдеро сар кард. ");
INSERT INTO tgk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Бегоҳӣ шогирдон назди Исо омада гуфтанд: «Ин як ҷои беодам аст, вақт ҳам дер шуд. ");
INSERT INTO tgk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Мардумро фиристед, ки ба деҳоту қишлоқҳои атроф рафта, барои худ хӯрдание харанд». ");
INSERT INTO tgk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Вале Исо гуфт: «Шумо ба онҳо хӯрок диҳед». Шогирдон пурсиданд: «Ба фикри шумо, мо бояд рафта ба дусад динор нон харида, ба онҳо диҳем?» ");
INSERT INTO tgk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Исо гуфт: «Рафта бинед, ки шумо чӣ қадар нон доред». Онҳо фаҳмида омада ба Ӯ гуфтанд: «Ҳамагӣ панҷ нону ду моҳӣ ҳаст». ");
INSERT INTO tgk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Он гоҳ Исо фармуд, ки шогирдонаш мардумро гурӯҳ-гурӯҳ рӯи сабза шинонанд. ");
INSERT INTO tgk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Одамон бо гурӯҳҳо панҷоҳ ва саднафарӣ нишастанд. ");
INSERT INTO tgk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Исо он панҷ нон ва ду моҳиро ба дасташ гирифта, ба осмон нигаристу аз Худо баракат талабид ва нонҳоро пора карда, бо моҳӣ ба шогирдонаш дод, онҳо бошанд, ба мардум тақсим карданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ҳама то сер шудан хӯрданду ");
INSERT INTO tgk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","шогирдон аз нонпора ва моҳиҳои боқимонда боз дувоздаҳ сабадро пур карданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Шумораи мардоне, ки нон хӯрданд, панҷ ҳазор нафар буд. ");
INSERT INTO tgk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Баъд аз он Исо зуд ба шогирдонаш фармуд, ки ба қаиқ савор шуда, пешопеш ба сӯи Байт-Сайдо раҳсипор шаванд, то худаш мардумро ҷавоб диҳад. ");
INSERT INTO tgk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Пас аз ҷавоб додани мардум Исо барои дуо кардан ба кӯҳ баромад. ");
INSERT INTO tgk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Шомгоҳон қаиқ ба миёни кӯл расид, Исо бошад, дар соҳил танҳо монда буд. ");
INSERT INTO tgk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Вақте Исо дид, ки шогирдонаш бо азоб зидди боди мухолиф шино мекунанд, субҳидам рӯ-рӯи об қадамзанон ба тарафи онҳо равона шуд. Вай аз назди онҳо гузашта рафтанӣ буд, ");
INSERT INTO tgk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","вале шогирдон дар рӯи об роҳ рафтани Ӯро дида, фикр карданд, ки ин арвоҳ аст ва аз тарс фарёд заданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Азбаски ҳама Ӯро дида тарсиданд, Исо фавран ба онҳо гуфт: «Натарсед! Ин Манам. Ором шавед». ");
INSERT INTO tgk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Баъд ба қаиқ савор шуд ва ҳамон замон бод аз вазидан монд. Шогирдон бениҳоят ҳайрон монданд, ");
INSERT INTO tgk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","чунки аз сабаби якравиашон ҳанӯз ҳодисаи зиёд шудани нонро нафаҳмиданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Онҳо ба соҳили дигар расида, дар сарзамини Ҷинесор қарор гирифтанд. ");
INSERT INTO tgk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ҳамин ки онҳо аз қаиқ фаромаданд одамон Исоро шинохтанд. ");
INSERT INTO tgk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Онҳо зуд ба тамоми гирду атроф рафта, беморонро, ҳатто бо ҷойгаҳашон бардошта, ба ҳар ҷое, ки мешуниданд Исо буд, меоварданд. ");
INSERT INTO tgk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ба ҳар ҷое, ки Исо мерафт, чи дар деҳоту чи дар шаҳрҳо, одамон беморонро сари роҳи Ӯ гузошта, илтимос мекарданд, ки ақаллан ба лаби доманаш даст расонанд ва ҳар касе ки даст мерасонд, шифо меёфт. ");
INSERT INTO tgk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Рӯзе чанд нафар аз фарисиён ва шариатдонон аз Ерусалим ба назди Исо омаданд. Онҳо гирди Ӯ ҷамъ омада ");
INSERT INTO tgk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","диданд, ки баъзе шогирдонаш бо дасти «бетаҳорат», яъне ношуста хӯрок мехӯранд. ");
INSERT INTO tgk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ҳол он ки яҳудиён, махсусан фирқаи фарисиён, то даме ки дастҳояшонро мувофиқи урфу одатҳои аҷдодон нашӯянд, ҳаргиз хӯрок намехӯрданд. ");
INSERT INTO tgk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Инчунин ҳеҷ чизро аз бозор то нашӯянд намехӯрданд. Боз бисёр урфу одатҳои дигарро риоя мекарданд, монанди шустани пиёла ва дегу табақҳои биринҷӣ. ");
INSERT INTO tgk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Фарисиён ва шариатдонон аз Исо пурсиданд: «Барои чӣ шогирдони Шумо урфу одатҳои аҷдодони моро риоя накарда, бо дастҳои бетаҳорат хӯрок мехӯранд?» ");
INSERT INTO tgk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Исо дар ҷавоби онҳо гуфт: «Ҳақ буд Ишаъё пайғамбар, вақте оид ба шумо, дурӯяҳо пешгӯӣ карда гуфта буд: „Худо мегӯяд: «Ин одамон бо суханонашон Маро таъриф мекунанд, вале дилашон аз Ман дур аст. ");
INSERT INTO tgk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Онҳо Маро бефоида парастиш мекунанд, чунки қонуну қоидаҳои инсониро „қонуни Худо“ гуфта таълим медиҳанд!»“ ");
INSERT INTO tgk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Шумо фармудаҳои Худоро як тараф гузошта, ба урфу одатҳои инсонӣ пайравӣ мекунед. ");
INSERT INTO tgk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Шумо барои нигоҳ доштани урфу одатҳои худ шуда моҳирона фармудаҳои Худоро беэътибор мемонед. ");
INSERT INTO tgk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Масалан, Худо ба воситаи Мӯсо фармудааст: „Падару модари худро эҳтиром кунед“ ва „ҳар кӣ дар ҳаққи падар ё модараш сухани қабеҳ гӯяд, ҷазояш марг аст“. ");
INSERT INTO tgk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Шумо бошед, таълим медиҳед, ки агар касе ба падару модараш бо чизе ёрӣ расонда тавонад, вале ёрӣ нарасонда гӯяд, ки ман инро ба Худо мебахшам, ");
INSERT INTO tgk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","шумо дигар намегузоред, ки вай ба падару модараш ягон кӯмаке кунад. ");
INSERT INTO tgk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ҳамин тавр шумо суханони Худоро бо урфу одатҳои худ барҳам дода, насл ба насл инро ёд медиҳед ва бисёр корҳои мисли ин мекунед». ");
INSERT INTO tgk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Исо мардумро боз наздаш даъват намуда гуфт: «Ҳамаатон Маро гӯш карда, бифаҳмед. ");
INSERT INTO tgk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ҳар чизе ки аз берун ба даруни одам медарояд, вайро ҳаром карда наметавонад, аммо он чизе, ки аз даруни одам берун мебарояд, вайро ҳаром мекунад». ");
INSERT INTO tgk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Вақте ки Исо аз назди мардум рафта, ба хона даромад, шогирдонаш аз Ӯ маънои ин масалро пурсиданд. ");
INSERT INTO tgk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Вай ба онҳо гуфт: «Наход шумо ҳам инро нафаҳмида бошед? Магар намедонед, ки он чӣ ба даруни одам аз берун медарояд, ӯро ҳаром карда наметавонад? ");
INSERT INTO tgk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Чунки хӯрок ба дили шумо дохил намешавад, балки аз меъдаи шумо гузашта, берун мебарояд» (бо ин суханон Исо эълон кард, ки ҳар гуна хӯрок ҳалол аст). ");
INSERT INTO tgk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Баъд илова кард: «Он чизе, ки аз даруни худи инсон мебарояд, ӯро ҳаром мекунад. ");
INSERT INTO tgk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Чунки маҳз аз дохил, аз дили инсон ниятҳои бад берун меоянд, ба монанди алоқаи беникоҳ, дуздиву одамкушӣ ва бахилӣ, фиребу найранг, бадкориву бадахлоқӣ, ҳасаду тӯҳматкунӣ, мағрурӣ ва бефаросатӣ. ");
INSERT INTO tgk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ҳамаи ин бадиҳо аз даруни инсон берун баромада, ӯро ҳаром мекунанд». ");
INSERT INTO tgk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Аз он ҷо Исо ба шаҳри Сур рафт. Ӯ ба хонае даромад ва нахост, ки касе омаданашро фаҳмад. Вале ин кор ба Ӯ муяссар нашуд. ");
INSERT INTO tgk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Зане, ки духтари хурдсолаш гирифтори рӯҳи нопок буд, аз омадани Исо зуд бохабар шуда, ба назди Ӯ омад ва ба пеши пойҳояш афтод. ");
INSERT INTO tgk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Вай зани юнонӣ, зодаи Финиқияи Сурия буд. Ӯ илтимос кард, ки Исо девро аз духтараш берун кунад. ");
INSERT INTO tgk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Исо ба ӯ гуфт: «Бигзор аввал фарзандон сер шаванд, чунки нони фарзандонро гирифта ба сагон додан нодуруст аст». ");
INSERT INTO tgk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Вале зан ҷавоб дод: «Дуруст аст, хоҷаам, вале сагон ҳам нонпораҳои аз дастархони кӯдакон афтодаро чида мехӯранд». ");
INSERT INTO tgk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Он гоҳ Исо ба зан гуфт: «Барои чунин ҷавобат метавонӣ ба хонаат баргардӣ, ки дев аз духтарат дур шудааст». ");
INSERT INTO tgk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Зан ба хонааш омада дид, ки дев аз духтараш берун шуда, вай ором хобидааст. ");
INSERT INTO tgk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Сипас, Исо аз Сур баромада, бо роҳи Сидун ба тарафи кӯли Ҷалил ба ноҳияи Даҳ Шаҳр равона шуд. ");
INSERT INTO tgk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Дар он ҷо ба наздаш мардеро оварданд, ки кар буду забонаш мегирифт. Онҳо илтимос карданд, ки Исо бар ӯ даст гузошта, шифояш диҳад. ");
INSERT INTO tgk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Исо ӯро аз байни мардум ба як тараф бурда, ангуштонашро ба гӯши вай гузошт ва туф карда, ангуштонашро ба забони мард расонд. ");
INSERT INTO tgk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Баъд ба осмон нигариста оҳе кашиду гуфт: «Ифатаҳ!», ки маънояш «Кушода шав!» мебошад. ");
INSERT INTO tgk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Он мард зуд шифо ёфта, гӯшҳояш кушода шуданд, забонаш озод гашт ва ӯ бурро гап зада метавонистагӣ шуд. ");
INSERT INTO tgk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Исо ба онҳо гуфт, ки ба касе чизе нагӯянд, вале ҳар қадар бештар онҳоро таъкид мекард, онҳо ҳамон қадар зиёдтар овозаҳо паҳн мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Мардум қоил шуда, ба якдигар мегуфтанд: «Ҳар коре, ки мекунад, хуб аст. Ӯ ҳатто карҳоро шунаво мекунаду забони гунгҳоро мекушояд». ");
INSERT INTO tgk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Дар яке аз ҳамин рӯзҳо боз тӯда-тӯдаи одамон ба назди Исо ҷамъ омаданд ва чизи хӯрдание надоштанд. Исо шогирдонашро ба наздаш даъват карда гуфт: ");
INSERT INTO tgk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ба ин одамон раҳмам меояд, онҳо се рӯз боз бо Ман ҳастанд ва ҳеҷ хӯрдание надоранд. ");
INSERT INTO tgk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Агар онҳоро гурусна ба хонаҳояшон фиристам, дар роҳ аз ҳол мераванд ва баъзеи онҳо аз роҳи дур омадаанд». ");
INSERT INTO tgk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Шогирдонаш гуфтанд: «Магар касе метавонад дар ин биёбон ин қадар одамро аз нон сер кунад?» ");
INSERT INTO tgk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Исо пурсид: «Шумо чанд нон доред?» Гуфтанд: «Ҳафтто». ");
INSERT INTO tgk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ӯ ба мардум фармуд, ки ба рӯи замин шинанд. Баъд он ҳафт нонро гирифта, ба Худо шукр гуфт ва онро пора карда, ба шогирдонаш дод, ки тақсим кунанд ва онҳо нонро ба мардум тақсим карданд. ");
INSERT INTO tgk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Онҳо инчунин чанд моҳии майда ҳам доштанд. Исо Худоро барои онҳо шукр гуфта, фармуд, ки он моҳиҳо низ байни мардум тақсим шаванд. ");
INSERT INTO tgk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Мардум хӯрда сер шуданд ва аз хӯроки боқимонда ҳафт сабади калонро пур карданд. ");
INSERT INTO tgk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Дар он ҷо қариб чор ҳазор нафар буданд ва Исо онҳоро ҷавоб дод. ");
INSERT INTO tgk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Баъд якбора Ӯ бо шогирдонаш ба қаиқ савор шуда, ба ноҳияи Далмонуто раҳсипор гашт. ");
INSERT INTO tgk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Сипас чанд нафаре аз фарисиён назди Исо омада, бо Ӯ баҳсу мунозираро сар карданд ва Ӯро озмуданӣ шуда, талаб намуданд, ки ба онҳо ягон нишонае аз ҷониби Худо диҳад. ");
INSERT INTO tgk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Исо аз дилаш оҳи вазнине кашида гуфт: «Барои чӣ ин насл нишонае талаб мекунад? Ба ростӣ ба шумо мегӯям, ба ин насл ягон нишона дода намешавад». ");
INSERT INTO tgk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Пас онҳоро монда, ба қаиқ савор шуду ба тарафи дигари кӯл рафт. ");
INSERT INTO tgk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Шогирдони Исо фаромӯш карданд, ки ба қаиқ бо худ нон бигиранд ва ҳоло фақат як нон доштанд. ");
INSERT INTO tgk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Исо ба онҳо гуфт: «Ҳушёр бошед! Худро аз хамиртуруши шоҳ Ҳиродусу фарисиён эҳтиёт кунед». ");
INSERT INTO tgk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Шогирдон бо якдигар муҳокима карда мегуфтанд: «Ӯ аз сабаби нон надоштанамон инро гуфт». ");
INSERT INTO tgk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Вале Исо аз суханони онҳо дарак дошта гуфт: «Чаро муҳокима мекунед, ки нон надоред? Магар то ҳол дарк намекунед ва нафаҳмидед? Ё гарданшах шудаед? ");
INSERT INTO tgk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Шумо, ки чашм доред, чаро намебинед? Гӯш дореду чаро намешунавед? Оё фаромӯш кардед? ");
INSERT INTO tgk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ҳангоми панҷ ҳазор мардро бо панҷ нон сер карданам чанд сабадро аз нонпораҳо пур кардед?» Ҷавоб доданд: «Дувоздаҳ сабад». ");
INSERT INTO tgk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Гуфт: «Вақте ки бо ҳафт нон чор ҳазор нафарро сер кардам, чанд сабадро аз нонпораҳо пур кардед?» Гуфтанд: «Ҳафт сабад!» ");
INSERT INTO tgk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ба онҳо гуфт: «Оё то ҳол намефаҳмед?» ");
INSERT INTO tgk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Вақте ки онҳо ба Байт-Сайдо расиданд, чанд нафаре марди кӯреро ба назди Исо оварда, хоҳиш карданд, ки ба вай даст расонда шифо диҳад. ");
INSERT INTO tgk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Исо дасти он мардро гирифта аз деҳа берун бурд. Баъд оби даҳонашро ба чашмони мард молида, дастонашро бар Ӯ гузошту пурсид: «Ягон чиз мебинӣ?» ");
INSERT INTO tgk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Мард боло нигариста гуфт: «Мардумро мисли дарахтоне мебинам, ки роҳ мераванд». ");
INSERT INTO tgk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Исо бори дигар дастонашро ба чашмони он мард гузошт. Ин дафъа мард бо диққат нигоҳ кард ва чашмонаш шифо ёфтанду ӯ ҳама чизро хуб дид. ");
INSERT INTO tgk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Исо ӯро ба хонааш фиристода таъкид кард, ки ба деҳа барнагардад. ");
INSERT INTO tgk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Исо бо шогирдонаш ба деҳаҳои атрофи шаҳраки Қайсарияи Филиппус сафарашро давом дод. Дар роҳ аз шогирдонаш пурсид: «Одамон дар бораи кӣ будани Ман чӣ мегӯянд?» ");
INSERT INTO tgk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Онҳо ҷавоб доданд: «Баъзеҳо мегӯянд, ки Шумо Яҳёи Таъмиддиҳанда ҳастед, дигарон, ки Илёс пайғамбаред, қисми дигари одамон мегӯянд, ки Шумо яке аз пайғамбарони гузашта ҳастед». ");
INSERT INTO tgk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Он гоҳ Исо пурсид: «Шумо чӣ? Шумо Маро кӣ мешуморед?» Петрус гуфт: «Ту Масеҳ, яъне Таъиншудаи Худо ҳастӣ». ");
INSERT INTO tgk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Исо онҳоро таъкид кард, ки дар ин бора ба касе чизе нагӯянд. ");
INSERT INTO tgk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Баъд Исо ба шогирдонаш таълим додани онро сар кард, ки Фарзанди Инсон бояд ранҷу азоби зиёде кашад ва пирони қавм, сардорони рӯҳонӣ ва шариатдонон аз Вай рӯ мегардонанд ва Ӯ кушта мешавад, вале баъд аз се рӯз аз нав зинда мегардад. ");
INSERT INTO tgk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Исо ин суханонро кушоду равшан гуфт, вале Петрус Ӯро ба як сӯ кашида, ба сарзаниш кардан даромад. ");
INSERT INTO tgk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Лекин Исо рӯяшро гардонда ба шогирдонаш нигоҳ карду Петрусро сарзаниш намуда гуфт: «Дур шав аз Ман, шайтон! Ту фикри Худоро надорӣ, балки фикри инсонӣ мекунӣ». ");
INSERT INTO tgk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Баъд Исо шогирдон ва мардумро ба наздаш ҷамъ карда гуфт: «Ҳар касе аз шумо, ки мехоҳад пайрави Ман бошад, бояд аз манфиатҳои худ даст кашида, салиби азобу маргашро бардошта барад, он гоҳ Маро пайравӣ кунад. ");
INSERT INTO tgk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ҳар кас, ки ҳаёташро нигоҳ доштан мехоҳад, онро аз даст медиҳад, вале ҳар кас, ки ба хотири Ман ва ин хушхабар аз баҳри ҳаёти худаш мегузарад, онро нигоҳ медорад. ");
INSERT INTO tgk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ба одам чӣ фоидае дорад, ки тамоми дунёро ба даст овараду ҷонашро аз даст диҳад? ");
INSERT INTO tgk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Одамизод бар ивази ҷони худ ҳеҷ товоне дода наметавонад. ");
INSERT INTO tgk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Касе, ки дар ин рӯзгори пур аз гуноҳу беимонӣ аз Ман ва суханонам шарм кунад, Фарзанди Инсон низ, ҳангоме ки бо шӯҳрату ҷалоли Падараш, ҳамроҳи фариштаҳои муқаддас меояд, аз ӯ шарм хоҳад кард». ");
INSERT INTO tgk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Исо ба онҳо боз ин тавр гуфт: «Ба ростӣ ба шумо мегӯям, чанд нафароне, ки дар ин ҷо ҳастанд, ҳанӯз дар қайди ҳаёт буданашон бо тамоми қудрат омадани подшоҳии Худоро мебинанд». ");
INSERT INTO tgk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Пас аз шаш рӯз Исо танҳо Петрус, Ёқуб ва Юҳанноро ҳамроҳаш гирифта, ба болои кӯҳи баланд баромад. Дар он ҷо рангу рӯи Исо дар пеши назари шогирдонаш дигаргун шуд. ");
INSERT INTO tgk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Либоси Ӯ дурахшида, аз барф ҳам сафедтар гашт, то ба дараҷае, ки дар рӯи замин ҳеҷ кас аз он сафедтар карда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Он гоҳ барояшон Илёс ва Мӯсо намудор шуданд, ки бо Исо сӯҳбат мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Он гоҳ Петрус ба Исо гуфт: «Устод, бароямон хуб аст, ки ин ҷо бошем. Биёед се хаймае месозем, яке барои Шумо, дигаре ба Мӯсо ва боз ба Илёс». ");
INSERT INTO tgk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Петрус намедонист, ки чӣ гӯяд, чунки ҳамаи онҳо сахт тарсида буданд. ");
INSERT INTO tgk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Баъд абре пайдо шуда, онҳоро бо сояаш фаро гирифт ва овозе аз он шунида шуд: «Ин Писари азизи Ман аст, суханони Ӯро гӯш кунед». ");
INSERT INTO tgk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ногаҳон онҳо ба атроф назар андохта, ғайр аз Исо касеро надиданд. ");
INSERT INTO tgk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Вақте ки аз кӯҳ мефаромаданд, Исо онҳоро таъкид кард, ки то аз нав зинда шудани Фарзанди Инсон аз он чӣ дидаанд, ба касе чизе нагӯянд. ");
INSERT INTO tgk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Барои ҳамин онҳо ба касе дар ин бобат даҳон намекушоданд, агарчи дар байни худ маънои ибораи «аз нав зинда шудан»-ро муҳокима мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Шогирдон аз Исо пурсиданд: «Чаро шариатдонон мегӯянд, ки пеш аз Масеҳ бояд Илёс биёяд?» ");
INSERT INTO tgk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Исо ҷавоб дод: «Дуруст, аввал Илёс омада, ҳама чизро барқарор мекунад. Вале Фарзанди Инсон, чунон ки дар борааш навишта шудааст, азоб кашида, хору зор мегардад. ");
INSERT INTO tgk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Аммо дар бораи Илёс мегӯям, ки ӯ омада буд ва айнан ҳамон тавре, ки дар бораи ӯ навишта шуда буд, дар ҳаққи ӯ ҳар чӣ ки хостанд, карданд». ");
INSERT INTO tgk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Вақте ки онҳо ба назди шогирдони дигар омаданд, диданд, ки мардуми зиёде дар гирди онҳо ҷамъ шудаанд ва чанд нафар аз шариатдонон бо онҳо баҳсу мунозира доранд. ");
INSERT INTO tgk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ҳамин ки мардум Исоро диданд, хеле ҳайрон шуда, давон-давон ба истиқболаш рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Исо пурсид: «Дар бораи чӣ бо онҳо баҳс мекунед?» ");
INSERT INTO tgk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Марде аз байни мардум ҷавоб дод: «Устод, писарамро назди Шумо овардам. Ӯ гап зада наметавонад, зеро гирифтори рӯҳи нопок аст. ");
INSERT INTO tgk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ҳар гоҳ ки рӯҳи нопок писарамро бигирад, ӯро бар замин мезанад ва даҳонаш кафк мекунад, дандонҳояш ба якдигар мечаспанд ва баданаш мисли чӯб карахт мешавад. Аз шогирдони Шумо хоҳиш кардам, ки рӯҳи нопокро аз ӯ берун кунанд, вале онҳо натавонистанд». ");
INSERT INTO tgk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Исо гуфт: «Эй насли беимон! То кай ҳамроҳи шумо бошам ва то кай ҳамаи шуморо тоқат кунам? Писарро пеши Ман биёред». ");
INSERT INTO tgk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Пас ӯро оварданд ва ҳамин ки рӯҳ Исоро дид, писарро сахт ларзонд. Бача ба рӯи замин ғалтида ғел мезад ва аз даҳонаш кафк мебаромад. ");
INSERT INTO tgk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Исо аз падари ӯ пурсид: «Ӯ кай боз ба ин дард гирифтор аст?» Ҷавоб дод: «Аз бачагиаш. ");
INSERT INTO tgk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Рӯҳи нопок борҳо ӯро ба обу оташ андохта, мехост нобудаш кунад. Ба мо раҳм кунед ва агар илоҷашро ёбед ба мо мадад кунед». ");
INSERT INTO tgk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Исо ба мард гуфт: «Чӣ? „Агар илоҷашро ёбам“? Ба касе, ки имон дорад, ҳама чиз имконпазир аст». ");
INSERT INTO tgk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Падари бача дарҳол нидо кард: «Бале, имон дорам, вале ёрӣ диҳед, ки имонам қавитар гардад». ");
INSERT INTO tgk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Вақте Исо дид, ки мардуми зиёд давон омада ҷамъ мешаванд, бо сарзаниш ба рӯҳи нопок амр кард: «Эй рӯҳи кариву гунгӣ! Ба ту мегӯям, аз ин бача берун баро ва дигар ба ӯ надаро!» ");
INSERT INTO tgk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Рӯҳи нопок наърае зада, бори дигар бачаро сахт ларзонда, аз ӯ берун шуд. Ранги бача монанди мурда шуд, барои ҳамин бисёриҳо «Вай мурдааст» гуфтанд. ");
INSERT INTO tgk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Вале Исо дасти ӯро гирифта, аз ҷояш хезонд ва бача ба пояш истод. ");
INSERT INTO tgk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Баъдтар, вақте ки Исо ба хона даромад шогирдон дар танҳоӣ аз Ӯ пурсиданд: «Чаро мо рӯҳи нопокро берун карда натавонистем?» ");
INSERT INTO tgk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Исо гуфт: «Ин зот танҳо бо дуо берун карда мешавад». ");
INSERT INTO tgk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Исо ҳамроҳи шогирдонаш он ҷоро монда, аз Ҷалил гузашта рафт. Вай намехост, ки касе аз ин бохабар шавад, ");
INSERT INTO tgk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","чунки Ӯ шогирдонашро таълим дода мегуфт: «Фарзанди Инсон ба дасти одамон супорида мешавад ва онҳо Ӯро мекушанд, вале баъд аз се рӯз Вай аз нав зинда мешавад». ");
INSERT INTO tgk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Вале онҳо маънои суханони Ӯро нафаҳмиданду аз пурсидан тарсиданд. ");
INSERT INTO tgk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Онҳо ба шаҳри Кафарнаҳум расида, ба хонае даромаданд ва Исо аз шогирдонаш пурсид: «Дар роҳ бо якдигар дар бораи чӣ баҳс мекардед?» ");
INSERT INTO tgk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Онҳо хомӯш буданд, зеро дар роҳ баҳс мекарданд, ки кӣ аз ҳама бузургтар аст. ");
INSERT INTO tgk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Пас, Исо нишасту дувоздаҳ шогирдро ҷамъ карда гуфт: «Ҳар кӣ дар сафи пеш шудан хоҳад, бояд аз ҳама ақиб ва дар хизмати ҳама бошад». ");
INSERT INTO tgk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Баъд кӯдакеро гирифта дар байни онҳо гузошт. Сипас, ӯро ба бағал гирифта, ба шогирдонаш гуфт: ");
INSERT INTO tgk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ҳар касе ки чунин кӯдакро ба хотири Ман қабул мекунад, дар асл Маро қабул мекунад. Ҳар касе, ки Маро қабул мекунад, на Маро, балки фиристандаи Маро қабул мекунад». ");
INSERT INTO tgk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Сипас Юҳанно ба Исо гуфт: «Устод, мардеро дидем, ки аз номи Шумо девҳоро берун мекард, вале азбаски ӯ бо мо набуд, кӯшиш кардем, ки ӯро аз ин кор боздорем». ");
INSERT INTO tgk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Аммо Исо гуфт: «Ӯро аз ин кор бознадоред! Ҳар касе, ки аз номи Ман мӯъҷиза мекунад, наметавонад баъд аз фурсате дар бораи Ман сухани баде бигӯяд. ");
INSERT INTO tgk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Зеро касе ки бар зидди мо нест, тарафдори мост. ");
INSERT INTO tgk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ба ростӣ ба шумо мегӯям, агар касе ба шумо фақат ба хотири он, ки шогирди Масеҳ ҳастед, ақаллан як пиёла об диҳад, ҳаргиз бе мукофот нахоҳад монд». ");
INSERT INTO tgk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Вале агар шахсе сабабгори он гардад, ки яке аз ин пайравони хурди Ман гумроҳ шавад, беҳтар аст, ки ба гардани он шахс санги осиёбро баста, ба баҳр партоянд. ");
INSERT INTO tgk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Агар дастат туро ба гуноҳ кардан водор созад, онро бурида парто, зеро бароят беҳтар аст, ки бе як даст буда, соҳиби ҳаёт шавӣ, аз он ки ду даст дошта бошию ба оташи дӯзах афтӣ. ");
INSERT INTO tgk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Агар поят туро ба гуноҳ кардан водор созад, онро бурида парто, зеро бароят беҳтар аст, ки бе як по буда, соҳиби ҳаёт шавӣ, аз он ки ду по дошта бошию ба дӯзах партофта шавӣ. ");
INSERT INTO tgk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Агар чашмат туро ба гуноҳ кардан водор созад, онро канда парто, зеро бароят беҳтар аст, ки як чашм дошта бошию ба подшоҳии Худо дароӣ, аз он ки ду чашм дошта бошиву ба дӯзах партофта шавӣ, ");
INSERT INTO tgk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","„ки дар он ҷо кирмҳо ҳаргиз намемиранд ва оташ ҳеҷ гоҳ хомӯш намегардад“. ");
INSERT INTO tgk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Чун ҳар кас бо оташ намакин мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Намак чизи хуб аст, вале агар сифаташро гум кунад, бо чӣ онро намакин карда метавонед? Пас шумо низ дар худ намак дошта бошед ва бо якдигар дар сулҳу салоҳ зиндагӣ кунед». ");
INSERT INTO tgk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Исо он ҷоро монда, ба тарафи сарзамини Яҳудия ва қисми шарқии дарёи Урдун рафт. Боз мардуми зиёде дар он ҷо ҷамъ омаданд ва Ӯ низ аз рӯи одат ба таълими онҳо шурӯъ кард. ");
INSERT INTO tgk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Он гоҳ чанд нафар фарисиён омада, Ӯро озмуданӣ шуда, савол доданд: «Оё аз рӯи шариат мумкин аст, ки мард аз занаш ҷудо шавад?» ");
INSERT INTO tgk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Исо ҳам аз онҳо пурсид: «Мӯсо дар ин бора чӣ фармудааст?» ");
INSERT INTO tgk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ҷавоб доданд: «Мӯсо иҷозат додааст, ки мард талоқномае навишта, аз занаш ҷудо шавад». ");
INSERT INTO tgk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Исо бошад, ба онҳо гуфт: «Мӯсо аз сабаби гарданшахии шумо бароятон чунин иҷозатро навишта буд. ");
INSERT INTO tgk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Вале аз ибтидои офариниши ин дунё Худо „онҳоро мард ва зан офаридааст“. ");
INSERT INTO tgk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","„Бинобар ин мард аз падару модараш ҷудо шуда, бо ҳамсараш мепайвандад, то ки на ду нафар, балки як тан шаванд“. Акнун онҳо на ду тан, балки якто ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Пас, он чиро ки Худо бо ҳам пайвастааст, инсон набояд ҷудо кунад». ");
INSERT INTO tgk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Вақте ки онҳо ба хона баргаштанд, шогирдонаш дар ин бора аз Исо пурсиданд. ");
INSERT INTO tgk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Исо ба онҳо гуфт: «Ҳар марде, ки аз занаш ҷудо шуда, зани дигар мегирад, нисбат ба ҳамсари аввалааш гунаҳкор дар алоқаи беникоҳ ҳисоб мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ҳамчунин агар зан аз шавҳараш ҷудо шуда, ба марди дигар ба шавҳар барояд, гунаҳкор дар алоқаи беникоҳ ҳисоб мешавад». ");
INSERT INTO tgk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Рӯзе одамон фарзандонашонро назди Исо оварданд, то ки Ӯ ба онҳо даст гузошта, баракат диҳад. Вале шогирдон онҳоро сарзаниш карданд. ");
INSERT INTO tgk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Исо рафтори шогирдонашро диду ба ғазаб омада гуфт: «Монед, ки кӯдакон назди Ман оянд ва пеши роҳи онҳоро нагиред, зеро Худо дар ҳаёти онҳое подшоҳӣ мекунад, ки мисли ин кӯдакон ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ба ростӣ ба шумо мегӯям, ҳар касе, ки подшоҳии Худоро монанди кӯдак қабул накунад, ҳеҷ гоҳ ба ин подшоҳӣ дохил намешавад». ");
INSERT INTO tgk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Баъд кӯдаконро ба оғӯш гирифт ва ба болои сарашон даст гузошта, онҳоро баракат дод. ");
INSERT INTO tgk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Вақте ки Исо ба роҳ баромад, марде ба наздаш давида омада дар пешаш ба зону афтод ва пурсид: «Эй устоди нек! Чӣ кор бояд бикунам, ки ҳаёти абадӣ насибам гардад?» ");
INSERT INTO tgk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Исо гуфт: «Чаро Маро нек мегӯӣ? Ғайр аз Худо каси нек нест. ");
INSERT INTO tgk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Худат фармоиши Худоро медонӣ: одамкушӣ накун, алоқаи беникоҳ накун, дуздӣ накун, шаҳодати бардурӯғ надеҳ, касеро фиреб надеҳ ва падару модаратро ҳурмату эҳтиром намо». ");
INSERT INTO tgk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Мард ҷавоб дод: «Эй устод! Ҳамаи ин фармоишҳоро аз хурдсолиам риоя кардаам». ");
INSERT INTO tgk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Исо ба ӯ бо нигоҳи гарму пурмеҳр гуфт: «Ба ту фақат як чиз намерасад: бирав, ҳар чӣ, ки дорӣ, бифурӯш ва пулашро ба бечорагон тақсим бикун, он гоҳ соҳиби ганҷинаи осмонӣ мегардӣ. Баъд омада, Маро пайравӣ намо». ");
INSERT INTO tgk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Вале он мард, ки бойигарии зиёде дошт, аз шунидани чунин суханон рӯҳафтода шуду ғамгин ба хонааш баргашт. ");
INSERT INTO tgk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Исо ба гирду атроф нигоҳ карда, ба шогирдонаш гуфт: «Ба подшоҳии Худо дохил шудани одамони бой чӣ душвор аст». ");
INSERT INTO tgk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Шогирдон аз суханони Исо ба ҳайрат афтоданд. Пас Исо такрор карда гуфт: «Эй фарзандонам! Ба подшоҳии Худо дохил шудан чӣ душвор аст. ");
INSERT INTO tgk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Аз сӯрохи сӯзан гузаштани шутур осонтар аз он, ки шахси сарватманд ба подшоҳии Худо дохил шавад». ");
INSERT INTO tgk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Шогирдон беш аз пеш дар ҳайрат монда, ба якдигар мегуфтанд: «Пас кӣ наҷот ёфта метавонад?» ");
INSERT INTO tgk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Исо ба шогирдонаш нигоҳ карда гуфт: «Ба инсон ин корро кардан ғайриимкон аст, вале на ба Худо; бо Худо аз ӯҳдаи ҳар кор баромадан мумкин аст». ");
INSERT INTO tgk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Он вақт Петрус ба Исо гуфт: «Ана, мо аз баҳри ҳама чиз баромада, Шуморо пайравӣ кардем». ");
INSERT INTO tgk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Исо ҷавоб дод: «Ба ростӣ ба шумо мегӯям, агар касе ба хотири Ман ва ин хушхабар аз баҳри хона, бародарон ё хоҳарон, падар ё модар, фарзандон ё заминҳояш гузашта бошад, ");
INSERT INTO tgk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ҳоло дар вақти ҳозира сад баробар зиёдтар хонаҳо, бародарону хоҳарон, модарону фарзандон, заминҳо ва баробари ҳамаи ин азобҳо низ пайдо мекунад ва дар оянда ҳаёти абадӣ низ насибаш мегардад. ");
INSERT INTO tgk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Лекин бисёри онҳое, ки ҳоло дар сафи пеш ҳастанд, дар сафи ақиб мешаванд ва онҳое, ки дар сафи ақиб ҳастанд, дар сафи пеш мешаванд». ");
INSERT INTO tgk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Онҳо ба сӯи Ерусалим раҳсипор шуданд. Исо пешопеш мерафт. Шогирдони дарҳайратмонда ва одамон бо тарс аз паси Ӯ қадам мезаданд. Исо дувоздаҳ шогирдашро ба як тарафе бурда, бори дигар гуфт, ки дар Ерусалим Ӯро чӣ сарнавиште интизор аст. ");
INSERT INTO tgk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ӯ гуфт: «Мо ба Ерусалим рафта истодаем, ки дар он ҷо Фарзанди Инсон ба дасти сардорони рӯҳонӣ ва шариатдонон фурӯхта мешавад. Онҳо Ӯро ба марг маҳкум мекунанду баъд ба дасти беимонон месупоранд. ");
INSERT INTO tgk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Беимонон бошанд, Ӯро масхара карда, ба Вай туф мекунанд ва латукӯб карда ба қатл мерасонанд, вале Ӯ пас аз се рӯз аз нав зинда мешавад». ");
INSERT INTO tgk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ёқубу Юҳаннои писарони Забдой пеши Исо омада гуфтанд: «Устод, мо мехоҳем, ки хоҳишамонро бароямон иҷро кунед». ");
INSERT INTO tgk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Исо пурсид: «Чӣ хоҳиш доред? Бароятон чӣ кор кунам?» ");
INSERT INTO tgk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Гуфтанд: «Вақте ки Шумо бо шӯҳрату ҷалол подшоҳӣ мекунед, иҷозат диҳед, яке аз дасти рост ва дигаре аз дасти чапатон бишинем». ");
INSERT INTO tgk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Исо ҷавоб дод: «Шумо намефаҳмед, ки чиро талаб карда истодаед. Магар аз он косае, ки Ман бояд бинӯшам, нӯшида метавонед ва магар бо он азоби марговаре, ки Ман таъмид мегирам, шумо ҳам таъмид гирифта метавонед?» ");
INSERT INTO tgk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ҷавоб доданд: «Бале, метавонем». Аммо Исо ба онҳо гуфт: «Хӯш, аз косаи Ман хоҳед нӯшид ва бо азобе, ки Ман таъмид мегирам, шумо ҳам таъмид хоҳед гирифт. ");
INSERT INTO tgk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Аммо ба интихоб кардани касоне, ки аз дасти чапу рости Ман мешинанд, Ман ҳақ надорам. Ба ин ҷойҳо касоне мешинанд, ки Худо онҳоро пешакӣ таъин кардааст». ");
INSERT INTO tgk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Даҳ шогирди дигар инро шунида, ба Ёқубу Юҳанно сахт қаҳрашон омад. ");
INSERT INTO tgk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Пас, Исо ҳамаи онҳоро гирд оварда гуфт: «Шумо хуб медонед, ки подшоҳон ва бузургони халқҳо ба мардуми худ зӯроварӣ мекунанд ва ҳукмашонро ба онҳо мегузаронанд. ");
INSERT INTO tgk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Лекин дар байни шумо набояд ин тавр бошад. Баръакс, ҳар кас ки дар байни шумо бузург будан мехоҳад, бояд хизматгори шумо бошад ");
INSERT INTO tgk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ва ҳар касе, ки мехоҳад дар сафи пеш истад, бояд ғуломи ҳама бошад. ");
INSERT INTO tgk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ҳатто Фарзанди Инсон барои он наомадааст, ки касе ба Ӯ хизмат кунад, балки омад, то ки ба дигарон хизмат кунад ва барои нархи наҷоти бисёр одамонро супоридан ҷонашро фидо кунад». ");
INSERT INTO tgk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Баъд онҳо ба Ериҳӯ омада расиданд. Вақте ки Исо бо шогирдонаш ва мардуми зиёде аз ин шаҳр берун мерафтанд, дар канори роҳ Бартимай ном нобиное, ки писари Тимай буд, нишаста садақа мепурсид. ");
INSERT INTO tgk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Чун Бартимай шунид, ки Исои Носирӣ аз он роҳ мегузарад, фарёд зада гуфт: «Эй Исои насли Довуд, ба ман раҳм кунед!» ");
INSERT INTO tgk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Бисёриҳо ӯро сарзаниш карда гуфтанд, ки хомӯш шавад. Вале ӯ овозашро боз ҳам баландтар карда фарёд мезад: «Эй Насли Довуд, ба ман раҳм кунед!» ");
INSERT INTO tgk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Исо аз роҳаш бозистода гуфт: «Ба вай бигӯед, ки ин ҷо биёяд». Мардум нобиноро ҷеғ зада гуфтанд: «Аз ҷоят хез, натарс, зеро Ӯ туро ба наздаш ҷеғ мезанад». ");
INSERT INTO tgk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Бартимай ҷомаашро кашида, аз ҷояш парида хест ва назди Исо омад. ");
INSERT INTO tgk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Исо аз вай пурсид: «Ту чӣ мехоҳӣ? Бароят чӣ кор кунам?» Нобино гуфт: «Устод, мехоҳам бино шавам». ");
INSERT INTO tgk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Исо ба ӯ гуфт: «Бирав, имонат туро шифо дод». Он мард ҳамон лаҳза бино шуд ва аз паси Исо рафт. ");
INSERT INTO tgk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Баъд Исо ва шогирдонаш ба наздикии Ерусалим, ба деҳаҳои Байт-Фоҷӣ ва Байт-Ҳинӣ, ки дар доманаи теппаи Зайтун ҷойгир шудаанд, рафта расиданд. Ӯ ду шогирдашро пешопеши худ фиристода, ");
INSERT INTO tgk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ба онҳо гуфт: «Ба қишлоқи дар пешистода равед. Ҳамин ки ба он ҷо мерасед, харкурраи бастаеро мебинед, ки ҳанӯз ба он касе савор нашудааст. Бандашро кушода, онро ба ин ҷо биёред. ");
INSERT INTO tgk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Агар касе бипурсад, ки чаро ин корро мекунед, бигӯед, ки вай ба Худованд даркор шуд ва Ӯ ба зудӣ онро ба ҷояш бармегардонад». ");
INSERT INTO tgk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Он ду шогирд рафта, харкурраеро, ки дар канори кӯча, дар назди дарвозае баста шуда буд, ёфтанд. Вақте банди онро мекушоданд ");
INSERT INTO tgk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","баъзе аз одамони он ҷо истода пурсиданд: «Чӣ кор карда истодаед? Чаро банди харкурраро мекушоед?» ");
INSERT INTO tgk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Шогирдон суханони Исоро такрор карданд ва одамон ба онҳо иҷозат доданд. ");
INSERT INTO tgk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Пас онҳо харкурраро ба назди Исо оварда, ҷомаҳояшонро ба болои харкурра партофтанд ва Исо ба он савор шуд. ");
INSERT INTO tgk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Бисёр одамон ҷомаҳои худро сари роҳи Ӯ пойандоз мекарданд, дигарон бошанд, навдаҳои сербарги аз саҳро буридаашонро пеши роҳи Ӯ мегузоштанд. ");
INSERT INTO tgk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Мардуме, ки аз пешу қафои Ӯ мерафтанд, фарёд мезаданд: «Шаъну шараф ба Худо! Баракат ёбад касе, ки аз номи Худованд меояд! ");
INSERT INTO tgk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Муборак бошад подшоҳии аҷдоди мо Довуд, ки наздик омада истодааст! Шаъну шараф ба Худо дар осмон!» ");
INSERT INTO tgk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ҳамин тавр, Исо ба Ерусалим омада, ба Хонаи Худо рафт ва ҳама чизро аз назар гузаронд. Азбаски бевақт шуда буд, бо дувоздаҳ шогирди худ ба Байт-Ҳинӣ равона шуд. ");
INSERT INTO tgk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Рӯзи дигар, вақте ки онҳо аз Байт-Ҳинӣ мерафтанд, Исо гурусна монд. ");
INSERT INTO tgk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Каме дуртар дарахти сербарги анҷирро дида, ба сӯяш рафт. Ӯ мехост анҷире пайдо кунад, вале ба он наздик омада дид, ки дар шохаҳояш ғайр аз барг чизи дигаре набуд, чунки ҳанӯз вақти анҷир набуд. ");
INSERT INTO tgk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Сипас, Исо дарахти анҷирро лаънат карда гуфт: «Аз ин пас касе ҳаргиз аз ту дигар мева нахӯрад». Ва шогирдонаш инро шуниданд. ");
INSERT INTO tgk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ҳангоме ки ба Ерусалим даромаданд, Исо ба Хонаи Худо рафт ва онҳоеро, ки дар он ҷо машғули хариду фурӯш буданд, берун ронда, мизҳои пуливазкунандагон ва курсиҳои кабӯтарфурӯшонро чаппа кард. ");
INSERT INTO tgk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Вай нагузошт, ки касе чизеро барои савдо аз саҳни Хонаи Худо гузаронад. ");
INSERT INTO tgk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Сипас мардумро таълим дода гуфт: «Оё навишта нашудааст, ки „хонаи Ман ҷои дуогӯӣ барои тамоми халқҳо номида мешавад“? Шумо бошед, онро ба лонаи дуздон табдил додаед». ");
INSERT INTO tgk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Чун шариатдонон ва сардорони рӯҳонӣ ин суханонро шуниданд, роҳи чӣ тавр ба қатл расондани Исоро ҷустуҷӯ карданд. Онҳо аз Исо тарсиданд, зеро тамоми мардум аз таълимоти Ӯ дар ҳайрат монда буданд. ");
INSERT INTO tgk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Худи ҳамон бегоҳ Исо бо шогирдонаш аз шаҳр берун рафт. ");
INSERT INTO tgk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Саҳарии рӯзи дигар онҳо дар роҳ ҳамон дарахти анҷирро диданд, ки аз решааш хушк шудааст. ");
INSERT INTO tgk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Петрус ҳодисаи рӯзи гузаштаро ба ёд оварда гуфт: «Устод, нигоҳ кунед! Дарахти анҷир, ки онро лаънат кардед, хушк шудааст!» ");
INSERT INTO tgk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Исо дар ҷавоб гуфт: «Ба Худо имон дошта бошед. ");
INSERT INTO tgk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ба ростӣ ба шумо мегӯям, ки агар касе ба ин кӯҳ фармон дода гӯяд: „Бархезу ба баҳр биафт“ ва дар дилаш шубҳае надошта бошад, балки бовар кунад, ки он чӣ мегӯяд, ҳамон тавр мешавад, он гоҳ ҳамон чиз барояш рӯй медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Барои ҳамин ҳам ба шумо мегӯям, ҳар чӣ дар дуо талаб мекунед, бовар кунед, ки аллакай онро гирифтаед ва он аз они шумо мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Вале ҳангоми дуо кардан, агар аз касе хафагие дошта бошед, ӯро бубахшед, то ки Падари осмонӣ низ гуноҳҳоятонро ба шумо бахшида тавонад». ");
INSERT INTO tgk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Онҳо боз ба Ерусалим омаданд. Вақте ки Исо дар саҳни Хонаи Худо рафтуо мекард, сардорони рӯҳонӣ, шариатдонон ва пирони қавм назди Ӯ омада ");
INSERT INTO tgk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","пурсиданд: «Ту бо кадом ҳуқуқ ин корҳоро мекунӣ? Ин ҳуқуқро ба Ту кӣ додааст?» ");
INSERT INTO tgk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Исо дар ҷавоб гуфт: «Ман ба шумо саволе медиҳам. Агар ҷавоб диҳед, Ман ҳам ба шумо мегӯям, ки бо кадом ҳуқуқ ин корҳоро мекунам. ");
INSERT INTO tgk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ба Ман бигӯед, ки ҳуқуқи таъмиддиҳиро ба Яҳё Худо ё инсон дода буд?» ");
INSERT INTO tgk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Онҳо ба якдигар гуфтанд: «Агар бигӯем, ки Худо дода буд, Ӯ мегӯяд: „Пас чаро ба ӯ бовар накардед?“ ");
INSERT INTO tgk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Агар бигӯем: „Инсон“…», (онҳо аз мардум метарсиданд, зеро ҳамаи мардум имон доштанд, ки Яҳё пайғамбари Худост). ");
INSERT INTO tgk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Оқибат, онҳо ба Исо «намедонем» гуфта ҷавоб доданд. Исо низ ба онҳо гуфт: «Пас, Ман ҳам ба шумо намегӯям, ки бо кадом ҳуқуқ ин корҳоро мекунам». ");
INSERT INTO tgk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Баъд Исо ба мардум бо масалҳо гап заданро сар кард: «Марде токзоре бунёд карда, атрофи онро девор гирифт. Барои фишурдани ангур ҳавзчае тайёр карда, дидбонгоҳе сохт ва токзорро ба деҳқонон иҷора дода ба сафар баромад. ");
INSERT INTO tgk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Дар мавсими ҳосилғундорӣ соҳиби токзор хизматгорашро назди иҷоракорон фиристод, то ки ҳаққашро аз ҳосили боғ бигирад. ");
INSERT INTO tgk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Вале онҳо он хизматгорро гирифта заданду бо дасти холӣ баргардонданд. ");
INSERT INTO tgk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Соҳиби токзор хизматгори дигареро фиристод, вале онҳо ба сари вай зада, бо ӯ беномусона рафтор карданд. ");
INSERT INTO tgk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Баъд боз хизматгори дигареро фиристод, лекин ӯро куштанд. Бисёр хизматгорони дигареро ҳам, ки мефиристод, ё мезаданд, ё мекуштанд. ");
INSERT INTO tgk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ҳамин тавр, дар хонаи соҳиби токзор ба ғайр аз писари азизаш каси дигаре намонд. Оқибат, „писарамро ҳатман иззату эҳтиром мекунанд“ гуфта, писарашро фиристод. ");
INSERT INTO tgk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Вале иҷоракорон ба якдигар гуфтанд: „Вай меросхӯр аст! Биёед, ӯро мекушем ва токзор аз они мо мешавад!“ ");
INSERT INTO tgk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Сипас, ӯро дастгир карда куштанд ва ҷасадашро берун аз токзор партофтанд. ");
INSERT INTO tgk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Акнун соҳиби токзор чӣ кор мекунад? Мераваду он иҷоракоронро мекушад ва токзорро ба дигарон медиҳад. ");
INSERT INTO tgk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Оё шумо дар навиштаҷот нахондаед: „Он сангеро, ки бинокорон нодаркор ҳисоб карда, як сӯ партофтанд, санги асосии таҳкурсии бино гардид. ");
INSERT INTO tgk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ин кори Худованд аст ва ба назарамон аҷиб менамояд“». ");
INSERT INTO tgk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Азбаски роҳбарони халқ фаҳмиданд, ки Исо бо ин масал онҳоро мисол овардааст, хостанд Ӯро дастгир кунанд, вале аз мардум метарсиданд, бинобар ин Ӯро ба ҳоли худ гузошта рафтанд. ");
INSERT INTO tgk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Дертар чанд нафар аз фарисиён ва ҳиродиён ба назди Исо фиристода шуданд, то ки Ӯро бо сухан ба дом афтонанд. ");
INSERT INTO tgk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Онҳо омада гуфтанд: «Устод, мо медонем, ки Шумо ростқавл ҳастед ва хушомадгӯи мардум нестед, чунки ба мавқею дараҷаи онҳо эътибор намедиҳед, балки роҳҳои Худоро аз рӯи ҳақиқат таълим медиҳед. Ҳоло бигӯед, оё раво аст, ки мо ба императори Рум андозу хироҷ супорем ё не? ");
INSERT INTO tgk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Мо бояд онро супорем ё не?» Исо аз дурӯягии онҳо бохабар буда чунин гуфт: «Чаро мехоҳед Маро ба дом афтонед? Ба Ман динореро биёред, ки бубинам». ");
INSERT INTO tgk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Вақте динорро ба Ӯ доданд, пурсид: «Дар рӯи ин акс ва номи киро мебинед?» Онҳо ҷавоб доданд: «Императорро». ");
INSERT INTO tgk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Он гоҳ Исо ба онҳо гуфт: «Он чи аз они император аст, ба император бидиҳед ва он чи аз они Худост, ба Худо». Онҳо аз ҷавоби Исо дар ҳайрат монданд. ");
INSERT INTO tgk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Баъд баъзе аз саддуқиён (онҳо аз нав зиндашавиро инкор мекарданд) ба назди Исо омада пурсиданд: ");
INSERT INTO tgk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Устод, Мӯсо дар шариат ба мо чунин навиштааст, ки агар бародари касе фарзанд наёфта бимирад, бигзор вай зани ӯро ба никоҳи худ дарорад ва фарзандони ба дунё омадаро ҳамчун насли бародари марҳумаш бидонад. ");
INSERT INTO tgk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Инак, ҳафт бародар буданд. Бародари калонӣ зан гирифт ва бефарзанд мурд. ");
INSERT INTO tgk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Баъд бародари дуюм ҳамсари ӯро ба занӣ гирифта, ӯ ҳам бефарзанд мурд. Бо бародари сеюм ҳам ҳамин тавр рӯй дод. ");
INSERT INTO tgk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Бо ҳамин сурат ҳамаи ҳафт бародарон бефарзанд вафот карданд. Баъд аз ҳама он зан ҳам аз дунё гузашт. ");
INSERT INTO tgk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Пас, рӯзе, ки мурдаҳо аз нав зинда мешаванд, вай зани кадоме аз онҳо мешавад? Охир ҳамаи ҳафт бародарон ӯро ба занӣ гирифта буданд!» ");
INSERT INTO tgk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Исо ҷавоб дод: «Хатои шумо дар он аст, ки на мазмуни навиштаҷотро медонеду на қудрати Худоро. ");
INSERT INTO tgk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Вақте ки мурдаҳо зинда мешаванд, дигар на зан мегиранд ва на шавҳар мекунанд, балки мисли фариштаҳои осмон мегарданд. ");
INSERT INTO tgk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Вале дар бораи зинда шудани мурдаҳо магар аз китоби Мӯсо дар бораи ҳодиса бо бутта нахондаед, ки чӣ тавр Худо ба Мӯсо гуфтааст: „Ман Худои Иброҳим, Худои Исҳоқ ва Худои Ёқуб ҳастам“. ");
INSERT INTO tgk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ӯ на Худои мурдагон, балки Худои зиндагон аст. Шумо хатои калон мекунед». ");
INSERT INTO tgk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Яке аз шариатдонон ба назди онҳо омада баҳсу мунозираашонро шунид. Вақте ӯ дид, ки Исо ба онҳо чӣ ҷавоби хубе дод, пурсид: «Аз тамоми фармоишҳои Худо кадомаш аз ҳама муҳимтар аст?» ");
INSERT INTO tgk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Исо ҷавоб дод: «Аввалин фармоиши муҳим ин аст: „Эй қавми Исроил, гӯш кунед! Худованд Худои мо Худованди яккаву ягона аст. ");
INSERT INTO tgk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Худованд Худои худро бо тамоми дилу ҷонатон, бо тамоми ақлу ҳушатон ва бо тамоми қуввати худ дӯст бидоред“. ");
INSERT INTO tgk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Дуюмаш чунин мебошад: „Ҳар шахсеро, ки наздики шумост, мисли худ дӯст бидоред“. Ҳеҷ фармоише аз ҳардуи ин бузургтаре нест». ");
INSERT INTO tgk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Шариатдон гуфт: «Устод, ҳақ ба ҷониби Шумост. Шумо бисёр хуб гуфтед, ки фақат як Худо вуҷуд дорад ва ғайр аз Ӯ Худои дигаре нест. ");
INSERT INTO tgk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Инчунин, Худоро аз таҳти дил, бо тамоми ақлу ҳуш ва қуввати худ дӯст доштан ва шахси наздики худ бударо ҳам мисли худ дӯст доштан муҳимтар аз қурбон кардани ҷонвар ва дигар намудҳои қурбонӣ мебошад». ");
INSERT INTO tgk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Исо дид, ки шариатдон оқилона сухан меронад, бинобар ин ба ӯ гуфт: «Шумо ба подшоҳии Худо наздик ҳастед». Пас аз он дигар ҳеҷ кас ҷуръат накард, ки ба Исо саволе диҳад. ");
INSERT INTO tgk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Вақте Исо дар Хонаи Худо ба мардум таълим медод, аз онҳо пурсид: «Барои чӣ шариатдонон мегӯянд, ки Масеҳ, яъне Таъиншудаи Худо аз насли Довуд аст? ");
INSERT INTO tgk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Дар ҳоле ки худи Довуд бо таъсири Рӯҳи Муқаддас чунин гуфта буд: „Худованд ба Худованди ман фармуд: «То вақте ки душманонатро зери поят нагузорам, аз дасти ростам бишин»“. ");
INSERT INTO tgk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Худи Довуд Таъиншудаи Худоро „Худованд“ номид, пас чӣ тавр Вай аз насли Довуд шуда метавонад?» Мардуми зиёде суханони Ӯро бо хушнудӣ гӯш мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Сипас Исо онҳоро таълим дода гуфт: «Аз шариатдонон эҳтиёт бошед. Ба онҳо маъқул аст, ки либосҳои қимат пӯшида гарданд ва мардум дар бозорҳо ба онҳо салом диҳанд. ");
INSERT INTO tgk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Онҳо дӯст медоранд, ки дар ҷойҳои беҳтарини ибодатхонаҳо бишинанд ва дар тӯю зиёфатҳо бологузар бошанд. ");
INSERT INTO tgk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Онҳо намоишкорона дуру дароз дуо мехонанд, вале дар асл молу мулки бевазанонро хӯрда ғорат мекунанд! Онҳо ҷазои сахттар мебинанд». ");
INSERT INTO tgk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Баъд Исо рӯ ба рӯи сандуқи хайрия нишаста, ба сандуқ пул андохтани мардумро тамошо мекард. Баъзеҳо, ки бою бадавлат буданд, пули зиёде хайр мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ҳамин вақт як бевазани бечора ҳам омада, ду тангаи хурди мисинро, ки арзиши кам дошт, ба сандуқ андохт. ");
INSERT INTO tgk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Исо шогирдонашро ба наздаш даъват карда гуфт: «Ба ростӣ ба шумо мегӯям, ки ин бевазани бечора аз ҳамаи дигарон дида зиёдтар хайрот кард. ");
INSERT INTO tgk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Чунки онҳо аз зиёдатии бойигариашон хайрия карданд, вай бошад, ҳамаи он чизеро, ки дошт, тамоми ризқу рӯзиашро хайрия кард». ");
INSERT INTO tgk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Вақте Исо аз Хонаи Худо мебаромад, яке аз шогирдонаш гуфт: «Устод, бинед, ин биноҳои Хонаи Худо чӣ қадар боҳашамат ҳастанд! Чӣ сангҳои бузурге доранд!» ");
INSERT INTO tgk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Исо ҷавоб дод: «Шумо ҳоло ин биноҳои бузургро мебинед? Санг бар болои сангаш намонда, ҳамааш ба замин яксон мешавад». ");
INSERT INTO tgk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Вақте Исо дар болои теппаи Зайтун, рӯ ба рӯи Хонаи Худо менишаст, Петрус, Ёқуб, Юҳанно ва Андриёс дар танҳоӣ аз Ӯ пурсиданд: ");
INSERT INTO tgk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Ба мо бигӯед, ки ҳамаи ин воқеаҳо кай рӯй медиҳанд ва иҷро шудани ҳамаи инро аз кадом нишона мефаҳмем?» ");
INSERT INTO tgk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Исо ҷавоб дод: «Эҳтиёт шавед, ки мабодо касе шуморо гумроҳ накунад. ");
INSERT INTO tgk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Зеро бисёр касоне пайдо мешаванд, ки гӯё аз номи Ман омада бошанду „Ман ҳамонам“ мегӯянд ва бисёр одамонро гумроҳ мекунанд. ");
INSERT INTO tgk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Вақте ки садоҳо ва овозаҳои ҷангҳоро мешунавед, ба воҳима наафтед. Чунин ҳодисаҳо бояд рӯй диҳанд, вале ин маънои фаро расидани охирзамонро надорад. ");
INSERT INTO tgk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Як халқ бо халқи дигар ҷанг мекунад ва як давлат ба давлати дигар ҳуҷум мекунад. Дар бисёр ҷойҳо заминҷунбӣ рӯй дода, қаҳтию гуруснагӣ меояд. Ҳамаи ин монанди саршавии дарди зоидан аст. ");
INSERT INTO tgk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Худатонро эҳтиёт кунед, зеро шуморо ба назди қозӣ бурда, дар ибодатхонаҳо қамчинкорӣ мекунанд ва ба сабаби Маро пайравӣ карданатон шумо дар назди ҳокимону подшоҳон истода шаҳодат хоҳед дод. ");
INSERT INTO tgk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Пеш аз ҳама хушхабар бояд ба тамоми халқиятҳо эълон карда шавад. ");
INSERT INTO tgk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Вақте шуморо дастгир карда ба ҷавобгарӣ мекашанд, ташвиш накашед, ки чӣ бояд бигӯед. Ҳар чӣ ҳамон лаҳза ба дилатон андохта мешавад, бигӯед, чунки он вақт на шумо, балки Рӯҳи Муқаддас ба воситаи шумо сухан меронад. ");
INSERT INTO tgk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Бародар бародари худро ба қатл мефиристад ва инчунин падар фарзандони худро. Фарзандон ба падару модари худ муқобил мебароянд ва онҳоро ба дасти марг месупоранд. ");
INSERT INTO tgk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ба сабаби Маро пайравӣ карданатон ҳама шуморо бад мебинанд. Вале касе, ки то ба охир истодагарӣ намояд, наҷот хоҳад ёфт. ");
INSERT INTO tgk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Аммо вақте ки харобазори нафратангезеро дар ҷое мебинед, ки он набояд бошад (бигзор хонанда бифаҳмад, ки ин чӣ маъно дорад), он гоҳ онҳое, ки дар Яҳудия ҳастанд, бояд ба кӯҳистон гурезанд. ");
INSERT INTO tgk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Агар касе дар болои бом бошад, барои гирифтани чизе поён нафарояд ва ба хона надарояд. ");
INSERT INTO tgk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Агар касе дар саҳро бошад, барои гирифтани ҷома ҳам барнагардад. ");
INSERT INTO tgk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Вой бар ҳоли заноне, ки он рӯзҳо ҳомиладор хоҳанд буд ва модароне, ки кӯдаки ширхор хоҳанд дошт! ");
INSERT INTO tgk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Пас дуо кунед, ки ин ҳодиса ба зимистон рост наояд. ");
INSERT INTO tgk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Зеро дар он айём чунон мусибате рӯй медиҳад, ки аз замони дунёро офаридани Худо то ба ҳол чунин нашуда буд ва дигар ҳаргиз нахоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Агар Худованд он рӯзҳои мусибатро кӯтоҳ намекард, дар рӯи замин ягон инсон зинда намемонд. Вале ба хотири интихобкардагонаш Худованд он рӯзҳоро кӯтоҳ кардааст. ");
INSERT INTO tgk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Агар ҳамон вақт касе ба шумо гӯяд, ки „Ана, Таъиншудаи Худо дар ин ҷост“ ва ё „Нигоҳ кунед, Ӯ дар он ҷост“, ба суханонаш бовар накунед. ");
INSERT INTO tgk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Зеро одамоне пайдо мешаванд, ки худро бардурӯғ Таъиншудаи Худо ва пайғамбар меноманд ва чунин мӯъҷизаҳову аҷоибот нишон медиҳанд, то ки агар шавад интихобшудагони Худоро гумроҳ кунанд. ");
INSERT INTO tgk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Инак, бохабар бошед. Ана Ман ҳамаашро ба шумо пешакӣ гуфтам. ");
INSERT INTO tgk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Дар ҳамон рӯзҳо, баъд аз он мусибатҳо, офтоб тира мегардад ва моҳ дигар равшанӣ намедиҳад, ");
INSERT INTO tgk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ситораҳо аз осмон поён меафтанд ва ҳама чиз дар осмон ба ҷунбиш меояд. ");
INSERT INTO tgk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Он вақт мардум Фарзанди Инсонро мебинанд, ки болои абрҳо бо қудрату ҷалоли бузург меояд. ");
INSERT INTO tgk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ӯ фариштаҳояшро мефиристад, то интихобкардагонашро аз чор тарафи дунё ва аз тамоми гӯшаву канори замину осмон гирд оваранд. ");
INSERT INTO tgk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Аз дарахти анҷир ибрат гиред. Ҳамин ки шохаҳояш муғча карда барг бароварданро сар кунанд, шумо аниқ медонед, ки ба қарибӣ тобистон меояд. ");
INSERT INTO tgk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ҳамин тавр, вақте мебинед, ки ин ҳодисаҳо ба амал меоянд, донед, ки вақт наздик, дар дами остона аст. ");
INSERT INTO tgk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ба ростӣ ба шумо мегӯям, ки ҳанӯз одамони ин насл аз олам нагузашта, ҳамаи ин ҳодисаҳо ба амал меоянд. ");
INSERT INTO tgk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Замину осмон нест мешаванд, аммо гуфтаҳои Ман то абад мемонанд. ");
INSERT INTO tgk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Лекин кай фаро расидани он рӯз ё он соатро ғайр аз Падар касе намедонад: на фариштаҳои осмон на Писар. ");
INSERT INTO tgk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Пас, ҳушёру бохабар бошед, зеро намедонед, ки он вақт кай фаро мерасад. ");
INSERT INTO tgk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ин монанди он аст, ки марде ба сафар рафта, барои ҳар як хизматгори худ вазифаи махсусе медиҳад ва ба дарвозабон мефармояд, ки посбонӣ кунад. ");
INSERT INTO tgk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Пас шумо низ ҳушёр бошед, чун намедонед, ки соҳиби хона кай бармегардад, бегоҳӣ ё нимаи шаб, вақти ҷеғзании хурӯс ё бомдодон. ");
INSERT INTO tgk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Мабодо ӯ ногаҳон баргашта шуморо дар хоб наёбад. ");
INSERT INTO tgk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Он чӣ ба шумо мегӯям ба ҳама дахл дорад: ҳушёр бошед!» ");
INSERT INTO tgk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","То иди Балогардон ва иди Фатир ду рӯз монда буд. Сардорони рӯҳонӣ ва шариатдонон роҳи бо ҳила дастгир карда, ба қатл расондани Исоро ҷустуҷӯ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Онҳо мегуфтанд: «Дар рӯзҳои ид ин корро кардан мумкин нест. Шояд одамон шӯриш мебардоранд». ");
INSERT INTO tgk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Исо дар Байт-Ҳинӣ, дар хонаи Шимъӯн ном махав меҳмон шуда буд. Дар вақти таомхӯрӣ зане омад ва як кӯзачаи сангини гаронбаҳоро пур аз атри қиматбаҳо оварда, онро шикасту ба сари Исо рехт. ");
INSERT INTO tgk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Баъзеҳо аз ин кори зан ба ғазаб омада, ба якдигар гуфтанд: «Чаро ӯ ин атри пурқиматро исроф кард? ");
INSERT INTO tgk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ин атрро ба маблағи зиёда аз сесад динор фурӯхта, пулашро ба камбағалон тақсим кардан мумкин буд». Ва занро сахт сарзаниш мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Вале Исо гуфт: «Ӯро ба ҳолаш гузоред, чаро ӯро ташвиш медиҳед? Вай бароям кори калон кард. ");
INSERT INTO tgk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Камбағалон ҳамеша бо шумо ҳастанд ва ҳар вақт, ки хоҳед, шумо метавонед ба онҳо ёрӣ кунед, вале Ман бо шумо ҳамеша намемонам. ");
INSERT INTO tgk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ин зан ҳар чӣ аз дасташ омад, кард. Ӯ атрро ба баданам рехт, то онро барои гӯронидан тайёр намояд. ");
INSERT INTO tgk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ба ростӣ ба шумо мегӯям, дар ҳар гӯшаву канори дунё, ки хушхабар эълон карда мешавад, кори кардаи ин занро барои ба ёд овардани ӯ нақл хоҳанд кард». ");
INSERT INTO tgk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Он гоҳ яке аз дувоздаҳ шогирдони Исо, ки номаш Яҳудои Исқарют буд, ба назди сардорони рӯҳонӣ рафт, то Исоро ба онҳо таслим кунад. ");
INSERT INTO tgk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Онҳо аз шунидани ин хеле хушҳол шуда, ба ӯ пул ваъда карданд. Пас, Яҳудо фурсати қулай меҷуст, то ки Исоро ба дасти онҳо бисупорад. ");
INSERT INTO tgk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Рӯзи аввали иди Фатир, ки мардум барраи балогардонро қурбонӣ мекарданд, шогирдон аз Исо пурсиданд: «Дар куҷо мехоҳед, ки мо рафта бароятон дастархони иди Балогардонро тайёр намоем?» ");
INSERT INTO tgk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Исо ду нафар шогирдашро фиристода гуфт: «Ба шаҳр равед ва мардеро мебинед, ки кӯзаи об мебарад. Аз паси ӯ биравед. ");
INSERT INTO tgk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ба ҳамон хонае, ки он мард медарояд, шумо ҳам дароед ва ба соҳиби хона бигӯед: „Устод мепурсад, ки куҷост меҳмонхонаи ӯ, ки дар он ҳамроҳи шогирдонаш хӯроки иди Балогардонро хӯрда тавонад?“ ");
INSERT INTO tgk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Вай ба шумо болохонаи калонеро нишон медиҳад, ки аллакай ғундошта ба тартиб оварда шудааст ва шумо дар ҳамон ҷо бароямон дастархон тайёр кунед». ");
INSERT INTO tgk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Пас шогирдон ба шаҳр рафтанду ҳамон тавре, ки Исо гуфта буд, шуд ва онҳо хӯроки иди Балогардонро тайёр намуданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Бегоҳирӯзӣ Исо бо дувоздаҳ шогирдаш омад. ");
INSERT INTO tgk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Вақте ки дар гирди дастархон нишаста хӯрок мехӯрданд, Исо гуфт: «Ба ростӣ ба шумо мегӯям, яке аз шумо, ки ҳоло бо Ман хӯрок хӯрда истодааст, ба Ман хиёнат мекунад». ");
INSERT INTO tgk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Онҳо хеле ғамгин шуда, пайдарҳам ба пурсидан даромаданд: «Мабодо ин ман набошам?» ");
INSERT INTO tgk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Исо ҷавоб дод: «Ин корро яке аз дувоздаҳ нафари шумо мекунад, ки луқмаи нонашро бо Ман дар як коса тар карда истодааст. ");
INSERT INTO tgk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Бо Фарзанди Инсон он чӣ дар навиштаҷот дар борааш навишта шудааст, рӯй медиҳад. Аммо вой бар ҳоли он касе, ки ба Фарзанди Инсон хиёнат мекунад. Барои вай беҳтар мешуд, ки ҳаргиз ба дунё наояд». ");
INSERT INTO tgk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ҳангоме ки онҳо мехӯрданд Исо нонро ба даст гирифта, шукри Худоро карду онро пора карда ба онҳо тақсим намуду гуфт: «Бигиред, ки ин бадани Ман аст». ");
INSERT INTO tgk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Пас косаро гирифта, шукри Худоро карду онро ба шогирдонаш дод ва ҳамаи онҳо аз он нӯшиданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Исо ба онҳо гуфт: «Ин хуни Ман аст, ки барои тасдиқ кардани аҳди Худо ба хотири одамони зиёде рехта мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ба ростӣ ба шумо мегӯям, ки акнун Ман аз меваи нави токи ангур фақат дар подшоҳии Худо хоҳам нӯшид, лекин то он рӯз ҳаргиз наменӯшам». ");
INSERT INTO tgk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Баъд онҳо Худоро ҳамду саногӯён ба теппаи Зайтун равона шуданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Пас Исо ба шогирдон гуфт: «Ҳамаи шумо пайравӣ кардани Маро бас мекунед, чунки дар навиштаҷот пешгӯйии Худо омадааст: „Чӯпонро мекушам ва гӯсфандони рама пароканда мешаванд“. ");
INSERT INTO tgk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Аммо, вақте ки аз нав зинда мешавам, пешопеши шумо ба вилояти Ҷалил меравам». ");
INSERT INTO tgk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Петрус гуфт: «Ҳарчанд ки ҳама пайравӣ кардани Шуморо бас кунанд ҳам, ман ин корро намекунам». ");
INSERT INTO tgk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Исо ба вай гуфт: «Ба ростӣ ба ту мегӯям, имрӯз, худи ҳамин шаб, ҳанӯз хурӯс ду бор ҷеғ назада, ту се бор Маро инкор мекунӣ». ");
INSERT INTO tgk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Вале Петрус бо қатъият гуфт: «Ҳатто агар ҳамроҳи Шумо ҷон додан лозим ояд, ҳаргиз Шуморо инкор намекунам». Дигарон низ чунин гуфтанд. ");
INSERT INTO tgk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Онҳо ба ҷое рафтанд, ки Ҷатсамон ном дошт ва Ӯ ба шогирдонаш гуфт: «Шумо дар ин ҷо бошед, Ман рафта дуо мекунам». ");
INSERT INTO tgk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ӯ бо худ Петрус, Ёқуб ва Юҳанноро бурд. Ғаму аламаш сахт шиддат меёфт ва ");
INSERT INTO tgk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ӯ ба онҳо гуфт: «Аз шиддати ғаму ғусса ҷонам ба лаб расидааст. Ин ҷо бимонеду бедор бошед». ");
INSERT INTO tgk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Инро гуфта Исо каме дуртар рафт ва худро рӯи замин партофта дуо кард, ки агар шавад он вақти азоб ба сараш наояд. ");
INSERT INTO tgk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Сипас гуфт: «Эй Падарҷон, бароят ҳама чиз имконпазир аст. Ин косаи азобро аз сари Ман дур кун. Аммо на хости Ман, хости Ту шавад». ");
INSERT INTO tgk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Баъд баргашта дид, ки шогирдонаш хобидаанд. Ӯ ба Петрус гуфт: «Шимъӯн, ту хобидаӣ? Магар як соат бедор истода натавонистӣ? ");
INSERT INTO tgk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Бедор бимонед ва дуо кунед, то ки ба васваса наафтед. Чунки рӯҳатон ба ин тайёр аст, аммо табиати инсониатон нотавон». ");
INSERT INTO tgk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Пас, боз рафта бо ҳамон суханони пештарааш дуо кард. ");
INSERT INTO tgk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Бори дигар баргашта омаду онҳоро боз дар хоб дид, чунки онҳо сахт хоболуд буданд ва намедонистанд, ки ба Исо чӣ ҷавоб диҳанд. ");
INSERT INTO tgk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Вай бори сеюм баргашта, ба онҳо гуфт: «Шумо ҳанӯз хоб рафта дам мегиред? Бас, акнун соати он расидааст, ки Фарзанди Инсон ба дасти гунаҳкорон таслим карда мешавад. ");
INSERT INTO tgk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Биёед, бархезед, меравем. Нигоҳ кунед, ана таслимкунандаи Ман ҳам наздик омад». ");
INSERT INTO tgk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Якбора, ҳанӯз Ӯ суханашро тамом накарда, Яҳудо, яке аз дувоздаҳ шогирдаш расида омад ва ҳамроҳаш як тӯда одамони чӯбу шамшер дар даст аз ҷониби сардорони рӯҳонӣ, шариатдонон ва пирони қавм буданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Инак, хиёнаткор ба онҳо пешакӣ чунин шарт карда буд: «Бидонед, касеро, ки бӯсидам, ҳамон шахсест, ки бояд дастгир кунеду таҳти назорат гирифта баред». ");
INSERT INTO tgk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Яҳудо дарҳол ба Исо наздик шуду «Устод!» гуфта, Ӯро бӯсид. ");
INSERT INTO tgk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Пас онҳо Исоро дастгир карданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ҳамон замон як нафар аз ҳозирон шамшерро аз ғилоф кашиду ба сӯи ғуломи сарвари рӯҳониён ҳамла карда, гӯши вайро бурида партофт. ");
INSERT INTO tgk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Он гоҳ Исо ба онҳо гуфт: «Шумо магар Маро роҳзан гумон мебаред, ки барои дастгир карданам бо чӯбу шамшерҳо омадаед? ");
INSERT INTO tgk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ман ҳар рӯз бо шумо дар Хонаи Худо будам ва таълим медодам, аммо шумо Маро дастгир намекардед. Вале, бигзор гуфтаҳои навиштаҷот ба амал оянд». ");
INSERT INTO tgk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ҳамон вақт ҳамаи шогирдонаш Ӯро танҳо гузошта гурехтанд. ");
INSERT INTO tgk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Як ҷавоне аз паси Исо рафт, ки дар танаш ҳеҷ чиз надошту фақат бо матои катонӣ худро печонда буд. Вақте сарбозон Ӯро дастгир карданд, ");
INSERT INTO tgk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","вай халос хӯрду матои катонӣ дар дасти онҳо монд, худаш тани бараҳна гурехт. ");
INSERT INTO tgk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Исоро ба хонаи сарвари рӯҳониён бурданд. Ҳамаи сардорони рӯҳонӣ, шариатдонон ва пирони қавм дар он ҷо ҷамъ шуданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Петрус ҳам, ки дуртар аз паси онҳо меомад, ба ҳавлии сарвари рӯҳониён даромада, дар назди хизматгорон нишаст, то ки дар оташи гулхан гарм шавад. ");
INSERT INTO tgk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Сардорони рӯҳонӣ ва ҳамаи аъзоёни шӯро кӯшиш мекарданд, ки бар зидди Исо далеле ба даст оварда, Ӯро ба қатл расонанд, вале ҳеҷ далеле пайдо накарданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Бисёриҳо бар зидди Исо шаҳодати дурӯғ доданд, аммо гуфтаҳояшон ба ҳам мувофиқ намеомад. ");
INSERT INTO tgk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Баъзеҳо аз ҷо бархеста, ба Исо чунин тӯҳматҳо карданд: ");
INSERT INTO tgk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Мо шунидем, ки Ӯ мегуфт: „Ман ин Хонаи Худоро, ки бо дасти инсон сохта шудааст, вайрон мекунам ва баъд аз се рӯз дигаре бе кӯмаки инсон месозам“». ");
INSERT INTO tgk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Вале шаҳодати онҳо бар хилофи якдигар буд. ");
INSERT INTO tgk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Он вақт сарвари рӯҳониён дар ҳузури ҳама бархеста, аз Исо пурсид: «Ин чӣ айбномаҳое, ки бар зидди Ту шаҳодат медиҳанд? Чаро Ту ҳеҷ ҷавобе намедиҳӣ?» ");
INSERT INTO tgk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Аммо Исо хомӯш истода, ҳеҷ ҷавобе надод. Сарвари рӯҳониён боз пурсид: «Магар Ту Таъиншуда ва Писари Худое ҳастӣ, ки ба Ӯ ҳамду сано мехонем?» ");
INSERT INTO tgk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Исо гуфт: «Ҳастам ва рӯзе Фарзанди Инсонро мебинед, ки аз тарафи рости Худои Пурқудрат нишаста дар рӯи абрҳои осмон меояд». ");
INSERT INTO tgk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Он гоҳ сарвари рӯҳониён либосашро дарронда гуфт: «Дигар ба мо ҳеҷ шоҳиде лозим ҳам нест! ");
INSERT INTO tgk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Худатон шунидед, ки Ӯ суханони кофирона гуфт. Ба чӣ қарор меоед?» Пас ҳамаи онҳо Ӯро айбдор карда, ба марг маҳкум намуданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Баъд баъзеҳо ба туф кардан ба Исо даромаданд. Онҳо чашмони Ӯро баста, ба рӯяш торсакӣ зада мепурсиданд: «Агар пайғамбар бошӣ, бигӯй, ки Туро кӣ зад?» ва сарбозон ҳам Ӯро бурда заданд. ");
INSERT INTO tgk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Петрус ҳоло ҳам дар ҳавлӣ назди гулхан нишаста, худро гарм мекард. Ҳамин вақт яке аз канизакони сарвари рӯҳониён ӯро дид ва ба ӯ бо диққат нигоҳ карда гуфт: «Ту ҳам ҳамроҳи Исои Носирӣ будӣ!» ");
INSERT INTO tgk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Петрус инро инкор карду «Намедонам ва намефаҳмам, ки чӣ мегӯӣ» гуфта, ба тарафи дигари ҳавлӣ гузашт. ");
INSERT INTO tgk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Канизак Петрусро бори дигар дид ва ба ҳозирбудагон гуфт: «Ин мард ҳам яке аз шарикони Исо аст!» ");
INSERT INTO tgk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Петрус инро боз инкор кард. Дертар ҳозирбудагон ба Петрус гуфтанд: «Аниқ ту шарики онҳоӣ, чунки ҷалилӣ ҳастӣ!» ");
INSERT INTO tgk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Петрус бошад, ба сараш лаънатҳо хонда, қасам хӯрда гуфт: «Ин одамеро, ки дар борааш мегӯед, намешиносам». ");
INSERT INTO tgk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Худи ҳамон лаҳза хурӯс бори дуюм ҷеғ зад ва Петрус суханони Исоро ба ёд овард, ки гуфта буд: «Пеш аз он ки хурӯс ду бор ҷеғ занад, ту се бор Маро инкор мекунӣ». Он гоҳ Петрус худро дошта натавониста ба гиря даромад. ");
INSERT INTO tgk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Саҳарии барвақт сардорони рӯҳонӣ, пирони қавм бо шариатдонон ва тамоми аъзоёни шӯро дар маҷлис ба як қарор омаданд. Онҳо Исоро баста, ба назди ҳокими румӣ Пилотус фиристоданд ва ба дасти ӯ супориданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Пилотус аз Исо пурсид: «Оё Ту Шоҳи Яҳудиён ҳастӣ?» Исо ҷавоб дод: «Ҳамон тавре ки худатон мегӯед». ");
INSERT INTO tgk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Сардорони рӯҳонӣ Исоро аз бисёр ҷиҳат айбдор мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Пилотус аз Ӯ пурсид: «Чаро ҷавоб намедиҳӣ? Бубин, Туро чӣ қадар айбдор мекунанд». ");
INSERT INTO tgk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Вале Исо боз ҳам чизе нагуфт ва Пилотус дар ҳайрат монд. ");
INSERT INTO tgk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Аз рӯи одат Пилотус дар ҳар ҷашнгирии ин ид як нафар маҳбусеро, ки мардум талаб мекард, озод менамуд. ");
INSERT INTO tgk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Дар он вақт Бараббос ном марде, ки бо шариконаш дар шаҳр шӯриш бардошта одам кушта буд, дар ҳабс менишаст. ");
INSERT INTO tgk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Мардум хоҳиш карданд, ки Пилотус мисли ҳарсола як нафар маҳбусро озод кунад. ");
INSERT INTO tgk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Пилотус пурсид: «Мехоҳед, ки Шоҳи Яҳудиёнро бароятон озод кунам?» ");
INSERT INTO tgk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Чун мефаҳмид, ки сардорони рӯҳонӣ Исоро аз рӯи ҳасад ба дасти ӯ супорида буданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Вале сардорони рӯҳонӣ мардумро ба ошӯб оварданд, то ба ивази Исо озод кардани Бараббосро талаб кунанд. ");
INSERT INTO tgk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Пилотус боз аз онҳо пурсид: «Пас, бо он касе, ки шумо Ӯро Шоҳи Яҳудиён меномед, чӣ кор кунам?» ");
INSERT INTO tgk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Онҳо фарёд заданд: «Ба салиб мехкӯб кунед!» ");
INSERT INTO tgk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Пилотус гуфт: «Чаро? Охир Вай чӣ бадие кардааст?» Лекин онҳо боз баландтар фарёд заданд: «Ӯро мехкӯб кунед!» ");
INSERT INTO tgk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Пилотус танҳо барои қонеъ гардондани талаботи халқ Бараббосро барояшон озод карда, фармон дод, ки Исоро қамчинкорӣ намуда, ба салиб мехкӯб кунанд. ");
INSERT INTO tgk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Сарбозон Исоро ба ҳавлии дарбор бурда, аскарони зиёдро ҷамъ карданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Баъд ба Исо ҷомаи бунафшранг пӯшонданд ва аз хор тоҷе бофта, ба сараш гузоштанд. ");
INSERT INTO tgk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ба Ӯ таъзим карда фарёд мезаданд: «Зинда бод Шоҳи Яҳудиён!» ");
INSERT INTO tgk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Онҳо бо чӯб ба сараш мезаданд, ба Ӯ туф мекарданд ва дар наздаш ба зону истода, ба Ӯ саҷда менамуданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Вақте ки онҳо масхара додани Ӯро бас карданд, ҷомаи бунафшрангро аз танаш кашида, либоси худашро пӯшонданд ва барои ба салиб мехкӯб кардан Ӯро аз он ҷо берун бурданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Дар роҳ онҳо бо як роҳгузари қуриние вохӯрданд, ки аз саҳро бармегашт. Он мард Шимъӯн ном дошт ва падари Искандару Руфис буд. Сарбозон ӯро маҷбур карданд, ки чӯби салиби Исоро бардошта барад. ");
INSERT INTO tgk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Баъд Исоро ба ҷое оварданд, ки Ҷолҷото, яъне «Ҷои косахонаи сар» ном дошт. ");
INSERT INTO tgk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Сарбозон ба Ӯ майи бо мӯр омехтаро доданд, вале Ӯ онро қабул накард. ");
INSERT INTO tgk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Он гоҳ Исоро ба рӯи салиб мехкӯб карданду либосашро байни худ тақсим карданӣ шуда, бо партофтани қуръа соҳибшавандаи онро муайян карданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Соати нӯҳи саҳар буд, ки Ӯро рӯи салиб мехкӯб карданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Дар лавҳаи айбнома бар зидди Исо навиштанд: «Шоҳи Яҳудиён». ");
INSERT INTO tgk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ҳамроҳи Исо боз ду дуздро аз тарафи чапу росташ ба салибҳои дигар мехкӯб карданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Одамоне, ки аз он ҷо мегузаштанд, сар ҷунбонда Исоро мазоқ карда мегуфтанд: «Ту-ку мехостӣ Хонаи Худоро вайрон карда, дар муддати се рӯз онро аз нав созӣ, ");
INSERT INTO tgk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","пас, ҳоло аз салиб поён фаромада, худатро наҷот деҳ?» ");
INSERT INTO tgk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Сардорони рӯҳонӣ ва шариатдонон низ Ӯро масхаракунон ба якдигар мегуфтанд: «Дигаронро наҷот медоду худашро наҷот дода наметавонад. ");
INSERT INTO tgk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Бигузор Таъиншудаи Худо, ки Шоҳи Яҳудиён аст, акнун аз салиб поён фарояд, то мо инро дида, имон оварем!» Ҳатто онҳое, ки ҳамроҳаш мехкӯб шуда буданд, Ӯро таҳқир мекарданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Нисфирӯзӣ ҳама ҷоро торикӣ фаро гирифт ва он то соати се давом кард. ");
INSERT INTO tgk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Дар соати се Исо бо садои баланд фарёд зад: «Элла! Элла! Лама сабақтанӣ?», яъне «Эй Худои Ман! Эй Худои Ман! Чаро Маро тарк кардӣ?» ");
INSERT INTO tgk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Баъзе аз ҳозирон инро шунида, гуфтанд, ки Исо Илёс пайғамбарро садо мекунад. ");
INSERT INTO tgk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Сипас як нафар давида латтаеро ба сирко тар кард ва ба сари як чӯб гузошту барои нӯшидан ба Исо дароз кард ва гуфт: «Истед, бинем-чи, оё Илёс омада, Ӯро аз салиб гирифта поён мефарорад ё не?!» ");
INSERT INTO tgk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Баъд Исо нолаи баланде карда ҷон дод. ");
INSERT INTO tgk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Худи ҳамин вақт пардае, ки ҷои муқаддастарини Хонаи Худоро ҷудо мекард, аз боло то ба поёнаш дарида, ду пора шуд. ");
INSERT INTO tgk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Вақте сардори лашкари румии дар рӯ ба рӯи салибистода дид, ки Исо чӣ тавр фарёд зада ҷон дод, гуфт: «Дар ҳақиқат ин мард Писари Худо буд!» ");
INSERT INTO tgk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Чанд зан ҳам он ҷо буданд, ки аз дур ин ҳодисаҳоро медиданд. Дар байни онҳо Марями Маҷдалия, Салӯмит ва Марям, ки модари Ёқуби хурдсол ва Юшо буд, низ ҳузур доштанд. ");
INSERT INTO tgk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Онҳо дар Ҷалил Исоро пайравӣ мекарданд ва дар эҳтиёҷаш кӯмак мерасонданд. Бисёр занони дигар низ, ки ҳамроҳи Ӯ ба Ерусалим омаданд, дар он ҷо буданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Шом шуд ва мардум ба рӯзи истироҳат тайёрӣ медиданд. ");
INSERT INTO tgk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Юсуф ном шахс аз шаҳри Аромот, ки аъзои обрӯманди шӯро буд ва омадани подшоҳии Худоро интизорӣ мекашид, боҷуръат ба назди Пилотус рафт ва ҷасади Исоро талаб кард. ");
INSERT INTO tgk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Пилотус ҳайрон шуд, ки Исо ба ин зудӣ мурдааст, бинобар ин сардори лашкарро даъват карда, аз ӯ пурсид, ки оё Исо аллакай мурдааст. ");
INSERT INTO tgk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Вақте он сардори лашкар тасдиқ кард, Пилотус ҷасади Исоро ба Юсуф супорид. ");
INSERT INTO tgk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Юсуф суфи сафед харид ва ҷасадро аз салиб поён фароварда, кафанпеч карду ба даруни қабре, ки дар ғоре канда шуда буд, гузошт. Баъд санги калонеро ба даромади қабр ғелонда, онро маҳкам кард. ");
INSERT INTO tgk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Марями Маҷдалия ва Марям, модари Юшо диданд, ки ҷасад ба куҷо гузошта шуд. ");
INSERT INTO tgk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Вақте ки рӯзи истироҳат ба охир расид, Марями Маҷдалия, Марям, ки модари Ёқуб буд ва Салӯмит рафта, равғани хушбӯй хариданд, то ки ба бадани Исо бимоланд. ");
INSERT INTO tgk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ва саҳарии барвақти рӯзи якшанбе, баъд аз баромадани офтоб ба сӯи қабр раҳсипор шуданд. ");
INSERT INTO tgk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Дар роҳ ба якдигар мегуфтанд: «Кӣ санги калонро аз даромади қабр барои мо мебардорад?» ");
INSERT INTO tgk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Вақте ки назди қабр расиданд, диданд, ки он санги бениҳоят калони қабр як сӯ ғелонда шудааст. ");
INSERT INTO tgk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Пас ба даруни қабр даромада диданд, ки як ҷавоне бо либоси сафед дар тарафи рост нишастааст. Занон ба ҳайрат афтоданд. ");
INSERT INTO tgk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Вале ҷавон ба онҳо гуфт: «Ҳайрон нашавед! Шумо Исои Носирии ба салиб мехкӯбшударо меҷӯед. Вай аз нав зинда шуд ва дар ин ҷо нест! Ба ҷое, ки ҷасадашро гузошта буданд, нигоҳ кунед! ");
INSERT INTO tgk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ҳоло рафта, ба шогирдонаш ва ба Петрус бигӯед, ки Исо пешопеши шумо ба Ҷалил меравад, то шуморо дар он ҷо бубинад, чунон ки ба шумо гуфта буд». ");
INSERT INTO tgk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Занҳо тарсону ларзон берун баромада, аз назди қабр гурехтанд ва ба касе чизе нагуфтанд, чунки дар ҳарос буданд.  ");
INSERT INTO tgk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Исо субҳи рӯзи якшанбе аз нав зинда шуд ва аввал ба Марями Маҷдалия, ки аз вуҷуди ӯ ҳафт девро берун карда буд, худро зоҳир кард. ");
INSERT INTO tgk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Марям назди шогирдони гирёну мотамзада рафта ин хабарро гуфт. ");
INSERT INTO tgk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Вале онҳо суханони ӯро шунида, бовар накарданд, ки Исо зинда асту Марям Ӯро дидааст. ");
INSERT INTO tgk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Баъд Исо худро дар сурати дигар ба ду шогирдаш, ки ба деҳа мерафтанд, зоҳир кард. ");
INSERT INTO tgk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Онҳо баргашта, инро ба дигарон нақл намуданд, аммо ҳеҷ кас ба суханони онҳо бовар накард. ");
INSERT INTO tgk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Дар охир Исо ба он ёздаҳ шогирдаш, дар вақти хӯрок хӯрданашон, зоҳир шуд ва онҳоро ба сабаби беимонӣ ва якравиашон сарзаниш кард, зеро ба суханони касоне, ки Ӯро баъд аз марг зинда дида буданд, бовар накарданд. ");
INSERT INTO tgk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Баъд ба онҳо гуфт: «Ба тамоми дунё рафта, хушхабарро ба ҳама эълон бикунед! ");
INSERT INTO tgk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Касоне, ки имон биоваранд ва таъмид бигиранд, наҷот меёбанд, вале касоне, ки имон наоваранд, маҳкум мешаванд. ");
INSERT INTO tgk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Дар ҳаёти касоне, ки имон меоваранд, чунин аломатҳо пайдо мешаванд: онҳо бо номи Ман девҳоро меронанд ва бо забонҳои нав сухан мегӯянд; ");
INSERT INTO tgk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","онҳо морҳоро бо даст мегиранд ва агар заҳр хӯранд, зараре намебинанд; даст бар беморон мегузоранд ва онҳо шифо меёбанд». ");
INSERT INTO tgk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Вақте ки сӯҳбати Исои Худованд бо онҳо тамом шуд, Вай ба сӯи осмон бурда шуд ва аз тарафи рости Худо нишаст. ");
INSERT INTO tgk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Шогирдон рафта, хушхабарро дар ҳама ҷо эълон мекарданд. Худованд ҳам мададгори онҳо буд ва бо мӯъҷизаҳое, ки онҳо нишон медоданд, гуфтаҳояшонро тасдиқ мекард. Омин.  ");
INSERT INTO tgk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Теофилуси мӯҳтарам! Бисёр касон ботартиб навиштани воқеаҳоеро сар карданд, ки дар байни мо ба амал омада буданд. Онҳо аз рӯи нақлҳое тартиб медиҳанд, ки шоҳидону хизматчиёни аввалини Хушхабар ба мо расондаанд. Аз ин рӯ, ман ҳам ин воқеаҳоро аз аввал бодиққат тадқиқ карда, дуруст донистам, ки онҳоро як-як ба шумо бинависам, ");
INSERT INTO tgk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","то дуруст будани таълимотеро, ки аз он хабар ёфтаед, бидонед. ");
INSERT INTO tgk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Дар замони ҳукмронии Ҳиродус ном подшоҳи сарзамини Яҳудия рӯҳоние зиндагӣ мекард, ки аз авлоди Абиёи рӯҳонӣ буд. Вай Закарё ном дошт ва занашро, ки аз авлоди Ҳоруни рӯҳонӣ буд, Элисобат меномиданд. ");
INSERT INTO tgk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ин зану шавҳар дар назари Худо беайб буданд ва тамоми фармону қонунҳои Худовандро пурра ба ҷо меоварданд. ");
INSERT INTO tgk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Онҳо ягон фарзанд надоштанд, чунки Элисобат зани нозой буд, ғайр аз ин ҳардуяшон аллакай пир шуда буданд. ");
INSERT INTO tgk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Рӯзе навбати хизмат ба гурӯҳи Закарё расид ва ӯ ҳамчун рӯҳонӣ дар пеши Худо машғули иҷрои вазифааш шуд. ");
INSERT INTO tgk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Барои муайян кардани касе, ки мувофиқи расми рӯҳониён ба Хонаи Худованд даромада, ширеши хушбӯйро месӯзонад, қуръа партофта шуд ва он ба номи Закарё афтид. ");
INSERT INTO tgk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Вақте ки Закарё машғули сӯзондани ширеши хушбӯй буд, тамоми мардум дар берун истода дуо мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Баногоҳ ба Закарё фариштаи Худованд зоҳир шуд, ки дар тарафи рости қурбонгоҳи ширеши хушбӯй меистод. ");
INSERT INTO tgk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ҳамин ки Закарё ӯро дид, беқарор шуд ва вуҷудашро воҳима зер кард. ");
INSERT INTO tgk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Аммо фаришта ба ӯ гуфт: «Ҳой Закарё, натарс. Дуоят ба даргоҳи Худо қабул шуд. Ҳамсарат Элисобат писаре хоҳад зоид ва ту ӯро Яҳё ном хоҳӣ гузошт. ");
INSERT INTO tgk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Шодиву хурсандӣ насибат мегардад ва таваллуди ин кӯдак боиси хушнудии бисёриҳо мешавад, ");
INSERT INTO tgk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","зеро ӯ дар назари Худованд бузург хоҳад шуд. Ӯ бояд ҳеҷ шаробу май нанӯшад. Кӯдак ҳанӯз пеш аз таваллуд шуданаш аз Рӯҳи Муқаддас пур шуда, ");
INSERT INTO tgk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","аз байни халқи Исроил бисёр касонро ба сӯи Худованд Худои онҳо бармегардонад. ");
INSERT INTO tgk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Вай ҳам мисли Илёс пайғамбар дар рӯҳ ва қудрат пешопеши Худованд қадам мезанад, то ки дилҳои падаронро ба фарзандонашон наздик карда, саркашонро ба ҳикмати накӯкорон орад ва бо ин роҳ барои Худованд халқро тайёр кунад». ");
INSERT INTO tgk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Закарё аз фаришта пурсид: «Аз куҷо мефаҳмам, ки ин мешавад? Охир ману занам пир шудаем» ");
INSERT INTO tgk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Фаришта ба ӯ ҷавоб дод: «Ман Ҷаброил ҳастам ва дар ҳузури Худо меистам. Ӯ маро фиристод, то ки бо ту гап зада, ин хабари хушро ба ту бирасонам. ");
INSERT INTO tgk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Вале чун ба суханонам, ки дар вақти муайяншуда иҷро хоҳанд шуд, бовар накардӣ, ҳоло гунг мешавӣ ва то он рӯзе, ки ҳамаи гуфтаҳоям ба амал наоянд, сухане гуфта наметавонӣ». ");
INSERT INTO tgk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Мардуме, ки интизори Закарё буданд, ҳайрон шуданд, ки чаро ӯ вақти зиёде дар Хонаи Худо мемонад. ");
INSERT INTO tgk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ҳангоме ки Закарё берун омад, ҳеҷ сухан гуфта наметавонист ва онҳо фаҳмиданд, ки дар Хонаи Худо ба вай чизе аён шудааст. Ӯ гунг шуда буд, аз ин сабаб бо одамон бо имову ишора гап мезад. ");
INSERT INTO tgk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ҳамин ки вақти хизмати Закарё ба охир расид, вай ба хонааш баргашт. ");
INSERT INTO tgk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Баъд аз ин зани вай Элисобат ҳомиладор шуд ва аз ин рӯ, панҷ моҳ аз хона намебаромад. Ӯ гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Ин кори Худованд аст, ки ҳоло ба ман назар андохта, нанги маро аз миёни мардум бардоштааст». ");
INSERT INTO tgk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Дар моҳи шашум Худо фаришта Ҷаброилро ба шаҳри Носираи сарзамини Ҷалил фиристод. ");
INSERT INTO tgk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ӯ ба назди Марям ном духтаре омад. Марям номзади Юсуф, як марде аз авлоди шоҳ Довуд буд. ");
INSERT INTO tgk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Фаришта пеши Марям омада, гуфт: «Салом, эй назаркардаи Худо. Худо бо туст». ");
INSERT INTO tgk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Марям аз ин суханони фаришта безобита шуда, худ ба худ фикр мекард, ки чаро ӯ ба ман чунин салом дод. ");
INSERT INTO tgk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Фаришта бошад, ба ӯ гуфт: «Натарс, Марям, зеро Худо бар ту назар кардааст; ");
INSERT INTO tgk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ҳоло ту ҳомиладор шуда, писаре таваллуд мекунӣ ва номашро Исо мегузорӣ. ");
INSERT INTO tgk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ӯ бузург мегардад ва Писари Худои Таоло хонда мешавад. Худованд Худо Ӯро ба тахти аҷдоди Ӯ Довуд мешинонад. ");
INSERT INTO tgk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ӯ то абад бар халқи Ёқуб фармонфармоӣ мекунаду подшоҳиаш ҳеҷ гоҳ ба охир намерасад». ");
INSERT INTO tgk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Марям ба фаришта гуфт: «Ман то ҳол бо ягон мард наздикӣ надоштам, пас чӣ тавр ҳомиладор шуда метавонам?» ");
INSERT INTO tgk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Фаришта ба ӯ ҷавоб дод: «Рӯҳи Муқаддас бар ту мефурояд ва қудрати Худои Таоло дар ту амал мекунад. Аз ин сабаб он кӯдаке, ки ту таваллуд мекунӣ, муқаддас ва Писари Худо номида хоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Охир хеши ту Элисобат ҳам дар пиронсолӣ писаре дар шикам дорад ва ҳоло аз ҳомиладор шуданаш шаш моҳ гузаштааст, ҳарчанд нозой шуморида шуда буд. ");
INSERT INTO tgk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Бидон, ки барои Худо ҳеҷ чизи ғайриимкон нест». ");
INSERT INTO tgk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Марям гуфт: «Ман бандаи Худованд ҳастам ва бигзор ҳар чизе, ки шумо гуфтед, ба амал ояд». Сипас, фаришта аз пеши ӯ рафт. ");
INSERT INTO tgk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Баъд аз ин Марям бошитоб ба шаҳре, ки дар кӯҳистони Яҳудия воқеъ буд, равона шуд. ");
INSERT INTO tgk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Вақте ки ба он ҷо расид, ба хонаи Закарё даромада, бо Элисобат салом кард. ");
INSERT INTO tgk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Саломи Марямро шунидан замон тифл дар шиками Элисобат ба ҷунбиш омад ва Элисобат аз Рӯҳи Муқаддас пур шуда, ");
INSERT INTO tgk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","бо овози баланд хитоб намуд: «Ту пурфайзтарин зани дунё ҳастӣ ва хушбахт аст он кӯдаке, ки дар шикам дорӣ! ");
INSERT INTO tgk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ман кӣ ҳастам, ки модари Худовандам ба диданам омадааст? ");
INSERT INTO tgk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Нигоҳ кун! Ҳамин ки саломи ту ба гӯшам расид, аз шодӣ бача дар шикамам ба ҷунбиш омад. ");
INSERT INTO tgk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Хушбахт ҳастӣ ту, ки ба иҷро шудани гуфтаҳои Худованд бовар кардӣ». ");
INSERT INTO tgk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Марям гуфт: «Ҷони ман Худовандро ситоиш мекунад ");
INSERT INTO tgk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ва рӯҳам аз Худои Наҷотдиҳандаам шод аст, ");
INSERT INTO tgk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","чунки Худо ба ман барин бандаи хокиаш назар андохтааст. Баъд аз ин ҳамаи наслҳо маро хушбахт хоҳанд хонд, ");
INSERT INTO tgk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","зеро Худои Пурқудрат, ки номаш муқаддас аст, бароям корҳои бузурге кардааст. ");
INSERT INTO tgk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Вай насл ба насли касоне, ки худотарс ҳастанд, марҳамати худро нишон медиҳад. ");
INSERT INTO tgk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ӯ бо дасташ корҳои боқудрат нишон дод ва онҳоеро, ки дилашон мағрур буд, ба ҳар сӯ парешон сохт. ");
INSERT INTO tgk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ҳокимонро аз тахтҳояшон ба зер афканд, вале одамони хоксорро сарбаланд кард; ");
INSERT INTO tgk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","гуруснагонро аз нозу неъматҳояш сер намуда, сарватмандонро аз пешаш бо дасти холӣ фиристод; ");
INSERT INTO tgk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","ба хотири марҳаматаш, ҳамон тавре ки ба аҷдодони мо, яъне ба Иброҳим ва авлоди ӯ то ба абад ваъда дода буд, ба бандаи худ Исроил ёрӣ расонд». ");
INSERT INTO tgk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Марям қариб се моҳ дар назди Элисобат монд ва баъд ба хонаи худ баргашт. ");
INSERT INTO tgk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Вақти таваллуд кардани Элисобат фаро расид ва ӯ писаре зоид. ");
INSERT INTO tgk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ҳамсояҳо ва хешовандонаш фаҳмиданд, ки Худованд дар ҳаққи вай марҳамати бузурге кардааст ва ба шодии ӯ шарик шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Вақте ки кӯдак ҳаштрӯза шуд, ҳамаи онҳо ҷамъ шуданд, то дар рӯзи хатнаи кӯдак иштирок кунанд ва хостанд ӯро монанди падараш Закарё ном гузоранд. ");
INSERT INTO tgk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Вале модараш гуфт: «Не, номи ӯ Яҳё мешавад». ");
INSERT INTO tgk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Онҳо ба ӯ гуфтанд: «Охир, дар байни хешонат ҳеҷ кас ин хел ном надорад». ");
INSERT INTO tgk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Баъд бо имову ишора аз Закарё пурсиданд, ки ӯ кӯдакро чӣ ном мондан мехоҳад? ");
INSERT INTO tgk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Вай тахтачаеро талаб карда, ба рӯи он навишт «Номи ӯ Яҳё аст» ва ҳама ҳайрон шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ҳамин вақт забони Закарё кушода шуду ӯ ба гап даромада Худоро ҳамду сано хонд. ");
INSERT INTO tgk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ҳамаи ҳамсояҳо ба тарс афтоданд ва ин воқеаҳоро дар сар то сари кӯҳистони Яҳудия нақл мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Онҳое, ки нақлашонро мешуниданд, дар дили худ чунин мегуфтанд: «Хӯш, ин кӯдак кӣ мешуда бошад?» Худованд бошад, дар ҳақиқат кӯдакро дастгирӣ мекард. ");
INSERT INTO tgk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Падари кӯдак Закарё аз Рӯҳи Муқаддас пур шуду пешгӯӣ карда, чунин мегуфт: ");
INSERT INTO tgk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Шаъну шараф ба Худованд Худои Исроил! Зеро Ӯ ба ёрии халқи худ омада, онро озод кард. ");
INSERT INTO tgk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ӯ барои мо аз авлоди бандааш Довуд Наҷотдиҳандаи пурқудратро пайдо кард, ");
INSERT INTO tgk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","чун аз қадим бо забони пайғамбарони муқаддаси худ гуфта буд, ");
INSERT INTO tgk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ки моро аз душманонамон ва аз дасти ҳамаи онҳое, ки моро бад мебинанд, наҷот медиҳад. ");
INSERT INTO tgk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ҳамин тавр Вай аз рӯи ваъдае, ки ба аҷдодонамон дода буд, ба мо раҳм нишон дод. Инчунин он аҳду паймони муқаддаси худро аз хотир набаровард, ки бо авлоди гузаштаи мо Иброҳим баста, қасам дод, ки ");
INSERT INTO tgk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","моро аз дасти душманонамон раҳоӣ медиҳад, то ки тамоми умрамон бе тарсу ҳарос, дар покиву накӯкорӣ ба Ӯ хизмат карда тавонем. ");
INSERT INTO tgk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Пас ту, эй фарзанд, пайғамбари Худои Таоло номида мешавӣ, чунки барои тайёр кардани роҳи Худованд пешопеши Ӯ қадам мезанӣ ");
INSERT INTO tgk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ва ба халқи Ӯ мефаҳмонӣ, ки ба воситаи бахшида шудани гуноҳҳояшон онҳо наҷот меёбанд. ");
INSERT INTO tgk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Зеро аз раҳму шафқати Худои мо офтоби субҳгоҳӣ аз осмон бар мо нурафшонӣ мекунад, ");
INSERT INTO tgk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","то бар касоне, ки дар торикию сояи марг мешинанд, равшанӣ кунад ва қадамҳои моро ба роҳи сулҳу осоиштагӣ ҳидоят намояд». ");
INSERT INTO tgk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Кӯдак бошад, калон шуда, рӯҳаш қавӣ мегашт ва то рӯзи ба халқи Исроил зоҳир гардиданаш дар биёбон зиндагӣ мекард. ");
INSERT INTO tgk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Дар он вақтҳо император Авғустус фармон баровард, ки дар саросари империя саршумории аҳолӣ гузаронида шавад. ");
INSERT INTO tgk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ин аввалин саршуморӣ буд, ки дар замони ҳукмронии Кириниюс дар Сурия гузаронида мешуд. ");
INSERT INTO tgk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ҳар кас барои ба қайд гирифта шудани номаш бояд ба шаҳри худ мерафт. ");
INSERT INTO tgk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Юсуф низ аз шаҳри Носира, ки дар сарзамини Ҷалил воқеъ гаштааст, ба сарзамини Яҳудия сафар кард. Азбаски ӯ аз авлоди шоҳ Довуд буд, бояд номаш дар шаҳри Байт-Лаҳм, ки ҷои таваллуди Довуд аст, ба қайд гирифта мешуд. ");
INSERT INTO tgk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ӯ Марямро низ, ки номзадаш ва ҳамон вақт аллакай ҳомиладор буд, бо худ бурд, то ки номи ӯ ҳам ба қайд гирифта шавад. ");
INSERT INTO tgk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ҳангоме ки онҳо дар Байт-Лаҳм буданд, вақти таваллуди кӯдак фаро расид. ");
INSERT INTO tgk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Азбаски дар меҳмонхона барои онҳо ҷое ёфт нашуд, Марям фарзанди аввалинашро, ки писар буд, таваллуд карда, парпеч намуда, дар охур хобонд. ");
INSERT INTO tgk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Дар он сарзамин чӯпонҳое буданд, ки шабона дар ҳавои кушод рамаи худро посбонӣ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Як фариштаи Худованд бар онҳо зоҳир гардид ва шӯҳрату ҷалоли Худованд дар атрофашон дурахшид. Чӯпонҳо сахт тарсиданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Аммо фаришта ба онҳо гуфт: «Натарсед, ман ба шумо хушхабареро овардаам, ки аз шунидани он тамоми мардум беҳад шод мегарданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Зеро имрӯз барои шумо дар шаҳри шоҳ Довуд Наҷотдиҳандае ба дунё омад, ки Ӯ Таъиншудаи Худо ва Худованд аст. ");
INSERT INTO tgk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ба шумо ҳамин нишона мешавад, ки тифли парпечшударо дар охур хобида меёбед». ");
INSERT INTO tgk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ногаҳон бо он фаришта дар осмон ҳазор-ҳазор фариштаҳои дигар пайдо шуданд, ки Худоро ҳамду сано хонда, мегуфтанд: ");
INSERT INTO tgk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Бигзор номи Худо дар осмонҳо шӯҳрату ҷалол ёбад ва дар байни онҳое, ки дар рӯи замин писандидаи Ӯ ҳастанд, сулҳу осоиштагӣ бошад!» ");
INSERT INTO tgk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Баъд фариштагон аз назди онҳо дур шуда, дар осмон нопадид гаштанд ва чӯпонҳо ба якдигар мегуфтанд: «Биёед, ба Байт-Лаҳм биравем ва он ҳодисаҳои рӯйдодаро, ки Худованд ба мо гуфт, бубинем». ");
INSERT INTO tgk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Пас бошитоб рафта, Маряму Юсуф ва он кӯдакро, ки дар охур хобида буд, ёфтанд. ");
INSERT INTO tgk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Вақте ки кӯдакро диданд, ҳар он чизеро, ки дар борааш шунида буданд, ба ҳама нақл карданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ҳамаи шунавандагон аз нақли чӯпонҳо ҳайрон шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Вале Марям чизи шунидаашро дар дили худ нигоҳ дошта, дар борааш фикру мулоҳизаҳои зиёде мекард. ");
INSERT INTO tgk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Чӯпонҳо баргашта, барои чизҳои шунидаву дидаашон Худоро ситоиш намуда, ба Ӯ ҳамду сано мехонданд, зеро ҳамаи он чизе, ки ба онҳо гуфта шуда буд, иҷро шуд. ");
INSERT INTO tgk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Баъд аз ҳашт рӯз вақти хатнаи кӯдак фаро расид ва Ӯро Исо номиданд. Ба Ӯ ҳамон номеро гузоштанд, ки фаришта ҳанӯз пеш аз дар шикам пайдо шудани Ӯ гуфта буд. ");
INSERT INTO tgk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ҳамин ки вақти покшавии онҳо фаро расид, Юсуфу Марям мувофиқи шариати Мӯсо кӯдакро ба Ерусалим оварданд, то ки ба Худованд пешкаш намоянд. ");
INSERT INTO tgk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Чунон ки дар шариати Худованд навишта шудааст: «Ҳар писари аввалин бояд ба Худо бахшида шавад» ");
INSERT INTO tgk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ва аз рӯи қонун падару модари кӯдак бояд ҳатман як ҷуфт мусича ва ё ду чӯҷаи кабӯтарро қурбонӣ кунанд. ");
INSERT INTO tgk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Дар Ерусалим Шимъӯн ном марде зиндагӣ мекард, ки худотарсу накӯкор буд. Вай вақти тасаллӣ ёфтани халқи Исроилро интизор буд. Рӯҳи Муқаддас бо Шимъӯн буд ");
INSERT INTO tgk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ва аз он Рӯҳ бар ӯ маълум шуд, ки то Шимъӯн Таъиншудаи Худованд, яъне Масеҳро набинад, намемирад. ");
INSERT INTO tgk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Он Рӯҳ ба Шимъӯн илҳом бахшид ва ӯ ба Хонаи Худо рафт. Худи ҳамон рӯз падару модари Исо ҳам кӯдакро барои иҷро намудани маросими шариат ба он ҷо оварданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Шимъӯн кӯдакро ба оғӯш гирифт ва Худоро ҳамду сано хонда гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ҳоло, эй Худованд, бандаатро аз рӯи ваъдаи худ бо сулҳу саломатӣ ҷавоб деҳ, ");
INSERT INTO tgk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","зеро чашмонам наҷотеро диданд, ки аз тарафи Ту меояд. ");
INSERT INTO tgk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ту онро дар ҳузури ҳамаи халқҳо муҳайё сохтӣ. ");
INSERT INTO tgk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Вай нурест, ки барои ғайрияҳудиён роҳи Туро равшан мекунад ва ба халқи Исроилат шӯҳрат меорад». ");
INSERT INTO tgk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Падару модари Исо аз чунин суханони дар бораи кӯдак гуфташуда ҳайрон шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Шимъӯн онҳоро баракат дода, ба Марям, модари Исо гуфт: «Ин кӯдак дар Исроил барои нобуд сохтан ва наҷот додани бисёриҳо таъин шудааст. Ӯ нишонае аз Худо мешавад, ки бар зиддаш сухан хоҳанд гуфт, ");
INSERT INTO tgk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","то ки фикрҳои дили бисёриҳо ошкор шавад ва ту ҳам бисёр азоб мекашӣ». ");
INSERT INTO tgk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Дар Хонаи Худо Ҳано ном пайғамбарзане буд, ки падараш Фануил ном дошт. Онҳо аз авлоди Ошер буданд. Ҳано хеле пир шуда буд. Вай баъд аз ба шавҳар баромадан ҳамагӣ ҳафт сол бо ҳамсараш зиндагӣ карда буд. ");
INSERT INTO tgk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ин зани ҳаштоду чорсола, ки бева монда буд, ҳеҷ вақт аз Хонаи Худо берун намерафт ва шабу рӯз бо дуову рӯза хизмату ибодат мекард. ");
INSERT INTO tgk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Вай ҳам якбора пеш омаду Худоро шукргӯён ба ҳамаи онҳое, ки интизори озод шудани Ерусалим буданд, дар бораи он кӯдак нақлҳои зиёде кард. ");
INSERT INTO tgk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Баъд аз он ки Юсуф ва Марям ҳамаи корҳоро аз рӯи шариати Худованд иҷро карданд, ба шаҳри худ, ки Носираи Ҷалил аст, баргаштанд. ");
INSERT INTO tgk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Кӯдак калон шуда, қувват мегирифт ва пур аз ҳикмат мешуд. Ӯ писандидаи Худо буд. ");
INSERT INTO tgk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ҳар сол падару модари Исо барои қайд кардани иди Балогардон ба Ерусалим мерафтанд. ");
INSERT INTO tgk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Вақте ки Исо дувоздаҳсола шуд, онҳо аз рӯи одат ҳамроҳи Ӯ ба он ҷо рафтанд. ");
INSERT INTO tgk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Баъд аз он ки рӯзҳои ид ба охир расиданд, онҳо ба шаҳри худ раҳсипор гаштанд, вале Исои наврас дар Ерусалим монд. Падару модараш аз ин бехабар буданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Онҳо гумон доштанд, ки Ӯ ҳамроҳи дигарон равона аст ва тамоми рӯз сафарашонро давом доданд. Дертар Ӯро дар миёни дӯстону хешони худ ҷустуҷӯ карданд ");
INSERT INTO tgk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ва чун наёфтанд, ба Ерусалим барои ҷустуҷӯяш баргаштанд. ");
INSERT INTO tgk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Баъд аз се рӯз Ӯро дар Хонаи Худо ёфтанд, ки дар байни муаллимон нишаста, суханонашонро гӯш мекард ва ба онҳо савол медод. ");
INSERT INTO tgk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ҳамаи шунавандагон аз барои доноӣ ва ҷавобҳояш ҳайрон монданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Падару модараш Ӯро дида, ҳайрон шуданд ва Марям ба Вай гуфт: «Писарам, чаро бо мо чунин рафтор кардӣ? Ману падарат дар ҷустуҷӯи Ту бисёр азоб кашидем». ");
INSERT INTO tgk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Исо гуфт: «Чаро Маро ҷустуҷӯ кардед? Магар шумо намедонистед, ки Ман бояд дар хонаи Падарам бошам?» ");
INSERT INTO tgk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Вале онҳо маънои суханони Ӯро нафаҳмиданд. ");
INSERT INTO tgk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ӯ бо падару модараш ба Носира баргашт ва аз гуфтаи онҳо берун намебаромад. Марям бошад, ҳамаи инро дар дили худ нигоҳ медошт. ");
INSERT INTO tgk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Исо сол ба сол дар ҳикмат ва қомат бузург шуда, торафт бештар писандидаи Худову мардум мегашт. ");
INSERT INTO tgk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Дар замони сарвари рӯҳониён будани Ҳонон ва Қаёфо каломи Худо дар биёбон ба гӯши Яҳёи писари Закарё расид. Ин воқеа дар соли понздаҳуми ҳукмронии император Тибариюс рӯй дод. Дар он айём Понтиюс Пилотус фармонравои Яҳудия ва Ҳиродус ҳокими Ҷалил буданд. Бародари Ҳиродус Филиппус бошад, дар Итурияву вилояти Тархонитус ҳукмронӣ мекард ва Лисониюс ҳокими Абилин буд. ");
INSERT INTO tgk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Яҳё тамоми ноҳияҳои атрофи дарёи Урдунро тай намуда, эълон мекард, ки мардум барои бахшида шудани гуноҳҳояшон бояд тавба карда, аз гуноҳҳояшон даст кашанд ва таъмид бигиранд. ");
INSERT INTO tgk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Дар бораи вай дар китоби Ишаъё пайғамбар чунин навишта шудааст: «Касе дар биёбон фарёд зада мегӯяд: „Барои Худованд роҳ тайёр кунед! Онро рост намоед! ");
INSERT INTO tgk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Бигзор ҳар водӣ баланд шавад, ҳар кӯҳу теппа ба ҳамворӣ мубаддал гардад. Бигзор роҳҳои печ дар печ рост шуда, роҳҳои пасту баланд ҳамвор шаванд, ");
INSERT INTO tgk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","он гоҳ ҳар як ҷони зинда наҷоти Худоро мебинад!“» ");
INSERT INTO tgk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Мардуми зиёде назди Яҳё меомаданд, то аз дасти ӯ таъмид бигиранд ва ӯ ба онҳо мегуфт: «Эй морони маккор! Кӣ ба шумо гуфт, ки аз ҷазои дарпешистодаи Худо гурехта метавонед? ");
INSERT INTO tgk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Асло фикр накунед, ки ба сабаби аз насли Иброҳим буданатон ҷазо намебинед. Зеро ба шумо мегӯям, ки Худо аз ҳамин сангҳо барои Иброҳим насл ба вуҷуд оварда метавонад. Пас, чун дарахти мевадоре, ки меваи хуб медиҳад, дар амал нишон диҳед, ки ҳақиқатан тавба кардаед. ");
INSERT INTO tgk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Теша аллакай бар решаи дарахтон гузошта шудааст ва ҳар дарахте, ки меваи хуб намеоварад, бурида ба оташ партофта мешавад». ");
INSERT INTO tgk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Мардум аз ӯ мепурсиданд: «Пас, мо чӣ кор кунем?» ");
INSERT INTO tgk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Яҳё ҷавоб дод: «Касе, ки ду ҷома дорад, яктоашро ба касе диҳад, ки ба он мӯҳтоҷ аст ва ҳар кӣ хӯрок дорад, низ чунин бикунад». ");
INSERT INTO tgk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Андозгирон ҳам, ки барои таъмид гирифтан омада буданд, аз ӯ пурсиданд: «Устод, мо чӣ кор кунем?» ");
INSERT INTO tgk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ба онҳо гуфт: «Бештар аз он андозе, ки бароятон муайян карда шудааст, аз мардум наситонед». ");
INSERT INTO tgk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Сарбозон низ аз ӯ пурсиданд: «Пас, мо чӣ кор кунем?» Яҳё гуфт: «Касеро бо зӯриву тӯҳмати ноҳақ ғорат накунед ва ба маоши худ қаноат намоед». ");
INSERT INTO tgk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Мардум интизори омадани Масеҳ, яъне Таъиншудаи Худо буданд ва баъд аз шунидани гуфтаҳои Яҳё худ ба худ фикр мекарданд, ки шояд Яҳё Таъиншудаи Худо аст. ");
INSERT INTO tgk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Яҳё бошад, ба онҳо гуфт: «Ман шуморо бо об таъмид медиҳам, вале тавонотаре аз ман меояд, ки ман ҳатто сазовори кушодани банди пойафзоли Ӯ нестам. Ӯ шуморо бо Рӯҳи Муқаддас ва оташ таъмид хоҳад дод. ");
INSERT INTO tgk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Дар дасти Ӯ бел барои бод кардани гандум тайёр аст. Вай бо он хирмани худро тоза карда, гандумро дар анбораш ҷамъ мекунад, вале каҳро дар оташи хомӯшнашаванда месӯзонад». ");
INSERT INTO tgk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ҳамин тавр Яҳё мардумро панду насиҳат карда, ба онҳо хушхабарро мерасонд. ");
INSERT INTO tgk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Яҳё ҳоким Ҳиродусро ҳам барои он ки ҳамсари бародари худаш Ҳиродияро ба занӣ гирифта буд ва барои ҳамаи корҳои бадаш сарзаниш мекард. ");
INSERT INTO tgk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Бинобар ин Ҳиродус, бар замми ҳамаи кирдори бадаш, боз Яҳёро ба ҳабс андохт. ");
INSERT INTO tgk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Инак, вақте ки ҳамаи мардум таъмид гирифта буданд, Исо низ таъмид гирифту ба дуогӯӣ машғул шуд. Дар ҳамин вақт осмон кушода шуда, ");
INSERT INTO tgk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Рӯҳи Муқаддас дар шакли кабӯтаре фаромада, дар болои Ӯ қарор гирифт ва садое аз осмон баромад, ки мегуфт: «Ту Писари азизи Ман ҳастӣ ва Ман аз Ту хушнудам!» ");
INSERT INTO tgk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Вақте ки Исо ба хизмати худ шурӯъ намуд, тақрибан сисола буд ва ҳама гумон мекарданд, ки Ӯ писари Юсуф аст. Юсуф бошад, писари Элӣ, ");
INSERT INTO tgk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Элӣ писари Маттот, Маттот писари Левӣ, Левӣ писари Малкӣ, Малкӣ писари Яннай, Яннай писари Юсуф, ");
INSERT INTO tgk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Юсуф писари Матитё, Матитё писари Омӯс, Омӯс писари Наҳум, Наҳум писари Ҳеслӣ, Ҳеслӣ писари Наҷҷой, ");
INSERT INTO tgk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Наҷҷой писари Маҳат, Маҳат писари Матитё, Матитё писари Шимъӣ, Шимъӣ писари Юсуф, Юсуф писари Юдо, ");
INSERT INTO tgk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Юдо писари Юҳонон, Юҳонон писари Ресо, Ресо писари Зарубобил, Зарубобил писари Шаалтиил, Шаалтиил писари Нерӣ, ");
INSERT INTO tgk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Нерӣ писари Малкӣ, Малкӣ писари Аддӣ, Аддӣ писари Қӯсом, Қӯсом писари Элмадом, Элмадом писари Эр, ");
INSERT INTO tgk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Эр писари Юсе, Юсе писари Элизер, Элизер писари Юрим, Юрим писари Маттот, Маттот писари Левӣ, ");
INSERT INTO tgk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Левӣ писари Шимъӯн, Шимъӯн писари Яҳудо, Яҳудо писари Юсуф, Юсуф писари Юном, Юном писари Элёқим, ");
INSERT INTO tgk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Элёқим писари Малё, Малё писари Мино, Мино писари Матато, Матато писари Натан, Натан писари Довуд, ");
INSERT INTO tgk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Довуд писари Йисой, Йисой писари Убид, Убид писари Бӯаз, Бӯаз писари Салмӯн, Салмӯн писари Наҳшӯн, ");
INSERT INTO tgk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Наҳшӯн писари Аминодоб, Аминодоб писари Адамин, Адамин писари Ҳорнӣ, Ҳорнӣ писари Ҳесрӯн, Ҳесрӯн писари Форас, Форас писари Яҳудо, ");
INSERT INTO tgk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Яҳудо писари Ёқуб, Ёқуб писари Исҳоқ, Исҳоқ писари Иброҳим, Иброҳим писари Тораҳ, Тораҳ писари Ноҳӯр, ");
INSERT INTO tgk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ноҳӯр писари Саруҷ, Саруҷ писари Рау, Рау писари Фолаҷ, Фолаҷ писари Эбар, Эбар писари Шолаҳ, ");
INSERT INTO tgk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Шолаҳ писари Қенон, Қенон писари Арфакшад, Арфакшад писари Сом, Сом писари Нӯҳ, Нӯҳ писари Ломак, ");
INSERT INTO tgk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ломак писари Матушолаҳ, Матушолаҳ писари Ҳанӯҳ, Ҳанӯҳ писари Ёрад, Ёрад писари Маҳалалъил, Маҳалалъил писари Қенон, ");
INSERT INTO tgk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Қенон писари Анӯш, Анӯш писари Шет, Шет писари Одам ва Одам писари Худо буданд. ");
INSERT INTO tgk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Исо аз Рӯҳи Муқаддас пур шуда, аз соҳили дарёи Урдун баргашт ва ин Рӯҳ Ӯро ба биёбон бурд. ");
INSERT INTO tgk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Он ҷо иблис дар муддати чил шабу чил рӯз Ӯро меозмоид. Ҳамон рӯзҳо Исо ҳеҷ чиз намехӯрд ва оқибат хеле гурусна монд. ");
INSERT INTO tgk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Иблис ба Ӯ гуфт: «Ту Писари Худо ҳастӣ-ку, пас, ба ин санг фармон деҳ, ки нон шавад». ");
INSERT INTO tgk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Исо ҷавоб дод: «Не, зеро дар навиштаҷот гуфта шудааст, ки инсон на фақат бо хӯрдани нон зинда аст». ");
INSERT INTO tgk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Баъд иблис Вайро ба баландӣ бурда, аз он ҷо дар як лаҳза тамоми мамлакатҳои дунёро ба Ӯ нишон дода, ");
INSERT INTO tgk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","гуфт: «Агар Ту ба ман саҷда кунӣ, ман тамоми ихтиёри ҳукмронӣ кардан ва ҳамаи шӯҳрату ҷалоли онҳоро ба Ту месупорам, зеро он ба ман дода шудааст ва ман метавонам онро ба касе, ки хоҳам, тӯҳфа бикунам». ");
INSERT INTO tgk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Исо ба вай ҷавоб дод: «Дар навиштаҷот гуфта шудааст, ки „мо бояд Худованд Худои худро бипарастем ва фақат ба Ӯ хизмат кунем“». ");
INSERT INTO tgk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Баъд иблис Ӯро ба Ерусалим бурд ва ба нуқтаи баландтарини Хонаи Худо гузошта гуфт: «Ту Писари Худо ҳастӣ-ку, пас, худро аз ин ҷо ба поён парто. ");
INSERT INTO tgk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Охир дар навиштаҷот гуфта шудааст, ки „Худо ба фариштагони худ фармон медиҳад, ки Туро муҳофизат кунанд ");
INSERT INTO tgk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ва онҳо Туро бар болои дастонашон хоҳанд бардошт, то ки поят ба санге назанад“». ");
INSERT INTO tgk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Исо ҷавоб дод: «Не, ҳамчунин гуфта шудааст, ки набояд Худованд Худои худро бисанҷем». ");
INSERT INTO tgk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Баъд аз ин иблис васвасаҳои худро бас кард ва то пайдо шудани лаҳзаи мувофиқ аз Исо дур шуд. ");
INSERT INTO tgk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Исо бо қудрати Рӯҳи Муқаддас ба Ҷалил баргашт ва ин хабар дар сар то сари он ноҳия паҳн шуд. ");
INSERT INTO tgk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ӯ дар ибодатхонаҳо мардумро таълим медод ва ҳама Исоро ситоиш мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ҳамин тавр Ӯ ба шаҳри Носира омад, ки дар он ҷо ба воя расида буд. Вай дар рӯзи истироҳат аз рӯи одат ба ибодатхона даромада, барои бо овози баланд хондани навиштаҷот аз ҷояш бархест. ");
INSERT INTO tgk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ба Ӯ китоби Ишаъё пайғамбарро доданд ва Исо онро кушода, ҷоеро ёфт, ки чунин навишта шуда буд: ");
INSERT INTO tgk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Рӯҳи Худованд дар Ман аст, зеро Ӯ Маро таъин намудааст, ки ба бенавоён хушхабарро бирасонам. Ӯ Маро фиристодааст, то озодии асирон, бино шудани кӯрон ва раҳоии ситамдидагону ");
INSERT INTO tgk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","соли файзбахши Худовандро эълон намоям». ");
INSERT INTO tgk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Баъд Вай китобро пӯшида, ба ходим дод ва ба ҷои худ нишаст. Дар ибодатхона ҳама бо диққат ба Ӯ нигоҳ мекарданд ");
INSERT INTO tgk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ва Ӯ ба сухан оғоз намуд: «Он навиштаҳоеро, ки ҳоло шунидед, имрӯз амалӣ гаштанд». ");
INSERT INTO tgk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ҳама Исоро таъриф мекарданд ва аз суханони файзбахши Ӯ дар тааҷҷуб монда, мегуфтанд: «Магар Ӯ писари Юсуф нест?» ");
INSERT INTO tgk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ӯ ба онҳо гуфт: «Медонам, ки дар бораи Ман чунин масалро хоҳед гуфт: „Эй табиб! Худатро шифо деҳ ва дар ватани худ низ мӯъҷизаҳоеро бикун, ки шунидаем дар шаҳри Кафарнаҳум кардаӣ“». ");
INSERT INTO tgk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Баъд суханашро давом дод: «Ба ростӣ мегӯям, ки ягон пайғамбар дар диёраш қадр надорад. ");
INSERT INTO tgk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ҳақиқатан ҳам, дар замони Илёс пайғамбар, вақте ки дар муддати севу ним сол борон наборид ва дар рӯи замин гуруснагии сахте ба вуҷуд омад, дар Исроил бевазанони бисёре буданд, ");
INSERT INTO tgk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","вале Илёс назди ҳеҷ яке аз онҳо фиристода нашуд. Ӯ танҳо ба назди як бевазане фиристода шуд, ки дар Сорфато ном шаҳри Сидун зиндагӣ мекард. ");
INSERT INTO tgk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Дар замони Элишои пайғамбар ҳам дар Исроил махавиёни зиёде буданд, вале ба ғайр аз Наамони суриёнӣ ҳеҷ кадоме аз онҳо шифо наёфтанд». ");
INSERT INTO tgk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Онҳое, ки дар ибодатхона буданд, аз шунидани чунин суханҳо ба ғазаб омаданд. ");
INSERT INTO tgk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Баъд аз ҷояшон бархеста, Исоро аз шаҳр берун карда, ба болои теппае бурданд, ки шаҳр он ҷо сохта шуда буд ва хостанд аз лаби ҷарӣ Ӯро партоянд. ");
INSERT INTO tgk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Аммо Ӯ аз миёни онҳо гузашта, бо роҳи худ равона шуд. ");
INSERT INTO tgk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Исо ба шаҳри Кафарнаҳум, ки дар Ҷалил аст, омада, дар рӯзи истироҳат мардумро таълим медод. ");
INSERT INTO tgk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Одамон аз таълимоти Ӯ қоил мемонданд, чунки суханонаш боқудрат буданд. ");
INSERT INTO tgk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Дар ибодатхона марде ҳузур дошт, ки дар вуҷудаш рӯҳи нопок, яъне дев ҷойгир шуда буд. Ӯ бо овози баланд фарёд зада гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Моро ба ҳоламон гузор! Ту ба мо чӣ кор дорӣ, эй Исои Носирӣ? Магар барои нобуд кардани мо омадаӣ?! Туро медонам! Ту Шахси муқаддаси Худо ҳастӣ!» ");
INSERT INTO tgk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Вале Исо рӯҳи нопокро сарзаниш карда фармуд, ки хомӯш шавад ва аз даруни он одам берун барояд. Дев мардро дар пеши назари ҳама ба замин партофт ва ба он мард ҳеҷ зараре нарасонда, аз вай берун баромад. ");
INSERT INTO tgk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ҳама ҳайрон шуда ба якдигар мегуфтанд: «Ин чӣ суханест, ки Ӯ бо қудрату қувват ба рӯҳҳои нопок амр мефармояд ва онҳо берун мебароянд?» ");
INSERT INTO tgk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Овозаи Исо дар тамоми он ноҳия паҳн мешуд. ");
INSERT INTO tgk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Исо аз ибодатхона баромада, ба хонаи Шимъӯн рафт. Хушдомани Шимъӯн ба табларзаи сахте гирифтор буд ва аз Исо хоҳиш карданд, ки ба ин зан ёрӣ диҳад. ");
INSERT INTO tgk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Исо болои сари ӯ хам шуда, табларзаро манъ кард ва он тамоман нест шуд. Зан дарҳол бархеста, ба меҳмоннавозӣ машғул шуд. ");
INSERT INTO tgk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Вақти ғуруби офтоб ҳамаи онҳоеро, ки ба касалиҳои гуногун гирифтор буданд, ба назди Исо меоварданд. Ӯ дасти худро болои сари ҳар яке аз онҳо мегузошту шифояшон медод. ");
INSERT INTO tgk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ҳамчунон девҳо «Ту писари Худо ҳастӣ!» гуфта, фарёдзанон аз бисёр касон берун мебаромаданд, чунки онҳо медонистанд, ки Ӯ Таъиншудаи Худо аст. Аммо Ӯ ба онҳо иҷозати гап заданро намедод. ");
INSERT INTO tgk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Вақте ки субҳ дамид, Исо берун баромада, ба ҷои хилвате рафт. Вале мардум Ӯро ҷустуҷӯ карда, ба наздаш омаданд ва намегузоштанд, ки аз пешашон биравад. ");
INSERT INTO tgk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ӯ бошад, ба онҳо гуфт: «Ман бояд хушхабари подшоҳии Худоро ба шаҳрҳои дигар ҳам бирасонам, чунки бо ҳамин мақсад Ман фиристода шудаам». ");
INSERT INTO tgk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ва Ӯ дар ибодатхонаҳои тамоми сарзамини Яҳудия хушхабарро эълон мекард. ");
INSERT INTO tgk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Як рӯз Исо дар канори кӯли Ҷинесор меистод ва мардуми бисёре, ки мехостанд каломи Худоро бишнаванд, аз ҳар тараф ба Ӯ фишор меоварданд. ");
INSERT INTO tgk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Исо ду қаиқеро дид, ки дар соҳили кӯл гузошта шуда буданд ва моҳигирон аз онҳо берун омада, тӯрҳои моҳидориро мешустанд. ");
INSERT INTO tgk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ӯ ба яке аз қаиқҳо, ки соҳибаш Шимъӯн буд, савор шуда, аз ӯ хоҳиш кард, ки қаиқро аз соҳил каме дуртар ронад. Баъд нишаста, аз қаиқ мардумро таълим медод. ");
INSERT INTO tgk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Дар охири суханаш Ӯ ба Шимъӯн гуфт: «Қаиқро ба мобайни кӯл бирон ва барои сайд тӯрҳоятонро ба об андозед». ");
INSERT INTO tgk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Шимъӯн ҷавоб дод: «Устод! Мо тамоми шаб заҳмат кашидем ва чизе сайд накардем, вале азбаски шумо мефармоед, ҳоло тӯрро ба об меандозем». ");
INSERT INTO tgk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Вақте ин корро карданд, он қадар моҳӣ сайд шуд, ки қариб буд тӯрҳояшон канда шаванд. ");
INSERT INTO tgk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Пас, Шимъӯн ва рафиқонаш ба шарикони худ, ки дар қаиқи дигар буданд, ишорае карданд, то ба ёриашон биёянд. Онҳо омада, ҳар ду қаиқро то дараҷае аз моҳӣ пур карданд, ки қариб ғарқ мешуданд. ");
INSERT INTO tgk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Шимъӯни Петрус ин ҳолатро дида, пеши пойҳои Исо афтода гуфт: «Худовандо! Аз пеши ман бирав, чунки ман одами гунаҳкор ҳастам». ");
INSERT INTO tgk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ӯ инро барои он гуфт, ки худаш ва ҳамроҳонаш аз сайди бешумори ба дастовардаашон ба ҳайрат афтода буданд. ");
INSERT INTO tgk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ёқубу Юҳанно низ, ки писарони Забдой ва шарикони Шимъӯн буданд, ҳайрон шуданд. Вале Исо ба Шимъӯн гуфт: «Натарс, баъд аз ин одамонро монанди моҳӣ ҷамъ хоҳӣ кард». ");
INSERT INTO tgk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Сипас моҳигирон қаиқҳоро ба соҳил бароварданд ва ҳамаи корҳояшонро як сӯ гузошта, Исоро пайравӣ карданд. ");
INSERT INTO tgk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Исо дар шаҳре буд, ки дар он ҷо марди гирифтори касалии махав буд. Он махав Исоро дида, сар ба пои Ӯ ниҳоду илтимос кард: «Худовандо, агар хоҳӣ, метавонӣ маро пок созӣ». ");
INSERT INTO tgk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Исо дасташро ба ӯ расонда гуфт: «Албатта, мехоҳам, пок шав!» ва касалии махав нест шуд. ");
INSERT INTO tgk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Баъд Исо ба ӯ таъкид карда гуфт: «Дар бораи ин воқеа ба касе нагӯй, балки рост назди рӯҳонӣ рафта, худро нишон деҳ ва барои пок шудани худ, ҳамон тавре ки Мӯсо фармудааст, қурбонӣ бикун, то ба мардум шаҳодате гардад». ");
INSERT INTO tgk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Аммо ба ин нигоҳ накарда, овозаи Ӯ торафт паҳн мешуд. Барои шифо ёфтан аз бемориҳо ва шунидани сухани Ӯ шумораи зиёди мардум дар атрофи Исо ҷамъ меомаданд. ");
INSERT INTO tgk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Исо бошад, барои дуо кардан ба ҷои хилват мерафт. ");
INSERT INTO tgk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Рӯзе Исо машғули таълим буд. Фарисиён ва шариатдононе, ки аз тамоми деҳоти Ҷалил, аз Яҳудия ва аз Ерусалим омада буданд, дар назди Ӯ нишастанд. Қудрати Худованд барои шифо додан бо Исо буд. ");
INSERT INTO tgk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ҳамин вақт чанд нафаре марди шалеро бо ҷойгаҳаш бардошта оварданд. Онҳо кӯшиш мекарданд, ки ӯро ба даруни хона дароварда, дар пеши Исо гузоранд, ");
INSERT INTO tgk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","вале аз сабаби бисёр будани мардум барои даровардани ӯ роҳе наёфтанд. Бинобар ин ба болои хона баромада, аз миёни сафолҳои бом шалро бо ҷойгаҳаш ба даруни хона, ба миёни мардум, пеши Исо фароварданд. ");
INSERT INTO tgk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Исо имони онҳоро дида, ба он шал гуфт: «Дӯстам! Гуноҳҳоят бахшида шуданд». ");
INSERT INTO tgk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Вале шариатдонону фарисиён ба якдигар мегуфтанд: «Ин кист, ки суханони кофирона мегӯяд? Ғайр аз Худо кӣ гуноҳҳоро бахшида метавонад?» ");
INSERT INTO tgk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Исо бошад, аз фикри онҳо дарак ёфта ҷавоб дод: «Чаро дар дилҳоятон чунин фикрҳо доред? ");
INSERT INTO tgk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Кадомаш осонтар аст: гуфтани он, ки „гуноҳҳои ту бахшида шуданд“ ё гуфтани он, ки „бархез ва роҳ гард“? ");
INSERT INTO tgk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Пас, Ман ба шумо исбот мекунам, ки Фарзанди Инсон дар рӯи замин қудрати бахшидани гуноҳҳоро дорад». Сипас ба шал нигариста гуфт: «Ба ту мегӯям, бархез, ҷойгаҳатро бардошта ба хонаат рав». ");
INSERT INTO tgk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Он мард дар пеши ҳама дарҳол аз ҷояш бархест ва ҷойгаҳашро, ки дар рӯи он хобида буд, бардошта, Худоро шукргӯён ба хонааш равона шуд. ");
INSERT INTO tgk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ҳама ба ҳайрат афтода, Худоро ситоиш мекарданд ва дар ҳолате, ки пур аз тарсу ҳарос буданд, мегуфтанд: «Имрӯз чизҳои аҷоибро дидем». ");
INSERT INTO tgk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Баъд аз ин Исо берун рафт ва Левӣ ном андозгиреро дид, ки дар ҷои кораш нишаста буд. Исо ба вай гуфт: «Биё, пайрави Ман шав». ");
INSERT INTO tgk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Левӣ бархест ва ҳама чизашро монда, аз паси Ӯ равона шуд. ");
INSERT INTO tgk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Левӣ дар хонаи худ барои Исо зиёфати калон орост. Шумораи зиёди андозгирон ва одамони дигар ҳамроҳашон дар гирди як дастархон менишастанд. ");
INSERT INTO tgk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Фарисиён ва шариатдонон ба шогирдони Исо шикоят карда мегуфтанд: «Чаро шумо ҳамроҳи андозгирону гунаҳкорон аз як дастархон мехӯреду менӯшед?» ");
INSERT INTO tgk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Исо ба онҳо ҷавоб дод: «Ба табиб на одамони солим, балки беморон мӯҳтоҷанд. ");
INSERT INTO tgk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ман ҳам барои он омадаам, ки на накӯкорон, балки гунаҳкоронро ба тавба даъват намоям». ");
INSERT INTO tgk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ба Исо гуфтанд: «Чаро шогирдони Яҳё зуд-зуд рӯза мегиранду дуо мехонанд, шогирдони фарисиён низ чунин мекунанд, вале шогирдони Шумо мехӯранд ва менӯшанд?» ");
INSERT INTO tgk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Исо ба онҳо гуфт: «Оё метавонед дӯстони домодро, модоме ки ӯ бо онҳост, маҷбур созед, ки рӯза бигиранд? ");
INSERT INTO tgk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Вале вақте мерасад, ки домод аз байнашон гирифта мешавад ва он гоҳ онҳо низ рӯза мегиранд». ");
INSERT INTO tgk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Баъд ба онҳо ин масалро гуфт: «Ҳеҷ кас аз ҷомаи нав пораеро канда, ҷомаи кӯҳнаро ямоқ намекунад, чунки ҳам ҷомаи нав ҳайф мешавад ва ҳам ямоқи нав ба ҷомаи кӯҳна мувофиқ намеояд. ");
INSERT INTO tgk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ҳамчунин ҳеҷ кас шароби навтайёршударо ба машки чармини кӯҳна намерезад, чунки шароб меҷӯшаду машкро дарронда, ҳам худ мерезад ва ҳам машк бекора мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Пас, шароби нав бояд ба машки нав рехта шавад. ");
INSERT INTO tgk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ҳеҷ кас баъд аз нӯшидани шароби кӯҳна шароби навро талаб намекунад, зеро мегӯяд, ки шароби кӯҳна хуб аст». ");
INSERT INTO tgk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Яке аз рӯзҳои истироҳат Исо аз миёни киштзорҳои гандум мегузашт. Шогирдонаш хӯшаҳоро чида, бо кафи дасташон молида мехӯрданд. ");
INSERT INTO tgk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Баъзе аз фарисиён гуфтанд: «Чаро шумо кореро мекунед, ки кардани он дар рӯзи истироҳат раво нест?» ");
INSERT INTO tgk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Исо ҷавоб дод: «Магар шумо дар навиштаҷот нахондаед, ки шоҳ Довуд, вақте ки бо ҳамроҳонаш гурусна монд, чӣ кор карда буд? ");
INSERT INTO tgk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ӯ ба хонае, ки ҳузури Худоро дошт, даромада, нони ба Худо тақдимшударо гирифта хӯрд ва ба ҳамроҳонаш низ дод. Ҳол он ки аз рӯи шариат фақат рӯҳониён ҳақ доштанд он нонро бихӯранд». ");
INSERT INTO tgk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Баъд ба онҳо гуфт: «Фарзанди Инсон соҳиби рӯзи истироҳат аст». ");
INSERT INTO tgk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Боз як рӯзи истироҳат Исо ба ибодатхона рафта, машғули таълим шуд. Дар он ҷо як марде ҳузур дошт, ки дасти росташ хушк шуда буд. ");
INSERT INTO tgk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Шариатдонон ва фарисиён мехостанд бинанд, ки Исо дар рӯзи истироҳат касеро шифо медиҳад ё не, то тавонанд Ӯро дар ин кор айбдор бикунанд. ");
INSERT INTO tgk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Аммо Исо фикри онҳоро медонист ва ба марди дасташ хушкшуда гуфт: «Бархез ва дар миёнҷо исто». Он мард бархесту истод. ");
INSERT INTO tgk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Исо ба онҳо гуфт: «Ба шумо саволе медиҳам: оё дар рӯзи шанбе некӣ кардан равост ё бадӣ? Ҷони касеро наҷот ё барбод додан?» ");
INSERT INTO tgk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Баъд ба ҳамаи онҳо нигоҳ карда, ба он мард гуфт: «Дастатро дароз кун». Вай дасташро дароз карду дасташ сиҳат шуд. ");
INSERT INTO tgk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Аммо шариатдонон ва фарисиён дар ғазаб шуда, бо ҳамдигар маслиҳат мекарданд, ки бар зидди Исо чӣ коре карда метавонанд. ");
INSERT INTO tgk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Дар он рӯзҳо Исо барои дуо кардан ба кӯҳ баромад ва тамоми шабро бо дуои Худо гузаронид. ");
INSERT INTO tgk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Вақте ки субҳ дамид, шогирдонашро ба наздаш ҷеғ зада, аз миёнашон дувоздаҳ нафарро интихоб кард ва онҳоро вакил номид, ки инҳоянд: ");
INSERT INTO tgk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Шимъӯн, ки Исо ӯро Петрус номид ва бародари Шимъӯн Андриёс, Ёқуб ва Юҳанно, Филиппус ва Барталмо, ");
INSERT INTO tgk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Матто ва Тумо, Ёқуби писари Ҳалфӣ ва Шимъӯн, ки ба ӯ лақаби Ватандӯстро гузошта буданд, ");
INSERT INTO tgk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Яҳудои писари Ёқуб ва Яҳудои Исқарют, ки оқибат хиёнаткор мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Исо ва вакилонаш аз кӯҳ поён фаромада, дар ҳамворие ҷой гирифтанд. Шумораи зиёди пайравонаш ва мардуми бешуморе аз тамоми гирду атрофи сарзаминҳои Яҳудия, Ерусалим ва аз ноҳияҳои назди баҳрии Суру Сидун ҷамъ омаданд, ");
INSERT INTO tgk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","то ки Исоро бишнаванд ва аз бемориҳо шифо ёбанд. Касоне, ки аз рӯҳи нопок азоб мекашиданд, низ шифо ёфтанд. ");
INSERT INTO tgk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Бинобар ин ҳама кӯшиш мекарданд, ки дасти худро ба Исо бирасонанд, чун қуввае, ки аз Ӯ берун меомад, ҳамаро шифо мебахшид. ");
INSERT INTO tgk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Исо ба шогирдонаш чашм дӯхта гуфт: «Хушбахтед шумо, ки ҳоло бечораед, чунки Худо дар ҳаётатон подшоҳӣ мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Хушбахтед шумо, ки ҳоло гуруснаед, чунки сер хоҳед шуд. Хушбахтед шумо, ки ҳоло гиря мекунед, зеро хандон мешавед. ");
INSERT INTO tgk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Хушбахтед шумо, вақте ки мардум ба хотири Фарзанди Инсон аз шумо нафрат мекунанд, шуморо аз байнашон меронанд, дашном медиҳанд ва номатонро ба бадӣ бароварда аз шумо рӯй мегардонанд. ");
INSERT INTO tgk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Дар он рӯз хурсанд бошед ва аз шодӣ бирақседу бидонед, ки Худо дар осмон бароятон мукофоти калон дорад. Зеро авлоди гузаштаи ин одамон низ бо пайғамбарон ҳамин тавр рафтор мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Лекин вой бар ҳоли шумо, эй сарватмандон, зеро аллакай тасаллии дили худро ёфтаед. ");
INSERT INTO tgk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Вой бар ҳоли шумо, ки ҳоло сер ҳастед, чунки гурусна хоҳед монд. Вой бар ҳоли шумо, ки ҳоло механдед, зеро гирёну нолон хоҳед шуд. ");
INSERT INTO tgk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Вой бар ҳоли шумо, вақте ки ҳама шуморо таърифу тавсиф мекунанд, чунки авлоди гузаштаи ин одамон низ бо пайғамбарони бардурӯғ ҳамин тавр рафтор мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Аммо ба шумо, ки ҳоло сухани Маро мешунавед, мегӯям: душманонатонро дӯст доред ва ба онҳое, ки шуморо бад мебинанд, некӣ кунед, ");
INSERT INTO tgk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","барои онҳое, ки шуморо лаънат мехонанд, баракат талабед ва барои онҳое, ки шуморо дашном медиҳанд, дуои хайр гӯед. ");
INSERT INTO tgk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Агар касе ба як тарафи рӯятон торсакӣ занад, тарафи дигари рӯятонро бар ӯ бигардонед ва агар касе ҷомаатонро кашида гирад, монед, ки куртаатонро ҳам бигирад. ");
INSERT INTO tgk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ҳар кӣ аз шумо чизе талаб кунад, ба ӯ бидиҳед ва ҳар кӣ чизи шуморо бигирад, баргардондани онро талаб накунед. ");
INSERT INTO tgk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Пас, чӣ гуна рафторро аз дигарон нисбати худ дидан хоҳед, ҳамон тавр аввал худи шумо нисбати онҳо рафтор кунед. ");
INSERT INTO tgk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Агар танҳо онҳоеро дӯст доред, ки шуморо дӯст медоранд, чӣ фоида ба даст меоред? Зеро гунаҳкорон ҳам дӯстдорандагони худро дӯст медоранд. ");
INSERT INTO tgk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Агар фақат ба касоне, ки ба шумо некӣ мекунанд, некӣ кунед, шумо чӣ ифтихоре доред? Зеро гунаҳкорон низ чунин мекунанд. ");
INSERT INTO tgk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Агар ба касе қарз диҳеду умеди пас гирифтани онро дошта бошед, чӣ фоида дорад? Зеро гунаҳкорон низ ба гунаҳкорон қарз дода, интизори пас гирифтани он ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Вале шумо душманонатонро дӯст доред, некӣ кунед ва қарз диҳеду интизори пас гардонда гирифтани он нашавед. Он гоҳ мукофоти бузурге насибатон гашта, фарзандони Худои Таоло хоҳед буд. Зеро Худо ба одамони хасис ва кӯрнамак ҳам меҳрубонӣ мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Пас, ҳамон тавре ки Падари шумо раҳмдил аст, шумо низ раҳмдил бошед. ");
INSERT INTO tgk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ҳукм накунед ва ба ҳукм дучор намешавед. Касеро айбдор накунед ва шумо низ айбдор карда намешавед. Ҳамаро бубахшед ва шумо низ бахшида мешавед. ");
INSERT INTO tgk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Бидиҳед ва ба шумо низ дода мешавад: ба андозаи хуби ҷунбонидаю фишурдашуда ва лабрезшуда ба доманатон меандозанд, зеро бо кадом санги тарозу баркашед, бо ҳамон санг ба шумо баркашида мешавад». ");
INSERT INTO tgk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ҳамчунин Ӯ масалеро ба онҳо гуфт: «Оё як кӯр ба кӯри дигар роҳ нишон дода метавонад? Магар ҳардуяшон ба чоҳ намеафтанд? ");
INSERT INTO tgk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Шогирд аз устодаш болотар нест. Аммо вақте ки донишашро пурра мекунад, ба устодаш баробар мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Чаро шумо хасро дар чашми бародаратон мебинеду чӯберо, ки дар чашми худатон ҳаст, ҳис намекунед? ");
INSERT INTO tgk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Чӣ тавр метавонед ба бародаратон бигӯед: „Эй бародар, иҷозат деҳ хасро аз чашмат барорам“, вақте ки чӯбро дар чашми худ намебинед? Эй дурӯяҳо! Аввал чӯбро аз чашми худатон дур кунед, он гоҳ дурусттар дида метавонед, ки чӣ хел хасро аз чашми бародаратон бароред. ");
INSERT INTO tgk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ҳаргиз дарахти хуб меваи бад ва ё дарахти бад меваи хуб ба бор намеоварад, ");
INSERT INTO tgk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","чунки ҳар дарахт аз мевааш шинохта мешавад. Аз буттаҳои хор анҷир намечинанд ва ё ҳосили ангур намегиранд. ");
INSERT INTO tgk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Шахси нек аз хазинаи неки дилаш некиро ва шахси бад аз хазинаи бади дилаш бадиро берун меорад, зеро он чи дилашро пур мекунад, баъд лабрез шуда, аз забонаш берун меояд. ");
INSERT INTO tgk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Чаро ба Ман „Худовандо! Худовандо!“ мегӯед, вале гуфтаҳоямро иҷро намекунед? ");
INSERT INTO tgk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ҳоло ба шумо ба кӣ монанд будани касеро мефаҳмонам, ки пеши Ман омада, сухани Маро мешунавад ва аз рӯи он амал мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ӯ ба одаме монанд аст, ки барои сохтани хонааш заминро чуқур канда, пойдеворашро болои санге мегузорад. Ҳангоме ки сел меояду оби пурталотумаш хонаро зер мекунад, ба он ҳеҷ осебе намерасад, чунки пойдевораш мустаҳкам сохта шудааст. ");
INSERT INTO tgk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Аммо касе, ки суханони Маро шунида, аз рӯи он амал намекунад, ба одаме монанд аст, ки хонаашро бе пойдевор болои хок сохтааст. Пас, вақте ки сел омада, оби пурталотумаш хонаро зер мекунад, он ба зудӣ фурӯ рафта несту нобуд мешавад». ");
INSERT INTO tgk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Баъд аз он ки Исо тамоми суханҳояшро ба мардум гуфта шуд, вориди шаҳри Кафарнаҳум гашт. ");
INSERT INTO tgk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Дар он ҷо як сардори лашкар хизматгоре дошт, ки барояш азиз буд. Ин хизматгор бемор шуда, дар бистари марг мехобид. ");
INSERT INTO tgk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Он сардори лашкар овозаи Исоро шунида, пирони яҳудиро пеши Ӯ фиристод, то илтимос кунанд, ки омада хизматгорашро шифо диҳад. ");
INSERT INTO tgk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Онҳо назди Исо омаданд ва бисёр илтимос карда гуфтанд: «Ин сардори лашкар сазовори он аст, ки барояш чунин корро бикунед, ");
INSERT INTO tgk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","чунки вай халқи моро дӯст медорад ва барои мо ибодатхонае сохтааст». ");
INSERT INTO tgk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Исо ҳамроҳи онҳо рафт. Ҳангоме ки ба хона наздик мешуд, сардори лашкар дӯстонашро фиристод, ки аз номи вай ба Исо чунин бигӯянд: «Хоҷа! Аз ин зиёд заҳмат накашед, зеро ман лоиқи он нестам, ки аз остонаи дарам гузаред. ");
INSERT INTO tgk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ба ҳамин сабаб худро муносиб надонистам, ки назди шумо биёям. Танҳо як амр кунед ва хизматгори ман шифо меёбад. ");
INSERT INTO tgk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Охир ман як фармонбардор ҳастам ва дар зери итоати худ низ сарбозонро дорам. Вақте ки ба яке „бирав“ мегӯям, меравад, ба дигаре „биё“ мегӯям, меояд ва агар ба хизматгорам „фалон корро бикун“ гӯям, ӯ албатта он корро иҷро мекунад». ");
INSERT INTO tgk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Исо инро шунида бисёр ҳайрон шуд ва ба мардуми бешуморе, ки аз паси Ӯ меомаданд, рӯ оварда гуфт: «Ба шумо мегӯям, ки ҳатто дар байни исроилиён касеро надидам, ки чунин имони сахт дошта бошад». ");
INSERT INTO tgk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Фиристодагони сардори лашкар ба хона баргашта, диданд, ки хизматгор сиҳат шудааст. ");
INSERT INTO tgk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Дере нагузашта Исо ҳамроҳи шогирдон ва шумораи зиёди мардум ба шаҳри Ноин рафт. ");
INSERT INTO tgk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ӯ ба дарвозаи шаҳр наздик шуда, дид, ки мурдаеро мебароранд. Он мурда писари ягонаи бевазане буд ва сокинони зиёди шаҳр ҳамроҳи он зан равона буданд. ");
INSERT INTO tgk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Худованд он занро дида, дилаш ба ҳоли вай сӯхт ва ба ӯ гуфт: «Гиря накун». ");
INSERT INTO tgk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Баъд наздик омада, дасти худро рӯи тобут гузошт ва тобутбардорон аз роҳ бозистоданд. Сипас Ӯ гуфт: «Эй бародар! Ба ту мегӯям, бархез». ");
INSERT INTO tgk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Мурда аз ҷояш бархеста нишасту ба сухан даромад ва Исо ӯро ба модараш супорид. ");
INSERT INTO tgk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ҳамаро тарсу ҳарос фаро гирифт ва мардум Худоро ҳамду санохонон мегуфтанд: «Худо ба халқи худ назар андохт ва дар байни мо пайғамбари бузурге пайдо шуд». ");
INSERT INTO tgk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Одамон дар тамоми Яҳудия ва гирду атрофи он дар бораи Исо нақл мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Шогирдони Яҳё низ ба устодашон ҳамаи воқеаҳоро нақл карданд. Яҳё ду нафар аз шогирдонашро ҷеғ зада, ");
INSERT INTO tgk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ба назди Худованд Исо фиристод, то бипурсанд: «Оё Шумо ҳамон шахсе ҳастед, ки омаданашро пешгӯӣ карда буданд ё мо бояд мунтазири каси дигар бошем?» ");
INSERT INTO tgk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Онҳо ба назди Исо омада, гуфтанд: «Яҳёи Таъмиддиҳанда моро пеши Шумо фиристод, то бипурсем, ки оё Шумо ҳамон шахсе ҳастед, ки омаданашро пешгӯӣ карда буданд ё мо бояд мунтазири каси дигар бошем?» ");
INSERT INTO tgk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ин ҳамон вақте буд, ки Исо мардуми зиёдеро аз бемориҳо, дарду азоб ва рӯҳҳои нопок шифо бахшида, чашми нобиноёни зиёдеро бино мекард. ");
INSERT INTO tgk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ӯ ба онҳо ҷавоб дод: «Ҳар чиро, ки дидаеду шунидаед, рафта, ба Яҳё нақл бикунед. Яъне бигӯед, ки чашмони кӯрон бино мешаванду лангон роҳ мегарданд, махавиён пок мешаванду карҳо мешунаванд, мурдаҳо аз нав зинда мешаванд ва ба бенавоён хушхабар эълон карда мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Пас, хушбахт аст касе, ки дар ҳаққи Ман шакку шубҳа намекунад». ");
INSERT INTO tgk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Баъд аз рафтани фиристодагони Яҳё Исо ба мардум дар бораи Яҳё суханашро оғоз кард: «Назди Яҳё ба биёбон барои дидани чӣ рафта будед? Барои дидани қамише, ки аз вазидани бод меҷунбад? ");
INSERT INTO tgk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Агар не, пас барои дидани чӣ рафта будед? Магар барои дидани одаме, ки либоси қимат мепӯшад? Охир онҳое, ки либоси зебо мепӯшанд ва ҳаёти пур аз айшу ишрат доранд, дар қасрҳои подшоҳӣ зиндагӣ мекунанд. ");
INSERT INTO tgk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Пас, киро диданӣ будед? Пайғамбарро? Дуруст, аммо ба шумо мегӯям, ки шумо каси бузургтар аз пайғамбарро дидаед. ");
INSERT INTO tgk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Яҳё ҳамон як одамест, ки Худо дар борааш дар навиштаҷот гуфта буд: „Ана, Ман пешопеши Ту як одамамро мефиристам, то ба омаданат роҳ тайёр кунад“. ");
INSERT INTO tgk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ҳоло ба шумо мегӯям, ки дар байни ҳамаи онҳое, ки аз модар ба дунё омадаанд, бузургтар аз Яҳё касе пайдо нашудааст. Аммо шахси хурдтарин дар подшоҳии Худо бузургтар аз Яҳё аст». ");
INSERT INTO tgk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Тамоми мардум ва андозгирон низ суханони ӯро шунида, дуруст будани роҳи Худоро тасдиқ менамуданд ва аз ин сабаб аз дасти Яҳё таъмид гирифта буданд. ");
INSERT INTO tgk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Вале азбаски фарисиён ва қонуншиносон таъмиди Яҳёро нагирифта буданд, аз нияте, ки Худо нисбаташон дошт, рӯй гардонданд. ");
INSERT INTO tgk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Исо суханашро давом дода гуфт: «Одамони ин наслро бо кӣ муқоиса кунам? Онҳо ба кӣ монандӣ доранд? ");
INSERT INTO tgk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Онҳо монанди кӯдаконе ҳастанд, ки дар кӯча нишаста, якдигарро ҷеғ мезананд ва мегӯянд: „Мо бароятон карнай навохтем, аммо шумо рақс накардед! Суруди мотам хондем, вале гиря накардед“. ");
INSERT INTO tgk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ҳоло Яҳёи Таъмиддиҳанда омадааст, ки нон намехӯраду шароб наменӯшад ва шумо мегӯед, ки ӯ дев дорад. ");
INSERT INTO tgk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Фарзанди Инсон омадааст, ки ҳам мехӯраду ҳам менӯшад ва шумо мегӯед: „Ана марди пурхӯр ва бадмаст дӯсти андозгирону гунаҳкорон аст“. ");
INSERT INTO tgk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Вале дуруст будани ҳикмати Худо ба воситаи корҳои тамоми фарзандонаш исбот мешавад». ");
INSERT INTO tgk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Яке аз фарисиён Исоро ба меҳмонӣ даъват намуд ва Ӯ ба хонаи он фарисӣ рафта, дар назди дастархон паҳлӯ зада нишаст. ");
INSERT INTO tgk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Дар он шаҳр як зани пургуноҳе буд. Чун ӯ фаҳмид, ки Исо дар хонаи он фарисӣ хӯрок мехӯрад, кӯзачаи сангини гаронбаҳоро, ки равғани хушбӯй дошт, гирифта ба он ҷо омад. ");
INSERT INTO tgk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Вай аз пушт, назди пойҳои Исо истода мегирист ва ашкҳояш ба пойҳои Исо мечакиданд. Зан бо мӯйҳояш пойҳои Ӯро мехушконид, бо эҳтиром онҳоро мебӯсид ва ба онҳо равғани хушбӯйро мемолид. ");
INSERT INTO tgk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Инро дида, фарисие, ки Исоро даъват карда буд, чунин фикрро аз дил гузаронд: «Агар ин мард дар ҳақиқат пайғамбар мебуд, мефаҳмид, ки ин зан чӣ гуна аст. Чун зане, ки ҳоло ба Ӯ даст мерасонад, гунаҳкор аст»! ");
INSERT INTO tgk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Вале Исо ба ӯ гуфт: «Шимъӯн! Мехоҳам ба ту чизе бигӯям». Гуфт: «Марҳамат, устод». ");
INSERT INTO tgk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Пас Исо суханашро давом дода гуфт: «Ду кас аз як одам пул қарз гирифтанд. Яке аз ӯ панҷсад ва дигаре панҷоҳ тангаи нуқра қарздор буд. ");
INSERT INTO tgk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Азбаски онҳо барои баргардондани қарз чизе надоштанд, он одам қарзи ҳардуро бахшид. Ҳоло бигӯ, кадоме аз онҳо ӯро бештар дӯст медорад?» ");
INSERT INTO tgk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Шимъӯн дар ҷавоб гуфт: «Ба гумонам он касе, ки ба ӯ қарзи зиёдтаре бахшида шудааст». Исо гуфт: «Дуруст фаҳмидӣ». ");
INSERT INTO tgk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Баъд ба он зан рӯ оварда, ба Шимъӯн гуфт: «Ин занро мебинӣ? Ман дар хонаи ту меҳмон шудам, вале барои пойҳоям об наовардӣ; ин зан бошад, пойҳои Маро бо ашкҳояш шуст ва бо мӯйҳояш тоза кард. ");
INSERT INTO tgk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ту Маро ҳатто набӯсидӣ; ин зан бошад, аз вақти омаданам то ҳол бӯсидани пойҳоямро бас намекунад. ");
INSERT INTO tgk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ту ба сарам ҳатто равғани оддиро намолидӣ; вай бошад, равғани қиматбаҳои хушбӯйро ба пойҳоям молид. ");
INSERT INTO tgk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Бинобар ин ба ту мегӯям, азбаски гуноҳҳои зиёди вай бахшида шудаанд, ӯ чунин муҳаббати зиёд дорад ва агар ба касе гуноҳи камтар бахшида шавад, муҳаббаташ низ камтар аст». ");
INSERT INTO tgk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Баъд ба он зан гуфт: «Гуноҳҳоят бахшида шуданд». ");
INSERT INTO tgk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Онҳое, ки бо Ӯ дар сари як дастархон нишаста буданд, худ ба худ мегуфтанд: «Вай кист, ки гуноҳҳоро мебахшад ҳам?» ");
INSERT INTO tgk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Вале Исо ба зан гуфт: «Туро имонат наҷот додааст. Рав ва дар амон бош!» ");
INSERT INTO tgk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Баъд аз ин Исо шаҳр ба шаҳру деҳа ба деҳа гашта, ба мардум хабари хуши подшоҳии Худоро мерасонд. Дар ин кор Ӯро дувоздаҳ шогирд ");
INSERT INTO tgk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ва якчанд зан, ки аз рӯҳҳои нопок ва бемориҳо шифо ёфта буданд, ҳамроҳӣ мекарданд. Яке аз он занҳо Марям буд, ки Маҷдалия номида мешуду аз ӯ ҳафт дев берун рафта буд. ");
INSERT INTO tgk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Дигаре Юҳона буд, ки шавҳараш Кузо ном дошту дар дарбори Ҳиродус вазифаи назоратчиро иҷро мекард. Ҳамчунин Сусан ва бисёр дигарон, ки бо пулу молашон онҳоро дастгирӣ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Вақте ки мардуми бисёре аз шаҳрҳои гирду атроф ҷамъ шуда, ба назди Исо омаданд, Ӯ масалеро гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Рӯзе як деҳқон барои киштани донаҳои худ мебарояд. Вақте ки дона мепошад, миқдоре аз онҳо ба пайраҳа афтода поймол мешавад ва паррандаҳо омада, онҳоро аз замин чида пок-покиза мехӯранд. ");
INSERT INTO tgk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Миқдори дигари донаҳо ба замини санглох афтода месабзанд, вале аз беобӣ хушк мешаванд. ");
INSERT INTO tgk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Боз як миқдори донаҳо ба миёни хорҳо афтода месабзанд, вале хорҳо қад кашида онҳоро пахш мекунанд. ");
INSERT INTO tgk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Аммо қисми донаҳое, ки ба замини хуби ҳосилхез меафтанд, сабзида, сад баробар зиёдтар ҳосил медиҳанд». Инро гуфту хитоб кард: «Ҳар кӣ Маро мешунавад, бигзор гӯш кунад!» ");
INSERT INTO tgk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Шогирдон аз Исо маънои ин масалро пурсиданд ");
INSERT INTO tgk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ва Ӯ гуфт: «Худо ба шумо имконияти фаҳмидани сирру асрори подшоҳии худро додааст, аммо ба дигарон бо масалҳо мегӯям, то ки „онҳо нигоҳ кунанду набинанд, гӯш кунанду нашунаванд“. ");
INSERT INTO tgk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Маънои масал ин аст: дона — каломи Худост. ");
INSERT INTO tgk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Донаҳое, ки ба пайраҳа афтодаанд, онҳое мебошанд, ки каломро мешунаванд, вале иблис онро аз дилашон медуздад, то ки имон наоваранд ва наҷот наёбанд. ");
INSERT INTO tgk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Донаҳое, ки ба замини санглох афтодаанд, онҳое мебошанд, ки каломро шунида, онро бо шодӣ қабул мекунанд, вале азбаски реша надоранд, муддати кӯтоҳе имондор буда, дар вақти озмоиш зуд аз имони худ мегарданд. ");
INSERT INTO tgk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Донаҳое, ки ба миёни хорҳо афтодаанд, онҳое мебошанд, ки каломро мешунаванд, вале ташвишу бойигарӣ ва кайфу сафои зиндагӣ онҳоро пахш мекунад ва онҳо ҳеҷ самаре ба бор намеоваранд. ");
INSERT INTO tgk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Аммо донаҳои ба замини ҳосилхез афтода онҳоянд, ки каломро мешунаванд ва онро дар дили неку самимиашон нигоҳ дошта, бо сабру тоқат самар ба бор меоваранд. ");
INSERT INTO tgk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ҳеҷ кас чароғро даргиронда, онро бо косае намепӯшонад ва ё ба зери кат намегузорад. Баръакс, онро ба чароғпоя мегузорад, то ҳар кӣ дарояд, равшаниашро бубинад. ");
INSERT INTO tgk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Зеро ҳеҷ чизи махфие нест, ки ошкор нашавад ва чизи пинҳоне нест, ки маълум ва равшан нагардад. ");
INSERT INTO tgk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Пас, аҳамият диҳед, ки суханони Маро чӣ хел гӯш мекунед, зеро ҳар кӣ чизе дорад, ба ӯ боз зиёд дода мешавад, аммо аз он касе, ки надорад, ҳатто он чизе, ки ба гумони худ дорад, аз вай кашида гирифта мешавад». ");
INSERT INTO tgk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ҳамин вақт модару бародарони Исо ба наздаш омаданд, аммо аз сабаби бисёрии мардум ба Ӯ наздик шуда натавонистанд. ");
INSERT INTO tgk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ба Исо гуфтанд: «Модар ва бародаронатон дар берун истодаанду мехоҳанд Шуморо бубинанд». ");
INSERT INTO tgk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ӯ ҷавоб дод: «Модар ва бародарони Ман онҳое ҳастанд, ки каломи Худоро мешунаванд ва онро ба ҷо меоранд». ");
INSERT INTO tgk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Рӯзе аз рӯзҳо Исо бо шогирдонаш ба қаиқ савор шуда ба онҳо гуфт: «Биёед, ба он тарафи кӯл мегузарем». Онҳо равон шуданду ");
INSERT INTO tgk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","дар аснои роҳ Исоро хоб бурд. Баногоҳ дар кӯл тӯфони сахте бархест ва қаиқ аз об пур мешуду ҷони одамон дар хатар мемонд. ");
INSERT INTO tgk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Шогирдон пеши Исо омада, бо суханони «Устод! Устод! Ҳалок мешавем!» Ӯро бедор карданд. Ӯ аз хоб хеста, боду мавҷҳои пурталотумро таъна зад, баъд тӯфон хомӯш шуда, ҳама ҷоро оромӣ фаро гирифт. ");
INSERT INTO tgk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Сипас Вай ба шогирдонаш гуфт: «Имонатон куҷост?!» Шогирдон бо тарсу ҳарос ва тааҷҷуб ба якдигар мегуфтанд: «Ин кист, ки ҳатто ба боду об фармон медиҳад ва онҳо ба Ӯ итоат мекунанд?» ");
INSERT INTO tgk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Баъд аз ин онҳо ба сарзамини Ҷадариён, ки дар рӯ ба рӯи ноҳияи Ҷалил воқеъ аст, омада расиданд. ");
INSERT INTO tgk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Вақте ки Исо ба соҳил фаромад, бо марде аз аҳли он шаҳр вохӯрд, ки гирифтори девҳо буд. Ӯ дер боз дар танаш либос надошт ва на дар хона, балки дар қабрҳо зиндагӣ мекард. ");
INSERT INTO tgk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ҳамин ки ӯ Исоро дид, бо доду фиғон ба пеши пойҳои Ӯ афтид ва бо овози баланд гуфт: «Эй Исо, Писари Худои Таоло, ба ман чӣ кор дорӣ? Илтимос мекунам, маро азоб надеҳ». ");
INSERT INTO tgk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ӯ инро гуфт, чунки Исо аллакай ба рӯҳи нопок фармон дода буд, ки аз он мард берун барояд. Дар гузашта дев чандин бор ба он мард ҳамла меовард ва ҳарчанд девонаро асир намуда, бо занҷиру бандҳо мебастанд, мард онҳоро пора-пора мекард ва дев ӯро ба биёбон мебурд. ");
INSERT INTO tgk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Исо аз ӯ пурсид: «Номи ту чист?» Ӯ гуфт: «Лашкар», чунки девҳои бисёре ба даруни он мард дохил шуда буданд. ");
INSERT INTO tgk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Девҳо аз Исо илтимос мекарданд, ки онҳоро ҷазо дода, ба чоҳи бепоён нафиристад. ");
INSERT INTO tgk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ҳамон ҷо, дар болои теппа галаи калони хукҳо мечарид. Девҳо аз Исо хоҳиш карданд, ки ба даруни хукҳо ҷо шаванд ва Ӯ ба онҳо иҷозат дод. ");
INSERT INTO tgk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Девҳо аз он мард берун шуда, ба даруни хукҳо даромаданд ва он гала аз баландӣ давон-давон худро ба кӯл партофта, ғарқ шуд. ");
INSERT INTO tgk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Хукбонон инро дида гурехтанд ва ҳамаи воқеаро дар шаҳру деҳот овоза карданд. ");
INSERT INTO tgk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Мардум барои дидани ин воқеа ба назди Исо рафтанд ва омада, мардеро диданд, ки девҳо аз ӯ берун рафта буданд. Вай дар тан либос дошту бо ақли солим дар пеши пои Исо менишаст. Ҳамаро тарс фаро гирифт. ");
INSERT INTO tgk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Шоҳидони ин воқеа ба одамон чӣ гуна шифо ёфтани девонаро нақл карданд. ");
INSERT INTO tgk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Баъд аз ин тамоми мардуми сарзамини Ҷадариён аз Исо хоҳиш карданд, ки аз пеши онҳо биравад, зеро онҳоро тарсу ваҳм фаро гирифта буд ва Ӯ барои баргаштан боз ба қаиқ савор шуд. ");
INSERT INTO tgk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Марде, ки девҳо аз ӯ берун шуда буданд, илтимос кард, ки Исо ӯро бо худ бубарад. Вале Исо ӯро ҷавоб дода гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ба хонаат баргард ва аз чунин кори бузурге, ки Худо дар ҳаққи ту кардааст, нақл кун». Ӯ рафта дар тамоми шаҳр дар бораи он кори бузурге, ки Исо барояш карда буд, эълон кард. ");
INSERT INTO tgk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Вақти баргаштани Исо мардуми зиёде, ки Ӯро интизор буданд, ба пешвозаш баромаданд. ");
INSERT INTO tgk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ҳамон вақт Ёир ном марде, ки сардори ибодатхона буд, назди Исо омада ба пеши пойҳояш афтид ва аз Ӯ илтимос кард, ки ба хонаи вай биравад, ");
INSERT INTO tgk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","зеро духтари ягонааш, ки тақрибан дувоздаҳсола буд, дар бистари марг мехобид. Исо ҳамроҳи Ёир мерафт ва мардуми бисёре аз ҳар тараф ба Ӯ фишор меоварданд. ");
INSERT INTO tgk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Як зан дар давоми дувоздаҳ сол гирифтори касалии хунравӣ буд. Вай тамоми буду шудашро ба табибон сарф кард, вале ҳеҷ кас ӯро шифо дода натавонист. ");
INSERT INTO tgk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Он зан аз ақиб ба Исо наздик шуду ба домани ҷомаи Ӯ даст расонд ва ҳамон замон хунравиаш бозмонд. ");
INSERT INTO tgk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Исо пурсид: «Кӣ ба Ман даст расонд?» Вақте ки ҳама инкор карданд, Петрус ба Ӯ гуфт: «Устод! Мардуми зиёде Туро иҳота карда, аз ҳар тараф фишор меоранд». ");
INSERT INTO tgk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Аммо Исо гуфт: «Касе ба Ман даст расонд, зеро Ман ҳис кардам, ки қуввае аз Ман берун рафт». ");
INSERT INTO tgk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Вақте он зан дид, ки дигар пинҳон монда наметавонад, тарсону ларзон омада пеши пои Исо афтид ва дар ҳузури ҳамаи мардум ба Ӯ иқрор шуд, ки чаро ба Ӯ даст расонд ва чӣ тавр зуд шифо ёфт. ");
INSERT INTO tgk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Исо ба ӯ гуфт: «Эй зан, туро имонат шифо дод. Рав ва дар амон бош». ");
INSERT INTO tgk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ҳанӯз ки Ӯ гап мезад, як нафаре аз хонаи Ёир хабар оварда, гуфт: «Духтаратон гузашт, дигар устодро заҳмат надиҳед». ");
INSERT INTO tgk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Вале Исо инро шунида, гуфт: «Натарс, фақат имон дошта бош ва ӯ шифо меёбад». ");
INSERT INTO tgk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Вақте ки Исо ба назди хонаи Ёир омада расид, ба ғайр аз Петрус, Юҳанно, Ёқуб ва падару модари он духтар ба каси дигаре иҷозат надод, ки бо Ӯ ба хона дарояд. ");
INSERT INTO tgk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ҳама барои он духтар гиряву нола мекарданд, вале Исо гуфт: «Дигар гиря накунед, ӯ намурдааст, балки хобидааст». ");
INSERT INTO tgk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Одамон писханде намуданд, зеро аниқ медонистанд, ки духтар мурдааст. ");
INSERT INTO tgk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Аммо Исо дасти духтарро гирифта гуфт: «Эй духтарак, бархез!» ");
INSERT INTO tgk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Вай аз нав зинда шуд ва зуд аз ҷояш бархест. Исо фармуд, ки ба ӯ хӯрок диҳанд. ");
INSERT INTO tgk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Падару модари вай дар ҳайрат монданд, Исо бошад, ба онҳо фармуд, ки ин воқеаро ба касе нагӯянд. ");
INSERT INTO tgk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Исо дувоздаҳ вакилонашро ҷеғ зада, ба онҳо қуввату қудрати берун кардани ҳамаи девҳо ва аз ҳар беморӣ шифо додани одамонро бахшид. ");
INSERT INTO tgk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ӯ онҳоро фиристод, то дар бораи подшоҳии Худо эълон карда, беморонро шифо бахшанд. ");
INSERT INTO tgk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Исо ба онҳо гуфт: «Ба роҳ бо худ ҳеҷ чиз нагиред: на асо, на борхалта, на нон, на пул ва на либоси иловагӣ. ");
INSERT INTO tgk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ба ҳар хонае, ки даромадед, то вақти боз ба роҳ баромадан дар ҳамон ҷо бимонед. ");
INSERT INTO tgk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Вале агар шуморо дар ҷое қабул накунанд, аз он шаҳр берун биравед ва чанги он шаҳрро аз пойҳои худ биафшонед, то шаҳодати айбдор будани онҳо гардад». ");
INSERT INTO tgk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Шогирдон аз он ҷо рафтанду деҳа ба деҳа гашта, хушхабарро эълон мекарданд ва дар ҳама ҷо мардумро шифо мебахшиданд. ");
INSERT INTO tgk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Вақте ки ҳоким Ҳиродус ҳамаи инро шунид, ба як ҳолати ногувор афтод, зеро баъзеҳо мегуфтанд, ки ин Яҳё аз мурдагон зинда шудааст, ");
INSERT INTO tgk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","дигарон бошанд, мегуфтанд, ки Илёс пайғамбар зоҳир гардидааст ва баъзеи дигарон мегуфтанд, ки яке аз пайғамбарони давраҳои қадим зинда шудааст. ");
INSERT INTO tgk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Вале Ҳиродус гуфт: «Охир ман сари Яҳёро аз танаш ҷудо кардам. Пас, ин кист, ки дар борааш чунин суханҳоро мешунавам?» Вай хост Исоро бубинад. ");
INSERT INTO tgk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Вақте ки вакилон баргаштанд, тамоми корҳои иҷрокардаашонро ба Исо баён намуданд. Ӯ онҳоро бо худ гирифта ба шаҳри Байт-Сайдо равона шуд, то ки бо шогирдонаш танҳо ба танҳо бимонад. ");
INSERT INTO tgk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Вале мардум аз ин бохабар шуда, аз пасаш рафтанд ва Исо онҳоро бо хушнудӣ қабул карда, ба онҳо дар бораи подшоҳии Худо нақл кард ва касонеро, ки ба шифо эҳтиёҷ доштанд, шифо дод. ");
INSERT INTO tgk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Рӯз бегоҳ мешуд ва он дувоздаҳ шогирд ба назди Исо омада гуфтанд: «Ин ҷо ҷои беодам аст. Мардумро ҷавоб намедиҳед, ки ба қишлоқҳо ва деҳоти гирду атроф рафта, барои худ ҷои хоб ва хӯроке пайдо кунанд?» ");
INSERT INTO tgk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Вале Вай ба онҳо гуфт: «Шумо ба онҳо хӯрок диҳед». Шогирдон гуфтанд: «Мо фақат панҷ нону ду моҳӣ дорем. Магар ин ки худамон рафта, барои тамоми мардум хӯрок бихарем». ");
INSERT INTO tgk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Дар он ҷо тақрибан панҷ ҳазор мард буд ва Исо ба шогирдонаш гуфт: «Онҳоро панҷоҳнафарӣ гурӯҳ-гурӯҳ шинонед». ");
INSERT INTO tgk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Онҳо гуфтаи Исоро ба ҷо оварда, ҳамаро шинонданд. ");
INSERT INTO tgk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Баъд Ӯ он панҷ нону ду моҳиро ба дасташ гирифта, ба осмон нигаристу аз Худо баракат талабид ва нонҳоро пора карда, ба шогирдонаш дод, то ба мардум тақсим бикунанд. ");
INSERT INTO tgk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ҳама то сер шудан хӯрданд ва аз пораҳои боқимонда боз дувоздаҳ сабад пур шуд. ");
INSERT INTO tgk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Рӯзе, вақте ки Исо дар танҳоӣ дуо мекарду дар наздаш фақат шогирдонаш буданд, аз онҳо пурсид: «Мардум дар бораи кӣ будани Ман чӣ мегӯянд?» ");
INSERT INTO tgk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Дар ҷавоб гуфтанд: «Баъзеҳо мегӯянд, ки Шумо Яҳёи Таъмиддиҳанда ҳастед, баъзеи дигарашон фикр мекунанд, ки Шумо Илёс ҳастед ва дигарон мегӯянд, ки яке аз пайғамбарони қадим зинда шудааст». ");
INSERT INTO tgk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ӯ аз онҳо пурсид: «Шумо чӣ? Шумо Маро кӣ мешуморед?» Петрус ҷавоб дод: «Ту Масеҳ, яъне Таъиншудаи Худо ҳастӣ». ");
INSERT INTO tgk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Баъд Исо онҳоро таъкид карда фармон дод, ки дар ин бора ба касе чизе нагӯянд. ");
INSERT INTO tgk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Сипас, суханашро давом дода гуфт: «Фарзанди Инсон бояд бисёр азоб кашад. Пирони қавм, сардорони рӯҳонӣ ва шариатдонон аз Вай рӯй мегардонанд. Ӯ кушта мешавад, вале баъд аз се рӯз аз нав зинда мегардад». ");
INSERT INTO tgk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Пас аз он Исо ба ҳама гуфт: «Ҳар касе, ки аз байни шумо пайрави Ман шудан мехоҳад, бояд аз манфиатҳои худ даст кашида, ҳар рӯз салиби азобу маргашро бардошта барад, он гоҳ Маро пайравӣ кунад. ");
INSERT INTO tgk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Зеро касе, ки ҳаёташро нигоҳ доштан мехоҳад, онро аз даст медиҳад, вале ҳар касе, ки ба хотири Ман ҳаёташро фидо мекунад, онро нигоҳ медорад. ");
INSERT INTO tgk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ба одам чӣ фоидае дорад, ки тамоми дунёро ба даст овараду ҷонашро аз даст диҳад ва ҷазо бинад? ");
INSERT INTO tgk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Зеро ҳар кӣ аз Ман ва аз суханонам шарм кунад, Фарзанди Инсон низ, ҳангоме ки дар дурахши ҷалоли худ, шӯҳрату ҷалоли Падар ва фариштагони муқаддас меояд, аз ӯ шарм хоҳад кард. ");
INSERT INTO tgk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ба ростӣ ба шумо мегӯям, дар ин ҷо чанд касе ҳастанд, ки ҳанӯз дар қайди ҳаёт буданашон подшоҳии Худоро мебинанд». ");
INSERT INTO tgk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Аз ин гуфтугӯ тақрибан ҳашт рӯз гузашт. Исо Петрус, Юҳанно ва Ёқубро бо худ гирифта, барои дуогӯӣ ба болои кӯҳе баромад. ");
INSERT INTO tgk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Вақте ки Ӯ ба дуогӯӣ машғул буд, чеҳрааш тағйир ёфта, либосаш сап-сафеди дурахшон шуд ");
INSERT INTO tgk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","ва инак ду мард, Мӯсою Илёс дар шӯҳрату ҷалол зоҳир гардиданд. Онҳо бо Исо гуфтугӯ карда нақл мекарданд, ки Ӯ дар Ерусалим бояд аз ин дунё равад ва бо ҳамин мақсадашро анҷом медиҳад. ");
INSERT INTO tgk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Петрус ва ҳамроҳонашро хоб бурд ва ҳангоме ки бедор шуданд, шӯҳрату ҷалоли Исо ва он ду мардро, ки бо Ӯ меистоданд, диданд. ");
INSERT INTO tgk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Вақте ки он ду нафар аз пеши Исо рафтанӣ шуданд, Петрус гуфт: «Эй Устод! Чӣ хуб аст, ки мо ин ҷо ҳастем. Биёед, ҳоло се хайма месозем: яке — барои Шумо, дигаре — барои Мӯсо ва сеюм — барои Илёс». Вай худаш намедонист, ки чӣ мегӯяд. ");
INSERT INTO tgk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Петрус ҳанӯз суханашро тамом накарда, абре пайдо шуда, онҳоро бо сояаш фаро гирифт ва вақте ки Мӯсо ва Илёс ба даруни абр даромаданд, шогирдон тарсиданд. ");
INSERT INTO tgk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ҳамин вақт аз абр овозе шунида шуд, ки мегуфт: «Ин Писари Ман аст, Ман Вайро интихоб кардаам. Ӯро гӯш кунед». ");
INSERT INTO tgk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Вақте ки овоз гум шуд, Исо боз танҳо монд. Шогирдон хомӯш монданд ва ҳамон вақт аз он чӣ дида буданд, ба касе чизе нагуфтанд. ");
INSERT INTO tgk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Рӯзи дигар, вақте ки онҳо аз кӯҳ мефаромаданд, мардуми бисёре Исоро пешвоз гирифтанд. ");
INSERT INTO tgk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ногаҳон марде аз миёни мардум фарёд зад: «Устод! Аз Шумо илтимос мекунам, ки ба писарам як назар андозед, зеро ӯ фарзанди ягонаи ман аст. ");
INSERT INTO tgk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Гоҳ-гоҳ ба вай рӯҳе ҳамла мекунад ва ӯ якбора дод зада, беихтиёрона печутоб мехӯраду аз даҳонаш кафк мебарояд. Он рӯҳ ӯро бисёр азоб дода, ба зӯрӣ аз ӯ даст мекашад. ");
INSERT INTO tgk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Аз шогирдонатон илтимос кардам, ки он рӯҳро берун кунанд, аммо онҳо натавонистанд». ");
INSERT INTO tgk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Исо дар ҷавоб гуфт: «Эй насли беимонону гумроҳон! То кай бо шумо бошам ва то кай шуморо тоқат кунам? Писаратро ин ҷо биёр!» ");
INSERT INTO tgk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Вақте ки писар ба назди Исо меомад, дев ӯро ба замин ғалтонда, печутоб дод. Вале Исо рӯҳи нопокро манъ карду писарро шифо бахшида, ба падараш супорид ");
INSERT INTO tgk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ва ҳама аз бузургии қудрати Худо дар ҳайрат монданд. Дар ҳоле, ки мардум аз тамоми корҳои кардаи Исо дар тааҷҷуб буданд, Вай ба шогирдонаш гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Он чизеро, ки ҳоло мегӯям, бишнавед ва дар ёд доред: Фарзанди Инсон ба дасти одамон супорида мешавад». ");
INSERT INTO tgk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Вале шогирдон маънои ин суханонро нафаҳмиданд, чунки маънояш аз онҳо пӯшида монд, ба тавре ки онро дарк накарданд ва ҳам метарсиданд, ки дар ин бора аз Исо чизе бипурсанд. ");
INSERT INTO tgk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Шогирдон байни худ баҳс мекарданд, ки кадоме аз онҳо бузургтар аст. ");
INSERT INTO tgk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Исо медонист, ки онҳо дар дили худ чӣ фикр доранд, бинобар ин кӯдакеро гирифта, ба паҳлӯи худ гузошт ");
INSERT INTO tgk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ва ба онҳо гуфт: «Ҳар кӣ ба хотири Ман ин кӯдакро қабул кунад, дар асл Маро қабул мекунад ва ҳар кӣ Маро қабул кунад, касеро қабул мекунад, ки Маро фиристодааст. Зеро он касе, ки дар байни шумо аз ҳама хурдтарин аст, бузургтарин мебошад». ");
INSERT INTO tgk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Он вақт Юҳанно гуфт: «Хоҷа, мардеро дидем, ки аз номи Шумо девҳоро берун мекард, аммо чун ӯ бо мо нест, кӯшиш кардем, ки ӯро аз ин кор боздорем». ");
INSERT INTO tgk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Исо ба ӯ гуфт: «Ӯро аз ин кор бознадоред! Зеро касе ки бар зидди шумо нест, тарафдори шумост». ");
INSERT INTO tgk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Азбаски то ба осмон бурда шудани Исо вақт кам монда буд, Ӯ қарори қатъӣ қабул кард, ки ба сӯи Ерусалим равона гардад. ");
INSERT INTO tgk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Исо одамонашро пешопеши худ фиристод ва онҳо ба деҳаи сомариён даромада, барои омадани Ӯ ҳама чизро тайёр намуданд. ");
INSERT INTO tgk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Аммо сомариён Исоро қабул накарданд, зеро Ӯ ба Ерусалим равона буд. ");
INSERT INTO tgk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Шогирдонаш Ёқуб ва Юҳанно инро дида гуфтанд: «Худовандо! Биёед, мегӯем, ки аз осмон оташе борида онҳоро нобуд созад?» ");
INSERT INTO tgk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Вале Исо ба Ёқубу Юҳанно рӯ оварда, онҳоро сарзаниш кард ва ҳама ба деҳаи дигаре равон шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Онҳо сафарашонро давом медоданд ва дар роҳ марде ба Исо гуфт: «Ман дар ҳама ҷо Шуморо пайравӣ мекунам». ");
INSERT INTO tgk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Исо ба ӯ ҷавоб дод: «Рӯбоҳон хона ва мурғони ҳаво лона доранд, аммо Фарзанди Инсон ҷое надорад, ки сарашро монда дам гирад» ");
INSERT INTO tgk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ва ба дигаре гуфт: «Аз паси Ман биё». Аммо ӯ ҷавоб дод: «Хоҷаам, иҷозат диҳед, ки аввал ба хонаам баргашта, падарамро ба хок супорам». ");
INSERT INTO tgk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Исо ба ӯ гуфт: «Бигзор мурдагон мурдаҳои худро ба хок супоранд, вале ту рафта, дар бораи подшоҳии Худо эълон бикун». ");
INSERT INTO tgk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Шахси дигаре ба Исо гуфт: «Хоҷаам! Ман аз паят меравам, вале иҷозат деҳ, ки аввал бо аҳли хонаводаам хайрухуш кунам». ");
INSERT INTO tgk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Исо ба вай гуфт: «Касе, ки ба шудгор кардан шурӯъ менамояду баъд ба ақиб нигоҳ мекунад, лоиқ нест, ки дар подшоҳии Худо бошад». ");
INSERT INTO tgk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Баъд аз ин Худованд боз ҳафтод нафари дигарро интихоб намуда, онҳоро ҷуфт-ҷуфт пешопеши худ ба ҳар шаҳру деҳоте, ки рафтанӣ буд, фиристод. ");
INSERT INTO tgk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ӯ ба онҳо гуфт: «Ҳосили дарав фаровон аст, вале коргарон намерасанд. Аз ин рӯ, аз соҳиби ҳосил илтимос кунед, ки барои ғундоштани ҳосилаш коргаронро фиристад. ");
INSERT INTO tgk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Биравед! Ҳоло шуморо мисли барра ба байни гургҳо мефиристам. ");
INSERT INTO tgk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Бо худ ҳеҷ пул, борхалта ва ё пойафзоли иловагӣ нагиреду дар роҳ бо касе дурудароз саломуалейк накунед. ");
INSERT INTO tgk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ба ҳар хонае, ки медароед, аввал бигӯед: „Сулҳ бод бар ин хонадон!“ ");
INSERT INTO tgk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Агар дар он ҷо шахси сулҳпарваре бошад, сулҳи шумо бо ӯ мемонад вагарна, он ба сӯи шумо бармегардад. ");
INSERT INTO tgk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Пас дар ба дар нагардеду дар ҳамон хона бимонед ва аз он чи ки доранд, бихӯреду бинӯшед, зеро коргар лоиқи он аст, ки музди корашро бигирад. ");
INSERT INTO tgk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Агар ба ягон шаҳр дароеду шуморо дар он ҷо қабул кунанд, ҳар хӯрокеро, ки пешатон гузоранд, бихӯред, ");
INSERT INTO tgk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","беморони он шаҳрро шифо диҳед ва бигӯед: „Подшоҳии Худо ба шумо наздик омадааст“. ");
INSERT INTO tgk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Вале агар ба шаҳре дароеду шуморо қабул накунанд, дар кӯчаҳояш гашта, чунин бигӯед: ");
INSERT INTO tgk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","„Ҳатто чангу ғубори шаҳри шуморо, ки бар пои мо нишастааст, афшонда ба шумо бармегардонем, вале аниқ бидонед, ки подшоҳии Худо наздик омадааст“. ");
INSERT INTO tgk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ба шумо мегӯям, ки дар ҳамон рӯз аҳволи шаҳрвандони бадкирдори Садӯм аз ҳоли он шаҳр сабуктар хоҳад буд. ");
INSERT INTO tgk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Эй аҳли Кӯрозину аҳли Байт-Сайдо, вой бар ҳоли шумо! Зеро агар он мӯъҷизоте, ки Ман дар байни шумо нишон додам, дар шаҳрҳои Сур ва Сидун рӯй медоданд, одамони он кайҳо тавба карда, бар тан либоси дағал пӯшида, мӯйканон нишаста нишон медоданд, ки онҳо аз гуноҳҳояшон даст кашидаанд. ");
INSERT INTO tgk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Бинобар ин дар рӯзи ҷазо аҳволи шаҳрвандони Суру Сидун аз ҳоли шумо сабуктар хоҳад буд. ");
INSERT INTO tgk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Инчунин шумо, эй аҳли Кафарнаҳум, гумон мекунед, ки саратон то ба осмон мерасад, аммо шумо ба дӯзах партофта мешавед. ");
INSERT INTO tgk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ҳар кӣ шуморо, шогирдонам, гӯш кунад, Маро гӯш мекунад ва ҳар кӣ аз шумо рӯй гардонад, аз Ман рӯй мегардонад ва ҳар кӣ аз Ман рӯй гардонад, аз шахсе рӯй мегардонад, ки Маро фиристодааст». ");
INSERT INTO tgk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ҳафтод нафар шогирдон бо хушҳолӣ баргашта, ба Исо гуфтанд: «Худовандо! Бо номи Ту ҳатто девҳо ба мо итоат мекунанд». ");
INSERT INTO tgk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ӯ ба онҳо гуфт: «Ман дидам, ки шайтон барқвор аз осмон ба поён афтод; ");
INSERT INTO tgk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ҳоло Ман ба шумо қудратеро додам, ки морону каждумон ва тамоми қувваи душманро поймол кунед ва ба шумо ҳеҷ чиз зарар расонда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Вале на барои он шод бошед, ки рӯҳҳо ба шумо итоат мекунанд, балки барои он шодӣ кунед, ки номҳоятон дар осмон навишта шудаанд». ");
INSERT INTO tgk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Худи ҳамон лаҳза Исо аз Рӯҳи Муқаддас пур шуда, бо хушҳолӣ гуфт: «Шукри Туро мекунам, эй Падарҷон, ҳокими замину осмон, ки ин чизҳоро аз оқилон ва хирадмандон пӯшида мондиву ба одамони оддӣ ошкор сохтӣ. Бале, Падар, хоҳиши неки Ту чунин буд. ");
INSERT INTO tgk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Падарам ҳама чизро ба Ман додааст. Ҳеҷ кас ғайр аз Падар намедонад, ки Писар кист. Инчунин ғайр аз Писар ва онҳое, ки Писар интихоб кардааст, то Падарро барояшон зоҳир кунад, ҳеҷ кас намедонад, ки Падар кист». ");
INSERT INTO tgk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Сипас, Исо ба шогирдонаш рӯ оварда, фақат ба онҳо гуфт: «Хушбахтанд чашмоне, ки чизи шумо медидаро мебинанд! ");
INSERT INTO tgk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Зеро ба шумо мегӯям, ки пайғамбарон ва подшоҳони бисёре мехостанд он чизеро бубинанд ва бишнаванд, ки шумо мебинед ва мешунавед. Вале онҳо на диданду на шуниданд». ");
INSERT INTO tgk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ҳамин вақт яке аз қонуншиносон бархест ва Исоро озмуданӣ шуда, ба Ӯ чунин савол дод: «Устод! Чӣ кор бояд бикунам, ки ҳаёти абадӣ насибам гардад?» ");
INSERT INTO tgk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Исо ҳам аз вай пурсид: «Дар шариат чӣ навишта шудааст? Шумо аз он ҷо чӣ мехонед?» ");
INSERT INTO tgk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Вай ҷавоб дод: «Худованд Худои худро бо тамоми дилу ҷонамон ва бо тамоми қуввату ақлу ҳушамон дӯст бидорем ва шахсеро, ки наздики мост, мисли худ дӯст бидорем». ");
INSERT INTO tgk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Исо гуфт: «Дуруст ҷавоб додӣ. Ҳамин тавр бикун ва ҳаёт хоҳӣ дошт». ");
INSERT INTO tgk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Вале ӯ худро сафед карданӣ шуда ба Исо гуфт: «Пас, шахси наздики ман кист?» ");
INSERT INTO tgk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Исо дар ҷавоб гуфт: «Марде, ки аз Ерусалим ба Ериҳӯ мерафт, ба дасти роҳзанҳо афтид. Онҳо ӯро ғорат карда хуб заданд ва дар ҳолати ниммурда партофта рафтанд. ");
INSERT INTO tgk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Тасодуфан аз ҳамон роҳ рӯҳоние мегузашт ва чун ӯро дид, аз тарафи дигари роҳ гузашта рафт. ");
INSERT INTO tgk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ҳамчунин марде аз тоифаи Левӣ аз он ҷо мегузашт ва марди захмдорро дидан замон, ӯ низ аз тарафи дигари роҳ гузашта рафт. ");
INSERT INTO tgk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Вале марди сомарие, ки аз он ҷо савора мегузашт, ба вай наздик шуда, ӯро дид ва дилаш ба ҳоли ӯ сӯхт. ");
INSERT INTO tgk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Сипас назди ӯ омада, захмҳояшро бо шароб тоза карду равған молида баст. Баъд ӯро бардошта ба хараш савор карду ба меҳмонхонае овард ва дар ҳамон ҷо ӯро нигоҳубин намуд. ");
INSERT INTO tgk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Рӯзи дигар ба соҳиби меҳмонхона ду динор дода гуфт: „Ӯро нигоҳубин кун ва агар харҷат аз ин зиёдтар шавад, вақти баргаштанам онро ба ту бармегардонам“. ");
INSERT INTO tgk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Хӯш, ба фикри ту кадоме аз ин се нафар ба он марде, ки аз дасти роҳзанҳо ҷабр дида буд, шахси наздик ҳисоб мешавад?» ");
INSERT INTO tgk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","«Он касе, ки ба ӯ раҳм кард», — ҷавоб дод шариатдон. «Пас, бирав ва монанди ӯ рафтор кун», — гуфт Исо. ");
INSERT INTO tgk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Исо ва шогирдонаш сафарашонро давом дода, ба деҳае ворид гаштанд. Дар ҳамон ҷо Марто ном зане Ӯро дар хонаи худ меҳмондорӣ кард. ");
INSERT INTO tgk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Вай Марям ном хоҳаре дошт, ки пеши пои Исо нишаста ба суханони Ӯ гӯш медод. ");
INSERT INTO tgk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Марто, ки барои меҳмондорӣ намудан бисёр даводав мекард, ба назди Исо омада гуфт: «Хоҷаам! Шумо парвое надоред, ки хоҳарам ҳамаи корро ба сари ман партофтааст? Охир, бигӯед, ки ба ман ёрӣ диҳад». ");
INSERT INTO tgk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","«Марто! Марто! — гуфт ба вай Худованд, — ту ғами бисёр чизҳоро хӯрда, даводав мекунӣ. ");
INSERT INTO tgk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Вале фақат як чиз лозим аст. Марям қисми хуберо интихоб намудааст ва онро аз ӯ ҳеҷ кас гирифта наметавонад». ");
INSERT INTO tgk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Рӯзе дар ҷое Исо машғули дуогӯӣ буд. Вақте ки дуояшро тамом кард, яке аз шогирдонаш ба Ӯ гуфт: «Худовандо! Ҳамон тавре ки Яҳё ба шогирдонаш ёд дода буд, Ту низ ба мо тарзи дуогӯйиро ёд деҳ». ");
INSERT INTO tgk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Исо ба онҳо гуфт: «Вақте ки дуо мекунед, чунин бигӯед: Эй Падар! Шаъну шараф бод ба номи муқаддаси Ту. Бигзор подшоҳии Ту биёяд; ");
INSERT INTO tgk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ба мо ризқу рӯзии ҳаррӯзаамонро бидеҳ ");
INSERT INTO tgk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ва гуноҳҳои моро бубахш, чунон ки мо онҳоеро мебахшем, ки бо мо нодуруст рафтор мекунанд ва моро ба озмоиш дучор накун». ");
INSERT INTO tgk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Пас ба онҳо гуфт: «Фарз мекунем, ки яке аз шумо дӯсте дореду ними шаб ба хонаи ӯ рафта, мегӯед: „Эй дӯст, ба ман се дона нон қарз деҳ, ");
INSERT INTO tgk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","чун яке аз дӯстонам, ки дар сафар буд, ба хонаам омадааст ва ман чизе надорам, ки пеши ӯ гузорам“. ");
INSERT INTO tgk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Вале ӯ аз даруни хона чунин ҷавоб медиҳад: „Маро ташвиш надеҳ, чунки дари хонаам баста аст ва ману бачаҳоям аллакай дар ҷойгаҳ хобидаем, ҳоло наметавонам хеста ба ту нон диҳам“. ");
INSERT INTO tgk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ба шумо мегӯям, агар ӯ аз рӯи дӯстӣ хеста чизе надиҳад, азбаски беист талаб мекунед, маҷбур мешавад, ки хезаду он чизеро, ки талаб мекунед, ба шумо диҳад. ");
INSERT INTO tgk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Бинобар ин Ман ҳам ба шумо мегӯям: талаб кунед ва ба шумо дода мешавад; биҷӯед ва пайдо мекунед; дарро бикӯбед ва он ба рӯятон кушода мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Чун ҳар кӣ талаб мекунад, ба даст меорад; ҳар кӣ меҷӯяд, пайдо мекунад; ва ҳар касе, ки дарро мекӯбад, он ба рӯяш кушода мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Оё дар байни шумо чунин падаре ёфт мешавад, ки агар писараш аз ӯ моҳӣ бипурсад, ба ҷои моҳӣ ба дасташ мори заҳрдор диҳад? ");
INSERT INTO tgk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ё агар писараш тухм бипурсад, ба ҷояш каждум ба ӯ диҳад? ");
INSERT INTO tgk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Пас, агар шумо бо ҳамаи дилсиёҳиатон ба фарзандони худ чизҳои хуб дода тавонед, наход Падари осмонӣ Рӯҳи Муқаддасро чанд маротиба зиёдтар ба онҳое надиҳад, ки аз Ӯ талаб мекунанд». ");
INSERT INTO tgk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Боре Исо деви як мардро берун кард. Ин дев, деви гунгӣ буд ва вақте ки ӯ берун баромад, марди гунг ба гап даромаду мардум ба ҳайрат афтоданд. ");
INSERT INTO tgk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Баъзеи одамон чунин мегуфтанд: «Исо девҳоро бо қудрати Баал-Забул, сардори девҳо берун мекунад». ");
INSERT INTO tgk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Дигарон бошанд, Ӯро озмуданӣ шуда, талаб мекарданд, ки аз ҷониби Худо нишонае диҳад. ");
INSERT INTO tgk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Вале Исо, ки аз фикрҳои онҳо бохабар буд, гуфт: «Ҳар давлате, ки дар дохили худ аз ҳам ҷудо шуда ҷанг мекунад, ба зудӣ барҳам мехӯрад ва ҳар хонае, ки дар байни аъзоёнаш ҷудоӣ меафтад, вайрон мегардад. ");
INSERT INTO tgk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Инак, агар шайтон дар худ ба ду қисм ҷудо шавад, магар давлаташ устувор монда метавонад? Шумо мегӯед, ки Ман девҳоро ба воситаи Баал-Забул берун мекунам. ");
INSERT INTO tgk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Агар Ман девҳоро бо қудрати Баал-Забул берун мекарда бошам, пас, пайравони худатон-чи? Онҳо бо кадом қудрат берун мекунанд? Бигзор онҳо шуморо ҳукм кунанд. ");
INSERT INTO tgk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Аммо, агар Ман бо қувваи Худо девҳоро берун мекарда бошам, аз ин бармеояд, ки подшоҳии Худо аллакай ба ҳаёти шумо омадааст. ");
INSERT INTO tgk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Вақте ки марди пурзӯру мусаллаҳ қасрашро посбонӣ мекунад, ба чизу чораи ӯ зараре намерасад. ");
INSERT INTO tgk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Вале ҳангоме ки шахси аз вай пурзӯртар ба ӯ ҳамла карда, ғолиб мебарояд, аслиҳаеро, ки соҳиби хона ба он умед баста буд, аз вай кашида мегираду чизи бадастовардаашро бо шариконаш тақсим мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Касе, ки тарафдори Ман нест, дар асл муқобили Ман аст ва касе, ки дар ҷамъ овардани одамон ба Ман ёрӣ намедиҳад, дар асл онҳоро пароканда мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Фарз кардем, рӯҳи нопок аз шахсе берун карда мешавад. Баъд ин рӯҳ бо нияти пайдо кардани манзили зист ҷойҳои беобро давр мезанаду онро наёфта, ба худ мегӯяд: „Э, ба хонаи пештараам бармегардам“, — ");
INSERT INTO tgk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ва баргашта мебинад, ки ин хона ба тартиб овардаву рӯбучиншуда аст. ");
INSERT INTO tgk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Пас, рӯҳи нопок рафта, ҳафт рӯҳи аз худаш ҳам бадтарро меорад ва ҳамаи онҳо ба он хона даромада зиндагӣ мекунанд. Дар натиҷа аҳволи он шахс аз ҳолати аввалааш ҳам бадтар хоҳад шуд». ");
INSERT INTO tgk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ҳангоме ки Исо ин суханонро мегуфт, зане аз миёни мардум хитоб кард: «Хушбахт аст он зане, ки Шуморо таваллуд карда шир додааст!» ");
INSERT INTO tgk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Исо бошад гуфт: «Вале онҳое, ки каломи Худоро мешунаванду аз рӯи он амал мекунанд, хушбахттаранд». ");
INSERT INTO tgk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Мардуми зиёде дар гирди Исо ҷамъ меомаданд ва Ӯ сухан оғоз намуда гуфт: «Чӣ бад аст насли ҳозира, ки нишонаеро талаб мекунад, вале ғайр аз нишонаи Юнуси пайғамбар ба онҳо нишонаи дигаре дода намешавад. ");
INSERT INTO tgk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Зеро, ҳамон тавре ки Юнус бар мардуми шаҳри Нинве нишонае буд, Фарзанди Инсон низ бар ин насл нишонае хоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Дар рӯзи ҷазо маликаи сарзамини Сабо бархеста ин наслро айбдор мекунад, зеро ӯ аз як гӯшаи дунё барои шунидани ҳикмати шоҳ Сулаймон омада буд. Ҳол он ки каси бузургтар аз Сулаймон дар ин ҷост! ");
INSERT INTO tgk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Дар рӯзи ҷазо бошад, шаҳрвандони Нинве бархеста, насли шуморо айбдор мекунанд, зеро онҳо бо шунидани пайғоми Юнус тавба карданду аз гуноҳҳояшон даст кашиданд. Ҳол он ки каси бузургтар аз Юнус дар ин ҷост! ");
INSERT INTO tgk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ҳеҷ кас чароғро даргиронда, ба ҷои чашмнорас ва ё ба таги тағора намегузорад, баръакс, онро ба чароғпояе мегузорад, то онҳое, ки ба хона медароянд, равшаниро бубинанд. ");
INSERT INTO tgk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Чашм чароғи бадан аст. Чун чашм солим аст, бадани одам пур аз равшанӣ мегардад, вале агар солим набошад, одамро торикӣ фаро мегирад. ");
INSERT INTO tgk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Эҳтиёт бошед, то он нуре, ки дар шумост, боз торикӣ набошад! ");
INSERT INTO tgk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Пас, агар тамоми баданатон пур аз равшанӣ бошаду дар худ ҳеҷ торикие надошта бошед, ба монанди он чароғе, ки бо дурахши худ шуморо мунаввар месозад, тамоми баданатон равшан хоҳад буд». ");
INSERT INTO tgk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Вақте ки Исо ин суханонро мегуфт, яке аз фарисиён Ӯро ба хонаи худ ба меҳмонӣ даъват намуд ва Исо ба хонаи ӯ даромада, ба сари дастархон нишаст. ");
INSERT INTO tgk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Фарисӣ ҳайрон шуд, ки Исо пеш аз хӯрдани хӯрок даст нашуст. ");
INSERT INTO tgk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Вале Худованд ба он фарисӣ гуфт: «Ҳамин шумо, фарисиён, беруни косаву табақи худро мешӯед, аммо дарунатон пур аз хасисию бадӣ аст. ");
INSERT INTO tgk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Эй беақлон! Оё ҳамон як Офаранда тамоми чизеро, ки ҳам дар берун ва ҳам дар дарун аст, наофаридааст? ");
INSERT INTO tgk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Пас он чӣ дар даруни коса доред ба камбағалон садақа диҳед ва ҳама чиз бароятон пок мегардад. ");
INSERT INTO tgk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Вой бар ҳоли шумо, эй фарисиён, ки аз ҳосили пудинаву кашнизу дигар намуди гиёҳҳо ҳиссаи даҳумро ба Худо месупоред, аммо таълимотро дар бораи адолат ва муҳаббати Худо беаҳамият мемонед. Шумо мебоист ин қонунҳоро риоя мекардеду қонунҳои дигарро низ беэътибор намемондед. ");
INSERT INTO tgk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Вой бар ҳолатон, эй фарисиён, шумо дӯст медоред, ки дар ибодатхонаҳо болонишин бошеду дар бозорҳо ба шумо салом диҳанд. ");
INSERT INTO tgk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Вой бар ҳоли шумо, ки ба қабрҳои белавҳасанг монанд ҳастед ва мардум нафаҳмида онҳоро зери по мекунанду ҳаром мешаванд». ");
INSERT INTO tgk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Он гоҳ яке аз қонуншиносон ба Исо гуфт: «Устод! Шумо бо ин суханонатон моро ҳам таҳқир мекунед». ");
INSERT INTO tgk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Вале Исо гуфт: «Вой бар ҳоли шумо низ, эй шариатдонон, ки бори бениҳоят вазнинро ба гардани мардум бор мекунеду дастатонро ҳам намеҷунбонед, ки ба онҳо ёрӣ диҳед. ");
INSERT INTO tgk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Вой бар ҳоли шумо, ки барои пайғамбарон мақбараҳо месозед. Охир, ҳамон пайғамбаронро аҷдодони шумо куштаанд. ");
INSERT INTO tgk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Бо ин амалатон шумо тасдиқ мекунед, ки бо корҳои аҷдодонатон розӣ ҳастед, чунки онҳо пайғамбаронро мекуштанд, шумо бошед, барои пайғамбарон мақбараҳо месозед. ");
INSERT INTO tgk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Барои ҳамин Ҳикмати Худо эълон мекунад: „Ба наздашон пайғамбарону вакилонро мефиристам ва онҳо баъзеашонро мекушанду баъзеи дигарашонро дунболагирӣ мекунанд“. ");
INSERT INTO tgk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Пас мардуми ин насл барои хуни тамоми пайғамбароне, ки аз аввали офариниши дунё рехта шудааст, ҷазо хоҳанд дид, ");
INSERT INTO tgk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","яъне аз хуни Ҳобил сар карда, то хуни Закарё, ки дар байни қурбонгоҳу муқаддастарин ҷои Хонаи Худо кушта шуда буданд. Бале, бидонед, ки мардуми ин насл барои ҳамаи ин ҷавоб хоҳад дод. ");
INSERT INTO tgk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Вой бар ҳоли шумо, эй қонуншиносон, ки калиди дарвозаи донишро бо худ бурда, ҳам худатон аз он надаромадед ва ҳам ба онҳое, ки мехоҳанд дароянд, монеъ мешавед». ");
INSERT INTO tgk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Вақте Исо аз он ҷо мерафт, шариатдонон ва фарисиёни бағазабомада Ӯро ба ҳолаш нагузошта, аз ҳар хусус саволборон мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Онҳо мехостанд аз забони Исо сухани нолоиқеро шунида, ба Ӯ тӯҳмат кунанд. ");
INSERT INTO tgk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Дар ин миён ҳазор-ҳазор одамон ҷамъ омада, якдигарро тела медоданд ва Исо аввал ба шогирдони худ муроҷиат карда гуфт: «Худро аз хамиртуруши фарисиён, ки дурӯягӣ аст, эҳтиёт кунед. ");
INSERT INTO tgk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Зеро ҳеҷ чизи пӯшидае нест, ки ошкор нашавад ва ҳеҷ чизи пинҳоне нест, ки маълум нагардад. ");
INSERT INTO tgk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Пас он чиро, ки дар торикӣ гуфта будед, дар рӯшноӣ хоҳанд шунид ва он чиро, ки шумо дар пинҳонӣ пичиррос карда гуфтед, аз болои бомҳо эълон хоҳанд кард. ");
INSERT INTO tgk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ба шумо мегӯям: Эй дӯстонам, аз онҳое, ки ҷисматонро мекушанд ва баъд аз он ҳеҷ кори дигаре карда наметавонанд, натарсед. ");
INSERT INTO tgk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ман ба шумо мефаҳмонам, ки аз кӣ бояд тарсед. Аз он касе тарсед, ки баъд аз куштан шуморо ба дӯзах партофта метавонад. Бале, ба шумо мегӯям, ки аз Ӯ бояд битарсед. ");
INSERT INTO tgk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Магар ба ду танга панҷ гунҷишк фурӯхта намешавад? Вале Худо ҳар як гунҷишкро ҳам дар хотираш нигоҳ медорад ");
INSERT INTO tgk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ва ҳар тори мӯйи саратон ҳам ба ҳисоб гирифта шудааст. Бинобар ин натарсед, шумо аз бисёр гунҷишкҳо ҳам қиматтар ҳастед. ");
INSERT INTO tgk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ба шумо мегӯям: ҳар кӣ дар пеши мардум гӯяд, ки пайрави Ман аст, Фарзанди Инсон низ дар назди фариштагони Худо пайрави Ман будани ӯро тасдиқ мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Лекин, ҳар кӣ дар пеши мардум Маро рад кунад, Фарзанди Инсон низ дар пеши фариштагони Худо ӯро рад мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ҳар кӣ бар зидди Фарзанди Инсон сухане бигӯяд, бахшида мешавад, лекин касе, ки бар зидди Рӯҳи Муқаддас сухани кофирона бигӯяд, бахшида нахоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Вақте шуморо ба ибодатхонаҳо, ба назди сардорону ҳукуматдорон меоранд, ғам нахӯред, ки чӣ хел бояд ҷавоб диҳед ё чӣ бояд гӯед. ");
INSERT INTO tgk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Зеро Рӯҳи Муқаддас ба шумо ёд медиҳад, ки ҳамон лаҳза чӣ бояд бигӯед». ");
INSERT INTO tgk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Марде аз байни мардум ба Исо гуфт: «Устод! Ба бародарам бигӯ, ки меросро бо ман тақсим кунад». ");
INSERT INTO tgk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Исо ҷавоб дод: «Эй мард, кӣ Маро бар шумо қозӣ ё довар таъин кардааст?» ");
INSERT INTO tgk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Сипас, ба ҳама муроҷиат карда гуфт: «Аз ҳар гуна ҳирсу чашмгуруснагӣ ҳазар кунед, зеро ҳаёти одам аз зиёдатии бойигариаш иборат нест». ");
INSERT INTO tgk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Баъд ба онҳо масалеро гуфт: «Замини як марди бой ҳосили фаровоне ба бор овард. ");
INSERT INTO tgk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Вай худ ба худ фикр карда гуфт: „Чӣ кор бояд кунам, охир барои ҷамъ кардани ҳосили худ ҷое надорам?“ ");
INSERT INTO tgk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Баъд гуфт: „Ана чӣ кор мекунам — анборҳои худро вайрон карда, калонтарашро месозам ва тамоми ҳосилу бойигариамро ба он ҷо бурда, ");
INSERT INTO tgk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ба худ мегӯям: Акнун ту бойигарии бисёре дорӣ, ки барои солҳои зиёде мерасад. Истироҳат кун, бихӯр, бинӯш ва аз кайфу сафои зиндагӣ бебаҳра намон“. ");
INSERT INTO tgk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Вале Худо ба вай гуфт: „Эй нодон! Ҳамин шаб ҷонат аз ту талаб карда мешавад. Пас, он чӣ захира кардаӣ, насиби кӣ мегардад?“ ");
INSERT INTO tgk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ҳамин тавр бо ҳар касе мешавад, ки барои худ бойигарӣ ҷамъ мекунад, вале дар назари Худо бой нест». ");
INSERT INTO tgk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Исо ба шогирдони худ гуфт: «Бинобар ин ба шумо мегӯям: на ташвиши онро кашед, ки дар зиндагиатон чӣ мехӯред ва на ғами баданатонро хӯред, ки чӣ мепӯшед. ");
INSERT INTO tgk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Охир зиндагӣ муҳимтар аз хӯрок ва бадан муҳимтар аз пӯшок аст. ");
INSERT INTO tgk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ба зоғҳо нигоҳ кунед, онҳо на мекоранд, на медараванд, на анбор доранду на каҳдон, вале Худо ризқу рӯзиашонро мефиристад ва шумо нисбат ба паррандаҳо қадри баландтаре доред! ");
INSERT INTO tgk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Кадоме аз шумо бо ғам хӯрдан метавонед умратонро ақаллан як соат дарозтар кунед? ");
INSERT INTO tgk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Пас, агар шумо чунин як кори ночизро иҷро карда натавонед, чаро ғами чизҳои дигарро мехӯред? ");
INSERT INTO tgk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ба нашъунамои гулҳои савсан нигоҳ кунед: Онҳо на меҳнат мекунанду на мересанд, лекин ба шумо мегӯям, ки ҳатто шоҳ Сулаймон бо тамоми ҳашамату бойигариаш мисли яке аз онҳо либоси зебое напӯшидааст. ");
INSERT INTO tgk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Пас, агар Худо алафи саҳроиро, ки имрӯз ҳасту пагоҳ ба оташ партофта мешавад, чунин пӯшонад, шуморо низ, эй сустимонҳо, пӯшонда метавонад! ");
INSERT INTO tgk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Шумо ғам хӯрда, аз пайи он нашавед, ки чӣ мехӯреду чӣ менӯшед. ");
INSERT INTO tgk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ин ғами асосии тамоми халқҳои дигар аст, вале Падари шумо медонад, ки ҳамаи ин чизҳо ба шумо лозиманд. ");
INSERT INTO tgk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Танҳо подшоҳии Ӯро биҷӯед ва Ӯ бар замми он ба шумо ин чизҳоро хоҳад дод. ");
INSERT INTO tgk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Эй рамаи хурди гӯсфандон, натарсед! Зеро иродаи Падаратон чунин аст, ки подшоҳиро ба шумо диҳад. ");
INSERT INTO tgk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Он чиро, ки доред, бифурӯшеду ба камбағалон садақа диҳед. Ҳамёнҳоеро ба даст оред, ки ҳеҷ вақт намедаранд. Дар осмон бойигариеро ҷамъ кунед, ки ҳеҷ вақт тамом намешавад, чунки дасти дузд ба он ҷо намерасад ва куя онро намезанад. ");
INSERT INTO tgk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Зеро ба он ҷое, ки бойигарӣ доред, дилатон кашол аст. ");
INSERT INTO tgk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ҳар яки шумо миёнатонро баста, чароғашро равшан нигоҳ доред. ");
INSERT INTO tgk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ба монанди хизматгороне бошед, ки интизори аз тӯй баргаштани соҳибашон ҳастанд, то ки вақти баргашта дарро кӯфтани соҳибашон, онро зуд ба рӯяш кушоянд. ");
INSERT INTO tgk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Хушбахтанд хизматгороне, ки соҳибашон вақти баргашта омадан онҳоро бедор меёбад. Ба ростӣ ба шумо мегӯям, ки худи соҳиб миёнашро баста, онҳоро ба сари дастархон мешинонад ва ба онҳо хизмат мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Хушбахтанд онҳое, ки соҳибашон хоҳ ними шаб, хоҳ наздики субҳ баргашта, онҳоро бедор меёбад. ");
INSERT INTO tgk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Бидонед, ки агар соҳибхона вақту соати омадани дуздро донад, вай намегузорад, ки дузд ба хонааш зада дарояд. ");
INSERT INTO tgk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Пас, шумо низ бояд ба омадани Фарзанди Инсон тайёр бошед, зеро Вай вақте меояд, ки интизораш нестед». ");
INSERT INTO tgk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Петрус гуфт: «Худовандо! Ин масалро танҳо барои мо ё барои ҳама гуфтӣ?» ");
INSERT INTO tgk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Худованд ҷавоб дод: «Монанди ҳамон хизматгори бовафову хирадманд бошед, ки соҳибаш дилпурона метавонад ӯро бар хизматгорони дигар назоратчӣ таъин кунад ва ба ӯ дар вақти муайяншуда додани хӯрду хӯроки онҳоро боварӣ намояд. ");
INSERT INTO tgk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Хушо хизматгоре, ки ӯро соҳибаш ҳангоми баргаштан дар сари иҷрои вазифааш меёбад. ");
INSERT INTO tgk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ба ростӣ мегӯям, ки соҳибаш вайро бар тамоми молу мулкаш назоратчӣ таъин менамояд. ");
INSERT INTO tgk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Вале агар он хизматгор фикр кунад, ки соҳибаш дер карда истодааст ва хизматгоронро, марду занро фарқ накарда, латукӯб кунад ва ба хӯрдану нӯшидану мастигарӣ машғул шавад, ");
INSERT INTO tgk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ана, он гоҳ дар вақту соате, ки хизматгор аз он бехабару мунтазираш нест, соҳибаш бармегардад ва ӯро ду пора карда, насиби беимононро медиҳад. ");
INSERT INTO tgk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Хизматгоре, ки хоҳиши соҳибашро медонад, вале онро иҷро намекунад ва иҷро карданӣ ҳам нест, сахт лат карда мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Аммо хизматгоре, ки иродаи соҳибашро надониста, кори баде мекунад, ҷазои сабуктаре мебинад. Ба ҳар касе, ки зиёд дода шудааст, аз ӯ низ зиёд пурсида мешавад ва ба ҳар касе, ки чизи бисёре боварӣ карда шудааст, аз вай низ бисёртар талаб карда мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ман омадам, ки дар рӯи замин оташ даргиронам ва бисёр мехоҳам, ки он зудтар фурӯзон гардад. ");
INSERT INTO tgk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ҳамон тавре ки одам дар вақти таъмид гирифтан ба об ғӯта мезанад, Ман низ бояд ба азоби марговар ғӯтавар гардам ва то ба амал омадани ин кор нороҳат ҳастам. ");
INSERT INTO tgk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Шумо гумон мекунед, ки Ман барои ба замин овардани сулҳ омадаам? Баръакс, на барои сулҳ, балки барои ҷудоӣ андохтан омадаам. ");
INSERT INTO tgk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Баъд аз ин агар дар хонае панҷ нафар бошанд, аз ҳам ҷудо хоҳанд шуд: се нафар ба ду нафар ва ду нафар ба се нафар зид мебароянд. ");
INSERT INTO tgk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Падар бар зидди писараш ва писар бар зидди падараш, модар бар зидди духтараш ва духтар бар зидди модараш, хушдоман бар зидди келинаш ва келин бар зидди хушдоманаш мебарояд». ");
INSERT INTO tgk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ҳамчунин ба мардум гуфт: «Вақте мебинед, ки аз ғарб абре пайдо мешавад, дарҳол мегӯед: „Бояд борон борад“ ва чунин мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ва ҳангоме ки боди ҷанубӣ мевазад, мегӯед: „Ҳаво гарм мешавад“ ва ҳамин тавр ҳам мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Эй дурӯяҳо! Шумо нишонаҳои замину осмонро дида чӣ гуна шудани ҳаворо фаҳмида метавонеду чаро фаҳмида наметавонед, ки ҳоло чӣ замоне фаро расидааст? ");
INSERT INTO tgk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Барои чӣ худи шумо муайян карда наметавонед, ки чӣ бояд кунед? ");
INSERT INTO tgk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Охир, вақте ки бо даъвогар ба пеши қозӣ меравед, бояд ҳаматарафа кӯшиш кунед, ки дар роҳ бо даъвогар оштӣ шавед, вагарна ӯ шуморо ба назди қозӣ мебарад ва қозӣ шуморо ба дасти зиндонбон месупораду вай шуморо ба зиндон мепартояд. ");
INSERT INTO tgk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Росташро мегӯям, ки то тангаи охирини қарзатонро надиҳед, ҳаргиз аз ҳабс намебароед». ");
INSERT INTO tgk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Дар ин маврид баъзеҳо ба назди Исо омада, дар бораи ҷалилиёне нақл карданд, ки Пилотус онҳоро ҳангоми қурбонӣ карданашон кушт. ");
INSERT INTO tgk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Исо дар ҷавоби онҳо гуфт: «Ба гумонатон ин ҷалилиён аз ҷалилиёни дигар гунаҳкортар буданд, ки бо онҳо чунин ҳодиса рӯй дод? ");
INSERT INTO tgk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Не, мегӯям ба шумо! Вале, агар тавба карда, аз гуноҳҳоятон даст накашед, ҳамаатон монанди онҳо нобуд мешавед. ");
INSERT INTO tgk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ё ба фикратон он ҳаждаҳ нафаре, ки манораи Шилӯаҳ ба болояшон чаппа шуда нобудашон кард, аз дигар сокинони Ерусалим гунаҳкортар буданд? ");
INSERT INTO tgk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Не, мегӯям ба шумо! Вале, агар тавба карда, аз гуноҳҳоятон даст накашед, ҳамаатон монанди онҳо нобуд мешавед». ");
INSERT INTO tgk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Исо чунин масалеро гуфт: «Дар токзори як мард дарахти анҷире шинонда шуда буд. Вай омада, аз он мева ҷустуҷӯ кард, вале чизе наёфт. ");
INSERT INTO tgk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Пас, ба боғбон гуфт: „Се сол боз ман меоям, то аз ин дарахт мевае пайдо бикунам, вале чизе намеёбам. Онро бурида парто! Чаро заминро беҳуда банд мекунад?“ ");
INSERT INTO tgk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Вале боғбон ҷавоб дод: „Хоҷа! Як соли дигар ҳам онро набуред. Ман гирдашро побел карда, ба замин пору меандозам. ");
INSERT INTO tgk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Агар соли оянда мева диҳад, хуб мешавад ва агар надиҳад, баъд бибуред“». ");
INSERT INTO tgk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Дар яке аз рӯзҳои истироҳат Исо дар ибодатхона мардумро таълим медод. ");
INSERT INTO tgk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Дар он ҷо зане ҳузур дошт, ки ҳаждаҳ сол боз гирифтори рӯҳи нопок буд. Аз ин сабаб миёни зан хам гашта, ӯ ҳеҷ қоматашро рост карда наметавонист. ");
INSERT INTO tgk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Исо инро дида, ба наздаш даъват кард ва дастонашро бар ӯ гузошта, гуфт: «Эй зан! Ту аз бемориат раҳоӣ ёфтӣ». Қомати зан дарҳол рост шуда, вай Худоро ҳамду сано хонд. ");
INSERT INTO tgk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Сардори ибодатхона, аз он ки Исо дар рӯзи истироҳат занро шифо бахшид, хашмгин шуда, ба мардум гуфт: «Барои кор кардан шаш рӯз ҳаст ва бояд на дар рӯзи истироҳат, балки дар яке аз ҳамин рӯзҳо омада, шифо ёбед». ");
INSERT INTO tgk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Вале Худованд дар ҷавоб гуфт: «Эй дурӯягон! Магар ҳар яки шумо дар рӯзи истироҳат банди барзагов ё хари худро кушода онҳоро аз оғил берун намебароред, то рафта об бихӯранд? ");
INSERT INTO tgk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ҳол он ки ин зан аз авлоди Иброҳим аст ва шайтон ӯро ҳаждаҳ сол боз дар бандҳои худ нигоҳ медошт! Пас, наход мумкин набошад, ки ӯ дар рӯзи истироҳат аз ин бандҳо озод шавад?!» ");
INSERT INTO tgk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Бо ин суханонаш Ӯ душманонашро шарманда кард ва тамоми мардум аз корҳои аҷибе, ки Ӯ мекард, шод мешуданд. ");
INSERT INTO tgk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Исо гуфт: «Подшоҳии Худо ба чӣ монанд аст? Ман онро ба чӣ ташбеҳ диҳам? ");
INSERT INTO tgk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Он ба донаи хардал монанд аст, ки шахсе гирифта, дар боғи худ мекорад. Он рӯида, дарахти калоне шуду паррандаҳо дар миёни шохаҳояш лона гузоштанд». ");
INSERT INTO tgk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Боз гуфт: «Подшоҳии Худоро ба чӣ монанд кунам? ");
INSERT INTO tgk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Вай монанди он аст, ки зане хамиртуруше мегираду бо як тағора орд омехта, хамир мекунад ва баъд тамоми хамир мерасад». ");
INSERT INTO tgk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Исо дар шаҳру деҳаҳо гашта мардумро таълим медод. Вай ба сӯи Ерусалим равона буд. ");
INSERT INTO tgk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Шахсе аз Ӯ пурсид: «Хоҷаам! Магар шумораи ками одамон наҷот меёбанд?» Вай ба мардум гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Саъю кӯшиш кунед, то аз дари танг дароед, зеро ба шумо мегӯям, ки бисёр касон кӯшиш хоҳанд кард, ки аз он дар дароянд, вале ин ба онҳо муяссар нахоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Вақте ки соҳибхона хеста дарро маҳкам мекунад, шумо дар берун мемонед ва дарро кӯфта мегӯед: „Хоҷа! Дарро ба рӯи мо бикушо!“ Вале ӯ ба шумо чунин ҷавоб медиҳад: „Ман намедонам шумо аз куҷо ҳастед!“ ");
INSERT INTO tgk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Он вақт шумо мегӯед: „Мо ҳамроҳи ту мехӯрдему менӯшидем. Ту дар кӯчаҳои мо мардумро таълим медодӣ“. ");
INSERT INTO tgk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Вале ӯ ба шумо ҷавоб хоҳад дод: „Ман намедонам шумо аз куҷо ҳастед, дур шавед аз ман, эй ҳамаи бадкорон!“ ");
INSERT INTO tgk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ва вақте ки шумо дар подшоҳии Худо Иброҳим, Исҳоқ, Ёқуб ва тамоми пайғамбаронро мебинеду худатон аз он ҷо ронда мешавед, аз дард дандон ба дандон зада гиря мекунед. ");
INSERT INTO tgk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Мардум аз шарқу ғарб ва шимолу ҷануб омада, дар гирди дастархони подшоҳии Худо менишинанд ");
INSERT INTO tgk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ва баъзе аз онҳое, ки ҳоло дар сафи ақиб ҳастанд, дар сафи пеш мешаванд ва баъзе аз онҳое, ки дар сафи пеш ҳастанд, дар сафи ақиб мешаванд». ");
INSERT INTO tgk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ҳамин вақт чанд нафар аз фарисиён ба назди Исо омада гуфтанд: «Ба шумо лозим аст, ки аз ин ҷо баромада раведу сафаратонро давом диҳед, зеро Ҳиродус мехоҳад шуморо бикушад». ");
INSERT INTO tgk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Исо ба онҳо гуфт: «Рафта, ба он рӯбоҳ бигӯед, ки Ман имрӯзу пагоҳ девҳоро берун карда, мардумро шифо медиҳам ва рӯзи сеюм корамро тамом мекунам. ");
INSERT INTO tgk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Вале Ман бояд имрӯз, пагоҳ ва ҳам баъд аз пагоҳ роҳамро давом диҳам, зеро ин хел шуданаш мумкин нест, ки пайғамбар берун аз Ерусалим ҳалок гардад. ");
INSERT INTO tgk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Эй Ерусалим, Ерусалим! Пайғамбаронро мекушиву онҳоеро, ки Худо ба наздат мефиристад, сангсор мекунӣ! Ман борҳо орзу доштам, мисли мурғе, ки чӯҷаҳояшро зери болҳояш ҷамъ мекунад, сокинонатро дар гирди худ ҷамъ оварам, вале ту роҳ надодӣ! ");
INSERT INTO tgk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Пас ҳоло хонаат бепарастор мемонад. Ба шумо мегӯям, ки то „Баракат ёбад касе, ки аз номи Худованд меояд!“ нагӯед, Маро нахоҳед дид». ");
INSERT INTO tgk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Боре, дар рӯзи истироҳат Исо барои хӯрдани хӯрок ба хонаи яке аз сардорони фарисиён рафт ва онҳо корҳои Ӯро мушоҳида мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Дар рӯ ба рӯи Исо марде менишаст, ки баданаш варам карда буд. ");
INSERT INTO tgk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Исо ба қонуншиносону фарисиён муроҷиат намуда гуфт: «Дар рӯзи истироҳат касеро шифо додан мумкин аст ё не?» ");
INSERT INTO tgk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Онҳо хомӯш монданд, Ӯ бошад, ба бемор даст расонда шифо бахшиду ҷавоб дод. ");
INSERT INTO tgk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Сипас ба онҳо гуфт: «Агар бача ва ё барзагови яке аз шумо дар рӯзи истироҳат ба чоҳ афтад, магар онро зуд берун намебароред?» ");
INSERT INTO tgk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Вале онҳо ба Ӯ ҷавобе дода натавонистанд. ");
INSERT INTO tgk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Исо мушоҳида мекард, чӣ тавр меҳмонон мехостанд ҷойҳои болотарро ишғол кунанд, бинобар ин ба онҳо масалеро гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Вақте ки ба тӯи арӯсӣ даъват мешавӣ, аз боло гузашта нашин, чун шояд шахсе даъват шуда бошад, ки аз ту баобрӯтар аст. ");
INSERT INTO tgk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Он гоҳ соҳибхонае, ки ҳардуи шуморо даъват кардааст, омада ба ту нагӯяд: „Ҷоятро ба ӯ бидеҳ“. Он вақт шарм дошта, маҷбур мешавӣ, ки ба поён гузашта шинӣ. ");
INSERT INTO tgk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Баръакс, вақте ки туро даъват мекунанд, омада дар ҷои поён бишин, то соҳибхона омада, ба ту бигӯяд: „Дӯстам, болотар бишин“. Он гоҳ иззату эҳтиромат дар пеши назари ҳамаи онҳое, ки дар гирди дастархон нишастаанд, ба ҷо оварда мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Зеро ҳар кӣ худро калон гирад, паст мешавад ва баръакс, ҳар касе, ки худро хоксор гирад, сарбаланд хоҳад шуд». ");
INSERT INTO tgk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Баъд ба соҳибхонае, ки Ӯро даъват карда буд, гуфт: «Вақте ки зиёфате ташкил мекунӣ, дӯстон, бародарон, хешон ва ҳамсояҳои бойи худро даъват накун, чунки онҳо низ туро даъват мекунанду некиатро бармегардонанд. ");
INSERT INTO tgk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Беҳтараш вақти зиёфат оростан камбағалону маъюбон ва шалҳову нобиноёнро даъват намо. ");
INSERT INTO tgk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Он гоҳ хушбахт хоҳӣ шуд, чунки онҳо некиатро баргардонда наметавонанд, вале дар рӯзе, ки некон зинда мешаванд, Худо некиатро ба ту бармегардонад». ");
INSERT INTO tgk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Инро шунида яке аз меҳмонон ба Исо гуфт: «Хушбахт аст он касе, ки дар подшоҳии Худо хӯрок бихӯрад!» ");
INSERT INTO tgk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Аммо Исо ба ӯ гуфт: «Марде зиёфати калоне ороста, мардуми зиёдро даъват намуд. ");
INSERT INTO tgk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Чун вақти хӯрдани хӯрок расид, хизматгорашро фиристод, то ба даъватшудагон бигӯяд: „Биёед, аллакай ҳама чиз тайёр аст“. ");
INSERT INTO tgk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ҳамин вақт ҳама, яке аз пайи дигар ба узрхоҳӣ даромаданд. Якумаш гуфт: „Ман замин харидам ва бояд рафта, онро бубинам. Хоҳиш мекунам, маро бубахшед“. ");
INSERT INTO tgk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Дигаре гуфт: „Ман панҷ ҷуфт барзагов харидам ва ҳоло барои санҷидани онҳо меравам. Илтимос мекунам, маро бубахшед“. ");
INSERT INTO tgk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Саввумӣ гуфт: „Ман зан гирифтам, бинобар ин рафта наметавонам“. ");
INSERT INTO tgk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Хизматгор баргашта ин хабарро ба хоҷааш расонд. Он гоҳ хоҷа дар ғазаб шуда, ба хизматгораш фармон дод: „Зудтар ба кӯчаву тангкӯчаҳои шаҳр рафта, камбағалон, маъюбон, шалҳо ва нобиноёнро ба ин ҷо биёр“. ");
INSERT INTO tgk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Хизматгор гуфт: „Хоҷаам! Фармонатонро иҷро намудам, вале боз ҳам ҷойҳои холӣ ҳастанд“. ");
INSERT INTO tgk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Сипас хоҷа ба хизматгор гуфт: „Қад-қади роҳҳои васеъву танг гашта, мардумро ба омадан маҷбур кун, то ки хонаам пур шавад. ");
INSERT INTO tgk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ба шумо мегӯям, ҳеҷ нафаре, ки аз аввал даъват шуда буд, мазаи хӯроки идонаи маро нахоҳад чашид“». ");
INSERT INTO tgk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ҳамроҳи Исо мардуми бисёре равона буданд ва Ӯ ба онҳо рӯ оварда гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Касе, ки пеши Ман меояду Маро бештар аз падару модараш, зану фарзандонаш, бародарону хоҳаронаш ва зиёдтар аз ҷони худ дӯст намедорад, шогирди Ман шуда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Касе, ки салиби азобу маргашро бо худ набардошта аз пайи Ман ояд, шогирди Ман шуда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Зеро кӣ аз байни шумо қалъае сохтанӣ мешаваду аввал нишаста харҷи онро ҳисоб намекунад, то бифаҳмад, ки имконияти ба анҷом расондани сохтмонро дорад ё не? ");
INSERT INTO tgk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","То мабодо баъд аз гузоштани пойдевор он сохтмонро ба охир расонда натавонад ва ҳамаи онҳое, ки инро мебинанд, писханд зада ");
INSERT INTO tgk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","гӯянд: „Ин мард сохтмонро сар карду ба тамом кардани он қувваташ нарасид.“ ");
INSERT INTO tgk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ҳамчунин подшоҳе низ пеш аз ба ҷанги зидди подшоҳи дигар баромадан, аввал бояд нишаста, нағзакак фикр кунад, ки оё метавонад бо даҳ ҳазор сарбози худ ба подшоҳе, ки бо бист ҳазор сарбозаш бар зидди ӯ меояд, муқобилат нишон диҳад? ");
INSERT INTO tgk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Пас, агар натавонад, ҳанӯз ки душманаш дур аст, сафиронашро барои сулҳ бастан мефиристад. ");
INSERT INTO tgk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Айнан ҳамин тавр ҳеҷ яке аз шумо то аз тамоми чизу чораи худ даст накашед, наметавонед шогирди Ман бошед. ");
INSERT INTO tgk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Шумо медонед, ки намак чизи хуб аст, вале агар намак сифаташро гум кунад, магар онро боз шӯр карда мешавад? ");
INSERT INTO tgk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Он вақт намак барои ҳеҷ чиз ба кор намеояд: на барои замин ва на барои пору. Онро бароварда мепартоянд. Ҳар кӣ Маро мешунавад, бигзор гӯш кунад!» ");
INSERT INTO tgk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Бисёр андозгирон ва дигар касоне, ки гунаҳкор ҳисоб мешуданд, барои шунидани суханони Исо ба наздаш меомаданд. ");
INSERT INTO tgk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Вале фарисиён ва шариатдонон норозигии худро баён карда, мегуфтанд: «Ин мард гунаҳкоронро қабул мекунад ва ҳамроҳашон хӯрок мехӯрад». ");
INSERT INTO tgk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Бинобар ин Исо ба онҳо чунин масалро гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Фарз мекунем, ки нафаре аз шумо сад сар гӯсфанд дораду якеашро гум мекунад. Магар наваду нӯҳтоашро дар чарогоҳ гузошта, то ёфтани он гӯсфанди гумшуда аз пайи вай намеравад? ");
INSERT INTO tgk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ва чун ёбад, бо хурсандӣ онро болои кифтонаш бардошта ");
INSERT INTO tgk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ба хонааш меояд ва дӯстону ҳамсояҳояшро ҷеғ зада мегӯяд: „Бо ман хурсандӣ кунед. Ман гӯсфанди гумшудаамро ёфтам“. ");
INSERT INTO tgk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ба шумо мегӯям, дар осмон барои як гунаҳкоре, ки аз гуноҳ даст кашида, тавба мекунад, хурсандии зиёдтаре мешавад, назар ба он наваду нӯҳ накӯкоре, ки ба тавба ҳеҷ эҳтиёҷ надоранд. ");
INSERT INTO tgk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Фарз мекунем, ки зане даҳ тангаи нуқра дораду якеашро гум мекунад. Магар вай чароғро даргиронда, хонаро рӯфта, бодиққат намекобад, то онро пайдо бикунад? ");
INSERT INTO tgk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ва чун ёбад, дугонаҳову ҳамсоягони худро ҷеғ зада мегӯяд: „Бо ман хурсандӣ кунед, чун тангаи гумкардаамро ёфтам“. ");
INSERT INTO tgk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ба шумо мегӯям, фариштагони Худо ҳам барои як гунаҳкоре, ки аз гуноҳ даст кашида, тавба мекунад, айнан ҳамин тавр хурсандӣ мекунанд». ");
INSERT INTO tgk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Боз гуфт: «Марде ду писар дошт. ");
INSERT INTO tgk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Писари хурдӣ ба падараш гуфт: „Он қисми молу мулкеро, ки насиби ман аст, ба ман бидеҳ“ ва падар ҳама чизеро, ки дошт, ба ҳарду писараш тақсим кард. ");
INSERT INTO tgk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Баъд аз чанд рӯз писари хурдӣ чизу чораашро ҷамъ карда, ба кишвари дурдасте рафт. Дар он ҷо ӯ тамоми бойигариашро беҳуда ба айшу ишрат сарф кард. ");
INSERT INTO tgk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Баъд аз он ки ҳамаи бойигариашро барбод дод, дар он сарзамин қаҳтии сахте ба амал омад ва ӯ ба мӯҳтоҷӣ дучор шуд. ");
INSERT INTO tgk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Сипас рафта хизматгори яке аз сокинони он кишвар шуд ва он мард ӯро ба замини худ фиристод, то ки хукбонӣ кунад. ");
INSERT INTO tgk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Азбаски ба ӯ чизи хӯрданӣ намедоданд, вай тайёр буд, шикамашро бо еме, ки хукҳо мехӯрданд, пур кунад. ");
INSERT INTO tgk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Оқибат вай ба худ омада гуфт: „Падарам хизматгорони бисёре дорад ва ҳамаи онҳо нони фаровон ва ҳатто зиёдатӣ доранд, аммо ман дар ин ҷо аз гуруснагӣ мемирам! ");
INSERT INTO tgk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Рафта ба назди падарам бармегардаму ба вай мегӯям: «Падарҷон! Ман дар пеши Худову шумо гунаҳкорам ");
INSERT INTO tgk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ва дигар лоиқи он нестам, ки писари шумо бошам. Маро ҳамчун яке аз хизматгоронатон қабул кунед»“. ");
INSERT INTO tgk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Пас ӯ хеста ба хонаи падараш равона шуд. Вай ҳанӯз хеле дур буд, ки падараш ӯро дида, ба ҳоли писараш раҳмаш омад ва давида рафту фарзандашро ба оғӯшаш кашида, бӯса кард. ");
INSERT INTO tgk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Писар ба вай гуфт: „Падарҷон! Ман дар пеши Худову шумо гунаҳкорам ва дигар лоиқи он нестам, ки писари шумо бошам“. ");
INSERT INTO tgk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Аммо падар ба хизматгоронаш гуфт: „Зудтар ҷомаи беҳтаринро оварда, ба ӯ пӯшонед. Ба дасташ ангуштарин ва ба пойҳояш пойафзол пӯшонед. ");
INSERT INTO tgk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Гӯсолаи боникардаро биёреду сар бибуред; мехӯрему хурсандӣ мекунем! ");
INSERT INTO tgk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Охир ин писарам мурда буд ва ҳоло зинда шуд, гумшуда буду ёфт шуд“. Пас онҳо ҷашне оростанд. ");
INSERT INTO tgk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ҳамин вақт писари калонӣ дар киштзор буд. Ҳангоми баргаштан вай ба хона наздик шуда, садои мусиқӣ ва рақсу бозиро шунид. ");
INSERT INTO tgk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Пас яке аз хизматгоронро ҷеғ зада пурсид, ки дар он ҷо чӣ воқеа рӯй дода истодааст? ");
INSERT INTO tgk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Хизматгор ба ӯ ҷавоб дод: „Бародаратон баргашт ва чун падаратон ӯро зиндаву саломат дид, гӯсолаи боникардаро сар бурид“. ");
INSERT INTO tgk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Бародари калониро чунон қаҳраш омад, ки нахост ба хона дарояд. Он гоҳ падараш берун баромада, ӯро розӣ кунонданӣ шуд. ");
INSERT INTO tgk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Вай бошад, ба падараш чунин ҷавоб дод: „Чандин сол аст, ки ман ба шумо хизмат мекунам ва ҳеҷ вақт аз гуфтаатон берун набаромадаам, шумо бошед, ягон бор ба ман ҳатто бузғолачаеро ҳам надодед, ки бо дӯстонам хурсандӣ карда тавонам. ");
INSERT INTO tgk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Вале ин писаратон, ки дороии шуморо ҳамроҳи фоҳишаҳо хӯрда тамом карду баргашт, шумо барои вай гӯсолаи боникардаро сар буридед“. ");
INSERT INTO tgk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Аммо падар ба ӯ гуфт: „Писарам, ту ҳамеша бо ман ҳастӣ ва ҳар чизе, ки ман дорам, аз они туст. ");
INSERT INTO tgk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Бояд шодиву хурсандӣ кунем, чунки бародарат мурда буду зинда шуд, гумшуда буду ёфт шуд“». ");
INSERT INTO tgk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ҳамчунин Исо ба шогирдонаш гуфт: «Марди сарватманде назоратчие дошт ва ба сарватманд шикоят карданд, ки назоратчиаш молу мулки ӯро беҳуда сарф мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Хоҷааш вайро ҷеғ зада гуфт: „Ман дар бораи ту чиҳо мешунавам? Ба ман ҳисобот деҳ, ки чӣ корҳо кардаӣ, чунки дигар назоратчии ман шуда наметавонӣ“. ");
INSERT INTO tgk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Он гоҳ назоратчӣ худ ба худ гуфт: „Чӣ кор кунам? Хоҷаам маро аз кор холӣ мекунад. Ман бел зада наметавонам ва аз гадоӣ кардан ҳам шарм мекунам. ");
INSERT INTO tgk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ёфтам чӣ бояд кунам. Бояд коре бикунам, ки вақти бекор монданам одамон маро ба хонаҳояшон роҳ диҳанд“. ");
INSERT INTO tgk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Вай қарздорони хоҷаашро як-як ҷеғ зад ва якумашро пурсид: „Ту аз хоҷаам чӣ қадар қарздор ҳастӣ?“ ");
INSERT INTO tgk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ҷавоб дод: „Сад хум равғани зайтун“. Назоратчӣ ба вай гуфт: „Ана забонхати ту, зуд нишаста, ба ҷои сад панҷоҳ навис“. ");
INSERT INTO tgk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Баъд аз дигаре пурсид: „Ту чӣ қадар қарздор ҳастӣ?“ Ӯ ҷавоб дод: „Сад халта гандум“. Назоратчӣ гуфт: „Ана забонхати ту, ба ҷои сад ҳаштод навис“. ");
INSERT INTO tgk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Вале хоҷааш назоратчии қаллобро таъриф кард, ки зиракиашро ба кор бурда, чунин кардааст. Охир одамони ин дунё дар муносибат бо онҳое, ки мисли худашон ҳастанд, назар ба одамони нур, ки аз они подшоҳии Худо ҳастанд, оқилтаранд. ");
INSERT INTO tgk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Пас, Ман ба шумо мегӯям: Пулу моли ин дунёро ба он сарф намоед, ки барои худ дӯстонро пайдо бикунед, то дар вақти тамом шудани бойигариатон онҳо шуморо дар хонаҳои абадӣ қабул кунанд. ");
INSERT INTO tgk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Касе, ки дар иҷрои вазифаи майда вафодор бошад, дар иҷрои вазифаи калон ҳам вафодор мемонад. Ҳамчунин касе, ки дар иҷрои кори ночиз беинсоф бошад, дар иҷрои кори муҳим ҳам беинсофӣ мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Пас, агар ба шумо бойигарии ин дунёро боварӣ карда нашавад, кӣ ба шумо бойигарии ҳақиқиро боварӣ мекунад? ");
INSERT INTO tgk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ва агар ба шумо бойигарии шахси бегонаро боварӣ карда нашавад, кӣ ба шумо меросатонро медиҳад? ");
INSERT INTO tgk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ҳеҷ хизматгор якбора ба ду хоҷа хизмат карда наметавонад, чунки ё якеашро дӯст медораду дигарашро бад мебинад, ё ба яке вафодор мемонаду дигарашро писанд намекунад. Шумо низ наметавонед ҳам бандаи Худо бошеду ҳам бандаи пул». ");
INSERT INTO tgk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Фарисиён, ки пулпараст буданд, ҳамаи инро шунида, Исоро масхара карданд. ");
INSERT INTO tgk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Вале Ӯ ба онҳо гуфт: «Шумо ҳамон одамоне ҳастед, ки худро дар пеши мардум беайб нишон медиҳед, лекин Худо аз дилҳои шумо бохабар аст. Чизеро, ки одамон олидараҷа мешуморанд, дар назари Худо нафратовар аст. ");
INSERT INTO tgk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Шариати Мӯсо ва навиштаҳои пайғамбарон то замони Яҳёи Таъмиддиҳанда амал мекарданд. Аз вақти Яҳё сар карда подшоҳии Худо эълон карда мешаваду ҳама кӯшиш мекунанд, ки зӯр зада вориди он гарданд. ");
INSERT INTO tgk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Вале нест шудани замину осмон осонтар аз он, ки ҳатто нуқтае аз ин қонун бекор карда шавад. ");
INSERT INTO tgk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ҳар кӣ зани худро талоқ дода, дигареро ба занӣ гирад, гуноҳи алоқаи беникоҳро мекунад ва ҳар кӣ зани талоқшударо ба занӣ гирад, низ ҳамон гуноҳро содир мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Як замонҳо марди сарватманде зиндагӣ мекард, ки либоси қиматбаҳо мепӯшиду ҳар рӯз хӯроки шоҳона мехӯрд. ");
INSERT INTO tgk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Лаъзор ном камбағале, ки тамоми баданаш пур аз захмҳо буд, дар назди дарвозаи марди сарватманд дароз кашида мехобид ");
INSERT INTO tgk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ва ҳатто сагҳо омада, захмҳои ӯро мелесиданд. Вай орзу мекард, ки шикамашро бо пасмондаҳои хӯроке, ки ба берун партофта мешаванд, сер кунад. ");
INSERT INTO tgk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Вақте ки Лаъзор мурд, фариштагон ӯро ба осмон бурда, ба паҳлӯи Иброҳим шинонданд. Марди сарватманд низ мурд ва ӯро гӯронданд. ");
INSERT INTO tgk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ҳангоме ки ӯ дар дӯзах азоб мекашид, ба боло нигоҳ кард ва аз дур Иброҳимро дид, ки Лаъзор дар паҳлӯяш менишаст. ");
INSERT INTO tgk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Он сарватманд фарёд зада гуфт: „Эй аҷдодам Иброҳим! Ба ман раҳм кунед ва Лаъзорро бифиристед, то нӯги ангушташро ба об тар карда, забонамро камтар нам кунад. Ман дар ин оташ азоб мекашам“. ");
INSERT INTO tgk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Вале Иброҳим чунин ҷавоб дод: „Ба хотир ор, писар, ту дар вақти зинда буданат аллакай ҳама чизи хубро ба даст оварда будӣ, вале насиби Лаъзор фақат чизи бад дид. Ҳоло бошад, дили вай дар ин ҷо тасаллӣ меёбаду ту азоб мекашӣ. ");
INSERT INTO tgk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Илова бар ин, байни мову шумо чунон ҷарии бетаге вуҷуд дорад, ки агар касе аз ин тараф ба пеши шумо гузаштан хоҳад ҳам, наметавонад. Ҳамчунин аз он ҷо касе пеши мо гузашта наметавонад“. ");
INSERT INTO tgk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Марди сарватманд гуфт: „Пас, эй аҷдод, аз шумо илтимос мекунам, ки Лаъзорро ба хонаи падари ман фиристед. ");
INSERT INTO tgk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Охир ман панҷ бародар дорам. Бигзор онҳоро таъкид кунад, то онҳо ҳам ба ин ҷои азоб наафтанд“. ");
INSERT INTO tgk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Иброҳим ба ӯ гуфт: „Онҳо навиштаҳои Мӯсо ва дигар пайғамбаронро доранд. Бигзор ба суханони онҳо гӯш диҳанд“. ");
INSERT INTO tgk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Аммо мард гуфт: „Не, аҷдодам Иброҳим! Танҳо агар яке аз мурдагон назди онҳо биёяд, тавба хоҳанд кард“. ");
INSERT INTO tgk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Иброҳим ҷавоб дод: „Модоме ки онҳо ба суханони Мӯсою пайғамбарон гӯш намедиҳанд, ба ҳеҷ кас, ҳатто ба мурдае, ки зинда шудааст, низ бовар нахоҳанд кард“». ");
INSERT INTO tgk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ба шогирдонаш бошад, Исо чунин гуфт: «Албатта васвасаҳои зиёд пайдо мешаванд, вале вой бар ҳоли он касе, ки ба воситаи вай васвасаҳо ба миён меоянд. ");
INSERT INTO tgk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Агар бар гардани вай санги осиёбро овехта, ӯро ба баҳр мепартофтанд, барояш беҳтар аз он мебуд, ки ӯ яке аз пайравони хурдтаринро ба васвасаи гуноҳ андозад. ");
INSERT INTO tgk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Пас, эҳтиёт бошед! Агар бародаратон бар шумо гуноҳе бикунад, ӯро таъкид кунед ва агар тавба карда, аз гуноҳ даст кашад, ӯро бубахшед. ");
INSERT INTO tgk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Агар рӯзе ҳафт бор гуноҳ кунад ва ҳафт маротиба „Тавба кардам“ гӯяд, бояд ӯро бубахшед». ");
INSERT INTO tgk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Вакилон ба Худованд гуфтанд: «Имони моро зиёдтар бикун». ");
INSERT INTO tgk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Худованд гуфт: «Агар имонатон донаи хардал барин бошад, шумо ба ин дарахти тут „Решакан шаву ба баҳр шинонда шав“ гуфта метавонед ва вай ба шумо итоат мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Фарз кардем, ки яке аз шумо хизматгоре дореду вай ба шудгори замин ва ё ба чӯпонӣ машғул аст. Магар вақти аз киштзор баргаштанаш шумо ба вай мегӯед, ки зуд омада назди дастархон бишинад? ");
INSERT INTO tgk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Магар ба ӯ чунин намегӯед: „Хӯроки шомро тайёр кун ва то вақте ки ман мехӯраму менӯшам, миёнатро маҳкам баста, ба ман хизмат кун. Баъдтар худат мехӯрӣ ва менӯшӣ?“ ");
INSERT INTO tgk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Охир, шумо ба хизматгоратон барои иҷро кардани фармонҳоятон ташаккур намегӯед-ку? ");
INSERT INTO tgk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Пас, шумо низ, баъд аз он ки фармонҳои ба шумо додашударо иҷро мекунед, бигӯед: „Мо танҳо хизматгори ночиз ҳастему вазифаи худро иҷро кардем“». ");
INSERT INTO tgk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Исо ба сӯи Ерусалим равона шуд. Вай қад-қади сарҳаде, ки байни Сомарияву Ҷалил буд, роҳ мерафт. ");
INSERT INTO tgk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Боре, вақте ки Ӯ ба деҳае медаромад, бо даҳ одамони махав рӯ ба рӯ шуд. Онҳо каме дур истода ");
INSERT INTO tgk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","дод мезаданд: «Эй Исо, хоҷа, ба мо раҳм кунед!» ");
INSERT INTO tgk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Исо онҳоро дида, гуфт: «Бираведу худро ба рӯҳониён нишон диҳед». Онҳо рафтанд ва дар аснои роҳ пок шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Яке аз онҳо чун дид, ки шифо ёфтааст, бо овози баланд Худоро ситоиш намуда, баргашт ");
INSERT INTO tgk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ва худро пеши пойҳои Исо партофта, ба Ӯ миннатдорӣ баён кард. Ӯ марди сомарӣ буд. ");
INSERT INTO tgk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Исо пурсид: «Магар даҳ нафар пок нашудаанд? Нӯҳ нафари дигар куҷоянд? ");
INSERT INTO tgk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Пас, наход ғайр аз ин марди бегона ягон нафаре аз онҳо барнагашт, ки Худоро ҳамду сано хонад?» ");
INSERT INTO tgk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Баъд ба он мард гуфт: «Бархезу бирав, туро имонат шифо дод». ");
INSERT INTO tgk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Фарисиён аз Исо пурсиданд, ки кай подшоҳии Худо фаро мерасад? Ӯ ба онҳо ҷавоб дод: «Аз рӯи нишонаҳои намоён омадани подшоҳии Худоро муайян кардан имконнопазир аст. ");
INSERT INTO tgk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Касе ба шумо намегӯяд: „Нигоҳ кунед, вай дар ин ҷост“ ва ё „Вай дар он ҷост!“ Охир, подшоҳии Худо аллакай дар байни шумо вуҷуд дорад». ");
INSERT INTO tgk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Вале ба шогирдонаш гуфт: «Вақте мерасад, ки ба дидани Фарзанди Инсон зор мешавед, вале Ӯро намебинед. ");
INSERT INTO tgk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ба шумо мегӯянд: „Вай дар он ҷост!“ ё „Вай дар ин ҷост!“ Аз ҷоятон ҷаста, аз қафояшон надавед. ");
INSERT INTO tgk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Зеро Фарзанди Инсон дар рӯзи омаданаш монанди барқе, ки дурахшида осмонро аз як сӯ то сӯи дигар нурпошӣ мекунад, пайдо мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Вале аввал Ӯ бояд азоби бисёре кашида, аз тарафи насли ин замон рад карда шавад. ");
INSERT INTO tgk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Чи тавре ки дар замони Нӯҳ пайғамбар буд, пеш аз омадани Фарзанди Инсон низ ҳамон тавр мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Зеро то рӯзи ба киштӣ даромадани Нӯҳ одамон мехӯрданд, менӯшиданд, зан мегирифтанд ва ба шавҳар мебаромаданд, вале баъд тӯфон бархоста, ҳамаро несту нобуд кард. ");
INSERT INTO tgk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ҳамчунин монанди замони Лут хоҳад буд, ки одамон мехӯрданду менӯшиданд, мехариданду мефурӯхтанд, мекоштанду иморат месохтанд. ");
INSERT INTO tgk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Вале рӯзе, ки Лут аз шаҳри Садӯм баромад, ба рӯи замин оташу сулфур борида, ҳамаро нест кард. ");
INSERT INTO tgk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Рӯзе, ки Фарзанди Инсон зоҳир мегардад, низ ҳамон тавр хоҳад буд. ");
INSERT INTO tgk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Агар касе он вақт дар болои бом бошаду чизу чорааш даруни хона, барои гирифтани онҳо поён нафарояд ва ҳар кӣ дар саҳро бошад, ба хонааш барнагардад. ");
INSERT INTO tgk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Зани Лутро ба хотир оваред. ");
INSERT INTO tgk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ҳар кӣ ҷони худро эмин нигоҳ доштанӣ аст, онро аз даст медиҳад ва ҳар кӣ ҷони худро фидо кунад, онро эмин нигоҳ хоҳад дошт. ");
INSERT INTO tgk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ба шумо мегӯям, ки дар он шаб аз ду нафаре, ки дар як ҷойгаҳ хобанд, якеаш гирифта мешаваду дигараш мемонад. ");
INSERT INTO tgk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Аз ду зане, ки дар як осиёб гандум орд мекунанд, якеаш гирифта мешаваду дигараш мемонад». ");
INSERT INTO tgk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Он гоҳ шогирдонаш аз Ӯ пурсиданд: «Эй Худованд, ин дар куҷо ба амал меояд?» Ӯ ба онҳо ҷавоб дод: «Ҳар ҷо ки ҷасади мурдае бошад, паррандаҳои лошахӯр дар он ҷо гирд меоянд». ");
INSERT INTO tgk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Баъд Исо ба онҳо масалеро нақл кард, то бидонанд, ки бояд ҳамеша дуо бигӯянд ва ҳеҷ вақт рӯҳафтода нагарданд. ");
INSERT INTO tgk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ӯ гуфт: «Дар як шаҳр қозие буд, ки на тарсе аз Худо дошту на шарме аз мардум. ");
INSERT INTO tgk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Дар он шаҳр бевазане низ буд, ки ҳамеша ба назди ӯ омада мегуфт: „Маро муҳофизат кунед, то бар душманам маълум гардад, ки ман ҳақ ҳастам“. ");
INSERT INTO tgk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Қозӣ муддати дуру дароз талаби ӯро рад мекард, вале дар охир худ ба худ гуфт: „Гарчанде ман на тарсе аз Худо дораму на шарме аз мардум, ");
INSERT INTO tgk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","вале, азбаски ин бевазан маро ба ҳолам намегузорад, ӯро ҳимоя мекунам, то ҳар гоҳ омада, маро безор накунад“». ");
INSERT INTO tgk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Сипас Худованд пурсид: «Шумо шунидед, ки ин қозии беадолат чӣ мегӯяд? ");
INSERT INTO tgk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Наход Худо интихобкардагони худро, ки шабу рӯз ба даргоҳаш зорию тавалло мекунанд, муҳофизат накунад? Магар Ӯ дер мекунад? ");
INSERT INTO tgk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ба шумо мегӯям, ки Худо онҳоро зуд муҳофизат мекунад. Вале оё Фарзанди Инсон вақти омаданаш дар рӯи замин имонро ёфта метавонад?» ");
INSERT INTO tgk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Баъд Исо ба онҳое, ки дар беайб будани худ шубҳае надошта, аз дигарон ҳазар мекарданд, чунин масалеро нақл кард: ");
INSERT INTO tgk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Ду кас барои дуогӯӣ ба Хонаи Худо даромаданд. Яке фарисӣ буду дигаре андозгир. ");
INSERT INTO tgk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Фарисӣ рост истода, дар дилаш чунин дуо мегуфт: „Худоё! Туро шукр мегӯям, ки мисли одамони дигар қаллобу золим нестам, алоқаи беникоҳ намекунам ва ҳам монанди ин андозгир нестам. ");
INSERT INTO tgk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ман ҳар ҳафта ду бор рӯза мегирам ва аз ҳар даромаде, ки дорам, ҳиссаи даҳумашро месупорам“. ");
INSERT INTO tgk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Вале андозгир дуртар истода, ҳатто ҷуръат намекард, ки сарашро боло карда, ба осмон нигарад. Вай танҳо бар сандуқи синааш мушт зада мегуфт: „Худоё! Ба мани гунаҳкор раҳм кун!“ ");
INSERT INTO tgk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ба шумо мегӯям, ки на фарисӣ, балки ҳамин андозгир сафед шуда, ба хонааш баргашт. Зеро ҳар кӣ худро калон гирад, паст мешавад ва, баръакс, ҳар касе, ки худро хоксор гирад, сарбаланд мешавад». ");
INSERT INTO tgk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ба назди Исо кӯдакони хурдсолро оварданд, то ки Ӯ бар сари онҳо даст гузорад. Вале шогирдон инро дида, мардумро сарзаниш карданд. ");
INSERT INTO tgk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Исо кӯдаконро ба наздаш ҷеғ зада гуфт: «Монед, ки кӯдакон назди Ман оянд, пеши роҳи онҳоро нагиред, зеро Худо дар ҳаёти онҳое подшоҳӣ мекунад, ки мисли ин кӯдакон ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ба ростӣ ба шумо мегӯям, ҳар кӣ подшоҳии Худоро мисли кӯдак қабул накунад, ба он дохил намешавад». ");
INSERT INTO tgk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Яке аз ҷумлаи сардорон аз Исо пурсид: «Эй устоди нек! Чӣ кор бояд бикунам, ки ҳаёти абадӣ насибам гардад?» ");
INSERT INTO tgk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Исо аз ӯ пурсид: «Чаро Маро нек мегӯӣ? Ҳеҷ кас ба ғайр аз Худои ягона нек нест. ");
INSERT INTO tgk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ту фармоишҳоро медонӣ: алоқаи беникоҳ накун, одамкушӣ накун, дуздӣ накун, шаҳодати бардурӯғ надеҳ, падару модаратро ҳурмату эҳтиром намо». ");
INSERT INTO tgk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Вай ба Исо ҷавоб дод: «Ман аз айёми ҷавониам ҳамаи ин фармоишҳоро риоя мекунам». ");
INSERT INTO tgk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Исо инро шунида гуфт: «Ба ту фақат як чиз намерасад. Ҳар он чизеро, ки дорӣ, фурӯхта, ба бечорагон бидеҳ. Он гоҳ соҳиби мукофоти осмонӣ мегардӣ. Баъд омада, Маро пайравӣ намо». ");
INSERT INTO tgk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Вале он мард инро шунида бисёр ғамгин шуд, чунки хеле бой буд. ");
INSERT INTO tgk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Исо ба вай нигоҳ карда гуфт: «Ба подшоҳии Худо дохил шудани одамони бой чӣ душвор аст. ");
INSERT INTO tgk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Аз сӯрохи сӯзан гузаштани шутур осонтар аз он, ки шахси бой ба подшоҳии Худо дохил шавад». ");
INSERT INTO tgk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Онҳое, ки Ӯро мешуниданд, пурсиданд: «Пас кӣ наҷот ёфта метавонад?» ");
INSERT INTO tgk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Исо ҷавоб дод: «Ҳар чизе, ки барои одамон ғайриимкон бошад, барои Худо имконпазир аст». ");
INSERT INTO tgk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Он гоҳ Петрус гуфт: «Ана, мо аз баҳри хонаҳои худ баромада, Шуморо пайравӣ кардем». ");
INSERT INTO tgk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Исо гуфт: «Ба ростӣ ба шумо мегӯям, ҳар кӣ ба хотири подшоҳии Худо аз баҳри хона, зан, бародарон, падару модар ва фарзандонаш гузарад, ");
INSERT INTO tgk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","дар ин дунё ҳамаи инро чанд маротиба зиёдтар ба даст меораду дар он дунё ҳаёти абадӣ насибаш мегардад». ");
INSERT INTO tgk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Исо он дувоздаҳ нафарро як сӯ бурда, ба онҳо гуфт: «Ана, мо ба Ерусалим рафта истодаем. Дар он ҷо ҳар чизе ки пайғамбарон дар бораи Фарзанди Инсон навиштаанд, ба амал хоҳад омад. ");
INSERT INTO tgk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ӯро ба дасти беимонон месупоранд. Онҳо Ӯро масхара ва ҳақорат карда, туфборон ");
INSERT INTO tgk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ва қамчинкорӣ намуда ба қатл мерасонанд, вале Ӯ дар рӯзи сеюм аз нав зинда хоҳад шуд». ");
INSERT INTO tgk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Лекин шогирдон аз ин гуфтаҳо чизеро нафаҳмиданд. Маънои суханони Исо аз онҳо пӯшида монд ва онҳо намефаҳмиданд, ки Ӯ дар бораи чӣ сухан меронад. ");
INSERT INTO tgk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Вақте ки Исо ба Ериҳӯ наздик мешуд, нобиноеро дид, ки дар канори роҳ нишаста садақа мепурсид. ");
INSERT INTO tgk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Чун нобино шунид, ки аз наздаш мардуми зиёде мегузаранд, пурсид: «Худаш чӣ гап?» ");
INSERT INTO tgk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ба вай гуфтанд, ки аз он ҷо Исои Носирӣ гузашта истодааст. ");
INSERT INTO tgk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Он нобино дод зада гуфт: «Эй Исои насли Довуд, ба ман раҳм кунед». ");
INSERT INTO tgk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Онҳое, ки пешопеш равона буданд, ӯро сарзаниш карда мегуфтанд, ки хомӯш шавад. Аммо ӯ торафт баландтар дод зада мегуфт: «Эй насли Довуд, ба ман раҳм кунед». ");
INSERT INTO tgk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Исо аз роҳаш бозистода фармуд, ки он нобиноро ба наздаш биёранд. Вақте ки ӯ наздик омад, Исо аз вай пурсид: ");
INSERT INTO tgk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ту чӣ мехоҳӣ? Бароят чӣ кор кунам?» Вай ҷавоб дод: «Худовандо! Мехоҳам бино шавам». ");
INSERT INTO tgk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Исо гуфт: «Бино шав! Имонат туро шифо дод». ");
INSERT INTO tgk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Вай ҳамон замон бино шуд ва Худоро ситоишкунон аз паси Исо равона гашт. Тамоми мардум инро дида, Худоро ҳамду сано мехонданд. ");
INSERT INTO tgk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Исо ба Ериҳӯ ворид шуда, аз он ҷо мегузашт. ");
INSERT INTO tgk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Дар он шаҳр Заккай ном марди сарватманде буд, ки вазифаи сардори андозгиронро ба ӯҳда дошт. ");
INSERT INTO tgk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Вай мехост бубинад, ки Исо кист. Вале, азбаски мардум зиёд буду Заккай қади паст дошт, Ӯро дида натавонист. ");
INSERT INTO tgk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Бинобар ин ӯ давида пеш гузашту ба болои дарахти анҷир баромад, то ки Исоро ҳангоми аз он ҷо гузаштанаш бубинад. ");
INSERT INTO tgk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Исо ба он ҷо наздик шудан замон ба Заккай нигоҳ карда гуфт: «Заккай! Зудтар поён фаро! Ман бояд имрӯз дар хонаи ту бимонам». ");
INSERT INTO tgk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Вай зуд поён фаромада, бо хурсандӣ Исоро меҳмондорӣ кард. ");
INSERT INTO tgk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Инро дида, ҳама норозигии худро баён намуда мегуфтанд: «Ӯ дар хонаи марди гунаҳкор меҳмон шудааст». ");
INSERT INTO tgk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Аммо Заккай рост истода ба Худованд гуфт: «Ана, Худованд, ман нисфи бойигариамро ба бечорагон медиҳам ва агар аз касе бо фиреб пул ситонда бошам, чор баробар зиёдтар бармегардонам». ");
INSERT INTO tgk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Исо гуфт: «Имрӯз ба ин хона наҷот омад, чунки Заккай ҳам аз насли Иброҳим аст. ");
INSERT INTO tgk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Зеро Фарзанди Инсон барои он омадааст, ки гумроҳшударо кофта ёбаду наҷот диҳад». ");
INSERT INTO tgk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Азбаски Исо аллакай дар наздикии Ерусалим буду шунавандагони Ӯ гумон доштанд, ки подшоҳии Худо ба зудӣ фаро мерасад, Вай масал гуфтанро давом дод: ");
INSERT INTO tgk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","«Як шахси олимартаба ба кишвари дурдаст сафар дошт, то ҳуқуқи ба тахти подшоҳӣ нишастанашро тасдиқ намуда, баргардад. ");
INSERT INTO tgk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Пеш аз рафтан вай даҳ нафар хизматгоронашро ба наздаш ҷеғ зада, ба ҳар кадомаш як тангаи тилло доду гуфт: „Дар вақти набудани ман ин тангаҳоро ба муомилот дароред“. ");
INSERT INTO tgk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Аммо ҳамшаҳриҳояш, ки ба вай нафрат доштанд, аз паси вай сафиронашонро фиристоданд, то рафта чунин бигӯянд: „Мо намехоҳем, ки вай бар мо подшоҳӣ кунад“. ");
INSERT INTO tgk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Вақте ки ӯ тахти подшоҳиро соҳиб шуда баргашт, фармон дод, то ҳамон хизматгоронеро, ки ба онҳо пул дода буд, ба наздаш ҷеғ зананд. Вай мехост бифаҳмад, ки ҳар яке аз онҳо чӣ қадар фоида ба даст овардааст? ");
INSERT INTO tgk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Аввалинаш омада, гуфт: „Хоҷаам, як тангаи тиллои шумо даҳ танга фоида овард“. ");
INSERT INTO tgk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Подшоҳ ба вай гуфт: „Офарин, хизматгори некам. Азбаски дар иҷрои вазифаи андаке вафодориатро нишон додӣ, туро ба даҳ шаҳр ҳоким таъин мекунам“. ");
INSERT INTO tgk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Дуюмин омада, гуфт: „Хоҷаам, як тангаи тиллои шумо панҷ танга фоида овард“. ");
INSERT INTO tgk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Подшоҳ ба вай гуфт: „Туро низ ба панҷ шаҳр ҳоким таъин мекунам“. ");
INSERT INTO tgk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Сеюмин омада, гуфт: „Хоҷаам, ана ин ҳамон тангаи тиллои шумо. Ман онро ба рӯймолчае печонда, нигоҳ доштам, ");
INSERT INTO tgk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","чунки аз шумо метарсидам. Охир шумо одами сахтгир ҳастед. Аз он ҷое, ки нагузоштаед, мегиред ва он чизеро, ки накоштаед, дарав мекунед“. ");
INSERT INTO tgk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Подшоҳ ба вай гуфт: „Ту хизматгори бад будаӣ! Аз рӯи он чизе ки гуфтӣ, ба ту ҳукм мебарорам! Охир ту медонистӣ, ки ман одами сахтгир ҳастам, аз он ҷое, ки нагузоштаам, мегирам ва он чизеро, ки накоштаам, дарав мекунам. ");
INSERT INTO tgk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Пас, чаро пули маро ба муомилот нагузоштӣ, то ки вақти баргаштанам онро бо фоидааш бигирам?“ ");
INSERT INTO tgk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Баъд ба онҳое, ки дар наздаш буданд, фармон дод: „Аз дасташ тангаи тиллоро гирифта, ба хизматгоре диҳед, ки даҳ танга дорад“. ");
INSERT INTO tgk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Онҳо гуфтанд: „Хоҷаам, охир вай аллакай даҳ тангаи тилло дорад!“ ");
INSERT INTO tgk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","„Ман ба шумо мегӯям, ба ҳар касе, ки чизе дорад, боз ҳам зиёд дода мешавад. Лекин аз касе, ки ҳеҷ чиз надорад, ҳатто он чизи андаке, ки дорад, гирифта мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ҳоло бошад, он душманонамро, ки намехостанд бар онҳо подшоҳӣ кунам, ба ин ҷо биёреду дар пеши назарам ба қатл расонед“». ");
INSERT INTO tgk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Исо ин масалро нақл карда, роҳашро давом дод ва ба сӯи Ерусалим раҳсипор гашт. ");
INSERT INTO tgk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Вақте ки онҳо ба деҳаҳои Байт-Фоҷӣ ва Байт-Ҳинӣ, ки дар доманаи теппаи Зайтун воқеъ гаштаанд, наздик шуданд, Исо ду шогирдашро фиристоданӣ шуда, ");
INSERT INTO tgk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ба онҳо гуфт: «Ба қишлоқи дарпешистода биравед ва, ҳамин ки вориди он гаштед, харкурраи бастаеро мебинед, ки то ҳол касе ба он савор нашудааст. Бандашро кушода, онро ба ин ҷо биёред. ");
INSERT INTO tgk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Агар касе аз шумо пурсад, ки барои чӣ бандашро мекушоед, гӯед, ки вай ба Худованд даркор шуд». ");
INSERT INTO tgk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Шогирдони фиристодашуда рафтанд ва, ҳамон тавре ки Ӯ ба онҳо гуфта буд, дарёфтанд. ");
INSERT INTO tgk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Вақте ки онҳо банди харкурраро мекушоданд, соҳибонаш аз онҳо пурсиданд: «Чаро банди харкурраро мекушоед?» ");
INSERT INTO tgk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Онҳо ҷавоб доданд: «Вай ба Худованд лозим аст». ");
INSERT INTO tgk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Пас онҳо харкурраро ба назди Исо оварда, ба болояш ҷомаҳои худро партофтанду Исоро ба он савор карданд. ");
INSERT INTO tgk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Исо савора мерафту мардум ҷомаҳояшонро дар сари роҳи Вай пойандоз мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Вақте Исо ба роҳе наздик шуд, ки он аз болои теппаи Зайтун ба поён мебурд, тамоми гурӯҳи шогирдонаш барои ҳамаи мӯъҷизаҳое, ки дида буданд, шодикунон бо овози баланд Худоро ҳамду сано хонда ");
INSERT INTO tgk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","мегуфтанд: «Баракат ёбад шоҳе, ки аз номи Худованд меояд! Сулҳ дар осмон ва шӯҳрату ҷалол ба Худо дар осмон!» ");
INSERT INTO tgk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Баъзе фарисиён аз байни мардум ба Исо гуфтанд: «Эй устод, шогирдонатро ором кун!» ");
INSERT INTO tgk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Вай ҷавоб дод: «Бовар кунед, агар онҳо хомӯш шаванд, сангҳо дод мезананд». ");
INSERT INTO tgk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Вақте ки онҳо наздиктар омаданд, Исо шаҳрро дида, дилаш ба ҳоли он сӯхта гиря карду гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«Оҳ, кошки ақаллан ҳамин рӯз роҳеро, ки туро ба осоиштагӣ мебарад, медидӣ! Вале ҳоло он роҳ аз чашмони ту ниҳон аст. ");
INSERT INTO tgk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Аз барои он ки ту ба наздат омадани Худовандро нафаҳмидӣ, ба сарат рӯзҳои сахт хоҳанд омад. Душманонат туро бо хоктӯдаҳо иҳота карда, муҳосира хоҳанд намуд. Онҳо аз ҳар тараф фишор оварда, туву сокинонатро ба хок яксон хоҳанд кард ва аз ту санг бар санге нахоҳад монд». ");
INSERT INTO tgk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Исо ба ҳавлии Хонаи Худо даромада, ба пеш кардани савдогарон даромад. ");
INSERT INTO tgk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Вай ба онҳо гуфт: «Дар навиштаҷот гуфтаҳои Худо омадаанд, ки „Хонаи Ман ҷои дуогӯӣ мешавад“. Шумо бошед, онро ба паноҳгоҳи дуздон табдил додаед!» ");
INSERT INTO tgk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ӯ ҳар рӯз дар ҳавлии Хонаи Худо мардумро таълим медод. Сардорони рӯҳонӣ, шариатдонон ва раисони халқи Исроил бошанд, дар фикри куштани Ӯ буданд. ");
INSERT INTO tgk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Вале илоҷи ин корро ёфта наметавонистанд, чунки тамоми мардум беист ва бодиққат ба ҳар як сухани Ӯ гӯш медоданд. ");
INSERT INTO tgk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Рӯзе, вақте ки Исо дар ҳавлии Хонаи Худо мардумро таълим дода, хабари хушро эълон мекард, ба наздаш сардорони рӯҳонӣ, шариатдонон ва пирони қавм омада ");
INSERT INTO tgk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","пурсиданд: «Ба мо бигӯй, Ту бо кадом ҳуқуқ ин корро мекунӣ? Кӣ ба Ту чунин ҳуқуқро додааст?» ");
INSERT INTO tgk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Исо дар ҷавоб гуфт: «Ман ҳам ба шумо як савол медиҳам ва шумо ба Ман ҷавоб диҳед, ки ");
INSERT INTO tgk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ба Яҳё кӣ ҳуқуқ дода буд, ки одамонро таъмид диҳад: Худо ё инсон?» ");
INSERT INTO tgk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Онҳо бо ҳам муҳокима намуда, мегуфтанд: «Агар „Худо“ гӯем, Вай аз мо мепурсад: „Чаро ба Яҳё бовар накардед?“ ");
INSERT INTO tgk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Агар „одамон“ гӯем, мардум моро сангсор мекунанд. Охир одамон боварии комил доранд, ки Яҳё пайғамбар буд». ");
INSERT INTO tgk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Онҳо ҷавоб доданд, ки намедонанд. ");
INSERT INTO tgk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","«Пас, Ман ҳам ба шумо намегӯям, ки бо кадом ҳуқуқ ин корро мекунам», — гуфт Исо. ");
INSERT INTO tgk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Баъд Исо ба халқ нақл кардани чунин масалро сар кард: «Шахсе токзоре бунёд карда, онро ба иҷоракорон ба иҷора дод ва худаш ба муддати дуру дароз ба кишвари дигар сафар кард. ");
INSERT INTO tgk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Чун вақти ҳосилғундорӣ расид, ӯ хизматгореро ба назди иҷоракорон фиристод, то ҳаққи худро аз он токзор бигирад. Вале иҷоракорон ӯро латукӯб карда, бо дасти холӣ баргардонданд. ");
INSERT INTO tgk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Он вақт ӯ хизматгори дигарашро фиристод. Вале онҳо ӯро ҳам зада, шарманда карданду бо дасти холӣ баргардонданд. ");
INSERT INTO tgk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ӯ боз хизматгори сеюмашро фиристод. Вайро низ маҷрӯҳ намуда, берун партофтанд. ");
INSERT INTO tgk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Он гоҳ соҳиби токзор гуфт: „Чӣ бояд бикунам? Писари азизамро мефиристам, шояд ӯро эҳтиром кунанд“. ");
INSERT INTO tgk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Вале иҷоракорон писари ӯро дида, ба якдигар гуфтанд: „Вай меросхӯр аст! Биёед, ӯро мекушем ва токзор аз они мо мешавад!“ ");
INSERT INTO tgk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ва ӯро аз токзор берун бароварда куштанд. Ба фикри шумо соҳиби токзор бо онҳо чӣ хел рафтор мекунад? ");
INSERT INTO tgk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Вай баргашта, он иҷоракоронро мекушаду токзорро ба дигарон медиҳад». Онҳое, ки Исоро мешуниданд, гуфтанд: «Худо нигоҳ дорад!» ");
INSERT INTO tgk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ӯ ба онҳо нигоҳ карда гуфт: «Пас ин калимаҳои навиштаҷот чӣ маъно доранд: „Он сангеро, ки бинокорон нодаркор ҳисоб карда, як сӯ партофтанд, санги асосии таҳкурсии бино гардид“. ");
INSERT INTO tgk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ҳар кӣ ба болои он санг ғалтад, шикаста майда-майда мешавад ва агар ин санг ба болои касе афтад, вайро маҷақ мекунад». ");
INSERT INTO tgk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Шариатдонону сардорони рӯҳонӣ фаҳмиданд, ки ин масал бар зидди онҳо равона шуда буд ва хостанд ҳамон замон Исоро дастгир кунанд, вале аз мардум метарсиданд. ");
INSERT INTO tgk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Онҳо якчанд нафарро барои аз пайи Исо поидан фиристоданд, то ки худро ростқавл нишон дода, Ӯро бо сухан ба дом афтонанду барои ҳукм шудан ба дасти ҳокими румӣ супоранд. ");
INSERT INTO tgk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Онҳо аз Исо пурсиданд: «Устод! Мо медонем, ки суханону таълимоти Шумо аз рӯи ҳақиқат аст. Медонем, ки нисбати ҳеҷ кас рӯйбинӣ надоред ва роҳҳои Худоро аз рӯи ҳақиқат таълим медиҳед. ");
INSERT INTO tgk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Бигӯед, оё раво аст, ки мо ба императори Рум андозу хироҷ супорем ё не?» ");
INSERT INTO tgk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ӯ аз макри онҳо пай бурда, ба онҳо гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ба Ман динореро нишон диҳед. Дар он акс ва номи кӣ аст?» «Император», — ҷавоб доданд онҳо. ");
INSERT INTO tgk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Исо ба онҳо гуфт: «Пас, он чӣ аз они император аст, бояд ба император баргардонда шавад ва он чӣ аз они Худост, ба Худо». ");
INSERT INTO tgk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Онҳо натавонистанд Исоро пеши мардум бо сухан ба дом афтонанд ва аз ҷавоби Ӯ ба ҳайрат афтода, хомӯш шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Чанд нафар аз саддуқиён (онҳо аз нав зиндашавиро инкор мекарданд) ба пеши Исо омаданду ");
INSERT INTO tgk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ба Вай чунин савол доданд: «Устод, Мӯсо дар қонун ба мо навиштааст, ки агар бародари касе фарзанд наёфта бимирад, бигзор вай зани ӯро ба никоҳи худ дарорад ва фарзандони ба дунё омадаро ҳамчун насли бародари марҳумаш бидонад. ");
INSERT INTO tgk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Инак, ҳафт бародар буданд. Бародари калонӣ зан гирифту фарзанде ба дунё наоварда мурд. ");
INSERT INTO tgk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Бародари дуюм, сеюм ва ҳамин тавр ҳамаи ҳафт бародарон ӯро ба занӣ мегирифтанд, вале ҳеҷ яке аз онҳо фарзанде ба дунё наоварда мурданд. ");
INSERT INTO tgk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Оқибат зан ҳам аз дунё чашм пӯшид. ");
INSERT INTO tgk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Пас, рӯзе, ки мурдаҳо аз нав зинда мешаванд, вай зани кадоме аз онҳо мешавад? Охир ҳамаи ҳафт бародарон ӯро ба занӣ гирифта буданд!» ");
INSERT INTO tgk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Исо ҷавоб дод: «Одамони ин олам зан мегиранд ва ба шавҳар мебароянд. ");
INSERT INTO tgk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Вале онҳое, ки ба зинда шудану дар олами оянда зиндагӣ кардан лоиқ дониста шудаанд, на зан мегиранд ва на ба шавҳар мебароянд. ");
INSERT INTO tgk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Онҳо дигар мурда наметавонанд, чунки мисли фариштаҳо мешаванд. Онҳо фарзандони Худо ҳастанд, охир Худо онҳоро аз мурдагон зинда кардааст. ");
INSERT INTO tgk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Дар бораи аз нав зинда шудани мурдагон бошад, худи Мӯсо ба воситаи буттаи сӯхтаистода нақл карда, Худовандро Худои Иброҳим, Худои Исҳоқ ва Худои Ёқуб меномад. ");
INSERT INTO tgk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ӯ на Худои мурдагон, балки Худои зиндагон аст. Барои Ӯ ҳама зинда ҳастанд». ");
INSERT INTO tgk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Он гоҳ баъзе аз шариатдонон гуфтанд: «Хуб гуфтӣ, устод!» ");
INSERT INTO tgk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ва дигар ҳеҷ кас ҷуръат накард, ки ба Ӯ саволе диҳад. ");
INSERT INTO tgk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Аммо Исо ба онҳо гуфт: «Чӣ тавр одамон гуфта метавонанд, ки Таъиншудаи Худо аз насли Довуд аст? ");
INSERT INTO tgk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Охир, худи Довуд дар китоби Забур мегӯяд: „Худованд ба Худованди ман гуфт: «То даме ки душманонатро зери пойҳоят наандозам, аз тарафи дасти рости Ман бишин»“. ");
INSERT INTO tgk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Довуд Ӯро „Худованд“ меномад. Пас, чӣ тавр Вай аз насли Довуд шуда метавонад?» ");
INSERT INTO tgk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ҳангоме ки тамоми мардум ба суханони Вай гӯш мекарданд, Исо ба шогирдони худ гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Аз шариатдонон эҳтиёт шавед. Чун либосҳои қимат пӯшида мегарданд ва ба онҳо маъқул аст, ки мардум дар бозорҳо ба онҳо салом диҳанд. Онҳо дӯст медоранд, ки дар ҷойҳои беҳтарини ибодатхонаҳо бишинанд ва дар тӯю зиёфатҳо бологузар бошанд. ");
INSERT INTO tgk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Онҳо намоишкорона дуру дароз дуо мехонанд, вале дар асл молу мулки бевазанонро хӯрда ғорат мекунанд! Барои ин корашон ҷазои сахттар мебинанд». ");
INSERT INTO tgk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Исо як назар андохта, бойҳоеро дид, ки ба сандуқи хайрия ҳадяҳои худро меандохтанд. ");
INSERT INTO tgk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ӯ бевазани камбағалеро низ дид, ки ба он ҷо ду тангаи хурди мисинро андохт. ");
INSERT INTO tgk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Баъд гуфт: «Ба ростӣ ба шумо мегӯям, ки ин бевазани бечора аз ҳама зиёдтар хайрот кард. ");
INSERT INTO tgk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Чунки онҳо аз зиёдатии бойигариашон хайрия карданд, вай бошад, ҳамаи он ризқу рӯзиашро, ки дошт, дод». ");
INSERT INTO tgk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Вақте ки баъзеҳо дар бораи Хонаи Худо сухан меронданду таъриф мекарданд, ки он бо чӣ гуна сангҳои зебо ва ҳадяҳои қиматбаҳо оро дода шудааст, Исо гуфт: ");
INSERT INTO tgk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Рӯзҳое меоянд, ки аз ҳамаи ин чизҳои медидаатон санг бар болои сангаш намонда ба замин яксон мегардад». ");
INSERT INTO tgk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Аз Ӯ пурсиданд: «Устод, пас ин ҳодиса кай рӯй медиҳад ва ба амал омадани онро аз кадом нишона мефаҳмем?» ");
INSERT INTO tgk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ӯ ҷавоб дод: «Эҳтиёт шавед, ки мабодо шуморо гумроҳ накунанд, зеро бисёр касоне пайдо мешаванд, ки гӯё аз номи Ман омада бошанду „Ман ҳамонам!“ ва ё „Вақташ расид!“ мегӯянд. Аз паси онҳо наравед! ");
INSERT INTO tgk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Вақте ки овозаи ҷангҳову шӯришҳо ба гӯшатон мерасад, ба воҳима наафтед. Зеро аввал бояд ҳамаи ин воқеаҳо ба вуҷуд оянд, вале ин маънои якбора расидани охирзамонро надорад». ");
INSERT INTO tgk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Баъд Исо ба онҳо гуфт: «Як халқ бо халқи дигар ҷанг мекунад ва як давлат ба давлати дигар ҳуҷум мекунад. ");
INSERT INTO tgk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Заминҷунбиҳои сахт ва дар ҷойҳои гуногун қаҳтиву гуруснагӣ ва вабо хоҳад шуд. Аз осмон ҳодисаҳои пурдаҳшат ва нишонаҳои бузург намоён хоҳанд гашт. ");
INSERT INTO tgk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Вале, пеш аз он ки ҳамаи ин ба амал ояд, шуморо дастгир карда, азоб хоҳанд дод ва ба ибодатхонаву зиндонҳо хоҳанд бурд. Аз барои номи Ман шуморо ба назди подшоҳону ҳокимон мебаранд. ");
INSERT INTO tgk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ин ҳамон вақтест, ки дар бораи Ман шаҳодат медиҳед. ");
INSERT INTO tgk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Қарор диҳед, то пешакӣ ташвиш накашед, ки дар ҷавоб чӣ бояд бигӯед. ");
INSERT INTO tgk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Зеро Ман ба шумо чунон ҳикмат ва суханпардозиро ато мекунам, ки ҳеҷ яке аз душманонатон наметавонад бар он муқобилате нишон дода, норозигии худро баён кунад. ");
INSERT INTO tgk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ҳатто падару модарон, бародарон, хешон ва дӯстонатон шуморо таслим хоҳанд намуд ва баъзеи шумо кушта мешавед. ");
INSERT INTO tgk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Аз барои Маро пайравӣ карданатон ҳама ба шумо бо чашми нафрат нигоҳ мекунанд. ");
INSERT INTO tgk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Вале як тори мӯйе ҳам аз сари шумо нахоҳад афтод. ");
INSERT INTO tgk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Истодагарӣ намоед ва ҳаётро ба даст хоҳед овард. ");
INSERT INTO tgk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ҳамин ки Ерусалимро дар иҳотаи аскарон дидед, бидонед, ки вақти вайрон шудани он наздик аст. ");
INSERT INTO tgk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Он вақт, агар касе дар Яҳудия бошад, ба кӯҳистон гурезад. Касе, ки дар Ерусалим бошад, аз он ҷо биравад ва касе, ки дар гирду атрофи шаҳр ҳаст, ба шаҳр барнагардад. ");
INSERT INTO tgk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Чун он рӯзҳо, ҳамчун иҷрошавии гуфтаҳои навиштаҷот, рӯзҳои ҷазо мешаванд. ");
INSERT INTO tgk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Вой бар ҳоли заноне, ки он рӯзҳо ҳомиладор хоҳанд буд ва модароне, ки кӯдаки ширхор хоҳанд дошт, чунки дар замин мусибати бузурге ба амал меояду ин мардум гирифтори ғазаб мешавад. ");
INSERT INTO tgk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Баъзеҳо аз дами шамшер ҳалок мегарданду дигаронро ба мамлакатҳои гуногун асир карда мебаранд. Ғайрияҳудиён бошанд, то вақти ба охир расидани давраи онҳо Ерусалимро поймол мекунанд. ");
INSERT INTO tgk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Дар офтоб, моҳ ва ситорагон нишонаҳое зоҳир мешаванд ва дар рӯи замин мардум ба ғаму андӯҳ печида, аз хурӯши баҳру мавҷҳо ба ҳайрат меафтанд. ");
INSERT INTO tgk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Аз барои он ки ҳама чиз дар осмон ба ҷунбиш меояд, одамон аз наздик шудани мусибате, ки ба сари ҷаҳон меояд, тарсида беҳуш мешаванд. ");
INSERT INTO tgk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Дар он вақт одамон Фарзанди Инсонро мебинанд, ки дар болои абр бо қудрат ва шӯҳрату ҷалоли бузурге меояд. ");
INSERT INTO tgk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Вақте ки ба амал омадани ин гуфтаҳо сар мешавад, қомататонро рост карда саратонро боло бардоред, чунки вақти харида гирифта шуданатон наздик аст». ");
INSERT INTO tgk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Баъд Исо ба онҳо чунин масалеро нақл кард: «Ба дарахти анҷир ва дигар дарахтҳо нигоҳ кунед. ");
INSERT INTO tgk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Вақте мебинед, ки онҳо барг мебароранд, медонед, ки тобистон аллакай наздик аст. ");
INSERT INTO tgk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Пас шумо ҳам вақте ки ба амал омадани ин чизҳоро мебинед, донед, ки подшоҳии Худо наздик аст. ");
INSERT INTO tgk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ба ростӣ ба шумо мегӯям, ки ҳанӯз одамони ин насл аз олам нагузашта, ҳамаи ин ба амал меояд. ");
INSERT INTO tgk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Замину осмон нест мешавад, аммо гуфтаҳои Ман то абад мемонанд. ");
INSERT INTO tgk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Пас, бохабар бошед, ки дилҳои шумо саргарми айшу ишрат, бадмастӣ ва ташвишҳои ин рӯзгор нашавад, ки, вагарна он рӯз ногаҳон, ");
INSERT INTO tgk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","мисли дом барои шумо фаро хоҳад расид. Зеро он рӯз ба сари тамоми сокинони рӯи замин хоҳад омад. ");
INSERT INTO tgk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ҳамеша бедор бошед ва дуо гӯед, то қувват дошта бошед, ки аз мусибатҳои омадаистода халосӣ ёбед ва дар назди Фарзанди Инсон истед». ");
INSERT INTO tgk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ҳар рӯз Исо дар ҳавлии Хонаи Худо таълим медод ва бо фарорасии бегоҳ ба теппаи Зайтун рафта, ҳамон ҷо шабро рӯз мекард. ");
INSERT INTO tgk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Тамоми мардум бошанд, саҳарии барвақт барои шунидани суханони Ӯ ба ҳавлии Хонаи Худо меомаданд. ");
INSERT INTO tgk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Иди Фатир, ки боз иди Балогардон ном дорад, наздик мешуд. ");
INSERT INTO tgk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Сардорони рӯҳонӣ ва шариатдонон аз мардум метарсиданд, бинобар ин роҳи пинҳонӣ ба қатл расондани Исоро ҷустуҷӯ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ҳамон вақт ба дили Яҳудои Исқарют, ки яке аз он дувоздаҳ шогирд буд, шайтон даромад. ");
INSERT INTO tgk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Яҳудо ба назди сардорони рӯҳонӣ ва саркорони посбонони Хонаи Худо омада, бо онҳо маслиҳат кард, ки бо кадом роҳ метавонад Исоро ба онҳо таслим кунад. ");
INSERT INTO tgk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Онҳо шод гашта, розӣ шуданд, ки ба Яҳудо пул диҳанд. ");
INSERT INTO tgk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Яҳудо ҳам розӣ шуд ва фурсати қулай меҷуст, ки аз мардум пинҳонӣ Исоро ба онҳо таслим кунад. ");
INSERT INTO tgk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Рӯзи иди Фатир ҳам фаро расид ва дар ин рӯз бояд барраи балогардонро қурбонӣ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Исо Петрус ва Юҳанноро фиристода, гуфт: «Бираведу бароямон дастархони иди Балогардонро тайёр кунед». ");
INSERT INTO tgk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Онҳо аз Ӯ пурсиданд: «Дар куҷо мехоҳед, ки тайёр кунем?» ");
INSERT INTO tgk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Исо ба онҳо дар ҷавоб гуфт: «Вақте ки ба шаҳр медароед, шуморо марде пешвоз мегирад, ки кӯзаи об бардошта мебарад. Аз ақибаш то ба хонае, ки вай медарояд, биравед. ");
INSERT INTO tgk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ба соҳиби он хона бигӯед: „Устод аз ту мепурсад, куҷост меҳмонхонае, ки Ӯ дар он бо шогирдонаш хӯроки иди Балогардонро хӯрда метавонад?“ ");
INSERT INTO tgk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ӯ ба шумо болохонаи калонеро нишон медиҳад, ки аллакай ба тартиб оварда шудааст. Дастархонро дар ҳамон ҷо андозед». ");
INSERT INTO tgk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Онҳо рафта, ҳамаро ҳамон тавре ки Исо гуфта буд, дарёфтанд ва хӯроки иди Балогардонро тайёр намуданд. ");
INSERT INTO tgk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ҳангоме ки вақту соаташ расид, вакилон ҳамроҳи Исо ба гирди дастархон нишастанд. ");
INSERT INTO tgk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Исо ба онҳо гуфт: «Бисёр мехостам, ки пеш аз азобу уқубатҳоям бо шумо ин хӯроки иди Балогардонро бихӯрам. ");
INSERT INTO tgk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ба шумо мегӯям, аз он дигар нахоҳам хӯрд, то он вақте ки ба маънои пуррааш дар подшоҳии Худо ба амал наояд». ");
INSERT INTO tgk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Баъд косаи майро гирифта дуои шукрона карду гуфт: «Инро гиреду банавбат бинӯшед. ");
INSERT INTO tgk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ба шумо мегӯям, минбаъд то вақти омадани подшоҳии Худо аз меваи ангур нахоҳам нӯшид». ");
INSERT INTO tgk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Сипас, нонро гирифта, дуои шукрона намуд ва онро пора карда, ба вакилон доду гуфт: «Ин бадани Ман аст, ки аз барои шумо қурбонӣ карда мешавад. Ба хотираи Ман ҳамин тавр бикунед». ");
INSERT INTO tgk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ва айнан ҳамин тавр баъд аз хӯроки шом косаро гирифта гуфт: «Ин коса аҳди навест, ки дар хуни барои шумо мерехтаам, баста шудааст. ");
INSERT INTO tgk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ҳоло нигоҳ кунед, касе, ки Маро таслим мекунад, бо Ман дар сари як дастархон нишастааст. ");
INSERT INTO tgk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Бале, Фарзанди Инсон бо роҳе меравад, ки барояш муайян шудааст, вале вой бар ҳоли касе, ки ба Ӯ хиёнат мекунад!» ");
INSERT INTO tgk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Вакилон аз якдигар пурсидан гирифтанд, ки кадоме аз онҳо ин корро мекарда бошад. ");
INSERT INTO tgk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Дар байни шогирдон баҳсу мунозира ба амал омад, ки кадоме аз онҳо бояд бузургтар шумурда шавад. ");
INSERT INTO tgk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Исо бошад, ба онҳо гуфт: «Подшоҳони халқҳо ва ҳокимони онҳо ҳукмашонро бар зердастони худ мегузаронанд ва „эҳсонкор“ номида мешаванд. ");
INSERT INTO tgk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Аммо дар байни шумо набояд ин тавр бошад. Бигзор бузургтарин аз байни шумо мисли хурдтарин рафтор бикунад ва сардор мисли хизматгор. ");
INSERT INTO tgk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Пас, кӣ бузургтар аст? Оне, ки дар сари дастархон нишастааст ва ё касе, ки ба вай хизмат мекунад? Магар на он касе, ки дар сари дастархон нишастааст? Вале Ман дар мобайни шумо мисли хизматгор ҳастам! ");
INSERT INTO tgk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Шумо ҳамроҳам аз озмоишҳои Ман гузаштед ");
INSERT INTO tgk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ва он подшоҳиеро, ки Падарам ба Ман ато намудааст, Ман низ ба шумо тӯҳфа мекунам, ");
INSERT INTO tgk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","то ки шумо дар подшоҳии Ман аз дастархонам бихӯреду бинӯшед ва бар тахтҳо нишаста, ба дувоздаҳ қабилаи Исроил ҳукмронӣ кунед». ");
INSERT INTO tgk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Исо гуфт: «Шимъӯн, Шимъӯн! Бидон, ки шайтон талабгори он шуд, ки ҳамаи шуморо монанди гандум аз ғалбер гузаронад. ");
INSERT INTO tgk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Вале Ман барои ту дуо кардам, то ки имонатро аз даст надиҳӣ ва вақти ба наздам баргаштанат бародарони худро устувор гардонӣ». ");
INSERT INTO tgk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Петрус ба Ӯ гуфт: «Худовандо! Ман тайёр ҳастам, ки бо Ту ҳам ба ҳабс ва ҳам ба мурдан биравам!» ");
INSERT INTO tgk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Вале Исо гуфт: «Ба ту мегӯям, ҳой Петрус! Худи ҳамин рӯз, пеш аз он ки хурӯс ҷеғ занад, ту се бор мегӯӣ, ки Маро намешиносӣ». ");
INSERT INTO tgk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Исо аз шогирдон пурсид: «Вақте ки Ман шуморо бе пул, бе борхалта ва бе пойафзол фиристода будам, магар ба чизе мӯҳтоҷ шуда будед?» Онҳо ҷавоб доданд: «Ба ҳеҷ чиз». ");
INSERT INTO tgk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ӯ гуфт: «Вале акнун, бигзор он касе, ки пул дорад, пулу борхалтаашро бо худ бигирад. Агар шамшер надошта бошад, бигзор ҷомаашро фурӯхта, онро бихарад. ");
INSERT INTO tgk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ба шумо мегӯям, дар навиштаҷот гуфта шудааст: „Ӯро ба қатори ҷинояткорон дароварданд“. Ин гуфтаҳо дар Ман бояд иҷро шаванд ва дар ҳақиқат ҳамаи он чизе, ки дар ҳаққи Ман навишта шудааст, иҷро шуда истодааст». ");
INSERT INTO tgk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Онҳо гуфтанд: «Худовандо! Ана дар ин ҷо ду шамшер ҳаст». Вай ҷавоб дод: «Кифоя аст!» ");
INSERT INTO tgk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Исо аз хона баромада, чун ҳарвақта ба теппаи Зайтун равона шуд. Шогирдон низ аз ақиби Ӯ рафтанд. ");
INSERT INTO tgk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ба он ҷо расида, Исо ба онҳо гуфт: «Дуо кунед, то ки ба васваса наафтед». ");
INSERT INTO tgk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Худаш бошад, ба масофаи партофтани санге аз онҳо дур шуд ва ба зону истода дуо кард: ");
INSERT INTO tgk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Эй Падар! Илтимос мекунам, ин косаи азобро аз Ман дур кун. Вале бигзор на хости Ман, балки хости Ту ба амал ояд!» ");
INSERT INTO tgk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Аз осмон фариштае зоҳир шуд ва ба Ӯ қувват бахшид. ");
INSERT INTO tgk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Исо аз дарду сӯзиши зиёд бо ҷидду ҷаҳди бештаре дуо мекард ва арақ аз Ӯ мисли қатраҳои хун ба замин мечакид. ");
INSERT INTO tgk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Баъд аз дуо Исо бархеста, ба назди шогирдон рафт ва дид, ки онҳо аз ғаму ғусса бемадор шуда хобидаанд. ");
INSERT INTO tgk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Пас, ба онҳо гуфт: «Чаро хоб рафтаед? Бархеста дуо кунед, то ки ба васваса наафтед». ");
INSERT INTO tgk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ҳанӯз Ӯ суханашро тамом накарда, мардуми бисёре пайдо шуданд ва пешопеши онҳо касе меомад, ки Яҳудо ном дошту яке аз он дувоздаҳ шогирд буд. Вай ба Исо наздик шуд, то ки Ӯро бибӯсад. ");
INSERT INTO tgk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Исо ба вай гуфт: «Яҳудо, магар бо ин бӯсаат Фарзанди Инсонро таслим мекунӣ?» ");
INSERT INTO tgk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Пас шогирдоне, ки дар гирди Исо истода буданд, аз оқибати кор пай бурда гуфтанд: «Худовандо! Шояд шамшерҳоро ба кор барем?» ");
INSERT INTO tgk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ва яке аз онҳо ба ғуломи сарвари рӯҳониён ҳамла оварду гӯши росташро бурида партофт. ");
INSERT INTO tgk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","«Бас кунед, бас!» — гуфт Исо ва ба гӯши ғулом даст расонда, ӯро шифо дод. ");
INSERT INTO tgk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Баъд ба сардорони рӯҳонӣ, саркорони посбонии Хонаи Худо ва пирони қавм, ки барои дастгир намудани Ӯ омада буданд, гуфт: «Шумо магар Маро роҳзан гумон мебаред, ки бо таёқу шамшерҳо омадаед? ");
INSERT INTO tgk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ҳар рӯз ҳамроҳатон дар Хонаи Худо будам ва шумо ба Ман даст боло намекардед. Ҳоло бошад, даври шумо, яъне вақти ҳукмронии зулмот фаро расидааст». ");
INSERT INTO tgk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Онҳо Исоро дастгир намуда, ба хонаи сарвари рӯҳониён бурданд. Петрус каме дуртар аз онҳо роҳ мерафт. ");
INSERT INTO tgk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Дар мобайни ҳавлӣ гулхан даргиронданд ва одамон якҷоя нишастанд. Петрус ҳам бо онҳо нишаст. ");
INSERT INTO tgk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Яке аз канизакон дид, ки вай дар равшании оташ нишастааст, бодиққат ба ӯ нигоҳ карда гуфт: «Ин одам ҳам бо Исо буд!» ");
INSERT INTO tgk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Вале Петрус инкор карда гуфт: «Эй хоҳар! Ман Ӯро намешиносам». ");
INSERT INTO tgk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Баъд аз чанд муддат як одами дигар вайро дида гуфт: «Ту ҳам яке аз онҳо ҳастӣ». «Не охир, ака!» — гуфт Петрус. ");
INSERT INTO tgk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Тахминан як соат гузашту боз як нафар бо боварии комил гуфт: «Аниқ ин кас ҳам бо Исо буд, чунки ӯ ҷалилӣ аст». ");
INSERT INTO tgk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","«Гӯш кун, ман намедонам, ту дар чӣ хусус гап мезанӣ», — гуфт Петрус. Вақте ки инро мегуфт, хурӯс ҷеғ зад. ");
INSERT INTO tgk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Худованд ба Петрус рӯй оварда нигоҳ кард ва Петрус суханони Худовандро ба ёдаш овард, ки гуфта буд: «Худи ҳамин рӯз, ҳанӯз хурӯс ҷеғ назада, ту се бор Маро инкор мекунӣ». ");
INSERT INTO tgk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Петрус аз ҳавлӣ берун баромада, зор-зор гиря кард. ");
INSERT INTO tgk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Одамоне, ки Исоро дастгир карда буданд, Ӯро таҳқир намуда мезаданд. ");
INSERT INTO tgk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Чашмонашро баста, аз Ӯ мепурсиданд: «Ҳой пайғамбар! Канӣ, гӯй-чи Туро кӣ зад?» ");
INSERT INTO tgk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ва Ӯро бисёр ҳақорат мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Вақте ки рӯз шуд, ҷамоате аз пирони қавм, сардорони рӯҳонӣ ва шариатдонон ҳамроҳ шуда, Исоро ба шӯрои худ оварданд. ");
INSERT INTO tgk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Онҳо гуфтанд: «Ба саволамон ҷавоб деҳ. Оё Ту Таъиншудаи Худо ҳастӣ?» Исо гуфт: «Агар Ман ба саволатон ҷавоб диҳам, шумо бовар намекунед ");
INSERT INTO tgk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ва агар худам савол диҳам, ҷавоб намегардонед. ");
INSERT INTO tgk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Вале минбаъд Фарзанди Инсон аз тарафи рости Худои Пурқудрат хоҳад нишаст». ");
INSERT INTO tgk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ҳозирбудагон гуфтанд: «Пас, Ту-чи писари Худо ҳастӣ?» Ӯ ҷавоб дод: «Ҳастам, аз рӯи гуфти худатон». ");
INSERT INTO tgk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Пас, онҳо гуфтанд: «Боз чӣ далеле ба мо лозим аст? Худи мо ҳама чизро аз забони Ӯ шунидем!» ");
INSERT INTO tgk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Баъд тамоми аҳли маҷлиси онҳо аз ҷой бархеста, Исоро ба назди Пилотус бурданд ");
INSERT INTO tgk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ва ба айбдор кардани Ӯ шурӯъ намуда, гуфтанд: «Мо аниқ кардем, ки ин одам мардуми моро аз роҳ мезанад. Вай ба император супоридани андозро манъ мекунад ва ҳатто худро Таъиншудаи Худо, Подшоҳ меномад». ");
INSERT INTO tgk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Пилотус аз Ӯ пурсид: «Магар Ту Шоҳи Яҳудиён ҳастӣ?» Исо ба вай ҷавоб дод: «Худатон ҳамин тавр мегӯед». ");
INSERT INTO tgk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Пилотус ба сардорони рӯҳонӣ ва мардум гуфт: «Ман дар Ӯ ҳеҷ айб наёфтам». ");
INSERT INTO tgk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Вале онҳо дар гапи худ истода мегуфтанд: «Ӯ бо таълимоташ тамоми мардуми Яҳудияро ба шӯр меандозад. Аз Ҷалил сар карда то ин ҷо омад». ");
INSERT INTO tgk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Пилотус инро шунида пурсид: «Ин одам аз Ҷалил аст?» ");
INSERT INTO tgk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ва чун фаҳмид, ки Исо аз вилояти дар зердасти Ҳиродус будааст, Ӯро ба назди Ҳиродус фиристод. Худи Ҳиродус ҳамон вақт дар Ерусалим буд. ");
INSERT INTO tgk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ҳиродус Исоро дида, бисёр хурсанд шуд, зеро кайҳо боз Ӯро дидан мехост ва азбаски дар борааш бисёр чизҳоро шунида буд, умед дошт, ки ягон мӯъҷизаи Исоро мебинад. ");
INSERT INTO tgk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Вай ба Исо саволҳои бисёре дод, вале Ӯ дар ҷавоб ҳеҷ чиз нагуфт. ");
INSERT INTO tgk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Сардорони рӯҳонӣ ва шариатдонон бошанд, дар ҷои худ истода бо шиддати хашму ғазаб Ӯро айбдор менамуданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ҳиродус бо сарбозонаш Исоро таҳқир ва масхара кард. Баъд ба Ӯ ҷомаи шоҳона пӯшонда, боз ба назди Пилотус фиристод. ");
INSERT INTO tgk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Гарчанде пештар Ҳиродус ва Пилотус бо якдигар душман буданд, аз ҳамон рӯз сар карда бо ҳам дӯст шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Пилотус сардорони рӯҳонӣ, роҳбарон ва мардумро даъват карда, ");
INSERT INTO tgk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ба онҳо гуфт: «Шумо ин одамро ҳамчун вайронкунандаи халқ ба назди ман овардед. Ман дар ҳузури шумо ба Вай савол дода фаҳмидам, ки ин одам дар ягон ҷинояте, ки шумо Ӯро гунаҳкор мекунед, айбдор нест. ");
INSERT INTO tgk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ҳиродус ҳам дар Ӯ ягон айбе наёфта, Ӯро боз ба назди мо фиристод. Пас ин одам ҳеҷ коре накардааст, ки сазовори марг бошад. ");
INSERT INTO tgk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ман фармон медиҳам, ки Ӯро қамчинкорӣ карда, баъд ҷавоб диҳанд». ");
INSERT INTO tgk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ҳамин вақт ҳама бо як овоз дод заданд: «Қатл кунед Ӯро! Барои мо Бараббосро озод кунед!» ");
INSERT INTO tgk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Бараббос одаме буд, ки аз барои бардоштани шӯриш дар шаҳр ва одамкушӣ ба ҳабс партофта шуда буд.) ");
INSERT INTO tgk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Пилотус, ки Исоро озод кардан мехост, боз ба онҳо сухан гуфт. ");
INSERT INTO tgk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Вале онҳо дод мезаданд: «Ӯро ба салиб мехкӯб кунед! Мехкӯб кунед!» ");
INSERT INTO tgk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Пилотус бори сеюм ҳам ба онҳо гуфт: «Чаро? Охир Вай чӣ бадие кардааст? Ман дар Ӯ ҳеҷ айберо намебинам, ки сазовори марг бошад. Ман Ӯро қамчинкорӣ карда ҷавоб медиҳам». ");
INSERT INTO tgk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Вале онҳо ду пойро ба як мӯза андохта, бо тамоми овоз дод мезаданду талаб мекарданд, ки Исо дар салиб мехкӯб карда шавад. Доду фарёди онҳо бар Пилотус ғалаба намуд ");
INSERT INTO tgk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ва ӯ ҳамон ҳукмеро баровард, ки онҳо талаб мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Мувофиқи хоҳиши онҳо вай шахсеро, ки барои шӯриш ва одамкушӣ ба ҳабс партофта шуда буд, озод намуд. Исоро бошад, ба ихтиёри онҳо супорид. ");
INSERT INTO tgk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Вақте ки сарбозон Исоро ба қатл мебурданд, бо Шимъӯн ном марди қуринӣ дучор шуданд, ки аз деҳа омада истода буд. Онҳо ӯро дастгир карда ба болояш салибро бор карданд, ки онро аз ақиби Исо бардошта барад. ");
INSERT INTO tgk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Аз ақиби Исо одамони бешуморе мерафтанд ва дар байни онҳо заноне буданд, ки барои Ӯ бо оҳу нола навҳа мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Исо ба онҳо рӯ оварда гуфт: «Эй занҳои Ерусалим, ба ҳоли Ман гиря накунед! Ба ҳоли худ ва фарзандонатон гиря кунед. ");
INSERT INTO tgk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Зеро рӯзҳое меоянд, ки одамон чунин мегӯянд: „Хушбахтанд занҳое, ки нозой ҳастанд, таваллуд накардаанд ва фарзанд намакондаанд“. ");
INSERT INTO tgk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Он вақт ба кӯҳҳо хоҳанд гуфт: „Ба сари мо биафтед!“ ва ба теппаҳо хоҳанд гуфт: „Моро пинҳон кунед!“ ");
INSERT INTO tgk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Агар бо Ман, ки мисли дарахти сабз ҳастам, чунин рафтор кунанд, аҳволи онҳое, ки мисли дарахти хушк ҳастанд, чӣ мешуда бошад?» ");
INSERT INTO tgk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ҳамроҳи Исо боз ду ҷинояткорро ба қатл мебурданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Чун ба ҷое расиданд, ки «Косахонаи Сар» ном дорад, Исоро ба салиб мехкӯб карданд ва он ҷинояткорон низ, яке аз тарафи рост ва дигаре аз тарафи чапи Ӯ ба салибҳо мехкӯб карда шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Исо гуфт: «Эй Падар! Онҳоро бубахш, чун намефаҳманд, ки чӣ кор мекунанд!» Сипас сарбозон бо партофтани қуръа соҳибшавандаи либоси Исоро муайян намуда, онро байни ҳам тақсим карданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Мардум рост истода тамошо мекарданд. Роҳбарони халқ бошанд, ба ҳоли Исо хандида мегуфтанд: «Дигаронро наҷот медод, канӣ, агар Таъиншуда ва интихобшудаи Худо бошад, худро наҷот диҳад!» ");
INSERT INTO tgk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Сарбозон низ Ӯро таҳқир менамуданд. Онҳо ба Исо наздик мешуданд ва ба Ӯ майи туршшударо дароз карда, ");
INSERT INTO tgk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","мегуфтанд: «Агар Ту Шоҳи Яҳудиён бошӣ, худро наҷот деҳ!» ");
INSERT INTO tgk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ба лавҳае, ки болотар аз сари Исо зада шуда буд, чунин навиштанд: «Ин Шоҳи Яҳудиён аст». ");
INSERT INTO tgk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Яке аз ҷинояткорони мехкӯбшуда ба сари Исо дод зада гуфт: «Магар Ту Таъиншудаи Худо нестӣ? Охир худату моро ҳам наҷот деҳ!» ");
INSERT INTO tgk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Вале дуюмин ӯро сарзаниш карда гуфт: «Магар аз Худо наметарсӣ? Охир, мо ҳам ба марг маҳкум шудаем. ");
INSERT INTO tgk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Вале ҷазои мо аз рӯи адолат аст, зеро чиро сазовор шуда бошем, ҳамонро гирифтем. Вай бошад, ҳеҷ кори баде накардааст». ");
INSERT INTO tgk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Баъд ӯ гуфт: «Исо, илтимос, вақте ки ба подшоҳиат дохил мешавӣ, маро ба ёдат биёр». ");
INSERT INTO tgk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Исо ба ӯ ҷавоб дод: «Ба ростӣ ба ту мегӯям, ки худи ҳамин рӯз бо Ман дар биҳишт хоҳӣ буд». ");
INSERT INTO tgk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Қариби нисфирӯзӣ буд, ки тамоми заминро торикӣ фаро гирифт ва се соат давом ёфт. ");
INSERT INTO tgk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Офтоб рӯшноӣ намекард ва ҳамин вақт пардаи даромади ҷои муқаддастарини Хонаи Худо ба ду қисм пора шуд. ");
INSERT INTO tgk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Исо бо овози баланд нидо карда гуфт: «Эй Падар! Рӯҳи худро ба дасти Ту месупорам!» Инро гуфта, ҷон дод. ");
INSERT INTO tgk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Сардори лашкар ин ҳодисаро дида, Худоро ҳамду сано хонд ва гуфт: «Дар ҳақиқат ин одам бегуноҳ буд». ");
INSERT INTO tgk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Тамоми мардуме, ки ба тамошои ин ҳодиса ҷамъ омада буданд, инро дида, аз ғам мушт бар сина мезаданду ба хонаҳояшон бармегаштанд. ");
INSERT INTO tgk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Вале ҳамаи онҳое, ки Исоро пештар мешинохтанд ва занҳое, ки бо Ӯ аз Ҷалил омада буданд, аз дур истода тамоми воқеаҳоро медиданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Як марди бо номи Юсуф аз шаҳри Аромоти яҳуднишин буд, ки фаро расидани подшоҳии Худоро интизорӣ мекашид. Ӯ шахси хубу накӯкор буд ва гарчанд аъзои шӯро бошад ҳам, бо кору қарори баровардаи шӯро розӣ набуд. ");
INSERT INTO tgk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Юсуф ба назди Пилотус омада, хоҳиш кард, ки ҷасади Исоро ба ӯ диҳанд. ");
INSERT INTO tgk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ӯ онро аз салиб поён фароварда, ба суфи сафед кафанпеч намуду ба қабре гузошт, ки аз санг ба шакли ғор тарошида шуда буд. То ҳол ба он қабр касеро нагузошта буданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Саршавии рӯзи истироҳат наздик буду мардум ба он тайёрӣ медиданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Занҳое, ки бо Исо аз Ҷалил омада буданд, аз ақиби Юсуф рафта, ҳам қабр ва ҳам тарзи гӯронда шудани ҷасади Исоро диданд. ");
INSERT INTO tgk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Баъд онҳо ба хонаҳояшон баргашта, атрҳои хушбӯй ва молиданиҳоро тайёр намуданд. Дар рӯзи истироҳат онҳо мувофиқи қонун истироҳат карданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Рӯзи якшанбе, саҳарии барвақт занҳо атрҳои хушбӯйро гирифта, ба сӯи қабр равона шуданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Вале омада диданд, ки санги даҳани қабр ба як тараф ғелонда шудааст. ");
INSERT INTO tgk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Онҳо ба дарун даромада ҷасадро наёфтанд. ");
INSERT INTO tgk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Занҳо ҳайрон шуда меистоданд, ки баногоҳ дар пеши назарашон ду одам пайдо шуданд, ки дар тан либосҳои дурахшон доштанд. ");
INSERT INTO tgk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Занҳо аз тарс худро рӯй ба замин партофтанд, вале он ду нафар ба онҳо гуфтанд: «Чаро зиндаро дар байни мурдаҳо мекобед? ");
INSERT INTO tgk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ба ёд оред, ки вақти дар Ҷалил буданаш Вай ба шумо чӣ гуфта буд? ");
INSERT INTO tgk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ӯ гуфта буд, ки Фарзанди Инсон бояд ба дасти гунаҳкорон супорида шавад ва онҳо бояд Ӯро ба салиб мехкӯб кунанд, вале дар рӯзи сеюм Ӯ бояд зинда гардад». ");
INSERT INTO tgk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ва занҳо суханони Исоро ба хотир оварданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Сипас он занҳо аз сари қабр баргашта, ҳамаи инро ба он ёздаҳ шогирд ва ҳамаи дигарон нақл намуданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Дар ин бора ба вакилон Марями Маҷдалия, Юҳона, Марям, ки модари Ёқуб буд ва занҳои дигар низ нақл карданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Вале суханони онҳо ба назари вакилон ҳамчун сафсатаи бофташуда намуд ва онҳо ба гапи занҳо бовар накарданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Петрус бошад, ҳамон замон ба сӯи қабр давида, ба даруни он нигоҳ кард, лекин танҳо кафани холиро диду аз ин ҳодиса ҳайрон шуда, ба хона баргашт. ");
INSERT INTO tgk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Худи ҳамон рӯз ду нафар аз пайравони Исо ба Аммоус ном деҳае равона буданд, ки тақрибан 12 километр аз Ерусалим дур буд. ");
INSERT INTO tgk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Роҳравон бо якдигар дар бораи ҳамаи ин воқеаҳо гуфтугӯ мекарданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ҳангоми гуфтугӯю муҳокимаашон худи Исо ба онҳо наздик шуда, ҳамроҳашон равона шуд. ");
INSERT INTO tgk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Аммо чашмони он ду нафарро гӯё чизе гирифта бошад, ки Исоро медиданду намешинохтанд. ");
INSERT INTO tgk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Пас, Ӯ ба сухан даромада аз онҳо пурсид: «Шумо роҳравон чиро муҳокима мекунед?» Онҳо, ки чеҳраҳои ғамгин доштанд, бозистоданд ");
INSERT INTO tgk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ва якеашон, ки Клеюпос ном дошт, ба саволи Исо бо савол ҷавоб дод: «Магар Шумо ягона мусофире дар Ерусалим ҳастед, ки аз воқеаи ҳамин рӯзҳо дар ин ҷо рӯйдода хабар надоред?» ");
INSERT INTO tgk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Исо пурсид: «Аз кадом воқеа?» Онҳо гуфтанд: «Аз воқеае, ки бо Исои Носирӣ рӯй дод. Ӯ дар пеши Худову тамоми мардум пайғамбари дар гуфтору кирдор тавоно буд. ");
INSERT INTO tgk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Вале сардорони рӯҳонӣ ва аъзоёни шӯрои мо Ӯро ба дасти румиён супориданд, то ба марг маҳкум намоянд ва Ӯро ба салиб мехкӯб карданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Мо бошем, умед доштем, ки Ӯ Исроилро озод мекунад. Ҳа, боз як чиз… Имрӯз се рӯз мешавад, ки ин воқеа рӯй дод ");
INSERT INTO tgk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ва ҳоло занҳои гурӯҳамон моро ҳайрон карданд. Онҳо саҳарии барвақт ба сари қабр рафта, ");
INSERT INTO tgk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ҷасади Исоро наёфтанд. Сипас баргашта, арз намуданд, ки ба онҳо фариштагон зоҳир шуда гуфтанд, ки Ӯ зинда аст. ");
INSERT INTO tgk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Чанд нафар аз гурӯҳи мо ба сари қабр рафта, ҳамон тавре ки занҳо гуфта буданд, дарёфтанд, вале худи Исоро надиданд». ");
INSERT INTO tgk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Исо ба он ду нафар гуфт: «Оҳ, чӣ хел шумо кундфаҳм ҳастед! Бо чӣ душворӣ ба ҳамаи он чизе, ки пайғамбарон гуфта буданд, имон меоваред! ");
INSERT INTO tgk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Магар Таъиншудаи Худо пеш аз соҳиби тамоми шӯҳрату ҷалолаш шудан набояд ҳамаи ин азобро аз сар мегузаронд?» ");
INSERT INTO tgk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Он гоҳ Ӯ аз навиштаҳои Мӯсо ва ҳамаи пайғамбарон сар карда ҳар як ҷои навиштаҷотро, ки дар борааш чизе гуфта шуда буд, ба онҳо фаҳмонд. ");
INSERT INTO tgk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Вақте он ду нафар ба деҳае, ки мерафтанд, наздик шуданд, ба назарашон намуд, ки Исо роҳашро давом додан мехоҳад. ");
INSERT INTO tgk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Вале онҳо Ӯро бисёр хоҳиш карда гуфтанд: «Бо мо бимон. Рӯз ба охир расида истодаасту шом наздик аст». Исо ба хона даромада, бо он ду нафар монд. ");
INSERT INTO tgk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ӯ бо онҳо дар сари дастархон нишаста, нонро ба даст гирифт ва дуои шукрона карду онро пора карда ба он ду нафар дод. ");
INSERT INTO tgk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ҳамин вақт гӯё пардае аз чашмони он ду нафар бардошта шуд ва онҳо Исоро шинохтанд, вале Ӯ аз назари онҳо нопадид гашт. ");
INSERT INTO tgk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Онҳо ба якдигар мегуфтанд: «Вақте ки Ӯ дар роҳ бо мо сӯҳбат мекарду навиштаҷотро мефаҳмонд, магар мо ба ҳаяҷон намеомадем?» ");
INSERT INTO tgk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Онҳо зуд аз ҷой бархеста, ба Ерусалим баргаштанду он ёздаҳ вакил ва пайравони дигари Исоро ҷамъ шуда ёфтанд, ");
INSERT INTO tgk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ки байни худ мегуфтанд: «Дар ҳақиқат Худованд аз мурдагон зинда шуд! Вай ба Шимъӯн зоҳир гардидааст». ");
INSERT INTO tgk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Баъд он ду нафар низ ба ҷамъшудагон нақл карданд, ки дар аснои роҳ чӣ воқеа рӯй дод ва чӣ хел онҳо Исоро дар вақти нон шикастанаш шинохтанд. ");
INSERT INTO tgk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Вақте ки шогирдон дар ин бора нақл мекарданд, баногоҳ дар мобайнашон Исо пайдо шуда ба онҳо гуфт: «Худо шуморо баракат диҳад!» ");
INSERT INTO tgk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Онҳо ба тарсу ҳарос афтода, фикр мекарданд, ки арвоҳро мебинанд. ");
INSERT INTO tgk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ӯ аз онҳо пурсид: «Чаро ин қадар метарсед ва барои чӣ дар дилатон шубҳае пайдо шуд? ");
INSERT INTO tgk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ба дастонам ва пойҳоям нигоҳ кунед, ин Ман ҳастам. Ба Ман даст расонда бинед, ки Ман ҷисму устухон дорам, вале арвоҳ ин чизҳоро надорад». ");
INSERT INTO tgk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Инро гуфта, ба онҳо дастону пойҳои худро нишон дод. ");
INSERT INTO tgk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Онҳо аз хурсандӣ ҳеҷ бовар карда наметавонистанду хеле ҳайрон буданд. Он гоҳ Ӯ аз онҳо пурсид: «Шумо дар ин ҷо ягон чизи хӯрданӣ доред?» ");
INSERT INTO tgk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Онҳо ба Исо як бурда моҳии пухтагӣ доданд. ");
INSERT INTO tgk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Вай моҳиро гирифта, дар пеши назари онҳо хӯрд. ");
INSERT INTO tgk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Баъд ба онҳо гуфт: «Суханҳоеро, ки ҳанӯз дар вақти бо шумо буданам ба шумо мегуфтам, чунин маъно доранд: ҳамаи он чизе, ки нисбати Ман дар шариати Мӯсо, гуфтаҳои пайғамбарон ва дар Забур навишта шудааст, бояд иҷро шавад». ");
INSERT INTO tgk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Он гоҳ Исо хиради онҳоро равшан сохт, то ки маънои навиштаҷотро фаҳмида тавонанд. ");
INSERT INTO tgk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Баъд ба онҳо гуфт: «Мувофиқи гуфтаҳои навиштаҷот Таъиншудаи Худо бояд азоб кашад ва дар рӯзи сеюм аз мурдагон зинда шавад. ");
INSERT INTO tgk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ба номи Ӯ аз Ерусалим сар карда ба ҳамаи халқҳо тавба ва бахшоиши гуноҳҳо эълон карда мешавад ");
INSERT INTO tgk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ва шумо шоҳидони ҳамаи ин воқеаҳо ҳастед. ");
INSERT INTO tgk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ман ба шумо чизи Падарам ваъдакардаро мефиристам. Инак, шумо то вақти аз осмон қувват гирифтанатон дар Ерусалим бимонед». ");
INSERT INTO tgk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Исо шогирдонро берун аз шаҳр бароварда, ҳамроҳашон то худи Байт-Ҳинӣ рафт ва дастонашро боло бардошта, онҳоро баракат дод. ");
INSERT INTO tgk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Вақте ки баракат медод, аз онҳо ҷудо шуда, ба осмон бурда шуд ");
INSERT INTO tgk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ва онҳо ба Ӯ саҷда намуда, бо шодии бепоён ба Ерусалим баргаштанд. ");
INSERT INTO tgk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Сипас, тамоми вақти худ дар ҳавлии Хонаи Худо монда, Худоро ҳамду сано мехонданд. ");
INSERT INTO tgk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Дар ибтидо Калом буд ва ин Калом бо Худо буд ва Калом Худо буд. ");
INSERT INTO tgk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Вай дар аввал бо Худо буд ");
INSERT INTO tgk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ва ҳама чиз ба воситаи Ӯ офарида шуду бе Ӯ ҳеҷ чизе аз офариниш пайдо нашуд. ");
INSERT INTO tgk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Дар Ӯ ҳаёт буд ва ин ҳаёт барои одамон равшанӣ буд. ");
INSERT INTO tgk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Равшанӣ дар торикӣ медурахшад ва торикӣ онро фаро гирифта наметавонад. ");
INSERT INTO tgk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Марде бо номи Яҳё аз тарафи Худо фиристода мешавад, ");
INSERT INTO tgk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ки дар бораи равшанӣ шаҳодат диҳаду ҳама ба воситаи Ӯ имон оваранд. ");
INSERT INTO tgk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Яҳё худ равшанӣ набуд, вале барои он омад, ки дар бораи равшанӣ шаҳодат диҳад. ");
INSERT INTO tgk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Он равшании ҳақиқие, ки ба ҳамаи одамон медурахшад, ба ҷаҳон омаданӣ буд. ");
INSERT INTO tgk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Калом дар ҷаҳон буд ва мардуми ҷаҳон ба воситаи Ӯ офарида шуда бошанд ҳам, Ӯро нашинохтанд. ");
INSERT INTO tgk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Вай ба назди қавмаш омад, вале онҳо Ӯро қабул накарданд. ");
INSERT INTO tgk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Аммо ба касоне, ки Ӯро қабул карданд ва ба Ӯ имон оварданд, ҳуқуқ дод, ки фарзандони Худо шаванд. ");
INSERT INTO tgk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Онҳо на ба таври табиӣ ва на аз рӯи хоҳиши инсонӣ, балки аз Худо таваллуд ёфтаанд. ");
INSERT INTO tgk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Инак, Калом инсон шуд ва дар миёни мо истиқомат дошт. Мо шӯҳрату ҷалоли Ӯро дидем, ки мисли ҷалоли фарзанди ягонаи Падар пур аз марҳамату ростӣ буд. ");
INSERT INTO tgk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Яҳё дар бораи Ӯ шаҳодат доду бо овози баланд гуфт: «Ман Ӯро дар назар дошта ба шумо гуфта будам, ки баъд аз ман каси аз ман бузургтаре меояд, чунки Вай пеш аз ман вуҷуд дошт». ");
INSERT INTO tgk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Аз фаровонии файзи Ӯ ҳамаи мо баракат аз паси баракат ёфтаем. ");
INSERT INTO tgk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Худо шариатро ба воситаи Мӯсо додааст, вале файзу ростӣ ба воситаи Исои Масеҳ омад. ");
INSERT INTO tgk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Худоро ҳеҷ гоҳ касе надидааст. Ӯро фақат Писари яккаву ягона, ки ҳамеша бо Падар аст, барои мо ошкор кардааст. ");
INSERT INTO tgk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Вақте роҳбарони яҳудӣ аз Ерусалим ба назди Яҳё чанд нафар рӯҳониён ва левизодагонро фиристоданд, то аз ӯ кӣ буданашро бипурсанд, Яҳё аз ҷавоб рӯ нагардонду ошкоро эълон карда, чунин шаҳодат дод: «Ман Масеҳ, яъне Таъиншудаи Худо нестам». ");
INSERT INTO tgk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Онҳо боз пурсиданд: «Пас, шумо кистед? Оё Илёс пайғамбаред?» «Не», — ҷавоб дод ӯ. «Ё ҳамон пайғамбаред, ки мунтазираш ҳастем?» «Не», — гуфт ӯ. ");
INSERT INTO tgk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Онҳо пурсиши худро давом доданд: «Охир, шумо кистед? Мо бояд ба касоне, ки моро фиристодаанд, ҷавоб диҳем. Шумо дар бораи худ чӣ мегӯед?» ");
INSERT INTO tgk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Яҳё бо суханоне, ки Ишаъё пайғамбар гуфта буд, ҷавоб дод: «Ман касе ҳастам, ки дар биёбон фарёд зада мегӯяд: „Барои Худованд роҳро рост намоед!“». ");
INSERT INTO tgk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Аз тарафи фарисиён низ фиристодашудагоне буданд, ");
INSERT INTO tgk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ки аз ӯ пурсиданд: «Модоме ки шумо на Таъиншудаи Худо, на Илёс ва на ҳамон пайғамбаре ҳастед, ки дар мунтазираш ҳастем, пас чаро мардумро таъмид медиҳед?» ");
INSERT INTO tgk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","«Ман бо об таъмид медиҳам, — ҷавоб дод Яҳё. — Вале дар байни шумо шахсе ҳаст, ки баъд аз ман меояд ва ман ҳатто лоиқи он нестам, ки банди пойафзолашро кушоям. Шумо Ӯро намешиносед». ");
INSERT INTO tgk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ҳамаи ин воқеа дар Байт-Ҳинӣ, дар соҳили дигари дарёи Урдун ба амал омад, ки Яҳё дар он ҷо мардумро таъмид медод. ");
INSERT INTO tgk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Рӯзи дигар Яҳё ба наздаш омада истодани Исоро дида, гуфт: «Ана ин аст Барраи Худо, ки гуноҳи ҷаҳонро мебардорад! ");
INSERT INTO tgk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ман дар бораи Ӯ гуфта будам, ки аз паси ман касе меояд, ки аз ман бузургтар аст, зеро пеш аз ман вуҷуд дошт. ");
INSERT INTO tgk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Худи ман Ӯро намешинохтам, вале барои ҳамин омада, бо об таъмид додам, ки Ӯ барои мардуми Исроил маълум гардад». ");
INSERT INTO tgk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Баъд шаҳодат дода гуфт: «Ман дидам, ки Рӯҳи Муқаддас монанди кабӯтар аз осмон фаромада, бар Ӯ қарор гирифт. ");
INSERT INTO tgk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Худи ман Ӯро намешинохтам, вале Худо, ки маро барои бо об таъмид додан фиристод, ба ман гуфта буд: „Бар касе бинӣ, ки Рӯҳ бар Ӯ фаромада қарор мегирад, бидон, ки Вай ҳамон касест, ки бо Рӯҳи Муқаддас таъмид медиҳад“. ");
INSERT INTO tgk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ман инро дидам ва шаҳодат медиҳам, ки Ӯ Писари Худост». ");
INSERT INTO tgk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Рӯзи дигар Яҳё бо ду нафар шогирди худ боз дар ҳамон ҷо меистод ");
INSERT INTO tgk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ва Исои аз роҳ гузашта истодаро дида, гуфт: «Ана Ӯ Барраи Худо аст!» ");
INSERT INTO tgk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Он ду шогирд суханонашро шунида, аз паси Исо равона шуданд. ");
INSERT INTO tgk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Вақте Исо ба ақибаш нигоҳ карда дид, ки онҳо аз паси Ӯ меоянд, ба онҳо гуфт: «Шумо чиро мекобед?» Онҳо дар ҷавоб пурсиданд: «Раббӣ! Шумо дар куҷо зиндагӣ мекунед? (Маънои калимаи „Раббӣ“ устод аст)». ");
INSERT INTO tgk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ӯ гуфт: «Рафтем, мебинед». Вақте ки онҳо ҳамроҳаш рафта, ҷои истиқомати Ӯро диданд, соат қариби чори бегоҳ буд ва онҳо ҳамон рӯз бо Ӯ монданд. ");
INSERT INTO tgk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Яке аз он ду нафар, ки суханони Яҳёро шунида, аз паси Исо равона шуд, Андриёс, бародари Шимъӯни Петрус буд. ");
INSERT INTO tgk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ӯ аввал бародари худ Шимъӯнро ёфта ба ӯ гуфт: «Мо Масеҳро ёфтем» (Маънои калимаи «Масеҳ» Таъиншудаи Худо аст). ");
INSERT INTO tgk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Андриёс Шимъӯни Петрусро ба назди Исо овард. Исо бо диққат ба ӯ нигоҳ карда гуфт: «Ту Шимъӯн, писари Юҳанно ҳастӣ. Аммо аз ин баъд Кифо номида мешавӣ» (Калимаи Петрус бо юнонӣ ва Кифо бо арамеӣ — маънои ҳардуяш ҳам «санг» аст). ");
INSERT INTO tgk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Рӯзи дигар Исо қарор дод, ки ба Ҷалил биравад. Ӯ Филиппусро ёфта, гуфт, ки аз пасаш биёяд. ");
INSERT INTO tgk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Филиппус ҳам монанди Андриёс ва Петрус яке аз сокинони Байт-Сайдо буд. ");
INSERT INTO tgk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Филиппус, дар навбати худ, Натаноилро ёфта, ба ӯ гуфт: «Мо он касеро ёфтем, ки дар борааш Мӯсо дар шариат ва пайғамбарон дар гуфтаҳои худ навишта буданд! Ин Исои писари Юсуф, аз аҳли Носира аст». ");
INSERT INTO tgk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","«Аз Носира? Магар аз Носира чизи хубе баромада метавонад?» — гуфт Натаноил. Филиппус ҷавоб дод: «Рафтем ва худат мебинӣ». ");
INSERT INTO tgk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Исо Натаноили ба наздаш омада истодаро дида, дар бораи ӯ гуфт: «Ана ин исроилии ҳақиқист, ки дар дил макре надорад». ");
INSERT INTO tgk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","«Ту маро аз куҷо мешиносӣ?» — пурсид Натаноил. Исо ба ӯ ҷавоб дод: «Ҳанӯз, пеш аз он ки Филиппус туро фарёд кунад, Ман туро дар зери дарахти анҷир дидам». ");
INSERT INTO tgk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","«Устод, Ту Писари Худо ва Подшоҳи Исроил ҳастӣ!» — гуфт Натаноил. ");
INSERT INTO tgk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Исо ҷавоб дод: «Магар ту барои он имон овардӣ, ки „туро дар зери дарахти анҷир дида будам“ гуфтам? Ту корҳои аз ин ҳам бузургтарро мебинӣ. ");
INSERT INTO tgk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ба шумо рост мегӯям, ки баъд аз ин шумо осмонро кушода ва ба пеши Фарзанди Инсон фаромадану боло баромадани фариштагони Худоро хоҳед дид». ");
INSERT INTO tgk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Рӯзи сеюм дар шаҳри Қанои Ҷалил тӯи арӯсӣ буд ва модари Исо дар он ҷо иштирок дошт. ");
INSERT INTO tgk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Исо низ бо шогирдони худ ба тӯй даъват шуда буд. ");
INSERT INTO tgk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Вақте ки шароб тамом шуд, модари Исо ба Вай гуфт: «Инҳо шароб надоранд». ");
INSERT INTO tgk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","«Ин ба мо чӣ дахл дорад, модар! — ҷавоб дод ба ӯ Исо. — Вақту соати Ман ҳанӯз нарасидааст». ");
INSERT INTO tgk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Модари Ӯ ба хизматгорон гуфт: «Ҳар чӣ Вай ба шумо бигӯяд, бикунед». ");
INSERT INTO tgk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Дар он ҷо шаш кӯзаи сангин барои об буд, ки аз рӯи урфу одати яҳудиён онро барои расму таомули покшавӣ истифода мебурданд. Ҳар кадоми онҳо аз ҳафтод то яксаду даҳ литр ғунҷоиш дошт. ");
INSERT INTO tgk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Исо ба хизматгорон гуфт: «Кӯзаҳоро аз об пур кунед». Хизматгорон онҳоро лабрез карданд. ");
INSERT INTO tgk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","«Акнун аз он гирифта, ба роҳбари тӯй баред», — гуфт ба онҳо Исо. Онҳо бурданд. ");
INSERT INTO tgk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Роҳбари тӯй аз куҷо будани шаробро намедонист, фақат хизматгороне, ки аз кӯза об гирифтанд, аз ин огоҳ буданд. Роҳбари тӯй оби ба шароб табдилшударо чашида, домодро ба назди худ даъват карду ");
INSERT INTO tgk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ба ӯ гуфт: «Ҳар кас аввал шароби хушсифатро оварда мегузораду баъд, вақте ки меҳмонон бисёр нӯшиданд, шароби пастсифатро меорад, аммо ту шароби хушсифатро то ҳол нигоҳ доштаӣ». ");
INSERT INTO tgk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ҳамин тавр Исо дар Қанои Ҷалил нишонаи аввалини шӯҳрату ҷалоли худро зоҳир кард ва шогирдонаш ба Ӯ имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Баъд аз он Исо ба шаҳри Кафарнаҳум рафт. Модари Исо, бародарон ва шогирдонаш ҳам ҳамроҳи Ӯ буданд. Онҳо дар он ҷо якчанд рӯз монданд. ");
INSERT INTO tgk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Рӯзи иди Балогардони яҳудиён наздик омад ва Исо ба Ерусалим рафт. ");
INSERT INTO tgk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ӯ дар Хонаи Худо шахсонеро дид, ки бо фурӯши барзагов, гӯсфанд ва кабӯтар машғул буданд. Пуливазкунандагон низ дар сари мизҳои худ нишаста буданд. ");
INSERT INTO tgk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Исо аз таноб қамчин сохта, ҳамаи онҳоро бо барзагову гӯсфандонашон аз Хонаи Худо берун ронду мизҳои пуливазкунандагонро чаппа ва пулҳояшонро пароканда кард. ");
INSERT INTO tgk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ба кабӯтарфурӯшон бошад, гуфт: «Инҳоро аз ин ҷо бардошта дур кунед! Хонаи Падари Маро ба тиҷоратхона табдил надиҳед!» ");
INSERT INTO tgk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Шогирдони Ӯ ба ёд оварданд, ки дар навиштаҷот чунин гуфта шудааст: «Оташи ҳавасмандӣ ба Хонаи Ту дар дилам аланга мезанад». ");
INSERT INTO tgk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Он гоҳ роҳбарони яҳудӣ аз Ӯ пурсиданд: «Бо кадом нишона ҳақ будани ин рафторатро исбот мекунӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Исо дар ҷавоби онҳо гуфт: «Ин Хонаи Худоро вайрон кунед ва Ман онро дар муддати се рӯз аз нав барпо мекунам». ");
INSERT INTO tgk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","«Ин Хонаи Худо дар давоми чилу шаш сол сохта шуда буд. Ту бошӣ, онро дар муддати се рӯз аз нав барпо кардан мехоҳӣ?!» — гуфтанд онҳо. ");
INSERT INTO tgk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Аммо Ӯ «Хонаи Худо» гуфта бадани худро дар назар дошт. ");
INSERT INTO tgk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Аз ин рӯ, вақте ки Ӯ аз мурдагон зинда шуд, шогирдонаш ин суханони Ӯро ба хотир оварданд ва ба навиштаҷоту гуфтаҳои Исо имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Дар он рӯзҳои иди Балогардон, ки Исо дар Ерусалим буд, мардуми бисёре мӯъҷизаҳои Ӯро дида ба Ӯ имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Аммо худи Исо ба ҳеҷ кас дилашро накушод, чунки аз дили ҳамаи онҳо бохабар буд. ");
INSERT INTO tgk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Бинобар ин Ӯ мӯҳтоҷи он набуд, ки касе ба Ӯ дар бораи одамон шоҳидӣ диҳад. Ӯ худ медонист, ки дар дили инсон чӣ ҳаст. ");
INSERT INTO tgk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Дар байни роҳбарони қавми яҳудӣ аз фирқаи фарисиён Ниқодимус ном марде буд. ");
INSERT INTO tgk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ӯ шабона назди Исо омада гуфт: «Устод, мо медонем, ки Шумо аз тарафи Худо фиристодашуда ҳастед. Чунки, агар Худо бо касе набошад, ӯ чунин мӯъҷизаҳоеро, ки Шумо нишон додаед, ба амал оварда наметавонад». ");
INSERT INTO tgk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Исо дар ҷавоб ба ӯ гуфт: «Ба ту рост мегӯям, то касе аз нав таваллуд наёбад, ҳаргиз подшоҳии Худоро дида наметавонад». ");
INSERT INTO tgk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","«Чӣ тавр одами солхӯрда аз нав таваллуд ёфта метавонад? — пурсид аз Ӯ Ниқодимус. — Магар ӯ метавонад ба шиками модараш баргашта, дубора таваллуд шавад?» ");
INSERT INTO tgk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Исо ҷавоб дод: «Ба ту рост мегӯям, агар касе аз об ва Рӯҳ таваллуд нашавад, ба подшоҳии Худо дохил шуда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Он чӣ аз ҷисм таваллуд мешавад, ҷисм аст ва он чӣ аз Рӯҳ таваллуд мешавад, рӯҳ аст. ");
INSERT INTO tgk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Аз он ки ба ту „Шумо бояд аз нав таваллуд ёбед“ гуфтам ҳайрон нашав. ");
INSERT INTO tgk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Бод ҳар ҷо ки хоҳад, мевазад. Ту садои онро мешунавӣ, аммо намедонӣ, ки аз куҷо меояд ва ба куҷо меравад. Бо ҳар касе, ки аз Рӯҳ таваллуд меёбад, ана ҳамин тавр мешавад». ");
INSERT INTO tgk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ниқодимус пурсид: «Ин чӣ хел мешавад?» ");
INSERT INTO tgk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Исо дар ҷавоби ӯ гуфт: «Ту устоди мардуми Исроил ҳастӣ ва магар ин чизҳоро намедонӣ? ");
INSERT INTO tgk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ба ту рост мегӯям, Ман чизи медонистагиамро мегӯям ва дар бораи чизи дидагиам шоҳидӣ медиҳам, аммо шумо шаҳодати Маро қабул намекунед. ");
INSERT INTO tgk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Агар шумо ба чизҳои заминие, ки дар бораашон ба шумо гуфтам, бовар накунед, пас, вақте ки дар бораи чизҳои осмонӣ мегӯям, ба Ман чӣ тавр бовар мекунед? ");
INSERT INTO tgk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ғайр аз Фарзанди Инсон, ки аз осмон фаромадааст, ҳеҷ каси дигар ба осмон набаромадааст. ");
INSERT INTO tgk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Чӣ тавре ки Мӯсо дар биёбон морро боло бардошта буд, ҳамон тавр Фарзанди Инсон ҳам бояд боло бардошта шавад, ");
INSERT INTO tgk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","то ҳар касе, ки ба Ӯ имон меоварад, ҳаёти абадӣ ёбад. ");
INSERT INTO tgk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Зеро Худо ҷаҳонро чунон дӯст дошт, ки Писари ягонаи худро дод, то ҳар кӣ ба Ӯ имон оварад, намирад, балки ҳаёти абадӣ дошта бошад. ");
INSERT INTO tgk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Зеро Худо Писарро на барои ҳукм кардани ҷаҳон фиристод, балки барои он, ки ҷаҳон ба воситаи Ӯ наҷот ёбад. ");
INSERT INTO tgk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ҳар кӣ ба Ӯ имон оварад, ҳукм карда намешавад, аммо ҳар кӣ имон наоварад, аллакай ҳукм карда шудааст, чунки ба номи Писари ягонаи Худо имон наовардааст. ");
INSERT INTO tgk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ана ҳукм аз чӣ иборат аст: равшанӣ ба ҷаҳон омад, вале мардум торикиро аз рӯшноӣ зиёдтар дӯст доштанд, чунки корҳои онҳо бад аст. ");
INSERT INTO tgk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ҳар касе, ки кори бад мекунад, аз равшанӣ нафрат дорад ва барои он ки корҳои бади ӯ ошкор нашаванд, ба сӯи рӯшноӣ намеояд. ");
INSERT INTO tgk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Аммо ҳар касе ки кори дуруст мекунад, ба сӯи рӯшноӣ меояд, то корҳои бо ёрии Худо кардааш ошкор шаванд». ");
INSERT INTO tgk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Баъд аз он Исо бо шогирдони худ ба сарзамини Яҳудия рафта, ҳамроҳи онҳо дар он ҷо монда, мардумро таъмид дод. ");
INSERT INTO tgk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Яҳё бошад, ин вақт дар Энони наздики Солим, ки дар он ҷо об фаровон буд, ба таъмид додан машғул буд. Мардум ба назди ӯ меомаданду таъмид мегирифтанд. ");
INSERT INTO tgk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Он вақт Яҳёро ҳанӯз ба зиндон наандохта буданд. ");
INSERT INTO tgk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Боре дар байни шогирдони Яҳё ва як нафар аз яҳудиён дар бораи расму таомули покшавӣ баҳс барпо шуд. ");
INSERT INTO tgk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Онҳо ба назди Яҳё омада, ба ӯ гуфтанд: «Устод, он касе, ки дар соҳили шарқии Урдун бо шумо буд ва шумо дар борааш шаҳодат дода будед, Ӯ ҳам таъмид дода истодааст ва ҳама пеши Ӯ мераванд!» ");
INSERT INTO tgk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Яҳё ҷавоб дод: «Инсон фақат он чизро дошта метавонад, ки аз осмон ба ӯ бахшида шудааст. ");
INSERT INTO tgk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Шумо худатон тасдиқ карда метавонед, ки „Ман Масеҳ, яъне Таъиншудаи Худо нестам“ гуфта будам, аммо пеш аз Ӯ фиристода шудаам. ");
INSERT INTO tgk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Домод соҳиби арӯс аст ва дӯсти домод бошад, дар паҳлӯи ӯ истода, овози домодро шунида хурсанд мешавад. Ҳамин тавр шодии ман пурра шуд. ");
INSERT INTO tgk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ӯ бояд боз ҳам бузургтар шавад, аммо ман боз ҳам хурдтар. ");
INSERT INTO tgk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Касе ки аз боло меояд, аз ҳама бузургтар аст. Касе ки аз замин аст, худ заминист ва чун заминӣ сухан мегӯяд. Аммо, касе ки аз осмон меояд, аз ҳама болотар аст. ");
INSERT INTO tgk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ӯ дар бораи он чӣ худ дидаасту шунидааст, шоҳидӣ медиҳад, аммо шоҳидии Ӯро ҳеҷ кас қабул намекунад. ");
INSERT INTO tgk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Вале ҳар кас ки шоҳидии Ӯро қабул мекунад, бо ин тасдиқ мекунад, ки Худо ҳамеша ҳақ аст. ");
INSERT INTO tgk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Фиристодашудаи Худо суханони Худоро мегӯяд, чунки Худо Рӯҳашро бе меъёр мебахшад. ");
INSERT INTO tgk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Падар Писарро дӯст медорад ва ҳама чизро ба дасти Ӯ супоридааст. ");
INSERT INTO tgk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ҳар кӣ ба Писар имон меоварад, соҳиби ҳаёти абадӣ мешавад, аммо ҳар кӣ ба Писар итоат намекунад, ҳеҷ гоҳ ҳаёт нахоҳад дид ва гирифтори ғазаби Худо мегардад». ");
INSERT INTO tgk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Вақте Исо фаҳмид, ки ба гӯши фарисиён хабар расидааст, ки Ӯ аз Яҳё бештар шогирд дорад ва бештар мардумро таъмид медиҳад, ");
INSERT INTO tgk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ҳол он ки мардумро шогирдонаш таъмид медоданд, ");
INSERT INTO tgk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ӯ Яҳудияро тарк карда, боз ба сӯи Ҷалил раҳсипор шуд. ");
INSERT INTO tgk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Роҳи Ӯ аз вилояти Сомария мегузашт. ");
INSERT INTO tgk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Инак, Исо ба Суҳор ном шаҳри Сомария омада расид, ки он дар наздикии заминест, ки Ёқуб ба писари худ Юсуф дода буд. ");
INSERT INTO tgk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Дар он ҷо чоҳи Ёқуб буд. Исо аз сафар монда шуда, барои дам гирифтан дар канори чоҳ нишаст. Вақт қариби нисфирӯзӣ буд. ");
INSERT INTO tgk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Шогирдони Ӯ барои харидани хӯрокворӣ ба шаҳр рафтанд. Ҳамин вақт як зани сомарӣ барои об ба сари чоҳ омад. Исо ба зан гуфт: «Барои нӯшиданам об деҳ». ");
INSERT INTO tgk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","«Чӣ тавр Шумо, ки яҳудӣ ҳастед, аз мани сомарӣ об мепурсед?» — гуфт ба Ӯ зани сомарӣ. (Гап дар сари он аст, ки яҳудиён бо сомариён рафтуомад надоранд). ");
INSERT INTO tgk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Исо ҷавоб дод: «Агар ту медонистӣ, ки Худованд чӣ чизро ато мекунад ва касе ки ба ту „Барои нӯшиданам об деҳ“ мегӯяд, кист, ту худат аз Ӯ об хоҳиш мекардӣ ва Ӯ ба ту оби ҳаёт медод». ");
INSERT INTO tgk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Зан ба Ӯ мегӯяд: «Хоҷаам, Шумо сатил надоред, чоҳ бошад, чуқур аст. Пас, аз куҷо оби ҳаёт мегиред? ");
INSERT INTO tgk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Магар Шумо аз аҷдоди мо Ёқуб, ки ин чоҳро ба мо дод ва аз он худаш, писаронаш ва чорвояш об менӯшиданд, бузургтар ҳастед?» ");
INSERT INTO tgk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Исо ҷавоб дод: «Ҳар касе ки аз ин об нӯшад, боз ташна хоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Аммо ҳар кӣ аз обе, ки Ман ба ӯ медиҳам, бинӯшад, ҳеҷ гоҳ ташна нахоҳад шуд. Обе, ки Ман ба ӯ медиҳам, аз даруни ӯ мисли ҷорӣ шудани оби ҳаёти абадӣ мешавад». ");
INSERT INTO tgk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Зан ба Ӯ гуфт: «Хоҷаам, ба ман аз ин об диҳед, ки дигар ташна нашавам ва барои об ба ин чоҳ наоям!» ");
INSERT INTO tgk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Исо ба ӯ гуфт: «Рафта, шавҳаратро ҷеғ зада биё». ");
INSERT INTO tgk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","«Ман шавҳар надорам», — ҷавоб дод зан. Исо ба ӯ гуфт: «Рост гуфтӣ, ки шавҳар надорӣ. ");
INSERT INTO tgk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ту панҷ шавҳар доштӣ ва он марде, ки бо ӯ ҳоло зиндагӣ мекунӣ, шавҳари ту нест. Ту рост гуфтӣ». ");
INSERT INTO tgk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Зан ба Ӯ гуфт: «Хоҷаам, мебинам, ки Шумо пайғамбар ҳастед. ");
INSERT INTO tgk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Аҷдодони мо дар сари ин кӯҳ ибодат мекарданд, аммо шумо, яҳудиён мегӯед, ки одамон бояд дар Ерусалим ибодат кунанд». ");
INSERT INTO tgk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Исо ба ӯ дар ҷавоб гуфт: «Эй зан, ба Ман бовар кун, ки вақту соате фаро мерасад, ки ба Падари осмонӣ на дар сари ин кӯҳ ва на дар Ерусалим саҷда хоҳед кард. ");
INSERT INTO tgk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Шумо, сомариён намедонед, ки ба чӣ саҷда мекунед, аммо мо медонем, ки ба кӣ саҷда мекунем, зеро наҷот ба воситаи яҳудиён меояд. ");
INSERT INTO tgk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Вале вақту соате меояд ва аллакай фаро расидааст, ки саҷдакунандагони ҳақиқӣ ба Падар дар рӯҳ ва ростӣ саҷда мекунанд, зеро Падар барои худ чунин саҷдакунандагонро меҷӯяд! ");
INSERT INTO tgk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Худо рӯҳ аст ва онҳое, ки ба Ӯ саҷда мекунанд, бояд дар рӯҳ ва ростӣ саҷда кунанд». ");
INSERT INTO tgk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Зан ба Ӯ гуфт: «Медонам, ки Таъиншудаи Худо бояд биёяд. Вақте ки Ӯ меояд, ҳама чизро ба мо баён мекунад». ");
INSERT INTO tgk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","«Он кас Манам, ки бо ту сӯҳбат мекунам», — ҷавоб дод Исо. ");
INSERT INTO tgk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ҳамин вақт шогирдони Исо аз шаҳр баргашта, ҳайрон монданд, ки Исо бо зане сӯҳбат мекунад. Лекин касе напурсид, ки Исо чӣ мехоҳад ё чаро бо он зан сӯҳбат мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Зан кӯзаи худро монду ба шаҳр рафта, ба мардум гуфт: ");
INSERT INTO tgk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Рафтем, шахсеро мебинед, ки ҳар кори дар зиндагӣ кардаамро ба ман як ба як гуфт. Шояд Ӯ Таъиншудаи Худо бошад?» ");
INSERT INTO tgk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Он гоҳ мардум аз шаҳр баромада ба назди Исо омаданд. ");
INSERT INTO tgk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Дар ин миён шогирдон аз Исо хоҳиш карда гуфтанд: «Устод, ягон чиз хӯред!» ");
INSERT INTO tgk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Исо ҷавоб дода гуфт: «Ман хӯроке дорам, ки шумо аз он бехабаред». ");
INSERT INTO tgk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Шогирдон боз ба ҳамдигар гуфтанд: «Шояд касе ба Ӯ хӯрок оварда бошад?» ");
INSERT INTO tgk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Исо ба онҳо гуфт: «Хӯроки Ман иҷро кардани хости Фиристандаам ва ба анҷом расондани корҳои ӯст. ");
INSERT INTO tgk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Магар шумо намегӯед, ки „Баъд аз чор моҳи дигар мавсими дарав фаро мерасад?“ Аммо Ман ба шумо мегӯям, ки чашмонатонро кушода, ба киштзор нигоҳ кунед, ки он чӣ гуна пухта расида, барои дарав тайёр шудааст! ");
INSERT INTO tgk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Даравгар ҳам музди худро мегирад ва ҳам барои ҳаёти абадӣ ҳосил ҷамъ мекунад, то ки ҳам коранда ва ҳам даравгар якҷоя хурсанд шаванд. ");
INSERT INTO tgk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ин ҷо чунин сухан бамаврид аст: „Яке мекораду дигаре медаравад“. ");
INSERT INTO tgk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ман шуморо барои даравидани ҳосиле фиристодам, ки шумо барои он заҳмат накашидаед, дигарон заҳмат кашидаанд, аммо шумо ба маҳсули меҳнати онҳо шарик шудаед». ");
INSERT INTO tgk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Мардуми зиёде аз сомариёни ин шаҳр ба туфайли суханони он зан, ки «ҳар кори дар зиндагӣ кардаамро ба ман як ба як баён кард» гуфта буд, ба Исо имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Вақте ки сомариён ба назди Исо омада, аз Ӯ хоҳиш карданд, ки ҳамроҳи онҳо бимонад, Ӯ ду рӯз дар он ҷо монд. ");
INSERT INTO tgk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Он гоҳ шумораи зиёдтари мардум ба Исо аз рӯи суханони худи Ӯ имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Онҳо ба он зан гуфтанд: «Акнун мо на аз барои суханони ту имон меоварем, балки худамон суханҳояшро шунида фаҳмидем, ки Вай ҳақиқатан Наҷотдиҳандаи ҷаҳон аст». ");
INSERT INTO tgk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Баъд аз ду рӯз Исо аз он ҷо баромада, ба Ҷалил рафт. ");
INSERT INTO tgk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ӯ худ шоҳидӣ медод, ки пайғамбар дар диёри худ қадр надорад. ");
INSERT INTO tgk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Аммо, вақте ки Ӯ ба Ҷалил омад, мардуми он ҷо Ӯро қабул карданд, чунки онҳо ҳангоми ҷашни ид дар Ерусалим буданд ва ҳамаи корҳоеро, ки Исо дар он ҷо карда буд, дида буданд. ");
INSERT INTO tgk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Исо боз ба Қанои Ҷалил, ки пештар дар он ҷо обро ба шароб табдил дода буд, омад. Дар Кафарнаҳум писари як амалдори дарбор бемор буд. ");
INSERT INTO tgk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ин амалдор аз Яҳудия ба Ҷалил омадани Исоро шунида ба назди Ӯ омад ва илтиҷо кард, ки ба Кафарнаҳум омада, писари ӯро, ки дар дами марг буд, шифо бахшад. ");
INSERT INTO tgk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Исо ба ӯ ҷавоб дод: «Шумо то ягон нишона ва мӯъҷизае набинед, имон намеоваред». ");
INSERT INTO tgk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","«Хоҷаам! Писарам ҳанӯз намурда биёед!» — гуфт амалдори дарбор. ");
INSERT INTO tgk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Исо гуфт: «Ба хонаат баргард, писарат намемирад». Он мард ба суханони Исо имон оварда, сӯи хонааш раҳсипор шуд. ");
INSERT INTO tgk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ҳанӯз дар аснои роҳ хизматгоронаш ӯро пешвоз гирифта гуфтанд, ки писари ӯ зинда аст. ");
INSERT INTO tgk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Амалдор аз онҳо пурсид, ки дар кадом соат ҳолаш хуб шуд. Онҳо ҷавоб дода гуфтанд: «Табаш дирӯз соати яки рӯз паст шуд». ");
INSERT INTO tgk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Он гоҳ падари бача фаҳмид, ки ин ҳамон соат рӯй дод, ки Исо ба ӯ «Писарат намемирад» гуфта буд. Пас ӯ бо тамоми аҳли хонаводааш ба Исо имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ин мӯъҷизаи дуюме буд, ки Исо баъди аз Яҳудия ба Ҷалил баргаштанаш нишон дода буд. ");
INSERT INTO tgk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Баъд аз он айёми иди яҳудиён буду Исо ба Ерусалим рафт. ");
INSERT INTO tgk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Дар Ерусалим дар наздикии Дарвозаи Гӯсфандон ҳавзе буд, ки ба забони ибронӣ Байт-Ҳасдо номида мешуд. Он панҷ айвон дошту ");
INSERT INTO tgk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","шумораи зиёди беморон: кӯрҳо, лангҳо ва шалҳо дар он ҷо мехобиданд. ");
INSERT INTO tgk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Дар он ҷо инчунин марде мехобид, ки сию ҳашт сол боз гирифтори беморӣ буд. ");
INSERT INTO tgk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Вақте Исо дид, ки ӯ дар он ҷо хобидааст ва фаҳмид, ки вай муддати дароз бемор аст, аз вай пурсид: «Мехоҳӣ сиҳат шавӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","«Хоҷаам, — ҷавоб дод бемор, — ман касе надорам, ки ҳангоми ба талотум омадани об маро ба ҳавз андозад. То ман наздик меоям ки, каси дигар аллакай аз ман пештар ба ҳавз медарояд». ");
INSERT INTO tgk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Исо ба ӯ гуфт: «Бархез, ҷойгаҳатро бардошта роҳ гард!» ");
INSERT INTO tgk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Он мард фавран сиҳат шуда, ҷойгаҳи худро бардошта рафт. Он рӯз рӯзи истироҳат буд. ");
INSERT INTO tgk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Аз ин сабаб роҳбарони яҳудӣ ба марди шифоёфта гуфтанд: «Имрӯз рӯзи истироҳат аст, бинобар ин раво нест, ки ҷойгаҳатро бардошта барӣ!» ");
INSERT INTO tgk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","«Касе, ки маро шифо дод, ба ман „Ҷойгаҳатро бардошта роҳ гард“ гуфт», — ҷавоб дод ӯ. ");
INSERT INTO tgk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Онҳо аз ӯ пурсиданд: «Кадом одам ба ту „Ҷойгаҳатро бардошта роҳ гард“ гуфт?» ");
INSERT INTO tgk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Аммо марди шифоёфта намедонист, ки Вай кӣ буд, чунки Исо дар байни мардуми онҷобуда аз назар ғоиб шуд. ");
INSERT INTO tgk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Пас аз он Исо ӯро дар Хонаи Худо дида гуфт: «Гӯш кун, акнун ту шифо ёфтӣ. Дигар гуноҳ накун, то ба чизи бадтаре дучор нашавӣ». ");
INSERT INTO tgk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Он мард ба назди роҳбарони яҳудӣ рафта, гуфт, ки ӯро Исо шифо додааст. ");
INSERT INTO tgk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Азбаски Исо чунин корҳоро дар рӯзи истироҳат мекард, яҳудиён аз дунболи Ӯ афтоданд. ");
INSERT INTO tgk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Аммо Исо ба онҳо ҷавоб дода гуфт: «Падари Ман ҳамеша кор мекунад ва Ман низ ҳамеша кор мекунам». ");
INSERT INTO tgk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Бинобар ин дар роҳбарони яҳудӣ нияти куштани Исо боз зиёдтар шуд, чунки Ӯ на танҳо қоидаи рӯзи истироҳатро вайрон мекард, балки Худоро боз Падари худ номида, бо ҳамин худро бо Худо баробар мекард. ");
INSERT INTO tgk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Аммо Исо дар ҷавоб ба онҳо гуфт: «Ба шумо рост мегӯям, Писар бо ихтиёри худ ҳеҷ кореро карда наметавонад, фақат он чӣ мебинад, ки Падар мекунад, Писар низ мекунад. Ҳар чӣ Падар мекунад, ҳамонро Писар ҳам мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Азбаски Падар Писарро дӯст медорад, ҳар чиро ки худ мекунад, ба Ӯ низ нишон медиҳад. Вай ба Писар аз ин ҳам корҳои бузургтарро нишон медиҳад, ки ҳамаи шумо ба ҳайрат меафтед. ");
INSERT INTO tgk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ҳамон тавр ки Падар мурдагонро зинда мекунад ва ба онҳо ҳаёт мебахшад, ҳамчунин Писар, ба ҳар кӣ хоҳад, ҳаёт мебахшад. ");
INSERT INTO tgk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Зеро Падар ҳеҷ касро ҳукм намекунад, балки ҳукм карданро пурра ба Писар супоридааст, ");
INSERT INTO tgk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","то ҳама Писарро ҳамон тавр эҳтиром кунанд, ки Падарро эҳтиром мекунанд. Касе, ки Писарро эҳтиром намекунад, Падарро ҳам, ки фиристандаи ӯст, эҳтиром намекунад. ");
INSERT INTO tgk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ба шумо рост мегӯям, ҳар кӣ сухани Маро мешунавад ва ба фиристандаи Ман имон меоварад, соҳиби ҳаёти абадӣ мебошад. Ӯ ҳукм карда намешавад, балки аллакай аз марг ба ҳаёт гузаштааст. ");
INSERT INTO tgk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ба шумо рост мегӯям, вақту соате меояд ва аллакай фаро расидааст, ки мурдагон садои Писари Худоро мешунаванд ва ҳар касе, ки Ӯро бишнавад, зинда мешавад. ");
INSERT INTO tgk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Чунон ки Падар сарчашмаи ҳаёт аст, Писарро низ сарчашмаи ҳаёт кардааст. ");
INSERT INTO tgk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Инчунин Ӯ ба Писар қудрати ҳукм карданро додааст, зеро Писар Фарзанди Инсон аст. ");
INSERT INTO tgk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Аз ин дар ҳайрат намонед, чунки вақту соате фаро мерасад, ки ҳамаи мурдагон садои Ӯро шунида аз қабрҳояшон мебароянд. Онҳо, ки некӣ карда буданд, барои ҳаёт ва онҳое, ки бадӣ карда буданд, барои маҳкум шудан бармехезанд. ");
INSERT INTO tgk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ман наметавонам ба ихтиёри худ кореро иҷро кунам: Ман он чӣ бишнавам, ҳамон тавр ҳукм мекунам ва ҳукми Ман одилона аст, зеро Ман на хости худамро, балки хости фиристандаамро иҷро кардан мехоҳам. ");
INSERT INTO tgk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Агар Ман дар бораи худ шаҳодат диҳам, шаҳодати Ман эътибор надорад. ");
INSERT INTO tgk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Аммо Ман шоҳиди дигаре дорам ва медонам, ки шоҳидии ӯ дар бораи Ман ҳаққонист. ");
INSERT INTO tgk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Шумо одамони худро ба назди Яҳё фиристодед ва ӯ дар бораи ростӣ шаҳодат дод. ");
INSERT INTO tgk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Дар воқеъ, Ман мӯҳтоҷи шаҳодати инсон нестам, фақат ба хотири наҷоти шумо инро гуфтам. ");
INSERT INTO tgk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Яҳё монанди чароғи фурӯзон дурахшанда буд ва шумо хостед, ки муддате ҳам бошад, дар равшании ӯ хурсандӣ кунед. ");
INSERT INTO tgk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Вале Ман шаҳодати бузургтар аз он, ки Яҳё дода буд, дорам. Он корҳое, ки барои иҷро кардан Падар ба Ман супоридааст ва худи он корҳое, ки Ман ба ҷо меоварам, шоҳиди онанд, ки Маро Падар фиристодааст! ");
INSERT INTO tgk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ҳамин Падарам, ки Маро фиристодааст, дар бораи Ман шаҳодат медиҳад. Шумо тамоман на овозашро шунидаед ва на намуди Ӯро дидаед. ");
INSERT INTO tgk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Каломи Ӯ дар дилҳои шумо нест, зеро шумо ба каси фиристодааш имон намеоваред. ");
INSERT INTO tgk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Шумо навиштаҷотро меомӯзед ва фикр мекунед, ки дар он ҳаёти абадӣ меёбед. Вале он ҳам дар бораи Ман шаҳодат медиҳад. ");
INSERT INTO tgk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Бо вуҷуди ин шумо намехоҳед, ки ба пеши Ман оеду ба ҳаёт соҳиб шавед. ");
INSERT INTO tgk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ман ба таърифи инсон мӯҳтоҷ нестам. ");
INSERT INTO tgk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ман медонам, ки шумо дар дилҳоятон муҳаббати Худоро надоред! ");
INSERT INTO tgk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ман назди шумо аз номи Падари худ омадаам ва шумо Маро қабул намекунед, вале агар каси дигар ба назди шумо аз номи худ биёяд, шумо ӯро қабул мекунед. ");
INSERT INTO tgk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Агар шумо таърифи якдигарро маъқул донеду барои ҷустани таърифи Худои яккаву ягона кӯшиш накунед, чӣ тавр имон оварда метавонед?! ");
INSERT INTO tgk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Гумон накунед, ки Ман шуморо дар пеши Падар айбдор мекунам, айбдоркунандаи шумо Мӯсо аст, ки ба ӯ умед мебандед! ");
INSERT INTO tgk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Агар шумо ба Мӯсо имон медоштед, ба Ман ҳам имон меовардед, зеро ӯ дар бораи Ман навишта буд. ");
INSERT INTO tgk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Вале, агар шумо ба он чӣ, ки ӯ навиштааст, имон наоваред, чӣ тавр ба суханони Ман бовар мекунед?» ");
INSERT INTO tgk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Баъд аз ин Исо ба соҳили дигари кӯли Ҷалил, ки баҳри Табария низ номида мешавад, равона шуд. ");
INSERT INTO tgk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Аз паси Ӯ мардуми бисёре рафтанд, зеро онҳо мӯъҷизаҳои Ӯро дар шифо додани беморон диданд. ");
INSERT INTO tgk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Исо ба болои кӯҳ баромада, ҳамроҳи шогирдонаш дар ҳамон ҷо нишаст. ");
INSERT INTO tgk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Айёми ҷашнгирии иди Балогардони яҳудиён наздик омада буд. ");
INSERT INTO tgk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Исо ба атроф нигоҳ карду мардуми зиёди ба тарафаш омадаистодаро дида, ба Филиппус гуфт: «Барои сер кардани инҳо аз куҷо бояд нон харем?» ");
INSERT INTO tgk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ӯ хуб медонист, ки чӣ кор мекунад, аммо Филиппусро санҷиданӣ шуда ин суханонро гуфт. ");
INSERT INTO tgk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Филиппус дар ҷавоб гуфт: «Ба дусад динор нон харем ҳам, ба ҳар кас ақаллан яклуқмагӣ намерасад». ");
INSERT INTO tgk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Яке аз шогирдонаш, Андриёс, ки бародари Шимъӯни Петрус буд, ба Исо гуфт: ");
INSERT INTO tgk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Дар ин ҷо писарбачае ҳаст, ки панҷ нони ҷав ва ду моҳӣ дорад. Вале ба ин қадар мардуми зиёд вай чӣ мешавад?» ");
INSERT INTO tgk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","«Ба мардум гӯед, ки бишинанд», — гуфт Исо. Дар он ҷо сабзазор буд. Шумораи ҳамаи нишастагон қариб панҷ ҳазор мард буд. ");
INSERT INTO tgk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Исо нонро гирифта дуои шукрона хонду онро ба нишастагон тақсим карда дод. Баъд бо моҳиҳо ҳам чунин кард ва ба ҳама чӣ қадаре ки мехостанд, ҳамон қадар дод. ");
INSERT INTO tgk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Вақте мардум сер шуданд, Исо ба шогирдони худ гуфт: «Нонпораҳои боқимондаро ҷамъ кунед, ки ҳеҷ чиз исроф нашавад». ");
INSERT INTO tgk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Шогирдон нонпораҳои панҷ нони ҷавро, ки аз хӯрандаҳо боқӣ монда буд, ҷамъ намуда, дувоздаҳ сабадро пур карданд. ");
INSERT INTO tgk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Мардум мӯъҷизаи Исоро дида гуфтанд: «Ӯ ҳақиқатан ҳамон пайғамбарест, ки бояд ба ҷаҳон биёяд!» ");
INSERT INTO tgk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Исо фаҳмид, ки онҳо нияти омада, Ӯро дастгир ва ба зӯрӣ подшоҳ кардан доранд, аз ин рӯ, танҳо ба кӯҳ баромад. ");
INSERT INTO tgk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Вақти шаб шуд, шогирдони Исо ба лаби баҳр фаромаданд ");
INSERT INTO tgk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ва ба қаиқ савор шуда, ба соҳили дигари баҳр, ба сӯи Кафарнаҳум равона шуданд. Рӯз аллакай торик шуд, вале Исо ҳанӯз ба наздашон наомада буд. ");
INSERT INTO tgk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Аз сабаби вазидани шамоли сахт баҳр ба талотум омад. ");
INSERT INTO tgk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Вақте онҳо ба масофаи панҷ-шаш километр қаиқро ронда рафтанд, Исоро диданд, ки дар рӯи об қадамзанон ба қаиқ наздик мешавад. Онҳо тарсиданд. ");
INSERT INTO tgk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","«Натарсед, ин Манам!» — гуфт ба онҳо Исо. ");
INSERT INTO tgk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Онҳо мехостанд, ки Ӯро ба қаиқ гиранд, вале қаиқ ҳамон замон ба соҳиле, ки онҳо равона буданд, омада расид. ");
INSERT INTO tgk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Рӯзи дигар мардуме, ки дар соҳили дигари баҳр монда буданд, фаҳмиданд, ки шогирдони Исо ба ягона қаиқе, ки дар он ҷо буд, савор шуда рафтаанд. Онҳо боз дида буданд, ки Исо ҳангоми ба қаиқ савор шудани шогирдонаш ба онҳо ҳамроҳ нашуд ва онҳо бе Ӯ рафта буданд. ");
INSERT INTO tgk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Он вақт одамон аз Табария дар якчанд қаиқ ба наздикии маҳале омаданд, ки дар он ҷо пас аз дуои шукронаи Худованд нон хӯрда буданд. ");
INSERT INTO tgk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Вақте мардум диданд, ки дар он ҷо на Исо ҳасту на шогирдонаш, ба қаиқҳо савор шуда, ба ҷустуҷӯи Ӯ ба Кафарнаҳум рафтанд. ");
INSERT INTO tgk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Баъд Ӯро дар он тарафи баҳр ёфта, аз Ӯ пурсиданд: «Устод, Шумо кай ба ин ҷо омадед?» ");
INSERT INTO tgk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Исо дар ҷавоб ба онҳо гуфт: «Ба шумо рост мегӯям, ки шумо Маро на аз барои он ки мӯъҷизаҳоямро дидаед, ҷустуҷӯ мекунед, балки аз барои он ки то сер шудан нон хӯрдед! ");
INSERT INTO tgk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","На барои хӯроки нестшаванда, балки барои хӯроке, ки то ҳаёти абадӣ мемонад, меҳнат кунед. Ин хӯрокро Фарзанди Инсон ба шумо медиҳад, чунки Худо-Падар ба иҷрои ин кор ба Ӯ розигиашро додааст». ");
INSERT INTO tgk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Онҳо аз Вай пурсиданд: «Барои иҷро кардани талаби Худо мо чӣ бояд кунем?» ");
INSERT INTO tgk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Исо ба онҳо ҷавоб дод: «Талаби Худо ин аст, ки ба каси фиристодааш имон оваред». ");
INSERT INTO tgk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Онҳо пурсиданд: «Ту ба мо чӣ мӯъҷизае нишон медиҳӣ, ки мо онро дида ба Ту имон оварем? Ту чӣ кор мекунӣ? ");
INSERT INTO tgk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Аҷдодони мо дар биёбон нони манна хӯрданд. Чунон ки дар навиштаҷот гуфта шудааст, ки Ӯ барои хӯрдан ба онҳо аз осмон нон дод». ");
INSERT INTO tgk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Исо ба онҳо ҷавоб дод: «Ба шумо рост мегӯям, ки нонро аз осмон ба шумо Мӯсо надодааст, ин Падари Ман аст, ки ба шумо аз осмон нони ҳақиқӣ медиҳад. ");
INSERT INTO tgk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Зеро нони Худо он аст, ки аз осмон поён меояду ба ҷаҳон ҳаёт мебахшад». ");
INSERT INTO tgk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","«Хоҷаам, — гуфтанд онҳо, — ба мо ҳамеша чунин нон бидеҳ!» ");
INSERT INTO tgk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Исо ба онҳо гуфт: «Ман нони ҳаёт ҳастам. Ҳар касе ки назди Ман биёяд, гурусна нахоҳад монд ва ҳар касе ки ба Ман имон оварад, ҳаргиз ташна нахоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Аммо, чунон ки Ман ба шумо гуфта будам, шумо Маро дидед, вале бовар намекунед. ");
INSERT INTO tgk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ҳар касе ки ӯро Падар ба Ман ато кардааст, сӯи Ман хоҳад омад ва ҳар касе ки ба назди Ман биёяд, Ман ӯро берун нахоҳам ронд. ");
INSERT INTO tgk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Зеро Ман аз осмон на барои иҷро кардани иродаи худ, балки барои иҷро кардани иродаи фиристандаам фаромадаам. ");
INSERT INTO tgk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Иродаи фиристандаи Ман ин аст, ки аз он касоне, ки Ӯ ба Ман ато кардааст, ҳеҷ якеро аз даст надиҳам, балки дар рӯзи қиёмат онҳоро зинда гардонам. ");
INSERT INTO tgk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Зеро иродаи Падари Ман ин аст: ҳар кас ки Писарро бинаду ба Ӯ имон оварад, ҳаёти абадӣ ба даст оварад ва дар рӯзи қиёмат Ман ӯро зинда мекунам». ");
INSERT INTO tgk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Он гоҳ дар байни мардум барои он ғавғо бархост, ки Ӯ «Ман нонам, ки аз осмон фаромадаам» гуфт. ");
INSERT INTO tgk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Онҳо гуфтанд: «Магар ин ҳамон Исои писари Юсуф нест, ки ҳам падар ва ҳам модари Ӯро мешиносем? Акнун Ӯ чӣ тавр „Ман аз осмон фаромадаам“ гуфта метавонад?» ");
INSERT INTO tgk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","«Байни худ ғур-ғур накунед!» — дар ҷавоб гуфт ба онҳо Исо. ");
INSERT INTO tgk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","«То Падар, ки Маро фиристодааст, касеро ба Ман ҷалб накунонад, ҳеҷ кас назди Ман омада наметавонад ва ҷалбшударо дар рӯзи қиёмат Ман зинда хоҳам кард. ");
INSERT INTO tgk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Дар китоби пайғамбарон навишта шудааст: „Ҳамаи онҳо аз Худо таълим хоҳанд гирифт“. Ҳар касе ки Падарро шунида ва аз Ӯ таълим гирифта бошад, ба назди Ман меояд. ");
INSERT INTO tgk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ин маънои онро надорад, ки касе Падарро дидааст. Фақат касе, ки аз пеши Худо омадааст, Падарро дидааст. ");
INSERT INTO tgk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ба шумо рост мегӯям, он ки имон дорад, ҳаёти абадӣ ёфтааст. ");
INSERT INTO tgk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ман нони ҳаёт ҳастам. ");
INSERT INTO tgk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Аҷдодони шумо дар биёбон хӯроки маннаро хӯрданд, вале аз марг наҷот наёфтанд. ");
INSERT INTO tgk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Аммо ноне, ки аз осмон мефурояд, дигар хел аст: касе ки онро бихӯрад, намемирад. ");
INSERT INTO tgk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ман он нони ҳаётам, ки аз осмон фаромадааст. Ҳар кас ин нонро бихӯрад, ҳаёти абадӣ пайдо мекунад. Ноне, ки Ман медиҳам, бадани Ман аст, ки онро ба хотири зинда мондани ҷаҳон фидо мекунам». ");
INSERT INTO tgk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Пас аз ин дар байни мардум баҳси пуршиддат авҷ гирифт: «Ин шахс чӣ тавр бадани худро барои хӯрдани мо дода метавонад?!» ");
INSERT INTO tgk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Исо ба онҳо гуфт: «Ба шумо рост мегӯям, ки агар бадани Фарзанди Инсонро нахӯред ва хуни Ӯро нанӯшед, ҳаёт пайдо намекунед. ");
INSERT INTO tgk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ҳар кӣ бадани Маро бихӯрад ва хуни Маро бинӯшад, ҳаёти абадӣ меёбад ва Ман дар рӯзи қиёмат ӯро зинда хоҳам кард. ");
INSERT INTO tgk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Зеро бадани Ман хӯроки ҳақиқӣ ва хуни Ман нӯшокии ҳақиқист. ");
INSERT INTO tgk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ҳар кӣ бадани Маро бихӯрад ва хуни Маро бинӯшад, вай дар Ман зиндагӣ мекунад ва Ман дар ӯ. ");
INSERT INTO tgk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Чунон ки Маро Падар фиристод, ки Ӯ худ сарчашмаи ҳаёт аст ва Ман ба воситаи Ӯ зиндаам, ҳамчунин, касе ки Маро бихӯрад, ба воситаи Ман зиндагӣ мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ин аст ноне, ки аз осмон поён фаромад. Вай монанди он ноне нест, ки аҷдодони шумо хӯрданд, вале аз марг наҷот наёфтанд. Аммо ҳар кӣ ин нонро бихӯрад, то абад зинда хоҳад монд». ");
INSERT INTO tgk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ин суханонро Исо ҳангоми дар ибодатхонаи Кафарнаҳум таълим доданаш гуфт. ");
INSERT INTO tgk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Бисёре аз шогирдон суханони Ӯро шунида гуфтанд: «Ин таълимоти вазнин аст! Кӣ онро қабул карда метавонад?» ");
INSERT INTO tgk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Исо медонист, ки шогирдонаш аз суханонаш ғур-ғур карда истодаанд ва ба онҳо гуфт: «Магар ин шуморо аз роҳ мезанад? ");
INSERT INTO tgk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Пас, агар шумо ба ҷои аввалаи худ боло баромадани Фарзанди Инсонро медидед, чӣ кор мекардед? ");
INSERT INTO tgk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ҳаётро Рӯҳ мебахшад ва ҷисм ин корро карда наметавонад. Он суханоне, ки Ман ба шумо гуфтам, рӯҳ ва ҳаётанд. ");
INSERT INTO tgk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Аммо дар байни шумо шахсоне ҳам ҳастанд, ки имон намеоваранд». (Исо аз аввал медонист, ки ба Ӯ кӣ имон наовардааст ва кӣ дар ҳаққи Ӯ хиёнат мекунад). ");
INSERT INTO tgk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ӯ давом дода гуфт: «Аз ин рӯ ба шумо гуфтам, ки фақат он кас назди Ман омада метавонад, ки Падар ба ӯ ихтиёри омаданро дода бошад». ");
INSERT INTO tgk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Баъд аз ин бисёри шогирдонаш аз Ӯ рӯй гардонданду дигар ҳамроҳи Ӯ нарафтанд. ");
INSERT INTO tgk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Пас, Исо аз он дувоздаҳ шогирдаш пурсид: «Шояд шумо ҳам рафтанӣ ҳастед?» ");
INSERT INTO tgk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","«Эй Худованд, — ҷавоб дод ба Ӯ Шимъӯни Петрус, — мо ба назди кӣ меравем? Суханони ҳаёти абадӣ аз они туанд. ");
INSERT INTO tgk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Мо имон овардем ва фаҳмидем, ки Ту Шахси Муқаддаси Худо ҳастӣ». ");
INSERT INTO tgk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Исо ба онҳо ҷавоб дод: «Магар Ман худам дувоздаҳ шогирдро интихоб накардаам? Вале як нафар аз байни шумо шайтон аст!» ");
INSERT INTO tgk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ӯ инро дар бораи Яҳудои писари Шимъӯни Исқарют, яке аз дувоздаҳ шогирдонаш мегуфт, ки дар оянда ба Исо хиёнат кард. ");
INSERT INTO tgk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Баъд аз он Исо дар сарзамини Ҷалил мегашт. Ӯ намехост, ки дар Яҳудия бошад, чунки роҳбарони яҳудӣ хоҳони марги Ӯ буданд. ");
INSERT INTO tgk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Иди Хаймаҳои яҳудиён наздик омад ");
INSERT INTO tgk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ва бародарони Исо ба Ӯ гуфтанд: «Аз ин ҷо баромада, ба Яҳудия рав! Бигзор шогирдонат ҳам корҳои мекардагиатро дар он ҷо бубинанд. ");
INSERT INTO tgk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Зеро касе ки шӯҳрат пайдо кардан мехоҳад, корҳои худро дар пинҳонӣ намекунад. Ту, ки ин гуна корҳоро мекунӣ, худро ба ҷаҳон ошкор намо» ");
INSERT INTO tgk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Ҳатто бародаронаш ба Ӯ имон надоштанд). ");
INSERT INTO tgk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","«Вақту соати Ман ҳанӯз нарасидааст, — ҷавоб дод ба онҳо Исо, — барои шумо ҳар вақт хуб аст. ");
INSERT INTO tgk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ҷаҳон наметавонад аз шумо нафрат дошта бошад, вале Маро бад мебинад, чунки Ман бад будани корҳои онро шаҳодат медиҳам. ");
INSERT INTO tgk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Шумо ба ин ид равед, вале Ман намеравам, чунки вақти Ман ҳанӯз нарасидааст». ");
INSERT INTO tgk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Инро ба онҳо гуфта, Исо дар Ҷалил монд. ");
INSERT INTO tgk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Аммо, пас аз он ки бародаронаш ба ид рафтанд, Исо ҳам на ошкоро, балки пинҳонӣ ба он ҷо рафт. ");
INSERT INTO tgk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Дар вақти ид роҳбарони яҳудӣ Ӯро ҷустуҷӯ карданд. Онҳо «Ин одам дар куҷост?» гуфта мепурсиданд. ");
INSERT INTO tgk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Дар байни мардум низ дар хусуси Ӯ баҳси зиёде ба миён омад. «Вай одами хуб аст», — мегуфтанд баъзеҳо, дигарон эътироз карда «Не, Ӯ мардумро гумроҳ мекунад» мегуфтанд. ");
INSERT INTO tgk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Аммо ҳама аз роҳбарони яҳудиён тарсида, ошкоро дар бораи Ӯ сухане ҳам ба забон намегирифтанд. ");
INSERT INTO tgk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Дар миёни ҳафтаи ид Исо ба Хонаи Худо омада, ба таълим додан шурӯъ намуд. ");
INSERT INTO tgk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Роҳбарони яҳудӣ тааҷҷуб карда мегуфтанд: «Аз куҷо Вай ин қадар дониш дорад, дар сурате ки дар ҳеҷ ҷо таълим нагирифтааст?» ");
INSERT INTO tgk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Исо дар ҷавоби онҳо гуфт: «Таълимоти Ман аз худам нест, балки аз касест, ки Маро фиристодааст. ");
INSERT INTO tgk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Касе ки хости Худоро ба ҷо овардан мехоҳад, мефаҳмад, ки ин таълимот аз Худост ё Ман аз худ мегӯям. ");
INSERT INTO tgk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ҳар кӣ аз номи худ сухан мегӯяд, барои худ шӯҳрат меҷӯяд, вале касе ки барои фиристандаи худ шӯҳрат ба даст овардан мехоҳад, ростқавл аст ва дар дили ӯ фиребе нест. ");
INSERT INTO tgk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Магар Мӯсо ба шумо шариатро надодааст? Бо вуҷуди ин ҳеҷ кадоми шумо онро риоя намекунед! Чаро Маро куштан мехоҳед?» ");
INSERT INTO tgk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Мардум ҷавоб доданд: «Ту дев дорӣ! Кӣ Туро куштан мехоҳад?» ");
INSERT INTO tgk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Исо ба онҳо гуфт: «Ман танҳо як кор кардам ва шумо ҳама дар тааҷҷуб мондед. ");
INSERT INTO tgk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Мӯсо ба шумо анъанаи хатнаро фармуд (ин анъана на аз Мӯсо, балки аз аҷдодон мондааст) ва шумо писаронатонро ҳатто дар рӯзи истироҳат хатна мекунед. ");
INSERT INTO tgk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Агар шумо барои вайрон нашудани шариати Мӯсо дар рӯзи истироҳат писаратонро хатна мекарда бошед, пас чаро аз Ман хашмгин мешавед, ки дар рӯзи истироҳат инсонеро пурра шифо бахшидам? ");
INSERT INTO tgk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Аз рӯи намуди зоҳирӣ ҳукм накунед, балки аз рӯи адолат ҳукм кунед!» ");
INSERT INTO tgk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Баъзе аз сокинони Ерусалим гуфтанд: «Магар Ӯ ҳамон одам нест, ки Ӯро куштан мехоҳанд? ");
INSERT INTO tgk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Бинед, Ӯ рӯйирост таълим медиҳад ва касе ба Ӯ чизе намегӯяд. Наход ҳукуматдорон фаҳмида бошанд, ки Ӯ ҳақиқатан Таъиншудаи Худо аст? ");
INSERT INTO tgk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Мо бошем, аз куҷо будани ин одамро медонем. Аммо, вақте ки Таъиншудаи Худо меояд, аз куҷо будани Ӯро ҳеҷ кас намедонад». ");
INSERT INTO tgk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Он гоҳ Исо, ки дар Хонаи Худо машғули таълимдиҳӣ буд, хитоб карда гуфт: «Шумо Маро ва аз куҷо буданамро медонед-а? Ман аз номи худам наомадаам. Касе ки Маро фиристодааст, ҳақ аст. Шумо Ӯро намешиносед, вале ");
INSERT INTO tgk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ман Ӯро мешиносам, чунки Ман аз пеши Ӯ омадаам ва Ӯ Маро фиристодааст». ");
INSERT INTO tgk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Сипас онҳо хостанд Ӯро дастгир кунанд, вале аз сабаби он ки вақти Ӯ ҳанӯз нарасида буд, касе ба Ӯ даст нарасонд. ");
INSERT INTO tgk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Бо вуҷуди он, аз байни мардум бисёриҳо ба Ӯ имон оварда мегуфтанд: «Вақте ки Таъиншудаи Худо меояд, магар аз ин одам бештар мӯъҷиза нишон дода метавонад?» ");
INSERT INTO tgk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Фарисиён дар байни мардум пичир-пичиркунон дар бораи Исо гуфтани чунин чизҳоро шуниданд. Баъд онҳо ва сардорони рӯҳонӣ барои дастгир кардани Исо посбонони Хонаи Худоро фиристоданд. ");
INSERT INTO tgk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Он гоҳ Исо гуфт: «Боз каме вақт бо шумо мемонаму баъд ба назди фиристандаи худ бармегардам. ");
INSERT INTO tgk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Шумо Маро мекобед, аммо намеёбед. Ба он ҷое, ки Ман меравам, шумо омада наметавонед». ");
INSERT INTO tgk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Роҳбарони яҳудӣ ба якдигар гуфтанд: «Ӯ ба куҷо рафтан мехоҳад, ки мо Ӯро ёфта наметавонем? Оё Ӯ барои таълим додани ғайрияҳудиён ба шаҳрҳои онҳо рафтанист, ки мардуми мо низ он ҷо зиндагӣ мекунад? ");
INSERT INTO tgk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ӯ „Шумо Маро мекобед, аммо намеёбед“ ва „Ба он ҷое, ки Ман меравам, шумо омада наметавонед“ гуфта чиро дар назар дорад?» ");
INSERT INTO tgk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Дар рӯзи охирин ва муҳимтарини ид Исо аз ҷояш бархеста, бо овози баланд эълон кард: «Касоне ки ташнаанд, назди Ман оянд ва бинӯшанд! ");
INSERT INTO tgk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Дар навиштаҷот гуфта шудааст, ки аз ботини он касе, ки ба Ман имон меоварад, дарёҳои оби ҳаёт ҷорӣ мешаванд». ");
INSERT INTO tgk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ӯ инро дар бораи Рӯҳе гуфт, ки касони ба Ӯ имоноварда қабул карданашон лозим буд. Рӯҳ ҳанӯз ато нашуда буд, зеро Исо ҳанӯз соҳиби тамоми шӯҳрату ҷалоли худ нагардида буд. ");
INSERT INTO tgk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Баъзе аз мардум суханони Ӯро шунида гуфтанд: «Ин одам дар ҳақиқат ҳамон пайғамбарест, ки мо мунтазираш будем!» ");
INSERT INTO tgk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","«Ин Таъиншудаи Худо аст!» — мегуфтанд дигарон. Баъзеи дигарон мегуфтанд: «Таъиншудаи Худо ҳаргиз аз Ҷалил пайдо намешавад! ");
INSERT INTO tgk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Охир, дар навиштаҷот гуфта шудааст, ки Масеҳ, яъне Таъиншудаи Худо бояд аз авлоди шоҳ Довуд, дар деҳаи Байт-Лаҳм, ки Довуд зиндагӣ мекард, пайдо шавад». ");
INSERT INTO tgk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Инак, дар байни мардум дар бораи Исо низоъ бархост. ");
INSERT INTO tgk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Баъзеҳо мехостанд Ӯро дастгир кунанд, лекин ҳеҷ кас ба Ӯ даст нарасонд. ");
INSERT INTO tgk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Вақте ки посбонон ба назди сардорони рӯҳонӣ ва фарисиён баргаштанд, аз посбонон пурсиданд: «Чаро Ӯро наовардед?» ");
INSERT INTO tgk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Посбонон ҷавоб доданд: «Касе ҳаргиз монанди ин шахс сухан нагуфтааст!» ");
INSERT INTO tgk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Фарисиён ба онҳо гуфтанд: «Наход Ӯ шуморо ҳам гумроҳ карда бошад? ");
INSERT INTO tgk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Магар касе аз сардорон ё фарисиён ба Ӯ имон овардааст? ");
INSERT INTO tgk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Мардум бошад, аз шариат бехабар ва лаънатзадаанд!» ");
INSERT INTO tgk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Аммо яке аз онҳо Ниқодимус, ки пештар ба назди Исо омада буд, ба онҳо гуфт: ");
INSERT INTO tgk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Оё аз рӯи шариатамон мо касеро нашунида ва кори кардаашро муайян накарда, ба ӯ ҳукм мебарорем?» ");
INSERT INTO tgk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Онҳо ҷавоб доданд: «Ту худат-ку аз Ҷалил нестӣ? Навиштаҷотро биомӯз ва мебинӣ, ки аз Ҷалил пайғамбар баромада наметавонад».  ");
INSERT INTO tgk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Он гоҳ ҳама ба хонаҳояшон рафтанд. ");
INSERT INTO tgk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Исо бошад, ба теппаи Зайтун рафт. ");
INSERT INTO tgk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Саҳарии барвақт Ӯ боз ба Хонаи Худо омад. Тамоми мардум ба наздаш омаданд ва Ӯ нишаста ба таълим додани онҳо шурӯъ кард. ");
INSERT INTO tgk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Дар ин вақт шариатдонону фарисиён ба назди Ӯ занеро оварданд, ки ҳангоми алоқаи беникоҳ доштанаш дастгир шуда буд. Ӯро дар пеши ҳама гузошта, ");
INSERT INTO tgk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ба Исо гуфтанд: «Эй устод, ин зан ҳангоми алоқаи беникоҳ доштанаш дастгир шудааст. ");
INSERT INTO tgk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Мӯсо дар шариат фармудааст, ки чунин занон бояд сангсор карда шаванд. Шумо чӣ мегӯед?» ");
INSERT INTO tgk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Онҳо ин суханонро барои ба дом афтондани Исо гуфтанд, то ки баъд Ӯро айбдор намоянд. Аммо Исо сарашро хам карда бо ангушташ дар рӯи замин чизе менавишт. ");
INSERT INTO tgk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Онҳо савол доданро бас намекарданд, ки Исо бархеста, ба онҳо гуфт: «Касе ки дар байни шумо бегуноҳ бошад, бигзор аввалин шуда, ӯро бо санг занад!» ");
INSERT INTO tgk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Исо боз сарашро хам карда дар рӯи замин менавишт. ");
INSERT INTO tgk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Мардум инро шуниданду аз калонсолон сар карда яке аз паси дигар ба ҳар тараф пароканда шуданд. Он гоҳ Исо бо зане, ки дар пеши Ӯ истода буд, танҳо монд. ");
INSERT INTO tgk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ӯ сари худро бардошта, аз зан пурсид: «Эй зан, ҳамаи онҳо куҷо рафтанд? Магар касе туро айбдор накард?» ");
INSERT INTO tgk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","«Ҳеҷ кас, хоҷа», — гуфт он зан. «Ман ҳам туро айбдор намекунам, — гуфт Исо. — Рав ва дигар гуноҳ накун».  ");
INSERT INTO tgk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Исо боз ба мардум гуфт: «Ман нури ҷаҳон ҳастам. Касе, ки аз паси Ман меравад, дар торикӣ намегардад, балки нури ҳаёт бо ӯст». ");
INSERT INTO tgk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Фарисиён ба Ӯ гуфтанд: «Ту аз номи худат шаҳодат медиҳӣ, бинобар ин шаҳодати Ту эътибор надорад». ");
INSERT INTO tgk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Исо ба онҳо ҷавоб дод: «Ҳатто агар Ман аз номи худам шаҳодат диҳам, шаҳодати Ман боэътибор аст, зеро Ман медонам, ки аз куҷо омадаам ва ба куҷо меравам, вале шумо инро намедонед. ");
INSERT INTO tgk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Шумо аз рӯи меъёри инсонӣ ҳукм мекунед, аммо Ман ҳеҷ касро ҳукм намекунам. ");
INSERT INTO tgk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Агар Ман ҳукм кунам ҳам, ҳукми Ман ҳақ аст, чунки Ман танҳо нестам: Падаре, ки Маро фиристодааст, бо Ман аст. ");
INSERT INTO tgk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Дар шариати шумо ҳам навишта шудааст, ки шаҳодати ду гувоҳ боэътибор аст. ");
INSERT INTO tgk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ман аз номи худам шаҳодат медиҳам ва Падаре, ки Маро фиристодааст, низ бар Ман шаҳодат медиҳад». ");
INSERT INTO tgk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Бинобар ин онҳо пурсиданд: «Падари Ту куҷост?» «Шумо на Маро ва на Падарамро мешиносед, — ҷавоб дод Исо. — Агар шумо Маро мешинохтед, Падари Маро низ мешинохтед». ");
INSERT INTO tgk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ин суханонро Ӯ ҳангоми дар назди хазинаи Хонаи Худо таълим додан гуфта буд. Вале касе Ӯро дастгир накард, чунки вақту соати Ӯ ҳоло нарасида буд. ");
INSERT INTO tgk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Исо боз ба онҳо гуфт: «Ман баъд аз чанд вақт меравам. Шумо Маро ҷустуҷӯ мекунед, вале бо гуноҳатон хоҳед мурд. Инчунин ба он ҷое, ки Ман меравам, шумо рафта наметавонед». ");
INSERT INTO tgk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Роҳбарони яҳудӣ гуфтанд: «Ӯ „Ба он ҷое, ки Ман меравам, шумо рафта наметавонед“ гуфта чиро дар назар дошт? Оё Ӯ худкушӣ кардан мехоҳад?» ");
INSERT INTO tgk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Исо ба онҳо гуфт: «Шумо аз олами поён ҳастед, вале Ман аз олами боло. Шумо аз ин ҷаҳон ҳастед, вале Ман аз ин ҷаҳон нестам. ");
INSERT INTO tgk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ман ба шумо гуфтам, ки „бо гуноҳҳоятон хоҳед мурд“. Зеро, агар бовар накунед, ки он чӣ дар бораам гуфтам, Ман ҳастам, шумо ҳатман бо гуноҳҳоятон мемиред!» ");
INSERT INTO tgk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","«Ту кистӣ?» — пурсиданд онҳо аз Исо. Ӯ ҷавоб дод: «Ман ҳамонам, ки аз аввал ба шумо гуфта будам. ");
INSERT INTO tgk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ман барои айбдор кардани шумо чизҳои зиёде гуфта метавонам, вале касе, ки Маро фиристодааст, ҳақ аст ва Ман он чиро, ки аз Ӯ шунидам, ба ҷаҳон эълон мекунам». ");
INSERT INTO tgk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Онҳо нафаҳмиданд, ки Вай ба онҳо дар бораи Падар мегуфт. ");
INSERT INTO tgk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Инак, Исо давом дода гуфт: «Вақте ки Фарзанди Инсонро дар салиб боло мебардоред, мефаҳмед, ки Ман ҳамонам ва аз худ ҳеҷ коре намекунам, фақат он чизҳоеро мегӯям, ки Падар ба Ман таълим додааст. ");
INSERT INTO tgk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Фиристандаи Ман бо Ман аст, Ӯ Маро танҳо нагузоштааст, зеро Ман ҳамеша кори табъи дили Ӯро мекунам». ");
INSERT INTO tgk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Бисёр касон аз рӯи ин суханон ба Ӯ имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Пас, Исо ба онҳое, ки ба Ӯ имон оварданд, гуфт: «Агар шумо гуфтаҳои Маро риоя кунед, шогирдони ҳақиқии Ман мешавед ");
INSERT INTO tgk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ва ростиро мефаҳмед ва ин ростӣ шуморо озод мекунад». ");
INSERT INTO tgk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Онҳо гуфтанд: «Мо аз авлоди Иброҳим ҳастем ва ҳаргиз ғуломи касе набудем! Пас, „озод хоҳед шуд“ гуфта, чиро дар назар дорӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Исо ба онҳо ҷавоб дод: «Ба шумо рост мегӯям, ҳар касе ки гуноҳ мекунад, ғуломи гуноҳ аст. ");
INSERT INTO tgk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ғулом дар як хонадон то охир зиндагӣ намекунад, аммо писар ҳамеша дар хонадон мемонад. ");
INSERT INTO tgk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Агар Писар ба шумо озодӣ бахшад, он вақт ҳақиқатан озод хоҳед шуд. ");
INSERT INTO tgk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ман медонам, ки шумо аз авлоди Иброҳим ҳастед, бо вуҷуди он шумо барои куштани Ман тайёред, чунки суханони Маро қабул намекунед. ");
INSERT INTO tgk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ман ба шумо чизҳоеро мегӯям, ки дар назди Падарам дидаам, шумо бошед, он кореро мекунед, ки аз падари худ шунидаед». ");
INSERT INTO tgk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","«Аҷдоди мо Иброҳим аст!» — ба Ӯ ҷавоб доданд онҳо. Исо ба онҳо гуфт: «Агар шумо ҳақиқатан аз авлоди Иброҳим мебудед, корҳои Иброҳимро ба ҷо меовардед. ");
INSERT INTO tgk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Вале шумо Маро, ки ростиро аз Худо шунида ба шумо гуфтам, куштан мехоҳед! Иброҳим чунин кор накардааст! ");
INSERT INTO tgk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Шумо корҳои падари худро ба ҷо меоваред!» «Мо-ку ҳаромзода нестем! — ба ғазаб омаданд онҳо, — мо як падар дорем, ки Ӯ Худо аст!» ");
INSERT INTO tgk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Исо ба онҳо ҷавоб дод: «Агар Худо падари шумо мебуд, шумо Маро дӯст медоштед, зеро Ман аз ҷониби Худо омадаам. Ман худсарона наомадаам, балки Ӯ Маро фиристодааст. ");
INSERT INTO tgk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Чаро шумо суханони Маро намефаҳмед? Чунки шумо тоқати шунидани онҳоро надоред! ");
INSERT INTO tgk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Падари шумо иблис аст ва шумо орзуву ҳаваси падари худро иҷро кардан мехоҳед. Ӯ аз азал одамкуш буд ва ҳеҷ гоҳ рост нагуфтааст, чун дар ӯ ростӣ нест. Дурӯғ гуфтан ба ӯ хос аст, ӯ дурӯғ мегӯяд, чунки ӯ дурӯғгӯй ва падари ҳамаи дурӯғҳост. ");
INSERT INTO tgk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Лекин, азбаски Ман рост мегӯям, шумо ба Ман имон намеоред. ");
INSERT INTO tgk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Кадоме аз шумо метавонад Маро дар ягон гуноҳ айбдор кунад? Пас, агар Ман ба шумо ростиро гӯям, чаро ба Ман имон намеоред? ");
INSERT INTO tgk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Касе ки аз Худо бошад, ба каломи Худо гӯш медиҳад. Шумо барои он гӯш намедиҳед, ки аз Худо нестед». ");
INSERT INTO tgk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Мардум ба Ӯ гуфтанд: «Магар мо нагуфтем, ки Ту сомарӣ ҳастӣ ва дев дорӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Исо ҷавоб дод: «Ман дев надорам, балки Падари худро ҳурмат мекунам, вале шумо Маро бадном мекунед. ");
INSERT INTO tgk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ман дар ҷустуҷӯи шӯҳрати худ нестам, каси дигаре дар ҷустуҷӯи он аст ва Ӯ довар мешавад. ");
INSERT INTO tgk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ба шумо рост мегӯям: касе ки гуфтаҳои Маро иҷро мекунад, ҳаргиз нахоҳад мурд». ");
INSERT INTO tgk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Онҳо ба Вай гуфтанд: «Акнун мо яқин донистем, ки Ту девона ҳастӣ. Аҷдоди мо Иброҳим мурд ва пайғамбарон ҳам мурданд. Вале Ту мегӯӣ, ки касе суханони Туро иҷро кунад, ҳаргиз намемирад. ");
INSERT INTO tgk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Иброҳим мурд, магар Ту аз ӯ бузургтар ҳастӣ? Пайғамбарон ҳам мурдаанд. Ту худро кӣ ҳисоб мекунӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Исо ҷавоб дод: «Агар Ман худро шӯҳрат медодам, шӯҳрати Ман арзише намедошт. Аммо Маро Падарам шӯҳрат медиҳад, ки шумо Ӯро Худои худ мехонед! ");
INSERT INTO tgk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Шумо ҳеҷ вақт Ӯро намешинохтед, вале Ман Ӯро мешиносам. Агар Ман мегуфтам, ки Ӯро намешиносам, монанди шумо дурӯғгӯй мешудам. Вале Ман Ӯро мешиносам ва гуфтаҳои Ӯро ба ҷо меорам. ");
INSERT INTO tgk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Аҷдоди шумо Иброҳим шод буд, ки рӯзи омадани Маро мебинад. Вай ин рӯзро дид ва хурсанд шуд!» ");
INSERT INTO tgk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","«Ту ҳанӯз панҷоҳсола нашудаӣ ва наход Иброҳимро дида бошӣ?!» — гуфтанд одамон. ");
INSERT INTO tgk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Исо ҷавоб дод: «Ба шумо рост мегӯям, ки пеш аз ба дунё омадани Иброҳим ҳам Ман ҳастам». ");
INSERT INTO tgk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Он гоҳ онҳо барои сангсор кардани Ӯ санг гирифтанд, вале Исо худро пинҳон карда, аз Хонаи Худо баромада рафт. ");
INSERT INTO tgk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Исо роҳравон шахсеро дид, ки кӯри модарзод буд. ");
INSERT INTO tgk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Шогирдон аз Исо пурсиданд: «Устод, аз барои гуноҳи кӣ ӯ кӯр таваллуд шудааст? Аз барои гуноҳи худаш ё гуноҳи падару модараш?» ");
INSERT INTO tgk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Исо дар ҷавоб гуфт: «На аз барои гуноҳи худаш ва на аз барои гуноҳи падару модараш. Кӯрии вай барои он аст, ки корҳои Худо дар ҳаёти вай нишон дода шаванд. ");
INSERT INTO tgk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","То рӯз аст, мо бояд корҳои фиристандаи Маро иҷро кунем. Вақте ки шаб мешавад, касе кор карда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","То Ман дар ҷаҳон ҳастам, Ман нури ҷаҳонам». ");
INSERT INTO tgk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Инро гуфта, ба замин туф карду онро бо хок омехта, гилро ба чашмони кӯр молид ва ");
INSERT INTO tgk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ба ӯ гуфт: «Рафта, дар ҳавзи Шилӯаҳ (маънои он „фиристода“ аст) рӯятро бишӯй». Ӯ рафта, рӯяшро шусту бо чашмони бино баргашт. ");
INSERT INTO tgk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ҳамсояҳои ӯ ва касони дигаре, ки ӯро дар вақти садақа пурсиданаш дида буданд, ба ҳамдигар мегуфтанд: «Оё ин ҳамон шахс нест, ки нишаста гадоӣ мекард?» ");
INSERT INTO tgk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","«Бале, ин ҳамон шахс аст», — мегуфтанд баъзеҳо. Дигарон мегуфтанд: «Не, ӯ фақат монанд аст». Он мард бошад, мегуфт, ки ман ҳамон одам ҳастам. ");
INSERT INTO tgk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","«Ту чӣ тавр бино шудӣ?» — пурсиданд аз ӯ. ");
INSERT INTO tgk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ӯ дар ҷавоб гуфт: «Марде бо номи Исо гиле сохта, ба чашмони ман молиду гуфт, ки ба Шилӯаҳ рафта, рӯямро шӯям. Ман рафта, рӯямро шустаму бино шудам». ");
INSERT INTO tgk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","«Ӯ дар куҷост?» — пурсиданд онҳо. «Намедонам», — ҷавоб дод ӯ. ");
INSERT INTO tgk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Мардеро, ки пештар кӯр буд, назди фарисиён бурданд. ");
INSERT INTO tgk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Рӯзе, ки Исо гил сохта, чашмони ӯро шифо дод, рӯзи истироҳат буд. ");
INSERT INTO tgk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Фарисиён ҳам ӯро пурсиданд, ки чӣ тавр ӯ бино шуд. Ӯ ҷавоб дод: «Ӯ ба чашмонам гил молиду ман рӯямро шустам ва акнун мебинам». ");
INSERT INTO tgk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Баъзе аз фарисиён гуфтанд, ки одами ин корро карда аз ҷониби Худо нест, чунки қоидаҳои рӯзи истироҳатро риоя намекунад. Лекин дигарон мегуфтанд: «Магар шахси гунаҳкор метавонад чунин мӯъҷизаҳоро нишон диҳад?» Ҳамин тавр дар миёни онҳо низоъ ба вуҷуд омад. ");
INSERT INTO tgk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Онҳо боз аз кӯр пурсиданд: «Ту дар бораи Вай чӣ гуфта метавонӣ? Охир Вай чашмони туро бино кард-ку». «Ӯ пайғамбар аст», — ҷавоб дод он мард. ");
INSERT INTO tgk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Онҳо то падару модари он кӯрро даъват накарданд боварӣ надоштанд, ки ин одам пештар кӯр буду баъд бино шуд. Баъд аз даъват кардан ");
INSERT INTO tgk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","аз онҳо пурсиданд: «Ин писари шумост? Шумо мегӯед, ки ӯ кӯр таваллуд шуда буд. Пас, чӣ тавр ӯ ҳоло дида метавонад?» ");
INSERT INTO tgk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Падару модари вай ҷавоб доданд: «Мо медонем, ки ин писари мост ва кӯр таваллуд шудааст. ");
INSERT INTO tgk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Аммо намедонем, ки чӣ тавр ӯ акнун медидагӣ шуд ва кист он касе, ки чашмони ӯро шифо додааст. Аз худи ӯ бипурсед. Ӯ ба воя расидааст ва худаш дар бораи худ гуфта метавонад». ");
INSERT INTO tgk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Падару модари ӯ аз тарси роҳбарони яҳудӣ чунин ҷавоб доданд, зеро роҳбарони яҳудӣ чунин қарор карданд: ҳар кӣ Исоро Таъиншудаи Худо гӯяд, аз ибодатхона ҷудо карда мешавад. ");
INSERT INTO tgk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Барои ҳамин ҳам падару модари вай гуфтанд, ки «Ӯ ба воя расидааст, аз худаш пурсед». ");
INSERT INTO tgk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Инак, шахсеро, ки кӯр буд, бори дигар ҷеғ зада, ба ӯ гуфтанд: «Ба Худо росташро бигӯй! Мо медонем, ки он шахс гунаҳкор аст». ");
INSERT INTO tgk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","«Гунаҳкор аст ё не, ман намедонам, — ҷавоб дод ӯ. — Ҳаминашро медонам, ки ман кӯр будам ва акнун мебинам». ");
INSERT INTO tgk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Онҳо боз пурсиданд: «Ӯ бо ту чӣ кор кард? Чӣ тавр чашмони туро бино кард?» ");
INSERT INTO tgk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","«Ман ба шумо гуфта будам, вале шумо гӯш накардед, — ҷавоб дод ӯ. — Чаро боз шунидан мехоҳед? Шояд шумо ҳам шогирди Ӯ шуданӣ ҳастед?» ");
INSERT INTO tgk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Онҳо ӯро ҷанг карда: «Ин ту шогирди Ӯ ҳастӣ, аммо мо шогирдони Мӯсо ҳастем. ");
INSERT INTO tgk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Мо медонем, ки Худо бо Мӯсо гап задааст, вале дар бораи ин одам бошад, ҳатто аз куҷо буданашро намедонем». ");
INSERT INTO tgk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Он мард дар ҷавоб гуфт: «Аҷиб аст, ки шумо аз куҷо будани Ӯро намедонед, ҳол он ки Ӯ чашмони маро бино кард. ");
INSERT INTO tgk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Мо медонем, ки Худо дуои гунаҳкоронро намешунавад, фақат онҳоеро мешунавад, ки худотарс ҳастанду хости Ӯро иҷро мекунанд. ");
INSERT INTO tgk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Аз рӯзе, ки олам ҳаст, боре нашунидаем, ки касе кӯри модарзодро бино карда бошад! ");
INSERT INTO tgk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Агар Ӯ аз ҷониби Худо намеомад, Ӯ ҳеҷ чиз карда наметавонист!» ");
INSERT INTO tgk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Онҳо ба ӯ ҷавоб доданд: «Ту пурра дар гуноҳ таваллуд шудаӣ ва боз моро таълим медиҳӣ!» Инро гуфта, ӯро берун ронданд. ");
INSERT INTO tgk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Вақте Исо фаҳмид, ки он мардро берун ронданд, вайро ёфта пурсид: «Ту ба Фарзанди Инсон имон дорӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ӯ ҷавоб дод: «Хоҷа, ба ман бигӯ, ки Ӯ кист, то ба Ӯ имон оварам». ");
INSERT INTO tgk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","«Ту Ӯро дидаӣ, — гуфт Исо. — Ӯ ҳамон касест, ки ҳоло бо ту гап мезанад». ");
INSERT INTO tgk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","«Эй Худованд, имон дорам!» — ҷавоб дод вай ва ба Исо саҷда кард. ");
INSERT INTO tgk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Исо гуфт: «Ман ба ин ҷаҳон барои доварӣ омадам, то онҳое, ки кӯр ҳастанд, бино шаванд ва онҳое, ки мебинанд, кӯр шаванд». ");
INSERT INTO tgk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Баъзе фарисиёне, ки назди Ӯ истода буданд, ин суханонро шунида ба Ӯ гуфтанд: «Шумо моро-ку кӯр намешуморед?» ");
INSERT INTO tgk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Исо ҷавоб дод: «Агар шумо дар ҳақиқат кӯр мебудед, дар гуноҳ айбдор намешудед. Вале ҳоло худатон мегӯед, ки бино ҳастед, пас гуноҳатон дар гардани худатон мемонад». ");
INSERT INTO tgk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Исо гуфт: «Ба шумо рост мегӯям, ҳар кӣ ба оғили гӯсфандон на аз дар, балки аз ҷои дигар гузашта дарояд, дузд ва роҳзан аст. ");
INSERT INTO tgk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Он ки аз дар медарояд, чӯпони гӯсфандон аст. ");
INSERT INTO tgk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Дарвозабон дарро барои ӯ мекушояд ва гӯсфандон садои ӯро мешунаванд. Ӯ гӯсфандони худро ном ба ном фарёд карда, берун мебарорад. ");
INSERT INTO tgk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Баъди берун баровардани ҳамаи гӯсфандонаш худ пешопеши онҳо равона мешаваду гӯсфандон аз паси ӯ мераванд, чунки овози ӯро мешиносанд. ");
INSERT INTO tgk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Гӯсфандон аз қафои каси бегона намераванд, балки аз ӯ мегурезанд, чунки овози каси бегонаро намешиносанд». ");
INSERT INTO tgk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Исо ба онҳо ин масалро нақл кард, аммо онҳо маънои гуфтаҳояшро нафаҳмиданд. ");
INSERT INTO tgk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Инак, Исо боз ба онҳо гуфт: «Ба шумо рост мегӯям, ки Ман барои гӯсфандон дарвоза ҳастам. ");
INSERT INTO tgk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ҳамаи онҳое, ки пеш аз Ман омада буданд, дузд ва роҳзан ҳастанд, лекин гӯсфандон онҳоро гӯш накарданд. ");
INSERT INTO tgk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ман дарвоза ҳастам. Ҳар касе ки ба воситаи Ман медарояд, наҷот меёбад. Ӯ ҳам медарояду ҳам мебарояд ва барои худ чарогоҳ пайдо мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Дузд фақат барои дуздидан, куштан ва нобуд кардан меояд. Ман омадаам, ки гӯсфандонам ҳаёт дошта бошанд ва ҳаёти фаровон. ");
INSERT INTO tgk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ман чӯпони нек ҳастам. Чӯпони нек ҷони худро барои гӯсфандон фидо мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Одами кирошуда, ки чӯпон нест ва гӯсфандон аз они ӯ нестанд, ба рама наздик шудани гургро бинад, гӯсфандонро монда, мегурезад ва гург ба онҳо дарафтода, онҳоро пароканда мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Одами кирошуда аз он сабаб мегурезад, ки парвои гӯсфандонро надорад. ");
INSERT INTO tgk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ман чӯпони нек ҳастам ва чӣ тавре ки Падар Маро мешиносаду Ман Падарро мешиносам, ҳамон тавр Ман гӯсфандони худро мешиносаму онҳо Маро мешиносанд. Ман ҷони худро барои гӯсфандон фидо мекунам. ");
INSERT INTO tgk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ман гӯсфандони дигаре ҳам дорам, ки аз ин оғил нестанд; Ман бояд онҳоро низ биёрам. Онҳо ба овози Ман гӯш мекунанд ва он гоҳ як рама бо як чӯпон хоҳад шуд! ");
INSERT INTO tgk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Падар барои он Маро дӯст медорад, ки Ман ҷони худро фидо мекунам, то боз онро ба даст оварам. ");
INSERT INTO tgk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ҳеҷ кас ҷони Маро аз Ман намегирад, Ман онро бо ихтиёри худ фидо мекунам. Ман қудрат дорам, ки онро фидо кунам ва қудрат дорам, ки онро боз ба даст орам. Ин фармонро Ман аз Падарам гирифтаам». ");
INSERT INTO tgk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Аз сабаби ин суханон дар байни мардум бори дигар низоъ ба вуҷуд омад. ");
INSERT INTO tgk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Бисёре аз онҳо мегуфтанд: «Ӯ дев дорад ва аз ақл бегона шудааст! Чаро ба суханони Ӯ гӯш медиҳед?» ");
INSERT INTO tgk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","«Ин суханони шахси девона нестанд, — норозӣ шуданд дигарон. — Магар дев чашмони кӯрро бино карда метавонад?» ");
INSERT INTO tgk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Зимистон фаро расид. Дар Ерусалим иди хотираи Бахшидашавии Хонаи Худо буд. Исо дар ҳавлии Хонаи Худо, дар айвони Сулаймон мегашт. ");
INSERT INTO tgk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Одамон Ӯро миёнагир карда пурсиданд: «То кай моро дар ноаниқӣ нигоҳ медорӣ? Ба мо рӯйирост бигӯ, ки Ту Таъиншудаи Худо ҳастӣ ё не?» ");
INSERT INTO tgk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Исо ба онҳо ҷавоб дод: «Ман ба шумо аллакай гуфта будам, вале шумо ба Ман бовар намекунед. Он корҳое, ки Ман аз номи Падари худ иҷро мекунам, дар бораи Ман шаҳодат медиҳанд, ");
INSERT INTO tgk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","аммо шумо ба Ман имон намеоваред, зеро шумо аз ҷумлаи гӯсфандони Ман нестед. ");
INSERT INTO tgk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Гӯсфандони Ман овози Маро мешунаванд. Ман онҳоро мешиносам ва онҳо аз паси Ман меоянд. ");
INSERT INTO tgk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ман ба онҳо ҳаёти абадӣ мебахшам ва онҳо ҳаргиз нобуд намешаванд ва касе наметавонад онҳоро аз дасти Ман бирабояд. ");
INSERT INTO tgk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Падари Ман, ки онҳоро ба Ман бахшидааст, аз ҳама бузургтар аст ва ҳеҷ кас онҳоро аз дасти Падари Ман кашида гирифта наметавонад. ");
INSERT INTO tgk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ману Падар як ҳастем». ");
INSERT INTO tgk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Яҳудиён боз барои сангсор кардани Ӯ санг бардоштанд. ");
INSERT INTO tgk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Исо ба онҳо гуфт: «Ман ба шумо аз ҷониби Падар бисёр корҳои нек нишон додаам, пас, барои кадоме аз онҳо шумо Маро сангсор кардан мехоҳед?» ");
INSERT INTO tgk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Онҳо ба Ӯ ҷавоб доданд: «Мо Туро на барои корҳои некат сангсор кардан мехоҳем, балки барои сухани кофиронаат, ки Ту инсон ҳастиву даъвои худоӣ мекунӣ!» ");
INSERT INTO tgk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Исо ҷавоб дод: «Магар дар шариати шумо навишта нашудааст: „Ман мегӯям, ки шумо худоён ҳастед?“ ");
INSERT INTO tgk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ва ин навиштаҷот ҳеҷ вақт бекор карда намешавад. Пас, агар Худо касонеро, ки ба онҳо суханонаш равона шудаанд, „худоён“ номида бошад, ");
INSERT INTO tgk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","чӣ тавр шумо суханони Маро, ки „Ман Писари Худо ҳастам“ гуфтам, кофирона мегӯед? Ба Ман, ба он касе мегӯед, ки Падар ҷудо карда, ба ҷаҳон фиристодааст?! ");
INSERT INTO tgk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Агар Ман корҳои Падарамро ба амал наоварам, ба Ман имон наоваред! ");
INSERT INTO tgk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Лекин, агар Ман онҳоро ба амал оварам, ҳарчанд ба Ман имон наоваред ҳам, ба корҳои Ман имон оваред, то бидонед ва бифаҳмед, ки Падар дар Ман аст ва Ман дар Падар ҳастам». ");
INSERT INTO tgk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Онҳо бори дигар хостанд Ӯро дастгир кунанд, вале Ӯ худро аз дасти онҳо раҳо кард. ");
INSERT INTO tgk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Исо боз ба он тарафи дарёи Урдун, ки Яҳё дар он ҷо пештар мардумро таъмид медод, рафта, дар ҳамон ҷо монд. ");
INSERT INTO tgk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Мардуми зиёде пеши Ӯ омаданд. Онҳо мегуфтанд, ки Яҳё ҳеҷ мӯъҷизае нишон надода буд, вале ҳамаи суханони Яҳё дар бораи ин шахс гуфтааш дурустанд. ");
INSERT INTO tgk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Он гоҳ шумораи бисёри одамон дар он ҷо ба Исо имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Марде, ки Лаъзор ном дошт, бемор шуд. Ӯ аз Байт-Ҳинӣ, аз деҳае буд, ки дар он Марям бо хоҳараш Марто зиндагӣ мекард. ");
INSERT INTO tgk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Марям ҳамон зан буд, ки ба пойҳои Худованд атриёт молида, онҳоро бо мӯйи сари худ хушк карда буд. Лаъзори беморшуда бародари ӯ буд. ");
INSERT INTO tgk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Хоҳарони Лаъзор касеро бо хабаре назди Исо фиристоданд, ки бигӯяд: «Эй Худованд, он касе, ки Ту дӯст медорӣ, бемор аст». ");
INSERT INTO tgk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Исо ин хабарро шунида гуфт: «Ин беморӣ на барои марг, балки барои шӯҳрату ҷалоли Худо ва барои он аст, ки Фарзанди Инсон ба воситаи он ҷалоли худро нишон диҳад». ");
INSERT INTO tgk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Исо Марто, хоҳари ӯ ва Лаъзорро дӯст медошт. ");
INSERT INTO tgk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Вале аз бемории Лаъзор хабардор шуда бошад ҳам, боз ду рӯзи дигар дар ҷояш монд. ");
INSERT INTO tgk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Баъд ба шогирдонаш гуфт: «Биёед, ба Яҳудия бармегардем». ");
INSERT INTO tgk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","«Устод, — гуфтанд шогирдони ӯ, — навакак мардум шуморо сангсор кардан мехостанду Шумо боз ба он ҷо рафтанӣ ҳастед?» ");
INSERT INTO tgk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Исо ба онҳо ҷавоб дод: «Магар як рӯз аз дувоздаҳ соат иборат нест? Касоне, ки рӯзона роҳ мераванд, пешпо намехӯранд, чунки рӯшноии ин ҷаҳонро мебинанд. ");
INSERT INTO tgk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Аммо касоне, ки шабона роҳ мераванд, пешпо мехӯранд, чунки равшанӣ надоранд». ");
INSERT INTO tgk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Исо инро гуфта, давом дод: «Дӯсти мо Лаъзор хобидааст, Ман рафта, ӯро бедор мекунам». ");
INSERT INTO tgk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Шогирдон ба Ӯ гуфтанд: «Худованд, агар хоб рафта бошад, сиҳат мешавад». ");
INSERT INTO tgk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Исо мурдани Лаъзорро дар назар дошт, аммо онҳо фикр мекарданд, ки Ӯ дар бораи хоби муқаррарӣ гап мезанад. ");
INSERT INTO tgk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Он гоҳ Исо ошкоро ба онҳо гуфт: «Лаъзор мурдааст, ");
INSERT INTO tgk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","вале Ман ба хотири шумо хурсандам, ки дар он ҷо набудам, то ки имон оваред. Ҳоло бошад, биёед, назди ӯ меравем». ");
INSERT INTO tgk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Он гоҳ Тумо, ки ӯро боз Дугоник меномиданд, ба шогирдони дигар гуфт: «Биёед, мо ҳам меравем, то ҳамроҳи Ӯ бимирем!» ");
INSERT INTO tgk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ба он ҷо расида омадан замон Исо фаҳмид, ки Лаъзорро чор рӯз пеш гӯронидаанд. ");
INSERT INTO tgk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Деҳаи Байт-Ҳинӣ аз Ерусалим дур набуд, тақрибан дар масофаи се километр роҳ буд, ");
INSERT INTO tgk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","бинобар ин бисёре аз яҳудиён ба назди Марто ва Марям омаданд, то ки барои марги бародарашон ҳамдардиашонро изҳор намоянд. ");
INSERT INTO tgk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Марто ҳамин ки хабари ба назди онҳо омада истодани Исоро шунид, ба пешвози Ӯ рафт, вале Марям дар хона монд. ");
INSERT INTO tgk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Марто ба Исо гуфт: «Худованд, агар Ту дар ин ҷо мебудӣ, бародарам аз дунё намегузашт! ");
INSERT INTO tgk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Аммо ман медонам, ки ҳоло ҳам ҳар чӣ аз Худо талаб кунӣ, ба Ту медиҳад». ");
INSERT INTO tgk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","«Бародарат гашта зинда мешавад», — гуфт ба ӯ Исо. ");
INSERT INTO tgk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","«Медонам, ки дар рӯзи қиёмат, ҳангоми зинда шудани мурдагон вай ҳам зинда мешавад», — ҷавоб дод Марто. ");
INSERT INTO tgk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Исо гуфт: «Ман каси зиндакунанда ва ҳаётбахш ҳастам. Касе ки ба Ман имон дорад, бимирад ҳам, аз нав зинда мешавад. ");
INSERT INTO tgk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Инчунин, ҳар касе ки дар Ман зиндагӣ мекунад ва ба Ман имон меоварад, ҳаргиз намемирад. Ту ба ин бовар мекунӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","«Бале, Худованд, — ҷавоб дод Марто, — ман бовар мекунам, ки Ту Таъиншуда ва Писари Худо ҳастӣ, ки бояд ба ҷаҳон биёяд». ");
INSERT INTO tgk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Инро гуфта, Марто рафт ва хоҳари худ Марямро ҷеғ зада, фақат ба ӯ гуфт: «Устод омадааст ва туро даъват мекунад». ");
INSERT INTO tgk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Марям инро шунида, зуд аз ҷояш бархест ва ба назди Исо рафт ");
INSERT INTO tgk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Исо ҳанӯз ба деҳа надаромада буд, балки дар ҳамон ҷое монд, ки Марто ба пешвозаш баромада буд). ");
INSERT INTO tgk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Дар хона ҳамроҳи Марям яҳудиёне буданд, ки ӯро дилбардорӣ мекарданд. Онҳо зуд аз ҷояш хеста ва аз хона баромадани Марямро дида, гумон карданд, ки вай ба сари қабр рафта, гиря мекунад ва аз паси ӯ равона шуданд. ");
INSERT INTO tgk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Вақте Марям ба ҷое, ки Исо буд, омаду Ӯро дид, пеши пойҳояш худро партофта, гуфт: «Худованд, агар дар ин ҷо мебудӣ, бародарам намемурд». ");
INSERT INTO tgk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Вақте Исо Марям ва одамони ҳамроҳаш омадаро гирён дид, дилаш сахт безобита шуда ");
INSERT INTO tgk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","гуфт: «Шумо ӯро дар куҷо гӯронидед?» Онҳо ҷавоб дода гуфтанд: «Рафтем, Худованд, нишон медиҳем». ");
INSERT INTO tgk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Исо ашки чашм рехт. ");
INSERT INTO tgk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Он гоҳ яҳудиён гуфтанд: «Бубинед, чӣ қадар ӯро дӯст медошт!» ");
INSERT INTO tgk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Лекин баъзеи онҳо гуфтанд: «Ӯ, ки чашмони кӯрро бино карда буд, магар Лаъзорро аз марг нигоҳ дошта наметавонист?» ");
INSERT INTO tgk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Исо бори дигар хашмгин шуда, ба сари қабр омад. Ин як ғоре буд, ки дар даромадгоҳи он санг гузошта шуда буд. ");
INSERT INTO tgk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","«Сангро дур кунед!» — гуфт Исо. Марто, хоҳари марҳум ба Ӯ гуфт: «Худованд, аллакай бӯй гирифтааст. Охир аз рӯзе, ки ӯро дафн кардем, чор рӯз гузашт». ");
INSERT INTO tgk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Исо ба ӯ гуфт: «Магар Ман ба ту нагуфта будам, ки агар имон оварӣ, шӯҳрату ҷалоли Худоро хоҳӣ дид?» ");
INSERT INTO tgk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Сангро дур карданд. Исо ба боло нигоҳ карда гуфт: «Эй Падар, шукри Туро мекунам, ки дуои Маро шунидӣ. ");
INSERT INTO tgk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ман медонистам, ки Ту ҳамеша дуои Маро мешунавӣ, вале инро ба хотири мардуме, ки дар ин ҷо истодаанд, гуфтам, то онҳо имон оваранд, ки Маро Ту фиристодаӣ!» ");
INSERT INTO tgk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Инро гуфта, бо овози баланд хитоб кард: «Эй Лаъзор, берун баро!» ");
INSERT INTO tgk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Мурда, ки дасту пойҳояш бо кафану рӯяш бо рӯймол печонда шуда буд, аз қабр баромад. Исо ба онҳо гуфт: «Дасту пойҳои ӯро кушоед, ки роҳ равад!» ");
INSERT INTO tgk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Бисёре аз яҳудиёне, ки назди Марям омада буданд, мӯъҷизаи Исоро дида ба Ӯ имон оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Аммо баъзе аз онҳо ба пеши фарисиён рафта, дар бораи корҳои Исо хабар доданд. ");
INSERT INTO tgk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Он гоҳ сардорони рӯҳонӣ ва фарисиён маҷлиси шӯроро ҷамъ карда, гуфтанд: «Чӣ кор мекунем? Ин одам мӯъҷизаҳои зиёде нишон медиҳад. ");
INSERT INTO tgk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Агар мо имконият диҳем, ки Ӯ кори худро давом диҳад, ҳама ба Ӯ имон меоваранд. Он вақт румиён омада, ҳам ҷои муқаддасамон ва ҳам халқи моро нест мекунанд». ");
INSERT INTO tgk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Яке аз онҳо ба номи Қаёфо, ки дар он сол сарвари рӯҳониён буд, гуфт: «Шумо ҳеҷ чизро намефаҳмед! ");
INSERT INTO tgk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Магар аён нест, ки агар як нафар ба хотири халқ бимирад, барои шумо беҳтар аст, аз он ки тамоми халқ нобуд шавад». ");
INSERT INTO tgk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Қаёфо ин суханонро боихтиёри худ нагуфт, балки аз сабаби ҳамон сол сарвари рӯҳониён буданаш аз ӯ ин пешгӯӣ баромаданд, ки Исо барои халқ мемирад. ");
INSERT INTO tgk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Вале на танҳо барои халқи яҳудиён, инчунин барои муттаҳид гардондани тамоми фарзандони Худо низ, ки дар рӯи замин парокандаанд, мемирад. ");
INSERT INTO tgk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Аз ҳамон рӯз сар карда, онҳо роҳи чӣ тавр ба қатл расондани Ӯро фикр карданд. ");
INSERT INTO tgk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Аз ин сабаб Исо дигар дар Яҳудия ошкоро рафтуомад намекард. Вай аз он ҷо ба Эфроим ном шаҳре, ки дар наздикии биёбон ҷойгир шуда буд, рафта, бо шогирдонаш дар ҳамон ҷо монд. ");
INSERT INTO tgk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Иди Балогардони яҳудиён наздик мешуд ва аз гӯшаву канори мамлакат мардуми зиёд ба Ерусалим равона шуданд, то пеш аз сар шудани ид расму таомули покшавиро ба ҷо оваранд. ");
INSERT INTO tgk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Онҳо дар ҷустуҷӯи Исо буданду дар Хонаи Худо аз ҳамдигар мепурсиданд: «Чӣ фикр доред? Наход Ӯ ба ид биёяд?» ");
INSERT INTO tgk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Зеро сардорони рӯҳонӣ ва фарисиён фармон бароварданд, ки агар касе дар куҷо будани Исоро донад, бояд ба онҳо хабар диҳад, то Ӯро дастгир карда тавонанд. ");
INSERT INTO tgk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Шаш рӯз пеш аз сар шудани иди Балогардон Исо ба Байт-Ҳинӣ ба хонаи ҳамон Лаъзор, ки зинда карда буд, омад. ");
INSERT INTO tgk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ба шарафи Ӯ зиёфат барпо карданд. Марто хизмат мекард ва Лаъзор бо ҳамроҳии Исо ва меҳмонони дигар дар сари дастархон нишаста буд. ");
INSERT INTO tgk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Марям бошад, як шишаи атри ниҳоят қиматбаҳоро гирифта, ба пойҳои Исо молиду бо мӯйҳояш пойҳои Ӯро хушк кард. Хонаро бӯйи муаттар фаро гирифт. ");
INSERT INTO tgk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ҳамин вақт Яҳудои Исқарют, яке аз шогирдон, ки дар оянда ба Исо хиёнат мекунад, гуфт: ");
INSERT INTO tgk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Чаро ин атр ба сесад динор фурӯхта, пули он ба камбағалон тақсим карда нашуд?» ");
INSERT INTO tgk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(Ӯ хазинадор буд ва барои манфиати худ аз он ҷо пул мегирифт. Бинобар ин ӯ на аз сабаби ғами камбағалонро хӯрдан, балки аз барои дузд буданаш он суханонро гуфт). ");
INSERT INTO tgk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Вале Исо дар ҷавоб гуфт: «Марямро ором гузор! Бимон, ки атрро барои рӯзи дафни Ман нигаҳ дорад. ");
INSERT INTO tgk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Камбағалон ҳамеша бо шумо ҳастанд, вале Ман ҳамеша бо шумо намемонам». ");
INSERT INTO tgk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Дар айни ҳол бисёре аз аҳолии Яҳудия дар Байт-Ҳинӣ будани Исоро дониста, ба он ҷо рафтанд. Вале онҳо на фақат ба хотири Исо, балки барои дидани Лаъзор ҳам, ки Исо ӯро зинда карда буд, ба он ҷо рафта буданд. ");
INSERT INTO tgk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Он гоҳ сардорони рӯҳонӣ қарор доданд, ки Лаъзорро ҳам бикушанд, ");
INSERT INTO tgk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","зеро аз барои ӯ мардуми зиёди Яҳудия аз онҳо рӯ гардонда, ба Исо имон меоварданд. ");
INSERT INTO tgk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Рӯзи дигар мардуми сершуморе, ки ба ид омада буданд, шуниданд, ки Исо ба Ерусалим омада истодааст. ");
INSERT INTO tgk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Он гоҳ онҳо шохаҳои дарахти нахлро ба даст гирифта, ба пешвози Ӯ баромаданд ва фарёд мекарданд: «Шаъну шараф ба Худо! Баракат ёбад касе, ки аз номи Худованд меояд ва Шоҳи Исроил аст!» ");
INSERT INTO tgk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Исо харкуррае ёфта, ба он савор шуд, зеро дар навиштаҷот чунин гуфта шудааст: ");
INSERT INTO tgk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Натарс, эй шаҳри Ерусалим! Ана, Шоҳи ту савораи харкурра омада истодааст». ");
INSERT INTO tgk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Шогирдони Ӯ инро он вақт нафаҳмиданд, вале ҳангоме ки Исо ба тамоми шӯҳрату ҷалоли Худо соҳиб шуд, онҳо ба ёд оварданд, ки дар навиштаҷот ҳамаи ин дар борааш навишта шуда буд ва бо Ӯ ҳамин тавр ҳам рӯй дод. ");
INSERT INTO tgk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Мардуме, ки дар ҳузурашон Исо Лаъзори мурдаро аз қабр ҷеғ зада, зинда карда буд, паҳн кардани ин хабарро давом медоданд. ");
INSERT INTO tgk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Аз сабаби шунидани ин мӯъҷиза тӯда-тӯда одамон ба пешвози Ӯ баромаданд. ");
INSERT INTO tgk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Аммо фарисиён ба якдигар гуфтанд: «Медонед, аз дастамон ҳеҷ коре намеояд! Ана бинед, тамоми ҷаҳон аз пайи Ӯ меравад!» ");
INSERT INTO tgk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Дар байни онҳое, ки барои саҷдаи Худо ба ид омада буданд, юнониҳо ҳам буданд. ");
INSERT INTO tgk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Онҳо ба назди Филиппус, ки аз аҳли Байт-Сайдои Ҷалил буд, омада гуфтанд: «Хоҷа, мо мехоҳем, ки Исоро бинем». ");
INSERT INTO tgk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Филиппус рафта, инро ба Андриёс хабар доду баъд ҳардуяшон рафта, ба Исо гуфтанд. ");
INSERT INTO tgk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Исо ҷавоб дод: «Вақту соати он расидааст, ки тамоми шӯҳрату ҷалоли Фарзанди Инсон ошкор гардад! ");
INSERT INTO tgk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ба шумо рост мегӯям: то донаи гандум ба замин афтида намирад, вай як донаи танҳо мемонад, аммо агар бимирад — ҳосили зиёд меоварад. ");
INSERT INTO tgk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Касе ки ҳаёташро азиз дорад, онро аз даст медиҳад ва касе ки дар ин дунё аз ҳаёти худ нафрат кунад, онро барои ҳаёти абадӣ нигоҳ медорад. ");
INSERT INTO tgk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ҳар кӣ ба Ман хизмат кунад, бояд аз пасам ояд ва ҳар ҷое, ки Ман ҳастам, хизматгорам низ ҳамон ҷо мешавад. Касеро, ки ба Ман хизмат кунад, Падарам сарфароз менамояд. ");
INSERT INTO tgk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ҷонам ҳоло дар азоб аст ва намедонам чӣ гӯям? Бигӯям, ки „Падар, Маро аз ин соат халос кун!“, вале Ман маҳз барои ҳамин соат омадаам! ");
INSERT INTO tgk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Эй Падар, номи худро шӯҳрат деҳ!» Он гоҳ аз осмон садое шунида шуд: «Аллакай шӯҳрат додам ва боз ҳам шӯҳрати бештар медиҳам!» ");
INSERT INTO tgk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Тӯдаи мардум, ки дар он ҷо истода буданд, ин овозро шунида, баъзеашон гуфтанд, ки ин ғурриши раъд буд, дигарон гуфтанд, ки фариштае ба Ӯ сухан гуфт. ");
INSERT INTO tgk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Исо дар ҷавоби онҳо гуфт: «Ин садо на ба хотири Ман, балки ба хотири шумо буд! ");
INSERT INTO tgk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Акнун вақти ҳукм шудани ин ҷаҳон аст, ҳоло ҳукмрони ин ҷаҳон берун ронда мешавад! ");
INSERT INTO tgk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Вақте ки Ман аз замин боло бардошта мешавам, ҳамаро ба сӯи худ мекашам!» ");
INSERT INTO tgk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Бо ин суханон Ӯ ишора мекард, ки чӣ тарз ҷон медиҳад. ");
INSERT INTO tgk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Мардум ҷавоб доданд: «Мо аз шариат медонем, ки Таъиншудаи Худо то абад зинда мемонад. Пас, чӣ тавр мегӯӣ, ки Фарзанди Инсон бояд боло бардошта шавад? Охир, Фарзанди Инсон кист?» ");
INSERT INTO tgk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Исо ба онҳо гуфт: «Боз муддати кӯтоҳе равшанӣ бо шумо мемонад. Ҳанӯз ки равшанӣ доред, роҳ равед, то ки торикӣ шуморо фаро нагирад, зеро ҳар кӣ дар торикӣ роҳ меравад, ҷои мерафтагиашро намедонад. ");
INSERT INTO tgk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Пас, ҳанӯз ки равшанӣ бо шумост, ба он имон биёваред, то ки писарони равшанӣ шавед!» Исо инро гуфта, он ҷойро монда рафту аз назари онҳо ғоиб шуд. ");
INSERT INTO tgk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Бо вуҷуди он ки Исо дар ҳузури онҳо мӯъҷизоти бисёр нишон дод, онҳо ба Ӯ имон наоварданд. ");
INSERT INTO tgk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ишаъё пайғамбар гуфта буд: «Эй Худованд, кӣ ба паёми мо бовар кардааст? Ба кӣ қудрати Худо ошкор гардидааст?» Ин пешгӯӣ ҳамин тавр иҷро шуд. ");
INSERT INTO tgk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Инчунин онҳо боз аз он сабаб имон оварда натавонистанд, ки Ишаъё пайғамбар чунин ҳам гуфта буд: ");
INSERT INTO tgk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Худо чашмони онҳоро нобино ва ақли онҳоро тира кардааст, то ки онҳо бо чашмони худ набинанд ва бо ақли худ дарк накунанд. Вагарна, мегӯяд Худо, ба Ман муроҷиат мекарданд, то Ман онҳоро шифо диҳам». ");
INSERT INTO tgk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ишаъё барои он чунин гуфта буд, ки шӯҳрату ҷалоли Исоро дид ва дар бораи Ӯ сухан гуфт. ");
INSERT INTO tgk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ба ҳар ҳол, бисёри одамон, ҳатто аз байни мансабдорон низ ба Исо эътиқод карданд, вале аз тарси фарисиён ошкоро ба ин иқрор намешуданд, ки мабодо онҳоро аз ибодатхонаҳо ҷудо накунанд. ");
INSERT INTO tgk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Зеро онҳо назар ба таърифе, ки аз ҷониби Худо аст, таърифи инсониро беҳтар донистанд. ");
INSERT INTO tgk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Исо бо овози баланд хитоб кард: «Ҳар кӣ ба Ман имон оварад, на ба Ман, балки ба касе, ки Маро фиристодааст, имон меоварад. ");
INSERT INTO tgk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ҳар кӣ Маро мебинад, он касеро мебинад, ки Маро фиристодааст. ");
INSERT INTO tgk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ман ҳамчун равшанӣ ба ҷаҳон омадаам, то ҳар кӣ ба Ман имон оварад, дар торикӣ намонад. ");
INSERT INTO tgk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ман ҳеҷ касеро, ки суханони Маро мешунаваду иҷро намекунад, ҳукм нахоҳам кард, чунки Ман на барои ҳукм кардани ҷаҳон, балки барои наҷот додани он омадаам. ");
INSERT INTO tgk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Касе, ки Маро инкор мекунад ва суханони Маро қабул намекунад, вай аллакай ҳукмкунандаро дорад. Дар рӯзи қиёмат он суханоне, ки Ман гуфтам, ӯро ҳукм мекунанд, ");
INSERT INTO tgk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","чунки Ман аз худ сухан нагуфтаам, балки Падаре, ки Маро фиристодааст, чӣ гуфтану чӣ нақл карданамро фармон додааст. ");
INSERT INTO tgk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ва Ман медонам, ки фармони Ӯ ҳаёти абадӣ мебахшад. Бинобар ин Ман танҳо он чиро, ки Падар ба Ман фармудааст, мегӯям». ");
INSERT INTO tgk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Як рӯз пеш аз иди Балогардон Исо дид, ки вақту соати аз ин дунё рафтан ва ба пеши Падараш баргаштани Ӯ расидааст. Ӯ дар ин дунё одамони худро дӯст медошт ва муҳаббаташ нисбат ба онҳо то охир пойдор буд. ");
INSERT INTO tgk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Иблис аллакай ба дили Яҳудои писари Шимъӯни Исқарют фикри дар ҳаққи Исо хиёнат карданро ҷо карда буд. Исо медонист, ки Падар ҳама чизро ба дасти Ӯ супоридааст ва Ӯ аз ҷониби Худо омада, ба пеши Худо бармегардад. Аз ин рӯ, ҳангоми хӯроки шом ");
INSERT INTO tgk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ӯ аз сари дастархон бархеста, ҷомаашро кашиду миёни худро бо сачоқ баст. ");
INSERT INTO tgk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Пас, ба тағораи дастурӯшӯйӣ об рехта, ба шустану бо сачоқи дар миён бастааш хушк кардани пойҳои шогирдон шурӯъ кард. ");
INSERT INTO tgk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ӯ ба назди Шимъӯни Петрус омад ва Шимъӯни Петрус гуфт: «Худованд, магар Ту пойҳои маро шустанӣ ҳастӣ?!» ");
INSERT INTO tgk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Исо ҷавоб дод: «Ҳоло ту кори мекардаамро намефаҳмӣ, баъдтар мефаҳмӣ». ");
INSERT INTO tgk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Он гоҳ Петрус ба Ӯ гуфт: «Ҳаргиз пойҳои маро намешӯӣ». «Агар нашӯям, ту бо Ман шарик намешавӣ!» — ҷавоб дод Исо. ");
INSERT INTO tgk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Шимъӯни Петрус дар ҷавоб гуфт: «Худовандо, пас на фақат пойҳоямро, балки дасту сарамро низ бишӯй!» ");
INSERT INTO tgk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","«Барои касе, ки ҳаммом кардааст, танҳо пойҳояшро шустан лозим аст, чунки ӯ комилан пок аст, — гуфт Исо. — Шумо ҳам пок ҳастед, вале на ҳама». ");
INSERT INTO tgk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Зеро Ӯ медонист, ки дар ҳаққаш кӣ хиёнат мекунад ва барои ҳамин гуфт, ки на ҳама пок ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Баъд аз он ки пойҳои онҳоро шуст, либосашро пӯшиду боз ба сари дастархон нишаста гуфт: «Оё медонед, ки Ман бароятон чӣ кор кардам? ");
INSERT INTO tgk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Шумо Маро устод ва Худованд меномед ва ин дуруст аст, чунки Ман ҳамонам. ");
INSERT INTO tgk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Пас, агар Ман, ки Худованд ва устоди шумо ҳастам, пойҳои шуморо шуста бошам, шумо низ бояд пойҳои якдигарро бишӯед. ");
INSERT INTO tgk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ман ба шумо намунаи ибрат шудам, ки шумо айнан мисле ки Ман нисбат ба шумо рафтор кардам, рафтор кунед. ");
INSERT INTO tgk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ба шумо рост мегӯям, ки хизматгор аз хоҷаи худ ва фиристодашуда аз шахсе, ки ӯро фиристодааст, бузургтар нест. ");
INSERT INTO tgk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Акнун ки шумо ин чизҳоро медонед, хушбахт мешавед, агар онҳоро ба амал оваред. ");
INSERT INTO tgk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ман на дар бораи ҳамаи шумо мегӯям; Ман касони интихобкардаамро медонам. Вале, бигзор, суханон аз навиштаҷот ба амал оянд: „Касе ки нони Маро мехӯрд, бар зидди Ман даст бардошт“. ");
INSERT INTO tgk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Инро ҳоло пеш аз рӯй доданаш ба шумо мегӯям, то ки ҳангоми ба амал омадани ин ҳодиса имон оваред, ки ин Ман ҳастам. ");
INSERT INTO tgk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ба шумо рост мегӯям, ҳар кӣ фиристодаи Маро қабул кунад, Маро қабул мекунад ва ҳар кӣ Маро қабул кунад, фиристандаи Маро қабул мекунад». ");
INSERT INTO tgk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Инро гуфта, Исо сахт безобита шуду эълон кард: «Ба шумо рост мегӯям, яке аз шумо ба Ман хиёнат мекунад». ");
INSERT INTO tgk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Шогирдон ба якдигар нигоҳ карда, дар ҳайрат монданд, ки Ӯ инро дар бораи кӣ гуфта бошад. ");
INSERT INTO tgk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Яке аз шогирдон, ки Исо ӯро дӯст медошт, дар паҳлӯи Ӯ такя карда нишаста буд. ");
INSERT INTO tgk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Шимъӯни Петрус ба ӯ ишора кард, то аз Исо бипурсад, ки Ӯ инро дар бораи кӣ гуфт. ");
INSERT INTO tgk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Он шогирд ба Исо наздиктар шуда пурсид: «Худованд, ин кист?» ");
INSERT INTO tgk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Исо ҷавоб дод: «Ба кӣ луқмаи нонро дар коса тар карда диҳам, ҳамон аст». Баъд луқмаи нонро тар карда, ба Яҳудои писари Шимъӯни Исқарют дод. ");
INSERT INTO tgk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ҳамин ки Яҳудо луқмаи нонро гирифт, иблис ба вуҷуди ӯ дохил шуд. Исо ба ӯ гуфт: «Он ниятеро, ки дар дил дорӣ, зудтар иҷро бикун». ");
INSERT INTO tgk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ҳеҷ касе аз онҳое, ки дар сари дастархон буданд, нафаҳмиданд, ки барои чӣ Исо ба ӯ ин суханро гуфт. ");
INSERT INTO tgk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Азбаски хазинаи пул дар дасти Яҳудо буд, баъзеҳо гумон карданд, ки Исо ба ӯ фармуд, то ҳар чӣ барои ид лозим аст, барояшон бихарад ё ки ба бенавоён чизе бидиҳад. ");
INSERT INTO tgk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Яҳудо нонро гирифта, ҳамон замон берун баромад. Шаб буд. ");
INSERT INTO tgk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Вақте ки ӯ берун баромад, Исо гуфт: «Акнун Фарзанди Инсон шӯҳрату ҷалол ёфт ва Худо низ ба воситаи Ӯ шӯҳрату ҷалол ёфт. ");
INSERT INTO tgk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Агар Худо дар Ӯ шӯҳрату ҷалол ёфта бошад, пас Худо низ дар худ Ӯро шӯҳрату ҷалол медиҳад ва фавран инро мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Эй фарзандонам, муддати кам мондааст, ки Ман ҳамроҳи шумо мемонам. Шумо Маро ҷустуҷӯ хоҳед кард, вале, чӣ тавре ки ба роҳбарони яҳудӣ гуфта будам, акнун ба шумо низ мегӯям, ба он ҷое, ки Ман меравам, шумо омада наметавонед. ");
INSERT INTO tgk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ман ба шумо фармони нав медиҳам, ки якдигарро дӯст доред. Ҳамон тавре ки Ман шуморо дӯст доштам, шумо низ якдигарро дӯст доред. ");
INSERT INTO tgk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Агар нисбат ба якдигар муҳаббат дошта бошед, ҳама хоҳанд фаҳмид, ки шумо шогирдони Ман ҳастед». ");
INSERT INTO tgk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Шимъӯни Петрус аз Ӯ пурсид: «Худованд, Ту ба куҷо меравӣ?» «Ба ҷое, ки Ман меравам, ту ҳоло аз паси Ман омада наметавонӣ, — ҷавоб дод Исо, — аммо баъдтар хоҳӣ омад». ");
INSERT INTO tgk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Петрус ба Ӯ гуфт: «Худованд! Чаро ман ҳоло аз паси Ту рафта наметавонам? Ман тайёрам ҷони худро барои Ту фидо кунам!» ");
INSERT INTO tgk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Исо ҷавоб дод: «Ҷонатро фидои Ман мекунӣ?! Ба ту рост мегӯям, ки пеш аз ҷеғ задани хурӯс ту се бор Маро инкор хоҳӣ кард!» ");
INSERT INTO tgk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Исо суханашро давом дода гуфт: «Бигзор дилҳоятонро ғаму ғусса фаро нагирад! Ба Худо имон оваред ва ба Ман низ имон оваред! ");
INSERT INTO tgk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Дар хонаи Падари Ман ҳуҷраҳо бисёранд. Агар чунин намебуд, магар Ман ба шумо мегуфтам, ки рафта, барои шумо ҷой тайёр мекунам? ");
INSERT INTO tgk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Вақте ки Ман меравам ва барои шумо ҷой тайёр мекунам, баргашта, шуморо пеши худ мебарам, то дар ҷое, ки Ман ҳастам, шумо ҳам бошед. ");
INSERT INTO tgk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Роҳ ба он ҷое, ки Ман меравам, барои шумо маълум аст». ");
INSERT INTO tgk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Он гоҳ Тумо ба Ӯ гуфт: «Худовандо, мо намедонем, ки Ту ба куҷо меравӣ. Пас роҳро аз куҷо дониста метавонем?» ");
INSERT INTO tgk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Исо ба ӯ гуфт: «Ман роҳ, ростӣ ва ҳаёт ҳастам. Ҳеҷ кас пеши Падар намеояд, магар ин ки фақат ба воситаи Ман. ");
INSERT INTO tgk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Модоме ки шумо Маро мешиносед, Падарамро ҳам мешиносед. Аз имрӯз эътиборан шумо Ӯро мешиносед ва ҳатто Ӯро дидаед!» ");
INSERT INTO tgk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","«Худовандо! — гуфт ба Ӯ Филиппус, — Падарро ба мо нишон деҳ ва ин бароямон кифоя аст». ");
INSERT INTO tgk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Исо дар ҷавоб гуфт: «Ман ин қадар ҳамроҳи шумо будам ва ту, Филиппус, Маро то ҳол намешиносӣ? Ҳар кӣ Маро дида бошад, Падарро дидааст. Пас чӣ гуна ту „Падарро ба мо нишон деҳ“ мегӯӣ? ");
INSERT INTO tgk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Магар бовар намекунӣ, ки Ман дар Падар ҳастам ва Падар дар Ман аст? Суханонеро, ки Ман ба шумо мегӯям, аз худам намегӯям. Падарам, ки дар Ман аст, корҳои худро иҷро мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ба Ман бовар кунед, ки Ман дар Падар ҳастам ва Падар дар Ман аст. Вагарна ба хотири он корҳое, ки мекунам, бовар кунед. ");
INSERT INTO tgk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ба шумо рост мегӯям, ҳар кӣ ба Ман имон оварад, корҳоеро, ки Ман мекунам, вай ҳам мекунад ва ҳатто корҳои бузургтар аз он мекунад, чунки Ман ба назди Падарам меравам. ");
INSERT INTO tgk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Инчунин ҳар чиро, ки аз номи Ман талаб кунед, Ман иҷро мекунам, то ки шӯҳрату ҷалоли Падар дар Писар намоён гардад. ");
INSERT INTO tgk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Агар аз номи Ман чизеро аз Ман талаб кунед, онро иҷро хоҳам кард. ");
INSERT INTO tgk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Агар шумо Маро дӯст доред, фармонҳои Маро иҷро мекунед. ");
INSERT INTO tgk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Он гоҳ Ман аз Падарам хоҳиш мекунам ва Ӯ ба шумо Мададгори дигареро медиҳад, ки то абад бо шумо мемонад. ");
INSERT INTO tgk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ин Рӯҳи ростӣ аст, ки ҷаҳон Ӯро қабул карда наметавонад, чунки Ӯро на мебинаду на мешиносад. Вале шумо Ӯро мешиносед, чун Вай ҳамроҳи шумо аст ва дар шумо мешавад. ");
INSERT INTO tgk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ман шуморо бепарастор намегузорам: боз ба назди шумо бармегардам. ");
INSERT INTO tgk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Пас аз андаке ҷаҳон Маро дигар намебинад, вале шумо Маро хоҳед дид. Азбаски Ман зиндаам, шумо ҳам зинда мешавед. ");
INSERT INTO tgk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Дар он рӯз медонед, ки Ман дар Падарам ҳастам ва шумо дар Ман ҳастед ва Ман дар шумо. ");
INSERT INTO tgk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ҳар кӣ бо фармонҳои Ман розӣ шаваду онҳоро иҷро кунад, вай касест, ки Маро дӯст медорад ва ҳар кӣ Маро дӯст дорад, ӯро Падари Ман ҳам дӯст медорад. Ман низ ӯро дӯст медорам ва худро ба ӯ ошкор мекунам». ");
INSERT INTO tgk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Яҳудо (на Исқарют) гуфт: «Худовандо, ин чӣ тавр мешавад, ки Ту худро ба мо зоҳир мекунӣ, аммо на ба ҷаҳон?» ");
INSERT INTO tgk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Исо дар ҷавоби ӯ гуфт: «Ҳар кӣ Маро дӯст дорад, каломи Маро риоя мекунад. Он гоҳ Падари Ман ҳам ӯро дӯст медорад. Мо пеши ӯ меоем ва дар наздаш ҷой мегирем. ");
INSERT INTO tgk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Касе ки Маро дӯст намедорад, суханони Маро иҷро намекунад. Он сухане, ки шумо мешунавед, аз Ман нест, балки сухани Падар аст, ки Маро фиристодааст. ");
INSERT INTO tgk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ман ин суханонро ба шумо ҳанӯз, ки бо шумо ҳастам, мегӯям. ");
INSERT INTO tgk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Вале Мададгор, Рӯҳи Муқаддас, ки Ӯро Падар аз номи Ман ба шумо мефиристад, ҳама чизро ба шумо ёд медиҳад ва ҳар сухани Маро ба хотири шумо меоварад. ");
INSERT INTO tgk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ман оромиро бо шумо мемонам, оромии худамро ба шумо медиҳам. Ман онро ба шумо на ба он тавре медиҳам, ки ҷаҳон медиҳад. Ғаму ғуссаро аз дилҳоятон дур кунеду ҳаросон нашавед! ");
INSERT INTO tgk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Шумо аллакай суханони Маро шунида будед, ки Ман меравам ва ба назди шумо бармегардам, гуфта будам. Агар Маро дӯст медоштед, хурсанд мешудед, ки Ман ба пеши Падар меравам, зеро Падар аз Ман бузургтар аст. ");
INSERT INTO tgk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ана Ман инро пеш аз ба амал омаданаш ба шумо гуфтам, то вақте ки ин ҳодиса ба амал меояд, имон оваред! ");
INSERT INTO tgk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ман дигар вақти дароз бо шумо гап намезанам, чунки ҳукмрони ин ҷаҳон омада истодааст. Вай бар Ман ҳеҷ қудрате надорад, ");
INSERT INTO tgk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","вале Ман аз рӯи фармони Падар, ки ба Ман додааст, ин корро мекунам, то ҷаҳон бидонад, ки Ман Падарро дӯст медорам. Бархезед, биёед, аз ин ҷо меравем!» ");
INSERT INTO tgk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Исо суханашро давом дода гуфт: «Ман токи ҳақиқӣ ҳастам ва Падари Ман токпарвар аст. ");
INSERT INTO tgk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ҳар шохаеро, ки дар Ман ҳосил намедиҳад, Ӯ бурида мепартояд ва ҳар шохаи ҳосилдиҳандаро хомток мекунад, то меваи бештаре ба бор оварад. ");
INSERT INTO tgk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Шумо аллакай ба воситаи суханоне, ки Ман ба шумо гуфтаам, пок шудаед. ");
INSERT INTO tgk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Дар Ман бимонед, чунон ки Ман дар шумо ҳастам. Ҳамон тавр ки шоха, агар дар ток набошад, аз худ ҳосил ба бор оварда наметавонад, ҳамчунин шумо низ, агар дар Ман намонед, аз худ самара оварда наметавонед. ");
INSERT INTO tgk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ман ток ҳастам ва шумо шохаҳо ҳастед. Танҳо онҳое, ки дар Ман ҳастанд ва Ман дар онҳо ҳастам, ҳосили фаровон ба бор меоваранд, чунки бе Ман шумо ҳеҷ коре карда наметавонед. ");
INSERT INTO tgk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ҳар кӣ дар Ман намонад, монанди шоха партофта шуда, баъд хушк мешавад. Чунин шохаҳоро ҷамъ карда, ба оташ мепартоянду месӯзонанд. ");
INSERT INTO tgk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Агар шумо дар Ман бимонед ва суханони Ман дар шумо бимонанд, ҳар чизеро, ки талаб кунед, бароятон иҷро мешавад! ");
INSERT INTO tgk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Падари Ман бо он шӯҳрату ҷалол меёбад, ки шумо самари зиёд меоваред ва бо ин нишон медиҳед, ки шогирдони Ман ҳастед. ");
INSERT INTO tgk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Чӣ тавре ки Падар Маро дӯст медорад, ҳамон тавр Ман ҳам шуморо дӯст медорам. Дар муҳаббати Ман бимонед! ");
INSERT INTO tgk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Айнан чӣ тавре ки Ман фармонҳои Падарамро иҷро кардаму дар муҳаббаташ мондам, шумо низ агар фармонҳои Маро иҷро кунед, дар муҳаббати Ман мемонед. ");
INSERT INTO tgk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ман инро ба шумо барои он гуфтам, ки шодии Ман дар шумо бошад ва шодии шумо пурра гардад. ");
INSERT INTO tgk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Фармони Ман ин аст: чуноне ки Ман шуморо дӯст медорам, ҳамон тавр шумо якдигарро дӯст доред. ");
INSERT INTO tgk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Аз он муҳаббате, ки кас ҷонашро барои дӯстонаш фидо мекунад, муҳаббати бузургтаре нест. ");
INSERT INTO tgk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Агар фармонҳои Маро иҷро кунед, шумо дӯстони Ман ҳастед. ");
INSERT INTO tgk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ман дигар шуморо хизматгор наменомам, зеро хизматгор намедонад, ки хоҷаи ӯ ба чӣ кор машғул аст. Лекин Ман шуморо дӯстони худ мехонам, чунки ҳама чизи аз Падар шунидаамро ба шумо гуфтаам. ");
INSERT INTO tgk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Шумо Маро интихоб накардаед, балки Ман шуморо интихоб карда, таъин намудаам, ки рафта мева биёред ва мевае, ки то абад мемонад. Инак, ҳар чи ба номи Ман аз Падар талаб кунед, Ӯ ба шумо бидиҳад. ");
INSERT INTO tgk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Пас, фармони Ман барои шумо ин аст, ки ҳамдигарро дӯст доред». ");
INSERT INTO tgk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Агар ҷаҳон аз шумо нафрат кунад, донед, ки аввал аз Ман нафрат дошта буд. ");
INSERT INTO tgk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Агар шумо аз ин ҷаҳон мебудед, ҷаҳон шуморо ҳамчун аз они худ дӯст медошт. Вале, аз сабаби он ки Ман шуморо аз ин ҷаҳон интихоб карда гирифтам ва шумо аз ин ҷаҳон нестед, ин ҷаҳон аз шумо нафрат дорад. ");
INSERT INTO tgk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Дар хотир доред, ки Ман ба шумо чӣ гуфта будам: „Хизматгор аз хоҷаи худ бузургтар нест“. Пас, агар Маро барои азоб додан дунболагирӣ карда бошанд, шуморо низ дунболагирӣ мекунанд. Агар суханони Маро иҷро карда бошанд, суханони шуморо низ иҷро мекунанд. ");
INSERT INTO tgk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Аммо мардум ҳамаи инро бо шумо аз барои Ман мекунанд, чунки фиристандаи Маро намешиносанд. ");
INSERT INTO tgk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Агар Ман ба ҷаҳон намеомадам ва ба онҳо сухане намегуфтам, онҳо гуноҳе намедоштанд, вале акнун барои сафед кардани гуноҳи худ баҳона надоранд. ");
INSERT INTO tgk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Касе, ки аз Ман нафрат мекунад, аз Падари Ман низ нафрат дорад. ");
INSERT INTO tgk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Агар Ман дар байни онҳо он корҳоеро, ки касе накардааст, намекардам, онҳо гуноҳ намедоштанд. Вале акнун онҳо он корҳоро диданд ва бо вуҷуди ин аз Ман ва ҳам аз Падарам нафрат доранд. ");
INSERT INTO tgk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ин барои иҷро шудани гуфтаҳои шариати онҳо ба амал меояд, ки гуфта шудааст: „Бесабаб аз ман нафрат доштанд“. ");
INSERT INTO tgk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Вале, вақте Мададгоре, ки Ман аз ҷониби Падар Ӯро назди шумо мефиристам, меояд, яъне Рӯҳи ростӣ, ки аз Падар мебарояд, дар бораи Ман шаҳодат медиҳад. ");
INSERT INTO tgk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Инчунин шумо ҳам шаҳодат медиҳед, зеро шумо аз рӯзҳои аввал бо Ман будед». ");
INSERT INTO tgk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Исо суханашро давом дода гуфт: «Ман инро ба шумо барои он гуфтам, ки роҳзада нашавед. ");
INSERT INTO tgk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Шуморо аз ибодатхонаҳо ҷудо мекунанд. Ҳатто чунон замоне фаро мерасад, ки кушандагони шумо фикр мекунанд, ки бо ин корашон ба Худо хизмат мекунанд. ");
INSERT INTO tgk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Онҳо аз сабаби он чунин рафтор мекунанд, ки на Падар ва на Маро мешиносанд. ");
INSERT INTO tgk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Аммо Ман ин чизҳоро ба шумо барои он гуфтам, ки ҳангоми расидани ин вақт шумо ба хотир оред, ки Ман дар бораи онҳо ба шумо гуфта будам. Аз аввал дар бораи ин чизҳо ба шумо нагуфтам, чунки ҳамроҳи шумо будам. ");
INSERT INTO tgk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Акнун пеши он касе меравам, ки Маро фиристодааст. Вале ҳеҷ касе аз шумо ба Ман савол намедиҳад, ки „Ту ба куҷо меравӣ?“, ");
INSERT INTO tgk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","чунки суханони Ман дилҳои шуморо пур аз ғам карданд. ");
INSERT INTO tgk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Аммо Ман ба шумо рост мегӯям: рафтани Ман барои фоидаи шумост. Зеро, агар Ман наравам, Мададгор пеши шумо намеояд ва агар биравам, Ӯро ба назди шумо мефиристам. ");
INSERT INTO tgk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Вақте ки Ӯ меояд, фикрронии нодурусти ин ҷаҳонро дар бораи гуноҳ, ростӣ ва ҳукмкунӣ фош мекунад: ");
INSERT INTO tgk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","гуноҳ дар ин аст, ки онҳо ба Ман имон намеоваранд; ");
INSERT INTO tgk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ростӣ дар ин аст, ки Ман ба пеши Падарам меравам ва шумо дигар Маро намебинед; ");
INSERT INTO tgk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ҳукмкунӣ дар ин аст, ки ҳукмрони ин ҷаҳон аллакай айбдор шудааст. ");
INSERT INTO tgk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ман боз бисёр чизи ба шумо гуфтанӣ дорам, аммо алҳол шумо онҳоро ғунҷонда наметавонед. ");
INSERT INTO tgk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Вақте ки Рӯҳи ростӣ меояд, Ӯ шуморо сӯи тамоми ростӣ роҳнамоӣ мекунад, зеро Ӯ аз худ чизе намегӯяд, балки он чиро, ки мешунавад, ба шумо мегӯяд. Ӯ ба шумо дар бораи ҳодисаҳои оянда хабар медиҳад. ");
INSERT INTO tgk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ӯ Маро шӯҳрату ҷалол медиҳад, зеро Ӯ гуфтаҳои Маро гирифта, ба шумо нақл мекунад. ");
INSERT INTO tgk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ҳар чӣ Падар дорад, аз они Ман аст. Аз ин сабаб Ман гуфтам, ки Ӯ гуфтаҳои Маро гирифта, ба шумо нақл мекунад». ");
INSERT INTO tgk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Баъд аз андаке шумо Маро дигар намебинед, вале баъд аз андаки дигар Маро боз хоҳед дид». ");
INSERT INTO tgk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Он гоҳ баъзе аз шогирдон ба ҳамдигар гуфтанд: «Ӯ „баъд аз андаке шумо Маро дигар намебинед, вале баъд аз андаки дигар Маро боз хоҳед дид“ ва „чунки Ман ба пеши Падар меравам“ гуфта чиро дар назар дорад? ");
INSERT INTO tgk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ӯ „андаке“ гуфта чиро дар назар дорад? Мо намефаҳмем, Ӯ дар бораи чӣ гуфта истодааст». ");
INSERT INTO tgk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Исо фаҳмид, ки онҳо ба Ӯ савол доданӣ ҳастанд, бинобар ин гуфт: «Шумо аз якдигар мепурсед, ки „баъд аз андаке шумо Маро дигар намебинед, вале баъд аз андаки дигар Маро боз хоҳед дид“ гуфта чиро дар назар доштам? ");
INSERT INTO tgk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ба шумо рост мегӯям, ки шумо гиря карда, андӯҳгин мешавед, вале ҷаҳон шодӣ мекунад. Шумо ғамгин мешавед, аммо ғами шумо ба шодӣ мубаддал мегардад. ");
INSERT INTO tgk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ҳангоми таваллуди кӯдак зан ғамгин мешавад, чун соати азоби вай расидааст, вале вақте ки кӯдакро мезояд, азобу шиканҷаро фаромӯш карда, шодӣ мекунад, ки инсоне ба дунё омадааст. ");
INSERT INTO tgk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Инак, шумо ҳам ҳоло ғамгин ҳастед, аммо Ман шуморо боз мебинам ва дилҳои шумо аз шодӣ пур мешаванд ва он шодиро ҳеҷ кас аз шумо гирифта наметавонад. ");
INSERT INTO tgk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Он рӯз шумо аз Ман чизе намепурсед. Ба шумо рост мегӯям, ҳар чиро ки бо номи Ман аз Падар талаб кунед, Ӯ ба шумо хоҳад дод. ");
INSERT INTO tgk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","То кунун шумо аз номи Ман чизеро талаб накардаед. Талаб кунед ва ба даст меоваред ва хурсандии шумо пурра мешавад». ");
INSERT INTO tgk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Ман дар ин бора ба шумо бо рамзҳо гуфтам, лекин замоне фаро мерасад, ки ба шумо на бо рамзҳо, балки кушоду равшан дар бораи Падар нақл мекунам. ");
INSERT INTO tgk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Дар он рӯз бо номи Ман аз Ӯ талаб мекунед. Ман намегӯям, ки барои шумо аз Падар талаб мекунам, ");
INSERT INTO tgk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","зеро худи Падар шуморо дӯст медорад, аз сабаби он ки шумо Маро дӯст доштед ва имон овардед, ки Ман аз ҷониби Ӯ омадаам. ");
INSERT INTO tgk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ман аз ҷониби Падар ба ин ҷаҳон омадаам ва боз ин ҷаҳонро тарк карда, ба назди Ӯ меравам». ");
INSERT INTO tgk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","«Акнун Шумо кушоду равшан ва бе рамзҳо гап зада истодаед, — гуфтанд ба Ӯ шогирдон. ");
INSERT INTO tgk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","— Ҳоло мо фаҳмидем, ки Шумо ҳама чизро медонед ва ҳоҷати аз Шумо пурсидан нест. Бинобар ин мо имон дорем, ки Шумо аз назди Худо омадаед». ");
INSERT INTO tgk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","«Шумо акнун имон овардед? — гуфт дар ҷавоби онҳо Исо. ");
INSERT INTO tgk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","— Инак вақту соате меояд ва он аллакай фаро расидааст, ки ҳамаи шумо пароканда шуда ба хонаҳои худ меравед ва Маро танҳо мегузоред. Вале Ман танҳо нестам, зеро Падар ҳамроҳи Ман аст. ");
INSERT INTO tgk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ман ин чизҳоро ба шумо гуфтам, то ки шумо дар Ман оромӣ пайдо кунед. Дар дунё шуморо азобу уқубат интизор аст, вале шумо мардонагиро аз даст надиҳед: Ман бар ин ҷаҳон ғолиб шудаам!» ");
INSERT INTO tgk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Баъд аз ин суханон Исо ба сӯи осмон нигоҳ карда гуфт: «Эй Падар, вақт фаро расид. Писари худро шӯҳрату ҷалол деҳ, то ки Писар Туро шӯҳрату ҷалол бидиҳад, ");
INSERT INTO tgk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","чунки Ту ихтиёри ҳамаи одамонро ба дасти Ӯ супоридаӣ, то ки Ӯ низ ба ҳамаи касоне, ки ба Ӯ бахшидаӣ, ҳаёти абадӣ диҳад. ");
INSERT INTO tgk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ва ҳаёти абадӣ ин аст, ки Туро, Худои ягонаи ҳақиқӣ ва Исои Масеҳро, ки Ту фиристодаӣ, шиносанд. ");
INSERT INTO tgk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ман бо анҷом додани он коре, ки Ту ба Ман супорида будӣ, бароят дар рӯи замин шӯҳрат додам. ");
INSERT INTO tgk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Акнун, эй Падар, он шӯҳрату ҷалолеро, ки пеш аз пайдоиши олам дар назди Ту доштам, ба Ман бидеҳ. ");
INSERT INTO tgk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ман номи Туро ба он касоне, ки Ту аз ҷаҳон гирифта, ба Ман бахшидаӣ, маълум кардам. Онҳо аз они Ту буданду Ту онҳоро ба Ман бахшидӣ ва онҳо каломи Туро риоя карданд. ");
INSERT INTO tgk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Акнун онҳо медонанд, ки ҳама чизи ба Ман додаат, аз они туст. ");
INSERT INTO tgk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Зеро он каломеро, ки Ту ба Ман додӣ, Ман ба онҳо расондам ва онҳо қабул карда, дар ҳақиқат фаҳмиданд, ки Ман аз назди Ту омадаам ва боварӣ доранд, ки Ту Маро фиристодаӣ. ");
INSERT INTO tgk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ман барои онҳо дуо мекунам. Ман на барои ҷаҳон, балки барои онҳое дуо мекунам, ки Ту ба Ман додаӣ, чунки онҳо аз они туанд. ");
INSERT INTO tgk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Зеро ҳамаи онҳое, ки Ман дорам, аз они туанд ва онҳое, ки Ту дорӣ, аз они Мананд ва ба василаи онҳо Ман шӯҳрату ҷалол ёфтам. ");
INSERT INTO tgk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ман дигар дар ин ҷаҳон нестам, балки пеши Ту меравам, вале онҳо дар ин ҷаҳон мемонанд. Эй Падари Муқаддас, бо қудрати номи худ, ки Ту ба Ман додаӣ, онҳоро муҳофизат бикун, то онҳо як бошанд, чунон ки Ману Ту бо ҳам як ҳастем. ");
INSERT INTO tgk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","То вақте ки Ман бо онҳо будам, онҳоро бо қудрати номи ту, ки ба Ман бахшидаӣ, муҳофизат ва нигаҳбонӣ кардам. Аз онҳо касе ҳам ҳалок нашуд, ғайр аз як нафар, ки бояд ҳалок мешуд, то гуфтаҳои навиштаҷот ба амал оянд. ");
INSERT INTO tgk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Вале акнун Ман назди Ту меравам ва ин чизҳоро ҳанӯз ки дар ин ҷаҳон ҳастам, мегӯям, то шодии Ман дар онҳо пурра шавад. ");
INSERT INTO tgk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ман каломи Туро ба онҳо расондаам ва ҷаҳон аз онҳо нафрат кард, чунки онҳо аз ин ҷаҳон нестанд, ҳамон тавр ки Ман ҳам аз ин ҷаҳон нестам. ");
INSERT INTO tgk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ман талаб намекунам, ки Ту онҳоро аз ҷаҳон бибарӣ, аммо мехоҳам, ки онҳоро аз иблис муҳофизат намоӣ. ");
INSERT INTO tgk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Онҳо аз ин ҷаҳон нестанд, чунон ки Ман ҳам аз ин ҷаҳон нестам. ");
INSERT INTO tgk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Тавассути ростӣ онҳоро барои худ ҷудо кун; каломи Ту ростӣ аст. ");
INSERT INTO tgk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Чунон ки Ту Маро ба ҷаҳон фиристодаӣ, ҳамин тавр Ман ҳам онҳоро ба ҷаҳон фиристодаам. ");
INSERT INTO tgk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ман ба хотири онҳо худро ба Ту бахшидам, то ки онҳо низ ба тавассути ростӣ худро ба Ту бахшида тавонанд. ");
INSERT INTO tgk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ман на фақат барои онҳо дуо мекунам, балки барои касоне ҳам, ки ба воситаи суханони онҳо ба Ман имон меоваранд. ");
INSERT INTO tgk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Бигзор ҳамаи онҳо як шаванд. Бигзор, чӣ тавре ки ту, Падар, дар Ман ҳастӣ ва Ман дар Ту ҳастам, онҳо низ дар мо бошанд, то ҷаҳон имон оварад, ки Маро Ту фиристодаӣ. ");
INSERT INTO tgk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ман ба онҳо ҳамон шӯҳрату ҷалолеро додаам, ки Ту ба Ман додаӣ, то онҳо як бошанд, чунон ки Ману Ту як ҳастем. ");
INSERT INTO tgk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ман дар онҳо ҳастам ва Ту дар Ман ҳастӣ, то онҳо дар ягонагии комил бошанду ҷаҳон бидонад, ки Ту Маро фиристодаӣ ва онҳоро ҳамон тарз дӯст медорӣ, ки Маро дӯст медорӣ. ");
INSERT INTO tgk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Эй Падар, мехоҳам, онҳое ҳам, ки Ту ба Ман бахшидаӣ, ҳамроҳи Ман дар он ҷое бошанд, ки Ман мешавам ва он шӯҳрату ҷалолеро бубинанд, ки Ту ба Ман додаӣ, зеро Ту Маро пеш аз офариниши олам дӯст дошта будӣ. ");
INSERT INTO tgk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Эй Падари одил, ҷаҳон Туро нашинохт, вале Ман Туро мешиносам ва онҳо медонанд, ки Ту Маро фиристодаӣ. ");
INSERT INTO tgk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ман ба онҳо Туро ошкор кардам ва боз ҳам ошкор мекунам, то он муҳаббате, ки Ту нисбат ба Ман дорӣ, дар онҳо низ бошад ва Ман ҳам дар онҳо бошам». ");
INSERT INTO tgk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Пас аз ин суханон Исо ҳамроҳи шогирдонаш баромада, ба канори дигари водии Қидрун гузашт. Дар он ҷо боғе буд ва Исо бо шогирдонаш ба он боғ даромад. ");
INSERT INTO tgk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Яҳудо, ки ба Исо хиёнат кард, низ он ҷоро медонист, чунки Исо ва шогирдонаш бисёр вақт дар он ҷо ҷамъ меомаданд. ");
INSERT INTO tgk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Инак, Яҳудо дастаи аскарони румӣ ва посбонони Хонаи Худоро, ки аз тарафи сардорони рӯҳонӣ ва фарисиён фиристода шуданд, бо худ ба он ҷо овард. Онҳо ҳама мусаллаҳ буданд ва дар даст фонусу машъал бардошта меомаданд. ");
INSERT INTO tgk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Исо медонист, ки бо Ӯ чӣ ҳодиса рӯй медиҳад, бинобар ин ба пеши онҳо баромада, пурсид: «Шумо киро ҷустуҷӯ мекунед?» ");
INSERT INTO tgk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Онҳо ҷавоб доданд: «Исои Носириро». «Ин Манам», — ҷавоб дод Исо. Яҳудо, ки ба Исо хиёнат кард, низ ҳамроҳи онҳо буд. ");
INSERT INTO tgk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ҳамин ки Исо «Ин Манам» гуфт, онҳо ақибнокӣ рафта, ба замин афтоданд. ");
INSERT INTO tgk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Исо боз аз онҳо пурсид: «Шумо киро ҷустуҷӯ мекунед?» «Исои Носириро», — гуфтанд онҳо. ");
INSERT INTO tgk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","«Ман ба шумо гуфтам, ки ин Ман ҳастам. Агар барои шумо Ман лозим бошам, пас монед, ки ин одамон раванд». ");
INSERT INTO tgk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ӯ барои он ин тавр гуфт, то суханони «Аз он касоне, ки Ту ба Ман бахшидӣ, касеро аз даст надодам» гуфтааш иҷро шаванд. ");
INSERT INTO tgk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Шимъӯни Петрус, ки шамшер дошт, онро аз ғилоф кашида, ғуломи сарвари рӯҳониёнро заду гӯши рости ӯро бурида партофт. Он ғулом Малҳус ном дошт. ");
INSERT INTO tgk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Исо ба Петрус гуфт, ки шамшерашро ба ғилофаш андозад. Инчунин илова кард: «Наход, ки аз косаи азобе, ки Падарам барои Ман додааст, нанӯшам?» ");
INSERT INTO tgk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Он гоҳ дастаи аскарони румӣ бо фармондеҳи худ ва посбонони яҳудӣ Исоро дастгир карда бастанд. ");
INSERT INTO tgk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Аввал Ӯро назди Ҳонон, падарарӯси Қаёфо бурданд, ки ҳамон сол сарвари рӯҳониён буд. ");
INSERT INTO tgk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Қаёфо ин ҳамон шахсе буд, ки ба ҳукуматдорони яҳудӣ маслиҳат дод, ки агар ба ҷои тамоми мардум як нафар бимирад, беҳтар аст. ");
INSERT INTO tgk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Шимъӯни Петрус ва як шогирди дигари Исо аз паси Ӯ рафтанд. Он шогирд бо сарвари рӯҳониён ошноӣ дошт, бинобар ин ҳамроҳи Исо ба ҳавлии сарвари рӯҳониён даромад. ");
INSERT INTO tgk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Вале Петрус дар беруни ҳавлӣ, дар назди дарвоза истод. Пас он шогирде, ки бо сарвари рӯҳониён ошноӣ дошт, баромада, бо зане, ки дарвозабон буд, гуфтугӯ карда, Петрусро ба ҳавлӣ даровард. ");
INSERT INTO tgk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Зани дарвозабон ба Петрус гуфт: «Оё ту аз шогирдони он кас нестӣ?» «Не, нестам», — ҷавоб дод Петрус. ");
INSERT INTO tgk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Азбаски ҳаво хунук буд, хизматгорон ва посбонон гулхан даргиронда, дар гирди он худро гарм мекарданд. Петрус низ дар паҳлӯи онҳо истода, худро гарм мекард. ");
INSERT INTO tgk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Сарвари рӯҳониён аз Исо дар бораи шогирдон ва таълимоти Ӯ пурсуҷӯ кард. ");
INSERT INTO tgk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Исо дар ҷавоб гуфт: «Ман дар пеши ҳама ошкоро сухан гуфтаам. Ман доимо дар ибодатхонаҳо ва дар Хонаи Худо, ки ҳамаи мардум ҷамъ мешаванд, таълим медодам ва пинҳонӣ чизе нагуфтаам. ");
INSERT INTO tgk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Пас, чаро шумо аз Ман мепурсед? Аз шунавандагон бипурсед, ки Ман дар бораи чӣ ба онҳо гуфтаам. Онҳо медонанд, ки Ман чӣ гуфтаам». ");
INSERT INTO tgk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ҳангоме ки Ӯ ин суханонро гуфт, яке аз посбонони дар паҳлӯяш истода Исоро торсакӣ зада, гуфт: «Ту чӣ тавр ба сарвари рӯҳониён гап гардонда метавонӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","«Агар чизе нодуруст гуфта бошам, бигӯ, ки хатои Ман дар чист, — ҷавоб дод Исо. — Вале агар дуруст гуфта бошам, чаро Маро мезанӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Он гоҳ Ҳонон Исои дастбастаро ба назди Қаёфои сарвари рӯҳониён фиристод. ");
INSERT INTO tgk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Шимъӯни Петрус бошад, дар ҷои пештарааш истода, худро гарм мекард. Аз ӯ пурсиданд: «Магар ту ҳам аз шогирдони Ӯ нестӣ?» Вале Петрус инро инкор карда, «не» ҷавоб дод. ");
INSERT INTO tgk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","«Магар туро дар боғ бо Ӯ надида будам?» — гуфт яке аз хизматгорони сарвари рӯҳониён, хеши ҳамон касе, ки гӯшашро Петрус бурида буд. ");
INSERT INTO tgk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Петрус боз инкор кард. Ҳамон лаҳза хурӯс ҷеғ зад. ");
INSERT INTO tgk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Пагоҳии барвақт Исоро аз назди Қаёфо ба қасри ҳокими румӣ бурданд. Онҳое, ки Ӯро оварданд, ба хотири он ки ҳаром нашаванду хӯроки иди Балогардонро хӯрда тавонанд, ба қаср надаромаданд. ");
INSERT INTO tgk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Пас, Пилотус ба назди онҳо баромада, гуфт: «Айби ин одам дар чист?» ");
INSERT INTO tgk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Онҳо ҷавоб доданд: «Агар Ӯ ҷинояткор намебуд, магар ба дасти шумо месупоридем?» ");
INSERT INTO tgk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","«Худатон Ӯро гирифта аз рӯи қонунатон ҳукм кунед», — гуфт ба онҳо Пилотус. «Ба мо раво нест, ки касеро ба қатл расонем», — ҷавоб доданд роҳбарони яҳудӣ. ");
INSERT INTO tgk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Ҳамаи ин барои он рӯй дод, то суханони Исо, ки дар бораи тарзи маргаш гуфта буд, иҷро шаванд). ");
INSERT INTO tgk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Пилотус ба қаср баргашт ва Исоро ҷеғ зада гуфт: «Оё Ту Шоҳи Яҳудиён ҳастӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Исо дар ҷавоб гуфт: «Ту ин саволро аз худат мегӯӣ ё дигарон дар бораи Ман ба ту гуфтанд?» ");
INSERT INTO tgk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Пилотус ҷавоб дод: «Магар ман яҳудӣ ҳастам? Халқ ва сардорони рӯҳонии худат Туро дошта, ба дасти ман супориданд. Ту чӣ кор кардӣ?» ");
INSERT INTO tgk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Исо гуфт: «Подшоҳии Ман аз ин ҷаҳон нест. Агар подшоҳии Ман аз ин ҷаҳон мебуд, одамони зердастам меҷангиданд, то ки Ман ба дасти ҳукуматдорони яҳудӣ таслим нашавам. Не, подшоҳии Ман аз ин ҷаҳон нест». ");
INSERT INTO tgk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","«Пас, Ту Шоҳ ҳастӣ?» — пурсид аз Ӯ Пилотус. Исо ҷавоб дод: «Ту мегӯӣ, ки Ман подшоҳ ҳастам. Ман барои он таваллуд шуда ба ин ҷаҳон омадам, ки шоҳиди ростӣ бошам. Ҳар кӣ тарафдори ростӣ бошад, Маро гӯш мекунад». ");
INSERT INTO tgk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","«Ростӣ чист?» — пурсид аз Ӯ Пилотус. Ин суханонро гуфта, Пилотус боз ба назди яҳудиён баромаду гуфт: «Ман дар Ӯ ҳеҷ айберо наёфтам. ");
INSERT INTO tgk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Лекин шумо як анъана доред, ки ҳар иди Балогардон ман бароятон як зиндониро озод мекунам. Мехоҳед, ки бароятон Шоҳи Яҳудиёнро озод кунам?» ");
INSERT INTO tgk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","«Не! — дод зада ҷавоб доданд онҳо. — Ба ҷои Ӯ Бараббосро озод кун!» Бараббос як марди роҳзан буд. ");
INSERT INTO tgk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Он вақт Пилотус фармуд, ки Исоро бо қамчин зананд. ");
INSERT INTO tgk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Сарбозон аз хор тоҷе бофта, бар сари Ӯ гузоштанд ва ба Ӯ ҷомаи бунафшранг пӯшонданд. ");
INSERT INTO tgk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Онҳо ба пеши Ӯ омада, «Зинда бод Шоҳи Яҳудиён!» мегуфтанду Ӯро торсакӣ мезаданд. ");
INSERT INTO tgk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Пилотус боз берун баромада, ба онҳо гуфт: «Акнун ман ин одамро пеши шумо меорам. Бидонед, ки ман дар Ӯ ҳеҷ айбе наёфтам». ");
INSERT INTO tgk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Исо берун баромад ва дар сар тоҷи хордору дар тан ҷомаи бунафшранг дошт. Пилотус ба онҳо гуфт: «Ана ин одам!» ");
INSERT INTO tgk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Сардорони рӯҳонӣ ва посбонон Ӯро дида, фарёд карданд: «Ӯро ба салиб мехкӯб кунед! Ӯро мехкӯб кунед!» Пилотус ба онҳо гуфт: «Шумо худатон Ӯро гирифта, мехкӯб кунед! Зеро ман дар Ӯ ҳеҷ айбе наёфтам». ");
INSERT INTO tgk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Онҳо ба ӯ ҷавоб доданд: «Мо дар шариат қонун дорем, ки мувофиқи он Ӯ бояд бимирад, чунки худро Писари Худо эълон кардааст». ");
INSERT INTO tgk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Вақте Пилотус инро шунид, аз пештара зиёдтар тарсид. ");
INSERT INTO tgk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ӯ боз ба дохили қаср баргашта, аз Исо пурсид: «Ту аз куҷоӣ?» Вале Исо ҷавобе надод. ");
INSERT INTO tgk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","«Бо ман гап задан намехоҳӣ? — пурсид Пилотус. — Магар намедонӣ, ман қудрат дорам, ки Туро озод кунам ва қудрат дорам, ки Туро ба салиб мехкӯб кунонам?» ");
INSERT INTO tgk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Исо ба ӯ ҷавоб дод: «Агар ба ту аз боло қудрат дода намешуд, ту бар Ман ҳеҷ қудрат дошта наметавонистӣ. Бинобар ин касе, ки Маро ба ту таслим кардааст, гуноҳи бузургтаре дорад». ");
INSERT INTO tgk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Аз ин лаҳза Пилотус кӯшиш кард, ки Ӯро озод кунад, вале мардум фарёд мекарданд: «Агар Ӯро озод кунӣ, ту дӯсти император нестӣ! Касе, ки худро подшоҳ эълон мекунад, вай душмани император аст!» ");
INSERT INTO tgk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Вақте ки Пилотус ин суханонро шунид, Исоро берун овард ва дар маҳале ба номи Сангфарш, ки ба забони ибронӣ онро «Ҷабто» мегуфтанд, ба курсии доварӣ нишаст. ");
INSERT INTO tgk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Арафаи иди Балогардон, қариби нисфирӯзӣ шуда буд. Пилотус ба мардум гуфт: «Ана Шоҳи шумо!» ");
INSERT INTO tgk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Онҳо фарёд зада гуфтанд: «Нест кун! Нест кун! Ӯро мехкӯб кун!» «Шумо мехоҳед, ки ман Шоҳи шуморо мехкӯб кунам?» — гуфт Пилотус. Сардорони рӯҳонӣ ҷавоб доданд: «Мо ғайр аз император подшоҳи дигаре надорем!» ");
INSERT INTO tgk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Он гоҳ Пилотус Исоро барои мехкӯб кардан ба дасти онҳо супорид. ");
INSERT INTO tgk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Онҳо Исоро бурданд ва Ӯ то «Ҷои косахонаи сар», ки ба забони ибронӣ «Ҷолҷото» ном дошт, салиби худро бардошта, рафт. ");
INSERT INTO tgk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Дар он ҷо Ӯро ба салиб мехкӯб карданд ва ҳамроҳи Ӯ боз ду нафари дигарро дар салибҳо, яке аз тарафи чап ва дигаре аз тарафи рост, мехкӯб карданд ва Исо дар мобайни онҳо буд. ");
INSERT INTO tgk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Пилотус лавҳачаеро нависонда, ба салиб мехкӯб кунонд, ки дар он чунин навишта шуда буд: «Исои Носирӣ, Шоҳи Яҳудиён». ");
INSERT INTO tgk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Одамони зиёд ин навиштаро хонданд, чунки ҷое, ки Исо мехкӯб шуд, аз шаҳр дур набуд ва он суханон ба забонҳои ибронӣ, румӣ ва юнонӣ навишта шуда буданд. ");
INSERT INTO tgk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Сардорони рӯҳонии яҳудиён ба Пилотус гуфтанд: «„Шоҳи Яҳудиён“ нанавис, балки бинавис, ки „Ин одам «Ман Шоҳи Яҳудиён ҳастам» мегуфт“». ");
INSERT INTO tgk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","«Ҳар чӣ навиштаам, навиштам», — ҷавоб дод Пилотус. ");
INSERT INTO tgk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Баъд аз он ки сарбозон Исоро мехкӯб карданд, либоси Ӯро гирифта, аз рӯи шумораи сарбозон ба чор қисм тақсим карданд. Куртаи Ӯро ҳам гирифтанд; ин курта аз матои яклухт бофта шуда буд ва ҷои пайваст надошт. ");
INSERT INTO tgk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Онҳо ба якдигар гуфтанд: «Биёед, инро пора намекунему қуръа партофта мебинем, ки соҳиби он кӣ мешавад». Дар навиштаҷот омадааст: «Либоси Маро дар байни худ тақсим карданд ва бар куртаи Ман қуръа партофтанд». Барои иҷро шудани ин навиштаҷот ҳамаи ин ба амал омад. ");
INSERT INTO tgk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Чунин буд амали сарбозон. Дар назди салиби Исо модар ва холааш, Марями зани Келуп ва Марями Маҷдалия истода буданд. ");
INSERT INTO tgk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Исо модари худ ва дар канори Ӯ шогирди дӯстдоштаашро дида, ба модараш гуфт: «Модар, ана ин писари туст». ");
INSERT INTO tgk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Баъд ба он шогирд гуфт: «Ана, ин модари туст». Аз ҳамон вақт он шогирд модари Исоро ба хонаи худ бурд. ");
INSERT INTO tgk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Исо донист, ки ҳама чиз иҷро шуд ва барои ба амал омадани пешгӯйии навиштаҷот гуфт: «Ташна мондам!» ");
INSERT INTO tgk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Дар он ҷо як косаи пур аз сирко буд ва латтаеро гирифта, ба он сирко тар карданду ба нӯги чӯбе гузошта, ба лабони Ӯ наздик оварданд. ");
INSERT INTO tgk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Чун Исо сиркоро чашид, гуфт: «Иҷро шуд!» Баъд сар хам карда ҷон дод. ");
INSERT INTO tgk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Он рӯзи тайёрӣ ба рӯзи истироҳат буд ва сардорони яҳудӣ намехостанд, ки ҷасади мехкӯбшудагон дар рӯзи истироҳат дар салиб бимонад, чунки он рӯзи истироҳат ба рӯзи иди бузург рост омада буд. Бинобар ин онҳо аз Пилотус дархост карданд, ки пойҳои мехкӯбшудагонро шикананду ҷасади онҳоро аз салиб ба поён фароранд. ");
INSERT INTO tgk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Сарбозон омада, аввал пойҳои мехкӯбшудаи якум ва баъд мехкӯбшудаи дуюмро шикастанд. ");
INSERT INTO tgk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Вале вақте ки ба Исо наздик омаданд, диданд, ки Ӯ мурдааст, бинобар ин пойҳои Ӯро нашикастанд. ");
INSERT INTO tgk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Яке аз сарбозон бо найза ба паҳлӯи Ӯ зад ва ҳамон дам аз бадани Ӯ хун ва об ҷорӣ шуд. ");
INSERT INTO tgk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Касе, ки тамоми ин ҳодисаҳоро дидааст, шаҳодат медиҳад, то шумо низ имон оваред. Шаҳодати ӯ рост аст ва ӯ медонад, ки ҳақиқатро мегӯяд). ");
INSERT INTO tgk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ҳамаи ин барои он ба амал омад, ки гуфтаҳои навиштаҷот, ки «Ҳеҷ як устухони Ӯ шикаста нахоҳад шуд» иҷро шаванд. ");
INSERT INTO tgk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Боз дар дигар ҷои навиштаҷот гуфта шудааст, ки «Онҳо ба касе нигоҳ хоҳанд кард, ки Ӯро найза заданд». ");
INSERT INTO tgk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Баъд аз он Юсуфи аромотӣ, ки аз тарси роҳбарони яҳудӣ шогирди махфии Исо буд, аз Пилотус иҷозат хост, ки ҷасади Исоро гирад. Пилотус иҷозат дод ва ӯ омада, ҷасади Исоро гирифт. ");
INSERT INTO tgk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ниқодимус, ки пештар шабона ба дидани Исо омада буд, низ омад ва қариб сию чор кило ширеши хушбӯй бо гиёҳи дорувор омехтаро бо худ овард. ");
INSERT INTO tgk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Онҳо аз рӯи расми яҳудиён ҷасади Исоро гирифта, ба кафани бо ҳамон дорувории хушбӯй омехта печонданд. ");
INSERT INTO tgk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Дар ҷои мехкӯбшудаи Исо боғе ва дар он боғ қабри наве буд, ки ҳанӯз касе дар он дафн нашуда буд. ");
INSERT INTO tgk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Азбаски арафаи рӯзи истироҳати яҳудиён буд ва қабр ҳам наздик буд, Исоро дар он ҷо дафн карданд. ");
INSERT INTO tgk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Пагоҳии барвақти рӯзи якшанбе, ҳанӯз равшан нашуда, Марями Маҷдалия ба сари қабр омад ва дид, ки санг аз даромадгоҳи он гирифта шудааст. ");
INSERT INTO tgk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ӯ давида назди Шимъӯни Петрус ва шогирди дигар, ки Исо ӯро дӯст медошт, омада, ба онҳо гуфт: «Онҳо Худованди моро аз қабр бурдаанд ва мо намедонем, ки Ӯро ба куҷо гузоштаанд». ");
INSERT INTO tgk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Пас, Петрус ва он шогирди дигар ба тарафи қабр равона шуданд. ");
INSERT INTO tgk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ҳардуи онҳо медавиданд, вале он шогирди дигар аз Петрус тезтар давида, аввалин шуда ба сари қабр расида омад. ");
INSERT INTO tgk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ӯ хам шуда кафанро дид, вале ба даруни қабр надаромад. ");
INSERT INTO tgk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Аз паси ӯ Шимъӯни Петрус ҳам давида омад. Вай ба даруни қабр даромада, дид, ки кафан ҳаст ва ");
INSERT INTO tgk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","матое, ки дар сари Исо буд, на бо кафан, балки дар каноре ҷудо печонда шудааст. ");
INSERT INTO tgk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Он гоҳ шогирди дигар ҳам, ки аввалин шуда ба сари қабр омада буд, ба қабр даромаду ҳамаи инро дида имон овард. ");
INSERT INTO tgk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Онҳо ҳанӯз суханони навиштаҷотро намефаҳмиданд, ки дар бораи Ӯ гуфта шуда буд, ки бояд баъд аз марг зинда шавад. ");
INSERT INTO tgk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Шогирдон ба хонаашон баргаштанд. ");
INSERT INTO tgk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Аммо Марям берун аз қабр истода гиря мекард. Ӯ гирякунон хам шуда ба даруни қабр нигоҳ кард ");
INSERT INTO tgk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ва ду фариштаи сафедпӯшро дид, ки дар ҷое, ки пештар Исо гузошта шуда буд, нишастаанд, яке аз тарафи сар ва дигаре аз тарафи пой. ");
INSERT INTO tgk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","«Эй зан, чаро гиря мекунӣ?» — пурсиданд онҳо. Марям ба онҳо ҷавоб дод: «Худованди маро бурдаанд ва ман намедонам, ки Ӯро дар куҷо гузоштаанд». ");
INSERT INTO tgk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Инро гуфта, ӯ ба қафо рӯ гардонду дид, ки дар рӯ ба рӯи ӯ Исо истодааст. Вале ӯ надонист, ки ин Исо аст. ");
INSERT INTO tgk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Исо ба вай гуфт: «Эй зан, чаро гиря мекунӣ? Ту киро меҷӯӣ?» Марям Ӯро боғбон фикр карда ба Ӯ гуфт: «Эй хоҷа, агар шумо Ӯро бурда бошед, ба ман бигӯед, ки дар куҷо гузоштаед, то Ӯро гирифта барам». ");
INSERT INTO tgk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","«Эй Марям!» — гуфт Исо. Марям рӯ оварда, бо забони ибронӣ фарёд зад: «Эй Раббунӣ (ки маънояш „устод“ аст)!» ");
INSERT INTO tgk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Исо ба ӯ гуфт: «Ба Ман даст нарасон, ки ҳанӯз ба пеши Падар боло нарафтаам. Лекин назди бародаронам рафта гӯй, ки Ман назди Падари Ману шумо, ба назди Худои Ману шумо меравам». ");
INSERT INTO tgk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Марями Маҷдалия ба назди шогирдон омада, дар бораи Худовандро диданаш ба онҳо хабар дод. Инчунин суханони Исоро, ки ба ӯ гуфта буд, ба онҳо нақл кард. ");
INSERT INTO tgk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Бегоҳии худи ҳамон рӯз, яъне рӯзи якшанбе, вақте ки шогирдон якҷоя ҷамъ шуда, аз тарси роҳбарони халқ дарҳоро маҳкам баста менишастанд, Исо омаду дар миёни онҳо истода гуфт: «Ба шумо оромӣ мехоҳам». ");
INSERT INTO tgk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Инро гуфта, дастҳо ва паҳлӯяшро ба онҳо нишон дод. Шогирдон аз дидани Худовандашон хурсанд шуданд. ");
INSERT INTO tgk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","«Ба шумо оромӣ мехоҳам! — такрор кард Исо. — Чунон ки Падар Маро фиристодааст, Ман низ шуморо мефиристам». ");
INSERT INTO tgk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Баъд аз ин суханон Ӯ бар онҳо пуф карда, гуфт: «Рӯҳи Муқаддасро қабул кунед! ");
INSERT INTO tgk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Гуноҳи касонеро, ки бубахшед, ба онҳо бахшида мешавад ва онҳоеро, ки набахшед, гуноҳ дар гардани онҳо мемонад». ");
INSERT INTO tgk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Тумо, яке аз он дувоздаҳ шогирди Исо, ки боз Дугоник номида мешуд, ҳангоми омадани Исо дар он ҷо ҳамроҳи онҳо набуд. ");
INSERT INTO tgk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Шогирдони дигар ба ӯ гуфтанд: «Мо Худовандро дидем!» Вале ӯ ба онҳо ҷавоб дод: «То бо чашмони худам изҳои мехро дар дастони Ӯ набинам ва ангуштамро ба он нагузорам ва дастамро ба захми паҳлӯяш намонам, бовар намекунам!» ");
INSERT INTO tgk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Баъд аз як ҳафта шогирдон боз ҷамъ омаданд ва Тумо ҳам ҳамроҳи онҳо буд. Дар баста буд, вале Исо омада, дар миёни онҳо истоду гуфт: «Ба шумо оромӣ мехоҳам!» ");
INSERT INTO tgk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Баъд ба Тумо гуфт: «Ангуштатро ба ин ҷо гузору дастонамро бин ва дастатро ба захми паҳлӯям гузор! Дигар шубҳа накуну бовар кун!» ");
INSERT INTO tgk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Тумо ба Вай ҷавоб дод: «Эй Худованди ман, Худои ман!» ");
INSERT INTO tgk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Он гоҳ Исо ба ӯ гуфт: «Магар аз сабаби он бовар мекунӣ, ки Маро мебинӣ? Вале хушбахтанд онҳое, ки Маро надида имон овардаанд». ");
INSERT INTO tgk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Исо дар ҳузури шогирдони худ бисёр мӯъҷизоти дигареро ҳам нишон дода буд, ки дар бораи онҳо дар ин китоб гуфта нашудааст. ");
INSERT INTO tgk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Вале ҳамаи ин барои он навишта шудааст, ки шумо ба Таъиншуда ва Писари Худо будани Исо имон овареду ба воситаи имон ба Ӯ ҳаёти абадӣ ёбед. ");
INSERT INTO tgk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Баъд аз ин Исо дар канори баҳри Табария бори дигар ба шогирдони худ зоҳир шуд. Зоҳир шудани Ӯ ана ин тавр ба амал омад: ");
INSERT INTO tgk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Шимъӯни Петрус, Тумо, ки боз Дугоник номида мешуд, Натаноил, ки аз аҳли Қанои Ҷалил буд, ду писари Забдой ва ду шогирди дигари Ӯ — ҳама дар як ҷо ҷамъ омада буданд. ");
INSERT INTO tgk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Шимъӯни Петрус ба онҳо гуфт: «Ман рафта, моҳӣ сайд мекунам». «Мо ҳам ҳамроҳи ту меравем», — гуфтанд дигарон. Онҳо рафта ба қаиқ савор шуданд, аммо он шаб чизе сайд накарданд. ");
INSERT INTO tgk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Вақти баромади офтоб Исо дар соҳил истода буд. Аммо шогирдон нафаҳмиданд, ки ин Исо аст. ");
INSERT INTO tgk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Исо аз онҳо пурсид: «Эй бародарон, ягон моҳӣ сайд кардед?» «Не», — ҷавоб доданд онҳо. ");
INSERT INTO tgk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Вай ба онҳо гуфт: «Тӯрро аз тарафи рости қаиқ партоед ва моҳӣ медоред». Онҳо тӯр партофтанду аз сабаби зиёд будани моҳӣ онро ба қаиқ кашида натавонистанд. ");
INSERT INTO tgk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Он шогирде, ки Исо ӯро дӯст медошт, ба Петрус «Ин Худованд аст!» гуфт. Вақте Шимъӯни Петрус шунид, ки ин Худованд аст, либосашро пӯшиду (чунки либосашро кашида буд) худро ба об партофт. ");
INSERT INTO tgk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Шогирдони дигар бо қаиқ ба тарафи соҳил ҳаракат карда, тӯри пур аз моҳиро аз паси худ кашида оварданд. Онҳо аз соҳил на он қадар дур буданд, тахминан дар масофаи сад қадам. ");
INSERT INTO tgk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Вақте онҳо ба соҳил расиданд, гулханеро диданд, ки рӯи он моҳӣ гузошта шудааст ва дар паҳлӯи он нон ҳам буд. ");
INSERT INTO tgk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Он гоҳ Исо ба онҳо гуфт: «Аз моҳиҳои сайд кардаатон биёред». ");
INSERT INTO tgk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Шимъӯни Петрус ба қаиқ даромада, тӯри пур аз яксаду панҷоҳу се моҳии калонро аз об ба соҳил кашид. Бо вуҷуди ин қадар зиёд будани моҳӣ тӯр канда нашуд. ");
INSERT INTO tgk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Исо ба онҳо гуфт: «Биёед ва ноништа кунед». Аз шогирдон касе ҷуръат накард, ки «Ту кистӣ?» гуфта бипурсад, чунки онҳо фаҳмиданд, ки ин Худованд аст. ");
INSERT INTO tgk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Он гоҳ Исо пеш омада, нонро гирифту дар байни онҳо тақсим кард, инчунин моҳиҳоро ҳам. ");
INSERT INTO tgk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ин бори сеюм буд, ки Исо баъд аз зинда шуданаш худро ба шогирдон нишон дод. ");
INSERT INTO tgk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Баъд аз хӯрдани хӯрок Исо ба Шимъӯни Петрус гуфт: «Эй Шимъӯни писари Юҳанно, оё ту Маро аз онҳо бештар дӯст медорӣ?» «Оре, Худованд, Ту медонӣ, ки ман Туро дӯст медорам», — ҷавоб дод Петрус. «Барраҳои Маро чарон», — гуфт Исо. ");
INSERT INTO tgk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Бори дуюм Исо ба ӯ гуфт: «Эй Шимъӯни писари Юҳанно, ту Маро дӯст медорӣ?» «Бале, Худованд, Ту медонӣ, ки ман Туро дӯст медорам», — ҷавоб дод Петрус. «Гӯсфандони Маро саробонӣ кун», — гуфт Исо. ");
INSERT INTO tgk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Бори сеюм Исо ба ӯ гуфт: «Эй Шимъӯни писари Юҳанно, ту Маро дӯст медорӣ?» Петрус ғамгин шуд, ки Исо бори сеюм аз ӯ мепурсад, ки Ӯро дӯст медорад ё не. «Худованд, ба Ту ҳама чиз маълум аст, — гуфт ӯ ба Исо. — Ту медонӣ, ки ман Туро дӯст медорам». Исо ба ӯ гуфт: «Гӯсфандони Маро чарон. ");
INSERT INTO tgk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ба ту рост мегӯям, вақте ки ҷавон будӣ, худат камарбандатро баста ба ҳар ҷое, ки мехостӣ, мерафтӣ, вале вақте ки пир мешавӣ, дастҳои худро дароз мекунӣ ва каси дигар камарбандатро баста ба ҷое, ки намехоҳӣ, туро мебарад». ");
INSERT INTO tgk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Бо ин суханон Исо ба Петрус фаҳмонд, ки бо кадом роҳ марги Петрус Худоро шӯҳрату ҷалол хоҳад дод. Баъд ба Петрус гуфт: «Аз паси Ман биё». ");
INSERT INTO tgk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Петрус ба ақиб нигоҳ карда, шогирдеро дид, ки Исо ӯро дӯст медошт. Ӯ аз паси онҳо меомад. Ин ҳамон шогирде буд, ки дар вақти шом хӯрдан ба Исо такя карда пурсида буд: «Эй Худованд, кӣ ба Ту хиёнат мекунад?» ");
INSERT INTO tgk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Инак, Петрус ӯро дида, аз Исо пурсид: «Эй Худованд, бо ӯ чӣ мешавад?» ");
INSERT INTO tgk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Исо ҷавоб дод: «Агар Ман хоҳам, ки ӯ то вақти бозгаштанам зинда монад, ба ту ин чӣ дахл дорад? Ту аз паси Ман биё!» ");
INSERT INTO tgk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Бинобар ин дар байни имондорони Исо овозае паҳн шуд, ки гӯё он шогирд намемирад. Аммо Исо ба ӯ нагуфт, ки ӯ намемирад. Ӯ фақат гуфт, ки «Агар Ман хоҳам, ки ӯ то бозгаштанам зинда монад, ба ту ин чӣ дахл дорад?» ");
INSERT INTO tgk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ин ҳамон шогирдест, ки ҳамаи инро навиштааст ва дар бораи ин чизҳо шаҳодат медиҳад ва мо медонем, ки шаҳодати ӯ рост аст. ");
INSERT INTO tgk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Инчунин Исо боз бисёр корҳои дигареро ҳам кардааст. Агар ҳамаи онҳо навишта мешуданд, ба гумонам, дар тамоми олам барои ин миқдор китоб ҷой ёфт намешуд. ");
INSERT INTO tgk_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Мо Павлус, Силӯс ва Тимотиюс ба ҷамоати имондорони шаҳри Таслӯникӣ, ки аз они Худо-Падар ва Худованд Исои Масеҳ аст, салом мерасонем. Файзу осоиштагӣ бар шумо бод! ");
INSERT INTO tgk_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Мо ҳамеша шумо — таслӯникиёнро дар дуоҳоямон ба хотир оварда, барои ҳамаи шумо Худоро шукр мегӯем. ");
INSERT INTO tgk_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Инчунин дар назди Худо-Падари мо имон ва муҳаббату умеди шуморо ба ёд меорем. Яъне корҳои шуморо, ки бо имон содир кардед, меҳнатеро, ки бо муҳаббат мекунед, умедеро, ки ба Худованд Исои Масеҳ доред ва онро нигоҳ медоред. ");
INSERT INTO tgk_vpl VALUES ("H11_4","082_1_4","1TH","1","4","5","Эй бародарони азизи Худо, азбаски хушхабари расондаамонро на танҳо дар сухан, балки бо қуввати Рӯҳи Пок қабул кардед ва ба он хушхабар боварии комил доред, мо медонем, ки Худо шуморо интихоб кардааст. Худатон ҳам медонед, ки мо чӣ гуна одамон будем, чун барои беҳбудии шумо дар наздатон мондем. ");
INSERT INTO tgk_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Шумо аз мову Худованд ибрат гирифтед: бо вуҷуди азобҳои бисёр шумо каломро бо хушнудии Рӯҳи Пок қабул кардед. ");
INSERT INTO tgk_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Аз ҳамин сабаб, шумо барои ҳамаи имондорони вилоятҳои Мақдуния ва Охоия намунаи ибрат шудед. ");
INSERT INTO tgk_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Акнун каломи Худованд аз тарафи шумо на танҳо дар Мақдуния ва Охоия, балки дар ҳама ҷое, ки дар бораи имони шумо шунидаанд, паҳн гардид. Барои ҳамин лозим нест, ки дар бораи имони шумо ба касе гӯем. ");
INSERT INTO tgk_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Чунки дигарон аллакай ба мо нақл мекунанд, ки чӣ тавр шумо моро қабул кардаед ва аз бутҳо рӯй гардонида, ба Худои зиндаву ҳақиқӣ рӯй овардаед, то ки ба Ӯ хизмат кунед. ");
INSERT INTO tgk_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Инчунин интизори аз осмон омадани Писараш ҳастед, ки Ӯро Падар аз мурдагон зинда кардааст — Исоро, ки моро аз ғазаби омадаистодаи Худо раҳоӣ мебахшад. ");
INSERT INTO tgk_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Бародарон, худи шумо медонед, вақте ки ману Силӯс ва Тимотиюс ба назди шумо омадем, хизматамон самаранок буд. ");
INSERT INTO tgk_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Чуноне ки медонед, дар шаҳри Филиппӣ моро бисёр азоб доданд, паст заданд, вале Худо ба мо ҷуръат дод, ки бо вуҷуди зиддиятҳои сахт хушхабари Ӯро ба шумо кушоду равшан эълон намоем. ");
INSERT INTO tgk_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Охир, дар даъвати мо гумроҳ кардан, нияти бад ва ё фиребе нест. ");
INSERT INTO tgk_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Баръакс, Худо баъди санҷишҳо моро супориш додааст, ки хушхабарро эълон кунем. Барои ҳамин бартарие, ки ба мо дода шудааст, ҳангоми сухан гуфтан кӯшиш мекунем, ки на ба одамон, балки ба Худое, ки дилҳои моро месанҷад, писанд оем. ");
INSERT INTO tgk_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Шумо медонед ва Худо низ шоҳид аст, ки мо ҳаргиз хушомадгӯӣ накардаем ва ба манфиати худ кор набурдаем. ");
INSERT INTO tgk_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Зеро мо на аз шумо ва на аз каси дигар таъриф наҷустаем. ");
INSERT INTO tgk_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Мо чун фиристагониМасеҳ ҳақ доштем, ки аз шумо ҳурмату эҳтиром талаб кунем, аммо, мисли он ки модар навозишкорона ба кӯдаконаш ғамхорӣ мекунад, дар байнатон меҳрубон будем. ");
INSERT INTO tgk_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Мо шуморо чунон дӯст доштем, ки тайёр будем на танҳо хушхабари Худоро ба шумо расонем, балки ҷони худро бароятон фидо кунем, чунки шумо бароямон хеле азиз ва гиромӣ ҳастед. ");
INSERT INTO tgk_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Бародарон, шумо дар ёд доред, чӣ тарз мо заҳмат мекашидем: хушхабари Худоро ба шумо расонда, боз шабу рӯз кор ҳам мекардем, то ки ба дӯши ягон каси шумо бор нашавем. ");
INSERT INTO tgk_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Ҳам шумо ва ҳам Худо шоҳид ҳастед, ки рафтори мо нисбати шумо, имондорон, то чӣ андоза пок, дуруст ва беайб буд. ");
INSERT INTO tgk_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Худатон медонед, ки мо бо ҳар яки шумо мисли падар бо фарзандонаш муомила мекардем; ");
INSERT INTO tgk_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","шуморо қувват бахшидаву рӯҳбаланд карда, насиҳат мекардем. Мехостем, ки тарзи зиндагии шумо писанди Худо бошад, ки шуморо ба шукӯҳу ҷалол ва подшоҳиаш даъват кардааст. ");
INSERT INTO tgk_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Мо ҳамеша Худоро шукр мегӯем, ки шумо ҳангоми аз мо шунидани каломи Худо, онро на ҳамчун сухани одамизод, балки чун каломи Худо қабул кардед, ки он дар ҳақиқат ҳам чунин аст. Ин калом дар ҳаёти шумо, имондорон, амал мекунад. ");
INSERT INTO tgk_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Охир шумо, бародарон, дар азоб кашиданатон ба одамони Худо дар вилояти Яҳудия, ки ба Исои Масеҳ бовар мекунанд, монанд шудед — шумо аз халқи худ ҳамон азобҳоеро кашидед, ки онҳо аз яҳудиён дида буданд. ");
INSERT INTO tgk_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Яҳудиён Худованд Исо ва пайғамбаронро куштанд, инчунин моро пеш карданд. Рафтори онҳо ба Худо маъқул нест, онҳо ба одамон зиддият карда ");
INSERT INTO tgk_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","намегузоранд, ки мо хушхабарро ба мардум расонем, то ки наҷот ёбанд. Бо ин корашон ҳамеша косаи гуноҳҳояшонро лабрез намуда, ба ғазаби Худо гирифтор мешаванд. ");
INSERT INTO tgk_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Эй бародарон, азбаски мо нохоҳ барои муддати кӯтоҳе на дар дил, балки ҷисман аз шумо ҷудо шудем, хоҳиши зиёд доштем, ки шуморо боз рӯ ба рӯ бубинем. ");
INSERT INTO tgk_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Бале, хеле мехостем ба назди шумо равем. Ман, Павлус, бошам на як бору ду бор кӯшиш кардам, аммо иблис пеши роҳамонро гирифт. ");
INSERT INTO tgk_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Вақте ки Худованд Исобармегардад, дар назди Ӯ шумо боиси умеду шодмонӣ ва сарбаландии мо мешавед! ");
INSERT INTO tgk_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Охир шумо сабаби фахру хушнудии мо ҳастед! ");
INSERT INTO tgk_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Пас, чун дигар тоқати ҷудоӣ надоштем, фикр кардем, ки дар шаҳри Атино худ танҳо бимонем, ");
INSERT INTO tgk_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","вале ба назди шумо ба шаҳри Таслӯникӣ Тимотиюсро фиристем. Ҳамон Тимотиюсро, ки бародари мо буда, дар эълон кардани хушхабари Масеҳ хизматгори Худо мебошад. Хостем, ки ӯ шуморо дар имонатон устувор ва боқувват гардонад, ");
INSERT INTO tgk_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","то касе аз шумо ҳангоми азобҳо ба дудилагӣ роҳ надиҳад. Шумо пештар ҳам медонистед, ки мо бояд азоб кашем. ");
INSERT INTO tgk_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Охир, ҳангоми дар назди шумо буданамон ҳам огоҳ карда будем, ки моро азоб дода, дунболагирӣ хоҳанд кард. Чуноне ки мебинед, ҳамин тавр ҳам шуд. ");
INSERT INTO tgk_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Аз ин сабаб, вақте ки тоқатам тоқ шуд, ба назди шумо Тимотиюсро фиристодам, то дар бораи имонатон бифаҳмад; мабодо иблиси васвасакор шуморо аз роҳ занад ва тамоми меҳнатамон барбод равад. ");
INSERT INTO tgk_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Вале алҳол Тимотиюс аз наздатон баргашта, дар бораи муҳаббату имони шумо хабарҳои хуш овард. Ӯ ба мо нақл кард, ки шумо ҳамеша бо некӣ моро ёд мекунед ва мехоҳед, ки моро боз бубинед, чуноне ки мо ҳам хоҳони дидори шумоем. ");
INSERT INTO tgk_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Бародарон, дар ин ҳама ранҷу азобу душвориҳоямон имони шумо моро рӯҳбаланд кард. ");
INSERT INTO tgk_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Агар имони шумо ба Худованд устувор бошад, мо ҳам зиндадил мегардем. ");
INSERT INTO tgk_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Бародарони таслӯникӣ, дар ҳузури Худо шумо ба мо хурсандии бузурге бахшидед, ки барои он Худоро беохир шукр мегӯем. ");
INSERT INTO tgk_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Мо шабу рӯз аз таҳти дил дуо мегӯем, ки боз бо шумо вохӯрем, то норасоии имонатонро пурра гардонем. ");
INSERT INTO tgk_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Бигзор худи Худо — Падар ва Худовандамон Исо моро сӯи шумо равона кунад! ");
INSERT INTO tgk_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Бигзор Худованд бо он муҳаббати бузурге, ки нисбат ба шумо дорем, шуморо ҳам нисбат ба якдигар ва ҳамагон пур ва лабрез намояд. ");
INSERT INTO tgk_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Ҳамин тавр, Ӯ дили шуморо боқувват гардонад, то ҳамон рӯзе, ки Худованд Исо бо пайравонаш меояд, дар пеши Худо-Падарамон беайб ва пок бошед. ");
INSERT INTO tgk_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Инак, бародарон, бо номи Худованд Исо хоҳиш ва илтиҷо мекунем, чи тавре ки мо таълим додем, зиндагиро давом диҳед, то ки ба Худо писанд оед. Шумо аллакай ҳамин тарз рафтор мекунед, вале кӯшиш намоед, ки аз ин ҳам беҳтар зиндагӣ кунед. ");
INSERT INTO tgk_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Зеро шумо медонед, ки бо қудрати Худованд Исо чӣ гуна таълимотро ба шумо додаем. ");
INSERT INTO tgk_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Худо мехоҳад, ки шумо худро пурра ба Ӯ бахшида, аз бадахлоқии ҷинсӣ худро нигоҳ доред. ");
INSERT INTO tgk_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Хости Худо ин аст, ки ҳар яки шумо ҷисму хоҳишҳои худро идора карда, беайб ва бономус бошед. ");
INSERT INTO tgk_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","Боз Худо мехоҳад мисли беимононе, ки Ӯро намешиносанд, пойбанди ҳавасҳои ҷинсӣ набошед. ");
INSERT INTO tgk_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Инчунин мувофиқи хости Худо шумо набояд аз боварии бародаратон сӯиистифода карда, бо зани вай ҳамхоба шавед. Мо пештар ҳам инро ба шумо қатъиян гуфта ва огоҳ карда будем, ки барои ҳамаи ин гуноҳҳо Худо аз одам қасос мегирад. ");
INSERT INTO tgk_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Чунки Ӯ моро на ба нопокӣ, балки ба ҳаёти пок даъват кардааст. ");
INSERT INTO tgk_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Инак, касе ки аз фармудаҳои Худо саркашӣ мекунад, на одамро, балки Худоеро, ки ба шумо Рӯҳи Муқаддасро медиҳад, рад мекунад. ");
INSERT INTO tgk_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Оид ба хусуси бародардӯстӣ ҳоҷат ба сухан нест, чунки худи шумо аз Худо таълим гирифтаед, ки якдигарро дӯст доред. ");
INSERT INTO tgk_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Бале, шумо ҳамаи имондоронеро, ки дар саросари вилояти Мақдуния ҳастанд, дӯст медоред. Ба ҳар ҳол, хоҳиш мекунем, ки якдигарро боз зиёдтар дӯст доред. ");
INSERT INTO tgk_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Чи тавре ки фармуда будем, оромона зиндагӣ кунед, ҳар кас бо кори худ машғул шуда, бо дастонаш меҳнат кунад. ");
INSERT INTO tgk_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Чунон зиндагӣ кунед, ки ҳаёти шумо сазовори ҳурмати беимонон бошад, то ки шумо аз дигарон вобаста набошед. ");
INSERT INTO tgk_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Эй бародарон, намехоҳем, ки шумо дар бораи гузаштагон бехабар монда, ба монанди беимононе, ки умед надоранд, ғамгин бошед. ");
INSERT INTO tgk_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Мо бовар мекунем, ки Исои Масеҳ мурда зинда шуд ва инчунин бовар мекунем, ки Худо касонеро, ки ба Исои Масеҳ имон доштанду аз олам гузаштаанд, ба назди Ӯ ба осмон мебарад. ");
INSERT INTO tgk_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Мувофиқи суханони Худованд ба шумо мегӯем: мо, ки то бозгаши Худованд зинда мемонем, аз имондорони гузашта, ҳаргиз пеш намеравем. ");
INSERT INTO tgk_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Зеро худи Худованд аз осмон бо фармони қатъӣ, бо овози сарфариштаву карнайи Худо фуруд меояд ва аввал онҳое, ки ба Масеҳ имон доштанду мурдан зинда мешаванд. ");
INSERT INTO tgk_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Сипас мо, зиндаҳои боқимонда, ҳамроҳи онҳо дар абре ба ҳаво, ба пешвози Худованд боло мешавем ва то абад бо Ӯ мемонем. ");
INSERT INTO tgk_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Бо ин суханон якдигарро рӯҳбаланд кунед. ");
INSERT INTO tgk_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Бародарон, ҳоҷат нест, ки мо ба шумо дар бораи вақту соати он рӯз нависем. ");
INSERT INTO tgk_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Зеро шумо хуб медонед, ки рӯзи Худованд ногаҳон фаро мерасад мисли дузде, ки шабона меояд. ");
INSERT INTO tgk_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Ҳангоме ки одамон «дар ҳама ҷо сулҳу осоиштагӣ» мегӯянд, ногаҳон ҳалокат меояд, мисли он ки пеш аз таваллуд зани ҳомиладорро дард мегирад. Ҳамин тавр, ба онҳо низ роҳи гурез нест. ");
INSERT INTO tgk_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Аммо шумо, бародарон, дар торикӣ нестед, то ки он рӯз ногаҳон чун дузд шуморо дар ғафлат ёбад. ");
INSERT INTO tgk_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Зеро ҳамаи шумо писарони нур ва рӯзи равшан ҳастед. Мо аз они шаб ва торикӣ нестем. ");
INSERT INTO tgk_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Инак, мисли дигарон дар хоби ғафлат намонем, балки бедор ва ҳушёр бошем. ");
INSERT INTO tgk_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Чунки онҳое, ки хобанд, шабона хоб мераванд; онҳое, ки бадмастанд, шабона шароб менӯшанд. ");
INSERT INTO tgk_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Лекин мо аз они нури рӯз ҳастем, пас биёед имону муҳаббатро ҳамчун либоси ҷангӣ дар бар кунем ва умеди наҷоти ояндаро ҳамчун кулоҳи ҷангӣ ба сар кашида, ҳушёр биистем. ");
INSERT INTO tgk_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Зеро Худо моро на барои ғазабаш, балки барои наҷот ба воситаи Худованди мо, Исои Масеҳ пешакӣ муайян кардааст. ");
INSERT INTO tgk_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Исо барои мо ҷонашро фидо кард, то ки мо хоҳ зинда бошем, хоҳ мурда — ҳамроҳи Ӯ зиндагӣ кунем. ");
INSERT INTO tgk_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Пас рӯҳбаланд кардан ва устувор гардондани якдигарро давом диҳед. ");
INSERT INTO tgk_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Бародарон, аз шумо хоҳиш мекунем: намояндагони Худовандро, ки дар байни шумо меҳнат ва шуморо роҳбарию насиҳат мекунанд, иззат намоед. ");
INSERT INTO tgk_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Барои корашон онҳоро ҳурмату эҳтиром кунед ва дӯст доред. Бо якдигар сулҳу осоиштагӣ дошта бошед. ");
INSERT INTO tgk_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Эй, бародарон, аз шумо илтиҷо мекунем, ки танбалонро насиҳат кунед; ба тарсончакон қувват бахшед; сустимонҳоро дастгирӣ кунед; нисбат ба ҳама сабру тоқат дошта бошед. ");
INSERT INTO tgk_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Нагузоред, ки касе ба ивази бадӣ бо бадӣ ҷавоб диҳад, балки ҳамеша нисбат ба якдигар ва ҳама ба некӣ кардан кӯшиш кунед. ");
INSERT INTO tgk_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Ҳама вақт шод бошед, ");
INSERT INTO tgk_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","ҳамеша дуо гӯед, ");
INSERT INTO tgk_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","дар ҳар ҳолат Худоро шукр гӯед, зеро хости Худо барои шумо, ки ба Исои Масеҳ тааллуқ доред, ҳамин аст. ");
INSERT INTO tgk_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Ба кори Рӯҳи Пок халал нарасонед; ");
INSERT INTO tgk_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","пешгӯйиҳоро зери пой нанамоед, ");
INSERT INTO tgk_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","лекин ҳамаи инро санҷида, пешгӯйиҳои хубро қабул кунед, ");
INSERT INTO tgk_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","аз ҳар намуди бадаш дурӣ кунед! ");
INSERT INTO tgk_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Бигзор худи Худои осоиштагӣ шуморо комилан пок гардонад, то ки ҳангоми бозгашти Худованди мо Исои Масеҳ тамоми вуҷудатон, яъне рӯҳ, ҷон ва ҷисматон беайб нигоҳ дошта шавад. ");
INSERT INTO tgk_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Худо — Даъваткунандаи шумо вафодор аст ва Ӯ шуморо беайб нигоҳ медорад. ");
INSERT INTO tgk_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Бародарон, барои мо дуо кунед. ");
INSERT INTO tgk_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Ҳамаи бародаронро ба оғӯш гирифта, салом расонед. ");
INSERT INTO tgk_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Дар назди Худованд шуморо вазифадор мекунам, ки ин номаро ба ҳамаи бародарон хонед. ");
INSERT INTO tgk_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Файзу марҳамати Худованд Исои Масеҳ бо шумо бошад! ");
INSERT INTO tgk_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Филемӯни азиз, дӯст ва ҳамхизмати мо! Ман Павлус, ки бандии Исои Масеҳ ҳастам, ҳамроҳи бародари имондори мо Тимотиюс ба ту ");
INSERT INTO tgk_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ва ба имондороне, ки дар хонаат ҷамъ мешаванд, салом мерасонем. Ҳамчунин, ба хоҳари имондори мо Апия ва ба ҳамсафи мо Архипус саломи моро бирасон. ");
INSERT INTO tgk_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Бигзор файз ва осоиши Падари мо Худо ва Худовандамон Исои Масеҳ бар шумо бод! ");
INSERT INTO tgk_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Ман ҳамеша туро ба ёд оварда, дар дуоҳоям Худои худро шукр мегӯям, ");
INSERT INTO tgk_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","зеро шунидам, ки ту — Филемӯн муқаддасони Худоро дӯст медоштаӣ ва ба Худованд Исои Масеҳ имон доштаӣ. ");
INSERT INTO tgk_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Бигзор имони ту, ки дар бародарӣ дида мешавад, фаҳмиши туро дар бораи ҳама баракатҳое, ки дар Масеҳ дорӣ, афзун намояд. ");
INSERT INTO tgk_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Бародар Филемӯн, муҳаббати ту маро хеле хурсанд ва рӯҳбаланд намуд, чунки ту ба дили муқаддасон қувват бахшидӣ. ");
INSERT INTO tgk_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Алҳол дар имон, ки ба Масеҳ дорем, метавонистам далерона ба ту кореро бифармоям. ");
INSERT INTO tgk_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","Лекин баҳри муҳаббати мо ҳамчун Павлуси пир ва шахсе, ки ба хотири Исои Масеҳ зиндонӣ аст, аз ту танҳо хоҳиш мекунам. ");
INSERT INTO tgk_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","Хоҳиши ман дар бораи Онисимус аст, ки дар зиндон ба воситаи ман имон овард. ");
INSERT INTO tgk_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Пеш Онисимус ба ту даркор набуд, лекин ҳоло ба ҳардуямон ҳам даркор аст. ");
INSERT INTO tgk_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Ӯро ба ту гӯё бо ҷони худ бармегардонам. ");
INSERT INTO tgk_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Хеле мехостам, дар наздам бошаду, ҳангоме ки барои хушхабар зиндонӣ ҳастам, ба ҷойи ту ба ман хизмат кунад. ");
INSERT INTO tgk_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Аммо нахостам бе розигият коре бикунам, то некии ту на ба тарзи маҷбурӣ, балки бо хости ту бошад. ");
INSERT INTO tgk_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Шояд Онисимус барои ҳамин муддате аз ту ҷудо карда шуда бошад, ки сипас то абад бо ту монад. ");
INSERT INTO tgk_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Лекин акнун на чун ғуломи ту, балки хеле беҳтар аз ғулом, ҳамчун бародари азизат бошад. Барои ман Онисимус хеле азиз аст, лекин барои ту ӯ ҳамчун коргар ва пайрави Масеҳ азизтар аст. ");
INSERT INTO tgk_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Инак, агар маро шарики худ донӣ, ӯро чун ман қабул намо. ");
INSERT INTO tgk_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Агар пеши ту хатое карда бошад ё қарзе дошта бошад, онро ба ҳисоби ман гузарон. ");
INSERT INTO tgk_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Инак, ман, Павлус, бо дасти худ ба ту менависам, ки қарзҳои ӯро бармегардонам, агарчи метавонистам гӯям, ки худи ту бо буду шудат аз ман қарздор ҳастӣ. ");
INSERT INTO tgk_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Бале, бародар Филемӯн, мехоҳам ба хотири Худованд аз ту фоидае бинам. Диламро дар Масеҳ қувват бубахш! ");
INSERT INTO tgk_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Дилам аз ту пур аст, ки гапи маро ба замин намегузорӣ. Бинобар ин, ба ту менависам, зеро медонам, ки барои ман аз хоҳишам бештар хоҳӣ кард. ");
INSERT INTO tgk_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Боз як хоҳиши дигар дорам: барои ман ҳуҷрае омода намо, зеро умед дорам, ки ба сабаби дуоҳои шумо ба наздатон бозгардам. ");
INSERT INTO tgk_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Эпафрос, ки ба хотири Исои Масеҳ бо ман зиндонӣ аст, ");
INSERT INTO tgk_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","ҳамчунин ҳамкоронам: Марқӯс, Ористархус, Димос ва Луқо ба ту салом мегӯянд. ");
INSERT INTO tgk_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Хайр, файзи Худованд Исои Масеҳ бо рӯҳи шумо бод! ");
INSERT INTO tgk_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Ман — Ёқуб, бандаи Худо ва Худованд Исои Масеҳ саломи худро ба дувоздаҳ қабилаи Исроил, ки саросари дунё парокандаанд, мефиристам. ");
INSERT INTO tgk_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Бародаронам, вақте ки ҳар гуна душвориҳо ба саратон меоянд, онҳоро бо шодию хурсандӣ қабул кунед, ");
INSERT INTO tgk_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","зеро медонед, ки ҳангоми аз санҷиш гузаштани имонатон сабру тоқататон обутоб меёбад. ");
INSERT INTO tgk_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Тоқати шумо бояд пурра обутоб ёбад, он вақт шумо шахси комил ва баркамол расида шуда, бароятон ҳеҷ чиз камӣ намекунад. ");
INSERT INTO tgk_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Аммо агар ба шумо хирад камӣ кунад, метавонед аз Худо онро талаб кунед ва Ӯ, ки ба ҳама бо дасти кушод ва бе таънаву миннат медиҳад, ба шумо низ хирад мебахшад. ");
INSERT INTO tgk_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Вале ҳангоми талаб кардан бояд бешакку шубҳа боварӣ дошта бошед, ки Ӯ медиҳад. Зеро касе, ки шубҳа мекунад, монанди мавҷи баҳр аст, ки бо вазидани шамол пасту баланд мешавад. ");
INSERT INTO tgk_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Бигзор чунин шахс фикр накунад, ки аз ҷониби Худованд чизе гирифта метавонад, ");
INSERT INTO tgk_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","чунки ӯ дудила буда, дар ҳар қарори худ ноустувор аст. ");
INSERT INTO tgk_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Бародари бечора бояд аз он фахр кунад, ки Худо ӯро сарбаланд кардааст. ");
INSERT INTO tgk_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Сарватманд бошад, аз он фахр кунад, ки Худо ӯро хоксор мегардонад, чунки умри ӯ мисли гули саҳро мегузарад. ");
INSERT INTO tgk_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Чуноне ки аз нурҳои сӯзони офтоб сабзаҳо хушкида ва баргҳои гул рехтаву аз зебоиаш чизе боқӣ намемонад, сарватманд низ ҳангоми саргармии машғулияташ аз ин дунё меравад. ");
INSERT INTO tgk_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Хушбахт он касест, ки дар вақти санҷишҳо сабру тоқат дорад, зеро ҳангоме ки аз ин гуна имтиҳони зиндагӣ мегузарад, тоҷи ҳаётро ба даст меорад. Ин тоҷро Худо ба дӯстдорони худ ваъда додааст. ");
INSERT INTO tgk_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Аммо, вақте ба васваса меафтед, нагӯед, ки «Худо маро месанҷад», чунки Худо худ ба васваса намеафтад ва дигаронро низ ба васваса намеандозад. ");
INSERT INTO tgk_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Балки ҳар шахс он вақт ба васваса меафтад, ки ҳаваси бад мекунаду баъд саргарми он ҳавас шуда, ба доми васваса меафтад. ");
INSERT INTO tgk_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Сипас, ҳамин ки дили вай бо ин ҳавас ҳомиладор мешавад, гуноҳро таваллуд мекунад. Гуноҳ бошад, ба воя расида, маргро таваллуд мекунад. ");
INSERT INTO tgk_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Пас, эй бародарони азизам, фиреб нахӯред, ");
INSERT INTO tgk_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","балки бидонед, ки ҳар неъмати нек ва бекамбудӣ аз боло, яъне аз ҷониби Падар меояд, ки Ӯ Офарандаи офтобу моҳ ва ситораҳо мебошад. Агарчи ин ҷисмҳои осмонӣ гоҳе равшану гоҳе тира мешаванд, Худо ҳеҷ вақт тағйир намеёбад. ");
INSERT INTO tgk_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Ӯ аз рӯйи хости худ ба воситаи каломи ростӣ ба мо ҳаёти навро бахшидааст, то ки мо дар байни ҳамаи офаридаҳои Ӯ ҳамчун ҳосили аввал бошем. ");
INSERT INTO tgk_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Бародарони азизам, дар ёд дошта бошед, ки ҳар кас бояд ба гӯш кардан чусту чолок бошаду ба гуфтану ғазаб кардан саросема нашавад. ");
INSERT INTO tgk_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Чунки қаҳру ғазаби инсон он ҳаёти дурустеро, ки аз рӯйи хости Худо аст, ба амал намеорад. ");
INSERT INTO tgk_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Бинобар ин ҳар бадӣ ва бадахлоқии одатшударо аз худ дур намоед ва каломи ба дилатон кошташударо хоксорона қабул кунед, ки ин калом ҷонатонро наҷот дода метавонад. ");
INSERT INTO tgk_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Худро фиреб дода, гумон накунед, ки фақат шунидани каломи Худо басанда аст, балки гуфтаҳои онро ба ҷо оваред. ");
INSERT INTO tgk_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Агар каломро фақат гӯш кунеду иҷро накунед, монанди шахсе ҳастед, ки рӯйи худро дар оина мебинаду ");
INSERT INTO tgk_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","аз пеши он дур рафтан замон аз ёдаш мебарорад, ки чеҳрааш чӣ гуна буд. ");
INSERT INTO tgk_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Лекин шахсе, ки ба қонуни комил ва озодибахшанда бодиққат нигоҳ карданро давом медиҳаду суханони шунидаашро фаромӯш накарда, иҷро мекунад, дар ҳар кораш баракат меёбад. ");
INSERT INTO tgk_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Ҳар кӣ худро диндор ҳисоб мекунаду забонашро идора карда наметавонад, ҳам худро фиреб медиҳад ва ҳам диндориаш ба як пули пуч намеарзад. ");
INSERT INTO tgk_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Вале диндорие, ки Падари мо Худо пок ва беайбу нуқсон ҳисоб мекунад, ин аст, ки ба ятимону бевазанон дар ҳолати душвориашон ғамхорӣ кунем ва худро аз олуда шудан бо ин ҷаҳон нигоҳ дорем. ");
INSERT INTO tgk_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Эй бародаронам, шумо ки ба Худованди пуршӯҳрату ҷалоламон Исои Масеҳ имон овардаед, ҳаргиз рӯйбинӣ накунед. ");
INSERT INTO tgk_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Фарз кунем, ки шахсе бо ангуштарини тилло дар даст ва либосҳои қиматбаҳо дар тан ба ҷамъомади шумо медарояд. Ҳамин вақт як камбағале ҳам бо либоси кӯҳнаву ҷанда дохили маҷлис мешавад. ");
INSERT INTO tgk_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Шумо бошед, ба шахси сарулибоси қиматбаҳо пӯшида «Аз боло гузаред!» мегӯеду ба камбағал «Ана, ҳо дар он ҷо ист» ё «Пеши пойҳои ман, рӯйи замин нишин» мегӯед. ");
INSERT INTO tgk_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Пас, магар дар байнатон рӯйбинӣ нест ва оё шумо аз рӯйи фикрҳои бад ҳукм намекунед? ");
INSERT INTO tgk_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Гӯш кунед, бародарони азизам. Охир Худо онҳоеро интихоб кардааст, ки дар назари мардуми ҷаҳон камбағал, аммо аз ҷиҳати имон бой ҳастанд ва подшоҳии Худо, ки Ӯ ба дӯстдорони худ ваъда додааст, насибашон мегардад. ");
INSERT INTO tgk_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Шумо бошед, камбағалонро меранҷонед. Магар худи ҳамин бойҳо шуморо сӯйиистеъмол намекунанд ва ба пеши қозӣ намебаранд? ");
INSERT INTO tgk_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Магар онҳо шахсоне нестанд, ки номи бошарафи Масеҳро дашном медиҳанд? Дар ҳоле ки шумо аз они Масеҳ ҳастед. ");
INSERT INTO tgk_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Пас, агар шумо аз рӯйи шариати Шоҳи мо рафтор намоед, ки он дар навиштаҷот омадааст: «Ҳар шахсеро, ки наздики мост, бояд мисли худ дӯст бидорем», он гоҳ кори хуб мекунед. ");
INSERT INTO tgk_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Аммо агар рӯйбинӣ намоед, гуноҳ содир мекунед ва аз рӯйи шариат шумо қонуншикан ҳисоб мешавед. ");
INSERT INTO tgk_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Зеро агар шахсе ҳамаи гуфтаҳои шариатро иҷро намуда, фақат як нуқтаи онро вайрон кунад, дар шикастани тамоми қонуни шариат айбдор мегардад. ");
INSERT INTO tgk_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Зеро ҳамоне ки «Алоқаи ғайриникоҳ накун» гуфтааст, ҳамчунин фармудааст, ки «Одамкушӣ накун». Пас, агар шумо алоқаи ғайриникоҳ накунед, вале одам кушед, қонуншикан мешавед. ");
INSERT INTO tgk_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Бинобар ин гуфтору рафтори шумо бояд мисли гуфтору рафтори шахсе бошад, ки аз рӯйи шариати озодибахшанда ҳукм хоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Зеро ба шахсе, ки нисбати дигарон раҳму шафқат нишон намедиҳад, дар вақти ҳукмшавӣ ба ӯ низ раҳму шафқат нишон дода намешавад. Чунки раҳму шафқат бар ҳукм дастболо мешавад. ");
INSERT INTO tgk_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Инак, эй бародаронам, чӣ фоида аст, агар касе гӯяд, ки имон дорад, аммо амал накунад? Магар чунин имон вайро наҷот дода метавонад? ");
INSERT INTO tgk_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Фарзи мисол, як бародар ё хоҳаре аз ҷумлаи имондорон сарулибос ва ризқу рӯзӣ надошта бошаду ");
INSERT INTO tgk_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","яке аз шумо ба вай гӯед, ки «Сиҳату саломат гарду ҳеҷ гуруснагию хунукиро аз сар нагузарон», аммо ба мӯҳтоҷии моддиаш ҳеҷ кӯмак накунед, пас аз суханони шумо чӣ фоида аст? ");
INSERT INTO tgk_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Имон ҳам айнан мисли ҳамин беамал бошад, имони мурда аст. ");
INSERT INTO tgk_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Шояд касе мегӯяд: «Яке имон дорад, дигаре бошад, амал мекунад». Ман мегӯям: «Канӣ ба ман имони беамалро нишон деҳ ва ман ба ту дар амали худ имонамро нишон медиҳам». ");
INSERT INTO tgk_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Ана ту имон дорӣ, ки Худо ягона аст. Кори хуб мекунӣ! Аммо ҳатто девҳо ба ин бовар мекунанд ва бинобар ин меларзанд. ");
INSERT INTO tgk_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Эй беақл, мехоҳӣ исбот кунам, ки имон беамал фоида надорад? ");
INSERT INTO tgk_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Бубин, ки аҷдодамон Иброҳим писараш Исҳоқро дар болои қурбонгоҳ қурбонӣ карданӣ шуд. Магар аз рӯйи ҳамин амалаш ӯ беайб шуморида нашуд? ");
INSERT INTO tgk_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Мебинӣ, ки ӯ ҳам бовар карду ҳам амал кард ва имонаш бо амалаш пурра шуд. ");
INSERT INTO tgk_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Ана ҳамин тавр, гуфтаҳои навиштаҷот дар бораи Иброҳим, ки «Вай ба Худо имон оварду аз рӯйи он беайб ҳисоб шуд» иҷро гаштанд ва ӯ дӯсти Худо номида шуд. ");
INSERT INTO tgk_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Пас, ҳоло мебинед, ки инсон на фақат аз рӯйи имонаш, балки ҳамчунин аз рӯйи амалаш сафед мешавад. ");
INSERT INTO tgk_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Ба монанди ин ҳатто фоҳишае ба номи Роҳоб бо амалаш беайб ҳисоб шуд. Ӯ ба ҷосусони аз тарафи халқи Худо фиристодашуда паноҳ дода, баъд онҳоро аз роҳи дигар ба саломатӣ равона карда буд. ");
INSERT INTO tgk_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Хулоса, ҳамон тавре ки бадан бе рӯҳ мемирад, имон низ бе амал мемирад. ");
INSERT INTO tgk_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Эй бародаронам, бигзор бисёре аз шумо ҳаракати муаллими калом шуданро накунад, зеро худатон медонед, ки аз мо, муаллимон, дар вақти ҷавобдиҳӣ бисёртар пурсида хоҳад шуд. ");
INSERT INTO tgk_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Чун ҳама дар соҳаҳои гуногуни ҳаёт пешпо мехӯранд, аммо касе, ки дар сухан ҳеҷ хато намекунад, шахси комил аст ва тамоми баданашро ҳам идора карда метавонад. ");
INSERT INTO tgk_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Масалан, мо барои ром кардани аспҳо ба даҳонашон лаҷом мезанем ва он вақт тамоми баданашонро ба ҳар ҷо ки хоҳем, гардонда метавонем. ");
INSERT INTO tgk_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Ё мисоли дигар киштиро гирем. Ҳарчанд он калон буда, бо вазидани шамоли шадид ҳаракат кунад ҳам, аммо роҳбари киштӣ онро ба ҳар тарафе, ки хоҳад, бо як чархи хурди суккон мегардонад. ");
INSERT INTO tgk_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Забон низ айнан монанди ҳамин аст. Он як узви хурди бадан аст, аммо чӣ лофи зиёд мезанад. Ана як ҷангали бузург ҳам бо як лахчаи хурди оташ дармегирад. ");
INSERT INTO tgk_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Ҳамчунон забон низ оташест, ки аз дӯзах дармегирад. Он як ҷаҳон бадӣ дар байни узвҳоямон мебошад, ки тамоми баданамонро ҳаром мекунад ва тамоми вуҷудамонро ба оташ гирифтор менамояд. ");
INSERT INTO tgk_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Инсон ҳар гуна ҳайвоноту паррандаҳо ва хазандаҳову ҷонварони обиро ром кардааст ва ром мекунад, ");
INSERT INTO tgk_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","лекин забони худро ҳеҷ яке ром карда наметавонад. Забон як бадии идоранашаванда ва пур аз заҳри марговар аст. ");
INSERT INTO tgk_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Бо он мо Худованд ва Падари Осмониамонро ҳамду сано мехонем ва ҳамчунон бо он одамонро лаънат мегӯем. Ҳол он ки инсон ба шакли Худо офарида шудааст. ");
INSERT INTO tgk_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Пас, аз як забон ҳам ҳамду сано ва ҳам лаънат мебарояд. Бародаронам, ин хел набояд бошад. ");
INSERT INTO tgk_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Магар аз як чашма оби ширину оби шӯр ҷорӣ шуда метавонад?! ");
INSERT INTO tgk_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Ё магар дарахти анҷир меваи зайтун ва ё токи ангур меваи анҷир бор меоварад?! Аз чашмаи оби шӯр низ оби ширин ҷорӣ шуда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Касе ки дар байни шумо бохираду бофаҳм бошад, бигзор инро бо зиндагии хуб ва амалҳое, ки бо хоксории хираду ҳикмат анҷом дода мешаванд, нишон диҳад. ");
INSERT INTO tgk_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Аммо агар дар дилҳои шумо кинаву ҳасад ва худпарастӣ вуҷуд дошта бошад, худситоӣ накунед, ки таърифатон бар зидди ростӣ аст. ");
INSERT INTO tgk_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Ин гуна хираду ҳикмат аз ҷониби Худо нест, балки ҳикмати заминӣ, дунявӣ, яъне шайтонӣ мебошад. ");
INSERT INTO tgk_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Зеро ҳар вақте ки дар байни шумо кинаву ҳасад ва худпарастӣ ҳаст, дар ҳамон ҷо бетартибӣ ва ҳар гуна фисқу фасод мебошад. ");
INSERT INTO tgk_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Аммо хираду ҳикмате, ки аз ҷониби Худо меояд, пеш аз ҳама пок аст ва баъд сулҳпарвар, нармдил, равшанфикр, пур аз раҳму шафқат ва самараҳои нек, самимӣ ва бе рӯйбинӣ мебошад. ");
INSERT INTO tgk_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Шахсони сулҳпарвар тухми сулҳро мекоранд ва ҳосилашро, ки адолат аст, ба даст меоваранд. ");
INSERT INTO tgk_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Сабаби ҳамаи баҳсҳову ҷангҳои байни шумо дар чист? Магар дар ҳамон орзу ва ҳавасҳоятон нест, ки дар дарунатон ҷанг мекунанд? ");
INSERT INTO tgk_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Шумо чизеро сахт мехоҳед, аммо ба даст намеоред ва барои ҳамин одамкушӣ мекунед. Шумо ҳамчунон чизеро сахт ҳавас мекунед, аммо боз ҳам ба мақсадатон намерасед, бинобар ин гирифтори ҷангу моҷаро мешавед. Сабаби ба даст наовардани чизи дилхоҳатон дар он аст, ки аз Худо хоҳиш намекунед. ");
INSERT INTO tgk_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Вале хоҳиш кунед ҳам, ба даст намеоред, чунки бо нияти айшу ишрати худ талаб мекунед ва ин нияти нодуруст аст. ");
INSERT INTO tgk_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Эй мардуми бевафо, магар намедонед, ки дӯстӣ кардан бо ин ҷаҳон бо Худо душманӣ карданро мефаҳмонад? Ҳар кӣ бо ин ҷаҳон дӯст шудан хоҳад, душмани Худо мешавад. ");
INSERT INTO tgk_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Ё фикр мекунед, ки дар навиштаҷот беҳуда гуфта шудааст: «Рӯҳи Худованд, ки Худо дар дарунамон гузоштааст, сахт рашк мекунад»? ");
INSERT INTO tgk_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Ба мо бошад, Ӯ қуввати бештар аз пештараро ато мекунад, то бар зидди ин ҳавасҳо истодагарӣ кунем. Барои ҳамин ҳам дар навиштаҷот гуфта шудааст: «Худо бар зидди ҳавобаландон аст, лекин ба хоксорон қувват мебахшад». ");
INSERT INTO tgk_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Пас, ба Худо пурра итоат кунеду ба иблис зид бароед ва ӯ аз пеши шумо мегурезад. ");
INSERT INTO tgk_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Ба Худо наздик шавед ва Ӯ низ ба шумо наздик мешавад. Шумо, эй гунаҳкорон, дастонатонро аз гуноҳ пок созеду шумо, эй дудилагон, дилҳоятонро тоза кунед. ");
INSERT INTO tgk_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Аз корҳоятон пушаймон шуда, нолаву гиря ва фиғон бардоред. Ба ҷойи ханда нола кунед ва ба ҷойи шодӣ кардан ғамгин бошед. ");
INSERT INTO tgk_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Дар пеши Худованд сарҳои худро хам кунед ва Ӯ шуморо сарбаланд хоҳад кард. ");
INSERT INTO tgk_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Эй бародарон, якдигарро бадгӯйӣ накунед. Ҳар кӣ бар зидди бародараш сухан мегӯяд ё ӯро ҳукм мекунад, дар асл, зидди шариати Худо сухан мегӯяд ва шариатро ҳукм мекунад. Агар шумо шариатро ҳукм мекарда бошед, пас дигар иҷрокунандаи он нестед, балки ҳукмкунанда ҳастед. ");
INSERT INTO tgk_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Аммо ҳаминро донед, ки фақат як Шариатдиҳанда ва Ӯ ҳам Ҳукмкунанда аст, ки қудрати наҷот додан ва нобуд карданро дорад. Лекин шумо кистед, ки якдигарро ҳукм мекунед? ");
INSERT INTO tgk_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Гӯш андозед шумое, ки мегӯед: «Имрӯз ё фардо фалон шаҳр меравем, он ҷо як сол монда, савдо мекунему фоида ба даст меоварем». ");
INSERT INTO tgk_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Шумо аз куҷо медонед, ки фардо чӣ рӯй медиҳад? Охир умри шумо мисли буғ аст, ки барои як лаҳзаи кӯтоҳ пайдо мешаваду баъд нопадид мегардад. ");
INSERT INTO tgk_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Пас, шумо бояд чунин бигӯед: «Худованд хоҳаду зинда монем, фалон корро мекунем». ");
INSERT INTO tgk_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Дар акси ҳол суханони шумо лофзанӣ аз корҳои худ мешавад ва чунин болиданҳо бадӣ аст. ");
INSERT INTO tgk_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Пас, ҳар кас ки нек будани кореро медонаду онро иҷро намекунад, гуноҳ содир менамояд. ");
INSERT INTO tgk_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Ҳоло шумо, эй сарватмандон, гӯш андозед! Шумо бояд гиряву нола кунед, чунки бало ба шумо наздик шуда истодааст. ");
INSERT INTO tgk_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Сарвати шумо пӯсидаасту либосатонро куя задааст. ");
INSERT INTO tgk_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Тиллову нуқраатон занг задааст. Худи ҳамин занг бар зидди шумо шаҳодат дода, баданатонро мисли оташ дармегиронад. Шумо бошед, дар ин рӯзҳои охир бойигарӣ ҷамъ кардаед. ");
INSERT INTO tgk_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Бинед, шумо ба мардикороне, ки ҳосили заминҳоятонро ҷамъ овардаанд, бояд музди меҳнаташонро медодед, вале ғоратгарона онро надодед. Ҳоло ҳамин музди меҳнати онҳо бар зидди шумо нолаю фарёд мекунад ва ин фарёди ҳосилҷамъкунандагон то ба гӯши Худои пурқудрат расидааст. ");
INSERT INTO tgk_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Ана шумо умри худро дар ин дунё бо кайфу сафо ва айшу ишрат гузаронда, худро мисли ҷонвароне, ки барои куштан парвариш мешаванд, барои рӯзи ҷавобдиҳӣ парвариш кардаед. ");
INSERT INTO tgk_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Одами бегуноҳро, ки ба шумо зиддият нишон намедод, ҳукм карда, ба қатл расонидаед. ");
INSERT INTO tgk_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Бинобар ин, эй бародарон, чунон ки деҳқон бо сабру тоқат интизори борони баҳору тирамоҳ мешавад, то ки киштзори ғаллаи гаронбаҳояш ҳосил диҳад, шумо низ то омадани Худованд сабру тоқат кунед. ");
INSERT INTO tgk_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Монанди ҳамин шумо низ бо сабру тоқат устувор истед, чунки вақти омадани Худованд наздик аст. ");
INSERT INTO tgk_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Аз якдигар, бародарон, арзу шикоят накунед, вагарна ҳукм мешавед, зеро Ҳукмкунанда дар остонаи дар истодааст. ");
INSERT INTO tgk_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Хӯш, бародарон, аз пайғамбароне, ки аз номи Худованд пайғом медоданд, ибрат бигиред, ки чӣ тавр онҳо дар вақти азобу шиканҷаҳо сабру тоқат нишон медоданд. ");
INSERT INTO tgk_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Шумо медонед, ки мо онҳоеро пурбаракат мешуморем, ки ба азобҳо тоб меоваранд. Тавре ки шумо шунидаед, чӣ гуна Айюб пайғамбар бо сабру тоқат аз азобҳо гузашт ва медонед, ки Худованд дар охир барояш чӣ кор кард. Худованд пур аз раҳму шафқат аст. ");
INSERT INTO tgk_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Аз ҳама муҳимаш, бародаронам, ҳеҷ қасам нахӯред, на бо Худо, на бо замин ва на бо ҳеҷ чизи дигар. Бигзор «ҳа» гуфтани шумо «ҳа» бошад ва «не» гуфтанатон «не» бошад. Вагарна шумо ҳукм мешавед. ");
INSERT INTO tgk_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Агар касе аз байни шумо мушкилие дошта бошад, бояд дуо кунад. Агар хурсанд бошад, бояд сурудҳои ҳамду сано бихонад. ");
INSERT INTO tgk_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Агар касе бемор бошад, бояд роҳбарони ҷамоати имондоронро даъват кунад, то ки барояш дуо кунанду бо номи Худованд бар бемор равған моланд. ");
INSERT INTO tgk_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Он гоҳ дуои боимон беморро шифо мебахшад ва Худованд ӯро аз бистари беморӣ мехезонад. Агар ӯ гуноҳ карда бошад, гуноҳаш бахшида мешавад. ");
INSERT INTO tgk_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Бинобар ин дар пеши якдигар ба гуноҳҳоятон иқрор шавед ва барои якдигар дуо кунед, то ки шифо ёбед. Дуои шахси дурусткор боқудрат ва натиҷабахш аст. ");
INSERT INTO tgk_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Илёс пайғамбар низ шахсе мисли мо буд, аммо вақте аз сидқи дил дуо кард, ки борон наборад, сеюним сол ба замин борон наборид. ");
INSERT INTO tgk_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Боз дуо кард, ки борон борад ва аз осмон борон бориду замин ҳосил дод. ");
INSERT INTO tgk_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Пас, эй бародаронам, бидонед, ки агар касе аз байни шумо аз роҳи ростӣ барояду дигаре ӯро ба роҳ баргардонад, ");
INSERT INTO tgk_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","вай гунаҳкорро аз роҳи хато баргардонда, ӯро аз марг наҷот медиҳад ва гуноҳҳои зиёдаш бахшида мешаванд. ");
INSERT INTO tgk_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Мо ба шумо дар бораи Каломи ҳаёт эълон мекунем, ки Ӯ аз ибтидо буд. Мо Ӯро шунидему бо чашмони худ дидем, инчунин ба Ӯ нигоҳ кардему ба Ӯ даст расондем. ");
INSERT INTO tgk_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Ин ҳаёт намоён шуд. Мо Ӯро дидем ва ба шумо дар борааш шаҳодат медиҳем. Мо дар бораи ин ҳаёти абадӣ хабар медиҳем, ки Ӯ бо Падари Осмонӣ буд ва ба мо намоён шуд. ");
INSERT INTO tgk_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Мо ба шумо дидаву шунидаамонро эълон мекунем, то шумо низ шарики муносибатҳои мо шавед, ки ин муносибат аслан бо Падари Осмонӣ ва Писари Ӯ, Исои Масеҳ аст. ");
INSERT INTO tgk_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Ин суханонро барои он менависем, ки шодии мо пурра гардад. ");
INSERT INTO tgk_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Ана ин пайғом, ки мо аз Масеҳ шунидем ва ба шумо эълон мекунем: «Худо нур аст ва дар Ӯ ҳеҷ торикие вуҷуд надорад». ");
INSERT INTO tgk_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Пас, агар гӯем, ки бо Худо муносибат дорем, аммо бо роҳи торикӣ равем, он гоҳ мо дурӯғгӯй ҳастем ва дар ростӣ зиндагӣ намекунем. ");
INSERT INTO tgk_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Аммо агар мо дар равшанӣ роҳ равем, ҳамон тавре ки Худо дар равшанӣ аст, пас бо якдигар муносибат дорем ва он гоҳ хуни Писари Ӯ, Исо моро аз ҳар гуноҳ пок мекунад. ");
INSERT INTO tgk_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Лекин агар гӯем, ки мо гуноҳкор нестем, худро фиреб медиҳем ва нишон медиҳем, ки дар вуҷудамон ростӣ нест. ");
INSERT INTO tgk_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Вале агар ба гуноҳҳои худ иқрор шавем, он гоҳ Худо, ки бовафо ва одил аст, гуноҳҳои моро мебахшад ва аз ҳар нодурустӣ моро пок месозад. ");
INSERT INTO tgk_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Агар гӯем, ки ҳеҷ гуноҳ накардаем, Худоро дурӯғгӯй мекунем ва нишон медиҳем, ки каломи Ӯ дар мо нест. ");
INSERT INTO tgk_vpl VALUES ("J12_1","092_2_1","1JN","2","1","2","Эй фарзандони азизам, ин суханонро ман барои он ба шумо менависам, то ки гуноҳ содир накунед. Вале вақте касе гуноҳ кунад, мо Исои Масеҳи беайбро дорем, ки ҳоло дар пеши Падари Осмонӣ моро тарафдорӣ мекунад. Ӯ барои ором кардани ғазаби Худо ва бахшида шудани гуноҳҳои мо ва нафақат барои гуноҳҳои мо, балки барои гуноҳҳои тамоми ҷаҳон ҷони худро фидо кардааст. ");
INSERT INTO tgk_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Агар мо ба фармонҳои Худо итоат кунем, он гоҳ боварӣ дошта метавонем, ки Ӯро ба ростӣ шинохтаем. ");
INSERT INTO tgk_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Ҳар касе, ки «ман Худоро шинохтаам» мегӯяду фармонҳои Ӯро иҷро намекунад, дурӯғгӯй аст ва ростӣ дар вуҷудаш нест. ");
INSERT INTO tgk_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Мо фақат ҳамон вақт Худоро ҳақиқатан дӯст медорем, ки фармонҳояшро иҷро кунем. Он гоҳ медонем, ки аз они Худо ҳастем. ");
INSERT INTO tgk_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Вақте касе мегӯяд, ки ӯ бо Худо аст, бояд ҳамон тавре амал кунад, ки Исо амал мекард. ");
INSERT INTO tgk_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Азизонам, ман ба шумо фармони нав наменависам, балки фармони қадимаеро менависам, ки шумо аз аввал доштед. Фармони қадима ҳамон пайғомест, ки шумо шунидаед. ");
INSERT INTO tgk_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Ба ҳар ҳол, ман ба шумо фармони навро менависам, ки ҳақиқат будани он дар Масеҳ ва шумо намоён шудааст, чунки торикӣ аз байн рафта истодааст ва равшании аслӣ аллакай медурахшад. ");
INSERT INTO tgk_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Ҳар касе, ки «ман дар равшанӣ ҳастам» мегӯяду бародарро бад мебинад, ҳанӯз дар торикӣ мебошад. ");
INSERT INTO tgk_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Лекин ҳар касе, ки бародарро дӯст медорад, дар равшанӣ зиндагӣ мекунад ва дар вай чизе нест, ки сабаби пешпо хӯрданаш шавад. ");
INSERT INTO tgk_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Аммо касе, ки ба як бародар нафрат дорад, дар торикист. Вай бо роҳи торикӣ равона асту роҳи мерафтаашро намедонад, чунки торикӣ чашмонашро кӯр сохтааст. ");
INSERT INTO tgk_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Эй фарзандон, ман ба шумо менависам, чунки гуноҳҳои шумо аз барои Масеҳ бахшида шудаанд. ");
INSERT INTO tgk_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Эй падарон, ман ба шумо менависам, чунки шумо ҳамонеро, ки аз ибтидост, мешиносед. Эй ҷавонон, ман ба шумо менависам, чунки шумо Шахси Бадро мағлуб кардаед. Эй фарзандон, ман ба шумо менависам, чунки шумо Падарро мешиносед. ");
INSERT INTO tgk_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Эй падарон, ман ба шумо менависам, чунки шумо ҳамонеро, ки аз ибтидо вуҷуд дорад, мешиносед. Эй ҷавонон, ман ба шумо менависам, чунки шумо боқувват ҳастед ва каломи Худо дар шумо ҳамеша натиҷабахш аст, инчунин шумо бар Шахси Бад ғолиб баромадаед. ");
INSERT INTO tgk_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","Ба ин дунё ва ба ҳар он чӣ, ки дар он аст, дил набандед. Касе, ки ба ин дунё дил мебандад, муҳаббати Худо дар вай нест. ");
INSERT INTO tgk_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Чунки ҳар чизе, ки дар ин дунё ҳаст, яъне ҳавасҳои нафсонӣ, чашмгуруснагӣ ва бо молу мулк калонгирӣ кардан, ҳамаи ин на аз ҷониби Падари Осмонӣ, балки аз ин дунё мебошад. ");
INSERT INTO tgk_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Ин дунё бо ҳавасҳояш гузарон аст, аммо онҳое, ки хости Худоро иҷро мекунанд, то абад зинда мемонанд. ");
INSERT INTO tgk_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Эй фарзандон, ин замони охир аст ва чӣ тавре ки шумо шунида будед дар бораи омадани шахси зидди Масеҳ, ҳоло чунин шахсон зиёд баромадаанд. Аз ҳамин ҳам мефаҳмем, ки ин замони охир аст. ");
INSERT INTO tgk_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Гарчанде ки ин шахсон аз байни мо баромада бошанд ҳам, онҳо аъзои мо набуданд, чунки агар аъзои мо мебуданд, ҳамроҳи мо мемонданд. Вале вақте аз мо ҷудо шуданд, маълум карданд, ки ҳеҷ якеашон аъзои мо набуданд. ");
INSERT INTO tgk_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Бар шумо бошад, Шахси муқаддаси Худо Рӯҳи худро рехтааст, бинобар ин ҳамаи шумо чӣ будани ростиро медонед. ");
INSERT INTO tgk_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Инак, ман ба шумо на барои он менависам, ки шумо ростиро намедонед, балки барои он менависам, ки шумо ростиро медонед ва ҳамчунон огоҳ ҳастед, ки аз ростӣ ҳеҷ дурӯғ барнамеояд. ");
INSERT INTO tgk_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Дурӯғгӯй кист? Магар он касе нест, ки Таъиншудаи Худо будани Исоро инкор мекунад? Ин дурӯғгӯй ҳамон душмани Масеҳ аст, ки ҳам Падар ва ҳам Писарро рад мекунад. ");
INSERT INTO tgk_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Ҳар кӣ Писарро рад кунад, бо Падар буда наметавонад ва ҳар кӣ Писарро қабул кунад, Падарро ҳам қабул мекунад. ");
INSERT INTO tgk_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Бигзор пайғоми аз аввал шунидаатон дар шумо бимонад. Зеро агар пайғоми аз аввал шунидаатон дар дилҳои шумо монад, он гоҳ шумо дар муносибати Падару Писар мемонед. ");
INSERT INTO tgk_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","Ана ваъдаи Масеҳ низ, ки ба мо додааст, ҳаёти абадӣ аст. ");
INSERT INTO tgk_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Ҳамаи ин суханонро ман оид ба касоне навиштаам, ки шуморо аз роҳ заданӣ ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Шумо бошед, Рӯҳеро доред, ки Ӯ ба шумо додааст ва ин Рӯҳ дар шумо сокин мебошад, бинобар ин эҳтиёҷ надоред, ки каси дигар шуморо ёд диҳад. Худи ҳамин Рӯҳ дар бораи ҳама чиз ёд медиҳад ва таълимоти Ӯ дурӯғ нест, балки рост аст. Пас, ҳамон тавре ки Ӯ шуморо таълим додааст бо Масеҳ монед. ");
INSERT INTO tgk_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Ҳоло бошад, фарзандони азизам, бо Масеҳ муносибати худро давом диҳед, то ки дар вақти баргаштан ва зоҳир шуданаш дар пеши Ӯ сари худро хамшуда ҳис накунем, балки боҷуръат бошем. ");
INSERT INTO tgk_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","Мо медонем, ки Масеҳ дурусткор аст. Бинобар ин медонем, ки ҳар кӣ корҳои дуруст мекунад, таваллуди нав аз Худо гирифтааст. ");
INSERT INTO tgk_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Бинед, ки Падар чӣ қадар моро дӯст доштааст, ки мо фарзандони Ӯ номида мешавем ва ҳам фарзандони Ӯ ҳастем. Сабабе, ки ҷаҳон моро намешиносад дар он аст, ки он Худоро нашинохт. ");
INSERT INTO tgk_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Азизон, мо ҳоло фарзандони Худо ҳастем ва ҳанӯз намоён нашудааст, ки мо чӣ гуна мешавем. Лекин ҳаминро медонем, ки ҳангоми зоҳир шудани Масеҳ мисли Ӯ хоҳем шуд, чунки Ӯро ҳамон тавре ки ҳаст, хоҳем дид. ");
INSERT INTO tgk_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Инак, ҳар кӣ ба Ӯ умед мебандад, худро пок нигоҳ медорад, чуноне ки Масеҳ пок аст. ");
INSERT INTO tgk_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Ҳар кӣ дар гуноҳ зиндагӣ мекунад. қонуншикан аст. Аслан худи гуноҳ беқонунӣ аст. ");
INSERT INTO tgk_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","Шумо ҳам медонед, ки Масеҳ барои аз байн бардоштани гуноҳҳои мо зоҳир шуд. Шумо инчунин медонед, ки Ӯ комилан бегуноҳ аст. ");
INSERT INTO tgk_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Пас, ҳар кӣ дар Ӯ зиндагӣ мекунад, гуноҳ карданро давом намедиҳад. Ҳар кӣ гуноҳ карданро давом медиҳад, Масеҳро на дидааст ва на шинохтааст. ");
INSERT INTO tgk_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Фарзандони азиз, нагузоред, ки касе шуморо гумроҳ созад. Ҳамаи онҳое, ки кори дуруст мекунанд, дурусткор ҳастанд, айнан мисли Масеҳ, ки дурусткор аст. ");
INSERT INTO tgk_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Аммо ҳамоне, ки гуноҳ карданро давом медиҳад, аз иблис аст, зеро иблис аз ибтидо гуноҳ карда меояд. Сабаби зоҳир шудани Писари Худо низ дар ҳамин буд, ки корҳои иблисро нобуд созад. ");
INSERT INTO tgk_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Ҳар касе, ки Худо барояш таваллуди нав бахшидааст, гуноҳ карданро давом намедиҳад, зеро дар дохилаш табиати Худо мебошад. Инчунин вай наметавонад, ки зиндагии гуноҳкоронаро давом диҳад, чунки таваллуди нав аз Худо гирифтааст. ");
INSERT INTO tgk_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Кӣ фарзанди Худо ва кӣ фарзанди иблис буданаш ин тавр маълум мегардад: ҳар кӣ чизи дурустро иҷро намекунад ва ҳамчунин бародари худро дӯст намедорад, фарзанди Худо намебошад. ");
INSERT INTO tgk_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Зеро пайғоме, ки шумо аз аввал шунида будед, ин аст, ки мо бояд якдигарро дӯст дошта бошем. ");
INSERT INTO tgk_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Мисли Қобил набошем, ки зердасти Шахси Бад буда, бародари худро кушт. Аз чӣ сабаб бародарашро кушт? Чунки корҳои ӯ баду корҳои бародараш дуруст буданд. ");
INSERT INTO tgk_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Бинобар ин, эй бародаронам, агар одамони ҷаҳон аз шумо нафрат кунанд, ҳайрон нашавед. ");
INSERT INTO tgk_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Азбаски бародарони худро дӯст медорем, мо медонем, ки аз марг ба ҳаёт гузаштем. Ҳар кӣ бародари худро дӯст намедорад, ҳанӯз ҳам зери дасти марг аст. ");
INSERT INTO tgk_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Ҳар кӣ бародари худро бад мебинад, одамкуш аст. Шумо бошед, медонед, ки дар даруни ҳеҷ як одамкуш ҳаёти абадӣ нест. ");
INSERT INTO tgk_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Чӣ будани муҳаббатро мо дар Исои Масеҳ мебинем, ки Ӯ ҷони худро барои мо фидо кард. Мо низ бояд худро барои бародарони худ фидо кунем. ");
INSERT INTO tgk_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Агар касе молу мулк дошта бошаду бинад, ки бародараш мӯҳтоҷӣ дорад, вале нисбати ӯ сангдил монад, магар муҳаббати Худо дар дили вай ҳаст? ");
INSERT INTO tgk_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Фарзандони азиз, биёед мо на бо забону сухан, балки дар амал ва ростӣ муҳаббатро нишон диҳем. ");
INSERT INTO tgk_vpl VALUES ("J13_19","092_3_19","1JN","3","19","20","Агар ҳамин тавр кунем, медонем, ки мо аз они ростӣ ҳастем ва агарчи виҷдонамон моро азоб диҳад ҳам, дар ҳузури Худо диламон ором мебошад, зеро Худо аз виҷдони мо бузургтар аст ва аз ҳама чиз огоҳ мебошад. ");
INSERT INTO tgk_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Дӯстони азиз, агар виҷдонамон моро азоб надиҳад, пас дар пеши Худо сарамонро бардошта меистем ва ");
INSERT INTO tgk_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","азбаски ба фармонҳои Ӯ итоат мекунем ва кори писандидаи Ӯро иҷро менамоем, ҳар чӣ хоҳиш кунем, аз Ӯ мегирем. ");
INSERT INTO tgk_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","Фармони Ӯ ин аст, ки ба Писараш Исои Масеҳ бовар кунем ва аз рӯи фармони Ӯ якдигарро дӯст дошта бошем. ");
INSERT INTO tgk_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Касоне, ки ба ин фармон итоат мекунанд, дар Ӯ зиндагӣ мекунанд ва Ӯ дар дохили онҳо зиндагӣ мекунад. Аз куҷо мо мефаҳмем, ки Ӯ дар дохили мо зиндагӣ мекунад? Аз Рӯҳи Муқаддас мефаҳмем, ки Ӯ ба мо додааст. ");
INSERT INTO tgk_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Эй азизон, ба ҳар касе, ки «ман Рӯҳи Худо дорам» мегӯяд, бовар накунед. Онҳоро санҷед, ки оё ростӣ аз тарафи Худоянд, чунки ба ҷаҳон бисёр пайғамбарони бардурӯғ омадаанд. ");
INSERT INTO tgk_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Шумо Рӯҳи Худоро ин тавр шинохта метавонед: ҳар рӯҳе, ки бо ҷисми инсонӣ омадани Исои Масеҳро иқрор мекунад, аз Худост, ");
INSERT INTO tgk_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","аммо ҳар рӯҳе, ки инро иқрор намекунад, аз Худо нест. Баръакс ин рӯҳ аз ҷониби душмани Масеҳ аст, ки шумо дар бораи омада истодани ӯ шунидаед ва ӯ аллакай дар ҷаҳон аст. ");
INSERT INTO tgk_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Фарзандони азиз, шумо аз они Худо ҳастед, бинобар ин Касе, ки дар дохили шумо ҳаст, бузургтар аз онест, ки дар ҷаҳон мебошад. Пас шумо пайғамбарони бардурӯғро мағлуб сохтаед. ");
INSERT INTO tgk_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Онҳо аз они ҷаҳон мебошанд, бинобар ин мувофиқи ин ҷаҳон гап мезананд ва одамони ҷаҳон онҳоро гӯш мекунанд. ");
INSERT INTO tgk_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Мо бошем, аз они Худо ҳастем ва ҳар касе, ки Худоро мешиносад, моро гӯш мекунад. Аммо онҳое, ки аз они Худо нестанд, моро гӯш намекунанд. Ана аз ҳамин мо рӯҳи ростиро аз рӯҳи фиреб фарқ мекунем. ");
INSERT INTO tgk_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Азизон, биёед якдигарро дӯст дорем, чунки муҳаббат аз Худо аст. Ҳар кӣ муҳаббат нишон медиҳад, аз Худо таваллуди нав гирифтааст ва Худоро мешиносад. ");
INSERT INTO tgk_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Худо муҳаббат аст, пас ҳар кӣ муҳаббат нишон намедиҳад Худоро намешиносад. ");
INSERT INTO tgk_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","Муҳаббати Худо ба мо ин тавр намоён шудааст, ки Ӯ Писари ягонаи худро ба ҷаҳон фиристод, то ки мо ба воситаи Ӯ ҳаёти абадӣ ба даст оварем. ");
INSERT INTO tgk_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Ана ин муҳаббат аст, ки на мо Худоро дӯст доштем, балки Ӯ моро дӯст дошт ва Писари худро фиристод, то ки Ӯ барои ором кардани ғазаби Худо ва бахшида шудани гуноҳҳои мо фидо шавад. ");
INSERT INTO tgk_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Азизонам, агар Худо моро ин қадар дӯст дорад, пас мо низ бояд якдигарро дӯст дорем. ");
INSERT INTO tgk_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Худоро касе надидааст, вале агар мо якдигарро дӯст дорем, Худо дар дохили мо зиндагӣ мекунад ва муҳаббати Ӯ дар дохили мо ба ҳадди комил мерасад. ");
INSERT INTO tgk_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Дар Худо сокин буданамон ва Худо дар мо сокин буданашро мо аз ин медонем, ки Ӯ Рӯҳи худро ба мо додааст. ");
INSERT INTO tgk_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Инчунин мо бо чашми худ дидем ва шаҳодат медиҳем, ки Падар Писари худро ҳамчун Наҷотдиҳандаи ҷаҳон фиристодааст. ");
INSERT INTO tgk_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Дар дохили касоне, ки Писари Худо будани Исоро иқрор мекунанд, Худо сокин мебошад ва онҳо дар Худо сокин мебошанд. ");
INSERT INTO tgk_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Ана ҳамин тавр мо муҳаббати Худоро нисбати худ шинохтем ва ба он бовар мекунем. Худо муҳаббат аст ва онҳое, ки дар муҳаббат мемонанд, дар Худо сокин мебошанд ва Худо дар онҳо мебошад. ");
INSERT INTO tgk_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Муҳаббати Худо дар мо ба ҳадди комил расидааст, то ки мо дар рӯзи ҷазо бо сари бардошта истода тавонем, чунки мо дар ин ҷаҳон монанди Ӯ ҳастем. ");
INSERT INTO tgk_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Дар муҳаббат тарс нест, баръакс муҳаббати пурра тарсро аз байн мебарад. Касе, ки тарс дорад, интизори ҷазо аст. Ӯ ҳанӯз ба ҳадди комили муҳаббат нарасидааст. ");
INSERT INTO tgk_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Мо барои он муҳаббат нишон медиҳем, чунки аввал Худо моро дӯст доштааст. ");
INSERT INTO tgk_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Агар касе мегӯяд, ки ӯ Худоро дӯст медорад, аммо бародарашро бад мебинад, дурӯғгӯй аст. Зеро агар мо бародаронро бад бинем, дар ҳоле ки чашмамон онҳоро мебинанд, пас Худоро, ки чашмамон намебинад, дӯст дошта наметавонем. ");
INSERT INTO tgk_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","Фармони Худо ин аст, ки ҳар кӣ Ӯро дӯст дорад, бояд бародари худро низ дӯст дорад. ");
INSERT INTO tgk_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Ҳар касе, ки ба Таъиншудаи Худо будани Исо бовар мекунад, таваллуди нав аз Худо гирифтааст ва ҳар кӣ падарро дӯст дорад, фарзандашро низ дӯст медорад. ");
INSERT INTO tgk_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Агар мо Худоро дӯст дорем ва фармонҳои Ӯро иҷро кунем, бо ҳамин мефаҳмем, ки фарзандони Худоро дӯст медорем. ");
INSERT INTO tgk_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Зеро Худоро дӯст доштан ин фармонҳои Ӯро иҷро кардан аст. Фармонҳои Ӯ бошанд, вазнин нестанд, ");
INSERT INTO tgk_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","чунки ҳар кӣ аз Худо таваллуди нав гирифтааст, ҷаҳонро ғалаба мекунад ва ин ғалабае, ки бар ҷаҳон ғолиб мебарояд, имони мост. ");
INSERT INTO tgk_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Пас кӣ бар ҷаҳон ғолиб мебарояд? Фақат он касе, ки ба Писари Худо будани Исо бовар мекунад. ");
INSERT INTO tgk_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Исои Масеҳ ҳамонест, ки ба воситаи обу хун омадааст. Ӯ на фақат ба воситаи об, балки ба воситаи обу хун омадааст. Инро Рӯҳ шаҳодат медиҳад, чунки Рӯҳ ҳақ аст. ");
INSERT INTO tgk_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Зеро се шоҳид аст, ки шаҳодат медиҳад: ");
INSERT INTO tgk_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","Рӯҳ, об ва хун ва ҳар сеи онҳо забон як доранд. ");
INSERT INTO tgk_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Мо шаҳодати инсонро қабул мекунем, вале шаҳодати Худо чӣ қадар бештар боварибахш аст. Охир дар ин ҷо худи Худо дар бораи Писараш шаҳодат додааст. ");
INSERT INTO tgk_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Касе, ки ба Писари Худо бовар мекунад, дар дили худ ин шаҳодатро дорад. Аммо ҳар кӣ ба Худо бовар намекунад, Ӯро дурӯғгӯй месозад, чунки ба шаҳодате, ки Худо дар бораи Писараш додааст, бовар накард. ");
INSERT INTO tgk_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Ин ҳам шаҳодати Худо аст, ки Ӯ ба мо ҳаёти абадӣ бахшидааст ва ин ҳаёт дар Писари Ӯст. ");
INSERT INTO tgk_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Ҳар кӣ бо Писар аст, ин ҳаётро дорад ва ҳар кӣ бо Писари Худо нест, ин ҳаётро надорад. ");
INSERT INTO tgk_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Ман ин суханонро ба шумое, ки ба Писари Худо бовар мекунед, менависам, то донед, ки соҳиби ҳаёти абадӣ ҳастед. ");
INSERT INTO tgk_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","Бинобар ин мо дар ҳузури Худо ин бовариро дорем, ки ҳар чӣ мувофиқи хости Ӯ хоҳиш кунем, Ӯ ба мо гӯш меандозад. ");
INSERT INTO tgk_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","Пас, агар донем, ки Ӯ ҳар хоҳиши моро мешунавад, мо инчунин медонем, ки чизи хоҳишкардаамонро ба даст овардаем. ");
INSERT INTO tgk_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Агар шумо бинед, ки бародаратон гуноҳе мекунад, ки ба марг намебарад, бояд барояш дуо кунед ва Худо ба ӯ ҳаёт мебахшад, яъне ба оне, ки гуноҳи ба марг набаранда мекунад. Чунки гуноҳе ҳаст, ки ба марг мебарад ва ман намегӯям, ки барои чунин гуноҳ бояд дуо кунед. ");
INSERT INTO tgk_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Ҳамаи корҳои нодуруст гуноҳ ҳастанд, вале ин гуноҳест, ки ба марг намебарад. ");
INSERT INTO tgk_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Мо медонем, ҳар касе ки аз Худо таваллуди нав ёфтааст, гуноҳ карданро давом намедиҳад, балки Писари Худо онҳоро эҳтиёт мекунад ва Шахси Бад ба онҳо даст расонда наметавонад. ");
INSERT INTO tgk_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","Мо низ медонем, ки мо фарзандони Худо ҳастем ва тамоми ҷаҳон зери дасти Шахси Бад мебошад. ");
INSERT INTO tgk_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","Мо боз медонем, ки Писари Худо омад ва ба мо қобилияти фаҳмиданро додааст, то мо ҳамонеро, ки ростӣ аст, шиносем. Мо бошем, дар ҳамоне, ки ростист ва дар Писари Ӯ Исои Масеҳ ҳастем. Ӯ Худои ҳақиқӣ ва ҳаёти абадӣ аст. ");
INSERT INTO tgk_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Фарзандони азиз, худро аз бутпарастӣ эҳтиёт кунед. ");
INSERT INTO tgk_vpl VALUES ("J21_1","093_1_1","2JN","1","1","2","Аз роҳбари ҷамоати имондорон ба хонуме, ки Худо интихоб кардааст, ва фарзандони вай, ки ба ростӣ дӯсташон медорам. Мо ҳарду ҳамон як ростиро дӯст медорем, ки он дар мо ҳоло мебошад ва то абад бо мо мемонад. На фақат ман шуморо дӯст медорам, балки ҳамаи онҳое ҳам, ки ростиро мешиносанд. ");
INSERT INTO tgk_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","Бигзор файзу раҳмат ва сулҳу осоиштагӣ аз ҷониби Худо-Падар ва Исои Масеҳ, Писари Падар бо мо, ки ростиро медонем ва якдигарро дӯст медорем, бошад. ");
INSERT INTO tgk_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","Аз фаҳмидани он, ки баъзе фарзандони шумо мувофиқи фармоиши Падар дар роҳи ростӣ зиндагӣ мекунанд, бениҳоят хурсанд шудам. ");
INSERT INTO tgk_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","Ҳоло ҳам, хонуми мӯҳтарам, ба шумо на фармони нав, балки ҳамонеро, ки аз аввал доштем, менависам ва хоҳиш мекунам, ки ҳамаамон якдигарро дӯст дорем. ");
INSERT INTO tgk_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","Муҳаббат бошад, дар ин аст, ки мо ба фармонҳои Худо итоат намуда, зиндагӣ кунем. Фармони Ӯ ҳамонест, ки аз аввал шунидаед, яъне бо роҳи муҳаббат равед. ");
INSERT INTO tgk_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","Дар ҷаҳон бисёр фиребгарон баромадаанд, ки дар ҷисм омадани Исои Масеҳро қабул намекунанд. Ин хел одамон фиребгар ва душмани Масеҳ ҳастанд. ");
INSERT INTO tgk_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","Эҳтиёт шавед, то чизеро, ки барояш заҳмат кашидаем, аз даст надиҳед. Баръакс ба мукофоти пурра ноил гардед. ");
INSERT INTO tgk_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Ҳар кӣ таълимоти Масеҳро иҷро намекунаду аз ҳадду ҳудуди он мебарояд бо Худо нест. Аммо касе, ки дар ин таълимот мемонад, ҳам бо Падар ва ҳам бо Писар мебошад. ");
INSERT INTO tgk_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","Агар касе пеши шумо ояду ин таълимотро наоварад, ӯро ба хонаатон роҳ надиҳед ва қабул накунед. ");
INSERT INTO tgk_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","Зеро касе, ки ӯро қабул мекунад, шарики корҳои бади ӯ мегардад. ");
INSERT INTO tgk_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","Боз чизи зиёд ба шумо гуфтанӣ ҳастам, вале бар ивази истифода бурдани коғазу ранг, умедворам, ки шуморо хабар гирифта чашм ба чашм сӯҳбат кунем, то ки шодиамон лабрез гардад. ");
INSERT INTO tgk_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","Фарзандони хоҳари интихобшудаат салом мегӯянд. ");
INSERT INTO tgk_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","Аз роҳбари ҷамоати имондорон ба Ғаюси азиз, ки дар ростӣ ӯро дӯст медорам. ");
INSERT INTO tgk_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Дӯсти азизам, ман дуо мекунам, ки аз ҳар ҷиҳат ривоҷу равнақ ёбӣ ва сиҳату саломат бошӣ, чуноне ки дилу ҷонат равнақ меёбад. ");
INSERT INTO tgk_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","Вақте ки чанд бародарон омада, ба ман шаҳодат доданд, ки ту ба ростӣ бовафо ҳастӣ ва дар роҳи ростӣ меравӣ, ман бениҳоят хурсанд шудам. ");
INSERT INTO tgk_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","Аз шунидани он, ки фарзандони ман дар роҳи ростӣ мераванд, бароям хурсандии бузургтаре нест. ");
INSERT INTO tgk_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Дӯсти азиз, ту дар он рафторе, ки нисбат ба бародарон мекунӣ, асосан ба бародарони бароят ношинос бовафо ҳастӣ. ");
INSERT INTO tgk_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","Ин бародарон дар бораи муҳаббати ту дар пеши ҷамоати имондорон шаҳодат доданд. Кори хуб мекунӣ, агар онҳоро тавре ба сафарашон гусел намоӣ, ки иззати Худоро ба ҷо меорад. ");
INSERT INTO tgk_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","Чунки онҳо аз барои номи Ӯ ба сафар баромадаанд ва аз беимондорон чизе қабул накарданд. ");
INSERT INTO tgk_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","Бинобар ин мо бояд чунин одамонро таъмин намоем, то ки дар роҳи ростӣ ҳамкор шавем. ");
INSERT INTO tgk_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","Ман дар бораи ин ба ҷамоати имондорон нависта будам, аммо ҳамон Деотрефес, ки роҳбарӣ карданро дӯст медорад, гапи моро дар замин монд. ");
INSERT INTO tgk_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","Пас, дар сурати омаданам, ман корҳои ӯро ва суханони зишташро, ки бар зидди мо мегӯяд, ба рӯи об мебарорам. Ба ӯ ин корҳояш ҳам кам аст, ки боз аз қабул кардани бародарон рӯй мегардонад. Ӯ ба дигарон низ, ки қабул кардан мехоҳанд, роҳ намедиҳад. Ҳатто онҳоро аз ҷамоати имондорон берун мекунад. ");
INSERT INTO tgk_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Дӯсти азизам, рафтори хубро тақлид кун ва на рафтори бадро. Зеро ҳар кӣ хубӣ мекунад аз ҷониби Худо аст. Аммо касе, ки бадӣ мекунад, Худоро надидааст. ");
INSERT INTO tgk_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Ана Деметрусро ҳама таъриф мекунанд, ҳатто худи ростӣ инро тасдиқ мекунад. Мо ҳам дар бораи ӯ шаҳодат медиҳем ва ту медонӣ, ки шаҳодати мо рост аст. ");
INSERT INTO tgk_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","Боз зиёд чиз ба ту гуфтанӣ ҳастам, лекин намехоҳам, ки онро бо ранг дар рӯи коғаз нависам. ");
INSERT INTO tgk_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","Ман умедворам, ки ба зудӣ туро мебинам ва чашм ба чашм гап мезанем. ");
INSERT INTO tgk_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Саломат бош. Дӯстони инҷо будаат ба ту салом мегӯянд, ту низ дӯстони онҷоро як ба як салом гӯй. ");
INSERT INTO tgk_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","Ман, Яҳудо, бандаи Исои Масеҳ ва бародари Яъқуб ҳастам. Ба даъватшудагон, ки дар Худо Падар муҳаббат пайдо намуда, дар паноҳи Исои Масеҳ мебошанд, ");
INSERT INTO tgk_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","лутфу меҳрубонӣ, осоиштагӣ ва муҳаббат орзумандам! ");
INSERT INTO tgk_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","Дӯстони азиз, хеле мехостам ба шумо дар бораи наҷоти умумиямон нависам. Лекин ҳоло зарур донистам, ки ин номаро навишта, шуморо рӯҳбаланд созам, то барои имоне, ки боре ба муқаддасон дода шудааст, мубориза баред. ");
INSERT INTO tgk_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","Зеро баъзе касон, ки дар бораи маҳкум шуданашон ҳанӯз дар замони қадим навишта шудааст, пинҳонӣ дар миёни шумо ҷой гирифтаанд. Онҳо худобехабар буда, файзи Худои моро ҳамчун иҷозат ба бадахлоқии ҷинсӣ медонанд ва ягона Ҳокиму Худованди мо Исои Масеҳро рад мекунанд. ");
INSERT INTO tgk_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","Ҳоло мехоҳам он чиро, ки худатон хуб медонед, бори дигар ба шумо хотиррасон намоям. Худованд мардуми Худро аз замини Миср халос кард, вале сипас аз байнашон онҳоеро, ки бовар накарданд, нобуд сохт. ");
INSERT INTO tgk_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","Инчунин, фариштаҳо мақоми худро нигоҳ надошта, манзили худро тарк карданд. Ӯ онҳоро дар торикии абадӣ занҷирбанд намуда, барои рӯзи бузурги қиёмат нигоҳ медорад. ");
INSERT INTO tgk_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","Мисли ин фариштаҳо, шаҳрҳои Садӯму Амӯро ва деҳоти гирду атрофи онҳо, ки ба бадахлоқии ҷинсӣ ва хоҳишҳои ғайритабиӣ дода шуда буданд, ҳамчун намуна гирифтори ҷазои оташи абадӣ гаштанд. ");
INSERT INTO tgk_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","Ин одамон дар асоси хобҳои дидаашон ҷисмашонро ҳаром мекунанд ва қудрати Худовандро рад менамоянду ҷалолдорони осмониро дашном медиҳанд. ");
INSERT INTO tgk_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","Ҳол он ки ҳатто фариштаи бузург Микоил чун бо иблис дар бораи ҷасади Мусо пайғамбар баҳс мекард, ба худ раво надид, ки ӯро бо дашном ҳукм намояд. Ӯ ба иблис танҳо гуфт, ки бигзор Худованд сазои туро диҳад. ");
INSERT INTO tgk_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","Ин одамон намедонанд, ки киро дашном медиҳанд. Лекин он чӣ ки табиатан, мисли ҳайвони беақл мефаҳманд, онҳоро нобуд мекунад. ");
INSERT INTO tgk_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","Вой бар ҳоли чунин одамон, чунки бо роҳи Қоин мераванд, пул гуфта, гирифтори хатои Билъом шудаанд ва саркашӣ намуда, мисли Қӯраҳ нобуд мешаванд. ");
INSERT INTO tgk_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","Онҳо ҳангоми хӯроки шомҳои муҳаббат байни шумо мисли санги пешпое нишаста, бе тарсу ҳарос худро мепарваранд. Онҳо абрҳои беобанд, ки бод мебарад ва дарахтони бемеваанд, ки дар тирамоҳ решакан мешаванд ва дубора мемиранд. ");
INSERT INTO tgk_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","Онҳо мавҷҳои шадиди баҳранд, ки шармандагии худро мисли кафк рӯйи об мебароранд. Онҳо ситорагони овораанд, ки барои ҳамеша ба торикии зулмонӣ хоҳанд рафт. ");
INSERT INTO tgk_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","Ҳамчунин, Ҳанӯҳ, ки насли ҳафтуми Одам буд, дар бораи онҳо пешгӯйӣ намуда гуфтааст: «Бингар, Худованд бо ҳазор-ҳазор муқаддасони Худ меояд. ");
INSERT INTO tgk_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","Меояд то ки ҳамаро маҳкум намояд ва ҷони ҳар гунаҳкорро мувофиқи кирдори бадаш ва суханони бешармонааш, ки ба Ӯ гуфтааст, ҷазо диҳад». ");
INSERT INTO tgk_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","Онҳо ҳамеша шикоят мекунанд ва баҳона меҷӯянд, аз пайи хоҳишҳои худ ҳастанд, бо худ меболанд ва барои фоидаи худ хушомад мезананд. ");
INSERT INTO tgk_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","Аммо шумо, дӯстон, суханони фиристагони Худовандамон Исои Масеҳро, ки пеш ба шумо гуфта буданд, дар ёд доред. ");
INSERT INTO tgk_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","Онҳо ба шумо чунин мегуфтанд: «Дар охирзамон масхарабозоне ба миён меоянд, ки аз пайи хоҳишҳои бади худ мераванд». ");
INSERT INTO tgk_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","Онҳо ҷудоӣ меандозанд, мувофиқи майлҳои ҷисмонӣ рафтор мекунанд, лекин Рӯҳи Худоро надоранд. ");
INSERT INTO tgk_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","Аммо шумо, дӯстони азиз, бо Рӯҳи Пок пайваста дуо карда, худро бар имони поктаринатон бунёд кунед. ");
INSERT INTO tgk_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","Худро дар муҳаббати Худо нигоҳ доред, чунки ҳоло умедвори марҳамати Худовандамон Исои Масеҳ барои ҳаёти абадӣ мешавед. ");
INSERT INTO tgk_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","Нисбат ба онҳое, ки дудила ҳастанд, раҳмдил бошед. ");
INSERT INTO tgk_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","Баъзеро гӯё аз дами оташ кашида, наҷот диҳед. Нисбати баъзеи дигар бо эҳтиёт дилсӯзӣ намоед, ҳатто ба либосе, ки олудаи ҷисми гунаҳкор аст, даст нарасонед. ");
INSERT INTO tgk_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","Ба Ӯ, ки шуморо аз гуноҳ нигоҳ дошта, бе камбудӣ ва бо шодмонӣ пеши ҷалоли Худ оварда метавонад, яъне ");
INSERT INTO tgk_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","бар Худои ягона, ки ба воситаи Худованд Исои Масеҳ наҷоткори мо шудааст, дар тӯли асрҳо, аз имрӯз то абад бузургиву ҷалолат ва нерӯву қудрат бод! Омин! ");
ALTER TABLE tgk_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
