﻿USE sofia;
DROP TABLE IF EXISTS sofia.tgj_vpl;
CREATE TABLE tgj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tgj_vpl WRITE;
INSERT INTO tgj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Si Abraham gvlo linv Dabid gv husi Jisu Kristo gv nwdwv. ");
INSERT INTO tgj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Abraham lokv naalaila Dvbv Dabid lobv soogv nwdw ha lvkpvpv: Abraham Isaak gv abuv, Isaak Jakob gv abuv, Jakob Juda gvla ninyigv boru vdwgv abuv. Okv Tamar gvlokv bvngnam Perej gvla Jera gv abuv Juda. Okv Perej Hejron gv abuv, okv Hejron Ram gv abuv. Ram Amminadab gv abuv, Amminadab Naason gv abuv, Naason Salmon gv abuv. Salmon gv kuunyilo hv Boaj, hv Rahab gvlokv bvngnam v, okv Boaj gv kuunyilo ngv Obed, hv Rut gvlokv, okv Obed gv kuunyilo ngv Jesse okv Jesse gv kuunyilo ngv Dvbv Dabid. ");
INSERT INTO tgj_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Dabid lokv naalaila Israel nyi vdwa Bebilon lo nyirabv naakunam lobv soogv nwdw vdwa lvkpvpv: Okv Jesse Dvbv Dabid gv abuv, Dvbv Dabid gv kuunyilo ngv Solomon (Ninyigv anv ngv Uriah gv nywng ngv), Solomon Rehoboam gv abuv, Rehoboam Abija gv abuv, Abija Asa gv abuv. Asa Jehosapat gv abuv, Jehosapat Jehoram gv abuv, Jehoram Ujjiah gv abuv. Ujjiah Jotam gv abuv, Jotam Ahaj gv abuv, Ahaj Hejekiah gv abuv. Hejekiah Mannasse gv abuv, Mannasse Amon gv abuv, Amon Josia gv abuv. Okv Josia Jehoiachin gvla ninyigv boru vdwgv abuv, so si Bebilon lo nyirabv rila doodw ngvku. ");
INSERT INTO tgj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Bebilon lo nyirabv rila dooro koching lokv naalaikula Jisunyi bvngdw lobv soogv nwdw ha lvkpvpv: Jehoiachin Sealtiel gv abuv, Sealtiel Jerubbabel gv abuv. Jerubbabel Abiud gv abuv, Abiud Eliakim gv abuv, Eliakim Ajor gv abuv. Ajor, Jadok gv abuv, Jadok Akim gv abuv, Akim Eliud gv abuv. Eliud Eliajar gv abuv, Eliajar Matan gv abuv, Matan Jakob gv abuv. Okv Jakob, Kristo vla minam Jisunyi bvngnv Meri gv nyilu Josep gv abuv. ");
INSERT INTO tgj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Vbvrikunamv Abraham lokv Dabid lobv singtam vring gola api go, okv Dabid lokv Bebilon lo nyirabv rila doonam lobv vring gola api singtam go okv hokv naalaikula Jisu Kristonyi bvngnam lobv singtam vring gola api gobv ritoku. ");
INSERT INTO tgj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisu Kristonyi svbvching mooku so dwrwboklin toku. Ninyigv anv Merinyi Josep gvlo minggag jitoku, vbvritola bunyiv nywng nyilubv rila dooba sutv madvbv hv Darwknv Dow lokv anga go dootvdu vla chinsu toku. ");
INSERT INTO tgj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep tarwkbaknv nyi go, vkvlvgabv Merinyi nyi vdwgv kaagialo hinying momare mvngla, mingak minsu nama atubongv kayu dukubv rungtoku. ");
INSERT INTO tgj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ho lvkwngbv ninyigv vbv mvngdung rilo, Ahtu gv nyidogindung ako yumalo aala ninyia mintoku, “Josep, Dabid gv husi, Merinyi no gv nywngbv naase nga busu mabvka. Ninyigv kuugvnam v Darwknv Dow lokv gvdunv. ");
INSERT INTO tgj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nw kuunyilo ako bvngri, okv no hum Jisu vla amin minre—ogulvgavbolo hv ninyigv nyi vdwa bunugv rimur loka ringlin reku.” ");
INSERT INTO tgj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Vjak so mvnwng si ridu Pwknvyarnv gv kvvlo nyijwk vdwlo minam dvdv nga jvjv bv rilin modubv. ");
INSERT INTO tgj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Darwknv nyijar gunv kuu gvla, okv kuunyilo gubv bvngre, okv ninyia Immanuel vla minre” (So minam si, “Pwknvyarnv ngonugv rikulo reming gvduku,” vnam v). ");
INSERT INTO tgj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Vkvlvgabv vdwlo Josep gudung tokudw nw nyidogindung gv ninyia ritokv vla mingkubv nw Merinyi nywngbv naatoku. ");
INSERT INTO tgj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Vbvritola nw Meri gv kuunyilo nga bvngtv madv yika nw Merinyi doogvkargv matoku. Okv Josep ninyia Jisu vla amin mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judia mookugv Betlehem banggu lo Jisunyi bvngtoku, Herod gv Dvbv bv rila doori hoka. Vbvridanam gula doonyi chaagu mooku lokv nyido takar a chinv nyi mego Jerusalem lo aatoku ");
INSERT INTO tgj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","okv tvvkato, “Jius vdwgv Dvbv bv rijinv vmi anga nga ogolo bvngpv? Ngonu ninyigv takar a chaagu kiambv chaalin nama kaala ninyia kumdujodubv aapvnv.” ");
INSERT INTO tgj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Vdwlo Dvbv Herod sum tvvpa tokudw, hv achialvbv mvngru toku, okv Jerusalem gv nyi mvnwng ngvka. ");
INSERT INTO tgj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nw Nyibu Butvnv mvnwngnga okv pvbv tamsarnv vdwa gokkum tola bunua tvvkato, “Ogolodw Kristonyi dwrwboklin jikuv?” ");
INSERT INTO tgj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Judia mookugv Betlehem lo,” bunu mirwkto. “Vkvlvgavbolo nyijwk vdwv svbv lvkpvpv: ");
INSERT INTO tgj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judah mookugv kvdw Betlehem a, no Judah mookugv pamtv mvnwng lokv miang nvgobv ribwng kumare; noogv lokv rigv nvgo linre, hv ngoogv Israel nyi vdwa rigvre.’” ");
INSERT INTO tgj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Vkvlvgabv Herod chaagu lokv kaalwknv nyi vdwa kvba doosi kolo goklwk toku okv bunugv lokv chintoku takar v dw tvrwk lo boklin pvnvnyi vla. ");
INSERT INTO tgj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Vbvrikunamv nw bunua svbv gaam mingv rikula Betlehem lo vngmu toku: “Vngnyika okv anga nga alvbv makar laka, okv vdwlo nonu mapa ridw, ngaaka chimu labv, ngo ka vngla ninyia kumdujodubv.” ");
INSERT INTO tgj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Okv vkvlvgabv bunu vngrap toku, okv bunugv lamtvlo bunu doonyi chaagu kiamgv takar kaanam anga lvkodv kaapa toku. Vdwlo bunu um kaapa tokudw, bunu achialvbv mvngpu laku, bunu achialv himpu punya toku! Hv bunua vngcho-vngcho gvla anga gv dooku lo vnglwk gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bunu naam arwnglo aatoku, okv vdwlo bunu vmi anga nga anv Meri nga lvkobv doodubv kaato kudw, bunu lvbwng ngv kumpvla gublwk dvla ninyia kumtojotoku. Bunugv amin gvnamv ain go, nampunv tvli go, okv nampunv amokayok jungnv guka naalinla ninyia jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Vbvrikunamv bunu akusunv lamtvbv vngla bunugv mooku lo vngkurla vngtoku, ogulvgavbolo Pwknvyarnv bunua yumalo gamrwto Herod gv dookubv vngpit kumabvkv vla mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bunugv vngyuro kochingbv, yuma goloka Ahtu gv nyidogindung gonv Josep gvlo aala mintoku, “Herod vmi anga nga mvkidubv vla ninyia makar kardu. Vkvlvgabv gudung tvka, okv vmi anga hala anv nga vnggv laila Ijipt lo kisum gvtoka, okv vdwlo ngo vnglakukv vla mima redw hoka doobwng laka.” ");
INSERT INTO tgj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep dokrap toku, vmi anga hala anv nga vnggv laila ayu Ijipt lo kisum toku, ");
INSERT INTO tgj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nw hoka Herod gv sima dvdvlobv dobwngto. So si Ahtu gv nyijwk vdwlo, minpvnam gaam “Ijipt lokv ngoogv Kuunyilo nga gokpv kunv,” vnam a jvjvbv rilin modukubv si ripvnv. ");
INSERT INTO tgj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Vdwlo Herod chaagu kiamgv kaalwknv nyi vdwv ninyia mvvpv kunvnyi vla chinto kudw, nw achialvbv dokcha toku. Nw Betlehem okv doosindoin gv vminyilo nyingnyinv okv miangnv mvnwngnga mvkidubv orto go jitoku—so si vbv ritoku vdwlo chaagu kiamgv nyi kaalwknv vdwa takar gv unglin jirilokv nw sum chintoku. ");
INSERT INTO tgj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Svbvrila nyijwk Jeremia gv minam v jvjv bv rilin toku: ");
INSERT INTO tgj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama lo dutv rungnv adu go tvvpadu, hidwkla kapnam adu go. Rakel gv kuu vdwv siro kunam lvkwngbv: nw maaku jimakv vla, siinyimar mvla kapdu.” ");
INSERT INTO tgj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod gv siro kochingbv, Ahtu gv nyidogindung ako Ijipt lo Josep gv yumalo aalwk toku ");
INSERT INTO tgj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","okv minto, “Gudungto, vmi anga hala okv ninyigv anv nga naalaila, Israel mookubv vngkur tokuka, ogulvgavbolo vmia mvkidubv rungnv vdwv siroku.” ");
INSERT INTO tgj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Vkvlvgabv Josep gudung toku, vmi hala okv anv ha naalaila, Israel mookubv vngkur gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Vbvritola vdwlo Josep Arkelaus Judia lo ninyigv abu Herod gv Dvbv svngtung nga svngsit pvkv vla tvvpa pvkudw, nw hoka vngdubv busuto. Ninyia yumalo abuyabv mintamto, vkvlvgabv hv Galili gv mooku lo vngtoku ");
INSERT INTO tgj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","okv Najaret vnam banggu lo ninyigv naam a mvtoku. Okv vkvlvgabv nyijwk vdwgv “Ninyia Najarene vla minre” vnammv jvjvbv rilin toku. ");
INSERT INTO tgj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Vbvrire hoka Jon Baptist Judia gv chukrimooku lo aala japgo raptoku. ");
INSERT INTO tgj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nw minto, “Nonu rimur lokv mvngdin tokuka, ogulvgavbolo Nyidomooku Karv ngv nvchi dooku!” ");
INSERT INTO tgj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon vkvnv nyi ako nyijwk Aijaya gv minam angv, Aijaya minto, “Chukrimooku v nyi go gokdungdo, ‘Ahtu gv lvgabv lamtv nga mvkimvak jilakv; ninyia vngmu dubv lamtv nga sorchi dubv mvtokv!’” ");
INSERT INTO tgj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon gv vjiv kemel amw lokv mvnam go; hv apin hukpia go hukto, okv ninyigv dvnam v takamyarup okv tangungula go. ");
INSERT INTO tgj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem lokv Judia mooku mvnwng lokv okv Jordan svko nvchi gv mooku lokv nyi vdwv ninyi gvlo aanyato. ");
INSERT INTO tgj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bunu bunugv rimur lokv mvngdin nyatoku okv nw bunua Jordan svko lo baptisma jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Vdwlo Jon Parisis okv Sadusis vdwa ninyi gvlo baptisma jikudubv aadu bv kaato kudw, nw bunua minto, “Tabw vdw nonu—yvvla nonua Pwknvyarnv gv mvritririt jikulo nonu aamare vla minv? ");
INSERT INTO tgj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nonu rimur lokv lirung pvku vla kaachin dukubv rinam go rito kuka. ");
INSERT INTO tgj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Okv nonuno Abraham nonugv abu v vla Pwknvyarnv gv mvritririt mvji kolo aamare vla mvngma bvka. Ngo nonua mindunv Pwknvyarnv so vlwng vdw sum naala Abraham gv husi bv mvlare! ");
INSERT INTO tgj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yagwng ngv singnv nga miami laalubv palin dubv dooriado; singnv alvnv apwasi svvmanv dvdv nga palinla okv vmvlo orlwk dunv. ");
INSERT INTO tgj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nonu mvngdin pvku vla kaatambv ngo nonua isi lokv baptisma jidunv, vbvritola ngoogv kochinglo aarinv angv nonua Darwknv Dow lokv okv vmv lokv nonua baptisma jireku. Nw nga achialvbv kaiyadunv; okv ngo ninyigv lvkiam haka dvbwng yadubvka riyin yakuma. ");
INSERT INTO tgj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nw ninyigv aamtami kapkak nvnv upua doogv sudu. Nw ninyigv amkarmikar a nesunglo gvvlwk reku, vbvritola amsokmisok a nyimanv vmvlo ramyok reku.” ");
INSERT INTO tgj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Vbvrire hoka Jisu Galili lokv aalwk la okv Jon gvlo Jordan Svko lo aatoku, nw gvlokv baptisma naadubv vla. ");
INSERT INTO tgj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Vbvritola Jon ninyigv mvngnama mvngkurmvngrwk modubv gwngkwto, Jon minto, “Ngo ya no gvlo baptisma naaya svnga, no ngoogvlo ayapvi!” ");
INSERT INTO tgj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Vbvritola Jisu ninyia mirwkto, “Vjakgv lvgabv vbv doomu lajuka. Svbv rila Pwknvyarnv gv mvngnam mvnwngnga rilajuka.” Vkvlvgabv Jon mvnglwk minggv toku. ");
INSERT INTO tgj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisu baapubv baptisma naanam gula, nw isi lokv agum lo daklin toku. Vbvrikunamv Ninyi gvbv nyidomooku ngv kokok jito, okv Nw Pwknvyarnv gv Dow v taakw jvbv ritola ninyi gvlo jarlwk loodubv kaatoku. ");
INSERT INTO tgj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Vbvrikunamv nyidomooku tolokv gaamgo minto, “Si ngo atubogv paknam Kuunyilo ngv, ngoogv mvngyum namv.” ");
INSERT INTO tgj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Vbvrikunamv Dowv Jisunyi chukrimooku lo okv ninyia Uyu am pokayarka modukubv vnggvto. ");
INSERT INTO tgj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Alu champi gula okv ayu champigo dvmabv dooro koching so, Jisu kano toku. ");
INSERT INTO tgj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Vbvrikunamv Uyu ninyi gvlo aala minto, “No Pwknvyarnv gv Kuunyilo ngvbolo, so vlwng vdw sum vtwngbv ridubv mintoka.” ");
INSERT INTO tgj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Vbvritola Jisu mirwksito, “Darwknv Kitaplo mindu, ‘Nyi si vtwng lokv mwng turma dunv, vbvritola Pwknvyarnv gv minam gaam mvnwngnga dinchi dunv.’” ");
INSERT INTO tgj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Vbvrikunamv Uyu ngv Jisunyi Jerusalem bv vnggv toku, Darwknv Pamtv lo, ninyia Pwknvyarnvnaam aoyachoknv mwnglo aolo dakmuto, ");
INSERT INTO tgj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","okv ninyia minto, “No Pwknvyarnv gv Kuunyilo ngvbolo, atubongv sokv poklu kaatoka, vkvlvgavbolo Darwknv Kitaplo mindu, ‘Pwknvyarnv no gvbv ninyigv nyidogindung nga orto jire; bunu nam bunugv laak lo dvvbwngre, vkvlvgavbolo noogv lvchu nga achidubv vlwng aolo mvmu madubv.’” ");
INSERT INTO tgj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisu mirwksito, “Vbvritola Darwknv Kitaplo vbv mintadu, ‘Noogv Pwknvyarnvnyi no rikwripak mabvka.’” ");
INSERT INTO tgj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Vbvrikunamv Uyu hv Jisunyi vnggv laila moodw aoyachok kolo chaagv toku okv ninyia nyiamooku gv achialvbv kainv karv vdwa kaatam toku. ");
INSERT INTO tgj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Uyu v minto, “No nga gublwk dvla kumbojobo lo, nam ngo so gv kaagv dvnam mvnwng sum jire.” ");
INSERT INTO tgj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Vbvrikunamv Jisu mirwk toku, “Uyu! No vngroto, Darwknv Kitaplo mindu, “Noogv Pwknvyarnv nyimwng kumlajolaka okv Ninyigv lvgabv rimwng laka!’” ");
INSERT INTO tgj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Vbvrikunamv Uyu ngv Jisunyi vngyu toku; okv nyidogindung ngv aala Jisunyi ridur toku. ");
INSERT INTO tgj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jonnyi patwk lwknama vdwlo Jisu tvvpa pvkudw, nw Galili bv vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nw Najaret lo dooku mato, vbvritola Jibulun gvla Naptali mooku gv Svpar adar lo doonv banggu, Kaparnaum lo doodubv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Svbvrinam si nyijwk Aijaya gv minpv nama jvjvbv rilin modukubv ritoku, ");
INSERT INTO tgj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jebulun gv Kvdw okv Naptali gv kvdw, lamtv ngv svmasa lo inv, Jordan Svko gv takdv gonvlo, Galili, Jentail vdwgv kvdw! ");
INSERT INTO tgj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kanv arwnglo doonv nyi vdwv, kairungnv Loung go kaapare. Sinv vdwgv kanv mooku lo doonv vdwgvlo loung ngv ungjire.” ");
INSERT INTO tgj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Vbvriri lokv Jisu ninyigv doina japrap toku: “Nonuno rimur lokv mvngdin tokuka ogulvgavbolo Nyidomooku gv Karv ngv nvchi duku!” ");
INSERT INTO tgj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisu Galili gv Svpar gv adar lo vngkar rilo, achiboru sinyi go aminv Saimon (Pitar vnam) okv ninyigv boru Andriu vsap lokv svpar lo ngui naadung dubv kaapato. ");
INSERT INTO tgj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisu bunua minto, “Nga vngming gvlaka, okv ngo nonua nyi naadubv tamsarre.” ");
INSERT INTO tgj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Vjakgobv bunu vsap a kayupila ninyia lvkobv vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nw vngdavngra la kvvbi achiboru sigodv kaapato, Jibedi gv kuunyilo Jon nyila Jemsnyi. Bunu svpw lo vsap a mvgemvrap sila doonyato. Jisu bunua gokto, ");
INSERT INTO tgj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","okv bunu vjakgobv svpwa okv bunugv abua kayupila ninyia lvkobv vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisu Galili gv mooku mvnwng lo vnggo karto, Jius kumku-naam lo tamsarla, Nyidomooku gv Karv gv lvkwng nga japgola, nvgwngnv achiapikla lvvmanv nyi vdwa mvpujila ritoku. ");
INSERT INTO tgj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jisu gv vbvrinam gv yunying ngv Sairia gv mooku mvnwnglo dusik kartoku, vkvlvgabv nyi vdwv nyi nvgwngnv achiapik nvnga, okv suru nvnga, nyi uyuvram gvnv nga, okv svmik tabnv nga, okv digwng nvnga, ninyi gvlo aagv nyatoku, okv nw bunu mvnwngnga mvpu jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nyi nyipam twngtv nvgo ninyia vngming gvto, hv bunu Galili lokv, okv Dekapolis lokv, Jerusalem, Judia, Jordan Svko gv takdv gonv lokv. ");
INSERT INTO tgj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisu nyipam vdwa kaatokula okv moodw putungbv chaato, hoka nw dootungto, ");
INSERT INTO tgj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","okv ninyigv lvbwlaksu vdwv ninyia dooyumto, okv bunua tamsar raptoku: ");
INSERT INTO tgj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Yvvbunudw yalu lo heema do vla chindunv; bunu mvngpuv, Nyidomooku gv Karv ngv bunu gvngv! ");
INSERT INTO tgj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Yvvbunudw tinggw dunv, bunu mvngpuv; Pwknvyarnv bunua maare! ");
INSERT INTO tgj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Yvvbunudw nyanyak dunv, bunu mvngpuv; bunu Pwknvyarnv ogugo milv pvdw um naarwk sireku! ");
INSERT INTO tgj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Yvvbunudw Pwknvyarnv gv mvngnam a kaiyachokbv rinwng dunv bunu mvngpuv; Pwknvyarnv bunua mvngnam mvnwngnga nyumchi more! ");
INSERT INTO tgj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Yvvbunudw kvvbi ajina aya mvngpa dunv bunu mvngpuv; Pwknvyarnv bunua aya mvngpare! ");
INSERT INTO tgj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Haapok darwknv vdwv mvngpuv; bunu Pwknvyarnvnyi kaapare! ");
INSERT INTO tgj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Yvvbunudw sarsopoyo gv lvgabv ridunv, bunu mvngpuv; Pwknvyarnv bunua ninyigv umvuu bv minre! ");
INSERT INTO tgj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Yvvbunudw Pwknvyarnv gv mvngnama rigv rila mvdwkmvku nama paadunv hv bunu mvngpuv; Nyidomooku gv Karv ngv bunu gvngvku! ");
INSERT INTO tgj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nonuno mvngpuv vdwlo nyi vdwv nonua nyarjikaula okv mvdwkmvku la okv nonuno gvlo mvvnamrunam a mvvlwk rulwk la mvrekudw, ogulvgavbolo nonuno ngoogv nyi bv rinam lvkwngbv. ");
INSERT INTO tgj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mvngpula okv sakpu yalaka, nonugv lvgabv kairungnv rijo lakmu kaanam go nyidomooku aotv vvpv jipvnv. Nonua richo dakcho yanv krim gv nyijwk vdwaka mvdwkmvku nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nonuno nyia opi mvnwng gv lvgabv alu jvbv ridunv. Vbvritola aluv vdwlo tinama nyemu kubolo, um lvkodv tidukubv mvnyu kuma. Hv anyung kaamanvgobv ridu kunv, vkvlvgabv um ora dukunv okv nyi vdwv um chaajap chariap mvdukunv. ");
INSERT INTO tgj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nonuno nyiamooku mvnwng gv lvgabv loung jvbv ridunv. Moodw putunglo pamtv mvnama vvsi nyuma dunv. ");
INSERT INTO tgj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yvvka mvdurupuma vmv baanu gvrila bati akonv takmam madunv; vbvmabvya hv um ungka kolo vvdin gvrila naam gv nyi mvnwngnga loung ungka modunv. ");
INSERT INTO tgj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hvkv aingbv nonuno nyi vdwgv kaagialo loung bv unglaka, vkvlvgabv nyi vdwv nonugv alvbv rinama kaapa gvrila, nyidomooku lo doonv nonugv Abunyi hartv reku. ");
INSERT INTO tgj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ngam Moses gv Pvbv ngala nyijwk vdwgv tamsar nama rila ria dubv aapvnvgo vla mvngma bvka. Ngo bunu gvnga ria dubv aama, vbvritola bunugv tamsar nama jvjvbv rilin modubv aapvnv. ");
INSERT INTO tgj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mvngpa laka nyido ngvla kvdwv vdwlo nyemabv doobwng redw, Pvbv gv gaam akor chargoka rilaria nyumare—ogumvnwng gv nyeri loka nyemare. ");
INSERT INTO tgj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Vkvlvgabv so Pvbv gv gaam minam akin guka yvvdw tvvma gvrila ajin haka vbv rigv bolo hv Pwknvyarnv gv Karv lo miangyachok nvgobv rire. Kvvbi gaam gunvlo, yvvdw Pvbv gaama tvvgvrila ridula ajin haka vbv rimu bolo, hv Pwknvyarnv gv Karv lo kainvgobv rireku. ");
INSERT INTO tgj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngo nonua mindunv, nonu Pvbv tamsarnv vdwa okv Parisis vdwa alvyala Pwknvyarnv gv mvnglwkbv ribolo Pwknvyarnv gv Karv lo aalare. ");
INSERT INTO tgj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nonuno tvvdu krim nyi vdwa minto, ‘Gwngrw gwma bvka; yvvdw gwngrw gwrinv um hinching chingmure.’ ");
INSERT INTO tgj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Vbvritola vjak ngo nonua mindunv: yvvdw ninyigv achiboru a haachi dunv um hinching chingmure, yvvdw ninyigv achiborua ‘Noogv alvnamv ogu anyung kaama!’ Vla mindunv um kvba lo boolwkre, okv yvvdw ninyigv achiborua anyung kaamanv pvchanvno vla minv ngv vmv maatarbv guku uyumooku lo vngyare. ");
INSERT INTO tgj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Vkvlvgabv no vdwlo noogv Pwknvyarnvnyi amin jise nga yugwnglo jitv rinyi hoka no achiboru gv nam rinying nama mvngpa bolo, ");
INSERT INTO tgj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","noogv amina hoka yugwng hoka kayupila baapubv noogv achiboru gvlo vngla alvbv sarsopoyo dukubv rimisipikula aakur lakula noogv amina Pwknvyarnvnyi jilaka. ");
INSERT INTO tgj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nam akonv rinyingla kort lo kvba japdubv vnggv rinyi, no kort lo vngtv madvbv baapubv yalung nga japdarjapa minsu laka. No hoka aaku bolo hv nam jwngkadakanv gvlo jilwk reku, hv nam pulis lo laklwkre okv nam patwk tumlwk reku. ");
INSERT INTO tgj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngo nonua mindunv, no hoka noogv aje nga dornyama dvdvlo doobwng reku. ");
INSERT INTO tgj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nonuno tvvtoku, ‘Nyimv nyilo bv rimur minsu mabvkv’ vla minam a. ");
INSERT INTO tgj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Vbvritola vjak ngo nonua mindunv: yvv akonv mvvga anga doogvkargv daloka vla kaabiu dunv hv ninyigv haapok lo ninyia lvkobv rimur roku. ");
INSERT INTO tgj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Vkvlvgabv noogv nyikbik nyikkv naam kaamur moduboloka, um koolinla ora tvka! Hv alvyare noogv ayak aba gonv kaama namv, ayak mvnwngnga uyumooku bolo orlwk komam svnga. ");
INSERT INTO tgj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Noogv laak lakbik angv nam rimur gvdubolo, um palin gvrila ora tvka! Hv achialvbv alvyare noogv laak gunv kaama namv, ayak mvnwngnga uyumooku bolo vngmam svnga. ");
INSERT INTO tgj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Sika vbvka minto, ‘Yvv akonv atubogv nywng nga burbolo burdukunv vla mvnwngnga chimpa modubv siti go ninyia jirung laka.’ ");
INSERT INTO tgj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Vbvritola vjak ngo nonua mindunv: nyi akonv ninyigv nywng nga nyilo rinying koma gvrila kvvbi rimur lokv burdunv, okv nywng ngv kvvbi nyilu go naakubolo nyilu naachonam angv ninyia rimur modukunv; okv yvv ho nyimv anga nywngbv naaya dunv hvvka rimurlo aata dunv. ");
INSERT INTO tgj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nonuno krim gv svbv minam haka tvvnyato, ‘Noogv milv nama topu mabvka, vbvritola noogv ridubv vla Ahtu gvlo milv nama rito laka.’ ");
INSERT INTO tgj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Vbvritola ngo vjak nonua mindunv: vdwlo nonu milvnam go minredw, ogugo mintak nvyoka. Nyidomooku a mintak nvyoka, tv Pwknvyarnv gv dogingngv; ");
INSERT INTO tgj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","sichingmooku haka mintak nvyoka si ninyigv lvpa gv lvnu kongv, Jerusalem haka mintak mabvka so si kainv Dvbv gv pamtv ngv. ");
INSERT INTO tgj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Noogv dumpo haka mintakla milv yoka, ogulvgavbolo no dwmw sogo nyika yapung yakia dubv mvnyu mare. ");
INSERT INTO tgj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘Vkv vmalo maakv’ vse nga minda tvka-um lvvbo yadubv noogv minammv Alvmanv Angv gvlokv aadunv. ");
INSERT INTO tgj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Okv nonuno tvvpado svbv minam a, ‘Nyik kvlwk v nyik ngurv go, okv hijung kvlwk v hijung ngurv go.’ ");
INSERT INTO tgj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Vbvritola ngo vjak nonua mindunv: nonua rimur nvnga mvrwkrirwk siyoka. Nyi gonv nam moobik tanga svbiak bolo, ninyia noogv moochi tangaka svbiak dvmu laka. ");
INSERT INTO tgj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Okv nyi gonv noogv jvkoklaklwk ka dvrit laila kort lo nam kvba mintv bolo, ninyia noogv jvkoklaklwk haka jitam yalaka. ");
INSERT INTO tgj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Okv sipai akonv nam yikungyira nga lvtw akin go gvji labvkv vla minbolo, no lvtw anyigo gvji laka. ");
INSERT INTO tgj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Vdwlo nam nyi gunv ogugo kooridw, ninyia jirung laka; vdwlo nyi gonv nam ogugo narlabvkv vrinyi, um no ninyia narrwk silaka. ");
INSERT INTO tgj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nonuno tvvpa nyado svbv minam a, ‘Ajin a paklaka, nyiru nvnga kaanwng mabv rilaka.’ ");
INSERT INTO tgj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Vbvritola vjak ngo nonua mindunv: nam nyirunv vdwa paklaka okv nam mvdwkmvkunv vdwgv lvgabv kumlaka ");
INSERT INTO tgj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","vbv rigvrikula nonuno nyidomooku lo doonv nonugv Pwknvyarnv Abu gv umvuu bv ridu kubv. Nw tarwkbaknv nyi majeka okv tarwkbaknv nyi jeka ninyigv doonyi a bunu gvlo nyika jimudu. Okv alvbv rinv haka okv alvmabv rinv jeka doochar a sarlu jimudu. ");
INSERT INTO tgj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nonuno nonua paknv nga pakmwng bolo, ogulvgabv Pwknvyarnv nam aya nga jidubv? Lampu naaria nvngvka um risu gvrila! ");
INSERT INTO tgj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Okv nonu noogv ajin vdwa gaam raamwng bolo, um no alvnvgo ripv mvngsu duai? Mvngjwng manv vdwvka um rinyadu! ");
INSERT INTO tgj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","No rilakriku runglaka—noogv Abu nyido tolo doonv gv rilak rikunam aingbv! ");
INSERT INTO tgj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nonuno hima sulaka, nonugv dormo kumla ridungripa rinama nyi vdwa kaadubv vla nyi kaapam lo rima bvka, hvbv nyi kaapam lo riku bolo, no noogv Pwknvyarnv Abu gvlokv rijo paamare. ");
INSERT INTO tgj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Vkvlvgabv vdwlo no heemanv nyi ha ogugo jitv rinyi, um no nyi vdwa kaibv kaatam mabvka, kaakudubvrinv nyi vdwgv kumkunaam vdwlo okv lamtv sugulo ripia aingbv riyoka. Bunu vkvlvgabv rinyadu nyi vdwv kaagvrila bunuam hartv dubv vla. Ngo nonua jvjvbv mindunv, bunuam jise mvnwngnga jiropvkunv. ");
INSERT INTO tgj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Vbvritola vdwlo nonu dvmaheemanv nyi vdwa ogugo ridur tvinyi vbv rilaka noogv dooku lo doonv ajin haka um chimpa madubv. ");
INSERT INTO tgj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Vbvrikubolo hv no atugv risunam bv rire. Okv noogv Abu no ogugo ridudw um kaayanv nam rijo nga jire. ");
INSERT INTO tgj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Vdwlo nonu kumredw, kaadubv rinam aingbv rima bvka! Bunu kumkujoku naam lo okv lamtv sugulo daktola kumnwng nyadunv, nyi mvnwngnga kaakudubv vla. Ngo nonua jvjvbv mindunv bunu ogumvnwng nga paaro pvkunv. ");
INSERT INTO tgj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Vbvritola vdwlo no kumdubv mvngridw, noogv karchung arwng lo aalaka, agi a koktum laka, okv noogv kaapa manam Abunyi, kumlaka. Okv noogv Abu no ogugo risududw um kaayanv, nam rijo nga jire. ");
INSERT INTO tgj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Vdwlo no kumredw, arin-kamanv gaam mimabvka, Pwknvyarnvnyi chimanv vdwgv ripiabv rima bvka, bunu mvngdu bunugv Pwknvyarnv ngv tvvdunv ogulvgavbolo bunugv kumnam v asunam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bunugv aingbv rima bvka. Noogv Abu chinchodu, noogv dinchi nama ninyia no kootv madvbv. ");
INSERT INTO tgj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Vbvrikunamv so sibv nonuno kumlaka: ‘Nyidomooku lo doonv ngonugv Abu: Noogv darwknv aminv kairungnv; ");
INSERT INTO tgj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","noogv Karv bv rimu laka; nyidomooku hv oguaingbv ridudw vkv aingbv sichingmooku so noogv mvngnambv rimu laka. ");
INSERT INTO tgj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ngonugv dvsetvngse dinchi nama silu ngonua jilaka. ");
INSERT INTO tgj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ngonua rimur nvnga ngonu oguaingbv mvngnga pvdw, vkv aingbv ngonugv rimur a mvngnga jilabv. ");
INSERT INTO tgj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ngonua hila manv pokayarka go rikw moma bvka, vbvritola ngonua Alvmanv Angv loka ringya labvka.’ Ogulvgavbolo noogv mooku hv okv jwkrw hv, okv yunglit hv krim lokv doobwng rungnv.’ Amen. ");
INSERT INTO tgj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kvvbi gv nam rimur rinam a no mvngnga bolo, aotolo doonv noogv Abu ka nam mvngnga jire. ");
INSERT INTO tgj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Vbvritola no kvvbi ham mvngnga mabolo, aotolo doonv noogv Abu ka, noogv rimur rinam a mvngnga jimare. ");
INSERT INTO tgj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Okv vdwlo nonu yikrinyi, kaadubv rinam aingbv nyukmua mvngrubv kaatamla rimabvka. Bunu ayakka mvngru nvgobv mvsudo ogulvgavbolo nyi mvnwngngv bunu yikla doodu nvnyi vla kaare. Ngo nonua jvjvbv mindunv, bunua achialvbv jijinamha jiro pvkunv. ");
INSERT INTO tgj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Vdwlo nonu dvmabv vngrinyi, nonugv nyukmua monyupla okv nonugv dwmw a tai toksu laka, ");
INSERT INTO tgj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","vbvribolo kvvbiv nonua yikdunv vla chimare—nonugv kaapa manam Abu mwngchik chinre. Okv nonugv Abu nonu ogugo risududw um kaayanv nonua rijo nga jire. ");
INSERT INTO tgj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bununo atubongv nyiamooku so nyitv nga tvvpv mabvka, soka tapin pungla okv chwnglwng dokla ramla okv dvchonv mvkola chojiku so vvpvyoka. ");
INSERT INTO tgj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vmabvya, noogv nyitv nga nyidomooku lo tvvpv yalaka, tolo tapin pungla ramla mare, okv dvcho nvngv mvkola chola mare. ");
INSERT INTO tgj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Okv ogolo noogv nyitv nga tvvpv pvdw haapok hvka hoka doore. ");
INSERT INTO tgj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nyik si ayak gv lvgabv mvdurrupum gubv ridunv. Noogv nyik hv alvbolo noogv ayak mvnwngngv loung bv ridunv; ");
INSERT INTO tgj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","vbvritola noogv nyik hv alv mabolo noogv ayak hv kanv arwng lo doodunv. Vkvlvgabv noogv loung ngv kanv arwng lo dooku bolo hv achialvbv mvngru gubv ridu kunv! ");
INSERT INTO tgj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yvvka atu anyi gv nyirabv rinyu mare; nw akonyi pakri okv akonyi kaanwng mare; nw akonvgv minam a tvvre okv akonyi miakayare. No Pwknvyarnv nyila morko nga lvkobv anyia lvinbv riji-vngji nyulamare. ");
INSERT INTO tgj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Vkvlvgabv nonua ngo mindu, nonu hv turla singnam lvgabv dvkor tvngkor ham mvngdwk mabvka, okv ayak lokv vji vbee lvga ngaaka, ogulvgavbolo turnam hv dvnam mamsenga kaiyama nvri? Okv ayak si vji gvnam mamsenga arv doya madunvre? ");
INSERT INTO tgj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pvta vdwa kaatoka: Bunu aliamu pakma, aamtami nvla, nesunglo gvlwkma; vbvritola noogv Abu nyidomooku lo doonv ngv bunua kaaya tayadu! No pvta vdwa achialvbv arv doya nvngv mai? ");
INSERT INTO tgj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nonu gv lokv akonv vbv mvngrula achuk kaiyago svngnyu re? ");
INSERT INTO tgj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Okv ogubv vji lvgabv mvngdwk dunv? Mootum gv apung agar vdwgv singnam a kaatoka: bunu atu v vji vbee lvgabv mvsu risuma. ");
INSERT INTO tgj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Vbvritola ngo nonua minjidunv Dvbv Solomon ka ninyigv nyitv mvnwng lokvka so gv apung agar so gv kaapu aingbv vji gvnam go kaamato. ");
INSERT INTO tgj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","So si Pwknvyarnv yvvdw mootum gv nvmwng nga vji koomunv-nvmwng ngv silu doodu okv aarunyi dooku majinv, vmvlo ramyok jinamv. Nw jvjv rungbv nonua vji vbee koomu mabv kayure? Nonugv mvngjwng ngv miang dulaka! ");
INSERT INTO tgj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Vkvlvgabv mvngru rungrap kuyoka: ngoogv dvse ngv tvngse ngv okv vji hv ogolo aatv rinvdw vla?’ ");
INSERT INTO tgj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(So mvngru runam dvdv si Pwknvyarnvnyi chimanv nyi vdwgv lokia mvngnam v.) So mvnwng sum nonu dinchi dvnv vla nonugv Abu nyidomooku doonv ngv chindu. ");
INSERT INTO tgj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Vmabvya ogumvnwngnga sv-nga kaiyabv Pwknvyarnv gv Karv nga okv Pwknvyarnv nam ogugo mvngpvdw um dinchi yalaka, vbvribolo Nw nam so ogu kvvbi mvnwng haka jitare. ");
INSERT INTO tgj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Vkvlvgabv aaru gv lvgabv mvngdwk mabvka: aaru gv mvngdwk hv dwkgu namgo doosure. Alu gv lokulo adwkaku logv nama, hoka lwktam svgo kaama. ");
INSERT INTO tgj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kvvbia jwngkadaka mabvka, Pwknvyarnv ka nonua jwngkadaka madubv. ");
INSERT INTO tgj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nonu nyi kvvbia oguaingbv jwngkadaka dudw, vbvdvdvbv Pwknvyarnv ka nonua jwngkadakare, okv nonu nyi kvvbia oguaingbv kiika dudw vbvching Pwknvyarnv ka nonua kiikare. ");
INSERT INTO tgj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ogulvgavbolo nonu atugv nyik nywkrw chartvyanv nga kaama yabv, nonuno achiboru gv nyik nywkrw charching yanv yanga kaadunv? ");
INSERT INTO tgj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nonu oguaingbv nonugv nyik lo nyikrw chartvyanv go doomu gvrila, achiboru gv nyikgv nyikrw charching nvnga naalin laju vla minyu dubv? ");
INSERT INTO tgj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kaakudubvrinv no! Nonu atubogv nyikgv nyikrwa naalin chotoka, vbvribolo nonugv achiboru vdwgv nyikgv nyikrwa naalin dubv nonu kaapa nyulare. ");
INSERT INTO tgj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Darwknv ogu ogua iki vdwa jimabvka-hv bunu tapkur danv nam chvyare. Tasing laktv nga vrikbv orji mabvka—hv bunu lvpa lvkwnglo chaajap chariapre. ");
INSERT INTO tgj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kolaka, okv nonu koopare; malaka, okv nonu mapare; takdin laka, okv nonu gvbv agi a kokda pvjire. ");
INSERT INTO tgj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ogulvgavbolo mvnwngngv yvv koodunv koopare, okv yvvdw madunv mapare, okv yvvdw takdin dunv ninyigv lvgabv agi a kokda pvji dunv. ");
INSERT INTO tgj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yvvgv abu ngvla kuunyilo nga vtwng go koomu gvrila vlwng pwgo jinv ngv? ");
INSERT INTO tgj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Vmalo ninyia ngui nvgo koomu gvrila nonu tabw sogo jiya dubvre? ");
INSERT INTO tgj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No vdwgo alvmanv gubv rida jvka, no gv umvuu vdwa alvbv jisv nga chindu, vkv aingbv, nonugv nyido Abu ka, ninyia konv nga, alvbv jisv nga, achialvbv chindunv. ");
INSERT INTO tgj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“No kvvbi nyi a no gv lvgabv kainvgo riji svgo vla mvngnam aingbv, no kvvbi nyi gv lvgabvka riji laka: so si Moses gv Pvbv gvla okv nyijwk vdwgv tamsar namgv arin jvngv. ");
INSERT INTO tgj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Lamtv takching kolo vnglaka, ogulvgavbolo uyumooku bv vngnv lamtv ngv geetv koyodo okv ho vngku lamtv ngv vngyin dunv, okv ho nyi vdwv achialvbv vngyadu. ");
INSERT INTO tgj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Vbvritola turku lo vngnv lamtv ngv takching dunv okv ho gv vngku lamtv ngv vngru vngya dunv, okv hoka nyi vdwv miang go vngmwngdu. ");
INSERT INTO tgj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nonu mvvnvrunv nyijwk vdwa hima sulaka; bunu nonugv kaagialo agum mv svlar jvbv ridu, vbvritola bunugv arwng ngv mootum svcha jvbv ridunv. ");
INSERT INTO tgj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bunugv gwngnam rinam lokv nonu chinreku. Hvngnv vrintv lokv anggor svma dunv, tanyum singnv lokv koksitkokrik svvlin madunv. ");
INSERT INTO tgj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bakboknv singnv ngv alvnv apw asi svvdunv, vbvritola yaagampolonv singnv ngv alvmanv apw asi svvdu. ");
INSERT INTO tgj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bakboknv singnv ngv alvmanv apw asi svvnyu madunv, okv yaagampolonv singnv ngv alvnv apw asi svvnyu madunv. ");
INSERT INTO tgj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Okv singnv apw asi alvnv svvma nvnga patap gvrila vmvlo orlwk dunv. ");
INSERT INTO tgj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Vkvlvgabv, mvvlarula nyijwk vdwa nonu bunugv gwngnam rinam lokv chinreku. ");
INSERT INTO tgj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nga Ahtu, Ahtu vla goknv mvnwngngv Pwknvyarnv gv Karv lo aala mare, vbvritola yvvdw ngoogv nyido Abu gv mvngkubv ridu vngdunv, hv mvngchik aanyure. ");
INSERT INTO tgj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Vdwlo jwngkadaka aluv lori kudw, nyi achialvgo nga minreku, ‘Ahtu, Ahtu! No gv amin lokv ngonu Pwknvyarnv gv doin a japgo pvnv, no gv amin lokv ngonu uyuvram vdwa chara pvnv, okv achialvgo lamrwpanam vkv rila kaatam pvnv! ");
INSERT INTO tgj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Vbvrikunamv ngo bunua minreku, ‘Ngo vdwloka nonua chimapvnv. Alvmanv nyi vdwv nonu, ngo gvlokv adu roto!’ ");
INSERT INTO tgj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Vkvlvgabv, yvvdw ngoogv gamchar vdwa, tvgvrila um ridu vngdunv, hv mvnglak rilaknv nyi go, ninyigv naam a vlwng aolo mvlwknv aingbv ridunv. ");
INSERT INTO tgj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nyido doochar hv sarluto, svko isi hv tvvluto, okv ritv doori hv rila ho naam ha tvging rigingto. Vbvritola ho naam anga mvyakmvchak nyumato, ogulvgavbolo hv vlwng aolo mvlwknam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Vbvritola yvvdw ngoogv gamchar vdwa tvgvrila okv um rima vngma dunv, hv pvchanv nyi go ninyigv naam a chukrilo mvlwknv aingbv ridunv. ");
INSERT INTO tgj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nyido doochar hv sarluto, svko isi hv tvvluto, ritv doori rila ho naam a tvging rigingto, okv naam angv taba toku. Okv ho hv achialvbv mvngru runam gubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Vdwlo Jisu gv vbv minya robv, nyipam hv ninyigv tamsar sarku nama tvvla lamrwpanya toku. ");
INSERT INTO tgj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nw Pvbv tamsarnv vdwgv aingbv rima; vmabvya nw kaiyachokbv jwkrw doonv gubvrila tamsar yatoku. ");
INSERT INTO tgj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Vdwlo Jisu moodw lokv lvkwngbv ito kudw, nyipam tvngtv nvgo ninyia vngming gvto. ");
INSERT INTO tgj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Vbvrikunamv taik rila silvmanv nyi ako ninyi gvlo aatoku, ninyigv kaagia lo lvbwng ngv kumpvla, okv ninyia minto, “Tamsarnv, no mvnggelo nga no darwk dubv mvnyure. ");
INSERT INTO tgj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisu nw gv lak v laklin daanv okv ninyia mvsit toku. Nw mirwkto, “Ngo mvngdunv,” “Darwk tokuka!” Vto, vbv minam gula vjakgobv nyi angv gv lvvma ngv poya toku. ");
INSERT INTO tgj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Vbvrikunamv, Jisu ninyia mintoku, “Tvvriato! Yvvnyika minpa mabvka, vbvritola nyibu gvlo vngdavngra yika okv ninyia no jwngkadaka kolaka; vbvrila no poorung pvku vla nyi mvnwngnga chimu laka, Moses gv ortojinam lokv erinpeelwk svnga rinlaka.” ");
INSERT INTO tgj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Vdwlo Jisu Kaparnaum lo aalwk tokudw, Roman nyigam gunv ninyia kaarwksuto okv ridur labv vla kooto: ");
INSERT INTO tgj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tamsarnv, ngoogv pakbu hv achialvbv lvvmala, naam gadw lo binyu tapnyu mabv, karpvkv.” ");
INSERT INTO tgj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisu minto, “Ngo vngla ninyia alvdubv mvreku.” ");
INSERT INTO tgj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Oo, Tamsarnv, ma,” vla nyigam angv mirwk toku. “Ngo nam ngoogv naam lo aaji labv vla mvngma. Vjak so orto jimwng tvka, okv ngoogv pakbu ngv poyariku. ");
INSERT INTO tgj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngo ka kainv nyigam vdwgv arwng lo doonv nyi akonv, okv ngoogv arwng loka sipai hv doodunv. Ngo so doonv anga ‘vngto’ vla orto jibolo hv vngdunv; okv ngo olo doonv anga ‘so aato’ vla orto jibolo, hv aadunv; okv ngo ngoogv pakbu nga, ‘Sum rito’ vla orto jibolo okv hv um ridunv.” ");
INSERT INTO tgj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Vdwlo Jisu hum tvvtokudw, nw lamrwpatoku okv ninyia vngming gvnv nyi vdwa minto, “Ngo nonua minpa dunv, Israel mooku lo ngo svbv mvngjwng nvgo vdwloka kaapama. ");
INSERT INTO tgj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngo nonua jvjvbv mindunv nyi achialvgo doonyi chagia okv doonyi aagia lokv aakumla Abrahamnyi, Isaaknyi okv Jakobnyi lvkobv Nyidomooku gv Karv dvpam dvmin lo dooming gvvre. ");
INSERT INTO tgj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Vbvritola yvvdw Karv lo doorung jinv nga kanv jiriak kolo orlwkreku, hoka bunu achiapik v hila kumabv hijung nga hitwk kwrwk sila dooreku.” ");
INSERT INTO tgj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Vbvrikunamv Jisu nyigam anga mintoku, “Naam bv vngyi kuka, no ogugo mvngjwng pvdw hv nam riji reku.” Okv nyigam gv pakbu angv ho pooya datoku. ");
INSERT INTO tgj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisu Pitar gv naam lo vngtoku, okv hoka Pitar gv ayuv ramla gadw lo doodubv nw kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisu hvkvgv laak ha mvsetto; ramnamv ninyia vngyu toku, okv hv gudung laku, Jisunyi dvnamtvngnam jirap toku. ");
INSERT INTO tgj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Vdwlo arium tokudw, nyi vdwv uyuvram naanam nyi vkv achialvgo Jisu gvlo aagv jito. Jisu Gamchar lokv uyuvram vdwa chara toku, okv lvvmanv mvnwngnga mvpu jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ninyigv svbvrinam si nyijwk Aijaya gv “Nw atubongv ngonugv achiapit mvnwngnga naasuto okv ngonugv lvvma mvnwngnga gvaa jipvku,” vla minam a jvjv modukubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Vdwlo Jisu nyipam v ninyia dakyum pvbo vla chinto kudw. Nw ninyigv lvbwlaksu vdwa svparsvlv gv takdv gonvlo vngyi laka vla minto. ");
INSERT INTO tgj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pvbv tamsarnv nyi ako ninyi gvlo aato. Hv minto, “Tamsarnv, no ogolo vngjeka ngo vngming gvdubv vla doodu kunv.” ");
INSERT INTO tgj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisu ninyia mirwkto, “Svlwng ngv arung doodunv, okv pvta vdwv taasup doodunv, vbvritola Nyia Kuunyilo ngv ogoloka doonudaknu kogoka kaama.” ");
INSERT INTO tgj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Lvbwlaksu kvvbinyi gunv minto, “Tamsarnv, ngam vngla ngoogv abunyi svma riicho molabvka.” ");
INSERT INTO tgj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisu mirwkto, “Ngam vngming gvlaka, okv bunugv svma nga bunua riisu motoka.” ");
INSERT INTO tgj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisu svpw gulo chaala dooto, okv ninyigv lvbwlaksu vdwv ninyia vngming gvto. ");
INSERT INTO tgj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Dvminmabv kairungnv dooridoogum ako rilwkla svparsvlv nga rigingto, okv svpw ngv maatarbv isi holwk tvvto. Vbvritola Jisu yuptoku. ");
INSERT INTO tgj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lvbwlaksu vdwv ninyi gvlo aala ninyia mvuto. Bunu minto, “Ahtu, ngonu sida jiku nvlaka, ngonua ringla bvkv.” ");
INSERT INTO tgj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisu mirwkto, “Nonuno ogulvgabv busu nyadunv, nonugv mvngjwng ngv achok gomwng hai!” Vbvrikunamv nw gudungdanv dooridogum okv svkiok ka choibvkv vla mintorto, okv ho jematai bv ritoku. ");
INSERT INTO tgj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nyichar mvnwngngv tvnga-rvnga nyatoku. “Ogu aingnv nyi gubvri si, doori vla svkiok kv ninyigv minam a tvvdu!” vla bunu mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Vdwlo Jisu svparsvlv gv takdv gonvgv Gadara mooku lo chaalin tokudw, ninyia hoka nyibung lo doonv nyi anyigo vngrwk sito. So nyi anyi lo uyuvrammv dooto okv ho lamtv hoka achialvbv busu nyala yvvka vngnv kaamato. ");
INSERT INTO tgj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Vjakgobv bunu svgokto, “Pwknvyarnv gv Kuunyilo, no ngonu gvlo ogugo mvngpv? No ngonua dw v aatv madvbv mvrit dubvre?” ");
INSERT INTO tgj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aduyoma lo vrik riktwng go hoka dvla rikar nyato. ");
INSERT INTO tgj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Vkvlvgabv uyuvram vdwv Jisunyi koodwkkrwkla kooto, “No ngonua charlin dubv mvngdu nvlo, ngonua vlo gv vrik riktwng alo vngmulabv.” ");
INSERT INTO tgj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisu bunua minto, “Vnglaak” vkvlvgabv bunu kiyu laku okv riktwnglo kilwk nyatoku. Riktwng mvnwngngv svparsvlv gv raktam lo chapchar minsula okv isi chaplwkla sinya toku. ");
INSERT INTO tgj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Riktwng nga kaayanv nyi vdwv kilaku, okv banggulo vngtoku, hoka bunu ogugo ripvdw hum mvnwngnga okv uyuvram doonv nyi anyi aka ogugo ripv kudw hum minji nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Vkvlvgabv banggu gv nyi mvnwngngv Jisunyi kaarwk sudubv vnglin nyatoku; okv vdwlo bunu ninyia kaapa tokudw, bunu ninyia bunugv mooku lokv vngro jilabv vla kodwkkrwkla koola minto. ");
INSERT INTO tgj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisu svpw lo aalwk toku okv svparsvlv a rapkur la ninyigv banggubv vngtoku, ");
INSERT INTO tgj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","hoka nyi megonv digwngnv nyi ako gadw lo karmu tvla nw gvlo joolwk jito. Jisu bunugv kaibv mvngjwng nama kaagv rikula digwngnv nyi anga minto, “Ngo gv kuunyilo nga, ator bvkv! Noogv rimur vdwa mvngnga jipvkunv.” ");
INSERT INTO tgj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Vbvrikunamv Pvbv tamsarnv megonv bunu minsunyato, “So nyi si Pwknvyarnvnyi nyarjitaridu!” ");
INSERT INTO tgj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisu chinto bunugv mvngnam a, vkvlvgabv nw minto, “Nonuno ogulvgabv svkvnv alvmanv go mvngdunv?” ");
INSERT INTO tgj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Noogv rimur ham mvngnga jipvkunv vla minam mvre, vmalo gudungto okv vnglaku vla minam mvre, ogolo angv minpu yapv? ");
INSERT INTO tgj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nyia Kuunyilo ngv nyiamooku so rimur a mvngnga nvnv doodunv vla ngo nonua kaachin modukubv ritam reku.” Vkvlvgabv nw digwngnv nyi anga minto, “Gudungto, noogv gadw nga naarap tvka okv naambv vngnyikuka!” ");
INSERT INTO tgj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nyi angv gudung toku okv naambv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Vdwlo nyi vdwv um kaapa tokudw, bunu busu nyatoku, okv Pwknvyarnvnyi hartv nyato hvkvnv jwkrw aya nga nyi vdwlo jilwk jinam lvkwnglo. ");
INSERT INTO tgj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisu ho mooku a vngyu toku, okv ninyigv vngdungrilo, nw lampu naaya nvgo kaapato, aminv Metiu, nw ninyigv opislo dooto. Jisu ninyia minto, “Nga vngming gvlaka.” Metiu gudungdanv ninyia vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Vdwlo Jisu Metiu gv naam lo dvnam dvla doorilo, lampu naayanv okv toa kunam nyi achialvgo Jisu gvla ninyigv lvbwlaksu vdwgv dvku tvbul lo aapwng mingvla dvmin gvto. ");
INSERT INTO tgj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisis megonv hum kaapato okv ninyigv lvbwlaksu vdwa tvvkato, “Ogulvgabv nonugv Tamsarbo vkvnv nyi vdwa lvkobv dvbam tvngbam dunvdw?” ");
INSERT INTO tgj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisu tvvpala bunua mirwksito, “Nyi chvrv nvngv daktor dinchi madunv, vbvritola yvvdw lvvma dvnv hv bunu dinchi dunv. ");
INSERT INTO tgj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Darwknv Kitaplo ogu vla minpvdw vngla kaabwk tvka: ‘ngoogv mvngnam v aya kaapa minsunam si, svnwngsvmin erin-peelwknam hum yama.’ Ngo mvngdvnam nyi vdwa gokbv aama, vbvritola toa kunam nyi vdwam yabv.” ");
INSERT INTO tgj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Vbvrikunamv Jon baptist gv lvbwlaksu vdwv Jisu gvlo aala tvvkato, “Ogulvgabv ngonu la Parisis vdwv yiknama ridarira gvre, vbvritola noogv lvbwlaksu vdwv lvkoka yiknam go rikw madunv?” ");
INSERT INTO tgj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisu mirwksito, “Nonuno vbv dvmin dunvri nyidalo nyi vdwv mvngrula paapumgvjinvgv lvkobv doodubv? Vbvrirung mare! Vbvritola alu go looreku paapum gvji bonga bunugv loka naaro dukubv, okv vbvrikubolo bunu yiknam a rirap rekunv. ");
INSERT INTO tgj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Yvvka jvtvlaklwk ainapin lo anwnvgo hamtak lwknv kaama dunv, ogulvgavbolo anw hamtak lwknam angv takgv la okv jvtvlaklwk ka abuyayabv ungko nga kotv moyare. ");
INSERT INTO tgj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Okv yvvka anggor ala anw nga anggor ala aku gvnvnv pumchup lo pwlwknv kaama, pwlwk kubolo pumchup v boktakre, okv anggor ala ngv sarlinre, okv pumchup v alvkumare. Vmabvya anggor ala ngvla pumchup v anyiv alvdubv, anggor ala anw nga pumchup anw lo pwlwk yadunv.” ");
INSERT INTO tgj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Vdwlo Jisu vbv mindung rilo, rigvdogvnv Jius nyi ako ninyi gvlo aala, ninyigv kaagialo lvbwng kumpvla, okv minto, “Ngoogv kuunyijar v vjak dadi siyibv; vbvritola no aala noogv laak v lakpv jibolo nw turri kunvpv.” ");
INSERT INTO tgj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Vkvlvgabv Jisu gudungla okv ninyia vngming gvtoku, okv ninyigv lvbwlaksu vdwv ninyia lvkobv vngming gvtato. ");
INSERT INTO tgj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mvvga ako nyingring gola nyingnyi go oyi sarla silvkumanv, Jisu gv adar lo aatoku okv ninyigv vji a mvsit to. ");
INSERT INTO tgj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Hv atubongv minsuto, “Ngo ninyigv vji a mvsit mwngbolo, ngo poyariku.” ");
INSERT INTO tgj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisu kaitkarla ninyia kaapato, okv minto, “Ngoogv kuunyijar a mvngrw laka! Noogv mvngjwng ngv nam poya mopvku. ");
INSERT INTO tgj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Vbvrikunamv Jisu ho rigvdogvnv nyi agv naam lo vngtoku. Vdwlo nw siku gv siinyimar gv adua okv nyi vdwgv adupvbin a kaiyayabv tvvpa tokudw, ");
INSERT INTO tgj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nw minto, “Nyichar mvnwngngv, agumbv linroto! Vmi nyijar angv simakv—nw yupdung mwngdunv!” Vbvrikunamv bunu mvnwngngv ninyia nyarji nyato. ");
INSERT INTO tgj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Vbvritola baapubv nyi vdwv agum linro sopikda, Jisu nyijar angv gv karchung lo aatoku okv ninyigv laakka gakbwngto, okv nyijar angv gudung toku. ");
INSERT INTO tgj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Svbvrinam gv yunying ngv ho mooku mvnwng hoka dupwng toku. ");
INSERT INTO tgj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisu ho mooku a vngyu toku, okv nw gv vngdungrilo, nyikchingnv nyi anyigo ninyia vngming gvrapto. Bunu gokto, “Dabid gv Kuunyilo, ngonua aya mvngpa labv!” ");
INSERT INTO tgj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Vdwlo Jisu naam agi arwngbv aatokudw, nyikchingnv nyi anyi vka aaming gvto okv bunua tvvkato, “Ngo nonyia mvpu nyure vla, nonyiv mvngjwng dunvri?” “Tamsarbo, vkv!” vla bunyiv mirwkto. ");
INSERT INTO tgj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Vbvrikunamv Jisu bunugv nyik a mvsit toku okv minto, “Nonyi gv mvngjwngnam lokv vbvrirung jilaka!”— ");
INSERT INTO tgj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","okv bunyi gv nyik v nyiktarla kaapa toku. Jisu bunyia kaagapla minto, “Sum yvvnyika minji mabvka!” ");
INSERT INTO tgj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Vbvritola bunyiv vnglaku okv Jisu gv lvkwnglo yunying nga, ho mooku mvnwnglo dusik motoku. ");
INSERT INTO tgj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nyi vdwgv vngyu rikulo, nyi mego uyuvram naanam nyi ako gaam milin nyuma nvgo Jisu gvlo aagv jito. ");
INSERT INTO tgj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Vbvritola uyuvram a chara ronam gula, nyi angv gaam rarap toku, okv nyichar mvnwngngv tvngarvnga nyatoku. Bunu hartvla minto, “Ngonu Israel mooku so vdwloka svkvnvgo kaakw mapvnv!” ");
INSERT INTO tgj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Vbvritola Parisis vdwv minto, “So si uyuvram vdwa rigvdogvnv hvkvgv jwkrw a ninyia jipv nvgo, uyuvram vdwa chara dubv.” ");
INSERT INTO tgj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisu banggu vdwlo okv nampum vdwlo vnggo karto. Nw Jius kumkunaamlo tamsarto, Tvvpunv Yunying nga Karv gv lvkwng nga japgo jito, okv nyi vdwa nvgwngnv achiayakla, lvvma nvnga mvpujito. ");
INSERT INTO tgj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nw nyipam vdwa kaadung dula ninyigv haapok v bunua aya mvngpato. Ogulvgavbolo bunua ridur nvgo kaamabv mvngru nyato, svlar lartwng go kaayanv kaamanv jvbv. ");
INSERT INTO tgj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Vkvlvgabv nw ninyigv lvbwlaksu vdwa minto, “Aam nvvse ngv awgo doodu, vbvritola nvvkum yaji nvngv miang go. ");
INSERT INTO tgj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rongo atua kumto ho nw aam nvvjinv vngmu gvrila ninyigv aam a nvvkum modukubv.” ");
INSERT INTO tgj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisu ninyigv lvbwlaksu vring gola anyia gokkumto okv bunua alvmanv dow a charanvnv okv lvvma nvgwngnv okv achiayak nvgwng nvnga mvpuripu dubv jwkrw a jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","So si Apostol vring gola anyi gv aminv: mintubv Saimon (Pitar vnam) okv ninyigv boru Andriu; Jems okv ninyigv boru Jon, bunyi gv abu v Jibedi; ");
INSERT INTO tgj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip okv Bartolomiu; Tomas okv Metiu lampu naakumyanv; Jems Alpius gv kuunyilo, okv Tadius; ");
INSERT INTO tgj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon ringrianv, okv Judas Iskariot, Jisunyi kupnv. ");
INSERT INTO tgj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","So nyi vring gola anyia Jisu svbv mingvrila vnglin moto: Nonuno Jentail mooku lo vmalo Samaritan banggu vdwlo vngma bvka. ");
INSERT INTO tgj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Vmabvya nonuno Israel gv svlar nyekunv nyi vdwgvlo vnglaka. ");
INSERT INTO tgj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Vngnyika okv japgo laka, ‘Nyidomooku gv Karv ngv nvchi duku!’ ");
INSERT INTO tgj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lvvma nvnga mvpu laka, sinv nga turkur molaka, yvvdw taik ridunv mvpu jilaka, okv uyuvram vdwa chara laka. Nonuno arv jimabv naapvnv, vkvlvgabv jinyubv jilaka. ");
INSERT INTO tgj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nonugv jekap lo ain, raaji, okv morko go gvma bvka; ");
INSERT INTO tgj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","moing vngkulo giagonv kochak vmalo jvkoklaklwk bornyi vmalo lvsup anyi vmalo bangngi guka gvyoka. Rinv anga ogugo dinchi pvdw jirung dunv. ");
INSERT INTO tgj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Vdwlo nonu Banggu lo vmalo napumlo aalwk redw, aagv rila nonua alvbv aamu jinv go kaaying laka, okv ninyia lvkobv dooming gvlaka nonugv ho mooku lokv vnglinma dvdvlo. ");
INSERT INTO tgj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Vdwlo nonuno naam gulo aaridw, ‘mvngpuv nonua lvkobv doi laka’ vla minlaka.” ");
INSERT INTO tgj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ho gv naam nyi v nonua alvbv naarwk siredw, nonugv kumrwklvtak nga ho doolwk molaka; vbvritola bunu nonua alvbv naarwk sima bolo, vbvribolo nonugv kumrwklvtak nga naakur lakuka. ");
INSERT INTO tgj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Okv vdwlo banggu gunv vmalo nampum gunv nonua alvbv naarwk sima boloka vmalo tvria maboloka vbvrikunamv ho mooku a kayulaka okv lvchu gv pvmar haka moolu laka. ");
INSERT INTO tgj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngo nonua jvjv nga minjidunv jwngkadaka alu lo Pwknvyarnv ho banggu gv nyi vdwa svnga Sodom okv Gomora banggu gv nyi vdwa aya yari nvpv! ");
INSERT INTO tgj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tvvriato! Ngo nonua vnglin mogv rinvla svlar a svcha chatwng lo vngmunam aingbv. Nonuno tabw gv apiabv hima sunvbv rilaka okv taakw jvbv angam nvgobv rilaka. ");
INSERT INTO tgj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Himasulaka nonua naatungla tumjinv okv kvbanaam lo boolwk jinv doodu nvla, okv bunu nonua Jius kumkunaamlo dvngri nvla. ");
INSERT INTO tgj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ngoogv lvgabv nonua dvbv vdwgv okv rigvdogvnv vdwgv kaagialo mvrit rinvla okv Jentail vdwa okv bunua Alvnv Yunying nga minjinam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Vdwlo bunu nonua mvrit kolo aagv rikudw, nonu ogu gonyi minse ngvdw vmalo oguaingbv mindu bvdw vla mvngru mabvka. Vdwlo mindubv riri kudw nonua minse nga jiri kunv. ");
INSERT INTO tgj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nonugv gamchar dvdv ngv nonu gvngvma, hv nonugv Abu gv Dow v nonu gvlokv japdunv. ");
INSERT INTO tgj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nyi vdwv atugv achiboru vdwa mvki modubv laklwk reku, okv abu vdwv vbvdvdvbv bunugv umvuu vdwa rire; umvuu vdwv anvabua rinying reku okv bunua mvki moreku. ");
INSERT INTO tgj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ngoogv lvgabv nyichar mvnwngngv nonua kaanwng mareku. Vbvritola yvvdw ataranya lobv gakbwngla rilin doolin rinv hv turnama paariku. ");
INSERT INTO tgj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Vdwlo bunu nonua banggu ako lo mvdwkmvku rikudw, banggu ako gunvlo joklwk laka. Ngo nonua jvjvbv mindunv nonu Nyia Kuunyilo gv aatv madvbv Israel gv banggu mvnwnglo rise gwngse nga rinya nyumare. ");
INSERT INTO tgj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Purinv vmiv Tamsar nvnga kaiyama dunv; nyira ngv ninyigv atua kaiyama dunv. ");
INSERT INTO tgj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vkvlvgabv purinv vmiv ninyigv tamsarbo aingbv rirung dubv mvngdum laka, okv nyira ngvka vbvdvdv bv ninyigv atu aingbv. Vpin ara gv nyiloyachok ka Biljebul vla minbolo, vpin gv nyi vdwa hum tvrukaya yadubv bunua minre! ");
INSERT INTO tgj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Vkvlvgabv nyi vdwa busu mabvka, ogugonyi vjak takmamla vvpv pvdw mvkok reku, okv arwnglo vvsinam ma chimpa morikunv. ");
INSERT INTO tgj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngo kanv lo nonua ogugo minpa pvdw nonuno um pua tota lo ridv laka, okv nonuno ogugo tvsi pvdw nonu hum naam mwnglo ao lokv gokpa jilaka. ");
INSERT INTO tgj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ayakka mvki jinv nga busu mabvka, vbvritola yaji yalu ha mvki nyumare; vmabvya ayak hala yaji yalu ha uyumooku lo mvyak jinv Pwknvyarnvnyi busu yalaka. ");
INSERT INTO tgj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Morko abar mvngchik lokv nonu pvdwng nvvnyi go rvvla madunvre vbvritola nonugv Abu mvngma rinyi pvdwng nvgoka kolv lo hoolu madunv. ");
INSERT INTO tgj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nonu gvbv dumpo dwmw haka kiro pvkunv. ");
INSERT INTO tgj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Vkvlvgabv busu mabvka; Nonu pvdwng mvnwng haka arv doya nvngv! ");
INSERT INTO tgj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yvvdw nyi vdwgv tvvpam kaapam lo rvbwngvrwngbv Jisu ngo gv-ngv vla minre kudw, ngooka ninyia nyido mooku tolo doonv ngo Abu gv kaagia lo vbvrire. ");
INSERT INTO tgj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Vbvritola yvvdw nga nyi vdwgv tvvpam kaapam lo mia siredw, ngooka ninyia nyido tolo doonv ngo Abu gv kaagialo mia siitv ngurure. ");
INSERT INTO tgj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nyia mooku so nga himpukain a aagvla aapvnv vla mvngma bvka. Ma, ngo sarsopoyo nga aagvdubv aama, vbvritola riokse nga aagv yapvnv. ");
INSERT INTO tgj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ngo aapvnv kuunyilo vdwv bunugv abu vdwa rinying modubv, kuunyijar vdwv bunugv anv vdwa rinying modubv, nyang vdwv bunugv ayu vdwa rinying modubv; ");
INSERT INTO tgj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nyi gunv gv kairungbv nyiru minsu namv ninyigv ogu naam gv nyi gubv rire. ");
INSERT INTO tgj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yvvdw nga lvyabv ninyigv anv okv abua pakdunv, hv ngoogv lvbwlaksu vla mindubv riyoma; yvvdw nga lvyabv ninyigv kuunyilo okv kuunyimv ha pakdunv, hv ngoogv lvbwlaksu vla mindubv riyoma. ");
INSERT INTO tgj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yvvdw ninyigv daapo nga joorapla ngoogv kochinglo vngming gvma dunv hv ngoogv lvbwlaksu vla mindubv riyoma. ");
INSERT INTO tgj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yvvdw ninyigv singdung nga kai modubv mvngdunv, hv ngooyare, okv yvvdw ninyigv singdung nga ngoogv lvgabv ngoomu dunv hv singya re. ");
INSERT INTO tgj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yvvdw nonua alvbv naarwk sidunv, hv nga alvbv naarwksinam mv; okv yvvdw nga alvbv naarwk sidudw, hv nga vngmunv nw nyika alvbv naarwk sita dunv. ");
INSERT INTO tgj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yvvdw Pwknvyarnv gv gindungpingko nga naarwk sidunv, ogulvgavbolo hv Pwknvyarnv gv gindungpingko ngv, hv nw gvlo rijo nga paare. Okv yvvdw alvnv nyi ha alvbv naarwk sidunv, ogulvgavbolo hv alvnv nyi hv, hv nw gvlo rijo nga paare. ");
INSERT INTO tgj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nonu jvjvbv mvngrung laka yvvdw nga reming gvnv miangyachok nvgonyi isi koobu go jidunv ogulvgavbolo hv nga reming gvnv ngv, hv jvjv rungbv rijo nga paarungre.” ");
INSERT INTO tgj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Vdwlo Jisu ninyigv lvbwlaksu vring gola anyi vdwa soogv minam vdwa minro koching so, nw ho mooku ha vngyula nvchilo doonv banggu vdwlo tamsar okv japgo dubv vla vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Vdwlo Jon baptist patwklo doopv tvvla Kristo gv rinamvngnama tvvpa pvkudw, nw ninyigv lvbwlaksu mego Jisu gvlo vngmuto. ");
INSERT INTO tgj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bunu minto, “Ngonu ham minpalabv, no Jon gv ako aarinvkv vla minam angvri, vmalo ngonu kvbi ako gunyi kariadu yadu bri?” ");
INSERT INTO tgj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisu mirwkto, “Vngkur lakula Jonnyi minji tvka nonu ogugo tvvdu okv kaadu: ");
INSERT INTO tgj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","nyikching nvngv nyikpo duku, lvpik nvngv vngkar nyuduku, yvvbunudw apin hv yala doonv vdw hv darwk nyapvku, rungji nvngv tvvpa duku, sinv vdwa turkur mopvku, okv Alvnv Yunying nga heema opin vdwa japji pvku. ");
INSERT INTO tgj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Vdwgo mvngpu ngv yvvdw nga tintinroru bv mvngma dunv!” ");
INSERT INTO tgj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Vdwlo Jon gv lvbwlaksu vdwgv vngyurilo, Jisu nyipam ha ninyigv lvga nga japji toku: “Vdwlo nonu Jon gvlo chukrimooku lo vnglin rinyi, nonu ogugo kaapare vla dvmin dunv? Nvmwng anv ngv doorilo yapchar dunvri? ");
INSERT INTO tgj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nonu ogugo kaadubv vnglin pvnv? Nyi ako vji kaapubv gvnv gore? Vkvnv vji gvnv nyi vdwv Dvbv gv karvlo doodunv! ");
INSERT INTO tgj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nga minpalabv, nonuno ogu kaadubv vla agum vnglin pvnv? Nyijwk ako-nyiri? Hv rung, vbvritola nonuno nyijwk ka kaiyanv go kaagv nyibv. ");
INSERT INTO tgj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon Darwknv Kitaplo minam angv: ‘Pwknvyarnv minto, ngo ngoogv gindungpingko nga no gv lvgabv lamtv nga mvko modubv nam vngcho yamure.’ ");
INSERT INTO tgj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngo nonua jvjvbv mindunv Jon Baptist kvvlo gv richo dakchonv nyi dvdv nga kaiyanv. Vbvritola yvvdw Nyidomooku gv Karv lo miangyachok nvngv hv Jonnyi kaiyanv. ");
INSERT INTO tgj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon gv doin japri lokv rila vjak lobv Nyidomooku gv Karv ngv achialv alvmanv hirukaya hindu, okv alvmanv nyi vdwv hum mvtum dubv rikwto. ");
INSERT INTO tgj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moses gv Pvbv ngvla nyijwk mvnwngngv Jon gvlobv Pwknvyarnv gv Karv lvga nga minyato; ");
INSERT INTO tgj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","okv nonuno bunu vdwgv doin ha tvjing dunvlo, Jon Elija kv, ninyigv aanama mincho jipvnv. ");
INSERT INTO tgj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Vbvrikunamv tvvtoka, nonuno nyarung gvdu nvlo! ");
INSERT INTO tgj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Vjak ngo ogu gonyi mintakla mindubv silugv nyi vdw sum? Bunu piokpamdorpamlo vmi metwng go doonv aingdo. Vmi apum gunv ngv apum gunv nga gokdu, ");
INSERT INTO tgj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ngonu nonugv lvgabv nyida gungrigungga mvdunv, vbvritola nonuno naas rima! Ngonu nonu gvbv siinyimar rijito vbvritola nonuno kapma!’ ");
INSERT INTO tgj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Vdwlo Jon aatokudw, nw yigto okv opo tvngmato, okv nyichar mvnwngngv, ‘Nw gvlo uyuvram hv doolwkdu!’ vla minto. ");
INSERT INTO tgj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Vdwlo Nyia Kuunyilo ngv aato kudw, nw dvtoku okv tvngtoku, nyichar mvnwngngv, ‘So nyi sum kaatoka! Nw dvki tvngki rianv go, lampu nayanv vdwgv okv kvvbi nyi toa kunam vdwgv ajin go!’ Pwknvyarnv gv mvngkimvnglak v ninyigv rinamvngnam lokv jvjv gubv kaadar modu.” ");
INSERT INTO tgj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisu ogolo ninyigv lamrwpadubv mvnam rinam ma kaiyabv kaatam pvkudw ho banggu gv nyi vdwv bunugv rimur lokv mvngdin manya toku, vkvlvgabv nw ho banggu vdwa haachito. ");
INSERT INTO tgj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Vdwnvgo mvngru runam gubv rire ‘Chorajin’ no! Okv vdwgo mvngru runam gubv ritare, ‘Betsaida’ no! Nonu gvlo lamrwpanam kaatam nama Taire okv Sidon lo rinv guilo krim ho gv nyi vdwv bunu krim rimur lokv mvngdin dukunv vla kaatam nvbv tagiam vji ha kopv kunvpv, okv bunu atu hv mvchu tayu nga taabum sipv kunvpv! ");
INSERT INTO tgj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngo nonua jvjvbv minjidunv jwngka daka alu lo Pwknvyarnv nonua sv-nga Taire okv Sidon gv nyi vdwa kaiyago aya kaatam yariku! ");
INSERT INTO tgj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Okv Kaparnaum no gvbv, no atubongv nyidomooku tolo naacha sidubv mvngpv ai? Nam uyumooku bolo orlu tainv! Nonu gvlo lamrwpanam kaatamnam vdwa Sodom lo kaatam nvgo yilo, hv vjaklodvbv doobwng pvnvpv! ");
INSERT INTO tgj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","No hum mvngjv lvlaka, jwngkadaka alu lo Pwknvyarnv nonua svnga Sodom ha kaiyago aya kaatam riku!” ");
INSERT INTO tgj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ho dw hoka Jisu minto, “Abu, nyidomooku gvla kvdw mookugv Ahtu! Nam ngo umbonyikv vla mindunv ogulvgavbolo no gv chinvpanv nyi vdwa vvsi nama silu no chimapamunv vdwa kaatam kunam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Vkv Abu so si no gv rimu dvbv vla mvngnam mv. ");
INSERT INTO tgj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ngo gv Abu nga ogumvnwngnga jipv. Yvvka Kuunyilo nga chima Abu mvngchik, okv yvvka Abunyi chima Kuunyilo ngv mvngchik okv Kuunyilo gv nw atu v kaatam dubv vla darnam nyi vdwv. ");
INSERT INTO tgj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mvnwngngv ngoogvlo aalaka, yvvdw ainv yikungyira baktola anyu kumabv ridunv, okv ngo nonua doonu modubv jire. ");
INSERT INTO tgj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngo gv rvngko nga no naala mvlwk sila gvtola ngoogv kochingbv vngming gvtoka, ogulvgavbolo ngo dow lo alvnv okv nyaknyaknv; okv nonuno doonu nama paare. ");
INSERT INTO tgj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngoogv nonua rvngko jinam angv gvpu dunv okv ngoogv nonua vge bakmu namv haajup dunv.” ");
INSERT INTO tgj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Achukgo ayungjvma nga Jius Doonualu golo Jisu radv rongolo vngkarto. Nwgv lvbwlaksu vdwv kano nyato, vkvlvgabv bunu radv dape pikla dvrap nyato. ");
INSERT INTO tgj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Vdwlo Parisis vdwv hum kaapa tokudw bunu Jisunyi minto, “Kaatoka, no gv lvbwlaksu vdwv Jius Doonualu so vbvrinamv ngonugv Pvbv nga rinyingdu!” ");
INSERT INTO tgj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisu mirwksito, “Dabid la ninyigv nyi vdwv vdwlo bunu kano tokudw ogugo ripv hum no vdwloka puri rika mapv nvri? ");
INSERT INTO tgj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nw Pwknvyarnv gv naam arwngbv aato, okv nw la ninyigv nyi vdwv Pwknvyarnv gvlo kumlwk joolwk nam vtwng nga dvto, hum bunu dvbolo Pvbv nga rinying nam gubv riku jvka-ho gv hum nyibu vdwv mvngchik dvmwng dunv. ");
INSERT INTO tgj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Okv nonu Moses gv Pvbv ngaaka puri rika mapv nvri Jius Doonualu gv dwkia nyibu dvdv ngv Jius Doonu alu gv pvbv nga mvvkmvrwk ropv, vbvritola bunuv rigakpama duai? ");
INSERT INTO tgj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngo nonua minjidunv Pwknvyarnvnaam a kaiyanv go sika si doodu. ");
INSERT INTO tgj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Darwknv Kitaplo mindu ‘aya kaapa minsunam si ngoogv mvngnam mv, svnwngsvmin rinji nama makv.’ Soogv minam sum no jvjv bv chirung bolo, nonu mia kumare nyi rimur manv vdwa; ");
INSERT INTO tgj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nyia Kuunyilo ngv Jius Doonualu gv Ahtu hv.” ");
INSERT INTO tgj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisu ho mooku ham vngyula Jius kumkunaam bv vngtoku, ");
INSERT INTO tgj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","hoka nyi ako laak hv lakpik nvgo dooto. Nyi mego hoka Jisunyi rimur rimu gvrila gungnying lwkdubv vla dooria nyato, vkvlvgabv bunu ninyia tvvkato, “Jius Doonualu lo mvpu jinam si ngonugv Pvbv nga rinying nambv ridu nvri?” ");
INSERT INTO tgj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisu mirwksito, “Nonugv lokv akonv svlar go doore okv hv Jius Doonualu lo ungrung arwng gulo holwk rinyi? Hum nw gakbwng gvrila agum joolin maredw? ");
INSERT INTO tgj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Okv nyi si svlar ham achialvbv kaiyanv gukv! Vkvlvgabv ngonugv Pvbv ngv ngonua Jius Doonualu lo kaadurridur minsu dubv jilin dunv.” ");
INSERT INTO tgj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Vbvrikunamv nw nyi lakpiknv hum minto, “Noogv laak hv lakda tvka.” Nw hum lakdakvra jito, okv hv lvkodv alv toku, laak lakgonv aing toku. ");
INSERT INTO tgj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Vbvrikunamv Parisis vdwv vngyu toku okv Jisunyi mvkidubv rungrap toku. ");
INSERT INTO tgj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Vdwlo Jisu nyi vdwgv ninyia mvki dubv gwngnam a tvvpa tvkudw, nw ho mooku ha vngyu toku; okv nyipam twngtv nvgo ninyia vngming gvto. Nw nyi lvvmanv mvnwngnga mvpu jitoku ");
INSERT INTO tgj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","okv bunua nw gv lvga nga yvvnyika minji mabvka vla mingap to. ");
INSERT INTO tgj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nw gv svbvrinam si Pwknvyarnv gv nyijwk Aijaya gvlo minam ma jvjv bv rilin modubv rito: ");
INSERT INTO tgj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ngoogv darnam, pakbu hv si doopv, ngoogv paknam, yvvnyi ngo alvbv mvngpvdw. Ngo ninyigv aolo ngoogv Dow nga jilwkre, okv nw ngoogv jwngkadaka nama diringmooku mvnwnglo gokgo jire. ");
INSERT INTO tgj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nw vdwloka larmare vmalo achialvbv gokmare vmalo banggu lamtv loka sudu pvbin rimare. ");
INSERT INTO tgj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nw vdwloka nvmwng yapchar nvgoka mvrik mare, vmalo mvru gudor manv ngaaka mvngit mare. Nw jvjv nga riya yamuma dvdvlo nw ribwngdvdvre, ");
INSERT INTO tgj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","okv nw gvlo nyi vdw mvnwngngv mvngging reku.” ");
INSERT INTO tgj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Vbvrikunamv nyi vdwv nyikching okv uyuvram gvtola gaam milin nyumanv nyi ako Jisu gvlo aagv jito. Jisu nyi anga mvpu jitoku, vkvlvgabv nyi angv nyiktar laku okv gaam milin nyutoku. ");
INSERT INTO tgj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nyipam nyi mvnwngngv lamngak nyatoku, Jisu gv rinam a kaagv rikula. Bunu tvvkato, “Si nyi si Dabid gv Kuunyilo ngvdw?”. ");
INSERT INTO tgj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Vdwlo Parisis vdwv hum tvvpa pvkudw, bunu mvrwkto, “Hv uyuuvram vdwa chara nyudo ogulvgavbolo bunua rigvdogvnv Biljebul ninyia vbv rinyu dubv jwkrw a jipv nvgo.” ");
INSERT INTO tgj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisu chintoku, bunugv ogugo mvngnam a, vkvlvgabv nw bunua mintoku, “Diringmooku gunv ngv atuv apinain sula akonv ako nvnga mvdar minsu nvngv ayungbv dooma dunv. Okv banggu okv vpin gunv apinain sula akonv ako nvnga mvdar minsu nvngv hv ngoodunv. ");
INSERT INTO tgj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Vkvlvgabv Uyu gv karv lo akonv ako nvnga mvdar minsu bolo, hvbv rinam hv manv bunu apinain suro pvku okv baapubv ngoonam bv rireku! ");
INSERT INTO tgj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nonuno nga mindu Biljebul nga jwkrw jinam lvgabv ngo vbv uyuuvram vdwa chara nyudunv vla, Alvdo, vbvrinamv nonua reming gvnv vdwa yvvla bunua chara nyudubv jwkrw jinv ngv? Nonua reming gvnvgv ogugo rinam lokv nonu mimor rungdo vla kaalin modu! ");
INSERT INTO tgj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma, si Biljebul makv, vbvritola Pwknvyarnv gv Dow v, nw nga uyuuvram vdwa chara nyudubv jwkrw jinv ngv, so si Pwknvyarnv gv Karv ngv nonu gvlo aapvku vla ho kaalin modu. ");
INSERT INTO tgj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Yvvka gwlwknv nyi gv naam lo mvko mvro la aala yikungyira nga naanyu mare, vdwlo nw gwlwknv nyi anga leepv choma bolo; leepv chobolo hv yikungyira nga dvrit nyulare. ");
INSERT INTO tgj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Akonv yvvdw ngogvbv rima dunv hv nga rinying rungdunv; akonv yvvdw nga ridur madunv naakum namvka ayak apak rungdunv. ");
INSERT INTO tgj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Okv vkvlvgabv ngo nonua minji dunv nyi vdwgv rimur a okv bunugv alvmanv mimur minam a mvngnga nyure; vbvritola yvvdw Darwknv Dow a alvmabv mimur redw hum vdwloka mvngnga nyulamare. ");
INSERT INTO tgj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yvvdw Nyia Kuunyilo nga alvmabv minyingmiru go minjeka hum mvngnga nyulare; vbvritola yvvdw Darwknv Dow a alvmanv minyingmiru go minredw hum vdwloka mvngnga nyulamare-vjakka okv kokwng nyika. ");
INSERT INTO tgj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Alvnv apwasi paanam lvgabv, no bakboknv singnv sorung laka; no singnv yaagampolonv sobolo apwasi alvmanv paare. Singnv nga apwasi svvlin kolokv kaachin dunv. ");
INSERT INTO tgj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kaakudubvrinv nonu-oguaingbv nonu atubongv alv mapv tvvla, alv nvnga minyu dubv? Haapok gv karukaya nga gaam lokv milin dunv. ");
INSERT INTO tgj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Alvnv nyi v ninyigv alvkolokv alvnvnga naalwk dunv; alvmanv nyi v ninyigv alvmaku lokv alvmanv nga naalwk dunv. ");
INSERT INTO tgj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nonuno mvngjelvlaka jwngkadaka alu lo mvnwngngv alvmanv gaam raanam dvdv nga kikala jidubv rireku. ");
INSERT INTO tgj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nonuno rimur pvdw ma rimur mapvdw, nonugv gamchar dvdv lokv nonua kaadar nvnv reku.” ");
INSERT INTO tgj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Vbvrikunamv Pvbv tamsarnv nyi mego okv Parisis nyi mego milin nyato. Bunu minto, “Tamsarnv, ngonu nam lamrwpanam go ridubv kaanwngdo.” ");
INSERT INTO tgj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“Silu meru gv nyi vdwsi achialvbv alvmanyado okv pwknvyarnv kaama nyado!” vla Jisu minto. “Nonu ngam lamrwpanam rinam go koodu ai? Ma! Nonua lamrwpanam go kaatam svngv hv nyijwk Jona gv lamrwpanam nga kaatamre. ");
INSERT INTO tgj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona gv kainv ngui arwnglo alu loum gola ayu yubom go doonam apiabv Nyia Kuunyilo ngvka kvdw arwng bolo alu loum gula okv ayu yubom go doore. ");
INSERT INTO tgj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jwngkadaka alu lo Ninebe gv nyi vdwv dakrap la nonua yamre, ogulvgavbolo bunu vdwlo Jona gv japji nama tvvtokudw mvngdin nyatoku; okv ngo nonua minjidunv Jonanyi kaiyanv go si doopv! ");
INSERT INTO tgj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jwngkadaka alu lo Seba gv Dvnv ngv dakrapla nonua yamre, ogulvgavbolo nw adubv moing vngla ninyigv mooku lokv ngv Solomon gv chinampaanam bv tamsar nama tvbv vngto; okv ngo nonua jvjvbv mindu Solomonnyi kaiyanv go si doopv! ");
INSERT INTO tgj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Vdwlo alvmanv dow v nyi gvlokv linri kudw, hv mooku mvnwnglo dooku makarla vnggo kardunv. Hv vdwlo dooku ako mapa kuma bolo, ");
INSERT INTO tgj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","hv atubongv minsu dunv, ‘Ngo ngoogv naam lo vngkur reku.’ Vkvlvgabv hv naam aakur laku naam a arochoko dubv, kakakbvrak dubv, okv mvnwngngv alvla doin dubv paadu kunv. ");
INSERT INTO tgj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Vbvrikunamv hv vngkur dvla kuring ninyia kaiyabv alvmanv dow kanw go naalwk dukunv, okv bunu aala ho doolwk dukunv. Vkvlvgabv so si vbv rinya vngnya kubolo, ho nyi angv kvvlo gvnga kaiyago alvmayabv ridu kunv. So si vbvku silu meru gv alvmanv nyi vdwa rirekunv.” ");
INSERT INTO tgj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisu nyi vdwa gaam raadungla doorilo, ninyigv Anv okv boru vdwv aalwkla ninyia gaam mindubv vla agumlo tvkala daknyato. ");
INSERT INTO tgj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Vkvlvgabv hoka nyi akonv minto, “Kaatoka, noogv anv okv boru vdwv, nam gaam mindubv vla agum v daknya pv.” ");
INSERT INTO tgj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisu mirwkto, “Yvvla ngoogv anv ngv? Yvvla ngoogv boru vdwv?” ");
INSERT INTO tgj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Vbvrikunamv nw ninyigv lvbwlaksu vdwa chigap dvla minto, “Kaatoka! So vdw si ngoogv anv okv boru vdwv! ");
INSERT INTO tgj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yvvbunudw ngo Abu nyidomooku tolo doonv gv mvnglwk kaalwk bv ridunv hv bunu ngoogv boruv, ngoogv bormv ngv, okv ngoogv anv ngv.” ");
INSERT INTO tgj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ho alu akin hoka Jisu naam ha vngyula svparsvlv kiambv itoku, hoka nw dootung tvla tamsarto. ");
INSERT INTO tgj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ninyia doyumdochinv nyi vdwv achialvbv twngtv kunam lvgabv nw svpw gulo aala dooto, nyipam gv agum lo dakrilo. ");
INSERT INTO tgj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nw minchisinam minv nvla bunua ogumvnwngnga minjito. “Alu gulo nyi ako rongolo radv chibv vnglinto. ");
INSERT INTO tgj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nw rongolo radv ha chirilo, megonv lamtvlo hopvto, okv pvta vdwv aala hum dvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kvgonv lvngtak aolo hopvto, hoka kvdw miang go dooto. Amw v Vjakgobv boksu dato, ogulvgavbolo kvdw v rungrwng mato. ");
INSERT INTO tgj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Vbvritola vdwlo doonyi v chaalin tokudw, agar anga kaayok toku; ogulvgavbolo miamiv rungrwngbv harlwk madvto, agar angv baapubv sinyok toku. ");
INSERT INTO tgj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Amw kvgonv mootum tv pvdwng lo hopvto, hv singlin toku, singnv vdwv hum yuptwngpatoku. ");
INSERT INTO tgj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Vbvritola amw kvgonv alvnv kvdw lo holwk toku, okv radv vdwv svngla dape pelin lakula; kvgonv chaam bv, kvgonv chamkvbv okv kvgonv lwnggobv lintoku.” ");
INSERT INTO tgj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Okv Jisu minyabv minto, “Tvvtoka, nonuno nyarung doodu bolo!” ");
INSERT INTO tgj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Vbvrikunamv lvbwlaksu vdwv Jisu gvlo aala tvvkato, “No nyi vdwa gaam minrinyi ogubv minchisinam minvla mindunv?” ");
INSERT INTO tgj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisu mirwkto, “Nyidomooku gv Karv gv lvga nga nonua minji ropvkunv, vbvritola bunua minji madv. ");
INSERT INTO tgj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yvvnyi hv ogugo doodunv hum jitamre, ninyia kaiyayabv doomu kunam lvgabv; vbvritola yvvdw oguka kaama dunv ninyigv achukgo doonam haka dvrit reku. ");
INSERT INTO tgj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ngoogv bunua minchisinam minvla minam gv lvga ngv bunu kaagapdo, vbvritola kaapama, okv bunu tvvdu, vbvritola tvvpama okv chima. ");
INSERT INTO tgj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Vkvlvgabv Aijaya gv nyikrw kaanam hv bunua mindu: ‘So nyi vdw si tvvdu okv tvvdu vbvritola tvchinma; bunu kaadi kaadidu, vbvritola kaapa ma, ");
INSERT INTO tgj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ogulvgavbolo bunugv haapok vdwv pvcha nyapv, okv bunugv nyarung nga mvtum sinyapv okv bunugv nyik a nyikching sinyapv. Vbv mvmabolo bunugv nyikkv kaapare, bunugv nyarung ngv tvvpare, bunugv haapok v chiri kunvpv, okv bunu nga dakrwk reku, Pwknvyarnv mindu, okv bunua ngo mvpu pvku nvpv.’ ");
INSERT INTO tgj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nonu gvbvdv vdwgo gamdakpv! Nonugv nyik v kaapadu, nonugv nyarung ngv tvvpadu. ");
INSERT INTO tgj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngo nonua jvjvbv mindunv, nyijwk achialvgo okv Pwknvyarnv gv pakbu achialvgo, nonugv kaagv dvnam a kaadubv mvngyato, vbvritola bunu kaapama, okv nonugv tvvgv dvnam a tvvdubv mvngnyato, vbvritola bunu tvvpa riakuma. ");
INSERT INTO tgj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Vbvrikunamv, tvvria nyato, okv chinlaka amw chinam minchisinam si ogu vdw. ");
INSERT INTO tgj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yvvdw Pwknvyarnv gv Karv gv doin a tvvgv rila hum tvvchin madunv hv lamtvlo amw hoolunv jvbv ridunv. Bunu gvlo amw chilwk nama uyu vrammv aala dvrit dunv. ");
INSERT INTO tgj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amw v lvngtak aolo hopvnv nvngv hobunua mindunv doin a tvdanam gula himpula torwk sinv vdwa. ");
INSERT INTO tgj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Vbvritola bunu ho rungrwngbv miami hv harlwk madu, okv bunu doobwng jinv gubv rikuma. Vkvlvgabv vdwlo doin gv lvkwngbv adwkaku vmalo mvdwkmvkuv aari kudw, bunu vjakpi gubv topu riku. ");
INSERT INTO tgj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amw v tvv pvdwng gulo holwknvngv hobunua mindunv doin a tvgvrila; vbvritola ninyigv singdung lvgabv mvngrula, okv nyitvnyigam lvgabv mvngbiu namv doin ha yuptoku, okv bunu apw asi svvlin kuma. ");
INSERT INTO tgj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Okv amw hv alvnv kvdw lo chilwk kunam hv ho bunua mindunv yvvdw doin ha tvvgvrila hum tvchin dunv; apw asi svvlin dunv, megonv chaam bv, kvgonv chamkvbv, okv kvgonv lwngbv bv.” ");
INSERT INTO tgj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisu bunua kvvbi minchisinam go minjito: “Nyidomooku gv Karv ngv svbv ridunv. Nyi ako ninyigv rongolo alvnv amw a chilwkto. ");
INSERT INTO tgj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ayu yupgolo, mvnwngnga yupmu tvla, nyimak ako aala vvng amw mego ampu apumlo paklwk pila vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Vdwlo agar hv garlin tokudw anw hv paalin raptoku vbvrikunamv vvng nga kaapa raptoku. ");
INSERT INTO tgj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nyi hvkvgv pakbuv aala ninyia tvvkato, ‘Atu, no gv rongolo no amw alvnv vkv paklwk pvnv; vvng ngv ogolo lokv aapvnvdw?’ ");
INSERT INTO tgj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nw mirwksito, ‘Nyiru nvgonv hum ripv.’ Bunu ninyia tvvkato, ‘No ngonua vngla vvng nga bulin svgo vla mvngdure?’ ");
INSERT INTO tgj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nw mirwksito, “Ma, nonuno vvng nga bulin rinyi ampu ngaaka butak linjila. ");
INSERT INTO tgj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vvng hala ampu nga bunyia lvkobv svngba rimutvka Nvvkumdw lobv. Vbvrikunamv ngo nvvkum jinv vdwa vvng nga naakum chotokv, puching tvkv, ramyok tvkv vla minre, okv ampu nga nvvkumla ngoogv nesunglo baglwk laka vla minreku.’” ");
INSERT INTO tgj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisu bunua kvvbi minchisinam akodv mindvto; “Nyidomooku gv Karv ngv svbv ridunv. Nyi ako yingmw chargo naalaila ninyigv rongolo hum paklwk to. ");
INSERT INTO tgj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","So si amw mvnwngnga charching yachoknv, vbvritola vdwlo hv svngrap tokudw, hv tamitasa mvnwngnga kaiyachok nvgobv ritoku, hv singnv gubv ritoku, vbvrikunamv pvta mvnwngngv aala ho gv hakbv dvdvlo asup mvlwkla doonya toku.” ");
INSERT INTO tgj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisu bunua vjaklodvbv minchisinam go minji jidvto: “Nyidomooku gv Karv ngv vbv ridunv. Mvvga ako vpap naala okv hum moida ata keji champigo naala pvchwng lo mvyomvchidu goochama dvdvlobv.” ");
INSERT INTO tgj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisu minchisinama minv nvla ogumvnwngnga nyipam a minjito; Nw minchisinama mintak mabv bunua ogugoka mimato. ");
INSERT INTO tgj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nw gv svbvrinam si nyijwk gv minpv nama jvjvbv rilin modukubv rito, Vdwlo ngo bunua gaam minridw ngo minchisinam minv nvla minre; Ngo bunua krim Sichingmooku sam pwklinyarlin rilokv naala vjak lobv chima nama minjire.” ");
INSERT INTO tgj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Vdwlo Jisu nyipam a vngyula naam lo aato kudw, ninyigv lvbwlaksu vdwv nw gvlo aala tvvkato, “Tamsarnv, noogv rongo vng nga minchisila minammv ogu hvdw ngonua minjilabv.” ");
INSERT INTO tgj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisu mirwksito, “Alvnv amw chilwkkunv nyi angv si Nyia Kuunyilo ngv; ");
INSERT INTO tgj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","rongo ngv nyiamooku si, alvnv amw v Karv gv nyi vdwv; vvng ngv Alvmanv Angv gv nyi vdwv; ");
INSERT INTO tgj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","okv vvng amw a chilwknv angv Uyudvbv. Nvvkumdw aluv nyiamooku gv ataranya ngv, okv nvvkum rianv vdwv nyidogindung ngv. ");
INSERT INTO tgj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Vvng nga oguaingbv nvvkumla vmvlo ramyok dvdw, vkv aingbv rire nyiamooku gv ataranya alulo; ");
INSERT INTO tgj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nyia Kuunyilo ngv ninyigv nyidogindung vdwa vnglin more ninyigv Karv lokv, yvvbunudw nyi vdwa rimur modunv, okv kvvbi alvmanv ridunv, ho vdwa naakum more, ");
INSERT INTO tgj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","okv bunu vdwa achialvbv vmv gukulo bunu orlwk reku, hoka bunu kapriku okv bunugv hijung nga kotwkkrwk sila dooreku. ");
INSERT INTO tgj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Vbvrikunamv Pwknvyarnv gv nyi vdwv bunugv Abu gv Karv lo doonyi ungnam aingbv rireku. Vbvrikunamv nonuno nyarung gvdu nvlo tvvria laka! ");
INSERT INTO tgj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Nyidomooku gv Karv ngv svbv ridunv. Nyi akonv rongo gulo yikungyira vvsi namgo kaapa toku, hum nw lvkodv mvtum toku okv himpu puyingla vnglaku ninyigv ogumvnwngnga piokla kula okv vngkur laku ho gv rongo nga rvvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nyidomooku gv Karv ngv svbv rita dunv. Nyi akonv svngtor singku kaapunv makar dubv rito, ");
INSERT INTO tgj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","okv vdwlo nw kaapuyaung nvgo kaapa tukudw, nw vnglaku ogugo svnggvrigv pvkudw mvnwngnga piokla kula ho gv svngtor singku nga rvvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nyidomooku gv Karv ngv svbvka rita dunv. Ngui naanv nyi megonv bunugv vsap a svparsvlv lo orlwk nyala nvgwngnv ngui vkv naanyato. ");
INSERT INTO tgj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Vdwlo vsaplo yarbing tokudw, bunu hum agum lo svvlin toku okv dootung nyatola ngui a darpin sidula: alv nvnga bunugv pvtak lo lwkto okv alvmanv vdwa ora nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ataranya alu lo vbvching rireku: nyidogindung ngv vnglin nyala alvnv nyi vdwgv apum lo alvmanv nyi vdwa naakum riku ");
INSERT INTO tgj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","okv bunua achialvbv vmv guku lo orlwk reku, hoka bunu hijung nga kotwkkrwk sila dooreku. ");
INSERT INTO tgj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisu bunua tvvkato, “Nonuno so vdw sum tvvchinpvri?” Bunu “vkv” vla mirwksito. ");
INSERT INTO tgj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Vkvlvgabv nw bunua mirwkto, “Vbvrikunamv so gv minam si Pvbv tamsarnv mvnwngngv Nyidomooku gv Karv lo lvbwlaksu bv rikubolo, hv bunu naam atuv ninyigv karchung gv yikungyira nga aku jeka anw jeka lvkobv naalinnv atu jvbv ridu.” ");
INSERT INTO tgj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Vdwlo Jisu so gv minchisinam sum bunua minjila minya tokudw, nw ho mooku a vngyu toku ");
INSERT INTO tgj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","okv ninyigv banggu lo vngkur toku. Nw jius kumkunaamlo tamsar toku, okv nw gvlo tvvnv vdwv tvngarvnga nyatoku. Bunu tvvkato, “Nw svkvnv mvngkimvnglak kv ogolo paapv nvyu? Okv ninyigv lamrwpanam rinam v oguvkudw? ");
INSERT INTO tgj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nw yikungyira mvnv gv kuunyilo mangvri? Meri ninyigv anv mangvri? Okv Jems, Josep, Saimon, okv Judas bunu ninyigv boru mangvri? ");
INSERT INTO tgj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ninyigv bormv vdwv so dooma dvnvdw? Nw so mvnwng sum ogolokv paapv nvyu?” ");
INSERT INTO tgj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Okv vbv bunu ninyia toa nyatoku. Jisu bunua minto, “Nyijwk ka ninyigv banggu naam lo okv nw atugv vpin nyi ngv mvngdv madunv, vbvritola mooku mvnwnglo mvngdv nama paayadunv.” ");
INSERT INTO tgj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ogulvgavbolo bunu mvngjwng namgo kaama, okv nw hoka achialvgo lamrwpanam goka riji mato. ");
INSERT INTO tgj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hvbv riri hoka Galili nga rigvdogvnv Herod, Jisu gv lvkwng nga tvvpa toku. ");
INSERT INTO tgj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Nw jvjvbv Jon Baptist turkur pvku nvgo vla ninyigv nyigam vdwa minto. “Vkvlvgabv nw lamrwpanam ridubv jwkrw doopvnv.” ");
INSERT INTO tgj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kvlokvcho Herod Jonnyi naatungla leetola patwk tumdubv orto jitoku. Nw gv svbvrinam si ogulvgavbolo ninyigv boru Pilip gv nywng Herodias gv lvgalo. ");
INSERT INTO tgj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Lvkogulo Jon Baptist Herodnyi minto, “Noogv Herodiasnyi nywng mvnam si mvyin madunv!” ");
INSERT INTO tgj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod ninyia mvkidubv mvngto, vbvritola Herod Jius nyi vdwa busuto, ogulvgavbolo bunu Jonnyi nyijwk akobv mvngnyato. ");
INSERT INTO tgj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod gv nvlum dvdw alulo Herodias gv kuunyijar angv nyi mvnwng gv kaagialo kaapu alvbv naasi rijito. Herod achialvbv himpula ");
INSERT INTO tgj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nw ninyia milv jito, “Ngo jvjvbv milv jidunv no ogugo koopvdw hum jirungre!” ");
INSERT INTO tgj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hv ninyigv anv gv minkulo, vbv minto, “Ngam so vjak Jon Baptist gv dumpo nga kumpok gulo jilabv!” ");
INSERT INTO tgj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dvbv ngv mvngruto, vbvritola ninyigv nyi mvnwng gv tvvgia kaagialo milvkunam lvgabv nw nyijar gv mvngnam ma jidukubv orto jilin toku. ");
INSERT INTO tgj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Vkvlvgabv nw Jon gv dumpo nga patwklo paalin toku. ");
INSERT INTO tgj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dumpo nga kumpok gulo bvnglwk toku okv nyijar anga jitoku, hv ninyigv anv gvlo bvnglwk jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jon gv lvbwlaksu vdwv aatoku, ninyigv svma nga bakro toku okv hum nyibung ritoku; vbvrikunamv bunu vnglaku Jisunyi minpa jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Vdwlo Jisu Jon gv lvga yunying nga tvvpa tokudw, nw atuv hoka kongv vngyula jvmataiku mooku lo vngtoku. Nyi vdwv hum tvvpa tvku, vkvlvgabv bunu banggu a kayu pikula lvpabv kvdw lo ninyigv kochingbv vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisu svpw lokv lintoku, okv vdwlo nw nyipam pamtv nga kaato kudw, ninyigv haapok v bunua aya mvngpa toku, okv nw lvvmanv vdwa mvpu jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ho arium hoka ninyigv lvbwlaksu vdwv nw gvlo aala minto, “So si achialvgo ayung pvku, okv so si jvmataiku mooku go. Nyi vdwa vngmu tvkuka okv bunua atuv nampum lo vngla dvnamtvngnam rvvsu motoka.” ");
INSERT INTO tgj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisu mirwkto, “Bunu vngsv kaama, nonuno atu v bunua dvnamtvngnam jirung svgo!” ");
INSERT INTO tgj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bunu mirwksito, “Ngonu mvnwng gv aralo vtwng tangu gula ngui nvvnyi gomwng kv.” ");
INSERT INTO tgj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisu minto, “Vbvrikunamv hum soka ngoogvlo bvnglwkto.” ");
INSERT INTO tgj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nw nyi vdwa vvng aolo dootung dubv minto; vbvrikunamv nw vtwng tangu hala ngui nvvnyi ha naatoku, nyidomooku aobv kaadungto okv Pwknvyarnvnyi umbonyikv hvto. Nw vtwng nga pintungpiungto okv hum lvbwlaksu vdwa jitoku, okv lvbwlaksu vdwv hum nyi vdwa jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mvnwngngv dvgudvbv dvtoku. Vbvrikunamv lvbwlaksu vdwv dvlv nga paapi vring gola anyigo yarpok dubv naakum toku. ");
INSERT INTO tgj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hum dvnv ngv mvvga vmi ha kiya mabv nyiga dvdv ngv hejar angu to. ");
INSERT INTO tgj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Vbvrikunamv vdwlo ninyigv nyi vdwa vngmu rikulo Jisu lvbwlaksu vdwa svpw lo aamu toku okv svparsvlv gv taggo nvbv lincho modubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nyi vdwa vngmuro kochingbv nw atu hv kumdubv vla moodw gulo chaatoku. Vdwlo arium pvkudw, hoka Jisu akin mwngto; ");
INSERT INTO tgj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","okv hvbv riri hoka svpw v svparsvlv lo mego adubv vngtoku, doori v rikorla hum achialvbv riging kunam lvgabv, svpw v svkiok kioknam lokv kublwk tvvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aru gv gunta aom gvla akv gv pingkolo Jisu isi aobv vngla lvbwlaksu vdwgvlo aatoku. ");
INSERT INTO tgj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Vdwlo bunu ninyia isi aobv vngdubv kaapa tokudw, bunu achialvbv busu nyatoku. Bunu busu nyala svgokla minto, “Si vram gumabv.” ");
INSERT INTO tgj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisu vjakgobv bunua minto, “Mvngrw lakv!” si ngookv. Nonuno busu mabvka!” vla nw minto. ");
INSERT INTO tgj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Vbvrikunamv Pitar minto. “Ahtu, hv jvjv bv no vrungbolo, ngam isi aobv no gvlo vngdubv orto jikato.” ");
INSERT INTO tgj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisu mirwkto, “So aato!”. Vkvlvgabv Pitar svpw agumbv linto okv Jisu gv kiambv isi aobv vngrap toku. ");
INSERT INTO tgj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Vbvritola vdwlo kainv doori v ritokudw nw hum himpala busuto okv isi arwngbv holwk tvvto. “Ahtu ringla bvkv!” vla nw kapto. ");
INSERT INTO tgj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Vbvrikunamv Jisu vjakgobv aachilaku ninyia gagbwng toku okv minto, “Noogv mvngjwng ngv miang mvngpv no ogubv tintinrorubv mvngdunv?” ");
INSERT INTO tgj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bunyi anyiv svpw lo aaba sutoku, okv vbvrikunamv doori v ringin toku. ");
INSERT INTO tgj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Vbvrikunamv svpw lo doonv lvbwlaksu vdwv Jisunyi kumtojotoku. Bunu hartvla minto, “No Pwknvyarnv gv Kuunyilo jvjv gurung.” ");
INSERT INTO tgj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bunu svparsvlv nga vngbola Gennesaret vnam mooku lo aalwk toku, ");
INSERT INTO tgj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","hoka nyi vdwv Jisunyi kaachin toku. Vkvlvgabv bunu lvvmanv nyi vdwa mingo jinv vngmuto dokardovr mooku lo lvvmanv vdwa Jisu gvlo aagv modubv. ");
INSERT INTO tgj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bunu ninyia koodwkkrwkla koola minto, lvvmanv vdwa ninyigv vji jvlap a mvsit modubv; okv yvvbunudw mvsit pvkudw mvnwngngv pooya nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Vbvrikunamv Parisis mego okv Pvbv tamsarnv mego Jerusalem lokv Jisu gvlo aala okv ninyia tvvkato, ");
INSERT INTO tgj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Noogv lvbwlaksu vdwv ogulvgabv ngonugv abuapa vdwgv Pvbv jilu nama tvvmarima dunv? Bunu dvnam dvtv madvbv laakka alvbv lasoklakak madu!” ");
INSERT INTO tgj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisu mirwk suto, “Okv nonuno ogulvgabv Pwknvyarnv gv gamrw nama tvvmarima gvrila nonunogv mvnggwngbv tamsarrisar kolo vngya dunv? ");
INSERT INTO tgj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ogu lvga Pwknvyarnv mindu, ‘Noogv anv okv abunyi mvngdv laka,’ okv ‘Yvvdw ninyigv anv okv ninyigv abua beedunv hum mvkidubv riduku.’ ");
INSERT INTO tgj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Vbvritola nonuno tamsardo nyi gunv ninyigv anv okv abua ridurdubv ogugo doopv tvlaka, vbvritola minre, ‘Si Pwknvyarnv gvbv ripvkunv,’ ");
INSERT INTO tgj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","hv ninyigv abua mvngdv dubv dinchi kumadu. Svbvrila nonu Pwknvyarnv gv gamrw nama pakma dunv, nonugv mvngkubv tamsar kolokv riming gvnam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kaakudubvrinv nonu, Aijaya gv nonunogv lvgabv nyikrw kaapv namv jvjv rungpv! ");
INSERT INTO tgj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Pwknvyarnv mindu, “So nyi vdw si nga gamchar lokv mwng hartv mvngdo, vbvritola bunugv haapok v jvjvbv nga adu nyado. ");
INSERT INTO tgj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bunugv nga vbv kumnamjonam v ogu arin go kaama, ogulvgavbolo bunu nyi gv mvnam pvbv nga ngoogv Pvbv aingbv tamsar nyadu!’” ");
INSERT INTO tgj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Vbvrikunamv Jisu nyipam ma nw gvlo goklwkto okv minto, “Tvvgv rila okv chintoka! ");
INSERT INTO tgj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nyi gv gaam lo aanv ngv ninyia darwk madubv mvvma dunv; vbvmabvya, ninyigv gaam arwng lokv linnv ngv ninyia darwk madubv mvya dunv.” ");
INSERT INTO tgj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Vbvrikunamv lvbwlaksu vdwv nw gvlo aala minto, “Noogv minamv Parisis vdwa tvvnying modu vla no chindure?” ");
INSERT INTO tgj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","“Ngoogv Abu nyidomoku tolo doonv gv lvvlwk manam singnv mvnwngnga bua rikunv,” vla Jisu minto. ");
INSERT INTO tgj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bunugv lvgabv mvngru yama bvka! Bunu nyikching tola nyikchingnv nyi vdwa rigv nvngv; okv vdwlo nyikchingnv akonv kvvbi nyikching nvnga vnggv rinyi, anyiv ungrung golo holwk dunv.” ");
INSERT INTO tgj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pitar milinto, “So minam sum ngonua minbwk jilabv.” ");
INSERT INTO tgj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisu bunua minto, “Nonuno vjaklodvbv kvvbi vdwa chilv yanv gubv rima pvnvre. ");
INSERT INTO tgj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nonuno tvchinma hai? Nyi gv gaam lo aanv ngv leit arwnglo aadunv okv vbvritokula ayak lokv agum lo lindu kunv. ");
INSERT INTO tgj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Vbvritola gaam lokv linnv ngv haapok lokv lindunv, okv si nyi nga darwk madubv mvdunv. ");
INSERT INTO tgj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nyi gv haapok lokv alvmanv ngv linla ninyia mvki mvmar modunv, yoogio modunv, okv kvvbi rimur haka rimu dvnv; dvrit mola, mvvmula, okv kvvbia minsingmia mola. So vdw si nyi a darwk madubv mvdunv. ");
INSERT INTO tgj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Vbvritola nonugv laak lasok mabv dvnam, bunugv nonua rirung svgo vla minam-si nyi nga darwk madubv mvvma dvnv. “Vbvritola bunugv rirung sego vla mvngnam—Lasok mabv dvku lokv nyi si darwkmanv gubv rima dunv.” ");
INSERT INTO tgj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisu ho gv mooku a vngyu toku okv Taire okv Sidon gv nvchi mooku lo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kananait mvvga ako ho mooku hoka doonvgo nw gvlo aato. Mvvga nvngv kapla minto, “Dabid gv Kuunyilo! Ngam aya mvngpa labv, tamsarnv! Ngo gv kuunyijar v uyuvram gvpv okv nw achialvbv hiru kaayala doopv.” ");
INSERT INTO tgj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Vbvritola Jisu nyimv nvnga gamgo ka mimato. Ninyigv lvbwlaksu vdwv nw gvlo aala kodwkkrwkla koola minto, “Ninyi vngmu tvkuka! Nw ngonua vngming gvla tvvsupkayap dubv minkidu!” ");
INSERT INTO tgj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Vbvrikunamv Jisu mirwk suto, “Ngam Israel gv svlar nyekunv vdwgv lvgabv vngmupvnv.” ");
INSERT INTO tgj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hvbv rinam gula mvvga nvngv Jisu gv lvpa lo gublwk dvla minto, Tamsarnv, nga ridur labv!” ");
INSERT INTO tgj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisu mirwkto, “Vmi gv dvtung nga naaritla iki bv orji nam si alv rungma.” ");
INSERT INTO tgj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Tamsarnv, hv jvjv ngv” vla nyimv nvngv mirwksito; vbvritola iki vdwv atu gv dvkulo dva nama tvbul lvkwng loka dvria dunv.” ");
INSERT INTO tgj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Vkvlvgabv Jisu mvvga nvnga mirwkto, “No kaibv mvngjwngnv nyimv go! No ogugo rijilabv vla mvngdudw hum noogv lvgabv riji reku.” Okv hvbv mimisiri hoka ninyigv kuunyijar hv poya toku. ");
INSERT INTO tgj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisu ho gvngv vnglaku Galili gv svparsvlv kiambv vngtoku. Nw moodw gulo chaala dootung toku. ");
INSERT INTO tgj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kairungnv nyipam go nw gvlo aato, bunugv lvkobv lvpiknv vdwa, nyikchingnv vdwa, digwngnv vdwa, pvchanv vdwa, okv kvvbi lvvmanv nyi vdwa aagv nyato, ho bunua Jisu gv lvpa lvkwnglo vvpv nyato; okv nw bunua mvpu jinya toku. ");
INSERT INTO tgj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nyi vdwv lamrwpanya toku pvcha nvngv milin nama, digwngnvgv alvkunam a, lvpik nvngv vnglak kunama, okv nyikching nvngv kaapa kunama, kaagv rikula bunu Israel gv Pwknvyarnv nga hartv nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisu ninyigv lvbwlaksu vdwa goklwk toku okv minto, “Ngo so gv nyi vdw sum aya mvngpa do, ogulvgavbolo bunu nga reming gvkunamv alu loom pvku okv vjak bunu ogu dvsv guka kaakuma. Ngo bunua dvnam dvmu mabv vngmu nwngmado, bunu nampum lo vngtvrikunyi lamtvlo anyukumare.” ");
INSERT INTO tgj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lvbwlaksu vdwv ninyia tvvkato, “Ngonu ogulo dvnam naala so gv nyipamma dvgudvbv jinyure?” ");
INSERT INTO tgj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisu tvvkato, “Nonuno hvkamgo vtwng gvpv?” Bunu mirwksito, “Vtwng takkanw go okv ngui charchingnv mego.” ");
INSERT INTO tgj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Vkvlvgabv Jisu nyipamma kvdw lo dootung dubv mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Vbvrikunamv nw vtwng kanw hala ngui a naatoku, Pwknvyarnvnyi umbonyikv vto, pintung piyung toku, okv hum lvbwlaksu vdwa jitoku; okv lvbwlaksu vdwv hum nyi vdwa hortoku. ");
INSERT INTO tgj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bunu mvnwngngv dvgudvbv dvnya toku. Vbvrikunamv lvbwlaksu vdwv dvlv dvkv lvlin kunamma paapi kanw go yarpok dukubv naakum toku. ");
INSERT INTO tgj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hum dvnv dvdv ngv mvvga vmia kiya mabv nyiga dvdv ngv hejar api gubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Vbvrikunamv Jisu nyi vdwa vngmu toku, svpw gulo nw aatoku, okv Magadan mooku lo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisis megola Sadusis mego bunu Jisu gvlo gwngkup dubv vla aanyato, vkvlvgabv bunu Jisunyi Pwknvyarnv gv kiinam gurung vla kaadubv lamrwpanam go ritokv vla tvvkato. ");
INSERT INTO tgj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Vbvritola Jisu mirwkto, “Vdwlo doonyi v poklwk tvi kunyi, nonu mindu, ‘Ngonu alvnv doonyi a paato kuji, ogulvgavbolo nyidokolo ngv yalwng dooku.’ ");
INSERT INTO tgj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Okv arukamchinyi nonu mindu, ‘Silu nyido hoi jinvgo, ogulvgavbolo nyidokolo ngv yalwng yakia bv ridu.’ Nonu nyidokolo nga kaagvrila minbwk jichodu, vbvritola nonu vdwloka vjakgv lamrwpanam gv lvkwng nga minbwk jinyu ma! ");
INSERT INTO tgj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Vdwgo alvmabv okv Pwknvyarnv chimanv nyi bv ridu silugv nyi vdw si! Nonu nga lamrwpanam go koodu nvre? Ma! Nonua lamrwpanam go jijinam si Jona gv lamrwpanam rijinam vmwng.” Vkvlvgabv nw bunua kayu pikula vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Vdwlo lvbwlaksu vdwv svparsvlv gv takdv gonvlo rapto kudw, bunu vtwng gvse nga mvngpa mato. ");
INSERT INTO tgj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisu bunua minto, “Hinsu laka; Parisis gvla Sadusis gv vpap am hima kaaya sulaka.” ");
INSERT INTO tgj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bunu bunugv aralo raami surap nyato, “Ngonu vtwng gvmanam lvkwngbv nw vbv mindu.” ");
INSERT INTO tgj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisu chinto bunu ogugo minpvdw, vkvlvgabv nw bunua tvvkato, “Nonu vtwng gvmanam lvkwngbv ogubv raami sikwng dunv? Nonunogv mvngjwng ngv achok gomwng! ");
INSERT INTO tgj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nonuno vjvlodvbv chima dunvre? Nonu ngoogv vtwng tangu ham nyi hejar angu lvgabv pintung piyung nama mvngpama ai? Paapi hvkamgo nonu darbingpvnv? ");
INSERT INTO tgj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Okv nyi hejar api gv lvgabv vtwng takkanw gv lvkwng ngv oguv? Paapi hvkamgo nonuno darbingpvnv? ");
INSERT INTO tgj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngoogv vtwng gv lvkwng nga nonua gaam raami suma nama nonugv chima namv hv ogubv ripvnv? Hima kaaya sulaka Parisis gvla Sadusis gv vpap ham!” ");
INSERT INTO tgj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Vbvrikunamv lvbwlaksu vdwv Jisu bunua, Parisis gvla Sadusis gv vtwng lo lwknam vpap ham hima sulakv vla gamrw kumanyi, vbvritola bunugv tamsar nama mindukunvnyi vla chintoku. ");
INSERT INTO tgj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisu Pilippi gv Sijari banggu gv nvchi mooku lo vngtoku, hoka nw ninyigv lvbwlaksu vdwa tvvkato, “Nyia Kuunyilo nga, nyi vdwv yvv vla minya do?” ");
INSERT INTO tgj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Nyi megonv Jon Baptist kv vla minya do,” vla bunu mirwkto. “Kvvbiv Elija kv, okv kvgonv Jeremia kv vmalo kvvbi nyijwk go vla minya do.” ");
INSERT INTO tgj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nw bunua tvvkato, “Nonu gvbv oguv? Okv nonu ngam yvv vla mindunv?” ");
INSERT INTO tgj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pitar mirwksito, “No Kristo, turla doobwngnv Pwknvyarnv gv Kuunyilo ngv.” ");
INSERT INTO tgj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisu mirwkto, “Jon gv kuunyilo Saimon, no alvrungnv go! no gvlo so gv jvjv si nyi gvlokv aama, vbvritola naam sum ngoogv Abu nyido tolo doonv ngv jipv. ");
INSERT INTO tgj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Okv Pitar, vkvlvgabv ngo naam mindunv: No vlwng go, okv so gv vlwng aolo ngo, ngoogv Gvrja nga mvlwkre, okv sinam ngenam v sum vdwloka rigumriya yala mare. ");
INSERT INTO tgj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ngo naam Nyidomooku Karv gv chabi nga jidunv; noogv nyiamooku so maakv vnam a nyido mooku tolo maakv vreku, okv no ogugo nyiamooku so umkv vnam a nyido mooku toloka umkv vreku.” ");
INSERT INTO tgj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Vbvrikunamv Jisu ninyigv lvbwlaksu vdwa mintoku nw Kristo kv vla yvvnyika minji mabvka. ");
INSERT INTO tgj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ho gv alu lokv Jisu ninyigv lvbwlaksu vdwa mindamirala minpa jirap toku, “Ngo Jerusalem bv vngrungre okv nyigagaatv, nyibu butvnv, okv Pvbv tamsarnv vdw gvlokv hinching chingnam ma paarungre. Nga mvki nyareku, vbvritola alu loom kochinglo ngo turkur reku.” ");
INSERT INTO tgj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pitar ninyia sesum laila yamla minto, “Ahtu, Pwknvyarnv sum noogv lokv adu motoka, no gvlo si vdwloka rimare!” ");
INSERT INTO tgj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisu dakkur dakrwk dukula Pitarnyi minto, “Uyu no, ngo gvlokv vngroto! No ngoogv lamtvlo atup asi yanv gubv rido, ogulvgavbolo no gv svbv mvngnam si Pwknvyarnv gvlokv aama vbvritola nyi gvlokv aanv go.” ");
INSERT INTO tgj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Vbvrikunamv Jisu ninyigv lvbwlaksu vdwa mintoku, “Yvvdw nga lvkobv vngming gvso mvngnv ngv, hv atubongv mvngnga sirung laka, ninyigv rvngko nga bagtola, nga vngming gvlaka. ");
INSERT INTO tgj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yvvdw atubogv singdung lvgabv mvngdunv, hv ngooriku; vbvritola yvvdw ngoogv lvgabv ninyigv singdung nga ngoomu dunv hv singnam ma paaya reku. ");
INSERT INTO tgj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nyi gunv nyiamooku mvnwngnga paalv yagvre vbvritola nw atubogv yajiyalua ngoomu bolo, hv ogugo paabin yapv? Hvbv ma! Nw vdwloka ninyigv turnamam paakor kunam lvgabv oguguka nw jinyu kumare. ");
INSERT INTO tgj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nyia Kuunyilo ngv ninyigv Abu gv jwkrw lokv nyidogindung nga lvkobv aagvla aareku, okv vbvrikunamv nw akin-akin a kaigo ripvdw ma miang go ripvdw hum kaala amina jireku. ");
INSERT INTO tgj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngo nonua jvjvbv mindunv ho-hoka mego si doopv bunu Nyia Kuunyilo gv Dvbv bv rila aanama kaama dvdvlo simare.” ");
INSERT INTO tgj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Alu lokv gv kochinglo Jisu Pitar nyila achiboru Jems okv Jon bunua moodw aolo chaagvla hoka bunu mwngchik doobam nyato. ");
INSERT INTO tgj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bunugv vbv kaadung rilo, Jisu gvlo akusubv rilwkto: Ninyigv nyukmuv doonyi loung jvbv ungtoku okv ninyigv vjiv yapung toji toku. ");
INSERT INTO tgj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Vbvrikunamv lvbwlaksu aom v Moses nyila Elija bunyia Jisunyi lvkobv gaam raami sidubv kaatoku. ");
INSERT INTO tgj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Vkvlvgabv Pitar Jisunyi mintoku, “Ahtu, ngonugv soka doonam si alv rungnvgo! No mvnggelo, ngo soka taabio aom go mvre, akonyi no gvbv, akonyi Moses gvbv okv akonyi Elija gvbv.” ");
INSERT INTO tgj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ninyigv vbv mindung rilo, haapum ungnv go bunu gvlo aalwkto, okv haapum lokv gaamgo milinto, “Si ngoogv pakyachoknam Kuunyilo ngv, nw gvlokv ngo mvngpu dunv-Ninyi tvvria laka!” ");
INSERT INTO tgj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Vdwlo Lvbwlaksu vdwv vlv nga tvvtokudw, bunu achialvbv busula kvdw lo gipv nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisu bunu gvlo aala bunua mvsit toku. Nw minto, “Gudungto, busu mabvkv!” ");
INSERT INTO tgj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Vkvlvgabv bunu kaarap toku nyi kaapa kuma vbvritola Jisu akin mvngku. ");
INSERT INTO tgj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Vbv bunugv moodw lokv idung rilo, Jisu bunua orto jitoku, “Nyia Kuunyilo ngv sipi kula turkur kuma dvdvlo, nonunogv nyikrw kaanam sum yvvnyika minji mabvka.” ");
INSERT INTO tgj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Vbvrikunamv lvbwlaksu vdwv Jisunyi tvvkato, “Ogulvgabv Pvbv tamsarnv vdwv hoka Elija aacho yinv pvkv vla mindunv?” ");
INSERT INTO tgj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Elija aanam gvbv aachore, okv nw ogumvnwng nga mvpvripv jireku,” vla Jisu mirwk toku. ");
INSERT INTO tgj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Vbvritola ngo nonua jvjvbv mindu, Elija aaro pvkunv, okv nyi vdwv ninyia kaachin mato, vbvritola bunugv mvnggwng bv mvmin nyatoku. Ho mvpia bv bunu Nyia Kuunyilo ngaaka vbv alvmabv mvreku.” ");
INSERT INTO tgj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Vbvrikunamv lvbwlaksu vdwv tvchin toku nw Jon Baptistnyi mindu kunvgo vla. ");
INSERT INTO tgj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Vdwlo bunu nyipam vdwgvlo aalwk tokudw, nyi ako Jisu gvlo aala, lvbwng kumpvla, ");
INSERT INTO tgj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","okv minto, “Tamsarbo, ngoogv kuunyilo nga aya mvngpa jilabv! Nw svmik tapdu, okv vbv alvmabv kamdaramda bv rila vmvlo okv isi lo poklwk kidu. ");
INSERT INTO tgj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngo ninyia noogv lvbwlaksu vdwgvlo aagv jito, vbvritola bunu ninyia mvpu nyuma.” ");
INSERT INTO tgj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisu mirwk toku, “Nonu achialvbv mvngjwngmanv nyi gonya laka! Vdwgo ngo nonua lvkobv doodubv? Vdwgo ngo nonua mindinmimbia dvdvdubv? Vminyilo nga ngoogvlo aagvto!” ");
INSERT INTO tgj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisu uyuvram a orto jitoku, okv hv vminyilo gv lokv kelin toku, okv vjakpi gubv vmi angv ho poya datoku. ");
INSERT INTO tgj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Vbvrikunamv lvbwlaksu vdwv vngsila Jisu gvlo aala tvvka toku, “Ogubv rila ngonu uyuuvram a charlin nyuma pvnv gubvri?” ");
INSERT INTO tgj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jisu mirwkto, “Hv nonuno mvngjwng doomanam lvkwngbv, ngo nonua milv jidunv, nonuno yingmw aing goka mvngjwng dubolo, nonu so moodw sum minlado sokv kongv alo vlo vngroto vbolo, hv tvvla vngjire. Nonu ogumvnwng nga rinyure!” ");
INSERT INTO tgj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Okv kvvbi lokv rinyu mare kumnam lokvla okv yiknam lokv svkv nvnga charlin nyure.” ");
INSERT INTO tgj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Vdwlo lvbwlaksu mvnwngngv Galili lo aakum tokudw, Jisu bunua mintoku, “Nyia Kuunyilo nga nyiga vdwgvlo laklwk tvduku ");
INSERT INTO tgj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bunu ninyia mvki reku; vbvritola alu loom kochinglo nw turkur reku.” Lvbwlaksu vdwv achialvbv mvngru nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Vdwlo Jisu la okv ninyigv lvbwlaksu vdwv Kaparnaum lo aato kudw, Pwknvyarnvnaam lvgabv lampu narianv Pitar gvlo aato okv tvvkato, “No gv Tamsarbo, Pwknvyarnvnaam lvgabv lampu a jidu nvri?” ");
INSERT INTO tgj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Jidu nvpv,” vla Pitar mirwkto. Vdwlo Pitar naam lo aatokudw, Jisu mincho yato, “Saimon, no gv mvngnam v ogubv? Nyia mooku so gv dvbv vdwa yvvla rijo naanv vmalo lampu jinv ngv? Diringmooku so gv nyi vdwv re vmalo nyebunyi vdwv re?” ");
INSERT INTO tgj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitar mirwk suto, “Kvvbi mooku lokv aanv nyi vdwv. Jisu minto, “Alvpv, vbvrikunamv, vnam hv mannv nyidung nyi vdwv jikur kaama. ");
INSERT INTO tgj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Vbvritola ngonu so naarianv vdwa adwkaku molama. Vkvlvgabv svparsvlv lo vngnyika, okv noogv karpak a soolwk ngurv tvka. Naachonam ngui a svvlin tvka, okv ho gv gaam lo noogvla ngoogv lvgabv Pwknvyarnvnaam lampu jisv lokdwng chargo kaapare. Hum naala ngonu gvbv lampu jiji laka.” ");
INSERT INTO tgj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ho alu lo lvbwlaksu vdwv Jisu gvlo aala, tvvkato, “Nyidomooku gv Karv tolo yvvla kaiyachok jinv ngv?” ");
INSERT INTO tgj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Vkvlvgabv Jisu vmi go gokla bunugv kaagialo dakmuto, ");
INSERT INTO tgj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","okv minto, “Ngo nonua milv jidunv vdwlo nonu mvngdinla so vmi so aingbv rima redw, nonu vdwloka Nyidomooku Karv tolo aala mare. ");
INSERT INTO tgj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yvvdw so vmi aingbv rila nyanyak dunv hv Nyidomooku gv Karv tolo kaiyachok nvgobv rireku. ");
INSERT INTO tgj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Okv yvvdw svkvnv vmia ngoogv amin bv alvbv naarwk sidunv, hv ngamka naarwk sidunv.” ");
INSERT INTO tgj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Yvv akonv so miangnv vdw sokv akonyi nga mvngjing nvnga mva riadunv, ho nyi angv vbvribolo alvyare ninyigv lvngpo lo vlwng pwktv nvgo paklwk sutola svmasa bolo poklwk sunam mv. ");
INSERT INTO tgj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Achialvbv mvngru runam gubv rire nyiamooku gv nyi vdwa ogulvgavbolo bunugv mvngjwng nga ngoomu jinv ngv achialvdu! Vkv nvngv lokia ribwngre-vbvritola yvvdw um bunua rimudunv hv achialvbv mvngru runam gubv rire! ");
INSERT INTO tgj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Noogv laak gunv vmalo lvpa gunv noogv mvngjwng nga mvlamva riadu bolo, hum palin gvrila ora tvka! noogv lvgabv hv alvyare turnamlo laak vmalo lvpa gunv kaamabv vngnam mv, vbvmayabv laak laknyia okv lvpa lvnyia gvtola vmv doobwngnv gula dookulo orlwk komam svnga. ");
INSERT INTO tgj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Okv noogv nyik gunv noogv mvngjwng nga nyemu bolo, hum koolin gvrila ora tvka! Noogv lvgabv si alvyare no nyik nyikin tvvla singkulo vngnam mv, vmabvya nyik nyiknyia gvtola uyumooku bolo orlwk komam svnga. ");
INSERT INTO tgj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kaatoka nonuno miangnv vdw so gv akonyika mvngnyekalo mabvka. Ngo nonua mindu, bunugv nyidogindung ngv lokia nyidomooku lo doonv ngo Abu gvlo dooming gvnya dunv. ");
INSERT INTO tgj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nyia Kuunyilo ngv nyekunv vdwa ringlin tvkubv aapv kunv. ");
INSERT INTO tgj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nonuno ogugo mvngdu nyi ako svlar lvnggo dooto okv akonv nyetoku? Nw kvvbi chamkia gula kia nga moodw lo nvmwng dvla rimu pila, nw vngla nyenv anga makardu. ");
INSERT INTO tgj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Vdwlo nw hum kaapa rekudw, ngo nonua mindu, nw nyenv akin ho lvgabv nyemanv chamkia gula akkia ngam svnga achialv kaiyago mvngpu yareku. ");
INSERT INTO tgj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","So gv apiabv noogv Abu nyidomooku tolo doonv so gv miangnv vdw so akonyika ngoomu dubv mvngma dunv. ");
INSERT INTO tgj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Noogv achiboru ngv nam rinyingla rimur dubolo, vngla ninyigv rimur a kaatam laka. Vbvritola um nonyi anyi gv pingkolo risila rila ka. Nw noogv minam a tvvdu boloka, no noogv achiboru a ria yaala paakor pvku. ");
INSERT INTO tgj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Vbvritola nw noogv minam a tvvma dubolo, no nyi lo ako vmalo anyigo noogv lvkobv vnggv laka, ogulvgavbolo Darwknv Kitaplo minam aingbv ‘Rimur mvnwngnga tvyakaayanv anyi aom lokv tvbwkkalo dukubv.’ ");
INSERT INTO tgj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Okv nw bunua tvvmabolo, ogumvnwng nga Gvrja lo minpa laka. Ataranyabv nw Gvrja gv minam haka tvvma kubolo, ninyia mvngjwng manv gubv vmalo rimurnv nyi gubv toa lakuka. ");
INSERT INTO tgj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Okv vkvlvgabv ngo nonua mindunv: nonu sichingmooku so ogugo maakv vrikudw hum nyido mooku toloka maakv vrikunv, okv nonu sichingmooku so ogu gonyi vkv vrikudw hum nyido mooku toloka vkv vriku. ");
INSERT INTO tgj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Okv ngo nonua minta jidunv: Vdwlo nonu sichingmooku so anyi gunv tolwk minsula ogugonyi kumridw, hum nonugv lvgabv ngoogv nyidomooku gv Abu ngv rijireku. ");
INSERT INTO tgj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ogo lo anyi gunv vmalo aom gunv ngoogv amin bv dookum redw, ngo hoka bunua lvkobv dooming gvdunv. ");
INSERT INTO tgj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Vbvrikunamv Pitar Jisu gvlo aatoku okv tvvkato, “Ahtu nga ngoogv boruv rinyingla rimur morbwng bolo, ngo ninyia vdwgo mvngnga jidubv? Kanw guri?” ");
INSERT INTO tgj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisu mirwkto, “Ma, kanw mwngma, kanw hv chaamkanw lo gubv, ");
INSERT INTO tgj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ogulvgavbolo Nyidomooku gv Karv ngv svbv ridunv. Kvlokvcho dvbv ako dooto, nw ninyigv pakbu vdwgv narnamha kaaka dukubv mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nw vbv rirap kunam gula bunugv lokv pakbu ako, nw gvlo morko kororgo narnv anga aagv toku. ");
INSERT INTO tgj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pakbu angv morko dvdu nga dorla kuma toku, vkvlvgabv dvbv ngv morko dvdua dordu kubv nw nyila ninyigv nywng umvuu vdwa nyirabv okv ninyigv yikungyira dvdv nga piokdu kubv orto jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pakbu angv lvbwng kumpvla dvbv gv habolo gipvto. Nw kodwkkrwkla koola minto, ‘Nga achukgo dooria jilabvkv, okv ngo nam ogumvnwng nga dorku nvpv!’ ");
INSERT INTO tgj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dvbv ngv ninyia aya mvngpa toku, vkvlvgabv dvbv ninyia morko dvdu nga mvngnga jitoku okv ninyia vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Vbvrikunamv nyi angv vnglintoku okv ninyigv pakbu ajin gonyi vngrwk suto hv kvvlo nw gvlo morko achukgo narnv go. Nw hum gakbwng gvrila dvngrapto okv minto, “Ngoogvlo narnam a baapubv jikur lakubv.” ");
INSERT INTO tgj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ninyigv pakbu ajin angv ninyigv lvpa lvkwnglo gipv la ninyia koodwkkrwkla koola minto, ‘Nga ayala achukgo dooya jilabv, ngo nam dvdua dorku nvpv!’ ");
INSERT INTO tgj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Vbvritola nw um tvvmato; vmabvya nw nyi anga dvdua dorma dvdvlo doomure vla patwk tumlwk yatoku. ");
INSERT INTO tgj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Vdwlo dvbv pakbu gunv vbvrinam a kaapa tokudw, dvbvnyi ogumvnwng nga minpa toku. ");
INSERT INTO tgj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Vkvlvgabv nw pakbu anga goklwk toku. Nw minto, ‘Arin kaamanv nyira noo! Noogv ngoogvlo morko narnam mvnwngnga ngo nam mvngnga jitoku, noogv nga vbv koonam lvkwngbv. ");
INSERT INTO tgj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngoogv nam aya mvngpanam aingbv, no pakbu ajin a aya mvngpa rungse gui.’ ");
INSERT INTO tgj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dvbv ngv achialvbv haachi toku, vkvlvgabv nw pakbu anga dvdu nga gvma dvdvlo mvrit modubv vla patwklo vngmu toku.” ");
INSERT INTO tgj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Okv Jisu minyabv mintoku, “Vkv aingbv ngoogv Abu nyidomooku tolo doonv, mvnwngnga mvre, vdwlo nonuno haapok raying lokv achiboru gv rimur a mvngnga maridw.” ");
INSERT INTO tgj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisu vdwlo so ogumvnwngnga minya tokudw, nw Galili nga vngyu toku okv Jordan Svko gv tagonv Judia mookubv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nyitwng go ninyia vngming gvto okv nw bunua hoka mvpu jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisis nyi mego nw gvlo aala, ninyia mimur modubv vla svbv tvvkato, “Ngonugv Pvbv ngv nyi hv atugv nywng nga ninyigv mvngnambv gungnying lwknam lwksubv lwktola burmisidubv jipv ai?” ");
INSERT INTO tgj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisu mirwkto, “Darwknv Kitaplo mindu krim atuakelo Pwknvyarnv nyi vdwa pwklin rilo, nyimv bvla nyilo bv pwkto, vla minam a nonuno puri rikw mai? ");
INSERT INTO tgj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Okv Pwknvyarnv minto, ‘Svkv lvkwngbv nyi hv ninyigv anv okv abua kayupila vngyula atugv nywng nga lvkobv ribam yalaku, okv anyiv akin gubv ridu kunv.’ ");
INSERT INTO tgj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Vkvlvgabv bunu anyibv ribwng kumare vbvritola akin vku. Vbvrikunamv Pwknvyarnv gv ogugo naadum sunamma nyi v mvpin sirung mabvka.” ");
INSERT INTO tgj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisis vdwv ninyia tvvkato, “Vbvrikunamv, ogubv Moses Pvbv lo nyiga ngv nywng nga mvnwngnga chimpa modubv vnggvnvnv siti go mvlinla ninyigv laak lo jilwk gvrikula vngmu dukubv minpvnv?” ");
INSERT INTO tgj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisu mirwkto, “Moses nonua nywng vdwa burmi sudubv jito ogulvgavbolo nonua tamsar sarnyu manam lvkwngbv. Vbvritola krim pwklinyarlin rilokv vbvma. ");
INSERT INTO tgj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngo nonua minjidunv, vbvrikunamv nyi gunv atugv nywng nga nyi kvvbi gulo karbamla rimur moma gvrila kvvbi rimur lokv burmisulaku nw kvvbi nywng go naaku bolo hv rimur dukunv.” ");
INSERT INTO tgj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ninyigv lvbwlaksu vdwv ninyia minto, “So si nywng gvla nyilu gv pingkolo vbvridu bolo, nywng nyilubv naami summa nammv alvyari.” ");
INSERT INTO tgj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisu mirwkto, “So tamsar sarnam si nyichar mvnwng loma, vbvritola Pwknvyarnv gv um jinam vdwa mwng. ");
INSERT INTO tgj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nyi ngv ogulvgabv nyimv naala madunv ho gv lvkwng ngv akuaku sidunv: kvvgo nvnga nywngnyilu rinyu madubv bvnglinto; kvvbi gonv, nyi vdwv bunua vbv rimu rungdubv vla mvnammv; okv mvgonv nyidomooku Karv gv lvgabv nyimv naama nyadunv. Yvvdw so gv tamsar nama torwk sidunv ninyia vbv rimutvka. ");
INSERT INTO tgj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nyi mvgo vmi vdwa Jisu gvlo ninyigv laak v bunua mampo gvrila bunugv lvgabv kumji modubv vla aagv jito, vbvritola lvbwlaksu vdwv nyi vdwa yamtoku. ");
INSERT INTO tgj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisu minto, “Vmi vdwa ngoogvlo aamuto okv bunua mintor mabv, ogulvgavbolo nyidomooku gv Karv ngv svbv rinv vdw gvngv.” ");
INSERT INTO tgj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Vbvrikunamv nw ninyigv laak v bunu gvlo mampv jitoku okv vbvripikula vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lvko nvnga nyi go Jisu gvlo aala tvvkato, “Tamsarnv, turbwngnv singnam a paanam lvgabv, ngo ogualvnv ridung go rirung svgobvri?” ");
INSERT INTO tgj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisu mirwkto, “Alvnam gv lvkwngbv no nga ogubv tvvka dunv? Akin gomwng alv nvngv. No turnamlo aanvpv mvngdu nvlo Pwknvyarnv gv gamkinam gaam vdwa alvbv pvvlaka.” ");
INSERT INTO tgj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nyi angv tvvkato, “Ogu gamkinam?” Jisu mirwkto, “Gwngrw gwma bvka; nyimv rimur mabvka; dvcho mabvka; mvvlarula yvvnyika gungnying milwk mabvka; ");
INSERT INTO tgj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","noogv anvabua mvngdv laka; okv no atubongv oguaingbv paksu dudw vbv namrwk ajin a paklaka.” ");
INSERT INTO tgj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nyi angv mirwksito, “Ngo so gv gamkinam mvnwng sum ripvkunv, ngo ogugo rita svgo doopv?” ");
INSERT INTO tgj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisu ninyia minto, “No abwkalo nvgobv riso mvngbolo, vngla noogv ogumvnwng nga piokla morko nga heemanv vdwa ortoka vbvribolo no nyidomooku tolo nyitvyachok nvgobv rireku, vbvripikula aala nga vngming gvlakuka.” ");
INSERT INTO tgj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nyitvnv nyi angv vdwlo hum tvvtokudw nw mvngrula vngyu toku ogulvgavbolo nw achialvbv nyitvto. ");
INSERT INTO tgj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Vbvrikunamv Jisu ninyigv lvbwlaksu vdwa mintoku, “Ngo nonua milv jidunv: nyitvnv nyi v nyidomooku gv Karv tolo aanam lvgabv achialvbv aanyu manam gubv ridunv. ");
INSERT INTO tgj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngo mintin jidunv: nyitvnv nyi v Pwknvyarnv gv nyidomooku gv Karv lo aapvnam lvgabv aanyu manam gv hiru kaaya ngv kemel gv pwsi ungko lo ngwngpik tvvnam gv hirukaya nga kaiyadunv.” ");
INSERT INTO tgj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lvbwlaksu vdwv vdwlo um tvvtokudw, bunu achialvbv tvngarvnga nyatoku, “Vbvrikunamv, yvvkula ringnam a paajikunv,” vla bunu tvvka nyato. ");
INSERT INTO tgj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisu bunua kaagap jinjinla kaala mirwkto, “So si nyi gvbv choopu manam gubv ridunv, vbvritola Pwknvyarnv gvbv ogumvnwng ngv choopu dunv.” ");
INSERT INTO tgj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Vbvrikunamv Pitar mintoku, “Kaatoka” nw minto, “Ngonu ogumvnwng nga topu pikula nam vngming gvdu. Ngonu ogugo paari kudw?” ");
INSERT INTO tgj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisu bunua minto, “Nonuno paarung jinv ngv, vdwlo Nyia Kuunyilo ngv anw bv singtam gunv tolo ninyigv kairungnv Dvbv dooging lo doolwk rikudw, vbvrikunamv nonu ngoogv vring gola anyigo rigvnam vdwvkam dootare Israel gv haalung vring gola anyia rigvdogv dukubv. ");
INSERT INTO tgj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Okv yvvdw naam a achiboru vdwa, anyibormv vdwa, anvabua, umvuu vdwa, rongo vdwa ngoogv lvgabv kayu pikula vngyu dukunv, hv lwnggo lvvyago paatv dukunv okv turbwngnv singnam a jirung rikunv. ");
INSERT INTO tgj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Vbvritola megonv vjak yvv atukchobv ridunv, hv kochingreku okv megonv vjak yvv kochinglo ridunv, hv atokchoreku. ");
INSERT INTO tgj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Nyidomooku Karv ngv svbv ridunv. Kvvlo nyi ako ninyigv anggor rongo nga ridubv vla rwklap lapnv nyi makarla arukamchi bv vnglinto. ");
INSERT INTO tgj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nw bunua alu nyilap bv joobwngnam, raaji lokdwng chargo jidubv tolwk gvrila bunua rongolo vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nw lvkodv aru gv kia baji lo vngkur toku piokpamdorpam kolo, ho nw nyi mego ogurimabv doonv vkv kaapa toku, ");
INSERT INTO tgj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","vkvlvgabv nw bunua mintoku, ‘Nonu ka anggor rongo vlo vngla riteka, okv ngo nonua alu rwklap lapjoa jire.’ ");
INSERT INTO tgj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Vkvlvgabv bunu vngtoku. Vbvrikunamv nw alu gv gunta vring gola anyi lola okv arium gv gunta aom lola vbvdvdvbv minla nyi vdwa vngmuto. ");
INSERT INTO tgj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Arium gv gunta angu baji tvvtoku vdwlo nw piokpam dorpamlo vngla kvvbi nyi vkv vjaklodvbv hoka dakbwng nvgo kaapa toku. Nw bunua tvvkato, ‘Nonuno ogubv alu longa soka ogu rimabv anyubv doomin dunv?’ ");
INSERT INTO tgj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bunu mirwksito, ‘Ngonua yvvka minnv kaama,’ Vbvrikunamv, alvpv, nonuka anggor rongo vlo vngla riteka,’ vla nw bunua mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Vdwlo arium tokudw, rongo atuv rongo rigv nvnga mintoku, ‘Rwklap lapnv vdwa goklwkla bunugv alu nyilap lapjo nga jooto kuka, goknyung yanam lokv jirap laila gokcho yanam lobv jila jime tokuka.’ ");
INSERT INTO tgj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gunta angu baji lo aalwk mwngla rinv vdwa raaji lokdwng charsak go jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Vkvlvgabv gokcho yachoknam nyi vdwa aamu gvrila jootv tvri ho, bunu mvngtoku bunu kaiyago paari nvpv vla; vbvritola bunuaka raaji lokdwng charkin sakgo jimwng toku. ");
INSERT INTO tgj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bunu bunugv morko nga naatokula rongo atua bvdur-bvdurbv japria nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘So nyi vdw si goknyung yanammv gunta akin gomwng rongo rinam v,’ vla bunu minto, ‘ngonu doonyi v hila madubv rila rekwng gvvre—vbvritola no bunua ngonua jinam apiabv jigvre!’ ");
INSERT INTO tgj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Tvvriato, ajin,’ rongo atuv mirwksito, bunugv lokv akonyi, ‘Ngo nonua rikup mapvnv. Minjvjvbolo, nonu alu nyilap a raaji lokdwng chargobv tolwk minsupvnv. ");
INSERT INTO tgj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nonu vjak nonugv alu nyilap a naalaikula naambv vngnyikuka. Ngo koching yachokbv ngoogv goklwk kunam nyi so, nonua jinam apiabv jirung tvdunv. ");
INSERT INTO tgj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngo atubogv morko nga mvnggwngbv mvnyu madu nvlare? Vmalo ngo jipu nvgobv rinam lvgabv nonuno tanyum gvvria doi?’” ");
INSERT INTO tgj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Okv Jisu minyabv mintoku, “Vkvlvgabv yvvdw atokchochuk yabv ridunv hv koching yabv rireku, okv yvvdw koching yabv ridunv, hv atokchochuk yabv rireku.” ");
INSERT INTO tgj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Vbv Jisu Jerusalem bv chaadungla charilo, nw lvbwlaksu vring gola anyia akusubv naarwsito okv bunu lamtvlo vngdung dula nw bunua minsila minto. ");
INSERT INTO tgj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tvvriato,” vla nw bunua minto, “Ngonu Jerusalem bv chaadungdo hoka Nyia Kuunyilo nga Nyibu butvnv vdwgv okv Pvbv tamsarnv vdwgv laak lo ninyia laklwk riku. Bunu ninyia miyakaayala mvkidubv minreku. ");
INSERT INTO tgj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Okv vbvrikunamv ninyia Jentail vdwgvlo laklwk reku, bunu ninyia nyarjikau riku, svnyak pareku, okv daapo lo ninyia takki reku; vbvritola alu loom kochinglo nw turkur reku.” ");
INSERT INTO tgj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Vbvrikunamv Jibedi gv nywng ngv kuunyilo anyia aagvla Jisu gvlo aato, ninyigv kaagialo gubwngla ninyia akusubv mvngkiamnam go kooto. ");
INSERT INTO tgj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisu ninyia tvvkato, “No ogugo mvngpvla?” Nw mirwkto, “No vdwlo Dvbv bv riku bolo ngoogv kuunyilo anyi sum noogv lakbik tangvlo akonyi okv lakchi tangvlo akonyi doomure vla, no ngam milv jilabvka.” ");
INSERT INTO tgj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisu kuunyilo anyia mirwkto, “Nonu ogugonyi koodunvbvre ho lvga nga nonu chima.” “Nonuno ngoogv hinching koobu tvngji nama, tvngla redw?” Bunu mirwkto, “Um, ngonu tvnglare.” ");
INSERT INTO tgj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jisu bunua mintoku, “Nonuno tvngnam gvbv ngoogv koobu lokv tvnglare, vbvritola ngoogv lakbik okv lakchilo dooji nvnga dardubv ngoogvlo kaama. So dooku vdwsi ngo Abu gv mvpvripv jikunam bunu vdw gvngv.” ");
INSERT INTO tgj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Vdwlo kvvbi lvbwlaksu vdwv hum tvvpa pvkudw bunu achiboru anyia haachi nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Vkvlvgabv Jisu bunu mvnwngnga goklwk toku okv mintoku, “Nonu chindu Jentail vdwa rigvdogvnv vdwv bunua rigvdogvnv lanv jwkrw doodunv, okv rigvdogvnv vdwv tujupkunam gubv rinya dukunv. ");
INSERT INTO tgj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Svbvrinam aingbv nonu gvlo doorung moyoka. Nonu gvlokv akonv kainvgobv riso mvngbolo, hv mvnwng gv pakbu bv rirunglaka; ");
INSERT INTO tgj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","okv nonu gvlokv akonv atokcho yaso mvngbolo, hv kvvbi vdwgv nyirabv rirunglaka— ");
INSERT INTO tgj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nyia Kuunyilogv jvbv, nw rijikodubv aama vbvritola nw riji yagv rila okv nyi achialvgo ringlin kunam lvgabv nw atubogv gv svngtung nga mvngnga siyadunv.” ");
INSERT INTO tgj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisu la ninyigv lvbwlaksu vdwv Jeriko nga vngyu rikulo nyitwng go bunua vngming gvto. ");
INSERT INTO tgj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nyikchingnv nyi anyigo lamtv hoka doonv Jisu vngpit rikv vla tvvpato, vkvlvgabv bunu gokrap toku, “Dabid gv Kuunyilo nga! Tamsarnv, ngonua aya mvngpa labvka!” ");
INSERT INTO tgj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nyitwng ngv bunua choibvkv vla mintoku. Vbvritola bunu kaiyayabv gokto, “Dabid gv Kuunyilo nga! Tamsarnv, ngonua aya mvngpa labv!” ");
INSERT INTO tgj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisu daktung toku okv bunua goklwk toku. Nw bunua tvkatoku “Nonu nga nonugv lvgabv ogugo rijilabv vla mvngpv?” ");
INSERT INTO tgj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bunu mirwksutoku, “Tamsarnv, Ngonu nam ngonugv kaapa nvnv nvnga jilabvkv vla mvngdunv!” ");
INSERT INTO tgj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisu bunua aya mvngpa toku okv bunugv nyik a mvsit jitoku; Vjakgobv bunugv nyikkv kaapa nyutoku, okv bunu ninyia vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisu la ninyigv lvbwlaksu vdwv Jerusalem vngchi dvlvbv rito, bunu Betpej gv Olib Moodw lo aatoku. Hoka Jisu lvbwlaksu anyi gonyi vngcho moto ");
INSERT INTO tgj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","svbv mingvrila: “nonugv vnglwkjiku nampum vlo vngnyika, okv Vjakgobv nonu hoka siak go kuu nga lvkobv takpv namgo kaapare. Um nonu paksoklaila ngoogv dookuso boolwk tvka. ");
INSERT INTO tgj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Okv nyi gunv ogugo minbolo, ninyia ‘Ahtu sum dinchidu,’ vla minlaka; okv vbvminku bolo hv vjakgobv bunua boomu reku.” ");
INSERT INTO tgj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Svbvrinam si nyijwk gv ogugo minpv nama jvjv modukubv ritoku: ");
INSERT INTO tgj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jayon gv pamtv nga minji teka, Kaatoka, nonugv Dvbv ngv nonu gvlo aarikunv! Nw nyanyak nvgo okv nw siak kuu nyi riokw manv gv aolo dootola.” ");
INSERT INTO tgj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Vkvlvgabv lvbwlaksu vdwv vngla Jisu gv bunua ritokv vnam a riji toku: ");
INSERT INTO tgj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","bunu siak hala okv hvkvgv kuu nga boolwk jitoku, bunugv jekok ka ho pipv jitoku okv Jisu gecha toku. ");
INSERT INTO tgj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Twngtv rungnv nyipam go bunugv jvkok ka lamtvlo pipv jinya toku, okv kvvbi vdwv singnv vdwlokv hakbv paalin nyala lamtvlo pipv jinya toku. ");
INSERT INTO tgj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nyipam v Jisu gv kokwng habobv vngkar nyato ho vngkarnv vdwv gokrap nyato, “Dabid gv Kuunyilo nga hartv nyato! Ahtu gv amin bv aanv sum Pwknvyarnv ninyia aya jirung laka! Pwknvyarnvnyi hartvdu!” ");
INSERT INTO tgj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Vdwlo Jisu Jerusalem lo aalwk tokudw, pamtv gv nyi mvnwngngv chikchakyayak bv ritoku. Nyi vdwv tvvkato, “Si yvvla?” ");
INSERT INTO tgj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nyipam v mirwkto, “Si Galili gv Najaret lokv nyijwk Jisu kv,” ");
INSERT INTO tgj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisu Pwknvyarnvnaam lo aatoku okv hoka pioknv rvvnv vdwa mvyakmvchak jitoku. Nw morko lwkko lwkpiknv tvbul am, okv taakw pioknv gv dooging ngaaka dutap durap mvji toku, ");
INSERT INTO tgj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","okv bunua mintoku, “So si Darwknv Kitaplo lvkpvdo hoka Pwknvyarnv mindu, ‘Ngoogv Pwknvyarnvnaam a kumkunaam bv vdunv.’ Vbvritola nonuno sum dvcho nvgv tosi siging kobv mvpv!” ");
INSERT INTO tgj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nyikchingnv okv lvpiknv ho Pwknvyarnvnaam arwng hoka nw gvlo aanya toku, okv nw bunua mvpu toku. ");
INSERT INTO tgj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nyibu butvnv vdwv la okv Pvbv tamsarnv vdwv Jisu gv lamrwpadubv mvnam rinam a kaala okv vmi vdwgv “Dabid gv Kuunyilo nga hartvdu” vla goknam a tvvla haachi nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Vkvlvgabv bunu Jisunyi tvvkato, “Bunugv ogugo minam a no tvvpa dunvre?” “Tvvnam gvbv ngo tvvpadu,” vla Jisu mirwkto. “Nonuno Darwknv Kitap so vdwloka puri rikw mapvi? ‘Nonu vmi vdwala okv anga vdwa risarrima la alvyaungbv hartv modubv ripv.’” ");
INSERT INTO tgj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisu bunua vngyula okv Betani pamtv lo vnglinlaku, hoka nw ayu yuplwk toku. ");
INSERT INTO tgj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nw gv pamtv bv vngkur rikulo, logo nvgv arukamchi lamtv hoka Jisu kano toku. ");
INSERT INTO tgj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nw lamtv adar hoka koksitkokrik singnv nvgo kaapala ho aalwk toku, vbvritola ogu guka kaapama anvv vmwng. Vkvlvgabv nw singnv nga minto, “No vdwlo lvkoka asi svvlin kumare!” singnv nvngv vjakgobv sinyuk toku. ");
INSERT INTO tgj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lvbwlaksu vdwv hum kaatokula tvngarvnga nyatoku. Bunu tvkato, koksitkokrik singnv ngv vjakgobv oguaingbv sinda yinv gubvri?” ");
INSERT INTO tgj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisu mirwkto, “Ngo nonua jvjvbv midunv, vdwlo nonu mvngsarmanam go kamabv mvngjwng bolo, nonu ka rilare ngoogv so koksitkokrik singnv nga rinam aingbv. Okv svbv mwngchikma, vbvritola nonu vbvka so gv moodw a minyure, ‘Gudungla no atuv svmasa bolo orlwksuto vbolo,’ hv vbv rijire. ");
INSERT INTO tgj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nonuno mvngjwng bolo, nonu ogugo kumla koopvdw um paare.” ");
INSERT INTO tgj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisu Pwknvyarnvnaam lo aakur toku; okv ninyigv tamsar rilo, nyibu butvnv vdwv, nyigagaatv vdwv nw gvlo aala tvvkato, “No ogubv mvngla so vdw sum rimin dunv? Nam svbv rila dubv yvvla tujupkunam a jinv ngv?” ");
INSERT INTO tgj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisu bunua mirwkto, “Ngo nonua gaamgo tvvkare, okv nonuno nga mirwk bolo, ngo ka so vdw sum ogubv rila dunvdw um ngo nonua minjire. ");
INSERT INTO tgj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon gv baptisma jinammv ogolokv aapvnv: hv Pwknvyarnv gvlokv aapv nvri vmalo nyi gvlo kri?” Bunugv aralo larrap minsuto, “Ngonu ogugo mirwksidubv? Ngonu Pwknvyarnv gvlokv, vla mirwk bolo, nw ngonua minre, vbvrinamv, ogulvgabv nonu Jonnyi mvngjwng mapvnv?” ");
INSERT INTO tgj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Vbvritola ngonu ‘Nyi gvlokv’ vla minse ngaaka busudo, ogulvgavbolo mvnwngngv Jonnyi nyijwk akobv mvngnya dukunv.” ");
INSERT INTO tgj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Vkvlvgabv bunu Jisunyi “Ngonu chimakv” vla mirwk toku. Okv nw bunua mintoku, “Ngooka nonua minjimare ngo so vdwsum ogubv rila pvnvdw.” ");
INSERT INTO tgj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Vjak, nonuno ogugo mvngdu? Ho hoka nyi ako dooto, hv kuunyilo anyigo dooto. Nw achiyagv dookulo aala okv minto, ‘Kuunyilo, silu no anggor rongo vlo vngla riteka.’ ");
INSERT INTO tgj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Ngo vngnwng ma,’ vla hv mirwkto, vbvritola koching so hv mvngdin lakula vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Vbvrikunamv abu angv kuunyilo gunvlo vngla vbvdvdvbv mintoku. ‘Tamsarbo, vkv vla mirwkto, vbvritola nw vngmato. ");
INSERT INTO tgj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yvvla anyi lokv abu gv mvnglwkbv rinv angv?” “Achi ya angv,” vla bunu mirwkto. Vkvlvgabv Jisu bunua mintoku, “Ngo nonua minjidunv: Lampu naayanv okv yookar nvngv nonua Pwknvyarnv gv Karv tolo vngchoyare. ");
INSERT INTO tgj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon nonu gvlo aala alvnv lamtv nga naamu dubv kaatam jitoku, okv nonuno ninyia mvngjwng mato; vbvritola lampu naayanv vdwv okv yookarnv vdwv ninyia mvngjwng toku. Okv um nonu kaagv rilaka, nonu koching so ka mvngdin nyama okv ninyia mvngjwng kuma. ");
INSERT INTO tgj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisu minto, “Kvvbi minchisinam godv tvvrianyato. “Kvvlo gwngda mooku atu go dooto, nw anggor rongo go mvlwkto, hum svlung rakyumto, anggor nyumjik dubv ungrung ako dupv toku, okv kaaria nvdubv aokoloknv taabio go mvtoku. Vbvrikunamv nw anggor rongo nga rwktin tinlwk pikula adubv moing vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Vdwlo anggor naakumdwv aato kudw, nw ninyigv nyira vdwa rwktin vdwgvlo anggor naakum kunamha ninyigv baak am naarwk modubv vla vngmuto. ");
INSERT INTO tgj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Rwktin vdwv ninyigv nyira nga naatung toku, akonyi dvngto, kvvbia mvkito, okv kvvbi gunyi vlwng orkito. ");
INSERT INTO tgj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Lvkodv nyi angv nyira vngmuto, vngcho monam vdwa kaiyanv go, okv rwktin vdwv ho vdwaka vbvdvdvbv mvritto. ");
INSERT INTO tgj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ataranya ngaku nw ninyigv kuunyilo nga bunu gvlo vngmu toku. Nw mintoku, “Bunu ngoogv kuunyilo nga jvjvbv mvngdv yiku nvpv.” ");
INSERT INTO tgj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Vbvritola rwktin vdwv vdwlo kuunyilo nga kaapa tokudw, bunu mimi sunyato, ‘Si atu gv kuunyilo ngv, klai mvki laju ninyia, okv ngonu ninyigv yikungyira nga paadu kubv!’ ");
INSERT INTO tgj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Vkvlvgabv bunu ninyia naatungla anggor rongo agum bv dvlin la okv mvki toku. ");
INSERT INTO tgj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisu tvvkato, “Vjak, vdwlo anggor rongo atuv aarikunyi ho rongo rwktin vdwa ogubv mvri kudw?” ");
INSERT INTO tgj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bunu mirwksito, “Nw jvjvbv ho nyi alvmanv vdwa mvki reku, okv anggor rongo nga naala kula ninyigv paasv nga jidw lo jilwk jikunv kvvbi rwktin lo tinlwk reku.” ");
INSERT INTO tgj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisu bunua minto, “Darwknv Kitaplo ogugo minpvdw um nonu vdwloka puri rikw mapv nvri? ‘Naam mvnv vdwgv arin kaama vla toa kunam vlwng ngv mvnwngnga arin doyachoknv gubv ritoku. So si Ahtu gv riku namv; si achialvbv kaasartabo rungnv goku!’ ");
INSERT INTO tgj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Okv vkvlvgabv ngo nonua minjidunv,” Jisu mindvjito, “Pwknvyarnv gv Karv nga nonu gvlo konga naalakula okv alvbv apwasi svvlin jikunv nyi vdwlo jireku.” ");
INSERT INTO tgj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yvvdw so vlwng aolo lo hopv rinv hv atung ayung reku; okv vlwng angv akonvgv aolo hopv ridw hum amwkamak dubv mvreku. ");
INSERT INTO tgj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nyibu butvnv vdwv la okv parisis vdwv Jisu gv minchisila minam a tvvtokula nw bunugv lvkwng nga mindu nvgo vla tvvchin nyatoku, ");
INSERT INTO tgj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","vkvlvgabv bunu ninyia naatung dubv rikwto. Vbvritola bunu nyitwng nga busu nyato, ogulvgavbolo nyitwng ngv Jisunyi nyijwk gubv mvngnyato. ");
INSERT INTO tgj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisu minchisinam lokv minvla nyi vdwa minto. ");
INSERT INTO tgj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Nyidomooku gv Karv ngv svbv ridunv. Kvvlo dvbv ako dooto, nw ninyigv kuunyilo gv lvgabv nyida dvpam go pamgvto. ");
INSERT INTO tgj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nw ninyigv pakbu vdwa nyi goknam vdwa dvpam lo aalwk tokukv vla minpa modubv vngmu toku, vbvritola nyi goknam vdwv bunu aalwk nwngma toku. ");
INSERT INTO tgj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Vkvlvgabv nw kvvbi pakbu gunyi nyi goknam vdwgv lvgabv svbv gaam milwk gvrila vngmu toku: ‘Ngo dvpam gv dvnamtvngnama vjak mvpvripv pvkunv; ngoogv svbv svv ngaaka dintwkbv twkpv pvkunv, okv ogumvnwng nga mvpvripv pvkunv. Nyida dvpam lo aalwk nyala kukv!’ ");
INSERT INTO tgj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Vbvritola nyi goknam vdwv um tvjvkamv nyato okv bunugv pwsepaase lvkwnglo vngnya toku: akonv nw gv rongolo vngtoku, kvvbiv ninyigv dukan lo, ");
INSERT INTO tgj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","kvvbi gunv pakbu vdwa twkbwng gvrila dvngla, okv bunua mvki nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Dvbv ngv achialvbv haachi toku; vkvlvgabv nw ninyigv sipai vdwa vngmutoku, bunu vngla gwngrw gwnv vdwa mvki toku okv bunugv pamtv nga ramyok jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Vbvrikunamv nw ninyigv pakbu vdwa goklwkla bunua mintoku, ‘Ngoogv nyida dvpam a vjak mvpvripv pvku, vbvritola ngoogv nyi goknam vdwv sum aala dvyin nvbv rima. ");
INSERT INTO tgj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nonu vjak namrwk pinkobv vngnyila nyi kaapanv dvdv nga goktv kuka.’ ");
INSERT INTO tgj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Vkvlvgabv pakbu vdwv namrwk vdwgv pingkobv vngla bunugv nyi kaapanam mvnwngnga alv jvka alv majvka gokkumto; okv nyida naam lo nyi vdwv yarbing toku. ");
INSERT INTO tgj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Dvbv ngv nyi goknam vdwa kaabv vngtoku, nw nyi ako nyida vji kooma nvgo kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Ajin, no nyida vji koomabv oguaingbv so aapvnv?’ Vla dvbv ngv ninyia tvkatoku. Vbvritola nyi angv oguka mirwk simato. ");
INSERT INTO tgj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Vbvrikunamv dvbv ngv pakbu vdwa mintoku, ‘Ninyia lvpa okv laakka leetoka, okv agum gv kanv kolo orlwk tvkuka. Hoka nw ninyigv hijung nga kotwkkrwkla kapla dooreku.’” ");
INSERT INTO tgj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Okv Jisu minyabv mintoku, “Mvnwngnga gokpv, vbvritola darnamv miang gomwng.” ");
INSERT INTO tgj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Vbvrikunamv Parisis vdwv vngyu laku okv Jisunyi tvunam lokv tvgvrikula kupdubv vla rungtoku. ");
INSERT INTO tgj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Vbvrikunamv bunu nw-bunugv lvbwlaksu mego okv Herod gv nyi vkv Jisu gvlo vngmu toku. Bunu vngla minto, “Tamsarnv, ngonu chindu no jvjv nga mindu. No nyi gv lvgabv Pwknvyarnv gv jvjvnv mvngnam lvkwng nga tamsardu, nyi vdwv ogugo mvngdudw hum chigamrai madu, ogulvgavbolo no nyi gv kai miang nga kimado. ");
INSERT INTO tgj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Vbvrikunamv, no ogubv mvngdu, ngonugv Roman Dvbvyachoknyi lampu jinam si ngonugv Pvbv nga rinying dunvri ma rinying madunvre? ");
INSERT INTO tgj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisu, ogubv rijvka bunugv alvmabv rungnam a chintoku, okv vkvlvgabv nw minto, “Kaakudvbv rinv nonu! Nonu ogulvgabv nga kupdubv rikw nyadunv? ");
INSERT INTO tgj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Lampu jise lokdwng nga kaatam labv!” Bunu lokdwng chargo nw gvlo bvnglwk jito, ");
INSERT INTO tgj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","okv nw bunua tvvkato, “Si yvvgv nyukmu ngvla aminv?” ");
INSERT INTO tgj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bunu mirwk suto, “Dvbvyachok gv.” Vkvlvgabv Jisu bunua minto, “Alvdo, vbvrinamv, Dvbvyachok gvnga Dvbvyachoknyi jilaka, okv Pwknvyarnv gv-nga Pwknvyarnvbv jilaka.” ");
INSERT INTO tgj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Vdwlo bunu sum tvvtokudw, bunu lamngak toku; okv bunu ninyia kayu pikula vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nyi si sitokula lvko turkur kumadunv vla minv Sadusis mego ho alu Jisu gvlo aato. ");
INSERT INTO tgj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Bunu minto, “Tamsarnv, Moses minto, nyi gunv umvuu doomabv sikubolo, ninyigv boruv hvngmi nga doogv gvrila sinv hvkv gvbv umvuu bvngji molaka hvto. ");
INSERT INTO tgj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Vjak, achiboru kanw go soka doodung nvgo. Achi yachok angv nyimv naatoku okv umvuu dooma dwbv sitoku, vkvlvgabv ninyigv hvngmi nga hvkvgv boru hv nywng mvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Vbvdvdvbv boru anyi nvnv loka ritoku, aom nvnv loka, okv Anyungnga achiboru kanw mvnwnglo. ");
INSERT INTO tgj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ataranya ngaku mvvga nvngv sitoku. ");
INSERT INTO tgj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Vjak, sinv vdwv turkur alulo, nyimv nvngv yvvgv nywngbv rireku? Mvnwngngv ninyia nywngbv mvpvkunv.” ");
INSERT INTO tgj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisu bunuam mirwkto, “Nonu achialvbv mvngmurdu! so si ogulvgavbolo nonuno Darwknv Kitap a vmalo Pwknvyarnv gv jwkrw nga chimanam lvgalo. ");
INSERT INTO tgj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sinv ngv vdwlo turkur rikunyi, bunu nyidogindung jvbv ridunv nyimv nyilo bv naami siku madunv. ");
INSERT INTO tgj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Vjak, sinv ngv turkurkunam sum: Pwknvyarnv gv nonua minpv jinam a nonuno lvkoka puri rikw mai? Nw minto, ");
INSERT INTO tgj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ngo Abraham gv Pwknvyarnv ngv, Isaak gv Pwknvyarnv ngv, okv Jakop gv Pwknvyarnv ngv.’ Nw turnv vdwgv Pwknvyarnv ngv, sinv gvngvma.” ");
INSERT INTO tgj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Vdwlo nyipam v sum tvvtokudw, bunu ninyigv tamsar nama tvvla lamngak nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Vdwlo Parisis vdwv Jisu Sadusis vdwa choi dubv mingvnyibv vnam a tvvpa tokudw, bunu aakum nyatoku, ");
INSERT INTO tgj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","okv bunugv lokv akonv, Pvbv tamsarnv ako Jisunyi tvunam go tvvgv rila mingkup dubv vla rikwto. ");
INSERT INTO tgj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Hv Jisunyi tvvkato, “Tamsarnv, Gamkinam gv aralo ogolo angv gamlo yachokkv?” ");
INSERT INTO tgj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisu mirwkto, “‘Pwknvyarnvnyi paklaka, noogv Pwknvyarnvnyi, no gv haapok raying lokv, no gv yalu mvnwng lokv, okv no gv mongrumara mvnwng lokv.’ ");
INSERT INTO tgj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","So si kaiyachoknv okv dinchi yachoknv Gamki namv. ");
INSERT INTO tgj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Anyinvbv gamlo yachokkv si: No atubongv oguaingbv paksu dudw vbv namrwk ajin a paklaka.’ ");
INSERT INTO tgj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses gv Pvbv mvnwng ngvla okv nyijwk mvnwng gv minam v so gv Gamkinam anyi gv arwnglo doodunv.” ");
INSERT INTO tgj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Vdwlo Parisis mego aakum nyato kudw, Jisu bunua tvvkato, ");
INSERT INTO tgj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nonuno Kristo gv lvkwng nga ogubv mvngdu? Nw yvvgv husi bv ridunv?” “Nw Dabid gv husi bv ridunv,” vla bunu mirwkto. ");
INSERT INTO tgj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisu tvvkato, “Vbvrinamv, ogulvgabv Dabidnyi Dow hv ninyia Ahtu vla mimu pvnv? Dabid mintoku, ");
INSERT INTO tgj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ahtu ngoogv Ahtunyi minto: Ngo no gv nyimak vdwa no gv lvpa lvkwnglo pvma dvdvlo ngoogv lakbik tangv so dootoka.’ ");
INSERT INTO tgj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Vbvrinamv Dabid ninyia ‘Ahtu’ vla minpv bolo, oguaingbv Kristo Dabid gv husi bv ridubv?” ");
INSERT INTO tgj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jisunyi yvvka gaam gamgo ka mirwk nyuma toku, okv ho alu lokv yvvka Jisunyi tvu dubv choopu nyuma toku. ");
INSERT INTO tgj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Vbvrikunamv Jisu nyitwng ngala okv ninyigv lvbwlaksu vdwa mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pvbv tamsarnv vdwv la okv Parisis vdwv Moses gv Pvbv nga miriadubv tolwkkunam vdwvku. ");
INSERT INTO tgj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Vkvlvgabv nonuno bunugv ritokv vla minam a tvvrung tvka; vbvrijvka, bunugv rinam a rimwng gvyoka, ogulvgavbolo bunu oguaingbv japdudw vbv bunu rima. ");
INSERT INTO tgj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bunu nyi vdwgv nangkulo ai ngv baknyu madubv baknam go mvlwk jido, ho gv bakjinama baknam lvgabv bunu ridur dubvka lakching ngvka chikka madu. ");
INSERT INTO tgj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bunugv rinam minam mvnwngngv nyi vdwa kaakudubv vla rinam gomwng. Kaatoka bunu darwknv Kitap lokv akor a chartv dubv lvktola atubogv toktam lo lvngbwnglo gvnam a, okv kaadvtvka vji jenyam a asukoyo dubv gvnam a.” ");
INSERT INTO tgj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bunu dvpam tvngpam lo alvyachoknv dooku a doonwng nyadu okv Jius kumkunaamlo dooku a atu tola gakchodu; ");
INSERT INTO tgj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bunu bajar lo mvngdvla salaam mvrwk konwng do okv “Tamsarnv” vla mingku nwngdo. ");
INSERT INTO tgj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nonuv “Tamsarnv” vla mirung mase ngv, ogulvgavbolo nonuv tamsarnv akin gomwng doodu okv nonu mvnwngngv achiboru hvku. ");
INSERT INTO tgj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Okv nonuno sichingmooku so yvvnyika ‘Abu’ vla miyoka, ogulvgavbolo nonugv abuv akin gomwng nyidomooku tv doodunv. ");
INSERT INTO tgj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Vmaloka nonuno ‘Rigvdakgvnv’ vlaka minse mangngv ogulvgavbolo nonugv rigvdakgvnv Kristo akin mwng. ");
INSERT INTO tgj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nonu mvnwng lokv yvv kaiyachokbv ridunv, hv miang nvgobv rirunglaka. ");
INSERT INTO tgj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yvvdw atubongv kainvgobv mvsu dunv, hv miang nvgobv rire, okv yvvdw atubongv miangbv mvngsudunv, hv kainvgobv rireku. ");
INSERT INTO tgj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Vdwnvgo achialvbv mvngru runam gubv rirekunv, Pvbv tamsarnv okv Parisis kaakudubvrinv nonu lo! Nonu nyi vdwgv kaagialo nyidomooku gv Karv nga mvtum nvngv, okv nonu atuv aama gvri okv nyi v aadu bv vla rikw nvnga ka aamu magvri! ");
INSERT INTO tgj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Pvbv tamsarnv okv Parisis kaakudubvrinv nonu achialvbv mvngru runam gubv rire! Nonu hvngmi vdwa riging nvminla okv bunugv naam nesung nga dvritpaapi jila, okv kumrinyi tvvpa modubv vla asu dubv kumla! vbvrinam lvkwngbv nonugv hirukaya hinse ngv achialvbv alvmanv gubv rireku! ");
INSERT INTO tgj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Pvbv tamsarnv okv Parisis kaakudubvrinv nonu achialvbv mvngru runam gubv rire! Nonu nyi ako naalwkkunam lvgabv svmasa vdwa durapla okv mooku mvnwngnga vngbo nyala; okv vdwlo hum rijik rikudw, nonu bunua lvnyi yago uyumooku bolo vngmu dubv mvyadu, nonu atubongv bolo vngrung jinv aingbv! ");
INSERT INTO tgj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kanvpvram lo vnggvnv nonu, achialvbv mvngru runam gubv rire! nonu tamsardo, ‘Yvv akonv Pwknvyarnvnaam lo milv mvngdunv, hv ogu arin kaama, okv yvvdw ain nam Pwknvyarnvnaam lo bvnglwkla milv dunv, hv milvnam lo doorung dunv’ vla. ");
INSERT INTO tgj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nyikchingnv nonu! ogulo angv dinchiyanv, ain vri vmalo ain nam darwk dubv mvnv yugwng yangvri? ");
INSERT INTO tgj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nonu vbvka tamsardu, ‘Yvvnyi gonv Pwknvyarnvnaam lo amin bvnglwkla milv dunv, hv milvvnam gv anyung kaama; vbvritola nw amin go bvnglwkla milv dubolo hv milv namgv anyung doodunv.’ ");
INSERT INTO tgj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Achialvbv nyikchingnv nonu! ogulo angv alvyanv, amin vri vmalo amen nam darwk monv yugwng vri? ");
INSERT INTO tgj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Vkvlvgabv vdwlo akonv Pwknvyarnvnaam lo milv rikudw, nw hum okv ho gv doonv amin mvnwng ngaaka milv dukunv; ");
INSERT INTO tgj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","okv vdwlo nw Pwknvyarnvnaam lo milv rikudw, nw Naam haka okv hoka doonv Pwknvyarnv nyika milv dukunv; ");
INSERT INTO tgj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","okv vdwlo yvv nyidomooku a milv nvbolo, nw Pwknvyarnv gv dooging nga okv ho doonv nw nyika milv dukunv. ");
INSERT INTO tgj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Pvbv tamsarnv okv Parisis kaakudubv rinv vdw nonu achialvbv mvngru runam gubv rire! nonuno pwnampaanam lokv miangjeka vring lokv akin jinam a jibwng gvri, nonunogv nayam lokv ujiuu miang nvnga ka, vbvritola nonu pvbv lokv dinchi nvnga rimadu hv minkiam miriam manam, aya minsunam, okv alv minsunam, sum nonu rirung svngv, akonyika kayu mabv. ");
INSERT INTO tgj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kanvpvram lo vnggvnv nonu! Nonu nonugv tvngku lokv tanyik jarlwk nvnga naala naa gvri, vbvritola kemel go dvmit gvri! ");
INSERT INTO tgj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Pvbv tamsarnv okv Parisis kaakudubvrinv vdw nonu achialvbv mvngru runam gubv rire! Nonu nonugv taali koobu gv agum a harkak do, vbvritola arwng ngv mvvnamrunam mv okv atu mvngwngbv rimin kunam mv awyaje duku. ");
INSERT INTO tgj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nyikchingnv Parisi nonu! Koobu arwng nga kakcho tvka, okv vbvrikubolo agum hvka darwk minggv riku! ");
INSERT INTO tgj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Pvbv tamsarnv okv Parisis kaadubv rinv, nonu achialvbv mvngru runam gubv rire! nyibung nga tanu piaknam jvbv ridu, hv agum hv kaarinyi kaapudo vbvritola arwng ngv svma alo ako ngvku yaaku nvngv doodu. ");
INSERT INTO tgj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hvkv aingbv, nonu agum lo mvnwngnga alv nvgubv kaatamdo, vbvritola arwnglo nonuno tanyumtaa ngv rimur doomur v awyaje duku. ");
INSERT INTO tgj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Pvbv tamsarnv okv Parisis, kaakudubv rinv nonu achialvgo hirukaya hinre! Nonu nyijwk vdwgv lvgabv alvnv nyibung mvdu okv nyi alvbv svngto kula sinv vdwgv nyibung ngaaka kaapu alvbv kaau pvvnamgo mvdu. ");
INSERT INTO tgj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Okv nonuno mindu, nonu nonugv abuapa vdwgv doori ho doonv guilo, bunugv rinam aingbv nyijwk vdwa gwngrw gwma dunvpv. ");
INSERT INTO tgj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Vkvlvgabv nonuno nyijwk vdwa gwngrw gwnv gv husi gubv minduku. ");
INSERT INTO tgj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Vbvrikunamv, vngnyila nonugv abuapa gv rirap kunam a rime tvkuka! ");
INSERT INTO tgj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tabw nonu okv tabw vdwgv umvuu vdw nonu! Nonuno oguaingbv miyakaya nama paala uyumooku bolo ima rinvpv vla dvmin dunv? ");
INSERT INTO tgj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Okv vkvlvgabv ngo nonua hum minpa jidunv, ngo nonu gvlo nyijwk vdwa vngmure okv chinv mvngnv vdwa okv tamsarnv vdwaka; nonu bunua kvgonyi mvkire, kvgonyi daapo lo takire, okv kvgonyi Jius kumkunaamlo svnyakpare, okv bunua banggu lokv banggu gunvlo charare. ");
INSERT INTO tgj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Vbvrikunamv, alvnv nyi mvnwngnga gwngrw gwnv vdwa mvritririt svngv nonu gvlo doolwkre, alvnv Abelnyi gwngrw gwnam lokv naalayila Berukia gv kuunyilo Jakarianyi nonugv Pwknvyarnvnaam gvla yugwng gv pingko lo gwngrw gwkunamv. ");
INSERT INTO tgj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngo minam gvbv nonua jvjvbv minpa jidunv: So gwngrw gwnv mvnwngnga mvritririt svngv vjakgv nyi vdwlo doolwk rikunv! ");
INSERT INTO tgj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Nonu nyijwk vdwa mvkito okv Pwknvyarnv gv nonu gvlo gindungpingko vngmunam vdwa nonu vlwng orkito! Vdwnvgo ngo noogv nyi mvnwngnga laakhv laakyum dubv ridukubv, poruk roknv gv ruu vdwa ninyigv laap lokv lapyumnam aingbv, vbvritola nonu ngam vbv rimuma! ");
INSERT INTO tgj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Okv vkvlvgabv nonugv Pwknvyarnvnaam ma toapagga laku oguka dooku mare. ");
INSERT INTO tgj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Vjakgv lokv rila, ngo nonua mindunv, vdwlo nonu, “Ahtu gv amin lokv aanv nga Pwknvyarnv boktalwkji laka” vla mima dvdvlo, nonu nga vdwloka lvkodv kaapa kumare. ");
INSERT INTO tgj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisu Pwknvyarnvnaam ma vngyula vngrilo ho ninyigv lvbwlaksu vdwv aala ho gv naam vdwa kaakw tvkv vla ninyia mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Umkv” vla nw minto, “Nonu so mvnwng sum kaanammv alv rungpv. Ngo so nonua minpa dunv: So gv vlwng pwgoka dooku lo doobwng kumare; bunu mvnwngnga ngorlula ngorra rikunv.” ");
INSERT INTO tgj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisu gv Olib moodw lo dootung rilo, lvbwlaksu vdwv aasila nw gvlo aatoku. Bunu ninyia minto, “Ngonua minpalabv, vdwlo so minam vdw si ritv tvdunv, okv noogv aadw hvku okv so si sichingmooku gv ataranya aluv vla kaachin dubv ogugo ritv tvdunv.” ");
INSERT INTO tgj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisu bunua mirwkto, “Nonuno hima kaaya sutoka, yvvnyika mvvkup rikup koyoka. ");
INSERT INTO tgj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nyi achialvgo, ngam mingingnv vdwv, aare okv minre, ‘Ngoonv Kristo!’ okv bunu nyi achialvgo mvvkupre. ");
INSERT INTO tgj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nonuno nyimak gv sudu pvbinna, adubv okv nvchibv tvvpa tvdu kunv; vbvritola adwkaku mabvka. Hvkvnvngv rirungjinv, vbvritola hv bunu ataranya alu hv aarikunv vnam kaama. ");
INSERT INTO tgj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Diringmooku vdwv mvmi sireku, Karv vdwv pami sireku. Hoka dvmayarwng ngv okv moobi hv mooku mvnwnglo rireku. ");
INSERT INTO tgj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","So ogumvnwng si kuu bvngtubvngke bv bvngrinyi, achichinam apiabv rire. ");
INSERT INTO tgj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Vbvrikunamv nonua mvritririt dukubv okv mvki mvmar dukubv laklwk reku. Nyi vdw mvnwngngv ngoogv lvkwnglo nonua kaanwng kumare. ");
INSERT INTO tgj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hvbv ririlo achialv nyi go bunugv mvngjwng nga ngoomu reku; bunu koa minsureku okv kaanwng kumabv rimi sireku. ");
INSERT INTO tgj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Vbvrikunamv mvvnvrunv nyijwk vdwv aalwk reku okv achialv nyi go mvvkup rikup reku. ");
INSERT INTO tgj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hvkvnv vdwv alvmanv nga dupwng monv gubv rireku, hoka nyi mvnwnggv pakmi sunam mv, ngeya yaya reku. ");
INSERT INTO tgj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Vbvritola yvvdw gakbwngla ataranya lobv doolin redw, hv bunu ringnam a paare. ");
INSERT INTO tgj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Okv so gv Alvnv Yunying Karv gv lvkwng nga nyi vdw mvnwngnga tvvmu dubv nyiamooku mvnwnglo japgo karreku; vbvrigvrikula ataranya aluv aariku. ");
INSERT INTO tgj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nonuno nyijwk Daniel gv minam, ‘Achialvbv Alvmanv Busu Namgo’ kaapare. Hv darwknv mooku lo dakdung reku.” (Puririnv vdwa minpa jidu: Si ogugonyi mindunv chinlaka!) ");
INSERT INTO tgj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Vbvrikunamv yvvbunudw Judia lo ridunv, hv bunu moodw vdwlo kicha runglaka. ");
INSERT INTO tgj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nyi gunv ninyigv namwng aolo doonv, vdwloka naam arwngbv aala ninyigv yikungyira nga naadubv rirung mabvka. ");
INSERT INTO tgj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nyi gunv rongolo rinv vngkur la ninyigv vji laklwk a naadubv rirung mabvka. ");
INSERT INTO tgj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ho aluv mvvga kuu gvnv gvbv okv anv kuu anga doonv gvbv achialvbv mvngru runam gubv rire. ");
INSERT INTO tgj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pwknvyarnvnyi kumtoka, ho no kamching poolu lo okv Jius Doonu alu lo jokyu la jokkwng madubv! ");
INSERT INTO tgj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ho gv hirukaya ngv maatarbv hinchi manam alvkuma nvgobv rila, ho gv mooku hoka lvkoka rikw manam gubv rire, nyiamooku gv rirap lokv vjakgv alu lobv. Okv vbvdvdvbv hoka lvkoka rikw kumare. ");
INSERT INTO tgj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Vbvritola Pwknvyarnv ho gv alua loodwng mopvkunv; Nw vbv mvma nvgo yilo, yvvka svngnyu mapvnvpv. Ninyigv darnam nyi vdwgv lvgabv, ogubvrijvka, Pwknvyarnv ho alu vdwa loodwng mopvkunv. ");
INSERT INTO tgj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Vbvrikunamv, nyi gunv nonua, ‘Kaatoka, Kristo si doopvku!’ vmalo ‘V nw doopv!’ vla minbolo—ninyia mvngjwng mabvka. ");
INSERT INTO tgj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mvvnvrunv Kristo vdwv okv mvvnvrunv nyijwk vdwv aalwk reku; bunu kairungbv lamrwpanam rila okv kaasartabobv rire, okv rilabolo Pwknvyarnv gv darnam nyi vdwa kupdubv mvre. ");
INSERT INTO tgj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tvvriato! ngo nonua hv ritv madvbv mincho jidunv. ");
INSERT INTO tgj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Vmalo rinyu bolo nonua vbv mintamre, ‘Kaatoka, nw chukrimooku v redu!’—hoka vngma bvka; vmalo bunu ‘Kaatoka, nw si tosila doopv!’ vla minbolo, um mvngjwng mabvka. ");
INSERT INTO tgj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nyia Kuunyilo ngv dooriak jvbv nyidomooku mvnwngnga doonyi chaagu kiamngv lokv aagia kiamngv lobv loung ngv ungpola aariku. ");
INSERT INTO tgj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ogolo svma ngv dooridw, adwn dvnv pvta ngv dookumre. ");
INSERT INTO tgj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Hirukaya alu vdwv vngro danam gula, doonyi v kanv riku, pooluv ungku mare, nyido tologv takar vdwv holu reku, okv nyidokolo tologv jarkarnv jwkrw gvnv vdwvka bunugv lamtv lokv ngeriku. ");
INSERT INTO tgj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Vbvrikubolo Nyia Kuunyilo ngv nyidomooku tolo kaachin dubv rilwk reku; okv sichingmooku so gv nyi mvnwngngv Nyia Kuunyilo gv jwkrw gvla okv kairungbv yunglit nvgobv rila doomwk lo aaku nama kaala kapnya riku. ");
INSERT INTO tgj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kairungnv tapung ngv mire, okv ninyigv nyidogindung vdwa sichingmooku gv chvnyung api lo vngmure, okv vbvrikunamv bunu vngla ninyigv darnam nyi vdwa Siching gv kvdw dootar gunv lokv dootar gunv lobv naakum reku. ");
INSERT INTO tgj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nonuno kaachin sinam lvgabv koksitkokrik singnv nga tamsar ako sarku laka. Vdwlo so gv hakbv vdwv jejila kaapu laku okv anv harlin laku riku bolo, nonuno dwrw hv nvchi duku vla chindu. ");
INSERT INTO tgj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hvkv aingbv, vdwlo nonu so mvnwng sum kaaku bolo, nonuno dw ngv nvchi duku, rirap tvduku vla chinreku. ");
INSERT INTO tgj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mvnggap laka so mvnwng si richore vjakgv nyi singnv mvnwng si sitv madvbv. ");
INSERT INTO tgj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Siching nyido ngv ngelare, vbvritola ngoogv gamchar vdwv vdwloka ngemare. ");
INSERT INTO tgj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ogubvrijvka, yvvka ho alu okv dw v vdwlo aatv rinvdw chinv kaama—nyido tologv nyidogindung ngvre vmalo Nyia Kuunyilo ngvre; Abu mvngchik chindu. ");
INSERT INTO tgj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nyia Kuunyilo gv aanam hv Noah gv dw lo ogugo ripv kudw ho apiabv rireku. ");
INSERT INTO tgj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ho alu svcharmoyar gv aatv madvbv nyi vdwv dvdikdvyik nyato, nyimv nyilo vdwv nywng nyilubv naami sinya toku Noah gv svpw lo aalwkri alu hoka; ");
INSERT INTO tgj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","vbvritola bunu mvngdin kuma, Anyungnga bunua svcharmoyar isihv tvvlula nungla vnggv toku. Nyia Kuunyilo gv aari kunyi vbvdvdvbv rireku. ");
INSERT INTO tgj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ho gv dw lo nyi anyi gunv rongo ribamre: akonyi naareku okv akonyi hoka kayu reku. ");
INSERT INTO tgj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mvvga anyi gunv chvngpar lo daa hwgba sure, akonyi naareku okv akonyi hoka kayu reku. ");
INSERT INTO tgj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Vbvrikunamv, nonuno hima sulaka, ogulvgavbolo nonu chima ogunv alulo nonugv Ahtu aarikudw. ");
INSERT INTO tgj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Naam atuv dvcho nvgv aadw a chinku bolo, nonu jvjvbv chinsudo nw yupma bv hula doogv rila, ninyigv naam a dvcho nvnga cholwk momare. ");
INSERT INTO tgj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Vkvlvgabv nonuka lokia agearap sula doolaka, ogulvgavbolo Nyia Kuunyilo ngv nonugv ninyia dvminmabv dooridw gunyi aariku. ");
INSERT INTO tgj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Vbvrinamv, yvvla alvnv okv mvnglaknv pakbu hv? Ho angv hvkv nvgo ninyigv atu hv ninyia kvvbi pakbu vdwa kaayataya mola dvdw tvngdw lo dvmu tvngmunv akobv pvvnam angv. ");
INSERT INTO tgj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Vdwnvgo mvngpu gubv rire vdwlo ninyigv atuv naam aari kunyi ninyia vbvridubv kaaku bolo. ");
INSERT INTO tgj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rinam gvbv vbvriri nvpv ngo nonua minpa jidu, ninyigv atuv ninyia ninyigv yikungyira mvnwngnga kaayataya nvgobv jire. ");
INSERT INTO tgj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Vbvritola nw alvmanv pakbu gubolo, nw atubongv minsu dunvpv nw gv atuv baapubv aakur kumare. ");
INSERT INTO tgj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Okv nw ninyigv pakbu ajin vdwa dvngrap dunvpv okv dvkium tvngkium dubv dvdu tvngdu nvpv. ");
INSERT INTO tgj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Vbvrikunamv ho pakbu gv atuv alu gunyi ninyigv dvminmabv doori gulo okv ninyigv chima dw alulo aakur riku. ");
INSERT INTO tgj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Atuv ninyia patungpayung mvreku, okv ninyigv kaakudubv rinam aje nga naaria nvbv mvre. Hoka nw kapreku, okv hijung nga kotwkkrwk sireku. ");
INSERT INTO tgj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ho alu lo Nyidomooku gv Karv ngv vbvrire. Lvkogulo nyijar vring go dooto, bunu bunugv mvdurupum a naalayila makbu rijibonga kaarwk sibv vnglin nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Angu gunv pvcha nyato okv kvvbi angu gunv mvnglak nyato. ");
INSERT INTO tgj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pvchanv vdwv bunugv mvdurupum a bvngla vngnyato vbvritola bunu tvli gvpwng mato. ");
INSERT INTO tgj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mvnglaknv angu hv bvngia nvnvlo bunugv mvdurupum lvgabv tvli vkv yarbing dubv bvngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Makbu rijibongv aadu bv tapv toku, vkvlvgabv nyijar vdwv yumi mirapla yupngak nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ayuyupra bv ritoku, ho sudu go dulinto, ‘Siinv makbu rijibongv! Aala okv ninyia kaarwk sulakuka!’ ");
INSERT INTO tgj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nyijar vring ngv hurap nyala bunugv mvdurupum baanu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vbvrikunamv pvchanv vdwv nyebanv vdwa minto, ‘Klai, ngonua nonugv tvli lokv jilabv, ogulvgavbolo ngonugv mvdurupum hv ngejiku.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nyebanv vdwv mirwkto, ‘Ma,’ ‘Nonu gvbv la ngonu gvbv tvli hv chimare. Dukan lo vngnyika okv nonuno lvgabv rvvti laka.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Vkvlvgabv pvchanv nyijar vdwv tvli mego rvvdubv vngnya toku; okv bunugv vngro kochingbv makbu rijibongv aatoku. Nyijar angu kaayanv vdwv makbu rijibonga lvkobv nyida dvpam lo vngming gvtoku, okv agi a koktum toku. ");
INSERT INTO tgj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ayungjvma nga kvvbi vdwv aalwk nyatoku. Bunu, ‘Tamsarnv, tamsarnv! Ngonua arwng aamu labv!’ vla kapla goknya toku. ");
INSERT INTO tgj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Ma rung! Ngo nonua chima,’ vla makburijibongv mirwk toku.” ");
INSERT INTO tgj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Okv Jisu minyabv mintoku, “Vbvrikunamv nonuno hinsu laka, ogulvgavbolo nonu alu vmalo dw nga chima. ");
INSERT INTO tgj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ho alu lo Nyidomooku gv Karv ngv svbv rire. Alu gulo nyi ako dooto, nw adu lo moing vngtv tvvto; nw ninyigv pakbu vdwa goklwk gvrila ninyigv yikungyira nga kaaya dubv tinglwk toku. ");
INSERT INTO tgj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nw nyi vdwa rilajinv nga kaala akin—akin a kaagvrila jito: Akonyi nw ain lokdwng hejar angu go jito, akonyi hejar anyigo okv akonyi nw hejar akin go jito. Vbvrikunamv nw moing vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hejar angu lokdwng go naarwknv pakbu angv vjakgobv vngda bongv ninyigv morko nga mvjinmvta toku okv hejar angu godv mvlin jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ho apiabv ain lokdwng hejar anyigo naarwk sinv pakbu angv hejar anyi godv mvlin jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Vbvritola lokdwng hejar go naarwk sinv pakbu angv vngla, kvdw lo ungrung go dutola ninyigv Ahtu gv morko nga hoka vvsi toku. ");
INSERT INTO tgj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Achialvgo ayungjvma nga ho pakbu vdwgv atu angv aakur toku okv bunua lvkobv morko nga sapka toku. ");
INSERT INTO tgj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lokdwng hejar angu go naarwksinv pakbu angv aatoku okv hejar angu go paatam nam hum laklwk toku, okv minto, ‘Atu, no ngam lokdwng hejar angu go jito, okv kaatoka! siinv ngo kvvbi hejar angu gudv ngo paalwk pvkunv.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Alvbv ripv, no alvnvgo okv jwkjwkvrwknv pakbu go!’ ninyigv atuv minto, ‘No miangnv morko nga alvbv mvjinmvtapv, vkvlvgabv ngo nam kainv morko nga kaaya modubv jire. Aatoka, soka okv ngoogv himpua pumin gvlaka.! ");
INSERT INTO tgj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Vbvrikunamv pakbu morko lokdwng hejar anyigo jinam angv aala okv minto, ‘Atu, no nga lokdwng hejar anyigo jito. Kaatoka, vjak ngo hejar anyi godv paalwk pvkunv.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Alvbv ripv, no alvnvgo okv jwkjwkvrwknv pakbu go!’ ninyigv atuv minto. ‘No miangnv morko nga alvbv mvjinmvtapv, vkvlvgabv ngo nam kainv morko nga rigv modubv jire. Aatoka, okv ngoogv himpu lo pumin gvlaka!’ ");
INSERT INTO tgj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Vbvrikunamv lokdwng hejar akin go naarwk sinv angv aala okv minto, ‘Tamsarbo, ngo chindu no raainv nyi go; no noogv rongo mvma kolo aam gvdu, okv no noogv aam chima kolo aam nvvdu. ");
INSERT INTO tgj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Vkvlvgabv ngo busula vngla noogv morko nga kvdw lo vvsi pvkunv. Kaatoka, siinv no gvngvku.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ninyigv atuv ninyia mintoku, ‘No alvmanv okv svpenv pakbu go!’ ‘No nga rongo mvma kolo aam gvdubv okv aam chima kolo aam nvvdubv chindu ai? ");
INSERT INTO tgj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Vbvriku nvgo yilo, alv rinvpv, no ngoogv morko nga morko benk lo lvktola ngoogv aakur rikulo kuu naatak la ngo naaku nvgo yilo. ");
INSERT INTO tgj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vjak morko nga nw gvlokv dvrit gvri kula nyi morko lokdwng hejar vring go doonv lo jitoka. ");
INSERT INTO tgj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yvvdw ogugo doodudw, um jitam yayare, okv nw kaiyayabv dooreku; vbvritola yvvnyiv ogu guka dooma dunv, ninyigv achukgo doonam haka nw gvlokv dvrit jireku. ");
INSERT INTO tgj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Svbv alvmabv rinv pakbua—agum kanv kolo ninyia ora tvka; hoka nw kapla hijung nga hitwkkrwk sireku.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Vdwlo Nyia Kuunyilo ngv Dvbv bv rila aarikudw okv nyidogindung mvnwngngv ninyia lvkobv aariku, nw ninyigv Dvbv dooging lo dootung reku, ");
INSERT INTO tgj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","okv diringmooku mvnwng gv nyi vdw mvnwngngv ninyigv kaagialo dookum reku. Vbvrikunamv nw bunua anyi gubv mvpin sureku, svlar kaaya nvgv svlar hala yabin a mvpin sunam apiabv. ");
INSERT INTO tgj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nw alvnv nyi vdwa ninyigv lakbik kiamlo vvpv reku okv kvvbi vdwa ninyigv lakchi tangvlo vvpv reku. ");
INSERT INTO tgj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Vbvrikunamv Dvbv ngv ninyigv lakbik tangvlo nyi daknv vdwa minreku, ‘Aatoka, nonuno ngo Abu gv aya jinam vdwv! Nyia mooku a pwkri lokv nonugv lvgabv pwklin jikunam Karv nga aala kaato kuka. ");
INSERT INTO tgj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngo kano toku okv nonu nga dvmu toku, tvngnwngto nonu nga tvngse go jitoku; ngo nyen bv rito nonu nga nonugv naam lo naarwk sutoku, ");
INSERT INTO tgj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","vji gvvpa mabv abinto nonu nga vji gvmutoku; ngo lvvmato okv nonu nga ringchum yato, patwklo dooto okv nonu nga kaalwk toku.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Alvnv nyi vdwv ninyia mirwk reku, ‘Ahtu, vdwlola, ngonu nam kano kvvbi kaapa namv okv nam dvmu kunamv vmalo tvngnwng kunam a tvngse go jinamv? ");
INSERT INTO tgj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Vdwlola ngonu nam nyen bv kaala ngonugv naam lo nam aamu namv, vmalo abin dubv kaapala nam vji gvmunamv? ");
INSERT INTO tgj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Vdwlola ngonu nam lvvma dubv okv patwk doodubv kaala nam kaalwk namv?’ ");
INSERT INTO tgj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dvbv ngv mirwk reku, ‘Ngo nonua minpa jidunv, vdwlo nonu ngoogv nyi miang nvgo nyika so vdw sum riku bolo, hv ngo lvgabv rinam vku!’ ");
INSERT INTO tgj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Vbvrikunamv nw ninyigv lakchikiam gv nyi vdwa minre, “Ngo gv lokv vngroto, Pwknvyarnv gv beenam arwng lo doonv vdw nonu! Uyudvbv okv ninyigv nyidogindung vdwgv lvgabv mvpv kunam doobwngnv vmvlo vngroto kulaka! ");
INSERT INTO tgj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngo kano toku vbvritola nonu nga dvnam jima, tvngnwngto vbvritola nonu nga tvngse go jima; ");
INSERT INTO tgj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngo nyen bv rito vbvritola nonu ngam nonugv naam vdwlo aamuma, vji koopa mato vbvritola nonu ngam vji jima; ngo lvvmato okv patwklo dooto vbvritola nonu ngam ringchumriaima.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Vbvrikunamv bunu ninyia mirwk sireku, ‘Ahtu, vdwlola ngonu nam kano dubv, vmalo tvngnwng dubv, vmalo nyenbv ridubv, vmalo vji gvvpa madubv, vmalo lvvma dubv, vmalo patwk doodubv kaagvrila ridur maanammv?’ ");
INSERT INTO tgj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dvbv ngv mirwk reku, ‘Ngo nonua minpa jidu, vdwlo nonu ngoogv nyi miang nvnga ridur maanammv hv nga ridur kuma namv.’ ");
INSERT INTO tgj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Vbvrikunamv, so vdwa hirukaya nyema kolo vngmu reku, okv alvnv nyi vdwa turbwngla dookulo vngmu reku.” ");
INSERT INTO tgj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Vdwlo Jisu so mvnwngnga tamsar sarro kochingbv nw ninyigv lvbwlaksu vdwa mintoku, ");
INSERT INTO tgj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nonuno chindu, alu lonyi kochingbv Vngbo Dvmin Pumja ngv, okv Nyia Kuunyilo nga daapo lo takki dubv laklwk reku.” ");
INSERT INTO tgj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Vbvrikunamv nyibu butvnv vdwv okv nyigagaatv vdwv nyibu Butvyachok Kaipas gv Naam lo kaarwk minsu toku, ");
INSERT INTO tgj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","okv Jisunyi naasila naatung gvrila mvkidubv rungnyato. ");
INSERT INTO tgj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bunu minto, “Ngonu Pumja riri soka rima bvjuka, vbvribolo nyi vdwv yalungyachung bv rire.” ");
INSERT INTO tgj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisu Betani lo Saimon vnam kvvlo taik rila silvmanv gv naam lo dooto. ");
INSERT INTO tgj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jisu gv dvla doorilo, mvvga nvgo takam pvchwng gulo achialv arv doonv nampunv tvli vkv bvla yila, nw gvlo aala dumpo nga pwke to. ");
INSERT INTO tgj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lvbwlaksu vdwv sum kaatola haachi nyato, “Sum mvnwng sum ogubv mva dunvdw?” Vla bunu tvvka nyato. ");
INSERT INTO tgj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“So nampunv tvli sum kainvgobv piokgv rila morko nga heemanv vdwlo jibolo alvyare!” ");
INSERT INTO tgj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisu bunugv minam a chintoku, vkvlvgabv nw bunua minto, “Nonuno ogubv so mvvga nvnga dwkya dunv? So si alvnvgo rigvnyibv okv ngam kaapu nvgo riji gvibv. ");
INSERT INTO tgj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nonuno alu gv dwkia heemanv nyi vdwa lvkobv ribam dakbam tvdu, vbvritola nonuno ngam alu gv dwkia lvkobv ribam dakbam tvvma. ");
INSERT INTO tgj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nw gv ngam ogugo rinam si tvli nga ngoogv ayak lo pwke do ngam svma rijinama richo dunv. ");
INSERT INTO tgj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Vjak ngo, nonua milv jila mindunv, so Gamlv sum ogolo mooku mvnwnglo japji rikudw, nwgv svbvrinam sum ninyia mvngpanam gubv minbwng jila minreku.” ");
INSERT INTO tgj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Vbvrikunamv lvbwlaksu vring gula anyi lokv akonv—Judas Iskeriot vnam angv—nyibu butv gvlo vngtoku ");
INSERT INTO tgj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","okv tvvkato, “Ngo Jisunyi nonu gvlo koa lwkji kubolo, nonu ngam ogugo jire?” Bunu raaji lokdwng chaam go saplinla ninyia jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hokv kongv Judas Iskeriot Jisunyi bunu gvlo laklwk jidukubv vla age kaarap toku. ");
INSERT INTO tgj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Vpap lwkmabv Vtwng dvdw Pumja gv lotuloke alu lo lvbwlaksu vdwv Jisu gvlo aala tvvkato, “No ngonua ogolo noogv lvgabv Vngbokunam dvmin a mvpvripv svgo vla mvngdu?” ");
INSERT INTO tgj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nw bunua minto, “Pamtv lo nyi ako gulo vnggv rila minpa tvka: Tamsarbo mindu, ngoogv dw ngv aapvku; ngo la ngoogv lvbwlaksu vdwv vngbo dvmin a noogv naam lo rigingre.’” ");
INSERT INTO tgj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jisu gv minkubv lvbwlaksu vdwv vngbo dvmin a mvpvripvla riji toku. ");
INSERT INTO tgj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Vdwlo arium tokudw Jisu la lvbwlaksu vdwv dvbam dvkubv vla dootung nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dvnam dvbam rilo Jisu minto, “Ngo nonua minpa jidunv, nonugv lokv akonv ngam koa reku.” ");
INSERT INTO tgj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lvbwlaksu vdwv achialvbv mvngru nyala okv akonvgv kochingbv akonv ninyia tvvka raptoku, “Ahtu, jvjvbv no ngam mindu nvgo bri?” ");
INSERT INTO tgj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisu mirwkto, “Yvvdw ngam lvkobv vtwng nga taali lo nwkbok mingv dunv hv ngam koa reku. ");
INSERT INTO tgj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nyia Kuunyilo ngv Darwknv Kitaplo oguaingbv minpvdw vbvrila nw sire, vbvritola yvvdw Nyia Kuunyilo nga kupnv hv maatarbv mvngru runam gubv rire! ho nyi anga hv alvyayijinyi ninyia dwrwboklin manv guilo!” ");
INSERT INTO tgj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas Iskeriot koanv angv minto, “Tamsarnv, jvjvbvbv no ngam mindu nvgo bri?” Jisu mirwk toku, “No minggv nyibv.” ");
INSERT INTO tgj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bunugv lvkobv dvdung rilo, Jisu vtwng ariap go naagvrila, umbonyikv vla kumto, pintung piyung toku, okv um ninyigv lvbwlaksu vdwa jitoku. Nw minto, “Sum nonu naato, okv dvtoka, si ngoogv ayak kv.” ");
INSERT INTO tgj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Vbvrikunamv nw koobu a naatoku, Pwknvyarnvnyi umbonyikv vtoku, okv um bunua jitoku, “Sum nonu mvnwngngv tvngtoka,” nw minto; ");
INSERT INTO tgj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Si ngoogv oyi hv, si Pwknvyarnv gv umkvpakv vnamha mvu pvvnamv, ngoogv oyi hv mvnwng gv rimur vdwa mvngnganam lvgabv sarlin jipvnv. ");
INSERT INTO tgj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngo nonua minpa jidunv, vdwlo ngo nonua lvkobv ngo Abu gv Karv lo anw bv aala tvngbam ma dvdvlo ngo sum aala sum vdwloka tvngdv kumare.” ");
INSERT INTO tgj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Vbvrikunamv bunu miriminpak go minbam pikula Olib Moodw bv vnglin nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Vbvrikunamv Jisu bunua mintoku, “Siyu gv ayu ching-ching nonu mvnwngngv nga kayupila kiyakkipak nyareku, Darwknv Kitaplo mindu, ‘Pwknvyarnv svlar kaaya nvnga mvkire, okv svlar vdwv kiyakkipak rekunv.’ ");
INSERT INTO tgj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Vbvritola ngoogv turkurro kochingbv ngo nonua Galili bv vngchoyare.” ");
INSERT INTO tgj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitar minda minrala Jisunyi minto, “Mvnwngngv nam vngyu dajvka, ngo nam vdwloka vngyu mare!” ");
INSERT INTO tgj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisu Pitarnyi minto, “Ngo nam minpa dunv, siyu gv ayu lo rokpuv kokma dwbv no lvom go ngam chimakv vla minre.” ");
INSERT INTO tgj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitar mirwk suto, “Ngo noogv lvkobv siitv dajvka, ngo vdwloka um mimare!” Okv lvbwlaksu kvvbi vdwvka vbvdvdvbv minya toku. ");
INSERT INTO tgj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Vbvrikunamv Jisu lvbwlaksu vdwa lvkobv Getsemane vnam mooku lo vngtoku, okv nw bunua minto, “Ngoogv alo vngla kumrilo, nonu soka doolaka.” ");
INSERT INTO tgj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nw Pitar nyila Jibedi gv kuunyilo anyia nw gv lvkobv vnggv toku. Nw gvlo achialvbv mvngdwk okv mvngruv aatoku, ");
INSERT INTO tgj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","okv nw bunua minto, “Ngo haapok gv mvngruv achialvbv kaiyajvla boktak tvduku, soka dootola ngam lvkobv hula doolaka.” ");
INSERT INTO tgj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nw achukgo adubv vngla, kvdw lo gublwk dvla okv kumto, “Ngoogv Abua, so si rila pvbolo, so ngoogv hinching koobu tvngtv dunam sum naa jilabv! Vbvritola ngoogv mvngnam bvma, noogv mvngnam bvyaka.” ");
INSERT INTO tgj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Vbvrikunamv nw lvbwlaksu aom gvlo aalwk toku bunua yupngakla doodubv kaapa toku; okv nw Pitarnyi minto, “Si ogubv ridu kunvla, nonu ngam lvkobv gunta akin goka hula doonyu madunv? ");
INSERT INTO tgj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Huladarla kumla dooto laka, nonuno pokayarka lo holwk madubv. Dow v mvnglwk yadu vbvritola ayak amar v mvngkam yama.” ");
INSERT INTO tgj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Lvkodv Jisu vngla okv kumto, “Ngo gv Abua, so gv hinching koobu sum ngo tvngma dvdvlo naa nyula manam gubv ridu bolo, noogv mvngnambv riya tukuka.” ");
INSERT INTO tgj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nw lvkodv aakur kunamv okv lvbwlaksu vdwa yupngakla doodubv kaapa toku; bunu nyikkv nyiktarla doonyu kuma toku. ");
INSERT INTO tgj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jisu lvkodv bunua kayupila okv vngla, okv lvom nvbv gamchar minam akin a minla kumto. ");
INSERT INTO tgj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Vbvrikunamv nw lvbwlaksu vdwgvlo aala kula minto, “Nonuno vjaklodvbv doomin yupmin doi? Kaatoka, Nyia Kuunyilo nga rimurnv nyi vdwgv laak lo laklwkdw gv aadu kunv. ");
INSERT INTO tgj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gudungto, klai vnglaju. Kaatoka, siinv ngam koa kunv nyi angv!” ");
INSERT INTO tgj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisu gv minbwng rilo, Judas, lvbwlaksu vring gola anyi lokv akonv aalwk toku. Ninyigv lvkobv Nyibu butv okv nyigagaatv vdwgv vngmukunam nyitwng go riokse okv daadwng bvngnv vkv aagv toku. ");
INSERT INTO tgj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Koanv nyi angv nyipam nyi vdwa kaachin modubv mvringmvma go mvrwjito: “Nonu gv naajinam anga ngo mopup nvpvla hum nonu naatung laka!” ");
INSERT INTO tgj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas Jisu gvlo vngdavngrala minto, “Tamsarnv, mvngpuv nam dooming gvlaka,” okv ninyia mopup toku. ");
INSERT INTO tgj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisu mirwkto, “Ajinha, um baapu bvkv!” Vbvrikunamv bunu aalaku, Jisunyi naatungla, okv ninyia achialvbv letwkkrwk toku. ");
INSERT INTO tgj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jisunyi lvkobv rinv vdwlokv akonv ninyigv riokse nga svvlin dabuv Nyibu Butvyachok gv nyira gv nyarung nga paalu jito. ");
INSERT INTO tgj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisu ninyia minto, “No gv riokse nga svlwk tokuka, yvv mvnwngngv riokse nga naadunv, hv riokse lokv sire. ");
INSERT INTO tgj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nonuno chima lare ngo Abunyi ridur lvgabv goklado, okv nw ngoogv lvgabv vjakgobv nyidogindung sipai hejar awgo vngmure? ");
INSERT INTO tgj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Vbvritola vbvrinam gubv riku bolo, Darwknv Kitaplo so si vbvrirung svngv vnam gaam vdwv jvjv kumare?” ");
INSERT INTO tgj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Vbvrikunamv Jisu nyitwng nga minto, “Nonuno ngam toa kunam nyi aingbv mvngnya la naatung dubv riokse okv daadwng bvngla yila aanyapvi? Alu gv dwkia ngo Pwknvyarnvnaam lo dootung tvla tamsarto, okv nonuno ngam naatung ma. ");
INSERT INTO tgj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Vbvritola so mvnwng si ripvnv nyijwk vdwgv Darwknv Kitaplo lvknam vdwa jvjv modukubv.” Vbvrikunamv ninyigv lvbwlaksu mvnwngngv ninyia kayupila kiyu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisunyi naatung kunv nyi vdwv ninyia Nyibu Butvyachok Kaipas gv naam lo boolwk nyatoku, hoka Pvbv tamsarnv vdwvla okv nyigagaatv vdwv dookum nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitar adu-adubv vngming gvtoku, Nyibu Butvyachok gv kvba baaku naam pvrv adu aingbv. Nw kvba baaku naam arwngbv aatoku, okv kaayanv vdwa lvkobv dootung mingv tvla mvnwngngv oguaingbv linri kudw vla kaaria toku. ");
INSERT INTO tgj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nyibu butvnv vdwvla okv kvba nyi vdwv Jisunyi mvkidubv vla mvvnam gungnying go mapadubv rikw nyatoku; ");
INSERT INTO tgj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","vbvritola bunu ogugoka mapa matoku, mvnwngngv aala ninyia mvvnamrunam vkv minkwng kubvka. Atar anyabv nyi anyigo aalwk toku ");
INSERT INTO tgj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","okv minto, “So nyi si minto, ‘Ngo Pwknvyarnvnaam sum mvyakmvchak gvrila okv alu loom kochinglo um ngo mvkor ladoku.’” ");
INSERT INTO tgj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nyibu Butvyachoknv dakrap la okv Jisunyi minto, “Nam gungnying lwknam vdw so no ogu mirwk sise domai?” ");
INSERT INTO tgj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Vbvritola Jisu choibv doobwngto. Nyibu Butvyachoknv lvkodv ninyia tvvkato, “Vjak ngo Pwknvyarnv gv amin bv nam tvvka dunv: minpalabv no Kristo okv Pwknvyarnv gv Kuunyilo ngvbolo.” ");
INSERT INTO tgj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisu ninyia mirwk sitoku, “No mingvnyibv. Vbvritola ngo mvnwngnga minpa jidunv: nonu Nyia Kuunyilo nga vjak lokv naalayila Pwknvyarnv gv lakbiklo doodubv okv mokpu haapam lo dootola nyidomooku tolokv aadu bv kaapare!” ");
INSERT INTO tgj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Vbv minam gula Nyibu Butvyachoknv atugv vji a putakpuyak mvgvrila mintoku, “Si Pwknvyarnvnyi nyarjitari namgo! So lvvya lo ngonu gungnying minji nvgo mvngkuma! Nonuno vjak ninyigv Pwknvyarnvnyi nyarjitari nama tvvsu gvibv! ");
INSERT INTO tgj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nonuno ogubv mvngpv?” Bunu mirwk suto, “Nw siyin dubv rimur rungpv.” ");
INSERT INTO tgj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Vbvrikunamv bunu ninyigv nyukmu lo tachor chorbiak nyatoku okv dvngtoku; okv ninyia svbiaknv vdwv ");
INSERT INTO tgj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","minto, “Kristo no ngonugv lvgabv nyikrw kaakato! Chinkato yvvla nam dvngnv!” ");
INSERT INTO tgj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pitar kvba baaku naam agum lo dominto ho Nyibu Butvyachok gv paknv akonv aato, okv ninyia minto, “Nooka Galilian go Jisunyi lvkobv rinv golaka.” ");
INSERT INTO tgj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nw mirwk suto, “Noo ogu gonyi mindu nvbvre, ngo hum chima,” vla nw mvnwng gv kaagialo chimakv vla mintoku, ");
INSERT INTO tgj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","okv kvba japku aajiku agi lo vnglintoku. Kvvbi paknv akonv ninyia kaatola hoka nyi doonv vdwa minto, “Nw ka Najaret lokv Jisunyi lvkobv rinv go.” ");
INSERT INTO tgj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Lvkodv Pitar chimakv vla mvvdvto okv mirwkto, “Ngo jvjvbv milv jidunv ngo ho nyi anga chima!” ");
INSERT INTO tgj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Achukgo ayungjvma nga hoka nyi daknv vdwv Pitar gvlo aala minto. “Vmabv nooka bunugv lokv akonv, noogv minam mvnwng lokv no atubongv miring sidu!” ");
INSERT INTO tgj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Vbvrikunamv Pitar minto, “Ngo milvla jvjvbv mindunv! Pwknvyarnv nga mvrit laka, ngo jvjv bv mima dunvlo! ngo ho nyi anga chimarung!” Vbvrikunamv, vjakgobv rokpuv koktoku, ");
INSERT INTO tgj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","okv Pitar Jisu gv ninyia minam a mvngpa toku: “Rokpuv koktv madvbv no nga chimakv vla lvom go mvvla minre.” Nw agumbv gwlin dukula achialvbv mvngrula kaptoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Arukamchi bv Nyibu butv mvnwng ngvla okv nyigagaatv vdwv Jisunyi rinyingla mvki dukubv rungtoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bunu ninyia rvngja mvlwk toku, linggv toku, okv Roman gobunor Pilot gvlo laklwk toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas koanv angv vdwlo Jisunyi miakaya pvkukv vla chinto kudw, nw mvngdin toku okv raaji lokdwng chaam a naatokula Nyibu butvnv vdwgvlo okv nyigagaatv vdwgvlo bvngkur jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nw minto, “Alvnv nyi nga koa la mvki monam si ngo rimur tokubv!” Bunu mintoku, “Hum ngonu oguriya dubv, hv noogv pwkor paakor gv ridung ngv!” ");
INSERT INTO tgj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas lokdwng nga Pwknvyarnvnaam lo orlwk pikula vngtoku; vbvrikunamv vnglaku okv nw atubongv hoksar sila sitoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nyibu butvnv vdwv lokdwng nga naarapla mintoku, “Si oyi morko ngv, okv sum pwknvyarnvnaam gv morko vvpvkolo lwkbolo Pvbv nga rinying jire.” ");
INSERT INTO tgj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Vbv minla koching so bunu ho lvkwng nga minjupminsi toku, ho morko nga bunu pvchwng pwknv nyi gv kvdw a rvvnv nvto okv hum kvdw a kvvbi mooku lokv aala sinv vdwa svma riikubv mvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hvkv lvkwngbv ho rongo nga ho alu lokv “Oyi rongo” vla mintoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Vbvrikunamv nyijwk Jeremia gv minamv jvjvbv rilin toku: “Bunu raaji lokdwng chaam a naatoku, Israel nyi vdwgv ninyia jidubv vla tolwkkunam morko nga, ");
INSERT INTO tgj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","okv morko nga pvchwng pwknv nyi gv kvdw a rvvnv nvtoku, Ahtu gv nga minpia aingbv.” ");
INSERT INTO tgj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisu Roman gobunor gv kaagialo daktoku, hv ninyia “Noo Jius vdwgv Dvbv ngvre?” vla tvuto. Jisu mirwkto, “No minam hv kv.” ");
INSERT INTO tgj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Vbvritola nw minto, Nyibu butvnv vdwgv, okv nyigagaatv vdwgv gungnying milwknam lo oguka mirwk simato. ");
INSERT INTO tgj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Vkvlvgabv Pilot ninyia mintoku, “Nam so ogumvnwng gungnying milwk nama no tvvpa madunvre?” ");
INSERT INTO tgj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Vbvritola Jisu gamgoka mirwk sumato, hum kaala gobunor angv achialvbv lamtoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vngbokunam Pumja rirap dwkibv Roman gobunor hv nyitwng gv koonam patwklo tumnam nyi akonyi tulin dukubv ribwng ako dooto. ");
INSERT INTO tgj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ho gv dw lo mvnwng gv chimbwng kunam nyi ako aminv Jisu Barabas vnamgo patwklo dooto. ");
INSERT INTO tgj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Vkvlvgabv vdwlo nyitwng ngv aakum tokudw, Pilot bunua tvvkato, “Nonuno nga nonugv lvgabv yvvnyi tulin svgo vla mvngdu? Jisu Barabas vnam sumre, vmalo Jisu Kristo vnam sumre?” ");
INSERT INTO tgj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jius nyi kainv vdwv Jisunyi kavtarv laila ninyia nw gvlo laklwk pvnv vla Pilot alvrungbv chintoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilot gv jwngkadakaku dooging lo dootungla doorilo ninyigv nyimv ngv gaamgo milwkla mimuto: “Ho nyi alvnvnga oguka rima bvka, ogulvgavbolo siyu ngo yuma mala, ho nyi angv gv lvkwngbv achialvbv hirukaya himpvnv.” ");
INSERT INTO tgj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nyibu Butvnv vdwv okv nyigagaatv vdwv nyitwng nga Barabasnyi anyubv tulin tvkv okv Jisunyi mvki tvkv vla Pilotnyi mintokv vla miarto. ");
INSERT INTO tgj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Vbvritola Pilot nyitwng nga tvvkato, “So nyi anyi sokv yvvnyi ngam nonugv lvgabv tulin jilabv vla mvngdu?” “Barabasnyi” vla bunu mirwkto. ");
INSERT INTO tgj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilot bunua tvvkato, “Vbvrikunamv Jisu Kristo vla minam sum ngo ogu mvdubv?” Bunu mirwkto, “Nyinyi daapo lo takkito!” ");
INSERT INTO tgj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Vbvritola Pilot tvkato, “Nw ogurimur go ripv?” Vbvrikunamv bunu gamtvyayabv gokla minto: “Nyinyi daapo lo takkito!” ");
INSERT INTO tgj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Vdwlo Pilot so ribwng minbwng tvbolo oguanyung kaamare, yalungyachung yabvya riya jinv go vla kaapa tokudw, nw isi koobu goya naagv rikula, si nonugv rinam mv, ngogvbv so nyi gv sinamv ogu aje doyama vla nyitwng gv kaagialo lasok toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nyitwng lokv nyi mvnwngngv mirwkto, “So nyi gv sinam gv aje nga ngonu gvlo okv ngonugv umvuu vdwgvlo doolwk molaka!” ");
INSERT INTO tgj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Vbvrikunamv Pilot Barabasnyi bunugv lvgabv anyubv tulin jitoku; okv Jisunyi svnyak pamuro kochingbv nw Jisunyi bunu gvlo daapo lo takki modukubv laklwk jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Vbvrikunamv Pilot gv sipai vdwv Jisunyi boola yila gobunor gv naam lo aagv toku, okv nyi mvnwngngv ninyia doyumdochi nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bunu ninyigv vji a pilin toku okv vji lwngching lwngbo nvgo pilwk toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Vbvrikunamv bunu tvv doonv hakbv ako naala um biotung bv mvtola ninyigv dumpo lo pilwk toku, okv bangngi daago ninyigv lakbik laak lo laklwk gvrila; vbvrikunamv bunu ninyigv haabo lo gublwk gvrila nyarjikau nyatoku. Bunu minto, “Jius gv dvbv, turbwng laka!” ");
INSERT INTO tgj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bunu ninyia tachor chorbiak nyatoku, okv laak gv bangngi nga naaritla ninyia dumpo nga dvngto. ");
INSERT INTO tgj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Vdwlo bunu ninyia nyarjikau rise nga rinya tokudw, bunu ninyigv jvkoklaklwk ka naalin toku okv ninyigv vji gvvbwng nga pikur lwktoku. Vbvrikunamv bunu ninyia daapo lo takki dubv vla vnglin gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Vbv bunugv vnglinla vngdungrilo, bunu Sairene lokv nyi aminv Saimon vnam a vngrwk suto, okv sipai vdwv ninyia Jisu gv daapo nga baktokv vla mintap minrap to. ");
INSERT INTO tgj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bunu Golgota vnam kvdw lo aalwk toku, so gv minam si, “Dumpo pakumku.” ");
INSERT INTO tgj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hoka bunu Jisunyi kvchaknv mvyomvchinam opo vkv jito; vbvritola um Jisu riakka gvrila tvngku mato. ");
INSERT INTO tgj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bunu ninyia daapo lo takki toku okv vbvrikunamv ninyigv vji a vlwng likw sila orpin oryin minsu toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Vbv mvro kochingbv bunu hoka dootung tokula ninyia kaaria nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nyinyia gungnying lwknam hum bunu: “Si Jisu, Jius vdwgv Dvbv ngv” vla lvktokula, nyi mvnwngnga kaamu dubv vla ninyigv dumpo aolo timpv jitoku.” ");
INSERT INTO tgj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Vbvrikunamv bunu Jisu gv lvkobv rimurnv nyi anyi guka, akonyi ninyigv lakbik tangvlo okv akonyi ninyigv lakchi tangvlo daapo lo paggin pvvtoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hoka vngpiknv nyi vdwv Jisunyi kaagvrila dumpo ngv dumpv-dumpvla nyarjikau nyatoku: ");
INSERT INTO tgj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“No, Pwknvyarnvnaam a mvyak gvrila okv hum alu loom lo mvdi tvkunv! No Pwknvyarnv gv Kuunyilo ngvbolo atubongv ringsu tvkuka! Daapo lokv itokuka!” ");
INSERT INTO tgj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ho apiabv Nyibu butvnv vdwv okv Pvbv tamsarnv vdwv okv nyigagaatv vdwv ninyia nyarjikau nyatoku: ");
INSERT INTO tgj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nw kvvbi vdwa ringdu, vbvritola nw atubongv ringsu nyumado! nw Israel gv dvbv mangvri? Vjak nw daapo lokv ikubolo, ngonu ninyia mvngjwng riku! ");
INSERT INTO tgj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nw Pwknvyarnvnyi mvngjwng nvgo, okv Pwknvyarnv gv Kuunyilo bv minsudo. Vbvrikunamv alvpv, kaaria laju, vjak Pwknvyarnv ila ninyia ringri kudw!” ");
INSERT INTO tgj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nvnyia lvkobv daapo lo pakpvnam rimurnv nyi anyi hvka, ninyia ho apiabv nyarjikau toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Alu lopo lo mooku mvnwnglo kanvjeriak toku, hv gunta aom gobv doobwngto. ");
INSERT INTO tgj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Alu gv aom baji nvnvlo Jisu achialvbv svgokla gokto, “Eli, Eli lema Sabakthani?” So gv minam si, “Ngoogv Pwknvyarnv, ngoogv Pwknvyarnv, no nga ogubv topu duku nvla?” ");
INSERT INTO tgj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hoka nyi mego daknv vdwv tvvpa gvrila minyato, “Nw Elijanyi gokdu!” ");
INSERT INTO tgj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bunugv lokv akonv vjakgobv joklwkla, svngchak alum a naala, kungsoknv opolo svbok gvrila, okv um singda nyiktoklo putin tvla, okv ninyia tvngmu dubv rikw toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Vbvritola kvvbi vdwv minto, “Dooyato, lvkonyika Elija aala ninyia ringji nvgobvre, kaaria laju!” ");
INSERT INTO tgj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisu lvkodv achialvbv svgokla, okv saknamma saknya toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Vbvrikunamv Pwknvyarnvnaam lo vji torchik nvnv ngv adum lokv ako lobv anyi gubv takpin sutoku. Sichingmooku si moobi hwktoku, lvngtak kv takpin takyin sutoku, ");
INSERT INTO tgj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","nyibung ngv detakla kokdariaka patoku, okv Pwknvyarnv gv nyi sikunv vdwv turkurla svngnya toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bunu nyibung nga vngyu nyatoku, okv Jisu gv sitokula turkurro kochingbvku, bunu Darwknv Pamtv lo vngnya toku hoka nyi achialvgo bunua kaatoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Armi nyigam angvla okv sipai ninyia lvkobv rila Jisunyi kaadungnv vdwv moobi hwknam a okv nvgwng nvbv rinam a kaatokudw bunu achialvbv lamngak nyato okv minto, “Jvjv rungbv nw Pwknvyarnv gv Kuunyilo gurung!” ");
INSERT INTO tgj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hoka mvvga achialvgo doonyato, bunu adu lokv kaanyala doonyato, bunu Jisunyi Galili lo vngming gvnv, okv ridurnv vdwv. ");
INSERT INTO tgj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bunu vdwv, akonv Meri Magdalene, Jems gvla Josep gv anv Meri, okv Jibedi gv nywng. ");
INSERT INTO tgj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Vdwlo ho arium tokudw, Arimatia lokv nyitv nyi go aachi toku, ninyigv aminv Josep, okv nw ka Jisu gv lvbwlaksu go. ");
INSERT INTO tgj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nw Pilot gv dookulo aala okv Jisu gv svma nga kootoku. Pilot svma nga Josepnyi jidubv milin jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Vkvlvgabv Josep svma nga naatoku, vji pakria anwnv lokv puching toku, ");
INSERT INTO tgj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","okv um nw atubogv nyibung lo joolwk toku, hv ninyigv vlwng lvngtak ka ungrungbv kodak sopik namgo. Vbvrikunamv nw vlwng pwktv nvgo nyibung agi a ngortum pikula vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Magdalene okv kvvbi Meri gunv nyibung nga doorwk tvla dootung nyato. ");
INSERT INTO tgj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Alu logo nvnga, hv Jius Doonu alu bv rito, Nyibu Butvnv vdwvla Parisis vdwv Pilotnyi lvkobv kaarwk sutoku ");
INSERT INTO tgj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","okv minto, “Tamsarnv, ngonu mvngpadu ho nyi mvvnv angv gv turla rire hoka nw minto, ‘Ngo alu loom kochinglo turkur reku.’ ");
INSERT INTO tgj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Vbvrikunamv, no ninyigv nyibung nga alu loom nvnv tolo lobv sipai vdwa mingvrila dakria motoka, ogulvgavbolo ninyigv lvbwlaksu vdwv aala nw gv svma nga chola madubv, okv vbvrikunamv nyi vdwa nw sinam lokv turpv kunv vla mima dubv. So gv ataranyabv mvvnam angv si mvvcho kunam vdwa kaiyabv alvmanv gubv riyi nvpvla.” ");
INSERT INTO tgj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilot bunua mintoku, “Dakria moto laka, okv nyibung nga nonugv lvgvlvma lokv haatinklin dubv mvto laka.” ");
INSERT INTO tgj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Vkvlvgabv bunu vnglaku nyibung nga achialvbv haatinklin dubv mvgvrikula kaachin dubv vlwnglo mvu lwktoku okv sipai vdwa dakria nyadubv vngyu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jius vdwgv Doonualu kochinglo, Vjwng alugv aru doonyi nyilin rilo, Meri Magdalene okv dvbv Meri akonv nyibung nga kaalwkbv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lamdokpada dubv hoka moobi go achialvbv hwkto; nyidomooku tolokv Ahtu gv nyidogindung ngv itoku, vlwng nga ngora jitola okv hoka dootung toku. ");
INSERT INTO tgj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hv dooriak jvbv kaanam go, okv ninyigv vjiv tapam aingbv yapung toji toku. ");
INSERT INTO tgj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dakyanv sipai vdwv bunu achialvbv busu sungak laku jinjinpaparla nyi sinv aingbv rinya toku. ");
INSERT INTO tgj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nyidogindung ngv mvvga vdwa mintoku. “Nonuno busu rungma bvka, ngo chindu nonu daapo lo takkinam Jisunyi makar dunvgo. ");
INSERT INTO tgj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nw si domakv; nw turrapla gudung ropvkunv, ninyigv minam aingbv. Soka aala kaatoka ninyigv karku a. ");
INSERT INTO tgj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Vjak baapubv vngnyika, okv ninyigv lvbwlaksu vdwa minpa jilaka, ‘Nw sinam lokv turkur pvkunv, okv vjak nonua vngchoyala Galili bv vngdungdo; hoka nonu ninyia kaapa reku!’ Ngo nonua ogugo minpvdw mvngpa laka.” ");
INSERT INTO tgj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Vkvlvgabv bunu baapubv nyibung nga vngyu toku, busu bvla okv mvngpu bvla ritola, ninyigv lvbwlaksu vdwa minpa dubv joktoku. ");
INSERT INTO tgj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lamdokpada dubv Jisu bunua kaarwksula okv minto, “Mvngpuv nonugv lvkobv dooming gvlaka.” Bunu nw gvlo aatoku okv ninyigv lvpa nga jarbwng nyatola ninyia kumnyajonya toku. ");
INSERT INTO tgj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisu bunua minto, “Busu mabvka, vngnyila ngoogv boru vdwa Galili lo vngdubv minpa jiteka, okv hoka bunu ngam kaapa reku.” ");
INSERT INTO tgj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mvvga vdwgv lamtvlo vngdungrilo, nyibung nga dakrianv sipai megonv pamtv bv vngkur lakula ogugo ripvkudw ho mvnwngnga Nyibu butvnv vdwa minpa jitoku. ");
INSERT INTO tgj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nyibu Butvnv vdwv nyigagaatv vdwa kaarwksula bunugv mvngnam a rungtoku; bunu sipai vdwa morko achialvbv jitola ");
INSERT INTO tgj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","okv minto, “Nonu vbv minlaka, nonugv yupla doorilo, ninyigv lvbwlaksu vdwv ayu bv aala ninyigv svma nga dvchoola baggv yinv vlaka. ");
INSERT INTO tgj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Okv so yunying sum gobunor tvvpa bolo, ngonu ninyia tvvlwk dubv minre, ho vdwv chimapvnv vla, ho lvgabv nonu mvngdwk mabvka.” ");
INSERT INTO tgj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nyibung nga Kaayanv sipai vdwv morko nga naagvrikula, bunugv minkubv riji toku. Okv vkvlvgabv so yunying sum Jius nyi vdwv vjaklodvbv dugola dupwng modu. ");
INSERT INTO tgj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lvbwlaksu vring gula akin vdwv Jisu gv vnglakv vku Galili gv moodw lo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Vdwlo bunu ninyia kaapa tokudw, kvgonv mvngjwng matolaka, bunu nvnyia kumtojotoku. ");
INSERT INTO tgj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisu bunugv nvchilo aala minto, “Ngam nyidomooku okv sichingmooku mvnwngnga rigvdogv nvgobv jipvkunv. ");
INSERT INTO tgj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Vbvrikunamv, nyi vdw mvnwng gvlo vngnyika okv bunua ngoogv lvbwlaksubv mvteritekuka: bunua Abu gvla, Kuunyilo gvla, okv Darwknv Dow gv amin bv baptisma jilaka, ");
INSERT INTO tgj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","okv ngoogv nonua gamki nama bunua tamsar gvrila tvvmurimu laka. Okv ngo alu gv dwkibv nonua lvkobv reming gvvre, ataranya alu lobv.”");
INSERT INTO tgj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Si Pwknvyarnv gv kuunyilo, Jisu Kristo gv Alvnv Yunying ngv ");
INSERT INTO tgj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Si nyijwk Aijaya gv lvkpv kunam aingbv rirap toku: “Pwknvyarnv minto, ‘Ngo ngoogv gindungpingko nga nonu gvlo vngcho more nw nonugv lvgabv lamtv nga mvko jire.’ ");
INSERT INTO tgj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chukrimooku lo nyi go gokdungdo, ‘Ahtu gv vngku lvgabv lamtv nga sorchi dvbv pacho laka!’” ");
INSERT INTO tgj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Vkvlvgabv Jon chukrimooku lo aalwkto, baptisma jitoku okv Japkar toku. “Nonu rimur lokv lintokuka okv baptisma naalakuka,” Nw mintoku nyi vdwa, “Okv Pwknvyarnv nonugv rimur a mvngnga jiriku.” ");
INSERT INTO tgj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judia mooku lokv okv Jerusalem pamtv lokv nyi achialvgo Jon gv minam a tvvbv linlaku bunu atubogv rimur a mintam jilaku Jon gvlo Jordan svko lo baptisma jiku toku. ");
INSERT INTO tgj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon Kemel gv amw lokv chumnam vji a kooto okv ninyigv kipo lo apin hook go hokto okv ninyigv dvnam v takamyarup okv mootum gv tangu-ngula. ");
INSERT INTO tgj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nw nyi vdwa minpa jito, “Ngoogv kochinglo ngam kaiyanvgo aare ngo ninyigv lvsup a choobap la taasok yadubvka alvka yama. ");
INSERT INTO tgj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngo nonua isi lokv mwng baptisma jidu, vbvritola nw nonua Darwknv Dow lokv baptisma jireku.” ");
INSERT INTO tgj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ayungjvma nga Jisu Galili mookugv Najaret lokv aalaku, Jordan svko lo Jon gvlokv baptisma jiku toku. ");
INSERT INTO tgj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisu isi lokv daklin sopikda, nw kaapato nyidomooku v kokok dubv okv Dow v taakw jvbv nw gvlo holwk dubv kaato. ");
INSERT INTO tgj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Okv ho nyidomooku lokv gaamgo gokto “No ngoogv pakyachoknam kuunyilo akin v, nam lvkobv ngo mvngpu dukunv.” ");
INSERT INTO tgj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Vjakgobv Darwknv Dow hv ninyia chukrimooku lo vngdubv mvto, ");
INSERT INTO tgj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","hoka nw alu champigo dookunamv, mootum lo Uyu ngv ninyia pookayarka toku. Hoka svnwngsvmin vka dooto, vbvrikunamv nyidogindung vdwv aatoku okv ninyia ridur toku. ");
INSERT INTO tgj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jonnyi patwk tumlwkro kochinglo, Jisu Galili mookulo vngla okv Pwknvyarnv lokv Alvnv Yunying nga japkar toku. ");
INSERT INTO tgj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Alvnv alu v aadukukv,” nw minto, “Okv Pwknvyarnv gv Karv ngv nvchi dukukv rimur lokv lintokuka okv Alvnv Yunying nga mvngjwng tvka!” ");
INSERT INTO tgj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisu Galili gv svparsvlv lvgumlo vngkar rikulo, ngui naanv nyi anyigo nw kaapato, Saimon okv ninyigv boru Andriu, vsap lokv ngui naadungto. ");
INSERT INTO tgj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisu bunua mintoku, “Ngam lvkobv aato, okv ngo nonua nyi naadubv tamsarre.” ");
INSERT INTO tgj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Vjakgobv bunu vsap a topu pikula okv ninyia lvkobv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nw achukgo vnglindvda hoka boru anyi godv kaapa toku, Jebedi gv kuunyilo Jems okv Jon bunyia. Bunu bunugv svpw arwnglo vsap a mvdinla dootoku. ");
INSERT INTO tgj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisu bunua kaapa namgola nw bunua gokto; ho bunu bunugv abu Jebedi okv riria jinv bunua svpw lo doomupila okv Jisunyi lvkobv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisu okv ninyigv lvbwlaksu vdwv Kaparnaum banggu lo aatoku, okv akonvgv Jius Doonualu lo Jisu Jius kumkunaam lo vngtoku okv tamsar rapto. ");
INSERT INTO tgj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nyi vdwv ninyigv tamsar nama tvvla lamrwpanyato, oglvgavbolo nw pvbv tamsarnvbv mimabv tojupkunam jvbv tamsar yato. ");
INSERT INTO tgj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Vjakgobv bunugv Jius kumkunaamlo ho alvmanv dow v nyi ako gvlo aakunamv nw gamtv rungbv segokto, ");
INSERT INTO tgj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Najaret gv Jisu No ngonu gvlo ogugo naadubv? No ngonua soka mvyakmvchak dvbvri? Ngo chindu no yvvdw—No Pwknvyarnv gv darwknv gindungpingko ngv!” ");
INSERT INTO tgj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisu gamki la dow a minto “Mimabvk, no nyi lokv liro tokuk!” ");
INSERT INTO tgj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","alvmanv dow v ho nyi ham achirungbv hwkdin moto okv gamtv rungbv segok moto, okv nyi lokv lintoku. ");
INSERT INTO tgj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nyi mvnwngngv achialvbv lamrwpanya lakula akin-akin v mirwk minsu raptoku, “Si ogu goda? Si re jvjvbv ogu gonyi anw bv tamsarnamv? So nyi angv si tojupkunam go nw alvmanv dow vdwaka kaanam namla do okv bunuka ninyia tvvjidu!” ");
INSERT INTO tgj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Okv vkvlvgabv Jisu gv lvkwng yunying ngv Galili gv mooku mvnwnglo baapu bv dupwng toku. ");
INSERT INTO tgj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisu okv ninyigv lvbwlaksu vdwv Jems okv Jon bunyia mintala, Jius kumkunaam ha kayupila okv vngdavngrala Saimon okv Andriu gv naamlo vnglwkto. ");
INSERT INTO tgj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon gv ayu gadw lo ramla lvvmala dooto, Jisu aachi sopikda, bunu ninyia hvkvgv lvgabv minjito. ");
INSERT INTO tgj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jisu ninyigvlo aato, laak lokv gakbwngto, okv ninyia ridurla dakrap dubv svyinto. Ramnam hv nw lokv ngetoku, okv nw bunua jiraphorap toku. ");
INSERT INTO tgj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Doonyi v poklwkro kochingbv ariumrikulo hoka nyi vdwv lvvmanv mvnwngnga okv vram naanam nyi vdwa Jisu gvlo aagvjito. ");
INSERT INTO tgj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Banggu hokv nyi mvnwngngv aakumla naam agi lo dakpamto. ");
INSERT INTO tgj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisu awgo nvgwngnv lvvma nvnga mvpujito okv awgo uyuvram haka chara jito. Nw uyuvram vdwa gaam milin momato, ogulvgavbolo bunu chinsuto nw yvvdw. ");
INSERT INTO tgj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Aru gonvgv arukamchi bv puaharing madvbv kanv dvdubv, Jisu gudungla okv naam lokv vngtoku. Nw banggu ha vngboto jimiku mooku golo, hoka nw kumto. ");
INSERT INTO tgj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Vbvritola Saimon la ninyigv ajin vdwv vnglinto Jisunyi makarbv, ");
INSERT INTO tgj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","okv vdwlo bunu nw a kaapa tokudw bunu minto, “Mvnwng hv nam kaakardu.” ");
INSERT INTO tgj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Vbvrinamv Jisu mirwksito, “Ngonu vngrung laju kvvbi dokardovr nampum vdw soka. Ngo bunugv lvgabv japtam jidubv, ogulvgavbolo ngo hvkv lvgabv aapvnv.” ");
INSERT INTO tgj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Vkvlvgabv nw Galili mookulo mvnwngnga vnggola okv ho vdwgv Jius vdwgv kumkunaamlo mingojito okv uyuvram vdwa charkak jito. ");
INSERT INTO tgj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Apin hv yaarikla arwnam lvvmanv nyi go Jisu gvlo aato, lvbwng ngv kumpvto, okv mvdur lvgabv ninyia dinchi rungbv koto. “No mvnggilo,” nw minto, “No nga darwk dubv mvlare.” ");
INSERT INTO tgj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisu aya mvngpato, okv ninyigv laak v ilindola nyi ham mambwngto. “Ngo mvnggidu,” nw mirwk toku. “Darwk tokuka!” ");
INSERT INTO tgj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Vjakgobv nyi agv lvvma ngv ngetoku, okv nw darwk toku. ");
INSERT INTO tgj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Vbvrinamv Jisu ninyia kadwk rungbv minto okv ninyia vjakgobv vngmu toku ");
INSERT INTO tgj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ninyia “Tvvtoka, so gv rinam sum yvvnyika mintam mabvka,” vla mingv rikula. “Vbvritola nyibu gvlo vngdavngra laka okv ninyia no jwngkadaka kolaka; hvbv rigvrila nyichar mvnwngnga no poorung pvku vla chimu laka, Moses gv ortojinam lokv erinpeelwk a rinto laka.” ");
INSERT INTO tgj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Vbvritola nyi angv vngtoku okv minrap toku Yunying nga mooku mvnwnglo dupwng motoku. Nw vbv achialvbv minkunamv Jisu ka banggu lo nyi ha kaapa kodubv vngnyu kumato. Vmabvya, nw agumlo jemataiku mookulo dootoku, okv mooku mvnwng gv nyi vdwv nw gvlo aakumto. ");
INSERT INTO tgj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Alu lonyi loom gv kochinglo Jisu kaparnaum lo vngkur toku, okv ho nw naam lo doopvkv vla yunying ngv dusik toku. ");
INSERT INTO tgj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Vkvlvgabv hoka nyi vdwv achialvbv aakum kunamv aronv karchung goka dooku mato, okv agi gv agum loka dooku kaamato. Jisu bunua doin japjito. ");
INSERT INTO tgj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Vdwlo nyi api v aalwk tokudw, digwngnv nyi go Jisu gvlo joolwk toku. ");
INSERT INTO tgj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nyi twngtv kunam lvgabv, ogubvrijeka, bunu nyi um ninyi gvlo aagv nyumato. Vkvlvgabv Jisu ogolo doopvdw ho tintwbv bunu namwng aolo ungko go mvko toku. Vdwlo bunu mvko tokudw bunu nyi a ninyigv joko lo karmu tvla soolu jitoku. ");
INSERT INTO tgj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bunugv achialvbv mvngjwng kunam a kaagv rikula, Jisu digwngnv nyi anga minto, “Ngoogv kuunyilo, noogv rimur vdwa mvngnga jipvkun.” ");
INSERT INTO tgj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pvbv tamsarnv megonv ho vdwv doodum tvla bunu mvngsu nyato, ");
INSERT INTO tgj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ogubv so nyi si svbv gaam minladunv? Si Pwknvyarnvnyi nyarjitari namgo! Pwknvyarnv akin mwng yvvdw rimur ham mvngnga ladunv!” ");
INSERT INTO tgj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Vjakpi gobv Jisu chintoku ho vdwgv ogugo mvngnam am, vkvlvgabv nw bunua minto, “Ogubv nonu vbv mvngdunv? ");
INSERT INTO tgj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Vbvri minpubv minla, so digwngnv nyi sum, ‘No gv rimur vdwa mvngnga pvkunv,’ vmalo mindubai, ‘Gudunglak, naaraplak noogv karpunvnv nga, okv vngkarto’? ");
INSERT INTO tgj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vbvrijvka Nyia Kuunyilo ngv nyiamooku so rimur ham anyubv kayu jidubv tojupkunamv doodu hum ngo kaatam dubv rinam go.” Vkvlvgabv nw digwngnv nyi a minto. ");
INSERT INTO tgj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngo nam mindu, dakrap tvkuka, naaraplak noogv karpunvnv nga, okv naam lo vngnyikuka!” ");
INSERT INTO tgj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Vbvririlo ho mvnwngngv kaadumto, nyi angv dakrap laku, ninyigv karpunvnv nga naarap toku, okv baapubv vngtoku. Bunu mvnwngngv lamngaknyato okv Pwknvyarnvnyi hartvla, minto, “Ngonu vdwloka svkvnvgo ogugoka kaakw mapvnv!” ");
INSERT INTO tgj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisu Galili svparsvlv adarlo lvkodv aakur toku. Nyitwng go nw gvlo aakumto, okv nw bunua tamsar rapto. ");
INSERT INTO tgj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nw vbv vngrilo, nw kaapato lampu naakumyanv, Lebi Alpius gv kuunyilo, ninyigv opislo dooto. Jisu ninyia minto, “Nga vngming gvto.” Lebi gudungto okv nw a vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kochinglo Jisu Lebi gv naamlo dvnam dvla dooto. Twngtv rungnv lampu naakumyanv okv toa kunam nyi vdwvka Jisunyi vngming gvto, okv ninyi gvlo megonv aapwngto okv ninyigv lvbwlaksu vdwv tvbul adarlo dooto. ");
INSERT INTO tgj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pvbv tamsarnv nyi mego, Parisis nyi vdwv, Jisunyi lampu naakumyanv vdwa okv toa kunam nyi vdwa lvkobv dvdubv kaapato, vkvlvgabv bunu ninyigv lvbwlaksu vdwa tvuto, “Ogubv nw vkvnv nyi vdwa lvkobv dvdunv?” ");
INSERT INTO tgj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisu bunuam tvvpato okv mirwkto, “Nyi ngv yvvbunudw chvrv nvngv Daktor a dinchima, vbvritola yvvbunudw lvvmanvngv mwng. Ngo mvngdvnv nyi vdwa gokbv aamato, vbvritola rimurnv vdwa.” ");
INSERT INTO tgj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Doopam gulo Jon gv rigvnam vdwv la okv Parisis vdwv bunu yikla doonyato. Nyi megonv Jisu gvlo aato okv ninyia tvuto, “Si ogu vdw Jon gv lvbwlaksu vdwv la okv Pharisis gv lvbwlaksu vdwv yikla doogvre, vbvritola no gvngv dooma dunv?” ");
INSERT INTO tgj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisu mirwkto, “Nonuno nyidalo doonv vdwa dvmatvngma bv vngmu dukubv dvmin dunvre? Hvbv rirung mare! Makbu v doodv dvbv bunuam, bunu hvbv rimare. ");
INSERT INTO tgj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Vbvritola alu go aariku makbu a bunugv loka vnggv roriku, okv vbvrikubolo bunu ho yigrap reku. ");
INSERT INTO tgj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Yvvka vji jenw ariap ham vji jikulo hamtak lwknv kaama; Vbvrikubolo ninyigv jenw hamlwk namv takche rikunyi takgv riku okv ungko ngv kootv yayare. ");
INSERT INTO tgj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yvvka anggor ala anw ham pumchup akulo pwlwknv kaamare; vbvribolo anggor ala anw ngv pumchup aku lo hupokre, okv anggor ala ngvla pumchup v alv mariku. Vmabvya anggor ala anw a pumchup anw lo pwlwk yadunv.” ");
INSERT INTO tgj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jius Doonualu golo Jisu radv rongo apum gulo vngpitla vngto. Nw gv lvbwlaksu vdwa lvkobv vngming gvto, bunu radv damw dooku ham gakbwngla pikrap nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Vkvlvgabv Parisi vdwv Jisunyi minto, “Kaato laka, noogv lvbwlaksu vdwv jius Doonualu lo vbvrinam si ngonugv Pvbv nga rinyingdu!” ");
INSERT INTO tgj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisu mirwkto, “Nonu Dabid vdwlo dvnam go dvnwng rilo ogugo ribvdw um nonuno lvkoka puri rikw mai? Nw la okv ninyigv nyi vdwv kano toku, ");
INSERT INTO tgj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","hoka nw vngtoku Pwknvyarnv gv naamlo okv dvtoku Pwknvyarnv gvlo kumlwknam vtwng nga. Svbvrito vdwlo Abiatar nyibu butvyachok bv ririlo. Ngonugv Pvbv ara lokv nyibu vmwng vtwng nga dvnyu nvngv—vbvritola Dabid um dvtoku okv ninyigv nyi vdwaka jita toku.” ");
INSERT INTO tgj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Okv Jisu minya toku, “Nyi si Doonualu lvgabv mvvma; Doonualuv nyi gv alvnam lvgabv mvpvnv; ");
INSERT INTO tgj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Vkvlvgabv Nyia Kuunyilo ngv Doonualu gvka Ahtu hv.” ");
INSERT INTO tgj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Vbvritola Jisu lvkodv Jius kumkunaamlo aato kuring, ho hoka nyi go dooto hv laak v lakpik nvgo. ");
INSERT INTO tgj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hoka Jisunyi rimur nvgobv vla minjinv nyi mego toyala dooto; Vbv bunu Jisunyi nyi anga Jius Doonualu lo mvpu ridw vla kaagapla doyato. ");
INSERT INTO tgj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisu nyi anga minto, “Aatoka kaagia so.” ");
INSERT INTO tgj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Vbvritola nw tvuto nyi vdwa, “Ogugo ngonugv Pvbv ngv rimudunv Jius Doonualulo? Ridur dubvri vmalo ridur madubvri? Nyi gv singdung nga ringdubvri vmalo ngoomu dubvri?” Vbvritola bunu oguka minkuma. ");
INSERT INTO tgj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisu haachila bunuam kaitto, vbvritola vjakgobv nw bunua aya mvngpa toku, ogulvgavbolo bunuv achialvbv vlwnghapok bv gvvnyadu okv rimur nyadu. Vbvrikunamv nw minto nyi anga, “Noogv laak v laklinto.” Nw laklinjito, okv hv lvkodv alvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Vkvlvgabv Parisis vdwv Jius kumkunaam lokv lintoku okv Herod gv nyi vkv lvkobv kaarwksuto, okv bunu Jisunyi mvkidubv rungrap toku. ");
INSERT INTO tgj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisu okv ninyigv lvbwlaksu vdwv Galili gv svparsvlv lo vngtoku, okv kairungnv nyitwng go ninyia vngming gvto. Ho vdwv Galili lokv aatoku, Judia lokv, ");
INSERT INTO tgj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem lokv, Idumia mooku lokv, Jordan svko chaagu takdv lokv, okv mooku dokarku Taire okv Sidon Pamtv lokv. So nyi mvnwngngv Jisu gvlo aato ogulvgavbolo bunuv ninyigv rinam a tvvpato. ");
INSERT INTO tgj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nyitwng v achialvbv twngtvto ho Jisu minto ninyigv lvbwlaksu vdwa svpw ako ninyigv lvgabv naapv jidubv, vkvlvgabv ho nyi vdwv ninyia chapma dubv. ");
INSERT INTO tgj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nyi achialvgo nw mvpu kunamv, okv lvvmanv mvnwngngv nw gvlo aala mvsit dubv vla nvngpin nvngyin minsula aanyato. ");
INSERT INTO tgj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Okv vdwlo alvmanv dow gvnv nyi vdwv ninyia kaapa tokudw, bunu ninyigv kaagialo guplwkla okv goklinto, “No rung Pwknvyarnv gv Kuunyilo ngv!” ");
INSERT INTO tgj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisu alvmanv dow vdwa nw yvvdw um yvvnyika minpa mabvkv vla kadwk rungbv mintoku. ");
INSERT INTO tgj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Vbvrikunamv Jisu yvvnyi vnggvnvpv mvngpvdw goklaila moodw putung golo chaato. Bunu hoka nw gvlo aato, ");
INSERT INTO tgj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Okv nw darlinto vring gola anyigo, yvvnyi nw Apostol vla amin minpvdw. “Ngo nonua darlin pvnv nga lvkobv ridubv,” Nw bunua minto. “Ngo ka nonua agumlo japdubv vngmure, ");
INSERT INTO tgj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","okv nonu gvlo uyuvram vdwa charkak nvnv jwkrw v doore.” ");
INSERT INTO tgj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","So vring gola anyi si ninyigv darlinnam: Saimon (Jisu Pitar vla ninyia amin minto); ");
INSERT INTO tgj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jebedi gv kuunyilo Jems okv ninyigv boru Jon (Bunuam Jisu Boanarjes vla amin minto, vnam si “Doogumbv rinv nyi v”); ");
INSERT INTO tgj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andriu, Pilip, Bartolomiu, Metiu, Tomas, Alpius gv kuunyilo Jems, Tadius, Saimon Ringrianv ");
INSERT INTO tgj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Okv Judas Iskeriot, yvvdw Jisunyi koanv. ");
INSERT INTO tgj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Vbvrikunamv Jisu naam vngtoku. Lvkodv nyi twngtv rungnvgo aakumto ho Jisu okv ninyigv lvbwlaksu vdwv dvdw doomato. ");
INSERT INTO tgj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Vdwlo ninyigv lvga nga vpin v hum tvvpapvdw, bunu ninyia naatung dubv rito, ogulvgavbolo nyi vdwv minto, “Nw suru duku!” ");
INSERT INTO tgj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pvbv tamsarnv mego Jerusalem lokv aala minto, nw gv arwnglo Biljebul doopv! So si uyuvram vdwgv dvbv ngv yvvdw nw a gwlwk jigvrila bunuam agumlo chara dubv jwkrw jipv nvgo. ");
INSERT INTO tgj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Vkvlvgabv Jisu bunuam nw gvlo goklwkto okv bunuam minchisinam go minto: “Oguaingbv Uyu ngv atubonga chara nyudubv? ");
INSERT INTO tgj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mooku gonv yakpin sisula v pami sikubolo hv yagiak reku. ");
INSERT INTO tgj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Vpin gonv yakpin sisula vpin akonyi pami sikubolo, v vpin v yagiak reku. ");
INSERT INTO tgj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Vkvlvgabv uyu gv karv ngv apumbv yakpin sikubolo, v vdwloka hvngdwng mare, vbvrikubolo yagiak reku okv ala ngeriku.” ");
INSERT INTO tgj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Gwlwknv nyi a leepv choma bolo yvvka hvkvgv naam a mvkola aala oguogua naanyu mare; leepv chobo lomwng naam loka naala vnggv nyure.” ");
INSERT INTO tgj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ngo nonua jvjvbv mindu, nyi vdwgv rimur mimur rinam mvnwng okv Pwknvyarnv nyika ogu minyingminchu milin nama mvngnga nyudunv; ");
INSERT INTO tgj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Vbvritola yvvnyiv Darwknv Dow a minyingminchu nvnga vdwloka mvngnga nyumare, oglvgavbolo nw doobwngnv rimur a ripv.” ");
INSERT INTO tgj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jisu gv sum minam si ogulvgavbolo nyi twnggonv, “Nw gvlo darwkmanv dow v doodu” vnam lvgabv.) ");
INSERT INTO tgj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Vbvrinamv Jisu gv, anv la okv boru vdwv vngchito. Bunu naam gv agumlo dakto okv ninyia tvvkarla gaam gamgo milwkto. ");
INSERT INTO tgj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hoka nyitwng go Jisunyi dookarto, okv bunu ninyia minto, “kaalak, noogv anv okv noogv boru vdwv okv noogv bormv vdwv agum v bunu nam dinchipv.” ");
INSERT INTO tgj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisu mirwk suto, “Yvv bunula ngoogv anv ngv? Yvv bunula ngoogv boruv?” ");
INSERT INTO tgj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ninyia dokarnv nyi mvnwngnga nw kaitkarto okv minto, “Kaato! Si bunu ngoogv anv okv boru vdwv! ");
INSERT INTO tgj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yvvbunudw Pwknvyarnv gv mvnglwkbv ridunv hv bunu ngoogv anv, ngoogv bormv, boruv.” ");
INSERT INTO tgj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Lvkodv Jisu Galili Svparsvlv adarlo tamsar rapto. Nw a ho dokarnv nyitwng v achialvbv twngtvto vkvlvgabv nw svpw arwnglo chaala dooto. Svpw v arwng kiambv vnglinto, okv nyitwng v dakto isi sidar biyagilo. ");
INSERT INTO tgj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nw bunua awgo tamsar dvla minchisinam vkv minvla minjito: ");
INSERT INTO tgj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tvvto! Kvvlo nyi ako dooto nw radv chibv vnglinto. ");
INSERT INTO tgj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Vdwlo nw amw vdwa rongolo chiak rapto kudw, kvgonv lamtvlo olinpvto, okv pvta vdwv aala okv hum dvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kvgonv lvngtak lo holula hopvto, hoka kvdw achakgo dooto. Amw v ainbv boklin toku ogulvgavbolo kvdw v rungrwng mato. ");
INSERT INTO tgj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Agar miami v rungrwngbv harlwkku kaama laila vbvrinamv, vdwlo doonyi v chaalin tokudw agar a kaayok toku; okv ogulvgavbolo miami v rungrwngbv kvdwlo aamato, agar v baapubv sintoku. ");
INSERT INTO tgj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kvgonv tvv apumlo holwkto, v singtoku okv agar a yuptoku, okv bunu oguka dape peelin mato. ");
INSERT INTO tgj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kvgonv hooluto kvdw alvyaung kolo, okv agar v baapubv garlinto, singto, okv dape peelin toku: kvgonv dasum chaam go kvgonv chamkv, okv kvgonv lwngbv.” ");
INSERT INTO tgj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Okv Jisu minya toku, “Vbvrinamv, nonuno nyarung doodu nvlo, tvvtoka!” ");
INSERT INTO tgj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Vdwlo Jisu akin tokudw ninyigv minam a tvvnv nyi kvgonv bunu lvbwlaksu vring gola anyi gv lvkobv aala ninyia minchisinama minbwk jilabvkv vtoku. ");
INSERT INTO tgj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jisu mirwksito, “Pwknvyarnv gv rungrwng rungnv Karv gv lvkwng nga nonua jiroku. Vbvritola kvvbinyi vdwv, ogumvnwng nga minchisinam lokv tvvdunv, ");
INSERT INTO tgj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","vkvlvgavbolo, ‘Bunu kaadv-kaadv la kaare, vbvrijvka kaapa mare; okv tvvdv-tvvdv la tvvre, vbvrijvka tvvchin mare. Vkvlvgavbolo bunu chinv guilo bunu Pwknvyarnvnyi dakrwk dukunvpv, okv nw bunua mvngnga jidu kunvpv.’” ");
INSERT INTO tgj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Vbvrinamv Jisu bunuam tvvkato, “Nonu minchisinam sum chimadunvri? Vbvrikubolo nonu oguaingbv kvvbi minchisinam go chindubv? ");
INSERT INTO tgj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Amw paknv Pwknvyarnv gv doin a pakje jito. ");
INSERT INTO tgj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kvgonv nyi v ho lamtvlo amw hosoknam jvbv; bunuv baapubv doin a tvvdasopitda, Uyu ngv aareku okv hung naala vnggvreku. ");
INSERT INTO tgj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kvgonv nyi v amw v lvngtak aolo hopvnam jvbv. Bunuv baapubv doin tvvdasopitda bunu himpula hum tvvrwksito. ");
INSERT INTO tgj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Vbvritola bunulo rungrwngbv aalwk manam lvgalo, okv bunu vdwloka hvngdwng mare vkvlvgabv vdwlo adwkaku v vmalo mvdwkmvku v aarikudw doin lvga lokv, bunu vjakgobv kayudariku. ");
INSERT INTO tgj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kvgunv nyi v tvv hvdwnglo amw holwk nam jvbv rido. So vdw sinv yvv doin ham tvvdunv, ");
INSERT INTO tgj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","vbvritola mvngrudu so singse lvgabv, nyitv lvgabv pakyado, okv nvgwng a mvngbiula nyitwng arwnglo okv doin a ngemu duku, okv bunu asi svlin kumanv. ");
INSERT INTO tgj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Vbvritola kvgonv nyi v alvnv kvdw lo amw paknam jvbv rito. Bunu doin a tvvgapto, hung tvvrwksito, okv asi svlinto: kvgonv chaam bv, kvgonv chamkvbv, okv kvgonv lwngbv.” ");
INSERT INTO tgj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisu minbwngto, “Nyi akonv mvdurrupum ako naalwkla okv hum bati kyampwk takmamla vmalo gadw gv kyampwk lo vvpv dvnvri? Hum tunggingnvnv gv aolo nw vvpv madunvri? ");
INSERT INTO tgj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ogugo vvsi pvdw hum agumlo bvnglinla mvko riku, okv ogugo takmam pvkudw v takmam kumare. ");
INSERT INTO tgj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Vbvrinamv, tvvto nonuno nyarung doodu nvlo!” ");
INSERT INTO tgj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nw bunua lvkodv mindvto, “Alvbv tvvgapto ogugo no tvvpvdw! Ogu kiinvnv lokv no nyi ham jwngkadaka dvdw vbv kiinvnv lokv Pwknvyarnv ka nam jwngkadaka—vbvritola humka kaiyanvgo rire. ");
INSERT INTO tgj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nyi v yvvdw ogugo doodudw hum kaiyago jire okv nyi v yvv ogugoka domapvdw vkvgvlo achukgo doonam haka naarit reku.” ");
INSERT INTO tgj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisu minbwngto, “Pwknvyarnv gv karv ngv svbv rido. Nyi akonv ninyigv rongolo amw paklwkkto. ");
INSERT INTO tgj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nw ayulo yuptoku, alu dukubv v gudung toku, okv vbvririlo amw mvnwngngv boksula okv garrap toku. Vjvka um nw oguaingbv ridu nvdw um chinkuma. ");
INSERT INTO tgj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kvdw v atubongv singnv a singmusido okv asi a svlin mosudo. Atukchochukbv radvdada ngv, okv danv ngv, okv ataranyabv dape mvnwng a kaapado. ");
INSERT INTO tgj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Vdwlo radv ngv kamkubolo, nyi v parap toku hum ninyigv rioktung lokv, ogulvgavbolo rongo mvdw dw v aatoku. ");
INSERT INTO tgj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Pwknvyarnv gv Karv ngv svbv rido vla ngonu oguaingbv minsedw?” Jisu tvuto. “Ngonu hum ogugonyi minchisinvla minbwk jidubv? ");
INSERT INTO tgj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","So si svbv ridu. Nyi akonv yingmw go naato, nyiamooku gv amw charching yachoknv, okv um kvdwlo lvvlwk toku. ");
INSERT INTO tgj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ayungjvma nga v singcha toku okv singnv mvnwngnga kaiyachok nvgobv ritoku. Hv hakbv ngv vbv kairungbv harlin toku ho pvta ngv aala bunugv asup vdwa ho gv doonyum lo suplwk toku.” ");
INSERT INTO tgj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisu ninyigv doina nyi vdwlo japjito, mintaknvto awgo kvvbi minchisinam sibe minvla; nw mintamto bunua vkamgo bunu tvvchin nyodudw. ");
INSERT INTO tgj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nw ogugoka mimato bunua minchisinam mintak mabv, vbvritola vdwlo nw akinpvdw lvbwlaksu vdwa lvkobv, nw ogumvnwng nga bunua minbwk jitoku. ");
INSERT INTO tgj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ho alu akin gv arium hoka, Jisu ninyigv lvbwlaksu vdwa minto, “Klai svparsvlv takdv gonv durap linlaju.” ");
INSERT INTO tgj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Vkvlvgabv bunu nyitwng nga vngyu toku; lvbwlaksu vdwv Jisu gv doolwkku svpw lo aalwk mingvto, okv bunu ninyia bunugv lvkobv vnggv toku. Kvvbi svpw vdwvka hoka dooto. ");
INSERT INTO tgj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dvminmabv kairungbv doori v rirapto, okv sikiok v svpw arwnglo kioklwkto, vkvlvgabv isi v hoka yarbing tvvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisunyi svpw arwng gv koching kiambv dooto, nw domtom golo dumpo ngv dumpv tola yupminto. Lvbwlaksu vdwv ninyia muuto okv minto, “Tamsarnv, no ngonua mvngpa kumare ngonu sida jiku nvlaka?” ");
INSERT INTO tgj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisu dakrapto okv dooria mintoku, “Choibv dooto!” Okv nw minto sikiok aka, “Doochingbv dooto!” Doori v ringin toku, hoka kairungbv jematai toku. ");
INSERT INTO tgj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Vbvrikunamv Jisu ninyigv lvbwlaksu vdwa minto, “Ogubv nonu busu nyadunv? Vjaklodvbv nonu nga mvngjwng malare?” ");
INSERT INTO tgj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Vbvritola bunu achialvbv busuto okv akonv akonyi mimisito, “Yvvla so nyi si? Doori vla sikiok hvka ninyia tvvdu!” ");
INSERT INTO tgj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisu okv ninyigv lvbwlaksu vdwv vngchi toku Gerasa mookugv Galili svparsvlv takdvlo, ");
INSERT INTO tgj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Vdwlo Jisu svpw lokv korlin sopikda nw kaapato nyigo hv nyibung bungpam hoka lvngpwk lokv linvgo. So nyi si alvmanv dow gvnvgo. ");
INSERT INTO tgj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Okv nyibung bungpam lo doonvgo yvvka ninyia rwngja ngv vdwloka leepv nyumato; ");
INSERT INTO tgj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Vdwnvgo ninyigv lvpa okv laak a leepv kwtoku, vbvritola leeri gv dwkibv nw rvngja nga dokpwkla mvmwkmvmakto ninyigv lvpa gv riokdar haka. Nw achialvbv gwlwkrongto yvvka ninyia naatung nyumato. ");
INSERT INTO tgj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Alu okv ayubv nw nyibung bungpam lo vngkarto okv moodw lokv, segok karto okv vlwng ngv atua tupsuto. ");
INSERT INTO tgj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nw mego aduto vdwlo Jisunyi kaapa tokudw; vkvlvgabv nw joklwk toku, ninyigv kaagialo lvbwng ngv kumpvla, ");
INSERT INTO tgj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Okv gamtvrongbv segokto, “Jisu, Kaiyachoknv Pwknvyarnv gv kuunyilo! No ngoogvlo ogugo mvngdu? Pwknvyarnv gv amin bv, nam ngo koodunv, nga mvrit mabvka!” ( ");
INSERT INTO tgj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nw svbv minto ogulvgavbolo Jisu mintoku, “Alvmanv dow, so nyi sokv liro tokuka!”) ");
INSERT INTO tgj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Vkvlvgabv Jisu ninyia tvvkato, “No gv aminv ogu vla?” Nyi angv mirwkto, “Ngoogv aminv ‘(Mob)’ nyitwng—ho ngonu twngtv nvgo!” ");
INSERT INTO tgj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Okv nw Jisunyi alvmanv dow vdwa ho mooku loka adu lo vngmu mabvka vla kodwkkrwkla koola minto. ");
INSERT INTO tgj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hoka kairungbv vrik riktwng go moodw nvchi hoka dvla reto. ");
INSERT INTO tgj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Vkvlvgabv dow v Jisunyi kooto, “Ngonua riktwng alo vngmulabvka, okv ngonua bunu gvlo aalwk molabvka.” ");
INSERT INTO tgj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisu bunua vngmuto, okv alvmanv dow v ho nyi lokv lintoku okv riktwnglo aalwk toku. Riktwng mvnwngngv lvngring anyi dvsegobv vrik v rito-chapchar minsula svparsvlv kiambv taraklo holula okv svparsvlv arwngbv holwk toku. ");
INSERT INTO tgj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vrik ka kaayanv vdwv joklakula banggu lo okv rongolo minggo kartoku. Hv ogubv ripv nvdw vla nyi mvnwngngv vnglinla kaatoku, ");
INSERT INTO tgj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","okv vdwlo bunu Jisu gvlo aatokudw, bunu alvmanv dow atwng go gvvkinv nyi um kaapa toku. Nw hoka dooto, vjikotoku okv mvngnam rinam v alvtokula; okv bunu mvnwng v busu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Alvmanv dow vdwgv lvkobv nyi angv um ogubv ripvnvdw okv vrik vdwgv lvkwng bvka kaanv vdwv nyi vdwa mintam nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Vkvlvgabv bunu Jisunyi bunugv mooku lokv vngro tokukv vtoku. ");
INSERT INTO tgj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisu gv svpwlo aalwkrilo, nyi alvmanv dow vdwa gvvnv nyi angv ninyia kooto, “Ngamka noogv lvkobv vngmulabvka!” ");
INSERT INTO tgj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Vbvritola Jisu ninyia vngmumato. Vbvmabvdv, nw ninyia minto, “Ahtu noogv lvgabv vdwgo ripv kudw okv vdwgo aya pvkudw no noogv naam lo vnglakula nyi vdwa mintam jilakuka.” ");
INSERT INTO tgj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Vbvrinamv ho nyi v vnglaku Jisu gv ninyia ogugo ripvdw hum Banggu Vring nyi lo minggojitoku, hoka nyi mvnwngngv tvvtokula lamngak nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisu vngkorla vngrap toku svparsvlv takdv gonvlo. Ho svparsvlv hoka kairungbv nyitwng go ninyia vngkumla dooyumto. ");
INSERT INTO tgj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairus, Jius kumkunaam gv nyigam gobv rinv aalwkto, okv vdwlo nw Jisunyi kaapa pvdw, nw atubongv Jisu gv lvpa lvkwnglo gilwk toku ");
INSERT INTO tgj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Okv dinchi rungbv ninyia kooto, “Ngoogv kuunyijar angv achialvbv lvvmapv. Ayala aagvrila noogv laak v ninyia mampo jilabv, vbvribolo nw poyariku okv turreku!” ");
INSERT INTO tgj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Vbvrinamv Jisu ninyia lvkobv vngrap mingv toku. Twngtv rungnv nyi go Jisunyi lvkobv vngming gvto hoka vngku dvdvlo ninyia nyitwng ngv kaiyaya bv vngyumto. ");
INSERT INTO tgj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hoka mvvga ako nyingring gola nyingnyi achialvbv oyi sarla silvmanv go dooto, ");
INSERT INTO tgj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Daktor achialvgo ninyia vdwnv dw go mvkwrikw toku. Nw atugv morko mvnwngnga mva tvku, vbvritola alvyaku svnga nw alvmabvya riayaya toku. ");
INSERT INTO tgj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nw Jisu gv lvkwng a tvvpato, vkvlvgabv nw ninyigv adar ayi nyitwng gv arwnglo aato, ");
INSERT INTO tgj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Atu v minsuto, “Ngo ninyigv vji a mvsit bolo, ngo poyariku.” ");
INSERT INTO tgj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nw Jisu gv vji a mvsit toku, okv ninyigv oyi sarnam v ho vjakgobv nyedatoku; okv nw atu v arwnglo himpa sitoku nw adwkaku lokv poya kunam a. ");
INSERT INTO tgj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Vjakgobv Jisu ninyigv lokv mvpunvnv go linyi bv vla himpa sito, hoka nw dakyitkarla kaakarto nyitwng a okv tvuto, “Yvvla ngoogv vji a mvsit nvngv?” ");
INSERT INTO tgj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ninyigv lvbwlaksu vdwv mirwkto, “No kaatoka vkamgo nyi nyitwng ngv nam lvvbum nama; ogubv no tvvka doonv yvvla nam mvsit nvngv vla?” ");
INSERT INTO tgj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Vbvritola Jisu kai tacha karla kaakarto yvvbvri rinvsi vla. ");
INSERT INTO tgj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mvvga angv dwdw toku ogugo ninyia ripvkudw, vkvlvgabv nw busu v jinjinrumrumla aato, Jisu gv lvpalo guplwkto, okv ogumvnwng nga jvjvkvlv bv ninyia minpa toku. ");
INSERT INTO tgj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisu ninyia mintoku, “Ngoogv kuunyijar, noogv mvngjwng ngv nam mvpu pvku. Sarsopoyo bv vngnyi kulaka, okv noogv hindwkhingku lokv poya lakuka.” ");
INSERT INTO tgj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisu gv svbv minri hoka, Jairas gv naam lokv nyitampingko mego ho aalwkla okv Jairasnyi minpa toku, “Noogv kuunyijar v siro. Ogujego tamsar nvnyi mindwkminku dunv?” ");
INSERT INTO tgj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bunu ogugo minpvdw Jisu tvvriamato, vbvritola ninyia minto, “Busu mabvka, mvngjwng mvnglaka.” ");
INSERT INTO tgj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Vbvrikunamv nw Pitar, Jems okv ninyigv boru Jon nyimwng ninyigv lvkobv vngmuto, yvvnyika vnggv mato. ");
INSERT INTO tgj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bunu Jairas gv naamlo vngchi toku, hoka achialvbv kapku nama siinyimar rinam a okv ogu kaagartapa madubv rinam vdwa Jisu kaatoku. ");
INSERT INTO tgj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nw arwnglo aala bunua minto, “Ogubv svbv kaagartapa madubv rinya dunv? Ogubv nonu kapdunv? Vmi si sima laka—nw yumwng dvlaka!” ");
INSERT INTO tgj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bunu ninyia nyarji nyato, vkvlvgabv nw bunu mvnwngnga agumlo nvnglintokula, vmi gv anvabua okv ninyigv lvbwlaksu aom a aagvla, vmi gv karku karchung arwngbv aatoku. ");
INSERT INTO tgj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nw vmi nyijar a laak lokv gakbwngto okv ninyia minto, “Talita koum,” So minamsi, “Vmi nyijar, ngo nam mindunv gudung tokuka!” ");
INSERT INTO tgj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nw vjakgobv gudung toku okv vngcharvngyar raptoku. (Nw nyingring gola nyingnyi kunvgo.) Vbvriri hoka, bunu mvnwngngv lamngaknyato. ");
INSERT INTO tgj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Vbvritola Jisu kadwk rungbv bunua minto yvvnyika minpa mabvka, okv nw minto, “Ninyia dvnam ogugo jigvrila dvmuto.” ");
INSERT INTO tgj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisu ho mooku a kayupila okv atugv banggu naamlo aakur toku, ninyigv lvbwlaksu vdwv vngming gvto. ");
INSERT INTO tgj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jius Doonualu lo kumkunaamlo nw tamsar raptoku. Ho nyi v achialvbv dooto; okv vdwlo bunu ninyigv lokv tvvtokudw, bunu mvnwngngv lamtoku. “So mvnwng sum nw ogolokv paapv nvdw?” Bunu tvvkato. “Ninyia si ogunv mvngkimvnglak go jipvkunvdw? Ogu ayimbv nw lamrwpanam vdwa rila kaatam dunvdw? ");
INSERT INTO tgj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nw yikungyira mvnv, Meri gv kuunyilo, okv Jems, Josep, Judas, okv Saimon gv abwng mangvri? Nw gv bormv vdwv soka dooma dunvri?” Okv vkvlvgabv bunu ninyia toa toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisu bunua minto, “Nyijwk a mooku mvnwnglo mvngdvdo, mvngdv makuv nw atugv dooku banggu lo okv amiasa lo okv ninyigv ugunyi mvngchiklo.” ");
INSERT INTO tgj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nw hoka lamrwpanam go rila kaatam nyumato, hoka nw lvvmanv nyi mego gv ao lo laak lakpvto okv bunua mvpu jimwng toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nw kairungbv lamtoku, ogulvgavbolo nyi vdwv mvngjwng nyamato. Vbvrikunamv Jisu hoka nampum dvdvlo vnggokarla nyi vdwa tamsar toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nw lvbwlaksu vring gola anyia lvkobv goklwkto okv bunua anyi-anyibv vnglin motoku. Nw bunua alvmanv dow vdwa yaanvnv jwkrw a jitoku ");
INSERT INTO tgj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","okv bunua minto, “Nonugv mooying vngkulo bangngi mvngchik a bvnglaka ogugoka gvyoka—vtwng guka gvyo, giagonv kochak a gvyo, noogv jvkap lo morko guka gvyoka. ");
INSERT INTO tgj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lvkiam gvlaka, vbvritola kvvbi jekok lvvyago gvyoka.” ");
INSERT INTO tgj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nw mindvto, “Ogolo nonua alvbv aamudvdw, ho naam lo nonu dooto laka, ho mooku lokv vnglinma dvdwbv. ");
INSERT INTO tgj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nonu banggu lo aabolo hoka nyi vdwv nonua alvbv aamu mabolo vmalo minam a tvvria mabolo, um kayulaka okv lvpa gv amukayuk a pakak jilaka v bunua gamrw rwkjinam gubv rire!” ");
INSERT INTO tgj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Vkvlvgabv bunu vnglin nyatoku okv nyi vdwa rimur lokv lirung tokukv vla japji toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bunu uyuvram achialvgo charkak toku, okv lvvmanv nyi achialvgo olib tvli piaktoku okv bunua mvpu toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","So mvnwng gv lvkwng nga vjak Herod Dvbv tvvpa toku, ogulvgavbolo Jisu gv singnamrinam mv mvnwnglo dupwng toku. Nyi kvgonv minto, “Jon Baptist gvlo turnam v aakurpvku! Vkvlvgabv nw so jwkrw lokv lamrwpanam kaatamdo.” ");
INSERT INTO tgj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kvgonv vbv minyato, “Nw Elija.” Kvvbigonv minto “Nw nyikrwkaanv go, Kvlokvcho gv nyikrwkaanv vdwlokv akonv jvbv kaanam go.” ");
INSERT INTO tgj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Vdwlo Herod um tvvpapvdw, nw minto, “Nw Jon Baptist bri! Ngo ninyigv dumpo nga paa-pvkunv, vbvritola nw turkur pvkui!” ");
INSERT INTO tgj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod nw atu v mingap gvrila Jonnyi naatung moto, okv nw ninyia jaako lvktola okv patwk arwnglo tumto. Herod gv svbvrinam si Herodias gv lvkwnglo, yvvnyi nw nywngbv mvpvdw, ninyigv boru Pilip gv nywngbv rijeka. ");
INSERT INTO tgj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon Baptist minbwngto Herodnyi, “Si no alvrima noogv boru gv nywng nga atu nywngbv mvsunam si!” ");
INSERT INTO tgj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Vkvlvgabv Herodias Jonnyi maatarbv tanyum gvto okv ninyia mvkidubv mvngto, vbvritola Herod gv lvkwnglo nw milin nyumato. ");
INSERT INTO tgj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod Jonnyi busuto ogulvgavbolo nw chinto Jon alvnvgo okv darwknv nyi go vla, okv vkvlvgabv ninyia ogu mvmabv alvbv doomuto. Nw dw mvnwnglo ninyi gvlokv tvvla kairungnv adwkaku nvgobv rijeka, ninyi gvlokv tvvnwng dvto. ");
INSERT INTO tgj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Anyungnga Herodias alvnv dw go paatoku. Hv vbv rito Herodnyi kuubvngdw alulo, nw sorkari nyigam kainv mvnwngnga, sipai nyigam gamtvlvbwng vdwa okv Galili lo nyi rigvdakgvla kairungnv vdwa nvlum dvpam pamgvrilo. ");
INSERT INTO tgj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias gv kuunyijar aato okv naasi rijito, okv Herod nyila ninyigv nyen vdwa mvngpu dubv mvtoku. Vkvlvgabv dvbv ninyia minto, “No ogugo mvngdu? No ogugo koodudw nam ngo jirungre.” ");
INSERT INTO tgj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hoka nw awgo milvnam go mintakla ninyia minto, “Ngo milvla mindunv no ogugo koopvdw ngo jirungre, minbinla ngoogv karv patung gunyi minjeka!” ");
INSERT INTO tgj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Vkvlvgabv nyijar v vnglintoku okv ninyigv anv nga tvvkato, “Ngo ogugo koose ngvdw?” “Jon Baptist gv dumpo ngakv,” Anv ngv mirwkto. ");
INSERT INTO tgj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nyijar angv dvbv gvlo baapubv vngkur toku okv koorap toku, “Ngo nam vjak svka Jon Baptist gv dumpo nga taali gulo jilabvkv vla mvngdunv!” ");
INSERT INTO tgj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Si dvbvnyi achialvbv mvngru motoku vbvritola nw maakv vlakumato ogulvgavbolo ninyia nw nyen vdwgv dookulo milv kunam lvkwngbv. ");
INSERT INTO tgj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Vkvlvgabv nw dakyakaya nvnga Jon Baptist gv dumpo nga baapubv bvnglwk tvka vla orto jigvrila vngmu toku. Dakyakaya nvngv vngla, Patwklo aalwk laku, okv Jon gv dumpo nga palin toku; ");
INSERT INTO tgj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Vbvrikunamv nw taali gulo bvnglwk toku okv um nyijar a jitoku, nyijar angv um atugv anv gvlo bvnglwk jitoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Vdwlo Jon gv lvbwlaksu vdwv um tvvpa tokudw, bunu aatoku okv ninyigv svma ngam gvvlaku okv um nyibung riitoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostol vdwv aakum toku okv Jisunyi lvkobv kaarwksuto, okv bunu ogugo ripvkudw okv tamsar pvkudw ninyia minpa toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hoka nyi v achialvgo aanv aadu okv vngnv vngdu mvkunamv Jisu la ninyigv lvbwlaksu vdwv dvnam dvdubvka dw kaaku mato. Vkvlvgabv nw bunua minto, “Klai mvnwngngv vnglaju ngonu mvngwngbv mooku golo hoka ngonu mvngchikre okv nonuno achakgo doonu ladubv.” ");
INSERT INTO tgj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Vkvlvgabv bunu atuv jemataiku mooku lo vngdubv vla svpw gulo vngrap nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bunugv vngnam a okv bunu yvvdw um nyi achialvgo kaapato okv chinyato, vkvlvgabv nyi vdwv bunu banggu mvnwng lokv kvdw bv vngla Jisu gvla ninyigv lvbwlaksu vdwgv vnglwk jikulo aachi choyato. ");
INSERT INTO tgj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Vdwlo Jisu svpw lokv lintokudw, nw so nyi nyitwng nga kaapa toku, okv nw gv haapok v bunua aya mvngpato, ogulvgavbolo bunu svlar a rigvnv kaamanv aingbv rinyato. Vkvlvgabv nw bunua achialvgo tamsar raptoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Vdwlo achialvnv dw gubv ritokudw, ninyigv lvbwlaksu vdwv ninyi gvlo aala minto, “Si jemataiku mooku go, okv so ngonu achialvgo dootokubv. ");
INSERT INTO tgj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nyi vdwa vngmu tokuka, okv bunua vngmula nvchi gv rongo vdwlo okv nampum vdwlo bunu atu v dvnam rvvla dvsu dubv,” ");
INSERT INTO tgj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Nonu atu v bunua dvse go jitoka” Jisu mirwksito. Bunu tvuto, “No ngonua vngla okv ain lokdwng lvngnyi lokv vtwng rvvla bunua dvmu svgo mvngduri?” ");
INSERT INTO tgj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Vkvlvgabv Jisu bunua tvuto, “Nonuno vtwng vkamgo doopv? Vngla kaateka.” Vdwlo bunu paato kudw, bunu ninyia, “Vtwng tangu gula okv ngui nvvnyi guka paapv,” vla mintam toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisu vbvrikunamv ninyigv lvbwlaksu vdwa minto nyi mvnwngnga nvmwng yajinv aolo apum-apum bv dopindoin motoka. ");
INSERT INTO tgj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Vkvlvgabv nyi vdwv apum-apum bv doonyala pamkin lo nyi lvnggobv okv chamngu gubv doonyato. ");
INSERT INTO tgj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Vbvrinamv Jisu vtwng tangu hala ngui nvvnyi a naatoku, nyidomooku bv kaadungto, okv Pwknvyarnvnyi umbonyikv vtoku. Nw vtwngnga pimwk toku okv nyi vdwa ortokv vla ninyigv lvbwlaksu vdwa jitoku. Nw ngui nvvnyi haka nyi mvnwngnga ortoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nyi mvnwng v dvgudubv dvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vbvrikunamv lvbwlaksu vdwv vtwng okv ngui dvlv nga paapi vring gola anyigo naakum toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Dvnv dvdv ngv nyiga ngv hejar angu gobv ritoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisu nw nyipam a vngmu rikulo, lvbwlaksu vdwa svparsvlv gv takdv gonv Betsaida lo vngcho moodubv vla svpw gulo baapubv aamu toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nyi vdwa alvbv vnglakukv vla minro kochingbv nw moodw lo kumdubv chaatoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Vdwlo arium tvkudw, svpw v svparsvlv gv aralo dooto, vbvritola Jisu dvpwlo akin bv rito. ");
INSERT INTO tgj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nw ninyigv lvbwlaksu vdwa svpw a pullo ngv tormisidu bv kaapato, ogulvgavbolo doori v bunu gvlo rilwkto; vkvlvgabv aru gv aom gvla akv baji gv pingkolo, nw isi ao bv vngla bunu gvlo aatoku. Nw bunua vngbo yatvto, ");
INSERT INTO tgj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","vbvritola bunu ninyia isi ao lo vngkar dubv kaatoku. Bunu mvngtoku, “Si vram go!” okv svgok toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bunu vdwlo ninyia kaapa tokudw bunu achialvbv busu nyatoku. Jisu vjakgobv bunua mintoku, “Mvngrw tvka!” “Si ngo sumabv, busu mabvka!” ");
INSERT INTO tgj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Vbvrinamv nw bunua lvkobv svpwlo aatoku, okv doori v ringin toku. Lvbwlaksu vdwv achialvbv lamngak nyatoku, ");
INSERT INTO tgj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ogulvgavbolo hejar angu a dvnam dvmunam gv arwng gv jvjv nga bunu chimato; bunugv mongrumara ngv um chindubv kamchi madvto. ");
INSERT INTO tgj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bunu svparsvlv nga rapbo toku okv Gennesaret kvdw hoka aatoku, hoka bunu svpwa takpvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Vbv bunu svpw a vngyurilo, nyi vdwv Jisunyi vjakgobv kachindato. ");
INSERT INTO tgj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Vkvlvgabv bunu ho mooku mvnwnglo joklakula; okv ogolo nw doopv vla tvvpa pvkudw, bunu lvvmanv nyi vdwa bunugv kargianvnv lo karmutvla ninyi gvlo aagv toku. ");
INSERT INTO tgj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Okv Jisu gv vngku dvdvlo nampum vdwlo, banggu vdwlo, vmalo rongo vdwlo, nyi vdwv nw bunugv lvvmanv nyi vdwa piokpamdorpamlo aagvla ninyia kodwkkrwkla kooto mamavjeka lvvmanv vdwa ninyigv vji jelap a mvsit moobvkv vla. Okv yvv bunu um mvsit pvkudw bunu pooya nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jerusalem lokv aanv Parisis okv Pvbv tamsarnv mego aadum sila Jisunyi dooyumto. ");
INSERT INTO tgj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bunu ninyigv lvbwlaksu megonyi lasok mabv dvnam ham dvdubv kaapa toku, vbvrinam v ribu mato—ho v, bunu Parisis vdwgv nyi v vbvritoka vnam aingbv bunu lasok mato. ");
INSERT INTO tgj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisis vdwv, Jius kvgonv vdwvkam, abuapa gv tamsarnam lokv rimingvto: bunu alvyaungbv lasok mabo loka dvnam dvmato; ");
INSERT INTO tgj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","vmalo bunu bajar lokv aanv ogu-ogu a harkak chomalo dvmato. Okv bunu bunugv chinam achialvbv kvvbi ribu vkv riming gvtato vbv rito, koobu vdwa, pvchwng vdwa, talu vdwa, okv gadw vdwa alvyaungbv harkaknam.) ");
INSERT INTO tgj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Vkvlvgabv Parisis vdwv okv Pvbv tamsarnv vdwv Jisunyi tvvkato, “Noogv lvbwlaksu vdwv ngonugv abuapa vdwgv tamsarla jilu nama riming gvmabv, vbvritoa lasok mabv dvnam a dvnam si ogubv ridunv?” ");
INSERT INTO tgj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisu bunua mirwkto, “Aijaya nonugv lvkwngbv nyikrw kaapv namv vdwgo jvjv rungpvku! Nonuno kaakudubvrinv, vbv ninyigv lvknam aingbv: ‘Pwknvyarnv mindu, so nyi vdw si, ngam gamchar lokv mwng mvngdvdu, vbvritola jvjvbv bunugv haapok v ngam adudo. ");
INSERT INTO tgj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bunugv ngam kunamjonam v bunugv lvgabv ogu anyung kaamanvgobv rinyadu, ogulvgavbolo bunu nyi gv mvnam pvbv nga ngoogv pvbv aing gubv tamsardo!’ ");
INSERT INTO tgj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Nonu Pwknvyarnv gv gamki nam a gakye pvvtola okv nyi gv tamsar kolo vngyadu.” ");
INSERT INTO tgj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Okv Jisu minbwngto, “Nonuno nyebabala Pwknvyarnv gv Pvbv nga tua yatola, bununo atugv tamsar nama bvngya dubv vla ridu. ");
INSERT INTO tgj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses gamkito, ‘Nonugv Anv okv nonugv Abua mvngdv laka,’ okv, ‘yvvbunudw atugv Anv vmalo atugv Abua alvmabv beedunv hum sidubv mvreku.’ ");
INSERT INTO tgj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Vbvritola nonu tamsardo ho nyi v ninyigv anv okv abua ridur nvdubv ogugo doopv tvla, vbvritola minam v, ‘So si Korban’ (hv minam v, si Pwknvyarnv gv rise ngv ngokv yama), ");
INSERT INTO tgj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nw ninyigv anv vmalo abua ridur svngv lokv mvngnga suduku. ");
INSERT INTO tgj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","So apiabv nonugv nyi vdwa tamsar sarlwknamv Pwknvyarnv gv gamchar a milamia yadu. Okv ho apiabv kvvbi rinam vka achialvbv nonu ridu.” ");
INSERT INTO tgj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Vbvrinamv Jisu lvkodv nyitwng go goklwk tvla okv bunua minto, “Nonu mvnwngngv, ngoogv minam a tvvria tvka, okv chinlaka. ");
INSERT INTO tgj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Agum lokv ogu-ogu v nyi gv arwnglo aanv hv ninyia darwk madubv mvla madunv. Vmabvyadv, so si nyi gv lokv ogu-ogu linv hv nyi a darwk madubv mvya dunv.” Tvvto laka, hvbvrikunmv, nonuno nyarung doodu nvlo. ");
INSERT INTO tgj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Vbvrikunamv, tvvtoka, nonu nyarung gvdubolo. ");
INSERT INTO tgj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Vdwlo nw nyitwng ham kayu pikula okv naamlo vngtoku, nw gv lvbwlaksu vdwv so gv minam sum minbwk jilabv vla ninyia tvuto. ");
INSERT INTO tgj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisu mintoku bunua, “Nonuno yvv kvvbinyi aka chilvyama,” “Nonu chima? Nyi a agum lokv arwnglo aanv ogu-ogu hv jvjvbv ninyia ogugoka darwk madubv mvlama, ");
INSERT INTO tgj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ogulvgavbolo si ninyigv haapok lo aamadu vbvritola ninyigv leit arwnglo okv vbvrinamv ayak lokv agum liyadoku.” (Svbv mindula, Jisu minbwk jito dvnam dvdv ngv alvdu dvdubv.) ");
INSERT INTO tgj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Okv nw minbwngla minto, “So si ogugo nyi arwnglokv agum linv hv yadv ninyia darwk madubv mvdu. ");
INSERT INTO tgj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Arwng lokv, nyi gv haapok lokv, alvmanv nga mvnglindu hv ninyia gwngmursingmur ridung nga rimudu, chorit modu, mvki modu, ");
INSERT INTO tgj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kvvbi gv nywngnyilu nga kaabiu modu, dvgum mola, okv alvmanv dvdv nga rila; dvkupdvritla, konurvnvla, Tanyumtakitla, mvngyakayala, kaimvngsula, okv riporiola ");
INSERT INTO tgj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","So mvnwng si alvmanv ngv nyi gv arwng lokv lindu okv ninyia darwk momadu.” ");
INSERT INTO tgj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Vbvrinamv Jisu vngyula vnglintoku Taire gv pamtv mooku adarlo. Nw naam gulo aatoku okv ninyia hoka doopv vla yvvnyika chingku nwngmagvri, vbvritola nw doosi nyumatoku. ");
INSERT INTO tgj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nyimvmvvga go, ninyigv kuunyijar a alvmanv dow naanamgo, Jisunyi tvvpato okv vjakgobv ninyi gvlo aato okv ninyigv lvpalo gilwkto. ");
INSERT INTO tgj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nyimvmvvga angv Jentail go, Sairia gv Poenesia mooku lo bvngnam go. Nw Jisunyi koodwkkrwkla kooto ninyigv kuunyijar lo alvmanv dow a charkak jilabv vla minto. ");
INSERT INTO tgj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Vbvritola Jisu mirwksito, “Klai ngonu vmi vdwa dvmu cholaju. So si alvbv rima vmi gv dvnam a dvritla okv iki vdwa orjinamv.” ");
INSERT INTO tgj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Tamsarnv,” Nw mirwksito, “iki vkadv vmi gv dvgianvnv Tebul lvkwnglo dootola dva nama dvriadu!” ");
INSERT INTO tgj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Vkvlvgabv ninyia Jisu minto, “Ho mirwk sinam lokv, no naambv vngkur nyiku laka, hoka no kaapare uyu gv dow v noogv kuunyijar lokv liro kunam a!” ");
INSERT INTO tgj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nw naambv vngtoku okv kaapato ninyigv kuunyijar a gadw lo kardubv; alvmanv dow v jvjvrungbv ninyia kayupila vngrotoku. ");
INSERT INTO tgj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Vbvrikunamv Jisu Taire gv namrwk a vngyula okv Sidon gv Galili svparsvlv nga vngpitla, pamtv vring gv lamtvlo vngdungrilo. ");
INSERT INTO tgj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nyi megonv nw gvlo nyi ako aagvjito hv rungji okv milin nyumabv minvgo, okv bunu Jisunyi kodwkkrwkla kooto ninyigv laak v nyi agv aolo lakpv jilabv vla. ");
INSERT INTO tgj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Vkvlvgabv Jisu nyi hum nyitwng lokv serwlaila ninyigv lakching ngv nyi agv nyarung nga chilwkto, okv nw atubogv lakchinglo chorbiak gvrila ninyigv riu ha mvsit to. ");
INSERT INTO tgj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Vbvrikunamv Jisu nyidomooku tolo kaadung tvla, achialvbv sagwngto, okv nyi anga minto, “Ephphatha,” So minamsi, “Tvvpa tokukv!” ");
INSERT INTO tgj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Vjakgobv nyi angv tvvpa nyula toku, vkvgv gangkakla minam v nyetoku, okv nw miraptoku ogu mintupminchi kaakumabv. ");
INSERT INTO tgj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Vbvrikunamv Jisu nyi vdwa orto jitoku so sung yvvnyika minpa mabvka; Vbvritola nw bunua mimabvkv vla vdwgo orto jikubvdw, bunu kaiyayabv minbv toku. ");
INSERT INTO tgj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Okv hum tvvpanv mvnwngngv lamrwpabv tvvto. “Oguaingbv nw alvrungbv ogumvnwng nga ridapvnv gubvri!” Bunu mvngpula gokto. “Nw rungji nvnga tvvpa dubv okv gangkak nvnga japdubv, mvrungdu!” ");
INSERT INTO tgj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Achakgo ayungjvma nga kainv nyitwng kvvbigo aadumsito. Vdwlo nyi vdwv oguka dvse kaaku mato kudw, Jisu lvbwlaksu vdwa ninyigvlo goklwkto okv minto, ");
INSERT INTO tgj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ngo aya mvngpadu so nyi vdwgv lvgabv, ogulvgavbolo bunu nga lvkobv remin gvkunamv alu loum pvku okv vjak oguka dvse kaakuma. ");
INSERT INTO tgj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ngo bunua dvnam dvmumabv bunua naam lo vngmu kubolo, bunu vngkulo bunu anyu kumare, ogulvgavbolo bunu megonv adu lamtv lokv aato.” ");
INSERT INTO tgj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nw gv lvbwlaksu vdwv ninyia tvvkato, “Vbvritola nyi vdwsum chukrimooku arwng soka yvvla dvnam dvgubv dvmu svgo paanyujinv?” ");
INSERT INTO tgj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Nonugvlo vdwgo vtwng doopv?” Jisu tvvkato. “Vtwng takkanw go,” bunu mirwkto. ");
INSERT INTO tgj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nw nyitwng a kvdw aolo doodubv minto. Vbvrikunamv nw vtwng kanw a naatoku, Pwknvyarnvnyi umbonyika hvto, vtwng nga pinpinpiinto, okv nyitwng nga orpinoryin dubv ninyigv lvbwlaksu vdwa jitoku; okv lvbwlaksu vdwv vbv rijito. ");
INSERT INTO tgj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bunu gvlo achokgo ngui miyangnv vkv dootato. Jisu umbonyika hvto ho hung okv lvbwlaksu vdwa bunua ortadubv mintoku. ");
INSERT INTO tgj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mvnwngngv dvtoku okv dvguto—hoka nyi v nyigagaatv dvdv ngv hejar api gobv rito. Vbvrikunamv lvbwlaksu vdwv pintungpiung dvlv nga paapi kanw go yarpok dubv naapv toku. Jisu nyi vdwa vngmutoku ");
INSERT INTO tgj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","okv vjakpi gobv ninyigv lvbwlaksu vdwa lvkobv svpw akolo aatoku okv Dalmanutha mookulo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisis kvgonv Jisu gvlo aato okv ninyia lvkobv larmi surapto. Bunu ninyia naatung dubv, vkvlvgabv bunu ninyia tvvkato lamrwpanam go kaatam labvkv ho kaapadubv Pwknvyarnv ngv ninyia yarlwknama. ");
INSERT INTO tgj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Vbvritola Jisu haang arwng lokv sakwla okv minto, “Ogulvgabv silugv nyi vdwsi lamrwpanam go rito vla tvvka dunv gubvre? Maa, ngo nonua mindunv! Svkvnv kaachin nvnvgo jimare so nyi vdwa!” ");
INSERT INTO tgj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nw bunua vngyula, svpw arwnglo aakur lakula, okv vngrap toku svparsvlv gv takdv gonvlo raptoku. ");
INSERT INTO tgj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lvbwlaksu vdwv vtwng dvgudvbv bvnglwk svnga mvngpa kuma toku okv vtwng takin gomwng bunugv lvkobv svpw hoka gvlwkto. ");
INSERT INTO tgj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","“Hintolaka,” Jisu bunuam gamrwto, “Okv nonuno atu v Himasulaka Parisis vdw gvla okv Herod gv vpap am.” ");
INSERT INTO tgj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bunugv arwnglo bunu atubongv japrap minsuto: “Nw sum mindo ogulvgavbolo ngonu gvlo vtwng kvvbigoka kaakuma.” ");
INSERT INTO tgj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisu chinto bunugv ogu gunyi minpvkudw, vkvlvgabv nw bunuam tvvkato, “Ogulvgavbolo nonuno ogu dvnam gvma vla raamisidunv? Nonuno chima vmalo vjakka chimare? Nonuno haang ngv achialvbv pvchapvnv ai? ");
INSERT INTO tgj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nonuno nyik doodu—nonu kaapamadu nvri? Nonuno nyarung gvdu—nonu tvvpa madonvre? Nonu mvngpa madunvri ");
INSERT INTO tgj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","vdwlo ngo hejar angu nyi vdw lvgabv vtwng tangu a pintak piyak ika? Vdw paapi akomaring nvgo pintungpiung dvlv nga nonuno naakumpv?” “Vring gola anyi,” bunu mirwkto. ");
INSERT INTO tgj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Okv vdwlo ngo hejar api nyi vdw lvgabv vtwng takkanwa pintak piyak ika,” Jisu tvvkato, “Vdw paapi akomaring nvgo Pintungpiung dvlv nga nonuno naakumpvnv?” “Kanw go,” bunu mirwkto. ");
INSERT INTO tgj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Okv vjaklodvbv nonuno chimadunvri?” Nw bunuam tvvkato. ");
INSERT INTO tgj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bunu Betsaida lo aatoku, ho hoka nyi twnggonv nyi nyikchingnv ako Jisu gvlo aagvjito okv ninyia gaksit jibvkv vla kodwkkrwkla kooto. ");
INSERT INTO tgj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisu nyikchingnv nyi hum laak lokv svla ila okv ninyia nampum agum bv vnggvto. Nw nyi vkvgv nyik a chorbiakro kochingbv, Jisu ninyigv laak v nyigvlo lakpvto okv nw a tvvkato, “No ogugo kaapa lado kure?” ");
INSERT INTO tgj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nyi angv moorapla kaato okv minto, “Vvm ngo nyi vdwa kaapa ladoku, vbvritola bunu singnv aingbv vngyit kardu.” ");
INSERT INTO tgj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Lvkodv Jisu ninyigv laak v nyi vkvgv nyiklo mampvto. So dw lo nyi angv kaanwngla kaarapto, ninyigv nyik kaapa nvnv ngv aatoku, okv nw ogumvnwng nga kaabwk toku. ");
INSERT INTO tgj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Vbvrikunamv Jisu nyi hum, “Nampum arwng bv vngkur kuyoka” vla minggap gvrila naam bv vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Vbvrikunamv Jisu okv ninyigv lvbwlaksu vdwv Kaisaria Pilippi nampum adarlo vnglintoku. Lamtv vngtunglo nw bunua tvvkato “Nga minpato, nyi vdwv nga yvv vla mindu?” ");
INSERT INTO tgj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Megonv mindu no Jon Baptist kv, bunu mirwkto; “Kvvbi v mindu no Elija kv, kvgonv mintadu no nyijwk vdwlokv akonv noo kv.” ");
INSERT INTO tgj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Nonu ogubvla?” Nw bunua tvvkato. “Ngam nonu yvv vla mindunv?” Pitar mirwksito, “No Kristo rung.” ");
INSERT INTO tgj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Vbvrikunamv Jisu bunua gamrwto, “Ngoogv lvkwng nga yvvnyika minpa mabvka.” ");
INSERT INTO tgj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Vbvrikunamv Jisu ninyigv lvbwlaksu vdwa tamsar rapto: “Nyia Kuunyilo ngv hinchingre okv nyigagaatv vdwgv, nyibu butv vdwgv, okv Pvbv tamsarnv vdw bunugv toa kunam gobv rire. Ninyia sidubv mvre, vbvritola alu loum kochinglo nw turkur riku.” ");
INSERT INTO tgj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nw hum bunua chinbwkdubv ritoku. Vkvlvgabv Pitar ninyia gaklaila vngsum gvto okv ninyia yamrapto. ");
INSERT INTO tgj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Vbvritola Jisu dakkur dakrwkla, kaato ninyigv lvbwlaksu vdwa, okv Pitarnyi yamtoku. “Uyu no, ngoogv lokv vngroto,” nw minto “Noogv mvngnam v Pwknvyarnv gv lokv aama vbvritola nyi gvlokv!” ");
INSERT INTO tgj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Vbvrikunamv Jisu nyitwng nga okv ninyigv lvbwlaksu vdwa ninyi gvlo goklwkto. “Yvvdw ngoogvlo aanvpv mvngdunv,” nw bunua minto “Hv atu v mvngnga sutola, ninyigv daapo nga gvtola okv ngam vngming gvlaka. ");
INSERT INTO tgj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yvv atubongv gv singdung nga singdubv mvngnv ngv hv ngoore; vbvritola yvvdw atugv singdung nga ngogvbv ngoobolo okv Alvnv Yunying lvgabv mvngbu v singyare. ");
INSERT INTO tgj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","No nyiamooku mvnwng sum no gvbv mvtola, no atubogv yalu a nyemu namv, hv no ogu anyung go doopvla? Anyung kaama! ");
INSERT INTO tgj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nw gv singdung nga lvkodv singdukubv ninyia jinyunv oguguka kaama. ");
INSERT INTO tgj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yvvnyi hv pwknvyarnv chimanv okv alvmanv alu so ngam la ngoogv tamsar nama hinying dunv, humka nyia kuunyilo ngv vdwlo nyidogindung gv lvkobv ninyigv Abu gv yunglit lo aarikudw ninyia hinying ngurv riku.” ");
INSERT INTO tgj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Okv nw minbwngla minto, “Ngo nonua mindunv, ho mego si doodu hv vdwloka simare Pwknvyarnv gv Karv nga jwkrw nga lvkobv aaku nama bunu kaama dvdvlo.” ");
INSERT INTO tgj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Alu lokv kochingbv Jisu, Pitar, Jems, okv Jon, bunua aonv moodw golo chaagvto, ho kvvbinyi kaama bunu mwng. Ho Jisu bunugv kaakulo akusubv ritoku, ");
INSERT INTO tgj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Okv ninyigv vjiv Yapung toji toku—nyia mooku so yvvgv vji a nukakjeka hung yapung yanv kaamare. ");
INSERT INTO tgj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Vbvrikunamv lvbwlaksu aom v kaapato Elija okv Moses Jisunyi lvkobv raami sidubv. ");
INSERT INTO tgj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pitar milinla Jisunyi minto, “Tamsarnv, ngonugv soka doonam si achialvbv alvnamgo! Ngonu so taabio aomgo mvre akonyi noogv lvgabv, akonyi Moses gvbv okv akonyi Elija gvbv.” ");
INSERT INTO tgj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitar la kvgonv achialv busuto ho nw ogugo minsedw chingkumato. ");
INSERT INTO tgj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Vbvrikunamv haapum ako kaklwkla okv bunua doonyum lokv nyumrumto, okv haapum lokv gaam gamgo milinto, “Si ngo atugv paknam Kuunyilo ngv—ninyia tvvyato!” ");
INSERT INTO tgj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bunu baapu alvbv kaitkarto vbvritola yvvnyika kaapamato; Jisu mwng bunugv lvkobv dooto. ");
INSERT INTO tgj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bunu moodw lokv iku nvngv, Jisu bunua minto, “Yvvnyika minpa mabvka nonu ogugo kaapvdw, nyia kuunyilo ngv sinam lokv turkurma dvdvlo.” ");
INSERT INTO tgj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bunu ninyigv minamtvto, vbvritola bunugv arwnglo bunu rarap minsuto ho gaam am, “Sinam lokv turkurkunam’ si ogu a mindu nvgubvre?” ");
INSERT INTO tgj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Okv bunu Jisunyi tvvkato, “Ogubv Pvbv tamsar nvngv mindu ho Elija aacho yinvpv?” ");
INSERT INTO tgj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nw gv mirwknamv, “Elija jvjvklvbv aachoreku ogumvnwng nga alvbv ripv reku. Vbvritola Darwknv Kitaplo ogubv mindu ho Nyia Kuunyilo ngv achialvbv hinching reku okv toanam gobv rireku? ");
INSERT INTO tgj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngo nonua mindunv, ogubvrijeka, Elija aapvku okv ho nyi vdwv Darwknv Kitaplo ninyigv lvkwng nga minam jvbv ninyia bunugv mvngkubv rinyato.” ");
INSERT INTO tgj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Vdwlo bunu lvbwlaksu kvgonyi vngdum sitokudw, bunu nyitwng go bunua vngyum dubv kaapato Pvbv tamsarnv megonv lvkobv larkwng minsuto bunuam. ");
INSERT INTO tgj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Vdwlo nyi vdwv Jisunyi kaatodw, bunu maatar alvbv lamkato, ho ninyia jokrwkto okv naarwk sila luurwkto. ");
INSERT INTO tgj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisu lvbwlaksu vdwa tvvkato, “Ogugola nonugv bonuam larmisinam hv?” ");
INSERT INTO tgj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nyitwng lokv nyi akonv mirwkto, “Tamsarnv, ngo ngoogv kuunyilo nga no gvlo aagv jipvnv, ogulvgavbolo ninyigvlo alvmanv dow v dootola okv milin nyumado. ");
INSERT INTO tgj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vdwlo ninyia dow v aalwk ridw, hv ninyia dookulo taba modu, okv ninyigv gaam lokv sipiktait v lindu, ninyigv hijung ngv hitwkkrwkdu, okv mvnwnglo kamdaramda lwkdu. Ngo noogv lvbwlaksu vdwa darwkmanv dowa charlin jilabvkv vkwto, vbvritola bunu rila nyumato.” ");
INSERT INTO tgj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisu bunuam minto, “Vdwgo mvngjwng manv nyi vla nonu! Vdwgo ngo nonua lvkobv doobamre? Vdwgo ngo nonua lvkobv mindin minbiayare? Vminyilo nga ngo dookuso bvnglwkto!” ");
INSERT INTO tgj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ninyia bunu Jisu gvlo bvnglwkto. Vjakgobv dow v Jisunyi kaapa sopikda, ung vminyilo nga dvato, vkvlvgabv nw kvdw lo hopvto okv gaam lokv svpiktait linla, gwchargwyarto. ");
INSERT INTO tgj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisu abua tvvkato, “Vdwlokv nyi si svbv ripvnv?” Abu v mirwkto, “Nw gv vmi anga lokv.” ");
INSERT INTO tgj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Achialvgo darwkmanv dow v ninyia mvkidubv gwngkwto vmvlo nw joklwkla okv isi loka. Ngonua aya labvka okv ringlabvka, no riso mvngbolo rilare!” ");
INSERT INTO tgj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Vm,” Jisu minto, “No ogubv mindunv, no rilabolo vla! Ogumvnwng a riladu nyi v yvv mvngjwng pvdw.” ");
INSERT INTO tgj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Abu v vjakgobv kapkok linto, “Ngo mvngjwngdu, vbvritola mvngchima. Awgo doodubv ngam ridur labvka!” ");
INSERT INTO tgj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisu chintoku nyitwng gv bunua nvchilo jokkum kunam a, vkvlvgabv nw alvmanv dowa gamkito. “Rungji okv gangkaknv dow,” nw minto, “Ngo nam mindunv so vminyilo sokv linro tokuka okv lvkodv nw gvlo aakur kuyoka!” ");
INSERT INTO tgj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dow v svgok toku, vminyilo anga alvmabv jinjin mola gipv motokula, okv lintoku. Vminyilo angv sipvkunv aingbv kaato, okv mvnwngngv mintoku, “Nw sipvku!” ");
INSERT INTO tgj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Vbvritola Jisu vminyilo anga laakbv gagbwng toku okv ninyia godung dubv ridurto, okv nw godung toku. ");
INSERT INTO tgj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jisu arwnglo aaro kochingbv, ninyigv lvbwlaksu vdwv ninyia tvvrwsula tvvkato, “Ogulvgabv ngonu dowa charlin nyuma dunv?” ");
INSERT INTO tgj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisu mirwkto, “Kumnam mvngchik lokv vkv nvnga charlin nyure; ogu gunvka rinyu mare.” ");
INSERT INTO tgj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisu okv ninyigv lvbwlaksu vdwv ho mooku a kayupikula okv Galili nga vngpikla vngtoku. Jisu nw atu hv ogolodw um yvvnyika chimmuso mvngmato, ");
INSERT INTO tgj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","vkvlvgabv ninyigv lvbwlaksu vdwa nw tamsarto: “Nyia Kuunyilo nga nyi gv laaklo laklwk reku bunu ninyia mvki riku. Alu loum kochinglo, ogubvrijeka, nw turkur reku.” ");
INSERT INTO tgj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Vbvritola bunu tvvchin mato so tamsarnam si ogu vdw, okv bunu busu nyato ninyia tvvka svnga. ");
INSERT INTO tgj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bunu Kaparnaum lo aatoku, okv arwnglo aachinam kochingbv Jisu ninyigv lvbwlaksu vdwa tvvkato, “Nonuno lamtv vngtunglo ogubv lardung minsupvnv?” ");
INSERT INTO tgj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Vbvritola bunu ninyia mirwkmato, ogulvgavbolo bunugv pingkolo yvvbvri kaiyachok jinv ngv vla lamtv vngtunglo lardung minsu kunam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisu dootokula, lvbwlaksu vring gola anyia goklwkto, okv bunuam minto, “Yvvdw vngcho nvpv mvngdunv v atubongv mvnwng gv kochinglo vngtoka okv mvnwng gv pakbu bv ritoka.” ");
INSERT INTO tgj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Vbvrikunamv nw vmi ako gakbwng toku okv ninyia mvnwng gv atuklo dakmu toku. Nw gv laak hv vmi anga chegapto okv bunuam minto, ");
INSERT INTO tgj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yvvdw so vmi vdw sokv ako gonyika ngoogv amin bv naarwk bongv, hv ngaaka naarwk sidunv; okv yvvdw ngam naarwk sidunv, hv ngam mvngma vbvritola ngam so jilwkbu angaka naarwk dunv.” ");
INSERT INTO tgj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon Jisunyi minto, “Tamsarnv, ngonu nyi ako noogv amin bv uyuvram vdwa charkak dubv kaato, okv ngonu ninyia rima bvkv vla minto, ogulvgavbolo nw ngonugv apum lokvma.” ");
INSERT INTO tgj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Ninyia mintor dubv rikw mabvka,” Jisu bunuam minto, “Ogulvgavbolo yvvdw ngoogv amin bv lamrwpadubv rinv ngv hv koching nga baapubv ngoogv amina minyingminsu mimare. ");
INSERT INTO tgj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yvvdw ngonua rinik madunv v ngonu gvbvku. ");
INSERT INTO tgj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngo nonua jvjvbv mindunv yvvdw nonua isi tvngse go jidunv hv ninyigv jijo amina paarungre ogulvgavbolo nonu ngo gvngv. ");
INSERT INTO tgj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yvvdw akonvnga mvngjwng doonv vmi sum gwngka riadunv, v alvyare ho nyi angv vlwng pwktv nvlo atugv lvngpolo yiklwk sutola okv svmasa lo poklwk sunam v.” ");
INSERT INTO tgj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Vkvlvgabv nogv laak gonv noogv mvngjwng nga ngoomu dvbolo, ung paato! Si alvyare laak gonv kamabv singkulo aalwknamv okv laak laknyia gvgvrila uyumooku bolo vmv ngapma kolo vngmam svnga. ");
INSERT INTO tgj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Hoka bunuam tapum vdwv chedu v vdwloka simare, okv vmv ngv bunuam gudu v vdwloka ngapmare. ");
INSERT INTO tgj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Okv noogv lvpa gonv noogv mvngjwng nga ngoomu dvbolo, ung paato! Si alvyare lvpa gonv kamabv singkulo aalwknamv okv lvpa lvnyia gvvgvrila uyumooku bolo japlwk kosenga. ");
INSERT INTO tgj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Hoka bunuam Tapum v chedu v vdwloka simare, okv vmv ngv bunuam gudu v vdwloka ngapmare. ");
INSERT INTO tgj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Okv noogv nyik gonv noogv mvngjwng nga ngoomu dvbolo, hung kolinto! Si alvyare noogv lvgabv nyik nyikin tvla Pwknvyarnv gv karvlo aalwknamv okv nyiknyi ha gvgvrila uyumooku bolo japlwk kosenga. ");
INSERT INTO tgj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hoka bunuam Tapum v chedu v vdwloka simare, okv vmv ngv bunuam gudu hv vdwloka ngapmare. ");
INSERT INTO tgj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Mvnwngnga vmv lokv ramdarre oguaingbv erinpeelwk nama alu lokv piakdar dvdw. ");
INSERT INTO tgj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Alu v alvnvgo; vbvritola ho gv tinam v ngeku bolo, oguaingbv lvkodv ung tidukubv mvnyure? “Alu jvbv nonugv pinkolo ajin jinla, okv sarsopoyo bv ribam dakbam laka.” ");
INSERT INTO tgj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Vbvrikunamv Jisu ho mooku a vngyula, Judia mookubv vngtoku, okv jordan svko nga raptoku. Nyitwng v lvkodv ninyia vngyum toku, okv ninyigv ribwngnam aingbv, bunuam nw tamsar toku. ");
INSERT INTO tgj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisis kvgonv ninyigvlo aato okv ninyia kupdubv gwngto. Bunu tvvkato, “Ngonua minpa labv, ngonugv Pvbv lo nyiga ngv atugv nywng nga apak dubv dopvnvre?” ");
INSERT INTO tgj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisu mirwk siyingla tvvkato, “Moses nonua ogu Pvbv go minpvpi?” ");
INSERT INTO tgj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bunugv mirwknamv, “Moses gv minpv namv nyiga ngv atugv nywng nga apak dubv vnglin nvnv pota go lvktola vngmulaka hvpv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisu bunuam minto, “Moses nonugv lvgabv so Pvbv nga lvkto ogulvgavbolo nonua tamsar sarnyu manam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Vbvritola atuake ho, Pwklinyarlin rilo, ‘Pwknvyarnv bunua nyimv okv nyilo bv,’ darwknv Kitaplo vbv mindu. ");
INSERT INTO tgj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Okv vkvlvgalo nyiga ngv atugv anv okv abua kayupila okv atugv nywng nga lvkobv ririku, ");
INSERT INTO tgj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","okv anyiv akin gubv ririku.’ Vkvlvgabv bunyi anyikuma, vbvritola akinhvku. ");
INSERT INTO tgj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Vbvrikunamv, Pwknvyarnv gv naadumsiku nama nyia nyi gunv yvvjvka um naapin sirung mabvka.” ");
INSERT INTO tgj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Vdwlo bunu naamlo vngkur tokudw, lvbwlaksu vdwv so gv lvkwng nga Jisunyi tvvkato. ");
INSERT INTO tgj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nw bunuam minto, “Nyi v yvv atugv nywng nga apak tvla okv kvvbi nyimvmvvga nga nywng mvbolo atugv nywng nga rinyingdu. ");
INSERT INTO tgj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Vkv aingbv, nyimvmvvga ngv yvv atugv nyilu nga apak tvla okv kvvbinyi go nyilu naakubolo hv jwkjwkvrwk manv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nyi megonv vmi vdwa Jisu gvlo aagvto ninyigv laak lokv bunuam mampv modubv vla, vbvritola lvbwlaksu vdwv nyi vdwa yamtumto. ");
INSERT INTO tgj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Vdwlo Jisu um kaapa kunamv, nw haachito okv ninyigv lvbwlaksu vdwa minto, “Vmi vdwa ngoogvlo aamuto, okv bunua mintor mabv, ogulvgavbolo Pwknvyarnv gv Karv ngv bunu aingnv gvngv. ");
INSERT INTO tgj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ngo nonua jvjvbv mindunv. Yvv vmi aingbv Pwknvyarnv gv Karv nga naarwk madudw nw hoka vdwloka aanyumare.” ");
INSERT INTO tgj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Vbvrikunamv nw vmi vdwa nw gvlo laachumtoku, ninyigv laak v bunuam akin-akinbv mampvto, okv bunuam boktalwkji toku. ");
INSERT INTO tgj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisu ninyigv vngkubv lvkodv vngrap tvvdubv, nyi ako joklwk toku, ninyigv lvgaplo gublwkto, okv ninyia tvvkato, “Alvbv Tamsarbo, ngo turbwng nama paadubv ogugo rise vdw?” ");
INSERT INTO tgj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisu ninyia tvvkato, “No ngam ogubv alvnvgo vla mindunv?” “Yvvka alvnvgo kaama Pwknvyarnv akin mwng. ");
INSERT INTO tgj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","No gamkinam vdwa chinsudo: ‘Gwngrw gwmabvka; nywngnyilu ribo minsu mabvka; dvcho mabvka; yvvnyika mvvla mimur mabvka; dvkup mabvka; noogv anv okv noogv abua mvngdv laka.’” ");
INSERT INTO tgj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Tamsarnv,” nyi angv minto, “Ngoogv yaapa singsa yilokv rila, ngo gamkinam vdwa tvvla ripvkunv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisu ninyia paknambv kaagap jinjinla minto, “No rise ako doodu. Vngnyika okv noogvlo ogugo doopvdw mvnwngnga pyoktoka okv morko nga heema vdwa ortoka, okv no nyidomooku tvlo nyitvyachok reku; vbvritokula aalakula okv ngam vngming gvlaka.” ");
INSERT INTO tgj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Vdwlo nyi angv so tvvpa kunamv, ninyigv nyukmu v motvkrv tokula, okv mvngdwkla vngtoku, ogulvgavbolo nw achibv nyitv nvgo. ");
INSERT INTO tgj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisu hoka ninyigv lvbwlaksu vdwa kaitkarla kaato okv bunuam minto, “Nyitvnv nyi vdwgv lvgabv Pwknvyarnv gv Karv lo aatv rinyi achialvbv aanyu manam gubv ridu!” ");
INSERT INTO tgj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lvbwlaksu vdwv ho gv gaam minam vdwa lamtoku, vbvritola Jisu minbwng jito, “Ngoogv vmi vdwa, Pwknvyarnv gv Karv lo aadu bv so si achialvbv aanyu manam gubv ridu! ");
INSERT INTO tgj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nyitvnv nyi gv Pwknvyarnv gv Karv lo aatv rinyi kemel gv pwsi ungko lo vngpit tvvnam um svnga, si achialvbv aanyu manam gubv riya dunv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hokaku lvbwlaksu vdwv achialvbv lamngak nyatoku okv akonv-akonyi tvvka minsu toku, “Vbvribolo, yvvkula ringnam a paala jinv?” ");
INSERT INTO tgj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisu hoka bunuam kaadichinchinla kaato okv mirwkto, “So si nyi gvbv rikanyuma nvgo, vbvritola Pwknvyarnv gvbvma; Pwknvyarnv lvgabv ogumvnwng ngv rinyu dunv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Vbvrinamv Pitar milin toku, “Kaato, ngonu ogumvnwng nga topu tokula okv nam lvkobv vngming gvdunv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Vm,” Jisu bunuam minto, “Okv ngo nonua mindunv ho yvv akonv naam vmalo boru vdwa vmalo bormv vdwa vmalo anv nga vmalo abua vmalo kuu vdwa vmalo rongo nga ngoogv okv gamlv gv lvgabv topu kubolo, ");
INSERT INTO tgj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sogv singnam sum kaiyachok yago paariku. Nw paariku lwnggo lvvya naamgo, boru go, bormv go, anv go, kuu go okv rongo go—okv ngam mvngjwngnam lokv mvdwkmvku haka; okv singnam gonv aaku bolo nw turbwngnv singnam a paariku. ");
INSERT INTO tgj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Vbvritola, awgonv vjak yvv kainvgobv singpvdw, hv miang nvgobv singreku, okv awgonv yvv vjak, miang nvgobv singpvdw, hv kainvgobv singreku.” ");
INSERT INTO tgj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisu okv ninyigv lvbwlaksu vdwv Jerusalem lo chaadubv lamtvlo vngdungto. Jisu lvbwlaksu vdwa vngchoyala vngto, kvgonv lamnyato; adarlo vngming gvnv nyi vdwv busunyato. Lvkodv Jisu vring gola anyi lvbwlaksu vdwa adargolo lingvto okv hoka ninyia ogugo rijinvnga ung mintoku. ");
INSERT INTO tgj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Tvvyato,” Nw bunua minto “Ngonu Jerusalem bv vngdungdunv hoka Nyia Kuunyilo nga nyibu butvnv vdwgvlo okv Pvbv tamsarnv vdwgvlo laklwk reku. Bunu ninyia simu dukubv miyakaya reku okv vbvritola ninyia Jentail haalung gvlo laklwk reku, ");
INSERT INTO tgj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ho bunu ninyia nyarjikau reku, tachor chorbiakre, svnyakpare, okv ninyia mvkire; vbvritola nw alu loum nvnga turkur reku.” ");
INSERT INTO tgj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Vbvrikunamv Jebedi gv kuunyilo, Jems la Jon, Jisu gvlo aato. Bunu minto, “Tamsarnv, ngonugv mvngnam akonv ngonugv lvgabv rijilabv vla mvngdunv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisu bunua tvvkato, “Hv ogugola?” ");
INSERT INTO tgj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bunu mirwkto, “Vdwlo no noogv yunglit rungnv Karv lo doori kudw, ngonu mvngdu no ngonua noogv lakchilo akonyi okv lakbiklo akonyi, noogv dookulo lvkobv doogv labv vla mvngdunv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisu bunua minto, “Nonuno chima nonu ogu gonyi koodudw, Ngoogv hinching koobu lo tvngjinam sum um nonu tvnglare? Ngoogv Baptisma naajinam um nonuno naalare?” ");
INSERT INTO tgj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bunu mirwkto, “Ngonu rilare.” Jisu bunua minto, “Rinam gvbv nonu ngoogv tvngjikunam hinching koobulo tvnglare okv ngoogv baptisma naajinam apiabv naamwng gvlare. ");
INSERT INTO tgj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Vbvritola ngoogv lakchilo okv lakbiklo yvv dooridw um dardubv ngoogvlo kaama. So dooku sam Pwknvyarnv yvvgv lvgabv mvpvjila vvpvnv nw jire.” ");
INSERT INTO tgj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Vdwlo lvbwlaksu vring ngv um tvvpa tokudw, bunu Jems nyila okv Jonnyi haachi toku. ");
INSERT INTO tgj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Vkvlvgabv Jisu bunu mvnwngnga lvkobv ninyigvlo goklwkto okv minto, “Nonu chindu yvvnyiv Jiusmanv nyi vdwgv dvbv bv ridunv bunu vdwv bunuam rigvdu, okv rigvnv vdwv achialvbv tojupkunamv doodu. ");
INSERT INTO tgj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Si, ogubvrijeka, nonugv pingkolo rima svngv. Nonuno gvlo akonv kai yanvpv mvngdulo, nw mvnwng gv pakbubv rirunglaka; ");
INSERT INTO tgj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Okv nonuno gvlo akonv vngcho nvpv mvngdudw, nw mvnwng gv nyirabv rirunglaka. ");
INSERT INTO tgj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nyia kuunyilo jesing ngv rijikodubv aama; Nw rijitebv aato okv ninyigv singtung nga mvngnga yala achialv nyi go ringlin dukubv.” ");
INSERT INTO tgj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bunu Jeriko lo aalwkto, okv Jisu ninyigv lvbwlaksu vdwala okv nyitwng nga lvkobv vnggvla vngrilo, Timias gv kuunyilo Bartimas vnam nyikching tola giago nvgu lamtv adar lo dooto. ");
INSERT INTO tgj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Vdwlo nw Najaret lokv Jisu kunyi vla tvvpapvdw, nw gokrapto, “Dabid gv kuunyilo, Jisu, ngam aya mvngpa labv!” ");
INSERT INTO tgj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Achialvnv nyi v ninyia yamto, okv ninyia bunu choibvkv vla minto. Vbvritola nw gamtvyayabv gokto, “Dabid gv kuunyilo, nga aya labvka!” ");
INSERT INTO tgj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisu daktungto okv minto, “Ninyia goklwkto.” Vkvlvgabv bunu nyikchingnv nyi um goklwk jitoku. “Mvngpu laka!” Bunu minto. “Gudunglak nam Jisu gokdu.” ");
INSERT INTO tgj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Vkvlvgabv nw atubogv vji laklwk ka ora toku, pogin pokrapto, okv Jisu gvlo aatoku. ");
INSERT INTO tgj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“No ngam ogugo rijikoso mvngdu?” Jisu nyi um tvuto. “Tamsarnv,” Nyikchingnv nyi v mirwksito, “Ngo lvkodv kaapa nwngdo.” ");
INSERT INTO tgj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Vngnyika,” Jisu ninyia minto, “Noogv mvngjwng ngv nam alvdvbv mvpvku.” Vjakgobv nw kaapatoku okv lamtv ho Jisunyi vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bunu Jerusalem vngchi dase rilo, Betpej gv okv Betani gv banggu nvchilo, bunu Olib Moodwlo aatoku. Jisu ninyigv lvbwlaksu anyigo kanamla vngcho moto ");
INSERT INTO tgj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Svkvnv gaam milwkto: “Nonugv vnglwkjiku nampum alo vngnyilaka. Nonu alo vngchi sopikda, siak ako takpvla lvkoka riokw manamgo nonu kaapare. Um paksoklaila okv um soka aagv teka. ");
INSERT INTO tgj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Okv nyi gonv nonua ogubv vbv ridunv vla tvvka bolo, so gv Ahtuv sum naanwngdu okv sum baapubv jikur reku vla ninyia minpa laka.” ");
INSERT INTO tgj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Vkvlvgabv bunu vngto okv lamtv vngtunglo siak ako naam ako gv agi lo rvngpv dubv kaapa toku. Bunu um taasok rilo, ");
INSERT INTO tgj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nyi mego hoka daknv vdwv bunua tvvkato, “Nonu ogubv rila, siak a taasok dunv?” ");
INSERT INTO tgj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bunu Jisu gv milwknam jvbv mirwkto, okv nyi vdwv bunua boomu toku. ");
INSERT INTO tgj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bunu siak a Jisu gvlo boolwk jito bunugv vji laklwk a siak aolo pujito, okv Jisu aolo gecha toku. ");
INSERT INTO tgj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nyi mvnwngngv bunugv vji laklwk a lamtvlo pupvjito, kvgonv rongo lokv svngming pala okv um bunu lamtvlo pipv jito. ");
INSERT INTO tgj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Koching okv habobv vngming gvnv nyi vdwv gokrap nyato, “Pwknvyarnvnyi hartvto! Pwknvyarnv boktalwkji laka Atugv amin bv aanvnga! ");
INSERT INTO tgj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pwknvyarnv boktalwkji laka aainv ngonugv Dvbv Dabid gv Karv nga! Pwknvyarnvnyi hartvdu!” ");
INSERT INTO tgj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisu Jerusalem lo aalwk toku, kumkunaam arwnglo aatoku, okv ogumvnwng nga kaitkarto. Vbvritola alu v loodwng kunam lvgabv, nw lvbwlaksu vring gola anyi lvkobv vnglingvla Betani bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Logo nvnga, bunu Betani lokv vngkurla vngrilo, Jisu kano toku. ");
INSERT INTO tgj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nw adu bv koksitkokrik singnv go anv ngv harbum dubv kaapato, vkvlvgabv nw koksitkokrik apw doopv bvri vla aala kaato. Vbvritola vdwlo nw aatokudw, nw anv mvngchik a kaapa toku, ogulvgavbolo hoka koksitkokrik apw svvdw madvto. ");
INSERT INTO tgj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisu hoka koksitkokrik singnv nga mintoku, “Yvvka lvkodv noogvlo koksitkokrik dvlwk kumare!” Okv ninyigv lvbwlaksu vdwv um tvvpato. ");
INSERT INTO tgj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vdwlo bunu Jerusalem lo vngchi tokudw, Jisu Pwknvyarnvnaam lo vngtoku okv pyoknv okv rvvnv mvnwngnga mvyakmvchak rirap toku. Nw morko lwkkolwkpik nvgv tvbul okv taakw pyoknv dooging okv pyokgingnvnv nga duyakduchak toku, ");
INSERT INTO tgj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Okv nw yvvnyika Pwknvyarnvnaam agum bv ogugoka gvvpik momato. ");
INSERT INTO tgj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Vbvrikunamv nw nyi vdwa tamsarto: “So si Darwknv Kitaplo lvkpvdu ho Pwknvyarnv minto, mooku mvnwng gv nyi mvnwng lvgabv ‘Ngoogv Pwknvyarnvnaam hv diringmooku nyi mvnwng gv kumgingjoging naam vla mindunv.’ Vbvritola um dvchochonv vdwgvbv tosi siging kobv nonuno kokda pvjiduku!” ");
INSERT INTO tgj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","So sum nyibu butvnv vdwv okv Pvbv tamsarnv vdwv tvvpato, vkvlvgabv bunu Jisunyi ogolo mvki sogobvri vla agi kaarap toku. Bunu ninyia busu toku, ogulvgavbolo ninyigv tamsar nama nyitwng mvnwngngv lamngak nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Vdwlo arium tukudw, Jisu okv ninyigv lvbwlaksu vdwv pamtv nga vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Logonvgv arukamchi lo, bunu lamtvlo vngying dula, bunu koksitkokrik singnv go kaato. Hv singmwng lokv miami mvnwng lobv sintoku. ");
INSERT INTO tgj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitar mvngpa toku ogugo ripvdw okv Jisunyi minto, “Kaato, Tamsarnv, noogv beenam koksitkokrik singnv ngv sinpvku!” ");
INSERT INTO tgj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisu bunua mirwk toku, “Pwknvyarnvnyi mvngjwngtvka. ");
INSERT INTO tgj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngo nonua jvjvklv bv mindunv ho yvvdw so moodw sum gudungla okv atu v svmasa bolo orlwksuto vla okv ninyigv haapoklo mvngngvm manam kamabv, vbvritola ogugo ninyigv minam v rirungre vla, mvngjwng bolo v nw gvbv rijire. ");
INSERT INTO tgj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Svkv lvgabv ngo nonua mindunv: vdwlo nonu kumredw okv ogugonyi kooridw, mvngjwngtvka ung nonu paapvku, okv ogugonyi nonu koobolo nonua jirung reku. ");
INSERT INTO tgj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Okv vdwlo nonu dakla okv kumbolo, mvngnga laka yvvdw nam rinying pvdw, vkvlvgabv ho nyidomooku aogv doonv Abu noogv rimur a mvngnga jireku. ");
INSERT INTO tgj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","No kvvbi haka mvngnga mabolo, noogv Abu nyidomooku aogv doonv tvka noogv rimur rinam vdwa mvngnga mare.” ");
INSERT INTO tgj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bunu lvkodv Jerusalem lo aachitoku. Jisu Pwknvyarnvnaam lo vngkarto, nyibu butvnv vdwv, Pvbv tamsarnv vdwv, okv nyiga vdwv ninyigvlo aato ");
INSERT INTO tgj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","okv nw ha tvvkato, “No so vdwsum ridubv ogu rilanvnv go doopv? Yvv nam so rilanvnv nga jipvnv?” ");
INSERT INTO tgj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisu bunua mirwkto, “Ngo nonua vjak gamgo tvkare, okv nonuno nga mirwksito, ngo nonua minpare ogu rilanvnv go ngo doopvdw so vdwa ridubv. ");
INSERT INTO tgj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ngam minpalabv, ogolokv Jon gv Baptisma jilanvnv ngv aapvnv: v Pwknvyarnv gvlore vmalo nyi gvlore?” ");
INSERT INTO tgj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bunugv pinkolo bunu larrap minsuto: “Ngonu ogugo mindubv? Ngonu Pwknvyarnv gvlokv vla mirwk sibolo, nw minre, ‘Ogulvgabv, vbvrinamv, nonu Jonnyi mvngjwng mapvnv?’ ");
INSERT INTO tgj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Vbvritola ngonu ‘Nyi lokv vla minbolo...’” (Bunu nyi vdwa busunyato, ogulvgavbolo nyi mvnwngngv Jonnyi nyijwk akobv mvngjwng nyato.) ");
INSERT INTO tgj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Vkvlvgabv Jisunyi bunugv mirwknamv, “Ngonu chimado.” Vbvrikunamv Jisu bunua minto, “Ngooka nonua minjimare, ogu rilanvnv lokv ngo so vdw sum ridunvdw.” ");
INSERT INTO tgj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Vbvrikunamv Jisu bunuam minchisinam lokv mintoku: “Kvvlo nyi ako dooto hv anggor rongo ako mvtoku, hum svlung rakyum toku, anggor nyumjit kobv ungrung ako dutoku okv kaaya koku taabio akochin bioto. Vbvrigvrila nw rwktinnam nyi lo tinlwk toku okv naam a mooying vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Vdwlo anggor a naakumdw hv aato kudw, nw pakbua rwktin gvlo vngmu toku ninyigv paase nga bunu gvlo naarwk simudubv vla. ");
INSERT INTO tgj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Rwktin tinam vdwv pakbu nga naatungto, ninyia jvngto, okv arochoko bv vngkur motoku. ");
INSERT INTO tgj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Vbvrikunamv atu v pakbu gonvnyi vngmuto; rwktin tinam vdwv ninyia dumpo lokv jvngrap toku okv ninyia achialvbv nyarjikaola mvtungmvre toku. ");
INSERT INTO tgj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Atu hv pakbu ako godv vngmuto, okv ninyia bunu mvki toku; okv bunu achialvbv kvvgo nyika vbvdvdvbv mvto, kvgonyi jvngto kvgonyi mvkito. ");
INSERT INTO tgj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Akin mvngchik go doomwng toku vngjikunv hv rongo atugv paknam kuunyilo ngv. Vbvrikunamv, atar anyabv, nw ninyigv kuunyilo nga rwktin vdwgvlo vngmu toku. Nw minto ‘Ngo jvjvbv mvngdunv bunu ngoogv kuunyilo nga mvngdvri.’ ");
INSERT INTO tgj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Vbvritola rwktin vdwv bunugv arwnglo raamisito, ‘So si rongo atu gv kuunyilo ngv. Klai, aakumto ninyia mvki laju, okv ninyigv yikungyira ngv ngonu gvbv rireku!’ ");
INSERT INTO tgj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Vkvlvgabv bunu kuunyilo anga naatungto okv ninyia mvki toku okv ninyigv svma nga rongo agumlo joa toku.” ");
INSERT INTO tgj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Vbvrikubolo, rongo atu v ogu rirekudw?” Jisu Tvvkato. “Nw aareku okv ho nyi vdwa mvkire okv rongo nga kvvbi rwktin lo tinriku. ");
INSERT INTO tgj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Darwknv Kitaplo nonu sum puri rirung pvnvri? ‘Naam mvnv vdwgv anyung kaama vla daranam vlwng ngv mvnwng a alvyachok nvgobv rito. ");
INSERT INTO tgj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Si Ahtu lokv ritoku; Si ogu kaasartabobv kaanam go!’” ");
INSERT INTO tgj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jius rigvnv vdwv Jisunyi naatung tvvtoku, ogulvgavbolo ninyigv minchisinam minam v bunuam minikla mindu vla bunu ho tvchinto, vbvritola bunu nyitwng nga busunyato, vkvlvgabv bunu ninyia kayula okv vngyutoku. ");
INSERT INTO tgj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Parisis nyi megola okv Herod gv nyi megola Jisu gvlo vngmuto ninyia tvu svgo tvka gvrila naatung dubv vla. ");
INSERT INTO tgj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bunu nw gvlo aala minto, “Tamsarnv, ngonu chindu no jvjv a mindunv, nyi vdwv ogugo mvngdu ho lvkwngbv mvngdwk mabv. No nyi vdwgv mvngnam lokv vngma, vbvritola nyi lvgabv Pwknvyarnv gv ogugo mvngnam jvjv nga tamsaryado. Ngonua minpalabv, Roman Dvbvyachok ka lampu dornam si ngonugv Pvbv nga rinying dunvri? Ngonu dordu bri vmalo dorma dubvri?” ");
INSERT INTO tgj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Vbvritola Jisu bunugv gwngsi nama kaapatvla mirwksito, “Nonu ogubv nga naatung dubv gwngdunv? Ain lokdwng lo chargo bvnglwkjilabv, okv um nga kaamulabv.” ");
INSERT INTO tgj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bunu charkin go ninyigvlo bvnglwk jito, okv Jisu tvvkato, “Si yvvgv nyukmu vla okv aminv?” Bunu mirwkto “Dvbvyachok gv.” ");
INSERT INTO tgj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Vkvlvgabv Jisu minto, “Alvdo, vbvrinamv, Dvbvyachok gvnga Dvbvyachoknyi jitoka, okv Pwknvyarnv gvnga Pwknvyarnvnyi jilaka.” Hoka bunu Jisunyi lamngak panyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Vbvrikunamv nyi sinv, turkur madunv vnv Sadusis mego, Jisu gvlo aato okv minto. ");
INSERT INTO tgj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tamsarnv, ngonugv lvgabv Moses so Pvbv nga lvkpv jito: ‘Nyi gunv atugv nywng nga kuu bvngma dwbv siyu bolo ho nyi gv boruv hvngmi nga nywng mvla doogv gvrila siyunv nyi ho gvbv kuu bvngji motoka’ ");
INSERT INTO tgj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lvko nvnga achiboru kanw go dooto; Achi yachokkv nywng naatoku okv kuu dooma dwbv siyuto. ");
INSERT INTO tgj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Vbvrikunamv boru yangv nywng nga doogv toku, okv nw ka kuu bvngma dwbv siyutoku. Boru aom nvnv vka vbvdvdvbv ritoku, ");
INSERT INTO tgj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","okv vbvrikunamv boru dvdv ngv: boru kanw mvnwngngv nyimvmvvga anga nywng mvto okv kuu bvngma dwbv siyu nyatoku. Atar anyabv nyimvmvvga angv sitoku. ");
INSERT INTO tgj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Vjak, bunu kanw mvnwngngv ninyia nywng mvto, turkurdw alu lo vdwlo sinv mvnwngngv turkur rikunyi, nyimvmvvga angv yvvgv nywngbv rirekudw?” ");
INSERT INTO tgj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisu bunua mirwk toku, “Vdwgo nonu mvngmur nyadunv! Okv nonu chindure ogulvgabv? So si ogulvgavbolo nonu Darwknv Kitap a vmalo Pwknvyarnv gv jwkrw nga chima namv. ");
INSERT INTO tgj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vdwlo sinv vdwv turkur rikudw, bunu nyidogindung jvbv ririku okv nywngnyilu naami sikumare. ");
INSERT INTO tgj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Vjak, sinv ngv turkur nama: nonu lvkoka Moses gv Kitaplo singnv amwng nga vmv gunam lvkwng nga puri rika mapv nvri? Hoka svbv lvkdu Pwknvyarnv Mosesnyi minto, ‘Ngo kuna Abraham gv, Isaak gv okv Jakob gv Pwknvyarnv ngv,’ ");
INSERT INTO tgj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pwknvyarnv turnv vdwgv Pwknvyarnv ngv, sinv gvngvma. Nonu achialvbv mvngmordu!” Pwknvyarnv turnv nyi vdwgv Pwknvyarnv ngv, bunu siro kujvka, turdunv. Nonu achialvbv mvngmordu!” ");
INSERT INTO tgj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Vbv raami sirilo Pvbv tamsarnv ako hoka tvvla dakto. Nw kaatoku Jisu sadusis vdwa alvrungbv mirwk gvnyibv vla, vkvlvgabv nw Jisu gvlo tvusvgo mvngla aatoku: “Gamkinam mvnwng lokv kaiyachoknv gamlo yachokkv ogolo angv?” ");
INSERT INTO tgj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisu mirwkto, “Gamlo yachoknv sinv ‘Tvvgap tvka, Israel! Ahtu ngonugv Pwknvyarnv mvngchik Ahtuv. ");
INSERT INTO tgj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ahtunyi paklaka noogv Pwknvyarnvnyi noogv haapok mvnwnglo, noogv dow mvnwnglo, noogv mongrumara mvnwnglo, okv noogv gwlwk mvnwnglo.’ ");
INSERT INTO tgj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gamnyi nvnv gamlo yachokkv si, ‘No kvvbinyi haka paktoka oguaingbv no atu nvnga paksudvdw.’ So gv gamlo gamnyi so lvvyabv ho kaiyanv gamkinam yagu kaama.” ");
INSERT INTO tgj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pvbv tamsarnv Jisunyi minto, “Tamsarnv, Alvbv ripv, so si jvjv ngvrung no mingvnyibv, ho Ahtu mwng Pwknvyarnv ngv okv ho hokaka kvvbi Pwknvyarnv yago kaama vbvritola nw mwng. ");
INSERT INTO tgj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Okv nyi v Pwknvyarnvnyi haapok mvnwnglo pakrung laka, okv mongrumara mvnwng loka okv ninyigv gwlwk mvnwng loka; okv kvvbinyi haka no atu v oguaingbv paksudvdw vbv pakmin sirung laka. Svnwngsvmin okv kvvbi go Pwknvyarnvnyi erin rinji mamsenga so gv gamkinam gaam anyi sum achialv bvya tvvgap mvnggapla rise gorung.” ");
INSERT INTO tgj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisu kaapa toku vdwgo alvrungdo ninyigv mirwknamv, okv vkvlvgabv Jisu ninyia minpa toku, “No Pwknvyarnv gv Karv lokv adu ma.” So kochingbv yvvka Jisunyi tvu svnga choopu nyuma toku. ");
INSERT INTO tgj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pwknvyarnvnaam lo Jisu tamsar sardungla ririlo, nw tvunam go tvvkato, “Pvbv tamsarnv vdwv Kristonyi Dabid gv husi gubv rire vla oguaingbv mindu nvdw? ");
INSERT INTO tgj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabidnyi Darwknv Dow lokv mimuto: ‘Ahtu ngoogv Ahtunyi minto: Ngo noogv nyimak vdwa noogv lvpa lvkwnglo domuma dvdvlo ngoogv lakbiklo dootoka.’ ");
INSERT INTO tgj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dabid atubongv ninyia ‘Ahtu’ vla gokto; vkvlvgabv Kristo oguaingbv Dabid gv husi bv ridubv?” Nyitwng kairungnv go Jisu gv minam a tvvpubv tvvria nyato. ");
INSERT INTO tgj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nw gv bunuam tamsar rilo, nw minto, “Pvbv tamsarnv vdwv jvtvlaklwk asudubv gvtola vngnwng nyanv okv piokpamdorpamlo mvngdv konwng nyanv vdwa himasuto laka, ");
INSERT INTO tgj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yvv jius kumkunaam vdwlo alvnv dooging nga okv dvpam dvkulo alvyachoknv dooku haka gaknv. ");
INSERT INTO tgj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bunu hvngmi vdwa rinvnvmindu okv bunugv naam a dvritpapidu, okv vbvrikunamv kaatamdu kumnam a asudvbv kumdu. Bunugv hiru rusengv sinama lvyabv rire!” ");
INSERT INTO tgj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisu Pwknvyarnvnaam lo morko lwkku jampa nvchilo dooto, nyi vdwgv morko paalwk nama nw kaayato. Nyitvnv nyi vdwv achialv kaibv morko nga paalwk nyato; ");
INSERT INTO tgj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","vbvrikunamv nyima harianv hvngmi go aalwk toku okv lokdwng charchingnv charnyi go hikki arv go paalwk ngurvto. ");
INSERT INTO tgj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisu ninyigv lvbwlaksu vdwa goklwkla bunuam minto, “Ngo nonua minpa dunv so nyima harianv hvngmi angv mvnwngnga kaiyabv Daan jampa so paalwk gvnyibv. ");
INSERT INTO tgj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kvvbbi vdwv bunugv nyitvla lvvlin kunam a paalwk nyato; vbvritola hvngmi v, nyimaharia bv rirung dvlachin, nw vdwgo doopvdw hum lwknya chekato—nw ninyigv turgv nvvse ngaaka lwktar jito.” ");
INSERT INTO tgj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisu Pwknvyarnvnaam lokv vnglin rikulo, ninyigv lvbwlaksu akonv ninyia minto, “Tamsarnv, kaatoka! Si achialv kaapu rungnv vlwng okv naam go!” ");
INSERT INTO tgj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisu mirwkto, “Nonu kaadure kainv naam vdwsum? Vlwng pwkin goka dookulo doobwng kumare; mvnwng sum ngorlula ngora reku.” ");
INSERT INTO tgj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisu ninyigv Pwknvyarnvnaam kaatok gonvgv Olib Moodw lo doorilo Pitar, Jems, Jon okv Andriu bunu ninyi gvlo aasila aatoku. ");
INSERT INTO tgj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Bunu minto, “Vdwnyi si ritv rinvdw ngonuam minpalabv, okv so gv mvnwng sokv ridw v aaduku vla ogu go kaaring sinv namgo richo tvdunvdw hum sin ngonua minjilabv.” ");
INSERT INTO tgj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisu bunua minto, “Yvvka nonua mvvkup madubv himasito laka. ");
INSERT INTO tgj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Achialvgo nyi v ngoogv amina gakka minsure, aagvrila minre, ‘Ngo kunv Jisu!’ okv bunu awgo nyi vdwa mvvkupre. ");
INSERT INTO tgj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Okv vdwlo nonu nyimak gv sidupvbin a nvchibv tvvla okv nyimak gv yunying nga adu lo tvvpala adwkaku mabvka. Vkv nvnga rirungjinv, vbvritola v rinya alu v aapvku vnam kaama. ");
INSERT INTO tgj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Diringmooku mvnwngngv padar minsi reku; Karv vdwv mvmisureku. Mooku mvnwnglo moobi hwkriku, okv ho dvmayarwng aariku. So vdw si kuu bvngtv rinyi huchi chichonam jvbv rire.” ");
INSERT INTO tgj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nonuno atubongv himasito laka. Nonuam naatung reku okv kvbanaam lo boolwk reku. Nonuam Jius kumkunaam vdwlo mvrit riku; Ngoogv lvkwng lokv bunua Gamlv a minpa dubv nonuam rigvnv vdw okv kvvbi vdwgv kaagialo dakmure. ");
INSERT INTO tgj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vbvritola rinya alu v aama dwbv, Gamlv nga chinggodogo haalung mvnwnglo japcho jirungre. ");
INSERT INTO tgj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Okv vdwlo nonuam naatung rekudw okv kvbanaam lo vnggv rekudw, nonu ogugo minsedw vla mvngchola mvngdwk mabvka; vdwlo mindw v aarikudw, minlaka vbvribolo ogugo nonua minpv jipvdw. Nonugv gaam minam vdwv nonu gvngvma; v vdwv Darwknv Dow lokv aareku. ");
INSERT INTO tgj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nyiga vdwv bunu atugv achiboru a mvki modubv laklwk reku, okv abu vdwvka bunugv kuu a vbvdvdvbv rire. Kuu vdwvka bunugv anvabu vdwaka rirwk sire okv bunuam mvkisure. ");
INSERT INTO tgj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nyi mvnwngngv nonua ngoogv lvgalokv kaanwng mare. Vbvritola yvvdw rinya alu lobv gakbwngla rilin redw v ringnam a paareku. ");
INSERT INTO tgj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nonuno ‘Achialv busu namgo hv mvyakmvchak jinv go.’ Hoka ninyigv dakma svngvlo dakdubv kaapare.” (Purinv vdwa mindu: Si ogu gonyi mindunvdw chirung laka!) “Vbvrikubolo yvv bunu Judia lo doodunv moodw bv kicha laka. ");
INSERT INTO tgj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yvvnyi angv nw gv naam namwng mwnglo aolo ridunv naam arwngbv yikungyira naadubv irung mabvka. ");
INSERT INTO tgj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yvvnyi angv rongolo ridunv ninyigv vji laklwk lvgabv naamlo vngkur kuyoka. ");
INSERT INTO tgj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Hv alu v nyimvmvvga vdwv kuu gvdunv okv anv vdwv yvv anga ajingnv doodunv ho vdwgvbv achialvbv alvmanv gobv rire! ");
INSERT INTO tgj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Svkv nvngv kamching poolu lo rima dubv Pwknvyarnvnyi kumtoka! ");
INSERT INTO tgj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ho alu gv hirukaya ngv Pwknvyarnv gv nyiamooku a pwklinyarlin rilokv vjak lobv nyia nyi vdwgv hingkw kunam um svnga si achialvbv alvmanv gubv riyare. Vbvdvdvbv kokwloka vkvnvgo lvko ridv kumare. ");
INSERT INTO tgj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vbvritola Ahtu ho alua loodwng modu; nw vbv rimabolo, yvvka turla renyu mare. Nw gv darkunam nyi vdwgv lvgabv, nw ho alu vdwa loodwng mopvnv. ");
INSERT INTO tgj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Vbvrikunamv, ‘Kaatoka, Kristo si doodukv!’ Vmalo, ‘Kaatoka, nw alo hv!’ Vla nyi gonv nonua minbolo—ninyia tvjing mabvka. ");
INSERT INTO tgj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mvvnvrunv Kristo ngv okv mvvnvrunv nyikrwkaanv aare. Rilabolo bunu Pwknvyarnv gv nyi vdwa mvvkup dubv lamrwpadubv okv kaapunv rila kaatamre. ");
INSERT INTO tgj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nonuno atugv lvgabv hima silaka! Ridw hv aamadwbv ngo nonua ogumvnwng nga mincho jipvkunv.” ");
INSERT INTO tgj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Hirukaya alu vdwv vngro kochingbv, Doonyi hv kanv riku okv Poolu vka loung kumare, ");
INSERT INTO tgj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","takar vdwv nyidomooku lokv holu re, okv nyidomooku tolo jargvnv gwlwk hv bunugv lokv ngeyu reku. ");
INSERT INTO tgj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Vbvrikubolo nyia kuunyilo ngv daklwk riku, jwkrw kairungnv okv yunglit nvgobv rila doomwk lo aareku. ");
INSERT INTO tgj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nw ninyigv nyidogindung vdwa nyia mookugv chenyung api lo vnglin more okv nyido dootar gonv lokv dootar gonv lobv Pwknvyarnv gv darnam nyi vdwa makum more. ");
INSERT INTO tgj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Koksitkokrik singnv lokv nonu kachin sutoka. Vdwlo so gv hakbv ngv jijibv okv kaapubv riri kudw okv anv harlin rapku bolo dwrw hv nvchi duku vla nonu chindu. ");
INSERT INTO tgj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ho apiabv, vdwlo nonu svkv nvnga ridubv kaapa rikudw, rirap dukubv, dwv nvchi duku vla nonu chinreku. ");
INSERT INTO tgj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nonu mvnggap laka so ogu mvnwng vdw si rire vjakgv nyi singnv mvnwng vdwsi sima dwbv. ");
INSERT INTO tgj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Siching nyido hv ngelare, vbvritola ngoogv gaam minam hv vdwloka ngemare. ");
INSERT INTO tgj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ho alu, vmalo dwv, vdwlo aarikudw hum chinv kaama-aomooku gv nyidogindung vdwvka, kuunyilo vka um chima; Abu mvngchik chindu. ");
INSERT INTO tgj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaaya laka, hula doolaka, vdwlo dwv aarikunvdw nonu chima. ");
INSERT INTO tgj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","So si nyi gunv atugv naam ha nyira vdwgvlo akin-akin gv rise nga parlwkla okv agi kaaya nvngaka kaaya dubv parlwk pela adu lo mooying vngyu nyonam aingbv rire. ");
INSERT INTO tgj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Himasuto laka vbvrikunamv, ogulvgavbolo nonuno chimado vdwlo naam gv atu hv aarikudw—si arium nyika vmalo yupra nyika vmalo arumadv bv vmalo doonyie poklin madvbv. ");
INSERT INTO tgj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nw dvminmabv aaku bolo, nonua yupla doodubv ninyia kaamu rungyoka. ");
INSERT INTO tgj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ogugo ngo nonua mindudw, vbvrikunamv, ngo mindunv mvnwng ha: Hima silaka!” ");
INSERT INTO tgj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Vngbodvnam okv Vpap lwkmabv vtwng dvnam pumja alu vdwgv aase ngv loonyi go doodubv, nyibu butv vdwv la Pvbv tamsarnv vdwv Jisunyi nyi chimpa madubv naatungla mvkidubv vla kaakarnyato. ");
INSERT INTO tgj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bunu minto, “Nyi vdwv yalungyachung bv rijila, ngonu pumja alulo sum riyojuka.” ");
INSERT INTO tgj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisu Betani lo Saimon gv naam lo dooto, nw apin yaritla lvvma kunvgo. Jisu gv dvnam dvla doorilo, nyimvmvvga ako daaching pumchup gulo achialv arvdoonv nampunv piaknam ala darwk dubv mvlinnam vkv akudubv bvngla hila aato. Nw pumchup a mvkok gvrila nampunv ala um Jisu gv dumpo lo piakto. ");
INSERT INTO tgj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hoka nyi kvgunv haachirapto okv akonv akonyi raamisito. “Ogu rinvla nampu nvnga pwgga mindunv? ");
INSERT INTO tgj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sum lwngngom lvnv raaji lokdwng gubv piokgv rila okv um morko nga heemanv vdwa jiya bolo alvnamv!” Okv bunu nyimvmvvga nga achialvbv darminto. ");
INSERT INTO tgj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Vbvritola Jisu minto, “Ninyia akinbv kayu tvka! Ogubv nonu ninyia mindwkminku yadunv? Nw ngam alvnvgo okv kaapu rungnvgo rijipv. ");
INSERT INTO tgj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nonu aludwkia heemanv nyi vdwa lvkobv ribam tvdu, okv vdw dw lo mvngridw, nonu ho bunua ridurladu. Vbvritola nonu nga aludwkia lvkobv doobam paamare. ");
INSERT INTO tgj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nw ogugo rila pvdw nw rigvnyibv; Nw nampunvnga ngoogv ayaklo piaknam si ngam nyibung riidwlo rise nga riicho dunv. ");
INSERT INTO tgj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Vjak, ngo nonua jvjvbv mindu, ogoloka ho Gamlv nga nyiamooku mvnwng so japgo redw, ninyigv rinamsum, ninyia mvngpala minpa nvnv gobv ribwngre.” ");
INSERT INTO tgj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Vbvrikunamv Judas Iskeriot, lvbwlaksu vring gola anyi lokv akonv, nyibu butv vdwgvlo Jisunyi bunu gvlo koa lwkdubv vla vngtoku. ");
INSERT INTO tgj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bunu ninyigv minam ha tvvla mvngpu nyatoku, okv ninyia morko jidubv milv nyato. Vkvlvgabv Judas Jisunyi bunu gvlo laklwkdubv alvnv dw makarto. ");
INSERT INTO tgj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Vpap lwkmabv vtwng dvdw pumja gv loocho alulo, ho alu vngbodvnam lvgabv svlarkuu nga mvki toku, Jisu gv lvbwlaksu vdwv ninyia tvvkato, “Ogulo no ngonua vngbodvnam dvmin nama noogv lvgabv richola ripv tebv vngnyika mvngdunv?” ");
INSERT INTO tgj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Vbvrikunamv Jisu bunugv lokv anyi gonyi svbv milwk gvrila vngmuto: “Banggu alo aaika, okv nyi go isi pvchwng joonv go nonua vngrwksire. Ninyia vngming gvla ");
INSERT INTO tgj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ninyia naam arwng aaming gvlaka, okv naam atua minlaka: ‘Tamsarnv mindu, ngo la okv ngoogv lvbwlaksu vdwv vngbodvnam dvjiku karchung ngv ogolola?’ ");
INSERT INTO tgj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Vbvrikunamv nw nonua aolo kairungnv karchung go kaapubv okv mvdum ridumla pvvnamgo kaatamre, hoka nonu ngonu gvbv ogumvnwng nga mvpvripv nama paare.” ");
INSERT INTO tgj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lvbwlaksu vdwv vngrapla, okv banggu lo vngtoku, okv Jisu gv bunua mingkunam aingbv ogumvnwng nga paatoku; okv bunu vngbodvnam ha mvpvripv toku. ");
INSERT INTO tgj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Vdwlo arium tokudw, Jisu lvbwlaksu vring gola anyia lvkobv aatoku. ");
INSERT INTO tgj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bunu tvbul lo dvbamla doorilo, Jisu minto, “Ngo nonua mindu, nonu lokv akonv ngam koare—ho angv nga lvkobv dvbamdu.” ");
INSERT INTO tgj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lvbwlaksu vdwv mvngru toku okv ninyia tvvka rapto akonv kochingbv akonv, “Jvjvbv no nga mima dvbvre, no midunvre?” ");
INSERT INTO tgj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisu mirwkto, “Hv nonu vring gola anyi lokv akonv yvv ngam lvkobv pwrw lo ninyigv vtwng nga nwkbok minggvnv. ");
INSERT INTO tgj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nyia kuunyilo ngv Darwknv Kitaplo nw vbvrire vnam aingbv rila sire; Vbvritola nyia kuunyilo nga koanv nyi hv vdwgo mvnglv manam mvngru hiru gobv rirekudw! So nyi so gv lvgabv alvyajibvnyi ninyia bvnglin manv guilo.” ");
INSERT INTO tgj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bunugv dvla doorilo, Jisu vtwng alap go naato, umbonyikv vla kumto, um pimwkto, okv um ninyigv lvbwlaksu vdwa jitoku. Nw minto, “Sum naatoka si ngoogv ayak hv,” ");
INSERT INTO tgj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vbvrikunamv nw koobu a naata toku Pwknvyarnvnyi umbonyikv vto, okv um bunua laklwk toku; okv um bunu mvnwngngv tvngbam toku. ");
INSERT INTO tgj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jisu minto, “Si ngoogv oyi hv, mvnwng gv lvgabv sarlin pvnv, ngoogv oyi hv Pwknvyarnv gv mingkimiyak nama miu pvvnam hv. ");
INSERT INTO tgj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngo nonua mindu, ngo so gv anggor ala sum vdwloka tvngku mare vdwlo Pwknvyarnv gv Karv lo sum anw bv tvngma dvdvlo.” ");
INSERT INTO tgj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Vbvrikunamv bunu miriminpak go minto kula okv Olib moodw bv vnglin nyatoku. ");
INSERT INTO tgj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisu bunuam minto, “Nonu mvnwngngv ngam kayupila kireku, Darwknv Kitap hv mindu, Pwknvyarnv mvkire svlar kaaya nvnga, okv svlar mvnwng hv kiyak karriku. ");
INSERT INTO tgj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Vbvritola ngoogv turkurro kochingbv, ngo Galili lo nonua vngchoyare.” ");
INSERT INTO tgj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pitar mirwkto, “Mvnwngngv vbv risujeka, ngo nam vdwloka kiyumare!” ");
INSERT INTO tgj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisu Pitarnyi minto, “Ngo nam mindunv, siyu gv ayulo rokpu hv lvnyi go kokma dwbv ho no ngam chimapvnv vla lvom go minre.” ");
INSERT INTO tgj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pitar abuyabv atorla mirwkto, “Ngo nam lvkobv sidajeka, vdwloka ngo vbv mimare!” Okv kvvbi lvbwlaksu mvnwng vka lvkobv vbv mintoku. ");
INSERT INTO tgj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bunu Getsemane vnam mooku lo aalwkto, okv Jisu ninyigv lvbwlaksu vdwa minto, “Ngoogv kumrinyi soka dooyato.” ");
INSERT INTO tgj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jisu Pitar, jems, okv Jonnyi lvkobv vnggv linto. Achialvbv mvngdwk okv sakdwk kv ninyi gvlo aalwk toku, ");
INSERT INTO tgj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","okv nw bunuam minto, “Ngoogv haapok so gv mvngdwk v achialvbv kaiyajvla v nga cheloyanga mvdup duku. So dooyato okv kaayato.” ");
INSERT INTO tgj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jisu achuk gobv adu vngto, nw atubongv kvdwlo gipvto, okv vbv kumto, rinyubolo, nw hindarkasu hinkulo vngmadubv vla. ");
INSERT INTO tgj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nw kumto “Abua” “Ngoogv Abua! No gvbv ogumvnwng nga rinyudo. Mvngdwk gv koobu sam ngoogv lokv naapak labv. Vbvjvka ngoogv mvngnam bvma, vbvritola noogv mvngnam bvka.” ");
INSERT INTO tgj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Vbvrikunamv nw linkurto okv lvbwlaksu aoma yupngakla doodubv kaapato. Nw Pitarnyi minto, “Saimon, no yupdu nvri? Nonu gunta akin gv lvgabvka hula doonyu mai?” ");
INSERT INTO tgj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Okv nw bunua minto, “Hula doobwngto, okv nonu v ho pookayarka lo gilu madubv kumtoka. Dow hv alvnvnga rinwngdu vbvritola adwn hv nyakriadu.” ");
INSERT INTO tgj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nw lvkodv vngdvla okv kumtoku, minam akin gaam a minbwngto. ");
INSERT INTO tgj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Vbvrikunamv nw lvbwlaksu vdwlo aakur toku okv bunuam yupdubv kaapato; bunugv nyik hv nyiktarla bunu doonyu mato. Okv bunu chima toku ninyia ogugo mirwk svngvdw. ");
INSERT INTO tgj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nw vdwlo lvom nvnv bv aakur dvto, nw bunua mintoku. “Nonu vjak gudvbv yupdvla okv doomin nyaduai? Hv kubvcho! Kaatoka Nyia Kuunyilo a rimurnv nyi vdwgv laak lo laklwkdw v aadukunv! ");
INSERT INTO tgj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Godung to, klai ngonu vnglaju. Kaatoka, siinv yvvdw nga koanv nyi angv!” ");
INSERT INTO tgj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Vdwlo Jisu gv gaam mindung dvdubv vring gola anyi lvbwlaksu lokv akonv Judas, aachitoku. Nw gv aakulo lvkobv nyibu butv vdwgv, Pvbv tamsarnv vdwgv okv nyiga vdwgv kanamla vngmunam vkv riokse, okv daadwng bvngnv nyitwng go aaming gvto. ");
INSERT INTO tgj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Koanv nyitwng nga riring rima go mirwjito. “Ngo yvvnyi mopup redw hv nonugv naajinam nyi angvla. Nw ha naatung laka okv ninyia kaaria kolo boolwkla vnggvlaka.” ");
INSERT INTO tgj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas aachi sopikda, nw Jisu gvlo aato okv minto, “Tamsarnv!” Okv ninyia moopupto. ");
INSERT INTO tgj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Vkvlvgabv bunu Jisunyi naatung toku okv ninyia laak ha achialvbv gakbwng toku. ");
INSERT INTO tgj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Vbvritola hoka daknv nyi akonv atugv riokse nga svlin gvrila okv Nyibu Butvyachok gv pakbua nvnglinla nyarung ha paluto. ");
INSERT INTO tgj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Vbvrikunamv Jisu minrap lakula okv bunua minto, “Nonu riokse okv daadwng gv lvkobv aala nga naatung dubv ripv ai, ngam Pvbv agumlo rinv aingbv? ");
INSERT INTO tgj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ngo alu gv dwkibv Pwknvyarnvnaam lo nonuam tamsarla rito, okv nonuno nga naatung mato. Vbvritola Darwknv Kitap gv minam hv jvjvbv aarungre.” ");
INSERT INTO tgj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Vbvrikunamv lvbwlaksu mvnwngngv ninyia kayupila okv adubv kitoku. ");
INSERT INTO tgj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nyi yaapa rungnvgo, vji pakria gvnvgo, Jisu gv kochinglo vngming gvto. Nw ha bunu naatung tvvto, ");
INSERT INTO tgj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vbvritola nw vji ha adarlo kayupila ayak abinbv kiyu toku. ");
INSERT INTO tgj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Vbvrikunamv Jisunyi Nyibu Butvyachok gv naam lo aagv toku, hoka nyibu butvnv vdwv, nyiga vdwv, okv Pvbv tamsarnv vdwv doopam nyato. ");
INSERT INTO tgj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pitar adu bv vngming gvto okv nyibu Butvyachok gv naam gv pvrvlo aaming gvto. Nw atu v hoka agi dakrianv vdwa lvkobv, vmv yigu mingvla dooto. ");
INSERT INTO tgj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nyibu butv vdwv okv dookumnv mvnwng hv rikw nyato Jisunyi mingging nvnv malinla ninyia mvkinvdubv, vbvritola bunu ogugoka malin nyumato. ");
INSERT INTO tgj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Achialvnv mvvnam vkv Jisunyi minv nyato. Vbvritola bunugv minam hv lvin akin mato. ");
INSERT INTO tgj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vbvrikunamv nyi kvgonv dakrapla okv so mvvnam gaam sum Jisu gvlo milwkto: ");
INSERT INTO tgj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ngonu ninyia vbv mindubv tvvto ‘Ngo nyi gv mvnam Pwknvyarnvnaam sum mvyakre, okv alu loum kochinglo ngo ho nyi gv mvmanam ako mvre.’” ");
INSERT INTO tgj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bunu mvngchikma, vbvrijvka, bunugv minam ha lvin akin dubv minyu mato. ");
INSERT INTO tgj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nyibu Butvyachoknv mvnwng gv kaagialo dakrapla okv Jisunyi tvuto, “Bunu mvnwng gv nam gungnying lwknam ha no ogu mirwk sise kaama lare?” ");
INSERT INTO tgj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Vbvritola Jisu sudu mato okv gamgoka milin mato. Lvkodv nyibu Butvyachoknv Jisunyi tvuto, “No Kristo rungre, Ngonugv kumnamjonam Pwknvyarnv gv kuunyilo vrungre?” ");
INSERT INTO tgj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Vm Ngo mabv,” Jisu mirwkto “Okv Nyia Kuunyilo ngam kainv Pwknvyarnv gv lakbiklo doodubv okv nyidomooku tolokv doomwk lo aadu bv nonu mvnwngngv kaapare!” ");
INSERT INTO tgj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nyibu Butvyachoknv atugv vji ha putak puyak sito okv minto, “Ngonu so gv aolo kvvbi tvvlakaala minjinv yago dinchi kuma! ");
INSERT INTO tgj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nonu ninyigv Pwknvyarnvnyi nyarjitari nama tvvgvnyibv. Nonugv minbwk svngv ogugola?” Bunu mvnwngngv ninyia tokum lwktoku: nw rimur rungpv sirung dubv ripv. ");
INSERT INTO tgj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bunu kvgonv Jisunyi tachor chorbiak rapto, okv bunu Jisu gv nyik a putumto okv ninyia nwkto. “Minjwk kaato yvvla nam nwkbu hv!” Bunu minto. Okv dakrianv vdwv ninyia svbiak svriakto okv ninyia vnggv toku. ");
INSERT INTO tgj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Vdwlo Nyibu Butvyachok gv nyijar paknv vdwlokv akonv aalwkrilo Pitar vjaklodvbv pvrvlo doodvto. ");
INSERT INTO tgj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Vdwlo hv Pitarnyi vmvlo atubongv yigula doodubv kaapa pvdw, hv ninyia kadichinchila kaato okv minto, “No kai Najareth Jisu gv lvkobv rinvgo ai.” ");
INSERT INTO tgj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Vbvritola nw um mvvtoku. “Ngo chima... No ogugo mindunv ngo tvvchinma,” nw mirwksito, okv nw aagia gv agi dookubv vngyi toku. Vbvrikunamv vjakpi gubv rokpu ako koktoku. ");
INSERT INTO tgj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Paknv nyijar angv ninyia hoka kaatola okv kaala daknv vdwa mindvjito, “Nw bunugv lokv akonv!” ");
INSERT INTO tgj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Vbvritola Pitar lvkodv um mvvdvto. Achakgu ayungjvma nga dakbam vdwv Pitarnyi gungnying milwkto, “No mvvnyu mare ho bunugv lokv ako nvngvma vla, ogulvgavbolo no ka, Galili lokv mabv.” ");
INSERT INTO tgj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Vbvrikunamv Pitar minto, “Ngo atubongv jvjvbv ho milv sidunv! Ngo jvjvbv minma dvnvlo Pwknvyarnv ngam mvrit laka! Nonu yvvnyi mindunv ho nyi anga ngo chima!” ");
INSERT INTO tgj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Vbv minam gola rokpu hv lvnyi nvbv kokto, okv Pitar Jisu ogugo ninyia minpvkudw mvngpa toku, “Rokpu hv lvnyi go kokma dwbv ho no lvom go nga chima vla minre.” Okv nw mvngdwk hv mvngtung sinyu kumabv rila kaptoku. ");
INSERT INTO tgj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Arukamchi bv nyibu butvnv vdwv, baapubv nyiga vdwa, Pvbv tamsarnv vdwa, okv dookum mvnwngnga lvkobv kaarwksuto. Okv bunugv rungnam vdwa mvtoku. Bunu Jisunyi jaako lvktola, ninyia vnglin gvto, okv Pilot gvlo ninyia laklwk toku. ");
INSERT INTO tgj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilot ninyia tvuto, “No Jius vdwgv Dvbv ngvri?” Jisu mirwkto “No gv minam v mabv.” ");
INSERT INTO tgj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nyibu butvnv vdwv Jisu gvlo gungnying awgo milwkto, ");
INSERT INTO tgj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","vkvlvgabv Pilot Jisunyi tvvdidvto “No mirwk dubv mvngmare? Tvvtoka vdwgo bunu mvnwngngv nam gungnying lwkdunv!” ");
INSERT INTO tgj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lvkodv Jisu gamgoka mirwk sumato, okv Pilot mvngngak pala mvngtoku. ");
INSERT INTO tgj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vngbodvnam Pumja ngv rirap dwkibv Pilot gvlo vkvnv ribwng namgo dooto patwklo tumnam nyi vdwlokv akonyi nyi vdwgv koonam anga anyubv limu dukubv. ");
INSERT INTO tgj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vbvriri ho nyi ako aminv Barabas vnam gonyi vdwa yalung dula gwngrw gwnv go patwk arwnglo dooto. ");
INSERT INTO tgj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Vdwlo nyitwng ngv vngkum tokudw okv bunu Pilot ninyigv ribu ha rijilabv vla kooto. ");
INSERT INTO tgj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nw bunua tvvkato, “Nonu ngam jius gv Dvbv nga nonugv lvgabv anyubv topu jilabv vla mvngdure?” ");
INSERT INTO tgj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bunugv tanyum gvnam lokv nyibu butv vdwv Jisunyi ninyi gvlo laklwk dunv vla Pilot alvrungbv chinto. ");
INSERT INTO tgj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Vbvritola nyibu butvnv vdwv nyitwng nga bunugv lvgabv Barabasnyi anyubv tulin jilabv vla Pilotnyi mintokv vla miarto. ");
INSERT INTO tgj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilot nyitwng nga lvkodv tvvkato, “Vbvrikunamv, nonugv Jius vdwgv dvbv ngv, vnam nyi sum ngam ogu ritokv vla mvngdu?” ");
INSERT INTO tgj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bunu rumla gokorto, “Ninyia Daapolo takki toka!” ");
INSERT INTO tgj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilot tvvka tokuda, “Vbvritola ogunv rimur gula nw ripvnv?” Bunu abuyabv rumla gokto “Ninyia Daapolo takki toka.” ");
INSERT INTO tgj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilot nyitwng nga rinyok dubv mvngto, vkvlvgabv nw bunu gvbv Barabasnyi anyubv tulin jitoku. Vbvrikunamv Pilot Jisunyi svnyak pamutoku, okv bunugv laaklo ninyia daapo lo takki dukubv jilwk toku. ");
INSERT INTO tgj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sipai vdwv bunugv ajin vdwa gokkum silaila Jisunyi Pilot nyigam gv kvba baaku pvrvlo vnggvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bunu lvngching lwngbonv vji vkv jvtvlaklwk gubv Jisunyi pilwkto, tvv doonv hakbv lokv dunggar bv mvto, okv um ninyigv dumpo lo pilwkto. ");
INSERT INTO tgj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Vbvrikunamv bunu salaam mvminto: “Jius vdwgv Dvbv ngv turbwng laka!” ");
INSERT INTO tgj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bunu ninyigv dumpo nga daadwng lokv dvngto, ninyia tachor chorke toku. Ninyia bunu lvbwng ngv kumpvto, okv guplwkto. ");
INSERT INTO tgj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Vdwlo bunu ninyia rijirio svngam rinya tokudw, bunu ninyigv ayak lokv lvngching lwngbonv vji pilwk nama pilintoku okv ninyigv vji gvbwng nama pikkur lwktoku. Vbvrikunamv bunu ninyia daapolo takki dubv linggv toku. ");
INSERT INTO tgj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lamtvlo bunu nyi go aminv Saimon vnamgo vngrwk suto nw mooku lokv pamtv bv aanvgo, okv ninyia sipai vdwv Jisu gv Daapo ngam joodu bv mililalato. (Saimon nw Sairene lokv okv Alekjandar gvla Rupus gv abuv.) ");
INSERT INTO tgj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bunu Jisunyi Golgota vnam mooku lo aalwk gvto. “Golgota vnam si dumku gv mooku.” ");
INSERT INTO tgj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hoka bunu ninyia anggor ala lo nvnv mvyomvchinam miir vnam, vkv jitv tvvto, vbvritola Jisu um tvngmato. ");
INSERT INTO tgj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Vbvrikunamv bunu ninyia hoka daapolo takki toku okv ninyigv vji ha bunu mvnwng hv ormi sitoku, vji arip ha yvv paaridw vla kaakanvbv vlwng lika suto. ");
INSERT INTO tgj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Vdwlo ninyia bunu Daapolo takki rilo ho aru gv gunta kiya baji bv ritoku. ");
INSERT INTO tgj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ninyia gungnying lwgvnvnv nga “Jius vdwgv Dvbv” vla lvktola kaapadubv timpvto. ");
INSERT INTO tgj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bunu dvritnaaritnv nyi anyi goka Jisunyi lvkobv akonyi lakbik kyambv okv akonyi lakchi kyambv takkito.  ");
INSERT INTO tgj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Vkv aingbv Darwknv Kitap hv jvjvbv ritoku ho mindu “Nw alvmanv nyi vdwgv aje ha naapin sipv” ");
INSERT INTO tgj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lamtv lokv vngpiknv nyi vdwv dumpo ngv dumpv panyula riying dvla Jisunyi minjimiobv svbv minto, “Ah ha! No Pwknvyarnvnaam ha mvyak gvrila alu loum lo mvrung tvdukui! ");
INSERT INTO tgj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Vjak Daapo hokv itokuka okv no atu hv mvtursito kuka!” ");
INSERT INTO tgj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Vbvdvdvbv nyibu butvnv vdwv okv Pvbv tamsarnv vdwv, Jisunyi nyarji minto, bunu mimisito, “Nw kvvbi vdwa ringlato, vbvritola nw atu hv ringsu-nyuma! ");
INSERT INTO tgj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Klai kaalaju Kristonyi, Israel gv Dvbvnyi, vjak Daapo lokv idu kubv, ho ngonu ninyia mvngjwng rikunv!” Okv ninyia takulo taktanam nyi anyi vka Jisunyi minjimiola mindvto. ");
INSERT INTO tgj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Vdwlo alu lopo tokudw, mooku mvnwnglo kanv toku, v gunta aom gubv doobwngto. ");
INSERT INTO tgj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Gunta aom baji bv Jisu gamtv rungbv gokla minto “Eloi, Eloi, lama Sabakthani?” So vnam si “Ngoogv Pwknvyarnv, ngoogv Pwknvyarnv no ogu bv ngam topak duku nvla?” ");
INSERT INTO tgj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nyi mego hoka doonv vdwv ninyigv minam um tvgvrila minto, “Tvvtoka nw Elijanyi gokdu!” ");
INSERT INTO tgj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bunugv lokv akonv riolwkto tachak pupam go bvngla, um kungsoknv opolo nwkbokto, okv um singda nyiktoklo pubwngto. Vbvritola nw um Jisugv naptwng naborlo tungsala tungpvto okv minto, “Dooyato! Klai kaalaju lvkonyika Elija aala ninyia Daapo loka naalu ridw!” ");
INSERT INTO tgj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gamtv rungbv gokto kula Jisu sitoku. ");
INSERT INTO tgj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pwknvyarnv gv naam arwnglo darwk yachoknv karchung lo vji torchik nvnv ngv mvngring lokv lvtwng lobv taknyi gubv takpinsito. ");
INSERT INTO tgj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sipai nyigam daapo kaagia gv nvchilo daktola, Jisu oguaingbv sipvdw um vdwlo kaatodw nw svbv minto, “Si Nyi si jvjvbv Pwknvyarnv gv kuunyilo gurung!” ");
INSERT INTO tgj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hoka nyimvmvvga vkv mego, adu lokv kaatinla dakto. Hv bunu Meri Magdalene, boruya Jems gvla Josep gv anv Meri okv Salom. ");
INSERT INTO tgj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bunu Jisu gv Galili lo rerilo remin gvnv ngv okv ninyia ridur nvngv. Okv ninyia vngming gvla Jerusalem lo vngming gvnv nyimvmvvga vkvsin awgo rito. ");
INSERT INTO tgj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Arium dindin bv ritoku, vdwlo Arimatia lokv Josep aalwk todw. Nw Jius kvba vdwgv mvngdvnam nyi gubv rito, nw Pwknvyarnv gv Karv gv aase nga dooya nvgo. Ho alu hv Richo minchola ridw alu bv rito (Vnamsi Jius Doonualu ham loochoyanv), vkvlvgabv Josep mvngrwla Pilot gv dookulo aala Jisu gv svma nga kooto. ");
INSERT INTO tgj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jisu sipvku vnam ha tvvtola Pilot achialvbv lamtoku. Nw sipai nyigamnyi gokla okv Jisu kajo sirokuri vla tvvkato. ");
INSERT INTO tgj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sipai nyigam gvlo tvgapro kochingbv, Pilot Josepnyi svma nga naala duku vla minto. ");
INSERT INTO tgj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep vji jebor go rvvgv rila, svma nga naalu laku, vji jebor hv tumgv rikula, okv nyibung arwnglo vvpv toku, nyibung ngv vlwng lvngtak golo dulwknam go. Vbv mvgvrila nw agi a vlwng pwktv rungnvgo ngortum to. ");
INSERT INTO tgj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Magdalene okv Josep gv anv Meri bunu kaariala okv Jisu gv svma nga vvpv konga kaatoku. ");
INSERT INTO tgj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jius Doonualuv vngro kochingbv, Meri Magdalene, Jemsgv anv Meri, okv Salom bunu Jisu gv svma lo piakdubv vla amok nampunv vkv rvvtoku. ");
INSERT INTO tgj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Vjwng alu gv achialv arukamchi bv, doonyi chaalin dukubv, bunu nyibung lo vngto. ");
INSERT INTO tgj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Bunu lamtvlo akin akin v raami sila vngto, “Yvvkudw ngonugv lvgabv nyibung agi gv vlwng a ngorkok jijinv?” (Ho vlwng angv maatarbv pwktv nvgo.) Vbvrikunamv bunu kaadung namv vlwng ngv ngorkokla doodubv kaapato. ");
INSERT INTO tgj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vkvlvgabv bunu nyibung arwnglo aato, hoka bunu nyi yaapa go yapungnv vji gvnvgo lakbik kyambv doodubv kaapato, ho bunu lamla busuto. ");
INSERT INTO tgj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nw minto, “Lamla busu mabv” “Ngo chindu nonu Najaret lokv Jisunyi makardu, yvvnyi daapo lo takki nama. Nw so dooma—nw turkur roku! Kaatoka bunugv ninyia vvpv konga. ");
INSERT INTO tgj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vjak vngyikula okv ninyigv lvbwlaksu vdwam, Pitarnyi mintala bunua so doin sam minji tekuka: ‘Nw Galili lo nonua vngchoyare; ninyigv nonuam mintam kunam aingbv, nonu ninyia alo kaarwk sire.’” ");
INSERT INTO tgj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Vkvlvgabv bunu achialvbv mvngdwkla okv lamla nyibung lokv jokla kula vnglintoku. Bunu yvvnyika ogugo mimato, ogulvgavbolo bunu busu nyato.  ");
INSERT INTO tgj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisu gv sitokula turkurro kochingbv Vjwng alu gv arukamchi bv, nw Meri Magdalenenyi kaatam sichoto, ninyigv uyuvram kanw go charlin kunam anga. ");
INSERT INTO tgj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nw vngtoku okv mvngdwkla kapla rila doonv Jisu ninyigv lvkobv rigvnam bunu vdwa mintam jitoku. ");
INSERT INTO tgj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bunu Jisu turpvku okv nw Jisunyi kaarwksuto vnam um tvvtolaka, bunu hum jvjvbv mvngma nyato. ");
INSERT INTO tgj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","So kochingbv, Jisu nyidum anyi gonyi akusubv kaatam sutoku vdwlo bunu bunugv diringmooku lamtvlo vngrilo. ");
INSERT INTO tgj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bunu vngkur toku okv kvvbi vdwa minpa toku vbvrijvka bunu hum tvvjing mato. ");
INSERT INTO tgj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ataranya bvku, Jisu lvbwlaksu vring gola akin gonyi kaatam sutoku bunugv dvnam dvla doorilo. Nw bunua yamtoku ogulvgavbolo bunu gvlo mvngjwng doomato okv ogulvgavbolo bunu achialvbv tvvjing nyuma nvgobv rito yvv bunu ninyia turpv vla kaatola mintam namaka tvvjing mato. ");
INSERT INTO tgj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nw bunua mintoku, “Vngnyika nonu nyiamooku mvnwnglo okv Gamlv nga nyi mvnwnglo japji teka. ");
INSERT INTO tgj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yvv bunu mvngjwngla Baptisma naaredw v bunu ringnam a paareku; Okv Yvv bunu mvngjwng maredw bunu ngooriku. ");
INSERT INTO tgj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mvngjwngnv vdwgvlo svkvnv lamrwpabv rigvnvnv jwkrw ngv lvkobv dooming gvriku: Bunu ngoogv amin lokv uyuvram vdwa charpakre; Bunu akusunv gaam japlare; ");
INSERT INTO tgj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bunu tabw vdwa naarapjeka vmalo chumdwk haka tvngjeka, bunua ogu rimare; bunu nyi lvvmanv aolo laak lakpvbolo lvvmanv poyariku.” ");
INSERT INTO tgj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ahtu Jisu gv bunua mintamro kochingbv, ninyia nyidomooku bv naacha toku, okv ninyia Pwknvyarnv gv lakbik kyamlo doomu toku. ");
INSERT INTO tgj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Lvbwlaksu vdwv vnglintoku okv mooku mvnwnglo japgo jitoku, okv Ahtu bunua lvkobv reming gvto okv bunugv japji namv jvjv gorung mvngdubv lamrwpadubv rila kaatam jitoku.");
INSERT INTO tgj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ayanam Tiopilas: Ngonugv pinko so ogugo ripvkudw hum lvkdubv awgo nyi vdwv bunugv lvgvlvmabv rikw nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ogugo ripvkudw um atuk alu lo tvvnvkaanv vdwgv doin a japkarla ngonua minji kunama bunu lvktoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Okv vkvlvgabv, ngonugv chinvpanv nga, ogulvgavbolo so minam gaam mvnwng nga atuk lokv ngo alvrungbv himpv kaapv kunv, hung mvnwngnga nonugv lvgabv jubjirvyi dubv lvkla pvji bolo alvyari vla ngo mvngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngo sum ridu ogulvgavbolo nonua minjinam ho gv jvjv mvnwngnga alvbv chimuso mvngla. ");
INSERT INTO tgj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod gv Judia lo Dvbv bv rila singrilo hokaka nyibu go aminv Jakaria vnamgo dooto, nw Abija vnam gv nyibu buli haalung lokv. Ninyigv nyimv gv aminv Elijabet; hvvka nyibu buli haalung lokv. ");
INSERT INTO tgj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Anyiv Pwknvyarnv gv kaagialo alvbv rila reto, okv Ahtu gv nyetin Pvbv nga alvbv mvnggapla rila reto. ");
INSERT INTO tgj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bunyi kuu kaamato ogulvgavbolo Elijabet akoka bvngmato, okv nw okv Jakaria bunyi achialvbv nyikam ongu toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Alu logolo Pwknvyarnvnaam lo Jakaria nyibubv rila ninyigv kudungkua rise nga naala ridungto, ");
INSERT INTO tgj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nyibu vdwgv riching bv rila, Pwknvyarnvnaam lo nampunv mwkwmwya mwwkulo mwwnam lvgabv amin chinka sila riku lo ninyia chimpa toku. Vkvlvgabv nw Ahtu gv Pwknvyarnvnaam lo vngtoku, ");
INSERT INTO tgj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","vdwlo nampunv mwkwmwya mwwdw v aapv kudw nyi nyitwng ngv agumlo kumtoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ahtu gv nyidogindung gonv nampunv mwkwmwya mwwku lakbik kiambv daktola ninyia kaatam sitoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Vdwlo Jakaria nyidogindung nga kaapa tokudw, nw lamla okv busuto. ");
INSERT INTO tgj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Vbvritola nyidogindung ngv ninyia minto, “Jakaria, busu mabvka! Pwknvyarnv noogv kumnam a tvvpa pvku, okv noogv nyimv Elijabet nam kuunyilo ako bvngjire. No ninyia Jon vla amin minlaka. ");
INSERT INTO tgj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Vdwlo ninyia bvnglin kubolo, noola okv kvvbi vdwv vdwgo mvngpunam gubv ririkudw! ");
INSERT INTO tgj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nw Ahtu gv kaagialo kainv nyi gobv rire. Nw opo tvngrung mare. Ninyia bvnglin rilokv nw Darwknv Dow gvnvgubv rire, ");
INSERT INTO tgj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","okv nw Israel nyi vdwam Ahtu gvlo bunugv Pwknvyarnv gvlo awgo aagv jireku. ");
INSERT INTO tgj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nw nyijwk Elija gv aingbv gwlwk okv kaibv gwlwk am gvvla, Ahtunyi vngchoyare. Nw lvkodv abu hala kuu vdwa lvkobv naadum sireku; Nw tvvma kaamanv nyi vdwa jvjvgv lamtv yalo vla mvngkur dukubv mvreku; Nw Ahtu gv nyi vdwa Ahtu gv lvgabv mvpvripv jidukubv mvreku.” ");
INSERT INTO tgj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakaria nyidogindung nga minto, “Ngo oguaingbv hum chinbwk sudubv? Ngo nyikam roku okv ngoogv nywng vka ongngu roku.” ");
INSERT INTO tgj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nyidogindung ngv mirwkto, “Ngo Gabriel, ngo Pwknvyarnv gv kaagia lo daknv, nam gaam japdubv okv soogv alvnv yunying nga minpa modubv nw ngam vngmupvnv. ");
INSERT INTO tgj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Vbvritola ngoogv doin ridwlo jvjvbv rilin jinvnga no tvvjwngma. No mvngjwng manam lvgabv, no gaam japlin nyuma reku; vdwlo ngoogv nam milvnamv jvjvbv rilin maredw no choibv dooriku.” ");
INSERT INTO tgj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Vbvrirelo nyi vdwv Jakarianyi kaaya toku okv bunu ninyia ogubvdabvre ogubv Pwknvyarnvnaam arwnglo vkamjegu ringak dvnvdw vla mvngnya toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Vdwlo nw agumlo lintokudw, nw bunuam gaam minyu matoku, vkvlvgabv nyi vdwv ninyia Pwknvyarnvnaam arwnglo nyikrw go kaapv nvgo vla mvngnya toku. Gamgoka milin nyumato, nw bunuam laak lokv riringrimabv riji toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Vdwlo ninyigv ridung rise nga ritokubvdw nw naambv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Dw mego dooro kochingbv ninyigv nywng Elijabet kuu gvvtoku okv poolu pwngu go naam a vngyu matoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nw minto “Vjak ataranyabv Ahtu ngam ridur pvku, nyi vdwgv kaagialo ngoogv hinying svnga Ahtu naala naa jipvku!” ");
INSERT INTO tgj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elijabet gv kuu gvla poolu pwkv rikulo, Pwknvyarnv nyidogindung Gabrielnyi Galili gv banggu aminv Najareth vnamlo vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nw gvlo nyijar agv lvgabv minji dubv doin go dooto, hv nyi ako golo aminv Josep vnam gvlo mingak jinam go, Josep Dvbv Dabid gv husi bv rito. Nyijar gv aminv Meri. ");
INSERT INTO tgj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nyido gindung ngv nyijar gvlo aala minto, “Mvngpuv nam lvkobv doolaka! Ahtu nam lvkobv doodu okv nam kairungbv boktalwkjidu!” ");
INSERT INTO tgj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nyidogindung gv doin lokv Meri achialvbv adwkaku toku, okv nw ninyigv gaam minamv oguvdw vla mvngdung mvngbap kartoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nyidogindung ngv ninyia minto, “Meri, no busu mabvka; Pwknvyarnv nam achialvbv ayado. ");
INSERT INTO tgj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","No kuu gvvre okv nyilo gobv bvngre, okv no ninyia Jisu vla amin minre. ");
INSERT INTO tgj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nw kainvgobv rire okv Kaiyachoknv Pwknvyarnv gv Kuunyilo ngv vla ninyia minre. Ahtu Pwknvyarnv ninyia Dvbv gobv mvre, ninyigv abuapa Dabid aing gubv, ");
INSERT INTO tgj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","okv nw Jakob gv husi lokv doobwngjinv Dvbv gobv rire; ninyigv Karv ngv vdwloka ngekumare!” ");
INSERT INTO tgj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri nyidogindung nga minto, “Ngo nyijar darwk nvgo. Vbvrikunamv si oguaingbv rinyure?” ");
INSERT INTO tgj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nyido gindung ngv mirwkto, “Darwknv Dow ngv no gvlo doolwkre, okv Pwknvyarnv gv loung ngv no gvlo doonure. Vkvlvgabv darwknv anga hum Pwknvyarnv gv Kuunyilo ngv vla minre. ");
INSERT INTO tgj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Noogv amiasa Elijabetnyi mvngka tvnv. Ninyia vdwloka kuu doonyu kumare vla minyato, vbvritola nw achialvbv ongubv ritolaka vjak atuv kuu gvlaku poolu pwkv pvku. ");
INSERT INTO tgj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Vkvlvgabv Pwknvyarnv gvlo ogugoka rinyu manamgo kaama.” ");
INSERT INTO tgj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri minto, “Ngo Ahtu gv paknv ngv, noogv minam vbv ngam rimulaka.” Okv nyidogindung ngv ninyia vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Vbvriro sopikda Meri baapubv mvgemvrap sitoku okv Judia mooku gv moodw lokv doonv banggu akolo baapubv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nw Jakaria gv naamlo aato okv Elijabetnyi mvngpula raarwk sitoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Vdwlo Elijabet Meri gv mvngpula raarwk sinama tvvpa pvkudw, leit gv anga ngv biitoku. Elijabet gvlo Darwknv Dowv doolwkto ");
INSERT INTO tgj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","okv gamtv rungbv gokla minto, “Nyimv mvnwng lokv no kaiyachokbv boktalwkji kunamgo, okv noogv anga bvngjinam angv boktalwkji nama gvnvgo! ");
INSERT INTO tgj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Svkvnv ogu kainv ngoogvlo ogubv ripv nvdw, v ngoogv Ahtu gv anv ngv aala ngam kaalwkyadunv? ");
INSERT INTO tgj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Noogv alvpvri vnama ngo tvvpa sopikda, ngoogv arwng gv anga si mvngpula chumkar toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ahtu gv nam minam v jvjvbv ho rirungre vla mvngjwng kunamv no vdwgo mvngpu vku!” ");
INSERT INTO tgj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meri mitoku, “Ngoogv haapok v Ahtunyi hartv do; ");
INSERT INTO tgj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ngoogv yalu hvka mvngpudo ogulvgavbolo Pwknvyarnv ngoogv Ringnv, ");
INSERT INTO tgj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","nw nga mvngpa toku, ninyigv anyanv paknv gvbv Vjak gvlokv nyi mvnwng ngv ngam mvngpunv vre, ");
INSERT INTO tgj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ogulvgavbolo Kairungnv Pwknvyarnv ngoogv lvgabv kainvgo rijipv Ninyigv aminv Darwknv; ");
INSERT INTO tgj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","yvvdw ninyia mvngdv dunv um nw singtam gonv lokv singtam gonv lobv aya kaatamdu. ");
INSERT INTO tgj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ninyigv kainv laakv laklinla okv kai mvngsunv bunugv rungnam mvnwngnga mvyakriyak toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nw kainv dvbv vdwa bunugv dvbvdooging vdwloka naalu toku, okv nyaknyinv vdwa naacha toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nw kanonv vdwa alvnv dvnam lokv dvji motoku, okv nyitv vdwa laak arobv vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nw ngonugv abuapa vdwa milv kunama vvbwngto, okv ninyigv pakbu Israel vdwa ridurbv aatoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nw Abraham okv ninyigv husi mvnwngnga dvbvsingtambv aya jise nga mvngpa toku!” ");
INSERT INTO tgj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri poolu pwom gubv Elijabetnyi lvkobv dootokula okv vbvrikunamv naambv vngkur toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elijabet ninyigv kuu nga bvngkunam lvgabv dw v aatoku, okv nw kuunyilo gobv bvnglin toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ninyigv namrwk ajin okv ninyigv amiasa ngv tvvpatoku vdwgo kairungnv alvnvgo ninyia Ahtu ripv vla, okv bunu mvnwngngv ninyia lvkobv himpu minggv toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Vdwlo anga ngv kaila alu pinw tokudw, bunu ninyia ayakmvu dubv aatoku, okv bunu ninyia abu Jakaria gv kochingbv vla Jakaria vla amin mintvto. ");
INSERT INTO tgj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Vbvritola ninyigv anv ngv minto, “Maa! ninyigv amin am Jon vdubv.” ");
INSERT INTO tgj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bunu ninyia minto, “Vbvritola ho aminv nonugvlo vkvnv amin doringnv kaama!” ");
INSERT INTO tgj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Vbvrikunamv bunu ninyigv abua vmia ogu amin minso mvngpvdw vla kaachin dubv rijitoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakaria lvknvnv atakgo kooto okv lvktoku, “Ninyigv aminv Jon.” Bunu mvnwngngv lamdokpanya toku! ");
INSERT INTO tgj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Vbvrire hoka Jakaria lvkodv gaam milin nyutoku, okv Pwknvyarnvnyi hartv raptoku. ");
INSERT INTO tgj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Namrwk ajin mvnwngngv lvkobv busu nyatoku, okv svbv rikunam gv yunying ngv Judia gv moodw diringmooku mvnwnglo dupwng toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hum tvvpanv vdwv ho lvkwng nga mvngnyato okv “Si vmi si ogubv riji nvgo bri?” Vla tvvka nyato, vkvlvgavbolo ninyigvlo Ahtu gv jwkrwv kaapadubv doolwk rungpv. ");
INSERT INTO tgj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon gv abu Jakaria gvlo Darwknv Dow v doolwkto, okv nw Pwknvyarnv gv doin a minto: ");
INSERT INTO tgj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Klvi Ahtunyi hartv laju, Israel gv Pwknvyarnvnyi! Nw ninyigv nyi vdwa ridurnam lvgabv aatoku okv bunua ringlin toku. ");
INSERT INTO tgj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nw ngonua kainv ringria nvgo jipvku, ninyigv pakbu Dabid gv husi go. ");
INSERT INTO tgj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kvvlo lokv nw milv toku ninyigv darwknv nyijwk vdw gvlokv ");
INSERT INTO tgj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","nw ho ngonua nyimak vdwloka ringria jinvku, ngonua kaanwng manv vdwgv gwlwk lokv ngaka. ");
INSERT INTO tgj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nw ngonugv abuapa vdwa aya kaatamre vla minto okv ninyigv darwkbv milvnam a mvngpa reku. ");
INSERT INTO tgj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ngonugv atu Abrahamnyi lvkobv gamrw go rwkmi sunam v, nw milv toku ngonugv nyimak lokv nga ngonua ringdukubv okv ninyia busu kaakumabv ririavngria jidukubv, ");
INSERT INTO tgj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ngonugv singnam alu dvkiam ngonu ninyigv kaagia lo darwk okv jvjv kunam lvgabv.” ");
INSERT INTO tgj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“No, ngoogv kuu, nam minre Kaiyachok nvgv Pwknvyarnv gv nyijwk. No Ahtunyi vngchoyare ninyigv lvgabv lamtv nga pachola papv jire, ");
INSERT INTO tgj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ninyigv nyi vdwa minpa tvka ho bunugv rimur a mvngnga jila bunu ringnam a paariku. ");
INSERT INTO tgj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ngonugv Pwknvyarnv aya okv nyanyaknv. Nw nyido tolokv ringnvbaanv gv loung am ngonu gvlo unglwk jire ");
INSERT INTO tgj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","okv hoogv siku gv kanv doonyum lo doonv mvnwng gvlo nyido tolo gvngv ungka dukubv, ngonugv korla vngnam a sarsopoyo lamtvlo chigudabia dukubv.” ");
INSERT INTO tgj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Vmiv singchala amar lokvla dow lokv chvrvto, okv nw Israel nyi vdwlo kaatam sudw alu lobv mootum lo rito. ");
INSERT INTO tgj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ho gv dw lo Dvbvyachoknv Agastas Roman mooku mvnwng gv nyi vdwa kika dubv vla amin lvkdubv kanam go namlin to. ");
INSERT INTO tgj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Vdwlo ritu rike bv nyi amin kiraplvkrap tokudw, ho Kuirinas Sairia gv gobunor bv rito. ");
INSERT INTO tgj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Vbvrikunamv nyi mvnwngngv, atuatu gv nampum lo amin lvkdukubv vngnya toku. ");
INSERT INTO tgj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep Najaret banggu Galili lokv Betlehem banggu gv Judia lo Dvbv Dabidnyi bvngku lo vngto ogulvgavbolo nw Dabid gv haalung lokv. ");
INSERT INTO tgj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nw ninyigv nywng bv vla milvla mingak kunam Merinyi lvkobv amin lvkgap dubv vnggv toku. Meri hoka leit lo kuu gvtoku, ");
INSERT INTO tgj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","okv vdwlo bunu Betlehem lo aalwk tokudw ho kuu anga bvnglin dw v aatoku. ");
INSERT INTO tgj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nw bvngtubvngke bv kuunyilo gubv bvnglinto, vji lo kvlap gvrila svv dvgianvnv dooku lo joopvto—hoka hotel lo bunugv lvgabv doojiku aronv karchung go dookumato. ");
INSERT INTO tgj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ho gv mooku hoka svlar kaayanv vdwv rongolo ayu a yupram dvla, nwbunugv svlar am kaaya nyato. ");
INSERT INTO tgj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ahtu gv nyidogindung go bunu gvlo daklwkto, okv Ahtu gv yunglit a bunugv aolo kaatamto. Bunu achialvbv busu nyatoku, ");
INSERT INTO tgj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","vbvritola nyidogindung ngv bunuam minto, “Busu mabvka! ngo soka nonugv lvgabv alvnv yunying nga aagvdu si nyi mvnwngnga kairungbv mvngpu more. ");
INSERT INTO tgj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Soogv alu so Dabid gv banggulo nonua Ringnv nga dwrwboklin pvku—Hv Ahtu Kristo! ");
INSERT INTO tgj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Okv so sum nonu vbv kaachin riku: Anga go vji kvlap tvla svv dvgianvnv dokv lo doodubv kaapare.” ");
INSERT INTO tgj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lamdadubv nyidomooku gv kainv nyidogindung vdwv achialvbv nyidogindung anga lvkobv kaarwksula Pwknvyarnvnyi hartvla mirimimpak minto: ");
INSERT INTO tgj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yunglit namv aoyachoknv nyidomooku lo doonv Pwknvyarnv gvbvkula, okv mvngpuv Sichingmooku so ninyigv mvnglwkbv rinv vdwlo doolwk laka!” ");
INSERT INTO tgj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Vdwlo nyidogindung vdwv bunu gvlokv vngro tokudw nyidomooku lo chaakor toku, Svlar kaayanv vdwv raamisito, “Klai ogugo ripvkudw Ahtu gv ngonua minpa kunam vdwsum kaadubv, ngonu Betlehem bv vnglaju.” ");
INSERT INTO tgj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Vkvlvgabv bunu baapubv vngla okv Meri nyila Josepnyi paato okv svv dokv arwnglo anga nga doodubv kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Svlar kaayanv vdwv ninyia vdwlo kaato kudw bunu hoka anga gv lvkwng nga nyidogindung vdwv ogugo minpvkudw um bunua mintam jitoku. ");
INSERT INTO tgj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Svlar kaayanv vdwgv minama tvvpanv mvnwngngv lamdokpanya toku. ");
INSERT INTO tgj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","So ogumvnwng sum Meri mvngapla okv soogv lvkwng nga rungrwngbv mvngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Svlar kaayanv vdwv bunu ogugo tvvpv kudw okv kaapv kudw ho lvkwngbv Pwknvyarnvnyi hartvla mirimimpak miyingla vngkur toku: nyidogindung gv bunua minam jvbv si ritoku. ");
INSERT INTO tgj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Alu kanw kochinglo, vdwlo anga nga ayakmvu dw ngv aatokudw, nyidogindung gv ninyia leit lo gvvmadwbv amin minama minla, ninyia Jisu vla amin mintoku. ");
INSERT INTO tgj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses gv Pvbv gamki kolokv, Josep okv Meri bunyi kumkakjokak sidukubv dw ngv aatoku. Vkvlvgabv bunu anga nga Ahtu gvlo kumlwk dukubv vla Jerusalem lo aagv toku, ");
INSERT INTO tgj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ahtu gv Pvbv lo svbv lvkpvdu: “Kuunyilo bvngchonam dvdv nga Ahtu gvlo kumlwk jidubv.” ");
INSERT INTO tgj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bunu kobutor vmalo taakw kwpa nvvnyi go erinpeelwk dubv bvnglayila vngto, hv Ahtu gv Pvbv lokv ribwngnam ridung ngv. ");
INSERT INTO tgj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ho gv dw lo hoka nyi ako aminv Simeon Jerusalem lo doodung nvgo. Nw alvnvgo, Pwknvyarnvnyi busu nvgo okv nw Israel nyi vdwa ringlinbaalin nama kaayala doonvgo. Darwknv Dowv nw gvlo dooming gvto ");
INSERT INTO tgj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","okv ninyia milv jito nw vdwloka sicho mare Ahtu gv milv kunam Kristonyi nw kaama dvdvlo. ");
INSERT INTO tgj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Darwknv Dow gv riku lokv, Simeon Pwknvyarnvnaam bv vngto. Vdwlo Anvabuv anga Jisunyi Pwknvyarnvnaam lo Pvbv gv rise nga ridubv vla aagv tokudw, ");
INSERT INTO tgj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon anga nga naala ninyigv laaklo joobwng gvrila Pwknvyarnvnyi umbonyikv vto: ");
INSERT INTO tgj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vjak, Ahtu, no vvpvrungdo noogv milv nama, okv no noogv nyira nga sarsopoyo bv vngmu riku. ");
INSERT INTO tgj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ngoogv nyik lokv ngo noogv ringlinbaalin nama kaatokubv, ");
INSERT INTO tgj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","noogv nyi mvnwng gv kaagia lo mvpvripv jiku nama: ");
INSERT INTO tgj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Noogv mvngnama Jentail vdwa loung bv kaatam svnga okv noogv Israel nyi vdwlo yungnam gobv naalwk jise nga.” ");
INSERT INTO tgj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ninyigv lvkwngbv Simeon gv minama anga gv anv okv abuv tvvtokula mvngngak patoku. ");
INSERT INTO tgj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon bunuam boktalwkji toku okv ninyigv Anv, Merinyi minto, “So vmi anga si Pwknvyarnv gv gaknamgo mvyaknam lvgabv okv Israel lo awgo turnama paakunam lvgabv. Nw Pwknvyarnv gvlokv kachinnam gubv rire ho awgo nyi v ninyia minyingre. ");
INSERT INTO tgj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Okv vbvrila kaatamre bunugv mvngsila mvngnama. Okv mvngdwkkv, noogv atubogv haapok am rioktung ripunv ako nwkko sunam aingbv rire.” ");
INSERT INTO tgj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ho hoka nyimv nyijwk ako dooto, hv hvngmi go aminv Anna, Paanuel gv kuunyijar Asher haalung lokv. Nw anying kanw go nyilo doogvla dootokula okv vjak nw anying chaampinw gula nyingpi loku ongubv ritoku. Nw Pwknvyarnvnaam a vdwloka vngyu mato; aluayu bv nw Pwknvyarnvnyi kumlajola okv yikla dooto. ");
INSERT INTO tgj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ho dw akin hoka nw aalwkto okv Pwknvyarnvnyi umbonyikv hvto okv yvvbunudw Jerusalem um vdwlo ringtv dunvdw um Pwknvyarnv gvlo kaayala doonv vdwgv apumlo vmi anga agv lvkwng nga mintoku. ");
INSERT INTO tgj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Vdwlo Josep la Meri Ahtu gv Pvbv gv minam rise nga rinya tokudw, bunyi Galili gv banggu Najaret bunugv naamlo akur toku. ");
INSERT INTO tgj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Vmi hv okv gwlwk nvgobv singchato; nw chingkipakok nvgobv, okv Pwknvyarnv gv boktalwkji namv nw gvlo doomin gvto. ");
INSERT INTO tgj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Anying dwkibv Jisu gv Anvabu hv Jerusalem bv vngkito vngbo dvmin pumja lvgabv. ");
INSERT INTO tgj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Vdwlo Jisu anying nyingring gula nyingnyi tokudw, bunu pumja vngbwng nga vngto. ");
INSERT INTO tgj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Vdwlo dvbamnam pumja ngv rinya tokudw, bunu naam bv vngkur raptoku, vbvritola vmi Jisu Jerusalem lo doolwkto. Hum nw gv anvabuv chimato; ");
INSERT INTO tgj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","bunu ninyia nyitwngnga lvkobv vngdunvpv vla mvngto, vkvlvgabv bunu alu logo vngkwng toku okv vbvritola ninyia bunugv amiasa lo okv ajin vdwgvlo makar raptoku. ");
INSERT INTO tgj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bunu nw am mapa kumato, vkvlvgabv bunu ninyia makarla Jerusalem lo vngkur toku. ");
INSERT INTO tgj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Alu loum nvnvlo bunu ninyia Pwknvyarnvnaam lo Jius tamsarnv vdwa lvkobv, bunuam tvvriala okv tvunamgo tvvkala doodubv kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nw gv chingkipakok rungbv mirwk sinam a tvvnv vdwv mvngngakpanya toku. ");
INSERT INTO tgj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ninyigv anvabu v mvngngakpala mvngto vdwlo ninyia kaapa tokudw, okv ninyigv anv ninyia minto, “Ngoogv Kuunyilo no ogubv svbv ngonua ridunv? Noogv abu okv ngo achialvbv mvngdwkla nam mapadubv vla rikar dunv laka.” ");
INSERT INTO tgj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nw bunua mirwkto, “Nonu ogubv ngam makar dunv? Ngo Abu gv naam lo doojinv um nonu chima dunvre?” ");
INSERT INTO tgj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Vbvritola bunu ninyigv mirwknam a chimato. ");
INSERT INTO tgj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Vkvlvgabv Jisu bunua lvkobv Najaret lo vngkur toku, hoka ho nw bunugv mvnglwkbv ritoku. Ninyigv anv ngv ninyigv vbvrinam mvnwng nga haapoklo mvnggapla vvpv toku. ");
INSERT INTO tgj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisu adwn amarbv okv chinvpanv rungbv, Pwknvyarnv gvlola nyi vdwgvlo lvkobv ayummiyum kunam gubv singchato. ");
INSERT INTO tgj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Dvbvyachoknv Tiberias gv nyingring gola nyingu bv rigvla ririlo; Pontius Pilot nw Judia gv gobunor bv rito, Herod Galili gv regvnvbv, okv ninyigv boru Pilip Ituria okv Trakonitis mooku lo regvnvbv; Laisanias Abilene lo regvnvbv, ");
INSERT INTO tgj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","okv Annas okv Kaipas bunyi Butvyachok nvbv. Ho gv dw lo Pwknvyarnv gv gaam v chukrimooku lo Jakaria gv Kuunyilo Jon gvlo aato. ");
INSERT INTO tgj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Vkvlvgabv Jon Jordan svko gv mooku mvnwnglo vnggoto japjito, “Rimur lokv mvngdin tokuka okv baptisma naatokuka, okv Pwknvyarnv nonugv rimur a mvngnga jireku.” ");
INSERT INTO tgj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","So si nyijwk Aijaya gv kitaplo lvkpvnam aingbv: “Chukrimooku arwng v nyi ako gokdu: ‘Atu gv lvgabv lamtv nga mvpv jitoka; Nw gv vngkubv lamtv nga dinda dubv mvtoka! ");
INSERT INTO tgj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Haakap mvnwng a bagring laka, Moodw diching ditv nga mvring laka. Lamtv pakungpala nvnga dinda dubv mvrung laka, okv lamtv alvmanv nga alvdubv mvrung laka. ");
INSERT INTO tgj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nyi opi dvdv ngv Pwknvyarnv gv ringlinbaalin a kaapa reku!’” ");
INSERT INTO tgj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nyitwng mvnwngngv Jon gvlo Baptisma jikudubv aato. “Tabw nonu!” nw bunua minto. “Yvvla nonua Pwknvyarnv gv mvritririt jilwk tvkulo nonu aapa mare vla minv? ");
INSERT INTO tgj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Vkvnv rinamgo no ritoka noogv rimur lokv lirung duku vla kaabwk dubv. Okv nonu atuv Abraham nonugv abuapa ngv vla nonu vdwloka minrap mabvka. Ngo nonua minpadu Pwknvyarnv so vlwng sum naala okv Abraham gv haalungbv mvlare! ");
INSERT INTO tgj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yagwng ngv singnv vdwa miami laarukbv parikla tvngtap lodobv dooyadu; singnv asi alvnv svvma nvnga tvngtapla okv vmvlo orlwk dunv.” ");
INSERT INTO tgj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nyi vdwv ninyia tvvkato, “Hv bolo, Ngonu ogugo risegubvri?” ");
INSERT INTO tgj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nw mirwkto, “Yvv vji bornyi go doodunv borgonyi yvv gvpamadunv um jirung laka, okv yvv dvnam dvpayadunv dvgvrunglaka.” ");
INSERT INTO tgj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lampu naayanv mego baptisma naadubv aato, okv bunu ninyia tvvkato, “Tamsarnv, ngonu ogugo rise vdw?” ");
INSERT INTO tgj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nw bunua minto, “Naadin lokv naabo mabvka.” ");
INSERT INTO tgj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sipai mego ninyia tvvkato, “Ngonua ogubv? Ngonu ogugo rise vdw?” Nw bunua minto, “Akonvgv morko nga dvrit mabvka homajeka akonyi miyum mabvka. Noogv pwtarpaatar lo ho nyumchi laka.” ");
INSERT INTO tgj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nyi vdwgv mvngtinnv kaiya toku, okv bunu Jon vnamsi lvkunyika Kristo madw vla lamrap nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Vkvlvgabv Jon bunu mvnwngnga minto, “Ngo nonua isi lokv Baptisma jidunv, vbvritola nyi go aadungdu hv ngam achialvbv kaiyanvgo. Ngo ninyigv lvpa gv lvsup ngaka tasok dubv riyin yama. Nw nonua Darwknv Dow okv vmv gv lvkobv baptisma jireku. ");
INSERT INTO tgj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kapkak nvnv upu hv ninyigvlo doodu, amya kaplin reku okv aam akarnvnga naakum lakula ninyigv nesunglo gwlwk reku; vbvritola nw amya nga vdwa ngemanv vmvlo ramyok reku.” ");
INSERT INTO tgj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon akuaku sunv lamtv lokv Gamlv nga nyi vdwgvlo japji toku okv bunua rimur lamtv lokv linto kukv vla mintvmiru toku. ");
INSERT INTO tgj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Vbvritola Jon gobunor bv rinv Herodnyi yamto, ogulvgavbolo nw ninyigv boru gv nywng Herodiasnyi nywng mvto, okv alvmanv ngaka awjego ritoku. ");
INSERT INTO tgj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Vbvrikunamv Herod Jonnyi patwk lwktokula abuyayabv alvmanv nga rimin toku. ");
INSERT INTO tgj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nyi mvnwngnga Baptisma jirokoching bv, Jisu nyika Baptisma jitoku. Vdwlo nw kumto kudw, nyidomooku v kokdariaka toku, ");
INSERT INTO tgj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","okv Darwknv Dow v ninyigv aolo taakw jvbv ritola holwkto. Okv gamgo nyidomooku tolokv ito, “No ngoogv pakyachoknam Kuunyilo ngv. Ngo nam lvkobv mvngpu dunv.” ");
INSERT INTO tgj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Vdwlo Jisu ninyigv kudungkua nga rirap tokudw, nw kaila anying chaam toku. Nyi vdwv mvngto nw Josep gv kuunyilo ngv, Josep Heli gv kuunyilo ngv, Heli ");
INSERT INTO tgj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matthat gv kuunyilo, Matthat Lebi gv kuunyilo, Lebi Melki gv kuunyilo, Melki Jannai gv kuunyilo, Jannai Josep gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep Mattathias gv kuunyilo, Mattathias Amos gv kuunyilo, Amos Nahum gv kuunyilo, Nahum Esli gv kuunyilo, Esli Naggai gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai Maath gv kuunyilo, Maath Mattathias gv kuunyilo, Mattathias Semein gv kuunyilo, Semein Josek gv kuunyilo, Josek Joda gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda Joanan gv kuunyilo, Joanan Rihesa gv kuunyilo, Rihesa Jerubbabel gv kuunyilo, Jerubbabel Shealteil gv kuunyilo, Shealteil Neri gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melki gv kuunyilo, Melki Addi gv kuunyilo, Addi kosam gv kuunyilo, kosam Elmadam gv kuunyilo, Elmadam Er gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josua gv kuunyilo, Josua Eliejer gv kuunyilo, Eliejer Jorim gv kuunyilo, Jorim Matthat gv kuunyilo, Matthat Lebi gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi Simeon gv kuunyilo, Simeon Juda gv kuunyilo, Juda Josep gv kuunyilo, Josep Jonam gv kuunyilo, Jonam Eliakim gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim Melea gv kuunyilo, Melea Menna gv kuunyilo, Menna Mattatha gv kuunyilo, Mattatha Nataan gv kuunyilo, Nataan Dabid gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dabid Jesse gv kuunyilo, Jesse Obed gv kuunyilo, Obed Boaj gv kuunyilo, Boaj Salmon gv kuunyilo, Salmon Nashon gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon Amminadab gv kuunyilo, Amminadab Admin gv kuunyilo, Admin Arni gv kuunyilo, Arni Hejron gv kuunyilo, Hejron Perej gv kuunyilo, Perej Juda gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda Jakob gv kuunyilo, Jakob Isaak gv kuunyilo, Isaak Abraham gv kuunyilo, Abraham Terah gv kuunyilo, Terah Nahor gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor Serug gv kuunyilo, Serug Reu gv kuunyilo, Reu Peleg gv kuunyilo, Peleg Eber gv kuunyilo, Eber Shelaa gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selaa Kainan gv kuunyilo, Kainan Arphajad gv kuunyilo, Arphajad Sem gv kuunyilo, Sem Noah gv kuunyilo, Noah Lamek gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek Methuselah gv kuunyilo, Methuselah Enouk gv kuunyilo, Enouk Jared gv kuunyilo, Jared Mahalaleel gv kuunyilo, Mahalaleel Kenan gv kuunyilo, ");
INSERT INTO tgj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enosh gv kuunyilo, Enosh Seth gv kuunyilo, Seth Adam gv kuunyilo, Adam Pwknvyarnv gv kuunyilo. ");
INSERT INTO tgj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisu Dorwknv Dow ngv akomaring tokula Jordan lokv linkur toku okv Dow v ninyia chukrimooku lo vnggvtoku, ");
INSERT INTO tgj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hoka alu champigo dookunamv Uyudvbv v ninyia pokayarkato. Ho dw mvnwnglo nw ogu goka dvkwmato, vdwlo hum doonya kunamv, nw kano toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Uyudvbv ngv ninyia minto, “No Pwknvyarnv gv Kuunyilo ngvbolo, vlwng sum mingvrila vtwng gobv rimutvka.” ");
INSERT INTO tgj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Vbvritola Jisu mirwkto, “Darwknv Kitaplo mindu, ‘Nyi si vtwng lokv mwng turla madunv.’” ");
INSERT INTO tgj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Vbvrikunamv Uyudvbv ngv ninyia putung gulo chaagv toku okv nyiktap gulo nyiamooku gv karv mvnwngnga kaatam toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Ngo nam so yikungyira mvnwngnga okv jwkrw a jire,” Uyudvbv ngv ninyia minpa toku. “So mvnwngsum ngam jipvkunv ngo atubogv mvngnambv ngo yvvnyika jilare. ");
INSERT INTO tgj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Vbvrinamv, no ngam kumbojobo lo, so mvnwng si no gvbv rire.” ");
INSERT INTO tgj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisu mirwksito, “Darwknv Kitaplo mindo, ‘Pwknvyarnvnyi kumlajolaka okv nw lvgabv rimwng laka!’” ");
INSERT INTO tgj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Vbvrinamv Uyudvbv ninyia Jerusalem bv vnggvto okv ninyia Pwknvyarnvnaam gv namwng mwnglo-aolo dakmuto, okv ninyia minto, “No Pwknvyarnv gv Kuunyilo gurung bolo, sokv no atu v poklu kaato. ");
INSERT INTO tgj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Darwknv kitaplo mindu, ‘Pwknvyarnv ninyigv nyidogindung nga ortojire ho bunu alvrungbv nam kaayare,’ ");
INSERT INTO tgj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Si mindvdu, ‘Bunu nam bunugv laak aolo dvbwngre ogulvgavbolo noogv lvpa nga vlwnglo tupmu madubv.’” ");
INSERT INTO tgj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Vbvritola Jisu mirwkto, “Darwknv Kitaplo mindu, ‘Ahtunyi noogv Pwknvyarnvnyi vdwloka rikaripakla rikw mabvka.’” ");
INSERT INTO tgj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Vdwlo Uyudvbv Jisunyi nvgwngbv pokayarka svnga rinya tukudw, nw achukgo ayungjvma gv lvgabv ninyia vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Vbvrikunamv Jisu Galili lo aakur toku, okv Darwknv Dow gv gilwk v ninyi lvkobv dooto. Ninyigv lvga yunying ngv ho mooku mvnwnglo dupwng toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nw Jius vdwgv kumkunaamlo tamsar toku okv nyichar mvnwng gv hartv kunam gubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Vbvrikunamv Jisu Najaret lo vngtoku, ogolo ninyia soochapvdw, okv Jius doonualu golo ninyigv vngchingbv Jius kumkunaamlo vngtoku. Nw Darwknv Kitap a puri rilindubv dakrapto ");
INSERT INTO tgj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","okv ninyia nyijwk Aijaya gv kitap a laklwk toku. Nw tibungnam kitap a tikokla okv ogolo svbv lvkpv nama kaapa toku, ");
INSERT INTO tgj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ahtu gv Dow v ngoogvlo doolwkdu, ogulvgavbolo nw ngam gaktoku heemanv vdwa Gamlv bvngji dubv. Nw ngam vngmu toku leela vnam vdwa topunam gv gaam a japgo jidubv okv kaapa manv vdwa kaapa modukubv, okv chaatinnam vdwa anyubv tulin dukubv. ");
INSERT INTO tgj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Okv ho gokpa jidukubv dw v aapvku vla vdwlo Ahtu ninyigv nyi vdwa ringrekudw.” ");
INSERT INTO tgj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisu tibungnam kitap a taatum toku, okv kaaria riria nvnga jikur toku, okv dootung toku. Jius kumkunaam arwng gv nyi mvnwngngv bunugv nyikkv ninyia kaagap nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nw bunua svbv minto, “Soogv lvknam abor si silu jvjvbv rilin pvku, nonu tvvgvnyibv um rilin nama.” ");
INSERT INTO tgj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bunu mvnwngngv lvkobv ninyia achialvbv mvngto okv ninyigv jwknam kioknambv gaam minama lamdok panambv tvvnyato. Bunu minto, “Nw Josep gv kuunyilo mangvri?” ");
INSERT INTO tgj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nw bunuam minto, “Ngo jvjvbv mindunv nonu so nyetin sam ngam mintaknvre, ‘Daktor, no atubongv mvpu silak.’ Nonu ngam mindvre ngoogv banggu naam so ridubv, Kaparnaum lo nonugv tvvnam um ripia aingbv. ");
INSERT INTO tgj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngo nonua sum mintam jidunv,” Jisu mindvto, “Nyijwk ka ninyigv banggu naam lo vdwloka alvbv naarwk suma. ");
INSERT INTO tgj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Ngam tvvriato: So si jvjv ngvrung Israel lo vmiv achialvto Elija gv rerilo, vdwlo nyingngom gola patung go nyido hooku manammv okv mooku mvnwnglo achialvbv dvmayarwng ripwng toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Rigvrila Israel lo Elijanyi yvv goloka vngmumato, vbvritola Sidon mookugv Jarepat lo hvngmi ako doodungnv angv lomwng. ");
INSERT INTO tgj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Okv Israel mookulo nyijwk Elisha gv doorilo; nyi mvnwngngv achialvbv apin yala silvmabv rinyato rigvrila yvvka poyamato, vbvritola Sairian gv Naaman mvnchik poyatoku.” ");
INSERT INTO tgj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jius kumkunaam gv nyi mvnwngngv vdwlo um tvvtokudw, bunu lvkobv sakcha nyato. ");
INSERT INTO tgj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bunu dokrapla, Jisunyi Banggu agumlo tunglin nyato, okv bunugv Banggu a mvlwk koku moodw putunglo ninyia aagv nyatoku. Bunugv vbvrinamv ninyia tarak rakla bv tunglu dubv vla, ");
INSERT INTO tgj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","vbvritola nw nyitwng gv pingkolo vngpikla okv ninyigv lamtvbv vngsu tuku. ");
INSERT INTO tgj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Vbvrikunamv Jisu Galili gv banggu, Kaparnaum lo vngtoku, hoka nw nyi vdwa tamsartoku Jius Doonualulo. ");
INSERT INTO tgj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ninyigv tamsarku lokv bunu mvnwngngv lamrwpanya toku, ogulvgavbolo nw tujupkunam gobv japto. ");
INSERT INTO tgj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jius kumkunaam arwnglo alvmanv uyuvram dow doonv nyi ako dooto; nw gamtv rungbv svgok goklinto, ");
INSERT INTO tgj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aa! Najaret lokv Jisu, no ngonua ogugo mvngpv? No so ngonua mvyakmvchak dubvre? No yvvdw ngo chindu: no Pwknvyarnv gv darwknv gindungpingko ngv!” ");
INSERT INTO tgj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisu dow a orto jitoku, “Choibv okv nyi gvlokv agum linroto!” uyuvram v nyi hum bunugv kaakulo orpvpila okv ninyia achijeyo madubv mvpila vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nyi mvnwngngv kaangak nyatoku okv ajin anying nga mimisito, “Si ogunv gamchar vkudw? Tujupkunam okv jwkrw a lvkobv si nyi si alvmanv dow a charnam v okv bunu agum linro duku!” ");
INSERT INTO tgj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Okv Jisu gv lvkwnglo so yunying ngv ho mooku mvnwnglo dupwng toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisu Jius kumkunaam a vngyu pila okv Saimon gv naam lo vngtoku. Saimon gv ayuv achialvbv tamiram karla dooto, okv bunu ninyigv lvga nga Jisunyi minjitoku. ");
INSERT INTO tgj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nw ho ninyigv dookulo aala daktoku okv tamiram a ninyigv lokv vngroto vla yamto. Tamiram v ninyigv lokv vngro toku, okv nw vjakgobv gudung toku okv bunua dvnamtvngnam jirap toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Doonyi poggaro kochingbv nyi mvnwngngv yvv bunu ajin doopv kudw yvv bunu nvgwngnv lvvmabv ridukudw bunua Jisu gvlo aagv jitoku; Nw mvnwngnga akinakinbv ninyigv laak hv lakpv jitoku okv mvnwngnga mvpu toku. ");
INSERT INTO tgj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Uyuvram vdwv segokto “No Pwknvyarnv gv Kuunyilo ngvmabv!” vbvmiying dula nyi megonvgv lokv kelin toku. Jisu uyuvram vdwa yamto okv bunua milin momato, ogulvgavbolo bunu ninyia Kristo rung vla chintoku. ");
INSERT INTO tgj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Alu v loolin tokudw Jisu banggu a vngyu toku okv jemataiku mooku lo vngtoku. Nyi vdwv ninyia kaakar nyatoku, okv vdwlo bunu ninyia kaapa tokudw, bunu ninyia vngyu momare vla rikw nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Vbvritola nw bunua minto, “Ngo Pwknvyarnv gv Karv lvgagv Gamlv nga kvvbi banggu loka japji rungdubv ripv, vkvlvgalo Pwknvyarnv ngam rimudubv vla vngmu pvnv.” ");
INSERT INTO tgj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Vkvlvgabv nw ho mooku mvnwng gv Jius kumkunaam vdwlo japgo jitoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Alu golo Jisu Gennesaret svparsvlv adarlo dakto ho nyi vdwv Pwknvyarnv gv gaam tvvdubv vla ninyigv kiambv chapcha nyato. ");
INSERT INTO tgj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nw svparsvlv adarlo svpw anyigo pucha dubv kaapato; ngui naanv vdwv ho kayupila okv vsap a kakdungto. ");
INSERT INTO tgj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisu svpw akonvlo aatoku—hv Saimon gvbv rito—okv ninyia minto achukgo adar lokv nvnglwk tvkv vla. Jisu svpw lo doopv tvla okv nyitwng nga tamsarto. ");
INSERT INTO tgj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Vdwlo nw raanam a raanya tvkudw, nw Saimonnyi minto, “Svpw a adu dubv isi arayabv tunglwkto, okv no la noogv ajin vdwv ngui naanam lvgabv vsap a orlwkto.” ");
INSERT INTO tgj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Tamsarnv,” Saimon minto, “Ngonu siyu harkwng pvnv vbvrijvka oguguka naapama. Vbvritola no vbv mindu nvbolo, ngo vsap vdwa orlwkre.” ");
INSERT INTO tgj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bunu vsap vdwa orlwkto okv vsap vdwa bokpwk tvdukubv achialv kaibv ngui vkv naatoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Vkvlvgabv bunu bunugv ajin vdwa pudumsedum labvkv vla goklwkto. Bunu aato okv svpw anyilo ngui v aku dubv naaku namv svpw vdwv isi bv hoolwk tvvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ogugo ripvkudw um Saimon Pitar kaagv rikula, nw ninyigv lvpa lvkwnglo Jisu gv habolo gipv tvkula okv minto, “Ahtu! ngoogv lokv vngroto, ngo rimurnv nyi vla!” ");
INSERT INTO tgj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nw okv ninyia lvkobv rinv kvvbi mvnwngngv bunugv achialvbv ngui naakunama kaangak nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon gv ribam ajin Jibedi gv kuunyilo Jems okv Jon bunyi ka kaangak toku. Jisu Saimonnyi minto, “Busu mabvka; vjak lokv no nyi naakar reku.” ");
INSERT INTO tgj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bunu svpw vdwa segumlo pucha toku, ogu mvnwngnga kayupila Jisunyi vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisu lvkogulo Banggu akolo dooto ho hoka nyi ako apin hv yala arwnam lvvma nvgo dooto. Vdwlo nw Jisunyi kaapa tokudw, nw atubongv gipv gvrila okv Jisunyi kodwkkrwkla kooto, “Tamsarnv, no mvngduboloka, no ngam darwk dubv mvlare!” ");
INSERT INTO tgj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisu ninyigv laakkv idaira linla okv ninyia mvsit toku. “Ngo vbv mvngrung dunv,” nw mirwkto. “Darwk tokukv!” Vjakgobv lvvma ngv nyi hum kayupila vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisu nyi hum minggapto “Yvvnyika minpa mabvka, vbvritola nyibu gvlo vngdavngra nyika okv ninyia jwngkadaka motoka; vbvrigvrila nyi mvnwngnga chimpakaapa molaka no poorung pvku vla, erin nvsenga jilaka Moses gv minkubv.” ");
INSERT INTO tgj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Vbvritola Jisu gv lvkwnglo kaiyayabv dupwng toku, nyi nyitwng ngv aala ninyigvlo tvvto okv bunugv lvvma vdwlokv pooya dukubv aato. ");
INSERT INTO tgj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Vbvritola nw jematai kolo vngla, hoka nw kumtoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Alu golo vdwlo Jisu tamsar rilo, Parisis okv Pvbv tamsarnv nyi mego hoka dooto hoka doonv kvgonv Galili banggu mvnwng lokv okv Judia lokv okv Jerusalem lokv aanvgo. Ahtu gv jwkrw v Jisu gvlo doolwkto lvvma nvnga mvpu dubv. ");
INSERT INTO tgj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nyi mego digwngnv nyi go gadw aolo doodubv joolaila aato, okv bunu naam arwng joolwk dubv rikwngto okv ninyia Jisu gv kaagialo joopv jidubv vla. ");
INSERT INTO tgj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nyitwng ngv achialv twngtv kunam lvgalo, bunu ninyia ogoloka arwnglo joolwk jiku mapa matoku. Vkvlvgabv bunu ninyia namwng aolo joocha toku, namwng nga mvkoto, okv ninyia gadw aolo doomu tvla soolu jitoku nyitwng gv pingkolo Jisu gv kaagialo. ");
INSERT INTO tgj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Vdwlo Jisu bunugv vkvnvgo achialvbv mvngjwng kunama kaapa tokudw, nw nyi hum minto, “Ngoogv ajin a, noogv rimur vdwa mvngnga jipv kunv.” ");
INSERT INTO tgj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pvbv tamsarnv vdwv okv Parisis vdwv bunu atu v minrap nyato, “Yvvla so nyi si svkvnvgo nyarjitari dunv! Pwknvyarnv mvngchik rimur vdwa mvngnga mvngdunv!” ");
INSERT INTO tgj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisu bunugv mvngnam a chintoku, okv bunua minto, “Ogubv nonu svkvnvgo mvngdunv? ");
INSERT INTO tgj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","So si minpubv minse gure, ‘Noogv rimur vdwa mvngnga ropvku,’ vmalo miya svgure ‘Gudung gvrila okv vnglakuka’? ");
INSERT INTO tgj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Vbvrinam v, ngo nonua himpa more, Nyia Kuunyilo ngv siching gwngda so jwkrw doodunv rimura mvngnga dubv.” Vkvlvgabv nw digwngnv nyi um minto, “Ngo nam mindunv, gudungto, noogv kartaknvnv nga naarapto, okv naam bv vngnyiku!” ");
INSERT INTO tgj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vjakgobv nyi mvnwnggv kaagialo nyi angv gudung toku, ninyigv dootak kartaknvnv nga naatoku, okv Pwknvyarnvnyi hartvla, naam bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bunu mvnwng ngv achialvbv kaangak tangak nyatoku! achialvbv busu datoku, bunu Pwknvyarnvnyi hartv yingla minto “Ngonu silu kaasartabo rungnvgo kaatokubv!” ");
INSERT INTO tgj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","So kochingbv, Jisu agumlo vnglinto, okv lampu nakumyanv nyigo kaapato aminv Lebi, ninyigv opislo dooto. Jisu ninyia minto, “Nga vngming gvlaak,” ");
INSERT INTO tgj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lebi gudung datoku, ogumvnwngnga kayu toku, okv Jisunyi vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Vbvrikunamv Jisu gv lvgabv Lebi ninyigv naamlo kainv dvmam go mvpvtoku, okv goklwknam nyen lokv lampu naakumyanv nyi ngv twngtv yato okv kvvbi nyi hvkv ta. ");
INSERT INTO tgj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisis nyi megola okv Pvbv tamsarnv nyi mego bunugv apumlo rinvgo bunu Jisu gv lvbwlaksu vdwa miakaayala minto, “Nonu ogubv lampu naayanv vdwa okv toa kunam nyi vdwa dvbam tvngbam dunv?” vla bunu tvuto. ");
INSERT INTO tgj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisu bunua mirwkto, “Yvvnyi hv chvrv nvngv daktor lodanv mvngma dvnv, vbvritola v bunu mwng yvvbunudw lvvma dunv. ");
INSERT INTO tgj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mvngdwnv nyi vdwa mvngdin modubv ngo aama, vbvritola toa kunam vdwgvbv.” ");
INSERT INTO tgj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nyi mego Jisunyi minto, “Jon gv lvbwlaksu vdwv yikla dookidu okv kumdakumra dvkv, okv Parisis vdwgv lvbwlaksu vdwvkam vbvridu; vbvritola noogv lvbwlaksu vdwv dvki okv twngki nyadu.” ");
INSERT INTO tgj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisu mirwkto, “No vbv dvminchok dunvri nyidalo makburiji bongngv najibongv okv ninyigv ajin vdwa doodv mogvrila nyen vdwa ogu dvmatvngma bv vngmu dubvi? Vdwloka vbvrirung mare! ");
INSERT INTO tgj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","vbvritola vkvnv alu hv aare vdwlo makburiji bongngv bunugv lokv naarorikudw vbvrikubolo ho bunu yikrap reku.” ");
INSERT INTO tgj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisu mindvjito bunua so minchisinam sam: “Yvvka vji jenw nga ariap go pulinla jekulo hamtak lwknv kaama. Nw vbvrikubolo vji jinw nga takmure, okv ho jinw ariap v jekulo ape simare. ");
INSERT INTO tgj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yvvka anggor ala anw nga anggor ala aku pumchup lo pwtamlwknv kaama, ogulvgavbolo vbvribolo pumchup hv takla anggor ala ngv yarpok linla pumchup hv alv kumare. ");
INSERT INTO tgj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ho mabvya anggor ala anw nga pumchup anw lo pwlwk rungsego! ");
INSERT INTO tgj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Okv yvvka anggor ala aku tvnggvrila anw lodanv vla mvngmadvnv. Nw mindu, ‘anggor ala aku v alvyadu.’” ");
INSERT INTO tgj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jius Doonu alu golo Jisu ampu rongolo vngkarto. Ninyigv lvbwlaksu vdwv aam amring nga puik gvrila, lakchulo nepung gvrila achar ha dvto. ");
INSERT INTO tgj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisis nyi mego tvvkato, “Nonu ngonugv Pvbv lo no Jius Doonualu lo riyoka vnam ham ogubv ridunv?” ");
INSERT INTO tgj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisu bunua mirwkto, “Nonu puri rika malare Dabid ogugo ripvdw vdwlo nw la okv ninyigv nyi vdwv kano tukudw? ");
INSERT INTO tgj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nw Pwknvyarnv gv naam arwnglo aatoku, Pwknvyarnv gvlo tolwk jinam dvnam ham naatoku, hum dvto okv hum ninyigv nyi vdwaka jitato. Kvvbi nyi gv lvgabv hv ngonugv Pvbv nga rinying kunamv nyibu mvngchik um dvnam um dvmwng dunv.” ");
INSERT INTO tgj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Okv Jisu minyala minto, “Nyia Kuunyilo ngv Jius Doonu alu gv Ahtu hv.” ");
INSERT INTO tgj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jius Doonualu gonvnga Jisu Jius kumkunaam lo vngtoku okv tamsarto. Ho nyi ako dooto ninyigv lakbik laak angv digwng nvgo. ");
INSERT INTO tgj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pvbv tamsarnv nyi megonv okv Parisis nyi megonv Jisunyi gungnying lwkdubv rimur lodanv mvngto, vkvlvgabv bunu ninyia Jius Doonualulo mvpu gvi jibvre vla kaagap jinjinla kaariato. ");
INSERT INTO tgj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Vbvritola Jisu bunugv mvngnam ha chinto okv nyi anga minto, “Dakrap tvka okv kaagia so aato.” Nyi angv gudungto okv hoka daktoku. ");
INSERT INTO tgj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Vbvrikunamv Jisu bunua minto, “Ngo nonua tvvka dunv: Ngonugv Pvbv ngv ngonua Jius Doonualu lo ogu rila dubv minpv? Ridur dubvre ma mvki dubvre? Nyi gv singse nga ringya dubvre vmalo um ngoomu dubvre?” ");
INSERT INTO tgj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nw bunu mvnwngnga kaagapla kaagoto; vbvrikunamv nw nyi anga minto, “Noogv laakkv laklinla lakrapto.” Nw vbv rijito okv ninyigv laakkv lvkodv alv tuku. ");
INSERT INTO tgj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bunu achialvbv sakcha toku okv Jisunyi bunu ogugo rila rikunvdw vla bunugv apumlo tvukapak minsi raptoku. ");
INSERT INTO tgj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ho dw lo Jisu kumdubv vla moodw golo chaatoku okv ayu hoka Pwknvyarnvnyi kumyingla dooto. ");
INSERT INTO tgj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Vdwlo alu hv loolin tokudw, nw ninyigv lvbwlaksu vdwa nw gvlo goklwk toku okv bunu vring gola anyia dartoku, bunua Apostol vla amin mintoku: ");
INSERT INTO tgj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon (Yvvnyi Pitar vla nw amin minpvkudw) okv ninyigv boru Andriu; Jems okv Jon, Pilip okv Bartolomiu, ");
INSERT INTO tgj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metiu okv Tomas, Jems Alpius gv kuunyilo okv Saimon (Yvvnyi Toryagayanv vla minpvkudw), ");
INSERT INTO tgj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jems gv kuunyilo, okv Judas Iskeriot, yvvdw kupnv gobv rikunv. ");
INSERT INTO tgj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Vdwlo Jisu moodw lokv ninyigv lvbwlaksu vdwa lvkobv ito kudw nw mooringku gulo dakto achialvbv ninyigv lvbwlaksu vdwa lvkobv nyi nyitwng twngtv nvgo hoka aato Judia gv mooku mvnwng lokv, okv Jerusalem lokv, okv svtvpambw adar aigv pamtv Taire okv Sidon lokv. ");
INSERT INTO tgj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bunu nw gvlo tvvdubv aato okv yvv bunua alvmanv dow vdwv mvdwkmvku pvkudw bunuka aatoku okv mvpu tuku. ");
INSERT INTO tgj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nyi mvnwng ngv ninyia mvsit dubv vla rikw nyato, ninyi gvlo jwkrw v linla okv bunu mvnwngnga mvpu toku. ");
INSERT INTO tgj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisu ninyigv lvbwlaksu vdwa kaagapto okv minto, “Heemanv vdwv nonu mvngpuv; Pwknvyarnv gv Karv ngv nonu gvngv!” ");
INSERT INTO tgj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Vjakgv kanonv vdwv nonu mvngpuv; nonua dvji more!” “Vjakgv kapdunv nonu mvngpuv; nonu nyormin reku!” ");
INSERT INTO tgj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nyia Kuunyilo gv lvgabv, nyi vdwgv kaanwng manam nonu, toa kunam nonu, mvngsa kunam nonu okv alvma vnam nonu, mvnwngngv mvngpuv! ");
INSERT INTO tgj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","mvngpu laka vdwlo hv vdwv rirekudw, himpula harkwpajok laka, ogulvgavbolo kainv yikungyira go nonugv lvgabv nyidoomooku lo vvpv jido. Bunugv abuapa vdwvka vbvdvdvbv nyijwk vdwaka rito.” ");
INSERT INTO tgj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Vbvritola vjak yvv nyitv dunv nonu vdwgo mvngdwk rekudw; nonu himpula singcho ropvku!” ");
INSERT INTO tgj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Vjakgv kitvdvlvnv nonu vdwgo mvngdwk rekunv; nonu kanola vngreku!” “Vjakgv nyorminnv vdw nonu vdwgo mvngdwk reku; nonu mvngdwk reku okv kapreku! ");
INSERT INTO tgj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Vdwlo nyi mvnwngngv nonua hartv redw mvngdwk hvla; Bunugv abuapa vdwvka vbvdvdvbv mvvnvrunv nyijwk vdwaka rito. ");
INSERT INTO tgj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Vbvritola nga tvvnv vdwa ngo nonua mindu: Nonua nyirunv vdwa pakto laka, alvnvgo riji laka yvvdw nonua kaanwng madunv, ");
INSERT INTO tgj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","nonua beenv vdwa boktalwkji yalaka, okv nonua alvmabv rinv vdwgv lvgabv kumto laka. ");
INSERT INTO tgj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ako nvgonv nam nyukmu tagonyi svbiak boloka ninyia nyukmu tagonyika svbiak modvlaka; ako nvgonv noogv jvtvlaklwk a naapv bolo, ninyia noogv lwkjar aka naamu laka. ");
INSERT INTO tgj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Jilaka mvnwngnga nonua ogugo koopvdw, okv vdwlo akonv nonugv yikungyira nga naapv bolo, um kookor kuyoka. ");
INSERT INTO tgj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kvvbi nyi gv lvgabv riji laka no bunua noogv lvgabv oguaingbv rijilabv mvngdudw. ");
INSERT INTO tgj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nonuno nonua paknvrinv nyi vdwa pakmwng bolo, nonu oguaingbv boktalwkji namgo paadubv? Rimurnv vdwvka bunua paknv nga pakrwksidu! ");
INSERT INTO tgj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Okv nonuno nonua alvbv rinv vdwa alvbv rimwng dubolo, nonu oguaingbv boktalwkji namgo paadubv? Rimurnv vdwvka um risugvrila! ");
INSERT INTO tgj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Okv nonuno yvv gvlo paakor reku mvngnam ma naarrwk nyumbolo, nonuno oguaingbv boktalwkji namgo paadubv? Rimurnv vdwvka rimurnv vdwlo jinama paakor rungreku mvngla narrwk dunv! ");
INSERT INTO tgj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma! nonua nyirunv vdwa pakto laka okv alv nvgo bunua riji laka okv paakor reku mvngma bvka. Vbvribolo nonu kairungnv amin go paare, okv nonuno kaiyachoknv Pwknvyarnv gv kuu bv rire. Nw kaalwkmabv rinv haka okv alvmanv haka ayadu. ");
INSERT INTO tgj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Noogv Abu oguaingbv aya dudw vbv no ayanvbv rilaka. ");
INSERT INTO tgj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kvvbia jwngkadaka mabvka, okv Pwknvyarnv nam jwngkadaka mare; kvvbia miakaya mabv, okv Pwknvyarnv nam miakaya mare; kvvbia mvngnga laka, okv Pwknvyarnv nam mvngnga re. ");
INSERT INTO tgj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kvvbia jilaka, okv Pwknvyarnv nam jire. Jvjvrungbv, no lvvpok dubv paarungre, ayabv ridur nama, noogv laaklo joolwk jire—no vdwgo bvngla dvdw. Noogv kvvbia kiinv nvnga hum Pwknvyarnv nam kiinv nvre.” ");
INSERT INTO tgj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Okv Jisu so minchisinam sam bunua minjito: “Nyikchingnv akonv vdwloka akonyi vnggv nyulamare; nw vnggvbolo, anyiv ungrung golo hoolwkre. ");
INSERT INTO tgj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tamsarnam vmiv tamsar sarnv nga kaiyama doonv; vbvritola tamsarnam vmiv, vdwlo nw risar minsar nama rinya rikudw ninyia tamsarnv aingbv ridukunv. ");
INSERT INTO tgj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“No atubogv nyikgv nyikrw nga mvngmabv, ogubv no noogv achiboru gv nyikgv nyikrw nga kaadunv? ");
INSERT INTO tgj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","No oguaingbv noogv achiborunyi minladubv, achiboru, klvi, noogv nyikgv nyikrw nga ngam naalin molabv, vjakgobv no atubogv nyikgv nyikrw nga kaapa magvrila? Kaakudubvrinv no! no atukchochukbv no atubogv nyikgv nyikrw nga naapak chotoka, okv vbvrikubolo no noogv achiboru gv nyikgv nyikrw nga kaabwk riku okv hum naapak nyureku. ");
INSERT INTO tgj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Baboknv singnv ngv alvmanv asi svvma dunv, yaagampolonv singnv ngv vdwloka alvnv asi svvma dunv. ");
INSERT INTO tgj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Asi svvlinnam lokv singnv mvnwngnga chindunv; No tanyum nyumki singnv lokv koksitkokrik pulama vbvmalachin hakar lokv anggor gvma dunv. ");
INSERT INTO tgj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Alvnv nyihv haapok lokv alv nvnga mvnglin rilindo, alvmanv nyi ngv arwnglo alvmabv mvngkum nama mvnglin rilindo. Haapok lo ogugo mvngkum pvdw vbv gaam lo milindo. ");
INSERT INTO tgj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Okv ngoogv minam a rima gvrila, nonu nga ogubv ‘Ahtu, Ahtu,’ vla gokdunv? ");
INSERT INTO tgj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yvv akonv ngoogvlo aala ngoogv gaam a tvvdunv okv um ridunv ngo nonua kaatamre hv yvv aingbv ridunv. ");
INSERT INTO tgj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hv nyi ako ninyigv, naam ha, vlwng aolo achialvbv ungrung runglwkla okv mvnv aingdo. Isi hv achialvbv tvvlula okv naam ha tvvgingto vbvrijvka bidubv mvnyu mato, ogulvgavbolo hv alvrungbv mvnam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Vbvritola yvv akonv ngoogv gaam ha tvvgvrila okv hum rimanv hv vkv aingbv rido, nyi ako ninyigv naam ha alvrungbv mvmabv; vdwlo isi hv tvvlu tvkudw ho naam ha tvvgingto hv vjakgobv taba tuku—okv hv achialvbv alvmabv yaknamgobv ritoku!” ");
INSERT INTO tgj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Vdwlo Jisu so gv minse mvnwngnga nyi vdwa minya jito kudw, nw Kaparnaum bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roman nyigam ako hoka pakbu go dooto hv ninyia achialvbv mongrumara lo aanvgo; hv nyi angv lvvmato okv sida svngvbv ritoku. ");
INSERT INTO tgj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nyigam angv vdwlo Jisu gv lvkwng nga tvvpa tokudw, nw Jius nyiga vkv vngmuto Jisunyi tvula naam aala okv ninyigv pakbua mvpu modubv vla. ");
INSERT INTO tgj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bunu Jisu gvlo aatoku okv ninyia dinchialvbv minto, “So nyi si jvjvrungbv noogv ridur ha dinchi rungdu. ");
INSERT INTO tgj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nw ngonugv nyi ha ayado okv nw atubongv ngonugv lvgabv jius kumkunaam go mvjito.” ");
INSERT INTO tgj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Vkvlvgabv Jisu bunua lvkobv vngming gvto. Nw naam lokv adu kuma toku, vdwlo nyigam angv ajin vkv vngmuto ninyia minpa modubv, “Tamsarnv, atubongv agarapi bv mvsuyoka. Nam ngoogv naamlo aamu dubv ngo alvka yama, ");
INSERT INTO tgj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","vbvmaka ngooka noogv dookulo nyidum gubvrila aadu bv alvnv nyi bvka riyama. Gaam bv milin jimwng boloka okv ngoogv pakbu hv pooya reku. ");
INSERT INTO tgj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngooka ngam kaiyanv nyigam vdwgv arwnglo doonv nyi go, okv ngoogv arwnglo ngoogv sipai vdwv doodu. Ngo so anga, ‘Vngto’ vla orto jibolo okv nw vngdu; ngo olo doonv anga ‘So aato’ vla orto jibolo hv aadu; okv ngo ngoogv nyira nga ‘Sum rito’ vla orto jibolo hv um ridu.” ");
INSERT INTO tgj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisu hum tvvgvrila lamtoku; nw dakkur dakrwk dvla ninyia vngming gvnv nyitwng nga minto, “Ngo nonua mindunv, ngo vdwloka svkvnv mvngjwng go himpa tvvma, Israel arwng so lvrika kaama!” ");
INSERT INTO tgj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jokjiyanv vdwv nyigam gv naam lo vngkur toku okv ninyigv pakbuv chvrv dukubv kaatoku. ");
INSERT INTO tgj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ayung madwbv Jisu Nain vnam banggu lo vngtoku, ninyigv lvbwlaksu vdwv la okv nyitwng go vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nw banggu gv agi lo aachinam gula, svma bvngla vnglinnv vdwa kaapato. Sinv nyi angv hvngmi gv tumpu hotum gubv rito, okv banggu gv nyitwng twngtv nvgo ninyia lvkobv reming gvto. ");
INSERT INTO tgj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Vdwlo Jisu hvngmi a kaapa tokudw ninyigv haapok kv achialvbv ninyia aya kaapa toku, okv hvngmi ha minto “Kapma bvka.” ");
INSERT INTO tgj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Vbvrikunamv nw vngsito okv maari ha mvsitto, bvngnv nyi vdwv daktungto. Jisu minto, “Nyi yaapa bongv! gudungto, Ngo nam mindunv!” ");
INSERT INTO tgj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nyi sikunv gudung toku okv gaam raarap toku, okv Jisu ninyia ho anv gvlo jikur toku. ");
INSERT INTO tgj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bunu mvnwngngv busuto okv Pwknvyarnvnyi hartv nyato. “Kairungnv nyijwk go ngonu gvlo aapvku!” bunu minto “Pwknvyarnv aapvku ninyigv nyi vdwa ringdukubv!” ");
INSERT INTO tgj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisu gv lvkwngbv so yunying si jarkar toku mooku mvnwnglo okv adar aigv mooku lo. ");
INSERT INTO tgj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Vdwlo Jon gv lvbwlaksu vdwv so gv ogumvnwng nga mintam tokudw, nw bunu gvlo anyi gunyi gokto ");
INSERT INTO tgj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","okv bunyia Ahtu gvlo tvvka moodubv vla vngmuto, “No rungri Jon gv aainvkv vla minamv, vmalo ngonu aku kvvbi gunyi kaaya dubvri?” ");
INSERT INTO tgj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Vdwlo bunu Jisu gvlo aatokudw, bunu minto, “Jon ngonua nam tvvka jilabv vla vngmupvnv ninyigv aainvkv vnam hv no rungre, vmalo ngonu ako gonyi kaaya segore.” ");
INSERT INTO tgj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hoka dw hoka Jisu lvvmanv nyi mego mvpu toku, bunugv achiayakha, okv alvmanv dow vdwa okv nyikchingnv nyi mego kaapa motoku. ");
INSERT INTO tgj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nw Jon gv gindungpingko vdwa mirwkto, “Vngkur yikuka okv Jonnyi minpa teka no ogugo kaadu okv tvvdu: Nyikchingnv kaapa nyuduku, lvpiknv vngla duku, yvvbunudw apin alvmabv lvvmanv vdwa darwk mopvku, rungjinv vdwv tvvpa nyuduku, sinv vdwa turkur moduku, okv Gamlv nga heemanv vdwlo japji duku. ");
INSERT INTO tgj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Vdwgo mvngpuv yvvdw ngoogv lvkwng nga mvngngum madunv!” ");
INSERT INTO tgj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon gv gindungpingko vdwgv vngro kochingbv, Jisu nyitwng nga japji raptoku Jon gv lvkwng nga: “Vdwlo nonu Jon gvlo chukrimooku lo vnglin rikulo, nonu ogugo kaapare vla dvminpvnv? Nvmwng anw hv doorilo yapchar dubv? ");
INSERT INTO tgj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ogugo kaadubv nonuno vnglin pvnv? Nyi ako vji kaapubv gvnv gore? Vkvnv nyi vji kaapubv gvnv okv himpukain bv doonv vdwa dvbvkarv vdwlo paadunv! ");
INSERT INTO tgj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nga minpalabv, nonu ogugo kaadubv vla vnglin pvnv? Nyijwk akore? Am hv jvbo, vbvritola nyijwk ka achialvbv kaiyanv go nonuno kaato. ");
INSERT INTO tgj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon Darwknv Kitaplo minpanam akonv: ‘Pwknvyarnv minto, ngo ngoogv gindungpingko akonyi nonu gvlo vngcho more nonugv lvgabv lamtv nga mvkok modubv.’ ");
INSERT INTO tgj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngo nonua mindu,” Jisu mindvto, “Jon kaiyanv singcho dvdvnv nyi lokv. Vbvritola yvvdw Pwknvyarnv gv Karv lo miangdunv nw Jonnyi kaiyadunv.” ");
INSERT INTO tgj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nyi mvnwngngv ninyigv minam ha tvvtoku; bunu okv lampu naayanv vdwv yabv Pwknvyarnv gv jvjvklv nga mvngya kunv okv Jon gvlokv baptisma naakunv vdwv. ");
INSERT INTO tgj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Vbvritola Parisi vdwv la Pvbv tamsarnv vdwv nwbunugv lvgabv Pwknvyarnv gv mvngnamha toa tuku okv Jon gvlokv baptisma naamare vtoku. ");
INSERT INTO tgj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisu mindvto, “Vjak ngo ogugonyi mintaknvla minladubv svjak silugv nyi vdwsum? Bunu oguaingbv ripv? ");
INSERT INTO tgj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bunu piokpamdorpamlo vmi dopamnv aingbv rido. Twnggonv twnggonyi gokdu, ‘Ngonu nonugv lvgabv nyida sidupvbin dumuto, vbvritola nonuno harkw pajokma! Ngonu siinyimar mvto, vbvritola nonuno kapma!’ ");
INSERT INTO tgj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon Baptist aatoku, vbvritola nw yikto okv opo tvngmato, okv nonuno minto ‘Nw gvlo uyuvram doodu!’ vla. ");
INSERT INTO tgj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nyia Kuunyilo ngv aatoku, okv dvto okv tvngto, okv nonuno minto, ‘Kaatoka so nyi sam! Nw dvria nvgo okv tvngria nvgo, lampu naayanv vdwgv okv kvvbi nyi toakunam vdwgv ajin go!’ ");
INSERT INTO tgj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pwknvyarnv gv mvnglak kv jvjvrungbv kaatamdu, mvnwng gvlo yvvdw um mvngrwk dvdw.” ");
INSERT INTO tgj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisis akonv Jisunyi gokto ninyia lvkobv achin dvbam dubv vla, okv Jisu ninyigv naam lo aatoku okv dvdukubv dootung toku. ");
INSERT INTO tgj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ho banggu lo nyimv nvgo rimurla doonvgo dooto. Nw Jisunyi Parisis gv naam lo dvla doodukv vla tvvpato, vkvlvgabv nw pumchup golo nampunv ala vkv akomaring dubv bvnglwkto ");
INSERT INTO tgj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","okv Jisu gv lvpa koching kiambv lvpa nga ninyigv nyikla ngv sarbum dubv kapla dakto, vbvrikunamv nw ninyigv dwmw lokv Jisu gv lvpa nga tipw to, mopup to, okv nampu nvnga lvpa lo pwke toku. ");
INSERT INTO tgj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Vdwlo Parisis angv um kaato kudw nw atubongv minsuto, “So nyi si jvjvbv nyijwk guloka, ninyia gakka nvnga chindu nvpv ogu nyimv gudw; ogu rimur go rila nw svngpv nvdw!” ");
INSERT INTO tgj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisu gamtv rungbv ninyia minto, “Saimon, ngo nam mintam segu doodukv.” “Vkv, tamsarnv,” nw minto, “Nga mintam labv.” ");
INSERT INTO tgj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Ho hoka nyi anyigo dooto bunyi morko narnv gvlo morko narto,” Jisu minrap toku. “Akonv ninyigvlo ain lokdwng lwngu go narto, okv kvvbi angv chamngu go narto. ");
INSERT INTO tgj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bunyi lokv yvvka ninyia jikur nyuma toku, vkvlvgabv nw bunyi gv dvdu doonam a kayu jitoku. Vbvrikunamv, ogolo angv ninyia kaiyabv ayare?” ");
INSERT INTO tgj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Ngo mvngkanamv,” Saimon mirwkto, “Hv ho angv nvpv yvvnyi kaibv kayu jinam angv.” “No minjwk gvibv,” Jisu minto. ");
INSERT INTO tgj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Vbvrikunamv nw nyimv nvnga kaarwk toku okv Saimonnyi minto, “No so nyimv sum kaadure? Ngo noogv naam lo aato, okv no ngoogv lvpa lvgabv isi jimato, vbvritola nw ninyigv nyikla lokv ngoogv lvpa nga harkakto okv ninyigv dwmw lokv hum tipw toku. ");
INSERT INTO tgj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","No ngam naam lo alvbv aamu rilo moopup mato vbvritola nw ngoogv aaro lokv lvpa nga moopup nama topuma. ");
INSERT INTO tgj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","No ngoogv dumpo lvgabv olib tvli jimato, vbvritola nw ngoogv lvpa nga nampunv vkv harbum pvku. ");
INSERT INTO tgj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngo nonua mindunv, vbvrikunamv, nw gv kairungbv aya kaatam kunam si ninyigv achialvbv rimur vdwa mvngnga jipvku vla chimu rungduku. Vbvritola yvvnyi miang go mvngnga jipv kudw miang go aya nga kaatam mvngdo.” ");
INSERT INTO tgj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Vbvrikunamv Jisu nyimv nvnga mintoku, “Noogv rimur vdwa mvngnga jipvkunv.” ");
INSERT INTO tgj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tvbul lo doodungnv kvvbi vdwv atu hv minrap suto, “Yvvdw si, rimur haka mvngnga jikunv?” ");
INSERT INTO tgj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Vbvritola Jisu nyimv nvnga mintoku, “Noogv mvngjwng ngv nam ringsupvku; alvbv vngnyiku.” ");
INSERT INTO tgj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ayungjvma gv kochinglo Jisu banggu vdwlo okv nampum vdwlo vngkarto, Pwknvyarnv gv Karv lvgabv Gamlv nga japgo jito. Lvbwlaksu vring gola anyi vka ninyia lvkobv vngto, ");
INSERT INTO tgj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","vkv aingbv nyimv vdw—vka yvv bunua alvmanv dow okv lvvma vdwloka mvpu kunam vdwv: Meri (Yvvnyi Magdalene vla minpvdw), yvv gvlokv uyuvram kanw go charlin pvkudw; ");
INSERT INTO tgj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, Yvvgv nyilu ngv Chuja yvvdw Herod gv naamlo nyigam bv rinv; okv Susanna, okv achialv nyimv vdwvka yvv bunu atugv pwnampaanam lokv Jisunyi okv ninyigv lvbwlaksu vdwa ridur kunv. ");
INSERT INTO tgj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nyi vdwv Jisu gvlo aadung nyato banggu akonvgv kochinglo akonv; okv vdwlo kairungnv nyitwng gubv vngdum tokudw, Jisu mintoku minchisinam sum: ");
INSERT INTO tgj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Alu golo nyi ako rongolo radv chitv bv vnglinto. Ninyigv vbv rongolo amw chirilo, kvgonv lamtv korpv kolo holula hopvto, okv pvta vdwv um pala dvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mego-kvgonv lvngtak aolo hopvto, okv vdwlo amw hv boksu tokudw, bunu sintoku ogulvgavbolo kvdw v dwsidwla kaamato. ");
INSERT INTO tgj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Amw megonv yamdwng yamchum tvv pvdwng lo holwkto, hv singnv vdwa lvkobv svngto okv bunua yuptoku. ");
INSERT INTO tgj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Okv amw megonv alvnv kvdwlo holwkto; agar v svngtoku okv dabak baklin toku, akin-akinlo lwnggobv dachar charlin toku.” Okv Jisu minyabv mintoku, “Vbvrikunamv, tvvtoka nonuno nyarung gvdubolo!” ");
INSERT INTO tgj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Minchisinam si ogu v vla Jisunyi ninyigv lvbwlaksu vdwv tvvkato, ");
INSERT INTO tgj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","okv nw mirwkto, “Pwknvyarnv gv Karv gv arwng gaam vdwa nonua chimu pvkunv, vbvritola kvvbi vdwa minchisinam vdwlo aadunv, vkvlvgalo bunu kaadu vbvritola kaapama, okv tvvdu vbvritola tvvchinma. ");
INSERT INTO tgj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Si ogu hv minchisinam gv lvga ngv: Amw ali vdw hv Pwknvyarnv gv gamchar hv. ");
INSERT INTO tgj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amw lamtvlo hopvnv bunu tvvpvdw; vbvritola Uyudvbv hv aala okv doin a bunugv haapok lokv-nga naaro toku ogulvgavbolo bunua mvngjwng okv ringnam lo doomu madubv vla. ");
INSERT INTO tgj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Amw hv lvngtak aolo hopvnv yvvbunudw doin ha tvda namgola okv um mvngpula torwk sito. Vbvritola hv bunu gvlo alvbv rungrwng lo harlwk manam lvgabv; bunu miang go mvngjwng mvngto vbvritola vdwlo gwngkarika ngv aakunamv, bunu kayu toku. ");
INSERT INTO tgj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Amw hv yamdwng yamchum tvv vdwlo holwknv hum mindo yvv bunu tvvpvkudw; vbvritola nyitv nyigam okv himpukain bv mvngla mvngdwk hv dooyum laku okv bunua yuptoku, okv bunugv asi hv vdwloka ngimareku. ");
INSERT INTO tgj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amw hv alvnv kvdw lo holwknv hum mindo yvv bunu doin a tvgvrila okv um alvbv haapok lo vvpv gvrila mvnggapla rinv, okv bunu asi svvma dvdvlobv rwkrwk mvbwngto. ");
INSERT INTO tgj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Yvvka mvdurupum a runu gvrila okv bati takmamla vmalo gadw kyampwk lo vvpvnv kaama. Ho mabvdv, nw hum tunggingnvnv aolo vvpv yadunv, vkvlvgavbolo nyi vdwv bunu arwng aarilo loung nga kaapa yadubv. ");
INSERT INTO tgj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ogugo vvsila vvsum pvpvdw agumlo naakok linreku, okv ogugo takmam pvkudw kaapa reku okv lounglo naalin reku. ");
INSERT INTO tgj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Himasuto laka, vbvrinamv, nonu oguaingbv tvvdudw; ogulvgavbolo yvvdw ogugo doodudw jitam yayare, vbvritola yvvdw arochoko dunv ninyigv achukgo doonv ngaaka dvrit reku.” ");
INSERT INTO tgj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisu gv anv okv boru vdwv ninyi gvlo aato, vbvritola nyi twngtv kunam lvgabv ninyia vngming gvla nyumato. ");
INSERT INTO tgj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nyi gunv Jisunyi minto, “No gv anv okv boru vdwv agum vka dakdungdu okv nam kaanwng pvkv vla.” ");
INSERT INTO tgj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisu minto bunu mvnwngnga, “Yvvbunudw Pwknvyarnv gv gaam a tvvgap gvrila ridunv v ngoogv anv ngv okv boruv.” ");
INSERT INTO tgj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Alu logo lo Jisu svpw golo dooto ninyigv lvbwlaksu vdwa lvkobv okv bunua minto, “Klai svparsvlv takdv gonvbv vngrap laju.” Vkvlvgabv bunu vnglinla vngrap toku. ");
INSERT INTO tgj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bunu vdwv dula vngrilo Jisu yuplwk toku. Lamdadubv kairungnv dooridoogum go rilula svparsvlv nga rigingto, okv svpw lo isi hv yarlwk raptoku, vkvlvgabv bunu mvnwngngv achialvbv busu kaapala dootoku. ");
INSERT INTO tgj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lvbwlaksu vdwv Jisu gvlo vngtoku okv ninyia mvu toku, vbv miyingto, “Tamsarnv, Tamsarnv! ngonu sida jikunvkv!” Jisu gudung toku okv dooria gaamgo gamkito okv isi sekiok hwknv haka; bunu ringin toku, okv hoka kairungbv sarsopoyo toku. ");
INSERT INTO tgj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Vbvrikunamv lvbwlaksu vdwa nw mintoku, “Ogulo nonugv mvngjwng ngv?” Vbvritola bunu lamrwpato okv busuto, okv akonv ako nvnga mimisito “Yvv bvri so nyi si? Nw doori okv sekiok a gamki namv, okv bunu ninyi tvjidu!” ");
INSERT INTO tgj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jisu okv ninyigv lvbwlaksu vdwv Gerasa mooku lo dulwk toku hoka hv Galili svparsvlv takdv gonv ngv. ");
INSERT INTO tgj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisu gv isi segumlo korpv rilo, ninyi nyi ako kaarwk sito hv banggu lokv ngv okv nw gvlo uyuvram vdwv dooto. Mvngchi kuma nvgo so nyi si vji koomabv relin nvgo okv naam lo dooma nvgo, okv ninyigv singnam ha nyibung bungpam gv lvngpwk lo relwk nvgo. ");
INSERT INTO tgj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Vdwlo nw Jisunyi kaapa tokudw nw achialvbv gokla kapto, atubongv ninyigv lvpa lvkwnglo gipvto, okv segokto, “Jisu, Kaiyachoknv Pwknvyarnv gv Kuunyilo! No ngoogvlo ogugo mvngdunv? Ngo nam koodwkkrwk la koodunv nga mvrit mabvka!” ");
INSERT INTO tgj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nw vbv minto ogulvgavbolo Jisu uyuvram dow ha ninyigv lokv linro toku vla gamkinam lvgalo. Ninyia achialvgo naatung pvla vvkwto, okv ninyia tumla vka lakuka ninyigv lvpa okv laak ha rwngja lokv leela, nw rwngja nga dokpwkto okv uyuvram hv ninyi mvdok laila chukrimooku bv limuto. ");
INSERT INTO tgj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisu ninyia tvvkato, “No gv aminv ogu hv?” “Ngo gv aminv ‘Mob’” nw mirwkto ogulvgavbolo uyuvram achialvgo nw gvlo aatoku. ");
INSERT INTO tgj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Uyuvram hv Jisunyi koodwkkrwkla kooto bunua dotarkamanv ungrong bolo charlu mabvkv vla. ");
INSERT INTO tgj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ho hoka nvchilo vrik riktwng go reto, moodw lo dvkar nyala. Vkvlvgabv uyuvram vdwv Jisunyi koodwkkrwk la kooto bunua riktwng arwnglo vngmulabv vla, okv nw bunua vngmuto. ");
INSERT INTO tgj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bunu nyi golokv lintoku okv riktwnglo aatoku. Riktwng mvnwngngv chapchar minsula tarakbv riolula svparsvlv lo riolwk nyala sitoku. ");
INSERT INTO tgj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Riktwng nga kaayanv vdwv ogugo ripvdw um kaatoku, vkvlvgabv bunu joktoku okv yunying nga banggu okv rongo vdwlo dupwng motoku. ");
INSERT INTO tgj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nyi vdwv vnglintoku ogugo ripvdw um kaadubv vla, okv vdwlo bunu Jisu gvlo aatokudw bunu uyuvram linrokunam nyi anga kaapa toku Jisu gv lvpalo doodu kubv vji koto kula okv mvngnamsaknam hv alv tokula; okv bunu mvnwngngv busu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yvv bunu um kaatokudw nyi vdwa minpa toku nyi angv oguaingbv poyapvku nvdw. ");
INSERT INTO tgj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Vbvrikunamv ho mooku lokv nyi mvnwngngv Jisunyi mintoku vngro tokuka vla, ogu lvgavbolo bunu achialvbv busu nyatoku. Vkvlvgabv Jisu svpwlo dootoku okv vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Uyuvram linrokunam nyi angv Jisunyi kodwkkrwkla kooto, “Ngam noogv vngkulo lvkobv vngmulabv.” Vbvritola Jisu ninyia vbv mintola vngmuyato, ");
INSERT INTO tgj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Naam bv vngkur nyikuka okv minpa laka Pwknvyarnv noogv lvgabv ogugo rijipvdw.” Nyi angv Jisu ninyigv lvgabv ogugo rijipvdw, banggu lo vnggola minkar toku. ");
INSERT INTO tgj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Vdwlo Jisu svparsvlv takdv gonvlo rapkur lintokudw, nyi vdwv ninyia alvbv kaarwk toku, ogulvgavbolo bunu ninyia kaaya nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Vbvrikunamv nyi ako aminv Jairas vnamgo aachito; nw Jius kumkunaam gv rigvnv akobv rito. Nw atubongv Jisu gv lvpa lvkwnglo gipvto okv kodwkkrwkla Jisunyi kooto ninyigv naam lo vngji labv vla, ");
INSERT INTO tgj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ogulvgavbolo ninyigv kuunyijar akin v, yvvdw anying nyingring gola nyingnyi mwngnv, sitv tvku. Jisu gv vngrilo nyipam hv apum bv ninyigvlo pamlwk nyato vngku mvnwng lokv. ");
INSERT INTO tgj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bunu nyipam lokv anvnyimv nvgo yvvdw oyi sarla lvvma la nyingring gola nyingnyi kunvgo; nw gv paanam mvnwngnga daktor vdwlo mva toku, vbvritola yvvka ninyia mvpu nyumato. ");
INSERT INTO tgj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nw nyipamlo aalwk dabuv Jisu gv kochinglo aalwkla okv Jisu gv vji jvlap a mvsit toku, okv vjakgobv ninyigv oyi sarnam hv sarngin toku. ");
INSERT INTO tgj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisu tvvkato, “Yvvla nga mvsit nvngv?” Mvnwngngv um miasuto, okv Pitar minto, “Tamsarnv, Nyi mvnwngngv nam dooyumdo okv no gvlo nyipam bv nam pamyumdu.” ");
INSERT INTO tgj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Vbvritola Jisu minto, “Nyi gunv nga mvsit gvibv, ngo um chinto vdwlo jwkrw go ngo gvlokv lintokudw.” ");
INSERT INTO tgj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nyimv nvngv kaatoku ninyia kaapa gvi kubv vla, vkvlvgabv nw jinjinrumrum la aatoku okv nw atuhv Jisu gv lvpa lvkwnglo gipv toku. Hoka nw nyi mvnwng gv kaagialo, nw Jisunyi minpa toku ogulvgabv nw ninyigv vji a mvsit pvnvdw okv oguaingbv nw vjakgobv poyapvku nvdw. ");
INSERT INTO tgj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisu nyimv nvnga mintoku, “Ngoogv kuunyijar a, noogv mvngjwng ngv nam alv mopvku. Alvbv vngto kulaka.” ");
INSERT INTO tgj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisu gv vbv mindung rilo, gindungpingko ako aatoku nyigam gv naam lokv. “Noogv kuunyijar hv siro yikubv,” nw Jairasnyi minto; “Tamsarbonyi vkvnvgo mindwkminku mabvk.” ");
INSERT INTO tgj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Vbvritola Jisu um tvvpato okv Jairasnyi minto, “Busu mabvka; mvngjwng mvngtoka, okv nw alv reku.” ");
INSERT INTO tgj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Vdwlo nw naam lo aachi tokudw, nw yvvnyika ninyia lvkobv arwng lo aamu mato, Pitar, Jon okv Jems mvngchik okv vmi gv anv okv abua. ");
INSERT INTO tgj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hoka nyi mvnwngngv vmi gv lvgabv kapdungto okv mvngdwk dwkdung nyato. Jisu minto, “Kapma bvka; vmiv siima kv—nyi yupmwng dunv!” ");
INSERT INTO tgj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nyi mvnwngngv ninyi nyarji nyato, ogulvgavbolo bunu chintoku nyijar angv siro pvku vla. ");
INSERT INTO tgj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Vbvritola Jisu ninyigv laak a gakbwng toku okv goklinto, “Ngoogv anga, gudungto!” ");
INSERT INTO tgj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nw gv turnam hv aakur toku, okv nw vjakgobv dakrap toku, okv Jisu bunua minto ninyia dvnam go jila dvmuto. ");
INSERT INTO tgj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nyijar gv anvabu hv lamrwpatoku, vbvritola Jisu bunua minggapto yvvnyika minpa mabvka ogugo ripvkudw. ");
INSERT INTO tgj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisu lvbwlaksu vring gola anyia gokdumto okv rigum minggum nvnv nga jitoku okv uyuvram mvnwngnga charanvnv jwkrw haka okv lvvma vdwaka mvpunvnv nga. ");
INSERT INTO tgj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Vbvrikunamv nw bunua vnglin motoku Pwknvyarnv gv Karv lvga nga japji modukubv okv lvvma nvnga mvpu modukubv, ");
INSERT INTO tgj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","bunua miro kochingbv, “Moing lvgabv ogu guka gvyoka: daadwng gvyo, giagonvnv kochak guka gvyo, dvnam gvyo, morko gvyo, jekok borgu lvvya gvma bvka. ");
INSERT INTO tgj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ogolo nonua alvbv aamu pvdw, ho banggu lokv vnglinma dvdvlo naam akinlo doobwng laka; ");
INSERT INTO tgj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ogolo nyi vdwv nonua alvbv aamu mapvdw, ho banggu ha vngyu laka okv lvpa gv pvmar haka kaklu laka bunua rirw mvrw chonam aing gubv.” ");
INSERT INTO tgj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Lvbwlaksu vdwv vngtoku nampum mvnwnglo vnggola, Gamlv a japji toku okv mooku mvnwnglo nyi vdwa mvpu toku. ");
INSERT INTO tgj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Vdwlo Herod, Galili ha rigvdakgvnv, ogugo ripv kudw ho mvnwng gv lvga nga tvvpa toku, nw achialvbv abwkmato, ogulvgavbolo nyi megonv minto Jon Baptist turkur pvkukv vto. ");
INSERT INTO tgj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kvvbi vdwv minto Elija aapvku, vjakgobv kvvbi vdwv krim gv nyijwk ako turkur pvkukv vto. ");
INSERT INTO tgj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod minto, “Ngo Jon gv dumpo nga paa pvnv; vbvritola so nyi si yvv bvri ngo soogv lvga nga tvvdu?” Okv nw Jisunyi kaadubv vla rikwng to. ");
INSERT INTO tgj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostol vdwv aakur toku okv bunugv rinam mvnwngnga Jisunyi minpa jitoku. Nw bunuam nw gv lvkobv naatoku, okv bunu atuhv Betsaida vnam banggu akolo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Vdwlo nyipam hv ho gv lvga um tvvpa tvkudw, bunu ninyia vngming gvtoku. Nw bunua alvbv aamu tuku, bunua Pwknvyarnv gv Karv lvga nga japji toku, okv dinchinv vdwa mvpu jitoku. ");
INSERT INTO tgj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Vdwlo doonyi hv pokga tvvtokudw, lvbwlaksu vring gola anyiv nw gvlo aatoku okv minto, “Nyi vdwa vngmu tukuka ogulvgavbolo bunu nampum vdwlo okv rongo rwktak vdw soka vngla dvnam okv yupku paamu tvka, ogulvgavbolo so si jvmataiku mooku go.” ");
INSERT INTO tgj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Vbvritola Jisu bunua minto, “Nonu atu hv bunua dvnam go jila dvmu tvka.” Bunu mirwkto, “Ngonu mvnwng gvlo vtwng takngu gola ngui nvnyi gomwng. No ngonua vngla so nyipam mvnwng gv lvgabv dvnam rvvkar teka mvngdure?” ");
INSERT INTO tgj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Hoka nyiga vdwv hejar angu gobv ritoku) Jisu lvbwlaksu vdwa mintoku, “Nyi vdwa nyipamlo chamngu-chamngu bv mvgvrila doomu tvka.” ");
INSERT INTO tgj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lvbwlaksu vdwgv svbv mvro kochingbv, ");
INSERT INTO tgj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisu vtwng takngu okv ngui nvnyi a naatoku, nyidomooku bv kaadung to, um Pwknvyarnvnyi umbonyikv vto, um pimwktoku, okv um lvbwlaksu vdwa jitoku nyi vdwlo ormu dubv. ");
INSERT INTO tgj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bunu mvnwngngv dvtoku okv dvgu nyatoku, okv lvbwlaksu vdwv dvlv nga paapi vring gola anyigo naakum toku. ");
INSERT INTO tgj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Alu logo lo Jisu akinv kumla doorilo, lvbwlaksu vdwv nw gvlo aatoku. Nw bunua tvvkato “Nyipam v nga yvv vla mindu?” ");
INSERT INTO tgj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bunu mirwkto, “Megonv nam Jon Baptist kv vdu.” “Kvvbi vdwv nam Elija kv vla mindu, kvvbi vdwv vbv mindungdo krimklu gv nyijwk go turkur pvku vla.” ");
INSERT INTO tgj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nw bunua tvvkato, “Nonu gvbv oguhv?” “Nonu ngam oguhv vla mindunv?” Pitar mirwkto, “No Pwknvyarnv gv Kristo.” ");
INSERT INTO tgj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Vbvrikunamv Jisu bunua mingap linlinla minto sum yvvnyika minji mabvkv vla. ");
INSERT INTO tgj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nw bunua mintato, “Nyia Kuunyilo ngv hinching rungre okv nyigagaatv vdwgv, butv vdwgv, okv Pvbv tamsarnv vdwgv toa kunam gobv rire. Ninyi mvki reku, vbvritola alu loom kochingbv nw turkur reku.” ");
INSERT INTO tgj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Okv nw mvnwngnga minto, “Yvv akonv ngam lvkobv vngming gvso mvngdunv, nw atua mvngnga sitola, alu gv loki a ninyigv daapo nga bvngla okv ngam vngming gvlaka. ");
INSERT INTO tgj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Vkvlvgabv yvvdw atu atubogv singdung nga singmu nvpv mvngdunv um ngoomu re, vbvritola yvvdw ninyigv singdung nga ngoogv lvgabv ngoomu yadunv um singmu yare. ");
INSERT INTO tgj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nyidum gunv mooku mvnwngnga mvgumrigum gvrila vbvritola nw atu v ngooya kunv gubv vmalo yaaku kunv gubv riku bolo hv ogu tuksarnam go paarikudw? Vbvrirung maare! ");
INSERT INTO tgj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nyidum gunv ngam okv ngoogv tamsar sarlwk nama hinying bolo, vbvrikubolo Nyia Kuunyilo vka ninyia hinying reku vdwlo nw gv okv Abu gv okv nyidogindung gvka kairungnv yunglit gubvrila aari kunyi. ");
INSERT INTO tgj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngo nonua jvjvbv mindunv ho megonv si doodu bunu simare vdwlo Pwknvyarnv gv Karv nga kaama dvdvlo.” ");
INSERT INTO tgj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Lokkanw dvse toku nw gv so ogu a minro kochingbv, Jisu nwha lvkobv Pitarnyi, Jonnyi, okv Jemsnyi vnggvla okv kumdubv moodwlo chaatoku. ");
INSERT INTO tgj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nw gv kumdung rilo, nw nyukmu v angu suto, okv nw gv vjiv yapung toji toku. ");
INSERT INTO tgj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lamdadubv hoka nyi anyigo ninyi lvkobv gaam raami suto. Ho anyiv Moses okv Elija, ");
INSERT INTO tgj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bunyiv kairungnv nyidomooku gv yunglit nama kaatam toku okv Jisunyi lvkobv gaam raami suto ninyigv Jerusalem lo sigv rila Pwknvyarnv gv minkipvvnam a baapu alvbv rilin jise gv lvkwngbv. ");
INSERT INTO tgj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitar okv nw a lvkobv rinv vdwv yupngak toku, vbvritola bunu hurap datoku okv kaapa toku Jisu gv yunglit a okv nyi anyi ninyi lvkobv daknam a. ");
INSERT INTO tgj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nyi anyi gv Jisu nyi vngyu tvrilo, Pitar Jisu nyi minto, “Ahtu, ngonugv so doonam si alvrungnv go! ngonu so taabio aom go biore, akonyi no lvgabv, akonyi Moses gvbv, okv akonyi Elija gvbv.” (Nw ogugo mindungdvdw um alvbv chimato.) ");
INSERT INTO tgj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nw gv vbv mindung rilo, haapam ako kaklwkto okv bunua doonyum bv nyumrum toku; okv lvbwlaksu vdwv busu toku haapam gv vbv bunu gvlo kaklwk rilo. ");
INSERT INTO tgj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Haapam lokv gaamgo milinto, “Si ngoogv darnam, Kuunyilo ngv—ninyi gvlo tvvtolaka!” ");
INSERT INTO tgj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Vdwlo gaam v minya tokudw, hoka mvnwnglo Jisu akin mvngku. So mvnwng gv lvga nga lvbwlaksu vdwv choibv doobwngto, okv bunu ogugo kaapvdw ho dw hoka yvvnyika minpa mato. ");
INSERT INTO tgj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Logo nvnga Jisu okv ninyigv lvbwlaksu vdwv moodw lokv lvkwng itoku, okv kairungnv nyipam go Jisunyi kaarwksuto. ");
INSERT INTO tgj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nyipam lokv nyi ako gokto, “Tamsarnv! ngo nam kodwkkrwkla koodunv, ngoogv kuunyilo nga kaakato—ngoogv kuunyilo akin a! ");
INSERT INTO tgj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dow v ninyia lamdubv mvrapla okv ninyi semit taplwk modu, vkvlvgabv nw gaam lo sepit taik lindubv mvdu; vbvdvdvbv ninyia achi dubv mvbwngla okv vngnyu madubv ninyia vngmudo! ");
INSERT INTO tgj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngo no gv lvbwlaksu vdwa kodwkkrwkla kooto um chara modubv vla, vbvritola bunu mvnyu mato.” ");
INSERT INTO tgj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","“Nonu vdwnvgo mvngjwng manv okv rimurnv nyi vdw golaka! ngo nonua lvkobv vdwgo doodubv? Vdwgo ngo nonu gvlo laklwk sula doodubv?” Vbvrikunamv, nw nyi anga minto, “Noogv kuunyilo nga so aagv teka.” ");
INSERT INTO tgj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Vmi gv aadungrilo, alvmanv dow hv ninyia kvdw lo hwkluto okv semit taplwk dubv mvtoku. Jisu uyu dow a orto jitoku, vmi a mvpu toku, okv ninyi ninyigv abua jikur toku. ");
INSERT INTO tgj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nyi mvnwngngv Pwknvyarnv gv kairungnv jwkrw a kaala lamrwpanya toku. Nyi vdwv vjaklodvbv lamrwpanyato Jisu gv ogu mvnwng ridung nama, vdwlo nw ninyigv lvbwlaksu vdwa minto kudw, ");
INSERT INTO tgj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mvngpa mabv riyoka ngo nonua ogugo mintam tvdudw! Nyia Kuunyilo nga nyi vdwgv laak lo laklwk tvduku.” ");
INSERT INTO tgj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Vbvritola lvbwlaksu vdwv chimato ho gv minam v ogu vdw. Bunugv lokv si toosi nam gubv rito vkvlvgabv bunu hum chinyu maatoku, okv ho gv lvga nga bunu ninyia tvvka svngaka busu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lvbwlaksu vdwv bunugv lokv yvvdw kaiyachok jinv vla larmisinya toku. ");
INSERT INTO tgj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisu chintoku bunu ogugo mvngdung dudw, vkvlvgabv nw vmi ako naatoku, nw gvlo dakmu toku, ");
INSERT INTO tgj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Okv bunua minto, “Yvvdw ngoogv amin bv so vmi sum alvbv torwk sidunv, nga torwk sinamv; okv yvvdw nga torwk sidunv, nga imu nvnga ka torwk sidunv. Vkvlvgabv nonu mvnwng gvlo yvvdw miangyachok dunv hv kaiyachok nvngv.” ");
INSERT INTO tgj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon minto, “Tamsarnv, ngonu nyi ako noogv amin lokv uyuvram charlin nvgo kaapa tvbv okv ngonu ninyia mintorto, ogulvgavbolo nw ngonugv rikulo rinvma.” ");
INSERT INTO tgj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Ninyia mintor dubv rikw nyayo ka,” Jisu Jonnyi okv kvvbi lvbwlaksu vdwa minto, “Ogulvgavbolo yvv nonua rinying maadudw hv nonu gvngv.” ");
INSERT INTO tgj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisunyi nyidomooku bv naachadw hv kvnwk lvlv toku, nw mvngnam a mvngbwk datoku okv Jerusalem lo vngdubv ninyigv lamtvlo vnglintoku. ");
INSERT INTO tgj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nw gindungpingko vkv vngcho moto, v samaria nampum arwnglo vngto ninyigv lvgabv ogumvnwngnga paala mvkimvak pvvdukubv. ");
INSERT INTO tgj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Vbvritola nyi vdwv ninyia naarwk sima toku, ogulvgavbolo ho v nw ninyigv lamtv nga Jerusalem bv vngdu vla abwk toku. ");
INSERT INTO tgj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Vdwlo lvbwlaksu Jems okv Jon hum kaatokudw, bunu minto, “Ahtu, no ngonua nyidomooku tolokv vmv go goklu la bunua guyak guchak modubv mvngdure?” ");
INSERT INTO tgj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisu dakrwk la bunua yamto. ");
INSERT INTO tgj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Vbvrikunamv Jisu okv ninyigv lvbwlaksu vdwv kvvbi nampum lo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Vbv bunugv lamtvlo bunu vngdungrilo, nyi ako Jisunyi minto, “No Ogolo vngdaka nam ngo vngming gvvre.” ");
INSERT INTO tgj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisu ninyia minto, “Haaringpaksar ngv ungrung doonyado, okv pvta ngv asup doosu nyadu, vbvritola Nyia Kuunyilo ngv oguloka karku guka okv doonu jiku guka kaayama.” ");
INSERT INTO tgj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nw kvvbinyi akonyika minto, “Nga vngming gvlaak.” Vbvritola ho nyi angv minto, “Tamsarnv, atukchochukbv nga vngkur mola okv ngoogv abunyi svma riiso molabv.” ");
INSERT INTO tgj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisu mirwkto, “Sinv nga bunugv svma nga risu motoka. No vngnyika Pwknvyarnv gv Karv nga japgo tvka.” ");
INSERT INTO tgj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kvvbinyi akonv minto, “Ngo nam vngming gvvre vbvritola atokchochukbv nga ngoogv vpin a alvbvka vmu labv.” ");
INSERT INTO tgj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisu nw a minto, “Yvvnyi akonv kvdw a gwor raptokula okv vbvrinamv kochingbv kaakor dvdvnv Pwknvyarnv gv Karv lo rinv nvdu bv rima dunv.” ");
INSERT INTO tgj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","So kochingbv Jisu kvvbi nyiga vkv chamkanw gula anyi go gokla, nw atu v vngjiku banggu mvnwnglo okv mooku lo anyi anyibv vngcho moto. ");
INSERT INTO tgj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nw bunua minto, “Aam nvvse ngv hoka achialv duku, hum nvvji nvngv miang gumwng. Kumtoka aam atu gv lvgabv nw aam nvvji nvnga vnglin more ninyigv aam nvvse um nvvmure. ");
INSERT INTO tgj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Vngnyika! ngo nonua svcha chaapamlo svlar vdw jebv vngmu gvrinvla ");
INSERT INTO tgj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nonu morko vgianvnv, vmalo giagonvgv chapa vmalo lvsup; lamtvlo nyi vdwa alvpvri vla minam a topu mabvka. ");
INSERT INTO tgj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Vdwlo nonu naam ako gv arwng aarinyi, atokcho bv minlaka ‘So naam soka mvngpu v lvkobv doolaka.’ ");
INSERT INTO tgj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hoka sarsopoyonv nyi go doodu bolo, nonugv sarsopoyo ngaaka ninyigvlo doolwk molaka; vkv kaama bolo, nonugv sarsopoyo nga naakur lakuka. ");
INSERT INTO tgj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ho gv naam akinlo doobwng laka, dvdunglaka okv tvngdung laka oguggo nw nonua jilin dudw, rinv nga ninyigv rijo nga jirung dunv. Naam namgunv lokv kvvbi namgu nvlo vnggo mabvka. ");
INSERT INTO tgj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Vdwlo nonu banggu ako gv arwnglo vngrikudw okv alvbv aamu pvkulo, ogu go nonua mvpvripv jipvdw dvlaka, ");
INSERT INTO tgj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ho banggu gv lvvma nvnga mvpu jilaka, okv hoka nyi vdwa minlaka ‘Pwknvyarnv gv Karv ngv nonu lo nvchibv aapvku vla.’ ");
INSERT INTO tgj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Vbvritola vdwlo nonu banggu akolo vngridw okv alvbv aamu mapvlo, vnglin lakuka lamtvlo hoka minlaka, ");
INSERT INTO tgj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘nonugv banggu gv dwmar ngonugv lvpalo doonv haka ngonu nonua rinying bv mvlu jidunv. Vbvritola mvnggap laka Pwknvyarnv gv Karv ngv aapvku nonugv nvchilo!’ ");
INSERT INTO tgj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngo nonua milv jidunv Jwngkadaka Alu lo Pwknvyarnv ho banggu um svnga Sodom a kaiyago aya kaatamre! ");
INSERT INTO tgj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Chorajin! no lvgabv vdwgo mvngdwk dwknam gubv rire, Betsaida! no lvgabvka vdwgo mvngdwk dwknam gubv rire, nonu gvlo lamrwpadubv mvkunam vdwa Taire okv Sidon lo rinv guilo, ho gv nyi vdwv krim doopam dukunvpv, tagiam vjia kooto kula okv mvchu a bunu atu v harbum sitokula, nw bunu rimur lokv mvngdin dukunv vla kaatam bvku ripv kunvpv! ");
INSERT INTO tgj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nonu am svnga kaiyago Pwknvyarnv Taire okv Sidon ha aya kaatamre Jwngkadaka Alu lo. ");
INSERT INTO tgj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Karparnaum! Okv no lvgabv, no atu hv nyidomooku ao tolo harsa sidubv mvngdure? Nam uyumooku bolo paalu rinvla!” ");
INSERT INTO tgj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisu ninyigv lvbwlaksu vdwa minto, “Yvv bunu nonua tvriadunv hv ngamka tvriadunv; yvv bunu nonua toa dunv hv ngamka toa dunv; okv yvv bunu nga toa dunv hv nga so imu nvngaka toa dunv.” ");
INSERT INTO tgj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nyiga chamkanw kanw gula anyi vdwv aakur toku kairungbv himpula. “Ahtu” bunu minto, “Uyuvram vka tvvdu vdwlo ngonu noogv amin bv bunua mintodw!” ");
INSERT INTO tgj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisu bunua mirwkto, “Ngo Uyu nga nyidomooku lokv dooriak jvbv hoolu dubv kaato. ");
INSERT INTO tgj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tvriato! ngo nonua jwkrw a jipv kunv, vkvlvgabv nonu tabw vdwgv okv dwkung vdwgv aolo vngla dukubv okv nyimak gv jwkrw mvnwngnga rigum yadubv, okv nonua ogugoka alvmanv rika madubv. ");
INSERT INTO tgj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Vbvritola alvmanv dow vdwv nonua tvvdu vla himpu mabvka, vmabvya himpu yalaka ogulvgavbolo nonugv amina nyidomooku tv lvkpv yadu.” ");
INSERT INTO tgj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ho dw lo Jisu himputo Darwknv Dow doonam lvkwng lokv okv minto, “Abu, nyidomooku gvla Sichingmooku gv Ahtu! Ngo nam umbonyika mvngdunv ogulvgavbolo no chima nvnga kaatam jikunam lvgalo noogv chinkichiak okv chinvpanv lokv vvsivrum nama. Vmabv Abu si noogv mvnggv rila rimu nvpv mvngnam a rimunamv.” ");
INSERT INTO tgj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ngo gv Abu nga ogumvnwng nga jito. Kuunyilo ngv yvvdw um yvvka chinv kaama Abu mvngchik chindu, okv Abu yvvdw um yvvka chinv kaama Kuunyilo mvngchik okv Kuunyilo gv ninyia kaatam dukubv vla darkunam vdwv.” ");
INSERT INTO tgj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Vbvrikunamv Jisu lvbwlaksu vdwa dakrwk toku okv bunua minsila minto, “Nonuno gamdak nvgo laka nonugv ogu kaadubv mvngnam a nonu kaapa mindu! ");
INSERT INTO tgj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngo nonua mintam jidunv vdwnv nyijwk vdwv okv kvvbi vdwv nonugv kaanam um kaanwng nyato, vbvritola bunu kaala matoku, okv nonugv tvvnam hum bunu tvngnwngto vbvritola bunu tvvpa kuma toku.” ");
INSERT INTO tgj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pvbv tamsarnv ako aato okv Jisunyi mingkup tvvto. “Tamsarnv,” nw tvuto, “Turbwngla singnam a paanam lvgabv ngo ogugo rise gubvre?” ");
INSERT INTO tgj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisu mirwkto, “Darwknv Kitaplo ogu vla minpv? Okv um no oguaingbv japjidunv?” ");
INSERT INTO tgj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nyi angv mirwkto, “Atunyi, noogv Pwknvyarnvnyi no haapok mvnwng lokv, noogv yalu mvnwng lokv, noogv gwlwk mvnwng lokv, okv noogv mongrumara mvnwng lokv; okv no atu hv oguaingbv paksu dudw vkv aingbv noogv namrwk ajin a pakmi sulaka.” ");
INSERT INTO tgj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“No alvbv mingvnyibv,” Jisu mirwk suto; “sum rilaka okv no turriku.” ");
INSERT INTO tgj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Vbvritola Pvbv tamsarnv nyi angv atu v abwk nvpv mvngtoku, vkvlvgabv nw Jisunyi tvvkato, “Yvvla ngoogv namrwk doobam ajin v?” ");
INSERT INTO tgj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisu mirwkto, “Ho hoka nyi ako dooto, nw Jerusalem lokv Jeriko bv idungto ho ninyia dvchotvnglanv nyi vdwv naatungto, ninyia vji pibinto, okv achialvbv dvngto, siloyasi dubv mvtola kayuto. ");
INSERT INTO tgj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hum hoka vbv rimutvla lamtv hoka nyibu ako idungto; vbvritola nyibu angv nyi anga vdwlo kaapa tokudw, nw vngyela, kvvbi lamtvbv vngto. ");
INSERT INTO tgj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vbvdvdvbv Libait ako vngtato, vngsito okv nyi anga kaato, okv vbvrikunamv vngyela, kvvbi lamtvbv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vbvritola samaritan ako ho lamtvlo vngdung nvgo aala nyi angv gv dookulo aato, okv vdwlo nw ho nyi anga kaatokudw, ninyigv haapok hv aya mvngpa toku. ");
INSERT INTO tgj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nw nyi angv gv dookulo aato, nyi angv gv ungvlo tvli okv opo pwbumto okv hum putum toku; vbvrikunamv nw ho nyi a ninyigv svnwng aolo joopvto okv hotel golo baklwk toku, hoka nw nyi anga ringchum yatoku. ");
INSERT INTO tgj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Alu logo nvlo nw ain lokdwng charnyi go naalinto okv hum ringchum nvnga jitoku. ‘Ninyia ringchum laka,’ nw ringchum nvnga mintoku, ‘okv vdwlo ngo so lamtvbv vngkur rikudw, no nyi so gv lvgabv ogugo ngoopvdw um ngo nam jireku.’” ");
INSERT INTO tgj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Okv Jisu minyabv minto, “Noogv mvngnam lokv, so nyi aom sokv yvvla namrwk ajin jvbv ripvnv dvchonv nyi vdwgv dvngnam nyi anga?” ");
INSERT INTO tgj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pvbv tamsarnv angv mirwkto, “Ninyia ayanv angv.” Jisu mirwkla minto, “Vbvrikunamv no vngnyi, okv vbvdvdvbv rilaka.” ");
INSERT INTO tgj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisu la ninyigv lvbwlaksu vdwv bunugv lamtvlo vngrilo nw nampum golo aatoku hoka Marta vnam nyimv go ninyigv naam lo Jisunyi alvbv aamu toku. ");
INSERT INTO tgj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nw bormv ako dooto aminv Meri, nw Jisu gv lvpa lvkwnglo dootola ninyigv tamsar nama tvvriato. ");
INSERT INTO tgj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ninyigv gwngserise ngv achialv kunam lvgalo nw timbuto, vkvlvgabv nw aato okv ninyia minto, “Ahtu, ngoogv bormv, nga gwngserise ngv awgo doomu gvrila nga vngyunam sum no kaachin malare? Ninyia ngam ridumdubv mintokv!” ");
INSERT INTO tgj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ahtu ninyia mirwkto, “Marta, Marta! no gwngserise achialv gv aolo timbula okv adwkaku dunvre, ");
INSERT INTO tgj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","vbvritola akin go dinchi yadu. Meri alvyanv go gakyapv, okv sum nw gvlo vdwloka dvrit nyulamare.” ");
INSERT INTO tgj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Alu logolo Jisu mooku golo kumla dooto. Vdwlo nw kumngin tokudw, ninyigv lvbwlaksu akonv ninyia minto, “Ahtu, ngonua kumsar labv, Jon ninyigv lvbwlaksu vdwa kumsarnam jvbv.” ");
INSERT INTO tgj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisu bunua minto, “Vdwlo nonu kumrinyi, sum minto: ‘Abu: Noogv darwknv aminv mvngdvnam gubvka; noogv Karv ngv aalaka. ");
INSERT INTO tgj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ngonugv dvsetvngse nga alu-alua jilaka. ");
INSERT INTO tgj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ngonugv rimur vdwa mvngnga jilaka, ngonua rimurnv vdwa ngonu mvngnga jidunv. Okv ngonua alvmanv gwngkarika moyoka.’” ");
INSERT INTO tgj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Okv Jisu ninyigv lvbwlaksu vdwa mintoku, “Svkv aingbv nonu gvlokv akonv ayuyupra nga ajin gv naam lo vngla minre, ‘Ajin, nga vtwng taggom go narlabvkv. ");
INSERT INTO tgj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ngoogv ajin ako moing vngnvgo nw vjakpi ngoogv naam lo aalwkpv, okv ngo ninyigv lvgabv dvnam go dooma!’ ");
INSERT INTO tgj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Okv svkv aingbv noogv ajin v naam arwng lokv mirwk bolo, ‘Nga no mindwkmingku mabv! vriap agi ngv koktum ropvku, okv ngo la ngoogv kuu vdwv gadw lo doopv kunv. Ngo gudungla nam ogugo jinyuma.’ ");
INSERT INTO tgj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Alvdo, vbvrikunamv ogugo rire? Ngo nonua minpadu, nw ngoogv ajin v vla gudungla nam ogugo jima jeka noogv hinying mabv koodv-koodvnam lokv nw gudungla nam ogugo jirung reku. ");
INSERT INTO tgj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Okv vkvlvgabv ngo nonua mindunv: Kolaka okv no paarungre; makar laka no mapare; takdin laka, okv agi nga no lvgabv kokda pvjire. ");
INSERT INTO tgj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mvnwngngv yvv koodunv hv paadu, okv yvvdw makar dunv mapare, okv yvvdw takdin dunv ninyigv lvgabv agi a kokda pvjire. ");
INSERT INTO tgj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nonu gv abu vdwv yvvla kuu nga vtwng go koomu gvrila tabw go jinv? ");
INSERT INTO tgj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Vmalo no ninyia pvpw go koomu gvrila dwkung go jiredw? ");
INSERT INTO tgj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","No alvmanv gubv rijeka, no chindu oguaing bv alvnvgo kuu nga jise ngvdw. Vbvrikunamv ung achialv kaiyanv go, nyidomooku lo doonv Abu Darwknv Dow a jirungre yvvdw ninyia koodunv!” ");
INSERT INTO tgj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisu milin momanv uyuvram ako charlin toku; vdwlo uyuvram angv vngro tokudw, nyi angv milin raptoku. Nyipam vdwv lamrwpatoku, ");
INSERT INTO tgj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","vbvritola megonv nyi vdwv minto, “Si Biljebul pvnv go, uyuvram vdwgv dvbv, v ninyia bunua charanvnv jwkrw a jiriadu.” ");
INSERT INTO tgj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kvvbi vdwv Jisunyi gwngkup dvbv mvngto, vkvlvgabv bunu ninyia lamrwpanam go kaatam labv Pwknvyarnv nam yarlwk pvnvlo vla kooto. ");
INSERT INTO tgj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Vbvritola Jisu bunugv mvngnam a chinto, vkvlvgabv nw bunua minto, “Diringmooku gunv atu v apum-apum gubv yakpin sila hv padar minsu kubolo hv vdwloka doobwng lamare; vpin akonv atu v apinain sila rinying minsunv, hv ngoopinngoin dukunv. ");
INSERT INTO tgj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Vkvlvgabv Uyu gv karv ngv apum gubvrila padar minsu kubolo, oguaingbv hv doobwng nyudubv? Nonu mindu nga uyuvram vdwa charadu ogulvgavbolo Biljebul ngam jwkrw jinam lokv vbv rimu doonv vla. ");
INSERT INTO tgj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Vbv rungbv ngo bunua charlin dunv bolo, nonua reming gvnv vdwv oguaingbv bunua charlindunv? Nonua reming gvnv vdwv nonua rimur do vla gakdu! ");
INSERT INTO tgj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma ho mabvdv ngo Pwknvyarnv gv jwkrw lokv bunua charlindunv, okv si kaatamdu Pwknvyarnv gv Karv ngv nonu gvlo aapvku vla.” ");
INSERT INTO tgj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Vdwlo gwlwknv nyi akonv, ninyigv panvnaanv nvnga lvkobv doogu sila, atubogv naam a kaaria sikubolo ninyigv yidu vdwv ngemare. ");
INSERT INTO tgj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Vbvritola vdwlo nyi gunv ninyia gwlwk yanvgo nw gvlo palwk laku ninyia mvya yaku bolo, atu gv mvngging kunam yidu vdwa gvla yikula okv ogugo dvrit pvkudw orpin-oryin sireku.” ");
INSERT INTO tgj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yvvdw ngogvbv rima dunv jvjvbv hv nga rinying nvngv; yvvdw nga ridur madunv, naakum nvngv ka jvjvbv ayakapakdu.” ");
INSERT INTO tgj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Vdwlo alvmanv dow v nyidum lokv linri kunyi, hv pvtwngko mooku lo dooku makarla vnggo kardu, hv dooku akoka mapa kuma bolo, hv atu v mindu, ‘Ngo ngoogv naam lo aakur reku.’ ");
INSERT INTO tgj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Vkvlvgabv nw aakur dukula naam a doin doopa dubv kaapa duku. ");
INSERT INTO tgj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Vbvrikunamv vnglinlaku okv ninyia alv mayanv uyu dow kanw go aagv dukunv okv bunu aalaku hoka doolwk duku. Vkvlvgabv vdwlo vbv rirekudw, ho nyi gv rinamdaknam hv kvvlo gvnga kaiyabv alvmayabv ridu kunv.” ");
INSERT INTO tgj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Vdwlo Jisu hum minto kudw, nyimv nvgo nyipam lokv goklin la ninyia minto, “Achialv mvngpu v ho nyimv angv nam dwrwboklin la sootv bongv!” ");
INSERT INTO tgj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Vbvritola Jisu mirwkto, “Vmabvya, achialv mvngpu v yvvdw Pwknvyarnv gv gaam a tvvdunv okv hum ridunv!” ");
INSERT INTO tgj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nyi vdwv Jisunyi nyipam bv dooyum lvlv toku, nw mimbwngla minto, “Silu meriu gv nyi vdw si achialvbv alvmado! bunu lamrwpanam go koodu, vbvritola Jona gv lamrwpanam a jimwngre kvvbi lamrwpanam yagu bunua jimare. ");
INSERT INTO tgj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ho apiabv nyijwk Jona Ninebe nyi vdwgv kaaringtamanam gobv rito, vkvlvgabv Nyia Kuunyilo vka silu meriu gv nyi vdwgv kaaringtama nam gubv rire. ");
INSERT INTO tgj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jwngkadaka Alu lo Seba gv Dvnv angv dakrapre okv silugv nyi vdwa gungnying milwkre, ogulvgavbolo nw ninyigv mooku lokv lamtv mvnwngnga vngmila vngtoku Solomon gv mvnglakmilak a tvvdubv vla; okv ngo nonua mindu Dvbv Solomon nyika kaiyanv ogugo sika si doopv. ");
INSERT INTO tgj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jwngkadaka Alu lo Ninebe gv nyi vdwv dakrap dvla nonua gungnying milwkre, ogulvgavbolo bunu Jona gv japji nama tvvla bunu bunugv rimur lokv mvngdin toku; okv ngo nonua jvjv bv mindunv Jona nyika kaiyanv go sika si doopv! ");
INSERT INTO tgj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Yvvka mvdurrupum a baanu gvrila vsila vmalo bati lvkwnglo vvpvnv kaama; vmabvya, nw hum tunggingnvnv lo vvpv yadunv, ogulvgavbolo nyi aanv vdwa kaapa modubv. ");
INSERT INTO tgj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Noogv nyik vdwv ayak gv lvgabv mvdurrupum jvbv rido. Vdwlo noogv nyik vdwv alvbolo, noogv ayak mvnwnglo loung ngv akomaring do; vbvritola vdwlo noogv nyik vdwv alvmabolo, noogv ayak mvnwngngv kanv arwng lo dooreku. ");
INSERT INTO tgj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Vbvrikunamv, mvnggap tvvlaka, no gvlo loung doodunv am kanv madubv. ");
INSERT INTO tgj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Noogv ayak mvnwnglo loung yayabv, ogugoka kanvnamgo kamabv ridu bolo, hv mvnwnglo achialvbv loungre, mvdurrupum gonvgv achialvbv ungnam loung ngv, nam ungkanam jvbv rire.” ");
INSERT INTO tgj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Vdwlo Jisu mintung nga minya tokudw, Parisis ako ninyia lvkobv dvnam dvbam dubv vla gokto; vkvlvgabv nw vngtoku okv dvdubv vla dootung toku. ");
INSERT INTO tgj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jisu gv dvma dwbv lasok manama Parisis nyi angv kaatokula lamkisak patoku. ");
INSERT INTO tgj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Vkvlvgabv Jisu ninyia mintoku, “Vbvrikunamv vjak, nonu Parisis vdwv nonugv koobu okv taali a agum a harkakdu, vbvritola arwnglo nonu dokchanam okv alvmanam v yarbingdu. ");
INSERT INTO tgj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pvchanv! Pwknvyarnv yvv agum gvnga mvnv, arwng gvnga mvmapvnvre? ");
INSERT INTO tgj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Vbvritola noogv koobu okv taali arwnglo ogugo doodudw um heemanv vdwa jitoka okv ogu mvnwngngv nonugv lvgabv darwk reku.” ");
INSERT INTO tgj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Vdwnvgo hirukaya gubv rire nonu Parisis nonu vdwa! nonu Pwknvyarnvnyi uji-uu linku loka vring lokv akonyi jinam a jidu, pudina uu okv achialv amok jungnv nvmwng uu okv kvvbi mvnwng uu hvkv nvnga, vbvritola nonu alvbv rinam a okv Pwknvyarnvnyi paknam a rimadu. So vdw sam nonu risar-sise ngvrung, dvbv vdwaka topu mabv. ");
INSERT INTO tgj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Vdwnvgo hirukaya gubv rire nonu Parisis vdwa! nonu Jius kumkunaam vdwlo alvyachoknv doogingnvnv nga mvngbiu nvngv okv piokpam dorpamlo vdwlo alvyochok bv mvngdv konwng nvngv. ");
INSERT INTO tgj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Vdwnvgo hirukaya gubv rire nonua! nonuno nyibung bungpam a mvu magvrila nyi vdwgv chimabv vngkarnam jvbv rido.” ");
INSERT INTO tgj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pvbv tamsarnv nyi akonv ninyia minto, “Tamsarnv, vdwlo no svbv minam v ngaaka miyakaya tadunv!” ");
INSERT INTO tgj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisu mirwksito, “Pvbv tamsarnv nonuaka vdwnvgo hirukaya gubv rire! nonu nyi gv nangkulo bagla madubv vge mvlwkdu, ho vge a bagdubv nonu atu v lakching vka ridur dubv chilin manv. ");
INSERT INTO tgj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nonua vdwnvgo hirukaya gubv rire! nonu nyijwk vdwgv lvgabv alvnv nyibung mvpvdo, ho nyijwk vdwa nonugv abuapa vdwgv gwngrw mingku namv. ");
INSERT INTO tgj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vbvrikunamv nonuka ho aaming gvduku, nonugv abuapa gv rinam am tolwk duku; bunu nyijwk vdwa gwngrw mintoku, okv nonu bunugv nyibung vdwa mvto. ");
INSERT INTO tgj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","So lvgabv Pwknvyarnv gv mvnglak v minto, ‘Ngo nyijwk vdwa okv gindungpingko vdwa vngmure bunu gvlo; bunu mvkire bunu kvgonam okv kvgunam mvritre.’ ");
INSERT INTO tgj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Vkvlvgabv selu gv nyi vdw sum mvritre ogu lvga nyiamooku a pwklin rilokv rila nyijwk mvnwngnga mvkijinam lvgalo, ");
INSERT INTO tgj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelnyi gwngrw gwnam lokv rila Jakarianyi gwngrw gwnam lobv bunua mwkwmwya mwwku gvla darwknv kumku pingkolo mvkitoku. Hum, ngo nonua mindunv, bunu mvnwng gv lvgalo selu gv nyi vdw sum mvritre!” ");
INSERT INTO tgj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Vdwnvgo hirukaya gubv rire Pvbv tamsarnv nonua! nonu chinampanam gv naam a yikoknvnv chabi a vvpv riadu; nonu atu v hoka arwng aama gvri okv kvvbi vdwaka arwng aamu mado!” ");
INSERT INTO tgj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Vdwlo Jisu ho mooku a vngyu tokudw, Pvbv tamsarnv vdwv la Parisis vdwv ninyia achialvbv minjimio rapto okv ninyi ogumvnwngnga tvuto, ");
INSERT INTO tgj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bunu ninyia kupdubv vla okv rimur go gakdubv vla rikw nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hejar hejar nyi v nyipam bv aakum kunamv, vkvlvgabv bunu chaajap minsu toku, Jisu mintuminke bv ninyigv lvbwlaksu vdwa minto, “Parisis vdwgv vpap am himasuto laka—Ngo minamsi bunugv kaakudubv rinam a. ");
INSERT INTO tgj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ogugonyi mvtum pvdw hum mvkok reku, vvsinam mvnwng vdwa chimu reku. ");
INSERT INTO tgj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Vkvlvgabv, nonu ogugo kanv arwnglo minpvkudw hum alulvpa loung kolo tvvpa reku, nonugv naam a koktum tvvla arwnglo japsi nama naam mwnglo aolo chaapv tvvla gokpa reku.” ");
INSERT INTO tgj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ngo nonua mindunv, ngoogv ajin vdwa, ayakka mvki jinv nga yvvnyika busu mabvka vbvritola ayungjvma kochinglo ogu alvmanvgo rinyu mare. ");
INSERT INTO tgj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yvvnyi busu svngvdw ngo kaatamre: Pwknvyarnvnyi busu laka, nw gvlo, mvkiro kochingbv, uyumooku bolo horlu nyudubv jwkrw doodu. Nga tvjwng laka, ninyinv nonugv busu svngv!” ");
INSERT INTO tgj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Pvdwng nvnga barnyi gubv piokma dvnvri? Vbvrijvka Pwknvyarnv pvdwng nvvkin gunyika mvngpa mabv rima. ");
INSERT INTO tgj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nonu gv dumpo gv dwmw mvnwng haka kingam ropv. Vkvlvgabv busu mabvka; No pvdwng vdwa achialvbv arv doya nvgo!” ");
INSERT INTO tgj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ngo nonua jvjvbv mindunv yvvdw nyi vdwlo ngo gvngv vla nw minpok jidunv, Nyia Kuunyilo ngvka vbvdvdvbv bunua rire nyidogindung vdwgv Pwknvyarnv gv kaagialo. ");
INSERT INTO tgj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Vbvritola yvvdw nga nw gvngema vla minpok dunv, Nyia Kuunyilo ngvka bunua nw gvngvma vla mintare nyidogindung vdwgv Pwknvyarnv gv kaagialo. ");
INSERT INTO tgj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yvvdw Nyia Kuunyilo nga minying dunv hum mvngnga nyulare; Vbvritola yvvdw Darwknv Dow a minying dunv hum vdwloka mvngnga nyulamare.” ");
INSERT INTO tgj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Vdwlo bunu nonua Jius kumkunaamlo rika dubv vmalo gobunor vdwgv kaagialo vmalo kvvbi vdwgvlo, nonu atu v oguaingbv mvnging svngvdw vla vmalo nonu ogugo minsedw vla mvngdwk mabvka. ");
INSERT INTO tgj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nonu ogugo mirung svngvdw hum hoka Darwknv Dow v nonua tamsarre.” ");
INSERT INTO tgj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nyipam lokv nyi ako Jisunyi minto, “Tamsarnv, ngoogv achiboru a minjilabv abu gv yikungyira vngyu nama ngam lvkobv orpin sudubv.” ");
INSERT INTO tgj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisu ninyia mirwkto, “Ajin, nga nonyi gv pingkolo miriadubv vmalo yikungyira nga baag nyuladubv jinv ngv yvvla?” ");
INSERT INTO tgj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Okv nw mvnwngnga minbwngto, “Raarwnv mvnwng gvlokv nonu atuv himasuto laka; ogulvgavbolo nyi gv jvjvbv singnam v ninyigv yikungyira lokv mvvma, nw vdwgo nyitv dajvka.” ");
INSERT INTO tgj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Vbvrikunamv Jisu so minchisinam sum bunua miji toku: “Ho hoka nyi ako dooto nw kvdw go rongo ali amw alvbv linji nvgo dooto. ");
INSERT INTO tgj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nw atu v mvngrap sutoku, ‘Ngo ngoogv ali amw a vvpv jikugo kaakuma. Ngo ogugo rila dukunv? ");
INSERT INTO tgj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ngo so svbv rireku,’ nw atu v minsuto; ‘Ngo ngoogv nesung nga mvyak reku okv sungtv nvgo mvgvrekula hoka ngoogv ali amw okv ngoogv yikungyira mvnwngnga vvpv reku. ");
INSERT INTO tgj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Vbvrigvrikula ngo atu v minsureku, Gamdaknv nyi go! no achialv anying gv lvgabv dinchijinam alvnv ogu mvnwng ngv doosupvku. Himpu alvbv svngmin laka, dvmin laka, tvngmin laka okv no atuv himpu dubv rimin sulaka!’ ");
INSERT INTO tgj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Vbvritola Pwknvyarnv ninyia minto, ‘Pvchanvno! Siyu gv ayulo no noogv singnam a topu rungdubv rireku; vbvrikunamv no atubogv lvgabv ogu mvnwng nga mvpvripv kunama paajikunv yvvkudw?’” ");
INSERT INTO tgj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Okv Jisu minyabv minto, “Atubogv lvgabv nyitv tvvtola vbvritola Pwknvyarnv gv lvgabv nyitv manv ngv so svbv ridunv.” ");
INSERT INTO tgj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Vbvrikunamv Jisu lvbwlaksu vdwa minto, “Okv vkvlvgabv ngo nonua mindunv nonu dvla singdubv vla dvse lvgabv vmalo nonu ayak gv lvgabv vji kose go vla mvngdwk mabvka. ");
INSERT INTO tgj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Singnam si dvnam a achialvbv kaiyanv, okv ayak si vji a achialvbv kaiyanv. ");
INSERT INTO tgj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Paak ka kaatoka: bunu ali lilwkma vmalo aam nvvma; bunu nesung naam kaama; Pwknvyarnv bunuam dvmu tvngmudu! nonu pvta vdwa achialvbv arv doya nvgo! ");
INSERT INTO tgj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hum mvngdwk gvrila nonu gvlokv akonv yvvla svnggv nama achukgo svngsu yadubv svnglajinv? ");
INSERT INTO tgj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","No svkvnv ogu miang nvnga rilwk nyuma bolo, ogubv kvvbi ogua mvngdwk yadunv? ");
INSERT INTO tgj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kaatoka mootum gv apung ngv oguaing bv svngdu: bunu ogugo rima vmalo bunu atugv lvgabv vji vbi mvvma. Vbvritola ngo nonua mindunv Dvbv Solomon achialvbv nyitv nvgobv rikubvka vji vbi gvnam vka so apung vdwgv kaapu aingbv rinv gvmato. ");
INSERT INTO tgj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","So si Pwknvyarnv yvvdw mootum gv nvsing nvmwng nga vji koomunv—nvmwng v silu doodu okv aarunyi nyeji kunv, vmvlo rampak svngv. Nw nonua vji gvmu dubv vla ogumvnwngnga mvngma rungredw? Nonugv mvngjwng ngv miang gomwng doodu!” ");
INSERT INTO tgj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Vkvlvgabv mvnwnglo ogugo dvsvdw okv tvngsedw vla alu gv dwkia mvngap dvdvla mvngdwk mabvka. ");
INSERT INTO tgj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Sichingmooku so gv Pwknvyarnvnyi chimanv vdwv aludwkia so ogu mvnwng gv lvgabv mvnggap dvdv dvnv.) No so vdw sum dinchi dunv vla noogv Abu chindu. ");
INSERT INTO tgj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vmabvya Pwknvyarnv gv Karv lvga nga mvnggap yato, okv nw nonua so gv ogumvnwngnga jire.” ");
INSERT INTO tgj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Twngtv manv nonu, busu mabvka, nonugv Abu nonua ninyigv Karv nga jidubv mvngbiudu. ");
INSERT INTO tgj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","No ogugo doodudw hum mvnwngnga pyoktoka okv morko nga heemanv vdwa jitoka. Morko vgianvnv ungko manvlo no atu v orsu laka, okv no gv nyitv a aomooku tolo tvvpv tvka, tolo vdwloka ngoomare, ogulvgavbolo dvcho nvngv tolo bunu gvlo aachi mare, okv bunua taram dvmwk jinv guka kaamare. ");
INSERT INTO tgj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ogolo no gv nyitv nga tvvpv pvdw hoka no gv haapok vka alu loki a doore. ");
INSERT INTO tgj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ogugo aaridw ho lvgabv Kaya laka, rinam lvgabv kaya laka, okv no gv mvdurrupum a baanu tvla doogv laka, ");
INSERT INTO tgj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nyira vdwgv bunugv atu v nyida lokv aari kunvpv vla kaayala doonam aingbv. Vdwlo nw aalaku okv takdin kubolo bunu vjakgobv agi nga ninyigv lvgabv kokda jiriku. ");
INSERT INTO tgj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ho nyira vdwv mvngpu v yvvgv atu v aakur rikulo bunua hula doodubv okv kaayala doodubv kaanam vdwv! Ngo nonua mindu, nw ninyigv jvtv am pilin reku, okv bunua dootung dubv minreku, okv bunuam jilahola rireku. ");
INSERT INTO tgj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Vdwgo mvngpu guku bunu nw bunua kaayala doodubv kaapa kubolo, nw yupra jama nga aaku jvka vmalo koching nyijvka! ");
INSERT INTO tgj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nonu chinsudo naam namgo gv atu v dvcho nvgv cholwk dwa chincho bolo, nw vdwloka dvcho nvnga ninyigv naam a tarkola amumare. ");
INSERT INTO tgj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Okv nonuka, dooya segorung, ogulvgavbolo nyia Kuunyilo ngv nonugv vdwlo dvmin mari gonyika aariku.” ");
INSERT INTO tgj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitar minto, “Ahtu so gv minchisinam si ngonua mindu nvre, vmalo mvnwngnga mindu nvre?” ");
INSERT INTO tgj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ahtu mirwkto, yvv, vbvrikunamv, alvnv okv mvnglaknv nyira ngv? Hv ho angv ninyigv atu hv ninyia naam nyi vdwa rigv dubv jinam, okv nyira kvvbi a bunugv dvse nga dvdw lo dvnam jinam. ");
INSERT INTO tgj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Vdwgo mvngpu vku ho pakbu angv ninyigv atu v vdwlo naam aaku namv ninyia vbvridubv kaapa koku namv! ");
INSERT INTO tgj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Vbvrung, Ngo nonua mindunv, Atu v ho pakbua-nga ninyigv yikungyira nga rigv modubv jire. ");
INSERT INTO tgj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Vbvritola ho pakbu angv nw atu v minsu bolo ninyigv atu moing vngro baapubv aakur nyuku mare vla kvvbi nyira vdwa okv nyimv daka nyilo daka dvngrap laku, dvlaku tvnglaku okv dvkium tvngkium kubolo. ");
INSERT INTO tgj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Vbvrikunamv Atu alugonyi aakur reku vdwlo pakbu gv ninyia dvmin marilo ho gv dwa nw chimpa kuma. Atu v ninyia patungpayung mvriku okv nw gv tvvma nvnga hingkw moreku. ");
INSERT INTO tgj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pakbu ngv yvv atu gv nw a ritokv mvngnam chindunv, vbvritola nw atu v hum ridubv okv agiarap madunv, hum achialvbv svnyakpare ");
INSERT INTO tgj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Vbvritola pakbu ngv yvvdw ninyigv atu gv mvngnam um chima gvrila nw dvngku yadubv riredw hum miang yabv dvngre. Yvv nw kaigo jipvdw hum kaigo koore; Yvv nw kaiyachok go jipvdw um kaiyachok go koyare. ");
INSERT INTO tgj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ngo nyiamooku so vmv rulwk tebv aato okv hv vbv ngoogv mvngkulo riro duku nvgo vla ngo mvngdu! ");
INSERT INTO tgj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngo baptisma naase go doodu, okv hum richima dvdvlo ngo mvngdwk sakdwk bv ridu! ");
INSERT INTO tgj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nonu nga nyiamooku so sarsopoyo alvbv rigv nvnv nga aagvla aapvnv mvngdu nvlare? Ma, sarsopoyo bvma, vbvritola apinain dubv. ");
INSERT INTO tgj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Vjak gvlokv rila vpin akolo nyi angu go doonv apin-ain reku, aom gunv anyia rinying reku okv anyiv aom a rinying reku. ");
INSERT INTO tgj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abu vdwv bunugv kuunyilo vdwa rinying reku okv kuunyilo vdwv bunugv abu vdwa rinying reku; anv vdwv bunugv kuunyijar vdwa rinying reku okv kuunyijar vdwv bunugv anv vdwa rinying reku; ayu vdwv bunugv dungnv vdwa rinying reku okv dungnv vdwv bunugv ayu vdwa rinying reku.” ");
INSERT INTO tgj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisu nyi vdwa mindvto, “Vdwlo nonu haapam a pogga takbv chaadubv kaapa bolo, vjakgobv nonu mindado nyido hotv dvnvgo vla—okv v vbv rido. ");
INSERT INTO tgj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Okv vdwlo mooko takbv doori richa nama nonu himpa bolo, nonu mindu si agu v gurap tvdu vla—okv vbvridu. ");
INSERT INTO tgj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kaakudubvrinv! nonu nyiamooku a okv nyidomooku a kaagvrila doonyi nyinam nyima nga minla gvri; ogubv vbvrinamv, vjakgv dw sum chima dunv?” ");
INSERT INTO tgj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ogulvgabv nonu atubongv alvnvngam mvngchinla kaakw sima dunv? ");
INSERT INTO tgj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nyi gunv nonua kvba japmi sidubv vla nonua mila yila kvba naambv vnggvbolo, nonu um rikin a ninyi alvbv minjupminsi dubv rilaka kvbanaam ha vngsi madvbv. No vbv rima boloka, nw nonua boola yila kvba japji nvgv kaagialo boolwkre, hv bunu nonua pulis vdwgvlo laklwk reku, okv nonua patwklo tumriku. ");
INSERT INTO tgj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngo nonua mindu, nonu morko dvdua dornya ma dvdvlo, hoka nonu dooreku.” ");
INSERT INTO tgj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ho hoka nyi mego dooto bunu Jisu nyi minjito Pilot gv Galili nyi vdwa Pwknvyarnvnyi kumla erin rijila rimu gvrila mvki namgv lvga nga. ");
INSERT INTO tgj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisu bunua mirwkto. “Ogulvgavbolo ho Galilian vdwa vbv mvkito, hum nonu bunua kvvbi Galilian vdwa kaiyabv rimur morya nvnga kaatam dubv ripv vla mvngdunvre? ");
INSERT INTO tgj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma vbvmare, Okv ngo nonua mindu nonu vdwlo nonugv rimur lokv linku mabolo, nonu mvnwngngv bunugv sinam aingbv sire. ");
INSERT INTO tgj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nyi vring gula pinw go Siloam lo aokoko dubv rakchanam naam hv vdwlo darlula darki nama ogubv mvngpv? Um nonu bunua Jerusalem gv nyi mvnwngnga kaiyabv rimur murnv go vla kaatamnam gubv ripv vla mvngdure? ");
INSERT INTO tgj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma vbvmare! Okv ngo nonua mindu, vdwlo nonu nonugv rimur lokv linku maridw nonu mvnwngngv vbvrila sire.” ");
INSERT INTO tgj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Vbvrikunamv Jisu so minchisinam sum bunua minjito: “Ho hoka nyi ako dooto nw ninyigv nayamlo koksitkokrik singnv vkv soto. Nw vngtoku hoka apw kaakarla vbvritola kaapa kuma toku. ");
INSERT INTO tgj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Vkvlvgabv nw ninyigv nayam kaaya nvnga minto, ‘Kaatoka, so gv koksitkokrik singnv so ngo apw lvgabv anying nyinghom go kaalwkto, okv ngo ogu goka kaapa ma. Um tvnglwkto! vlam oguaingbv kvdw lo doomu dubv?’ ");
INSERT INTO tgj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Vbvritola nayam kaayanv angv mirwkto, atu, anying goda akinbv vlam doomuto; ngo vlam kvdwa dugo gvrila naya-naka lo lwkbum kwnvpv. ");
INSERT INTO tgj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aarinv anying tolo singnv ngv apw charlin bolo, v alvyachok namv; vbv maloka, no um tvngnga toku mabv.” ");
INSERT INTO tgj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jius Doonualu golo Jisu Jius kumkunaamlo japjila dooto. ");
INSERT INTO tgj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hoka nyimv nvgo nyingring gola nyingpinw go alvmanv dow hv ninyia lvvmala doodubv mvkunam go dooto; nw pookung toku okv achukguka gudung nyuku matoku. ");
INSERT INTO tgj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Vdwlo Jisu nyimv nvnga kaapa tokudw nw nyimv nvnga goklinto, “Nyimv angv, no noogv lvvma lokv adu dukunv!” ");
INSERT INTO tgj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nw ninyigv laak v nyimv nvngv gv aolo lakpvto, okv vjakgobv nyimv nvngv adinabia dakunv gudung toku okv Pwknvyarnvnyi hartv toku. ");
INSERT INTO tgj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jius kumkunaam gv rigvdogvnv haachi toku Jisunyi doonualu lo mvpu nvgobv vla, vkvlvgabv nw gamtv rungbv gokla, okv nyi vdwa minto, “Ngonu kudungkua ridubv alu lookv go doodunv; vkvlvgabv ho alulo aatoka okv mvpu kotoka, vbvritola doonualu loma!” ");
INSERT INTO tgj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ahtu ninyia mirwkto, “Kaakudubvrinv nonu! Nonu gv lokv akonv ninyigv svv vmalo siak ka Jius Doonualu lo oso nga pakyak laila isi tvngmu dubv naam lokv vnglin madunvre? ");
INSERT INTO tgj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vjak so si Abraham gv husi v ninyia Uyu nyingring gola nyingpinw go tumla vvpvpv; sum Jius Doonualu lo limu madu kubvri?” ");
INSERT INTO tgj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ninyigv mirwksinamv nyirunv vdwa hinying simudubv minto, nyi vdwv ninyigv lamrwpadubv mvnam rinam lokv himpu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisu tvvkato, “Pwknvyarnv gv Karv ngv oguaingbv ridunv? Um ngo ogu-am lvkobv mintak nvdubv? ");
INSERT INTO tgj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hv svbv ridu. Nyi ako yingmw naala okv ninyigv rongolo paklwkdo. Agar hv garlinla okv singnv gubv ritoku, okv pvta vdwv ho aala bunugv asup a vkvgv hakbv vdwlo suplwk toku.” ");
INSERT INTO tgj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisu lvkodv minto, “Pwknvyarnv gv Karv nga ngo ogu gonyi lvkobv mintak nvdubv? ");
INSERT INTO tgj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hv svbv ridu. Nyimv nvgonv vpap mego naala okv hum kainv pvchwng gulo vtwng nga mvyomvchila nyakma dvdvlobv vvpvnam aing bv rido.” ");
INSERT INTO tgj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisu banggu vdwlo okv nampum vdwlo vnggoto nyi vdwa japgo jila okv ninyigv lamtv nga Jerusalem takbv vngdula. ");
INSERT INTO tgj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nyi gonv ninyi tvkato, “Tamsarnv, nyi miang gonv mvngchik ringnam a paamwng redw?” Jisu bunua mirwkto, ");
INSERT INTO tgj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“No vdwgo rilapvdw agi takching kolo vngpit dvbv rilaka; ogulvgavbolo nyi mvnwngngv hoka vngpit rungdubv rikwre vbvritola rinyu mare. ");
INSERT INTO tgj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Naam atu v gudung reku okv agi a koktum reku; vbvrikubolo vdwlo no agumlo daktola okv agi a takdin reku okv minre, ‘Ngonugv lvgabv agi a kokda jilabv, Ahtu!’ nw nonua mirwksire, ‘Nonu ogolokv aapvnv ngo chima!’ ");
INSERT INTO tgj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Vbvrikunamv nonu mirwksire, ‘Ngonu nam lvkobv dvbamto okv tvngbumto; no ngonugv banggu lo tamsarto!’ ");
INSERT INTO tgj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Vbvritola nw lvkodv mindvre, ‘Ngo nonua chimakv nonu ogo lokv aapvnv. Ngoogv lokv vngroto, nonu alvmanv nyi vdwv!’ ");
INSERT INTO tgj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nonu Abraham, Isaak, okv Jakob okv nyijwk mvnwngnga Pwknvyarnv gv Karv lo doodubv kaapa rikunyi, hoka nonua orlinla ora rikulo, nonu kapla, hijung nga kotwkkrwkla rire! ");
INSERT INTO tgj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nyi vdwv doonyi chaagu lokv okv aagia lokv, yordum okv yorko lokv aakumla Pwknvyarnv gv Karv lo dootung tokula dvpam pamminre. ");
INSERT INTO tgj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Vbvrikunamv yvv bunu vjak koching dunv vngcho reku okv vjak yvvbunudw vngcho dunv kochingreku.” ");
INSERT INTO tgj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ho gv dw akin hoka Parisis mego Jisu gvlo aato okv ninyia minto, “No sokv linro lakuka okv dooku kvvbiv gulo vngnyikuka, ogulvgavbolo Herod nam mvki nvpv mvngdu.” ");
INSERT INTO tgj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisu bunua mirwkto, “Vngnyila haaringpaksar a minpa tvka: ‘Ngo uyuvram vdwa charkakdu okv silu okv aaru kaatamre mvpuripu nama, okv loum nvnvlo ngo ngoogv kudungkua nga rinya reku.’ ");
INSERT INTO tgj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ogubvrijeka ngo silu ngoogv lamtvlo vngrung rikunv, aarunyi, okv logo nvnga so si nyijwk ka kvvbi mookulo mvki dubv riku mare Jerusalem mvngchiklo. ");
INSERT INTO tgj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem! nonu nyijwk vdwa mvki do, nonu gvlo Pwnvyarnvgv gindungpingko vngmunama nonu vlwng kungpv! Vdwnvgo ngo noogv nyi vdwa laak kv lakyum nwngdu kubv, roknv gv ruu vdwa laap lokv lapyumnam aingbv, vbvritola nonu nga vbv rimuma! ");
INSERT INTO tgj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Okv vkvlvgabv nonugv Pwknvyarnvnaam arochoko reku. Ngo nonua jvjvbv milv jidunv nonu nga vdwloka kaapa mare vdwlo nonu ‘Pwknvyarnv aya laka yvvdw Ahtu gv amin lo aanv nga vla mindw v aama dvdvlo.’” ");
INSERT INTO tgj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Doonu alu golo Jisu Parisis nyi rigvnvgv akogv naam lo achin dvbv aato; okv nyi vdwv Jisunyi orchok mvla kaayato. ");
INSERT INTO tgj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nyi ako lvpa laak bingla lvvma nvgo Jisu gvlo aato, ");
INSERT INTO tgj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Okv Jisu pvbv tamsarnv vdwa okv Parisis vdwa tvkato, “Ngonugv Pvbv lo doonu alu lo lvvma nvnga mvpu dubv minpvri?” ");
INSERT INTO tgj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Vbvritola bunu ogugoka mimato. Jisu nyi anga naatoku, ninyia mvpu toku, okv ninyia vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Vbvrikunamv Nw bunua mintoku, “Nonugv lokv akonv kuunyilo go dooto vmalo svvhvpu angv doonu alu lo ungrung golo holwk kubolo, hum no doonu alu lo dorlin maredw?” ");
INSERT INTO tgj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Vbvritola bunu so gv lvga nga ogugoka mirwk nyula mato. ");
INSERT INTO tgj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisu kaapato nyen goknam vdwv dooku alvyachoknv vdwa gakdubv, vkvlvgabv nw so minchisinam sum bunua minjito: ");
INSERT INTO tgj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Vdwlo nonua nyi gonv nyida dvpam lo gokbolo, alvyachoknv dooku lo doomabvka, vbvrinam goka doore nam kaiyanv nyi goka gokpv kuso, ");
INSERT INTO tgj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","okv nonyi gv atu, nonyia goknv, v aala kula minre, ‘Soogv dooku sam ninyia doomu tvka.’ Vbvrikunamv nonu hinying reku okv dooku alv makulo doodubv rireku. ");
INSERT INTO tgj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ho mabvdv, vdwlo nonua gokpv kudw, vnglaka okv koching yachok dooku lo doolaka, vkvlvgabv nonua goknv atu v nonu gvlo aala minre, ‘Ngoogv ajin a, dooku alvku so, chaatoka.’ Svbvrinam si nonua dvbvnyi goknam vdwgv kaagialo mvngdv modu. ");
INSERT INTO tgj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yvv mvnwng v atu v kainvgobv mvngsu dvdw hum miang more okv yvv mvnwngngv atu v miang nvgobv mvngsu dvdw hum kai dubv mvre.” ");
INSERT INTO tgj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Vbvrikunamv Jisu ninyia goknv atua minto, “Vdwlo no alu dvnam vmalo arium dvnam go jirinyi, no noogv ajin a vmalo noogv abwngboru a vmalo noogv agungasa nga vmalo noogv namrwk doobam nyitvnv vdwa gokmabvka bunu nonua gokrwk sireku, okv vbvrila noogv ogu rinam dvdvgv rijo nga no paaro riku. ");
INSERT INTO tgj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Vdwlo nonu dvpam go dvmu tvdudw, heemanv vdwa, pookungnv vdwa, lvpiknv vdwa, okv nyikchingnv vdwa goklaka; ");
INSERT INTO tgj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Okv no aya choknam gubv rire, ogulvgavbolo bunu nonua rirwk sinyu kumare. Pwknvyarnv nonua rirwk jireku vdwlo alvnv nyi vdwgv sinam lokv turkur rikunyi.” ");
INSERT INTO tgj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Vdwlo tvbul doodungnv nyi akonv hum tvvpa tokudw nw Jisunyi minto, “Vdwgo mvngpu v yvvdw Pwknvyarnv gv Karv lo dvpam lo doolwknv!” ");
INSERT INTO tgj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisu ninyia minto, “Ho hoka nyi ako dooto nw kainv dvpam go dvmu dubv nyi achialvbv gokto. ");
INSERT INTO tgj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Vdwlo dvpam dw hv aato kudw, nw ninyigv pakbua kanamla vngmuto ninyigv nyen vdwa minpa modubv vla, ‘Ogu mvnwngngv mvpvripv pvku, aakum tokuka!’ ");
INSERT INTO tgj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Vbvritola bunu mvnwngngv mvngnga labv vla minrap nyatoku. Atuk gv nyi angv pakbua minto, ‘Vjakpi rongo go rvvtobv okv um vngla kaadu bv ripv; ayala ngoogv minam sum tvji labv.’ ");
INSERT INTO tgj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nyi akonv minto, ‘Ngo hvpu dorring go rvvtobv okv ngo hum rikala lamtvlo lingv segorung; ayala ngoogv minam sum tvji rungla bv.’ ");
INSERT INTO tgj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nyi akonv minto, ‘Ngo vjakpi nyimv naada pvnv, ho lvga lo ngo aala nyuma.’ ");
INSERT INTO tgj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pakbu angv vngkur toku okv ogumvnwngnga ninyigv Atua minpa jitoku. Atu angv achialvbv hachiv kvchakbvriak toku okv ninyigv pakbu nga mintoku, ‘Baapu bv banggu arwnglo okv banggu gv chenyung lo vngnyika, okv heemanv vdwa, pookungnv vdwa, nyikchingnv vdwa, okv lvpiknv vdwa aakur gvteka. ");
INSERT INTO tgj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pakbu angv baapubv minto, no gv gamki nama rito kubv, tamsarnv, vbvritola karchung ngv nyi megonvgv lvgabv doodvpv.’ ");
INSERT INTO tgj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Vkvlvgabv Atu v pakbua minto, ‘mookugv lamtvbv vnglin nyika okv nyi vdwa arwng lo aadu bv mvtoka, vkvlvgabv ngoogv naam lo yarbing dukubv. ");
INSERT INTO tgj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngo nonu mvnwngnga mindunv so nyi tamnam vdw sokv yvvka ngoogv arium dvnam a dvpa kumare!’” ");
INSERT INTO tgj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lvko nyipam kainvgo Jisunyi lvkobv vngming gvrilo, nw dakrwkla bunua minto, ");
INSERT INTO tgj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yvvdw ngoogvlo aadunv ngoogv lvbwlaksu gubv rinyumare vdwlo nw ninyigv Abu okv ninyigv anv, ninyigv nywng okv ninyigv kuu vdwa, ninyigv achiboru okv ninyigv anyibormv, okv nw atubongv alvrungbv paknama lvyabv nga pakma dvdvlo. ");
INSERT INTO tgj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yvvdw atu ninyigv daapo nga bakma dunv okv nga vngming gvma dunv hv ngoogv lvbwlaksu gubv rinyu mare. ");
INSERT INTO tgj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nonu gvlokv akonv naam aokolo nvgo mvdubv rungbolo, nw atukchobv doopv tvla okv vkamgu arv ngv ritv rinv bri nw um morko v um rinya nvnv go doodudw kaaka chori. ");
INSERT INTO tgj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nw dooku mabolo, naam a mvrapro kochingbv nw vdwloka mvnya nyuku mare; okv ogugo ripvdw nyi kaanv mvnwngngv ninyia nyarji reku. ");
INSERT INTO tgj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bunu minreku, ‘So nyi si naam a mvdubv mvrap toku vbvritola mvnya nyukuma.’ ");
INSERT INTO tgj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Dvbv gonv hejar vring nyiga go vnglingvla dvbv hejar chamnyi doonvgo mvmi sidubv riku bolo, nw atokchobv doopv tvla japka riku dvbv nga mvmi sinyu redw ma mvmi sinyu maridw vla. ");
INSERT INTO tgj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nw choopu kuma bolo, nw gindungpingko go vngmure dvbv anga kaarwk sidu kubv okv sarsopoyo lvgabv tvvka siya dukubv ninyigv adu lo vngdungla vngngo lvpa rikulo.” ");
INSERT INTO tgj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Ho apiabv,” Jisu minyabv minto, “Nonu lokv yvvka ngoogv lvbwlaksu gobv rinyu mare vdwlo nonuno nonugv ogumvnwngnga kayu maredw.” ");
INSERT INTO tgj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Alu v alv nvgo, vbvritola si tinam a ngemu kubolo, hum lvkodv tidukubv mvjiku lamtv kaakuma. ");
INSERT INTO tgj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","So si kvdw gv lvgabv alv kuma vmalo eriung gvbvka alvkuma; hum adulo ora duku. Tvvtoka, vbvrikunamv, nonuno nyarung gvdubolo!” ");
INSERT INTO tgj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Alu golo lampu naakumyanv okv toakunam vdwv achialvgo Jisu gvlo tvvdubv aatoku, ");
INSERT INTO tgj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisis vdwvla Pvbv tamsarnv vdwv minsiminpit rapto, “So nyi si toa kunam vdwa naarwk sidu okv bunua lvkobvka dvbam tvdu!” ");
INSERT INTO tgj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Vkvlvgabv Jisu bunua so minchisinam sum mintam toku: ");
INSERT INTO tgj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Vkv aingbv nonugv lokv akonv svlar ngv lwnggo doore okv bunugv lokv akonyi ngemure-nw ogu rireku? Nw chamkia gula kia nga nvmwnglo kayupila okv ngenv akin a kaapama dvdvlo makar reku. ");
INSERT INTO tgj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Vdwlo nw mapa rikudw nw achialvbv mvngpu laku hum ninyigv gorbwnglo vvpv toku. ");
INSERT INTO tgj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Okv um naam lo bakkor lwktoku. Vbvrikunamv nw ninyigv ajin vdwa okv namrwk vdwa gokkum tokula bunua mintoku, ‘Ngo achialvbv mvngpu duku ngo ngoogv svlar ngenv anga paakunamv. Klvi ngonu naayap lakuju!’ ");
INSERT INTO tgj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ho apiabv, ngo nonua mindunv, nyidomooku tolo hum kaiyabv mvngpure rimurnv nyi go mvngdin kubolo chamkia gula kia yvv mvngdin kusegu kaakumanv mamsenga.” ");
INSERT INTO tgj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Vmalo nyimv nvgo ain lokdwng charring go doonv chargunyi ngemu toku—nw ogu ripvku? Nw mvdurrupum a baanu toku, ninyigv naam a pakak toku, okv kaapama dvdvlobv um alvyaungbv kaakar toku. ");
INSERT INTO tgj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Vdwlo nw hum kaapa tokudw, nw ninyigv ajin vdwa okv namrwk ajin vdwa gokdum sitoku, okv bunua mintoku, ‘Ngo achialvbv mvngpu dukunv ngo ngoogv ngemu kunam lokdwng nga paapvku. Klvi ngonu naayap lakuju!’ ");
INSERT INTO tgj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngo nonua mindu, ho apiabv rimurnv nyi gunv mvngdin kubolo vkvgv aolo Pwknvyarnv gv gindungpingko vdwv achialvbv mvngpu yadunv.” ");
INSERT INTO tgj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisu mimbwngla minto, “Ho hoka nyi akonv nw kuunyilo anyigo dooto. ");
INSERT INTO tgj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Boruya angv ninyia minto, ‘Abu, vjak yikungyira ngo gvnga ngam jilabv,’ Vkvlvgabv abu hv yikungyira vdwa kuunyilo anyi gv pingkolo orpin sitoku. ");
INSERT INTO tgj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Lonyi loum kochinglo boruya angv ninyigv yikungyira vdwa pyoktoku okv morko nga gvtokula naam a vngyu toku. Nw adu koko mookulo vngtoku, hoka nw rikunamv ninyigv morko nga mvnam mvsubv mva toku. ");
INSERT INTO tgj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nw vdwgo gvku bvdw hum mvnwngnga mva toku. Vbvrikunamv dvmayarwng go ho mooku hoka vngtoku, okv nw hoka oguka kaaku mabv ramkar toku. ");
INSERT INTO tgj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Vkvlvgabv nw ho mookugv nyi gonvgv lvgabv kudungkua riji dukubv vngtoku, hv ninyia ninyigv rongo adukolo lo vrik kaaria modubv vnglin motoku. ");
INSERT INTO tgj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nw ninyigv dvse a vrik gv dvnam dvku lokv dvsu tvnvpv mvngto, vbvritola yvvka ninyia dvnam jinv kaama toku. ");
INSERT INTO tgj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Anyung anya nga ninyigv haapok lo mvngchin raptoku okv mintoku, ‘Ngo Abu gv nyi riria modubv goknam mvnwng hvka bunu dvnam a dvlv kumabv dvmin duku, okv ngo soka kano gvbv sakap tvya dukunv! ");
INSERT INTO tgj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngo gudung reku okv Abu gvlo vngreku, okv minreku, Abu, ngo Pwknvyarnv nyila okv nam la rinyingla rimur tokubv. ");
INSERT INTO tgj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngo noogv kuunyilo ngv vla mindubv riya kuma; no nga noogv riria nvbv goknam nyi ako bv mvngla kubvka,’ ");
INSERT INTO tgj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Vkvlvgabv nw gudung toku okv ninyigv Abu gvlo vla vngkur raptoku. “Nw vjakgobv naam vngchi sengv lamtv ngv adudvto hoka ninyigv Abu hv ninyia kaapa toku; nw haapok v hau toku, okv nw joktoku, okv ninyigv laak hv ninyigv kuunyilo nga jarbwng toku, okv ninyia moopupdvtak toku. ");
INSERT INTO tgj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kuunyilo ngv mintoku, ‘Abu, ngo Pwknvyarnv nyila nam la rinyingla rimur tokubv. Ngo noogv kuunyilo ngv vla mindubv riya kuma.’ ");
INSERT INTO tgj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Vbvritola Abu hv ninyigv pakbu vdwa goktoku. ‘Baapubv!’ nw minto. ‘Jvtvlaklwk alvyachok nvnga bvnglwkto okv ninyia pilwkto. Ninyigv lakchinglo lakchup go pilwkto okv ninyigv lvpa lo lvsup goka. ");
INSERT INTO tgj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Vbvrikunamv vngnyika okv svbv bakboknv akonyi paala hum mvki tvka, okv klvi ngonu naayapla dvpam go pamla kuju! ");
INSERT INTO tgj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ngoogv kuunyilo angv si sirokunv ngv, vbvritola vjak nw turpvku; nw ngooro kunvngv, vbvritola vjak ninyia paapv kunv.’ Okv vkvlvgabv dvpam ha pamrap toku.” ");
INSERT INTO tgj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Vbvrire hoka kuunyilo achi yangv agum rongolo rito. Ninyigv lamtvlo vngkur rikulo, vdwlo naam aachidvlv bv riri hoka, nw giomin okv soomin namgv sidu a tvvpa toku. ");
INSERT INTO tgj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Vkvlvgabv nw pakbu ako goklwkla okv ninyia tvvkato, ‘Ogugo ridung dunvla?’ ");
INSERT INTO tgj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Noogv boruv naam aakur pvku,’ pakbuv mirwkto, ‘Okv noogv Abu svbv babok yachok nvgonyi paki pvkunv, ogulvgavbolo nw ninyia ayak alvdvkubv paakunam lvgabv.’ ");
INSERT INTO tgj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Achi yangv achialvbv kvchakbriak laila nw naam arwnglo aamato; vkvlvgabv ninyigv Abu agumlo linto okv ninyia arwng aatokv vla kodwkkrwkla minto. ");
INSERT INTO tgj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Vbvritola nw ninyigv Abunyi mirwksito, ‘Kaatoka, anying mvnwnglo ngo nyira jvbv noogv lvgabv kudungkua nga rijito, okv ngo noogv minam a vdwloka tvvmabv rinam kaama. No nga ogugo jipv? Ngoogv ajin vdwaka lvkobv dvpam dvgv laka vla yabin akoka ka jinam kaama! ");
INSERT INTO tgj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Vbvritola noogv kuunyilo angv si noogv yikungyira mvnwngnga randi vdwlo mva nvmin kunvngv, okv vdwlo nw naam aakur kunamv no ninyigv lvgabv svbv bakbok nvgonyi paki jiminla!’ ");
INSERT INTO tgj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Abu v mirwkto, ‘Ngoogv kuunyilo nga,’ ‘no ngam alu loki a lvkobv doobwng kunvngv, okv ngo ogugo doopv kudw mvnwngngv nokvku. ");
INSERT INTO tgj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Vbvritola ngonuv naayap segorung okv mvngpu segorung, ogulvgavbolo no gv boruv siro kunvngv, vbvritola vjak nw turpvku; nw ngero toku, vbvritola vjak ninyia paapvku.’” ");
INSERT INTO tgj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisu ninyigv lvbwlaksu vdwa minto, “Ho hoka nyitvnv nyi ako dooto nw pakbu go dooto hv ninyigv yikungyira nga kaayataya nvgo. Nyitvnv nyi anga ninyigv ogu rungyanv angv ninyigv morko nga mva dukv vla mintamto, ");
INSERT INTO tgj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","vkvlvgabv nw rungya nvnga arwnglo goklwkto okv minto, ‘Ngo noogv lvkwng nga tvvdunv si ogu gokula? No ngoogv yikungyira nga kaayataya nama vdw godw ogumvnwngnga ngam kaatam lakubv, ogulvgavbolo no vdwloka ngoogv rungyapayanam gubv rinyu kumare.’ ");
INSERT INTO tgj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pakbu angv nw atu hv minsuto, ‘Ngoogv atu nga ngoogv nokori loka naalin tvduku. Ngo ogu rila kuse gubvri? Ngo dvnam lvgabv rongo ridubv gwlwk doyama, okv giago karse ngaaka yinying yapv. ");
INSERT INTO tgj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Vjak ngo chinduku ngo ogugo risedw! Vbvrikunamv vdwlo ngo nokori lokv linre kudw, ngo ajin jinre bunu nga bunugv naam lo alvbv aamure.’ ");
INSERT INTO tgj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Vkvlvgabv nw ninyigv atu gvlo dvdu doonv nyi vdwa goklwk toku. Nw atokchogv anga tvvkato, ‘No ngo atu gvlo vkamgu narpvnv?’ ");
INSERT INTO tgj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nw mirwkto, ‘Olib tvli vkv pumpa lvngo narto,’ ‘Siinv noogv jise ngv,’ rungyanv angv ninyia minto, ‘dootungto okv chamngu go lvkgapto.’ ");
INSERT INTO tgj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Vbvrikunamv nw kvvbi akonyi tvkato, ‘Okv no—vdwgo narpvnv?’ Nw mirwkto, ‘Giu vkv tagiam munv hejar go,’ ‘siinv noogv jise ngv,’ rungyanv ninyia minto; ‘lwngpinv go lvkgapto.’ ");
INSERT INTO tgj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pakbu mvvlaknv gv Atu hv ninyia vbv rungkup runglik la ridanam lvgabv ninyia hartv toku; ogulvgavbolo nyiamooku so gv nyi vdwv achialvbv bunu rungkup runglik la lounglo rinv nyi vdwa kaiyabv ridu.” ");
INSERT INTO tgj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Okv Jisu mimbwngla minto, “Okv vkvlvgabv ngo nonua mindunv: Nonuno atuv nyiamooku so gv yikungyira nga lvkobv ajin jinlaka, vkvlvgabv um vdwlo si topu rikudw, nonua simabv doobwng jiku naam lo alvbv aamu riku. ");
INSERT INTO tgj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yvvdw miangnv yikungyira nga alvbv mvnging dubv ridunv hv kainv yikungyira loka achialvbv kaiyabv mvnging dubv ridunv, okv yvvbunudw miangnv yikungyira lo jwkjwkvrwk bv mvngging dubv rima dunv v kainv yikungyira loka jwkjwkvrwkbv mvngging dubv rima dunv. ");
INSERT INTO tgj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hv bolo, vbvrikunamv, nonu nyiamooku so gv yikungyira nga alvbv mvnging dubv rinyu mabolo oguaingbv jvjvnv yikungyira nga mvnging dubv rinyure? ");
INSERT INTO tgj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nonu nyi kvvbi gvbvrinv yikungyira nga mvnging dubv riji mabolo, yvvla no gvbvrinv yikungyira nga nam jijinv? ");
INSERT INTO tgj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Pakbuv yvvka atu anyi gv nyirabv rinyu mare; nw akonyi pakre okv akonyi kaanwng mare; nw akonvgv minam a tvvre okv akonvgv nga tvvmare. No Pwknvyarnv nyila morko nga lvkobv rijivngji nyulamare.” ");
INSERT INTO tgj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Vdwlo Parisis vdwv so mvnwng sum tvvtokudw, bunu Jisunyi nyarjito, ogulvgavbolo bunu morko nga mvngbiuto. ");
INSERT INTO tgj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisu bunua minto, “Nonuno atubongv nyi vdwgv kaagialo jvjv nvgobv minsunv vbvritola Pwknvyarnv nonugv haapok ha chindu, yikungyira vdwv nyi gv lvgabv kainv arv doonv gubv rinv ngv, Pwknvyarnv gvlo ogu arv ka kaama.” ");
INSERT INTO tgj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses gv Pvbv okv nyijwk vdwgv lvknam vdwv Jon Baptist gv dw lobv ribwngto; okv ho koching nga Pwknvyarnv gv Karv gv lvkwng Alvnv Yunying nga mintam raptoku, nyi mvnwngngv ho Karv lo aadu bv gwnglilala nyadu. ");
INSERT INTO tgj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pvbv gv gaam achukguka minggap nama ria jemam svnga nyido gvla kvdw gv nyitv namv nyepu yare.” ");
INSERT INTO tgj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Yvv nyi akonv atugv nywng nga toa tokula ako kvvbi nyimvmvvga go nywng mvku bolo hv yoomurnv; okv toanam nyimvmvvga anga yvv nywng mvdunv hvvka yoomurnv.” ");
INSERT INTO tgj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ho hoka nyi nyitvnv ako dooto nw kainv arv doonv vjia kooto okv achialvbv lokia himpukain la svngminto. ");
INSERT INTO tgj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ho hoka heemanv nyi ako dooto aminv Lajaras, ungvtarv ngv rara nvgo, hum nyitv nyi gv naam agi lo vvpvkinamgo, ");
INSERT INTO tgj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","nyitv nyi gv dvkulo dvala hoolin nama dvpa yare vla mvngnv go. Iki vka aala ninyigv ungngv nga dvriak riakbwngto.” ");
INSERT INTO tgj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Heemanv nyi angv sitoku okv nyidogindung vdwv ninyia gvvtoku Abrahamnyi lvkobv nyidomooku gv dvpam lo doomuto. Nyitv nyi v sitoku okv nyibung riitoku, ");
INSERT INTO tgj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","okv Uyumooku bolo nw achialvbv hirukaya toku, nw kaadung kunamv adukoyo lo Abraham okv ninyigv lvkobv Lajarasnyi doodubv kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Vkvlvgabv nw goklin toku, ‘Abu Abraham! nga aya labvka, okv Lajarasnyi ninyigv lakching nga isi lo chibok mogvrila achok godaka ngoogv riu sum chapke molabvka, ogulvgavbolo ngo si vmv arwng si achialvbv hirukaya dvkukv!’ ");
INSERT INTO tgj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Vbvritola Abraham minto, ‘Mvngpa tokuka, ngoogv kuunyilo nga, noogv turla singrilo nam alvnv mvnwngnga jimiro, Lajaras hoka alvmanv mvnwngnga paariato. Vbvritola vjak nw soka atuv himpu pumin dukunv, no hoka hirukaya rikulo. ");
INSERT INTO tgj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","So ogu mvnwng sum kayu tvla, no gvla ngoogv pingko si kairungnv kobung go doodunv, vkvlvgabv yvvdw sokv noogv hoka vngrap dubv ritv nvngv vbv rinyu madunv, vmajeka yvvka noogv hokvkongv ngonugv so linyu madunv.’ ");
INSERT INTO tgj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nyitvnv nyi angv minto, ‘Vbvrikunamv ngo nam kodwkkrwkla koola mindunv, Abu Abraham, Lajarasnyi ngoogv abu gv naam lo vngmu jilabv, ");
INSERT INTO tgj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","v ngo boru angu go doopvnv. Ninyia vngmula okv bunua gamrw motoka, bunuka so hirukayaku so aama dubv.’ ");
INSERT INTO tgj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham minto, ‘Noogv boru vdwv Mosesnyi okv nyijwk vdwa doogv sudu bunua gamrw nvngv; noogv boru vdwv bunugv ogugo minam a tvvrung svngv.’ ");
INSERT INTO tgj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nyitvnv nyi hv mirwksito, ‘Hv pwngmare, Abu Abraham! Vbvritola siro kunv nyi gonv turkur laku okv bunua minbolo, vbvrikubolo bunu bunugv rimur lokv linreku.’ ");
INSERT INTO tgj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Vbvritola Abraham minto, ‘Bunu Moses nyila Nyijwk vdwa tvvmabolo, bunua mintap nyulamare sikunv akonv turkur kujvka.’” ");
INSERT INTO tgj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisu ninyigv lvbwlaksu vdwa minto, nyi vdwa rimur mobv rinv ngv ho lokia doore! vbvritola yvvdw bunua rimu dunv hv mvngru gubv rire! ");
INSERT INTO tgj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ho nyi anga vlwng pwtv nvgo lvngpolo paklwk tvvla svlv lo orlwk namv nw gv lvgabv alvyare so gv vmi anga rimur modubv ritv svnga. ");
INSERT INTO tgj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Vkvlvgabv hingto laka no ogugo ridudw! “Noogv achiboru vdwv rimur dubolo, ninyia yamtoka, okv nw mvngdin dukubolo, ninyia mvngnga jilaka. ");
INSERT INTO tgj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nw alua kanw go nam rinyingla rimur dubolo, okv riri gv dwkia no gvlo aala, ‘Ngo mvngdin dukunv vku bolo, no ninyia mvngnga jirung laka.’” ");
INSERT INTO tgj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nyitampingko vdwv Jisunyi minto, “Ngonugv mvngjwng nga kai molabv.” ");
INSERT INTO tgj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jisu mirwkto, “Nonu gvlo mvngjwng ngv yingmw chargobv doodu bolo, nonu so malberi singnv sum minyure, ‘No atu hv kolv lokv puchok linsula okv svmasa lo atu hv lvvlwk suto vla minbolo hv noogv minam a tvjire. ");
INSERT INTO tgj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Minchisinam go nonu gvlo akonv pakbu doodu hv rongo padungdo vmalo svlar vdwa kaaya riadungdo. Vdwlo nw rongo lokv aari kunyi, um no ninyia baapubv okv dvnam a dvto vla minridw? ");
INSERT INTO tgj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Vbvrirung mare! vmabvya, no ninyia minre, ‘Ngoogv dvnya dvse nga mvpvto, vbvrikunamv no noogv vji a kotoka okv ngoogv dvrilo okv tvngrilo no doya tvka; ho kochingbv no noogv dvse a dvla duku.’ ");
INSERT INTO tgj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Minam a tvvla pakbu angv umbonyikv go panyu mapvri, panyu pvri? ");
INSERT INTO tgj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Vbvdvdvbv so si nonu gvloka doolwk laka; nonugv rise a vdwlo nonu ripv kudw, minlaka, ‘Ngonu pakbu bvtwkbv rimwngnv; ngonu ngonugv rise a rimwng pvnv.’” ");
INSERT INTO tgj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisunyi Jerusalem bv vngrilo nw Samaria gvla Galili gv doorwsi pingkolo vngpitla vngto. ");
INSERT INTO tgj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nw nampum arwnglo vngdungrilo ho arwnam apin yaritla lvvmanv nyi vring go paami suto, bunu adulo dakto ");
INSERT INTO tgj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","okv goktoku, “Jisu! Tamsarnv! ngonua aya mvngpa labv!” ");
INSERT INTO tgj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisu bunua kaapa toku okv bunua minto, “Vngnyika okv nyibu vdwa nonua jwngkadaka kolaka.” Lamtvlo bunua darwk dukubv mvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Vdwlo bunugv lokv akonv poyapvku vla himpa tokudw, nw vngkur toku, Pwknvyarnvnyi gamtv rungbv hartv toku. ");
INSERT INTO tgj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nw Jisu gv lvpa lvkwng gv kvdw lo atu v gipv toku okv ninyia umbonyi vtoku. Nyi angv Samaritan go. ");
INSERT INTO tgj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisu minto, “Nyi mvpu namv nyidum vring gui laka; kvvbi kia gunv ogolo? ");
INSERT INTO tgj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ogubv so nyebunyi angv si Pwknvyarnvnyi umbonyi vla mimbv aadunv?” ");
INSERT INTO tgj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Okv Jisu ninyia minto, “Gudungto okv vngnyika; noogv mvngjwng lokv nam alv mopvku.” ");
INSERT INTO tgj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisis mego Jisunyi tvkato Pwknvyarnv gv Karv ngv vdwlo aatv dunv. Ninyigv mirwksinamv, “Pwknvyarnv gv Karv ngv vbvrung vla kaadubv rimare. ");
INSERT INTO tgj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yvv akonvka minla mare, ‘kaato si kunv!’ vmalo, ‘v kunv!’; ogulvgavbolo Pwknvyarnv gv Karv ngv no gvlo doodu.” ");
INSERT INTO tgj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Vbvrikunamv Jisu lvbwlaksu vdwa minto, “Dw gv aariku vdwlo nonu Nyia Kuunyilo gv alu logonyi kaanwngre, vbvritola um nonu kaapa kumare. ");
INSERT INTO tgj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ho hoka nyi vdwv nonua minre ‘tolobv kaatoka!’ vmalo ‘so soka kaatoka!’ vbvritola vnglinla um kaakar mabvka. ");
INSERT INTO tgj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dooriak gv nyidomooku lo riaklinla okv chegunv lokv chegunvbv loung monam aingbv rire nyia kuunyilo ninyigv alu hv. ");
INSERT INTO tgj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Vbvritola atukchobv nw achialvbv hinching chingchore okv silugv nyi vdwgv toanam gubv rire. ");
INSERT INTO tgj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noah gv riri ho gv dw aingbv Nyia Kuunyilo gv dw hvka Vbvrire. ");
INSERT INTO tgj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nyi mvnwngngv dvbwngla okv tvngbwng nyala rinyato, nyimv okv nyiga vdwv nywng nyilubv rimi sinyato, Noah gv svpw arwnglo aalwk rikulo okv isi hv tvvlula bunu mvnwngnga tvvrumla tvki toku. ");
INSERT INTO tgj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ho alu hv Lot gv ririlo gv alu aing bv rire. Nyi mvnwngngv dvbwngla okv tvngbwng nyato, korvpachu rvvmi sinyato okv pyokmi sinyato, singnv lvvdung nyato okv naam mvdung nyato. ");
INSERT INTO tgj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot gv Sodom a vngyuri alu lo, vmv okv vmv gununvnv ngv nyidomooku tolo gvngv holula nyi mvnwngnga guki kingam toku. ");
INSERT INTO tgj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nyia Kuunyilo gv daklwk rikulo ho vkv aingbv rireku.” ");
INSERT INTO tgj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ho gv alu lo nyi gonv ninyigv namwng mwnglo lo rinv naam arwng aala ninyi gvbv rinam yikungyira mvnwngnga naadubv mvngrung mabvka; vkv aingbv nyi gonv yvv agum rongolo rinv naam aakur kuyoka. ");
INSERT INTO tgj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot gv nywng nga mvngpa toka! ");
INSERT INTO tgj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yvvdw nyi atugv singdung nga ringdubv mvngdunv ngoore; yvvdw ninyigv singdung nga ngoomu dunv v hum ringyare. ");
INSERT INTO tgj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ho gv ayulo, ngo nonua mindu, ho hoka nyi anyigo gadw lo lvkobv yupbam la doore; akonyi naare okv akonyi kayure. ");
INSERT INTO tgj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nyimv anyi gonv daa hwkbasire: akonyi naaro reku okv akonyi kayu reku. ");
INSERT INTO tgj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nyi anyigo rongo mvba sila doore akonyi naaro reku okv akonyi kayu reku.” ");
INSERT INTO tgj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Lvbwlaksu vdwv ninyia tvvkato, “Ogulo, Ahtu?” Jisu mirwkto, “Ogulo svmago doopvdw hoka Pvta nyidin dvnv dookumre.” ");
INSERT INTO tgj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Vbvrikunamv Jisu ninyigv lvbwlaksu vdwa minchisinam go minla tamsarto bunua kumbwngla doomu dubv okv vdwloka miangbv mvngsu madubv. ");
INSERT INTO tgj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Banggu guloka kvba japrianv nyi go dooto nw yvvnyika mvngdv manvgo okv Pwknvyarnv nyika busu manvgo. ");
INSERT INTO tgj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Okv ho banggu akin hoka hvngmi goka dooto hv ninyi gvlo aaki nvgo okv ninyigv jvjv nga raabwngto vbv minto ‘nga nyiru nvnga ridarminsu dubv nga ridur labv!’ ");
INSERT INTO tgj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Japria jinv angv megojego riji jimakv vla mingkwngto, vbvritola anyung jemanga nw atuv minsuto, ‘Ngo Pwknvyarnvnyi busu manv vmalo nyi ha mvngdv manv gubv rijvka, ");
INSERT INTO tgj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","so hvngmi gv nga adwkaku jinam mvnwng gv lvgalo ngo ninyigv jvjv nga paadu kubv kaajire. Ngo vbv riji mabolo nw aabwngre okv ataranya lo ngaaka gvvkuji!’” ");
INSERT INTO tgj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Okv Ahtu minbwngto, “Japrianv nyi alvmanv gv minam a tvvtoka. ");
INSERT INTO tgj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Vjak, Pwknvyarnv nw atugv nyi gv lvgabv japjiriji maredw yvvdw aluayu bv ridur lvgabv kapki nvnga? Nw ninyia ridur svnga tapv ridw? ");
INSERT INTO tgj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngo nonua mindu, Nw bunu gvbv japjire okv hum baapubv rijire. Vbvritola nyia Kuunyilo ngv vdwlo nyiamooku so aarikunyi mvngjwng go paarikudw?” ");
INSERT INTO tgj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Atua darwk nvgobv mvngsinv okv kvvbi nyi mvnwngnga miyakaayanv vdwa Jisu so minchisinam sum minjidato. ");
INSERT INTO tgj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Alu golo nyi anyigo Pwknvyarnvnaam lo kumdubv vla chaato: akonv Parisi go kvvbi gonv lampu naaria nvgo. ");
INSERT INTO tgj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi angv atu hv akusubv dakrwsito okv kumto, ‘Ngo Pwknvyarnv nam, umbonyikv mvngdunv, ogulvgavbolo ngo dvgum madunv, tvvma nvgobv rima, vmalo nyi mvnwng gv ribv, yoomur nvgobv rima. Ngo nam umbonyikv vdunv ogulvgavbolo ngo alo v doonv lampunayanv aingbv rima. ");
INSERT INTO tgj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngo lokkanw lo loonyi go yikla doodunv, okv ngo paanam lo vring loka akonyi nam jibwng dunv.’ ");
INSERT INTO tgj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Vbvritola Lampunayanv angv adulo dakto okv ninyigv nyukmu ngvka nyido aobv baayinmato, vbvritola ninyigv haakwnglo baapv gvrila okv minto, ‘Pwknvyarnv, ngo rimurnv nyi go, ngam aya labv!’ ");
INSERT INTO tgj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ngo nonua mindunv,” Jisu minto, “Pwknvyarnv gv kaagia lo, alvnvgobv rinv lampu naayanv angv, vdwlo nw naam bv vngtokudw, Parisis angvma. Ho lvga mvnwngngv yvvdw kainvgobv mvngsudunv um miang nvgobv mvre, okv yvvdw atu v miang nvgobv mvngsudunv hum kainvgobv mvre.” ");
INSERT INTO tgj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nyi mego bunugv vmi vdwa Jisu gvlo aagvjito ninyigv laak v bunuam lakpo modubv vla. Lvbwlaksu vdwv bunua vbvrinv gubv vla yamdarpato, ");
INSERT INTO tgj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","vbvritola Jisu vmi vdwa nw gvlo goklwkto okv minto, “vmi vdwa ngoogvlo aamuto okv bunua mintor mabv, ogulvgavbolo Pwknvyarnv gv Karv ngv svkv nvgv gvngv. ");
INSERT INTO tgj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sum mvnggap laka! Yvvdw vmi aingbv rigv rila Pwknvyarnv gv Karv nga naarwk madunv v hoka aanyu mare.” ");
INSERT INTO tgj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jius nyi rigvnv ako Jisunyi tvvkato, “Alvbv Tamsarnv, turbwng nama paanam lvgabv ngo ogugo risegubvri?” ");
INSERT INTO tgj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“No nga ogubv alvnv vla mindunv?” Jisu ninyia tvvkato. “Yvvka alvnv kaama Pwknvyarnv akin mvngchik. ");
INSERT INTO tgj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","No gamkinam gaam vdwa chindu: ‘Yoomur mabvka; gwngrw gwyoka; dvcho mabvka; mvvlarula yvvnyika mium mabvka; noogv anv okv abunyi mvngdv laka.’” ");
INSERT INTO tgj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nyi angv mirwkto, “So gv gamkinam gaam vdw sum, ngo vmi anga lokv, ribwngchala ripvkunv.” ");
INSERT INTO tgj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Vdwlo Jisu hum tvvtokudw, nw nyi anga minto, “No rise ngv akin go doopv. No ogugo doopvdw hum mvnwngnga pyoktola morko nga heemanv vdwa jito laka, okv no nyidomooku tolo nyitvyachok reku; vbvripikula aala nga vngming gvlakuka.” ");
INSERT INTO tgj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Vbvritola vdwlo nyi angv hum tvvtokudw, nw achialvbv mvngru toku, ogulvgavbolo nw achialvbv nyitvto. ");
INSERT INTO tgj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisu ninyia mvngru dubv kaatoku okv minto, “Nyitvnv nyi hv Pwknvyarnv gv Karv lo aanam lvgabv achialvbv aanyu madunv! ");
INSERT INTO tgj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kemel gv pwsi ungrung lo vngpit tvvnam aingbv nyitvnv nyi v hum kaiyabv aanyu manam gubv Pwknvyarnv gv Karv lo aatv rinyi ridunv.” ");
INSERT INTO tgj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nyi vdwv hum nw gvlo tvvpanv vdwv tvvkato, “Vbvrikubolo, yvv, ringnam a paala kujinv?” ");
INSERT INTO tgj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisu mirwkto, “Nyi gv ogugo rinyu manamv Pwknvyarnv gv lvgabv rinyu dunv.” ");
INSERT INTO tgj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Vbvrikunamv Pitar minto, “Kaatoka! Ngonu nam vngming gvdubv ngonugv naam vdwa vngyu pvnv.” ");
INSERT INTO tgj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Am,” Jisu bunua minto, “Okv ngo nonua jvjvbv milv jidunv yvvdw naam vmalo nyimv vmalo achiboru vmalo anvabu vmalo kuu vdwa Pwknvyarnv gv Karv lvgabv vngyu dunv. ");
INSERT INTO tgj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Vjakgv singgv dvnam sum achialvbv kaiyabv paare okv aainv singnam gunv tolo turbwng nama paare.” ");
INSERT INTO tgj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisu lvbwlaksu vdwa vngyi gvtoku okv bunua minto, “Tvvtoka, ngonu Jerusalem bv vngdunv, hoka nyijwk vdwgv nyia Kuunyilo gv lvga nga lvknam vdwv jvjvbv rilin jiriku. ");
INSERT INTO tgj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ninyia kvvbi nyi vdwgvlo laklwk reku, bunu ninyia mvmin reku, nyarjikao reku, okv tachor chorke reku. ");
INSERT INTO tgj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bunu ninyia svnyak pareku, okv mvki reku, vbvritola alu loom kochinglo nw turrap reku.” ");
INSERT INTO tgj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Vbvritola lvbwlaksu vdwv minam vdwa akonyika chinku mato; ogu ha minpv nvdw hv bunugv lokv adu toku, okv Jisu ogu gonyi minpv nvdw um bunu chinku mato. ");
INSERT INTO tgj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisu Jeriko gv adarlo aadungto, hoka giagonv nyi ako lamtv hoka doopv tvvla giadungto. ");
INSERT INTO tgj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Vdwlo nw nyipam vdwgv vngpit nama tvvpa tokudw, nw tvkato, “Si ogu v?” ");
INSERT INTO tgj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bunu ninyia minpato, “Najaret lokv Jisu vngpit dvnvkv.” ");
INSERT INTO tgj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nw kapla minto, “Jisu! Dabid gv kuunyilo! Nga aya mvngpa labvka!” ");
INSERT INTO tgj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Haabo lokv nyi vdwv ninyia yamto okv ninyia choibvkv vla minto. Vbvritola nw gamtvyayabv gokla minto, “Dabid gv kuunyilo! Nga aya mvngpa labvka!” ");
INSERT INTO tgj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Vkvlvgabv Jisu daktungto okv nyikchingnv nyi anga ninyigvlo aagv dubv minto. Vdwlo nyi angv nvchilo aato kudw, Jisu ninyia tvvkato, ");
INSERT INTO tgj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“No nga noogv lvgabv ogugo rijilabv vla mvngdunv?” “Tamsarnv,” nw mirwksito, “Ngo lvkodv kaapa nwngduku.” ");
INSERT INTO tgj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisu ninyia minto, “Vbvrikunamv kaato kuka! Noogv mvngjwng ngv nam alv mopvku.” ");
INSERT INTO tgj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Vjakgobv nw kaapa toku, okv nw Pwknvyarnvnyi hartv yingla, Jisunyi vngming gvtoku. Vdwlo nyipam v um kaatokudw, bunu mvnwngngv Pwknvyarnvnyi hartv toku. ");
INSERT INTO tgj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisu Jeriko nga vngpitla vngto. ");
INSERT INTO tgj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ho hoka lampu naayanv mvnwng lokv kaiyachok nvgo dooto vkvgv aminv Jakias, nw achialvbv nyitvto. ");
INSERT INTO tgj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nw Jisu yvvdw kaadubv vla rikwto, vbvritola nw adwngnv nyi gubv rito okv nyipam v twngtvnam lvkwnglo nw Jisunyi kaapa nyumato. ");
INSERT INTO tgj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Vkvlvgabv nw nyipam a jokcho yala koksitkokrik singnv gulo gechato Jisu ho lamtv hoka vngpit rilo ninyia kaadubv vla. ");
INSERT INTO tgj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Vdwlo Jisu ho hoka vngchi tokudw, nw kaadung toku, okv Jakiasnyi minto, “Baapubv itoku, Jakias, ogulvgavbolo ngo silu noogv naam lo doorung tvvdunv.” ");
INSERT INTO tgj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jakias baapubv geludanv ngv achialvbv himpula ninyia alvbv aamu toku. ");
INSERT INTO tgj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nyi mvnwng hum kaanv vdwv arwnglo mimi sinyato, “So nyi angv si rimurnv nyi gv naam lo nyen bv aadunv!” ");
INSERT INTO tgj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jakias dakrap dato okv Jisunyi minto, “Tamsarnv, tvvrialabv! Ngo ngoogv yikungyira nga tunggonyi heemanv vdwa jireku, okv ngo yvvnyi dvkup pvkudw, ngo ninyia api yagu jiya reku.” ");
INSERT INTO tgj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisu ninyia minto, “Silu so gv naam so ringnam v aapvku, ho lvga so nyi si Abraham gvka husi v. ");
INSERT INTO tgj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nyia Kuunyilo ngv nyekunv vdwa makarla ringdukubv aapvnv.” ");
INSERT INTO tgj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nyi vdwgv um tvria rilo, Jisu mimbwngla minchisinam go bunua mintamto. Nw vjak Jerusalem lo aachi dvlvbv ritoku, okv Pwknvyarnv gv Karv ngv aadaribo vla bunu mvngnyato. ");
INSERT INTO tgj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Vkvlvgabv nw minto “Hoka ho nyi ako kaibv mvngdvnam go dooto nw aduko mookulo vngtv nvgo Dvbv bv mvku dvbv vla, ho kochingbv nw naam aakur dubv vla rungto. ");
INSERT INTO tgj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nw gv vngrap maadvbv, nw ninyigv pakbu vring vdwa gokkumto okv bunua ain lokdwng vkv charchak go jigvrila minto, ‘Kaatoka ngoogv vngro rilo nonu so sam ogugo pwlwkpaalwk la pwtam paatam rila rinv.’ ");
INSERT INTO tgj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Vjak, ninyigv mookugv nyi vdwv ninyia kaanwng mato, okv vkvlvgabv bunu gindungpingko vdwa mimu dubv vla ninyigv kochinglo vngmuto, ‘Ngonu so nyi sum ngonugv Dvbv bv vla mvngma dunv.’” ");
INSERT INTO tgj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Nyi anga Dvbv bv mvtoku okv aakur toku. Nw pakbu vdwa ninyigv kaagialo lvkin gubv aadum dubv minto, bunu vdwgo pwkumpaakum pvdw um kaadubv vla. ");
INSERT INTO tgj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Atokchogv angv aatoku okv minto, ‘Tamsarnv, ngo ain lokdwng charring go paakumpv noogv charkin go jiku lokv.’ ");
INSERT INTO tgj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Alvbv ripv,’ nw mintoku: ‘No alvnv pakbu go! no miangnv yikungyira lo jwkjwkvrwkbv rinv go, ngo nam pamtv vring nga rigvdubv jidunv.’ ");
INSERT INTO tgj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Anyi nvnv pakbu angv aato okv minto, ‘Tamsarnv, ngo ain lokdwng charngu go paakumpv no gv charkin go jiku lokv.’ ");
INSERT INTO tgj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","So anga nw minto, ‘No pamtv angu a rigvnvbv rire.’ ");
INSERT INTO tgj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pakbu gunv aato okv minto, ‘Tamsarnv, siinv noogv ain lokdwng ngv; ngo sam jeriap gulo vvsi pvnv. ");
INSERT INTO tgj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngo nam busuto, ogulvgavbolo no nyi kingin nvgo. No nokv gvnga maka naadu okv noogv paklwk maanam humka nvvdu.’ ");
INSERT INTO tgj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nw pakbu anga minto, ‘No alvmanv pakbu! ngo noogv mvnggwngbv alvmanv gaam um minnvla nam miakayare! No nga gwlwknv nyi go, ngo gvngv manv ngaaka naanv gubv okv ngoogv paklwk maanam humka nvvnv gubv chimpvi. ");
INSERT INTO tgj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Alvdu, vbvrikunamv, no ogubv ngoogv morko nga Benk morko kuu bvngkulo lwkma pvnv? Vbvrikunamv ngo naakur rikunyi morko kuu a lvkobv naaku svnga.’ ");
INSERT INTO tgj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Vbvrikunamv nw hoka daknv vdwa minto, ‘Nw gvlokv ain lokdwng nga naatokuka okv hum Pakbu ain lokdwng charring go doonv yanga jitoka.’ ");
INSERT INTO tgj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Vbvritola bunu ninyia minto, ‘Tamsarnv, nw lokdwng charring go doogvla doopv!’ ");
INSERT INTO tgj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Ngo nonua mindunv,’ nw mirwkto, ‘Nyidum mvnwngnga yvvdw ogugo doodunv, hum jidv yayare; vbvritola yvvdw ogugoka kaama dunv, ninyigv achukgo doogv namaka um ninyigv lokv naaritre. ");
INSERT INTO tgj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Vjak, ngoogv nyiru minsunv vdwa yvvbunudw nga bunugv Dvbv bv mvnwng madunv vdwa, bunua so naalwk tvka okv ngoogv dooku soka mvki tokuka!’” ");
INSERT INTO tgj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisu hum mintoku okv vbvrikunamv bunua vngchoyala Jerusalem bv vngto. ");
INSERT INTO tgj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nw Betpej okv Betani gv adar Olib moodw lo aarilo, nw lvbwlaksu anyigo vngcho moto ");
INSERT INTO tgj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","svbv mingvrila: “Vngnyika nonugv vnglwkjiku nampum alo; nonugv vnglwk rilo, nonu siak ako riokwka manamgo takpvla vvpvnamgo kaapare. Um paksoklaila soka aagv tvika. ");
INSERT INTO tgj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nyi gonv nonua hum ogubv paksok dunv vla minbo loka, Ahtu sum dinchidukv vla ninyia minpa laka.” ");
INSERT INTO tgj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bunu bunugv lamtvlo vngkunamv Jisu gv bunua minam jvbv ogumvnwng nga paatoku. ");
INSERT INTO tgj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bunugv siak a paksok rilo, ho gv atu v bunua minto, “nonuno um ogubv paksok dunvla?” ");
INSERT INTO tgj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Ahtu sum dinchidu,” bunu mirwkto, ");
INSERT INTO tgj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","okv bunu siak a naalaila Jisu gvlo aagv jitoku. Vbvrikunamv bunu bunugv vji a siak aolo puchato okv Jisunyi siak aolo chadubv ridurto. ");
INSERT INTO tgj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ninyigv siak aolo vngrilo nyi vdwv lamtvlo bunugv vji vdwa pipv nyato. ");
INSERT INTO tgj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Vdwlo Nw Jerusalem gv nvchilo aatokudw, Olib moodw bv lamtv ilwk jiku mooku hoka, ninyigv lvbwlaksu vdwv twngtv rungbv bunugv ninyigvlo kaanam mvnwngnga Pwknvyarnvnyi umbonyikv vla okv ninyia hartvla minrap nyatoku: ");
INSERT INTO tgj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pwknvyarnv ayalaka Dvbvnyi yvvdw Ahtu gv amin lokv aanvnga! Nyidomooku lo sarsopoyo reku okv Pwknvyarnv gvlo kairungbv!” ");
INSERT INTO tgj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Vbvrikunamv nyipam lokv Parisis megonv Jisunyi minto. “Tamsarnv,” bunu minto “Noogv lvbwlaksu vdwa choibvkv vla minto!” ");
INSERT INTO tgj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisu mirwkto, “Ngo nonua mindunv bunu choi kubolo, vlwng vdwv bunu atuv gamtv rungbv rumrapre.” ");
INSERT INTO tgj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nw pamtv lo aanwk lvlvto, okv vdwlo nw hum kaapa tokudw, nw ho gv lvgabv kapto, ");
INSERT INTO tgj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","minto, “Nonu silu sarsopoyo gv lvgalo ogugo aadu nvdw um chinv guloka! Vbvritola nonu vjak um kaapa kumare! ");
INSERT INTO tgj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nonua nonugv nyimak vdwv aagvrila goyumgochila vnglin chaalin momabv tumla vvpv dw alu v aariku. ");
INSERT INTO tgj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bunu nonua achuk goka dooku madubv mvyak mvchakre okv nonugv vlwngsvlu arwnglo doonv nyi vdwaka; vlwng pwgoka dookulo doomu mare, ogulvgavbolo nonu Pwknvyarnv gv vdwlo nonua ringdubv vla aanama kaachin manam lvkwnglo!” ");
INSERT INTO tgj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Vbvrikunamv Jisu Pwknvyarnvnaam lo vngtoku okv korvpachu pioknv vdwa charlin raptoku, ");
INSERT INTO tgj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","bunua minto, “So si Darwknv Kitaplo lvkdu, ‘Ngoogv Naam a kumgingku naam bv vla mindunv.’ Vbvritola nonu hum chonvmvvnv tosiku bv mvpv!” ");
INSERT INTO tgj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jisu alu gv dwkia Pwknvyarnvnaam arwnglo tamsarto. Nyibu butvnv vdwv, Pvbv tamsarnv vdwv, okv nyi vdwa rigvnv vdwv Jisunyi mvki dubv mvngtoku, ");
INSERT INTO tgj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","vbvritola bunu ninyia vbvridubv lamtv paanyu matoku, ogulvgavbolo nyi mvnwngngv ninyia tvvria bwngto, gamgoka nyemu nwngma vla mvngnyato. ");
INSERT INTO tgj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Alu gulo Jisu Pwknvyarnvnaam lo nyi vdwa tamsarla okv Gamlv nga japji rilo, nyibu butvnv vdwv okv Pvbv tamsarnv vdwv, nyiga vdwa lvkobv, aatoku ");
INSERT INTO tgj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","okv ninyia minto, “Ngonua mintamto, no ogubv svbv rimin dunv? Yvvla nam svbv rimin dubv jinv ngv?” ");
INSERT INTO tgj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisu bunua mirwksito, “Ngam nonua gaamgo tvu chomu labv. Ngam mintam labv, ");
INSERT INTO tgj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon gv baptisma jinamv Pwknvyarnv gvlo kvre vmalo nyi gvlo kvre?” ");
INSERT INTO tgj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bunu vdwv atu v larmi sirap nyato, “Ngonu ogu vla mindubv? Ngonu ‘Pwknvyarnv gvlokv’ vla minbolo, nw minrikuda, ‘V bolo nonu ogugbv Jonnyi mvngjwng mapvnv?’ ");
INSERT INTO tgj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Vbvritola ngonu ‘Nyianyi gvlokv’ vla minbolo, so gv nyi nyipam vdwsi ngonua vlwng orgingre, ogulvgavbolo bunu Jonnyi nyijwk akobv pvbwng alvbv chinya dukunv.” ");
INSERT INTO tgj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Vkvlvgabv bunu mirwkto, “Ngonu chima v ogulokv aapvnvdw.” ");
INSERT INTO tgj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Okv Jisu bunua mintoku, “Ngo ka nonua minjimare ogubv ngo so vdw sum ridu nvdw.” ");
INSERT INTO tgj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Vbvrikunamv Jisu so minchisinam sum bunua minjito: “Ho hoka nyi ako dooto hv anggor rongo mvto, um rijo naanv nyi vdwlo tinto, vbvrikunamv adubv relinnam lvgabv vnglintoku. ");
INSERT INTO tgj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Vdwlo anggor naakumdwv aatokudw, nw nyira go rwktin vdwlo gvlo anggor ninyigv baak paase naarwk simu dubv vla vngmu toku. Vbvritola rwktin vdwv nyira anga dvngtola ogu goka jimabv vngkur motoku. ");
INSERT INTO tgj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Vkvlvgabv nw nyira gunvnyi vngmuto; vbvritola rwktin vdwv ninyi nyika dvngdvto, hinyinghiru dubv mvto, okv ogugoka jimabv vngkur motoku. ");
INSERT INTO tgj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Vbvrikunamv nw nyira aom nvnv nga vngmuto; rwktin vdwv ninyia ungnv gvdubv, mvdvto, okv ninyia agumlo dvato. ");
INSERT INTO tgj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Vbrikunamv anggor rongo atuv mintoku, ‘Ngo ogugo riku nvpvdw? Ngo ngoogv paknam kuunyilo nga vngmu reku; bunu ninyia jvjvbv mvngdv jiriku!’ ");
INSERT INTO tgj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Vbvritola vdwlo rwktin vdwv ninyia kaapa tokudw, bunugv aralo mimisinyato, ‘So si atu gv kuunyilo ngv. ‘Klai ninyia mvki laju, okv ninyigv yikungyira ngv ngonu gvbv rireku!’ ");
INSERT INTO tgj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Vkvlvgabv bunu ninyia anggor rongo agum dvlinto okv mvki toku. “Vbvrikunamv, rongo atuv rwktin vdwa ogubv rireku?” Jisu tvkato. ");
INSERT INTO tgj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Nw aariku okv ho nyi vdwa mvki reku, okv anggor rongo nga kvvbi rwktin vdwlo laklwk reku.” Vdwlo nyi vdwv sum tvvtokudw bunu minto, “Vbvrirung mare!” ");
INSERT INTO tgj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisu bunua kaagapto okv tvvkato, “Vbvrikunamv so darwknv kitap gv minam si ogu v? ‘Naam mvnv vdwgv toa kunam vlwng pwngv mvnwngnga dinchiyachok nvgobv rire.’ ");
INSERT INTO tgj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nyi mvnwngnga ho vlwng hoka hopv nvnga patungpayung mvre; okv ho vlwng angv nyi akonvgv aolo hoopv bolo, v ninyia amwkbv mvre.” ");
INSERT INTO tgj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pvbv tamsarnv vdwv okv nyibu butvnv vdwv, hoka Jisunyi naatung dubv rikwto, ogulvgavbolo ninyigv minchisinam minam angv bunua minyingdu vla bunu chintoku; vbvritola bunu nyi vdwa busu nyato. ");
INSERT INTO tgj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Vkvlvgabv bunu alvnv dw kaakarto. Bunu nyi mego arwnglo gwngla jisito bunua alvnv nyi go vla kaakudubvrinv nyi vkv, okv bunu ho vdwa Jisu gvlo vngmuto tvu gvrila naatung dubv vla vkvlvga bunu ninyi Roman nyigam lo laklwk ladukubv. ");
INSERT INTO tgj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","So gv arwng gwngyanv vdwv Jisunyi minto, “Tamsarnv, ngonu chindu no ogugo mindudw okv tamsar dudw v jvjv ngv. Ngonu chindu no nyi gv mvngnam lokv kaamadu, vbvritola nyi gv lvgabv Pwknvyarnv gv mvngnam jvjv nga tamsaryado. ");
INSERT INTO tgj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ngonua mintam labv, Roman Dvbvyachoknyi ngonugv lampu jinam si ngonugv Pvbv nga rinying dunvri, vmalo rikin madunvri?” ");
INSERT INTO tgj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Vbvritola Jisu bunugv gwngnam a kaapa toku okv bunua minto, ");
INSERT INTO tgj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ngam lokdwng go kaatam labv. So si yvvgv nyukmu vla aminv doodunv?” “Dvbvyachok gv,” bunu mirwksito. ");
INSERT INTO tgj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Vkvlvgabv Jisu minto, “Alvdo, vbvrikunamv, Dvbvyachok gvnga Dvbvyachoknyi jitoka, okv Pwknvyarnv gvnga Pwknvyarnvnyi jilaka.” ");
INSERT INTO tgj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Vkvlvgabv nyi vdwgv kaagia hoka ogu goka bunu ninyia naatung nyula mato, vkvlvgabv bunu ninyigv mirwk nama lamrwpanya la choibv doonya toku. ");
INSERT INTO tgj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Vbvrikunamv Sadusis mego, yvvbunudw nyi vdwv sitokula turkur kumadunv vnv vdwv, Jisu gvlo aato okv minto, ");
INSERT INTO tgj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tamsarnv, Moses so Pvbv sum ngonugv lvgabv lvkpv jipvnv: ‘Nyi gonv nywng nga kuu dooma dwbv siyu bolo, ho siyu nvgv boruv hvngmi nga nywng mvrung tvka vkvlvgabv bunyiv kuu doogv rila sinv ho gv kuu bv mindu kubv.’ ");
INSERT INTO tgj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Alu golo achiboru kanw go dooto; achi yachok v nyimv naatoku okv kuu dooma dwbv siyuto. ");
INSERT INTO tgj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Vbvrikunamv boruya gonv nyimv nvnga nywngbv doogvto, ");
INSERT INTO tgj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","okv boru aom nvnv ngvka. Vbvdvdvbv achiboru kanw mvnwnglo rito—bunu siyuto kuu dootv madvbv. ");
INSERT INTO tgj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mvnwng gv kochinglo, nyimv nvngv sitoku. ");
INSERT INTO tgj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Vjak, sinv ngv turkurdw alulo, nyimv nvngv yvvgv nywngbv rirekudw? Mvnwng kanw v ninyia nywng mvpv.” ");
INSERT INTO tgj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisu bunua mirwkto, “Vjakgv nyiga mvvga ngv nywng nyilubv rimi sidu, ");
INSERT INTO tgj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","vbvritola nyiga okv mvvga ngv yvvdw sinam lokv turkur kuji bongv okv singnam gunv tolo doojinv v nywng nyilubv rimi sikumare. ");
INSERT INTO tgj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bunu nyidogindung vdw jvbv rire okv sinyu kumare, bunu Pwknvyarnv gv kuu vdwvku, ogulvgavbolo bunu sito koola turrap kunvngv. ");
INSERT INTO tgj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sinam lokv turkurkunama Moses ka chimbwk toku. Lvklin jinamlo yamdwng yamchumlo vmv gunam gv lvkwng nga nw Atu gvbv minto ‘Abraham gv Pwknvyarnv ngv, Isaak gv Pwknvyarnv ngv, okv Jakob gv Pwknvyarnv ngv.’ ");
INSERT INTO tgj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nw turnv vdwgv Pwknvyarnv ngv, sinv gvngvma, ninyigv lvgabv mvnwngngv turdunv.” ");
INSERT INTO tgj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pvbv tamsarnv megonv goklinto, “Alvbv mirwknam go, Tamsarnv!” ");
INSERT INTO tgj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bunu ninyia ho lvkwngbv tvu dukubv choopu kuma toku. ");
INSERT INTO tgj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisu bunua tvvkato, “Kristo Dabid gv husi v vla oguaingbv minpvnv? ");
INSERT INTO tgj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dabid nw atuv mirimimpak kitaplo minsuto, ‘Ahtu ngoogv Ahtunyi minto: Ngoogv lakbiklo dootungto ");
INSERT INTO tgj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","vdwlo ngo noogv nyimak vdwa lvpa lvging nvnv aingbv mvla noogv lvchulo vvpvma dvdvlobv.’ ");
INSERT INTO tgj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dabid ninyia ‘Ahtu’ vla minto; oguaingbv, vbvrikunamv, Kristo Dabid gv husi bv rila rinv?” ");
INSERT INTO tgj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nyi vdwgv ninyia tvvla doorilo, Jisu ninyigv lvbwlaksu vdwa minto, ");
INSERT INTO tgj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pvbv tamsarnv vdwa nonu himasuto laka, bunu bunugv jvtvlaklwk a kotola daakar svnga mvngbiu dunv okv pyokpamdorpam lo vngkar gvrila mvngdv kodubv mvngbiu dunv; bunu jius kumkunaam vdwlo dooku a okv dvpam dvkulo alvyachoknv dooku a gakcho dunv; ");
INSERT INTO tgj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bunu hvngmi vdwlo riborilit mingla okv bunugv naam vdwa dvrit papi jila, okv kaakudubv vla asu dubv kumla! bunua achialvbv alvmanam gubv mvritre!” ");
INSERT INTO tgj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisu kaitkarto okv nyitvnv nyi vdwv bunugv daan a Pwknvyarnvnaam gv morko vvgia nvnv arwnglo paalwk dubv kaapato. ");
INSERT INTO tgj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Okv nw hvngmi go achialv heema nvgo aala ain lokdwng charnyi go lwkdubv kaapa dvto. ");
INSERT INTO tgj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nw minto, “Ngo nonua mindunv so gv heemanv hvngmi angv kvvbi mvnwngnga kaiyabv lwkgv nyibv. ");
INSERT INTO tgj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kvvbi vdwv bunugv nyitv laila lvvlin kunvnga amin bv lwkdunv; vbvritola nw, achialvbv heema dvlaka, dvtvsinv nvnvnga jitar pagvyibv.” ");
INSERT INTO tgj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lvbwlaksu megonv Pwknvyarnvnaam gv lvkwng nga minto, so gv alvnv vlwng v achialvbv kaapuv okv Pwknvyarnvnyi amin jinam vdwv. Jisu minto, ");
INSERT INTO tgj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nonugv kaanam mvnwng si—alu go looriku vdwlo vlwng pwgoka dookulo dooku mare; mvnwng a orlula ora reku.” ");
INSERT INTO tgj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bunu tvvkato, “Tamsarnv,” “Vdwlo so vdw si ritv dunv? Okv so vdwgv ridw v aatv riku vla kaatam nvnvbv ogugo ritv rinvla?” ");
INSERT INTO tgj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisu minto, “Hima tvlaka; kupku yoka. Nyi achialvgo, ngo yamabv vla nga minre, v aare okv minre, ‘Ngo kunv nw!’ okv, ‘Dw v aaduku!’ Vbvritola bunua vngming gvyoka. ");
INSERT INTO tgj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Vdwlo nonu nyimak okv mvyakminsu nama busu mabvka; vkv nvngv richola rirungjinv, vbvritola vkv nvngv rinya alu v nvchi duku vla minam kaama.” ");
INSERT INTO tgj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nw minbwngto, “Mooku vdwv padar minsureku; Karv ngv Karv gonyi palwk reku. ");
INSERT INTO tgj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hoka achialvbv hilamanam moobi v hwkriku, dvmayarwng, okv yipvyvlam v mooku mvnwnglo rire; nyidomooku tolokv kaaka manam okv arwsinyi nvngv ire. ");
INSERT INTO tgj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","So mvnwng gv rima dwbv, nonua naatung reku okv mvdwkmvku reku; nonua Jius vdwgv kumkunaamlo mvmin dubv laklwk reku, okv patwklo lwkreku; nonua ngoogv lvgabv Dvbv vdwgv rigvnv vdwgv kaagialo daklin moreku. ");
INSERT INTO tgj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","So si alvnv dw v nonugv lvgabv Alvnv Yunying a mintam jidubv. ");
INSERT INTO tgj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nonugv mvngnamsaknam a mvngcho richo laka oguaingbv atu v mvnging sila minse rise vdw vla busukano madubv, ");
INSERT INTO tgj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ogulvgavbolo ngo nonua vkvnv gaam okv mvnglak ha jire nonugv nyiru minsinam vdwv yvvka nonugv gaam minama tvvlakaala vmalo raarwksila maadubv. ");
INSERT INTO tgj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nonua laklwk jikunv nonugv Anvabu, nonugv abwngboru, nonugv amiasa, okv nonugv ajin vdwv; nonua megonyi mvkire. ");
INSERT INTO tgj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ngoogv lvgabv nonua nyi mvnwngngv kaanwng mare. ");
INSERT INTO tgj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Vbvritola nonugv dwmw sogo nvka ngoomare. ");
INSERT INTO tgj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gwlwkbv dakto laka okv nonu atuv ringsu reku.” ");
INSERT INTO tgj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Vdwlo nonu Jerusalem a sipai vdwv dakyum dubv kaaparidw, vbvrikunamv si baapu bv yakriku vla nonu chinre. ");
INSERT INTO tgj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Vbvrikunamv yvvbunudw Judia lo doodunv moodw bv kicha rungre; yvvbunudw pamtv arwnglo doodunv vngro laka, okv yvvbunudw mooku agum lo doodunv v pamtv arwnglo aarung mabvka. ");
INSERT INTO tgj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ho vdwv ‘Mvritririt alu hv,’ Darwknv Kitaplo minam mvnwngnga jvjv bv rilin modubv. ");
INSERT INTO tgj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Vdwgo mvngdwknam gubv rire ho alu hoka yvv nyimv ngv leit lo kuu gvnv okv anv ngv anga ajingnv doogvnv! achialvbv alvmanv go so kvdw so rilwkre, okv Pwknvyarnv gv mvrit v so nyi vdwlo aare. ");
INSERT INTO tgj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Megonyi riokse lokv pakire, okv kvvbi vdwa mooku mvnwnglo tumla vvpvre; okv nyi kvvbi Pwknvyarnvnyi chimanv vdwv nw bunugv dwhv vngma dvdvlo Jerusalem a chaatin la vvpvre.” ");
INSERT INTO tgj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nyidomooku doonyi tolo ogu kaakwmanam go rilinre, poolu loka, okv takar vdwloka. Sichingmooku mvnwnglo turdubv mvngmin kuma reku, Svmasa gv sudu a tvvla okv sekiok gv kioknam vdwa kaala busu nyareku. ");
INSERT INTO tgj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sichingmooku mvnwng so ogugo ritv tvdu nvbvre vla nyi vdwv mvngngak sangakla anyu kumabv doore, aotolo gv jwkrw ngvka ngooriku. ");
INSERT INTO tgj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Vbvrikunamv Nyia Kuunyilo ngv, doomwk lo kaibv yunglit rungnam gubvrila aalwk reku. ");
INSERT INTO tgj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Vdwlo so vdw si ridukubv vla rirap tvri kunyi, dakrap lakuka okv nonugv dumpo v baarap lakuka, ogulvgavbolo nonugv ringlinbaalin v nvchi duku.” ");
INSERT INTO tgj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Vbvrikunamv Jisu so minchisinam sum bunua minjito: “Koksitkokrik singnv hala okv kvvbi singnv mvnwng haka mvngkw toka. ");
INSERT INTO tgj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Vdwlo bunugv anw hv harlin tvvnam a nonu kaapa rikunyi, dwrw hv nvchi duku vla nonu chindo. ");
INSERT INTO tgj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ho apiabv, vdwlo soogv vdw sum ridu kubv nonu kaapa kubolo, Pwknvyarnv gv Karv gv aadw hv nvchi duku vla nonu chinreku.” ");
INSERT INTO tgj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mvnggap tvvlaka vjakgv rinv nyi mvnwng si sitv maadvbv so gv vdw si rilin reku. ");
INSERT INTO tgj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sichingmooku okv nyidomooku hv ngelare vbvritola ngoogv gamchar vdwv vdwloka ngela mare. ");
INSERT INTO tgj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Himasuto laka! dvpam okv dvnamtvngnam yayabv rila nonugv so singnam a atu v mvngdwk mvngkubv rimu mabvka, ho gv alu hv nonua lamdubv loopu jila ");
INSERT INTO tgj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","amin mvnam jvbv. Ho hv Sichingmooku mvnwng gv nyi mvnwng gv aolo aalwkre. ");
INSERT INTO tgj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chvrv nvgobv rito laka okv loki ha kumlaka so mvnwng gv riri kunyi nonua ogu riakuma dubv okv nyia kuunyilo gv kaagialo dakdu kubv.” ");
INSERT INTO tgj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisu ho alu mvnwng a Pwknvyarnvnaam lo tamsarla dootoku, okv vdwlo ariumv aato kudw, nw Olib Moodw lo ayu a doolwk toku. ");
INSERT INTO tgj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Arukamchi dwkibv nyi vdwv Pwknvyarnvnaam lo nw gvlo tvvria dubv vla vngnya toku. ");
INSERT INTO tgj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Vpap lwkmabv vtwng dvbamnam alu v nvchi toku, ho hum Vngbo dvmdvin vla minto. ");
INSERT INTO tgj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nyibu butvnv vdwv okv Pvbv tamsarnv vdwv nyi vdwa busu nyato, vkvlvgabv bunu Jisunyi tosila mvkidubv vla lamtv makar nyato. ");
INSERT INTO tgj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Vbvrikunamv lvbwlaksu nyidum vring gola anyi lokv Judas, Iskeriot vla minam gvlo Uyu ngv aatoku. ");
INSERT INTO tgj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Vbvrikunamv Judas Nyibu butvnv vdwgv okv Pwknvyarnvnaam ha kaayanv vdwgv nyigam gv dookulo nw Jisunyi oguaingbv bunu gvlo kublwk nyuku sengvdw ho lvga nga mintebv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bunu mvngpula ninyia morko jidukubv mintoku. ");
INSERT INTO tgj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas hum tolwk toku okv nw Jisunyi nyi chimpa madubv bunu gvlo laklwk dukubv vla alvnv dw marap toku. ");
INSERT INTO tgj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hoka vpap lwkmabv vtwng nga dvdw okv svlarkuu a vngbodvmin gv lvgabv palwkdw pumja alu v loolwk toku. ");
INSERT INTO tgj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisu Pitar okv Jonnyi svbv mingvrila vngmuto: “Vngnyika okv ngonugv lvgabv vngbo dvmin dvnam a dvdubv mvpvripv tvka.” ");
INSERT INTO tgj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bunu ninyia tvvkato, “No ngonua ogolo mvpvripv tvka vla mvngdunv?” ");
INSERT INTO tgj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nw mirwkto, “Nonu gv pamtv vlo arwnglo aarilo, nyiga ako isi opum bvngnv go nonua vngrwksire. Ninyia vngming gvla ninyigv naam arwngbv aakulo aaming gvlaka, ");
INSERT INTO tgj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","okv naam atua minlaka: ‘Tamsarnv nam mindu, ngo okv ngoogv lvbwlaksu vdwgv vngbo dvmin dvnam dvjiku karchung ngv ogolo?’ ");
INSERT INTO tgj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nw nonua aolo kaapu dubv mvnam karchung go kaatamre, hoka nonu ogumvnwng nga mvpvripv dukubv kaapare.” ");
INSERT INTO tgj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bunu vngtoku okv Jisu gv bunua minam aingbv ogumvnwngnga kaapa toku, okv bunu vngbo dvmin dvnam a mvpvripv toku. ");
INSERT INTO tgj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Vdwlo dw v aato kudw, Jisu Apostol vdwa lvkobv dvkulo dootoku. ");
INSERT INTO tgj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nw bunua minto, “Ngoogv hinching chingma dwbv ngo nonua lvkobv so vngbo dvmin dvnam sum dvnwng dunv! ");
INSERT INTO tgj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ho lvga ngo nonua mindunv, Pwknvyarnv gv Karv lo so gv lvga nga alvbv rilin jima dvdvlo ngo vdwloka sum dvmare.” ");
INSERT INTO tgj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Vbvrikunamv Jisu koobu a naarapto, Pwknvyarnvnyi umbonyikv vla minto, okv minto, “Sum naato okv nonugv apumlo nonu atu v ormisito. ");
INSERT INTO tgj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngo nonua mindunv vjak lokv rila vdwlo Pwknvyarnv gv Karv ngv aama dvdvlo ngo vdwloka sum tvngnam sum tvngmare.” ");
INSERT INTO tgj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Vbvrikunamv nw vtwng ariap ha naato, okv Pwknvyarnvnyi umbonyikv vla minto, hum pintungpiungto, okv hum bunua jitola, minto, “Si ngoogv ayak adwn v, sum nonugv lvgabv jipvnv. Ngam mvngpa gvnvbv sum rito laka.” ");
INSERT INTO tgj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ho apiabv, nw bunua dvnam dvro kochingbv koobu ha jitola, minto “So koobu si nonugv lvgabv ngoogv oyi sarlin kunamv si Pwknvyarnv gv anw bv milv jikunama mvu pvvku namv.” ");
INSERT INTO tgj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Vbvritola, kaatoka! ngam koanv angv vjak ngoogv dookulo tvbul si lvkobv doodu! ");
INSERT INTO tgj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nyia Kuunyilo ngv Pwknvyarnv gv minam aingbv sire, vbvritola vdwgo mvngdwk rekudw nga koanv angv!” ");
INSERT INTO tgj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Vbvrikunamv bunugv apum lo tvvka minsu toku bunugv lokv yvvdw vbv ritv tvdunv vla. ");
INSERT INTO tgj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lvbwlaksu vdwv bunugv arwnglo larmi sinyato bunugv lokv yvv yadw kaiyachok nvgobv riji kunv vla. ");
INSERT INTO tgj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisu bunua minto, “Pwknvyarnvnyi chimanv vdwgv Dvbv ngv bunugv nyi vdwa kaiyadunv, okv dvbv vdwv ‘Nyi vdwgv ajin’ vla amina gakdu. ");
INSERT INTO tgj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Vbvritola so gv rinam si nonu gvlo doomare; vmabvya, nonu gvlo kaiyachok jinv ngv mvnwngnga miangyachok nvgobv rire okv rigvnv gubv rijinv pakbu aingbv rirungre. ");
INSERT INTO tgj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yvvla kainv, dvdubv vla dootungnv angv re vmalo ninyia jirianv angv re? Dootungnv angv, v rung. Vbvritola nonu gvlo ngo jirianv angv aingbv ridu.” ");
INSERT INTO tgj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ngo gv hirukaya kolo nonu nga lvkobv doomwng gvto; ");
INSERT INTO tgj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","okv ngoogv Abu nga rigv dubv jinam aingbv ngo nonua jidunv. ");
INSERT INTO tgj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nonu ngoogv Karv lo dvgianvnv lo doopv tvla dvriku okv tvngriku, okv Dvbv dogianvnv lo doopv tvla Israel gv nyi haalung vring gola anyia rigv reku. ");
INSERT INTO tgj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon! Tvriato! Uyu hv nonu mvnwngnga rika dubv vla rinv nvnga naagv nyibv, alvmanv lokv alv nvnga naapin sidubv vla, rongo rinv nyi ako gv aam-tami a amsok-misok lokv naapin sunam aingbv. ");
INSERT INTO tgj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Vbvritola ngo nonugv lvgabv kumpvnv, Saimon, no gv mvngjwng ngv ngooma dubv. Okv vdwlo no nga dakrwk rikudw no noogv boru vdwa abwk mola kuka.” ");
INSERT INTO tgj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitar mirwksito, “Ahtu, ngo nam lvkobv patwk tumjeka sida jeka reming gvdubv mvngpvla doodunv!” ");
INSERT INTO tgj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Pitar nam ngo mindunv,” Jisu minto, “Siyunyi rokpu v kokma dwbv no ngam chimapvnv vla lvomgo minre.” ");
INSERT INTO tgj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Vbvrikunamv Jisu ninyigv lvbwlaksu vdwa tvvkato, “Ngoogv nonua morko gvnvnv, gvgianvnv vmalo lvsup jimabv vnglin mori hoka ogu chiimanvgo doopire?” “Oguka ma” bunu mirwkto. ");
INSERT INTO tgj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Vbvritola vjak,” Jisu minto, “Yvvdw morko gvnvnv vmalo gvgianvnv doodunv ung naarung toku laka; okv yvvdw riokse dooma dunv hv ninyigv vji laklwk a pioktola ako rvvla kuka. ");
INSERT INTO tgj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngo nonua mindunv Darwknv Kitaplo mindu, ‘Nw rimur nvgv gungnying nga gvvria jito,’ vnam ngoogv lvga ngv jvjvbv aarung reku, ogulvgavbolo ngoogv lvga nga lvknam v jvjv bv rilin reku.” ");
INSERT INTO tgj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Lvbwlaksu vdwv minto, “Kaatoka! Ahtu, So si riokse sonyi go doopv!” “Hv chipvku!” nw mirwk toku. ");
INSERT INTO tgj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisu pamtv nga vngyula vngtoku, ninyigv kvvlo gv vngchingbv, Olib Moodw lo; okv lvbwlaksu vdwv ninyia lvkobv vngto. ");
INSERT INTO tgj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Vdwlo nw dooku hoka vngchi tokudw, nw bunua minto, “No pokayarka kolo ngoolwk madubv kumto laka.” ");
INSERT INTO tgj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Vbvrikunamv nw bunua mego adubv vngyu dvla vlwng ngv kongchi dubv rikulo vngla nw lvbwng v kumpvto okv kumtoku. ");
INSERT INTO tgj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Abu” nw minto, “No mvngdu boloka, hinching gv koobu sam ngo gvlokv naapak jilabv. Ngoogv mvngnam bvma vbvritola noogv mvngnambv rilaka.” ");
INSERT INTO tgj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nyidomooku tolokv nyidogindung go ninyi gvlo aalwkto okv ninyia ridurto. ");
INSERT INTO tgj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Achialvbv mvngdwk laila nw kadwk yayabv kumto; ninyigv haar hv oyi jvbv kvdw lo sarluto. ");
INSERT INTO tgj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kumku lokv taprap lakula, nw lvbwlaksu vdwgv dookulo aakur toku okv bunua yupngakla doodubv kaapa toku, mvngdwk hv bunua dwkyup gvdubv. ");
INSERT INTO tgj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nw bunua minto, “Ogubv nonu yupmin dunv? Gudungla kumla dootoka nonu gwngka kolo ngoolwk madubv.” ");
INSERT INTO tgj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisu gv raadung rilo nyipam go aalwkto, Judas, lvbwlaksu vring gola anyi lokv akonv aagvto. Nw Jisu gvlo chaato okv ninyia moopupto. ");
INSERT INTO tgj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Vbvritola Jisu minto, “Judas, moopup akolo no Nyia Kuunyilo nga koa duku nvri?” ");
INSERT INTO tgj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Vdwlo Jisunyi hoka lvkobv rinv vdwv ho gv ritv nama kaapa gvrila Jisunyi tvkato, “Ahtu ngonu ngonugv riokse lokv rirap svgo bri?” ");
INSERT INTO tgj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Okv bunugv lokv akonv nyibu Butvyachok nvgv nyira nga nyarung rungbik ha palu toku. ");
INSERT INTO tgj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Vbvritola Jisu minto, “So gotoku!” Nw nyi angv gv nyarung nga mvsit to okv ninyia mvpu toku. ");
INSERT INTO tgj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Vbvrikunamv Jisu nyibu butvnv vdwa okv Pwknvyarnvnaam lo dakria nvgv nyigam vdwa okv nyiga vdw yvv ninyia naabv aanv vdwa minto, “Nonuno ngam Pvbv agumlo rinv nyi aing gubv, riokse okv daadwng bvngla aapvi? ");
INSERT INTO tgj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngo Pwknvyarnvnaam lo loki a nonua lvkobv rebwngto, okv nonuno nga naatung dubv rikw mato. Vbvritola kanv gv gwlwk v rigvdogvri so, si nonugv ridw vku.” ");
INSERT INTO tgj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bunu Jisunyi naatung toku okv ninyia Nyibu Butvyachok nvgv naam lo vnggv toku; okv Pitar mego adubv vngming gvto. ");
INSERT INTO tgj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kvba baaku naam gv adar lo vmv nga parto, okv Pitar hum dooyumnv vdwa doomwng gvto. ");
INSERT INTO tgj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Vdwlo paknv akonv ninyia vmvlo doodubv kaapa tokudw, nw kaagap lalato ninyia okv minto, “So nyi angv si ka Jisu gv rikulo reming gvnv!” ");
INSERT INTO tgj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Vbvritola Pitar hum miasuto, “Nyimv angv, ngo ninyia chimaka nvgo!” ");
INSERT INTO tgj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Achukgo ayungjvma nga nyi akonv Pitarnyi kaachinto okv minto, “No ka bunugv lokv akonv!” Vbvritola Pitar mirwkto, “Nyi angv, ngo ma!” ");
INSERT INTO tgj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Okv ayungjvma gv kochinglo nyi akonv ninyia minggap lala la minto, “Nw Jisunyi riming gvnv ngv vnam so mvngbwk masego kaama ogulvgavbolo nw ka Galili gv nyi go!” ");
INSERT INTO tgj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Vbvritola Pitar mirwkto, “Nyi angv, no ogu gonyi mindudw ngo chima!” Vjakgobv, ninyigv vbv mindung rilo, rokpu v koktoku. ");
INSERT INTO tgj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ahtu kaitkarto okv Pitarnyi kaagapto, okv Pitar mvngpa toku Ahtu gv ninyia minam a, “Siyu gv ayulo rokpu v kokma dwbv no nga chima vla lvom go minre.” ");
INSERT INTO tgj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pitar agumbv vngtoku okv achialvbv mvngdwkla kaptoku. ");
INSERT INTO tgj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisunyi kaayanv nyi vdwv ninyia minjikminbikto okv ninyia dvngto. ");
INSERT INTO tgj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bunu ninyia nyik a putumto okv ninyi tvkato, “Yvvla nam dvngnv ngv? Mvngjwk kaato!” ");
INSERT INTO tgj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Okv bunu ninyia nyarjikau gaam vkv awgo minto. ");
INSERT INTO tgj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Vdwlo bunu aato kudw, nyiga vdwv, nyibu butvnv vdwv, okv Pvbv tamsarnv vdwv lvkobv kaarwksuto, okv Jisunyi kvba vdwgv kaagialo daklin motoku. ");
INSERT INTO tgj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bunu minto, “Ngonua mintamto, no Kristo rungre?” Nw mirwkto, “Ngo nonua mintam jvka, nonu ngam mvngjwng mare; ");
INSERT INTO tgj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Okv ngo nonua tvu sego tvka jvka nonu mirwk simare. ");
INSERT INTO tgj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Vbvritola vjak lokv Nyia Kuunyilo ngv kaiyachoknv Pwknvyarnv gv lakbiklo dooreku.” ");
INSERT INTO tgj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bunu mvnwngngv mintoku, “Vbvrikunamv, no Pwknvyarnv gv Kuunyilo ngvre?” Nw bunua mirwkto, “Nonu gv minam hv ngo.” ");
INSERT INTO tgj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Okv bunu minto, “Ngonu kvvbi gungnying yago mvngkuma! Nw ogugo minpvdw ngonu tvvgap tokubv!” ");
INSERT INTO tgj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nyi mvnwngngv gudungto okv Jisunyi Pilot gv dookulo aagv toku. ");
INSERT INTO tgj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hoka bunu ninyi gungnying lwkrapto “Ngo so nyi sum ngonugv nyi vdwa rimur gvdubv Dvbvyachoknyi lampu jima bvkv vla okv nw atu v Kristo, okv Dvbv gubv minsu dubv naatung pvnv.” ");
INSERT INTO tgj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilot ninyia tvkato, “No Jius vdwgv Dvbv ngvre?” “No mingvnyibv,” Jisu mirwkto. ");
INSERT INTO tgj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Vbvrikunamv Pilot Nyibu butv vdwa okv nyipam vdwa minto, “Ngo so nyi sum rimur rinam go mapama.” ");
INSERT INTO tgj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Vbvritola bunu tvvmabv abuyayabv minto, “Judia lo nw gv tamsar kolo nyi vdwa yalung durap moto. Nw Galili lo rirapto okv alo gvngv si rilwk dukunv.” ");
INSERT INTO tgj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Vdwlo Pilot hum tvvpa tokudw, nw tvkato, “So nyi si Galili lokv nyi ngvre?” ");
INSERT INTO tgj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Vdwlo Pilot Jisu nyi Herod gv rigvnam mooku lokv vla chinto kudw nw Jisunyi Herod gvlo vngmuto, ho gv dw lo Herod Jerusalem lo dootato. ");
INSERT INTO tgj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Vdwlo Herod Jisunyi kaato kudw nw achialvbv himputo, ogulvgavbolo nw Jisu gv lvga nga tvvpato okv kvvlo gv lokv ninyia achialvbv kaanwngla dooto. Nw Jisu nyi lamrwpadubv mvnam rinam go kaanvpv vla dvminla dooto. ");
INSERT INTO tgj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Vkvlvgabv Herod Jisunyi achialvbv tvula tvkato, vbvritola Jisu mirwk sima toku. ");
INSERT INTO tgj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nyibu butvnv vdwv okv Pvbv tamsarnv vdwv aanwk yayala Jisunyi achialvbv gungnying lwkto. ");
INSERT INTO tgj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod okv ninyigv sipai vdwv Jisunyi nyarjikaola mvritto; vbv mvgvrila bunu ninyi alvnv vji go pilwkto okv Pilot gvlo vngkur motoku. ");
INSERT INTO tgj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","So gv alu lokv Herod la Pilot bunyi ajin minsu toku; kvvlo bunyi anyi hv nyiru minsito. ");
INSERT INTO tgj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilot Nyibu butvnv vdwa, nyiga vdw, okv nyi vdwa gokkumto, ");
INSERT INTO tgj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","okv bunua minto, “Nonu so nyi sum ngoogvlo aagvpv, okv nw nyi vdwa rimur gvdu vla. Vjak, okv ngo nonugv kaaku so ninyia jwngkadaka toku, okv ngo ninyia nonugv minam gungnying akoka mapa yama. ");
INSERT INTO tgj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod ka ninyia rimur go mapa mato vkvlvga nw ninyia ngonu gvlo jikur duku. Ninyi mvkidubv rimur ako ka mapama. ");
INSERT INTO tgj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Vkvlvgabv ngo ninyi senyak pala mvrit mogvrila okv ninyi vngmu reku.” ");
INSERT INTO tgj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Vngbo dvmin pumja alu lori gv dwkia Pilot bunugv lvgabv patwklo tumla vnam nyi ako limu dukunv. ");
INSERT INTO tgj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nyipam lokv nyi mvnwngngv achialvbv gokla minto, “Ninyia mvkito! ngonugv lvgabv Barabasnyi limu toku!” ");
INSERT INTO tgj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasnyi patwk tumla vvpvto Pamtv arwnglo yalung dula gwngrw gwkunam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilot Jisunyi limu dukubv mvngto, vkvlvgabv nw nyipam vdwa lvko alvbv mindvto. ");
INSERT INTO tgj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Vbvritola bunu gokkorla minto, “Ninyia Daapolo takkito! Ninyia Daapolo takkito!” ");
INSERT INTO tgj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilot bunua lvom nvbv minto,, “Vbvritola nw ogu rimur go ripvla? Ngo ninyia mvki dubv ogu ka rimur go mapa yama! Ngo ninyia svnyak pala mvmu gvrila okv ninyia topu reku.” ");
INSERT INTO tgj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Vbvritola bunu Jisunyi Daapo lo takki rungto ka vla bunugv gaam v gamtvyayabv gokbwngto, okv goknyung nga bunu gokjik toku. ");
INSERT INTO tgj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Vkvlvgabv Pilot bunugv mingkubv Jisunyi lvklin jitoku. ");
INSERT INTO tgj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nw bunugv koonam nyi yvvdw yalung dukulo gwngrw gwto la patwk tumnam angaka topu jitoku, okv nw Jisunyi bunu gvlo laklwk jitoku bunugv mvngwngbv rimu dukubv vla. ");
INSERT INTO tgj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sipai vdwv Jisunyi vnggv toku, okv bunugv vngdungrilo, bunu Sairene lokv nyi ako aminv Saimon vnamgo mooku lokv pamtv bv aatv nvgo vngrwk sito. Bunu ninyia naatungto, Daapo nga nw gvlo joopvto, okv nw bakla Jisu kochinglo vngming gvdubv mvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Okv nyi vdwv achialvbv twngtv bv ninyia vngming gvtoku; bunu lokv nyi kvgunv anvnyimv vdwv nw gv lvgabv kapnv okv dwknv vdwv. ");
INSERT INTO tgj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisu bunua dakrwkto okv minto, “Jerusalem gv anvnyimv vdwa! Ngo gv lvgabv kapyo ka, vbvritola nonu atugv lvgabv okv nonugv kuu vdwgv lvga bvyaka. ");
INSERT INTO tgj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Vkvnv alu v aariku vdwlo nyi vdwv minreku, ‘Vdwgo gamdak dukunv yvv anvnyimv vdwloka kuu dooka manv, yvvka anga bvngka manv, yvv bunua soocha manv!’ ");
INSERT INTO tgj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","V alu vna vdwlo nyi vdwv moodw ditv am minre, ‘Ngonua gijap labv!’ okv dichingnv vdwa, ‘Ngonua girum labv!’ ");
INSERT INTO tgj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Vdwlo singnv ngv yajila leelak rilo vbv ritv kunv, vdwlo singku bolo ogubv rirekudw?” ");
INSERT INTO tgj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Rimurnv nyi anyi goka Jisu nyi lvkobv mvkidubv vla vnglin gvdvto. ");
INSERT INTO tgj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Vdwlo bunu “Dumku” vnam mooku gulo aalwk tokudw hoka bunu Jisunyi Daapo lo takki toku, okv rimurnv anyi aka, akonyi ninyigv lakbik tangvlo okv akonyi ninyigv lakchi tangvlo. ");
INSERT INTO tgj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisu minto, “Abu! bunugv rimur a mvngnga laka, bunu chima bunu ogugo ridudw.” Bunu ninyigv vji a amin chinkala baakminsuto ");
INSERT INTO tgj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nyi vdwv kaadung nyato vdwlo Jius nyi ringnv vdwgv ninyi nyarjikao mvri-hoka: “Nw kvvbi ha ringdu; nw atubongv ringsu momuto nw Pwknvyarnv gv gaknam Kristo ngvbolo!” ");
INSERT INTO tgj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sipai vdwvka ninyi nyarjikao dvto: bunu nw gvlo chaato okv ninyi opo vkv jito, ");
INSERT INTO tgj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","okv minto, “No Jius gv Dvbv ngvbolo no atuv ringsu laka!” ");
INSERT INTO tgj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ninyigv aolo svbv lvkla vvpvto: “So si Jiu vdwgv Dvbv ngv.” ");
INSERT INTO tgj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hoka daapolo takdala takpvnam nyi rimurnv akonv ninyia nyarjito: “No Kristo malare? No atuv ringsu tvka okv ngonua ka!” ");
INSERT INTO tgj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kvvbi akonv ninyi yamla minto “No Pwknvyarnvnyi busu malare? Nw gv rinam apiabv no ka paadu. ");
INSERT INTO tgj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ngonugv si rijik kv ogu lvga vbolo ngonu ogugo ripvdw um ngonu paadu; vbvritola nw ogu rimur goka rima.” ");
INSERT INTO tgj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Okv nw Jisu nyi minto, “Ngam mvngpa labvka, Jisu, vdwlo no Dvbv gubvrila aari kunyi!” ");
INSERT INTO tgj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisu hum minto, “Ngoona milv jidunv selu gv lokv no nga lvkobv nyidomooku tolo doore.” ");
INSERT INTO tgj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Doonyi chaato bv ritoku ho doonyi v nyiku mato okv mooku mvnwngngv gumta aom go kanvla dootoku; ");
INSERT INTO tgj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","okv Pwknvyarnv naam gv vji rvdala vvpv namv taknyi gubv takpin suto. ");
INSERT INTO tgj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisu gamtv rungbv gokla kapto, “Abu! Noogv laak lo ngoogv yalu a laklwk dukunv!” Nw vla minto okv sitoku. ");
INSERT INTO tgj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sipai nyigam angv ogugo ripvdw um kaatoku okv nw Pwknvyarnvnyi hartvla minto, “Jvjvbv nw alvnv nyi go!” ");
INSERT INTO tgj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Vdwlo nyi vdwv hoka dookumnv vdwv ogugo ripv kudw kaanam dvdv nga kaatokula, bunu mvnwngngv naam bv vngtoku, mvngdwk laila bunugv hakwng a kisu nyato. ");
INSERT INTO tgj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yvvbunudw Jisu nyi nyidum tungnyibv chinto kudw, anvnyimv Galili lokv ninyi vngming gvnv vdwv, adulo daktola kaaria nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Hoka Josep vnam nyi ako dooto nw Judia gv banggu, Arimatia lokv. Nw alvnv nyi go, mvngdwnam nyi go, nw Pwknvyarnv gv Karv gv aanama kaayala doonvgo. Nw kvba baanv gv nyi ako bv rijvka, nw bunugv minbwk nama okv rinam a tolwk mingv mato. ");
INSERT INTO tgj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nw Pilot gv dookulo aato okv Jisu gv svma nga kooto. ");
INSERT INTO tgj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Vbvrikunamv nw svma nga naalu toku, hum alvrungnv vji jebor v kvlap toku, okv um vlwnglo runglwknam nyibung svma lwkkw manam guloka joolwkla vvpv toku. ");
INSERT INTO tgj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ho alu v Gumpualu alu bv ritoku, okv Jius doonualu hv loorap tvvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galili lokv anvnyimv Jisu nyi vngming gvnv vdwv Josepnyi lvkobv vngtoku okv nyibung nga okv Jisugv svma ayak a oguaingbv hoka lwkpvdw hum kaatoku. ");
INSERT INTO tgj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vbvrikunamv bunu naam bv vngkur toku okv nampunv vkv mvpvripv toku svma ayak gv lvgabv. Pvbv gv minkubv, Jius doonu alu lo bunu doonu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Vjwngalu gv arukamchi bv anvnyimv vdwv nyibung lo vngto, bunugv mvnam nampunv vkv bvngla ila. ");
INSERT INTO tgj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nyibung agv aaku vlwng nga ngora rodubv bunu kaapa toku, ");
INSERT INTO tgj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","vkvlvgabv bunu arwnglo aatoku vbvritola bunu Ahtu Jisu gv svma nga kaapa kumato. ");
INSERT INTO tgj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bunu hum abwk kumabv hoka daktoku, lamdubv nyi anyigo achialvbv ungnv vji gvnv vkv bunu gvlo daklwkto. ");
INSERT INTO tgj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Anvnyimv vdwv, achialvbv busu laila bunu kwdilo guplwk toku, nyi anyiv anvnyimv vdwa svbv minto, “Turkunv nyi anga sinv vdwlo nonu ogubv kaakar dunv? ");
INSERT INTO tgj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nw si dooma; nw turrap roku. Galili lo nw gv riri hoka nonua ogugo nw minpvdw hum mvngpa toka: ");
INSERT INTO tgj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Nyia Kuunyilo nga rimurnv nyi vdwgv laak lo laklwk reku, hum daapo lo takki reku, okv alu loum kochingbv turkur reku.’” ");
INSERT INTO tgj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Vbvrikunamv anvnyimv vdwv nw gv minam a mvngpa toku, ");
INSERT INTO tgj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","nyibung lokv vngkur toku, okv ogumvnwngnga lvbwlaksu vring gola akin vdwa minpa toku okv kvvbi mvnwng haka. ");
INSERT INTO tgj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Anvnyimv vdwv Meri Magdalene, Joana, okv Jems gv anv Meri; bunu okv bunua vngming gvnv kvvbi anvnyimv vdwvka ogu mvnwng sam apostol vdwa minpa toku. ");
INSERT INTO tgj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Vbvritola apostol vdwv anvnyimv vdwgv minam si minamminsubv mindu nvgo vla mvngtoku, okv bunu anvnyimv vdwa mvngjwng mato. ");
INSERT INTO tgj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Vbvritola Pitar dokrap toku okv nyibung bv joktoku; nw gublwk toku okv vji kvlap kvchap nvnv jebor a kaapa nyumtoku okv ogu ka kaama toku. Vbvrikunamv ogugo ripv kudw hum lamrw palaku nw naam bv vngkur toku. ");
INSERT INTO tgj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ho gv alu akin hoka Jisunyi riming gvnv anyigo nampum aminv Emmaus vnamlo vngdubv vla vngdungto, hv Jerusalem lokv adu v kilomitar vring gola akin gubv rito, ");
INSERT INTO tgj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Okv bunu ogugo ripv kudw ho mvnwng gv lvga nga raamisito. ");
INSERT INTO tgj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Vbv bunu raami sula okv mimi surilo Jisu nyi atu v bunugv nvchilo aanwkto okv bunua lvkobv vngming gvto; ");
INSERT INTO tgj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","bunu ninyia kaato, vbvritola ninyia kaabwk mato. ");
INSERT INTO tgj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisu bunua minto, “Ogugola, nonugv vngying dula raami svgv dvnammv?” Bunu mvngdwk dula, dakbwngto. ");
INSERT INTO tgj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bunugv lokv akonvgv aminv Kleopas vnam hv ninyia tvvkato, “No Jerusalem so kaalwkbv aanv vmwngre sogv lonyi loum sokv ogu rinama chima dunv?” ");
INSERT INTO tgj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nw tvvkato, “Ogu gula?” Bunu mirwkto, “Najaret lokv Jisunyi rinam mamnv,” “So nyi angv si nyijwk go nw Pwknvyarnv nyila okv nyi mvnwngnga mvngpu dubv rila, ninyigv rinam minam mvnwngngv jwkrw doonv gubv okv kairungnv nyijwk gubvrila kaatam toku. ");
INSERT INTO tgj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ngonugv nyibu butvnv vdwv okv rigvdogvnv vdwv ninyia mvki tuku vla laklwk la lvklin jitoku, okv ninyi daapolo takki toku. ");
INSERT INTO tgj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Okv ngonu ninyia Israel am ringlin laji kunv vla mvngtin nyato! hum mvnwng am mimabv, vbvrikunamv silu si alu loum dukunv. ");
INSERT INTO tgj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Anvnyimv megonv ngonua lamrwpamupv; bunu doonyi nyika dubv nyibunglo vngto, ");
INSERT INTO tgj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Vbvritola ninyigv svma nga kaapama. Bunu vngkorla mintoku bunu nyikrw bv nyidogingdung vdwa kaapvnv ho vdwv nw turkur pvkunv vla bunua mintam toku. ");
INSERT INTO tgj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ngonugv lokv megonv nyibunglo vngla kaanam v anvnyimv vdwgv minam rungbv kaapatoku, vbvritola bunu ninyia kaapa mato.” ");
INSERT INTO tgj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Vbvrikunamv Jisu bunua mintoku, “Vdwgo nonu pvcha dukunv, nyijwk vdwgv minam a nonu mvngjwng dubv tapv dunv! ");
INSERT INTO tgj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Hv Kristo ninyigv yunglit lo aanam lvgabv hinching chingma svngvri?” ");
INSERT INTO tgj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Okv Jisu ninyigv lvgabv Darwknv Kitap mvnwnglo Moses gv kitap lokv minrapla nyijwk vdwgv lvknam lobv minpv nama bunua minbwk jitoku. ");
INSERT INTO tgj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bunugv nampum vnglwkjiku gv nvchilo bunu vngrilo Jisu vbv ritoku nw adubv vngtv dvnv aingbv; ");
INSERT INTO tgj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Vbvritola bunu ninyia mintung gvrila, minto, “Ngonua lvkobv doomwng gvlaka; alu v tungtv yanv vngro pvku okv si kanv putv duku.” Vkvlvgabv nw doomwng gvdubv vla bunua vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nw bunua lvkobv dvmwng gvdubv vla dootung toku, vtwng nga naatoku, okv bokta doolwk dubv minto; vbvrikunamv nw vtwng nga pintung toku okv bunua jitoku. ");
INSERT INTO tgj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Vbvrikunamv bunugv nyik v nyiktar toku okv bunu ninyia kaachin toku, vbvritola nw bunugv kaaku lokv nyetoku. ");
INSERT INTO tgj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bunu mimisuto, “Lamtvlo nw gv ngonua gaam raarilo okv Darwknv kitap a minbwk jirilo ngonua vmv gunam jvbv rimapvi?” ");
INSERT INTO tgj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bunu vjakgobv gudungto okv Jerusalem lo vngkur toku, hoka bunu lvbwlaksu vring gola akin a paami sutoku kvvbi vdwa lvkobv doobam sidubv ");
INSERT INTO tgj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","okv minto, “Ahtu jvjv bv turrap rungpvku! Nw Saimon nyika kaarwk supv!” ");
INSERT INTO tgj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nyi anyiv lamtvlo ogugo ripv kudw hum bunua minpa jitoku, okv Ahtu gv vtwng nga pintung rilo bunu oguaing bv kaachin pvkudw humka. ");
INSERT INTO tgj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Vdwlo anyi gv sum mintam rilo, lamdubv Jisu atubongv bunugv dookulo daklwk toku okv bunua minto, “Nonu gvlo mvngpu v lvkobv doolaka.” ");
INSERT INTO tgj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bunu achialvbv lamrwpatoku bunu vram go kaadunv vla mvngto. ");
INSERT INTO tgj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Vbvritola nw bunua minto, “Nonu ogubv lamdunv? Ogubv so gv mvngjwng manamv nonugv haapoklo aapvnv? ");
INSERT INTO tgj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ngoogv lvpa okv ngoogv laak am kaatoka okv kaakato si ngo kuna. Ngam mvsit toka, okv nonu chinreku, nonugv ngam kaanam aingbv vram v adwnayak okv loobung gvma doonv.” ");
INSERT INTO tgj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nw vbv mintam toku okv nw gv lvpa okv nwgv laak am bunua kaatam toku. ");
INSERT INTO tgj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bunu vjaklodvbv mvngjwng nyuma toku, bunu achialvbv mvngpubv okv lamrwpanam bv ritoku; vkvlvgabv nw bunua tvkato, “Nonu so dvse go dooma lare?” ");
INSERT INTO tgj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bunu ninyia ngui nunv go jito, ");
INSERT INTO tgj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","hum nw naagvrila okv bunugv kaakulo dvtoku. ");
INSERT INTO tgj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Vbvrikunamv nw bunua mintoku, “So gv sum ngoogv nonua lvkobv riri hoka minam v: ngoogv lvga mvnwngnga Moses gv Pvbv lo lvkpv, nyijwk vdwgv lvknam loka okv mirimimpak minam loka v jvjvbv aarung jinv.” ");
INSERT INTO tgj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Vbvrikunamv nw bunugv haapok a Darwknv Kitap a chimu dukubv mvkok toku, ");
INSERT INTO tgj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","okv bunua minto, “So svbv lvkpvnv: Kristo hingching chirungre okv alu loum kochinglo sinam lokv turrap reku, ");
INSERT INTO tgj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","okv ninyigv amin lokv mvngdin okv rimur a mvngnga kunamgv doin a Jerusalem lokv rirap laila, mooku mvnwnglo japgo reku. ");
INSERT INTO tgj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nonu kuna so vdw sum mingo yajikunv. ");
INSERT INTO tgj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Okv ngo Atu v ngo Abu gv milv nama nonu gvlo jilu jire. Vbvritola nonu pamtv lo kaayala doorung laka aotolokv jwkrw v nonu gvlo aalwkma dvdvlobv.” ");
INSERT INTO tgj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Vbvrikunamv nw bunua pamtv agum lo lingv toku Betani jebv adu lo, hoka nw ninyigv laak v idungto okv bunua boktalwkji toku. ");
INSERT INTO tgj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nw bunua aya jidung dvla, nw bunua vngyu toku okv nyidomooku bv naacha toku. ");
INSERT INTO tgj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bunu ninyia kumtoku okv Jerusalem bv vngkur toku, kairungbv mvngpu puingla, ");
INSERT INTO tgj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","okv bunugv rinam doonam mvnwngnga Pwknvyarnvnaam lo Pwknvyarnvnyi umbonyikv vla relwkdoolwk toku.");
INSERT INTO tgj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nyiamooku a pwklin madvbv, Gamchargo doocho toku; Gamchar v Pwknvyarnv gv lvkobv dooto, okv Gamchar hv Pwknvyarnvnyi akinnv. ");
INSERT INTO tgj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Gamchar v doorap lokv Pwknvyarnv gv lvkobv dooto. ");
INSERT INTO tgj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ninyigv lokv Pwknvyarnv ogumvnwngnga pwklin to; pwknamyarnam mvnwng lokv ako daka ninyia dooma mogvrila mvnam go kaama. ");
INSERT INTO tgj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Gamchar v turnam gv linkubv rito, okv so turnam si nyi mvnwngnga loung naalwk jitoku. ");
INSERT INTO tgj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Loung ngv kanv lo ungto, okv kanv ngv hum vdwloka mvngit nyuma toku. ");
INSERT INTO tgj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pwknvyarnv ninyigv gindungpingko nga vngmuto, ho nyi gv aminv Jon, ");
INSERT INTO tgj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","hv nyi vdwa loung gv lvkwngbv minji tvbv aatoku, vkvlvgavbolo mvnwngngv doin a tvvgvrikula mvngjwng rungdukubv. ");
INSERT INTO tgj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hv atubongv loung mato; hv loung gv lvkwngbv minpa tvvbv aatoku. ");
INSERT INTO tgj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","So si jvjvbv alvyachoknv loung ngv—Loung ngv nyiamooku lo aatoku okv nyi mvnwnglo ungtoku. ");
INSERT INTO tgj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gamchar v nyiamooku lo dootoku, okv ninyigv lokv Pwknvyarnv ogumvnwngnga mvlin bvka, vbvrijvka nyia nyi vdwv ninyia kaachin matoku. ");
INSERT INTO tgj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hv atugv mooku lo aatoku, vbvritola ninyigv nyi vdwv ninyia naarwk sumato. ");
INSERT INTO tgj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Megonv, ninyia naarwk sutoku, okv ninyia mvngjwng toku; vkvlvgabv hv bunua Pwknvyarnv gv kuu bv ridubv tolwk toku. ");
INSERT INTO tgj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hv manv, bunu tanyi anvabu gv kuu bvngchwng lokv Pwknvyarnv gv kuu bv rima; Pwknvyarnv atubongv bunugv abu bv rito. ");
INSERT INTO tgj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Gamchar v nyi gobv rilin toku okv jvjv okv aya ngv yarbing nvgobv rila, ngonugv dookurikulo doomingriming gvto. Ngonu ninyigv yunglit nama kaatoku, ninyigv Abu gv Kuunyilo hotum gubvrila yunglit nvgobv paanam a. ");
INSERT INTO tgj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ninyigv lvkwngbv japjito. Hv kapla minto, “So si ngoogv minam v ngo vbv minto, ‘Hv ngoogv kochinglo aadu, vbvritola hv nga kaiyanv, ogulvgavbolo hv nga bvngma dwbv doolin chonv.’” ");
INSERT INTO tgj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Hv aya gv yarbing kolokv hv ngonu mvnwngnga achialvbv ayato, ako jidv gv aolo ako jitamla bokta jidv toku. ");
INSERT INTO tgj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses gv lokv Pwknvyarnv Pvbv nga jito, vbvritola jvjv okv aya ngv Jisu Kristo gvlokv aatoku. ");
INSERT INTO tgj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yvvka Pwknvyarnvnyi kaakw nvgo kaama. Kuunyilo mvngchik, Abu gvlo doonv, Pwknvyarnvnyi akin kunv, hv bunua Pwknvyarnvnyi chimu toku. ");
INSERT INTO tgj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem gv Jius rigvdakgvnv vdwv nyibu vkvla okv Lebait mego vngmuto, Jonnyi “No yvvla?” vla tvvka modubv. ");
INSERT INTO tgj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon mirwk siji makv vmato, vbvritola pvbwng vrwngbv minpok jitoku, svbv minto: “Ngo Kristo ma.” ");
INSERT INTO tgj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bunu tvkato, “Vbvrikunamv no yvvla? No Elija re?” “Ma, ngo ma,” Jon mirwkto. Bunu tvvkato, “No Nyijwk vri?” Hv mirwkto, “Ma”. ");
INSERT INTO tgj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Vbvrikunamv ngonua minjilabv no yvvla,” bunu minto. “Ngonu ngonua kanamnv vdwa vngkur dukula mirwk jireku.” “No atubongv ogu vla minsu dunv?” ");
INSERT INTO tgj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon Aijaya gv minam a mintaknvla mirwk sitoku: “Chukrimooku lo nyi ako gokdungdo ho vlv angv ngo: Ahtu gv lvgabv vngdubv lamtv nga sorchi dubv mvtoka!” ");
INSERT INTO tgj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Gindungpingko vdwv, Parisis vdwgv vngmukunam vdwv, ");
INSERT INTO tgj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","vbvrikunamv Jonnyi tvvkato, “No Kristo mabolo vmalo Elija vmaloka Nyijwk ngvma bolo, no ogubv Baptisma jidunv?” ");
INSERT INTO tgj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon mirwkto, “Ngo nonua isi lokv Baptisma jidunv, vbvritola nonugv pingkolo nonugv chimanam nyi go daklinre. ");
INSERT INTO tgj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hv ngoogv kochinglo aadungdu, vbvritola ngo ninyigv lvkiam gv oso haka taasok yadubvka riyin yama.” ");
INSERT INTO tgj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","So mvnwng si Betani lo ritoku Jordan svko gv doonyi chaalin kiambv, Jon gv baptisma jidung kolo. ");
INSERT INTO tgj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Alu loogu nvnga Jon Jisunyi ninyi gvlo aadu bv kaagv rikula minto, “Hvvnv Pwknvyarnv gv svlarkuu ngv nyiamooku gv rimur a naa jikunv! ");
INSERT INTO tgj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","So siinv ngoogv minamv, ‘Nyi go ngo kochingbv aadungdu, vbvritola hv nga kaiyanv, ogulvgavbolo hv nga bvngma dwbv doolinchonv.’ ");
INSERT INTO tgj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngo chimato hv yvvdw, vbvritola ngo Israel nyi vdwa ninyia chimu dubv vla isi lokv baptisma jila aapvnv.” ");
INSERT INTO tgj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Okv Jon so gv gaam sum minji toku: “Ngo nyido ao tolokv Darwknv Dow v taakw jvbv ritola nw gvlo jarlwkla doodubv kaatoku. ");
INSERT INTO tgj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hvkunyi vla vjaklodvbv ngo chima toku, vbvritola Pwknvyarnv, yvvdw nga isi lokv baptisma jidubv aamunv, hv nga svbv minto, ‘No Dow a ila nyi ako gvlo doolwk dubv kaapare; ho nyi angv Darwknv Dow lokv baptisma jiji kunv.’ ");
INSERT INTO tgj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Um ngo kaatoku,” Jon minto, “Okv ngo nonua minjidunv hv kunv Pwknvyarnv gv Kuunyilo ngv.” ");
INSERT INTO tgj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Alu loogu nvnga Jon ninyigv Lwbwlaksu anyia lvkobv hoka lvkodv dakdvto, ");
INSERT INTO tgj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Vdwlo hv Jisunyi hoka vngdubv kaapa tokudw hv minto, “Vnv Pwknvyarnv gv Svlarkuu ngv!” ");
INSERT INTO tgj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lwbwlaksu anyiv ninyia svbv mindubv tvvgvrikula Jisunyi lvkobv vngming gvtoku. ");
INSERT INTO tgj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisu dakur toku, okv bunua ninyia vngming gvdubv kaato, okv tvvkato, “Nonu ogugola kaadung dunv?” Bunu mirwkto, “Rabbi, no ogulo doodunv?” (Rabbi vnam si “Tamsarnv” vla minam v). ");
INSERT INTO tgj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Hv mirwkto, “Aala kaatoka.” (Vbvrikunamv ho doonyiv tabv laku api baji toku.) Vkvlvgabv bunu ninyia vngming gvtoku okv ninyigv dooku a kaatoku, okv ho alu lo ninyia lvkobv doomwng gvtoku. ");
INSERT INTO tgj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Bunugv lokv akonv Andriu, Saimon Pitar gv boru. ");
INSERT INTO tgj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Vjakgobv ninyigv achi Saimonnyi kaapa toku okv ninyia minto, “Ngonu Messianyi paapvku.” (So gv minam si “Kristo”) ");
INSERT INTO tgj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Vbvrikunamv hv Saimonnyi Jisu gvlo aagv toku. Jisu ninyia kaatoku okv minto, “No gv aminv Saimon Jon gv kuunyilo, vbvritola nam Kepas vla minreku.” (So minam si Pitar vla minam a akin v, “Vlwng lvngrak vnammv.”) ");
INSERT INTO tgj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Alu loogu nvnga Jisu Galili lo vngdubv mvngtoku. Hv Pilipnyi kaapato okv ninyia minto, “Ngoogv lvkobv vngming gvlaak!” ");
INSERT INTO tgj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip Betsaida lokv, Pitar gvla Andriu gv dooku banggu akin gvngv. ");
INSERT INTO tgj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip Natanael nyika kaapa toku okv ninyia minpa toku, “Ngonu Pvbv kitaplo Moses gv lvknam okv nyijwk vdwgv lvkpanam nyi anga paapvku. Hv Jisu Josep gv kuunyilo, Najareth lokv.” ");
INSERT INTO tgj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Najareth lokv alvnv yikungyira ngv linla dunvdw?” vla Natanael tvkato. Pilip mirwkto, “Aato okv kaalak.” ");
INSERT INTO tgj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Vdwlo Jisu Natanaelnyi ninyi gvlo aadukubv kaatokudw nyi ho gv lvgabv minto, “Siinv Israel nyi jvngv; ninyi gvlo mvvnamrunam go kaama!” ");
INSERT INTO tgj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael ninyia tvkato, “No nga oguaingbv chimpvnv?” Jisu mirwkto, “Pilip gv nam gokma dwbv ngo nam koksitkokrik singnv kolv lo doodubv kaato.” ");
INSERT INTO tgj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael mirwk sitoku, “Tamsarnv,” “No kunyi Pwknvyarnv gv Kuunyilo ngv! No Israel gv Dvbv ngvku!” ");
INSERT INTO tgj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisu minto, “Nam ngo koksitkokrik singnv kolv lo kaapvnv vnam lokv no nga mvngjwng mvngdunvre? No sumka kaiyanv awgo kaapare!” ");
INSERT INTO tgj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Okv nw bunua minto, “Ngo nonua jvjv nvnga minjidunv: nonu nyidomooku agi hv kokok dubv okv Pwknvyarnv gv Gindungpingko ngv Nyia Kuunyilo gvlo ila chaala ridubv kaapare.” ");
INSERT INTO tgj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Alu lonyi kochingbv Galili gv banggu Kana lo nyida go rito. Hoka Jisu gv Anv ngv dooto, ");
INSERT INTO tgj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","okv nyida hoka Jisu nyila okv ninyigv lvbwlaksu vdwa gokto. ");
INSERT INTO tgj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vdwlo anggor ala nga jinya pvkudw, Jisu gv anv ngv ninyia minto, “Bunu gvlo anggor ala kaakuma.” ");
INSERT INTO tgj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Ogugo rise ngvdw no ngam mingkwng svgo kaama,” Jisu mirwkto. “Ngo gv dw ngv vjak aatv madv.” ");
INSERT INTO tgj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jisu gv Anv ngv pakbu vdwa minto, “Hv ogugo nonua minredw ritoka.” ");
INSERT INTO tgj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jius vdwv pvbv doola arwanyu harkak nanvbv, hoka takam pvchwng vkv pwkv go dooto, pvchwng pwkinnv kai ngv isi laajok lvngbv go aajinv vkv. ");
INSERT INTO tgj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisu pakbu vdwa minto, “Pvchwng vdw soka isi lokv pwbing tvka.” Bunu pvchwng lvnggung lo godubv pwbing to, ");
INSERT INTO tgj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","okv vbvrikunamv hv bunua minto, “Vjak isi kvgonyi joklin gvrila nyida nga rigvnv nyi hum jitoka.” Bunu isi a ninyi bvngji toku, ");
INSERT INTO tgj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","hv vjak anggor ala bv ritoku, okv nw hum tvngka toku. Hv anggor ala hv ogolokv aapvnvdw hum nw chimato (vbvritola, isi a joklinnv pakbu vdwv chinto); vkvlvgabv hv makbu rijinv anga goklwkto ");
INSERT INTO tgj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","okv minto, “Nyi mvnwngngv tvngpunv anggor ala alvyanv nga jicho dvnv yikv, okv nyen vdwgv tvnggu dubv tvngro kochingbvku, hv sarchik nvnga jidunv. Vbvritola nonu vjaklodvbv anggor ala alvyachok nvnga doobwng mopv!” ");
INSERT INTO tgj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisu so lamrwpadubv mvnam a Galili gv kana lo riturike bv rito; hoka hv ninyigv kai nama kaatam toku, okv ninyigv lvbwlaksu vdwv ninyi mvngjwng toku. ");
INSERT INTO tgj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","So kochingbv, Jisu okv ninyigv Anv, achiboru vdwv, okv ninyigv lvbwlaksu vdwv Kaparnaum bv vngtoku okv hoka lonyi loum go dootoku. ");
INSERT INTO tgj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","So si vngbokunam pumja ridwv nvchibv ritoku, vkvlvgabv Jisu Jerusalem bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hoka Pwknvyarnvnaam arwng lo svv pioknv nyi, svlar, okv taakw, okv morko lwkmisinv vdwa tvbul lo doodubv hv kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Vkvlvgabv hv svnwngsvmin mvnwngnga bangngi lokv dvnggvrila Pwknvyarnvnaam loka charlin toku, svlar okv svv vdwaka; hv morko lwknv vdwgv tvbulla ngora jito okv bunugv morko lokdwng ngv kaayak padubv mvtoku; ");
INSERT INTO tgj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","okv hv taakw pyoknv nyi vdwa minto, “Bunua sokv agumlo bvngroto! ngo abu gv naam a bajar mookubv mvku mabvka!” ");
INSERT INTO tgj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ninyigv lvbwlaksu vdwv mvngpa nyatoku Darwknv Kitaplo mindu, “Ho Pwknvyarnv no gv naam ha ngoogv mvngbiula kumnam si vmv jvbv gudu.” ");
INSERT INTO tgj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jius nyi kainv vdwv Jisunyi mirwkla tvuto, “No sum rila dunv vla ngonua ogu lamrwpanam go rila kaatamre?” ");
INSERT INTO tgj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisu mirwkto, “So Pwknvyarnvnaam sum toyak tvka okv ngo alu loum lo sum mvdi jiriku.” ");
INSERT INTO tgj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“No alu loum lo sum mvdi jitv dunvre? Vla bunu ninyia tvvkato. Sum Pwknvyarnvnaam sum mvdubv anying champi gola nyingkv gobv ripvnv!” ");
INSERT INTO tgj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Vbvritola Jisu gv Pwknvyarnvnaam vnam si ninyigv ayakka minpvnv. ");
INSERT INTO tgj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Vkvlvgabv vdwlo nw sinam lokv turkur tokudw, ninyigv lvbwlaksu vdwv nw sum minpvnv vla mvngpa toku, okv bunu Darwknv Kitap okv Jisu ogugo mimpvkudw hum mvngjwng toku. ");
INSERT INTO tgj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Vngbodvnam pumja lo Jisu gv Jerusalem lo doolwk dvla, ninyigv lamrwpadubv mvnam rinam a kaala awgo nyi vdwv ninyia mvngjwng toku. ");
INSERT INTO tgj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Vbvritola Jisu atubongv bunua mvngjwk matoku, ogulvgavbolo hv bunu mvnwngnga chintoku. ");
INSERT INTO tgj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hoka bunugv lvgabv yvvka ninyia minji sego kaamato, ogulvgavbolo bunugv haapok arwnglo ogugo doopvdw hum atuv chinsu toku. ");
INSERT INTO tgj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hoka Jius vdwa rigvnv nyi go aminv Nikodemas vnamgo dooto, hv Parisis haalung lokv. ");
INSERT INTO tgj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ayu yupgolo hv Jisu gvlo vngto okv ninyia tvvkato, “Tamsarnv, ngonu chindu Pwknvyarnv nam tamsarnvbv vla vngmupvnv. Yvvka no gv rinam vbv lamrwpadubv rinam a rinyu mare Pwknvyarnv ngv ninyia lvkobv dooming gvma bolo.” ");
INSERT INTO tgj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisu mirwksito, “Ngo nam jvjvbv mindunv; Lvnyibv kuu bvngdi kuma bolo yvvka Pwknvyarnv gv Karv nga kaapa kumare.” ");
INSERT INTO tgj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Nyi ngv nyigabv rikunv oguaingbv bvngdi kodu kubv?” Nikodemas tvvkato. “Hv lvkodv bvngdi kodu kubv vla anv gv namam lo aala nyuku mare!” ");
INSERT INTO tgj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","“Ngo jvjvbv nam mindunv,” Jisu mirwkto. “Yvvka Pwknvyarnv gv Karv lo vdwloka aanyu mare isi okv Darwknv Dow lokv bvnglin kuma dvdvlo. ");
INSERT INTO tgj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nyi v anvabu lokv bvngnam v nyi amarbv ridunv, vbvritola Darwknv Dow lokv bvngnam v dow bv ridunv. ");
INSERT INTO tgj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ngo gv nonu mvnwngnga kuu bvngdi kolaka vnam a no lamrwpamabvka. ");
INSERT INTO tgj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Doori v ogolo ridubv mvngdudw hoka ridu; nonu ho gv adua tvvpa nyumdo, vbvritola nonuno chima v ogo lokv aapvnvdw okv ogolo vngdu nvdw. Dow lo kuu bvngnam v mvnwng v ho apiabv ridunv.” ");
INSERT INTO tgj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemas tvvkato, “Si oguaingbv rinyu dunv?” ");
INSERT INTO tgj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisu mirwkto, “No Israel gv kainv tamsar nvgobv ridu, vbvritola no sum chima dunvre? ");
INSERT INTO tgj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ngo jvjvbv nam mindunv: ngonu ogugo chindudw hum mindu okv ogugo kaadudw hum minpa jido, vbvritola nonuno yvvka ngonugv doin a naarwk sinv kaama. ");
INSERT INTO tgj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Vdwlo ngo nyiamooku gv lvgabv nam minji renyi no nga tvjwngmanv; oguaingbv no tvjwng dukubv vdwlo ngo nyidomooku gv lvgabv nam minji rikunyi? ");
INSERT INTO tgj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nyia Kuunyilo nyidomooku tolokv inv mvngchik, ho lvvya yvvka nyidomooku ao tolo chaakwnv kaama.” ");
INSERT INTO tgj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Chukrimooku lo Moses gv daachwng tabwa svngtung ao golo timpvto, vbvdvdvbv Nyia Kuunyilo ngamka aolo timpv rungre, ");
INSERT INTO tgj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","vkvlvgabv yvv mvnwngngv ninyi mvngjwng rikudw v turbwngnv singnam a paare. ");
INSERT INTO tgj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pwknvyarnv nyiamooku a achialvbv pakla ninyigv Kuunyilo akin mvngchik a jitoku, vkvlvgabv yvvdw ninyia mvngjwng rinv v simare vbvritola turbwngnv singnam a paare. ");
INSERT INTO tgj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pwknvyarnv ninyigv Kuunyilo nga nyiamooku so gv nyi vdwa jwngkadaka yanv gubv imu ma, vbvritola ringyanv gubv imu pvnv. ");
INSERT INTO tgj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yvvdw Kuunyilo nga mvngjwng rekunv bunua jwngkadaka kumare; vbvritola yvbunudw mvngjwng marinv ho vdwa jwngkadaka roku, vkvlvgabv vbolo hv bunu Pwknvyarnv gv Kuunyilo akin a mvngjwng kuma. ");
INSERT INTO tgj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jwngkadaka ngv svbv rireku: loung ngv nyiamooku so aatoku, vbvritola nyi vdwv loung nga kaiyabv kanv yanga mvngbiu yatoku, ogulvgavbolo bunugv rinam mvngnam v alvmatoku. ");
INSERT INTO tgj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yvvdw alvmanv nga ridunv hv loung nga kaanwng madunv, okv lounglo aamadunv, ogulvgavbolo ninyibunugv alvmabv rinam a kaatam nwngma dunv. ");
INSERT INTO tgj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Vbvritola yvvdw jvjv rungnv nga ridunv, hv lounglo aadunv, ninyibunugv Pwknvyarnv gvlo mvnglwkkaalwk bv rinam a kaatam dubv vla. ");
INSERT INTO tgj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","So kochingbv Jisu okv ninyigv lvbwlaksu vdwv Judia mookubv vngtoku, hoka bunua lvkobv achukgo relwk tvkula okv nyi vdwa baptisma naamu toku. ");
INSERT INTO tgj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hoka Jon ka Ainon nampum lo Salem vnam lokv adumako lo baptisma jidungla reto, ogulvgavbolo ho mooku hoka isi v kaigo dookunam lvgabv nyi vdwv Jon gvlo baptisma jiku dubv vla aatoku, hv bunua hoka baptisma jitoku. ");
INSERT INTO tgj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","So si Jonnyi patwk lvkma dwbv ripvnv. ");
INSERT INTO tgj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jon gv lvbwlaksu megonv darpudvbv sokbwngnam lvkwngbv Jius nyi gonyi larmi surapto. ");
INSERT INTO tgj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Vkvlvgabv bunu Jon gvlo vngtoku okv minto, “Tamsarnv, no mvngpa dukudw Jordan takdv gv doonyi chaaku kyamgv nam lvkobv rinv nyi, okv yvvgv lvgabv no mindudw? Alvdo, hv nyi vdwa baptisma jiduku okv nyi mvnwngngv hvkv gvlo vngdung duku!” ");
INSERT INTO tgj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon mirwkto, “Yvvka ogugo doogv nyuma vdwlo Pwknvyarnv hum ninyi jima dvdvlo. ");
INSERT INTO tgj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nonu ngoogv minam ha tvvnvkaanv pingko nyi vdwv, ngo minto ‘ngo Kristo ma, vbvritola ngam ninyia vngcho yamu pvnv.’ ");
INSERT INTO tgj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nyimv nyamjibongv paapum gvjinv gvbv ridu; vbvritola paapumgvjinvgv ajin v, dakdula tvrianv, himpu yadu vdwlo hv paapumgvjinvgv gaam a tvvpa rikudw. Svbv dvdvbv ngo atubogv mvngpuv punya dukunv. ");
INSERT INTO tgj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hv kaiyaya rungre, ngo miang yaya rungre.” ");
INSERT INTO tgj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hv nyido mooku tolokv inv mvnwngnga kaiyadunv. Hv yvvdw Siching sokvdw Siching so gvbv ridunv okv Sichingmooku lvgabv mindu, vbvritola hv yvvdw nyido mooku tolokv idunv mvnwngnga kaiyanv. ");
INSERT INTO tgj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hv minpado ogugo hv kaapvdw okv tvvpvdw, vbvrijvka yvvka ninyigv doin ha torwk sinv kaama. ");
INSERT INTO tgj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Vbvritola yvvdw ninyigv doin ha naarwk sidunv hv Pwknvyarnv jvjv rungnv ngv vla chindu. ");
INSERT INTO tgj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yvvnyi Pwknvyarnv vngmu pvdw hv Pwknvyarnv gv gaam a mindu, ogulvgavbolo Pwknvyarnv ninyigv Darwknv Dow ha ninyi gvlo jinya chekala jito. ");
INSERT INTO tgj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Abu ninyigv Kuunyilo nga pakdu okv ogumvnwng nga ninyigv laak lo jilwk toku. ");
INSERT INTO tgj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yvvdw Kuunyilo nga mvngjwng dunv turbwngnv singnam ha paare; yvvdw Kuunyilo gv minam ha tvvma dunv hv singnam a paamare, vbvritola Pwknvyarnv gv mvritririt jiku arwng lo doore. ");
INSERT INTO tgj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisi vdwv Jisu Jonnyi kaiyabv nyi naalwkla okv baptist jidu vla tvvpato. ");
INSERT INTO tgj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Minje jvbolo Jisu atuv yvvnyika baptisma jimato; ninyigv lvbwlaksu vdwv mvngchik jito. ");
INSERT INTO tgj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Vkvlvgabv vdwlo Jisu ogugo minpvdw tvvtoku, hv Judia nga vngyula okv Galili bv vngkur toku; ");
INSERT INTO tgj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ninyigv vngku lamtv ngv Samaria bv vngpitla vngdubv rito. ");
INSERT INTO tgj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria lo Sikar vnam banggu lo hv aalwk toku, ho Jakop gv ninyigv kuu Josepnyi jinam rongo lokv adu mato. ");
INSERT INTO tgj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jakop gv isikua ngv hoka dooto, okv Jisu, moing vngkunamv anyu kuma toku, isi kua hoka dootungla doonu toku. Vbvrire hoka alu lopo bv rito. ");
INSERT INTO tgj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaritan nyimv gonv isi mego tokdubv hoka aato, okv Jisu ninyia minto, “Nga isi tvngse go jilabv,” ");
INSERT INTO tgj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ninyigv lvbwlaksu vdwv dvnam rvvbv banggu lo vngyu roto. ");
INSERT INTO tgj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nyimv angv mirwksito, “No Jiu go, okv ngo Samaritan nyimv go—vkvlvgabv no oguaingbv nga tvngnamgu koodunv?” (Samaritan vdwgv dvnv tvngnvnv koobu okv bati vdwa Jius vdwv dvnv tvngnv madunv.) ");
INSERT INTO tgj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisu mirwksito, “No Pwknvyarnv gv jinam a okv nam isi tvngse go koodudw ninyia chinv guilo, no ninyia koya dvnvpv, okv hv nam turgvnv isi a jiri nvpv.” ");
INSERT INTO tgj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nyimv angv minto, “Tamsarnv, no isi toknvnv bvngma, okv isi kua ngv arwng chekwng do. Ogolo no turnvnv isi a paala dubv? ");
INSERT INTO tgj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Si ngonugv abuapa Jakob gv ngonua isi kua jinammv; ninyi okv ninyigv kuunyilo, okv ninyigv sonam svnwngsvmin mvnwngngv soka tvngnya pvnv. No atuv Jakobnyi kaiyanv gubv minsu dunvre?” ");
INSERT INTO tgj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisu mirwksito, “Yvvdw so gv isi a tvngdunv hv tvngnwng nwngkor reku, ");
INSERT INTO tgj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Vbvritola yvvdw ngoogv isi jinam ha tvngdunv hv vdwloka tvngnwng nwngkor kumare, ngoogv ninyia isi jinammv ninyigv lvgabv isi boklin sinv aingbv rila ninyi singnam a turnam jinv isi gubv rire okv ninyi turbwngnv singnam a jire.” ");
INSERT INTO tgj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nyimv angv ninyia minto, “Tamsarnv, ho isia ngam jilabvkv! vbvrikubolo ngo vdwloka tvngnwng mvngkor kuma dukubv, okv soka isi tokbv aakwng kuma dukubv.” ");
INSERT INTO tgj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisu ninyia minto, “No vngyila no gv nyilua gokte kuka, okv aakur lakuka.” ");
INSERT INTO tgj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hv mirwkto, “Ngo nyilu guka kaama.” Jisu mirwk sutoku, “Noogv ngo nyilu kaama vla minam v no jvjvbv mirungdo. ");
INSERT INTO tgj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","No nyi angu go nyilubv mvtoku, okv noogv vjak lvkobv doogvnam nyi angvka noogv nyilu jvjvma. No nga jvjvbv minpa gvibv.” ");
INSERT INTO tgj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nyimv angv minto, “Tamsarnv, ngo kaanam v no nyijwk go,” ");
INSERT INTO tgj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Ngoogv Samaritan abuapa vdwv Pwknvyarnvnyi so moodw so kumtojotoku, vbvritola nonu Jius vdwv Jerusalem v ngonugv Pwknvyarnvnyi kumjijojiku mooku v vla mindo.” ");
INSERT INTO tgj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisu ninyia minto, “Nyimv, nga mvngjwng tvka, vkvnv aluv aariku nyi vdwv Abunyi so moodw sokaka kumnyajonya kumare vmalo Jerusalem loka kumnyajonya kumare. ");
INSERT INTO tgj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nonu Samaritan vdwv jvjv rungbv chima nonu yvvnyi kumdujodu nvdw; vbvritola ngonu Jius vdwv chindu ngonu yvvnyi kumdujodu nvdw, ogulvgavbolo so si Jius lokv ringlinbaalin v aadu. ");
INSERT INTO tgj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Vbvritola aluv aariku okv vjak si doopv, Pwknvyarnv gv Dow gv jwkrw lokv nyi vdwv Abunyi jvjvbv kumlajola, ninyigv mvnglwk kaalwkbv kumrejoreku. ");
INSERT INTO tgj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pwknvyarnv Dowbv ridunv, okv yvv ninyia kumdujodunv hv jvjv rungbv okv dow bv kumlajola rirung sego.” ");
INSERT INTO tgj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nyimv angv ninyia minto, “Ngo chindu Kristo aariku, okv vdwlo hv aarikudw, hv ogumvnwng nga ngonua minbwk jireku.” ");
INSERT INTO tgj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisu mirwk sutoku, “Hv dv ngo mabv, nam lvkobv raamisidunv.” ");
INSERT INTO tgj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Vbvrire hoka Jisu gv lvbwlaksu vdwv aakur toku, okv bunu ninyia nyimv gonyi raami sudubv kaala kairungbv lamrwpanya toku. Vbvritola bunugv lokv yvvka nyimv anga “No ogugo mvngdu?” Vla minv kaamato, vmalo Jisu nyika “No ogubv nyimv anga raami sudunv?” vla tvvka nvgoka kaamato. ");
INSERT INTO tgj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Vbvrikunamv nyimv angv isi pvchwng nga kayupila, banggubv vngkur toku, okv hoka nyi vdwa mintoku, ");
INSERT INTO tgj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aato okv nyi anga kaakwto ngoogv ogugo rikunam mvnwngnga minpa nvgo. Kristo vnammv v bri?” ");
INSERT INTO tgj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Vkvlvgabv bunu banggu a kayupila okv Jisu gvlo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Vbvridung rilo lvbwlaksu vdwv Jisunyi dinchi rungbv minto, “Tamsarnv, dvnam go dvlakv!” ");
INSERT INTO tgj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Vbvritola hv mirwkto, “Ngoogvlo nonugv chimanam dvnam v doodu.” ");
INSERT INTO tgj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Vkvlvgabv lvbwlaksu vdwv bunugv aralo tvka minsunyato “Nyi gunv ninyia dvnamgu bvnglwk jipv nvgu bri?” ");
INSERT INTO tgj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisu bunua minto, “Ngoogv dvnam hv Pwknvyarnv gv mvngkubv rinam angv nw ngam vngmunv okv ngo ninyigv rimidubv jinam ha rirungre. ");
INSERT INTO tgj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nonu mimbwng namgo doodu, ‘Poolu pwpi go doodvdu aam nvdwv’vla. Vbvritola ngo nonua mindunv, rongo nga alvbv kaatoka; rongo gv aam hv nginduku okv nvvdubv riduku! ");
INSERT INTO tgj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yvvnyiv aam nvvpvdw nvvjo nga paadu okv turbwng gvnv dubv nvvchingla vvpvdu, ho hv lvvlwk nvla nvvchingnv lvkobv himpu pubam dubv vla. ");
INSERT INTO tgj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‘Nyi akonv lvvriare nyi akonv nvvching riare’ vnam si jvjv rungdo. ");
INSERT INTO tgj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngo nonugv rongo nyingma kolo nonua aam nvdubv vngmuto; kvvbi vdwv hoka nyingdu okv nonuno boksi paayadu.” ");
INSERT INTO tgj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Achialvnv Samaritan nyi vdwv Jisu nyi mvngjwng toku ogulvgavbolo nyimv angv minto, “Ngoogv ogumvnwng riku nama hv ngam minpa toku.” ");
INSERT INTO tgj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Vkvlvgabv vdwlo Samaritan vdwv hv golo aatokudw bunu ninyia dinchi rungbv minto bunua lvkobv dooming gvdubv, okv Jisu hoka alu lonyi go dootoku. ");
INSERT INTO tgj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Achialv nyi go ninyia mvngjwng toku ninyigv doin a tvgvrila. ");
INSERT INTO tgj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Okv bunu nyimv anga mintoku, “Ngonu vjak mvngjwng dukunv, noogv minam lokvma, ngonu atuv ninyi gvlo tvvnam lokv okv ngonu chinduku jvjvbv hv nyiamooku gv Ringnvbaanv gorung.” ");
INSERT INTO tgj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Hoka alu lonyi go dooro kochingbv, Jisu vngraplaku okv Galili bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Hv atubongv minsuto, “Nyijwk ka atubogv mooku lo mvngdv madunv.” ");
INSERT INTO tgj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Vdwlo hv Galili lo vngchi tokudw, nyi vdwv ninyia alvrungbv aamu toku, ogulvgavbolo bunu Jerusalem lo vngbo pumja hoka vngtoku okv ho pumja hoka bunu ninyigv rinam mvnwngnga kaatoku. ");
INSERT INTO tgj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Vbvrikunamv Jisu Galili gv Kana nampum lo vngkur toku, ninyigv isi ha anggor ala bv mvku hoka. Sorkari nyigam go hoka dooto ninyigv kuunyilo ngv Kaparnaum lo lvvma toku. ");
INSERT INTO tgj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Vdwlo hv Jisu Judia lokv Galili lo aapv vla tvvpa pvkudw, hv Jisu gvlo aala okv ninyia tvvkato Kaparnaum bv vngla ninyigv kuunyilo sida svngv bv rinv nga mvpu jilabv vla dinchi rungbv minto. ");
INSERT INTO tgj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisu ninyia minto, “Nonu, yvvka mvngjwng mare vdwlo nonu kaasartabo okv lamrwpanam go kaama dvdvlo.” ");
INSERT INTO tgj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nyigam angv mirwkto, “Tamsarnv, nga lvkobv vngming gvcholabv ngoogv kuunyilo ngv sitv madvlo.” ");
INSERT INTO tgj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisu ninyia minto, “Vngnyila, no gv kuunyilo ngv turriku!” Nyi angv Jisu gv minam a mvngjwngto okv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ninyigv nampum lamtv hoka ninyigv pakbu vdwv ninyia kaarwksula yunying nga gvjito, “No gv kuunyilo ngv turduku!” ");
INSERT INTO tgj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hv bunua tvvkato vdwlola ninyigv kuunyilo ngv alvyakunamv, okv bunu mirwkto, “Doonyi hv chaanyala tabv rilo tamiramhv ninyia liu toku.” ");
INSERT INTO tgj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Vbvrikunamv abu angv mvngpa toku, ho dw lo Jisu gv ninyia “No gv kuunyilo ngv turriku,” vla mindwbv ritoku. Vkvlvgabv hv la okv ninyigv nyimv kuu vdwv mvngjwng nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judia lokv Galili bv aaro kochingbv si Jisu lvnyi naabv lamrwpadubv rila kaatam namv. ");
INSERT INTO tgj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","So kochingbv, Jisu dormo pumja lvgabv Jerusalem bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem gv svlar agi nvchilo svpar pargo dooto taabio angu goka dooto; Hebru gaam bv um Betjata vla minto. ");
INSERT INTO tgj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lvvmanv nyipam go taabio lo karpv nyato—nyikchingnv, lvpiknv, okv digwngnv. Bunu isi gv binam a kayala dooto, ");
INSERT INTO tgj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ogulvgavbolo nyido gindung ngv idw dwkibv ila isi a bidubv mvto. Vbv isi v birap rinyi yvvdw hoka poklwk chodunv hv ogugo lvvma go gvpvdw poya dukunv. ");
INSERT INTO tgj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hoka nyi ako anying chaam gola nyingpinw go lvvmala doonvgo dooto. ");
INSERT INTO tgj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisu nyi anga hoka doodubv kaatoku, okv hv chintoku nyi angv vkvjegu kaibv lvvmala doopv nvgo vla; vkvlvgabv hv ninyia tvvkato, “No chvrv kunvpv mvngdure?” ");
INSERT INTO tgj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Lvvmanv nyi angv mirwksito, “Tamsarnv, vdwlo svpar bolokv isi v birinyi ngam bolo dvlwk jinv nyi go doyama; vdwlo ngo gilwk dubv ritv rinyi, nyigonv gilwk choyado.” ");
INSERT INTO tgj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisu ninyia minto, “Gudung tokuka, noogv doopikarpi nvnv nga naarap tokuka, okv vngkar tokuka.” ");
INSERT INTO tgj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Vjakgobv nyi angv alvtoku; hv ninyigv karpi nvnv nga naarap toku okv vngkar raptoku. Vbvriri aluv Jius Doonualu bv ritoku, ");
INSERT INTO tgj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Vkvlvgabv Jius nyi rigvnv vdwv poyakunv nyi anga mintoku, “Silu Jius Doonualuv, okv noogv karpiu nvnv nga baknam si ngonugv Pvbv nga rinying do.” ");
INSERT INTO tgj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hv mirwkto, “Ngam mvpunv nyi angv ngam karpiu nvnv nga naarapla vngto kuka vla minto.” ");
INSERT INTO tgj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bunu ninyia tvvkato, “Nam sum ritokv vla minv nyi angv yvvla?” ");
INSERT INTO tgj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Vbvritola mvpunam nyi angv Jisu yvvdw um chimato, hoka nyi nyipam go dooto, okv Jisu nyipam lokv vnglintoku. ");
INSERT INTO tgj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ayungjvma nga, Jisu nyi anga Pwknvyarnvnaam lo kaapa toku okv minto, “Tvvtoka, no alvrungpvku; vkvlvgabv rimur kumabvka vmalo alvmanv ngv nam rijila.” ");
INSERT INTO tgj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Vbvrikunamv nyi angv vngtoku okv Jius nyi rigvnv vdwa minpa toku ninyia mvpunv nyi angv Jisu kv vla. ");
INSERT INTO tgj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Vkvlvgabv bunu Jisunyi alvmabv rirap toku, ogulvgavbolo bunugv Jius Doonualu lo hv nyi anga mvpu jinam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisu bunua mirwkto, “Ngoogv Abu alu lokia nyingdunv, okv ngooka nyingrung jinv.” ");
INSERT INTO tgj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","So minam si Jius nyi vdwa kaiyayabv ninyia mvkidubv mvngmuto; Jius doonualu gv Pvbv nga mvyakmvchak mvngma, vbvritola hv minto Pwknvyarnvnyi atugv Abu vkv okv svbv hv atuv Pwknvyarnvnyi karingching dubv minsuto. ");
INSERT INTO tgj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Vkvlvgabv Jisu bunua mirwksito, “Ngo nonua jvjv nga minjidu: Kuunyilo ngv hv atuv oguguka rinyuma; hv ninyigv Abu gv rinam a kaagvrila rimwngdunv. Abu ogugo ridudw, Kuunyilo ngvka ridu. ");
INSERT INTO tgj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Abu Kuunyilo nga pakdu okv ninyia ninyigv rinam mvnwngnga kaatamdu. Hv ninyia sum kaiyabv ridubv, okv nonu mvnwngngv mvngngak reku. ");
INSERT INTO tgj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Abu gv nyi sinv nga turkur moduku okv singnam a bunua jidu, vkv apiabv Kuunyilo ngvka ninyigv mvngkubv bunua singnam a jidu. ");
INSERT INTO tgj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Abu yvvnyika jwngkadaka madu. Hv ninyigv Kuunyilo nga ogumvnwng nga jwngkadaka dubv jito, ");
INSERT INTO tgj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Abunyi mvnwngngv mvngdvnam aingbv, Kuunyilo ngaaka mvngdv dubv. Yvvdw Kuunyilo nga mvngdv madunv hv ninyia vngmunv Abu nyika mvngdv madunv.” ");
INSERT INTO tgj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ngo nonua jvjv nga minjidunv: yvvdw ngoogv gaam ha tvvdunv okv ngam imu nvnyi mvngjwng dunv hv torbwngnama paariku. Hv jwngkadaka lo domare ogulvgavbolo hv sinam loka vngbola turnamlo aapv kunv. ");
INSERT INTO tgj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngo nonua jvjv nga minjidunv: dw ngv aadungduku—dw ngv aaropvku—vdwlo sinv vdwv Pwknvyarnv gv Kuunyilo gv gaam a tvvpare, okv yvvbunudw um tvvpa rinv hv turnamlo aariku. ");
INSERT INTO tgj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Abunyi atuv turnam gv kolv ngv, vbvdvdvbv ninyigv Kuunyilo nga turnam gv kolv gubv mvpvkunv. ");
INSERT INTO tgj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hv Kuunyilo gvbv alvpoma nga jwngkadaka nvnv ngaaka jipv, ogulvgavrinyi hv Nyia Kuunyilo ngv. ");
INSERT INTO tgj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nonu sum lamrwpagv mabvka, sinv mvnwngngv ninyigv gaam a tvvpadwv aariku ");
INSERT INTO tgj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","okv bunugv nyibung vdwlokv linreku: yvvbunudw alvbv rikunv vdwv gudungla okv turreku, okv yvvbunudw alvmanv nga rikunv vdwv gudungre okv darra koore.” ");
INSERT INTO tgj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ngo atuv oguguka rinyuma, Pwknvyarnv gv minam mvngchik a ngo makardu, vkvlvgabv ngoogv makarnamv jvjvdu, ogulvgavbolo ngo atuv alvnam lvgabv ritvma, vbvritola ngam vngmunv mvngchik gv mvnggiabv rijire.” ");
INSERT INTO tgj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ngo ngo atubogv lvkwngbv minjidunv bolo, ogugo mindudw hv torwk sunam jvjv gubv rilin jimare. ");
INSERT INTO tgj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Vbvritola ngoogv lvkwng nga minji nvgo akin go doodu okv ngo chindu hv ogugo ngo lvkwngbv minam dvdv ngv jvjvngv. ");
INSERT INTO tgj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jon ho angv yvv gvlo nonu nonugv gindungpingko nga vngmu pvdw, okv hv jvjvgv lvkwng nga japjito. ");
INSERT INTO tgj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","So si vbvma, ngo nyi mirianv ako doodu vla, ngo sum mimwngdunv nonua ringnam vdwa paamu dubv. ");
INSERT INTO tgj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon mvru aingbv rito, guto okv ungkato, okv nonu ninyigv lounglo dw achukgo himpu karnvpv vla mvngdungto. ");
INSERT INTO tgj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Vbvritola ngo atubogv lokv minse risego doodu so si Jon gv minam vdwaka kaiyanv go: ngo ogugo ridudw, ho hv, ngo Abu gv ngam ridubv jinammv so vdw si ngogvbv miriadu okv Abu ngam vngmupvnv vla kaatamdu. ");
INSERT INTO tgj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Okv Abu, yvvdw ngam vngmunv, ngoogv lvkwng ngaaka minjidu. Nonu ninyigv gaam ha vdwloka tvvkwma vmalo ninyigv nyukmu aka kaakwma, ");
INSERT INTO tgj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","okv nonu ninyigv doin a nonugv haapok lo vvpvma, okv nonu nw gv vngmunam angaka mvngjwngma. ");
INSERT INTO tgj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nonu Darwknv Kitap vdwa puri rido, ogulvgavbolo nonu mvngdo bunu gvlo turbwng nama paare vla. Okv si Darwknv Kitaplo ngoogv lvkwngbv mindu! ");
INSERT INTO tgj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Vbvrijvka nonuno turnam paanam lvgabv ngoogvlo aanvpv vla mvngma.” ");
INSERT INTO tgj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ngo nyia vdwgv hartvnama makar madunv. ");
INSERT INTO tgj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Vbvritola ngo chindu nonu oguaingnv nyi gudw, okv ngo chindu nonugv haapok lo Pwknvyarnv gv lvgabv aya namgo dooma. ");
INSERT INTO tgj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngo Abu gv jwkrw ha lvkobv aagv pvnv, vbvritola nonuno nga torwk suma; vdwlo, vbvrijvka, kvvbi akonv ninyigv atugv jwkrw ha lvkobv aagv nama, nonu um torwk sure. ");
INSERT INTO tgj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nonu akonv akonvnga hartv minsu nama mvngbiu do, vbvritola nonu Pwknvyarnv akin mvngchik lokv hartvnama paanvpv vla rikwma; vbvrikunamv, oguaingbv nonu nga mvngjwng nyudubv? ");
INSERT INTO tgj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Vbvrijvka, mvngma bvka, Pwknvyarnv gvlo ngo nonua gungnying lwkji bongv vla. Moses nonugv mvnggingla dvmin kunam, hv nonua gungnying lwkji bongv. ");
INSERT INTO tgj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nonuno Mosesnyi jvjvbv mvngjwng doonv guilo, nonu ngaaka mvngjwng doore, ogulvgavbolo hv ngoogv lvkwngbv lvkpvto. ");
INSERT INTO tgj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Vbvritola hv ogugo lvkpvdw um nonuno mvngjwng manv ngv, oguaingbv ngoogv minam a nonu mvngjwng nyudubv?” ");
INSERT INTO tgj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","So kochingbv, Jisu Galili Svpar vmalo, Tiberias Svpar vlaka minam a vngbola vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nyi nyipam twngtv nvgo ninyia vngming gvto, ogulvgavbolo bunu ninyigv lvvmanv vdwa lamrwpadubv mvpuripu nama kaatoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisu moodw gulo chaatoku okv ninyigv lvbwlaksu vdwa lvkobv dootung toku. ");
INSERT INTO tgj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Vngbokunam Pumja ridw v nvchi toku. ");
INSERT INTO tgj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisu kaitkarla kaato okv nyipam v nw gvlo aadungdubv kaapato, vkvlvgabv nw Pilipnyi tvvkato, “Ngonu so nyi vdw sum dvgu dubv dvmunam lvgabv ogolo dvnam rvvpa nyuredw?” ");
INSERT INTO tgj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hv svbv minam si Pilipnyi tvvka rungbv minto; minjvjvbolo hv chincho suto ogugo hv rise ngvdw. ");
INSERT INTO tgj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip mirwkto, “Nyichar mvnwngnga achukgo dvmu dajvka, so si lokdwng lvngnyi go dinchirungre dvgudvbv dvnam rvvdubv.” ");
INSERT INTO tgj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ninyigv lvbwlaksu akonv, Andriu, Saimon Pitar gv boru bv rinv, angv minto, ");
INSERT INTO tgj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Olo vka vmi ako vtwng tangu go okv ngui nvnyi go gvnvgo doopv. Vbvritola hv so nyi mvnwng gv lvgabv chirung mare.” ");
INSERT INTO tgj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisu bunua minto, “Nyi vdwa dootung dubv mvtoka,” (Hoka achialvgo nvmwng ngv dooto.) Vkvlvgabv nyi mvnwngngv dootung nyatoku; hoka ho nyiga dvdv ngv hejar angu gubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisu vtwng nga naato, okv Pwknvyarnvnyi umbonyikv vto, okv hoka doonv nyi vdwa ortoku. Nw ngui haka vbvdvdvbv mvto, okv bunu mvnwngngv vdwgo dvla pvkudw dvgubv dubv dvtoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Vdwlo bunu mvnwngngv dvji dubv dvto kudw, nw ninyigv lvbwlaksu vdwa minto, “Dvlv nga naakumto; akoka ornam orsubv ora momabvju.” ");
INSERT INTO tgj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Vkvlvgabv bunu vtwng tangu nyi vdwgv dvkunam lokv dvtung dvngo dvlv mvnwngnga paapi vring gola anyigo naakum toku. ");
INSERT INTO tgj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jisu gv svbv lamrwpanam rila kaatam nama kaala hoka nyi vdwv minto, “So si jvjvbv Nyijwk gurung Sichingmooku so aakujinv akonv!” ");
INSERT INTO tgj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bunu ninyia naatungla Dvbv bv mvlilala tvdu vla Jisu chintoku; vkvlvgabv nw atubongv moodw vdwbv vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Vdwlo arium tokudw, Jisu gv lvbwlaksu vdwv svpar lo ilwk toku, ");
INSERT INTO tgj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","svpw gulo aalwk toku, okv svpar lo Kaparnaum kiambv vngkorla vngtoku. Arium kanv toku, okv Jisu vjaklodvbv bunu gvlo aatv madvto. ");
INSERT INTO tgj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Vbvrikunamv kainv doori go rilwkto okv isi a kiokdubv mvtoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Lwbwlaksu vdwv svpwa dula lvtw angu vmalo akv gubv dulwk toku vdwlo bunu Jisunyi isi aolo vngdung dubv, svpw nvchilo aadung dubv kaapa toku, okv bunu busu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jisu bunua minto, “Nonuno busu mabvka, si ngo sumabv!” ");
INSERT INTO tgj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Vbvrikunamv bunu mvngpula ninyia svpw arwnglo aamu toku okv svpw lo bunugv vnglwkjiku mooku lo baapubv vngchi nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Logo nvnga nyipam v svpar takdv gonvbv doonv vdwv oloka svpw ngv akin gumwng vla mvngdi nyatoku. Bunu Jisunyi ninyigv lvbwlaksu lvkobv vngma, vbvritola bunu ninyia kayupila vngyu ropvku vla chintoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kvvbi svpw vdwv, Tiberias lokv, Jisu gv vtwng nga umbonyikv vro kochingbv nyi vdwa dvmuku mooku nvchi gv isi adarlo aakum nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Vdwlo nyipam v Jisu hoka dooma, ninyigv lvbwlaksu vdwvka dooma vla kaato kudw, bunu ho svpw vdw ho aanyatoku okv ninyia kaakarla Kaparnaumbv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Vdwlo nyi vdwv Jisunyi svpar gv takdv gunvlo kaapa tokudw, bunu ninyia tvvkato, “Tamsarnv, vdwlo no so aapvnv?” ");
INSERT INTO tgj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisu mirwksito, “Ngo nonua jvjv nga minpa jidunv: nonuno ngam makardu ogulvgavbolo nonu vtwng nga dvla okv nonugv mvngnam a dvkunam lvgalo, ngoogv lamrwpanam rinam a chinam lokvma. ");
INSERT INTO tgj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Alvmanv gubv rijinv dvnam lvgabv rima bvka, vmabvya turbwngla svngya jinv dvnam lvgabv rilaka. So siinv Nyia Kuunyilo gv nonua dvnam jiji namv, ogulvgavbolo Pwknvyarnv Abu ninyia alvnvgobv tolwk laku mvu pvkunv.” ");
INSERT INTO tgj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Vkvlvgabv bunu ninyia tvvkato, “Pwknvyarnv gv mvnglwkbv rinam lvgabv ngonu ogugo rila sego bri?” ");
INSERT INTO tgj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisu mirwksito, “Pwknvyarnv gv nonua ritokv vla mvngnamv si ninyigv vngmunam anga mvngjwng laka vla.” ");
INSERT INTO tgj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bunu mirwksito, “Ogu lamrwpanam go no rila kaatam dubv ngonu um kaagvrila nam mvngjwng dubv? No ogugo ridubv? ");
INSERT INTO tgj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ngonugv abuapa vdwv chukrimooku lo manna nga dvto Darwknv Kitaplo minam aingbv, ‘Hv nyido mooku tolokv vtwng nga jito dvmu dubv.’” ");
INSERT INTO tgj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","“Ngo nonua jvjv nga minjidunv,” Jisu minto, “Moses nonua ogugo jipv kudw hv nyidomooku tolokv vtwng ma; so si ngoogv Abu nonua nyidomooku tolokv vtwng loda jenga jinv. ");
INSERT INTO tgj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pwknvyarnv gv vtwng jinammv hv yvvdw nyidomooku tolokv inv okv nyiamookua turnam jidu.” ");
INSERT INTO tgj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bunu ninyia kooto, “Tamsarnv, so gv dvnam a ngonua lokia jilabv.” ");
INSERT INTO tgj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisu bunua mintoku, “Ngo kunv turnam gv vtwng ngv, yvvdw ngoogvlo aadunv vdwloka kano kumare; yvvdw ngam mvngjwng dunv vdwloka tvngnwng kumare. ");
INSERT INTO tgj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Vjak, ngo nonua mindunv nonuno ngam kaaroku vbvritola mvngjwng mare. ");
INSERT INTO tgj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nyichar mvnwngnga yvvnyi ngo Abu ngam jidu kudw ngogvlo aareku. Ngo vdwloka ngogvlo aanv nga dakkurla vngyu mare, ");
INSERT INTO tgj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ogulvgavbolo ngo nyidomooku tolokv inam hv ngo atugv mvngwngbv ridu bvma vbvritola ngam vngmunv ninyigv mvngnambv ridubv. ");
INSERT INTO tgj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Okv so si ngam vngmunv ninyigv mvngnamv ngo ninyigv jinam mvnwng loka akonyika ngoomu marung dubv, vbvritola ngo bunua ataranya alulo bunua turrap modukubv. ");
INSERT INTO tgj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ngo Abu gv mvngnam v Kuunyilo nga kaanv mvnwngngv okv ninyia mvngjwngnv vdwv turbwngnv singnam ha paadubv. Okv ngo bunua ataranya alu lo turmu dukubv.” ");
INSERT INTO tgj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nyi vdwv ninyia bvdung-bvdungbv japnyato, ogulvgavbolo hv minto “Ngo nyidomooku tolokv vtwng inv ngv.” ");
INSERT INTO tgj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Vkvlvgabv bunu minto, “So nyi si Jisu, Josep gv kuunyilo ngv, hv mari? Ngonu ninyigv abu nyila okv anvnyi chindu, vbvrikunamv vjak oguaingbv hv mindunvdw ngo nyidomooku tolokv ipvnv vla?” ");
INSERT INTO tgj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisu mirwksito, “Nonugv pingkolo bvdung-bvdungbv mimabvka. ");
INSERT INTO tgj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yvvka ngoogvlo aanyu mare vdwlo ngam vngmunv Abu ninyia ngoogvlo naalwk jima redw; okv ngo ninyia ataranya alulo turrap moreku. ");
INSERT INTO tgj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nyijwk vdwv lwkgapto, ‘Mvnwngnga Pwknvyarnv tamsarto.’ Yvvdw Abunyi tvvgap dunv okv ninyi gvlo chindunv ngoogvlo aadunv. ");
INSERT INTO tgj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","So si vbv minam angvma nyi gunv Abunyi kaapv nvgo vla; hv yvvdw Pwknvyarnv lokv aapvnv hv mvngchik Pwknvyarnvnyi kaanv ngv. ");
INSERT INTO tgj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ngo nonua jvjv nga minjidunv: yvvdw mvngjwng dunv hv turbwngnv singnam a paapv kunv. ");
INSERT INTO tgj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngo kunv turnam gv vtwng ngv. ");
INSERT INTO tgj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nonugv abuapa vdwv chukrimooku lo manna nga dvto, vbvritola bunu siroku. ");
INSERT INTO tgj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Vbvritola nyidomooku tolokv inv vtwng ngv vbvridu um dvnv ngv simare. ");
INSERT INTO tgj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngo turnv vtwng ngv nyidomooku tolokv ipvnv. Yvvdw so vtwng sum dvbolo, hv turbwngla singre. Ngoogv ninyia vtwng jiji namv ngoogv ayak v um ngo jidu ogulvgavbolo nyiamooku hv singdu kubv.” ");
INSERT INTO tgj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Si bunugv apumlo haachila larrap minsunam gubv rito. Bunu tvvka minsuto, “Oguaingbv so nyi si ninyigv ayakka ngonua dvmudubv vla jila nyuridw?” ");
INSERT INTO tgj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisu bunua minto, “Ngo jvjv nga nonua minjidunv: nonu vdwlo nyia Kuunyilo gv ayakka dvma redw okv ninyigv oyi ha tvngma redw nonu atubongv turnama paamare. ");
INSERT INTO tgj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yvvdw ngoogv ayakka dvridw okv ngoogv oyi ha tvngridw turbwngnv singnam ha paare, okv ataranya alulo ngo ninyia turrap moriku. ");
INSERT INTO tgj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ogulvgavbolo ngoogv ayak v dvnam jvjv ngv; ngoogv oyi si tvngnam jvjv ngv. ");
INSERT INTO tgj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yvvdw ngoogv ayak ha dvdunv okv ngoogv oyi ha tvngdunv ngoogvlo doodunv, okv ngo ninyi gvlo doodunv. ");
INSERT INTO tgj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Turbwngnv Abu ngam vngmuto, okv ninyigv lokv ngo ka turdunv. Ho apaiabv yvvdw ngoogv ayak ha dvdunv hv ngo gvlokv turbwngla doore. ");
INSERT INTO tgj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Vbvrikunamv, si, nyidomooku tolokv inv vtwng ngv; so si nonugv abuapa vdwgv vtwng dvnam aingma, vbvritola koching so sitoku. Yvvdw so vtwng sung dvredw hv turbwngla svngre.” ");
INSERT INTO tgj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisu sum Kaparnaum lo Jius kumkunaamlo ninyigv tamsar sarnam jvbv minto. ");
INSERT INTO tgj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ninyigv rigvnam nyi achialvgo sum tvvpa toku okv minto, “So tamsarnam si achialvbv rinyu manamgo. Yvv sum tvvria nyudubv?” ");
INSERT INTO tgj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Minpanvgo kaamajeka, Jisu chinto bunu soogv lvga nga bvdung-bvdungbv larmisidu nvgo vla vkvlvgabv hv bunua minto, “So si nonua topu monwng dubv mvdu nvgo lare? ");
INSERT INTO tgj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Vbvrikunamv, nonu nyia Kuunyilo nga ninyigv kvvlo doochoku mooku tolo chaakor dukubv kaanam gubv rikubolo? ");
INSERT INTO tgj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Turnam ogugo jinv si Pwknvyarnv gv Dow ngv; nyi gv jwkrw si vdwloka ogu mvnwng loka rinv nyuma. Ngoogv nonua gamchar minam vdwv turnam naalwk jinv Pwknvyarnv gv Dow ngv. ");
INSERT INTO tgj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Vbvritola nonu megonv mvngjwngma.” (Jisu atoklokv chinchoto bunugv lokv yvvdw mvngjwng majinv okv yvvdw ninyia koa kujinv.) ");
INSERT INTO tgj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Okv hv mindvto, “So siinv anyung ngv ngo nonua mintoku vdwlo Abu ninyia vbv rinyu dubv mvvma dvdvlo yvvka ngoogvlo aanyu mare.” ");
INSERT INTO tgj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Vbv minam lvkwngbv, Jisu gv rigvnam achialvgo vngkur nyatoku okv ninyia lvkoka vngming gvkuma. ");
INSERT INTO tgj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Vkvlvgabv ninyigv lvbwlaksu vring gola anyi vdwa tvvkato, “Okv nonu—nonu ka topu duku bri?” ");
INSERT INTO tgj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pitar ninyia mirwksito, “Ahtu vbvbolo ngonu yvvnyi vngming gvdu kubv? Turbwngnv singnam a jinv gamchar v no gvlo doodu. ");
INSERT INTO tgj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Okv ngonu vjak mvngjwngdu okv chindu no darwk mvngchiknv Pwknvyarnv gvlokv aanv.” ");
INSERT INTO tgj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisu mirwksito, “Ngo nonu vring gola anyia darpvnv, ngo darmare? Vbvritola nonugv lokv akonv uyudvbv go!” ");
INSERT INTO tgj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hv Judas gv lvkwng nga minto, Saimon Iskeriot gv kuunyilo. Judas, lvbwlaksu vring gola anyi lokv jeka, Jisunyi koa tvduku. ");
INSERT INTO tgj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","So kochingbv, Jisu Galili bv vngkarto; hv Judia lo vngkar nwngma toku, ogulvgavbolo Jius nyi kainv vdwv hoka ninyia mvki dubv mvngnyato. ");
INSERT INTO tgj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Rongonampo pumja ridwv nvchi toku, ");
INSERT INTO tgj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","vkvlvgabv Jisu gv boru vdwv ninyia minto, “So mooku sam kayupila okv Judia bv vngtoka, ogulvgavbolo nam reming gvnv nyi vdwv no ogugo ridudw kaamu dubv. ");
INSERT INTO tgj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Hv ogugo ridudw alvrungbv chimu nvpv mvngbolo yvvka vvsi mare. No sung ridung roku, nyiamooku gv nyi mvnwngnga nam chimu toka!” ");
INSERT INTO tgj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ninyigv boru vdwvka ninyia mvngjwng mato. ");
INSERT INTO tgj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisu bunua minto, “Ngoogv lvgabv alvnv dw hv aatv madv. Nonugv lvgabv ogu dw jvka alvnv. ");
INSERT INTO tgj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nyiamooku gv nyi vdwv nonua kaanwng mabv rinyu mare, vbvritola bunu nga kaanwng mado, ogulvgavbolo bunugv lamtv ngv alvma vla ngo bunua minbwng jido. ");
INSERT INTO tgj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nonu pumja lo vngsu laka, ngo so gv pumja so vngmare, ogulvgavbolo ngoogv lvgabv alvnv dw v aatv madv.” ");
INSERT INTO tgj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hv sum mintoku, okv vbvrikunamv Galili lo doobwngla doolwk toku. ");
INSERT INTO tgj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ninyigv boru vdwgv pumja lo vngro kochingbv, Jisu ka vngtoku; vbvrijvka hv nyi mvnwngnga kaapatapa dubv vngmato, vbvritola choibv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jius nyi kainv vdwv ninyia pumja lo kaakarnyato. “Hv ogolobvri?” bunu tvvka toku. ");
INSERT INTO tgj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hoka ninyigv lvkwng nga nyipamlo achialvbv japsijapit nyato. “Hv alvnv nyi go,” Nyi megonv minto. Kvvbi vdwv minto “Ma, hv nyi vdwa rimur gvdu.” ");
INSERT INTO tgj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Vbvritola yvv akonvka ninyigv lvgabv japkok rikok mato, ogulvgavbolo bunu Jius nyi kainv vdwa busu nyato. ");
INSERT INTO tgj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pumja nga tunggo nvnga rinya toku vdwlo Jisu Pwknvyarnvnaam lo vngla hoka tamsar sarrap tokudw. ");
INSERT INTO tgj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jius nyi kainv vdwv achialvbv lamrwpanya toku okv minto, “Hv ogu risarrima kolo vngkw rikw magvre, oguaingbv hv vkv nvgu achialvbv chimpv nvdw?” ");
INSERT INTO tgj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisu mirwksito, “Ngo ogugo tamsar dvdw hv ngo atubogv tamsar sarnamma, vbvritola hv nga vngmunv Pwknvyarnv lokv aadunv. ");
INSERT INTO tgj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yvvdw Pwknvyarnv gv mvngnambv rinwng nvngv chinre ngo ogugo tamsar dvdw, Pwknvyarnv lokv aadu nvdw vmalo ngo atubogv chinampaanam lokv mindunvdw. ");
INSERT INTO tgj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yvvdw atubogv chinampaanam lokv mindunv, hv atubonga kaibv yungku dubv mvsudunv. Vbvritola yvvdw ninyia vngmunv lvgabv kaibv yungnamma mvngdunv, hv alvnv, okv hoka ninyigv ogu mvvnamrunam kaama. ");
INSERT INTO tgj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses nonua Pvbv nga jito, hv jima pvnvri? Vbvritola nonuno yvvka Pvbv nga tvnvrinv kaama. Ogulvgabv nonu nga mvki dubv rikw dunv?” ");
INSERT INTO tgj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nyipam hv mirwkto, “No arwnglo uyuvram gvdu nvgo! Nam yvvla mvki dubv rikw nvngv?” ");
INSERT INTO tgj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisu mirwksito, “Ngo lamrwpanam go kaatamto okv nonu mvnwngngv lamnyato. ");
INSERT INTO tgj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses nonua orto jito nonugv kuunyilo vdwa ayakmvu dubv (so si Moses ma vbvritola nonugv abuapa vdwv sum rirap gvtoku), okv vkvlvgabv nonuno kuunyilo nga Jius Doonualu lo ayakmvu dunv. ");
INSERT INTO tgj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Vminyilo nga Jius Doonualu lo ayakmvu dunvlo vkvlvgabv Moses gv Pvbv ngv mvwk madubv, ogulvgavbolo ngoogv nyi nga Jius doonualu lo mvnwngnga alvdukubv mvnam a haachi dunv? ");
INSERT INTO tgj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Agum lokv kaala jwngnamdanam a kayu tokuka, okv jvjv lokv jwngkadaka laka.” ");
INSERT INTO tgj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem gv nyi megonv minto, “So nyi si mare kainv vdwgv mvki nvpvkv vnam angv? ");
INSERT INTO tgj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kaatoka! Hv kvba vdwlo japdungdo, okv bunu ninyia oguka minyingminsu ma! hv bunugv si Kristo vla chimbwk kunam guma bri? ");
INSERT INTO tgj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Vbvritola vdwlo Kristo aarikudw, yvvka chimare hv ogo lokvdw: okv ngonu mvnwngngv chindu so nyi si ogo lokvdw.” ");
INSERT INTO tgj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisu Pwknvyarnvnaam lo japtoku, hv gamtv rungbv minto, “Nonu ngam jvjvbv chimpvi okv ogolokvbvri vla chimpvi? Ngo atubongv aasuma, ngam vngmunv angv jvjv ngv. Nonu ninyia chima, ");
INSERT INTO tgj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","vbvritola ngo ninyia chindu, ogulvgavbolo ngo ninyigv lokv aapvnv okv hv nga vngmupvnv.” ");
INSERT INTO tgj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Vbvrikunamv bunu ninyia naatung tvvto, vbvritola yvvka ninyia laak laklin nvgoka kaamato, ogulvgavbolo ninyigv alvnv dw ngv aatvmadvto. ");
INSERT INTO tgj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Vbvritola nyipamlo nyi achialvgo ninyia mvngjwng nyato okv minto, “Vdwlo Kristo aarikudw, hv so nyi sum kaiyabv lamrwpanam rila kaatam rekudw?” ");
INSERT INTO tgj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisis vdwv nyipamlo Jisu gv lvgabv japsijapit dubv tvvpa toku, vkvlvgabv bunu okv nyibu butvnv vdwv sipai mego ninyia naatung dubv vngmutoku. ");
INSERT INTO tgj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisu minto “Ngo achukgo asu dubv nonua lvkobv doore, okv vbvrikunamv ngo ngam vngmunv gvlo vngyu reku. ");
INSERT INTO tgj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nonu ngam kaakarre vbvritola nonu ngam kaapamare, ogulvgavbolo ngo ogolo dooridw nonu vngnyu mare.” ");
INSERT INTO tgj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jius nyi kainv vdwv bunu atubongv minsunyato, “Ngonu ninyia mapa madubv hv ogolobvri vngtv tvdunv? Hv Grik pamtv vdwlo ngonugv nyi rikulo vngla Grik vdwa tamsar tvdu nvbvri? ");
INSERT INTO tgj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Hv mindu ngonu ninyia kaakarre vbvritola kaaapa mare vla, okv hv ogolo dooridw ngonu hoka vngnyu mare vla. Ninyigv minam si ogu gobvre?” ");
INSERT INTO tgj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pumja alu gv lootar loonya dinchi yachoknv alu lo Jisu dakrapto okv gamtv rungbv minto, “Yvvla tvngnwng dunv ngoogvlo aarung laka okv tvnglaka. ");
INSERT INTO tgj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Darwknv Kitaplo mindu, ‘Yvvdw nga mvngjwng dunv, singnamlo turnam jinv isi svdwng dvngdo ngv ninyigv haapok lokv pwlin jire.’” ");
INSERT INTO tgj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisu gv so minam si Dow gv lvgabv minto, yvvbunudw ninyia mvngjwng rinv hv bunu paatv rinv. Ho dw lo Dow a jitv madvto, ogulvgavbolo Jisu vjaklodvbv sila turkurla yunglitnam gubv ritv madvto. ");
INSERT INTO tgj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nyipam lokv nyi megonv ninyia vbv mindubv tvgvrila minto, “So nyi si jvjvrungbv Nyijwk go!” ");
INSERT INTO tgj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kvvbi vdwv minto, “Hv kunv Kristo!” Vbvritola kvvbi gunv kuring minto “Kristo Galili lokv linmare! ");
INSERT INTO tgj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Darwknv Kitaplo mindu Kristo Dvbv Dabid gv husi lokv linre vla okv Betlehem lo bvnglinre, Dabid gv dooku banggu lo.” ");
INSERT INTO tgj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Vkvlvgabv hoka nyi vdwv asak-asak sutoku Jisu gv lvkwnglo. ");
INSERT INTO tgj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Megonv ninyia naatung dubv mvngtoku vbvritola yvvka ninyi laak laklin nvgoka kaama toku. ");
INSERT INTO tgj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Vdwlo sipai vdwv vngkur tokudw, nyibu butvnv vdwv okv parisis vdwv bunua tvvkato, “Nonu ogubv ninyia aagv mapvnv?” ");
INSERT INTO tgj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sipai vdwv mirwkto, “Yvvka alo nyi vbv minv kaama!” ");
INSERT INTO tgj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisis vdwv bunua tvvkato, “Hv nonua pvcha dubv mvta pvnvre? ");
INSERT INTO tgj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Vdwloka no kainv nyi akoka okv Parisis goka ninyia mvngjwng dubv chimpvnvre? ");
INSERT INTO tgj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","So nyipam si Moses gv Pvbv nga chima, vkvlvgabv bunu Pwknvyarnv gv beenam arwnglo doodunv!” ");
INSERT INTO tgj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Parisis akin go hoka Nikodemas, yvvdw kvvlo Jisunyi kaabv vngnv nyi angv. Hv kvvbi vdwa minto, ");
INSERT INTO tgj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ngonugv Pvbv gv milam lokv vngrinyi ngonu yvvnyika rimur vngmur ha gaklin madvbv mia jinyuma.” ");
INSERT INTO tgj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bunu mirwkto, “Alvpv,” “No ka Galili lokvre? Darwknv Kitap a puri kaateka okv Galili lokv nyijwk aanv kaama vla no chinre.” ");
INSERT INTO tgj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Vbvrikunamv nyichar mvnwngngv naam bv vngnya toku, vbvritola Jisu Olib Moodw bv chaatoku. ");
INSERT INTO tgj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Alu logonvgv arukamchibv nw Pwknvyarnvnaam bv vngkur toku. Nyi mvnwngngv vngkumla ninyia vngyumto, okv nw dootung tvvla bunua tamsar sarrap toku. ");
INSERT INTO tgj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pvbv tamsarnv vdwv okv Parisis vdwv nyimv ako yoomur nvgo naatungla boolwk nyato, okv bunu nyimv nvnga mvnwng gv kaagialo dakmuto. ");
INSERT INTO tgj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bunu Jisunyi minto, “Tamsarnv, so nyimv angv yoomurla rila donv nga naatung pvnv. ");
INSERT INTO tgj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ngonugv Pvbv lo Moses gamkito svkvnv nyimv nga vlwngngv orkidubv. Vjak, no ogu vla mindunv?” ");
INSERT INTO tgj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bunugv svbv minam si Jisunyi minkup gvrila gungnying lwkdubv vla minto. Vbvritola hv dumpo bawng gvrila ninyigv lakching lokv kvdwlo akor lvkminla dooyasuto. ");
INSERT INTO tgj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bunu hoka daktola ninyia tvula tvvka dvdvnyato, hv mvngrwpala yikula baarapla bunua minto, “Nonu gv lokv akonv yvvla rimur rima pvnv hv ninyia vlwng orcholaka.” ");
INSERT INTO tgj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Vbvrikunamv nw lvkodv dumpo bawng gvrila kvdw lo lvkminto. ");
INSERT INTO tgj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Vdwlo bunu sum tvvtokudw, bunu abwngyachok v vngcho gvlaila akin akinbv mvnwngngv vngyu nyatoku. Jisunyi akin dookubv okv nyimv nvngaka hoka dakbwng dubv bunu vngyu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hv atubongv mvngrw laila baarapla nyimv anga tvvkato, “Ogolo bunu? Nam miakaya jinv akoka dooku mai?” ");
INSERT INTO tgj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nw mirwksito, “Tamsarnv,” akoka dookuma. Vbvrikunamv, alvdo, Jisu minto, “Ngo ka nam miakaya madunv. Vngnyikuka, vbvritola lvkodv rimur kumabvka.” ");
INSERT INTO tgj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisu Parisis vdwa lvkodv mindvto. Nw minto, “Ngo nyiamooku gv loung ngv, yvvdw nga vngming gvdunv hv singnamlo loung yayabv rire okv vdwloka kanv arwnglo vngkar mare.” ");
INSERT INTO tgj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisis vdwv ninyia minto, “Vjak no atubogv lvgabv minsudo; no ogugo mindudw anyung kaama.” ");
INSERT INTO tgj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisu mirwksito, “Ma, ngo atubogv lvkwng nga minsu jvka, ngo ogugo mindudw hv jvjv ngv, ogulvgavbolo ngo chinsudo ngo ogolokv aapvnvdw okv ngo ogolo vngtv tvdunvdw. Nonu chima ngo ogolokv aapvnvdw vmalo ngo ogolo vngtv tvdunvdw. ");
INSERT INTO tgj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nonu ngam nyi adwnayak lokv chingching bv jwngkadakado; ngo yvvnyika jwngkadaka mapvnv. ");
INSERT INTO tgj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Vbvritola ngo vbvrinam gubv rinv guilo, ngoogv jwngkadaka namv jvjvre, ogulvgavbolo so ngo akin mwngma; ngam vngmunv Abu ka ngam lvkobv reming gvdu. ");
INSERT INTO tgj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","So si nonugv Pvbv lo lvkpv vdwlo kayatayanv anyi gonv tolwk minsu bolo, bunu ogugo minpvdw hv jvjv ngv, ");
INSERT INTO tgj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngo atubogv lvgabv minsudo okv ngam vngmunv Abu ka ngoogv lvgabv mindvdo.” ");
INSERT INTO tgj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bunu tvvkato, “Ogolo no gv abu?” Jisu mirwksito, “Nonu ngamla ngoogv Abu nyika chima, nonu ngam chinv guilo, ngoogv Abu nyika nonu chinre.” ");
INSERT INTO tgj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisu so mvnwngnga minto, Pwknvyarnvnaam lo karchung arwng lo morko lwkku jampa vvpvku hoka ninyigv tamsar sarnam aingbv. Okv yvvka ninyia naatung mato, ogulvgavbolo ninyigv dw ngv aatv madvto. ");
INSERT INTO tgj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisu lvkodv bunua minto, “Ngo vngro reku: nonu ngam kaakar reku, vbvritola nonu nonugv rimurlo silwk reku. Nonu vngnyu mare ngoogv vngkulo.” ");
INSERT INTO tgj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jius nyi kainv vdwv minto, “Hv mindu ninyigv vngjikolo ngonu vngnyu mare vla. Svbv minam si hv atubongv mvki sidubv mindu nvgo bri?” ");
INSERT INTO tgj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisu mirwkto, “Nonu so lvkwng gv Sichingmooku so gvngv, vbvritola ngo ao tolokv inv ngv. Nonu so Sichingmooku so gvngv, vbvritola ngo so Sichingmooku gvngvma. ");
INSERT INTO tgj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Vkvlvgabv ngo nonua minpa pvkunv nonuno silwkre nonugv rimurlo. Okv nonu sireku nonugv rimurlo vdwlo nonu ‘Ngo Yvvkudw Ngo’ um nonu mvngjwng maridw.” ");
INSERT INTO tgj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bunu tvvkato, “No yvvla?” Jisu mirwksito, “Atuk lokv ngo nonua ogugo minpvdw. ");
INSERT INTO tgj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ngo nonugv lvga nga minse ngv awgo doodu, awgo nonua mia sengv. Ngam vngmunv angv, ogubv rijeka jvjv ngv, okv ngo nyiamookua mintamdu ninyi gvlo tvvnam dvdv nga mwngchik.” ");
INSERT INTO tgj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bunu Jisunyi ninyigv Abu gv lvga nga bunua mindunv vla tvchin mato. ");
INSERT INTO tgj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Vkvlvgabv hv bunua minto, “Vdwlo nonu Nyia Kuunyilo nga tungcha rikudw, ho nonu chinre ‘Ngo Yvvkudw Ngo;’ vbvrikubolo nonu chireku ngo atunvgv chinampanam lokv oguguka rima, vbvritola ngo mindu Abu gv mintoka vla minam a ngo mimwngdunv. ");
INSERT INTO tgj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Okv yvvdw ngam vngmunv hv ngam lvkobv redunv; hv ngam akinbv kayuma, ogulvgavbolo ngo lokia ninyigv mvnglwkbv ridunv.” ");
INSERT INTO tgj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Achialv nvgo Jisunyi so mvnwng sum mindubv tvvnv vdwv mvngjwng nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Vkvlvgabv Jisu ninyia mvngjwngnv vdwa minto, “Nonu ngoogv tamsar nama tvvnvrinv gubv ribolo, nonu jvjvbv ngoogv lvbwlaksu v; ");
INSERT INTO tgj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","nonu jvjv nga chinreku okv jvjv ngv nonua ajarabi moriku.” ");
INSERT INTO tgj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“Ngonu Abraham gv husi hv,” bunu mirwkto, “okv ngonu yvv gvka nyirabv rikw manv. Vbvrinamv noogv nonua ajarabi kunam gubv mvreku vla minammv oguv?” ");
INSERT INTO tgj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisu bunua minto, “Ngo jvjv nga nonua minjidunv: nyichar mvnwngngv yvvdw rimur dunv hv rimur gv nyirabv ridunv. ");
INSERT INTO tgj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nyira ngv vpinlo doobwng madunv, vbvritola kuunyilo ngv doobwng nvgobv ridunv. ");
INSERT INTO tgj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kuunyilo ngv nonua ringlin mooku bolo, vbvrikunamv nonu jvjvrungbv ajarabi kunamv. ");
INSERT INTO tgj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngo chindu nonu Abraham gv husi hv. Vbvrirung gvrila nonu ngam mvki dubv rikwdo, ogulvgavbolo nonu ngoogv tamsar nama torwk simare. ");
INSERT INTO tgj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngo, ngoogv abu ogugo kaatam pvdw ho lvgabv mindunv, vbvritola nonu ridu nonugv abu nonua ogugo minpv pvdw.” ");
INSERT INTO tgj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bunu mirwkto, “Ngonugv abuv Abraham.” Jisu mirwksito, “Nonu jvjvbv Abraham gv Kuu gubolo, nonuka hv ogugo ripvdw ho apiabv rire. ");
INSERT INTO tgj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngoogv rinam mvnwngngv ngo ogugo Pwknvyarnv gvlokv tvvpvdw nonua jvjv nga minji dubv vla ripvnv, vjvka nonu ngam mvkidubv rikwdo. Abraham svkv aingbv rimato! ");
INSERT INTO tgj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nonu nonugv abu gv rinam apiabv ridungdo.” “Pwknvyarnv mvngchik ngonugv Abu doonv ngv,” bunu mirwkto, “okv ngonu ninyigv kuunyilo jvjv ngv.” ");
INSERT INTO tgj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisu bunua minto, “Jvjvbv Pwknvyarnv nonugv Abu bv rinv guilo, nonu ngam ayare, ogulvgavbolo ngo Pwknvyarnv gvlokv aanv ngv okv vjak ngo si doodu. Ngo atubogv jwkrw lokv aasuma vbvritola hv nga vngmupvnv. ");
INSERT INTO tgj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngo ogugo mindudw nonu ogubv chima dunv? So si ogulvgavbolo nonu ngoogv doin ha tvvya nwngmado. ");
INSERT INTO tgj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nonuno Uyudvbv gv kuu ngv, okv nonu abu gv mvngjimvngro kolo rinwngnv. Atuk lokv hv gwngrw gwnv okv vdwloka jvjvgv takbv aakw manv, ogulvgavbolo hoka ninyigvlo jvjv achuk guka dooma. Vdwlo nw mvridw, nw ninyigv riching bv ridunv, ogulvgavbolo nw mvkinv okv mvnv mvnwng gv abuv. ");
INSERT INTO tgj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Vbvritola ngo jvjv nga minjidu, vkvlvgabv nonu ngam mwngjwng madunv. ");
INSERT INTO tgj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nonu gvlokv akonv yvvla ngam rimur nvgobv vla gungnying lwkla gaknyu jinv? Ngo jvjv nga mindu bolo, vbvrikunamv nonu ogubv ngam tvvjing madunv? ");
INSERT INTO tgj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yvvdw Pwknvyarnv gvlokv aadunv Pwknvyarnv gv gamchar vdwa tvvdunv. Nonu, ogubvrijeka, Pwknvyarnv lokvma, okv vkvlvgabv nonuno tvya madunv.” ");
INSERT INTO tgj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bunu Jisunyi tvvkato, “Ngonugv nam samaritan go okv no uyuvram gvnvgo vla minam v minjwk mapvnvre?” ");
INSERT INTO tgj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisu mirwksito, “Ngoogvlo uyuvram dooma, ngo Abunyi mvngdv dunv okv nonu ngam miakaya dunv. ");
INSERT INTO tgj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ngo atubogv lvgabv mvngdvnam makar madunv. Vbvritola hoka um makarnv ako doodu okv hv ngogvbv jwngkadakayadu. ");
INSERT INTO tgj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ngo jvjv nga nonua minjidunv: yvvdw ngoogv tamsar nama tvvdunv hv vdwloka simare.” ");
INSERT INTO tgj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bunu ninyia minto, “Vjak ngonu jvjvbv mvngduku no gvlo uyuvram doorungdo! Abraham siroku, okv nyijwk vdwvka siroku, vjvka no mindu yvvdw no gv tamsar nama tvvrinv hv vdwloka simare vla. ");
INSERT INTO tgj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ngonugv abu Abraham siroku; no Abrahamnyi kaiyanv gubv mvngsu dunvre? Okv nyijwk vdwvka siroku. No atuv yvv vla mvngsudunv?” ");
INSERT INTO tgj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","“Ngo atuv mvngdv subolo, ho mvngdv namv ogu arv doomare. Ngam mvngdvnv angv ngoogv Abu—nonugv Pwknvyarnv vla minam angv. ");
INSERT INTO tgj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nonu vdwloka ninyia chimato, vbvritola ngo ninyia chindu. Ngo ninyia chima vla minbolo, ngo nonugv apiabv mvvki nvgobv ripvnvpv. Vbvritola ngo ninyia chirung dunv, okv ninyigv gamchar a tvvdunv. ");
INSERT INTO tgj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nonugv abu Abraham ngoogv aaji nama kaanwngla mvngpula kaacho toku okv himpu toku.” ");
INSERT INTO tgj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bunu ninyia minto, “No vjak anying chamngu goka svngtv madv—okv no Abrahamnyi kaapv nvlv?” ");
INSERT INTO tgj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisu mirwksito, “Ngo jvjv nga nonua minjidunv, Abrahamnyi bvngtv madvbv, ‘Ngoonv.’” ");
INSERT INTO tgj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Vbvrikunamv bunu ninyia vlwng ordubv vla naarap toku, vbvritola Jisu atubongv tosisito okv Pwknvyarnvnaam a vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisu vbv vngkarminto, nw nyi ako bvnglin lokv nyikching nvgo kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ninyigv lvbwlaksu vdwv ninyia tvvkato, “Tamsarnv, yvvgv rimur vkudw ninyia bvngrilokv nyikching monv? Hv atugv lokvre vmalo ninyigv anvabu gv rimur lokvre?” ");
INSERT INTO tgj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisu mirwkto, “Si so nyi gv rimur vmalo ninyigv anvabu gv rimur lokv ninyia nyikching moma. So nyi si nyikching pvnv v, ogulvgavbolo Pwknvyarnv gv jwkrw okv rinam a ninyi gvlokv kaatam dubv. ");
INSERT INTO tgj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vdwgo aluv asubv doodv ridw, ngonu ngam vngmunvgv lvgabv kudungkua riji rungdubv ridu; kanv ngv aariku vdwlo yvvka kudungkua rinyu kumare. ");
INSERT INTO tgj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngo vdwgo nyiamooku so dooridw, ngo nyiamooku gv loung ngv.” ");
INSERT INTO tgj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Vbv so miro kochingbv, Jisu kvdw lo tachor chorbiakto okv chorbiak kolokv eriungbv mego mvto; nw nyi hvkvgv nyiklo piaklwkto ");
INSERT INTO tgj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","okv minto, “Vngnyika okv noogv nyukmua sokak teka siloam gv svlv lo,” (Siloam vla minam si “vngmukunam”). Vkvlvgabv nyi angv vngtoku, ninyigv nyokmua sokak toku, okv nyiktarla kaying lakula aakur toku. ");
INSERT INTO tgj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Vbvrikunamv, ninyigv namrwk ajin vdwv okv ninyia kvvlo dvku koodubv kaanv vdwv, tvvka minsunyato, “So nyi si mabvre dootung tvla kookinv angv?” ");
INSERT INTO tgj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Megonv minto, “Hv mabv,” vbvritola kvvbi vdwv minto, “Ma hv ma; hv ho nyi anga gvvnv go.” Vkvlvgabv nyi angv atuv minto, “Nyi angv ngo mabv.” ");
INSERT INTO tgj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bunu ninyia tvvkato, “No vjak oguaingbv rila kaapa nyudukunv?” ");
INSERT INTO tgj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hv mirwksito, “Jisu vnam nyi angv kvdw mego naala eriungbv mego mvto, um ngoogv nyiklo piaklwkto, okv ngam Siloam lo vngla nyukmua soktoka vla minto. Vkvlvgabv ngo vngtoku, okv vdwlo ngo sokdanam gola ngo kaapa nyutoku,” ");
INSERT INTO tgj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bunu tvvkato, “Hv ogolo?” Nyi angv mirwksito, “Ngo chingkuma.” ");
INSERT INTO tgj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Vbvrikunamv bunu nyikchingnv nyi anga Parisis vdwgvlo aagv jitoku. ");
INSERT INTO tgj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisu gv kvdw a eriungbv mvla okv ninyigv nyikching nama mvpu kunam alu v Jius Doonualulo rito. ");
INSERT INTO tgj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Vbvrikunamv, Parisis vdwv, nyi anga oguaingbv rila hv kaapa pvku nvdw vla tvvkato. Hv bunua mintam toku, “Nw kvdw eriung vkv ngoogv nyik so piaklwkto; ngo nyukmua sokak toku okv ngo vjak kaapa nyudukunv.” ");
INSERT INTO tgj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisis megonv minto, “Sum rinv nyi angv si Pwknvyarnv gvlokvma, ogulvgavbolo (nw jius Doonualu gv pvbv gvbv rijima.”) Kvvbi vdwv, ogubvrijeka, minyato, “Oguaingbv nyi rimur nvngv svkvnv lamrwpanam a svbv kaatam nyuladubv?” Okv hoka bunugv apumlo akuaku subv mvngnya rinyato. ");
INSERT INTO tgj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Vkvlvgabv Parisis vdwv nyi anga lvkodv tvvdito, “No mindu hv noogv nyikching nama mvpupv vla—alvdo, no ninyia oguv vla mindunv?” Nyi angv mirwksito, “Hv Nyijwk go.” ");
INSERT INTO tgj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jius nyi kainv vdwv, ogubvrijeka, mvngjwng mato hv nyikching dvbv bvngnam go okv vjak kaapa nyudukunv vla, rinyung nga bunu ninyigv anvabua goklwkto ");
INSERT INTO tgj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","okv bunua tvvkato, “Si nonugv kuunyilo ngvre? Nonu mindu ninyia nyikching dubv bvngpvnv; vbvrikunamv, oguaingbv hv vjak kaapa nyudukunv?” ");
INSERT INTO tgj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ninyigv anvabuv mirwksito, “Ngonu chindu hv ngonugv kuunyilo ngv, okv ngo chindu ninyia nyikching dubv bvngpvnv. ");
INSERT INTO tgj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Vbvritola ngonu chima hv oguaingbv vjak kaapa nyudu kunvbvri, ngonu vbvka chima yvvdw ninyigv nyikching nga mvpu pvnv. Ninyia tvvka toka; hv kaipvku, okv atuv mirwk sinyu reku!” ");
INSERT INTO tgj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ninyigv anvabuv svbv minto, ogulvgavbolo bunu Jius nyi kainv vdwa busuto, vbv tolwk minsuto yvvdw Jisunyi Kristo vla mvngjwng dvnvkv vnv anga Jius kumkunaam lokv naala naa reku. ");
INSERT INTO tgj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Vkvlvgabv ninyigv anvabuv vbv minto, “Hv kaipvku; ninyia tvvka laka!” ");
INSERT INTO tgj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lvnyi nanvbv bunu nyi nyikching dubv bvngnam anga gokorto okv ninyia minto, “Pwknvyarnv gvlo milvla minto no jvjv nga milin jire vla! Ngonu chindu nam mvpunv nyi angv rimur nvgo.” ");
INSERT INTO tgj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nyi angv mirwksito, “Ngo chima hv rimur nvgobvre vmalo rimur manv gobvre, ngo ako chinsudo: ngo nyikchingto, okv vjak ngo kaapa duku.” ");
INSERT INTO tgj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Hv ogugo nam rikunamv?” bunu tvvkato. “Hv oguaingbv nam nyikching nga mvpu kunamv?” ");
INSERT INTO tgj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Ngo nonua mintam ropvkunv,” hv mirwkto, “okv nonu tvya magvrila. Nonu ogubv lvkodv tvvnwng dunv? Lvkonyika nonu ninyigv lvbwlaksu bv rinwng pvnv gubvre?” ");
INSERT INTO tgj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bunu ninyia beela okv minto, “No vlo nyi gv lvbwlaksu gumabv; vbvritola ngonu Moses gv lvbwlaksu vdwv. ");
INSERT INTO tgj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ngonu chindu Pwknvyarnv Mosesnyi raarwksuto; ogubvrijeka, vlo nyi anga, ngonu chima hv ogolokv aapvnvdw!” ");
INSERT INTO tgj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nyi angv mirwkto, “Hv tvvkwkaakw manam gulaka! nonu chima hv ogolokv aapvnvdw, vbvritola hv nga ngoogv nyikching nama mvpu jipvku! ");
INSERT INTO tgj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ngonu chindu Pwknvyarnv vdwloka rimurnv nyi ha tvvma dunv; hv tvvdu nyi yvvdw ninyia mvngdv dunv okv ninyigv minam ha rinv vdwa. ");
INSERT INTO tgj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sichingmookua pwklinyarlin rilokv naala Vjakgobv yvvka tvvpama nyi nga bvnglin lokv nyikching nvnga kaapa dukubv mvnv. ");
INSERT INTO tgj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","So nyi si Pwknvyarnv gvlokv aama nvgoilo hv vdwloka vkvnv aba go rinyu mare.” ");
INSERT INTO tgj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bunu mirwkto, “Nam rimurlo bvnglinla okv sotv pvkunv—okv no ngonua tamsar dubv rikwdoi?” Okv bunu ninyia Jius kumkunaam loka naalin toku. ");
INSERT INTO tgj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ogugo ripvkudw um vdwlo Jisu tvvpa tokudw, hv nyi anga kaapa toku okv ninyi tvkato, “No Nyia Kuunyilo nga mvngjwng dunvre?” ");
INSERT INTO tgj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nyi angv mirwkto, “Tamsarnv, hv yvvdw nga minpalabv ngo ninyia mvngjwng nyula dukubv!” ");
INSERT INTO tgj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisu ninyia minto, “No ninyia kaaropvkunv, okv ho nyi angv vjak nam lvkobv gaam raadung minsudo.” ");
INSERT INTO tgj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nyi angv minto, “Ahtu, ngo mvngjwng dukunv!” okv hv Jisu gv haabolo guplwk toku. ");
INSERT INTO tgj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisu minto, “Ngo nyiamooku so jwngkadaka tebv aapvnv, nyikching nvngv kaaparungdu kubv okv yvvdw kaapa dunv nyikching rungdu kubv.” ");
INSERT INTO tgj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisis nyi mego hoka ninyia lvkobv rinv, ninyia vbv mindubv tvvgvrila okv ninyia tvvkato, “Jvjvbv no ngonua ka nyikching nvngv vla minta madunvre?” ");
INSERT INTO tgj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisu mirwkto, “vbvrikunamv nonu nyikching nvgoilo, nonu rigakpanam dootvma; vbvritola nonu kaapadunv vla mimbwngla minro pvku, vbv minam si kunv nonu vjakgobv rigakpanam doodukunv.” ");
INSERT INTO tgj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisu minto, “Ngo nonua jvjv nga minjidunv: Yvvnyi ngv svlarnaam lo agi lokv aamadunv, vbvritola kvvbi lamtv lokv gvkarnv hv dvchonv okv dvritnaaritnv. ");
INSERT INTO tgj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yvvnyi ngv agi lokv aadunv hv svlar vdwa kaayanvngv. ");
INSERT INTO tgj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Agi kaayanvngv agi a ninyigv lvgabv mvkok jire; svlar vdwv ninyigv vlv nga tvvpare hv ninyigv svlar a amina minla gokrikunyi, okv hv bunua agumbv linggv reku. ");
INSERT INTO tgj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Vdwlo hv bunua agum lo linggv rilo, hv bunua vngchola vnggvdu, okv svlar vdwv ninyia vngming gvdu, ogulvgavbolo bunu ninyigv vlv nga tvvchin do. ");
INSERT INTO tgj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bunu kvvbia vngming gvmare; vmabvya bunu kiyu yare vkvnv nyi nga ogulvgavbolo bunu ninyigv vlv nga tvvchinma.” ");
INSERT INTO tgj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisu bunua so minchisinam sum minjito, vbvritola bunuv ogugonyi mindunvdw um tvchin mato. ");
INSERT INTO tgj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Vkvlvgabv Jisu lvkodv mindvto, “Ngo jvjv nga nonua minji dunvla: Ngo svlar gv agi ngv. ");
INSERT INTO tgj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kvvbi mvnwngngv yvvdw ngam aachoyadunv hv dvchonv okv dvritnaaritnv, vbvritola svlar hv bunua tvvma duku. ");
INSERT INTO tgj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngo agi v yvvdw ngo gvlokv arwng aadunv hv ringnam ha paare; hv arwnglo aare okv agumbv vngre okv nvmwng mapareku. ");
INSERT INTO tgj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Dvchonv arwng aadu ogulvgavbolo dvcho dubv, mvkidubv, okv mvyakmvchak dubv. Ngo aapvnv nonua svngsu alvbv singmu rimu dubv. ");
INSERT INTO tgj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ngo alvnv svlar kaayanv, yvvdw svlar lvgabv sidubv mvngnv ngv, ");
INSERT INTO tgj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Svlar sokw manv okv kaaya riakw manv jonam nyi ngv vdwlo svcha nga aadu bv kaaparinyi, hv svlar a kayupila okv kiudunv; vkvlvgabv svcha ngv gamdu okv bunua charjung charngola charra dukunv. ");
INSERT INTO tgj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jonam nyi ngv kiudunv ogulvgavbolo hv jonam nyi vmwng okv svlar a alvbv kaaria madunv. ");
INSERT INTO tgj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngo alvnv svlar kaayanv. Abu ngam chindu okv ngo Abunyi chindu, vkv aingbv ngo ngoogv svlar ha chindu okv bunu ngam chindu. Okv ngo bunugv lvgabv sidubv mvngdunv. ");
INSERT INTO tgj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ngoogv svlar kvgonv so svlarnaam soka doomanv vka doodunv. Ngo bunuaka so naalwk rungre, bunu ngoogv vlv nga tvvre, okv bunu svlar vdwa akin gubvrila kaayanv akingv kaanam gubv rireku.” ");
INSERT INTO tgj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Abu ngam pakdunv ogulvgavbolo ngo ngoogv singnam a mvngnga sidubv mvngdunv, vkvlvga um ngo paakor nyula dukubv vla. ");
INSERT INTO tgj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yvvka ngoogv singnam ha ngoogv lokv dvrit mare. Ngo um ngo atubongv anyubv mvngnga supvnv, ngo um jilaka nyure okv ngo um naakurka nyula reku. So sumnv ngoogv Abu nga ritokv vla gamki la minam v.” ");
INSERT INTO tgj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lvkodv nyi vdwv apumlo so gaam vdw so gv lvgabv asak sutoku. ");
INSERT INTO tgj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bunugv lokv nyi achialvgo minyato, “Hv uyuvram gvdu! Hv surupv! nonu ninyia ogulvgabv tvvya dunv?” ");
INSERT INTO tgj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Vbvritola kvvbi vdwv minyato, “Nyi uyuvram gvnv ngv svbv minyu madunv! oguaingbv uyuvram v nyikchingnv nyi vdwa nyiktarla kaapa dukubv mvla nyudubv?” ");
INSERT INTO tgj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","So si svkar poolu bv ritoku, okv Pwknvyarnvnaam a kumkok jokok lwkdw pumja nga Jerusalem lo ritoku. ");
INSERT INTO tgj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisu Pwknvyarnvnaam gv Solomon Pvrvlo vngkarto, ");
INSERT INTO tgj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","vdwlo nyi vdwv ninyia goyum tokudw okv tvvkato, “No ngonua vdwnvgo ayungbv angaaja mobwng modubv? Jvjv nga ngonua minjilabv: no Kristo rungre?” ");
INSERT INTO tgj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisu mirwkto, “Ngo nonua mintam jipvkunv, vbvritola nonu nga mvngjwng mato. Ngo, ngo Abu gv ngo lvgabv tolwkkunam ha minku lokv ngo hvkvnv ogu vdwa ridu; ");
INSERT INTO tgj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","vbvritola nonu mvngjwng mare, vkvlvgabv nonu ngoogv svlar ma. ");
INSERT INTO tgj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngoogv svlar v ngoogv minam ha tvvya dunv; ngo bunua chindu, okv bunu ngam vngming gvdu. ");
INSERT INTO tgj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ngo bunua turbwngnv singnam ha jidunv, okv bunu vdwloka sikumare. Yvvka bunua ngoogv loka dvrit nyulamare. ");
INSERT INTO tgj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ngo Abu gv ngam jinammv ogumvnwng nga kaiyanvngv, Abu gv ringchum kunam lokv yvvka bunua dvrit nyulamare. ");
INSERT INTO tgj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Abu la ngo akinnv.” ");
INSERT INTO tgj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Vbvrikunamv nyi vdwv ninyia ordubv vla vlwng naarap nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisu bunua minto, “Abu gv ngam ritokv vla jinam a ngo alvnv achialvgo nonugv kaakulo ritoku; so gv alvnv rinam sokv ogubv nonu nga vlwng ortv dunv?” ");
INSERT INTO tgj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bunu mirwksito, “Ngonu nam alvnv rinam lvkwngbv vlwng ortvma, vbvritola no gv Pwknvyarnvnyi minyingminchu kunam lvkwnglo! No nyi nyimummv mvngchik, vbvritola no atuv Pwknvyarnv gubv mvsudubv rikwngdu!” ");
INSERT INTO tgj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisu mirwkto, “So si nonugv Pvbv lo lvkpvpv Pwknvyarnv minto, ‘Nonu Pwknvyarnv vdwv.’ ");
INSERT INTO tgj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ngonu chindu Darwknv Kitaplo ogugo lvkpvdw hv jvjv bwngre; okv Pwknvyarnv ho nyi vdwa Pwknvyarnv vdwv vla minto, ninyigv doin a jikunam nyi vdwa. ");
INSERT INTO tgj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ngogvbv Abu ngam darto okv nyiamooku lo imuto. Vbvrikunamv, ngo Pwknvyarnv gv Kuunyilo ngv vnam lvkwnglo nonu ngam oguaingbv Pwknvyarnvnyi minyingminchudu vla minyu dunv? ");
INSERT INTO tgj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Vbvrikunamv ngam mvngjwng mabvka, ngo ngo Abu gv ngam ritokv vnam ha rima dunvlo. ");
INSERT INTO tgj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Vbvritola ngo bunua rijeka, nonu ngam mvngjwngma, nonu ngoogv rinam lokaka achukgo mvngjwng tvvka, Abu ngoogvlo doodu okv ngo Abu gvlo doodu vla nonu mvnwngngv chiminam lvgabv.” ");
INSERT INTO tgj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bunu lvkodv Jisunyi naatung dubv rikwto, vbvritola hv bunugv laak lokv doksok lintoku. ");
INSERT INTO tgj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Vbvrikunamv Jisu lvkodv vngkorla Jordan svko nga rapbola Jon gv baptisma jikulo vngtoku, okv hv hoka doolwk toku. ");
INSERT INTO tgj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nyi vdwv nw gvlo achialvgo aatoku. “Jon lamrwpanam rila kaatam ma,” bunu minto, “Vbvritola ninyigv so nyi gv lvgabv minam mvnwngngv Jvjv rungpv.” ");
INSERT INTO tgj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Okv hoka nyi achialvgo ninyia mvngjwng toku. ");
INSERT INTO tgj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nyi ako aminv Lajaras vnamgo, nw Betani lo doonvgo lvvma toku. Betani vnamsi bangguv hoka Meri okv ninyigv bormv Marta dooto. ");
INSERT INTO tgj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","So gv Meri angv si Jisunyi nampunv tvli lvpa lo piaknv okv um ninyigv dumpo dwmw lokv tipwnv angv; lvvmanv angv Lajaras ninyigv boru bv rito. ");
INSERT INTO tgj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Anyibormv nyingv Jisunyi gaamgo milwk toku, “Ahtu, no gv ayanam ajin hv lvvma pvkv.” ");
INSERT INTO tgj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Vdwlo Jisu um tvvpa tokudw, nw minto, “So gv lvvma angv gv anyung ngv Lajarasnyi sinam gubv rimare; so rinam si Pwknvyarnvnyi kaimonam lvgabv, okv so si vbvrinam hv Pwknvyarnv gv Kuunyilo ngvka hartvnam paare.” ");
INSERT INTO tgj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisu Marta nyila ninyigv anyinyi okv Lajarasnyi paktoku. ");
INSERT INTO tgj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Vbvrijvka vdwlo hv Lajaras lvvmapvkv vnam yunying nga tvvtolaka ninyigv dooku hoka hv alu lonyi godv doodv toku. ");
INSERT INTO tgj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Vbvrikunamv nw ninyigv lvbwlaksu vdwa minto, “Klai ngonu Judia bv vngkur lakuju.” ");
INSERT INTO tgj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Tamsarnv,” lvbwlaksu vdwv mirwkto, “Vjak mego ayungjvma nga nyi vdwv nam hoka vlwng ngv ordubv mvngnyato; no vngkur dukubv vla mvngdui?” ");
INSERT INTO tgj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisu minto, “Aluv gunta vring gola anyigo doodu, dooma dunvre? Vkvlvgabv yvvdw alu pua lo vngkar dunv hv pokmap madunv, hv nyiamooku gv lounglo kaapa kunam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Vbvritola hv ayu rinyi vngkar bolo hv pokmapdo, ogulvgavbolo hv loung dooma.” ");
INSERT INTO tgj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisu sum minto, okv vbvrikunamv mindvto, “Ngonu ajin Lajaras yupvku, vbvritola ngo vngla okv ninyi muu riku.” ");
INSERT INTO tgj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Lwbwlaksu vdwv mirwkto, “Ahtu, nw yupdung dvnvlo hv alvriku.” ");
INSERT INTO tgj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisu gv minam v manv Lajaras sipvku vla, vbvritola bunu hv yupching bv yuppv nvgo vla mvngto. ");
INSERT INTO tgj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Vkvlvgabv Jisu bunua jvjvbv mintam jitoku, “Lajaras siroku, ");
INSERT INTO tgj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","vbvritola nonugv lvgabv ngo mvngpudo ngo ninyia lvkobv dooma toku, vkvlvga nonu ho mvngjwng dukubv. Klvi hv gvlo vnglaju.” ");
INSERT INTO tgj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas (Bvngpiam vla minam) ninyigv ajin vdwa minto, “Klvi ngonu mvnwngngv Tamsarbonyi lvkobv vngming gvlaju, ngonuka ninyia lvkobv sikulo simi gvnam lvgabv!” ");
INSERT INTO tgj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Vdwlo Jisu vngchi tokudw, Lajarasnyi nyibung riku namv alu loopi dukubv hv paatoku. ");
INSERT INTO tgj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ngv Jerusalem lokv lvtw aom gubv rito, ");
INSERT INTO tgj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","okv Judia gv nyi achialvgo Meri okv Marta bunyigv boru sikunam lvgalo mvngdwk mabvkv vla mimbv okv kaalwkbv aanyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jisu aariku vla vdwlo Marta tvvpa tokudw, nw kaarwk sidubv vnglintoku, vbvritola Meri naam lo dootoku. ");
INSERT INTO tgj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jisunyi mintoku, “Ahtu, no so doonv guilo ngoogv boruv sima dvnvpv! ");
INSERT INTO tgj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Vbvritola ngo chindu vjakka no ninyia ogugo koodudw Pwknvyarnv nam jire.” ");
INSERT INTO tgj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisu ninyia mintam toku, “No gv boruv turkur reku.” ");
INSERT INTO tgj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta mirwksito, “Ngo chindu, hv ataranya alulo turkur reku.” ");
INSERT INTO tgj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisu ninyia minto, “Turkurkunam vla singnam v ngo. Yvvdw nga mvngjwng dunv hv turre, hv sikujeka; ");
INSERT INTO tgj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","okv yvvdw singdunv okv ngam mvngjwng dunv hv vdwloka simare. No sum mvngjwng dunvre?” ");
INSERT INTO tgj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Hv mirwkto, “Vkv, Ahtu! ngo mvngjwng dunv no Kristo, Pwknvyarnv gv Kuunyilo, yvvdw nyiamooku so aajikunv ngv.” ");
INSERT INTO tgj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta sum minro kochingbv nw vngkur toku, okv ninyigv anyi Merinyi minsila minjito. “Tamsarbo si doodu,” hv anyia minjitoku, “okv nam tvvkadu.” ");
INSERT INTO tgj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Vdwlo Meri sum tvvpa tokudw, hv gudung toku okv ninyia kaarwk sudubv baapubv vnglintoku. ");
INSERT INTO tgj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisu vjaklodvbv nampumlo aachi madvto, vbvritola Marta gv ninyia kaarwk suku mookulo doobwngto. ");
INSERT INTO tgj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nyi vdwv naam lo Merinyi lvkobv doonv vdwv ninyia mvngdwk mabvkv vnyato, ninyia vngming gvnyato, vdwlo bunu ninyia baapubv gudungdanv agumbv vnglin nama kaato kudw, bunu ninyia nyibung lo kapdubv vngji nvgo vla mvngnyato. ");
INSERT INTO tgj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jisu ogolo doopvdw hoka Meri vngchi toku, okv hv baapubv ninyia kaapa danam gula, hv Jisu gv lvpa lo gipv toku. “Ahtu,” hv minto, “No so doonv guilo, ngoogv boruv sima dvnvpv!” ");
INSERT INTO tgj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisu ninyia kapdubv kaatoku, okv ninyia lvkobv rinv vdwvka oguaingbv kapdudw umka kaatoku; vbvrinam hv ninyigv haapok ka mvsit la, okv achialvbv mvngdwk motoku. ");
INSERT INTO tgj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hv bunua tvvkato, “Nonu ninyia ogolo nyibung riipvnv?” Bunu mirwkto, “Ahtu, Aala okv kaatoka.” ");
INSERT INTO tgj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisu kapto. ");
INSERT INTO tgj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nyi vdwv minto, “Kaatoka, ninyia achialvbv pakdu!” ");
INSERT INTO tgj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Vbvritola bunu megonv minto, “Hv nyikching nvnga kaapa dukubv mvtoku, nw mvmma pvnvre? Nw Lajarasnyi sima dubv mvnyu mapv nvdw?” ");
INSERT INTO tgj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lvkodv mvngdwk hilok laikula dooku mabvku, Jisu nyibung lo vngtoku hv lvngpwk bv rito agi aagia nga vlwng ajap nvgo jootum kunam go. ");
INSERT INTO tgj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisu minto, “Vlwng nga dvato!” Marta, sinv nyi angv gv anyiv, mirwkto, “Ahtu, hoka naya amokrikv. Ninyia nyibung riikunamv alu loopi roku!” ");
INSERT INTO tgj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisu ninyia minto, “Ngo nam mimapvnvre, no mvngjwng bolo Pwknvyarnv gv jwkrw nga kaapare vla?” ");
INSERT INTO tgj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bunu vlwng nga dva toku. Jisu aobv kaadungto okv minto, “Abu, ngo nam umbonyikv, no nga tvvyadu. ");
INSERT INTO tgj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngo chindu no lokia ngam tvvyadu, vbvritola ngo sung mindu so nyi vdw so gv lvgabv, ogulvgavbolo so nyi vdw si no ngam vngmupvnv vla mvngjwng dukubv.” ");
INSERT INTO tgj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hv vbv minro kochingbv, hv gamtv rungbv gokto, “Lajaras, lintokuka!” ");
INSERT INTO tgj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hv nyibung lokv lintoku, ninyigv lvpa laak ha vji puching dvdubv, okv nyukmu haka puching dvdubv. Jisu bunua minto, “Ninyia paksok la, okv vngmu tokuka.” ");
INSERT INTO tgj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nyi achialvgo Merinyi kaalwkla aanv vdwv Jisu ogugo ripvkudw kaanya toku okv bunu ninyia mvngjwng nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Vbvritola megonv bunu Parisis vdwgvlo vngkur toku okv Jisu ogugo ripvkudw minpa toku. ");
INSERT INTO tgj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Vkvlvgabv Parisis vdwv, okv nyibu butvnv vdwv Kvba vdwa lvkobv kaarwksuto okv minto, “Ngonu oguridukubv? Kaatokuka so nyi gv lamrwpanam kaatamnam ma! ");
INSERT INTO tgj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ngonu so nyi sum svbv ribwng mobolo, nyichar mvnwngngv ninyia mvngjwng riku, okv Roman nyi kainv vdwv tvvchar kayarre okv ngonugv Pwknvyarnvnaam ha mvyakmvchak riku okv ngonugv haalung ngakka!” ");
INSERT INTO tgj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bunugv lokv akonv, aminv Kayapas, yvvdw ho anying hoka Nyibu Butvyachok nvbv rinv angv, minto, “Nonu ogu pvcha pvnvri! ");
INSERT INTO tgj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nonu mvngdi malare, haalung gv yaktv svnga, nonugv lvgabv alvyanvngv, nyi akin gonv nyi vdwgv lvgabv siria monam si?” ");
INSERT INTO tgj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Minjvjvbolo hv sung atuv mvngsula mimato; vmabvya hv ho anying gv Nyibu Butvyachok nvbv rinam lvgabv, hv nyikrw kaala Jisu Jius nyi vdwgv lvgabv siria tvdu vla, ");
INSERT INTO tgj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","okv bunua mvngchikma, vbvritola Pwknvyarnvnyi mooku mvnwnglo doosik kunv vdwa akin gubvku naadumsidu kubvka. ");
INSERT INTO tgj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ho alu lokv Jius nyi kainv vdwv Jisunyi mvkidubv rungtoku. ");
INSERT INTO tgj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Vkvlvgabv Jisu Judia mookulo nyi kaagialo vngkar matoku, vbvritola vngyu toku okv chukrimooku nvchi mooku gulo vngtoku, Epraim vnam banggu gulo hoka ninyigv lvbwlaksu vdwa lvkobv doolwk toku. ");
INSERT INTO tgj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Vngbokunam Pumja dvdw ngv nvchi toku, nyi achialv go mooku lokv pumja rima dwbv ridar kakdar koodubv vla Jerusalem lo aanya toku. ");
INSERT INTO tgj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bunu Jisunyi kaakarnyato, okv bunu Pwknvyarnvnaam lo vngkum nyatoku, bunu akonv ako nvnga tvvka minsuto, “No ogubv mvngdu? Hv pumja so aarung mare, ma aaridw?” ");
INSERT INTO tgj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nyibu butvnv vdwv okv Parisis vdwv orto jipvpv yvvdw Jisu ogolo doopvdw um chinv ngv, hv minpa laka, vkvlvgavbolo bunu ninyia naatung nyudukubv. ");
INSERT INTO tgj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vngbokunam pumja ridwv alu lookv go doodubv, Jisu Betani bv vngtoku, ninyigv siku nvnga turkur mokunam Lajaras gv naam lo. ");
INSERT INTO tgj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bunu ninyigv lvgabv arium dvse go hoka mvpv jito, Marta ridurto ordubv; Lajarasnyi akonv yvvdw Jisunyi lvkobv tvbul lo dootung minggvnv. ");
INSERT INTO tgj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Vbvrikunamv Meri maatarbv arv doonv nampunv Nard tvli vkv pumchup go naatoku, um Jisu gv lvpalo pwke toku, okv um ninyigv dwmw lokv tipw toku. Ho gv tvli gv nampunv amok hv naam arwng mvnwnglo jukar toku. ");
INSERT INTO tgj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jisu gv lvbwlaksu vdwlokv akonv Judas Iskeriot—yvvdw ninyia koa kujinv angv—minto, ");
INSERT INTO tgj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ogubv so nampunv tvli sum ain lokdwng lvngngom gubv piokma pvnv okv morko nga heemanv vdwlo jima pvnv?” ");
INSERT INTO tgj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ninyigv sum minam si hv heemanv vdwa kaala tvla rigvdu vnamgo kaama, vbvritola hv dvcho nvgobv riato. Hv morko gvgianvnv nga gvla rigvto okv atubongv dvsidvpit suto. ");
INSERT INTO tgj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Vbvritola Jisu minto, “Ninyia akinbv risu moto! ninyia ogugo doogv pvkudw vvpvmoto nga nyibung ritvri alu gv lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","No alu gv lokia heema nvnga lvkobv ribam tvdu, vbvritola no ngam lokia ribam paaku mare.” ");
INSERT INTO tgj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nyitwng tvngtv go Jisu Betani lo doopvku vla tvvpa toku, vkvlvgabv bunu hoka vngtoku, Jisu dopvkv vnam mwngchik lokvma vbvritola Jisu gv nyi siku nvnga turkur mokunam, Lajaras nyika kaadu bvka. ");
INSERT INTO tgj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Vkvlvgabv Nyibu butvnv vdwv Lajaras nyika mvki tadubv rungtoku, ");
INSERT INTO tgj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ogulvgavbolo ninyigv lvgalo Jius nyi achialvgo bunua toa toku okv Jisunyi mvngjwng nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Alu logo nvnga kainv nyipam v Vngbokunam Pumja lo aanv vdwv Jisu Jerusalem lo aarikv vla tvvpa toku. ");
INSERT INTO tgj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Vkvlvgabv bunu taru ruda rumwng doodubv naatoku okv ninyia kaarwk sidubv vnglinla, goknyato, “Pwknvyarnvnyi hartvto! Ahtu gv amin bv aanv nga Pwknvyarnv ninyia boktalwkji laka! Pwknvyarnv boktalwkji laka Israel gv Dvbvnyi!” ");
INSERT INTO tgj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisu siak go paatoku okv vkvgv aolo gecha toku, Darwknv Kitaplo minam ching-ching bv, ");
INSERT INTO tgj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jayon pamtv gv nyi vdwa, busu mabvka! Siinv aarikunv nonugv dvbv ngv, Joklwk rikunv siak yakpa aolo dootokula.” ");
INSERT INTO tgj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ho dw hoka ninyigv lvbwlaksu vdwv sung chima toku; vbvritola vdwlo Jisu turkurla yunglit gubv ritokudw, bunu mvngpa toku Darwknv Kitaplo ninyigv lvga nga sum minpvku okv bunu ritoku sum ninyigv lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisu gv rikulo lvkobv rinv nyi vdwv vdwlo nw Lajarasnyi nyibung loka goklin kunam ha okv siku nvnga turkur mooku nama kaanv vdwv minpa nyatoku ogugo ripvkudw. ");
INSERT INTO tgj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Vbvrikunam lvgabv nyipam v ninyi kaarwk sutoku-ogulvgavbolo bunu tvvpa toku hv so lamrwpanam sum rila kaatampv vla. ");
INSERT INTO tgj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Vbvrikunamv Parisis vdwv akonv ako nvnga mimi sutoku, “No kaatoka, ngo oguka ria yala kuma! Kaakwto, nyiamooku nyi mvnwngngv ninyia reming gvdu kunv!” ");
INSERT INTO tgj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grik nyi mego Pumja lo kumdujodubv Jerusalem lo aanv nyi vdwgv apumlo vngming gvtato. ");
INSERT INTO tgj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bunu Pilip gvlo vngtoku (hv Galili gv Betsaida lokv ngv) okv minto, “Tamsarnv, ngonu Jisunyi kaanwngdo.” ");
INSERT INTO tgj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip vngtoku okv Andriunyi mintamto, okv bunyi anyiv vngtoku okv Jisunyi minpa toku. ");
INSERT INTO tgj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisu bunua mirwkto, “Nyia Kuunyilo gv kairungbv hartv paadwv aaduku. ");
INSERT INTO tgj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ngo nonua jvjv nga minjidunv: aam amchar hv kvdwbolo chilwkla simumabolo amchar hv charkin tvla doobwngre, vbvrikunamv um chilwkla simukubolo, hv hintar go amring ngv ringtvyare. ");
INSERT INTO tgj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yvvdw atugv singnam ha paksu dunv hv ung nyemuyare; yvvdw atubogv singnam ha nyiamooku so kaanwng madunv hv torbwngnama paayare. ");
INSERT INTO tgj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yvvdw nga mvdur ridur nvpv mvngdunv hv nga vngming gvvrung laka, vbvrikubolo ngoogv pakbuv ngo ogolo doopvdw lvkobv dooming gvreku. Okv ngoogv Abu nga mvdur ridur nvnga mvngdv re.” ");
INSERT INTO tgj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Vjak ngoogv haapok v adwkaku do—okv ngo ogugo mvku svngvdw? Ngo vbv minre, ‘Abu, so gv dw sum ngoogvlo aamu mabv?’ Vbvritola ngo ho lvgabv aapvnv-so gv hirukaya sung ngo hirung svngvrung. ");
INSERT INTO tgj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Abu no gv aminha kai moya toka!” Vbvrikunamv nyido mooku tolokv vlv go duluto, “Ngo um yungnam gubv naalwk pvkunv, okv ngo lvkodv vbv ritare.” ");
INSERT INTO tgj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hoka nyipam daknv vdwv vlv nga tvvpato, megonv bunu minto, hv doogum go, kvgonv minto, “Nyido gindung gunv ninyia raami supv!” ");
INSERT INTO tgj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Vbvritola Jisu bunua minto, “Ho gv vlv dunam v ngoogv lvgabvma, vbvritola nonugv lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vjakgv alu si nyiamooku a jwngkadakaku alu vku; vjak nyiamooku gv dvbv nga chara reku. ");
INSERT INTO tgj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Vdwlo ngam nyiamooku sokv naacha rekudw, ngo nyichar mvnwngnga ngoogvlo naalwk sureku.” ");
INSERT INTO tgj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Svbv minam si ninyigv hirukayala sise nga minto. ");
INSERT INTO tgj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nyipam v mirwkto, “Ngonugv Pvbv lo mindu Kristo turla doobwngre. Vbvrikunamv, ogubv, no mindunv nyia Kuunyilo nga naacha riku vla? Nyia kuunyilo vnam si yvvla?” ");
INSERT INTO tgj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisu mirwkto, “Loung ngv achukgo nonu gvlo dooming gvmwngre. Loung gv ungla doorilo nonugv lamtvlo vnglvlaka, ogulvgavbolo nonu gvlo kanv ngv putum manam lvgabv; yvvdw kanv lo vngkar dunv chinsuma hv ogolo vngdung dunvdw. ");
INSERT INTO tgj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Vbvrikunamv, vdwgo loung ngv nonu gvlo doodudw, loung nga mvngjwng laka, vkvlvga nonu loung gv nyi bv ridubv.” Jisu sum minro kochingbv, vngyu toku okv bunugv lokv tosi sutoku. ");
INSERT INTO tgj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hv vdwnvgo bunugv kaakulo so lamrwpanam mvnwngnga rila kaatam kujeka, bunu ninyia mvngjwng matoku, ");
INSERT INTO tgj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","vkvlvga nyijwk Aijaya ogugo minpvdw v jvjvbv aarungre: “Ahtu, ngonugv doin minkunama yvvla mvngjwng jinv? Yvvnyila Ahtu gv jwkrw a kaatam tvvdunv?” ");
INSERT INTO tgj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Okv vkvlvgabv bunu mvngjwng nyula kuma, ogulvgavbolo Aijaya mindvto, ");
INSERT INTO tgj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pwknvyarnv bunugv nyik vdwa kaapa moma okv bunugv mongrumara nga mvtumro, vkvlvga bunugv nyikkv kaapa madu kubv, okv bunugv mongrumara ngv chima dubv, okv bunu nga dakrwk madubv, Pwknvyarnv minto, ngo amin bv bunua mvpu dubv.” ");
INSERT INTO tgj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aijaya sum mintoku ogulvgavbolo hv Jisu gv kai kuse nga kaapa chotokula okv ninyigv lvkwngbv minto. ");
INSERT INTO tgj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Vbvrikujeka, Jius nyi kainv achialvgo Jisunyi mvngjwng nyatoku; vbvritola Parisis vdwgv lvgalo bunu um minkokla milin nyumato, Jius kumkunaam lokv naalin konwng manam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bunu Pwknvyarnv gv naarwk sunamma mvngbiu mabv nyi gv naarwk sunamma mvngbiu yato. ");
INSERT INTO tgj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisu gamtv rungbv minto, “Yvvbunudw ngam mvngjwng dunv hv ngam mvngchikma vbvritola yvvdw ngam vngmupvnv nw nyika. ");
INSERT INTO tgj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yvvdw ngam kaadunv hv ngam vngmunv humka kaadunv. ");
INSERT INTO tgj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngo nyiamooku so loung gubvrila aapvnv, vkvlvga yvvdw ngam mvngjwngnv nyichar mvnwngngv kanv arwnglo doobwng manam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yvv akonv ngoogv doin ha tvvdunv okv um rima dunv, ngo ninyia jwngkadaka mare. Ngo nyiamookua jwngkadaka dubv aamapvnv, vbvritola um ringdubaadu bv aapvnv. ");
INSERT INTO tgj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yvvdw nga toa dunv okv ngoogv doin ha naarwk suma dunv um ninyia jwngkadaka reku. Ngoogv gaam japnam vdwv ataranya alulo ninyi jwngkadaka rireku! ");
INSERT INTO tgj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","So si jvjv ngv, ogulvgavbolo ngo atugv mvngnam lokv mimato, vbvritola ngoogv Abu ngam vngmunv hv ngo ogugo minse ngvdw okv japse ngvdw gamki nama um ngo mindunv. ");
INSERT INTO tgj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Okv ngo chindu ninyigv gamki namv torbwngnama naalwk jidu. Vbvrikunamv, ngo ogugo mindu kudw hv Abu gv nga mintokv vla mimu namv.” ");
INSERT INTO tgj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","So si Vngbokunam Pumja aluv loma dwbv loochoyanv alu bv rito. Jisu ninyigv nyiamookua kayupikula okv Abu gvlo vngdwv aaduku vla chintoku. Nw nyiamooku so nw gvbvrinv vdwa alu gv dwkia arwng rungbv paktoku okv nw bunua ataranya alu lobv pakbwngre. ");
INSERT INTO tgj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisu la ninyigv lvbwlaksu vdwv dvnam dvla doonyato. Uyudvbv ngv Saimon Iskeriot gv kuunyilo Judas Iskeriot gv haapok lo Jisunyi kubdubv mvnggv nvnv nga lwkro toku. ");
INSERT INTO tgj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisu Abu ninyia jwkrw mvnwngnga jilwk pvku vla chintoku; nw Pwknvyarnv gvlokv aanv ngv okv Pwknvyarnv gvlo vngtv rikunv vla chintoku. ");
INSERT INTO tgj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Vkvlvgabv hv tvbul lokv dakrap toku, ninyigv agumlo vji a pilin toku, okv vbee vkv leit am puchingsito. ");
INSERT INTO tgj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Vbvrikunamv nw gamla lo isi mego pwlwkto okv lvbwlaksu vdwgv lvpa vdwa harkak kakrap toku okv ninyigv leit lo puchingnam vbee lokv tipw toku. ");
INSERT INTO tgj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nw Saimon Pitar gvlo aatoku, Pitar ninyia mintoku, “Ahtu, no ngoogv lvpa nga harkak dubvi?” ");
INSERT INTO tgj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisu ninyia mirwkto, “No vjak chimare ngo ogugo ridung dunvdw, vbvritola no kokwngnyi chireku.” ");
INSERT INTO tgj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pitar minbwk toku, “Vdwloka ogubv rijeka no ngoogv lvpa nga harkak maji nvngv!” Jisu minrwkto “Ngo nonugv lvpa nga harkak mabolo, nonu ngoogv lvbwlaksubv rinyu mare.” ");
INSERT INTO tgj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pitar mirwkto, “Ahtu, ngoogv lvpa mvngchik ka harkak mabv, vbvkubolo! ngoogv laak okv dumpo ngaaka harkak labv!” ");
INSERT INTO tgj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisu minto, “Yvv bunudw horsok sokro pvkunv bunu mvnwngngv darwk pvkunv okv bunu atuv harkak sise kaakuma, bunugv lvpa vdwa mwngku. Nonu mvnwngngv darwk pvku—akin gomwng.” ");
INSERT INTO tgj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisu chintoku yvvdw ninyia kubjinv angv; vkvlvgabv nw minto, “Mvnwngngv darwk pvku, akin gomwng.” ");
INSERT INTO tgj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisu bunugv lvpa vdwa harkakro kochingbv nw ninyigv agum gv vji a pilwk sutoku okv ninyigv dooku tvbul lo aakur toku. Nw tvvkato, “Ngo vjak nonua ogugo ripvdw nonu chimpvre?” ");
INSERT INTO tgj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nonu nga Ahtu okv Tamsarnv vla mindu, okv si rijwkkv nonu svbv rila, ogulvgavbolo ngo vbv rirungdo. ");
INSERT INTO tgj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngo, nonugv Ahtu okv Tamsarnv, vjak nonugv lvpa vdwa harkakto. Vbvrikunamv, nonuka, akonv akonvgv lvpa nga harkak minsu laka. ");
INSERT INTO tgj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ngo nonua rimurilam jipvnv, nonua ngoogv nonua rinam apiabv rimu dubv vla. ");
INSERT INTO tgj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ngo nonua jvjv nga minjidunv: pakbu hv ninyigv Atua kaiyama dunv, okv jokria nvngv ninyia kanamla vngmunv anga kaiyama dunv. ");
INSERT INTO tgj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Vjak nonu so gv jvjv nga chindu, nonu achialvbv mvngpu reku sum nonu riying bolo!” ");
INSERT INTO tgj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ngo nonu mvnwngnga mima dunv; ngoogv darnam vdwa ngo chindu. Vbvritola Darwknv Kitaplo minam v jvjvbv rirungre ho mindu, ‘Nyi gunv ngoogv lvkobv dvbam dunv hv nga rinying riru duku.’ ");
INSERT INTO tgj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","So si rilinla ritvmadvbv ngo vjak nonua mincho jidunv, ho nonu mvngjwng reku ‘Ngo Yvvdw Ngo.’ ");
INSERT INTO tgj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ngo nonua jvjv nga minjidunv: yvvdw ngoogv kanamla vngmunam akonyi naarwksidunv hv ngam naarwk tadunv; okv yvvdw ngam naarwksidunv hv ngam vngmunv ninyia naarwksitadunv.” ");
INSERT INTO tgj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisu sum minro kochingbv, hv achialvbv mvngdwk mvngku lakula okv minlin toku, “Ngo jvjv nga nonua minjidunv: nonugv lokv akonv ngam koa tvduku.” ");
INSERT INTO tgj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lwbwlaksu vdwv akonv akonyi kaagap minsuto, achialvbv abwkalo kuma toku yvvnyi mindu nvbvre vla. ");
INSERT INTO tgj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Lwbwlaksu akonv, Jisu gv pakyachoknam angv, Jisunyi dochinsinvgo. ");
INSERT INTO tgj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pitar ninyia lakching ngv chigap lwngchingla mvto okv minto, “Ninyia tvvkato yvvnyi mindu nvbvre.” ");
INSERT INTO tgj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Vkvlvgabv ho lvbwlaksu angv Jisu gvlo hvngnwkto okv tvvkato, “Ahtu, hv yvvla?” ");
INSERT INTO tgj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisu mirwkto, “Ngo vtwng mego naala bati lo nwkbok tvvla ninyia jire; hv nyi angv.” Vkvlvgabv nw vtwng patung achukgo naato, um nwkbok toku, okv Saimon Iskeriot gv kuunyilo Judasnyi jitoku. ");
INSERT INTO tgj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas vtwng nga dvdanam gula Uyudvbv ngv baapubv nw gvlo aatoku. Jisu ninyi minto, “No ogugo ridung dudw baapubv ritoka!” ");
INSERT INTO tgj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tvbul lo doonv kvvbi nyi vdwv chimato Jisu ninyia sum ogugbv minpv nvdw. ");
INSERT INTO tgj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas morko bvngya nvgobv rikunam lvgabv, lvbwlaksu megonv Jisu ninyia Pumja gv lvgabv ogugo rvvmu tvbv vmalo heemanv vdwa ogugo jimu tvbv vngmupvnv go vla mvngto. ");
INSERT INTO tgj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas vtwng nga naarwksuto okv vjakgobv agumbv lintoku. Ho kanv toku. ");
INSERT INTO tgj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas gv vngro kochingbv, Jisu minto, “Vjak Nyia Kuunyilo gv kai nama kaapa duku; vjak nw gvlokv Pwknvyarnv gv kai nama kaapa duku. ");
INSERT INTO tgj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pwknvyarnv gv kai nammv nw gvlokv kaapa duku nvbolo, vbvrikunamv Pwknvyarnvnyi Nyia Kuunyilo gv kai nama ninyigv lokv kaatamre okv hv vbv vjakgobv rireku. ");
INSERT INTO tgj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ngo gv kuu vdwa, ngo nonua kaigo lvkobv ribam kumare. Nonu nga kaakar reku; vbvritola ngo vjak nonua mindunv ngo oguaingbv Jius nyi kainv vdwa mindudw, ‘Ngo ogolo vngdudw nonu vngnyu mare.’ ");
INSERT INTO tgj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Okv ngo vjak nonua anwnv gamki gaamgo jidunv: ajin anyingnga pakmi sulaka. Ngoogv nonua paknam apiabv, vkvlvgabv nonuno pakmi sulaka, ");
INSERT INTO tgj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nonu akonv akonvnga pakmi sibolo, vbvrikunamv nyi mvnwngngv chinreku nonu ngoogv lvbwlaksu v vla.” ");
INSERT INTO tgj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pitar ninyia tvvkato, “Ahtu, no ogolo vngtv dunv?” Jisu mirwkto, “No vjak vngming gvnyu mare ngoogv vngkulo; vbvritola kokwnglo no nga vngming gvreku!” ");
INSERT INTO tgj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pitar tvvkato, “Ahtu, ogulvgabv ngo vjak nam vngming gvnyu madubv?” “Ngo noogv lvgabv siso mvngdunv!” ");
INSERT INTO tgj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisu mirwkto, “No jvjvbv ngoogv lvgabv sidubv mvngpv pvnvre?” Ngo nam jvjv nga minjidunv: rokpuv koktv madvbv no ngam chima vla lvom go minre. ");
INSERT INTO tgj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Mvngdwk mvngkula doomabvka,” Jisu bunua minto. “Pwknvyarnvnyi mvngjwng laka okv ngaaka mvngjwng laka. ");
INSERT INTO tgj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngo Abu gv naam tv karchung ngv awgo doodu, okv ngo nonugv lvgabv dooku riku mvpvripv jitebv vngjinv. Minggvdvnam si doorung mabolo ngo nonua svbv mima dvnvpv. ");
INSERT INTO tgj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Okv ngo vngla nonugv lvgabv dooku riku nga mvpv ripvro kochingbv, ngo aakur reku okv ngo atuv nonua naareku, vbvrikubolo ngo ogolo doopvdw nonuka dooming gvreku. ");
INSERT INTO tgj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nonu chindu ngoogv vngjiku mooku lo vnglwknv lamtv nga.” ");
INSERT INTO tgj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas ninyia minto, “Ahtu, ngonu chima noogv vngku lamtv nga; vkvlvgabv tolo chaalwk dubv oguaingbv ngonu lamtv nga chinyu dubv?” ");
INSERT INTO tgj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisu ninyia mirwkto, “Ngo lamtv ngv, jvjv ngv, okv turnammv; ngo gvlokv vngmabv yvvka Abu gvlo vngnyu mare. ");
INSERT INTO tgj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Vjak nonu ngam chimpvku,” nw bunua minto, “Nonu ngoogv Abu nyika chinreku, okv vjak gvlokv nonuka ninyia chireku okv nonu ninyia kaakw pvku.” ");
INSERT INTO tgj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip ninyia minto, “Ahtu, Abunyi ngonua kaatam labv; si ngonu mvnwng gv mvngnamv.” ");
INSERT INTO tgj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisu mirwkto, “Pilip, ngo nonua mvngchi kumanamgo lvkobv reming gvkwng kunam vka nonu ngam chimai?” Yvvdw ngam kaadudw hv Abu nyika kaadunv, vbvrikunamv ogulvgabv no Abunyi ngonua kaatam labv vla mindunv? ");
INSERT INTO tgj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ngo Abu gvlo doodu okv Abu ngoogvlo doodu um Pilip no mvngjwng madunvre? Jisu ninyigv lvbwlaksu vdwa mintoku, “Ngoogv nonua gaam minam dvdv ngv, ngo gvlokv aama. Abu, ngoogvlo doonv ninyigv ridung nga atuv ridunv. ");
INSERT INTO tgj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngam mvngjwng laka ngo vdwlo abu ngoogvlo doodunv okv ngo Abu gvlo doodunv vla minam a. Ho malo, ngoogv rinam a kaagvrila mvngjwng tvka. ");
INSERT INTO tgj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ngo nonua jvjv nga minjidunv: yvvdw ngam mvngjwng dunv hv ngoogv rinam aingbv rire—am, hv kaiyanv goka rire, ogulvgavbolo ngo abu gvlo vngjinv. ");
INSERT INTO tgj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Okv nonu ngoogv amin bv ogugo kooridw ngo rijire, Abu gv kairungnv jwkrw nga Kuunyilo gvlokv kaatam kunam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nonu ngoogv amin bv ngam ogugo kooridw, ngo um rijire.” ");
INSERT INTO tgj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nonu nga mvngjwng bolo, nonu ngoogv gamki nama tvjirijire. ");
INSERT INTO tgj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ngo Abunyi koore, okv hv nonua ridur rianv kvvbigo jire, hv nonua dvbvsvngtambv dooming gvvre. ");
INSERT INTO tgj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hv Dow hv Pwknvyarnv gv jvjv nga kaatam rianv. Nyiamooku v ninyia naarwk nyumare, ogulvgavbolo hv ninyia chima vmalo kaakwma. Vbvritola nonu ninyia chindu, ogulvgavbolo hv nonu gvlo lvkobv doobwngdu okv nonu lo doodu.” ");
INSERT INTO tgj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Vdwlo ngo vngro jeka, nonua ngo opin jvbv doomu mare; ngo nonu gvlo aakur reku. ");
INSERT INTO tgj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nyia mooku hv ngam ayungjvma nga kaapa kumare, vbvritola nonu ngam kaare; ogulvgavbolo ngo turre, okv nonu ka turre. ");
INSERT INTO tgj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Vdwlo ho aluv lori kudw, nonu chinre ngo Abu gvlo doodu, okv nonu ngoogvlo doodu, ngo oguaingbv nonu gvlo doodudw ho apiabv.” ");
INSERT INTO tgj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Yvvdw ngoogv gamki nama torwk sudunv okv um tvduridunv hv ngam paknvrinvbv ridunv. Yvvdw ngam pakdunv um ngoogv Abu pakre; ngooka ninyia paktare okv ngo atuv ninyia kaatam sure.” ");
INSERT INTO tgj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","(Judas Iskariotnyi miyamabv) Judas gunv minto, “Ahtu, no atuv ngonua kaatamre okv nyiamookua kaatam sumare, hv oguaingbv ritv dunv?” ");
INSERT INTO tgj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisu ninyia minrwkto, “Yvvdw ngam pakdunv hv ngoogv tamsar nama tvduridunv. Ngoogv Abu ninyia pakre, okv ngo la Abu ninyi gvlo aala lvkobv dooming gvvre. ");
INSERT INTO tgj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yvvdw ngam pakma dunv ngoogv tamsar nama tvvmarima dunv. Okv nonugv tvvnam ngoogv tamsar namv ngo gvngvma, vbvritola ngam vngmunv Abu gvlo naapvnv.” ");
INSERT INTO tgj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ngo nonua minpvkunv nonuam lvkobv doodula. ");
INSERT INTO tgj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ridur rianv, Darwknv Dow, Abu gv ngo amin bv imu kujinam v, nonua tamsarre okv ngoogv nonua minam dvdv nga mvngpa more.” ");
INSERT INTO tgj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nonua ngo sarsopoyo nama lvkobv kayu jido; so si ngo atugv sarsopvyo nama nonua jipvnv. Um ngo nyiamooku gv rinam aingbv jima. Mvngdwk mvngkula doomabvka; Busu mabvka. ");
INSERT INTO tgj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nonu ngam nonua ‘Ngo vngjinv, vdubv tvvdu, vbvritola ngo nonu gvlo aakur reku,’ nonu ngam pakdu bolo, ngoogv Abu gvlo vngnam ha nonu mvngpure; ogulvgavbolo hv ngam kaiyanv. ");
INSERT INTO tgj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ngo nonua mintam chodunv so gv ogumvnwng si ritv madvbv, vkvlvga vdwlo si rirekudw nonu mvngjwng reku. ");
INSERT INTO tgj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ngo nonua awgo raami sidubv rinyuma, ogulvgavbolo nyiamookua rigvdakgv nvngv aariku. Hvkvgv jwkrw ngv ngam rigum lamare, ");
INSERT INTO tgj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","vbvritola nyiamookuv chirung laka ngo Abunyi pakdunv; vkvlvgalo ngo ogumvnwng ngam ridunv ninyigv ngam minam dvdv nga.” “Aatoka, klvi so mooku lokv vngla kuju.” ");
INSERT INTO tgj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ngo singnv hampo ngv, okv ngoogv Abu nayam mvnv atuv. ");
INSERT INTO tgj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hv ngoogvlo hakbv asi svvma nvnga pala paa dunv, okv asi svvnv hakbv vdwa hv mvngi riadunv, vkvlvgavbolo abuyayabv asi svvmu dubv vla hv mvngi dunv. ");
INSERT INTO tgj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nonua mvngi ropvkunv (darwk dubv mvpvkunv) ngoogv nonua tamsar kolokv. ");
INSERT INTO tgj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ngoogvlo doolwk laka, okv ngo ka nonu gvlo doolwkre. Hakbv ngv atuv asi svvnyu madunv; hakbv ngv asi svvlare vdwlo hv hampo nga hargap tvla dooridw. Vkv aingbv nonu asi svvnyu mare vdwlo nonu ngam rwkrwk mvla gakbwngla doomaredw.” ");
INSERT INTO tgj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ngo hampo ngv, okv nonu hakbv ngv. Yvvdw ngam rwkrwk mvla gakbwng doonv, ngo ka ninyia, hv achialvbv asi svvre; ngam kayu tvla nonu oguka rinyu mare. ");
INSERT INTO tgj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yvvdw ngam gakbwng madunv (ngoogvlo doolwk madunv), hakbv nga mvnam apiabv ora dunv okv simudunv; vkvnv hakbv nga naakum dukunv okv vmvlo orlwk dukunv, hoka bunua vmv ramdu kunv. ");
INSERT INTO tgj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nonu ngoogvlo doobwng bolo okv ngoogv gamchar vdwv nonu gvlo doore, vbvrikunamv nonugv mvngnam lokv ogugo kooridw, nonu um paare. ");
INSERT INTO tgj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nonugv achialvbv asi svvku lokv ngo Abu gv kairungnam ha kaapa dunv; okv vbvrila nonu ngoogv lvbwlaksu bv ridunv. ");
INSERT INTO tgj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Abu gv ngam paknam aingbv, ngo nonua pakdunv; ngoogv pakkulo doobwng laka. ");
INSERT INTO tgj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nonu ngoogv gamki nama tvboribolo, nonu ngoogv paknam lo doobwngre, ngo Abu gv gamki nama tvvla rila ninyigv paknam lo doobwng nam aingbv.” ");
INSERT INTO tgj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ngo sum nonua mintam pvkunv, vkvlvgavbolo ngoogv mvngpuv nonu gvlo doolwk dubv okv nonugv mvngpuv achialv dukubv vla mindunv. ");
INSERT INTO tgj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ngoogv gamki la minammv siinv: akonv akonyi pakmi sulaka, ngoogv nonua paknam aingbv. ");
INSERT INTO tgj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Akonv ajin vdwgv lvgabv ninyigv turnama mvngnga jikunv v kaiyachokbv paknam jinamv. ");
INSERT INTO tgj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Okv vdwlo nonu ngoogv gamki nama ribolo, nonu ngoogv ajin v. ");
INSERT INTO tgj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ngo nonua pakbu vla minku mare, ogulvgavbolo pakbuv chima ninyigv atuv ogugo ridudw. Vmabvya, ngo nonua ajin vla mindunv, ogulvgavbolo ngo vdwgo ngo Abu gvlo tvvpvkudw nonua mintam pvkunv. ");
INSERT INTO tgj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nonu ngam darma; ngo nonua darpvkunv okv vngla turbwngnv asi lokv achialvbv svvmudubv tolwk pvkunv, okv nonu ngoogv amin bv Abunyi ogugo kooredw nw nonua jire. ");
INSERT INTO tgj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Vbvrikunamv, sum ngo gamki la mindunv: akonv akonyi pakmi sulaka.” ");
INSERT INTO tgj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nyiamooku hv nonua kaanwng madubolo, nonu mvngpa dalaka hv ngam kaanwng mabv richo dunv. ");
INSERT INTO tgj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nonu nyiamooku gvngvbolo, vbvrikunamv, nonua nyiamooku v atu gvngv vla pakdu nvpv. Vbvritola ngo nonua nyiamooku loka darpvkunv, okv nonu nyiamooku gvbv rikuma; vkvlvgabv nyiamookuv nonua kaanwng madunv. ");
INSERT INTO tgj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mvngpa laka ngo nonua ogugo minpvkudw: ‘pakbuv ninyigv atua kaiyama dunv.’ Bunu ngam mvdwkmvku bolo, bunu nonua ka mvdwkmvkure; bunu ngoogv tamsar nama tvvdu bolo, bunu nonua ka tvvre. ");
INSERT INTO tgj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Vbvritola bunu nonua so mvnwng sum rire ogulvgavbolo nonu ngo gvngv; bunu ngam so imunv anga chima. ");
INSERT INTO tgj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngo bunu gvlo aala mima nvgoilo, bunu vdwloka chinsu mare bunu rimur nvngv vla; vjak vbvrikujeka, bunugv rimur gungnying nga vjak anyubv kayu laku mare. ");
INSERT INTO tgj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yvvdw ngam kaanwng madunv hv ngoogv Abu nyika kaanwng madunv. ");
INSERT INTO tgj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bunu rimurnvngv vla chinsu mapvnvpv, ngo bunu gvlo nyi gv rikw manam vdwa rima nvgolo; vbvdvdvbv, bunu kaato ngo ogugo ripvkudw, okv bunu ngam okv Abu ngunyia kaanwng madu. ");
INSERT INTO tgj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Svbvrinam si bunugv Pvbv kitaplo ogugo lvkchola lvkpv pvdw um jvjvbv rilin monam lvgabv ripv, ho vbv lvkpv: ‘Bunu ngam oguguka gungnying kaamabv kaanwng madu.’” ");
INSERT INTO tgj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Riduryanv aare—Dow v, hv Pwknvyarnv gvlokv aanv okv Pwknvyarnv gv jvjv nga kaatam mintam rianv. Ngo ninyia nonu gvlo vngmure, okv hv ngoogv lvkwng nga japjire. ");
INSERT INTO tgj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Okv nonuka, ngoogv lvkwng nga japjire, ogulvgavbolo nonu ngam atuk lokv reming gvkunv.” ");
INSERT INTO tgj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ngo nonua sum mintam pvkunv, vkvlvgavbolo nonuno mvngjwng nga topu madubv. ");
INSERT INTO tgj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nonua Jius vdwgv Kumkunaam loka naalin reku, okv vkvnv dw v aareku nyi gonv nonua mvki tokula Pwknvyarnv gv lvgabv ripvnv vla mvngsure. ");
INSERT INTO tgj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nyi vdwv nonua svbv rireku ogulvgavbolo bunu Abunyi vmalo ngaaka chima kunam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Vbvritola ngo nonua sum minjidunv, vkvlgavbolo vdwlo bunu so ridubv ridwv aarikudw, nonu mvngpa reku ngo nonua mintam jipvkunv vla.” “Ngo nonua ribamnam lvgabv, kvvlo ngo soogv vdw sum nonua mintam mapvnv. ");
INSERT INTO tgj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Vbvritola vjak ngo vngjikunv ngam vngmunv gvlo, vjakka nonugv lokv yvvka ngam ogolo vla tvvka nvgoka kaama. ");
INSERT INTO tgj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Okv vjak ngo nonua mintam pvkunv, nonugv haapok hv mvngru yayabv ripvku. ");
INSERT INTO tgj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Vbvritola ngo nonua jvjv nga minjidunv: so si nonugv lvgabv alvyare ngo vngyu namv, ogulvgavbolo ngo vngma bolo, ridur rianv nonu gvlo aamare. Vbvritola ngo vngyu kubolo, ngo ninyia nonu gvlo vngmu reku. ");
INSERT INTO tgj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Okv vdwlo hv aarikudw, hv nyiamooku gv nyi vdwa hinchinkaachin moreku, bunu vdwv rimurlo doodu kunvnyi vla, alv ngv oguvkudw, okv Pwknvyarnv gv jwngkadaka dw alu gv lvkwng nga hinchinkaachin reku. ");
INSERT INTO tgj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bunu rinying riru la rimurdu, ogulvgavbolo bunu ngam mvngjwng manam angv; ");
INSERT INTO tgj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Jvjv ngv oguvdw um rimayabv bunu rimurdu, ogulvgavbolo ngo Abu gvlo vngjikunv okv nonu ngam lvkodv kaapa kumare; ");
INSERT INTO tgj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Jwngkadaka gv lvkwnglo bunu mvngmur nyadu, ogulvgavbolo nyiamooku sum rigvnv vdwa jwngkadaka ropvkunv.” ");
INSERT INTO tgj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ngo nonua minta sengv awgo doodu, vbvritola vjak nonu awyaje nga gvla mare. ");
INSERT INTO tgj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Vdwlo Dow hv aarikudw, hv Pwknvyarnv gv jvjv nga kaatamre, hv nonua jvjv lo vnggvre, hv vdwloka hv atubongv tojupkunam jvbv minsumare vbvritola hv ogugo tvvpvdw um minre, okv aaji nvgv ogu-ogua nonua minpa jire. ");
INSERT INTO tgj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hv ngam yungnam gubv rimure, ogulvgavbolo hv ngoogv minam a naala nonua minjire. ");
INSERT INTO tgj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ngo Abu ogugo doodudw hv mvnwngngv ngokv, vkvlvgabv ngoogv minamv hvvnv Dow v ngo minam dvdv nga naala um nonua minjire.” ");
INSERT INTO tgj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Achukgo ayungjvma nga nonu nga kaapa mare, okv achukgo ayungjvma gv kochinglo nonu nga kaapareku.” ");
INSERT INTO tgj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ninyigv lvbwlaksu vdwv bunugv aralo tvvka minsuto, “So gv minam si ogu gubvre? Hv ngonua mintamdu achukgo ayungjvma nga ngonu ninyia kaapamare, okv vbvrikunamv achukgo ayungjvma gv kochinglo ngonu ninyia kaapa reku; okv hv mintadu, ‘So si ogulvgavbolo ngo abu gvlo vngjikunv.’ ");
INSERT INTO tgj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ogu gubvre so gv ‘achukgo ayungjvma nga’ vla minam si? Hv ogugonyi mindunvdw ngonu chima!” ");
INSERT INTO tgj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisu chintoku bunu ninyia tvu dubv mvngdu vla, vkvlvgabv nw bunua minto, “Ngo minto, ‘Achukgo ayungjvma nga nonu nga kaapamare, okv vbvrikunamv achukgo ayung jemagv kochinglo nonu nga kaapareku’ si re nonugv aralo tvvka minsu namv? ");
INSERT INTO tgj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ngo nonua jvjv nga minjidunv: nonu kapre okv ilokre, vbvritola nyiamookuv mvngpu puminre; nonu mvngrure, vbvritola nonugv mvngru runam v mvngpu gubv rilin reku. ");
INSERT INTO tgj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vdwlo nyimv gonv kuu bvngtv tvdudw, hv mvngrudu ogulvgavbolo ninyigv mvngru rudwv aakunam lvgalo; vbvritola vdwlo anga nga bvnglin rekudw, hv ninyigv hinching chingnam a mvngpa kumado, ogulvgavbolo hv anga nga nyiamooku so bvnglin pvku vla mvngpu duku. ");
INSERT INTO tgj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ho apiabv nonu gvloka: vjak nonu mvngrudu, vbvritola ngo nonua lvkodv kaapa minsureku, okv nonugv haapok lo mvngpu pulwk reku, vkvnv mvngpu gubv rire yvvka naala naa nyulamare.” ");
INSERT INTO tgj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Vdwlo hv aluv lori kudw nonu nga oguka kooku mare. Ngo nonua jvjv nga minjidunv: Abu nonugv ogugo kooridw ngoogv amin bv koonam a jire. ");
INSERT INTO tgj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Vjaklodvbv nonu ngoogv amin bv koonam kaama; kolaka okv nonu paare, vkvlvgavbolo nonugv mvngpuv punya mindu kubv.” ");
INSERT INTO tgj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nonua so vdw sum ngo minchisinam lokv minjito. Vbvritola vkvnv dw v aariku vdwlo ngo minchisinambv mima reku, vbvritola ngo Abu gv lvga nga nonua mindakvlabv minji reku. ");
INSERT INTO tgj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Vdwlo ho aluv lori kudw, nonu ninyi ngo amin bv kooriku; okv ngo nonugv lvgabv ninyia koonvpv vla mima, ");
INSERT INTO tgj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","vkvlvgabv Abu nonua atubongv paksudu. Hv nonua pakdu ogulvgavbolo nonu ngam pakdu okv ngam Pwknvyarnv gvlokv aapvnv vla mvngjwngdu. ");
INSERT INTO tgj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ngo Abu gvlokv aarungpvnv, okv ngo nyiamooku so aalwk pvnv; okv vjak ngo nyiamooku kayupikula okv Abu gvlo vngjikunv.” ");
INSERT INTO tgj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Vbvrikunamv ninyigv lvbwlaksu vdwv ninyia minto, “Vjak no minchisinam bv mimabv mindakvlabv mindu. ");
INSERT INTO tgj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vjak ngonu chinduku no ogumvnwng nga chinv go; nam tvvu jinv guka no dinchi kuma. Svbvrinam si no Pwknvyarnv gvlokv aanv ngv vla ngonua mvngjwng modu.” ");
INSERT INTO tgj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisu bunua mirwkto, “Vjak nonu mvngjwng dukure? ");
INSERT INTO tgj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ngam akinbv kayu tvla, nonu atu atugv naam lo kiakkipak dw hv aariku okv si aaropvku. Vbvritola ngo akin vmwng ma, ogulvgavbolo abu nga reming gvdu. ");
INSERT INTO tgj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ngo nonua sum minpvkunv nonu ngam lvkobv relwk minggv tvla mvngpu pumin dubv. Nyia mooku hv nonua hinching chingmure. Vbvritola mvngpak nvgobv ritolaka! Ngo nyiamookua rigum yapvkunv!” ");
INSERT INTO tgj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisu sum minro kochingbv, nw nyidomookubv kaadungto okv minto, Abu, dw v aapvku. Noogv Kuunyilo nga amina yunglit molaka, vkvlvgavbolo Kuunyilo ngvka noogv amina kaiyachok mola jidukubv. ");
INSERT INTO tgj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","No nyiamookua rigv dubv tojupkunam ha ninyia jito, vkvlvgavbolo nw noogv jinam a bunua turbwng nvnga jidubv. ");
INSERT INTO tgj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Okv turbwngnv singnam manv nam jvjvrungnv Pwknvyarnv akin vla chinam, okv Jisunyi no vngmu kunamv vla chinam. ");
INSERT INTO tgj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ngo nyiamooku so noogv amin kai nama kaatam pvkunv; noogv ritokv vla ridung jinama ngo rinya pvkunv. ");
INSERT INTO tgj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Abu! Nyia mooku ha pwklin yarlin madvbv noogv ngam amin kai dubv jinam aingbv. Vjakka no gv nvchilo ngam amin kai dubv jilabvka. ");
INSERT INTO tgj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nyia mooku so noogv ngam jinam vdwa noogv amina ngo bunua chimupvnv. Bunu no gvngvku okv no bunua ngam jito. Bunu noogv gamchar vdwa tvvpvripvku, ");
INSERT INTO tgj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","okv vjak bunu chimpvku noogv ngam ogumvnwng jinam vdwa no gvlokv aanv ngv vla. ");
INSERT INTO tgj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ngo noogv jinam doin ha bunua jipvkunv, okv bunu larwksupvku; bunu ngam noogv lokv jvjvbv aanv ngv vla chindu, okv ngam no vngmu pvnv vla bunu mvnjwngdu. ");
INSERT INTO tgj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ngo bunugv lvgabv kumdunv. Ngo nyiamooku gv lvgabv kumma vbvritola noogv ngam jinam vdwgv lvgabv, bunu no gvbv ripvku. ");
INSERT INTO tgj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngoogvlo ogugo doopvdw mvnwngngv no gvngv, okv noogv ogu mvnwngngv ngokvku; okv ngoogv amin kai nama bunugv lokv kaatam pvnv. ");
INSERT INTO tgj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Okv vjak ngo no gvlo chaarikunv; ngo nyiamooku so doobwng kumare, vbvritola bunu nyiamooku si doopv. Darwknv Abu! Noogv amin jwkrw lokv bunua alv dubv toryagaya laka, noogv nga amin jinam a vkvlvgavbolo bunuv akin gubv ridu kubv no la ngo oguaingbv akinpvdw vkv aingbv. ");
INSERT INTO tgj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bunua ngoogv lvkobv doorilo, no gv ngam amin jinam, ho gv jinam amin jwkrw lokv ngo bunua turlingalin pvkunv, Darwknv kitap lokv minam gaam hv rilin kunam lvgabv nyidum akin go ngerung jinv nga mimabv ngo bunugv lokv akin goka ngemu mato. ");
INSERT INTO tgj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Okv vjak ngo no gvlo aariku, okv ngo nyiamooku soogv ogu ogu vdwa mindunv vkvlvga bunu gvlo ngoogv mvngpuv bunugv haapok vdwlo kaibv doolwk modubv. ");
INSERT INTO tgj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ngo bunua noogv doin a jipvnv, okv nyiamookuv bunua kaanwng mado, ogulvgavbolo bunu nyiamooku gvngv kuma, ngoogv nyiamooku gvngv manam apiabv. ");
INSERT INTO tgj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ngo bunua nyiamooku so doonv nga naarotvka vla mima, vbvritola bunua Alvmanv loka toryagaya laka vla mindunv. ");
INSERT INTO tgj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ngo gv nyiamooku gvngv manam apiabv bunu nyiamooku gvngv kuma. ");
INSERT INTO tgj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Noogv gaam v jvjvrungnv; jvjvnv gaam lokv no bunua no gvbv jvjv dukubv mvsulaka. ");
INSERT INTO tgj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","No oguaingbv ngam nyiamooku so vngmupvdw, vkv aingbv ngo bunua nyiamooku so vngmupvnv. ");
INSERT INTO tgj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Okv ngo bunugv lvgabv ngo atuv no gvlo tolwk sudunv, ho apiabv bunuka no gvlo jvjvbv tolwk sidukubv.” ");
INSERT INTO tgj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ngo bunu mvngchik lvgabv kumma, vbvritola bunugv doin lokv nga mvngjwngnv vdwgv lvgabvka kumdunv. ");
INSERT INTO tgj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bunu mvnwngnga akin molaka vla ngo kumdunv. Abu! no ngoogvlo okv ngo no gvlo vkv aingbv bunuaka ngonu gvlo akin motoka, okv nyiamooku so gv nyi vdwv no kunyi nga vngmunv vla chindubv. ");
INSERT INTO tgj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","No okv ngo oguaingbv akinpvdw, vkv aingbv bunuaka akin modubv vla, no gv jinam yunglit nama ngo bunua jipvnv. ");
INSERT INTO tgj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ngo bunu gvlo okv no ngoogvlo, vkvlvgavbolo bunu mvnwngngv akin dukubv, nyiamookuv no ngam vngmunv vla chinam lvgabv okv no gv ngam paknam apiabv bunua no pakdu kubv.” ");
INSERT INTO tgj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Abu no bunuam ngam jito, okv ngo ogolo dooredw bunuaka ngoogvlo doomu nvpv mvngdu, noogv nga yunglit dubv jinama ngooka bunua ngoogv yunglit nama kaatam dukubv ogulvgavbolo nyiamookua pwklinyarlin madvbv no ngam pakpvnv. ");
INSERT INTO tgj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Daadwvrwnv Abu! Nyia mooku v nam chima vbvritola ngo nam chindu, okv si bunu no nga vngmunv vla chindu. ");
INSERT INTO tgj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ngo nam bunua chimu dukubv mvpvnv, okv ngo vbvdvdvbv ribwngre, vkvlvgabv no gv ngam paknamv bunu gvlo doolwk dukubv.” ");
INSERT INTO tgj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisu gv so kumro kochingbv, hv okv ninyigv lvbwlaksu vdwa vnggvla Kidron svko vnamha vngpikto. Okv hoka mooku hoka nayam ako dooto, Jisu la okv ninyigv lvbwlaksu vdwv ho aalwkto ");
INSERT INTO tgj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, kupnv angv, chinto hv ogolodw, ogulvgavbolo Jisu hoka ninyigv lvbwlaksu vdwa lvkobv kaarwk subvto. ");
INSERT INTO tgj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Vkvlvgabv Judas Nayam arwngbv vngtoku, ninyigv vngkulo Roman sipai apum go vnggvto, okv nyibu butvnv okv Parisi vdwgv vngmunam Pwknvyarnvnaam a kaayanv nyi mego; bunu ho yidu naalayila okv mvdurupum okv horkanvnv bvngnyato. ");
INSERT INTO tgj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisu ninyia ogugo ritv tvvdukudw mvnwngnga chintoku, vkvlvgabv nw bunugv dookulo korlwk yadula tvvkato, “Nonugv kaakar namv Yvvnyila?” ");
INSERT INTO tgj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bunu mirwkto, “Najaret lokv Jisunyi.” Nw minto, “Hvvdv ngoonv.” Judas, kupnv angv, hoka bunua lvkobv dakto. ");
INSERT INTO tgj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Vdwlo Jisu bunua “Ngo kuna nw” vla minto kudw, bunu koching kyambv tapkurla kvdwlo gipv nyato. ");
INSERT INTO tgj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Lvkodv Jisu bunua tvvkato, “Nonuno Yvvnyila kaakar dunv?” Bunu mirwkto, “Najaret lokv Jisunyi.” ");
INSERT INTO tgj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Ngo nonua minpvkunv ngoonv nw,” vla Jisu minto. “Vbvrikunamv, nonu nga kaakar dunvlo, so kvvbi vdw sum vngmulak.” ");
INSERT INTO tgj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nw sum minto ho lvga ninyigv minam a jvjvbv rimu dubv vla: “Abu no gv ngam jinam vdwa ngo akin goka ngemu mare.” ");
INSERT INTO tgj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pitar gvlo riokse ako dooto, seelin dabonv okv Butvyachok nvgv nyira gv, nyarung rungbik ka palujito, pakbu nyarung palu namgv aminv Malkus. ");
INSERT INTO tgj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisu Pitarnyi minto, “No gv riokse nga selin kolo selwk tokuka! No ngam ngo Abu gv hinching koobu tvngdubv jinam ha tvngma jinvgo vla mvngdunvre?” ");
INSERT INTO tgj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Vbvrikunamv Roman sipai vdwv bunugv mirianv nyigam okv Jius dakrianv vdwa lvkobv Jisunyi naatungla ninyia leetoku, ");
INSERT INTO tgj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","okv ninyia Annas gvlo aacho gvtoku. Annas Kaipas gv nywng gv abuv, Kaipas ho anying gv Butvyachok kv. ");
INSERT INTO tgj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaipas mabvdv Jius vdwa, nyi mvnwng gv lvgabv nyi akin gonv siria namv alvyanv vla minv. ");
INSERT INTO tgj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pitar okv kvvbi lvbwlaksu ako Jisunyi vngming gvto. Kvvbi lvbwlaksu angv Butvyachoknyi alvbv chimisuto, vkvlvgabv Jisunyi lvkobv kvba baaku Butvyachok gv naam lo aatoku. ");
INSERT INTO tgj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Vdwlo Pitar agum gv agi aagialo dakto kudw, kvvbi lvbwlaksu angv agumbv lingkur laku agi ho daknv nyijar anga minla Pitarnyi arwngbv aamu toku. ");
INSERT INTO tgj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Agi gv nyijar angv Pitarnyi minto, “No ka nyi angv gv lvbwlaksu gomabvre?” Pitar mirwkto, “Ma, ngo ma.” ");
INSERT INTO tgj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ho svkarto, vkvlvgabv pakbu vdwvla okv dakrianv vdwv mvri vkv vmv partola okv um dakyum nyatokula, iguminla doonya toku. Vkvlvgabv Pitar bunu gvlo aala lvkobv iguminla dakbamto. ");
INSERT INTO tgj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Butvyachoknv Jisunyi ninyigv lvbwlaksu okv ninyigv tamsarnam gv lvkwngbv tvuto. ");
INSERT INTO tgj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisu mirwkto, “Ngo alu gv lokia nyichar mvnwng gv okv kvba vdwgv tvvku kaaku lo minpvnv; ogolo nyi vdwv aakum dvdw Jius kumkunaamlo, okv Pwknvyarnvnaam lo ngoogv tamsar a sarpv kunv. Ngo vdwloka minsi minpikla mimapvnv. ");
INSERT INTO tgj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Vbvrikunamv no ngam ogulvgabv tvu dunv? Ngoogvlo tvvnv nyi vdwa tvu toka. Tvvkalaka ngo bunua ogugo minpvdw—bunu chindu ngo ogugo mimpvkudw.” ");
INSERT INTO tgj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Vdwlo Jisu sum minto kudw, hoka dakrianv akonv Jisunyi svbiakseriak mvtoku okv minto, “No Butvyachoknyi busu mabv ogubv vbv gaam mindunv!” ");
INSERT INTO tgj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisu ninyia mirwkto, “Ngo mimur go minpv bolo, hv ogu gudw so nyi vdwsum minpa toka. Vbvritola ngoogv minam hv minjwk pvbolo, no ngam ogulvgabv dvngdunv?” ");
INSERT INTO tgj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas ninyia vjaklodvbv leekor bwngtola Butvyachoknv Kaipas gvlo vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pitar hoka vjaklodvbv atuv igula doobwngto. Vkvlvgabv kvvbi gonv ninyia minto, “No ka alo nyi angv gv lvbwlaksu guma bri?” Vbvritola Pitar um miasula minto, “Ma ngo ma.” ");
INSERT INTO tgj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Butvyachok gv nyira ako Pitar gv nyarung palu namgv agungarum nyi go minto, “Nam ngo alo nyi anga Nayamlo lvkobv ridubv kaama pvnvre?” vla nw tvkato. ");
INSERT INTO tgj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pitar lvkodv mindvto, “Ma”—vla minda sopikda rokpu v koktoku. ");
INSERT INTO tgj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Arukamchi bv Jisunyi Kaipas gv naam loka gobunor gv opislo vnggv toku. Jius nyi kainv vdwv naam arwngbv aama toku, bunu vngbokunam Pumja nga dvnyu dubv vla darwk dubv mvsure vla mvngla rinyato. ");
INSERT INTO tgj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Vkvlvgabv Pilot agum bv linla bunua tvvkato, “Ogu gula nonu so nyi angv sum gungnying lwkla mindunv?” ");
INSERT INTO tgj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bunugv mirwknamv “Hv rimur mimor rima nvgolo ngonu ninyia no gvlo aagv mapvnvpv.” ");
INSERT INTO tgj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilot bunua minto, “Vbvribolo nonuno atuv ninyi naalaila nonugv Pvbv gv alambv kaala risu tvka.” Bunu mirwksito, “Ngonua nyi mvkidubv jima pvnv.” ");
INSERT INTO tgj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Svbvrinam si Jisu gv nw oguaingbv rila sitv rinvdw um gaam minchola ninyigv minpv nama rilin modubv rito. ");
INSERT INTO tgj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilot opis arwngbv aakur toku okv Jisunyi goklwkto. Nw Jisunyi tvvkato, “No Jius vdwgv dvbv ngvre?” ");
INSERT INTO tgj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisu mirwkto, “So gaam si no atubongv minsu dvnvre vmalo kvvbi gonv ngo lvga nga nam mintam pvnvre?” ");
INSERT INTO tgj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilot mirwksito, “No ngam Jiu go vla mvngdunvre? No ogugo ripv nvla? Noogv Atunyi vdwvla nyibu butvnv vdwv nam ngoogvlo laklwknv.” ");
INSERT INTO tgj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisu minto, “Ngoogv Karv ngv nyiamooku si ma; nyiamooku si ngoogv karv bv rinv guilo, ngoogv rigvnam vdwv ngam Jius kainv vdwgv laak lo laklwk momabv padar minsu pvnvpv. Ma, ngoogv karv ngv soka ma!” ");
INSERT INTO tgj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Vkvlvgabv Pilot ninyia tvvkato, “Vbvrinamv no dvbv ngvre?” Jisu mirwkto, “No nga dvbv akobv minggv nyibv. Ngo so lvgabv nyiamooku so ila bvnglin kopvnv, jvjvgv lvga nga mindubv. Yvvbunudw jvjvlo doodunv nga tvya dunv.” ");
INSERT INTO tgj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilot tvkato, “Jvjv ngv oguv?” Vbvrikunamv Pilot nyi vdwgvlo agum bv linkur toku okv bunua mintoku, “Ngo so nyi sum mia dubv gungying paanyu ma. ");
INSERT INTO tgj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Vbvritola nonugv Pvbv gv alam lokv, vngbo pumja lo patwklo tumla vvpvnam nyi akonyi anyubv ngo nonugv lvgabv tulin jibwng dunv. Nonu nga Jius vdwgv dvbv nga anyubv tulin dukubv mvngdure?” ");
INSERT INTO tgj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bunu gamtvbv gokla mirwkto, “Ma, nw nyima! Ngonu Barabasnyi mvngdunv!” (Barabas gwngrw gwnv nyi go.) ");
INSERT INTO tgj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Vbvrikunamv Pilot Jisunyi naatoku okv dvngdar pamuto. ");
INSERT INTO tgj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sipai vdwv tv doonv hakbv vkv naala biotung bv mvtola okv um ninyigv dumpolo pilwkto; vbvrikunamv bunu vji pakria go ninyia pilwk tato ");
INSERT INTO tgj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","okv nw gvlo aala minto, “Jius vdwgv dvbv ngv turbwng laka!” Okv bunu nw gvlo chaala svbiakseriak mvtoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilot lvkodv agum linkurla okv nyipam a minto, “Kaatoka, ngo ninyia mia dubv gungnying mapa nyuma vla nonua kaamu dubv ngo ninyia nonu gvlo agum lo limu gvrinvla.” ");
INSERT INTO tgj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Vkvlvgabv Jisu agumbv lintoku, tvv biotung hala vji pakria nga gvtokula. Pilot bunua mintoku, “Kaatoka! nyi angv so si kunv!” ");
INSERT INTO tgj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Vdwlo nyibu butvnv vdwv okv kumkunaam a kaayanv vdwv ninyia kaatokudw, bunu goktoku, “Daapo lo ninyia takkito! Daapo lo ninyi takkito!” Pilot bunua minto, “Vbvrikunamv, nonu ninyi naala okv Daapo lo ninyi takki toka. Ngo ninyia mia dubv gungnying mapa yama.” ");
INSERT INTO tgj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nyipam v minkurla mirwkto, “Ngonu pvbv go doosudo hv mindu ninyi kua jinvku, ogulvgavbolo hv atuv Pwknvyarnv gv Kuunyilo gubv minsudo.” ");
INSERT INTO tgj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Vdwlo Pilot sum tvvtokudw nw abuyayabv busuto. ");
INSERT INTO tgj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nw opis arwngbv aakur toku okv Jisunyi tvvkato, “No ogolokv aapvnv?” Vbvritola Jisu mirwk matoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilot ninyia minto, “No ngam raarwk suma dubvre? Mvnggap laka ngoogvlo nam anyubv tulin dubv okv daapo loka takki modubv rigvnvnv doodunv.” ");
INSERT INTO tgj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisu mirwkto, “No ngam vbv mvngchik rilanvnv doodunv ogulvgavbolo Pwknvyarnv nam um jipvnv. Vkvlvga yvvdw ngam no gvlo laklwk pvdw hv achialvbv rimur gungnying gvyachoknv.” ");
INSERT INTO tgj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Vdwlo Pilot sum tvvtokudw, nw Jisunyi anyubv tulin dukubv lamtv makar kwto. Vbvritola nyipam hv gokla mindvto, “No ninyia anyubv tulin kubolo, hv manv no Dvbvyachok gv ajin kumanyi! yvvdw dvbv gubv minsu dunv hv Dvbvyachoknyi rinyingriru dunv!” ");
INSERT INTO tgj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Vdwlo Pilot so gaam sum tvvpa tokudw, nw Jisunyi agumlo linggv toku okv jwngkadakaku “Dooging Lvngnv” vnamlo doolwk toku (Um Hebru gaam bv “Gabbatha” vla minto.) ");
INSERT INTO tgj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Vbvrikunamv ho alu hv Vngbokunam pumja nga loochoyanv alu lopo bv ritoku. Pilot nyi vdwa mintoku, “Siinv nonugv dvbv ngv!” ");
INSERT INTO tgj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bunu gokla mindvto, “Ninyia mvkito! Ninyia mvkito! Daapo lo ninyia takkito!” Pilot bunua tvvkato, “Nonu ngam nonugv dvbv nga daapo lo takki tvkv vla mvngdu ai?” Nyibu butvnv vdwv mirwkto, “Dvbvyachok mvngchik ngonugv dvbv ngv!” ");
INSERT INTO tgj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Vbvrikunamv Pilot Jisunyi daapo lo takki modukubv bunu gvlo laklwk toku. Vkvlvga bunu Jisunyi vnggv toku. ");
INSERT INTO tgj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nw agumbv vnglintoku ninyigv daapo nga bakto kula “Dumku gv mooku” vnam moodw putung (Um Hebru gaam bv “Golgota” vla minam) golo aalwk toku. ");
INSERT INTO tgj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hoka bunu ninyia daapolo takki toku; okv kvvbinyi anyi goka Jisu gv taggotaksak bv takkito. ");
INSERT INTO tgj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilot minpanam gaamgo lvktola um daapolo takgap lwkmuto, ninyigv lwknammv, “Najaret lokv Jisu Jius vdwgv Dvbv ngv,” vla lvkto. ");
INSERT INTO tgj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nyi mvnwngngv um purinyato, ogulvgavbolo Jisunyi daapo lo takkiku hv pamtv lokv adu mato. Minpanam gaam lvkpvnam hv Hebru, Letin, Grik gaam bv lvktoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nyibu butv vdwv Pilotnyi minto, “Jius vdwgv Dvbv ngv vla lvkma bvka vmabvdv, ‘So nyi angv si ngo Jius vdwgv Dvbv ngv vla minsupvnv.’” ");
INSERT INTO tgj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilot mirwkto, “Ngo ogugo lvkpv kudw vbv lvknam bv doomure.” ");
INSERT INTO tgj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sipai vdwgv Jisunyi daapo lo takkiro kochingbv, bunu ninyigv vji ha naatoku okv um bunu takpi gobv putakpuyak mvtola sipai akin-akinnv asak gobv orpin-oryin sitoku, bunu arwnglo vji hammabv chumnam haka naatoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sipai vdwv akonv akonyi mimisuto, “Sum putak mabvju; klvi ngonu vlwng likwsulaju yvvdw sum paaji bongv.” Svbvrinam si Darwknv kitaplo minam a jvjvbv rilin modubv ritoku: “Bunu ngoogv vji a orpin oryin sunyato, okv ngoogv vji achar lvgabv limin likwsunyato.” Okv sum vbvchingching sipai vdwv ritoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisu gv daapo lo nvchibv daknv vdwv ninyigv anv, ninyigv anv gv bormv, Klopas gv nyimv Meri, okv Meri Magdalene. ");
INSERT INTO tgj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisu ninyigv anvnyi okv ninyigv paknam lvbwlaksu gunyi hoka dakdubv kaagapto; vkvlvgabv nw ninyigv anvnyi minto, “Hv noogv kuunyilo ngv.” ");
INSERT INTO tgj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Vbvrikunamv nw lvbwlaksu anga minto, “Hv no gv anv ngv.” Ho dw lokv lvbwlaksu angv ninyia vnggv lakula ninyigv naam lo doomu toku. ");
INSERT INTO tgj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisu chintoku vjak ogumvnwng nga rinya pvku vla, okv Darwknv kitap nga jvjv monam lvgabv nw minto, “Ngo tvngnwng pv.” ");
INSERT INTO tgj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hoka upum gulo, opo kungsuk nvkv yarbing dubv dooto; vkvlvga svngchak ka opolo nwkbok tvla, um tabiu karda daagolo mvlwk tvla okv um Jisu gv naptwng gaam lo nwkjito. ");
INSERT INTO tgj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisu opo nga tvngto kula mintoku, “Si rinya ngvku!” Vbvrikunamv nw dumpo ngv bawng tuku okv sitoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Vbvrikunamv Jius nyi kainv vdwv daapo lo takkinam nyi vdwa lvpa nga svtar svbar momu labv vla Pilotnyi kooto, okv svma vdwa daapo loka naalu dukubv vla. Bunu vbv kooto, ogulvgavbolo ho aluv Jius vdwgv doonu alua loochoyanv gubv rito, okv bunu svma vdwa jius Doonualu lobv doolin modubv mvngmato, ogulvgavbolo aarinv Jius Doonualuv achialvbv darwk nvgo. ");
INSERT INTO tgj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Vkvlvgabv sipai vdwv vngla Jisunyi lvkobv daapo lo takkinam vdwa akonyi mvsolaila akonyi lvpa vdwa svtar svbar mvtoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Vbvritola vdwlo bunu Jisu gvlo aatokudw, bunu ninyia sidubv kaatoku, vkvlvga bunu ninyigv lvpa nga svtar svbar mvmato. ");
INSERT INTO tgj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sipai akonv nvvbung lokv Jisu gv hubyam lo nwklwkto okv vjakgobv oyi bvla isi bv toolinto. ");
INSERT INTO tgj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Vbvridubv kaanv angv ho lvkwngbv mintoku, minam gv lvga ngv nonuaka mvngjwng modukubv vla, ninyigv minammv jvjv ngv, okv hv chindu nw jvjv nga mindu vla. ");
INSERT INTO tgj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Svbvrinam si Darwknv kitap nga jvjv modubv vla ritoku: “Ninyigv loobung akoka dartung ma.” ");
INSERT INTO tgj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Okv Darwknv Kitap kvvbi loka mindo, “Yvvnyi bunu nwkpv kudw nyi vdwv ninyia kaagap reku.” ");
INSERT INTO tgj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","So kochingbv, Josep, Arimatia banggu lokv nw Jisu gv svma nga naaku nvpv vla Pilotnyi kooto. (Josep risila Jisunyi reming gvnvgubv rito, ogulvgavblo nw Jius nyi kainv vdwa busuto.) Pilot ninyia svma nga naalado vla mintoku, vkvlvgabv Josep vngla okv um naaro jitoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemas, yvvdw kvvlo Jisunyi ayubv kaarwk sudubv aanv angv, hv mairrh okv aloe mvyomvchila amok nampunv vkv keji chaamgo gvla Josepnyi lvkobv vngming gvto. ");
INSERT INTO tgj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nyi anyiv Jisu gv svma nga naatoku, okv vji koopa lo amok nampu nvnga lvkobv kvlap toku, Jius vdwv svma riiji nama oguaingbv mvla riidudw ho rilambv riitoku. ");
INSERT INTO tgj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisunyi ogolo mvki pvkudw hoka mooku hoka nayam ako dooto, okv hoka ho svma magoka lwkw manam anwnv nyibung bunggo dooto. ");
INSERT INTO tgj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ho alu hv Jius doonu alua loochoyanv alu bv rito, okv ogulvgavbolo nyibung ngvka nvchilo doopv, bunu Jisu gv svma nga hoka dvpv toku. ");
INSERT INTO tgj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Vjwngalu gv arukamchi bv, kanv ngv doodv dubv, Meri Magdalene nyibung lo vngto okv aagiagv vlwng nga naala naa rodubv kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nw Saimon Pitar okv Jisu gv paknam kvvbi lvbwlaksu vdwgvlo riolwk toku, okv bunua minpa jitoku, “Bunu Ahtunyi nyibung loka naaropvku vla, okv ngonu chima ogolo bunu ninyia vvpvpvkudw!” ");
INSERT INTO tgj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Vbvrikunamv Pitar la okv kvvbi lvbwlaksu angv nyibung bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bunyi anyiv rioba sito, vbvritola kvvbi lvbwlaksu angv Pitarnyi riogo yala nyibung lo riochi choyato. ");
INSERT INTO tgj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hv gubwngto okv kaanammv vji koopa kvlap nvnv nga kaapato, vbvritola hv arwngbv aamato. ");
INSERT INTO tgj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ninyigv adar lo Saimon Pitar aatoku, okv nw arwngbv jokdajokrayato. Nw kvlap nvnv vji koopa nga ho doodubv kaatoku ");
INSERT INTO tgj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","okv Jisu gv dumpo nga heebum nvnv vjiv kvlap nvnv vji a lvkobv doomato, vbvritola achikaik tvvla doosuto. ");
INSERT INTO tgj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Vbvrikunamv kvvbi lvbwlaksu nyibunglo aachi choyanv angvka arwngbv aatoku; hv kaatokula okv mvngjwng toku. ");
INSERT INTO tgj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bunu vjaklodvbv Darwknv kitaplo hv sinam lokv turrap rungreku vnama chima bwngto. ");
INSERT INTO tgj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Vbvrikunamv lvbwlaksu vdwv naambv vngkur nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meri nyibung gv agumlo kapla daktoku. Nw vbv kapdung rilo, nw gubwngla okv nyibung arung nga kaabungto ");
INSERT INTO tgj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","okv nyido gindung anyigo vji yapung tojinv kotola Jisunyi vvpvku hoka doodubv kaatoku, akonv dumpo dooku kyambv okv akonv lvpa dooku kyambv, ");
INSERT INTO tgj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","“Nyimv, ogubv kapdunv?” Vla bunu ninyia tvvkato. Nw mirwksito, “Bunu ngoogv Ahtunyi naaropvku, okv ngo chima bunu ninyia ogolo vvpvpvkudw!” ");
INSERT INTO tgj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Vbvrikunamv nw dakkurdakjur namv Jisunyi hoka dakdubv kaapa toku; vbvritola nw um Jisu kv vla chimato. ");
INSERT INTO tgj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Nyimv, no ogubv kapdunv?” Jisu ninyia tvvkato. “No Yvvnyila kaakar dunv?” Nw um nayam kaaya nvgo vla ninyia mvngto, vkvlvgabv nw ninyia mintoku, “No ninyia naaropvnvbolo, tamsarnv, nga minpalabv no ninyia ogolo vvpv pvnvla, ngo vngla ninyia naaku nvpvla.” ");
INSERT INTO tgj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisu ninyia mintoku, “Meri!” Nw dakrwk toku ninyigv takbv okv Hebru gaam bv minto, “Rabboni!” (So minam si “Tamsarnv.”) ");
INSERT INTO tgj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisu ninyia minto, “Ngam mvsit mabvka, ogulvgavbolo ngo vjaklodvbv Abu gvlo chaakorla chaalin madv. Vbvritola vngnyila ngoogv boru vdwa minpa jiteka ngo ngo Abu okv bunugv Abu bv rikunv gvlo okv ngoogv Pwknvyarnv okv bunugv Pwknvyarnvbv rikunv gvlo vngkur jikunv.” ");
INSERT INTO tgj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Vkvlvgabv Meri Magdalene vngtoku okv ninyigv lvbwlaksu vdwa minpa jitoku nw Ahtunyi kaapv nvkv vla okv ninyigv bunua minam vdwa hv mintam jitoku. ");
INSERT INTO tgj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Vjwngalu gv arium riumdwng bv, okv lvbwlaksu vdwv bunu adarai lo agi a koktum sutola lvkobv dookum nyato, ogulvgavbolo bunu Jius nyi kainv vdwa busu nyato. Vbvrikunamv Jisu aatoku okv bunu gvlo daktoku. Nw minto, “Sarsopoyo ngv nonu gvlo lvkobv doolwk laka.” ");
INSERT INTO tgj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Vbv miro kochingbv, nw ninyigv laak okv hubyam a bunua kaatam toku. Lwbwlaksu vdwv Jisunyi kaatokula achialvbv mvngpu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisu bunua lvkodv mindvto, “Sarsopoyo ngv nonu gvlo lvkobv doolwk laka. Abu gv ngam vngmunam apiabv ngo nonua vngmu dunv,” ");
INSERT INTO tgj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Vbvrikunamv nw bunu gvlo saklwk toku okv minto, “Darwknv Dow ha naarwk silaka. ");
INSERT INTO tgj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nonu nyi vdwgv rimur a mvngnga jibolo, bunuaka mvngnga jireku; nonu bunua mvngnga mabolo, bunuaka mvngnga mare.” ");
INSERT INTO tgj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Lwbwlaksu vring gola anyi lokv akin gonv, Tomas (Bvngpiam sinam vla minam) Jisu gv bunu gvlo aarilo hoka bunua lvkobv doomato. ");
INSERT INTO tgj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Vkvlvgabv kvvbi lvbwlaksu vdwv, “Ngonu Ahtunyi kaapv kunv!” vla ninyia mintamto. Tomas bunua minto, “Ngo vdwlo ninyigv laak lokv kili taknam ungv nga kaala ngoogv lakching ngv chilwk maredw, ngo mvngjwng mare.” ");
INSERT INTO tgj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Alu lokkanw kochingbv lvbwlaksu vdwv lvkodv agi a koktum tvvla doobam nyato, okv Tomas bunua lvkobv doobam toku. Agi a mvtum toku, vbvritola Jisu aato okv bunua lvkobv dakto okv minto, “Sarsopoyo namv nonua lvkobv doolwk laka.” ");
INSERT INTO tgj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Vbvrikunamv nw Tomasnyi minto, “Ngoogv laakka kaato kuka, okv noogv lakching ngv chilwk tvkuka; vbvrikunamv noogv lak v ilinla okv ngoogv hubyam so mamkato. No gv mvngjwng mabv rinam a kayu tokula hoka mvngjwng tokuka!” ");
INSERT INTO tgj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ninyi mirwk toku, “Ngoogv Ahtu okv ngoogv Pwknvyarnv!” ");
INSERT INTO tgj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisu ninyia minto, “No ngam kaakunam lvgabv mvngjwng duku ai? Vdwgo mvngpu vku yvvdw ngam kaamabv mvngjwng dunv!” ");
INSERT INTO tgj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ninyigv lvbwlaksu vdwgv kaagia lo Jisu kvvbi lamrwpanam vkv achialvgo kaatamto um so kitap so lvkgap pvma. ");
INSERT INTO tgj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Vbvritola so lvkgap pvvnam vdw so gv lvkwng ngv nonua Jisunyi Kristo, Pwknvyarnv gv Kuunyilo ngv vla mvngjwng modukubv, okv nonugv vbv ninyi mvngjwng kolokv nonu turbwng nama paadu kubv. ");
INSERT INTO tgj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","So kochingbv Jisu lvkodv Tiberias Svpar lo ninyigv lvbwlaksu vdwa kaarwksuto. Si vbvchingbv ritoku. ");
INSERT INTO tgj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pitar, Tomas (Bvngpiam sinam vla minam), Natanael (Hv Galili gv Kana lokv), Jibedi gv kuunyilo vdwv, okv Jisu gv kvvbi lvbwlaksu anyiv la mvnwngngv lvkobv dookumtoku. ");
INSERT INTO tgj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pitar kvvbi vdwa minto, “Ngo ngui naabv vngjinnv.” Bunu ninyia minto, “Ngonuka nam vngming gvvre.” Vkvlvgabv bunu svpw akolo vnglin nyatoku, vbvritola bunu ho ayu mvnwngngv hoka oguka harpa kumato. ");
INSERT INTO tgj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Doonyi hv nyilin sopit pvngnga, Jisu isi biyarlo daktoku, vbvritola lvbwlaksu vdwv ninyia Jisu vla chimato. ");
INSERT INTO tgj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Vbvrikunamv hv bunua tvvkato, “Yaapa vdwa, nonu oguka harpa malare?” Bunu mirwkto, “Aaro, oguka naama.” ");
INSERT INTO tgj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nw bunua minto, “Nonugv vsap a svpw hokv lakbik takbv orlwk kwto, okv nonu mego naare.” Vkvlvgabv bunu bunugv vsap a orlwk toku okv um pukorla pulwk nyuma toku, ogulvgavbolo achialvbv ngui naakunam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jisu gv paknam lvbwlaksu angv Pitarnyi minto, “Si Ahtu laka!” Vdwlo Pitar Ahtu vla tvvpa tvkudw, hv ninyigv agum vji a koorum sutoku (hv ninyigv vji a pilinla vvpv kunam um) okv isi bv poklwk toku. ");
INSERT INTO tgj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kvvbi lvbwlaksu vdwv svpw lokv agumbv dulunlinla vsaplo ngui yarpok kunam a puming gvto. Bunu agum gv kvdw a adu jeyo kumato, mitar lwngkin gubv adu to. ");
INSERT INTO tgj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Vdwlo bunu agum kvdwlo korlin tokudw, bunu vtwng vkvla ngui go vmv mvri lo baalwk tvla doodubv kaapato. ");
INSERT INTO tgj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Vbvrikunamv Jisu bunua minto, “Nonugv vjakpi ngui naanam lokv mego bvnglwkto.” ");
INSERT INTO tgj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pitar svpw lo vngto okv ngui nvvtvnv vsaplo yarpok kunvnga agumbv rvvlinto, ngui ngv lvngola chamngu gula nvom gubv mvnwngngv rito; hoka achialv kujeka, vjaklodvbv vsap hv bokpwk mato. ");
INSERT INTO tgj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisu bunua minto, “Aato okv dvto.” Lwbwlaksu vdwv yvv akonvka mvngpakla ninyia “No yvvla?” Vla tvvka nvgoka kaama, ogulvgavbolo bunu si Ahtu kv vla chintoku. ");
INSERT INTO tgj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Vkvlvgabv Jisu vngla, vtwng nga naato okv bunua jitoku; okv ngui haka vbvdvdvbv rito. ");
INSERT INTO tgj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisu sinam lokv turrapro kochingbv ninyigv lvbwlaksu vdwa kaarwk sunamv si lvom nvnvku. ");
INSERT INTO tgj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bunu dvro kochingbv, Jisu Saimon Pitarnyi minto, “Saimon, Jon gv kuunyilo, no ngam so kvvbi vdwgv ngam paknama kaiyabv pakya dunvre?” Hv mirwkto, “Vkv, Ahtu, nam ngoogv paknam ma no chindu.” Jisu ninyia minto, “Ngoogv svlarkuu vdwa alvbv kaaya laka.” ");
INSERT INTO tgj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisu lvnyi nvbv ninyia minto, “Saimon Jon gv kuunyilo, no ngam pakdunvre?” Hv mirwkto, “Vkv, Ahtu, nam ngoogv paknam a no chindu.” Jisu ninyia minto, “Ngoogv svlar vdwa alvbv kaaya laka.” ");
INSERT INTO tgj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisu lvom nvbv minto, “Saimon Jon gv kuunyilo, no nga pakdunvre?” Pitar mvngru toku ogulvgavbolo Jisu ninyia lvom go “No nga pakdunvre?” Vla tvvka kunam lvkwngbv vkvlvgabv hv Jisunyi minto, “Ahtu, no ogumvnwngnga chindunv; no chindu nam ngoogv paknama!” Jisu ninyia minto, “Ngoogv svlar vdwa alvbv kaaya laka. ");
INSERT INTO tgj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ngo nam jvjv nga minjidunv: nonugv yaapa rilo nonu ogolo vngso mvngpvdw no mvgemvrap sula vngdung vngbab karminto; vbvritola noogv nyikam rilo, no lak v laklin reku okv kvvbi akonv nam leeriku okv noogv vngso mvngma kolo vnggv reku.” ");
INSERT INTO tgj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisu gv ninyia svbv minam si Pitar silaku Pwknvyarnvnyi kaibv yunglit mosenga mintoku.) Vbvrikunamv Jisu ninyia “Nga vngming gvlaak!” vla mintoku. ");
INSERT INTO tgj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pitar kaakor kaarwk namv Jisu gv paknam kvvbi lvbwlaksu anga adarlo dakdubv kaapato—hv Jisu gv dvnam dvgv rilo ninyigv nvchilo doolwk dvla “Ahtu nam yvvla koa tvdunv?” vla tvvkanv angv. ");
INSERT INTO tgj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Vdwlo Pitar ninyia kaapa tokudw, nw Jisunyi tvvkato, “Ahtu, ogubvla so nyi sum?” ");
INSERT INTO tgj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisu ninyia mirwkto, “Ngo ninyia ngoogv aakurma dvdvlo turbwng modubv mvngbolo, hv no gvbv ogubv ridula? Ngam vngming gvlaak!” ");
INSERT INTO tgj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Vkvlvgabv so lvbwlaksu angv simare vla yunying ngv jarkar toku Jisu gv rigvnam vdwgvlo. Vbvritola nw simare vla Jisu mimato; nw minto, “Ngo ninyia ngoogv aakurma dvdvlo turbwng modubv mvngbolo, hv no gvbv ogubv ridula?” ");
INSERT INTO tgj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nw kuna lvbwlaksu angv yvvdw so vdw sum mindunv, okv sum lvkgap pvnv angv; okv ngonu chindu nw ogugo minpvkudw hv jvjv ngv. ");
INSERT INTO tgj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Vjak, Jisu gv kvvbi aba rikunam dvdv ngv hoka achialv toku. Um akin akinbv lvknv guilo ngo mvngkanamv nyiamooku mvnwng si um lvkpv nama dvbwng nyulamare.");
INSERT INTO tgj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1"," Pakmisinam Tiopilas: Ngoogv lvktulwkke lwknam kitap lo ngo Jisu gv ogumvnwng rinam okv minam ninyigv atukalu ho rinama lvkpvnv ");
INSERT INTO tgj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ninyi nyidomooku chaatv madvbv alulo. Ninyigv chaama dvbv, Hv kaatamritamla Darwknv Dow jwkrw lokv ninyigv Apostol gobv darlin kunam nyi vdwa. ");
INSERT INTO tgj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Vkvgv siro kunam kochingso alu champi go ogolo lamtv lo hv nyi vdwa kaarwksuku nama ho hv turpvkunv vv nyi vdwa kaatam kunam. Bunu ninyia kaatoku, okv hv bunua lvkobv Pwknvyarnv gv Karv gv lvgabv japbam toku. ");
INSERT INTO tgj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Okv vdwlo bunu lvkobv aato kudw, hv bunua so orto sum jitoku: “Jerusalem am vngyu mabv kv, vbvritola jwkrw lvgabv doyato ngoogv nonuam minpv nama, ngo Abu gv jwkrw milv nama. ");
INSERT INTO tgj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon isi lokv baptisma jito, vbvritola so lonyiloum so nonua Darwknv Dow lokv baptisma jire.” ");
INSERT INTO tgj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Vdwlo Apostol vdwv Jisunyi kaarwk sikubvdw, bunu vdwv ninyia tvvkato, “Ahtu, no so vjakdadw suka Israel am Karv nga jikur dooku bvre?” ");
INSERT INTO tgj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jisu bunua minto, “Ridwvngdw ngv ngoogv Abu gv atubogv tujupkunamv, okv so si nonu lvgabv chinsvma vdwlo vv bunu ririkudw. ");
INSERT INTO tgj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Vbvritola vdwlo Darwknv Dowv nonu gvlo aaku bolo, no jwkrw doriku, okv no ngo gvbvku minjiyanv gobv ririku Jerusalem lo Judia mvnwnglo okv Samaria okv sichingmooku gv dotvr mvnwnglo mingo jinv gobv ririku.” ");
INSERT INTO tgj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Miro koching so ninyi nyidomooku naacha kunama ho vdwv kaaria toku, okv ho vdwgv kaanyung aku ninyia hapumv kaklum toku. ");
INSERT INTO tgj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bunu vdwv vjaklodvbv nyido tlo bv ninyigv chaanama roodungla kaaria kunamv, ogolokv nyi anyigo vji jipung kootola dvminmabv bunu vdwgvlo aala dakbamto ");
INSERT INTO tgj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","okv minto, “Galili nyi vdwv, ogulvgabv nonuno daktola nyidotolo kaadung dunv? Si Jisu si, nonugv lokv nyidomooku bv naacha kunama, nonu ninyia nyidomooku bv chaadubv kaaming gvnam aingbv nw vbvching lvkodv aakur reku.” ");
INSERT INTO tgj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Okv Apostol vdwv Olib gv Moodw lokv Jerusalem lo vngkur toku, hv pamtv lokv lvtw gobv aduto. ");
INSERT INTO tgj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bunu banggu lo aachi toku okv ho vdwgv karchung dookulo chaachi toku: Pitar, Jon, Jems okv Andriu, Pilip okv Tomas, Bartolomiu okv Metiu, Alpius gv kuunyilo Jems, Saimon ringria kunv okv Jems gv kuunyilo Judas. ");
INSERT INTO tgj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bunu dookum nyato kumbwng nyala, anvnyimv vdwv okv Jisu gv anv Meri okv ninyigv boru vdwv lvkobv. ");
INSERT INTO tgj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Alu lonyiloum koching ho mvngjwngnv vdwv doopamgo pamto, hokaku lwnggola chamnyi gubv, okv Pitarnyi japdubv daktoku. ");
INSERT INTO tgj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ngoogv ajin vdwv,” hv minto, “Darwknv Dow lokv minamv darwknv kitapv jvjvbv aaduku, Dabid gv lokv, oogv Jisunyi booku nama chigudabianv Judas gv lvkwng lo mincho moodubv mvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas ka ngonugv apam lo ribamv, hv ngonugv kudungkua aba lo ribam kunam akobv darlin kunamv.” ( ");
INSERT INTO tgj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas gv alvmanv rijo morko paanama rongo rvvnv toku, ho rongo hoka ninyi atubongv hoksar sitoku; ninyi godit goitla okv ninyigv tangiv pokdik lintoku. ");
INSERT INTO tgj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem lo nyi doonv vdwv so sum tvvpa kunam, okv ho vdwgv atubogv gaam bv ho rongo nga Akeldama vla vdwv minkunam, Akeldama, minam si “Gwngrw Talwng Rongo.”) ");
INSERT INTO tgj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Holvgabv soogv Miri kitap si vbv lvkpv pvku, ‘Oogv naam lo nyi akoka dookuma; Holvgabv vkvgv naamv arochoko duku.’ So si ka lvkpv duku, ‘Vbvmabvdv akonvka vkvgv risvdosv nga naariku.’ ");
INSERT INTO tgj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Holvgabv, Ahtu Jisu gv turkur kunama, ho kaariatarianv akobv ngonu gvlo ribam rungdu kubv, hv nyi angv kvvlo lokv Ahtu Jisu ngonugv lvkobv vnggo karla Jon ninyigv baptisma gv doina japgo kari lokv Jisunyi nyidomooku lo ngonugv pingko lokv laachama dvdv lobv riming gvnv gobv rirungpv lage.” ");
INSERT INTO tgj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Vbvrikunamv, bunu vdwv nyi anyi gonyi mimpv toku: Josep, um Barsabbas vtoku (Justus bvka mintoku) okv Matias. ");
INSERT INTO tgj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Vbvrikunamv bunu kumtoku, “Ahtu, no mvnwng gv mvngnama chindu, noogv gaklin pvvnam nyidum anyi sum ngonua kaatam bvka ");
INSERT INTO tgj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Apostol aingbv ridubv Judas gv vngro kunam lokv, nyi ogolokvdw ho vngkunam.” ");
INSERT INTO tgj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Vbvrikunamv bunu nyi anyia amin chingkw sito okv ako chincha namv Matiasnyi Apostol akobv chilin toku vringgola akinlo aapwng toku. ");
INSERT INTO tgj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Vdwlo Pintikost aluv aakunamv, mvngjwngnv vdwv lvkobv dooku akin lo dookum toku. ");
INSERT INTO tgj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dvminmabv nyido gvngv doogumdoori ngv gumnam jvbv kai alvbv svdu duto, okv bunu vdwgv dooku naam lo dulwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Vbvrikunamv bunu ogu vmv mvriak taakar nam aingbv kaapatoku okv hoka akinakin lo mvsit karto. ");
INSERT INTO tgj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Darwknv Dowv lvkobv ho mvnwng nga aaku namv Dowv kvvbi gaam aingbv japdu kubv bunua mvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jerusalem lo Jius vdwv dookunamv, nyiamooku mvnwng lokv diringmooku mvnwng dormo nyi vdwv aakum toku. ");
INSERT INTO tgj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Vdwlo bunu so svdua tvvpapvdw, nyi nyitwnggo aakum toku. Bunu mvnwng ngv yaa mvngtoku, ogulvgavbolo akinakin bv mvnwng ngv mvngjwngnv vdwa bunu atugv gaambv japdubv tvvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mvngrimvngma okv kaasartabo mvngdukla bunu gokto, “So nyi japnv vdwv si Galili nyi jvbv! ");
INSERT INTO tgj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Si oguaingbv, vbvrikunamv, ngonu mvnwng ngv ho bunua ngonugv atugv gaam nga japdubv tvvdunv? ");
INSERT INTO tgj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ngonu Partia lokv, Media, okv Elam; Mesopotamia lokv, Judia, okv kapadosia; Pontus okv Asia lokv gvngv, ");
INSERT INTO tgj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigia lokv, okv Pampilia lokv, Ijipt okv Sairen nvchi Libya mooku lokv. Ngonu kvvgonv Rom lokv gvngv, ");
INSERT INTO tgj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jius okv Jentail judaism lo aakunv nyitwng anyiv, okv ngonu kvvgonv Kret okv Arabia lokv gvngv vjvka ngonu mvnwng ngv bunua ngoogv gaambv japdubv tvvdu Pwknvyarnv gv ogu kairungnv go rinam lvgabv!” ");
INSERT INTO tgj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Lamnam okv mvngbwk mabv, bunu akonv akonyi tvvka minsuto, “Si ogu gubvri?” ");
INSERT INTO tgj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Vbvritola kvvgonv mvngjwngnv vdwa giokw nyala, minto, “So nyi vdwv tvngkium nyapv!” ");
INSERT INTO tgj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Vbvrikunamv Pitar vringgola akin Apostol am lvkobv daktoku okv gamtv alvbv milinto bunua: “Okv yvvdw Jerusalem lo doonv vdwv nonu mvnwng ngv Jius aingbv ritoku, nga tvvriato okv klai ngo nonua mintodv si oguvdw. ");
INSERT INTO tgj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","So nyi vdwv tvngmanv, oguaingbv no mvngdudw; si arugv kia baje mvngchikdu. ");
INSERT INTO tgj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Vmabvya, so si nyijwk Joel gv ogugo mingkunamv vvkv: ");
INSERT INTO tgj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Pwknvyarnv minto, ogu gunyi ngo rirungre so sung ataranya alu lo: Ngoogv Dowa ngo mvnwng gv aolo pwlwk jire. Ngoogv doina, noogv kuunyilo okv nyimv vdwv minkar riku; noogv nyipayapa vdwv nyikrw kaare, okv noogv nyikam vdwv yuma maare. ");
INSERT INTO tgj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Vvka tikmabv, ngoogv nyira anyi, pakbu okv paknv loka, Ngo aamure ngoogv Dow ho alunyi, okv bunu minjire ngoogv doina. ");
INSERT INTO tgj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ngo nyido aolo lamrwpadubv kaatamre okv sichingmooku lvkwnglo kaasartabo more. Hoka ka oyi, vmv, okv mvkwv doore; ");
INSERT INTO tgj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Donyiv nyikumare, okv Pooluv oyi jvbv yalwngre, Ahtu gv aamadvbv kairungnv okv yunglitnam alu lo. ");
INSERT INTO tgj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Okv vbvrikunamv, yvvdw Ahtunyi ringkudubv gokdunv um ringreku.’ ");
INSERT INTO tgj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Tvvgapto soogv gamchar am, Israel ribam vdwv! Jisu Najaret gv nyi go vv darwknv tulwkkunama kaatamto nonua lamrwpadubv okv kaasartabo bv Pwknvyarnv ninyigv lokv kaatamto. Nonu atubongv chinsudo sum, si nonugv pingkolo ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ninyigv atubongv mvngdung lokv Pwknvyarnv mvngpv kunam ho Jisunyi bunu gvlo laklwk jitoku; okv nonuno rimurnv nyi vdwa ninyia daapo lo takki motoku. ");
INSERT INTO tgj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Vbvritola Pwknvyarnv ninyia sinam lokv turkur motoku, ninyia jwkrw jitoku, ogulvgabv ninyia hv rila mato sinamv patwk doonv nyi jvbv naatung nyomare. ");
INSERT INTO tgj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dabid ninyigv lvkwnglo minto, ‘Hoogv dw mvnwng lo ngo Ahtunyi kaato, hv ngoogv nvchilo dooto okv ngo adwkakunam kaamare. ");
INSERT INTO tgj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Okv vkvlvgabv ngo gvlo himpuv puulvk duku, okv ngoogv gamcharv achialvbv alv duku. Okv ngo, sidajvka ngo ka, mvngjwng ngv doming gvvriku, ");
INSERT INTO tgj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","vkvlvgabv no nga achialvbv siku sichingmooku lo tulatua mare; noogv mvngjwngnv nyira nga nyibunglo yaalwk momare. ");
INSERT INTO tgj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","No nga kaatamto singjiku lamtv nga, okv noogv doonam lokv nga lvkobv himpu moto.’ ");
INSERT INTO tgj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ngoogv ajin vdwa, Ngo nonua minda kalabv mindunv ngoogv yungnam abuapa Dvbv Dabid gv lvkwngbv. Hv sitoku okv svma nga ritoku, okv ninyigv nyibung ngv silu gudvbv ngonua lvkobv dooming gvdo. ");
INSERT INTO tgj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Hv nyijwk gubv ritoku, okv Pwknvyarnv ogugo ninyia milv pvdw um hv chindu: Pwknvyarnv milv toku Dvbv Dabid aingnvgo, ninyigv husi lokv akonyi Dvbv bv mvre. ");
INSERT INTO tgj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dabid kaapato Pwknvyarnv ogugo vngtvritv dunvdw aarinvlo, okv hv minto Kristo gv turkur kunam lvkwng lo, ‘Hv siku sichingmooku soka tulatua kumare; ninyigv ayak vv nyibung boloka yaaku mare.’ ");
INSERT INTO tgj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pwknvyarnv Jisunyi sikunam lokv tukur motoku, okv sung ngonu mvnwng ngv jvjv nga kaarianvngv. ");
INSERT INTO tgj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hv ka turkur kunv ngv Pwknvyarnv gv lakbik peelvbv doonv, ninyigv Abu lokv okv Darwknv Dowa ninyi naarwk sitoku, ninyigv milvnam lokv. No ogu gunyi vjv kaadunv okv tvvdunv si ninyigv jinamgo ho hv ngonua Darwknv Dowa jilwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Hv Dabid mato yvvdw nyidomooku tolobv chaakunv; vbvritola Dabid atuv mintoku, ‘Ahtu ngoogv Ahtunyi minto: Soka dooto ngoogv lakbik kiambv ");
INSERT INTO tgj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ngo noogv nyimak am lvchu arwnglo vvpvma dvdvlo.’ ");
INSERT INTO tgj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Israel gv nyi mvnwng ngv, vbvritola hoka nonu chirungto si Jisu, yvvnyi nonu daapolo takipvdw, ho angv Pwknvyarnv gv mvkunam Ahtu okv Messiah!” ");
INSERT INTO tgj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Vdwlo nyi vdwv sum tvvpa pukudw, bunu mvnwng ngv achialvbv adwkakuto okv Pitarnyi minto okv kvvbi Apostol vdwaka, “Achiboru vdwv ngonu ogubv rire?” ");
INSERT INTO tgj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pitar bunua minto, “Nonuno akinakinv rimur lokv lirung tokuka okv Jisu Kristo gv amin bv baptisma laato kuka, vbvribolo nonugv rimur am mvngnga jiriku; okv nonuno Pwknvyarnv gv jinam nga naarwk siriku, Darwknv Dowa. ");
INSERT INTO tgj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pwknvyarnv gv milvpvvnamv nonua okv nonugv umvuu vdwa, okv mvnwng nga yvvbunu adu lokv—mvnwng nga ngonugv Ahtu Pwknvyarnv ninyi atubogv lvgabv goklwkto.” ");
INSERT INTO tgj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitar bunua dinchinam gaam minto okv hv mindwkkrwkla minto, “Alvmanv nyi vdwgvlo mvritririt aarinvpv nonuno ringsu laka!” ");
INSERT INTO tgj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bunu vdwv awgonv mvngjwngto ninyigv doina okv baptisma naakunam, okv ho alulo hejar aom dvsv gobv nyitwnggo apam hoka aapwng toku. ");
INSERT INTO tgj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bunugv dwa jila Apostol vdwgvlo risar sunya toku, kumkulo kumbam nyato, dvnam am jimi suto okv kummi suto. ");
INSERT INTO tgj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aigo lamrwpanam okv kaasartabo namgo ritoku Apostol lokv okv nyi mvnwng ngv kaalam paktola mvngto. ");
INSERT INTO tgj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mvngjwngnv mvnwng ngv lvkin gubv nvchibv kumkulo kumbv ribv nyatoku okv bunugv yikungyira am ajinanying nga jimi sunya toku. ");
INSERT INTO tgj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bunu vdwv atugv yikungyira okv ayi nga pyoktokula okv morko nga mvnwng ngv pingkolo akinakin gv ogugo dinchinam nga orpinorin sito. ");
INSERT INTO tgj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Alu logo yayaku bunu lvkobv Pwknvyarnv gv Naam arwnglo apam gubv kaarwksuto, okv bunugv dvnamtvngnam nga bunugv naamlo lvkobv, hapokv mvngpula okv nyaknyak bv dvbamto, ");
INSERT INTO tgj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pwknvyarnv hartv la, okv nyi mvnwng gv alvbv mvngnam saknama himpala himpu nyatoku. Okv alu lokia Ahtu ringlin kunam vdwa bunugv apumlo aapwng momu toku. ");
INSERT INTO tgj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Alu logolo Pitar okv Jon kumdw lo, ariumgv gunta aom lo kumbv Pwknvyarnvnaam lo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hoka Kaapunv Agi minamgo dooto, nyi ako ninyigv singcha ilo gvngv lvpik bogobv rinvgo dooto. Aludwkibv ninyia agi lo baklwk kito nyi vdwlokv morko koonam lvgabv yvvbunu Pwknvyarnv gv Pwknvyarnvnaam bv vngdudw. ");
INSERT INTO tgj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Vdwlo hv Pitar okv Jon bunyia arwngbv aadubv kaapa tokudw, hv ogu achukgo ninyia jikubv bunua kootoku. ");
INSERT INTO tgj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bunu ninyia kaadichinchin la kaato, okv Pitar mintoku, “Ngonua kaato!” ");
INSERT INTO tgj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Vkvlvgabv hv bunua kaato, mvngto bunu gvlo ogu achukgo paiji vla. ");
INSERT INTO tgj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Vbvritola Pitar ninyia mintoku, “Vjak ngo gvlo morko achukguka kaama, vbvritola ngo nam jire ngo gvlo ogugo doopvdw: Najaret Jisu Kristo gv amin bv ngo nam mindunv gudungto okv vngkar tokuka!” ");
INSERT INTO tgj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Vbvrikunamv hv gakbwngto ninyigv laakbik laak lokv okv ninyia svvraptoku. Vjakpigobv nyi angv gv lvpa okv gorbwng ngv gwlwktoku; ");
INSERT INTO tgj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","hv pokdinpokrin toku, ninyigv lvpa ngv dakdin jitoku, okv vngraptoku angchar vngyarla. Vbvrikunamv hv bunugv lvkobv Pwknvyarnv gv Naam arwngbv aaming gvvto, vngyingla okv pokyingla okv Pwknvyarnv hartvbamtvla. ");
INSERT INTO tgj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hoka nyi vdwv ninyia vngkar dubv kaatoku okv Pwknvyarnvnyi hartvbamtv dubv, ");
INSERT INTO tgj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","okv vdwlo bunu ninyia kaapunv agilo dootola koriak karnv gubv kachin tukudw, bunu mvnwng ngv lamdokpanyato okv mvngnyato ogugo ninyia ripv kunvdw. ");
INSERT INTO tgj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pitar okv Jon Solomon gv giabv, vla um vbvching mintoku hoka vngrilo nyi angv bunyia gakbwng toku, nyi vdwv lamngakpanyato okv bunu gvlo joklwk nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Vdwlo Pitar nyi vdwa kaapa tokula, hv bunua minto, “Israel gv nyi vdwv, Ho so nonuno ogubv lamdokpadunv, okv nonuno ogubv ngonua kaagap chinchila kaadunv? Nonu vbv mvngdunvre soogv nyi angv sum vngdu kubv mvnam si ngonu atugv gwlwk vmalo jwkrw lokv mvpv nvgo mvngdu ai? ");
INSERT INTO tgj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham gv, Isaak gv, okv Jakop gv Pwknvyarnv, ngonugv abuapa vdwgv Pwknvyarnv, ninyigv Pakbu Jisunyi ninyigv kainv jwkrwa jito. Vbvritola nonuno ninyia rigvdoogvnv vdwgvlo laklwkto, okv nonuno Pilot gv dookulo ninyia toa jitoku, Pilat gv ninyia topu dokubv vla minro koching bvka. ");
INSERT INTO tgj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Hv darwkto okv alvnvbv ritoku, vbvritola nonuno ninyia toa toku, okv bununo nyi mvki yanv anga alvyabv mvngla tulin kunam lvgabv pilatnyi nonuno koonyato. ");
INSERT INTO tgj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nonuno singkurikulo vnggv jinv anga mvkito, vbvritola Pwknvyarnv ninyia sikunvnga turkur motoku—okv so sung ngonuv kaarianv vdwv. ");
INSERT INTO tgj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jisu ninyigv amin bv jwkrwa so lvpiknv nyi anga turnv nvnga jitoku. Nonuno ogu gunyi kaadudw okv chindu kudw mvngjwng lokv ninyigv amin bv ripvkonv; Jisunyi mvngjwng kunam lvgalo ninyia alvmopv kunv, vbv nonu mvnwng nga kaadubv. ");
INSERT INTO tgj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Okv vjv, ngoogv ajin vdwv, ngo chindu ho nonuno ogugunyi okv nonugv nyi rigvnv vdwv Jisunyi chinchirichi mabv rinyato. ");
INSERT INTO tgj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Klu gvngv Pwknvyarnv nyijwk mvnwng gvlo mimu toku ho ninyigv Kristo ngv hinching chingre; okv hv um svbv jvjv dukubv mvjitoku. ");
INSERT INTO tgj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Vbvrikunamv, mvngdwn tokuka, okv Pwknvyarnv gvlo aanyato, nonuno vbv rikubolo, hv nonugv rimur am mvngnga jiriku. ");
INSERT INTO tgj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ahtu gvlokv Dow atortornv nvnv dw ngv aariku, okv hv Jisunyi vngmu riku, yvvdw Messiah vla hv nonuno gv lvgabv gakpv kunamv. ");
INSERT INTO tgj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hv nyidomooku lo doyare ho dw vv aama dvdvlo ogumvnwng ngv anw malo, Pwknvyarnv vbv mimpa jito ninyigv darwknv nyijwk yvvbunudw krimklu gv rinv lokv. ");
INSERT INTO tgj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses minto, Nonugv Pwknvyarnv Ahtu nonua jilwkre nyijwk akobv, sijv nga hv jilwknam aingbv, okv nonugv atugv nyi lokv akonv singri nvpv. Nonuno ogumvnwng nga tvvtoka ho nonuno ninyigv minama ritoka. ");
INSERT INTO tgj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Akonv yvv ho nyijwk am tvvmabolo Pwknvyarnv gv nyi vdwgvlo mvpin suriku okv mvyakmvchak riku.’ ");
INSERT INTO tgj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Okv nyijwk mvnwng ngv yvv doin minpvdw Samuelnyi mindvla okv yvvbunu ninyigv kochingbv aakunv, japta jitoku Silumelu ogugo ridu kudw. ");
INSERT INTO tgj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nonu gvbv nyijwk vdwgv lokv Pwknvyarnv milv jito, okv ogugonyi Pwknvyarnv nonugv abuapa vdwa lvkobv mvrwjinama nonuno mvpinmiyin minsuto. Hv Abrahamnyi vbv minto, ‘Nonugv husi lokv ngo schingmooku gv nyi mvnwng nga ayare.’ ");
INSERT INTO tgj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Okv vkvlvgabv Pwknvyarnv ninyigv Pakbu nga gaklin riku okv ninyia nonu lo jilwk chore, nonua ayare nonugv akinakin gv alvmanv lamtv loka lingkur moriku.” ");
INSERT INTO tgj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitar okv Jon nyi vdwa mindung rilo, nyibu kvvgonv, Pwknvyarnvnaam dakriakarianv okv Sadusi kvvgonv vngchi toku. ");
INSERT INTO tgj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bunu ridwkriku nyato vkvlvgavbolo Apostol anyiv nyi vdwa tamsarla ho Jisu gv sipikula turkur kunama, vdwlo chintoku ho sitokula turkur kunv nga. ");
INSERT INTO tgj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Vkvlvgabv bunu bunua naatungto okv bunua patwk arwnglo tumpvto alu lonyinvnv aama dvdvbv, si ogubvrijvka tapv rotoku. ");
INSERT INTO tgj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Vbvritokula meegonv yvv doina tvvpvdw vv mvngjwngto; okv nyi vdwv aapwng yayala hejar angu dvsv gubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Alu logonvgv kochingbv Jius gv rigvbu vdw, nyigagatv vdw, okv pvbv tamsarnv vdwv Jerusalem aakumto. ");
INSERT INTO tgj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bunu lvkobv kaarwk minsuto nyibu butvyachok Annas okv Kaiapas, Jon, Alekjandar, okv yvvdw nyibu butv gv dvpar parkin bv rinv kvvbi vdwaka. ");
INSERT INTO tgj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bunu milinto Apostol vdwa bunugv atuklo dakmu tvla okv bunua tvuto, “No oguaingbv ripvnv so? No ogolokv jwkrw papvnv vmalo yvvgv amin bv nonu rinv dunv?” ");
INSERT INTO tgj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pitar, Darwknv Dow ngv akomaring bv dootola, bunua mirwksuto, “Nyi vdwa tujupkunam vdwa la okv nyigagatv vdwa: ");
INSERT INTO tgj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ngonu silu alvrungnv rinam nyi lvpikbo anga okv oguaingbv hv mvpunam vdw tvvkabolo, ");
INSERT INTO tgj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","vbvrikunamv nonu mvnwng ngv chinto kulaka, okv Israel gv nyi mvnwng vka chinto kulaka, ho nonugv kaagialo so suka daknv nyi angv ogumvnwng ngv alv duku Najaret Jisu kristo gv amin gv jwkrw nonugv daapo lo takkinam okv sikunv anga Pwknvyarnv gv turkur mokunam. ");
INSERT INTO tgj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisu Darwknv kitaplo minpvnam angv, ‘Nonu naam mvnv vdwgv toakunam vlwng angv mvnwng nga dinchi yachok nvgobv ritoku.’ ");
INSERT INTO tgj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ringlinbaalin nama ninyi akin lokv pamwngre; nyiamooku soka Pwknvyarnv yvvnyika jinam kaama ngonua ringnyu dubv.” ");
INSERT INTO tgj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dopam gv nyi vdwv Pitar okv Jon bunyia kaanyato okv chintoku bunyiv ogumanv ngv puriputa kaama nvgo oguaingbv busu mabv mindu nvgoda vla lamnyato. Vbvrikunamv bunu mvngdw toku ho bunyiv Jisu gv rikulo rinvgo. ");
INSERT INTO tgj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Vbvritola bunu hoka oguka minyu kumato, ogulvgavbolo nyi mvpunam angv Pitar okv Jon bunyi lvkobv dakdubv bunu kaato. ");
INSERT INTO tgj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Vkvlvgabv bunu bunua kvbadopam karchung lokv vngro dukubv mintoku, okv vbvrikunamv bunu bunugv pinkolo japrap minsuto. ");
INSERT INTO tgj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ngonu so nyi vdwa lvkobv ogu ridubv?” bunu tvvkato. “Jerusalem gv nyi nyicharv ho chinyato so bunu gvlo akusubv rinyu manam lamrwpanam go kaatamto, okv ngonu hum miya jinyuma. ");
INSERT INTO tgj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Vbvritola so gaam sum pvpvlaju nyi vdwgv pinkolo tvvsik suma dubv, klvi ngonu so nyi vdwa gamrw laju yvvnyika lvkodv Jisu gv amina minkar kuma dubv mintor laju.” ");
INSERT INTO tgj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Vkvlvgabv bunu arwnglo bunua gokkur lvkto okv bunua mintoku ogugoka tvvkayo nonuno Jisu gv amin bv japkuyo vmalo tamsarka koomabvkv. ");
INSERT INTO tgj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Vbvritola Pitar okv Jon bunua mirwksuto, “Nonu atuv jwngkadaka suto ogolo angv Pwknvyarnv gvlo tarwkbak yadunvdw—nonua tvvria svgobvri vmalo Pwknvyarnvnyi tvvria svgobvri. ");
INSERT INTO tgj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ngonu atubongv ogugo kaapvdw okv tvvpvdw um ngonu mintong nga topunyuma.” ");
INSERT INTO tgj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Vkvlvgabv dopamv bunua kaiyayabv gamrw rwkto okv vbvrikunamv bunua topu nyatoku. Bunu kaatoku hoka bunua mvrit nyomare vla, ogulvgavbolo ogugo ripvkudi um nyi mvnwng ngv Pwknvyarnv hartv tvvdung nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yvvnyi lamrwpadubv kaatamla mvpunam nyi angv anying champi lvgubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pitar okv Jon bunyia topusopitda, bunugv ribam achamlo bunu vngkurtuku okv bunua mimpa toku ogugo nyibu butv vdwgv okv nyigagatv vdwgv minku nvnga. ");
INSERT INTO tgj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Vdwlo mvngjwngnv vdwv um tvvpa namgola, bunu mvnwng ngv lvkin gobv Pwknvyarnvnyi kumto: “Ahtuv okv nyidomooku nga Pwklinyarlinv, sichingmooku, okv Svmasa, okv ho bunu doonv mvnwng ngv ninyi gvngv! ");
INSERT INTO tgj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","No minto Darwknv Dow lokv ngonugv abuapa noogv pakbu, Dabid gvlo, vdwlo hv minto, ‘Ogubv Jentail vdwa haak nyadunv; ogubv nyi vdwv anyung kaamabv bunu gwngnya dunv? ");
INSERT INTO tgj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sichingmooku gv dvbv vdwv bunu atubongv mvngbv rinyato, okv nyi am rigvnv vdwv lvkobv kaarwk minsula Ahtunyi okv ninyigv Kristonyi nyiru nyato.’ ");
INSERT INTO tgj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Herod okv Pontius Pilat soogv pamtvlo jentail vdwa lvkobv kaarwk minsuto okv Israel gv nyi vdwvka Jisunyi nyirula, noogv Darwknv Pakbu, yvvnyi noogv Messiah mvnamv. ");
INSERT INTO tgj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bunu ogumvnwng nga ridubv vngkum nyatoku ho noogv jwkrw okv mvngnam lokv rirung nvpv vnamv. ");
INSERT INTO tgj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Okv vjv, Ahtua, bunugv milam mincham la rinam am kaayato, okv ngonua jito, noogv pakbu vdwa milakdubv, noogv doin mvnwng nga lvkobv busukano kamabv mindubv. ");
INSERT INTO tgj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mvpudubv noogv laakv irapto, okv ho gv kaasartabo okv lamrwpanama kaatam dubv jilinto noogv darwknv Pakbu Jisu gv amin bv.” ");
INSERT INTO tgj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Vdwlo bunu kumnya kunam gola, hoka bunugv dopam dookulo hwkdinto. Bunu mvnwng nga lvkobv Darwknv Dow aatoku okv Pwknvyarnv gv doina lvkobv busukano kamabv japgo raptoku. ");
INSERT INTO tgj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mvngjwngnv vdwv haapokv pwkin gubv mvngtoku. Yvvka ninyigv atu gvngv kv vla minkumato, vbvritola bunugv ogugo doodudw mvnwng nga bunu vdwv lvkobv orpin sitoku. ");
INSERT INTO tgj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kainv jwkrwa lvkobv Apostol vdwv Ahtu Jisu gv turkur kunama mingo jitoku, okv Pwknvyarnv bunu mvnwng nga nyitv nga boktalwkji toku. ");
INSERT INTO tgj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Hoka nyipam arwng hoka yvvnyika paajinv dvdv ngv pamanam kaakuma. Yvvbunudw rongo vmalo naam doonv ngv um pyoktokula, pyoknam morko naarwk sukunama bvnglwk nyatoku, ");
INSERT INTO tgj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","okv um Apostol vdwgv laak lo laklwk toku; okv morko nga barsaksakbv ninyigv mvngnam lo orpin sitoku. ");
INSERT INTO tgj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Okv vbv ho Josep vnamgo, Lebi nyigo Saipraslo bvngnamgo, ninyia Apostol vdwv Barnabas vla minto (ho minamsi “Oogv mintvmiru yanv”), ");
INSERT INTO tgj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","hv atubongv gv rongo nga pyoklaku, morko nga bvnglwk jitoku, okv Apostol vdwgvlo laklwk jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Vbvritola hoka nyi akonvgv aminv Ananias, ho ninyigv nywng Sapphira lvkobv bunugvlo yikungyira doonv nga kvvgonyi pyoktoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Vbvritola ninyigv nywng gv lvkobv umkvpakv vmisila hv morko kvvgonyi nyigvbv pvchingto okv kvvgonyi Apostol vdwlo laklwkto. ");
INSERT INTO tgj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pitar ninyia minto, “Ananias, no ogulvgabv Uyudvbv nga yaaku dunv okv yikungyira lokv paanam morko nga kvvgonyi pvpvtola no Darwknv Dowa mvvdunv? ");
INSERT INTO tgj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Atuk lo no yikungyira nga pyoktv madvbv, vv no gvbv rito; okv pyokro kochingbv, morko ngv nokvku. Vbvrikunamv, no ogubv so svkvnvgo ridubv mvngpvnv? No nyi am mvvmado—no Pwknvyarnvnyi mvvdu!” ");
INSERT INTO tgj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias so tvvpa sopikda, hv giyala sidasirato; okv yvv um tvvbvdw mvnwng ngv busu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nyipayapa vdwv aatoku, ninyigv ayak am maatum tumtoku, ninyia agumbv baklin toku, okv ninyia sima ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Gunta aom lvlv kochinglo ninyigv nywng ngv, ogugo ripvdw chiya kumabv, arwnglo aatoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pitar ninyia tvvkato, “Nga mimpato, morko mvnwng ngv si mvngchikre no la noogv nyilu nonyi gv yikungyira pyoknam lo paanamv?” “Vmabv,” hv mirwkto, “mvnwng vmabv.” ");
INSERT INTO tgj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Vkvlvgabv Pitar ninyia minto, “Ogubv no la noogv nyiluv Ahtu gv Dowa rikwripak dubv mvngpvnv? Noogv nyilu nga simarinv nyi vdwv vjv agiv daknyado, okv bunu namka agumlo baklin riku!” ");
INSERT INTO tgj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Vjakpigobv hv ninyigv lvpa lvkwng bv gimupla okv sidapvto. Yaapa vdwv arwng aatola okv ho kaakunamv hv sitoku, vkvlvgabv bunu ninyia baklinto okv ninyigv nyilu adarlo ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gvrja mvnwng ngv okv yvvdw so kvvbi tvvpapvdw tvvnv mvnwng ngv busu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mvngchigo lamrwpadubv okv kaasartabobv nyi vdwgv pinkolo Apostol vdwv kaatamto. Mvngjwngnv mvnwng ngv lvkin gubv Solomon gv giabv lo kaarwk minsuto. ");
INSERT INTO tgj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Agum lokv akonvka nyitwnglo mvngpak mabv bunua lvkobv aapwng nyumato, nyi vdwv bunua kainvgobv japnya kujvka. ");
INSERT INTO tgj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Vbvritola kaiyayabv nyi yangv nyipamv aapwng yayato—Ahtunyi mvngjwngnv nyimv okv nyilo bv twngtv toku. ");
INSERT INTO tgj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kaakunamv lvvmanv nyi vdwa lamtv lo bakdar linto okv gadw lo okv kuchoklo karmu tola ho maanyikinyingka Pitar gv yalu babuv bunua vngsikla okv bunua poya modubv vla ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Okv Jerusalem adarai gv banggu lokv nyitwnggo aatoku, ho vdwv yvv lvvmapvdw vmalo yvvbunuam alvmanv dow doonv nga aagvnyato; okv bunu mvnwng ngv poyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Vbvrikunamv Nyibu Butvyachuk okv ninyigv richam mvnwng ngv, sadusis gv ridungnv vdw vla, Apostol vdwa achialvbv kaanwng mabv rinyato; vkvlvgabv bunu rirap dokubv mimisitoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bunu Apostol vdwa naatung toku okv bunua kvba patwk arwnglo tumlwkto. ");
INSERT INTO tgj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Vbvritola ho ayuyupra lo Ahtu gv nyidogindung akonv patwk agiya kukda pvvtola, Apostol vdwa agum linggvto, okv bunua minto, ");
INSERT INTO tgj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Vngnyika okv Pwknvyarnvnaam arwnglo daktola nyi mvnwng nga so anwnv singdung lvgabv mimpa tvka.” ");
INSERT INTO tgj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Apostol vdwv tvvda laikula, okv arukamchi doonyi chaalin rilo bunu Pwknvyarnvnaam lo aalakula okv tamsar sarap toku. Nyibu Butvyachok okv ninyigv ajin vdwv Jius gv nyigagatv mvnwng nga dopam pamdubv gokum nyato; vbvrikunamv patwk lo nyi vdwa orto jitola Apostol vdwa bunugv kaagialo boolwk dubv minto. ");
INSERT INTO tgj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Vbvritola vdwlo nyigam vdwv vngchi tokudw, bunu Apostol vdwa patwk arwnglo kaapa kuma, vkvlvgabv bunu kvba lo vngkur lakula okv mimpa toku, ");
INSERT INTO tgj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ngonu vdwlo patwk hoka vngchi kunamv, ngonu vriap am alvbv raktin dubv kaato okv agi ho kaaria nvngv chin mvnwng ngv dakdubv kaato; vbvritola vdwlo ngonu agiya kokda kunamv, ngonu arwnglo akoka kaapa kumato!” ");
INSERT INTO tgj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Vdwlo nyibu butv mvnwng okv gvrja lo kaariadakrianv vdwv so tvvpa kunam gola, Apostol vdwa ogugo riku namngvdw bunu lamrwsuk panya toku. ");
INSERT INTO tgj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Vbvrikunamv nyi ako arwng aatoku okv bunua minto, “Tvvriato! Nonu patwk tumnam nyi vdwv Pwknvyarnvnaam arwng gv nyi vdwa tamsar nyadu!” ");
INSERT INTO tgj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Vkvlvgabv Nyigam gamtv angv ninyigv nyi vdwa lvkobv vnglaku okv Apostol vdwa aakur gvvtoku. Vbvrikujvka, bunu mvduridu bv mvngka kuma, vkvlvgavbolo bunu busu nyato ho nyi vdwv bunua vlwng orji mvngbv. ");
INSERT INTO tgj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bunu Apostol vdwa arwnglo aagv tola, bunua kvba kaagialo dakmu toku, okv Nyibu Butvyachok angv bunua tvvkato. ");
INSERT INTO tgj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ngonu nonuam so nyi angv amin bv tamsar karma bvkv vla orto jitoku,” hv minto; “vbvritola nonuno ogugo ridudw kaatoku! Nonugv tamsarnama Jerusalem mvnwnglo dupwng mooto, okv nonuno ninyigv siku nvgv lvgabv alv ponampoma nga ngonua laarwk simu dubv mvngdu!” ");
INSERT INTO tgj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pitar okv Apostol kvvgonv mirwksito, “Ngonu Pwknvyarnvnyi tvvrung dubv rirungdu, nyi yanga ma. ");
INSERT INTO tgj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ngonugv abuapa gv Pwknvyarnv sikunv Jisunyi turrap motoku, nonugv ninyia daapolo takkiro kochingbv. ");
INSERT INTO tgj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pwknvyarnv ninyia turkur motoku ninyigv lakbik takbvku Rigvnvgobv okv Ringnv gobv, Israel gv nyi vdwa mvngdin modubv alvnv dw nga jitoku okv bunugv rimur am mvngnga dokubv. ");
INSERT INTO tgj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","So oguogu mvnwng nga ngonu tvriakarianv vdwv Ngonu okv Darwknv Dow, yvvdw Pwknvyarnv gv amin jinam hogv yvbunudw ninyia tvvdunv.” ");
INSERT INTO tgj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Vdwlo dopam gv nyi vdwv sum tvvpa nvgola, ho bunu mvnwng ngv achialvbv haachito bunu Apostol vdwa mvki dukubv mvngnya toku. ");
INSERT INTO tgj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Vbvritola bunugv lokv akonv, Parisis go aminv Gamaliel vnamgo hv Pvbv tamsar nvgo okv nyi mvnwng gv mvngdv kunam go, kvba arwnglo dakrap toku. Hv Apostol vdwa agumlo achukgo daklin modubv orto jitoku, ");
INSERT INTO tgj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","okv vbvrikunamv hv kvba vdwa minto, “Israel gv ribam vdwa, so nyi vdw sum nonuno ogugo ritvdonvdw imasuto laka. ");
INSERT INTO tgj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nonuno mvngpato kvvlogv ho Tiudas gv kaatam nama, nyi kvvgonv kaibogobv hartvto, okv nyiga lvngpi gobv ninyia tulwkla riming gvvto. Vbvritola ninyia mvki kunamv, ninyigv nyi vdwv apinain toku, okv ninyigv binamtapnamka siro nyvrokaku. ");
INSERT INTO tgj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hokochingbv, Judas Galili nyi go amin lvkardw alulo aalwkto; ninyigv nyitwnggo ninyia kochingbv riming gvvto, vbvritola ninyia aka mvki toku, okv ninyigv ribam mvnwng vka kipinkiyin toku. ");
INSERT INTO tgj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Okv so lvgabv, ngo nonua mindunv, oguguka ho nyi vdwa mvmarima bvka. Bunua mvngchik toputo! Bunu ogugo rungdupadudw okv ridupadudw vv nyi mvngdungridung lokv ridubolo, vv nyeri kunvpv, ");
INSERT INTO tgj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","vbvritola vv Pwknvyarnv gvlokv aadubolo, nonuno bunua mvchinrichin nyomare. Nonuno chinsure atubongv Pwknvyarnvnyi rinyingriru bv padarminsu namnga!” Kvba mvnwng ngv Gamaliel gv minam am tvvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bunu Apostol vdwa goklwk tvla, bunua svnyak patoku, okv bunua Jisu gv amin bv mingku madu kubv mintoku; okv vbvrikunamv bunua anyubv topu jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Okvku Apostol vdwv kvba lokv lintoku, bunu himpu toku, vkvlvgavbolo Pwknvyarnv ngv bunua Jisu gvbv rinam adwkaku nvnga boktalwkji toku. ");
INSERT INTO tgj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Okv aludwkibv Pwknvyarnvnaam lo okv nyi mvnwng gv naam lo bunu minsar sarbv dula okv alvnv yunying nga Jisu Kristo lvkwnglo gvvtam jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ayungjvma nga, lvbwlaksu vdwv twngtv yaya toku, hoka Grik gaam minv Jius gola okv Jius jvjvgo bunu gvlo yalunggo dumisito. Grik minv Jius vdwv minyato ho bunugv hvngmi vdwv aludwkibv dvnamtvngnam ornam nga mvnglwk makv vto. ");
INSERT INTO tgj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Vkvlvgabv Apostol vringgola anyiv mvngjwngnv vdwa lvkobv gokkum nyato okv minto, “So si ngonu gvbv alvma Pwknvyarnv gv gaama japma yabvya ainmorko a gakbwngla rinamv. ");
INSERT INTO tgj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Vkvlvgabv, ajin vdwv nonugv pinkolo nyi kanwgo darlinto yvv alvjvbv darwknv Dowa gvvdunv okv minlak dunv, okv vkvnvlo ngonu bunua soogv lvgabv kaaria dubv tulwkre. ");
INSERT INTO tgj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Vbvritola, ngonu atubongv kumku lo okv japgokolo rilwkdoolwk riku.” ");
INSERT INTO tgj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nyitwng mvnwng ngv Apostol gv mingku bv lvkobv tulwk minggv toku, vkvlvgabv bunu Stipinnyi tulwkto, nyi angv achialvbv mvngjwng okv Darwknv Dow dooto, okv Pilip, Prokoras, Nikanor, Timon, Parminas, okv Nikolas, Antiok lokv Jentail nyi go klu lokv Judaism lo aaku nvgo. ");
INSERT INTO tgj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nyitwng ngv bunua Apostol vdwgvlo daklin motoku, bunu mvnwng gv laak v bunu gvlo lakpv tola kumtoku. ");
INSERT INTO tgj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Okv Pwknvyarnv gv gamcharv tloblobv dupwng karbv moduku. Mvngjwng nvngv Jerusalem lo twngtv yaya toku, okv nyibu vdwka achialvgo mvngjwng la tulwk minggv toku. ");
INSERT INTO tgj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stipin, Pwknvyarnv gv jwkrw okv kairungnv boktalwkjinam nyi ako, nyi mvnwng gv apam lo achialvgo lamrwpadubv okv kaasartabo bv kaatamto. ");
INSERT INTO tgj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Vbvritola ninyia Jius kumkunaam gv topukunam nyi vdwv bunu kaanwng mabv rito, (um vbv minto) ho vv Jius lokv Sairene okv Alekjandaria gvgoto. Bunu okv kvvbi Jius Silisia okv Asia lokv Stipinnyi lvkobv larmi surap toku. ");
INSERT INTO tgj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Vbvritola Darwknv Dowv Stipinnyi mvnglak moto vdwlo hv mirap tokudw, bunu ninyia larya yanyumato. ");
INSERT INTO tgj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Vkvlvgabv bunu nyi kvvgonyi jinamgo jinyok tola mimuto, “Ngonu ninyia Moses okv Pwknvyarnvnyi tvvrutvya dubv minam am tvvyapvnv kv!” ");
INSERT INTO tgj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Vbvrila bunu nyi mvnwng nga miriok patoku, nyigagatv vdwa, okv pvbv tamsarnv vdwa. Bunu Stipinnyi naatung toku okv ninyia kvba kaagialo boolwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Vbvrikunamv ninyia mvvya modu bv bunu nyi meego naalwkto. Bunu minto, “so nyi si”, “ngonugv Pwknvyarnvnaam gv okv Moses gv Pvbv nga dvbvdwkibv minyingmiru mingki yado. ");
INSERT INTO tgj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ngonu ninyia vbv mindubv tvvto so Najaret gv Jisu Pwknvyarnvnaam am mvyakre okv Moses gv lokv ngonu kvvlogv ridung mvnwng nga akusibv mvriku!” ");
INSERT INTO tgj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kvbalo doonv mvnwng ngv bunugv nyikv Stipinnyi kaagap jinjin namv ninyigv nyukmuv nyidogindung gv nyukmu aingbv ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nyibu butvyachok ngv Stipinnyi tvvkato, “So si jvjv ngvri?” ");
INSERT INTO tgj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stipin mirwksito, “Achiboru vdw okv Abu vdw, ngoogv minama tvvriato! Kvvlo ngonugv abuapa Abraham Haran lo vngtv madvbv Mesopotamia doyilo kairungnv Pwknvyarnv ninyia kaatam suto ");
INSERT INTO tgj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","okv ninyia minto, ‘Noogv mooku isi okv vpinvriap vngyuto okv vnglinto ho mookulo nam ngo kaatamre.’ ");
INSERT INTO tgj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Okv hv vbvrikunamv ninyigv diringmooku isi nga vngyu toku okv Haran lo vngla dootoku. Abraham gv abu siro kochingbv, Pwknvyarnv ninyia so mooku so doodubv mvto vjak ogolo hv doopvdw. ");
INSERT INTO tgj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Vbvrikunamv Pwknvyarnv Abrahamnyi mooku achukguka ninyigvbv jimato, lvchu kurpv kogodaka jimato, vbvritola Pwknvyarnv milvto ninyia sum jidubv vla, okv vv ninyigvbv ridukubv okv ninyigv singsit gvbv ridukubv. Alu dwlo Pwknvyarnv soogv milv nam sum milin jitoku, ho Abraham gv umvuu kaamarilo. ");
INSERT INTO tgj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ninyia Pwknvyarnv svbv minto: ‘Noogv singsit vdwv nyebunyi diringmooku isi lo doore, hoka bunua nyira gubv okv anying nyingpi go hingching dubv mvrikla doogvre. ");
INSERT INTO tgj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Vbvritola ngo nyi vdwgvlo vngbo jwngkadaka namgo doore ho bunu vdwv pakbu jvbv ririku, Okv Hokochingbv noogv singsit vdwv bunu vnglin riku ho diringmooku lokv okv nga kumriku so gwngda arwnglo.’ ");
INSERT INTO tgj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Vbvrikunamv Pwknvyarnv Abrahamnyi ayakmvu namgo kaachin dubv bunyi gv mingkimiyak minsu nama mvngpala rimunam lvgabv jitoku. Vkvlvgabv Abraham Isaaknyi bvngla alu kanw kochinglo ayakmvu toku; Isaak ninyigv kuunyilo Jakopnyi ayakmvu toku, okv Jakop ninyigv kuunyilo ngonugv yunyingyunam abuapa bv rinv kuunyilo vdwa ayakmvu toku. ");
INSERT INTO tgj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jakop gv kuunyilo vdwv bunugv boru Josepnyi kaanwng mabv rito okv ninyia pakbu bv Ijipt lo pioklwkto. Vbvrijvka Pwknvyarnv ninyi gvlo lvkobv dooto ");
INSERT INTO tgj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","okv ninyigv adwkaku mvnwng lokv ninyia atupachi kaama dubv laalwk toku. Vdwlo Josep Ijipt gv dvbv nga kaarwksitv madvbv, Pwknvyarnv ngv ninyia mvngyam nvnv okv mvnglaknvnv am jilwkto, okv dvbv ngv Josepnyi diringmooku isi mvnwng okv nasungnaam nga kaaria dubv gobunor gubv mvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Vbvrikunamv Ijipt okv Kanaan mooku mvnwng lo hoka yarwngdwrw ngv aatoku, vbvrikunamv achialvbv adwkaku toku. Ngonugv abuapa vdwv oguguka dvsvtwngsv ka paakuma, ");
INSERT INTO tgj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","okv vdwlo Jakop Ijipt lo hoka aamtami dvpatwngpa dubv tvvpapvdw, hv vngmuto ninyigv kuunyilo vdwa, ngonugv abuapa, bunua hoka vngcho moto. ");
INSERT INTO tgj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lvnyinvbv vngkurkunam lo Josepnyi atubongv achiboru vdwa kaachin kodu bv ritoku, okv Ijipt gv dvbv ngv Josep gv vpinvriap am chinya toku. ");
INSERT INTO tgj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Vbvrikunamv Josep atugv abu Jakopnyi yunying go, ninyia milwkto okv vpinvriap mvnwng nga, nyi chamkanw gola angu mvnwng aka, Ijipt lo aadubv. ");
INSERT INTO tgj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Vbvrikunamv Jakop Ijipt lo vngto, ogolo ninyila okv ninyigv kuunyilo vdwgv silwkku bv rikuv. ");
INSERT INTO tgj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ho bunugv svma nga Sikem lo baktoku, bunugv nyibung rikua Abraham Hamor haalung gvlo morko jitola rvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Vdwlo Pwknvyarnv Abrahamnyi milv namv dw vv aanwk tokudw, Ijipt lo ngonugv nyi ngv twngtv yaya toku. ");
INSERT INTO tgj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Anyungnga Josep gv lvkwng lo chima nvgonv dvbv ako Ijipt lo rigvla riraptoku. ");
INSERT INTO tgj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Hv ngonugv abuapa nga gwngkupto okv bunua aiamar mato, bunugv kuu anga vdwa bunua naam lokv agumlo charlila dubv mvto, vkvlvgavbolo simu dubv vla ");
INSERT INTO tgj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ho dwlo Mosesnyi bvngto, anga angv achialvbv kaaputo. Ninyia naam lo poolu pwkgumgo ringchum la rito, ");
INSERT INTO tgj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","okv vdwlo ninyigv naam lokv ninyia agum lo topak tokudw, dvbv gv umvnyijar angv ninyia laato okv ninyia atugv kuunyilo gubv mvla ninyia sootv toku. ");
INSERT INTO tgj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ninyi Ijipt nyi vdwgv mvngkimvnglak mvnwng nga tamsar toku okv kokwng loku gaamlo milaknv chinvpanv kainv nyi gubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Vdwlo Moses anying champi tokudw, hv mvngchinla ritoku ninyigv Israel ajin vdwgv vdwgo hirukaya mvnwng nga hinla ridu kudw. ");
INSERT INTO tgj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Bunugv lokv akonyi Ijipt nyi akonv richingriying ridubv hv kaapa toku, vkvlvgabv ninyia ringbv hv vngtoku okv mvrwk sula ninyia mvki toku. ");
INSERT INTO tgj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Hv mvngnamv ninyigv atugv nyi vdwv mvngchin pvkunvpv Pwknvyarnv ninyia bunua linggv dukubv ritv dunv vla, vbvrilachin bunu vdwv oguka mvngchin mato) ");
INSERT INTO tgj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lvnyinvbv logo nvnga vngyilo hv Israel nyi anyigo mvmi sudubv kaapato, okv hv anyi gv pingkolo alv minsu modubv gwngkw rikwto. Hv minto, ‘nyi vdwa, tvriato,’ ‘bunyi anyino Israel anying vlaka; ogubv nonuno sibv padarminsu dunv?’ ");
INSERT INTO tgj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Vbvritola richingriying yanv akonv Mosesnyi nvnglin toku. Hv mintoku, ‘Ngonyi gv pingkolo nam miriavngria dubv mvnv ngv yvvla?’ ");
INSERT INTO tgj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘No meru hogv Ijipt nyi akonyi mvki nam aingbv, no ngaaka mvkiso mvngpv ai?’ ");
INSERT INTO tgj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Vdwlo sum Moses tvvpa namgola, hv Ijipt mooku gvngv kilin toku okv Midian mooku lo vngla dootoku. Hoka ninyi kuunyilo anyigo dootoku. ");
INSERT INTO tgj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Anying champi go vngro koching nga, nyidogindung akonv chokri mooku gv mootum yamchum golo vmvbv gulinla Sinai moodw gv nvchilo Mosesnyi kaarwksuto. ");
INSERT INTO tgj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses kaato kula hv lamngakpatoku, okv mootum gv yamchum nvchilo aatoku kaabwk dubv vla. Vbvritola Ahtu gv gaama hv tvvpa toku:” ");
INSERT INTO tgj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ngo nonugv abuapa vdwgv Pwknvyarnv ngv, Abraham, Isaak, okv Jakop gv Pwknvyarnv ngv.’ Moses busula jinjin rumrumto okv kaadw chinchi nyumato. ");
INSERT INTO tgj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ahtu ninyia minto, ‘Noogv lvkiama pilin pvtoka, no ogolo dakpvdw ho kwdwv darwk nvngv. ");
INSERT INTO tgj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ngoogv nyi vdwa Ijipt lo alvmabv hirukaya hindubv kaato. Ngo bunugv svgok goknama tvvpvnv, okv ngo bunua ringlin tvvbv ipvnv. Vjak aato; ngo nam Ijipt lo vngmure.’ ");
INSERT INTO tgj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses Israel nyi vdwgv toakunam akonv. Bunu tvvkato, ‘nam yvvla ngonua kaariataria nvgobv okv mvpvnv?’ Pwknvyarnv ho ninyia nyi vdwa kaariatarianv akobv okv bunua ringlin dubv vngmuto nyidogindung ninyia mootum yamchum lo vmvbv gula kaarwk sunv gv ridur lokv. ");
INSERT INTO tgj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hv nyi vdwa Ijipt loka vnglin gvvtoku, kaasartabo okv Ijipt lo lamripanam kaatamto okv Lwngchingnv svmasa lo okv anying champi go chokrimookulo rikwngto. ");
INSERT INTO tgj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses akinmwng Israel gv nyi mvnwng nga minv ngv, ‘Pwknvyarnv nyijwk ako jilwkre, ninyia vjak nga jilwknam aingbv, okv vv nonugv atugv nyi ako bv rire.’ ");
INSERT INTO tgj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hv laka Israel nyi vdwa lvkobv chukri mookulo dokumla rigvdonv; hv hoka ngonugv abuapa gv lvkobvka okv ninyia lvkobv nyidogindung Sinai moodwlo ninyia japnv, okv hv Pwknvyarnv gv singdung doina naarwkla ngonu gvlo jilwkto. ");
INSERT INTO tgj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Vbvritola ngonugv abuapa vdwv ninyia tvvjimakv vtoku; bunu ninyia nvnglin pvto okv Ijipt bv vngkur dukubv bunu mvnggya toku. ");
INSERT INTO tgj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Vkvlvgabv bunu Aaronnyi minto, ‘Ngonua rigvnv pwknvyarnv gonv vtwng go ngonua mvji yapi. Ngonu chinkuma ho nyi Mosesnyi ogubv ripv kunvdw ngonua Ijipt lokv lingvkunv ngv.’ ");
INSERT INTO tgj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Vbvrikunamv bunu vbv rinya toku morti go svv nga mvring namgo mvtola, um erinpeelwkla rito, okv bunugv vbv ogugo mvpvdw ho mvkunam lvgabv hartv minsu laku dvpam goka pamnya toku. ");
INSERT INTO tgj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Vkvlvgabv Pwknvyarnv bunua dakkur toku okv bunua nyidomooku gv takar vdwa kumdujoodu bv jitoku, so sum nyijwk vdwgv kitap lo lvkpvto: ‘Israel gv nyi vdwa! ho vv ngo gvbvma nonugv chukrimooku lo anying champi go rila svnwngsvmin am pakila okv erinpeeji namv. ");
INSERT INTO tgj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ho gv vv Pwknvyarnv Molvk gv tombuv ho nonuno bakkar karnamv, okv Repan gv potuv, nonugv takar Pwknvyarnv ngv; vv bunu morti ngv nonugv kumdubv mvnam vdwv. Okv vkvlvgabv nonua ngo Bebilon nga vngbola vngram more.’ ");
INSERT INTO tgj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ngonugv abuapa vdwv Pwknvyarnv gv doomwng gvvnam tombuv chukrimooku lo bunua lvkobv dooming gvvto, vv Pwknvyarnv gv Mosesnyi mvtokv vla mingku lokv mvto, vbv mvtokv vla milam lo Moses kaatam jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kochingso, ngonugv abuapa vdwv bunugv abu vdwlokv tombua laatoku um bunu Josua gv lvkobv okv Pwknvyarnv gv kvvbi diringmooku vdwa charpak jiroku kvdw hoka aarilo bunu um bakbwngto. Okv ho tombu angv Dabid gv singri loka doodvto. ");
INSERT INTO tgj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Hv Pwknvyarnv gv mvngkiam bv rito okv Pwknvyarnvnyi kumto ninyia Jakop gv Pwknvyarnv gv lvgabv doogingku naam go mvnyu dubv jila bvkv vla kooto. ");
INSERT INTO tgj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Vbvritola Solomon yabv ninyigv lvgabv naam a mvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Vbvritola Kai yachoknv Pwknvyarnv ngv nyia laak lokv mvnam naam lo dooma dvnv; Nyijwk gv minam jvbv, ");
INSERT INTO tgj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ahtu mindu, nyidomooku ngv ngoogv dooging ngv, okv sichingmooku si ngoogv lvpa daging ngv. Oguaingnv naam go nonu ngoogv lvgabv mvtv tvvdunv? Ogolo ngoogv doolwk jikuv? ");
INSERT INTO tgj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ngo atubongv so ogumvnwng nga mvvma pvnvre?’ ");
INSERT INTO tgj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Vdwgo nonuno mvngkuk linyu madunv!” Stipin um mimbwng dvdvto. “Vdwgo nonugv haapokv chimadunv, vdwgo nonuno Pwknvyarnv gv doina rungji nyadunv! Nonuno nonugv abuapa vdwgv apia jvbv ridu; nonuka Darwknv Dowa naarwk mabv dvdvbv rikidu! ");
INSERT INTO tgj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nonugv abuapa vdwv nyijwk akoka mvjwk mvbit la rima nvngvre? Bunu Pwknvyarnv gv gindungpingko go, hogv klu kuchugv ninyigv darwkchongjornv Pakbu go aaji kunv nga mimpa jiyakunv om mvkito. Okv vjak nonu ninyia pyoktoku okv mvki toku. ");
INSERT INTO tgj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nonuno kunv Pwknvyarnv gv Pvbv nga nyidogindung gv laak loka naarwk sikunv—vbvrijvka nonuno vjaklodvbv um mingku lo tvvma duku!” ");
INSERT INTO tgj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kvba lo nyi vdwv Stipin gv minama tvvriala dooto, bunu achialv bv hidik nyato okv bunugv hijung ngv itikkvrwk nyala dokcha nyato. ");
INSERT INTO tgj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Vbvritola Stipin, Darwknv Dow akomaring tukula nyidomooku kaadungto okv Pwknvyarnv gv hartvkai nama kaapato okv Jisu Pwknvyarnv gv lakbik takbv dakto. ");
INSERT INTO tgj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Hv minto, “Kaato!” “Ngo nyidomooku nga kukko dubv kaapado okv ho Nyi gv Kuunyilo ngv Pwknvyarnv gv lakbik tangv lo dakdo!” ");
INSERT INTO tgj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kvba nyi vdwv achialv bv goknyala bunu lvkobv bunugv nyarung nga bunugv laakv mamtum nyato. Bunu mvnwng ngv baapu alvbv lvkin gubv Stipinnyi nvngjab nyato, ");
INSERT INTO tgj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","pamtv gv agum bv ninyia charlin nyato, okv ninyia vlwng ngv ornyato. Kaayatvrianv vdwv bunugv vji laklwk am Sol vnam yaapa gvlo kaachumtai yadubv orkum jito. ");
INSERT INTO tgj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bunu Stipinnyi vlwng ngv ordungto hv svgokla Ahtunyi gokto, “Ahtu Jisu, ngoogv dowa laarwk kubvkv!” ");
INSERT INTO tgj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hv lvbwng kumpv tokula okv achialv bv gokla kapto, “Ahtua! so rimur kunam sum mvngpa kuma bvkv bunugv rinyingriru kunama!” Hv sum mintokula okv sitoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Okv Sol vkvgv gwngrw sinama alv nvgobv mvngtoku. O alulo Jerusalem gvrja lo alvmanv nyi vdwv mvdwmvku namv rirapto. Mvngjwngnv mvnwng ngv Judia mooku lola okv Samaria mookulo vngyakvngchak nyato, Apostol vdwv vmwngku. ");
INSERT INTO tgj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nyi alvbv mvngjwngnv kvvgonv Stipinnyi svma ritoku, ninyigvbv mvngdwk nyala kapnya toku. ");
INSERT INTO tgj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Vbvritola Sol gvrja nga mvyakmvchak dubv gwngtoku; naam lo vngla, hv mvngjwngnv vdwa svdarlinto, anvnyimv jvka nyiga jvka okv bunua patwk lo tumlwk nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mvngjwngnv vdwv ogolo mooku mvnwng lo vngsik karpv kudw, mooku mvnwng lo vnggola doina mingkar nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip samariya dinchiyachoknv pamtv lo vngla Messiah nga nyi vdwlo japkar jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ogugo Pilip mimpvdw nyipamv vngkam nyala tvvnyato, bunu ninyia tvvgap kaagap nyato okv ninyia lamrwpadubv rinama kaanya toku. ");
INSERT INTO tgj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Achialvbv nyi vdwgvlo alvmanv dow achialvbv kapla linya toku, achialvgo nyi dwgwngnv okv lvpiknv ponya toku. ");
INSERT INTO tgj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Vkvlvgvbv ho pamtv okaku achialvbv mvngpu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nyi ako aminv Saimon vnamgo hoka dooto, hv lvko lvkobv ninyi lama hinam lokv Samaritan nyi vdwa lamrwpadubv mvto. Ho ninyi atubongv kainv akobv minsuto, ");
INSERT INTO tgj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","okv pamtv gv nyi mvnwng ngv ninyia tvvkamkaakam nyato. Bunu minto, “Hv oogv Pwknvyarnv gv jwkrwv, ‘Kainv jwkrw” vla chimbwng kunam go. ");
INSERT INTO tgj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bunu dinchi alvbv ninyia tvvriakariato ogulvgavbolo kvvlo gvngv lokv ninyi bunua ninyigv lama lokv lamrwpadubv mvbwng jito. ");
INSERT INTO tgj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Vbvritola vdwlo bunu Pilip gv doin alvnv yunying Pwknvyarnv gv Karv gv lvkwng lo okv Jisu Kristo gv lvkwng lo tvvla mvngjwng tukudw, bunu mvvga jvka nyiga jvka, baptisma lanya toku. ");
INSERT INTO tgj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon atubongv ka mvngjwng sutoku; okv kochingso baptisma laatoku, hv Pilip gv nvchilo doomin gvvto, okv kaakw manam lamrwpadubv kaatamritam nama kaala kaasartabo bv kaatoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalem lo doonv Apostol vdwv Samaria gv nyi vdwv Pwknvyarnv gv gaama laarwk supvku vla tvvpa toku, vkvlvgabv bunu Pitar nyila Jonnyi bunu gvlo vngmuto. ");
INSERT INTO tgj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Vdwlo bunu vngchi tokudw, bunu mvngjwngnv vdwa Darwknv Dowa paamu dubv vla kumtoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Darwknv Dowv bunu gvlo yvvnyika aatv madvto; bunu Ahtu Jisu gv amin bv baptisma laamwngto. ");
INSERT INTO tgj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Vbvrikunamv Pitar okv Jon bunyi gv laakv bunu gvlo lakpvto, okv bunu Darwknv Dowa paatoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon vdwlo Apostol vdwv mvngjwngnv vdwa bunugv laakv lakpvnam gola darwknv Dow jinama kaapa toku. Vkvlvgabv hv Pitar nyila Jonnyi morko jito, ");
INSERT INTO tgj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","okv minto, “So jwkrw sum ngaka jila bvkv, vkvlvgabv ngoogv yvvnyika laakv lakpv ridw bunu Darwknv Dowa paadubv.” ");
INSERT INTO tgj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Vbvritola Pitar ninyia mirwksito, “No okv noogv morko ngv uyumooku bv vngnyika, no Pwknvyarnv gv amin jinam am morko lokv rvnyure vla mvngnam lvgabv. ");
INSERT INTO tgj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","No ngonu gvlo ribamdakbam dubv rikuma, ogulvgavbolo noogv haapok gv mvngnamv Pwknvyarnv gvlo alvkuma. ");
INSERT INTO tgj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Vbvrikunamv, mvngdinto, svbv noogv alvmanv mvngnama, okv Ahtunyi kumtoka hv noogv svbv mvngmur nama mvngnga jireku. ");
INSERT INTO tgj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ngo kaanamv no achialv bv kabiutari yaya nvgo okv rimur gv patwk lo tumnamgo.” ");
INSERT INTO tgj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon Pitar nyila Jonnyi minto, “Ayala ngo gvbv Ahtunyi kumji labv, nonugv minam vdwsi ngo gvlo rima dubv.” ");
INSERT INTO tgj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bunu bunugv minsvrisv nga mintamro kochingbv bunu Ahtu gv doina minggo jitoku. Pitar okv Jon bunyi Jerusalem bv vngkur toku. Bunugv vngku lamtv lo bunu Alvnv Yunying nga Samaria gv nampum mvnwng lo japgo jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ahtu gv nyidogindung akonv pilipnyi minto, “Gudungto okv yurko yabv Jerusalem lokv Gaja vngjiku lamtv bv vngdubv.” (So lamtv si sinyingsilu vngkuma) ");
INSERT INTO tgj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Vkvlvgabv Pilip vngdu kubv rila okv vngtoku, vjak Itopian alvyachoknv nyigam hijra go Itopia dvnv gv ainmorko nga rigvyanv go, ninyigv naam takbv vnglintoku. Hv Jerusalem lo vngla Pwknvyarnvnyi kumpikula okv ninyigv yikungyira nga bakla ikula naam bv vngkur toku. Hv vbv vngdula, hv nyijwk Aijaya gv kitap nga purito. ");
INSERT INTO tgj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Darwknv Dowv Pilipnyi minto, “Yikungyira bagla vngnv, um vngchitvka okv vkvgv nvchilo vngtoka.” ");
INSERT INTO tgj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilip ninyi gvlo joklwk toku okv ninyia nyijwk Aijaya gv kitap nga puri dubv tvvpato. Ninyia tvvkato, “Noogv purinam um no chinpvre?” ");
INSERT INTO tgj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Oo nyigam angv mvrwksuto, “Nyigonv mimpa mabolo ngo oguaingbv sum chindubv?” Okv hv Pilipnyi gvvchala chaatokv vla gokto okv ninyia yikungyira baknv nga lvkobv dootokv vla. ");
INSERT INTO tgj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ninyigv kitap puri ridungnam angv si: “Hv svlar ako boola ila pakinam aingbv, svlarkuu gv amw peelin jvka sidu manv aingbv, hv oguguka gamchar milinma. ");
INSERT INTO tgj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ninyia nyi mangv aingbv mvto, okv jvjv nga kaajitajinv vv ninyia tvvma jitoku. Yvvka ninyigv husi lvgabv mimpa jila nyumare, ogulvgavbolo ninyigv singdung ngv nyiamooku so singnya dukubv aaduku.” ");
INSERT INTO tgj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nyigam angv Pilipnyi tvvkato, “Nga mimpa labv, nyijwk angv si yvvnyi mindunv? Atubongvre vmalo ako gunyire?” ");
INSERT INTO tgj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Vbvrikunamv Pilip japrap toku; so darwknv kitap lokv puri rirapto, ninyi Jisu gv Alvnv Yunying nga hv mimpa toku. ");
INSERT INTO tgj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bunu lamtv pvkwng bvku irilo, bunu isi meego dooku gulo aatoku, okv nyigam angv minto, “So si isi meego doopv. Nga so baptisma jilabv?” ");
INSERT INTO tgj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipnyi minto, “Noogv haapok gv mvngjwng pvnvlo nam Baptisma jire.” Ninyi mirwkto, “Vv kv,” “Ngo mvngjwng do Jisu Kristo Pwknvyarnv gv Kuunyilo ngv.” ");
INSERT INTO tgj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ho nyigam angv goragari nga daktung moto, okv Pilip la nyigam angv bunyi isi dokubv lvkobv ito, okv Pilip ninyia Baptisma jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Vdwlo bunu isi gvngv agum lintokudw, Ahtu gv Darwknv Dow Pilipnyi lala vngro gvvtoku. Nyigam angv ninyia kaapa kumato vbvritola ninyigv vngtunglo himpu la vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ajotas lo Pilip atubongv kaapa suto; hv kaisaria bv vnglintoku, okv hv lamtv lo vngyingla Alvnv yunying nga banggu mvnwnglo japkar toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sol ho apo gunv nga Ahtu ninyigv mvngjwngnv vdwa rinyingrirula ninyia yalungyachung dula gwngrw talwngbv rila mvritto. Ninyi nyibu butvyachok gvlo vngto, ");
INSERT INTO tgj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","okv Damaskas lo Jius vdwgv kumkunaam lo kaatam nvdubv sitiputa go kooto, ogulvgavbolo ho hoka yvvnyika hv kaapa ridw Ahtu gv lamtvlo vngnv vdwa, hv bunua nyimv jvka nyilo jvka naatung tola okv bunua Jerusalem bv bookar dukubv vla. ");
INSERT INTO tgj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol Damaskas gv pamtv lo aachi svlv nga, dvminmabv nyido gvngv ninyia dooriak loung go ungkato. ");
INSERT INTO tgj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Hv kwdwlo gipvto okv ninyia vlv gamgo mindubv tvvpato, “Sol, Sol! No ogubv nga mvdwkmvku dunv?” ");
INSERT INTO tgj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol tvvkato, “Ahtu, no yvvla?” ho gv vlv ngv minto, “Ngoonv Jisu, noogv mvdwkmvku kunam,” vlv ngv vbv minto. ");
INSERT INTO tgj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Vbvritola gudungto okv pamtv lo vngnyika ho hoka nam mimpare no ogugunyi risvdw.” ");
INSERT INTO tgj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sol gv lvkobv nyi vngbam vdwv daktung nyatoku, gamchar guka milin kuma; bunu gaam go tvvpato vbvritola oguguka kaapama. ");
INSERT INTO tgj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol kvdw gvngv godung toku okv ninyigv nyikv nyiktar toku, vbvritola oguachuk goka kaapama. Vbvrikunamv ninyia bunu laak am gakbwng tukula okv ninyia Damaskas lo vnggv toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Hv alu loum go kaapa kuma, okv ho dw lo hv ogugoka dvkutvngku mato. ");
INSERT INTO tgj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskas lo mvngjwngnv ako doonv gv aminv Ananias. Hv nyikrw kaanamv, ninyia Ahtu minto, “Ananias!” Hv mirwksito, “Ahtu, ngo sika kv.” ");
INSERT INTO tgj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ahtuv ninyia minto, “Gudungto okv lamtv vngchik bv vngdavngra tvka, okv Judas gv naam lo Tarsus lokv nyi Sol vnam amin go um tvvkato. Hv kumdungdo, ");
INSERT INTO tgj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","okv hv nyikrwgo kaato Ananias vnam nyi ako ninyigv laakv ninyia kaapa modu kubv vla hipo dubv yuma maato.” ");
INSERT INTO tgj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias mirwksuto, “Ahtu, so nyi agv lvkwng lo achialvbv nyi vdwv nga minjipvnv okv Jerusalem lo doonv noogv nyi vdwa hv achialvbv alvmabv rinv ngv. ");
INSERT INTO tgj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Okv hv Damaskas lo nyibu butv vdwgv lokv nam kumnvjonv nyi vdwa naatung dubv vla naatung nvnv siti pota lala aapvnv.” ");
INSERT INTO tgj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ahtu ninyia minto, “Vngnyika, ngo ninyia ngo gvbv ridukubv darlin pvkunv, ogulvgavbolo ngoogv amina Jentail vdwlo okv dvbv vdwlo okv Israel nyi vdwlo chinmu dukubv. ");
INSERT INTO tgj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Okv ngo atubongv ninyia ngoogv lvgabv hv vdwgo hirukaya nga hinsvkudw ho mvnwng nga ngo ninyia kaatamre.” ");
INSERT INTO tgj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Vkvlvgabv Ananias vngtoku, Sol ogolo naam lo doopvdw ho aatoku, okv ninyigv laakv ninyia lakpv tola. Hv minto, “Achiboru Sol,” “Ahtu Jisu atubongv nga so aamu pvnv, noogv so aatv ringa lamtv lo noogv kaarwk sunam. Hv nga aamu pvnv ogulvgavbolo nam lvkodv kaapa modu kubv vla okv Darwknv Dowa paamu dukubv vla.” ");
INSERT INTO tgj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Vjakpigobv Sol gv nyik lokv ngui asikarik ainggo olinto, okv hv lvkodv kaapa toku. Hv dakrap toku okv baptisma naatoku; ");
INSERT INTO tgj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Okv kochingso hv dvnam dvnyu laku okv ninyigv gwlwkv aakur toku. Sol mvngjwngnv vdwgv lvkobv alu lonyiloum go Damaskas lo doomin gvvto. ");
INSERT INTO tgj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Hv Jius vdwgv kumkunaamlo vngdavngra la okv ho Jisu Pwknvyarnv gv Kuunyilo ngvkv vla japrap toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ninyigv minama tvvnv mvnwng ngv lamrwpato okv tvvkato, “So nyi angv mai Jerusalem alo hogv nyi Jisunyi kumnvjoonv nga mvkinv? Okv hv vbv so ogugo mvngla aama sudw ho nyi vdwa naatung la okv bunua nyibu butv vdwgvlo bookur lwkdu kubv ridu nvgori?” ");
INSERT INTO tgj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Vbvritola Sol gv japnamv tvvngam yaya toku, okv ninyi Jisu Messiah vla kaatam la mintoku ho Damaskas lo doonv Jius nyi vdwv ninyia yvvka mirwk sinyu matoku. ");
INSERT INTO tgj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Alu mvngchigo vngro kochinglo, Jius vdwv lvkobv kaarwk suto okv Solnyi mvki dubv rungnyato, ");
INSERT INTO tgj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","vbvritola ninyia bunugv rungnam nga mimpa toku. Aluayu bv ninyia mvki dubv vla bunu pamtv gv agilo tooya toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Vbvritola ayu yupgo lo Sol gv rigvvnam vdwv ninyia chikchiya mvko tvla okv otum gulo doomu gvrila lvkwnglo soolu toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalem lo vngto okv lvbwlaksu vdwgvlo ribam dubv rito. Vbvritola bunu ninyia lvbwlaksu gubv mvngjwng mato, okv bunu mvnwng ngv ninyia busuto. ");
INSERT INTO tgj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Vbvrikunamv Barnabas ninyia naarwk sudubv aatoku okv ninyia Apostol vdwgvlo vnggv toku. Hv bunua oguaingbv Sol Ahtu ninyia lamtv lo kaarwk supvdw okv ho Ahtu ninyia oguaingbv raami supvdw mimbwk jitoku. Hv ka bunua mimpa toku Sol gv busukano kumabv Damaskas lo Jisu gv amin bv japgo karku nama. ");
INSERT INTO tgj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Okv vbvrikunamv Sol bunua lvkobv doobam toku okv Jerusalem bv vngyik kartoku, Ahtu amin bv busukano kumabv japto. ");
INSERT INTO tgj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hv ka Grik bv japnv Jius vdwa japmi sila okv haak minsuto, vbvritola bunu ninyia mvki dubv rito. ");
INSERT INTO tgj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Vdwlo mvngjwngnv vdwv um chinpa namgola, bunu Solnyi Kaisaria lo aagvto okv ninyia Tarsus lo vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Okv vkvlgabv ho Judia, Galili, okv Samaria Gvrja lo ho dwa sarsopoyoto. Darwknv Dow gv ridur kolokv hoka gwlwk nyato okv Ahtunyi alvbv mvngjwng nyato, mvngjwng nvngvka kaiyaya toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitar mooku dvdvlo vngsik karto, okv lvko nvnga Lidda lo doonv Pwknvyarnv gv nyi vdwa kaalwkbv hv vngto. ");
INSERT INTO tgj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Hoka Ainias vnam nyi ako ninyia kaarwk suto, hv digwngla doonvgo okv gadw lo gudung nyuku mabv anying pinw go dooku nvgo. ");
INSERT INTO tgj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitarnyi minto, “Ainias,” “Jisu Kristo nam alvdubv mvpure. Gudungto okv noogv gadwa mvdinmvta tokuka.” Vjakpigobv Ainias gudung toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lidda okv Soran lo doonv nyi mvnwng ngv ninyia kaapa toku, okv Ahtunyi bunu mvngjwng nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa hoka ka Tabita vnam nyimv ako dooto, Hv mvngjwng nvgo. (Grik bv ninyigv amina Dorkas gobv minto, minam si “svdum ako”). Ninyigv singnam mvnwng nga alvnvgobv rito okv heemanv vdwa ridurto. ");
INSERT INTO tgj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Oogv dw lo hv lvvmala sitoku. Ninyigv svma nga harkak tokula okv pvvya yagv karchung lo joopv toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda lokv Joppa ngv adu minsu mato, okv vdwlo Joppa lo doonv mvngjwngnv vdwv Pitarnyi Lidda lo doopv vla tvvpa pvkudw, bunu nyi anyigo milwkla vngmu toku, “Ayala ngonu gvlo baapubv aaji labvkv.” ");
INSERT INTO tgj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Vkvlvgabv Pitar gwnggegwngrap tokula okv bunugv lvkobv vngtoku. Vdwlo hv vngchi tokudw, ninyia pvvya yagv karchung lo chaagv toku, hoka hvngmi mvnwng ngv ninyia doyumto, kapdula okv jvkok laklwk, jvtv Dorkas gv turla doori lo chumji nama ninyia kaatamto. ");
INSERT INTO tgj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pitar bunu mvnwng nga karchung agumbv limu tokula, okv guplwk doola kumtoku; vbvrikunamv hv svma takbv dakrwk tola okv minto, “Tabita, gudungto!” hv ninyigv nyikv nyiktar toku, okv vdwlo hv Pitarnyi kaapa tokudw, hv gudung toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pitar nvchilo aanwk tola okv ninyia svvdungto. Vbvrikunamv hv mvngjwngnv vdwa, hvngmi vdwa mintala, goklwk toku okv bunua ninyia turdu kubv kaatam nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Soogv yunying ngv Joppa mooku mvnwng lo dupwng nyato, okv Ahtunyi achialvgo mvngjwng toku. ");
INSERT INTO tgj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pitar Joppa lo apin mvnv Saimon minam nyi ako lvkobv alu meego doomin gvvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisaria lo Kornelias vnam nyi ako dooto, Hv Rom sipai rejiment gv kiapten bv rito, um “Italian rejiment” vla minto. ");
INSERT INTO tgj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hv dormo nyi ako; hv okv ninyigv vpin mvnwng ngv Pwknvyarnvnyi kumnvjoonv go. Hv Jius nyi heema nvnga ka kaadur nvgo okv Pwknvyarnvnyi kumbwng nvgo. ");
INSERT INTO tgj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Alu logo lo arium gv gunta aom rilo hv nyikrwgo kaato, hv pvbwngvrwngbv kaato Pwknvyarnv gv nyidogindung go aala okv ninyia minto, “Kornelias!” ");
INSERT INTO tgj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hv nyidogindung nga busula kaadi chinchi to okv minto, “Tamsarnv, si oguv?” Nyidogindung ngv mirwkto, “Pwknvyarnv noogv kumnam okv jilakrumlak nama alvbv mvngdu, okv nam mirwk sudubv mvngdu. ");
INSERT INTO tgj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Okv vjak Joppa lo nyi meego vngmuto nyi daadwvrw rungnv go vkvgv aminv Saimon Pitar kv. ");
INSERT INTO tgj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hv apin mvnv Saimon vnam, svmasa agum lo naam doonv gvlo nyen bv rila doodu.” ");
INSERT INTO tgj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Vbvrikunamv nyidogindung ngv vnglintoku, okv Kornelias ninyigv naam gv nyira anyigo okv sipai ako, nyi dormo lo doonv ako, hogv akonv vv ninyigv atubogv lokv kaaria tarianvgo to. ");
INSERT INTO tgj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hv ogugo ripvdw bunua mimpa toku okv bunua Joppa lo vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Alu logo nvnga, bunu lamtv bv vngdungto okv Joppa gv nvchilo aari nga, donyitabv nga Pitar kumbv naam namwng aulo chaato. ");
INSERT INTO tgj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hv kano toku okv ogugo dvnwng toku; vdwlo dvnam nga mvdung la ripv nga, hv nyikrwgo kaato. ");
INSERT INTO tgj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Hv nyidomooku gv agiya kokko dubv kaapato okv ogu ako vji jvbor bortvnv aingbv kaanv go atung tungpi nga kvlum tola sichingmooku bv oolu dubv kaapa toku. ");
INSERT INTO tgj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Hoka piakarnv svnwngsvmin nvgwng nvngv dooto, okv mootum pvta ngvka. ");
INSERT INTO tgj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Vlvgo ninyia minto, “Pitar, gudungto; mvkitvla okv dvvto!” ");
INSERT INTO tgj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Vbvrikunamv Pitar mirwksito, “Ahtu, vbv makv! Ngo oguguka darmanv okv darwk manv go dvka mapvnv.” ");
INSERT INTO tgj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ninyia lvkodv vlvgo mindvto, “Pwknvyarnv gv darwk pvnvkv vnama no darwkmanv gubv miyoka.” ");
INSERT INTO tgj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","So si lvom go rito, okv vbvrikunamv um nyidomooku bv naakur chaatoku. ");
INSERT INTO tgj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pitar nyikrw kaanama lamrw palaku si ogugubvri vla mvngla doori lo, ho Kornelias gv vngmunam nyi mvnwng ngv Saimon gv naam am chintoku, okv bunu vdwv vjak agi peelv ho daknyato. ");
INSERT INTO tgj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bunu gokto okv tvvka nyato, “So si Saimon Pitar vnam nyen ako dopvre?” ");
INSERT INTO tgj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pitar vjv gubv ninyigv nyikrw kaanama ogugubvri mvngla chindubv rito, Darwknv Dowv minto, “Tvvriato! soka ka nyi aom go nam makar kardu. ");
INSERT INTO tgj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Vkvlvgabv gudung toku okv pvkwng bv ito, bunua lvkobv vngdubv mvngram mabvkv ngo bunua kanam la vngmu pvnv.” ");
INSERT INTO tgj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Vkvlvgabv Pitar itoku okv nyi vdwa minto, “Nonugv makar nam nyiv ngookv. Nonu ogu mvlwk pvnv?” ");
INSERT INTO tgj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Kiapten nyigam Kornelias ngonuam kanam pvnv,” bunu mirwksito. “Hv alvnv nyi ako Pwknvyarnv ninyia kumnvjonv go okv Jius nyi mvnwng ngv ninyia kaibv mvngdv nyadunv. Pwknvyarnv gv nyidogindung ako ninyia minto ninyigv naam lo nam goktokv vla, vkvlvgabv noogv minama ninyia tvvmu dubv.” ");
INSERT INTO tgj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pitar nyi vdwa arwngbv goklwkto okv bunua ho ayu miyayala yupmuto. Logo nvngaku hv gwngrapsingrap tokula okv bunugv lvkobv vngtoku; okv mvngjwngnv meego Joppa lokvka ninyia lvkobv vngming gvvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Alu logo nvngaku hv Kaisaria lo vngchi toku, okaku ogolo Kornelias ninyia kaaria la, ninyigv agungaram vdwa lvkobv doobam la dooto kudw okv ajin vdwa ninyigv goknam dvdv nga lvkobv doobam toku. ");
INSERT INTO tgj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pitar arwngbv aatv ringa, Kornelias ninyia kaarwk sito, okv ninyigv lvpalo gupba la okv ninyigv kaagia guplwkto. ");
INSERT INTO tgj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Vbvritola Pitar ninyia svdungto. Hv minto; “Dakrapto, Ngooka nyi ngvmabv.” ");
INSERT INTO tgj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pitar Korneliasnyi gaam japmi sila hv naam arwng bv aatoku, ninyia hoka nyi achialvgo dopam dubv kaapato. ");
INSERT INTO tgj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Hv bunua minto, “Nonu atubongv alvbv chinsu pvnvpv ho Jentail vdwa lvkobv kaarwk okv ribam mabvkv vla Jius bunugv ridungsingdung lo mindu. Vbvritola Pwknvyarnv nga kaatamdo ho yvvnyiv darwkmanv jeka okv kasingkanyak jeka ngo alvmakv vla mare. ");
INSERT INTO tgj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Okv vkvlvgabv no vdwlo nyi kanamla ngo gvlo vngmuto, ngo oguguka ma vla mvngnam kamabv aapvnv. Ngo nam tvvkadu, vbvrikunamv, no ngo gvlo ogubv nyi kanam la vngmu pvnv?” ");
INSERT INTO tgj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelias minto, “Soogv dw so vjak alu loum go vngro pvkua ho ngo atugv naam soka arium gv gunta aom baji lo kumdungla doosuto. Dvminmabv nyi go vji yapung tojinv gvvtola ngoogv habolo dakto ");
INSERT INTO tgj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","okv minto: ‘Kornelias! Pwknvyarnv noogv kumnam am tvvpato okv noogv nyi am jinamrungnama kaapa duku. ");
INSERT INTO tgj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nyi go Joppa lo vngmuto ho ninyigv lvgabv aminv Saimon Pitar vnamgo. Hv Saimon apin mvnv, svmasa adarlo doonv gv naam lo nyen bv doopv.’ ");
INSERT INTO tgj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Okv vkvlvgabv ngo vjakpigobv noogv lvgabv vngmu pvnvkv, okv no so alvrungbv aalwk jipv. Vjv ngonu mvnwng ngv Pwknvyarnv gv dooku si doodu, Ahtu ogugo ritokv vla nam mimpv kudw um minama tvvbv doyala doodunv.” ");
INSERT INTO tgj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pitar japrap toku: “Vjv ngo mvngdw kunamv so si jvjv ngv Pwknvyarnv nyi mvnwng nga akin gubv mvngla ridunv. ");
INSERT INTO tgj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yvvdw ninyia kumnvjoonv ngv okv alvbv ridu singdunv vv ninyia turwk sunam gubv ridunv, hv ogolokv ogunv nyi haalung gubv rijeka. ");
INSERT INTO tgj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nonu chindu hv doina Israel nyi vdwlo jilwk kunama, mvnwng gv Ahtu Jisu Kristo gv Alvnv yunying nga japji kunama. ");
INSERT INTO tgj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nonu chinyado Israel gv kvvdw mvnwng so kaibv dunamlamnam go rikunama, Galili lo riraptoku Jon gv baptisma gv lvgabv japjiro koching bv. ");
INSERT INTO tgj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nonu Najaret gv Jisunyi chinyado okv Pwknvyarnv ninyia oguaingbv Darwknv Dowv okv jwkrw nga jiku nama. Hv mooku mvnwng lo vngyik kartoku, alvnv rikarto okv Uyuvram gv arwnglo doonv mvnwng aka mvpu karto, ogulvgavbolo Pwknvyarnv ninyia lvkobv dooming gvvto. ");
INSERT INTO tgj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Hv ogugo Israel gv kvvdw lo okv Jerusalem so ripvkudw ngonu mvnwng ngv ho mvnwng nga tvvriakaaria kunama japyariya yajikunv. Vbvrikunamv bunu ninyia daapo lo kali lokv sidukubv takki toku. ");
INSERT INTO tgj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Vbvritola Pwknvyarnv ninyia alu loum koching lo sikunvnga turkur motoku okv ninyia kaapa modubv mvtoku, ");
INSERT INTO tgj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","nyi mvnwng nga kaatam ma, vbvritola Pwknvyarnv gv darlin pvvnam kaarianv mvngchik amwng, hv sipikula turkurro koching bv ninyigv lvkobv ngonu ninyia lvkobv dvbamtvngbam kunam ngv. ");
INSERT INTO tgj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Okv hv ngonua yunying ngam nyi vdwlo japkar dubv kanamto okv Pwknvyarnv gv darlin kunam angv turnv okv sikunv vdwgv jwngyadaya yanv gubv. ");
INSERT INTO tgj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nyijwk mvnwng ngv ninyigv lvkwng lo japto, vbv minjito yvvdw ninyia mvngjwng dunv vv ninyigv amin jwkrw lokv vkv rimur am mvngnga jiriku.” ");
INSERT INTO tgj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Vdwlo Pitar gv japdung rilo, Darwknv Dowv ilwkjito mvnwng gvlo yvv ninyigv doina tvvla doonv vdwa. ");
INSERT INTO tgj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Joppa lokv Pitarnyi lvkobv aanv Jius nyi mvngjwngnv vdwv Pwknvyarnv gv Jentail vdwaka Darwknv Dowa jilwk nama kaapatola lamrw pakunam. ");
INSERT INTO tgj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ogulvgavbolo bunu bunua akusubv japdubv okv Pwknvyarnv gv kainama hartv dubv tvvnyato. Pitar japrapto: ");
INSERT INTO tgj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“So nyi vdwsi Darwknv Dowa paapvku, ngonu gvka paakunam aingbv. Vbvrikunamv, nyigonv, bunua isi lo baptisma nama dubv mintor nyuji kunv?” ");
INSERT INTO tgj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Vkvlvgabv hv bunua Jisu Kristo gv amin bv baptisma naadubv mintoku. Vbvrikunamv bunu ninyia bunugv lvkobv alu lonyiloum go doomin gvdubv kooto. ");
INSERT INTO tgj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostol vdwv okv Judia mvnwng lokv kvvbi mvngjwngnv vdwv tvvpa nyatoku Jentail vdwvka Pwknvyarnv gv gamchar am laarwk suta pvku vla. ");
INSERT INTO tgj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Vdwlo Pitar Jerusalem lo vngto kudw, yvvbunudw Jentail vdwa ayakmvua mvnglwknv vdwv Pitarnyi minjimio la minto, ");
INSERT INTO tgj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“No Jentail ayakmvu manv nyi vdwgv naam lo nyen gubv ripvi, okv no bunua lvkobv dvbamtvngbamdu ai!” ");
INSERT INTO tgj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Vkvlvgabv Pitar bunua atuk lokv oguaingbv rirap pvkudw ho mvnwng nga mimpa jitoku: ");
INSERT INTO tgj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Vdwlo ngo Joppa gv pamtv lo kumla doori lo, Ngo nyikrwgo kaato. Nyidomooku tvlokv vji jvbor aingbv kaanv go atung tungpi am kvlum tola ogugo solu dubv ngo kaapato, okv ho vv ngo takbv olwkto. ");
INSERT INTO tgj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ngo arwngbv kaatar lwkla kaakunamv soonam okv somanam svnwngsvmin, piakarnvngv, mootum pvta vkv kaapato. ");
INSERT INTO tgj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Vbvrikunamv ngo vlvgo nga mindubv tvvpato, ‘Gudungto, Pitar; mvkitvla okv dvto!’ ");
INSERT INTO tgj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Vbvritola ngo minto, ‘Ahtu, vbv makv! yaboryachenv vmalo dvnam kasingkanyak nvngv ngoogv gaam lo vdwloka aakw mapvnv.’ ");
INSERT INTO tgj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nyidomooku tvlokv vlvgo lvkodv minto, ‘Pwknvyarnv gv darwk pvnvkv vnama ogu darwkmanv gubv mvngma bvka.’ ");
INSERT INTO tgj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","So si lvom gubv rijito, okv anyunganya nga ogumvnwng nga nyidomooku bv chaakur gvvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Vbvrida sopikda nyi aom vv Kaisaria lokv ngo gvlo vngmunam vdwv ngo ogolo doopvdw oogv naam hoka vngchi toku. ");
INSERT INTO tgj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Darwknv Dowv nga bunua lvkobv vnglaka mvngram mabvkv vla minto. Oogv mvngjwngnv nyi akvgo nga lvkobv Joppa gvngv Kaisaria lo vngming gvvto, okv ngonu mvnwng ngv Kornelias gv naam arwnglo aatoku. ");
INSERT INTO tgj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ninyi ngonua minjito ninyia oguaingbv nyidogindung angv ninyigv naam arwng lo dakdubv kaanama, ho ninyi minto, ‘Nyi go Saimon Pitarnyi hardubv Joppa bv vngmu tvka. ");
INSERT INTO tgj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hv nonua gaam japjire ho no okv noogv vpin mvnwng ngv ringnam am paariku.’ ");
INSERT INTO tgj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Okv vdwlo ngo japrap kunamv, Darwknv Dowv bunu gvlo ilwk toku atuk lo ngonu gvlo aanam jvbvku. ");
INSERT INTO tgj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Vbvrikunamv ngo mvngpa toku ogugonyi Ahtu minpvdw: ‘Jon isi bv baptisma jidu, vbvritola nonuam Darwknv Dow lvkobv baptisma jire.’ ");
INSERT INTO tgj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Si pvbwngvrwng dukunv vv Pwknvyarnv Jentail vdwa ngonua jwkrw jinam apiabv jipv vdwlo ngonu Ahtu Jisu Kristonyi mvngjwng tokudw; vbvrikunamv ngo yvvla, Pwknvyarnvnyi mvtor dubv ridunv!” ");
INSERT INTO tgj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Vdwlo bunu sum tvvto kudw, bunu miriminu kuma okv Pwknvyarnvnyi ombonyikv, vnya toku, “Vbvrikunamv Pwknvyarnv Jentail vdwaka mvngdin modukubv jito okv singmurimu dukubv alvnv alua lomu toku!” ");
INSERT INTO tgj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stipinnyi vlwng orki rilo Jisunyi mvngjwngnv vdwa mvdwmvkunam lvgabv bunu mooku mookulo kiakkipak toku. Kvvgonv Jius mvngchik ka doina japjito Poenesia lobv, Saipras okv Antiok lobv vngto. ");
INSERT INTO tgj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Vbvritola mvngjwngnv kvvbi vdwv, Saipras okv Sairene lokv nyiga vdwv, Antiok bv vngto okv doina Jentail vdwlo japji toku, Ahtu Jisu gv Alvnv Yunying nga bunua ka minji toku. ");
INSERT INTO tgj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ahtu gv jwkrwv bunugv lvkobv dooto, okv nyi vdwv kaiyabv mvngjwng la twngtvya toku okv Ahtu gvlo aakur nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","So yunying ngv Jerusalem Gvrja lo vngchi toku, vkvlvgabv bunu Barnabasnyi Antiok bv vngmuto. ");
INSERT INTO tgj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Vdwlo hv vngchi tokudw okv ninyia Pwknvyarnv gv nyi vdwa vdwgo boktalwkji kunama kaapa toku, hv mvngpu toku okv nyi vdwa ninyi tamsarto Ahtunyi haapok mvnwng lokv jvjvbv okv mvnglwkkaalwk bv rilaka vla minto. ");
INSERT INTO tgj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas alvnv nyi go, Darwknv Dow gvnv go okv mvngjwng nvgo, okv nyi meego Ahtu gvlo aagv jito. ");
INSERT INTO tgj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Vbvrikunamv Barnabas Solnyi kaakar bv Tarsus lo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Vdwlo hv ninyia kaapa kunamv, hv ninyia Antiok bv vnggv toku, okv anying nyinggo bv bunyi lvkobv Gvrja gv nyi vdwa kaarwk sito okv nyitwngtwngtv nvgo tamsar toku. Mvngjwngnv vdwa Kristan vla mintuminke bv minrap kongv Antiok lo. ");
INSERT INTO tgj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Vbv riri hoka nyijwk meego Jerusalem lokv Antiok lo vnglwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bunugv lokv akonvgv aminv Agabas, Darwknv Dow gv jwkrw lokv dakrap danv kokwnglo riji nama mincho jila vbv minto achialvbv alvmanv dvmayarwng go sichingmooku so vngtv tvvdu vla minto. (Klaudius gv Dvbv bv ririlo vv aatoku.) ");
INSERT INTO tgj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Lvbwlaksu vdwv Judia lokv mvngjwngnv ajin vdwa vdwgo rila pvdw ridur dubv vla japmi sinyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bunu sum ritoku, vbvrikunamv morko nga Barnabas okv Sol bunyigv laak lo jilwk la Gvrja gv nyigagatv vdwlo jidukubv. ");
INSERT INTO tgj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","So lvkwng lo vbv ririlo hoka Dvbv Herod gvrja nyi meegonyi mvdwkmvku rapto. ");
INSERT INTO tgj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Hv Jemsnyi, Jon gv boru am rioksv lokv pakitoku. ");
INSERT INTO tgj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Vdwlo hv vbvrinam si Jius vdwa alvbv mvngpu modu vla kaapa pvkudw hv Pitar nyika naatungto. (Svbv rikuv vpap lwkmabv vtwng dvdw pumja alu lo). ");
INSERT INTO tgj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pitarnyi naatungro koching bv patwk lo tumlwk toku, hoka ninyia sipai nyitwng api lokv akinakin sakbv naalinla ninyia apigo dagv yamuto. Herodnyi vngbo dvmin gv kochinglo kvba vdwgv kaakulo mvtungmvre dubv vla rungto. ");
INSERT INTO tgj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Vkvlvgabv Pitarnyi patwk lo tumlwk pvto, vbvritola gvrja lo nyi vdwv ninyigvbv Pwknvyarnvnyi dinchi rungbv kumji nyato. ");
INSERT INTO tgj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pitarnyi ho ayu Herod gv nyi vdwgvlo boolin madv bv, Pitar dakrianv anyi gv pingkolo yupla dooto. Ninyia jaako sonyi gonv leepvto, okv okaku dakrianv vdwv patwk agi lo dakria nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dvminmabv Ahtu gv nyidogindung ako hoka daktoku, okv patwk arwnglo loung go unglinto. Pitar gv Gorbwng lo nyidogindung lakpvnamv lamrwpato, ninyia mvu toku, okv minto, “Gudungto! baapubvkv!” Pitar gv laak lokv vjakpigobv rvngja ngv taasokto. ");
INSERT INTO tgj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Vbvrikunamv nyidogindung ngv minto, “Noogv tainhokpo nga hukto kuka okv noogv lvkiama gvvto.” Pitar vbv ritoku, okv nyidogindung ngv minto, “Noogv pakria nga koorwkto okv nga lvkobv aato.” ");
INSERT INTO tgj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pitar oguka chimabv, patwk arwng lokv agum bv, ninyia vngming gvvtoku, ogubv rikujvka, vbv nyidogindung gv rinam yangv jvjv guya; vla hv mvngtoku ninyi nyikrwgo kaapv nvgobvri vla. ");
INSERT INTO tgj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bunu dakria la dakcho konga vngboto okv anyi nvngaka, okv vngnyung nga pamtv bv vngjiku riokdar agi lo aatoku. Agiv bunugv lvgabv kokda sila dooto, okv bunu agum bv vnglintoku. Bunu pamtv gv ara bv ilwkla vngto, okv nyidogindung ngv Vjakgobv Pitarnyi vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Vbvrikunamv Pitar ninyigv ogugo ripvdw mvngdw tola, okv minto, “Ngo svjv chimpvku so si jvjv gurung! Ahtu ninyigv nyidogindung nga kanam tola nga Herod gv jwkrw lokv okv Jius nyi vdwgv vbvrijeyiku nvpv vla mvngmin nam mvnwng loka ringlin pvku.” ");
INSERT INTO tgj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ninyigv svbv riyi so himakaya sudubv, hv Jon mark gv anv Meri gv naam lo vngtoku, hoka nyi vdwv achialv dookum la okv kumla doonyato. ");
INSERT INTO tgj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pitar hoka agi am takdinto, okv nyimvpaknv aminv Roda vnam ako um mirwk sudubv aatoku. ");
INSERT INTO tgj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hv Pitar gv gaama tvvchinto okv himpu yalaku agiya koko mabv ninyi arwngbv jukkur lwktoku, okv Pitar agum vv dakpv vla arwnglo gokyak pato. ");
INSERT INTO tgj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bunu ninyia minto, “No suru pvnvgo!” Vbvritola hv si jvjv ngvkv vla mimbwng jito. Vkvlvgabv bunu mirwksito, “So si ninyigv nyidogindung go.” ");
INSERT INTO tgj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Vbv ridung rilo Pitar takdin dvla doodvto. Anyungnga bunu agiya kokko jitoku, okv vdwlo bunu ninyia kaapa namgola, bunu lamnya toku. ");
INSERT INTO tgj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pitar ninyigv laakv lakbvla bunua choibvkv vla mintoku, okv hv bunua oguaingbv Ahtu ninyia patwk lokv linggv kunam am mimbwk la mimpa jitoku. “Sum Jems okv mvngjwngnv dvdvlo mimpa laka,” hv minto; vbvrikunamv ninyia vngyu toku okv mooku kvvbilo vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Vdwlo arukamchi kubvdw, hoka dakria kaarianv vdwgv pingkolo abwk kuma bv ritoku—Pitarnyi ogugo ripv nvgobvri? ");
INSERT INTO tgj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod Pitarnyi makar dubv orto jito, vbvritola bunu ninyia mapa kuma toku. Vkvlvgabv hv dakriakarianv vdwa tvukapak tokula okv bunua mvki dvkubv orto jitoku. So kochingbv, Herod Judia nga vngyula okv Kaisaria lo apogo dootoku. ");
INSERT INTO tgj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod Tayar okv Sidon gv nyi vdwa achialv bv haachi toku, vkvlvgabv bunu lvkin gubv ritola ninyia kaatv bv vngtoku. Atuk chochok bv dvbvkarv nga doogvdakgv yanv nyi, Blastasnyi bunu mindin chootoku, bunua ninyia kaadur kodubv vla. Vbvrikunamv bunu Herod gv dokubv vngto okv sarsopoyonam lvgabv ninyia tvvkato, ogulvgavbolo bunugv mooku ngv ambinamor am dvbv gv diringmooku lokv jilwk doonv. ");
INSERT INTO tgj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Darlinnam alu gulo Herod ninyigv Dvbv vji jvtv laklwk ka gvvto, ninyigv dvbvdotung kolo doolwk toku okv nyi vdwa kvba gaam go japto. ");
INSERT INTO tgj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bunu gokla minto, “So si nyi gv japnam bv rima, vbvritola Pwknvyarnv gv japnam bv rido!.” ");
INSERT INTO tgj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Vjakgobv Ahtu gv nyidogindung ngv Herodnyi svtap pala seluto, ogulvgavbolo hv Pwknvyarnvnyi mvngdv jimato. Ninyia tapumv chetoku okv sitoku. ");
INSERT INTO tgj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Vbvriro kochingbv Pwknvyarnv gv gaamv tvvsik yaya toku okv kaiyayabv ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas okv Sol bunyi gv minkarrikar svnga rinya toku, okv bunyi Jerusalem lokv aakur laku, Jon Mark ninyia naalaila bunyi gv lvkobv vnggv toku. ");
INSERT INTO tgj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok gv gvrja hoka ka nyijwk vdwv okv tamsarnv vdwv meego doonyato: Barnabas, Saimeon (Yakianv vla minto), Lusias (Sairene lokv), Manaen (Herod gobunor gv lvkobv sochakunam), okv Sol. ");
INSERT INTO tgj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bunu Ahtu gv kanam nama rilapala okv dvmatvngma bv yikdungla doori lo, bunua Darwknv Dowv minto, “Ngo gvbv Barnabas la Sol bunyia akusubv vngmuto, ngoogv gokla kanam nama bunua rimudubv.” ");
INSERT INTO tgj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bunu dvmatvngma bv yikdungto okv kumtoku, bunugv laakv bunua lakpv tola okv bunua vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Darwknv Dow gv kanam la vngmukunam lokv, Barnabas okv Sol Seleukia lo vngtoku okv svpwbv dula Saipras bokpin lo vnglwkto. ");
INSERT INTO tgj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Vdwlo bunu Salamis hoka vngchi kunamv, bunu Pwknvyarnv gv doina Jius kumkunaamlo japji toku. Bunu Jon Marknyi bunugv riku lo rigvto ridur riadubv. ");
INSERT INTO tgj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bunu bokpin mvnwng nga vngbola Papos lo vnglwkto, hoka bunu tagohinv ako aminv Bar-Jisu, vnamgo paami sito, hv Jius nyi go nyijwk akobv minsunv. ");
INSERT INTO tgj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hv bokpin gv gobunor gv ajin bv rito, Sergius Paulusnyi chinvpanv gubv rito. Gobunor angv Barnabas nyila Solnyi vkvgvlo gokcho lwkto ogulvgavbolo ninyia Pwknvyarnv gv doina tvvnwngto. ");
INSERT INTO tgj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Vbvritola tagohinv Elimas (ho vv Grik amin minam) bunu mvnwng am kaanwng mabv rito rinyingriruto, ninyi Gobunornyi mvngjwng moma dubv rikwto. ");
INSERT INTO tgj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Vbvrikunamv Sol— nyika Paul vla chinya kunam—Darwknv Dowv aakunamv; hv tagohinv nga kaagap chinchila kaato ");
INSERT INTO tgj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","okv minto, “No uyu gv kuunyilo! No alvnv ogumvnwng gv nyirunyimak kv. No alvmabv gwngnamrungnam am gvnv okv no Ahtu gv jvjv nga mvvnam gubv rimu dubv lokia rikwnv! ");
INSERT INTO tgj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ahtu gv laakv no gvlo vjak laklure; no nyikching riku okv alu gv loung nga meego kaapa mabv ririku.” Vjakgobv Elimas gv nyiklo kanv ngv jing mvlwkto, okv ninyi vngdubv vngtvto nyigonv ninyigv laak am gakbwng tvla vnggv labv vla riakarto. ");
INSERT INTO tgj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Vdwlo gobunor angv um kaapv kudw hv mvngjwng toku; Ahtu gv lvgabv tamsarnama tvvla hv kairungbv lamngapatoku. ");
INSERT INTO tgj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul okv ninyigv ajin mvnwng ngv Papos lokv Pampilia pamtv bv Parga lo svpw bv raplwk toku, hoka Jon Mark bunua kayupikula Jerusalem bv vngkur toku. ");
INSERT INTO tgj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bunu Parga lokv vngraptoku okv Pisidia gv Antiok lo vngchi toku, okv bunu Jius doonu alulo kumkunaam arwng aalaku okv dootung nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses gv Pvbv nga okv nyijwk vdwgv lvkpv nama um puri riro kochingso, Jius kumkunaam gv nyigam vdwv bunua gaam go milwkto: “Ajin vdwv, nonu nyi vdwa doin tamsarkinu gaam go doodu bolo mintokv vla ngonu mvngdu.” ");
INSERT INTO tgj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul dakrab dvla, ninyigv laakv ijodvla, okv minrap toku: “Israel ajin vdwa okv soka Jentail vdwa yvv Pwknvyarnvnyi kumdunv: nga tvvriato! ");
INSERT INTO tgj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel nyi vdwgv Pwknvyarnv ngonugv abuapa vdwa dartoku okv nyi vdwa kainv mooku gubv mvtoku Ijipt lo bunugv nyen pakbubv rila doori lo. Pwknvyarnv gv kainv jwkrw lokv bunua Ijipt loka agum naalin toku, ");
INSERT INTO tgj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","okv anying champi gubv bunua chokrimookulo Hv saktv toku. ");
INSERT INTO tgj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pwknvyarnv Kanaan gwngda lo diringmooku kanwgo mvyakmvchak tvla okv ninyigv nyi vdwa mookuatu bv mvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","So mvnwng si anying lvngpi gula chamngu gobv ritoku. “Soogv kochingso ninyi bunua nyi kiyahakya nvgobv jitoku Samuel nyijwk gv dootv madvbv. ");
INSERT INTO tgj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Okv vdwlo bunu dvbv lo ako jibvkv vla koonamv, Pwknvyarnv bunua Binjamin haalung lokv Kis gv kuunyilo Solnyi, bunugv dvbv bv anying champi gubv singmuto. ");
INSERT INTO tgj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kochingso ninyia rimu kuma namv, Pwknvyarnv Dabidnyi bunugv dvbv bv mvtoku. So si ogugonyi Pwknvyarnv ninyia minamv: ‘Ngo paapvku Jesse gv kuunyilo Dabid ngoogv haang lo mvnglwknam nyi gobv rido, ngo ogugo mvngpvdw ninyia um mvnwng nga riji nvgobv riyinvpv.’ ");
INSERT INTO tgj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","O Jisu, Dabid gv husi lokv, yvvnyi Pwknvyarnv Israel nyi vdwgv ringlinnv gubv, ninyia mvtoku ninyigv milvla mimpv nam lokv. ");
INSERT INTO tgj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisu ninyigv ridung nga ritam madvbv, Jon Israel gv nyi mvnwng nga japkar choto ho nonugv rimur lokv nonu lintokv okv baptisma laato kukv vla. ");
INSERT INTO tgj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Okv Jon ninyigv risvvngsv nga rinya svlv bv rire hoka, hv nyi vdwa minto, ‘Nonuno nga yvv vla mvngdu? Nonugv kaaria la doonam angv vv makv. Vbvritola tvvriato! Hv ngoogv koching lo aadungdu, okv ngo vbv alvka yama ninyigv lvkiam ngaka ninyigv lvchu loka pilin dubvka rinyuma.’ ");
INSERT INTO tgj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Israel gv ngoogv ajin vdw, Abraham gv husi vdwa, okv soka Jentail mvnwng ngv yvv Pwknvyarnvnyi kumdudw: soogv turnam gv doin sum ngonugv lvgabv jilwk jipvnv! ");
INSERT INTO tgj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem lo doonv nyi vdwv okv bunua rigvnv vdwvka ho Jisunyi ringnvbaanv ngvkv vla chimato, Doonu alu lokia nyijwk vdwgv gaam ngaka puri rilin jinam aka chinv kaama. Vjvlodvbv Jisunyi miyakaya tola bunu nyijwk vdwgv gaam yanga jvjvbv limuyato. ");
INSERT INTO tgj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Okv bunu ninyia mvki dubv gaam mimbwk svgo dooma jvka, bunu Pilatnyi ninyia mvkito vla kooto. ");
INSERT INTO tgj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Okv kochingso bunu ogumvnwng nga ritoku ho Darwknv kitap lo ninyigv lvkwng lo minam nga, bunu ninyia daapo gvnga jolu toku okv ninyia nyibung arwngbv lwktoku. ");
INSERT INTO tgj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Vbvritola Pwknvyarnv ninyia sikunvnga turkur motoku, ");
INSERT INTO tgj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","okv alu aw gobv yvvbunu ninyigv lvkobv Galili lokv Jerusalem bv vngming gvnv nga kaapa kotoku. Bunu mvnwng ngv sijv Israel nyi vdwgvbv ninyigv lvgabv ririamiria nvgu bv rinya dukunv. ");
INSERT INTO tgj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Okv ngonu mvnwng ngv sika nonu gvbv alvnv yunying nga bvnglwk jitv dunv: Pwknvyarnv ogugo ngonugv abuapa vdwa minpvnam nga hv ritv hinvkv, hv vjakka ngonu gvbvka um rilin jipvku, yvvbunudw bunugv husi bv ripvkudw, Jisunyi sikunvnga singdu kubv mvto kula. Mirimimpak lo baanyi nvnv lo minam jvbv, ‘No ngoogv kuunyilo; silu ngo noogv Abu bv riduku.’ ");
INSERT INTO tgj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Okv so si Pwknvyarnv ninyia sinam lokv turkur mooku nambv minto, vdwloka nyibung arwng lo yalwk mabvka: ‘Ngo nonuam Dabidnyi milvnam darwknv okv jvjvrungbv boktalwkjire.’ ");
INSERT INTO tgj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Svbvka hv borgu nvlo mindu, ‘No noogv jwkjwkvrwk rungnv pakbu nga nyibung arwnglo yaamin momare.’ ");
INSERT INTO tgj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dabid Pwknvyarnv gv mvngnama ninyigv ridwlo ritoku, okv vbvrikunamv hv sitoku, abuapa vdwgv lvkobv sima ritoku, okv ninyigv ayakv nyibunglo yaalwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Vbvritola Pwknvyarnv gv sikunvnga turkur mookunam angv gvlo so si riku mato. ");
INSERT INTO tgj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ngonu nonua chinmu nvpv mvngdu ngoogv Israel ajin vdwa, Jisu gv lokv rimur vdwa mvngnga jikunam gv doina nonua japji toku; Moses gv Pvbv jinam lokv nonua rimur loka topunyuma nama topu jiriku yvvdw ninyia mvngjwng dukunv. ");
INSERT INTO tgj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Vbvrikunamv, hima sulakv ogulvgavbolo nyijwk vdwgv minamv nonu gvlo rilwk madubv: ");
INSERT INTO tgj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kaatoka, nonu nyarjikaunv vdwv! Lamrwpalaka okv silakuka! Ngo silu ogugo ridung dunv si vkvnv ogugo nonu mvngjwng mare, vdwlo nyigonv nonua alvbv mintam jida jvka!’” ");
INSERT INTO tgj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul la okv Barnabas bunyi Jius kumkunaam lokv lindung rilo, nyi vdwv bunua lvko aakur dvla aainvgv bunugv Doonu alu lo okv bunua soogv lvgabv sum kaiyabv minjilabv vla mintoku. ");
INSERT INTO tgj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kochingso nyi vdwgv kvbadopam lokv vngpinvngyin rikulo, Paul la Barnabas bunyi gv kochingbv Jius okv Jentail Judaism lo aalwkla rikunv vdw vkv achialv bv vngming gvvto. Apostol vdwv bunua japtoku okv Pwknvyarnv gv anyuaya lo alvbv doobwng runglaka vla mintvmiru toku. ");
INSERT INTO tgj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bunugv Doonu alu akonvnga banggu gv nyichar mvnwng ngv Ahtu gv gaam nga tvvbv aakum nyato. ");
INSERT INTO tgj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Vdwlo Jius vdwv nyipam am kaapv kudw, bunu mvnwng ngv kaakbriak nyato; Paul gv japnama bunu ridwkrikuto okv ninyia nyarjitari toku. ");
INSERT INTO tgj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Vbvritola Paul la Barnabas bunyi busukano kaakumabv japrapto: “Pwknvyarnv gv gaama ho nonu gvlo japcho jidubv ripvkv. Vbvritola nonu um toasula okv turbwngnv singnama paanyu manv gubv mvngsu dvnv bolo ngonu nonua kayupikula Jentail nyi vdwlo vngriku. ");
INSERT INTO tgj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","So si Ahtu ngonua gamki pvjinamv: ‘Ngo nonua Jentail vdwgv lvgabv loung gubv mvpvnv, ogulvgavbolo nyiamooku gv nyi vdwv turnama paadu kubv.’” ");
INSERT INTO tgj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Vdwlo Jentail vdwv sum tvvpa kunam gula, bunu mvnwng ngv himpu pulaku okv Ahtu gv doina umbonyikv mvngtoku; okv yvvbunu ninyia turbwngnv singnam lo darlin pvkudw bunu mvngjwng nvgobv ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ahtu gv gaamv ho mooku mvnwng lo dupwng kartoku. ");
INSERT INTO tgj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Vbvritola Jius vdwv pamtv gv Jius nyiga vdwa mivrmimbam la jokkumrikum motoku okv Jentail anvnyimv kaibv rigvnv vdwv yvv Pwknvyarnvnyi kumnvjonv vdwv. Bunu Paul okv Barnabas bunyia yalungyachung durab toku okv bunugv mooku loka bunua charlin toku. ");
INSERT INTO tgj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Apostol vdwv bunua rinyingriru dunv vla bunugv lvchu gv pvmar am mvkak supi kula bunu Ikonium mooku bv vnglintoku. ");
INSERT INTO tgj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antiok lo doonyabu mvngjwngnv mvnwng lo Darwknv Dow lokv okv achialvbv himpu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikonium loka vbvdvdv bv rito: Paul la Barnabas bunyiv Jius vdwgv kumkunaamlo vngto okv vbv japlaku Jius vla Jentail nyi vdwa achialvgo mvngjwng nvgobv rimutoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Vbvritola Jius mvngjwng manv nyi vdwv Jentail nyi vdwa meerla okv mvngjwngnv vdwa rinyingriru moto. ");
INSERT INTO tgj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Apostol vdwv hoka alu achialv gubv dootoku, Ahtu gv lvgabv busukano mabv japtoku, bunugv ninyigv anyuaya namgv doinv jvjv rungdo vla kaamu dubv bunu jwkrw lokv achialvgo kaasartabo okv lamrwpadubv rila kaatamto. ");
INSERT INTO tgj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pamtv gv nyi vdwv apinain sitoku: meegonv Jius vdwgvbv, kvvgonv Apostol vdw gvbvku. ");
INSERT INTO tgj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Vbvrikunamv Jentail nyi meego okv Jius vdwv bunugv rigvnv vdwa lvkobv, Apostol vdwa vlwng orla alvmabv ridubv minbam sitoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Vdwlo Apostol vdwv um tvvpa namgola, bunu Listra okv Darbe okv dokardovr mooku Likaonia pamtv vdwlo kelwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Hoka bunu Alvnv Yunying nga japtoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra lo nyi ako dooto vv bvnglin lokv lvpikto okv vdwloka vngkar nyumabv rito. ");
INSERT INTO tgj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hv hoka doya tola okv Paul gv gaama tvvriato. Paul kaatoku hvkvgv mvngjwng kunam am okv poya nyola suku nama, vkvlvgabv hv ninyia kaagap lalatoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Okv gaam gamtv bv goktoku, “Noogv lvdubv dakdin chinchila daktokv!” Nyi angv pokdinpokrinla okv vngchar vngyarla vngrab toku. ");
INSERT INTO tgj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Vdwlo nyi nyipam vv Paul ogugo ripvkudw um kaato kula, bunu atugv Likaonia gaam bv bunu gokrap toku, “Pwknvyarnv ngv nyi jvbv ritokula okv ngonu gvlo ipvku!” ");
INSERT INTO tgj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bunu Barnabasnyi Jeus gobv amin minto okv Paulnyi Harmes gobv minya toku, ogulvgavbolo hv japlaknv kaiyachok kunv go. ");
INSERT INTO tgj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jeus Pwknvyarnv gv nyibu go pwknvyarnvnaamv banggu agum gv adar hoka dooto, ninyila nyipam vdwv svv vvpu okv apungana vkv agi hoka bvnglwkto Apostol vdwa erinpeeji dubv vla mvngnyato. ");
INSERT INTO tgj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bunugv ritv nama Barnabas okv Paul bunyiv tvvpa namgola, bunyi vji am putak pasuto okv nyitwng pingko gv arwng lo juklwkla, gokto, ");
INSERT INTO tgj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nonuno ogubv svbv rinya dunv? Ngonu atubongv ka nonuno aingbv nyi vmwng mabv! Ngonu mvnwng ngv sukaka Alvnv Yunying nga, nonuam mimpa dubv doodunv Pwknvyarnv yvvdw nyidomookua, sichingmookua, svmasa nga, okv ogugo dopvkudw Pwknvyarnv gvlo svkvnv ogu arv kamanv ridungsingdung loka mvngdin modukubv vla. ");
INSERT INTO tgj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Vngro ikunv atuk lo hv nyi mvnwng nga bunugv mvngbv vngkarchaakar moto. ");
INSERT INTO tgj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Vbvritola ninyigv alvbv rijinam lokv hv kaatam sudunv, hv nyidomooku tologv nyido odw lo omudu okv aliami, aamtami nga nyindw lo nyimu dunv; hv nonua dvnamtvngnam nga jila haapok am mvngpu sakpu la rimudu.” ");
INSERT INTO tgj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Apostol vdwv so svkvnv gaam vkv milaku bunua raaibv ho bunyia erinpeeji tvku loka mintor toku. ");
INSERT INTO tgj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jius nyi meego Pisidia gv Antiok lokv okv Ikonium lokv aatoku; bunu nyipam nga miyayala bunu gvlo minkiam lwkto, Paulnyi vlwng ngv ortoku okv ninyi sipvkudw mvngnyato, ninyi banggu gvnga svvlin toku. ");
INSERT INTO tgj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Vbvritola ninyia mvngjwngnv vdwv sooyum kunam ngv, hv gudung toku okv banggu arwngbv vngkur toku. Logo nvnga hv la Barnabas Darbe bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul okv Barnabas Alvnv Yunying nga Darbe lo japji toku okv achialv nyi vkv mvngjwng motoku. Vbvrikunamv bunu Listra bv, Ikonium bv, okv Pisidia gv Antiok lo vngkur nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bunu mvngjwngnv vdwa gwlwk bvkv okv alvbv mvngjwng nyalakv vla bunua tamsarto. “Ngonu Pwknvyarnv gv Karvlo aapvnam lvgabv ngonu atuklo achialv bv hirukaya hirungre.” ");
INSERT INTO tgj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Gvrja lokv nyigagatv vdw akinsago bunu laalinla rigv modubv parlwk toku um yigla kumla doogvrila Ahtu gvlo kobik lwkji toku, okv yvvnyi bunu mvngjwng nyapvkudw. ");
INSERT INTO tgj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia gv mooku nga vngnyaro koching bv, bunu Pampilia lo aatoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bunu Parga hoka doina japji pikula okv vbvrikunamv Attalia bv vngtoku, ");
INSERT INTO tgj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","okv hoka gvngv bunu svpwbv Antiok lo vngkur toku, ho mookuv bunua kvvlo Pwknvyarnv gv anyuaya lvgabv kudungkua nga vjakgv ripwngrinya kunam anga kaaduridubv tulwk kongv. ");
INSERT INTO tgj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Vdwlo bunu Antiok lo vngchi tokudw, bunu gvrja gv nyi vdwa lvkobv gokum nyatola okv bunugv lvkobv Pwknvyarnv gv rinam mvnwng nga okv oguaingbv Jentail nyi vdwa mvngjwng dukubv hv lamtv nga mvkok jiku nama bunuv mintam jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Okv bunu mvngjwngnv vdwgv lvkobv hoka apo go doomin gvvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nyi meegonv Judia lokv Antiok lo aanya toku okv mvngjwngnv vdwa tamsar sarab toku, “Nonu Moses gv Pvbv aingbv ayakmvu sudubv rinya mabolo nonuv ringnama paamare.” ");
INSERT INTO tgj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul okv Barnabas bunyi so gv lvgabv bunua lvkobv achialvbv larmi sunya toku, vkvlvgabv Paul okv Barnabas okv Antiok gv nyi meegonv Jerusalem lo vngla okv Apostol vdwa okv nyigagatv vdwgv lvkobv soogv raagv dvnam sum kaarung svgo vla japmi sunya toku. ");
INSERT INTO tgj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Gvrja lokv bunua kanam toku bunuv lamtv lo vngdungto; okv bunu vbv Poenesia okv Samaria bv vngpik nyato, bunua oguaingbv Jentail vdwv Pwknvyarnv gvlo aadu kudw um mimpa kartoku; so yunying ngv mvngjwngnv vdwlo gwlwk jinamv mvnwng ngv achialvbv himpu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Vdwlo bunu Jerusalem lo vngchi tokudw, bunua gvrja vdwv alvbv naarwk sinyatoku, Apostol vdwa, okv nyigagatv vdwa, Paul la Barnabas bunyi Pwknvyarnv oguaingbv bunyi am rinv la ripvkudw um japji toku. ");
INSERT INTO tgj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Vbvritola Parisis apam lokv mvngjwngnv meegonv dakto la okv minto, “Jentail vdwv ayakmvu rirungtoka okv Moses gv Pvbv nga tvvdubv mintoka.” ");
INSERT INTO tgj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apostol vdwv okv nyigagatv vdwv so tvvka nam um alv bvju vla kaarwk sunyato. ");
INSERT INTO tgj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Achialvbv raakwng minsuro kochingbv Pitar dakrap la minto, “Ngoogv ajin vdwv, nonu chinyado kvvlo gvngv Pwknvyarnv nga nonugv pingko loka goklinto Jentail nyi vdwgvlo Alvnv Yunying nga japji dubv, vkvlvgabv ho bunu tvvria tvla okv mvngjwng dubv. ");
INSERT INTO tgj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Okv Pwknvyarnv yvvdw nyichar mvnwng gv mvngnam saknama chinv, ngonua rinam aingbv Jentail nyi vdwaka Darwknv Dowa ninyigv jinama kaatam jito. ");
INSERT INTO tgj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hv ngonua okv bunua pingkolo yvvnyika akusubv mvngnam kaama; hv bunugv rimur am mvngnga jipvku ogulvgavbolo bunuka mvngjwngto. ");
INSERT INTO tgj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Vbvrikunamv, vjak nonu ogulvgabv mvngjwngnv vdwgv koching lo vge nga tulwk tola Pwknvyarnvnyi ingka dunv vmalo ngonugv abuapa ngvka malo ngonu mvnwng vka um baknyure? ");
INSERT INTO tgj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Vv makv! Ngonu mvngjwngnam lvgabv okv Ahtu Jisu gv anyuaya ngv ringpv kunv, vbvching bunu nyika rdunv.” ");
INSERT INTO tgj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nyitwng dopam mvnwng ngv Barnabas okv Paul bunyi gvlo Pwknvyarnv gv Jentail nyi vdwlo lamrwpadubv okv kaasartabo dubv rinam am bunyi gv mimpa jiku nama tvvriala choibv doonyato. ");
INSERT INTO tgj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Vdwlo bunu japnya kunam gola, Jems japrapto: “Ngoogv ajin vdwa, nga tvriato! ");
INSERT INTO tgj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon vjv mimbwk jigv ibv oguaingbv Pwknvyarnv Jentail nyi vdwa ninyigv chigudabia nga kaatam kunama okv bunua ninyigv nyigvbv laatulake bv naarwk suku nama. ");
INSERT INTO tgj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nyijwk vdwgv gaam vdwv so sum lvkobv tulwk minggvto. Kitap lo vbv mindu, ");
INSERT INTO tgj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ahtu minto, So kochingbv ngo akur riku, okv Dabid gv karv nga lvkodv laakumlaapa riku. Ngo darmwk kunama um mvdin rikunv okv lvkodv um gwlwk dukubv mvdin riku. ");
INSERT INTO tgj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Okv vkvlvgabv nyi mvnwng ngv ngo gvlo aariku, Jentail nyi mvnwng vka yvv bunua ngo atubogv bv mvngla gokku nam vdwa. ");
INSERT INTO tgj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Vkvlvgabv vbvching Ahtu minto, yvvdw sum krimklu lokv chimu dukubv mvkunv.’ ");
INSERT INTO tgj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“So si ngoogv mvngnamv,” Jems japdungto, ho ngonu mvnwng ngv Pwknvyarnv gvlo aakur kunv “Jentail vdwa ridwkriku jimabv. ");
INSERT INTO tgj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Vmabvya, ngonuya bunua siti go lvkto kula mimpa lajuka darwkmanv ogugoka dvma bvkv ogulvgavbolo ho vv morti lo jilwknamv; bunua yoomur minsu mabvka; okv svnwngsvmin hoksar nama vmalo oyi am dvma bvkv vla miya lajukv vla minto ");
INSERT INTO tgj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Moses gv pvbv nga kvvlo lokv Jius kumkunaamlo doonu aludwkibv puri rijikito okv ninyigv gaam nga banggu mvnwnglo japjito.” ");
INSERT INTO tgj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Vbvrikunamv Apostol vdwvla okv nyigagatv vdwv, Pwknvyarnv gv nyi mvnwng ngv doodum toku, bunugv ajin lokv darlin gvrikula Paul okv Barnabas gv vngkulo Antiok bv vngmu dubv mintoku. Vbvrikunamv mvngjwngnv vdwgv mvngdv kunam nyi anyigo Barnabas vnam Judas nyila Silasnyi darlin toku. ");
INSERT INTO tgj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Okv bunua siti meego lvkto kula bunua lvkobv vngmu toku: “Ngonu, Apostol okv nyigagatv vdwv, nonugv abwngboru, Jentail doonv Sairia, okv Silisia gv Antiok lo rinyabu vdwa kumrwk sidunv. ");
INSERT INTO tgj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ngonugv apam lokv nyi meegonv ngonua vbvkv vla mingkuriku mabv vngla nonua mindwkmingku pvkv vla ngonu tvvpa pvku. ");
INSERT INTO tgj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Okv vkvlvgabv ngonu mvnwng ngv doodum toku okv nyi meego darlin laku nonu gvlo vngmu dukubv vla tulwk pvkunv bunu ngonugv ajin Paul okv Barnabas bunyia lvkobv vngriku, ");
INSERT INTO tgj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","yvvbunudw atugv singdung nga mvngmabv Ahtu Jisu Kristo gv kudungkua lvgabv mvngla rinvgo. ");
INSERT INTO tgj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ngonu nonu gvlo vngmure, vbvrikunamv, Judas okv Silas bunyi nonua nyidum bv ngonugv lvknam so apia bv mimpa jire. ");
INSERT INTO tgj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Darwknv Dow vla okv ngonu tulwk minsu pvnv so gv ridung aba so gv lvvyalo nonu gvlo oguaingbv adwkaku go lvkmare vla: ");
INSERT INTO tgj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Morti lo erinpeelwknam dvnama dvma bvka, oyi dvma bvka; svnwngsvmin hoksar nama dvma bvka; okv nonu atubongv yoomur nyama bvka. Nonu so vdw sum rimabv ribamdobam bolo alvre. Ngonugv ayanam mvnglwk lvkobv doming gvvre.” ");
INSERT INTO tgj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Gingdung mvnwng ngv vngnya toku okv Antiok lo vngchi nyalaku, hoka bunu mvngjwngnv apam mvnwng ngv dookum tokula okv bunua siti nga jinya toku. ");
INSERT INTO tgj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nyitwng ngv siti nga purila, tamsar doin nga puri ripa tokula, bunu mvnwng ngv himpu punya toku. ");
INSERT INTO tgj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas okv Silas, bunu atubongvka nyijwk go, bunugv lvkobv mvngchigo japnya la doonyato, bunua mintvmiru jito okv vngdwng mooto. ");
INSERT INTO tgj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Hoka meego doopi kula koching nga, bunu mvnwng ngv mvngjwngnv lvkobv sarsopoyo pikula okv mvngjwngnv vdwv bunua kanam nvgv dokubv vngkur motoku. ");
INSERT INTO tgj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Vbvritola Silas hokaku doodu kubv mvngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paul okv Barnabas apogo Antiok lo dootoku, okv bunugv lvkobv nyi meegonyi tamsar nyala okv Ahtu gv gaam nga japnyato. ");
INSERT INTO tgj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Meego nvgv dw kochingso Paul Barnabasnyi minto, “Kvlai ngonu vngkur lakuju ogolo ngonu Ahtu gv gaam nga banggu mvnwnglo ngonugv mvngjwngnv vdwa japji kunam nga kaakar lakuju, okv kvlai ngonu bunu ogu ripvkudw kaanya lakuju.” ");
INSERT INTO tgj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas Jon Marknyi bunua lvkobv vnggv dubv mvngkato, ");
INSERT INTO tgj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","vbvrinamv Paulnyi vnggv dubv um mvngka mato, vkvlvgabv ninyia bunugv risv nga lvkobv rinya gvla doomin gvvmado, vbvritola bunua Pampilia lo topak pikula okv vngkur toku. ");
INSERT INTO tgj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Hokaku achialvbv larkwng minsu pikula, okv Barnabas Marknyi svpw lokv Saipras bv vnggv toku, ");
INSERT INTO tgj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","hoka Paul Silasnyi gaktoku, okv vnglintoku, mvngjwngnv vdwv Ahtu gv anyuaya nga alv bvkv hvming gvvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Hv Sairia bvla Silisia bv vngpik kunam, Gvrja vdwa gwlwk ha jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul Vngtoku Darbe okv Listra lo, ogolo kristan amin Timoti vnamgo doopvdw. Ninyigv anv ka kristan go, Jius gvgo, vbvritola ninyigv abuv Grik go. ");
INSERT INTO tgj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra okv Ikonium lokv mvngjwngnv mvnwng ngv Timotinyi alv nvgo vla japnya toku. ");
INSERT INTO tgj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul ninyigv lvkobv Timotinyi vnggv nwngto, vkvlvgabv hv ninyia ayakmvuto. Vkvlvgabv hv ritoku ho mooku gv doonv Jius mvnwng ngv Timoti gv abuv Grik vkv vla chintoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bunu banggua vngpikla vngrilo, Jerusalem gv Apostol vdwa okv nyigagatv vdwgv pvbv mimpv nama tvvdu ridubv, bunu mvngjwngnv vdwlo japying jito okv ho minam am bunua ridubv mintoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Vkvlvgabv Pwknvyarnvnaam lo gwlwk alvbv mvngjwng toku okv aludwkibv twngtv yaya toku. ");
INSERT INTO tgj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bunu vngraptoku Prigia okv Galatia gv mooku lo ogulvgavbolo Darwknv Dowv bunua Asia mooku lo doina bunua mimu matoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bunu vdwlo Maisia gv launglo vngchi pvkudw, bunu gwngkw nyato Bitinya mooku lo vngdubv, vbvritola Jisu gv Dowv bunua vngmumato. ");
INSERT INTO tgj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Vbvrikunamv bunu Maisia takbv vngtoku okv Troas lo vnglwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ho ayu Paul nyikrwgo kaato ninyia Mesedonia ngv dakto la okv ninyia kodwkrwk la kodubv kaato, “Mesedonia lo aala okv ngonua ringla bvkv vla!” ");
INSERT INTO tgj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul so nyikrwa kaanam gola, ngonu mvngrap toku Mesedonia bv vngdu kubv, ogulvgavbolo ngonu Mvngtoku Pwknvyarnv ngonua goklin pvkunv alvnv yunying nga Mesedonia gv nyi vdwa minji dokubv. ");
INSERT INTO tgj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ngonu Troas lokv svpw gvngv vnglin lakula okv sidakala bv vngdavngra la Samotras lo vngpikla, okv logo nvnga Neapolis lo vngchito. ");
INSERT INTO tgj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ngonu ho mooku gvngv Pilippi lo aalwk toku, ho pamtv vv Mesedonia gv mvtumvke distrik akobv rito; so si ka Roman nyi vdwgv doolwkku bvka ritoku. Ngonu hoka alu meegoka doa pvkunv. ");
INSERT INTO tgj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Doonu alu lo ngonu Jius vdwgv kumdubv dookum kongv hoka dodubv vla mvnggv rila, pamtv gvngv svko takbv linto. Ho anvnyimv vdwa ngonu dootung tokula okv minrap toku. ");
INSERT INTO tgj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ngonu gvlo tvvnv akonv Laidia Taitira lokv, ho vv yalwng yajinv iji pioknv angv. Nyimv angv Pwknvyarnvnyi kumnv go, okv Ahtu ninyigv tuktum mvngnv nvnvnga mvkoto Paul gv ogugo minpvdw alvbv tvvria dubv. ");
INSERT INTO tgj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kochingbv ninyia okv ninyigv naam lo doonv vdwv baptisma naatoku, ninyi ngonua harlwkto, “Aala okv ngoogv naam lo doolaka nonuno nga jvjvbv Ahtu gv mvngjwng bogobv mvngpvlo.” Okv ninyi ngonua gumya yala vnggv toku. ");
INSERT INTO tgj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Alu golo ngonu mvnwng ngv kumku mookulo vngtoku; ngonu mvnwng ngv nyijar paknv go vngrwk sito hvkv gvlo darwkmanv dowv doonvgo ho aajinv singdung nga mincho nyunvgo. Ninyigv atu gvbv hv achialv bv morko nga paanv go alvbv aainvgv lvga mincho jinam lokv. ");
INSERT INTO tgj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hv Paul okv ngonua vngming gvtoku, gokto “So nyi vdwsi Kairungnv Pwknvyarnv gv pakbu go! Bunu nonua dupwng jidu oguaingbv nonu singnya svngvdw!” ");
INSERT INTO tgj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ninyia svbv rila alu meego ritoku, Anyungnga Paul achialvbv mvngdwk toku ho ninyi hinkur hirwkla okv dowa mintoku, “Ngo Jisu Kristo gv amin bv nyimv sokv alvmanv dowv liro toku vla orto jidunv!” dowv linda toku vbv ho minda rilo. ");
INSERT INTO tgj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Vdwlo ninyigv atu gv morko nanv nvngv nyeepv kudw bunu mvngdwk toku, bunu Paul okv Silasnyi gakbwng toku okv bunu svvla ikula rigvdoogvnv nyi vnggiachaagia lo svvlwk nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bunu bunua Roman nyigam vdwlo boolwk chotola okv mintoku, “So nyi vdwsi Jius vdwgo okv bunu mvnwng ngv ngoogv pamtv so ridwkriku nyadu. ");
INSERT INTO tgj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bunu akusunv ridungdodung go tamsar la ngonugv pvbv nga rinyingrirudo, ngonu Roman pamtv lokv, okv ngonu mvnggia mare so ridungdoodung sum vmalo bunugv rinama.” ");
INSERT INTO tgj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Okv nyipamv lvkin gubv Paul okv Silasnyi naatungto. Vbvrikunamv nyigam vdwv Paul okv Silas gv vji nga putakpuyak tokula okv bunua mvdu ridubv orto nga jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Koching nga achialv bv dwngto la, bunu vdwv buniya patwk arwng lo tumlwk toku, okv patwk rigv nvngv bunua alvbv itum pvvto vla orto nga jito. ");
INSERT INTO tgj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Oogv orto nga tvvnam gola, patwk rigvnvgv bunua chenyung lo tunglwk to okv bunugv lvpa nga lvpia lwkpium sitola tumpvto. ");
INSERT INTO tgj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yupra lvpa nga Paul okv Silas bunyiv Pwknvyarnvnyi kumla okv mimin mintoku, okv kvvbi patwk doonv mvnwng ngv bunya tvla dootoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dvminmabv hoka kairungnv mobi go hwkto, hogv patwk doogingnvnv vka hvkdin rvpwngto. Vbvrinamv agi mvnwng ngv kokko nyatoku, okv patwk lo doonv mvnwng ngv jaako ngv doksok toku. ");
INSERT INTO tgj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Patwk am kaarianv angv godung toku, okv vdwlo hv patwk gv age ngv kokda namnga kaapa tokula, ho ninyi patwk lo doonv vdwv toosi pvvkuji mvngtoku; vkvlvgabv hv atubongv rioksv nga svvlin laku okv atubongv peeki sitv toku. ");
INSERT INTO tgj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Vbvritola Paul ho lokv gvngv ninyigv gaam bv gokbub lotoku, “No atubongv mvki suma bvka! Ngonu mvnwng ngv si dopvnv!” ");
INSERT INTO tgj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Patwk am rigv nvngv mvru bvngla ikula, arwngbv chaplwk toku, okv jinjin rumrum laku Paul okv Silas gv lvpa lvkwnglo aalwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Vbvrikunamv hv bunua agumbv linggv toku okv tvuto, “Tamsarbo vdw, ngo oguaingbv rila ringdubv?” ");
INSERT INTO tgj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bunu mvrwkto, “Ahtu Jisunyi mvngjwng laka, okv nonua ringya tvvrikunv—nam okv noogv ogu nyi haka.” ");
INSERT INTO tgj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Vbvrikunamv bunu Ahtu gv gaam nga japji toku okv ninyigv naam lo doonv kvvbi vdwaka. ");
INSERT INTO tgj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hogv ayulo patwk kaaria nvngv bunua vnggv toku okv bunugv ungv nga harkak toku; okv hv okv ninyigv ogu nyi mvnwng ngv lvkin gubv baptisma naatoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Vbvrikunamv hv Paul okv Silasnyi naambv chaagv toku okv bunua dvnam go meego jitola dvmu tvku. Hv okv ninyigv ogumvnwng ngv achialv bv himpu toku, vkvlvgabv bunu Pwknvyarnvnyi vjv mvngjwng nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Aru gunv nga Roman rigvnv vdwv polis nyigam vdwa orto nga jilinla vngmuto, “Hogv nyi vdwa vngmu laku kv vla.” ");
INSERT INTO tgj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Vkvlvgabv patwk kaarianv Paulnyi minto, “Nyigam vdwv nam okv Silasnyi orto go jilwkpv topu dukubv. Vbvribolo, nonu vngla riku, vngnyi kuka okv nyanyak alvbvku.” ");
INSERT INTO tgj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Vbvritola Paul polis nyigam vdwa mintoku, “Ngonu mvnwng lo ogu rimur goka kaapama, bunu ngonu mvnwng nga nyi gv apam lo mvritmvkato—okv ngonu mvnwng vka Roman nyi to! Vbvrinamv bunu ngonu mvnwng nga patwk arwnglo tumlwkto. Okv vjv ngonua chinpa madubv vngmu kuso mvngduku. Vmabv! Roman nyigam vdwv atubongv soka aasu la okv ngonua naalin motoka.” ");
INSERT INTO tgj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Polis nyigam vdwv mirwk toku soogv gaam am Roman nyigam vdwlo minpa toku; okv vdwlo bunu Paul okv Silasnyi Roman nyi go vla tvvpa kunamv, bunu mvnwng ngv busu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Vkvlvgabv bunu aalaku okv bunua minggu lwktoku; Vbvrikunamv bunu patwk gvngv bunua linggv toku okv bunua pamtv nga kayu tokukv vla tvvkato. ");
INSERT INTO tgj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paul okv Silas patwk gvngv linlaku okv Laidia gv naam bv aatoku. Bunu hoka mvngjwngnv vdwa kaarwk sito kula, okv bunua gaam mintvmiru pikula okv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paul okv Silas Ampipolis okv Apollonia bv vngpikla vngtoku, Jius kumkunaam dooku gv Tesalonika lo aatoku. ");
INSERT INTO tgj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paul ninyigv atugv vngdungbv Jius kumkunaamlo vngtoku. Hoka Doonu alu lvum go hv nyitwng gv lvkobv dopam pamgvto Baibel kitap lokv minla, ");
INSERT INTO tgj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","okv Darwknv kitap lokv bunua mindimiyin jila mimpa jitoku ho Kristo hinching la okv sito kula turkur kunama. “Si Jisu oogv ngo nonua mimpa jidunv si,” Paul minto, “Si kv Kristo.” ");
INSERT INTO tgj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bunugv meegonv Paul okv Silas gv mingku lo tvvlwk minggv toku okv lvkobv ritoku; vkvlvgabv Grik twngtvnv meego okv anvnyimv rigvdogvnv meegoka, oogv Pwknvyarnvnyi kumnyabo vdwv. ");
INSERT INTO tgj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Vbvritola Jius vdwv kavtarv toku okv nyi agar manv vngkarchaakarnv meego vngkum motola okv dopam pamnya lakula alvmanv nyitwng gubv ritoku. Bunu pamtv mvnwng lo makarrikar nyato okv nyi akogv naama palwk jitoku Jason minv angv naam nga okv Paul okv Silasnyi mvdubv kaakar nyala okv bunua nyi apam lo boolin dubv. ");
INSERT INTO tgj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Vbvritola bunua kaapa kuma nvngv, bunu Jasonnyi okv mvngjwngnv meegonyi pamtv gv rigvdogv nvlo boolin chotola okv goktoku, “So nyi vdwv mooku mvnwng lo ridwkriku nvgo! Bunu vjv ngonugv pamtv lo aapvku, ");
INSERT INTO tgj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","okv Jason bunua ninyigv naam lo doomu toku. Bunu mvnwng ngv Dvbvyachok gv pvbv nga tvvmabv rinia toku, mvvnya toku dvbv kvvbigo dopvkv, vkvgv aminv Jisu.” ");
INSERT INTO tgj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bunu soogv gaam nga nyipam okv pamtv tujupkunam nga tvvsik motola twngtwng rara mvngmu toku. ");
INSERT INTO tgj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tujupkunam vdwv Jason okv ajin vdwa ainmorko dorsvrisv nga rimu tokula topu toku, okv vbvrikunamv bunua vngmu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kanv sopikda, mvngjwngnv vdwv Paul okv Silas bunyia Beria lo vngmu toku. Vdwlo bunu vngchinam gola, bunu Jius kumkunaam bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria gv nyitwng ngv Tesalonika nyitwng nga habia yatoku. Bunu doina tvvnwng alvbv tvvria nyatoku, okv Paul gv minam ngv jvjv gubvri vla bunu Baibel kitap nga alu lokia purila kaanyato. ");
INSERT INTO tgj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bunu mvnwng ngv awgonv mvngjwng nyatoku, okv Grik gv anvnyimv kaibv rigvdogv awgo okv Grik gv nyiga awgunv ka mvngjwng nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Vbvritola vdwlo Tesalonika lo doonv Jius vdwv Paul Beria lo Pwknvyarnv gv gaam nga japdokv vla tvvpa namgola, bunu hoka aatoku okv lamrwpato kula okv apam am nvngyaknvngchak toku. ");
INSERT INTO tgj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Vjakpigobv mvngjwngnv vdwv Paulnyi svmasa gv agum bv vngmu toku; vbvritola Silas okv Timoti bunyi Beria lo dootoku. ");
INSERT INTO tgj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paul gv lvkobv vnggvnv vngbom nyi vdwv ninyia Etins bv vngchi gvvtoku okv vbvrikunamv Paul gvlo lvkobv minsar koto kula ho Silas okv Timotinyi lvkobv aamu dokubv baapubv Beria vngkur toku. ");
INSERT INTO tgj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Vdwlo Paul Etins lo Silas okv Timotinyi kaaria rilo, hv achialvbv mvngru toku pamtv lo morti achialvgo kaapa tokula. ");
INSERT INTO tgj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Vkvlvgabv ninyia Pwknvyarnv kumnvjonv Jius okv Jentail vdwgv lvkobv kumkunaamlo dopam pamgv toku okv nyitwng nga aludwkibv vngpiknv vdwaka. ");
INSERT INTO tgj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ipikurian gv meego okv stoik gv tamsarnvnyi larmi sito, mintoku, “so nyi si oguka chima hv ogugo mindu nvdw. Hv ogugo mintv dvnvdw?” Kvvbiv minto, “Hv mintv doonvgo ngonua kvvbi Pwknvyarnv meego,” ogulvgavbolo Paul minjito bunua Jisu gv lvkwng lo okv ninyigv sinam lokv turkur kunama. ");
INSERT INTO tgj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Vbvrikunamv Paulnyi hv vnggv toku, Aropagus kvba, doopamlo hoka hv mintoku, “Ngonua minbwk jilabv so anw rinama noogv ngonua tamsarnama. ");
INSERT INTO tgj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Noogv ngonuam anw bv minjinam nga, okv ngonu chinwngdo soogv tamsarnam si oguvdw,” ( ");
INSERT INTO tgj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Etins lo nyi mvnwng ngv okv nyebunyi mvnwng gv atugv dwa rilwk dula anwnv ogugo minam am tvvria laka rito okv mimpa laka rito.) ");
INSERT INTO tgj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul pamtv gv kvbadopam kaagia lo dakrap toku okv minto, “Ngo kaadu nonugv Etins lo nyi vdwv achialvbv dormo rinv gubv ridu. ");
INSERT INTO tgj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ngo nonugv pamtv nga vngpitla okv nonugv kumkujoku am ngo kaakunamv oogv yogwngmvrwng lo lvkpv nama kaapa toku ‘Chimanam Pwknvyarnv gv lvgabv’ hv nonugv kumnamjonam go, vbvrikunamv, vbvrilachin hum nonu chimado, si oguvdw ngo nonua vjak minkar jidukunv. ");
INSERT INTO tgj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Pwknvyarnv, sichingmooku okv ogumvnwng nga sum pwknv, nyidomooku okv nyiamooku gv Ahtuv okv nyi vdwgv mvnam kumging lo dooma dunv. ");
INSERT INTO tgj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pwknvyarnv ngonu gvlo oguguka mvngma dunv vmalo ngonu ninyia ogugo jila nyudunv hv yabv atuv ngonua saknam turnama okv ogumvnwng nga nyichar mvnwng lo jiya dunv. ");
INSERT INTO tgj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nyi ako lokv hv mooku mvnwng nga mvlinto okv minjito sichingmooku mvnwng lokv turdubv. Hv atubongv mvkimvak jito ogolo okv oguaingbv singsv vdw. ");
INSERT INTO tgj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ninyia sum ritoku vkvlvgabv ho bunu ninyia kaachin sidubv, okv ninyi chinsu lare bunu ninyigv lvkwng lo mvngnama. Hvjvka Pwknvyarnv ngonu mvnwng gv lokv aduma; ");
INSERT INTO tgj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","vbv akonv minto, ‘Ninyigv lokv ngonu singdunv okv bidutapdunv okv turmudakmu dunv.’ Si nonugv mimin lvknv meegonv mindunv, ‘Ngonuka ninyigv umvuu ngv.’ ");
INSERT INTO tgj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ngonu mvnwng ngv Pwknvyarnv gv umvuu ngv vbolo, ngonu vbv mvngmare hv ain vmalo raaji vmalo vlwng lokv morti bv mvnamgo vla. Hv ogu lokvka manvgo nyi vdwlokv mwnglin nam okv mvlin nam. ");
INSERT INTO tgj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Vngnyi konv dwlo, Pwknvyarnv kaabotalikla kaato ogulvgavbolo nyi vdwv chimato ogugo bunu ridunvdw. Vbvritola vjak ninyia minduku ho nyi mvnwng nga mooku mvnwng gvngv alvmanv lokv mvngdin la ninyi gvlo aakur tvku vla. ");
INSERT INTO tgj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pwknvyarnv sichingmooku mvnwng nga nyi akin gvlokv alvrungbv jwngkadaka dukubv alua mvpvripv pvku, okv hv sum kaabwk dukubv rilin jitoku ninyia sikunvnga turkur molaku!” ");
INSERT INTO tgj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Vdwlo nyi vdwv, Paul gv oogv sitola turkur kunam gv lvkwngbv japnama tvvpa pvkudw, nyi kvvgonv nyarjito. Vbvritola kvvgonv mintoku, “Ngonu sum tvvria dvre no gvlo lvkodv.” ");
INSERT INTO tgj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Okv vbvrikunamv Paul bunugv doopam lokv lintoku. ");
INSERT INTO tgj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nyi meegonv Paulnyi mvngjwng toku okv vngming gvvtoku, apam ho Dionysius, hv kvba gv nyi go, hoka anvnyimv ako aminv Damaris, okv nyitwng kvvbi meegoka. ");
INSERT INTO tgj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","So koching bv, Paul Etins nga kayu pikula okv korin bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Hoka nyi Akuila vnam, pontus lo bvngnam Jius nyi ako kaapato, ninyigv nyimv Prisilanyi lvkobv Itali lokv gvngv aachi sopikto, Klaudius Dvbv Jius mvnwng nga Rom lokv vngro tokukv vla orto jilin toku. Paul bunua kaabv vngto, ");
INSERT INTO tgj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","okv hoka doolwk toku okv bunua lvkobv ridungripa riming gvvto, ogulvgavbolo hv bunugv rinam apia bv vbv tombu mvla turla singnv go. ");
INSERT INTO tgj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ninyia Doonu aludwkiya Jius kumkunaam lo, Jius okv Grik vdwa mvngdin modubv vla dopam lo japbwngto. ");
INSERT INTO tgj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Vdwlo Silas okv Timoti Mesedonia gvngv vngchi pvkudw, Paul ninyigv dw mvnwng nga Jius vdwlo ho Jisu Kristo ngv vla doin japku lo rimwng toku. ");
INSERT INTO tgj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Vdwlo bunu ninyia maakv vpvdw okv ninyia tvvru kaayanv minto kudw, hv atubogv vji gv amokayok nga tia sidula okv bunua mintoku, “Nonugv atubogv singnwng manamv nonugv mvngmur vsu! hv ngo ajv kaariama. Vjak lokv ngo vngjikun Jentail vdwloku.” ");
INSERT INTO tgj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Vbvritola hv bunua vngyu toku okv vngla kula Jentail Titius Justus vnam dooku gv naam lo aatoku hv Pwknvyarnvnyi kumnv go; ninyigv naamv Jius kumkunaam koching lo dooto. ");
INSERT INTO tgj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispas, Jius kumkunaam gv rigvnvgo, Ahtunyi mvngjwng nvgo, ninyigv nyimv kuu mvnwng vka lvkobv; okv Korin gv kvvbi nyitwng mvnwng ngv doina tvvpa tokula, mvngjwng toku, okv baptisma laanya toku. ");
INSERT INTO tgj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ayu yupgo lo Paul nyikrwgo kaatoku Ahtu ninyia ho mintoku, “Busu mabvka, vbvritola japbwng laka okv kayu mabvka, ");
INSERT INTO tgj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ngo noogv lvkobv doodunv. Nam yvvka ogu mvkimvmar jinv kaamare, ogulvgavbolo ngoogv nyi vv soogv pamtv si awgo dopvnv.” ");
INSERT INTO tgj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Vbvrikunamv Paul hoka dootoku nyingola patung go, Pwknvyarnv gv gaam nga nyi vdwa tamsar la. ");
INSERT INTO tgj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Vdwlo Gallionyi Akaia lo Roman mooku gv gobunor gobv mvlin pvkudw, Jius mvnwng ngv lvkin gubv aakum la Paulnyi naatung toku okv ninyia kvba baaku naam bv aagv toku. ");
INSERT INTO tgj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bunu minto, “So nyi si, tamsardu nyi vdwa Pwknvyarnvnyi kumlakv vla ngonugv pvbv nga rinyingriru bv ridu!” ");
INSERT INTO tgj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul mintv namgola Gallio Jius vdwa minto, “Vdwlo nonu so nyi sum alvmabv pvbv nga riborilikla vmalo rimurvngmur kunam gv gaam gubolo, ngo nonu Jius vdwgv minama tvvria namv vv alvnvgobv rire. ");
INSERT INTO tgj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Vbvritola nonugv ogugo raami sinam si gamchar okv amin gv lvkwng mvngchik gomwng mimisinam si nonugv atubogv pvbv gv lvkwng lo. Vkvlvkwngbv no atubongv risu laka soogv adwkaku sum noogv sigwng bv. Ngo sikv nvnga macharmayar nwngria ma!” ");
INSERT INTO tgj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Okv ninyia bunu mvnwng nga kvbanaam gv agum bv charlin toku. ");
INSERT INTO tgj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bunu mvnwng ngv, Jius kumkunaam gv rigvnv Sostenesnyi svvbwng tokula okv ninyia kvbanaam alin lo dwngnya toku. Vbvritola dwngjvka Gallio ogugoka mvngma bv riminto. ");
INSERT INTO tgj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul Korint lo awgo mvngjwngnv vdwa lvkobv doopi kula, vbvrikunamv bunua doomu pikula okv svpwlo vngraptoku Prisila okv Akuila gv lvkobv Sairia bv vngtoku. Svpw lokv Senkrai bv vngma dvbv ninyigv dumpo dvmwa mwkak toku ogulvgavbolo hv milv toku. ");
INSERT INTO tgj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Vbvrikunamv bunu Epesus lo vngtoku, hoka Paul Prisila okv Akuilanyi kayupikula. Hv Jius vdwgv kumkunaam bv vngtoku okv Jius vdwa lvkobv tvulvpak minsuto. ");
INSERT INTO tgj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nyitwng ngv ninyia awgo doodubvri vla tvuto, vbvritola ninyia maakv vla mintoku. ");
INSERT INTO tgj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Hv vngrap jiku la, hv milvto, “Ngo aakur riku vbvritola si Pwknvyarnv mvnglwkbolo,” Vbvritola hv doruptoku Epesus lokv. ");
INSERT INTO tgj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Vbvrinamv hv kaisaria lo vngchinam gola, ninyi Jerusalem bv vngla Gvrja nga alvpvri vpi kula okv vbvrikunamv Antiok bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kochingso hoka meego ripikula, hv lintoku okv Galatia okv Prigia mooku bv vngpik lakula mvngjwngnv mvnwng nga adwngchwng motoku. ");
INSERT INTO tgj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jius nyi ako aminv Apollos Alekjandaria lo bvngnam go hv Epesus lo aalwkto. Hv alv rungbv milak nvgo okv chinv go okv Darwknv kitap a awbv chinv go. ");
INSERT INTO tgj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Hv Ahtu gv Lamtv nga alvbv tamsar jito, okv lvkobv hardv rungbv ninyia japjito okv Jisu gv jvjv nga minjwk la tamsar jito. Vbvka, ninyi Jon gv baptisma nga chimwngdu. ");
INSERT INTO tgj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Hv mvngkam alvbv Jius kumkunaam arwng lo japrap toku. Vdwlo Prisila okv Akuila ninyia tvvpa tvkudw, bunu ninyia naam lo lvkobv aagv tokula okv ninyia bunu Pwknvyarnv gv Lamtv nga alvjvbv mirwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Vbvripikula Apollos Akaia lo vngdu kubv ritoku, vkvlvgabv Epesus gv mvngjwngnv vdwv ninyia kaadurto vla Akaia gv mvngjwngnv vdwa siti go bunua lvkto la ninyia alvbv aamu tvkv vto. Hv vngchinam gola, Pwknvyarnv gv anyuayanam lokv mvngjwng kunv vdwa hv alvbv ridur nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apollos Jius vdwa Jisu Kristo kv vla Darwknv kitap lokv kaatam la nyi apam lo gwlwk alvbv larmi sula bunua larya yatoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos Korin lo doori lo, Paul mooku mvnwng lo vngpit karla Epesus lo vngchi toku. Hoka hv lvbwlaksu meego kaapatoku ");
INSERT INTO tgj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","okv bunua tvvkatoku, “Nonuno Darwknv Dow paato bvre vdwlo nonu mvngjwng nvbv rikulo?” Bunu mirwksito “Ngonu Darwknv Dowa doopv nvkv vla tvvpama.” ");
INSERT INTO tgj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Vbvrikunamv, alvdo, oguaingnv baptisma naapvnv?” Paul tvvkato. Bunu mirwksito, “Jon gv baptisma.” ");
INSERT INTO tgj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul minto, “Jon gv baptijumv yvvbunudw rimur lokv mvngdin dukunv; okv hv mintoku Israel gv nyi vdwa mvngjwng nyato ninyigv koching lo ako yvvdw aakunv hv Jisu.” ");
INSERT INTO tgj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Vdwlo bunu sum tvvpa pvkudw, bunu mvnwng ngv baptisma naanya toku Ahtu Jisu gv amin bv. ");
INSERT INTO tgj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paul ninyigv laakv bunu gvlo lakpv toku, okv Darwknv Dowv bunu gvlo aatoku; bunu tvvchin madubv gaam ranya toku okv Pwknvyarnv gv doina japnya toku. ");
INSERT INTO tgj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bunu mvnwng ngv nyi vringgola anyi gobv rito. ");
INSERT INTO tgj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul Jius kumkunaamlo vngtoku okv poolu pwkgumlo nyi vdwa lvkobv mvngkum alvbv japji toku Pwknvyarnv gv Karv nga hv bunua laadubv gwngkwto. ");
INSERT INTO tgj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Vbvritola bunu kvvgonv larnyato okv mvngjwng mato, okv bunu mvnwng gv alvmanv gaam mintv madvbv Ahtu gv Lamtv gv lvkwng lo. Vkvlvgabv Paul bunua vngyu toku okv mvngjwngnv vdwa ninyigv lvkobv vnggv laikula, okv Tairannas gv japku naam lo hv dopam go pamgv toku aludwkibv. ");
INSERT INTO tgj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Anying nyingnyi go, ho Asia mooku lo nyi doonv mvnwng ngv, Jius okv Jentail, anyiv Ahtu gv gamchar am tvvla dootoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pwknvyarnv Paul gvlo rika manam lamrwpanam go kaatam motoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Lumar okv vji jiriapjichap lokv hv lvvma nvnga mvnvrinvto, okv bunugv achi nvngv poya toku, okv alvmanv dow vka bunugv lokv lintoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jius nyi gonv vngkarchaakar la okv Ahtu Jisu gv amin lokv minv la alvmanv uyuvram am charlin kwla rika nyato. Bunu alvmanv dowa minto, “Ngo, Paul gv japkar kunam Jisu Kristo gv amin lokv gamki dunv.” ");
INSERT INTO tgj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Achiboru kanwv, Jius Nyibu Butv gv aminv skvba vnam gv kuu vdwv svbv rinyato. ");
INSERT INTO tgj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Vbvritola alvmanv dowv bunua minto, “Ngo Jisunyi chindunv, okv ngo Paul gv lvkwng aka chindunv; Vbvritola nonuno yvvla?” ");
INSERT INTO tgj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Alvmanv dow doonv nyi angv hv bunu mvnwng gv aulo pokdakto okv mvnwng nga mvtoku. Bunu naam lokv kilin nyatoku, okv abin bv okv oyiv raratvla. ");
INSERT INTO tgj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Epesus lo doonv Jius okv Jentail nyi vdwv mvnwng ngv sum tvvpa nyatoku; bunu mvnwng ngv busu nyatoku, okv Ahtu Jisu gv amina kaibv mvngpa nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mvngjwngnv awgo aalaku, ogugo bunugv rimursingmur kunam nga nyi apam lo mimpa sitoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Awgo tagohinv vdwv bunugv kitap am bakkum lakula okv bunu nyi apum lo vmvlo ramyok toku. Bunugv kitap gv arv ngv Raaji lokdwng hejar chamngu gobv ritoku . ");
INSERT INTO tgj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Vkvlvgabv Ahtu gv gaam gv jwkrwv svbv gwlwk yayabv ritoku okv dupwng kartoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ogumvnwng gv riro koching bv, Paul ninyi atubongv mvngtoku Mesedonia okv Akaia bv vngpikla Jerusalem lo vngdubv mvngtoku. Paul minto, “Hoka ngo vngpikula,” “Ngo Rom haka kaarungre.” ");
INSERT INTO tgj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Vkvlvgabv ninyigv riduryanv anyigo vngmuto Mesedonia bv, Timoti okv Irastusnyi. Hv vbvritola Asia lo awgo dootoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ahtu gv lamtv gv lvkwngbv ho dw hoka Epesus lo achialv bv yalungyachung dutoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ain pwknvrinv aminv Demetrius vnam nyi angv nyimv pwknvyarnv Artemis gv pwknvyarnvnaam a raaji lokv mvto la pyokto okv yvbunudw ninyigvbv pioknv vdwv achialvbv pyokpa la paakum jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Vkvlvgabv hv bunu mvnwng nga gokum lwkto lvkobv kvvbi vkv bunugv gwngpiabv gwngnv vdwa okv mintoku bunua, “Nyi vdw, nonuno chindu ho ngonugv singkuv soogv gwngnamrinam lokv aadunv. ");
INSERT INTO tgj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Vjak, nonu atubongv kaasudu okv tvvsudu ogugo Paul gv ridung doonv nga. Ninyia hoka minto laak lokv mvnam pwknvyarnv ngv pwknvyarnv jvjv mangvkv okv ninyia awgo milwk toku Epesus okv Asia mooku gv nyi taktv yanga ka. ");
INSERT INTO tgj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Hoka achialvbv maarw yinvpv, vbvritola, ho ngonugv pioksvrisv ngv alvmanv amin donyiji. Vv twkma, Vbvritola hokaka rire maarw alvbv hogv Pwknvyarnvnaam lo kairungbv Pwknvyarnv nyimv Artemis aariku ogubvka riku mabv, okv hoka ninyigv kairungnv ngv apinayin riku pwknvyarnv nyimv ninyia kumnv Asia mvnwng ngv okv chinggodogo gv mvnwng lokv ngvka!” ");
INSERT INTO tgj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nyitwng ngv so gamchar nga tvvpa namgola, bunu mvnwng ngv sakcha nyatoku okv gokrap toku, “Epesus gv kai yachuk nvngv Artemis kv!” ");
INSERT INTO tgj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tvvsupkayap dukubv hv bunu dupwng kartoku Pamtv mvnwng lo. Nyi kvvgonv Gaius okv Aristarkasnyi svvtungto, Paulnyi lvkobv vngnv vdw Mesedonia lokv, chapchar minsuto mvnwng ngv dopam dooku lo. ");
INSERT INTO tgj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul atubongv nyitwnglo aala okv minso mvngto, vbvritola mvngjwngnv vdwv ninyia vngmu nwngmato. ");
INSERT INTO tgj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia mooku gv tujupkunam nyigam kvvgonv Paul gv ajin bv rinv, ninyia kumla minam gindung go vngmuto gokku naam lo vngma bvkv vla. ");
INSERT INTO tgj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Dopamripam mvnwng lo aparasar nyatoku: nyi kvvgonv gokto ogu ako, kvvbi gonv gokto oguguyv mvngla, ogulvgabv takloyangv bunu chimato ogubv bunu mvnwng ngv aakum pvdw. ");
INSERT INTO tgj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nyitwng kvvgonv minya toku Alekjandarkv jvjvkv rigvnv, vbv Jius vdwv ninyia atuk lo vngcho dubv mvtoku. Vbvrikunamv Alekjandar nyitwng nga choyi bvkv vla ninyigv laakv riaria toku, okv hv gwngkw tola minkwto miring sidubv. ");
INSERT INTO tgj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Vbvritola vdwlo bunu ninyia kaachin pvkudw Jius nyi bv, bunu mvnwng ngv gamkin gubv goklin toku lvkobv ho gunta anyi gubv ritoku: “Artemis kv Epesus lo kai nvngv!” ");
INSERT INTO tgj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Anyunganya nga banggu gv baabu angv nyitwng nga nyanyak dubv mvla toku. Hv minto, “Epesus gv nyi vdwv!” “Mvnwng ngv chindo ho Epesus pamtv ngv Pwknvyarnvnaam gv kaarianv kainv Artemis okv darwknv vlwng nyidomooku lokv holu pvnv. ");
INSERT INTO tgj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Yvvbonu ka sum miya nyomare svkvnv nga. Vkvlvgabv nonuno nyanyak runglakv okv oguka riyoka pvchaharianv gwngnamgo. ");
INSERT INTO tgj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","No so nyi sum svka aagvpv vbvritola bunu oguka dvchoma Kumkulo vmalo oguka mima ngonugv pwknvyarnv nyimv gv lvkwngbv. ");
INSERT INTO tgj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Vbvritola Demetrius okv ninyigv ririanv nyi vdwv ngonua minkinrikinbolo akonyimaka akonyi, ngonu gvlo mvvlarila gvnvnv tujubkunamv doodu kvbanaam lo aludwkibv mimisidubv. ");
INSERT INTO tgj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Vbvritola no ogu kaiyago minsu mvngdv bolo, hum minpwk jiriku pamtv gv mimpumlo. ");
INSERT INTO tgj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Silu gv ogugo ripvkunam soogv kochingbv, ngonua hoka yalungyachung rigvnvgobv minv yinvpv. Soogv duyakduchak minsukunam si ogu minkorrikor jvgo kaayoma, okv ngonu so lvkwng sum alvnvgobv minji nyula mare.” ");
INSERT INTO tgj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Pamtv baabuv svbv minggv rikula, nyitwng nga naam bv vngmu nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Yalungyachung rinya nam kochingso, Paul mvngjwngnv vdwa gokkum nyatola okv bunua lvkobv gamgo mintvmiru nyapi kula alvbv vla bunua mintoku. Vbvrikunamv hv vnglin lakula okv Mesedonia bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Hv mooku mvnwnglo vngpikla okv mintvmiru karla nyitwng nga lvkobv doin awgo minggo kartoku. Vbvripikula hv Akaia lo aatoku, ");
INSERT INTO tgj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","hoka hv poolu pwkgumgo dootoku. Hv gwngrap toku Sairia lo vngdu kubv vdwlo hv chinsu pvkudw Jius vdwgv ninyia nyiru rusvnga; vkvlvgabv hv mvngtoku Mesedonia bv vngkur dvkubv. ");
INSERT INTO tgj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Beria lokv, Pirhus gv kuunyilo Sopatarnyi lvkobv vngming gvvto; Tesalonika lokv Aristarkas okv Sekundas; Derbe lokv, Gaius; Asia mooku lokv, Taikikas okv Tropimus; okv Timoti. ");
INSERT INTO tgj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bunu vngcho nyala okv Troas lo ngonua kaariala doonya toku. ");
INSERT INTO tgj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ngonu Pilippi lokv vngraptoku vtwnglo vpap lvkmanam dvbam alulo okv alu longu kochingbv ngonu bunua Troas lo ribam tvku, hoka ngonu alu kanwgo ribam tvku. ");
INSERT INTO tgj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Karbualu gv arium ngonu mvnwng ngv lvkobv aakumchaakum nyatoku dvnam dvbam dubv. Paul nyitwng nga mintoku okv yupra lo gobv mimbwng la, hv logonvlo vngyu tvvkunam lvkwngbv. ");
INSERT INTO tgj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mvdurupum awgo hungdungto ngonu mvnwng gv doopam dooku gv hogv karchung lo. ");
INSERT INTO tgj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Yaapa ako aminv Iutikas vla minam angv kirki lo dooto, okv Paul japbwngto, Yutikas yumi la okv yuptab toku, anyunganya nga ninyi yupngak tvku okv holutvku naam hogv karchung aom lokv kvdwlo hopvtoku. Vdwlo bunu ninyia svvrap tokudw okv hv siro tvku. ");
INSERT INTO tgj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Vbvritola Paul itoku okv atubongv ninyi gvlo joklwkla okv ninyia jarbwng toku. “Mvngdwk mabvka,” hv mintoku, “Hv vjak turdvdu!” ");
INSERT INTO tgj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Vbvrikunamv hv chaakur tvku hogv karchung bv, vtwng nga pimwkto, okv dvtoku. Bunu hum lvkobv awgo raami siro koching bv, Doonyi vka poklin dvkubv, Paul vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bunu naatoku vmi yaapa anga turdubv naam lo chaagv toku okv mvnwng ngv hinging nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ngonu svpwbv vngcho yala vngtoku okv Assos lo aalwk tvvto hoka ngonu Paulnyi svpwlo vnggv tvvto. Hv ngonua sibv ritokv vla mintoku, ogulvgavbolo hv hoka kvdwbv vngtvtvto. ");
INSERT INTO tgj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Vdwlo hv ngonua Assos lo paami sipvkudw, hv svpwbv vnggla okv Mitiline lo aagv toku. ");
INSERT INTO tgj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ngonu hokv gvngv durapla okv Kios lo logo nvnga aachi toku. Alu gonvgv kochingbv ngonu Samos lo aatoku, okv ho alu ngonu Miletus lo aachitoku. ");
INSERT INTO tgj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul svpw lokv Epesus nga vngbo dubv mvngtoku, Asia mookulo dwa nyemu manam lvkwngbv. Vdwgo rinyupvdw, hv Pentikos alulo Jerusalem lo baapu alvbv aalwk dvkubv vla. ");
INSERT INTO tgj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus lokv Paul Epesus lo gaam go milwkto, Gvrja gv nyigagatv vdwa ninyi kaarwk sudubv mintoku. ");
INSERT INTO tgj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bunu vdwlo aachi tokudw, ninyi bunua mintoku, “Nonuno chindu oguaingbv ngoogv dwa nonu gvlo lvkobv rilariya kunama, Asia mooku lo ngoogv atuake bv aalwkri alu lokv. ");
INSERT INTO tgj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Jius nyi meegonv nga rinyingriruto okv nga achialvbv mvngdwkmvngku okv hirukaaya moto. Vbvritola ngo mvngdwkla nyikla sarla okv nyanyak alvbv Ahtu gv lvgabv ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nonuno ho chindo ngo oguguka mvngtung mabv minjito nonu gvbv alv jinvgo okv mvngtoku mvnwng gvbv okv nonugv naam gvbv. ");
INSERT INTO tgj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jius okv Jentail vdwa ngo dinchi rungbv gamrw jitoku bunu atugv rimur am mvngdin lakula Pwknvyarnv gvloku okv ngonugv Ahtu Jisunyi mvngjwng dvkubv. ");
INSERT INTO tgj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Okv vjak, Darwknv Dowa tvvla kuju ngo Jerusalem bv vngjikunv, ngo chinsuma ogugo alo ririkudw. ");
INSERT INTO tgj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ngo mvngchik chindu ho pamtv mvnwng lo Darwknv Dowv gamrw toku nga ho patwk lo dosv nga okv ngoogv hirukaya svngaka. ");
INSERT INTO tgj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Vbvritola ngo atugv singdung nga oguka mvngsuma; ngoogv mvngnam mvngchik vv ho Ahtu Jisu nga ritokv vla jinama, Pwknvyarnv gv anyuaya lokv Alvnv Yunying nga rinyadoonya dukubv mvngmwng dunv. ");
INSERT INTO tgj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ngo Pwknvyarnv gv Karv nga nonu mvnwng gv, pingkolo vngkarla japji kartoku. Okv vjv ngo chinduku ho nonuno nga lvkoka kaapa kumare. ");
INSERT INTO tgj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Vkvlvgabv ngo silu gv alu lokv nonuna jvjvklvbv mirw doonv la: Vdwlo nonu akonvka nyenam goka dubolo, ngo ogugoka nonu lvlo ajv laya kumare. ");
INSERT INTO tgj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ngo Pwknvyarnv gv nonua chinsv gui vla mvngnam ogumvnwng nga nonua minji pvkunv. ");
INSERT INTO tgj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Vkvlvgabv nonu atubongv chvrv bv kaala dosutvka okv Darwknv Dow gv nonua svlar kaaria dubv jinam vdwaka. Pwknvyarnv gv goklin kunam nyi vdwa rigv nvgobv ritokuka, hv ninyigv atubogv kuunyilo gv oyi lokv ninyigvbv mvpv kunv. ");
INSERT INTO tgj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ngo chindo ho ngoogv vngrokochingbv, nonugv pingkolo nyi vv busunam svcha jvbv rinv ngv aari nvpv okv gwngkw rinvpv nonua domumare. ");
INSERT INTO tgj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dwv aari kunvpv noogv atubogv nyi lokv, vnggv rikunvpv mvngjwngnv vdwa bunugv koching bv. ");
INSERT INTO tgj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Vkvlvgabv bununo atuv hindum silaka! mvngpa laka ngoogv nam doomadakma bv nyiksinyikla dwkla nyingum go ho aluayu bv nonu mvnwng nga okv akinakin bv minpv nama. ");
INSERT INTO tgj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Okv vjak ngo nonuam Pwknvyarnv gv ringnam lo okv ninyigv ayanv doin lo tulwk jidunv, si nonua gwlwk am jiriku okv Pwknvyarnv gv anyuaya kunam ninyigv nyi mvnwng nga jiriku. ");
INSERT INTO tgj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ngo vdwloka mvngma dvnv Yvvgvloka morkoain go okv vji vbego. ");
INSERT INTO tgj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nonuno chindo oguaingbv ngo kudungkua ridudw ngoogv atugv laak lokv atubongv svngsu dubv okv ajin vdwaka. ");
INSERT INTO tgj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ogumvnwng nga ngo ritoku, ngo kaatamto oguaingbv ridur svngvdw ngonu heema nvnga ridur svvgorung. Mvngpa laka ngonugv Ahtu Jisu gv gaama ninyi atubongv minto, ‘Jinam si laanam amamsvnga mvngpu yadunv.’” ");
INSERT INTO tgj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paul ninyigv minyaro koching bv, hv lvbwng lokv kompv tvla nyi mvnwng nga okv kumtoku. ");
INSERT INTO tgj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bunu mvnwng ngv kapnya toku okv chvgap toku okv mopup tvku ninyia. ");
INSERT INTO tgj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bunu mvnwng ngv mvngru nyatoku ogulvgavbolo Paul bunua mintoku, “nonuno nga vdwloka lvkodv kaapa kumare.” Vkvlvgabv bunu ninyia svpwlo vnglwk minggv toku. ");
INSERT INTO tgj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ngonu bunua alvbv doolakukv vpi kula vngyu toku. Ho koching bv sidakala bv durapla, Kos lo ngonu raplwk toku; logo nvnga ngonu Rodes lo vngchi toku, okv hokv ngv ngonu vngdavngrala Patara bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ngonu hoka svpw go Poenesia bv vngjinvgo paatoku, vkvlvgabv ngonu hoka aalwk la vngdavngra toku. ");
INSERT INTO tgj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ngonu Saipras bokpin am kaapa dukubv aato, okv vbvrikunamv yorko kiambv dulu la Sairia lo aatoku. Ngonu Taire gv svgambv vngto ogulvgavbolo svpwlo gvvnama hoka gvvpv dokubv. ");
INSERT INTO tgj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ngonu hoka mvngjwngnv nyi meego kaapa minsu la okv bunua lvkobv alu kanwgo doobamto. Bunu Darwknv Dow gv jwkrw lokv Paulnyi Jerusalem bv vngma bvkv vla minto. ");
INSERT INTO tgj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Vbvritola bunua lvkobv ngonugv doobam namgv dwv vngnya kunamv, ngonu vngyu tokula okv atugv lamtv bv vngtoku. Bunu mvnwng gv, nywng kuu mvnwng ngv lvkin gobv, ngonua lvkobv pamtv agum bv vnglintoku, hoka ngonu mvnwng ngv isi agum lo lvbwng kumpv tokula kumbam toku. ");
INSERT INTO tgj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Vbvrikunamv ngonu asakv alv bvkv vmi sopi kula, okv ngonu svpwlo aatoku okv bunu naam bv vngkur nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ngonu atugv svpwlo vngdungla, Taire lokv Ptolimais lo dulin toku, hokaku ngonu mvngjwngnv vdwa alvbv raami solaku okv bunua lvkobv alu logo bv dooming gvvto. ");
INSERT INTO tgj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Alu gonv nga ngonu vnglaku okv Kaisaria lo vngchi kunam. Hoka ngonu ebenjelist Pilips gv naam lo dooto, hv Jerusalem lo nyi kanwgo riduryanv gubv darlin kunam lokv akonv. ");
INSERT INTO tgj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ninyi gvlo nyibu vngmadvnv Pwknvyarnv gv doina japgo yanv umvnyijar api go dooto. ");
INSERT INTO tgj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ngonu hoka alu mvngchikgo dookunamv Agabas vnam nyijwk go Judia lokv aalwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Hv ngonu dookulo aato, Paul gv hok am naala, hv atugv lvpa laak lo um leelwk sutola okv minto, “So svbv Darwknv Dowv mindo: Soogv hok atua Jerusalem lo Jius nyi vdwv vbv leeri, okv bunu ninyia Jentail nyi vdwgv laak lo laklwk riku.” ");
INSERT INTO tgj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Vdwlo ngonu sum tvvpanamgola, hoka ngonu la kvvbi vdwv Paulnyi Jerusalem bv vngma bvkv vla kumla minto. ");
INSERT INTO tgj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Vbvritola hv mirwksito, “Nonu ogubv svbv kapnyarinya la ngoogv haapok ka mvngdwk modunv? Ngo Jerusalem mvngchik lo leemwng koodubv mvngma vbvritola hoka ngo Ahtu Jisu gv lvgabv sidubv mvngta dunv.” ");
INSERT INTO tgj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ngonu ninyia mintap nyumato, vkvlvgabv ngonu topu tokula, “Ahtu gv mvngnam bv rila kuka.” ");
INSERT INTO tgj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kochingso hoka meego ripikula, ngonu atugv yikungyira nga mvgemvrap tokula okv Jerusalem bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kaisaria lokv lvbwlaksu meego ngonua vngming gvvto okv ngonugv lvkobv naam doojiku ninyigv naam bv ngonua vnggv toku—Mnason, Saipras lokv, hv kvvlogv lokv mvngjwng nvgobv rinv. ");
INSERT INTO tgj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Vdwlo ngonu Jerusalem lo vngchi tokudw, mvngjwngnv nyi vdwv mvngpu nyala ngonua alvbv aamuto. ");
INSERT INTO tgj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Logo nvnga Paul Jemsnyi kaabv ngonua lvkobv vngming gvvtoku; okv gvrja nyi nyigagatv vdwv mvnwng ngv lvkobv rinya kunam. ");
INSERT INTO tgj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul bunu mvnwng nga alvbv kaarwk sito okv ninyigv lokv Pwknvyarnv oguaingbv Jentail vdwgv pingkolo ripvkudw um mvnwng nga bunua mimpa jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Hvkv gvlo tvvronam kochingso, bunu mvnwng ngv Pwknvyarnvnyi hartv nyatoku. Vbvrikunamv bunu minto, “Achiboru Paul, no kaakw tvka vdwnvgo hejarhejar Jius nyi vdwv mvngjwng nvbv rinya dukunv, okv bunu mvnwng ngv achialv bv Pvbv ngaka mvnggap nyadunv. ");
INSERT INTO tgj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bunu vbv chimpa duku no Jius nyi mvnwng nga Jentail vdwgv mooku lo rinv doonv vdwa Moses gv Pvbv nga topu dukubv tamsar duku, bunua umvuu vdwa ayakmvu kuma dvbv okv Jius vdwgv krimklu gv ridungdodung nga riming gvvku madubv minduku vla tvvpa nyapvku. ");
INSERT INTO tgj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bunu noogv so aalwk nama tvvpa rungriku. Vbvrikunamv ngonu ogugo risv ngvkudw? Vbvritola, ogugo rinam ngaka? ");
INSERT INTO tgj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ngonu nam svbv risv go vla mvngdunv. So sika nyi api go milvminsu tvla dopvnv. ");
INSERT INTO tgj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bunua lvkobv vngnyika okv mvdurridur kolo aapwng minggv laka okv bunugv rijo minjo nga joji tvka; vbvrikubolo bunu bunugv dwmw am mwkga sito. Vbvrila mvnwng ngv chinriku bunugv nam minam lo ogu jvjv go dokumanyi vla, vbvritola bunu nonua Moses gv Pvbv lo doobwng dvnvnyi vla chiya rikunv. ");
INSERT INTO tgj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Vbvritola Jentail mvngjwngnv vdwa yugwngmvrwng lo lwknam dvnamtvngnam okv oyi ngaka okv oksarnam svnwngsvmin ngaka dvku madubv, okv bunua yoomur minsu madubv ngonu mimpv kunv vla bunua siti lo lvkla pau pvkunv.” ");
INSERT INTO tgj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Vkvlvgabv Paul logo nvnga nyi vdwa vnggv laku, bunua mvdurridur kolo lvkobv rimutoku. Vbvrikunamv hv Pwknvyarnvnaam lo vngtoku okv bunu mvnwng gv lvgabv mvdurridur kunama vdw lonyi bunu akinakinv risvmvsv ngvdw um minggo jito. ");
INSERT INTO tgj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Vbvritola vdwlo alu lokkanwv vngnya tvku namv, Asia mooku lokv Jius nyi meego Paulnyi Pwknvyarnvnaam lo kaapa toku. Bunu nyitwng nga nvngyak nvngpak la okv Paulnyi naatung toku. ");
INSERT INTO tgj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bunu goknyato, “Israel gv nyi vdwa!” “Ridurto! So nyi angv si mooku lo vngkarla nyi mvnwng lo Israel nyi vdwa okv Moses gv Pvbv aka okv so Pwknvyarnvnaam am miyakaya la tamsar sargonv. Okv vjak hv Jentail meegoka Pwknvyarnvnaam so aagvla darwknv naam am darwk madubv mvdu!” ");
INSERT INTO tgj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Bunu svbv minam si ogulvgavbolo bunu Epesus lokv Tropimusnyi Paul gv lvkobv pamtv lo ridubv kaato, okv bunu mvngtoku Paulnyi Pwknvyarnvnaam lo aagv pvnv vla.) ");
INSERT INTO tgj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tvvbwktvlo kumanam lokv pamtv mvnwng lo dupwng toku, okv nyi vdwv lvkin gobv jokbam nyala, Paulnyi naatungto, okv ninyia Pwknvyarnvnaam agum bv tunglin nyato. Okv Pwknvyarnvnaam gv agi vdwa vjakpigobv koktum nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nyitwng ngv Paulnyi mvki dubv gwngto, vbvrikunamv Roman sipai kamandar lo yunying ngv aatoku Jerusalem mvnwng lo yalungyachung bv ridu vla. ");
INSERT INTO tgj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Vjakpigobv kamandar angv nyigam meego okv sipai twnggo naalaila nyitwng apam lo juklu toku. Vdwlo nyitwng ngv ninyia sipai atwng am kaapa tokudw, bunu Paulnyi jvngkumato. ");
INSERT INTO tgj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kamandar angv Paul dokubv aato, okv ninyia naatung toku, okv ninyia jaako sonyi go leedu kubv milin toku. Vbvrikunamv hv tvvkato, “So nyi si yvvla, okv ninyi ogugo ripvla?” ");
INSERT INTO tgj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nyitwng apam lokv meegonv ogugo goknyato, kvvbi vdwv aku subv goknyato. Hoka ho vkvnv abwkalo kuma bv rikunamv Kamandar angv kaabwk nyumato ogugo ripvnvdw, vkvlvgabv hv ninyigv nyi vdwa Paulnyi sipai naam lo vnggv dukubv minto. ");
INSERT INTO tgj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bunu ninyia baatunglo vngchi minggv toku, okv vbvrikunamv sipai vdwv ninyia jootoku vkvlvgavbolo nyitwng ngv iki svrv bv rinyato. ");
INSERT INTO tgj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bunu mvnwng ngv ninyigv kochingbv aaming gvvtola, “Ninyia mvkito!” vla goknyato. ");
INSERT INTO tgj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Sipai vdwv Paulnyi sipai naam arwngbv aagv tvvrilo, hv kamandar anga minto: “Ngo nam gaam lo gamgo minla ridw?” “No Grik gaambv minto, no minyure?” Vla kamandar angv tvvkato. ");
INSERT INTO tgj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Vbvrikunamv no kvvlo kvcho gv Ijipt nyi ako yalungyachung dula hejar api alvmanv nyi go rigvla chukrimooku lo riram la ramgvnv angv mai?” ");
INSERT INTO tgj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul mirwksito, “Ngo Jius nyi ngv, Silisia gv Tarsus lo bvngnamv, Pamtv kai nvlo doonv ngv. Ayala nga nyi vdwa gaam japmu labv.” ");
INSERT INTO tgj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kamandar angv ninyia japdubv jitoku, vkvlvgabv Paul baatung lo dakpv tvla ninyigv laakv nyi vdwa choi bvkv vla minto. Vdwlo bunu choi bv dooto kudw, Paul bunua Hebru gaambv japtoku: ");
INSERT INTO tgj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ngoogv Israel ajin vdwa, ngo atuv mvngging sula minam sum nonu tvvria jilabv!” ");
INSERT INTO tgj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Vdwlo bunu ninyia Hebru gaambv japdubv tvvto kudw, bunu abuyayabv choi nyatoku; okv Paul japwngla japjuk paying toku: ");
INSERT INTO tgj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ngo Jius nyi vkv, Silisia gv Tarsus lo bvngnamv, vbvritola Jerusalem lo Gamaliel gvlo puri rila singcha toku. Ngo paato abuapa vdwgv alvbv Gamki pvvnama, okv silu so doodunv nonugv asar alvbv Pwknvyarnv gvlo tulwk sunam aingbv rito. ");
INSERT INTO tgj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ngo so lamtv lo vngming gvnv nyi vdw ngaka pakipamar la sidubv mvtoku. Ngo nyimv jvka okv nyilo jvka naatungla okv bunua patwk arwnglo tumlwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nyibu butvyachoknv okv kvba nyi mvnwng ngvka chinyadu ngoogv minam si jvjvbv mindunv vla. Ngo bunugv lokv Damaskas lo jius ajin vdwa siti lvknam am naarwksito, vkvlvgabv ngo bunua naatungla Jerusalem lo boolwkla rvngja lokv leeto la mvritririt dubv vla vngto. ");
INSERT INTO tgj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ngo vngdungla okv Damaskas lo aachi svlv nga, alo lopo dvsv nga Nyidokolo gvngv dvminmabv dooriak go nga riakyum toku. ");
INSERT INTO tgj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ngo kvdw bolo gipv toku okv gaamgo nga, ‘Sol Sol! No nga ogubv mvdwmvku dunv?’ Vla mindubv tvvpato. ");
INSERT INTO tgj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ngo tvvkato, ‘Ahtu, no yvvla?’ ‘Noogv mvdwmvku namv, ngo Najaret gv Jisu kv,’ hv nga vbv minto. ");
INSERT INTO tgj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nga lvkobv vngnv nyiga vdwv loung ungnama kaapa minggvto, vbvritola yvvka nga gaam japnam am tvvpa manyato. ");
INSERT INTO tgj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ngo tvvkato, ‘Ahtu, ngo ogu ridukubv?’ Okv ahtu nga mintoku, ‘Gudungto okv Damaskas bv vngnyika, okv Pwknvyarnv gv no lvgabv mvngnam am no ogu risv ngvdw hoka ogumvnwng nga nam mimpariku.’ ");
INSERT INTO tgj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Loung ngv achialv bv ungkanam lvgabv ngo nyikching toku, okv vbvritola ngoogv vngbam ajin vdwv ngoogv laak am svvbwng tola Damaskas lo aalwk gvvtoku. ");
INSERT INTO tgj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ho pamtv lo nyi ako dooto vkvgv aminv Ananias, hv dormo nyi go ngonugv Pvbv ngaka riming gvnv go okv hoka Jius nyi mvnwng ngv kaibv mvngdv namgo. ");
INSERT INTO tgj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Hv ngo gvlo aato, ngoogv nvchilo daktola, okv minto, ‘Boru Sol, lvkodv kaadvto!’ Hokaku ngo kaapa toku okv ninyi nyika kaatoku. ");
INSERT INTO tgj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Hv mintoku, ‘Ngonugv abuapa vdwgv Pwknvyarnv ngv nam darlinto ninyigv mvngnam nga chimu dubv, ninyigv darwkchongjornv pakbu gubv kaamu dubv, okv ninyigv atu gaambv japrinyi ninyia tvvmu dubv. ");
INSERT INTO tgj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","No ninyigvbv kaariatvvria nvbv ririku mvnwng nga mimpa dukubv okv ogugo no kaapv tvvpv kudw. ");
INSERT INTO tgj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Okv svjv, ogu gonyi doyadunv? Gudungto okv baptisma naalaku okv noogv rimur am sokga lakuka ninyia kumgv riku laka.’ ");
INSERT INTO tgj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ngo Jerusalem bv vngkur toku, okv vdwlo ngo Pwknvyarnvnaam lo kumrilo, ngo nyikrwgo kaato, ");
INSERT INTO tgj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","hoka ngo Ahtunyi kaapato, hv nga vbv minto, ‘baapu alvbv okv Jerusalem am vngyu datoku, ogulvgavbolo so gv nyi vdwv noogv ngo lvkwngbv minam am tvvmare.’ ");
INSERT INTO tgj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","‘Ahtu,’ Ngo mirwksuto, ‘Bunu alv rungbv chindo ho ngo Jius kumkunaamlo vngla okv yvvdw nam mvngjwngnv vdwa naatung la dvngnama. ");
INSERT INTO tgj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Okv vdwlo noogv kaariariria nvbv rinv Stipinnyi mvki rilo ngo atuv hoka doosuto, ninyigv gwngrw bv sinama alv nvgobv mvnglwk riato okv ninyi gwngrw gwnv vdwgv vji a doogv riato.’ ");
INSERT INTO tgj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ahtu nga minto, ‘Vngnyilak,’ ‘holvgabv nam ngo Jentail vdwgv dooku adugolo vngmure.’ ” ");
INSERT INTO tgj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nyi vdwv Paulnyi vbv mindu kubv tvvria nyatoku; vbvritola bunu goktv rungbv bunugv goknam am gokrap nyatoku, “Ninyia lvkobv adu tvkuka! ninyia mvkito! ninyi singdu kubv rikuma!” ");
INSERT INTO tgj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bunu mvnwng ngv goknyato, vjia lwnglolwnglv karla okv, achuaya nga doori aulo jukar dubv taakar nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Roman kamandar angv atugv nyi vdwa Paulnyi sipai naam arwng lo boolwk tvkv vla orto jitoku okv bunua minto ninyia svnyak patola ogulvkwngbv Jius vdwv ninyia svbv goknya dunvdw um tvvlinto. ");
INSERT INTO tgj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Vbvritola vdwlo bunu ninyia svnyak padubv vla leeto kudw, hoka nyigam daknv anga Paul minto, “Svkvnv si noogv pvbv lo Roman nyi am ogu rimur go rima jvka leetola svnyak padubv doorung pvnvre?” ");
INSERT INTO tgj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Vdwlo nyigam angv ninyia vbv mindubv tvvto kudw, hv orto jinv nyigam gvlo vngtoku okv ninyia tvvkato, “No ogugo ridunv? Alo nyi angv Roman nyi gulaka!” ");
INSERT INTO tgj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Vbvriku nvngv orto jinv nyigam angv Paul dokubv aatoku okv ninyi tvvkato, “Nga mimpato, no Roman nyi vre?” “V” vvkv Paul mirwkto. ");
INSERT INTO tgj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Orto jinv nyigam angv minto, “Ngo achialvbv ainmorko jila Roman nyi bv rinv ngv.” Paul mirwksito, “Vbvritola ngo bvngyi lokv Roman nyi bv bvngtak linv ngv.” ");
INSERT INTO tgj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Paul ninyia tvvka jinv nyi vdwv vjakpigobv ninyigv kochingbv daksum nyato; okv orto jinv nyigam angv Paul Roman nyi gupv kunyi okv ninyia jaakobv leeto kubv vla mvngdin lakula hv busutoku. ");
INSERT INTO tgj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Orto jinv nyigam angv Jius mvnwng ngv Paulnyi ogubv yalung dupv nvdw mvngla um malinla chindubv mvngtoku; vkvlvgabv logo nvnga hv Paul gv jaako nga paklin toku okv nyibu butv mvnwng nga okv Dopam gv nyi mvnwng nga kaarwk sudubv orto jito. Vbvrikunamv hv Paulnyi aagv toku okv ninyia bunugv atuk lo dakmu toku. ");
INSERT INTO tgj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul dopam lo doonv nyi vdwa kaagap chinchinla minto, “Ngoogv Israel ajin vdwa! ngoogv haang lo Pwknvyarnv gv lvkwng lo kvvlo lokv silu gobv mvngla tulwksula lamtv lo singduridunv si ribwngching bv mvngbwk la ridunv. ");
INSERT INTO tgj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nyibu butvyachok Ananias Paul gv nvchilo daknv vdwa ninyigv gaam nga nwknyato vla orto jito. ");
INSERT INTO tgj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulnyi minto, “Pwknvyarnv ya nam nwkyare! Tanyum gvriabo no! No hoka dootola nga Pvbv lo kaala minjinv, no bunua nga mvtokv vla orto jinv no vjak Pvbv nga mvyak yadunv!” ");
INSERT INTO tgj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Paul gv nvchilo daknv nyi vdwv ninyia minto, “No Pwknvyarnv gv Nyibu Butvyachok am miyakayadu!” ");
INSERT INTO tgj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul mirwkto, “Ngoogv Israel richam vdwv, Ngo ninyia Nyibu Butvyachok nvngv vla chima. Darwknv Kitap lo mindu, ‘Nonugv nyi vdwa rigvnvnga alvmanv gaam mima bvka.’ ” ");
INSERT INTO tgj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Vdwlo Paul Sadusis apam meegonyi okv Parisis kvgonyi kaapa tokudw, hv doopam lokv goklin toku, “Israel gv achiboru vdwa! Ngooka Parisis gvngv, Parisi gv kuu ngv. Nga si jwngkadaka duku ogulvgavbolo sinv ngv turkur dukunv vla mvngjwng kunam lvgalo!” ");
INSERT INTO tgj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ninyia vjakpigobv svbv minda namgola, Parisis vla Sadusis ngv yalung durap minsu lakula okv apam lokv apinain sitoku. ( ");
INSERT INTO tgj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Holvgabv Sadusis vdwv vbv minto sikunv nyi vdwv ho turkur kumare okv hoka ka nyidogindung vla okv dow go kaama dunv; vbvritola Parisis vdwv ho aom am mvngjwng nyadu.) ");
INSERT INTO tgj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Gokyagokya kunamv gamtv yaya toku, okv Parisis lokv Pvbv tamsarnv meegonv daknya tokula okv achibv mintor nyadubv mintoku: “So nyi angv gvlo ngonu ogugoka lvkobv rimur namgo kaapama! Vbvritola dow vla nyidogindung ngv ninyia jvjvklvbv mimu rungdu ka nvpv!” ");
INSERT INTO tgj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Larmi suku nvngv yalung duyak minsu nyatoku hokaku kamandar angv busu toku Paulnyi pamwk kuji mvngla. Vbvrikunamv ninyia orto jitoku ninyigv sipai vdwa apam bolo ila, Paulnyi bunugv lokv svvlinto okv hv sipai naam lo aagvto vtoku. ");
INSERT INTO tgj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ho ayu Paul gv dakku lo Ahtu dakming gvvto la minto, “Busu mabvkv! No ngo gvbv Jerusalem soka minkar jipv, okv Rom loka vbv dvdvbv rilaka.” ");
INSERT INTO tgj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Arugunv nga Jius meegonv lvkobv kaarwk sila okv rungnamgo rungto. Bunu Paulnyi mvkima dvdvlo bunu dvnamtvngnam ogugoka dvku mare vla milv nyatoku. ");
INSERT INTO tgj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Hoka champi lvyagobv doopam tvla lvkobv rungnyato. ");
INSERT INTO tgj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Vbvrikunamv bunu nyibu butv vdwlo okv nyigagatv vdwlo vngla minto, “Ngonuv lvkobv milv pvkunv ngonu Paulnyi mvkima dvdvlo oguka dvmare. ");
INSERT INTO tgj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Vjak vbvrikunamv no okv kvba vdwv Roman kamandarnyi gaam go milwk tvka Paulnyi no gvlo igv modubv, ninyigv lokv mvvma rungmanv yunyingsa paadubv ridunv vla gwngtoka. Vbvritola ninyigv soka aachi madvbv ngonu ninyia mvki chore.” ");
INSERT INTO tgj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Vbvritola Paul gv bormv gv kuunyilo angv mvki dubv gwngnam nga tvvpa tola; vkvlvgabv hv sipai doopamlo vngla kula Paulnyi mintamto. ");
INSERT INTO tgj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Vbvrikunamv Paul nyigam akonyi gokla okv ninyia minto, “So yaapa nga kamandar gvlo aagv jitoka: hvkv gvlo ogugo ninyi minsvgo doodu.” ");
INSERT INTO tgj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nyigam angv ninyia vnggvla, ninyia kamandar gvlo aagv jito, okv minto, “Patwk doonv Paul nga gokla okv nga tvvkala no gvlo so yaapa sum aagv jito vla, ogulvgavbolo hvkv gvlo nam ogugo minsvgo dopvkv vdu.” ");
INSERT INTO tgj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kamandar angv ninyigv laak nga gakbwng tola, hv atubongv ninyia svsum laila, okv ninyia tvvkato, “No nga ogugo minsvgo dopvla?” ");
INSERT INTO tgj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ninyia minto, “Jius tujapkunam vdwv vkvpakv vmisilaku arunyi Paulnyi doopam lo boolwkla nam tvvka dubv vla minya do, kvba ngv hoka ninyigv lvkwng lo tvvkurtvrwk minsu dubv meego chinsv go dopvkv vla gwngre. ");
INSERT INTO tgj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Vbvritola bunua tvvma bvka, vkvlvgavbolo hoka nyi champi lvyago toosila okv ninyigv lvgabv toyado. Bunu ninyia mvkima dvdvlo bunu dvmatvngma dubv milvminsu nyato. Bunu mvnwng ngv um ridukubv vla okv noogv minbwk kuji nama tooyala doonya duku.” ");
INSERT INTO tgj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kamandar ngv minto, “So sum no ngam minjipvnv vla yvvnyika mimpa mabvkv.” Okv hv yaapa anga vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Vbvrikunamv kamandar ninyigv nyigam anyi gunyi goklwkla okv minto, “Kaisaria lo vnggv dubv sipai lvngnyi go mingkumto, lvkobv gora jukya nvlo chamkanw go okv nungbung chilaknv nyi lvngnyi go, okv siyugv kia bajilo vngdubv mvpvripv tokula dooya laka. ");
INSERT INTO tgj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Paulnyi gora lo awgo mvge jito juknv dubv okv gobunor Peliks gvlo alvbv aachi modubv.” ");
INSERT INTO tgj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Orto jinv ngv siti ako ho vbv lvkto: ");
INSERT INTO tgj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Klaudius Laisias mvngdv kunam Gobunor Peliksnyi kumrwksidunv. ");
INSERT INTO tgj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jius vdwv so nyi sum naatung tokula okv ninyia mvki dokubv rinya kunamv. Ho ngo ninyia Roman nyi gobv tvvpatvla, vkvlvgabv ngoogv sipai vdwa lvkobv ngo vnggvla okv ninyia ringpv kunv. ");
INSERT INTO tgj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ngo chinso mvngla bunu mvnwng ngv ninyia ogubv mvduridu nvdw, vkvlvgabv ngo ninyia bunugv kvbadoopam lo igv jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ngo chinkunamv hv sidubv okv patwk lo tumdubv oguka rimur namgo kaama, ninyia gungnying nyiru minam ngv bunu atugv Pvbv lvkwngbv tvvka sunam go. ");
INSERT INTO tgj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Okv vdwlo nga ninyi hoka nyirunv apam go donyapv vla mimpa tokudw, ngo ninyia no gvlo vjakpigobv aagv jidu kubv mvngpv kunv. Ngo ninyia nyirunv vdwa minpvkunv bunugv ninyia gungnying minsv nga noogv kaagia lo minlakv vla.” ");
INSERT INTO tgj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sipai vdwv bunugv orto jilin kunama gvvlin toku. Bunu Paulnyi boola ikula okv ninyia ayuyupra nga Antipatris lobv vnggv toku. ");
INSERT INTO tgj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Logo nvnga lvpabv vngnv sipai vdwv hv bunugv dookulo vngkurkunam okv gora sipai vdwa ninyia lvkobv vngmu toku. ");
INSERT INTO tgj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bunu ninyia kaisaria lo aagv tokula, gobunor hv siti nga jilwk toku, okv Paulnyi ninyi gvlo laklwk kunam. ");
INSERT INTO tgj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gobunor siti nga puri tula okv Paulnyi tvvkato no ogulo mooku gvngv. Ho vdwlo ninyia Silisia lokv vla ninyia tvpakunam gola, ");
INSERT INTO tgj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ninyi minto, “Ngo nam tvvriare vdwlo noogv yalung doonv ngv vngchi bolo.” Vbvrikunamv ninyi orto jilin toku Paulnyi gobunor gv dooku naam gvlo tumlwk tvla sipai dakgv moto. ");
INSERT INTO tgj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Alu longu kochingbv Nyibu Butv Ananias nyigagatv vdwlo meegonyi okv Pvbv chinv ako Tertullus minam lvkobv Kaisaria bv vngla. Bunu Peliksnyi kaarwk chotola okv bunu Paulnyi gungnying milwk toku. ");
INSERT INTO tgj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Vbvrikunamv, Paulnyi goklwk toku, okv Tertullus hvbv gungnying lwkrap toku: “Mvngdvnam nyigam! Noogv chinampanam lokv ngonua rigvla rinamv awgo sarsopoyo toku, okv ngonugv diringmooku gv dinchinam risvvngsv nga alvrungbv ridinvngdin gvpvku. ");
INSERT INTO tgj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ngonu so ogumvnwng nga okv ho dw mvnwnglo alvbv tulwk minggv dvnv, okv ngonu mvnwng ngv nam alvrungbv mvngyum doonv. ");
INSERT INTO tgj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ngo noogv dw nga kaibv ngemu jinwngma, ogubvrijvka, ngo nam kumdunv aya gvrila ngonugv minam achuk am tvvria jilabv. ");
INSERT INTO tgj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ngonu so nyi sum maatarbv alvmanv gobv kaadu; hv mooku mvngnwnglo Jius vdwa yalungyachung duki nvgo okv Najareth gv nyipam vdwa rigvnvgo. ");
INSERT INTO tgj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hv Pwknvyarnvnaam ngaka yarboryache dubv gwngkw nvgo, okv ngonu ninyia nyum naatoku, ngonu ninyia ngonugv Pvbv lokv jwngkadaka dubv mvngto, ");
INSERT INTO tgj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","vbvritola kamandar Laisias aala, okv lvkobv ninyia twkbwng tola ngonugv lokv dvrit linto. ");
INSERT INTO tgj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Vbvrikunamv Laisias orto go jilin toku ninyia gungnying lwknv vdwv noogv kaagialo dakdubv. So nyi sum no tvvkabolo, hv gvlo ogumvnwng nga no atubongv chinsure ho ngonu mvnwng ninyia yalungyachung bv rila gungnying lwknama.” ");
INSERT INTO tgj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jius vdwv gungnying lwknama tulwk minggvto okv minto so mvnwng si jvjv ngv. ");
INSERT INTO tgj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Vbvrikunamv, gobunor Paulnyi mincho moto, okv Paul minto, “So diringmooku mvnwng nga no kaadar yala anying mvngchigo rigvnvnga ngo chindo, okv vkvlvgabv ngo himpudo atubonga no kaagialo mindar chodubv. ");
INSERT INTO tgj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","No atubongv ka chinsu toka, so si alu loring gola lonyi gubvka ritvmadv ho ngo Jerusalem bv kumbv vngto. ");
INSERT INTO tgj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Jius vdwv chimpama nga Pwknvyarnvnaam lo yvvnyika larmisidubv, ho majvka bunu nga Jius kumkunaamlo vmalo pamtv kvvbi loka nyi vdwa charkar dubv kaanv kaama. ");
INSERT INTO tgj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Hv maloka bunugv vjak nga gungnying lwkla bvnglwk nama nam jvjv gorung vla kaalin modubv rinyumare. ");
INSERT INTO tgj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ngooka vjak sum no gvlo tulwk jidunv: Ngooka riming gvvdunv abuapa vdwgv Pwknvyarnv kumnamjonam Lamtv lo bunugv mvvdunv vnam sum. Vbvritola ngooka Moses gv Pvbv okv nyijwk vdwgv kitap vdwlo lvknam mvnwng nga mvngjwng dunv. ");
INSERT INTO tgj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Bunugv akinbv ngooka vbv mvngtin minggv dunv Pwknvyarnv gvlo nyi mvnwng ngv alv nvngvla alvmanv ngv sinam lokv turkur riku vla. ");
INSERT INTO tgj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Okv vkvlvgabv ngo vdwgo rinyupvdw Pwknvyarnv gvla nyi gv kaagialo lokia alvbv ridu mindubv vla mvngdunv. ");
INSERT INTO tgj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Jerusalem am anying awgo riro kochingbv ngo hoka ngo atubogv nyi vdwgv lvgabv morko naadubv okv erinpeelwk jidubv vngto. ");
INSERT INTO tgj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ngoogv vbvrila doori hoka bunu nga kaapato Pwknvyarnvnaam lo ngoogv kumkakjokak ridung nga riro kochingbv. Hoka nga nyitwng lvkobv ribamnam kaama okv ayak achaknam kaama. ");
INSERT INTO tgj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Vbvritola Asia mooku lokv Jius meego hoka dooto; bunu atuv nga rikin nvnv ogugo dubolo no kaagialo aala gungnying lwkdubv. ");
INSERT INTO tgj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Vmalo so nyi vdwa milin moto vdwlo ngo kvba lo dakri hoka ogu rimur go bunu nga kaapa pv— ");
INSERT INTO tgj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","gamkin gumwng ngoogv gokla minamv vdwlo bunugv kaagialo dakri hoka: ‘Silu gv noogv jwngkadaka gvdunam si sinv ngv turkur riku vla mvngjwng nama.’” ");
INSERT INTO tgj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Vbvrikunamv Peliks ho lamtv nga alv rungbv chinto kula tvvka kapak svnga mintor toku. “Orto jinv Laisias vdwlo aachi tokudw,” hv bunua minto, “Ngo nonugv kvba nga japjub jiriku.” ");
INSERT INTO tgj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Hv Paulnyi kaarianv nyigam am orto jitoku ninyia arwng lo vpv dubv, vbvritola aar dubv vpvlaka okv ninyigv ajin vdwaka ninyigv mvngnam am naaji molaka vto. ");
INSERT INTO tgj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Alu meegonv kochingso Peliks ninyigv nywng Jius nyimv, Drusilanyi lvkobv aato. Hv Paulnyi harmu la okv Jisunyi ninyigv mvngjwng namgv lvkwng bv raadung nama tvvriato. ");
INSERT INTO tgj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Vbvritola Paul japdungto alvnam gv lvkwngbv, atuv himv sunam gv lvkwng bv, aarinv tlo jwngkadaka namgv lvkwnglo, Peliks um tvvto kula busu toku okv minto, “No vjak vngla riku okv vdwlo ngo dw paarikudw ngo nam gokkur riku.” ");
INSERT INTO tgj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ho dw akin hoka hv mvngtin tindungto Paulnyi morko lo meego jiri nvpv vla; ho lvkwngbv hv Paulnyi vngdv mola okv lvkobv japdv japdvto. ");
INSERT INTO tgj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Anying nyingnyi vngro kochingso Peliks gv gobunor ritungnga Porsius Pestas ritoku. Peliks Jius vdwa alvbv mvngkiam dubv vla mvngnvgo vkvlvgabv hv Paulnyi patwk lo doomu tvla vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Alu loum koching bv Pestas mooku lo vngchi tokula, nw Kaisaria lokv Jerusalem lo vngtoku, ");
INSERT INTO tgj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ho nyibu Butv vdwvku okv Jius gv rigvdoogvnv vdwv bunu Paulnyi miyum nvbv bookin lwkto. Bunu vdwv bunua ");
INSERT INTO tgj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Paulnyi Jerusalem bv bookarla alvbv mvngkiam dukubv Pestasnyi kootoku, bunu ninyia lamtv vngkulo mvki dubv mvngsi pvvnya toku. ");
INSERT INTO tgj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pestas mirwkto, “Paulnyi Kaisaria patwk lo tumlwk pvvto okv Ngo atubongv alo baapubv vngkur jikunv. ");
INSERT INTO tgj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nyi angv ogugo rimur go doopv bolo okv klai nonugv rigvdoogvnv vdwa ngo lvkobv Kaisaria bv vngming gvvmuto.” ");
INSERT INTO tgj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestas alu piinw vmalo loring gobv bunua lvkobv doobamto, okv vbvrikunamv Kaisaria bv vngtoku. Logo nvgv alua nw kvba nga jwngkadaka dubv doolwk tola okv Paulnyi arwng so aagv tokv vla orto jito. ");
INSERT INTO tgj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Vdwlo Paul aachi namgola, Jerusalem lokv aanv Jius vdwv ninyia dakyamdakchi tola okv ninyia mvngchigo maatar bv gungnying mirap toku, bunu ogu atunggo himpa mato. ");
INSERT INTO tgj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Vbvritola Paul atubongv miring suto: “Ngo ogugoka Jius gv pvbv lo mimur vngmur jima vmalo kumkunaam loka vmalo Roman Dvbvyachok nyika.” ");
INSERT INTO tgj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Vbvritola Pestas Jius vdwgv yabv alvbv mvngkiam yatola, vkvlvgabv nw Paulnyi tvvkato, “No Jerusalem bv vngnwng yapv ai okv alo nga dakcho tola yalung nga mindar chodubvre?” ");
INSERT INTO tgj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul minto, “Ngo Dvbvyachok gv atuk si atugv kvba lo jwngkadaka kodubv dakda pvnv, ngo ogolo mindar sudubv. Ngo Jius vdwa rigakpanam go rijima, no atubongv ka alvbv chindu. ");
INSERT INTO tgj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ngo pvbv nga rigakpanam go rilo okv sikorgo ripv lo vbv rilo ngo sidukubv busukano kaama, ngo toosi sikar dukubv um tvvkaram. Vbvritola bunugv nga gungnying lwknam lo ogu jvjv nvgo kaama bolo, yvvka nga bunugv laaklo laklwk nyumare. Ngo Dvbvyachok gvlo tulwk jidukunv.” ");
INSERT INTO tgj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Vbvrikunamv Pestas, kochingso ninyigv minsaryanv vdwlo lvkobv tvvdikaying minsu gvila, mirwkto, “No Dvbvyachok am tulwk jipvku, vkvlvgabv no Dvbvyachok gvlo vngrung riku.” ");
INSERT INTO tgj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Dw meego nvgv kochingso Dvbv Agrippa okv Barnis bunyiv Pestasnyi Kaisaria lo alvbv kaarwk sinyato. ");
INSERT INTO tgj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bunu kochingso hoka alu meego doonya tola, Pestas Paul gv rinamdoonam nga dvbvnyi mintamto: “Alo patwk doonv nyi angv vv Peliks gv topu namgo doopv; ");
INSERT INTO tgj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","okv vdwlo ngo Jerusalem bv vngto namv, Jius nyibu butv vdw okv nyigagatv vdwv ninyia aagv tvla gungnying lwkto okv nga minto ninyia miyakaya tvkv vla. ");
INSERT INTO tgj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Vbvritola ngo bunua minto nyi akingunv nga ninyia haaknv nyi vdwa kaarwk sula okv ninyi gungnying lwknam am mindar simu mabv jilwk mvngchik namv Roman gv ribu Pvbv bv rima vla minto. ");
INSERT INTO tgj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Vbvrikunamv, vdwlo bunu so aato kudw, ngo tapv mato, vbvritola alu logo nvnga ngo kvbanaam lo dooto okv nyi anga arwng aagv dubv orto jito. ");
INSERT INTO tgj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ninyia nyirunv vdwv dakrap toku, vbvritola bunu ninyia ngoogv rirung pvnvgo vla mvngnam gungnying akoka milwk mato. ");
INSERT INTO tgj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bunu mvnwng gv larmi sunamv bunugv kumnamjonam gv lvgabv okv Jisu vnam sikunv nyi angv gv lvgabv ninyia larkwng minsu namgo; vbvritola Paul ninyia turpv nvkv vla minto. ");
INSERT INTO tgj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ngo svkvnv aba lvkwng bv oguaingbv naalin svngvdw vla mvngbwk nyumato, vkvlvgabv ngo Paulnyi bunugv gungnying lwknv vdwv soogv lvgabv Jerusalem lo chaadu kula tvvdarkadar kusvdw vla tvvkato. ");
INSERT INTO tgj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Vbvritola Paul madwkrwkla maato; hv orto jito chigudabia yanv gv arwng lo doomu dubv okv dvbvyachoknyi so yalung sum jwngkadaka modubv. Vkvlvgabv ngo ninyigvbv milv jidunv chigudabia yanv arwng lo doomu dubv ngoogv ninyia Dvbvyachok gvlo vngmuma dvdvlo.” ");
INSERT INTO tgj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa Pestasnyi minto, “Ngo tvvnwngdo so nyi sum ngoogv mvngwngbv.” No arunyi tvvpare ninyia, Pestas mirwksito. ");
INSERT INTO tgj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Alu gonv nga Agrippa okv Barnis bunyi kairungnv gubv dwkdwkvrwkbv rila hardv alvbv okv mvkukrikuk jila okv tvvriaku naam arwnglo sipai kai yachok nvnga lvkobv okv pamtvlo rigvnv vdwaka lvkobv aalwk gvvtoku. Pestas orto jito okv Paulnyi aagv toku. ");
INSERT INTO tgj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pestas minto, “Dvbv Agrippa, okv ngonua soka doming gvnv mvnwng nga: no kaatoka so nyi sum yvvbunudw gungnying lwknv jius vdwv Jerusalem lo okv soka ka gamtv alvbv goklin yayala nga mindu turmu dvbv anyung kaama vla. ");
INSERT INTO tgj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Vbvritola ngo chindu hv ogugoka rimur kaama ninyi simu dubv. Okv hv atubongv alvbv Dvbvyachoknyi masubolo, ngo ninyia vngmu dubv mvngbwk dukunv. ");
INSERT INTO tgj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Vbvrilachin ngo oguka lvkbwklvkrwkla Dvbvyachoknyi jisv kaama ninyigv lvkwng lo. Vbvritola ngo aagv pvnv nonugv pingko so—okv Dvbv Agrippa!—no gvlo dinchirungbv aagv pvnv! Ninyigv gungnying nga japro kochingbv, ngo ogugo lvkpa ridw mvngla. ");
INSERT INTO tgj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Si asarma ogulvgavbolo patwk tumnam nyi am oguka jwngkadaka mabv vngmu namv alvma mvngla.” ");
INSERT INTO tgj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa Paulnyi mintoku, “No atuv atubogv lvkwng lo minsu tvka nam dwa jidukunv.” Vbvrinamv Paul laakv iyinla okv atubongv mvngging sula vbv mintoku: ");
INSERT INTO tgj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Dvbv Agrippa! ngo silu atubongv gamdak nvgobv mvngsudunv ho ngo atuv noogv kaagialo mvngging sula Jius vdwgv nga gungnying lwknam lokv, ");
INSERT INTO tgj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","no Jius mvnwng gv ridungsingdung nga jvjvbv chirungdo okv yalungyachung nga. Ngo nam lvbu doonv, vbvrikunamv, nga tapvbv tvvriato. ");
INSERT INTO tgj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Jius mvnwng ngv chinto oguaingbv ngo singpvdw yaapa rilo gv singcha nama. Bunu chinto oguaingbv ngoogv singyisingcha nga singcha pvkudw atubogv diringmooku lo okv Jerusalem loku. ");
INSERT INTO tgj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bunu chinbwng nyadu, um bunu vdwv mvnggv ila milare, ngo ho atuk lokv achialvbv riming gvvdu ngonugv kumnam Parisis dormo nga. ");
INSERT INTO tgj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Okv vjak ngo si dootola gwngkw dunv ogulvgavbolo ngonugv abuapa vdwa milv nama ngo mvngtinla— ");
INSERT INTO tgj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","alv rungnv hoka vringgola anyi haalung gv ngonugv nyi vdwv paare vla mvngtinto, bunugv Pwknvyarnvnyi ariumarubv kumnam lokv. Okv si ogulvgavbolo so mvngtin kolo, ho Dvbv Agrippa, nga Jius vdwv ho rinyingriru nyato. ");
INSERT INTO tgj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ogubv nonu mvnwng ngv sum mvngjwngmanv gobv ridunv Pwknvyarnv sinam lokv turdu kunv vla? ");
INSERT INTO tgj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ngooka achialvbv mvngtoku ngo ogumvnwng nga gungnying milwk torungto Jisu Najaretnyi. ");
INSERT INTO tgj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Vkvlvgabv Jerusalem lo ngo ritoku. Ngo Nyibu butv gvlo paatoku gwlwk am okv Pwknvyarnv gv nyi vdwa awgo patwk lo tumlwkto: okv vdwlo bunua mvki pvkudw ngooka mvnglwk minggvto. ");
INSERT INTO tgj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Achialv dwgo ngo bunua mvritririt motoku Jius kumkunaamlo okv bunua atugv mvngjwng am mvngnwng madubv gwngkwto. Ngo ho achialvbv haachi toku bunua ngo nyebumooku pamtv loka vngtoku bunua mvdwmvku dubv. ");
INSERT INTO tgj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ngo sikv lvkwng bv ho Nyibu Butv gv orto jinam lokv okv Damaskas bv tujupkunam gv lvkobv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ho Dvbv Agrippa nga, ho lamtv alulvpa hoka, ngo loung go kaapato doonyi loung aka hongya nvgo, nyidokolo lokv nga hongyumto okv nga lvkobv vnggvnv nyi vdwaka. ");
INSERT INTO tgj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ngonu mvnwng ngv gipv toku kvdwlo, okv ngo tvvpa toku adugo nga Hebru gaambv minvgo, ‘Sol, Sol! no nga ogubv mvdwkmvku doonv? No atubongv achi dubv mvkur sudu noogv mvnam lokv, Svv hvpu ngv soonv atugv singkio nga dusunv aingbv.’ ");
INSERT INTO tgj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘No yvvla Ahtu?’ Ngo tvvka toku. Okv Ahtu mirwk sito, ‘Ngo Jisu, ho noogv mvdwmvku kunam. ");
INSERT INTO tgj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Vbvritola godung lakuk okv noogv lvpa lokv dakto. Ngo noogv dooku si aapvnv nam ngoogv pakbu gobv mvdubv. No kvvbi ngaka mimpa laka ogugo kaapvdw silu ngokvlo okv ngo nam ogugo kaatam rikudw aarinv dw lo. ");
INSERT INTO tgj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ngo nam ringriare Israel gv nyi vdwlokv okv Jentail lokv, ngo bunu gvlo nam vngmure. ");
INSERT INTO tgj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","No bunugv nyik am nyikpo molaka okv kanvparum lokv pualo limu lakuka okv Uyudvbv gv gwlwk lokv Pwknvyarnv gvloku, vkvlvgabv bunugv nga mvngjwng lokv bunugv rimur am mvngnga jiriku okv Pwknvyarnv gv darkunam nyi vdwa lvkobv bunugv dookudakku am naarwk siriku.’ ");
INSERT INTO tgj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Dvbv Agrippa, ngo nyidomooku nyikrw kaanama tvvmabv rimato. ");
INSERT INTO tgj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ahtua Damaskas lo okv Jerusalem lo okv Judia mvnwng lokv, okv Jentail vdwlo ngo tamsarto bunu mvnwng nga bunugv rimur lokv mvngdin dokubv okv Pwknvyarnv lo aakur dukubv okv ogugo ripvdw um kaatam riku bunu mvngdin pvku vla. ");
INSERT INTO tgj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Si svkvlvkwngbv Jius vdwv nga naatungto vdwlo ngo Pwknvyarnvnaam lo doori lo okv bunu nga mvki dubv gwngnyato. ");
INSERT INTO tgj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Vbvritola sibv riri alu lo Pwknvyarnv nga ridur toku, okv Vkvlvkwngbv ngo si daktola mvnwng nga kaatam doonv jvjv nga, kai dvlo okv miang dvlo. Ngoogv ogugo mimpvdw lvyin akindu nyijwk am okv Moses gv minamv rirung duku: ");
INSERT INTO tgj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kristo ho hinching rungre okv atukchochuk bv hv sinam lokv turkur riku, dupwng riku loung gv turnama Jius okv Jentail vdwlo.” ");
INSERT INTO tgj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paul atubongv sibv miring sitoku, Pestas ninyia gokto, “No siru dooku, Paul! Noogv kaibv chinamv nam siru mopvku!” ");
INSERT INTO tgj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paul mirwk sitoku, “Ngo siruma, noogv kairungnv! ngo jvjvrungbv mindunv. ");
INSERT INTO tgj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Dvbv Agrippa! ngo nam mvngrw alvbv milare, ogulvgavbolo no so lvkwngbv chindu ngo mvngrungdo no bunu mvnwng nga chimpv kunvpv, ogulvgavbolo si chvnyung baarwnglo rinam kaama. ");
INSERT INTO tgj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Dvbv Agrippa, no nyijwk nga mvngjwng dunvre? Ngo chindo no mvngjwngdu!” ");
INSERT INTO tgj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa Paulnyi minto, “Soogv dw achuklo no nga kristan mvdubv mvngdunvre?” ");
INSERT INTO tgj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","“Dw v achuk jvka vmalo awjvka,” Paul mirwksito, “Ngoogv Pwknvyarnvnyi kumdunv si no okv mvnwng ngv yvvbunudw ngam silu tvvria dunv ngo jvbv—riming gvvre, rvngja mvngchik ka gvvmare!” ");
INSERT INTO tgj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Vbvrinamv Dvbv, gobunor, Barnis, okv kvvbi mvnwng vka dakrap toku, ");
INSERT INTO tgj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","okv vngrokochingbv bunu ajinanying am mimisitoku, “So nyi angv sum ninyia mvki dubv vmalo patwk lo tumdubv ogu rinam jego kaama.” ");
INSERT INTO tgj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Okv Agrippa Pestasnyi minto, “So nyi sum topu pvkunvpv vdwlo hv Dvbvyachok am dinchi rungbv lvbu manv guilo.” ");
INSERT INTO tgj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Vdwlo bunu Itali vngdubv mimbwk pvkudw, bunu Paul nyila okv patwk lo doonv kvvgonyi “Roman Rejiment um Dvbvyachok gv Rejiment vla minto ho gv nyigam amin Julius gvlo jilwkto.” ");
INSERT INTO tgj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ngonu Adramitiam lokv vngto hoka svpw ako Asia gv mooku svpw dookubv vngtv nvgo, ngonu vnglintoku, Mesedonia nyi go Aristarkas Tesalonika lokv, ngonua lvkobv vngto. ");
INSERT INTO tgj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Logo nvngaku ngonu vngchi toku Sidon lo. Julius Paulnyi aya mvngpato okv ninyia tulin toku vngdubv okv hv ogugo mvngrung pvdw ninyigv ajin vdwa kaala jimu dubv. ");
INSERT INTO tgj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ngonu Sidon lokv vnglintoku, okv ogulvgavbolo dooriv ngonua riketo okv ngonu durap tvku Saipras gv bokpin kiambv. ");
INSERT INTO tgj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ngonu vngbo toku Silisia svmasa nga okv pampilia okv Maira gv Lisia lo aatoku. ");
INSERT INTO tgj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Hoka nyigam angv svpw go kaapato hv Alekjandaria lokv Itali bv vngjinvgo hv ngonua svpwlo aagv toku. ");
INSERT INTO tgj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ngonu tapv tapvbv vngrap toku lonyiloum go okv achialvbv adwkakubv Anyungnga vngchi toku Banggu Konidas loku. Dooriv ngonua ho kvvbi mooku lo vngmu kumato, vkvlvgabv ngonu dulu tvku Kret bokpin gv adarlo geko gv Salmone nga vngpitla. ");
INSERT INTO tgj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ngonu svmasa lvgam hoka aanwk toku okv anyung ngaku kairungbv apiai yingdula svpw rvngpumku mooku hoka vngchi toku, vv Lasia Banggu lokv adu kuma toku. ");
INSERT INTO tgj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ngonu hoka dwa awgo ria toku, okv dulv la vnglv svngvka maatar bv alv matoku okv rimur am anyu bv mvngnga la dvmatvngma doodw alu hvka vngro toku. Vkvlvgabv Paul bunua so gaam sum minjito: ");
INSERT INTO tgj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Vbvrinamv Paul mintoku svpw gv nyi vdwa, “Nyi vdw, nonuno nga tvvriato, ngonu vjak durup bolo maatar bv alv kumare, ngonugv svpw okv yikungyira ngv alv marung bv amwkre, awgo doonv ngvka nyeriku,” ");
INSERT INTO tgj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Vbvritola Sipai nyigamv tvvriato svpw atugv okv svpwa rigvnvgv minama, okv tvvma nyato Paul gv minama. ");
INSERT INTO tgj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kamchwng dw lo svpw rvngpam kolo svpw nga doogv dubv alvma, vkvlvgabv nyi mvnwng ngv svmasa lokv vngdubv gwngnyado Poneks lo vnglwk dubv, okv rinyubolo Poneks lo vngchi la hoka kamchwng nga doodubv, Poneks vv svpw rvngpam kokuv Kret pamtv gv doonyi aagia tangv yordum okv yorko ngv gvvrwk nvgo. ");
INSERT INTO tgj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yorko peelv bv dooriv bvibvi bv rirapto, okv nyi vdwv mvngtoku si bunua doori ngv bunugv rungkubv rila vnggvre, vkvlvgabv bunu svpw rvngtung nvnv nga paksok toku okv lvgvlvma bv kret bokpin kiambv durup toku. ");
INSERT INTO tgj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Vbvrinamv Vjakgobv kairungnv doori go riraptoku “Yordumdonyichagia lokv Tabv doori vnamv” bokpin kiambv lokv rilwkto. ");
INSERT INTO tgj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Dooriv svpwa riketo, okv ngonu svpwa dunyu kumato, ngonu svpwa duku mato okv doori yanga rigv kooto. ");
INSERT INTO tgj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ngonu kaapato miangnv bokpin go vdwlo ngonu yorko kiambv kauda nga vngpit rilo. Hoka, ngonu meego doonu kogo paato. Hoka, miangnv svpwa kiinvpanv dubv kainv svpw arwnglo rilv kuma dubv, ");
INSERT INTO tgj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","bunu boolwk tvla okv hum oso meegonv svpwlo adakrungbv leelwkto. Bunu busunyato ho lvko nyika bunu Libya gv adar chukri apum lo riulwkji mvngla, vkvlvgabv bunu koching lo vngto okv svpwa doori lokv rigv moto. ");
INSERT INTO tgj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kainv doogumdooriv vngdvto, vkvlvgabv logo nvngaku bunu svpw gv yikungyira nga meegonyi kungnga raptoku, ");
INSERT INTO tgj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","okv ho alu svpwlo doonv atungama yikungyira aka kungnga toku. ");
INSERT INTO tgj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Achialv alu go ngonu doonyi okv takara kaapa nyokuma, doori gv achialv bv awyayabv rinam lvkwng bv. Ngonu Anyungnga mvngnga sutoku turkuram mvngla. ");
INSERT INTO tgj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nyi vdwv oguka dvmabv awgo dootoku, Paul bunugv pingkolo dakrapto okv minto, Nyi vdwa, nonuno ngoogv minam nga tvvla Kret lo doonv guilo, nonu sikvnv nyenam okv amwk mare. ");
INSERT INTO tgj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Vbvritola vjak ngo nonua mindwkkrwkla mindunv, haapok v mvngrw laka! nonuno yvvka atugv singtung ngv nyemare; svpw mvngchikv nyvmwngre. ");
INSERT INTO tgj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Siyu Pwknvyarnv ngoogv kumnamjonam vv ninyigv nyidogindung ngv ngo gvlo aato, ");
INSERT INTO tgj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","okv mintoku, ‘Paul busu mabvka! no Dvbvyachok gv kaagia lo dakrungre. Pwknvyarnv noogv lvkobv yvvbunudw nam svpwlo vngdunv mvnwng nga ayala ringyare.’ ");
INSERT INTO tgj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Vkvlvgabv mvngrwlak, Nyi vdw! Ngo Pwknvyarnvnyi mvngingdu ho hv rirungre ninyigv ngam minama. ");
INSERT INTO tgj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Vbvritola ngonu bokpin kvvbi golo riulinre.” ");
INSERT INTO tgj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Yupring gola yuppi toku, okv ngonu Mediterranian svmasa gv doogumdoori lokv nungbwngto. Yupra lvpa nga svpw dunv vdwv mvngtoku ngonu dvpw lo aachi rikunv mvngla. ");
INSERT INTO tgj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Vkvlvgabv bunu isi gv rungrwng nga kiikw namv champi mitar gobv rito; okv achukgo vngto la ho bunu kiikw nammv Chaom mitar gobv rungrwngto. ");
INSERT INTO tgj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bunu ho busu nyato svpwv vlwng goka tupji mari mvngla, vkvlvgabv bunu koching lakchikiam lo riokdar toochi daapigo svpwlo paklwk toku okv kumnya toku aluv loolin dubv. ");
INSERT INTO tgj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Vbvrinamv svpwa vnggvnv dunv vdwv gwngkw nyato svpw lokv ringsu dubv; Bunu miangnv svpw isi lo soolu nyato okv bunu mvvla gwngnyato hoka svpw nyoktuk gv toochi meegonyi layin dvnvkv vla. ");
INSERT INTO tgj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Vbvrinamv Paul mintoku sipai nyigam am okv Sipai vdwa, “Svpw dunv ngv svpwlo dooming gvvma lo nonu turjiku kaakuma.” ");
INSERT INTO tgj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Vkvlvgabv sipai vdwv ho oso nga papwkto okv svpwa riusiriudv motoku. ");
INSERT INTO tgj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pua madvbv, Paul bunu mvnwng nga alvbv mintoku dvnam go dvdubv: “Nonu vjak dooya kunamv loring gola loopi dooku, so dw mvnwng am nonu oguguka dvnam dvma. ");
INSERT INTO tgj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ngo nonua mindwkkrwk dunv, vkvlvgabv, dvnam go dvrung tvka; Sikv lokv nonu turungre. Nonugv dvmw sogo nvka dumpo lokv nyemare.” ");
INSERT INTO tgj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Sibv miro kochingbv, Paul vtwng meego naatoku, Pwknvyarnv hartv toku bunu mvnwng gv kaagia lo, pintung piyungla, okv dvrap toku. ");
INSERT INTO tgj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bunu mvnwng ngv mvngrw nyatoku, okv bunu akinakin bv dvnam meego dvrap toku. ");
INSERT INTO tgj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ngonu mvnwng ngv svpw hoka doonv ngv lwngnyi gola chamkanw gola akv gobv rito. ");
INSERT INTO tgj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Mvnwng ngv dvgu dubv dvro kochingbv, bunu vtwng mvnwng nga svmasa bv nvvlwk lakula svpwa haajup motoku. ");
INSERT INTO tgj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Vdwlo aluv aapv kudw, Svpw dunv ngv jobv vngtung am himbwk kumabv ritoku, vbvritola bunu dvpw go kaapato okv hoka bunu vngnyu bolo vngdubv rungnyato. ");
INSERT INTO tgj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Vbvrinamv bunu svpw toochi nga papwk la isi bv lumlwk motoku okv lvkobv bunu parnv nvlo oso haka taasok toku. Vbvrinamv bunu svpw gv nyoktuk lo vji am turpvto hoka svpwa dooriv adarlo milin mola svpw dunama dulin gvvdubv vla. ");
INSERT INTO tgj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Vbvrinamv svpwv chukri putung nga tupto okv vngtoku, svpw gv dumpo lakchikiam ngv haktung toku okv vngka nyuma bvku, vbvrikunamv koching lakchikiam nga sibu nungnv ngv nuyinnupin toku. ");
INSERT INTO tgj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sipai vdwv gwngrap toku patwk tumnam nyi mvnwng nga mvki dubv, turla jaalinla kiyu mamsv nga mvngla. ");
INSERT INTO tgj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Vbvritola Armi nyigamv Paulnyi turmu so mvngto, vkvlvgabv hv bunugv gwngnam am rimu mato. Vbvmabvya mintoku nyi mvnwng ngv yvvbunudw jaalak nvngv poklwk chola okv lvgum alo jaalin lakv vla minto; ");
INSERT INTO tgj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Jaachin manv vdwv jaaming gvvlaka svpw gv dartungdaryung nga gakbwng tola. Okv svkv lokv ngonu mvnwng ngv ringsula isi agum lo riulin pvkunv. ");
INSERT INTO tgj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Vdwlo ngonu dvpw lo linpv kudw, ngonu chintoku vv Malta bokpin vkunyi vla. ");
INSERT INTO tgj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mooku gv nyi vdwv ngonua achialv bv ajinarum bv ritoku. Hoka nyido ngv hoto okv achialvbv sikarto, vkvlvgabv bunu vmv parto la okv ngonu mvnwng nga higu motoku. ");
INSERT INTO tgj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul takiotaram rvkgo darkamto okv vmv partoku vmvgv agu lokv hinla ikula Tabw sogo linto okv ninyigv laak lo leedak lwkto. ");
INSERT INTO tgj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Mooku gv nyi vdwvka kaaria nyatoku Paul gv laak lo tabw sogo bvyo dubv kaatola okv bunu mimisitoku, “So nyi si gwngrw siyin gunyi, hv svmasa lo simato, vbvritola vjak sinamv ninyia topu kumare.” ");
INSERT INTO tgj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Vbvritola Paul oguka ungv gvvmabv okv ninyigv laak lokv tabw am vmvlo orlwkto. ");
INSERT INTO tgj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bunu ninyia biungridw okv dvminmabv tapv la siridw vla kaaria nyato. Vbvritola achialvbv kaariaro kochingbv okv ninyia oguka riku mato, bunu mvngkur la okv minto, “hv Pwknvyarnv ako!” ");
INSERT INTO tgj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Adu yomaku mooku lo ho Puplius gv rongo mooku meego dooto, bokpin gv nyigam kaiyachok nvgo. Hv ngonua alvbv aamuto ayala okv ninyi gvlo ngonu alu loum gv nyen bv ritoku. ");
INSERT INTO tgj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Puplius gv abuv gadw lo karto, chilirampin lvvmala okv eeching chila Paul ninyigv karchung bv aatoku, ninyi, kumtoku, ninyigv laakv lakpo tvla okv ninyi mvpu jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Vdwlo sibv ripvkudw, bokpin gv kvvbi lvvmanv mvnwng ngv aakumto okv mvpu toku. ");
INSERT INTO tgj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bunu mvnwng ngv ngonua amin awgo jitoku, vdwlo ngonu durup pvkudw, mooying vngtunglo ngonu ogugo mvngrung pvkudw bunu um vvpv jitoku. ");
INSERT INTO tgj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Poolu pwkgum gv koching lo ngonu svpwlo vngraptoku Alekjandaria lokv aanvgo vbv minamgo “Pwknvyarnv anyi vnamgo,” ho gv bokpin lo kamching vdwa ho doonvgo. ");
INSERT INTO tgj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ngonu Sirakas gv Pamtv lo vngchi toku okv alu loum go dootoku. ");
INSERT INTO tgj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Hokv ngonu vngrap la okv Regiam gv pamtv lo vngchi toku. Logo nvngaku dooriv mooko peelvbv rirapto, okv ngonugv Putioli banggu lo aalwk la lonyi lo. ");
INSERT INTO tgj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ngonu mvngjwngnv meego kaapato hoka bunu minto hopta go lvkobv doola bvkv ngonua vla, vkvlvgabv ngonu Rom bv vngtoku. ");
INSERT INTO tgj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Rom gv mvngjwngnv vdwa ngonugv lvkwng bv tvvpato okv aduadu gv Appius gv banggu bajar lokv okv hotel Tri Inns vnamgo ngonua paamuto. Vdwlo Paul bunua kaapa pvkudw, hv Pwknvyarnvnyi hartv toku okv kairungbv mintvmiru toku. ");
INSERT INTO tgj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Vdwlo ngonu Rom lo vngchi pvkudw, Paulnyi atubonga dongu sumu toku sipai a ninyia dakgv motola. ");
INSERT INTO tgj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Alu loum gv koching bv Paul goklwkto Jius vdwgv rigv nvnga paami sidubv. Vdwlo bunu aakum tokudw, hv minto bunua, ngoogv Israel gv ajin richam vdwv, ngo ogugo gungnying malachin ngonugv nyi vdwv vmalo abuapa gv ridungsingdung rinama, ngo Jerusalem gv patwk lo tumto okv Roman vdwlo jilwkto. ");
INSERT INTO tgj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nga tvvkaro kochingbv, Roman vdwv nga topu nwngtoku, ogulvgavbolo bunu hoka nga mvki dubv oguguka mapa matoku. ");
INSERT INTO tgj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Vbvritola vdwlo Jius vdwv maakv vpvdw sum, ngo kwngkwng alvbv dvbvyachoknyi koodwkkrwkla kooto, ngoogv atu nyi vdwa ngo gungnying go lwksu majeka. ");
INSERT INTO tgj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Vkvlvkwngbv ngo nam kaarwk sila okv lvkobv mindunv. Ogulvgavbolo ngo silu Israel nyi mvnwng gv mvngtinnam ninyigv lvgabv ngo laak gv rvngja sum gvvdunv. ");
INSERT INTO tgj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bunu ninyia mintoku, “Ngonu Judia lokv siti guka paama noogv lvkwnglo, ngonugv nyi akonvka Judia lokv aanv ngv ogu yunying alvmanv goka gvvlwkma noogv lvkwng lo. ");
INSERT INTO tgj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Vbvritola ngonu tvvnwngdo noogv mvngnam am, ogulvgavbolo ngonu chindo nyi mvnwng ngv noogv so apum sum gungnying bv mindu. ");
INSERT INTO tgj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Vkvlvgabv bunu alu go mirw pvvtoku Paulnyi paami sidubv, okv bunu nyitwng ngv alu lo aakumto Paul ogolo doopvdw. Arukamchi lokv arium lobv hv minjito ninyigv doina Pwknvyarnv gv Karv lvkwng lo, hv gwngkwto bunua Jisunyi mvngjwng modubv Moses gv Pvbv lokv okv nyijwk vdwgv lvknama minvla. ");
INSERT INTO tgj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Kvvgonv bunu mvngjwngto ninyigv minam lokv, vbvritola kvvgonv mvngjwngjvjv kuma toku. ");
INSERT INTO tgj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Vkvlvgabv bunu vngyu rapto, bunugv pingkolo tolwktoak minsu mabv rila, ho koching nga Paul gaamgo mindvto, Darwknv Dowv jvjvbv mindunv noogv abuapa nga nyijwk Aijaya lokv! ");
INSERT INTO tgj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Hoka hv mintoku, ‘Vngla okv minji lak so nyi sum: Nonu tvvre okv tvvriare, vbvritola vdwloka tvvchinma; nonu kaare okv kaariare vbvritola vdwloka kaachin mare, ");
INSERT INTO tgj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ogulvgavbolo so nyi vdwsi mvngchin madu, okv bunu tvvnwng mabv tvvdu okv kaanwng mabv kaadu. Ho manv guilo, bunugv nyikv kaapare, bunugv nyarung ngv tvvpare, bunu mvngchin riku, okv bunu ngo gvlo aalwkre, Pwknvyarnv minto, okv ngo bunua mvpure.”’ ");
INSERT INTO tgj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Okv Paul minyabv mintoku: “Nonuno chinto laka, Vkvlvgabv, ho Pwknvyarnv gv Turnam doinv Jentail vdwlo jilwk toku. Bunu vdwv tvvriare!” ");
INSERT INTO tgj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paul gv minro kochingbv, Jius vdwv bunugv pinkolo achialvbv larmi sudula vngyu toku. ");
INSERT INTO tgj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Anying nyingnyi go Paul atubongv dookudaku go morko jila doosuto, okv hoka Paul nyi vdwa yvvbunudw ninyia kaabv aanv mvnwng nga alvrungbv aamuto. ");
INSERT INTO tgj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Hv tamsar rapto Pwknvyarnv gv Karv gv lvkwngbv okv minji rapto Ahtu Jisu Kristo gv lvkwng bv, mvngrw alvbv okv mintup minchi kaamabv.");
INSERT INTO tgj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paul lokv, apostol akobv gaknam Kristo Jisu gv pakbu akobv rinv okv alvnv yunying minggo kardubv Pwknvyarnv gv goklin kunamv. ");
INSERT INTO tgj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Pwknvyarnv gv alvnv yunying ngv krimklu lokv ninyigv nyijwk lo milv pvvto, Darwknv kitap lo vbv lvklwk toku. ");
INSERT INTO tgj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","So si ninyigv umvuu lvkwnglo, ngonugv Ahtu Jisu kristo: vbv adwnamar bv, Hv Dabid gv husi ara lokv bvnglin toku; ");
INSERT INTO tgj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ninyigv darwknv gv Dow hvvrong jvjvbv, kairungnv jwkrw lokv kaatam la Pwknvyarnv gv Kuunyilo rinam lokv siku nvngv turkur toku. ");
INSERT INTO tgj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ninyigv lokv Pwknvyarnv ngam Apostol ako bv ridubv kristo gv amin lo jito, vbv orto kunam lokv diringmooku gv nyi mvnwng nga rigv mola mvngjwng modu kubv okv tvvnvgobv rimu dukubv ritoku. ");
INSERT INTO tgj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Si Rom lo doonv, yvvnyi Pwknvyarnv gv Jisu kristo gvbv gokpvdw nonua ka mintak dunv. ");
INSERT INTO tgj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Okv vkvlvgabv Rom lo doonv Pwknvyarnv gv paknam nyi dvdv nga okv ninyigv atubogv gvbv gokunam am ngo lvkdunv: Ngonugv Pwknvyarnv Abu okv Ahtu Jisu Kristo gv anyuaya okv sarsopoyo ngv nonu gvlo jilwk yilaka. ");
INSERT INTO tgj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Atuakebv, Jisu kristo amin lo nonu mvnwng lvgabv ngokv Pwknvyarnvnyi ngo umbonyikv vdunv, ogulvgavbolo nonugv mvngjwng nam lvkwng bv nyiamooku mvnwng ngv tvvpa nyadung duku. ");
INSERT INTO tgj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ngo ogugo mindudw sum jvjv dunv vla ngoogv Pwknvyarnv tvvyakaya do— ninyigv Kuunyilo lvkwnglo alvnv yunying nga ngoogv japgo karla haapok lokv ridum jikunamv Pwknvyarnv ngv. Pwknvyarnv ngv chindu ngo nonua mvngpa kidunv ");
INSERT INTO tgj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ngoogv kumri dwkibv kumpa dunv. Nonugv dooku lo ngam vjak vngmuchamu nam lvgabv Pwknvyarnvnyi ngo ninyigv mvnglwkkaalwk bvka vla tvvka doonv. ");
INSERT INTO tgj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nonua ngo achialv bv kaanwng dunv, vkvlvgavbolo darwknam boktalwkjinamv gwlwk alvbv nonu gvlo doolwk jimu dukubv. ");
INSERT INTO tgj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ngo mindunv si oguvvbolo bunyino la okv ngo lvvyin akinbv mvdur minsu lareku, ngoogv mvngjwng lokv nonu okv nonugv mvngjwng lokv ngo. ");
INSERT INTO tgj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nonu mvnggap runglaka, ngokv ajin vdw, si ngo nonua kaarwk sidubv achialvgo gwngkwng toku, vbvrijvka rigv nyikibv vbv vnglinrilin paamabv ribvto. Jentail kvvbi vdwa ngoogv rinam aingbv, nonugv ara loka mvngdin mola aamu dukubv mvngdu kunv. ");
INSERT INTO tgj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ngo gvlo nyi mvnwng lvgabv, chinvpanv jvka okv chinvpanv majvka, puripupanv jvka okv puripupanv majvka minsvrisv go doodunv. ");
INSERT INTO tgj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Vkvlvgabv ngo nonua okv Rom lo doonvdaknv vdwaka Alvnv Yunying nga japji nwngdunv. ");
INSERT INTO tgj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Gamlv am ngo alvjvjv rungbv mvngjwng rungdunv; si Pwknvyarnv gv jwkrwv mvngjwng la doobu dvdv nga ringnam lvgabv, atuake bv jius vdwa okv Jentail vdwaka ringlin reku. ");
INSERT INTO tgj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Holvgabv Pwknvyarnv atubongv nyi vdwa ninyi gvlo tarwkbak dukubv mvkunama um gamlv ngv kaatamdo; si mvngjwngnam lokv atuake gvngv laala yikula ataranya gobv rire. Darwknv kitap ngv vbv mindu, “yvvnyiv Pwknvyarnv gvlo tarwkbak bv doodudw mvngjwng nam lokv turla dooreku.” ");
INSERT INTO tgj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Pwknvyarnv gv haachi namv rimur dvdvlo okv alvmanv nyi vdwgv jvjvrungnv am chimu madubv mvturla oogv alvmanv lamtv lo rigvnv vdwgv lvkwngbv nyidomooku tolo gvngv kaatam la ritoku. ");
INSERT INTO tgj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Pwknvyarnv bunu vdwa mvritririt toku, ogulvgavbolo Pwknvyarnv gv lvkwnglo ogunv chinsv vdw bunu vdwv chinpu bv chinla toku, vkvlvgavbolo Pwknvyarnv atubongv um chinpu dubv mvjitoku. ");
INSERT INTO tgj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Krimklu lokv nyiamookua pwklinyarlin yilo gvngv laala yikula, ninyigv kaapa manam raying nga, ninyigv turbwngnv jwkrw lokv okv ninyigv Darwkrungnv doodung sunv so anyi lokv, rvbwngching bv kaabwk toku; bunu vdwa soogv ogumvnwng si Pwknvyarnv gv mvpvkunv mvngmu toku. Vkvlvgabv ho nyi vdwa yvvnyika ayeako namgo kaamare! ");
INSERT INTO tgj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bunu vdwv Pwknvyarnvnyi chindo, vbvrijvka bunu vdwv Ninyigvbv mvnglwk sula mvngdv jimadu, vmajeka ninyia umbonyikv vlaka mimadu. Vbvmayabvku, bunugv tuktumv mvngdung kaama nvbv riduku, okv bunugv tuktum arochoko lo kanvtwng yalwk duku. ");
INSERT INTO tgj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Hv bunu mindu bunu vdwv chinvpanv ngv vdu, vbvrijvka bunu vdwv nyiposoyo nvgobv ridu. ");
INSERT INTO tgj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Sikamajinv Pwknvyarnvnyi kumji koloya, bunu vdwv siyajinv nyi jvbv kaadubv mvringmvma tvla vmalo pvta vmalo svnwngsvmin vmalo doojingburu am mvringmvma tvla kumnya la ridu. ");
INSERT INTO tgj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Okv vkvlvgabv vkvnv nyi kasingkanyaknv rilwkdolwk dubv haapok mvngnv bunu vdwa Pwknvyarnv jilwk jito, okv bunugv ajinanying lokv hinyinghiru rinam lo ridukalam mola rimu duku. ");
INSERT INTO tgj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Mvvnam lvgabv Pwknvyarnv lvkwnglo jvjvrungnv nga bunu vdwv mvlomvk jila ritoku, Pwknvyarnv ogugunyi yarpvdw bunu vdwv um kumlajola rijiyala ritoku, Pwknvyarnvnyi dvbvsingtambv hartvbamtv yabv la rise yanga! Amen. ");
INSERT INTO tgj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Vkvlvgabv bunu vdwv so vbvrikulo, Pwknvyarnv bunua hinyinghiru sakduk namlo jilwk toku. Nyimv vdwka bunugv nyimvnyilo gv ridung jvjvlo rimisinam sum riku mabv nvgwngbv rimisingmi sinyala riduku. ");
INSERT INTO tgj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Oogv apia bv nyilo vdwvka nyimvnyilo gv ridung jvjvlo riku mabv nvgwngbv rimi sinyala riduku okv ajinanying lo sakduk kalam minsula ridu. Nyilo vdwv vbv ajinanying lo vkvnv rimisila rinamv, okv kaka kunamv bunu awgv rimur nam lvgabv bunu atubogv aolo mvrit kosv nga hv bunu laalwk sila ridu. ");
INSERT INTO tgj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ogulvgavbolo oogv nyi vdwv Pwknvyarnv gv lvkwnglo jvjvrungnv chinampanama tuktumlo tvvgap pvvla risv nga tvvmarima kolo, bunu vdwa alvmanv mvngnampanam am hv jilwk pvvto, vkvlvgabv bunu rima svnga riniadaknia la riduku. ");
INSERT INTO tgj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bunu vdwv nvgwng mvnwng gv rimurrichvnam, alvmanv, gumpwngnam okv rimur mursik sinam dvdv ngv, doolwkdaklwk nyala riduku, bunu vdwv kavtavnam, mimisinam, pamisinam, kupmisinam, okv kvvbia hirukaya modu bv gwngnam. Bunu vdwv japsijapik laka ridu, ");
INSERT INTO tgj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","okv ajinanyingnga tvvmur dubv mindu, bunu vdwv Pwknvyarnvnyi mvngnwng madu, mvngdv dubv rimadu, kai mvngsunam, okv goosunam; bunu vdwv alvmanv lamtv lo kaiyago riso mvngdu; bunu vdwv bunugv anvabu gv mingku bv vngso mvngmadu; ");
INSERT INTO tgj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","bunu vdwv mvngdung kaamado; bunu vdwv bunugv milvpvvnam lo rimadomadu, okv bunu kvvbi lvgabvka ayakaapa nam okv aiamarnam kaatam madu. ");
INSERT INTO tgj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Hv bunu soogv lamtv so ribudakbu vdwv sinam lo paadunv vla Pwknvyarnv gv Pvbv lo minam am chindu. Vjvtikmabv, hv bunu vdwnvgo riji nvnga ka ridungdu, vbvritola bunu kvvbi gv rinam aka bunua tulwk minggv laka ridu. ");
INSERT INTO tgj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ngokv ajin nonuno, kvvbia jwngkadaka dunvri? Nonu yvvnvbv rijeka, nonu miyiminggi svgo kaama rinvpv. Vkvlvgabv vdwlo nonuno kvvbia jwngkadaka dudw okv oogv 