﻿USE sofia;
DROP TABLE IF EXISTS sofia.tfrNTpo_vpl;
CREATE TABLE tfrNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tfrNTpo_vpl WRITE;
INSERT INTO tfrNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kjok ëre dämär, l̇l̇ëye l̇l̇ëm obishko ga Sbö kjok shäryono uunkong, kjopkwo, kl̈ung bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kl̈ung ëre ĩgöy l̇l̇ëm obi, dl̈ung rong, kjing yẽt eröe. Eshko ga Sbö Sëya wir pjang dl̈ung kjing pjl̈uk wl̈eni erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Eshko ga Sbö tjl̈ẽ ga «Kjok, pja ber shjiye» l̈e. L̈ara sorë ga shäryono beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","5","Ĩya ga kjok shjiy l̈i beno pjl̈úe. Kjok shjiy l̈i kowara «dba», kjok sĩ l̈i kowara «shkë», ga iara beno tjeng dboy dboye. Eshko ga öötong dbar kjwara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Wẽshko ga tjl̈ẽ ga «Dl̈ung, pja opkjos ber dboye» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","L̈ara sorë ga shäryono beno eni. Dl̈ung l̈i iara beno buk töshko, dira iara beno pjang kjomo, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","beno pjang ba tjrëko l̈i kowara «kjok dogo». Eshko ga öötong dbar pjök. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Wẽshko ga tjl̈ẽ ga «Dl̈ung, pja tönzong ber tjeng shtor, kjok dogro l̈i wen wl̈o» l̈e. L̈ara sorë ga shäryono beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kjok dogro l̈i kowara beno «kl̈ung», dl̈ung l̈i kowara beno «dl̈ung». Eshko ga ĩya ga beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Eshko ga tjl̈ẽ ga «Kl̈ung, pja kjing go kjl̈o sho wenzong, kjl̈o sho l̇l̇ërba pogo dwl̈ayo tjok wl̈eniyo, kjor botjyë wl̈eniyo bakoe» l̈e. L̈ara sorë ga shäryono beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kl̈ung l̈i kjing go kjl̈o sho weno obl̈ë obl̈ë dwl̈ayo tjok wl̈eniyo, kjor weno bo tjok wl̈eniyo bakoe. Eshko ga ĩya ga beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Eshko ga öötong dbar mya. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Wẽshko ga tjl̈ẽ ga «Kjopkwo, pja goshko iök wenzong, shkë, dba, e ber tjeng dboy dboy wl̈o, dbar l̇l̇ë, mok l̇l̇ë, l̈u l̇l̇ë, e miydokl̈o wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Iök, pjãy ber kãl̈ã shjiy kl̈ung kong» l̈e. L̈ara sorë ga shäryono beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Iök shäryara pjök, kjwara kësbang ber shjiy dba wl̈o, kjwara chirawa ber shjiy shkë wl̈o. Dbala shäryara uunkong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Iök l̈i iara beno l̈ok kjopkwo go, kl̈ung kjing l̈i ber shjiy wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Iara beno tjeng shjiy dba wl̈o, shkë wl̈o bakoe. Ga kjok shjiy l̈i, kjok ro sĩ l̈i, e kjara beno tjeng dboy dboy eni. Eshko ga ĩya ga beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Eshko ga öötong dbar pkëng (4). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Wẽshko ga tjl̈ẽ ga «Dl̈ung, di, pjãy roshko mã wenzong obl̈ë obl̈ëe. Kjok dogo, pja go sënwa wenzong l̇l̇ërba pogo» l̈e. L̈ara sorë ga shäryono beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Äya këskës chila dl̈ung roy so, di roy so, e shäryara uunkong, sënwa, e shäryara uunkong bakoe. Eshko ga ĩya ga beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Eshko ga tjl̈ẽ l̇l̇ëbo wena tjeng l̈i kong ga «Pjãy wapga shdärzong dl̈ung kjwang jĩkong, di uunkong roshko bakoe. Sënwa, pjãy wapga shdärzong kjok kjwang jĩkong bebi» l̈e. L̇l̇ëbo shäryara beno pjl̈ú ba kong l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Eshko ga öötong dbar shkëng (5). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Wẽshko ga tjl̈ẽ ga «Kl̈ung, pja kjing go äya kjl̈oshko so wenzong, öng wenzong bakoe» l̈e. L̈ara sorë ga shäryono beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Eshko ga ĩya ga beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Eshko ga tjl̈ẽ obi ga «No shäryëy shara, so shji kjoyoe. E ber tjwl̈õ ara, dbo ara, l̇l̇ëbo obl̈ë obl̈ë tjeng l̈i kjinmo, mã, sënwa, öng, äya kjl̈oshko so bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Eni ga no, e shäryara Sbörë so e om go kjoyoe. Shäryara domer, wal̈ë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Eshko ga tjl̈ẽno beno pjl̈ú ba kong. Tjl̈ẽ ga «Pjãy shdärzong ara, tira l̇l̇ëme. Kjok ëre dl̈imia. Pjãy iër ber l̈öng ba ĩga. Mã, sënwa, öng, äya kjl̈oshko so, pjãy iër ber l̈öng ba ĩga bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","E irgo ga tjl̈ẽ ga «Kjok ĩzĩa. Kjl̈o sho l̇l̇ërba pogo dwl̈ayo tjok wl̈eniyo, kjor botjyë wl̈eniyo, e twër ber bomi kong, uëmi wl̈o. E bomi dl̈i uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Gueniyo ga öng, sënwa, äya kjl̈oshko so, e kong kjl̈o sho twër ber ba kong, ue wl̈o» l̈e. L̈ara sorë ga shäryono beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Eshko ga ĩya ga uunkong l̈i beno pjl̈ú, owa l̇l̇ëme. Eshko ga öötong dbar tjer (6). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kjok uunkong, l̇l̇ëbo tjeng kës, e shäryara beno pjir eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","3","Dbar kjäk (7) ga ba pak shäryara pjir l̈ishko ga woshtonoe. Ga woshtono eshko dbaryo kjĩshko ga l̇l̇ëbo shäryara dbar kjäk (7) l̈i kong pjl̈úe. E iara beno pjang dboye. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kjok shäryara Sbö Jehovárë uunkong eni. Eshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","kjor, kjl̈o sho, e wentë l̇l̇ëm obi. Shunyo ichayde Sbö Jehovárë shrë kl̈ung kjing go l̇l̇ëm obi. Ëye parkaga kl̈ung kjing go l̇l̇ëm bakoe. L̇l̇ëye wentë l̇l̇ëm obi e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Gueniyo eshko ga di tur tëm kl̈ung dirko, e sguin kl̈ung kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Eshko ga domer, e shäryara Sbörë kjl̈ara kl̈ung sho go. Ga pjl̈uk bakwara ba ne roy ber shäng së wl̈o, ga beno shäng së. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ga Sbö kjok poshäryono buk kjrina ko Edén, kjok, e buk dl̈o wen tëm shwo l̈ëkong. Ga domer shäryara l̈i iara beno shäng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Eshko ga kjor shäryara obl̈ë obl̈ë kjl̈öböso, wol̈ësowa, bo uako wl̈eniyo. Ga kjok buk l̈i roworbëshko ga kjor iara beno l̈ok do pjök. Kjl̈ara, ba bo uoroy ga shji wol̈on l̇l̇ëme. Kjl̈ara obi, e l̇l̇ëbo pjl̈ú, l̇l̇ëbo owa, e miydokl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Edén kjokyo l̈ishko ga di wen pjang pjl̈ara. E jer pjang shdär kjor l̈i gl̈oroy. Ey ga shdöktong beno pjl̈ogl̈o pkëng (4). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Di bäm go l̈i ko Pisón. E jer pjrĩya buk Javilá kjokyo worbo tjok. Kjok eshko, e dbur sho shõyl̈ṍr ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dbur sho shõyl̈ṍr kjok eshko so l̈i owa l̇l̇ëm, shõyl̈ṍr anmoyõ. Poshtikkl̈o l̈õ pjl̈ëbl̈ë ko bedelio eshko tjok. Akkwo tjwl̈õ ara ko ónice eshko tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Di pjl̈ara obi l̈i ko Guijón. E jer buk sjöng Cus kjokyo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Di pjl̈ara obi l̈i ko Tigris. E jer buk Asiria kjokyo dl̈o wen tëm shwo l̈ëkong. Di pjl̈ara obi l̈i ko Éufrates. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Domer l̈i iara Sbörë beno shäng Edén kjokyo roshko, kjok l̈i ĩga, kjok l̈i daga bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Eni ga tjl̈ẽ ba kong ga «Kjok ëreshko ga kjor bo twër ber bop kong uunkong, uëp wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Gueniyo ga l̇l̇ëbo pjl̈ú, l̇l̇ëbo owa, e miydokl̈o kjoryo bo, era uëy l̇l̇ëme. Uorop ga pja wol̈on jl̈õkoyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Eshko ga tjl̈ẽ obi ga «Domer ber sök kjl̈araso ga pjl̈ú l̇l̇ëme. Kong ba yorkaga shäryër kjl̈ara, ba kjimtë wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Eni ga öng, äya kjl̈oshko so, sënwa, e shäryak beno kl̈ung sho go, ga söra uunkong, pina domer l̈i kong, koie wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ga koiara uunkong eni. Gueniyo e tjrëko l̇l̇ëye wl̈ẽna ber ba kjimtokl̈o wl̈o l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","E kjĩshko ga domer l̈i iara Sbörë beno buk pë ronge. Buk pë wopro ga shgl̈ing shira kjwangna, ga sho l̇l̇ira jek iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ba shgl̈ing l̈i go ga wal̈ë shäryara kjl̈ara. E irgo ga söra, pina ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ĩya domer l̈irë ga tjl̈ẽ ga «¡Ĩzong! Ërera so tja kjoyoe. Ba sho kjwe botoya dik. Ba dbogl̈o kjwe botoya dik. Koiër ber “wal̈ë”, shira domer go dwayo kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","E kjĩshko ga domer ba data, ba mekë rayë, ga orkwosmok wal̈ë tjok, ga ber l̈öng kjl̈araso wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Eshko ga l̈öng kjwor, gueniyo l̇l̇ëye l̈ökyokjre l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Dgur, e obl̈ë jyãpgwë äe, äya kjl̈oshko so obl̈ë obl̈ë shäryara Sbö Jehovárë l̈i kjinmo. Pjl̈ara ga tjl̈ẽ wal̈ë l̈i kong ga «¿Jl̈õkoyo ga Sbö tjl̈ẽno bomi kong ga “Kjok ëreshko ga kjor bo uëy uunkong l̇l̇ëme” l̈ara eni jl̈õre?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","«Kjor bo uërwa uunkong ga pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Gueniyo ga kjor jong kjl̈ara kjok roworbëshko, era uërwa ga äe. Sbö tjl̈ẽno borwa kong ga “Kjwe uëy l̇l̇ëme. Porwëy l̇l̇ëm bakoe. L̇l̇ëm ga pjãy wol̈on” l̈ara eni» l̈e dgur kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kuya ga tjl̈ẽ ba kong ga «E jyõ. Pjãy wol̈on l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Miyde Sbörë pjir ga kjor ëre bo uoromi ga pjãy bokkwo roshwing, ga pjãy ber l̈ong l̇l̇ëbo pjl̈ú, l̇l̇ëbo owa miydë. Eni ga pjãy ber l̈öng Sbö dik» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kuya ga ĩya ga kjor bo, e wol̈ësowae. Ga iara beno uayuae. E kjok miydokl̈o bakoe l̈e. Eni ga kjor bo l̈i kjrara, ga uarae. E irgo ga twara ba l̈anma kong, ga omuono bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Jekdo eshko ga bokkwo roshwingö, ga opmiydono l̈ok ga l̈öng kjwor. Eni ga kjor ko higuera l̈i korga sera, pjrira ba dop go, ber l̈öng kjwor l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kjok sëng, pjl̈uk ri rishko ga Sbö jëk jek shäng kjor gl̈oroy l̈i kura l̈ok. Ga töktong l̈ok zron ĩ, ga opjneno kjor l̈i pjl̈or go, ĩya l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Eshko ga domer l̈i rokara Sbörë. Tjl̈ẽ ga «¿Pja shäng kjone?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","«Kuror ga pja jëk shäng kjor gl̈oroy ga pja bangkjroror ara, ga tja shäng kjwor kjĩshko ga tja opjnenoe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kuya ga tjl̈ẽ ba kong ga «¿“Pja shäng kjwor” l̈aga ërë bop kong? ¿Eni l̈i kjor bo uëy l̇l̇ëme l̈oror bop kong l̈i uoropde?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","«Kjor bo l̈i twaga wal̈ë tworop bor kong l̈irë bor kong ga uorore» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Eni ga kjakrokara wal̈ë l̈i kong ga «¿L̇l̇ëye shäryoropdo?» «Tja jyãpgwaga dgurdë. E kjĩshko ga kjor bo l̈i uorore» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kuya ga tjl̈ẽ dgur l̈i kong ga «L̇l̇ëbo owa shäryorop. E kjĩshko ga pja shdun pja kjl̈araso, öng, äya kjl̈oshko so l̇l̇amo tjeng l̈ira l̇l̇ëme. Pja eröe. Eeri jek l̈ëkong ga pja iër ber buk dopshik ĩ kl̈ung kjing go, ga kl̈ung sho dwëp bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Pja, wal̈ë, pjãy ber l̈öng ëng moskwo, bop tjëyo, ba tjëyo, e ber eni bakoe. Ba tjëyo, pja kä shguiya. Ga pjara omuë ba kjuktushko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ga tjl̈ẽ wal̈ë l̈i kong ga «Pja chida buk döröshko ga iër ber bop kong bang ara, woyotjl̈ĩnor bäm go sorë l̈i kjinmo. Ga pja wo pjang bop l̈anma go. Ga e ber bop ichaga» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ga tjl̈ẽ domer l̈i kong ga «“Kjor bo kjwe uëy l̇l̇ëme” l̈oror bop kong, gueniyo tja kol̈orop l̇l̇ëm, bop boy wl̈era kol̈orop. E kjĩshko ga kl̈ung ëre äyoshtoror, ioror beno l̇l̇ëbo uëp wl̈o ga pakyo shäryëp kjang enido. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kl̈ung, e kjing go kjl̈o sho wen ara shkö tjok, kjil̇l̇gwo shkökyo tjok bakoe. Ga pja ber shäng kjl̈o sho kjl̈oshko so uako, e uopdë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Eshko ga pja parkë shorya go l̇l̇ëm ga pja ië l̇l̇ëme. Pja tek shäryak kl̈ung sho go, kl̈ung sho l̈i pja. Ga l̇l̇ono ga pja kworkwë jek ber kl̈ung sho iröng obishko ga pja parkë pjir äär ber eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","E irgo ga wal̈ë l̈i koiara domer l̈irë Eva, e nopga uunkong mekë kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Shwong pjũya l̈ok wl̈o ga shwong shäryara Sbörë öng kwota go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ga tjl̈ẽ ga «Era domer l̈i öötong l̇l̇ëbo pjl̈ú miydë, l̇l̇ëbo owa miydë, beno so shji kjoyoe. Kjor jong kjl̈ara, ba bo uoroy ga shji wol̈on l̇l̇ëme. Uara l̈ok ga ber l̈öng së ĩyado, e woydër l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","E kjĩshko ga domer l̈i shira Edén kjokyo dwayo ba boy tjok. Bäm goshko ga domer l̈i shäryara kl̈ung sho go. Shirashko ga beno shäng parkë kl̈ung sho l̈i kjing go shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Shira pjir ga Edén kjokyo dl̈o wen tëm shwo l̈ëkong ga Sbö parkagaga kjok dogo so sjä̃gä tjok wl̈eniyo iara beno l̈öng kjl̈öbö eshko. Dröng iara pjang kjwangna l̇l̇etl̇l̇et iök wl̈eni, pjrĩya pjang l̇l̇aw ëre pogo, e beno pjang irbo l̈i dë, ëye jek äär kjor kjl̈ara, ba bo uoroy ga shji wol̈on l̇l̇ëm jong l̈ishko ga ä wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","E irgo ga Adán pono ba boy tjok, ga beno shäng kjl̈araso l̇l̇ëme. E irgo ga wa buk kjl̈ara domer. Ga Eva tjl̈ẽ ga «Tja wa buk kjl̈ara domer, e twaga Jehovárë bor kong» l̈e. E kjĩshko ga koiara Caín. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","E irgo ga wa buk kjl̈ara domer obi ko Abel. E pak beno öng daga. Caínda pak beno dwl̈a dgaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Dbar kjwara ga Caín öör ba dwl̈a dgara l̈i bo kjrë, ga söra jek, twara Jehová kong ba sënggl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abelda, ba öng wl̈ẽp ushko so weno bäm ĩ wl̈eniyo l̈i zröra pjökde myare. Ga ba sho pjl̈ú l̈i söra jek, twara Jehová kong ba sënggl̈o bakoe. Eni ga Jehová beno wopjl̈ú Abel tjok, ba öng twara ba sënggl̈o l̈i tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Gueniyo beno wopjl̈ú Caín tjok l̇l̇ëm, ba dwl̈a bo twara ba sënggl̈o l̈i tjok l̇l̇ëm bakoe. E kjĩshko ga Caín iirkono träk l̇l̇ëm, bokkwo keyeng erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Eni ga Jehová tjl̈ẽ ba kong ga «¿Pja iirkë ara ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","L̇l̇ëbo pjl̈ú shäryorop kjwe ga tja ber wopjl̈ú bop tjok. Gueniyo l̇l̇ëbo owa shäryëp ĩyado ga bong kjönma ga pja ber shäng l̇l̇ëbo owa l̈i shäryë l̇l̇ëm ga äe. Bek wl̈o ga l̇l̇ëbo pjl̈ú l̈i shäryëp, l̇l̇ëbo owa l̈i shäryëp ame wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Dbar jek ga Abel mana Caíndë jëk ba tjok. Öötong l̈öng pjola ga ba l̈ëng l̈i shakza pjä, ga zrörae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","E irgo ga Jehová tjl̈ẽ ba kong ga «¿Bop l̈ëng Abel kwonl̇l̇o?» «Miydër l̇l̇ëme. ¿Eni l̈i tja iak shäng bor l̈ëng dagare?» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","11","Kuya ga tjl̈ẽ ba kong ga «¿L̇l̇ëye shäryoropdo? Bop l̈ëng zrörop. Ba srëng tjeng kl̈ung kjing l̈i ĩnor. E kjĩshko ga pja shdun. Bop l̈ëng srëng kwono kl̈ung kjing go kjĩshko ga pja parkë ber shäng kl̈ung kjing ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Pja parkë ara kl̈ung kjing ëmdë ga l̇l̇ëye botjyë bop kong ame. Pja to shäng jëk kl̈ung kjing kjone pogo ëmdë ga pja shto woshtozl̈ong wl̈o drete» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kuya ga tjl̈ẽ ba kong ga «Bor shdunggl̈o ëre ber kjang anmoyõ. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tja kuzong. Tja parkë kl̈ung kjing ame kjĩshko ga tja to jongya shäng jëk kjok pjola, tja ber bop soshko ame. Tja to shäng tök wl̈eni. Ga tja wl̈ẽna ë pogorë ga tja zröya jekdo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kuya ga tjl̈ẽ ba kong ga «Pja zröga ërë ga e shdun, pja shdunor l̈i kjinmo» l̈e. Eni ga pogl̈o jyã tara, wl̈ẽngga ërë ga zröya l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ga Caín opshino to l̈ano shäng l̈ishko dwayo ga jek öötong sök Nod kjokyo, e ber buk Edén kjokyo, dl̈o wen tëm shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Dbar jek ga Caín pono ba boy tjok, ga beno shäng kjl̈araso l̇l̇ëme. E irgo ga wa buk kjl̈ara domer ko Enoc. E dbaryoshko ga Caín shäng u ywë kjwöböso, kjëryo shäryak ak go pjribri kjókshko. Kjok l̈i kowara Enoc, ba wa l̈i ko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoc, e Irad data. Irad, e Mejuyael data. Mejuyael, e Metusael data. Metusael, e Lamec data. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamec, e boy do pjök, kjl̈ara ko Ada, kjl̈ara ko Zila. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","21","Ada, e wapga domerga do pjök, kjl̈ara ko Jabal, kjl̈ara ko Jubal. Nopga to l̈öng öng daga kjok shto obl̈ë obl̈ë, ba u shäryak öng kwota go l̈i, shäryaga shäng bäm go l̈i Jabal. Nopga dbonmo të, nopga kjorkwang shäryak jong kjiyo tjok tëy or go wl̈eniyo l̈i të, e shäryaga bäm go l̈i Jubal. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ga Zilara wa buk kjl̈ara domer ko Tubal Caín. Nopga parkokl̈o shäryë dröng shosho obl̈ë obl̈ë go l̈i, shäryaga shäng bäm go l̈i Tubal Caín. E dor shäng kjl̈ara ko Noamá. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Pjl̈ara ga Lamec tjl̈ẽ ba boyga kong ga «L̇l̇ëye l̈ër bomi kong l̈i kuzĩ yõtso. Domer zröror kjl̈ara, tja zara kjĩshko. Dwl̈as zröror kjl̈ara bako, tja shpora kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Caín zröga ërë ga e shdũya Sbörë, Caín shduna l̈i kjinmo. Tjara zröga ërë ga shdũya, Caín zröga l̈i kjinmo obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Dbar jek ga Adán, Eva, e wa buk kjl̈ara domer obi, ga koiara Set. Eshko ga Eva tjl̈ẽ ga «Tja kjimtara Sbörë, tja kong wa twara kjl̈ara obi. E ber shäng Abel, zröra Caíndë l̈i ãska. E kjĩshko ga koiër Set» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","E irgo ga Set, e wa buk kjl̈ara domer, ga koiara Enós. Enós dbaryo ga oba syõshtono Jehová kong kjwl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Nopga shäryara Sbörë so e om go kjoyoe. Shäryara domer, wal̈ë. E kjimtara, ga koiara «nopga». Ëre ba tjëyo tek beno ba irgo l̈i kjibokwoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adán, e öötong l̈u pjl̈ogl̈o sak dbäw kjingsho sak myashko (130) ga wa buk kjl̈ara domer so e om go kjoyo, ga koiara Set. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","5","E irgo ga wapga weno obi. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o shkaw kjingsho sak myashko (930) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set, e öötong l̈u pjl̈ogl̈o sak dbäw kjingsho shkëngshko (105) ga wa buk kjl̈ara ko Enós. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","8","E irgo ga wapga weno obi. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o shkaw kjingsho sak kjwara kjingsho pjökshko (912) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enós, e öötong l̈u pjl̈ogl̈o sak shkawshko (90) ga wa buk kjl̈ara ko Cainán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","11","E irgo ga wapga weno obi. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o shkaw kjingsho shkëngshko (905) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainán, e öötong l̈u pjl̈ogl̈o sak kjäkshko (70) ga wa buk kjl̈ara ko Malalel. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","14","E irgo ga wapga weno obi. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o shkaw kjingsho sak kjwarashko (910) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malalel, e öötong l̈u pjl̈ogl̈o sak tjer kjingsho shkëngshko (65) ga wa buk kjl̈ara ko Jared. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","17","E irgo ga wapga weno obi. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o kjwong kjingsho sak shkaw kjingsho shkëngshko (895) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared, e öötong l̈u pjl̈ogl̈o sak dbäw kjingsho sak tjer kjingsho pjökshko (162) ga wa buk kjl̈ara ko Enoc. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","20","E irgo ga wapga weno obi. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o shkaw kjingsho sak tjer kjingsho pjökshko (962) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoc, e öötong l̈u pjl̈ogl̈o sak tjer kjingsho shkëngshko (65) ga wa buk kjl̈ara ko Matusalén. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","E irgo ga wapga weno obi. Enoc, e Sbö woydë owa l̇l̇ëm, ga jëk shäng ba tjok ĩyado. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o mya kjingsho sak tjer kjingsho shkëngshko (365) ga söra Sbörë to, ĩnaba ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalén, e öötong l̈u pjl̈ogl̈o sak dbäw kjingsho sak kjwong kjingsho kjäkshko (187) ga wa buk kjl̈ara ko Lamec. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","27","E irgo ga wapga weno obi. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o shkaw kjingsho sak tjer kjingsho shkawshko (969) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec, e öötong l̈u pjl̈ogl̈o sak dbäw kjingsho sak kjwong kjingsho pjökshko (182) ga wa buk kjl̈ara domer. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ga tjl̈ẽ ga «Shji parkë ara kjok ëre kjing go, kjok l̈i äyoshtara Jehovárë kjĩshko. Gueniyo chida ërera shji ie ber l̈öng woshtë» l̈e. E kjĩshko ga ba wa l̈i kowara Noé. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","31","E irgo ga wapga weno obi. Ga l̈u ĩno öötong sak dbäw pjl̈ogl̈o kjäk kjingsho sak kjäk kjingsho kjäkshko (777) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé, e öötong l̈u pjl̈ogl̈o sak dbäw pjl̈ogl̈o shkëngshko (500) ga wapga tjeng domerga dogl̈o mya, Sem, Jafet, Cam. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Nopga, e wapga shdöktong träk l̇l̇ëm kjok ëre kjing goshko. Ga wapga wal̈ëga kjong kjong wol̈ësowa. E kjĩshko ga Sbö wapga orkwosmono wal̈ëga woyde kjone dey l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Eni ga Jehová tjl̈ẽ ga «Nopga, e iër ber l̈öng së ĩyado l̇l̇ëm, e wol̈on wl̈o kjĩshko. Eni ga iër ber l̈öng së l̈u pjl̈ogl̈o sak dbäw kjingsho sak pjök (120) eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Sbö wapga orkwosmono wal̈ëga kjok ëre so tjokshko ga wapga weno sok këskës, obl̈ë kjinmo. Ga nopga tjwl̈õ ara tek dënashko so l̈i epga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ĩya Jehovárë ga nopga l̈öng l̇l̇ëbo owa shäryë ara anmoyõ, ga wotjl̈ĩk owa erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Eni ga wotjl̈ĩk ga «Nopga shäryoror l̇l̇ëm kjwe dey, bangyo ara bor pjl̈úshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ga tjl̈ẽ ga «Nopga shäryoror tjeng kl̈ung kjing ëre kjër jũshko dwayo. Shäryër öng, äya kjl̈oshko so, sënwa tjok eni bakoe. Woyotjl̈ĩn ga shäryoror l̇l̇ëm kjwe dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Gueniyo ga domer shäng kjl̈ara ko Noé. Jehová wopjl̈ú ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ëre l̇l̇ëye shäryara Noérë dö l̈i kjibokwoyo. E domer pjl̈o bek, pogo l̇l̇ëye dret Sbö bokso. L̇l̇ëye woyde Sbörë l̈i shärye eni, ga jëk shäng ba tjok ĩyado. Nopga obl̈ë obl̈ë omshäryono eni l̇l̇ëm, Noé eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","E wapga domerga dogl̈o mya, Sem, Jafet, Cam. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Ga ĩya Sbörë ga kl̈ung ëre kjing go l̇l̇ëbo owa ara, nopga ëngkjwë ara ëng tjok, l̇l̇gwega ërë l̇l̇ëme. Nopga l̈öng kës l̈i beno l̈öng l̇l̇ëbo owa shäryë eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","E kjĩshko ga Sbö tjl̈ẽ Noé kong ga «Tja wotjl̈ĩk nopga pjik uunkong l̈ër. L̈öng ëngkjwë ara ëng tjok. L̈öng l̇l̇ëbo owa shäryë erä. E kjĩshko ga e pjir ber dret, l̇l̇ëbo tjeng kl̈ung ëre kjing go l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","»Eni ga kjorkwang wl̈ẽs pjl̈ú, owa l̇l̇ëm wl̈eniyo, ga kjyong shäryos kjl̈ara kësbange. Kjyong bängyos pjir kjoko, ro l̈ëkong bako, di opzrëk l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Shäryos jyãgl̈o eni: kur orkwo jyãgl̈o pjl̈ogl̈o sak dbäw pjl̈ogl̈o mya (300); bam orkwo jyãgl̈o pjl̈ogl̈o sak shkëng (50); jem kjomo l̈ëkong wop orkwo jyãgl̈o pjl̈ogl̈o sak mya (30). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Shäryos yongyo kjringgwo mya, kjëryo tjok tjok. U dbo kjing shäryos tuk, ba dirko shäryos ber oojong pjribri, kur orkwo jyãgl̈o kjwara. U bäng shäryos ber jong kjwara ba pogl̈o go, e opzrëkkl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","»Di ichër kësbang, kjok ëre pir wl̈o. Eshko ga l̇l̇ëye l̈öng së kjok kjwang jĩkong kjing go ga e kjer drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Gueniyo ga tjl̈õkwo twër bop kong, ber ĩyado wl̈o. Pja jem opzrëk kjyong l̈i roy, bop boy, bop wapga, bop pjl̈aydoga tjok, pjãy wol̈on l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","»Öng, äya kjl̈oshko so, sënwa, e l̈öng kjok ëre kjing go kës l̈i, e jem sös pjök pjök, wl̈ënggl̈a kjl̈ara kjl̈ara, popga kjl̈ara kjl̈ara, kjer l̇l̇ëm wl̈o. Woydër ga ber l̈öng së, pjãy dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Dl̈i tö̃s l̇l̇ërba pogo, ga jem sös bomi tjok, e bomi kong, e öng, äya kjl̈oshko so, sënwa tjeng l̈i kong bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","L̇l̇ëye l̈ara ba kong l̈i shäryara Noérë uunkong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","E irgo ga Jehová tjl̈ẽ Noé kong ga «No kjl̈araso wl̈ẽnor shäng pjl̈o bek bor bokso l̈i pja. E kjĩshko ga pja opzrës jem kjyong l̈i roy, bop boy, bop wapga, bop pjl̈aydoga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Öng ber pjl̈ú bor poshrëkkl̈o wl̈o obl̈ë obl̈ë, sënwa obl̈ë obl̈ë, e sös wl̈ënggl̈a dogl̈o kjäk kjäk (7), popga dogl̈o kjäk kjäk (7). L̇l̇amo sös wl̈ënggl̈a kjl̈ara kjl̈ara, popga kjl̈ara kjl̈ara. Shäryos eni, jer kjok ëre kjing go l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Sondë kjwara go ga shunyo ichër shrë dbargwo sak pkëng (40), shkë dbae. Eshko ga l̇l̇ëye shäryoror tek dämärshko l̈öng së l̈i pjiga tjarë ber drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kuya ga l̇l̇ëye l̈ara ba kong l̈i shäryara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Kjok ëre piktongshko ga Noé l̈u pjl̈ogl̈o sak dbäw pjl̈ogl̈o tjer (600). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Era eni ga opzrëno jem kjyong l̈i roy, ba boy, ba wapga, ba pjl̈aydoga tjok, shtẽya dirë l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ga öng uako wl̈eniyo, öng uako l̇l̇ëm wl̈eniyo, äya kjl̈oshko so, sënwa, e öötong l̈öng ba shwoy, ga söra jem pjök pjök, wl̈ënggl̈a kjl̈ara kjl̈ara, popga kjl̈ara kjl̈ara, l̈ara Sbörë ba kong sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Öötong dbargwo kjäk (7) ga shunyo shrono, kjok ëre pir wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","18","Mok pjök, dbar sak kjwara kjingsho kjäk (17) dbaryo ga Noé l̈u pjl̈ogl̈o sak dbäw pjl̈ogl̈o tjer (600). E dbaryo ga opzrëno jem kjyong l̈i roy, ba boy, ba wapga, ba pjl̈aydoga tjok. Öng, äya kjl̈oshko so, sënwa, e opzrëno jem l̈ok pjök pjök kjyong l̈i roy ba tjok bakoe. Opzrëno jem wl̈ënggl̈a kjl̈ara kjl̈ara, popga kjl̈ara kjl̈ara. L̈ara Sbörë ba kong sorë l̈i shäryara eni. E irgo ga u bäng bängzara Jehovárë beno jong tuke. E dbaryo ga dl̈ung kësbang buk kjok dorong l̈i dl̈oktong, tuktong kjone pogo. Kjok dogo ëmdë ga di börgak tjeng l̈i böptuktonge. Shunyo shrono pjang kjok ëre kjing go dbargwo sak pkëng (40), shkë dbae. Eshkoshko ga di jem poyong l̇l̇ögong l̇l̇ögong, ga kjyong l̈i beno buk di kjing wëng erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Di poyono ara, öötong dl̈up l̇l̇ë l̈ok kjok ëre kjing go kjókshko l̈i jnena beno drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","E irgo ga dl̈up l̇l̇ë jnena pjirshko ga di l̈i poyono jem, öötong wop orkwo jyãgl̈o pjl̈ogl̈o sak kjwara kjingsho shkëng (15). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nopga l̈öng kjok ëre kjing go kës l̈i wol̈ono eni. Öng, äya kjl̈oshko so, sënwa, e l̈öng kjok ëre kjing go kës l̈i kjëtong eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","L̇l̇ëye l̈öng së kjok ëre kjing go, tjwl̈õ shrë wl̈eniyo, e kjëtong drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Gueniyo Noéra beno sök së, l̈öng kjyong l̈i roshko ba tjok bakoe. Epga eröe. L̇l̇amo pjitong dret, nopga, öng, äya kjl̈oshko so, sënwa bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ga kjok ëre piktong beno eni, öötong dbargwo sak dbäw kjingsho sak shkëng (150). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Eshkoshko ga Noé woyojera Sbörë l̇l̇ëm, öng, äya kjl̈oshko so, e l̈öng ba tjok kjyong roy l̈i woyojera l̇l̇ëm bakoe. Eni ga pjl̈uk ichara di kjing go kjrina. Wop sira ga di kl̈än jer iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Dl̈ung kësbang buk kjok dorong dl̈oktong l̈i sjëktong, ga shunyo ter shrono kjok dogo dwayo ame bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Eni ga di kl̈än jer jong worae. Kjok ëre piktong beno dbargwo sak dbäw kjingsho sak shkëngshko (150) ga di kl̈äno jer dëgong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Mok kjäk (7), dbar sak kjwara kjingsho kjäk (17) dbaryo ga kjyong l̈i dano beno buk Ararat kjokyo, dl̈up l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Eshko ga di kl̈äno jer dëgong obi. Ga öötong mok sak kjwara (10), dbar kjwara dbaryo ga dl̈up l̇l̇ë kjókshko l̈i dl̈up dbo go ĩya ga wen l̈ok wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Öötong dbargwo sak pkëng (40) obi ga Noé sökshko ga u bäng shäryara l̈i döra. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ga sënwa shira kjwara so ëp uaga kjoyo, ga ichara dbuk pjang jek l̈ë, tek l̈ë, kjok dano l̈i koshë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","E irgo ga sënwa shira kjwara obi, e dunggwo shara, kl̈ung kjing di dano beno buk dogrore ĩk wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Gueniyo shto wl̈ẽno opyë wl̈o ga ä, kl̈ung buk l̈i kjing go di obi kjĩshko. Eni ga shrono iröng obishko ga Noé orkwo shino kjoko, ga kjrara, iara jek ba shtoshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Koshara dbargwo kjäk (7) irgo ga dunggwo ichara jek kjwara obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kjok ro zar kjwl̈ë ga dunggwo l̈i shrono tek pjang iröng, kjor korga tjagl̈ën söra tjeng kara ba kowo go. Miydara e go ga kl̈ung dogrotkë jeke. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Koshara dbargwo kjäk (7) obi irgo ga dunggwo ichara jek kjwara obi, ga shrono ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noé l̈u pjl̈ogl̈o sak dbäw pjl̈ogl̈o tjer kjingsho kjwarashko (601) ga di beno kl̈ung kjing go ame. Mok kjl̈ara, dbar kjwara dbaryo ga kjyong l̈i kjing, e kjara ga ĩya ga kl̈ung kjing l̈i beno buk dogroe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Öötong mok pjök, dbar sak pjök kjingsho kjäk (27) dbaryo ga kl̈ung dano beno buk kjange. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Eni ga Sbö tjl̈ẽ Noé kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Pja opshis kjyong wl̈e roy dwayo, bop boy, bop wapga, bop pjl̈aydoga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Öng, äya kjl̈oshko so, sënwa, e tjeng bop tjok kës l̈i shis dret bako, shdär ber l̈öng kjok kjwang jĩkong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kuya ga opshino kjyong roy dwayo, ba boy, ba wapga, ba pjl̈aydoga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Öng, äya kjl̈oshko so, sënwa, e l̈öng obl̈ë obl̈ë eshko l̈i opshino tjë jĩkong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","E irgo ga Noé akkwo töno dl̈uw ëng kjing go kjókshko, ga öng zröra, sho sura e kjing go, pjono dret, Jehová poshrëkkl̈o. Ga öng uako wl̈eniyo shara obl̈ë obl̈ë kjl̈ara kjl̈ara, sënwa uako wl̈eniyo shara obl̈ë obl̈ë kjwara kjwara bakoe. Eshko ga zröra uunkong, ga sho sura Jehová kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Öng sho sura l̈i l̈õ beno pjl̈ú, owa l̇l̇ëm Jehová kong. Ga wotjl̈ĩk ga «Nopga, e tek miteshko ga wotjl̈ĩk l̇l̇ëbo owa shäryë eröe. Eni ëmdë ga kjok ëre äyoshtër nopga l̈i kjĩshko ame. Öng kës, äya kjl̈oshko so kës, e pjiror sorë ga shäryër eni ame bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","»Kjok ëre pjang obishko ga dwl̈a dgozl̈ong dbaryo tjok, dwl̈a bo kjrozl̈ong dbaryo tjok, kjok kjl̈ik dbaryo tjok, kjok zengteng dbaryo tjok, shunyo dbaryo tjok, dl̈o të dbaryo tjok, dba tjok, shkë tjok bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Eshko ga Sbö tjl̈ẽno beno pjl̈ú Noé, ba wapga kong bakoe. Tjl̈ẽ ga «Pjãy wapga wenzong ara, shdär ber l̈öng kjok kjwang jĩkong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Öng kës, äya kjl̈oshko so kës, e ber bomi bangkjrë ara, dete erä, kjok dirko so, kjok ëre so, dl̈ung roy so, e ber eni bakoe. E ber l̈öng ichaga pjãydë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Dënashko ga l̇l̇ëbo dguëy kl̈ung kjing botjyë wl̈eniyo, l̇l̇amo obl̈ë obl̈ë, e tworor bomi kong uëmi wl̈o. Eeri ga l̇l̇ëbo l̈öng së, jëk l̈öng ĩ, e twër bomi kong. E ber bomi dl̈i bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Gueniyo l̇l̇ëbo l̈öng së l̈i l̈aga ba srëngdë. E kjĩshko ga sjëngna srëng tjok, e uëy l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","»Nopga shäryoror so tja kjoyoe. E kjĩshko ga ëye no zröno ga e shdungga tjarë, zröga äya kjl̈oshko sorë, zröga öng ushko sorë ëmdë ga e shdun eni bakoe. No zröga ërë ga e zröy. L̈ër jl̈õkoyo ga eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","»Gueniyo bomi kong ga pjãy wapga wenzong ara, shdär ber l̈öng kjok kjwang jĩkong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Eshko ga tjl̈ẽ ba kong obi ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«¡Tja kuzĩa! Tjl̈õkwo twër bomi kong, ber ĩyado wl̈o. E twër bomi tjëyo tek ber bomi irgo l̈i kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","E twër sënwa, öng, äya kjl̈oshko so, e ter söromi bomi tjok kjyong kësbang roy dwayo kës l̈i kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Eni ga tjl̈õkwo twër bomi kong, ber ĩyado wl̈o. Di ichër kjok ëre kjing go, nopga, öng, äya kjl̈oshko so, e pjir uunkong wl̈o ame. Di ichër, kjok kjwang jĩkong pjir wl̈o ame bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Tjl̈õkwo ëre twër bomi kong, öng, äya kjl̈oshko so uunkong kong, kjok kjwang jĩkong kong bakoe. E twër bomi kong, ber ĩyado wl̈o. Bor donku ëre iër ber pjang kjok dogo. E ber pjang tjl̈õkwo ëre jyãgl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Pjäng ichër ĩmi wen pjang kjok dogo, ga donku wen pjang ba tjrëkoshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","woyoshrër ga tjl̈õkwo tworor bomi kong, öng, äya kjl̈oshko so uunkong kong ga shunyo ichër tjwe e kjoyo kjok pjikkl̈o ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Donku wen pjang pjäng tjrëkoshko ga e ĩn, ga tjl̈õkwo tworor nopga uunkong kong, öng, äya kjl̈oshko so uunkong kong l̈i woyoshrër eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Donku, e ber pjang tjl̈õkwo ëre jyãgl̈o. Ber eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé wapga opshino kjyong kësbang roy dwayo l̈i, e Sem, Jafet, Cam. (Cam wa buk kjl̈ara ko Canaán.) ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Shji l̈öng kjok kjwang jĩkong kës ëre beno l̈öng Noé wapga mya l̈i, e tjëyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé beno shäng dwl̈a dgaga. Ga kjil̇l̇gwo bo dyo dbo ara shärye wl̈o ga kjil̇l̇gwo eniyo l̈i dwl̈ayo dgara kjwöbö. Kjil̇l̇gwo eniyo dgaga bäm l̈i e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Pjl̈ara ga kjil̇l̇gwo bo dyo dbo ara l̈i iara, ga nel̈õtkonoe. Ga shwong skwono beno buk kjwor ba u shäryak öng kwota go l̈i roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Eni ga Canaán data Cam, e opzrëno jek ba data u l̈i roshko, ga wl̈ẽna, ĩna buk nel̈õ, kjwor. Eshko ga opshino jek, ga roy l̈ara ba shjiyga kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Eni ga Sem, Jafet, e kjinyokl̈o kjrono kara, iara l̈ok ba dbopdo, ga jëktong kokso l̈ëkong ba data buk l̈ishko, ga kjingara e go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noé nel̈õ jenoshko ga wol̇l̇eno. L̇l̇ëye shäryara ba wa iröng wl̈eniyorë l̈i miydarashko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","tjl̈ẽ ba kong ga «¡Bop wa Canaán, e äyoshtër! ¡E ber shäng bop shjiyga kjwe parkaga tjwl̈ẽk shäng pjir wl̈eniyo!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ga tjl̈ẽ Jehová kong ga «Jehová, pja tjwl̈õ kësbange. Pja Sem Sbö. Canaán, e ber shäng ba parkaga tjwl̈ẽk shäng pjir wl̈eniyo ga pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Sbö, kjok twos tira l̇l̇ëm Jafet kong. Ba tjëyoga ios ber l̈öng uunkong Sem tjok. Ga Canaán ios ber shäng ba parkaga tjwl̈ẽk shäng pjir wl̈eniyo bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kjok piktong irgo ga Noé l̈u ĩno pjl̈ogl̈o sak dbäw pjl̈ogl̈o mya kjingsho sak shkëng (350). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","E l̈u ĩno öötong sak dbäw pjl̈ogl̈o shkaw kjingsho sak shkëngshko (950) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Sem, Jafet, Cam, e Noé wapga. Ëre ba tjëyo tek beno ba irgo l̈i kjibokwoyo. Kjok piktong irgo ga mya jĩkong l̈i wapga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafet, e wapga domerga ko eni: Gómer, Magog, Maday, Javán, Tubal, Mésec, Tirás. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gómer, e wapga domerga ko eni: Asquenaz, Rifat, Togarma. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javán, e wapga domerga ko eni: Elisá, Tarsis, Quitín, Dodanín. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ëre Jafet tjëyo tek beno ba irgo. Ga beno to l̈öng dl̈ung kjako. Tjëyo kjrina kjrina l̈i beno l̈öng ba kjok baĩya kjing go, ba tjl̈õkwo baĩya tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Cam, e wapga domerga ko eni: Cus, Misrayin, Fut, Canaán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cus, e wapga domerga ko eni: Seba, Javilá, Sabtá, Ragama, Sabteca. Ragama, e wapga domerga ko eni: Sabá, Dedán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus, e wa buk kjl̈ara domer obi ko Nimrod. E ëngkjwaga dbo ara wl̈eniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kjimtara Jehovárë kjĩshko ga e wl̈o pjl̈úe. E kjĩshko ga oba tjl̈ẽ ga «Kjwe kjimtara Jehovárë kjĩshko ga kjwe wl̈o pjl̈ú, Nimrod ĩ dik» l̈ëba eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kjok tjeng pkëng (4) ko Babel, Érec, Acad, Calné. Pkëng jĩkong, e Sinar kjokyo obl̈ë obl̈ë. Kjrina kjrina kjëryo shäryak ak go pjribri kjókshko. Kjok eshko sopga ichaga Nimroddë bäm go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","E irgo ga opshino jek shäng Asiria kjokyo l̈ëkong. Eshko ga kjok shto obl̈ë obl̈ë u ywara kjwöböso. Kjok kjrina kjrina kjëryo shäryak ak go pjribri kjókshko. Kjok, e ko Nínive, Rejobot Ir, Cala, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resén. Resén, e kjokyo kësbange. E ber buk Nínive kjokyo, Cala kjokyo, e tjrëko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrayin, e tjëyo tek beno ba irgo l̈i beno tjëyo kop ara. E Lud tjëyo, Anam tjëyo, Lehab tjëyo, Naftu tjëyo, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrus tjëyo, Caslu tjëyo, Caftor tjëyo. Filisteoga, e Caftor tjëyo obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaán, ba wa domer bäm ĩyo l̈i ko Sidón. E irgo ga wa buk kjl̈ara domer obi ko Het. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaán, e tjëyo tek beno ba irgo l̈i beno tjëyo kop ara. E Jebús sopga, amorreoga, gergeseoga, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveoga, araceoga, sineoga, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvad sopga, zemareoga, jamatitaga. E irgo ga Canaán so tjëyoga shdöktonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ba kjok, e ber buk Guerar kjokyo, Sidón kjokyo, e dwayo äär jong Gaza kjokyo go. Sodoma kjokyo, Gomorra kjokyo, Admá kjokyo, Zeboyín kjokyo, e shwo l̈ëkong äär jong Lasa kjokyo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ëre Cam tjëyo tek beno ba irgo. Tjëyo kjrina kjrina l̈i beno l̈öng ba kjok baĩya kjing go, ba tjl̈õkwo baĩya tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafet shjiy Sem, e wapga tjeng bakoe. Éber tjëyo tek beno ba irgo l̈i, e beno l̈öng Sem tjëyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem, e wapga domerga ko eni: Elam, Asur, Arfaxad, Lud, Aram. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram, e wapga domerga ko eni: Uz, Hul, Guéter, Mas. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad, e wa buk kjl̈ara domer ko Selaj. Selaj, e wa buk kjl̈ara domer ko Éber. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Éber, e wapga domerga do pjök, kjl̈ara koiara Péleg, eshko dbaryo ga nopga shdöktong beno tjeng dboy dboy kjĩshko. Péleg, e l̈ëng ko Joctán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctán, e wapga domerga ko eni: Almodad, Sélef, Jazar Mávet, Yeraj, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadorán, Uzal, Diclá, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sabá, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Javilá, Jobab. Epga uunkong Joctán wapga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ba kjok, e beno buk Mesá kjokyo dwayo äär jong Sefar kjokyo go. Sefar, e ber buk dl̈up l̈ok dl̈o wen tëm shwo l̈ëkong tjrëko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ëre Sem tjëyo tek beno ba irgo. Tjëyo kjrina kjrina l̈i beno l̈öng ba kjok baĩya kjing go, ba tjl̈õkwo baĩya tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Tjëyoga uunkong ëre, e Noé wapga tjëyoga. Tjëyo kjrina kjrina tak beno l̈ok kjibokwo ëre go ba kjokëso tjok, ba kjok baĩya tjok bakoe. Kl̈ung piktong irgo ga epga shdöktong beno l̈öng kjone pogo. Eeri ga tjëyo l̈öng kjrina kjrina kjok kjwang jĩkong, e Noé wapga tjëyoga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Dbar eshkoshko ga nopga uunkong tjl̈ẽ tjl̈õkwo kjwaraso. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Opshino jek l̈öng dl̈o wen tëm shwo l̈ëkong dwayo ga jek öötong l̈öng Sinar kjokyo kjing goshko ga sdam wl̈ẽna buk kjrina, ga beno l̈öng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Pjl̈ara ga tjl̈ẽ ëng kong ga «Shji kl̈ung shosho shäryë, piy iök go ber kjang ak dik wl̈o, u shäryëy e go wl̈o, ak ãska. Sho smoy ëng go ba smokkl̈o dishäng kjoyo, gueniyo sho sĩ go, ak smokkl̈o sho ãska. E go ga kjweri shji u ywë kjwöböso, kjëryo shäryëy ak go pjribri kjókshko. Ga u shäryëy kl̈ung akyo go, e shäryëy jem äär jong kjok dogo. E go ga shji shdär l̇l̇ëm, gueniyo shji roy shdär ber kjok kjwang jĩkong. Eni ga shji ber tjwl̈õ ara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Gueniyo ga nopga l̈öng u ywë kjwöböso, kjëryo shäryak ak go pjribri kjókshko, ga l̈öng u shäryë kl̈ung akyo go jem jong kjok dogo l̈ëshko ga Jehová ter öör eshko ba pak l̈i ĩk. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Eshko ga wotjl̈ĩk ga «Nopga kjwe tjëyo kjrinaso, tjl̈õkwo jong kjwaraso bakoe. Eni ga l̇l̇ëye shärye woydë kës l̈i, e sl̈ongga ërë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Shji to jer ba tjl̈õkwo kjl̈opswë, tjl̈ẽ ber l̈öng obl̈ë obl̈ë wl̈o, tjl̈ẽ ga l̇l̇ë l̈ayde ëng kong l̈i miyde l̇l̇ëm wl̈o. Shäryëy eni dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nopga iara Jehovárë beno tjeng dboy dboy kjok shto obl̈ë obl̈ë eni. Ga ba pak shärye l̈öng l̈i rayarae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kjok eshko ga tjl̈õkwo kjl̈opswara Jehovárë beno wẽl̈ë l̇l̇ëmshko ga nopga shdöktong to beno l̈öng dboy dboy kjok kjwang jĩkong. E kjĩshko ga kjok ëre kowëba Babel. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ëre Sem tjëyo tek beno ba irgo. Kjok piktong irgo ga öötong l̈u pjl̈ogl̈o pjök ga Sem, e l̈u pjl̈ogl̈o sak dbäwshko (100) ga wa buk kjl̈ara domer ko Arfaxad. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","E irgo ga l̈u ĩno sak dbäw pjl̈ogl̈o shkëng (500) obi, ga wapga weno obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad, e l̈u pjl̈ogl̈o sak mya kjingsho shkëngshko (35) ga wa buk kjl̈ara domer ko Selaj. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","E irgo ga l̈u ĩno sak dbäw pjl̈ogl̈o pkëng kjingsho mya (403) obi, ga wapga weno obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selaj, e l̈u pjl̈ogl̈o sak myashko (30) ga wa buk kjl̈ara domer ko Éber. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","E irgo ga l̈u ĩno sak dbäw pjl̈ogl̈o pkëng kjingsho mya (403) obi, ga wapga weno obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Éber, e l̈u pjl̈ogl̈o sak mya kjingsho pkëngshko (34) ga wa buk kjl̈ara domer ko Péleg. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","E irgo ga l̈u ĩno sak dbäw pjl̈ogl̈o pkëng kjingsho sak mya (430) obi, ga wapga weno obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Péleg, e l̈u pjl̈ogl̈o sak myashko (30) ga wa buk kjl̈ara domer ko Reú. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","E irgo ga l̈u ĩno sak dbäw pjl̈ogl̈o pjök kjingsho shkaw (209) obi, ga wapga weno obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reú, e l̈u pjl̈ogl̈o sak mya kjingsho pjökshko (32) ga wa buk kjl̈ara domer ko Serug. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","E irgo ga l̈u ĩno sak dbäw pjl̈ogl̈o pjök kjingsho kjäk (207) obi, ga wapga weno obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug, e l̈u pjl̈ogl̈o sak myashko (30) ga wa buk kjl̈ara domer ko Najor. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","E irgo ga l̈u ĩno sak dbäw pjl̈ogl̈o pjök (200) obi, ga wapga weno obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Najor, e l̈u pjl̈ogl̈o sak pjök kjingsho shkawshko (29) ga wa buk kjl̈ara domer ko Taré. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","E irgo ga l̈u ĩno sak dbäw kjingsho sak kjwara kjingsho shkaw (119) obi, ga wapga weno obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taré, e l̈u pjl̈ogl̈o sak kjäkshko (70) ga wapga tjeng domerga ko Abram, Najor, Jarán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ëre Taré tjëyo tek beno ba irgo. Ba wapga ko Abram, Najor, Jarán. Jarán, e wa kjl̈ara ko Lot. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Jarán l̈i wol̈ono buk Caldea so kjokyo ko Ur, e weno bukshko. Wol̈onoshko ga ba data sök së obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Wal̈ë shäng kjl̈ara ko Saray. Abram, e orkwosmono ba tjok. Jarán, e wapga wal̈ëga ko Milca, Iscá. Najor, e orkwosmono Milca tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray, e wapga l̇l̇ëm, e kjrong kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taré wl̈o opshino Caldea so kjokyo ko Ur dwayo, jongya jong Canaán kjokyo wl̈o. Ga ba wa Abram, e söra jek Abram boy Saray tjok, ba tjër Lot tjok bakoe. Gueniyo ga öötong l̈öng Jarán kjokyo ga beno l̈öng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Kjok eshko ga Taré l̈u ĩno öötong sak dbäw pjl̈ogl̈o pjök kjingsho shkëngshko (205) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Pjl̈ara ga Jehová tjl̈ẽ Abram kong ga «Bop kjok, bop tjëyo, bop pjeyoga, e rayos ber uunkong, ga pja nom jek kjokyo kjone pin bop kong l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Eshko ga bop tjëyo tek ber bop irgo l̈i, e iër ber shdär träk l̇l̇ëm, ber tjëyo kësbang wl̈o. Pja kjimtër, pja ber tjwl̈õ ara wl̈o. Eni ga nopga uunkong kjimtër bebi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ëye wotjl̈ĩk pjl̈ú bop kong ga tja wotjl̈ĩk pjl̈ú ba kong bebi. Ëye wotjl̈ĩk owa bop kong ga tja wotjl̈ĩk owa ba kong bebi bakoe. Bop kjĩshko ga tjëyoga l̈öng kjok ëre kjing go kjimtër uunkong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kuya ga toe. Abram l̈u pjl̈ogl̈o sak kjäk kjingsho shkëngshko (75) ga opshino Jarán kjokyo dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ba boy Saray, ba shtop Lot, ba l̇l̇ëbo uunkong, ba parkagaga l̈öng ba tjok, e söra jek uunkong Canaán kjokyo. Öötong l̈öng eshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","jëktong ara ga öötong l̈öng Moré kjokyo, kjor jong kjl̈ara kësbang l̈ishko, Siquén kjokyo ber buk soshko. Eshkoshko ga Canaán sopga l̈öng eshko obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Eshko ga Jehová weno shäng Abram kong, ga tjl̈ẽ ba kong ga «Kjok ëre twër ber bop tjëyo tek ber bop irgo l̈i kong» l̈e. Jehová weno shäng ba kong eshko kjĩshko ga akkwo töna dl̈uw ëng kjing go kjókshko, Jehová poshrëkkl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Pjir ga jëk öötong l̈öng dl̈up shwo l̈ëkong, Betel kjokyo ber buk soshko. Eshko ga ba u shäryak öng kwota go söya jek ba tjok l̈i iara jong Betel kjokyo, Hai kjokyo, e tjrëko. Eshko ga akkwo töna dl̈uw ëng kjing go kjókshko, Jehová poshrëkkl̈o obi. Shäryara pjir ga syõshtono Jehová kong eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","E irgo ga jek l̈öng shtor shtor, irbo jek jong äär Néguev kjokyo shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Eshko ga öötong l̈öng l̈ishko ga pjl̈i shrono arae. E kjĩshko ga Abram wl̈o opshino to l̈ok ey dwayo, jongya jong Egipto kjokyo, ber l̈öng eshko dbar kjwöbö wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Jek l̈öng ääto Egipto kjokyo ga Abram tjl̈ẽ ba boy kong ga «Miydër pjl̈ú ga pja wol̈ësowa. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Pja ĩya Egipto sopgarë ga pja bor boy l̈e, ga tja zröya l̈ok bop kjĩshko, pja ber ba kong wl̈o dani. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","E kjĩshko ga tja zröya l̈ok bop kjĩshko l̇l̇ëm wl̈o ga pja bor dor l̈ëp ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Eni ga öötong l̈öng Egipto kjokyo ga kjok eshko sopga tjl̈ẽ ëng kong ga «Ba boy kjwe wol̈ësowa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Egipto so pjl̈uyo parkagaga omĩno l̈ok bakoe. Ga tjl̈ẽ ba pjl̈uyo kong ga «Wal̈ë shrono shäng kjl̈ara wol̈ësowa» l̈e, ga Saray l̈i söra l̈ok jekdo pjl̈u ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Eni ga Saray kjĩshko ga Abram wl̈okjrara, dara l̈ok pjl̈úe. Sëna öng këskës chila, ga parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo twara ba kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Gueniyo ga Saray kjĩshko ga pjl̈u l̈i shduna Jehovárë, ba pjeyoga uunkong tjok, swl̈o ichara träk l̇l̇ëm ba ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","E kjĩshko ga Abram rokara pjl̈u l̈irë tek ba shwoy, ga tjl̈ẽ ba kong ga «¿Pja l̇l̇ëbo shäryono bor kong kjweni ega? ¿“Wal̈ë ëre bor boy” l̈orop bor kong l̇l̇ëm ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","“Kjwe bor dor” l̈orop bor kong kuzong ga sirashko ga kjwe kjwe kjroror bor boy. Bop boy shäng ëre. ¡Sös bop tjok, ga pjãy nomo!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Eni ga ba parkagaga ichara Abram ichë jek Egipto kjokyo dwayo, ba boy, ba l̇l̇ëbo uunkong tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram opshino to Egipto kjokyo dwayoshko ga jek öötong shäng Néguev kjokyo, ba boy, ba shtop Lot, ba l̇l̇ëbo tjeng kës l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Eshko ga Abram dbur sho shõyl̈ṍr ara, dbur sho pjl̈ubl̈ún ara, öng ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","E irgo ga jek l̈öng shtor shtor, irbo jek jong äär Betel kjokyo shwo l̈ëkong. Dëna sök l̈ishko ga akkwo töna dl̈uw ëng kjing go kjókshko, Jehová poshrëkkl̈o. Kjok eshko, e buk Betel kjokyo, Hai kjokyo, e tjrëko. Öötong l̈öng eshko iröng obi ga syõshtono Jehová kong obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Eshko ga Abram shtop Lot, e öng ara, parkaga ara, ba kjokwa dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ba kjok l̈öng l̈ishko ga öng ara anmoyõ kjĩshko ga ba öng dl̈i pjitënge. E kjĩshko ga ber l̈öng eshko uunkong ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Dl̈i ara l̇l̇ëm kjĩshko ga Abram öng dagaga ëngkjwë l̈ok ara Lot ĩ tjok. Eshko dbaryo ga Canaán sopga, ferezeoga, e l̈öng eshko obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Eni ga pjl̈ara ga Abram tjl̈ẽ Lot kong ga «Shji epenga döe. E kjĩshko ga shji iirkë ëng tjok kar kar ga äe. Bi parkagaga ëngkjwë ëng tjok ga ä bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Rokër bop kong sira ga pja opkjos ber sök dboye. Kjok ëre ĩzong. Woydëp kjone dey ga kjrozong. Pja jek mil̈ëkong ga tja jek kël̈ë. Pja jek kël̈ëkong ga tja jek mil̈ë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kuya ga ĩya Jordán sdamyo kjok kjwang jĩkong. Ĩna ga Jordán diyo kjwo kar kar äär jong Zoar kjokyo go, e diyo bayo ara, so kjok shäryara Jehovárë Adán kong l̈i kjoyo, so Egipto kjokyo kjoyo bakoe. (Eshko ga Sodoma kjokyo, Gomorra kjokyo, e pjiyde Jehovárë l̇l̇ëm obi.) ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","13","Eni ga kjok kjrara Jordán sdamyo shwo l̈ëkong, ga to jek dl̈o wen tëm shwo l̈ëkong, öötong sök eshko, Sodoma kjokyo ber buk soshko. (Sodoma sopga, e wotjl̈ĩk owa erä. L̇l̇ëbo owa shäryara l̈ok ara Jehová bokso.) Abramda beno sök Canaán kjokyo. Abram, Lot, e opkjono l̈ok dboy dboy eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot to irgo ga Jehová tjl̈ẽ Abram kong ga «Kjok ĩs yõtso l̇l̇aw pogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Pja bokkwo dbo äär kjone l̈ishko ga kjok, e twër uunkong ber bop kong, bop tjëyo tek ber bop irgo l̈i kong, ber bomi kong ĩyado wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Bop tjëyo l̈i iër shdär l̈ok träk l̇l̇ëm, shtëy ga äär l̇l̇ëm, kl̈ung pjl̈ungyo wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","¡Eni ga pja jëkzong! Kjok ĩs kjwang jĩkong, e twër ber bop kong kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","E irgo ga poshäryono ga toe. Domer sök kjl̈ara ko Mamré. E kjor këskës l̈ok arae. Kjok eshko ga Hebrón kjokyo ber buk soshko. Abram wl̈o öötong l̈öng eshko ga akkwo töna Abramdë dl̈uw ëng kjing go kjókshko, Jehová poshrëkkl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Eshkoshko ga pjl̈upga dogl̈o pkëng (4), e ëngkjwono pjl̈upga dogl̈o shkëng (5) tjok. Pjl̈upga dogl̈o pkëng (4) l̈i, e Sinar so pjl̈uyo ko Amrafel, Elasar so pjl̈uyo ko Arioc, Elam so pjl̈uyo ko Quedorlaómer, Goyim so pjl̈uyo ko Tidal. Pjl̈upga dogl̈o shkëng (5) l̈i, e Sodoma so pjl̈uyo ko Bera, Gomorra so pjl̈uyo ko Birsá, Admá so pjl̈uyo ko Sinab, Zeboyín so pjl̈uyo ko Semeber, Bela so pjl̈uyo. (Bela kjokyo, e ko Zoar kjokyo bakoe.) ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","4","Eshko dbaryo ga pjl̈upga dogl̈o shkëng (5) l̈i ichaga Pjl̈u Quedorlaómer l̈irë sök l̈u sak kjwara kjingsho pjök (12) tjän. Gueniyo öötong l̈uyo sak kjwara kjingsho myashko (13) ga epga wotjl̈ĩno ëngkjwë ba tjok. Eni ga shkëng (5) jĩkong l̈i ëng töno l̈ok, ga ba ëngkjwagaga söra jek l̈ok Sidín sdamyo, Di Bäng Buk Kësbang Dl̈ek l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Öötong l̈u pjl̈ara obi ga Pjl̈u Quedorlaómer jongya jong eshko, pjl̈upga l̈öng ba shwo l̈ëkong l̈i tjok, ëngkjwë wl̈o. Jek l̈öng eshko wopro ga refaítaga zana l̈ok Astarot Carnayin kjokyo, zuzitaga zana l̈ok Jam kjokyo, emitaga zana l̈ok Save Quiriatayin kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Horeoga zana l̈ok Seir kjokyo dl̈up shwo l̈ëkong, irpjana l̈ok äär l̈öng Parán kjokyo. E ber buk kjok dogro no l̇l̇ëmshko l̈i worbo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tek iröng shrono l̈öng Enmispat kjokyo, e ko Cades kjokyo bakoe. Eshko ga Amalec tjëyoga zana l̈ok pjire. Amorreoga l̈öng Jazezón Tamar kjokyo l̈i zana l̈ok pjir bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Epga zana l̈ok pjir irgo ga jek öötong l̈öng Sidín sdamyo shara. Eshko ga pjl̈upga dogl̈o pkëng (4) l̈i ëngkjwono pjl̈upga dogl̈o shkëng (5) l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidín sdamyo l̈ishko ga pjl̈ëbgwo l̈ok träk l̇l̇ëm, roshko di shäng sho sĩ tjeng tjunge. Eni ga Sodoma so pjl̈uyo, Gomorra so pjl̈uyo, e tök l̈e l̈okshko ga l̈ono jer l̈ok pjl̈ëbgwo l̈i roshko. Eshko ga pjl̈upga zana l̈ok pjir dogl̈o mya obi l̈i, e töktong jem l̈ok dl̈up shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Sodoma kjokyo, Gomorra kjokyo ga dl̈i l̇l̇ë, l̇l̇ëbo tjeng kës tjwl̈õ tjok l̈i, e söra l̈ok pjl̈upga ba kjangyoga l̈irë drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram shtop Lot, e sök Sodoma kjokyo kuzong ga shara l̈ok, söra to ba l̇l̇ëbo tjeng kës l̈i tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Gueniyo ga no töktong kjl̈ara, ga Lot roy söra jek öötong Abram, hebreo l̈i kong. Eshkoshko ga Abram sök Mamré kjor këskës l̈ok l̈ishko. Mamré, e amorreo. E l̈ëmga tjeng do pjök, kjl̈ara ko Escol, kjl̈ara ko Aner. Pjl̈ara ga domerga dogl̈o mya l̈i tjl̈õkwo l̈ono ëng kong Abram tjok. Tjl̈ẽno ëng kong jl̈õkoyo ga «Oba ëngkjwë woydë bi tjok wl̈eni ga shji ëng wl̈ikë sharae» l̈ara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Eni ga roy kura Abramdë ga ba shtop söraba toe. Eshko ga Abram ëngkjwagaga tjeng dogl̈o sak dbäw pjl̈ogl̈o mya kjingsho sak kjwara kjingsho kjwong (318). Epga kuno jem l̈öng uunkong ba tjok. Eni ga söra jek pjl̈upga pkëng (4) l̈i irpjang, äär jong Dan tjëyoga kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","E shkëyo ga ba ëngkjwagaga l̈i shdöra beno tjeng dboy dboy, ga pjl̈upga l̈i kopjrina l̈ok pjribrie. Eshko ga popdara, irpjana l̈ok öötong l̈öng Hobá kjokyo, e Damasco kjokyo pjl̈or kal̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Eni ga l̇l̇ëbo kjrara, söra tjeng ba tjok l̈i döra Abramdë ba shjiryo drete. Ba shtop Lot, ba l̇l̇ëbo, ba wal̈ëga, ba nopga uunkong, e döra eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Quedorlaómer, pjl̈upga l̈öng ba shwo l̈ëkong l̈i, e zana pjir ga Abram bojono tek iröng obi. Öötong shäng Save sdamyo ga Sodoma so pjl̈uyo opshino jek ba wl̈okjrë irbo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Domer shäng kjl̈ara ko Melquisedec. E Salem so pjl̈uyo. E omwl̈okjrono bakoe. E syõshtaga Sbö Tjwl̈õ Kësbangyo kong ba pjeyoga kjĩshko. Eshko ga pjl̈ung shosho suk pjir shira, twara Abram kong, kjil̇l̇gwo bo dyo dbo ara tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ga tjl̈ẽno beno pjl̈ú ba kong. Tjl̈ẽ ga «Pja kjimte Sbö Tjwl̈õ Kësbangyorë ara. E kjok uunkong shäryaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Pja kjimtara, bop moskwoga iara beno tjeng bop wl̈oshko, ga zanop song erä. E kjĩshko ga e poshrëy kësbang ĩyado» l̈e. Eni ga l̇l̇ëbo wl̈ẽna Abramdë kës l̈i shtara äär ba sakyo (10) go, ba sakyo (10) go, shira kjrina kjrina, ga twara beno Melquisedec kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","E irgo ga Sodoma so pjl̈uyo tjl̈ẽ Abram kong ga «L̇l̇ëbo uunkong dörop kjwe ber tjeng bop kong ga pjl̈ú, gueniyo bor nopga kjwera twos bor kong iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kuya ga tjl̈ẽ ba kong ga «Tja tjl̈ẽno Jehová kong jl̈õkoyo. E Sbö Tjwl̈õ Kësbangyo. E kjok uunkong shäryaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","L̈oror ba kong jl̈õkoyo ga l̇l̇ëye bopoya kjrër l̇l̇ëm, trer kjwara l̇l̇ëm, drepkwota pjrikkl̈o pjl̈ara l̇l̇ëm bakoe. Eni ga l̇l̇ono ga tja l̇l̇ëbo ara wl̈eni ga twaga pjarë bor kong l̈ëp ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","L̇l̇ëye woydër ber bor kong l̇l̇ëm, dl̈i uara bor nopgarë l̈i döe. Gueniyo ga domerga bor yorkaga Aner, Escol, Mamré, kjwepga wl̈e kongda l̇l̇ëbo twos kjrina kjrinae» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","E irgo ga Jehová weno shäng Abram kong yoshko wl̈eni, ga tjl̈ẽ ba kong ga «Abram, l̇l̇ëye bangkjrëp l̇l̇ëme. Tja bop wl̈ikaga. L̇l̇ono ga pja iër ber tjwl̈õ ara. E kjĩshko ga l̇l̇ëye bangkjrëp l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Kuya ga tjl̈ẽ ba kong ga «Jehová, l̇l̇ëye shäryëp woydë l̈i shäryëp ga pjl̈úe. ¿Tja ber tjwl̈õ ara l̇l̇ëno? Miydëp pjl̈ú ga tja wapga drete. Tja kong wapga tworop l̇l̇ëme. E kjĩshko ga tja wol̈onoshko ga bor l̇l̇ëbo uunkong ber bor parkaga tjwl̈ẽk shäng pjir wl̈eniyo ko Eliezer kong. E bor pjeyo l̇l̇ëm, e Damasco so» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kuya ga tjl̈ẽ ba kong ga «Bop l̇l̇ëbo uunkong ber ba kong l̇l̇ëm, e ber bop wa domer onmo l̈i kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Eshko ga Abram söra jek kjoko, ga tjl̈ẽ ba kong obi ga «Kjok dogo ĩs yõtso. Dbala shtozong, shtëp ga pjl̈úre ĩp wl̈o. Bop tjëyo tek ber bop irgo l̈i ber träk l̇l̇ëm kjweni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Kuya ga tjl̈õkwo kjrara, ga mär beno shäng ba go. E kjĩshko ga iara Jehovárë beno pjl̈o bek ba bokso. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ga tjl̈ẽ ba kong ga «Jehová l̈i tja. Pja shiror tek Caldea so kjokyo ko Ur l̈i dwayo, kjok ëre twër ber bop kong wl̈o, kjok ëre twër ber bop tjëyo tek ber bop irgo l̈i kong wl̈o bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kuya ga tjl̈ẽ ba kong ga «Tjl̈apga Jehová, ¿kjok ëre ber bor kong jl̈õkoyo miydër sorë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","«Öng tek sös bor kong kop eni: sögl̈a popga wapga l̇l̇ëm obi wl̈eniyo kjl̈ara, shwl̈ing ushko so popga kjl̈ara, öng wl̈ẽp ushko so wl̈ënggl̈a kjl̈ara, mya jĩkong mikbo l̈u pjl̈ogl̈o mya döe. Dunggwo tek sös kjwo pjok obl̈ë obl̈ë bako, kjwara kësbang wl̈eniyo, kjwara chirawa wl̈eniyo» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kuya ga l̇l̇ëbo rokara l̈i söra uunkong Jehová kong. E irgo ga zröra, sho shora wok, ga iara tjeng ëng gomyo. Dunggwora shora l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ba öng sho shora, iara tjeng l̈ishko ga l̈ä̃ tjwe l̈ok träk l̇l̇ëm ba kjing go, gueniyo shgawe Abramdë shäng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kjok ro zar wl̈eni ga Abram sjeno, opbuno, ga pono rong anmoyõ. Buk pëshko ga ĩya yoshko go ga kjok ro beno yẽt, ga bangkjrara ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Eshko ga Jehová tjl̈ẽ ba kong ga «Pja äär tjl̈abl̈ashko, ga pja wol̈on döröshko ga pja sök wl̈ẽp ĩyado. Gueniyo ga l̈ër bop kong jl̈õkoyo ga bop tjëyo tek ber bop irgo l̈i äär l̈öng kjok shto obl̈ë. Eshko ga ber l̈öng parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo, ga bokrotkëba, ga opshik ga ä, äär jong l̈u pjl̈ogl̈o sak dbäw pjl̈ogl̈o pkëng (400). Gueniyo ba bokrotkagaga l̈i, e shdungga tjarë. Bop tjëyoga opshik ey dwayoshko ga l̇l̇ëbo tjeng kës l̈i söya l̈ok jek ba tjok pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Eeri ga amorreoga l̈öng kjok ëre kjing go, l̇l̇ëbo owa shärye l̈ok ara, gueniyo l̇l̇ëbo owa shärye l̈öng l̈i äätë ba dbo go l̇l̇ëm obi. E kjĩshko ga bop tjëyoga tjwe iröng mal̈ing l̇l̇ëme. L̈u äär pjl̈ogl̈o sak dbäw pjl̈ogl̈o pkëngshko (400) ga bop tjëyoga tjwe l̈öng kjok ëreshko iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kjok ro zoktongshko ga kjok ro beno yẽt erä. Eshko ga sbi weno pjang kjwara, roshko yõ sho tur jonge. Kjor weno pjang bok kjwara dbo go iök pjë jong ri rie. Pjöyĩkong jëk l̈ok ba öng sho shora tjeng l̈i tjrëko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Eshko ga Jehová tjl̈ẽ Abram kong ga «Tjl̈õkwo twër bop kong, ber ĩyado wl̈o. Kjok ëre twër bop tjëyo tek ber bop irgo l̈i kong, tek Egipto diyo dwayo äär jong Éufrates diyo kësbang l̈i go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Eeri ga kjok ëre, e quenitaga kjokyo, Cenaz tjëyoga kjokyo, cadmoneoga kjokyo, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het tjëyoga kjokyo, ferezeoga kjokyo, refaítaga kjokyo, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreoga kjokyo, Canaán so kjokyo, gergeseoga kjokyo, Jebús so kjokyo bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Abram sök Canaán kjokyo l̈u pjl̈ogl̈o sak kjwarashko (10) ga ba boy Saray wapga l̇l̇ëm obi. Gueniyo ga wal̈ë Egipto so shäng kjl̈ara ko Agar, e Saray parkaga tjwl̈ẽk shäng pjir wl̈eniyo. Pjl̈ara ga Saray tjl̈ẽ ba l̈anma kong ga «Tja kuzong. Jehová kjĩshko ga tja kjrong. E kjĩshko ga rokër bop kong ga pja pë Agar tjok. Ba kjĩshko ga tja wapga tjok kjwe» l̈e. Kuya ga «Jöl̈ö» l̈e ba kong. Eni ga Agar twara Abram kong, pë ba tjok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Eshko ga pono ba tjok, ga beno shäng kjl̈araso l̇l̇ëme. Eshko jek l̈ëkong ga ba pjl̈u Saray bangkjre ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Eni ga Saray tjl̈ẽ ba l̈anma kong ga «¡Bop kjĩshko ga tja bangkjre ame! Twak tjarë bop kong, bop boy wl̈o. Era wl̈oshko dörö kjĩshko ga wotjl̈ĩk ga e tjwl̈õ ara, bor kjinmo l̈e. Ëye diktong l̈i ë, pjare, de tja miydaga ber Jehovárë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kuya ga tjl̈ẽ ba kong ga «Tja kuzong. Bop parkaga l̈i shäng bop wl̈oshko. L̇l̇ëye shäryëp woydë ba tjok l̈i miydaga ber pjarë» l̈e. Eshko jek l̈ëkong ga Agar bokrotke Saraydë ara. E kjĩshko ga töktong to ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Jëk shäng kjok dogro no l̇l̇ëmshko ga öötong woshtë sök di bäng buk kjwara l̈i zl̈ong bäng, e buk irbo jek jong äär Sur kjokyo l̈i sor go. Eni ga wl̈ẽna Jehová parkaga kjok dogo so l̈irë sök eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ga tjl̈ẽ ba kong ga «Agar, ¿pja tek kjone dwayo? ¿Pja to kjone?» «Tja to shäng bor sogo Saray töywë» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kuya ga tjl̈ẽ ba kong ga «Pja nom jek bop pjl̈u Saray ushko iröng obi. L̇l̇ëye l̈e bop kong l̈i kol̈ozong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ga tjl̈ẽ ba kong obi ga «Bop tjëyo tek ber bop irgo l̈i iër ber shdär träk l̇l̇ëm, shtëy ga äär l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Pja shäng kjl̈araso l̇l̇ëme. L̇l̇ono ga pja wa buk kjl̈ara domer, e koiëp Ismael, pja woydë ara l̈i miyde Jehovárë pjir kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Bop wa, e ber shäng tjëkso l̇l̇ëm, sëgro äya kjl̈oshko so wl̈eni. E ber nopga uunkong moskwo. Ëye wotjl̈ĩk pjl̈ú ba kong l̇l̇ëme. E ber shäng ëngkjwë ba pjeyoga tjok ĩyado» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kuya ga wotjl̈ĩk ga «Tja ĩna Sbörë, ga tja sök së obi» l̈e. E kjĩshko ga Jehová, e tjl̈ẽno ba tjok l̈i kowara Sbö, Bor Ĩga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","E kjĩshko ga di bäng buk Cades kjokyo, Béred kjokyo, e tjrëko l̈i kowëba Sbö Sök Ĩyado, Bor Ĩga l̈i di bäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","E irgo ga wa buk kjl̈ara domer, ga koiara ba data Abramdë Ismael. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Eshko ga Abram l̈u pjl̈ogl̈o sak kjwong kjingsho tjer (86). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram l̈u pjl̈ogl̈o sak shkaw kjingsho shkawshko (99) ga Jehová weno shäng ba kong, ga tjl̈ẽ ba kong ga «Tja ëre Sbö, l̇l̇ëye shäryër woydë l̈i shäryër ga pjl̈úe. Tja kol̈ozong. Pja jëk pjl̈o bek bor bokso bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Tjl̈õkwo twër bop kong, ber ĩyado wl̈o, ga bop tjëyo tek ber bop irgo l̈i iër ber shdär träk l̇l̇ëme» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kuya ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go. Eshko ga Sbö tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Tjl̈õkwo twër bop kong, ber ĩyado wl̈o l̈i eni: Pja ber tjëyoga ara data. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ga eeri jek l̈ëkong ga pja ko ber Abram ame. Pja ko ber Abraham shara, pja ioror beno tjëyoga ara data kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Bop tjëyo tek ber bop irgo l̈i iër ber shdär träk l̇l̇ëme. E tjrëko pjl̈upga wen. Epga ber l̈öng tjëyoga obl̈ë obl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Tjl̈õkwo ëre twër bop kong, bop tjëyo tek ber bop irgo l̈i kong bakoe. Tja bop Sbö ĩyado, tja ber ba Sbö ĩyado bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Pja sökshko l̈i ko Canaán. Pja kjok ëre so l̇l̇ëm, gueniyo kjok buk kës ëre twër ber bop kong ĩyado wl̈o, epga kong bakoe. Ga tja ber ba Sbö ĩyado» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ga tjl̈ẽ Abraham kong obi ga «Tjl̈õkwo twër bop kong l̈i shäryos eni ĩyado. Bop tjëyo tek ber bop irgo l̈i omshäryë eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tjl̈õkwo twër bop kong, ber ĩyado wl̈o l̈i ber eni: Domerga l̈öng bomi tjok kjl̈obi l̈i ber l̈öng doyo jyã tak pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Eni ga bomi chimkwo dbo kwota zëmi tas, e ber tjl̈õkwo ëre kjroromi jl̈õkoyo l̈i jyãgl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Eeri jek l̈ëkong ga chidaga domerga wen tjeng bomi tjrëko kjl̈obi l̈i äär dbar kjwongshko (8) ga doyo jyã tëmi pjir eni, bomi wapga, bomi parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo l̈i wapga bakoe. Bomi parkagaga tjwl̈ẽnomi shto obl̈ë so kong l̈i doyo jyã tëmi pjir bakoe. Pjãy domerga doyo jyã të uunkong. Ba jyãgl̈o ëre ber pjang bomi sho go ĩyado, tjl̈õkwo tworor bomi kong l̈i dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ëye doyo jyã të l̇l̇ëm ga ber sök bomi tjok ga äe. Eni wl̈eni ga tjl̈õkwo tworor bomi kong l̈i shäryara l̇l̇ëm kjĩshko ga ichozĩ bomi shwoy dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Eshko ga tjl̈ẽ ba kong obi ga «Bop boy kjwe ko ber Saray ame. Eeri jek l̈ëkong ga ko ber Sara shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","L̇l̇ëbo shäryër ber pjl̈ú ba kong. Bop kong wa twër kjl̈ara domer ba tjok. Sara, e ber tjëyoga ara mekë. Ba tjëyo tek ber ba irgo l̈i tjrëko pjl̈upga wen» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kuya ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, ga jar jonge. Wotjl̈ĩk sök ga «¿Domer l̈uyo sak dbäw (100) ga data sorë? ¿E ga Sara l̈uyo sak shkaw (90) ga wa tjok sorë?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Eni ga tjl̈ẽ Sbö kong ga «Rokër bop kong ga tjl̈õkwo tworop bor kong l̈i twos Ismael kong dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kuya ga tjl̈ẽ ba kong ga «L̇l̇ëme. L̈oror bop kong ga bop boy Sara, e l̇l̇ono ga wa buk kjl̈ara domer. E koiëp Isaac. Tjl̈õkwo tworor bop kong, ber ĩyado wl̈o l̈i shäryër ber ba kong, ber ba tjëyo tek ber ba irgo l̈i kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Pja syõshtë sök Ismael kjĩshko l̈i kuror, ga kjimtër bakoe. Ba tjëyo tek ber ba irgo l̈i iër ber shdär träk l̇l̇ëme. Ga iër ber tjëyo kësbange. E tjrëko pjl̈upga wen dogl̈o sak kjwara kjingsho pjök (12). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Gueniyo ga l̈u pjl̈ara go ga pjãy wa buk kjl̈ara domer ko Isaac. Tjl̈õkwo tworor bop kong, ber ĩyado wl̈o l̈i, e ber ba kong eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Sbö tjl̈ẽno ba kong pjir ga opshino to ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","E dbaryo ga domerga l̈öng ba ushko l̈i doyo jyã tara Abrahamdë uunkong, ba wa Ismael, ba parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo weno tjeng ba ushko, ba parkagaga tjwl̈ẽna shto obl̈ë l̈i bakoe. Eshko ga Abraham l̈u pjl̈ogl̈o sak shkaw kjingsho shkaw (99), ba wa Ismael l̈u pjl̈ogl̈o sak kjwara kjingsho mya (13). Domerga l̈i doyo jyã tara uunkong, l̈ara Sbörë ba kong sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Dbar kjwara ga Abraham sök Mamré kjor këskës l̈ok l̈ishko, ba u zl̈ong bäng. Eni ga dl̈o dl̈uw wl̈eni ga Jehová weno shäng ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ĩya jekdo ga domerga bë l̈öng ba zl̈ong bäng dogl̈o mya. Sök l̈i kojono mal̈ing ba wl̈okjrë, ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ga tjl̈ẽ ba kong ga «Tjl̈apgaga, rokër bomi kong sira ga pjãy brik mal̈ing l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kumi ga pjl̈ú wl̈eni ga tja di rokë bomi kong, pjãy dre shkwë e go wl̈o. Pjir ga pjãy woshtë wop tjok kjor ëre dorko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Pjãy l̈öng töshko. Pjãy brikdë l̇l̇ëm obi ga pjãy sën, pjãy jëk ga dbo tjok wl̈o. Pjãy shrono bor ĩk kjĩshko ga tja wopjl̈úe. Bor u ëre bomipjõy bebi» l̈e. Kuya l̈ok ga «Pjl̈úe» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Eni ga Abraham opzrëno jek ba u roy, ga tjl̈ẽ Sara kong ga «Pjl̈ung sho kjros bayo eeje. Sho l̇l̇rus, ga suzong. ¡Shäryos mal̈inge!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","L̈ara eni ga opshino ey dwayo, ga jek öötong shäng ba sögl̈a tjeng l̈ishko, shara kjl̈ara pjl̈ú wl̈eniyo, twara ba parkaga kong, poshäryë jekdo wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Eni ga dl̈i l̈i poshäryara pjir ga söra, twara Abrahamdë ba kong l̈ok, ue l̈ok wl̈o. Öng nä dyo, öng nä dyo shor, e twara ba kong l̈ok bakoe. Ië l̈öng kjor dorko wopro ga e shäng ba dë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Iono l̈ok pjir ga tjl̈ẽ l̈ok ba kong ga «¿Bop boy Sara kwonl̇l̇o?» «Shäng kjweshko, kjër roy» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","13","Domerga dogl̈o mya l̈i, kjl̈ara, e Jehová. Tjl̈ẽ Abraham kong ga «L̈u pjl̈ara go ga pja ĩn tjwe obi. Eshko ga bop boy Sara wl̈oshko wa tjeng kjl̈ara domer tjän» l̈e. Kura Sararë kjër pjl̈or go, ba l̈anma kokso l̈ëkong. Eshko dbaryo ga Abraham tjl̈abl̈a, Sara bakoe. Ga Sara, ba dbar mokyo ĩya ame. E kjĩshko ga jar jong, ga wotjl̈ĩk ga «Tja tjl̈abl̈ae. Bor l̈anma tjl̈abl̈a bakoe. ¿Tja wa tjok sorë?» l̈e. Jar shäng l̈i kuya Jehovárë ga tjl̈ẽ Abraham kong ga «¿Sara jar ega? ¿Tjl̈abl̈a kjĩshko ga wa tjok ga äe l̈ere? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿L̇l̇ëbo kjang, shäryako l̇l̇ëm Jehová kong tjokde? L̈u pjl̈ara go ga pja ĩn tjwe obi. Eshko ga Sara wl̈oshko wa tjeng kjl̈ara domer tjän» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Kuya Sararë ga bangkjrara ara, ga tjl̈ẽ ga «Tja jatong l̇l̇ëme» l̈e. «Miydër pjir ga pja jatong» l̈e Jehovárë ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Iono l̈ok pjir ga irbo shano to Sodoma kjokyo, ga wl̈obyara Abrahamdë irbo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","18","Eshko ga Jehová wotjl̈ĩk ga «Abraham ber tjëyo kësbang, dbo ara data. Tja tjl̈ẽno ba kong jl̈õkoyo ga ba kjĩshko ga tjëyo l̈öng kjrina kjrina kjok kjwang jĩkong l̈i kjimtër. E kjĩshko ga l̇l̇ëye shäryër l̈i l̈ër ba kong dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","E kjroror nopga uunkong tjrëko, ba tjëyo tek ber ba irgo l̈i pĩya bor kol̈ë wl̈o, jëk l̈öng bëy wl̈o. Eni ga l̇l̇ëye l̈oror l̈i shäryër uunkong. Kjroror parkë shäng bor tjok e kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Eni ga Jehová tjl̈ẽ ba kong ga «Sodoma sopga, Gomorra sopga, e roy owa. Kur ga l̇l̇ëbo shärye l̈öng owa l̈i, e kësbang anmoyõ. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","E kjĩshko ga tja jongya eshko roy kuror owa l̈i jl̈õre ĩk wl̈o. Eni l̇l̇ëm wl̈eni ga miydër eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Eshko ga domerga do pjök ba pjl̈oga l̈i jer Sodoma kjokyo, gueniyo Jehová beno shäng Abraham tjok obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Wop tjok ga Abraham tjl̈ẽ ba kong ga «¿Nopga owa l̈i tjrëko nopga pjl̈o bek tjok wl̈eni ga pjip uunkongde? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","¿Kjok eshko nopga kjwe l̈öng pjl̈o bek sak shkëng (50) wl̈eni ga pjip jek enire? ¿Zröp nopga owa l̈öng l̈i tjokde? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nopga pjl̈o bek shdum nopga owa l̈i tjok ga äe. Nopga pjl̈o bek l̇l̇gwep nopga owa l̈i dik ga äe. Rokër bop kong sira ga shäryëp eni l̇l̇ëme. Pja nopga l̈öng kjok ëre kjing go l̈i l̇l̇gwega. Miydër ga pja kjok l̇l̇gwek beke» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kuya ga tjl̈ẽ ba kong ga «Sodoma sopga wl̈ẽnor pjl̈o bek l̈öng sak shkëng (50) wl̈eni ga epga kjĩshko ga shdun l̇l̇ëme» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eshko ga tjl̈ẽ ba kong obi ga «Tja jnep kësbang, pja bangkjrër l̇l̇ëm wl̈eni. Pja Sbö, tja domer. Tja domer song, tjwl̈õ l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kjwe shkëng (5) obi äär sak shkëng (50) wl̈o. ¿Shkëng (5) kjĩshko ga kjok pjip jek enire?» Kuya ga tjl̈ẽ ba kong ga «Wl̈ẽnor pjl̈o bek l̈öng sak pkëng kjingsho shkëng (45) wl̈eni ga shdun l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Eshko ga tjl̈ẽ obi ga «Wl̈ẽp tjeng sak pkëng (40) erö dikjoyoe» l̈e. Kuya ga tjl̈ẽ ba kong ga «Epga sak pkëng (40) l̈i kjĩshko ga shdun l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eshko ga tjl̈ẽ ga «Rokër jek bop kong obi ga pja iirkë bor kong l̇l̇ëm, rokër bop kong ara l̈i kjĩshko. ¿Wl̈ẽnop tjeng sak mya (30) erö wl̈eni ga l̇l̇ëye shäryëp?» Kuya ga tjl̈ẽ ba kong ga «Epga sak mya (30) l̈i kjĩshko ga shdun l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eshko ga tjl̈ẽ obi ga «Tjl̈apga, pja bangkjrër l̇l̇ëm wl̈eni. ¿Wl̈ẽnop pjl̈o bek l̈öng sak pjök (20) erö wl̈eni ga l̇l̇ëye shäryëp?» Kuya ga tjl̈ẽ ba kong ga «Epga sak pjök (20) l̈i kjĩshko ga shdun l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Eshko ga tjl̈ẽ pjl̈ara obi ga «Tjl̈apga, pja iirkë bor kong l̇l̇ëme. Kjakrokër bop kong pjir ëre döe. Pja barwër ame. ¿Wl̈ẽnop tjeng sak kjwara (10) wl̈eni ga l̇l̇ëye shäryëp?» Kuya ga tjl̈ẽ ba kong ga «Epga sak kjwara (10) l̈i kjĩshko ga shdun l̇l̇ëme» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Jehová tjl̈ẽno ba kong pjir ga to ey dwayo, ga Abraham jek ba ushko iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kjok ro zar jekshko ga Sbö parkagaga kjok dogo so do pjök l̈i jek öötong l̈öng Sodoma kjokyo. Ga opzrëno jek kjok l̈i roshkoshko ga Lot sök eshko. Ĩya sök ga kojono ba wl̈okjrë, ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ga tjl̈ẽ ba kong ga «Tjl̈apgaga, rokër bomi kong sira ga pjãy ber l̈öng bor ushko shkër kjwara. Bor u, e bomipjõy bebi. Eshko ga pjãy dre shkwë ga pjl̈úe. Pjãy brik bong, kjok shröngto jã» l̈e. Kuya l̈ok ga tjl̈ẽ ba kong ga «L̇l̇ëme. Tjawa ber l̈öng kjoko dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Gueniyo «Shji to ushko» l̈e ba kong kjër kjĩshko ga to jek l̈ok ba tjok ushko. Öötong l̈öng eshko ga sëna dl̈i owa l̇l̇ëm, pjl̈ung shosho suk pjir shäryak ba uukkl̈o tjok l̇l̇ëm bako, ga uara l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","L̈öng poydë l̇l̇ëm obishko ga domerga Sodoma so öötong l̈öng eshko uunkong, këskës chila, ga Lot u kopjrina l̈ok pjribrie. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Eshko ga öö l̈e l̈ok Lot kong, tjl̈ẽ ga «¿Domerga tjwe l̈öng l̈una bop ushko yẽ kwonl̇l̇o? ¡Shis borwa kong kjoko! ¡Tjawa pë woydë ba tjok!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kuya Lotdë ga opshino jek kjoko, l̈an ba tjok wl̈o, ga u bäng bängzara tuk, ba kokso l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Eshko ga tjl̈ẽ ba kong l̈ok ga «L̈ër bomi kong ga l̇l̇ëbo owa shäryëmi eni l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tja wapga wal̈ëga tjeng do pjök, domerga miydoydë l̇l̇ëm obi. Epga twotë bomi kong dey. L̇l̇ëye shäryëmi woydë ba tjok l̈i miydaga ber pjãydë. Gueniyo rokër bomi kong sira ga domerga l̈ëmi l̈i maga tjarë kjĩshko ga kong l̇l̇ëye owa shäryëmi l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kuya l̈ok ga tjl̈ẽ ba kong ga «¡Pja opkjos ëre dwayo! Pja na so l̇l̇ëme. Tjawa ichëp woydë kuzong ga pja kong l̇l̇ëbo owa shäryërwa, l̇l̇ëbo owa shäryërwa ba kong l̈ok l̈i kjinmo» l̈e l̈ok ba kong eni, ga jek ri ri ba kjing go, u bäng l̈i dl̈oya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Gueniyo ga Lot wl̈ikara domerga l̈öng ba u roshko l̈irë, shira jek u roy, ga u bäng bängzara tuke. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Eshko ga domerga l̈öng kjoko l̈i iara l̈ok uunkong beno l̈öng kjok ĩgö l̇l̇ëme. Eni ga u bäng wl̈ẽya l̈ok ga drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Eshko ga domerga do pjök l̈i tjl̈ẽ Lot kong ga «Sodoma sopga ëre l̇l̇ëbo shäryë l̈öng owa anmoyõ, ga roy öötong Jehová sök kjok dogo l̈i kong. E kjĩshko ga tjawa ichara kjok ëre pjik. Pja opshis na dwayo, pja nom pjolae. Pja pjeyo obl̈ë na tjok ga jek sös bop tjok uunkong, bop wapga, bop kwosga, bop pjeyo obl̈ë tjeng kjok ëreshko bako, kjok ëre pjirwa kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Eni ga Lot opshino jek ba kwosga ĩni rokë, tjl̈ẽ ba kong ga «Kjok ëre pjiya Jehovárë. E kjĩshko ga pjãy wl̈ẽp l̇l̇ëme. Pjãy tökzong pjolae» l̈e. Gueniyo tjl̈õkwo kjrara l̈ok l̇l̇ëme. Wotjl̈ĩk l̈ok ga «Shäng tjötoro» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Wẽshko kjok shröngto ga Sbö parkagaga kjok dogo so l̈i tjl̈ẽ Lot kong ga «Pja kojõs mal̈ing, bop boy, bop wapga wal̈ëga do pjök, e jek sös bop tjok. L̇l̇ëm ga kjok ëre shdunwashko ga pjãy wol̈on jek kjok ëre sopga tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Gueniyo ga Lot wor kuzong ga shara l̈ok ba orkwo go, songe l̈e Jehovárë kjĩshko. Shäryara eni ba boy, ba wapga tjok bakoe. Eshko ga shira l̈ok kjok eshko dwayo, wol̈on l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Shira l̈ok pjir ga kjl̈ara tjl̈ẽ ba kong ga «Pjãy zronzong. Iröng ĩmi l̇l̇ëme. Pjãy sl̈an kjok ëreshko l̇l̇ëm bakoe. Pjãy tökzong dl̈up l̈ëkong, pjãy wol̈on woydë l̇l̇ëmda eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kuya Lotdë ga tjl̈ẽ ba kong ga «L̇l̇ëme. Tjl̈apgaga, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","tja kjimtoromi ara. Pjãy pjl̈ú bor tjok. Tja shiromi kjĩshko ga tja sök së obi. Gueniyo ga tja tök dl̈up go ga äe. Kjok pjimishko ga tja doshaya irbo, ga tja wol̈on. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ëreshko kjok buk chira kjrina soye. Tja jek äär eshko ga pjl̈úe. Tja ichozĩ jek eshko, tja ber sök së obi wl̈o. ¿Ĩmi ga chirawa jl̈õ l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kuya l̈ok ga kjl̈ara tjl̈ẽ ba kong ga «Pja kuror. L̇l̇ëye rokorop bor kong l̈i shäryër eni. Kjok buk l̈ëp l̈i pjir l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pja jëkzong mal̈ing kjweshko. Pja äätë kjweshko l̇l̇ëm obishko ga l̇l̇ëye shäryër ga äe» l̈e. Kjok buk eshko chira l̈i, e kowaraba beno Zoar e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot äär shäng eshko ga kjok shröng tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Eshko ga akkwo ko azufre l̈ono ter iök, shrono shunyo wl̈eni, ichara Jehovárë ter kjok dogo dwayo l̈on Sodoma kjokyo, Gomorra kjokyo, e kjing go wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Eni ga kjok eshko pjitong dret, nopga l̈öng eshko kjl̈obi l̈i wol̈ono dret, l̇l̇ëbo tjeng së eshko kës l̈i pjitong beno dret bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lot boyda tek shäng ba irgo, ga iröng ĩya yal̈erbo ga posgono beno shäng dl̈ungna akyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wẽshko kjok shröngto ga Abraham jek öötong shäng l̈ano Jehová tjok bäm go l̈ishko, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ga ĩya ga sdam kjwang jĩkong pjë jong träk l̇l̇ëm obi äär jong Sodoma kjokyo, Gomorra kjokyo bebi. Beno yõbor erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lot sökshko sdamyo pjira Sbörë eni. Gueniyo Abraham woyoshrara kuzong ga Lot shira kjok pjira l̈ishko dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","E irgo ga Zoar sopga bangkjrara Lotdë ara kjĩshko ga opshino jek shäng dl̈up shwo l̈ëkong, ba wapga wal̈ëga do pjök l̈i tjok, ga beno l̈öng guëng jong ööng kjwara eshko l̈i roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Pjl̈ara ga ba wa këguëyo tjl̈ẽ ba l̈ëng kong ga «Bi data kjwe tjl̈abl̈ae. Kjok kjwang jĩkong ga oba orkwosmok ĩyado. Gueniyo jũshko ga domerga shji orkwosmok ba tjok wl̈o drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kjweri nel̈õtkëy, shji pë ba tjok wl̈o, shji wapga shdär jek këgong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","E shkëyo ga kjil̇l̇gwo bo dyo dbo ara twara ba data kong. Nel̈õtkono ga Lot wa bäm ĩyo pono ba tjok. Gueniyo nel̈õ kjĩshko ga to miydara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wẽshko ga Lot wa këguëyo tjl̈ẽ ba l̈ëng kong ga «Tja kuzong. L̈una shkëyo ga tja pono bi data tjok. Eeri shkëyo ga nel̈õtkëy jek obi, pja pë ba tjok shara wl̈o, shji wapga shdär jek këgong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","E shkëyo ga nel̈õtkara l̈ok jek obi, ga Lot wa mite pono ba tjok shara. Gueniyo to miydara l̇l̇ëm obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Eni ga Lot wapga l̈i beno l̈öng kjl̈araso l̇l̇ëm, ba data l̈i ĩ. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","E irgo ga ba wa këguëyo wa buk kjl̈ara domer, ga koiara Moab. E beno Moab tjëyo data. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ga ba l̈ëng wa buk kjl̈ara domer bebi, ga koiara Ben Amí. E beno Amón tjëyo data. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","E irgo ga Abraham wl̈o opshino Mamré kjokyo dwayo, to jongya jong Néguev kjokyo. Eshko ga beno l̈öng Guerar kjokyo, e buk Cades kjokyo, Sur kjokyo, e tjrëko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Äär l̈öng eshkoshko ga ba boy Sara, e ba dor l̈e uunkong kong. E kjĩshko ga Guerar so pjl̈uyo Abimélec no ichono Sara wl̈okjrë, pë ba tjok wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Eshko ga Sbö tjl̈ẽ Abimélec kong yoshko ga «Wal̈ë sörop kjwe orkwosmok shäng pjire. E kjĩshko ga pja wol̈on» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Eshko ga poydë ba tjok l̇l̇ëm obi kjĩshko ga tjl̈ẽ Sbö kong ga «Tjl̈apga, ¿ëye l̇l̇ëbo owa shäryoydë l̇l̇ëm ga pja wotjl̈ĩk ba zrökde? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham tjl̈ẽno bor kong ga “Wal̈ë kjwe bor dor” l̈ara. “Kjwe bor sing jl̈õe” l̈ara wal̈ë l̈irë bakoe. Eni ga tja opshäryë shäng pjl̈ú bop bokso l̈ër eni bor pjl̈úshko, l̇l̇ëye owa shäryotë l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kuya ga tjl̈ẽ ba kong ga «Miydër pjl̈ú ga pja opshäryë shäng pjl̈ú bor bokso l̈ëp eni bop pjl̈úshko jl̈õe. E kjĩshko ga pja ichoror ba porwë l̇l̇ëm, l̇l̇ëbo owa l̈ër l̈i shäryëp l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Wal̈ë kjwe to twëp ba l̈anma kong iröng obi. Domer, e bor tjl̈õkwo l̈aga. E kjĩshko ga syõshtë bor kong bop kjĩshko, pja wol̈on l̇l̇ëm wl̈o. Gueniyo twëp ba kong iröng l̇l̇ëm ga l̈ër bop kong jl̈õkoyo ga pja wol̈on, bop pjeyoga uunkong wol̈on bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Wẽshko kjok shröngto ga ba dboryagaga rokara ba shwoy, ga yoĩno sorë ga l̈ara ba kong pjire. Kuya l̈ok ga bangkjrara ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","E irgo ga Abraham rokara Abimélecdë ba shwoy, ga tjl̈ẽ ba kong ga «¿L̇l̇ëye shäryorop borwa kongdo? Tja jëktong bëy bop tjok. Gueniyo tja ichorop l̇l̇ëbo owa shäryë, bor nopga ichorop l̇l̇ëbo owa shäryë bakoe. E shäryako l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿“Kjwe bor dor” l̈ëp bor kongshko ga pja wotjl̈ĩk shäng l̇l̇ëro?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","«Tja wotjl̈ĩno ga kjok ëre sopga Sbö bangkjrë l̇l̇ëmdo l̈oror, ga tja zröya l̈ok bor boy kjwe kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Jl̈õkoyo ga kjwe bor dor, bor data wa, gueniyo bor mekë wa l̇l̇ëme. Tja orkwosmono ba tjok ga pjl̈ú e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","“Pja opshis bop data ushko dwayo” l̈ara Sbörë bor kongshko ga tja tjl̈ẽ bor boy kong ga “Tja kjimtëp sira. Shji äär kjone pogo ga tja bop sing l̈ëp eni” l̈ër ba kong» l̈e Abrahamdë eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Eshko ga ba boy Sara twara Abimélecdë ba kong iröng obi. Öng ushko so, sögl̈a, domerga parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo, wal̈ëga parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo, e twara ba kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ga tjl̈ẽ ba kong ga «Kjok ëre ĩzong. Woydëp ara kjone dey ga kjros, pja ber sök eshko wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ga tjl̈ẽ Sara kong ga «L̇l̇ëbo tworor bop sing kong kjwe tjwl̈õ dbur sho pjl̈ubl̈ún kjwo sak dbäw dbäw (1,000). Tworor ba kong, pja l̇l̇ëbo owa shäryono l̇l̇ëm miydëba e go wl̈o, pja ber pjl̈ú nopga uunkong ëre bokso wl̈o, pja owa l̈aga ërë l̇l̇ëm wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Sara kjĩshko ga wal̈ëga l̈öng Abimélec ushko kjl̈obi l̈i shduna Jehovárë, beno l̈öng wapga ame. Gueniyo ga Abraham syõshtono Jehová kong. E kjĩshko ga Abimélec poptara Sbörë. Ba boy, ba parkaga wal̈ëga poptara bako, wapga tjok obi wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","E irgo ga l̇l̇ëbo shäryara Jehovárë pjl̈ú Sara kong, l̈ara sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abraham tjl̈abl̈ashko ga Sara beno shäng kjl̈araso l̇l̇ëme. L̈ara Sbörë dbaryo l̈ishko ga wa buk kjl̈ara domer, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","5","ga koiara ba datarë Isaac. Eshko ga Abraham l̈u pjl̈ogl̈o sak dbäw (100). Öötong dbar kjwongshko (8) ga chida doyo jyã tara, l̈ara Sbörë ba kong sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Eshko ga Sara wotjl̈ĩk ga «Tja iara Sbörë jar. Ga tja wa tjok miydaraba ga oba jar wopjl̈ú bor tjok bebi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Tja wa tjeng Abraham tjok kjl̈ara l̈aga ëro? ¡Tjl̈abl̈a ëmdë ga ĩzong! Ba tjok ga tja wa buk kjl̈ara domer» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","E irgo ga Isaac kunoe. Nä döra dbaryoshko ga dl̈i shäryara ba datarë kësbang, ba poshrëkkl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ismael, e Egipto so Agar l̈i wa Abraham tjok. Pjl̈ara ga shäng tjör Isaac tjok. Ĩya Sararë ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","tjl̈ẽ ba l̈anma kong ga «Bi parkaga tjwl̈ẽk shäng pjir wl̈eniyo l̈i ichos jek na dwayo, ba wa kjwe tjok. Pja wol̈onoshko ga bop l̇l̇ëbo tjeng kës ber Isaac kong eröe. L̇l̇ëye ber bi parkaga wa kjwe kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kuya ga bangyo ba kong ara, e ba wa bebi kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Gueniyo ga Sbö tjl̈ẽ ba kong ga «Pja woydë kjwozir l̈i kjĩshko l̇l̇ëm, bop parkaga kjĩshko l̇l̇ëm bakoe. L̇l̇ëye roke Sararë bop kong l̈i shäryos eni. Isaac tjëyo tek ber ba irgo l̈i ber bop tjëyo jl̈õkoyo eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Bop parkaga wa l̈i, e bop wa kjĩshko ga e iër ber tjëyo obl̈ë, kësbang bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wẽshko kjok shröngto ga dl̈i, di, e iara Abrahamdë ba bapkwo roshko, twara Agar kong, ga iara pjang ba kokso. Eshko ga «Pja nome» l̈e ba kong, ga ichara to ey dwayo, ba wa l̈i tjok. Kuya ga to jek kjok dogro no l̇l̇ëmshko kjokyo ko Berseba. Eshko ga jëktong l̇l̇aw pogo, to jongya shäng kjone miyde l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ba diwa söra l̈i pjitongshko ga ba wa l̈i iara beno sök tjoksa, kjor chirawa jong eshko l̈i dorko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ga wotjl̈ĩk ga «Bor wa kjwe wol̈on ĩn woydë l̇l̇ëme» l̈e. E kjĩshko ga opkwono, sirkeno sök pjola, ga beno sök tjoksa, ga sl̈ar träk l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Eshko ga ba wa sl̈ar jong bebi. Kuya Sbörë ga Agar rokara Sbö parkaga kjok dogo sorë tjl̈ẽ ter kjok dogo dwayo ga «Agar, ¿pja oto? L̇l̇ëye bangkjrëp l̇l̇ëme. Bop wa kjl̈oshtono l̈i kura Sbörë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","To kjrëba jeke. Rayëp ber tjoksa ame. Ba tjëyo tek ber ba irgo l̈i iër ber tjëyo kësbange» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Di bäng shäryak jong kjwara eshko. E pina Sbörë ba kong. Eni ga jek öötong shäng eshko, ga ba di bapkwo l̈i dl̈ina, ga twara ba wa kong, ie wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ismael kunoshko ga beno shäng kjok dogro no l̇l̇ëmshko kjokyo ko Parán. Eshkoshko ga kjimtara Sbörë. Öötong këguë ga swl̈ë dbuk owa l̇l̇ëme. Ga orkwosmona ba mekërë wal̈ë Egipto so tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Eshkoshko ga Guerar so pjl̈uyo Abimélec öör l̈an Abraham tjok. Ba ëngkjwaga kägäyo ko Ficol, e söra öör ba yorkë. Öötong l̈öng eshko ga Abimélec tjl̈ẽ Abraham kong ga «Ĩn ga l̇l̇ë pogo shäryëp ga pja kjimte Sbörë ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Woydër ga eeri dbaryo ga l̈os bor kong jl̈õkoyo Sbö bokso ga l̇l̇ëye owa shäryëp bor kong l̇l̇ëm, bor tjëyo tek ber bor irgo l̈i kong l̇l̇ëm bakoe. Pja na so l̇l̇ëm, gueniyo pja sök jũshkoshko ga tja wotjl̈ĩno bëy bop kong. E kjĩshko ga woydër ga shäryëp bor kong eni bako, bor pjeyoga kong eni bakoe. ¿Kuropde?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","«Jöl̈ö. L̈ër bop kong jl̈õkoyo ga shäryër bop kong eni» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Gueniyo ga tjl̈ẽ ba kong obi ga «Di bäng shäryak jong kjwara botoya. Gueniyo kjrara bop parkagagarë kjĩshko ga diyo shirwa ga äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kuya ga tjl̈ẽ ba kong ga «E miydër eeri jã l̈iro. Shäryaga ërë miydër l̇l̇ëme. L̇l̇ëye l̈opdë bor kong l̇l̇ëme. ¿Eni ga miydër sorë?» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Eni ga öng ushko so, sögl̈a, e twara kjl̈öbö Abimélec kong. E dbaryo ga tjl̈ẽno ëng kong jl̈õkoyo beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","E irgo ga öng wl̈ẽp ushko so popga kjara tjeng dboshko dogl̈o kjäk (7). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ĩya Abimélecdë ga tjl̈ẽ ba kong ga «¿Öng kjorop tjeng kjwe l̇l̇ëno wl̈o?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","«Woydër ga öng ëre kjrëp, ber bop kong wl̈o. Miydëp e go ga di bäng shäryak jong ëre botoya» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tjl̈ẽno ëng kong jl̈õkoyo kjĩshko ga kjok eshko kowara beno Berseba. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tjl̈ẽno eni pjirshko ga Abimélec sano to jek iröng obi filisteo kjokyo, Ficol tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahamda syõshtono Jehová kong eshko Berseba kjokyo. Jehová, e ko Sbö Sök Ĩyado bakoe. Eshko ga Abraham kjor dgono kjl̈ara ko tamarisco, syõshtono eshko kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ga beno sök filisteo kjokyo l̈u kop ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Öötong l̈u kop ara ga Abraham tjl̈ĩya woydë Sbörë, kol̈e jl̈õkoyore miyde wl̈o. Eni ga rokara, tjl̈ẽ ba kong ga «¡Abraham!» «¿L̇l̇ë?, Tjl̈apga» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tjl̈ẽ ga «Isaac, e bop wa kjl̈araso. E woydëp ara. Sös Moria kjokyo. Pja äär eshko ga zröp, ga sho sup, pjë dret bor poshrëkkl̈o, dl̈up jong kjone pin bop kong l̈i goshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Wẽshko kjok shröngto ga kojono, öng so kwomgl̈a kjoyo dre töshko poshäryara, wl̈argl̈o iara ba kjing go. E irgo ga l̈öng zara, ber Sbö poshrëkkl̈o l̈i sho suya wl̈o. Pjir ga söra to ba wa tjok, ba parkagaga do pjök tjok bakoe. Eni ga jek kjok kjone l̈ara Sbörë ba kong l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Jëktong l̈ok dbargwo mya ga ĩya pjola dwayo ga kjok l̈ara l̈i ber buk wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Eshko ga tjl̈ẽ ba parkagaga kong ga «Pjãy ber l̈öng na borwa koshë, bor öng tjok. Tja jek këgong kjwozir ëre tjok. Sbö poshrërorwa pjir ga tjawa tjwe iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eshko ga ba l̈öng l̈i iara ba wa dbopdo. Sögl̈o, iök, e shara, söra jek ba tjok bakoe. Jek l̈öng irbo bäng goshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac tjl̈ẽ ba kong ga «¡Data!» «¿L̇l̇ë?» l̈e ba kong. Tjl̈ẽ ga «¿Shji l̈öng tjok, iök tjok, gueniyo öng ushko so l̇l̇gwokl̈ë wl̈eniyo suy wl̈o l̈i sök kjone?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","«Twe Sbörë bi kong dani» l̈e ba kong. Eshko ga jëktong l̈ok jek këgong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Öötong l̈ok kjokyo kjone l̈ara Sbörë l̈ishko ga Abraham akkwo töno dl̈uw ëng kjing go kjókshko, ga l̈öng iara ba kjing go. Pjir ga ba wa orkwo pjrira, dre pjrira, ga poyona buk l̈öng l̈i kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Eshko ga sögl̈o kjrara ba wa zröya wl̈o l̈eshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Jehová parkaga kjok dogo so l̈i tjl̈ẽ ter kjok dogo dwayo ga «¡Abraham! ¡Abraham!» «¿L̇l̇ë?, Tjl̈apga» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tjl̈ẽ ga «Bop wa kjwe wẽyẽ. L̇l̇ëye owa shäryëp ba kong l̇l̇ëme. Miydër ga Sbö bangkjrëp jl̈õkoyo, bop wa kjl̈araso kjwe kiyokorop bor kong l̇l̇ëm kjĩshko» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ĩya iröng ga öng wl̈ẽp ushko so wl̈ënggl̈a l̇l̇gwĩna sök kjl̈ara ba sjö go, kjor kowo tjrëko. Eni ga shara, zröra, sho sura, pjono dret Jehová poshrëkkl̈o, ba wa l̈i ãska. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","E irgo ga kjok eshko kowara beno «L̇l̇ëbo uunkong, e twaga Jehovárë.» E kjĩshko ga eerishko ga oba tjl̈ẽ ga «Jehová dl̈upyo go ga shji l̇l̇ëye l̇l̇ëm ga twe Jehovárë bi kong» l̈ëba eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Eshko ga Jehová parkaga l̈i tjl̈ẽno ba kong ter kjok dogo dwayo jek obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Tjl̈ẽ ga «Jehová tjl̈ẽ ga “Bop wa kjl̈araso kiyokorop bor kong l̇l̇ëm kjĩshko ga l̈ër bop kong om go jl̈õkoyo ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","pja kjimtër ara. Bop tjëyo tek ber bop irgo l̈i iër ber shdär träk l̇l̇ëm, dbala l̈ok kjopkwo go wl̈eni, l̈a sho tjeng dl̈ung kjako wl̈eni bakoe. Epga ber l̈öng kjok kjone pogo ga ba moskwoga zãya song ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tja kol̈orop kjĩshko ga tjëyo l̈öng kjrina kjrina kjok kjwang jĩkong l̈i kjimtër bop tjëyo l̈i kjĩshko” l̈e Jehovárë bop kong» l̈e Jehová parkagarë ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kura pjir ga to tek iröng obi ba wa tjok, ba parkagaga beno l̈öng l̈ishko. E irgo ga opshino to iröng Berseba kjokyo ba tjok. Ga beno sök eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Öötong dbar kop ara ga roy shrono Abraham kong ga ba kjl̈ara Najor wapga tjeng ara. Wapga tjeng domerga dogl̈o kjwong (8) ba boy Milca tjok. Ba wa domer bäm ĩyo ko Uz, e irgo Buz, e irgo Quemuel. (Quemuel, e Aram data.) E irgo ga wapga tjeng domerga ko Quésed, Jazó, Pildás, Yidlaf, Betuel. (Betuel, e Rebeca data.) ");
INSERT INTO tfrNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Najor boy obl̈ë ba parkaga wl̈eniyo tjok kjl̈ara ko Reumá. Wapga tjeng domerga obi ba tjok ko Tébaj, Gaján, Tajás, Macá. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Kjok buk kjrina ko Quiriat Arbá. Eeri ga e ko Hebrón, e Canaán kjokyo obi. Eshko ga Sara l̈u ĩno öötong sak dbäw kjingsho sak pjök kjingsho kjäkshko (127) ga wol̈onoe. E kjĩshko ga Abraham sl̈atong, ba boy l̈i soyopora. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Pjir ga opshino eshko dwayo, ga öör jek shäng l̈an Het tjëyoga tjok. Epga kjok eshko sopga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Eshko ga tjl̈ẽ ba kong l̈ok ga «Tja na so l̇l̇ëme. Gueniyo rokër bomi kong sira ga tja kong kjok soynezĩ kjrina, bor boy jner ber buk eshko wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kuya l̈ok ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Tjl̈apga, tjawa kuzong. Pja borwa kong ga tjwl̈õ ara, pjl̈u wa dik. Bop boy jnes borwa sak pjl̈ú, owa l̇l̇ëm wl̈eniyoshko. Kjakrokëp ë pogo kong wl̈eni ga “¡Jöl̈ö!” l̈e bop kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kuya ga kojono shäng, ga kä kjujono Het tjëyoga kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","Ga tjl̈ẽ ba kong l̈ok ga «L̈ëmi jl̈õkoyo ga bor boy jner ber buk sak jũshko ga pjl̈ú wl̈eni ga tja kjimtëmi eni. Zojar wa Efrón kjok worbo go ga guëng jong ööng kjwara, Macpela kjokyo buk l̈ishko. Woydër ga kjakrokëmi ba kong ga soyneya bor kong. Tjwl̈õ ie kjöm ga tjwl̈ẽn ba kong eni. Eni ga kjok tjwl̈ẽnor l̈i ber buk bor kong kjok ëre kjing go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efrón sök ba pjeyoga tjrëko kuzong ga Abraham dboryara, kuya nopga l̈öng eshko kës l̈irë pjl̈ú wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Tjl̈ẽ ba kong ga «¡L̇l̇ëme, Tjl̈apga! Guëng jong ööng l̈ëp l̈i twër ber bop kong bop sënggl̈o, kjok buk eshko l̈i tjok bakoe. Bor pjeyoga kjok ëre so ber l̈öng ba miydaga. Eni ga tworor bop kong bop sënggl̈o kjĩshko ga bop boy to jnep eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kuya ga kä kjujono jek obi kjok eshko sopga l̈öng l̈i kong, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ga Efrón dboryara ba bokshto, tjl̈ẽ ga «Tja kuzong. Rokër bop kong sira ga dbur kjros, kjok l̈i ãska. E irgo ga bor boy jner ber buk eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Kuya Efróndë ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Tja kuzong, Tjl̈apga. Kjok tjwl̈õ dbur sho pjl̈ubl̈ún kjwo sak dbäw pjl̈ogl̈o pkëng (400), dbur bayo eni. Gueniyo bi kong ga ëre l̇l̇ëye drete. E kjĩshko ga bop boy to jnep eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","19","Kuya ga tjl̈ẽ ba kong ga «Jöl̈ö» l̈e. Eni ga Het tjëyoga bokshto ga kjok l̈i tjwl̈ẽna Abrahamdë, dburyo shte l̈öng pjl̈uk jonge. Efrón kjok, e Macpela kjokyo obi, e ber buk Mamré kjokyo, dl̈o wen tëm shwo l̈ëkong. Eerishko ga Mamré kjokyo ko Hebrón, e Canaán kjokyo obi. Efrón kjok l̈i tjwl̈ẽna Abrahamdë, guëng jong ööng l̈i tjok, kjor l̈ok eshko tjok bakoe. E irgo ga ba boy Sara jnena beno buk eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Eni ga guëng jong ööng soynena Het tjëyogarë Abraham kong l̈i beno ba shinmoga jnezl̈ong shtoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham öötong tjl̈abl̈a, ga kjimtara Jehovárë l̇l̇ë pogo go ĩyado. E kjĩshko ga l̇l̇ëye shäryara kës l̈i beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Pjl̈ara ga ba parkaga shäng këguë wl̈eniyo rokara. E parkë shäng ba l̇l̇ëbo tjeng kës l̈i daga. Tjl̈ẽ ba kong ga «Woydër ga tjl̈õkwo l̈os bor kong jl̈õkoyo. Pja kä dos, orkwo ios bor kworbo kjing go, e ber ba jyãgl̈o wl̈o. Jehová, e Sbö sök kjok dogo, kjok uunkong shäryaga l̈i e. L̈os bor kong jl̈õkoyo ba ko go ga bor wa Isaac, e ichëp orkwosmok wal̈ë Canaán so tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Pja jongya bor kjokshko, bor pjeyoga l̈öng l̈ishko. Eshko ga kong boy wl̈ẽp kjl̈ara, bor pjeyoga wapga tjrëko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kuya ga tjl̈ẽ ba kong ga «¿Gueniyo kjogl̈o wl̈ẽnor l̈i tek woydë bor tjok l̇l̇ëm wl̈eni ga l̇l̇ëye shäryër? ¿Enira bop wa l̈i sör jongya bop kjok, pja to tek dënashko dwayo l̈ishkore?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","«¡L̇l̇ëme! Bor wa, e söp eshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehová, e Sbö sök kjok dogo. Tja shira bor data uy dwayo, bor pjeyoga kjokshko dwayo bakoe. Ga tjl̈ẽno bor kong jl̈õkoyo ga kjok ëre twe ber bor kong, bor tjëyo tek ber bor irgo l̈i kong bakoe. Ba parkaga kjok dogo so iche jek bop bäm go kjl̈ara, pja kjimte kjogl̈o wl̈ẽk kjl̈ara, tek söp bor wa kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Gueniyo kjogl̈o l̈i tek woydë bop tjok l̇l̇ëm wl̈eni ga pja döktong tjl̈õkwo l̈ëp shäng l̈i go. ¡Gueniyo ga bor wa jek söp eshko l̇l̇ëme!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Eni ga ba parkaga orkwo iono Abraham kworbo kjing go, ga l̇l̇ëye rokara l̈i l̈ara ba kong jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","E irgo ga l̇l̇ëbo wol̈ësowa anmoyõ wl̈eniyo kjrara ba kägäyo l̈i ushko dwayo, ga iara beno tjeng öng jëkkl̈o sok këskës dogl̈o sak kjwara (10) kjing go, ga söra to jek Najor kjokyo, e Aram Najarayin kjokyo obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Öötong shäng kjok l̈i worbo go ga ba öng l̈i iara l̈öng woshtë, di bäng shäryak jong kjwara l̈ishko. Eshko ga kjok sëng, wal̈ëga tjwe di shik eshko l̈i dl̈oyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Eshko ga syõshtono Jehová kong. Tjl̈ẽ ga «Jehová, pja bor kägäyo Abraham Sbö. Pja wotjl̈ĩk pjl̈ú bor kägäyo l̈i kong kuzong ga tja kjimtos sira, l̇l̇ëbo shäryër shäng ëre ber pjl̈ú wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","¡Ĩzong! Tja sök di bäng shäryak jong ëre zl̈ong, kjogl̈oga jũshko so tjwe di shik l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Rokër bop kong sira ga tja kjimtos eni. “Tja kong di shis sira, iër wl̈o” l̈ër kjogl̈o kong eni ga woydër ga kjogl̈o kjrorop bop parkaga Isaac kong l̈i tjl̈ẽ bor kong ga “Di iozong. Bop öng ëmdë ga kong di twër bakoe” l̈e. Miydër e go ga pja wotjl̈ĩk pjl̈ú bor kägäyo kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Syõshtë sök obi wopro ga ĩya ga Rebeca tek shäng di bapkwo söya jong ba dbopdo. Rebeca, e Betuel wa. Betuel, e Najor wa, ba boy Milca tjok. Najor, e Abraham kjl̈arayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeca, e wol̈ësowa. Shäng kjl̈araso, orkwosmoydë l̇l̇ëm obi, domer miydoydë l̇l̇ëm bakoe. Opl̈ongö jer shäng di puk. Ga di bapkwo l̈i dl̈ina ga toe l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Eshko ga parkaga l̈i jek zron jong ba irgo, doshaya wl̈o, ga tjl̈ẽ ba kong ga «Tja së̃s di sira, iër wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kuya ga di bapkwo l̈i l̈ona töshko, ga tjl̈ẽ ba kong ga «Iozong, Tjl̈apga» l̈e. Ga sëna, ga iarae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iara pjir ga tjl̈ẽ ba kong obi ga «Bop öng kjwe ëmdë ga kong di shir, twër, ie l̈ok wl̈o bakoe. Ie äär bayo kjöm ga eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Jekdo eshko ga ba di l̈i tyara öng di iokl̈o buk eshko l̈i roshko, ga kjre öör pjl̈öböso, ĩna ga äär kjwõr ba öng uunkong kong guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","E wopro ga Abraham parkaga wojeno sök ba ĩk, kjing erä. Wotjl̈ĩk sök jl̈õkoyo ga «¿Tja pak shäryë to shäng l̈i kjimtara Jehovárë beno pjl̈ú l̈ëpde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ga ba öng di iono pjir ga ne iokl̈o kjwo shõyl̈ṍr tjwl̈õ ara shira domer l̈irë kjwara, ga twara kjogl̈o l̈i kong, kong orkwo iokl̈o kjwo shõyl̈ṍr këskës tjwl̈õ ara twara ba kong kjwo pjök bako, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ga tjl̈ẽ ba kong ga «¿Pja data ë? ¿Bop data ushko, shto tjokde? ¿Tjawa pë eshko ga buere?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","«Tja data Betuel. E data Najor, mekë Milca. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Borwa ushko ga shto tjok. Pjãy pë eshko ga pjl̈úe. Bop öng kjwe ië wl̈o ga tjawa kjl̈o sho tjok bakoe» l̈e ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Eshko ga parkaga l̈i wl̈oktong sök kjöpgwo go, ga Jehová poshrëra. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Tjl̈ẽ ga «Jehová, pja bor kägäyo Abraham Sbö. Pja tjwl̈õ kësbange. Pja wotjl̈ĩk pjl̈ú ba kong, ga kjimtëp ara. Tja sörop tek bek irbo bäng äär jong ba pjeyoga l̈öng l̈ishko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Eshko ga Rebeca jek zron jong ba mekë ushko, ga l̇l̇ëye shäryono dö l̈i rotara uunkong kong eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ba sing shäng kjl̈ara ko Labán. Ba dor l̈i ne iokl̈o, orkwo iokl̈o l̈ok l̈i ĩna, ga domer l̈i tjl̈ẽno sorë l̈i roy kura. Jekdo eshko ga jek öötong shäng di bäng shäryak jong l̈ishko, Abraham parkaga l̈i wl̈okjre wl̈o. Öötong shäng eshko ga ĩya ga domer l̈i shäng di bäng l̈i zl̈ong, ba öng tjok ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","tjl̈ẽ ba kong ga «Pjãy tegö. Pjãy kjimtara Jehovárë. Pjãy ber l̈öng kjoko l̇l̇ëme. U wl̈ẽnor bomi kong tjän. Bop öng kjwe shto wl̈ẽnor bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kuya ga jek ba tjok ushko. Öötong l̈öng eshko ga Labán tjl̈ẽ ba parkagaga kong ga «L̇l̇ëbo l̈ok öng kjing go kjwe dözĩa. Së̃zĩ bakoe. Domerga kjwe kong di tek sözĩ, dre shkwë e go wl̈o» l̈e. L̈ara sorë ga shäryara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Domerga l̈i kong dl̈i twara tjeng pjirshko ga Abraham parkaga tjl̈ẽ ga «Tja ië l̇l̇ëm, l̇l̇ëye l̈ër woydë l̈i l̈oror pjir guing» l̈e. Kuya Labándë ga tjl̈ẽ ba kong ga «L̇l̇ëye l̈ëp woydë l̈i l̈ozong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kuya ga tjl̈ẽ ba kong ga «Tja Abraham parkaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Bor kägäyo, e kjimte Jehovárë ara. Iara beno sök l̇l̇ëbo ara. Kong öng ushko so, sögl̈a, dbur sho shõyl̈ṍr, dbur sho pjl̈ubl̈ún, parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo, öng jëkkl̈o sok këskës, öng so kwomgl̈a kjoyo dre töshko, e twara ba kong ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ga ba boy Sara tjl̈abl̈ashko ga kong wa twara kjl̈ara domer ba tjok. Ga ba l̇l̇ëbo tjeng kës l̈i twara beno ba wa l̈i kong pjir tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kjupäbäshko ga bor kägäyo tjl̈ẽ bor kong ga “Woydër ga tjl̈õkwo l̈os bor kong jl̈õkoyo. Bor wa Isaac, e ichëp orkwosmok wal̈ë Canaán so tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Pja jongya bor kjokshko, bor pjeyoga l̈öng l̈ishko. Eshko ga kong boy wl̈ẽp kjl̈ara, bor pjeyoga wapga tjrëko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","»Kur ga tja tjl̈ẽ ba kong ga “¿Gueniyo kjogl̈o wl̈ẽnor l̈i tek woydë bor tjok l̇l̇ëm wl̈eni ga l̇l̇ëye shäryër?” ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","»“Tja jëktong shäng Jehová bokshto ĩyado. Ga ba parkaga kjok dogo so iche jek bop bäm go kjl̈ara, pja kjimte äär eshko ga pjl̈ú wl̈o, pja kjimte kjogl̈o bor pjeyo wl̈eniyo wl̈ẽk kjl̈ara wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Eshko ga kjogl̈o l̈i iche woydë bor pjeyogarë l̇l̇ëm wl̈eni ga pja döktong tjl̈õkwo l̈ëp shäng l̈i go” l̈e bor kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","»Eni ga eerishko ga tja shrono sök di bäng shäryak jong kjok ëreshkoshko ga tja syõshtono Jehová kong. Tja tjl̈ẽ ga “Jehová, pja bor kägäyo Abraham Sbö. Tja kjimtos, l̇l̇ëbo shäryër shäng ëre ber pjl̈ú wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","44","Tja sök di bäng ëre zl̈ong wopro ga ‘Tja kong di shis sira, iër wl̈o’ l̈ër kjogl̈oga tjwe l̈öng di kjrë l̈i kong. Eshko ga woydër ga kjogl̈o kjrorop bor kägäyo wa kong l̈i tjl̈ẽ bor kong ga ‘Di iozong. Bop öng ëmdë ga kong di twër bakoe’ l̈e bor kong” l̈oror Jehová kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","»Tja syõshtë sök obi wopro ga ĩn ga Rebeca tek shäng ba di bapkwo söya jong ba dbopdo. Di kjrara pjir ga tja tjl̈ẽ ba kong ga “Tja së̃s di sira, iër wl̈o” l̈ër. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","»Kuya ga ba di bapkwo l̈ona töshko, ga tjl̈ẽ bor kong ga “Iozong, Tjl̈apga. Bop öng kjwe ëmdë ga kong di twër bakoe” l̈e. Ga tja di iono, ga di twara bor öng kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","»E irgo ga tja tjl̈ẽ ba kong ga “¿Pja data ë?” »“Tja data Betuel. E data Najor, mekë Milca” l̈e bor kong. »Eshko ga ne iokl̈o ioror pjang ba ne go, ga orkwo iokl̈o ioror l̈ok ba orkwo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Eshko ga tja wl̈oktong sök kjöpgwo go, Jehová poshrëror. Tja tjl̈ẽ ga “Jehová, pja bor kägäyo Abraham Sbö. Tja wopjl̈ú bop tjok. Tja sörop tek bek irbo bäng äär jong bor kägäyo pjeyoga l̈öng l̈ishko” l̈ër. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","»Era eni ga pjãy wotjl̈ĩk pjl̈ú bor kägäyo kong, ga kjimtëmi woydë wl̈eni ga l̈ozĩ bor kong eni. L̇l̇ëm ga l̈ozĩ bor kong eni bakoe. E go ga l̇l̇ëye shäryër l̈i miydër pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Kuya l̈ok ga Labán, Betuel, e tjl̈ẽ l̈ok ba kong ga «L̇l̇ëbo ëre l̈aga Jehovárë. “L̇l̇ëme” l̈ërwa ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ĩzong. Kjogl̈o shäng kjwe. Sözong. Pjãy nomo. Orkwosmok bop kägäyo wa l̈i tjok ga pjl̈ú, l̈ara Jehovárë sorë l̈i eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kuya Abraham parkagarë ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, Jehová bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","E irgo ga l̇l̇ëbo shira obl̈ë obl̈ë, dbur sho shõyl̈ṍr, dbur sho pjl̈ubl̈ún, shwong bakoe. Ga twara Rebeca kong. Ga ba sing, ba mekë, e sëna l̇l̇ëbo tjwl̈õ ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","E irgo ga iono ba parkagaga tjok, ga pono l̈öng eshko. Wẽshko ga kojono, ga parkaga l̈i tjl̈ẽ ga «¿Tja to iröng bor kägäyo shwoy ga buere?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kuya Rebeca pjeyogarë ga tjl̈ẽ l̈ok ba kong ga «Woydërwa ga kjogl̈o kjwe ber sök borwa tjok sondë pjök dik obi. E irgo ga jek bop tjok ga pjl̈úe» l̈e ba sing, ba mekërë eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kuya ga tjl̈ẽ ba kong ga «Tja shami shäng kjër ame. Tja kuzong. Tja kjimtara Jehovárë, ga l̇l̇ëbo shäryër shäng ëre beno pjl̈úe. Eni ga tja to woydë iröng bor kägäyo shwoy» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kuya l̈ok ga tjl̈ẽ ba kong ga «Kjogl̈o rokëy, wotjl̈ĩk sorë kjakrokëy ba kong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Eni ga rokara l̈ok tek ba shwoy, ga tjl̈ẽ l̈ok ba kong ga «¿Pja jek woydë domer ëre tjokde?» «Ëng. Tja jeke» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Eni ga ichara ba pjeyogarë to domerga l̈i tjok, ba daga ichara jek ba tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ga tjl̈ẽno l̈ok beno pjl̈ú ba kong. Tjl̈ẽ ga «Rebeca, woydërwa ga bop tjëyo tek ber bop irgo l̈i shdär träk l̇l̇ëme. Woydërwa ga ba moskwoga, e zãya pjire» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeca, ba parkaga wal̈ëga, e opyono jem l̈öng öng jëkkl̈o sok këskës l̈i kjing go. Ga to jek Abraham parkaga irgo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","E wopro ga Isaac jek öör shäng di bäng ko «Sbö, Bor Ĩga» jong l̈ishko, ga shrono sök iröng Néguev kjokyo, ba u jong l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Dbar kjwara kjok sëng ga opshino jek shäng woshtë. Ga ĩya ga öng jëkkl̈o sok këskës tek tjeng. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca ëmdë ga omĩno bakoe. Isaac ĩya ga opl̈ono ba öng kjing go dwayo, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ga tjl̈ẽ parkaga l̈i kong ga «¿Domer tek shäng kjl̈oy dwayo bek bi shwo l̈ëkong kjwe ëro?» «Kjwe bor kägäyo» l̈e ba kong. Eni ga bokkwo kjinyokl̈o kjrara kara, ga ba bokkwo kjinyara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Eshko ga l̇l̇ëye shäryono dö l̈i l̈ara parkaga l̈irë Isaac kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","E irgo ga Rebeca söra Isaacdë jek ba mekë Sara u beno jong l̈i roy, ga orkwosmono ba tjok. Rebeca woydara Isaacdë ara. Eni ga ba mekë wol̈ono ëmdë ga beno wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","E irgo ga Abraham orkwosmono jek obi, Cetura tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Wapga tjeng domerga ba tjok ko Zimrán, Jocsán, Medán, Madián, Isbac, Súaj. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsán, e wapga tjeng domerga ko Sabá, Dedán. Dedán, e tjëyo tek beno ba irgo l̈i beno tjëyoga kjringgwo mya, Asur tjëyo, Letús tjëyo, Leum tjëyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madián, e wapga tjeng domerga ko Efá, Éfer, Janoc, Abidá, Eldá. Ëre Cetura tjëyoga uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Pjl̈ara ga Abraham tjl̈ẽ ga «Tja wol̈onoshko ga bor l̇l̇ëbo tjeng kës l̈i iër ber Isaac kong» l̈e. Ba boyga obl̈ë l̈i wapga sëna Abrahamdë l̇l̇ëbo sira sira, ga ichara to Isaac shwoy dwayo, jek öötong l̈öng kjok shto obl̈ë, dl̈o wen tëm shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham l̈u ĩno sak dbäw kjingsho sak kjäk kjingsho shkëng (175). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Tjl̈abl̈ashko ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Eshko ga iara ba wapga Isaac, Ismaeldë beno buk guëng jong ööng Macpela kjokyo l̈i roshko. E ber buk Efrón kjokyo, Mamré kjokyo, dl̈o wen tëm shwo l̈ëkong. Efrón, e data Zojar. Zojar, e Het tjëyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Kjok, e tjwl̈ẽna Abrahamdë Het tjëyoga kong. Eshko ga Abraham doyo iara beno buk ba boy Sara zl̈ong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","E irgo ga Isaac kjimtara Sbörë ara. E beno sök di bäng ko «Sbö, Bor Ĩga» jong l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","13","Ismael, e Abraham wa, Sara parkaga tjwl̈ẽk shäng pjir wl̈eniyo Egipto so ko Agar l̈i tjok. Ismael, e wa buk domer bäm ĩyo ko Nebayot. E irgo tek eni, Cedar, Adbel, Mibsán, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mismá, Dumá, Masá, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Temá, Jetur, Nafis, Cedema. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ba wapga domerga dogl̈o sak kjwara kjingsho pjök (12) l̈i kowara eni. Kjl̈ara kjl̈ara beno l̈öng ba tjëyoga tek beno ba irgo l̈i kägäyo, ga beno l̈öng ba kjok baĩya l̈ishko. Kjok kjrina kjrina l̈i kowaraba beno ba sogo l̈i ko go. Ba tjëyo kjrina kjrina l̈i kowaraba beno eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael l̈u ĩno öötong sak dbäw kjingsho sak mya kjingsho kjäkshko (137) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ba tjëyo tek beno ba irgo l̈i beno l̈öng kjok buk Javilá kjokyo, Sur kjokyo, e tjrëko. Kjok, e ber buk Egipto kjokyo gomyo, irbo jek jong äär Asiria kjokyo l̈i sor go. Wotjl̈ĩno l̈ok ëngkjwë kjĩshko ga beno l̈öng Abraham wapga tjok l̇l̇ëm, beno l̈öng eshko dboye. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ëre Abraham wa Isaac, e to tek jong sorë, e l̈anyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac l̈u pjl̈ogl̈o sak pkëngshko (40) ga orkwosmono Rebeca tjok. Rebeca, e Betuel wa, Labán, e ba sing. Epga, e arameoga l̈öng Padán Aram kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeca, e kjrong kjĩshko ga Isaac syõshtono Jehová kong ba kjĩshko. Kuya Jehovárë ga shäryara eni, ga Rebeca beno shäng kjl̈araso l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Miydara ga wapga tjeng do pjök. Gueniyo epga ëngkjwë tjeng ba bö roy. E kjĩshko ga tjl̈ẽ Jehová kong ga «Ëre owa. ¿Tja oto eniro?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kuya ga tjl̈ẽ ba kong ga «Pja bö roshko chida tjeng do pjök. Ba tjëyo tek ber ba irgo l̈i äär ber tjëyoga kjring pjök. Eeri jek l̈ëkong ga ëngkjwë l̈ok ëng tjok ara. Tjëyo kjrina dbo ara, obl̈ë l̈i kjinmo. Ga bäm ĩyo l̈i ichaga ber ba l̈ëngdë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Eni ga dbaryo öötong ga Rebeca wapga tjeng kjl̈ö. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Buk bäm go l̈i pogl̈o srëzrën, pogl̈o zok do jĩkong, ga koiara Esaú. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Buk ba irgo l̈i, ba shjiy l̈i kjuktu shara ba orkwo go kjĩshko ga koiara Jacob. Eshko ga Isaac l̈u pjl̈ogl̈o sak tjer (60). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kjwozirga l̈i kunoe. Öötong këskës ga Esaú, e domer pjö gl̈oroy so, wl̈o owa l̇l̇ëme. Jacob, era domer wl̈ẽp, ushko so. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac sjëng kjl̈oshko so uë äe. Ga äya kjl̈oshko so zröya Esaúrë, söya ba kong ara kjĩshko ga Esaú woyde ba datarë ara, Jacob kjinmo. Gueniyo Rebecara wotjl̈ĩk eni l̇l̇ëme. Jacob woydayde. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Pjl̈ara ga Jacob shäng dl̈i l̈ik wopro ga Esaú tjwe shäng pjö gl̈oroy dwayo pjl̈i ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ga tjl̈ẽ ga «Tja pjl̈i ara anmoyõ. Bop dl̈i dyor srëzrën kjwe twos bor kong sira» l̈e. (E kjĩshko ga kowëba Edom.) ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kuya ga tjl̈ẽ ba kong ga «Pja bi data wa domer bäm ĩyo. L̇l̇ëye twe bop kong e kjĩshko l̈i, e iëp ber bor kong, dl̈i ëre ãska, l̇l̇ëm ga twër bop kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kuya ga tjl̈ẽ ba kong ga «Tja wol̈onto pjl̈irë. L̇l̇ëye twe bi datarë bor kong l̈i tjwl̈õ bor kong eni tjok ga l̇l̇ëno l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kuya ga tjl̈ẽ ba kong ga «L̈os bor kong jl̈õkoyo eni tjok» l̈e. Kuya ga tjl̈ẽ ba kong ga «Jöl̈ö» l̈e. Ga beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Era ga pjl̈ung shosho suk pjir twara Esaú kong, shtagwo l̈ik jong dyor l̈i tjok. Uara, iara pjir ga kojono, ga toe. Ga l̇l̇ëye twe ba datarë ba kong l̈i woyotjl̈ĩna ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abraham sök së obishko ga pjl̈i shrono arae. Ga Isaac dbaryoshko ga pjl̈i shrono jek kjok eshko, e kjoyo obi. E kjĩshko ga Isaac to jek Guerar kjokyo, filisteo pjl̈uyo Abimélec sökshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Eshko ga Jehová weno shäng ba kong, ga tjl̈ẽ ga «Pja jek Egipto kjokyo l̇l̇ëme. Pja ber sök kjone l̈ër bop kong l̈ishko ga pja ber sök ey. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Pja ber sök kjok ëreshko dbar kjwöbö. Kjok ëre twër ber bop kong, bop tjëyo tek ber bop irgo l̈i kong kuzong ga tja ber shäng bop tjok, pja kjimtër bakoe. Tjl̈õkwo l̈oror bop data Abraham kong jl̈õkoyo l̈i shäryër ber eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","5","Bop tjëyo tek ber bop irgo l̈i iër ber shdär träk l̇l̇ëm, dbala l̈ok kjopkwo go wl̈eni. Ga kjok ëre twër ber ba kong uunkong. Ba kjĩshko ga tjëyo kjrina kjrina kjok kjwang jĩkong l̈i kjimtër. Tja beno wopjl̈ú Abraham tjok. Tja bangkjrara. Tja tjl̈õkwo kjrara. Bor kjok l̇l̇gwekkl̈o kol̈ara. E kjĩshko ga tjl̈õkwo l̈oror ba kong jl̈õkoyo l̈i shäryër pjir eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Eni ga Isaac beno sök Guerar kjokyo ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ba boy Rebeca tjok. Rebeca wol̈ësowa kjĩshko ga Isaac wotjl̈ĩk ga «Tja zrökoba ba kjĩshko» l̈e. Kjakroke l̈ok ba kong Rebeca kjĩshkoshko ga tjl̈ẽ ba kong ga «Kjwe bor dor» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ga beno sök kjok eshko dbar kop ara. Pjl̈ara ga ĩya Abimélecdë ba u bäng bäng dwayo ga Isaac bë shäng Rebeca shrëk. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Eni ga Isaac rokara ba shwoy, ga tjl̈ẽ ba kong ga «¡Miydoror pjl̈ú ga kjwe bop boy! ¿Kjwe bop dor l̈orop ega?» «Tja zrökoba ba kjĩshko l̈oror. L̈oror eni e kjĩshko» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kuya ga tjl̈ẽ ba kong ga «¿Kjwe shäryëp borwa kong ega? Bor nopga kjok ëre so pono bop boy kjwe tjok kjwe ga tjawa iorop beno uunkong l̇l̇ëbo owashko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Eni ga tjl̈ẽ ba nopga kong ga «Domer ëre barwaga ërë, ba boy barwaga ërë ga e zrökko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","L̈u e go ga Isaac dwl̈a dgono kjok eshko, ga bo kjrara tira l̇l̇ëm, kjimtara Jehovárë kësbang kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","E irgo ga beno sök dbur ara, l̇l̇ëbo träk l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Kong öng ushko so twara kjl̈araso l̇l̇ëm, sögl̈a tira l̇l̇ëm, domerga parkaga kjl̈araso l̇l̇ëm bakoe. Eshko ga ba l̇l̇ëbo l̈i kjĩshko ga filisteoga wotjl̈ĩno ba kong owa. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Eni ga ba data Abraham sök së obishko ga di bäng shäryara ba parkagagarë tjeng l̈i, e dl̈ina filisteogarë uunkong kl̈ung sho go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Eni ga Abimélec tjl̈ẽ Isaac kong ga «Pja opshis jũshko dwayo. Pja tjwl̈õ ara, borwa kjinmo anmoyõ» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Eni ga Isaac to jek Guerar sdamyo, ga beno sök eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ba data Abraham sök së obishko ga di bäng shäryara ba parkagagarë eshko, gueniyo wol̈ono irgo ga dl̈ina filisteogarë uunkong. Eni ga di bäng l̈i shäryara Isaacdë jek obi, ga uunkong l̈i koiara, koiara ba datarë dënashko sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Pjl̈ara ga Isaac parkagaga l̈öng kl̈ung kë, di bäng shärye wl̈o. Eshko ga di bokkwo wl̈ẽna kjrina. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gueniyo eshko ga öng dagaga Guerar so l̈öng kjl̈öbö. Ga ëngkjwono Isaac öng dagaga tjok, tjl̈ẽ ba kong ga «Di ëre borwatoy» l̈e. E kjĩshko ga di bäng l̈i, e kowara Isaacdë «Ëngkjwozl̈ong» di bäng, ëngkjwono l̈ok eshko kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","E irgo ga Isaac parkagaga di bäng shäryono jek kjwara obi, e goyo ga jek ëngkjwono l̈ok obi. E kjĩshko ga di bäng l̈i, e kowara Isaacdë «Shji Iirkë Ëng Kong» di bäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isaac to pjola eshko dwayo ga di bäng shäryara kjwara obi. Ëngkjwono ba di bäng l̈i kjĩshko ame kuzong ga kowara beno «Shji Döktong» di bäng. Ga tjl̈ẽ ga «Shji kjimtara Jehovárë, shji kong kjok twara ara, shji wapga shdär kjok ëre kjing go pjl̈ú wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Eshko ga Isaac to jek Berseba kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","E shkëyo ga Jehová weno shäng ba kong, ga tjl̈ẽ ga «Tja bop data Abraham Sbö. L̇l̇ëye bangkjrëp l̇l̇ëme. Tja shäng bop tjok. Bor parkaga Abraham kjĩshko ga pja kjimtër, bop tjëyo tek ber bop irgo l̈i iër ber shdär träk l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Eshko ga akkwo töna dl̈uw ëng kjing go kjókshko, Jehová poshrëkkl̈o. Ga syõshtono Jehová kong bakoe. Ga ba u shäryak öng kwota go l̈i iara jong eshko, ga ba parkagaga di bäng shäryono kjwara. Ga beno l̈öng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Dbar kjwara ga Abimélec jek Guerar kjokyo dwayo, l̈an Isaac tjok wl̈o. Yorkaga ba kjimtaga ko Ajuzat, ga ëngkjwaga kägäyo ko Ficol bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Öötong l̈öng eshko ga Isaac tjl̈ẽ ba kong ga «Tja woydoromi l̇l̇ëme. Tja ichoromi bomi kjokshko dwayo. ¿Eni ga pjãy tek l̈öng bor ĩk l̇l̇ëno?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","«Ĩnorwa ga Jehová shäng bop tjok. E kjĩshko ga woydërwa ga shji tjl̈ẽ ëng kong jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","L̇l̇ëbo owa shäryororwa bop kong l̇l̇ëme. Tjawa jëktong pjl̈ú bop tjok ĩyado. Pja brikshko ga pja ichororwa jek wopjl̈úe. Ga eeri ga pja kjimte Jehovárë shäng. E kjĩshko ga l̇l̇ëbo owa shäryororwa bop kong l̇l̇ëm kuzong ga l̈os borwa kong jl̈õkoyo ga tjawa kong l̇l̇ëbo owa shäryëp l̇l̇ëm bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kuya ga epga mana ië, ga sëna ara. Epga iono l̈ok tira l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wẽshko kjok shröngto ga tjl̈ẽno ëng kong jl̈õkoyo irgo ga jek brik l̈öng kjwl̈ëshko ga Isaac tjl̈ẽ ba kong l̈ok ga «Pjãy nome» l̈e. Kuya l̈ok ga tjl̈ẽ ba kong ga «Shji ëng ĩkdo» l̈e ba kong, epenga dö wl̈eni. Ga «Jöl̈ö» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","E dbaryo ga Isaac parkagaga tjwe l̈öng roy söga, tjl̈ẽ ba kong ga «Kl̈ung kërwa l̈öng l̈i, e diyo wl̈ẽnorwae» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Di bäng, e kowara Isaacdë beno Seba. E kjĩshko ga kjok ber buk eshko l̈i ko Berseba obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaú l̈u pjl̈ogl̈o sak pkëngshko (40) ga orkwosmono wal̈ë ko Judit tjok. Ba data ko Beerí. Orkwosmono Basemat tjok bakoe. Ba data ko Elón. Beerí, Elón, e Het tjëyoga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Gueniyo Isaac, Rebeca, e beno l̈öng wotjl̈ĩk ara wal̈ëga do pjök l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac öötong tjl̈abl̈ashko ga beno sök kjok ĩgö ame. Pjl̈ara ga ba wa këguëyo rokara, ga tjl̈ẽ ba kong ga «Esaú.» «¿L̇l̇ë?, data» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tjl̈ẽ ga «Miydëp pjl̈ú ga tja tjl̈abl̈a tjän, tja wol̈on döröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","E kjĩshko ga bop sböng kjros, bop könkowo tjok, ga pja nom wl̈orkë pjö gl̈oroy, äya kjl̈oshko so uako wl̈eniyo zröp kjl̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Zrörop ga sho shäryëp bor kong yõtso, woydër sorë l̈i eni. Ga söp bor kong, uër wl̈o. Eshko ga tja wol̈ontë l̇l̇ëm obishko ga tjl̈õkwo l̈ër ber pjl̈ú bop kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Gueniyo Isaac tjl̈ẽ sök Esaú kong l̈i kura Rebecarë. E kjĩshko ga Esaú to pjö gl̈oroy wl̈orkë äya kjl̈oshko so uako wl̈eniyo zrök ba data kong wopro ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca tjl̈ẽ ba wa iröng l̈i kong ga «Jacob, tja kuzong. Bop data kuror sök tjl̈ẽ bop shjiy kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Äya kjl̈oshko so uako wl̈eniyo zröp kjl̈ara, ga l̈ip bor kong yõtso, uër wl̈o. Eshko ga tja wol̈ontë l̇l̇ëm obishko ga tjl̈õkwo l̈ër ber pjl̈ú bop kong Jehová bokshto” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","E kjĩshko ga l̇l̇ëye l̈ër bop kong l̈i kus yõtso. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pja nom öng kjëryo roy, ga tja kong shwl̈ing ushko so owa l̇l̇ëm wl̈eniyo tek söp do pjök. Woyde bop datarë sorë ga shäryër ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","E irgo ga söga pjarë om go, ue wl̈o. Eni ga wol̈ontë l̇l̇ëm obishko ga tjl̈õkwo l̈e ber pjl̈ú bop kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kuya ga tjl̈ẽ ba kong ga «Bor shjiy, e pogl̈o zok ara, tja eni l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tja porwara bor datarë wl̈eni ga miyde ga tja l̈e. Eni ga e ioror beno tjwl̈õ l̇l̇ëm wl̈eni l̈e. Eshko ga tjl̈õkwo l̈e ber pjl̈ú bor kong wl̈o l̈i, e l̈e ber owa shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kuya ga tjl̈ẽ ba kong ga «¡Tja kuzong! Tjl̈õkwo l̈e ber owa bop kong l̈i, e ber bor kong dey. L̇l̇ëye l̈ër bop kong l̈i shäryozong. Shwl̈ing ushko so l̈i tek sözong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kuya ga öör öng l̈i kjrë, ga söra jek ba mekë kong. E irgo ga l̈ira, shäryara beno uak owa l̇l̇ëm, woydara Isaacdë sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Esaú shwong jnek tjeng, e shira, ga Jacob doyara e go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","E irgo ga pogl̈o zok l̇l̇ëm kjĩshko ga ba orkwo popgara öng l̈i kwota go, ba kjwl̈ingdo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Öng sho shäryara owa l̇l̇ëm l̈i twara ba kong, pjl̈ung shosho sura, twara ba kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Eni ga Jacob opzrëno jek ba data bukshko, ga tjl̈ẽ ga ba kong ga «Miga data.» «Kjobe. ¿Pja bor wa kjone dey?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","«Tja Esaú, bop wa këguëyo. L̇l̇ëye l̈orop bor kong l̈i shäryoror pjire. Pja kojõs sira, pja sirkes sök töshko. Sjëng zröror, shäryoror ëre uozong. Ga tjl̈õkwo l̈ëp ber pjl̈ú bor kong» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kuya ga tjl̈ẽ ba kong ga «¿Wl̈ẽnop mal̈ing sorë?» «Bop Sbö Jehová, tja kjimtara ba wl̈ẽk mal̈inge» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kuya ga tjl̈ẽ ba kong ga «Pja tek nogo sit, pja porwër wl̈o, pja bor wa Esaúre miydër wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kuya ga tek shrono shäng ba data zl̈ong. Eshko ga pogl̈o kura ba datarë, ga tjl̈ẽ ba kong ga «Bop tjl̈ẽ l̈i Jacob ĩ, gueniyo bop orkwo l̈ira Esaú ĩ» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Eni ga ba orkwo l̈i zok ara Esaú ĩ kjoyo kjĩshko ga e ë to miydara ba datarë l̇l̇ëme. Gueniyo l̇l̇ëbo ber pjl̈ú ba kong l̈aydeshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","tjl̈ẽ ba kong jek obi ga «¿Jl̈õkoyo ga pja bor wa Esaúre?» «Ëng. Tja Esaú» l̈e Jacobdë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Eni ga ba data tjl̈ẽ ba kong ga «Dl̈i shäryorop bor kong l̈i tek sös bor kong uër wl̈o. Eshko ga tjl̈õkwo l̈ër ber pjl̈ú bop kong» l̈e. Kuya ga sëna, ga kjil̇l̇gwo bo dyo dbo ara twara ba kong bakoe. Uara, iara pjir ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","tjl̈ẽ ba wa kong ga «Pja tek bor zl̈ong. Tja l̈õ shizong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kuya ga jek öötong shäng ba zl̈ong ga shwong l̈õ shira ba datarë. Eshko ga Isaac tjl̈ẽno beno pjl̈ú ba kong. Tjl̈ẽ ga «Bor wa, e pogl̈o l̈õ kl̈ung kjimtara Jehovárë l̈i kjoyoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Pja kjimte Sbörë, tjong borya ter kjok dogo dwayo, bop dwl̈a l̇l̇ë dgorop l̈i wen pjl̈ú, owa l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Pja parkaga ber ara, ga tjëyoga obl̈ë obl̈ë kjök tok bop bokshto. Bop pjeyoga pjl̈ol̇l̇gwega ber pjarë, ga kjök tok bop bokshto bakoe. Ëye wotjl̈ĩk owa bop kong ga Sbö wotjl̈ĩk owa ba kong bebi. Ëye wotjl̈ĩk pjl̈ú bop kong ga Sbö wotjl̈ĩk pjl̈ú ba kong bebi bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","L̈ara eni pjir ga Jacob opshik jek shäng kjwl̈ë ba data sökshko ga Esaú tek tjwe shäng pjö gl̈oroy dwayo, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ga sjëng kjl̈oshko so zröno l̈i shäryara uak owa l̇l̇ëm bakoe. E irgo ga söra ba data kong, ga tjl̈ẽ ba kong ga «Data, pja kojõs sira. Sjëng kjl̈oshko so zröror ëre uozong. Ga tjl̈õkwo l̈os ber pjl̈ú bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kuya ga tjl̈ẽ ba kong ga «¿Pja ë?» «Tja Esaú, bop wa këguëyo» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kuya ga beno sök sëya l̇l̇ëme. Tjl̈ẽ ga pjë l̇l̇ëme. Tjl̈ẽ ga «¿Eni ga ëye sjëng kjl̈oshko so söno shäryak owa l̇l̇ëme? Uoror bäm go pja tjwayde l̇l̇ëm obishko yẽ. Ga tjl̈õkwo l̈ër ber pjl̈ú bop kong l̈oror l̈i l̈oror ba kong tjän. L̇l̇ëye l̈oror l̈i beno ba kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kuya ga sl̈atong jl̈õkoyo, iir goshko. Tjl̈ẽ ga «¡Data! ¡Tjl̈õkwo l̈os ber pjl̈ú bor kong bakoe!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kuya ga tjl̈ẽ ba kong ga «Bop l̈ëng öör shäng, ga tja jyãpgwarae. Tjl̈õkwo l̈ër ber pjl̈ú bop kong l̈oror l̈i sörae» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kuya ga tjl̈ẽ ba kong ga «Koiak Jacob e kjĩshko. Tja l̈ũyotkara kjwe tjok ga pjl̈ogl̈o pjök. Bor shto, tja ba shjiy këguëyo, e döra bor shjiryo. Ëre, tjl̈õkwo l̈e datagarë ber pjl̈ú ba wapga domerga bäm ĩ wl̈eniyo kong l̈i, e söra bakoe. Data, ¿tjl̈õkwo l̈ëp pjl̈ú jnenop beno bor kong obl̈ë l̇l̇ëmde?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","«L̇l̇ëme. E ioror beno sök bop ichaga tjän. Ba pjeyoga uunkong ioror beno ba parkaga. Ba dwl̈a dgara l̈i wen träk l̇l̇ëme l̈oror ba kong. ¿Era pja kjwër l̇l̇ong?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","«¿Eni l̈i tjl̈õkwo l̈ëp ber pjl̈ú bor kong obi ga äre? Tjl̈õkwo l̈os ber pjl̈ú bor kong bakoe» l̈e. Ga sl̈atong jek obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Eni ga ba data tjl̈ẽ ga «Kl̈ung pjl̈ú wl̈eniyo, tjong borya l̈onshko ga pja ber sök pjolae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Bop dröng l̈i go ga pja opwl̈ikë. Pja ber shäng bop l̈ëng parkaga, gueniyo pja dbokjronoshko ga pja där» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Jekdo eshko ga Esaú beno iirkë ara ba l̈ëng kong, tjl̈õkwo l̈ara ba datarë ber pjl̈ú ba kong l̈i kjĩshko. Ga wotjl̈ĩk ga «Bor data dbar beno sira döe. Wol̈ono irgo ga bor l̈ëng zrör kjl̈uwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Wotjl̈ĩk sök sorë l̈i miydara Rebecarëshko ga Jacob rokara, ga tjl̈ẽ ba kong ga «Tja kuzong. Bop shjiy, pja zröya woydë. L̇l̇ëbo shäryorop, e tjwl̈õ shiya woydë bop kong l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","E kjĩshko ga tja kuzong. Pja poshäryozong. Pja tökzong jekdo Jarán kjokyo, bor sing Labán ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Pja ber sök dbar kop ara eshko, bop shjiy iir l̈i jeno guing, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","l̇l̇ëye shäryorop l̈i woyojera guing. Eshko ga roy ichër jek bop kong, pja tek iröng wl̈o. Woydër ga pjãy ëng zrök l̇l̇ëme. Tja bor wapga do pjök jer dbar kjwaraso ga äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","E irgo ga Rebeca tjl̈ẽ ba l̈anma kong ga «Tja sök së woydë kjër ame. Tja kwl̈era Esaú boyga Het tjëyoga l̈i tjok. Jacob äär orkwosmok Het tjëyoga jũshko so tjok wl̈eni ga rokër ga tja wol̈on dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Eshko ga Jacob rokara Isaacdë ba shwoy, ga tjl̈ẽno beno pjl̈ú ba kong. Tjl̈ẽ ga «Pja orkwosmok wal̈ë Canaán so tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Pja nom Padán Aram kjokyo, bop kjokë Betuel ushko. Pja orkwosmok bop kégue Labán wapga tjok kjl̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Sbö, l̇l̇ëye shärye woydë l̈i shärye ga pjl̈úe. Woydër ga pja kjimte. Pja kong bop tjëyo tek ber bop irgo l̈i ie ber shdär träk l̇l̇ëm, ie ber l̈öng tjëyoga obl̈ë obl̈ë bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Woydër ga tjl̈õkwo l̈ara Abraham kong jl̈õkoyo l̈i ber bop kong, bop tjëyo tek ber bop irgo l̈i kong bako, eeri ga kjok shji l̈öngshko ëre ber bomi kong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Jacob ichara jek Padán Aram kjokyo eni, ga to jongya Labán ushko. Labán, e Betuel wa, Rebeca sing bakoe. Betuel, e arameo. Rebeca, e Jacob, Esaú mekë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Miydara Esaúrë ga ba data tjl̈ẽno beno pjl̈ú Jacob kong, ga ichara to Padán Aram kjokyo orkwosmok eshko wl̈o. Eshko ga Jacob ichara orkwosmok wal̈ë Canaán so tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ba data, ba mekë tjl̈õkwo kol̈ara Jacobdë, ga to jek Padán Aram kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Miydara Esaúrë ga ba boyga Canaán so woyde ba datarë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","E kjĩshko ga öör shäng Ismael ĩk, e Abraham wa. Eshko ga wal̈ë shäng kjl̈ara ko Majalat. Majalat, e Nebayot dor, Ismael wa, Abraham tjër. Ga Esaú orkwosmono ba tjok. Boyga mya l̈i beno l̈öng ba tjok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob opshino jek Berseba kjokyo dwayo jek shäng Jarán kjokyo l̈e. (Jarán kjokyo, e ko Padán Aram bakoe.) ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Jek irbo wenzong ga öötong kjok sënge. E kjĩshko ga shto wl̈ẽno pë eshko wl̈o l̈e. Eni ga ak kjrara kjwara, iara ba kä iokl̈o, ga opbuno buk töshko eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","E irgo ga pë ga yoĩno pjl̈ara. Ĩna ga tyokl̈o jem jong kjl̈ara kl̈ung kjing go dwayo äär jong kjok dogo. E goshko Sbö parkagaga kjok dogo so jem l̈öng, ter l̈öng e go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ga Jehová kojono shäng eshko, ga tjl̈ẽ ba kong ga «Tja Jehová, bop kjokë Abraham Sbö, bop data Isaac Sbö bakoe. Kjok pja bukshko ëre twër ber bop kong, bop tjëyo tek ber bop irgo l̈i kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Epga shdär l̈ok träk l̇l̇ëm, shtëy ga äär l̇l̇ëm, kl̈ung pjl̈ungyo wl̈eni. Epga äär l̈öng kjok sorshko, pjribrie. Bomi kjĩshko ga nopga l̈öng kjok ëre kjing go kjimtër uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tja shäng bop tjok. Pja jek kjone pogo ga pja dër, ga pja sör tjwe iröng, kjok ëreshko obi. Pja rayër l̇l̇ëm, l̇l̇ëye l̈oror bop kong jl̈õkoyo l̈i shäryoror bop kong pjir guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob wol̇l̇enoshko ga wotjl̈ĩk ga «Jl̈õkoyo ga Jehová shäng kjok ëreshko, gueniyo miydoror l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","E kjĩshko ga kjok bangkjrara ara. Wotjl̈ĩk ga «Kjok ëreshko iak beno buk dboy Sbö kong. Ba u jong jũshko. Kjok ëre iak beno buk ba u bäng wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Wẽshko kjok shröngto ga Jacob kojono. Ba ak kä iokl̈o l̈i kjrara, poyona, iara beno jong kojong, ber ba yoĩno l̈i jyãgl̈o wl̈o. E kjing go kjyo tyara sira, ber jong dboy Sbö kong wl̈o, ga iara beno Sbö kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Dënashko ga kjok eshko l̈i ko Luz, gueniyo kjl̈opswara, iara Jacobdë beno ko Betel. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Eshko ga Jacob tjl̈õkwo l̈ono Sbö kong jl̈õkoyo, tjl̈ẽ ga «Sbö, woydër ga tja kjimtëp, tja jëk shäryër shäng ëre wopro ga pja ber shäng bor tjok, tja kong dl̈i twëp, tja kong shwong twëp pjung wl̈o, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","tja söp tjwe iröng obi bor data ushko pjl̈úe. Tja kjimtëp eni wl̈eni ga Jehová, pja bor Sbö jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ak kojonor jong ëre ber jong bop u. Ga l̇l̇ëye twëp bor kong dö l̈i shtër äär ba sakyo (10) go, ba sakyo (10) go, shir kjrina kjrina, ga twër bop kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob to jek shäng jëk ĩ, öötong shäng kjok dl̈o wen tëm shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Eshko ga ĩya këm jũni ga kjok tjrëko di bäng shäryak jong kjwara. Öng ushko so l̈öng woshtë ba zl̈ong kjringgwo mya, di ië eshko ä kjĩshko. Ak buk kjwara kësbang ba kjing go, di bäng l̈i kjingokl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Öng l̈i ëng töng uunkong di bäng shäryak jong l̈ishko ga ak kje öng dagagarë guing, di shiya ba kong wl̈o. Së̃ya l̈ok pjir ga di bäng kjingue jek iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Eni ga Jacob tjl̈ẽ öng dagaga l̈öng l̈i kong ga «¿Pjãy kjone so?» «Tjawa Jarán so» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kuya ga tjl̈ẽ ba kong ga «¿Labán miydëmire? E Najor tjër.» «Ëng, miydërwa» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kuya ga tjl̈ẽ ba kong ga «¿Sök yonde?» «Ëng, sök yone. Ĩzong. Ba wa Raquel kjwe tek shäng ba öng ushko so tjok» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kuya ga tjl̈ẽ ba kong ga «Kjok dba obi, dl̈o pjang obi. Öng bängzazl̈ong dl̈oyo äätë l̇l̇ëm obi. ¿Kong di twëmi, sömi kjl̈o sho uë obi wl̈o l̇l̇ëm ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","«Shäryërwa eni ga ä, öng dagaga töno uunkong, ak buk di bäng kjing go kjwe kjara pjir guing. Eshko ga öng kjwe sënwa di ga pjl̈úe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","L̈öng l̈an ëng tjok wopro ga Raquel tjwe shäng ba data öng tjok, e ba öng daga kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ĩya Jacobdë ga tjwe shäng ba data Labán öng tjok ga jekdo shäng di bäng zl̈ong, ga ak l̈i kjara, ga ba öng sëna di. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","E irgo ga Raquel l̈õ shira, ga sl̈atong tira l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ga tjl̈ẽ ba kong ga «Labán, e bor kégue. Ba dor Rebeca, e bor mekë» l̈e. E irgo ga Raquel opshino jek zron jong ba roy l̈ë ba data kong ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Jacob roy kuya Labándë ga opshino jek mal̈ing ba wl̈okjrë. Öötong shäng ba shwoy ga popjl̈ura, l̈õ shira, ga söra jek ba ushko. Ga l̇l̇ëye shäryono ba tjok dö l̈i l̈ara Jacobdë ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kuya ga tjl̈ẽ ba kong ga «Pja bor pjeyo jl̈õe» l̈e. Jacob beno sök Labán tjok mok kjl̈arashko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labán tjl̈ẽ ba kong ga «Pja bor pjeyo. Gueniyo pja parkë kjër ga pja potjwl̈ẽn l̇l̇ëm ga äe. Woydëp ga pja potjwl̈ẽn kjöme ga l̈os bor kong, miydër wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labán wapga kjogl̈oga tjeng do pjök, ba wa wal̈ë këguëyo ko Lea, ba l̈ëng ko Raquel. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea bokkwo wol̈ësowa döe. Gueniyo Raquelda wol̈ësowa anmoyõ do jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Raquel woydara Jacobdë arae. E kjĩshko ga tjl̈ẽ Labán kong ga «Tja parkë bop kong l̈u pjl̈ogl̈o kjäk (7), ãska bop wa mite Raquel twëp bor kong, tja orkwosmok ba tjok wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Kuya ga tjl̈ẽ ba kong ga «Pjl̈ú wl̈o ga twër bop kong dey, domer obl̈ë kongda l̇l̇ëme. Pja ber sök bor shwoy dey» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Eni ga Jacob parkono ba kong l̈u pjl̈ogl̈o kjäk (7), orkwosmok Raquel tjok wl̈o. Gueniyo Raquel woyde ara anmoyõ kuzong ga kuya ga dbar ba kong chira anmoyõ. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","E irgo ga Jacob tjl̈ẽ Labán kong ga «Tja parkono bop kong wl̈o l̈i, e l̈uyo öötonge. Bor boy twos bor kong, tja orkwosmok ba tjok wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Eni ga Labán, ba pjeyoga eshko so mana uunkong, dl̈i l̇l̇ë shäryara, ää bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ga öötong kjok shkë go ga ba wa Lea söra, twara Jacob kong, ga Jacob pono ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Eshko ga Lea parkaga shäng kjl̈ara ko Zilpá, ga twara ba datarë ba kong, ber ba kjimtaga wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Wẽshko kjok shröngto ga miydara Jacobdë ga pono Lea tjok. Ga l̈ãywara Labán kong, tjl̈ẽ ba kong ga «¿L̇l̇ëye shäryorop bor kongdo? Tja parkono bop kong, tja orkwosmok Raquel tjok wl̈o. ¿Tja jyãpgworop ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","«Tjawa jũshko so sgara l̈öng wapga këguë orkwosmok bäm go, e irgo ga ba l̈ëng. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","E kjĩshko ga pja orkwosmono Lea tjok. Woydër ga dbar shrëy sondë kjwara. Pjir ga pja orkwosmok Raquel tjok bakoe. Gueniyo pja parkë bor kong äär jong l̈u pjl̈ogl̈o kjäk (7) obi ba ãska» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kuya ga tjl̈ẽ ba kong ga «Jöl̈ö» l̈e. Ga orkwosmono sondëyo bäm l̈i pjitongshko ga Raquel twara Labándë ba kong, ber ba boy wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Raquel kong parkaga twara ba datarë kjl̈ara ko Bilhá, ber ba kjimtaga wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Eshko ga Jacob pono Raquel tjok bakoe. Ga woydara ara, Lea kjinmo. E irgo ga beno shäng parkë Labán kong l̈u pjl̈ogl̈o kjäk (7) obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ĩya Jehovárë ga Lea, e woyde Jacobdë l̇l̇ëm kuzong ga kong wapga twara. Gueniyo Raquelda beno shäng wapga drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea beno shäng kjl̈araso l̇l̇ëme. E irgo ga wa buk kjl̈ara domer ga tjl̈ẽ ga «Ĩna Jehovárë ga tja sök woydë ara. Era ëre go ga tja woyde bor l̈anmarë arae. E kjĩshko ga koiër Rubén» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea dbar kjwöböso ga shäng kjl̈araso l̇l̇ëm obi. Ga wa buk kjl̈ara domer obi ga tjl̈ẽ ga «Kura Jehovárë ga tja woydëba l̇l̇ëme. E kjĩshko ga tja kong wa twara domer kjl̈ara obi. E kjĩshko ga koiër Simeón» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","E irgo ga jek beno shäng kjl̈araso l̇l̇ëm obi. Ga wa buk kjl̈ara domer obi ga tjl̈ẽ ga «Era tja woyde bor l̈anmarë ara anmoyõ, ba tjok ga tja wapga tjeng domerga dogl̈o mya kjĩshko. E kjĩshko ga koiër Leví» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea jek beno shäng kjl̈araso l̇l̇ëm obi. Ga wa buk kjl̈ara domer obi ga tjl̈ẽ ga «Ëre go ga Jehová poshrër. E kjĩshko ga koiër Judá» l̈e. E irgo ga beno wa ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ĩya Raqueldë ga wapga Jacob tjok l̇l̇ëm kuzong ga Lea ymoyotkara ara. Ga tjl̈ẽ ba l̈anma kong ga «Tja wapga woydë. Shäryëp sorë ga tja ber wapga tjok. L̇l̇ëm ga tja wol̈on» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Gueniyo kuya ga iirkono ara ba kong, ga tjl̈ẽ ga «¿Eni l̈i pja wotjl̈ĩk ga tja Sbö l̈ëpde? Pja wa l̇l̇ëm kjwe l̈aga erë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kuya ga tjl̈ẽ ba kong ga «Bor parkaga Bilhá shäng ëre. Pja pos ba tjok. Eni ga wapga tjokshko ga epga ber l̈öng bor wapga wl̈eni. Eni ga tja wapga tjok l̈ër wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Eni ga Bilhá twara Jacob kong, ber ba boy obl̈ë ba parkaga wl̈eniyo wl̈o. Ga Jacob pono ba tjok, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ga beno shäng kjl̈araso l̇l̇ëme. Wa buk kjl̈ara domer ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raquel tjl̈ẽ ga «Tja syõ kura Sbörë. Tja l̇l̇gwera, ga beno pjl̈ú bor kong, ga tja kong wa twara kjl̈ara domer. E kjĩshko ga koiër Dan» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","E irgo ga Bilhá beno shäng kjl̈araso l̇l̇ëm obi. Ga wa buk kjl̈ara domer obi, Jacob tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Eshko ga Raquel tjl̈ẽ ga «Tja dbonino bor wi tjok ara, ga zanor. E kjĩshko ga bor wa ëre koiër Neftalí» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Miydara Learë ga wa ame kuzong ga ba parkaga Zilpá twara Jacob kong, ber ba boy obl̈ë ba parkaga wl̈eniyo wl̈o. Ga Jacob pono ba tjok, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ga beno shäng kjl̈araso l̇l̇ëme. Wa buk kjl̈ara domer ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea tjl̈ẽ ga «Tja kong l̇l̇ëbo weno pjl̈ú tjän. E kjĩshko ga bor wa ëre koiër Gad» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","E irgo ga Zilpá beno shäng kjl̈araso l̇l̇ëm obi. Ga wa buk kjl̈ara domer obi, Jacob tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Eshko ga Lea tjl̈ẽ ga «Tja woowa l̇l̇ëme. Ga wal̈ëga uunkong tjl̈ẽ ëng kong ga “Kjwe wopjl̈úe” l̈e. E kjĩshko ga bor wa ëre koiër Aser» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Dbar kjwara ga dwl̈a dgara bo kjrozl̈ong dbaryoshko ga Rubén jek kjl̈oshko. Eshko ga kjor l̈ok kjwöbö ko mandrágora. Bo wl̈ẽna Rubéndë ga söra, twara ba mekë Lea kong. Ĩya Raqueldë ga tjl̈ẽ Lea kong ga «Tja kjimtos sira. Tja kong bop kjor bo söra bop warë kjwe twos bor kong pjökde myare» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kuya ga tjl̈ẽ ba kong ga «Bor l̈anma dörop bor shjiryo. ¿Ga pja wotjl̈ĩk ga l̇l̇ëbo shäryorop l̈i beno bor kong pjl̈ú l̈ëpde? ¿Era kjor bo söra bor warë ëre ëmdë ga döp woydë bor shjiryo bakore?» «Eni ga kjor bo kjwe ãska, pjesit shkëyo ga pja pë Jacob tjok ga pjl̈úe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kjok sëng ga Jacob tek shäng iröng ba pakshko dwayo ga wl̈okjrara Learë irbo. Tjl̈ẽ ba kong ga «Eeri shkëyo ga pja pë bor tjok. Pja tjwl̈ẽnor shäng pjir tjän, mandrágora bo söra bor warë bor kong l̈i go» l̈e. Eni ga e shkëyo ga Jacob pono ba tjok, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ga ba syõ kura Sbörë kjĩshko ga beno shäng kjl̈araso l̇l̇ëme. E irgo ga wa buk kjl̈ara domer. E tjok ga wapga tjeng domerga dogl̈o shkëng (5) tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ga Lea tjl̈ẽ ga «Tja potjwl̈ẽna Sbörë, bor parkaga tworor bor l̈anma kong kjĩshko. E kjĩshko ga bor wa ëre koiër Isacar» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","E irgo ga Lea beno shäng kjl̈araso l̇l̇ëm obi. Ga wa buk kjl̈ara domer obi, Jacob tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ga tjl̈ẽ ga «Tja kjimtara Sbörë. Tja sëna l̇l̇ëbo owa l̇l̇ëme. Tja wapga tjeng domerga dogl̈o tjer (6) bor l̈anma tjok kuzong ga tja poshrëya ara. E kjĩshko ga bor wa ëre koiër Zabulón» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","E irgo ga Lea wa tjeng kjl̈ara obi wal̈ë. E koiara Dina. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Gueniyo Sbö, Raquel woyotjl̈ĩna bakoe. Ba syõ kura, ga wa l̇l̇ëm l̈i döra. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ga Raquel wa buk kjl̈ara domer ga tjl̈ẽ ga «Tja l̈ök ara wa l̇l̇ëm kjĩshko l̈i döra Sbörë bor kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Woydër ga tja kong wa twe Jehovárë kjl̈ara domer obi. E kjĩshko ga koiër José» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raquel wa José buk irgo ga Jacob tjl̈ẽ Labán kong ga «Tja ichos to bor kjokshko iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Bor boyga twos bor kong. Tja parkono bop kong ba kjĩshko tjän. Bor wapga twos bor kong bakoe. Tja ichos jek ba tjok. Tja parkono shäng bop kong sorë, e miydëp pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Gueniyo kuya ga tjl̈ẽ ba kong ga «Rokër bop kong sira ga pja ber sök borwa tjok obi. Miydoror bor l̇l̇ëbo miydokl̈o go ga tja kjimtara Jehovárë bop kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Pja dbur woydë kjöme l̈i l̈os bor kong, ga pja potjwl̈ẽn bayo eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kuya ga tjl̈ẽ ba kong ga «Miydëp pjl̈ú ga tja parkono bop kong pjl̈ú, bop öng doror owa l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Dämär ga tja tjwayde l̇l̇ëm obishko ga pja l̇l̇ëbo ara l̇l̇ëme. Tja shäng bop tjok kjĩshko ga pja kjimtara Jehovárë, bop l̇l̇ëbo, e shdöktong träk l̇l̇ëme. Gueniyo eerishko ga tja parkë bor kong shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Kuya ga tjl̈ẽ ba kong ga «¿Woydëp ga pja potjwl̈ẽn kjöm?» «Tja potjwl̈ẽp l̇l̇ëme. L̇l̇ëye rokër bop kong l̈i jl̈õ l̈orop wl̈eni ga tja jek bop öng dë obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Eeri ga tja ichos jek shäng bop öng ushko so tjeng l̈i tjrëko. L̈öng bayo tjok tjok, e kjër dboye. Bop öng wl̈ẽp ushko so kjl̈o sĩ wl̈eniyo, e kjër dboy bakoe. Tja potjwl̈ẽp e go eröe. Öng bayo eni l̇l̇ëm wl̈eniyo ber bop kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Eni bong kjönma ga pja tjwe shäng bor öng kjroror bor pak ãska l̈i ĩga ga pjl̈úe. Bor öng ber bayo tjok uunkong, ga bor öng wl̈ẽp ushko so ber kjl̈o sĩ eröe. Eni l̇l̇ëm ga miydëp pjl̈ú ga pja l̈ũyotkoror» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Kuya ga «Jöl̈ö» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Gueniyo e dbaryo ga ba öng bayo tjok l̈i twara Labándë ba wapga kong, de wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","E irgo ga epga ichara opshino to jek kjok eshko dwayo ba öng l̈i tjok, Jacob sökshko ga jëktong dbargwo mya äär eshko wl̈o. Jacobda beno shäng Labán öng l̇l̇amo tjeng l̈i dë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Eshko ga kjor kowo kësong zara kjringgwo mya. E irgo ga poshtara beno sĩ, pjl̈ubl̈ún, ĩga wẽl̈ë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","E irgo ga iara l̈ok ba öng tjwe di iozl̈ong l̈i bokshto. Eni ga wl̈ënggl̈a jëk l̈öng ba popga pogoshko ga wapga shguin l̈öng bayo tjok, so kjor kowo l̈i kjoyoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Eshko ga Labán öng bayo tjok tjeng kjl̈öbö. Ga wl̈ënggl̈a l̇l̇ë jëk ba popga goshko ga ie Jacobdë ber öng bayo tjok l̈i bokshto, öng wl̈ẽp ushko so kjl̈o sĩ l̈i bokshto bako, ba wapga wen bayo eni wl̈o. Eni ga Jacob öng weno träk l̇l̇ëme. Ga iara beno tjeng Labán ĩ tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wl̈ënggl̈a jëk l̈öng ba popga tjokshko ga öng këskës, kjl̈o dik l̈i kong kjor kowo l̈i ie l̈ok ba bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Gueniyo öng kjl̈o owa l̈i kong kjor kowo l̈i ie ba bokshto l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Eni ga Jacob beno shäng dbur ara, öng ara, parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Miydara Jacobdë ga Labán wapga to l̈öng tjl̈ẽ ëng kong ga «Bi data l̇l̇ëbo kjrara Jacobdë drete. E go ga beno dbur ara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ĩya Jacobdë ga e ĩya Labándë bokkwo owa, dämär dik l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Eni ga Jehová tjl̈ẽ ba kong ga «Pja nom iröng bop data kjokshko, bop pjeyoga tjengshko. Eshko ga tja jëk shäng bop tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Raquel, Lea, e rokara Jacobdë ba shwoy, shäng ba öng dë l̈ishko, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ga tjl̈ẽ ba kong ga «Miydër ga bomi data, tja woyde dämär dik l̇l̇ëme. Gueniyo bor data Sbö, era shäng bor tjok ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Miydëmi pjl̈ú ga tja parkono shäng bomi data kong pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Gueniyo tja jyãpgwara, bor potjwl̈ẽkkl̈o kjl̈opswara enido. Gueniyo tja kjimtara, dara Sbörë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Pjl̈ara ga bomi data tjl̈ẽ bor kong ga “Pja parkë öng bayo tjok l̈i ãska” l̈e. L̈e enishko ga wapga weno l̈öng bayo tjok uunkong. Pjl̈ara obi ga tjl̈ẽ bor kong ga “Pja parkë öng kjl̈o shrit l̈i ãska” l̈e. L̈e enishko ga wapga weno l̈öng kjl̈o shrit uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Eni ga bomi data öng l̈i döra Sbörë ba shjiryo, ga twara bor kong shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","»Dbar kjwara ga öng l̈öng wl̈ënggl̈a woydë dbaryo wl̈enishko ga yoyoĩnor ga wl̈ënggl̈a l̈öng bayo tjok, kjl̈o shrit l̈i jëk l̈öng ba popga tjok, wl̈ënggl̈a bayo l̇l̇ëm l̈i l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Era Sbö parkaga kjok dogo so, tja rokara. Tjl̈ẽ ga “Jacob.” »“¿L̇l̇ë?, Tjl̈apga” l̈ër ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","»Tjl̈ẽ ga “L̇l̇ëye shäryara Labándë bop kong dö l̈i ĩnor. E kjĩshko ga ĩp eshko ga öng wl̈ënggl̈a l̈öng bayo tjok, kjl̈o shrit l̈i jëk l̈öng ba popga tjok, wl̈ënggl̈a bayo l̇l̇ëm l̈i l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Sbö weno shäng bop kong Betel kjokyo l̈i tja, ak kjing kjyo tjyoropshko, tjl̈õkwo l̈orop bor kong jl̈õkoyoshko. Pja nom kjok jũshko dwayo, pja jek iröng bop kjokshko, pja weno bukshko” l̈e bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kuya Raquel, Learë ga tjl̈ẽ ba kong ga «Tjawa kong l̇l̇ëbo twe borwa datarë, e wl̈ẽnwa ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tjawa iara beno l̈öng tjwl̈õ l̇l̇ëm, epenga l̇l̇ëm wl̈eni. Tjawa soynena, ga l̇l̇ëye kjrara borwa kjĩshko l̈i söra drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Bek wl̈o ga l̇l̇ëbo tjeng kës döra Sbörë borwa data shjiryo l̈i, e borwatoy, borwa wapga ĩ bakoe. E kjĩshko ga l̇l̇ëye shäryëp l̈ara Sbörë bop kong l̈i shäryos eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","19","Eshko ga Labán to ba öng zok shtë kjok shto obl̈ë. Sök l̇l̇ëm wopro ga ba sböpga jyãgl̈o tjeng ba ushko l̈i l̈ũyotkara Raqueldë. Eshkoshko ga Jacob poshäryono. E irgo ga ba wapga, ba boyga, e opyono l̈ok ba öng jëkkl̈o sok këskës l̈i kjing go, ga toe. Ba öng kës jëk tjeng ba tjok, ba l̇l̇ëbo baĩya tjeng kës töna tjeng Padán Aram kjokyo l̈i, e söra jek ba tjok bakoe. Ga to jongya Canaán kjokyo, ba data Isaac sökshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Labán jyãpgwara Jacobdë eni. Ga Jacob töktong to l̈ara ba kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Opshino, ba l̇l̇ëbo tjeng kës l̈i söra pjire. Ga jek öötong Éufrates diyo kjakoshko ga zara jek tas, ga jëktong jek l̈öng Galaad kjokyo dl̈up shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Öötong dbar mya ga roy kura Labándë ga «Jacob to töktonge» l̈ëba. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","25","Eni ga töno ba pjeyoga tjok, ga irpjana jëktong dbargwo kjäk (7), ga doshara öötong l̈öng Galaad kjokyo dl̈up shwo l̈ëkong, Jacob wl̈o l̈öng l̈ishko. Labán wl̈o sl̈ano, pono l̈öng eshko bakoe. E shkëyo ga Sbö tjl̈ẽno Labán kong yoshko, tjl̈ẽ ga «Tja kuzong. Jacob, e kroyoywëp l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Wẽshko ga Labán tjl̈ẽ Jacob kong ga «¿L̇l̇ëye shäryoropdo? Tja jyãpgworop. Bor wapga wal̈ëga l̈ũyotkorop. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Tja jyãpgwëp eni ega? ¿Pja opjnek l̈ũtshko ega? L̇l̇ëye l̈opdë bor kong l̇l̇ëm obi. Woydoror ga pja opshik dbaryoshko ga pja kong dl̈i shäryër, shji ië ëng tjok, shji të, shji bërkë, shji l̇l̇ung l̇l̇ë të bakoe. L̈oror eni, gueniyo pja briktonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Bor wapga wal̈ëga, bor tjërga ëmdë ga iorop l̈õ shir wl̈o l̇l̇ëm, “Pjãy nome” l̈ër ba kong wl̈o l̇l̇ëm bakoe. Pja opshäryono kä l̇l̇ëm wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Pja kong l̇l̇ëbo owa shäryër wl̈o ga pjl̈ú, pjãy uunkong kong. Gueniyo l̈una shkëyo ga bop data Sbö tjl̈ẽno bor kong ga “Tja kuzong. Jacob, e kroyoywëp l̇l̇ëme” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Miydër pjl̈ú ga pja jek woydë ara bop data ushko iröng obi. ¿Gueniyo bor sböpga jyãgl̈o l̈ũyotkorop ega?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Kuya ga tjl̈ẽ ba kong ga «L̈ër bop kong jl̈õkoyo ga pja bangkjroror ara. Tja wotjl̈ĩno ga bop wapga wal̈ëga döp bor shjiryo l̈oror. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Gueniyo ëye wl̈ẽnop jũshko, bop sböpga jyãgl̈o tjok ga zröy. Bi pjeyoga l̈öng ëre iër ber l̈öng ba miydaga. L̇l̇ëbo bopoya l̈ëp l̈i wl̈ẽs, ga sözong» l̈e. Gueniyo ba sböpga jyãgl̈o l̈ũyotkara Raqueldë to miydara Jacobdë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","34","Eni ga Labán opzrëno jek Jacob u shäryak öng kwota go l̈i roshko ba sböpga jyãgl̈o wl̈ẽk. Pjir ga ba wapga parkagaga pjök ĩ l̈i roshko, Lea ĩ l̈i roshko bakoe. Gueniyo l̇l̇ëye wl̈ẽna l̇l̇ëme. E wopro ga ba data sböpga jyãgl̈o l̈i jnena Raqueldë tjeng ba öng jëkkl̈o sok kësbang l̈i sökkl̈o dirko, sökshko. Labán opshino tek Lea u l̈i roy dwayo ga opzrëno jek Raquel ĩ l̈i roy shara. E roshko ga roĩna pjir, gueniyo l̇l̇ëye wl̈ẽna l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Eshko ga Raquel tjl̈ẽ ba data kong ga «Pja iirkë bor tjok l̇l̇ëme. Tja kojong bop bokshto ga äe. Eni tjok ga tja shäng bor dbar ĩk» l̈e. Eni ga ba sböpga jyãgl̈o wl̈ẽna däw ga wl̈ẽna l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Eshko ga Jacob iirkono ara, ga tjl̈ẽno dbo go Labán kong. Tjl̈ẽ ga «¿Tja l̇l̇ëye wl̈ẽnop owa bop bokshtoro? ¿Tja irpjam ega? ¿L̇l̇ëye owa shäryoror bop kongdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Pja bor l̇l̇ëbo roĩno, sguinop drete. ¿Eni ga l̇l̇ëbo wl̈ẽnop bopoya tjokde? Wl̈ẽnop ga tek sös jũshko, bi pjeyoga ëre bokshto, shji kjone dey ga jëk l̈öng pjl̈o bek ĩya l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","»L̈u pjl̈ogl̈o sak pjök (20) ga tja öör shäng parkë bop kong ga öng ushko so wa shguino do go kjl̈ara l̇l̇ëme. Bop öng ushko so wl̈ënggl̈a uotë kjl̈ara l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Bop öng uara äya kjl̈oshko sorëshko ga ãska tworor bop kong enido. Dba ga l̈ũyotkarabashko ga tjwl̈õ shirop bor kong, ga l̈ũyotkaraba shkëshko ga tjwl̈õ shirop bor kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Dba ga tja wl̈oyo dl̈orë. Shkë ga tja wl̈oyo smorë, tja pë eshko ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","»Ga tja öör sök l̈u pjl̈ogl̈o sak pjök (20) bop ushko ga l̈u pjl̈ogl̈o sak kjwara kjingsho pkëng (14) ga tja parkono bop wapga wal̈ëga do pjök kjwe ãska, ga l̈u pjl̈ogl̈o tjer (6) ga tja parkono bor öng ushko so kjwe ãska. Bor potjwl̈ẽkkl̈o l̈i kjl̈opsworop enido. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Sbö shäng bor tjok ĩyado. E bor data Isaac Sbö, bor kjokë Abraham Sbö bakoe. Sbö shäng bor tjok l̇l̇ëm kjwe ga tja ichorop jek shäng or rorëe. Gueniyo ga tja song l̈i ĩna Sbörë. Bor pak kës shäryoror l̈i ĩna bakoe. E kjĩshko ga l̈una shkëyo ga shji l̇l̇gwera beno pjl̈ú bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Kuya ga tjl̈ẽ ba kong ga «Bor wapga wal̈ëga kjwe botoya. Bor tjërga kjwe botoya bakoe. Öng kjwe botoya bebi. L̇l̇ëbo ĩp uunkong ëre, e botoya eröe. ¿L̇l̇ëye shäryër eeri dbaryo bor wapga wal̈ëga kong, bor tjërga kong ga pjl̈ú? L̇l̇ëye shäryër ba kong ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","E kjĩshko ga shji tjl̈õkwo twë ëng kong, ber ĩyado wl̈o, ga shji jëk ber l̈öng e go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Eni ga Jacob ak kjrono, poyona, ga iara beno jong kojong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Eshko ga tjl̈ẽ ba parkagaga kong ga «Ak tö̃zĩ, ak jong kjwe zl̈ong bäng» l̈e. E irgo ga iono l̈ok eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Eshko ga Labán tjl̈ẽ ba kong ga «Ak tjeng dl̈uw ëre ber ba woyoshrokl̈o bi kong» l̈e. E kjĩshko ga kjok eshko kowara Labándë arameo tjl̈õkwo go beno Yegar Saduta. Jacob omkowono hebreo tjl̈õkwo go beno Galaad. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ga Labán tjl̈ẽ ba kong obi ga «Shji l̈öng pjola, shji ëng ĩk ame ga shji ĩga, daga ber Jehovárë» l̈e. E kjĩshko ga kjok eshko kowara beno Mizpa bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Eshko ga Labán tjl̈ẽ ba kong ga «Pja bor wapga bokrotkë wl̈eni, l̇l̇ëm ga pja orkwosmok wal̈ë obl̈ë tjok wl̈eni ga miydër l̇l̇ëme. Gueniyo woyoshros ga e miydaga ber Sbörë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ak tjeng dl̈uw ëre ĩzong. Ak kojonor beno jong shji pjök tjrëko jũ ĩs bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kjring pjöyĩkong ber l̈öng ba miydokl̈o. Pja tek na l̈ë, bor barwë wl̈o l̇l̇ëme. Tja jek kal̈ë, bop barwë wl̈o l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bop kjokë Abraham Sbö, e ber bi l̇l̇gwega. Bor kjokë Najor sbö, e ber bi l̇l̇gwega bakoe» l̈e. Eshko ga Jacob tjl̈ẽno jl̈õkoyo ba data Isaac Sbö bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","E irgo ga öng zröra kjl̈ara, sho sura kjrina, pjono dret Sbö poshrëkkl̈o, l̇l̇amo beno tjeng l̈i l̈ira ba pjeyoga kong. Uara l̈ok pjir ga pono l̈öng dl̈upshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Wẽshko kjok shröngto ga Labán kojono, ba tjërga l̈õ shira, ba wapga wal̈ëga bakoe. Ga tjl̈ẽno beno pjl̈ú ba kong. E irgo ga sano jek ba kjokshko iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Eshko ga Jacob irbo shano to bakoe. Eshko ga Sbö parkagaga kjok dogo so wen l̈öng irbo bäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ĩya Jacobdë ga tjl̈ẽ ga «Ëre ëngkjwagaga Sbö ĩ» l̈e. E kjĩshko ga kjok eshko koiara beno Majanayin. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","E irgo ga nopga ichara jek Seir kjokyo ba roy dbuk bäm go, ba shjiy Esaú kong. Seir kjokyo, e Edom kjokyo obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Roy sögaga brikdë l̇l̇ëm obishko ga tjl̈ẽ ba kong l̈ok ga «Pjãy tjl̈ẽ bor shjiy Esaú kong ga “Tjl̈apga, bop l̈ëng Jacob öör sök Labán ushko däwe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Era eerishko ga öng këskës chila ara, parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo ara bakoe. Ga roy ichara bop kong eni, pja ber wopjl̈ú ba tjok wl̈o” l̈ëmi ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Roy sögaga l̈i öör, ga shrono iröng obi ga tjl̈ẽ Jacob kong ga «Tjawa öör Esaú ĩk. Eni tjok ga tek shäng om go bop wl̈okjrë, yorkaga domerga dogl̈o sak dbäw pjl̈ogl̈o pkëng (400)» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kuya ga bangkjrara ara, beno shäng sjëk. E kjĩshko ga ba nopga tjeng ba tjok l̈i shdöra beno kjring pjök, ba öng shdöra eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Wotjl̈ĩk ga «Esaú tjwe ëngkjwë bor nopga kjrina tjok wl̈eni ga e wopro ga kjrina, e tök ga bue» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","E irgo ga syõshtono Sbö kong. Tjl̈ẽ ga «Sbö, pja bor kjokë Abraham Sbö. Pja bor data Isaac Sbö bakoe. Jehová, pja tjl̈ẽno bor kong ga “Pja nom bop kjokshko iröng obi, bop pjeyoga l̈öngshko. Pja kjimtër l̇l̇ëbo ber pjl̈ú bop kong wl̈o” l̈orop eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Pja wotjl̈ĩk pjl̈ú bor kong wl̈eni ga tja kjimtëp ĩyado. ¿Gueniyo ga shäryëp ega? Jl̈õkoyo ga tja bop parkaga eröe. Jordán diyo jũ zër tek shängshko ga tja wl̈oshko bor kjorkung ëre döe. Era eni tjok ga tja öötong sök parkagaga kjring pjök, öng kjring pjök bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Bangkjrër l̈i bor shjiy Esaú tek shäng bor zrök, bor boyga, bor wapga zrök bakoe. Tja wl̈ikos, l̇l̇ëbo owa shärye bor kong l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Pja tjl̈ẽno bor kong ga “Pja kjimtër l̇l̇ëbo ber pjl̈ú bop kong wl̈o. Bop tjëyo tek ber bop irgo l̈i iër ber shdär träk l̇l̇ëm, shtëy ga äär l̇l̇ëm, l̈a sho tjeng dl̈ung kjako wl̈eni” l̈orop eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","E shkëyo ga Jacob pono buk eshko. Wẽshko ga l̇l̇ëbo tjeng ba tjok kës l̈i rowl̈ẽna ba shjiy kong, ba sënggl̈o wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Wl̈ẽna l̈i ëre: shwl̈ing ushko so popga dogl̈o sak dbäw pjl̈ogl̈o pjök (200), wl̈ënggl̈a dogl̈o sak pjök (20), öng wl̈ẽp ushko so popga dogl̈o sak dbäw pjl̈ogl̈o pjök (200), wl̈ënggl̈a dogl̈o sak pjök (20), ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","öng jëkkl̈o sok këskës wapga chilawa tjok wl̈eniyo dogl̈o sak mya (30) ba wapga tjok, sögl̈a popga dogl̈o sak pkëng (40), wl̈ënggl̈a dogl̈o sak kjwara (10), öng so kwomgl̈a kjoyo dre töshko popga dogl̈o sak pjök (20), wl̈ënggl̈a dogl̈o sak kjwara (10). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","E irgo ga twara beno ba parkagaga kong, tö̃ya dboy dboy wl̈o, ga tjl̈ẽ ba kong ga «Pjãy jek l̈öng bor bäm go, ga shto twozĩ öng kjrina kjrina shdök tjeng wl̈e kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Eshko ga tjl̈ẽ ba parkaga jek shäng bäm l̈i kong ga «Bor shjiy Esaú dowl̈ẽp tek shäng ga tjl̈ẽ bop kong ga “¿Bop kägäyo ë? ¿Pja to kjone? ¿Öng kjwe sogo ë?” l̈e bop kong wl̈eni ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","pja tjl̈ẽ ba kong ga “Tjl̈apga Esaú, ëre bop sënggl̈o, ichara bop l̈ëng Jacobdë bop kong. E tek shäng om go borwa irgo” l̈ëp ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","E irgo ga tjl̈ẽ ba parkagaga jek ber tjeng iröng l̈i kong ga «Esaú dowl̈ẽmi tek shäng kjone wl̈eni ga l̇l̇ëye l̈oror kës l̈i l̈ëmi ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Pjãy tjl̈ẽ ba kong obi ga “Tjl̈apga, bop l̈ëng Jacob tek shäng borwa irgo” l̈ëmi ba kong eni» l̈e. Wotjl̈ĩk ga «Wl̈ẽpyotkër ba sënggl̈o ichoror jek tjeng bäm l̈i go. E irgo ga tja oppingdo ba bokshto kjwl̈ë jã. Eni ga tja wl̈okjre pjl̈ú kjwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Eni ga ba sënggl̈o l̈i ichara jek bäm go ba parkagaga tjok. Gueniyo Jacob pono beno buk eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","24","E shkëyo ga ba pjeyoga dipzara jek Jaboc diyo kjwo kal̈ëkong, ba l̇l̇ëbo tjeng kës l̈i tjok. Ba boyga do pjök, ba boyga obl̈ë ba parkagaga wl̈eniyo do pjök, ba wapga dogl̈o sak kjwara kjingsho kjl̈ara (11), e iara beno l̈öng di kjwo kal̈ëkong pjir ga Jacob dipzono jek iröng, ga beno sök eshko tjoksa. Eshko ga domer weno shäng ba kong kjl̈ara, ga dbonino ba tjok äär jong shkë jek shrönge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Miydara ga Jacob zãya ga äshko ga porwara ba kworboshko, ga ba kworbo jöktëng erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Eshko ga domer l̈i tjl̈ẽ ba kong ga «¡Tja rayozong! Kjok shräntoe» l̈e. Kuya ga tjl̈ẽ ba kong ga «Tjl̈õkwo l̈os ber pjl̈ú bor kong. L̇l̇ëm ga pja rayër l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kuya ga tjl̈ẽ ba kong ga «Pjae, ¿ko l̇l̇ë?» «Tja ko Jacob» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kuya ga tjl̈ẽ ba kong ga «Pja ko Jacob ame. Pja dbonino Sbö tjok, nopga tjok, ga zanope. E kjĩshko ga pja ko ber Israel shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kuya ga tjl̈ẽ ba kong ga «¿Pja e, ko l̇l̇ë?» «¿Tja ko miydëp woydë l̇l̇ëno?» l̈e ba kong, ga tjl̈ẽno beno pjl̈ú Jacob kong eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Eshko ga Jacob tjl̈ẽ ga «Tja, Sbö, tjawa ëng ĩno l̈öng ëng bokshto ëmdë ga tja iara beno sök së» l̈e. E kjĩshko ga kjok eshko kowara beno Peniel. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jacob jek shäng kjwl̈ë Peniel kjokyo l̈ishko ga dl̈o wen tëm pjang l̇l̇ënge. L̈aga ba kworbo jöktëng l̈irë ga beno jëk yökyöke. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Porwara ba kworboshko kjĩshko ga öng l̇l̇ë kworbo kjyungyo ue Jacob tjëyo tek beno ba irgo l̈irë ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Döni ga ĩya Jacobdë pjola dwayo ga Esaú tek shäng domerga dogl̈o sak dbäw pjl̈ogl̈o pkëng (400) tjokshko ga ba wapga shdöra beno ba mekë tjok tjoke. Ba boyga obl̈ë parkagaga wl̈eniyo do pjök l̈i iara tjeng bäm go, ba wapga baĩya tjok. Lea iara shäng ba irgo, ba wapga baĩya tjok. Raquel iara beno iröng, ba wa José tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ga Jacob opshino jek bäm go. Jek shäng ba shjiy shwoy wopro ga jëk jek sira ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go. Jëk sira obi ga kjök tono eni obi. Shäryara eni öötong pjl̈ogl̈o kjäk (7). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Gueniyo ga Esaúra jek zron ĩ äär jong ba l̈ëng shwoy, ga pjä ba go, popjl̈ura, l̈õ shira. Eshko ga sl̈atong l̈ok ara pjöyĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","E irgo ga Jacob boyga, wapga ĩya Esaúrë ga tjl̈ẽ ba l̈ëng kong ga «¿Ëye tek l̈öng bop tjok kjwe ë?» «Tjl̈apga, kjwe bor wapga twara Sbörë bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ga ba boyga obl̈ë parkagaga wl̈eniyo do pjök l̈i öötong l̈öng ba shjiy zl̈ong ba wapga tjok ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","E irgo ga Lea tek shrono shäng ba wapga tjok ga kjök tono, kjujono eni bakoe. E irgo ga José, Raquel omshäryono eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eshko ga Esaú tjl̈ẽ ba kong ga «¿Öng wl̈ẽnor irbo kjwe l̇l̇ë l̈okl̈o?» «Ichoror jek bop kong, pja ber wopjl̈ú bor tjok wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kuya ga tjl̈ẽ ba kong ga «L̇l̇ëme. Botoya arae. Kjwe ber tjeng bop tjok wẽyẽ» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Gueniyo kuya ga tjl̈ẽ ba kong ga «L̇l̇ëme. Rokër bop kong sira ga tja wl̈okjrorop pjl̈ú l̈ëp l̈i jl̈õ wl̈eni ga l̇l̇ëbo twër bop sënggl̈o kjwe kjrozong. Pja wotjl̈ĩno pjl̈ú bor kong kjĩshko ga pja bokkwo ĩnor ga Sbö bokkwo ĩnor wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Sbö kjĩshko ga tja l̇l̇ëbo ara, l̇l̇ëye woydër l̈i tjeng enido. E kjĩshko ga bop sënggl̈o söror bop kong kjwe kjrozong» l̈e. Eshko ga «L̇l̇ëbo kjrozong» l̈ara ba kong ara kuzong ga «Jöl̈ö» l̈e Esaúrë, ga kjrarae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Eshko ga tjl̈ẽ ga «Shji toe. Tja jek shäng bop bäm go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kuya ga tjl̈ẽ ba kong ga «Tjl̈apga, miydëp pjl̈ú ga kjwozirga chilawa jëk mae. Öng wapga chilawa tjok wl̈eni l̈i söy jëk dbar kjwara jl̈õkoyo wl̈eni ga e kjer drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Pjl̈ú wl̈o ga pja to bäm dey, Tjl̈apga. Tja jek ber shäng bop irgo wor, öng kjĩshko, kjwozirga kjĩshko. Shji ëng ĩk Seir kjokyo, bop kjokshko jã» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kuya ga tjl̈ẽ ba kong ga «Jöl̈ö. Gueniyo nopga jëk tjeng bor tjok ëre iër ber l̈öng bop tjok kjl̈öbö, bop yorkë» l̈e. Kuya ga «¿L̇l̇ëno? Pja woydë eshko l̇l̇ëme. Tja kjimtëp woydë kjĩshko ga tja ber wopjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Eni ga e dbaryo ga Esaú wl̈o opshino to jek iröng, äär Seir kjokyo wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ga Jacob wl̈ora opshino to jek Sucot kjokyo. Öötong l̈öng eshko ga u ywara kjwara ba kong, ga ukwang shäryara ba öng kong. E kjĩshko ga kjok eshko kowara beno Sucot. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","E irgo ga Jacob wl̈o opshino tek Padán Aram kjokyo dwayo, ga döktong shrono l̈öng pjl̈ú Canaán kjokyo. Eshko ga pono beno l̈öng kjok l̈i worbo go, e ber buk Siquén kjokyo gomyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kjok eshko l̈i tjwl̈ẽna Jamor wapga kong, tjwl̈õ dbur sho pjl̈ubl̈ún kjwo sak dbäw (100). Jamor, e Siquén data. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Era Jacob akkwo töno dl̈uw ëng kjing go kjókshko, Sbö poshrëkkl̈o, ga akkwo töna dl̈uw l̈i kowara Sbö, e Israel Sbö. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jacob wa kjl̈ara Lea tjok ko Dina. Dbar kjwara ga jek opshino kjogl̈oga eshko so ĩk. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Eshko ga domer shäng kjl̈ara ko Siquén, ba data ko Jamor. Jamor, e kjok eshko so kägäyo. Dina ĩya Siquéndë ga shara, pono ba tjok dbo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","E irgo ga Dina woryara ara, ga tjl̈ẽno ba kong yõtso ba wl̈ẽpyotkokl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","E irgo ga tjl̈ẽ ba data Jamor kong ga «Kjogl̈o kjwe woydër ara. Tja orkwosmok woydë ba tjok. Wl̈ẽs bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","E wopro ga miydara Jacobdë ga ba wa Dina kjrara Siquéndë dbo go. Gueniyo eshkoshko ga ba wapga domerga l̈öng öng dë kjl̈oshko. Ga l̇l̇ëye l̈ara Jacobdë ë kong l̇l̇ëm, ba wapga shrono guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","E wopro ga Siquén data Jamor to jek shäng Jacob shwoy, l̈an ba tjok wl̈o. Epga l̈öng l̈anshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jacob wapga domerga to l̈öng kjl̈oshko l̈i shrono. Ga l̇l̇ëbo shäryono l̈i miydara ga beno bangyo ara, iirkë ara bakoe. Siquén pono ba dor tjok l̈i, e l̇l̇ëbo owa Israel tjëyoga kong. E shäryako l̇l̇ëme. Epga iirkono ara e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Eshko ga Jamor tjl̈ẽ ba kong l̈ok ga «Bor wa Siquén, bomi dor woyde arae. Rokër bomi kong sira ga ichëmi orkwosmok ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Eni ga shji ber l̈öng epenga dö wl̈eni, ga bomi kjogl̈oga orkwosmok borwa tjok, borwa kjogl̈oga orkwosmok bomi tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Pjãy ber l̈öng borwa tjok kjok ëre kjing go ga pjl̈ú, ga pjãy mär ber l̈öng e go. Pjãy jëk kjone pogo ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ga Siquén tjl̈ẽ ba kong l̈ok ga «Rokër bomi kong sira ga kumi ga pjl̈ú. L̇l̇ëye rokëmi bor kong l̈i twër bomi kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tja kong l̇l̇ëye rokëmi bayo kjöm ga twër bomi kong, bomi sënggl̈o. Gueniyo kjogl̈o l̈i ichëmi orkwosmok bor tjok guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Eni ëmdë ga Dina bangkjrara Siquéndë l̇l̇ëm, kjrara dbo go kjĩshko ga Jacob wapga tjl̈ẽno ba kong, ba data Jamor kong jl̈õ wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Tjl̈ẽ ga «Borwa dor, e ichërwa orkwosmok domer doyo jyã tak l̇l̇ëm tjok ga äe. Shäryororwa eni kjwe ga tjawa ber l̈öng l̈ök ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tjl̈õkwo l̈ërwa bomi kong l̈i shäryëmi eni wl̈eni ga “Jöl̈ö” l̈ërwa. L̇l̇ë kuzĩa. Pjãy domerga doyo jyã tëmi uunkong, pjãy ber tjawa dik wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Eni wl̈eni ga borwa kjogl̈oga orkwosmok bomi tjok, bomi kjogl̈oga orkwosmok borwa tjok bakoe. Tjawa ber l̈öng bomi tjok, ga shji ber tjëyo kjrinaso. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Gueniyo pjãy doyo jyã të l̇l̇ëm ga tjawa to kjok ëreshko dwayo, borwa dor tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kuya l̈ok ga beno pjl̈ú ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Dina woyde Siquéndë ara kuzong ga ba doyo jyã tara jekdo eshko. Siquén, ba pjeyoga tjok ga tjwl̈õ ara ba data ushko kuzong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","jek öötong shäng kjok eshko opzrëzl̈ong shtoyo, nopga tön l̈öng l̈ishko, ba data Jamor tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Eshko ga tjl̈ẽ l̈öng l̈i kong ga «Domerga ëre bi pjeyoga wl̈eni. Kjok ëre bayo ara ba kong. E kjĩshko ga woydërwa ga epga ber l̈öng bi tjok kjok ëre kjing go, mär ber l̈öng e go, jëk kjone pogo ga pjl̈ú bakoe. Eni ga ba kjogl̈oga orkwosmok bi tjok, bi kjogl̈oga orkwosmok ba tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","»Gueniyo shji ber l̈öng tjëyo kjrinaso wl̈o ga woyde l̈ok ga shji domerga doyo jyã të uunkong, epga omshäryë dik. E ba sdëkwo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Eni ga ba öng kës, ba l̇l̇ëbo tjeng kës, e ber bishĩya. Epga ber l̈öng bi tjok wl̈o ga “Jöl̈ö” l̈ëy ba kong eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kuya l̈ok ga «Jöl̈ö» l̈e ba kong, ga domerga kjok eshko so doyo jyã tono uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Dbargwo mya ga doyo bang ara, poptoydë l̇l̇ëm obishko ga Dina simga Simeón, Leví, e öör l̈öng eshko ga domerga l̈i zröra l̈ok dröng go dret, wl̈ikaga ërë l̇l̇ëm kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Jamor, ba wa Siquén, e zröra l̈ok dröng go. E irgo ga Dina jek söra ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","E irgo ga Jacob wapga l̇l̇amo tjwe l̈öng jëktong shinmoga doyo tjeng l̈i kjing go. Ga opzrëno jek l̈ok u kjwara kjwara roshko, ba l̇l̇ëbo l̈ũyotkara l̈ok dret, ba dor kong l̇l̇ëbo owa shäryara l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","L̇l̇ëbo uunkong tjeng kjok eshko l̈i söra l̈ok dret, öng ushko so l̇l̇ë, sögl̈a, kwomgl̈a, l̇l̇ëbo tjeng ba ushko, l̇l̇ëbo tjeng kjl̈oshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ba wapga, ba wal̈ëga, e söra l̈ok jek ba tjok uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Eshko ga Jacob tjl̈ẽ Simeón, Leví kong ga «Tja ioromi beno owa kjok eshko sopga tjok. Canaán sopga, ferezeoga, tja ĩywa l̈ok shjiktëng shara. Shji nopga kjl̈öbö dö anmoyõ kjĩshko ga kjring pjök l̈i tön ber tjeng kjrinaso ga shji zröya l̈ok, bi pjeyoga uunkong tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Gueniyo kuya ga tjl̈ẽ ba data kong ga «Borwa dor kong l̇l̇ëbo owa shäryara, iara beno tjwl̈õ wal̈ë to shäng opsoynek domerga obl̈ë obl̈ë kong wl̈eniyo. Iërwa ber eni ga äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","E irgo ga Sbö tjl̈ẽ Jacob kong ga «Pja shäng Esaú töywëshko ga tja weno shäng bop kong Betel kjokyo. Pja nom sök eshko shara, ga akkwo töm dl̈uw ëng kjing go kjókshko, bor poshrëkkl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Eshko ga Jacob tjl̈ẽ nopga tjeng ba tjok kës l̈i kong ga «Bomi sböpga jyãgl̈o tjeng uunkong, shizĩ, dbuzĩ drete. Pjãy nom wë, pja shwong kjl̈opswë obl̈ë. Shäryëmi eni, pjãy Sbö poshrëk ga pjl̈ú wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pjir ga shji to Betel kjokyo. Eshko ga tja akkwo töng dl̈uw ëng kjing go kjókshko, Sbö poshrëkkl̈o. Tja jek shäng song, woydëshko ga tja kjimtara. Tja jëk kjone pogo ga e shäng bor tjok ĩyado» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kuya l̈ok ga ba sböpga jyãgl̈o l̈i twara ba kong dret, ba kwomgwo iokl̈o söya l̈ok l̈i twara ba kong bakoe. Eshko ga kjor jong kjl̈ara kësbang, Siquén kjokyo zl̈ong, ga l̇l̇ëbo twara ba kong kës l̈i pjl̈ona Jacobdë uunkong kl̈ung roshko, kjor l̈i dorko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Opshino jek l̈öngshko ga kjok eshko sopga iara Sbörë beno l̈öng kjok bangkjrë arae. E kjĩshko ga Jacob wl̈o irpjana l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Eshko ga öötong l̈öng Luz kjokyo, e ko Betel bakoe. E Canaán kjokyo obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Eshko ga Jacob akkwo töno dl̈uw ëng kjing go kjókshko, Sbö poshrëkkl̈o. Ba shjiy töyweshko ga Sbö weno shäng ba kong eshko kjĩshko ga kjok eshko kowara beno El Betel. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Eshko ga Rebeca daga Débora l̈i wol̈ono, ga jnena l̈ok kl̈ung roshko, kjor jong kësbang eshko l̈i dirko, ga kjok eshko kowara Jacobdë beno Alón Bacut. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kjok eshko ga Sbö weno shäng ba kong obi, ga tjl̈ẽno beno pjl̈ú ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Tjl̈ẽ ga «Pja ko Jacob, gueniyo pja ko eni ame. Eeri jek l̈ëkong ga pja ko ber Israel shara» l̈e. Koiara eni pjir ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","tjl̈ẽ ba kong obi ga «Tja ëre Sbö, l̇l̇ëye shäryër woydë l̈i shäryër ga pjl̈úe. Pjãy wapga wenzong ara, bop tjëyo tek ber bop irgo l̈i shdär ber träk l̇l̇ëm wl̈o. Epga ber l̈öng tjëyoga obl̈ë obl̈ë, ga tjë jĩkong ber l̈öng tjëyo kjrinaso. E tjrëko pjl̈upga wen. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kjok tworor Abraham, Isaac kong l̈i, e twër bop kong, bop tjëyo tek ber bop irgo l̈i kong bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","L̈ara eni pjir ga to ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Eshko ga Jacob ak kjrono kjwara, poyona, ga iara beno jong kojong, Sbö tjl̈ẽno ba kong l̈ishko. E irgo ga ak l̈i kjing go kjyo tyara, kjil̇l̇gwo bo dyo tyara bako, e ber jong dboy Sbö kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ga kjok eshko kowara beno Betel. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","E irgo ga to eshko dwayo. Ga Efrata kjokyo beno pjola obishko ga Raquel shara swl̈orë, gueniyo wl̈oshko tjeng ga ä, beno buk owa. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Swl̈o arashko, chida buk döröshko ga ba kjimtaga tjl̈ẽ ba kong ga «L̇l̇ëye bangkjrëp l̇l̇ëme. Buk domer obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Raquel beno buk ba l̇l̇ëmdo, ga tjl̈ẽ ga «Koiër Benoni» l̈e. Gueniyo koiara ba datarë Benjamín shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Eni ga Raquel wol̈ono, ga jnenaba beno buk irbo jek jong äär Efrata kjokyo l̈i sor go. Efrata kjokyo, e ko Belén bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ba sak l̈i kjing go Jacob ak kojono beno jong kjwara, ba jyãgl̈o. Eerishko ga jong eshko wẽl̈ë obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","E irgo ga Jacob wl̈o irbo shano to öötong l̈öng Migdal Edar kjokyo pjl̈or kal̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","L̈öng kjok eshko wopro ga Rubén öör pono ba data boy obl̈ë ba parkaga wl̈eniyo ko Bilhá tjok. Miydara ba datarë ga iirkono tira l̇l̇ëme. Jacob wapga domerga dogl̈o sak kjwara kjingsho pjök (12). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea tjok, e Jacob wa domer bäm ĩyo Rubén, Simeón, Leví, Judá, Isacar, Zabulón. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raquel tjok, e José, Benjamín. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raquel parkaga Bilhá tjok, e Dan, Neftalí. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea parkaga Zilpá tjok, e Gad, Aser. Ëre Jacob wapga weno tjeng Padán Aram kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Era Jacob öör ba data Isaac ĩk, Abraham, Isaac dënashko ga l̈öngshko l̈i kjokyo ko Mamré. Mamré kjokyo, e ko Arbá, ko Hebrón bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac l̈u ĩno öötong sak dbäw kjingsho sak kjwongshko (180) ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Tjl̈abl̈ashko ga wol̈ono, ga töno ba pjeyo shinmoga tek dënashko so tjok. Eshko ga iara ba wapga Esaú, Jacobdë beno buk sakshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ëre Esaú tjëyo tek beno ba irgo. Esaú, e kowëba Edom bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Esaú orkwosmono wal̈ëga Canaán so dogl̈o mya tjok. Epga ko Ada, Aholibama, Basemat. Ba boy Ada, e Elón wa. Elón, e Het tjëyo. Ba boy Aholibama, e Aná wa. Aná, e Zibeón wa. Zibeón, e heveo. Ba boy Basemat, e Ismael wa, Nebayot dor bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","5","Esaú sök Canaán kjokyoshko ga wapga tjeng dogl̈o shkëng (5). Ada wa buk kjl̈ara domer ko Elifaz. Basemat wa buk kjl̈ara domer ko Reuel. Aholibama wapga tjeng dogl̈o mya domer ko Jeús, Jalán, Coré. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Esaú, Jacob, e dbur ara, öng ara. Ba kjok l̈öngshko l̈i öng ara anmoyõ, ga ba öng dl̈i pjitënge. E kjĩshko ga ber l̈öng pjöyĩkong ga äe. Eni ga Esaú to kjok shto obl̈ë, ba l̈ëng sökshko dwayo. Ba boyga, ba wapga, ba parkagaga, ba öng, ba l̇l̇ëbo uunkong wl̈ẽna Canaán kjokyo l̈i, e söra jek uunkong ba tjok, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ga öötong Seir kjokyo dl̈up shwo l̈ëkong, ga beno l̈öng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","14","Esaú, e Edom tjëyoga data. E beno l̈öng Seir kjokyo dl̈up shwo l̈ëkong. Ëre ba tjëyo tek beno ba irgo. Esaú boyga dogl̈o mya: Ada, Basemat, Aholibama. Ada tjok ga Esaú wa domer kjl̈ara ko Elifaz. Elifaz, e wapga domerga ko eni: Temán, Omar, Zefo, Gatán, Cenaz. Elifaz boy obl̈ë ba parkaga wl̈eniyo ko Timná tjok ga wa domer kjl̈ara ko Amalec. Basemat tjok ga Esaú wa domer kjl̈ara ko Reuel. Reuel, e wapga domerga ko eni: Najat, Zera, Sama, Mizá. Aholibama tjok ga Esaú wapga domerga dogl̈o mya: Jeús, Jalán, Coré. Aholibama, e Aná wa. Aná, e Zibeón wa. Zibeón, e heveo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esaú tjëyo tek beno ba irgo l̈i tjëyoga ko eni. Esaú wa Ada tjok Elifaz l̈i tjëyo tek ber ba irgo l̈i tjëyoga ëre: Temán, Omar, Zefo, Cenaz, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatán, Amalec. Epga l̈öng Edom kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esaú wa Basemat tjok Reuel l̈i tjëyo tek beno ba irgo l̈i tjëyoga ëre: Najat, Zera, Sama, Mizá. Epga l̈öng Edom kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esaú wapga Aholibama tjok l̈i tjëyo tek beno ba irgo l̈i tjëyoga ëre: Jeús, Jalán, Coré. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Esaú tjëyo tek beno ba irgo l̈i tjëyoga, e beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Esaú öötong sök kjok eshkoshko ga nopga l̈öng eshko ko horeoga. Epga domer ko Seir l̈i tjëyo tek beno ba irgo. Seir tjëyoga ëre: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer, Disán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotán, e wapga domerga ko eni: Horí, Homán. Lotán, e dor ko Timná. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal, e wapga domerga ko eni: Alván, Manajat, Ebal, Sefó, Onam. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeón, e wapga domerga ko eni: Ayá, Aná. Pjl̈ara ga Aná, e shäng ba data öng dëshko ga di bäng wl̈ẽna kjrina kjok dogro no l̇l̇ëmshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aná, e wa domer kjl̈ara ko Disón, wa wal̈ë kjl̈ara ko Aholibama. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disón, e wapga domerga ko eni: Hemdán, Esbán, Itrán, Querán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer, e wapga domerga ko eni: Bilán, Zaván, Acán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disán, e wapga domerga ko eni: Uz, Arán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horeo, e tjëyoga ko eni: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer, Disán. Epga l̈öng Seir kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israel tjëyoga pjl̈upga l̇l̇ëm obishko ga Edom so pjl̈upga, e ëre: ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, e Dinaba so, Beor wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela wol̈onoshko ga beno Jobab, e Bosra so, Zera wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab wol̈onoshko ga beno Jusán, e Temán so. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Jusán wol̈onoshko ga beno Hadad, e Avit so, Bedad wa. Nopga Madián so zana Bedaddë Moab kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad wol̈onoshko ga beno Samla, e Masreca so. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla wol̈onoshko ga beno Saúl, e Rejobot so. Rejobot kjokyo, e buk Éufrates diyo gomyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saúl wol̈onoshko ga beno Baal Janán, e Acbor wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal Janán wol̈onoshko ga beno Hadar, e Pau so, boy ko Mehitabel. Mehitabel, e mekë ko Matred. Matred, e mekë ko Mezab. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Edom tjëyoga ko eni: Timná, Alvá, Jetet, Aholibama, Elá, Pinón, Cenaz, Temán, Mibzar, Magdiel, Iram. Epga beno l̈öng kjok kjrina kjrina baĩya om go. Esaú beno Edom tjëyoga uunkong data. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob beno sök Canaán kjokyo, dëna ba data sökshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ëre Jacob pjeyoga to tek jong sorë, e l̈anyo. José l̈u pjl̈ogl̈o sak kjwara kjingsho kjäkshko (17) ga shäng öng ushko so dë ba shjiyga tjok. Ba shjiyga mekë ko Bilhá, Zilpá, ba data boyga obl̈ë ba parkagaga wl̈eniyo. L̇l̇ëbo shärye ba shjiygarë owa l̈i roy söya tjwe, l̈e ba data kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","José bukshko ga Jacob tjl̈abl̈a kuzong ga José woyde ba datarë ara, ba wapga obl̈ë kjinmo. Ga kong shwong sera kara wol̈ësowae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ĩya ba shjiygarë ga woyde ba datarë ara ba kjinmo ga ĩywa l̈ok shjiktëng, tjl̈ẽ l̈ok ba kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Pjl̈ara ga José yoĩno, ga tjl̈ẽ ba shjiyga kong ga «Tja yoĩno l̇l̇ë l̈ër bomi kong. ¡Tja kuzĩa! Tja yoĩk ga shji uunkong öötong l̈öng bi pakshko ga dwl̈a bo doyo diy l̈öng kjl̈ara ĩ kjrina kjrinae. Ĩn ga botoya kojono beno jong bek, ga bomipjõy tek l̈ok botoya zl̈ong, ga kjujono ba kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kuya l̈ok ga ĩywa l̈ok shjiktëng ara anmoyõ, ga tjl̈ẽ ba kong ga «¿Pja wotjl̈ĩk ga pja ber borwa pjl̈uyo, tjawa ichëp wl̈o l̈ëpde?» l̈e. Eni ga woydara l̈ok l̇l̇ëm jek këgong ara anmoyõ, yoĩno l̈i kjĩshko, l̈ara ba kong l̈i kjĩshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","E irgo ga José yoĩno jek pjl̈ara obi, ga tjl̈ẽ ba shjiyga kong ga «Tja yoĩk ga dl̈o, mok, dbala kop sak kjwara kjingsho kjwara (11) kjujono bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","L̈ara ba data, ba shjiyga kongshko ga kuya ba datarë ga iirkorgö, ga tjl̈ẽ ba kong dbo go ga «¿Pja yoĩno, e l̇l̇ë l̈okl̈oro? ¿Tja, bop mekë, bop shjiyga, tjawa tjwe l̈öng bop zl̈ong, kjujong bop kong wl̈o l̈ëpde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ga ĩywa ba shjiygarë shjiktëng erä. Gueniyo yoĩno l̈i woyotjl̈ĩya ba datarë arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Dbar kjwara ga Jacob öng l̈i söra José shjiygarë jek Siquén kjokyo, kjl̈o sho tjok l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Eshko ga Jacob tjl̈ẽ José kong ga «Bop shjiyga l̈öng öng dë Siquén kjokyo. E kjĩshko ga pja nom ba ĩk eshko» l̈e. Kuya ga «Jöl̈ö. Tja to ĩk» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kuya ga tjl̈ẽ ba kong ga «Pja nome. Bop shjiyga l̈öng sorë, bor öng l̈öng sorë ĩp yõtso, ga roy söp bor kong iröng obi» l̈e ba kong, ga ichara jek Hebrón sdamyo l̈ëkong dwayo. Öötong shäng Siquén kjokyoshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","jeno shäng ey. Eni ga domer weno shäng kjl̈ara, ga tjl̈ẽ ba kong ga «¿L̇l̇ëye wl̈ẽpdë shängdo?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","«Tja to shäng bor shjiyga wl̈ẽk. ¿L̈öng öng dë kjone l̈ëp bor kong ga buere?» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kuya ga tjl̈ẽ ba kong ga «Opshino to tjän. Gueniyo kuror ga “Shji to Dotán kjokyo” l̈ara l̈ok ëng kong yẽ» l̈e. Kuya ga jek ba shjiyga irgo, ga wl̈ẽya l̈öng Dotán kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ĩya ba shjiygarë pjola dwayo ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","tjl̈ẽ ëng kong ga «¡Ĩzĩa! Yoĩga döröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kjweri kjwe zröy. Pjir ga dbuy di bäng roy, ga uara äya kjl̈oshko sorë l̈ëy eni. Eshko ga l̇l̇ëye wen ba yo l̈i tjok ĩy» l̈e l̈ok ëng kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kuya ba shjiy Rubéndë ga ba l̈ëng wl̈ike l̈ara. Ga tjl̈ẽ ba l̈ëmga kong ga «Zröy l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Shji srëng kwong l̇l̇ëme. Shji or ië ba go l̇l̇ëm bakoe. Dbuzĩ jer di bapkwo pjl̈ëbgwoyo kjwe roy dey» l̈e. Wotjl̈ĩno ga döni ga shiya om go ey dwayo, ga söya jek äär ba data shwoy iröng obi l̈ara. L̈ara ba l̈ëmga kong eni e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","E irgo ga José öötong shäng ba shjiyga l̈öngshko ga ba shwong pjang ba do go wol̈ësowa l̈i skwara l̈ok ba shjiryo, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ga ba l̈ëng l̈i shara l̈ok, dbura jer di bapkwo pjl̈ëbgwoyo jong eshko l̈i roshko. Eshko dbaryo ga roy di drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","E irgo ga sirkeno l̈öng ië. Eshko ga ĩya l̈ok ga nopga tek l̈öng träk l̇l̇ëme. Epga Ismael tjëyoga tek Galaad kjokyo dwayo jongya Egipto kjokyo. Dwl̈o poshtikkl̈o l̈õ pjl̈ëbl̈ë söra obl̈ë obl̈ë, ba öng l̇l̇ëbo shgokl̈o këskës kjing go, dl̈i mokyo söra bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Eni ga Judá tjl̈ẽ ba pjeyoga kong ga «Shji wotjl̈ĩk bi kjl̈ara zrök. E irgo ga jney ber miydëba l̇l̇ëm wl̈o. ¿L̇l̇ëye shjiy e go? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Bi kjl̈ara obi kjĩy ga zröy l̇l̇ëme. Soyney Ismael tjëyoga tek l̈öng wl̈e kong dey» l̈e. Kuya l̈ok ga «Pjl̈úe» l̈e l̈ok ëng kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","L̇l̇ëbo soynega l̈i öötong l̈öng eshko ga José shira ba shjiygarë di bapkwo pjl̈ëbgwoyo l̈i roy dwayo, ga soynena Ismael tjëyoga l̈i kong, dbur sho pjl̈ubl̈ún kjwo sak pjök (20) ãska, ga söra l̈ok to Egipto kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubén tjwe iröng di bapkwo pjl̈ëbgwoyo jong l̈ishko ga José wl̈ẽya ga drete. Eni ga sl̈atong ara, ga ba shwong dwl̈ëkza tjã tjã erä, woydë ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Jek äär ba l̈ëmga tjeng l̈ishko ga tjl̈ẽ ba kong ga «Bi l̈ëng shäng ame. ¿Era l̇l̇ëye shäryër?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Eni ga öng zröra l̈ok kjl̈ara, ga José shwong l̈i kjrara, shtira öng srëng l̈i go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Pjir ga söra l̈ok jek ba data kong, ga tjl̈ẽ ba kong ga «Shwong ëre wl̈ẽnorwa. ¿Bop wa ĩre? ¡Ĩzong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ĩya ga tjl̈ẽ ba kong ga «Kjwe bor wa shwong jl̈õe. Zröra äya kjl̈oshko sorë, ga uarae» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Eni ga Jacob ba shwong dwl̈ëkza tjã tjã, ga shwong pjuno obl̈ë sopok wl̈o, ga ba wa wol̈ono ga sl̈oywara dbar kop ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Data sl̈ar ëë ga wojeya ba wapga uunkongdë, gueniyo wojer l̇l̇ëme. Sl̈ar ëë ba wa kjĩshko, ga tjl̈ẽ ga «Tja wojer l̇l̇ëme. Woyoshrër ĩyado. Tja wol̈onoshko ga pjir ber eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","E wopro ga José söra Ismael tjëyogarë öötong l̈öng Egipto kjokyo. Eshko ga domer shäng kjl̈ara ko Potifar. E Egipto so pjl̈uyo u daga kägäyo. Ga José soynena l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Eshkoshko ga Judá opshino ba pjeyoga shwoy dwayo, öötong sök Adulam kjokyo. Eshko ga domer shäng kjl̈ara ko Hirá, e Adulam so. Ga Judá beno sök ba ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Domer shäng kjl̈ara eshko obi ko Súaj, e Canaán so. Judá orkwosmono ba wa tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","E irgo ga ba boy beno shäng kjl̈araso l̇l̇ëme. Wa buk kjl̈ara domer, ga koiara Er. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","E irgo ga beno jek shäng kjl̈araso l̇l̇ëm obi. Wa buk kjl̈ara domer obi, ga koiara Onán. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","E irgo ga beno shäng kjl̈araso l̇l̇ëm jek obi. Wa buk kjl̈ara domer obi, ga koiara Selá. Bukshko ga Judá sök Quezib kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judá wapga kunoe. Eshko ga wal̈ë shäng kjl̈ara ko Tamar. Judá wa domer bäm ĩyo Er l̈i orkwosmona Judárë ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, e jëk shäng owa Jehová bokso. E kjĩshko ga zrörae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Eshko ga Judá tjl̈ẽ Onán kong ga «Bop shjiy wol̈ono, ga wapga beno l̇l̇ëme. Wa tjeng kjl̈ara bop shjiy ĩ wl̈o ga pja orkwosmok Tamar tjok kjl̈uwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Miyde Onándë ga wapga tjengshko ga epga ber baĩya l̇l̇ëm kuzong ga pë ba tjok pjl̈obi go ga opdë Tamar ber shäng kjl̈araso l̇l̇ëm wl̈o, wapga tjeng ba shjiy kong l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Jehová bokshto ga Onán l̇l̇ëbo owa shäryono. E kjĩshko ga zröra bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Eshko ga Judá tjl̈ẽ ba pjl̈aydo l̈i kong ga «Pja nom bop data ushko iröng obi, gueniyo pja orkwosmok l̇l̇ëm, bor wa Selá öötong këguë ba l̈uyo go guing. Eshko ga orkwosmok bop tjok ga pjl̈úe» l̈e. (Woyotjl̈ĩya Judárë ga Selá wol̈on ba shjiyga dik bakoe l̈e.) Eni ga Tamar to jek beno sök ba data ushko iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","L̈u to jek kop ara ga Judá boy wol̈onoe. Soyopora pjir ga jekdo shäng Timnat kjokyo, ba kjl̈ara Hirá tjok, ba öng zok shtagaga l̈öng l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Judá jek Timnat kjokyo, ba öng zok shtë wl̈o l̈i miydara ba pjl̈aydorë pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Judá wa Selá öötong kësbang ëmdë ga orkwosmoyde ba tjok l̇l̇ëm obi. E kjĩshko ga ba syã shwongyo skwara, doyono obl̈ë, kä kjingono pjir, ë miydëba l̇l̇ëm wl̈o. Pjir ga jek l̇l̇et sirkeno sök Enayin kjokyo soyozl̈ong, e ber buk irbo jek jong äär Timnat kjokyo l̈i sor go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judá jek shäng irbo bäng ga ĩya ga wal̈ë sök eshko kjl̈ara. Wotjl̈ĩno ga wal̈ë to shäng opsoynek domerga obl̈ë obl̈ë kong wl̈eniyo l̈ara, kä kjingono pjir kjĩy. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Wal̈ë, e ba pjl̈aydo miydara l̇l̇ëm kjĩshko ga jek öötong shäng ba shwoy ga tjl̈ẽ ba kong ga «¿Tja pë bop tjok ga buere?» «¿Pja pë bor tjok wl̈eni ga ãska l̇l̇ëye twëp bor kong?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kuya ga tjl̈ẽ ba kong ga «Shwl̈ing ushko so ichër tjwe bop kong kjl̈ara» l̈e. Kuya ga tjl̈ẽ ba kong ga «Jöl̈ö. Gueniyo woydër ga l̇l̇ëbo twëp kjrina ber tjeng bor tjok, öng l̈ëp l̈i ichorop shrono bor kong guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kuya ga tjl̈ẽ ba kong ga «¿L̇l̇ëye woydëp?» «Bop ko jyãgl̈o pjang bop bëngshko ba kjiyo go kjwe twos bor kong. Bop kjorkung kjwe twos bor kong bakoe» l̈e. Kuya ga twara ba kong, pono ba tjok, ga beno shäng kjl̈araso l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","E irgo ga Tamar to ba ushko, ga ba kä kjingokl̈o l̈i kjara, ba syã shwongyo l̈i pjuna jek iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","E irgo ga öng ichara Judárë jek ba kjl̈ara Adulam so l̈i tjok, l̇l̇ëbo iara beno tjeng wal̈ë tjok l̈i tek twe ba kong iröng wl̈o. Gueniyo wal̈ë l̈i wl̈ẽna shäng eshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Eni ga kjakrokara domerga eshko so kong ga «Wal̈ë Enayin so shäng kjl̈ara, to shäng opsoynek domerga obl̈ë obl̈ë kong wl̈eniyo. L̈unashko ga sök irbo ëre sor go. ¿E kwonl̇l̇o?» «Wal̈ë eniyo jũshko drete» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Eni ga Hirá sano jek Judá shwoy iröng obi, ga tjl̈ẽ ba kong ga «Wal̈ë l̈i wl̈ẽnor l̇l̇ëme. Domerga eshko so tjl̈ẽno bor kong ga “Wal̈ë eniyo jũshko drete” l̈ara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kuya ga tjl̈ẽ ba kong ga «Eni ga ber tjeng wẽyẽ ba tjok, shji joywëba l̇l̇ëm wl̈o. Miydëp ga shwl̈ing ushko so ichoror jek ba kong, gueniyo wl̈ẽnop l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Öötong mogl̈o mya dik ga oba tjl̈ẽ Judá kong ga «Bop pjl̈aydo Tamar opsoyneno domerga obl̈ë obl̈ë kong, ga beno shäng kjl̈araso l̇l̇ëme» l̈e. Roy kuya ga tjl̈ẽ ga «¡Shizĩ ey dwayo, ga suzĩa!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tamar shikoba l̈ëbashko ga roy ichara ba kegue l̈i kong, tjl̈ẽ ga «Pja tjl̈ẽ bor kegue kong ga “L̇l̇ëbo tjeng bor tjok ëre sogo ë ga tja shäng kjl̈araso l̇l̇ëm ëre baĩya. Ko jyãgl̈o ëre ba kjiyo go ĩs yõtso, sogo ë miydëp wl̈o. Kjorkung ëre ĩs bakoe” l̈ëp ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Roy söra öötong, l̈ara Judá kong. Ba l̇l̇ëbo l̈i ĩya ga tjl̈ẽ ga «Tamar l̇l̇ëbo shäryono bëye. L̇l̇ëbo owa l̈i shäryaga tjarë, bor wa Selá orkwosmonor ba tjok l̇l̇ëm kjĩy» l̈e. Eshko jek l̈ëkong ga pono ba tjok ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar wl̈oshko tjeng dbaryoshko ga wapga tjeng domerga do pjök jekdo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tjeng döröshko ga chida kjl̈ara orkwo shino bäm go. Eshko ga ba kjimtaga trer srëzrën pjrino ba orkwo go, ga tjl̈ẽ ga «Ëre buk bäm go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Gueniyo orkwo shino jem iröng ga ba kjl̈arawa orkwo pjrik l̇l̇ëm l̈i buk bäm go. Eshko ga ba kjimtaga tjl̈ẽ ba kong ga «¿Pja buk bäm go sorë?» l̈e. E kjĩshko ga koiara Fares. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","E irgo ga orkwo pjrira trer srëzrën go l̈i bukshko ga koiara Zera, ba trer srëzrën l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Eshkoshko ga José söraba öötong Egipto kjokyo. Eshko ga domer shäng kjl̈ara ko Potifar. E Egipto so pjl̈uyo u daga kägäyo. José tjwl̈ẽga Ismael tjëyoga kong l̈i e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","3","José sök ba ushkoshko ga Jehová shäng ba tjok, ga kjimtara ara. L̇l̇ëbo beno ba kong pjl̈ú erä, ga miyde Potifardë pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","E kjĩshko ga wotjl̈ĩno pjl̈ú ba kjĩshko, ga kong pak wl̈ẽna ba kjimtaga, iara beno shäng ba l̇l̇ëbo tjeng kës ba ushko l̈i daga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Dbar eshko jek l̈ëkong ga José kjĩshko ga Potifar kjimtara Jehovárë ara. Eni ga l̇l̇ëbo uunkong beno pjl̈ú ba ushko, ba kjokshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Eni ga Potifar, ba l̇l̇ëbo tjeng kës l̈i iara beno tjeng José wl̈oshko. E kjĩshko ga l̇l̇ëbo obl̈ë woyotjl̈ĩya l̇l̇ëm, ba dl̈i eröe. José, e domer wol̈ësoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ĩya Potifar boydë ga worye kjër, ga tjl̈ẽ ba kong ga «Pja pë bor tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kuya ga tjl̈ẽ ba kong ga «¡L̇l̇ëme! ¡Tja kuzong! L̇l̇ëbo tjeng kës iara bor pjl̈urë beno tjeng bor wl̈oshko. Tja shäng na ga woydë l̇l̇ë kjĩshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ëye tjwl̈õ ëreshko bor kjinmo drete. Bor pjl̈u, tja kong l̇l̇ëye wl̈ikayde l̇l̇ëm, pja erö, pja ba boy kjĩshko. E kjĩshko ga l̇l̇ëbo owa shäryër wl̈eni Sbö bokso ga äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Roke wal̈ë l̈irë ba kong dbar kjwobi go ëmdë ga jl̈õ l̈ara l̇l̇ëm, to jek öötong ba zl̈ong bäng l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Dbar kjwara ga José opzrëno jek u roshko, ba pak shäryë wl̈o. E dbaryo ga ëye ushko drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","E wopro ga shakza wal̈ë l̈irë pjä ba shwong go, ga tjl̈ẽ ba kong ga «Pja pë bor tjok» l̈e ba kong. Gueniyo José opdös wl̈es, opshino jek zron ĩ, ga ba shwong beno tjeng wal̈ë l̈i wl̈oshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ĩya ga José opshinoshko ga ba shwong beno tjeng ba wl̈oshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ba parkagaga rokara ba shwoy, ga tjl̈ẽ ba kong dbo go ga «Hebreo söra bor l̈anmarë l̈i, shji ie woydë ber tjwl̈õ l̇l̇ëm oba bokso. Opzrëno jek bor kjër roshko, pë bor tjok dbo go wl̈o l̈ara. Gueniyo öö l̈oror jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kuya ga opshino jek zron ĩ, ba shwongda beno tjeng bor wl̈oshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","E irgo ga José shwong l̈i jnena tjeng, ba l̈anma shrono ushko guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Shrono ga l̈ara jek ba kong obi. Tjl̈ẽ ga «Bop parkaga hebreo sörop jũshko l̈i opzrëno jek bor kjër roshko, pë bor tjok dbo go wl̈o l̈ara, tja ber tjwl̈õ l̇l̇ëm oba bokso wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Gueniyo öö l̈oror jl̈õkoyo kjĩshko ga opshino jek zron ĩ, ba shwongda beno tjeng bor wl̈oshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kuya ga iirkono ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Eni ga ba parkagaga ichara José shak, ie l̈ok ber no shdũzl̈ong uyo roshko wl̈o. Ga iara beno sök eshko, nopga shduna pjl̈urë tjeng l̈ishko. José sök eshkoshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Jehová shäng ba tjok, ga kjimtara ara. Jehová kjĩshko ga no shdũzl̈ong uyo daga wotjl̈ĩno pjl̈ú José tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ga iara beno shäng no shdung l̈öng l̈i daga. L̇l̇ëye shäryëba eshko dö ga ichaga shäng erë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Jehová shäng José tjok, ga kjimtara ara. E kjĩshko ga l̇l̇ëbo shärye kës l̈i beno pjl̈úe. E kjĩshko ga José parkë shäng sorë woyotjl̈ĩya no shdũzl̈ong uyo daga l̈irë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Eshko ga Egipto so pjl̈uyo l̈i parkagaga l̈öng do pjök. Kjl̈ara, e di iokl̈o söga ba kong, kjl̈ara, e ba pjl̈ung shosho suga. Pjl̈ara ga epga diktong kjĩshko ga pjl̈u iirkono ba kong, ichara jek l̈öng ba u daga kägäyo l̈i ushko, bängzaya no shdũzl̈ong uyo roshko wl̈o, José shdung shäng l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","José iara Egipto so pjl̈uyo u daga kägäyo l̈irë beno shäng domerga l̈i dë. Shduna beno l̈öng dbar kop ara eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Shkër kjwara ga domerga do pjök l̈i yoĩno l̈ok obl̈ë obl̈ë, e l̈okl̈o dö l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Wẽshko ga ĩya Josérë tjwe kjok shröngto ga wl̈ẽya bë l̈öng woydë arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Eni ga tjl̈ẽ ba kong ga «¿Pjãy woydë ara ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","«Tjawa yoĩno, ga pjl̈ol̇l̇gwega ërë borwa kong l̇l̇ëme. Tjawa woydë ara e kjĩshko» l̈e l̈ok ba kong. Kuya ga tjl̈ẽ ba kong ga «Pjãy yoĩno l̈i l̇l̇ë l̈ozĩ bor kong. Shji yoĩk l̈i l̇l̇ë l̈okl̈o miyde Sbörë pjire. Ga tja kjimte wl̈eni ga l̈ër bomi kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Eni ga tjl̈apga di iokl̈o söga l̈i tjl̈ẽ ba kong ga «Tja yoĩk ga kjil̇l̇gwo jong sok kjwara, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","l̇l̇iywono l̈ok mya. Wãrbo wen mite, l̈ong tyë, e irgo ga ba l̈onggwo opkjl̈opswë ber bo kwi tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Eshko ga pjl̈u di iokl̈o l̈i tjeng bor wl̈oshko. Kjil̇l̇gwo bo l̈i kjrër ga l̇l̇rur shäng ba di iokl̈o l̈i roshko. E irgo ga twër pjl̈u l̈i wl̈oshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kuya ga tjl̈ẽ ba kong ga «Pja yoĩno l̈i l̇l̇ë l̈okl̈o l̈ër bop kong. Kjil̇l̇gwo sogwo l̇l̇iywono mya l̈i, e dbargwo mya l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dbargwo mya go ga pja shiya pjl̈urë na dwayo, pja ie ber shäng parkë bop shtoy iröng obi, ba di iokl̈o sörop ba kong dämär sorë ga söp ba kong ber shäng eni obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Shäryë enishko ga tja woyoshrëba. Pja tjl̈ẽ pjl̈u kong bor kjĩshko, tja shiya na dwayo wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tja ëre l̈ũyotkaraba tek hebreoga kjokyo dwayo. Tja kjwe shäng ëreshko l̇l̇ëm gueniyo. L̇l̇ëye owa shäryoror l̇l̇ëm, tja shäng jũshko wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kuya tjl̈apga pjl̈ung shosho suga l̈irë ga ba kjl̈ara yoĩno l̈i pjl̈ol̇l̇gwera beno pjl̈ú ba kong ga tjl̈ẽ José kong ga «Tjara yoĩk ga shing kjwo mya, roshko pjl̈ung shosho suk pjir, iak tjeng ëng kjing ëng kjing bor dl̈u kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Shing tjeng kjwara ba kjing go l̈i, roshko pjl̈ëbl̈ë sho tjeng obl̈ë obl̈ë pjl̈u kong, gueniyo ue sënwarë tjwe jonge» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kuya ga tjl̈ẽ ba kong ga «Pja yoĩno l̈i l̇l̇ë l̈okl̈o l̈ër bop kong. Shing kjwo mya l̈i, e dbargwo mya l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dbargwo mya go ga pja shiya pjl̈urë na dwayo. Ba parkagaga iche bop kä zë tas, ga bop doyora ie l̈ok ber pjang kjor go. Eshko ga bop sho ue l̈ä̃rë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Öötong dbargwo mya ga pjl̈u sök ië ba pjl̈oyoga tjok, ba dbar shrëkkl̈o. Eshko ga ba parkagaga ichara ba di iokl̈o söga l̈i shik, ba pjl̈ung shosho suga l̈i shik bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Di iokl̈o söga l̈i iara beno shäng parkë ba shtoy iröng obi, ba di iokl̈o söra ba kong dämär sorë ga söya ba kong eni obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","23","Gueniyo pjl̈ung shosho suga l̈ira, ba parkagaga ichara ba zrök. L̈ara Josérë ba kong sorë l̈i shäryono uunkong eni ëmdë ga José woyoshrara pjl̈u di iokl̈o söga l̈irë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","L̈u pjl̈ogl̈o pjök irgo ga shkër kjwara ga Egipto so pjl̈uyo yoĩk ga shäng Nilo diyo kjako. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ĩya ga sögl̈a wen tëm di roy dwayo dogl̈o kjäk (7), wol̈ëso, kjl̈o dike. Opshino ga jek tjeng kjl̈o sho uë jonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","E irgo ga sögl̈a wen tëm di roy dwayo dogl̈o kjäk (7) obi, kjl̈o owa, sl̈osl̈oe. Tëm shrono tjeng kjl̈o dik l̈i zl̈ong bäng, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ga döni ga sögl̈a kjl̈o dik l̈i uara sögl̈a sl̈osl̈o l̈irë drete. Eshko ga pjl̈u l̈i wol̇l̇eno buk ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","pono jek obi. Ga yoĩno jek obi. Ĩya ga dwl̈a weno jong sok kjl̈ara, boryono l̈ok tjung wol̈ëso, pjl̈ogl̈o kjäk (7). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","E irgo ga weno sok kjl̈ara obi, boryono l̈ok pjl̈ogl̈o kjäk (7) obi, gueniyo owa, pira pjl̈uk kjl̈ikyorë beno kl̈uktënge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ga bo pjl̈ú l̈i uara bo owa l̈irë drete. Eshko ga pjl̈u wol̇l̇enoshko ga «Tja buk yoĩkdo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Wẽshko kjok shröngto ga woyotjl̈ĩya ara kuzong ga ba parkagaga ichara ybi l̈öng kjl̈obi kjok eshko l̈i rokë, nopga kjok miydë ara l̈i rokë bakoe. Shrono l̈ok ga yoĩno l̇l̇ë l̈ara ba kong, gueniyo pjl̈ol̇l̇gwega ërë ba kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Eni ga ba di iokl̈o söga l̈i tjl̈ẽ ba kong ga «Woyoshrër kjl̈ay ga tja opshäryono owa. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kjupäbäshko ga pja iirkono pjl̈ung shosho suga kong, bor kong bakoe. Eshko ga tjawa ichorop bop u daga kägäyo ushko, tjawa bängzaya no shdũzl̈ong uyo roshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Shkër kjwara ga tjawa yoĩno obl̈ë obl̈ë, e l̈okl̈o dö l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tjawa l̈öngshko ga domer shäng kjl̈ara hebreo. E bop u daga kägäyo parkaga. Tjawa yoĩno l̈i l̈ororwa ba kong ga pjl̈ol̇l̇gwera borwa kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","L̈ara borwa kong sorë ga shäryono eni. Tjara shrono iröng bor pakshko, bor kjl̈arara zröra l̈oke» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kuya ga no ichara José rokë, ga shira no shdũzl̈ong uyo roshko dwayo jekdo. José kä shtono, shwong kjl̈opswono, doyono pjir ga jek pjl̈u shwoy. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Eshko ga pjl̈u tjl̈ẽ ba kong ga «Tja yoĩno pjl̈ara ga pjl̈ol̇l̇gwega ërë bor kong l̇l̇ëme. Roy kuror ga pja yo pjl̈ol̇l̇gwek pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Kuya ga tjl̈ẽ ba kong ga «E l̈ak tjarë l̇l̇ëme. Gueniyo pjl̈ol̇l̇gweya Sbörë ber pjl̈ú bop kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kuya ga tjl̈ẽ ba kong ga «Tja yoĩk ga tja shäng Nilo diyo kjako. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ĩnor ga sögl̈a wen tëm di roy dwayo dogl̈o kjäk (7), wol̈ëso, kjl̈o dike. Opshino ga jek tjeng kjl̈o sho uë jonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","E irgo ga sögl̈a wen tëm di roy dwayo dogl̈o kjäk (7) obi, kjl̈o owa, sl̈osl̈oe. Sögl̈a ĩntë Egipto kjokyo kjl̈o owa eni l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Eshko ga sögl̈a kjl̈o dik l̈i uara sögl̈a sl̈osl̈o l̈irë drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Uara pjir ëmdë ga bë l̈öng sl̈osl̈o sorë ga beno l̈öng eni obi. Eshko ga tja wol̇l̇eno buk ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","tja pono jek obi. Ga tja yoĩno jek obi. Ĩnor ga dwl̈a weno jong sok kjl̈ara, boryono l̈ok tjung wol̈ëso, pjl̈ogl̈o kjäk (7). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","E irgo ga weno sok kjl̈ara obi, boryono l̈ok pjl̈ogl̈o kjäk (7) obi, owa, pira pjl̈uk kjl̈ikyorë beno kl̈uktënge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ga bo pjl̈ú l̈i uara bo owa l̈irë drete. L̈oror ybipga kong, gueniyo l̇l̇ëye miyde l̈ok l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kuya ga tjl̈ẽ pjl̈u kong ga «Pja yoĩno pjl̈ogl̈o pjök, e l̇l̇ëbo kjrinaso l̈okl̈o döe. L̇l̇ëye shärye Sbörë bong kjönma l̈i, e l̈ayde bop kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sögl̈a dogl̈o kjäk (7) wol̈ëso l̈i, dwl̈a bo pjl̈ogl̈o kjäk (7) wol̈ëso l̈i, e l̈u pjl̈ogl̈o kjäk (7) l̈okl̈o pjöyĩkong. Pja yoĩno pjl̈ogl̈o pjök l̈i, e l̇l̇ëbo kjrinaso l̈okl̈o döe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sögl̈a dogl̈o kjäk (7) owa, sl̈osl̈o l̈i, dwl̈a bo pjl̈ogl̈o kjäk (7) owa, pira pjl̈uk kjl̈ikyorë beno kl̈uktëng l̈i, e l̈u pjl̈ogl̈o kjäk (7) pjl̈i tjwe ara l̈okl̈o pjöyĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","L̈ër shäng bop kong sorë ga shäryë eni. L̇l̇ëye shärye Sbörë bong kjönma l̈i, e l̈ayde bop kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","L̈u pjl̈ogl̈o kjäk (7) ga dl̈i wen tjwe Egipto kjokyo träk l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","E irgo ga l̈u pjl̈ogl̈o kjäk (7) obi ga pjl̈i tjwe träk l̇l̇ëme. Eshko ga dl̈i ara dbaryo woyojekoba, nopga uunkong l̈öng Egipto kjokyo pjl̈i ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Pjl̈i tjwe träk l̇l̇ëm kjĩshko ga dl̈i ara dbaryo l̈i woyoshrëba l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","L̇l̇ëye shärye Sbörë bong kjönma l̈e l̈i, e shärye jl̈õkoyo, e dörö bakoe. Pja yoĩno pjl̈ogl̈o pjök e kjĩshko. Pja yoĩno pjl̈ogl̈o pjök l̈i, e wen dörö l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","»E kjĩshko ga l̈ër bop kong ga no wl̈ẽs kjl̈ara kjok miydë ara wl̈eniyo, kjok l̇l̇gwek pjl̈ú wl̈eniyo bakoe. E ber sök Egipto sopga uunkong ichaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Era nopga ichos kjl̈öbö, dl̈i töng wl̈o. L̈u pjl̈ogl̈o kjäk (7), dl̈i tjokshko ga dl̈i wen kjöm pogo l̈i kjringgwo shkëng (5) l̈i ship kjrina, kjringgwo sak kjwara (10) l̈i ship kjring pjök, kjringgwo sak kjwara kjingsho shkëng (15) l̈i ship kjringgwo mya. Shäryëp uun eni. Ga dl̈i ëre jnep ber tjeng dboye. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","L̈u pjl̈ogl̈o kjäk (7), pjl̈i tjwe arashko ga nopga sëm e go, wol̈on l̇l̇ëm wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kuya pjl̈urë ga beno pjl̈ú ba kong, ba pjl̈oyoga kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Eni ga pjl̈u tjl̈ẽ ba kong l̈ok ga «Domer ëre go Sbö Sëya. Wl̈ẽy obl̈ë pjl̈ú kjweni drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ga tjl̈ẽ José kong ga «Ëye kjok miydë ara äär bopoya dik l̇l̇ëme. Ëye kjok l̇l̇gwek pjl̈ú bopoya dik l̇l̇ëm bakoe. Bop kjok miydë l̈i twaga Sbörë bop kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Pja iër ber sök bor parkagaga ichaga, Egipto sopga uunkong kägäyo bakoe. L̇l̇ëye l̈ëp ba kong l̈i kol̈e l̈ok. Tja pjl̈u kjĩshko ga tja tjwl̈õ ber bop kjinmo, gueniyo ëye obl̈ë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Eeri jek l̈ëkong ga pja ber sök Egipto sopga uunkong kägäyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Eshko ga pjl̈u, ba sakkwo iokl̈o goshko ba jyãgl̈o l̈i döra, iara José sakkwo go. Ga ba nopga ichara ba doyë, shwong ko pjl̈ubl̈ún, pjl̈ú tjwl̈õ ara wl̈eniyo go, ga bö pjrikkl̈o shäryak dbur sho shõyl̈ṍr go iara ba bëngshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E irgo ga ichara opyë pjl̈u jëkkl̈o roy. Jek jëk l̈öng ga ba parkagaga ichara öö l̈ë, tjl̈ẽ ga «¡Ëre José, bi kägäyo!» José iara beno sök Egipto sopga uunkong kägäyo eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","E irgo ga pjl̈u tjl̈ẽ José kong ga «Tja pjl̈u ëmdë ga l̇l̇ëye shäryëba wl̈o ga kjakroke bop kong guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Wal̈ë shäng kjl̈ara ko Asenat, e Potifera wa. Potifera, e sök On kjokyo. E syõshtaga Egipto so sböpga kong. Eshko ga José koiara pjl̈urë Zafenat Panea, ga kong Asenat twara beno ba boy. E irgo ga José roy öötong Egipto kjokyo kjok kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","José l̈u pjl̈ogl̈o sak myashko (30) ga söra l̈ok öötong sök Egipto so pjl̈uyo shwoy. Eshko ga «Tja toe» l̈e pjl̈u kong, ga opshino to ba pak shäryë Egipto kjokyo kjok kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Egipto kjokyo ga dl̈i weno ara l̈u pjl̈ogl̈o kjäk (7). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Eshkoshko ga José dl̈i töno ara Egipto kjokyo kjok kjwang jĩkong. Kjrara l̈öngshko soshko ga dl̈i töna l̈ok, ga jnena beno tjeng eshko, u roshko, shtoyo obl̈ë obl̈ë. Shtoyo kjrina kjrina l̈i kjëryo shäryak ak go pjribri kjókshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Dl̈i töna bayo ara. Shtara ame, beno ara, l̈a sho tjeng dl̈ung kjako wl̈eni kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Pjl̈i tjwe l̈e l̈i bäm go ga José wapga domerga do pjök, ba boy Asenat tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ba wa domer bäm ĩyo bukshko ga José tjl̈ẽ ga «Tja kjimtara Sbörë, l̇l̇ëbo weno bor kong owa kjöme woyojeror pjir, bor pjeyoga woyojeror bakoe. E kjĩshko ga koiër Manasés» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","E irgo ga ba l̈ëng bukshko ga José tjl̈ẽ ga «Bor kong l̇l̇ëbo weno owa ara kjok ëreshko. Jũshko ga bor kong wapga twara Sbörë» l̈e. Koiara Efraín e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","L̈u to jek kjäk (7), dl̈i ara Egipto kjokyo l̈i dbaryo pjitonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","E irgo ga pjl̈i tjwe l̈u pjl̈ogl̈o kjäk (7) l̈i soyarae. L̈ara Josérë sorë ga shäryono eni. Kjok shto obl̈ë obl̈ë dl̈i pjitong drete. Gueniyo Egipto kjokyo ga dl̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Pjl̈i shrono Egipto kjokyo ga nopga uunkong dl̈i rokono pjl̈u kong. Eshko ga pjl̈u tjl̈ẽ ba kong ga «Pjãy to José ĩk, ga l̇l̇ëye l̈e bomi kong dö l̈i shäryëmi eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Pjl̈i shdöktong Egipto kjokyo kjok kjwang jĩkongshko ga José dl̈i jneno tjengshko uyo u bäng l̈i döra, dl̈i soyneya Egipto sopga kong wl̈o, dbar jek ga pjl̈i tjwe ara anmoyõ kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kjok shto obl̈ë obl̈ë dl̈i l̇l̇ëm kjĩshko ga nopga tjwe l̈öng Egipto kjokyo, dl̈i tjwl̈ẽk José kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Egipto kjokyo dl̈i tjok l̈i miydara Jacobdë, ga tjl̈ẽ ba wapga kong ga «¿Pjãy ëng ĩk l̈öng drëng kar kar egaro? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“Egipto kjokyo dl̈i tjok” l̈araba bor kong. Eni ga pjãy nom eshko dl̈i tjwl̈ẽk, shji wol̈on pjl̈irë l̇l̇ëm wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Eni ga José shjiyga dogl̈o sak kjwara (10) l̈i to jek l̈ok Egipto kjokyo dl̈i tjwl̈ẽk. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Gueniyo ga José l̈ëng Benjamín l̈ira ichara ba datarë jek ba shjiyga tjok l̇l̇ëme. Ba data wotjl̈ĩk ga l̇l̇ëbo wen owa ba tjok kjwe l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Pjl̈i shrono ara Canaán kjokyo kjĩshko ga Jacob wapga to dl̈i tjwl̈ẽk nopga obl̈ë tjok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","José, e Egipto sopga uunkong kägäyo, shäng dl̈i l̈i soynega bakoe. E kjĩshko ga ba shjiyga öötong l̈öng ba zl̈ong ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","E José miydara ba shjiygarë l̇l̇ëme. Era ommiydono ga ba shjiyga tjwayde l̈öng. Gueniyo tjl̈ẽno ba kong oba obl̈ë wl̈eni, kjang kjange. Tjl̈ẽ ba kong ga «¿Pjãy kjone so?» «Tjawa tek Canaán kjokyo dwayo, dl̈i tjwl̈ẽga» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Eshko ga yoĩno dënashko ba shjiyga tjok sorë ga woyo tjwe kjl̈ay ba kong. Ga tjl̈ẽ ba kong ga «¿Pjãy tek l̈öng borwa kjok ëre buk sorë ĩga l̇l̇ëmdo?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","«L̇l̇ëme, Tjl̈apga. Tjawa bop parkagaga ëre. Tjawa tek l̈öng dl̈i tjwl̈ẽga. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tjawa uunkong ëre data kjl̈araso. Tjawa wotjl̈ĩk bëy eröe. Tjawa tek l̈öng l̇l̇ëbo owa shäryaga bomi kong l̇l̇ëme» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kuya ga tjl̈ẽ ba kong ga «¡Jyõ! Pjãy tek l̈öng kjok ëre buk sorë ĩga erä» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kuya l̈ok ga tjl̈ẽ ba kong obi ga «Tjl̈apga, bop parkagaga uunkong ëre epenga döe. Tjawa sak kjwara kjingsho pjök (12), data kjl̈araso. Tjawa l̈öng Canaán kjokyo. Borwa l̈ëng chirawa beno sök borwa data tjok. Kjl̈arara sök borwa tjok ame» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Gueniyo kuya ga tjl̈ẽ ba kong obi ga «Pjãy tek l̈öng borwa kjok ëre ĩk erä. L̈oror bomi kong eni tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Pjãy tjl̈ĩn ëre go. L̈ër bomi kong jl̈õkoyo pjl̈u ko go ga pjãy opshik na dwayo l̇l̇ëm, bomi l̈ëng tek söromi shrono na guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Pjãy kjl̈ara jek bomi l̈ëng wl̈okjrë, l̇l̇amo ber l̈öng na, no shdũzl̈ong uyo roshko. L̇l̇ëye l̈ëmi l̈i jl̈õre miydër e go. L̇l̇ëm ga l̈ër jl̈õkoyo ga pjãy tek l̈öng kjok ëre ĩk jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Eshko ga epga bängzara Josérë uunkong tjeng no shdũzl̈ong uyo roshko dbargwo mya. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","E irgo ga tjl̈ẽ ba kong ga «Tja Sbö bangkjrë kjĩshko ga l̇l̇ëye l̈ër bomi kong l̈i shäryëmi eni ga pjãy wol̈on l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Pjãy wotjl̈ĩk bëy jl̈õkoyo wl̈eni ga pjãy ëng wl̈ẽs kjl̈ara, ber shäng na, no shdũzl̈ong uyo roshko wl̈o, l̇l̇amo to iröng dl̈i sök bomi pjeyoga kong, ue l̈ok wl̈o, epga pjl̈i ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bomi l̈ëng tek sömi bor kong, pjãy tjl̈ẽno bëy jl̈õre miydër e go wl̈o. L̇l̇ëm ga pjãy wol̈on» l̈e. Kuya l̈ok ga tjl̈ẽ ba kong ga «Jöl̈ö» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","E irgo ga tjl̈ẽ l̈ok ëng kong ga «Shji opshäryono owa bi l̈ëng tjok. Ĩnoy shäng wosong, gueniyo kjl̈oshtono bi kongshko ga kuroy l̇l̇ëme. L̇l̇ëbo wen bi kong owa anmoyõ ëre e kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ga Rubén tjl̈ẽ ba kong ga «“L̇l̇ëye owa shäryëy bi l̈ëng kong l̇l̇ëme” l̈oror bomi kong. Gueniyo jl̈õ l̈oromi l̇l̇ëme. Wol̈ono kjĩshko ga potjwl̈ẽy l̈öng kjwl̈ëe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","José tjl̈õkwo pjl̈ol̇l̇gwega tjok kuzong ga l̈an l̈öng ëng kongshko ga tjl̈õkwo kura Josérë pjir l̈i miydara ba shjiygarë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Eshko ga José opkjono ba shjiyga l̈öngshko dwayo tjoksa, ga sl̈atong. Pjir ga tek shrono iröng obi, ga tjl̈ẽno ba kong obi. Eshko ga Simeón kjara shäng dboy, ga nopga ichara ba pjrik, ba pjeyoga bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","E irgo ga José tjl̈ẽ ba parkagaga kong ga «Domerga ëre dl̈i sho pjanggl̈o, e dl̈ĩzĩ dl̈i sho go. Ba dburwa dl̈i sho tjwl̈ẽnggl̈o l̈i iozĩ ber tjeng ba dl̈i sho pjanggl̈o roshko, kjl̈ara ĩ ĩe. Dl̈i twozĩ ba kong, söya, ue l̈ok irbo wl̈o bakoe» l̈e. L̈ara sorë ga shäryara l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Eni ga ba dl̈i sho iara ba shjiygarë ba öng kjing go, ga to l̈ok ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kjër äär sl̈an l̈öng, pë wl̈o l̈ara l̈ishko ga José shjiy kjl̈ara, ba öng së̃yashko ga ĩya ga ba dburwa iak bë tjeng ba dl̈i sho kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ga tjl̈ẽ ba pjeyoga kong ga «Bor dburwa twara l̈ok tek bor kong iröng. ¡Ĩzĩa! Buk bor dl̈i sho kjing go» l̈e. Kuya l̈ok ga bangkjrara l̈ok ara, opshgawono l̈öng dete erä. Ga tjl̈ẽ ëng kong ga «¿L̇l̇ë shäryayde Sbörë bi kong jũni?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Öötong l̈öng Canaán kjokyo iröng obi ga l̇l̇ëye shäryono ba kong dö l̈i l̈ara l̈ok ba data kong. Tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Domer Egipto so kägäyo tjl̈ẽno borwa kong kjang kjange. “¿Pjãy tek l̈öng kjok ëre buk sorë ĩga l̇l̇ëmdo? Pjãy nopga owa tjwayde l̈öng” l̈ara borwa kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tjawa tjl̈ẽno ba kong ga “Tjawa wotjl̈ĩk bëy eröe. Tjawa tek l̈öng l̇l̇ëbo owa shäryaga bomi kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tjl̈apga, bop parkagaga uunkong ëre epenga döe. Tjawa sak kjwara kjingsho pjök (12), data kjl̈araso. Tjawa l̈öng Canaán kjokyo. Borwa l̈ëng chirawa beno sök borwa data tjok. Kjl̈arara sök borwa tjok ame” l̈ororwa ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Eshko ga tjl̈ẽno borwa kong ga “Pjãy wotjl̈ĩk bëy jl̈õ wl̈eni ga pjãy ëng wl̈ẽs kjl̈ara, ber shäng bor tjok na wl̈o, l̇l̇amo to iröng dl̈i sök bomi pjeyoga kong, ue l̈ok wl̈o, epga pjl̈i ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ga bomi l̈ëng tek sömi bor kong. Eni ga pjãy tjl̈ẽno bëy jl̈õre miydër e go. Eni ga bomi kjl̈ara l̈i dör, ga pjãy to l̈öng l̇l̇ëbo tjwl̈ẽk kjok ëreshko ga pjl̈úe” l̈ara borwa kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ba dl̈i sho shiya l̈okshko ga ba dburwa wen tjeng ba roy kjl̈ara ĩ ĩe. Eni ga yëy l̈e l̈ok uunkong, ba datarë bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Eshko ga Jacob tjl̈ẽ ba kong ga «¿Tja iëmi ber shäng wapga dret wl̈ore? José sök bi tjok ame, Simeón bakoe. ¿Benjamín sömi woydë sharare? Ber song l̈i tja» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Eshko ga Rubén tjl̈ẽ ba data kong ga «Benjamín ichos jek bor tjok. Miydaga ber tjarë. Sör tjwe bop kong iröng obi. Sör tjwe l̇l̇ëm ga bor wapga do pjök zröp ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Gueniyo kuya ga tjl̈ẽ ba kong ga «Bor wa jek bomi tjok kjone l̇l̇ëme. Ba kjl̈ara José wol̈ono, beno shäng kjl̈ara kjwe erä. L̇l̇ëbo wen ba kong owa irbo wl̈eni ga tjl̈apga ëre wol̈ono woydorbo ga wl̈oyo pjãydë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Dbar jek ga pjl̈i tjwe ara anmoyõ. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Dl̈i söra l̈i uara l̈ok pjir ga Jacob tjl̈ẽ ba wapga kong ga «Pjãy to dl̈i tjwl̈ẽk bi kong Egipto kjokyo obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","5","Eshko ga Judá tjl̈ẽ ba kong ga «Domer shäng këm tjl̈ẽno borwa kong wẽl̈ëe. “Bomi l̈ëng tek sömi tjwe na l̇l̇ëm ga pjãy tjwe bor ĩk na l̇l̇ëme” l̈ara borwa kong eni. E kjĩshko ga Benjamín ichëp jek borwa tjok ga tjawa jek dl̈i tjwl̈ẽk. L̇l̇ëm ga tjawa jek l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kuya ga tjl̈ẽ ba kong ga «¿L̇l̇ëbo shäryëmi bor kong owa ara ega? ¿Pjãy l̈ëng shäng kjl̈ara l̈ëmi domer e kong l̇l̇ëno?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","«L̇l̇ëbo kjakrokara ara borwa kjĩshko, borwa pjeyoga kjĩshko bakoe. Tjl̈ẽno borwa kong ga “¿Pjãy data tjokde? ¿Pjãy l̈ëmga obl̈ë tjokde?” l̈ara eni. L̇l̇ëbo obl̈ë l̈ororwa ba kong l̇l̇ëme. Dboryororwa eni erä. “Bomi l̈ëng tek sömi bor kong” l̈e borwa kong eni miydororwa l̇l̇ëme» l̈e l̈ok ba data kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Eshko ga Judá tjl̈ẽ ba data kong ga «Kjwozirwa l̈i ichos jek bor tjok, daga ber tjarë. Shji wol̈on l̇l̇ëm wl̈o ga tjawa to dl̈i tjwl̈ẽk. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ios ber tjeng bor wl̈oshko, ĩga ber tjarë, l̇l̇ëye shäryono ba tjok wl̈eni ga kjakrokëp bor kong. Sör tjwe iröng l̇l̇ëm ga tja ber pogo tjwl̈õ bop kong ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Shji l̈öng wor l̇l̇ëm kjwe ga tjawa öör pjl̈ogl̈o pjök tjän» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kuya ga tjl̈ẽ ba kong ga «L̇l̇ëye shäryako obl̈ë wl̈o l̇l̇ëme. E kjĩshko ga dwl̈o poshtikkl̈o l̈õ pjl̈ëbl̈ë obl̈ë obl̈ë, or dyo, kjor bo obl̈ë uako wl̈eniyo, e sömi domer e kong ba sënggl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Dbur sözĩ bayo eni obi. Dbur twara tek tjeng l̈i twëmi ba kong iröng obi, dir ĩ kjwe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bomi l̈ëng kjwe sözĩ jek bomi tjok. Pjãy nom jekdo, domer l̈i ĩk. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Sbö, l̇l̇ëye shärye woydë l̈i shärye ga pjl̈úe. Woydër ga pjãy songe l̈e, pjãy kjimte, bomi kjl̈ara döya wl̈o, Benjamín döya wl̈o bakoe. Tja ber wapga dret wl̈o ga tja beno wapga drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Eni ga Jacob wapga to jek Egipto kjokyo Benjamín tjok. Domer sënggl̈o l̈i söra l̈ok jek ba tjok, dburwa l̈ara ba datarë l̈i söra jek bakoe. Eni ga jek öötong l̈öng José shwoy Egipto kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ĩya Josérë ga Benjamín tek shäng ba shjiyga tjok ga tjl̈ẽ ba u daga kägäyo kong ga «Domerga kjwe sös jek bor ushko. Sögl̈a zröp kjl̈ara, ga l̈iba. Eeri dl̈o dl̈uw ga ië l̈ok bor tjok» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","L̈ara ba kong sorë ga shäryara eni. Epga söra jek ba ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Gueniyo bangkjrara l̈ok ara, söya jek José ushko kjĩshko. Wotjl̈ĩk l̈ok ga «Shji söya l̈ok jek l̈öng eshko jl̈õ wl̈eni, dbur twara l̈ok tek bi kong iröng l̈i kjĩshko. Shji shakoba, shji iëba ber l̈öng ba parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo, bi öng wl̈e tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Öötong l̈öng José ushko ga epga tjl̈ẽ ba u daga kägäyo kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Tjl̈apga, kjupäbäshko ga tjawa öör l̈öng na dl̈i tjwl̈ẽk. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Gueniyo tjawa äär sl̈an l̈öngshko ga borwa dl̈i sho bapkwo kjak dörorwa, ga dbur bë tjeng ba roy, kjl̈ara ĩ ĩ, uunkonge. Dbur iak tjeng sorë ga sörorwa tek tjeng eni, twërwa bomi kong iröng wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tjawa dbur söno dl̈i sho tjwl̈ẽkkl̈o obi. Gueniyo dbur iaga ërë tjeng eshko miydërwa l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kuya ga tjl̈ẽ ba kong ga «Pjãy woydë l̇l̇ëme. L̇l̇ëye bangkjrëmi l̇l̇ëme. Dl̈i tjwl̈ẽnomi, e dburyo kjroror. Dbur beno tjeng bomi dl̈i bapkwo roy l̈i iak bomi Sbörë, e bomi data Sbö bakoe» l̈e. Eshko ga Simeón shira, söra jek öötong ba pjeyoga tjeng l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","E irgo ga söra jek uunkong José u roshko, ga kong di twara, dre shkwë e go wl̈o. Ba öng sëna pjir bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kura l̈ok ga José tjwe ië ba tjok kuzong ga koshe l̈öng. E wopro ga ba sënggl̈o söra l̈i poshäryara tjeng ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","José jek äär ushko ga ba sënggl̈o söra l̈i twara l̈ok ba kong, ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Eshko ga José tjl̈ẽ ba kong ga «¿Pjãy yonde? Pjãy tjl̈ẽ bor kong ga bomi data tjl̈abl̈ae. ¿Sök yonde?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","«Tjl̈apga, borwa data sök yone» l̈e l̈ok ba kong, ga kä dono jek obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ba shjiyga kjing ĩya Josérë. Benjamín, ba l̈ëng data, mekë kjl̈araso l̈i ĩya ga tjl̈ẽ ga «¿Bomi l̈ëng l̈ëmi kjupä kjwere?» l̈e. Ga tjl̈ẽ Benjamín kong ga «Pja miydaga ber Sbörë» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ba l̈ëng ĩya ga wopjl̈ú anmoyõ, sl̈arwõ erä. Eni ga opzrëno jek mal̈ing ba kjër roshko, ga sl̈atong ba l̈ëng kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Woroyono pjir ga bokkwo shkwono, opshino, ga tjl̈ẽ ba parkagaga kong ga «Dl̈i shizĩa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Eshko ga José kong dl̈i shira l̈ok dboy, Jacob wapga kong dboy, Egipto sopga kong dboy bakoe. Egipto sopga kong ga hebreoga tjwl̈õ l̇l̇ëme. E kjĩshko ga ië l̈ok ba tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ba shjiyga ichara Josérë sirkeno tjeng ba gomyo ba këguëyo äär jong ba l̈ëng mite go. E kjĩshko ga epga opshgawono, ga ëng ĩk l̈öng drëng erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Sëna Josérë ba dl̈i baĩya. Ga Benjamínda sëna ara, ba shjiyga kjinmo. José iono ba pjeyoga tjok, ga uunkong beno l̈öng woowa l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","E irgo ga José tjl̈ẽ ba u daga kägäyo kong ga «Domerga ëre dl̈i sho pjanggl̈o, e dl̈ĩs dl̈i sho go. Ba dburwa dl̈i sho tjwl̈ẽnggl̈o l̈i ios ber tjeng dl̈i sho pjanggl̈o l̈i roshko, kjl̈ara ĩ ĩe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Bor di iokl̈o shäryak dbur sho pjl̈ubl̈ún go l̈i ios ber buk ba l̈ëng dl̈i sho pjanggl̈o l̈i roy, ba dbur dl̈i sho tjwl̈ẽnggl̈o wl̈e ios ba roy bakoe» l̈e. L̈ara ba kong sorë ga shäryara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Wẽshko kjok shröngto ga José ba pjeyoga ichono to iröng obi ba öng tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Jek l̈öng pjola l̇l̇ëm obi ga José tjl̈ẽ ba u daga kägäyo kong ga «Pja nom domerga jek l̈öng yẽ irpjang. Dosharop ga pja tjl̈ẽ ba kong ga “¿Pjãy kjimtak pjl̈ú ga tjwl̈ẽmi owa ega? ¿Di iokl̈o shäryak dbur sho pjl̈ubl̈ún go, e l̈ũyotkoromi ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","E bor kägäyo di iokl̈o. E ba l̇l̇ëbo miydokl̈o. Pjãy l̇l̇ëbo owa shäryono” l̈ëp ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kuya ga to jek ba irgo, ga doshara ga l̇l̇ëye l̈ara Josérë ba kong l̈i l̈ara ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kuya l̈ok ga tjl̈ẽ ba kong ga «Tjl̈apga, ¿pja tjl̈ẽ borwa kong eni ega? E shäryororwa l̇l̇ëme. Borwa kong ga e shäryako l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tjawa tek l̈öng iröng Canaán kjokyo dwayoshko ga dbur wl̈ẽnorwa borwa dl̈i sho pjanggl̈o roshko l̈i tyororwa bomi kong iröng. ¿Eni ga era bop kägäyo dbur sho l̈ũyotkërwa sorë? ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Di iokl̈o wen tjeng ë tjok ga e wol̈on wl̈o, tjawa ber l̈öng bomi parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kuya ga tjl̈ẽ ba kong ga «Pjl̈úe. Shäryër eni. Gueniyo wen tjeng ë tjok ga ber shäng bor parkaga tjwl̈ẽk shäng pjir wl̈eniyo, l̇l̇amo to iröng ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ba dl̈i sho pjanggl̈o l̈ona l̈ok töshko, ga kjak döra l̈ok jekdo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Roĩna José u daga kägäyorë ba shjiy këguë ĩ äär jong ba l̈ëng mite ĩ go, ga di iokl̈o l̈i wl̈ẽna buk Benjamín dl̈i sho pjanggl̈o roy. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","E kjĩshko ga ba shwong dwl̈ëkza l̈ok tjã tjã erä, woydë l̈ok ara kjĩshko. Eshko ga ba l̇l̇ëbo poyona ba öng kjing go, ga sano jek José shwoy iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judá, ba pjeyoga öötong l̈öng José ushko ga José sök eshko obi. Eni ga kjök tono l̈ok, kjujono bokdo kjl̈ay kl̈ung go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Eshko ga José tjl̈ẽ ba kong ga «¿L̇l̇ëye shäryoromiro? ¿Tja ëre l̇l̇ëbo miydokl̈o tjok miydëmi l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kuya Judárë ga tjl̈ẽ ba kong ga «¿L̇l̇ëye l̈ërwa? ¿Tjawa l̇l̇ëbo owa shäryono l̇l̇ëm ga pinwa bop kong sorë? L̇l̇ëbo shäryororwa owa l̈i iara Sbörë beno ĩkoba wẽl̈ëe. Tjawa l̈öng na. Tjawa bop parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo, borwa l̈ëng bop di iokl̈o söga kjwe tjok bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Gueniyo kuya ga tjl̈ẽ ba kong ga «Eni l̇l̇ëme. Di iokl̈o tjeng ë tjok ga e ber shäng bor parkaga tjwl̈ẽk shäng pjir wl̈eniyo. Pjãyda to jek iröng ushko ga pjl̈úe. Pjãy barwaga ërë l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Era eni ga Judá jek José zl̈ong bäng, ga tjl̈ẽ ba kong ga «Tjl̈apga, ¿tja tjl̈ẽ bop kong sira tjoksa ga buere? Pja iirkë bor kong l̇l̇ëme. Pja tjwl̈õ ara bor kong, Egipto so pjl̈uyo dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Pja tjl̈ẽno borwa kong ga “¿Pjãy data tjokde? ¿Pjãy l̈ëmga obl̈ë tjokde?” l̈orop borwa kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Eshko ga tjawa tjl̈ẽ bop kong ga “Borwa data, e tjl̈abl̈ae. Ga tjawa l̈ëng shäng kjl̈ara mite obi. E bukshko ga borwa data tjl̈abl̈ae. Ba meyo l̈i tjok ga wapga tjeng do pjök, gueniyo kjl̈ara shinmotkonoe. E kjĩshko ga ba wa beno shäng l̈i woyde borwa datarë ara” l̈ërwa bop kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","»Eshko ga pja tjl̈ẽ borwa kong ga “Bomi l̈ëng tek sömi bor kong ĩn wl̈o” l̈ëp. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ga tjawa tjl̈ẽ bop kong ga “Kjwozirwa ba data rayë ber tjoksa ga äe. Raye ber tjoksa ga wol̈on” l̈ërwa. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Gueniyo pja tjl̈ẽ borwa kong ga “Bomi l̈ëng tek sömi na l̇l̇ëm ga pjãy tjwe bor ĩk na l̇l̇ëme” l̈ëp. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tjawa jek äär iröng borwa data shwoy ga l̇l̇ëye l̈orop borwa kong l̈i l̈ororwa ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","»Eshko ga borwa data tjl̈ẽ borwa kong ga “Pjãy nom iröng dl̈i sho tjwl̈ẽk sira” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Gueniyo tjawa tjl̈ẽ ba kong ga “Tjawa yorke borwa l̈ëngdë l̇l̇ëm ga tjl̈apga sök, e ĩnwa ga äe” l̈ërwa ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","»Kuya ga tjl̈ẽ borwa kong ga “Miydëmi pjl̈ú ga bor boy, e wapga do pjök bor tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kjl̈ara to bor shjiryo dwayo, ga sök bor tjok ame. Miydër ga uara äya kjl̈oshko sorë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Era ba l̈ëng kjwe söromi to bor zl̈ong dwayo ga l̇l̇ëbo weno ba kong owa bebi wl̈eni ga tja wol̈on woydorbo. Eshko ga wl̈oyo ber pjãydë” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","»E kjĩshko ga bor l̈ëng woyde bor datarë ara ba pjl̈ugwo baĩya wl̈eni. Kjwozirwa, e äär borwa tjok iröng l̇l̇ëm ga borwa data, e wol̈on woydorbo. Enira wl̈oyo ber tjawarë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tja tjl̈ẽno bor data kong ga “Ios ber tjeng bor wl̈oshko, ĩga ber tjarë. L̇l̇ëye shäryono ba tjok wl̈eni ga kjakrokëp bor kong. Sör tjwe iröng l̇l̇ëm ga tja ber pogo tjwl̈õ bop kong ĩyado” l̈oror. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","»E kjĩshko rokër bop kong sira ga tja ios ber shäng bop parkaga tjwl̈ẽk shäng pjir wl̈eniyo, kjwozirwa kjwe shtoshko. Ga ichos jek ba shjiyga tjok sira. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tja jek äär iröng bor data shwoy ba tjok l̇l̇ëm ga äe. Bor data sök woydë, song, e ĩn woydë l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","3","Eshko ga José sl̈arwõ, ga tjl̈ẽ ba parkagaga l̈öng l̈i kong ga «¡Pjãy opshis uunkong na dwayo!» l̈e, ga beno shäng tjoksa ba pjeyoga tjok, ga sl̈atong jl̈õkoyo. Kuya Egipto sopga l̈öng kjoko l̈irë ga roy shdöra öötong uunkong kong, öötong Egipto so pjl̈uyo ushko bakoe. Eshko ga José tjl̈ẽ ba pjeyoga kong ga «Tja José. ¿Bor data sök sëre?» l̈e. Kuya l̈ok ga beno l̈öng sëya l̇l̇ëme. Dborye l̈ok ga äe. Tjl̈õkwo drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Eshko ga José tjl̈ẽ ba kong ga «Pjãy tek bor zl̈ong sira» l̈e. Ga tjl̈ẽ ba kong obi ga «Bomi l̈ëng soynenomi Egipto sopga kong dgue, e tja José. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Gueniyo ga pjãy woydë l̇l̇ëme. Tja wl̈oyo pjãydë l̇l̇ëme. Tja ichara Sbörë na bomi bäm go, nopga kjimtë, wol̈on l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","»Pjl̈i ara kjok ëre kjing go l̈u pjl̈ogl̈o pjök tjän. Kjwe l̈u pjl̈ogl̈o shkëng (5) obi ga dl̈i l̇l̇ë wen l̇l̇ëm, l̇l̇ëye dguëy ga wen l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gueniyo tja ichara Sbörë bomi bäm go, bomi kjimtë, pjãy wol̈on l̇l̇ëm wl̈o, bomi tjëyo tek ber bomi irgo l̈i wen wl̈o. Shäryara Sbörë obl̈ë, ba dbo kësbang go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tja ichaga Sbörë na, pjãydë l̇l̇ëme. Tja iara beno shäng Egipto so pjl̈uyo dboryaga, ba u daga kägäyo, Egipto sopga uunkong ichaga bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","»Pjãy nom mal̈ing bor data shwoy, ga pjãy tjl̈ẽ ba kong ga “Bop wa José tjl̈ẽ ga ‘Tja ichara Sbörë beno shäng Egipto so kägäyo. Pja tek bor ĩk wop äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Pja ber sök Gosén kjokyo, bop wapga, bop tjërga, bop öng, bop l̇l̇ëbo tjeng kës l̈i tjok. Eni ga pja ber sök bor soshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ëreshko ga pja sën dl̈i, bop pjeyoga uunkong tjok, pjãy pjl̈i kuk l̇l̇ëm wl̈o, dl̈i l̇l̇ëm kjwe l̈u pjl̈ogl̈o shkëng (5) obi kjĩshko’ l̈e Josérë” l̈ëmi ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","»Miyde bor l̈ëng Benjamíndë, pjãy ommiydë bebi ga tja José jl̈õkoyo. Tja tjl̈ẽno l̈i kuromi uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tja sök na, tja tjl̈apga dbo kësbang, tja parkë sök sorë l̈i l̈anyotkëmi bor data kong. L̇l̇ëye ĩnomi na dö l̈i l̈ëmi ba kong pjir bakoe. Pjãy nomo. Bor data tek sömi wop äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Eshko ga José, Benjamín, e ëng popjl̈uno l̈ok, ga sl̈atong wop ara ëng tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Eshko ga ba pjeyoga uunkong l̈õ shira, sl̈atong ba tjok. E irgo ga ba pjeyoga woroyono, tjl̈ẽno ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","José pjeyoga shrono l̈öng l̈i roy kuya pjl̈urë ga beno wopjl̈ú, ba pjl̈oyoga uunkong tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Eni ga pjl̈u tjl̈ẽ José kong ga «L̈ëp bop pjeyoga kong ga dl̈i sho ie l̈ok ba öng kjing go, ga to Canaán kjokyo, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ga bop data, ba pjeyoga tek söya bor kong. Egipto kjok pjl̈úyo twër ber ba kong, Egipto dl̈i pjl̈úyo twër ba kong, ue wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ichos jek na dwayo jëkkl̈o sök, ba boyga sökkl̈o, ba wapga sökkl̈o, bop data sökkl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wotjl̈ĩk l̈ok ba l̇l̇ëbo ber l̈i kjĩshko l̇l̇ëm, l̇l̇ëbo pjl̈úyo tjeng Egipto kjokyo ëre twër ber ba kong kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Shäryara Jacob wapgarë eni. Ba jëkkl̈o l̈ara pjl̈urë l̈i twara Josérë ba kong, dl̈i ichara, ue irbo wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Shwong twara tjagl̈ën ba shjiyga kong. Gueniyo Benjamínda kong dbur sho pjl̈ubl̈ún twara kjwo sak dbäw pjl̈ogl̈o mya (300), shwong twara kjringgwo shkëng (5) bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ba data kong öng l̇l̇ëbo sökkl̈o ichara sak kjwara (10) l̇l̇ëbo pjl̈úyo tjeng Egipto kjokyo tjok, öng dogl̈o sak kjwara (10) obi dl̈i sho tjok, ue irbo wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","«Tjawa toe» l̈e l̈okshko ga José tjl̈ẽ ba pjeyoga kong ga «Jöl̈ö. Pjãy nome. Pjãy ëngkjwë ëng tjok irbo l̇l̇ëme» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Eni ga opshino jek Egipto kjokyo dwayo, öötong l̈öng Canaán kjokyo, ba data Jacob sökshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ĩya l̈ok ga tjl̈ẽ ba kong ga «¡José sök së! ¡E tjl̈apga tjwl̈õ kësbang, Egipto so kägäyo!» l̈e l̈ok ba data kong, gueniyo tjl̈õkwo kjrara l̇l̇ëm, yëy l̈e erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Gueniyo l̇l̇ëye l̈ara Josérë kjöme l̈i kura. Ga ĩna ga jëkkl̈o ichara Josérë jong ba wl̈okjrokl̈o. Eni ga beno wopjl̈ú, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ga tjl̈ẽ ga «¡Jl̈õe! Era miydër ga José sök së. Tja wol̈ontë l̇l̇ëm obi ga tja to ba ĩk» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","E irgo ga Jacob opshino to jek Egipto kjokyo ba pjeyoga tjok, ba l̇l̇ëbo uunkong tjok bakoe. Jek öötong l̈öng Berseba kjokyo ga öng zröra, sho sura, pjono dret, ba data Isaac Sbö poshrëkkl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","E shkëyo ga Sbö weno shäng ba kong yoshko wl̈eni, ga tjl̈ẽ ba kong ga «¡Jacob!» «¿L̇l̇ë?, Tjl̈apga» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Tjl̈ẽ ga «Tja Sbö, tja bop data Sbö. Pja jek Egipto kjokyo ga l̇l̇ëye bangkjrëp l̇l̇ëme. Kjok eshko ga bop tjëyo tek ber bop irgo l̈i iër ber tjëyo kësbange. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Tja jek shäng bop tjok eshko. L̇l̇ono ga bop tjëyoga shir ey dwayo, ga tek sör na iröng obi. Ga pja wol̈onshko ga José sök bop zl̈ong bäng» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","E irgo ga Jacob iara ba wapgarë opyë sök jëkkl̈o ichara Egipto so pjl̈uyorë ba kong l̈i roshko, ba pjl̈aydoga, ba tjërga tjok. Ga Jacob opshino to ey dwayo ba tjëyo tek beno ba irgo uunkong l̈i tjok. Ba öng, ba l̇l̇ëbo uunkong wl̈ẽna Canaán kjokyo l̈i söra jek ba tjok Egipto kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","15","Jacob tjëyo tek beno ba irgo l̈i öötong l̈öng Egipto kjokyo ko l̈ok eni. Epga beno l̈öng Israel tjëyoga. Lea wapga Jacob tjok, e weno tjeng Padán Aram kjokyo, e ko l̈ok eni. Ba tjëyo tek beno ba irgo l̈i tjok ga beno l̈öng dogl̈o sak mya kjingsho mya (33). Rubén, e ba wa domer bäm ĩyo. Rubén, e öötong ba wapga domerga Janoc, Falú, Jezrón, Carmí tjok. Simeón, e öötong ba wapga domerga Jemuel, Jamín, Oad, Jaquín, Zojar, Saúl tjok. Saúl, e mekë Canaán so. Leví, e öötong ba wapga domerga Guersón, Coat, Merari tjok. Judá, e öötong ba wapga domerga Selá, Fares, Zera tjok. Ba wapga domerga Er, Onán, e wol̈ono beno l̈öng Canaán kjokyo. Fares, e öötong ba wapga domerga Jezrón, Jamul tjok. Isacar, e öötong ba wapga domerga Tola, Fuvá, Job, Simrón tjok. Zabulón, e öötong ba wapga domerga Séred, Elón, Yalel tjok. Jacob wa wal̈ë Dina, e öötong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Parkaga twara Labándë ba wa Lea kong ko Zilpá l̈i wapga Jacob tjok ko l̈ok eni. Ba tjëyo tek beno ba irgo l̈i tjok ga beno l̈öng dogl̈o sak kjwara kjingsho tjer (16). Gad, e öötong ba wapga domerga Zefón, Jaguí, Ezbón, Suni, Erí, Arodí, Arelí tjok. Aser, e öötong ba wapga domerga Imná, Isvá, Isví, Beriá tjok, ba wa wal̈ë Sera tjok bakoe. Beriá, e öötong ba wapga domerga Héber, Malquiel tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","22","Raquel wapga Jacob tjok ko l̈ok eni. Ba wapga tjok ga beno l̈öng dogl̈o sak kjwara kjingsho pkëng (14). José, e sök Egipto kjokyo ga wapga tjeng domer do pjök ba boy Asenat tjok ko Manasés, Efraín. Asenat, e Potifera wa. Potifera, e sök On kjokyo. E syõshtaga Egipto so sböpga kong. Benjamín, e öötong ba wapga domerga Bela, Béquer, Asbel, Guerá, Naamán, Ehí, Ros, Mupín, Jupín, Ard tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Parkaga twara Labándë ba wa Raquel kong ko Bilhá l̈i wapga Jacob tjok ko l̈ok eni. Ba wapga tjok ga beno l̈öng dogl̈o kjäk (7). Dan, e öötong ba wa domer Jusín tjok. Neftalí, e öötong ba wapga domerga Yazel, Guní, Jéser, Silén tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jacob, e öötong Egipto kjokyo ba tjëyo tek beno ba irgo l̈i dogl̈o sak tjer kjingsho tjer (66) tjok, ba pjl̈aydoga tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","José wapga tjeng Egipto kjokyo do pjök. Eshko ga Jacob tjëyoga shrono l̈öng Egipto kjokyo dogl̈o sak kjäk (70). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Epga jek l̈öng irbo ga Judá ichara Jacobdë jek bäm go José ĩk, wl̈okjre tek irbo Gosén kjokyo wl̈o. Öötong l̈öng eshko l̈i kuya Josérë ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ba parkagaga ichara ba jëkkl̈o poshäryë. E irgo ga José jek ba data wl̈okjrë. Öötong shäng ba data sökshko ga ëng popjl̈uno l̈ok, ga sl̈atong wop ara ëng tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Eshko ga Jacob tjl̈ẽ ba kong ga «Pja ĩnor om go bor bokkwo go, ga pja shäng së jl̈õe. Era tja wol̈on ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","32","Kuya ga tjl̈ẽ ba data, ba pjeyoga kong ga «Tja to tjl̈ẽ pjl̈u kong ga “Bor data, bor pjeyoga l̈öng Canaán kjokyo l̈i shrono l̈öng na, ber l̈öng bor tjok wl̈o. Epga öng daga kjĩshko ga ba öng, ba l̇l̇ëbo uunkong söra tek ba tjok” l̈ër ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Pjãy roke pjl̈urëshko ga “¿Pjãy pak l̇l̇ë?” l̈e bomi kongshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","pjãy tjl̈ẽ ba kong ga “Tjawa tek chilawa obishko dwayo ga tjawa pak, e öng daga, borwa tjëyoga dëna ĩ dik” l̈ëmi ba kong eni. Eni ga Egipto sopga l̈öng öng dagaga tjok woydë l̇l̇ëm kjĩshko ga pjãy ie ber l̈öng Gosén kjokyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Eshko ga ba pjeyoga kjrara dogl̈o shkëng (5), ga söra jek öötong l̈öng Egipto so pjl̈uyo shwoy, ga tjl̈ẽ ba kong ga «Bor data, bor pjeyoga tek Canaán kjokyo dwayo l̈i shrono l̈öng Gosén kjokyo ba öng tjok, ba l̇l̇ëbo tjeng kës l̈i tjok bakoe» l̈e. Eshko ga ba pjeyoga l̈i pina pjl̈u kong, miyde wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Eni ga pjl̈u tjl̈ẽ ba kong ga «¿Pjãy pak l̇l̇ë?» «Tjl̈apga, tjawa tek chilawa obishko dwayo ga tjawa pak, e öng daga, borwa tjëyoga dëna ĩ dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Canaán kjokyo pjl̈i ara, borwa öng dl̈i drete. E kjĩshko ga tjawa to tek ber l̈öng na wl̈o l̈ërwa. Rokërwa bop kong sira ga tjawa ios ber tjeng Gosén kjokyo» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kuya ga tjl̈ẽ José kong ga «Bop data, bop pjeyoga tek shrono ber l̈öng bop tjok wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egipto kjokyo tjeng bop wl̈oshko. Gosén kjokyo, e Egipto kjok pjl̈úyo kuzong ga twos ba kong, ber l̈öng eshko wl̈o. Ĩp ga domerga kjone kjone parkë pjl̈ú ga ios ber l̈öng bor öng dë bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","E irgo ga ba data söra, pina pjl̈u kong, miyde wl̈o. Eshko ga Jacob tjl̈ẽno beno pjl̈ú ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ga pjl̈u tjl̈ẽ ba kong ga «¿Pja l̈u pjl̈obi?» ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","«Tja l̈u pjl̈ogl̈o sak dbäw kjingsho sak mya (130) erä. Tja sök shtor l̇l̇ëm, tja jëkko erä, tja songe. Bor data, bor kjokë, e jëk to l̈öng shtor l̇l̇ëm bako, gueniyo l̈u ĩno bor kjinmo» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","E irgo ga Jacob tjl̈ẽno beno pjl̈ú ba kong obi, ga toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Eshko ga l̈ara pjl̈urë sorë ga shäryara Josérë eni. Egipto kjok pjl̈úyo twara ba data, ba pjeyoga kong, ber l̈öng eshko wl̈o. Kjok, e ber buk Ramsés kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ba pjeyoga uunkong sëna dl̈i bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Egipto kjokyo, Canaán kjokyo ga dbar jek ga pjl̈i tjwe ara anmoyõ. Nopga wol̈onto pjl̈irë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Eni ga dl̈i soynena Josérë Egipto sopga kong, Canaán sopga kong bakoe. Dburyo l̈i jnena tjeng pjl̈u dbur jnezl̈ongshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Dbur pjitongshko ga Egipto sopga tjwe tjl̈ẽ José kong ga «Tjawa dbur pjitonge. Tjawa sëm dl̈i. L̇l̇ëm ga tjawa wol̈on pjl̈irë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kuya ga tjl̈ẽ ba kong ga «Pjãy dbur pjitong ga bomi öng sömi bor kong, ga kjl̈opswër dl̈i sho go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Eni ga Egipto sopga, ba öng obl̈ë obl̈ë, e söra José kong, kjl̈opswe dl̈i sho go wl̈o. Shäryara eni l̈u pjl̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","E irgo ga tjwe tjl̈ẽ José kong obi ga «L̇l̇ëye jnenwa bop kong ga äe. Tjawa dbur pjitong, ga borwa öng, e beno bopoya. Beno tjawa, borwa kjok erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tjawa iëp wol̈on l̇l̇ëme. Borwa kjok iëp ber tjoksa l̇l̇ëme. Tjawa tjwl̈ẽs, borwa kjok tjok bebi, dl̈i sho ãska. Eni ga tjawa ber l̈öng parkë borwa kjok l̈i kjing go pjl̈u kong. Dwl̈a twos borwa kong, tjawa wol̈on l̇l̇ëm wl̈o, kjok ëre kjing go nopga tjok obi wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Pjl̈i tjwe ara anmoyõ kjĩshko ga ba kjok soynena uunkong José kong. Eni ga Egipto kjok tjwl̈ẽna Josérë uunkong pjl̈u kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Nopga uunkong beno l̈öng ba parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Gueniyo syõshtagaga Egipto so sböpga kong, epgara kong dl̈i twe pjl̈urë ĩyado. E kjĩshko ga ba kjok soynena l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","E irgo ga José tjl̈ẽ nopga kong ga «Pjãy tjwl̈ẽnor uunkong bomi kjok tjok pjl̈u kong. Dwl̈a tjeng ëre to dguëmia. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Gueniyo ba bo kjrozl̈ong dbaryo ga dl̈i tömi l̈i kjringgwo shkëng (5) l̈i shimi kjrina pjl̈u kong, kjringgwo sak kjwara (10) l̈i shimi kjring pjök ba kong, kjringgwo sak kjwara kjingsho shkëng (15) l̈i shimi kjringgwo mya ba kong. Shäryëmi uun eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kuya l̈ok ga tjl̈ẽ ba kong ga «Pja opshäryono pjl̈ú borwa tjok. Tjawa iorop wol̈on pjl̈ishko l̇l̇ëme. E kjĩshko ga tjawa to ber l̈öng pjl̈u parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Eni ga José kjok l̇l̇gwekkl̈o shäryono kjrina Egipto so kjl̈obi kong, dwl̈a bo kjrozl̈ong dbaryo ga dl̈i tö̃ya l̈i twe l̈ok pjl̈u kong, l̈ara sorë l̈i eni. Kjok l̇l̇gwekkl̈o l̈i eeri ga buk eni. Gueniyo syõshtagaga Egipto so sböpga kong l̈ira l̇l̇ëye twe l̇l̇ëm, ba kjok beno pjl̈u kong l̇l̇ëm kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel tjëyoga beno l̈öng Gosén kjokyo, e Egipto kjokyo obi. Kjok shano bayo ara, dbur ara, wapga träk l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob beno sök eshko l̈u pjl̈ogl̈o sak kjwara kjingsho kjäk (17). L̈u ĩno sak dbäw kjingsho sak pkëng kjingsho kjäk (147). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Dbar kjwara ga Jacob sök së obishko ga wol̈on dbaryo woyotjl̈ĩya buk. Eshko ga ba wa José rokara, ga tjl̈ẽ ba kong ga «Tja woydëp jl̈õkoyo wl̈eni ga l̈os bor kong jl̈õkoyo ga pja wotjl̈ĩk pjl̈ú bor kong, ga tja kjimtëp ĩyado. Pja kä dos, orkwo ios bor kworbo kjing go, e ber ba jyãgl̈o wl̈o. Tja jnep ber buk na Egipto kjokyo l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Tja wol̈onoshko ga tja ship Egipto kjokyo ëre dwayo, tja söp äär ber buk bor pjeyoga iak tjengshko» l̈e. Kuya ga tjl̈ẽ ba kong ga «Shäryër eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Eshko ga tjl̈ẽ ba wa kong obi ga «L̈os bor kong jl̈õkoyo» l̈e. Kuya ga tjl̈ẽ ba kong ga «L̈ër bop kong jl̈õkoyo ga shäryër eni» l̈e. Eshko ga Jacob kä dono, syõshtono Sbö kong buk ba bukkl̈o kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","E irgo ga oba tjl̈ẽ José kong ga «Bop data swl̈o ara» l̈ëba ba kong. Eni ga José jek ba ĩk, ba wapga Manasés, Efraín tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Öötong l̈öng ba shwoy ga «Bop wa José shrono shäng bop ĩk» l̈ëba ba kong. Kuya ga kojono dbo go, sirkeno sök ba bukkl̈o kjing go, ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ga tjl̈ẽ José kong ga «Sbö, l̇l̇ëye shärye woydë l̈i shärye ga pjl̈úe. Sbö weno shäng bor kong Luz kjokyo, e Canaán kjokyo obi. Eshko ga tjl̈ẽno beno pjl̈ú bor kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Tjl̈ẽ ga “Pja iër ber shdär träk l̇l̇ëme. Bop tjëyo tek ber bop irgo l̈i iër ber l̈öng tjëyoga obl̈ë obl̈ë, ga tjë jĩkong ber l̈öng tjëyo kjrinaso. Kjok ëre twër ber ba kong ĩyado wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Bop wapga Efraín, Manasés, e weno tjeng na Egipto kjokyo, tja tjwayde töntë bop tjok l̇l̇ëm obishko. Epga ber bor wapga onmo wl̈eni, Rubén, Simeón dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pja wapga tjok obi wl̈eni ga epgara bopoya. Kjok twe datagarë ba wapga kong l̈i twe Efraín, Manasésdë ba kong, epga ba l̈ëmga kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Tja jek shäng Padán Aram kjokyo dwayo, Efrata kjokyo ber buk pjola obishko ga bop mekë Raquel wol̈ono bor shjiryo eshko Canaán kjokyo. Eni ga jnenor beno buk irbo jek jong äär Efrata kjokyo sor go» l̈e. (Eeri ga Efrata kjokyo, e ko Belén.) ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Eshko ga Jacob tjl̈abl̈a, kjok ĩgö pjl̈ú ame. E kjĩshko ga José wapga miydara l̇l̇ëme. Eni ga tjl̈ẽ José kong ga «¿Kjwepga kjwe ë?» «Kjwe bor wapga twara Sbörë bor kong na Egipto kjokyo» l̈e ba kong. Kuya ga tjl̈ẽ ba kong ga «Tek sös bor zl̈ong bäng, tjl̈õkwo l̈ër ber pjl̈ú ba kong wl̈o» l̈e. Eni ga ba wapga söra jek ba kjokë zl̈ong. Eshko ga popjl̈ura Jacobdë, ga l̈õ shira. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ga tjl̈ẽ José kong obi ga «Pja ĩn ame l̈oror. Gueniyo tja kjimtara Sbörë sök së obi, pja ĩnor, bop wapga ĩnor bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Eshko ga ba wapga kjara Josérë ba kjokë zl̈ong dwayo, ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","E irgo ga ba wa Efraín shara ba or kël̈ë go, Manasés ba or mil̈ë go. Eni ga Efraín beno ba kjokë or mil̈ëkong, Manasés ba or kël̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Gueniyo Jacob orkwo ië ba tjërga kjing goshko ga Manasés, e José wa domer bäm ĩyo ëmdë ga ba orkwo kël̈ë l̈i iara beno Efraín kä kjing go, orkwo mil̈ë l̈i iara Manasés kä kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Eni ga tjl̈ẽno beno pjl̈ú José kong. Tjl̈ẽ ga «Sbö, e kol̈ara bor data Isaac, bor kjokë Abrahamdë. E bor daga, tja bukshko tek l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","L̇l̇ëbo wen bor tjok owashko ga ba parkaga kjok dogo so, e bor kjimtaga. Kjwozirga ëre kjimte eni bakoe. Kjwepga kjĩshko ga tja woyoshrëba, bor data Isaac, bor kjokë Abraham, e woyoshrëba bakoe. Ba tjëyo tek ber ba irgo l̈i shdär träk l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ĩya Josérë ga ba data orkwo kël̈ë l̈i iara Efraín kä kjing go ga beno ba kong owa. E kjĩshko ga orkwo shara, kje Efraín kä kjing dwayo, ie Manasés kä kjing go wl̈o l̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ga tjl̈ẽ ba data kong ga «Data, kjweni l̇l̇ëme. Ba shjiy shäng ëre. Bop orkwo kël̈ë kjwe ios ba kä kjing go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Gueniyo kuya ga tjl̈ẽ ba kong ga «Miydër tjän. Ba tjëyo tek ber ba irgo l̈i äär ber tjëyo kësbang, tjwl̈õ ara bakoe. Gueniyo ba l̈ëngda äär tjwl̈õ ara ba kjinmo. Ba tjëyo tek ber ba irgo l̈i äär ber tjëyoga obl̈ë obl̈ëe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Eshko ga Jacob tjl̈ẽno beno pjl̈ú ba tjërga kong. Tjl̈ẽ ga «L̇l̇ono ga Israel tjëyoga tjl̈ẽ ga “Pja kjimte Sbörë ber Efraín, Manasés ĩ dik” l̈e ber pjl̈ú nopga kong wl̈o» l̈e. Efraín iara beno Manasés bäm go eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","E irgo ga tjl̈ẽ José kong ga «Tja wol̈on e, gueniyo ga Sböra ber shäng bomi tjok, pjãy kjimte äär iröng obi bomi tjëyoga kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tja ëngkjwono amorreoga tjok, zanor song, ba kjok ko Siquén l̈i döror. Kjok, e pjl̈ú, owa l̇l̇ëme. E twër ber bop kong erö, bop pjeyoga kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","E irgo ga Jacob, ba wapga rokara uunkong tek ba shwoy, ga tjl̈ẽ ba kong ga «L̇l̇ëye wen bomi kong l̇l̇ono l̈i l̈ër bomi kong, miydëmi wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Pjãy tek l̈öng bor zl̈ong bäng. Tja kuzĩa. Pjãy bor wapga, pjãy uunkong kjweni. Tja bomi data Israel. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","»Rubén, pja bor wa domer bäm ĩyo. Pja bukshko ga tja dwl̈as l̈ë jã. Pja tjwl̈õ ara, dbo ara, bop l̈ëmga kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Gueniyo pja domer tjëkso l̇l̇ëm, kä l̇l̇ëm wl̈eniyo. Pja pono bor boy obl̈ë tjokshko ga tja iorop beno sök l̈ökshko. E kjĩshko ga pja tjwl̈õ bop l̈ëmga kjinmo ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","»Simeón, Leví, pjãy epenga döe. Pjãy wotjl̈ĩk no barwë erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Pjãy ëng töng l̈anshko ga tja tön woydë bomi tjok l̇l̇ëme. Pjãy iirkonoshko ga no zrömi äe. Öng dre kjyungyo zëmi l̇l̇ë kjĩshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Pjãy iir ara. Pjãy iir äya kjl̈oshko so wl̈eni. E kjĩshko ga pjãy äyoshtër. Eni ga bomi tjëyo tek ber bomi irgo l̈i ber l̈öng kjok drete. Epga shdär ber l̈öng Israel tjëyoga tjrëko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","»Judá, bop moskwoga zam song erä. E kjĩshko ga pja poshrëya bop pjeyogarë. Epga kjök tok, kjujong bokdo kjl̈ay kl̈ung go bop kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Dbong dl̈i shano, uara pjir ga bojong iröng woshtë ba shtoshko. Dbo ara kjĩshko ga barwaga ërë l̇l̇ëme. Judá, pja dbong wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Pja dbo kjaga ërë l̇l̇ëm, bop kjë döga ërë l̇l̇ëm, ba sogo shrono om go guing. Era kol̈e tjëyoga uunkongdë. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Pja ber sök dl̈i ara, opzang ĩ, bop kjor bo pjl̈úyo twëp bop öng kong. Pja ää ara anmoyõ, shwong kwoshkwëp e go ga pjir l̇l̇ëm, ber obie. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Pja bok ro srëzrën, pja ää ara kjĩshko. Pja kowo pjl̈ubl̈ún, pja öng nä dyo ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","»Zabulónda ber sök dl̈ung kjako, kjyong këskës tjwe tjyëshko. Ba kjok worbo äär jong Sidón kjokyo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","»Isacarda öng l̇l̇ëbo shgaga dbo ara woshtë sök ba l̇l̇ëbo tjok wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ĩya ga woshtozl̈ong pjl̈ú kjĩshko ga kojono dbo go jek ba l̇l̇ëbo shguë. Eni ga beno shäng obl̈ë parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","»Danda ba tjëyo l̇l̇gwek om go, Israel tjëyoga obl̈ë dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dgur buk irbo sor go. Kwomgl̈a jek ba zl̈ongshko ga ba dre uakza ga no sök ba kjing go l̈i l̈on. Dan, pja bangkjrëba dgur wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Eshko ga Jacob tjl̈ẽ ga «¡Jehová, tja dözong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ga tjl̈ẽ ba wapga kong obi ga «Gadda, moskwoga tjwe ba zrök l̈eshko ga epga zãya, irpjãya erë shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","»Aserda dl̈i ara, uak pjl̈ú, pjl̈upga dl̈i dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","»Neftalíra shwl̈ing kjl̈oshko so jek zron oojong, wapga wol̈ëso wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","»Joséra, e kjil̇l̇gwo jong diksor go, bo ara, l̇l̇iywë shdär äär di dl̈upyo wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ĩywa l̈ok shjiktëng ba moskwogarë, könkowo dbuya l̈ok ara ba kjing go, twe l̈ok tjötö ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Gueniyo ba sböng shaya jl̈õkoyo, wir l̇l̇ëme. Orkwo ber gol̈ong, Jacob Sbö dbo ara kjĩshko, e Israel tjëyoga daga, guëng wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Pja kjimte bop data Sbörë. L̇l̇ëye shärye woydë Sbörë l̈i shärye ga pjl̈úe. L̇l̇ëbo twe bop kong pjl̈úe. Shunyo iche shrë kjok dogo dwayo, diwa iche tur kl̈ung roy dwayo, pja wapga shdär träk l̇l̇ëm, bop öng wapga shdär eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","L̇l̇ëbo weno pjl̈ú bor kong träk l̇l̇ëm, äär jong kjókshko, dl̈up l̇l̇ë këskës kjinmo. L̇l̇ëbo pjl̈ú l̈i ber bop kong, pja bop pjeyo kägäyo kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","»Benjamínda, e shjiti kjl̈oshko so iir ara wl̈eni. Kjok shröngto ga ba sëng ue, kjok sëng ga l̇l̇amo pjl̈orgue» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ëre Israel tjëyoga kjringgwo sak kjwara kjingsho pjök (12). Tjl̈õkwo l̈ara ba datarë beno pjl̈ú tjëyo kjrina kjrina kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","E irgo ga Jacob tjl̈ẽ ba kong ga «Tja wol̈ontoe. Tja wol̈onoshko ga tja sömi äär ber buk bor pjeyoga iak tjengshko, guëng jong ööng Het tjëyo ko Efrón kjokshko l̈i roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","E ber buk Macpela kjokyo, Mamré kjokyo gomyo, e Canaán kjokyo obi. Guëng l̈i tjwl̈ẽna Abrahamdë Efrón kong, l̇l̇ëye tjeng eshko l̈i bako, ber buk sak ba pjeyoga kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham, ba boy Sara, Isaac, ba boy Rebeca, e iak tjeng eshko, Lea iak buk eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kjok buk eshko, guëng jong ööng tjwl̈ẽna Het tjëyoga kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tjl̈ẽno eni pjir ga opbuno buk töshko, ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Eshko ga doyo popjl̈ura Josérë, l̈õ shira, ga sl̈ar ëëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","E irgo ga no dwl̈omnega ichara ba data doyo poshtik, an l̇l̇ëm wl̈o. Shinmo doyo poshtiya l̈ok eshko sorë ga Jacob doyo poshtira l̈ok dbargwo sak pkëng (40) eni. Jacob soyopora Egipto sopgarë dbargwo sak kjäk (70). ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sopono l̈ok pjir irgo ga José tjl̈ẽ pjl̈u pjl̈oyoga kong ga «Rokër bomi kong sira ga pjãy tjl̈ẽ pjl̈u kong bor kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Pjãy tjl̈ẽ ba kong ga bor data wol̈on döröshko ga tja ichara tjl̈ẽ ba kong jl̈õkoyo ga “Pja wol̈onoshko ga pja sör äär ber buk Canaán kjokyo, sak shäryorop om go l̈i roshko” l̈oror. Eni ga rokëmi ba kong ga tja iche bor data jnek. Jnenor pjir ga tja tjwe iröng obi l̈ëmi ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kuya pjl̈urë ga tjl̈ẽ José kong ga «Pja jek ga pjl̈úe. Rokara bop kong sorë l̈i shäryos eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Eni ga José jek ba data jnek, ba pjeyoga tjok. Yorkara tjl̈apgaga parkë l̈öng pjl̈u kong kjl̈obi l̈irë, pjl̈u ëngkjwagaga jëk kwomgl̈a go, jëkkl̈o roy tjok. Nopga öör träk l̇l̇ëme. Ba öng, ba wapga chilawa, e iara Jacob pjeyogarë beno tjeng Gosén kjokyo erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Dipzono l̈ok Jordán diyo kjwo kal̈ëkong pjir ga öötong l̈öng Atad kjokyo, dwl̈a bo kwota shiya l̈okshko. Eshko ga woydono l̈ok ara, sl̈atong, kjl̈oshtono ara, Jacob soyopora dbargwo kjäk (7) José tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ĩya Canaán sopga l̈öng eshko l̈irë ga tjl̈ẽ ga «Egipto sopga woydë ara» l̈e. E kjĩshko ga kjok eshko koiara Abel Misrayin, e ber buk Jordán diyo dl̈o wen tëm shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","E irgo ga Jacob söra ba wapgarë Canaán kjokyo, iara beno buk guëng jong ööng Macpela kjokyo roshko, Mamré kjokyo gomyo. Guëng l̈i tjwl̈ẽna Abrahamdë Efrón kong, l̇l̇ëye tjeng eshko l̈i bako, ber buk sak ba pjeyoga kong wl̈o. L̇l̇ëye l̈ara Jacobdë ba kong l̈i shäryara ba wapgarë eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ba data jnena pjir ga José to jek Egipto kjokyo iröng obi, ba pjeyoga, ba yorkaga uunkong tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jacob wol̈ono kuzong ga José shjiyga wotjl̈ĩk ga «José wotjl̈ĩk bi kong owa dikjoyoe. L̇l̇ëbo shäryoroy ba kong owa kuzong ga l̇l̇ëbo shärye bi kong owa kjwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","E kjĩshko ga no ichara tjl̈ẽ ba kong ga «Bop data wol̈ontë l̇l̇ëm obishko ga tjl̈ẽ bop shjiyga kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Pjãy tjl̈ẽ bop l̈ëng kong ga ‘Bop data tjl̈ẽno beno bop kong ga “Bop shjiyga l̇l̇ëbo shäryono bop kong owa l̈i rokër bop kong sira ga epga shdum e kjĩshko l̇l̇ëme. Epga jnep kësbange” l̈ara bop datarë bop kong eni’ l̈ëmi ba kong” l̈ara. Eni ga roke l̈ok bop kong sira ga epga jnep kësbange, epga bop data Sbö parkagaga» l̈e. Kuya Josérë ga sl̈ar jonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Eni ga José shjiyga tjwe l̈öng kjök tono, kjujono bokdo kjl̈ay kl̈ung go, tjl̈ẽ ba kong ga «Tjawa l̈öng ëre, tjawa bop parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Gueniyo kuya ga tjl̈ẽ ba kong ga «L̇l̇ëye bangkjrëmi l̇l̇ëme. Tja Sbö l̇l̇ëm, pjãy shdun wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Pjãy wotjl̈ĩno l̇l̇ëbo shäryë bor kong owa. Gueniyo bomi wotjl̈ĩk owa l̈i kjl̈opswara Sbörë beno pjl̈ú, nopga ara kjimtokl̈o, wol̈on l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","E kjĩshko ga l̇l̇ëye bangkjrëmi l̇l̇ëme. Pjãy kong dl̈i twër, bomi wapga kong bakoe» l̈e. Eni ga José tjl̈ẽno ba shjiyga kong yõtso, wotöye. Ga epga beno l̈öng wopjl̈ú, woydono ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","25","José beno sök Egipto kjokyo ba pjeyoga tjok. Öötong tjl̈abl̈a, ba wa Efraín tjërga, e wapga ĩna, Manasés wa Maquir, e wapga ĩna bako, wl̈okjrara ba wapga wl̈eni. Pjl̈ara ga tjl̈ẽ ba pjeyoga kong ga «Tja wol̈on döröe. Pjãy kjimtaga ber Sbörë. Pjãy shiya na dwayo. Pjãy söya äär l̈öng kjok twara Abraham, Isaac, Jacob kongshko. Pjãy tjl̈ẽs bor kong jl̈õkoyo ga pjãy shiya Sbörë na dwayoshko ga bor doyo sömi jek bomi tjok l̈ozĩ bor kong jl̈õkoyo eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","José l̈u ĩno öötong sak dbäw kjingsho sak kjwarashko (110) ga wol̈ono buk Egipto kjokyo. E irgo ga ba doyo poshtira, an l̇l̇ëm wl̈o, ga iara beno buk shinmoga bapkwo roshko.");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Domer shäng kjl̈ara ko Elimélec, boy ko Noemí, wapga domerga do pjök ko Majlón, Quilión. Elimélec, e efrateo, Belén so. Belén kjokyo, e Judá tjëyoga kjokyo obi. Israel tjëyoga pjl̈uyo l̇l̇ëm obi dbaryoshko ga pjl̈i shrono ara kjok eshko. E kjĩshko ga Elimélec to jek öötong beno sök Moab kjokyo, ba pjeyoga l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Eshko ga Elimélec shinmotkonoe. Ba boy Noemí beno sök eshko, ba wapga do pjök tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","E irgo ga ba wapga orkwosmono wal̈ëga Moab so tjok, kjl̈ara ko Orfa, kjl̈ara ko Rut. Gueniyo öötong l̈uyo sak kjwara (10) ga ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Majlón, Quilión, e shinmotkono l̈ok. Eni ga Noemí beno sök wa dret, l̈anma dret bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","7","Eshkoshko ga Israel tjëyoga kjimtara Jehovárë, ga pjl̈i dbaryo l̈i pjirae. Roy kura Noemírë eshko Moab kjokyo. E kjĩshko ga wotjl̈ĩk to iröng Judá tjëyoga kjokyo obi, ba pjl̈aydoga do pjök l̈i tjok l̈e. Opshik kjok eshko dwayo kjwl̈ëshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","tjl̈ẽ ba kong l̈ok ga «Pjãy nom jek iröng bomi mekëga shwoy. Tja, bor wapga, tjawa woydoromi, kjimtoromi ara. E kjĩshko ga rokër Jehová kong ga pjãy woyde, pjãy kjimte eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Pjãy kong l̈anma wl̈ẽya jek obi, pjãy ber l̈öng wopjl̈ú bomi ushko wl̈o» l̈e. E irgo ga l̈õ shira, tja toe l̈okl̈o. Kuya l̈ok ga sl̈ar tira l̇l̇ëm, ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ga tjl̈ẽ ba kong ga «L̇l̇ëme. Tjawa jek bop tjok, bop pjeyoga l̈öng l̈ishko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Gueniyo kuya ga tjl̈ẽ ba kong l̈ok ga «Toguëga, pjãy to iröng obi. ¿Pjãy jek bor tjok l̈ëmi kjër l̇l̇ëno? Tja wapga orkwosmok bomi tjok wl̈o ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Pjãy to iröng bomi ushko. Tja këguë anmoyõ, tja orkwosmok obi wl̈o. Tja kjwe orkwosmono eeri jã, ga wapga domerga weno tjeng bor kong jekdo kjwe ga ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","pjãy orkwosmok l̇l̇ëm, äär jong epga äär këkboga dbaryo guing l̇l̇ëme. Pjãy jek bor tjok l̇l̇ëme. L̇l̇ëye weno bomi kong l̈i, e kjange. Gueniyo l̇l̇ëye weno bor kong l̈i, e kjang anmoyõ, Jehová opyono shäng bor wl̈oyo kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Kuya l̈ok ga sl̈atong jek obi. Eshko ga Orfa, ba ëm l̈õ shira, ga briktong toe. Gueniyo Rutda jek pjä ba ëm l̈i go, to rayara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Eshko ga Noemí tjl̈ẽ ba kong ga «Bop kjl̈ara kjwe ĩzong. To jek iröng ba pjeyoga l̈öng l̈ishko. To ba sböpga baĩya poshrëk iröng obi. Pja to ba tjok dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Kuya ga tjl̈ẽ ba kong ga «Pja yorkër woydë jl̈õkoyo. Tja ichëp bop rayë l̇l̇ëme. Pja jek kjone ga tja jek bop tjok eshko. Pja äär sök kjone ga tja äär sök bop tjok eshko. Bop pjeyoga l̈ëp l̈i, e ber bor pjeyoga bakoe. Bop Sbö l̈ëp l̈i, e ber bor Sbö bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Pja shinmotkë äär kjone ga tja shinmotkë ber eshko bakoe. Pja jnekoba kjone ga tja jnekoba eshko bakoe. Tja tjl̈ẽ bop kong jl̈õkoyo ga shji l̈öng së obishko ga pja äär kjone pogo ga pja rayër l̇l̇ëme. Rokër Jehová kong ga shäryoror eni l̇l̇ëm wl̈eni ga tja shdũya» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ĩya Noemírë ga raye woydë Rutdë l̇l̇ëm kuzong ga l̇l̇ëye l̈ara ba kong ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Eni ga jek l̈ok pjöyĩkong. Öötong l̈öng Belén kjokyo ga nopga shdöktong tjl̈ẽ ara. Wal̈ëga eshko so tjl̈ẽ l̈ok ëng kong ga «¿Kjwe Noemí l̇l̇ëmdo?» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Kuya Noemírë ga tjl̈ẽ ba kong l̈ok ga «Tja kowëmi Noemí ame. Jehová, l̇l̇ëye shärye woydë l̈i shärye ga pjl̈úe. Ga tja iara beno sök woydë ara. E kjĩshko ga tja kowëmi Mara shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Tja opshino na dwayoshko ga l̇l̇ë pogo woydër l̈i tjok. Gueniyo tja söra Jehovárë tek iröng or rorëe. Opyono shäng bor wl̈oyo. ¿Eni ga tja kowëmi Noemí sorëro?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Eni ga Noemí opshino tek Moab kjokyo dwayo ba pjl̈aydo Rut, Moab so l̈i tjok. Öötong l̈öng Belén kjokyoshko ga dwl̈a bo kjrozl̈ong dbaryo l̈i soyëba l̈öng kjwl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Domer shäng kjl̈ara ko Booz, e Elimélec, Noemí l̈anma dëna l̈i pjeyo. E dbur ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Dbar kjwara ga Rut tjl̈ẽ Noemí kong ga «Rokër bop kong ga tja ichos jek oba parkë dwl̈a skok l̈öng l̈ishko. Eni ga ëbo, tja iche kjwe dwl̈a bo beno tjeng ba irgo l̈i töng» l̈e. Kuya ga tjl̈ẽ ba kong ga «Jöl̈ö, toguë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Eni ga Rut jek öötong shäng dwl̈a bo kjrëba l̈öng l̈i irgo. Shäng parkëshko l̈i kjokyo sogo, e Booz, Elimélec l̈i pjeyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Eshko ga Booz tek tjwe shäng Belén kjokyo dwayo ga tjl̈ẽ ba parkagaga l̈öng l̈i kong ga «Miga. Pjãy kjimtaga ber Jehovárë» l̈e. Kuya l̈ok ga tjl̈ẽ ba kong ga «Kjobe. Pja kjimtaga ber Jehovárë bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Eshko ga tjl̈ẽ ba parkagaga tjeng l̈i kägäyo kong ga «¿Wal̈ë shäng kjwe ë pjeyo?» ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","«Kjwe Moab so. Wal̈ë to tek Noemí tjok Moab kjokyo dwayo l̈i kjwe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Kjok shröngto ga tjl̈ẽ bor kong ga “Tja ichos dwl̈a bo l̇l̇ë beno tjeng ba skogaga irgo l̈i töng sira” l̈e. Ga “Jöl̈ö” l̈ër ba kongshko ga jek parkë, ga beno shäng parkë kjweshko. Woshtono shäng eeri jã ukwang kjwe dorko» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Eshko ga Booz jek Rut zl̈ong bäng, ga tjl̈ẽ ba kong ga «Chiya, tja kuzong. Pja dwl̈a bo töng shto obl̈ë l̇l̇ëme. Pja ber shäng jũshko bor parkagaga wal̈ëga tjeng wl̈e tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Domerga to l̈öng dwl̈a bo skok tjeng l̈i töngshko ga pja parkë jek ba irgo. Pja twe l̈ok tjötö l̇l̇ëme l̈oror bor parkagaga domerga kong tjän. Ga pja wodogroshko ga di kjrëp di bapkwo dl̈ina domergarë tjeng wl̈e roy dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Kuya ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, tjl̈ẽ ga «Tja shto obl̈ë so. ¿Bop bokso ga tja pjl̈úe l̈ëp ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","«Pja roy kuror uunkong. Bop l̈anma wol̈ono tek l̈ëkong ga bop ëm, e kjimtëp shäng ara. Bop data, bop mekë, bop kjok, e rayorop pjir, ga pja to tek shrono beno sök nopga miydëp l̇l̇ëm l̈öng l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Jehová, e Israel tjëyo Sbö. Pja opyono beno sök ba sjä̃gä dirko wl̈eni, pja de wl̈o. Eni ga rokër ba kong ga pja potjwl̈ẽya, l̇l̇ëye shäryorop l̈i kjĩshko» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Kuya ga tjl̈ẽ ba kong ga «Woydër ga bop bokso ga tja pjl̈úe l̈ëp ĩyado. Bop tjl̈õkwo, tja ie dbokjrë jek obi. Tja tjwl̈õ l̇l̇ëm, bop parkagaga wal̈ëga tjeng wl̈e dorko. Eni ëmdë ga pja tjl̈ẽ shäng bor kong yõtso, wl̈ẽpe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ga öötong iozl̈ong dl̈oyo goshko ga Rut rokara Boozdë, tjl̈ẽ ba kong ga «Pja tegö. Pjl̈ung shosho suk pjir wl̈e kjros, ga pös kjil̇l̇gwo bo dyo shpoä wl̈e go, ga uozong» l̈e. Kuya ga wl̈oktëng sök parkagaga tjeng l̈i tjrëko, ga kong dwl̈a jnena tjeng l̈i twara Boozdë ba kong kjwöböso. Eni ga kjrara, uara beno shäng bö tjung, wopjl̈ú, ga beno obie. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","E irgo ga jek dwl̈a skok tjeng l̈i töng obi, ga Booz tjl̈ẽ ba parkagaga l̈öng l̈i kong ga «Iëmi dwl̈a töng kjone pogoshko, tö̃ya töng tjeng dl̈uw wl̈eshko ëmdë ga wẽyẽ. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Dwl̈a skomi, tömishko ga l̈omi pjl̈öbö pjl̈öbö, tö̃ya bomi irgo wl̈o. Ga kong l̇l̇ëye l̈ëmi l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Eni ga Rut dwl̈a bo töno shäng kjok eshko äär jong kjok sënge. E irgo ga kjwokära bayo gök kësbang tjung wl̈eni kjwo sak kjwara (10). ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","E irgo ga söra jek u l̈ok l̈ishko, ga pina ba ëm kong. Dl̈i twara ba kong l̇l̇amo l̈i shira, twara ba kong, ue wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ĩya ga tjl̈ẽ ba kong ga «¿Eerishko ga pja dwl̈a bo töng shäng kjone? ¿Pja parkë shäng kjone? Pja kjimtara kjok sogo l̈irë ara kjĩshko ga rokër Jehová kong ga e kjimte ara bakoe» l̈e. Kuya ga tjl̈ẽ ba kong ga «Tja parkono domer shäng kjl̈ara ko Booz tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Kuya ga tjl̈ẽ ba kong ga «Eni ga rokër Jehová kong ga e kjimte. Jehová, shji nopga l̈öng së obi l̈i kjimte jl̈õkoyo. Nopga wol̈ono tjän l̈i kjimte bakoe. Shji kjimte bi pjeyoga soshko tjeng l̈irë kjl̈uwe. Ga bi pjeyoga kjl̈ara jũni, e Booz» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Eshko ga tjl̈ẽ ba ëm kong ga «Tja ichara ber shäng eshko, ba parkagaga wal̈ëga tjeng l̈i tjok, äär dwl̈a bo kjrozl̈ong dbaryo pjitong guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Kuya ga tjl̈ẽ ba kong ga «Toguë, pja ber shäng ba parkagaga wal̈ëga tjeng l̈i tjok ga ber bop kong pjl̈úe. Pja jek shto obl̈ë kjwe ga l̇l̇ëbo wen bop kong owa kjwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Eni ga Rut beno shäng parkë Booz parkagaga wal̈ëga tjeng l̈i tjok, dwl̈a bo kjrozl̈ong dbaryo pjitong guing. Gueniyo beno sök ba ëm shwoy. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Dbar kjwara ga Noemí tjl̈ẽ Rut kong ga «Toguë, pja kong l̈anma wl̈ẽn kjl̈ara, pja ber sök shtoyo pjl̈ú wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Booz, pja parkë shäng ba parkagaga wal̈ëga tjeng l̈i tjok, e bi pjeyo. Kuzong. Eeri shkëyo ga to ba dwl̈a kjwokäk. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Eni ga pja nom wë, pja poshtis poshtikkl̈o l̈õ pjl̈ëbl̈ë go, ga pja doyos shwong pjl̈ú wl̈eniyo go. E irgo ga pja to parkë shäng l̈ishko, gueniyo pja opping wẽl̈ë ba kong l̇l̇ëm, äär iono, di iono pjir guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Eshko ga pë buk kjoneshko ga ĩp yõtso. E irgo ga pja jek ba zl̈ong bäng, ba kjinyokl̈o dre l̈ëkong l̈i kjëp, ga pja opbuk buk eshko. Eshko ga l̇l̇ëye shäryëp wl̈o l̈i l̈e bop kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Kuya ga tjl̈ẽ ba kong ga «L̇l̇ëye l̈ëp bor kong l̈i shäryër eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Eni ga opshino to jek eshko, ga l̇l̇ëye l̈ara ba ëmdë ba kong kës l̈i shäryara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Ga Booz iono, di iono pjirshko ga beno shäng wopjl̈úe. E irgo ga jek opbuno, pë buk dwl̈a töng tjeng dl̈uw l̈i zl̈ong bäng. Wop tjok ga Rut jek shäng wora wora, öötong shäng ba zl̈ong bäng, ba kjinyokl̈o dre l̈ëkong l̈i kjara, ga opbuno buk eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Kjok rong dik ga Booz buk l̈i pol̇l̇äk, ga wol̇l̇eno. Ga workwë jek kal̈ëkongshko ga kuya ga wal̈ë buk ba dre zl̈ong bäng kjl̈ara, ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","ga tjl̈ẽ ba kong ga «¿Pja ëro?» «Tja bop parkaga Rut. Tja kjimte bor pjeyoga soshko kjl̈ara jũni l̈irë kjl̈uwe. Ga kjl̈ara jũni, e pja. Woydër ga pja orkwosmok bor tjok» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Kuya ga tjl̈ẽ ba kong ga «Chiya, rokër Jehová kong ga pja kjimte. Domerga dwl̈as bor kjinmo tjeng ara. Kjone kjone dbur ara, kjone kjone song wl̈eniyo. Wl̈ẽnop kjl̈ara jũni kjwe, orkwosmok bop tjok wl̈o. Gueniyo shäryorop eni l̇l̇ëme. Tja bop l̈anma shinmotkono l̈i pjeyo kjĩshko ga pja opshäryono beno ba kong pjl̈ú, l̇l̇ëye shäryorop pjl̈ú ba kong dënashko l̈i kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Chiya, l̇l̇ëye bangkjrëp l̇l̇ëme. L̇l̇ëye l̈ëp bor kong l̈i shäryër. Bor pjeyoga kjok ëre so l̈öng kës l̈i ommiydë ga pja wal̈ë wotjl̈ĩk pjl̈ú wl̈eniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","»Jl̈õkoyo ga tja bop pjeyo soshko. Gueniyo domer shäng kjl̈ara obi, bop pjeyo soshko anmoyõ bor kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Eeri shkëyo ga pja ber buk na. Bong kjok shröngto ga tja to l̈an ba tjok, pja dere, de pja de woydë l̇l̇ëmde, e miydër wl̈o. Pja de woydë ga pja de. Gueniyo woyde l̇l̇ëm ga l̈ër bop kong jl̈õkoyo Jehová ko go ga pja dër. Pja pos buk bop shtoshko kjwey äär jong bong kjok shröng guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Gueniyo pja öör buk na, woydër ga miydëba l̇l̇ëme» l̈e. Eni ga pono beno buk ba dre zl̈ong bäng. Gueniyo wẽshko kjok shröng, kjok sĩ obishko ga kojono, opshik ey dwayo wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Eshko ga Booz tjl̈ẽ ba kong ga «Bop kjinyokl̈o kjwe skwos, ga shas yõtso, roshko dwl̈a iër wl̈o» l̈e. Shäryara eni, ga dwl̈a iara Boozdë kjringgwo tjer (6) söya wl̈o, ga toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut öötong shäng ba ëm shwoy ga Noemí tjl̈ẽ ba kong ga «Toguë, ¿pja öör sorë?» l̈e. Kuya ga l̇l̇ëye l̈ara Boozdë ba kong l̈i l̈ara ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ga tjl̈ẽ ba kong ga «Dwl̈a ëre twara bor kong, ga tjl̈ẽ bor kong ga “Pja jek shäng iröng bop ëm shwoy or rorë l̇l̇ëme” l̈e bor kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kuya ga tjl̈ẽ ba kong ga «Toguë, koshos, l̇l̇ëye wen ĩp wl̈o. Eeri ga domer l̈i woshtë l̇l̇ëm, l̇l̇ëbo l̈i l̇l̇gweya pjir guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","E wopro ga Booz jek öötong shäng kjok eshko opzrëzl̈ong shtoyo, ga wl̈oktëng sök eshko. Ga ĩya wop tjok ga Rut pjeyo soshko l̈ara l̈i jek shäng eshko ga tjl̈ẽ ba kong ga «Kjl̈ara, pja tegö. Pja sirkes sök jũshko» l̈e. Kuya ga jek sirkeno sök ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Eshko ga tjl̈apgaga rokara Boozdë dogl̈o sak kjwara (10), tjl̈ẽ ba kong l̈ok ga «Pjãy tegö. Pjãy sirkek l̈öng jũshko» l̈e. Kuya l̈ok ga jek l̈öng sirkergö tjeng ba tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Eshko ga tjl̈ẽ domer l̈i kong ga «Noemí tek shrono sök iröng Moab kjokyo dwayo, ga wotjl̈ĩk sök kjok soynek. Kjok, e bi pjeyo Elimélec, ba l̈anma shinmotkono l̈i ĩ. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ba pjeyo soshko anmoyõ l̈i pja. E kjĩshko ga woydoror ga pja ommiydë, tjwl̈ẽp wl̈o. E tjwl̈ẽp jl̈õkoyo l̈os tjl̈apgaga tjeng jũshko, tjl̈apgaga kjok l̇l̇gwega wl̈eniyo bokshto. Tjwl̈ẽp woydë ga tjwl̈ẽzong. Gueniyo tja ba pjeyo soshko bakoe. Pja bäm go, irgo tja. E kjĩshko ga tjwl̈ẽp woydë l̇l̇ëm ga l̈os bor kong, miydër wl̈o» l̈e. Kuya ga tjl̈ẽ ga «Enira tjwl̈ẽn» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Kuya ga tjl̈ẽ ba kong ga «Kjok, e Noemí, Elimélec syãyo l̈i ĩ. Ba wa shinmotkono l̈i syãyo ko Rut, e Moab so. Kjok l̈i ber Elimélec tjëyo tek ber ba irgo l̈i ĩ ĩyado wl̈o, ga tjwl̈ẽnopshko ga pja orkwosmok Rut tjok kjl̈uwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Kuya ga tjl̈ẽ ba kong ga «Enira kjok l̈i tjwl̈ẽn l̇l̇ëm dey. Tjwl̈ẽnor ga kjok botoya jer bor shjiryo kjwe. Tjwl̈ẽn ga äe. E kjĩshko ga tjwl̈ẽs pjarë dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Eshko dbaryo ga Israel tjëyoga sdëkwo tjok obi. Kjok l̇l̇ë soynek wl̈o ga ba soynega, kjupkwo iokl̈o skwe kjwara, ga twe ba tjwl̈ẽga kong. Kjok soyneya, tjwl̈ẽya eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Eni ga domer l̈i, kjupkwo iokl̈o skwara kjwara, ga twara Booz kong, tjl̈ẽ ga «Kjok l̈i tjwl̈ẽs pjarë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Eshko ga Booz tjl̈ẽ tjl̈apgaga l̈öng l̈i kong, nopga l̈öng kës l̈i kong ga «Eeri ga pjãy uunkong ber l̈öng ba miydaga. Elimélec, Quilión, Majlón, e kjok kës l̈i tjwl̈ẽnor Noemí kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ga Majlón syãyo ko Rut, Moab so l̈i kjroror beno sök bor boy, kjok l̈i ber Majlón tjëyo tek ber ba irgo l̈i ĩ ĩyado wl̈o, Majlón roy jer l̇l̇ëm wl̈o bakoe. Pjãy uunkong ber ba miydaga» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Tjl̈apgaga l̈öng l̈i, nopga l̈öng kës l̈i, Booz tjl̈õkwo kuya l̈ok ga tjl̈ẽ ga «Jöl̈ö. Tjawa ber l̈öng ba miydaga jl̈õkoyo. Ga rokërwa Jehová kong ga wal̈ë l̈i kong wapga twe ara, twara Israel boyga Raquel, Lea kong sorë ga eni. Rokërwa ba kong obi ga efrateoga tjrëko ga pja ie ber domer tjwl̈õ ara wl̈eniyo, ga Belén sopga tjrëko ga pja ie ber roy kësbange. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Judá, Tamar, ba wa Fares kjĩshko ga ba tjëyo tek beno ba irgo l̈i shdöktong träk l̇l̇ëme. Eni ga rokërwa Jehová kong ga wapga twe bomi kong l̈i kjĩshko ga pjãy ie ber l̈öng eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Eni ga Booz orkwosmono Rut tjok, ga pono ba tjok, ga beno shäng kjl̈araso l̇l̇ëm, kjimtara Jehovárë kjĩshko. E irgo ga wa buk kjl̈ara domer. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Eshko ga wal̈ëga eshko so tjl̈ẽ l̈ok Noemí kong ga «¡Jehová poshrëy jl̈õkoyo! Eeri ga kjimtaga twara Jehovárë bop kong kjl̈ara. Rokërwa Jehová kong ga chida l̈i roy ie shdär Israel tjëyoga uunkong kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Pja woyde bop pjl̈aydorë ara. Bop kong ga tjwl̈õ ara, wapga domerga dogl̈o kjäk (7) kjinmo. Ga chida l̈i weno ba kong. E kjĩshko ga pja ie ber mite wl̈eni, ga pja këguëshko ga pja de» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Eshko ga chida l̈i kjrara Noemírë ba wl̈oshko, ga kuna shäng ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","E koiara wal̈ëga eshko so l̈irë Obed, ga tjl̈ẽ l̈ok ga «Noemí wa buk kjl̈ara» l̈e. E irgo ga Obed, e wa Isaí. Isaí, e wa David. ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Fares tjëyo tek beno ba irgo l̈i beno eni: Fares, e wa Jezrón; ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Jezrón, e wa Ram; Ram, e wa Aminadab; ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab, e wa Naasón; Naasón, e wa Salmón; ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmón, e wa Booz; Booz, e wa Obed; ");
INSERT INTO tfrNTpo_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed, e wa Isaí; Isaí, e wa David.");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Domer shäng kjl̈ara ko Jonás, e Amitay wa. Pjl̈ara ga Jehová tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","«Kjok buk kjrina kësbang, kjëryo shäryak ak go pjribri kjókshko ko Nínive. Pja nom eshko. Ga roy sös ba kong ga l̇l̇ëbo owa shärye l̈öng kës l̈i roy kuror, ga epga shdun e kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Gueniyo ga kol̈ara Jonásdë l̇l̇ëm, jek Jope kjokyo shara. Öötong shäng eshko ga kjyong wl̈ẽna buk kjl̈ara ba brikdo, jongya jong Tarsis kjokyo, Jehová töywe wl̈o l̈e. Eni ga oppotjwl̈ẽno, opyono ba roshko, jek äär eshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5","Gueniyo ga pjl̈uk ichara Jehovárë dl̈ung kjing kësbang, dbo ara. Eni ga kjyong sögaga l̈i bë l̈öng dete erä. Wotjl̈ĩk l̈ok ga kjyong dl̈ar l̈e, bangkjre l̈ok träk l̇l̇ëm, ga kjl̈ara kjl̈ara kjarga l̈öng syõshtë, kjl̈oshtë ba sböpga kong. Eshko ga ba kjyong jer pir l̇l̇ëm wl̈o ga kjyong roshko l̇l̇ëbo tjeng kës l̈i shira, dbura l̈ok jer dl̈ung roshko. E wopro ga Jonás beno buk pë dew, kjyong roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Eni ga kjyong söga kägäyo jer Jonás bukshko ga tjl̈ẽ ba kong ga «¿Pja pë kjër ega? ¡Pja kojõs mal̈ing kjwey dwayo! ¡Pja syõshtos bop sbö kong, shji songe l̈e kjwe, shji wol̈on l̇l̇ëm wl̈o!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","E irgo ga kjyong sögaga l̈i tjl̈ẽ l̈ok ëng kong ga «Kjweri, shji l̇l̇ëbo jyãgl̈o dbuk, l̇l̇ëbo owa jũ l̈aga ërë ĩy wẽl̈ë wl̈o» l̈e. Shäryara l̈ok eni, ga miydara e go ga wl̈oyo Jonásdë. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Eni ga tjl̈ẽ l̈ok ba kong ga «L̈os borwa kong ga ¿l̇l̇ëbo owa tjwe borwa kong ega? ¿Pja pak l̇l̇ë? ¿Pja tek kjone dwayo? ¿Pja kjone so? ¿Pja tjëyo kjone dey?» ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_9","033_1_9","JON","1","9","10","«Tja hebreo. Jehová, e bangkjrotë. E Sbö, kjok uunkong shäryaga, dl̈ung ëre shäryaga bakoe. Tja ëre to shäng ba töywë» l̈e ba kong. Kuya l̈ok ga bangkjrara ara, tjl̈ẽ ba kong ga «¿Shäryëp eni ega?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Eshko ga dl̈ung poyong dbo kjrë jek këgong këgong, ga tjl̈ẽ l̈ok ba kong ga «¿L̇l̇ëye shäryërwa bop tjok, dl̈ung ëre sl̈an ber buk tjëkso wl̈o?» ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","«Tja dbuzĩ jer dl̈ung roy, ga dl̈ung kjwe ber buk tjëkso dani. Miydër pjl̈ú ga pjl̈uk to tek l̈öng kës bi kjing go ëre wl̈oyo tjarë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Eshko ga kjra l̈ara l̈ok dbo go, kjyong tjye l̈ok pjöshko l̈ara, gueniyo dl̈ung iirkono ara anmoyõ kjĩshko ga tjye ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Eni ga rokara Jehová kong ga tjl̈ẽ l̈ok ga «Jehová, tjawa iëp wol̈on, domer ëre zrörwa kjĩshko l̇l̇ëme. L̇l̇ëbo owa shäryara l̇l̇ëm wl̈eni ga owa ëre iëp ber pjang borwa go l̇l̇ëme. Jehová, l̇l̇ëbo uunkong ëre shäryaga l̈i pja» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","L̈ara l̈ok pjir ga Jonás dbura l̈ok jer dl̈ung roy, ga dl̈ung kjing shkuno, beno buk tjëkso. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ĩya l̈ok ga Jehová bangkjrara l̈ok, ga l̇l̇ëbo söra, twara ba kong, ga tjl̈õkwo l̈ara ba kong jl̈õkoyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Gueniyo ga mã dl̈ung roy so ichara Jehovárë kësbang kjl̈ara, Jonás dwe wl̈o. Ga Jonás beno sök mã l̈i bö roy dbargwo mya, shkër dbae. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Eni ga Jonás sök mã l̈i bö roshkoshko ga syõshtono ba Sbö Jehová kong. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","«Jehová, tja woydëshko ga pja rokoror, ga tja kar dboryorop. Tëm dl̈ung dorong dwayo, tja wol̈on döröshko ga pja rokoror, ga tja kurop. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Tja ichorop jer dl̈ung dorong, ga tja popnena dl̈ung mäs l̈irë. Ba pjl̈ubl̈ún këskës l̈i to jek bor kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Kur ga tja iorop beno sök tjoksa. Bop u ĩn ame l̈oror. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Tja jnena dl̈ung dyorë uunkong, tja kjingara dl̈ung rong l̈irë, dl̈ung kjl̈o sho opl̇l̇gwing jong bor dl̈u go. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Tja opl̈ono jer öötong shäng dl̈ung dl̈upyo jer äärshko. Kur ga tja shduna, iara beno sök eshko ĩyado. Gueniyo ga tja wol̈ontoshko ga tja dörop. Pja bor Sbö Jehová. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Kur ga tja wol̈on döröshko ga Jehová, pja woyoshroror, ga bor syõ öötong bop shwoy, öötong bop u jong l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ëye mär sböpga jyãgl̈o go ga kjimtëp ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Gueniyo bor tjl̈õkwo pjl̈ú go ga l̇l̇ëbo sör, twër ber bop kong. L̇l̇ëye l̈oror bop kong jl̈õkoyo l̈i shäryër eni. ¡Jehová, bor döga l̈i pja eröe!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Eni ga mã l̈i ichara Jehovárë Jonás tjwë dl̈ung kjako. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","E irgo ga Jehová tjl̈ẽno Jonás kong jek obi. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","«Kjok buk kjrina kësbang, kjëryo shäryak ak go pjribri kjókshko ko Nínive. Pja nom eshko. Ga l̇l̇ëye l̈ër bop kong l̈i l̈ëp ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Eni ga Sbö tjl̈õkwo l̈i kol̈ara, ga to jek Nínive kjokyo. Kjok, e kësbang, shji jek u ĩk ba roshko wl̈o ga woydara dbargwo mya. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jonás jëktong shäng ba roshko dbar kjwara ga tjl̈ẽ nopga kong ga «Äär dbargwo sak pkëng (40) ga Nínive kjokyo ëre pjiya Sbörë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Kuya l̈ok ga tjl̈õkwo kjrarae. Ga tjl̈ẽ l̈ok ëng kong ga «Shji ië l̇l̇ëm Sbö kong» l̈e. Eshko ga nopga uunkong shwong pjuno shtëgro së ä wl̈eniyo, ba woowa l̈i ĩya Sbörë wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Roy öötong Nínive so pjl̈uyo kongshko ga kojono ba sökkl̈o sökshko dwayo, ga shwong onmo pjl̈ú l̈i skwara, shwong shtëgro së ä wl̈eniyo pjuna, ga wl̈oktong sök töshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","E irgo ga pjl̈u, ba pjl̈oyoga, e kjibokwo tono kjwara, miyde kjok eshko sopga uunkongdë wl̈o. Kjibokwo l̈i tjl̈ẽ ga «Shji ië l̇l̇ëme. Öng l̇l̇ë së̃y l̇l̇ëm, kong di twëy l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Shwong shtëgro së ä wl̈eniyo, e pjũzĩ, bi woowa l̈i ĩya Sbörë wl̈o. Ga pjãy kjl̈oshtos jl̈õkoyo Sbö kong. L̇l̇ëye owa shäryëmi l̈öng ĩyado l̈i rayozĩa. Pjãy opshäryë owa, oba zrök, oba shpok, e rayozĩ bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Eni wl̈eni ga Sbö wotjl̈ĩk l̈i kjl̈opswë, ba iir l̈i l̈õya, sl̈õya, ga shji pjiya l̇l̇ëm kjwe.» ");
INSERT INTO tfrNTpo_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Ĩya Sbörë ga l̇l̇ëbo owa shärye l̈öng l̈i rayara kjĩshko ga epga songe l̈ara, ga l̇l̇ëye shärye ba tjok l̈ara l̈i shäryara eshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","E kjĩshko ga Jonás iirkono ara, ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","ga syõshtono Jehová kong, tjl̈ẽ ga «Jehová, tja kuzong. Tja shäng bor kjokshko obishko ga miydoror ga ëre shäryë jũni, ga l̈oror bop kong pjire. E kjĩshko ga tja töktong jek Tarsis kjokyo. Miydër ga pja Sbö, pja wopjl̈ú anmoyõ, nopga songe l̈ëp ĩyado, pja iirkë wl̈o ga kjange. Nopga shdum l̈ëpshko ga l̇l̇ëbo wl̈ẽp woydë obl̈ë obl̈ë enido, shdum l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","»Eni ga rokër bop kong ga tja ios wol̈on jekdo. Tja ber sök së ame dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Kuya ga tjl̈ẽ ba kong ga «¿Pja iirkë kjweni ga pjl̈úre?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Eshko ga Jonás opshino kjok eshko dwayo, jek öötong sök kjok buk dl̈o wen tëm shwo l̈ëkong. Eshko ga ukwang shäryara kjwara, ga beno sök ba dirko, l̇l̇ëye shäryë kjok buk l̈i tjok ĩya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Eshko ga kji sho iara Sbö Jehovárë wen jong kjl̈ara Jonás kopshko, ber sök wopjl̈ú wl̈o. Kji sho l̈i kjĩshko ga Jonás woowa l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Gueniyo wẽshko kjok shröngto ga shtätä ichara Sbörë, kji sho l̈i ue wl̈o, ga sho dano beno drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Dl̈o wenoshko ga pjl̈uk kjl̈ik ichara Sbörë weno jong dl̈o wen tëm shwo l̈ëkong dwayo, ga dl̈o jong bek Jonás kä kjing go. Eni kuzong ga kuya mae, wopjir kjoyo, wol̈on woydë erä. Ga tjl̈ẽ ga «Tja sök së woydë ame» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Kuya Sbörë ga tjl̈ẽ ba kong ga «¿Pja iirkë kji sho dano l̈i kjĩshko ga pjl̈úre?» «Ëng. Bor kong ga pjl̈úe. Tja sök ëreshko wol̈on iirdë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Kuya ga tjl̈ẽ ba kong ga «Kji sho kjwe dgaga pjarë l̇l̇ëm, kungga pjarë l̇l̇ëm bakoe. Shkër kjwara ga weno, wẽshko ga kjëtonge. Gueniyo ga songe l̈ëp. ");
INSERT INTO tfrNTpo_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Nínive kjokyora nopga ara, sak dbäw dbäw pjl̈ogl̈o sak dbäw kjingsho sak dbäw dbäw pjl̈ogl̈o sak pjök (120,000) kjinmo. L̇l̇ëye pjl̈úre, de oware, e miyde l̈ok l̇l̇ëme. Eshko ga öng ara bakoe. ¿Eni ga songe l̈ër l̇l̇ëm sorë?» l̈e.");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo, e David tjëyo, Abraham tjëyo bakoe. Ëre ba data, ba kjokë, ba tjl̈apgaga tek dënashko dwayo, e kjibokwoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, e Isaac data. Isaac, e Jacob data. Jacob, e Judá data, ba shjiyga, ba l̈ëmga data bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá, e Fares data, Zera data bakoe. Epga mekë ko Tamar. Fares, e Esrom data. Esrom, e Aram data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, e Aminadab data. Aminadab, e Naasón data. Naasón, e Salmón data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón, e Booz data. Booz mekë ko Rajab. Booz, e Obed data. Obed mekë ko Rut. Obed, e Isaí data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí, e Pjl̈u David data. David, e Salomón data. Salomón mekë, e dënashko ga Urías boy. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón, e Roboán data. Roboán, e Abías data. Abías, e Asa data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, e Josafat data. Josafat, e Joram data. Joram, e Uzías data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías, e Jotam data. Jotam, e Acaz data. Acaz, e Ezequías data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías, e Manasés data. Manasés, e Amón data. Amón, e Josías data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías, e Jeconías data, ba shjiy, ba l̈ëmga data bakoe. E dbaryoshko ga Israel tjëyoga zanaba, söraba jek Babilonia kjokyo dbo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Eshko tek l̈ëkong ga wapga weno obi. Jeconías, e Salatiel data. Salatiel, e Zorobabel data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel, e Abiud data. Abiud, e Eliaquim data. Eliaquim, e Azor data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor, e Sadoc data. Sadoc, e Aquim data. Aquim, e Eliud data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud, e Eleazar data. Eleazar, e Matán data. Matán, e Jacob data. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob, e José data, María l̈anma. María, e Jesús mekë. Oba tjl̈ẽ ga no pjl̈uyo ichara Sbörë shrono shäng l̈i, e Jesús. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham wapga, tjërga, tek l̈ëkong tjwe jong David go beno wapga öötong kop eni dogl̈o sak kjwara kjingsho pkëng (14). David wapga, tjërga, tek l̈ëkong tjwe jong Israel tjëyoga söraba jek Babilonia kjokyo dbo go dbaryoshko beno wapga öötong kop eni dogl̈o sak kjwara kjingsho pkëng (14). Eshko dwayo ba wapga, tjërga, tek l̈ëkong tjwe jong no pjl̈uyo iche l̈e Sbörë l̈i buk dbaryoshko beno wapga öötong kop eni dogl̈o sak kjwara kjingsho pkëng (14) bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo, e bukshko ga eni. Kjogl̈o shäng kjl̈ara ko María. Domer shäng kjl̈ara ko José. Tjl̈õkwo twono ëng kong, orkwosmok wl̈o. Gueniyo orkwosmoydë l̈ok l̇l̇ëm obishko ga María beno shäng kjl̈araso l̇l̇ëm, Sbö Sëya ĩ. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, e domer pjl̈o bek, ga María rote woydë ë kong l̇l̇ëme. E kjĩshko ga raye kjingtëng l̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Woyotjl̈ĩya shärye eni l̈eshko ga Tjl̈apga parkaga kjok dogo so weno shäng ba kong kjl̈ara yoshko, ga tjl̈ẽ ba kong ga «José, David tjëyo, pja orkwosmok María tjok ga bangkjrëp l̇l̇ëme. Shäng kjl̈araso l̇l̇ëm, Sbö Sëya ĩ. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","L̇l̇ono ga María wa buk kjl̈ara domer. Eshko ga koiëp Jesús. Koiëp eni, ba tjëyoga döya l̇l̇ëbo owa shärye l̈öng l̈i dbo dorko dwayo kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Shäryono eni, tjl̈õkwo l̈ara Tjl̈apgarë ba tjl̈õkwo l̈aga kong dënashko l̈i ber jl̈õkoyo wl̈o. Tjl̈ẽno beno eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Kjogl̈o domer miydoydë l̇l̇ëm obi l̈i, e ber shäng kjl̈araso l̇l̇ëme. Wa buk kjl̈ara domer, ga koiëba Emanuel.» (Emanuel, e «Sbö shäng bi tjok» l̈okl̈o.) ");
INSERT INTO tfrNTpo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","25","José wol̇l̇enoshko ga l̇l̇ëye l̈ara Tjl̈apga parkaga kjok dogo sorë l̈i shäryara eni, ga María wl̈okjrara. Gueniyo José pono ba tjok l̇l̇ëm, äär jong chida l̈i buk guing. Eni ga wa buk kjl̈ara domer, ga koiara Josérë Jesús. E irgo ga beno l̈öng pjöyĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús weno buk Belén kjokyo, e Judea kjokyo obi. E dbaryo ga kjok eshko so pjl̈uyo ko Herodes. Eshkoshko ga domerga l̇l̇ëbo miydë ara dbala go wl̈eniyo, e tek shrono l̈öng Jerusalén kjokyo, dl̈o wen tëm shwo l̈ëkong dwayo ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","tjl̈ẽ oba kong ga «¿Judío pjl̈uyo weno buk kjone? Ba dbala ĩnorwa, ga tjawa tek l̈öng ba poshrëk» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kuya Pjl̈u Herodesdë ga beno sök woydë ara. Jerusalén sopga beno l̈öng eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eshko ga syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e rokara pjl̈urë uunkong, ga tjl̈ẽ ba kong l̈ok ga «¿No pjl̈uyo iche l̈e Sbörë l̈i wen buk kjone?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","«E wen buk Belén kjokyo, e Judea kjokyo obi. Tara beno Sbö tjl̈õkwo l̈aga tek dënashko sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","»“Belén kjokyo, pja Judá tjëyoga kjokyo obi. Bor nopga Israel tjëyo pjl̈uyo wen kjl̈ara bop kjok kjing go. E kjĩshko ga pja tjwl̈õ tira l̇l̇ëm kjok ëre kjing goshko.”» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eni ga domerga shrono dl̈o wen tëm shwo l̈ëkong dwayo l̈i rokara pjl̈urë tjoksa l̈ũtshko. Ga epga kjĩshko ga miydara ga dbala weno pjang l̇l̇onoshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","E irgo ga tjl̈ẽ ba kong ga «Pjãy nom Belén kjokyo, ga kjwozirwa wl̈ẽmi yõtso. Wl̈ẽnomi ga pjãy tek iröng, ga roy sömi bor kong, tja jek ba poshrëk bako wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kuya l̈ok ga toe. Ga dbala ĩna weno pjang l̈i jek pjang ba bäm go, ga sl̈an äär pjang kjwozirwa sök l̈i kopshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Dbala l̈i ĩya l̈ok ga beno l̈öng wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eshko ga opzrëno jek l̈ok u l̈i roshko, ga kjwozirwa ĩna sök ba mekë María tjok. Eshko ga kjök tono, ga kjwozirwa l̈i poshrëra. E irgo ga dbur sho shõyl̈ṍr, l̇l̇ëbo l̈õ pjl̈ëbl̈ë tjwl̈õ ara wl̈eniyo, dwl̈o poshtikkl̈o l̈õ pjl̈ëbl̈ë, e shira, twara ba kong ba sënggl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","E irgo ga Sbö tjl̈ẽ ba kong yoshko ga «Pjãy jek pjl̈u shwo l̈ëkong l̇l̇ëme» l̈e. E kjĩshko ga irbo shano obl̈ë, ga to jek l̈ok iröng obi ba kjokshko eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Domerga l̈i briktong irgo ga Tjl̈apga parkaga kjok dogo so weno José kong kjl̈ara yoshko, ga tjl̈ẽ ba kong ga «Kjwozirwa l̈i wl̈ẽya Pjl̈u Herodesdë, zröya wl̈o l̈e. E kjĩshko ga pja kojõzong. Kjwozirwa, ba mekë, e sös na dwayo. Pjãy nom tök Egipto kjokyo. Pjãy ber l̈öng eshko, äär jong l̇l̇ono l̈ër bop kong guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","E shkëyo ga José kojono, ga kjwozirwa, ba mekë, e söra to jek Egipto kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Öötong beno l̈öng eshko, Pjl̈u Herodes wol̈ono guing. Shäryono eni, tjl̈õkwo l̈ara Tjl̈apgarë ba tjl̈õkwo l̈aga kong dënashko l̈i ber jl̈õkoyo wl̈o. Tjl̈ẽno beno eni: «Bor wa rokoror Egipto kjokyo dwayo.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Miydara Herodesdë ga jyãpgwara domerga tjwe dl̈o wen tëm shwo l̈ëkong dwayo l̈irë ga iirkono ara anmoyõ. Dbala weno pjang l̇l̇onoshko l̈ara domerga l̈irë ba kong kjĩshko ga nopga ichara kjwozirga domerga l̈u pjl̈ogl̈o pjök ter l̈ëkong l̈öng Belén kjokyo l̈i zrök uunkong, kjwozirga l̈u eni l̈öng ba soshko l̈i tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Eni ga tjl̈õkwo l̈ara Sbö tjl̈õkwo l̈aga tek dënashko so Jeremíasdë l̈i beno jl̈õkoyo. Tjl̈ẽno beno eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ramá kjokyo ga ybö pjl̈uk ara, sl̈ar ara, kjl̈oshtë ara. E Raquel, ba wapga wol̈ono, ga sl̈ar sök ba kjĩshko, wojekoba woyde l̇l̇ëme.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes wol̈onoshko ga Tjl̈apga parkaga kjok dogo so weno shäng kjl̈ara José kong yoshko Egipto kjokyo, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tjl̈ẽ ba kong ga «Nopga l̈öng kjwozirwa zrök woydë kjupä l̈i wol̈onoe. E kjĩshko ga pja kojõzong. Kjwozirwa, ba mekë, e sös jek na dwayo. Pjãy nom jek Israel kjokyo iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eni ga José kojono, ga kjwozirwa, ba mekë, e söra to jek iröng Israel kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gueniyo kuya ga Arquelao parkë sök Judea so pjl̈uyo, ba data Herodes shtoshko ga jek eshko ga bangkjre ara. Eni ga Sbö tjl̈ẽ ba kong yoshko ga «Pjãy jek Judea kjokyo l̇l̇ëme» l̈e. E kjĩshko ga to jek Galilea kjokyo shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Öötong eshko ga jek l̈öng Nazaret kjokyo, ber l̈öng eshko wl̈o. Shäryono eni, tjl̈õkwo l̈ara Tjl̈apgarë ba tjl̈õkwo l̈agaga kong dënashko l̈i ber jl̈õkoyo wl̈o. Tjl̈ẽno beno eni: «No pjl̈uyo iche Sbörë tjwe l̈i kowëba Nazaret so.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","L̈u to jek ara irgo ga domer weno shäng kjl̈ara ko Juan No Waga. E jëk to shäng Judea kjok dogro no l̇l̇ëmshko, tjl̈ẽ oba kong ga «Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo äätoe. E kjĩshko ga l̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈ozĩ, ga rayozĩa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kjibokwo tara Sbö tjl̈õkwo l̈aga tek dënashko so Isaíasdë. Tjl̈ẽno beno eni: «Kjok dogro no l̇l̇ëmshko ga ëbo tjl̈ẽ shäng dbo go ga “Irbo poshäryozĩ Tjl̈apga tjwe l̈i kong. Shäryozĩ ber beke.”» Ëbo tjl̈ẽ shäng dbo go l̈ara l̈i, e Juan l̈ayde. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Eshkoshko ga Juan doyë shwong sek öng jëkkl̈o sok kësbang zok go, dop pjrikkl̈o shäryak öng kwota go bakoe. Ba dl̈i beno sekwa, or kjl̈oshko so dyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén sopga, Judea sopga, Jordán diyo kjokyo sopga, e shrono l̈öng träk l̇l̇ëm ba kuk. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Eshko ga kjone kjone, l̇l̇ëbo owa shäryara l̈i l̈e oba uunkong bokshto. E irgo ga we Juandë jer Jordán diyo roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Eshko ga nopga tjeng kjring pjök ko fariseoga, saduceoga. Ĩya Juandë ga tjwe l̈öng ba shwoy we wl̈o ga tjl̈ẽ ba kong ga «¡Pjãy so dgur kjoyoe! ¿Nopga owa shdũzl̈ong dbaryo dörö l̈ishko ga pjãy där l̈aga ërë bomi kongdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pjãy jëk pjl̈o beke. Miydëba e go ga l̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈oromi, ga rayoromi jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","L̈ër bomi kong ga akkwo ëre ëmdë shärye Sbörë ber Abraham tjëyoga ga pjl̈úe. E kjĩshko ga “Tjawa Abraham tjëyoga kjĩshko ga tjawa shdũya Sbörë l̇l̇ëme” l̈ëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Zër e” l̈e Sbörë shäng. Kjor botjyë pjl̈ú l̇l̇ëm wl̈eniyo tjeng kës l̈i ze jek tas, dbuya iök roy, suya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","»Ëye, l̇l̇ëbo owa shärye l̈öng l̈i, e owa jl̈õe l̈ara, ga rayara ga wër shäng di goshko. Gueniyo ga no tjwe bor irgo kjl̈ara. Bek wl̈o ga tja ba drepkwota sök wl̈o l̇l̇ëm, e tjwl̈õ ara bor kjinmo anmoyõ kjĩshko. Era, pjãy we iök go, ga pjãy go Sbö Sëya iche tjwe ber kësbang bomi tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tjwe kjwl̈ë tjok, dwl̈a pjl̈oyong wl̈o wl̈eni. Dwl̈a pokeshko ga dwl̈a bo tö̃ya ber tjeng ba bapkwo roy. Gueniyo ba kasho l̈ira suya iök roy. Iök l̈i pjë jong ri ri ĩyado, sjer l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús opshino jek Galilea kjokyo dwayo, öötong shäng Jordán diyo, Juan shängshko, we wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Gueniyo we woydë Juandë l̇l̇ëme. Tjl̈ẽ ba kong ga «Pja tek shäng bor shwoy, pja wër wl̈o l̈ëp, gueniyo tja waga pjarë dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kuya ga tjl̈ẽ ba kong ga «Ios ber eni guing. Shäryëy jũni, woyde Sbörë eni kjĩshko» l̈e. Kuya ga «Jöl̈ö» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Eni ga Jesús wara jer di roshko. Wara pjir ga Jesús opshik tëm shäng di roy dwayoshko ga kjok dogo roshwino beno oojong erä. Ga ĩya Jesúsdë ga Sbö Sëya to ter kjok dogo dwayo so dunggwo kjoyo, ga opyono sök ba go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eshko ga ybö kuraba kjok dogo dwayo, tjl̈ẽ ga «Bor wa l̈i kjwe. Kjwe woydër ara. Tja wopjl̈ú ba tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","E irgo ga Jesús söra Sbö Sëyarë jek öötong shäng kjok dogro no l̇l̇ëmshko, tjl̈ĩya Ärë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eshko ga iono l̇l̇ëm Sbö kong dbargwo sak pkëng (40), shkë dbae. E irgo ga pjl̈i jonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Eni ga Ä jek äär shäng Jesús tjl̈ĩk, l̇l̇ëbo shärye owa wl̈o l̈e. Tjl̈ẽ ba kong ga «Pja Sbö Wa jl̈õkoyo ga akkwo tjeng ëre posgos ber pjl̈ung shosho suk pjir, uëp wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kuya ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: »“No mär dl̈i goshko dö l̇l̇ëme. Mär tjl̈õkwo l̈e Sbörë l̈i go bakoe”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","E irgo ga söra Ärë jek öötong shäng kjok zrek ko Jerusalén, Sbö u kësbang jong l̈ishko. Eshko ga söra jem, öötong shäng Sbö u dbo go, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: »“Ba parkagaga kjok dogo so iche Sbörë bop dë, pja shaya ba orkwo go, pja dre pjë akkwo go l̇l̇ëm wl̈o.” E kjĩshko ga pja Sbö Wa jl̈õkoyo ga pja optos jer na dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kuya ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni bakoe: »“Tjl̈apga, bop Sbö l̈i tjl̈ĩy l̇l̇ëme”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","E irgo ga söra Ärë jem öötong shäng dl̈up jong kjókshko dbo go, ga kjok kjwang jĩkong kjrina kjrina l̈i pina ba kong uunkong, wol̈ësowa ĩya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Eshko ga tjl̈ẽ ba kong ga «Pja kjök tok, tja poshrëp wl̈eni ga kjok uunkong ëre twër ber bop kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kuya ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: »“Tjl̈apga, bop Sbö l̈i poshrëmirë döe. E kol̈omirë döe.” E kjĩshko ga Ä, pja opkjos na dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eni ga Ä opkjono ey dwayo ga toe. Eshko ga Sbö parkagaga kjok dogo so shrono l̈ok Jesús kjimtë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan bängzaraba shäng no shdũzl̈ong uyo roshko l̈i roy kuya Jesúsdë ga to jek Galilea kjokyo iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gueniyo beno sök Nazaret kjokyo l̇l̇ëme. To jek Capernaúm kjokyo, ga beno sök eshko shara. Capernaúm kjokyo, e ber buk di bäng buk kësbang, shkung, so dl̈ung kjoyo l̈i sor go, Zabulón tjëyoga, Neftalí tjëyoga dëna l̈öngshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Shäryono eni, tjl̈õkwo l̈ara ba tjl̈õkwo l̈aga tek dënashko so Isaíasdë l̈i ber jl̈õkoyo wl̈o. Tjl̈ẽno beno eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zabulón tjëyoga, Neftalí tjëyoga, e kjokyo ber buk Jordán diyo kjwo kal̈ëkong, di bäng buk kësbang, shkung, so dl̈ung kjoyo ko Galilea l̈i kjako, nopga judío l̇l̇ëm wl̈eniyo l̈öngshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kjok eshko sopga jëk l̈öng kjok ro sĩ roshko wopro ga iök shjiy ĩna l̈ok kësbang kjwara. “Nopga l̈i wol̈ono tjeng pjire” l̈araba, gueniyo iök shjiy weno ba kong kjwara, dl̈o wen tëm pjang kjok shröngto wl̈eni.”» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eshko jek l̈ëkong ga Jesús beno shäng tjl̈ẽ oba kong ga «Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo döröe. E kjĩshko ga l̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈ozĩ, ga rayozĩa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Domer shäng kjl̈ara ko Simón, e kowëba Pedro bakoe. Domer shäng kjl̈ara obi ko Andrés, e Simón l̈ëng. Epga mã shaga. Pjl̈ara ga l̈öng ba kjl̈a mã shakkl̈o dbuk Galilea di bäng buk kësbang shkung, so dl̈ung kjoyo l̈i roshko. Eshko ga Jesús jek shäng diksor go, ga ĩya ga domerga l̈i bë l̈önge. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Eshko ga tjl̈ẽ ba kong ga «Pjãy tek bor tjok, pjãy pin wl̈o. Pjãy to l̈öng mã shak ame. Pjãy iër to ber l̈öng no töng bor kong shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kuya l̈ok ga ba kjl̈a rayara jekdo, ga to jek ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jek këgo sit ga domerga l̈öng do pjök ko Santiago, Juan. E data Zebedeo. Epga l̈öng ba kjl̈a mã shakkl̈o bängyë kjyong roshko ba data tjok. Ga Jesús jek shäng eshko ga domerga do pjök l̈i ĩna, ga rokara jek ba tjok, opping ba tjok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kuya l̈ok ga ba data rayara jekdo, beno sök ba kjyong roshko, ga to jek l̈ok Jesús tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Eshko ga Jesús jëk to shäng Galilea kjokyo kjok kjwang jĩkong. Kjok kjrina kjrina ga oba pĩya judíoga syõ uyo l̈ok kjwobi l̈i roshko. Sbö ber no pjl̈uyo sorë l̈i roy pjl̈ú l̈e oba kong, ga oba swl̈o l̇l̇ë ara, l̇l̇ayo boyo bang ara, e popte. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eni ga Jesús roy shdöktong Siria kjokyo kjok kjwang jĩkong, ga swl̈opga sökoba tjwe ba kong, no swl̈o l̇l̇ërba pogo tjok, no pogl̈o l̇l̇ë bang ara, no goshko Ä sëyaga, no wopjir ä wl̈eniyo, no dre kuga l̇l̇ëm wl̈eniyo, ga poptara uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilea sopga, Decápolis sopga, Jerusalén sopga, Judea sopga, Jordán diyo kjok ber buk dl̈o wen tëm shwo l̈ëkong l̈i sopga, e to jek l̈ok ba tjok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ĩya Jesúsdë ga nopga ara ga poyono sök dl̈up go. Eshko ga ba oppinggaga tek shrono l̈öng ba zl̈ong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","pina. Tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ëye songe l̈e, l̇l̇ëye pjl̈ú twe Sbö kong wl̈o drete l̈e ga era ber wopjl̈ú, Sbö ber ba pjl̈uyo kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ëye sl̈ar ëë ga era ber wopjl̈ú, wojeya Sbörë kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ëye wotöy ga era ber wopjl̈ú, l̇l̇ono ga kjok uunkong twe Sbörë ba kong, ber baĩya wl̈o kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ëye, l̇l̇ëye woyde Sbörë l̈i shärye woydë ara, no pjl̈i ara l̈i dl̈i uë woydë wl̈eni, no wodogro l̈i di ië woydë wl̈eni bako ga era ber wopjl̈ú, kjimte Sbörë ba shäryë kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ëye, obl̈ë songe l̈e ĩyado ga era ber wopjl̈ú, songe l̈e Sbörë bako kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ëye Sbö woydë jl̈õkoyo ba pjl̈úshko, l̈e kjamo go dö l̇l̇ëm ga era ber wopjl̈ú, l̇l̇ono ga Sbö ĩya kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ëye oba wl̈ẽpyotkë, ber l̈öng wopjl̈ú ëng tjok wl̈o ga era ber wopjl̈ú, kowe Sbörë ba wa kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ëye shdungoba, l̇l̇ëye woyde Sbörë l̈i shärye kjĩshko ga era ber wopjl̈ú, Sbö ber ba pjl̈uyo kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","»Pjãy wl̈ongoba, pjãy shdungoba, pjãy jyõyotkëba bor kjĩshkoshko ga pjãy ber wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Eshkoshko ga pjãy woydë l̇l̇ëme. Pjãy ber wopjl̈ú dey. Pjãy äär kjok dogoshko ga pjãy potjwl̈ẽn ara. Dënashko ga Sbö tjl̈õkwo l̈agaga shdunaba eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","»Pjãy so dl̈ungna kjoyo, nopga l̈öng kjok ëre kjing go kong. Gueniyo dl̈ungna pjl̈ë ameshko ga iëy ber pjl̈ë ba shtoy iröng obi ga äe. Eshko ga l̇l̇ëno ame. Dbuy ber tjeng irbo bang, shgl̈ëkoba wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","»Pjãy so iök shjiy kjoyo, nopga l̈öng kjok ëre kjing go kong. U l̈ok dl̈up dbo go jney ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iök shjiy borkey, jney l̇l̇ëbo dorko wl̈o l̇l̇ëme. Iëy jong kjókshko dey, kãl̈ã të shjiy nopga l̈öng ushko kjl̈obi l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pjãy ber l̈öng iök shjiy wl̈eni. Pjãy jëk l̈öng bëy oba bokshto, l̇l̇ëye shäryëmi l̈i ĩkoba wl̈o, bomi Data sök kjok dogo l̈i poshrëkoba wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","»Tja shrono shäng kjok l̇l̇gwekkl̈o tara Moisésdë l̈i kjaga l̈ëmi l̇l̇ëme. Tja shrono shäng l̇l̇ëye l̈ara Sbö tjl̈õkwo l̈agaga tek dënashko sorë l̈i kjaga l̈ëmi l̇l̇ëm bakoe. E eni l̇l̇ëme. Tja shrono shäng l̇l̇ëye l̈ak jl̈õkoyo l̈i, e l̇l̇ë l̈okl̈o l̈ë bomi kong, miydëmi wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","L̈ër bomi kong jl̈õkoyo ga kjopkwo, kjok ëre pjitë l̇l̇ëm obishko ga tjl̈õkwo tak l̈ok kjok l̇l̇gwekkl̈o l̈i jer kjwara l̇l̇ëm, shäryono uunkong guing, tjl̈õkwo chirawayo ëmdë eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","»Eni ga ëye kjok l̇l̇gwekkl̈o tara Moisésdë l̈i kjë kjrina, ba chirawayo ëmdë, ga obl̈ë pĩya eni bako ga Sbö sök no pjl̈uyo ĩyado l̈ishko ga tjwl̈õ sira l̈i e l̈ëba eshko. Gueniyo ëye omkol̈ë, ga obl̈ë pĩya ba kol̈ë bako ga Sbö sök no pjl̈uyo ĩyado l̈ishko ga tjwl̈õ ara l̈i e l̈ëba eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¡Tja kuzĩa! Woyde ga l̇l̇ëye woyde Sbörë l̈i shäryëmi pjl̈ú, fariseoga kjinmo, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go kjinmo bakoe. Shäryëmi eni l̇l̇ëm ga pjãy äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","»“Shji no zrök l̇l̇ëme. Ëye no zröno ga e shdungko” l̈araba tjl̈apgaga tek dënashko so kong eni. Tjl̈õkwo ëre kuromi tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gueniyo l̈ër bomi kong ga ëye iirkono ba kjl̈ara kong ga e shdungko. Ëye “Pja makrae” l̈ono ba kjl̈ara kong ga sökoba Judío Kjok L̇l̇gwegaga Këskësyo kong, shdũya wl̈o. Ëye ba kjl̈ara äyoshtono ga e jek shäng irbo äär jong iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","»E kjĩshko ga pjãy jek äär öng sho sukkl̈o Sbö sënggl̈o tjokshko ga woyoshrëmi ga bomi kjl̈ara shäng iirkë bomi tjok wl̈eni ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Sbö sënggl̈o l̈i rayëmi ber sök eshko, pjãy nom ba l̇l̇gwek bomi kjl̈ara tjok, pjãy ber wopjl̈ú ëng tjok wl̈o. Pjir ga pjãy jek iröng Sbö sënggl̈o söromi l̈i twë ga pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","»Pjãy sökoba no l̇l̇gwega shwoy l̈ëbashko ga pjãy l̈an bomi söga l̈i tjok bäm goshko, pjãy ie ber tjeng tjl̈apga wl̈oshko l̇l̇ëm wl̈o. Shäryëmi eni l̇l̇ëm ga pjãy twe tjl̈apga l̈irë ba parkagaga kong, pjãy shdũya wl̈o, ga pjãy ie ber l̈öng no shdũzl̈ong uyo roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","L̈ër bomi kong jl̈õkoyo ga pjãy opshik eshko dwayo l̇l̇ëm, äär jong dburwa kjöme l̈ara bomi kong l̈i potjwl̈ẽnomi pjir guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","»“Shji pë oma boy obl̈ë tjok l̇l̇ëme” l̈araba kuromi eni tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gueniyo l̈ër bomi kong ga ëye wal̈ë obl̈ë ĩk, wotjl̈ĩk ba pjl̈úshko ba woydë dö wl̈eni ga l̇l̇ëbo owa shäryara, pono ba tjok wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","»Bomi bokkwo, pjãy iche l̇l̇ëbo owa shäryë wl̈eni ga shimi pjus, dbumi pjola, e bomi bokkwo pjl̈úyo ëmdë. Bomi doyo, e dbuya jer uunkong iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko l̇l̇ëm wl̈o ga shäryëmi eni dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bomi orkwo, pjãy iche l̇l̇ëbo owa shäryë wl̈eni ga zëmi tas, dbumi pjola, e bomi orkwo pjl̈úyo ëmdë. Bomi doyo, e jer uunkong iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko l̇l̇ëm wl̈o ga shäryëmi eni dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","»“Ë pogo ba boy rayono ga ëng rayono kjibokwoyo twe ba kong dey” l̈araba kuromi eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Gueniyo l̈ër bomi kong ga domer ba boy rayono, pono domer obl̈ë tjok kjĩy l̇l̇ëm ga ba boy orkwosmok obl̈ë tjok wl̈eni ga owa l̈i ber ba go, gueniyo ba go dö l̇l̇ëme. Owa l̈i ber ba rayaga l̈i go, e ber ba l̈anma kjl̈ara obi l̈i go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","»“Tjl̈õkwo l̈oromi jl̈õkoyo Tjl̈apga ko go l̈i shäryozĩ eni ĩyado” l̈araba bi tjl̈apgaga tek dënashko so kong eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Gueniyo l̈ër bomi kong ga pjãy tjl̈ẽ jl̈õkoyo Tjl̈apga ko go l̇l̇ëme. Pjãy tjl̈ẽ jl̈õkoyo kjok dogo so ko goshko l̇l̇ëm, kjok dogo, e Sbö pjl̈u sökkl̈o wl̈eni kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pjãy tjl̈ẽ jl̈õkoyo kjok ëre so ko go l̇l̇ëm bako, kjok ëre, e ba kjupkwo shto wl̈eni kjĩshko. Pjãy tjl̈ẽ jl̈õkoyo Jerusalén kjokyo kjĩshko l̇l̇ëm bako, e no pjl̈uyo kësbang l̈i kjokyo kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pjãy tjl̈ẽ jl̈õkoyo bomi kägä kjĩshko l̇l̇ëm, bomi käkzong, e iëmi ber sĩ, l̇l̇ëm ga pjl̈ubl̈ún pjl̈ara l̇l̇ëm kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pjãy l̈an ëng tjokshko ga “Ëng” l̈ëmi, “L̇l̇ëme” l̈ëmi. Pjãy l̈an ber ëng tjok eni döe. Tjl̈õkwo l̈ëmi obl̈ë obi ga e l̈aga Ärë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","»“Ëye obl̈ë bokkwo shino kjwara ga e bokkwo shikko kjwara bakoe. Ëye obl̈ë orkwo zono tas kjwara ga e orkwo zako tas kjwara bakoe” l̈araba kuromi eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gueniyo l̈ër bomi kong ga ëye l̇l̇ëbo owa shäryono bomi kong ga wẽyẽ, kar l̇l̇ëbo owa shäryëy ba kong l̇l̇ëme. Pjãy kwomso kël̈ë shpora obl̈ërë ga mil̈ëkong twëmi ba kong, shpoya wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pjãy rote obl̈ërë tjl̈apgaga kjok l̇l̇gwega wl̈eniyo kong, bomi shwong ter l̈ëkong l̈i döya wl̈o l̈e ga bomi shwong kop l̈ëkong l̈i twëmi ba kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ëngkjwaga, pjãy iche ba l̇l̇ëbo sök dbo go äär wop kjöme l̈e bomi kong ga äär jong eshko ga sömi ba kong eni pjl̈ara obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ë pogo tjwe bomi shwoy l̇l̇ëbo rokë ga twëmi ba kong. No tjwe l̇l̇ëbo poskwong bomi kong ga “L̇l̇ëme” l̈ëy ba kong l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","»“Bi kjl̈ara, e woydako, ga bi moskwo, e woydako l̇l̇ëme” l̈araba kuromi eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Gueniyo l̈ër bomi kong ga bomi moskwoga woydozĩ ara. Pjãy syõshtos Sbö kong, bomi shdunggaga kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Enira pjãy jëk bomi Data sök kjok dogo l̈i wapga wl̈eni. Dl̈o shäryara l̈i ie të nopga pjl̈o bek kong, nopga owa kong bakoe. Shunyo iche shrë nopga jëk bëy l̈i kjing go, nopga jëk owa l̈i kjing go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","¿Bomi woydagaga woydomirë dö wl̈eni ga pjãy potjwl̈ẽkkl̈o l̇l̇ë l̈ëmiro? ¿Pjãy tjl̈ẽ ga nopga dbur töngga Roma so kong, e owa, gueniyo epga omshäryë e kjoyo l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","¿“Miga” l̈ëmi bomi pjeyoga kong erö wl̈eni ga l̇l̇ë shäryomirëro? Nopga Sbö miydë l̇l̇ëm wl̈eniyo omshäryë eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bomi Data sök kjok dogo l̈i, e pjl̈o bek, dir l̇l̇ëme. Pjãy ber l̈öng pjl̈o bek, dir l̇l̇ëm, baĩya dik bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","»Pjãy l̇l̇ëbo pjl̈ú shäryëshko ga shäryëmi ĩkoba wl̈o l̇l̇ëme. L̇l̇ëm ga pjãy potjwl̈ẽya bomi Data sök kjok dogo l̈irë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","»E kjĩshko ga nopga song wl̈eniyo kjimtoromishko ga roy shdömi ë kong l̇l̇ëme. Nopga Sbö tjl̈õkwo söga jl̈õkoyo l̈e, gueniyo wotjl̈ĩk owa ba pjl̈úshko l̈i omshäryë eni judíoga syõ uyo roshko, irbo pjl̈obi bäng goshko, opposhrëk e go wl̈o. L̈ër bomi kong jl̈õkoyo ga potjwl̈ẽkkl̈o tjok tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","»Gueniyo pjãyda nopga song wl̈eniyo kjimtëshko ga shäryëmi l̈ũtshko, miydaga ërë l̇l̇ëm wl̈o. Enira pjãy potjwl̈ẽngga ber bomi Data sök bomi ĩk l̈ũtshko l̈irë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","»Pjãy syõshtë Sbö kongshko ga pjãy ber l̈öng nopga Sbö tjl̈õkwo söga jl̈õkoyo l̈e, gueniyo wotjl̈ĩk owa ba pjl̈úshko l̈i dik l̇l̇ëme. Epga syõshtë l̈öng kojong nopga arashko, judíoga syõ uyo roy, irbo pjl̈obi bäng goshko, ĩkoba wl̈o. L̈ër bomi kong jl̈õkoyo ga potjwl̈ẽkkl̈o tjok tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","»Gueniyo pjãyda syõshtëshko ga pjãy opzrëk jek kjër roshko, ga kjër bängzami tuke. Pjãy syõshtë bomi data kong l̈ũtshko. Enira pjãy potjwl̈ẽngga ber bomi Data sök bomi ĩk l̈ũtshko l̈irë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","»Pjãy syõshtëshko ga tjl̈õkwo l̈ëmi jek ba bokjing obi l̇l̇ëme. Nopga Sbö miydë l̇l̇ëm wl̈eniyo omshäryë eni. Tjl̈õkwo l̈e ara kjĩshko ga kuya Sbörëro l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pjãy opshäryë baĩya dik l̇l̇ëm, l̇l̇ëbo rokomirë l̇l̇ëm obishko ga l̇l̇ëye woydëmi l̈i miydara bomi Datarë pjir tjän kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","»Pjãy syõshtë Sbö kong eni. »“Data, pja sök kjok dogo, bop ko, e ber kësbang, dboye. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pja tjwe ber sök borwa pjl̈uyo wl̈o. Kjok dogo ga l̇l̇ëye woydëp sorë ga shäryë eni ĩyado. Ichos ga shäryë kjok ëre kjing go eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dl̈i woydërwa l̈i twos borwa kong, eeri wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","L̇l̇ëbo shäryara obl̈ërë borwa kong owa l̈i iororwa beno tjwl̈õ l̇l̇ëm sorë ga owa pjang borwa go l̈i l̈ö̃s ber dret eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tjawa iëp ber l̈öng borwa tjl̈ĩzl̈ong l̈ishko l̇l̇ëme. Tjawa dös Ä wl̈oshko dwayo.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","»L̇l̇ëbo shäryara obl̈ërë bomi kong owa l̈i ioromi beno tjwl̈õ l̇l̇ëm ga owa pjang bomi go l̈i l̈ö̃ya bomi Data sök kjok dogo l̈irë ber dret eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gueniyo l̇l̇ëbo shäryara obl̈ërë bomi kong owa l̈i ioromi beno tjwl̈õ l̇l̇ëm wl̈eni l̇l̇ëm ga owa pjang bomi go l̈i l̈ö̃ya bomi Datarë l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","»Pjãy ië l̇l̇ëm Sbö kongshko ga pjãy ber l̈öng nopga Sbö tjl̈õkwo söga jl̈õkoyo l̈e, gueniyo wotjl̈ĩk owa ba pjl̈úshko l̈i dik l̇l̇ëme. Epga opyë l̈öng bokkwo woydë, ĩkoba wl̈o. L̈ër bomi kong jl̈õkoyo ga potjwl̈ẽkkl̈o tjok tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","»Gueniyo pjãyda ië l̇l̇ëm Sbö kongshko ga pjãy bokkwo shkwë, pjãy poshäryë yõtso, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pjãy l̈öng ië l̇l̇ëm l̈i miydëba l̇l̇ëm wl̈o. Miydaga ber bomi Datarë eröe. Enira pjãy potjwl̈ẽngga ber bomi Data sök bomi ĩk l̈ũtshko l̈irë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","»Pjãy parkë bomi kong om go, l̇l̇ëbo tjwl̈õ ara tömi kjok ëre kjing go wl̈o l̇l̇ëme. L̇l̇ëye tömi jũshko l̈i ue ba sëyarë dret, srer dret, l̈ũyotkëba bomi shjiryo dret bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pjãy parkë ber l̈öng Sbö kong dey, l̇l̇ëbo tjwl̈õ ara l̈i ber bomi kong kjok dogo wl̈o. Eshko ga l̇l̇ëbo l̈i ue ba sëyarë l̇l̇ëm, srer l̇l̇ëm, l̈ũyotkëba l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bomi l̇l̇ëbo tjwl̈õ ara l̈i töng tjeng kjone ga pjãy wotjl̈ĩk eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","»Iök shjiy ĩgömi wẽl̈ë bomi bokkwo go. Bomi bokkwo pjl̈ú wl̈eni ga bomi doyo uunkong iök shjiy tjok wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Gueniyo bomi bokkwo owa wl̈eni ga bomi doyo uunkong kjok ro sĩ wl̈eni. Eni ga pjãy kjok ĩgö l̇l̇ëm ga pjãy l̈öng kjok ro yẽt erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","»Ëye parkë pjl̈u do pjök kong ga äe. Shärye eni wl̈eni ga kjl̈ara woyde, kjl̈ara woyde l̇l̇ëme. Ber pjl̈ú kjl̈ara tjok, ber owa kjl̈ara tjok. Pjãy wo pjang dbur go ĩyado wl̈eni ga pjãy parkë Sbö kong ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","»L̈ër bomi kong ga shji woydë l̇l̇ëme. Shji woydë dl̈i kjĩy l̇l̇ëm, di kjĩy l̇l̇ëm, shwong kjĩy l̇l̇ëm bakoe. Pjãy l̈öng së, e tjwl̈õ ara, bomi dl̈i kjinmo. Bomi doyo, e tjwl̈õ ara, bomi shwong kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sënwa dbuk to l̈öng sorë ĩzĩa. Dwl̈a dgue l̇l̇ëm, bo kjre l̇l̇ëm, jneya ba jnekkl̈o uyo roy l̇l̇ëm bakoe. Gueniyo së̃ya bomi Data sök kjok dogo l̈irë. ¡Ga pjãyda tjwl̈õ ara, sënwa kjinmo! ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","»¿Pjãy woydë ara ga l̇l̇ëye shimi e goro? Bomi l̈u iëmi om go dbar kjwara obi ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Pjãy woydë bomi shwong kjĩshko ega? Nana kjl̈oshko so ĩzĩa. Parkë l̇l̇ëm, shwong sek l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Eni ëmdë ga l̈öng wol̈ësowa ĩyado. L̈ër bomi kong ga Pjl̈u Salomón l̇l̇ëbo ara anmoyõ. Gueniyo doyono wol̈ësowa, öötong nana kjl̈oshko so ĩ dik l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kjl̈o sho l̇l̇ë doye Sbörë eni, eeri ga l̈ok pjl̈ú, bong ga sukoba gueniyo. ¿Pjãy doye e kjinmo anmoyõ l̇l̇ëmdo? ¿Pjãy mär Sbö go jl̈õkoyo l̇l̇ëm ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","»E kjĩshko ga pjãy woydë l̇l̇ëme. “¿L̇l̇ëye uëy? ¿L̇l̇ëye iëy? ¿Shji doyë l̇l̇ë go?”, e l̈ëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","L̇l̇ëbo tjeng kës ëre kjĩshko ga nopga Sbö miydë l̇l̇ëm wl̈eniyo woydë arae. Gueniyo pjãyda Data sök kjl̈ara kjok dogo. L̇l̇ëye woydëmi dö l̈i miyde sök pjir tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sbö ber bomi pjl̈uyo sorë l̈i woyotjl̈ĩmi ara, l̇l̇ëbo obl̈ë obl̈ë kjinmo. Tjl̈õkwo l̈ara l̈i shäryozĩ eni. Shäryëmi l̈öng eni ga l̇l̇ëbo obl̈ë woydëmi kës l̈i ber bomi kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","»Pjãy woydë l̇l̇ëye wen bong l̈i kjĩshko l̇l̇ëme. E woyotjl̈ĩmi bong jã ga pjl̈úe. Dbar kjwara kjwara ga l̇l̇ëbo wen bomi kong owa ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","»“No obl̈ë l̇l̇ëbo owa shäryono” l̈ëy ë kong l̇l̇ëm, pjãy l̇l̇ëbo owa shäryono l̈e Sbörë l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Obl̈ë woyotjl̈ĩmi sorë ga pjãy woyotjl̈ĩya Sbörë eni bakoe. Shäryëmi obl̈ë kong sorë ga shärye Sbörë bomi kong eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","»Bomi kjl̈ara bok bäng kjor pjl̈oyo ĩmi kjër. E wopro ga bomi bok roshko kjorkwang buk kjwangna l̈i ĩgömi l̇l̇ëme. ¿Shäryëmi eni egaro? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Pjãy bok roshko kjorkwang buk kjwangnashko ga “Kjor pjl̈oyo buk bop bok bäng kjwe shir bop kong” l̈ëmi bomi kjl̈ara kong sorëro? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! Kjorkwang buk bomi bok roshko l̈i shizĩ bäm go. Enira kjor pjl̈oyo buk bomi kjl̈ara bok bäng l̈i ĩgömi wẽl̈ë, shimi ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","»L̇l̇ëbo Sbö ĩ l̈i twëmi ba wl̈oyoga kong l̇l̇ëm, e so shjiti kjl̈oshko so sëmirë wl̈eni. Eni ga tek workwë bomi kjing go iröng obi, ga pjãy ue. Bomi obrikkwo tjwl̈õ ara wl̈eniyo dbumi köchi kong l̇l̇ëme. Eni ga sho shgl̈ëya bomi shjiryo drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","»L̇l̇ëbo rokozĩ Sbö kong, ga twe bomi kong. L̇l̇ëbo wl̈ẽzĩ, ga wl̈ẽmi. “U bäng bäng dözĩ bor kong” l̈ozĩ, ga där bomi kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ëye l̇l̇ëbo rokë ga e kjre. Ëye l̇l̇ëbo wl̈ẽk ga e wl̈ẽya. Ëye “U bäng bäng dözĩ bor kong” l̈ë ga e där ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","»¿Data kjone dey ga kong dl̈i roke ba warëshko ga kong apkwo twaydero? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Ga kong mã rokeshko ga kong dgur twaydero? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eni ga pjãy nopga owa ëmdë ga pjãy wotjl̈ĩk l̇l̇ëbo pjl̈ú twë bomi wapga kong. Eni wl̈eni ga bomi Data sök kjok dogo l̈i kong l̇l̇ëbo rokëmishko ga pjãy kong l̇l̇ëbo twe pjl̈ú anmoyõ. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","»Eni ga pjãy l̇l̇ëbo shäryos obl̈ë kong, woydëmi ga shärye l̈ok bomi kong sorë ga eni. Pjãy omshäryë enira kjok l̇l̇gwekkl̈o tara Moisésdë l̈i, tjl̈õkwo l̈ara Sbö tjl̈õkwo l̈agaga tek dënashko sorë l̈i, e shäryëmi l̈öng uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","»Pjãy opzrëk jek kjër bäng bam chira l̈i go. Irbo jek jong äär nopga shdũya ber tjeng ĩyado shtoyoshko l̈i, e kjang l̇l̇ëm, kjëryo u bäng bam ee bakoe. Nopga jëk ara e go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gueniyo irbo jek jong äär shji ber l̈öng së ĩyado Sbö tjok shtoyoshko l̈i, e kjang, kjëryo u bäng bam chira bakoe. Nopga jëk e go kjl̈öbö döe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","»No kjone kjone to l̈öng tjl̈ẽ ga “Tja Sbö tjl̈õkwo l̈aga” l̈e, gueniyo ichaga Sbörë l̇l̇ëme. Tek l̈öng bomi shwoy öng wl̈ẽp ushko so wl̈eni, miga pjãy shaywa, ue wl̈o l̈e, shjiti kjl̈oshko so dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kjil̇l̇gwo bo kjrëy shkö sho doyo go l̇l̇ëme. Kjor bo kjrëy shkl̈ik doyo go l̇l̇ëm bakoe. Eni ga l̇l̇ëye shärye nopga l̈irë goshko ga epga sorë miydëmi wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kjor doyo pjl̈ú ga ba bo, e pjl̈úe. Kjor doyo owa ga ba bo, e owa. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kjor bo owa wl̈ẽy kjor doyo pjl̈ú goshko l̇l̇ëme. Kjor bo pjl̈ú wl̈ẽy kjor doyo owa go l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kjor l̈ok bo owa kjl̈obi l̈i kö̃y, suy wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eni ga Sbö tjl̈õkwo l̈agaga kjok ëre so l̈i miydëmi ba bo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","»Oba ara tjl̈ẽ bor kong ga “Pja bor Tjl̈apga jl̈õkoyo” l̈e. Gueniyo epga kjone kjone äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko l̇l̇ëme. Ëye bor Data sök kjok dogo l̈i kol̈ë ga äär ber ba nopga eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","No l̇l̇gwezl̈ong dbaryoshko ga oba ara tjl̈ẽ bor kong ga “Pja borwa Tjl̈apga jl̈õkoyo. Bop tjl̈õkwo l̈ororwa ara. Bop ko go ga Ä sëyaga tjeng oba goshko l̈i ichororwa toe. Bop ko go ga l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryororwa ara” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Gueniyo eshko ga tja tjl̈ẽ ba kong ga “Pjãy bor nopga l̇l̇ëme. Pjãy nopga owa erä. Pjãy opkjos bor shwoy ëre dwayo” l̈ër ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","»Ëye, tja tjl̈õkwo kuya, ga l̇l̇ëye l̈oror l̈i shärye ga e so domer u ywaga kjl̈ara kjoyoe. U shäryarashko ga shwl̈eyo pjl̈ona rong, ga ak iara ba so bäng pjribrie. Shäryara pjir ga shunyo shrono, di to jer, pjl̈uk shrono träk l̇l̇ëm, pjono u l̈i goshko ga to wito l̇l̇ëm, ba shwl̈eyo pjl̈ong l̈ok rong, ak roshko kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","»Gueniyo ëye, tja tjl̈õkwo kuya, ga l̇l̇ëye l̈oror l̈i shärye l̇l̇ëm ga e so domer u ywaga obl̈ë kjoyoe. U shäryarashko ga shwl̈eyo pjl̈ona uriso, rong l̇l̇ëme. Shäryara pjir ga shunyo shrono, di to jer, pjl̈uk shrono träk l̇l̇ëm, pjono u l̈i goshko ga skwara pjir, söra dirë drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tjl̈ẽno pjir ga nopga uunkong l̈öng l̈i beno l̈öng yëy l̈e erä, pina sorë l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tjl̈õkwo l̈ara jl̈õkoyo, dbo ara go, l̈e no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë go l̈irë dik l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","E irgo ga Jesús opl̈ono jer dl̈up dwayoshko, ga nopga to jer ara ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Eshko ga domer shrono shäng Jesús shwoy. Domer l̈i pogl̈o go swl̈o ara, sho an do jĩkong. Öötong shäng Jesús zl̈ong bäng ga kjök tono ba bokshto, tjl̈ẽ ba kong ga «Tjl̈apga, tja poptëp woydë ga tja poptëp ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kuya ga porwara ba orkwo go, ga tjl̈ẽ ba kong ga «Pja poptër woydë. Pja ber pjl̈ú shara» l̈e. Jekdo eshko ga domer l̈i poptono, beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Eshko ga Jesús tjl̈ẽ ba kong ga «Tja kuzong. Pja poptoror l̈ëp ë kong l̇l̇ëme. Pja nom opping syõshtaga Sbö kong nopga kjĩshko l̈i kong, pja ĩya wl̈o eröe. Sbö sënggl̈o l̈ara Moisésdë l̈i söp, twëp ba kong, pja poptono miydëba wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","E irgo ga Jesús opzrëno jek öötong shäng Capernaúm kjokyo. Domer Roma so shäng kjl̈ara eshko, e ëngkjwagaga ara kägäyo. E tek shrono shäng Jesús zl̈ong bäng ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Tjl̈apga, bor parkaga buk swl̈o ara bor ushko. Dre kuga l̇l̇ëm, doyo bang ara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kuya ga tjl̈ẽ ba kong ga «Enira tja jek ba poptë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kuya ga tjl̈ẽ ba kong ga «Tjl̈apga, tja l̇l̇ëno l̇l̇ëm, tjwl̈õ l̇l̇ëm, pja opzrëk tek bor u roshko wl̈o. Bor parkaga poptë l̈ëp erö ga poptë dani. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tja kägäyo tjok. L̇l̇ëye l̈e bor kong l̈i shäryër eni ĩyado. Tja ëngkjwagaga ara kägäyo. L̇l̇ëye l̈ër ba kong l̈i shärye l̈ok eni ĩyado bakoe. “Pja nomo” l̈ër kjl̈ara kong ga toe. “Pja tegö” l̈ër kjl̈ara kong ga teke. Bor parkaga tjwl̈ẽk shäng pjir wl̈eniyo ichër l̇l̇ëbo shäryë ga shärye eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kuya ga beno shäng yëy l̈e erä, ga tjl̈ẽ nopga jëk l̈öng ba tjok l̈i kong ga «L̈ër bomi kong jl̈õkoyo ga domer ëre mär bor go jl̈õkoyo, Israel tjëyoga uunkong kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","L̈ër bomi kong ga nopga judío l̇l̇ëm wl̈eniyo tjwe ara l̇l̇aw pogo dwayo, äär l̈öng ië Abraham, Isaac, Jacob tjok, Sbö sök no pjl̈uyo ĩyado l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Judíogara, epga uunkong äär l̈öng eshko wl̈o. Gueniyo kjone kjone dbuya ber tjeng kjoko, kjok ro sĩ roshko, ber tjeng sl̈ar eshko, kowo uë, l̇l̇ëbo bang ara ba kong kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Eshko ga tjl̈ẽ ëngkjwaga kägäyo l̈i kong ga «Pja nom bop ushko. Woyotjl̈ĩnop sorë ga shäryoror bop kong eni» l̈e, ga ba parkaga l̈i poptono jekdo eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","E irgo ga Jesús jek öötong shäng Pedro ushko ga ba ëm wl̈ẽna buk ba bukkl̈o kjing go, kjl̈irkono buk träk l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eshko ga ba orkwo porwara, ga kjl̈ik l̈i zenoe. Eni ga wal̈ë l̈i kojono, ga dl̈i shäryono ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jek kjok ro zar ga nopga goshko Ä sëyaga söraba ara Jesús kong. Ga Jesús tjl̈ẽno ba kong dö ga Ä sëyaga l̈i to l̈ok ba go dwayo. Swl̈opga l̈öng kjl̈obi l̈i poptara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Shäryono eni, tjl̈õkwo l̈ara Tjl̈apgarë ba tjl̈õkwo l̈aga tek dënashko so Isaías kong l̈i ber jl̈õkoyo wl̈o. Tjl̈ẽno beno eni: «Shji döra bi swl̈o tjeng kës l̈i dbo dorko dwayo.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","E irgo ga ĩya Jesúsdë ga oba tjwe tön ara shäng l̈ishko ga ba oppinggaga ichara dipzë jek di bäng buk kësbang l̈i kjwo kal̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Eshko ga no pingga kjok l̇l̇gwekkl̈o tara Moisésdë go l̈i tek shäng ba zl̈ong bäng kjl̈ara ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, woydër ga pja jek kjone ga tja jek bop tjok eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kuya ga tjl̈ẽ ba kong ga «Shjiti kjl̈oshko so, e pë kl̈ung bäng. Sënwa, e pë ba usho roy. Gueniyo no to ter kjok dogo dwayo ërera woshtozl̈ong shtoyo drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E irgo ga Jesús oppingga kjl̈ara tjl̈ẽ ba kong ga «Tjl̈apga, tja ichos jek bor data ushko sira. Bor data wol̈ono, jnenor sakshko pjir ga tja tekdo iröng bop tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kuya ga tjl̈ẽ ba kong ga «Pja tek bor tjok, pja pin wl̈o dey. Shinmoga ber tjeng ëng jnek wẽyẽ» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","E irgo ga Jesús opyono kjyong roshko ba oppinggaga tjok, ga toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","E irgo ga pjl̈uk tjwe jong träk l̇l̇ëm, dbo ara di bäng buk kësbang l̈i kjing go. Di iõya ara, ga kjyong l̈i pir sek seke. Gueniyo Jesús bë buk pëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eni ga ba oppinggaga jek l̈öng ba wol̇l̇eng, ga tjl̈ẽ ba kong ga «¡Tjl̈apga, tjawa kjimtozong, tjawa shten l̇l̇ëm wl̈o!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kuya ga tjl̈ẽ ba kong ga «¿Bangkjrëmi ega? Pjãy l̈öng mär bor go jl̈õkoyo l̇l̇ëme» l̈e. E irgo ga kojono, ga pjl̈uk, di iõya, e wl̈ona, ga beno tjeng tjëkso. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eni ga epga beno l̈öng yëy l̈e erä. Ga tjl̈ẽ l̈ok ëng kong ga «¿Domer kjwe ëro? Ĩzĩa. Tjl̈ẽno pjl̈uk, di iõya l̈i kong ga kol̈e pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús, ba oppinggaga, e dipzono jek öötong l̈öng di bäng buk kësbang l̈i kjwo kal̈ëkong, Gadara kjokyo. Eshko ga domerga goshko Ä sëyaga l̈öng do pjök. Epga iir äya kjl̈oshko so wl̈eni. E kjĩshko ga ëye jëk irbo e go l̇l̇ëme. Eshko ga domerga l̈i opshino tek sakshko dwayo, tjwe l̈öng Jesús zl̈ong bäng ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tjl̈ẽ ba kong dbo go ga «Sbö Wa, ¿pja tek shäng borwa barwë ega? ¿Pja to tek ëreshko borwa shdung wl̈ore? Borwa shdũzl̈ong dbaryo l̈i äätë l̇l̇ëm obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Epga l̈öng l̈ishko soshko ga köchi tjeng träk l̇l̇ëm, ië. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Eni ga Ä sëyaga l̈i tjl̈ẽ ba kong ga «Rokërwa bop kong sira ga tjawa ichëp domerga pjök ëre rayë wl̈o wl̈eni ga tjawa ichos jek köchi tjeng kjwe go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kuya ga tjl̈ẽ ba kong ga «Pjãy nomo» l̈e. Ga Ä sëyaga l̈i opkjono to l̈ok domerga l̈i go dwayo, jek l̈ok köchi l̈i go shara. Wop eni l̇l̇ëm ga köchi tjeng l̈i zrono jer ri ri dl̈up pogl̈o go, optono l̈ok jer uunkong di bäng buk kësbang l̈i roshko, ga shteno l̈ok dret eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Eni ga köchi dagaga tjeng l̈i töktong jek ey dwayo, ga öötong l̈öng nopga l̈öngshko ga l̇l̇ëye ĩna domerga goshko Ä sëyaga tjok l̈i roy l̈ara nopga kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Eni ga nopga l̈öng eshko l̈i opshino jek l̈ok uunkong, ga öötong l̈öng Jesús shäng l̈ishko ga tjl̈ẽ ba kong ga «Rokërwa bop kong sira ga pja opshis kjok ëreshko dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","E irgo ga Jesús opyono kjyong roshko, ga dipzono jek ba kjokshko iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Eshko ga domer buk töshko kjl̈ara, dre kuga l̇l̇ëm wl̈eniyo, ga söra nopga obl̈ërë l̈ok pogl̈o roshko Jesús zl̈ong bäng. Ĩya Jesúsdë ga swl̈o sögaga l̈i mär ba go ga tjl̈ẽ swl̈o buk töshko l̈i kong ga «Pja wosong l̇l̇ëme. Owa pjang bop go l̈i l̈önor beno drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go l̈öng eshko kjl̈öbö. Kuya l̈ok ga wotjl̈ĩk ga «¡Domer kjwe shäng Sbö l̈ãywë owa, ber tjwl̈õ l̇l̇ëm wl̈o l̈e!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wotjl̈ĩk l̈öng l̇l̇ë l̈i miydara Jesúsdë pjir kuzong ga tjl̈ẽ ba kong ga «¿Pjãy wotjl̈ĩk owa eni ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Owa pjang bop go l̈i l̈önor beno drete” l̈oror ba kong. Gueniyo l̈önorde, de l̈önor l̇l̇ëm, e ĩgömi l̇l̇ëme. Gueniyo ga “Pja kojõzong. Pja jëkzong” l̈oror ba kong ga poptororde, de poptoror l̇l̇ëm, era ĩgömi wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kjok ëre kjing go ga no to ter kjok dogo dwayo ëre dbo ara, owa pjang nopga go l̈i l̈ön ber dret wl̈o ga pjl̈úe. Miydëmi wl̈o ga l̇l̇ëbo shäryër e» l̈e. Eni ga tjl̈ẽ swl̈o buk töshko l̈i kong ga «Pja kojõzong. Bop bukkl̈o kjwe kjros, ga pja nom bop ushko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kuya ga kojono, ga to jek ba ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ĩya l̈öng eshko l̈irë ga beno l̈öng yëy l̈e erä, ga Sbö poshrëra, dbo twara domer kong eni kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","E irgo ga Jesús opshino to ey dwayo. Jek jëk shängshko ga domer sök kjl̈ara eshko ko Mateo, e dbur töngga Roma so kong. E sök ba pak l̈ishko. Ĩya Jesúsdë ga tjl̈ẽ ba kong ga «Pja tek bor tjok, pja pin wl̈o» l̈e. Kuya ga kojono, ga to jek ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","E irgo ga Jesús jek öötong sök ië Mateo tjok ba ushko, ba oppinggaga tjok. Ga nopga dbur töngga Roma so kong öötong l̈öng ië ba tjok eshko, nopga owa wl̈eniyo obl̈ë öötong l̈öng ië ba tjok eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ĩya fariseogarë ga tjl̈ẽ Jesús oppinggaga l̈öng l̈i kong ga «¿Bomi pingga kjwe ië nopga owa wl̈eniyo tjok kjweni ega?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kuya Jesúsdë ga tjl̈ẽ ba kong l̈ok ga «Nopga l̈öng pjl̈ú, swl̈o l̇l̇ëm ga e dwl̈omnega woydë l̇l̇ëme. Swl̈opgara dwl̈omnega woydë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pjãy to opping Sbö tjl̈õkwo go. Tjl̈ẽno beno eni: “Woydër ga obl̈ë songe l̈ëmi. E tjwl̈õ ara, öng zrömi, sho sumi, pjë dret bor poshrëkkl̈o l̈i kjinmo.” Eni ga tja shrono shäng kjok ëreshko, nopga pjl̈o bek rokaga l̇l̇ëm, nopga owa rokaga eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dbar kjwara ga Juan oppinggaga tek shrono l̈öng Jesús shwoy ga tjl̈ẽ ba kong ga «Tjawa ië l̇l̇ëm Sbö kong dbar kop ara. Fariseoga omshäryë eni bakoe. ¿Bop oppinggagara omshäryë eni l̇l̇ëm ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","«Orkwosmozl̈ong dbaryoshko ga domer orkwosmok wl̈o l̈i shäng ba tjok obishko ga nopga mak l̈öng eshko l̈i woydë l̇l̇ëme. Gueniyo domer l̈i söraba ba shjiryoshko ga epga ië l̇l̇ëm eshko jã. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","»Shwong këguë bängyëy shwong l̈ikyo tjagl̈ën go l̇l̇ëme. Shäryoroy eni kjwe ga shwong l̈ikyo tjagl̈ën l̈i, shwong këguë l̈i, e sreya, dwl̈er jek këgong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","»Kjil̇l̇gwo bo dyo dbo ara tjagl̈ën tyëy ba bapkwo këguë shäryak öng kwota go roshko l̇l̇ëme. Shäryoroy eni kjwe ga bapkwo l̈i böptur. Eni ga kjil̇l̇gwo bo dyo l̈i ber l̇l̇ëno ame, ba bapkwo l̈i ber eni bakoe. Eni kuzong ga kjil̇l̇gwo bo dyo dbo ara tjagl̈ën tyëy wl̈o ga woyde bapkwo tjagl̈ën, pjöyĩkong ber tjeng pjl̈ú wl̈o» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús shäng tjl̈ẽ wopro ga judío ichaga tjwe shäng kjl̈ara ba zl̈ong bäng, ga kjök tono, tjl̈ẽ ba kong ga «Bor wa wal̈ë wol̈ono buk eeri jã. Gueniyo pja jek orkwo ië ba kjing go ga woshrë iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kuya ga kojono, ga to jek ba tjok, ba oppinggaga jek ba tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","L̈öng l̈i tjrëko wal̈ë shäng kjl̈ara swl̈o ara l̈u pjl̈ogl̈o sak kjwara kjingsho pjök (12) tjän. Ba dbar ĩya ĩyado, poptë l̇l̇ëme. Eshko ga tek shrono shäng Jesús zl̈ong bäng ba kokso shwo l̈ëkong, ga ba shwong worbo porwara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Wotjl̈ĩk ga «Ba shwong worbo porwër dö ga tja poptë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ĩya Jesúsdë iröng ga wal̈ë bë shäng. Eshko ga tjl̈ẽ ba kong ga «Pja wosong l̇l̇ëme. Pja mär bor go kuzong ga pja poptonoe» l̈e. Ga wal̈ë l̈i poptono jekdo eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","E irgo ga Jesús öötong shäng judío ichaga l̈i ushko ga ĩya ga nopga dbonmo bakwaga poshäryë l̈öng ba shinmo jnek wl̈o, ga nopga sl̈ar wopjl̈uk jong träk l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Eshko ga tjl̈ẽ l̈öng l̈i kong ga «Pjãy opshis na dwayo. Kjogl̈o, e wol̈ono l̇l̇ëme. Buk pë erä» l̈e. Kuya l̈ok ga Jesús joywe l̈ok jong erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Gueniyo ga epga ichara opshik pjire. E irgo ga opzrëno jek öötong shäng kjogl̈o buk l̈ishko, shara ba orkwo go, ga kojono. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","L̇l̇ëbo shäryono eshko l̈i roy shdöktong kjok eshko kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús opshino jek shäng ey dwayo ga domerga l̈öng do pjök kjok ĩgö l̇l̇ëm wl̈eniyo. Öö l̈e jek l̈öng ba irgo, tjl̈ẽ ba kong ga «David tjëyo, tjawa songe l̈ozong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ga Jesús jek öötong shäng ushko ga nopga kjok ĩgö l̇l̇ëm wl̈eniyo l̈i jek äär l̈öng ba irgo. Eshko ga Jesús tjl̈ẽ ba kong l̈ok ga «¿Woyotjl̈ĩmi ga pjãy bokkwo poptër ga pjl̈úe l̈ëmire?» «Ëng, Tjl̈apga» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eni ga ba bokkwo porwara Jesúsdë, ga tjl̈ẽ ba kong ga «Pjãy mär bor go kuzong ga shäryë bomi kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bokkwo poptono pjir ga Jesús tjl̈ẽ ba kong ga «Pjãy poptoror l̈ëmi ë kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Gueniyo opshino jek l̈ok ey dwayo, ga l̇l̇ëye shäryara Jesúsdë ba kong l̈i roy shdöra kjok eshko kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Domerga l̈i opshino pjir ga domer söraba tjwe shäng kjl̈ara, tjl̈ẽ l̇l̇ëm, goshko Ä sëya kjl̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eshko ga sëya l̈i ichara Jesúsdë toe. E irgo ga domer l̈i beno shäng tjl̈ẽ. Ĩya l̈öng l̈irë ga beno l̈öng yëy l̈e erä. Ga tjl̈ẽ ëng kong ga «L̇l̇ëye ĩkdoy Israel kjokyo kjweni l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gueniyo ga fariseoga l̈öng eshko l̈i tjl̈ẽ ga «Ä sëyaga iche to, dbo twara Ä sëya kägäyorë ba kong l̈i go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús to shäng oba ping kjok kjrina kjrina, judíoga syõ uyo roshko. Sbö ber no pjl̈uyo sorë l̈i roy pjl̈ú l̈e oba kong. Oba swl̈o l̇l̇ë ara, l̇l̇ayo boyo bang ara, e poptara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ĩya ga nopga sjeno l̈öng ara, dbo ame. E kjĩshko ga songe l̈e. Wotjl̈ĩk ga epga öng wl̈ẽp ushko so daga l̇l̇ëm wl̈eni l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eni ga tjl̈ẽ ba oppinggaga kong ga «Dwl̈a bo kjrëy wl̈o ga ara, gueniyo parkagaga kjl̈öbö döe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eni ga rokozĩ dwl̈a sogo l̈i kong ga parkagaga wl̈ẽya obi, dwl̈a bo ara l̈i kjre wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús, ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i rokara, ga kong dbo twara, Ä sëyaga tjeng oba goshko l̈i iche to wl̈o, swl̈o obl̈ë obl̈ë, l̇l̇ayo boyo bang ara, e popte wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Domerga kjrara parkë l̈öng Sbö tjl̈õkwo roy l̈agaga ba ãska dogl̈o sak kjwara kjingsho pjök (12) l̈i ko l̈ok eni: Simón, e kowëba Pedro, e ba bäm ĩyo; Andrés, e Simón l̈ëng; Santiago, e Zebedeo wa; Juan, e Santiago kjl̈arayo; ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe; Bartolomé; Tomás; Mateo, e parkono dbur töngga Roma so kong; Santiago, e Alfeo wa; Lebeo, e kowëba Tadeo bakoe; ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, e cananita; Judas Iscariote, e Jesús soynega. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","E irgo ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i ichara jek Sbö tjl̈õkwo l̈ë. Bäm goshko ga tjl̈ẽno ba kong ga «Pjãy jek judíoga shwoy eröe. Pjãy jek nopga judío l̇l̇ëm wl̈eniyo shwoy l̇l̇ëme. Pjãy jek opzrëk Samaria kjokyo l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pjãy to Israel tjëyoga shwoy dey, epga, e öng wl̈ẽp ushko jeno l̈öng wl̈eni kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pjãy nom Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo ääto l̈i roy shdök. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Swl̈opga poptëmia. Shinmoga woshrëmia. Nopga pogl̈o go swl̈o ara, sho an do jĩkong wl̈eniyo poptëmia. Ä sëyaga tjeng oba goshko l̈i ichëmi toe. Pjãy kong dbo twak iguing kuzong ga obl̈ë kjimtëmi iguing bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dbur sho sömi bomi tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Shwong obl̈ë sömi l̇l̇ëm, drepkwota obl̈ë l̇l̇ëm, l̇l̇ëbo bapkwo l̇l̇ëm, kjorkung l̇l̇ëm bako, ëye parkë ga mär ba potjwl̈ẽkkl̈o ba pak ãska l̈i go kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","»Pjãy äär kjone pogo ga no wl̈ẽmi kjl̈ara, miydëmi ga wotjl̈ĩk bëy wl̈eniyo, ga pjãy ber l̈öng ba ushko, äär jong pjãy opshik kjok eshko dwayo guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pjãy äär ushko ga “Pjãy kjimte Sbörë” l̈ëmi ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","E irgo ga e beno bomi kong pjl̈ú wl̈eni ga kjimte Sbörë jl̈õkoyo. Eni l̇l̇ëm wl̈eni ga tjl̈õkwo l̈oromi pjl̈ú l̈i ber ba kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pjãy öötong l̈öng kjone ga pjãy wl̈okjre l̇l̇ëm, pjãy kuya l̇l̇ëm wl̈eni ga pjãy opshik kjok eshko dwayo ga bomi dre pjl̈ungyo l̈ö̃zĩ ber tjeng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","L̈ër bomi kong jl̈õkoyo ga no l̇l̇gwezl̈ong dbaryoshko ga kjok eshko sopga shdũya Sbörë ara, Sodoma sopga, Gomorra sopga, e kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","»Tja kuzĩa. Pjãy ichër jek l̈öng öng wl̈ẽp ushko so jëk l̈öng shjiti kjl̈oshko so l̈öngshko wl̈eni. Eni kuzong ga pjãy jek l̈öng nopga kjok miydë ara wl̈eni, gueniyo pjãy ber l̈öng wl̈ẽp bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pjãy sjëke. Pjãy iëba ber tjeng tjl̈apgaga wl̈oshko, pjãy sökoba äär judíoga syõ uyo roshko, pjãy shpokoba no shpokkl̈o go eshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bor kjĩshko ga pjãy sökoba äär tjeng no ichagaga bokshto, pjl̈upga këskës bokshto bakoe. Eshko ga l̇l̇ëbo ĩnomi, kuromi l̈i roy l̈ëmi ba kong, nopga judío l̇l̇ëm wl̈eniyo kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gueniyo ga pjãy shakobashko ga pjãy woydë l̇l̇ëm, “¿L̇l̇ëye l̈ër?” l̈ëmi l̇l̇ëm, “¿L̈ër sorë?” l̈ëmi l̇l̇ëm bakoe. Pjãy tjl̈ẽshko ga tjl̈õkwo twe Sbörë bomi kong, l̈ëmi wl̈o. Pjãy woydë l̇l̇ëm e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eshko ga pjãy l̈i tjl̈ẽkdo l̇l̇ëme. Bomi Data Sëya l̈i tjl̈ẽkdo bomi kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","»Nopga epenga dö ëng twë tjl̈apgaga kong, zröya l̈ok wl̈o. Dataga, e ba wapga twë eni bakoe. Wapga iirkono ba data, ba mekë kong ga twe tjl̈apgaga kong, zröya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pjãy ĩywa nopga uunkongdë shjiktëng bor kjĩshko. Gueniyo ga ëye mär Sbö go äär jong ba dbo go ga era där ber shäng pjl̈ú ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pjãy l̈öngshko ga pjãy shdungoba wl̈eni ga pjãy tök kjok shto obl̈ë. Gueniyo l̈ër bomi kong jl̈õkoyo ga pjãy äätë Israel kjokyo uunkong l̇l̇ëm obishko ga no to ter kjok dogo dwayo ëre shrono tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","»Oppinggaga tjwl̈õ ara, ba pingga kjinmo l̇l̇ëme. Parkagaga tjwl̈ẽk l̈öng pjir wl̈eniyo tjwl̈õ ara, ba sogo kjinmo l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Woyde oppingga l̈irë ga äär ber ba pingga dik erö dey. Woyde parkaga l̈irë ga äär ber ba sogo ĩ dik erö dey bakoe. Tja bomi kägäyo. ¿Tja ga kowëba Beelzebú ga era pjãye? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","»L̇l̇ëbo shäryak l̈ũtshko kës l̈i wen wẽl̈ëshko. L̇l̇ëbo jnek tjeng kës l̈i wl̈ẽkoba pjire. E kjĩshko ga nopga bangkjrëy l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tjl̈õkwo l̈ër bomi kong shkëshko l̈i, e l̈ëmi oba kong kjok shjiyshko. Tjl̈õkwo l̈ër bomi kong l̈ũtshko l̈i, e l̈ëmi oba uunkong kong kjone pogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nopga bangkjrëmi l̇l̇ëme. Bomi doyo zröya l̈ok ga pjl̈ú, gueniyo bomi sëyara zröya l̈ok ga äe. Bomi sëya, bomi doyo, e zröga, dbuga iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko ga pjl̈ú l̈i, e bangkjromirë dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","»¿Sënwa kjwo pjök, e soynek dburwa kjwara ãska l̇l̇ëmdo? Eni ëmdë ga sënwa l̈i iche bomi Datarë l̈on töshko, enira l̈on. Gueniyo iche l̇l̇ëm ga l̈on kjwara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Pjãyda tjwl̈õ ara, sënwa ara kjinmo. Bomi käkzong pjl̈obi l̈i shtara Sbörë pjir tjän. E kjĩshko ga l̇l̇ëye bangkjrëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","»Pjãy tjl̈ẽno oba kong ga pjãy l̈öng bor tjok l̈oromi wl̈eni ga bomi kjĩshko ga tja tjl̈ẽ bor Data sök kjok dogo l̈i kong ga pjãy l̈öng bor tjok l̈ër eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Gueniyo pjãy tjl̈ẽno oba kong ga pjãy l̈öng bor tjok l̇l̇ëme l̈oromi wl̈eni ga tja tjl̈ẽ bor Data l̈i kong ga pjãy l̈öng bor tjok l̇l̇ëme l̈ër eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","»Tja shrono shäng nopga ichë ber l̈öng wl̈ẽp ëng tjok wl̈o l̈ëmi l̇l̇ëme. Tja shrono shäng nopga ichë ëngkjwë wl̈o, ber l̈öng wl̈ẽp ëng tjok wl̈o l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tja shrono shäng wapga domerga ichë ëngkjwë ba dataga tjok, wapga wal̈ëga ichë ëngkjwë ba mekëga tjok, pjl̈aydoga ichë ëngkjwë ba ëmga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Eni ga bomi pjeyoga l̈öng bomi ushko l̈i ber l̈öng bomi moskwoga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","»Ëye, ba data, ba mekë, ba wapga, e woyde ara, bor kjinmo wl̈eni ga ber bor oppingga ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Woyde ga l̇l̇ëye shäryëba ba kong bor kjĩshko l̇l̇ë pogoshko l̈i, e zrökoba pjang kjl̈ös go ëmdë ga e ba kong ga l̇l̇ëye l̇l̇ëme l̈e. Eni l̇l̇ëm ga e ber bor oppingga ga ä bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ëye beno shäng bor tjok l̇l̇ëm, e zrökoba l̇l̇ëme l̈e wl̈eni ga äär kjok dogo l̇l̇ëme. Gueniyo ga ëye jëk bor tjok jl̈õkoyo, e zröraba bor kjĩshko ëmdë ga era ber sök së ĩyado Sbö tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","»Ëye, pjãy wl̈okjrara ga tja wl̈okjrara wl̈eni. Ëye, tja wl̈okjrara ga bor ichaga wl̈okjrara wl̈eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ëye Sbö tjl̈õkwo l̈aga wl̈okjrara, e Sbö tjl̈õkwo l̈aga kjĩshko ga Sbö tjl̈õkwo l̈aga l̈i potjwl̈ẽkkl̈o ber ba kong bakoe. Ëye no pjl̈o bek wl̈eniyo wl̈okjrara, e pjl̈o bek kjĩshko ga no pjl̈o bek l̈i potjwl̈ẽkkl̈o ber ba kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ëye bor oppingga song ëre kjimtara, e bor oppingga kjĩshko ga sëna di zeng erö ëmdë ga l̈ër bomi kong jl̈õkoyo ga potjwl̈ẽkkl̈o tjok tjän» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús, ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i poshduna pjir ga to jek l̈ok eshko dwayo, jongya kjok shto obl̈ë obl̈ë, oba ping wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Eshkoshko ga Juan shdung shäng no shdũzl̈ong uyo roshko. Ga Cristo roy kuya ga ba oppinggaga ichara pjök mya, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","l̇l̇ëbo kjakrokë Jesús kong. Öötong l̈öng Jesús shängshko ga tjl̈ẽ l̈ok ba kong ga «¿No pjl̈uyo iche l̈e Sbörë koshërwa l̈öng l̈i pjare, de obl̈ë koshorwarë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","«L̇l̇ëye kuromi, ĩnomi l̈i to l̈ëmi Juan kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nopga kjok ĩgö l̇l̇ëm wl̈eniyo kjok ĩnoe. Nopga jëk l̇l̇ëm wl̈eniyo jëktonge. Nopga pogl̈o go swl̈o ara, sho an do jĩkong wl̈eniyo poptonoe. Nopga kjok kugö l̇l̇ëm wl̈eniyo kjok kunoe. Shinmoga woshrono iröng obi. Nopga song wl̈eniyo kong Sbö tjl̈õkwo roy pjl̈ú l̈ak ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ëye mär bor go, ga tja raye l̇l̇ëm ga era ber sök wopjl̈úe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Epga brikshko ga Jesús tjl̈ẽno oba kong Juan kjĩshko. Tjl̈ẽ ga «¿Pjãy jek l̈öng kjok dogro no l̇l̇ëmshko, Juan ĩkshko ga pjãy äätë eshko l̇l̇ëm obishko ga domer, e kjwe sorë l̈oromi? ¿E sjro bakwara pjl̈ukdë wl̈eni l̈oromire? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Eni l̇l̇ëm ga e kjwe sorë l̈oromi? ¿E doyono shäng shwong wol̈ësowa, tjwl̈õ ara wl̈eniyo go l̈oromire? Miydëmi pjl̈ú ga nopga eniyo l̈öng pjl̈u ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Eni ga e kjwe sorë l̈oromi? ¿E kjwe Sbö tjl̈õkwo l̈aga l̈oromire? E jl̈õe. Ga e tjwl̈õ ara, Sbö tjl̈õkwo l̈agaga obl̈ë kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sbö tjl̈õkwo tak pjang l̈i goshko ga Sbö tjl̈ẽno Juan kjĩshko. Tjl̈ẽno beno eni: »“No ichër kjl̈ara bop bäm go, bop roy l̈aga, irbo poshäryë bop kong wl̈o.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","»L̈ër bomi kong jl̈õkoyo ga nopga uunkong kjok ëre kjing go äätë tjwl̈õ ara, Juan No Waga kjinmo l̇l̇ëme. Eni gueniyo ga nopga l̈öng Sbö sök no pjl̈uyoshko kjl̈obi l̈i tjwl̈õ ara, Juan kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","»Juan No Waga dbaryoshko tek l̈ëkong ga nopga ara optwono Sbö kong, e ber ba pjl̈uyo wl̈o. Ga nopga owa ëngkjwë ara, Sbö ber no pjl̈uyo l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan tjwayde l̇l̇ëm obishko ga Sbö tjl̈õkwo l̈agaga uunkong tjl̈ẽno ga l̇l̇ono ga Sbö, e ber no pjl̈uyo l̈e. Kjok l̇l̇gwekkl̈o tara Moisésdë l̈i tjl̈ẽ eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ëye, tja tjl̈õkwo kuya woydë l̈i kong ga l̈ër ga Sbö tjl̈õkwo l̈aga Elías tjwe iröng l̈ara koshëmi l̈öng l̈i, e Juan. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ëye kwomgwo tjok ga woyde ga kuya yõtso. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","»Eerishko dbaryo sopga, ¿pjãy so l̇l̇ë kjoyo l̈ër bomi kong? Pjãy so kjwozirga öö l̈e l̈öng ëng kong l̇l̇ëbo soynezl̈ong shtoyoshko tjör kjoyoe. Tjl̈ẽ l̈ok ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","»“Tjawa dbonmo bakwono ga bëyotkoromi l̇l̇ëme. Tjawa tono tëkwo woydokl̈o ga pjãy sl̈atong l̇l̇ëm bakoe” l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","19","»L̈ër ega l̈ër bomi kong. Juan shrono shäng ga iono l̇l̇ëm Sbö kong dbar kop ara, ga kjil̇l̇gwo bo dyo iono l̇l̇ëm bakoe. Eshko ga “Kjwe goshko Ä sëya kjl̈ara” l̈oromi. E irgo ga no to ter kjok dogo dwayo ëre shrono ga tja ië ara, tja kjil̇l̇gwo bo dyo ië bakoe. Eni ga “Domer kjwe ië sĩyo, nel̈õtkë äe, jëk nopga owa wl̈eniyo tjok, ië nopga dbur töngga Roma so kong l̈i tjok bakoe” l̈ëmi eni. L̈ër bomi kong ga pjãy so kjwozirga l̈öng l̈i kjoyo e kjĩshko. Sbö kjok miydë l̈i, e jl̈õe miydëba ba pak shäryara beno l̈i go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryara Jesúsdë kjok shto obl̈ë obl̈ë tjän, ga kjok eshko sopga, l̇l̇ëbo owa shärye l̈öng l̈i, e owa jl̈õe l̈oromi l̇l̇ëm, ga rayara l̇l̇ëm bakoe. E kjĩshko ga e dbaryo ga epga wl̈ona Jesúsdë, tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«¡Corazín sopga, Betsaida sopga, pjãy song jl̈õ, pjãy shdungko! L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryoror bomi kong l̈i ĩna Tiro sopga, Sidón sopgarë tek dënashko kjwe ga l̇l̇ëbo owa shärye l̈öng l̈i, e owa jl̈õe l̈ara, ga rayara, ga shwong pjuna shtëgro së ä wl̈eniyo, pjl̈ung sho iara ba dl̈u kjing go, ba woowa l̈i ĩya Sbörë wl̈o tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eni ga l̈ër bomi kong ga no l̇l̇gwezl̈ong dbaryoshko ga pjãy shdũya Sbörë ara, Tiro sopga, Sidón sopga, e kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","»Capernaúm sopga, ¿pjãy wotjl̈ĩk ga pjãy söya Sbörë jem äär kjok dogo l̈ëmiro? Eni l̇l̇ëme. Pjãy iche jer äär iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko. L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryoror bomi kong l̈i ĩna Sodoma sopgarë kjwe ga eeri ga ba tjëyoga l̈öng eshko obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eni ga l̈ër bomi kong ga no l̇l̇gwezl̈ong dbaryoshko ga pjãy shdũya Sbörë ara, Sodoma sopga kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Eshko ga Jesús tjl̈ẽ Sbö kong ga «Data, pja kjok dogo sopga, kjok ëre sopga, e Tjl̈apga. L̇l̇ëye jnenop kjok miydagaga l̈öng kong l̈i pinop oba song, wotöy wl̈eniyo kong. E kjĩshko ga pja poshrër ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Shäryorop eni, woydorop eni kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eshko ga tjl̈ẽ nopga kong ga «L̇l̇ëbo uunkong iara Data Sbörë beno tjeng bor wl̈oshko. Sbö Wa ëre sorë, e miydaga ërë l̇l̇ëm, e miydaga bor Datarë eröe. Data Sbö, e sorë miydaga ërë l̇l̇ëm, e miydaga tjarë eröe. Gueniyo e sorë pin woydë ë kong ga pin. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","»Pjãy sjeno parkorbo, l̇l̇ëbo pjanbo ga pjãy tek bor shwoy uunkong, ga pjãy iër ber l̈öng woshtë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tja wl̈ẽp, wotöy kuzong ga pjãy kong pak twër l̈i shäryozĩ, pjãy oppĩs bor go. Enira pjãy woshtë jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","L̇l̇ëye pin bomi kong l̈i, e kjang l̇l̇ëme. L̇l̇ëye twër bomi kong pjami wl̈o l̈i, e kwing l̇l̇ëm bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Woshtozl̈ong dbaryo kjwara ga Jesús jëk shäng dwl̈a dgak buk l̈i tjrëko. Eshko ga ba oppinggaga pjl̈i ara kuzong ga dwl̈a bo kjre l̈öng, ue l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ĩya fariseogarë ga tjl̈ẽ Jesús kong ga «¡Bop oppinggaga kjwe ĩzong! L̈öng l̇l̇ëbo shäryako woshtozl̈ong dbaryoshko l̇l̇ëm l̈i shäryë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kuya ga tjl̈ẽ ba kong ga «¿Dënashko ga David, ba yorkagaga, e pjl̈i l̈ok arashko ga l̇l̇ëye shäryara tak pjang Sbö tjl̈õkwo go l̈i, e l̈omirë l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David opzrëno jek shäng Sbö u roshko, ga pjl̈ung shosho suk pjir iak beno tjeng dboy Sbö kong l̈i, e uaga syõshtagagarë erö ëmdë ga uara l̈oke. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kjok l̇l̇gwekkl̈o tara Moisésdë l̈i tjl̈ẽ ga woshtozl̈ong dbaryoshko ga syõshtagaga parkë l̈öng Sbö u roshko l̈i, l̇l̇ëye owa shärye l̈öng l̇l̇ëme. ¿E l̈omirë l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","L̈ër bomi kong ga ëreshko shäng kjl̈ara tjwl̈õ ara anmoyõ, Sbö u kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sbö tjl̈õkwo tak pjang eni: “Woydër ga obl̈ë songe l̈ëmi. E tjwl̈õ ara, öng zrömi, sho sumi, pjë dret bor poshrëkkl̈o l̈i kjinmo.” Tjl̈õkwo ëre l̇l̇ë l̈okl̈o miydëmi kjwe ga “Pja owa shäryono” l̈ëmi obl̈ë l̇l̇ëye owa shäryono l̇l̇ëm l̈i kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Woshtozl̈ong dbaryo kägäyo l̈i, no to ter kjok dogo dwayo ëre l̈i e» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","E irgo ga Jesús to ey dwayo, ga opzrëno jek judíoga syõ uyo jong kjok eshko l̈i roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Domer shäng kjl̈ara eshko orkwo kjwara sl̈osl̈oe. Fariseoga l̈öng eshko kjl̈öbö, l̇l̇ëbo wl̈ẽya l̈öng ara, Jesús rote e go wl̈o. Eni ga tjl̈ẽ l̈ok ba kong ga «¿Woshtozl̈ong dbaryo ga no poptëy ga pjl̈úre?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","«¿Bomi öng, e l̈ono pjl̈ëbgwo roshko woshtozl̈ong dbaryoshko ga shimi l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","No, e tjwl̈õ ara, öng kjinmo anmoyõ. Eni ga l̇l̇ëbo pjl̈ú, e shäryëy woshtozl̈ong dbaryoshko ga pjl̈úe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eshko ga Jesús tjl̈ẽ domer l̈i kong ga «Pja orkwo roshwĩzong» l̈e. Kuya ga orkwo roshwino, ga poptono beno pjl̈ú, ba orkwo kar go dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Gueniyo ga fariseoga opshino jek l̈ok ey dwayo, ga tjl̈ẽ l̈ok ëng kong ga «¿Jesús, e zröy sorë ga pjl̈ú?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Wotjl̈ĩk l̈öng l̇l̇ë l̈i miydara Jesúsdë pjire. Eni ga opshino to kjok eshko dwayo. Oba to jek ara ba tjok. Swl̈opga l̈öng eshko l̈i poptara uunkong, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ga tjl̈ẽ ba kong l̈ok ga «Tja ë l̈ëmi ë kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Shäryono eni, tjl̈õkwo l̈ara ba tjl̈õkwo l̈aga tek dënashko so Isaíasdë l̈i ber jl̈õkoyo wl̈o. Tjl̈ẽno beno eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Bor parkaga kjroror shäng ëre. Kjwe woydër ara. Tja wopjl̈ú ba tjok bakoe. Bor Sëya iër ber ba go, ga kjok l̇l̇gwer sorë l̈i roy shdöya tjëyoga uunkong kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kjwe ëngl̈ë kar kar ë tjok l̇l̇ëm, öö l̈e kukoba irbo bäng l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Sjro shũktong tjeng l̈i, e toya l̇l̇ëm, shwomzrëng pjë jer jong ba seto l̈i, e sjëya l̇l̇ëm, kjok l̇l̇gwera beno bek pjir guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","L̇l̇ono ga tjëyoga uunkong ber l̈öng ba koshë.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Eshko ga domer shäng kjl̈ara kjok ĩgö l̇l̇ëm, tjl̈ẽ l̇l̇ëm, goshko Ä sëya kjl̈ara kjĩshko. E söraba Jesús shwoy, ga poptara beno shäng kjok ĩgö pjl̈ú, tjl̈ẽ pjl̈ú bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nopga l̈öng eshko l̈i beno l̈öng yëy l̈e erä. Ga tjl̈ẽ ëng kong ga «¿Ëre David tjëyo shrono shäng bi dögaro l̇l̇ëm?» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kuya fariseogarë l̈ok ga tjl̈ẽ l̈ok ëng kong ga «Ä sëyaga iche to, dbo twara Ä sëya kägäyo ko Beelzebúrë ba kong l̈i go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wotjl̈ĩk l̈öng l̇l̇ë l̈i miydara Jesúsdë pjir, ga tjl̈ẽ ba kong ga «Pjl̈u l̇l̇ë, ba nopga ëngkjwë ëng tjok kar kar wl̈eni ga e oppjik l̈ok om go. Nopga tjeng kjok kjrinaso, nopga tjeng u kjwaraso, e ëngkjwë ëng tjok kar kar wl̈eni ga e oppjik l̈ok om go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","¿Eni ga Ä, e ëngkjwë ba sëyaga tjok wl̈eni ga e pjir mal̈ing l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ä sëyaga ichër opshik oba goshko dwayo, dbo twara Beelzebúrë bor kong l̈i go l̈ëmi. ¿Eni ga bomi oppinggaga kong dbo twaga ërë, Ä sëyaga iche l̈ok wl̈o? E kjĩshko ga epga omĩk wẽl̈ë ga pjãy diktong l̈öng jl̈õe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ä sëyaga ichër to, Sbö Sëya dbo ara go. Miydëmi e go ga Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo shrono tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","»¿Domer sök kjl̈ara dbo ara ba ushko wl̈eni ga no jek äär opzrëk l̈ũrkë ba u roshko sorëro? Woyde ga domer l̈i shara, pjrira bäm go guing. Enira ba l̇l̇ëbo l̈ũyotke ga pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","»Ëye shäng bor shwo l̈ëkong l̇l̇ëm ga e shäng bor wl̈oyo. Ëye no töng bor kong l̇l̇ëm ga e shäng ba shdöga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","E kjĩshko ga l̈ër bomi kong ga ëye l̇l̇ëbo owa shäryë, tjl̈õkwo l̈ë owa ga owa pjang ba go l̈i l̈ö̃ya Sbörë ber dret wl̈o ga pjl̈úe. Gueniyo ëye Sbö Sëya l̈ãywë owa ga owa l̈i l̈ö̃ya ba kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ëye no to ter kjok dogo dwayo ëre l̈ãywë owa ga owa l̈i l̈ö̃ya ber dret wl̈o ga pjl̈úe. Gueniyo ëye Sbö Sëya l̈ãywë owa ga owa l̈i l̈ö̃ya eerishko l̇l̇ëm, l̇l̇onoshko l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","»Kjor doyo pjl̈ú ga ba bo, e pjl̈úe. Kjor doyo owa ga ba bo, e owa. Kjor, e sorë miydëy ba bo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Pjãy so dgur kjoyoe! ¿Pjãy owa kjĩshko ga pjãy tjl̈ẽ pjl̈ú sorëro? L̇l̇ëbo tjeng bomi pjl̈úshko l̈omirë bomi kjamo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","No pjl̈ú ga tjl̈ẽ pjl̈ú, wotjl̈ĩk pjl̈ú kjĩshko. No owa ga tjl̈ẽ owa, wotjl̈ĩk owa kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","L̈ër bomi kong ga no l̇l̇gwezl̈ong dbaryo ga no kjl̈obi l̈i iche Sbörë ba dboryë, tjl̈õkwo owa l̈ono kjwobi l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Eshko ga pjãy ie ber l̈öng pjl̈ú, l̇l̇ëm ga pjãy ie ber l̈öng shdungko, tjl̈õkwo l̈oromi l̈i kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Eshko ga fariseoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e kjone kjone tjl̈ẽ Jesús kong ga «Tjl̈apga no pingga, pja ichara Sbörë l̈i jyãgl̈o shäryos kjrina borwa kong, l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo ĩnwa wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kuya ga tjl̈ẽ ba kong ga «Eerishko dbaryo sopga, pjãy owa. Pjãy so domer orkwosmok shäng pjir, gueniyo jëk shäng wal̈ë obl̈ë tjok kjoyoe. Woydëmi ga l̇l̇ëbo jyãgl̈o shäryër bomi kong, gueniyo shäryër l̇l̇ëm, Sbö tjl̈õkwo l̈aga Jonás, e jyãgl̈o shäryotë bomi kong eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Dënashko ga e beno sök mã dl̈ung roy so kësbang bö roshko dbargwo mya, shkë dba sorë ga no to ter kjok dogo dwayo ëre äär ber buk kl̈ung roshko dbargwo mya, shkë dba eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive sopga, e Jonás tjl̈õkwo kunoshko ga l̇l̇ëbo owa shärye l̈öng l̈i, e owa jl̈õe l̈ara, ga rayarae. Ga ëreshko no shäng kjl̈ara tjwl̈õ ara, Jonás kjinmo. E kjĩshko ga eerishko dbaryo sopga, pjãy l̇l̇gweya Sbörëshko ga Nínive sopga kojong l̈ok, ga tjl̈ẽ ga “Kjwepga shdungko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sabá so pjl̈uyo wal̈ë tek pjola dwayo, Pjl̈u Salomón kjok miydë l̈i kuya wl̈o. Ga ëreshko no shäng kjl̈ara tjwl̈õ ara, Salomón kjinmo. E kjĩshko ga eerishko dbaryo sopga, pjãy l̇l̇gweya Sbörëshko ga wal̈ë l̈i kojong, ga tjl̈ẽ ga “Kjwepga shdungko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","»Ä sëya pjang no goshko l̈i toshko ga to shäng shto wl̈ẽk kjok dogro no l̇l̇ëmshko, woshtë wl̈o, gueniyo wl̈ẽya l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Eshko ga wotjl̈ĩk ga “Tja to bor ushko iröng obi” l̈e. Äär iröng ba ushko ga wl̈ẽya shäng rorë, pjl̈okjak pjir, poshäryak pjir wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eni ga sëya obl̈ë tö̃ya ba tjok dogl̈o kjäk (7), owa ba kjinmo, ga uunkong l̈i pjë jek äär ber tjeng no l̈i go. Eni ga no l̈i beno shäng owa anmoyõ, shäng bäm go sorë l̈i kjinmo. Eerishko dbaryo sopga, pjãy owa, ga pjãy ber l̈öng domer ëre dik eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús sök tjl̈ẽ oba tjeng ara l̈i kong wopro ga ba mekë, ba l̈ëmga, e shrono tjeng kjoko, l̈an ba tjok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eni ga rotaraba Jesús kong, tjl̈ẽ ga «Bop mekë, bop l̈ëmga, e shrono tjeng bop ĩk kjoko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kuya ga tjl̈ẽ ba kong ga «¿Bor mekë, e ë? ¿Bor l̈ëmga, e ë?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eni ga ba oppinggaga l̈öng l̈i pĩya ba sakkwo go, ga tjl̈ẽ ga «Bor mekë l̈ër l̈i kjwepga. Bor l̈ëmga l̈ër l̈i kjwepga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ëye bor Data sök kjok dogo l̈i kol̈ë ga era bor mekë wl̈eni, bor l̈ëng wl̈eni, bor dor wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","E dbaryo ga Jesús opshino jek u l̈i roshko dwayo, ga öötong sirkeno sök di bäng buk kësbang l̈i sor go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nopga shrono l̈öng ara kjĩshko ga Jesús opyono kjyong roshko, ga sirkeno sök eshko. Nopga l̈i beno tjeng di bäng l̈i kjako. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Eshko ga tjl̈ẽno ba kong ara l̇l̇ëbo jyãgl̈o go, tjl̈ẽ ga «Domer shäng kjl̈ara dwl̈a sguingga. Pjl̈ara ga opshino to jek dwl̈a sguing. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sguĩyashko ga kjone kjone l̈ono tjeng irbo bäng, ga sënwa shrono, uara l̈ok drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kjone kjone l̈ono tjeng ak ara tjrëko, kl̈ung sho ara l̇l̇ëmshko, ga weno mal̈ing, kl̈ung sho rong l̇l̇ëm kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Gueniyo sl̈enggwo dret kjĩshko ga dl̈o wenoshko ga dwl̈a l̈i sura, beno dogroe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dwl̈a kjrina obi, e l̈ono tjeng shkö sho roshko, ga shkö sho l̈i kunoshko ga dwl̈a l̈i l̇l̇gwĩnae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dwl̈a kjrina obi, e l̈ono tjeng kl̈ung sho pjl̈ú kjing go, ga kuno, botjyono pjl̈úe. Kjoneshko ga sok kjwara botjyono kjwo sak dbäw (100), kjoneshko ga botjyono kjwo sak tjer (60), kjoneshko ga botjyono kjwo sak mya (30). ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ëye kwomgwo tjok ga woyde ga kuya yõtso» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","E irgo ga ba oppinggaga tek shrono l̈öng ba zl̈ong bäng ga tjl̈ẽ ba kong ga «¿Pja tjl̈ẽ oba kong l̇l̇ëbo jyãgl̈o go erä ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","«Sbö ber no pjl̈uyo sorë l̈i roy miydaydëba l̇l̇ëm l̈i pinaba bomi kong, gueniyo epga kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ëye l̇l̇ëbo tjok ga së̃ya jek obi, ber l̇l̇ëbo ara wl̈o. Ëye l̇l̇ëye l̇l̇ëm ga l̇l̇ëye tjeng sirawa l̈i döya ba shjiryo drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kuya l̈öng ga l̇l̇ë l̈okl̈o miyde l̈ok l̇l̇ëme. Ĩya l̈öng ga l̇l̇ë ĩyde miyde l̈ok l̇l̇ëm bakoe. Tja tjl̈ẽ ba kong l̇l̇ëbo jyãgl̈o go e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","L̇l̇ëye l̈ara Sbö tjl̈õkwo l̈aga tek dënashko so Isaíasdë l̈i beno epga l̈i kjĩshko. Tjl̈ẽno beno eni: »“Kuya l̈öng kjër ga l̇l̇ë l̈okl̈o miyde l̈ok l̇l̇ëm, ĩya l̈öng kjër ga l̇l̇ë ĩyde miyde l̈ok l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nopga ëre, l̇l̇ëye kuya woydë l̇l̇ëme. Kwomgwo bäng bängzara l̈ok tuke. Bokkwo l̇l̇ino l̈ok tuk bakoe. Shäryara eni, l̇l̇ëye ĩya l̈ok ba bokkwo go l̇l̇ëm wl̈o, l̇l̇ëye kuya l̈ok ba kwomgwo go l̇l̇ëm wl̈o, opping l̈ok sira l̇l̇ëm wl̈o, optwë ber bor kong l̇l̇ëm wl̈o, epga dör l̇l̇ëm wl̈o bakoe.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","»Gueniyo pjãyda kjok ĩgö bomi bokkwo go, pjãy kjok kugö bomi kwomgwo go bakoe. E kjĩshko ga pjãy ber l̈öng wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","L̈ër bomi kong jl̈õkoyo ga l̇l̇ëbo ĩmi, kumi l̈öng ëre tjwl̈õ ara. Dënashko ga Sbö tjl̈õkwo l̈agaga, nopga obl̈ë pjl̈o bek wl̈eniyo, e omĩk woydë, omkuk woydë, gueniyo omĩno l̇l̇ëm, omkuno l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","»Dwl̈a sguingga l̈anyo, e l̇l̇ë l̈okl̈o l̈ër bomi kong. Kuzĩa. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ëye Sbö ber no pjl̈uyo sorë l̈i roy kuno, gueniyo l̇l̇ë l̈okl̈o miyde l̇l̇ëm ga e so dwl̈a l̈ono irbo bäng l̈i kjoyoe. Tjl̈õkwo l̈i dgak pjang ba pjl̈úshko, gueniyo Ä tjwe eshko, ga döya ba shjiryo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dwl̈a l̈ono ak ara tjrëko l̈i, e ëye tjl̈õkwo l̈i kuno, ga beno shäng wopjl̈ú l̈i l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Gueniyo tjl̈õkwo l̈i äär ber ba pjl̈úshko jl̈õkoyo l̇l̇ëm kjĩshko ga l̇l̇ëye wen ba kong sirashko, shdungoba tjl̈õkwo l̈i kjĩshkoshko ga tjl̈õkwo l̈i raye, söya ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Dwl̈a l̈ono shkö sho roshko l̈i, e ëye tjl̈õkwo l̈i kuno l̈i l̈okl̈o. Tjl̈õkwo l̈i kura, gueniyo l̇l̇ëbo tjeng kjok ëre kjing goshko l̈i woyotjl̈ĩya ara, wo pjang dbur go bakoe. E kjĩshko ga tjl̈õkwo l̈i woyo ba kong ame, ga bo wen tjl̈õkwo l̈i kjĩshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","E ga dwl̈a l̈ono kl̈ung sho pjl̈ú kjing go l̈i, e ëye tjl̈õkwo l̈i kuno, ga l̇l̇ë l̈okl̈o miyde pjl̈ú l̈i l̈okl̈o. Eni ga e ber shäng so dwl̈a botjyono pjl̈ú kjoyoe. Kjoneshko ga sok kjwara botjyono kjwo sak dbäw (100), kjwo sak tjer (60), kjwo sak mya (30)» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ga Jesús tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go obi, tjl̈ẽ ga «¿Sbö ber no pjl̈uyo sorë, e so l̇l̇ë kjoyo l̈ër bomi kong? Domer shäng kjl̈ara. Pjl̈ara ga dwl̈a pjl̈ú wl̈eniyo dgara ba kjok kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gueniyo dwl̈a dgaga l̈i ponoshko ga ba moskwo shrono shäng kjl̈ara dwl̈a dgak buk l̈ishko. Kjl̈o sho owa dwl̈ayo, e söra, dgara dwl̈a buk pjl̈ú l̈i roshko, ga to ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Eni ga dwl̈a pjl̈ú l̈i weno, botjyë kjwl̈ëshko ga kjl̈o sho owa l̈i weno ba tjrëko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","»Ĩya dwl̈a sogo l̈i parkagagarë ga öör l̈ok ba rotë ba kägäyo kong, tjl̈ẽ ga “Tjl̈apga, pja dwl̈a dgono bop kjok kjing go pjl̈ú eröe. ¿Eni ga kjl̈o sho owa kjwe wen sorë?” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","»“Söga, dgaga bi moskworë” l̈e ba kong. »Kuya l̈ok ga tjl̈ẽ ba kong ga “¿Kjl̈o sho owa kjwe shirware?” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","»“L̇l̇ëme. Kjl̈o sho owa kjwe skwëmishko ga dwl̈a pjl̈ú kjwe skwe tëm ba tjok äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pjl̈ú wl̈o ga iozĩ ber kun uunkong, äär jong bo kjrozl̈ong dbaryo. Eshko ga nopga ichër kjl̈o sho owa l̈i zë bäm go, pjriya, ga ie tjeng dboshko, ber sukoba wl̈o. Shäryara l̈ok eni pjir ga dwl̈a pjl̈ú l̈i skoya, jneya tjeng dwl̈a jnekkl̈o uyo roshko” l̈e ba kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ga Jesús tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go obi, tjl̈ẽ ga «Sbö ber no pjl̈uyo sorë, e so kjor dwl̈ayo chirawa ko mostaza dgoroy kl̈ung roy kjoyoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Dwl̈agwo ëre chirawa, dwl̈agwo obl̈ë obl̈ë dorko. Gueniyo kun kësbang, dwl̈agwo obl̈ë obl̈ë kjinmo. Eshko ga sënwa l̇l̇ë usho ywë ba kowo go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ga Jesús tjl̈ẽno ba kong, l̇l̇ëbo jyãgl̈o go obi, tjl̈ẽ ga «Sbö ber no pjl̈uyo sorë, e so wal̈ë pjl̈ung shosho l̇l̇runo bayo gök kësbang tjung wl̈eni kjwo sak kjwara (10) ba uukkl̈o tjok, ga ie ber buk uur wl̈o kjoyoe. Ba uukkl̈o shdöktong pjl̈ung shosho l̈i kjwang jĩkong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","L̇l̇ëbo uunkong ëre l̈ara Jesúsdë nopga kong l̇l̇ëbo jyãgl̈o go erä. Eni l̇l̇ëm ga l̇l̇ëye l̈ara ba kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Shäryono eni, tjl̈õkwo l̈ara Sbö tjl̈õkwo l̈aga tek dënashko sorë l̈i ber jl̈õkoyo wl̈o. Tjl̈ẽno beno eni: «Tja tjl̈ẽ l̇l̇ëbo jyãgl̈o go; tjl̈õkwo l̈ër l̈i, e iak Sbörë tjeng l̈ũtshko, kjok ëre shäryara Sbörë tek l̈ëkong.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús to ey dwayo ga opzrëno jek shäng u roshko. Eshko ga ba oppinggaga tek shrono l̈öng ba zl̈ong bäng ga tjl̈ẽ ba kong ga «Kjl̈o sho owa weno dwl̈a pjl̈ú tjrëko l̈anyo, e l̇l̇ë l̈okl̈o l̈os borwa kong sira» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kuya ga tjl̈ẽ ba kong ga «Dwl̈a pjl̈ú dgaga l̈i, e no to ter kjok dogo dwayo ëre l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Dwl̈a dgara kjokyo l̈i, e kjok kjwang jĩkong l̈okl̈o. Dwl̈a pjl̈ú l̈i, e Sbö nopga l̈okl̈o. Kjl̈o sho owa l̈i, e Ä nopga l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ba moskwo, kjl̈o sho owa dgaga l̈i, e Ä l̈okl̈o. Dwl̈a bo kjrozl̈ong dbaryo l̈i, e kjok pjir dbaryo l̈okl̈o. Ga dwl̈a skogaga l̈i, e Sbö parkagaga kjok dogo so l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","»Kjl̈o sho owa l̈i tö̃ya, dbuya iök roshko, suya wl̈o sorë ga kjok pjir dbaryoshko ga Ä nopga suya eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Eshkoshko ga nopga ber l̈öng l̇l̇ëbo owa shäryë, nopga ber l̈öng obl̈ë ichë l̇l̇ëbo owa shäryë bakoe. Eshko ga bor parkagaga kjok dogo so ichër no to ter kjok dogo dwayo ërerë nopga owa l̈i töng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ga dbuya l̈ok iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko, ber tjeng sl̈ar eshko, kowo uë, l̇l̇ëbo bang ara ba kong kjĩy. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ga nopga pjl̈o bek l̈öng l̈i ber l̈öng kãl̈ã l̇l̇etl̇l̇et dl̈o wl̈eni, ba Data sök l̈ishko. Ëye kwomgwo tjok ga woyde ga kuya yõtso. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","»Sbö ber no pjl̈uyo sorë, e so l̇l̇ëbo tjwl̈õ ara jnek buk kjok kjrina roshko kjoyo. Domer, l̇l̇ëbo tjwl̈õ ara l̈i wl̈ẽna buk eshko, ga jnena jek beno buk eshko obi. Eshko ga woowa l̇l̇ëme. Eni ga ba l̇l̇ëbo tjeng l̈i soynena uunkong, ga kjok l̈i tjwl̈ẽna beno ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","»Sbö ber no pjl̈uyo sorë, e so domer l̇l̇ëbo tjwl̈ẽga, soynega to shäng obrikkwo tjwl̈õ ara wl̈ẽk kjoyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Obrikkwo wl̈ẽna kjwara tjwl̈õ ara wl̈eniyoshko ga ba l̇l̇ëbo tjeng l̈i soynena uunkong, ga obrikkwo l̈i tjwl̈ẽna beno ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","»Sbö ber no pjl̈uyo sorë, e so kjl̈a mã shakkl̈o kjoyo bakoe. Dbuya l̈ok di roshkoshko ga mã shaya l̇l̇ërba pogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kjl̈a l̈i dl̈inoshko ga shikoba tjeng pjöshko, ga mã pjl̈ú wl̈eniyo töngoba shing roshko, ga owa l̈i dbukoba. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Eni ga kjok pjir dbaryoshko ga Sbö parkagaga kjok dogo so tjwe l̈ok nopga owa l̈i kjë nopga pjl̈o bek tjeng l̈ishko dwayo, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ga nopga owa l̈i dbuya l̈ok iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko, ber tjeng sl̈ar eshko, kowo uë, l̇l̇ëbo bang ara ba kong kjĩy» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Eshko ga Jesús tjl̈ẽ ba kong l̈ok ga «¿Tjl̈õkwo l̈ër shäng l̈i l̇l̇ë l̈okl̈o miydëmi l̈öngde?» «Ëng, miydërwa» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kuya ga tjl̈ẽ ba kong ga «Ëye no ping pjl̈ú, Sbö ber no pjl̈uyo sorë l̈i kjĩshko ga e so domer u sogo kjoyoe. L̇l̇ëbo jnek tjeng ara, l̇l̇ëbo tjagl̈ën, l̇l̇ëbo këguë bakoe. Ga l̇l̇ëbo l̈i shiya, twe oba kong ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús tjl̈ẽno l̇l̇ëbo jyãgl̈o go pjir ga to ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jek öötong shäng ba kjokshko, tek chirawa ga kuno shäng l̈ishko obi ga nopga pina ara judíoga syõ uyo jong eshko l̈i roshko. Kuya l̈ok ga beno l̈öng yëy l̈e erä. Ga tjl̈ẽ l̈ok ëng kong ga «¿Kjwe kjok miydë ara opping kjone? ¿L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shärye sorë? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Domer kjwe u shäryaga l̈i wa l̇l̇ëmdo? ¿Mekë María l̇l̇ëmdo? ¿L̈ëmga Santiago, José, Simón, Judas l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Dorga l̈öng na bi tjok bako l̇l̇ëmdo? ¿Kjok miydë ara kjwe wl̈ẽya kjone?» l̈e l̈ok ëng kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ga tjl̈õkwo kjre l̈ok woydë l̇l̇ëm, iirkono l̈ok ara erä. Eshko ga Jesús tjl̈ẽ ba kong l̈ok ga «Kjok kjone pogo ga Sbö tjl̈õkwo l̈aga, e iëba tjwl̈õ ara. Gueniyo ba kjok om go l̈ishko, ba ushko ga iëba tjwl̈õ l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kjok eshko sopga mär Jesús go l̇l̇ëm kuzong ga l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryara ara eshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dbar eshkoshko ga Pjl̈u Herodes parkë sök Galilea so ichaga. Jesús roy kuya ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","tjl̈ẽ ba parkagaga kong ga «E Juan No Waga l̈i woshrokdo. L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shärye ga pjl̈ú e kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kjupäbäshko ga Juan tjl̈ẽ Herodes kong ga «Herodías kjwe kjrëp ber bop boy wl̈o ga ä, e bop shjiy Felipe boy kjĩshko» l̈e. E kjĩshko ga Juan shara, bängzara Herodesdë, shdũya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Zröya woydë, gueniyo «Juan, e Sbö tjl̈õkwo l̈aga» l̈ëba, ga oba bangkjre ara. E kjĩshko ga zröra l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Öötong Herodes shrëzl̈ong dbaryoshko ga Herodías wa wal̈ë l̈i bërkono oba l̈öng kjl̈obi l̈i bokshto, ga Herodes beno sök wopjl̈ú e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","E kjĩshko ga tjl̈ẽno ba kong jl̈õkoyo ga l̇l̇ëye roke l̈i twe ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Poshduna ba mekërë kjĩshko ga tjl̈ẽ Herodes kong ga «Woydër ga no ichëp Juan No Waga kägä zë, ga tek söp bor kong kjwl̈ë roshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kuya ga woydë jonge. Gueniyo tjl̈ẽno jl̈õkoyo nopga mana l̈öng l̈i bokshto kuzong ga no ichara ba shäryë ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eni ga Juan kägä zara tas, no shdũzl̈ong uyo roshko, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ga söra, twara kjogl̈o l̈i kong kjwl̈ë roshko. Eshko ga kjrara, ga söra, twara ba mekë kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","E irgo ga Juan oppinggaga öör l̈ok ba doyo kjrë, ga söra, jnena l̈ok sakshko. E irgo ga öötong l̈öng Jesús shäng l̈ishko ga roy l̈ara l̈ok ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan roy kuya Jesúsdë ga opshino shäng l̈ishko dwayo ga opyono kjyong roshko, ga to kjok shto obl̈ë, ber sök tjoksa wl̈o. Gueniyo ga miydara kjok eshko sopgarë, ga to jek l̈ok ara ba irgo pjö l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","E irgo ga Jesús opshino kjyong roshko dwayoshko ga nopga ëng töno träk l̇l̇ëm l̈i ĩna, ga songe l̈e, ga swl̈opga söra l̈ok tjeng eshko l̈i poptara pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kjok ro zar kjwl̈ë kuzong ga ba oppinggaga tjl̈ẽ l̈ok ba kong ga «Kjok sëng tjän. Kjok ëreshko l̇l̇ëye drete. Pjl̈ú wl̈o ga nopga kjwe ichos to na dwayo, jek l̇l̇ëbo soynekoba kjone l̈ishko, dl̈i tjwl̈ẽk wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kuya ga tjl̈ẽ ba kong ga «Brik l̈ok l̇l̇ëm ga pjl̈úe. Së̃zĩ pjãydë dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kuya l̈ok ga tjl̈ẽ ba kong ga «Ëreshko tjawa pjl̈ung shosho suk pjir tjeng kjwo shkëng (5), mã tjeng do pjök erä» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kuya ga tjl̈ẽ ba kong ga «Tek sözĩ bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eni ga nopga tjeng kjl̈obi l̈i ichara wl̈ar uunkong töshko, shkwamsho kjing go. Pjir ga pjl̈ung shosho suk pjir kjwo shkëng (5) l̈i, mã do pjök l̈i, e kjrara Jesúsdë, ga kjok dogo ĩya jem drëng ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga pjl̈ung shosho suk pjir l̈i tora, ga twara ba oppinggaga kong. Ga pjl̈orgara l̈ok nopga l̈öng kës l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nopga uunkong iono beno l̈öng bö tjung, wopjl̈úe. E irgo ga dl̈i worbo töna ba oppinggagarë l̈ok shing roshko, beno tjeng shing kjwo sak kjwara kjingsho pjök (12), tjung tjunge. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Domerga iono uunkong dogl̈o sak dbäw dbäw pjl̈ogl̈o shkëng (5,000) dik. Wal̈ëga, kjwozirga, e shtak l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","E irgo ga Jesús ba oppinggaga ichono opyë kjyong roshko, dipzë di bäng buk kësbang l̈i kjwo kal̈ëkong wl̈o. Nopga brik l̈ok wopro ga Jesús beno shäng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Briktong pjir ga Jesús jem öötong shäng dl̈up go tjoksa, syõshtë Sbö kong eshko wl̈o. Eni ga kjok ro zoktong shäng eshko tjoksa. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Eshko ga kjyong l̈i jek öötong buk pjola tjän, ga jõya di iõya ararë, pjl̈uk tek jong ba shwo l̈ëkong kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kjok shränto ga Jesús jek jëk shäng di l̈i kjing go, ba oppinggaga l̈öng l̈i shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ĩya l̈ok ga bangkjre l̈ok ara, ga tjl̈ẽ ëng kong ga «¡Kjwe äya jl̈õe!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jekdo eshko ga Jesús tjl̈ẽ ba kong ga «¡Pjãy wokjange! ¡Tja l̈i jekdo shäng! L̇l̇ëye bangkjrëmi l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Eni ga Pedro tjl̈ẽ ba kong ga «Tjl̈apga, pja jl̈õ ga tja ichos jek jëk di kjing go, äär bop shwoy wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kuya ga tjl̈ẽ ba kong ga «Pja tegö» l̈e. Kuya Pedrorë ga opshino kjyong roy dwayo, ga jëktong jek di kjing go, Jesús shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Eshko ga ĩya ga pjl̈uk tjwe jong dbo ara ga bangkjrara, ga pir jer jong, ga tjl̈ẽ ga «¡Tjl̈apga, tja kjimtozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Eshko ga shara Jesúsdë jekdo ba orkwo go, ga tjl̈ẽ ba kong ga «Pja mär bor go jl̈õkoyo l̇l̇ëme. ¿Pja kjimtër l̇l̇ëme l̈orop ega?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","E irgo ga opyono l̈ok kjyong l̈i roshkoshko ga pjl̈uk l̈i beno tjëksoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eshko ga beno l̈öng kjyong roshko l̈i, Jesús poshrëra, ga tjl̈ẽ l̈ok ba kong ga «Pja Sbö Wa jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dipzono l̈ok di bäng buk kësbang l̈i kjwo kal̈ëkongshko ga öötong l̈öng Genesaret kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jesús miydara kjok eshko sopgarëshko ga roy shdöra l̈ok kjok eshko kjwang jĩkong. Eni ga swl̈opga söra l̈ok ba kong, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","tjl̈ẽ ba kong ga «Swl̈opga kjwe ichos bop shwong worbo porwë sira döe» l̈e. Ga porwara, ga poptono jekdo uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Eshko ga fariseoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e kjone kjone tjwe l̈öng Jerusalén kjokyo dwayo, tek shrono l̈öng Jesús shwoy ga tjl̈ẽ l̈ok ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«¿Bop oppinggaga kjwe, bi tjl̈apgaga tek dënashko so sdëkwo bangkjre l̈ok l̇l̇ëm ega? Ië l̈okshko ga orkwo shkwë l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kuya ga tjl̈ẽ ba kong ga «¿Bomi sdëkwo kjĩshko ga Sbö kjok l̇l̇gwekkl̈o kol̈ëmi l̇l̇ëm ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sbö tjl̈ẽno ga “Bomi dataga, bomi mekëga, e bangkjrozĩ, iozĩ ber tjwl̈õ ara.” Sbö tjl̈ẽno obi ga “Ëye ba data, ba mekë l̈ãywono owa ga e zrökko.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Gueniyo ga ëye tjl̈ẽno ba data, ba mekë kong ga “Pja kjimtër ga äe. Bor l̇l̇ëbo uunkong ëre tworor tjeng Sbö kong pjire” l̈ara ba kong pjir ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ba data, ba mekë kjimte ame ga pjl̈úe l̈ëmi eni. Eni ga bomi sdëkwo kjĩshko ga Sbö tjl̈õkwo ioromi beno tjwl̈õ l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! L̇l̇ëye l̈ara Sbö tjl̈õkwo l̈aga tek dënashko so Isaíasdë bomi kjĩshko l̈i, e jl̈õe. Tjl̈ẽno beno eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","»“Nopga ëre, tja poshrëya ba kjamo go, gueniyo tja woyotjl̈ĩya ba pjl̈úshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tja poshrëya l̈öng l̈i l̇l̇ëno l̇l̇ëm, nopga pĩya kjok l̇l̇gwekkl̈o tak norë go erö kjĩshko”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Eshko ga nopga rokara tek ba zl̈ong bäng, ga tjl̈ẽ ba kong ga «Tja kuzĩa. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nopga äär ber owa Sbö bokso l̈aga dl̈i ue l̈irë l̇l̇ëme. Miga ber l̈öng eni l̈i l̈aga ba tjl̈õkwo l̈e om go l̈irë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wop tjok ga ba oppinggaga tek shrono l̈öng ba zl̈ong bäng ga tjl̈ẽ ba kong ga «L̇l̇ëye l̈orop l̈i kjĩshko ga fariseoga iirkono ara. ¿E miydëpde?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","«Dwl̈a dgara bor Data sök kjok dogo l̈irë l̇l̇ëm ga e skwako sl̈eng go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kjwepga l̈öng wẽyẽ. Kjok ĩgö l̈ok l̇l̇ëm, gueniyo l̈öng obl̈ë kjok ĩgö l̇l̇ëm wl̈eniyo wl̈osök. Eni ga no kjok ĩgö l̇l̇ëm wl̈eniyo wl̈osöya no kjok ĩgö l̇l̇ëm wl̈eniyorë ga l̈on tjeng pjöyĩkong pjl̈ëbgwo kjwaraso roy» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Eshko ga Pedro tjl̈ẽ ba kong ga «L̇l̇ëye l̈orop l̇l̇ëbo jyãgl̈o go l̈i pjl̈ol̇l̇gwes borwa kong sira» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kuya ga tjl̈ẽ ba kong l̈ok ga «¿L̇l̇ëye l̈ër shäng l̈i l̇l̇ë l̈okl̈o miydomirë l̇l̇ëm obire? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dl̈i uëy l̈i jer bi kjamo roy, äär ber tjeng bi bö roshko. Pjir ga tur bi roy dwayo. ¿E miydëmi l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Gueniyo ga tjl̈õkwo l̈ëy l̈i wen tëm bi pjl̈úshko dwayo, ga tur bi kjamo go. Nopga äär ber owa Sbö bokso l̈aga erë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","No wotjl̈ĩk owa, no zrök, pë no orkwosmono ba tjok l̇l̇ëm l̈i tjok, l̈ũrkë, jyõrkë, obl̈ë jyõyotkë, obl̈ë l̈ãywë owa, e wen tëm ba pjl̈úshko dwayo uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nopga äär ber owa Sbö bokso l̈aga l̇l̇ëbo tjeng kës ërerë. Gueniyo ëye ber pjl̈o bek Sbö bokso, iono orkwo shkwono l̇l̇ëm kjĩshko l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","E irgo ga Jesús opshino to kjok eshko dwayo, jek öötong shäng Tiro kjokyo, Sidón kjokyo, e soshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wal̈ë sök kjl̈ara eshko Canaán so. Tek shrono shäng Jesús shwoy ga tjl̈ẽ ba kong dbo go ga «¡Tjl̈apga, David tjëyo, tja songe l̈ozong! Bor wa wal̈ë, goshko Ä sëya kjl̈ara, ĩn ga songe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kuya ga dboryara l̇l̇ëme. Eni ga ba oppinggaga tjl̈ẽ ba kong ga «“Pja nom na dwayo” l̈os wal̈ë kjwe kong, tek shäng öö l̈e ara bi irgo kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kuya ga tjl̈ẽ wal̈ë l̈i kong ga «Tja ichara Sbörë Israel tjëyoga kong döe. Epga öng wl̈ẽp ushko so jeno l̈öng wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Eni ga wal̈ë l̈i tek shrono shäng ba zl̈ong bäng ga kjök tono, tjl̈ẽ ba kong ga «¡Tjl̈apga, tja kjimtozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kuya ga tjl̈ẽ ba kong ga «Bi wapga dl̈i l̈i döy, twëy shjiti kong wl̈o ga äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kuya ga tjl̈ẽ ba kong ga «Jl̈õe, Tjl̈apga. Gueniyo ba sogo iëshko ga dl̈i pjl̈oyo l̈on ter töshko ga ue shjitirë ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kuya ga tjl̈ẽ ba kong ga «Pja mär bor go jl̈õkoyo. Woydorop sorë l̈i shäryë eni» l̈e. Ga ba wa l̈i poptono jekdo eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús opshino to eshko dwayo, jek öötong shäng Galilea di bäng buk kësbang l̈i sor go. Eshko ga to jem öötong sök dl̈up go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","E irgo ga nopga shrono l̈öng träk l̇l̇ëm sök l̈ishko. Swl̈opga söra l̈ok ara, nopga jëk l̇l̇ëm wl̈eniyo, nopga kjok ĩgö l̇l̇ëm wl̈eniyo, nopga orkwo owa, dre owa wl̈eniyo, nopga tjl̈ẽ l̇l̇ëm wl̈eniyo, nopga swl̈o obl̈ë obl̈ë bakoe. Eni ga söra l̈ok Jesús zl̈ong bäng, ga poptarae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Eshko ga nopga swl̈o ara wl̈eniyo, e poptono, nopga tjl̈ẽ l̇l̇ëm wl̈eniyo, e tjl̈ẽno, nopga orkwo owa wl̈eniyo, e orkwo poptono, nopga dre owa wl̈eniyo, e dre poptono, nopga jëk l̇l̇ëm wl̈eniyo, e jëktong, nopga kjök ĩgö l̇l̇ëm wl̈eniyo, e kjok ĩno bakoe. Ĩya l̈öng l̈irë ga beno l̈öng yëy l̈e erä, ga Israel tjëyo Sbö poshrëra l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","E irgo ga ba oppinggaga rokara Jesúsdë tek ba zl̈ong bäng, ga tjl̈ẽ ba kong ga «Nopga kjwe l̈öng bor tjok na öötong dbargwo mya, ga l̇l̇ëye uako l̇l̇ëme. E kjĩshko ga songe l̈ër. Jek ichër l̈öng ba ushko ië l̇l̇ëm ga äe. Wopjir irbo kjwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kuya l̈ok ga tjl̈ẽ ba kong ga «¿Nopga träk l̇l̇ëm kjwe së̃y sorë? ¿Kjok no l̇l̇ëmshko ëre dl̈i wl̈ẽy kjone?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kuya ga tjl̈ẽ ba kong ga «¿Pjãy pjl̈ung shosho suk pjir tjeng kjwobi?» «Tjeng kjwo kjäk (7), mã chilawa tjeng kjwöbö bakoe» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eni ga nopga l̈i ichara Jesúsdë wl̈ar uunkong töshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pjir ga pjl̈ung shosho suk pjir kjwo kjäk (7) l̈i, mã l̈i, e kjrara, ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga dl̈i l̈i tora, twara ba oppinggaga kong. Ga pjl̈orgara l̈ok nopga tjeng kës l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nopga uunkong iono beno l̈öng bö tjung, wopjl̈úe. E irgo ga dl̈i worbo töna ba oppinggagarë l̈ok shing roshko, beno tjeng shing kjwo kjäk (7), tjung tjunge. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Domerga iono uunkong dogl̈o sak dbäw dbäw pjl̈ogl̈o pkëng (4,000). Wal̈ëga, kjwozirga, e shtak l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","E irgo ga nopga briktong pjir ga Jesús opyono kjyong roshko, ga to ey dwayo, jek öötong shäng Magdala kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Eshko ga fariseoga, saduceoga, e tek shrono l̈öng Jesús shwoy, ba tjl̈ĩk wl̈o. Tjl̈ẽ ga «L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryos borwa kong kjrina, pja ichaga Sbörë jl̈õre miydërwa e go wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kuya ga tjl̈ẽ ba kong ga «Ĩmi kjok sëng ga kjok dogo srëzrë́n ga bong ga kjok pjl̈úe l̈ëmi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ĩmi kjok shröngto ga kjok dogo srëzrë́n, pjäng sho ara ga eeri ga kjok owa l̈ëmi. Eni ga l̇l̇ëbo wen kjok dogo, e l̇l̇ë l̈okl̈o miydëmi pjl̈úe. ¿Eni ga l̇l̇ëbo shärye Sbörë eerishko dbaryo l̈i, e l̇l̇ë l̈okl̈o miydëmi l̇l̇ëm sorëro? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Eerishko dbaryo sopga, pjãy owa. Pjãy so domer orkwosmok shäng pjir, gueniyo jëk shäng wal̈ë obl̈ë tjok kjoyoe. Woydëmi ga l̇l̇ëbo jyãgl̈o shäryër bomi kong, gueniyo shäryër l̇l̇ëm, Sbö tjl̈õkwo l̈aga Jonás, e jyãgl̈o shäryotë bomi kong eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","E irgo ga Jesús oppinggaga dipzono tek shrono l̈öng di bäng buk kësbang l̈i kjwo na l̈ëkong ga pjl̈ung shosho suk pjir söra l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Eshko ga Jesús tjl̈ẽ ba kong ga «Pjãy sjëk, fariseoga, saduceoga, ba pjl̈ung shosho uukkl̈o wl̈e tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kuya l̈ok ga tjl̈ẽ ëng kong ga «Shji pjl̈ung shosho suk pjir söno l̇l̇ëme. L̈e shäng bi kong eni e kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tjl̈ẽ l̈öng ëng tjok l̇l̇ë l̈i miydara Jesúsdë kuzong ga tjl̈ẽ ba kong ga «¿“Shji pjl̈ung shosho suk pjir söno l̇l̇ëme” l̈ëmi ega? ¿Pjãy mär bor go jl̈õkoyo l̇l̇ëm ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Bor tjl̈õkwo l̈i l̇l̇ë l̈okl̈o miydomirë l̇l̇ëm obire? ¿Domerga sënor dogl̈o sak dbäw dbäw pjl̈ogl̈o shkëng (5,000), pjl̈ung shosho suk pjir kjwo shkëng (5) goshko ga dl̈i beno obi tönomi shingyo kjwobi woyo bomi kong l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Domerga sënor dogl̈o sak dbäw dbäw pjl̈ogl̈o pkëng (4,000), pjl̈ung shosho suk pjir kjwo kjäk (7) goshko ga dl̈i beno obi tönomi shingyo kjwobi woyo bomi kong l̇l̇ëm bakoro? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Tja tjl̈ẽ shäng pjl̈ung shosho suk pjir kjĩshko l̇l̇ëm l̈i miydëmi l̇l̇ëm sorë? Pjãy sjëk fariseoga, saduceoga, ba pjl̈ung shosho uukkl̈o wl̈e tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eshko ga miydara l̈ok ga Jesús shäng tjl̈ẽ l̈i, e pjl̈ung shosho uukkl̈o l̈ayde l̇l̇ëme. No pĩya fariseoga, saduceogarë l̈öng sorë, e l̈ayde shäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús jek öötong Filipo Cesarea kjokyo ga tjl̈ẽ ba oppinggaga kong ga «¿No to ter kjok dogo dwayo ëre, e ë l̈ëba?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kuya l̈ok ga tjl̈ẽ ba kong ga «No kjone kjone tjl̈ẽ ga pja Juan No Waga l̈i woshrokdo l̈e. Kjone kjone tjl̈ẽ ga pja Sbö tjl̈õkwo l̈aga tek dënashko so Elías l̈i tjwayde shäng l̈e. Kjone kjone tjl̈ẽ ga pja Sbö tjl̈õkwo l̈aga tek dënashko so Jeremías l̈i woshrokdo l̈e. Kjone kjone obi tjl̈ẽ ga pja Sbö tjl̈õkwo l̈agaga tek dënashko so kjl̈ara l̈i woshrokdo l̈e» l̈e l̈ok ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kuya ga tjl̈ẽ ba kong ga «E ga pjãy e, ¿tja ë l̈ëmi?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kuya Simón Pedrorë ga tjl̈ẽ ba kong ga «No pjl̈uyo ichara Sbörë shrono shäng l̈i, e pja. Pja Sbö Sök Ĩyado l̈i Wa jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kuya ga tjl̈ẽ ba kong ga «Simón, Jonás wa, pja tjl̈ẽno l̈i l̈aga norë bop kong l̇l̇ëm, l̈aga bor Data sök kjok dogo l̈irë bop kong. E kjĩshko ga pja ber wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","L̈ër bop kong ga pja kowër Pedro. Oba u ywë wl̈o ga ak kjang iëba bäm go, ber ba shakkl̈o wl̈o. Eni ga nopga tjëyo shäryër kjrina bor tjl̈õkwo kjragaga kjl̈obi l̈i go, so u kjoyo, ga ak l̈ër l̈i, e ber u l̈i shakkl̈o wl̈eni. Tjëyo l̈i zãya Ärë ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ga pja kong dbo twër, pja ber Sbö nopga bapshiga wl̈o. Ba nopga ichëp sorë kjok ëre kjing go ga epga iche Sbörë kjok dogo eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","E irgo ga tjl̈ẽ ba oppinggaga kong obi ga «No pjl̈uyo ichara Sbörë shrono shäng l̈i, e tja l̈ëmi ë kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Eshko jek l̈ëkong ga Jesús tjl̈ẽ ba oppinggaga kong ga «Tja jongya Jerusalén kjokyo. Eshko ga judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, tja shdũya l̈ok ara, ga tja zrökoba, gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Eni ga rokara Pedrorë tjoksa, ga tjl̈ẽ ba kong ga «¡Tjl̈apga, woydër ga e wen bop kong eni l̇l̇ëme!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Gueniyo ga Jesús bojono Pedro shwo l̈ëkong, ga tjl̈ẽ ba kong ga «¡Ä, pja opkjos bor zl̈ong dwayo! Tja ichëp woydë dir eröe. L̇l̇ëye woyde Sbörë l̈i woyotjl̈ĩp shäng l̇l̇ëme. L̇l̇ëye woyde norë l̈i woyotjl̈ĩpdë shäng eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Eshko ga tjl̈ẽ ba oppinggaga kong ga «Ëye jëk woydë bor tjok jl̈õkoyo ga ber shäng bor woyotjl̈ĩk ĩyado, wotjl̈ĩk l̇l̇ëbo shäryë kjok ëre kjing goshko ame bakoe. Bor kjĩshko ga l̇l̇ëye shäryëba ba kong l̇l̇ë pogoshko l̈i, e zrökoba ëmdë ga e ba kong ga l̇l̇ëye l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ëye wotjl̈ĩk opdë om go, zrökoba bor kjĩshko l̇l̇ëm wl̈o l̈e ga äär kjok dogo l̇l̇ëme. Gueniyo ëye jëk bor tjok jl̈õkoyo, e zröraba bor kjĩshko ëmdë ga era ber sök së ĩyado kjok dogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ëye l̇l̇ëbo tjeng kjok ëre kjing go kës l̈i kjrara tjeng ba wl̈oy ëmdë ga e l̇l̇ëno l̇l̇ëme. Wol̈ono ga öötong kjok dogo l̇l̇ëm ga to jeno ba l̇l̇ëbo l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","»No to ter kjok dogo dwayo ëre tjwe bor Data dbo kãl̈ã goshko, bor parkagaga kjok dogo so tjok. Eshko ga no kjl̈ara kjl̈ara potjwl̈ẽn, l̇l̇ëbo shäryara dö l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","L̈ër bomi kong jl̈õkoyo ga pjãy kjone kjone l̈öng ëreshko wol̈ontë l̇l̇ëm obishko ga tja ber no pjl̈uyo sorë l̈i ĩmi wẽl̈ëe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dbargwo tjer (6) irgo ga Pedro, Santiago, Juan (e Santiago kjl̈arayo), e söra Jesúsdë jem ba tjok dboshko, dl̈up jong kjwara kjókshko l̈i go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Eshko ga ĩna ba oppinggaga jem l̈öng ba tjok l̈irë ga Jesús kjl̈opswono, bokkwo beno kãl̈ã l̇l̇etl̇l̇et dl̈o wl̈eni, ga shwong beno pjl̈ubl̈ún shjiye. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ĩya l̈öng wopro ga Moisés, Elías, e weno bë l̈öng l̈an Jesús tjok eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Eni ga Pedro tjl̈ẽ Jesús kong ga «Tjl̈apga, tjawa l̈öng na ga pjl̈úe. Woydëp wl̈eni ga tja ukwang shäryë kjwo mya, bop kong kjwara, Moisés kong kjwara, Elías kong kjwara bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Shäng tjl̈ẽ wopro ga pjäng sho shjiy l̈ono ter kjrina ba kjing go. Ga pjäng sho l̈i roshko dwayo ga ybö kura l̈ok, tjl̈ẽ ga «Bor wa l̈i ëre. Woydër ara. Tja wopjl̈ú ba tjok. Ba tjl̈õkwo kuzĩa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kuya ba oppinggaga l̈öng l̈irë ga jek rish l̈öng töshko bokdo kjl̈ay kl̈ung go, bangkjre l̈ok ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Gueniyo Jesús tek ba zl̈ong bäng, ga porwara, ga tjl̈ẽ ba kong ga «Pjãy kojõzong. L̇l̇ëye bangkjrëmi l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ĩya l̈ok obi ga nopga l̈öng Jesús tjok l̈i beno drete. Jesúsda beno shäng tjoksa erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jer opl̈ong l̈öng dl̈up l̈i go dwayoshko ga Jesús tjl̈ẽ ba kong l̈ok ga «L̇l̇ëye ĩnomi yẽ l̈anyotkëmi ë kong l̇l̇ëm, no to ter kjok dogo dwayo ëre woshrara Sbörë iröng obi guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kuya l̈ok ga tjl̈ẽ ba kong ga «No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go tjl̈ẽ l̈ok ga “Borwa pjl̈uyo iche l̈e Sbörë l̈i tjwe ber nopga uunkong pjl̈uyo wl̈o. Gueniyo ga Elías tjwe bäm go” l̈e. ¿L̈e l̈ok eni ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","«Elías tjwe bäm go jl̈õe. E tjwe l̇l̇ëbo uunkong poshäryaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gueniyo l̈ër bomi kong ga e shrono öör tjän. Gueniyo ga to miydaraba l̇l̇ëme. Kong l̇l̇ëbo owa shäryaraba, woydaraba sorë l̈i eni. No to ter kjok dogo dwayo ëre kong l̇l̇ëbo owa shäryëba e kjoyo bakoe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Miydara ba oppinggaga l̈irë eni ga Juan No Waga l̈i l̈anyotkayde shäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesús, ba oppinggaga l̈i, e jer äär l̈öng iröng nopga tjeng arashko ga domer tjwe shäng Jesús zl̈ong bäng kjl̈ara, kjök tono, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ga tjl̈ẽ ba kong ga «Tjl̈apga, bor wa songe l̈ozong. L̇l̇ëbo owa tjwe ba kongshko ga jek kjl̈o dete, wopjir kjl̈ul̈u erä. Ol̈ö ga dguë iök roshko, l̇l̇ëm ga l̈on dishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","E kjĩshko ga söror bop oppinggaga wl̈e kong, gueniyo to poptara l̈ok l̇l̇ëme» l̈ë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kuya ga tjl̈ẽ ba oppinggaga beno l̈öng l̈i kong ga «Pjãy wotjl̈ĩk owa. Pjãy mär Sbö go l̇l̇ëme. ¿Tja ber shäng bomi tjok kjër äär jong l̇l̇ono, pjãy mär ba go wl̈o? Tja sjeno shäng bomi tjok tjän. Dwl̈as l̈i tek sös bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Eshko ga Ä sëya l̈i wl̈ona, ichara to dwl̈as l̈i go dwayo, ga dwl̈as l̈i poptono jekdo beno shäng pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Döni ga ba oppinggaga l̈öng tjoksa Jesús tjokshko ga tjl̈ẽ l̈ok ba kong ga «¿Ä sëya l̈i to ichororwa l̇l̇ëm ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","«Pjãy mär Sbö go jl̈õkoyo l̇l̇ëm kjĩshko. L̈ër bomi kong jl̈õkoyo ga pjãy mär ba go sirawa kjwe ëmdë ga pjãy tjl̈ẽ dl̈up ëre kong ga “Pja opkjos jek pjola” l̈ëmi, ga opkjë jek pjolae. Eni wl̈eni ga l̇l̇ëye shäryëmi ga ä wl̈o l̈i drete» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jek tjeng uunkong Galilea kjokyoshko ga Jesús tjl̈ẽ ba oppinggaga kong ga «No to ter kjok dogo dwayo ëre twëba ber tjeng nopga wl̈oshko, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ga tja zröya l̈ok. Gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi» l̈e. Kuya l̈ok ga woydë l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús, ba oppinggaga, e öötong l̈öng Capernaúm kjokyoshko ga kä potjwl̈ẽkkl̈o dburyo l̈i töngga Sbö u kong l̈öng eshko l̈i tjl̈ẽ Pedro kong ga «¿Bop pingga kjwe kä potjwl̈ẽk l̇l̇ëmdo?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","«Ëng, potjwl̈ẽya» l̈e ba kong. Döni ga Pedro opzrëno jek u roshko. Ga l̇l̇ëye l̈ayde Pedrorë ba kong l̇l̇ëm obishko ga Jesús tjl̈ẽ ba kong ga «¿“Pjãy kä potjwl̈ẽk bor kong” l̈e pjl̈upgarë ë kong? ¿Ba wapga kongde, de oba obl̈ë kong?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","«Oba obl̈ë kong eröe» l̈e ba kong. Kuya ga tjl̈ẽ ba kong ga «Eni ga ba nopga baĩyara kä potjwl̈ẽk l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gueniyo ëye barwëy l̇l̇ëm wl̈o ga pja nom diga, sö dbup jer dishko. Eshko ga mã ship kjl̈ara bäm go l̈i kjak roshko dburwa buk kjwara. Ship, söp, twëp dbur töngga l̈i kong, bi kä potjwl̈ẽkkl̈o wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Eshko ga Jesús oppinggaga tek shrono l̈öng ba zl̈ong bäng ga tjl̈ẽ ba kong ga «¿Sbö sök no pjl̈uyo ĩyado l̈ishko ga tjawa l̈öng ëre tjrëko, tjwl̈õ kësbangyo l̈i kjone dey?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kuya ga kjwozirwa rokara kjl̈ara, iara shäng ba tjrëko, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ga tjl̈ẽ ba oppinggaga kong ga «L̈ër bomi kong jl̈õkoyo ga pjãy opkjl̈opswë ber kjwozirwa jũni l̇l̇ëm ga pjãy äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ëye opkjl̈opswë ber wotöy, kjwozirwa jũni ga tjwl̈õ kësbangyo Sbö sök no pjl̈uyo ĩyado l̈ishko l̈i e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ga ëye, kjwozirwa jũni wl̈okjrara bor kjĩshko ga tja wl̈okjrara wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","»Ëye, kjwozirwa mär bor go jũni ichara l̇l̇ëbo owa shäryë ga e song jl̈õe. Shäryayde l̇l̇ëm obishko ga shakko, apkwo kësbang pjrikko ba bëngshko, ga dbukko jer dl̈ung dorong dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","L̇l̇ëbo tjeng ara kjok kjwang jĩkong no ichë l̇l̇ëbo owa shäryë wl̈eni. L̇l̇ëbo wen eni ĩyado. Gueniyo ëye no ichë l̇l̇ëbo owa shäryë ga e song jl̈õe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","»E kjĩshko ga bomi orkwo, bomi dre, pjãy iche l̇l̇ëbo owa shäryë wl̈eni ga zëmi tas, dbumi pjolae. Pjãy opzrëk jek äär Sbö sökshko dre kjwara l̇l̇ëm, orkwo kjwara l̇l̇ëm dey ga pjl̈ú, pjãy pjë bomi orkwo pjök l̈i tjok, bomi dre pjök l̈i tjok, iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bomi bokkwo, pjãy iche l̇l̇ëbo owa shäryë wl̈eni ga shimi pjus, ga dbumi pjolae. Pjãy opzrëk jek äär Sbö sökshko bokkwo kjwara l̇l̇ëm dey ga pjl̈ú, pjãy pjë bomi bokkwo pjök l̈i tjok, iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","»Kjwozirga kjwe tjwl̈õ l̇l̇ëme l̈ëmi l̇l̇ëme. L̈ër bomi kong ga Sbö parkagaga kjok dogo so l̈öng bor Data bokkwo ĩk kjok dogo ĩyado l̈i, e kjwozirga kjwe daga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","»¿L̇l̇ë l̈ëmi? Domer shäng kjl̈ara, e öng wl̈ẽp ushko so tjeng dogl̈o sak dbäw (100). ¿Kjl̈ara jeno wl̈eni ga l̇l̇amo sak shkaw kjingsho shkaw (99) l̈i ie ber tjeng dl̈upshko, ga to jeno sök l̈i wl̈ẽk l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wl̈ẽnashko ga l̈ër bomi kong jl̈õkoyo ga öng dogl̈o sak shkaw kjingsho shkaw (99) jeno l̇l̇ëm l̈i woyotjl̈ĩya ara l̇l̇ëme. E ber sök wopjl̈ú kjl̈ara jeno, wl̈ẽna l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eni ga woyde bomi Data sök kjok dogo l̈irë ga kjwozirga kjwe jer kjl̈ara l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","»Bop kjl̈ara opshäryono owa bop kong ga pja l̈an ba tjok tjoksa, l̇l̇ëye owa shäryara l̈i jl̈õe l̈e wl̈o. Jl̈õ l̈ara ga pjãy beno l̈öng wopjl̈ú ëng tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jl̈õ l̈e l̇l̇ëm ga obl̈ë rokëp jek bop tjok kjl̈ara pjök, l̇l̇ëye l̈anyotkëp l̈i, e jl̈õe l̈e l̈ok wl̈o, Sbö tjl̈õkwo tjl̈ẽ ga “Shji obl̈ë rotëshko ga nopga söy pjök mya, e jl̈õe l̈e l̈ok wl̈o” kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jl̈õ l̈e l̇l̇ëm obi ga pja nom syõ uyo, ga l̈ëp bor tjl̈õkwo kjragaga l̈öng l̈i kong. L̈ano l̈ok ba tjok pjir ga jl̈õ l̈e l̇l̇ëm obi ga iëp ber shäng nopga Sbö miydë l̇l̇ëm wl̈eniyo dik, dbur töngga Roma so kong dik bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","»L̈ër bomi kong jl̈õkoyo ga no l̇l̇gwemi sorë kjok ëre kjing go ga l̇l̇gweya Sbörë kjok dogo eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","L̈ër bomi kong obi ga bor tjl̈õkwo kjragaga tön l̈öng bor ko goshko ga tja shäng ba tjok eshko, epga pjökde myare dö gueniyo. E kjĩshko ga l̈ër bomi kong ga pjãy tön wotjl̈ĩk kjrinaso kjok ëre kjing go, pjãy l̈öng do pjökde dö ëmdë ga l̇l̇ëbo rokëmi syõ go ga twe bor Data sök kjok dogo l̈irë bomi kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Eni ga Pedro shrono shäng Jesús zl̈ong bäng ga tjl̈ẽ ba kong ga «Tjl̈apga, ¿bor kjl̈ara l̇l̇ëbo owa shäryono bor kong l̈i iër ber tjwl̈õ l̇l̇ëm pjl̈obi ga pjl̈ú? ¿Shäryër eni pjl̈ogl̈o kjäk (7) ga pjl̈úre?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","«Pjl̈ogl̈o kjäk (7) l̈ër bop kong l̇l̇ëme. L̇l̇ëbo owa shäryara bop kjl̈ararë bop kong l̈i iëp ber tjwl̈õ l̇l̇ëm pjl̈ogl̈o sak kjäk kjingsho kjäk (77). ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","»Eni ga Sbö ber no pjl̈uyo sorë, e so l̇l̇ëbo l̈ër bomi kong ëre kjoyoe. Pjl̈u sök kjl̈ara. Pjl̈ara ga ba parkagaga rokara, pogo tjwl̈õ ba kong kjöme l̈e l̈ok ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Shärye shäng kjwl̈ëshko ga ba parkaga söraba ba shwoy kjl̈ara, pogo tjwl̈õ ba kong ara, domerga dogl̈o sak dbäw dbäw pjl̈ogl̈o sak kjwara (10,000) parkë l̈u pjl̈ogl̈o sak kjwara kjingsho shkëng (15) ãska wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tjwl̈ẽya ba parkaga l̈irë l̇l̇ë go l̇l̇ëm kuzong ga pjl̈u tjl̈ẽ ga “Kjwe soynezĩ jek ba boy, ba wapga, ba l̇l̇ëbo baĩya uunkong tjok, ber l̈öng parkë obl̈ë kong, pogo tjwl̈õ l̈i tjwl̈ẽya bor kong e go wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","»Kuya ba parkaga l̈irë ga kjök tono, tjl̈ẽ ba kong dbo go ga “Tja songe l̈ozong. Tja koshos sira ga tjwl̈ẽn bop kong uunkong” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ĩya pjl̈urë ga songe l̈e, ga tjwl̈õ shira ba kong ame, döra beno shäng oojong shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","»E irgo ga ba parkaga l̈i opshino ey dwayo, ga ba parkaga wl̈ẽna kjl̈ara obi bë shäng eshko, pogo tjwl̈õ ba kong sira döe, domer parkë dbargwo sak dbäw (100) ãska wl̈eni. Eni ga shakza pjä ba bëngso go, ga tjl̈ẽ ba kong ga “¡Pja pogo tjwl̈õ bor kong l̈i tjwl̈ẽs bor kong jekdo, eeri eröe!” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","»Kuya ba parkaga l̈irë ga kjök tono, tjl̈ẽ ba kong dbo go ga “Tja songe l̈ozong. Tja koshos sira ga tjwl̈ẽn bop kong uunkong” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Gueniyo ga songe l̈e l̇l̇ëme. Shduna, iara beno shäng no shdũzl̈ong uyo roshko pogo tjwl̈õ l̈i tjwl̈ẽna ba kong pjir guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","»Ĩya pjl̈ú parkagaga obl̈ërë ga beno ba kong owa, woydë l̈ok ara. Ga l̇l̇ëye ĩna l̈ok l̈i roy l̈ara pjl̈u kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eni ga ba parkaga l̈i rokara pjl̈urë, ga tjl̈ẽ ba kong ga “Pja parkaga owa. Pja pogo tjwl̈õ bor kong ara ëmdë ga tjwl̈õ shiror bop kong l̇l̇ëme. Pja kjl̈oshtono bor kong ga pja songe l̈oror. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Eni ga bop kjl̈ara, e songe l̈orop botoya dik l̇l̇ëm ega?” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Eni ga pjl̈u iirkono ara ba kong, ga ba nopga iara beno tjeng no shdũzl̈ong uyo roshko, pogo tjwl̈õ kjöme l̈i tjwl̈ẽna ba kong pjir guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","»L̇l̇ëbo owa shäryara bomi kjl̈ararë bomi kong l̈i iëmi ber tjwl̈õ l̇l̇ëm wl̈eni l̇l̇ëm ga bor Data sök kjok dogo l̈i omshäryë bomi tjok eni bakoe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús tjl̈ẽno pjir ga to Galilea kjokyo dwayo, jek öötong shäng Judea kjokyo, Jordán diyo kjwo kal̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nopga to jek ara ba tjok, ga swl̈opga poptara uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eshko ga fariseoga kjone kjone tek shrono l̈öng Jesús zl̈ong bäng, ba tjl̈ĩk wl̈o. Tjl̈ẽ ba kong ga «¿Domer ba boy rayë l̇l̇ë pogo kjĩshko ga pjl̈úre?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","«Sbö tjl̈õkwo tak pjang eni: “Dämärshko ga nopga shäryara Sbörë domer, wal̈ë.” ¿E l̈omirë l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","E kjĩshko ga domer ba data, ba mekë rayë, ga orkwosmok wal̈ë tjok, ga ber l̈öng kjl̈araso wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eni ga ber pjök ame, ber kjl̈araso shara. Töna Sbörë ga e döy l̇l̇ëme» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kuya fariseogarë ga tjl̈ẽ ba kong ga «Domerga ba boy rayë wl̈o ga ichara Moisésdë kjibokwo ëng rayokl̈o twe ba boy kong kjwara, ga iche jek ba ushko dwayo. ¿L̈ara eni ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","«L̇l̇ëye kumi woydë l̇l̇ëm kjĩshko. Pjãy ichara Moisésdë ëng rayë eni e kjĩshko. Gueniyo ga tek dämärshko ga e eni l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","L̈ër bomi kong ga ba boy pono domer obl̈ë tjok l̇l̇ëm ga raye ga äe. L̇l̇ëm ga shäryara eni, ga orkwosmono obl̈ë tjok wl̈eni ga l̇l̇ëbo owa shäryayde, e pono oma boy obl̈ë tjok wl̈eni» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kuya ba oppinggagarë ga tjl̈ẽ ba kong ga «Eni kuzong ga ëye orkwosmok l̇l̇ëm dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kuya ga tjl̈ẽ ba kong ga «Tjl̈õkwo ëre kjraga uunkongdë l̇l̇ëme. Ëye kjimte Sbörë ga era omkjrë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Domerga kjone kjone orkwosmok l̇l̇ëm, weno beno pë wal̈ë tjok ga ä kjĩshko. Kjone kjone orkwosmok l̇l̇ëm, shäryaga norë beno l̈öng eni kjĩshko. Kjone kjone orkwosmok l̇l̇ëm, parkë Sbö, ba pjl̈uyo l̈i kong ga pjl̈ú wl̈o. Ëre l̇l̇ë l̈okl̈o, ëye ommiydë woydë ga miyde ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pjl̈ara ga kjwozirga sökoba Jesús kong, Jesús orkwo ië ba kjing go wl̈o, syõshtë Sbö kong ba kjĩshko wl̈o bakoe. Eni ga kjwozirga sögaga l̈i wl̈õya Jesús oppinggagarë l̈öng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Eni ga Jesús tjl̈ẽ ba oppinggaga kong ga «Kjwozirga somi l̇l̇ëm, tek wẽyẽ bor shwoy. Ëye ber kjwozirga jũni ga Sbö ber ba pjl̈uyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E irgo ga orkwo iono kjwozirga l̈i kjing go. E irgo ga epga to ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pjl̈ara ga domer mite tek shrono shäng Jesús zl̈ong bäng ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, ¿l̇l̇ëye pjl̈ú shäryër, tja ber sök së ĩyado Sbö tjok wl̈o?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","«¿L̇l̇ëye pjl̈ú kjakrokëp bor kong l̈i l̇l̇ëro? Pjl̈ú l̈i, e Sbö eröe. Pja ber sök së ĩyado Sbö tjok wl̈o ga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i kol̈ozong» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kuya ga tjl̈ẽ ba kong ga «¿Kjone dey?» «Shji no zrök l̇l̇ëme. Shji pë oma boy obl̈ë tjok l̇l̇ëme. Shji l̈ũrkë l̇l̇ëme. Shji obl̈ë jyõyotkë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bop data, bop mekë, e bangkjros, ios ber tjwl̈õ ara, ga pja opwoydë sorë ga bop kjl̈ara, e woydos eni bakoe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kuya ga tjl̈ẽ ba kong ga «Tjl̈õkwo l̈ëp shäng kës l̈i shäryër shäng eni tjän. ¿L̇l̇ëye shäryër obi?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","«Pja ber pjl̈o bek woydë ga pja nom bop l̇l̇ëbo tjeng kës l̈i soynek pjir, ga dburyo twos oba song wl̈eniyo kong. Enira pja l̇l̇ëbo ara kjok dogo. Pjir ga pja tek bor tjok, pja pin wl̈o» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kuya ga beno shäng woydë ara, ga to ey dwayo, dbur ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","E irgo ga Jesús tjl̈ẽ ba oppinggaga kong ga «L̈ër bomi kong jl̈õkoyo ga nopga dbur ara wl̈eniyo äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko wl̈o ga kjange. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","L̈ër bomi kong jek obi ga öng jëkkl̈o sok kësbang wl̈eniyo opzrëk jek shkö bokkwo bäng go ga kjange. Gueniyo nopga dbur ara wl̈eniyo äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko wl̈o ga kjang anmoyõ» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kuya l̈ok ga beno l̈öng yëy l̈e erä. Ga tjl̈ẽ ba kong ga «¿Enira ëye därdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kuya ga ĩya drëng, ga tjl̈ẽ ba kong ga «Nopga kong ga shärye ga äe. Gueniyo l̇l̇ëye shärye Sbörë ga ä wl̈o drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Eshko ga Pedro tjl̈ẽ ba kong ga «Borwa l̇l̇ëbo tjeng kës l̈i rayororwa beno pjir, tjawa jek bop tjok wl̈o. ¿L̇l̇ëye wl̈ẽnwa e kjĩshko?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kuya ga tjl̈ẽ ba kong l̈ok ga «L̈ër bomi kong jl̈õkoyo ga kjok tjagl̈ënshko ga no to ter kjok dogo dwayo ëre sirkek äär sök bor pjl̈u sökkl̈o kãl̈ã l̇l̇etl̇l̇et l̈i kjing goshko. Eshko ga pjãy sirkek äär ber l̈öng sökkl̈o tjeng sak kjwara kjingsho pjök (12) kjing go eni bako, Israel tjëyoga kjringgwo sak kjwara kjingsho pjök (12) l̈i l̇l̇gwek wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ga ëye, ba u, ba kjl̈ara, ba data, ba mekë, ba wapga, ba kjok, e rayara bor kjĩshko ga ãska wl̈ẽya l̇l̇ëye rayara l̈i pjl̈ogl̈o sak dbäw (100) obi. Ga ber l̈öng së ĩyado Sbö tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Gueniyo eerishko ga nopga tjwl̈õ ara wl̈eniyo l̈öng ara l̈i, e ber l̈öng tjwl̈õ chira eshko. Ga eerishko nopga tjwl̈õ chira l̈öng ara l̈i, e ber l̈öng tjwl̈õ ara eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús tjl̈ẽ ba oppinggaga kong ga «Sbö ber no pjl̈uyo sorë, e so l̇l̇ëbo l̈ër bomi kong ëre kjoyoe. Domer shäng kjl̈ara kjil̇l̇gwo bo ara kjokyo sogo. Pjl̈ara ga opshino jek kjok shröngteng, nopga wl̈ẽk parkë ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Eshko ga tjl̈ẽno parkagaga l̈i kong ga potjwl̈ẽya dbar kjwara ãska l̈ara, ga ichara jek parkë ba kjok buk l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","»Dl̈o wenzong ga opshino jek obi, ga nopga wl̈ẽna l̈öng kjl̈öbö pak dret, l̇l̇ëbo soynezl̈ong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eshko ga tjl̈ẽ ba kong ga “Pjãy nom parkë bor kjokshko, ga pjãy potjwl̈ẽn bëye” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eni ga to jek l̈ok parkë ba kong. »Dl̈o dl̈uw ga shäryara eni jek obi. Dl̈o pjö l̈ë wl̈eni ga jek shäryara obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","»Dl̈o töy wl̈eni ga opshino jek obi, ga nopga wl̈ẽna l̈öng kjl̈öbö pak drete. Eshko ga tjl̈ẽ ba kong ga “¿Pjãy dbo ga l̈öng parkë l̇l̇ëm ega?” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","»“Tjawa parkë ë tjok l̇l̇ëm kjĩshko” l̈e l̈ok ba kong. »Kuya ga tjl̈ẽ ba kong ga “Pjãy nom parkë bor kjokshko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","»Öötong kjok shkë ga kjok sogo l̈i tjl̈ẽ ba parkaga kägäyo kong ga “Parkagaga to rokëp, ga potjwl̈ẽma. Shrono parkë iröng l̈i potjwl̈ẽp bäm go, shrono parkë bäm go l̈i potjwl̈ẽp ber iröng” l̈e ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Eshko ga parkagaga shrono dl̈o töy l̈i potjwl̈ẽna dbar kjwara ãska. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","»Roy kuya parkagaga shrono bäm go l̈irë ga wotjl̈ĩk ga potjwl̈ẽya l̈ok iröng l̈i kjinmo l̈e. Gueniyo potjwl̈ẽna dbar kjwara ãska bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Potjwl̈ẽna l̈ok pjirshko ga kjok sogo l̈i l̈ãywe l̈ok owa ëng kong, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","tjl̈ẽ l̈ok ga “¿Nopga tjwe l̈öng iröng kjwe parkono wop tjok erä, ga potjwl̈ẽna borwa tjok bëy ega? ¡Tjawa song parkono dl̈o roshko dboe!” l̈e l̈ok ëng kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","»Eni ga kjok sogo l̈i tjl̈ẽ parkaga kjl̈ara kong ga “Tja shäng l̇l̇ëbo owa shäryë bop kong l̇l̇ëme. Pja potjwl̈ẽn eni l̈oror bop kong, ga jöl̈ö l̈orop bor kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bop dburwa kjros, ga pja nom na dwayo. Parkagaga tjwe l̈öng iröng l̈i potjwl̈ẽn woydë bopoya dik bako ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","miydaga ber tjarë, dbur l̈i botoya kjĩshko. ¿Pjãy wotjl̈ĩk owa bor kong, tja no sëng ä kjĩshkore?” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","»Eni ga tjwl̈õ ara eerishko l̈i, e ber l̈öng tjwl̈õ chira eshko, e ga eerishko tjwl̈õ chira l̈i, e ber l̈öng tjwl̈õ ara eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús jek shäng Jerusalén kjokyoshko ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i rokara dboshko, ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Shji to Jerusalén kjokyo. Eshko ga no to ter kjok dogo dwayo ëre twëba ber tjeng syõshtaga kägäyoga wl̈oshko, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go wl̈oshko bakoe. Eshko ga tja iche l̈ok, zrökoba wl̈o, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ga tja twe l̈ok nopga judío l̇l̇ëm wl̈eniyo kong. Eshko ga tja joywe l̈ok, tja shpoya l̈ok no shpokkl̈o go, ga tja zröya l̈ok pjang kjl̈ös go. Gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eshko ga Zebedeo wapga ko Santiago, Juan, e mekë tek shrono l̈öng Jesús zl̈ong bäng ga kjök tono, tjl̈ẽ ba kong ga «L̇l̇ëbo shäryëp bor kong sira» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kuya ga tjl̈ẽ ba kong ga «¿L̇l̇ëye woydëp?» «Pja ber sök no pjl̈uyoshko ga bor wapga do pjök ëre iëp ber l̈öng bop tjok, or mil̈ë kjl̈ara, or kël̈ë kjl̈ara» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kuya ga tjl̈ẽ ba kong l̈ok ga «L̇l̇ëye rokëmi l̈öng bor kong l̈i, e l̇l̇ë miydëmi l̈öng l̇l̇ëme. ¿Pjãy shdungoba, bokrotkëba botoya dik ga pjl̈úre?» «Ëng» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kuya ga tjl̈ẽ ba kong ga «L̈ër bomi kong ga pjãy shdungoba, bokrotkëba, zrökoba botoya dik jl̈õe. Gueniyo ga pjãy kjrër ber tjeng bor or kël̈ë, or mil̈ë, e l̈aga tjarë l̇l̇ëm, e l̈aga bor Datarë. Shto bor or kël̈ë, or mil̈ë, e ber ëye kjrara bor Datarë tjeng l̈i kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kuya ba oppinggaga dogl̈o sak kjwara (10) l̈irë ga iirkono ba pjeyoga pjök l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gueniyo rokara Jesúsdë uunkong, ga tjl̈ẽ ba kong ga «Miydëmi pjl̈ú ga kjok ëre kjing go ga nopga judío l̇l̇ëm wl̈eniyo ichagaga ba nopga ichë parkë ara ba kong. Nopga dbo ara wl̈eniyo ba nopga ichë parkë ara ba kong bakoe. Ëye songe l̈e l̇l̇ëm, iche parkë ara ba kong erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Gueniyo woydër ga pjãy omshäryë eni l̇l̇ëme. Ëye opyë woydë ber tjwl̈õ ara obl̈ë kjinmo ga opyë ber shäng obl̈ë kjimtaga dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ëye opyë woydë ber bäm go ga opyë ber shäng parkaga tjwl̈ẽk shäng pjir wl̈eniyo obl̈ë kong dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","No to ter kjok dogo dwayo ëre shrono shäng kjok ëreshko, ëye parkë bor kong wl̈o l̇l̇ëme. Tja shrono shäng parkë obl̈ë kong wl̈o. Ga tja optwë, wol̈on wl̈o, tja ber nopga ara potjwl̈ẽkkl̈o wl̈o, epga där wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús opshino jek shäng Jericó kjokyo dwayo ba oppinggaga tjokshko ga nopga to jek ara ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eshko ga domerga l̈öng irbo sor go do pjök kjok ĩgö l̇l̇ëm wl̈eniyo. Kuya l̈ok ga Jesús jek shäng eshko ga tjl̈ẽno dbo go, tjl̈ẽ ga «¡Tjl̈apga, David tjëyo, tjawa songe l̈ozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Eni ga nopga jëk l̈öng Jesús tjok l̈i tjl̈ẽ ba kong ga «Pjãy kjinkozong» l̈e. Kuya l̈ok ga gueniyo kjinkë l̈ok l̇l̇ëme. Tjl̈ẽ l̈ok dbo go jek obi ga «¡Tjl̈apga, David tjëyo, tjawa songe l̈ozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eni ga Jesús kojongö shäng, ga tjl̈ẽ ba kong ga «¿L̇l̇ëye woydëmi ga shäryër bomi kong?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","«Tjl̈apga, tjawa kjok ĩk woydë» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Eshko ga songe l̈e Jesúsdë, ga bokkwo porwara. Jekdo eshko ga beno l̈öng kjok ĩgö wẽl̈ë, ga to jek l̈ok Jesús tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús jek shäng jongya Jerusalén kjokyo ba oppinggaga tjokshko ga öötong l̈öng Betfagé kjokyo, e ber buk Olivos dl̈upyo pogl̈o go. Eshko ga ba oppinggaga jek l̈öng ba tjok l̈i rokara do pjök, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ga tjl̈ẽ ba kong ga «Pjãy nom kjok buk bi bokshto kjweshko. Kjweshko ga öng so kwomgl̈a kjoyo dre töshko popga wl̈ẽmi sök kjl̈ara kjro go, ba wa wl̈ënggl̈a tjok. Komi, ga tek sömi bor kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eshko ga ëbo l̇l̇ëbo l̈ë bomi kong wl̈enishko ga “Woyde Tjl̈apgarë” l̈ëmi ba kong eni, ga iche tek bomi tjok jekdo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Shäryono eni, tjl̈õkwo l̈ara Sbö tjl̈õkwo l̈aga tek dënashko sorë l̈i ber jl̈õkoyo wl̈o. Tjl̈ẽno beno eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«L̈ëmi Sión sopga kong ga “Bomi pjl̈u tek sök dörö bomi shwoy wl̈ẽp, öng so kwomgl̈a kjoyo dre töshko kjing go. Tjwe öng l̇l̇ëbo shgokl̈o wa kjing go” l̈ëmi ba kong eni.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kuya l̈ok ga shäryara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Öng l̈i söra tek shrono ba wa tjok. Ga ba shwong kop l̈ëkong l̈i iara öng do pjök l̈i kokso kjing go. Eshko ga Jesús opyono sök öng l̈i kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Eshko ga nopga jek l̈öng ba tjok ara. Kjone kjone, ba shwong kop l̈ëkong skwara l̈ok, ga kwoptara l̈ok irbo bäng go. Kjone kjone, kjor korga zara, ga kwoptara l̈ok irbo bäng go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nopga jek l̈öng ba bäm go, nopga jek l̈öng ba irgo, öö l̈e l̈ok ara. Tjl̈ẽ ga «David tjëyo kjwe pjl̈ú jl̈õe. Kjwe ichara Tjl̈apgarë shrono kjok ëreshko. Kjwe kjimte Sbörë. Sbö sök kjok dogo, e pjl̈ú jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús jek opzrëno Jerusalén kjokyo roshkoshko ga nopga tjeng eshko l̈i shdöktong uunkong l̇l̇aw pogo, ga tjl̈ẽ ga «¿Kjwe ëro?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nopga jek l̈öng Jesús tjok l̈i tjl̈ẽ ba kong ga «Kjwe Jesús. E Sbö tjl̈õkwo l̈aga. E Nazaret so. Nazaret kjokyo, e Galilea kjokyo obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","E irgo ga Jesús jek opzrëno öötong shäng Sbö u zl̈ong bäng, ga nopga l̈öng eshko l̇l̇ëbo soynek, l̇l̇ëbo tjwl̈ẽk l̈i ichara uunkong ey dwayo. Ba dbur bapkwo kjl̈opswozl̈ong oba kong l̈i poskara beno tjeng töshko. Dunggwo soynega sökkl̈o l̈i poskara beno tjeng töshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ga tjl̈ẽ ba kong l̈ok ga «Sbö tjl̈õkwo tak pjang eni: “Bor u, e kowëba ber syõ uyo wl̈o. Gueniyo ioromi beno jong l̈ũ uyo”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Eshko ga nopga kjok ĩgö l̇l̇ëm wl̈eniyo, nopga jëk l̇l̇ëm wl̈eniyo, e tek shrono l̈öng Jesús zl̈ong bäng, ga poptara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e l̈öng eshko. Jesús shäng l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryë l̈i ĩna l̈ok. Eshko ga öö l̈e kjwozirgarë l̈öng Sbö u zl̈ong bäng, tjl̈ẽ ga «David tjëyo kjwe pjl̈ú jl̈õe» l̈e l̈i kura l̈ok bakoe. Eni ga iirkë l̈ok ara, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ga tjl̈ẽ l̈ok Jesús kong ga «¿L̇l̇ëye l̈e l̈ok l̈i kup shängde?» «Ëng. Sbö tjl̈õkwo tak pjang eni: “Kjwozirga, chidaga, e ichorop bop poshrëk, ba tëkwo go.” ¿E l̈omirë l̇l̇ëmdo?» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","E irgo ga nopga l̈i beno l̈öng eshko, ga Jesús to opshino Jerusalén kjokyo dwayo, jek öötong shäng Betania kjokyo, ga pono beno buk shkër kjwara eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wẽshko kjok shröng ga Jesús to jek shäng iröng obi Jerusalén kjokyoshko ga pjl̈i arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Eshko ga kjor jong kjl̈ara irbo l̈i sor go ko higuera. Ĩya ga jek äär ba zl̈ong ga jong bo dret, korga tjok erä. Eni ga tjl̈ẽ kjor jong l̈i kong ga «Pja ber botjyë ame» l̈e ba kong, ga kjor l̈i dano jekdo beno jong dogroe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ĩya ba oppinggagarë ga beno l̈öng yëy l̈e erä. Ga tjl̈ẽ ba kong ga «¿Kjor kjwe dano jekdo sorë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","«Pjãy mär bor go jl̈õkoyo, ga bor dbo ara äär l̇l̇ë go l̇l̇ëme l̈ëmi l̇l̇ëm wl̈eni ga l̈ër bomi kong jl̈õkoyo ga l̇l̇ëye shäryoror ëre shäryëmi ga pjl̈ú, ga pjãy tjl̈ẽ dl̈up ëre kong ga “Dl̈up, pja opkjos jer dl̈ung roy” l̈ëmi ga shäryë eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pjãy l̇l̇ëbo rokë syõ goshko ga woyotjl̈ĩmi ga twe Sbörë l̈ëmi jl̈õkoyo ga wl̈ẽmi» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E irgo ga Jesús opzrëno jek öötong shäng Sbö u zl̈ong bäng. Eshko ga oba pĩya shäng wopro ga syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, e tek shrono l̈öng ba zl̈ong bäng ga tjl̈ẽ l̈ok ba kong ga «¿L̇l̇ëye shäryëp shäng l̈i shäryëp ega? ¿Pja ichaga ërë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","«Pjãy kong l̇l̇ëbo kjakrokër bakoe. ¿Juan No Waga, e ichaga ërë no wë? ¿Ichaga Sbörëre, de norë? Tja dboryoromi ga tja ichaga ërë l̈ër bomi kong bakoe» l̈e ba kong. Kuya l̈ok ga tjl̈ẽ l̈ok ëng kong ga «Ichaga Sbörë l̈oroy ba kong wl̈eni ga “¿Tjl̈õkwo kjroromi l̇l̇ëm ega?” l̈e bi kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Gueniyo Juan, e Sbö tjl̈õkwo l̈aga l̈e nopga uunkongdë. E kjĩshko ga ichaga norë l̈ëy ga ä bakoe. Nopga l̈i bangkjrëy ara kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eni ga tjl̈ẽ l̈ok Jesús kong ga «Miydërwa l̇l̇ëme» l̈e. Kuya ga tjl̈ẽ ba kong ga «E kjĩshko ga tja ichaga ërë l̈ër bomi kong l̇l̇ëm bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","E irgo ga Jesús tjl̈ẽ ba kong ga «L̇l̇ëye l̈ër bomi kong ëre woyotjl̈ĩzĩa. Domer shäng kjl̈ara, wapga tjeng domerga do pjök. Pjl̈ara ga tjl̈ẽ ba wa kjl̈ara kong ga “Pja nom parkë bor kjokshko, kjil̇l̇gwo bo ara l̈ishko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kuya ga tjl̈ẽ ba kong ga “¡Tja jek parkë woydë l̇l̇ëme!” l̈e. Gueniyo döni ga wotjl̈ĩno obl̈ë, ga to jek parkë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","E irgo ga domer l̈i tjl̈ẽ ba wa kjl̈ara obi kong ga “Pja nom parkë bor kjokshko” l̈e. Kuya ga tjl̈ẽ ba kong ga “Jöl̈ö, Data. Tja to parkë” l̈e, gueniyo to jek l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","¿Kumi ga ba wa kjone dey ga ba data kol̈ara?» l̈e. Nopga l̈öng eshko l̈i tjl̈ẽ ba kong ga «Bäm go l̈ira ba data kol̈ono» l̈e. Kuya ga tjl̈ẽ ba kong ga «L̈ër bomi kong jl̈õkoyo ga nopga dbur töngga Roma so kong, wal̈ëga to l̈öng opsoynek domerga obl̈ë obl̈ë kong wl̈eniyo, e äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko bomi bäm go. Juan No Waga shrono shäng irbo pjl̈o bek l̈i ping bomi kong, ga tjl̈õkwo kjroromi l̇l̇ëme. Gueniyo ga nopga owa l̈ër l̈i, epgara omtjl̈õkwo kjrono. Ĩnomi eni ëmdë ga l̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈oromi l̇l̇ëm, ga rayoromi l̇l̇ëm, ga tjl̈õkwo kjroromi l̇l̇ëm obi. E kjĩshko ga nopga owa l̈ër l̈i kongda, Sbö, e ber ba pjl̈uyo, bomi bäm go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","»Tja tjl̈ẽ bomi kong l̇l̇ëbo jyãgl̈o go. Kuzĩa. Domer shäng kjl̈ara kjok sogo. Pjl̈ara ga kjil̇l̇gwo dwl̈ayo dgara ba kjokshko, kjëryo tyara jong pjribri, kl̈ung kjara ber kjil̇l̇gwo bo l̇l̇ruzl̈ong shtoyo wl̈o, ga u shäryara jong kjwara ba dwl̈a l̈i dokl̈o. Pjir ga kjok l̈i poskwona parkagaga kjl̈öbö kong, potjwl̈ẽya ĩ, ga to kjok shto obl̈ë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","»Öötong kjil̇l̇gwo bo kjrozl̈ong dbaryo ga ba parkagaga ichara kjl̈öbö, kjil̇l̇gwo bo ber ba kong l̈i rokë parkagaga beno l̈öng ba kjok daga l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Gueniyo ga ba parkagaga ichara tjwe l̈öng l̈i shara kjok dagaga l̈öng l̈irë, kjl̈ara shpora, kjl̈ara zröra, kjl̈ara l̈öra ak go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","E irgo ga ba parkagaga ichara jek kjl̈öbö obi, ichara bäm go l̈i kjinmo. Öötong l̈öng kjok buk l̈ishko ga l̇l̇ëye shäryara kjok dagaga l̈öng l̈irë bäm go sorë ga shäryara jek eni obi parkagaga ichara obi l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","»E irgo ga ba wa ichayde shara. Wotjl̈ĩk ga “Miydër ga bor wa ërera bangkjre l̈ok” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Gueniyo öötong shäng eshko ga ba wa l̈i ĩya kjok dagaga l̈öng l̈irë ga tjl̈ẽ l̈ok ëng kong ga “L̇l̇ono ga kjwe ber kjok ëre sogo. Zröroy wl̈eni ga kjok ëre kjrëy, ber bi kong wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eni ga shara l̈ok, shira kjok l̈i roy dwayo, ga zröra l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","»¿Eni ga kjok sogo l̈i tjwe iröng obishko ga l̇l̇ëye shärye ba tjok l̈ok l̈ëmi?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kuya l̈ok ga tjl̈ẽ ba kong ga «Parkagaga owa l̈i songe l̈e l̇l̇ëme. Zröya jekdo. Pjir ga parkagaga wl̈ẽya obl̈ë, dwl̈a bo kjrozl̈ong dbaryo ga dwl̈a ba kong bayo kjöme l̈i twe ba kong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kuya ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: »“Akkwo woydara u shäryagagarë l̈ok l̇l̇ëm l̈i, e iak beno buk bäm go, beno tjwl̈õ ara, obl̈ë kjinmo. Shäryara Tjl̈apgarë eni, ga tjawa beno l̈öng yëy l̈ërwa erä.” ¿E l̈omirë l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","E kjĩshko ga l̈ër bomi kong ga pjãy kjrara Sbörë, e ber bomi pjl̈u wl̈o. Gueniyo pjãy omkol̈ë l̇l̇ëm kuzong ga obl̈ë omkol̈ë pjl̈ú l̈i kjrayde, e ber ba pjl̈u shara wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ëye l̈ono akkwo ëre kjing go ga tar pjäs erä. Ga akkwo ëre l̈ono ë kjing go ga e sho shguir ber tjeng l̈ul̈ue» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tjl̈ẽno l̇l̇ëbo jyãgl̈o go l̈i kuya syõshtaga kägäyoga, fariseogarë ga miydara l̈ok ga ba l̈ayde shäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eni ga shaya l̈ok woydë, bängzaya l̈ok wl̈o. Gueniyo oba bangkjre l̈ok ara, Jesús, e Sbö tjl̈õkwo l̈aga l̈ëba kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go jek obi. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Sbö ber no pjl̈uyo sorë, e so l̇l̇ëbo l̈ër bomi kong ëre kjoyoe. Pjl̈u shäng kjl̈ara, ba wa domer orkwosmozl̈ong dbaryo shrëkkl̈o poshärye shäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Eni ga ba parkagaga ichara kjl̈öbö nopga mana l̈i rokë, gueniyo tek l̈ok woydë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","E irgo ga ba parkagaga obl̈ë ichara jek tjl̈ẽ nopga mana l̈öng l̈i kong ga “Bor wa orkwosmozl̈ong dbaryo shrëkkl̈o, e poshäryak pjire. Nopga ichoror öng tjeng kjl̈o dik l̈i zrök, ga shäryak tjeng pjir tjän. Pjãy tek mal̈inge” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","»Kura l̈ok, gueniyo kol̈ara l̈ok l̇l̇ëme. Kjone kjone jek l̈ok ba kjokshko. Kjone kjone jek l̈ok ba pakshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kjone kjone, pjl̈u parkagaga l̈i shara l̈ok, shpokza tjã tjã, ga zrörae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","»Roy kuya pjl̈urë ga iirkonoe. Eni ga ba ëngkjwagaga ichara ba parkaga zrögaga l̈i zrök, ba kjok l̈i suk pjir bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Döni ga tjl̈ẽ ba parkagaga kong ga “Dl̈i l̇l̇ë shäryak tjeng pjir tjän, gueniyo nopga manor bäm go l̈i tjwl̈õ l̇l̇ëm, tek tjwe na wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eni ga pjãy nom irbo bäng, nopga tön arashko ga ë pogo wl̈ẽnomi l̈i mami, bor wa orkwosmozl̈ong dbaryo shrëya l̈ok bi tjok wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eni ga ba parkagaga opshino jek, ga nopga pjl̈ú, nopga owa, e wl̈ẽna irbo bäng go kjl̈obi l̈i mana l̈ok drete. Eni ga ba u dl̈ino jong tjung no erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","»Pjl̈u opzrëk jek äär nopga mana l̈öng l̈i ĩkshko ga ĩya ga domer jek shäng kjl̈ara, do go shwong orkwosmokkl̈o wl̈eniyo drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eni ga tjl̈ẽ ba kong ga “¿Pja tek shäng doyono shwong orkwosmokkl̈o wl̈eniyo go l̇l̇ëm ega?” l̈e. Kuya kjing erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Eni ga pjl̈u tjl̈ẽ ba parkagaga l̈öng l̈i kong ga “Kjwe shazĩ, pjrizĩ ba dre go, ba orkwo go, ga dbuzĩ jek kjoko, kjok ro sĩ roshko, ber shäng sl̈ar eshko, kowo uë, l̇l̇ëbo bang ara ba kong kjĩy” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nopga mak ara, gueniyo kjrak l̈i kjl̈öbö erä» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","E irgo ga fariseoga töno, l̈ano l̈ok ëng kong. Woydara ga l̇l̇ëbo kjakroke Jesús kong, dborye bëy l̇l̇ëm ga doshaya l̈ok e go, rote wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Eni ga ba oppinggaga ichara kjl̈öbö, Herodes pjl̈oyoga tjok. Öötong l̈öng Jesús shwoy ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, miydërwa ga pja tjl̈ẽ beke. Woyde Sbörë ga shji jëk sorë l̈i l̈ëp jl̈õkoyo. No tjl̈ẽshko ga tjl̈õkwo kup l̇l̇ëm, tjwl̈õ kjöm pogo, e bop kong ga tjwl̈õ beke. Pja tjl̈ẽ bek ë pogo kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Eni ga shji kä potjwl̈ẽk pjl̈u kësbangyo sök Roma kjokyo l̈i kong ga pjl̈úre?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kuya ga miyde ga l̈öng wotjl̈ĩk owa. E kjĩshko ga tjl̈ẽ ba kong ga «¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! ¿Tja tjl̈ĩmi ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dburwa kä potjwl̈ẽkkl̈o l̈i tek sözĩ bor kong kjwara, ĩn wl̈o» l̈e, ga tek söra l̈ok ba kong kjwara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eni ga tjl̈ẽ ba kong ga «¿Domer jyãgl̈o sök dburwa ëre go jũ ë? ¿Ko tak pjang ëre go jũ ë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","«Kjwe pjl̈u kësbangyo sök Roma kjokyo l̈i ĩ» l̈e l̈ok ba kong. Kuya ga tjl̈ẽ ba kong ga «Eni ga l̇l̇ëye pjl̈u ĩ l̈i, e twozĩ pjl̈u kong, gueniyo l̇l̇ëye Sbö ĩ l̈i, e twozĩ Sbö kong bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kuya l̈ok ga beno l̈öng wotjl̈ĩk ara, ga to l̈ok ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Saduceoga wotjl̈ĩk ga no wol̈ono ga woshrë ame l̈e. Eni ga eshko dbaryo ga saduceoga tek shrono l̈öng Jesús shwoy kjl̈öbö ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Tjl̈apga no pingga, kjibokwo tara Moisésdë beno pjang l̈i tjl̈ẽ ga “Ëye wol̈ono, wapga beno ba boy tjok l̇l̇ëm ga shinmo kjl̈arayo l̈i orkwosmok ba boy beno sök l̈i tjok, wa tjok wl̈eni ga ber shinmo l̈i ĩ wl̈eni wl̈o.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","»Pjl̈ara ga borwa tjrëko ëreshko ga domerga l̈öng dogl̈o kjäk (7), epenga döe. Ba këguëyo orkwosmono, ga wol̈ono, ga wapga beno l̇l̇ëm kuzong ga ba l̈ëng orkwosmono ba syã tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Eni ga ba l̈ëng wol̈ono jek bakoe. Ba l̈ëmga kjl̈obi l̈i orkwosmono ba syã tjok eni bako, ga wol̈ono uunkong, ga wapga beno ba boy tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","E irgo ga wal̈ë l̈i to wol̈ono bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Eni ga domerga dogl̈o kjäk (7) l̈i orkwosmono uunkong wal̈ë l̈i tjok kuzong ga no woshrozl̈ong dbaryoshko ga wal̈ë l̈i ber domerga kjone dey l̈i boy?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","«¡Pjãy diktong l̈öng jl̈õe! Sbö tjl̈õkwo tak pjang l̈i miydëmi l̇l̇ëm, ba dbo kësbang l̈i miydëmi l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","No woshrozl̈ong dbaryoshko ga ëye orkwosmok ame. Eshko ga nopga ber l̈öng Sbö parkagaga kjok dogo so wl̈eni shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Pjãy wotjl̈ĩk ga no wol̈ono, ga woshrë ame l̈ëmi. Gueniyo ga Sbö tjl̈ẽno bomi kong ga “Tja Abraham, Isaac, Jacob, e Sbö” l̈ara. ¿E l̈omirë l̇l̇ëmdo? E shinmoga Sbö l̇l̇ëme. E nopga l̈öng së l̈i Sbö» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kuya nopga l̈öng l̈irë ga beno l̈öng yëy l̈e erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceoga kjinkara Jesúsdë l̈i kuya fariseogarë ga ëng töno l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Eshko ga fariseo shäng kjl̈ara, kjok l̇l̇gwekkl̈o tara Moisésdë l̈i miydaga pjl̈ú wl̈eniyo. E tek shrono shäng Jesús zl̈ong bäng, ba tjl̈ĩk wl̈o. Tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Tjl̈apga no pingga, ¿kjok l̇l̇gwekkl̈o tjwl̈õ kësbangyo l̈i kjone dey?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","«“L̇l̇ëbo woydëpshko, l̇l̇ëbo woyotjl̈ĩpshko, l̇l̇ëbo shäryëpshko, pja sök së obishko ga Tjl̈apga, bop Sbö l̈i woydos jl̈õkoyo ĩyado.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kjok l̇l̇gwekkl̈o tjwl̈õ kësbangyo l̈i e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kjok l̇l̇gwekkl̈o kjrina obi tjwl̈õ ara, e so bäm l̈i kjoyoe. Tjl̈ẽ ga “Pja opwoydë sorë ga bop kjl̈ara, e woydos eni bakoe.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kjok l̇l̇gwekkl̈o kjring pjök ëre tjwl̈õ ara anmoyõ. Kjok l̇l̇gwekkl̈o l̇l̇amo tak l̈ok l̈i, l̇l̇ëye tara Sbö tjl̈õkwo l̈agagarë l̈i, e beno shji Sbö woydë sorë, shji ëng woydë sorë, e pinggl̈o bi kong eröe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseoga l̈öng eshko obi wopro ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús tjl̈ẽ ba kong ga «¿No pjl̈uyo iche l̈e Sbörë l̈i, e ë tjëyo l̈ëmi?» «E David tjëyo» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kuya ga tjl̈ẽ ba kong ga «¿Eni ga David go Sbö Sëyashko ga no pjl̈uyo l̈i kowara ba Tjl̈apgayo ega? Eshko ga David tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","»“Tjl̈apga tjl̈ẽno bor Tjl̈apgayo kong ga ‘Pja tek wl̈ar ber sök bor orkwo kël̈ëkong, äär jong bop moskwoga zanor pjir guing, eshko ga twër ber bop kong ichëp wl̈o’ l̈e.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","»¿Eni ga no pjl̈uyo l̈i kowara Daviddë ba Tjl̈apgayo kuzong ga e ber ba tjëyo tek ber ba irgo l̈i sorë?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kuya l̈ok ga to dboryara ërë l̇l̇ëme. Eshko dbaryo jek l̈ëkong ga ëye wokjang l̇l̇ëbo kjakrokë ba kong wl̈o ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","E irgo ga Jesús tjl̈ẽ nopga tjeng ara l̈i kong, ba oppinggaga kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga, e wotjl̈ĩk l̈ok ga no pinggaga Sbö tjl̈õkwo go jl̈õkoyo l̈i epga, ëye obl̈ë drete l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","E kjĩshko ga pjãy pĩya sorë ga shäryozĩ eni, gueniyo epga omshäryë l̈öng sorë l̈i, pjãy omshäryë eni l̇l̇ëme. Nopga kjwe tjl̈ẽ ga “L̇l̇ëbo shäryëy jũni” l̈e, gueniyo omshäryë l̈öng obl̈ë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","»Oba pĩyashko ga tjl̈õkwo l̈e l̈ok ara l̈i shäryëba uunkong ga äe. E so l̇l̇ëbo kwing ä twe obl̈ë kong söya wl̈o kjoyoe. Shärye l̈ok eni, gueniyo epga om go omkjimtë ba sök l̇l̇ëm, ba sakkwo go ëmdë l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","L̇l̇ëbo shärye l̈ok kës l̈i, e ĩkoba wl̈o erä. Sbö tjl̈õkwo tak pjang kjibokwo go l̈i pjriya l̈ok ba bokdo go, ba sjä̃kso go ĩyado. Ba shwong kjarbo shẽshẽ l̈i shärye l̈ok kur may, pjë äär kjl̈ay kl̈ung go wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Oba tön, iëshko ga woyde ga l̈öng bäm goshko, sökkl̈o pjl̈ú goshko, shärye l̈ok eni judíoga syõ uyo roshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Woyde l̈ok ga miga l̇l̇ë l̈ëba ba kong yõtso l̇l̇ëbo soynezl̈ong, ga kowëba no pingga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","»Gueniyo ga pjãyda epenga dö wl̈eni. Pjãy pingga sök kjl̈araso. E kjĩshko ga pjãy kowëba no pingga l̇l̇ëm dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pjãy Data kjl̈araso, Sbö sök kjok dogo l̈i e. E kjĩshko ga kjok ëre kjing goshko ga ëye kowëmi data l̇l̇ëm dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pjãy bapshiga kjl̈araso. Tja, no pjl̈uyo ichara Sbörë shrono shäng ëre l̈i e. E kjĩshko ga pjãy kowëba no bapshiga l̇l̇ëm dey bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ëye opyë woydë tjwl̈õ kësbang, obl̈ë kjinmo ga opyë ber shäng obl̈ë kjimtaga dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ëye opyono tjwl̈õ ara ga ie ber tjwl̈õ l̇l̇ëme. Ëye opkjl̈opswono beno wotöy ga ie ber tjwl̈õ ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","»¡No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga, pjãy song jl̈õ, pjãy shdungko! ¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! Nopga, Sbö ie ber ba pjl̈uyo wl̈o l̈i l̈e ga somi ara. E so u bäng bängzami, nopga opzrëk jek ba roshko l̇l̇ëm wl̈o kjoyoe. Pjãy opzrëk eshko l̇l̇ëm, ga no obl̈ë opzrëk woydë eshko l̈i ichëmi opzrëk eshko l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","»¡No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga, pjãy song jl̈õ, pjãy shdungko! ¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! Pjãy to l̈öng dl̈ung kjing, kjok shto obl̈ë obl̈ë, no wl̈ẽk ber bomi oppingga wl̈o. Wl̈ẽnomishko ga pimi owa. Eni ga ber shäng owa, bomi kjinmo. Pjãy shdungko, pjãy ber l̈öng iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko wl̈o. Gueniyo bomi oppinggaga l̈i, e shdungko, bomi kjinmo anmoyõ. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","»¡Pjãy song jl̈õ, pjãy shdungko! Pjãy so no kjok ĩgö l̇l̇ëm wl̈eniyo kjoyo, gueniyo no wl̈osömi l̈ëmi. Pjãy tjl̈ẽ oba kong ga “Shji tjl̈ẽno jl̈õkoyo Sbö u kjĩshko ga e l̇l̇ëno l̇l̇ëme. Gueniyo shji tjl̈ẽno jl̈õkoyo dbur sho shõyl̈ṍr smok l̈ok Sbö u goshko l̈i kjĩshko ga l̇l̇ëye l̈oroy jl̈õkoyo l̈i shäryëy kjl̈uwe” l̈ëmi oba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pjãy kjok miydë sira l̇l̇ëme. Pjãy so no kjok ĩgö l̇l̇ëm wl̈eniyo kjoyoe. Dbur sho shõyl̈ṍr smok l̈ok Sbö u goshko l̈i iak beno tjeng dboy Sbö kong, Sbö u l̈i kjĩshko. ¿Eni ga l̇l̇ëye tjwl̈õ ara anmoyõ l̈i l̇l̇ë, dbur sho shõyl̈ṍr l̈ire, de Sbö u l̈i? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","»Pjãy tjl̈ẽ oba kong ga “Shji tjl̈ẽno jl̈õkoyo öng sho sukkl̈o l̈i kjĩshko ga e l̇l̇ëno l̇l̇ëme. Gueniyo shji tjl̈ẽno jl̈õkoyo öng twara, zröra, suya buk öng sho sukkl̈o kjing go l̈i kjĩshko ga l̇l̇ëye l̈oroy jl̈õkoyo l̈i shäryëy kjl̈uwe” l̈ëmi oba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pjãy so no kjok ĩgö l̇l̇ëm wl̈eniyo kjoyoe. Öng twara, zröra, suya buk öng sho sukkl̈o kjing go l̈i iak beno buk dboy, öng sho sukkl̈o l̈i kjĩshko. ¿Eni ga l̇l̇ëye tjwl̈õ ara anmoyõ l̈i l̇l̇ë, öng l̈ire, de öng sho sukkl̈o l̈i? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","»E kjĩshko ga ëye tjl̈ẽ shäng jl̈õkoyo öng sho sukkl̈o l̈i kjĩshko ga tjl̈ẽ shäng jl̈õkoyo ba kjĩshko dö l̇l̇ëme. Tjl̈ẽ shäng jl̈õkoyo l̇l̇ëbo buk ba kjing go l̈i kjĩshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ëye tjl̈ẽ shäng jl̈õkoyo Sbö u kjĩshko ga tjl̈ẽ shäng jl̈õkoyo Sbö sök eshko l̈i kjĩshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ëye tjl̈ẽ shäng jl̈õkoyo kjok dogo kjĩshko ga tjl̈ẽ shäng jl̈õkoyo Sbö pjl̈u sökkl̈o kjĩshko bako, Sbö sök ba sökkl̈o kjing go kjĩshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","»¡No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga, pjãy song jl̈õ, pjãy shdungko! ¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! L̇l̇ëbo wl̈ẽnomi l̈i shtëmi äär ba sakyo (10) go, ba sakyo (10) go, shimi kjrina kjrina, ga twëmi Sbö kong. Bomi dl̈i mokyo obl̈ë obl̈ë tjok ga shäryëmi l̈öng jl̈õkoyo eni bakoe. Gueniyo kjok l̇l̇gwekkl̈o tak pjang tjwl̈õ ara, ba kjinmo l̈ira kol̈ëmi l̈öng l̇l̇ëme. Pjãy kjok l̇l̇gwek bek l̇l̇ëme. Obl̈ë songe l̈ëmi l̇l̇ëme. L̇l̇ëbo l̈ëmi obl̈ë kongshko ga shäryëmi l̇l̇ëm bakoe. Pjl̈ú wl̈o ga kjok l̇l̇gwekkl̈o tjwl̈õ ara ëre shäryomirë dey, kjok l̇l̇gwekkl̈o obl̈ë l̈i shäryozĩ ĩyado bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pjãy so no kjok ĩgö l̇l̇ëm wl̈eniyo kjoyo, gueniyo no wl̈osömi l̈ëmi. Kjok l̇l̇gwekkl̈o, e l̇l̇ë l̈okl̈o miydëmi l̇l̇ëme. E kjĩshko ga l̇l̇ëye tjwl̈õ ara l̇l̇ëm l̈i, e shäryomirë l̈öng. Gueniyo l̇l̇ëye tjwl̈õ ara l̈i, e shäryëmi l̈öng l̇l̇ëme. Pjãy so no sök di ië kjoyoe. L̇l̇gwirwa buk ba di iokl̈o roshko l̈i shira, gueniyo öng kësbang buk ba roshko l̈ira dwara jer, miydara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","»¡No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga, pjãy song jl̈õ, pjãy shdungko! ¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! Pjãy l̇l̇ëbo shäryë ara, pjãy pjl̈úe l̈ëba wl̈o, gueniyo ga pjãy kirkë ara, pjãy wotjl̈ĩk dbur töng bomi kong erö. Pjãy so di iokl̈o, dl̈i uokl̈o kjoyoe. E kwoshkwak ba pogl̈o go, gueniyo roshko wl̈iwl̈ie. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseoga, pjãy so no kjok ĩgö l̇l̇ëm wl̈eniyo kjoyoe! Pjl̈ú wl̈o ga di iokl̈o, dl̈i uokl̈o, e ro kwoshkwëmi bäm goshko. Pjir ga ber drëpdrë jl̈õe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","»¡No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga, pjãy song jl̈õ, pjãy shdungko! ¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! Pjãy so shinmo bapkwo poshtik pjl̈ubl̈ún, wol̈ësowa kjoyoe. Ĩkoba ga pogl̈o go pjl̈ú, gueniyo roshko shinmo dbogl̈o, l̇l̇ëbo wl̈iwl̈i tjeng ara eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pjãy so e kjoyo bakoe. Ĩkoba ga pjãy pjl̈o beke l̈ëba, gueniyo pjãy wotjl̈ĩk owa erä, l̇l̇ëye l̈ëmi ga shäryëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","»¡No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga, pjãy song jl̈õ, pjãy shdungko! ¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! Sbö tjl̈õkwo l̈agaga shinmotkono tjeng dënashko l̈i, ak sho shäryëmi ba sak kjing go, ber l̈öng kjone miydëba wl̈o. Nopga pjl̈o bek shinmotkono l̈i sakyo poshäryëmi, ber wol̈ësowa wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","E irgo ga pjãy tjl̈ẽ ga “Tjawa kjwe l̈öng borwa tjl̈apgaga tek dënashko so dbaryoshko ga Sbö tjl̈õkwo l̈agaga zrörorwa l̇l̇ëme” l̈ëmi eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eni ga miydëmi ga pjãy Sbö tjl̈õkwo l̈agaga zröga l̈i tjëyoga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Shäryara bomi tjl̈apgaga tek dënashko so l̈irë sorë ga pjãy omshäryë jek eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Pjãy so dgur kjoyoe! Pjãy shdungko, pjãy ber l̈öng iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko wl̈o. ¿Pjãy där, äär eshko l̇l̇ëm wl̈o ga sorëro? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","»E kjĩshko ga Sbö tjl̈õkwo l̈agaga, nopga kjok miydë ara, no pinggaga, e ichër jek bomi kong. Gueniyo kjone kjone zrömi, kjone kjone zrömi l̈ok kjl̈ös go, kjone kjone shpomi no shpokkl̈o go judíoga syõ uyo roshko, ga töktong l̈ok. Eni ga irpjami to l̈öng kjok shto obl̈ë obl̈ë go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tek dämär ga nopga pjl̈o bek l̈i srëng kwono ara. Tek jong Abel go äär jong Zacarías, Berequías wa l̈i go eni. Zacarías pjl̈o bek, gueniyo zröromi Sbö u jong l̈i, öng sho sukkl̈o jong l̈i, e tjrëko. L̇l̇ono ga owa ëre ber pjang bomi go. Pjãy shdungko e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","L̈ër bomi kong jl̈õkoyo ga eerishko dbaryo sopga, pjãy shdungko l̇l̇ëbo owa ëre uunkong kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","»¡Jerusalén sopga, tja kuzĩa! Sbö tjl̈õkwo l̈agaga zrömi. Sbö tjl̈õkwo roy l̈agaga ichara bomi kong l̈i l̈ömi ak go, zrömi wl̈o. Woydoror enido ga pjãy tön, kjörkö meyo ba wapga töno tjeng ba sjä̃gä dirko wl̈eni, gueniyo woydoromi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tja kuzĩa. Bomi u, e raye Sbörë ber jong tjoksa. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","L̈ër bomi kong ga tja ëre ĩmi ame, äär jong pjãy tjl̈ẽ l̈öng ga »“Kjwe ichara Tjl̈apgarë tjwe kjok ëreshko. Kjwe kjimte Sbörë” l̈ëmi l̈öng guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","E irgo ga Jesús opshino jek Sbö u jong l̈ishko dwayo. Jëk shängshko ga ba oppinggaga tek l̈öng ba zl̈ong bäng ga tjl̈ẽ l̈ok ba kong ga «U l̈ok ëre ĩzong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kuya ga tjl̈ẽ ba kong ga «¿U l̈ok ëre ĩmi l̈öngde? L̈ër bomi kong jl̈õkoyo ga ëreshko akkwo ëmdë ber tjeng ëng kjing go kjwara l̇l̇ëme. L̇l̇ëbo tjeng kës ëre pjir ber drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","E irgo ga jem öötong l̈öng Olivos dl̈upyo ga Jesús sirkeno sök eshko. Ba oppinggaga tek l̈öng ba zl̈ong bäng, tjl̈ẽ ba kong tjoksa wl̈o. Eshko ga tjl̈ẽ l̈ok ga «¿L̇l̇ëye l̈ëp shäng l̈i, e shäryë l̇l̇ono? ¿Pja tjwe iröng dörö l̈i jyãgl̈o wen l̇l̇ë? ¿Kjok pjir dörö l̈i jyãgl̈o wen l̇l̇ë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","«Pjãy sjëk, pjãy jyãpgwëba l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Eshko ga nopga wen tjwe ara tjl̈ẽ ga “No pjl̈uyo ichara Sbörë shrono shäng l̈i tja” l̈e. E go ga oba jyãpgwe ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","»Roy kumi ga oba ëngkjwë kjok shto obl̈ë obl̈ë arashko ga l̇l̇ëye bangkjrëmi l̇l̇ëme. E shäryë eni kjl̈uwe. Gueniyo eshko ga kjok pjir dbaryo l̈i äätë l̇l̇ëm obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tjëyoga obl̈ë obl̈ë ëngkjwë l̈ok ëng tjok. Nopga kjok shto obl̈ë obl̈ë so ëngkjwë l̈ok ëng tjok bakoe. Pjl̈i tjwe ara kjok shto obl̈ë obl̈ë. E ga yo tjwe ara kjok shto obl̈ë obl̈ë bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gueniyo l̇l̇ëbo wen tjwe owa anmoyõ l̈i soye l̇l̇ëbo kës ëre go kjwl̈ë jã. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","»Eshko ga pjãy twëba kjok l̇l̇gwegaga kong, pjãy shdũya l̈ok wl̈o, ga pjãy zröya l̈ok bakoe. Bor kjĩshko ga pjãy ĩywaba shjiktëng kjok kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Eshkoshko ga nopga ara mär bor go ame. Epga ëng ĩywõ shjiktëng, ëng rotë kar kar, ëng twë kjok l̇l̇gwegaga kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Eshko ga nopga ara to l̈öng tjl̈ẽ ga “Tja Sbö tjl̈õkwo l̈aga” l̈e, gueniyo e ichaga Sbörë l̇l̇ëme. E go ga oba jyãpgwe ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Eshko ga nopga wotjl̈ĩk owa ëng kong ara. E kjĩshko ga nopga l̈öng ara ëng woydë ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gueniyo ga ëye mär bor go äär jong ba dbo go ga era där ber shäng pjl̈ú ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sbö ber no pjl̈uyo sorë l̈i roy pjl̈ú, e shdär kjok kjwang jĩkong, miyde tjëyoga uunkongdë wl̈o. Eshko ga öötong kjok pjir dbaryoshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","»Dënashko ga Sbö tjl̈õkwo l̈aga Daniel, e tjl̈õkwo tono l̇l̇ëbo shäryë owa anmoyõ Sbö shto zrek roshko kjĩshko. Ëre woydër ga kumi yõtso. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Eshko ga pjãy l̈öng Judea kjokyo ga pjãy tökzong dl̈up l̈ëkong; ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","pjãy l̈öng bop u dbo kjing sdok l̈i kjing go ga pjãy tökzong mal̈ing, pjãy opzrëk jek bomi u roshko l̇l̇ëbo kjrë l̇l̇ëme; ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","pjãy l̈öng bomi kjokshko ga pjãy jek bomi ushko iröng bomi shwong kop l̈ëkong l̈i kjrë l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","E dbaryo ga wal̈ëga l̈öng kjl̈araso l̇l̇ëm, e song jl̈õe. Wal̈ëga kjwozirwa tjeng nä ië, e song jl̈õ bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Rokozĩ Sbö kong ga pjãy tök kjok owa dbaryo l̇l̇ëm, woshtozl̈ong dbaryo l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","»E dbaryo ga l̇l̇ëbo wen nopga kong owa anmoyõ. L̇l̇ëbo eni, e ĩkdaba tek dämärshko dwayo l̇l̇ëm, ga wen e kjoyo ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","L̇l̇ëbo owa ëre ie Sbörë ber dbar ara l̇l̇ëm, ba nopga kjrara l̈i woyde ara kjĩshko. Eni l̇l̇ëm kjwe ga ëye där ber sök së kjl̈ara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","»Eshko dbaryo ga no tjwe shäng tjl̈ẽ ga “¡No pjl̈uyo ichara Sbörë l̈i shäng na ĩzĩa!” l̈e. Obl̈ë tjl̈ẽ ga “¡Shäng kjwe!” l̈e bomi kong, gueniyo jl̈õ l̈ëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Eshko ga nopga ara to l̈öng tjl̈ẽ ga “No pjl̈uyo ichara Sbörë shrono shäng l̈i, e tja” l̈e. “Tja Sbö tjl̈õkwo l̈aga kjok ëre so” l̈e. Gueniyo e ichaga Sbörë l̇l̇ëme. L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shärye l̈ok kësbang obl̈ë obl̈ë ara. L̇l̇ëbo jyãgl̈o shärye l̈ok obl̈ë obl̈ë bakoe. Shärye l̈ok eni, oba ara jyãpgwe wl̈o, Sbö nopga kjrara l̈i ëmdë jyãpgwe wl̈o l̈e, gueniyo epga jyãpgwe ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gueniyo miydëmi pjir wl̈o ga l̇l̇ëye wen eshko l̈i l̈oror bomi kong tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","E kjĩshko ga ëye tjl̈ẽ ga “¡No pjl̈uyo ichara Sbörë l̈i shäng kjok dogro no l̇l̇ëmshko!” l̈e bomi kongshko ga pjãy jek eshko l̇l̇ëme. Ëye tjl̈ẽ ga “¡Opjneno sök na!” l̈e bomi kongshko ga jl̈õ l̈ëmi l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","No to ter kjok dogo dwayo ëre tjwe iröng obishko ga e ber so l̇l̇gwl̈ëng l̇l̇er kãl̈ã l̇l̇etl̇l̇et kjok dogo l̇l̇aw pogo kjoyoe. Eni ga tja ĩga nopga uunkongdë wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Shinmo doyo buk kjone ga l̈ä̃ tjwe tön ara eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","»L̇l̇ëbo owa ëre dbaryo irgo ga »“Dl̈o ber pjang yẽt, ga mok kãl̈ã të ame. Dbala l̈on ter kjok dogo dwayo, ga kjopkwo ber dete erä.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","»Eshko ga ĩkoba ga no to ter kjok dogo dwayo ëre jyãgl̈o l̈i wen kjok dogo ga bangkjrëba kjok kjwang jĩkong, ga sl̈ar l̈ok ara. Eshko ga ĩkoba ga tja ter tjwe pjäng sho roy ga bor dbo kãl̈ã ĩkoba wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bor parkagaga kjok dogo so ichër wl̈i kësbang të, ga bor nopga kjrara l̈i kjre l̈ok kjok kjwang jĩkong, tö̃ya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","»Tja kuzĩa. Pjãy pin, kjor ko higuera l̈i go. Kjor kowo wen mite, korga wen tjagl̈ënshko ga miydëmi e go ga l̈ushko dbaryo äätoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eni ga l̇l̇ëbo tjeng kës ëre shäryë l̈i ĩmishko ga miydëmi e go ga no to ter kjok dogo dwayo ëre tjwe iröng obi dbaryo l̈i ääto eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","L̈ër bomi kong jl̈õkoyo ga nopga l̈öng eerishko dbaryo kjone kjone wol̈ontë l̇l̇ëm obishko ga l̇l̇ëye l̈ër shäng bomi kong ëre shäryë uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kjopkwo, kjok ëre, e pjir ber drete. Gueniyo bor tjl̈õkwora ber pjang ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","»E dbaryo l̇l̇ono, kjok orë, ëye ommiydë l̇l̇ëme. Miydaga Sbö parkagaga kjok dogo sorë l̇l̇ëm, miydaga Sbö Wa ërerë l̇l̇ëm bakoe. Miydaga Data Sbörë eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","No to ter kjok dogo dwayo ëre tjwe iröng obi döröshko ga l̇l̇ëbo shäryë kjok ëre kjing go l̈i, e ber so l̇l̇ëbo shäryono Noé dbaryoshko l̈i dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Eshko ga kjok ëre pitë l̇l̇ëm obishko ga nopga to l̈öng wl̈ẽp dl̈i uë, di ië, orkwosmok ëng tjok öötong Noé opzrëno jem kjyong kësbang roshko dbaryoshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","L̇l̇ëye tjwe shäryë eshko l̈i miydaraba l̇l̇ëme. Eshko ga shunyo shrono kësbang, ga nopga l̈i söra dirë, shtena drete. No to ter kjok dogo dwayo ëre tjweshko ga e shäryë eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Eshko dbaryo ga domerga l̈öng do pjök parkë ba kjokshko. Kjl̈ara söya, kjl̈ara ie ber shäng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ga wal̈ëga l̈öng do pjök l̇l̇ëbo kl̈äk. Kjl̈ara söya, kjl̈ara ie ber shäng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","»E kjĩshko ga pjãy l̈öng sjëk ĩyado, bomi Tjl̈apga ëre tjwe dbar l̇l̇ono miydëmi l̇l̇ëm kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tja kuzĩa. Ëye tjwe l̈ũrkë l̇l̇ono miyde u sogo l̈irë kjwe ga koshe, ba u de, l̇l̇ëbo l̈ũyotkëba l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","No to ter kjok dogo dwayo ëre tjwe l̇l̇ono miydëmi l̇l̇ëm kuzong ga pjãy ber l̈öng bor koshë, poshäryak pjir ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","»Parkaga ie ba pjl̈urë ber ba parkagaga obl̈ë daga, së̃ya äär ba dl̈oyo go kjok orë ga woyde ga parkaga l̇l̇ëye l̈e ba kong l̈i shärye eni wl̈eniyo, kjok miydë ara wl̈eniyo bakoe. ¿Gueniyo ga kjre sorë? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tjwe iröng obishko ga parkaga wl̈ẽya ba pjl̈urë shäng ba pak shäryë pjl̈ú l̈i, e kongda ber pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","L̈ër bomi kong jl̈õkoyo ga era ie ba pjl̈urë ber shäng ba l̇l̇ëbo uunkong kägäyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gueniyo ga parkaga l̈i wotjl̈ĩk owa wl̈eni ga wotjl̈ĩk ga ba pjl̈u tjwe mal̈ing l̇l̇ëme l̈e, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ga opyorgö to shäng parkagaga obl̈ë shdung, ga gl̈ö ara nel̈õga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Eni wl̈eni ga koshe shäng l̇l̇ëm dbaryoshko ga ba pjl̈u tjwe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eshko ga parkaga owa l̈i shdũya, iche nopga Sbö tjl̈õkwo söga jl̈õkoyo l̈e, gueniyo wotjl̈ĩk owa ba pjl̈úshko tjeng l̈ishko, ber shäng sl̈ar eshko, kowo uë, l̇l̇ëbo bang ara ba kong kjĩy. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","»Sbö ber no pjl̈uyo sorë, e so l̇l̇ëbo l̈ër bomi kong ëre kjoyoe. Pjl̈ara ga orkwosmozl̈ong dbaryo ga kjogl̈oga töno tjeng dogl̈o sak kjwara (10), kjogl̈o orkwosmok wl̈o l̈i yorkaga. Ba iök shjiy bapkwo söra ba tjok kjl̈ara ĩ ĩ, ga beno l̈öng domer orkwosmok wl̈o l̈i koshë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kjogl̈oga dogl̈o shkëng (5) wotjl̈ĩk l̇l̇ëm wl̈eniyo, kjogl̈oga dogl̈o shkëng (5) obi, era wotjl̈ĩk pjl̈ú wl̈eniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kjogl̈oga wotjl̈ĩk l̇l̇ëm l̈ira iök dyo söno ba tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kjogl̈oga wotjl̈ĩk pjl̈ú l̈ira iök dyo söno ba bapkwo roy, ga iök dyo söra l̈ok bapkwo obl̈ë roy bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Eshko ga domer orkwosmok wl̈o l̈i shrono mal̈ing l̇l̇ëm kuzong ga poywõ l̈ok uunkong, ga ponoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","»Kjok rong ga oba tjl̈ẽ dbo go ga “¡Domer l̈i tek shäng döröe! ¡Pjãy opshis ba wl̈okjrë!” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","»Kuya kjogl̈oga l̈irë ga kojono l̈ok uunkong, ba iök shjiy l̈i poshärye wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kjogl̈oga wotjl̈ĩk l̇l̇ëm l̈i tjl̈ẽ l̈ok l̇l̇amo l̈öng l̈i kong ga “Borwa iök sjer woydë. E kjĩshko ga tjawa së̃zĩ iök dyo sira” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","»Gueniyo kuya wotjl̈ĩk pjl̈ú l̈irë ga tjl̈ẽ l̈ok ba kong ga “L̇l̇ëme. Borwatoy kjwõr shji uunkong kong wl̈o l̇l̇ëme. Twërwa bomi kong kjwe ga borwatoy pjir bakoe. E kjĩshko ga pjãy to ba tjwl̈ẽk bomi kong om go dey” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","»Gueniyo jek l̈ok ba tjwl̈ẽk wopro ga domer l̈i shronoe. Kjogl̈oga l̈öng ĩyado ba koshë l̈i opzrëno jek orkwosmozl̈ong uyo l̈i roshko. Ga u bäng l̈i bängzaraba tuke. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","E irgo ga kjogl̈oga kjrina l̈i shrono l̈ok iröng obi ga tjl̈ẽ ga “¡Tjl̈apga, Tjl̈apga, u bäng dös borwa kong!” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","»Gueniyo kuya domer orkwosmok wl̈o l̈irë ga tjl̈ẽ ba kong ga “L̈ër bomi kong jl̈õkoyo ga pjãy ë miydër l̇l̇ëme” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","»No to ter kjok dogo dwayo ëre tjwe iröng dbar l̇l̇ono, kjok orë, e miydëmi l̇l̇ëme. E kjĩshko ga pjãy ber l̈öng sjëk ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","»Sbö ber no pjl̈uyo sorë, e so l̇l̇ëbo l̈ër bomi kong ëre kjoyoe. Pjl̈ara ga domer shäng kjl̈ara. To kjok shto obl̈ë go kjwl̈ë wl̈eni ga ba parkagaga rokara, ie ber l̈öng ba dbur dë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ba parkaga dbur dë pjl̈ú anmoyõ l̈i kong dbur sho pjl̈ubl̈ún twara kjwo sak dbäw dbäw pjl̈ogl̈o shkëng (5,000). Ba parkaga dbur dë pjl̈ú l̈i kong twara kjwo sak dbäw dbäw pjl̈ogl̈o pjok (2,000). Ba parkaga dbur dë pjl̈ú anmoyõ l̇l̇ëm l̈i kong twara kjwo sak dbäw dbäw (1,000). E irgo ga toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","»Parkaga kong dbur twara kjwo sak dbäw dbäw pjl̈ogl̈o shkëng (5,000) l̈i, l̇l̇ëbo tjwl̈ẽna dbur l̈i go, ga soynena jek obi, ga dbur shano öötong bayo eni obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Parkaga kong dbur twara kjwo sak dbäw dbäw pjl̈ogl̈o pjök (2,000) l̈i omshäryono e kjoyo bako, ga dbur shano bayo eni obi bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gueniyo parkaga kong dbur twara kjwo sak dbäw dbäw (1,000) l̈ira pjl̈ëbgwo kjono kjwara kl̈ung roshko, ga dbur l̈i jnena beno tjeng e roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","»Dbar kop ara irgo ga domer l̈i shrono shäng iröng obi ga ba parkagaga rokara, dbur l̈i l̇l̇gweya ba tjok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ba parkaga kong dbur twara kjwo sak dbäw dbäw pjl̈ogl̈o shkëng (5,000) l̈i shrono shäng ba shwoy ga tjl̈ẽ ba pjl̈uyo kong ga “Tjl̈apga, tja kong dbur sho pjl̈ubl̈ún tworop kjwo sak dbäw dbäw pjl̈ogl̈o shkëng (5,000). Tja dbur shano bayo eni obi” l̈e, ga dbur l̈i twara ba kong uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","»Kuya ga tjl̈ẽ ba kong ga “Pjl̈úe. Pja parkaga pjl̈ú wl̈eniyo, l̇l̇ëye l̈e bop kägäyorë bop kong l̈i shäryëp eni ĩyado. Pja kong l̇l̇ëbo tworor chira, ga dorop pjl̈o beke. E kjĩshko ga l̇l̇ëbo twër bop kong ara, dëp wl̈o. Pja opzrëk tek bor tjok na, pja ber sök wopjl̈ú wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","»E irgo ga ba parkaga kong dbur twara kjwo sak dbäw dbäw pjl̈ogl̈o pjök (2,000) l̈i shrono shäng ba shwoy ga tjl̈ẽ ba kong ga “Tjl̈apga, tja kong dbur sho pjl̈ubl̈ún tworop kjwo sak dbäw dbäw pjl̈ogl̈o pjök (2,000). Tja dbur shano bayo eni obi” l̈e, ga dbur l̈i twara ba kong uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","»Kuya ga tjl̈ẽ ba kong ga “Pjl̈úe. Pja parkaga pjl̈ú wl̈eniyo, l̇l̇ëye l̈e bop kägäyorë bop kong l̈i shäryëp eni ĩyado. Pja kong l̇l̇ëbo tworor chira, ga dorop pjl̈o beke. E kjĩshko ga l̇l̇ëbo twër bop kong ara, dëp wl̈o. Pja opzrëk tek bor tjok na, pja ber sök wopjl̈ú wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","»E irgo ga ba parkaga kong dbur twara kjwo sak dbäw dbäw (1,000) l̈i shrono shäng ba shwoy ga tjl̈ẽ ba kong ga “Tjl̈apga, miydër pjl̈ú ga pja kjange. Pja dwl̈a bo kjrë, dwl̈a dgorop l̇l̇ëmshko. Dwl̈a sguinop l̇l̇ëmshko ga dwl̈a bo jöp eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","E kjĩshko ga pja bangkjroror ara, ga bop dbur l̈i jnenor beno tjeng kl̈ung roshko. Tjeng ëre” l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","»Kuya ga tjl̈ẽ ba kong ga “Pja parkaga owa, shmi ara. Miydëp pjl̈ú ga tja dwl̈a bo kjrë, dwl̈a dgoror l̇l̇ëmshko. Dwl̈a sguinor l̇l̇ëmshko ga dwl̈a bo jör eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","E kjĩshko ga bor dbur ëre sörop, jnenop dbur jnezl̈ong uyo roshko dey. Eni kjwe ga tja tjwe iröng obi ga tja dbur töno e kjinmo kjwe” l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","»Eshko ga ba pjl̈uyo tjl̈ẽ oba kong ga “Dbur tjeng ba wl̈oshko kjwe dözĩ, twozĩ kjl̈ara shäng dbur shano kjwo sak dbäw dbäw pjl̈ogl̈o sak dbäw (10,000) l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ëye l̇l̇ëbo tjok ga së̃ya jek obi, ber l̇l̇ëbo ara wl̈o. Ëye l̇l̇ëye l̇l̇ëm ga l̇l̇ëye tjeng sirawa l̈i döya ba shjiryo drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Parkaga l̇l̇ëno l̇l̇ëm kjwe dbuzĩ jek kjoko, kjok ro sĩ roshko, ber shäng sl̈ar eshko, kowo uë, l̇l̇ëbo bang ara ba kong kjĩy” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","»No to ter kjok dogo dwayo ëre tjwe bor dbo kãl̈ã go, bor parkagaga kjok dogo so tjokshko ga tja sirkek wl̈ar sök bor pjl̈u sökkl̈o kãl̈ã l̇l̇etl̇l̇et l̈i kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Eshko ga tjëyoga kjrina kjrina kjok kjwang jĩkong tjwe tön uunkong bor bokshto. Öng daga, ba öng wl̈ẽp ushko so, ba shwl̈ing ushko so, e kje dboy dboy sorë ga nopga kjër dboy dboy eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","»Nopga so öng wl̈ẽp ushko so kjoyo l̈i iër ber tjeng or kël̈ëkong. Nopga so shwl̈ing ushko so kjoyo l̈i iër ber tjeng or mil̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","E irgo ga no pjl̈uyo ëre tjl̈ẽ nopga tjeng or kël̈ëkong l̈i kong ga “Pjãy kjimtara bor Datarë. Pjãy tek l̈öng kjok ëreshko. Kjok ëre poshäryak buk pjir, kjok ëre shäryara Sbörë tek l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tja pjl̈i arashko ga tja sënomi. Tja wodogroshko ga tja kong di tworomi. Tja song, tjwe shto obl̈ë so dwayoshko ga tja wl̈okjroromi bomi ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tja shwong l̇l̇ëmshko ga tja kong shwong tworomi. Tja swl̈o arashko ga tja kjimtoromi. Tja sök no shdũzl̈ong uyo roshko ga tja ĩnomi öör jong ey” l̈ër. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","»Kuya nopga pjl̈o bek l̈irë ga tjl̈ẽ l̈ok bor kong ga “Tjl̈apga, ¿pja ĩnorwa pjl̈i arashko ga pja sënorwa l̈ëp l̈i, e l̇l̇onoshko? ¿Pja wodogroshko ga pja kong di twororwa l̈ëp l̈i, e l̇l̇onoshko? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Pja song, tjwe shto obl̈ë so dwayoshko ga pja wl̈okjrororwa borwa ushko l̈ëp l̈i, e l̇l̇onoshko? ¿Pja shwong l̇l̇ëmshko ga pja kong shwong twororwa l̈ëp l̈i, e l̇l̇onoshko? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Pja swl̈o arashko, pja sök no shdũzl̈ong uyo roshko ga pja ĩnorwa öör jong l̈ëp l̈i, e l̇l̇onoshko?” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","»Eshko ga tja tjl̈ẽ ba kong ga “L̈ër bomi kong jl̈õkoyo ga shäryoromi eni bor pjeyo song wl̈eniyo kjl̈ara kong wl̈eni ga shäryoromi bor kong wl̈eni” l̈ër. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","»E irgo ga tja tjl̈ẽ nopga tjeng or mil̈ëkong l̈i kong ga “Pjãy shdungko. Pjãy opkjos bor zl̈ong dwayo. Iök jong kjwara pjë jong ri ri ĩyado. Shäryak jong Ä kong, ba pjeyoga kjok dogo so kong bakoe. Pjãy nom ber l̈öng eshko ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tja pjl̈i arashko ga tja sënomi l̇l̇ëme. Tja wodogroshko ga tja kong di tworomi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tja song, tjwe shto obl̈ë so dwayoshko ga tja wl̈okjroromi bomi ushko l̇l̇ëme. Tja shwong l̇l̇ëmshko ga tja kong shwong tworomi l̇l̇ëme. Tja swl̈o arashko, tja sök no shdũzl̈ong uyo roshko ga tja ĩnomi öör l̇l̇ëm bakoe” l̈ër. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","»Kuya l̈ok ga tjl̈ẽ l̈ok bor kong ga “Tjl̈apga, ¿pja ĩnorwa sorë l̈ëp l̈i ga pja kjimtororwa l̇l̇ëm l̇l̇onoshko?” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","»Eshko ga tja tjl̈ẽ ba kong ga “L̈ër bomi kong jl̈õkoyo ga l̇l̇ëye shäryoromi eni bor pjeyo song wl̈eniyo kjl̈ara kong l̇l̇ëm wl̈eni ga shäryoromi bor kong l̇l̇ëm wl̈eni” l̈ër. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","»E irgo ga epga jongya ber tjeng shdũya ĩyado wl̈o. Ga nopga pjl̈o bek l̈i jongya ber tjeng së ĩyado Sbö tjok wl̈o» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús tjl̈ẽno pjir ga tjl̈ẽ ba oppinggaga kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Miydëmi pjl̈ú ga Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o l̈i kjönma. Eshko dbaryo ga no to ter kjok dogo dwayo ëre twëba bor wl̈oyoga kong, tja zröya l̈ok pjang kjl̈ös go wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Eshkoshko ga syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, e töno l̈ok syõshtaga kësbangyo ko Caifás ushko, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ga tjl̈ẽ l̈ok ëng kong ga «¿Jesús, e shay, zröy wl̈o sorë ga pjl̈ú? Shay wl̈o ga jyõyotkëy. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Gueniyo dbar shrëzl̈ong dbaryo l̇l̇ëme. L̇l̇ëm ga nopga ara ga wl̈ike l̈ok äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","E irgo ga Jesús jek öötong shäng Betania kjokyo, Simón ushko. Dënashko ga Simón l̈i pogl̈o go swl̈o ara, sho an do jĩkong, gueniyo poptonoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús sök Simón ushkoshko ga wal̈ë shrono shäng ba zl̈ong bäng kjl̈ara, wl̈oshko poshtikkl̈o bapkwo tjwl̈õ ara shäryak akkwo ko alabastro go, roshko poshtikkl̈o l̈õ pjl̈ëbl̈ë tjwl̈õ ara wl̈eniyo. Eshko ga söra jek Jesús sök ië l̈ishko, ga tyara ba dl̈u kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ĩya ba oppinggagarë ga iirkë jong, ga tjl̈ẽ l̈ok ëng kong ga «¿Kjwe zãya kjweni ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Zok ga kjwe soynena dburyo ara, oba song wl̈eniyo kjimtokl̈o wl̈o dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tjl̈ẽ l̈öng l̇l̇ë l̈i miydara Jesúsdë pjir kuzong ga tjl̈ẽ ba kong ga «¿Wal̈ë kjwe l̈ãywëmi eni ega? L̇l̇ëye shäryara bor kong ëre beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Oba song wl̈eniyo l̈öng bomi tjok ĩyado, gueniyo tjara shäng bomi tjok ĩyado l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Poshtikkl̈o tyara bor doyo go ëre, e bor doyo poshäryokl̈o, tja iëba sakshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","L̈ër bomi kong jl̈õkoyo ga kjok kjwang jĩkong kjone pogo ga Sbö tjl̈õkwo roy pjl̈ú l̈ëbashko ga l̇l̇ëye shäryara wal̈ë kjwerë bor kong ëre woyoshrëba, ga roy l̈ëba bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesús oppinggaga dogl̈o sak kjwara kjingsho pjök (12) kjl̈ara ko Judas Iscariote. E öör shäng syõshtaga kägäyoga ĩk, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ga tjl̈ẽ ba kong ga «¿Jesús, e twër bomi kong ga tja potjwl̈ẽmi kjöm?» l̈e. Eni ga potjwl̈ẽna l̈ok dbur sho pjl̈ubl̈ún kjwo sak mya (30). ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Eshko jek l̈ëkong ga Judas beno shäng wotjl̈ĩk ga «¿Jesús twër ba kong sorë ga pjl̈ú?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","E irgo ga pjl̈ung shosho suk pjir shäryak ba uukkl̈o tjok l̇l̇ëm dbaryo l̈i öötonge. E dbaryo ga Jesús oppinggaga tek shrono l̈öng ba zl̈ong bäng ga tjl̈ẽ ba kong ga «¿Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o l̈i dl̈iyo shäryërwa kjone ga pjl̈ú?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","«Pjãy to Jerusalén kjokyo roshko. Domer shäng kjl̈ara eshko. Pjãy tjl̈ẽ ba kong ga “Tjl̈apga no pingga tjl̈ẽ ga ‘Tja dbaryo äätoe. Tja jek bop ushko bor oppinggaga tjok, Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo l̈i shrërwa wl̈o’ l̈e” l̈ëmi ba kong eni» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kuya l̈ok ga shäryara l̈ok eni, ga dbar shrëkkl̈o l̈i dl̈iyo poshäryara l̈ok pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Öötong kjok shkë ga Jesús sök ië, ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","L̈öng ië wopro ga Jesús tjl̈ẽ ba kong ga «L̈ër bomi kong jl̈õkoyo ga pjãy kjl̈ara, tja soyneya, twe oba kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kuya l̈ok ga beno l̈öng woydë arae. Ga kjl̈ara kjl̈ara tjl̈ẽ Jesús kong ga «Tjl̈apga, ¿tja l̇l̇ëm l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kuya ga tjl̈ẽ ba kong ga «Ëye sök bor tjok, ba pjl̈ung shosho suk pjir l̈i pöya sök bor tjok iokl̈o kjwaraso roy ga bor soynega l̈i e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","No to ter kjok dogo dwayo ëre wol̈on, tak pjang Sbö tjl̈õkwo go sorë l̈i eni. Gueniyo bor soynega, era song jl̈õe. Weno l̇l̇ëm kjwe ga pjl̈ú ba kong dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eni ga Judas, ba soynega l̈i tjl̈ẽ ba kong ga «No pingga, ¿tja l̇l̇ëm l̇l̇ëmdo?» «L̈ëp sök om go l̈iro» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","L̈öng ië wopro ga pjl̈ung shosho suk pjir kjrara Jesúsdë kjwara, ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga pjl̈ung shosho suk pjir l̈i tora, twara sira sira ba oppinggaga kong, ga tjl̈ẽ ba kong l̈ok ga «Kjrozĩ, uozĩ, ëre bor sho wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","E irgo ga di iokl̈o kjrara kjwara, roy kjil̇l̇gwo bo dyo dbo ara, ga tjl̈ẽ Sbö kong ga «Tjawa kong kjil̇l̇gwo bo dyo tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga twara ba oppinggaga kjl̈ara kjl̈ara kong, ga tjl̈ẽ ba kong l̈ok ga «Iozĩ pjãy uunkongdë sira sira. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ëre bor srëng wl̈eni. E go ga tjl̈õkwo twara Sbörë, beno ĩyado wl̈o l̈i, e shärye. Bor srëng l̈i kwon, nopga ara kong. E go ga owa pjang ba go l̈i l̈ö̃ya Sbörë ber drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gueniyo l̈ër bomi kong ga kjil̇l̇gwo bo dyo iër ame, äär jong bor Data ber sök no pjl̈uyo dbaryoshko jã. Eshko ga iër bomi tjok jek obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","E irgo ga tono l̈ok pjl̈ara Sbö kong, ga to jem l̈ok Olivos dl̈upyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Öötong l̈öng eshko ga Jesús tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: »“Öng daga l̈i zrör, ga öng wl̈ẽp ushko so tjeng l̈i shdär ber kjl̈oro erä.” Eni ga eeri shkëyo ga pjãy tjeng uunkong ëre, tja rayëmi pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gueniyo ga tja wol̈ono, ga tja woshrara Sbörë iröng obishko ga tja äär Galilea kjokyo bomi bäm go. Pjãy koshër shäng eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kuya Pedrorë ga tjl̈ẽ ba kong ga «L̇l̇amora, pja rayara uunkong pjir ëmdë ga tjara, pja rayër l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kuya ga tjl̈ẽ ba kong ga «L̈ër bop kong jl̈õkoyo ga pjesit kjok shränto ga kjörkö kjl̈untë l̇l̇ëm obishko ga “Jesús, e ë miydër l̇l̇ëme” l̈orop oba kong pjl̈ogl̈o mya tjän» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Gueniyo kuya ga tjl̈ẽ ba kong obi ga «Eni l̇l̇ëme. Tja zrökoba jek bop tjok ëmdë ga “Jesús, e ë miydër l̇l̇ëme” l̈ër ë kong l̇l̇ëme» l̈e. Ba oppinggaga l̇l̇amo l̈i oml̈ono e kjoyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","E irgo ga Jesús jek öötong shäng Getsemaní kjokyo ba oppinggaga tjok. Eshko ga tjl̈ẽ ba kong l̈ok ga «Tja to syõshtë Sbö kong këm ëre wl̈e wopro ga pjãy wl̈ar ber tjeng na» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Eni ga jek syõshtë l̈ishko ga ba oppinggaga tjeng l̈i söra jek ba tjok dogl̈o mya, Pedro, Santiago, Juan. Jek l̈öngshko ga Jesús wosong, woydë ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ga tjl̈ẽ ba kong l̈ok ga «Tja woydë ara bor pjl̈úshko. Kur ga tja wol̈on kjoyoe. Pjãy ber tjeng na, ga pjãy sjëke» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eni ga opkwono jek këgo sit, ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, ga syõshtono Sbö kong, tjl̈ẽ ga «Data, rokër bop kong sira ga l̇l̇ëbo wen bor kong owa dörö l̈i, e wen tjwe bor kong l̇l̇ëm kjwe dey. Shäryë eni ga pjl̈ú kjwe ga woydër eni. Gueniyo ga e l̈aga tjarë l̇l̇ëme. E l̈aga ber pjarë. Woydër ga l̇l̇ëbo shäryë, woydëp sorë l̈i eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","E irgo ga tek shrono shäng ba oppinggaga dogl̈o mya beno tjeng l̈ishko ga wl̈ẽna bë tjeng pëe. Eni ga tjl̈ẽ Pedro kong ga «¿Pjãy l̈öng së wop sira ga äre? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pjãy pë l̇l̇ëme. Pjãy sjëke. Pjãy syõshtozong. Eni ga pjãy tjl̈ĩya Ärëshko ga pjãy kjimte Sbörë, l̇l̇ëbo owa shäryëmi l̇l̇ëm wl̈o. Pjãy l̇l̇ëbo pjl̈ú shäryë woydë jl̈õ, gueniyo pjãy womae» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","E irgo ga jek syõshtë obi. Tjl̈ẽ ga «Data, l̇l̇ëbo wen tjwe bor kong owa l̈i kjëp ga ä wl̈eni ga l̈aga ber pjarë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E irgo ga tek shrono shäng iröng obi ba oppinggaga beno tjeng l̈ishko ga wl̈ẽna bë tjeng pë obi, bokkwo l̇l̇ir woydë ëng go poywõrë kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Eni ga jek syõshtë pjl̈ara obi, öötong pjl̈ogl̈o mya. Eshko ga tjl̈ẽno jek obi, l̈ara bäm go sorë ga eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Syõshtono pjir ga tek shrono shäng iröng obi ba oppinggaga beno tjeng l̈ishko ga tjl̈ẽ ba kong ga «¿Pjãy l̈öng pë, woshtë obire? No to ter kjok dogo dwayo ëre twëba ber tjeng nopga owa wl̈oshko l̈i dbaryo öötonge. Ĩzĩa. Bor soynega tek shäng dörö tjän. Pjãy kojõzong. Shji to ëng dowl̈ẽk ba tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús tjl̈ẽydë pjitë l̇l̇ëm obishko ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) kjl̈ara ko Judas, e shrono shäng eshko. Nopga shrono l̈öng träk l̇l̇ëm ba tjok, kjone kjone wl̈oshko dröng, kjone kjone wl̈oshko wl̈ëng no shpokkl̈o. Epga ichaga syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyorë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","L̈unashko ga l̇l̇gwera Judasdë nopga l̈i kong pjir tjän, Jesús, e ë miyde l̈ok wl̈o. Tjl̈ẽno ba kong ga «Ĩmi ga ëye l̈õ shir ga domer l̈i e. E shamirë» l̈ara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eni ga Judas jek öötong shäng Jesús zl̈ong bäng ga tjl̈ẽ ba kong ga «¡Miga, Tjl̈apga no pingga!» l̈e ba kong, ga l̈õ shira. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kuya ga tjl̈ẽ ba kong ga «Kjobe. Pja bor kjl̈ara. L̇l̇ëye shäryëp wl̈o l̈i shäryozong» l̈e. Eni ga nopga l̈i tek shrono l̈öng Jesús zl̈ong bäng ga shakza l̈ok pjä erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eshko ga nopga l̈öng Jesús tjok eshko l̈i kjl̈ara dröng shino kjwangna, ga syõshtaga kësbangyo parkaga kwomgwo zakza tas jer l̈on pjik buk töshko erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Eni ga Jesús tjl̈ẽ ba kong ga «Bop dröng kjwe jnes ba shtoy iröng obi. Ëye ëngkjwë dröng go ga zrökoba dröng go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Eni tjok ga rokër bor Data kong kjwe ga tja kong ba parkagaga kjok dogo so iche träk l̇l̇ëm ga pjl̈ú, kjringgwo sak kjwara kjingsho pjök (12) wl̈eni. ¿E miydëp l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gueniyo l̇l̇ëye wen bor kong l̈i, e tak pjang Sbö tjl̈õkwo go tjän. Rokër bor Data kong eni kjwe ga l̇l̇ëye tak pjang l̈i shäryë eni l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ga Jesús tjl̈ẽ nopga l̈i kong ga «¿Pjãy tjwe bor shak dröng tjok, wl̈ëng no shpokkl̈o tjok kjweni ega? ¿Tja shamishko ga tja ëngkjwë bomi tjok l̈ëmiro? Tja öör shäng oba ping ara, Sbö u zl̈ong bäng. ¿Tja sharomi eshko l̇l̇ëm egaro? ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gueniyo ëre shäryë jũni, tjl̈õkwo tara Sbö tjl̈õkwo l̈agaga tek dënashko sorë l̈i ber jl̈õkoyo wl̈o» l̈e. Eshko ga ba oppinggaga Jesús rayono uunkong, ga töktong to l̈ok ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","58","E irgo ga Jesús söra l̈ok to jongya syõshtaga kësbangyo ko Caifás ushko. Pedro jek shäng kä kjwaraso kä kjwaraso ba irgo. Öötong l̈öng eshko ga opzrëno jek u l̈i roshko, ga Pedro beno sök u bongkjako, Sbö u dagaga l̈öng l̈i tjok, l̇l̇ëye shäryëba pjir ber sorë ĩya wl̈o. No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, e töno l̈öng u l̈i roshko tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Syõshtaga kägäyoga, Judío Kjok L̇l̇gwegaga Këskësyo uunkong, Jesús zröya l̈ok woydë. E kjĩshko ga nopga rokara ara töno tjeng l̈ishko, Jesús jyõyotkë wl̈o, rote l̈ok e go wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jyõyotkara l̈ok ara, gueniyo l̇l̇ëye to wl̈ẽna l̇l̇ëme. E irgo ga nopga kojono obl̈ë do pjök, Jesús rotë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tjl̈ẽ l̈ok ga «Domer ëre tjl̈ẽno ga “Sbö u ëre shdör dret, ga äär dbargwo mya ga shäryër ber ba shtoshko iröng obi” l̈ara eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Eni ga syõshtaga kësbangyo l̈i kojono, ga tjl̈ẽ Jesús kong ga «Pja rote l̈öng ara. ¿Dboryëp l̇l̇ëmde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kuya ga beno shäng kjinge. Eni ga syõshtaga kësbangyo l̈i tjl̈ẽ ba kong ga «¿No pjl̈uyo ichara Sbörë shrono shäng l̈i, Sbö Wa l̈ëba l̈i, e pjare? L̈os borwa kong jl̈õkoyo, Sbö Sök Ĩyado l̈i ko go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kuya ga tjl̈ẽ ga «L̈ëp shäng pjarë om go eni. Gueniyo l̈ër bomi kong ga Sbö, l̇l̇ëye shärye woydë l̈i shärye ga pjl̈úe. Ga l̇l̇ono ga no to ter kjok dogo dwayo ëre ĩmi sök ba orkwo kël̈ëkong, tja ĩmi ter tjwe kjok dogo pjäng sho tjrëko bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kuya syõshtaga kësbangyo l̈irë ga ba shwong dwl̈ëkza tjã tjã iirdë. Tjl̈ẽ ga «¡Domer kjwe shäng Sbö l̈ãywë owa, ber tjwl̈õ l̇l̇ëm wl̈o l̈e! ¿Ëye wl̈ẽy ba rotë obi l̇l̇ëno? L̇l̇ëye l̈ara l̈i kuromi pjir tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Kumi ga sorë?» l̈e. Kuya nopga töno tjeng uunkong l̈irë ga tjl̈ẽ ga «¡Kjwe zrökko!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Eshko ga Jesús yora l̈ok. Bokso go tröng twara l̈ok bakoe. Kjone kjone omkwomso shpono, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ga tjl̈ẽ ba kong ga «Pja no pjl̈uyo ichara Sbörë shrono shäng l̈i jl̈õkoyo wl̈eni ga pja shpoga ërë l̈os borwa kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","E wopro ga Pedro sök kjoko, u bongkjako. Eshko ga kjogl̈o shäng kjl̈ara, syõshtaga kësbangyo parkaga wl̈eniyo. Tek shrono shäng Pedro zl̈ong bäng ga tjl̈ẽ ba kong ga «Nopga jëk l̈öng Jesús, Galilea so l̈i tjok, e kjl̈arayo pja» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kuya ga tjl̈ẽ ga «¡Jyõ! L̇l̇ëye l̈ëp shäng l̈i miydër l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","E irgo ga jek öötong shäng kjër pjl̈or kal̈ëkong, u bäng jong l̈ishko. Eshko ga kjogl̈o obl̈ë omĩno, ga tjl̈ẽ nopga l̈öng l̈i kong ga «Kjwe jëk shäng Jesús, Nazaret so l̈i tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kuya Pedrorë ga tjl̈ẽ nopga l̈i kong ga «¡Jyõ! L̈ër bomi kong jl̈õkoyo ga domer, e ë miydër l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","E irgo ga nopga l̈öng eshko l̈i tek shrono l̈öng ba zl̈ong bäng ga tjl̈ẽ ba kong ga «Miydërwa pjl̈ú ga pja ba kjl̈arayo. Pja ba pjeyo jl̈õe, bop tjl̈ẽ wl̈e go ga wẽl̈ëe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kuya ga tjl̈ẽ ba kong ga «¡Jyõ! L̈ër bomi kong jl̈õkoyo ga domer, e ë miydër l̇l̇ëme. Eni l̇l̇ëm ga rokër Sbö kong ga tja shdũya» l̈e. Jekdo eshko ga kjörkö kjl̈unoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Eshko ga woyoshre kjl̈ay ga Jesús tjl̈ẽno ba kong ga «Kjörkö kjl̈untë l̇l̇ëm obishko ga “Jesús, e ë miydër l̇l̇ëme” l̈orop oba kong pjl̈ogl̈o mya tjän» l̈ara. Eni ga opshino ey dwayo, ga sl̈atong jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wẽshko kjok shröng ga syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, Jesús zröya l̈ok sorë l̈i, e l̇l̇gwera l̈ok pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","E irgo ga Jesús orkwo pjrira, ga söra l̈ok jek, ga twara Pilato kong. Pilato, e kjok eshko so ichaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesús roy kura Judas, ba soynega l̈irë, ga miydara ga Jesús, e zrökko. Eshko ga bangyo ba kong ara, ga dbur sho pjl̈ubl̈ún kjwo sak mya (30) ba potjwl̈ẽkkl̈o l̈i twara iröng syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo kong, ga tjl̈ẽ ba kong l̈ok ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«L̇l̇ëbo owa shäryoror. Domer pjl̈o bek tworor bomi kong, zrömi wl̈o» l̈e. Gueniyo kuya l̈ok ga tjl̈ẽ ba kong ga «E borwa kong ga l̇l̇ëye drete. E miydaga ber pjarë om go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Eni ga dbur sho l̈i dbukza Judasdë shl̈äw, beno tjeng Sbö u dburyo jnezl̈ong uyo l̈i roshko, ga to jek ey dwayo, ga opskunoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dbur sho l̈i töna syõshtaga kägäyogarë, ga tjl̈ẽ ëng kong ga «Dbur sho ëre, e domer potjwl̈ẽkkl̈o, zrökoba wl̈o. E kjĩshko ga iëy ber jong Sbö u l̈i dburyo jnezl̈ong ga äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eni ga l̈anyotkara l̈ok pjir ga kjok tjwl̈ẽna kjrina ko Kl̈ung Sbiyo Shäryaga kjokyo, ber buk sakshko, oba shto obl̈ë so kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","E kjĩshko ga kjok eshko kowaraba beno srëng kjokyo, ga eerishko ga kowëba jong eni obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Eni ga tjl̈õkwo l̈ara Sbö tjl̈õkwo l̈aga tek dënashko so Jeremíasdë l̈i beno jl̈õkoyo. Tjl̈ẽno beno eni: «Dbur sho pjl̈ubl̈ún kjwo sak mya (30) l̈i kjrara l̈ok, e tjwl̈õ iara Israel tjëyogarë beno eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ga Kl̈ung Sbiyo Shäryaga kjokyo l̈i tjwl̈ẽna l̈ok dbur l̈i go, tja ichara Tjl̈apgarë sorë l̈i eni.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús söra l̈ok öötong shäng kjok eshko so ichaga Pilato bokshtoshko ga Pilato tjl̈ẽ ba kong ga «¿Judío pjl̈uyo l̈i pjare?» «L̈ëp sök om go l̈iro» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eshko ga Jesús rote syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyorë l̈öng ara. Gueniyo dboryara Jesúsdë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Eni ga Pilato tjl̈ẽ ba kong ga «¿Pja rote l̈öng ara l̈i kugöp l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Gueniyo dboryara kjak kjwara l̇l̇ëme. E kjĩshko ga woyotjl̈ĩya Pilatorë arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Äär l̈u pjl̈obi go ga Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈oshko ga nopga bängzak tjeng no shdũzl̈ong uyo roshko l̈i, enido ga raye Pilatorë kjl̈ara. Woyde nopgarë kjone dey ga e rayayde. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Eshko ga no bängzak shäng kjl̈ara ko Barrabás, roy kësbange. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Eni ga nopga shrono l̈öng arashko ga Pilato tjl̈ẽ ba kong l̈ok ga «¿Woydëmi ga ëye dör, Barrabásde, de Jesús, e kowëba no pjl̈uyo ichara Sbörë shrono shäng l̈i?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Miydara pjl̈ú ga Jesús woydëba ara kjĩshko ga ymoyotke ba wl̈oyogarë ara, ga söra l̈ok ba kong e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato sök no l̇l̇gwezl̈ong shtoyo wopro ga ba boy tjl̈õkwo ichono ba kong. Tjl̈ẽ ga «Domer l̇l̇gwep sök l̈i, e pjl̈o beke. Kjupke shkëyo ga e yoyoĩnor owa anmoyõ. ¡E kjĩshko ga wẽyẽ, barwëy l̇l̇ëme!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gueniyo ga nopga tjeng ara eshko l̈i poshduna syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyorë arae. Tjl̈ẽ ga «Rokozĩ ba kong ga Barrabás, e döyde bi kong dey l̈ozĩ eni. Rokozĩ obi ga Jesúsda zrökko l̈ozĩ eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Eshko ga Pilato tjl̈ẽ nopga l̈öng l̈i kong ga «¿Nopga do pjök ëre dör bomi kong kjone dey?» «¡Barrabás, e döpdë!» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kuya ga tjl̈ẽ ba kong ga «¿Eni ga l̇l̇ëye woydëmi ga shäryër Jesús, no pjl̈uyo ichara Sbörë shrono shäng l̈ëba l̈i kong?» «¡Zrös pjang kjl̈ös go!» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kuya ga tjl̈ẽ ba kong ga «¿L̇l̇ë kjĩy? L̇l̇ëbo owa shäryara l̈i l̈ozĩ bor kong» l̈e. Gueniyo nopga tjl̈ẽ jek obi ga «¡Zrös pjang kjl̈ös go!» l̈e eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Eni ga ĩya Pilatorë ga nopga l̈i tjl̈õkwo jong kjwaraso, nopga shdöktong ëngkjwë woydë wl̈eni, l̇l̇ëye l̈e ba kong, kjl̈opswë ber wotjl̈ĩk obl̈ë wl̈o ga äe. E kjĩshko ga di rokara sira, ga orkwo shkwono nopga l̈i bokshto. Tjl̈ẽ ga «Kjwe ichër zrökoba wl̈o, gueniyo miydaga ber tjarë l̇l̇ëme. Miydaga ber pjãydë om go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kuya nopga l̈irë ga tjl̈ẽ ba kong ga «Wol̈ono ga miydaga ber tjawarë, borwa wapgarë bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eni ga Barrabás, e shira, ga rayarae. E irgo ga Jesúsda twara ba ëngkjwagaga kong, shpoya l̈ok no shpokkl̈o go wl̈o, zröya l̈ok pjang kjl̈ös go wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Eni ga söra l̈ok, öötong shäng Pilato u bongkjako. Shto eshko, e kowëba pretorio. Ga ëngkjwagaga töno tjeng uunkong eshko, ba zl̈ong bäng pjribrie. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Eshko ga Jesús shwong skwara l̈ok, ãska wl̈ẽna l̈ok kara pjl̈upga shwong wl̈eniyo ko dingding shwëshwë, ga pjuna l̈ok ba do go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ga shkö sho ywara l̈ok kjwara, beno pjl̈u dl̈u iokl̈o wl̈eni, ga iara l̈ok pjang ba dl̈u go, ga kong kjë twara kjwangna, ba orkwo kël̈ëkong. Eshko ga tjl̈ẽ l̈ok ba kong dbo go ga «¡Judío pjl̈uyo, pja pjl̈ú, pja tjwl̈õ arae!» l̈e l̈ok eni, ba joywokl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eshko ga go tröng twara, shpokza l̈ok tjã tjã kjë l̈i go ara ba käshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Joywara l̈ok pjir ga ba shwong pjang ba do go l̈i skwara l̈ok, ga ba shwong baĩya l̈i pjuna l̈ok jek iröng obi. E irgo ga söra l̈ok to, zröya l̈ok pjang kjl̈ös go wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jek l̈öng kjwl̈ë irbo bäng go ga domer wl̈ẽna l̈ok kjl̈ara ko Simón, e Cirene so, ga ichara l̈ok dbo go Jesús kjl̈ös l̈i sök. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","E irgo ga jem öötong l̈öng kjokyo ko Gólgota. (E «No Kä Dbogl̈o dl̈upyo» l̈okl̈o.) ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Eshko ga kjil̇l̇gwo bo dyo dbo ara ropsrära l̈ok l̇l̇ëbo këä wl̈eniyo tjok, ga twara l̈ok Jesús kong, ie wl̈o. Tjl̈ĩna sira, gueniyo iara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Eshko ga l̈öra l̈ok pjang kjl̈ös go irgo ga ëngkjwagaga tjeng l̈i tjöto l̈ok l̇l̇ëbo jyãgl̈o go, Jesús shwong l̈i ber ë kong ĩya l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","E irgo ga sirkeno l̈öng eshko ba dë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesús l̈ök pjangshko l̈i kopshko, kjibokwo iak pjang kjwara, e zröya l̈ok l̇l̇ë kjĩy miydëba wl̈o. Kjibokwo tak pjang l̈i tjl̈ẽ ga «Domer ëre ko Jesús. E judío pjl̈uyo.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesús l̈öra pjangshko ga nopga l̈ũ ä wl̈eniyo l̈öra l̈ok do pjök kjl̈ös go bakoe. Kjl̈ara pjang or kël̈ë, kjl̈ara pjang or mil̈ë, kjl̈ösyo dboy dboye. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Eshko ga nopga jek l̈öng Jesús l̈ök pjangshko l̈i kä wikza tjã tjã, joywe l̈ok wl̈o. Ga l̈ãywe l̈öng owa bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tjl̈ẽ ga «Pja Sbö u shdök ber dret, ga äär dbargwo mya ga shäryëp ber ba shtoshko iröng obi l̈orop eni. Pja Sbö Wa jl̈õkoyo ga pja opdös om go, pja ter opl̈õs töshko kjl̈ös kjwe go dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jesús joywe syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyorë eni bakoe. Tjl̈ẽ l̈ok ëng kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Oba obl̈ëra döra, gueniyo opdök om go ga äe. Kjwe Israel tjëyo pjl̈uyo l̈e. Woyde ga opl̈ong töshko kjl̈ös kjwe go dwayo. Enira tjawa mär ba go kjwe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Tja mär Sbö go” l̈ara. Enira woyde Sbörë ga döya. “Tja Sbö Wa” l̈ara bi kong om go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nopga do pjök l̈ũ ä wl̈eniyo l̈ök l̈ok kjl̈ös go Jesús pjl̈or kar kar ëmdë ga oml̈ãywë l̈öng eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Öötong dl̈o dl̈uw bek ga kjok ro zoktong kjok kjwang jĩkong beno yẽt erä. Beno eni äär jong dl̈o pjö l̈ë wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dl̈o öötong eni ga Jesús tjl̈ẽno dbo go, tjl̈ẽ ga «Elí, Elí, ¿lama sabactani?» l̈e. (E «Bor Sbö, bor Sbö, ¿tja rayorop jũni ega?» l̈okl̈o.) ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kuya nopga tjeng eshko l̈irë ga tjl̈ẽ ëng kong ga «Sbö tjl̈õkwo l̈aga tek dënashko so Elías, e rokayde pjang» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eshko ga domer shäng kjl̈ara jek tji tji, ga l̇l̇ëbo l̇l̇ukl̇l̇uk di shak ara wl̈eniyo kjrara kjwara, pöra kjil̇l̇gwo bo dyo shpoä go, kjrochara kjor dbo go, ga poyona jem, shuya Jesúsdë wl̈o l̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Eshko ga l̇l̇amo l̈öng l̈i tjl̈ẽ ba kong ga «Wẽyẽ. Elías tjwe ba dökde ĩy» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","E irgo ga ay l̈e Jesúsdë dbo go obi, ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Eshko ga Sbö u roshko ga shwong kësbang iak pjang eshko l̈i dwl̈ëtong aas ter kjomo dwayo äär jong töshko, beno kjring pjök. Kl̈ung iano jek shkik shkik, guëng woktong aas, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ga sak roshwino ara. Eshko ga Sbö nopga kjone kjone wol̈ono tjeng l̈i, e woshrara Sbörë iröng obi, beno l̈öng së, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ga opshino ba sak roy dwayo. Ga Jesús woshrara Sbörë iröng obi irgo ga epga jek öötong opzrëno l̈öng kjok zrek ko Jerusalén l̈i roshko. Eshko ga ĩkoba l̈öng arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesús l̈ök pjang kjl̈ös go l̈i bokshto ga ëngkjwagaga l̈öng kjl̈öbö ba dë, ba kägäyo shäng ba tjok. Yo l̈i kura l̈ok, ga l̇l̇ëbo shäryono l̈i ĩna l̈ok uunkong. Eni ga bangkjrara l̈ok tira l̇l̇ëm, ga tjl̈ẽ l̈ok ëng kong ga «Shinmo l̈ök pjang kjl̈ös go kjwe, e Sbö Wa jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Eshko ga wal̈ëga tjeng kjl̈öbö, tek tjeng Galilea kjokyo dwayo Jesús tjok, ba kjimtë wl̈o. Eshko ga l̇l̇ëye shäryëba Jesús kong l̈i ĩya tjeng pjola sit. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","E tjrëko tjeng dogl̈o mya, kjl̈ara ko María Magdala so, kjl̈ara, e Zebedeo boy, kjl̈ara ko María. María, e Santiago, José mekë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Domer dbur ara wl̈eniyo shäng kjl̈ara ko José, e Arimatea so. E oppino ara Jesús tjok. Kjok sëng ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","jek öötong shäng Pilato shwoy ga Jesús doyo rokara ba kong, jneya wl̈o. Eni ga ba nopga ichara Pilatorë, Jesús doyo twë ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Eni ga kjrara Josérë, popgara shwong ko pjl̈ubl̈ún, pjl̈ú wl̈eniyo go, ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ga söra jek öötong sak baĩyashko. Eshko ga pjl̈ëbgwo jong kjwara guëmkwota roshko, kara Josérë om go. Shinmo iaydëba eshko l̇l̇ëm obi. Eshko ga doyo l̈i iara beno buk ba roshko, ga bängzara ak kësbang wl̈eniyo go, ga toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdala so, María obl̈ë l̈i, e sirkeno beno l̈öng sak l̈i bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wẽshko, woshtozl̈ong dbaryo ga syõshtaga kägäyoga, fariseoga, e jek l̈ok Pilato shwoy. Öötong l̈öng ba shwoy ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tjl̈ẽ l̈ok ba kong ga «Tjl̈apga, woyoshrërwa ga jyõgwang l̈i shäng së obishko ga tjl̈ẽno ga “Äär dbargwo mya ga tja woshre Sbörë iröng obi” l̈ara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","E kjĩshko ga rokërwa bop kong sira ga nopga ichëp ba doyo buk sakshko l̈i dë, äär jong dbargwo mya. Eni l̇l̇ëm ga ba oppinggaga tjwe ba l̈ũyotkë kjwe. Eni kjwe ga tjl̈ẽ l̈ok oba kong ga “E woshrara Sbörë iröng obi” l̈e kjwe. Eni ga jyõ ëre ber owa anmoyõ, jyõ l̈ara bäm go l̈i kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kuya ga tjl̈ẽ ba kong ga «Jöl̈ö. Ëngkjwagaga sözĩ kjl̈öbö, doyo buk kjone l̈i dëmi yõtso wl̈o, miydëmi sorë l̈i eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eni ga jek öötong l̈öng sak l̈ishko ga jyã iara l̈ok beno pjang ak jong ba bängzakkl̈o l̈i go, dökoba l̇l̇ëm wl̈o, ga ëngkjwagaga l̈i iara beno l̈öng ba dë eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Woshtozl̈ong dbaryo l̈i pjitonge. Wẽshko kjok shröng, sondëshko ga wal̈ëga do pjök ko María Magdala so, María obl̈ë l̈i, e jek l̈ok jongya sak l̈i ĩk. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Eshko ga Sbö parkaga kjok dogo so ter shrono shäng eshko kjl̈ara. E kjĩshko ga yo ian pjang kjok eshko dbo träk l̇l̇ëme. Ga Sbö parkaga l̈i jek öötong shäng sakshko ga ak iak beno jong ba bängzakkl̈o l̈i dira, kjara beno jong ba sor go, ga sirkeno sök ba kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sbö parkaga l̈i kãl̈ã ara so l̇l̇gwl̈ëng kjoyo, shwong ko pjl̈ubl̈ún so pjäng sho kjoyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ĩya ëngkjwagaga l̈öng l̈irë ga sëya l̇l̇ëm, kjl̈o dete erä, ga dgono jek rish rish tjeng töshko, beno wol̈ono l̈öng wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eshko ga Sbö parkaga l̈i tjl̈ẽ wal̈ëga l̈i kong ga «L̇l̇ëye bangkjrëmi l̇l̇ëme. Miydër ga pjãy tek l̈öng ëre Jesús, zröraba pjang kjl̈ös go l̈i doyo wl̈ẽga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Gueniyo ga e buk na l̇l̇ëme. E woshrono iröng obi, l̈ara om go sorë l̈i eni. Pjãy tek iak beno buk l̈i shtoyo ĩmia. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ĩnomi ga pjãy nom mal̈ing ba oppinggaga l̈öng l̈i shwoy, ga pjãy tjl̈ẽ ba kong ga “Jesús, e woshrara Sbörë iröng obi. E jek Galilea kjokyo bomi bäm go. Ĩmi eshko” l̈ëmi ba kong eni. L̇l̇ëye l̈ër bomi kong wl̈o l̈i e» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eshko ga kjok bangkjre l̈ok ara, gueniyo l̈öng wopjl̈ú bakoe. Eni ga jek zron jong jongya Jesús oppinggaga l̈öng l̈ishko, roy söya l̈ok ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Eshko ga Jesús ëng wl̈ẽno ba tjok ga tjl̈ẽ ba kong ga «Miga» l̈e. Ĩya l̈ok ga tek ba zl̈ong bäng, ga dre popjl̈ura l̈ok, poshrëya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Eni ga Jesús tjl̈ẽ ba kong ga «L̇l̇ëye bangkjrëmi l̇l̇ëme. Pjãy nom tjl̈ẽ bor pjeyoga kong ga “Pjãy nom Galilea kjokyo. Jesús ĩmi eshko” l̈ëmi ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","E wopro ga ëngkjwagaga Jesús doyo daga l̈i kjone kjone jek öötong l̈öng Jerusalén kjokyo roshko, syõshtaga kägäyoga ĩk. Öötong l̈öng eshko ga l̇l̇ëye shäryono kës l̈i l̈ara l̈ok ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kuya l̈ok ga to l̈an judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo tjok, l̇l̇ëye shärye wl̈o l̈i woyotjl̈ĩya jong kjrinaso wl̈o. E irgo ga dbur twara l̈ok ëngkjwagaga l̈i kong arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ga tjl̈ẽ l̈ok ba kong ga «L̇l̇ëye ĩnomi l̈i roy l̈ëy ë kong l̇l̇ëme. Pjãy to l̈öng tjl̈ẽ oba kong ga “Shkëshko ga tjawa l̈öng pë wopro ga ba oppinggaga tek shrono l̈öng eshko, shinmo doyo buk l̈i l̈ũyotkara, ga söra toe” l̈ëmi oba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Roy kuya nopga kjok ëre so ichagaga l̈irë ga tjawa l̈an ba tjok yõtso eshko. Pjãy woydë l̇l̇ë kjĩy l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kuya ëngkjwagaga l̈irë ga dbur l̈i kjrara, ga l̇l̇ëbo shäryara, l̈ara l̈ok ba kong sorë l̈i eni. E kjĩshko ga dbar eerishko ga judíoga omroy l̈ë l̈öng eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","E irgo ga Jesús oppinggaga dogl̈o sak kjwara kjingsho kjl̈ara (11) l̈i to öötong l̈öng Galilea kjokyo, dl̈up jong l̈ara Jesúsdë ba kong l̈i go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Eshko ga Jesús ĩna l̈ok, ga poshrëra. Gueniyo kjone kjone wotjl̈ĩk ga e Jesús l̇l̇ëm dikjoyoe l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Eshko ga Jesús tek ba zl̈ong bäng ga tjl̈ẽ ba kong ga «Tja kong dbo twara Sbörë, tja ber sök kjok dogo sopga, kjok ëre sopga l̈öng kës l̈i, e ichaga wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Eni ga pjãy jongya jong kjok kjwang jĩkong, tja roy l̈ëmi tjëyoga uunkong kong, epga ber l̈öng bor oppingga wl̈o. Ga Data Sbö ko go, Sbö Wa ëre ko go, Sbö Sëya ko go ga epga wëmia. ");
INSERT INTO tfrNTpo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ga l̇l̇ëye l̈oror bomi kong, shäryëmi wl̈o l̈i pimi ba kong pjir, shärye l̈ok eni bako wl̈o. Ga tja ber shäng bomi tjok ĩyado, äär jong kjok pjir dbaryo l̈ishko» l̈e.");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo, e Sbö Wa. E roy pjl̈ú l̈i soyozl̈ong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kjibokwo tara Sbö tjl̈õkwo l̈aga tek dënashko so Isaíasdë. Tjl̈ẽno beno eni: «Sbö tjl̈ẽno ba Wa kong ga “No ichër kjl̈ara bop bäm go, bop roy l̈aga, irbo poshäryë bop kong wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kjok dogro no l̇l̇ëmshko ga ëbo tjl̈ẽ shäng dbo go ga “Irbo poshäryozĩ Tjl̈apga tjwe l̈i kong. Shäryozĩ ber beke” l̈e.» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Eni ga no weno shäng kjl̈ara ko Juan. E doyono shäng shwong sek öng jëkkl̈o sok kësbang zok go, dop pjrikkl̈o shäryak öng kwota go bakoe. Dl̈i ba kong ue wl̈o l̈i, e sekwa, or kjl̈oshko so dyo bakoe. E öötong shäng kjok dogro no l̇l̇ëmshko ga shäng oba wë jer di roshko ga tjl̈ẽ oba kong ga «L̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈ozĩ, ga rayozĩ, ga pjãy wër jer di roshko. Shäryoromi eni ga owa pjang bomi go l̈i l̈ö̃ya Sbörë ber drete» l̈e. Judea sopga, Jerusalén sopga, e shrono l̈öng träk l̇l̇ëm ba kuk. Eshko ga kjone kjone, l̇l̇ëbo owa shäryara l̈i l̈e oba uunkong bokshto. E irgo ga we Juandë jer Jordán diyo roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ga Juan tjl̈ẽ oba kong ga «No tjwe bor irgo kjl̈ara. Bek wl̈o ga tja ba drepkwota dök wl̈o l̇l̇ëm, e tjwl̈õ ara bor kjinmo anmoyõ kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Pjãy wër shäng di goshko, gueniyo domer tjwe bor irgo l̈ira, pjãy go Sbö Sëya iche tjwe ber kësbang bomi tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eshkoshko ga Jesús opshino jek Nazaret kjokyo dwayo, e Galilea kjokyo obi, ga öötong shäng Jordán diyo, Juan shängshko. Eshko ga wara Juandë jer Jordán diyo roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wara pjir ga Jesús opshik tëm shäng di roy dwayoshko ga ĩya ga kjok dogo roshwino beno oojong erä, ga Sbö Sëya to ter kjok dogo dwayo so dunggwo kjoyo, ga opyono sök ba go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eshko ga ybö kuraba kjok dogo dwayo, tjl̈ẽ ga «Bor wa l̈i pja. Pja woydër ara. Tja wopjl̈ú bop tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","E irgo ga Jesús söra Sbö Sëyarë jek öötong shäng kjok dogro no l̇l̇ëmshko, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","äya kjl̈oshko so tjeng ara l̈ishko, ga beno shäng eshko dbargwo sak pkëng (40). Eshko ga tjl̈ĩna Ärë ara, l̇l̇ëbo owa shäryë wl̈o l̈ara. Ga Sbö parkagaga kjok dogo so shrono tjeng ba tjok kjl̈öbö ba kjimtë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan bängzaraba shäng no shdũzl̈ong uyo roshko irgo ga Jesús jek öötong shäng Galilea kjokyo. Eshko ga Sbö tjl̈õkwo roy pjl̈ú l̈e shäng oba kong, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","tjl̈ẽ ga «Dbar iara Sbörë l̈i öötonge. Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo döröe. E kjĩshko ga l̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈ozĩ, ga rayozĩa. Sbö tjl̈õkwo roy pjl̈ú l̈ër shäng bomi kong l̈i, e kjrozĩa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Domer shäng kjl̈ara ko Simón. Kjl̈ara obi ko Andrés, e Simón l̈ëng. Epga mã shaga. Pjl̈ara ga l̈öng ba kjl̈a mã shakkl̈o dbuk Galilea di bäng buk kësbang, shkung, so dl̈ung kjoyo l̈i roshko. Eshko ga Jesús jek jëk shäng diksor go, ga ĩya ga domerga l̈i bë l̈önge. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Eshko ga tjl̈ẽ ba kong ga «Pjãy tek bor tjok, pjãy pin wl̈o. Pjãy to l̈öng mã shak ame. Pjãy iër to ber l̈öng no töng bor kong shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kuya l̈ok ga ba kjl̈a rayara jekdo, ga to jek ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jek këgo sit ga domerga l̈öng do pjök ko Santiago, Juan. E data Zebedeo. Epga l̈öng ba kjl̈a mã shakkl̈o bängyë kjyong roshko ba data tjok. Ga Jesús jek shäng eshko ga domerga do pjök l̈i ĩna, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ga rokara jek ba tjok, opping ba tjok wl̈o. Kuya l̈ok ga ba data rayara jekdo, beno sök ba kjyong roshko ba parkagaga tjok, ga to jek l̈ok Jesús tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","E irgo ga to l̈ok öötong l̈öng Capernaúm kjokyo. Öötong woshtozl̈ong dbaryoshko ga Jesús opzrëno jek judíoga syõ uyo jong eshko l̈i roshko, ga nopga pina. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tjl̈õkwo l̈ara jl̈õkoyo, dbo ara go, l̈e no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë go l̈irë dik l̇l̇ëme. E kjĩshko ga nopga l̈öng ba kuga l̈i beno l̈öng yëy l̈e erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Eshko ga domer shäng kjl̈ara, goshko Ä sëya kjl̈ara. Ga Jesús ĩya sëya l̈irë ga öö l̈e ba kong dbo goshko, tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Jesús, Nazaret so, ¿pja tek shäng borwa barwë ega? ¿Pja tek shäng borwa pjigare? Pja ë miydër pjl̈úe. Pja iak beno shäng dboy Sbö kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kuya ga sëya l̈i wl̈ona, tjl̈ẽ ba kong ga «Pja kjinkozong. Pja opkjos domer kjwe go dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kuya ga domer l̈i iara jek kl̈an kjl̈ul̈u erä. Eshko ga öö l̈e sëya l̈irë dbo goshko, ga opkjono to domer l̈i go dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ĩya nopga tjeng eshko l̈irë ga beno l̈öng yëy l̈e erä, ga tjl̈ẽ ëng kong ga «¿Kjwe l̇l̇ëro? ¿Tjl̈õkwo tjagl̈ën wl̈eniyo bi kongdo l̇l̇ëm? Tjl̈õkwo kjwe dbo ara. Ä sëyaga iche ga kol̈e bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eshko jek l̈ëkong ga Jesús roy shdöktong jekdo Galilea kjokyo kjok kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","E irgo ga Jesús opshino judíoga syõ uyo l̈i roshko dwayo Santiago, Juan tjok, ga jek öötong l̈öng Simón, Andrés ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Eshko ga Simón ëm buk ba bukkl̈o kjing go, kjl̈irkono buk träk l̇l̇ëme. Roy l̈ara Jesús kongshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","jek öötong shäng swl̈o buk l̈ishko. Eshko ga orkwo shara, kojona, ga kjl̈ik l̈i zenoe. Eni ga wal̈ë l̈i dl̈i shäryono ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jek kjok ro zar ga swl̈opga, nopga goshko Ä sëyaga, e söraba ara Jesús kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kjok eshko sopga uunkong töno shrono l̈ok u bäng l̈i bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nopga swl̈o l̇l̇ë ara poptara Jesúsdë, Ä sëyaga tjeng oba goshko l̈i ichara to bakoe. Jesús, e ë miyde Ä sëyaga tjeng oba goshko l̈irë owa l̇l̇ëme. E kjĩshko ga ichara Jesúsdë tjl̈ẽ l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wẽshko kjok shröngto ga Jesús kojono, opshino jek kjok eshko dwayo, to jongya ëye l̇l̇ëmshko, syõshtë Sbö kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","E irgo ga Simón to shäng ba pjeyoga oppingga tjok ba wl̈ẽk. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wl̈ẽnashko ga tjl̈ẽ l̈ok ba kong ga «Oba uunkong to l̈öng bop wl̈ẽk» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kuya ga tjl̈ẽ ba kong ga «Shji to jongya kjok shto obl̈ë obl̈ë, Sbö tjl̈õkwo roy l̈ër eshko wl̈o, miydëba wl̈o. Tja shrono shäng e kong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eni ga to shäng Sbö tjl̈õkwo roy pjl̈ú l̈ë Galilea kjokyo kjrina kjrinashko, judíoga syõ uyo l̈ok kjwobi l̈i roshko. Ga Ä sëyaga tjeng oba goshko l̈i iche to bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pjl̈ara ga domer shrono shäng kjl̈ara Jesús shwoy. Domer l̈i pogl̈o go swl̈o ara, sho an do jĩkong. Öötong shäng Jesús zl̈ong bäng ga kjök tono ba bokshto, tjl̈ẽ ba kong ga «Tja poptëp woydë ga tja poptëp ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ĩya ga songe l̈e, ga porwara ba orkwo go, ga tjl̈ẽ ba kong ga «Pja poptër woydë. Pja ber pjl̈ú shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jekdo eshko ga domer l̈i poptonoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Eshko ga Jesús tjl̈ẽ ba kong ga «Tja kuzong. Pja poptoror l̈ëp ë kong l̇l̇ëme. Pja nom opping syõshtaga Sbö kong nopga kjĩshko l̈i kong, pja ĩya wl̈o eröe. Sbö sënggl̈o l̈ara Moisésdë, pja äär Sbö poshrëk ba ushko ga pjl̈ú wl̈o l̈i söp, twëp ba kong, pja poptono miydëba wl̈o» l̈e, ga ichara toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Gueniyo ga domer poptono l̈i to shäng kjone pogoshko ga tjl̈ẽ ga «Tja poptara Jesúsdë» l̈e ë kong pogo. E kjĩshko ga Jesús jek opzrëk u ara tjeng l̈ishko ga äe. To jek wl̈eni ga oba tön ba shwoy ara anmoyõ kjĩshko. Eni ga beno shäng no l̇l̇ëmshko. Eni ëmdë ga ĩkoba äär träk l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dbar kjwöbö irgo ga Jesús shrono sök Capernaúm kjokyo iröng obi ba ushko. Miydaraba ga shrono sök iröng ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","oba shrono l̈öng träk l̇l̇ëm ba shwoy, ga u l̈i dl̈ino tjung no eröe. Oba ara ba u bongkjako bakoe. Ëye äär u bäng zl̈ong ga äe. Jesús sök Sbö tjl̈õkwo roy l̈ë oba kong kjër roshkoshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","domerga tjwe l̈öng dogl̈o pkëng (4), swl̈o söno kjl̈ara. Swl̈o l̈i buk töshko, dre kuga l̇l̇ëm wl̈eniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eshko ga söra l̈ok shrono u bongkjako ga söya kjër roshko, Jesús sökshko l̈ara, gueniyo to öötong ey l̇l̇ëm, oba ara kjĩy. Eni kuzong ga jem tyono l̈ok u dbo kjing sdok l̈i kjing go, kjing döra sira, swl̈o l̈i l̈ona ter pjang ba pogl̈o roshko öötong buk dew, Jesús sök l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ĩya Jesúsdë ga swl̈o sögaga l̈i mär ba go ga tjl̈ẽ swl̈o buk töshko l̈i kong ga «Domer, owa pjang bop go l̈i l̈önor beno drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go l̈öng eshko kjl̈öbö. Wotjl̈ĩk l̈ok ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«¿Kjwe ëro? ¡Domer kjwe shäng Sbö l̈ãywë owa, ber tjwl̈õ l̇l̇ëm wl̈o l̈e! Owa l̈öngga nopga kong l̈i Sbö eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wotjl̈ĩk l̈öng l̇l̇ë l̈i miydara Jesúsdë pjir kuzong ga tjl̈ẽ ba kong ga «¿Pjãy wotjl̈ĩk owa eni ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Owa pjang bop go l̈i l̈önor beno drete” l̈oror ba kong. Gueniyo l̈önorde, de l̈önor l̇l̇ëm, e ĩgömi l̇l̇ëme. Gueniyo ga “Pja kojõzong. Bop bukkl̈o kjwe kjrozong. Pja jëkzong” l̈oror ba kong ga poptororde, de poptoror l̇l̇ëm, era ĩgömi wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kjok ëre kjing go ga no to ter kjok dogo dwayo ëre dbo ara, owa pjang nopga go l̈i l̈ön ber dret wl̈o ga pjl̈úe. Miydëmi wl̈o ga l̇l̇ëbo shäryër e» l̈e. Eni ga tjl̈ẽ swl̈o buk töshko l̈i kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«L̈ër bop kong ga pja kojõzong. Bop bukkl̈o kjwe kjros, ga pja nom bop ushko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kuya ga kojono, ba bukkl̈o kjrara, ga to jek ba ushko. Ĩya l̈öng eshko l̈irë ga beno l̈öng yëy l̈e erä, ga Sbö poshrëra, ga tjl̈ẽ l̈ok ëng kong ga «L̇l̇onoshko ga l̇l̇ëbo ĩydë kjweni l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E irgo ga Jesús jek öötong shäng di bäng buk kësbang l̈i kjako obi. E irgo ga nopga öötong l̈öng ara ba zl̈ong, ga epga pĩya Jesúsdë shäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jek jëk shängshko ga domer sök kjl̈ara eshko ko Leví, e dbur töngga Roma so kong. E Alfeo wa. E sök ba pak l̈ishko. Ĩya Jesúsdë ga tjl̈ẽ ba kong ga «Pja tek bor tjok, pja pin wl̈o» l̈e. Kuya ga kojono, ga to jek ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","E irgo ga Jesús jek öötong sök ië Leví ushko, ba oppinggaga tjok. Ga nopga dbur töngga Roma so kong öötong l̈öng ië ba tjok eshko, nopga owa wl̈eniyo obl̈ë öötong l̈öng ië ba tjok eshko bakoe. Nopga eniyo jëk l̈öng Jesús tjok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Eshko ga nopga l̈öng kjl̈öbö no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, epga fariseoga bakoe. Ĩya l̈ok ga Jesús sök ië nopga eniyo tjok ga tjl̈ẽ ba oppinggaga l̈öng l̈i kong ga «¿Bomi pingga kjwe ië nopga owa wl̈eniyo tjok kjweni ega?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kuya Jesúsdë ga tjl̈ẽ ba kong l̈ok ga «Nopga l̈öng pjl̈ú, swl̈o l̇l̇ëm ga e dwl̈omnega woydë l̇l̇ëme. Swl̈opgara dwl̈omnega woydë. Eni ga tja shrono shäng kjok ëreshko, nopga pjl̈o bek l̈i rokaga l̇l̇ëm, nopga owa l̈i rokaga eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ol̈ö ga Juan oppinggaga, fariseoga, e ië l̇l̇ëm Sbö kong. Pjl̈ara ga l̈öng ië l̇l̇ëm enishko ga nopga tek shrono l̈öng Jesús shwoy ga tjl̈ẽ ba kong ga «Juan oppinggaga ië l̇l̇ëm Sbö kong dbar kop ara. Fariseo oppinggaga omshäryë eni bakoe. ¿Bop oppinggagara omshäryë eni l̇l̇ëm ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","«Orkwosmozl̈ong dbaryoshko ga domer orkwosmok wl̈o l̈i shäng ba tjok obishko ga nopga mak l̈öng eshko l̈i ië l̇l̇ëm ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gueniyo domer l̈i söraba ba shjiryoshko ga epga ië l̇l̇ëm eshko jã. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","»Shwong këguë bängyëy shwong l̈ikyo tjagl̈ën go l̇l̇ëme. Shäryoroy eni kjwe ga shwong l̈ikyo tjagl̈ën l̈i, shwong këguë l̈i, e sreya, dwl̈er jek këgong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","»Kjil̇l̇gwo bo dyo dbo ara tjagl̈ën tyëy ba bapkwo këguë shäryak öng kwota go roshko l̇l̇ëme. Shäryoroy eni kjwe ga ba bapkwo l̈i böptur. Eni ga kjil̇l̇gwo bo dyo l̈i, e ber l̇l̇ëno ame, ba bapkwo l̈i ber eni bakoe. Eni kuzong ga kjil̇l̇gwo bo dyo dbo ara tjagl̈ën tyëy wl̈o ga woyde bapkwo tjagl̈ën» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Woshtozl̈ong dbaryo kjwara ga Jesús jëk shäng dwl̈a dgak buk l̈i tjrëko ba oppinggaga tjok. Eshko ga ba oppinggaga l̈öng dwl̈a bo kjrë, ue l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ĩya fariseogarë ga tjl̈ẽ Jesús kong ga «¡Bop oppinggaga kjwe ĩzong! ¿L̈öng l̇l̇ëbo shäryako woshtozl̈ong dbaryoshko l̇l̇ëm l̈i shäryë ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","«¿Dënashko ga David, ba yorkagaga pjl̈i l̈ok arashko ga l̇l̇ëye shäryara tak pjang Sbö tjl̈õkwo go l̈i, e l̈omirë l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar sök syõshtaga Sbö kong ba pjeyoga kjĩshko kësbangyo dbaryoshko ga David opzrëno jek shäng Sbö u roshko, ga pjl̈ung shosho suk pjir iak beno tjeng dboy Sbö kong l̈i uara, ga twara ba nopga jëk l̈öng ba tjok l̈i kong, ue wl̈o bako, e uaga syõshtagagarë erö gueniyo» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","E irgo ga tjl̈ẽ ba kong obi ga «Woshtozl̈ong dbaryo, e shäryak beno nopga kjimtokl̈o. Nopga, e shäryak beno woshtozl̈ong dbaryo kjimtokl̈o l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","E kjĩshko ga woshtozl̈ong dbaryo kägäyo l̈i, no to ter kjok dogo dwayo ëre l̈i e» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","2","Woshtozl̈ong dbaryo obl̈ë ga Jesús opzrëno jek judíoga syõ uyo jong kjok eshko l̈i roshko. Domer shäng kjl̈ara eshko orkwo kjwara sl̈osl̈oe. Fariseoga l̈öng eshko bako, Jesús dë, swl̈o l̈i popte woshtozl̈ong dbaryore ĩya l̈ok wl̈o, rote e go wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Eshko ga Jesús tjl̈ẽ swl̈o l̈i kong ga «Pja kojõs shäng nopga l̈öng kës ëre tjrëko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","E irgo ga Jesús tjl̈ẽ fariseoga l̈i kong ga «¿Woshtozl̈ong dbaryo ga l̇l̇ëye shäryëy obl̈ë kong ga pjl̈ú? ¿L̇l̇ëbo pjl̈úre, de l̇l̇ëbo owa? ¿Ëre dbaryo ga kjl̈ara buk ba l̇l̇ëmdo shinmotkë wl̈o ga l̇l̇ëye shäryëy? ¿Wẽyẽre, de kjimtëy?» l̈e. Kuya l̈ok ga beno tjeng kjing erä. Dboryara l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Eshko ga l̈öng ba zl̈ong bäng pjribri l̈i ĩna, ga iirkorgö ba kong, swl̈o l̈i songe l̈e l̈ok l̇l̇ëm kjĩshko. Ga tjl̈ẽ swl̈o l̈i kong ga «Pja orkwo roshwĩzong» l̈e. Kuya ga orkwo roshwino, ga poptono beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Gueniyo ga fariseoga opshino jek l̈ok ey dwayo, ga öötong ëng töno l̈ok Herodes pjl̈oyoga tjok. Eshko ga tjl̈ẽ l̈ok ëng kong ga «¿Jesús, e zröy sorë ga pjl̈ú?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Dbar kjwara ga Jesús opkjono jer öötong shäng ba oppinggaga tjok di bäng buk kësbang l̈i kjako. Nopga to jek ara ba tjok. Jesús roy öötong kjok shto obl̈ë obl̈ë, ga nopga shrono l̈öng ara ba ĩk, Galilea sopga, Judea sopga, Jerusalén sopga, Idumea sopga, kjok buk Jordán diyo kjwo kal̈ëkong sopga, Tiro sopga, Sidón sopga bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jesús shäng nopga poptë ara, e miydaraba kuzong ga swl̈opga shrono l̈ok ara ba zl̈ong bäng, porwe l̈ok wl̈o. E kjĩshko ga ba oppinggaga ichara kjyong wl̈ẽk kjl̈ara, nopga tjwe arashko ga jem tyë kjyong l̈i roy wl̈o, l̇l̇ikoba l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Eshko ga nopga goshko Ä sëyaga tjeng kjl̈öbö. Jesús ĩya l̈okshko ga tjwe l̈öng ba zl̈ong bäng, ga kjök torgö, öö l̈e l̈ok, tjl̈ẽ ba kong ga «¡Pja Sbö Wa!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kuya ga tjl̈ẽ ba kong ga «Tja ë l̈ëmi ë kong l̇l̇ëme. ¿Kuromire?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","E irgo ga Jesús to jem dl̈up jong kjwara eshko bigdo go. Eshko ga nopga rokara tek ba zl̈ong bäng kjl̈öbö, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ga kjrara dogl̈o sak kjwara kjingsho pjök (12), ber l̈öng Sbö tjl̈õkwo roy l̈aga ba ãska wl̈o, ber tjeng jëk ba tjok wl̈o, iche Sbö tjl̈õkwo roy pjl̈ú shdök kjok shto obl̈ë obl̈ë wl̈o, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ä sëyaga tjeng oba goshko l̈i iche dbo twara ba kong l̈i go wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Domerga kjrara dogl̈o sak kjwara kjingsho pjök (12) l̈i ko l̈ok eni: Simón, e koiara beno Pedro; ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, e Zebedeo wa; Juan, e Santiago kjl̈arayo, pjöyĩkong l̈i kowaraba Boanerges (e epga so kjrik kjoyo l̈okl̈o); ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés; Felipe; Bartolomé; Mateo; Tomás; Santiago, e Alfeo wa; Tadeo; Simón, e zelote; ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, e Jesús soynega. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","E irgo ga Jesús jer dl̈up l̈i dwayo, ga opzrëno jek u roshko. Jesús ĩkoba shrono l̈öng ara kuzong ga Jesús, ba oppinggaga, e kong dbar ië l̈ok wl̈o ëmdë ga drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eni ga l̇l̇ëye shärye shäng l̈i roy kuya ba pjeyoga epenga l̈irë ga woyotjl̈ĩya l̈ok ga «E skwẽrkono dikjoyoe» l̈e. E kjĩshko ga tjl̈ẽ l̈ok ëng kong ga «Shji to wl̈okjrë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go tek shrono l̈öng Jerusalén kjokyo dwayo kjl̈öbö, ga tjl̈ẽ l̈ok ga «¡Domer kjwe goshko Beelzebú! Ä sëyaga iche to, dbo twara Ä sëya kägäyo ko Beelzebúrë ba kong l̈i go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eni ga nopga l̈öng l̈i rokara Jesúsdë tek ba zl̈ong bäng, ga tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga «¿Ä, e iche Ärë opshik om go sorëro? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pjl̈u l̇l̇ë, ba nopga ëngkjwë ëng tjok kar kar wl̈eni ga e oppjik l̈ok om go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nopga tjeng u kjwaraso, e ëngkjwë ëng tjok kar kar wl̈eni ga e oppjik l̈ok om go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","¿Eni ga Ä, e ëngkjwë ba sëyaga tjok wl̈eni ga e pjir mal̈ing l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","»Domer sök kjl̈ara dbo ara ba ushko wl̈eni ga no jek äär opzrëk l̈ũrkë ba u roshko ga äe. Woyde ga domer l̈i shara, pjrira bäm go guing. Enira ba l̇l̇ëbo l̈ũyotke ga pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","»L̈ër bomi kong jl̈õkoyo ga ëye l̇l̇ëbo owa shäryë, tjl̈õkwo l̈ë owa ga owa l̈i l̈ö̃ya Sbörë ber dret ga pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gueniyo ëye Sbö Sëya l̈ãywë owa ga owa l̈i l̈ö̃ya l̇l̇ëme. To beno pjang ba go ĩyadoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tjl̈ẽno eni, l̈unashko ga no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go tjl̈ẽno l̈ok ga «Domer kjwe goshko Ä sëya kjl̈ara» l̈ara eni kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eshko ga Jesús mekë, ba l̈ëmga, e shrono tjeng kjoko, ga no ichara l̈ok kjl̈ara ba rokë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eni ga nopga sirkeno tjeng Jesús zl̈ong bäng l̈i tjl̈ẽ ba kong ga «Bop mekë, bop l̈ëmga, e shrono tjeng bop wl̈ẽk kjoko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kuya ga tjl̈ẽ ba kong ga «¿Bor mekë, e ë? ¿Bor l̈ëmga, e ë?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eni ga ba oppinggaga sirkeno tjeng ba tjok l̈i ĩya ga tjl̈ẽ ga «Bor mekë l̈ër l̈i kjwepga. Bor l̈ëmga l̈ër l̈i kjwepga. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ëye Sbö kol̈ë ga era bor mekë wl̈eni, bor l̈ëng wl̈eni, bor dor wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús öötong sirkeno sök di bäng buk kësbang l̈i sor go ga nopga pina eshko jek obi. Nopga shrono l̈öng ara kjĩshko ga Jesús opyono kjyong roshko, ga sirkeno sök eshko. Nopga l̈i beno tjeng di bäng l̈i kjako. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eshko ga epga pina ara l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Tja kuzĩa. Domer shäng kjl̈ara dwl̈a sguingga. Pjl̈ara ga opshino to jek dwl̈a sguing. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sguĩyashko ga kjone kjone l̈ono tjeng irbo bäng, ga sënwa shrono, ga uara l̈ok drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kjone kjone l̈ono tjeng ak ara tjrëko, kl̈ung sho ara l̇l̇ëmshko, ga weno mal̈ing, kl̈ung sho rong l̇l̇ëm kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Gueniyo sl̈enggwo dret kjĩshko ga dl̈o wenoshko ga sura, beno dogroe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dwl̈a kjrina obi, e l̈ono tjeng shkö sho roshko, ga shkö sho l̈i kunoshko ga dwl̈a l̈i l̇l̇gwĩna beno bo l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dwl̈a kjrina obi, e l̈ono tjeng kl̈ung sho pjl̈ú kjing go, ga kuno, botjyono pjl̈úe. Kjoneshko ga sok kjwara botjyono kjwo sak mya (30), kjoneshko ga botjyono kjwo sak tjer (60), kjoneshko ga botjyono kjwo sak dbäw (100)» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","E irgo ga tjl̈ẽ ba kong jek sira obi ga «Ëye kwomgwo tjok ga woyde ga kuya yõtso» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nopga tjeng kës l̈i briktong irgo ga Jesús oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i, oba obl̈ë jëk l̈öng ba tjok wl̈eniyo, e tjl̈ẽ l̈ok ba kong ga «Rokërwa bop kong sira ga l̇l̇ëye l̈orop l̇l̇ëbo jyãgl̈o go yẽ, e l̇l̇ë l̈okl̈o pjl̈ol̇l̇gwes borwa kong, miydërwa wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kuya ga tjl̈ẽ ba kong ga «Sbö ber no pjl̈uyo sorë l̈i roy miydaydëba l̇l̇ëm l̈i pinaba bomi kong. Gueniyo nopga obl̈ë kongda, l̈ër l̇l̇ëbo jyãgl̈o go erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eni ga »“Ĩya l̈öng kjër ga l̇l̇ë ĩyde miyde l̈ok l̇l̇ëm, kuya l̈öng kjër ga l̇l̇ë l̈okl̈o miyde l̈ok l̇l̇ëm bakoe. Eni l̇l̇ëm kjwe ga optwë ber Sbö kong, ga owa pjang ba go l̈i l̈ö̃ya ber drete”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","E irgo ga Jesús tjl̈ẽ ba kong ga «¿Tjl̈õkwo l̈ër shäng l̇l̇ëbo jyãgl̈o go ëre l̇l̇ë l̈okl̈o miydëmi l̇l̇ëmde? Miydëmi l̇l̇ëm ga tjl̈õkwo l̈ër l̇l̇ëbo jyãgl̈o go obi ga miydëmi l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dwl̈a sguingga l̈i, e Sbö tjl̈õkwo l̈aga oba kong l̈i l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kjone kjone, e so dwl̈a l̈ono tjeng irbo bäng l̈i kjoyoe. Tjl̈õkwo l̈i kuya, gueniyo Ä tjwe eshko, ga döya ba shjiryo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","»Kjone kjone, e so dwl̈a l̈ono ak ara tjrëko l̈i kjoyoe. Tjl̈õkwo l̈i kuya ga kjre l̈ok wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Gueniyo tjl̈õkwo l̈i äär ber ba pjl̈úshko jl̈õkoyo l̇l̇ëm kjĩshko ga l̇l̇ëye wen ba kong sirashko, epga shdungoba tjl̈õkwo l̈i kjĩshkoshko ga raye, söya ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","»Kjone kjone, e so dwl̈a l̈ono shkö sho roshko l̈i kjoyoe. Tjl̈õkwo l̈i kura, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","gueniyo l̇l̇ëbo tjeng kjok ëre kjing goshko l̈i woyotjl̈ĩya ara, wo pjang dbur go, l̇l̇ëbo tjeng kës l̈i kjre woydë ber ba kong wl̈o bakoe. E kjĩshko ga tjl̈õkwo l̈i woyo ba kong ame, ga bo wen tjl̈õkwo l̈i kjĩshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","»Gueniyo ga kjone kjone obi, e so dwl̈a l̈ono tjeng kl̈ung sho pjl̈ú kjing go l̈i kjoyoe. Tjl̈õkwo l̈i kuya, ga kjre jl̈õkoyo. E ber shäng so dwl̈a botjyono pjl̈ú kjoyoe. Kjoneshko ga sok kjwara botjyono kjwo sak mya (30), kjwo sak tjer (60), kjwo sak dbäw (100)» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","E irgo ga Jesús tjl̈ẽ ba kong ga «Iök borkey jong shjiy, jney l̇l̇ëbo dorko wl̈o l̇l̇ëme. Iëy jong kjókshko dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","L̇l̇ëbo jnek tjeng l̈i, e woyde Sbörë ga ber ĩkoba wẽl̈ë wl̈o. Ga l̇l̇ono ga e ber miydëba dret, iök shjiy poyong jong kjókshko wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ëye kwomgwo tjok ga woyde ga kuya yõtso. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","»Ga l̇l̇ëye kumi l̈öng l̈i kuzĩ yõtso. Kumi yõtso wl̈eni ga pjãy opping ara. Kumi yõtso l̇l̇ëm wl̈eni ga pjãy opping ara l̇l̇ëme. Kumi sorë ga pjãy opping eni, ga pjãy opping e kjinmo obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ëye l̇l̇ëbo tjok ga së̃ya jek obi. Ëye l̇l̇ëye l̇l̇ëm ga l̇l̇ëye tjeng sirawa l̈i döya ba shjiryo drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","E irgo ga Jesús tjl̈ẽ ba kong obi ga «Sbö ber no pjl̈uyo sorë, e so dwl̈a sguina domer kjl̈ararë kjoyoe. Dwl̈a, e sguina beno kl̈ung sho kjing go, ga domer l̈i shrono iröng ba ushko. Eshko ga pë, wol̇l̇en, ga bë sök wl̈ẽpe. E wopro ga dwl̈a sguina beno tjeng l̈i weno, ga kuno, shäryë eni sorë miyde domer l̈irë l̇l̇ëm gueniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dwl̈a l̈i kun jong l̈aga kl̈ung shorë. Kun jem, korga wen, kjing shen, ga bo kwirkë shjiye. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bo kwirkono shjiy kuzong ga domer l̈i jongya ba skok kjwl̈ë jã» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","E irgo ga Jesús tjl̈ẽno ba kong jek obi. Tjl̈ẽ ga «¿Sbö ber no pjl̈uyo sorë, e so l̇l̇ë kjoyo? ¿L̈ër bomi kong sorë ga pjl̈ú? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E so kjor dwl̈ayo chirawa ko mostaza dgoroy kl̈ung roy kjoyoe. Dwl̈agwo ëre chirawa, dwl̈agwo obl̈ë obl̈ë dorko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Gueniyo kun kësbang, dwl̈agwo obl̈ë obl̈ë kjinmo. Eshko ga sënwa l̇l̇ë usho ywë ba kowo go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nopga pina Jesúsdë l̇l̇ëbo jyãgl̈o go eni. Kura l̈ok, gueniyo l̇l̇ë l̈okl̈o miydara l̈ok uunkong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesús tjl̈ẽno nopga kong l̇l̇ëbo jyãgl̈o go erä. Gueniyo nopga tjeng kës l̈i briktong l̈ok pjirshko ga l̇l̇ëye l̈ara l̇l̇ëbo jyãgl̈o go l̈i, e l̇l̇ë l̈okl̈o pjl̈ol̇l̇gwera ba oppinggaga kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Kjok sëng ga Jesús sök kjyong roshko obi, ga tjl̈ẽ ba oppinggaga kong ga «Shji to dipzë, di bäng buk kësbang ëre kjwo kal̈ëkong» l̈e. Kuya l̈ok ga opyono l̈ok kjyong l̈i roy ga «Tjawa toe» l̈e l̈ok nopga kong, ga to jek ey dwayo. Eshko ga kjyong obl̈ë sökoba jek tjeng ba tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Eshko ga pjl̈uk tjwe jong träk l̇l̇ëm, dbo ara di bäng buk kësbang l̈i kjing go. Di iõya ara, ga di dl̈in jong kjyong l̈i roy, pir sek seke. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Eshko ga Jesús buk pë kjyong sigwo l̈ëkong, kä iak buk kä iokl̈o kjing go. Eni ga ba oppinggaga jek l̈öng ba wol̇l̇eng, ga tjl̈ẽ ba kong ga «¡Tjl̈apga no pingga! ¡Shji ba pitoe! ¿Pja buk wl̈ẽp ega?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kuya ga kojono, ga tjl̈ẽ pjl̈uk, di iõya l̈i kong ga «Pja sl̈anzong. Pja ber tjëkso» l̈e, ga beno buk tjëkso. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eshko ga tjl̈ẽ ba oppinggaga kong ga «¿Kjok bangkjrëmi ara ega? ¿Pjãy mär bor go l̇l̇ëm obire?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eni ga epga shgawara l̈öng ara. Ga tjl̈ẽ ëng kong ga «¿Kjwe ëro? Ĩzĩa. Tjl̈ẽno pjl̈uk, di iõya l̈i kong ga kol̈e pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús, ba oppinggaga, e dipzono jek öötong l̈öng di bäng buk kësbang l̈i kjwo kal̈ëkong, Gadara kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Eshko ga domer goshko Ä sëya kjl̈ara. Kjra l̈ëba, shakoba or go ga ä kuzong ga kjrocharaba dröng sho go pjl̈ogl̈o kop ara, gueniyo ba dröng sho l̈i skoya jek tas tas erä. Ga domer l̈i kjwëy l̇l̇ong l̇l̇ëme. Shaga ërë l̇l̇ëm bakoe. Jëk to shäng sakshko erä. To shäng öö l̈e öö l̈e kjl̈oy. Äär kjone ga opyok to shäng ak go. Eni ga Jesús ĩya sak tjeng l̈ishko dwayo ga tek shrono shäng ba zl̈ong bäng ga kjök tono. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ĩya Jesúsdë ga tjl̈ẽ ba kong ga «¡Ä sëya, pja opkjos domer kjwe go dwayo!» l̈e. Kuya ga tjl̈ẽ ba kong dbo go ga «¡Sbö Tjwl̈õ Kësbangyo Wa l̈i pja! ¿Pja tek shäng bor barwë ega? ¡Rokër bop kong sira Sbö ko go ga tja shdum l̇l̇ëme!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kuya ga tjl̈ẽ ba kong ga «¿Pja ko l̇l̇ë?» «Tja ko Kop Arae. Tjawa sëya ara domer ëre go kjĩy» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eshko ga tjl̈ẽ l̈ok ba kong obi ga «Rokër bop kong sira ga tjawa ichëp kjok ëreshko dwayo l̇l̇ëme» l̈e ba kong eni kop arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Epga l̈öng l̈ishko soshko ga köchi tjeng träk l̇l̇ëm dl̈up pogl̈o go, ië. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eni ga sëyaga l̈i tjl̈ẽ Jesús kong ga «Rokërwa bop kong sira ga tjawa ichos jek köchi tjeng kjwe go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kuya ga «Jöl̈ö» l̈e, ga sëyaga l̈i opkjono to l̈ok domer l̈i go dwayo, ga jek l̈ok köchi l̈i go shara. Wop eni l̇l̇ëm ga köchi tjeng l̈i zrono jer ri ri dl̈up pogl̈o go, optono l̈ok jer uunkong di bäng buk kësbang l̈i roshko, ga shteno l̈ok dret eshko. Köchi shteno l̈i kop sak dbäw dbäw pjl̈ogl̈o pjök (2,000) dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eni ga köchi dagaga tjeng l̈i töktong jek ey dwayo, ga öötong l̈öng nopga l̈öngshko ga l̇l̇ëye shäryono l̈i roy l̈ara nopga kong pjire. Kuya l̈ok ga tek shrono l̈öng ara ba ĩk. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Shrono l̈öng Jesús shäng l̈ishko ga ĩya l̈ok ga domer dämär ga goshko Ä sëya l̈i, e wl̈ẽna l̈ok bë sök eshko, doyono pjir shwong go, skwẽ ame, poptono sök pjl̈úe. Ĩya l̈ok eni ga beno l̈öng sëya l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","L̇l̇ëye shäryono domer l̈i tjok, köchi l̈i tjok, e l̈ara ba ĩgaga tjeng eshko l̈irë nopga shrono tjeng l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eshko ga nopga l̈i tjl̈ẽ Jesús kong ga «Rokërwa bop kong sira ga pja opshis kjok ëreshko dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kuya ga jl̈õ l̈ara. Jer opyë kjyong royshko ga domer poptono l̈i tjl̈ẽ ba kong ga «Rokër bop kong sira ga tja ios jek bop tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kuya ga tjl̈ẽ ba kong ga «L̇l̇ëme. Pja nom bop ushko iröng dey. L̇l̇ëye shäryara Tjl̈apgarë bop kong l̈i, pja songe l̈ara sorë l̈i, e l̈ëp bop pjeyoga uunkong kong, miyde l̈ok wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kuya ga jl̈õ l̈ara, ga to jek öötong shäng kjokyo ko Decápolis. Eshko ga e poptara Jesúsdë sorë l̈i roy l̈e öötong shäng oba kong eshko. Kukoba ga woyotjl̈ĩkoba beno l̈öng arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","E irgo ga Jesús dipzono jek iröng di bäng buk kësbang l̈i kjwo kal̈ëkong. Öötong shäng di kjako ga oba töno l̈öng träk l̇l̇ëm eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eshko ga domer shäng kjl̈ara ko Jairo. Judíoga syõ uyo jong eshko l̈i kägäyoga shäng kjl̈ara l̈i e. Jesús ĩya ga tek shrono shäng ba zl̈ong bäng ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tjl̈ẽ ba kong ga «Bor wa wal̈ë buk ba l̇l̇ëmdo, shinmotkokdoe. Rokër bop kong sira ga kayo ĩp bor kong. Pja orkwo ië ba kjing go, poptëp wl̈o, shinmotkë l̇l̇ëm wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kuya ga to jek ba tjok. Oba ara kjĩshko ga Jesús jëk shängshko ga pol̇l̇ikoba arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","L̈öng l̈i tjrëko wal̈ë shäng kjl̈ara swl̈o ara l̈u pjl̈ogl̈o sak kjwara kjingsho pjök (12) tjän. Ba dbar ĩya ĩyado, poptë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Öör shäng dwl̈omnega ara shwoy ga ba dburwa tjeng l̈i zana drete. Eni ëmdë ga poptono l̇l̇ëme. Miga beno shäng ro bang ara jek këgong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Bäm go ga Jesús roy miydara, ga wotjl̈ĩk ga «Tja to ĩk. Tja öötong shäng ba shwoy ga ba shwong worbo porwër dö ga tja poptë» l̈e. Eshko ga tek shrono shäng Jesús zl̈ong bäng ba kokso shwo l̈ëkong ga ba shwong worbo porwara, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ga poptono jekdo eshko. Opkuk ga beno shäng pjl̈ú, swl̈o ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jekdo eshko ga Jesús wotjl̈ĩk ga «Miydër ga ëbo poptono, l̇l̇ëbo shäryono bor dbo kësbang go» l̈e. E kjĩshko ga ĩya iröng ga tjl̈ẽ oba kong ga «¿Bor shwong porwaga ërë?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kuya ba oppinggagarë l̈ok ga tjl̈ẽ ba kong ga «Nopga ara kuzong ga pja pol̇l̇iya l̈öng bop zl̈ong bäng pjl̈or kar kare. ¿Eni ga “¿Tja porwaga ërë?” l̈ëp sorëro?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Gueniyo jl̈õ l̈ara l̇l̇ëme. Ĩya beno shäng obi kjl̈arashko kjl̈arashko, porwaga ërë miyde wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eni ga wal̈ë l̈ira ommiydë shäng pjl̈úe. Ga tek shäng Jesús zl̈ong bäng ga kjök tono sök kjl̈o dete erä. Eshko ga l̇l̇ëye shäryono ba kong l̈i l̈ara ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kuya ga tjl̈ẽ ba kong ga «Pja mär bor go kuzong ga pja poptonoe. Pja nom wopjl̈ú bop ushko. Pja woydë ame. Bop swl̈o, e wen bop kong ame» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús tjl̈ẽ shäng wal̈ë l̈i kong wopro ga nopga tek shrono l̈öng Jairo ushko dwayo ga tjl̈ẽ Jairo kong ga «Bop wa yẽ shinmotkonoe. Tjl̈apga no pingga kjwe twëy tjötö ame» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kuya Jesúsdë ga jl̈õ l̈ara l̇l̇ëme. Tjl̈ẽ Jairo kong ga «Pja woydë l̇l̇ëme. Pja mär bor go erä» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eshko ga Jesús to jek Jairo ushko. Ba oppinggaga tjeng ba tjok dogl̈o mya l̈i jek söra ba yorkë, Pedro, Santiago, Santiago kjl̈arayo Juan bakoe. L̇l̇amo söra jek ba tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Öötong l̈öng ushko ga ĩya Jesúsdë ga nopga sl̈ar wopjl̈uk jong träk l̇l̇ëm, kjl̈oshtë ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Eni ga opzrëno jek shäng u l̈i roy ga tjl̈ẽ l̈öng l̈i kong ga «¿Pjãy sl̈ar ara kjweni ega? Kjogl̈o, e wol̈ono l̇l̇ëme. Buk pë erä» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kuya l̈ok ga joywe l̈ok jong erä. Gueniyo ga epga ichara opshik pjire. E irgo ga opzrëno jek öötong shäng kjogl̈o buk l̈ishko, kjogl̈o l̈i data, mekë tjok, ba oppinggaga tjeng ba tjok l̈i tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eshko ga kjogl̈o l̈i orkwo shara, ga tjl̈ẽ ba kong ga «¡Talitá cum!» l̈e. (E «Kjwozirwa, pja kojõzong» l̈okl̈o.) ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jekdo eshko ga kjogl̈o l̈i kojono, ga jëktonge. Kjogl̈o l̈i l̈u pjl̈ogl̈o sak kjwara kjingsho pjök (12). Ĩya l̈öng l̈irë ga beno l̈öng yëy l̈e erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Gueniyo Jesús tjl̈ẽ ba kong l̈ok ga «L̇l̇ëye shäryono jũshko ëre l̈ëmi ë kong l̇l̇ëme» l̈e. Ga ba data, ba mekë, e ichara ba wa l̈i sëng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E irgo ga Jesús opshino to ey dwayo ba oppinggaga tjok, ga jek öötong l̈öng ba kjokshko, tek chirawa ga kuno shäng l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ga öötong woshtozl̈ong dbaryo ga Jesús opzrëno jek judíoga syõ uyo jong eshko l̈i roshko, ga nopga pina. Kuya l̈ok ga nopga ara beno l̈öng yëy l̈e erä. Ga tjl̈ẽ ëng kong ga «¿Kjwe kjok miydë ara opping kjone? ¿Kjok miydë ara l̈i twaga ërë? ¿L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shärye sorë? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿U shäryaga wl̈e kjwe l̇l̇ëmdo? ¿Mekë María l̇l̇ëmdo? ¿L̈ëmga Santiago, José, Judas, Simón l̇l̇ëmdo? ¿Dorga l̈öng na bi tjok bako l̇l̇ëmdo?» l̈e eni. Ga tjl̈õkwo kjre l̈ok woydë l̇l̇ëm, iirkë l̈ok ara erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Eshko ga Jesús tjl̈ẽ ba kong ga «Kjok kjone pogo ga Sbö tjl̈õkwo l̈aga, e iëba tjwl̈õ ara. Gueniyo ba kjok om go l̈ishko, ba ushko ga iëba tjwl̈õ l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E kjĩshko ga l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo to shäryara kjok eshko sopga kong ara l̇l̇ëme. Orkwo iono swl̈opga pjökde myare kjing go, ga poptara. L̇l̇ëbo obl̈ë shäryara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ga Jesús beno shäng wotjl̈ĩk ara, kjok eshko sopga mär ba go l̇l̇ëm kjĩshko. E irgo ga Jesús to jongya oba ping shäng kjok shto obl̈ë obl̈ë ber l̈ok soshko wl̈eniyoshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Öötong shäng shto kjrinashko ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i rokara, ga ichara jek pjök pjöke. Kong dbo twara, Ä sëyaga iche wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Brikdë l̈ok l̇l̇ëm obishko ga tjl̈ẽ ba kong l̈ok ga «Pjãy brikshko ga l̇l̇ëbo sömi ara l̇l̇ëm, bomi kjorkung döe. Pjãy dl̈i sök l̇l̇ëm, kjl̈a l̇l̇ëm, dbur sho l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Shwong pjang bomi do go l̈i sömi ga pjl̈ú, drepkwota bako, gueniyo shwong obl̈ë, drepkwota obl̈ë, e sömi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pjãy äär kjone pogo ga pjãy ber l̈öng u kjwaraso, äär jong pjãy opshik kjok eshko dwayo guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pjãy öötong l̈öng kjone ga pjãy wl̈okjre l̇l̇ëm, pjãy kuya l̇l̇ëm wl̈eni ga pjãy opshik kjok eshko dwayo, ga bomi dre pjl̈ungyo l̈ö̃zĩ ber tjeng eshko. E ber pjãy kura l̈ok l̇l̇ëm l̈i jyãgl̈o, ga owa l̈i ber pjang ba go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eni ga epga to jek l̈öng tjl̈ẽ oba kong ga «L̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈ozĩ, ga rayozĩa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eshkoshko ga nopga goshko Ä sëyaga wl̈ẽna ara, ga sëyaga l̈i ichara to drete. Swl̈opga ara, e dl̈u kjing go kjyo kwona, ga poptara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","E dbaryoshko ga Jesús roy shdöktong kjone pogoshko. Ga kura Pjl̈u Herodesdë. No kjone kjone tjl̈ẽ ga «E Juan No Waga l̈i woshrokdo. L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shärye ga pjl̈ú e kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kjone kjone tjl̈ẽ ga «E Sbö tjl̈õkwo l̈aga tek dënashko so Elías tjwayde shäng» l̈e. Kjone kjone obi tjl̈ẽ ga «E Sbö tjl̈õkwo l̈agaga tek dënashko so obl̈ë l̈i kjoyoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Gueniyo ga oba tjl̈ẽno l̈i kuya Herodesdë ga tjl̈ẽ ga «E Juan. Tja no ichono ba kägä zë kjupargue. E woshrokdo shäng» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herodes shjiy ko Felipe. Ba boy ko Herodías. Kjupäshko ga Herodías kjrara Herodesdë beno sök ba boy shara. E kjĩshko ga Juan tjl̈ẽ Herodes kong ga «Herodías kjwe kjrëp ber bop boy wl̈o ga ä, e bop shjiy Felipe boy kjĩshko. Tak pjang kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go eni» l̈e. E kjĩshko ga nopga ichara Herodesdë Juan shak, bängzaya wl̈o, shdũya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Eni ëmdë ga Juan bangkjre Herodesdë ara. Wotjl̈ĩk ga e domer pjl̈o bek, iara Sbörë beno shäng dboy Sbö kong l̈e. Juan tjl̈õkwo l̈ë l̈i kuya pjl̈ogl̈o ara, kuya ä kjĩshko, woyotjl̈ĩya ara ëmdë. E kjĩshko ga Juan wl̈ikara. Herodíasda omĩywõ shjiktëng, e tjl̈ẽno sorë l̈i kjĩshko. Zröya woydë, gueniyo Juan wl̈ikara Herodesdë kuzong ga zröya ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Öötong Herodes shrëzl̈ong dbaryoshko ga Herodes dl̈i shäryono ara, ga nopga parkë ba tjok l̈i mana ië ba tjok. Ba pjl̈oyoga, ba ëngkjwaga kägäyoga, domerga Galilea so tjwl̈õ ara wl̈eniyo, e mana, ga shrono l̈ok, ië wl̈o. Eshko ga nopga ara l̈i ĩya Herodíasdë ga wotjl̈ĩk ga «Juan, e wol̈on dbaryo öötonge» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","E irgo ga Herodías wa wal̈ë shrono shäng ga bërkono nopga l̈öng kës l̈i bokshto. Ĩya l̈ok ga beno l̈öng wopjl̈úe. E kjĩshko ga Herodes tjl̈ẽ ba kong ga «L̇l̇ëye woydëp l̈i rokos bor kong, ga twër bop kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","L̈ër bop kong jl̈õkoyo ga kjok ichër sök l̈i ëmdë ga “Woydër bëye” l̈ëp bor kong ga twër bop kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kuya ga opshino jek ba mekë shwoy. Tjl̈ẽ ba kong ga «¿Era l̇l̇ëye rokër?» «Juan No Waga kägä rokopdë» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eni ga kjogl̈o l̈i jekdo shäng mal̈ing pjl̈u shwoy, ga tjl̈ẽ ba kong ga «Woydër ga no ichëp Juan No Waga l̈i kägä zë, ga tek söp bor kong kjwl̈ë roshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kuya ga woydë jonge. Gueniyo «L̇l̇ëme» l̈e ba kong woydë l̇l̇ëm, tjl̈ẽno jl̈õkoyo nopga mana l̈öng l̈i bokshto kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Eni ga no ichara kjl̈ara Juan kägä l̈i zë no shdũzl̈ong uyo roshko, tek söya ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Eni ga no l̈i jek öötong shäng no shdũzl̈ong uyo ga Juan kägä zara tas, ga söra, twara kjogl̈o l̈i kong kjwl̈ë roshko. Eshko ga kjrara, ga söra, twara ba mekë kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Roy kuya Juan oppinggagarë ga öör l̈ok ba doyo kjrë, ga söra, jnena l̈ok sakshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sbö tjl̈õkwo roy l̈agaga Jesús ãska l̈i shrono l̈öng iröng obishko ga l̇l̇ëye shäryara l̈ok, Sbö tjl̈õkwo l̈ara oba kong sorë, e l̈ara l̈ok Jesús kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús sökshko ga nopga tjwe jong ara ga brik jong eni bakoe. Eni kuzong ga dbar epga kong ië wl̈o ëmdë ga äe. E kjĩshko ga Jesús tjl̈ẽ ba oppinggaga kong ga «Shji to jongya kjok shto obl̈ë, kjok kjing, no l̇l̇ëm wl̈eniyoshko, shji woshtë wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eni ga opshino jek ey dwayo, ga opyono jem l̈ok kjyong roshko, ga to kjok shto obl̈ë, ber l̈öng tjoksa wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","34","Gueniyo opshinoshko ga ĩna nopga ararë. Ga nopga kjok shto obl̈ë obl̈ë so to jek l̈ok ba irgo pjö l̈ëkong. Jesús opshino kjyong roshko dwayoshko ga nopga ëng töno träk l̇l̇ëm l̈i ĩna, ga songe l̈e. Wotjl̈ĩk ga epga öng wl̈ẽp ushko so daga l̇l̇ëm wl̈eni l̈e. E kjĩshko ga epga pina ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kjok ro zar kjwl̈ë kuzong ga ba oppinggaga tjl̈ẽ l̈ok ba kong ga «Kjok sëng tjän. Kjok ëreshko l̇l̇ëye drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pjl̈ú wl̈o ga nopga kjwe ichos to na dwayo, jek l̇l̇ëbo soynekoba kjone l̈ishko, dl̈i tjwl̈ẽk wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kuya ga tjl̈ẽ ba kong ga «Së̃zĩ pjãydë dey» l̈e. Kuya l̈ok ga tjl̈ẽ ba kong ga «Së̃y uunkong wl̈o ga woyde ga dbur bayo domer parkono dbargwo sak dbäw pjl̈ogl̈o pjök (200) ãska wl̈eni. ¿Shäryërwa sorëro?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eni ga tjl̈ẽ ba kong l̈ok ga «¿Pjãy pjl̈ung shosho suk pjir tjeng kjwobi? To ĩmia» l̈e. Öör ĩna, ga tjwe l̈öng iröng ga tjl̈ẽ ga «Ëreshko pjl̈ung shosho suk pjir tjeng kjwo shkëng (5), mã tjeng do pjök bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kuya ga epga ichara nopga tjeng kjl̈obi l̈i ichë wl̈ar uunkong töshko, shkwamsho kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kuya l̈ok ga nopga wl̈oktong töshko, shtor shtor, kjoneshko ga dogl̈o sak dbäw (100), kjoneshko ga dogl̈o sak shkëng (50). ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pjir ga pjl̈ung shosho suk pjir kjwo shkëng (5) l̈i, mã do pjök l̈i, e kjrara Jesúsdë, ga kjok dogo ĩya jem drëng ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga pjl̈ung shosho suk pjir l̈i tora, ga twara ba oppinggaga kong. Ga pjl̈orgara l̈ok nopga tjeng kës l̈i kong. Mã do pjök l̈i shdöra uunkong kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nopga uunkong iono beno l̈öng bö tjung, wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","E irgo ga dl̈i worbo töna ba oppinggagarë l̈ok shing roshko, beno tjeng shing kjwo sak kjwara kjingsho pjök (12), tjung tjunge. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Domerga iono uunkong ga dogl̈o sak dbäw dbäw pjl̈ogl̈o shkëng (5,000). Wal̈ëga, kjwozirga, e shtak l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","E irgo ga Jesús ba oppinggaga ichono opyë kjyong roshko, dipzë di bäng buk kësbang l̈i kjwo kal̈ëkong wl̈o, äär ber l̈öng Betsaida kjokyo shwo l̈ëkong wl̈o. Ga nopga brik wopro ga Jesús beno shäng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nopga briktong pjir ga Jesús jem öötong shäng dl̈up go tjoksa, syõshtë Sbö kong eshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kjok ro zoktong ga shäng eshko tjoksa. Eshko ga ĩya ga kjyong l̈i jek öötong buk di bäng buk kësbang l̈i roworbëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ga pjl̈uk tek jong ba shwo l̈ëkong. E kjĩshko ga kjra l̈e l̈ok ba kjyong l̈i roshgue jong ba kjl̈ongkwang go. Kjok ba shränto ga Jesús jek jëk shäng di bäng buk kësbang l̈i kjing go, dipzë kjwo kal̈ëkong wl̈o l̈ara. Gueniyo öötong jek shäng ba oppinggaga l̈i soy ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ĩya l̈ok ga tjl̈ẽ ëng kong ga «¡Kjwe äya jl̈õe!» l̈e, ga öö l̈e l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ĩya l̈ok uunkongdë ga bangkjre beno l̈öng ara. Jekdo eshko ga Jesús tjl̈ẽ ba kong ga «¡Pjãy wokjange! ¡Tja l̈i jekdo shäng! L̇l̇ëye bangkjrëmi l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","E irgo ga jem opyono kjyong l̈i roy, ga pjl̈uk l̈i beno tjëksoe. Eshko ga epga beno l̈öng yëy l̈e erä. L̇l̇ëye kuya woydë l̇l̇ëm kjĩshko ga pjl̈ung shosho suk pjir twara oba ara kong l̈i, e l̇l̇ë l̈okl̈o to miydara l̈ok l̇l̇ëm, ga beno l̈öng wotjl̈ĩk ara e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dipzono l̈ok di bäng buk kësbang l̈i kjwo kal̈ëkongshko ga öötong l̈öng Genesaret kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Eshko ga opshik l̈ok kjyong roy dwayoshko ga nopga l̈öng eshko kjl̈öbö. Miydara l̈ok ga kjwe Jesús l̈e eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Eni ga roy shdöra l̈ok kjok eshko kjwang jĩkong. E kjĩshko ga swl̈opga sökoba swl̈o sökkl̈o roy, tjwe jong l̇l̇aw pogo, öötong l̈öng Jesús jëk shäng l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Eni ga äär kjone pogoshko ga swl̈opga söraba, iaraba tjeng l̇l̇ëbo soynezl̈ong irbo sor go l̇l̇ögong l̇l̇ögong. Ga tjl̈ẽ l̈ok Jesús kong ga «Swl̈opga kjwe ichos bop shwong worbo porwë sira döe» l̈e ba kong. Ga porwara, ga poptono jekdo uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pjl̈ara ga no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga kjone kjone, e tjwe l̈öng Jerusalén kjokyo dwayo, ga tek shrono l̈öng Jesús shwoy. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Eshko ga ĩya l̈ok ga Jesús oppinggaga kjong kjong iono, orkwo shwoyde l̇l̇ëm obishko. E kjĩshko ga l̈ãywe l̈ok owa. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fariseoga, judíoga l̇l̇amo l̈i, e ioydë l̇l̇ëm obishko ga orkwo shkwë yõtso enido, ba tjl̈apgaga tek dënashko so sdëkwo sorë ga eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","To l̇l̇ëbo soynezl̈ong ga tjwe ushko iröng ga orkwo shkwë e kjoyo enido, l̇l̇ëm ga ië l̇l̇ëme. Ga ba l̇l̇ëbo iokl̈o, e kwoshkwe l̈ok pjir bako, ba di bapkwo shäryak kl̈ung shosho go, ba sbi shäryak dröng sho go, ba iokl̈o bako, l̈ara ba pjeyoga tek dënashko so l̈irë sorë ga eni. Sgara beno l̈öng l̇l̇ëbo shäryë obl̈ë obl̈ë, e kjoyo kjoyo eni bakoe.) ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","E kjĩshko ga tjl̈ẽ l̈ok Jesús kong ga «¿Bop oppinggaga kjwe, bi tjl̈apgaga tek dënashko so sdëkwo bangkjre l̈ok l̇l̇ëm ega? Ië l̈okshko ga orkwo shkwë l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kuya ga tjl̈ẽ ba kong ga «¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! L̇l̇ëye l̈ara Sbö tjl̈õkwo l̈aga tek dënashko so Isaíasdë bomi kjĩshko l̈i, e jl̈õe. Tjl̈ẽno beno eni: »“Nopga ëre, tja poshrëya ba kjamo go, gueniyo tja woyotjl̈ĩya pjang ba pjl̈úshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","No pĩya kjok l̇l̇gwekkl̈o taga norë l̈i go eröe. E kjĩshko ga tja poshrëya l̈öng l̈i l̇l̇ëno l̇l̇ëme.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","»Sbö kjok l̇l̇gwekkl̈o l̈i sömi ĩyado l̇l̇ëme. Pjãy ber l̈öng no sdëkwo shäryë döe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sbö kjok l̇l̇gwekkl̈o l̈i kol̈ëmi l̇l̇ëm, bomi sdëkwo shäryëmi wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés tjl̈ẽno tek dënashko ga “Bomi dataga, bomi mekëga, e bangkjrozĩ, iozĩ ber tjwl̈õ ara.” Tjl̈ẽno obi ga “Ëye ba data, ba mekë, e äyoshtono ga e zrökko.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Gueniyo ga pjãy tjl̈ẽ ga ëye tjl̈ẽno ba data, ba mekë kong ga “Pjãy kjimtër ga äe. Bor l̇l̇ëbo uunkong ëre tworor tjeng Sbö kong pjire” l̈ara ba kong pjir ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ba data, ba mekë, e kjimte ame ga pjl̈úe l̈ëmi eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Eni ga bomi sdëkwo pimi oba kong l̈i kjĩshko ga Sbö tjl̈õkwo l̈i ioromi beno tjwl̈õ l̇l̇ëme. Ga pjãy l̇l̇ëbo shäryë owa obl̈ë obl̈ë e kjoyo bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Eshko ga nopga rokara tek ba zl̈ong bäng obi, ga tjl̈ẽ ba kong ga «Tja kuzĩ uunkong, miydëmi wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nopga äär ber owa Sbö bokso l̈aga dl̈i ue l̈irë l̇l̇ëme. Miga ber l̈öng äär ba bokshto wl̈o l̈aga ba wotjl̈ĩk wen ba pjl̈úshko l̈irë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tjl̈ẽno oba kong pjir ga opshino jek ey dwayo, ga opzrëno jek öötong shäng u jong kjwara eshko l̈i roshko. Eshko ga ba oppinggaga tjl̈ẽ l̈ok ba kong ga «Rokërwa bop kong sira ga l̇l̇ëye l̈ëp shäng oba uunkong kong yẽ, e l̇l̇ë l̈okl̈o l̈os borwa kong, miydërwa wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Kuya ga tjl̈ẽ ba kong ga «¿L̇l̇ëye l̈ër shäng l̈i l̇l̇ë l̈okl̈o miydomirë l̇l̇ëm obire? Nopga äär ber owa Sbö bokso l̈aga dl̈i uara l̈irë l̇l̇ëme. Dl̈i uëy l̈i jer äär ber tjeng bi bö roshko. Pjir ga tur bi roy dwayo. E äär ber tjeng bi pjl̈úshko l̇l̇ëme. E kjĩshko ga shji äär ber pjl̈o bek Sbö bokso dl̈i kjĩshko l̇l̇ëme» l̈e. Tjl̈õkwo l̈ara Jesúsdë shäng l̈i, e dl̈i uunkong uëy ga pjl̈úe l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pjir ga tjl̈ẽ obi ga «Nopga äär ber owa Sbö bokso l̈aga ba wotjl̈ĩk wen ba pjl̈úshko l̈irë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","No wotjl̈ĩk owa, pë no orkwosmono ba tjok l̇l̇ëm l̈i tjok, no zrök, pë wal̈ë ba boy l̇l̇ëm l̈i tjok, l̈ũrkë, wotjl̈ĩk dbur töng ba kong erö, l̇l̇ëbo shäryë obl̈ë kong owa, oba jyãpgwë, l̇l̇ëbo owa shäryë l̈öktkë l̇l̇ëm wl̈eniyo, wotjl̈ĩk owa obl̈ë tjok ba l̇l̇ëbo kjĩshko, obl̈ë l̈ãywë owa, opyë woydë ber tjwl̈õ ara obl̈ë kjinmo, l̇l̇ëbo shäryë wotjl̈ĩk l̇l̇ëm, e wen tëm ba pjl̈úshko dwayo uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nopga äär ber owa Sbö bokso l̈aga l̇l̇ëbo tjeng kës ëre wen ba pjl̈úshko l̈irë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús opshino to kjok eshko dwayo ga jek öötong shäng Tiro kjokyo. Eshko ga u wl̈ẽna jong kjwara ber sök eshko miydëba l̇l̇ëm wl̈o l̈ara. Gueniyo öötong sök eshko l̈i miydarabae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kjok eshko ga wal̈ë sök kjl̈ara, e judío l̇l̇ëm, e Fenicia so. Fenicia kjokyo, e Siria kjokyo obi. E wa sök kjl̈ara wal̈ë, kjwozirwa wl̈eniyo, goshko Ä sëya kjl̈ara. Jesús roy miydara wal̈ë l̈irëshko ga tekdo shrono shäng ba zl̈ong bäng ga kjök tono, tjl̈ẽ ba kong ga «Tja wa sök kjl̈ara ushko wal̈ë, goshko Ä sëya kjl̈ara. Rokër bop kong sira ga sëya l̈i ichëp to bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Gueniyo kuya ga tjl̈ẽ ba kong ga «Woyde ga bi wapga ië bäm go. Bi wapga dl̈i l̈i döy, twëy shjiti kong wl̈o ga äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kuya ga tjl̈ẽ ba kong ga «Jl̈õe, Tjl̈apga. Gueniyo wapga l̈i iëshko ga ba dl̈i pjl̈oyo l̈on ter töshko ga ue shjitirë ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kuya ga tjl̈ẽ ba kong ga «Tja dboryorop eni kjĩshko ga pja woydë ame. Pja nom iröng bop ushko. Ä sëya pjang bop wa go l̈i to tjän» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wal̈ë l̈i to ey dwayo. Öötong shäng ba ushko ga ba wa l̈i wl̈ẽna buk ba bukkl̈o kjing go. Ä sëya l̈i to tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","E irgo ga Jesús opshino to Tiro kjokyo dwayo, jongya Galilea di bäng buk kësbang bukshko. Jek shäng l̈i jek jong Sidón kjokyo ga öötong shäng Decápolis kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eshko ga domer sök kjl̈ara kjok kugö l̇l̇ëm, tjl̈ẽ ma wl̈eniyo. Domer l̈i söraba Jesús zl̈ong bäng, ga tjl̈ẽ l̈ok ba kong ga «Rokërwa bop kong ga pja orkwo ios domer ëre kjing go sira, poptëp wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kuya ga domer l̈i orkwo shara, ga söra jek nopga ara l̈öng l̈ishko dwayo pjola sira. Öötong l̈öng eshko ga Jesús sakkwo zrëno domer l̈i kwomgwo bäng kar kare. E irgo ga ba sakkwo shira iröng, ga pöra ba tröng go, ga domer l̈i kjyorkwo porwara ba sakkwo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Eshko ga kjok dogo ĩya jem drëng ga tjwl̈õ shrono rong, domer l̈i songe l̈e kjĩshko. Ga tjl̈ẽ domer l̈i kong ga «¡Efatá!» l̈e. (E «Kwom ro, pjãy roshwĩzong» l̈okl̈o.) ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jekdo eshko ga domer l̈i kwom ro tuk l̈i roshwino beno kjok kugö pjl̈úe. Ba kjyorkwo l̈i döktong beno tjl̈ẽ pjl̈ú bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","E irgo ga Jesús tjl̈ẽ nopga l̈öng l̈i kong ga «Domer ëre poptoror l̈ëmi ë kong l̇l̇ëme» l̈e. Gueniyo jl̈õ l̈ara l̇l̇ëme. «L̈ëmi l̇l̇ëme» l̈e Jesúsdë jek obi. Enira kuya l̈ok ga roy shdöra l̈ok jek këgong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eni ga nopga beno l̈öng yëy l̈e erä. Ga tjl̈ẽ l̈ok ëng kong ga «L̇l̇ëbo shärye kës l̈i, e owa l̇l̇ëme. Nopga kjok kugö l̇l̇ëm wl̈eniyo ie ber shäng kjok kugö wẽl̈ëe. Nopga tjl̈ẽ l̇l̇ëm wl̈eniyo ëmdë ga ie ber shäng tjl̈ẽ bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dbar kjwara ga nopga shrono töno l̈öng ara Jesús sök l̈ishko. Dl̈i l̇l̇ëm kuzong ga ba oppinggaga rokara Jesúsdë tek ba zl̈ong bäng, ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nopga kjwe l̈öng bor tjok na öötong dbargwo mya, ga l̇l̇ëye uako l̇l̇ëme. E kjĩshko ga songe l̈ër. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jek ichër ba ushko ië l̇l̇ëm ga äe. Kjone kjone tjwe pjola dwayo. E kjĩshko ga wopjir irbo kjwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kuya l̈ok ga tjl̈ẽ ba kong ga «¿Nopga träk l̇l̇ëm kjwe së̃y sorë? ¿Kjok no l̇l̇ëmshko ëre dl̈i wl̈ẽy kjone?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kuya ga tjl̈ẽ ba kong ga «¿Pjãy pjl̈ung shosho suk pjir tjeng kjwobi?» «Tjeng kjwo kjäk (7)» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eni ga nopga l̈i ichara Jesúsdë wl̈ar uunkong töshko. Pjir ga pjl̈ung shosho suk pjir kjwo kjäk (7) l̈i, e kjrara, ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga dl̈i l̈i tora, twara ba oppinggaga kong. Ga pjl̈orgara l̈ok nopga tjeng kës l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mã tjeng kjl̈öbö chilawa bakoe. Eni ga Jesús tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga mã l̈i twara ba oppinggaga kong, pjl̈orgue l̈ok nopga tjeng kës l̈i kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eshko ga nopga uunkong iono beno l̈öng bö tjung, wopjl̈úe. E irgo ga dl̈i worbo töna ba oppinggagarë l̈ok shing roshko, beno tjeng shing kjwo kjäk (7), tjung tjunge. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Domerga iono uunkong ga dogl̈o sak dbäw dbäw pjl̈ogl̈o pkëng (4,000) dik. Wal̈ëga, kjwozirga, e shtak l̇l̇ëme. E irgo ga nopga briktong pjir ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesús opyono kjyong roshko ba oppinggaga tjok, ga to ey dwayo, jek öötong l̈öng Dalmanuta kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Eshko ga fariseoga tek shrono l̈öng Jesús shwoy, ba tjl̈ĩk wl̈o. Tjl̈ẽ ba kong ga «L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryos borwa kong kjrina, pja ichaga Sbörë jl̈õre miydërwa e go wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kuya ga tjwl̈õ shrono rong, ga tjl̈ẽ ba kong ga «¿Eerishko dbaryo sopga, woydëmi ga l̇l̇ëbo jyãgl̈o shäryër bomi kong ega? L̈ër bomi kong jl̈õkoyo ga shäryër l̇l̇ëme» l̈e, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ga rayara beno l̈öng eshko. E irgo ga opyono kjyong roy, ga dipzono jek di bäng buk kësbang l̈i kjwo kal̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ga jek l̈öng kjyong roshkoshko ga miydara ba oppinggagarë l̈ok ga dl̈i söra l̈ok l̇l̇ëm, pjl̈ung shosho suk pjir beno buk kjwara eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ga Jesús tjl̈ẽ ba kong l̈ok ga «Pjãy sjëk fariseoga, Herodes, ba pjl̈ung shosho uukkl̈o wl̈e tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eni ga epga tjl̈ẽ l̈ok ëng kong ga «Shji pjl̈ung shosho suk pjir söno l̇l̇ëme. L̈e shäng bi kong eni e kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tjl̈ẽ l̈öng ëng tjok l̇l̇ë l̈i miydara Jesúsdë kuzong ga tjl̈ẽ ba kong ga «¿“Shji pjl̈ung shosho suk pjir söno l̇l̇ëme” l̈ëmi ega? ¿Bor tjl̈õkwo l̈i l̇l̇ë l̈okl̈o miydomirë l̇l̇ëm obire? ¿L̇l̇ëye kumi woydë l̇l̇ëm obire? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pjãy bokkwo tjok, gueniyo pjãy kjok ĩgö l̇l̇ëme. Pjãy kwomgwo tjok, gueniyo pjãy kjok kugö l̇l̇ëm bakoe. ¿L̇l̇ëye woyo bomi kong l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Domerga sënor dogl̈o sak dbäw dbäw pjl̈ogl̈o shkëng (5,000), pjl̈ung shosho suk pjir kjwo shkëng (5) goshko ga dl̈i beno obi tönomi shingyo kjwobi?» «Shingyo dl̈inorwa kjwo sak kjwara kjingsho pjök (12)» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Eshko ga tjl̈ẽ ba kong l̈ok obi ga «¿Domerga sënor dogl̈o sak dbäw dbäw pjl̈ogl̈o pkëng (4,000), pjl̈ung shosho suk pjir kjwo kjäk (7) goshko ga dl̈i beno obi tönomi shingyo kjwobi?» «Shingyo dl̈inorwa kjwo kjäk (7)» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eni ga tjl̈ẽ ba kong l̈ok ga «¿Eni ga bor tjl̈õkwo l̇l̇ë l̈okl̈o miydëmi l̇l̇ëm obire?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E irgo ga Jesús öötong shäng Betsaida kjokyo. Eshko ga domer sök kjl̈ara kjok ĩgö l̇l̇ëme. E söraba shrono l̈öng Jesús zl̈ong bäng, ga tjl̈ẽ l̈ok ba kong ga «Rokërwa bop kong ga domer ëre porwos sira, poptëp wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kuya ga domer l̈i orkwo shara, ga söra jek u l̈okshko l̈i worbo go. Öötong l̈öng eshko ga Jesús tröng twono domer l̈i bokkwo go, orkwo iara ba bokkwo kjing go, ga tjl̈ẽ ba kong ga «¿L̇l̇ëbo ĩgöpde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eshko ga kjok roĩno, ga tjl̈ẽ ga «Ĩn ga no jëk jonge. Gueniyo ga ĩgör yõtso l̇l̇ëme. E kjĩy ga nopga jëk l̈öng l̈i ĩn ga so kjor kjoyoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Eni ga Jesús orkwo iono ba bokkwo kjing go jek obi. Eshko ga bokkwo poptono, beno kjok ĩgö wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","E irgo ga Jesús tjl̈ẽ ba kong ga «Pja nom bop ushko. Pja jek äär Betsaida kjokyo guing l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","E irgo ga Jesús, ba oppinggaga, e jek l̈öng Filipo Cesarea kjokyo shto obl̈ë obl̈ë. Eshko ga jek l̈öng irbo ga Jesús tjl̈ẽ ba kong l̈ok ga «¿Kumi ga tja ë l̈ëba?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","«No kjone kjone tjl̈ẽ ga pja Juan No Waga l̈i woshrokdo l̈e. Kjone kjone tjl̈ẽ ga pja Sbö tjl̈õkwo l̈aga tek dënashko so Elías tjwayde shäng l̈e. Kjone kjone obi tjl̈ẽ ga pja Sbö tjl̈õkwo l̈agaga tek dënashko so kjl̈ara l̈i woshrokdo l̈e» l̈e l̈ok ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kuya ga tjl̈ẽ ba kong ga «E ga pjãy e, ¿tja ë l̈ëmi?» l̈e. Kuya Pedrorë ga tjl̈ẽ ba kong ga «No pjl̈uyo ichara Sbörë shrono shäng l̈i, e pja» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kuya ga tjl̈ẽ ba kong l̈ok ga «Tja ë l̈ëmi ë kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Eshko jek l̈ëkong ga Jesús tjl̈ẽ ba oppinggaga kong ga «Äär dbar kjwara ga no to ter kjok dogo dwayo ëre shdungoba ara guing. Judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, tja wl̈okjre l̈ok l̇l̇ëme. Ga tja zrökoba, gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi» l̈e eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","L̇l̇ëbo shäryëba ba kong tjwe l̈i, e l̈ara ba oppinggaga kong wẽl̈ë, miyde l̈ok wl̈o. Kuya Pedrorë ga Jesús rokara tjoksa, ga wl̈onae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Gueniyo ga Jesús bojono, ba oppinggaga l̇l̇amo beno tjeng l̈i ĩk wl̈o. Eshko ga tjl̈ẽ Pedro kong ga «¡Ä, pja opkjos bor zl̈ong dwayo! L̇l̇ëye woyde Sbörë l̈i woyotjl̈ĩp shäng l̇l̇ëme. L̇l̇ëye woyde norë l̈i woyotjl̈ĩpdë shäng eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eshko ga ba oppinggaga rokara tek ba zl̈ong bäng, nopga tjeng l̈i rokara eni bakoe. Ga tjl̈ẽ ba kong ga «Ëye jëk woydë bor tjok jl̈õkoyo ga ber shäng bor woyotjl̈ĩk ĩyado, wotjl̈ĩk l̇l̇ëbo shäryë kjok ëre kjing goshko ame bakoe. Bor kjĩshko ga l̇l̇ëye shäryëba ba kong l̇l̇ë pogoshko l̈i, e zrökoba pjang kjl̈ös go ëmdë ga e ba kong ga l̇l̇ëye l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ëye wotjl̈ĩk opdë om go, zrökoba bor kjĩshko l̇l̇ëm wl̈o l̈e ga äär kjok dogo l̇l̇ëme. Gueniyo ëye jëk bor tjok jl̈õkoyo, e zröraba bor kjĩshko, l̇l̇ëm ga Sbö tjl̈õkwo roy pjl̈ú kjĩshko ëmdë ga era ber sök së ĩyado kjok dogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ëye l̇l̇ëbo tjeng kjok ëre kjing go kës l̈i kjrara tjeng ba wl̈oy ëmdë ga e l̇l̇ëno l̇l̇ëme. Wol̈ono ga öötong kjok dogo l̇l̇ëm ga to jeno ba l̇l̇ëbo l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Shji ber l̈öng së ĩyado Sbö tjok wl̈o ga tjwl̈ẽkkl̈o kjok ëre kjing goshko drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","»Nopga l̈öng eerishko dbaryo l̈i owa, so domer orkwosmok shäng pjir, gueniyo jëk shäng wal̈ë obl̈ë tjok kjoyoe. L̇l̇ono ga no to ter kjok dogo dwayo ëre tjwe bor Data dbo kãl̈ã goshko, bor parkagaga kjok dogo so tjok. Eerishko ga ëye, tja l̈ökyokjre nopga owa bokshto ga eshko ga l̈ökyokjrër eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ga Jesús tjl̈ẽ ba kong obi ga «L̈ër bomi kong jl̈õkoyo ga pjãy kjone kjone l̈öng ëreshko wol̈ontë l̇l̇ëm obishko ga Sbö ber no pjl̈uyo dbo ara go sorë l̈i ĩmi wẽl̈ëe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Dbargwo tjer (6) irgo ga Pedro, Santiago, Juan, e söra Jesúsdë jem dboshko, dl̈up jong kjwara kjókshko l̈i go. Öötong l̈öng tjoksa eshko ga ĩna ba oppinggaga jem l̈öng ba tjok l̈irë ga Jesús kjl̈opswono, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","shwong beno pjl̈ubl̈ún shjiye. Shji shwong kwoshkwono beno pjl̈ubl̈ún stek l̈ëy wl̈eni, gueniyo äär eni l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eshko ga ĩya l̈ok ga Moisés, Elías, e weno l̈öng l̈an Jesús tjok eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Eni ga ba oppinggaga beno l̈öng kjok bangkjrë arae. Pablo, e l̇l̇ëye l̈ako ba kong wl̈o drete. Eni ëmdë ga tjl̈ẽ Jesús kong ga «Tjl̈apga no pingga, tjawa l̈öng na ga pjl̈úe. Tjawa ukwang shäryë kjwo mya, bop kong kjwara, Moisés kong kjwara, Elías kong kjwara bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","E wopro ga pjäng sho l̈ono ter kjrina ba kjing go. Ga pjäng sho l̈i roshko dwayo ga ybö kura l̈ok, tjl̈ẽ ga «Bor wa l̈i ëre. Woydër ara. Ba tjl̈õkwo kuzĩa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jekdo eshko ga ĩya l̈ok ba sor go obi ga ëye beno drete. Jesúsda beno shäng erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jer opl̈ong l̈öng dl̈up l̈i go dwayoshko ga Jesús tjl̈ẽ ba kong l̈ok ga «L̇l̇ëye ĩnomi yẽ l̈anyotkëmi ë kong l̇l̇ëm, no to ter kjok dogo dwayo ëre woshrono iröng obi guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eni ga l̇l̇ëye l̈ara l̈ok ë kong l̇l̇ëme. Gueniyo ga «No to ter kjok dogo dwayo ëre woshrono iröng obi guing» l̈ara l̈i, e l̇l̇ë l̈okl̈o l̈anyotke beno l̈öng ëng kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","E irgo ga ba oppinggaga l̈öng l̈i tjl̈ẽ l̈ok ba kong ga «No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go tjl̈ẽ l̈ok ga “Borwa pjl̈uyo iche l̈e Sbörë l̈i tjwe ber nopga uunkong pjl̈uyo wl̈o. Gueniyo ga Elías tjwe bäm go” l̈e. ¿L̈e l̈ok eni ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","«Elías tjwe bäm go jl̈õe. E tjwe l̇l̇ëbo uunkong poshäryaga. Gueniyo ga no to ter kjok dogo dwayo ëre shdungoba ara guing, ga tja wl̈okjrëba l̇l̇ëm bakoe. ¿Tak pjang Sbö tjl̈õkwo go eni bako jl̈õre? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gueniyo l̈ër bomi kong ga Elías shrono öör tjän. Ga kong l̇l̇ëbo owa shäryaraba, woydaraba sorë l̈i eni, tak pjang Sbö tjl̈õkwo go sorë l̈i eni» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús, ba oppinggaga jëk l̈öng ba tjok l̈i, e jer äär l̈öng ba oppinggaga l̇l̇amo beno tjeng l̈ishko. Ga ĩna l̈ok ga nopga töno ara eshko. E tjrëko no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go l̈öng kjl̈öbö. Epga l̈öng ëngl̈ë Jesús oppinggaga beno tjeng l̈i tjok kar kare. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús tek shäng l̈i ĩya nopga l̈öng l̈irëshko ga beno l̈öng yëy l̈e erä. Ga jek zron jong öötong l̈öng Jesús zl̈ong bäng, wl̈okjre l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Eshko ga Jesús tjl̈ẽ ba kong ga «¿Pjãy l̈öng ëngl̈ë kar kar, l̇l̇ëro?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Kuya domer kjl̈ararë ga tjl̈ẽ Jesús kong ga «Tjl̈apga no pingga, tja wa shäng kjl̈ara domer, goshko Ä sëya kjl̈ara. Iara beno shäng tjl̈ẽ l̇l̇ëme. Shaya sëya l̈irëshko ga dbukza rish buk töshko erä, ga kjamo ber bung ara, kowo uë shmẽt, ber buk kjl̈o des erä. Tek söror bop kong, poptëp wl̈o l̈oror, gueniyo tja tjwe ga pja shäng na l̇l̇ëme. Tja tjl̈ẽno bop oppinggaga beno tjeng ëreshko wl̈e kong ga “Bor wa ëre, goshko Ä sëya kjl̈ara. Rokër bomi kong ga ichozĩ to bor kong sira” l̈oror, gueniyo to ichara l̈ok l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Eni ga Jesús tjl̈ẽ ba oppinggaga l̈i kong ga «Pjãy mär Sbö go l̇l̇ëme. ¿Tja ber shäng bomi tjok kjër äär jong l̇l̇ono, pjãy mär ber l̈öng ba go wl̈o? Tja sjeno shäng bomi tjok tjän. Dwl̈as l̈i tek sös bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eni ga dwl̈as l̈i söra l̈ok tek ba zl̈ong bäng. Jesús ĩya sëya l̈irë ga dwl̈as l̈i dbukza rish buk töshko erä, ga jek workwë to buk pjuk pjuk kl̈ung kjing, kjamo bung erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Eshko ga Jesús tjl̈ẽ dwl̈as l̈i data kong ga «¿Kjwe shäryë kjweni tek l̇l̇ono tjän?» «Tek chirawa obishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Dbura iök roshko, l̇l̇ëm ga dishko, zröya wl̈o kop ara tjän. E kjĩshko ga pja dbo ara ba poptokl̈o tjok ga tjawa songe l̈ozong, tjawa kjimtozong» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kuya ga tjl̈ẽ ba kong ga «¿Tja dbo ara ba poptokl̈o tjokde, de l̇l̇ëmde l̈ëp eni ega? Ëye mär Sbö go ga l̇l̇ëye shärye ga ä wl̈o drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jekdo eshko ga domer l̈i tjl̈ẽ ga «Tja mär ba go. Gueniyo tja kjimtos mär ba go jek këgong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tjl̈ẽ l̈öng eni wopro ga nopga tjwe tön jong ara eshko. Ĩya Jesúsdë ga tjl̈ẽ sëya l̈i kong ga «Ä sëya, dwl̈as ëre iorop beno kjok kugö l̇l̇ëm, tjl̈ẽ l̇l̇ëm bakoe. L̈ër bop kong ga pja opkjos dwl̈as ëre go dwayo. Ga pja tjwe ba go ame» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kuya sëya l̈irë ga öö l̈e, ga dwl̈as l̈i dbukza rish buk töshko erä, ga opkjono toe. Eshko ga dwl̈as l̈i beno buk shinmo wl̈eni, ga no kjone kjone tjl̈ẽ ga «Kjwe shinmotkono ĩzong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eshko ga dwl̈as l̈i shara Jesúsdë ba orkwo go, ga kojonae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","E irgo ga Jesús opzrëno jek u jong kjwara roshko. Döni ga ba oppinggaga l̈öng ba tjok tjoksashko ga tjl̈ẽ l̈ok ba kong ga «¿Ä sëya l̈i to ichororwa l̇l̇ëm ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","«Ä sëya eniyo ichëmi wl̈o ga woyde ga pjãy syõshtë Sbö kong ara guing» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","E irgo ga to l̈ok eshko dwayo ga jek l̈öng uunkong Galilea kjokyo. Ba oppinggaga pĩya woydë tjoksa kuzong ga woyde ga öötong l̈öng kjone l̈i miydaga ërë l̇l̇ëme. Eni ga tjl̈ẽ ba oppinggaga kong ga «No to ter kjok dogo dwayo ëre twëba ber tjeng nopga wl̈oshko, ga tja zröya l̈ok. Gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","L̇l̇ëye l̈e shäng l̈i l̇l̇ë l̈okl̈o miydara l̈ok l̇l̇ëme. E l̇l̇ë l̈okl̈o kjakroke l̈ok woydë ba kong, gueniyo kjakrokara l̈ok l̇l̇ëm, bangkjre l̈ok ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Eshko ga Jesús opshino to jongya Capernaúm kjokyo ba oppinggaga tjok. Jek l̈öng irboshko ga ba oppingga kjl̈ara tjl̈ẽ ga «Tja ber tjwl̈õ ara, pjãy uunkong kjinmo» l̈e kjl̈ara obi kong. Kuya ga tjl̈ẽ ga «L̇l̇ëme. Ber tjwl̈õ ara l̈i tja» l̈e. Ga l̇l̇amo oml̈ë jong e kjoyo bakoe. Tjl̈ẽ jek l̈öng l̈an ëng tjok eni irgo ga jek öötong l̈öng Capernaúm kjokyo ga opzrëno jek u jong kjwara roshko. Eshko ga Jesús tjl̈ẽ ba kong l̈ok ga «¿L̇l̇ëye l̈ëmi tek l̈öng kar kar ëng kong yẽ l̇l̇ë?» l̈e. Kuya l̈ok ga beno l̈öng kjing erä. Dboryara l̈ok l̇l̇ëme. Miydara l̈ok pjl̈ú ga l̇l̇ëye l̈ara tek l̈öng ëng kong l̈i, e bëy l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eni ga Jesús wl̈oktong sök, ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i rokara tek l̈öng ba zl̈ong bäng, ga tjl̈ẽ ba kong ga «Ëye opyë woydë ber tjwl̈õ ara obl̈ë kjinmo ga woyde ga opyë ber tjwl̈õ chira, ber shäng parkaga obl̈ë kong dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eshko ga kjwozirwa kjrara Jesúsdë kjl̈ara, ga iara shäng ba tjrëko. Kjrarga tjeng ba wl̈oshko ga tjl̈ẽ ba oppinggaga kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ëye, kjwozirwa jũni wl̈okjrara bor kjĩshko ga tja wl̈okjrara wl̈eni. Ga ëye, tja wl̈okjrara ga bor ichaga wl̈okjrara wl̈eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","E irgo ga Juan tjl̈ẽ Jesús kong ga «Tjl̈apga no pingga, domer ĩnorwa shäng kjl̈ara, Ä sëyaga tjeng oba goshko l̈i iche to shäng bop ko go. Gueniyo ga e bop oppingga bi tjok l̇l̇ëm kjĩshko ga tjawa tjl̈ẽno ba kong ga “Ä sëyaga ichëp Jesús ko go ame” l̈ororwa eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kuya ga tjl̈ẽ ba oppinggaga kong ga «¡Wẽyẽ! “Shäryëp ame” l̈ëmi ba kong l̇l̇ëme. Ëye l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryë bor ko go ga tja owa l̈e jekdo ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ëye shäng bi wl̈oyo l̇l̇ëm ga shäng bi shwo l̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","L̈ër bomi kong jl̈õkoyo ga ëye, pjãy kjimtara, pjãy bor nopga kjĩshko ga pjãy sëna di erö ëmdë ga potjwl̈ẽkkl̈o tjok tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","»Ëye, kjwozirwa mär bor go jũni ichara l̇l̇ëbo owa shäryë ga e song jl̈õe. Shäryayde l̇l̇ëm obishko ga shakko, apkwo kësbang pjrikko ba bëngshko, ga dbukko jer dl̈ung dorong dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Eni ga bomi orkwo, pjãy iche l̇l̇ëbo owa shäryë wl̈eni ga zëmi tas. Pjãy opzrëk jek äär Sbö sökshko orkwo kjwara l̇l̇ëm dey ga pjl̈ú, pjãy pjë bomi orkwo pjök l̈i tjok, iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Bomi dre, pjãy iche l̇l̇ëbo owa shäryë wl̈eni ga zëmi tas. Pjãy opzrëk jek äär Sbö sökshko dre kjwara l̇l̇ëm dey ga pjl̈ú, pjãy pjë bomi dre pjök l̈i tjok, iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bomi bokkwo, pjãy iche l̇l̇ëbo owa shäryë wl̈eni ga shimi pjuse. Pjãy opzrëk jek äär Sbö sök no pjl̈uyo ĩyado l̈ishko bokkwo kjwara l̇l̇ëm dey ga pjl̈ú, pjãy pjë bomi bokkwo pjök l̈i tjok, iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kjok eshko ga shtä kjer l̇l̇ëm, ga iök sjer l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","»Shji sjëng tjokshko ga shtirgöy dl̈ungna go, an mal̈ing l̇l̇ëm wl̈o. Sbö omshäryë bi kong eni wl̈eni bakoe. L̇l̇ëbo kjang ie ber bi kong, bi poshdunggl̈o, shji ber pjl̈ú jek këgong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","»Dl̈ungna, e pjl̈úe. Gueniyo ga pjl̈ë ameshko ga iëy ber pjl̈ë ba shtoy iröng obi ga äe. Pjãy ber l̈öng dl̈ungna wl̈eni. Pjãy ber l̈öng wopjl̈ú ëng tjok ĩyado» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E irgo ga Jesús to ey dwayo, jek öötong shäng Judea kjokyo, Jordán diyo kjwo kal̈ëkong. Eshko ga nopga töno ara Jesús shäng l̈ishko obi. Sgara shäng oba ping sorë ga epga pina eshko eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eshko ga fariseoga kjone kjone tek shrono l̈öng Jesús zl̈ong bäng, ba tjl̈ĩk wl̈o. Tjl̈ẽ ba kong ga «¿Domer ba boy rayë ga pjl̈úre?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kuya ga tjl̈ẽ ba kong ga «¿Pjãy ichara Moisésdë l̇l̇ë shäryë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","«Domerga ba boy rayë wl̈o ga ichara Moisésdë kjibokwo ëng rayokl̈o twe ba boy kong kjwara guing» l̈e l̈ok ba kong ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kuya ga tjl̈ẽ ba kong l̈ok ga «L̇l̇ëye kumi woydë l̇l̇ëme. Pjãy ichara Moisésdë ëng rayë eni e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gueniyo ga dämärshko ga nopga shäryara Sbörë domer, wal̈ë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","E kjĩshko ga domer ba data, ba mekë rayë, ga orkwosmok wal̈ë tjok, ga ber l̈öng kjl̈araso wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Eni ga ber pjök ame, ber kjl̈araso shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Töna Sbörë ga e döy l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Döni ga Jesús opzrëno jek sök u roshko, ga ba oppinggaga tjl̈ẽ ba kong ga «Tjl̈apga, ¿l̇l̇ëye l̈ëp shäng yẽ, e l̇l̇ë l̈okl̈o?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","«Domer ba boy rayono, ga orkwosmono obl̈ë tjok wl̈eni ga l̇l̇ëbo owa shäryayde. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wal̈ë ba l̈anma rayono, ga orkwosmono obl̈ë tjok wl̈eni ga l̇l̇ëbo owa shäryayde bakoe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kjwozirga sökoba jek Jesús kong, Jesús orkwo ië ba kjing go wl̈o. Eni ga kjwozirga sögaga l̈i wl̈õya Jesús oppinggagarë l̈öng. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ĩya Jesúsdë ga iirkono, tjl̈ẽ ba oppinggaga kong ga «Kjwozirga somi l̇l̇ëm, tek wẽyẽ bor shwoy. Ëye ber kjwozirga jũni ga Sbö ber ba pjl̈uyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","L̈ër bomi kong jl̈õkoyo ga ëye Sbö tjl̈õkwo kjrë kjwozirwa dik l̇l̇ëm ga äär ber sök Sbö sök no pjl̈uyo ĩyado l̈ishko l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","E irgo ga kjwozirga l̈i kjrara ba wl̈oshko, orkwo iono ba kjing go, ga tjl̈õkwo l̈ara beno pjl̈ú ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús opshik to jongya kjok shto obl̈ë l̈e shäng kjwl̈ë ga domer tek zron jong, shrono shäng Jesús zl̈ong bäng ga kjök tono, tjl̈ẽ ba kong ga «Tjl̈apga no pingga, pja pjl̈úe. ¿L̇l̇ëye shäryër, tja ber sök së ĩyado Sbö tjok wl̈o?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","«¿Tja pjl̈úe l̈ëp ega? Pjl̈ú l̈i, e Sbö eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kjok l̇l̇gwekkl̈o tara Moisésdë l̈i, e miydëp tjän. Shji no zrök l̇l̇ëme. Shji pë oma boy obl̈ë tjok l̇l̇ëme. Shji l̈ũrkë l̇l̇ëme. Shji obl̈ë jyõyotkë l̇l̇ëme. Shji obl̈ë jyãpgwë l̇l̇ëme. Bop data, bop mekë, e bangkjros, ios ber tjwl̈õ ara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kuya ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, tjl̈õkwo l̈ëp shäng kës l̈i shäryër shäng enido tja tek dwl̈as l̈ë obishko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eni ga domer l̈i ĩya Jesúsdë, ga woydara ara. Tjl̈ẽ ba kong ga «L̇l̇ëbo shäryorop kës l̈i, e pjl̈úe. Gueniyo l̇l̇ëbo beno kjrina obi. Pja nom bop l̇l̇ëbo tjeng kës l̈i soynek pjir, ga dburyo twos oba song wl̈eniyo kong. Enira pja l̇l̇ëbo ara kjok dogo. Pjir ga pja tek bor tjok, pja pin wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kuya ga beno shäng woydë ara, ga to ey dwayo, dbur ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","E irgo ga ba oppinggaga ĩya Jesúsdë ga tjl̈ẽ ba kong ga «Nopga dbur ara wl̈eniyo äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko wl̈o ga kjange» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kuya l̈ok ga beno l̈öng wotjl̈ĩk arae. Eni ga Jesús tjl̈ẽ ba kong ga «Pjeyoga, ëye äär ber sök Sbö sök no pjl̈uyo ĩyado l̈ishko wl̈o ga kjange. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Öng jëkkl̈o sok kësbang wl̈eniyo opzrëk jek shkö bokkwo bäng go ga kjange. Gueniyo nopga dbur ara wl̈eniyo äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko wl̈o ga kjang anmoyõ» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kuya l̈ok ga beno l̈öng wotjl̈ĩk ara jek këgong, ga tjl̈ẽ l̈ok ba kong ga «¿Enira ëye därdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kuya ga ĩya drëng, ga tjl̈ẽ ba kong ga «Nopga kong ga shärye ga äe. Gueniyo l̇l̇ëye shärye Sbörë ga ä wl̈o drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Eshko ga Pedro tjl̈ẽ ba kong ga «Borwa l̇l̇ëbo tjeng kës l̈i rayororwa beno pjir, tjawa jëk bop tjok wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kuya ga tjl̈ẽ ba kong l̈ok ga «L̈ër bomi kong jl̈õkoyo ga ëye, ba u, ba kjl̈ara, ba data, ba mekë, ba wapga, ba kjok, e rayara bor kjĩshko, l̇l̇ëm ga Sbö tjl̈õkwo roy pjl̈ú kjrara l̈i kjĩshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ãska wl̈ẽya ara anmoyõ. Kjok ëre kjing go ga wl̈ẽya l̇l̇ëye rayara l̈i pjl̈ogl̈o sak dbäw (100) obi: u, pjeyoga, mekëga, wapga, kjok. Gueniyo ga kong l̇l̇ëbo tjwe owa bako, ĩywaba shjiktëng, ga bokrotkëba. Gueniyo l̇l̇ono ga ber sök së ĩyado Sbö tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","»Gueniyo eerishko ga nopga tjwl̈õ ara wl̈eniyo l̈öng ara l̈i, e ber l̈öng tjwl̈õ chira eshko. Ga eerishko ga nopga tjwl̈õ chira wl̈eniyo l̈öng ara l̈i, e ber l̈öng tjwl̈õ ara eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Öötong dbar kjwara ga Jesús jek shäng Jerusalén kjokyoshko ga ba oppinggaga jek l̈öng wotjl̈ĩk ara, ga oba jek l̈öng ba tjok l̈i kjok bangkjrë ara. Eshko ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i rokara Jesúsdë jek dboshko, l̈an ba tjok, l̇l̇ëye wen ba kong l̈i kjĩshko wl̈o. Eshko ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Shji to Jerusalén kjokyo. Eshko ga no to ter kjok dogo dwayo ëre twëba ber tjeng syõshtaga kägäyoga wl̈oshko, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go wl̈oshko bakoe. Tja iche l̈ok, zröya wl̈o, ga tja twe l̈ok nopga judío l̇l̇ëm wl̈eniyo kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Eshko ga tja joywe l̈ok, tröng twe l̈ok bor go, tja shpoya l̈ok no shpokkl̈o go, ga tja zröya. Gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Eshko ga Zebedeo wapga ko Santiago, Juan, e tek shrono l̈öng Jesús zl̈ong bäng ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, l̇l̇ëye rokërwa bop kong l̈i shäryos borwa kong sira» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kuya ga tjl̈ẽ ba kong ga «¿L̇l̇ëye shäryër bomi kong ga pjl̈ú?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","«Pja ber sök no pjl̈uyo, bop dbo kãl̈ã ĩkoba wẽl̈ëshko ga tjawa iëp ber l̈öng bop tjok, or mil̈ë kjl̈ara, or kël̈ë kjl̈ara» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kuya ga tjl̈ẽ ba kong ga «L̇l̇ëye rokëmi l̈öng bor kong l̈i, e l̇l̇ë miydëmi l̈öng l̇l̇ëme. ¿Pjãy shdungoba, bokrotkëba, zrökoba botoya dik ga pjl̈úre?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","«Ëng» l̈e l̈ok ba kong. Kuya ga tjl̈ẽ ba kong l̈ok ga «Pjãy shdungoba, bokrotkëba, zrökoba botoya dik jl̈õe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gueniyo ga pjãy kjrër ber tjeng bor or kël̈ë, or mil̈ë, e l̈aga tjarë l̇l̇ëm, e l̈aga bor Datarë. Shto bor or kël̈ë, or mil̈ë, e ber ëye kjrara bor Datarë tjeng l̈i kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kuya ba oppinggaga dogl̈o sak kjwara (10) l̈irë ga iirkono Santiago, Juan kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gueniyo rokara Jesúsdë uunkong, ga tjl̈ẽ ba kong ga «Miydëmi pjl̈ú ga kjok ëre kjing go ga nopga judío l̇l̇ëm wl̈eniyo ichagaga ba nopga ichë parkë ara ba kong. Nopga dbo ara wl̈eniyo ba nopga ichë parkë ara ba kong bakoe. Ëye songe l̈e l̇l̇ëm, iche parkë ara ba kong erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gueniyo woydër ga pjãy omshäryë eni l̇l̇ëme. Ëye opyë woydë ber tjwl̈õ ara obl̈ë kjinmo ga opyë ber shäng obl̈ë kjimtaga dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ëye opyë woydë ber bäm go ga opyë ber shäng parkaga tjwl̈ẽk shäng pjir wl̈eniyo obl̈ë kong dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","No to ter kjok dogo dwayo ëre ëmdë ga shrono shäng kjok ëreshko, ëye parkë bor kong wl̈o l̇l̇ëme. Tja shrono shäng parkë obl̈ë kong wl̈o. Ga tja optwë, wol̈on wl̈o, tja ber nopga ara potjwl̈ẽkkl̈o wl̈o, epga där wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","E irgo ga Jesús öötong shäng Jericó kjokyo, ba oppinggaga tjok. Ga opshino l̈öng eshko dwayo ga nopga to jek ara ba tjok. Domer sök kjl̈ara eshko kjok ĩgö l̇l̇ëm wl̈eniyo ko Bartimeo, e Timeo wa. E sök dbur rokë irbo l̈i sor go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kura ga «Jesús, Nazaret so l̈i tekdo shäng» l̈ëba. Eni ga tjl̈ẽ ba kong dbo go ga «¡Jesús, David tjëyo, tja songe l̈ozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kuya l̈öng l̈irë ga tjl̈ẽ ba kong ga «Pja kjinkozong» l̈e l̈ok ba kong, gueniyo ga kjinkë l̇l̇ëme. Tjl̈ẽno dbo go jek obi, tjl̈ẽ ga «¡David tjëyo, tja songe l̈ozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eni ga Jesús kojongö shäng, ga tjl̈ẽ l̈öng l̈i kong ga «Rokozĩ tek bor shwoy» l̈e. Ga nopga l̈i tjl̈ẽ ba kong ga «Pja kojõzong. Pja woydë l̇l̇ëme. Pja roke shäng» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kuya ga ba shwong kop l̈ëkong kur may pjang ba kjing go l̈i skwakza wl̈es, ga dbura l̈ono beno buk eshko. Ga kojono jekdo, jek öötong shäng Jesús shäng l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Eshko ga Jesús tjl̈ẽ ba kong ga «¿L̇l̇ëye woydëp ga shäryër bop kong?» «Tjl̈apga no pingga, tja kjok ĩk woydë» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kuya ga tjl̈ẽ ba kong ga «Pja to ga bue. Pja mär bor go kuzong ga pja poptonoe» l̈e. Jekdo eshko ga beno shäng kjok ĩgö wẽl̈ë, ga to jek shäng Jesús tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","E irgo ga Jesús jek shäng jongya Jerusalén kjokyo ba oppinggaga tjokshko ga öötong l̈öng Betfagé kjokyo, Betania kjokyo, e ber l̈öng Olivos dl̈upyo pogl̈o go. Eshko ga ba oppinggaga rokara do pjök, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ga tjl̈ẽ ba kong ga «Pjãy nom kjok buk bi bokshto kjweshko. Eshko ga öng so kwomgl̈a kjoyo dre töshko l̇l̇gwokl̈ë wl̈eniyo wl̈ẽmi sök kjro go kjl̈ara wl̈ënggl̈a, kjing go ëye opyoydë l̇l̇ëm wl̈eniyo. Komi, ga tek sömi bor kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eshko ga ëbo tjl̈ẽ bomi kong ga “¿Shäryëmi kjweni ega?” l̈e bomi kong wl̈eni ga “Woyde Tjl̈apgarë, ga iche tjwe mal̈ing iröng obi” l̈ëmi ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eni ga jek öötong l̈öng eshko, ga öng l̈ara l̈i wl̈ẽna sök kjro go, irbo sor go, u bäng jong kjwara zl̈ong. Ga kõya l̈öngshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ĩya nopga tjeng eshko kjl̈öbörë ga tjl̈ẽ l̈ok ba kong ga «¿Öng kjwe komi l̇l̇ëno?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kuya l̈ok ga dboryara, l̈ara Jesúsdë ba kong sorë l̈i eni. Ga nopga tjeng eshko l̈i tjl̈ẽ l̈ok ba kong ga «Jöl̈ö» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eni ga öng l̈i tek söra shrono l̈öng Jesús kong, ga ba shwong kop l̈ëkong l̈i iara l̈ok öng l̈i kokso kjing go. Eshko ga Jesús opyono sök öng l̈i kjing go, ga jeke. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Eshko ga nopga jek l̈öng ba tjok ara. Kjone kjone, ba shwong kop l̈ëkong skwara l̈ok, ga kwoptara l̈ok irbo bäng go ba bäm go. Kjone kjone, kjor korga zara, ga kwoptara l̈ok irbo bäng go eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nopga jek l̈öng ba bäm go, nopga jek l̈öng ba irgo, öö l̈e l̈ok ara. Tjl̈ẽ ga «Kjwe pjl̈ú jl̈õe. Kjwe ichara Tjl̈apgarë shrono kjok ëreshko. Kjwe kjimte Sbörë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kjwe ber sök bi pjl̈uyo, bi tjl̈apga tek dënashko so David dik. Kjwe kjimte Sbörë. Sbö sök kjok dogo, e pjl̈ú jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","E irgo ga Jesús jek opzrëno Jerusalén kjokyo roshko, ga öötong shäng Sbö u zl̈ong bäng. Eshko ga u l̈i roĩna l̇l̇aw pogoshko. Gueniyo öötong kjok sëng kuzong ga to jek Betania kjokyo iröng obi, ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wẽshko kjok shröng ga opshino to l̈ok Betania kjokyo dwayoshko ga Jesús pjl̈i ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eshko ga ĩya pjola dwayo ga kjor jong kjl̈ara korga tjok ko higuera. Eni ga jek äär shäng ba zl̈ong, bo tjokde ĩya wl̈o, gueniyo jong bo dret, korga tjok erä, eshko dbaryo ga kjor l̈i bo dbaryo äätë l̇l̇ëm obi kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eni ga tjl̈ẽ kjor jong l̈i kong ga «Ëye tjwe bop bo uë ame» l̈e, ga tjl̈õkwo l̈ara l̈i kura ba oppinggagarë l̈ok pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","E irgo ga Jesús jek opzrëno Jerusalén kjokyo, ga öötong shäng Sbö u zl̈ong bäng ga nopga l̈öng eshko l̇l̇ëbo soynek, l̇l̇ëbo tjwl̈ẽk l̈i ichara opshik ey dwayo. Ba dbur bapkwo kjl̈opswozl̈ong oba kong l̈i poskara beno tjeng töshko. Dunggwo soynega sökkl̈o l̈i poskara beno tjeng töshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Eshko ga ëye l̇l̇ëbo soynekko l̈i sök tek kal̈ëkong dwayo jek Sbö u roshko jer opl̈ong pjl̈or kal̈ëkong ga ä, sl̈ona Jesúsdë kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Eni ga oba pĩya shäng ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: “Bor u, e kowëba ber syõ uyo wl̈o, tjëyoga uunkong kong.” “Gueniyo ioromi beno jong l̈ũ uyo”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesús tjl̈õkwo l̈i kura syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë go l̈irë, ga ĩna ga nopga l̈öng ba kuga l̈i beno l̈öng yëy l̈e erä. E kjĩshko ga Jesús bangkjre l̈ok ara. Eni ga ëng töno ga tjl̈ẽ l̈ok ëng kong ga «¿Jesús, e zröy sorë ga pjl̈ú?» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kjok sëng ga Jesús opshino jek Jerusalén kjokyo dwayo, ba oppinggaga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wẽshko kjok shröng ga jek l̈öng kjor äyoshtara Jesúsdë jong l̈i soy obi. Eshko ga ĩna ga kjor l̈i bë jong dogro, dano ba sl̈eng dwayo äär jong ba dbo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Eni ga Pedro tjl̈ẽ Jesús kong ga «¡Tjl̈apga no pingga, kjor äyoshtorop kjurgue dano beno jong dogro, ĩzong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Kuya ga tjl̈ẽ ba kong ga «Pjãy mär Sbö go jl̈õkoyo. L̇l̇ëbo shärye Sbörë ga äe l̈ëmi l̇l̇ëme. Eni ga l̈ër bomi kong jl̈õkoyo ga pjãy tjl̈ẽ dl̈up kësbang ëre kong ga “Dl̈up, pja opkjos jer dl̈ung roy” l̈ëmi ga shäryë bomi kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pjãy l̇l̇ëbo rokë syõ goshko ga woyotjl̈ĩmi ga “Wl̈ẽnor beno bor kong tjän” l̈ëmi jl̈õkoyo ga wl̈ẽmi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","»Pjãy l̈öng syõshtëshko ga l̇l̇ëbo owa shäryara obl̈ërë bomi kong, e woyotjl̈ĩmi wl̈eni ga iozĩ ber tjwl̈õ l̇l̇ëme. Shäryëmi eni ga owa pjang bomi go l̈i l̈ö̃ya bomi Data sök kjok dogo l̈irë ber dret eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","E irgo ga jek opzrëno Jerusalén kjokyo obi, ga öötong l̈öng Sbö u zl̈ong bäng. Eshko ga Jesús jëk shäng wopro ga syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, e tek shrono l̈öng ba zl̈ong bäng ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tjl̈ẽ l̈ok ba kong ga «¿L̇l̇ëye shäryëp shäng l̈i shäryëp ega? ¿Pja ichaga ërë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","«Pjãy kong l̇l̇ëbo kjakrokër bakoe. ¿Juan No Waga, e ichaga ërë, no wë? ¿Ichaga Sbörëre, de norë? Tja dboryoromi ga tja ichaga ërë l̈ër bomi kong bakoe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kuya l̈ok ga tjl̈ẽ ëng kong ga «Ichaga Sbörë l̈oroy ba kong wl̈eni ga “¿Tjl̈õkwo kjroromi l̇l̇ëm ega?” l̈e bi kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Gueniyo Juan, e Sbö tjl̈õkwo l̈aga jl̈õkoyo l̈e nopga uunkongdë. E kjĩshko ga e ichaga norë l̈ëy ga ä bakoe. L̈oroy eni wl̈eni ga nopga iirkë l̈ok ara bi kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eni ga tjl̈ẽ l̈ok Jesús kong ga «Miydërwa l̇l̇ëme» l̈e. Kuya ga tjl̈ẽ ba kong l̈ok ga «E kjĩshko ga tja ichaga ërë l̈ër bomi kong l̇l̇ëm bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Eshko ga Jesús tjl̈ẽno ba kong l̈ok l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga «Domer shäng kjl̈ara kjok sogo. Pjl̈ara ga kjil̇l̇gwo dwl̈ayo dgara ba kjokshko, kjëryo tyara jong pjribri, kl̈ung kjara ber kjil̇l̇gwo bo l̇l̇ruzl̈ong shtoyo wl̈o, ga u shäryara jong kjwara ba dwl̈a l̈i dokl̈o bakoe. Pjir ga kjok l̈i poskwona parkagaga kjl̈öbö kong, potjwl̈ẽya ĩ, ga to kjok shto obl̈ë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","»Öötong kjil̇l̇gwo bo kjrozl̈ong dbaryo ga ba parkaga ichara kjl̈ara, kjil̇l̇gwo bo ber ba kong l̈i rokë parkagaga beno l̈öng ba kjok daga l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Gueniyo ga ba parkaga ichara tjwe shäng l̈i shakza l̈ok pjä, ga shpokza l̈ok tjã tjã, ga ichara to iröng or go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","E irgo ga ba parkaga ichara jek eshko kjl̈ara obi. Öötong shäng kjok buk l̈ishko ga shpokza l̈ok tjã tjã ba käshko, ga l̈ãywara l̈ok owa. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","E irgo ga ba parkaga ichara jek kjl̈ara obi. Era zröra l̈ok. E irgo ga ichara jek kjl̈öbö obi. Kjone kjone shpora l̈ok, kjone kjone zröra l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","»E irgo ga beno sök kjl̈araso döe. Ba wa l̈i e. E woyde ara wl̈eniyo. E ichayde domer l̈irë shara. Wotjl̈ĩk ga “Miydër ga bor wa ërera bangkjre l̈ok” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","»Gueniyo ga öötong shäng eshko ga parkagaga kjok dagaga l̈öng l̈i tjl̈ẽ l̈ok ëng kong ga “L̇l̇ono ga kjwe ber kjok ëre sogo. Zröroy wl̈eni ga kjok ëre kjrëy, ber buk bi kong wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eni ga shara l̈ok, zröra l̈ok, ga doyo dbura kjok l̈i roy dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","»¿Eni ga l̇l̇ëye shärye kjok sogo l̈irë ba tjok l̈ok l̈ëmi? E jongya eshko ba zrök dani. Pjir ga parkagaga wl̈ẽya obl̈ë, kjok l̈i de l̈ok ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Sbö tjl̈õkwo tak pjang eni: »“Akkwo woydara u shäryagagarë l̈ok l̇l̇ëm l̈i, e iak beno buk bäm go, beno tjwl̈õ ara, obl̈ë kjinmo. Shäryara Tjl̈apgarë eni, ga tjawa beno l̈öng yëy l̈ërwa erä.” ¿E l̈omirë l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tjl̈ẽno l̇l̇ëbo jyãgl̈o go l̈i kuya ba wl̈oyoga l̈öng l̈irë ga miydara ga ba l̈ayde shäng. Shaya l̈ok woydë, bängzaya l̈ok wl̈o. Gueniyo oba bangkjre l̈ok ara kjĩshko ga rayara l̈ok toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","E irgo ga woydara ga l̇l̇ëbo kjakroke Jesús kong, dborye bëy l̇l̇ëm ga doshaya l̈ok, ga rote l̈ok e go wl̈o. Eni ga fariseoga ichara kjl̈öbö, Herodes pjl̈oyoga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Öötong l̈öng Jesús shwoy ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, miydërwa ga pja tjl̈ẽ beke. No tjl̈ẽshko ga tjl̈õkwo kup l̇l̇ëm, tjwl̈õ kjöm pogo, e bop kong ga tjwl̈õ beke. Pja tjl̈ẽ bek ë pogo kong. Woyde Sbörë ga shji jëk sorë l̈i l̈ëp jl̈õkoyo. ¿Eni ga shji kä potjwl̈ẽk pjl̈u kësbangyo sök Roma kjokyo l̈i kong ga pjl̈úre?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kuya ga miyde ga l̈öng wotjl̈ĩk owa, nopga Sbö tjl̈õkwo söga jl̈õkoyo l̈e, gueniyo wotjl̈ĩk owa ba pjl̈úshko l̈i dik. E kjĩshko ga tjl̈ẽ ba kong l̈ok ga «¿Tja tjl̈ĩmi ega? Dburwa kä potjwl̈ẽkkl̈o l̈i tek sözĩ bor kong kjwara, ĩn wl̈o» l̈e, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ga tek söra l̈ok ba kong kjwara. Ĩya ga tjl̈ẽ ba kong ga «¿Domer jyãgl̈o sök dburwa ëre go jũ ë? ¿Ko tak pjang ëre go jũ ë?» «Kjwe pjl̈u kësbangyo sök Roma kjokyo l̈i ĩ» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kuya ga tjl̈ẽ ba kong l̈ok ga «Eni ga l̇l̇ëye pjl̈u ĩ l̈i, e twozĩ ber pjl̈u kong, gueniyo l̇l̇ëye Sbö ĩ l̈i, e twozĩ ber Sbö kong bakoe» l̈e. Kuya l̈ok ga beno l̈öng yëy l̈e erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceoga wotjl̈ĩk ga no wol̈ono ga woshrë ame l̈e. Eni ga eshko dbaryo ga saduceoga tek shrono l̈öng Jesús shwoy kjl̈öbö ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Tjl̈apga no pingga, kjibokwo tara Moisésdë beno pjang l̈i tjl̈ẽ ga “Ëye wol̈ono, wapga beno ba boy tjok l̇l̇ëm ga shinmo kjl̈arayo l̈i orkwosmok ba boy beno sök l̈i tjok, wa tjok wl̈eni ga e ber shinmo l̈i ĩ wl̈eni wl̈o.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","»Pjl̈ara ga domerga l̈öng dogl̈o kjäk (7) epenga döe. Ba këguëyo orkwosmono, ga wol̈ono, ga wapga beno l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Eni kuzong ga ba l̈ëng orkwosmono ba syã tjok, gueniyo wol̈ono jek, ga wapga beno l̇l̇ëm bakoe. Ba l̈ëmga orkwosmono ba syã tjok kjl̈ara kjl̈ara eni bako, ga wol̈ono uunkong, ga wapga beno ba boy tjok l̇l̇ëme. E irgo ga wal̈ë l̈i to wol̈ono bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Eni ga domerga dogl̈o kjäk (7) l̈i orkwosmono uunkong wal̈ë l̈i tjok kuzong ga no woshrozl̈ong dbaryoshko ga wal̈ë l̈i ber domerga kjone dey l̈i boy?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","«¡Pjãy diktong l̈öng jl̈õe! Sbö tjl̈õkwo tak pjang l̈i miydëmi l̇l̇ëm, ba dbo kësbang l̈i miydëmi l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","No woshrozl̈ong dbaryoshko ga ëye orkwosmok ame. Eshko ga nopga ber l̈öng Sbö parkagaga kjok dogo so wl̈eni shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pjãy wotjl̈ĩk ga no wol̈ono ga woshrë ame l̈ëmi. Gueniyo ga dënashko ga kji sho pjë jong ri ri l̈ishko ga l̇l̇ëye l̈ara Sbörë Moisés kong l̈i, e tara Moisésdë beno pjang kjibokwo go. Tjl̈ẽ ga “Tja Abraham, Isaac, Jacob, e Sbö.” ¿E l̈omirë l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","E shinmoga Sbö l̇l̇ëme. E nopga l̈öng së l̈i Sbö. Pjãy diktong l̈öng jl̈õe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Eshko ga domer shäng kjl̈ara, e no pingga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go. Jesús l̈ano saduceoga tjok l̈i kura, ga wotjl̈ĩk ga Jesús omdboryono beke l̈e. Eni ga tjl̈ẽ ba kong ga «¿Kjok l̇l̇gwekkl̈o tjwl̈õ kësbangyo l̈i kjone dey?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","«Tjl̈õkwo tak pjang kjwara tjl̈ẽ ga “Israel tjëyoga, tja tjl̈õkwo kuzĩa. Tjl̈apga, e bi Sbö, e kjl̈araso. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","L̇l̇ëbo woydëpshko, l̇l̇ëbo woyotjl̈ĩpshko, l̇l̇ëbo shäryëpshko, pja sök së obishko ga Tjl̈apga, bop Sbö l̈i woydos jl̈õkoyo ĩyado.” Kjok l̇l̇gwekkl̈o tjwl̈õ kësbangyo l̈i e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kjok l̇l̇gwekkl̈o kjrina obi tjwl̈õ ara. Tjl̈ẽ ga “Pja opwoydë sorë ga bop kjl̈ara, e woydos eni bakoe.” Kjok l̇l̇gwekkl̈o tak pjang tjwl̈õ ara, kjring pjök ëre kjinmo drete» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kuya ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, eni jl̈õe. Sbö, e kjl̈araso, e pjl̈or kar go obl̈ëyo dret, l̈ëp shäng sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ga l̇l̇ëbo woydëyshko, l̇l̇ëbo woyotjl̈ĩyshko, l̇l̇ëbo shäryëyshko ga woyde ga Sbö, e woydëy jl̈õkoyo ĩyado, e jl̈õe. Shji opwoydë sorë ga woyde ga bi kjl̈ara, e woydëy eni bako, e jl̈õ bakoe. Kjok l̇l̇gwekkl̈o kjring pjök ëre tjwl̈õ ara, öng l̇l̇ë, dl̈i l̇l̇ë twëy Sbö kong, suy öng sho sukkl̈o kjing go wl̈o tjeng kës l̈i kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kuya ga wotjl̈ĩk ga domer l̈i tjl̈ẽ shäng bëye l̈e. Eni ga tjl̈ẽ ba kong ga «Sbö ber bop pjl̈uyo wl̈o ga kjwe sira obi eröe» l̈e. Eshko dbaryo jek l̈ëkong ga ëye wokjang l̇l̇ëbo kjakrokë ba kong wl̈o ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ga Jesús sök oba ping Sbö u zl̈ong bäng wopro ga tjl̈ẽ oba kong ga «Tjl̈apga no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go tjl̈ẽ l̈ok ga “No pjl̈uyo iche l̈e Sbörë l̈i, e David tjëyo tek ber ba irgo l̈i” l̈e. ¿L̈e l̈ok eni ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pjl̈ara ga David go Sbö Sëyashko ga no pjl̈uyo l̈i kowara ba Tjl̈apgayo. Eshko ga David tjl̈ẽ ga »“Tjl̈apga tjl̈ẽno bor Tjl̈apgayo kong ga ‘Pja tek wl̈ar ber sök bor orkwo kël̈ëkong, äär jong bop moskwoga zanor pjir guing, eshko ga twër ber bop kong ichëp wl̈o’” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Eni ga no pjl̈uyo l̈i kowara Daviddë ba Tjl̈apgayo kuzong ga e ber ba tjëyo tek ber ba irgo l̈i sorë?» l̈e. L̇l̇ëye l̈e Jesúsdë shäng l̈i, e kukoba ga beno l̈öng woowa l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ga Jesús sök oba ping obi ga tjl̈ẽ ba kong ga «¡Pjãy sjëk, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë go l̈i tjok! Jëk l̈öng doyono shwong kur may, tjwl̈õ ara wl̈eniyo go äe. Woyde l̈ok ga bangkjrëba l̇l̇ëbo soynezl̈ong shtoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Judíoga syõ uyo roshko ga woyde l̈ok ga l̈öng sökkl̈o pjl̈ú goshko. Oba tön, iëshko ga woyde l̈ok eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Gueniyo syãpga l̇l̇ëbo döya l̈ok ba shjiryo. E irgo ga syõshtë wop ara, “Nopga kjwera pjl̈úe” l̈ëba wl̈o l̈e. E kjĩshko ga epga shdũya Sbörë ara anmoyõ, obl̈ë kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E irgo ga Jesús sök Sbö u zl̈ong bäng ga dbur bapkwo jong soy ba bokshto kjwara, ga ĩya sök ga oba tjwe dbur ië jong ba bapkwo l̈i roy. Ga nopga dbur ara wl̈eniyo omië jong bayo arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","E irgo ga syã song wl̈eniyo shrono shäng kjl̈ara eshko, ga dburwa iara kjwo pjökdewa. Ba dburwa iara l̈i, e tjwl̈õ chira anmoyõ wl̈eniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Ĩya Jesúsdë ga ba oppinggaga rokara tek ba zl̈ong bäng, ga tjl̈ẽ ba kong ga «Nopga dbur ara wl̈eniyo kjwe omiono ara wl̈eni jl̈õe. Gueniyo kjwe ba worbo wl̈eniyo iayde. Syã song wl̈eniyo kjwera, ba dburwa tjeng sira l̈i woydara ba l̇l̇ëbowa tjwl̈ẽkkl̈o. Eni ëmdë ga twara Sbö kong drete. E kjĩshko ga l̈ër bomi kong jl̈õkoyo ga syã kjwe, dburwa iara sira tjwl̈õ l̇l̇ëm wl̈eni jl̈õe. Gueniyo Sbö kong ga tjwl̈õ ara, l̇l̇amo omiono l̈ok kës wl̈e kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","E irgo ga Jesús opshino jek Sbö u jong l̈ishko dwayo, ba oppinggaga tjok. Eshko ga kjl̈ara tjl̈ẽ ba kong ga «Tjl̈apga no pingga, Sbö u ëre akyo l̈ok këskëse. U l̈ok ëre wol̈ëso ĩzong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kuya ga tjl̈ẽ ba kong ga «¿U l̈ok këskës ëre ĩp shängde? L̇l̇ono ga ëreshko akkwo ëmdë ber tjeng ëng kjing go kjwara l̇l̇ëme. L̇l̇ëbo tjeng kës ëre pjir ber drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","E irgo ga jem öötong l̈öng Olivos dl̈upyo, Sbö u jong l̈i bokshto, ga Jesús sirkeno sök eshko. Eshko ga Pedro, Santiago, Juan, Andrés, e tek shrono l̈öng ba zl̈ong bäng, tjl̈ẽ l̈ok ba kong dboshko wl̈o. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«¿L̇l̇ëye l̈ëp shäng l̈i, e shäryë l̇l̇ono? ¿E shäryë dörö l̈i jyãgl̈o wen l̇l̇ë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","«Pjãy sjëk, pjãy jyãpgwëba l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Eshko ga nopga wen tjwe ara, tjl̈ẽ ga “No pjl̈uyo ichara Sbörë shrono shäng l̈i tja” l̈e. E go ga oba jyãpgwe l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","»Roy kumi ga oba ëngkjwë kjok shto obl̈ë obl̈ë arashko ga l̇l̇ëye bangkjrëmi l̇l̇ëme. E shäryë eni kjl̈uwe. Gueniyo eshko ga kjok pjir dbaryo l̈i äätë l̇l̇ëm obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tjëyoga obl̈ë obl̈ë ëngkjwë l̈ok ëng tjok. Nopga kjok shto obl̈ë obl̈ë so ëngkjwë l̈ok ëng tjok bakoe. Kjok shto obl̈ë obl̈ë goshko ga yo tjwe ara, pjl̈i tjwe ara bakoe. Gueniyo l̇l̇ëbo wen tjwe owa anmoyõ l̈i soye l̇l̇ëbo kës ëre go kjwl̈ë jã. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","»Eshko ga pjãy sjëke. Pjãy twëba kjok l̇l̇gwegaga kong, pjãy shpoya l̈ok no shpokkl̈o go judíoga syõ uyo roshko wl̈o. Bor kjĩshko ga pjãy iche l̈ok äär l̈öng no ichagaga bokshto, pjl̈upga këskës bokshto bakoe. Eshko ga l̇l̇ëbo ĩnomi, kuromi l̈i roy l̈ëmi ba kong, miyde l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kjok pjitë l̇l̇ëm obishko ga Sbö tjl̈õkwo roy pjl̈ú äär tjëyo kjrina kjrina kong, kukoba wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ga pjãy shakoba, sökoba äär l̈öng tjl̈apgaga këskës bokshto ga pjãy woydë l̇l̇ëm, “L̇l̇ëye l̈ër” l̈ëmi l̇l̇ëme. Eshko ga pjãy tjl̈ẽshko ga tjl̈õkwo twe Sbörë bomi kong, l̈ëmi wl̈o. E kjĩshko ga pjãy woydë l̇l̇ëme. Eshko ga pjãy l̈i tjl̈ẽkdo l̇l̇ëme. Sbö Sëya l̈i tjl̈ẽkdo bomi kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","»Nopga epenga dö ëng twë tjl̈apgaga kong, zröya l̈ok wl̈o. Dataga, e ba wapga twë eni bakoe. Wapga iirkono ba data, ba mekë kong ga twe tjl̈apgaga kong, zröya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pjãy ĩywa nopga uunkongdë shjiktëng bor kjĩshko. Gueniyo ga ëye mär bor go äär jong ba dbo go ga era där ber shäng pjl̈ú ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","»L̇l̇ëbo l̈ër bomi kong miydëmi wl̈o. L̇l̇ono ga l̇l̇ëbo wen owa anmoyõ Sbö shto zrek l̈i roshko. E kjĩshko ga shto l̈i ber zrekteng ame, ga ëye äär eshko ame bakoe. Jekdo eshko ga pjãy l̈öng Judea kjokyo ga pjãy tökzong jem dl̈up l̈ëkong; ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","pjãy l̈öng bomi u dbo kjing sdok l̈i kjing go ga pjãy tökzong jek mal̈ing, pjãy opzrëk jek bomi u roshko l̇l̇ëbo kjrë l̇l̇ëme; ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","pjãy l̈öng bomi kjokshko ga pjãy jek bomi ushko iröng bomi shwong kop l̈ëkong kjrë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","E dbaryo ga wal̈ëga l̈öng kjl̈araso l̇l̇ëm, e song jl̈õe. Wal̈ëga kjwozirwa tjeng nä ië, e song jl̈õ bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rokozĩ Sbö kong ga pjãy tök eni kjok owa dbaryo l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","E dbaryo ga l̇l̇ëbo wen nopga kong owa anmoyõ. L̇l̇ëbo eni, e ĩkdaba tek kjok shäryara Sbörë dämärshko dwayo l̇l̇ëm, ga wen e kjoyo ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","L̇l̇ëbo owa ëre ie Sbörë ber dbar ara l̇l̇ëm, ba nopga kjrara l̈i woyde ara kjĩshko. Eni l̇l̇ëm kjwe ga ëye där ber sök së kjl̈ara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","»Eshko dbaryo ga no tjwe shäng tjl̈ẽ ga “¡No pjl̈uyo ichara Sbörë l̈i shäng na ĩzĩa!” l̈e, l̇l̇ëm ga tjl̈ẽ ga “¡Shäng kjwe!” l̈e bomi kong, gueniyo jl̈õ l̈ëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Eshko ga nopga ara to l̈öng tjl̈ẽ ga “No pjl̈uyo ichara Sbörë shrono shäng l̈i, e tja” l̈e. “Tja Sbö tjl̈õkwo l̈aga kjok ëre so” l̈e. Gueniyo epga ichaga Sbörë l̇l̇ëme. L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shärye l̈ok ara. L̇l̇ëbo jyãgl̈o shärye l̈ok obl̈ë obl̈ë bakoe. Shärye l̈ok eni, oba ara jyãpgwe wl̈o, Sbö nopga kjrara l̈i ëmdë jyãpgwe wl̈o l̈e, gueniyo epga jyãpgwe ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Eshko ga pjãy sjëke! L̇l̇ëye wen eshko l̈i l̈oror bomi kong pjir tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","»L̇l̇ëbo owa ëre dbaryo irgo ga »“Dl̈o ber pjang yẽt, ga mok kãl̈ã të ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dbala l̈on ter kjok dogo dwayo, ga kjopkwo ber dete erä.” ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","»Eshko ga ĩkoba ga no to ter kjok dogo dwayo ëre ter tjwe pjäng sho roy, ga bor dbo kãl̈ã ĩkoba wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bor parkagaga kjok dogo so ichër bor nopga kjrara l̈i wl̈okjrë l̈ok kjok kjwang jĩkong, kjok pjir äär kjone ga eshko, kjopkwo pjir äär kjone ga eshko bako, epga tö̃ya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","»Tja kuzĩa. Pjãy pin, kjor ko higuera l̈i go. Kjor kowo wen mite, korga wen tjagl̈ënshko ga miydëmi e go ga l̈ushko dbaryo äätoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Eni ga l̇l̇ëbo kës ëre shäryë l̈i ĩmishko ga miydëmi e go ga no to ter kjok dogo dwayo ëre tjwe iröng obi dbaryo l̈i ääto eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","L̈ër bomi kong jl̈õkoyo ga nopga l̈öng eerishko dbaryo kjone kjone wol̈ontë l̇l̇ëm obishko ga l̇l̇ëye l̈ër shäng bomi kong ëre shäryë uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kjopkwo, kjok ëre, e pjir ber drete. Gueniyo bor tjl̈õkwora ber pjang ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","»E dbaryo l̇l̇ono, kjok orë, ëye ommiydë l̇l̇ëme. Miydaga Sbö parkagaga kjok dogo sorë l̇l̇ëm, miydaga Sbö Wa ërerë l̇l̇ëm bakoe. Miydaga Data Sbörë eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","E kjĩshko ga koshëmi l̈öng sjëk ĩyado, e dbaryo wen äär l̇l̇ono miydëmi l̇l̇ëm kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tjl̈õkwo l̈ër bomi kong l̇l̇ëbo jyãgl̈o go, shäryëmi eni wl̈o. Domer shäng kjl̈ara u sogo. To opshik jek kjok shto obl̈ë wl̈o ga ba parkagaga ie ber l̈öng ba u l̈i dë. Kjl̈ara kjl̈ara kong pak twe ber obl̈ë obl̈ëe. Ga tjl̈ẽ u bäng daga l̈i kong ga “¡Pja shäng sjëke!” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eni ga u sogo tjwe iröng l̇l̇ono miydëmi l̇l̇ëm, kjok ro zar kjwl̈ëre, kjok rongde, kjörkö kjl̈unshkore, de kjok shräntore. E kjĩshko ga pjãy l̈öng sjëk ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","U sogo l̈i tjwe mal̈ing wl̈eni ga woyde ga pjãy wl̈ẽya l̈öng pë wl̈eni l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","L̇l̇ëye l̈ër bomi kong l̈i, e l̈ër nopga uunkong kong, “¡Pjãy l̈öng sjëke!”» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Eshko ga Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o, pjl̈ung shosho suk pjir shäryak ba uukkl̈o tjok l̇l̇ëm dbaryo kjwe dbar pjök obi. Eshkoshko ga syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e töno l̈ok, ga tjl̈ẽno l̈ok ëng kong ga «¿Jesús, e shay, zröy wl̈o sorë ga pjl̈ú? Shay wl̈o ga jyõyotkëy. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Gueniyo dbar shrëzl̈ong dbaryo l̇l̇ëme. L̇l̇ëm ga oba ara ga wl̈ikëba äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús jek öötong shäng Betania kjokyo, Simón ushko. Dënashko ga Simón l̈i pogl̈o go swl̈o ara, sho an do jĩkong, gueniyo poptonoe. Jesús sök Simón ushkoshko ga wal̈ë shrono shäng kjl̈ara, wl̈oshko poshtikkl̈o bapkwo tjwl̈õ ara shäryak akkwo ko alabastro go, roshko poshtikkl̈o l̈õ pjl̈ëbl̈ë tjwl̈õ ara wl̈eniyo. Eshko ga söra jek Jesús sök ië l̈ishko, ga ba bapkwo l̈i dl̈ora, ga poshtikkl̈o l̈i tyara ba dl̈u kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ĩya no kjone kjone tjeng eshko l̈irë ga iirkë jong, tjl̈ẽ l̈ok ëng kong ga «¿Kjwe zãya kjweni ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Soynena kjwe ga dburyo shaya bayo domer parkë dbargwo sak dbäw pjl̈ogl̈o mya (300) ãska wl̈eni, oba song wl̈eniyo kjimtokl̈o wl̈o dey» l̈e. Ga wal̈ë l̈i wl̈ona l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Eni ga Jesús tjl̈ẽ ba kong ga «¡Wẽyẽ! ¿Wal̈ë kjwe l̈ãywëmi kjweni egaro? L̇l̇ëye shäryara bor kong ëre beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Oba song wl̈eniyo l̈öng bomi tjok ĩyado, ga kjimtëmi, woydëmi l̇l̇ono ga eshko. Gueniyo tjara ber shäng bomi tjok ĩyado l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","L̇l̇ëye shärye bor kong ga pjl̈ú l̈i, e shäryayde bor kong. Poshtikkl̈o l̈i tyara bor doyo go, ëre bor poshäryayde, tja iëba ber buk sakshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","L̈ër bomi kong jl̈õkoyo ga kjok kjwang jĩkong kjone pogo ga Sbö tjl̈õkwo roy pjl̈ú l̈ëbashko ga l̇l̇ëye shäryara wal̈ë kjwerë bor kong ëre woyoshrëba, ga roy l̈ëba bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesús oppinggaga dogl̈o sak kjwara kjingsho pjök (12) kjl̈ara ko Judas Iscariote. E öör shäng syõshtaga kägäyoga ĩk, Jesús soyneya, twe ba kong l̈ok wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kuya l̈ok ga beno l̈öng wopjl̈ú, ga tjl̈ẽ l̈ok ba kong jl̈õkoyo ga «Enira pja potjwl̈ẽnwa» l̈e. Eshko jek l̈ëkong ga beno shäng wotjl̈ĩk ga «¿Jesús twër ba kong sorë ga pjl̈ú?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","E irgo ga pjl̈ung shosho suk pjir shäryak ba uukkl̈o tjok l̇l̇ëm dbaryo l̈i öötonge. E dbaryo ga öng wl̈ẽp ushko so l̇l̇gwokl̈ë zröya, sho suya, Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o. Eshko ga ba oppinggaga tjl̈ẽ ba kong ga «¿Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o l̈i, e dl̈iyo shäryërwa kjone ga pjl̈ú?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kuya ga tjl̈ẽ ba oppinggaga do pjök kong ga «Pjãy nom jek u l̈ok arashko. Eshko ga domer wl̈ẽmi shäng kjl̈ara, di bapkwo sök jong kjwara, roshko di. Pjãy jek ba irgo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ĩmi ga opzrëk jek u roy ga pjãy tjl̈ẽ u sogo kong ga “Tjl̈apga no pingga tjl̈ẽ ga ‘¿Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o l̈i, e dl̈iyo uër bor oppinggaga tjok l̈i kjëryo kjone?’ l̈e” l̈ëmi ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eni ga pjãy kong, kjër pĩya jong kjomo kjwara kësbang, poshäryak pjire. L̇l̇ëye uëy wl̈o l̈i shäryëmi pjir ber tjeng bäm go eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eni ga ba oppinggaga do pjök l̈i to jek öötong l̈öng u l̈ok arashko ga l̇l̇ëye l̈ara Jesúsdë ba kong l̈i wl̈ẽna tjeng eshko uunkong eni. E irgo ga dbar shrëkkl̈o l̈i dl̈iyo poshäryara l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Öötong kjok shkë ga Jesús öötong shäng eshko, ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","L̈öng ië wopro ga Jesús tjl̈ẽ ba kong ga «L̈ër bomi kong jl̈õkoyo ga pjãy l̈öng ië bor tjok kjl̈ara, tja soyneya, twe oba kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kuya l̈ok ga beno l̈öng woydë arae. Ga kjl̈ara kjl̈ara tjl̈ẽ Jesús kong ga «¿Tja l̇l̇ëm l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kuya ga tjl̈ẽ ba kong ga «Pjãy dogl̈o sak kjwara kjingsho pjök (12) kjl̈ara. Ëye sök bor tjok, ba pjl̈ung shosho suk pjir pöya sök bor tjok iokl̈o kjwaraso roy ga bor soynega l̈i e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","No to ter kjok dogo dwayo ëre wol̈on, tak pjang Sbö tjl̈õkwo go sorë l̈i eni. Gueniyo bor soynega, era song jl̈õe. Weno l̇l̇ëm kjwe ga pjl̈ú ba kong dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","L̈öng ië wopro ga pjl̈ung shosho suk pjir kjrara Jesúsdë kjwara, ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga pjl̈ung shosho l̈i tora, twara sira sira ba oppinggaga kong, ga tjl̈ẽ ba kong l̈ok ga «Kjrozĩ, ëre bor sho wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","E irgo ga di iokl̈o kjrara kjwara, roy kjil̇l̇gwo bo dyo dbo ara, ga tjl̈ẽ Sbö kong ga «Tjawa kong kjil̇l̇gwo bo dyo tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga twara ba oppinggaga kjl̈ara kjl̈ara kong, ga iara l̈ok sira sira uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ga Jesús tjl̈ẽ ba kong l̈ok ga «Ëre bor srëng wl̈eni. E go ga tjl̈õkwo twara Sbörë, beno ĩyado wl̈o l̈i, e shärye. Bor srëng l̈i kwon, nopga ara kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gueniyo l̈ër bomi kong jl̈õkoyo ga kjil̇l̇gwo bo dyo iër ame, äär jong Sbö ber no pjl̈uyo dbaryoshko jã. Eshko ga iër obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","E irgo ga tono l̈ok pjl̈ara Sbö kong, ga to jem l̈ok Olivos dl̈upyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Öötong l̈öng eshko ga Jesús tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: »“Öng daga l̈i zrör, ga öng wl̈ẽp ushko so tjeng l̈i shdär ber kjl̈oro erä.” Eni ga pjãy tjeng uunkong ëre, tja rayëmi pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Gueniyo ga tja wol̈ono, ga tja woshrara Sbörë iröng obishko ga tja äär Galilea kjokyo bomi bäm go. Pjãy koshër shäng eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kuya Pedrorë ga tjl̈ẽ ba kong ga «L̇l̇amora, pja rayara uunkong pjir ëmdë ga tjara, pja rayër l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kuya ga tjl̈ẽ ba kong ga «L̈ër bop kong jl̈õkoyo ga pjesit kjok shränto ga kjörkö kjl̈untë pjl̈ogl̈o pjök l̇l̇ëm obishko ga “Jesús, e ë miydër l̇l̇ëme” l̈orop oba kong pjl̈ogl̈o mya tjän» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Gueniyo kuya ga tjl̈ẽ ba kong obi ga «Eni l̇l̇ëme. Tja zrökoba jek bop tjok ëmdë ga “Jesús, e ë miydër l̇l̇ëme” l̈ër ë kong l̇l̇ëme» l̈e. Ba oppinggaga l̇l̇amo l̈i oml̈ono e kjoyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","E irgo ga jek öötong l̈öng Getsemaní kjokyo. Eshko ga Jesús tjl̈ẽ ba oppinggaga kong ga «Tja to syõshtë Sbö kong wopro ga pjãy wl̈ar ber tjeng na» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Eni ga jek syõshtë l̈ishko ga ba oppinggaga tjeng l̈i söra jek ba tjok dogl̈o mya, Pedro, Santiago, Juan. Jek l̈öngshko ga Jesús wosong, woydë ara ba pjl̈úshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ga tjl̈ẽ ba kong l̈ok ga «Tja woydë ara bor pjl̈úshko. Kur ga tja wol̈on kjoyoe. Pjãy ber tjeng na, ga pjãy sjëke» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Eni ga opkwono jek këgo sit, ga kjök tono sök, kjujono bokdo kjl̈ay kl̈ung go, ga rokara Sbö kong ga l̇l̇ëbo wen owa ba kong l̇l̇ëm wl̈o, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","tjl̈ẽ ga «Abba, Data, l̇l̇ëye shäryëp woydë l̈i shäryëp ga pjl̈úe. Rokër bop kong sira ga l̇l̇ëbo wen owa dörö l̈i, e tjwe bor kong l̇l̇ëm kjwe dey. Woydër eni, gueniyo ga e l̈aga tjarë l̇l̇ëme. E l̈aga ber pjarë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","E irgo ga tek shrono shäng ba oppinggaga dogl̈o mya beno tjeng l̈ishko ga wl̈ẽna bë tjeng pëe. Eni ga tjl̈ẽ Pedro kong ga «Simón, ¿pja buk përe? ¿Pja sök së wop sira ga äre?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ga tjl̈ẽ mya jĩkong l̈i kong ga «Pjãy pë l̇l̇ëm, pjãy syõshtos dey. Eni ga pjãy tjl̈ĩya Ärëshko ga pjãy kjimte Sbörë, l̇l̇ëbo owa shäryëmi l̇l̇ëm wl̈o. Pjãy l̇l̇ëbo pjl̈ú shäryë woydë jl̈õ, gueniyo pjãy womae» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","E irgo ga jek syõshtë obi. Ga tjl̈ẽno jek obi, l̈ara bäm go sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Syõshtono pjir ga tek shrono shäng iröng obi ba oppinggaga beno tjeng l̈ishko, ga wl̈ẽna bë tjeng pë obi, bokkwo l̇l̇ir woydë ëng go poywõrë kjĩshko. Eni ga to dboryara l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","E irgo go ga öör pjl̈ara obi. Shrono shäng iröng pjl̈ogl̈o mya go ga tjl̈ẽ ba oppinggaga kong ga «¿Pjãy l̈öng pë, woshtë obire? ¡Kjweni ga bue! No to ter kjok dogo dwayo ëre twëba ber tjeng nopga owa wl̈oshko l̈i dbaryo öötonge. Ĩzĩa. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bor soynega kjwe tek shäng tjän. Pjãy kojõzong. Shji to ëng dowl̈ẽk ba tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús tjl̈ẽydë pjitë l̇l̇ëm obishko ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) kjl̈ara ko Judas, e shrono shäng eshko. Nopga shrono l̈öng träk l̇l̇ëm ba tjok, kjone kjone wl̈oshko dröng, kjone kjone wl̈oshko wl̈ëng no shpokkl̈o. Epga ichaga syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyorë. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","L̈unashko ga l̇l̇gwera Judasdë nopga l̈i kong pjir tjän, Jesús, e ë miyde l̈ok wl̈o. Tjl̈ẽno ba kong ga «Ĩmi ga ëye l̈õ shir ga domer l̈i e. E shami, ga sömi, dëmi yõtso» l̈ara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Eni ga Judas jek öötong shäng Jesús zl̈ong bäng ga tjl̈ẽ ba kong ga «¡Miga, Tjl̈apga no pingga!» l̈e ba kong, ga l̈õ shira. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eni ga shakza l̈ok pjä erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Eshko ga nopga l̈öng Jesús zl̈ong bäng kjl̈ara dröng shino kjwangna, ga syõshtaga kësbangyo l̈i parkaga kwomgwo zakza tas jer l̈on pjik buk töshko erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Eshko ga Jesús tjl̈ẽ nopga l̈i kong ga «¿Pjãy tjwe bor shak dröng tjok, wl̈ëng no shpokkl̈o tjok kjweni ega? ¿Tja shamishko ga tja ëngkjwë bomi tjok l̈ëmiro? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tja öör shäng oba ping ara, Sbö u zl̈ong bäng, pjãy l̈öng l̈ishko. ¿Tja sharomi eshko l̇l̇ëm egaro? Gueniyo ëre shäryë jũni, Sbö tjl̈õkwo tak pjang l̈i ber jl̈õkoyo wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eshko ga ba oppinggaga Jesús rayono uunkong, ga töktong to l̈ok ey dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Eshko ga dwl̈as jek shäng kjl̈ara ba irgo, taywono kjingokl̈o pjl̈ubl̈ún wl̈eniyo go döe. Ĩya nopga jek tjeng Jesús söga l̈irë ga shakza l̈ok pjä l̈e, ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","miga shara l̈ok uriso, beno l̈öng ba shwong l̈i shayde erä. Eni ga opdöno jek wl̈es, ba shwong l̈ira beno tjeng nopga l̈i wl̈oshko erä. Ey ga töktong jek shäng kjl̈op drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","54","E irgo ga Jesús söra l̈ok to jongya syõshtaga kësbangyo sök l̈ishko. Pedro jek shäng kä kjwaraso kä kjwaraso ba irgo. Öötong l̈öng eshko ga opzrëno jek u l̈i roshko, ga Pedro beno sök iökkok, u bongkjako, Sbö u dagaga l̈öng l̈i tjok. Syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e töno tjeng uunkong u l̈i roshko tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Syõshtaga kägäyoga, Judío Kjok L̇l̇gwegaga Këskësyo uunkong, Jesús zröya l̈ok woydë. E kjĩshko ga nopga rokara ara töno tjeng l̈ishko, Jesús rotë wl̈o. Eshko ga nopga kojono ara, Jesús rotë wl̈o, gueniyo ba jyõyotkayde l̈ok eröe. Kjl̈ara kjl̈ara tjl̈ẽno obl̈ë obl̈ë erä. E kjĩshko ga Jesús rotokl̈o wl̈o wl̈ẽna l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","E irgo ga domerga kojono obl̈ë, ga Jesús jyõyotkara jek obi. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Kjwe kurorwa, tjl̈ẽ ga “Sbö u ëre shäryak norë, e shdör dret, ga äär dbargwo mya ga shäryër kjwara obi shäryak norë l̇l̇ëme” l̈e eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gueniyo epga tjl̈ẽno bek l̇l̇ëm, tjl̈ẽno l̈ok obl̈ë obl̈ë erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eni ga syõshtaga kësbangyo l̈i kojono nopga töno tjeng l̈i bokshto, ga tjl̈ẽ Jesús kong ga «Pja rote l̈öng ara. ¿Dboryëp l̇l̇ëmde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kuya ga beno shäng kjinge. Dboryara l̇l̇ëme. Eni ga syõshtaga kësbangyo l̈i tjl̈ẽ ba kong ga «¿No pjl̈uyo ichara Sbörë shrono shäng l̈i, e pjare? ¿Sbö poshrërwa l̈i, pja ba Ware?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kuya ga tjl̈ẽ ga «Ëng, e tja. Sbö, l̇l̇ëye shärye woydë l̈i shärye ga pjl̈úe. Ga l̇l̇ono ga no to ter kjok dogo dwayo ëre ĩmi sök ba orkwo kël̈ëkong, tja ĩmi ter tjwe kjok dogo pjäng sho tjrëko bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kuya syõshtaga kësbangyo l̈irë ga ba shwong dwl̈ëkza tjã tjã iirdë. Tjl̈ẽ ga «¿Rotaga wl̈ẽy obi l̇l̇ëno? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Domer kjwe shäng Sbö l̈ãywë owa, ber tjwl̈õ l̇l̇ëm wl̈o l̈e! E kuromi pjir tjän. ¿Kumi ga sorë?» l̈e. Kuya nopga töno tjeng uunkong l̈irë ga tjl̈ẽ ga «¡Kjwe zrökko!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eshko ga kjone kjone, Jesús go tröng twara l̈ok, bokkwo go shwomzrëng kjrochara l̈ok tuke. Eni ga yokza l̈ok pjök pjök, ga tjl̈ẽ ba kong ga «Pja yoga ërë l̈os borwa kong» l̈e. E irgo ga Sbö u dagaga omsöno, ga shpokza l̈ok pjök pjök erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","E wopro ga Pedro sök kjoko, u bongkjako. Eshko ga kjogl̈o shäng kjl̈ara, syõshtaga kësbangyo parkaga wl̈eniyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ĩya ga Pedro sök iökkok. Ga ĩya yõtso robyë wẽl̈ëshko ga tjl̈ẽ ba kong ga «¿Nopga jëk l̈öng Jesús, Nazaret so tjok l̈i kjl̈arayo pja l̇l̇ëmdo?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","«¡Jyõ! E ë miydër l̇l̇ëme. L̇l̇ëye l̈ëp shäng l̈i miydër l̇l̇ëm bakoe» l̈e ba kong. Ga jek öötong shäng kjër pjl̈or kal̈ëkong. Eshko ga kjörkö sök kjwara, ga kjl̈uno pjl̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Eshko ga ĩya kjogl̈o l̈irë jek obi ga tjl̈ẽ nopga tjeng l̈i kong ga «Kjwe ëmdë ga ba kjl̈arayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kuya Pedrorë ga tjl̈ẽ nopga l̈i kong ga «¡Jyõ!» l̈e obi. E irgo ga nopga tjeng eshko l̈i tjl̈ẽ ba kong ga «¿Pja Galilea so l̇l̇ëmdo? E kjĩshko ga miydërwa pjl̈ú ga pja ba kjl̈arayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kuya ga tjl̈ẽ ba kong ga «¡Jyõ! L̈ër bomi kong jl̈õkoyo ga domer l̈ëmi l̈öng l̈i, e ë miydër l̇l̇ëme. Eni l̇l̇ëm ga rokër Sbö kong ga tja shdũya» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jekdo eshko ga kjörkö l̈i kjl̈uno jek pjl̈ara obi, öötong pjl̈ogl̈o pjök. Eshko ga woyoshre Pedrorë kjl̈ay ga Jesús tjl̈ẽno ba kong ga «Kjörkö kjl̈untë pjl̈ogl̈o pjök l̇l̇ëm obishko ga “Jesús, e ë miydër l̇l̇ëme” l̈orop oba kong pjl̈ogl̈o mya tjän» l̈ara. Eni ga woroyë ga ä, ga sl̈atonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wẽshko kjok shröng ga syõshtaga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e töno l̈ok Judío Kjok L̇l̇gwegaga Këskësyo uunkong tjok, l̇l̇ëye shärye l̈ok Jesús tjok l̈i l̇l̇gweya l̈ok ba tjok wl̈o. L̈anyotkara l̈ok pjir ga Jesús orkwo pjrira, ga söra, twara Pilato kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Öötong l̈öng ba bokshto ga Pilato tjl̈ẽ Jesús kong ga «¿Judío pjl̈uyo l̈i pjare?» «L̈ëp sök om go l̈iro» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eshko ga Jesús rotara syõshtaga kägäyogarë, l̇l̇ëbo ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","E kjĩshko ga Pilato tjl̈ẽ Jesús kong ga «Tja kuzong. Pja rote l̈öng ara. ¿Dboryëp l̇l̇ëmde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Gueniyo dboryara l̇l̇ëme. E kjĩshko ga woyotjl̈ĩya Pilatorë beno sök arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Äär l̈u pjl̈obi go ga Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈oshko ga nopga bängzak tjeng no shdũzl̈ong uyo roshko l̈i, enido ga raye Pilatorë kjl̈ara. Rokëba ba kong ë ga e rayayde. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eshko ga domer bängzak shäng no shdũzl̈ong uyo roshko kjl̈ara ko Barrabás. Dënashko ga ba pjl̈u, e woyde l̇l̇ëme. E kjĩshko ga ëng töno obl̈ë tjok kjl̈öbö, ga ëngkjwono l̈ok pjl̈u l̈i nopga tjok, ga nopga zröra l̈ok. E kjĩshko ga bängzak shäng eshko, no zröga obl̈ë l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eni ga nopga shrono l̈öng ara ga tjl̈ẽ Pilato kong ga «Rokërwa bop kong sira ga nopga bängzak tjeng no shdũzl̈ong uyo roshko l̈i rayos kjl̈ara borwa kong, shäryëp enido sorë ga eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kuya ga tjl̈ẽ nopga l̈i kong ga «¿Woydëmi ga judío pjl̈uyo l̈ëmi l̈i dötë bomi kongde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Miydara pjl̈ú ga Jesús woydëba ara kjĩshko ga ymoyotke syõshtaga kägäyogarë ara, ga söra l̈ok ba kong e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gueniyo ga nopga tjeng eshko l̈i poshduna syõshtaga kägäyogarë arae. Tjl̈ẽ l̈ok ba kong ga «Rokozĩ ba kong ga Barrabás, e döyde bi kong dey» l̈e ba kong. Ga rokara l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Eni ga Pilato tjl̈ẽ nopga l̈i kong ga «¿Eni ga l̇l̇ëye woydëmi ga shäryër judío pjl̈uyo l̈ëmi l̈i kong?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kuya l̈ok ga tjl̈ẽno dbo go, tjl̈ẽ ga «¡Zrös pjang kjl̈ös go!» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","«¿L̇l̇ë kjĩy? L̇l̇ëbo owa shäryara l̈i l̈ozĩ bor kong» l̈e ba kong. Gueniyo ga nopga öö l̈e, tjl̈ẽ jek obi ga «¡Zrös pjang kjl̈ös go!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eni ga woydara Pilatorë ga nopga ber l̈öng wopjl̈ú ba tjok wl̈o kuzong ga Barrabás, e shira, ga rayarae. E irgo ga Jesúsda twara ëngkjwagaga kong, shpoya l̈ok no shpokkl̈o go wl̈o, zröya l̈ok pjang kjl̈ös go wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Eni ga söra l̈ok öötong shäng Pilato u bongkjako. Shto eshko, e kowëba pretorio. Ga ëngkjwagaga töno tjeng uunkong eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Eshko ga kong shwong wl̈ẽna l̈ok kara pjl̈upga shwong wl̈eniyo ko dingding shwëshwë, ga pjuna l̈ok ba do go. Ga shkö sho ywara l̈ok kjrina, beno pjl̈u dl̈u iokl̈o wl̈eni, ga iara l̈ok ba dl̈u go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eni ga tjl̈ẽ l̈ok dbo go ga «¡Judío pjl̈uyo, pja pjl̈ú, pja tjwl̈õ arae!» l̈e l̈ok ba kong, joywe l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eshko ga shpokza l̈ok ara kjorkung go ba käshko, go tröng tjwara l̈ok bakoe. E irgo ga kjök tono ba zl̈ong bäng, poshrëya l̈öng wl̈eni, miga ba joywayde l̈ok erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Joywara l̈ok pjir ga ba shwong pjang ba do go ko dingding shwëshwë l̈i skwara l̈ok, ga ba shwong baĩya l̈i pjuna l̈ok jek iröng obi. E irgo ga söra l̈ok to, zröya l̈ok pjang kjl̈ös go wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jek l̈öng irbo bäng go ga domer tek shäng kjl̈ara ko Simón, e Cirene so. E wapga domerga do pjök ko Alejandro, Rufo. Simón l̈i tek shäng kjl̈oy dwayoshko ga ĩya ëngkjwagaga jek l̈öng l̈irë ga ichara l̈ok dbo go Jesús kjl̈ös l̈i sök. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ga Jesús söra l̈ok jem öötong l̈öng kjokyo ko Gólgota. (E «No Kä Dbogl̈o dl̈upyo» l̈okl̈o.) ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eshko ga kjil̇l̇gwo bo dyo dbo ara ropsrära l̈ok dwl̈o l̈õ pjl̈ëbl̈ë tjok. Ga pina l̈ok Jesús kong ie wl̈o, gueniyo iara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","26","Öötong dl̈o wenzong ga l̈öra l̈ok pjang kjl̈ös go. Ga Jesús l̈ök pjang l̈ishko, kjibokwo iak pjang kjwara, e zröya l̈ok l̇l̇ë kjĩy miydëba wl̈o. Kjibokwo tak pjang l̈i tjl̈ẽ ga «Domer ëre, e judío pjl̈uyo.» E irgo ga ëngkjwagaga tjeng l̈i tjöto l̈ok l̇l̇ëbo jyãgl̈o go, Jesús shwong l̈i ber ë kong ĩya l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Jesús l̈öra l̈okshko ga l̈ũgwangga l̈öra l̈ok do pjök l̈ok kjl̈ös go bakoe. Kjl̈ara pjang or kël̈ë, kjl̈ara pjang or mil̈ë, kjl̈ösyo dboy dboye. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Eshko ga nopga jek l̈öng Jesús l̈ök pjangshko l̈i kä wikza tjã tjã, joywe l̈ok wl̈o. Ga l̈ãywe l̈öng owa bakoe. Tjl̈ẽ ga «¿Pja Sbö u shdök ber dret, ga äär dbargwo mya ga shäryëp ber ba shtoshko iröng obi l̈orop ga pja oto? ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pja opdös om go, pja ter opl̈õs töshko kjl̈ös kjwe go dwayo» l̈e ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e oml̈ãywono l̈ok eni bakoe. Tjl̈ẽ l̈ok ëng kong ga «Oba obl̈ëra döra, gueniyo opdök om go ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","No pjl̈uyo ichara Sbörë shrono shäng l̈i, Israel tjëyo pjl̈uyo l̈i, e pjang om go. Tjawa mär ba go wl̈o ga woyde ga opl̈ong om go jer töshko kjl̈ös kjwe go dwayo. Eni ga ĩnwa, ga jl̈õe l̈ërwa bakoe» l̈e. Nopga do pjök l̈ök l̈ok kjl̈ös go Jesús pjl̈or kar kar ëmdë ga oml̈ãywë l̈ok eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Öötong dl̈o dl̈uw ga kjok ro zoktong kjok kjwang jĩkong beno yẽt erä. Beno eni äär jong dl̈o pjö l̈ë wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dl̈o öötong eni ga Jesús tjl̈ẽno dbo go, tjl̈ẽ ga «Eloi, Eloi, ¿lama sabactani?» l̈e. (E «Bor Sbö, bor Sbö, ¿tja rayorop jũni ega?» l̈okl̈o.) ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kuya nopga tjeng eshko l̈irë ga tjl̈ẽ ëng kong ga «Kjwe kuzong. Sbö tjl̈õkwo l̈aga tek dënashko so Elías, e rokayde pjang» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eshko ga domer shäng kjl̈ara jek tji tji, ga l̇l̇ëbo l̇l̇ukl̇l̇uk di shak ara wl̈eniyo kjrara kjwara, pöra kjil̇l̇gwo bo dyo shpoä go, kjrochara kjor dbo go, ga poyona, shuya Jesúsdë wl̈o. E irgo ga tjl̈ẽ nopga tjeng eshko l̈i kong ga «Wẽyẽ. Elías tjwe ba l̈ong kjl̈ös kjwe go dwayore ĩy» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","E irgo ga ay l̈e Jesúsdë dbo go, ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sbö u roshko ga shwong kësbang iak pjang eshko l̈i dwl̈ëtong aas ter kjomo dwayo äär jong töshko, beno kjring pjök. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesús l̈ök pjang kjl̈ös go l̈i bokshto ga ëngkjwagaga l̈öng l̈i kägäyo shäng eshko. Jesús wol̈ono sorë l̈i ĩya ga tjl̈ẽ ga «Shinmo l̈ök pjang kjl̈ös go kjwe, e Sbö Wa jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Eshko ga wal̈ëga tjeng kjl̈öbö, kjupäshko ga öötong l̈öng Jerusalén kjokyo Jesús tjok. Eshko ga l̇l̇ëye shäryëba Jesús kong l̈i ĩya tjeng pjola sit. E tjrëko tjeng dogl̈o mya, kjl̈ara ko María Magdala so, kjl̈ara ko Salomé, kjl̈ara ko María. María l̈i, e Santiago mite l̈i mekë, José mekë bakoe. Jesús jëk shäng Galilea kjokyo obishko ga epga jëktong l̈öng ba tjok, ga kjimtara l̈ok däwe. Wal̈ëga obl̈ë omshäryono eni eshko bako, ga to tek ba tjok, shrono l̈öng Jerusalén kjokyo bebi. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesús wol̈ono l̈ishko ga poshäryozl̈ong dbaryo l̈i ey. Eshko ga woshtozl̈ong dbaryo l̈i dl̈oyo ääto, kjok sëng tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Eshko ga domer shäng kjl̈ara ko José. E Arimatea so, Judío Kjok L̇l̇gwegaga Këskësyo kjl̈arayo, tjwl̈õ ara wl̈eniyo. Sbö ber no pjl̈uyo dbaryo l̈i koshe sök bakoe. E opyono wokjang, jek öötong shäng Pilato shwoy, ga Jesús doyo rokara ba kong, jneya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kuya Pilatorë ga beno sök wotjl̈ĩk ga Jesús, e wol̈ono mal̈ing jl̈õre l̈e. Eni ga ëngkjwaga kägäyo l̈i rokara tek ba shwoy, ga tjl̈ẽ ba kong ga «¿Jesús wol̈ono tjände?» ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","«Ëng, wol̈ono tjän» l̈e ba kong. Eni ga José ichara Pilatorë Jesús doyo pjang l̈i kjrë, jneya buk sakshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Eni ga José shwong tjwl̈ẽno kara ko pjl̈ubl̈ún, pjl̈ú wl̈eniyo, ga jek öötong shäng shinmo l̈ök pjang kjl̈ös go l̈ishko. Eshko ga doyo l̈i l̈ona ter töshko, popgara shwong l̈i go, ga söra jek öötong sakshko. Eshko ga iara pjl̈ëbgwo kak jong guëmkwota roshko, ga ak kësbang dira beno jong ba u bäng bäng go, bängzaya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdala so, María José mekë, Jesús doyo l̈i iak buk kjone, e ĩya beno l̈öng eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Woshtozl̈ong dbaryo pjitong, öötong kjok shkë ga wal̈ëga dogl̈o mya ko María Magdala so, María Santiago mekë, Salomé, poshtikkl̈o l̈õ pjl̈ëbl̈ë tjwl̈ẽna l̈ok Jesús doyo l̈i poshtiya l̈ok wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wẽshko kjok shröng sondëshko ga jek l̈ok jongya jong sakshko, Jesús doyo iak buk l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jek l̈öng irboshko ga tjl̈ẽ l̈ok ëng kong ga «¿Ak jong ba sak bängzakkl̈o l̈i kjaga ërë bi kong dani?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Öötong l̈öng eshko ga ak kësbang l̈i wl̈ẽna l̈ok dik beno jong pjl̈ëbgwo l̈i sor go. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eni ga opzrëno jek pjl̈ëbgwo l̈i roy, ga ĩya or kël̈ëkong ga domer sök kjl̈ara mite jã, shwong ko pjl̈ubl̈ún, kur maye. Ga beno l̈öng sëya l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eshko ga domer sök eshko l̈i tjl̈ẽ ba kong l̈ok ga «L̇l̇ëye bangkjrëmi l̇l̇ëme. Jesús, Nazaret so l̈i zröraba pjang kjl̈ös go, ga wol̈onoe. Pjãy tek l̈öng ëre ba doyo wl̈ẽga. Gueniyo buk na l̇l̇ëme. ¡E woshrono iröng obi! ¡Iak buk l̈i shtoyo kjwe ĩzĩa! ¡Bukde ĩzĩa! ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ĩnomi ga pjãy nom tjl̈ẽ Pedro, Jesús oppinggaga l̇l̇amo l̈i kong ga “Jesús jek Galilea kjokyo bomi bäm go. Ĩmi eshko, l̈ara bomi kong sorë l̈i eni” l̈ëmi ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eshko ga sëya l̇l̇ëm kjĩshko ga wal̈ëga töktong to l̈ok ey dwayo, jek zron jonge. L̇l̇ëye ĩna l̈i bangkjrara l̈ok ara kuzong ga l̇l̇ëye l̈ara ë kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús woshrono iröng obi l̈i, e dbaryo sondë. E dbaryo kjok shröng ga Jesús weno shäng María Magdala so kong bäm go. Wal̈ë, e dënashko ga goshko Ä sëya dogl̈o kjäk (7), ga ichara Jesúsdë to drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Jesús weno ba kong irgo ga wal̈ë l̈i jek öötong shäng nopga jëktong Jesús tjok l̈öng l̈ishko, ga wl̈ẽya ga l̈öng woydë, sl̈ar ara. Eshko ga tjl̈ẽ ba kong ga «¡Jesús woshrono shäng së obi, ga oppino shäng bor kong!» l̈e. Gueniyo kuya l̈ok ga tjl̈õkwo kjre l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","E irgo ga Jesús oppinggaga do pjök jek jëk l̈öng irbo bäng goshko ga Jesús weno shäng ba kong eshko. Dämär ga Jesús weno María Magdala so kong sorë ga weno shäng ba kong l̈ok e kjoyo l̇l̇ëm, ĩya l̈ok ga obl̈ë shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jesús weno ba kong irgo ga jek iröng ba pjeyoga l̇l̇amo l̈öng l̈ishko. Öötong l̈öng eshko ga l̇l̇ëye ĩna l̈i l̈ara l̈ok ba kong pjire. Gueniyo kuya l̈ok ga tjl̈õkwo kjre l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","E irgo ga Jesús oppinggaga dogl̈o sak kjwara kjingsho kjl̈ara (11) l̈i l̈öng iëshko ga Jesús weno shäng ba kong eshko. Ga epga wl̈ona ara. Epga mär ba go jl̈õkoyo l̇l̇ëme. E ĩnaba shäng së l̈i roy kura, gueniyo jl̈õ l̈ara l̈ok l̇l̇ëm bakoe. Epga wl̈ona ara e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E irgo ga tjl̈ẽ ba kong l̈ok ga «Pjãy jongya kjok kjwang jĩkong, ga Sbö tjl̈õkwo roy pjl̈ú l̈ëmi nopga uunkong kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ëye tjl̈õkwo pjl̈ú l̈i kjrono, ga wono jer di roshko ga döya Sbörë. Gueniyo ëye omkjrono l̇l̇ëm ga e shdungko. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tjl̈õkwo pjl̈ú kjraga l̈i kong ga dbo twe Sbörë, ga l̇l̇ëbo jyãgl̈o shärye eni: Ä sëyaga iche oba goshko dwayo bor ko go; tjl̈ẽ tjl̈õkwo tjagl̈ën; ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","dgur shaya or goshko, dwl̈o bi zrökkl̈o ieshko ga l̇l̇ëye shäryë ba kong l̇l̇ëme; orkwo ie swl̈opga kjing goshko ga poptë eshko bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tjl̈apga Jesús tjl̈ẽno ba kong pjir ga söra Sbörë to jem kjok dogo, ga öötong sirkeno beno sök ba orkwo kël̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E irgo ga Jesús oppinggaga jëktong to kjok shto obl̈ë obl̈ë, Sbö tjl̈õkwo roy pjl̈ú l̈ë oba kong. Jek l̈öng l̈ishko ga kjimte Tjl̈apga Jesúsdë arae. Ga dbo twara ba kong, l̇l̇ëbo jyãgl̈o shärye l̈ok ara wl̈o, tjl̈õkwo l̈e l̈ok l̈i, e jl̈õe woyotjl̈ĩkoba wl̈o.");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Miga, Tjl̈apga Teófilo. L̇l̇ëbo shäryara Sbörë bi tjrëko l̈i, e tër bop kong, miydëp wl̈o. Tja omĩno l̇l̇ëm, gueniyo nopga omĩno ara ba bokkwo go, ba soyozl̈ong tek l̈ëkong. Epga beno l̈öng ba roy l̈aga. Ga roy l̈e l̈ok l̈i kuya l̈ok ga kjone kjone tjl̈ẽ ga «E jyã tëy, l̇l̇ëye ĩnaba l̈i ber wẽl̈ë wl̈o» l̈e. Ga jyã tara l̈ok beno bi kong. Ba jyã tagaga l̈i kjl̈öböso, ga tjl̈õkwo tara l̈ok l̈i beno bi kong kjibokwo obl̈ë obl̈ë go. Tjara omtë eni bakoe. Jesús roy kurorshko ga tja wotjl̈ĩno ga «¿E sorëro?» l̈oror, «Tja omkjakrokë ba miydagaga kong» l̈oror bakoe. Ga kjakrokoror shäng yõtso, eeri ga öötong l̈uyo kop arae. E kjĩshko ga tja wotjl̈ĩno ga e jyã tër ber bop kong beke. Miydëp e go wl̈o ga l̇l̇ëbo pinaba bop kong l̈i, e jl̈õe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tjl̈apga Herodes sök Judea so pjl̈uyoshko ga tjl̈apga sök kjl̈ara syõshtaga Sbö kong nopga kjĩshko wl̈eniyo ko Zacarías, e Abías tjëyo. Ba boy ko Elisabet, e Aarón tjëyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Epga pjök l̈i pjl̈o bek Sbö bokso, ba tjl̈õkwo kol̈e l̈ok ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Epga wapga l̇l̇ëm, Elisabet kjrong kjĩshko. Eshko ga epga öötong tjl̈abl̈a tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dbar kjwara ga Zacarías tjëyoga parkë Sbö kong ba u roy wl̈o dbaryo l̈i öötonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","E ba sdëkwo kjĩshko ga jyã shira l̈ok, ga l̈ono Zacarías kong, opzrëk jek Sbö u roshko, l̇l̇ëbo l̈õ pjl̈ëbl̈ë suya eshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Eni ga opzrëno jek öötong shäng ba l̇l̇ëbo l̈õ pjl̈ëbl̈ë l̈i suk. E wopro ga nopga tjeng kjoko kës l̈i beno tjeng syõshtë Sbö kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eshko ga këm kjër roshko ga Tjl̈apga parkaga kjok dogo so weno shäng Zacarías kong kjl̈ara, shäng l̇l̇ëbo l̈õ pjl̈ëbl̈ë sukkl̈o jong l̈ishko e sor go, or kël̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ĩya ga beno shäng sëya l̇l̇ëm erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Eshko ga Tjl̈apga parkaga l̈i tjl̈ẽ ba kong ga «Zacarías, l̇l̇ëye bangkjrëp l̇l̇ëme. L̇l̇ëye rokorop Sbö kong bop syõ go l̈i, e kura, ga shärye bop kong. E kjĩshko ga l̇l̇ëye bangkjrëp l̇l̇ëme. L̇l̇ono ga bop boy, e wa buk kjl̈ara domer. Bukshko ga koiëp Juan. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Eshko ga pja ber wopjl̈ú, woowa l̇l̇ëme. Nopga ara ber l̈öng wopjl̈ú eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bop wa, e ber kësbang Sbö bokso. Kjil̇l̇gwo bo dyo ie wl̈o l̇l̇ëm, ää dbo ara ie wl̈o l̇l̇ëm bakoe. Buk l̇l̇ëm obishko ga ba go Sbö Sëya tjwe ber kësbang ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","»Ba kjĩshko ga Israel tjëyoga ara wotjl̈ĩk owa wl̈eniyo, e tjwe Tjl̈apga, ba Sbö l̈i kol̈ë iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Sbö Sëya ber ba tjok kësbang, beno kësbang tjl̈apga tek dënashko so Elías tjok dik. Ga e jek shäng Tjl̈apga bäm go. Eshko ga dataga ie ber wotjl̈ĩk pjl̈ú ba wapga kong obi, nopga Sbö bangkjrë l̇l̇ëm wl̈eniyo, e ie ber ba tjl̈õkwo kol̈ë. Eni ga nopga poshärye, Tjl̈apga wl̈okjrë wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kuya ga tjl̈ẽ ba kong ga «Tja tjl̈abl̈a, bor boy, e tjl̈abl̈a bakoe. ¿Tjl̈õkwo l̈ëp shäng l̈i, e jl̈õre miydër sorë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","«Tja Gabriel. Tja parkë Sbö kong ba bokshto. Tja ichara l̈an bop tjok, chida l̈i roy pjl̈ú söga bop kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ga tja tjl̈õkwo kjrorop l̇l̇ëm kuzong ga pja ber shäng tjl̈ẽ l̇l̇ëm äär jong tjl̈õkwo l̈oror bop kong l̈i shäryono eni pjir guing» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","E wopro ga nopga beno l̈öng Zacarías koshë kjoko l̈i wotjl̈ĩk l̈ok arae. «¿Shäng wop ara oto l̈ëba? ¿Opshik Sbö u kjwe roy dwayo mal̈ing l̇l̇ëm ega?» l̈e ëng kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eshko ga opshinoshko ga tjl̈ẽ ga äe. Eni ga miydara l̈ok ga l̇l̇ëbo ĩno yoshko këm kjër roshko. Tjl̈ẽ ga ä e kjĩshko. Beno shäng tjl̈ẽ or goshko erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ga ba pak shäryë Sbö kong ba u roy wl̈o dbaryo l̈i pjitongshko ga to iröng obi ba ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","E irgo ga ba boy beno shäng kjl̈araso l̇l̇ëme. Beno sök ba ushko, opshino l̇l̇ëm öötong mogl̈o shkëng (5). Wotjl̈ĩk ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Tja wapga l̇l̇ëm kjĩshko ga tja kong wa twe Tjl̈apgarë bor kong, tja wa tjokshko ga tja l̈ëba ame wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Kjogl̈o shäng kjl̈ara ko María. E sök Nazaret kjokyo, e Galilea kjokyo obi. Domer miydoydë l̇l̇ëm obi, gueniyo tjl̈õkwo twono José kong, orkwosmok ba tjok wl̈o l̈e. José, e David tjëyo. Elisabet shäng kjl̈araso l̇l̇ëm mogl̈o tjershko (6) ga ba parkaga kjok dogo so ko Gabriel l̈i ichara Sbörë María ĩk. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eni ga Sbö parkaga l̈i tjwe shäng ba shwoy ga tjl̈ẽ ba kong ga «Miga, María. Pja woyde Tjl̈apgarë ara. Ba kong ga pja tjwl̈õ ara. E shäng bop tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kuya ga woyotjl̈ĩya beno sök ara. «¿Tjl̈õkwo l̈e shäng eni bor kong ega?» l̈e ba pjl̈úshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eshko ga Sbö parkaga l̈i tjl̈ẽ ba kong ga «María, l̇l̇ëye bangkjrëp l̇l̇ëme. Sbö ber shäng wopjl̈ú bop tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pja ber shäng kjl̈araso l̇l̇ëme. Pja wa buk kjl̈ara domer. Bukshko ga koiëp Jesús. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","E ber tjwl̈õ kësbang. E kowëba Sbö Tjwl̈õ Kësbangyo l̈i Wa. E ie Sbö Tjwl̈õ Kësbangyorë ber shäng Israel tjëyo pjl̈uyo, ba pjeyo tek dënashko so David ĩ dik, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ber Israel tjëyo pjl̈uyo ĩyado wl̈o. E ber pjl̈u dbaryo l̈i, e pjir l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kuya ga tjl̈ẽ ga «¿Tja wa tjok sorë? Tja domer miydoydë l̇l̇ëm obi.» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","«Bop go Sbö Sëya tjwe ber kësbang bop tjok, ga pja kjingue Sbö Tjwl̈õ Kësbangyo dbo l̈irë. Eshko ga pja ber shäng kjl̈araso l̇l̇ëm, l̈aga Sbörë eni. E kjĩshko ga chida buk l̈i, e iak beno buk dboy Sbö kong, e kowëba Sbö Wa bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","L̈ër bop kong kjrina obi ga bop pjeyo Elisabet, e tjl̈abl̈a tjän ëmdë ga wa buk kjl̈ara döröe. L̈ãywëba ga e wapga l̇l̇ëm wl̈eniyo l̈araba. Gueniyo shäng kjl̈araso l̇l̇ëm mogl̈o tjer (6) tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","L̇l̇ëye shärye Sbörë ga ä wl̈o drete» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kuya ga tjl̈ẽ ba kong ga «Jöl̈ö. Tja ichaga Tjl̈apgarë. Eni ga l̇l̇ëye l̈orop l̈i, e miydaga ber Sbörë» l̈e. E irgo ga Sbö parkaga l̈i toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","E irgo ga María to jek mal̈ing Elisabet ĩk. Elisabet sök Judea kjokyo dl̈up shwo l̈ëkong. E sök eshko ba l̈anma Zacarías tjok. María öötong shäng eshko, opzrëno jek ba u roshko ga «Miga» l̈e Elisabet kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kuya chida buk Elisabet roshko l̈irë ga wiktong jl̈õkoyo. Ga ba mekë go Sbö Sëya shrono beno kësbang ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","E kjĩshko ga tjl̈ẽno dbo go, tjl̈ẽ ga «María, pja kjimtara Sbörë ara, wal̈ëga uunkong kjinmo, bop chira kjimtara ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bor Tjl̈apga mekë l̈i pja. Tjara tjwl̈õ l̇l̇ëme. ¿Tja ĩp tjwe l̇l̇ë kjĩydo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bop ybö kur ga chida l̈i wiktong jekdo bor bö roshko, wopjl̈ú kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","L̇l̇ëye l̈ara Tjl̈apgarë bop kong l̈i tjl̈õkwo kjrorop. E kjĩshko ga pja ber wopjl̈úe» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kuya ga tjl̈ẽ ga «Tja bor Tjl̈apga poshrëk arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tja wopjl̈ú Sbö tjok, e bor döga. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Tja ba parkaga, tja tjwl̈õ l̇l̇ëm wl̈eniyo, gueniyo ga tja ĩna, tja miydara. L̇l̇ëbo shäryara Sbö Kjangyo l̈irë bor kong kësbange. E kjĩshko ga eeri jek l̈ëkong ga tja roy shdär nopga uunkong kong. “Wal̈ë kjwe kjimtara Sbörë kësbang jl̈õe” l̈e ĩyado. E ko Eröe. E bishĩya dik l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pja songe l̈e ba bangkjraga uunkong kong ĩyadoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","L̇l̇ëbo kësbang shärye ĩyado, e dbo ara kjĩshko. Nopga opposhrëk ä wl̈eniyo, opyë woydë ber kësbang l̈i, e shdöra kjl̈oroe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pjl̈upga këskës wl̈eniyo, e l̈ona beno tjwl̈õ ame. Nopga wl̈ẽp wl̈eniyo, e poyona beno këskëse. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nopga pjl̈i ara wl̈eniyo kong, l̇l̇ëye woyde l̈i, e twara ba kong pjire. Nopga tjeng l̇l̇ëbo ara wl̈eniyo, e ichara jek or rorëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Shji Israel tjëyoga ber l̈öng ba parkaga. Shji kjimtara. Shji songe l̈e ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","L̈ara eni jl̈õkoyo bi pjeyoga tek dënashko so kong, Abraham kong bako, ga shäryara eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ga María beno sök Elisabet tjok ba ushko mogl̈o mya dik. E irgo ga tek shrono shäng iröng obi ba ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet dbaryo öötongshko ga wa buk kjl̈ara domer. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Eshko ga ba mekë beno wopjl̈úe. Roy kura nopga tjeng ba zl̈ong bäng l̈i, ba pjeyogarë, ga beno l̈öng wopjl̈ú ba tjok eshko bakoe. Miydara l̈ok ga l̇l̇ëbo shäryara Tjl̈apgarë pjl̈ú ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Öötong dbargwo kjwongshko (8) ga chida l̈i söra l̈ok, doyo jyã te wl̈o. «Koiëy Zacarías, ba data l̈i ko» l̈ara nopga l̈öng l̈irë, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","gueniyo ga ba mekë tjl̈ẽ ga «Eni l̇l̇ëme. E ko Juan» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kuya l̈ok ga tjl̈ẽ ba kong ga «¿Eni ega? Pja pjeyo ko eni drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ga tjl̈ẽno l̈ok chida data l̈i kong or goshko, koie ber l̇l̇ë miyde l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Eshko ga ba data kjorkwang rokono kjwangna, l̇l̇ëbo jyã të e go wl̈o. Twara l̈ok ba kong ga jyã tara ga «E ko ber Juan» l̈e. Ĩya nopga uunkong l̈irë ga beno l̈öng yëy l̈e erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jekdo eshko ga chida data l̈i tjl̈ẽno jek obi, ga Sbö poshrëra arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kuya l̈ok ga yëy l̈e uunkong l̈irë. Ga l̇l̇ëbo shäryono l̈i, e l̈anyotkëba ara Judea kjokyo dl̈up shwo l̈ëkong kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kuya nopga l̈öng eshko l̈irë ga beno l̈öng wotjl̈ĩk ara uunkong. Tjl̈ẽ ëng kong ga «Jl̈õkoyo ga Tjl̈apga shäng chida l̈i tjok. ¿E kjĩshko ga e ber l̇l̇ë shäryë?» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eshko ga Zacarías go Sbö Sëya shrono beno kësbang ba tjok, ga tjl̈õkwo l̈ara Sbö Sëyarë ba kong. Kuya ga l̈ara jekdo eshko obi. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","69","«Tjl̈apga, e poshrëy ara. Shji Israel tjëyo Sbö l̈i e. E shrono, shji kjimte wl̈o, shji döya wl̈o bakoe. Bi döga ichara kjl̈ara bi kong, e kësbang, e ba parkaga tek dënashko so David l̈i tjëyo. E poshrëy träk l̇l̇ëm e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tek dënashko ga tjl̈õkwo twara beno bi kong, l̈ak ba tjl̈õkwo l̈agagarë drete. Tak pjang eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Tja tjwe ber bomi döga, bomi wl̈oyoga wl̈oshko dwayo, bomi woydaga l̇l̇ëm l̈i wl̈oshko dwayo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pjãy songe l̈ër ĩyado. Bor tjl̈õkwo tworor bomi kong beno ĩyado wl̈o l̈i woyojer l̇l̇ëme.” ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tjl̈õkwo l̈ara bi tjl̈apga Abraham kong jl̈õkoyo l̈i beno jong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Shji döya bi wl̈oyoga wl̈oshko dwayo. Eni ga l̇l̇ëye bangkjrëy l̇l̇ëm, dbar kjwobi go, shji l̈öng së obishko ga ba tjl̈õkwo l̈i söy ga pjl̈ú, pjl̈o bek, owa l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Ga pja, bor wa, pja jek Tjl̈apga tjwe l̈i bäm goshko, irbo poshäryëp shäng ba kong wl̈eni. E kjĩshko ga pja kowëba Sbö Tjwl̈õ Kësbangyo tjl̈õkwo l̈aga. Ba tjl̈õkwo l̈orop ba nopga kong l̈i go ga miyde l̈ok ga owa pjang ba go l̈i l̈öna Sbörë beno dret, ga döra l̇l̇ëbo owa shärye l̈öng l̈i dbo dorko dwayo, shdũya Sbörë ame wl̈o. L̈örop ba kong l̈i, e irbo poshäryëp shäng ba kong wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Bi Sbö, shji woyde ara, shji songe l̈e ĩyado. Miyde ga shji tjeng kjok ro sĩ roy wl̈eni, shji wol̈on l̈i, e bangkjrëy arae. Eni kuzong ga bi kong bi döga iche tjwe kjl̈ara kjok dogo dwayo, kãl̈ã shjiy dl̈o wl̈eni, dba, e ie ber bi kong tjagl̈ën wl̈eni. Dl̈o l̈i kãl̈ã të shjiy shji l̈öng l̈ishko, shji ber tjeng kjok ro sĩ roy ame wl̈o, shji wol̈on l̈i, e bangkjrëy ame wl̈o bakoe. Irbo pjl̈ú l̈i, e pĩya bi kong, shji ber l̈öng wl̈ẽp wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ga chida l̈i kun jem, ga ba wotjl̈ĩk pjl̈ú l̈i kun jem bakoe. Öötong kësbangshko ga öötong sök kjok dogro no l̇l̇ëmshko, äär jong ba dbar opping Israel tjëyoga kong, Sbö tjl̈õkwo roy l̈e ba kong wl̈o l̈i öötong guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chida l̈i buk chirawa obishko ga pjl̈u kësbangyo sök Roma kjokyo l̈i ko Augusto. Dbar kjwara ga ba parkagaga ichara jek ko kjrë kjok kjwang jĩkong, nopga tjeng kjl̈obi miyde wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","E bäm goshko ga ko kjrayde eni l̇l̇ëm, kjre eshko jã. Kjreshko ga Cirenio parkë sök Siria so ichaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eshko ga nopga uunkong jek jongya ba tjl̈apgaga tek dënashko so l̈i kjokshko iröng obi, ko twë ba ko kjragaga kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Eshkoshko ga José sök Nazaret kjokyo, e Galilea kjokyo obi. Eni ga José opshino jek ey dwayo, to jek shäng Judea kjokyo, ga öötong shäng Belén kjokyo, David weno buk l̈ishko. To shäng eshko, David, e ba tjl̈apga tek dënashko so kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Dënashko ga tjl̈õkwo twono María kong, orkwosmok ba tjok wl̈o l̈e, gueniyo eshkoshko ga orkwosmoydë ba tjok l̇l̇ëm obi. Eni ga jek shäng ko twëshko ga María jek shäng ba tjok bakoe. Eshko ga María wl̈oshko tjeng döröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","L̈öng Belén kjokyo wopro ga María chida bukshko dbaryo l̈i öötonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ga wl̈oshko wa buk kjl̈ara domer, ba wa bäm ĩyo. Ga popgara shwong chida popgokl̈o wl̈eniyo go, ga iara beno buk öng dl̈i iokl̈o bapkwo kjing go, öng tjeng l̈ishko. Söya jek no pozl̈ong uyo roy ga ä, shtoyo dret kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Eshko soshko ga öng wl̈ẽp ushko so dagaga l̈öng kjl̈öbö, ber tjeng ba öng l̈i dë ba kjokshko. Shkë ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tjl̈apga parkaga kjok dogo so weno shäng kjl̈ara ba kong eshko, Tjl̈apga dbo kãl̈ã tono l̇l̇etl̇l̇et pjribri l̈öng l̈ishko. Ĩya l̈ok ga bangkjre l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Gueniyo Tjl̈apga parkaga l̈i tjl̈ẽ ba kong ga «L̇l̇ëye bangkjrëmi l̇l̇ëme. Tja tjwe shäng l̇l̇ëbo roy pjl̈ú söga bomi kong. Kuromi ga pjãy ie ber l̈öng wopjl̈ú träk l̇l̇ëme. Kuromi ga pjãy ber wopjl̈ú l̈i, e ber nopga uunkong kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","L̈unashko ga David kjokshko ga chida buk kjl̈ara. Chida l̈i, e bomi döga. No pjl̈uyo ichara Sbörë shrono buk l̈i e. E ber bomi pjl̈uyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chida l̈i miydëmi wẽl̈ë wl̈o ga wl̈ẽmi ga popgak iak buk öng dl̈i iokl̈o bapkwo kjing go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jekdo eshko ga Sbö parkagaga kjok dogo so weno tjeng ara obi ba kjl̈ara l̈i sor go. Ga Sbö poshrëra l̈ok ara, tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Kjok dogo ga Sbö, e poshrëya l̈ok träk l̇l̇ëme. “Pja kësbange” l̈e l̈ok ba kong. Kjok ëre kjing go ga nopga woyde Sbörë ara l̈i, e ber l̈öng wopjl̈ú ëng tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","E irgo ga Sbö parkagaga l̈i to jem l̈ok kjok dogo iröng obi. E irgo ga öng dagaga l̈i tjl̈ẽ l̈ok ëng kong ga «L̇l̇ëbo roy ichara Tjl̈apgarë bi kong. Eni ga shji to ĩk Belén kjokyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eni ga jek l̈ok shëstëng, ga tjwe l̈öng ga chida l̈i wl̈ẽna bë buk öng dl̈i iokl̈o bapkwo kjing go. María, José, e wl̈ẽna l̈öng eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chida l̈i ĩna pjir ga l̇l̇ëye l̈ara Sbö parkagarë ba kong l̈i roy shdöra l̈ok nopga uunkong kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kuya l̈ok ga beno l̈öng wotjl̈ĩk arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gueniyo Maríara omkuno, ga beno sök kjing erä. Woyojeya l̇l̇ëm, söya tjeng ba pjl̈úshko erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ga öng dagaga l̈ira to iröng obi, ba öng iara beno tjeng l̈ishko. L̇l̇ëye l̈ara Sbö parkagarë ba kong l̈i ĩna l̈ok, kura l̈ok pjire. E kjĩshko ga Sbö poshrëra l̈ok ara, tjl̈ẽ ga «Sbö, pja kësbange» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Öötong dbargwo kjwongshko (8) ga chida l̈i doyo jyã tara pjire. Eshko ga koiara Jesús, ko l̈i l̈ara Sbö parkagarë María kong, e shäng kjl̈araso l̇l̇ëm l̈i l̇l̇ëm obishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Ga sopono, dbar tak pjang kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go sorë ga eni. Tjl̈apga tjl̈õkwo tak pjang eni: «Wapga domerga bäm ĩyo, e kje ber tjeng dboy Tjl̈apga kong.» E kjĩshko ga chida l̈i söra ba mekë, ba datarë jek Jerusalén kjokyo, kje ber shäng dboy Tjl̈apga kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tjl̈apga tjl̈õkwo tak pjang eni: «Dunggwo kjring pjök, dunggwo kjwo këskës wl̈eniyo, l̇l̇ëm ga dunggwo kjwo chilawa wl̈eniyo twe Tjl̈apga kong kjwo pjök.» E kjĩshko ga Tjl̈apga sënggl̈o l̈i shäryara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","E dbaryoshko ga domer sök kjl̈ara Jerusalén kjokyo ko Simeón. E domer pjl̈o bek, Sbö poshrëya shäng ara, Israel tjëyoga döga dbaryo l̈i koshe sök ĩyado, e goshko Sbö Sëya bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pjl̈ara ga Sbö Sëya tjl̈ẽ ba kong ga «Pja wol̈on l̇l̇ëm, no pjl̈uyo iche l̈e Sbörë l̈i ĩnop om go guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jesús söra ba mekë, ba datarë jek Sbö u zl̈ong bäng, l̇l̇ëye tak pjang kjok l̇l̇gwekkl̈o tara Moisésdë go l̈i shärye eni wl̈o dbaryoshko ga Simeón ichara Sbö Sëyarë jek eshko ba koshë. Öötong l̈öngshko ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","chida l̈i ĩna, ga kjrara ba wl̈oshko, ga Sbö poshrëra ara, tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","«Borwa pjl̈uyo ëre ichorop, ĩya tjëyoga l̈öng kës l̈irë wl̈o. Ëre ber iök shjiy wl̈eni, nopga judío l̇l̇ëm wl̈eniyo kong. Bop tjëyo Israel, e poshrëkoba ara ba kjĩshko. Tjl̈apga, tja bop parkaga. L̇l̇ëye l̈orop bor kong jl̈õkoyo l̈i, e shäryorop eeri. Borwa döga ëre ĩnor bor bokkwo go. E kjĩshko ga tja shinmotkë wopjl̈ú ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","L̈anyotke Simeóndë shäng eni l̈i kuya ba mekë, ba datarë ga beno l̈öng wotjl̈ĩk arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","E irgo ga tjl̈õkwo l̈ara Simeóndë beno pjl̈ú ba kong l̈ok. Ga tjl̈ẽ chida mekë María l̈i kong ga «Israel tjëyoga kong ga chida ëre, e ber shäng no kjone kjone l̈ongga, ber tjwl̈õ ame wl̈o, no kjone kjone poyongga, ber tjwl̈õ ara wl̈o bakoe. E ber shäng l̇l̇ëbo jyãgl̈o ichara Sbörë wl̈eni, ga l̈ãywëba owa ara, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","oba wotjl̈ĩk sorë ba pjl̈úshko l̈i ĩgöy wẽl̈ë wl̈o. Gueniyo l̇l̇ono ga ba kjĩshko ga pja ber woydë ara, pja shorkera sögl̈orë wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Eshko wal̈ë shäng kjl̈ara ko Ana, e Sbö tjl̈õkwo l̈aga. Ba data ko Fanuel, e Aser tjëyo. Ana, e tjl̈abl̈ae. Mite obishko ga orkwosmono, ga beno sök ba l̈anma tjok l̈u pjl̈ogl̈o kjäk (7). ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","E irgo ga ba l̈anma shinmotkono, ga beno sök syã. Eshko ga öötong sök l̈u pjl̈ogl̈o sak kjwong kjingsho pkëng (84). Beno sök Sbö u zl̈ong bäng Sbö poshrëk shkë dba, opshik l̇l̇aw l̇l̇ëme. Syõshtë Sbö kong ara, ga ië l̇l̇ëm Sbö kong dbar kop ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Eshko ga tek shrono shäng chida buk l̈i zl̈ong bäng. Ĩya ga beno shäng wopjl̈úe. Ga tjl̈ẽ ga «Sbö, chida ëre ichorop borwa pjl̈uyo. E kjĩshko ga tja wopjl̈ú bop tjok» l̈e. Eshko Jerusalén kjokyo ga nopga tjeng ara ba pjl̈uyo tjwe dbaryo l̈i koshë. Ga chida l̈i roy l̈ara ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tjl̈õkwo tak pjang Tjl̈apga kjok l̇l̇gwekkl̈o go shärye wl̈o l̈i shäryara l̈ok pjirshko ga chida l̈i söra José, Maríarë to jek iröng obi Galilea kjokyo, ga öötong l̈öng ba kjokshko Nazaret kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eshko ga Jesús kun jem, beno dbo ara, kjok miydë ara bakoe. Ga kjimte Sbörë arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","L̈u pjl̈obi go ga ba data, ba mekë, e jek l̈ok Jerusalén kjokyo, Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëk wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ga Jesús öötong l̈u pjl̈ogl̈o sak kjwara kjingsho pjökshko (12) ga jek dbar l̈i shrëk ba tjok bebi, sgara judíogarë sorë ga eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Dbar l̈i shrëra l̈ok pjir ga ba data, ba mekë, e tek l̈öng iröng obi, ga nopga jek l̈öng ara ba tjok. Jesús l̈ira tek shäng ba tjokdo l̈ara l̈ok, miga l̇l̇ëm, beno shäng Jerusalén kjokyo. Jëktong l̈ok dbar kjwarashko ga wl̈ẽya l̈ok ba pjeyoga tjrëko, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","gueniyo wl̈ẽna l̇l̇ëme. Eni ga sano jek iröng obi Jerusalén kjokyo, wl̈ẽya l̈ok eshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kjö̃shko ga wl̈ẽna l̈ok bë sök Sbö u zl̈ong bäng, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë go l̈i tjrëko. E sök ba tjl̈õkwo l̈e l̈ok l̈i kuk, ga omkjakrokë jong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kuya nopga l̈öng l̈irë l̈ok ga Jesús kjok miydë ara, l̇l̇ëbo kjakroke kjöme l̈i dboryara pjl̈úe. E kjĩshko ga yëy l̈e l̈ok erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ĩya ba mekë, ba datarë äär eshko ga ba wa sök nopga l̈i tjrëko ga yëy l̈e erä. Eshko ga ba mekë tjl̈ẽ ba kong ga «Jesús, ¿pja opshäryë borwa kong kjweni ega? Tja, bop data, tjawa to l̈öng bop wl̈ẽk. Tjawa woydë ara bop kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kuya ga tjl̈ẽ ba kong ga «¿Tja wl̈ẽmi l̈öng ega? ¿Tja sök bor Data ushko, e miydëmi l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Gueniyo tjl̈õkwo l̈ara l̈i l̇l̇ë l̈okl̈o miydara l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","E irgo ga tek shrono shäng iröng obi ba tjok ba ushko Nazaret kjokyo. Ga kuno sök ba mekë, ba data tjok. L̇l̇ëye l̈ara l̈ok ba kong kës l̈i söya eni. Ba mekëra, l̇l̇ëye shäryara l̈i woyojeya l̇l̇ëm, söya tjeng ba pjl̈úshko erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ga Jesús kun jeme. Ba kjok miydë l̈i kun jem bakoe. «Jesús kjwe pjl̈úe» l̈e Sbörë, l̈e nopgarë eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio sök pjl̈u kësbangyo öötong l̈u pjl̈ogl̈o sak kjwara kjingsho shkëngshko (15) ga Poncio Pilato sök Judea so ichaga, Herodes sök Galilea so pjl̈uyo, ba shjiy Felipe sök Iturea so pjl̈uyo, Traconite so pjl̈uyo bako, Lisanias sök Abilene so pjl̈uyo, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás, Caifás, e l̈öng syõshtaga Sbö kong nopga kjĩshko këskësyo. Eshkoshko ga Juan, Zacarías wa l̈i sök kjok dogro no l̇l̇ëmshko. Eshko ga tjl̈õkwo l̈ara Sbörë Juan kong, l̈e oba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eni ga to jek shäng kjok buk kës Jordán diyo sor go, tjl̈ẽ oba kong ga «L̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈ozĩ, ga rayozĩ, ga pjãy wër jer di roshko. Shäryoromi eni ga owa pjang bomi go l̈i l̈ö̃ya Sbörë ber drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Shäryono eni, tara Sbö tjl̈õkwo l̈aga tek dënashko so Isaíasdë sorë l̈i eni. Tjl̈ẽno beno eni: «Kjok dogro no l̇l̇ëmshko ga ëbo tjl̈ẽ shäng dbo go ga “Irbo poshäryozĩ Tjl̈apga tjwe l̈i kong. Shäryozĩ ber beke. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dipkwo uunkong l̈i, e kl̈ungyo dl̈ingko, kjing ber bek wl̈o. Dl̈up këskës, chilawa l̈i, e l̈öngko, kjing ber bek wl̈o. Irbo sjöng l̈i, e l̇l̇gwekko, ber pjl̈o bek wl̈o. Irbo pjl̈ëbgwoyo ara l̈i, e kjingako, ber kjing bek wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ga no pjl̈uyo iche Sbörë no döya wl̈o l̈i, e ĩya nopga tjeng kjok kjwang jĩkong l̈irë” l̈e.» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Eni ga nopga tjwe jong Juan shwoy ara, we jer di roshko wl̈o. Ga Juan tjl̈ẽ ba kong ga «¡Pjãy so dgur kjoyoe! ¿Nopga owa shdũzl̈ong dbaryo dörö l̈ishko ga pjãy där l̈aga ërë bomi kongdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pjãy jëk pjl̈o beke. Miydëba e go ga l̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈oromi, ga rayoromi jl̈õkoyo. L̈ër bomi kong ga akkwo ëre ëmdë shärye Sbörë ber Abraham tjëyoga ga pjl̈úe. E kjĩshko ga “Tjawa Abraham tjëyoga kjĩshko ga tjawa shdũya Sbörë l̇l̇ëme” l̈ëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Zër e” l̈e Sbörë shäng. Kjor botjyë pjl̈ú l̇l̇ëm wl̈eniyo tjeng kës l̈i ze jek tas, dbuya iök roy, suya wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kuya l̈ok ga tjl̈ẽ ba kong ga «¿Eni ga l̇l̇ëye shäryërwa?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","«Ëye shwong ko pjök ga twe kara ëye shwong l̇l̇ëm l̈i kong, ëye dl̈i tjok ga shdöya, twe ëye dl̈i l̇l̇ëm l̈i kong» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nopga dbur töngga Roma so kong l̈i shrono l̈öng eshko, we wl̈o bakoe. Epga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, ¿l̇l̇ëye shäryërwa?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","«Pjãy ichara bomi kägäyorë dbur töng bayo kjöme l̈i, e shimirë erö, shimi e kjinmo l̇l̇ëme» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ëngkjwagaga l̈öng eshko l̈i tjl̈ẽ ba kong ga «¿Tjawa orwë l̇l̇ong?» «L̇l̇ëye dömi obl̈ë shjiryo l̇l̇ëme. L̇l̇ëye dömi dbo go l̇l̇ëm, jyõyotkëmi ĩ l̇l̇ëm bakoe. Pjãy tjwl̈ẽkoba kjöme ga pjãy ber l̈öng wl̈ẽp ba tjok» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Eshko ga nopga beno l̈öng wopjl̈ú anmoyõ, ga wotjl̈ĩk l̈ok ga «¿No pjl̈uyo ichara Sbörë shrono shäng l̈i, e Juan kjwe l̈ëpde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","E kjĩshko ga Juan tjl̈ẽ ba kong ga «Pjãy wër shäng di goshko. Gueniyo no tjwe bor irgo kjl̈ara. Bek wl̈o ga tja ba drepkwota dök wl̈o l̇l̇ëm, e tjwl̈õ ara bor kjinmo anmoyõ kjĩshko. Era, pjãy we iök go, ga pjãy go Sbö Sëya iche tjwe ber kësbang bomi tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tjwe kjwl̈ë tjok, dwl̈a pjl̈oyong wl̈o wl̈eni. Dwl̈a pokeshko ga dwl̈a bo tö̃ya ber tjeng ba bapkwo roy. Gueniyo ba kasho l̈ira suya iök roy. Iök l̈i pjë jong ri ri ĩyado, sjer l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Eni ga nopga poshduna Juandë tjl̈õkwo obl̈ë obl̈ë go ara, ga Sbö tjl̈õkwo roy pjl̈ú l̈ara ba kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Eshkoshko ga Pjl̈u Herodes, ba shjiy boy l̈i kjrara beno sök ba boy. L̇l̇ëbo owa shäryara obl̈ë ara bakoe. E kjĩshko ga wl̈ona Juandë ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Gueniyo Juan kol̈ara l̇l̇ëm, l̇l̇ëbo owa shäryara jek këgong, Juan iara beno shäng no shdũzl̈ong uyo roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Iayde shäng no shdũzl̈ong uyo roy l̇l̇ëm obishko ga Juan shäng oba wë ara. Pjl̈ara ga Jesús jek öötong shäng eshko, ga wara Juandë jer di roshko. Wara pjir ga Jesús shäng syõshtë Sbö kong wopro ga kjok dogo roshwino beno oojong erä, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ga Sbö Sëya to ter kjok dogo dwayo so dunggwo kjoyo, ga opyono sök ba go, ĩkoba ga wẽl̈ëe. Eshko ga ybö kuraba ter kjok dogo dwayo, tjl̈ẽ ga «Bor wa l̈i pja. Pja woydër ara. Tja wopjl̈ú bop tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ga Jesús l̈u pjl̈ogl̈o sak myashko (30) ga ba pak soyarae. Jesús, e José wa l̈ëba. José, e Elí wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí, e Matat wa. Matat, e Leví wa. Leví, e Melquí wa. Melquí, e Jana wa. Jana, e José wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José, e Matatías wa. Matatías, e Amós wa. Amós, e Nahúm wa. Nahúm, e Esli wa. Esli, e Nagai wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, e Maat wa. Maat, e Matatías wa. Matatías, e Semei wa. Semei, e José wa. José, e Judá wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá, e Joanán wa. Joanán, e Resa wa. Resa, e Zorobabel wa. Zorobabel, e Salatiel wa. Salatiel, e Neri wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, e Melquí wa. Melquí, e Adi wa. Adi, e Cosam wa. Cosam, e Elmodam wa. Elmodam, e Er wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, e Josué wa. Josué, e Eliézer wa. Eliézer, e Jorim wa. Jorim, e Matat wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat, e Leví wa. Leví, e Simeón wa. Simeón, e Judá wa. Judá, e José wa. José, e Jonán wa. Jonán, e Eliaquim wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim, e Melea wa. Melea, e Mainán wa. Mainán, e Matata wa. Matata, Natán wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán, e David wa. David, e Isaí wa. Isaí, e Obed wa. Obed, e Booz wa. Booz, e Salmón wa. Salmón, e Naasón wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón, e Aminadab wa. Aminadab, e Aram wa. Aram, e Esrom wa. Esrom, e Fares wa. Fares, e Judá wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá, e Jacob wa. Jacob, e Isaac wa. Isaac, e Abraham wa. Abraham, e Taré wa. Taré, e Najor wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Najor, e Serug wa. Serug, e Ragau wa. Ragau, e Péleg wa. Péleg, e Heber wa. Heber, e Selaj wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selaj, e Cainán wa. Cainán, e Arfaxad wa. Arfaxad, e Sem wa. Sem, e Noé wa. Noé, e Lamec wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec, e Matusalén wa. Matusalén, e Enoc wa. Enoc, e Jared wa. Jared, e Malalel wa. Malalel, e Cainán wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán, e Enós wa. Enós, e Set wa. Set, e Adán wa. Adán, e Sbö wa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Eshko ga Jesús go Sbö Sëya jl̈õkoyo. Eni ga tjwe iröng Jordán diyo dwayoshko ga söra Sbö Sëyarë jek öötong shäng kjok dogro no l̇l̇ëmshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Eshko ga tjl̈ĩna Ärë shäng dbargwo sak pkëng (40), l̇l̇ëbo owa shäryë wl̈o l̈e. Dbar eshko ga Jesús iono l̇l̇ëme. E irgo ga pjl̈i jonge. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Eni ga Ä tjl̈ẽ ba kong ga «Pja Sbö Wa jl̈õkoyo ga akkwo ëre posgos ber pjl̈ung shosho suk pjir, uëp wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kuya ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: “No mär dl̈i go dö l̇l̇ëme”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","E irgo ga söra Ärë jem öötong shäng dl̈up jong kjókshko dbo go, ga kjok kjwang jĩkong kjrina kjrina l̈i pina ba kong uunkong jekdo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Eshko ga tjl̈ẽ ba kong ga «Pja kjök tok, tja poshrëp wl̈eni ga kjok uunkong ëre twër ber bop kong. Ba l̇l̇ëbo wol̈ësowa tjeng kës kjwe, ba dbo ara, e ber bopoya, ga pja ber ba ichaga. E twak beno bor kong uunkong, ga twër woydë ë kong ga twër» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kuya ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: “Tjl̈apga, bop Sbö l̈i poshrëmirë döe. E kol̈omirë döe”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","E irgo ga söra Ärë jek öötong shäng Jerusalén kjokyo, Sbö u kësbang jong l̈ishko. Eshko ga söra jem öötong shäng Sbö u dbo go, ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni: »“Ba parkagaga kjok dogo so iche Sbörë bop dë, pja shaya ba orkwo go, pja dre pjë akkwo go l̇l̇ëm wl̈o.” E kjĩshko ga pja Sbö Wa jl̈õkoyo ga pja optos jer na dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kuya ga tjl̈ẽ ba kong ga «Sbö tjl̈õkwo tak pjang eni bakoe: »“Tjl̈apga, bop Sbö l̈i tjl̈ĩy l̇l̇ëme”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tjl̈ĩna Ärë pjir ga rayara to ey dwayo. Ga barwara ame äär jong l̇l̇ono jã. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","E irgo ga Jesús to jek Galilea kjokyo iröng obi. Jëk shäng Sbö Sëya dbo ara l̈i tjok. Ga e roy shdöktong kjok eshko kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kjok kjrina kjrina ga oba pĩya judíoga syõ uyo roshko, ga poshrëkoba uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pjl̈ara ga Jesús jek öötong shäng Nazaret kjokyo, kuno shäng l̈ishko. Ga öötong woshtozl̈ong dbaryo ga opzrëno jek shäng judíoga syõ uyo jong eshko l̈i roy. Eshko ga kojono shäng, Sbö tjl̈õkwo l̈ë nopga tjeng l̈i kong wl̈o, sgara shäng enido sorë ga eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ga kjibokwo tara Sbö tjl̈õkwo l̈aga tek dënashko so Isaíasdë l̈i twara tjeng ba kong. Eshko ga kjibokwo l̈i koshwina, ga l̈ara nopga l̈i kong. Tjl̈õkwo tak pjang l̈ara l̈i tjl̈ẽ eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Tja kjrara Tjl̈apga Sëyarë, ba tjl̈õkwo roy pjl̈ú l̈ë oba song wl̈eniyo kong wl̈o. E kjĩshko ga Tjl̈apga Sëya pjang bor go. Tja ichara tjl̈ẽ nopga shdung l̈öng l̈i kong ga “Pjãy där mal̈inge”, tjl̈ẽ nopga kjok ĩgö l̇l̇ëm l̈i kong ga “Pjãy kjok ĩk shara”, tjl̈ẽ nopga bokrotkëba ara l̈i kong ga “Pjãy bokrotkëba ame”, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tjl̈ẽ nopga uunkong kong ga “Sbö nopga där dbaryo l̈i öötonge.”» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","E irgo ga kjibokwo l̈i l̇l̇ira, twara iröng ba kjimtaga parkë shäng judíoga syõ uyo roy l̈i kong, ga sirkeno sök eshko. Eshko ga ĩya nopga l̈öng l̈irë beno l̈öng drëng erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Eni ga Jesús tjl̈ẽ ba kong ga «Sbö tjl̈õkwo ëre kuromi l̈i, e shäryono eeri» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tjl̈ẽ shäng ga ba kugaga l̈öng l̈i tjl̈ẽ ëng kong ga «Kjwe pjl̈úe. Ba tjl̈õkwo l̈e l̈i, e wol̈ësowa» l̈e, ga beno l̈öng yëy l̈e erä. Ga tjl̈ẽ ëng kong ga «¿Domer kjwe José wa l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kuya Jesúsdë ga tjl̈ẽ ba kong ga «L̇l̇ëye l̈ëmi woydë bor kong l̈i, e miydoror pjir tjän. ¿No dwl̈omnega shäng kjl̈ara swl̈o ara ga shji tjl̈ẽ ba kong ga “Pja no dwl̈omnek pjl̈úra pja opdwl̈omnes om goshko” l̈ëy eni l̇l̇ëmdo? Eni ga “Pja no dwl̈omnek pjl̈úra nopga tjeng bop kjok ëreshko dwl̈omnezong” l̈ëmi woydë bor kong eni. “Capernaúm kjokyoshko ga l̇l̇ëbo shäryorop obl̈ë obl̈ë ara l̈i roy kurorwa pjire. Eni ga bop kjok ëreshko ga shäryos eni bakoe” l̈ëmi woydë bor kong eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","L̈ër bomi kong jl̈õkoyo ga Sbö tjl̈õkwo l̈aga, e iëba tjwl̈õ ara ba kjok om go l̈ishko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","L̈ër bomi kong jl̈õkoyo ga Sbö tjl̈õkwo l̈aga Elías dbaryoshko ga shunyo shrono l̇l̇ëm l̈u pjl̈ogl̈o mya kjingsho bëy, ga pjl̈i shrono ara kjone pogo. Eshkoshko ga syãpga tjeng ara Israel kjokyo, Elías sök l̈ishko, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","gueniyo ichara Sbörë syãpga l̈öng eshko l̈i kjimtë l̇l̇ëme. Miga ichara Sarepta kjokyo, kjok l̈i buk Sidón kjokyo worbo go, syã sök kjl̈ara eshko kjimtë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sbö tjl̈õkwo l̈aga Eliseo dbaryoshko ga nopga tjeng Israel tjëyoga ara pogl̈o go swl̈o ara, sho an do jĩkong wl̈eniyo, gueniyo poptara kjl̈ara l̇l̇ëme. Miga domer Siria so ko Naamán, era poptara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kuya nopga tjeng judíoga syõ uyo roshko l̈irë ga iirkono ara ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ga kojono l̈ok, ga Jesús söra l̈ok jek kjok eshko dwayo. Kjok eshko l̈i, e pjang dl̈up pogl̈o go. Eni ga söra l̈ok jek öötong l̈ok dl̈up l̈i dbo go, dbuya l̈on jer töshko wl̈o l̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Miga Jesús opdöno jek ba tjrëko, ga toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","E irgo ga jek öötong shäng Capernaúm kjokyo, e Galilea kjokyo obi. Ga öötong woshtozl̈ong dbaryo ga opzrëno jek shäng judíoga syõ uyo jong eshko l̈i roshko, ga nopga pina. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tjl̈õkwo l̈ara jl̈õkoyo, dbo ara go. E kjĩshko ga nopga l̈öng ba kuga l̈i beno l̈öng yëy l̈e erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eshko ga domer shäng kjl̈ara, goshko Ä sëya kjl̈ara. Ga Jesús ĩya sëya l̈irë ga öö l̈e ba kong dbo goshko, tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Jesús, Nazaret so, ¿pja tek shäng borwa barwë ega? ¿Pja tek shäng borwa pjigare? Pja ë miydër pjl̈úe. Pja iak beno shäng dboy Sbö kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kuya ga sëya l̈i wl̈ona, tjl̈ẽ ga «Pja kjinkozong. Pja opkjos domer kjwe go dwayo» l̈e. Kuya ga domer l̈i dbura buk töshko, gueniyo l̇l̇ëye owa shäryara ba kong l̇l̇ëme. Eshko ga opkjono ba go dwayo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eni ga nopga tjeng eshko l̈i beno l̈öng yëy l̈e erä. Ga tjl̈ẽ ëng kong ga «¿Tjl̈õkwo kjwe l̇l̇ëro? Dbo ara go ga Ä sëyaga iche opkjë ga kol̈e jl̈õkoyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ga Jesús roy shdöra l̈ok kjok eshko kjwang jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","E irgo ga Jesús opshino judíoga syõ uyo l̈i roshko dwayo, ga jek öötong shäng Simón ushko. Eshko ga Simón ëm buk swl̈o ara, wl̈oyo kjl̈ikdë. Eni ga nopga tjeng eshko l̈i tjl̈ẽ Jesús kong ga «Rokërwa bop kong sira ga kjwe kjimtozong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Öötong shäng ba zl̈ong bäng ga kjl̈ik l̈i zenoe. Jekdo eshko ga kojono, ga dl̈i shäryono ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jek kjok ro zar ga nopga swl̈o obl̈ë obl̈ë wl̈eniyo söraba ara Jesús kong. Ga orkwo iono kjl̈ara kjl̈ara kjing go, ga poptara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jesús, e no pjl̈uyo ichara Sbörë shrono shäng l̈i miyde Ä sëyaga tjeng oba goshko l̈irë owa l̇l̇ëme. Epga toshko ga tjl̈ẽ l̈öng dbo go ga «¡Pja Sbö Wa!» l̈e. E kjĩshko ga ichara Jesúsdë tjl̈ẽ l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wẽshko kjok shröngto ga Jesús opshino jek kjok eshko dwayo, to jongya ëye l̇l̇ëmshko, ber sök tjoksa wl̈o. E irgo ga nopga to l̈öng ba wl̈ẽk. Ga wl̈ẽna l̈ok, ga tjl̈ẽ l̈ok ba kong ga «Pja brik l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gueniyo kuya ga tjl̈ẽ ba kong ga «Tja to jongya kjok shto obl̈ë obl̈ë, Sbö ber no pjl̈uyo sorë l̈i roy pjl̈ú shdök, miydëba wl̈o. Tja ichak shäng e kong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eni ga to shäng ba l̈ë judíoga kjokyo kjrinashko kjrinashko, judíoga syõ uyo l̈ok kjwobi l̈i roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","3","Pjl̈ara ga Jesús shäng di bäng buk kësbang, shkung, so dl̈ung kjoyo ko Genesaret l̈i kjako. Eshko ga nopga shrono l̈öng ara ba zl̈ong bäng, Sbö tjl̈õkwo kuya l̈ok wl̈o, ga Jesús l̇l̇iya l̈ok ara. Eshko ga ĩna Jesúsdë ga kjyong tjeng do pjök di bäng l̈i kjako, roy no l̇l̇ëme. Nopga tjeng ba roy l̈i opshino tjeng ba kjl̈a mã shakkl̈o kwoshkwë. Eni ga Jesús opyono kjyong buk kjl̈ara roshko, kjyong l̈i sogo ko Simón. Eshko ga tjl̈ẽ Simón kong ga «Ichos jek sira di rong shwo l̈ëkong» l̈e. Ga ichara jeke. Eshko ga Jesús sirkeno sök kjyong l̈i roshko, ga nopga beno tjeng pjöshko l̈i pĩya sök. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tjl̈ẽno pjir ga tjl̈ẽ Simón kong ga «Kjyong ëre ichos jek këgong sit di rong wl̈eshko, ga bomi kjl̈a mã shakkl̈o kjwe dbuzĩ dishko, pjãy mã shak wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kuya ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, tjawa parkono l̈öng shkë ga mã sharorwa kjl̈ara l̇l̇ëme. Gueniyo tjawa ichaga pjarë ga kjl̈a dburwa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Shäryara eni ga mã shara l̈ok träk l̇l̇ëme. Shiya l̈okshko ga kjl̈a l̈i kjiyo kjone kjone skoktong tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ĩya ga dwl̈eto ga ba pjeyoga tjeng kjyong obl̈ë roshko l̈i rokara or go, tek ba kjimtë wl̈o. Ga epga shrono, ga parkono tjë jĩkong. Ba kjyong do pjök l̈i pito, roy dl̈ina tjung mã erö kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Ga ĩya l̈ok ga mã shara l̈ok ara ga beno l̈öng yëy l̈e erä. Eni ga Simón Pedro kjök tono Jesús bokshto, ga tjl̈ẽ ba kong ga «Tjl̈apga, pja opkjos bor zl̈ong dwayo sira. Tja domer owa wl̈eniyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ba pjeyoga tjeng kjyong obl̈ë roshko l̈i beno l̈öng eni bakoe. Tjeng kjyong obl̈ë roshko l̈i, epga ko Santiago, Juan. E Zebedeo wapga. Eshko ga Jesús tjl̈ẽ Simón kong ga «L̇l̇ëye bangkjrëp l̇l̇ëme. Pja to shäng mã shak ame. Pja iër to ber shäng no töng bor kong shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eni ga kjyong l̈i shira tjeng pjöshko iröng obi, ba l̇l̇ëbo tjeng kës l̈i rayara, ga to jek l̈ok Jesús tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pjl̈ara ga Jesús öötong shäng kjok kjrinashko ga domer shrono shäng kjl̈ara ba shwoy. Domer l̈i pogl̈o go swl̈o ara, sho an do jĩkong. Jesús ĩya ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, ga tjl̈ẽ ba kong ga «Tjl̈apga, tja poptëp woydë ga tja poptëp ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kuya ga porwara ba orkwo go, ga tjl̈ẽ ga «Pja poptër woydë. Pja ber pjl̈ú shara» l̈e. Jekdo eshko ga domer l̈i poptono beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Eshko ga Jesús tjl̈ẽ ba kong ga «Pja poptoror l̈ëp ë kong l̇l̇ëme. Pja nom opping syõshtaga Sbö kong nopga kjĩshko l̈i kong, pja ĩya wl̈o eröe. Sbö sënggl̈o l̈ara Moisésdë, pja äär Sbö poshrëk ba ushko ga pjl̈ú wl̈o l̈i söp, twëp ba kong, pja poptono miydëba wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gueniyo ga Jesús roy shdöktong jek këgong. E kjĩshko ga shäng l̈ishko ga oba tön l̈öng ba shwoy ara anmoyõ, ba kuk wl̈o, ba swl̈o l̇l̇ë l̈i popte wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Gueniyo ol̈öshko ga Jesús opkwë jek shäng ëye l̇l̇ëmshko, syõshtë Sbö kong tjoksa wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dbar kjwara ga Jesús sök oba ping. Eshko ga fariseoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e shrono l̈öng Galilea kjokyo obl̈ë obl̈ë dwayo, Judea kjokyo obl̈ë obl̈ë dwayo, Jerusalén kjokyo dwayo bako, ga sirkeno l̈öng eshko. Eshko ga Tjl̈apga dbo kësbang tjeng Jesús tjok, swl̈opga popte wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eni ga domerga tjwe l̈öng eshko kjl̈öbö, swl̈o söno kjl̈ara pogl̈o roshko. Swl̈o l̈i buk töshko, dre kuga l̇l̇ëm wl̈eniyo. Söya l̈ok kjër roshko, ie buk Jesús bokshto wl̈o l̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Gueniyo jek opzrëk kjone go l̇l̇ëm, oba ara kjĩy. Eni kuzong ga jem tyono l̈ok u dbo kjing sdok l̈i kjing go, kjing döra sira, swl̈o l̈i l̈ona ter pjang ba pogl̈o roshko öötong buk dew, oba ara tjrëko, Jesús bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ĩya Jesúsdë ga swl̈o sögaga l̈i mär ba go ga tjl̈ẽ swl̈o buk töshko l̈i kong ga «Domer, owa pjang bop go l̈i l̈önor beno drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga l̈öng eshko, e wotjl̈ĩk l̈ok ga «¿Kjwe ëro? ¡Domer kjwe shäng Sbö l̈ãywë owa, ber tjwl̈õ l̇l̇ëm wl̈o l̈e! Owa l̈öngga nopga kong l̈i Sbö eröe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wotjl̈ĩk l̈öng l̇l̇ë l̈i miydara Jesúsdë pjir kuzong ga tjl̈ẽ ba kong ga «¿Pjãy wotjl̈ĩk owa eni ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Owa pjang bop go l̈i l̈önor beno drete” l̈oror ba kong. Gueniyo l̈önorde, de l̈önor l̇l̇ëm, e ĩgömi l̇l̇ëme. Gueniyo ga “Pja kojõzong. Pja jëkzong” l̈oror ba kong ga poptororde, de poptoror l̇l̇ëm, era ĩgömi wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kjok ëre kjing go ga no to ter kjok dogo dwayo ëre dbo ara, owa pjang nopga go l̈i l̈ön ber dret wl̈o ga pjl̈úe. Miydëmi wl̈o ga l̇l̇ëbo shäryër e» l̈e. Eni ga tjl̈ẽ swl̈o buk töshko l̈i kong ga «L̈ër bop kong ga pja kojõzong. Bop bukkl̈o kjwe kjros, ga pja nom bop ushko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kuya ga kojono nopga l̈öng l̈i bokshto, ba bukkl̈o l̈i kjrara, ga to jek ba ushko Sbö poshrëk ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ĩya nopga tjeng eshko l̈irë ga beno l̈öng yëy l̈e erä, ga Sbö poshrëra, ga tjl̈ẽ l̈ok ëng kong ga «Eeri ga l̇l̇ëbo ĩydë l̇l̇ëm obi, e ĩnoy jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","E irgo ga Jesús opshino to ey dwayo. Jek jëk shängshko ga domer sök kjl̈ara eshko ko Leví, e dbur töngga Roma so kong. E sök ba pak l̈ishko. Ĩya Jesúsdë ga tjl̈ẽ ba kong ga «Pja tek bor tjok, pja pin wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kuya ga kojono, ba l̇l̇ëbo tjeng kës l̈i rayara, ga to jek ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","E irgo ga Leví dl̈i shäryono kësbang ba ushko, Jesús poshrëkkl̈o. Eshko ga oba shrono l̈öng ara ië, tjrëko nopga dbur töngga Roma so kong shrono l̈öng ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ĩya fariseoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë go l̈irë ga tjl̈ẽ l̈ok Jesús oppinggaga l̈öng l̈i kong ga «¿Pjãy ië nopga owa wl̈eniyo tjok kjweni ega?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kuya Jesúsdë ga tjl̈ẽ ba kong l̈ok ga «Nopga l̈öng pjl̈ú, swl̈o l̇l̇ëm ga e dwl̈omnega woydë l̇l̇ëme. Swl̈opgara dwl̈omnega woydë. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eni ga tja shrono shäng kjok ëreshko, nopga pjl̈o bek l̈i rokaga l̇l̇ëm, nopga owa l̈i rokaga, l̇l̇ëbo owa shärye l̈öng l̈i, e owa jl̈õe l̈e, ga raye wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eshko ga tjl̈ẽ l̈ok ba kong ga «Juan oppinggaga ië l̇l̇ëm syõshtë Sbö kong wl̈o dbar kop ara. Fariseo oppinggaga omshäryë eni bakoe. ¿Bop oppinggagara ië enido ega?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","«Orkwosmozl̈ong dbaryoshko ga domer orkwosmok wl̈o l̈i shäng ba tjok obishko ga nopga mak l̈öng eshko l̈i ië l̇l̇ëm ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gueniyo domer l̈i söraba ba shjiryoshko ga epga ië l̇l̇ëm eshko jã» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eshko ga tjl̈ẽno ba kong l̈ok l̇l̇ëbo jyãgl̈o go obi. Tjl̈ẽ ga «Shji shwong tjagl̈ën zëy sira, shwong këguë bängyëy e go wl̈o l̇l̇ëme. Shäryoroy eni kjwe ga shwong tjagl̈ën l̈i sreya, ga shwong këguë l̈i ber owa bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","»Kjil̇l̇gwo bo dyo dbo ara tjagl̈ën tyëy ba bapkwo këguë shäryak öng kwota go roshko l̇l̇ëme. Shäryoroy eni kjwe ga ba bapkwo l̈i böptur. Eni ga kjil̇l̇gwo bo dyo l̈i, e ber l̇l̇ëno ame, ba bapkwo l̈i ber eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Eni kuzong ga kjil̇l̇gwo bo dyo dbo ara tjagl̈ën tyëy wl̈o ga woyde bapkwo tjagl̈ën. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ëye kjil̇l̇gwo bo dyo dbo ara këguë l̈i iono ga kjil̇l̇gwo bo dyo tjagl̈ën l̈i ie woydë l̇l̇ëme. Eshko ga tjl̈ẽ ga “Këguë l̈i pjl̈ú, tjagl̈ën l̈i kjinmo” l̈e eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Woshtozl̈ong dbaryo kjwara ga Jesús jëk shäng dwl̈a dgak buk l̈i tjrëko ba oppinggaga tjok. Eshko ga ba oppinggaga l̈öng dwl̈a bo kjrë, ga kjwokäya or go, ue l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Eni ga fariseoga kjone kjone tjl̈ẽ ga «¿L̇l̇ëbo shäryako woshtozl̈ong dbaryoshko l̇l̇ëm l̈i shäryëmi l̈öng kjweni ega?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kuya Jesúsdë ga tjl̈ẽ ba kong ga «¿Dënashko ga David, ba yorkagaga, e pjl̈i l̈ok arashko ga l̇l̇ëye shäryara tak pjang Sbö tjl̈õkwo go l̈i, e l̈omirë l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David opzrëno jek shäng Sbö u roshko, ga pjl̈ung shosho suk pjir iak beno tjeng dboy Sbö kong l̈i uara, ga twara ba nopga jëk l̈öng ba tjok l̈i kong, ue wl̈o bako, e uaga syõshtagagarë erö gueniyo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ga tjl̈ẽ ba kong obi ga «Woshtozl̈ong dbaryo kägäyo l̈i, no to ter kjok dogo dwayo ëre l̈i e» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Woshtozl̈ong dbaryo obl̈ëshko ga Jesús opzrëno jek judíoga syõ uyo jong kjok eshko l̈i roshko, ga nopga tjeng eshko l̈i pina. Domer shäng kjl̈ara eshko orkwo kël̈ë sl̈osl̈oe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fariseoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e l̈öng eshko bako, Jesús dë, swl̈o l̈i popte woshtozl̈ong dbaryore ĩya l̈ok wl̈o, rote e go wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wotjl̈ĩk l̈öng l̇l̇ë l̈i miydara Jesúsdë pjir kuzong ga tjl̈ẽ swl̈o l̈i kong ga «Pja kojõs shäng nopga l̈öng kës ëre tjrëko» l̈e. Kuya ga shäryara eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","E irgo ga Jesús tjl̈ẽ nopga tjeng l̈i kong ga «Pjãy kong l̇l̇ëbo kjakrokër kjrina. ¿Woshtozl̈ong dbaryo ga l̇l̇ëye shäryëy obl̈ë kong ga pjl̈ú? ¿L̇l̇ëbo pjl̈úre, de l̇l̇ëbo owa? ¿Ëre dbaryo ga kjl̈ara buk ba l̇l̇ëmdo shinmotkë wl̈o ga l̇l̇ëye shäryëy? ¿Wẽyẽre, de kjimtëy?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eshko ga l̈öng ba zl̈ong bäng pjribri l̈i ĩna uunkong, ga tjl̈ẽ swl̈o l̈i kong ga «Pja orkwo roshwĩzong» l̈e. Kuya ga shäryara eni, ga ba orkwo poptono beno pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Gueniyo ga nopga l̈öng l̈i iirkono ara, tjl̈ẽ l̈ok ëng kong ga «¿L̇l̇ëye shäryëy Jesús kjwe kong ga pjl̈ú?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Eshko dbaryo ga Jesús opshino to jem shäng dl̈up jong kjwara bigdo go, syõshtë Sbö kong wl̈o, ga syõshtono shkëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wẽshko kjok shröng ga ba oppinggaga rokara tek l̈öng ba zl̈ong bäng. Eshko ga kjrara dogl̈o sak kjwara kjingsho pjök (12), ber l̈öng Sbö tjl̈õkwo roy l̈aga ba ãska wl̈o. Epga ko l̈ok eni: ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón, e koiara beno Pedro; Andrés, e Simón l̈ëng; Santiago; Juan; Felipe; Bartolomé; ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo; Tomás; Santiago, e Alfeo wa; Simón, e zelote; ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, e Santiago wa; Judas Iscariote, e Jesús soynega. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","E irgo ga Jesús to ter dl̈up l̈i dwayo ba oppinggaga kjrara l̈i tjok, ga öötong l̈öng sdam l̈ëkong. Eshko ga nopga tjeng träk l̇l̇ëm, opping ba tjok wl̈o. Nopga shrono l̈öng ara ba kuk wl̈o, ba swl̈o l̇l̇ë l̈i popte wl̈o bakoe. Shrono l̈öng l̈i, e Judea sopga, Jerusalén sopga, Tiro sopga, Sidón sopga bakoe. Tiro kjokyo, Sidón kjokyo, e tjeng dl̈ung sor go. Ëye tjeng eshko goshko Ä sëyaga ga e poptara Jesúsdë. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Eshko ga ëye ba shwong porwono ga poptono ba dbo kësbang go. E kjĩshko ga uunkong wotjl̈ĩk l̈ok ba porwë l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Eshko ga ba oppinggaga ĩya Jesúsdë ga tjl̈ẽ ba kong ga «Nopga song wl̈eniyo, pjãy ber wopjl̈ú, Sbö ber bomi pjl̈uyo kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pjãy l̈öng pjl̈i ara wl̈eniyo, pjãy ber wopjl̈ú, l̇l̇ono ga pjãy ber l̈öng bö tjung kjĩshko. Pjãy l̈öng sl̈ar ëë wl̈eniyo, pjãy ber wopjl̈ú, l̇l̇ono ga pjãy ber l̈öng jar kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Pjãy ĩywaba shjiktëng, pjãy wl̈okjrëba l̇l̇ëm, pjãy l̈ãywëba owa, bomi ko e owa l̈ëba, shäryëba eni no to ter kjok dogo dwayo ëre kjĩshkoshko ga pjãy ber wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Eni ga pjãy äär kjok dogoshko ga pjãy potjwl̈ẽn ara. E kjĩshko ga shäryëba owa bomi kong enishko ga pjãy woydë l̇l̇ëme. Pjãy ber woowa l̇l̇ëm dey. Sgl̈ik l̈ëmi, öö l̈ëmi ara, pjãy l̈öng wopjl̈ú kjĩshko bakoe. Dënashko ga Sbö tjl̈õkwo l̈agaga shdunaba eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Gueniyo ga pjãy nopga dbur ara wl̈eniyo, pjãy song jl̈õ, l̇l̇ono ga pjãy l̈öng pjl̈ú dbaryo l̈i pjitong kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pjãy l̈öng bö tjung wl̈eniyo, pjãy song jl̈õ, l̇l̇ono ga pjãy ber l̈öng pjl̈i ara kjĩshko. Pjãy l̈öng jar wl̈eniyo, pjãy song jl̈õ, l̇l̇ono ga pjãy ber l̈öng sl̈ar ëë kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pjãy poshrëkoba arashko ga pjãy song jl̈õe. Dënashko ga nopga to l̈öng tjl̈ẽ ga “Tja Sbö tjl̈õkwo l̈aga” l̈e, gueniyo ichaga Sbörë l̇l̇ëme. Eshko ga epga poshrëraba ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","»Gueniyo ga l̈ër pjãy bor kuga l̈i kong ga bomi moskwoga woydozĩ ara. Ëye, pjãy ĩywa shjiktëng ga kong l̇l̇ëbo shäryozĩ pjl̈ú dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ëye wotjl̈ĩk owa bop tjok ga pjãy wotjl̈ĩk pjl̈ú ba tjok. Ëye, pjãy bokrotke ga pjãy syõshtë Sbö kong ba kjĩshko dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pjãy kwomso shpora obl̈ërë pjl̈ara ga kal̈ëkong twëmi ba kong, shpoya wl̈o bakoe. Bomi shwong kop l̈ëkong döra ga bomi shwong ter l̈ëkong twëmi ba kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ë pogo tjwe bomi shwoy l̇l̇ëbo rokë ga twëmi ba kong. L̇l̇ëbo döra bop shjiryo ga wẽyẽ. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pjãy l̇l̇ëbo shäryos obl̈ë kong, woydëmi ga shärye l̈ok bomi kong sorë ga eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","»¿Bomi woydagaga woydomirë dö wl̈eni ga pjãy potjwl̈ẽkkl̈o l̇l̇ë l̈ëmiro? Nopga owa ëmdë ga omshäryë e kjoyoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","¿Bomi kjimtagaga kjimtomirë erö ga pjãy potjwl̈ẽkkl̈o l̇l̇ë l̈ëmiro? Nopga owa ëmdë ga omshäryë e kjoyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","¿Dbur poskwomi, tjwl̈õ shimi iröng wl̈o dö ga pjãy potjwl̈ẽkkl̈o l̇l̇ë l̈ëmiro? Nopga owa ëmdë ga omshäryë e kjoyoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Eni l̇l̇ëme. Nopga kong l̇l̇ëbo shärye Sbörë pjl̈ú bako, “Tja kjimtara Sbörë” l̈e l̇l̇ëm gueniyo. E kjĩshko ga bomi moskwoga woydozĩ ara. L̇l̇ëbo shäryozĩ pjl̈ú ba kong. Dbur poskwõzĩ oba kong, ga tjwl̈õ shimi l̇l̇ëme. Eni ga bomi potjwl̈ẽkkl̈o ber kësbange. Ga pjãy ber l̈öng Sbö Tjwl̈õ Kësbangyo l̈i wapga jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pja songe l̈e bomi Datarë oba kong. Pja songe l̈ozĩ oba kong eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","»“No obl̈ë l̇l̇ëbo owa shäryono” l̈ëy ë kong l̇l̇ëme. Eni ga “Pjãy l̇l̇ëbo shäryono owa” l̈e Sbörë bomi kong l̇l̇ëm bakoe. “Pja shdungko” l̈ëy ë kong l̇l̇ëme. Eni ga “Pjãy shdungko” l̈e Sbörë bomi kong l̇l̇ëm bakoe. L̇l̇ëbo shäryara obl̈ërë bomi kong owa l̈i iozĩ ber tjwl̈õ l̇l̇ëme. Eni ga owa pjang bomi go l̈i l̈ö̃ya Sbörë ber dret eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Oba së̃zĩa. Eni ga pjãy së̃ya Sbörë bakoe. Pjãy kong l̇l̇ëbo twe bayo ara, so resgwo bapkwo tjung kjoyo, resgwo bapkwo l̈i roshko resgwo yoroy, kjing l̇l̇iy or go, sigwo yoy ber l̇l̇iktëng wl̈o, kjing goshko iëy jek obi, ber tjung kjopkwo shopte jong om go wl̈eni. Shäryëmi obl̈ë kong sorë ga shärye Sbörë bomi kong eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","E irgo ga tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go obi. Tjl̈ẽ ga «Nopga tjeng do pjök kjok ĩgö l̇l̇ëm wl̈eniyo. ¿Kjl̈ara wl̈osöya ba kjl̈ara l̈irë l̈e ga l̈on jer tjeng pjöyĩkong pjl̈ëbgwo kjwaraso roy l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Oppinggaga tjwl̈õ ara, ba pingga kjinmo l̇l̇ëme. Gueniyo ga oppino pjirshko ga äär ber ba pingga dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","»Bomi kjl̈ara bok bäng kjor pjl̈oyo ĩmi kjër. E wopro ga bomi bok roshko kjorkwang buk kjwangna l̈i ĩgömi l̇l̇ëme. ¿Shäryëmi eni egaro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Kjorkwang buk bomi bok roshko l̈i ĩgömi l̇l̇ëm ga “Kjor pjl̈oyo buk bop bok bäng kjwe shir bop kong” l̈ëmi bomi kjl̈ara kong sorëro? ¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! Kjorkwang buk bomi bok roshko l̈i shizĩ bäm go. Enira kjor pjl̈oyo buk bomi kjl̈ara bok bäng l̈i ĩgömi wẽl̈ë, shimi ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","»Kjor doyo pjl̈ú ga botjyë ga owayo drete. Kjor doyo owa ga botjyë ga pjl̈úyo dret bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kjor, e sorë miydëy ba bo go. Kjor bo kjrëy shkl̈ik doyo go l̇l̇ëme. Kjil̇l̇gwo bo kjrëy shkö sho doyo go l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","No pjl̈ú ga tjl̈ẽ pjl̈ú, wotjl̈ĩk pjl̈ú ba pjl̈úshko kjĩshko. No owa ga tjl̈ẽ owa, wotjl̈ĩk owa ba pjl̈úshko kjĩshko bakoe. L̇l̇ëbo tjeng bomi pjl̈úshko l̈omirë bomi kjamo go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","»Pjãy tjl̈ẽ bor kong ga “Pja bor Tjl̈apga jl̈õkoyo” l̈ëmi, gueniyo tja kol̈ëmi l̇l̇ëme. ¿Shäryëmi eni egaro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Ëye tjwe bor shwoy, tja tjl̈õkwo kuya, ga l̇l̇ëye l̈oror l̈i shärye ga e so domer u ywaga kjl̈ara kjoyoe. U shäryarashko ga shwl̈eyo pjl̈ona rong, ga ak iara ba so bäng pjribrie. Shäryara pjir ga di to jer, pjono u l̈i goshko ga to wito l̇l̇ëm, u l̈i shäryara pjl̈ú kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gueniyo ëye, tja tjl̈õkwo kuya, ga l̇l̇ëye l̈oror l̈i shärye l̇l̇ëm ga e so domer u ywaga obl̈ë kjoyoe. U shäryarashko ga ba shwl̈eyo pjl̈ona uriso, rong l̇l̇ëme. Shäryara pjir ga di to jer, pjono u l̈i goshko ga skwara pjir, söra dirë drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús tjl̈ẽno oba kong pjir ga opzrëno jek öötong shäng Capernaúm kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Domer sök kjl̈ara eshko, e Roma so, e ëngkjwagaga ara kägäyo bakoe. Domer l̈i parkaga tjwl̈ẽk shäng pjir wl̈eniyo buk kjl̈ara, woyde ara wl̈eniyo, e swl̈o ara, wol̈ontoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ga Jesús roy kura ba kägäyo l̈irë, ga judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo ichara kjl̈öbö, Jesús rokë, ba parkaga l̈i poptë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Öötong l̈öng Jesús shwoy ga tjl̈ẽ ba kong ga «Tjl̈apga, rokërwa bop kong ga domer l̈i kjimtos sira. E judío bishĩya dik l̇l̇ëm, gueniyo bi tjëyoga woyde ara. Tjawa kong syõ uyo shäryara kjwara om go. E kjimtako jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kuya ga to jek ba tjok. Jek l̈öng ääto ba ushko ga ëngkjwaga kägäyo l̈i, ba pjeyoga ichara kjl̈öbö, l̈an Jesús kong obi wl̈o. Öötong l̈öng ba shwoy ga tjl̈ẽ l̈ok ba kong ga «Domer l̈i tjl̈õkwo ichono bop kong. Tjl̈ẽ ga “Tjl̈apga, pja tek bor ushko l̇l̇ëm ga bue. Tja l̇l̇ëno l̇l̇ëm, tjwl̈õ l̇l̇ëm, pja opzrëk tek bor u roshko wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pja ĩnor jek om go bop shwoy l̇l̇ëm e kjĩshko. Bor parkaga poptë l̈ëp erö ga poptë dani. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tja kägäyo tjok. L̇l̇ëye l̈e bor kong l̈i shäryër eni ĩyado. Tja ëngkjwagaga ara kägäyo. L̇l̇ëye l̈ër ba kong l̈i shärye l̈ok eni ĩyado bakoe. ‘Pja nomo’ l̈ër kjl̈ara kong ga toe. ‘Pja tegö’ l̈ër kjl̈ara kong ga teke. Bor parkaga tjwl̈ẽk shäng pjir wl̈eniyo ichër l̇l̇ëbo shäryë ga shärye eni” l̈e bop kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kuya ga beno shäng yëy l̈e erä. Ga nopga jëk l̈öng ba tjok l̈i ĩya ga tjl̈ẽ ba kong ga «L̈ër bomi kong ga domer, e mär bor go jl̈õkoyo, Israel tjëyoga uunkong kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","E irgo ga domerga ichara l̈i öötong l̈öng ëngkjwaga kägäyo l̈i ushko iröng obishko ga ba parkaga swl̈o ara l̈i wl̈ẽna shäng pjl̈ú tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","E irgo ga Jesús jek shäng jongya kjok ko Naín, ba oppinggaga tjok. Oba jek l̈öng ara ba tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jek l̈öng ääto eshko ga shinmo sökoba jek pjang kjl̈ara, iëba sakshko wl̈o. Shinmo l̈i meyo, e syã, ga wa domer obl̈ë drete. Kjok eshko sopga jek l̈öng ara ba yorkë. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ĩya Tjl̈apga Jesúsdë ga songe l̈e, ga tjl̈ẽ ba kong ga «Pja sl̈ar ame» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E irgo ga jek öötong shäng shinmo l̈i zl̈ong bäng ga ba bapkwo söya l̈ok pjang l̈i porwara. Ba sögaga jek l̈öng l̈i sl̈ongtëng l̈önge. Eshko ga Jesús tjl̈ẽ shinmo l̈i kong ga «¡Dwl̈as, l̈ër bop kong ga pja kojõzong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ga shinmo l̈i wl̈oktëng sök, ga tjl̈ẽno. Eshko ga ichara Jesúsdë to iröng ba mekë tjok obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ĩya l̈öng l̈irë ga bangkjre l̈ok träk l̇l̇ëme. Ga Sbö poshrëra l̈ok ara. Tjl̈ẽ l̈ok ga «Sbö tjl̈õkwo l̈aga weno shäng bi tjrëko kjl̈ara kësbange» l̈e. Ga tjl̈ẽ l̈ok obi ga «Sbö shrono shäng, ba nopga kjimtë wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesús roy shdöktong Judea kjokyo kjok kjwang jĩkong, kjok shto obl̈ë obl̈ë ber tjeng ba worbo go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","E irgo ga l̇l̇ëbo shäryak eni l̈i, e roy kura Juandë pjir, l̈aga ba oppinggagarë ba kong. Eni ga ba oppinggaga rokara ba shwoy do pjök, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ga ichara tjl̈ẽ Tjl̈apga Jesús kong ga «¿No pjl̈uyo iche l̈e Sbörë koshërwa l̈öng l̈i pjare, de obl̈ë koshorwarë?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Eni ga öötong l̈öng Jesús shwoy ga tjl̈ẽ ba kong ga «Tjawa ichara Juan No Wagarë tjl̈ẽ bop kong ga “¿No pjl̈uyo iche l̈e Sbörë koshërwa l̈öng l̈i pjare, de obl̈ë koshorwarë?”» l̈e l̈ok ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jekdo eshko ga nopga swl̈o obl̈ë obl̈ë wl̈eniyo, nopga goshko Ä sëyaga, e poptara Jesúsdë ara. Ga nopga kjok ĩgö l̇l̇ëm wl̈eniyo poptara ara, beno l̈öng kjok ĩgö pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","E irgo ga Jesús tjl̈ẽ Juan oppinggaga l̈i kong ga «L̇l̇ëye ĩnomi, kuromi l̈i to l̈ëmi Juan kong. Nopga kjok ĩgö l̇l̇ëm wl̈eniyo kjok ĩnoe. Nopga jëk l̇l̇ëm wl̈eniyo jëktonge. Nopga pogl̈o go swl̈o ara, sho an do jĩkong wl̈eniyo poptonoe. Nopga kjok kugö l̇l̇ëm wl̈eniyo kjok kunoe. Shinmoga woshrono iröng obi. Nopga song wl̈eniyo kong Sbö tjl̈õkwo roy pjl̈ú l̈ak ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ëye mär bor go, ga tja raye l̇l̇ëm ga era ber sök wopjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Epga toshko ga Jesús tjl̈ẽno oba kong Juan kjĩshko. Tjl̈ẽ ga «¿Pjãy jek l̈öng kjok dogro no l̇l̇ëmshko, Juan ĩkshko ga pjãy äätë eshko l̇l̇ëm obishko ga domer, e kjwe sorë l̈oromi? ¿E sjro bakwara pjl̈ukdë wl̈eni l̈oromire? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Eni l̇l̇ëm ga e kjwe sorë l̈oromi? ¿E doyono shäng shwong wol̈ësowa, tjwl̈õ ara wl̈eniyo go l̈oromire? Miydëmi pjl̈ú ga nopga dbur ara eniyo l̈öng pjl̈u ushko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Eni ga e kjwe sorë l̈oromi? ¿E kjwe Sbö tjl̈õkwo l̈aga l̈oromire? E jl̈õe. Ga e tjwl̈õ ara, Sbö tjl̈õkwo l̈agaga obl̈ë kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sbö tjl̈õkwo tak pjang l̈i goshko ga Sbö tjl̈ẽno Juan kjĩshko. Tjl̈ẽno beno eni: “No ichër kjl̈ara bop bäm go, bop roy l̈aga, irbo poshäryë bop kong wl̈o.” ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","L̈ër bomi kong ga nopga uunkong kjok ëre kjing go äätë tjwl̈õ ara, Juan kjinmo l̇l̇ëme. Eni gueniyo ga nopga l̈öng Sbö sök no pjl̈uyoshko kjl̈obi l̈i tjwl̈õ ara, Juan kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Jesús tjl̈õkwo kugaga uunkong, nopga dbur töngga Roma so kong ëmdë ga tjl̈ẽ ga «Sbö tjl̈õkwo, e beke» l̈e, optwono Juan kong, we jer di roshko l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gueniyo ga fariseoga, kjok l̇l̇gwekkl̈o tara Moisésdë l̈i miydagaga pjl̈ú wl̈eniyo, era optwono Juan kong, we wl̈o l̇l̇ëme. E kjĩshko ga Sbö tjl̈õkwo kjrara l̈ok l̇l̇ëme.) ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ga Jesús tjl̈ẽ obi ga «Eerishko dbaryo sopga, ¿pjãy so l̇l̇ë kjoyo l̈ër bomi kong? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pjãy so kjwozirga öö l̈e l̈öng ëng kong l̇l̇ëbo soynezl̈ong shtoyoshko tjör kjoyoe. Tjl̈ẽ l̈ok ga »“Tjawa dbonmo bakwono ga bëyotkoromi l̇l̇ëme. Tjawa tono tëkwo woydokl̈o ga pjãy sl̈atong l̇l̇ëm bakoe” l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","34","»L̈ër ega l̈ër bomi kong. Juan No Waga shrono shäng ga iono l̇l̇ëm Sbö kong dbar kop ara, ga kjil̇l̇gwo bo dyo iono l̇l̇ëm bakoe. Eshko ga “Kjwe goshko Ä sëya kjl̈ara” l̈oromi. E irgo ga no to ter kjok dogo dwayo ëre shrono ga tja ië ara, tja kjil̇l̇gwo bo dyo ië bakoe. Eni ga “Domer kjwe ië sĩyo, nel̈õtkë äe, jëk nopga owa wl̈eniyo tjok, ië nopga dbur töngga Roma so kong l̈i tjok bakoe” l̈ëmi eni. L̈ër bomi kong ga pjãy so kjwozirga l̈öng l̈i kjoyo e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sbö kjok miydë l̈i, e jl̈õe miydëba ba sögaga l̈i go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo shäng kjl̈ara. Pjl̈ara ga Jesús mana jek ba ushko ië, ga Jesús jek öötong sirkeno sök ië ba tjok eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kjok eshko ga wal̈ë shäng kjl̈ara, l̇l̇ëbo owa shäryaga wl̈eniyo. Kuya ga Jesús sök ië fariseo l̈i ushkoshko ga jek öötong shäng eshko, wl̈oshko poshtikkl̈o bapkwo tjwl̈õ ara, roshko poshtikkl̈o l̈õ pjl̈ëbl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Öötong shäng Jesús zl̈ong bäng ga sl̈ar ëëe. Ba boryo l̈i tjöno Jesús dre kjing go, ga dõya sök ba käkzong go. Eni ga ba dre l̈i l̈õ shira, ga kjing go poshtikkl̈o l̈i kwona. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ĩya fariseo, Jesús maga l̈irëshko ga wotjl̈ĩk ga «Domer kjwe Sbö tjl̈õkwo l̈aga wl̈eniyo jl̈õkoyo kjwe ga wal̈ë sök ba porwë kjwe owa miydara pjire» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Fariseo l̈i ko Simón. Eni ga Jesús tjl̈ẽ ba kong ga «Simón, tjl̈õkwo l̈ër woydë bop kong sira» l̈e. Kuya ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, l̈ozong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Eshko ga tjl̈ẽ ba kong ga «Pjl̈ara ga nopga tjeng do pjök, pogo tjwl̈õ dbur poskwongga wl̈eniyo kong. Kjl̈ara pogo tjwl̈õ ba kong bayo domer parkë dbargwo sak dbäw pjl̈ogl̈o shkëng (500) ãska wl̈eni. Kjl̈ara obi pogo tjwl̈õ ba kong bayo domer parkë dbargwo sak shkëng (50) ãska wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ga potjwl̈ẽya l̈ok ga ä kuzong ga dbur poskwongga l̈i tjl̈ẽ ba kong l̈ok ga “Wẽyẽ, tja potjwl̈ẽmi ame” l̈e. ¿Eni ga kjone dey ga e woyde ara anmoyõ?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","«Bor kong ga kjl̈ara pogo tjwl̈õ ara, potjwl̈ẽkkl̈o ame l̈i e» l̈e. Kuya ga tjl̈ẽ ba kong ga «L̈ëp l̈i eni jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eni ga wal̈ë l̈i ĩya ga tjl̈ẽ Simón kong ga «Wal̈ë kjwe ĩzong. Tja shrono tek shäng bop u roshkoshko ga tja kong di tworop, tja dre shkwë e go wl̈o l̇l̇ëme. Gueniyo bor dre pöra kjwerë ba boryo go, ga dona ba käkzong go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tja wl̈okjroropshko ga tja l̈õ shirop l̇l̇ëme. Gueniyo tja shrono tek l̈ëkong ga bor dre l̈õ shiya kjwerë wop sit wop site. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kjyo kwonop bor dl̈u kjing go l̇l̇ëme. Gueniyo poshtikkl̈o kwona kjwerë bor dre kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","E kjĩshko ga l̈ër bop kong ga owa pjang ba go ara l̈i l̈önor beno drete. E kjĩshko ga tja woyde ara anmoyõ. Gueniyo ëye kong, owa pjang ba go l̈i l̈önor sira dö ga tja woyde ara anmoyõ l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","E irgo ga Jesús tjl̈ẽ wal̈ë l̈i kong ga «Owa pjang bop go l̈i l̈önor beno drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eshko ga nopga mana tjeng ië ba tjok l̈i tjl̈ẽ ëng kong ga «¿Kjwe ëro? ¿Owa pjang oba go l̈i l̈ö̃ya sorë?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Gueniyo ga Jesús tjl̈ẽ wal̈ë l̈i kong ga «Pja mär bor go kuzong ga pja döktonge. Pja nom wopjl̈ú bop ushko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","E irgo ga Jesús jëk to shäng kjok kjrina kjrina, ga Sbö ber no pjl̈uyo sorë l̈i roy pjl̈ú l̈e shäng oba kong. Ga domerga kjrara dogl̈o sak kjwara kjingsho pjök (12) l̈i jek l̈öng ba tjok, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","wal̈ëga jek l̈öng ba tjok kjl̈öbö bakoe. Wal̈ëga l̈i bäm goshko ga kjone kjone swl̈o obl̈ë obl̈ë, kjone kjone goshko Ä sëyaga, ga poptara Jesúsdë beno pjl̈úe. Kjl̈ara ko María Magdala so. Dämärshko ga Ä sëyaga tjeng ba goshko dogl̈o kjäk (7) l̈i ichara to uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kjl̈ara obi ko Juana, e Cuza boy. Cuza, e parkë shäng Herodes kong, ba l̇l̇ëbo daga. Kjl̈ara obi ko Susana. Jesús kjimte wal̈ëga l̈irë l̈öng, ba dbur baĩya l̈i go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pjl̈ara ga oba shrono kjok shto obl̈ë obl̈ë dwayo ga töno ara Jesús sök l̈ishko. Eshko ga Jesús tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Domer shäng kjl̈ara dwl̈a sguingga. Pjl̈ara ga opshino to jek dwl̈a sguing. Sguĩyashko ga kjone kjone l̈ono tjeng irbo bäng, ga shgl̈ëraba, uara sënwarë drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kjone kjone l̈ono tjeng ak ara tjrëko. Gueniyo kl̈ung sho l̈i shgl̈ëk l̇l̇ëm kjĩshko ga dwl̈a l̈i wenoshko ga danoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dwl̈a kjrina obi, e l̈ono tjeng shkö sho roshko, ga wenoshko ga l̇l̇gwĩna drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dwl̈a kjrina obi, e l̈ono tjeng kl̈ung sho pjl̈ú kjing go, ga kuno, botjyono pjl̈úe. Kjoneshko ga sok kjwara botjyono kjwo sak dbäw (100)» l̈e. E irgo ga tjl̈ẽ ba kong jek sira obi ga «Ëye kwomgwo tjok ga woyde ga kuya yõtso» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","E irgo ga Jesús oppinggaga tjl̈ẽ l̈ok ba kong ga «Rokërwa bop kong sira ga l̇l̇ëye l̈orop l̇l̇ëbo jyãgl̈o go l̈i, e l̇l̇ë l̈okl̈o pjl̈ol̇l̇gwes borwa kong, miydërwa wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kuya ga tjl̈ẽ ba kong ga «Sbö ber no pjl̈uyo sorë l̈i roy miydaydëba l̇l̇ëm l̈i pinaba bomi kong, miydëmi wl̈o. Gueniyo nopga obl̈ë kongda, l̈ër l̇l̇ëbo jyãgl̈o go erä. Eni ga »“Ĩya l̈öng ga l̇l̇ë ĩyde miyde l̈ok l̇l̇ëm, kuya l̈öng ga l̇l̇ë l̈okl̈o miyde l̈ok l̇l̇ëm bakoe.” ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","»Dwl̈a sguingga l̈anyo, e l̇l̇ë l̈okl̈o l̈ër bomi kong. Dwl̈a l̈i, e Sbö tjl̈õkwo l̈okl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dwl̈a l̈ono irbo bäng l̈i, e ëye Sbö tjl̈õkwo kuno l̈i l̈okl̈o. Gueniyo Ä tjwe eshko, ga döya ba pjl̈úshko dwayo, tjl̈õkwo l̈i kjre l̇l̇ëm wl̈o. Eni ga epga där l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dwl̈a l̈ono ak ara tjrëko l̈i, e ëye tjl̈õkwo l̈i kuno ga beno shäng wopjl̈ú l̈i l̈okl̈o. Gueniyo tjl̈õkwo l̈i äär ber ba pjl̈úshko jl̈õkoyo l̇l̇ëm kjĩshko ga tjl̈õkwo l̈i kjre dbar kjwöbö erä. E irgo ga l̇l̇ëye wen ba kong sira tjl̈õkwo l̈i kjĩshko ga raye, söya ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Dwl̈a l̈ono shkö sho roshko l̈i, e ëye tjl̈õkwo l̈i kuno l̈i l̈okl̈o. Tjl̈õkwo l̈i kura, gueniyo wotjl̈ĩk sök ara, wo pjang dbur go, l̇l̇ëbo pjl̈ú kjok ëre kjing goshko l̈i woyotjl̈ĩya ara bakoe. E kjĩshko ga tjl̈õkwo l̈i woyo ba kong ame, ga bo wen tjl̈õkwo l̈i kjĩshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","E ga dwl̈a l̈ono kl̈ung sho pjl̈ú kjing go l̈i, e ëye tjl̈õkwo l̈i kuno, ga kjre jl̈õkoyo ba pjl̈úshko l̈i l̈okl̈o. Kjre, ga söya ĩyado, ga bo wen tjl̈õkwo l̈i kjĩshko arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","»Iök shjiy borkey, kjinguëy wl̈o l̇l̇ëm, jney bi bukkl̈o dorko wl̈o l̇l̇ëm bakoe. Iëy jong kjókshko dey, nopga opzrëk jek eshkoshko ga kãl̈ã të shjiy wẽl̈ë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","L̇l̇ëbo jney, miydëba jekdo l̇l̇ëm wl̈o. Gueniyo l̇l̇ono ga e miydëba dret, iök shjiy iak jong kjókshko wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","E kjĩshko ga bor tjl̈õkwo kuzĩ yõtso, miydëmi pjl̈ú wl̈o. Ëye l̇l̇ëbo tjok ga së̃ya jek obi. Ëye l̇l̇ëye l̇l̇ëm ga l̇l̇ëye tjeng sirawa l̈i döya ba shjiryo drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Eshko ga Jesús mekë, ba l̈ëmga, e shrono tjeng Jesús sök l̈ishko, gueniyo öötong ba soshko l̇l̇ëm, oba ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","E kjĩshko ga roy l̈araba Jesús kong ga tjl̈ẽ ga «Bop mekë, bop l̈ëmga, e shrono tjeng bop ĩk kjoko» l̈ëba. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kuya ga tjl̈ẽ ba kong ga «Ëye, Sbö tjl̈õkwo kura, ga kol̈e ga era bor mekë wl̈eni, bor l̈ëng wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dbar kjwara ga Jesús opyono kjyong roshko ba oppinggaga tjok, ga tjl̈ẽ ba kong ga «Shji to dipzë, di bäng buk kësbang ëre kjwo kal̈ëkong» l̈e. Ga jek l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jek l̈öng dipzë wopro ga Jesús ponoe. Eshko ga pjl̈uk tjwe jong träk l̇l̇ëm, dbo ara di bäng buk kësbang l̈i kjing go. Di iõya ara, ga di dl̈in jong kjyong l̈i roy, pir sek seke. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eni ga ba oppinggaga äär l̈öng ba wol̇l̇eng, tjl̈ẽ ba kong ga «¡Tjl̈apga, shji ba pitoe!» l̈e. Kuya ga kojono, ga pjl̈uk, di iõya, e wl̈ona, ga beno tjeng tjëkso. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Eshko ga tjl̈ẽ ba oppinggaga kong ga «¿Pjãy oto? ¿Pjãy mär bor go l̇l̇ëm ega?» l̈e. Eshko ga epga beno l̈öng sëya l̇l̇ëm, kjok bangkjre l̈ok ara bakoe. Ga tjl̈ẽ ëng kong ga «¿Domer kjwe ëro? Tjl̈ẽno pjl̈uk, di iõya l̈i kong ga kol̈e pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","E irgo ga öötong l̈öng Gadara kjokyo, di bäng buk kësbang l̈i kjwo kal̈ëkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Eshko ga domer shäng kjl̈ara, goshko Ä sëya kjl̈ara. Shäng dbar kop ara ga shwong pjung l̇l̇ëm, sök u roshko l̇l̇ëm, jëk to shäng sakshko erä. Ba orkwo, ba dre, e kjrocharaba dröng sho go pjl̈ogl̈o kop ara, där l̇l̇ëm wl̈o l̈araba, gueniyo shaya sëya l̈irëshko ga ba dröng sho l̈i skoya jek tas tas erä, ga iche sëya l̈irë kjok dogro no l̇l̇ëmshko. Eni ga Jesús opshino jek shäng kjyong roy dwayo l̈i ĩya sakshko dwayoshko ga tek shrono shäng ba zl̈ong bäng ga kjök tono. Ĩya Jesúsdë ga tjl̈ẽ ba kong ga «¡Ä sëya, pja opkjos domer kjwe go dwayo!» l̈e. E kjĩshko ga sëya l̈i tjl̈ẽ ba kong dbo go ga «¡Sbö Tjwl̈õ Kësbangyo Wa l̈i pja! ¡Pja tek shäng bor barwë l̇l̇ëme! ¡Rokër bop kong sira ga tja shdum l̇l̇ëme!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kuya ga tjl̈ẽ ba kong ga «¿Pja ko l̇l̇ë?» «Tja ko Kop Arae» l̈e ba kong. L̈ara eni, Ä sëyaga tjeng domer l̈i go ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eni ga rokara Jesús kong ga iche Ä sëyaga shdũzl̈ong shtoyo l̇l̇ëme l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Epga l̈öng l̈ishko soshko ga köchi tjeng träk l̇l̇ëm dl̈up pogl̈o go, ië. Eni ga rokara Jesús kong ga iche jek köchi tjeng l̈i go. Kuya ga «Jöl̈ö» l̈e, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ga sëyaga l̈i opkjono l̈ok domer l̈i go dwayo, ga jek l̈ok köchi l̈i go shara. Wop eni l̇l̇ëm ga köchi tjeng l̈i zrono jer ri ri dl̈up pogl̈o go, optono l̈ok jer uunkong di bäng buk kësbang l̈i roshko, ga shteno l̈ok dret eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ĩya köchi dagaga tjeng l̈irë ga töktong jek ey dwayo, ga öötong l̈öng nopga l̈öngshko ga l̇l̇ëye shäryono l̈i roy l̈ara nopga kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kuya l̈ok ga tek shrono l̈öng ara ba ĩk. Shrono Jesús shäng l̈ishko ga ĩya l̈ok ba zl̈ong bäng ga domer dämär ga goshko Ä sëya l̈i, e wl̈ẽna l̈ok bë sök eshko, doyono pjir shwong go, skwẽ ame, poptono sök pjl̈úe. Ĩya l̈ok eni ga beno l̈öng sëya l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Domer goshko Ä sëya l̈i poptara sorë, e l̈ara ba ĩgaga tjeng eshko l̈irë nopga shrono tjeng l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Eshko ga kjok eshko sopga uunkong tjl̈ẽ Jesús kong ga «Rokërwa bop kong sira ga pja opshis kjok ëreshko dwayo» l̈e. L̈ara eni, kjok bangkjre l̈ok ara kjĩshko. Kuya ga jl̈õ l̈ara, jer opyë sök kjyong l̈i roy. Eshko ga domer poptono l̈i tjl̈ẽ ba kong ga «Rokër bop kong sira ga tja ios jek bop tjok.» «L̇l̇ëme. Pja nom bop ushko iröng dey. L̇l̇ëye shäryara Sbörë bop kong l̈i, e l̈ëp oba kong, miydëba wl̈o» l̈e ba kong. E irgo ga Jesús to ey dwayo. Eni ga jl̈õ l̈ara domer l̈irë, ga to jek kjok eshko kjwang jĩkong. Eshko ga e poptara Jesúsdë sorë l̈i roy l̈e öötong shäng oba kong eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús dipzono jek di bäng buk kësbang l̈i kjwo kal̈ëkong iröng obi. Öötong shäng di kjako ga oba töno l̈öng träk l̇l̇ëm eshko ba wl̈okjrë. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Eshko ga domer shäng kjl̈ara ko Jairo. Judíoga syõ uyo jong eshko l̈i kägäyoga shäng kjl̈ara l̈i e. Ba wa wal̈ë kjl̈araso l̈i wol̈ontoe. E l̈u pjl̈ogl̈o sak kjwara kjingsho pjök (12) erä. E kjĩshko ga Jesús ĩya ga tek shrono shäng ba zl̈ong bäng ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, ga rokara jek ba ushko. Kuya ga «Jöl̈ö» l̈e, ga to jek ba tjok. Oba ara kjĩshko ga Jesús jëk shängshko ga pol̇l̇ikoba arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","L̈öng l̈i tjrëko wal̈ë shäng kjl̈ara swl̈o ara l̈u pjl̈ogl̈o sak kjwara kjingsho pjök (12) tjän. Ba dbar ĩya ĩyado, poptë l̇l̇ëme. Öör shäng dwl̈omnega ara shwoy, ga ba dburwa tjeng l̈i zana drete. Eni ëmdë ga poptono l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Eshko ga tek shrono shäng Jesús zl̈ong bäng ba kokso shwo l̈ëkong ga ba shwong worbo porwara, ga poptono jekdo eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eni ga Jesús tjl̈ẽ oba kong ga «¿Tja porwaga ërë?» l̈e. Kjl̈ara kjl̈ara tjl̈ẽ ga «Tja l̇l̇ëme» l̈e l̈ok ba kong eni. E kjĩshko ga Pedro tjl̈ẽ ba kong ga «Tjl̈apga, nopga ara kuzong ga pja pol̇l̇iya l̈öng pjl̈or kar kare» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gueniyo kuya ga tjl̈ẽ ba kong ga «Tja porwara ëborë, e miydorore. Kuror ga ëbo poptono, bor dbo kësbang go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Eni ga miydara wal̈ë l̈irë ga Jesús porwara l̈i beno l̈ũtshko l̇l̇ëme. Eni kuzong ga tek shäng Jesús zl̈ong bäng ga kjök tono sök kjl̈o dete erä. Eshko ga nopga uunkong bokso ga porwara ega, poptono jekdo sorë, e l̈ara ba kong pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kuya ga tjl̈ẽ ba kong ga «Pja mär bor go kuzong ga pja poptonoe. Pja nom wopjl̈ú bop ushko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús tjl̈ẽ shäng wal̈ë l̈i kong wopro ga no tek Jairo ushko dwayo shrono shäng kjl̈ara ga tjl̈ẽ Jairo kong ga «Bop wa yẽ shinmotkonoe. Tjl̈apga no pingga kjwe twëy tjötö ame» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kuya Jesúsdë ga jl̈õ l̈ara l̇l̇ëme. Tjl̈ẽ Jairo kong ga «Pja woydë l̇l̇ëme. Pja mär bor go ga bop wa poptë dani» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","E irgo ga Jesús öötong shäng Jairo ushkoshko ga Pedro, Santiago, Juan, Jairo, Jairo boy, epgara ichara opzrëk jek ba tjok. No obl̈ëra ichara opzrëk l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Eshko ga nopga sl̈ar wopjl̈uk jong träk l̇l̇ëm, kjl̈oshtë ara bakoe. Jesús opzrëno jek u l̈i roshkoshko ga tjl̈ẽ l̈öng l̈i kong ga «Pjãy sl̈ar ame. Kjogl̈o, e wol̈ono l̇l̇ëme. Buk pë erä» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kuya l̈ok ga Jesús joywe l̈ok jong erä. Miyde l̈ok ga kjogl̈o l̈i shinmotkonoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eni ga Jesús opzrëno jek öötong shäng kjogl̈o buk l̈ishko, orkwo shara, ga tjl̈ẽ ba kong dbo go ga «Kjwozirwa, pja kojõzong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jekdo eshko ga kjogl̈o l̈i woshrono, ga kojono shäng. Eni ga ba data, ba mekë, e ichara Jesúsdë ba sëng. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Eshko ga epga beno l̈öng yëy l̈e erä. Gueniyo ga Jesús tjl̈ẽ ba kong l̈ok ga «L̇l̇ëye shäryono jũshko ëre l̈ëmi ë kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","E irgo ga Jesús, ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i rokara, ga kong dbo twara, Ä sëya obl̈ë obl̈ë tjeng oba goshko l̈i iche to wl̈o, swl̈o obl̈ë obl̈ë popte wl̈o bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ga ichara Sbö ber no pjl̈uyo sorë l̈i roy l̈ë oba kong, swl̈opga poptë bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Eni ga tjl̈ẽ ba kong ga «Pjãy brikshko ga l̇l̇ëye sömi l̇l̇ëme. Pjãy kjorkung sök l̇l̇ëm, kjl̈a l̇l̇ëm, dl̈i l̇l̇ëm, dbur sho l̇l̇ëm bakoe. Shwong pjang bomi do go l̈i sömi ga pjl̈ú, gueniyo shwong obl̈ëra sömi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pjãy äär kjone pogo ga pjãy ber l̈öng u kjwaraso, äär jong pjãy opshik kjok eshko dwayo guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pjãy öötong l̈öng kjone ga pjãy wl̈okjre l̇l̇ëm wl̈eni ga pjãy opshik eshko dwayo, ga bomi dre pjl̈ungyo l̈ö̃zĩ ber tjeng eshko. E ber pjãy kura l̈ok l̇l̇ëm l̈i jyãgl̈o, ga owa l̈i ber pjang ba go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eni ga epga to jek l̈öng kjok kjrinashko kjrinashko, Sbö tjl̈õkwo roy pjl̈ú l̈ë oba kong, ga swl̈opga popte l̈ok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","E dbaryo ga l̇l̇ëye shärye Jesúsdë shäng l̈i roy shdöktong ara. Ga kura Pjl̈u Herodesdë, ga beno sök wotjl̈ĩk ara. No kjone kjone tjl̈ẽ ga «E Juan No Waga l̈i woshrokdo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kjone kjone obi tjl̈ẽ ga «E Sbö tjl̈õkwo l̈aga tek dënashko so Elías tjwayde shäng» l̈e. Kjone kjone obi tjl̈ẽ ga «E Sbö tjl̈õkwo l̈agaga tek dënashko so kjl̈ara l̈i woshrokdo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Gueniyo Herodes tjl̈ẽ ga «E l̈anyotkëba ara. ¿Eni ga ë l̈ëba? ¿E Juan woshrokdore? Nopga ichaga tjarë om go, Juan kägä zë tase» l̈e eni. Eni ga dröno ara, ĩya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sbö tjl̈õkwo roy l̈agaga Jesús ãska l̈i shrono l̈öng iröng obishko ga l̇l̇ëye shäryara l̈ok l̈i l̈ara l̈ok Jesús kong pjire. E irgo ga epga töna Jesúsdë tjeng dboy, ga söra jek öötong l̈öng kjok ko Betsaida. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gueniyo ga miydara kjok eshko sopgarë, ga to jek l̈ok ba irgo. Shrono l̈öng ba shwoy ga nopga l̈i wl̈okjrara, ga Sbö ber no pjl̈uyo sorë l̈i roy l̈ara ba kong, ga swl̈opga söra l̈ok tjeng eshko l̈i poptara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kjok sëng ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i tek shrono l̈öng ba zl̈ong bäng ga tjl̈ẽ ba kong ga «Kjok ëreshko l̇l̇ëye drete. Pjl̈ú wl̈o ga nopga kjwe ichos to na dwayo, jek l̇l̇ëbo soynekoba kjone l̈ishko, dl̈i tjwl̈ẽk wl̈o, pozl̈ong shtoyo wl̈ẽk wl̈o bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kuya ga tjl̈ẽ ba kong ga «Së̃zĩ pjãydë dey» l̈e. Kuya l̈ok ga tjl̈ẽ ba kong ga «Ëreshko tjawa pjl̈ung shosho suk pjir tjeng kjwo shkëng (5), mã tjeng do pjökdewa erä. ¿Woydëp ga tjawa jongya dl̈i tjwl̈ẽk nopga tjeng kës ëre kongde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Eshko ga domerga tjeng dogl̈o sak dbäw dbäw pjl̈ogl̈o shkëng (5,000) dik. Wal̈ëga, kjwozirga, e shtak l̇l̇ëme.) Eni ga Jesús tjl̈ẽ ba kong ga «Nopga kjwe ichozĩ wl̈ar tjeng töshko, shtor shtor, dogl̈o sak shkëng (50) sak shkëng (50)» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kuya l̈ok ga shäryara eni, ga nopga l̈i wl̈oktong tjeng töshko uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pjir ga pjl̈ung shosho suk pjir kjwo shkëng (5) l̈i, mã do pjök l̈i, e kjrara Jesúsdë, ga kjok dogo ĩya jem drëng ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga dl̈i l̈i twara ba oppinggaga kong, pjl̈orgue l̈ok nopga tjeng kës l̈i kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nopga uunkong iono beno l̈öng bö tjung, wopjl̈úe. E irgo ga dl̈i worbo töna ba oppinggagarë l̈ok shing roshko, beno tjeng shing kjwo sak kjwara kjingsho pjök (12), tjung tjunge. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pjl̈ara ga Jesús sök syõshtë Sbö kong. Ba oppinggaga l̈öng ba tjok eröe. Eshko ga tjl̈ẽ ba kong l̈ok ga «¿Kumi ga tja ë l̈ëba?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","«No kjone kjone tjl̈ẽ ga pja Juan No Waga l̈i woshrokdo l̈e. Kjone kjone obi tjl̈ẽ ga pja Sbö tjl̈õkwo l̈aga tek dënashko so Elías tjwayde shäng l̈e. Kjone kjone obi tjl̈ẽ ga pja Sbö tjl̈õkwo l̈agaga tek dënashko so kjl̈ara l̈i woshrokdo l̈e» l̈e l̈ok ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kuya ga tjl̈ẽ ba kong ga «E ga pjãye, ¿tja ë l̈ëmi?» l̈e. Kuya Pedrorë ga tjl̈ẽ ba kong ga «No pjl̈uyo ichara Sbörë shrono shäng l̈i, e pja» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kuya ga tjl̈ẽ ba kong l̈ok ga «Tja ë l̈ëmi ë kong l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Eshko ga tjl̈ẽ ba kong obi ga «Äär dbar kjwara ga no to ter kjok dogo dwayo ëre shdungoba ara guing. Judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, tja wl̈okjre l̈ok l̇l̇ëme. Ga tja zrökoba, gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","E irgo ga tjl̈ẽ uunkong kong ga «Ëye jëk woydë bor tjok jl̈õkoyo ga ber shäng bor woyotjl̈ĩk ĩyado, wotjl̈ĩk l̇l̇ëbo shäryë kjok ëre kjing goshko ame bakoe. Bor kjĩshko ga l̇l̇ëye shäryëba ba kong l̇l̇ë pogoshko l̈i, e zrökoba pjang kjl̈ös go ëmdë ga e ba kong ga l̇l̇ëye l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ëye wotjl̈ĩk opdë om go, zrökoba bor kjĩshko l̇l̇ëm wl̈o l̈e ga äär kjok dogo l̇l̇ëme. Gueniyo ëye jëk bor tjok jl̈õkoyo, e zröraba bor kjĩshko ëmdë ga era ber sök së ĩyado kjok dogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ëye, l̇l̇ëbo tjeng kjok ëre kjing go kës l̈i kjrara tjeng ba wl̈oy ëmdë ga e l̇l̇ëno l̇l̇ëme. Wol̈ono ga öötong kjok dogo l̇l̇ëm ga to jeno ba l̇l̇ëbo l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","»L̇l̇ono ga no to ter kjok dogo dwayo ëre tjwe bor dbo kãl̈ã goshko, Data Sbö dbo kãl̈ã go, bor parkagaga kjok dogo so tjok. Eerishko ga ëye, tja l̈ökyokjre oba bokshto ga eshko ga l̈ökyokjrër eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","L̈ër bomi kong jl̈õkoyo ga pjãy kjone kjone l̈öng ëreshko wol̈ontë l̇l̇ëm obishko ga Sbö ber no pjl̈uyo sorë l̈i ĩmi wẽl̈ëe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Dbargwo kjwong (8) irgo ga Pedro, Santiago, Juan, e söra Jesúsdë jem ba tjok dboshko, ga öötong l̈öng dl̈up jong kjwara kjókshko l̈i go, syõshtë Sbö kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eshko ga Jesús syõshtë Sbö kong wopro ga ba bokkwo kjl̈opswono, shwong beno pjl̈ubl̈ún, kãl̈ã l̇l̇etl̇l̇ete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Eshko ga Moisés, Elías, e weno l̈öng l̈an ba tjok, kãl̈ã të shjiye. Ga wop tjok ga Jesús zrökoba Jerusalén kjokyo sorë l̈i l̈anyotke l̈ok ëng tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ba oppinggaga tjeng eshko l̈i l̈öng poywõ erä. Gueniyo pol̇l̇äk ga ĩna l̈ok ga Jesús kãl̈ã shjiye. Domerga l̈öng do pjök ba tjok l̈i ĩna l̈ok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Domerga l̈i brik l̈ok kjwl̈ëshko ga Pedro tjl̈ẽ Jesús kong ga «Tjl̈apga, tjawa l̈öng na ga pjl̈úe. Tjawa ukwang shäryë kjwo mya, bop kong kjwara, Moisés kong kjwara, Elías kong kjwara bakoe» l̈e. L̈ara eni, gueniyo l̇l̇ë l̈ayde shäng l̈i miyde shäng l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Shäng tjl̈ẽ wopro ga pjäng sho l̈ono ter kjrina ba kjing go, ga ba oppinggaga l̈i beno kjok bangkjrë ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ga pjäng sho l̈i roshko dwayo ga ybö kura l̈ok ga tjl̈ẽ ga «Bor wa l̈i ëre. E kjroror. Ba tjl̈õkwo kuzĩa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kura l̈ok pjir ga ĩya l̈ok ga Jesús beno shäng kjl̈araso. Dbar eshko ga beno l̈öng kjing, l̇l̇ëye ĩna l̈ok l̈i l̈ara ë kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wẽshko ga ter shrono dl̈up l̈i dwayoshko ga nopga shrono l̈öng träk l̇l̇ëm, Jesús ĩk. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eshko ga domer shäng kjl̈ara nopga tjeng l̈i tjrëko. Tjl̈ẽ Jesús kong dbo go ga «Tjl̈apga no pingga, rokër bop kong ga bor wa domer ëre ĩs sira. Tja wa obl̈ë drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ol̈ö ga shaya Ä sëyarë, ie öö l̈e, dbukza rish buk töshko, jek kjl̈o dete, ga kjamo ber bung erä. Shärye owa eni wop sit wop sit. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tja tjl̈ẽno bop oppinggaga beno tjeng ëreshko wl̈e kong ga “Bor wa ëre, goshko Ä sëya kjl̈ara. Rokër bomi kong ga ichozĩ to bor kong sira” l̈oror, gueniyo to ichara l̈ok l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kuya ga tjl̈ẽ l̈öng l̈i kong ga «Pjãy wotjl̈ĩk owa. Pjãy mär Sbö go l̇l̇ëme. ¿Tja ber shäng bomi tjok kjër äär jong l̇l̇ono, pjãy mär ber l̈öng ba go wl̈o? Tja sjeno shäng bomi tjok tjän» l̈e. Eshko ga tjl̈ẽ domer l̈i kong ga «Bop wa tek sös bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Eni ga dwl̈as l̈i söya l̈ok jek shäng äätë ba zl̈ong bäng ga dwl̈as l̈i dbura sëya l̈irë rish buk töy, jek kjl̈o dete erä. Eshko ga sëya l̈i wl̈ona Jesúsdë, ga dwl̈as l̈i poptara, ga twara iröng ba data kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ĩya nopga tjeng eshko l̈irë ga beno l̈öng yëy l̈e erä, Sbö dbo ara kjĩshko. L̇l̇ëye shäryara Jesúsdë l̈i woyotjl̈ĩkoba l̈öng wopro ga tjl̈ẽ ba oppinggaga kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«L̇l̇ëye l̈ër bomi kong l̈i kuzĩ yõtso, woyojemi l̇l̇ëme. No to ter kjok dogo dwayo ëre twëba ber tjeng nopga wl̈oshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Gueniyo ga l̇l̇ëye l̈e shäng l̈i l̇l̇ë l̈okl̈o miydara l̈ok l̇l̇ëm, e jnena Sbörë beno, miyde l̈ok l̇l̇ëm wl̈o kjĩshko. Ga l̇l̇ë l̈okl̈o kjakrokara l̈ok ba kong l̇l̇ëm, bangkjre l̈ok ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","E irgo ga ba oppingga kjl̈ara tjl̈ẽ ga «Tja ber tjwl̈õ ara pjãy uunkong kjinmo» l̈e kjl̈ara obi kong. Kuya ga tjl̈ẽ ga «L̇l̇ëme. Ber tjwl̈õ ara l̈i tja» l̈e. Ga l̇l̇amoga oml̈ë jong eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","L̇l̇ëye l̈e l̈öng l̈i miydara Jesúsdë drete. Eni ga kjwozirwa kjrara kjl̈ara, ga iara shäng ba zl̈ong bäng, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ga tjl̈ẽ ba oppinggaga kong ga «Ëye, kjwozirwa ëre wl̈okjrara bor kjĩshko ga tja wl̈okjrara wl̈eni. Ga ëye, tja wl̈okjrara ga bor ichaga wl̈okjrara wl̈eni bakoe. Bomi tjrëko ga ëye shäng kjl̈ara wotöy anmoyõ ga tjwl̈õ ara anmoyõ l̈i e» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","E irgo ga Juan tjl̈ẽ ba kong ga «Tjl̈apga no pingga, domer ĩnorwa shäng kjl̈ara, Ä sëyaga tjeng oba goshko l̈i iche to shäng bop ko go. Gueniyo ga e bop oppingga bi tjok l̇l̇ëm kjĩshko ga tjawa tjl̈ẽno ba kong ga “Ä sëyaga ichëp Jesús ko go ame” l̈ororwa eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kuya ga tjl̈ẽ ba kong ga «¡Wẽyẽ! “Shäryëp ame” l̈ëmi ba kong l̇l̇ëme. Ëye shäng bi wl̈oyo l̇l̇ëm ga shäng bi shwo l̈ëkong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Eshko ga Jesús jem kjok dogo iröng obi wl̈o dbaryo l̈i ääto, ga wotjl̈ĩk ga to jongya Jerusalén kjokyo, l̈ara jong kjwaraso eni. Ga to jek ba nopga tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jëk l̈öngshko ga nopga ichara pjök mya ba bäm go ba roy söga wl̈eniyo. Eni ga ba roy sögaga l̈i öötong l̈öng bäm go Samaria kjokyo kjrina, pozl̈ong shtoyo wl̈ẽk l̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gueniyo ga miydara Samaria sopgarë ga jongya jong Jerusalén kjokyo. E kjĩshko ga wl̈okjrara l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Roy kuya ba oppinggaga Santiago, Juan l̈irë ga tjl̈ẽ l̈ok Jesús kong ga «Tjl̈apga, ¿woydëp ga tjawa iök l̈ong ter kjok dogo dwayo, epga pjir wl̈ore?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kuya ga bojono ba shwo l̈ëkong ga wl̈ongza tjã tjã erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Eshko ga jek l̈ok kjok shto obl̈ë. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eni ga jek l̈öng irbo wopro ga no shäng kjl̈ara eshko tjl̈ẽ Jesús kong ga «Tjl̈apga, woydër ga pja jek kjone ga tja jek bop tjok eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kuya ga tjl̈ẽ ba kong ga «Shjiti kjl̈oshko so, e pë kl̈ung bäng. Sënwa, e pë ba usho roy. Gueniyo no to ter kjok dogo dwayo ërera woshtozl̈ong shtoyo drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","E irgo ga tjl̈ẽ obl̈ë kong ga «Pja tek bor tjok, pja pin wl̈o» l̈e. Gueniyo kuya ga tjl̈ẽ ba kong ga «Tjl̈apga, tja ichos jek bor data ushko sira. Bor data wol̈ono, jnenor sakshko pjir ga tja tekdo iröng bop tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kuya ga tjl̈ẽ ba kong ga «Shinmoga ber tjeng ëng jnek wẽyẽ. Pja nom Sbö ber no pjl̈uyo sorë l̈i roy l̈ë oba kong dey» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","E irgo ga no shäng kjl̈ara obi tjl̈ẽ Jesús kong ga «Tjl̈apga, tja jek bop tjok l̈ër. Gueniyo tja koshëp sira, “Tja toe” l̈ër bor pjeyoga kong guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kuya ga tjl̈ẽ ba kong ga «Ëye ba pak soyono, ga wotjl̈ĩk l̇l̇ëbo beno iröng l̈i kjĩshko ga e l̇l̇ëno l̇l̇ëm Sbö ber no pjl̈uyo l̈ishko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","E irgo ga nopga jek l̈öng ba tjok l̈i kjrara Jesúsdë dogl̈o sak kjäk kjingsho pjök (72). To kjok shto obl̈ë obl̈ë l̈e l̈ishko ga epga ichara jek l̈öng pjök pjök ba bäm go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Eshko ga tjl̈ẽ ba kong ga «Dwl̈a bo kjrëy wl̈o ga ara, gueniyo parkagaga kjl̈öbö döe. Eni ga rokozĩ dwl̈a sogo l̈i kong ga parkagaga wl̈ẽya obi, dwl̈a bo ara l̈i kjre wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eni ga pjãy nomo. Pjãy to l̈öng sjëke. Pjãy ichër jek l̈öng öng wl̈ẽp ushko so l̇l̇gwokl̈ë jëk l̈öng shjiti kjl̈oshko so l̈öngshko wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pjãy brikshko ga pjãy dbur sök l̇l̇ëm, kjl̈a sök l̇l̇ëm, drepkwota sök l̇l̇ëm bakoe. Pjãy jëkko eröe. No wl̈ẽmi irbo ga “Miga” l̈ëmi ba kong l̇l̇ëm, pjãy jek bek eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pjãy äär ber l̈öng kjone ga pjãy opzrëk jek u jong kjwara eshko l̈i roshko, ga pjãy tjl̈ẽs nopga tjeng eshko l̈i kong ga “Miga. Rokër Sbö kong ga pjãy l̈öng u ëreshko uunkong ie ber l̈öng wl̈ẽpe” l̈ozĩ ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Eshko ga pjãy wl̈okjre l̈ok wopjl̈ú wl̈eni ga epga ie Sbörë ber l̈öng wl̈ẽp jl̈õkoyo. Gueniyo pjãy wl̈okjre eni l̇l̇ëm ga epga kjimte Sborë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pjãy öötong l̈öng kjone pogo ga pjãy to l̈öng u kjwara kjwara l̇l̇ëm, pjãy ber l̈öng u kjwaraso dey. Ëye parkë ga e potjwl̈ẽkko ba pak l̈i ãska. E kjĩshko ga pjãy së̃ya l̇l̇ë ga uozĩ, bomi potjwl̈ẽkkl̈o l̈i e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","»Pjãy öötong l̈öng kjone pogo ga pjãy wl̈okjre nopga eshko sorë wl̈eni ga pjãy së̃ya l̇l̇ë ga uozĩ, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","swl̈opga l̈öng eshko l̈i poptozĩ, ga pjãy tjl̈ẽ nopga l̈öng l̈i kong ga “Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo döröe” l̈ëmi ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","»Gueniyo ga pjãy öötong l̈öng kjok kjrina ga pjãy wl̈okjre nopga eshko sorë l̇l̇ëm ga pjãy to l̈öng jëk irbo pjl̈ara pjl̈ara tjwe l̈ok l̈i go, ga pjãy tjl̈ẽ kjok eshko sopga l̈i kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bomi kjokshko pjl̈ungyo pjono borwa dre go l̈i l̈önwa ber tjeng jũshko, pjãy shdungko l̈okl̈o. Gueniyo miydozĩ pjl̈ú ga Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo döröe” l̈ëmi ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","L̈ër bomi kong ga no l̇l̇gwezl̈ong dbaryoshko ga kjok eshko sopga shdũya Sbörë ara, Sodoma sopga kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","E irgo ga tjl̈ẽno nopga kjok shto obl̈ë obl̈ë l̈i kjĩshko. Tjl̈ẽ ga «¡Corazín sopga, Betsaida sopga, pjãy song jl̈õ, pjãy shdungko! L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryoror bomi kong l̈i ĩna Tiro sopga, Sidón sopgarë tek dënashko kjwe ga l̇l̇ëbo owa shärye l̈öng l̈i, e owa jl̈õe l̈ara, ga rayara, ga shwong pjuna shtëgro së ä wl̈eniyo, pjl̈ung sho iara ba dl̈u kjing go, ba woowa l̈i ĩya Sbörë wl̈o tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Eni ga no l̇l̇gwezl̈ong dbaryoshko ga pjãy shdũya Sbörë ara, Tiro sopga, Sidón sopga, e kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","»Capernaúm sopga, ¿pjãy wotjl̈ĩk ga pjãy söya Sbörë jem äär kjok dogo l̈ëmiro? Eni l̇l̇ëme. Pjãy iche jer äär iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Eshko ga tjl̈ẽ ba oppinggaga kong ga «Pjãy tjl̈õkwo kjraga ërë ga e bor tjl̈õkwo kjrayde wl̈eni. Ëye, pjãy wl̈okjrara l̇l̇ëm ga tja wl̈okjrara l̇l̇ëm wl̈eni. Ga ëye, tja wl̈okjrara l̇l̇ëm ga bor ichaga wl̈okjrara l̇l̇ëm wl̈eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Eni ga nopga dogl̈o sak kjäk kjingsho pjök (72) l̈i toe. Tjl̈õkwo l̈ara l̈ok kjok shto obl̈ë obl̈ë pjir ga tek shrono l̈öng wopjl̈ú iröng obi. Eshko ga tjl̈ẽ l̈ok Jesús kong ga «Tjl̈apga, Ä sëyaga ëmdë ga tjawa bangkjre. Epga ichororwa bop ko goshko ga tjawa kol̈ara» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kuya ga tjl̈ẽ ba kong ga «Eni jl̈õe. Ĩnor ga Ä zana Sbörë, ga e l̈ono ter kjok dogo dwayo l̇l̇gwl̈ëng wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ga pjãy kong dbo tworor kësbang, bi moskwo kësbang l̈i zami wl̈o, ga l̇l̇ëye wen owa bomi kong l̇l̇ëme. Dgur shgl̈ëmi, dyë shgl̈ëmi ëmdë ga l̇l̇ëye wen owa bomi kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","¿Gueniyo pjãy l̈öng wopjl̈ú, pjãy kol̈e Ä sëyagarë kjĩshko egaro? Pjãy kol̈e eni l̈i tjwl̈õ ara l̇l̇ëme. Pjãy ko tak l̈ok kjibokwo go kjok dogo l̈ira tjwl̈õ ara. Woyde ga pjãy ber l̈öng wopjl̈ú e kjĩshko shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jekdo eshko ga go Sbö Sëya jl̈õkoyo kjĩshko ga Jesús beno shäng wopjl̈ú ara, tjl̈ẽ Sbö kong ga «Data, pja kjok dogo sopga, kjok ëre sopga, e Tjl̈apga. L̇l̇ëye jnenop kjok miydagaga l̈öng kong l̈i pinop oba song, wotöy wl̈eniyo kong. E kjĩshko ga pja poshrër ara. Shäryorop eni, woydorop eni kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Eshko ga tjl̈ẽ nopga kong ga «L̇l̇ëbo uunkong iara Data Sbörë beno tjeng bor wl̈oshko. Sbö Wa ëre sorë, e miydaga ërë l̇l̇ëm, e miydaga bor Datarë eröe. Data Sbö, e sorë miydaga ërë l̇l̇ëm, e miydaga tjarë eröe. Gueniyo e sorë pin woydë ë kong ga pin» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","E irgo ga ba oppinggaga ĩya ga tjl̈ẽ ba kong tjoksa ga «L̇l̇ëye shäryër l̈i ĩmi l̈öng bomi bokkwo go. Ëye omĩno ga era ber wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","L̈ër bomi kong ga l̇l̇ëbo ĩmi, kumi l̈öng ëre tjwl̈õ ara. Dënashko ga Sbö tjl̈õkwo l̈agaga, pjl̈upga, e omĩk woydë, omkuk woydë, gueniyo omĩno l̇l̇ëm, omkuno l̇l̇ëm bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Domer shäng kjl̈ara, kjok l̇l̇gwekkl̈o tara Moisésdë l̈i miydaga pjl̈ú wl̈eniyo. Pjl̈ara ga kojono shäng Jesús zl̈ong bäng, tjl̈ĩya wl̈o. Tjl̈ẽ ba kong ga «Tjl̈apga no pingga, ¿l̇l̇ëye shäryër, tja ber sök së ĩyado Sbö tjok wl̈o?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","«¿L̇l̇ëye tara Moisésdë pjang kjok l̇l̇gwekkl̈o kjibokwoyo l̈i go? ¿Bop kong ga e pjl̈ol̇l̇gwep ber sorë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","«“L̇l̇ëbo woydëpshko, l̇l̇ëbo woyotjl̈ĩpshko, l̇l̇ëbo shäryëpshko, pja sök së obishko ga Tjl̈apga, bop Sbö l̈i woydos jl̈õkoyo ĩyado”, ga “Pja opwoydë sorë ga bop kjl̈ara, e woydos eni bakoe.” Kjok l̇l̇gwekkl̈o tak pjang l̈i e» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kuya ga tjl̈ẽ ba kong ga «Tja dboryorop beke. Shäryorop eni ga pja beno sök së ĩyado Sbö tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eshko ga domer l̈i opwl̈ikë woydë. Eni ga tjl̈ẽ ba kong ga «¿Bor kjl̈ara l̈e l̈i ë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","«Domer opshino kjl̈ara Jerusalén kjokyo dwayo, jongya jer shäng Jericó kjokyo wl̈o l̈ara. Jek jëk shängshko ga wl̈ẽna nopga l̈ũrkë ä wl̈eniyorë irbo. L̇l̇ëbo söya tjeng ba tjok l̈i döra l̈ok ba shjiryo dret, ba shwong pjang ba do go l̈i tjok, shpora l̈ok träk l̇l̇ëm, ga iara beno buk eshko ba l̇l̇ëmdo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","E bër ga syõshtaga Sbö kong ba nopga kjĩshko wl̈eniyo tek shäng kjl̈ara irbo l̈i go. Buk l̈i ĩna, gueniyo kjimtara l̇l̇ëm, koskara jek irbo sor go, jek bek erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","E irgo ga Leví tjëyo tek shäng kjl̈ara irbo l̈i go bakoe. Omĩno, ga kjimtara l̇l̇ëm, koskara jek irbo sor go, jek bek erä bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","E irgo ga tek shäng irbo l̈i go kjl̈ara obi, Samaria so shara. Buk l̈i ĩna, ga songe l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eni ga jek öötong shäng ba zl̈ong bäng. Shporaba jyãgl̈o l̈ok l̈i dwl̈omnena kjyo go, kjil̇l̇gwo bo dyo dbo ara go, ga pjrira shwomzrëng go. E irgo ga poyona, iara ba öng kjing go, söra jek no pozl̈ong uyoshko, ga dara buk eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wẽshko ga pozl̈ong uyo sogo l̈i potjwl̈ẽna dbur sho pjl̈ubl̈ún kjwo pjök go, ga tjl̈ẽ ba kong ga “Shporaba kayo buk kjwe dos bor kong jũshko sira. Dbur zanop ëre kjinmo wl̈eni ga tja tjwe iröng obishko ga pja potjwl̈ẽn eshko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","»¿Eni ga bop kong ga nopga dogl̈o mya l̈i kjone dey ga beno shporaba kayo l̈i kjl̈arayo?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","«Songe l̈aga ba kong l̈i e» l̈e kjok l̇l̇gwekkl̈o miydaga l̈irë. Kuya ga tjl̈ẽ ba kong ga «Eni ga pja nom omshäryë e kjoyo bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Kjok kjrinashko ga wal̈ë shäng kjl̈ara ko Marta, l̈ëng ko María. Jesús jëk shäng irbo ba oppinggaga tjok, ga öötong shäng eshko ga wl̈okjrara Martarë ba ushko. Eshko ga María wl̈oktong sök ba dre zl̈ong, tjl̈õkwo l̈e sök l̈i kuya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martara shäng wotjl̈ĩk ara, l̇l̇ëbo shärye wl̈o l̈i ara kjĩshko. E kjĩshko ga jek shäng Jesús zl̈ong bäng ga tjl̈ẽ ba kong ga «Tjl̈apga, bor l̈ëng kjwe ichos jek bor kjimtë. Tja iara beno shäng parkë ara tjoksa. ¿E ĩgöp l̇l̇ëmdo?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","«Marta, pja woydë ara, l̇l̇ëbo woyotjl̈ĩp shäng ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Gueniyo l̇l̇ëbo tjwl̈õ ara l̈i kjrinaso, ga tjwl̈õ ara l̈i kjrayde Maríarë, ga döga ërë ba shjiryo l̇l̇ëme» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pjl̈ara ga Jesús sök syõshtë Sbö kong. Syõshtono pjir ga ba oppingga kjl̈ara tjl̈ẽ ba kong ga «Tjl̈apga, tjawa pĩs syõshtë, Juan ba oppinggaga pino dik» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kuya ga tjl̈ẽ ba kong ga «Pjãy syõshtë Sbö kongshko ga l̈ëmi eni: »“Data, bop ko, e ber kësbang, dboye. Pja tjwe ber sök borwa pjl̈uyo wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dbar kjwobi go ga dl̈i woydërwa l̈i twos borwa kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","L̇l̇ëbo shäryara obl̈ërë borwa kong owa l̈i iërwa ber tjwl̈õ l̇l̇ëme. E kjĩshko ga owa pjang borwa go l̈i l̈ö̃s ber dret eni bakoe. Tjawa iëp ber l̈öng borwa tjl̈ĩzl̈ong l̈ishko l̇l̇ëme.”» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","E irgo ga tjl̈ẽ ba kong l̈ok ga «Kjok rong bek ga pjãy kjl̈ara shwoy, no tjwe shäng kjl̈ara pjola dwayo, ga pja dl̈i ba kong drete. ¿Eni wl̈eni ga pja to dl̈i rokë bop pjeyo sök soshko kong l̇l̇ëmdo? Pja äär ba shwoy ga pja tjl̈ẽ ba kong ga “Bor kjl̈ara shrono shäng bor shwoy, ga tja dl̈i ba kong drete. E kjĩshko ga tja sëm pjl̈ung shosho suk pjir kjwo myare” l̈ëp ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","»Pja kuya ga tjl̈ẽ bop kong ga “L̇l̇ëme. Tja barwëp l̇l̇ëme. U bäng jong tuke. Bor wapga tjeng bor tjok pëe. Tja kojong, l̇l̇ëye twër bop kong wl̈o l̇l̇ëme” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","»Gueniyo l̈ër bop kong ga rokëp jek rokëp jek wl̈eni ga kojong, l̇l̇ëye woydëp l̈i twe bop kong pjire. Eshko ga kojono bop kjimtë, pjãy ëng tjok pjl̈ú kjĩshko l̇l̇ëme. Kojono, e barworop ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","»Eni ga l̈ër bomi kong ga l̇l̇ëbo rokozĩ Sbö kong, ga twe bomi kong. L̇l̇ëbo wl̈ẽzĩ, ga wl̈ẽmi. “U bäng bäng dözĩ bor kong” l̈ozĩ ba kong, ga där bomi kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ëye l̇l̇ëbo rokë ga e kjre. Ëye l̇l̇ëbo wl̈ẽk ga e wl̈ẽya. Ëye “U bäng bäng dözĩ bor kong” l̈ë ga e där ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","»¿Data kjone dey ga kong mã roke ba warëshko ga kong dgur twaydero? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Ga kong kjörkö wa ak l̈ë rokeshko ga kong dyë twaydero? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eni ga pjãy nopga owa ëmdë ga pjãy wotjl̈ĩk l̇l̇ëbo pjl̈ú twë bomi wapga kong. Eni wl̈eni ga bomi Data sök kjok dogo l̈i kong l̇l̇ëbo rokëmishko ga pjãy kong ba Sëya twe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pjl̈ara ga domer shäng kjl̈ara tjl̈ẽ l̇l̇ëm, goshko Ä sëya kjl̈ara kjĩshko, ga sëya l̈i ichara Jesúsdë toe. E irgo ga domer l̈i beno shäng tjl̈ẽ. Ĩya l̈öng l̈irë ga beno l̈öng yëy l̈e erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gueniyo kjong kjong tjl̈ẽ ëng kong ga «Ä sëyaga iche to, dbo twara Ä sëya kägäyo ko Beelzebúrë ba kong l̈i go» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kjong kjong l̈öng obi omtjl̈ĩk woydë, ga tjl̈ẽ ba kong ga «L̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo shäryos borwa kong kjrina, pja ichaga Sbörë jl̈õre miydërwa e go wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wotjl̈ĩk l̈öng l̇l̇ë l̈i miydara Jesúsdë pjir, ga tjl̈ẽ ba kong ga «Pjl̈u l̇l̇ë, ba nopga ëngkjwë kar kar wl̈eni ga e oppjik l̈ok om go. Nopga tjeng u kjwaraso, e ëngkjwë kar kar wl̈eni ga e oppjik l̈ok om go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","¿Eni ga Ä, e ëngkjwë ba sëyaga tjok wl̈eni ga e pjir mal̈ing l̇l̇ëmdo? L̈ër bomi kong eni, tja Ä sëyaga ichë to, dbo twara Beelzebúrë bor kong l̈i go l̈ëmi kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Eni kjwe ga bomi oppinggaga kong dbo twaga ërë, Ä sëyaga iche wl̈o? E kjĩshko ga pjãy diktong l̈öng jl̈õe l̈aga epgarë om go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ä sëyaga ichër to, Sbö dbo ara go. Miydëmi e go ga Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo shrono tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","»Domer shäng kjl̈ara dbo ara, wl̈oshko opwl̈ikokl̈o tjok. Shäng ba u dëshko ga l̇l̇ëbo tjeng u roshko l̈i l̈ũyotkëba ba shjiryo ga ä, wokjang ba opwl̈ikokl̈o tjeng l̈i kjĩshko. Gueniyo ga tjwe kjl̈ara obi, dbo ara ba kjinmo wl̈eni ga shäng l̈i zãya, ba opwl̈ikokl̈o l̈i döya ba shjiryo, l̇l̇ëbo tjeng ba u roshko l̈i söya jek ba tjok, ba opwl̈ikokl̈o tjok bako, ga shdöya obl̈ë kong drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","»Ëye shäng bor shwo l̈ëkong l̇l̇ëm ga e shäng bor wl̈oyo. Ëye no töng bor kong l̇l̇ëm ga e shäng ba shdöga. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","»Ä sëya pjang no goshko l̈i toshko ga to shäng shto wl̈ẽk kjok dogro no l̇l̇ëmshko, woshtë wl̈o, gueniyo wl̈ẽya l̇l̇ëme. Eshko ga wotjl̈ĩk ga “Tja to bor ushko iröng obi” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Äär iröng ba ushko ga wl̈ẽya shäng pjl̈okjak pjir, poshäryak pjir wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Eni ga sëya obl̈ë tö̃ya ba tjok dogl̈o kjäk (7), owa ba kjinmo, ga uunkong l̈i pjë jek äär ber tjeng no l̈i go. Eni ga no l̈i beno shäng owa anmoyõ, shäng bäm go sorë l̈i kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tjl̈ẽ shäng wopro ga wal̈ë shäng oba tjeng l̈i tjrëko kjl̈ara, tjl̈ẽno dbo go. Tjl̈ẽ ga «Bop mekë, pja wena, pja kuna. Miydër ga shäng wopjl̈ú bop kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kuya ga tjl̈ẽ ga «Ëng. Gueniyo ga ëye Sbö tjl̈õkwo kuno, ga kol̈e ga era ber shäng wopjl̈ú anmoyõ» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eshko ga nopga töno ara, tjwe jong obi Jesús shäng l̈ishko. Ga Jesús tjl̈ẽ ba kong ga «Eerishko dbaryo sopga, pjãy owa. Woydëmi ga l̇l̇ëbo jyãgl̈o shäryër bomi kong, gueniyo shäryër l̇l̇ëm, Sbö tjl̈õkwo l̈aga Jonás, e jyãgl̈o shäryotë bomi kong eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dënashko ga Jonás, e beno l̇l̇ëbo jyãgl̈o Nínive sopga kong. Ga no to ter kjok dogo dwayo ëre ber l̇l̇ëbo jyãgl̈o nopga l̈öng eerishko l̈i kong eni wl̈eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sabá so pjl̈uyo wal̈ë tek pjola dwayo, Pjl̈u Salomón kjok miydë l̈i kuya wl̈o. Ga ëreshko no shäng kjl̈ara tjwl̈õ ara, Salomón kjinmo. E kjĩshko ga eerishko dbaryo sopga, pjãy l̇l̇gweya Sbörëshko ga wal̈ë l̈i kojong, ga tjl̈ẽ ga “Kjwepga shdungko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nínive sopga, e Jonás tjl̈õkwo kunoshko ga l̇l̇ëbo owa shärye l̈öng l̈i, e owa jl̈õe l̈ara, ga rayarae. Ga ëreshko no shäng kjl̈ara tjwl̈õ ara, Jonás kjinmo. E kjĩshko ga eerishko dbaryo sopga, pjãy l̇l̇gweya Sbörëshko ga Nínive sopga kojong l̈ok, ga tjl̈ẽ ga “Kjwepga shdungko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","»Iök shjiy borkey, jney wl̈o l̇l̇ëm, iëy sbi dorko wl̈o l̇l̇ëm bakoe. Iëy jong kjókshko dey, nopga opzrëk jek eshkoshko ga kãl̈ã të shjiy wẽl̈ë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iök shjiy ĩgömi wẽl̈ë bomi bokkwo go. Bomi bokkwo pjl̈ú wl̈eni ga bomi doyo uunkong iök shjiy tjok wl̈eni. Gueniyo bomi bokkwo owa ga bomi doyo uunkong kjok ro sĩ wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eni ga pjãy sjëke. ¿Tjl̈õkwo kjroromi l̈i, e jl̈õre? Bomi iök shjiy l̈i e. E kjĩshko ga tjl̈õkwo kjroromi l̈i jyõ wl̈eni ga pjãy l̈öng kjok ro sĩ roy wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gueniyo bomi doyo uunkong iök shjiy tjok, kjok ro yẽt eshko l̇l̇ëm ga kjok ĩgömi wẽl̈ë, pjãy jëk l̈öng iök shjiy tjok wl̈eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tjl̈ẽno eni pjir ga e mana fariseo shäng kjl̈ara l̈irë ië ba tjok ba ushko. Eni ga opzrëno jek ba tjok ba u roshko, ga sirkeno sök, ië wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ĩya fariseo l̈irë ga Jesús orkwo shkwono judíoga ĩ dik l̇l̇ëm ga beno shäng wotjl̈ĩk ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eshko ga Jesús tjl̈ẽ ba kong ga «Pjãy fariseoga l̇l̇ëbo shäryë ara, pjãy pjl̈úe l̈ëba wl̈o, gueniyo pjãy wotjl̈ĩk dbur töng bomi kong erö, pjãy wotjl̈ĩk l̇l̇ëbo owa shäryë. Pjãy so di iokl̈o, dl̈i uokl̈o kjoyoe. E kwoshkwak ba pogl̈o go, gueniyo roshko wl̈iwl̈ie. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Pjãy wotjl̈ĩk l̇l̇ëme! Shji shäryara Sbörë pjir, bi doyo dö l̇l̇ëm, bi sëya bakoe. ¿E miydëmi l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gueniyo pjãy wotjl̈ĩs l̇l̇ëbo pjl̈ú shäryë oba song wl̈eniyo kong. Eni ga pjãy ber l̈öng pjl̈o bek Sbö bokso jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","»¡Fariseoga, pjãy song jl̈õ, pjãy shdungko! L̇l̇ëbo wl̈ẽnomi l̈i shtëmi äär ba sakyo (10) go, ba sakyo (10) go, shimi kjrina kjrina, ga twëmi Sbö kong. Bomi dl̈i mokyo obl̈ë obl̈ë tjok ëmdë ga shäryëmi jl̈õkoyo eni bakoe. Gueniyo ga pjãy jëk l̈öng pjl̈o bek obl̈ë tjok l̇l̇ëm, Sbö woydëmi l̇l̇ëm bakoe. Pjl̈ú wl̈o ga pjãy jëk pjl̈o bek nopga uunkong tjok, ga Sbö woydëmi pjl̈ú bakoe. Gueniyo woyde ga l̇l̇ëbo wl̈ẽnomi l̈i twëmi Sbö kong, shäryëmi l̈öng wl̈eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","»¡Fariseoga, pjãy song jl̈õ, pjãy shdungko! Judíoga syõ uyo roshko ga woydëmi ga pjãy l̈öng sökkl̈o pjl̈ú goshko erä. Woydëmi ga miga l̇l̇ë l̈ëba bomi kong yõtso l̇l̇ëbo soynezl̈ong shtoyo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Pjãy song jl̈õ, pjãy shdungko! Pjãy so shinmo doyo iak buk jyãgl̈o l̇l̇ëm kjoyoe. Nopga jëk ba kopshko ga l̇l̇ëye miyde l̈ok l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Domer shäng kjl̈ara eshko, kjok l̇l̇gwekkl̈o tara Moisésdë l̈i miydaga pjl̈ú wl̈eniyo. Eshko ga tjl̈ẽ Jesús kong ga «Tjl̈apga no pingga, l̇l̇ëye l̈ëp shäng l̈i, e borwa barwokl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kuya ga tjl̈ẽ ba kong ga «¡Kjok l̇l̇gwekkl̈o tara Moisésdë l̈i miydagaga pjl̈ú wl̈eniyo, pjãy song jl̈õ, pjãy shdungko! Oba pimi l̈öngshko ga tjl̈õkwo l̈ëmi ara l̈i shäryëba uunkong ga äe. E so l̇l̇ëbo kwing ä twëmi obl̈ë kong söya wl̈o kjoyoe. Shäryëmi eni, gueniyo pjãy om go omkjimtë ba sök l̇l̇ëm, bomi sakkwo go ëmdë l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Pjãy song jl̈õ, pjãy shdungko! Dënashko ga Sbö tjl̈õkwo l̈agaga, e zröra bomi tjl̈apgagarë ara, ga jnena l̈ok. E ga pjãy eerishko ga l̈öng ba sak l̈i poshäryë ber wol̈ësowa wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","E goshko ga pimi l̈öng oba uunkong kong ga pjãy wotjl̈ĩk ga zröra l̈ok l̈i, e pjl̈úe l̈ëmi. Zröra, jnena epgarë l̈ok, ga pjãyda beno l̈öng ba sak shäryaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","»E kjĩshko ga Sbö tjl̈ẽno ba kjok miydë l̈i go. Tjl̈ẽno ga “Epga kong bor tjl̈õkwo l̈agaga ichër obl̈ë obl̈ë. Kjong kjong zröya l̈ok, kjong kjong shdũya l̈ok, bokrotke l̈ok ara” l̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","E kjĩshko ga eerishko dbaryo sopga, pjãy shdũya Sbörë, ba tjl̈õkwo l̈agaga zröra l̈ok tek dämärshko dwayo l̈i kjĩshko, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","soyara l̈ok Abel go, äär jong Zacarías go. Zacarías, e zröra l̈ok Sbö u jong l̈i, öng sho sukkl̈o jong l̈i, e tjrëko. L̈ër bomi kong ga pjãy shdũya Sbörë, l̇l̇ëbo shäryara l̈ok ba tjl̈õkwo l̈agaga l̈öng kës kong l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","»¡Kjok l̇l̇gwekkl̈o tara Moisésdë l̈i miydagaga pjl̈ú wl̈eniyo, pjãy song jl̈õ, pjãy shdungko! Pjãy opping kjok l̇l̇gwekkl̈o l̈i go ara kjĩshko ga shji Sbö miydë sorë miydëmi l̈öng pjl̈ú, gueniyo l̈ëmi ë kong l̇l̇ëme. Nopga obl̈ë somi, Sbö miydë l̈ok l̇l̇ëm wl̈o, ga pjãy om go ëmdë ga Sbö miydë l̈öng l̇l̇ëm bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","E irgo ga Jesús to eshko dwayo. E dbaryo jek l̈ëkong ga no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, fariseoga, e iirkono l̈ok ara ba kong, ga l̇l̇ëbo kjakroke l̈ok ara, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tjl̈ĩya l̈ok wl̈o, rote l̈ok l̇l̇ëbo l̈ara l̈i go wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","E wopro ga oba tjwe jong tjwe jong träk l̇l̇ëm, sho l̇l̇ik l̇l̇ik l̈ë. Eshko ga Jesús tjl̈ẽ ba oppinggaga kong ga «¡Pjãy sjëk fariseoga tjok, ba pjl̈ung shosho uukkl̈o wl̈e tjok! ¡Epga Sbö tjl̈õkwo söga jl̈õkoyo l̈e, gueniyo wotjl̈ĩk owa ba pjl̈úshko! ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","L̇l̇ëbo shäryak l̈ũtshko kës l̈i wen wẽl̈ëshko. L̇l̇ëbo jnek kës l̈i wl̈ẽkoba pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eni ga tjl̈õkwo l̈oromi shkëshko l̈i, e kukoba kjok shjiyshko. Tjl̈õkwo l̈oromi l̈ũtshko l̈i, e kukoba kjone pogoshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","»Pjeyoga. L̈ër bomi kong ga nopga bangkjrëmi l̇l̇ëme. Bomi doyo zröya l̈ok ga pjl̈ú, gueniyo l̇l̇ëye shärye l̈ok bomi kong obi ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bangkjrako l̈i ë l̈ër bomi kong. Sbö, e bangkjromirë dey. Pjãy zröya ga pjl̈úe. E irgo ga pjãy iche äär ber l̈öng iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko ga pjl̈ú bakoe. Era bangkjrozĩa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","»¿Sënwa kjwo shkëng (5) soynek dburwa kjwo pjök ãska l̇l̇ëmdo? Eni ëmdë ga sënwa l̈i woyojeya Sbörë kjwara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pjãyda tjwl̈õ ara, sënwa ara kjinmo. Bomi käkzong pjl̈obi shtara Sbörë pjir tjän. E kjĩshko ga l̇l̇ëye bangkjrëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","»L̈ër bomi kong ga pjãy tjl̈ẽno oba kong ga pjãy l̈öng bor tjok l̈oromi wl̈eni ga no to ter kjok dogo dwayo ëre tjl̈ẽ bor parkagaga kjok dogo so l̈i kong ga pjãy l̈öng bor tjok l̈ër eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gueniyo pjãy tjl̈ẽno oba kong ga pjãy l̈öng bor tjok l̇l̇ëme l̈oromi wl̈eni ga tja tjl̈ẽ bor parkagaga l̈i kong ga pjãy l̈öng bor tjok l̇l̇ëme l̈ër eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","»Ëye no to ter kjok dogo dwayo ëre l̈ãywë owa ga owa l̈i l̈ö̃ya Sbörë ber dret ga pjl̈úe. Gueniyo ëye Sbö Sëya l̈ãywë owa ga owa l̈i l̈ö̃ya l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","»Pjãy shakoba, sökoba judíoga syõ uyo roshko, l̇l̇ëm ga tjl̈apgaga bokshtoshko ga pjãy woydë l̇l̇ëm, “¿Tja opwl̈ikë sorë?” l̈ëmi l̇l̇ëm, “¿L̇l̇ëye l̈ër?” l̈ëmi l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pjãy tjl̈ẽshko ga l̇l̇ëye l̈ëmi wl̈o l̈i, e twaga Sbö Sëyarë bomi kong eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Domer shäng kjl̈ara eshko oba tjrëko, tjl̈ẽ Jesús kong ga «Tjl̈apga no pingga, bor data wol̈ono, ga ba l̇l̇ëbo beno tjeng l̈i, e shdöya woydë bor shjiydë bor kong l̇l̇ëme. E kjĩshko ga l̈os ba kong ga l̇l̇ëbo botoya l̈i twe bor kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kuya ga tjl̈ẽ ba kong ga «¿Tja iaga ërë beno shäng bomi l̇l̇gwega, bomi l̇l̇ëbo l̈ëp l̈i shdör wl̈oro?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eshko ga tjl̈ẽ oba kong ga «¡Pjãy sjëke! Shji wotjl̈ĩk l̇l̇ëbo töng bayo ara wl̈o l̇l̇ëme. Shji wopjl̈ú l̈aga bi l̇l̇ëbo tjeng ara l̈irë l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","E irgo tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga «Domer shäng kjl̈ara dbur ara wl̈eniyo. Ba kjok buk l̈i kjing go dwl̈a dgara, ga bo kjrara arae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","18","Eni ga wotjl̈ĩk ga “¿Tja orwë l̇l̇ong? ¿Bor dwl̈a bo kjroror ara kjwe jner tjeng kjone? Bor dwl̈a bo jnekkl̈o uyo l̈ok kjwe, e chilawa anmoyõ” l̈e. Wotjl̈ĩno sök däw ga tjl̈ẽ ga “L̇l̇ëye shäryër miydër tjän. Bor dwl̈a bo jnekkl̈o uyo kjwe shdör, ãska shäryër këskës anmoyõ. E roshko bor dwl̈a bo kjwe jner tjeng pjir eshko, bor l̇l̇ëbo obl̈ë obl̈ë tjeng kjwe jner eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Shäryoror eni pjir ga l̈ër bor pjl̈úshko ga ‘Tja l̇l̇ëbo jnek tjeng ara, äär l̈u pjl̈ogl̈o ara kong wl̈o. Tja woshtë, tja ië ara, tja ber wopjl̈úe’ l̈ër eni eshko jã” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","»Gueniyo ga Sbö tjl̈ẽ ba kong ga “Pja kä l̇l̇ëme. Eeri shkëyo ga pja wol̈on. ¿Eshko ga bop l̇l̇ëbo jnenop tjeng l̈i ber ë kongdo?” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","»Eni ga ëye dbur töng, jneya ber ba kong om go wl̈o, gueniyo l̇l̇ëbo tjwl̈õ ara Sbö kong l̈i shärye l̇l̇ëm ga era kong, l̇l̇ëbo wen tjwe ba kong eni kjoyo bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","E irgo ga Jesús tjl̈ẽ ba oppinggaga kong ga «L̈ër bomi kong ga shji woydë l̇l̇ëme. Shji woydë dl̈i kjĩy l̇l̇ëm, shwong kjĩy l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pjãy l̈öng së, e tjwl̈õ ara, bomi dl̈i kjinmo. Bomi doyo, e tjwl̈õ ara, bomi shwong kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sënwa so ëp uaga kjoyo l̈i woyotjl̈ĩzĩa. Dwl̈a dgue l̇l̇ëm, bo kjre l̇l̇ëm, jneya ba jnekkl̈o uyo roy l̇l̇ëm bakoe. Gueniyo së̃ya Sbörë. ¡Pjãyda tjwl̈õ ara, sënwa kjinmo! ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Pjãy woydë ara ga l̇l̇ëye shimi e goro? Bomi l̈u iëmi om go dbar kjwara obi ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","¿Eni ga l̇l̇ëbo chirawayo l̈i shäryëmi ga ä kuzong ga pjãy woydë l̇l̇ëbo obl̈ë kjĩshko l̇l̇ënoro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","»Nana kjl̈oshko so woyotjl̈ĩzĩa. Parkë l̇l̇ëm, shwong sek l̇l̇ëm bakoe. Eni ëmdë ga l̈öng wol̈ësowa ĩyado. L̈ër bomi kong ga Pjl̈u Salomón l̇l̇ëbo ara anmoyõ. Gueniyo doyono wol̈ësowa, öötong nana kjl̈oshko so ĩ dik l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kjl̈o sho l̇l̇ë doye Sbörë eni, eeri ga l̈ok pjl̈ú, bong ga sukoba gueniyo. ¿Pjãy doye e kjinmo anmoyõ l̇l̇ëmdo? ¿Pjãy mär Sbö go jl̈õkoyo l̇l̇ëm ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","»E kjĩshko ga shji woydë l̇l̇ëme. Shji woydë dl̈i kjĩy l̇l̇ëm, di kjĩy l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","L̇l̇ëbo tjeng kës ëre kjĩshko ga nopga Sbö miydë l̇l̇ëm wl̈eniyo woydë arae. Gueniyo bomi Data, l̇l̇ëye woydëmi dö l̈i miyde sök pjir tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sbö ber bomi pjl̈uyo sorë l̈i woyotjl̈ĩmi ara, l̇l̇ëbo obl̈ë obl̈ë kjinmo. Shäryëmi l̈öng eni ga l̇l̇ëbo obl̈ë woydëmi kës l̈i ber bomi kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","»Pjãy bor öng wl̈ẽp ushko so wl̈eni. Pjãy ara l̇l̇ëm, gueniyo woyde Sbörë ga pjãy ber l̈öng no ichagaga ba tjok, sök no pjl̈uyo ĩyado l̈ishko. E kjĩshko ga l̇l̇ëye bangkjrëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pjãy l̇l̇ëye tjok ga soynezĩ, ga dburyo twozĩ oba song wl̈eniyo kong. L̇l̇ëbo tjwl̈õ ara l̈i iëmi ber tjeng ba bapkwo roy kjok dogo, eshko ga l̇l̇ëbo l̈i pjir l̇l̇ëm, l̈ũyotkëba l̇l̇ëm, ue ba sëyarë l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bomi l̇l̇ëbo tjwl̈õ ara l̈i töng tjeng kjone ga pjãy wotjl̈ĩk eshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","40","»No to ter kjok dogo dwayo ëre tjwe l̇l̇ono miydëmi l̇l̇ëme. E kjĩshko ga pjãy ber l̈öng bor koshë, poshäryak l̈öng pjir ĩyado. Woyde ga pjãy ber l̈öng parkagaga l̈öng ba kägäyo koshë wl̈eni. Ba kägäyo l̈i jek kjok shto obl̈ë orkwosmozl̈ong dbaryo shrëk. Woyde ga ba parkagaga l̈öng ba ushko obi l̈i ber l̈öng ba koshë ĩyado, wl̈oshko iök borkek tjeng shjiy, tjwe iröng obishko ga wl̈okjre l̈ok jekdo ga pjl̈ú wl̈o. Tjwe kjok rong, l̇l̇ëm ga kjok ba shränto ëmdë ga woyde ga l̈öng ba koshë eni. Ga shronoshko ga epga wl̈ẽna l̈ok eni ga e ber ba kong l̈ok pjl̈úe. L̈ër bomi kong jl̈õkoyo ga eni ga epga ie wl̈ar l̈öng sökkl̈o go, ië wl̈o, ga dl̈i shiya, söya, twe ba kong l̈ok om go. »Tja kuzĩa. Ëye tjwe l̈ũrkë l̇l̇ono miyde u sogo l̈irë kjwe ga ëye opzrëk jek ba ushko l̇l̇ëbo l̈ũyotkë wl̈o l̇l̇ëme. Ga no to ter kjok dogo dwayo ëre tjwe dbar l̇l̇ono miydëmi l̇l̇ëm kuzong ga pjãy ber l̈öng bor koshë, poshäryak l̈öng pjir ĩyado» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Eshko ga Pedro tjl̈ẽ ba kong ga «Tjl̈apga, ¿tjl̈õkwo l̈ëp shäng l̈i l̈ëp shäng borwa kong döre, de oba uunkong kong?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","«Parkaga ie ba pjl̈urë ber ba parkagaga obl̈ë daga, së̃ya äär ba dl̈oyo go kjok orë ga woyde ga parkaga l̇l̇ëye l̈e ba kong l̈i shärye eni wl̈eniyo, kjok miydë ara bakoe. ¿Gueniyo ga kjre sorë? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tjwe iröng obishko ga parkaga wl̈ẽya ba pjl̈urë shäng ba pak shäryë pjl̈ú l̈i, e kongda ber pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","L̈ër bomi kong jl̈õkoyo ga era ie ba pjl̈urë ber shäng ba l̇l̇ëbo uunkong kägäyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gueniyo ga parkaga l̈i wotjl̈ĩk owa wl̈eni ga ba pjl̈u tjwe mal̈ing l̇l̇ëme l̈e wl̈eni ga opyorgö to shäng parkagaga obl̈ë shdung, ga gl̈ö ara, nel̈õtkë ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Eni wl̈eni ga koshe shäng l̇l̇ëm dbaryoshko ga ba pjl̈u tjwe. Eshko ga parkaga owa l̈i shdũya, iche jek nopga kä l̇l̇ëm wl̈eniyo l̇l̇amo tjeng l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","»Parkaga l̇l̇ë, l̇l̇ëye woyde ba pjl̈urë l̈i miyde pjl̈ú, gueniyo shäryara eni l̇l̇ëm, ba tjl̈õkwo kol̈ara l̇l̇ëm ga e shdungko, e shpokko ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gueniyo parkaga l̇l̇ë, l̇l̇ëbo owa shäryara, miydara l̇l̇ëm kjĩshko ga era shdungko bako, gueniyo e shpokko sira döe. Ëye kong l̇l̇ëbo twara ara ga kong l̇l̇ëbo roke ara, obl̈ë kjinmo. Ëye kong l̇l̇ëbo iara beno tjeng ba wl̈oshko ara ga kong l̇l̇ëbo roke, obl̈ë kjinmo bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","»Tja shrono shäng kjok ëre kjing go, iök borkek wl̈o wl̈eni. ¡Ga woydër ga iök l̈i pjë jong ri ri tjän! ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tja kong l̇l̇ëbo wen tjwe owa kjl̈uwe. E kjĩshko ga tja woydë ara, äär jong l̇l̇ëbo l̈i shäryono bor kong pjir guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Tja shrono shäng nopga ichë ber l̈öng wl̈ẽp ëng tjok wl̈o l̈ëmire? Eni l̇l̇ëme. L̈ër bomi kong ga tja shrono shäng no shdöga, ber l̈öng dboy dboy wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Eeri jek l̈ëkong ga nopga tjeng u kjwaraso dogl̈o shkëng (5) ga e shdär ber kjring pjök, kjrina dogl̈o mya, kjrina do pjök, ga ber l̈öng ëng moskwo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dataga, ba wapga domerga, e ber l̈öng ëng moskwo; mekëga, ba wapga wal̈ëga, e ber l̈öng ëng moskwo; wal̈ëga, ba pjl̈aydoga, e ber l̈öng ëng moskwo eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Eshko ga Jesús tjl̈ẽ nopga kong ga «Pjäng sho poyong jem pjang dl̈o jer shwo l̈ëkong l̈i ĩmishko ga miydëmi e go ga shunyo shrë l̈ëmi, ga shrë jl̈õe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pjl̈uk tjwe kjok dogro no l̇l̇ëm shwo l̈ëkong dwayo l̈i kumishko ga miydëmi e go ga kjok kjl̈irkë l̈ëmi, ga shäryë eni jl̈õe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! L̇l̇ëbo wen kjok dogo, kjok ëre kjing go, e l̇l̇ë l̈okl̈o miydëmi pjl̈úe. ¿Eni ga l̇l̇ëbo shärye Sbörë eerishko dbaryo l̈i, e l̇l̇ë l̈okl̈o miydëmi l̇l̇ëm sorëro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","»¿L̇l̇ëye ber pjl̈ú, l̇l̇ëye ber owa, e miydëmi l̇l̇ëmde? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pjãy sökoba no l̇l̇gwega shwoy l̈ëbashko ga pjãy l̈an bomi söga l̈i tjok bäm goshko, pjãy ie ber tjeng tjl̈apga wl̈oshko l̇l̇ëm wl̈o. Shäryëmi eni l̇l̇ëm ga pjãy twe tjl̈apga l̈irë ba parkagaga kong, pjãy shdũya wl̈o, ga pjãy ie ber l̈öng no shdũzl̈ong uyo roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","L̈ër bomi kong ga pjãy opshik eshko dwayo l̇l̇ëm, äär jong dburwa kjöme l̈ara bomi kong l̈i potjwl̈ẽnomi pjir guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Eshko ga nopga l̈öng kjl̈öbö tjl̈ẽ Jesús kong ga «Galilea sopga l̈öng kjl̈öbö öng zrök, sho suya, pjë dret Sbö kong wl̈o. E wopro ga nopga ichara bi pjl̈uyo Pilatorë ba zrök, ga zröra l̈ok eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kuya ga tjl̈ẽ ba kong ga «¿Pjãy wotjl̈ĩk ga Galilea sopga l̈i zröraba, epga owa, nopga obl̈ë ba kjokshko so kjinmo kjĩshko l̈ëmire? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","L̈ër bomi kong ga eni l̇l̇ëme. Gueniyo l̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈ozĩ, ga rayozĩa. L̇l̇ëm ga pjãy pjir bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿E ga pjãy wotjl̈ĩk ga nopga wol̈ono Siloé kjokyo dogl̈o sak kjwara kjingsho kjwong (18), ak sho jong kjókshko eshko l̈i dgono jer ba kjing goshko l̈i, e owa, Jerusalén sopga l̇l̇amo l̈i kjinmo l̈ëmire? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","L̈ër bomi kong ga eni l̇l̇ëme. Gueniyo l̇l̇ëbo owa shäryëmi l̈öng l̈i, e owa jl̈õe l̈ozĩ, ga rayozĩa. L̇l̇ëm ga pjãy pjir bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","E irgo ga tjl̈ẽno nopga kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga «Domer shäng kjl̈ara, kjor jong kjl̈ara, ba kjil̇l̇gwo bo ara kjokyo l̈i tjrëko. Kjor l̈i ko higuera. Dbar kjwara ga jek jëk shäng e go, bo tjokde ĩya wl̈o, gueniyo bo drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eni ga tjl̈ẽ ba kjok daga l̈i kong ga “Kuzong. Eeri ga öötong l̈u pjl̈ogl̈o mya ga kjor kjwe ĩnshko ga bo wl̈ẽn kjwara l̇l̇ëme. ¡Kjwe kö̃zong! ¿Shto kjrë jong ara l̇l̇ënoro?” l̈e ba parkaga l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","»Kuya ga tjl̈ẽ ba kong ga “Tjl̈apga, wẽyẽ. Rayos ber jong l̈u pjl̈ara obi, sor pokër, ga dwl̈omner, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","botjyëre ĩy wl̈o, l̇l̇ëm ga köm eshko jã ga pjl̈úe” l̈e ba pjl̈u kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Woshtozl̈ong dbaryo kjwara ga Jesús sök oba ping judíoga syõ uyo jong kjwara l̈i roshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wal̈ë sök kjl̈ara eshko, swl̈o ara l̈u pjl̈ogl̈o sak kjwara kjingsho kjwong (18) tjän, wl̈oyo Ä sëya kjl̈ararë. Wal̈ë l̈i beno shäng wozönge. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ĩya Jesúsdë ga rokara tek ba shwoy, ga tjl̈ẽ ba kong ga «Pja döktong, pja rayara bop swl̈o wl̈erë» l̈e, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ga orkwo iono ba go. Jekdo eshko ga wal̈ë l̈i poptono beno shäng kjl̈o bek ba shtoshko. Ga opyono beno shäng Sbö poshrëk. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Gueniyo judíoga syõ uyo kägäyo l̈i shäng eshko. Ĩya ga iirkono ara, tjl̈ẽ nopga l̈öng l̈i kong ga «Shji parkozl̈ong dbaryo iak l̈ok kjwo tjer (6). Pjãy poptë woydë ga pjãy tek eshko dbaryo ga pjl̈úe. Gueniyo woshtozl̈ong dbaryo l̈ira l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Kuya Jesúsdë ga tjl̈ẽ ba kong ga «¡Pjãy Sbö tjl̈õkwo söga jl̈õkoyo l̈ëmi, gueniyo pjãy wotjl̈ĩk owa bomi pjl̈úshko! Wal̈ë kjwe, e Abraham tjëyo, ga tjeng Ä wl̈oshko eeri ga öötong l̈u pjl̈ogl̈o sak kjwara kjingsho kjwong (18). ¿Pjãy uunkong bomi öng dök, sömi di ië woshtozl̈ong dbaryo l̇l̇ëmdo? ¿Eni ga wal̈ë kjwe döror Ä wl̈oshko dwayo dbar ëreshko ga owa l̈ëmi sorëro?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kuya ba wl̈oyoga l̈irë ga l̈ökkjrono ara. Gueniyo l̇l̇amoga l̈öng l̈ira beno l̈öng wopjl̈ú, l̇l̇ëbo shäryara kës l̈i kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Eshko ga Jesús tjl̈ẽ l̈öng l̈i kong ga «¿Sbö ber no pjl̈uyo sorë, e so l̇l̇ë kjoyo? ¿L̈ër bomi kong sorë ga pjl̈ú? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","E so kjor dwl̈ayo chirawa ko mostaza dgoroy kl̈ung roy kjoyoe. Kuno ga kësbang, kjor wl̈eni. Eshko ga sënwa l̇l̇ë usho ywë ba kowo go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","E irgo ga tjl̈ẽ ga «¿Sbö ber no pjl̈uyo sorë, e so l̇l̇ë kjoyo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E so wal̈ë pjl̈ung shosho l̇l̇runo bayo ara ba uukkl̈o tjok, ga ie ber buk uur wl̈o kjoyoe. Ba uukkl̈o shdöktong pjl̈ung shosho l̈i kjwang jĩkong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús to jek shäng Jerusalén kjokyo wl̈o l̈e. Eshko ga jëk shäng irbo goshko ga äär kjok kjrina kjrinashko ga sl̈an oba ping. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pjl̈ara ga no kjl̈ara l̇l̇ëbo kjakrokono ba kong. Tjl̈ẽ ga «Tjl̈apga, ¿no kjre Sbörë där wl̈o l̈i kjl̈öbö döre?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Pjãy drön ëë, pjãy opzrëk jek kjër bäng bam chira l̈i go wl̈o. L̈ër bomi kong ga nopga ara opzrëk woydë jek e go wl̈o, gueniyo jek ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","U sogo l̈i u bäng bängzano pjir ga pjãy beno l̈öng kjoko l̈i, u bäng l̈i porwëmi kjöw kjöw, ga öö l̈ëmi, pjãy tjl̈ẽ ga “Tjl̈apga, u bäng dös borwa kong sira” l̈ëmi eni. »Kuya ga tjl̈ẽ bomi kong ga “Pjãy ë, pjãy kjone so, e miydër l̇l̇ëme” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","»Eshko ga pjãy tjl̈ẽ ba kong ga “Dënashko ga tjawa iono bop tjok, ga oba pinop borwa kjokshko bakoe” l̈ëmi eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","»Kuya ga tjl̈ẽ bomi kong ga “Pjãy ë, pjãy kjone so, e miydër l̇l̇ëme. Pjãy l̇l̇ëbo owa shäryaga eröe. Pjãy opkjos bor shwoy ëre dwayo” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","»Eshko ga Abraham, Isaac, Jacob, Sbö tjl̈õkwo l̈agaga l̈öng kës l̈i, e ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko. Ga nopga kjok kjwang jĩkong so sirkek äär ber l̈öng ië ba tjok. Ĩmi eni ga pjãy iak beno tjeng kjoko kjĩshko ga pjãy ber tjeng sl̈ar eshko, kowo uë, l̇l̇ëbo bang ara bomi kong kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Eerishko ga kjong kjong tjwl̈õ ara l̈i, e ber l̈öng tjwl̈õ chira eshko. E ga eerishko ga kjong kjong tjwl̈õ chira l̈i, e ber l̈öng tjwl̈õ ara eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Eshko ga fariseoga shrono l̈öng kjl̈öbö, ga tjl̈ẽ ba kong ga «Pjl̈u Herodes, pja zröya woydë. E kjĩshko ga pja nom jũy dwayo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kuya ga tjl̈ẽ ba kong ga «Domer l̈ëmi l̈öng l̈i, e oba jyãpgwaga erä. Pjãy nom ba shwoy, ga pjãy tjl̈ẽ ba kong ga “Eeri, bong ga tja shäng Ä sëyaga tjeng oba goshko l̈i ichë to, ga tja shäng oba poptë bakoe. Pak shäryër wl̈o l̈i, e pjir kjönma” l̈ëmi ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Gueniyo ga eeri, bong, kjönma ga tja to jek shäng Jerusalén kjokyo wl̈o. Tek këgongshko ga Sbö tjl̈õkwo l̈agaga zröraba shtoyo eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","»¡Jerusalén sopga, tja kuzĩa! Sbö tjl̈õkwo l̈agaga zrömi. Sbö tjl̈õkwo roy l̈agaga ichara bomi kong l̈i l̈ömi ak go, zrömi wl̈o. Woydoror enido ga pjãy tön, kjörkö meyo ba wapga töno tjeng ba sjä̃gä dirko wl̈eni, gueniyo woydoromi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tja kuzĩa. Bomi u, e raye Sbörë ber jong tjoksa. L̈ër bomi kong ga tja ëre ĩmi ame, äär jong pjãy tjl̈ẽ l̈öng ga »“Kjwe ichara Tjl̈apgarë tjwe kjok ëreshko. Kjwe kjimte Sbörë” l̈ëmi l̈öng guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Woshtozl̈ong dbaryo kjwara ga Jesús öötong shäng fariseo tjwl̈õ ara wl̈eniyo, e ushko, ië ba tjok wl̈o. Nopga l̈öng eshko l̈i l̈öng ba dë, l̇l̇ëye shärye l̈i ĩya l̈ok yõtso wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Domer sök kjl̈ara eshko swl̈o ara, pogl̈o dguë do jĩkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ĩya Jesúsdë ga tjl̈ẽ fariseoga l̈öng l̈i kong, kjok l̇l̇gwekkl̈o tara Moisésdë l̈i miydagaga pjl̈ú wl̈eniyo l̈öng l̈i kong ga «¿Woshtozl̈ong dbaryo ga shji swl̈o poptë ga pjl̈úre?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kuya l̈ok ga beno l̈öng kjing erä. Eni ga Jesús orkwo iono swl̈o l̈i go, ga poptara, tjl̈ẽ ba kong ga «Pja nom ga pjl̈úe» l̈e. Kuya ga toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eshko ga Jesús tjl̈ẽ nopga l̈i kong ga «¿Bomi wa, bomi öng, e l̈ono di bäng roshko woshtozl̈ong dbaryoshko ga shimi jekdo mal̈ing l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kuya l̈ok ga dboryara l̇l̇ëm, beno l̈öng kjing erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","E irgo ga ĩya Jesúsdë ga nopga mak l̈i shrono l̈öngshko ga sökkl̈o wl̈ẽya l̈ok pjl̈ú wl̈eniyo, oba tjwl̈õ ara tjeng l̈ishko. Eni ga tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Ëbo orkwosmok wl̈enishko ga pja mana ië ba tjokshko ga pja jek sirkek sökkl̈o kjing, oba tjwl̈õ ara tjeng l̈ishko l̇l̇ëme. No tjwl̈õ ara bop kjinmo tjwe shäng eshko wl̈eni ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","bomi maga l̈i tjwe tjl̈ẽ bop kong ga “Pja kojõzong. Sökkl̈o kjwe twos kjl̈ara wl̈e kong” l̈e kjwe. Eshko ga pja l̈öktkë ara, ga pja ber sök sökkl̈o tjeng iröng wl̈eniyo kjing go shara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","»Pja manabashko ga pja shronoshko ga pja jek sirkek sök sökkl̈o tjeng iröng wl̈eniyo kjing go dey. Eni ga bop maga l̈i tjwe tjl̈ẽ bop kong ga “Tjl̈apga, pja tjwl̈õ ara. Pja tek sirkek sök sökkl̈o ëre pjl̈ú anmoyõ kjing go shara” l̈e bop kong eni kjwe. Eshko ga pja ĩkoba ga pja tjwl̈õ tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ëye opyë ber tjwl̈õ ara ga iëba ber tjwl̈õ l̇l̇ëme. Ëye opyë ber tjwl̈õ l̇l̇ëm ga iëba ber tjwl̈õ ara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Eshko ga tjl̈ẽ ba maga l̈i kong ga «Pja dl̈i shäryono bayo arashko ga woyde ga oba l̇l̇ëbo ara wl̈eniyo mapdë dö l̇l̇ëm, bop pjeyoga mapdë dö l̇l̇ëm bakoe. Shäryorop eni wl̈eni ga dbar obl̈ë go ga pja kjwe kar maya eni bakoe. Eshko ga pja potjwl̈ẽkkl̈o tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pja dl̈i shäryono bayo arashko ga nopga song wl̈eniyo, nopga jëk l̇l̇ëm wl̈eniyo, nopga jëk yökyök wl̈eniyo, nopga kjok ĩgö l̇l̇ëm wl̈eniyo, e mapdë dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Epgara, pja potjwl̈ẽya ga äe. Gueniyo shäryorop eni wl̈eni ga pja ie Sbörë ber wopjl̈ú, ga pja potjwl̈ẽga erë, nopga pjl̈o bek l̈i woshre iröng obi dbaryo l̈ishko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Eshko ga sirkeno sök kjl̈ara ba tjok eshko l̈i tjl̈ẽ ba kong ga «¡Sbö ber no pjl̈uyo dbaryo öötongshko ga ëye öötong sök ië ba nopga tjok eshko l̈i ber wopjl̈úe!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kuya ga tjl̈ẽ ba kong ga «Domer shäng kjl̈ara, nopga mana träk l̇l̇ëm, tjwe ba ushko ië ba tjok wl̈o, ga opyono beno shäng dl̈i shäryë ba kong bayo ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Öötong iozl̈ong dl̈oyo go ga ba parkaga ichara kjl̈ara, tjl̈ẽ nopga mana l̈i kong ga “Pjãy tegö. Dl̈i kwirkonoe” l̈e eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","»Gueniyo kuya l̈ok ga kjl̈ara kjl̈ara l̇l̇ëbo wl̈ẽno, jek mana l̈ishko l̇l̇ëm wl̈o. Bäm go l̈i tjl̈ẽ ga “Tja kjok tjwl̈ẽno kjrina. Tja jongya ba ĩk. Tja jnep kësbange” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","»Kjl̈ara obi tjl̈ẽ ga “Tja sögl̈a kl̈ung workwokl̈o dopshiga wl̈eniyo tjwl̈ẽno dogl̈o sak kjwara (10). Tja jongya ba tjl̈ĩk. Tja jnep kësbange” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","»Kjl̈ara obi tjl̈ẽ ga “Tja orkwosmok sök eeri jã. Tja jek ga äe” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","»E irgo ga parkaga l̈i tek shrono shäng iröng obi ba pjl̈uyo shwoy, ga roy l̈ara ba kong pjire. Kuya ga iirkono ara, ga tjl̈ẽ ba kong ga “Pja to u l̈ok ara wl̈eniyo tjrëko, irbo pjl̈ara pjl̈ara bäng go, irbo chilawa obl̈ë obl̈ë bäng go bakoe. Eshko ga nopga song wl̈eniyo, nopga jëk l̇l̇ëm wl̈eniyo, nopga kjok ĩgö l̇l̇ëm wl̈eniyo, nopga jëk yökyök wl̈eniyo, e tek söba” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","»Shäryara eni pjir ga shrono tek shäng iröng obi, tjl̈ẽ ba pjl̈uyo kong ga “Tjl̈apga, l̇l̇ëye l̈orop bor kong l̈i shäryoror pjire. Gueniyo iozl̈ong shtoyo obie” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","»Kuya ga tjl̈ẽ ba kong ga “Pja nom nopga wl̈ẽk kjok shto obl̈ë shara. Pja to u l̈ok kjwöbö kjwöbö wl̈eniyo tjrëko. Eshko ga ëye wl̈ẽnop ga ichëp tek bor ushko, bor u ëre dl̈in ber jong tjung wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","L̈ër bop kong ga nopga manor l̈öng bäm go l̈i, bor dl̈i l̈i ue sira l̇l̇ëme” l̈e ba parkaga kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesús jek jëk shäng irbo go, ga oba jëk l̈öng ba tjok ara. Eni ga bojono iröng, tjl̈ẽ ba kong l̈ok ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ëye jëk woydë bor tjok jl̈õkoyo ga woyde ga ba data, ba mekë, ba wapga, ba pjeyoga uunkong, e ie ber woyo ba kong ame. Woyde ga wotjl̈ĩk ga “Tja wol̈onde, de tja wol̈on l̇l̇ëmde, tja jëk ba tjok” l̈e ĩyado bakoe. Shärye eni l̇l̇ëm ga e ber bor oppingga ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Woyde ga l̇l̇ëye shäryëba ba kong bor kjĩshko l̇l̇ë pogoshko l̈i, e zrökoba pjang kjl̈ös go ëmdë ga e ba kong ga l̇l̇ëye l̇l̇ëme l̈e. Eni l̇l̇ëm ga e ber bor oppingga ga ä bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","»¿Pjãy kjl̈ara wotjl̈ĩk ak sho shäryë jong kjókshko wl̈eni ga pja sirkek sök ba woyotjl̈ĩk ga “¿Tjwl̈õ kjöm? ¿Dburyo kjwõrde?” l̈ëp bäm go l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eni l̇l̇ëm ga u shakkl̈o l̈i shäryorop pjirshko ga dbur pjir eshko wl̈eni ga pja ĩkoba ga pja joywëba, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tjl̈ẽ ga “Domer kjwe ba pak soyono, ga kjra l̈ara ga pjitong l̇l̇ëm ĩzĩa” l̈ëba eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","»¿Pjl̈u l̇l̇ë opshik jek ba ëngkjwagaga dogl̈o sak dbäw dbäw pjl̈ogl̈o sak kjwara (10,000) tjok, ëngkjwë pjl̈u obl̈ë tjok wl̈eni ga ĩya ga pjl̈u obl̈ë l̈i ëngkjwagaga dogl̈o sak dbäw dbäw pjl̈ogl̈o sak pjök (20,000) wl̈eni ga l̇l̇ëye shärye eshko l̈ëmi? ¿Wotjl̈ĩk ga “¿No kjwõrde? ¿Shji ëngkjwë ba tjok sorë? ¿Shji kjangde, de l̇l̇ëmde?” l̈e eni l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eni ga “Shji songe” l̈e wl̈eni ga pjola obishko ga nopga iche jek kjl̈öbö, l̈an pjl̈u obl̈ë l̈i tjok wl̈o, ie ber sök wl̈ẽp wl̈o, ëngkjwë ba tjok l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bomi l̇l̇ëbo tjeng kës l̈i iëmi ber iröng l̇l̇ëm ga pjãy ber bor oppingga l̇l̇ëm eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","»Dl̈ungna, e pjl̈úe. Gueniyo ga pjl̈ë ameshko ga iëy ber pjl̈ë ba shtoy iröng obi ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Eshko ga l̇l̇ëno ame, ioroy kl̈ung kjing go ëmdë ga l̇l̇ëno l̇l̇ëme. E dbukko erä. Ëye kwomgwo tjok ga woyde ga kuya yõtso» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesús shäng oba ping wopro ga nopga dbur töngga Roma so kong, nopga owa wl̈eniyo obl̈ë, e shrono l̈öng ara ba kuk eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e l̈öng eshko kjl̈öbö bakoe. Nopga owa l̈i ĩya l̈ok ga tjl̈ẽ ëng kong ga «Nopga wotjl̈ĩk owa wl̈okjre, ga ië ba tjok bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eni ga Jesús tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«¿Pjãy kjl̈ara öng wl̈ẽp ushko so tjeng dogl̈o sak dbäw (100), ga kjl̈ara jeno wl̈eni ga l̇l̇ëye shäryëp eshko? ¿L̇l̇amo sak shkaw kjingsho shkaw (99) l̈i iëp ber tjeng ba kjok kjing go, ga pja to jeno l̈i wl̈ẽk, äär jong wl̈ẽnop guing l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wl̈ẽnopshko ga pja wopjl̈úe. Eshko ga iëp buk bop dbopdo, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","söp tek iröng bop ushko, ga bop pjeyoga rokëp uunkong tek eshko. Ga pja tjl̈ẽ ba kong l̈ok ga “Bor öng jeno l̈i wl̈ẽnore. Tja wopjl̈úe. Woydër ga pjãy ber wopjl̈ú botoya dik bakoe” l̈ëp eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","»Eni bakoe. L̈ër bomi kong ga no kjl̈ara, l̇l̇ëbo owa shärye shäng l̈i, e owa jl̈õe l̈ara, ga rayarashko ga kjok dogo ga l̈öng wopjl̈ú ba kjĩshko. Eshko ga nopga pjl̈o bek dogl̈o sak shkaw kjingsho shkaw (99) l̈i, era woyotjl̈ĩya l̈ok ara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","»¿Wal̈ë shäng kjl̈ara, dbur tjeng kjwo sak kjwara (10) ga jeno kjwara wl̈eni ga l̇l̇ëye shärye? ¿Iök borkeya, ga u ro pjl̈oke yõtso, ba dbur jeno l̈i wl̈ẽna guing l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wl̈ẽnashko ga ba pjeyoga roke tek eshko uunkong. Ga tjl̈ẽ ba kong ga “Bor dbur jeno l̈i wl̈ẽnore. Tja wopjl̈úe. Woydër ga pjãy ber wopjl̈ú botoya dik bakoe” l̈e eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","»Eni bakoe. L̈ër bomi kong ga no kjl̈ara, l̇l̇ëbo owa shärye shäng l̈i, e owa jl̈õe l̈ara, ga rayarashko ga Sbö parkagaga kjok dogo so l̈öng wopjl̈ú eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Eshko ga tjl̈ẽ ba kong obi ga «Domer sök kjl̈ara wapga do pjök. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pjl̈ara ga ba wa miteyo tjl̈ẽ ba data kong ga “Data, bop l̇l̇ëbo ber bor kong l̇l̇ono wl̈o l̈i twos bor kong jekdo” l̈e. Kuya ga ba l̇l̇ëbo tjeng kës l̈i shdöra ba wapga do pjök l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","»Dbar kjwöbö ga ba wa miteyo l̈i, l̇l̇ëbo twara ba kong l̈i soynena pjir, ga dburyo söra jek ba tjok, öötong beno sök kjok shto obl̈ë pjolae. Eshko ga ba dbur l̈i zana, to shäng sorë pogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Zana pjirshko ga kjok shäng l̈ishko ga pjl̈i shrono kësbang, ga l̇l̇ëye wl̈ẽya, ue wl̈o drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","»Eni ga to shäng pak wl̈ẽk domer kjok eshko so kong, ga kong pak twara, ichara köchi dë ba kjokshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Parkëshko ga pjl̈i ara, köchi dl̈i worbo l̈i ue woydë, gueniyo twëba ba kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","»Eni ga wotjl̈ĩk tjwe kjl̈ay ga “Bor data ushko ga dl̈i träk l̇l̇ëm, ba parkagaga l̈öng kës l̈i bö tjung ĩyado, ga dl̈i ber obie. ¡Na ga tja sök wol̈onto pjl̈irë! ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tja to bor data shwoy iröng obi dey. Tja äär eshko ga l̈ër ba kong ga ‘Data, tja l̇l̇ëbo owa shäryono Sbö kong, bop kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Bek ga tja tjwl̈õ bop wa dik ame. Tja ios ber bop parkaga wl̈eni dey’ l̈ër ba kong eni” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eni ga to sök l̈ishko dwayo, jongya ba data shwoy. »Jek shäng ääto ga ĩna ba datarë pjola dwayo, ga songe l̈e. Jekdo eshko ga jek zron jong ba wl̈okjrë, popjl̈ura, ga l̈õ shira. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","»Eshko ga ba wa l̈i tjl̈ẽ ba kong ga “Data, tja l̇l̇ëbo shäryono owa Sbö kong, bop kong bakoe. Bek ga tja tjwl̈õ bop wa dik ame” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","»Eshko ga ba data tjl̈ẽ ba parkagaga l̈öng l̈i kong ga “Pjãy shwong shis mal̈ing, pjl̈ú wl̈eniyo, ga doyozĩ e go. Kong sakkwo iokl̈o iozĩ kjwara, drepkwota iozĩ bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sögl̈a l̇l̇gwokl̈ë kjl̈o pjl̈ú wl̈eniyo l̈i tek sözĩ, ga zrözĩa. Shji dl̈i shäryë, ba shrëkkl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bor wa ëre shinmotkonoe l̈oror, miga shäng së. Jeno bor shjiryo, gueniyo shrono shäng iröng” l̈e. E irgo ga kjarga l̈öng ba shrëk. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","»E wopro ga ba wa këguëyo shäng parkë kjl̈oshko. Tek shäng iröng tjwayde ushko ga kuya ga oba l̈öng bërkë. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Eni ga parkaga rokara kjl̈ara, tjl̈ẽ ba kong ga “¿E l̇l̇ëro?” ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","»“Bop l̈ëng shäng së, shrono shäng pjl̈úe. E kjĩshko ga sögl̈a l̇l̇gwokl̈ë kjl̈o pjl̈ú wl̈eniyo l̈i zröra bop datarë ba shrëkkl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","»Kuya ga iirkono, opzrëk jek woydë u roshko l̇l̇ëme. Miydara ba datarëshko ga opshino jek ba wl̈ẽpyotkë, opzrëk wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Gueniyo tjl̈ẽ ba data kong ga “Miydëp pjl̈ú ga tja parkë shäng bop kong l̈uyo ara, pja kol̈ër ĩyado. Eni ëmdë ga tja kong shwl̈ing ushko so chirawa tworop bor kong, tja opshrëk bor pjeyoga tjok wl̈o pjl̈ara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gueniyo bop wa bopoya, bop dbur zana dret wal̈ëga owa wl̈eniyo tjok l̈i, era kong sögl̈a l̇l̇gwokl̈ë pjl̈ú wl̈eniyo l̈i zrörop” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","»Kuya ga tjl̈ẽ ba kong ga “Pja sök bor tjok ĩyado, bor l̇l̇ëbo tjeng kës l̈i, e bopoya. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gueniyo bop l̈ëng, e shinmotkonoe l̈oror, miga shäng së. Jeno bor shjiryo, gueniyo shrono shäng iröng obi. E kjĩshko ga shrëy l̇l̇ëm ga äe” l̈e ba kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Eshko ga Jesús tjl̈ẽ ba oppinggaga kong ga «Domer shäng kjl̈ara dbur ara. Domer l̈i parkaga shäng kjl̈ara, ba parkagaga tjeng kës l̈i kägäyo. E rotaraba ga ba pjl̈uyo l̈i dbur zãya ara sorë pogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Eni ga rokara ba pjl̈uyorë tek ba shwoy, ga tjl̈ẽ ba kong ga “Pja bor dbur jek shäng ara l̈ëba. ¿E sorëro? L̇l̇ëbo soynenop kjöm, tjwl̈ẽnop kjöm, e kjibokwoyo twos bor kong, bor l̇l̇ëbo dorop sorë l̈i miydër wl̈o. Pja ber shäng bor parkaga kägäyo ame” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","»Kuya ga wotjl̈ĩk ga “Tja ie bor pjl̈uyorë ber shäng pak drete. Tja parkë kjl̈oshko ma, ga tja to shäng dbur rokë ga tja l̈ök ara. ¿Era tja orwë l̇l̇ong? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Woydër ga tja pak l̇l̇ëmshko ga tja wl̈okjrëba ba ushko. ¿Gueniyo l̇l̇ëye shäryër ga pjl̈ú? Ãã, l̇l̇ë miydoror tjän” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","»Eshko ga ë pogo tjwl̈õ ba pjl̈uyo kong l̈i, e rokara tek ba shwoy. Ga tjl̈ẽ shrono shäng bäm l̈i kong ga “¿Pja pogo tjwl̈õ bor pjl̈uyo kong kjöm?” ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","»“Tja pogo tjwl̈õ kjyo bayo ba bapkwo kësbang tjung wl̈eni kjwo sak dbäw (100) dik” l̈e. »Kuya ga tjl̈ẽ ba kong ga “Bop tjwl̈õ kjöme l̈i kjibokwoyo ëre kjrozong. Pja sirkes mal̈ing, kjibokwo tos kjwara obl̈ë, gueniyo kjyo bayo ba bapkwo kësbang tjung wl̈eni kjwo sak shkëng (50) dik” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","»E irgo ga tjl̈ẽ shrono shäng kjl̈ara obi l̈i kong ga “¿Pja pogo tjwl̈õ ba kong kjöm?” »“Tja pogo tjwl̈õ dwl̈a bayo ba bapkwo kësbang tjung wl̈eni kjwo sak dbäw (100) dik” l̈e. »Kuya ga tjl̈ẽ ba kong ga “Bop tjwl̈õ kjöme l̈i kjibokwoyo ëre kjrozong. Kjibokwo tos kjwara obl̈ë, gueniyo dwl̈a bayo bapkwo kësbang tjung wl̈eni kjwo sak kjwong (80) dik” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","»Roy kura ba pjl̈uyorë, ga wotjl̈ĩk ga “Bor parkaga kägäyo l̈i wotjl̈ĩk owa ëmdë ga kjok miydë ara, wotjl̈ĩk mal̈inge” l̈e. Nopga Sbö miydë l̇l̇ëm wl̈eniyo omshäryë eni bakoe. L̇l̇ëbo tjeng kjok ëre kjing go pakyo shärye l̈ok pjl̈ú wl̈o ga epga wotjl̈ĩk mal̈ing, nopga Sbö ĩ l̈i kjinmo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","»L̈ër bomi kong ga pjãy dbur tjok ga zãzĩ oba kjimtokl̈o, epga ber wopjl̈ú bomi tjok wl̈o. Eni ga bomi dbur pjitongshko, pjãy wol̈onoshko ga pjãy wl̈okjraga tjok kjok dogo, shji sök së ĩyado l̈ishko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","»Ëye kong l̇l̇ëbo twëy tjwl̈õ chira ga de pjl̈ú wl̈eni ga miydëy e go ga kong l̇l̇ëbo twëy tjwl̈õ ara ga de pjl̈ú eni bakoe. Ga ëye kong l̇l̇ëbo twëy tjwl̈õ chira ga de ma wl̈eni ga miydëy e go ga kong l̇l̇ëbo twëy tjwl̈õ ara ga de ma eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eni ga bomi dbur, bomi l̇l̇ëbo, e doromi pjl̈ú l̇l̇ëm kjok ëre kjing goshko wl̈eni ga l̇l̇ëbo tjwl̈õ ara tjeng kjok dogo l̈i twaga ërë bomi kong l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","¿Ga l̇l̇ëbo oma ĩ l̈i doromi pjl̈ú l̇l̇ëm ga l̇l̇ëbo twe obl̈ërë ber bomipjõy wl̈o sorëro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","»Ëye parkë pjl̈uyo do pjök kong ga äe. Shärye eni wl̈eni ga kjl̈ara woyde, kjl̈ara woyde l̇l̇ëme. Ber pjl̈ú kjl̈ara tjok, ber owa kjl̈ara tjok. Pjãy wo pjang dbur go ĩyado ga pjãy parkë Sbö kong ga äe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseoga l̈öng eshko kjl̈öbö. Dbur sĩyo kjĩshko ga tjl̈õkwo l̈i kuya l̈ok ga joywakza l̈ok tjã tjã erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eni ga Jesús tjl̈ẽ ba kong ga «Pjãy l̇l̇ëbo shäryë ara oba bokso, pjãy pjl̈úe l̈ëba wl̈o. Gueniyo pjãy wotjl̈ĩk l̇l̇ë l̈i miyde Sbörë pjire. Nopga kong ga l̇l̇ëbo tjwl̈õ ara l̈e l̈i, e Sbö kong ga l̇l̇ëbo owa anmoyõ. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","»Kjok l̇l̇gwekkl̈o tara Moisésdë l̈i, tjl̈õkwo tara Sbö tjl̈õkwo l̈agaga tek dënashko sorë l̈i, e beno bi kong, kol̈ëy wl̈o, äär jong Juan No Waga shrono guing. Eshko tek l̈ëkong ga Sbö ber no pjl̈uyo sorë l̈i roy pjl̈ú shdöktong ara, ga nopga drön ëë, Sbö ber ba pjl̈uyo wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gueniyo kjok l̇l̇gwekkl̈o l̈i, e pjir wl̈o l̇l̇ëme. Kjopkwo, kjok ëre, e pjir ber dret, gueniyo ga tjl̈õkwo tak l̈ok kjok l̇l̇gwekkl̈o go l̈i l̈öngko kjwara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","»Domer ba boy rayono, ga orkwosmono obl̈ë tjok wl̈eni ga l̇l̇ëbo owa shäryayde. Ga ëye orkwosmok wal̈ë rayak sök l̈i tjok ga l̇l̇ëbo owa shäryayde bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","»Domer shäng kjl̈ara dbur ara, doyë shwong pjl̈ú, wol̈ëso go. Dbar kjwobi go ga bë shärye kësbang, dl̈i opzang ĩ. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eshko obi domer sök kjl̈ara ko Lázaro, pogl̈o go ũta ara do jĩkong, sirkek sök töshko, domer dbur ara l̈i u bäng zl̈ong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sök oma dl̈i worbo l̈on töshko l̈i koshë, ue wl̈o, pjl̈i ara kjĩy. Shjiti l̇l̇ë tjwe ba zl̈ong bäng ba ũta l̈i shuk. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Dbar kjwara ga domer song l̈i wol̈ono, ga ba sëya söra Sbö parkagaga kjok dogo sorë öötong sök Abraham zl̈ong. »E ga domer dbur ara l̈i ëmdë ga wol̈ono bako, jnenaba to sakshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ga ba sëya öötong sök iök pjë jong ri ri sjer l̇l̇ëm shtoyo l̈i roshko. Eshko ga song, suya iökdë, bang ara. Eni ga ĩya jem pjola dwayo ga Abraham bë sök Lázaro tjok, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ga öö l̈e, tjl̈ẽ ba kong ga “¡Kjokë Abraham, tja songe l̈ozong! Tja suya iökdë, bang ara. E kjĩshko ga Lázaro kjwe ichos ba sakkwo dbo pök di go, tek di smoktong ba go l̈i sök bor kong iër wl̈o, bor kjyorkwo zẽya wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","»Kuya ga tjl̈ẽ ba kong ga “Pja wotjl̈ĩs sira. Pja sök kjok kjing go obishko ga pja öör sök owa l̇l̇ëme. Lázarora öör songe. Eerishko ga sök wopjl̈ú jũshko, ga pjara sök song, suya iökdë, bang ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","E pjl̈or kar go ga jũshko kjok tjrëk pjang oojong kësbang, borwa shwo l̈ë, bop shwo l̈ë bakoe. E kjĩshko ga ëye jek ga ä, ëye tek ga ä bakoe” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","»Kuya ga tjl̈ẽ ba kong ga “Kjokë, rokër bop kong ga Lázaro kjwe ichos bor data ushko, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kjok owa anmoyõ ëre roy sök bor l̈ëmga dogl̈o shkëng (5) l̈öng eshko l̈i kong, tjwe kjok ëreshko l̇l̇ëm wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","»Kuya ga tjl̈ẽ ba kong ga “L̇l̇ëme. Epga kong kjok l̇l̇gwekkl̈o tara Moisésdë l̈i beno tjeng ba kong, tjl̈õkwo tara Sbö tjl̈õkwo l̈agaga tek dënashko sorë l̈i beno tjeng ba kong bakoe. Woyde ga e kol̈ayde l̈ok” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","»Kuya ga tjl̈ẽ ba kong ga “E kol̈e l̈ok l̇l̇ëme. Gueniyo ëbo wol̈ono, ga woshrono iröng obi, ga jek l̈an ba tjok wl̈eni ga l̇l̇ëbo owa shärye l̈öng l̈i, e owa jl̈õe l̈e, ga raye eshko” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","»Kuya ga tjl̈ẽ ba kong ga “Moisés tjl̈õkwo, Sbö tjl̈õkwo l̈agaga tjl̈õkwo, e kjre l̈ok l̇l̇ëm ga ëye wol̈ono, ga woshrono iröng obi l̈i tjl̈õkwo kjre l̈ok l̇l̇ëm bakoe” l̈e ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Eshko ga Jesús tjl̈ẽ ba oppinggaga kong ga «L̇l̇ëbo tjeng ara, pjãy iche l̇l̇ëbo owa shäryë wl̈o. E ber eni ĩyado. Gueniyo ëye obl̈ë ichono l̇l̇ëbo owa shäryë ga era song jl̈õ, shdungko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kjwozirwa bor tjl̈õkwo kjraga kjl̈ara ichayde l̇l̇ëbo owa shäryë l̇l̇ëm obishko ga ba ichaga l̈i shakko, apkwo kësbang pjrikko ba bëngshko, ga dbukko jer dl̈ung dorong dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","E kjĩshko ga pjãy sjëke. »Bop kjl̈ara, e l̇l̇ëbo owa shäryono ga pĩzong, “Shäryëp eni ame” l̈os ba kong. Eni ga “E owa jl̈õe. Shäryër ame” l̈ara bop kong wl̈eni ga l̇l̇ëbo shäryara owa l̈i ios ber tjwl̈õ l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dbar kjwara ga l̇l̇ëbo shäryara bop kong owa pjl̈ogl̈o kjäk (7) ëmdë ga tjwe bop shwoyshko ga tjl̈ẽ bop kong ga “E owa jl̈õe. Shäryër ame” l̈eshko ga owa l̈i ios ber tjwl̈õ l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eshko ga Sbö tjl̈õkwo roy l̈agaga ba ãska l̈i tjl̈ẽ ba kong ga «Tjawa mär l̈öng Sbö go. Tjawa kong dbo twos, tjawa mär ba go jek këgong wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kuya ga tjl̈ẽ ba kong ga «Dwl̈agwo chirawayo ëmdë ga kun jem ga pjl̈úe. Eni wl̈eni ga pjãy mär Sbö go sirawa dö ëmdë ga pjãy tjl̈ẽno kjor kësbang kjwe kong ga “Pja opshis ëre dwayo, pja nom wen jong dl̈ung roy” l̈oromi ga pjãy kol̈e, ga shäryë eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","»Pjãy kjl̈ara, parkaga shäng kjl̈ara wl̈eni ga brik shäng kl̈ung workwë, l̇l̇ëm ga öng dë. ¿Tjwe shäng iröng bop shwoyshko ga l̇l̇ëye l̈ëp ba kong eshko? ¿Pja tjl̈ẽ ba kong ga “Pja tegö. Pja sirkes sök ië jekdo” l̈ëp ba kong enire? Eni l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pja tjl̈ẽ ba kong ga “Bor dl̈i shäryos bor kong jekdo. Pja poshäryos, pja shwong skwos stek wl̈eniyo, bor dl̈i pjl̈orguëp bor kong wl̈o. Tja iono pjir ga ië pja shara” l̈ëp ba kong eni dani. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Shäryara bop kong eni pjir ga pja tjl̈ẽ ba kong ga “Tja kjimtorop ara, tja wopjl̈ú bop tjok” l̈ëp ba kong enire? Eni l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pjãy parkaga eniyo wl̈eni bakoe. Pjãy ichara Sbörë parkë ga pak l̈i shäryoromi pjir ga woyde ga pjãy tjl̈ẽ ga “Tjawa tjwl̈õ ara l̇l̇ëme. Tjawa parkaga eröe. L̇l̇ëye l̈ara Sbörë borwa kong l̈i shäryorwarë erä” l̈ëmi eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús jek shäng Jerusalén kjokyo wl̈o l̈eshko ga jëk shäng Samaria kjokyo, Galilea kjokyo, e tjrëko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jek äär shäng kjok kjrinashko ga domerga wen tjeng dogl̈o sak kjwara (10), pogl̈o go swl̈o ara, sho an do jĩkong wl̈eniyo. Tek shrono l̈öng pjola sit, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ga öö l̈e, tjl̈ẽ ba kong ga «¡Tjl̈apga Jesús, tjawa songe l̈ozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ĩya ga tjl̈ẽ ga ba kong l̈ok ga «Pjãy nom opping syõshtagaga Sbö kong ba pjeyoga kjĩshko l̈i kong, pjãy ĩya l̈ok wl̈o» l̈e. Jek l̈öng jëkko wopro ga poptonoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kjl̈ara opĩno ga beno drëpdrë, sano iröng, ga Sbö poshrëya shäng pjl̈uk ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eni ga jek öötong shäng Jesús zl̈ong bäng ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go, ga tjl̈ẽ ba kong ga «Tja poptorop. Tja beno wopjl̈ú bop tjok e kjĩshko» l̈e. Domer l̈i, e Samaria so. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kuya ga tjl̈ẽ nopga l̈öng l̈i kong ga «¿Domerga poptono, e dogl̈o sak kjwara (10) l̇l̇ëmdo? ¿L̇l̇amo dogl̈o shkaw (9) l̈i kjwono l̇l̇ong? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Domer ëre Samaria so, e judío l̇l̇ëme. Era shrono iröng obi Sbö poshrëk. ¿Judíogara kjwono l̇l̇ong?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eshko ga tjl̈ẽ domer l̈i kong ga «Pja kojõzong. Pja nomo. Pja mär bor go kuzong ga pja poptonoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pjl̈ara ga fariseoga kjone kjone tjl̈ẽ Jesús kong ga «¿Sbö ber no pjl̈uyo wl̈o l̈i, e dbaryo tjwe l̇l̇ono?» «Sbö ber no pjl̈uyo l̈i, e l̇l̇ëbo ĩkko wl̈eni l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Sbö, e no pjl̈uyo shäng ĩzong” l̈ëy ga äe, ĩgöy l̇l̇ëme. Sbö ber no pjl̈uyo l̈i, e l̇l̇ëbo wen bomi pjl̈úshko» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Eshko ga tjl̈ẽ ba oppinggaga kong ga «Dbar tjwe kjwara ga no to ter kjok dogo dwayo ëre ĩmi woydë ara jek pjl̈ara obi. Gueniyo eshko ga tja ĩmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Eshko ga no tjwe shäng tjl̈ẽ bomi kong ga “¡Shäng na ĩzĩa!” l̈e. Obl̈ë tjl̈ẽ ga “¡Shäng kjwe!” l̈e bomi kong, gueniyo jl̈õ l̈ëmi l̇l̇ëm, pjãy jek eshko l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tja tjwe iröng obishko ga e ber so l̇l̇gwl̈ëng l̇l̇er kãl̈ã l̇l̇etl̇l̇et kjok dogo l̇l̇aw pogo kjoyoe. Eni ga tja ĩga nopga uunkongdë wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gueniyo e bäm go ga tja shdungoba ara guing. Tja wl̈okjre nopga l̈öng eerishko dbaryo l̈irë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","»No to ter kjok dogo dwayo ëre tjwe iröng obi döröshko ga l̇l̇ëbo shäryë kjok ëre kjing go l̈i, e ber so l̇l̇ëbo shäryono Noé dbaryoshko l̈i dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Eshko ga kjok ëre pitë l̇l̇ëm obishko ga nopga to l̈öng wl̈ẽp dl̈i uë, di ië, orkwosmok ëng tjok, öötong Noé opzrëno jem kjyong kësbang roshko dbaryoshko. Eshko ga shunyo shrono kësbang, ga nopga l̈i söra dirë, shtena drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","»Lot dbaryo ga nopga opshäryono eni bakoe. To l̈öng dl̈i uë, di ië, l̇l̇ëbo tjwl̈ẽk, l̇l̇ëbo soynek, dwl̈a dguë, u ywë, beno l̈öng l̇l̇ë l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Gueniyo Lot opshino Sodoma kjokyo dwayo irgo ga akkwo l̈ono ter iök, shunyo shrono wl̈eni, ga nopga l̈i pjira drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ga tja wen obishko ga shäryë eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","»Eshko dbaryo ga ëye sök ba u dbo kjing sdok l̈i kjing go ga jek l̇l̇ëbo beno tjeng ba u roshko l̈i kjrë l̇l̇ëm, tök jekdo dey. Ëye shäng ba kjokshko ga jek ba ushko iröng, l̇l̇ëbo beno tjeng l̈i kjrë l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","L̇l̇ëye weno Lot boy kong dënashko l̈i woyotjl̈ĩzĩa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","»Ëye wotjl̈ĩk opdë om go, zrökoba bor kjĩshko l̇l̇ëm wl̈o l̈e ga äär kjok dogo l̇l̇ëme. Gueniyo ëye jëk bor tjok jl̈õkoyo, e zröraba bor kjĩshko ëmdë ga era ber sök së ĩyado kjok dogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","L̈ër bomi kong ga eshko dbaryo ga nopga tjeng do pjök bukkl̈o kjwaraso kjing go. Kjl̈ara söya, kjl̈ara ie ber buk eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ga wal̈ëga l̈öng do pjök l̇l̇ëbo kl̈äk. Kjl̈ara söya, kjl̈ara ie ber shäng eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kuya l̈ok ga tjl̈ẽ ba kong ga «Tjl̈apga, ¿shäryë eni l̈i, e kjone?» «Shinmo doyo buk kjone ga l̈ä̃ tjwe tön tjeng ara eshko» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Eshko ga Jesús tjl̈ẽno ba oppinggaga kong l̇l̇ëbo jyãgl̈o go, epga syõshtë ber l̈öng Sbö kong ĩyado wl̈o, wosonkë l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tjl̈ẽ ba kong ga «Kjok buk kjrinashko ga no shäng kjl̈ara no l̇l̇gwega, ëye bangkjre l̇l̇ëm, Sbö ëmdë ga bangkjre l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","4","Kjok eshko ga syã shäng kjl̈ara. Tjwe tjl̈apga kjok l̇l̇gwega wl̈eniyo l̈i shwoy enido, tjl̈ẽ ga “Bor wl̈oyo, e l̇l̇gwep bor kong sira. Tja wl̈ikozong” l̈e ba kong eni enido. Kjok l̇l̇gwega sök l̈i ĩya öör ga l̇l̇gweya woydë tjl̈apga l̈irë ba kong l̇l̇ëme. Eni ga ĩya jek tjwe obi, ĩya jek tjwe obi. »Gueniyo pjl̈ara ga tjl̈apga l̈i wotjl̈ĩk ga “Tja, ëye bangkjrër l̇l̇ëm, Sbö ëmdë ga bangkjrër l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Gueniyo wal̈ë kjwe tjwe shäng bor barwë ara enido. E kjĩshko ga l̇l̇ëbo l̈i l̇l̇gwer ba kong, tja barwe ame wl̈o. L̇l̇ëm ga tjwe bor barwë jek obi, ga tja ie ber sök wl̈ẽp l̇l̇ëme” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","»L̇l̇ëye l̈ara no l̇l̇gwega owarë l̈i, e woyotjl̈ĩzĩa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Pjãy wotjl̈ĩk ga Sbö, ba nopga kjrara tjeng l̈i wl̈ike l̇l̇ëme l̈ëmiro? Epga syõshtë l̈ok ba kong shkë dba, wl̈ike wl̈o. ¿Pjãy wotjl̈ĩk ga dborye mal̈ing l̇l̇ëme l̈ëmiro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","L̈ër bomi kong ga wl̈ike mal̈ing. ¿Gueniyo ga no to ter kjok dogo dwayo ëre tjwe kjok ëre kjing goshko ga nopga wl̈ẽn l̈öng mär bor gore?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nopga l̈öng eshko kjl̈öbö, wotjl̈ĩk ga «Tjawa jëk pjl̈o bek, obl̈ëra jëk bëy l̇l̇ëme» l̈e eni. Eni ga Jesús tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Domerga öötong l̈öng Sbö u zl̈ong bäng do pjök syõshtë. Kjl̈ara, e fariseo, kjl̈ara obi, e dbur töngga Roma so kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Eshko ga fariseo l̈i syõshtono shäng kojong, tjl̈ẽ ga “Sbö, tja no obl̈ë dik l̇l̇ëme. Tja l̈ũrkë l̇l̇ëm, tja l̇l̇ëbo owa shäryë l̇l̇ëm, tja pë oma boy obl̈ë tjok l̇l̇ëm bakoe. Dbur töngga kjwe jëk owa, tjara jëk eni l̇l̇ëme. Tja wopjl̈ú bop tjok e kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sondë kjwobi go ga tja ië l̇l̇ëm bop kong dbar pjök. L̇l̇ëbo wl̈ẽnor l̈i shtër äär ba sakyo (10) go, ba sakyo (10) go, shir kjrina kjrina, ga twër bop kong” l̈e eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","»Dbur töngga l̈ira beno shäng ro pjola sira. L̇l̇ëbo owa shäryara l̈i bangyo ba kong ara kjĩshko ga beno shäng pjl̈ú kjing shpok, ga kjok dogo jem ĩya woydë sira l̇l̇ëm, l̈öktkë ara Sbö bokso kjĩy. Eni ga syõshtono, tjl̈ẽ ga “Sbö, tja l̇l̇ëbo owa shäryono ara. Tja songe l̈ozong” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","»L̈ër bomi kong ga brik l̈okshko ga dbur töngga l̈i beno shäng pjl̈o bek Sbö bokso, fariseo l̈ira l̇l̇ëme. Ëye opyë ber tjwl̈õ ara ga ie ber tjwl̈õ l̇l̇ëme. Ëye opyë ber tjwl̈õ l̇l̇ëm ga ie ber tjwl̈õ ara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Eshko ga kjwozirga sökoba jek Jesús kong, Jesús orkwo ië ba kjing go wl̈o. Ĩya ba oppinggagarë ga kjwozirga sögaga l̈i wl̈ona. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Eni ga ba oppinggaga l̈i rokara Jesúsdë tek ba shwoy, ga tjl̈ẽ ba kong ga «Kjwozirga somi l̇l̇ëm, tek wẽyẽ bor shwoy. Ëye ber kjwozirga jũni ga Sbö ber ba pjl̈uyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","L̈ër bomi kong jl̈õkoyo ga ëye Sbö tjl̈õkwo kjrë kjwozirwa dik l̇l̇ëm ga äär ber sök Sbö sök no pjl̈uyo ĩyado l̈ishko l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tjl̈apga shäng kjl̈ara eshko tjwl̈õ ara wl̈eniyo. Tjl̈ẽ Jesús kong ga «Tjl̈apga no pingga, pja pjl̈úe. ¿L̇l̇ëye shäryër, tja ber sök së ĩyado Sbö tjok wl̈o?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","«¿Tja pjl̈úe l̈ëp ega? Pjl̈ú l̈i, e Sbö eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kjok l̇l̇gwekkl̈o tara Moisésdë l̈i, e miydëp tjän. “Shji pë oma boy obl̈ë tjok l̇l̇ëme. Shji no zrök l̇l̇ëme. Shji l̈ũrkë l̇l̇ëme. Shji obl̈ë jyõyotkë l̇l̇ëme. Bop data, bop mekë, e bangkjros, ios ber tjwl̈õ ara”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kuya ga tjl̈ẽ ba kong ga «Tjl̈õkwo l̈ëp shäng kës l̈i, e shäryër shäng enido, tja tek dwl̈as l̈ë obishko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kuya ga tjl̈ẽ ba kong ga «L̇l̇ëbo shäryorop kës l̈i, e pjl̈úe. Gueniyo l̇l̇ëbo beno kjrina obi. Pja nom bop l̇l̇ëbo tjeng kës l̈i soynek pjir, ga dburyo twos oba song wl̈eniyo kong. Enira pja l̇l̇ëbo ara kjok dogo. Pjir ga pja tek bor tjok, pja pin wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kuya ga beno shäng woydë ara, dbur ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Woydë ara l̈i ĩya Jesúsdë ga tjl̈ẽ ga «Nopga dbur ara wl̈eniyo äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko wl̈o ga kjange. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Öng jëkkl̈o sok kësbang wl̈eniyo opzrëk jek shkö bokkwo bäng go ga kjange. Gueniyo nopga dbur ara wl̈eniyo äär ber l̈öng Sbö sök no pjl̈uyo ĩyado l̈ishko wl̈o ga kjang anmoyõ» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kuya l̈öng eshko l̈irë ga tjl̈ẽ l̈ok ba kong ga «¿Enira ëye därdo?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","«L̇l̇ëye shärye norë ga ä l̈i, e shärye Sbörë ga pjl̈úe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Eshko ga Pedro tjl̈ẽ ba kong ga «Borwa l̇l̇ëbo tjeng kës l̈i rayororwa beno pjir, tjawa jek bop tjok wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kuya ga tjl̈ẽ ba kong l̈ok ga «L̈ër bomi kong jl̈õkoyo ga ëye, ba u, ba boy, ba kjl̈ara, ba data, ba mekë, ba wapga, e rayara, Sbö ber ba pjl̈uyo wl̈o ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ãska wl̈ẽya ara anmoyõ. Kjok ëre kjing go ga wl̈ẽya l̇l̇ëye rayara l̈i pjl̈ogl̈o ara obi. Ga l̇l̇onoshko ga ber sök së ĩyado Sbö tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Eshko ga ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) l̈i rokara dboshko, ga tjl̈ẽ ba kong ga «Shji to Jerusalén kjokyo. Eshko ga l̇l̇ëye tara Sbö tjl̈õkwo l̈agagarë no to ter kjok dogo dwayo ëre kjĩshko l̈i, e shäryë eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tja twëba nopga judío l̇l̇ëm wl̈eniyo kong, ga tja joywe l̈ok, tja l̈ãywe l̈ok owa, tröng twe l̈ok bor go, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","tja shpoya l̈ok no shpokkl̈o go, ga tja zröya. Gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","L̇l̇ëye l̈ara l̈i, e l̇l̇ë l̈okl̈o miydara l̈ok l̇l̇ëme. E tjl̈õkwo rong kjĩshko ga l̇l̇ë l̈okl̈o miydara l̈ok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús jëk shäng ääto Jericó kjokyoshko ga domer sök kjl̈ara eshko kjok ĩgö l̇l̇ëm wl̈eniyo. E sök dbur rokë irbo l̈i sor go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kuya sök ga nopga jëk l̈öng träk l̇l̇ëm ga tjl̈ẽ ga «¿Oba jëk l̈öng l̇l̇ë kjĩshko?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","«Jesús, Nazaret so l̈i tekdo shäng» l̈ëba ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kuya ga tjl̈ẽ ba kong dbo go ga «¡Jesús, David tjëyo, tja songe l̈ozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kuya nopga jëk l̈öng Jesús bäm go l̈irë ga tjl̈ẽ ba kong ga «Pja kjinkozong» l̈e ba kong, gueniyo kjinkë l̇l̇ëme. Tjl̈ẽno dbo go jek obi, tjl̈ẽ ga «¡David tjëyo, tja songe l̈ozong!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eni ga Jesús kojongö shäng ga tjl̈ẽ l̈öng l̈i kong ga «Tek sözĩ bor shwoy» l̈e, ga söra l̈ok jek ba shwoy. Eshko ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«¿L̇l̇ëye woydëp ga shäryër bop kong?» «Tjl̈apga, tja kjok ĩk woydë» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kuya ga tjl̈ẽ ba kong ga «Kjok ĩs jek obi. Pja mär bor go kuzong ga pja poptonoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jekdo eshko ga beno shäng kjok ĩgö wẽl̈ë, ga to jek shäng Jesús tjok Sbö poshrëk. Ĩya nopga l̈öng eshko l̈irë ga beno l̈öng Sbö poshrëk bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E irgo ga Jesús opzrëno jek Jericó kjokyo roshko, tur pjl̈or kal̈ëkong wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Domer sök eshko kjl̈ara ko Zaqueo, e dbur ara. E parkë shäng dbur töngga Roma so kong l̈i kägäyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesús, e sorë ĩya woydë. Gueniyo domer l̈i sok chirawa töshko, ga oba ara. E kjĩshko ga ĩya ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eni kuzong ga Jesús tek tjwe irbo e go miydarashko ga jek zron jong ba bäm go këm jũni. Ga tjyono jem kjor jong eshko kjl̈ara l̈i ko roy, ĩya wẽl̈ë wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús jek shäng irbo e goshko ga ĩya sök kjomo, ga tjl̈ẽ ba kong ga «Zaqueo, pja opl̈õs kjwey dwayo ter töshko mal̈ing. Eeri ga tja ber sök bop ushko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kuya ga opl̈ono ter töshko mal̈ing, ga Jesús wl̈okjrara shäng wopjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Eni ga ĩya l̈öng eshko l̈irë ga Jesús l̈ãywe l̈ok owa ara. Tjl̈ẽ l̈ok ëng kong ga «Domer kjwe l̇l̇ëbo owa shäryaga. ¿Jesús kjwe jek ba ushko l̇l̇ëno?» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Eshko ga Zaqueo kojongö shäng, tjl̈ẽ Jesús kong ga «Tjl̈apga, bor l̇l̇ëbo tjeng kës l̈i twër bëy oba song wl̈eniyo kong. Ga ëbo l̇l̇ëbo l̈ũyotkoror jyãpgwër ĩ wl̈eni ga ãska twër iröng bayo l̇l̇ëbo kjroror l̈i pjl̈ogl̈o pkëng (4)» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kuya ga tjl̈ẽ ba kong ga «Eeri ga pja döktong, bop pjeyoga l̈öng bop ushko l̈i tjok. Jl̈õkoyo ga pja Abraham tjëyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","No to ter kjok dogo dwayo ëre shrono shäng no jeno l̈öng wl̈eniyo, e wl̈ẽga, e döga» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús jek jëk shäng ääto Jerusalén kjokyoshko ga nopga jëk l̈öng ara ba tjok, l̇l̇ëye l̈e l̈i kuya l̈ok wl̈o. Wotjl̈ĩk l̈ok ga äär Jerusalén kjokyo ga Sbö ber no pjl̈uyo dbaryo l̈i eshkoro l̈ara. Miga eni l̇l̇ëme. E kjĩshko ga Jesús tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tjl̈ẽ ga «Pjl̈ara ga domer shäng kjl̈ara, tjwl̈õ ara wl̈eniyo. To kjok shto obl̈ë pjola, iëba ber sök ba kjokshko sopga pjl̈uyo wl̈o, ga tjwe iröng ba kjokshko wl̈o l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Opshiydë l̇l̇ëm obishko ga ba parkagaga rokara dogl̈o sak kjwara (10). Kjl̈ara kjl̈ara kong dbur twara bayo ara, ga tjl̈ẽ ba kong l̈ok ga “Pjãy ber l̈öng dbur shak ëre go, tja tjwe iröng obi guing” l̈e ba kong, ga toe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","»Gueniyo ĩywa kjok eshko sopga l̈irë shjiktëng. E kjĩshko ga nopga ichara kjl̈öbö ba irgo, tjl̈ẽ ga “Kjwe woydërwa ber borwa pjl̈uyo l̇l̇ëme” l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Woydara l̈ok eni l̇l̇ëm ëmdë ga iaraba beno sök ba pjl̈uyo. »E irgo ga tek shrono iröng ba kjokshko. Shrono shäng ga ba parkagaga kong dbur twara l̈i, e rokara, dbur shano e go kjöme miyde wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","»Parkaga shrono shäng bäm go l̈i tjl̈ẽ ba kong ga “Tjl̈apga, bop dbur tworop bor kong l̈i go ga kjingsho sharor kjringgwo sak kjwara (10) obi” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","»Kuya ga tjl̈ẽ ba kong ga “Pjl̈úe. Pja parkaga pjl̈ú wl̈eniyo. Pja kong l̇l̇ëbo tworor chira, ga dorop pjl̈o beke. E kjĩshko ga pja iër ber no ichaga kjok kjringgwo sak kjwara (10)” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","»E irgo ga parkaga shrono shäng kjl̈ara obi, tjl̈ẽ ba kong ga “Tjl̈apga, bop dbur tworop bor kong l̈i go ga kjingsho sharor kjringgwo shkëng (5) obi” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","»Kuya ga tjl̈ẽ ba kong ga “Eni ga pja iër ber no ichaga kjok kjringgwo shkëng (5)” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","»E irgo ga parkaga shrono shäng kjl̈ara obi, tjl̈ẽ ba kong ga “Tjl̈apga, bop dbur tworop bor kong kjupargue l̈i kjros iröng. Popgoror beno tjeng jangsher roshko, jer l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Miydër pjl̈ú ga pja kjange. Pja parkono l̇l̇ëmshko ga pja dbur shak eshko, ga pja dwl̈a bo kjrë, dwl̈a dgorop l̇l̇ëmshko bakoe. E kjĩshko ga pja bangkjroror ara” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","»Kuya ga tjl̈ẽ ba kong ga “Pja parkaga owa wl̈eniyo. Pja l̇l̇gwer, tjl̈õkwo l̈ëp shäng om go l̈i go. Miydëp pjl̈ú ga tja kjange. Tja parkono l̇l̇ëmshko ga tja dbur shak eshko, ga tja dwl̈a bo kjrë, dwl̈a dgoror l̇l̇ëmshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","E kjĩshko ga bor dbur ëre sörop, jnenop beno dbur jnezl̈ong uyo roshko kjwe dey. Eni kjwe ga tja tjwe iröng obi ga tja dbur töno e kjinmo kjwe” l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","»Eshko ga pjl̈u l̈i tjl̈ẽ ba parkagaga obl̈ë l̈öng eshko l̈i kong ga “Ba dbur tjeng ba wl̈oshko kjwe dözĩ, twozĩ kjl̈ara shäng dbur shara kjringgwo sak kjwara (10) l̈i kong” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","»Kuya l̈ok ga tjl̈ẽ ba kong ga “Tjl̈apga, kjwera dbur tjeng kjringgwo sak kjwara (10) tjän” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","»Kuya ga tjl̈ẽ ba kong ga “L̈ër bomi kong ga ëye l̇l̇ëbo tjok ga së̃ya jek obi. Ëye l̇l̇ëye l̇l̇ëm ga l̇l̇ëye tjeng sirawa l̈i döya ba shjiryo drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E ga bor wl̈oyoga l̈ira, tja woydara ber ba pjl̈uyo l̇l̇ëme. Epgara to shami, ga tek sözĩ, zrömi bor bokshto wl̈o”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús tjl̈ẽno eni pjir ga jek jongya Jerusalén kjokyo obi, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ga öötong shäng Betfagé kjokyo, Betania kjokyo, e ber l̈öng Olivos dl̈upyo pogl̈o go. Eshko ga ba oppinggaga jek l̈öng ba tjok l̈i rokara do pjök, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ga tjl̈ẽ ba kong ga «Pjãy nom kjok buk bi bokshto kjweshko. Eshko ga öng so kwomgl̈a kjoyo dre töshko l̇l̇gwokl̈ë wl̈eniyo wl̈ẽmi sök kjro go kjl̈ara wl̈ënggl̈a, kjing go ëye opyoydë l̇l̇ëm wl̈eniyo. Komi, ga tek sömi bor kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Eshko ga ëbo tjl̈ẽ bomi kong ga “¿Komi kjweni ega?” l̈e bomi kong wl̈eni ga “Woyde Tjl̈apgarë” l̈ëmi ba kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eni ga jek öötong l̈öng eshko, ga öng wl̈ẽna sök kjl̈ara, l̈ara ba kong sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kõya l̈öngshko ga ĩya ba sogogarë ga tjl̈ẽ l̈ok ba kong ga «¿Öng kjwe komi l̇l̇ëno?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","«Woyde Tjl̈apgarë» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eni ga öng l̈i tek söra shrono l̈öng Jesús kong, ga ba shwong kop l̈ëkong iara l̈ok öng l̈i kokso kjing go. Eshko ga Jesús kjimtara l̈ok opyë sök öng l̈i kjing go, ga jeke. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jek sökshko ga nopga jëk l̈öng ba tjok ara. Kjone kjone, ba shwong kop l̈ëkong skwara l̈ok, ga kwoptara l̈ok irbo bäng go ba bäm go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jek sök ääto kjujõzl̈ong irboyoshko ga nopga jëk l̈öng ba tjok l̈i, öö l̈e l̈ok, wopjl̈ú kjĩshko. Ga Sbö poshrëya l̈ok träk l̇l̇ëm, l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo ĩna l̈ok ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tjl̈ẽ ga «Pjl̈u kjwe ichara Tjl̈apgarë shrono kjok ëreshko. Kjwe kjimte Sbörë. L̈öng kjok dogo l̈i l̈öng wopjl̈ú Sbö tjok, poshrëya l̈ok träk l̇l̇ëme. “Pja kësbange” l̈e l̈ok ba kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fariseoga l̈öng eshko kjl̈öbö, nopga l̈i tjrëko. Kuya l̈ok ga tjl̈ẽ Jesús kong ga «Tjl̈apga no pingga, bop oppinggaga kjwe kjinkozong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kuya ga tjl̈ẽ ba kong ga «L̈ër bomi kong ga kjwepga kjinkoror kjwe ga akkwo tjeng kjwey, öö l̈e shara» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jek sök ääto Jerusalén kjokyo ga kjok l̈i ĩna, ga sl̈atong ara, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","tjl̈ẽ ga «Jerusalén sopga, pjãy iaga ber l̈öng wl̈ẽp l̈i ë, e miydomirë l̇l̇ëm obi. Woydoror ga miydoromi tjän, gueniyo jnek tjeng pjir bomi kong, miydëmi l̇l̇ëm wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Sbö shrono sök bomi ĩkshko ga wl̈okjroromi l̇l̇ëme. E kjĩshko ga dbar tjwe bomi kong owa kjrina. Eshko ga pjãy popde bomi moskwogarë l̈ok, ga pjãy kopjrĩya l̈ok pjribri, pjãy opshik tök l̇l̇aw l̇l̇ëm wl̈o. Bomi kjok kjëryo shäryak ak go pjribri kjókshko kjwe dl̈oya l̈ok ber tjeng töshko, akkwo ëmdë ber tjeng ëng kjing go kjwara l̇l̇ëme. Eshko ga pjãy zröya l̈ok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús opzrëno jek Jerusalén kjokyo roshko irgo ga öötong shäng Sbö u zl̈ong bäng ga nopga l̈öng eshko l̇l̇ëbo soynek l̈i ichara opshik ey dwayo, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","tjl̈ẽ ga «Sbö tjl̈õkwo tak pjang eni: “Bor u, e kowëba ber syõ uyo wl̈o. Gueniyo ioromi beno jong l̈ũ uyo”» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Dbar kjwobi go ga Jesús öör shäng nopga ping Sbö u zl̈ong bäng. Ga syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, tjl̈apgaga tjwl̈õ ara wl̈eniyo, e tjl̈ẽ ëng kong ga «¿Zröy sorë ga pjl̈ú?» l̈e l̈ok eni enido. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Gueniyo shaya l̈ok ga ä, Jesús zl̈ong bäng nopga l̈öng ara ba kuk kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dbar kjwara ga Jesús Sbö tjl̈õkwo roy pjl̈ú l̈ono oba kong Sbö u zl̈ong bäng. Eshko ga oba pĩya shäng wopro ga syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo, e tek shrono l̈öng ba zl̈ong bäng ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ga tjl̈ẽ l̈ok ba kong ga «¿L̇l̇ëye shäryëp shäng l̈i shäryëp ega? ¿Pja ichaga ërë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","«Pjãy kong l̇l̇ëbo kjakrokër bakoe. Kjakrokër ga tja dboryozĩa. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Juan No Waga, e ichaga ërë no wë? ¿Ichaga Sbörëre, de norë?» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kuya l̈ok ga tjl̈ẽ ëng kong ga «Ichaga Sbörë l̈oroy ba kong wl̈eni ga “¿Tjl̈õkwo kjroromi l̇l̇ëm ega?” l̈e bi kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Gueniyo Juan, e Sbö tjl̈õkwo l̈aga l̈e nopga uunkongdë. E kjĩshko ga ichaga norë l̈ëy ga ä bakoe. L̈oroy eni wl̈eni ga shji zröya l̈ok ak go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Eni ga tjl̈ẽ l̈ok Jesús kong ga «E ichaga ërë miydërwa l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kuya ga tjl̈ẽ ba kong ga «E kjĩshko ga tja ichaga ërë l̈ër bomi kong l̇l̇ëm bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Eshko ga Jesús tjl̈ẽno nopga kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga «Domer shäng kjl̈ara kjok sogo. Pjl̈ara ga kjil̇l̇gwo dwl̈ayo dgara ba kjokshko, ga kjok l̈i poskwona parkagaga kjl̈öbö kong, potjwl̈ẽya ĩ, ga to kjok shto obl̈ë dbar kop ara wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Öötong kjil̇l̇gwo bo kjrozl̈ong dbaryo ga ba parkaga ichara kjl̈ara, kjil̇l̇gwo bo ber ba kong l̈i rokë parkagaga beno l̈öng ba kjok daga l̈i kong. Gueniyo ga ba parkaga ichara tjwe shäng l̈i shpokza l̈ok tjã tjã, ga ichara l̈ok to iröng or go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","E irgo ga ba parkaga ichara jek eshko kjl̈ara obi. Öötong shäng kjok buk l̈ishko ga l̈ãywara l̈ok owa, shpokza l̈ok tjã tjã, ga ichara to iröng or go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","E irgo ga ba parkaga ichara jek eshko kjl̈ara obi. Era shpokza l̈ok tjã tjã, dbukza l̈ok jek kjoko, srëng l̇l̇ë kwono l̇l̇aw pogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","»Eni ga domer l̈i wotjl̈ĩk ga “¿Tja orwë l̇l̇ong? Bor wa woydër ara ëre ichotë shara. Ërera bangkjre l̈ok kjwe” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","»Gueniyo öötong shäng eshko ga ba wa l̈i ĩya parkagaga kjok daga l̈öng l̈irë ga tjl̈ẽ l̈ok ëng kong ga “L̇l̇ono ga kjwe ber kjok ëre sogo. Zröroy wl̈eni ga kjok ëre kjrëy, ber buk bi kong wl̈o” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eni ga shira l̈ok kjok l̈i roy dwayo, ga zröra l̈ok. »¿Eni ga l̇l̇ëye shärye kjok sogo l̈irë ba tjok l̈ok l̈ëmi? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","E jongya eshko ba zrök dani. Pjir ga parkagaga wl̈ẽya obl̈ë, kjok l̈i de l̈ok ba kong wl̈o» l̈e. Kuya l̈ok ga tjl̈ẽ l̈ok ga «¡Ay! ¡Eni l̇l̇ëme!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Eshko ga nopga l̈i ĩya Jesúsdë jek drëng ga tjl̈ẽ ba kong l̈ok ga «Sbö tjl̈õkwo tak pjang eni: »“Akkwo woydara u shäryagagarë l̈ok l̇l̇ëm l̈i, e iak beno buk bäm go, beno tjwl̈õ ara, obl̈ë kjinmo.” ¿E l̇l̇ë l̈okl̈o l̈ëmiro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ëye l̈ono akkwo ëre kjing go ga tar pjäs erä. Ga akkwo ëre l̈ono ë kjing go ga e sho shguir ber tjeng l̈ul̈ue» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tjl̈ẽno l̇l̇ëbo jyãgl̈o go l̈i kuya no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, syõshtaga kägäyogarë ga miydara l̈ok ga ba l̈ayde shäng. Shaya l̈ok woydë, bängzaya l̈ok wl̈o. Gueniyo oba bangkjre l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eshko ga nopga ichara l̈ok kjl̈öbö oba l̈i tjrëko, Jesús tjl̈õkwo kuk wl̈o. Nopga l̈i ĩkoba ga pjl̈o bek wl̈eniyo, miga l̇l̇ëme. Woydara l̈ok ga l̇l̇ëbo kjakroke Jesús kong, dborye bëy l̇l̇ëm ga doshaya l̈ok e go, rote no ichaga Roma so l̈i kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Eshko ga nopga ichara l̈i tjl̈ẽ l̈ok Jesús kong ga «Tjl̈apga no pingga, miydërwa ga pja tjl̈ẽ bek, oba pim tjl̈õkwo bek l̈i go bakoe. Nopga tjwl̈õ kjöm pogo, e bop kong ga tjwl̈õ beke. Pja tjl̈ẽ bek ë pogo kong. Woyde Sbörë ga shji jëk sorë l̈i l̈ëp jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Eni ga shji kä potjwl̈ẽk pjl̈u kësbangyo sök Roma kjokyo l̈i kong ga pjl̈úre?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kuya ga miyde ga l̈öng wotjl̈ĩk owa. E kjĩshko ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Dburwa kä potjwl̈ẽkkl̈o l̈i tek sözĩ bor kong kjwara» l̈e, ga tek söra l̈ok ba kong kjwara, ĩn wl̈o. Eni ga kjrara, ga tjl̈ẽ ba kong l̈ok ga «¿Domer jyãgl̈o sök dburwa ëre go jũ ë? ¿Ko tak pjang ëre go jũ ë?» «Kjwe pjl̈u kësbangyo sök Roma kjokyo l̈i ĩ» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kuya ga tjl̈ẽ ba kong l̈ok ga «Eni ga l̇l̇ëye pjl̈u ĩ l̈i, e twozĩ ber pjl̈u kong, gueniyo l̇l̇ëye Sbö ĩ l̈i, e twozĩ ber Sbö kong bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eni ga l̇l̇ëbo l̈ara oba kong l̈i go ga l̇l̇ëbo wl̈ẽya l̈ok, rote wl̈o l̈e l̈i, e wl̈ẽna l̇l̇ëme. E kjĩshko ga beno l̈öng yëy l̈e erä, jek kjingtëng l̈öng erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduceoga wotjl̈ĩk ga no wol̈ono ga woshrë ame l̈e. Eni ga eshko dbaryo ga saduceoga tek shrono l̈öng Jesús shwoy kjl̈öbö ga tjl̈ẽ ba kong ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Tjl̈apga no pingga, kjibokwo tara Moisésdë beno pjang l̈i tjl̈ẽ ga “Ëye wol̈ono, wapga beno ba boy tjok l̇l̇ëm ga shinmo kjl̈arayo l̈i orkwosmok ba boy beno sök l̈i tjok, wa tjok wl̈eni ga e ber shinmo l̈i ĩ wl̈eni wl̈o.” ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","»Pjl̈ara ga domerga l̈öng dogl̈o kjäk (7) epenga döe. Ba këguëyo orkwosmono, ga wol̈ono, gueniyo wapga beno l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Eni kuzong ga ba l̈ëng orkwosmono ba syã tjok, gueniyo wol̈ono jek, ga wapga beno l̇l̇ëm bakoe. Ba l̈ëmga orkwosmono ba syã tjok kjl̈ara kjl̈ara eni bako, ga wol̈ono uunkong, gueniyo wapga beno ba boy tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","E irgo ga wal̈ë l̈i to wol̈ono bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Eni ga domerga dogl̈o kjäk (7) l̈i orkwosmono uunkong wal̈ë l̈i tjok kuzong ga no woshrozl̈ong dbaryoshko ga wal̈ë l̈i ber domerga kjone dey l̈i boy?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","«Eerishko ga nopga orkwosmok ëng tjok kjok ëre kjing go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Gueniyo l̇l̇ono ga nopga tjwl̈õ ara Sbö bokso woshre ber l̈öng ba tjok wl̈o l̈i, era orkwosmok ame, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ga wol̈on ame bakoe. Eshko ga ber l̈öng Sbö parkagaga kjok dogo so wl̈eni shara. Woshrara Sbörë kjĩshko ga beno l̈öng Sbö wapga. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","»Dënashko ga Moisés öötong shäng kji sho pjë jong ri rishko ga tjl̈ẽ ga “Sbö, e Abraham, Isaac, Jacob, e Sbö” l̈e. Miydëy e go ga shji wol̈ono ga shji woshrë iröng obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sbö, e shinmoga Sbö l̇l̇ëme. E nopga l̈öng së l̈i Sbö. Ba kong ga shji nopga uunkong l̈öng së, shji wol̈ono ëmdë ga eni» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","No pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go l̈öng eshko kjl̈öbö. Kuya kjone kjonerë ga tjl̈ẽ ba kong ga «Tjl̈apga no pingga, dboryorop beke» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Eshko dbaryo jek l̈ëkong ga ëye wokjang l̇l̇ëbo kjakrokë ba kong wl̈o ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Eshko ga Jesús tjl̈ẽ nopga l̈öng l̈i kong ga «¿“No pjl̈uyo iche l̈e Sbörë l̈i, e David tjëyo tek ber ba irgo l̈i” l̈ëba eni ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kjibokwo ko Salmos go ga David tjl̈õkwo tono om go, tjl̈ẽ ga »“Tjl̈apga tjl̈ẽno bor Tjl̈apgayo kong ga ‘Pja tek wl̈ar ber sök bor orkwo kël̈ëkong, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","äär jong bop moskwoga zanor pjir guing, eshko ga twër ber bop kong ichëp wl̈o’” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Eni ga no pjl̈uyo l̈i kowara Daviddë ba Tjl̈apgayo kuzong ga e ber ba tjëyo tek ber ba irgo l̈i sorë?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eshko ga Jesús tjl̈ẽno ba oppinggaga kong shara. Gueniyo nopga l̈öng eshko l̈i omkuno l̈ok bakoe. Tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«¡Pjãy sjëk, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë go l̈i tjok! Jëk l̈öng doyono shwong kur may, tjwl̈õ ara wl̈eniyo go äe. Woyde l̈ok ga bangkjrëba l̇l̇ëbo soynezl̈ong shtoyo. Judíoga syõ uyo roshko ga woyde l̈ok ga l̈öng sökkl̈o pjl̈ú goshko. Oba tön, iëshko ga shärye l̈ok eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gueniyo ga wal̈ëga song, beno l̈öng syã wl̈eniyo, ba u döya l̈ok ba shjiryo. E irgo ga syõshtë wop ara, “Nopga kjwera pjl̈úe” l̈ëba ba kjĩshko wl̈o l̈e. Nopga eniyo, e shdũya Sbörë ara anmoyõ, obl̈ë kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pjl̈ara ga Jesús sök Sbö u zl̈ong bängshko ga ĩya ga nopga dbur ara wl̈eniyo tek l̈öng dbur ië jong ba bapkwo roy. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Eshko ga syã song wl̈eniyo shrono shäng kjl̈ara, ga dburwa iara kjwo pjökdewa. Ba dburwa iara l̈i, e tjwl̈õ chira anmoyõ wl̈eniyo. Ĩya Jesúsdë ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","tjl̈ẽ ga «Nopga dbur ara wl̈eniyo kjwe omiono ara wl̈eni jl̈õe. Gueniyo kjwe ba worbo wl̈eniyo iayde. Syã song wl̈eniyo kjwera, ba dburwa tjeng sira l̈i woydara ba l̇l̇ëbowa tjwl̈ẽkkl̈o. Eni ëmdë ga twara Sbö kong drete. E kjĩshko ga l̈ër bomi kong jl̈õkoyo ga syã kjwe, dburwa iara sira tjwl̈õ l̇l̇ëm wl̈eni jl̈õe. Gueniyo Sbö kong ga tjwl̈õ ara, l̇l̇amo omiono l̈ok kës wl̈e kjinmo» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eshko ga ba oppinggaga kjong kjong l̈öng Sbö u l̈ãywë, tjl̈ẽ l̈ok ga «Ak l̈ok kjwe wol̈ëso. L̇l̇ëbo obl̈ë obl̈ë twaraba, iaraba beno tjeng dboy Sbö kong kjwe wol̈ëso bakoe» l̈e l̈ok eni. Eshko ga Jesús tjl̈ẽ ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Dbar tjwe kjwara ga l̇l̇ëbo ĩmi l̈öng kës kjwe, e pjir ber drete. Akkwo ëmdë ber tjeng ëng kjing go kjwara l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kuya l̈ok ga tjl̈ẽ ba kong ga «¿L̇l̇ëye l̈ëp shäng l̈i, e shäryë l̇l̇ono? ¿E shäryë dörö l̈i jyãgl̈o wen l̇l̇ë?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","«Pjãy sjëk, pjãy jyãpgwëba l̇l̇ëm wl̈o. Eshko ga nopga wen tjwe ara, tjl̈ẽ ga “No pjl̈uyo ichara Sbörë shrono shäng l̈i tja” l̈e. Tjl̈ẽ jek obi ga “Dbaryo l̈i shronoe” l̈e. Gueniyo pjãy jek ba tjok l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","»Roy kumi ga oba ëngkjwë kjok shto obl̈ë obl̈ë ara, l̇l̇ëm ga oba ëngkjwë ba pjl̈uyo sök l̈i l̈ong wl̈oshko ga l̇l̇ëye bangkjrëmi l̇l̇ëme. E shäryë eni kjl̈uwe. Gueniyo eshko ga kjok pjir dbaryo l̈i äätë l̇l̇ëm obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","»Tjëyoga obl̈ë obl̈ë ëngkjwë l̈ok ëng tjok. Nopga kjok shto obl̈ë obl̈ë so ëngkjwë l̈ok ëng tjok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kjok shto obl̈ë obl̈ë goshko ga yo tjwe këskës, pjl̈i tjwe ara, swl̈o tjwe obl̈ë obl̈ë bakoe. Ga kjok dogoshko ga l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo wen këskës, ga bangkjrëba ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","»Gueniyo l̇l̇ëbo tjeng kës ëre bäm go ga pjãy shakoba, shdungoba wl̈o. Pjãy sökoba judíoga syõ uyo roshko, pjãy l̇l̇gweya l̈ok eshko wl̈o, ga pjãy ie l̈ok ber l̈öng no shdũzl̈ong uyo roshko. Bor kjĩshko ga pjãy sökoba pjl̈upga këskës bokshto, no ichagaga bokshto bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eshko ga l̇l̇ëbo ĩnomi, kuromi l̈i roy l̈ëmi ba kong, miyde l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","»Gueniyo pjãy äätë eshko l̇l̇ëm obishko ga pjãy wotjl̈ĩk ga “¿Tja opwl̈ikë sorë?” l̈ëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eshko ga pjãy kong tjl̈õkwo twër, pjãy opwl̈ikë wl̈o. Kuya l̈ok ga wotjl̈ĩk ga pjãy kjok miydë ara l̈e, ga pjãy kar dborye l̈ok ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gueniyo pjãy wl̈oyo ber bomi dataga, bomi mekëga, bomi pjeyoga bakoe. Pjãy twe l̈ok tjl̈apgaga kong, pjãy shdũya l̈ok wl̈o, ga pjãy kjone kjone zröya l̈ok bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pjãy ĩywa nopga uunkongdë shjiktëng bor kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Gueniyo pjãy dër ĩyado, pjãy jer kjl̈ara l̇l̇ëm wl̈o. Bomi käkzong ëmdë ga jer pjl̈ara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ga pjãy mär Sbö go äär jong ba dbo go ga pjãy ber l̈öng së ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","»Ĩmi ga Jerusalén kjokyo kopjrina ëngkjwagaga ararë pjribrishko ga miydëmi e go ga ba pjirzl̈ong dbaryo l̈i döröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Eshko ga ëye l̈öng Judea kjokyo ga tök jem dl̈up l̈ëkong, ëye l̈öng Jerusalén kjokyo roshko ga tök ey dwayo, ga ëye l̈öng ba kjokshko ga tjwe iröng Jerusalén kjokyo ame. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jerusalén so shdunggl̈o dbaryo l̈i eshko, tak pjang Sbö tjl̈õkwo go sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","E dbaryo ga wal̈ëga l̈öng kjl̈araso l̇l̇ëm, e song jl̈õe. Wal̈ëga kjwozirwa tjeng nä ië, e song jl̈õ bakoe. Eshko ga kjok ëreshko sopga song ara anmoyõ, shdũya Sbörë ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kjong kjong zrökoba dröng go. Kjong kjong sökoba to dbo go kjok shto obl̈ë obl̈ë. Ga nopga judío l̇l̇ëm wl̈eniyo äär ber l̈öng Jerusalén kjokyo, ga l̇l̇ëbo owa shärye l̈ok eshko, äär jong ba dbaryo pjitong guing. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","»Eshko ga kjok dogoshko ga l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo wen dl̈o go, mok go, dbala go bakoe. Kjok ëre kjing goshko ga dl̈ung, e pjl̈ubl̈unyo këskës ara, pjl̈ukyo ara bakoe. E kjĩshko ga tjëyoga obl̈ë obl̈ë ber l̈öng sëya l̇l̇ëm, kjok bangkjrë l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","L̇l̇ëbo wen tjwe kjok ëre kjing go l̈i ĩkobashko ga kjone kjone wopjir jek kjl̈ul̈u erä. L̇l̇ëbo l̈ok kjopkwo go ëmdë ga jek dete erä bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Eshko ga ĩkoba ga no to ter kjok dogo dwayo ëre ter tjwe pjäng sho roy, ga bor dbo kãl̈ã ĩkoba wẽl̈ëe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","L̇l̇ëbo ëre ĩmi kjwl̈ë enishko ga miydëmi e go ga bomi döga dbaryo l̈i döröe. E kjĩshko ga eshko dbaryo ga pjãy dbokjrozong. Ga pjãy wotjl̈ĩs l̇l̇ëye wen dörö l̈i kjĩshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Eshko ga tjl̈ẽno ba kong l̇l̇ëbo jyãgl̈o go. Tjl̈ẽ ga «Kjor ko higuera kjwe ĩzĩa. Kjor obl̈ë obl̈ë kjwe ĩzĩ bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Korga wen tjagl̈ënshko ga miydëmi e go ga l̈ushko dbaryo äätoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eni ga l̇l̇ëbo tjeng kës ëre shäryë l̈i ĩmishko ga miydëmi e go ga Sbö ber no pjl̈uyo dbaryo l̈i ääto eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","L̈ër bomi kong jl̈õkoyo ga nopga l̈öng eerishko dbaryo kjone kjone wol̈ontë l̇l̇ëm obishko ga l̇l̇ëye l̈ër shäng bomi kong ëre shäryë uunkong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kjopkwo, kjok ëre, e pjir ber drete. Gueniyo bor tjl̈õkwora ber pjang ĩyado. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","»Pjãy sjëk, bor tjl̈õkwo woyotjl̈ĩzĩ ĩyado. Pjãy sgara l̈öng nel̈õtkë, l̇l̇ëbo owa shäryë, l̇l̇ëbo tjeng kjok ëre kjing go woyotjl̈ĩk wl̈eni ga eshko dbaryo ga pjãy wl̈ẽya l̈öng l̇l̇ë l̈ëmi. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","L̇l̇ëbo wen eshko dbaryo l̈i, e wen tjwe nopga tjeng kjok kjwang jĩkong kës l̈i kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","¡Eni ga pjãy sjëke! Pjãy syõshtos Sbö kong ĩyado, pjãy döya l̇l̇ëbo owa shäryë kës l̈i dwayo wl̈o, no to ter kjok dogo dwayo ëre ber wopjl̈ú bomi tjok wl̈o bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Dbar kjwobi go ga Jesús öör shäng oba ping Sbö u zl̈ong bäng, ga kjok sëng ga opshino jek iröng beno sök Olivos dl̈upyoshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ga kjok shröngto ga nopga uunkong öör Sbö u zl̈ong bäng ba kuk. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Eshko ga Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o, pjl̈ung shosho suk pjir shäryak ba uukkl̈o tjok l̇l̇ëm dbaryo l̈i döröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Eshkoshko ga syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e töno l̈ok ga tjl̈ẽ l̈ok ëng kong ga «¿Jesús, e shay, zröy wl̈o sorë ga pjl̈ú?» l̈e, gueniyo oba bangkjre l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jesús oppinggaga dogl̈o sak kjwara kjingsho pjök (12) kjl̈ara ko Judas Iscariote. Eshko dbaryo ga Ä shrono, pjono ba go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eni ga Judas öör shäng syõshtaga kägäyoga, Sbö u daga kägäyoga, e ĩk, Jesús twe ba kong l̈ok sorë l̈i l̈anyotkë ba kong l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kuya l̈ok ga beno l̈öng wopjl̈ú, ga tjl̈ẽ l̈ok ba kong ga «Enira pja potjwl̈ẽnwa» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kuya ga «Jöl̈ö. Enira pjl̈úe» l̈e. Eshko jek l̈ëkong ga beno shäng wotjl̈ĩk ga «¿Jesús twër ba kong sorë ga pjl̈ú? Woyde ga dbar oba ara l̇l̇ëm wl̈enishko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","E irgo ga pjl̈ung shosho suk pjir shäryak ba uukkl̈o tjok l̇l̇ëm dbaryo l̈i öötonge. E dbaryo ga öng wl̈ẽp ushko so l̇l̇gwokl̈ë zröya, sho suya, Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Eshko ga Jesús tjl̈ẽ Pedro, Juan kong ga «Pjãy nom dl̈i shäryë, Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo l̈i shrëy wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kuya l̈ok ga tjl̈ẽ ba kong ga «¿Shäryërwa kjone ga pjl̈ú?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","«Pjãy nom jek u l̈ok arashko. Eshko ga domer wl̈ẽmi shäng kjl̈ara, di bapkwo sök jong kjwara ba dl̈u kjing go, roshko di. Pjãy jek ba irgo äär jong opzrëk jek u roy jong kjone ga eshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Eshko ga pjãy tjl̈ẽ u sogo kong ga “Tjl̈apga no pingga tjl̈ẽ ga ‘¿Israel tjëyoga döktong tek Egipto kjokyo dwayo dbaryo shrëkkl̈o l̈i, e dl̈iyo uër bor oppinggaga tjok l̈i kjëryo kjone?’ l̈e” l̈ëmi ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eni ga pjãy kong, kjër pĩya jong kjomo kjwara kësbang, poshäryak pjire. L̇l̇ëye uëy wl̈o l̈i shäryëmi pjir ber tjeng bäm go eshko» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eni ga ba oppinggaga do pjök l̈i to jek öötong l̈öng eshko ga l̇l̇ëye l̈ara Jesúsdë l̈i wl̈ẽna tjeng eshko uunkong eni. E irgo ga dbar shrëkkl̈o l̈i dl̈iyo poshäryara l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Öötong ba dl̈oyo go ga Jesús öötong shäng Sbö tjl̈õkwo roy l̈agaga ba ãska l̈i tjok, ga sirkeno l̈öng tjë jĩkong dl̈i iokl̈o jong l̈i zl̈ong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Eshko ga Jesús tjl̈ẽ ba kong ga «Tja wotjl̈ĩno ara ga tja shdũydëba l̇l̇ëm obishko ga dbar shrëkkl̈o ëre dl̈iyo uër bomi tjok l̈oror. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","L̈ër bomi kong ga uër ame, äär jong Sbö ber no pjl̈uyo dbaryoshko jã, dbar shrëkkl̈o ëre l̇l̇ë l̈okl̈o shäryono pjir ga eshko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Eshko ga di iokl̈o kjrara kjwara, roshko kjil̇l̇gwo bo dyo dbo ara, ga tjl̈ẽ Sbö kong ga «Tjawa kong kjil̇l̇gwo bo dyo tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga tjl̈ẽ ba oppinggaga kong ga «Kjrozĩ, shdözĩ ëng kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","L̈ër bomi kong ga kjil̇l̇gwo bo dyo iër ame, äär jong Sbö ber no pjl̈uyo dbaryoshko jã» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","E irgo ga pjl̈ung shosho suk pjir kjrara kjwara, ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga pjl̈ung shosho l̈i tora, twara sira sira ba oppinggaga kong, ga tjl̈ẽ ba kong l̈ok ga «Ëre bor sho wl̈eni, twak bomi kong. Shäryëmi jũni, bor woyoshrokl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ga uara l̈ok irgo ga shäryara eni obi, kjil̇l̇gwo bo dyo dbo ara tjok, tjl̈ẽ ga «Tjl̈õkwo twara Sbörë tjagl̈ën, beno ĩyado wl̈o. Shärye wl̈o ga bor srëng l̈i kwon bomi kjĩshko. Kjil̇l̇gwo bo dyo ëre, e ba jyãgl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Gueniyo bor soynega l̈i sök ië bor tjok jũshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","L̇l̇ëbo wen no to ter kjok dogo dwayo ëre kong owa, l̈ara Sbörë sorë l̈i eni. Gueniyo bor soynega, era song jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kuya l̈ok ga tjl̈ẽ ëng kong ga «¿Ë l̈ayde l̈ëba?» l̈e l̈ok ëng kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","E irgo ga opyono l̈ok ëngl̈ë kar kar, tjl̈ẽ l̈ok ga «¿Shji kjone dey tjwl̈õ ara, l̇l̇amo l̈i kjinmo?» l̈e l̈ok ëng kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kuya Jesúsdë ga tjl̈ẽ ba kong l̈ok ga «Miydëmi pjl̈ú ga kjok ëre kjing go ga nopga judío l̇l̇ëm wl̈eniyo ichagaga ba nopga ichë parkë ara ba kong. Ba nopga dbo ara wl̈eniyo opyë l̈ok ko no kjimtaga. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gueniyo woydër ga pjãy omshäryë eni l̇l̇ëme. Ëye opyë woydë ber tjwl̈õ ara obl̈ë kjinmo ga opyë ber tjwl̈õ l̇l̇ëm dey. Ëye opyë woydë ber obl̈ë ichaga ga ber shäng obl̈ë kjimtaga dey. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nopga tjeng do pjök ga kjl̈ara sök ië, kjl̈ara shäng dl̈i pjl̈orguë ba kong. ¿Kjone dey ga tjwl̈õ ara l̈ëba? Sök ië l̈i l̈ëba. Gueniyo tjara shäng bomi tjrëko, parkaga bomi kong wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","»Pjãy l̈öng bor tjok ĩyado. L̇l̇ëbo kës l̈i weno bor kong owashko ga tja rayoromi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","E kjĩshko ga l̇l̇ono ga pjãy iër ber l̈öng no pjl̈uyo, tja iara bor Datarë beno sök no pjl̈uyo sorë ga eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ga Sbö ber no pjl̈uyo l̈ishko ga pjãy äär ber l̈öng ië bor tjok eshko, ga pjãy sirkek äär l̈öng pjl̈u sökkl̈o kjing go, Israel tjëyoga kjringgwo sak kjwara kjingsho pjök (12) l̈i l̇l̇gwek wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Eshko ga tjl̈ẽ Pedro kong ga «¡Simón, tja kuzong! Shji dwl̈a pjl̈oyongshko ga ba pjl̈ungyo dbuk ber l̇l̇ëno ame. Pjãy tjl̈ĩya woydë Ärë eni, pjãy ber l̇l̇ëno ame eni bako wl̈o. Ga pja iara Sbörë beno shäng tjl̈ĩya eni wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gueniyo Simón, tja syõshtono Sbö kong bop kjĩshko, pja kjimte mär ber shäng bor go wl̈o, pja mär bor go jl̈õkoyo iröng obishko ga bop pjeyoga kjimtëp mär bor go eni bako wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kuya ga tjl̈ẽ ba kong ga «Tjl̈apga, tja sökoba no shdũzl̈ong uyo roshko bop tjok, l̇l̇ëm ga tja zrökoba jek bop tjok ëmdë ga tja shäng bop tjok, pja rayër l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kuya ga tjl̈ẽ ba kong ga «Pedro, l̈ër bop kong ga pjesit kjok shränto ga kjörkö kjl̈untë l̇l̇ëm obishko ga “Jesús, e ë miydër l̇l̇ëme” l̈orop oba kong pjl̈ogl̈o mya tjän» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","E irgo ga Jesús tjl̈ẽ ba kong l̈ok ga «Kjupä ga pjãy ichoror jek l̈öng dbur sho tjok l̇l̇ëm, kjl̈a tjok l̇l̇ëm, drepkwota tjok l̇l̇ëm bakoe. ¿Eshko ga l̇l̇ëye söromi l̇l̇ëm l̈i kjĩshko ga songyo kjroromire?» «L̇l̇ëme» l̈e l̈ok ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Eshko ga tjl̈ẽ ba kong l̈ok ga «Eni. Gueniyo eeri ga ëye dbur tjok ga söya. Ëye kjl̈a tjok ga söya bakoe. Ëye dröng l̇l̇ëm ga ba shwong kop l̈ëkong soyneya, dröng tjwl̈ẽkkl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sbö tjl̈õkwo tak pjang eni: “‘Domer kjwe l̇l̇ëbo owa shäryaga’ l̈araba ara.” E bor l̈ayde, ga wop ä ga shäryë bor kong eni kjl̈uwe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kuya l̈ok ga tjl̈ẽ ba kong ga «Tjl̈apga, jũshko dröng tjeng kjwang pjök» l̈e. Kuya ga tjl̈ẽ ba kong ga «Erö ga bue» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","E irgo ga Jesús opshino jek Olivos dl̈upyo ba oppinggaga tjok, sgara l̈öng sorë ga eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Öötong l̈öng eshko ga tjl̈ẽ ba kong l̈ok ga «Pjãy syõshtos Sbö kong ara, pjãy tjl̈ĩya Ärëshko ga pjãy kjimte Sbörë, l̇l̇ëbo owa shäryë l̇l̇ëm wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","E irgo ga opkjono jek ba zl̈ong bäng dwayo wop ak dburoy l̈onshko wl̈eni. Eshko ga kjök tono, syõshtono Sbö kong, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","tjl̈ẽ ga «Data, woydër ga l̇l̇ëbo wen owa bor kong dörö l̈i, e wen tjwe bor kong l̇l̇ëme. Woydëp eni wl̈eni ga shäryos eni. Gueniyo ga e l̈aga tjarë l̇l̇ëm, e l̈aga ber pjarë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Eshko ga Sbö parkaga kjok dogo so weno shäng kjl̈ara ba kong, kong dbo twe obi wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ga woydë ara l̇l̇ëbo wen tjwe ba kong owa l̈i kjĩshko ga syõshtono ara, shorya tjök tjök kl̈ung kjing go srëng dik. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Syõshtono pjir ga kojono, ga tek shrono shäng ba oppinggaga tjeng l̈ishko ga wl̈ẽya bë tjeng pë, woydë l̈ok ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ga tjl̈ẽ ba kong l̈ok ga «¿Pjãy pë egaro? Pjãy kojõzong. Pjãy syõshtos Sbö kong ara, pjãy tjl̈ĩya Ärëshko ga pjãy kjimte Sbörë, l̇l̇ëbo owa shäryë l̇l̇ëm wl̈o» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús tjl̈ẽydë pjitë l̇l̇ëm obishko ga nopga tjwe jong träk l̇l̇ëme. Ba oppinggaga dogl̈o sak kjwara kjingsho pjök (12) kjl̈ara ko Judas, e tek shäng ba bäm go. Eshko ga tek shrono shäng Jesús zl̈ong bäng, l̈õ shiya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Eshko ga Jesús tjl̈ẽ ba kong ga «Judas, ¿no to ter kjok dogo dwayo ëre l̈õ ship, iëp ber tjeng oba wl̈oshko wl̈ore?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tek l̈öng l̇l̇ëno miydara ba oppinggaga l̈öng l̈irëshko ga tjl̈ẽ l̈ok ba kong ga «Tjl̈apga, ¿shji ëngkjwë ba tjok dröng gore?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jekdo eshko ga kjl̈ara jũni dröng shino, ga syõshtaga kësbangyo l̈i parkaga kwomgwo kël̈ëkong zakza tas jer l̈on pjik buk töshko erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Eshko ga Jesús tjl̈ẽ ba oppingga l̈i kong ga «¡Wẽyẽ! ¡Kjweni l̇l̇ëme!» l̈e, ga parkaga l̈i kwomgwo porwara, ga poptonoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Eshko ga tjl̈ẽno ba kjragaga kong. Epga syõshtaga kägäyoga, Sbö u daga kägäyoga, judío tjl̈apgaga kjok l̇l̇gwega wl̈eniyo bakoe. Tjl̈ẽ ba kong l̈ok ga «¿Pjãy tjwe bor shak dröng tjok, wl̈ëng no shpokkl̈o tjok kjweni ega? ¿Tja shamishko ga tja ëngkjwë bomi tjok l̈ëmiro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tja öör shäng oba ping ara, Sbö u zl̈ong bäng, pjãy l̈öng l̈ishko. ¿Tja sharomi eshko l̇l̇ëm egaro? Gueniyo dbaryo koshoromi l̈i, e öötonge. Eni tjok ga kjok ichaga l̈i beno Ärë» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","55","Eshko ga Jesús shara l̈ok, söra to jongya syõshtaga kësbangyo l̈i ushko. Pedro jek shäng kä kjwaraso kä kjwaraso ba irgo. Öötong l̈öng eshko ga opzrëno jek u l̈i roshko, ga Pedro beno sök iökkok, u bongkjako, iök borkegaga l̈öng l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Eshko ga kjogl̈o shäng kjl̈ara, syõshtaga kësbangyo parkaga wl̈eniyo. Ĩna ga Pedro sök iökkok. Ga ĩya yõtso robyë wẽl̈ëshko ga tjl̈ẽ nopga l̈öng l̈i kong ga «Domer sök kjwe jëk shäng Jesús tjok bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kuya sök ga tjl̈ẽ kjogl̈o l̈i kong ga «¡Jyõ! ¡E ë miydër l̇l̇ëme!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wop tjok ga obl̈ë omĩno, ga tjl̈ẽ ba kong ga «Pja ëmdë ga ba kjl̈arayo» l̈e. Kuya ga tjl̈ẽ ba kong ga «¡Jyõ! ¡Tja l̇l̇ëme!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wop ara obi ga obl̈ë tjl̈ẽ ga «Domer kjwe Galilea so. E kjĩshko ga miydërwa pjl̈ú ga kjwe jëktong shäng ba tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kuya ga tjl̈ẽ ba kong ga «¡Jyõ! ¡L̇l̇ëye l̈ëp shäng l̈i miydër l̇l̇ëme!» l̈e. Pedro shäng tjl̈ẽ obishko ga kjörkö kjl̈unoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eshko ga Tjl̈apga Jesús bojono tek, Pedro ĩya drëng, ga woyoshre Pedrorë kjl̈ay ga Jesús tjl̈ẽno ba kong ga «Kjörkö kjl̈untë l̇l̇ëm obishko ga “Jesús, e ë miydër l̇l̇ëme” l̈orop oba kong pjl̈ogl̈o mya tjän» l̈ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Eni ga opshino ey dwayo, ga sl̈atong ara jl̈õkoyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","E irgo ga nopga l̈öng Jesús daga l̈i ba joywono, ga shpora l̈ok ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ga bokkwo go shwomzrëng kjrochara l̈ok tuke. Ga tjl̈ẽ l̈ok ba kong ga «Pja yoga ërë l̈os borwa kong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ga l̈ãywara l̈ok owa obl̈ë obl̈ë ara bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kjok shröngto ga Judío Kjok L̇l̇gwegaga Këskësyo töno l̈ok uunkong, syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go bakoe. Eshko ga Jesús söra l̈ok, jek öötong shäng tjl̈apgaga l̈i bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ga tjl̈ẽ l̈ok ba kong ga «¿No pjl̈uyo ichara Sbörë shrono shäng l̈i, e pjare? L̈os borwa kong» l̈e. Kuya ga tjl̈ẽ ba kong l̈ok ga «L̈oror bomi kong wl̈eni ga tjl̈õkwo kjrëmi l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ga pjãy kong l̇l̇ëbo kjakrokër kjwe ga tja dboryëmi l̇l̇ëm bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gueniyo Sbö, l̇l̇ëye shärye woydë l̈i shärye ga pjl̈úe. Ga eeri jek l̈ëkong ga no to ter kjok dogo dwayo ëre sirkeno öötong sök ba orkwo kël̈ëkong» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kuya l̈ok ga tjl̈ẽ ba kong ga «¿Eni ga pja Sbö Ware?» «L̈ëmi l̈öng pjãydë om go eni» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kuya l̈ok ga tjl̈ẽ ëng kong ga «L̈e shäng om go ba kjamo go. ¿Nopga wl̈ẽy ba rotë obi l̇l̇ëno?» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","E irgo ga l̈öng eshko l̈i kojono uunkong, ga Jesús söra l̈ok, jek öötong l̈öng Pilato bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Eshko ga rote l̈öng ara. Tjl̈ẽ ga «Domer kjwe wl̈ẽnorwa shäng oba shdök ara kjok kjwang jĩkong. Oba pĩya shäng kä potjwl̈ẽk pjl̈u kësbangyo sök Roma kjokyo l̈i kong l̇l̇ëme l̈e eni. Tjl̈ẽ obi ga “No pjl̈uyo ichara Sbörë shrono shäng l̈i, e tja” l̈e eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eni ga Pilato tjl̈ẽ ba kong ga «¿Judío pjl̈uyo l̈i pjare?» «L̈ëp sök om go l̈iro» l̈e ba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Eni ga Pilato tjl̈ẽ syõshtaga kägäyoga kong, nopga tjeng ara l̈i kong ga «Domer ëre bor kong ga l̇l̇ëye owa shäryara ber shdungko wl̈o drete» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gueniyo tjl̈ẽ l̈ok jek obi ga «Tjl̈õkwo l̈e shäng l̈i go ga oba shdöya ara Judea kjokyo kjok kjwang jĩkong. Soyara tek shäng Galilea kjokyo dwayo, era eni tjok ga shrono shäng jũshko bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kuya ga tjl̈ẽ ba kong ga «¿Domer ëre Galilea sore?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","«Ëng» l̈e l̈ok ba kong. Eni ga ichara Pilatorë jek Herodes shwoy, e Galilea so pjl̈uyo kjĩshko. Ey dbaryo ga Herodes sök Jerusalén kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Eni ga söra l̈ok, jek öötong shäng ba bokshto ga Herodes beno wopjl̈ú anmoyõ. Jesús, e l̈anyotkëba ara l̈i kura tek kjupäbäshko, ga ĩya woydë, l̇l̇ëbo ĩydëba l̇l̇ëm wl̈eniyo pĩya ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","E kjĩshko ga kong l̇l̇ëbo kjakrokara ara, gueniyo dboryara l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Syõshtaga kägäyoga, no pinggaga kjok l̇l̇gwekkl̈o tara Moisésdë l̈i go, e l̈öng eshko bakoe. Ga rotara l̈ok ara iir go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eshko ga joywara Herodesdë ara. Ba ëngkjwagaga omshäryono eni bakoe. Doyara l̈ok shwong tjwl̈õ ara go, pjl̈u shwongyo dik, joywe l̈ok wl̈o, ga ichara jek iröng obi Pilato shwoy. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ey dbaryo ga Herodes, Pilato, e opyono beno l̈öng wopjl̈ú ëng tjok. Bäm go ga l̈öng iirkë ëng tjok erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","E irgo ga nopga rokara Pilatorë uunkong tek ba shwoy, syõshtaga kägäyoga, no ichagaga, e tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Töna l̈öng pjir ga tjl̈ẽ ba kong ga «Domer ëre söromi shäng bor bokshto, oba shdöya ara kjĩshko l̈ëmi. E kjĩshko ga l̇l̇ëbo kjakrokoror ba kong ara bomi bokshto, gueniyo rotëmi l̈öng l̈i, e bor kong ga l̇l̇ëye drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes kong ga l̇l̇ëye dret bakoe. Ichara shrono shäng bi kong iröng obi e kjĩshko. Miydër pjl̈ú ga l̇l̇ëye owa shäryara ber zrökko wl̈o drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","E kjĩshko ga shdun. E irgo ga rayër toe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kuya l̈ok ga öö l̈e l̈ok uunkong, tjl̈ẽ Pilato kong ga «¡Domer kjwe zrözong! ¡Barrabás döpdë borwa kong dey!» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Domer l̈e l̈öng l̈i, e bängzak shäng no shdũzl̈ong uyo roshko. Dënashko ga ba pjl̈u, e woyde l̇l̇ëme. E kjĩshko ga ëng töno obl̈ë tjok kjl̈öbö, ga ëngkjwono l̈ok pjl̈u nopga tjok, ga nopga zröra l̈ok. E kjĩshko ga bängzak shäng eshko.) ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jesús döya woydë Pilatorë, ga tjl̈ẽno nopga l̈öng l̈i kong jek obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gueniyo öö l̈e l̈ok uunkong, tjl̈ẽ ba kong ga «¡Zrös pjang kjl̈ös go! ¡Zrös pjang kjl̈ös go!» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Eni ga Pilato tjl̈ẽno ba kong jek pjl̈ara obi, öötong pjl̈ogl̈o mya. Tjl̈ẽ ga «¿L̇l̇ë kjĩy? L̇l̇ëbo owa shäryara l̈i l̈ozĩ bor kong. L̇l̇ëye wl̈ẽnor ba go owa ber zrökko wl̈o drete. E kjĩshko ga shdun. E irgo ga rayër toe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Kuya ga öö l̈e l̈ok jek tjë jĩkong, Jesús iche zröya l̈ok pjang kjl̈ös go wl̈o. Eni ga nopga l̈öng l̈i wl̈ẽpyotke Pilatorë ga ä kuzong ga wotjl̈ĩno obl̈ë, l̇l̇ëye woyde l̈ok l̈i shäryara ba kong eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Eni ga domer bängzak shäng no shdũzl̈ong uyo roshko l̈ara l̈ok l̈i döra, ga Jesúsda twara ba ëngkjwagaga kong, l̇l̇ëye woydara nopgarë ba kong l̈i shärye l̈ok ba kong wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesús söya l̈ok jek zröya pjang kjl̈ös go wl̈o wopro ga domer tek shäng kjl̈ara ko Simón, e Cirene so. Tek shäng iröng ba kjokshko dwayo ga shara ëngkjwagaga jek l̈öng l̈irë, ga ichara l̈ok dbo go Jesús kjl̈ös l̈i sök ba irgo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Oba jëk l̈öng ara ba irgo, tjrëko wal̈ëga l̈öng ara, sl̈ar ara ba kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ĩya Jesúsdë bojono iröng, ga tjl̈ẽ ba kong ga «Wal̈ëga Jerusalén so, pjãy sl̈ar bor kjĩshko l̇l̇ëme. Pjãy sl̈ar bomi kjĩshko dey, bomi wapga kjĩshko bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","L̇l̇ono ga oba tjl̈ẽ ga “Wal̈ëga kjrong, wapga l̇l̇ëm wl̈eniyo, l̈öng wopjl̈ú l̈i epga” l̈ëba eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ey dbaryo ga nopga tjl̈ẽ dl̈up tjeng l̈i kong ga »“Pjãy l̈on ter borwa kjing go, tjawa jek jëktëng ber dret wl̈o” l̈e eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","¿Shäryëba eni kjor kësong kong ga l̇l̇ëye wen kjor dogro l̈i kong?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eshko ga domerga owa wl̈eniyo söra tjeng do pjök, zröya l̈ok Jesús tjok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ga öötong l̈öng kjokyo ko No Kä Dbogl̈o dl̈upyoshko ga Jesús l̈öra l̈ok pjang kjl̈ös go, domerga do pjök l̈i tjok, kjl̈ara pjang or kël̈ë, kjl̈ara pjang or mil̈ë, kjl̈ösyo dboy dboye. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eshko ga Jesús tjl̈ẽ ga «Data, l̇l̇ë shäryayde miyde l̈öng l̇l̇ëme. E kjĩshko ga l̇l̇ëbo owa shärye l̈öng ëre l̈ö̃s ba kong ber drete» l̈e. Eshko ga ëngkjwagaga tjeng l̈i tjöto l̈ok l̇l̇ëbo jyãgl̈o go, Jesús shwong l̈i ber ë kong ĩya l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nopga l̈öng ara eshko ba ĩk. No ichagaga l̈öng l̈i oml̈ãywono l̈ok owa ara, tjl̈ẽ ga «Oba obl̈ëra döra, eeri ga woyde ga opdök om go. Tjl̈ẽno ga no pjl̈uyo ichara Sbörë shrono shäng l̈i e l̈ara, e kjraga Sbörë om go l̈ara eni bakoe. L̈ara eni l̈i jl̈õ wl̈eni ga woyde ga opdök om go» l̈e l̈ok eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ëngkjwagaga l̈öng l̈i omjoywono l̈ok bakoe. Kjil̇l̇gwo bo dyo shpoä twara l̈ok ba kong ie wl̈o, joywe l̈ok wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ga tjl̈ẽ l̈ok ba kong ga «Pja judío pjl̈uyo jl̈õ wl̈eni ga pja opdös om go» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ga Jesús l̈ök pjangshko l̈i kopshko, kjibokwo iak pjang kjwara, e zröya l̈ok l̇l̇ë kjĩy miydëba wl̈o. Kjibokwo tak pjang l̈i tjl̈ẽ ga «Domer ëre, e judío pjl̈uyo.» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Domerga owa wl̈eniyo l̈ök l̈ok ba tjok kjl̈ara oml̈ãywono eni bakoe. Tjl̈ẽ ga «¿No pjl̈uyo ichara Sbörë shrono shäng l̈i, e pja l̇l̇ëmdo? Pja opdös om go, ga tjawa dös eni bakoe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gueniyo kuya ba kjl̈ara pjang l̈irë ga tjl̈ẽ ba kong ga «¿Pja Sbö bangkjrë l̇l̇ëmdo? ¿Pja shdungoba ba tjok bek l̇l̇ëmdo? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Shjira l̇l̇ëbo owa shäryono jl̈õkoyo, shji shdungoba wl̈o. Gueniyo domer kjwera, l̇l̇ëye owa shäryara l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eshko ga tjl̈ẽ Jesús kong ga «Pja äär ber sök no pjl̈uyoshko ga tja woyoshrëba» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kuya ga tjl̈ẽ ba kong ga «L̈ër bop kong jl̈õkoyo ga eeri dö ga pja ber sök bor tjok kjok ko Paraíso l̈ishko» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Öötong dl̈o dl̈uw bek ga kjok ro zoktong kjok kjwang jĩkong beno yẽt erä. Beno eni äär jong dl̈o pjö l̈ë wl̈eni. Eshko ga Sbö u roshko ga shwong kësbang iak pjang eshko l̈i dwl̈ëtong ter aas beno kjring pjök. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ga Jesús tjl̈ẽno dbo go, tjl̈ẽ ga «Data, bor sëya ëre iër ber tjeng bop wl̈oshko» l̈e, ga wol̈onoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","L̈ök pjang kjl̈ös go l̈i bokshto ga ëngkjwaga Roma so l̈i kägäyo shäng eshko kjl̈ara. L̇l̇ëbo weno l̈i ĩya ga Sbö poshrëra, ga tjl̈ẽ ga «Shinmo l̈ök pjang kjl̈ös go kjwe, e pjl̈o bek jl̈õe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ĩya nopga l̈öng eshko l̈irë ga to iröng ba ushko pjl̈ú kjing shpok, woydë ara kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gueniyo nopga Jesús miydë pjl̈ú wl̈eniyo l̈i beno tjeng l̇l̇ëbo tjeng kës ëre ĩk pjola sit, wal̈ëga tek tjeng Galilea kjokyo dwayo Jesús tjok l̈i tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Eshko ga domer shäng kjl̈ara ko José. E Arimatea so. E wotjl̈ĩk pjl̈ú, pjl̈o bek Sbö bokso. Sbö ber no pjl̈uyo dbaryo l̈i koshe sök bakoe. Domer l̈i Judío Kjok L̇l̇gwegaga Këskësyo kjl̈arayo, gueniyo l̇l̇ëye shäryara l̈ok Jesús kong l̈i woydara l̇l̇ëm, ba kong ga beno bëy l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jesús wol̈ono irgo ga domer l̈i jek öötong shäng Pilato shwoy, ga Jesús doyo rokara ba kong, jneya wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","E irgo ga jek öötong shäng shinmo l̈ök pjang kjl̈ös go l̈ishko. Eshko ga doyo l̈i l̈ona ter töshko, popgara shwong ko pjl̈ubl̈ún, pjl̈ú wl̈eniyo go, ga söra jek sakshko. Eshko ga iara beno buk pjl̈ëbgwo kak jong guëmkwota roshko. Eshko ga ëye iaydëba l̇l̇ëm obi. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dbar eshko ga poshäryozl̈ong dbaryo l̈i ey. Eshko ga woshtozl̈ong dbaryo l̈i dl̈oyo ääto, kjok sëng tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wal̈ëga tek tjeng Galilea kjokyo dwayo Jesús tjok l̈i jek l̈öng José irgo, ga shinmo doyo iara beno buk sakshko sorë l̈i, e ĩna l̈ok pjire. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","E irgo ga jek öötong l̈öng ushko, poshtikkl̈o l̇l̇ë l̈õ pjl̈ëbl̈ë wl̈eniyo, e shäryë, shinmo doyo poshtik e go wl̈o l̈ara. Gueniyo shäryayde pjitë l̇l̇ëm obishko ga woshtozl̈ong dbaryo l̈i öötonge. E kjĩshko ga woshtono l̈ok, tak pjang kjok l̇l̇gwekkl̈o tara Moisésdë go sorë l̈i eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Öötong sondë kjok shröngto ga jek l̈ok jongya sakshko, Jesús doyo iak buk l̈ishko. Poshtikkl̈o shäryara l̈i söya tjeng ba tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Öötong l̈öng eshko ga ak kësbang jong ba sak bängzakkl̈o l̈i wl̈ẽna l̈ok dik beno jong pjl̈ëbgwo l̈i sor go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eni ga opzrëno jek pjl̈ëbgwo l̈i roy, gueniyo shinmo doyo drete. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Woyotjl̈ĩya l̈öng obishko ga domerga weno tjeng do pjök, shwong kãl̈ã l̇l̇etl̇l̇et. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ĩya l̈ok ga beno l̈öng sëya l̇l̇ëm, ga kjök tono, kjujono bokdo kjl̈ay kl̈ung go. Eshko ga domerga l̈i tjl̈ẽ ba kong l̈ok ga «¿Shäng së l̈i wl̈ẽmi shinmo tjrëko l̇l̇ënoro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Buk na l̇l̇ëme. Woshrara Sbörë iröng obi. Zröydëba l̇l̇ëm obishko ga l̇l̇ëye l̈ara bomi kong Galilea kjokyo l̈i woyoshrozĩa. Tjl̈ẽno ga ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“No to ter kjok dogo dwayo ëre iëba ber tjeng nopga owa wl̈oshko guing, tja zröya l̈ok pjang kjl̈ös go wl̈o. Gueniyo äär dbargwo mya ga tja woshre Sbörë iröng obi” l̈ara bomi kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kuya l̈ok ga tjl̈õkwo l̈ara l̈i woyoshrarae. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Eni ga opshino l̈ok eshko dwayo, ga jek öötong l̈öng Jesús oppinggaga dogl̈o sak kjwara kjingsho kjl̈ara (11) l̈i l̈öngshko. Eshko ga l̇l̇ëbo ĩna, kura kës l̈i l̈ara l̈ok pjir ba kong, ba pjeyoga l̇l̇amo tjeng eshko ba tjok l̈i kong bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tjl̈õkwo roy sögaga l̈i, e María Magdala so, Juana, María Santiago mekë, wal̈ëga l̇l̇amo obl̈ë l̈i bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kuya Jesús oppinggaga l̈irë l̈ok ga tjl̈õkwo kjre l̈ok l̇l̇ëme. Wotjl̈ĩk l̈ok ga wal̈ëga l̈i skwẽ kjoyoe l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Eni ëmdë ga Pedro jek zron jong sakshko. Öötong shäng eshko ga opzrëno jek ba roshko, ga shwong shinmo pjrikkl̈o l̈i ĩna beno buk eshko eröe. E irgo ga to iröng ushko, l̇l̇ëbo weno shinmo kong l̈i woyotjl̈ĩya jek shäng. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","E irgo ga Jesús oppinggaga do pjök jek jëk l̈öng irbo jek jong äär Emaús kjokyo l̈i bäng. Emaús kjokyo ber buk pjola, shji opshik jek jëk Jerusalén kjokyo dwayo kjok shröngto ga shji äär kjok eshko dl̈o dl̈uw dik wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","Jëk l̈öng l̇l̇ëbo shäryono Jesús tjok l̈i l̈anyotkë ëng tjok. E wopro ga Jesús tek shrono shäng ba zl̈ong, ga jek jëk shäng ba tjok, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","gueniyo e ë miydara l̈ok jekdo l̇l̇ëm, woydara Sbörë eni l̇l̇ëm kjĩshko. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eshko ga Jesús tjl̈ẽ ba kong ga «¿Pjãy jek jëk l̈öng l̇l̇ë l̈anyotkë ëng tjok?» l̈e. Kuya l̈ok ga sl̈ongtëng l̈öng, woydë ara. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kjl̈ara ko Cleofas tjl̈ẽ ba kong ga «¿Kjakrokëp ega? L̇l̇ëbo shäryono Jerusalén kjokyo tjagl̈ën jã, e miydara nopga uunkongdë. U ĩga l̇l̇ë ëmdë ga ommiydono l̈ok pjire. ¿Eni ga pjara ommiydono l̇l̇ëm sorëro?» ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","«¿L̇l̇ëbo shäryono eshko l̈i l̇l̇ë?» l̈e. Kuya l̈ok ga tjl̈ẽ ba kong ga «Domer shäng kjl̈ara ko Jesús, e Nazaret so. E Sbö tjl̈õkwo l̈aga, l̇l̇ëye shärye l̈i, l̇l̇ëye l̈e l̈i, e dbo ara. Sbö kong ga tjwl̈õ ara, nopga kong ga eni bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gueniyo syõshtaga kägäyoga, bi tjl̈apgaga, e twara l̈ok oba kong, zrökoba wl̈o, ga zröraba pjang kjl̈ös go. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tjawara wotjl̈ĩno ga e shji Israel tjëyoga döga l̈ororwa. Gueniyo shäryono eni eeri ga öötong dbargwo mya tjän. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","»Eerishko kjok shröngto ga wal̈ëga jëk l̈öng borwa tjok kjong kjong jek öör l̈öng sakshko, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","gueniyo shinmo l̈i doyo wl̈ẽna l̇l̇ëme. Tek shrono l̈ok iröng obi ga tjl̈ẽ borwa kong ga “Sbö parkagaga kjok dogo so weno l̈öng borwa kong yoshko wl̈eni, ga tjl̈ẽ ga ‘Jesús, e woshrara Sbörë iröng obi’ l̈e l̈ok borwa kong eni” l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","E irgo ga borwa pjeyoga kjong kjong jek öör l̈öng sakshko bebi, ga l̇l̇ëbo wl̈ẽna l̈ok, l̈ara wal̈ëga l̈irë sorë l̈i eni. Gueniyo Jesúsda ĩna l̈ok l̇l̇ëme» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kuya ga tjl̈ẽ ba kong l̈ok ga «¡Pjãy kä kjange! ¿Pjãy opping l̇l̇onoro? ¿Tjl̈õkwo l̈ara Sbö tjl̈õkwo l̈agagarë l̈ok tek këgongshko kës l̈i, e kjrëmi l̇l̇onoro? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿No pjl̈uyo iche l̈e Sbörë l̈i, e shdungoba bäm go wl̈o, e irgo ga ie Sbörë ber tjwl̈õ ara l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","E irgo ga tjl̈õkwo tak pjang ba kjĩshko Sbö tjl̈õkwo go l̈i, e pjl̈ol̇l̇gwera ba kong pjire. Soyara Moisés kjibokwoyo l̈i go, äär pjë jong Sbö tjl̈õkwo l̈agaga tek dënashko so kjibokwoyo tjeng kës l̈i go bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ga jek l̈öng ääto kjok äär woydë l̈ishkoshko ga Jesús jek jëk shäng obi, äär jek këgong woydë wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Gueniyo mana l̈ok ber sök ba tjok. Tjl̈ẽ l̈ok ba kong dbo go ga «Pja jek këgong ame. Kjok sëng tjän, kjok ro zatoe. Pja ber sök borwa tjok kjok ëreshko dey» l̈e. Kuya ga opzrëno jek shäng ba tjok, ber sök ba tjok eshko wl̈oro l̈ara l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Eshko ga sirkeno sök ba tjok l̈ok, ië wl̈o, ga pjl̈ung shosho suk pjir kjrara kjwara, ga tjl̈ẽ Sbö kong ga «Tjawa kong dl̈i tworop ëre. Tjawa ber wopjl̈ú bop tjok e kjĩshko» l̈e. E irgo ga pjl̈ung shosho l̈i tora, twara sira sira ba kong l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jekdo eshko ga bokkwo roshwino wl̈eni, e ë miydara l̈ok pjir, gueniyo sök l̈i jek jëktëng erä. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eshko ga tjl̈ẽ l̈ok ëng kong ga «Shji tek jëk l̈öng ba tjok irbo bängshko ga Sbö tjl̈õkwo pjl̈ol̇l̇gwera bi kong. ¿Eshkoshko ga shji wopjl̈ú ara anmoyõ l̇l̇ëmdo?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jekdo eshko ga sano jek iröng Jerusalén kjokyo. Öötong l̈öng eshko ga Jesús oppinggaga dogl̈o sak kjwara kjingsho kjl̈ara (11) l̈i wl̈ẽna töno l̈öng eshko, nopga obl̈ë tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ga tjl̈ẽ l̈ok shrono l̈öng l̈i kong ga «Tjl̈apga Jesús woshrono iröng obi jl̈õe. E weno shäng Simón kong tjän» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kuya l̈ok ga l̇l̇ëbo weno ba kong irbo bäng l̈i, e l̈ara ba kong pjire. Pjl̈ung shosho suk pjir torashko ga e ë miydara l̈ok sorë l̈i, e l̈ara ba kong pjir bakoe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ga l̈anyotke l̈öng obi wopro ga Jesús weno shäng ba tjrëko, ga tjl̈ẽ ba kong l̈ok ga «Miga. Pjãy ber l̈öng wl̈ẽpe» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ĩya, kuya l̈ok ga beno l̈öng sëya l̇l̇ëm, bangkjre l̈ok ara. Wotjl̈ĩk l̈ok ga ba shingyo l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eni ga Jesús tjl̈ẽ ba kong obi ga «¿Pjãy sëya l̇l̇ëm ega? ¿Tja woshrono iröng obi woyotjl̈ĩmi l̇l̇ëm ega? ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","¡Tja l̈i shängdo! Bor orkwo ëre ĩzĩa. Bor dre ëre ĩzĩa. Tja porwozĩa. Bi shingyo, e sho dret, dbogl̈o dret, botoyara tjok» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","L̈ara eni ga ba orkwo bäng, ba dre bäng, e pina ba kong l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kuya, ĩya l̈ok ga tjl̈õkwo kjrayde l̈ok jl̈õkoyo l̇l̇ëm obi, gueniyo beno l̈öng wopjl̈ú anmoyõ, yëy l̈e l̈ok bakoe. Eshko ga tjl̈ẽ ba kong l̈ok ga «¿Pjãy jũshko l̇l̇ëbo uako tjokde?» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kuya l̈ok ga kong mã sho suk pjir wl̈eniyo twara ba kong bok kjwara, ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ga kjrara, uara ba bokshto. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Eshko ga tjl̈ẽ ba kong l̈ok ga «Tja shäng bomi tjok obishko ga tja tjl̈ẽno bomi kong ga “Tjl̈õkwo tak pjang bor kjĩshko Moisés kjibokwoyo l̈i go, Sbö tjl̈õkwo l̈agaga tek dënashko so kjibokwoyo tjeng kës l̈i go, kjibokwo ko Salmos go, e shäryë uunkong kjl̈uwe” l̈oror bomi kong eni» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Eshko ga epga kjimtara Sbö tjl̈õkwo tak pjang l̈i l̇l̇ë l̈okl̈o miydë pjl̈úe. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tjl̈ẽ ba kong ga «Tjl̈õkwo tak pjang l̈i tjl̈ẽ eni: “No pjl̈uyo iche l̈e Sbörë l̈i, e wol̈on wl̈o. Gueniyo äär dbargwo mya ga woshre Sbörë iröng obi.” ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tjl̈õkwo tak pjang obi tjl̈ẽ eni: “Ba ko goshko ga tjl̈õkwo l̈ëba tjëyo kjrina kjrina l̈öng kjok ëre kjing go l̈i kong. Tjl̈õkwo l̈ëba l̈i ëre: ‘L̇l̇ëbo shäryëy l̈öng owa l̈i, e owa jl̈õe l̈ëy, ga rayëy ga owa pjang bi go l̈i l̈ö̃ya Sbörë ber drete.’” ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pjãy beno l̈öng l̇l̇ëbo ĩnomi, kuromi l̈i roy l̈aga oba kong. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ga bomi go Sbö Sëya ichër kjok dogo dwayo äär ber kësbang bomi tjok, l̈ara bor Datarë jl̈õkoyo sorë l̈i eni. Gueniyo pjãy ber l̈öng ëreshko Jerusalén kjokyo, ëye l̈ër shäng bomi kong l̈i shrono guing» l̈e. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","E irgo ga epga söra jek Jerusalén kjokyo dwayo, öötong l̈öng Betania kjokyo. Eshko ga orkwo poyono, ga tjl̈õkwo l̈ara beno pjl̈ú ba kong l̈ok. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Shäng tjl̈ẽ obishko ga opkjono eshko dwayo, ga söra Sbörë to jem kjok dogo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","E irgo ga poshrëra l̈ok ara, ga sano to tek l̈öng wopjl̈ú iröng Jerusalén kjokyo. ");
INSERT INTO tfrNTpo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Eshko ga beno l̈öng Sbö poshrëk, ba u zl̈ong bäng enido.");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Shäng kjl̈ara ko Tjl̈õkwo. Kjok ëre dämär, l̇l̇ëye l̇l̇ëm obishko ga e sök tjän. E sök Sbö tjok, ga e Sbö. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","L̇l̇ëye l̇l̇ëm obishko ga e sök Sbö tjok. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ba go ga l̇l̇ëbo tjeng kës ëre shäryara Sbörë L̇l̇ëbo tjeng kës ĩy l̈öng ëre, e shäryara ba go. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","L̇l̇ëbo tjeng së kës ëre, e l̈aga erë. Shji uunkong ber l̈öng së tjagl̈ën wl̈eni, e l̈aga erë bakoe. Shji kong kjok miydë twaga l̈i e, e bi kong ga iök jong shjiy wl̈eni. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kjok ro sĩ l̈ishko ga iök l̈i jong shjiy ĩyado, e sjëya kjok ro sĩ l̈irë ga äe. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Eebor ga domer weno shäng kjl̈ara ko Juan, e ichaga Sbörë. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ichara Iök Shjiy l̈i roy l̈ë oba kong, nopga uunkong mär ber l̈öng ba go wl̈o. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan, e Iök Shjiy l̈i l̇l̇ëme. E shrono shäng Iök Shjiy l̈i roy l̈aga eröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iök Shjiy jl̈õkoyo l̈i, shji uunkong ber l̈öng kjok miydë ara l̈i l̈aga erë, ga eshko ga tjwe döröe. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Eshkoshko ga sök kjok ëre kjing go, ga kjok ëre shäryara kës ëmdë ga e ë miydaraba l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Öör shäng kjok baĩya l̈ishko, gueniyo wl̈okjrara ba tjëyogarë l̇l̇ëme. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gueniyo no kjong kjongda omwl̈okjrono, ga beno l̈öng mär ba go. Epga iara beno l̈öng Sbö wapga. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","E weno beno Sbö wapga, shji nopga wen kjok ëre kjing go dik l̇l̇ëme. E l̈aga domerdë l̇l̇ëm, e l̈aga Sbörë. ");
INSERT INTO tfrNTpo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ga Tjl̈õkwo l̈i, e weno beno no, ga beno sök shji nopga tjok. E Data Sbö Wa kjl̈araso, e Sbö bakoe. E kjĩshko ga e dbo ara, ga ba dbo kãl̈ã ĩnoy