﻿USE sofia;
DROP TABLE IF EXISTS sofia.tew_vpl;
CREATE TABLE tew_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tew_vpl WRITE;
INSERT INTO tew_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nä́ˀi-ân namuu iˀ híwóˀdi tun Jesus-ví̖ˀgeḏi, i-á namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, iˀbá Jôesi Táḏáví ay ûnmuu. ");
INSERT INTO tew_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hä́nˀoe Jôesi Táḏáví tukheˀbiˀ, Isaiah gin nakhá̖wä̖́ˀiˀ, itaˀnan háa Jôesi Táḏá iví ay itu̖ˀannin, ginnân: ");
INSERT INTO tew_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ótꞌôeyanbe, naví tꞌôepa̖ˀa̖a̖ˀiˀ uví páaḏé wînsankhâymáa. Iˀḏân u̖gîˀ in pꞌôe wônkhâyˀa̖mí. Oe ahkon deeḏi iˀ tꞌôepa̖ˀa̖a̖ˀi ûntu̖hkwíntú̖u̖ní, “In pꞌôe binkhâyˀan iˀ shánkí natsonjiˀigîˀ. Hä̖ˀi pꞌôeˀây-á wáˀ igîˀ bintaˀgeˀan.” ");
INSERT INTO tew_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John iˀ pꞌóˀpꞌoekandi-ân iˀ tꞌôepa̖ˀa̖a̖ˀi namuu. Oe ahkon deeḏi Jôesiví tun in tꞌowa ovâytꞌôekanhondi ovâytu̖máa, “Unbí tꞌaywóˀdi binjoeˀan, heḏânho Jôesi Táḏáḏí wovâyˀowóejé-íḏí, ihayḏânho naaḏi wâypꞌóˀpꞌoeˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Heḏi hânho báyékí tꞌowa Judea nangewin heḏá Jerusalem búˀwindá ee najiˀ iwepiye dimää, heḏi in toˀwên dívítꞌaywóˀdihä̖ä̖tsiˀannin in Jordan pꞌoˀkꞌay iwe ovâypꞌóˀpꞌoeˀan. ");
INSERT INTO tew_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John-bí aa kamä́yo phóḏí ûnpaˀan, heḏá napújebaˀáamuu, heḏi khowi̖ˀdá heḏá thaawä̖́ä̖ á̖pꞌo ishaaˀi-á ikꞌoe. ");
INSERT INTO tew_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Heḏi ginnân in tꞌowa ovâytu̖máa: “Wí toˀwí naví shánkí tsonan, heḏânho Jôesi Táḏáḏí wovâyˀowóejé-íḏí, ihayḏânho naaḏi wâypꞌóˀpꞌoeˀa̖míkhuu imáaˀi naví tíˀúugé napowagíˀo, heḏi naa ihay híwóˀdi wóˀmuupí dáytꞌä̖́ä̖-íḏí iví anto wänbo dônmaˀpꞌä̖̂ä̖ḏi-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naaḏá pꞌoeḏiḏa̖ˀ wâypꞌóˀpꞌoeˀoˀ, hewänbo iˀḏá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ wovâysankhâymáa wí pꞌóˀpꞌoekan waagibá.” ");
INSERT INTO tew_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ihayhä̖̂ä̖bá Jesus oe Nazareth búˀḏí napówá, Galilee nantaa búgeḏi, heḏi in Jordan pꞌoˀkꞌay iwe John-di óepꞌóˀpꞌoeˀan. ");
INSERT INTO tew_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Heḏi Jesus ee pꞌoe iweḏi natsꞌanpeeˀä̖ˀ ihayḏi, makówá nakhuuḏeemändi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ wí kꞌoˀwee waagibá nawândi imûˀ, heḏi ivîˀḏi isóge. ");
INSERT INTO tew_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Heḏi wí tun makówáḏí napeeḏi ginnân natú̖: “U̖-á naví ay wísígíˀi-ân unmuu. Hânho u̖ˀḏi ohíhchan.” ");
INSERT INTO tew_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ihayḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi Jesus ahkónupiye óehoˀ. ");
INSERT INTO tew_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jónä́ntä̖ (40) thaa iwe najiˀ, heḏi Satan iˀ Penísendi namuuˀiˀ ikhä̖ä̖ḏeˀ óehíwóhpíkannamíḏí. Ihayhä̖̂ä̖ḏi wíyá toˀwí i-áḏí wínaˀä́npí, in ahkónuwin animâa hä̖ä̖wênda̖ˀmân iwe dijiˀ, hewänbo in makówáwin tꞌôepa̖ˀa̖a̖ˀindiho óekhä̖geˀnan. ");
INSERT INTO tew_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","John iˀ pꞌóˀpꞌoekandiˀ oe Judea óepansóge, heḏi tíˀúugéḏí Jesus oe Galilee-piye namää, Jôesi Táḏáví híwóˀdi tun in tꞌowa ovâytꞌôekanhondi. Ovâytu̖máa, “Nää-ânho híwóˀ diwe naná, Jôesi Táḏá nakhâymuu wovâysígíhóeníḏí. Unbí tꞌaywóˀdi binjoeˀan, heḏá nä́ˀi Jôesi Táḏáví híwóˀdi tun bíwä̖́yú̖.” ");
INSERT INTO tew_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iwáy Galilee pꞌoekwí̖ kíngé Jesus naphaḏemän dihayḏi, Simon-dá iví tíˀûu Andrew-áḏí dä̂npaˀakanundeḏi ovä̂nmûˀ, indá paawóˀin damuuḏi. ");
INSERT INTO tew_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Heḏi ovä̂ntu̖ˀan, “Naa-áḏí bákä̖ˀve. Nää dä̂npaahóndeˀ, hewänbo naagîˀ dîntꞌowahóeníˀin wä̂nhá̖ˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wesebo inbí paˀakanuˀi dä̂njoeˀandi i-áḏí damää. ");
INSERT INTO tew_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wíyá hây namää ihayḏi, James-áḏí iví tíˀûu John-dáḏí ovä̂nmûˀ, indá Zebedee-ví ây damuu. Inbí paˀakanuˀi dä̂nkoḏiˀoˀ inbí kophé iwe. ");
INSERT INTO tew_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Heḏi ovä̂nmûˀḏi ovä̂ntu̖ˀan i-áḏí damú-íˀin, heḏi inbí táḏá Zebedee ee kophé iwe in tꞌôeˀindáḏí ovâyjoeˀandi i-áḏí damää. ");
INSERT INTO tew_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Capernaum búˀay dipówá, heḏi iˀ kaykhanwówá thaa nanáˀ dihayḏi Huḏíyoví méesateˀay ee Jesus natsꞌú̖, heḏi in tꞌowa ovâyhá̖ˀan. ");
INSERT INTO tew_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Háa Jesus-di ovâyhá̖ˀo waa ovâyháaˀan, gá in senäˀ in Huḏíyoví khuu dâyhá̖ˀoˀin dívíhéeˀan waagibá wíˀihéeˀanpíḏân, hewänbo iˀḏá ovâyhá̖ˀan taˀgendi itsonkhuumáa waagi. ");
INSERT INTO tew_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ihayḏibá wí sen iˀ méesate ee natsꞌú̖, i-á wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáa, heḏi itu̖wí̖nú, ");
INSERT INTO tew_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ánpí díˀan, u̖ˀ Jesus Nazareth búˀwiˀ. Ti unˀä̖ä̖ dítꞌahá̖a̖nú-íḏí gáhân? Naa dînhanginná toˀwí unmuuˀin. U̖-á iˀ tꞌä̖hkí yä̖ˀḏâaˀiˀ unmuu, iˀ Jôesi Táḏáḏí wóesandiˀ.” ");
INSERT INTO tew_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus-di iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ óetꞌeˀyandi óetu̖ˀan, “Hânda̖ˀdiboˀ, nä́ˀi senbíˀweḏi ópeeve.” ");
INSERT INTO tew_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Heḏi iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ itu̖wí̖núḏáháˀ iˀ sen óetha̖tha̖kannan ivíˀweḏi napeeˀä̖ḏi. ");
INSERT INTO tew_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tꞌä̖hkí in tꞌowa ovâyháaˀan, heḏi dívítu̖ˀan, “Hânnan namuu nä́ˀin? Wên tsꞌa̖a̖min há̖hkannân imáa, heḏá itsonkhuumáa waa iˀoˀ. In yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ wänbo ovâytsonmáa, heḏi indi óeˀaˀgindoˀ.” ");
INSERT INTO tew_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Heḏi oe Galilee nange i̖ˀge tꞌä̖hkí tꞌowa iví̖ˀgeḏi ditꞌoe. ");
INSERT INTO tew_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iˀ méesate iweḏi dipee, heḏi Jesus oe Simon-dá Andrew-áḏí inbí tewhá iwepiye namää. James-áḏí John-dáḏí wáˀ damää. ");
INSERT INTO tew_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Dipówá ihayḏi Jesus óetu̖ˀan Simon-bí jahkwíjo ûntsá̖wä̖pꞌíḏehayˀin. ");
INSERT INTO tew_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Heḏi iˀ kweeví whohte iwepiye namääḏi man diweḏi óeyâ̖ˀḏi óeshaa. Iˀ tsá̖wä̖pꞌíḏe wesebo ûnhán, heḏi ovâyhúujôn. ");
INSERT INTO tew_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nathantsꞌú̖ˀ dihayḏi iˀ kaykhanwówá thaa naphaḏe, heḏiho in tꞌowaḏi in dihayˀin tꞌä̖hkí heḏá in toˀwên yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi ovâymáaˀindá wáy Jesus naˀä́n diwepiye ovâyhújaˀ. ");
INSERT INTO tew_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","In búˀwnmáa, heḏi indi óeˀaˀgindoˀ.in tꞌowa tꞌä̖hkí ee tewhá phóḏi dívíwéˀgeˀan. ");
INSERT INTO tew_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Heḏi báyékí tꞌowa ovâyhehkháaˀan, tobá háawi inbí hay dínmuu wänboˀ, heḏá báyékí yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpiye. Hewänbo in pꞌoewa̖a̖hâ̖a̖ wíˀovâyhíˀmä́gipí, gá toˀwí namuuˀin dínhanginnândân. ");
INSERT INTO tew_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Waˀḏéeḏí Jesus ishaa, heḏi búˀḏí napeeḏi oe hânda̖ˀ nanáˀ diwepiye namää, heḏi iwe ijûusuˀan. ");
INSERT INTO tew_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon-dá in wéˀgen i-áḏí dijiˀindáḏí dimää óenuuwä̖́-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Heḏi óeshaa ihayḏi óetu̖ˀan, “Tꞌowa tꞌä̖hkíḏí wóetu̖wä̖máa.” ");
INSERT INTO tew_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iˀḏi ovâytu̖ˀan, “Jaho gimú-í oˀi wéˀgeˀi búˀ nä́we tsowa nanáˀ diwepiye, eeje wáˀ Jôesi Táḏáví tun dovâytꞌôeˀa̖míḏí. Hangîˀ-ânkun oˀä̖ä̖.” ");
INSERT INTO tew_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tꞌä̖hkí Galilee nange i̖ˀge Jesus namändi inbí méesate eeje Jôesi Táḏáví tun ovâytꞌôekanhon, heḏá in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpiyendeˀ. ");
INSERT INTO tew_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wí sen naphéetaymuuˀi Jesus-víˀpiye naˀä̖ä̖, heḏi idégeˀdisógeḏi pín taˀgeḏi nakhä̖geˀdaˀpóe. Óetu̖ˀan Jesus, “Dînhanginná u̖-á úkoḏiˀin nä́ˀi phéetay dînjâaˀa̖míḏí, undaˀḏi.” ");
INSERT INTO tew_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus ivíˀpiye hânho nasehkanäpóe, heḏi ikhóhtä̖ä̖ḏi iví mandi óetä̖ge, heḏi óetu̖ˀan, “Naa odaˀákun wînhehkháaˀa̖míˀin. Unhehkháapúuwí.” ");
INSERT INTO tew_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wesebo iˀ phéetay ûnhándí nahehkháapóe. ");
INSERT INTO tew_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Heḏi Jesus-di óepunjôn, hewänbo páaḏé kaygindi óetu̖ˀan, “Óetꞌôeyan, toˀwí wänbo nä́ˀi úpóe i̖ˀgeḏi wínâatꞌôeˀa̖mípí. Moses itaˀnan Jôesi Táḏáví taˀnin diwe, únkhâyˀä̖ˀ wí hä̖ä̖wí iˀ owhaˀvíˀpiye bînhûuwíˀin Jôesi Táḏá óemä̂äníḏí, in tꞌowa ovâyhanginˀânnamíḏí íhehkháapóeˀin. Nää ópûn, haˀwâa óˀan.” ");
INSERT INTO tew_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hewänbo iˀ sen iweḏi namääḏi báyékí ihéeˀan niˀgeḏi, heḏá háa ûnpóeˀindá tꞌä̖mäpiye in tꞌowa ovâytꞌôeˀan. Háa iˀ sen iˀannin namuuḏi Jesus wíˀûnkoḏipí keeˀeeḏi iˀ búˀ natsꞌú̖u̖níḏí, heḏiho búˀḏí jáˀwébo wáy tóebo nathaapí iwe iwóyí̖ˀ. Hewänbo ee naˀä́n diwe in tꞌowa tꞌä̖mäpha̖ˀgeḏi dipóyaˀ. ");
INSERT INTO tew_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wí hä̖́yú̖ thaa naphaḏe ihayḏi Jesus wíyá oe Capernaum-piye namää, heḏi ivîˀ naˀä́nnin in tꞌowa dínhanginpóe. ");
INSERT INTO tew_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Báyékí tꞌowa iwe diwéˀgepóe, heḏiho wínajâanáhpí phóḏi núˀ wänbo joe, heḏi Jôesi Táḏáví tun ovâytꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wây-á tꞌowa diˀä̖ä̖, heḏi in diweḏi jónu senäˀdi wí sen ûnˀa̖ˀyä̖kankoḏipîˀ whohpa̖ˀ kꞌéwéḏí óekán. ");
INSERT INTO tew_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hewänbo ditꞌowabáˀyendi wíḏínkoḏipí Jesus-ví núˀ óekáaníḏí, heḏiho whaˀkꞌaypiye dipeeḏi Jesus nawin dee taˀge dâyphohkíḏi, heḏi whohpa̖ˀ wóegé iˀ sen ûnˀa̖ˀyä̖kankoḏipîˀ oe áagépiye óewaje. ");
INSERT INTO tew_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dâywä̖yu̖máaˀin Jesus-di ovâymûˀ ihayḏi iˀ nahayˀiˀ óetu̖ˀan, “Naví ay, uví tꞌaywóˀdi úˀowóˀjen.” ");
INSERT INTO tew_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hewänbo wên Huḏíyoví khuu dâyhá̖ˀoˀin iwe dikwꞌóˀnin ginnân dívíˀánshaamáa: ");
INSERT INTO tew_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Háaḏan nä́ˀi sen gin ihíˀmáa? Jôesi Táḏáḏa̖ˀmân ûnkꞌóe tꞌaywóˀdi iˀowóejé-íḏí, heḏiho gin nä́ˀi sen ihíˀmáaḏí Jôesi Táḏá óeˀaˀginhá̖núndeˀ.” ");
INSERT INTO tew_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wesebo Jesus wíˀbo ûnhanginpóe háa kaaḏibo dívíˀánshaamáaˀin, heḏi ovâytu̖ˀan, “Heḏi háaḏan haˀwâa úvíˀánshaamáa? ");
INSERT INTO tew_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nä́ˀi sen ûnˀa̖ˀyä̖kankoḏipîˀ dótu̖ˀandá, ‘Uví tꞌaywóˀdi úˀowóˀjen,’ háa dótu̖ˀandá, ‘Uví whohpa̖ˀay mänkeˀḏi ójíyé,’ wéˀi-an shánkí wínabâapuˀwanpí heḏânho bînmúuníḏí háa taˀgendi dînkoḏiˀin háa joe? ");
INSERT INTO tew_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nää hä̖ä̖wí dókhâymáa wâykeeya̖míḏí naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀi dînkꞌóeˀin nä́ä oepáa kꞌayḏi tꞌaywóˀdi dovâyˀowóejé-íḏí wáˀ.” Heḏáháˀ iˀ sen ûnˀa̖ˀyä̖kankoḏipîˀ óetu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Wítu̖máa, ówí̖nú, uví whohpa̖ˀay mänkeˀḏi uvíˀpiye unmú-í.” ");
INSERT INTO tew_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Heḏi iˀ sen wesebo iwí̖nú, heḏi iví whohpa̖ˀ ikêˀḏi napee. Tꞌä̖hkíḏíbo óemûˀḏi ovâyháaˀandi ditú̖, “Wên hä̖ä̖wên giˀmin wáymûu wänbo wíˀâymûˀpí,” heḏi Jôesi Táḏá kwꞌáayébo óemáa. ");
INSERT INTO tew_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus iˀ búˀḏí napeeḏi oe pꞌoekwí̖ kíngépiye wíyá namää. Báyékí tꞌowa ivíˀpiye dimää, heḏi ovâyhá̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Heḏi Capernaum-piye nawáymän dihayḏi wí sen Levi gin nakhá̖wä̖́ˀiˀ óemûˀ iˀ phahsan chä̖ˀ dâywéˀgeˀoˀi tewháˀay ee naˀä́ndí, i-á Alpheus-ví ay ûnmuu, heḏá tax phahsandi-ân namuu. Jesus-di Levi óetu̖ˀan, “Naa-áḏí ókä̖ˀve,” heḏi iwí̖núḏí Jesus-áḏí namää. ");
INSERT INTO tew_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Báyékí wây-á tax phahsannin heḏá wây-á tꞌowa-á Jesus-áḏí dijiˀ, nä́ˀin wéˀgen tꞌowa in Pharisees-di ovâytu̖máa tꞌôeyanpíˀin gin. Wí thaa Levi-ví tewhá ee nä́ˀin tꞌowa Jesus-áḏí iví khä̖geˀnindáḏí dívíhúujoˀ. ");
INSERT INTO tew_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Heḏi wên Huḏíyoví khuu dâyhá̖ˀoˀin senäˀ, indá Pharisee tꞌowa iweḏiˀin dimuuˀindi Jesus óemûˀ nä́ˀin giˀmin tꞌowa-áḏí ihúujoḏi. Heḏi Jesus-ví khä̖geˀnin ovâytsikaˀyan, “Háaḏan nä́ˀin tax phahsannindáḏí heḏá nä́ˀin tꞌôeyanpíˀindáḏí ihúujoˀ?” ");
INSERT INTO tew_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus natꞌoeḏi ovâytu̖ˀan, “In dihayˀinda̖ˀmân wí woekandi díntáy, in dihaypíˀindá joe. Naa oˀä̖ä̖ in toˀwên tꞌaywóhkannin dimuuˀin dínhanginnáˀnin dovâytu̖ˀâ̖a̖míḏí inbí tꞌaywóˀdi dâyjoeˀa̖míḏí, in toˀwên inbí wówátsi taˀge dâyhon gin diˀándeˀindá joe.” ");
INSERT INTO tew_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ihayhä̖̂ä̖bá John iˀ pꞌóˀpꞌoekandiví khä̖geˀnindáḏí in Pharisee tꞌowaví khä̖geˀnindáḏí dívíha̖a̖ḏä́ˀoˀ, heḏi wên tꞌowa Jesus ûnpówáˀindi óetsikaˀyan, “Háaḏan John-bí khä̖geˀnindáḏí in Pharisees-víˀindáḏí dívíha̖a̖ḏä́ˀoˀ, uvîndá joe?” ");
INSERT INTO tew_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus-di ovâytu̖ˀan, “Dínkhóhtsa̖a̖shánkíˀeeḏináˀ dihayḏi, ti iˀ soyingiví kꞌemaˀin dívíha̖a̖ḏä́ˀo waˀḏi indáḏí najiḏiboˀ? Joe, háˀto haˀwâa dívíˀa̖mí waˀḏi indáḏí dínˀä́ndí. ");
INSERT INTO tew_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hewänbo owáy hä̖̂ä̖ḏi iˀ soyingi inbíˀweḏi óekhuwakhâymáa, ihayḏânho dívíha̖a̖ḏä́khâymáa.” ");
INSERT INTO tew_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Toˀwí wänbo wên to khannin deeḏi wên aaˀay tsꞌa̖a̖min wíˀitꞌiˀkꞌúyaˀpí. Haˀwâagi iˀandá, dâyˀowíḏiḏi in aaˀay natꞌiˀkꞌóeˀin natsꞌú̖u̖ní, heḏá shánkí wänbo-á in to-á nasiveḏee-í. ");
INSERT INTO tew_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Heḏi toˀwí wänbo wí úuva pꞌoe tsꞌa̖a̖bi wíˀikuuḏepí wí kꞌúwá khowa pꞌoemúu khandi eeje. Haˀwâagi iˀandá, iˀ úuva pꞌoe nakaypóeḏí nasôeḏi iˀ pꞌoemúu napání, heḏá iˀ méena-á nachaˀḏee-í. Úuva pꞌoe tsꞌa̖a̖bi-á pꞌoemúu tsꞌa̖a̖bi eejân ûnkuukhâyˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wí thaa, kaykhanwówá thaa nanáˀdiˀ, wí táhtân nava i̖ˀge Jesus-áḏí iví khä̖geˀnindáḏí dimän, heḏi in khä̖geˀnin dâytákꞌéthehondi dâykoehon. ");
INSERT INTO tew_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Heḏi in Pharisee tꞌowaḏi Jesus óetu̖ˀan, “Háaḏan uví khä̖geˀnin haˀwâa dívíˀoˀ? Háa dívíˀoˀin kaykhanwówá thaa nanáˀ diwe nakhâ̖a̖kꞌóe.” ");
INSERT INTO tew_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jesus-di ovâytu̖ˀan, “Hewänbo bîntunnanpíˀan háa David hä́nˀoe iˀannin, Abiathar naˀowhaˀpꞌóˀḏéḏîˀä́n dihayḏi. David-dá heḏá in senäˀ i-áḏí dijiˀindáḏí diha̖hsêndi wí hä̖ä̖wí dâykꞌoˀíˀin wíḏâymáapí, heḏiho Jôesi Táḏáví tewhá ee ditsꞌú̖, heḏi iˀ pává ee nasaaˀi David ihógiḏi ikꞌoe, heḏá in senäˀ i-áḏí dijiˀindá wáˀ ovâymä́gi, tobá iˀ pává Jôesi Táḏágîˀ ûnwijesaa wänboˀ, heḏiho in owhaˀḏa̖ˀmân dínkꞌóe dâykꞌoˀíḏí. ");
INSERT INTO tew_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jôesi Táḏáḏí tꞌowa ovâykhíjé iˀ kaykhanwówá thaa dâywänpiˀaˀgeeníḏá joe, hewänbo iˀ kaykhanwówá thaa-á tꞌowa ovâymä́gi ovâykhä̖geˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Heḏiho naa, tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi dînkꞌóe otú̖u̖níḏí háa tꞌowa kaykhanwówá thaa iwe wänbo dínkoḏiˀin dívíˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus iˀ Huḏíyoví méesateˀay ee wíyá natsꞌú̖, heḏi wí sen wáyhángéḏí namantꞌaamuuˀiˀ iwe naˀä́n. ");
INSERT INTO tew_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Heḏi in tꞌowaḏi Jesus á̖yîngiḏi óemúndeˀ, tigúba kaykhanwówá thaa iˀ sen ônhehkháaˀa̖mí, heḏi ônhehkháaˀandá ôntꞌeˀpꞌêeḏe-í. ");
INSERT INTO tew_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus-di iˀ sen namantꞌaamuuˀiˀ óetu̖ˀan, “Nä́ˀin tꞌowaví páaḏépiye ówí̖nú.” ");
INSERT INTO tew_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Heḏáháˀ Jesus-di ovâytsikaˀyan, “Kaykhanwówá thaa wéˀi-an gínkꞌóe ívíˀa̖míḏí: Ti wí toˀwí âykhä̖geˀnamí háa âywa̖ˀa̖mí? Ti gínkhâyˀä̖ˀ wí toˀwí iví wówátsi âyˀaywoeníˀin háa âyháyjíˀin?” Indá háabo wíḏitú̖hpí. ");
INSERT INTO tew_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Heḏi Jesus ibéeḏí tyîngiḏi óemúndeˀ, tigúba kꞌaygi ovâymúndeˀ, gá wíḏisígítaachanpoeˀopíḏân, heḏi wíḏisehkanäpóepíḏí óewa̖ˀan. Heḏáháˀ iˀ sen óetu̖ˀan, “Ókhóhtä̖ä̖.” Heḏi ikhóhtä̖ä̖ḏi iví man ûnwówaḏi páaḏéḏí ûnmuu waagibá ûnpóe. ");
INSERT INTO tew_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","In Pharisee tꞌowa dipee, heḏi wesebo Herod-ví kꞌemaˀin ovâyhéeˀan wên híˀ dâykꞌúuwíḏí háḏíḏí Jesus óeháyjíˀin. ");
INSERT INTO tew_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus-áḏí iví khä̖geˀnindáḏí iweḏi dívíjâaˀan, heḏi oe pꞌoekwíngépiye dimääḏi báyékí tꞌowa dínwóemää. Nä́ˀin tꞌowa diˀä̖ä̖ oe Galilee nangeḏi, Judea nangeḏá, ");
INSERT INTO tew_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem búˀḏá, Idumea nangeḏá, Jordan pꞌoˀ pꞌä̖́näḏá, heḏá Tyre búˀ Sidon búˀ tsowaḏá. Nä́ˀin tꞌowa-á háa iˀoˀ i̖ˀgeḏi ditꞌoeḏi ivíˀpiye dimää. ");
INSERT INTO tew_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Heḏi Jesus iví khä̖geˀnin itu̖ˀan wí kophé ûnkhâychaníˀin, in báyékí tꞌowaḏi wíˀóetꞌä̖́ä̖máˀve-ípíḏí. ");
INSERT INTO tew_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Báyékího ovâyhehkháaˀan, heḏiho nää-á tꞌä̖hkí in dihayˀin ivíˀpiye dívítꞌä̖́ˀtꞌä̖́ˀmáa óetä̖ä̖gé-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Heḏi in tꞌowa in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi ovâymáaˀindi óemûˀḏi iví páaḏépiye dívídégeˀdikwꞌóḏi, heḏi dívítu̖wí̖nú, “U̖-á Jôesi Táḏáví ay-ân unmuu.” ");
INSERT INTO tew_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hewänbo kayˀindi in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ ovâykhâ̖a̖kꞌûˀ wíḏitú̖ˀbe-ípíḏí toˀwí namuuˀin. ");
INSERT INTO tew_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus okú iˀpiye namää, heḏi in toˀwên nadaˀin ovâytu̖hkánnan, heḏi ee najiˀ iwepiye dimää. ");
INSERT INTO tew_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","In diweḏi tä̖ˀḏi wíje senäˀ ovâydeˀman i-áḏí dimú-íḏí, heḏá ovâypunjôeníḏí iví tun in tꞌowa ovâytunphaaḏé-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Heḏá inbá ovâykꞌûˀ in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpeeyé-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ginnân in senäˀ dikhá̖wä̖́: Simon (i-á Jesus-di Peter gin wáˀ óekhá̖wä̖́mä́gi), James-á John-dá (nä́ˀindá Zebedee-ví ây ûnmuu, hewänbo Jesus-di ovä̂nkhá̖yä̖́ˀ Boanerges gin, heḏi nä́ˀin khá̖wä̖́ Boanerges-á Greek-ví tundi “Kwa̖hta̖a̖” gân namuu), Andrew-á, Philip-á, Bartholomew-á, Matthew-á, Thomas-á, James-á (i-á Alpheus-ví ay ûnmuu), Thaddeus-á, Simon-dá (i-á in Zealot tꞌowa iweḏiˀi namuuwän), heḏá Judas Iscariot-dá (i-á Jesus óeku̖hpekhâymáaˀi-á namuu). ");
INSERT INTO tew_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesus wí tewhá ee natsꞌú̖, heḏi báyékí tꞌowa wíyá diwéˀgepóeḏí Jesus-á iví khä̖geˀnindá húu wänbo wíˀovâymähpí. ");
INSERT INTO tew_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Heḏi iví maatuˀin háa ûnpoeˀoˀin dínhanginpóeḏí ûnkenmää. “Háḏée iví hangintan wíˀimáapí” gin ditû̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wên Huḏíyoví khuu dâyhá̖ˀoˀin oe Jerusalem búˀḏí diˀä̖ä̖ˀin wáˀ ditû̖ˀ, “Jesus-á Penísendiḏi óemáa. In yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ví pꞌóˀḏéḏîˀ dínmuuˀiˀ, Beelzebul gin nakhá̖wä̖́ˀiˀḏân óekhä̖geˀmáa in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpeeyé-íḏí.” ");
INSERT INTO tew_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Heḏi Jesus-di in tꞌowa ivíˀwe ovâywéˀgeˀandi nä́ˀi híˀ wên óˀgéḏíˀay waagiˀbá namuuˀiˀ ovâytu̖ˀan ovâyhá̖ˀa̖míḏí: “Háḏíḏan Satan iˀ Penísendi namuuˀiˀ ûnkoḏi wíˀbo ipikhehpeeyé-íḏí? ");
INSERT INTO tew_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ti wíˀúnhanginnáhpíˀan wí nangewin tꞌowa wíˀbo dívípihä́nboḏá, háˀto inbí nange dínkâypúuwí. ");
INSERT INTO tew_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Heḏi tꞌowa inbí kꞌaygi ee wíˀbo dívípiyándeḏáhoˀ, háˀto híwó inbí kꞌaygi dínpúuwí. ");
INSERT INTO tew_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Heḏi hanbá Satan iví khä̖geˀnindáḏí iyándeḏá, háˀto nakâypúuwí, hewänbo iwebo iví kay ûnhá̖a̖ní. ");
INSERT INTO tew_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Toˀwí wänbo wíˀûnkoḏipí wí sen nakayˀiví tewhá ee natsꞌú̖u̖níḏí iví hä̖ä̖wí ônsänhóeníḏí, páaḏé iˀ sen nakayˀiˀ óewhisógepíḏíboˀ. Óewhisógeḏiḏa̖ˀmânho ônsänhóení iví hä̖ä̖wí. ");
INSERT INTO tew_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Taˀgendi wâytu̖máa, nakoḏi ovâyˀowóejé-íḏí tꞌowaví tꞌaywóˀdi tꞌä̖hkí heḏá tꞌä̖hká inbí híˀḏí Jôesi Táḏá óeˀaˀginhá̖núndeˀi-á. ");
INSERT INTO tew_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Hewänbo toˀwí iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ví̖ˀgeḏi aˀginkha̖nuḏi ihíˀmáaḏá, Jôesi Táḏáḏí háˀto hä̂nhay wänbo ônˀowóejé-í. Wên tꞌaywóˀnin iˀo háˀto hä̂nhay wänbo naˀowójéḏee-íˀin.” ");
INSERT INTO tew_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Haˀwâagi Jesus ihéeˀan gá in Huḏíyoví khuu dâyhá̖ˀoˀin ditú̖ḏân, “I-á wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáa.” ");
INSERT INTO tew_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ihayhä̖̂ä̖bá Jesus-ví jíyá-á iví tíˀûuwindá iˀ tewhá wáy naˀä́n diwe dipówá, heḏi jáˀwé dívítsíkhawindi wí toˀwí Jesus ûntu̖hkántsꞌú̖. ");
INSERT INTO tew_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Báyékí tꞌowa ee naˀä́n dee dikwꞌôn, heḏi óetu̖ˀan, “Uví jíyá-áḏí uví tíˀûuwindáḏí oe jáˀwé dijiˀ heḏi wóetu̖wä̖máa.” ");
INSERT INTO tew_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus-di ovâytu̖ˀan, “Wây-á tꞌowa dijiˀ jíyá-á tíˀûuwindá waaginbá dimuuˀin naagîˀ.” ");
INSERT INTO tew_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Heḏi in tꞌowa dibûukwꞌóˀnin ovâybéepu̖wä̖máaḏí natú̖, “Nä́ˀin wáˀ naví jíyá-á naví tíˀûuwindá dînmuu. ");
INSERT INTO tew_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Toˀwên háa Jôesi Táḏá nadaˀ waa dívíˀoˀinnânho naví tíˀûuwindá naví jíyá-á dînmuu.” ");
INSERT INTO tew_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus-di in tꞌowa oe pꞌoekwí̖ kíngé wíyá ovâyhá̖ˀoˀ, heḏi ee najiˀ iwe báyékí tꞌowa dívíwéˀgeˀandi wí kophé naˀä́n diwe itógiḏi isóge, heḏi tꞌä̖hkí in tꞌowa ee nange pꞌoekwí̖ kíngé dívíwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iwe ovâyˀóˀgéḏíˀan báyékí hä̖ä̖wí ovâyhá̖ˀa̖míḏí. Wên óˀgéḏí ovâytu̖ˀannin ginnân namuu: ");
INSERT INTO tew_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Bítꞌôeyan. Wí koˀjikwoˀi namää iví koˀji wóegé, heḏi ee nava i̖ˀge ikoˀjiwáḏe. ");
INSERT INTO tew_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wáy wí koˀji in pꞌôeˀay nava pínu nakꞌóe i̖ˀge najemu, heḏi in tsíḏé dipówáḏí tꞌä̖hkí dâykꞌoe. ");
INSERT INTO tew_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wíyá koˀji-á nakꞌuunáˀ deeḏá najemu, báyékí wínanankwꞌóhpí iwe, heḏi wä̖hphaḏe wínanankꞌaanáhpíḏí iˀ nan nasúwáḏí wesebo natsijópúpóe. ");
INSERT INTO tew_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hewänbo iˀ than napee ihayḏi, tꞌä̖hkí natꞌaaḏi óephahá̖nú, ihay wínapúutsiyeḏipíḏí. ");
INSERT INTO tew_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wíyá koˀji-á wä̖́ä̖ˀi phéˀyä̖́vi jâa-á najemu, heḏi iˀ phéˀyä̖́vi nasôeḏi iˀ koˀji óeˀánhógiḏi hä̖́ä̖bo wínapaapí. ");
INSERT INTO tew_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hewänbo wíyá koˀji-á híwóˀdi nan diwá najemu, heḏi napeeḏi nasôe, heḏi wáy wí koˀji iweḏi powintä̖ maˀkwꞌanukí shánkí napaa, wíyá iweḏi sígíntä̖-á, heḏá wíyá iweḏá tä̖gintä̖-á. ");
INSERT INTO tew_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Toˀwên naví híˀ ditꞌoeˀindá híwó dívítꞌôeyaaníˀin dínkhâyˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesus wíˀbo najiˀ ihayḏi, iví tä̖ˀḏi wíje khä̖geˀnindá heḏá in wéˀgen i-áḏí dijiˀindá oetsikaˀyan hânnan nä́ˀin óˀgéḏí natundaˀin. ");
INSERT INTO tew_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ovâythayyandi natú̖, “Jôesi Táḏáḏí wovâymä́gi íkaˀpóewíḏí háḏíḏí iˀḏi nää tꞌowa ovâysígíhóndeˀ i̖ˀgeḏi, hewänbo in wéˀgen tꞌowa dikaˀpowadaˀpíˀindáho dovâyhá̖ˀoḏi óˀgéḏíḏa̖ˀ dovâytu̖máa heḏânho wíḏikaˀpóewípíḏí. ");
INSERT INTO tew_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jôesi Táḏáví taˀnin diwe ginnân inbí̖ˀgeḏi nataˀmuu: Tobáháa hä̖̂ä̖ḏi wänbo tꞌä̖hkí dâymúnde wänbo wíḏínkeepoeˀopí, heḏá hä̖̂ä̖ḏi wänbo tꞌä̖hkí ditꞌoeˀo hewänbo wíḏikaˀpóyaˀpí. Dínkeepoeˀoḏá heḏá dikaˀpóyaˀdá Jôesi Táḏávíˀpiye dívíbée-í heḏi iˀḏi ovâyˀowóejé-í.” ");
INSERT INTO tew_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Heḏi Jesus-di ovâytsikaˀyan, “Ti nä́ˀin há̖hkangíˀin óˀgéḏí iˀ koˀji i̖ˀgeḏi wíˀíkaˀpóyaˀpíˀan? Háḏíḏan iˀ wéˀgeˀi há̖hkangîˀ óˀgéḏí wâytu̖máaˀiˀ íkaˀpóewí? ");
INSERT INTO tew_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nä́ˀi koˀji iˀ sen ikoeˀi Jôesi Táḏáví tun waagiˀbá namuu. ");
INSERT INTO tew_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wí koˀji in pꞌôeˀay i̖ˀgepiye najemu nanankâymuu eeḏi, heḏi wên tꞌowa nä́ˀi nan waaginbá dimuu. Nä́ˀi Jôesi Táḏáví tun ditꞌoeḏi wesebo i Penísendi Satan naˀä̖ä̖ḏi inbíˀweḏi ovâyhóndeˀ. ");
INSERT INTO tew_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wíyá koˀji-á nakꞌuunáˀ deeḏá najemu, heḏi wây-á wên tꞌowa-á nä́ˀi wä̖hphaḏe kꞌaapîˀ nan waaginbá dimuu. Jôesi Táḏáví tun ditꞌoeḏi wesebo híhchandi dâysígíˀoˀ. ");
INSERT INTO tew_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hewänbo wíḏipúumuupí waaginbá dimuu. Pín taˀgeḏi wíḏívíwä̖yundepíḏí hây tä̖hkíḏa̖ˀ diyä̖́ä̖poeˀo. Dâytꞌôephaḏendeḏáháˀ tꞌowaḏá ovâywa̖ˀoˀ nä́ˀi Jôesi Táḏáví tun namuuḏi, heḏiho wesebo inbí wä̖yu̖ dínhándeˀ. ");
INSERT INTO tew_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wíyá koˀji-á wä̖́ä̖ˀi phéˀyä̖́vi jâa-á najemu, heḏi wây-á wên tꞌowa-á iˀ tun ditꞌoeḏi nä́ˀi nan waaginbá dimuu. ");
INSERT INTO tew_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Báyékí hä̖ä̖wí nä́ä oepáa kꞌayḏiwiḏi ovâyˀá̖yîngimäˀ, heḏi hânho dâychä̖ˀsígíḏí in taˀgen namuu iweḏi dívíhângeˀoˀ, heḏá báyékí wíyá hä̖ä̖wí-á didaˀ, heḏiho iˀ koˀji óeˀánhógi waagibá dínpoeˀo, indá Jôesi Táḏáví híˀ dâyˀóḏé̖ˀdeḏi wên híwó wänbo wíˀovâyˀohpí. ");
INSERT INTO tew_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wíyá koˀji-á híwóˀdi nan deeḏá najemu, heḏi wây-á wên tꞌowa-á nä́ˀi híwóˀdi nan waaginbá-á dimuu. Jôesi Táḏáví tun ditꞌoeˀoḏi dâysígíˀoˀ, heḏi híwóˀdi hä̖ä̖wí dívíˀoˀ. Iˀ koˀji powintä̖ háa sígíntä̖ háa tä̖gintä̖ maˀkwꞌanukí shánkí napaa waagibá, nä́ˀin tꞌowa iweḏi wáy wên shánkí híwó dívíˀo wây-á wênbíˀweḏi.” ");
INSERT INTO tew_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Heḏi wáˀ ovâytu̖ˀan, “Ti wên phakó bîntsꞌúyaˀ wên tꞌún napekicháˀnin phoˀ háa whohte phoˀ bînkêeníḏí? Joe, wên phakóbay-á dâykéeˀí wáy nakohkeetꞌôení iwepíˀan. ");
INSERT INTO tew_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Heḏi hanbá tꞌä̖hkí hä̖ä̖wí nää nakaamuu wänbo nakeepúuwí, i dívíˀoˀ. Iˀ koˀji powintä̖ háa sígíntä̖ háa tä̖gintä̖ maˀkwꞌanukí shánkí napaa waagibá, nä́ˀin tꞌowa iweḏi wheḏi hä̖ä̖wí nää nakaˀpowamuupí wänbo-á nakaˀpowaḏee-í. ");
INSERT INTO tew_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Toˀwên naví híˀ ditꞌoeˀindá dínkhâyˀä̖ˀ híwó dívítꞌôeyaaníˀin. ");
INSERT INTO tew_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Hewänbo á̖yîngiḏi bítꞌôeyanbe. Wí hí̖yä̖̂ä̖wän úvítꞌôeyandáhoˀ, wí hí̖yä̖̂ä̖wän íkaˀpóewí. Hewänbo híwó úvítꞌôeyandá híwó wáˀ íkaˀpóewí, heḏá shánká íhá̖hpúuwí. ");
INSERT INTO tew_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Toˀwí nakaˀpówáˀi-á shánkí óekaˀpowamä̂äní. Hewänbo toˀwí híwó nakaˀpówápîˀ-á, iˀ waagibá, nä́ˀin tꞌowa iweḏi whí̖yä̖̂ä̖ nakaˀpówáˀiˀ ônkaaya̖mí.” ");
INSERT INTO tew_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","“Naaḏi wâythayya̖mí háa Jôesi Táḏáví há̖hkan ûnmuu waa. Ginnân waaginbá namuu: Wí sen nava iwe ikoˀjiwáḏe. ");
INSERT INTO tew_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Khun waagi iˀ sen najókhá̖yä̖ˀ, heḏá héḏén waagá ishaaḏeˀ. Iˀ koˀji-á natsijópúpuwamändi nasôemän, hewänbo iˀ sen wíˀûnhanginnáhpí háaḏí gin napoeˀoˀin. ");
INSERT INTO tew_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Iˀ nan diweḏi napipee. Páaḏé napee, heḏá natútoḏee, heḏá nakâypóe. ");
INSERT INTO tew_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Heḏi nakâypóe ihayḏá iˀ táhtsaa tsijóḏí itsꞌâˀ, táhtsaa ihayḏi nanândi.” ");
INSERT INTO tew_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus-di wíyá ovâytu̖ˀan, “Naaḏi wâytu̖hkankhâymáa háawin Jôesi Táḏáví há̖hkan ûnmuuˀin. Nä́ˀi há̖hkangîˀ híˀ wâytu̖ˀa̖mí wâythayya̖míḏí háa ûnwaḏeḏee-íˀin: ");
INSERT INTO tew_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ûnpúuwí háa wí mustard tân ûnpoeˀo waagibá. Nä́ˀi tândá shánkí hínchä̖̂ä̖ˀi namuu iˀ wéˀgeˀi koˀji tꞌä̖hkívíˀweḏi, ");
INSERT INTO tew_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","hewänbo óekoeḏi napee ihayḏi, shánkí nasôeˀo iˀ wéˀgeˀi nakoˀondivíˀweḏi. Heḏi nasôeḏi heˀendi nawaˀjáykhóepoeˀo, heḏá in tsíḏéˀây-á iˀ waˀjáykhóe eeḏá naˀóhkhunnáˀ deeḏi dâyyä̖́hpaˀ.” ");
INSERT INTO tew_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","In tꞌowa ovâyhá̖ˀoḏi báyékí há̖hkangîˀ óˀgéḏíˀây giˀbibá ovâytu̖ˀan, hä̖́yú̖ díntꞌôeyankoḏi ihay. ");
INSERT INTO tew_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Giˀbi híˀḏíḏa̖ˀ nä́ˀin tꞌowa ovâyhá̖ˀan, hewänbo wíˀbo iví khä̖geˀnindáḏí najiˀ ihayḏi indáho iˀḏi hä̖ä̖wí tꞌä̖hkí ovâythayjoˀ. ");
INSERT INTO tew_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iˀ thaabá nakin dihayḏi iví khä̖geˀnin itu̖ˀan, “Jaho gimú-í oe pꞌoekwí̖ˀ pꞌä̖́näpiye.” ");
INSERT INTO tew_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Heḏiho tꞌä̖hkí in tꞌowa ovâyjoeˀandi in tä̖ˀḏi wíje khä̖geˀnin iˀ kophé iwe dívítógiḏi indáḏí óehoˀ. Wây-á kophé wáˀ iwe dikwꞌó. ");
INSERT INTO tew_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Heḏi wí wa̖a̖ hânho kayˀi napówá, heḏi iˀ kophé búge napꞌoˀtsꞌúyaˀdi napꞌohpiḏemän. ");
INSERT INTO tew_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iˀ kophé tíˀûupiye pꞌônwéḏé eeḏi Jesus najókha̖wä̖kꞌóe, heḏi iví khä̖geˀnindi óejóhsandi óetu̖ˀan, “Há̖hkandiˀ, ti á̖yîngi wíwóemähpíˀan naˀin dípꞌotꞌakha̖nukhâyˀoˀ?” ");
INSERT INTO tew_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus ishaa, heḏi kaygindi óehéeˀan iˀ wa̖a̖, heḏá iˀ pꞌoekwîndá óetu̖ˀan, “Ánpí ókꞌuˀ.” Heḏi iˀ wa̖a̖ nahándí tꞌä̖hkí nahángípóe. ");
INSERT INTO tew_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Heḏi Jesus iví khä̖geˀnin itu̖ˀan, “Háaḏan íkhunwôedaˀ? Ti in wä̖yu̖ wívînmáapíˀan?” ");
INSERT INTO tew_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","In khä̖geˀnin hânho dikhunwôedaˀ, heḏi dívítu̖máa, “Háawi sennan nä́ˀi namuu? Wa̖a̖ḏi wänbo pꞌoeḏi wänbo-á óeˀaˀgindoˀ.” ");
INSERT INTO tew_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pꞌoekwí̖ˀ pꞌä̖́näpiye diphaḏeḏi in Gerasene-bí nange iwe dipówá. ");
INSERT INTO tew_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iˀ kophé iweḏi Jesus nawá̖ˀ dihayḏi, wí sen peníbégeḏi napee óejay-íḏí. Nä́ˀi sendá wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáa. ");
INSERT INTO tew_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","I-á tꞌowápho eeje nathaa, wáy dâypeníkhä̖ˀkwꞌóeˀó iwe. Óewhiˀowän, hebo wínawhisogeḏeeˀipí, kaḏénaḏi wänbo joe. ");
INSERT INTO tew_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hä̖́yä́nbo óekwä̖́kꞌukhú̖whiˀan, heḏá kaḏénaḏá óemanwhiˀan, hewänbo iˀ kaḏéna itä̖ä̖ḏi itsꞌándeˀ, iˀ kwä̖́kꞌukhú̖to-á ithándeˀ, heḏi nää toˀwí wänbo wíˀûnkoḏipí óesahá̖a̖nú-íḏí, ívíwo nakayḏi. ");
INSERT INTO tew_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Khu̖u̖-á thaa-á penípho eeje heḏá okú i̖ˀgá najiḏi itu̖wí̖núndeˀ, heḏá kꞌuuḏá ipitsꞌándeˀ. ");
INSERT INTO tew_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Heḏi Jesus kayi̖ˀ najiḏi óemûˀḏi ivíˀpiye iˀä̖ä̖, heḏi iví páaḏépiye idégeˀdisóge. ");
INSERT INTO tew_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesus-di iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ óetu̖ˀan, “Nä́ˀi senbíˀweḏi ópeeve.” Heḏi kaygi itu̖wí̖núḏí iˀ pꞌoewa̖a̖hâ̖a̖ natú̖, “Háaḏan ánpí wíḏíˀohpí, Jesus, u̖ Jôesi Táḏá iˀ shánkí kwꞌáye naˀä́ndiví ay unmuuˀiˀ? Naaḏi Jôesi Táḏáví páaḏépiye wídaˀmáa, wíḏítꞌôephaḏekannamípí.” ");
INSERT INTO tew_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus-di óetsikaˀyan, “Hânnan unkhá̖wä̖́?” “Gá Báyékí gân” gin natú̖ iˀ sen, “gá naˀindá báyékí gijiḏân.” ");
INSERT INTO tew_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Heḏi kayˀindi iˀ sendi Jesus óedaˀmáa nä́ˀin yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ wíˀovâysaanípí nä́ˀi nangeḏi. ");
INSERT INTO tew_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Iwe tsowa wáy báyékí pehtsuḏe dihúujiˀ ee okú wáhkí, ");
INSERT INTO tew_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","heḏi in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi Jesus kayˀindi óedaaˀan, “Naˀin oˀin pehtsuḏeví̖ˀge dísân inbí túˀ eeje ívítôeníḏí.” ");
INSERT INTO tew_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Háa didaˀpóeˀin Jesus-di ovâymä́gi, heḏiho in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ iˀ senbíˀweḏi dipeeḏi in pehtsuḏe eeje dívítógi. In pehtsuḏe-á oe wáhkíḏí pꞌoekwí̖ˀ diwepiye dívíˀä̖ä̖wá̖veḏi dívípꞌotꞌahá̖nú. Nä́ˀin pehtsuḏe maḏi wíje maapaasôn (2,000) ihay dijiˀ. ");
INSERT INTO tew_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","In dâypehtsuḏeˀá̖yînmáaˀin dishavemää, heḏi iwáy búˀ heḏá búˀḏí jáˀwé-á háa napóeˀin dâytꞌôehoˀ. Heḏiho in tꞌowa dâymúuníḏí dimää. ");
INSERT INTO tew_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus-víˀwe dipówá ihayḏi iˀ sen báyékí yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ ivíˀweḏi ônkhehpiyeˀiˀ óemûˀ. Nää-á naˀaamuu heḏá iví hangintandá imáa. Óemûˀ ihayḏi dikhunwôedaˀpóe. ");
INSERT INTO tew_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","In tꞌowa háa napóeˀin dâymûˀindi in tꞌowa dipówáˀin ovâytu̖ˀan iˀ senbí̖ˀgeḏi háa óeˀannin, heḏá háa in pehtsuḏe dínpóeˀindá. ");
INSERT INTO tew_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ihayḏáháˀ in tꞌowaḏi hânho kayˀindi Jesus óedaaˀan inbí nangeḏi ijâatä̖ä̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus iˀ kophé iwe itohon dihayḏi, iˀ sen in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ ivíˀweḏi ônkhehpiyeˀiˀḏi pín taˀgeḏi óedaaˀan, “U̖-áḏí dípunmä́ä.” ");
INSERT INTO tew_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hewänbo Jesus-di wíˀóepunmä́gipí. Óetu̖ˀan, “Uvíˀpiye ópûndi uví tꞌowa ovâytꞌôeˀa̖mí tꞌä̖hkí háa iˀ shánkí natsonjiˀiˀḏi u̖gîˀ wônˀannin, heḏá háa uvíˀpiye nasehkanäpóeˀindá.” ");
INSERT INTO tew_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Heḏiho iˀ sen iˀ nange Tä̖ Búˀwi Nange gin dâytu̖ˀoˀ iwepiye namää, heḏi háa Jesus-di ônˀannin ovâytꞌôeˀan. Tꞌä̖hkí in tꞌowa ditꞌoeˀin ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus iˀ kophé iweḏi pꞌoekwí̖ˀ pꞌä̖́näḏi nawáyˀä̖ä̖ ihayḏi, pꞌo kíngé wáy najiˀ iwe báyékí tꞌowa diwéˀgepóe. ");
INSERT INTO tew_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Heḏi wí sen, Jairus gin nakhá̖wä̖́ˀi naˀä̖ä̖, i-á in Huḏíyoví méesateˀaywi pꞌóˀḏéḏîˀ namuu. Iˀḏi Jesus óemûˀḏi iví páaḏépiye idégeˀdisóge óekhä̖geˀdaaˀa̖míḏí, ");
INSERT INTO tew_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","heḏi pín taˀgeḏi óetu̖ˀan, “Naví ayú̖káy dînchuwamääˀä̖. Naví kꞌaygipiye unmú-í heḏi uví mandi nâatä̖ä̖gé-í, heḏânho nawôewa-í heḏá nawówáyê̖e̖ní.” ");
INSERT INTO tew_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Heḏiho Jesus i-áḏí namää. Báyékí tꞌowa dä́nwóemää, heḏi indi Jesus óetꞌä̖́ˀtꞌä̖́ˀchä̖nuhon. ");
INSERT INTO tew_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wí kwee wáˀ ûnwóemän, i-á napꞌóehayḏi tä̖ˀḏi wíje (12) pa̖a̖yo iví ûnpꞌoe wíˀûnwóyí̖ˀdeeˀipí. ");
INSERT INTO tew_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ikhä̖geˀtu̖wä̖máaḏí iví hä̖ä̖wí tꞌä̖hkí iku̖ˀchꞌáaḏáháˀ iví chä̖ˀdá ihá̖nú, hewänbo in woekannindi shánkí óewänpitꞌôephaḏekannan, heḏi óekhä̖geˀnamívíˀweḏi shánká nahaypóe. ");
INSERT INTO tew_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nä́ˀi kwee-á Jesus-ví̖ˀgeḏi natꞌoe, heḏiho iví tíˀûupha̖ˀgeḏi tꞌowa jâa natsꞌú̖ iví kꞌéwéˀin to ôntä̖ä̖gé-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ginnân iˀánshaamáa: “Jesus-ví kꞌéwéˀin to kꞌáygéḏí wän dôntä̖geḏibo owôewa-í.” ");
INSERT INTO tew_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Heḏi ôntä̖geḏi wesebo iví ûnpꞌoe ûnwóyí̖ˀdee, heḏi iví túˀ iwe nataachanpóe iví ta̖wä̖ ûnhehkháapóeˀin. ");
INSERT INTO tew_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wesebo Jesus ûnhanginpóe iví pínnándí toˀwí nahehkháapóeˀin, heḏi in tꞌowa jâaḏi ibéeḏí natú̖, “Toˀḏan naví aa dîntä̖ge?” ");
INSERT INTO tew_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iví khä̖geˀnindi óetu̖ˀan, “Nä́ˀin báyékí tꞌowaḏi u̖ˀ wóetꞌä̖́ˀtꞌä̖́ˀchä̖numáaḏí ovâymúndepíˀan, heḏiho háaḏan untû̖ˀ, ‘Toˀḏan naa dítä̖ge?’ gin” ");
INSERT INTO tew_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hewänbo Jesus-á ibéemáa, toˀḏan óetä̖geˀin óemúuníḏí. ");
INSERT INTO tew_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iˀ kwee ûnhanginpóe háa ûnpóeˀin, heḏi nakhunwôedaˀpóeḏáháˀ natha̖tha̖póe, heḏi Jesus-víˀpiye namääḏi iví páaḏépiye idégeˀdisóge, heḏi óetu̖ˀan taˀgendi háa iˀannin. ");
INSERT INTO tew_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus-di óetu̖ˀan, “Naví ay, uví wä̖yu̖ úmuuḏi unhewówa. Ánshaaginpíḏíbo ópûn. Unhehkháamúuní-áhay.” ");
INSERT INTO tew_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Waˀḏi ihíˀmáa ihayḏibo wên senäˀ iˀ méesatewi pꞌóˀḏéḏîˀvíˀweḏi dipówá, heḏi óetu̖ˀan, “Janbo Jesus-á ibéemáa, toˀḏan irus, iˀ há̖hkandi ánpí óˀan, uví ayú̖káy-á ho úchuu.” ");
INSERT INTO tew_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hewänbo Jesus-di háa ditû̖ˀ wänbo wíˀovâyˀá̖yîngiˀanpí, heḏi nä́ˀi tsondi óetu̖ˀan, “Wíˀunkhunwôedaˀípí, ówänpiwä̖́yú̖.” ");
INSERT INTO tew_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Heḏi Peter-á James-á heḏá John-dá, James-ví tíˀûu ûnmuuˀiˀ, inda̖ˀ i-áḏí ovâypunmä́gi. ");
INSERT INTO tew_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iˀ tsondiví tewhá jáˀwé napówá ihayḏi hânho díntû̖ˀdi natꞌoe. Wáy wên diséejiˀ, wây-á wêndá dívísíhtu̖wí̖núndeˀ. ");
INSERT INTO tew_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Heḏi natsꞌú̖ˀ dihayḏi ovâytu̖ˀan, “Háaḏan hânho úntû̖ˀ, háaḏan íséejiˀ? Iˀ ayú̖káy-á wínachuupí, nawänpijókha̖wä̖kꞌóe-á.” ");
INSERT INTO tew_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","In tꞌowaḏi ônwänpipꞌáhkaa. Heḏiho Jesus-di tꞌä̖hkí ovâykhehpiye, heḏi iˀ ayú̖káyví táḏá-á jíyá-á in poje khä̖geˀnindá i-áḏí ovâyhondi iˀ wêe íve iˀ ayú̖káy nakꞌóe ee ditsꞌú̖. ");
INSERT INTO tew_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iˀ ayú̖káyví man ônyâ̖ˀḏi Huḏíyoví tundi óetu̖ˀan, “Talitha kum.” (Nä́ˀi híˀ ginnân natundaˀ: “Óshaa ayú̖káy gân wítu̖máa.”) ");
INSERT INTO tew_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wesebo ishaaḏi ijíyé (i-á tä̖ˀḏi wíje pa̖a̖yo ihayˀi namuu), heḏi hânho ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus-di kayˀindi ovâykhâ̖a̖ˀan toˀwí wänbo wíḏâyhanginˀânnamípíˀin háa napóeˀin, heḏi ovâytu̖ˀan iˀ ayú̖káy óehúujôeníˀin. ");
INSERT INTO tew_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iweḏi Jesus napeeḏi iví khä̖geˀnindáḏí iví ówîngepiye namää. ");
INSERT INTO tew_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iˀ kaykhanwówá thaa napówá ihayḏi Huḏíyoví méesateˀay ee ovâyhá̖ˀoˀ, heḏi in báyékí tꞌowa iwe dikwꞌóˀnin dívítꞌôeyannin ovâyháaˀan, heḏi ditú̖, “Wä̖́hä̖̂ä̖-an nä́ˀi natû̖ˀdi tꞌä̖hkí ûnhanginpóe, heḏi toˀḏan óehangintanmä́gi? Háḏíḏan nä́ˀi pínnán tꞌôe iˀoˀ? ");
INSERT INTO tew_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ti i-á iˀ phéˀtꞌôeˀiˀḏa̖ˀ wínamuupíˀan, Mary-ví ay-á? Ti nä́ˀin senäˀ James-á Joses-á Judas-á Simon-dá iví tíˀûuwin wíˀûnmuupíˀan? Heḏá in kwiyä̖ˀ iví tíˀûuwin ûnmuuˀin wáˀ, ti naˀindáḏí wíḏijihpíˀan?” Gin in tꞌowa ditû̖ˀ gá i-áḏí híhchan wíḏínpóepíḏân. ");
INSERT INTO tew_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Heḏi Jesus-di ovâytu̖ˀan, “Wí Jôesi Táaví tukheˀbi-á wä̖́hä̖̂ä̖ wänbo tꞌä̖hkí óeˀaˀgin, hewänbo iví nange iwá joe, iví tꞌowa-áḏá joe, heḏá iví kꞌaygi wänbo-á joe.” ");
INSERT INTO tew_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Heḏi wên hí̖yä̖̂ä̖ḏiḏa̖ˀ tꞌowavîˀḏi imankꞌûˀḏi hehkháa ovâymä́gi, hewänbo wíyá pínnán tꞌôe wänbo wíˀûnkoḏipí iˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Inbí wä̖yu̖píḏí óeháaˀan. Ee búˀây i̖ˀge Jesus namändi ovâyhá̖hkanhon. ");
INSERT INTO tew_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Heḏá in tä̖ˀḏi wíje (12) khä̖geˀnin ivíˀpiye ovâywéˀgetu̖ˀandi wíˀjendi ovâypuwaˀan, heḏi iví tꞌôe dívíˀa̖míḏí ovâysan. Dimääpíḏíboˀ iˀḏi ovâykꞌûˀ in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ ovâytꞌaaníḏí. ");
INSERT INTO tew_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ginnân ovâyjôn: “Ímän dihayḏi uḏuphéḏa̖ˀmân bînhûuwí, wíyá hä̖́ä̖bo-á joe — wí koegîˀ wänbo joe, heḏiháa wí múu bînhä̖ä̖wíkuu-ígîˀ wänbo joe, heḏiháa wí chä̖ˀ únmúhtoˀondi wänbo joe. ");
INSERT INTO tew_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Unbí anto úntoˀonda̖ˀ bînhûuwí, heḏá wíje to-á wívînhûuwípí.” ");
INSERT INTO tew_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ovâytu̖ˀan wáˀ, “Wä̖́hä̖̂ä̖ ímää wänboˀ, wí tewhá ee wovâysígíˀandi eebo úvíwóyí̖ˀní, iˀ búˀḏí ímää píhay. ");
INSERT INTO tew_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hewänbo wä̖́hä̖̂ä̖ wovâysígíˀanpíḏá, heḏiháa wovâytꞌôeyanpíḏá, iweḏi ípeemän dihayḏi unbí anto iweḏi bînnaˀjeepêeḏi-í in tꞌowa dínhanginnáaníḏí híwó wíḏívíˀanpíˀin.” ");
INSERT INTO tew_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Heḏiho iví khä̖geˀnin iweḏi dimääḏi in tꞌowa ovâytꞌôeˀan inbí tꞌaywóˀdi dâyjoeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Báyékí yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpiye, heḏá báyékí tꞌowa dihayˀindá olive ka̖ˀpꞌoe-á ovâyˀä̖yu̖ḏi hehkháa ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heḏi Herod iˀ nangewi tsondi namuuˀiˀ ûnhanginpóe háa napuwamännin, in tꞌowa tꞌä̖hkí Jesus-ví̖ˀgeḏi dívíhíˀmáaḏí. Wên ditû̖ˀ, “I-á John iˀ pꞌóˀpꞌoekandi namuu nawáywówápóeˀiˀ, heḏân kavêe nä́ˀi pínnán tꞌôe iˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wây-á ditû̖ˀ, “Elijah-ân namuu.” Heḏá wây-á wêndá ditû̖ˀ, “In wéˀgen Jôesi Táḏáví tukheˀmin diweḏiˀi-ân namuu, in hä́nˀoeˀin tukheˀmin waagiˀbá namuu.” ");
INSERT INTO tew_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hewänbo Herod natꞌoe ihayḏi, i-á natú̖, “John iˀ pꞌóˀpꞌoekandi-ân namuu, iˀ to otsonpóe óekꞌéˀtsꞌâa-íˀi-ân nawáywówápóe.” ");
INSERT INTO tew_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Haˀwâa Herod natú̖ gá hä̂nhay natsonpóeḏân John óepankáyjíḏí heḏá pantewhá ee óewhisôege-íḏí. Iví kwee Herodias-gîˀ ginho iˀan. Nä́ˀinnânho napóe: Herod wí tíˀûu ûnˀä́n, Philip gin nakhá̖wä̖́ˀiˀ, heḏi tobá Herodias-á Philip-ví kwee ûnmuu wänboˀ, Herod-di óekhóˀyâ̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Heḏi John-di Herod óetu̖máa, “Híwó wínamuupí uví tíˀûuví kwee mânkáyjíḏí.” ");
INSERT INTO tew_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Heḏânho Herodias-di John óetꞌayḏi nadaˀ toˀwíḏí óeháyjíˀin, hewänbo wíˀûnkoḏipí, ");
INSERT INTO tew_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","gá Herod-di John óekhunwôedaˀḏân. Herod-dá ûnhanginná John iví wówátsi taˀge ihonnin heḏá yä̖ˀḏâaˀi-á namuu, heḏiho ônˀaywondeˀ. Herod óehí̖ˀan John-bí híˀ ôntôeyaaníḏí, hewänbo ôntꞌôeyandeḏi háa iˀánshaaˀa̖míˀin wíˀishaaḏepí. ");
INSERT INTO tew_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tꞌôeḏiwän híwó ûnpóe Herodias. Herod-ví aycha thaa ûnnândi ishánkíˀeeḏipaa, heḏi in tsonnindá in sundaḏo pꞌóˀḏéḏíˀindá heḏá in koḏitꞌowa senäˀ Galilee-windá ovâyhúutu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heḏi Herodias-ví aˀyú̖ ûntsꞌûndi ovâyjáḏe, heḏi Herod-á in ovâyhúutu̖ˀannindá ovâyhí̖ˀan iví shaḏe. Heḏiho Herod-di iˀ aˀyú̖ óetu̖ˀan, “Dídaaˀan naa hä̖ä̖wí undaˀiˀ, heḏi naaḏi iˀ wímä̂äní.” ");
INSERT INTO tew_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iví tun imä́gi Jôesi Táḏáví páaḏépiye ginnân: “Hä̖ä̖wí undaˀpóeˀiˀ, naaḏáho wímä̂äní, naví nan wänbo píngé hayḏi wímä̂äní.” ");
INSERT INTO tew_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Heḏi iˀ aˀyú̖ napeeḏi iví jíyá óetsikaˀyan, “Hä̖ä̖-an odaˀpúuwí?” Iví jíyáḏí óetu̖ˀan, “Gá John iˀ pꞌóˀpꞌoekandiví pꞌônnân undaˀpúuwí.” ");
INSERT INTO tew_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Iˀ aˀyú̖ iwä̖́nähoˀḏi wesebo ee Herod naˀä́n dee natsꞌú̖, heḏi óetu̖ˀan: “Naa odaˀ wesebo dímä̂äníˀin wên sä̖ˀwé pháagîn diweḏi John iˀ pꞌóˀpꞌoekandiví pꞌôn.” ");
INSERT INTO tew_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herod natꞌoeḏi báyékí nachanpóe, hewänbo in senäˀ dikwꞌóˀninbí páaḏépiye iví tun imä́giˀin namuuḏibo wínadaˀpí “joe” gin óetu̖ˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Heḏiho wí sundaḏo á̖yí̖ˀdiˀ óepunjôn John óekꞌéˀtsꞌâa-íḏí pan tewhá ee, iví pꞌôn ônkáyjíḏí. ");
INSERT INTO tew_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Heḏi iˀ sundaḏo han iˀandi John-bí pꞌôn wên sä̖ˀwé pháagîn diweḏi ônmaa. Iˀ aˀyú̖ ônˀandáháˀ i aˀyú̖ḏá iví jíyá-á ônˀan. ");
INSERT INTO tew_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","John-ví khä̖geˀnin dínhanginpóe ihayḏi diˀä̖ä̖ iˀ pení dâykáyjíḏí, heḏi dâykhä̖ˀkꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesus-ví tꞌôekhuwaˀin Jesus-víˀpiye diwáyˀä̖ä̖, heḏi tꞌä̖hkí háa dívíˀan waa heḏá hä̖ä̖wí tꞌä̖hkí dâyhá̖ˀannindá óetꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Báyékí tꞌowa diˀä̖ä̖ˀä̖ḏá dimääˀä̖ḏá Jesus-á iví khä̖geˀnindá húu wänbo wíˀovâymähpí. Heḏiho Jesus iví khä̖geˀnin itu̖ˀan, “Jaho gimú-í oe hânda̖ˀ nanáˀ diwepiye wíˀbo giyê̖e̖níḏí, heḏi owe ívíkaykhanwówáˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Heḏiho kophé iweḏi oe hânda̖ˀ nanáˀ diwepiye dimää. ");
INSERT INTO tew_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hewänbo dívíjâaˀandi báyékí tꞌowa iˀ búˀây i̖ˀgeˀindi ovâymûˀ, heḏi ovâytaa, heḏi oe pꞌoekwí̖ kíngé nangeḏibo dívíˀa̖ˀyu̖u̖ˀandi Jesus-ví páaḏébo dipówá. ");
INSERT INTO tew_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus iˀ kophé iweḏi nawha̖veˀä̖ḏi in báyékí tꞌowa ovâymûˀ, heḏi inbíˀpiye nasehkanäpóe gá wên kꞌúwá waagibá á̖yí̖ˀdipíḏíbo dijiḏân, heḏiho báyékí hä̖ä̖wí ovâyhá̖ˀan. ");
INSERT INTO tew_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nakinmän dihayḏi iví khä̖geˀnin ivíˀpiye diˀä̖ä̖ḏi óetu̖ˀan, “Nä́we naˀahkonná, heḏá nää-á nakinmän. ");
INSERT INTO tew_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nä́ˀin tꞌowa ovâypunjônbe iˀ nava hä̖ä̖ tsowa nanân deejepiye heḏá iˀ búˀây eejepiyá, dâyhä̖ä̖wíkuumä́-íḏí dívíhú̖u̖ya̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hewänbo Jesus-di ovâytu̖ˀan, “Undiḏânho bînhúujôení.” Indi óetu̖ˀan, “Háḏíḏan âyˀa̖mí? Ti undaˀ gimú-íˀin wáygín tä̖gintä̖ (200) thaa tꞌôe dívíˀandi wáˀâa âyhá̖a̖nú-íḏí koegîˀ âykuumä́-íḏí, heḏá âymä̂äní dâykꞌoˀíḏí?” ");
INSERT INTO tew_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus-di ovâytsikaˀyan, “Hä̖́yú̖-an koegîˀ bînmáa? Ja binmúˀḏí.” Hä̖́yú̖ dâymáaˀin dínhanginpóe ihayḏi ditú̖, “Pꞌánú páváˀây heḏá wíje paˀây-á.” ");
INSERT INTO tew_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Heḏi in tꞌowa tꞌä̖hkí ovâytu̖ˀan ee táa tsá̖wä̖́ eeḏi dívíbóeḏíkwꞌôení. ");
INSERT INTO tew_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Heḏi dívíwhaaḏikwꞌóḏi tä̖gin tä̖gindá (100’s) heḏá pꞌánä́n tä̖gindá (50’s). ");
INSERT INTO tew_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus iˀ pꞌánú pává heḏá in wíje paa-á ihógi, heḏi makówápiye ibéeḏí ikú̖ˀdaaˀandi iˀ pává-á heḏá in paa-á iháve. Heḏáháˀ iví khä̖geˀnin ovâyˀan in tꞌowa ovâyphaaḏé-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tꞌä̖hkí in tꞌowa dívíhú̖u̖yandi dívíshu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","heḏi iví khä̖geˀnin tä̖ˀḏi wíje (12) tꞌún pꞌéeḏí iˀ dínphaḏeˀi pává heḏá paa-á dâywéˀgeˀan. ");
INSERT INTO tew_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","In senäˀda̖ˀbo dívíhú̖u̖yannin pꞌánú maapaasôn (5,000) ihay dijiˀ. ");
INSERT INTO tew_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wesebo Jesus iví khä̖geˀnin ijôn iˀ kophé iwe dívítôeníḏí, heḏi ovâytu̖ˀan oe pꞌoekwí̖ˀ pꞌä̖́näpiye dipáaḏémú-íˀin, Bethsaida búˀay nanáˀ diwepiye. Hebo i-á iwebo iwóyí̖ˀ in tꞌowa ovâypunjôeníḏí. ");
INSERT INTO tew_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Heḏi in tꞌowa ovâyjoeˀandi okú kwꞌáyepiye namää ijûusuˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nakhunpóe ihayḏi iˀ kophé oe pꞌoe pinuḏi namän, heḏi Jesus-á wíˀbo-á ee nan deeḏi najiˀ. ");
INSERT INTO tew_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hânho dívítꞌôekanhondi ovâymûˀ, iˀ wa̖a̖ḏi páaḏépiye wíˀovâypunmähpíḏí. Héḏénpiye nanáˀ dihayḏi pꞌoe kwꞌáayé najiˀ ovâykâaníḏí, heḏi ovâyphaḏekhâymáawän. ");
INSERT INTO tew_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","In khä̖geˀnindi pꞌoe kwꞌáayé najiḏi óemûˀ, heḏi wí pꞌoewa̖a̖hâ̖a̖ iˀ namuu gin diˀândi dívítu̖wí̖nú dikhunwôedaˀ waa, ");
INSERT INTO tew_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","gá tꞌä̖hkíḏí óemûˀḏi dívípíhä̖ä̖ḏân. Hewänbo wesebo ovâytu̖ˀan, “Unbí píˀnä́ khóˀjé íkaymúuní. Naa Jesus-ân omuu. Wíˀíkhunwôedaˀípí.” ");
INSERT INTO tew_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Heḏi iˀ kophé iwe indáḏí ipitógi, heḏi iˀ wa̖a̖ nahán. Hânho ovâyháaˀan, ");
INSERT INTO tew_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","gá dikaˀpowakâymuuḏân. Waˀḏi wíḏikaˀpóyaˀpí taˀgendi toˀwí namuuˀin, tobá iˀ páváḏí wí pínnán tꞌôe iˀan wänbo. ");
INSERT INTO tew_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Oe pꞌoˀ pꞌä̖́näpiye diphaḏeḏi Gennesaret nange dipówá, heḏi iˀ kophé dâywhisóge. ");
INSERT INTO tew_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iˀ kophé iweḏi dipee ihayḏi wesebo in tꞌowaḏi Jesus óetaa. ");
INSERT INTO tew_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wáygé najiˀin dínhanginpóe ihayḏi, in tꞌowa tꞌä̖hkí dívíˀa̖ˀyu̖u̖ˀan in dihayˀin inbí whohpa̖ˀ wóegé ovâykáaníḏí. ");
INSERT INTO tew_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wä̖́hä̖̂ä̖ Jesus namää wänboˀ, háa búˀây i̖ˀge, háa búˀ heˀendi i̖ˀge, heḏiháa búˀ jáˀwé iwe in tꞌowaḏi nä́ˀin dihayˀin bûu píngé iwe ovâykwꞌóeˀó, heḏá pín taˀgeḏi óedaaˀoˀ iví toˀ kꞌáygéḏí wän ôntä̖ä̖gé-íḏí, heḏi tꞌä̖hkí in óetä̖geˀin dihehkháapóe. ");
INSERT INTO tew_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","In Pharisee tꞌowa-á heḏá wên Huḏíyoví khuu dâyhá̖ˀoˀindá Jerusalem-di diˀä̖ä̖ḏi Jesus-víˀwe dívíwéˀgeˀan. ");
INSERT INTO tew_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Heḏi indi ovâymûˀ Jesus-ví khä̖geˀnin dívíhúujoḏi dívímanˀowíḏipíḏíboˀ in Huḏíyoví khuu waa. ");
INSERT INTO tew_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nä́ˀin Pharisees-á heḏá tꞌä̖hkí in wéˀgen Huḏíyo-á wíḏívíhúujopí páaḏé dívímanˀowíḏipíḏíboˀ, háa in hä́nˀoeˀin Huḏíyoví khuu dínmuu waagi. ");
INSERT INTO tew_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Heḏi wáy dâyhä̖ä̖wíku̖ˀchꞌáaḏeˀ iweḏi diˀä̖ä̖ḏi wíḏívíhúujopí páaḏé gin dívímanˀowíḏipíḏíboˀ; heḏá báyékí ha̖ˀbi khuu-á dâyˀaˀgindoˀ. Inbí kꞌéḏé-á pꞌonbay-á sänbáy-á dâyˀowíḏínde háa namúuní waagi. Gin dínmuu inbí khuu. ");
INSERT INTO tew_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Heḏi nä́ˀin Pharisees-á nä́ˀin Huḏíyoví khuu dâyhá̖ˀoˀindá indi Jesus óetsikaˀyan, “Háaḏan uví khä̖geˀnin in hä́nˀoeˀin seˀdaaví khuu dâyˀaˀginnamívíˀweḏi, inbí húugîˀ dâykꞌoˀ waˀ dívímanˀowíḏipíḏíbo háa nakhâyˀä̖ˀ waagi?” ");
INSERT INTO tew_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Iˀḏi ovâytu̖ˀan, “Un paa waaginbá úvíjánúmáaˀin ímuuˀin, hä́nˀoe híwó Isaiah-ḏi unbí̖ˀgeḏi itaˀnan háawin tꞌowa ímúuníˀin. Ginnân háa Jôesi Táḏá natú̖ˀin itaˀnan: Nä́ˀin tꞌowa híwó naví̖ˀgeḏi dívíhéeˀo sóphogeḏi, hewänbo inbí píˀnä́ḏá han wíḏícha̖a̖pí. Ditû̖ˀ naa díˀaˀgin, hewänbo wíḏínchä̖ˀmuupí, gá tꞌowaví híˀḏa̖ˀ dâyhá̖ˀoḏân, heḏá ditû̖ˀ inbí híˀ-á naví há̖hkan dînmuu. ");
INSERT INTO tew_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Háa Jôesi Táḏá natsonpóeˀin bînjoegiˀoˀ, heḏi tꞌowaví khuu-á bînhóndeˀ. ");
INSERT INTO tew_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Íchanpóe hânho únhanginnân waa, háa Jôesi Táḏá natsonpóeˀin bînhângeˀoḏi unbí khuu bînˀaˀginnamíḏí. ");
INSERT INTO tew_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses natú̖hpíˀan, Unbí táḏáˀin jíyáˀin bînˀaˀginnamí. Heḏá wáˀ natú̖, Toˀwí iví táḏáví̖ˀgeḏi háa iví jíyáví̖ˀgeḏi híwóhpí ihéeˀandi, i-á óeháyjí. ");
INSERT INTO tew_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Hewänbo undá ginnân ítû̖ˀ: Wí toˀwí ûnˀä̖ˀ iví táḏá háa iví jíyá itu̖ˀâ̖a̖míˀin, ‘Naví hä̖ä̖wí i̖ˀgeḏi otû̖ˀ Korban gin.’ (Huḏíyoví tundá Korban natundaˀ, ‘Nä́ˀi hä̖ä̖wí-áho Jôesi Táḏá dómä́gi’ gin.) Heḏi tobá iˀ hä̖ä̖wíḏí iˀ táḏá háa iˀ jíyá óekhä̖geˀnamí wänboˀ, nä́ˀi toˀwí gin natú̖ˀi hä̖ä̖wí wänbo ingîˀ wívînkanmä̂änípí. ");
INSERT INTO tew_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Báyékí hä̖ä̖wí haˀwâagi bînˀoˀ, heḏiho unbí khuu bînhá̖ˀoḏi Jôesi Táḏáví híˀ wíˀûnchä̖ˀmuupí waa bînkanmáa.” ");
INSERT INTO tew_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","In tꞌowa wíyá ovâywéˀgeˀan dihayḏi, Jesus-di ovâytu̖ˀan, “Tꞌä̖hkíḏíbo bítꞌôeyan, heḏânho íkaˀpóewí. ");
INSERT INTO tew_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Háawi wí hä̖ä̖wí namuu wänbo tꞌowa dâykꞌoˀiˀḏá yä̖ˀḏâapíˀin wíḏipoeˀopí. Hewänbo hä̖ä̖wí híwóhpîˀ inbí píˀnä́ khóˀjé iweḏi dínpeeˀiˀḏáho yä̖ˀḏâapíˀin dipoeˀo. ");
INSERT INTO tew_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Toˀwí nakaˀpowadaˀi-á ûnkhâyˀä̖ˀ itꞌôeyaaníˀin.” ");
INSERT INTO tew_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","In tꞌowa ovâyjoeˀan dihayḏi iví tewhá ee natsꞌú̖, heḏi iví khä̖geˀnindi óetsikaˀyan nä́ˀi híˀ hânnan natundaˀin. ");
INSERT INTO tew_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Heḏi ovâytu̖ˀan, “Ti un wáˀ kaˀpowapíˀin ímuu? Ti wíˀúnhanginnáhpíˀan wí toˀwí yä̖ˀḏâapîˀ wínapoeˀopí wí hä̖ä̖wí iví jáˀwéḏí ûntsˀûndiḏi, ");
INSERT INTO tew_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","gá nä́ˀi hä̖ä̖wí wíˀûntsꞌúyaˀpíḏân iví píˀnä́ khóˀjé, hewänbo iví see iwáhoˀ, heḏi iví túˀ iweḏi ûnwänpiphaḏeˀ.” (Nä́ˀi ovâytu̖ˀandi Jesus-di ovâyhá̖ˀan tꞌä̖hkí koegîˀ-á híwóˀdi namuu óekꞌoˀígîˀ). ");
INSERT INTO tew_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Heḏáháˀ ovâytu̖ˀan, “Hä̖ä̖wí wí toˀwíví píˀnä́ḏí ûnpeeˀiˀḏibâa yä̖ˀḏâapîˀ napoeˀo. ");
INSERT INTO tew_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Híwóhpí ánshaa wí toˀwí iví píˀnä́ khóˀjé imáaḏí i-á nasändaˀ; natꞌowatꞌakha̖nudaˀ; wínakhóhtsa̖a̖ˀä́npí wänbo toˀwí-áḏí iwhohkumáa; háa tobá nakhóhtsa̖a̖ˀä́n wänboˀ, wíyá toˀwíví kwee-áḏí háa sendáḏí iwhohkumáa; hä̖ä̖wí wéˀgen tꞌowa dâymáaˀi-á nadaˀ; jänäkíkandi namuu; nahójo; háa nawänpidaˀ waagi iˀoˀ; nathúutꞌóe; tꞌowaví̖ˀgeḏi híwóhpí ihéeˀoˀ; icha̖a̖ˀoˀ; tꞌôeyanpîˀ namuu. ");
INSERT INTO tew_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nä́ˀi yä̖ˀḏâapîˀ hä̖ä̖wí wí toˀwíví píˀnä́ khóˀjé iweḏi ûnpeeḏi, iˀḏibâa yä̖ˀḏâapîˀ óepaˀ.” ");
INSERT INTO tew_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesus iˀ nange ijoeˀandi Tyre búˀ tsowapiye namää, heḏi wí tewhá ee natsꞌú̖. Wínadaˀpí toˀwí wänbo ûnhanginnáaníˀin ee naˀä́nnin, hewänbo wíˀûnkoḏipí ikaaya̖míˀin. ");
INSERT INTO tew_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Heḏi wí kwee Jesus-ví̖ˀgeḏi natꞌoeḏi wesebo ee naˀä́n deepiye namää. Nä́ˀi kwee-á Syrophoenicia-wi namuu, heḏiho koḏi Huḏíyo wínamuupí. Iví ayú̖káy wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi ônmáa, heḏi Jesus-ví páaḏépiye idégeˀdisógeḏi kaygindi óedaaˀan iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ iví aˀyú̖víˀweḏi ônkhehpeeyé-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus-di iˀ kwee óetu̖ˀan, “Naa wíḏînkhâyˀä̖hpí in wéˀgen tꞌowa dovâykhä̖geˀnamíˀin, in Huḏíyo tꞌowa dovâykhä̖geˀnanpíḏíboˀ. U̖ˀ páaḏé wíkhä̖geˀnandá, in áyyä̖̂ä̖ví húugîˀ in tséˀây dovâymäˀ waagibá namúuní.” ");
INSERT INTO tew_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Iˀ kweeḏi óetu̖ˀan, “Nanbí Sedó, háa untú̖ waa taˀgen namuu. Hewänbo iˀ pávátä̖́ mä́äsa phoˀ in áyyä̖̂ä̖ dínjemuˀiˀ in tséˀây wänbo dâykꞌoˀ.” ");
INSERT INTO tew_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus-di óetu̖ˀan iˀ kwee, “Híwó untú̖ḏího naaḏi iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ uví ayú̖káyvíˀweḏi dônkhehpiye. Jaho uvíˀpiye ópûn.” ");
INSERT INTO tew_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Heḏi iˀ kwee ivîˀ napówá ihayḏi, iˀ aˀyú̖ whohte eeḏi nakꞌóeḏí óemûˀ, heḏi iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ ho ûnpee. ");
INSERT INTO tew_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tyre búˀḏí Jesus napeeḏi Sidon búˀ i̖ˀge naphaḏe, heḏá iweḏá Galilee pꞌoekwíngépiye nawáymää, iˀ nange Tä̖ Búˀ Nange gin dâytu̖ˀoˀ iwe. ");
INSERT INTO tew_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Heḏi wí sen ojetꞌaaˀi namuuˀi heḏá tunpîˀ-á ônkán, heḏi pín taˀgeḏi óedaaˀan iˀ sen óetä̖ä̖gé-íḏí ônhehkháaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus-di iˀ sen in tꞌowavíˀweḏi wíˀboˀ óejâaˀan, heḏi iví mankhú̖ iˀ senbí oje phóge itógi, heḏáháˀ imankhú̖sópꞌoˀandi iˀ senbí hän ôntä̖ge. ");
INSERT INTO tew_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Heḏi makówápiye ibéeḏí kaygi ihâ̖a̖ˀan, heḏi iˀ sen óetu̖ˀan, “Ephatha” gin. (Nä́ˀi tun Ephatha-á “nakhuuḏee-í” gân natundaˀ Huḏíyoví tundi.) ");
INSERT INTO tew_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wesebo iˀ senbí ojepho ûnkhuuḏee, iví händá ûnjuḏeḏee, heḏi thayˀeeḏi ihéeˀan. ");
INSERT INTO tew_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Heḏi Jesus-di in tꞌowa ovâykhâ̖a̖ˀan toˀwí wänbo wíḏâytꞌôeˀa̖mípíḏí, hewänbo indá shánkí ovâykhâ̖a̖ˀandá shánká dâytꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","In tꞌowa ditꞌoeḏi hânho ovâyháaˀan, heḏi ditú̖, “Hä̖ä̖wí tꞌä̖hkí híwó iˀoˀ. In ojetꞌaaˀin wänbo ditꞌoeˀo, in tunpíˀindá dívíhéeˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ihayhä̖̂ä̖bá wây-á báyékí tꞌowa diwéˀgepóe, heḏi hä̖ä̖wí wänbo dâykꞌoˀígîˀ wíḏâymáapí. Jesus iví khä̖geˀnin itu̖ˀandi ovâytu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Naa nä́ˀin tꞌowavíˀpiye osehkanäpóe. Poje thaa naa-áḏí dijiˀ, heḏi nää-á hä̖ä̖wí koegîˀ wänbo wíḏínphaḏepí. ");
INSERT INTO tew_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Heḏi diha̖hsêndibo inbíˀpiye dovâypunjôndá, wáy pꞌóegébo ha̖a̖ḏi dikaanú-í, wáy wên kayi̖ˀdi diˀä̖ä̖ḏi.” ");
INSERT INTO tew_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iví khä̖geˀnindi óetsikaˀyan, “Wä̖́hä̖̂ä̖-an nä́ä ahkon deeḏi wí koegîˀ âyhóení, nä́ˀin tꞌowa âyhúujôeníḏí?” ");
INSERT INTO tew_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus-di ovâytsikaˀyan, “Hä̖́yú̖ pává-an bînmáa?” Ditú̖, “Tsé ihay.” ");
INSERT INTO tew_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesus-di in tꞌowa ovâytu̖ˀan ee nange dívíkwꞌôení gin. Heḏáháˀ iˀ pává ihógiḏi ikú̖ˀdaaˀan, heḏi iháveḏi iví khä̖geˀnin ovâyˀan in tꞌowa ovâyphaaḏé-íḏí, heḏi han dívíˀan. ");
INSERT INTO tew_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wên hä̖́yú̖ paˀây wáˀ in khä̖geˀnin dâymáa, heḏi Jesus ikú̖ˀdaaˀandi in khä̖geˀnin ovâytu̖ˀan dâyphaaḏé-íˀin. ");
INSERT INTO tew_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","In tꞌowa dívíhú̖u̖yandi híwó dívíshu̖ˀan, heḏi in khä̖geˀnin tsé ihay tꞌún pꞌéeḏí iˀ dínphaḏeˀiˀ koegîˀ dâywéˀgeˀan. ");
INSERT INTO tew_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nä́ˀin tꞌowa dívíhú̖u̖yannin maḏi jónu maapaasôn (4,000) ihay dijiˀ. ");
INSERT INTO tew_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Heḏi Jesus-di in tꞌowa ovâypunjôndi wesebo iˀ kophé iwe itógi iví khä̖geˀnindáḏí, heḏi Dalmanutha nangepiye dimää. ");
INSERT INTO tew_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","In Pharisee tꞌowa diˀä̖ä̖ heḏi Jesus óetu̖hä́nmáa. Óedaˀmáa wên taa makówáḏí ovâykeeya̖míḏí, gá óetayi̖ˀníˀin didaˀḏân. ");
INSERT INTO tew_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus kaygi ihâ̖a̖ˀandi ovâytu̖ˀan, “Háaḏan un nääwin tꞌowa wên taa bînmúuníˀin ídaˀ? Taˀgendi wâytu̖máa, un tꞌowa wí hä̖ä̖wí haˀwâagiˀi-á wíwâykeekankhâymáapí.” ");
INSERT INTO tew_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Heḏi ovâyjoeˀandi wíyá iví kophé iwe itógi, heḏi iwáybun oe wáyhánäpiyebá. ");
INSERT INTO tew_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesus-ví khä̖geˀnin dínˀóḏe dâypáváhûuwíḏí — wí wêe páváḏa̖ˀ iˀ kophé iwe indáḏí dâymaa. ");
INSERT INTO tew_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iˀḏi ovâytu̖ˀan, “Bíˀá̖yîngiˀan hä̖ˀin Pharisee-ví oewáaseeḏi, heḏá Herod-vîˀḏá.” ");
INSERT INTO tew_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Heḏi in khä̖geˀnin wíˀnä́ táye dívítu̖ˀan, “Háaḏan gin natú̖? Gá maḏi wíˀâypávámaapíḏân.” ");
INSERT INTO tew_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Háa ditû̖ˀnin Jesus ûnhanginpóe, heḏi ovâytsikaˀyan, “Háaḏan ítû̖ˀ wívînpávámaapíˀin? Ti háa otundaˀin waˀḏi wíˀúnhanginpoeˀopíˀan, heḏiháa waˀ wíˀíkaˀpóyaˀpíˀan? Ti íkaˀpowakâymuu? ");
INSERT INTO tew_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ítséemuu, heḏi háaḏan handi wíˀúnkeetꞌóepí? Heḏá íˀojemuu, heḏi háaḏan handi wíˀítꞌoeˀopí? ");
INSERT INTO tew_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ti wíˀúnˀánshaapíˀan háa dáyˀannin? Nä́ˀi pꞌánú pává in pꞌánú maapaasôn (5,000) tꞌowagîˀ dovâyháve ihayḏi, hä̖́yú̖ tꞌúnnan iˀ dínphaḏeˀi koegîˀ bînwéˀgeˀan?” Óetu̖ˀan, “Tä̖ˀḏi wíje (12) ihay.” ");
INSERT INTO tew_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Heḏá tsé ihay pává in jónu maapaasôngîˀ-á (4,000) dovâyháve ihayḏi, hä̖́yú̖ tꞌúnnan iˀ dínphaḏeˀi koegîˀ bînwêˀgeˀan?” Ditú̖, “Tsé ihay.” ");
INSERT INTO tew_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Heḏi ovâytu̖ˀan, “Heḏi háaḏan waˀḏi wíˀíkaˀpóyaˀpí iˀ oewáasee i̖ˀgeḏi wâytu̖ˀandi?” ");
INSERT INTO tew_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Oe Bethsaida búˀay dipówá, heḏi wên tꞌowaḏi wí sen tsíˀtꞌaaˀi namuuˀi Jesus-víˀwe óekán. Pín taˀgeḏi indi Jesus óedaaˀan nä́ˀi tsíˀtꞌaaˀiˀ óetä̖ä̖gé-íḏí ônhehkháaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus-di iˀ tsíˀtꞌaaˀiˀ óepahkêˀ, heḏi oe búˀḏí jáˀwépiye óepahoˀḏi tsée eeḏi wí sóˀpꞌoeḏi óeˀä̖yu̖, heḏá iví mandá óetä̖geḏi óetsikaˀyan, “Ti hä̖ä̖wí úkeepoeˀo?” ");
INSERT INTO tew_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iˀ tsíˀtꞌaaˀiˀ ipu̖wä̖béeḏí natú̖, “Tꞌowa dijiḏi dovâymúndeˀ, hewänbo hä̖ä̖wí wí tay waagibá díncha̖a̖.” ");
INSERT INTO tew_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Heḏi wíyá iˀ senbí tsée Jesus-di ôntä̖ge. Nää-á iˀ tsíˀtꞌaaˀi hânho ipu̖wä̖khä̖ä̖ḏi nawówa, heḏi wesebo hä̖ä̖ tꞌä̖hkí keeˀeeḏi ûnkeepóe. ");
INSERT INTO tew_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Heḏi Jesus-di iˀ sen ivíˀpiye óepunjôndi óetu̖ˀan, “Hä̖ä̖ búˀ wíˀunwáytsꞌú̖u̖nípí.” ");
INSERT INTO tew_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus iví khä̖geˀnindáḏí iˀ búˀây eeje Caesarea Philippi búˀ tsowa eejepiye namää. Dimän dihayḏi iví khä̖geˀnin itsikaˀyan, “To-an naa omuu gân nä́ˀin tꞌowa ditû̖ˀ?” ");
INSERT INTO tew_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Óetu̖ˀan, “Wên ditû̖ˀ John iˀ pꞌóˀpꞌoekandi-ân unmuu. Wây-a wêndá ditû̖ˀ Elijah-ân unmuu, heḏá waˀḏi wáyjé wêndá ditû̖ˀ wí Jôesi Táḏáví tukheˀmin diweḏiˀi-ân unmuu.” ");
INSERT INTO tew_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Heḏi ovâytsikaˀyan, “Heḏi undá, to-á naa-á omuu gân íˀándeˀ?” Peter-di óetu̖ˀan, “Gá iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, i-ân unmuu.” ");
INSERT INTO tew_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Heḏi kaygindi ovâykhâ̖a̖kꞌûˀ wíyá toˀwí wänbo wíḏâyhanginˀânnamípíḏí toˀwí namuuˀin. ");
INSERT INTO tew_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Heḏi ihayḏi háa ûnpuwagíˀo i̖ˀgeḏi ovâyhéeˀandi ovâytu̖ˀan, “Nä́ˀin nakhâyˀä̖ˀ napúuwíˀin: Naa, tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi báyékí dontꞌôephaḏekhâymáa, heḏi in Huḏíyo tsonninḏáḏí in owhaˀ pꞌóˀḏéḏíˀindáḏí heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindáḏí wéˀge naa díjoegikhâymáaḏá wíḏísígíkaykhâymáapí. Díkheˀkhâymáa, hewänbo poje thaa iwe owáywówápuwagíˀo.” ");
INSERT INTO tew_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nä́ˀi hä̖ä̖wí thayˀeeḏi ovâytu̖ˀan, heḏi Peter-di óehângeˀandi óetu̖ˀan, “Haˀwâa wíˀuntú̖u̖nípí.” ");
INSERT INTO tew_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus ibéeḏí in wéˀgen khä̖geˀnin ovâymúndeˀ, heḏi Peter óetꞌeˀyandi óetu̖ˀan, “Satan, Penísendiˀ, navíˀweḏi óha̖ḏi. U̖-á tꞌowa waabá biˀánshaamáa, Jôesi Táḏá iˀánshaaˀo waagá joe.” ");
INSERT INTO tew_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Heḏáháˀ iví khä̖geˀnindá in wéˀgen tꞌowa tꞌä̖hká ovâywéˀgeˀandi ovâytu̖ˀan, “Toˀwên naa-áḏí dikä̖ˀä̖ä̖daˀindá wíḏínkhâyˀä̖hpí háa diwänpidaˀ waa dívíˀa̖míˀin, hewänbo inbí phéˀwin dâyhûuwí, heḏá naa-á díyu̖u̖hûuwí. ");
INSERT INTO tew_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Toˀwên inbí wówátsi dâywänpiˀaywoeníˀin didaˀindá inbí wówátsi dipeḏeegíˀo. Hewänbo toˀwên inbí wówátsi naagîˀ heḏá Jôesi Táḏáví híwóˀdi tungîˀ-á dívímä́giˀin, indá inbí wówátsi ditꞌanpúuwí. ");
INSERT INTO tew_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tobá wí toˀwí hä̖ä̖wí tꞌä̖hkí nä́ä oepáa kꞌayḏi nakwꞌóˀdi ihógi wänboˀ, wéˀinnan wên híwó óekhâymáa iví wówátsi iwáyhoˀḏi? ");
INSERT INTO tew_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Wí toˀwí wíˀûnkoḏipí hä̖ä̖wí wänbo imä̂äníḏí iví wówátsi nawáytꞌanpúuwíḏí. ");
INSERT INTO tew_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","In nääwin tꞌowa tꞌaywóhkannin dimuuˀin Jôesi Táḏá dâyjoegiˀan, wí kwee iví sen ijoegiˀan wíyá piˀwíví sendáḏí ithaayé-íḏí waagibá. Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi nä́ä oepáa kꞌayḏipiye owáyˀä̖ˀ, naví Táḏáví saˀwóˀdi kohthay wóegé heḏá in yä̖ˀḏâaˀin makówáwin tꞌôepa̖ˀa̖a̖ˀin wóegá oˀä̖ˀ. Heḏi toˀwên nää naa díwôedaˀin heḏá naví há̖hkandá dînwôedaˀindá, naaḏi wáˀ dovâywôedaˀkhâymáa owáy iˀ thaa owáyˀä̖ˀi napówá ihayḏi. ");
INSERT INTO tew_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","“Taˀgendi wâytu̖máa, Jôesi Táḏáḏí iví kay ûnmuuˀin wovâykeeya̖mí heḏi bînpu̖wä̖khâymáa naa tsondi omuuˀin. Nä́ˀin napúuwí waˀḏi wáy wên nä́we íjiˀin íhánpíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sí thaa naphaḏe ihayḏi Jesus-di Peter-á James-á John-dá i-áḏí ovâyhoˀ, heḏi wên pꞌin tu̖wä̖ˀin kwꞌáyepiye wíˀbo dimää, heḏi inbí páaḏépiye Jesus háa ûncha̖a̖ˀin ûnˀegópóe. ");
INSERT INTO tew_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iví aa hânho tsꞌä̖ˀi ûnˀotsꞌápóe, tóebo háˀto iˀ aa ihay tsꞌä̖ˀi iˀowêeḏi-í. ");
INSERT INTO tew_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Heḏi Moses-áḏí Elijah-áḏí tsíkhagipí dakeepóe, heḏi Jesus-áḏí dänhíˀmáa. ");
INSERT INTO tew_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter-di Jesus óetu̖ˀan, “Há̖hkandiˀ, híwó namuu nä́we gikwꞌôndi. Jaho poje óhkhun tewháˀây âykꞌwôení, wêe u̖ˀgîˀ, wíyá Moses-gîˀ-á, heḏá wíyá Elijah-gîˀ-á.” ");
INSERT INTO tew_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Moses-áḏí Elijah-áḏí dakeepóeḏí in khä̖geˀnin hânho ovâypíhä̖ä̖, heḏânho haˀwâa Peter natú̖, gá háa natú̖u̖níˀin wíˀûnhanginnáhpíḏân. ");
INSERT INTO tew_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Heḏi wí okhúwá napówáḏí ovâyˀóhkhunnan, heḏi nä́ˀin tun okhúwá jâaḏiḏi napee: “Nä́ˀi-ân naví ay dînmuu donsígíˀiˀ. Iˀ bîntꞌôeyaaní.” ");
INSERT INTO tew_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wesebo i̖ˀge tꞌä̖hkí dívíbée, hewänbo Jesus-da̖ˀmân dâymûˀ, wíyá hä̖ä̖wí wänbo-ájoe. ");
INSERT INTO tew_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Oe pꞌin kwꞌáyeḏi diwha̖veˀä̖ˀ ihayḏi Jesus-di ovâytu̖ˀan, “Toˀwí wänbo hä̖ä̖wí bînmûˀin wívîntꞌôeˀa̖mípí, owáy naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ ochuuḏi wíyá owáywówápóe píhay.” ");
INSERT INTO tew_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iví tun ônˀaˀgin, hewänbo wíˀnä́ táye dívítsikaˀyan, “Hânnan namuu nä́ˀin tun, wíyá nawáywówápúuwí i̖ˀgeḏi?” ");
INSERT INTO tew_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Heḏi Jesus óetu̖ˀan, “In Huḏíyoví khuu dâyhá̖ˀoˀin ditû̖ˀ, iˀ toˀwí Jôesi Táaḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí naˀä̖ä̖píḏíboˀ Elijah-á napowagíˀo. Háaḏan haˀwâa ditû̖ˀ?” ");
INSERT INTO tew_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus-di ovâytu̖ˀan, “Taˀgendi Elijah páaḏébo naˀä̖ä̖-íˀin nakhâyˀä̖ˀ-ákun, hä̖ä̖wí tꞌä̖hkí ikhâyˀa̖míḏí. Heḏi hânnan nataˀmuu naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiví̖ˀgeḏi? Gá ginnân: Báyékí dontꞌôephaḏekhâymáa, heḏá tꞌowaḏá díjoegikhâymáa. ");
INSERT INTO tew_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Hewänbo naaḏi wâytu̖máa, Elijah ho naˀä̖ä̖-ákun, heḏi híwóhpí óeˀan in tꞌowaḏi háa didaˀ waagi. Jôesi Táḏáví taˀnin diwe iví̖ˀgeḏi ûntaˀmuu háa óekhâymáaˀin.” ");
INSERT INTO tew_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesus-ví wéˀgen khä̖geˀnin dijiˀ iwe tsowa dipówá, heḏi báyékí tꞌowa bûukꞌúwákí diwindi dâymûˀ. Wên Huḏíyoví khuu dâyhá̖ˀoˀindá heḏá in khä̖geˀnindá dívítu̖hä́nmáa. ");
INSERT INTO tew_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","In tꞌowaḏi Jesus óemûˀḏi ovâyháaˀan, heḏi ivíˀpiye dívíˀä̖ä̖ óesengitu̖ˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus-di ovâytsikaˀyan, “Háaḏan úvítu̖hä́nmáa?” ");
INSERT INTO tew_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nä́ˀin tꞌowa jâageḏi wí sendi óetu̖ˀan, “Há̖hkandiˀ, naví eˀnú wînmaa, i-á wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáaḏí wíˀûnhíˀkoḏipí. ");
INSERT INTO tew_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Heḏi hä̖̂ä̖ḏi wänbo nä́ˀi pꞌoewa̖a̖hâ̖a̖ itꞌôeˀandi iˀ eˀnú oe nangepiye óekanundeˀ, heḏi iˀ eˀnú-á nasóˀokhópeeˀiḏá iwä̖pútsꞌîndoˀ, heḏá ta̖a̖suugiˀbo-á napoeˀo. Uví khä̖geˀnin dovâydaaˀan nä́ˀi pꞌoewa̖a̖hâ̖a̖ ônkhehpeeyé-íḏí, hewänbo wíḏínkoḏipí.” ");
INSERT INTO tew_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus-di ovâytu̖ˀan, “Un tꞌowa-á wä̖yu̖píˀin ímuu. Hä̖̂ä̖ḏi puwahay-an undáḏí oyê̖e̖ní úvíwä̖ä̖yú̖-íḏí, hä̖̂ä̖ḏi puwahay-an undáḏí dáyyä̖́ä̖ˀa̖mí? Jaˀ iˀ enúkáy navíˀpiye binmáˀ.” ");
INSERT INTO tew_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Heḏi óemaaḏi iˀ pꞌoewa̖a̖hâ̖a̖ḏi Jesus óemûˀḏibo nä́ˀi enúkáy óetha̖tha̖kannan, heḏi iˀ eˀnú nakanuḏi ijánúmáa, heḏá nasóˀokhópeeˀi. ");
INSERT INTO tew_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus-di iˀ enúkáyví táḏá óetsikaˀyan, “Hä̖̂ä̖ḏi waabo-an gin ûnpoeˀo?” Iˀ táḏáḏí óetu̖ˀan, “Gá hí̖yä̖̂ä̖ˀi namuuḏibo-ân. ");
INSERT INTO tew_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Heḏá hä̖́yä́n wänbo iˀ pꞌoewa̖a̖hâ̖a̖ḏi phaa iwe heḏá pꞌoe eewá óechä̖nundeˀ óeháyjíḏí. Úkoḏiḏáho nanbíˀpiye dísehkanäˀan, háawin wên wänbo wên khä̖geˀ díˀan.” ");
INSERT INTO tew_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus-di óetu̖ˀan, “Háaḏan dítu̖máa, ‘Úkoḏiḏáhoˀ?’ Toˀwí iwä̖yundeˀi-á ûnkoḏi hä̖ä̖wí namûuge iˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wesebo nä́ˀi enúkáyví táḏá kaygindi natú̖, “Naa dáywä̖yundeˀ, díkhä̖geˀnan wíyá shánkí dáywä̖ä̖yú̖-íḏí.” ");
INSERT INTO tew_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus-di wây-á báyékí tꞌowa a̖ˀyu̖u̖gi dívíkha̖ḏimáˀḏí ovâymûˀ, heḏi wesebo nä́ˀi yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ óetꞌeˀyandi óetu̖ˀan, “U̖ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖, u̖ˀḏi tꞌowa ovâyˀojetꞌaaˀoˀiˀ, tunpíˀindá ovâypaˀiˀ, naaḏi wítu̖máa, nä́ˀi enúkáyvíˀweḏi ópeeve, heḏi wíyá wíˀuntsꞌú̖u̖nípí.” ");
INSERT INTO tew_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iˀ pꞌoewa̖a̖hâ̖a̖ itu̖wí̖núḏí nä́ˀi enúkáy óekanuḏi hânho óetha̖tha̖kannan, heḏáháˀ ivíˀweḏi ûnpee. Iˀ enúkáy wí pení waabá ûncha̖a̖, heḏiho in tꞌowaḏi óemûˀḏi ditú̖, “I-áho nachuu.” ");
INSERT INTO tew_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Hewänbo Jesus-di iˀ enúkáyví man ônyâ̖ˀḏi óekwi̖nukhä̖geˀnandi iwí̖nú. ");
INSERT INTO tew_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Heḏi Jesus wí tewhá ee natsꞌú̖, heḏi iví khä̖geˀnindi wíˀbo óetsikaˀyan, “Háaḏan naˀin wígínkoḏipí iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ âykhehpeeyé-íḏí?” ");
INSERT INTO tew_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus-di ovâytu̖ˀan, “Úvíjûusuˀoḏiḏa̖ˀmân únkoeḏí-í wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ giˀbibá bînkhehpeeyé-íḏí.” ");
INSERT INTO tew_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesus-áḏí iví khä̖geˀnindáḏí iweḏi dimää heḏi Galilee nange i̖ˀge diphaḏe. Jesus wínadaˀpí toˀwí wänbo ûnhanginpúuwíˀin wä̖́hä̖̂ä̖ najiˀin, gá dimändibo iví khä̖geˀnin ovâyhá̖hkanhondân. ");
INSERT INTO tew_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ovâytu̖máa, “Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi wây-á tꞌowaví mangepiye díkáaní. Indáho díkheˀkhâymáa, hewänbo poje thaa iwá wíyá owáywówápuwagíˀo.” ");
INSERT INTO tew_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","In khä̖geˀnin nä́ˀi hä̖ä̖wí Jesus-di ovâytu̖máaˀi wíḏikaˀpóyaˀpí, hewänbo diwôedaˀ óetsikaˀyâ̖a̖míḏí i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum búˀay dipówá, heḏi wí tewhá ee ditsꞌú̖. Jesus-di in khä̖geˀnin ovâytsikaˀyan, “Oe pꞌóegé giˀä̖ḏi hä̖ä̖ i̖ˀgeḏan úvítu̖hä́nmáa?” ");
INSERT INTO tew_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Indá hânda̖ˀ dikꞌwó, gá oe pꞌóegé dijiḏi wéˀi-angú in diweḏi iˀ shánkí hayˀi namuu i̖ˀgeḏi dívítu̖hä́nmáˀḏân. ");
INSERT INTO tew_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus isóge, heḏi nä́ˀin tä̖ˀḏi wíje (12) khä̖geˀnin ovâywéˀgeˀandi ovâytu̖ˀan, “Toˀwí iˀ pꞌóˀḏéḏîˀ namúuníˀin nadaˀḏá, i-á ûnkhâyˀä̖ˀ tíˀúugéˀi namúuníˀin, heḏá tꞌä̖hkíví khä̖geˀdi-á.” ");
INSERT INTO tew_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Heḏi Jesus-di wí ay óepahkêˀḏi inbí páaḏépiye óehoˀ, heḏáháˀ nä́ˀi ay óebaˀaaˀandi ovâytu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Toˀwíḏí naa dídaˀḏi wí ay nä́ˀi ay waabá óesígíkéndeḏi, naa wáˀ dísígíkénde waabá iˀoˀ. Heḏi toˀwí naa dísígíkéndeˀiˀḏá naaḏa̖ˀbá wíḏísígíkéndepí, hewänbo iˀ toˀwí naa dísandiˀ wáˀ óesígíkéndeˀ.” ");
INSERT INTO tew_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John-di óetu̖ˀan, “Há̖hkandiˀ, tóewí sen âymûˀ yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpiyendeḏi uví khá̖wä̖́ natû̖ˀdi, heḏi âytu̖ˀan han wíˀiˀa̖mípíˀin, naˀin diweḏiˀi wínamuupíḏí.” ");
INSERT INTO tew_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Hewänbo Jesus natú̖, “Toˀwí giˀbi wívînkhâ̖a̖ˀa̖mípí. Toˀwí namuuˀi naví khá̖wä̖́ natû̖ˀdi ipínnántꞌôeˀandi-á wesebo híwóhpí naví̖ˀgeḏi wíˀihéeˀa̖mípí. ");
INSERT INTO tew_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Toˀwí nanbíˀpiye háa wínacha̖a̖pîˀ-á nanbíˀnäpiyebá napoeˀo. ");
INSERT INTO tew_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taˀgendi wâytu̖máa, toˀwí wí pꞌoe wänbo wovâysu̖wä̖jôndi, navíˀin ímuuˀin ûnhanginnândi, i-á Jôesi Táḏáḏí óewáˀâakhâymáa.” ");
INSERT INTO tew_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Heḏi toˀwíḏí wêe wänbo nä́ˀin hí̖ˀínnin navíˀpiye dívíwä̖yundeˀin diweḏi óetꞌaywóhá̖ˀandá, shánkí híwó iˀ toˀwí ûnpúuwíwän waˀḏi han óehá̖ˀanpíḏíbo wí kꞌuu kháaˀi iví kꞌáy eeḏi ônwhisôege-íˀin heḏi mâapꞌoe iwe óechä̖ä̖nú-íˀin. ");
INSERT INTO tew_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Heḏi wéhpêe mandi úvítꞌaywóˀdoḏá, shánkí híwó namuu bîntsꞌâa-íˀin, wíyá indi úvítꞌaywóˀnâamívíˀweḏi. Tobá wéhpêeḏa̖ˀ ímanmuu wänboˀ, shánkí híwó namuu wówátsi nahándepíˀin bînkáyjíḏí, péyégépiye ímú-ívíˀweḏi wíˀgín ímanmuuḏi. ");
INSERT INTO tew_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Oe péyégá tꞌowa hä̂nhay wänbo tꞌä̖hkí dâytꞌôephaḏekhâymáa, heḏá iˀ phaa hä̂nhay wänbo napa̖a̖ˀa̖pîˀḏá ovâyphahkha̖nukhâymáa. ");
INSERT INTO tew_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Heḏi wéhpêe ândi in taˀgeˀin pꞌóegéḏí wovâyhângeˀoḏá, shánkí híwó namuu bîntsꞌâa-íˀin wíyá indi úvítꞌaywóˀnâamívíˀweḏi. Tobá wéhpêeḏa̖ˀ íˀânmuu wänboˀ, shánkí híwó namuu wówátsi nahándepíˀin bînkáyjíḏí, péyégépiye wovâychä̖ä̖nú-ívíˀweḏi wíˀgín íˀânmuuḏi. ");
INSERT INTO tew_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Oe péyégá tꞌowa hä̂nhay wänbo tꞌä̖hkí dâytꞌôephaḏekhâymáa, heḏá iˀ phaa hä̂nhay wänbo napa̖a̖ˀa̖pîˀḏá ovâyphahkha̖nukhâymáa. ");
INSERT INTO tew_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Heḏi wéhpêe tséeḏí híwóhpí hä̖ä̖wí wovâypu̖wä̖ˀoḏá, shánkí híwó namuu bînwhahkáyjíˀin, wíyá indi úvítꞌaywóˀnâamívíˀweḏi. Tobá wéhpêeḏa̖ˀ ítséemuu wänboˀ, shánkí híwó namuu oe makówápiye ímú-íḏí, péyégépiye wovâychä̖ä̖nú-ívíˀweḏi wíˀgín ítséemuuḏi. ");
INSERT INTO tew_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Oe péyégá tꞌowa hä̂nhay wänbo tꞌä̖hkí dâytꞌôephaḏekhâymáa, heḏá iˀ phaa hä̂nhay wänbo napa̖a̖ˀa̖pîˀḏá ovâyphahkha̖nukhâymáa. ");
INSERT INTO tew_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Toˀwên tꞌä̖hkí phaaḏi ovâyˀa̖a̖yä̖ä̖khâymáa. ");
INSERT INTO tew_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A̖a̖yä̖ä̖ híwóˀdi namuu, hewänbo iˀ a̖a̖yä̖ä̖ naˀá̖hhándáhoˀ, háˀto wíyá á̖hsä̖ä̖ˀi napúuwí. Undá únkhâyˀä̖ˀ a̖a̖yä̖ä̖ naˀá̖hhándepîˀ waaginbá ímúuníˀin, heḏi tsa̖a̖ginpíḏíbo wéˀge ítháaní.” ");
INSERT INTO tew_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus iweḏi ijâaˀan, heḏi Judea nangepiye namääḏi Jordan pꞌoˀ pꞌä̖́näpiye naphaḏe. Iwe wây-á báyékí tꞌowa iví núˀ dívíwéˀgeˀan, heḏi hä̖̂ä̖ḏi waa iˀan waagi in wáˀ ovâyhá̖ˀan. ");
INSERT INTO tew_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Heḏi wên Pharisee tꞌowa ûnpówáḏí óetsikaˀyan, “Ti híwó namuu wí sen nakhóhtsa̖a̖ˀä́ndiˀ iví kweevíˀweḏi ithaaweejé-íḏí? Hân iˀ tsontun natû̖ˀ?” Gin ditú̖ Jesus óetayi̖ˀníḏí, tigúba híwóhpí natu̖hpee-í. ");
INSERT INTO tew_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus-di ovâytsikaˀyan, “Hân Moses-di wovâyjôn?” ");
INSERT INTO tew_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Indi óetu̖ˀan, “Moses-di nä́ˀin tun dînjoeˀan: Wí sen wên khóhtsa̖a̖wije taˀnin itaˀnamí heḏi handiḏi iví kwee ijoeˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus-di ovâytu̖ˀan, “Hewänbo Moses-di haˀwâagi wovâytaˀkꞌûˀ gá tꞌôeyanpíˀin ímuuḏân, unbí kwiyä̖ˀ bînwänpijoekanmáaḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hewänbo oe tsꞌanpáaḏé nanân diwe Jôesi Táḏáḏí sendáḏí kwee-áḏí ovä̂nkhíjé. ");
INSERT INTO tew_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Heḏi natú̖ wí sen ikhóˀyâ̖ˀḏáhoˀ, iví táḏá-á iví jíyá-á ijoeˀa̖míˀin ûnkhâyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Heḏiho iˀ sendá iˀ kwee-á wêe tûu ûnpꞌoeḏa̖ˀ dapoeˀo, heḏiho wíje wíḏamuupí, wêeḏa̖ˀ damuu. ");
INSERT INTO tew_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Heḏânho in toˀwên Jôesi Táḏáḏí ovä̂nwónnindá toˀwí wänbo wíˀûnkhâyˀä̖hpí ovä̂nweejé-íˀin.” ");
INSERT INTO tew_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iˀ tewhá ee diwáytsꞌûndi iví khä̖geˀnindi nä́ˀi híˀ i̖ˀgeḏi óetsikaˀyan. ");
INSERT INTO tew_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Heḏi ovâytu̖ˀan, “Wí sen iví kwee ijoeˀandi wíyá kwee-áḏí ikhóˀyâ̖ˀḏá, iví kweevíˀpiye tꞌaywó iˀoˀ. ");
INSERT INTO tew_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iˀ kwee wáˀ, iví sen ijoeˀandi wíyá sendáḏí ikhóˀyâ̖ˀḏá, iví senbíˀpiye tꞌaywó iˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wên tꞌowa inbí áyyä̖̂ä̖ Jesus-víˀwe dâykán iˀḏi ovâytä̖ä̖gé-íḏí, heḏi iví khä̖geˀnindi in tꞌowa ovâytꞌeˀyandi ovâytu̖ˀan haˀwâa wíḏívíˀa̖mípí. ");
INSERT INTO tew_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Heḏi Jesus-di in khä̖geˀnin háa dívíˀoˀin ovâymûˀḏi inbíˀpiye híhchan wínacha̖a̖pí, heḏi ovâytu̖ˀan, “In hí̖ˀínnin áyyä̖̂ä̖ navíˀpiye binkä̖ˀä̖ä̖mä́ä, wívînkhâ̖a̖ˀa̖mípí, gá toˀwên nä́ˀin áyyä̖̂ä̖ waaginbá dimuuˀindá Jôesi Táḏávíˀin ûmuuḏân. ");
INSERT INTO tew_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Taˀgendi wâytu̖máa, toˀwí wänbo Jôesi Táḏávîˀ wínapúuwípí wí hínchä̖̂ä̖ˀiˀ ay waagibá iwä̖yu̖píḏí.” ");
INSERT INTO tew_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Heḏáháˀ in áyyä̖̂ä̖ ovâybaˀaahógiḏi wíˀínbo ovâytä̖geḏi ingîˀ ovâyjûusuˀan. ");
INSERT INTO tew_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pꞌóegé wíyá Jesus natsꞌanmän dihayḏi wí sen ivíˀweä̖ä̖ navíˀpiye binkä̖ˀä̖ä̖piye iˀä̖ä̖kán, heḏi idégeˀdisógeḏi óetu̖ˀan, “Híwóˀdi há̖hkandiˀ, hân dáyˀa̖mí heḏânho in wówátsi nahándepíˀin donkáyjíḏí?” ");
INSERT INTO tew_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus-di óetsikaˀyan, “Háaḏan naa híwóˀdi gin dítu̖ˀoˀ? Jôesi Táḏáḏa̖ˀmân híwóˀdi namuu, wíyá toˀwí-á joe. ");
INSERT INTO tew_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jôesi Táḏáví tsontun ho mântaa. I-á natú̖ wívîntꞌowatꞌahá̖a̖nú-ípí, wíyá toˀwíví kwee-áḏí háa sendáḏí wíˀúvíwhohkwomáˀve-ípí, wíˀúvísä̖ˀmamípí, tꞌowaví̖ˀgeḏi wíˀúvíhójoˀa̖mípí, hójo waagiḏibo tꞌowaví hä̖ä̖wí wívînhóenípí, unbí táḏá-á jíyá-á bînˀaˀginmáˀve-í.” ");
INSERT INTO tew_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Óetu̖ˀan iˀ sendi, “Há̖hkandiˀ, naa enúkáy omuuḏiboˀ tꞌä̖hkí nä́ˀi tsontun dóˀaˀgin.” ");
INSERT INTO tew_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus-di sígíḏí taˀgebo óemúndeḏi óetu̖ˀan, “Waˀḏi wây-á háawên útáy biˀa̖míˀin. Jaho ópûn, hä̖ä̖wí úkwꞌóˀdi tꞌä̖hkí mänku̖ˀchꞌâaní, heḏi iˀ chä̖ˀ mänhógiˀiˀ in tꞌowa sehkanäwó diwówájiˀin ovâymä̂äní, heḏânho oe makówá koḏitꞌowa unmúuníḏí. Heḏi nâaku̖ˀchꞌáaḏá ovâymä́giḏá naa-áḏí ókä̖ˀve.” ");
INSERT INTO tew_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nä́ˀin natꞌoe ihayḏi iˀ sen naboˀaatsꞌaypóe, heḏi iví píˀnä́ khóˀjé ûnkháapóeḏí iweḏi namää, gá báyékí hä̖ä̖wí ûnkwꞌôndân heḏiho wínaku̖chadaˀpí. ");
INSERT INTO tew_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus ipu̖wä̖béemáa, heḏi iví khä̖geˀnin itu̖ˀan, “Báyékí kâyˀin namuu wí toˀwí nakoḏitꞌowamuuˀi háa Jôesi Táḏá natú̖ waa dívíˀa̖míḏí heḏânho ovâyˀaywoeníḏí.” ");
INSERT INTO tew_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nä́ˀi híˀḏí in khä̖geˀnin ovâyháaˀan, hewänbo Jesus-di wíyá ovâytu̖ˀan, “Naví ây, ívíwo nabâapuˀwan wí toˀwí háa Jôesi Táḏá natú̖ waa iˀa̖míḏí heḏânho ônˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nabâapuˀwan wí kamä́yo wên agúusa tsípho i̖ˀge natsꞌú̖u̖níḏí, hewänbo shánkí nabâapuˀwan wí toˀwí koḏitꞌowa namuuˀi háa Jôesi Táḏá natú̖ waa iˀa̖míḏí heḏânho ônˀaywoeníḏí.” ");
INSERT INTO tew_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Näbâa shánkí ovâyháaˀan in khä̖geˀnin, heḏi wíˀnä́ táye dívítsikaˀyan, “Gin namuuḏá to-an ûnkoḏi ûnˀaywondee-íḏí?” ");
INSERT INTO tew_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus-di taˀgebo ovâymúndeḏi ovâytu̖ˀan, “Toˀwí wänbo wíˀbo wíˀûnkoḏipí. Jôesi Táḏáḏa̖ˀmân ûnkoḏi tꞌowa ovâyˀaywoeníḏí. Jôesi Táḏá-á hä̖ä̖wí tꞌä̖hkí ûnkoḏi iˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter-di óetu̖ˀan, “Úhanginná hä̖ä̖wí tꞌä̖hkí âyjoeˀannin u̖-áḏí gimú-íḏí.” ");
INSERT INTO tew_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus-di ovâytu̖ˀan, “Taˀgendi wâytu̖máa, naa omuuḏibo heḏá Jôesi Táḏáví híwóˀdi tun ûnmuuḏibo-á, toˀwí ijoeˀandi iví tewhá, háa iví tíˀûuwindá páˀḏâyindá, háa iví táḏá-á jíyá-á, háa iví ây-á, háa iví nava-á, ");
INSERT INTO tew_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","i-á taˀgendi tä̖gintä̖ (100) maˀkwꞌanukí shánkí ihóení, tewhá-á, tíˀûuwindá páˀḏâyˀindá, jíyáˀindá, ây-á, nava-á — heḏá itꞌôephaḏekhâymáa iví wä̖yu̖ ûnmuuḏi. Tꞌä̖hkí nä́ˀi ihóení waˀ nä́ä oepáa kꞌayḏi nawówájiˀ ihayḏi, heḏá iví wówátsi nä́ä oepáa kꞌayḏi ûnboˀwan dihayḏá wówátsi nahándepíˀindá ikáyjí. ");
INSERT INTO tew_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hewänbo báyékí tꞌowa nää pꞌóˀḏéḏíˀin dimuu waa díncha̖a̖ˀindá tíˀúugéˀin dipúuwí; heḏi báyékí tꞌowa-á nää tíˀúugéˀin dimuu waa díncha̖a̖ˀindá pꞌóˀḏéḏíˀindá dipúuwí.” ");
INSERT INTO tew_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","In pꞌóegé dimän Jerusalem búˀpiye, heḏi iví khä̖geˀninbí páaḏé Jesus namän. In khä̖geˀnindá wíḏínhanginnáhpí háa dívíˀánshaaˀa̖míˀin, heḏá in wéˀgen tꞌowa iví tíˀúugé dimännindá dikhunwôedaˀ. In tä̖ˀḏi wíje khä̖geˀnin ivíˀpiye wíyá ovâyhângeˀan, heḏi háa ûnpúwágíˀoˀin ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Natú̖, “Bítꞌôeyan, nää-á Jerusalem-piye gimän, heḏi naa, tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀiˀ tꞌowaḏi díkáaní in owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá inbí mange. Indáho ditú̖u̖ní naa dînkhâyˀä̖ˀ ochuu-íˀin, heḏá in Huḏíyo dimuupíˀin tꞌowaví mangá díkáaní. ");
INSERT INTO tew_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nä́ˀindi dînpꞌáhkaakhâymáa, heḏá díˀohphaykhâymáa. Púwhí̖ˀdí díwhä̖ḏikhâymáa, heḏá díkheˀkhâymáa. Hewänbo poje thaa iwe owáywówápúuwí.” ");
INSERT INTO tew_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ihayḏibá James-áḏí John-dáḏí Zebedee-ví ây damuuˀin Jesus-víˀpiye damää, heḏi óetu̖ˀan, “Há̖hkandiˀ, naˀin hä̖ä̖wí gadapúuwí heḏi u̖ˀḏi dînˀa̖míˀin gadaˀ.” ");
INSERT INTO tew_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ovä̂ntsikaˀyan, “Hä̖ä̖-an dadaˀ wä̂nˀa̖míˀin?” ");
INSERT INTO tew_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Óetu̖ˀan, “Owáy untsondisogeḏee ihayḏi, naˀin uví khóe gamúuníˀin gadaˀ, wêe koˀḏíngéḏí, wêe-á yä̖́ˀmä́ngéḏá.” ");
INSERT INTO tew_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus-di ovä̂ntu̖ˀan, “Undá wíḏä́nhanginnáhpí hä̖ä̖wí dadaˀin. Ti dä́nkoḏi dä̂ntꞌôephaaḏé-íḏí naa dontꞌôephaḏekhâymáa waabá? Heḏi naa hä̖ä̖wí kháaˀi donphaḏekhâymáa waabá, ti dä́nkoḏi dä̂nphaaḏé-íˀin?” ");
INSERT INTO tew_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Óetu̖ˀan, “Gä́nkoḏi-ákun.” Jesus-di ovä̂ntu̖ˀan, “Taˀgendi undá wáˀ dä̂ntꞌôephaḏekhâymáa, heḏá hä̖ä̖wí kháaˀi dä̂nphaḏekhâymáa, naa dînpúuwí waabá. ");
INSERT INTO tew_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Hewänbo naa wíḏînkꞌóepí naví khóe wä̂ndeˀmamíˀin koˀḏíngéḏá yä̖́ˀmä́ngéḏá. Jôesi Táḏáḏa̖ˀmân ûnkꞌóe ovâydeˀmamíḏí toˀwên ha̖ˀmin dimúuníḏí.” ");
INSERT INTO tew_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","In wéˀgen tä̖ khä̖geˀnin James-á John-dá inbí híˀ i̖ˀgeḏi dínhanginpóe ihayḏi inbíˀpiye ditꞌayyaapóe. ");
INSERT INTO tew_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Heḏiho Jesus tꞌä̖hkí iví khä̖geˀnin iwéˀgeˀandi ovâytu̖ˀan, “Únhanginná in Huḏíyo dimuupíˀin tꞌowaví tsonnin hânho ditsontꞌóe, heḏá inbí tꞌowa-á ovâytsonmáˀve-íˀindá diwänpidaˀ. ");
INSERT INTO tew_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Hewänbo undá wíˀúnkhâyˀä̖hpí ha̖ˀmin ímúuníˀin. Toˀwí un diweḏi hayˀi namúuníˀin nadaˀḏá, i-á unbí khä̖geˀdiḏa̖ˀ namúuníˀin ûnkhâyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Heḏi toˀwí pꞌóˀḏéḏîˀ namúuníˀin nadaˀḏá, i-á wí pantꞌôeˀi un tꞌä̖hkígîˀ waagiˀbá namúuníˀin ûnkhâyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Naa wänboˀ, tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi-á oˀä̖ä̖ tꞌowa dovâykhä̖geˀnamíḏí, indi naa díkhä̖geˀnamíḏá joe. Oˀä̖ä̖ ochuu-íḏí, heḏá naví wówátsi-á dáywáˀâa-íḏí tꞌä̖hkí tꞌowa dínkoeḏí-íḏí inbí tꞌaywóˀdi iweḏi dimaˀpꞌä́níḏí.” ");
INSERT INTO tew_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Oe Jericho búˀ Jesus iví khä̖geˀnindáḏí báyékí tꞌowa-áḏí dipówá, heḏi iweḏi dipeemän dihayḏi wí sen tsíˀtꞌaaˀi namuuˀiˀ owáy pꞌôe hángé wáy nahä̖ä̖daˀä́n, i-á Bartimaeus gin nakhá̖wä̖́, Timaeus-ví ay ûnmuuˀiˀ. ");
INSERT INTO tew_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bartimaeus-á natꞌoe Jesus oe Nazareth búˀwi naˀä̖ˀin, heḏi itu̖wí̖nú, “Jesus, u̖ David-ví ây iweḏiˀiˀ unmuuˀiˀ, navíˀpiye ósehkanäpuwave.” ");
INSERT INTO tew_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Báyékí tꞌowaḏi iˀ sen óetꞌeˀyandi óetu̖ˀan, “Hânda̖ˀdiboˀ.” Hewänbo i-á shánkí kaygá itu̖wí̖nú, “U̖ David-ví ây iweḏiˀiˀ unmuuˀiˀ, dísehkanäˀan.” ");
INSERT INTO tew_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus iwóyí̖ˀdí ovâytu̖ˀan, “Bintu̖ˀan naˀä̖ä̖-íḏí.” Indi iˀ tsíˀtꞌaaˀiˀ óetu̖ˀan, “Jesus-di wóetu̖hkánmáa. Ówí̖nú, óhíhchanpuwave.” ");
INSERT INTO tew_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iˀ sen iví kꞌéwéˀin to ipꞌä̖́ḏi, heḏi wesebo iwí̖núḏí Jesus-víˀpiye namää. ");
INSERT INTO tew_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus-di óetsikaˀyan, “Hânnan wînˀa̖míˀinnan undaˀ?” Iˀ sendi óetu̖ˀan, “Gá dînkeepúuwíˀinnân odaˀ, Nanbí sedó.” ");
INSERT INTO tew_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus-di óetu̖ˀan, “Ópûn, uví wä̖yu̖ úmuuḏânkun unwówa.” Heḏi wesebo iˀ sen ûnkeepóeḏí Jesus-áḏí namää. ");
INSERT INTO tew_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesus-á iví khä̖geˀnindáḏí Jerusalem búˀ tsowa dipówá. Iwe wí okú nakꞌóe “Olive Okú” gin dâytu̖ˀoˀ, heḏi nä́ˀi okú iwe núˀ wáy nä́ˀin wíje búˀây daná, Bethpage-áḏí Bethany-áḏí. Heḏi wíje iví khä̖geˀnin ovä̂nsan dapáaḏémú-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ovä̂ntu̖ˀan, “Jaho bápûn hä̖ˀi búˀay nanbí páaḏépiye nanân diwepiye, heḏi datsꞌú̖ˀ dihayḏá wí búduˀay dä̂nshaa-í nawhiwindi, i-á waˀ wáymûu wänbo toˀwí wänbo wíˀiˀíhsógepí. Dä̂nwhisuuḏi dä̂nmáˀí nä́we. ");
INSERT INTO tew_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Heḏi toˀwíḏí wovä̂ntsikaˀyandáhoˀ, ‘Háaḏan haˀwâa dä̂nˀoˀ?’, ginnân dä̂ntu̖ˀa̖mí: ‘Gá Nanbí Sedó iˀ ûntáyḏân, heḏi hây napóeḏíbo wônwáymáˀí.’ ” ");
INSERT INTO tew_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Damääḏi wí búduˀay pꞌôe hángé wên phóḏi núˀ nawhiwindi dä̂nshaa. ");
INSERT INTO tew_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Heḏi dä̂nwhisuuḏeḏi in tꞌowa iwáygé diwinnindi ovä̂ntsikaˀyan, “Hânnan dänˀoˀ? Háaḏan hä̖ˀi búduˀay dä̂nwhisuuḏeˀ?” ");
INSERT INTO tew_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","In khä̖geˀnin háa Jesus-di ovä̂ntu̖ˀan waa datú̖, heḏiho ovä̂nmä́gi. ");
INSERT INTO tew_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Iˀ búduˀay Jesus ônhoˀ, heḏi inbí kꞌéwéˀin to dänpꞌä̖́ḏiḏi iˀ búdu kꞌéwé ônpa̖ˀkꞌûˀ, heḏi Jesus iˀíhsóge. ");
INSERT INTO tew_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Heḏi wáy Jesus óeˀíhon niˀge báyékí tꞌowa inbí kꞌéwéˀi to oe teˀpꞌóegé ônpa̖ˀkwohon, heḏi wây-á wéˀgendá dâytaykhóepa̖ˀkwohon, iˀ nava iwe dâytsꞌâˀiˀ. ");
INSERT INTO tew_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Heḏi in toˀwên páaḏé dimännindá heḏá in tíˀúugé ûnwóeˀä̖ˀindá dívítu̖hkwi̖nuhon, “Wísígíkéndeˀ.” “Nanbí Sedó Jôesi Táḏáḏí wóesan, heḏiho híwó wóeˀâ̖a̖mí.” ");
INSERT INTO tew_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Híwó úpúuwí gá untsondisogeḏee-íḏân, nanbí thehtáy pahpâa David natsondiˀä́n waagibá.” “Jôesi Táḏá oe makówá naˀä́ndi-á hayˀi namuu.” ");
INSERT INTO tew_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Heḏi Jerusalem búˀpiye Jesus namääḏi iˀ méesate hayˀi ee natsꞌú̖, heḏi ibéemáaḏí hä̖ä̖wí tꞌä̖hkí imúndeˀ. Hebo nathíˀêemändibo in tä̖ˀḏi wíje (12) khä̖geˀnindáḏí oe Bethany búˀaypiye namää. ");
INSERT INTO tew_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wíyá tháwä́n Bethany-ḏi dipee, heḏi Jesus naha̖hséhpóe. ");
INSERT INTO tew_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hây kayi̖ˀ diwe wên fig tay nachândi imûˀ nakaamuuḏi. Iwepiye namää imúuníḏí tigúba na-fig-muuˀin, hewänbo iwe napówá ihayḏi fig wänbo wíˀishaapí, waˀḏi na-fig-púuwí ihayḏi wínanáhpíḏí. ");
INSERT INTO tew_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Heḏi Jesus-di in tay óetu̖ˀan, “Uvíˀweḏá toˀwí wänbo wíyá wíˀi-fig-kꞌoˀípí.” Iví khä̖geˀnin háa natú̖ˀin ditꞌoe. ");
INSERT INTO tew_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem búˀpiye wíyá dimää, heḏi Jesus iˀ méesate hayˀi eepiye namää, heḏi in tꞌowa dâyhä̖ä̖wíku̖ˀchꞌáaḏeˀindáḏí in dâyhä̖ä̖wíkumändeˀindáḏí iweḏi ovâykhehpiye, heḏi in dâychä̖ˀegóˀoˀinbí mä́äsa-á heḏá in dâykꞌoˀweeku̖ˀchꞌáaḏeˀinbí púwéḏé-á ovâyjánú. ");
INSERT INTO tew_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Heḏi toˀwí wänbo oe-á nä́ä-á ee méesate íve wíˀovâyphaḏemä́gipí inbí hä̖ä̖wí wóegé. ");
INSERT INTO tew_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Heḏi in tꞌowa ovâyhá̖ˀandi ovâytu̖ˀan, “Jôesi Táḏá iví taˀnin diwe ginnân natú̖hpíˀan: Naví tewhá-á tꞌä̖hkí nangeˀin tꞌowa dívíjûusuˀa̖mígîˀ namuu, hewänbo undá bînˀegóˀandi sänmin dívíkaakwꞌôenígîˀ napóe.” ");
INSERT INTO tew_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","In owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá háa natú̖ˀin ditꞌoe, heḏi iweḏi páaḏépiye háḏíḏí óeháyjíˀin dâytu̖wä̖máa, hewänbo óekhunwôedaˀ, iví híˀḏí in tꞌowa ovâyháaˀoḏi. ");
INSERT INTO tew_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nakin dihayḏi Jesus-á iví khä̖geˀnindáḏí ee búˀḏí dipee. ");
INSERT INTO tew_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Héḏéndí napóe ihayḏi pꞌóegé dimändi in fig tay Jesus-di óehéeˀannindá púˀḏíbo natꞌaaḏi dâymûˀ. ");
INSERT INTO tew_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter háa Jesus natú̖ˀin ûnˀánpówá, heḏi óetu̖ˀan, “Há̖hkandiˀ, in tay untú̖ˀin háˀto híwó napúuwíˀin tꞌä̖hkí natꞌaa.” ");
INSERT INTO tew_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus-di ovâytu̖ˀan, “Bíwä̖́yú̖ Jôesi Táḏá-á hä̖ä̖ tꞌä̖hkí iˀa̖míˀin ûnkoḏi. ");
INSERT INTO tew_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Taˀgendi wâytu̖máa, toˀwí nä́ˀin pꞌin itu̖ˀandi, ‘Ótégé, oe mâapꞌoe iwe ópichä̖́nú,’ heḏi háa natú̖ waa napúuwí gin iwä̖yundeḏá, ônˀa̖mí-ákun. Hewänbo pín taˀgeḏi iwä̖ä̖yú̖-íˀin ûnkhâyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Heḏân wâytu̖máa, úvíjûusuˀandi iˀ hä̖ä̖wí bîndaaˀandi taˀgendi bînhóeníˀin úvíwä̖yundeḏáhoˀ, heḏáho bînhóení-áheˀ. ");
INSERT INTO tew_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Hewänbo hä̖̂ä̖ḏi úvíjûusuˀoˀ ihayḏi, toˀwívíˀpiye híwó wíˀícha̖a̖píḏí, i-á bînˀowóejé-í, heḏânho unbí Táḏá oe makówá naˀä́ndiˀḏi unbí tꞌaywóˀdi wáˀ wovâyˀowóejé-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Heḏi wên tꞌowa bînˀowójépíḏá, Jôesi Táḏá oe makówá naˀä́ndiˀḏi háˀto unbí tꞌaywóˀdi wovâyˀowóejé-í.” ");
INSERT INTO tew_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalem búˀ diwáypówá ihayḏi iˀ méesate hayˀi ee natsꞌú̖. Iwe najiˀ ihayḏi in owhaˀ pꞌóˀḏéḏíˀindá in Huḏíyoví khuu dâyhá̖ˀoˀindá heḏá wây-á in Huḏíyoví tsonnindá ûnpówá. ");
INSERT INTO tew_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Indi óetsikaˀyan, “Háawinnan uví tsonkhuu úmuu háa biˀo waa biˀa̖míḏí? Toˀḏan in taˀgen wônkꞌûˀ nä́ˀi hä̖ä̖wí nâaˀa̖míḏí?” ");
INSERT INTO tew_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus-di ovâytu̖ˀan, “Nää-á naaḏá wáˀ un wéhpêe tsika wâytsikaˀya̖mí, heḏi dítu̖ˀandá, naaḏá wâytu̖ˀâ̖a̖mí toˀwíḏí in taˀgen dînkꞌûˀin nä́ˀi hä̖ä̖wí dóˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Dítu̖ˀan, toˀḏan John ônkꞌûˀ tꞌowa ovâypꞌóˀpꞌoeˀa̖míḏí, ti Jôesi Táḏáḏí háa tꞌowaḏi ônkꞌûˀ?” ");
INSERT INTO tew_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Heḏi wíˀnä́ táye dívítu̖máa, “Jôesi Táḏáḏí John ônkꞌûˀ gin gitú̖ḏáhoˀ, Jesus-di dítsikagíˀo, ‘Heḏi háaḏan handi háa John natú̖ˀin wíˀúvíwä̖yu̖pí?’. ");
INSERT INTO tew_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hewänbo wígitú̖u̖nípí, ‘Tꞌowaḏiḏa̖ˀ ônkꞌûˀ’ gin.” (In tꞌowa dâykhunwôedaˀḏibo haˀwâa ditú̖, gá tꞌä̖hkí in tꞌowa dívíwä̖yundeḏân John-dá Jôesi Táḏáví tukheˀbi ûnmuuˀin.) ");
INSERT INTO tew_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Heḏiho indi Jesus óetu̖ˀan, “Naˀindá wígínhanginnáhpí toˀwíḏí ônkꞌûˀin.” Heḏi Jesus-di ovâytu̖ˀan, “Heḏáhoˀ, naaḏi wänbo wáˀ wíwâytu̖ˀa̖mípí toˀwíḏí in taˀgen dînkꞌûˀin dóˀa̖míḏí nä́ˀi hä̖ä̖wí dóˀoˀiˀ.” ");
INSERT INTO tew_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus-di in tsonnin nä́ˀi há̖hkangíˀin óˀgéḏí ovâytu̖ˀan: “Wí sen iˀúuvaˀáakhä̖hsaa, heḏi iˀ nava iphéˀahkhaayan, iˀ kꞌuu iwá iphoyä̖ä̖ iˀ úuva ipꞌomapꞌee-ígîˀ, heḏi wí tewhá tu̖wä̖ˀi-á ikꞌûˀ iví nava iˀá̖yí̖ˀnamíḏí. Heḏáháˀ iˀ nava wên senäˀ úuva áaphä̖ä̖ á̖yí̖ˀnin dimuuˀin ovâypíyémä́giḏi wíyá piˀwí nangepiye namää. ");
INSERT INTO tew_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Iˀ úuva napꞌeˀyin dihayḏiho wí tꞌôeˀiˀ iˀ nava iwepiye óesan heḏânho in senäˀ dâynavapíyéˀannindi iˀ úuva nayä̖́muˀiˀ óemä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hewänbo indi iˀ tꞌôeˀiˀ óeyâ̖ˀḏi óewhä̖́ḏi, heḏi manda̖ˀdibo óewáybun. ");
INSERT INTO tew_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Heḏi iˀ sendá wíyá tꞌôeˀi-á óesan. Indi i-á pꞌóˀḏá óewhä̖́ḏi, heḏá jänäkí-á óeˀan. ");
INSERT INTO tew_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Heḏá wíyá tꞌôeˀi-á óesandi-á óehay. Heḏá wây-á wên tꞌôeˀindá ovâysan. Wáy wên in ovâywhä̖́ḏi, wây-á wêndá ovâyhá̖nú. ");
INSERT INTO tew_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Heḏi iví ayḏa̖ˀ ûnjoekandee, iˀ isígíˀiˀ. Nä́ˀiho tꞌä̖ˀgeḏiho in dâynavapíyéˀanninbíˀwepiye óesan. Natú̖, ‘Maḏân naví ay-á dînˀaˀgeení.’ ");
INSERT INTO tew_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hewänbo indá wéˀge dívíhéeˀandi ditú̖, ‘Nä́ˀi-ânkun namuu nä́ˀi hä̖ä̖wí tꞌä̖hkí ûnjoepuwagíˀoˀiˀ. Jaho âyháyjí, heḏi nä́ˀi hä̖ä̖wí nayä̖́muˀi-á nanbîˀ-á gínmúuní.’ ");
INSERT INTO tew_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Heḏiho iˀ ay óeyâ̖ˀḏi óehay, heḏi iˀ nava iweḏi óepꞌégi.” ");
INSERT INTO tew_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Heḏi Jesus-di in tꞌowa ovâytsikaˀyan, “Hân nä́ˀi nava ivîˀ ûnmuuˀiˀ iˀa̖mí? Gá namääḏá in senäˀ dâynavapíyéˀannin ovâyhá̖a̖nú-í, ihayḏá iˀ nava-á wây-á toˀwêndá ovâypíyémä̂äní. ");
INSERT INTO tew_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bîntunnanpíˀan nä́ˀi híˀ Jôesi Táḏáví taˀnin diwe nataˀmuuˀiˀ: Iˀ kꞌuu in tewhátehpaaˀin dâyjoegiˀandi-á, nää shánkí natáyˀi kꞌuu tehpaa béˀḏí napóe. ");
INSERT INTO tew_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iˀ shánkí natsonjiˀi gin iˀan, heḏi naˀin âymûˀḏi díháaˀan.” ");
INSERT INTO tew_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","In Huḏíyoví tsonnin dínhanginná Jesus-á nä́ˀi híˀ inbí̖ˀgeḏiho ihéeˀannin, heḏi didaˀ óepankáyjíˀin, hewänbo in tꞌowa dâykhunwôedaˀmáaḏí wíˀóepankêˀpí, heḏi iweḏi dimää. ");
INSERT INTO tew_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tíˀúugéḏí in Huḏíyo tsonnindi wên Pharisee tꞌowa-á heḏá Herod-ví kꞌemaˀindá Jesus-víˀpiye ovâypunjôn hä̖ä̖wí óetsikaˀya̖míḏí. Didaˀ óekáyjíˀin híwó wíˀihíˀmáapíḏí. ");
INSERT INTO tew_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Heḏi ûnpówáḏí óetu̖ˀan, “Há̖hkandiˀ, gínhanginná uví híˀ-á taˀgen úmuuˀin, u̖ˀḏá tꞌä̖hkí tꞌowa handa̖ˀbá ovâymáa, háa tꞌowa dínwänpicha̖a̖ waa háabo wíˀunmuupí, heḏiho taˀgendá Jôesi Táḏáví khuu i̖ˀgeḏá tꞌowa ovâyhá̖ˀoˀ. Dítu̖ˀan, hânnan nanbí tsontun gíntû̖ˀ? Ti híwó namuu in Rome-winbí tsondi Caesar ây-tax-wáˀâa-íḏí háa joe? Ti gínkhâyˀä̖ˀ âywáˀâa-íˀin háa joí óetsikaˀya̖míḏí. Didaˀ é?” ");
INSERT INTO tew_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Hebo Jesus ûnhanginná gin óetsikaˀmáaḏí inbí ánshaaho taˀge wíḏâymáapíˀin, heḏiho ovâytu̖ˀan, “Háaḏan dítayindeˀ? Wí denarius chä̖ˀ dînmáˀ naa dómúuníḏí.” ");
INSERT INTO tew_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ônmaaḏi ovâytsikaˀyan, “Toˀví tsꞌay-an nä́ˀi chä̖ˀ eeḏi ûnkꞌóe, heḏá toˀví khá̖wä̖́-á?” Óetu̖ˀan, “Gá Caesar-víˀinnân.” ");
INSERT INTO tew_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus-di ovâytu̖ˀan, “Heḏáhoˀ, hä̖ä̖wí Caesar-vîˀ ûnmuuˀi Caesar-bá binmä́ä, heḏi wáˀ hä̖ä̖wí Jôesi Táḏávîˀ ûnmuuˀi-á Jôesi Táḏá-á binmä́ä.” Heḏi iví híˀḏí báyékí ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nä́ˀin Sadducee tꞌowa Jesus-víˀpiye diˀä̖ä̖, hä̖ä̖wí óetsikaˀya̖míḏí. (In Sadducees-á dívíwä̖yundeˀ in tꞌowa dichuuˀin háˀto wíyá diwówápúuwí.) ");
INSERT INTO tew_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Indi óetu̖ˀan, “Há̖hkandiˀ, Moses-di nä́ˀin tsontun dîntaˀnan: Wí sen âypíḏíbo nachuuḏi iví kwee waˀ ûnwówájiḏá, iˀ senbí tíˀûu ûnkhâyˀä̖ˀ iˀ kwee-áḏí ikhóˀyâ̖a̖-íˀin, heḏânho dä̂nˀâykwꞌôeníḏí iˀ páˀḏâyví khá̖wä̖́ ônhûuwíḏí. ");
INSERT INTO tew_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hebo ginnân napóe: Tsé ihay tíˀûuwin senäˀ dijiˀ. Iˀ shánkí páaḏéˀiˀ ikhóˀyâ̖ˀ, hebo âypíḏíbo nachuu. ");
INSERT INTO tew_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Iˀ eeḏiˀi-á wáˀ iˀ kwee-áḏí ikhóˀyâ̖ˀ, heḏi nä́ˀi sen wáˀ âypíḏíbo-áho nachuu. Heḏi iˀ powageˀi-á hanbá ûnpóe. ");
INSERT INTO tew_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Heḏi handa̖ˀ tꞌä̖hkí in tséḏí dijiˀin tíˀûuwin dínpóe, tꞌä̖hkí wíˀínbo iˀ kwee-áḏí dívíkhóˀyâ̖ˀḏi wêe wänbo wí ay wíḏâysógepí. Tꞌä̖ˀgeḏá iˀ kwee-á wáˀ nachuu. ");
INSERT INTO tew_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nä́ˀin tsé ihay tíˀûuwin iˀ kwee-áḏí dikhóhtsa̖a̖kwꞌônwän, heḏiho dítu̖ˀan, owáy tꞌowa wíyá diwáywówápóe ihayḏi, toˀwíví kwee-an ûnmúuní?” ");
INSERT INTO tew_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus-di ovâytu̖ˀan, “Gindiḏân ípeḏeekwꞌó, wíˀúnhanginnáhpíḏí Jôesi Táḏáví taˀnin háa ûntû̖ˀnin, heḏá wáˀ wíˀúnhanginnáhpí Jôesi Táḏá-á hânho nakayˀin. ");
INSERT INTO tew_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Owáy in ditꞌahánnin tꞌowa diwáywówápóe ihayḏi, senäˀdá kwiyä̖ˀdá háˀto wíyá dívíkhóˀyâ̖a̖-í, gá gindiḏi in makówáwin tꞌôepa̖ˀa̖a̖ˀin waaginbá dimúuníḏân. ");
INSERT INTO tew_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","In tꞌowa dichuuˀin diwáywówápúuwí i̖ˀgeḏi dítsikaˀmáa, hewänbo bîntunnanpíˀan háa Moses-ví taˀnin diwe ûntaˀmuuˀin in wä̖́ä̖ˀi phéˀyä̖́vi nakojeˀ niˀgeḏi itaˀnan diwe. Ihayḏi Jôesi Táḏáḏí ginnân Moses óehéeˀan: Naa-ân omuu Jôesi Táḏá, Abraham-dá Isaac-á Jacob-á inbí Jôesi omuu. ");
INSERT INTO tew_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nä́ˀin senäˀ dichuu wänbo taˀgendi diwówájiˀ, gá Jôesi Táḏá-á in diwówájiˀinbí Jôesi dínmuuḏân, in dichumuuˀinbîˀ-á joe. Heḏânkun tꞌä̖hkí ípeḏeekwꞌó úvíwä̖yundeḏi in dichuuˀin háˀto diwáywówápúuwíˀin.” ");
INSERT INTO tew_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wí sen in Huḏíyoví khuu dâyhá̖ˀoˀin diweḏiˀi natꞌoe dívíhíˀmáaḏí, heḏi Jesus-di híwóˀnin híˀ ovâymä́giˀin ûnhanginná, heḏiho Jesus-víˀpiye namääḏi óetsikaˀyan, “Wéˀinnan tꞌä̖hkí Jôesi Táḏáví tsontun diweḏi in shánkí kayˀin ûnmuu?” ");
INSERT INTO tew_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus-di óetu̖ˀan, “Nä́ˀinnân in shánkí kayˀin namuu: Un Israel tꞌowa bítꞌôeyan, Nanbí Jôesi iˀ shánkí natsonjiˀi namuuˀiˀ iˀ wêeḏa̖ˀ Jôesi naˀä́ndiˀ namuu, ");
INSERT INTO tew_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","heḏi undá únkhâyˀä̖ˀ nä́ˀi shánkí natsonjiˀiˀ unbí Jôesi únmuuˀi-á pín taˀgeḏi bînsígí-íˀin, unbí píˀnä́ khóˀjé-á, unbí hâ̖a̖ iwá, unbí ánshaaḏá, heḏá unbí kay tꞌä̖hkíḏá. ");
INSERT INTO tew_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Heḏi nä́ˀindá in eeḏiˀin tsontundá namuu: Háa un wíˀbo úvípisígí waagibá wéˀgen tꞌowa wáˀ bînsígíhûuwí. Wây-á tsontun nä́ˀin wíjeví shánkí hayˀin namuuˀin wínakꞌóepí.” ");
INSERT INTO tew_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nä́ˀi Huḏíyoví khuu ovâyhá̖ˀoˀiˀḏi Jesus óetu̖ˀan, “Há̖hkandiˀ, híwó bihéeˀan. In taˀgen namuu untú̖ waa, wêeḏa̖ˀ Jôesi naˀä́n, heḏi wíyá Jôesi-á wínaˀä́npí, iˀḏa̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Híwó namuu animâa âyhûuwíˀin oe méesate eepiye âyphamää-íḏí Jôesi Táḏá âymä̂äníḏí, heḏá wíyá hä̖ä̖wí-á âymä̂äníˀin. Hebo shánkí híwóˀnin namuu Jôesi âysígí-íˀin nanbí píˀnä́ khóˀjé-á, nanbí hangintandá, nanbí kay tꞌä̖hkíḏá, heḏá wáˀ wây-á tꞌowa-á âysígíhûuwíˀin ívípisígí waabá.” ");
INSERT INTO tew_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus ûnhanginná nä́ˀi sendi híwóˀdi híˀ óemä́giˀin heḏi óetu̖ˀan, “U̖-á hí̖yä̖̂ä̖ḏa̖ˀ útáy unkhâymúuníḏí Jôesi Táḏáví tsonkhuu mânsígíkáyjíḏí.” Heḏi iweḏi tꞌä̖hkíḏíbo diwôedaˀpóe Jesus wíyá hä̖ä̖wí óetsikaˀyâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus-di iˀ méesate hayˀi ee ovâyhá̖ˀoḏi ovâytu̖ˀan, “Heháaḏan in Huḏíyoví khuu dâyhá̖ˀoˀin ditû̖ˀ, iˀ toˀwí Jôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí David-ví ây iweḏiˀiˀḏa̖ˀ ûnmuu? ");
INSERT INTO tew_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi David óehá̖ˀandi David-bo ginnân natú̖: Nanbí Sedó Jôesi Táḏáḏí óetu̖ˀan naví tsondi hayˀiˀ, ‘Naví koˀḏíngéḏí ósoge, heḏi uví hä́nmin dovâytꞌaaní heḏá uví mange wînkáaní.’ ");
INSERT INTO tew_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nä́ˀi toˀwí Jôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí David-dibo iví tsondi hayˀi gin óetu̖ˀoˀ. Gin namuuḏá háḏíḏanho David-ví ây iweḏiˀiˀḏa̖ˀmân ûnmúuní?” In báyékí tꞌowa híhchangiḏi dívítꞌôeyande Jesus-di ovâyhá̖ˀoḏi. ");
INSERT INTO tew_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ovâytu̖ˀan, “Nä́ˀin tꞌowa Huḏíyoví khuu dâyhá̖ˀoˀin dimuuˀinbíˀweḏi bíˀá̖yîngiˀan. To whaaḏiˀin ditoˀondi dijiˀ dâykeeya̖míḏí toˀwên dimuuˀin, heḏá ovâyhí̖ˀan tꞌowaḏi aˀgindi ovâysengitu̖ˀâ̖a̖míˀin iˀ búˀ pinge i̖ˀge dijiḏi, ");
INSERT INTO tew_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","heḏá wáˀ in Huḏíyoví méesate eeje heḏá nashánkíˀeeḏináˀ dihayḏá in tsonninbí soge eeḏi dívíkwꞌôeníˀin didaˀ. ");
INSERT INTO tew_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kwiyä̖ˀ inbí senäˀ dínchuuˀinbí tewhá ovâykweeḏeˀ, heḏáháˀ thaa tꞌä̖hkí dívíjûusuˀoḏi híwóˀnin dimuu waagi dívípiḏaˀoˀ. Gin dívíˀoḏi Jôesi Táḏáḏí shánkí ovâytuhchä̖nukhâymáa.” ");
INSERT INTO tew_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus iˀ méesate hayˀi íve iˀ chä̖ˀ phébay núˀ isógeḏi in tꞌowa inbí chä̖ˀ dâykuuḏeḏi ovâymúndeˀ. Báyékí in koḏitꞌowa dimuuˀindá báyékí dâychä̖ˀkuuḏeˀ. ");
INSERT INTO tew_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Heḏi wí kwee iví sen ûnchuuˀi sehkanäwó nawówájiˀi-á napówáḏí wíje chä̖ˀ pꞌíˀin itógi, hí̖yä̖̂ä̖ḏa̖ˀ iˀ chä̖ˀ namuu. ");
INSERT INTO tew_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Heḏi Jesus iví khä̖geˀnin iwéˀgeˀandi ovâytu̖ˀan, “Taˀgendi wâytu̖ˀâ̖a̖mí, nä́ˀi kwee iví sen ûnchuuˀi sehkanäwó nawówáji wänbo iˀ chä̖ˀ phébay iwe shánkí itógi tꞌä̖hkí in wéˀgen dâykuuˀinbíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","In wéˀgendáho iˀ chä̖ˀ dínphaḏe iweḏi dívímä́gi, hewänbo nä́ˀi kwee-á báyékí ûnkwꞌóhpí wänbo hä̖́yú̖ imáaˀi tꞌä̖hkí itógi — iví wówátsi iˀa̖mígîˀ tꞌä̖hkí imä́gi.” ");
INSERT INTO tew_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus iˀ méesate hayˀi iweḏi napeemän dihayḏi, wêe iví khä̖geˀnin diweḏiˀiˀḏi óetu̖ˀan, “Há̖hkandiˀ, námúˀḏí nä́ˀi saˀwóˀdi tewhá nä́we nakwꞌóˀdiˀ, heḏá iˀ saˀwóˀdi kꞌuuḏi napaˀandi-á.” ");
INSERT INTO tew_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus-di óetu̖ˀan, “Nä́ˀi tewhá heˀendi nää nâamúndepíˀan. Hewänbo tꞌä̖hkí hä̖ˀi-á tꞌowa dâynayu̖khâymaa, heḏi wêe wänbo wí kꞌuu hä̖ˀi tehpaa iweḏi wínateˀḏeegíˀopí.” ");
INSERT INTO tew_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus iˀ okú “Olive Okú” gin dâytu̖ˀoˀ eeḏi napeeḏi wíˀbo isóge, heḏi pꞌohuuge onä pꞌä̖́näbo iˀ méesate hayˀi imúndeˀ. Heḏi Peter-á, James-á, John-dá, Andrew-á diˀä̖ä̖ḏi óetsikaˀyan, ");
INSERT INTO tew_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ti dítu̖ˀâ̖a̖mí, hä̂nhay-an nä́ˀi hä̖ä̖wí i̖ˀgeḏi dítu̖ˀandi napuwagíˀo? Hä̖ä̖-an nakeepúuwí heḏânho gínhanginnáaníḏí hä̖̂ä̖ḏi natsꞌanpúuwíˀin?” ");
INSERT INTO tew_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus-di ovâytu̖ˀan, “Bíˀá̖yîngiˀan toˀwíḏí wänbo piháa wíwovâywä̖yu̖ˀa̖mípíḏí. ");
INSERT INTO tew_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Báyékí tꞌowa naví khá̖wä̖́ i̖ˀgeḏi dikä̖ˀä̖ä̖gíˀo, heḏi wíˀínbo ditú̖u̖ní innânho dimuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. Gindiḏi báyékí tꞌowa inbí hójo ovâywä̖yu̖kankhâymáa. ");
INSERT INTO tew_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hewänbo tꞌowa tsowa dithaaˀin háa kayi̖ˀ dithaaˀin dívíhä́nboˀ i̖ˀgeḏi ítꞌoeḏá, wíwovâyˀá̖yîngimä̂änípí. Nakhâyˀä̖ˀ nä́ˀi hä̖ä̖wí napúuwíˀin, hewänbo owáy napóe ihayḏá iˀ tꞌä̖ˀgeˀi thaa waˀḏi wínaˀä̖hpí. ");
INSERT INTO tew_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tꞌowa wêe nangewin dívíhä́nkhâymáa wây-á tꞌowa wíyá wêe nangewindáḏí, heḏá nangewin tsonnindá wáˀ dívíhä́nkhâymáa. Wáyjé tꞌä̖hkí nananˀa̖ˀyä̖puwagíˀo, heḏá báyékí diha̖a̖puwagíˀo. Hewänbo nä́ˀi hä̖ä̖wí-á wí kwee páaḏé naˀejehay waagiˀbá namuu, waˀḏi shánkí napuwagíˀo. ");
INSERT INTO tew_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Undá wíˀbo bíˀá̖yîngiˀan. Wovâypankhonkhâymáaḏá tunjó wháagépiyá wovâyhûuwí, heḏi iˀ Huḏíyoví méesate eeje wovâywhä̖ḏikhâymáa. Naa omuuḏi in nangewin pꞌóˀḏéḏíˀinbíˀpiye heḏá wéˀgen tsonninbíˀpiyá wovâyhûuwí, naví̖ˀgeḏi bîntꞌôeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hewänbo waˀḏi iˀ tꞌä̖ˀgeˀi thaa napówápíḏíboˀ, Jôesi Táḏáví híwóˀdi tun tꞌä̖hkí nangeˀin tꞌowa ovâytꞌôeˀa̖míˀin nakhâyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Owáy wovâypanhógiḏi tunjó wháagé wovâykándí, waˀ ípówápíḏíbo wíwovâyˀá̖yîngimä̂änípí háa iwe ítú̖u̖níˀin, hewänbo ihayḏi iˀ híˀ Jôesi Táḏáḏí wovâte eeje wovâywhä̖ḏikhâymáa. Naa omuuḏi in nangewin pꞌóˀḏéḏíˀinbíˀpiye heḏá wéˀaymä́giˀi-áho ítú̖u̖ní. Undá wíˀbo wíˀúvípihíˀkhâymáapí, iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏân wovâykhä̖geˀkhâymáa bînhéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tꞌowa inbí tíˀûuwin páaḏéˀin inbí hä́nminbí mangepiye ovâykáaní ovâyhá̖a̖nú-íḏí, heḏi in táḏáˀindá hanbá inbí ây dâykhâymáa, heḏá in ây-á inbí táḏáˀin jíyáˀinbíˀpiye dívíhä́nsaaḏi tson diwe ovâykwohkhâymáa ovâyhá̖a̖nú-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Báyékí tꞌowaḏi wovâytꞌaykhâḏéḏíˀinbíˀpiye heḏá wéˀymáa navíˀin íwänpimuuḏi, hewänbo in toˀwên dívítꞌôephaḏeyä̖́ä̖ˀannin dichuu píhay, indá ovâyˀaywoení.” ");
INSERT INTO tew_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Jôesi Táḏáví taˀnin diwe Daniel itaˀnan iˀ Naháˀḏä̂nkantꞌóeˀiví̖ˀgeḏi, iˀ Jôesi Táḏáḏí wänbo óetꞌayˀiˀ. (Bîntunnanpíˀan, heḏi únkhâyˀä̖ˀ íkaˀpóewíˀin.) Owáy ee ûnkhâyˀä̖hpíˀwe nawindi bînmûˀḏi, ihayḏáho un Judea nange íkwꞌóˀnin únkhâyˀä̖ˀ oe okú iˀpiye íjáaníˀin. ");
INSERT INTO tew_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Heḏi wí toˀwí iví whaˀkꞌay iwe najiˀiˀ iweḏi nawândi wíˀûnkhâyˀä̖hpí ihayjêeˀa̖míˀin iˀ tewhá ee natsꞌú̖u̖níḏí wí hä̖ä̖wí wänbo ikáyjíḏí. ");
INSERT INTO tew_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Heḏi toˀwí nava iwe najiˀi-á wíˀibuunípí iví kꞌéwéˀin to wänbo ikáyjíḏí. ");
INSERT INTO tew_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Owáy iˀ thaa napówá ihayḏá, sehkanä in kwiyä̖ˀ disâamuuˀin heḏá in dâyˀâytsä̖ä̖ˀoˀindá, gá ingîˀ-á nakâypúuwíḏân dijáaníḏí. ");
INSERT INTO tew_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Úvíjûusuˀa̖mí nä́ˀi hä̖ä̖wí teˀnúḏí wínapúuwípí, ");
INSERT INTO tew_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","gá báyékí tꞌôephaḏe naˀä̖ḏân. Jôesi Táḏá nä́ˀi nan oepáa ikhíjé waabo tꞌowa dâytꞌôephaḏendeˀ, hewänbo owáy iˀ thaa napówá ihayḏá shánkí báyékí dâytꞌôephaḏekhâymáa, heḏi háˀto wíyá haˀwâa dâytꞌôephaaḏé-í. ");
INSERT INTO tew_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Hewänbo in toˀwên Nanbí Sedó Jôesi Táḏáḏí ovâydeˀmannin dimuuḏihoˀ, in tꞌowa báyékí thaa wíˀovâytꞌôephaḏepä̖khâymáapí, gá imä́giḏá toˀwí wänbo háˀto nawówáyê̖e̖níḏân. ");
INSERT INTO tew_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Heḏi ihayḏá tꞌowa ditú̖ḏáhoˀ, ‘Binmúˀḏí, nä̂äwân najiˀ iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí,’ heḏiháa wây-á ditú̖ḏá, ‘Oe-ân najiˀ,’ háa ditú̖ waa wíˀúvíwä̖ä̖yú̖-ípí, ");
INSERT INTO tew_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","gá hójoˀin tꞌowa dikä̖ˀä̖ä̖gíˀoḏân heḏi wên ditú̖u̖ní innânho dimuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, heḏá wêndá ditú̖u̖ní Jôesi Táḏáví tukheˀmindá dimuu. Nä́ˀin hójoˀindá wên pínnán taa-á dâykeeya̖mí in tꞌowa ovâyháaˀa̖míḏí, heḏi inbí hójoḏibo in Jôesi Táḏáḏí ovâydeˀmannin in taˀgen namuuˀin diweḏi ovâyhângeˀa̖mí, ho nakoḏiḏi. ");
INSERT INTO tew_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Undá bíˀá̖yîngiˀan. Wâytu̖máa hä̖ä̖wí tꞌä̖hkí napúuwí i̖ˀgeḏi waˀ napóepíḏíboˀ.” ");
INSERT INTO tew_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Heḏi iˀ thaa nanáˀ dihayḏi hä̖ˀin tꞌôephaḏe nahán dihayḏi, iˀ than nakhunpuwagíˀo, iˀ pꞌóethay wänbo wínakeepúuwípí. ");
INSERT INTO tew_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","In agóyó-á makówáḏá dijaymú-í, heḏá tꞌä̖hkí oe makówá nasaaˀi-á naˀa̖ˀyä̖púuwí. ");
INSERT INTO tew_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Heḏi ihayḏi in tꞌowaḏi naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀiˀ okhúwá jâa oˀä̖ḏi dímúuní, báyékí pínnán kay wóegé heḏá saˀwóˀdi kohthay wóegá oˀä̖ä̖-í. ");
INSERT INTO tew_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Heḏi in makówáwin tꞌôepa̖ˀa̖a̖ˀin dovâypunjôení in dovâydeˀmannin ovâywéˀgeˀa̖míḏí pꞌinpiyeḏá tsânpiyeḏá aakonpiyeḏá thanpiyeḏá, wéngé tꞌä̖hkí nä́ä oepáa kꞌayḏi dikwꞌóˀnin deejeḏá ovâywéˀgeˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Wên fig tay binmúˀḏí hä̖ä̖wí íhá̖hpúuwíḏí. Iˀ taykhóeˀây naˀohphuupoeˀoḏi natsꞌantsá̖wä̖́puwamän dihayḏi, únhanginná nata̖ˀánpowaˀä̖ˀinpíˀan. ");
INSERT INTO tew_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Heḏi gindiḏibá owáy nä́ˀi hä̖ä̖wí i̖ˀgeḏi wâytꞌôeˀan bînmûˀ ihayḏá únhanginnáaní púnúˀ nanáˀnin naa owáyˀä̖ä̖-íḏí, phóḏi núˀ owin waagi namúuní. ");
INSERT INTO tew_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Taˀgendi wâytu̖máa, tꞌä̖hkí in nä́äwin tꞌowa háˀto dihá̖a̖ní waˀḏi nä́ˀi hä̖ä̖wí tꞌä̖hkí páaḏé natsꞌanpoeˀopíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Makówá-á heḏá oepáa kꞌayḏá tꞌä̖hkí nakhangíˀo, hewänbo naví tundá háˀto dînhá̖a̖ní.” ");
INSERT INTO tew_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Hewänbo hä̖̂ä̖ḏi nä́ˀi hä̖ä̖wí napuwagíˀoˀin toˀwí wänbo taˀgendi wíˀûnhanginnáhpí. In makówáwin tꞌôepa̖ˀa̖a̖ˀin wänbo wíḏínhanginnáhpí, heḏá naa Jôesi Táḏáví ay omuuˀi wänbo-á wíḏînhanginnáhpí. Jôesi Táḏáḏa̖ˀmân ûnhanginná. ");
INSERT INTO tew_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Heḏiho bíkhâyˀandá bíˀá̖yîngiˀan, hä̖̂ä̖ḏi nä́ˀi hä̖ä̖wí napuwagíˀoˀin wíˀúnhanginnáhpíḏí. ");
INSERT INTO tew_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gin waagibá napúuwí: Wí sen iví tewhá ijoeˀandi wáy kayi̖ˀpiye namääḏi iví tꞌôeˀin ovâykꞌûˀ iví hä̖ä̖wí ônˀá̖yîngiˀa̖míḏí heḏá háa inbí tꞌôe dâyˀa̖míˀindá ovâyjôn, heḏi iˀ phóḏi á̖yí̖ˀdiˀ óetu̖ˀan nakhâymúuníḏí. In tꞌôeˀin wíḏínhanginnáhpí hä̖̂ä̖ḏi nä́ˀi sen nawáyˀä̖ˀin. ");
INSERT INTO tew_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nä́ˀi sen waagiˀbá naa omuu, heḏiho íkhâymúuní, wíˀúnhanginnáhpí hä̖̂ä̖ḏi owáyˀä̖ˀin — háḏéewáy kindi, háa khun pinuḏi, háa héḏénpiye, háa nathanpeeˀä̖ˀ ihayḏi. ");
INSERT INTO tew_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Úvíˀá̖yîngiˀanpíḏá wáy tsíkhagipí opówáḏí íjóˀkwꞌôndibo wâyshaa-í. ");
INSERT INTO tew_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Háa un wâytu̖ˀan waa, tꞌä̖hkí tꞌowa-ân hanbá dovâytu̖máa: Íkhâymúuníˀin únkhâyˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Waˀ wíje thaa ûntáy in Huḏíyoví shánkíˀeeḏi Passover gin dâytu̖ˀoˀi dínpóewíḏí, ihayḏi iˀ pává oewáaseepîˀ dâykꞌoˀ. In owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá dâytu̖wä̖máa háḏíḏí kaaḏibo Jesus óekáyjíˀin óeháyjíḏí. ");
INSERT INTO tew_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ditú̖, “Nää-á waˀḏi nä́ˀin shánkíˀeeḏi napoeˀoḏi wíˀívíˀa̖mípí. Haˀwâa ívíˀandá, wáy nä́ˀin tꞌowaḏi naˀin díyâ̖a̖-í.” ");
INSERT INTO tew_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ihayhä̖̂ä̖ḏibá Jesus oe Bethany búˀay najiˀ, heḏi wí sen Simon gin nakhá̖wä̖́ˀivîˀ ihúuhoˀ, nä́ˀi sendá naphéetaymuuwän. Jesus nahúuˀä́n dihayḏi wí kwee wên pꞌonbayˀay imáaḏí natsꞌú̖, indá kꞌuu tsꞌä̖ˀiˀḏi ûnpaˀan heḏi wí ka̖ˀpꞌoe “nard” gin dâytu̖ˀoˀiˀ ûnkuˀun. Nä́ˀi ka̖ˀpꞌoe-á saˀwóˀgí nasun heḏá hânho-á nachä̖ˀmuu. Heḏi iˀ kwee in pꞌonbayˀay kꞌáy iháve, heḏi nä́ˀi ka̖ˀpꞌoe-á Jesus-ví pꞌóˀḏé ônˀewe. ");
INSERT INTO tew_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wên tꞌowa iwe dikwꞌóˀnin dâymûˀḏi ditꞌayjiˀ, heḏi wíˀnä́ táye dívítu̖máa, “Háaḏan nä́ˀi ka̖ˀpꞌoe-á ipeḏeeˀan? ");
INSERT INTO tew_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Powin tä̖gintä̖ (300) thaa tꞌôe dívíˀandi wáˀâaḏi naku̖hchaḏee-íwän, háa maḏi shánkí wänboˀ, heḏi iˀ chä̖ˀ in sehkanäwó diwówájiˀin ovâymä̂äníwän.” Heḏi iˀ kwee-á hânho óetunsúuˀan. ");
INSERT INTO tew_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus-di ovâytu̖ˀan, “Iˀ kwee ánpí binˀan. Háaḏan bîntꞌaymáa? Híwóho saˀwóˀgí naa díˀan. ");
INSERT INTO tew_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hä̖̂ä̖ḏi wänbo in sehkanäwó diwówájiˀin tꞌowa undáḏí únkwoˀní, heḏiho hä̖̂ä̖ḏi wänbo nä́we hä̖ä̖wí híwó bînˀa̖míˀin ídaˀḏá, únkoḏi bînˀa̖míḏí. Hewänbo naa-á nä́we hä̂nhay wänbo tꞌä̖hkí undáḏí wíˀochangíˀopí. ");
INSERT INTO tew_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nä́ˀi kwee hä̖́yú̖ ûnkoḏi ihay iˀan. Waˀḏi in pení ovâykhä̖ˀkwꞌóḏipíḏíboˀ inbîˀḏi dâyka̖ˀpꞌoeˀewendeˀ, heḏi hanbá iˀḏi naa díˀan waˀḏi ochuupíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Taˀgendi wâytu̖máa, wä̖́hä̖̂ä̖ wänbo nä́ˀin Jôesi Táḏáví híwóˀdi tun ônphaḏendeˀ eeje nä́ä oepáa kꞌayḏi tꞌä̖hkí, háa nä́ˀi kwee iˀannin ovâytꞌôeˀa̖mí, iví̖ˀgeḏi dívíˀánshaaˀâ̖a̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Heḏi Judas Iscariot, wí in tä̖ˀḏi wíje khä̖geˀnin diweḏiˀi namuuˀiˀ, in owhaˀ pꞌóˀḏéḏíˀinbíˀwepiye namää Jesus óeku̖ˀpꞌâyníḏí. ");
INSERT INTO tew_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Heḏi nä́ˀin owhaˀ ditꞌoe ihayḏi tꞌä̖hkí dihíhchanpóe, heḏi inbí tun Judas óemä́gi chä̖ˀ óewáˀâa-íḏí. Heḏiho iweḏi Judas itu̖wä̖máa háḏíḏí Jesus inbí mange óekáaníˀin, hä̖̂ä̖ḏi ûnkoḏi ihayḏi. ");
INSERT INTO tew_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","In Huḏíyo dínshánkíˀeeḏipoeˀo, iˀ oewáaseepîˀ pává dâykꞌoˀiˀ. Iˀ páaḏéˀi shánkíˀeeḏi thaa in kꞌúwáˀây dâyhá̖núndeˀ, Passover koegîˀ gin dâytu̖ˀoˀi dâykꞌoˀíḏí. Heḏi Jesus-ví khä̖geˀnindi óetsikaˀyan, “Wä̖́hä̖̂ä̖-an naˀin gimú-íˀin undaˀ hä̖ä̖wí âykhâyˀa̖míḏí iˀ Passover koegîˀ âykꞌoˀíḏí?” ");
INSERT INTO tew_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Heḏi wíjeḏi in khä̖geˀnin ovä̂nsan dä̂nˀa̖míḏí. Ovä̂ntu̖ˀan, “Oe Jerusalem búˀpiye bápûn, heḏi wí sen wên pꞌonbay ihondiˀḏi wovä̂njay-í. I-áḏíbá damú-í. ");
INSERT INTO tew_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Heḏi wáy i-á natsꞌûndá iˀ sen iví tewhá ûnmuuˀiˀ dä̂ntu̖ˀâ̖a̖mí, ‘Nanbí há̖hkandiˀḏi dítu̖ˀan wítsikaˀyâ̖a̖míḏí, Wéˀi íve-an naagîˀ dînmuu, eewân naví khä̖geˀnindáḏí nä́ˀi Passover koegîˀ âykꞌoˀí?’ ");
INSERT INTO tew_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Heḏi iˀ sendi wí whaˀkꞌay íve hayˀi wovä̂nkeeya̖mí, hä̖ä̖ tꞌä̖hkí gíntáyˀi nakwꞌôndi. Ee-áho iˀ koegîˀ dä̂nkhâyˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Heḏiho in khä̖geˀnin damääḏi iˀ búˀ iwe datsꞌú̖, heḏi hä̖ä̖wí tꞌä̖hkí háa Jesus natú̖ waagibá dä̂nshaa, heḏiho iˀ Passover koegîˀ dä̂nkhâyˀan. ");
INSERT INTO tew_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nakin dihayḏi Jesus-á iví khä̖geˀnindáḏí iˀ tewhá eepiye dimää. ");
INSERT INTO tew_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dihúukwꞌôn dihayḏi Jesus-di ovâytu̖ˀan, “Taˀgendi wâytu̖máa, wêe un naa-áḏí úvíhúujoˀin diweḏiˀiˀḏi naa díku̖hpekhâymáa.” ");
INSERT INTO tew_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","In khä̖geˀnin diháachanpóe, heḏi wíˀínbo óetu̖ˀan, “Ti naa-ân gin dáyˀa̖mí? Naa-á háˀtoˀ.” ");
INSERT INTO tew_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus-di ovâytu̖ˀan, “Wêe un tä̖ˀḏi wíje iweḏi naa-áḏí iví pává nä́ˀi sä̖ä̖ iwe ipꞌohtôeníˀiˀ, iˀḏân díku̖hpekhâymáa. ");
INSERT INTO tew_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ ochuwagíˀo, Jôesi Táḏáví taˀnin diwe nataˀmuu waagi. Hewänbo nä́ˀi toˀwí díku̖hpekhâymáaˀi-á tꞌôephaḏe ûnpúuwí. Shánkí híwó iˀ sen ûnpúuwíwän naˀaypu̖yä̖píḏí.” ");
INSERT INTO tew_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dívíhúujoˀ ihayḏi Jesus wí pává ikêˀḏi Jôesi Táḏá óekú̖ˀdaaˀan, heḏáháˀ iháveḏá iví khä̖geˀnin ovâymä́gi, heḏi ovâytu̖ˀan, “Binhóˀgí, nä́ˀi-á naví túˀ dînmuu.” ");
INSERT INTO tew_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Heḏáháˀ wên kꞌéḏé ikêˀḏi wíyá Jôesi Táḏá óekú̖ˀdaaˀandi ovâymä́gi, heḏi tꞌä̖hkíḏíbo wí dâysu̖wä̖. ");
INSERT INTO tew_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Heḏi ovâytu̖ˀan, “Nä́ˀi-á naví ûnpꞌoe dînmuu. Naví ûnpꞌoe-á tꞌä̖hkí tꞌowagîˀ donchaˀgíˀo, heḏi owáy gin naa dáyˀandiho Jôesi Táḏáví tun imä́giˀi ho ûnpúuwí. ");
INSERT INTO tew_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Taˀgendi wâytu̖máa, háˀto wíyá dóméenasu̖u̖wä̖́-í owáy Jôesi Táḏáḏí naa dítsondisóge píhay, heḏi ihayḏá wíyá piˀwí méena waagibá dósu̖wä̖khâymáa.” ");
INSERT INTO tew_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Heḏi dâyjûusukhaˀwandi iˀ tewhá iweḏi dipee, heḏi oe Olive Okú gin dâytu̖ˀoˀ iwepiye dimää. ");
INSERT INTO tew_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dimändi Jesus-di ovâytu̖ˀan, “Jôesi Táḏáví taˀnin diwe ûntaˀmuu háa iˀ natú̖ˀin, ginnân: ‘Naaḏi iˀ kꞌúwá á̖yí̖ˀdiˀ dóháyjí, heḏi in kꞌúwá dívíwaḏegíˀo. Haˀwâabá un únpuwagíˀo. Naa díkheˀkhâymáaḏáháˀ undá tꞌä̖hkíḏí díjoeˀandi úvíwaḏekhâymáa. ");
INSERT INTO tew_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Heḏi owáy owáywówápóe ihayḏá Galilee nangepiye unbí páaḏé omän.” ");
INSERT INTO tew_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter-di óetu̖ˀan, “Tobá tꞌä̖hkíḏí wóejoeˀan wänboˀ, naaḏá háˀtoˀ.” ");
INSERT INTO tew_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hewänbo Jesus-di óetu̖ˀan, “Nä́ˀin taˀgendi wítu̖ˀâ̖a̖mí: Nääaví taˀnin diwe ûntaˀmuu háa iˀ natú̖ˀin, ginnân: ‘Naaḏi iˀ kꞌúwá á̖yí̖ˀdiˀ dóháyjí, heḏi in kꞌúwá dívíwaḏegíˀo. Haˀwâabá un únpuwagíˀo. Naa díkheˀkhâymáaḏáháˀ undá tꞌä̖hkíḏí nä́ˀi khunboˀ, wí dee sen waˀḏi wáygín ikinpíḏíboˀ u̖-á powin untú̖u̖ní naa wíḏítaapíˀin.” ");
INSERT INTO tew_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hewänbo Peter-di shánkí kayˀindi óetu̖ˀan, “Tobá u̖-áḏí naa díhay wänboˀ, naa háˀto hä̂nhay wänbo otú̖u̖ní wíwítaapí gin.” Heḏi tꞌä̖hkí in wéˀgen khä̖geˀnin hanbá ditú̖. ");
INSERT INTO tew_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nä́ˀi tay jâa iwe dipówá, Gethsemane gin dâytu̖ˀoˀ, heḏi Jesus iví khä̖geˀnin itu̖ˀan, “Nä́we bíkwꞌoˀ. Naaáaḏáháˀ undá tꞌä̖hkíḏí oˀä̖ä̖mú-í dáyjûusuˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hewänbo Peter-á James-á heḏá John-dá i-áḏí ovâyhoˀ. Ihayḏi khunwôedaˀḏi óemáa heḏá iví píˀnä́ ûnkháapóe. ");
INSERT INTO tew_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Heḏi ovâytu̖ˀan, “Naví píˀnä́ khóˀjé hânho otaachanpoeˀoḏi hä̖ä̖wí ochuu-í waa ocha̖a̖. Nä́webo úvítsíkhakwꞌôení heḏá á̖yîngiḏi bíkwoˀbe.” ");
INSERT INTO tew_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wíyá hây namääḏi iwe nange iseewhaaḏikꞌûˀ, heḏi ijûusuˀan nä́ˀin natsꞌanpuwagíˀoˀin wíˀûnpúuwípí, nakoḏiḏáhoˀ. ");
INSERT INTO tew_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ginnân ijûusuˀan: “Naví Táḏá, u̖-á hä̖ä̖ tꞌä̖hkí úkoḏi biˀa̖míḏí. In tꞌôephaḏe donkhâymáaˀin naa odaˀ dînjâaˀa̖míˀin. Hewänbo tobá napúuwí háa u̖-á undaˀ waa, háa naa odaˀ waagá joe.” ");
INSERT INTO tew_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Heḏi in poje khä̖geˀnin dikwꞌôn diwepiye nawáymääḏi dijókha̖wä̖kwꞌôndi ovâymûˀ, heḏi ovâyjóhsandi Peter óetu̖ˀan, “Simon, háaḏan unjókhá̖? Ti wí hây tä̖hkí wänbo wíˀúkoḏipíˀan á̖yîngiḏi unchaníḏí? ");
INSERT INTO tew_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Á̖yîngiḏḏi bíkwoˀbe heḏá bíjûusuˀan, heḏânho wovâytayindeˀ ihayḏi híwóhpí wíˀúvíˀa̖mípí. Pín taˀgeḏi híwó úvíˀa̖míˀin ídaˀ, hewänbo unbí túˀḏá wíˀíkaypí.” ");
INSERT INTO tew_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Heḏáháˀ nawáymääḏi háa hä̂nhay ijûusuˀan waagibá wíyá ijûusuˀan. ");
INSERT INTO tew_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Heḏi iví khä̖geˀninbíˀwepiye nawáyˀä̖ä̖ḏi wíyá ovâyjóhshaa, hânho dikayhándí, heḏi wíḏínhanginnáhpí háa óetu̖ˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Heḏi powingîˀ ijûusuˀandi nawáyˀä̖ä̖ḏi ovâytu̖ˀan, “Ti waˀḏi íjóˀkwꞌó heḏá úvíkaykhanwówáˀoˀ? Hä̖hayḏa̖ˀdiboˀꞌꞌ Ihayḏiho naná. Nää-á toˀwíḏí in tꞌaywóhkanninbí mange díkáaní naa, tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀiˀ. ");
INSERT INTO tew_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bíwí̖nú, gimú-íhoˀ. Binmúˀḏí, iˀ díku̖ˀpꞌégiˀi ho napówá.” ");
INSERT INTO tew_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Waˀḏi ihíˀmáa ihayḏi Judas napówá, i-á wêe in tä̖ˀḏi wíje khä̖geˀnin diweḏiˀiˀbá namuu. Báyékí wây-á tꞌowa i-áḏí dijiˀ. In owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá heḏá in Huḏíyoví tsonnindá nä́ˀin tꞌowa ovâysan tsijó pháˀ-á phé-á wóegé. ");
INSERT INTO tew_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Dipówápíḏíbo Judas, iˀ Jesus óeku̖ˀpꞌégiˀiˀḏi ho ovâytu̖ˀan in tꞌowa, “Iˀ sen dópꞌohtsä̖ä̖khâymáaˀi-áho iˀ namuu. Bînpankáyjí heḏi á̖yîngiḏi bînhûuwí.” ");
INSERT INTO tew_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Heḏi Judas wesebo Jesus-víˀpiye namääḏi óetu̖ˀan, “Há̖hkandiˀ,” heḏi óepꞌohtsä̖ä̖, ");
INSERT INTO tew_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","heḏi in tꞌowaḏi Jesus óeyâ̖ˀḏi óepanhoˀ. ");
INSERT INTO tew_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wí Jesus-ví khä̖geˀdiˀ iwe núˀ nawindi iví tsijó pháˀ iwhahkêˀḏi iˀ owhaˀ pꞌóˀḏéḏîˀví tꞌôeˀiˀ pꞌóˀḏé óewhä̖́ḏi, heḏi iví oje heˀyinbo ôntꞌó̖ˀtsꞌâˀ. ");
INSERT INTO tew_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Heḏi Jesus-di in tꞌowa ovâytu̖ˀan, “Háaḏan tsijó pháˀ-áḏí phé-áḏí íkhehpówá dípankáyjíḏí wí jänäkíkandiˀ omuu waabá? ");
INSERT INTO tew_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Thamuwaagi iˀ méesate hayˀi ee naa undáḏí ojiˀ wâyhá̖ˀoḏi, heḏi wíḏípankêˀpí. Hewänbo nää-á gin úvíˀoˀ, háa Jôesi Táḏáví taˀnin diwe ûntû̖ˀ waa napúuwíḏí.” ");
INSERT INTO tew_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Heḏi tꞌä̖hkí iví khä̖geˀnindi óejoeˀandi dijân. ");
INSERT INTO tew_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Wí eˀnú wáˀ wên aa tsꞌä̖ˀinda̖ˀ naˀaamuuḏi Jesus ûnwóejiˀ, heḏi in tꞌowaḏi óeyâ̖ˀ, hewänbo najândi in aaḏa̖ˀ dínjoepóe. ");
INSERT INTO tew_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesus iˀ owhaˀ shánkí pꞌóˀḏéḏîˀvíˀpiye óehoˀ. Eebá in wéˀgen pꞌóˀḏéḏíˀin owhaˀ-á, in tsonnindá, in Huḏíyoví khuu dâyhá̖ˀoˀindá dívíwéˀgeˀan. ");
INSERT INTO tew_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jesus óehon dihayḏi Peter-á tíˀúugá kayi̖ˀdiḏibo-á nawóemän, heḏi iˀ pꞌóˀḏéḏîˀ owhaˀví tewhá tehpaa búge natsꞌú̖, heḏi in sundaḏo á̖yí̖ˀnindáḏí isóge isúwáˀa̖míḏí ee naphaa iwe. ");
INSERT INTO tew_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Oe íve in owhaˀ-áḏí heḏá in tunjowaˀ dimuuˀindáḏí dâytu̖wä̖máa wí toˀwí híwóhpí Jesus-ví̖ˀgeḏi ihéeˀa̖míḏí, heḏânho Jesus óeháyjíḏí, hewänbo wíḏâyshaapí. ");
INSERT INTO tew_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Báyékí tꞌowa iví̖ˀgeḏi dívíhójoˀan, hewänbo handa̖ˀ wíḏitú̖hpí. ");
INSERT INTO tew_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Ihayḏi wên hójoˀin dívíwí̖núḏí ginnân ditú̖: “Gitꞌoe natú̖ḏí, ‘Nä́ˀi méesate hayˀi tꞌowa dâytegeˀi dónayu̖khâymáa, heḏi poje thaa iwe wíyá méesate tꞌowa dâykꞌûˀpîˀ naa dótegegíˀo.’ ” ");
INSERT INTO tew_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hewänbo nä́ˀin tꞌowa wänbo wíˀínbo handa̖ˀ wíḏitû̖ˀpí. ");
INSERT INTO tew_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Heḏáháˀ iˀ owhaˀ pꞌóˀḏéḏîˀ in tꞌowa tꞌä̖hkíví páaḏépiye iwí̖núḏí Jesus óetsikaˀyan, “Ti háabo wíˀuntú̖u̖nípíˀan nä́ˀi hä̖ä̖wí indi wônchä̖nundeˀ i̖ˀgeḏi?” ");
INSERT INTO tew_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Hebo Jesus-á tunginpí nawindi háabo wíˀóetu̖ˀanpí. Wíyá iˀ owhaˀ pꞌóˀḏéḏîˀḏi óetsikaˀyan, “Ti u̖-ân unmuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí? Ti u̖-ân iˀ âyˀaˀginmäˀiví ay unmuu?” ");
INSERT INTO tew_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus natú̖, “Naa-ânkun omuu, heḏi un tꞌä̖hkíḏí dípu̖wä̖khâymáa naa, tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ oˀä́ndí iˀ toˀwí tꞌä̖hkí kay imáaˀiví koˀḏíngéḏí. Heḏá makówáḏí okhúwá jâaḏi oˀä̖ḏi dípu̖wä̖khâymáa.” ");
INSERT INTO tew_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Haˀwâagi Jesus natú̖ḏí iˀ owhaˀ pꞌóˀḏéḏîˀ iví kꞌéwéˀin to isíve, in tꞌowaḏi óemúuníḏí natꞌayˀin, heḏi natú̖, “Wây-á toˀwên wígíntáypí iví̖ˀgeḏi dívíhéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Háa natú̖ˀin ítꞌoepíˀan. Natú̖ i-á Nanbí Sedó Jôesi Táḏá waagiˀbá namuu. Hânnan ídaˀ âyˀa̖míˀin?” Tꞌä̖hkíḏíbo ditú̖, “Gá óeháyjí-ân, híwóhpí âyshaaḏi.” ");
INSERT INTO tew_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Heḏi wêndi Jesus óeˀohphay, heḏi óetsíwhiˀandi óemahpúuḏí óetu̖ˀan, “Dítu̖ˀan toˀḏan wóemahpúuˀin.” Heḏi in méesatewin sundaḏoḏi óeyâ̖ˀḏi hä̖́yä́nbo óemapháve. ");
INSERT INTO tew_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Peter oe áagé iˀ tewhá tehpaa búgebo waˀḏi najiˀ, heḏi wí aˀyú̖ iˀ owhaˀ pꞌóˀḏéḏîˀví tꞌôeˀi namuuˀi Peter-víˀwe napówáḏí óemûˀ isúwáˀoḏi, heḏi óeḏamúndeḏi óetu̖ˀan, “U̖ˀ wáˀ Jesus Nazareth-wi-áḏí unjiwän.” ");
INSERT INTO tew_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hewänbo Peter natú̖, “Joe, naa-á joe. Naa wíˀokaˀpóyaˀpí hä̖ä̖wí i̖ˀgeḏi bihíˀmáaˀin.” Heḏi iweḏi napeeḏi in tehpaa phóḏi núˀpiye namää. ");
INSERT INTO tew_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Iˀ aˀyú̖ḏí wíyá óemûˀ, heḏi in iwe diwinnin ovâytu̖ˀan, “Nä́ˀi sen in Jesus-víˀin diweḏiˀiˀbá namuu.” ");
INSERT INTO tew_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Hebo Peter wíyá natú̖, “Naa-á joe.” Hây napóe ihayḏi in diwin diweḏi wí toˀwíḏí Peter óetu̖ˀan, “Taˀgendi u̖-á Galilee-wibá unmuuḏibo Jesus-áḏíbá unjiwän.” ");
INSERT INTO tew_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peter natú̖, “Jôesi Táḏáḏí dítuhchä̖ä̖nú-í taˀge dáyhíˀmáapíḏí. Hä̖ˀi sen iví̖ˀgeḏi úvíhíˀmáaˀi-á wíḏótaapí.” ");
INSERT INTO tew_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ihayḏibá wesebo wí dee sen ikin. Heḏi Peter ûnˀánpówá háa Jesus-di hä́nwaa óetu̖ˀannin: “Waˀ iˀ dee sen wáygín ikinpíḏíboˀ, u̖-á powin untú̖u̖ní naa wíḏítaapíˀin.” Heḏi Peter hânho isíhtä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Waˀḏéeḏí nanân dihayḏi in owhaˀ pꞌóˀḏéḏíˀindá, in tsonnindá, in Huḏíyoví khuu dâyhá̖ˀoˀindá heḏá tꞌä̖hkí in tunjowaˀ dimuuˀindá dívíwéˀgeˀan háa dívíˀa̖mí i̖ˀgeḏi dívíhéeˀa̖míḏí. Heḏi Jesus óewhiˀandi iweḏi óehoˀḏi Pilate-ví mange óekán. ");
INSERT INTO tew_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate-di Jesus óetsikaˀyan, “Ti u̖-á in Huḏíyoví tsondi hayˀi unmuu?” Jesus-di óetu̖ˀan, “Háa u̖ˀbo untú̖ waa.” ");
INSERT INTO tew_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Heḏi in owhaˀ pꞌóˀḏéḏíˀindi báyékí híwóhpîˀ Jesus ônchä̖nundeˀ. ");
INSERT INTO tew_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Heḏáháˀ Pilate-di wíyá óetsikaˀyan, “Ti háabo wíˀuntungíˀopíˀan? Ti nä́ˀi báyékí híwóhpîˀ u̖ˀ wônchä̖nundeḏi wíˀuntꞌoepíˀan?” ");
INSERT INTO tew_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hebo Jesus-á waˀḏi háabo wínatú̖hpí, heḏi Pilate óeháaˀan. ");
INSERT INTO tew_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pa̖a̖yo waagi nä́ˀi Passover shánkíˀeeḏi dínnân dihayḏi, wí wêe pan Pilate-di óemaˀpꞌä̖́ḏíndeˀ, toˀwí in tꞌowa didaˀiˀ. ");
INSERT INTO tew_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wí sen Barabbas gin nakhá̖wä̖́ˀi-áḏí wây-á senäˀdáḏí dipankwꞌó, indá iˀ búˀ iweˀin tꞌowa ovâytꞌeˀyaˀnandi in pꞌóˀḏéḏíˀinbíˀpiye dívíhä́nsaa, heḏi ihayḏi dâytꞌowatꞌahá̖nú. ");
INSERT INTO tew_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","In tꞌowa Pilate-ví núˀpiye dívíhá̖ḏi óedaaˀa̖míḏí ovâyˀa̖míḏí pa̖a̖yo waa iˀo waa. ");
INSERT INTO tew_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate-di ovâytsikaˀyan, “Ti nä́ˀi Jesus wâymaˀpꞌä̖̂ä̖ḏi-íˀin ídaˀ, un Huḏíyoví tsondi hayˀi únmuuˀiˀ?” ");
INSERT INTO tew_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Haˀwâa Pilate natú̖ gá ûnhanginnândân in owhaˀ pꞌóˀḏéḏíˀindi Jesus óethúumáaḏíbo ivíˀwe óemangekánnin. ");
INSERT INTO tew_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hewänbo in owhaˀ pꞌóˀḏéḏíˀindi in tꞌowa báyékí ovâyhéeˀan Pilate óedaaˀa̖míḏí Barabbas-ân óemaˀpꞌä̖̂ä̖ḏi-íḏí, Jesus-á joe. ");
INSERT INTO tew_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Heḏiho Pilate-di wíyá in tꞌowa ovâytsikaˀyan, “Heḏi hânnan dóˀa̖mí nä́ˀiˀ, iˀ bînkhá̖yä̖́ˀdeˀi Huḏíyoví tsondi hayˀi gin?” ");
INSERT INTO tew_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","In tꞌowa dívítu̖wí̖nú, “Wên phéˀwin deeḏi nátꞌóhtä̖gekꞌuˀꞌꞌ” ");
INSERT INTO tew_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate-di ovâytsikaˀyan, “Háaḏan gin dóˀa̖mí? Háawin tꞌaywóˀninnan iˀan?” Indá shánká dívítu̖wí̖nú, “Phéˀwin deeḏi nátꞌóhtä̖gekꞌuˀꞌꞌ” ");
INSERT INTO tew_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate nadaˀ in tꞌowa ovâyhíhchannamíˀin, heḏiho Barabbas óemaˀpꞌä̖́ḏi. Ihayḏá natsonpóe Jesus óewhä̖́ä̖níˀin, heḏi in sundaḏoví mange óejoeˀan phéˀwin deeḏi óetꞌóhtä̖gekꞌúuwíḏí. ");
INSERT INTO tew_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Páaḏé Jesus ee Pilate-ví tunjó tewhá tehpaa búge óetsꞌúḏe, heḏi in wéˀgen sundaḏo tꞌä̖hkí ovâywéˀgetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Heḏi wên pꞌí tsá̖a̖wä̖́ˀin kꞌéwéˀin to óetógi, tsondi hayˀiví aa waagiˀbá namuuˀin, heḏá wên wä̖́ä̖khän dâyˀophíḏéˀannindá óepꞌóhtógi. ");
INSERT INTO tew_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Heḏi óejänäkísengitu̖ˀandi óetu̖ˀan, “Hân unˀä́n, Huḏíyoví tsondi hayˀi unmuuˀiˀ.” ");
INSERT INTO tew_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Heḏi hä̖́yä́nbo pꞌóˀḏé óewhä̖ˀ wên phéḏí, heḏá óeˀohphayḏeˀ, heḏá dívídégeˀdikwꞌóeˀóḏí óeˀaˀgin waa-á dívíˀan. ");
INSERT INTO tew_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Óesúugímáaḏí dívíbowa ihayḏi, in pꞌí tsá̖a̖wä̖́ˀin to óepꞌä̖́ḏiḏi ivîndá óewáytógi. Ihayḏáháˀ iweḏi óehoˀ phéˀwin deeḏi óetꞌóhtä̖gekꞌúuwíḏí. ");
INSERT INTO tew_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ihayḏibá wí sen Simon gin nakhá̖wä̖́ˀiˀ oe nava iweḏi iˀ búˀ eepiye naˀä̖ˀ. I-á Cyrene búˀwi namuu, heḏi Alexander-áḏí Rufus-áḏí iví ây ûnmuu. In sundaḏoḏi nä́ˀi sen óekaygiˀan Jesus-ví phéˀwin ônhûuwíḏí, ");
INSERT INTO tew_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","heḏi Jesus in okú Golgotha gin dâytu̖ˀoˀ iwe óehoˀ. (Nä́ˀin tun Golgotha-á “pꞌóhkhú̖bay” ginnân namuu.) ");
INSERT INTO tew_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Heḏi wí méena-áḏí nä́ˀi woe myrrh gin dâytu̖ˀoˀi-áḏí dawóemuuˀiˀ óemä́gi, hewänbo wíˀisu̖wä̖pí. ");
INSERT INTO tew_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Héḏéndí whä̖nu iwe naná phéˀwin deeḏi óetꞌóhtä̖gekꞌûˀ ihayḏi. In sundaḏo-á dívíˀáywan iví aa dívíweejé-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Heḏi wên phépháˀay phéˀwin kwꞌáye dâytꞌíˀkꞌûˀ eeḏi hä̖ä̖wí dâytaˀnan in tꞌowa dínhanginnáaníḏí hä̖ä̖wí i̖ˀgeḏi óetuhchä̖nundeˀin. “In Huḏíyoví tsondi hayˀiˀ” gin dâytaˀnan. ");
INSERT INTO tew_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Heḏi wên wíje sänmin wáˀ i-áḏí ovä̂ntꞌóhtä̖gekꞌûˀ, iˀ wêe koˀḏíngéḏí, iˀ wêe-á yä̖́ˀmä́ngéḏá. ");
INSERT INTO tew_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Heḏiho gin napóe háa Jôesi Táḏáví taˀnin diwe ûntaˀmuu waa: “I-á wáˀ wí jänäkíkandi-ân namuu” gin tꞌowa ditú̖u̖ní. ");
INSERT INTO tew_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Heḏi in tꞌowa diphaḏeˀnin dívípꞌônwáḏáˀoˀ óeháachannamíḏí, heḏá tꞌä̖mägá óetu̖máa. Ditú̖, “U̖-ân nä́ˀi méesate hayˀi nâanayu̖khâymáawän, heḏi poje thaa iwebo wíyá nâakuhkhâymáawän. ");
INSERT INTO tew_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nää-á wíˀbo ópiˀaywon, hä̖ˀin phéˀwin diweḏi ówhanbe.” ");
INSERT INTO tew_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","In owhaˀ pꞌóˀḏéḏíˀindáḏí heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindáḏí wáˀ Jesus ônpꞌáhkaaḏi ditû̖ˀ, “Wéˀgen tꞌowa-áho iˀḏi ovâyˀaywondeˀ, hewänbo wíˀbo-á ipiˀaywoeníḏí wíˀûnkoḏipí. ");
INSERT INTO tew_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nä́ˀi sendá iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí namuuḏáhoˀ, heḏá Israel nangewi tsondi hayˀi-á namuuḏáhoˀ, i-á ûnkhâyˀä̖ˀ hä̖ˀin phéˀwin diweḏi nawá̖a̖níˀin âymúuníḏí, heḏânho ivíˀpiye ívíwä̖ä̖yú̖-íḏí.” Heḏi in wíje i-áḏí phéˀwin deeḏi dawhiˀkꞌóeˀindá wáˀ óejänäkítu̖máa. ");
INSERT INTO tew_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Taagepiye nanáˀ dihayḏi i̖ˀge tꞌä̖hkí nakhunpóe thíˀêeḏi poje puwahay. ");
INSERT INTO tew_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Heḏi poje iwe napóe ihayḏi, kaygibo Jesus Huḏíyoví tundi natú̖, “Eloi, Eloi, lama sabachthani?” (Nä́ˀi híˀ-á ginnân namuu: Naví Jôesi, naví Jôesi, háaḏan díjoeˀan?) ");
INSERT INTO tew_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wên tꞌowa núˀ diwinnin háa natú̖ waa ditꞌoe, heḏi ditú̖, “Bítꞌôeyan, Elijah óekhá̖yä̖́ˀdeˀ.” ");
INSERT INTO tew_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wí toˀwí iˀä̖ä̖ wên hä̖ä̖wên napꞌohsaaḏeeˀin ikáyjíḏí, heḏi wí méena ojohayˀi iwe ipꞌohtógiḏi wên poesú hayˀin diweḏi ôntege ipꞌohú̖u̖níḏí, heḏi natú̖, “Âymúuní tigú Elijah naˀä̖ä̖-í nä́ˀin phéˀwin diweḏi óewâ̖a̖ve-íḏí.” ");
INSERT INTO tew_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Heḏi Jesus kaygi itu̖wí̖núḏí tꞌä̖ˀgeḏi ihâ̖a̖ˀan. ");
INSERT INTO tew_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ihayḏibá in aa nakhaanáˀnin iˀ méesate hayˀi khóˀjé nawhiˀwonnin nasiveḏee, kwꞌáyeḏibo áagéhay pínu-á nasiveḏee. ");
INSERT INTO tew_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Heḏi iˀ sundaḏo pꞌóˀḏéḏîˀ Jesus-ví páaḏépiye nawindi háḏíḏí Jesus nachuuˀin imûˀ, heḏi natú̖, “Taˀgendi nä́ˀi sendá Jôesi Táḏáví ay ûnmuu.” ");
INSERT INTO tew_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wên kwiyä̖ˀ wáˀ iwe dijiˀ, indá hây kayi̖ˀ diweḏi dâymúndeˀ. Nä́ˀin poje dikhá̖wä̖́ Salome-á, Mary-á (i-á Magdala búˀwi namuu), heḏá wíyá wêe Mary-á (i-á Joses-á heḏá James iˀ tíˀúugéˀi-á inbí jíyá dä́nmuu). ");
INSERT INTO tew_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nä́ˀin poje kwiyä̖ˀ Jesus-áḏí dimändi óekhä̖geˀmáa waˀḏi oe Galilee najiˀ ihayḏi, heḏi nä́ˀindá i-áḏí wây-á kwiyä̖ˀdáḏí Galilee-ḏi Jerusalem-piye wéˀge diˀä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ihay thaa-á in Huḏíyo dívíkhâyˀoˀ, gá wíyá tháwä́ndá kaykhanwówá thaa nanáaníḏân. Heḏi nakinpuwamän dihayḏi wí sen Joseph gin nakhá̖wä̖́ˀi napówá, i-á Arimathea búˀwi namuu, in tunjowaˀ diweḏiˀiˀbá namuu heḏá naˀaˀginmuu, heḏi natsíkhajiˀ Jôesi Táḏáḏí óesôege-íḏí iˀ toˀwí tꞌowa ovâyˀaywoeníˀiˀ. Wesebo khunwôedaˀginpíḏí Pilate-víˀpiye namää iˀ pení óedaaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jesus ho nachuuˀin Pilate natꞌoeḏi hânho óeháaˀan, heḏi in sundaḏoví pꞌóˀḏéḏîˀ óetsikaˀyan háa taˀgendi Jesus nachuuˀin háa joe. ");
INSERT INTO tew_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Óetu̖ˀan nachuu-ákun, heḏiho Joseph iˀ pení óehûuwiˀin óemä́gi. ");
INSERT INTO tew_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Heḏi Joseph wên aa tsꞌä̖ˀin ikumä, heḏi iˀ pení in phéˀwin diweḏi óewá̖veḏi in aaḏi óeˀánnan. Heḏáháˀ iˀ pení wí tꞌowápho dâykíḏi iwe óetógi, heḏi wí kꞌuu hayˀiˀ iˀ pho iwe itiḏisóge. ");
INSERT INTO tew_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene-dá, heḏá wíyá Mary, iˀ Joses-ví jíyá unmuuˀi-á, dä̂nmûˀ wáygé Jesus óekꞌûˀin. ");
INSERT INTO tew_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Iˀ kaykhanwówá thaa naphaḏe ihayḏi Salome-á, Mary Magdalene-dá, heḏá wíyá Mary, i-á James-ví jíyá ûnmuuˀi-á, wí saˀwó nasundiˀ woe dâykumä, Jesus óeˀä̖ä̖yú̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dumîngu iwe héḏéndí héˀḏibo nathanpeeˀä̖ˀ ihayḏi, iˀ tꞌowápho eepiye dimää. ");
INSERT INTO tew_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Waˀ dimän dihayḏi wíˀnä́ táye dívítsikaˀmáa, “Toˀḏan iˀ kꞌuu dînhângeˀa̖mí iˀ tꞌowápho iweḏi?” (Nä́ˀi kꞌuu-á ívíwo hayˀi namuu.) ");
INSERT INTO tew_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Heḏi dívíbéeḏí iˀ kꞌuu ho nahângemuuḏi dâymûˀ. ");
INSERT INTO tew_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Heḏiho ditsꞌú̖ ee tꞌowápho ee, heḏi wí eˀnú wên tsꞌä̖ˀin to whaaḏiˀin natoˀondi koˀḏíngéḏí naˀä́ndí óemûˀ, heḏi ovâypíhä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hebo iˀḏi ovâytu̖ˀan, “Wíˀíkhunwôedaˀípí. Jesus oe Nazareth-wi bîntu̖wä̖máa, iˀ phéˀwin deeḏi óetꞌóhtä̖gekꞌûˀiˀ, hebo i-á nä́ä wínaˀä́npí, i-á nawáywówápóe. Binmúˀḏí hä̖ä̖ óekꞌûˀ iwe. ");
INSERT INTO tew_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bípûn, Peter-á in wéˀgen khä̖geˀnindá bîntu̖ˀâ̖a̖mí, ‘Jesus unbí páaḏé oe Galilee-piye namän, heḏi iwe bînmúuní, háa wovâytu̖ˀan waa.’ ” ");
INSERT INTO tew_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Heḏi iˀ tꞌowápho iweḏi dipeeḏi dijân, ovâypíhä̖ä̖ḏi ditha̖tha̖poeˀo. Hânho dikhunwôedaˀḏi toˀwí wänbo háabo wíḏâytu̖ˀanpí. ");
INSERT INTO tew_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dumîngu nanáˀ diwe Jesus nawáywówápóe ihayḏi, Mary Magdalene-bíˀpiye páaḏé ipikeeyan. Nä́ˀi kwee-á namuu iˀ Jesus-di in tsé ihay yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ ônkhehpiyeˀiˀ. ");
INSERT INTO tew_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Heḏi Mary namääḏi Jesus-ví kꞌemaˀin diboˀaaḏi heḏá diséejiḏi ovâyshaa, heḏi háa ûnpóeˀin ovâytꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hewänbo Jesus nawáywówápóeḏí Mary-ḏi óemûˀin ditꞌoeḏi wíḏívíwä̖yu̖pí. ");
INSERT INTO tew_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesus piháa ûncha̖a̖ḏi wên wíjevíˀpiye ipikeeyan, indá Jerusalem búˀḏí iˀ nava iwepiye dapeemän. ");
INSERT INTO tew_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","In wíje iˀ búˀpiye dänwáybun, heḏi háa dä̂nmûˀ waa in wéˀgen Jesus-ví khä̖geˀnin ovâytꞌôeˀan, hewänbo wíḏívíwä̖yu̖pí. ");
INSERT INTO tew_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tíˀúugéḏí in tä̖ˀḏi wêe khä̖geˀnin dívíhúujoˀ ihayḏi Jesus inbíˀpiye wíyá ipikeeyan, heḏi wä̖yu̖píˀindá pꞌóhkâyˀindá dimuuḏi ovâytꞌeˀyan, in toˀwêndi nawáywówápóeˀin óemûˀin wíˀovâywä̖yundepíḏí. ");
INSERT INTO tew_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Heḏáháˀ ovâytu̖ˀan, “Jaˀ nä́ä oepáa kꞌayḏi tꞌä̖hkí bípûn, heḏá tꞌowa tꞌä̖hká Jôesi Táḏáví híwóˀdi tun bîntunphaaḏé-í. ");
INSERT INTO tew_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tꞌä̖hkí toˀwên dívíwä̖yundeˀindá heḏá ovâypꞌóˀpꞌoeˀannindá ovâyˀaywoení. Hewänbo toˀwên dívíwä̖yundepíˀindá ovâytuhchä̖nukhâymáa. ");
INSERT INTO tew_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","In dívíwä̖yundeˀin naaḏi dovâykꞌúuwí nä́ˀi pínnán tꞌôe dâyˀa̖míḏí: In yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi dâykhehpeeyé-í, heḏá piháawi tundá dívíhéeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Diˀânpíḏíbo dâypä̖́ä̖yu̖hógiḏi, háa hä̖ä̖wí nakheˀtꞌóeˀi dâysu̖wä̖ḏi, háˀto háabo dipúuwí; heḏá inbí mandi in tꞌowa dihayˀindá ovâytä̖geḏi, indá dihehkháapúuwí.” ");
INSERT INTO tew_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Heḏi Jesus iˀ shánkí natsonjiˀiˀḏi ovâyhíˀbowa ihayḏi, makówápiye napee, heḏi Jôesi Táḏáví koˀḏíngéḏí isóge. ");
INSERT INTO tew_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iví khä̖geˀnin iweḏi dimää tꞌowa wä̖́hä̖̂ä̖ tꞌä̖hkí iví tun ovâytꞌôekanhûuwíḏí, heḏi Jôesi Táḏáḏí ovâykhä̖geˀnan, heḏi iˀ pínnán tꞌôe napoeˀoˀiˀḏi in tꞌowa ovâykeeyan taˀge dívíhíˀmáaˀin.");
INSERT INTO tew_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Híwóˀdi kꞌema Theophilus: Báyékí tꞌowa háa dínkoḏi waa dâytanan tꞌä̖hkí iˀ hä̖ä̖wí wáy wên nanbí tíˀûuwin páaḏéˀin páaḏé iweḏibo dâymûˀiˀ. I̖ˀgeḏá naˀin dítu̖ˀan, heḏi á̖yîngiḏi háa dâymûˀ waa dâytaˀnan. ");
INSERT INTO tew_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naa wáˀ hä̖ä̖wí páaḏé iweḏibo nakoḏipóeˀiˀ á̖yîngiḏi dónuwä̖, heḏi naa ochanpóe híwó namúuníˀin u̖gîˀ dótaˀnamíḏí nä́ˀi hä̖ä̖wí háa napóe waagi. ");
INSERT INTO tew_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Naa gin waagi dáyˀoˀ heḏânho úkoḏihanginnáaníḏí iˀ hä̖ä̖wí Jesus-ví̖ˀgeḏi wóehá̖ˀandiˀ taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod oe Judea nange natsonnä́n dihayḏi, wí owhaˀ Zecharias gin nakhá̖wä̖́ˀi naˀä́n. I-áḏí wây-á owhaˀ-áḏí wéˀge dívítꞌôemáa, indá Abijah-ví tꞌowa dimuu. Zechariah-ví kwee-á Elizabeth gin ûnkhá̖wä̖́, heḏi iˀ wáˀ wí owhaˀví ay ûnmuu. ");
INSERT INTO tew_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zechariah-áḏí iví kwee-áḏí inbí wówátsi taˀge dä̂nhon háa Jôesi Táḏá nadaˀ waagibá. Á̖yîngiḏi Jôesi Táḏáví tsontun dä̂nˀaˀgindoˀ heḏá háa Jôesi Táḏá natsonpóe waagibá dänˀan. ");
INSERT INTO tew_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hebo Elizabeth-á âypîˀ namuuḏi wíḏä́nˀayˀä́npí, heḏá nää-á kwijó-á sedó-á dapaa. ");
INSERT INTO tew_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","In Zechariah-ˀinbí thaa dínpóe dívítꞌôeˀa̖míḏí, heḏiho Zechariah-á Jôesi Táḏágîˀ iví owhaˀ tꞌôe iˀoˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","In owhaˀ dâykhá̖wä̖́whahóndeˀ dâydeˀmamíḏí toˀwí Nanbí Sedó Jôesiví méesate hayˀi pingewi íve iwe natsꞌú̖u̖níˀiˀ, iˀ saˀwó nasundiˀ hä̖ä̖wí iphahá̖a̖nú-íḏí. Heḏi nää Zechariah-ví khá̖wä̖́ ônwhahkêˀ, heḏiho natsꞌú̖. ");
INSERT INTO tew_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ee íve iˀe̖e̖yä̖ä̖ˀoˀ ihayḏibá oe jáˀwé báyékí tꞌowa-á dívíjûusuˀoˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tsíkhagipí iˀ mä́äsa koˀḏíngéḏí iˀ e̖e̖yä̖ä̖ nacháˀ diwe wí makówáwi tꞌôepa̖ˀa̖a̖ˀi Jôesi Táḏáchariah-áḏí iví kwee-áḏí ḏí óesandiˀ nakwinuḏee. ");
INSERT INTO tew_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah óepíhä̖ä̖ iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ óemûˀḏi, heḏi khunwôedaˀḏi óemáa. ");
INSERT INTO tew_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hewänbo iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óetu̖ˀan, “Zechariah, wíˀunkhunwôedaˀípí. Jôesi Táḏáḏí uví jûusu wônsígíˀan. Elizabeth uví kwee úmuuˀi wí enúkáy iˀayya̖mí, heḏi John gin nâakhá̖yä̖́ˀní. ");
INSERT INTO tew_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Owáy naˀaypu̖yä̖ ihayḏi báyékí híhchan uvîˀ úmúuní, heḏá báyékí wây-á tꞌowa wáˀ dihíhchanpúuwí. ");
INSERT INTO tew_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","I-á Jôesi Táḏáví heˀennin senäˀ diweḏiˀi namúuní. I-á wíˀûnkhâyˀä̖hpí iméenasu̖u̖wä̖́-íˀin háa wíyá hä̖ä̖wí naháapúuwíˀi-á, heḏi natsꞌanˀaypu̖yä̖ḏiboˀ iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi imáˀve-í. ");
INSERT INTO tew_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iˀḏá báyékí in Israel-win tꞌowa inbí Jôesi iˀ shánkí natsonjiˀi namuuˀivíˀpiyeˀ ovâywáymáˀí. ");
INSERT INTO tew_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Uví ay-á iví píˀnä́ khóˀjé i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ imáˀve-í, Elijah-ḏi iví píˀnä́ khóˀjé óemáa waabá, heḏá Elijah waabá-á natu̖hkáy-í. I-á Nanbí Sedógîˀ napáaḏémú-í Nanbí Sedóví tun wóegé, heḏá táḏáˀindá ovâykhä̖ge̖ˀnamí inbí áyyä̖̂ä̖-á wíyá dâysígí-íḏí, heḏá in ditꞌôeyanhá̖hpíˀindá ánshaa-á ovaymä̂äní heḏânho in toˀwên inbí wówátsi taˀge dâyhonnin waaginbá dimúuníḏí. Iˀḏi in tꞌowa ovâykhâyˀa̖mí heḏânho iˀ shánkí natsonjiˀiˀ óesígíˀa̖míḏí” gin iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi Zechariah óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah-ḏi i makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ óetu̖ˀan, “Hebo hândiḏan taˀgendi dînhanginnáaní nä́ˀi untú̖ˀi napúuwíˀin? Naa ho sedó omuu, naví kwee-á wáˀ hânho kwijó dînmuu.” ");
INSERT INTO tew_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óetu̖ˀan, “Naa Gabriel-ân omuu. Naa hä̖̂ä̖ḏi wänbo tꞌä̖hkí Jôesi Táḏáví núˀ owin. Iˀḏânkun naa dísan wíhéeˀá̖míḏí heḏá nä́ˀi híwó̖ˀdi tun wînmáˀíḏí. ");
INSERT INTO tew_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Híwóˀ ótꞌôeyan. Híwó nanáˀ dihayḏi háa naa otú̖ waa napúuwí. Hewänbo u̖-á nä́ˀi wítu̖ˀandiˀ wíviwä̖yu̖píḏíhoˀ tunpîˀ unpúuwí, iˀ ay naˀaypu̖yä̖ píhay.” ");
INSERT INTO tew_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oe jáˀwé in tꞌowaḏi Zechariah waˀḏi óetsíkhaˀmáa, heḏi dívítu̖máa, “Heháaḏan thaa tꞌä̖hkí óehoˀ iˀ méesate íveḏi napee-íḏí?” ");
INSERT INTO tew_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Heḏi napee ihayḏá wíˀûnhíˀkoḏipí, heḏihoˀ in tꞌowa dínhanginpóe wí hä̖ä̖wí ûnkeepóeˀiˀ iˀ méesate íve imûˀin. Tunpîˀ najoekandeeḏi iví mandiho ovâyhéeˀan. ");
INSERT INTO tew_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wí hä̖́yú̖ thaa naphaḏe ihayḏi iví owhaˀwi tꞌôe ûnboˀwandi ivíˀpiye iweehoˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wí hä̖́yú̖ jâaḏi naphaḏe ihayḏá Zechariah-ví kwee ûnsáhpóe, iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óetu̖ˀan waa, heḏi pꞌánú pꞌóe iví kꞌaygiḏi wínapeepí. ");
INSERT INTO tew_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Heḏi natú̖, “Nanbí Sedó Jôesi Táḏáḏí naagîˀ nä́ˀi dînˀan. Näbâa tꞌôeḏiwän naa-áḏí híwóˀdi namuu. Naa owôedaˀwän wíḏáyˀâyjohpíḏí, hewänbo nää-á naví wôedaˀ dînjâaˀan.” ");
INSERT INTO tew_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth sí pꞌóe nasâamuu ihayḏi Jôesi Táḏáḏí wí makówáwi tꞌôepa̖ˀa̖a̖ˀi Gabriel gin nakhá̖wä̖́ˀiˀ óesan i búˀay Nazareth gin dâytu̖ˀoˀ iwepiye, oe Galilee nange nanáˀ diwe. ");
INSERT INTO tew_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wí khóhtsa̖a̖pîˀ aˀyú̖ Mary gin nakhá̖wä̖́ˀivíˀpiye Gabriel óesan. Mary-áḏí wí sen Joseph-áḏí dakhóhtsa̖a̖tunpä̖ˀän, heḏi Joseph-á David-ví ây iweḏiˀiˀbá namuu. ");
INSERT INTO tew_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Heḏi Gabriel-di nä́ˀi sengitundi Mary óejay: “Híhchandibo unmúuní u̖ Jôesi Táḏáḏí hânho wóesígíˀiˀ. Jôesi Táḏá-á u̖-áḏí najiˀ.” ");
INSERT INTO tew_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary nä́ˀin natꞌoe ihayḏi háa iˀánshaaˀa̖míˀin wíˀishaapí, heḏi napitú̖, “Hângúba nä́ˀi sengitun natundaˀ?” ");
INSERT INTO tew_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Heḏi iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óetu̖ˀan, “Mary, wíˀunkhunwôedaˀípí. Jôesi Táḏáḏí wóesígíˀin wônkeekankhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ótꞌôeyan, u̖-á unsáhpúuwí, heḏi wí enúkáy biˀayya̖mí, i-á Jesus gin nâakhá̖yä̖́ˀní. ");
INSERT INTO tew_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I-á báyékí hayˀi namúuní, heḏi iˀ shánkí kwꞌáyeˀi namuuˀiˀḏi óetu̖ˀâ̖a̖mí ‘Naví ay unmuu’ gin, heḏi Nanbí Sedó Jôesi Táḏáḏíbá tsondi hayˀi óesôege-í, iví hehä̖̂ä̖wi thehtáy pahpâa David-á tsondi hayˀi namuu waagibá. ");
INSERT INTO tew_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Iˀḏá hä̂nhay wänbo tꞌä̖hkí in Israel tꞌowaví tsondi dínmúuní. Iví tsonkhuu-á háˀto hä̂nhay wänbo ûnhá̖a̖ní.” ");
INSERT INTO tew_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary-ḏi iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ óetsikaˀyan, “Hândiḏan nä́ˀi napúuwí waˀḏi wí sendáḏí wóˀthaapíḏí?” ");
INSERT INTO tew_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óetu̖ˀan, “Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ úwá̖a̖ní, heḏi i shánkí kwꞌáyeˀi namuuˀiˀḏi iví pínnándí wóetä̖ä̖gé-í, heḏiho i ay shánkí yä̖ˀḏâaˀi biˀayyandiˀ Jôesi Táḏáví ay gin óetu̖ˀâ̖a̖mí. ");
INSERT INTO tew_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Uví maatuˀi Elizabeth wáˀ sí pꞌóe nasâamuu tobá ho nakwijópaa wänboˀ, heḏi wí enúkáy iˀayya̖mí, tobáháa âypîˀ namuu gin tꞌowa diˀân wänboˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jôesi Táḏá-á hä̖ä̖ tꞌä̖hkí ûnkoḏi.” ");
INSERT INTO tew_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary-ḏi óetu̖ˀan, “Naa Nanbí Sedó Jôesi Táaví tꞌôeˀiˀ omuu. Odaˀ hä̖ä̖ tꞌä̖hkí untú̖ˀi naa dînpúuwíˀin.” Ihayḏihoˀ i makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óejoeˀan. ");
INSERT INTO tew_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wí hä̖́yú̖ thaa ihayḏi Mary ikhâyˀandi wí búˀay iwepiye iwä̖́nähoˀ, iˀ búˀ-á oe Judea nange naˀokúnáˀ niˀge nakꞌóe. ");
INSERT INTO tew_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zechariah-ví tewhá iwepiye namää, heḏi natsꞌûndi Elizabeth óesengitu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth-á Mary-ví sengitun natꞌoe ihayḏi iˀ ay iví seephoge imáaˀiˀ iˀa̖ˀyä̖ˀnan. Elizabeth iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi imáaḏí kaygi natú̖, ");
INSERT INTO tew_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“Jôesi Táḏáḏá u̖gîˀ híwóˀdi hä̖ä̖wí wônˀan, shánkí híwó wänbo tꞌä̖hkí in wéˀgen kwiyä̖ˀgîˀvíˀweḏi, heḏá wáˀ iˀ toˀwí úˀaypu̖yä̖gíˀoˀi híwóˀbá ônˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","U̖-á Nanbí Sedóví jíyá unmuu, heḏiho háaḏan nä́ˀi hä̖ä̖wí hayˀi naa dînpúuwí navîˀ unpu̖wä̖ˀä̖ä̖ḏi? ");
INSERT INTO tew_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ti úhanginná, unpówáḏí uví sengitun otꞌoe ihayḏiboˀ, nä́ˀi ay naví seephoge donmáaˀiˀ nahíhchanpóeḏí iˀa̖ˀyä̖ˀnan. ");
INSERT INTO tew_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Heḏi híhchandi u̖-á unmúuní, gá Jôesi Táḏáví tun wóemä́giˀin úpuwagíˀo gin biwä̖yundeḏân.” ");
INSERT INTO tew_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Heḏi Mary natú̖, “Pín taˀgeḏi otú̖u̖ní Nanbí Sedó Jôesi Táḏá-á hayˀi namuuˀin, heḏi naví píˀnä́ khóˀjé-á hânho ohíhchan gá i-á naví aywondi dînmuuḏân. ");
INSERT INTO tew_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jôesi Táḏáḏí naa iví tꞌôeˀiˀ omuuˀi díˀánshaaˀan, tobá kwꞌáyeˀi wóˀmuupí wänboˀ, heḏi nää thaa iweḏi páaḏépiyá tꞌä̖hkí tꞌowa ditú̖u̖ní iˀḏá naagîˀ híwó dînˀannin. ");
INSERT INTO tew_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Taˀgendi iˀ shánkí tsonkhuu imáaˀiˀḏá báyékí naagîˀ dînˀan. I-á yä̖ˀḏâaˀiḏa̖ˀ namuu. ");
INSERT INTO tew_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jôesi Táḏá-á in toˀwên iˀ óeˀaˀginninbíˀpiye nasehkanäpoeˀo, in ho diˀâypu̖yä̖ˀindá heḏá in diˀâypu̖yä̖gíˀoˀindá wáˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Báyékí nakayḏi heˀendi hä̖ä̖wí iˀoˀ, heḏi in toˀwên inbí píˀnä́ khóˀjé dijêngiˀánshaamuuˀin tꞌä̖mäpiye ovâywáḏéndeˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In toˀwên tsonkhuu dâymáaˀin waa dicha̖a̖ˀin áagépiye iˀḏi ovâywá̖véndeˀ, hewänbo in heˀennin dimuupíˀindá shánkí kwꞌáye ovâytegendeˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","In diha̖hséˀnindá híwóˀdi hä̖ä̖wí ovâymäˀ dishu̖ˀmúuníḏí, hewänbo in koḏitꞌowa dimuuˀindá hä̖ä̖wípíḏíbo-á ovâyjâatä̖ä̖ḏeˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Háa nanbí hehä̖̂ä̖win thehtáy pahpáˀin ovâytu̖ˀan waa iˀoˀ. Naˀin Israel-ˀin iví tꞌôeˀin gimuuˀin díkhä̖geˀdoˀ, heḏi wíˀûnˀóḏepí hä̖̂ä̖ḏi wänbo tꞌä̖hkí Abraham-dáḏí heḏá tꞌä̖hkí Abraham-bí ây iweḏiˀindáḏí ovâysehkanäˀâ̖a̖míḏí” gin Mary natú̖. ");
INSERT INTO tew_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Heḏi Mary poje pꞌóe Elizabeth-víˀweboˀ iwóyí̖ˀ, heḏáháˀ ivíˀpiyá iweehoˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Iˀ thaa Elizabeth iˀayya̖míḏí ûnpówá, heḏi wí enúkáy iˀayyan. ");
INSERT INTO tew_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","In toˀwên iví tsowa dithaaˀindá heḏá iví maatuˀindá dínhanginpóe Nanbí Sedó Jôesi Táḏá ivíˀpiye híwóˀdi namuuˀin, heḏá indá Elizabeth-áḏá dívíhíhchanmáa. ");
INSERT INTO tew_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wí jâaḏi naphaḏe ihayḏi in tꞌowa diwáyˀä̖ä̖, iˀ enúkáy in Huḏíyoví kꞌewe taaḏi óetaaˀa̖míḏí. Iví táḏá Zechariah waabá óekha̖yä̖ˀkhâymáa in tꞌowaḏi, ");
INSERT INTO tew_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","hewänbo iví jíyá ûntú̖, “Haˀwâagá joe. John gân âykhá̖yä̖́ˀní.” ");
INSERT INTO tew_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Indi óetu̖ˀan, “Hewänbo wéˀi wí wänbo uví maatu tꞌowa haˀwâa wínakhá̖wä̖́pí.” ");
INSERT INTO tew_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Heḏi inbí mandi iˀ ayví táḏá óehéeˀan óetsikaˀya̖míḏí hânnan i ay óekhá̖yä̖́ˀníˀin nadaˀ. ");
INSERT INTO tew_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Iˀḏi wên hä̖ä̖wên ovâydaaˀan eeḏi ita̖ˀnamíḏí, heḏi wên phépháˀay ônˀandi ginnân itaˀnan: “John gin iví khá̖wä̖́ ûnmuu.” Tꞌä̖hkíḏíbo ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wesebo nahänjuḏeḏeeḏi nahíˀḏee, heḏi natû̖ˀ Jôesi Táḏá-á hayˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tꞌä̖hkí inbí tsowa dithaaˀin diˀánde hânnangú napóe, heḏá tꞌä̖hkí oe Judea nange naˀokúnáˀ niˀge dithaaˀindá i̖ˀgeḏi dívíhíˀmáa. ");
INSERT INTO tew_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tꞌä̖hkí ditꞌoeˀin nä́ˀi hä̖ä̖wí i̖ˀgeḏi dívíˀánshaamáa, heḏi dívípitsikaˀmáa, “Háawi-angú nä́ˀi ay namúuní?” Heḏi taˀgendi Nanbí Sedó Jôesi Táḏáḏí iví mange iˀ ay óemáa. ");
INSERT INTO tew_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John-bí táḏá Zechariah ûnmuuˀiˀ iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi imáaḏí wí Jôesi Táḏáví tukheˀbi waabá ihéeˀandi ginnân natú̖: ");
INSERT INTO tew_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Jaho gitú̖u̖ní Nanbí Sedó Jôesi Táḏá hayˀi namuuˀin, i-á Israel-ví Jôesi dínmuu, gá naˀin iví tꞌowa gimuuˀinbíˀpiye gínˀä̖ä̖ḏân díkhä̖geˀnamíḏí heḏá nanbí hä́nminbí mangeḏá dímaˀpꞌä̖̂ä̖ḏi-íḏá. ");
INSERT INTO tew_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jôesi Táḏáḏá wí hânho kayˀi aywondi naˀin dímä́gi. David-á hä́nˀoe Jôesi Táḏáví tꞌôeˀi ûnmuu, heḏá nä́ˀi aywondi-á David-ví ây iweḏiˀiˀbá ûnmuu. ");
INSERT INTO tew_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jôesi Táḏáḏí dítꞌôeˀan gin ikhâymáaˀin, heḏi iˀ híˀ iví hä́nˀoeˀin yä̖ˀḏâaˀin tukheˀminbí sóphogeḏi dînsan. ");
INSERT INTO tew_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Natú̖ naˀinbí hä́nminbíˀweḏi dînˀaywoení, in dítꞌayˀinbí mangeḏi díjâaˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Natú̖ nanbí hehä̖̂ä̖win thehtáy pahpáˀinbíˀpiye nasehkanäpúuwí heḏá wáˀ in yä̖ˀḏâaˀin tun Abraham-dáḏí ikꞌûˀindá háˀto ûnˀôeḏe-í. ");
INSERT INTO tew_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Jôesi Táḏáḏí iví tun taˀgendi Abraham óemä́gi nanbí hä́nminbí mangeḏi díwhahóníḏí, heḏânho gínkoeḏí-í khunwôedaˀginpíḏíboˀ iˀ âyˀaˀginmä̂äníḏí, ");
INSERT INTO tew_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","heḏânho gin ívíkanhondibo tꞌä̖hkí naˀinbí wówátsi thaa yä̖ˀḏâaˀin gimúuní, heḏá taˀgebo-á nanbí wówátsi-á âyhûuwí” gin Zechariah natú̖. ");
INSERT INTO tew_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ihayḏá i ay-á óetu̖ˀan, “Naví ay, u̖-á iˀ shánkí kwꞌáye naˀä́ndi namuuˀiví tukheˀbi gin wóetu̖ˀâ̖a̖mí. Heḏá u̖-á iˀ shánkí natsonjiˀiví páaḏé unmú-í in pꞌôe igîˀ mânkhâyˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","U̖ˀḏá iví tꞌowa ovâyhanginˀânnamí ovâyˀaywoeníˀin inbí tꞌaywó̖ˀdi-á dínˀowóˀyendi. ");
INSERT INTO tew_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nanbí Jôesi-á gin iˀa̖mí gá hânho nasehkanätꞌóeḏân, heḏiho iˀ toˀwí iˀ thanbí muwä̖thay waagiˀbá namuuˀiˀ oe kwꞌáyeḏi nanbíˀpiye nakä̖ˀä̖ä̖gíˀo, ");
INSERT INTO tew_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","heḏi in toˀwên in chuwa dâykhunwôedaˀḏi khun niˀge dimännindáho iˀḏi ovâykomä̂äní. Iˀḏáho naˀin díkhä̖geˀkhâymáa heḏânho ánshaaginpíḏíbo giyê̖e̖níḏí” gin Zechariah natú̖. ");
INSERT INTO tew_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","John nasôeḏi iví hangintan wáˀ ûnsôe, heḏi tíˀúugéḏí ihayḏá ahkónu-á nathaa, in Israel-ˀinbí jâa itsꞌantꞌôeˀan píhay. ");
INSERT INTO tew_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","John iˀ pꞌóˀpꞌoekandi naˀaypu̖yä̖ iwáyḏíbá iˀ Rome-wi tsondi shánkí hayˀi Caesar Augustus gin nakhá̖wä̖́ˀiˀḏi tꞌä̖hkí tꞌowa iˀ nange itsonmáa eejewin ovâytꞌôephaḏe dívíkhá̖wä̖́taˀkwogihûuwíḏí. ");
INSERT INTO tew_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nää páaḏé in tꞌowa dívíkhá̖wä̖́taˀkwꞌóḏi Quirinius oe Syria nange natsondimuu ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Heḏiho tꞌä̖hkí tꞌowa inbí thehtáy pahpáˀinbí búˀpiye dimää dívíkhá̖wä̖́taˀkwꞌôeníḏí. ");
INSERT INTO tew_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph wáˀ ikhá̖wä̖́taˀkugihoˀ. I-á Galilee nange nanáˀ diweḏi Nazareth búˀayḏi napee, heḏi wíyá búˀay oe Judea nange Bethlehem gin dâytu̖ˀoˀ iwepiye namää. Joseph-á David-ví ây iweḏiˀiˀbá namuu, heḏi David-á Bethlehem iwewi-á namuu, heḏiho Joseph iwepiye ûnpu̖hpóe. ");
INSERT INTO tew_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Joseph-di Mary i-áḏíbá óehoˀ. Indá dakhóhtsa̖a̖tunpä̖ˀän, heḏi Mary-á nasâamuu. ");
INSERT INTO tew_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bethlehem dajiˀ ihayhä̖̂ä̖bá iˀ thaa napówá Mary iˀayya̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Heḏi iví páaḏéˀiˀ ay iˀayyan, heḏi aaˀây iwe óeˀánnankíḏí i hä̖ä̖panbí húuphébay iwe óekꞌûˀ, gá ee dívíwhoˀkwꞌóeˀóˀi tewhá iwe wínajâanáhpíḏân. ");
INSERT INTO tew_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iwáy búˀay tsowa wáy wên kꞌúwá á̖yí̖ˀnin dikwꞌó, indá khu̖ˀḏéeḏí oe ahkónu inbí kꞌúwá dâyˀá̖yînmáa. ");
INSERT INTO tew_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jôesi Táḏáḏí wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ inbíˀpiye ovâysan, heḏi inbí páaḏépiye tsíkhagipí dínkwi̖nuḏee, heḏi Nanbí Sedó Jôesiví kohthayḏi ovâyˀánhógiḏi hânho dikhunwôedaˀpóe. ");
INSERT INTO tew_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Heḏi iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi ovâytu̖ˀan, “Wíˀíkhunwôedaˀípí. Bítꞌôeyan, naaḏá híwóˀdi tun wâymáˀ, tꞌä̖hkí tꞌowa hânho ovâyhíhchannamíḏí. ");
INSERT INTO tew_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nää thaa oe David-ví búˀ wí aywondi ungîˀ naˀaypu̖yä̖. I-á iˀ toˀwí namuu Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, i-á iˀ shánkí natsonjiˀi namuu. ");
INSERT INTO tew_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Heḏi nä́ˀin bînmúuní únhanginnáaníḏí háa wáytu̖ˀan waa taˀgen namuuˀin: Wí ay bînshaa-í aaˀây iwe naˀánmuuḏi, hä̖ä̖panbí húuphébay iwe nakꞌóeḏí.” ");
INSERT INTO tew_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tsíkhagipí iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀi-áḏí wây-á báyékí mákówáwin tꞌôepa̖ˀa̖a̖ˀin dikeepóe. Tꞌä̖hkíḏíbo Jôesi Táḏáví̖ˀgeḏi híwó dívíhíˀmáaḏí ditû̖ˀ, ");
INSERT INTO tew_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Makówá kwꞌáayé tꞌä̖hkí ditú̖u̖ní Jôesi Táḏá-á hânho hayˀi namuuˀin, heḏi nä́ä oepáa kꞌayḏá in toˀwên Jôesi Táḏá óehíhchanmäˀindá ánshaaginpíḏíbo dikwoní.” ");
INSERT INTO tew_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","In makówáwin tꞌôepa̖ˀa̖a̖ˀin makówápiye diwáypee ihayḏi in kꞌúwá á̖yí̖ˀnin wíˀnä́ táye dívítu̖máa, “Jaho Bethlehem-piye gimú-í nä́ˀin napóeˀin âymúuníḏí, i̖ˀgeḏi Nanbí Sedó Jôesi Táḏáḏí naˀin díhanginˀânnan.” ");
INSERT INTO tew_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Heḏiho dívíwä̖́nähoˀḏi Mary-á Joseph-á heḏá iˀ ay ee hä̖ä̖panbí húuphébay iwe nakꞌóeḏá ovâyshaa. ");
INSERT INTO tew_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iˀ ay óemûˀ ihayḏi háa in makówáwin tꞌôepa̖ˀa̖a̖ˀindi iví̖ˀgeḏi ovâytu̖ˀan waa ditunjiˀ. ");
INSERT INTO tew_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tꞌä̖hkí in iwe dijiˀin ovâyháaˀan iˀ hä̖ä̖wí in kꞌúwá á̖yí̖ˀnindi ovâytꞌôeˀandi ditꞌoeḏi. ");
INSERT INTO tew_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary-á nä́ˀi hä̖ä̖wí tꞌä̖hkí napóeˀi wíˀûnˀóḏepí, heḏi hä̖̂ä̖ḏi wänbo tꞌä̖hkí i̖ˀgeḏi iˀánshaamáa. ");
INSERT INTO tew_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","In kꞌúwá á̖yí̖ˀnin inbí kꞌúwá dijiˀ iwepiye diwáymää, heḏi Jôesi Táḏá-á kwꞌáayéboˀ óemáaḏí ditû̖ˀ hânho hayˀi namuuˀin, gá nä́ˀiˀ hä̖ä̖wí dâymûˀi-á ditꞌoeˀi-á namuuḏân. Tä̖hkí háa i makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi ovâytu̖ˀan waagibá napóe. ");
INSERT INTO tew_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wí jâaḏi naphaḏe ihayḏi iˀ ay in Huḏíyoví kꞌewe taaḏi óetaaˀan, heḏi Jesus gin óekhá̖yä̖́ˀ. Nä́ˀin khá̖wä̖́-á iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óemä́gi waˀḏi iví jíyá ûnsáhpóepíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Heḏi ihayḏiho napóe dänˀa̖míḏí háa Moses itaˀnan waa, in Huḏíyo inbí khuu dínmuuḏi dínkhâyˀä̖ˀ dívíˀa̖míˀin wí ay naˀaypu̖yä̖ ihayḏi, heḏihoˀ iˀ ay oe Jerusalem-piye dä̂nhoˀ, iˀ méesate hayˀi iwe Jôesi Táḏá óetu̖ˀâ̖a̖míḏí, “Nanbí ay wímä̂äní.” ");
INSERT INTO tew_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Gin dä̂nˀan gá nä́ˀin tsontun Jôesi Táḏáví taˀnin diwe ûnkꞌóeḏân: Tꞌä̖́hkí in páaḏé diˀâypu̖yä̖ˀin eˀnûn áyyä̖̂ä̖-á Jôesi Táḏá óemä̂äní. ");
INSERT INTO tew_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Heḏá wáˀ nataˀmuu in jíyáˀindá wíje kꞌoˀwee háa wíje tsíḏéˀây haˀwâagiˀin dâyhûuwí, heḏi nä́ˀin tsíḏé dâyhayḏi Jôesi Táḏá óemä̂äní. Heḏiho Mary-á wáˀ han ikhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oe Jerusalem wí sen nathaa Simeon gin nakhá̖wä̖́ˀiˀ. Iví wówátsi-á taˀge ihon, heḏá Jôesi Táḏáví khuu-á ônˀaˀgin. Natsíkha Jôesi Táḏáḏí in Israel-ˀin inbí tꞌôephaḏe iweḏi ovâywhahóeníḏí, heḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ i-áḏí najiˀ. ");
INSERT INTO tew_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏibá Simeon óehanginˀânnan wínachuwagíˀopíˀin iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí óemûˀpíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi iˀ hayˀi méesate ee Simeon óetsꞌúḏe. Jesus-ví jíyá-áḏí táḏá-áḏí iˀ wáˀ óetsꞌúḏe, heḏânho indi igîˀ ônˀa̖míḏí háa nakhâyˀä̖ˀin Jôesi Táḏá natsonpóe waagibá. ");
INSERT INTO tew_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ditsꞌú̖ˀ dihayḏi Simeon-di iˀ ay óekêˀ, heḏi Jôesi Táḏá óekú̖ˀdaaˀandi ginnân natú̖: ");
INSERT INTO tew_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nanbí Sedó Jôesi, näbâa hîn naa uví tꞌôeˀiˀ omuuˀi híhchandi díchuwamä́ä, uví tun bimä́gi waagibá. ");
INSERT INTO tew_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Naa ohíhchan, gá nää-á naví tséeḏí iˀ aywondi u̖ˀḏi dînsandiˀ dópimûˀḏân. ");
INSERT INTO tew_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Heḏi nä́ˀindá biˀan tꞌä̖hkí nangeˀin tꞌowa dâymúuníḏí. ");
INSERT INTO tew_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nä́ˀi aywondi-á wí ko waagibá namúuní uví pꞌôe in Huḏíyo dimuupíˀin ovâykeeya̖míḏí, heḏi iˀ namuuḏi uví tꞌowa Israel-ˀindá heˀennin dipúuwí.” ");
INSERT INTO tew_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Gin Simeon iˀ ayví̖ˀgeḏi ihéeˀandi iˀ táḏá-á jíyá-á hânho ovä̂nháaˀan. ");
INSERT INTO tew_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Heḏáháˀ Simeon-di Jôesi Táḏá óedaaˀan híwóˀdi thaa ovä̂nmä̂äníḏí, heḏá Mary-á óetu̖ˀan, “Wáy wên in Israel-ˀin iˀ óesígíkáyjí, heḏiho ovâyˀaywoení, hebo wây-á wêndá wíˀóesígíkáyjípí heḏiho dipeḏee-í. Iˀḏá tꞌä̖hkí tꞌowa háa Jôesi Táḏá nadaˀ waagi ovâykeeya̖mí, hewänbo in tꞌowaḏá óejoegikhâymáa, ");
INSERT INTO tew_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","heḏi báyékí tꞌowa háa inbí píˀnä́ khóˀjé diˀánshaamuu waa ovâykeeya̖mí. Heḏi u̖-á báyékí mäntꞌôephaḏekhâymáaḏí wí toˀwíḏí wí tsijó pháˀḏí uví pín wônjún waagibá uncha̖a̖-í.” ");
INSERT INTO tew_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Heḏá iwebá wí kwee Anna gin nakhá̖wä̖́ˀi wáˀ najiˀ, i-á wí Jôesi Táḏáví tukheˀbibá namuu. Nä́ˀi kwee-á Phanuel-ví aˀyú̖ ûnmuu, heḏi Asher-á iví hehä̖̂ä̖wi thehtáy pahpâa ûnmuu. ");
INSERT INTO tew_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tsé ihay pa̖a̖yo nakhóhtsa̖a̖ˀä́nwän, heḏi khávéntä̖ˀḏi jónu (84) pa̖a̖yo ûnná iví sen ûnchuu iweḏi. Hä̖̂ä̖ḏi wänbo tꞌä̖hkí iˀ méesate hayˀi iwe najiˀ, heḏi hä̖́yä́nboˀ iha̖a̖ḏä́ˀoḏá ijûusuˀoḏá khu̖u̖-á thaa-á Jôesi Táḏá óeˀaˀginmäˀ. ");
INSERT INTO tew_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Waˀḏi Simeon ihíˀmáa ihayḏibá iˀ kwee natsꞌú̖, heḏi iˀ aygîˀ Jôesi Táḏá óekú̖ˀdaaˀan, heḏá iví̖ˀgeḏá ovâytꞌôeˀan tꞌä̖hkí in Jerusalem-win ditsíkhakwꞌóˀnin Jôesi Táḏáḏí ovâymaˀpꞌä̖̂ä̖ḏi-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph-áḏí Mary-áḏí dänˀan háa Nanbí Sedó Jôesiví tsontun diwe nakꞌóe waagibá, ihayḏáháˀ inbí búˀay Nazareth-piye dänweehoˀ, i-á Galilee nangá nakꞌóe. ");
INSERT INTO tew_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Heḏi iˀ ay nasôˀḏi nakaypoeˀo heḏá báyékí hangintandá imáa, heḏá Jôesi Táḏáḏá báyékí óekhä̖geˀmáa. ");
INSERT INTO tew_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pa̖a̖yo pꞌóe waagi iˀ Passover shánkíˀeeḏi dínnáˀ dihayḏi, Jesus-ví jíyá-á táḏá-á oe Jerusalem-piye damääˀä̖. ");
INSERT INTO tew_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Heḏiho Jesus tä̖ˀḏi wíje (12) pa̖a̖yoˀi namuu ihayḏi Jerusalem-piye dimää, hä̖̂ä̖ḏi waa dívíˀo waagibá. ");
INSERT INTO tew_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iˀ shánkíˀeeḏi dínkꞌeweˀ dihayḏi in tꞌowa dívíweehondi, Jesus-á Jerusalem-bo iwóyí̖ˀ. Hewänbo iví táḏá-á jíyá-á wíḏä́nhanginnáhpí iwe iwóyí̖ˀnin. ");
INSERT INTO tew_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Indá daˀánde wây-á tꞌowa indáḏíbá dimännindáḏí najiˀin, heḏi wí thaa tꞌä̖hkí Jerusalem diweḏi damää. Ihayḏi inbí kꞌemaˀin deeje heḏá inbí maatuˀin deejá óenuwä̖, ");
INSERT INTO tew_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","hewänbo wíˀóeshaapíḏí Jerusalem-piye dänwáybun óenuuwä̖́-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wíje thaa naphaḏe ihayḏi iˀ méesate hayˀi ee in Huḏíyoví há̖hkannindáḏí óeshaa. Háa dívíhíˀmáaˀin iˀḏi ovâytꞌôeyande heḏáháˀ báyékí hä̖ä̖wí ovâytsikaˀmáa. ");
INSERT INTO tew_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iví hangintandá heḏá iví híˀ in há̖hkannin ovâytu̖máaˀiˀḏá tꞌä̖hkí tꞌowa ditꞌoeˀin ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iví táḏá-á jíyá-á wíḏä́nhanginnáhpí háa dänˀánshaaˀa̖míˀin. Iví jíyáḏí óetu̖ˀan, “Naví ay, háaḏan gin naˀin díˀan? Ti wíˀúhanginnáhpíˀan u̖ˀḏi báyékí á̖yîngi uví táḏá-áḏí naa-áḏí dímä́gi, heḏá tꞌä̖mäpiye wítu̖wä̖máa?” ");
INSERT INTO tew_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus-di ovä̂ntu̖ˀan, “Ti wíḏä́nhanginnáhpíˀan naa dînkhâyˀä̖ˀ naví Táḏáví tewhá ee ochaníˀin?” ");
INSERT INTO tew_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hewänbo háa ovä̂ntu̖ˀannin wíḏakaˀpówápí. ");
INSERT INTO tew_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iví táḏá-á jíyá-á indáḏíbá oe Nazareth-piye nawáymää, heḏi tꞌä̖hkí háa óetu̖ˀan waa iˀaˀgindoˀ. Iví jíyá nä́ˀi hä̖ä̖wí tꞌä̖hkí napóeˀi wíˀûnˀóḏéndepí. ");
INSERT INTO tew_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Heḏi Jesus-á nasôemändi shánkí báyékí hangintandá ihóndeˀ, shánkí nasenpuwamän, heḏi Jôesi Táḏá-áḏí in tꞌowa-áḏí shánkí wänbo óesígí. ");
INSERT INTO tew_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Tiberius Caesar tꞌä̖hkí iˀ Rome-wi nange tä̖ˀḏi pꞌánú (15) pa̖a̖yoḏi natsonjiˀ ihayḏi, Zechariah-ví ay John iˀ pꞌóˀpꞌoekandiˀ oe ahkónu najiˀ, heḏi Jôesi Táḏáḏí óetu̖ˀan iví híˀ ôntꞌôeˀa̖míḏí. Ihayhä̖̂ä̖bá Pontius Pilate Judea nangewi tunjó namuu, Herod-á oe Galilee nangá natsonnä́n, Herod-ví tíˀûu Philip-á oe Iturea nange heḏá Trachonitis nangá natsonnä́n, Lysanius-á oe Abilene nangá natsonnä́n, heḏá Annas-áḏí Caiaphas-áḏí owhaˀ pꞌóˀḏéḏíˀindá damuu. ");
INSERT INTO tew_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Heḏi John tꞌä̖mäpiye Jordan pꞌoˀkꞌay tsowa i̖ˀge najiḏi in tꞌowa Jôesiví tun ovâytꞌôekanhon. Ovâytu̖máa, “Unbí tꞌaywóˀdi binjoeˀan heḏânho Jôesi Táḏáḏí wovâyˀowóejé-íḏí, heḏá naaḏá wâypꞌóˀpꞌoeˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Heḏi nä́ˀi háa John iˀo waa Jôesi Táḏáví tukheˀbiˀ Isaiah iví taˀnin diwe ho itaˀnan. Ginnân ûntaˀmuu: Wí toˀwí oe ahkon deeḏi ûntu̖hkwíntú̖u̖ní, ‘In pꞌôe binkhâyˀan iˀ shánkí natsonjiˀigîˀ. Hä̖ˀi pꞌôeˀây wáˀ igîˀ bintaˀgeˀan. ");
INSERT INTO tew_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tꞌä̖hkí hége̖ˀây napiḏeḏee-í. Tꞌä̖hkí okú-á pꞌindá natayeḏipúuwí. Wáy namäägináˀ deejá nataˀgepúuwí, heḏi iˀ pꞌôe nabôebôenáˀdiˀ nataˀgepúuwí. ");
INSERT INTO tew_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Heḏi tꞌä̖hkí tꞌowa dâymúuní Jôesi Táḏáḏá tꞌowa ovâyˀaywondeˀin.’ ");
INSERT INTO tew_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hânho báyékí tꞌowa dimääˀä̖ John-di ovâypꞌóˀpꞌoeˀa̖míḏí. Iˀḏi ovâytu̖máa, “Un pä̖́ä̖yu̖ wí phaa iweḏi íshavemännin waaginbá ímuuˀin, toˀḏan wovâytu̖ˀan háa úvíˀa̖míˀin, heḏânho Jôesi Táḏáḏí wíwovâytuhchä̖ä̖nú-ípíḏí? ");
INSERT INTO tew_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Híwó úvíˀâ̖a̖mí heḏânho nakeepúuwíḏí unbí tꞌaywóˀdi taˀgendi bînjoeˀannin. Wíˀíjêngitú̖u̖nípí, ‘Abraham-bí ây iweḏiˀinbá gimuu.’ Nä́ˀin wâytu̖ˀa̖mí, Jôesi Táḏá-á nadaˀḏáho ûnkoḏi nä́ˀi kꞌuu nä́äyé nakꞌwóˀdiḏi wây-á Abraham-bí ây ovâypaˀíḏí. ");
INSERT INTO tew_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nääho gin waagibá napoeˀo: Wí kꞌuuwée-á ho nakhâymuu wí tay púu núˀ óetsꞌâa-íḏí. Tꞌä̖hkí iˀ tay nabaypoeˀopîˀ-á óetsꞌâa-í, heḏi phaa iwe óechä̖ä̖nú-í.” ");
INSERT INTO tew_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Heḏi in tꞌowaḏi óetsikaˀyan, “Hân gínkhâyˀä̖ˀ ívíˀa̖míˀin háa untú̖ waa wígínpúuwípíḏí?” ");
INSERT INTO tew_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Iˀḏi ovâytu̖ˀan, “Gá ginnân: Wí toˀwí wíje kꞌéwéˀin to ûnkꞌóeḏáhoˀ, i-á ûnkhâyˀä̖ˀ wéhpêe wí toˀwí ûnkꞌóepîˀ óemä̂äníˀin. Heḏi wí toˀwí ûnkoegîˀbáˀyendi-áho ûnkhâyˀä̖ˀ wí toˀwí ûnkoegîˀkwꞌóhpîˀ óemä̂äníˀin.” ");
INSERT INTO tew_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wên tax phahsannin ivíˀpiye dimää ovâypꞌóˀpꞌoeˀa̖míḏí, heḏi ditsikapóe, “Há̖hkandiˀ, heyâa naˀindá, hân ívíˀa̖mí?” ");
INSERT INTO tew_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Iˀḏi ovâytu̖ˀan, “Iˀ chä̖ˀ hä̖́yú̖ unbí tsonnindi wovâytu̖ˀan ihayḏa̖ˀmân bînwéˀgeˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Heḏá wên sundaḏo-á ditsikapóe, “Heyâa naˀindá, hândá ívíˀa̖mí?” Iˀḏi ovâytu̖ˀan, “Hä̖́yú̖ wovâywáˀâaˀiˀḏi bíhíhchannan. Tꞌowa wívînkaygiˀa̖mípí wíyá shánkí wovâymä̂äníḏí, heḏiháa in tꞌowa híwóhpí wíḏívíˀanpíḏáhoˀ, wíˀovâytu̖ˀâ̖a̖mípí híwóhpí dívíˀannin wí chä̖ˀ inbíˀweḏi bînhóeníḏí.” ");
INSERT INTO tew_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","In tꞌowa dichanpoeˀo wí hä̖ä̖wí hayˀi napuwagíˀo waagibá, heḏi John i pꞌóˀpꞌoekandiví̖ˀgeḏi báyékí dívíˀánshaamáa, tigúba i-ân namuu iˀ toˀwí Jôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Heḏi John-di tꞌä̖hkíḏíbo ovâytu̖ˀan, “Naaḏi pꞌoeḏiḏa̖ˀ wâypꞌóˀpꞌoeˀoˀ, hewänbo wí toˀwí naví shánkí tsonkhuu imáaˀi napowagíˀo, naa ihay híwóˀdi wóˀmuupí iví anto wänbo dônpꞌä̖̂ä̖ḏi-íḏí. Iˀḏá wíyá piˀwí pꞌóˀpꞌoekan waagibá wovâymä̂äní. Wáy wên un iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ wovâymä̂äní, wáy wêndá phaaḏá wovâytuhchä̖ä̖nú-í. ");
INSERT INTO tew_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I-á nakhâymuu tꞌowa ovâyweejé-íḏí, wí toˀwí iˀ táhtân iˀ tákhowa iweḏi iwijende waagibá. Iˀ táhtân iwéˀgeˀan dihayḏi tebay iwe ikuu-í, hewänbo iˀ tákhowa-á wí phaa hä̂nhay wänbo naphahpa̖a̖ḏipîˀ iwe ichꞌâaní.” ");
INSERT INTO tew_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Shánkí wíyá tun giˀbibá John-di kayˀindi in tꞌowa ovâyhéeˀan, Jôesi Táḏáví híwó̖ˀdi tun ovâytꞌôeˀoḏi. ");
INSERT INTO tew_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Heḏá John-di Herod wáˀ óetu̖ˀan iˀ kwee Herodias-áḏí tꞌaywó iˀannin. Tobá Herodias-á Herod-ví tíˀûuví kwee ûnmuu wänboˀ ônkêˀ. Báyékí wíyá tꞌaywóˀdi-á Herod iˀan, heḏá wáˀ John óepansóge, heḏi nä́ˀin in shánkí pꞌä́ndíkîˀ iˀannin namuu. ");
INSERT INTO tew_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","John-di tꞌä̖hkí in tꞌowa ovâypꞌóˀpꞌoeˀoˀ ihayḏi Jesus wáˀ óepꞌóˀpꞌoeˀan. Heḏi iwebá Jesus ijûusuˀoˀ ihayḏi makówá nakhuuḏee, ");
INSERT INTO tew_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","heḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ wí kꞌoˀwee waagibá natúˀmuuḏi nawândi Jesus-vîˀḏi isóge, heḏá wí tun makówáḏí napeeḏi ginnân natú̖: “U̖-á naví ay wísígíˀi-ân unmuu. Hânho u̖ˀḏi ohíhchan.” ");
INSERT INTO tew_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus-á maḏi powintä̖ (30) pa̖a̖yoˀi namuu páaḏé itsꞌanhá̖hkanjíyé ihayḏi. Tꞌowa-á diˀân i-á Joseph-ví ay namuuˀin. Joseph-á Heli-ví ay ûnmuu. ");
INSERT INTO tew_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli-á Matthat-ví ay ûnmuu, Matthat-á Levi-ví ay ûnmuu, Levi-á Melchi-ví ay ûnmuu, Melchi-á Jannai-ví ay ûnmuu, Jannai-á Joseph-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph-á Mattathias-ví ay ûnmuu, Mattathias-á Amos-ví ay ûnmuu, Amos-á Nahum-bí ay ûnmuu, Nahum-dá Esli-ví ay ûnmuu, Esli-á Naggai-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai-á Maath-ví ay ûnmuu, Maath-á Mattathias-ví ay ûnmuu, Mattathias-á Semein-bí ay ûnmuu, Semein-dá Josech-ví ay ûnmuu, Josech-á Joda-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda-á Joanan-bí ay ûnmuu, Joanan-dá Rhesa-ví ay ûnmuu, Rhesa-á Zerubbabel-ví ay ûnmuu, Zerubbabel-á Shealtiel-ví ay ûnmuu, Shealtiel-á Neri-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri-á Melchi-ví ay ûnmuu, Melchi-á Addi-ví ay ûnmuu, Addi-á Cosam-bí ay ûnmuu, Cosam-dá Elmadam-bí ay ûnmuu, Elmadam-dá Er-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er-á Joshua-ví ay ûnmuu, Joshua-á Eliezer-ví ay ûnmuu, Eliezer-á Jorim-bí ay ûnmuu, Jorim-dá Matthat-ví ay ûnmuu, Matthat-dá Levi-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi-á Simeon-bí ay ûnmuu, Simeon-dá Judah-ví ay ûnmuu, Judah-á Joseph-ví ay ûnmuu, Joseph-á Jonam-bí ay ûnmuu, Jonam-dá Eliakim-bí ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim-dá Melea-ví ay ûnmuu, Melea-á Menna-ví ay ûnmuu, Menna-á Mattatha-ví ay ûnmuu, Mattatha-á Nathan-bí ay ûnmuu, Nathan-dá David-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David-á Jesse-ví ay ûnmuu, Jesse-á Obed-ví ay ûnmuu, Obed-á Boaz-ví ay ûnmuu, Boaz-á Salmon-bí ay ûnmuu, Salmon-dá Nahshon-bí ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon-dá Amminadab-ví ay ûnmuu, Amminadab-á Ram-bí ay ûnmuu, Ram-dá Hezron-bí ay ûnmuu, Hezron-dá Perez-ví ay ûnmuu, Perez-á Judah-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah-á Jacob-ví ay ûnmuu, Jacob-á Isaac-ví ay ûnmuu, Isaac-á Abraham-bí ay ûnmuu, Abraham-dá Terah-ví ay ûnmuu, Terah-á Nahor-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor-á Serug-ví ay ûnmuu, Serug-á Reu-ví ay ûnmuu, Reu-á Peleg-ví ay ûnmuu, Peleg-á Eber-ví ay ûnmuu, Eber-á Shelah-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah-á Cainan-bí ay ûnmuu, Cainan-dá Arphaxad-ví ay ûnmuu, Arphaxad-á Shem-bí ay ûnmuu, Shem-dá Noah-ví ay ûnmuu, Noah-á Lamech-ví ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech-á Methuselah-ví ay ûnmuu, Methuselah-á Enoch-ví ay ûnmuu, Enoch-á Jared-ví ay ûnmuu, Jared-á Mahalaleel-ví ay ûnmuu, Mahalaleel-á Cainan-bí ay ûnmuu, ");
INSERT INTO tew_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan-dá Enos-ví ay ûnmuu, Enos-á Seth-ví ay ûnmuu, Seth-dá Adam-bí ay ûnmuu, Adam-dá Jôesi Táḏáví ay ûnmuu. ");
INSERT INTO tew_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi imáaḏí in Jordan pꞌoˀkꞌay nanáˀ diweḏi nawáymää, heḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi ahkónupiye óehoˀ. ");
INSERT INTO tew_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Iwe jónä́ntä̖ (40) thaa iˀ Penísendi ikhä̖ä̖ḏeˀ óetꞌaywóhkannamíḏí. Iˀ jónä́ntä̖ thaa tꞌä̖hkí hä̖́ä̖bo wíˀikꞌoepí, heḏi tꞌä̖hkí iˀ thaa naphaḏe ihayḏi ha̖a̖ḏi óemáa. ");
INSERT INTO tew_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Heḏi Penísendiḏi óetu̖ˀan, “Jôesi Táḏáví ay unmuuḏáho nä́ˀi kꞌuu nä́we nakwꞌóˀdi nâajôení napávápaˀíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus-di óetu̖ˀan, “Joe, háˀto gin dáyˀa̖mí. Jôesi Táḏáví ta̖ˀnin diwe ûntû̖ˀ, Tꞌowa-á wíyá shánkí díntáy pávávíˀweḏi heḏânho in koḏi wówátsi dâymáˀve-íḏí.” ");
INSERT INTO tew_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Heḏáháˀ iˀ Penísendiḏá owáy kwꞌáyepiye nanáˀ diwe Jesus óepiye, heḏi tꞌä̖hkí nange nä́ä oepáa kꞌayḏi wémûuḏiboˀ ônkeeyan, ");
INSERT INTO tew_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","heḏi óetu̖ˀan, “Naaḏi tꞌä̖hkí tsonkhuu tꞌä̖hkí nä́ˀi nan deeje wímä̂äní, inbí saˀwóˀdi hä̖ä̖wí wóegé. Nä́ˀi-á tꞌä̖hkí naví mange dînkwꞌóḏihoˀ, heḏi toˀwí naa odaˀi dómä̂äní. ");
INSERT INTO tew_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Heḏânho naví páaḏépiye bidégeˀdisógeḏi díˀaˀginmä̂äníḏí, nä́ˀi tꞌä̖hkí uvîˀ úmúuní.” ");
INSERT INTO tew_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus-di óetu̖ˀan, “Joe, háˀto gin dáyˀa̖mí. Jôesi Táḏáví taˀnin diwá ginnân ûntaˀmuu: Jôesi Táḏá iˀ shánkí natsonjiˀiˀbá namuuḏi bînˀaˀginmä̂äní. I-á unbí Jôesi únmuu, heḏiho iˀḏa̖ˀmân bînˀaˀgeení.” ");
INSERT INTO tew_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ihayḏá Penísendiḏá Jesus-á oe Jerusalem-piye óehoˀ, heḏi iˀ méesate hayˀi shánkí natu̖ˀwän deeḏi óepiye, heḏi óetu̖ˀan, “Jôesi Táḏáví ay unmuuḏá nä́weḏi ókeˀtꞌave, ");
INSERT INTO tew_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","gá Jôesi Táḏáví taˀnin diwe gin nataˀmuuḏân: Jôesi Táḏá iví makówáwin tꞌôepa̖ˀa̖a̖ˀin itu̖ˀa̖mí wóeˀá̖yîngiˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Heḏá gin wáˀ nataˀmuu: Indiḏânho inbí man diwe wóeyâ̖a̖-í heḏânho kꞌuu eeḏi wíviˀânchä̖ä̖nú-ípíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus-di óetu̖ˀan, “Joe, háa untú̖ waa háˀto dáyˀa̖mí, gá iví ta̖ˀnin diwebá ûntû̖ˀdân, Uví Jôesi iˀ shánkí natsonjiˀi namuuˀi wínâatayi̖ˀnípí nâamúuníḏí háa in natú̖ˀin iˀa̖míˀin háa joe.” ");
INSERT INTO tew_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tꞌä̖mäge háa Jesus óetꞌaywóhkannamíḏí Penísendi ikhä̖ä̖ ihayḏi Jesus-víˀweḏi ijâaˀan wíyá wáygéḏí puwahay. ");
INSERT INTO tew_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏá Jesus báyékí pínnán óemä́gi, heḏi Galilee-piye iwáybun. Tꞌä̖mäpiye iˀ búˀ eeje tꞌä̖hkí tꞌowa Jesus-ví̖ˀgeḏi ditꞌoe, ");
INSERT INTO tew_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","heḏi tꞌä̖hkí Huḏíyoví méesate eeje iˀḏi ovâyhá̖ˀoˀ, heḏi tꞌä̖hkí tꞌowaḏi kwꞌáayéboˀ óemáa. ");
INSERT INTO tew_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesus oe Nazareth búˀay napówá, nasôe iweˀi búˀ namuu. Iˀ kaykhanwówá thaa in Huḏíyoví méesateˀay ipiye namää, hä̖̂ä̖ḏi wänbo tꞌä̖hkí iˀo waagibá. Iwí̖nú Jôesi Táḏáví ta̖ˀnin diweḏi in tꞌowa ovâytunnamíḏí, ");
INSERT INTO tew_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","heḏi indi in taˀnin Jôesi Táḏáví tukheˀbi Isaiah itaˀnannin ônˀan, heḏi imahsanusuuḏi nä́ˀi híˀ nataˀmuu iwe ishaa: ");
INSERT INTO tew_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","Nanbí Sedó Jôesi Táḏáḏí iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ naa dînsan, heḏiho i-á naa-áḏí najiˀ, gá naa dídeˀmandân in sehkanäwó diwówájiˀin tꞌowa iví híwóˀdi tun dovâytꞌôeˀa̖míḏí. Iˀḏi naa dísan in pan dovâytꞌôeˀa̖míḏí dovâymahpä̖ḏikhâymáaˀin, in tsíˀtꞌaaˀindá inbí keetandá dâywáykáyjíḏí, in áagé diwha̖ˀvennindá dovâywáytaygé-íḏí, heḏá tꞌowa-á dovâytu̖ˀâ̖a̖míḏá ihayḏiho naná Nanbí Sedóḏí ovâykeeya̖míḏí hânho híwóˀdi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Heḏáháˀ Jesus in taˀnin iwáymahsanu, heḏi iˀ méesate iwewi khä̖geˀdiˀ ônwáyˀandi isóge. Tꞌä̖hkí ee méesdiwówájiˀin tꞌowa iví híwóˀdi tun dovâytꞌôeˀa̖míḏí. Iˀḏi naa dísan in pan dovâytꞌôeˀa̖míḏí dovâymahpä̖ḏikhâymáaˀin, in tsíˀtꞌaaˀindá inbí keetandá dâywáykáyjíḏí, in áagé diwha̖ˀvennindá dovâywáytaygé-íḏí, heḏá tꞌowa-á dovâytate dikwꞌóˀnindi Jesus hânho óeḏamúndeˀ. ");
INSERT INTO tew_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ihayḏáháˀ Jesus-di ovâytu̖ˀan, “Nä́ˀi hä̖ä̖wí Jôesi Táḏáví taˀnin diwe nataˀmuuˀi-á ho napóe nää thaa ítꞌôeyankwꞌôndiboˀ.” ");
INSERT INTO tew_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tꞌä̖hkíḏíbo dichanpóe híwó ihéeˀannin. Tꞌä̖hkí ovâyháaˀan, gá saˀwóˀdi tundi ovâyhéeˀandân, heḏi ditû̖ˀ, “Háḏíḏan nä́ˀi hä̖ä̖wí ûnhanginná? Ti Joseph-ví ayḏa̖ˀmân wíˀûnmuupíˀan?” ");
INSERT INTO tew_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iˀḏi ovâytu̖ˀan, “Maḏi undi nä́ˀi tuní, heḏá tꞌowa-á dovâyt tꞌowa ditû̖ˀdi dítu̖ˀâ̖a̖mí, ‘Woekandi, páaḏé bipihehkháaˀa̖mí.’ Han ítú̖ḏáho unbí híˀ ginnân úntundaˀí: Un ítꞌoe háa ee Capernaum búˀay dáyˀannin, heḏiho nää-á nä́ä naví ówí̖nä́ wáˀ han waagibá naa dînkhâyˀä̖ˀ dáyˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hewänbo naaḏá taˀgendi wâytu̖ˀa̖mí, wí Jôesi Táḏáví tukheˀbiˀ-á iví nange iweho wíˀóesígíˀohpí. ");
INSERT INTO tew_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Naaḏá wâytu̖ˀa̖mí háa báyékí pa̖a̖yo phaḏe taˀgendi napóeˀin, Jôesi Táḏáví tukheˀbiˀ Elijah nawówájiˀ ihayḏi. Pojeḏá píngé pa̖a̖yo wíˀikwa̖ˀnanpí, heḏiho tꞌä̖hkí iˀ nange wáy báyékí diha̖a̖póe. Heḏi tobá Israel-win kwiyä̖ˀ inbí senäˀ díntꞌahánnin báyékí diji wänboˀ, hä̖ˀin kwiyä̖ˀbíˀwepiye Jôesi Táḏáḏí Elijah óesaanívíˀweḏi oe Sidon búˀpiyân óesan, wí búˀ Zarephath gin dâytu̖ˀoˀ iwepiye, wí kwee iví sen ûnchuuˀiˀ óekhä̖geˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Heḏá wáˀ Jôesi Táḏáví tukheˀbiˀ Elisha nawówájiˀ ihayhä̖̂ä̖, báyékí in Israel-win diphéetaymuu, heḏi wénä wänbo in wíḏiwówapí. Wí sen Naaman kin nakhá̖wä̖́ˀiḏa̖ˀmân nawówa, heḏi i-á Syria nangewi-ân namuu.” ");
INSERT INTO tew_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","In méesate ee dikwꞌóˀnin nä́ˀi ditꞌoe ihayḏi hânho ditꞌayyaapóe. ");
INSERT INTO tew_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tsíkhagipí dívíwí̖núḏí iˀ búˀḏí jáˀwépiye Jesus óechä̖nupiye. Iˀ búˀ-á okú wáhkí nakꞌóe, heḏi oe okú kwꞌáyepiye óepiye tꞌowá kꞌáygéḏí óekeˀtꞌâave-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hewänbo i-á inbí jáagé i̖ˀge naphaḏeḏiboˀ iweḏi namää. ");
INSERT INTO tew_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ihayḏá Jesus-á wíyá Galilee nangewi búˀay Capernaum gin dâytu̖ˀoˀ iwepiye namää, heḏi iˀ Huḏíyoví kaykhanwówá thaa dínnáˀ dihayḏi in tꞌowa ovâyhá̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","In tꞌowa háa Jesus-di ovâyhá̖ˀannindi ovâyháaˀan, gá wí toˀwí báyékí tsonkhuu imáaˀi waagibá ihíˀmáaḏân. ");
INSERT INTO tew_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Iwebá wí sen naˀä́n wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáaˀiˀ, heḏi itu̖wí̖nú, “Íviˀwän u̖ Jesus Nazareth-wiˀ, ánpí díˀan. Ti unˀä̖ä̖ dítꞌahá̖a̖nú-íḏí gáhân? Naa dînhanginná toˀwí unmuuˀin — u̖-á iˀ tꞌä̖hkí yä̖ˀḏâaˀiˀ unmuu, iˀ Jôesi Táḏáḏí wóesandiˀ.” ");
INSERT INTO tew_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus-di iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ tꞌayḏi óehéeˀandi óetu̖ˀan, “Hânda̖ˀdiboˀ, hä̖ˀi senbíˀweḏi ópeeve.” Iˀ pꞌoewa̖a̖hâ̖a̖ḏi iˀ sen in tꞌowaví páaḏépiye óekanu, heḏi i senbíˀweḏi napee wíˀóewa̖ˀanpíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tꞌä̖hkí dikwꞌóˀnin ovâyháaˀandi dívítu̖máa, “Jesus-ví híˀ-á hânho ûnkay. I-á báyékí tsonkhuu ûnkꞌóe in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ toˀwênbíˀweḏi ovâypeejôeníḏí, heḏiho dâyˀaˀgindoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Heḏi tꞌä̖mäpiye tꞌä̖hkí in tꞌowa iwéngéwin iví̖ˀgeḏi dívíhíˀmáa. ");
INSERT INTO tew_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus in Huḏíyo-ví méesate iweḏi napee, heḏi Simon-bí tewhá iwepiye namää. Simon-bí jahkwíjo ûnhayḏi hânho natsá̖wä̖pꞌíḏeˀ, heḏi Jesus igîˀ ônkhä̖ˀgeˀdaaˀan. ");
INSERT INTO tew_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Heḏiho Jesus namääḏi iˀ kweeví whohte hânge iwí̖nú, heḏi iˀ tsá̖wä̖pꞌíḏe i kweeví túˀḏí napee-íḏí ijôn. Wesebo iˀ tsá̖wä̖pꞌíḏe ûnhándí iˀ kwee ishaa, heḏi ovâyhúujôn. ");
INSERT INTO tew_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nathantsuḏemän dihayḏi iˀ kaykhanwówá thaa ho naphaḏe, heḏi toˀwên wây-á dihayˀin dínkwꞌóˀnin Jesus-víˀpiye dâyhoˀ, tobá háawi inbí hay dínmuu wänboˀ, heḏi iví mandi ovâytä̖geḏi tꞌä̖hkí ovâyhehkháamä́gi. ");
INSERT INTO tew_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","In yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ báyékí tꞌowavíˀweḏi dínpee, heḏi dipeeˀä̖ḏi dívítu̖wí̖nú, “U̖-á Jôeso Táḏá-ví ay-ân unmuu.” Hewänbo iˀḏi tꞌayḏi ovâyhéeˀandi wíyá wíˀovâyhíˀmä́gipí, gá dínhanginnândân i-á nammu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, heḏi waˀḏi wínadaˀpí in tꞌowa dínhanginnáaníḏí toˀwí namuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Namuwä̖thay ihayḏi Jesus ee búˀḏí napee, heḏi wä̖́hä̖̂ä̖ tóebo wínathaapí iwepiye namää. In tꞌowaḏi óetu̖wä̖hoˀ, heḏi óeshaa ihayḏá dívíkhä̖ä̖ḏeˀ inbíˀweḏi wíˀijâaˀa̖mípíḏí. ");
INSERT INTO tew_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hewänbo iˀḏi ovâytu̖ˀan, “Naa dînkhâyˀä̖ˀ iˀ wéˀgeˀi búˀây eejepiye omú-íˀin, heḏânho dovâytꞌôeˀa̖míḏí nä́ˀi híwóˀdi tun háḏíḏí Jôesi Táḏádí in tꞌowa ovâysígíhóndeˀ i̖ˀgeḏi. Hangîˀânkun naa dísan.” ");
INSERT INTO tew_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Heḏiho Jôesi Táḏáví tun iˀ Huḏíyoví méesateˀây eeje in Huḏíyoví nange i̖ˀge tꞌä̖hkí ovâytꞌôekanhon. ");
INSERT INTO tew_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wí thaa Jesus iˀ pꞌoekwîn Genessaret gin dâytu̖ˀoˀ iwe tsowa wáy nawin, heḏi báyékí in tꞌowa dívíchä̖numáa shánkí iví núˀpiye dívíhâ̖a̖ḏi-íḏí heḏânho shánkí híwó Jôesi Táḏáví híˀ ditꞌoe-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wíje kophé owáy pꞌoˀ kꞌáygé wáy daˀä́ndí imûˀ. In paawóˀindá wíyá wáygé dijiˀ inbí paˀakanuˀi dâyˀowêeḏi-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wí kophé-á Simon-bîˀ ûnmuu. Jesus iwe itógiḏi Simon óedaaˀan hây pꞌoe iwepiye ônhâ̖a̖ḏi-íḏí, heḏi iwáygé isógeḏi in tꞌowa ovâyhá̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Heḏi ovâyhíˀbowa ihayḏi Simon óetu̖ˀan, “Uví kophé oe shánkí nawä̖ˀän diwepiye mänha̖ḏi, heḏi unbí paˀakanuˀi binwhájé heḏânho bînpaawhahóeníḏí.” ");
INSERT INTO tew_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon-di óetu̖ˀan, “Há̖hkandiˀ, khun tꞌä̖hkí hânho ívítꞌôeˀan, heḏi wêe wänbo paa wíˀâywhahkêˀpí. Hewänbo nää-á gin u̖ˀ untú̖ḏího iˀ paˀakanuˀi dówhaajé-í.” ");
INSERT INTO tew_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Heḏi han dívíˀan dihayḏi báyékí paa dâywhahógi, heḏi inbí paˀakanuˀi dínsivekhâypóe. ");
INSERT INTO tew_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Heḏiho dívímanwáḏáˀan inbí kꞌemaˀin iˀ wêe kophé iwe ditoˀonnin diˀä̖ä̖-íḏí ovâykhä̖geˀnamíḏí, heḏi indá dipówá ihayḏi in wíje kophé tꞌä̖hkí dínpꞌídepóeḏí báyékí dínpaakuˀundi ovâyˀu̖gekhâyˀan. ");
INSERT INTO tew_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Peter háa napóeˀin imûˀ ihayḏi Jesus-ví páaḏépiye idégeˀdisóge heḏi óetu̖ˀan, “Nanbí Sedó, navíˀweḏi óha̖ḏi, naa-á tꞌaywóhkandiḏa̖ˀ omuu.” ");
INSERT INTO tew_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Haˀwâa Peter natú̖ gá óeháaˀandân báyékí paa dâywhahógiḏi, heḏi tꞌä̖hkí in diho dívímanwáḏáˀan inbí kꞌemaˀin iˀ wêe kophé iwe ditoˀonnin diˀä̖ä̖-íḏí ovâykhä̖geˀnamíḏí, heḏi indá dipówá ihayḏi in wíje kophé tꞌä̖hkí dínpꞌídepóeḏí báyékí dínpaakuˀundi ovâyi-áḏí dijiˀin wáˀ ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","James-áḏí John-dáḏí hanbá dachanpóe. Nä́ˀin wíje senäˀdá Zebedee-ví ây damuu, heḏi indáḏí Simon-dáḏí wéˀge dä̂npaawóˀoˀ. Hebo Jesus-di Simon óetu̖ˀan, “Wíˀunkhunwôedaˀípí. Nää-á paa mänhóndeˀ, hewänbo nää iweḏi páaḏépiyá tꞌowa-ân naagîˀ dînkhonkhâymáa.” ");
INSERT INTO tew_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Inbí kophé oe pꞌo kíngépiye dâywáyhá̖ḏiḏi hä̖ä̖wí dínkwꞌóˀdi tꞌä̖hkí dâyjoeˀan, heḏi Jesus óeyu̖u̖hoˀ. ");
INSERT INTO tew_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wí thaa ee nangebá wí búˀay iwe Jesus najiˀ, heḏi wí sen iví túˀ tꞌä̖hkí naphéetaymuuˀi Jesus-ví páaḏépiye idégeˀdisógeḏi ipꞌóˀtꞌä̖́ä̖, heḏi óekhä̖geˀdaaˀandi óetu̖ˀan, “Dînhanginná u̖-á úkoḏiˀin nä́ˀi phéetay dînjâaˀa̖míḏí, undaˀḏi.” ");
INSERT INTO tew_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Heḏi Jesus ikhóhtä̖ä̖ḏi iví mandi iˀ sen óetä̖geḏi óetu̖ˀan, “Odaˀ-ákun wíhehkháamä̂äníḏí. Unhehkháapúuwí.” Wesebo iˀ senbí phéetay ûnhán. ");
INSERT INTO tew_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Heḏi Jesus-di kayˀindi óetu̖ˀan, “Toˀwí wänbo háa úpóeˀin wínâatꞌôeˀa̖mípí. Moses-di wovâyjôn wí hä̖ä̖wí iˀ owhaˀvíˀpiye bînhûuwíˀin Jôesi Táḏá óemä̂äníḏí, heḏânho in tꞌowa ovâyhanginˀânnamíḏí íwówaˀin. Nää ópûn, haˀwâa óˀan.” ");
INSERT INTO tew_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hewänbo nää-á shánká báyékí tꞌowa Jesus-ví̖ˀgeḏi dínhanginpóe, heḏi báyékí tꞌowa tꞌä̖mäpha̖ˀgeḏi diˀä̖ä̖ḏi dívíwéˀgeˀan ôntꞌôeyaaníḏí heḏá iˀḏi ovâyhehkháamä̂äníḏá. ");
INSERT INTO tew_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hewänbo iˀḏi ovâyjoeˀandi oe ahkónupiye namää ijûusuˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wí thaa wí tewhá iwe Jesus-di in tꞌowa ovâyhá̖ˀoˀ, heḏi wên Pharisees-áḏí heḏá wên Huḏíyoví khuu dâyhá̖ˀoˀindáḏí iví tsowa wáy dikwꞌó. Nä́ˀindá diˀä̖ä̖ iˀ búˀây eejeḏi oe Galilee nange Judea nangá nakwꞌóˀdiˀ, heḏá Jerusalem búˀ iweḏá. Nanbí Sedó Jôesi Táḏáḏí Jesus báyékí kay óemä́gi in tꞌowa hehkháa ovâymä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ihayḏibá wên senäˀ dipówá, indá wí sen ûnˀa̖ˀyä̖kankoḏipîˀ wên whohpa̖ˀay eeḏi nakꞌóeḏí óekán, heḏi dívíkhä̖ä̖ ívepiye óetsꞌûuḏe-íḏí heḏânho Jesus-ví páaḏépiye óekꞌúuwíḏí. ");
INSERT INTO tew_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hewänbo oe íve in tꞌowa dibáˀyendi háḏíḏí óetsꞌûuḏe-íˀin wíḏâyshaapí, heḏiho oe whaˀkꞌaypiye óepiye. I tekumu wáy wí dâyhá̖ḏiḏi dâykhóˀjéphohkíḏi, heḏi iˀ sen iví whohpa̖ˀay wóegé in tꞌowaví jâaḏi óewhaje Jesus-ví páaḏépiye. ");
INSERT INTO tew_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dâywä̖yu̖máaˀin Jesus-di ovâymûˀ ihayḏi iˀ sen óetu̖ˀan, “Kꞌema, uví tꞌaywóˀdi-á úˀowóˀjen.” ");
INSERT INTO tew_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","In Huḏíyoví khuu dâyhá̖ˀoˀindáḏí in Pharisees-áḏí dívítu̖máa, “To-an nä́ˀi namuu gân naˀándeˀ? Jôesi Táḏáḏa̖ˀmân ûnkoḏi tꞌaywóˀdi iˀowóejé-íḏí, wíyá toˀwí wänbo-á joe. Heḏiho nä́ˀi sen gin ihíˀmáaḏí Jôesi Táḏá óeˀaˀginhá̖núndeˀ.” ");
INSERT INTO tew_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus ûnhanginná háa diˀánshaamuuˀin, heḏi ovâytsikaˀyan, “Heháaḏan giˀbi ánshaa bînmáa? ");
INSERT INTO tew_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Naa otú̖ḏá, ‘Uví tꞌaywóˀdi úˀowóˀjen,’ háa otú̖ḏá, ‘Ówí̖núḏá ójíyé,’ wéˀi-an shánkí wínabâapuˀwanpí heḏânho bînmúuníḏí háa taˀgendi dînkoḏiˀin háa joe? ");
INSERT INTO tew_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nää hä̖ä̖wí dókhâymáa wâykeeya̖míḏí naa tꞌowa tꞌä̖hkígîˀ oˀaypu̖yä̖ˀiˀ dînkꞌóeˀin nä́ä oepáa kꞌayḏi tꞌaywóˀdi dovâyˀowóejé-íḏí wáˀ.” Heḏáháˀ iˀ sen ûnˀa̖ˀyä̖kankoḏipîˀ-á óetu̖ˀan, “Naaḏi wítu̖máa, ówí̖nú, uví whohpa̖ˀay mänkeˀḏi uvíˀpiye unmú-í.” ");
INSERT INTO tew_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wesebo iˀ sen in tꞌowaví páaḏépiyeboˀ iwí̖nú, heḏi iví pa̖ˀay iwe ûnkꞌóeˀiˀ ikêˀḏi ivíˀpiye iweehoˀ, Jôesi Táḏá kwꞌáayéboˀ óemáaḏí namää. ");
INSERT INTO tew_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","In tꞌowa hânho ovâyháaˀan heḏá dikhunwôedaˀpóe. Heḏi indi wáˀ Jôesi Táḏá kwꞌáayéboˀ óemáaḏí ditú̖, “Nää thaa âymûˀ wí hä̖ä̖wí hä̂nhay wänbo âymûˀpîˀ.” ");
INSERT INTO tew_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nä́ˀi tꞌä̖hkí napóe ihayḏi Jesus iˀ búˀay iweḏi namääḏi wí tax phahsandi Levi gin nakhá̖wä̖́ˀiˀ óemûˀ iˀ phahsan chä̖ˀ dâywéˀgeˀoˀiˀ tehwáˀay ee naˀä́ndí. Jesus-di óetu̖ˀan, “Naa-áḏí ókä̖ˀve.” ");
INSERT INTO tew_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi iwí̖núḏí hä̖ä̖wí tꞌä̖hkí ûnkwꞌóˀdi ijoeˀandi Jesus-áḏí namää. ");
INSERT INTO tew_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Heḏi Levi-ḏi Jesus iví kꞌaygipiye óehoˀḏi ônshánkíˀeeḏipaa. Wây-á báyékí tax phahsannindá heḏá wây-á tꞌowa-á dikwꞌó indáḏí dívíhúujoḏi. ");
INSERT INTO tew_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","In Pharisees-áḏí heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindáḏí wíˀovâyhí̖ˀanpí Jesus-á nä́ˀin tꞌowa-áḏí ihúujoˀin, heḏiho Jesus-ví khä̖geˀnin ovâytsikaˀyan, “Heháaḏan nä́ˀin tax phahsannindáḏí heḏá nä́ˀin wéˀgen tꞌôeyanpíˀin dimuuˀindáḏí úvíhúujoˀ?” ");
INSERT INTO tew_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus-di ovâytu̖ˀan, “In dihayˀinda̖ˀmân wí woekandi díntáy, in dihaypíˀindá joe. ");
INSERT INTO tew_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Naa oˀä̖ä̖ in toˀwên tꞌaywóhkannin dimuuˀin dínhanginnáˀnin dovâytu̖ˀâ̖a̖míḏí inbí tꞌaywóˀdi dâyjoeˀa̖míḏí, in toˀwên inbí wówátsi taˀge dâyhon gin diˀándeˀindá joe.” ");
INSERT INTO tew_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wên tꞌowaḏi Jesus óetu̖ˀan, “John iˀ pꞌóˀpꞌoekandiví khä̖geˀnin ihayḏa̖ˀ dívíha̖a̖ḏä́ˀo heḏá báyékí dívíjûusuˀoˀ, in Pharisees-ví khä̖geˀnin wáˀ hanbá dívíˀoˀ. Heháaḏan uví khä̖geˀnin húukandáḏí su̖wä̖-áḏíḏa̖ˀ dívíˀoˀ?” ");
INSERT INTO tew_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus-di ovâytu̖ˀan, “Dínkhóhtsa̖a̖shánkíˀeeḏináˀ dihayḏi ti únkoḏi iˀ soyingiví kꞌemaˀin bînha̖a̖ḏä́kannamíˀin waˀḏi iˀ soyingi indáḏí najiḏiboˀ? Heḏân joe. ");
INSERT INTO tew_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hewänbo owáy hä̖̂ä̖ḏi iˀ soyingi inbíˀweḏi óekhuwakhâymáa, ihayḏânho dívíha̖a̖ḏä́ˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus-di nä́ˀi há̖hkangîˀ híˀ wáˀ ovâytu̖ˀan: “Toˀwí wänbo wên to tsꞌa̖a̖min diweḏi wíˀisívéndepí wây-á to naphohcháˀnin diwe itꞌiˀkꞌúuwíḏí. Han waagi iˀandá, in to tsꞌa̖a̖min wí pho ûnchaní, heḏá in to tsꞌa̖a̖min diweḏiˀin tꞌihku-á wáˀ háˀto in to khannin deeḏi híwó nakeetꞌôení. ");
INSERT INTO tew_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Heḏá wáˀ toˀwí wänbo wí méena tsꞌa̖a̖biˀ kꞌúwá khowa múu kayjee eeje wíˀikuuḏepí. Gin waagi iˀandá, iˀ méenaḏi iˀ múu óephuuḏi óepâave-í, heḏá iˀ méena nachaˀḏee-í heḏi iˀ múu-á óepeḏeeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nakhâyˀä̖ˀ méena tsꞌa̖a̖bi-á wí kꞌúwá khowa múu tsꞌa̖a̖biˀ eeje óekuu-íˀin. ");
INSERT INTO tew_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Heḏá tꞌowa-á páaḏé méena kayjee dâysu̖wä̖ḏá háˀto méena tsꞌa̖a̖bi-á disu̖wä̖daˀí. Ditú̖u̖ní, ‘Nä́ˀi méena kayjee-á shánkí híwóˀdi namuu’.” ");
INSERT INTO tew_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wí thaa, Huḏíyoví kaykhanwówá thaa nanáˀdiˀ, Jesus-áḏí iví khä̖geˀnindáḏí wí táhtân nava i̖ˀge dimän, heḏi iví khä̖geˀnin dâytákꞌéthehon, heḏá inbí mandi dâyhuuˀandi iˀ táhtân dâykꞌoˀ. ");
INSERT INTO tew_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wên Pharisees-di ovâytu̖ˀan, “Kaykhanwówá thaa háa úvíˀo waagá nakhâ̖a̖kꞌóe. Heháaḏan haˀwâa úvíkanhon?” ");
INSERT INTO tew_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus-di ovâytu̖ˀan, “Undá bîntunnanpíˀan háa David heḏá in senäˀ i-áḏí dijiˀindáḏí hä́nˀoe dívíˀannin diha̖hsên dihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jôesi Táḏáví tewhá ee David natsꞌûndi iˀ pává ee nasaaˀiˀ ihógi heḏi ikꞌoe, heḏá in senäˀ i-áḏí dijiˀindá wáˀ ovâymä́gi, tobá iˀ pává Jôesi Táḏágîˀ ûnwijesaa wänboˀ, heḏiho in owhaˀḏa̖ˀmân dínkꞌóe dâykꞌoˀíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesus nä́ˀin wáˀ ovâytu̖ˀan: “Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi dînkꞌóe otú̖u̖níḏí háa tꞌowa kaykhanwówá thaa dínkoḏiˀin dívíˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wíyá kaykhanwówá thaa nanáˀ diwe Jesus wí Huḏíyoví méesateˀay ee natsꞌûndi in tꞌowa ovâyhá̖ˀoˀ. Wí sen iví koˀḏíngéḏíˀin man ûntꞌaamuuˀiˀ iwe naˀä́n. ");
INSERT INTO tew_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wên Huḏíyoví khuu dâyhá̖ˀoˀindá heḏá wên Pharisees-á wáˀ dikwꞌó. Indi á̖yîngiḏi óemúnde tigúba kaykhanwówá thaa wí toˀwí hehkháa óemä̂äníˀin, heḏi gin iˀandáhoˀ ôntꞌeˀpꞌêeḏe-í. ");
INSERT INTO tew_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hewänbo Jesus ûnhanginná háa diˀánshaamuuˀin, heḏi iˀ sen namantꞌaamuuˀiˀ óetu̖ˀan, “Ówí̖núḏí nä́ä páaḏépiye ókä̖ˀve.” ");
INSERT INTO tew_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Heḏáháˀ Jesus-di ovâytu̖ˀan, “Nä́ˀin tsika wâytsikakhâymáa: Kaykhanwówá thaa wéˀi-an gínkꞌóe ívíˀa̖míḏí: Ti gínkhâyˀä̖ˀ wí toˀwí iví wówátsi âyˀaywoeníˀin háa âyháyjíˀin?” ");
INSERT INTO tew_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Heḏi ibéeḏí wíˀínbo ovâymúndeˀ, heḏáháˀ iˀ sen óetu̖ˀan, “Ókhóhtä̖ä̖.” Heḏi ikhóhtä̖ä̖ḏi iví man ûnwówaḏi páaḏéḏí ûnmuu waagibá ûnpóe. ");
INSERT INTO tew_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hewänbo in dikwꞌóˀnin hânho ditꞌayḏi dívítu̖máa hânnangú Jesus dâyˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ihayhä̖̂ä̖ḏihkí Jôesi Táḏávíˀpiye ijûusuˀan. ");
INSERT INTO tew_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nathay ihayḏi iví khä̖geˀnin ivíˀpiye itu̖hkánnan, heḏi in diweḏi tä̖ˀḏi wíje ovâydeˀmandi nä́ˀinbá ovâytu̖ˀan, “Undá naví tꞌôekhuwaˀin ímuu.” Ginnân dikhá̖wä̖́: ");
INSERT INTO tew_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Simon (i-á Jesus-di Peter gin wáˀ óekhá̖wä̖́mä́gi), heḏá Andrew-á (i-á Simon-bí tíˀûu-á ûnmuu), heḏá James-á, John-dá, Philip-á, Bartholomew-á, Matthew-á, Thomas-á, heḏá wíyá wêe James-á (i-á Alpheus-ví ay ûnmuu), heḏá wíyá wêe Simon-dá (i-á “Iˀ Zealot namúˀdeˀiˀ” gin wáˀ óetu̖ˀoˀ), Judas-á (iví táḏá-á James gân ûnkhá̖wä̖́), heḏá Judas Iscariot-dá (i-á Jesus óeku̖hpekhâymáaˀi-á namuu). ");
INSERT INTO tew_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Okú kwꞌáyeḏi tꞌä̖hkíḏíbo diwá̖, heḏi Jesus nanantayeḏináˀ diwe iwí̖nú. Báyékí in óeyu̖u̖honnin i-áḏí dijiˀ heḏá báyékí wây-á tꞌowa-á wáˀ, indá diˀä̖ä̖ Jerusalem búˀḏí, heḏá wíyá wáygéḏá Judea nantaa búgeḏi, heḏá iˀ mâapꞌoe pꞌoˀ kꞌáygéwin búˀ Tyre-á Sidon-dá tsowaḏá wáˀ diˀä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nä́ˀin tꞌowa-á diˀä̖ä̖ Jesus ôntꞌôeyaaníḏí heḏá inbí hay ovâyjâaˀa̖míḏí. Heḏá in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi ovâytꞌôephaḏekandoˀin wáˀ diˀä̖ä̖ḏi dihehkháapóe. ");
INSERT INTO tew_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tꞌä̖hkí in tꞌowa dívíkhä̖ä̖ḏeˀ óetä̖ä̖gé-íḏí, gá wí pínnán ûnpeeˀiˀḏi dihaywówaˀdân. ");
INSERT INTO tew_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus ibéeḏí iví khä̖geˀnin imúndeḏi ovâytu̖ˀan, “Un sehkanäwó íwówájiˀin híhchan bînmáˀve-í, gá Jôesi Táḏáví tꞌowa ímuuḏân. ");
INSERT INTO tew_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Un nää bînha̖hphaḏendeˀin híhchan bînmáˀve-í, gá íshu̖hpúuwíḏân. Un nää íséejiˀin híhchan bînmáˀve-í, gá híhchandi úvípꞌáhkaa-íḏân. ");
INSERT INTO tew_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuḏi tꞌowaḏi wovâytꞌayḏá heḏá wovâyjoegimáaḏá heḏá tꞌä̖mäge unbí̖ˀgeḏi dívíhíˀmáaḏá heḏá tꞌaywóhkannin ímuu gin wovâytu̖máaḏá, híhchan bînmáˀve-í. ");
INSERT INTO tew_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gin waagi únpóeḏá íhíhcha̖a̖-í heḏá úvíhíhchanchä̖ä̖nú-í, gá in tꞌowaḏi han wovâyˀandibo Jôesi Táḏáḏí báyékí híwóˀdi hä̖ä̖wí oe makówá wovâymä̂äníḏân. Wíˀúnˀôeḏe-ípí nä́ˀin tꞌowaví hehä̖̂ä̖win thehtáy pahpáˀindi wáˀ in Jôesi Táḏáví tukheˀmin hanbá ovâyˀan. ");
INSERT INTO tew_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Hewänbo un nää íkoḏitꞌowamuuˀin tꞌôephaḏe únpúuwí, gá undá unbí híwóˀdi thaa ho únphaḏeḏân. ");
INSERT INTO tew_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Un nää íshu̖ˀmuuˀin tꞌôephaḏe únpúuwí, gá undá íha̖a̖púuwíḏân. Un nää ípꞌâajiˀin tꞌôephaḏe únpúuwí, gá undá íboˀaapúuwíḏân heḏá íséeyê̖e̖ní. ");
INSERT INTO tew_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tꞌä̖hkí tꞌowa unbí̖ˀgeḏi híwó dívíhíˀmáaḏá tꞌôephaḏe únpúuwí. Háaḏí? Gá nä́ˀin tꞌowaví hehä̖̂ä̖win thehtáy pahpáˀin híwóˀbáho dívíhéeˀandân in hójoˀinbí̖ˀgeḏi ditú̖ˀin Jôesi Táḏáví tukheˀmin dimuuˀin.” ");
INSERT INTO tew_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Hewänbo un naa dîntꞌôeyandeˀin naaḏi wâytu̖máa, unbí hä́nmin bînsígí-í, heḏá in wovâytꞌayˀindá híwóˀdá bînˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Jôesi Táḏá bîndaaˀa̖mí wí hä̖ä̖wí híwóˀdi ovâyˀa̖míˀin in toˀwên híwóhpîˀ únpúuwíˀin didaˀin, heḏá in toˀwên unbíˀgeḏi wovâyjänäkíhéeˀoˀingîˀ ovâyjûusuˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wí toˀwíḏí wéhángéḏí wovâytsꞌemapháveḏi, oe wéhángéḏí wáˀ bîntsꞌemaphavemä̂äní. Wí toˀwíḏí unbí kꞌéwéˀin to wovâykêˀḏi, unbí to wáˀ wovâykáyjíḏí wívînkhâ̖a̖ˀa̖mípí. ");
INSERT INTO tew_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wí toˀwíḏí wí hä̖ä̖wí wovâydaaˀandi bînmä̂äní, heḏi wí toˀwíḏí wí hä̖ä̖wí únmuuˀi wovâykêˀḏá, wíyá wívîndaaˀa̖mípí. ");
INSERT INTO tew_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Háa tꞌowaḏi un wovâyˀa̖míˀin ídaˀ waagibá, hanbá bînˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“In toˀwên wovâysígíˀinda̖ˀmân bînsígíḏá, ti tꞌowa unbí̖ˀgeḏi ditú̖u̖ní híwó úvíˀoˀin? Heḏân joe. In tꞌaywóhkannindi wänbo wáˀ ovâysígí toˀwên in ovâysígíˀin. ");
INSERT INTO tew_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Heḏi in toˀwên híwó wovâyˀoˀingîˀḏa̖ˀmân híwó bînˀoḏá, ti tꞌowa unbí̖ˀgeḏi ditú̖u̖ní híwó úvíˀoˀin? Heḏân joe. Tꞌaywóhkannin wänbo wáˀ híwó ovâyˀoˀ in toˀwên híwó in ovâyˀoˀin. ");
INSERT INTO tew_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Heḏi in toˀwên wovâywáywáˀâa-íˀinda̖ˀmân bînchä̖ˀpíyémäḏá, ti híwó úvíˀo gin tꞌowa ditú̖u̖ní? Heḏân joe. Tꞌaywóhkannin wänbo wáˀ wây-á tꞌaywóhkannin dâychä̖ˀpíyémäˀ, dínhanginnândáho hä̖́yú̖ dívípíyémä́gi ihaybá ovâywáywáˀâa-íˀin. ");
INSERT INTO tew_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ginnân úvíˀa̖mí: Uví hä́nmin bînsígí-í, heḏá híwóˀdá bînˀa̖mí. Bînpíyémä̂äní hä̖ä̖wí, heḏi i̖ˀgeḏi wíˀúvíˀánshaaˀa̖mípí háa wíyá bînhóení háa joe. Gin waagi úvíˀandi, wíyá shánkí híwó bînhóení, heḏi taˀgendi iˀ shánkí kwꞌáye naˀä́ndiví ây ímuu gin tꞌowa ovâykeeya̖mí. Iˀḏá in toˀwên dikú̖ˀdaapoeˀoˀpíˀin wänboˀ in ditꞌaywóˀtꞌóeˀin wänbo-á híwó ovâyˀoˀ. ");
INSERT INTO tew_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Únkhâyˀä̖ˀ tꞌowavíˀpiye ísehkanäpúuwíˀin, uví Táḏá Jôesi uvíˀpiye nasehkanäpoeˀo waagibá.” ");
INSERT INTO tew_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ihayḏa̖ˀ tꞌowa wívîntꞌaywóˀdichä̖́nuˀbe-ípí, heḏânho un wíwovâytꞌaywóˀdichä̖ä̖nú-ípíḏí. Ihayḏa̖ˀ wíˀítú̖ˀbe-ípí toˀwên dimuuˀin ovâytuhchä̖ä̖nú-íˀin, heḏânho wíwovâytuhchä̖ä̖nú-ípí. Wây-á tꞌowa bînˀowóejé-í heḏânho wovâyˀowóejé-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","In tꞌowa hä̖ä̖wí bînmä̂äní, heḏânho Jôesi Táaḏí un wáˀ wovâymä̂äní. Unbí tꞌún wovâypꞌíḏe waagibá únpúuwí, heḏáháˀ in tꞌún wovâytꞌä̖́ˀtꞌä̖́ˀnandá wovâywáḏáˀa̖mí shánkí báyékí únsaḏee-íḏí, pꞌéeḏí chꞌa̖ˀkí únsaḏee-í. Wây-á toˀwêngîˀ bîntaajo waagibáho wovâytaaya̖mí.” ");
INSERT INTO tew_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus-di nä́ˀi há̖hkangîˀ híˀ wáˀ ovâytu̖ˀan: “Wí tsíˀtꞌaaˀi-á wûnkoḏipí wíyá tsíˀtꞌaaˀiˀ óepahûuwíḏí. Gin iˀandá wíˀgíndíbo kwiˀónú dakeˀtꞌá̖a̖nípíˀan. ");
INSERT INTO tew_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wí toˀwí nahá̖hpoeˀoˀi-á iví há̖hkandiví shánkí wínahá̖hpí, hewänbo ho nahá̖hpóe ihayḏá iví há̖hkandi waagiˀbá namúuní. ");
INSERT INTO tew_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Heháaḏan iˀ phétä̖́ wíyá toˀwíví tsée ûntoˀondi bînmúndeˀ, heḏi in phé unbí tsée úntoˀonnindá wívînˀá̖yîngiˀohpí? ");
INSERT INTO tew_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wíˀúnkoḏipí bîntu̖ˀâ̖a̖míḏí, ‘Ókä̖ˀ kꞌema, hä̖ˀi phétä̖́ uví tsíˀḏí wînwhahkáyjí,’ gá wên phé uví tsíˀ útoˀondi híwó wíˀúnkeetꞌóepíḏân. Undá paa úvíjánúmáaˀin waaginbá ímuu. Páaḏé hä̖ˀin phé unbí tsíˀḏí binwhahkeˀ heḏânho híwó únkeetꞌôení wíyá toꞌwíví tsíˀḏí hä̖ˀin phétä̖́ bînwhahkáyjíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Wên bay tay híwóˀnin deeḏi híwóhpîˀ bay wínapaˀpí, heḏi wên bay tay híwóhpíˀin namuuˀin deeḏi bay híwóˀdi namuuˀi wínapaˀpí. ");
INSERT INTO tew_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Úhanginná háawin wên tay namuuˀin iˀ hä̖ä̖wí napayeḏee iweḏi. Figs-á phéˀyä́vi nawä̖́ä̖muu iweḏi wíˀóetháyˀépí, heḏá úuva-á wên tsígu iweḏi wíˀóetháyˀépí. ");
INSERT INTO tew_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Heḏi hanbá wí toˀwí híwóˀdi namuuˀi-á híwó iˀoˀ, gá iví píˀnä́ khóˀjé báyékí híwóˀdi imáaḏân, heḏi wí toˀwí híwóhpîˀ namuuˀi-á híwóhpîˀ iˀoˀ, iví píˀnä́ khóˀjé-á híwóhpîˀ imáaḏí. Tꞌä̖hkí tꞌowa háa inbí píˀnä́ khóˀjé dâymáa waagibá dívíhéeˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Heháaḏan undi naa ihayḏa̖ˀ díkhá̖yä̖́ˀde ‘Nanbí tsondi pꞌóˀḏéḏîˀ’ gin, hewänbo háa naaḏi wâytu̖ˀan waa wíˀúvíˀohpí? ");
INSERT INTO tew_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Toˀwên navíˀpiye diˀä̖ä̖ḏi naví híˀ ditꞌoeḏi dînˀaˀgindoḏá naaḏi wâythayya̖mí háawin dimuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Indá wí sen wí tewhá ikꞌûˀi waaginbá dimuu, iví tepúgîˀ báyékí iphoyä̖ä̖ heḏá kꞌuuḏá itepútógi. Heḏi napꞌohsôe ihayḏi iˀ pꞌoeḏi iˀ tewhá óenán, hewänbo iˀ sen híwó ikꞌûˀḏiho iˀ tewhá wíˀóeˀa̖ˀyä̖ˀnanpí. ");
INSERT INTO tew_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Hewänbo in toˀwên naví híˀ ditꞌoeḏi dînˀaˀgindopíˀindá wí sen itewhákꞌûˀḏi tepúpíḏíbo waaginbá dimuu, heḏi iˀ pꞌoˀkꞌay napꞌohsôe ihayḏi iˀ pꞌoeḏi iví tewhá hânho ônnándí wesebo tꞌä̖hkího ônpꞌonayu̖.” ");
INSERT INTO tew_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nä́ˀi tꞌä̖hkí Jesus-di in tꞌowa ûntꞌôeyanjiˀin ovâyhíˀbowa ihayḏiho iwáygéḏí oe Capernaum búˀaypiye namää. ");
INSERT INTO tew_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iwe wí sundaḏo pꞌóˀḏéḏîˀ najiˀ, i-á wí tꞌôeˀi ûnˀä́n hânho idaˀiˀ, heḏi nä́ˀi tꞌôeˀi-á nahayḏi chuwa kꞌáygé nakꞌóe. ");
INSERT INTO tew_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Iˀ sundaḏo pꞌóˀḏéḏîˀ Jesus-ví̖ˀgeḏi natꞌoe ihayḏi wên Huḏíyo tsonnin ovâysan Jesus óedaaˀa̖míḏí naˀä̖ä̖-íḏí iví tꞌôeˀiˀ óehehkháamä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jesus najiˀ iwe dipówá ihayḏi pín taˀgeḏi óekhä̖geˀdaaˀan. Óetu̖ˀan, “Nä́ˀi sundaḏo pꞌóˀḏéḏîˀ-á ihay híwóˀdi namuu nä́ˀi iˀgîˀ mânˀa̖míḏí, ");
INSERT INTO tew_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","gá iˀḏá tꞌä̖hkí nanbí tꞌowa dînsígíḏân, heḏá nanbí búˀwi méesateˀay dînkûˀ.” ");
INSERT INTO tew_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Heḏiho Jesus indáḏí namää. Owáy iˀ sundaḏoví tewhá tsowa wáy dipowamän dihayhä̖̂ä̖ iˀḏi ivíˀweḏi wên kꞌemaˀin ovâysan Jesus óejay-íḏí, heḏi indi Jesus óetu̖ˀan, “Nanbí Sedó, wíyá á̖yîngi wíˀúyê̖e̖nípí, naa ihay híwóˀdi wóˀmuupí naví kꞌaygi untsꞌú̖u̖níḏí, ");
INSERT INTO tew_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","heḏá wáˀ ochanpóe naa ihay híwóˀdi wóˀmuupíˀin uvíˀpiye wänbo omú-íḏí. Naví tꞌôeˀi dînhehkháapúuwí gin untú̖ḏí, nahehkháapúuwí-ákun. ");
INSERT INTO tew_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nä́ˀindá naa dînhanginná, gá naa wáˀ hä̖ä̖wí díjôndi dóˀaˀgindoḏân, heḏi naaḏi wây-á sundaḏo dovâytsonmáa, heḏi dâyˀaˀgindoˀ. Wí sundaḏo ‘Ópûn’ gin dótu̖ˀandi, i-á namääˀä̖, heḏi wíyá wêe ‘Ókä̖ˀve’ gin dótu̖ˀandá, i-á naˀä̖ä̖ˀä̖. Naví pantꞌôeˀi ‘Haˀwâa óˀan’ gin dótu̖ˀandi, háa otú̖ waa iˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus óeháaˀan nä́ˀin natꞌoeḏi, heḏi ibéeḏí in tꞌowa ûnwóeˀä̖ˀin ovâytu̖ˀan, “Nä́ˀin wâytu̖ˀa̖mí, hä̂nhay wänbo wí toˀwí báyékí wä̖yu̖ nä́ˀi sen waagi imáaˀi wíḏóshaapí, Israel iweˀin wänbo-á joe.” ");
INSERT INTO tew_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Heḏi iˀ sundaḏo pꞌóˀḏéḏîˀví tewhá iwepiye in iví kꞌaygiˀin diˀä̖ä̖ˀin diwáymää, heḏi iˀ tꞌôeˀi nawówaḏi óeshaa. ");
INSERT INTO tew_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wí hä̖́yú̖ thaa naphaḏe ihayḏi Jesus wí búˀay Nain gin dâytu̖ˀoˀ iwepiye namää. Iví khä̖ge̖ˀnindá heḏá wây-á báyékí tꞌowa-á i-áḏíbá dimää. ");
INSERT INTO tew_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ee búˀ tehpaa phóḏi tsowa dimän dihayhä̖̂ä̖ wí eˀnú nachuuˀiˀ óekhä̖hkugihon. Iˀ eˀnú nachuuˀi-á wí kweeví wêeḏa̖ˀ ay ûnˀä́ndiˀ ûnmuu, heḏi iˀ kweeví sedó wáˀ ho ûnchuu. Báyékí iˀ búˀin tꞌowa iˀ jíyá-áḏí dijiˀ. ");
INSERT INTO tew_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nanbí Sedó Jesus-di iˀ kwee óemûˀ ihayḏi ivíˀpiye nasehkanäpóe, heḏi óetu̖ˀan, “Wívisíhtä̖ä̖-ípí.” ");
INSERT INTO tew_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Heḏi ihá̖ḏiḏi iˀ peníphébay itä̖ge, heḏi in dâyhonnin dívíwóyí̖ˀ, heḏi Jesus natú̖, “Eˀnú, óshaa.” ");
INSERT INTO tew_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Heḏi iˀ nachuuˀiˀ idaygisógeḏi ûnhíˀpaa, heḏi Jesus-di iˀ jíyá óetu̖ˀan, “Nä́ä uví eˀnú úˀä́n.” ");
INSERT INTO tew_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tꞌä̖hkíḏíbo dikhunwôedaˀpóe, heḏi Jôesi Táḏá kwꞌáayéboˀ óemáa. Ditú̖, “Wí Jôesi Táḏáví tukheˀbi hayˀi naˀä̖ä̖ naˀindáḏí nachaníḏí, Jôesi Táḏá-á naˀä̖ä̖ iví tꞌowa ikhä̖geˀnamíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","In Huḏíyoví nange tꞌä̖hkí heḏá iˀ nange bûu kꞌuwakí nakwꞌóˀdi-á in tꞌowa háa Jesus iˀannin ditꞌoe. ");
INSERT INTO tew_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John i pꞌóˀpꞌoekandiví khä̖geˀnindi John óetu̖ˀan nä́ˀi hä̖ä̖wí tꞌä̖hkí napóe i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Heḏi John-di wíje iví khä̖geˀnin ovä̂ntu̖hkánnan, heḏi Nanbí Sedó Jesus-víˀpiye ovä̂nsan óetu̖ˀa̖míḏí, “Hä́nˀoe ditû̖ˀ wí toˀwí Jôesi Táḏáḏí dînsankhâymáaˀin. Ti u̖-ân iˀ unmuu, háa wíyá toˀwí âynuuwä̖́-í?” ");
INSERT INTO tew_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jesus najiˀ iwe dapówá ihayḏi óetu̖ˀan, “John iˀ pꞌóˀpꞌoekandiˀḏi naˀin dísan uvíˀpiye wên háawên wítsikaˀya̖míḏí,” heḏáháˀ John-bí tsika óetsikaˀyan. ");
INSERT INTO tew_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dapówá ihayhä̂äḏibá Jesus-di in tꞌowa tꞌä̖mäge dihayˀin hehkháa ovâymäˀ, heḏá yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖-á in ovâymáaˀinbíˀweḏi ovâykhehpiyendeˀ, heḏá ditsíˀtꞌaamuuˀindá inbí keetandá ovâymäˀ. ");
INSERT INTO tew_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Heḏiho Jesus-di ovä̂ntu̖ˀan, “Jaho báwáypûn heḏi John dä̂ntu̖ˀâ̖a̖mí háa dä̂nmûˀ heḏá datꞌoe waagibá. In tsíˀtꞌaaˀin inbí keetan dâywáyhóndeˀ, in ditsiˀḏeeˀipíˀindá ditsiˀḏee, in diphéetaymuuˀindá diwówaˀ, diˀojetꞌaamuuˀindá ditꞌoeˀo, in dichuuˀindá diwáywówápoeˀo, heḏá Jôesi Táḏáví híwóˀdi tundá in sehkanäwó diwówájiˀin ovâytꞌôeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iˀ toˀwí iví wä̖yu̖ navíˀpiyeˀ wíˀûnhándepîˀ-á híhchan imáˀve-í.” ");
INSERT INTO tew_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","In John-bíˀweḏi daˀä̖ä̖ˀin dawáymää ihayḏi Jesus-di in báyékí tꞌowa i-áḏí dijiˀin ovâytsikaˀyan, “Ahkónupiye John ítꞌoe-íḏí ímää ihayḏi, hä̖ä̖-an íˀân bînmúníˀin? Ti wí toˀwí wên poesú waagibá wa̖a̖ḏi óepheḏemáaˀiˀ? ");
INSERT INTO tew_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Heḏi hangîˀ wíˀímääpíḏí, hä̖ä̖-an handi bînmúuníḏí ímää? Ti wí toˀwí koḏitꞌowa waagi naˀaamuuˀiˀ? Ti wíˀúnhanginnáhpíˀan iowápoeˀo, heḏá Jôesi Táḏán saˀwóˀgí dívíˀawendeˀindá heḏá hä̖ä̖wí tꞌä̖hkí dâymáaˀindá tsonninbí tewhá heˀendi eeje dithaa. ");
INSERT INTO tew_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Heḏi wí toˀwí giˀbiˀ ípu̖wä̖määpíḏí hä̖ä̖-an handi ípu̖wä̖mää? Ti wí Jôesi Táḏáví tukheˀbi gáhân? Naaḏi wâytu̖ˀâ̖a̖mí John-dá wí Jôesi Táḏáví tukheˀbi namuu-ákun, hewänbo shánkí wänbo namuu. ");
INSERT INTO tew_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","John-nânkun namuu iˀ tꞌôekhuwaˀi Jôesi Táḏáví taˀnin diwe iví̖ˀgeḏi nataˀmuuˀiˀ. Jôesi Táḏáḏí iˀ toˀwí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí óehíˀmáaḏí óetu̖ˀan, Ótꞌôeyan, naaḏi wí naví tꞌôekhuwaˀiˀ uví páaḏé wînsankhâymáa. Iˀḏân in pꞌôe wônkhâyˀa̖mí unpówápíḏíboˀ.” ");
INSERT INTO tew_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Heḏáháˀ Jesus natú̖, “Naaḏi wâytu̖máa, toˀwí wänbo nä́ä oepáa kꞌayḏi nää puwahay naˀaypu̖yä̖ˀi John-bí shánkí kwꞌáye wínamuupí. Hewänbo nää pha̖a̖piyeḏi in toˀwên Jôesi Táḏáví tun tꞌowa ovâytꞌôeˀoˀindáho John-bí shánkí kwꞌáye dimuu, tobá kwꞌáye dimuupíˀin waagin dimuu. ");
INSERT INTO tew_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Heḏi in tax phahsannindáḏí heḏá wây-á báyékí tꞌowa-áḏí John ôntꞌôeyan, heḏi John-di ovâypꞌóˀpꞌoeˀan. Gin dívíˀandá dâykeeyan dívíwä̖yundeˀin Jôesi Táḏá-á híwó iˀoˀin. ");
INSERT INTO tew_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Hewänbo in Pharisees-á heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá wíḏihíjepí John-di ovâypꞌóˀpꞌoeˀa̖míḏí, heḏiho gindiḏi dâykeeyan dâyjoegiˀannin háa Jôesi Táḏá nadaˀ waa ingîˀ ovâyˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Hânnan otú̖u̖ní nä́ˀin nää diwówájiˀin tꞌowaví̖ˀgeḏi? Háawin tꞌowa-an dimuu? Hä̖ä̖ waagiˀinnan dimuu? ");
INSERT INTO tew_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gá áyyä̖̂ä̖ dimuu bûu pinge dikwꞌóˀnin waagiˀinnân dimuu, wáy wêndi in wéˀgen ovâytu̖wí̖núndeḏi, ‘Wâykhóhtsa̖a̖khaˀpúwhä̖ä̖ˀandi wíˀúvíjáḏéndepí, heḏá wâypeníkhaˀwandá wíˀúvísíhtä̖ä̖ḏepí.’ ");
INSERT INTO tew_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ginnân otundaˀ: John iˀ pꞌóˀpꞌoekandi napówá ihayḏi iha̖a̖ḏä́ˀan heḏá wíˀiméenasu̖wä̖pí, heḏiho un ítú̖, ‘Wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáa.’ ");
INSERT INTO tew_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hewänbo naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ wéˀgen tꞌowa-áḏí dáyhúujo heḏá dósu̖wändeˀ, heḏiho ítú̖, ‘Binmúˀḏí, i-á naha̖ˀtꞌaa, heḏá su̖wä̖toˀi-ân namuu, heḏá hä̖ˀin tax phahsannindáḏí in wéˀgen tꞌaywóhkannindáḏí inbí kꞌema dínmuu.’ ");
INSERT INTO tew_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hebo tobá gin ítû̖ˀ wänboˀ, in toˀwên Jôesi Táḏáḏí hangintan ovâymä́giˀindá ditû̖ˀ, ‘Taˀgendi Jôesi Táḏá báyékí ihangintanmáa’.” ");
INSERT INTO tew_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wí Pharisee Simon gin nakhá̖wä̖́ˀiˀḏi Jesus óehúutu̖ˀan, heḏiho iˀ Pharisee-ví tewhá iwepiye namääḏi ihúusóge. ");
INSERT INTO tew_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ee búˀbá wí kwee tꞌaywóhkandi namuuˀi nathaa. Nä́ˀi kwee-á Jesus iˀ Pharisee-víˀwe ihúujoˀin ûnhanginpóe ihayḏi iwepiye namää. Wên tsꞌä̖ˀin pꞌonbayˀay saˀwó nasundi ka̖ˀpꞌoe ûnkuˀunnin i-áḏí ihoˀ. ");
INSERT INTO tew_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesus-ví ân núˀ idégeˀdisóge, heḏi isíhtä̖ä̖ḏeˀ. Iví tsíˀpꞌoe Jesus-ví ân deeḏi ûnjemuḏi iví whä̂ndi ôntꞌawe, heḏi óeˀânpꞌohtsä̖ˀ, heḏi iˀ ka̖ˀpꞌoe saˀwó nasundiḏá ân deeḏá ônˀeweḏáháˀ óeˀä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iˀ Pharisee Jesus óehúutu̖ˀandiˀ nä́ˀi imûˀ ihayḏi iˀánshaamáa, “Nä́ˀi sen taˀgendi Jôesi Táḏáví tukheˀbi namuuḏáhoˀ, ûnhanginnáaníwän nä́ˀi kwee óetä̖gendeˀiví̖ˀgeḏi toˀwí heḏá háawi namuuˀin, i-á tꞌaywóhkandi namuuḏi.” ");
INSERT INTO tew_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus-di Simon óetu̖ˀan, “Naa u̖-áḏí ohíˀdaˀ.” Simon-di Jesus óetu̖ˀan, “Heḏáho há̖hkandiˀ, hä̖ä̖-an naa dítu̖ˀa̖míˀin undaˀ?” ");
INSERT INTO tew_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus-di ginnân óetu̖ˀan: “Wíje senäˀ wí chä̖ˀ píyépä̖ˀi sen dachä̖ˀphaamuu. Iˀ wêe pꞌánä́n tä̖gintä̖ (500) kwä̖́kꞌu tsꞌä̖ˀi naphaamuu, heḏi iˀ wêe-á pꞌánä́ntä̖-á (50). ");
INSERT INTO tew_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hewänbo wíḏä́nkoḏipí dänwáˀâa-íḏí, heḏiho wíˀgíndí iˀ daphaamuuˀiˀḏi ovä̂nˀowójé. Wéˀiḏan in wíje senäˀ diweḏi shánkí óesígí? Hân u̖-á unˀándeˀ?” ");
INSERT INTO tew_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon-di Jesus óetu̖ˀan, “Gá iˀ shánkí báyékí ônˀowójéˀiˀḏân shánkí óesígí, gin naa oˀándeˀ.” “Taˀge untú̖” gin Jesus-di óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Heḏi Jesus ibéeḏí iˀ kwee óemúndeˀ, heḏi Simon óetu̖ˀan, “Ti nä́ˀi kwee nâamúndeˀ? Naa uví kꞌaygi otsꞌûndi u̖ˀḏá wí pꞌoe wänbo wíḏímä́gipí naa dáyˀânˀowêeḏi-íḏí, hewänbo iˀḏá iví tsíˀpꞌoeḏi díˀânpꞌoeˀan, heḏá iví whä̂ndá dípꞌoepíḏi. ");
INSERT INTO tew_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","U̖ˀḏá wíḏípꞌohtsä̖ä̖pí uví kꞌaygi dísígíˀa̖míḏí, hewänbo iˀḏá otsꞌûn waagibo díˀânpꞌohtsä̖ḏi wíˀiwóyí̖ˀpí. ");
INSERT INTO tew_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","U̖ˀḏá wíḏípꞌóhka̖ˀanpí dînkeeya̖míḏí uví kꞌaygi díhéegíˀannin, hewänbo iˀḏá hä̖ˀi ka̖ˀpꞌoe saˀwó nasundiˀ naví ân deeḏi díˀä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Heḏiho wítu̖ˀâ̖a̖mí, nä́ˀi kwee-á iví báyékí sígí ûnmuuḏi ikeejoˀ báyékí tꞌaywóˀdi ûnˀowóˀjennin, hewänbo wí toˀwí naˀándeḏi hínchä̖̂ä̖ḏa̖ˀ ûnˀowóˀjennin, i-á hínchä̖̂ä̖ḏa̖ˀ sígí imáa.” ");
INSERT INTO tew_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Heḏáháˀ Jesus-di iˀ kwee óetu̖ˀan, “Uví tꞌaywóˀdi-á úˀowóˀjen.” ");
INSERT INTO tew_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wây-á i-áḏí dívíhúujoˀin dívíˀánshaamáa, “Háawi sennan nä́ˀi namuu? Natû̖ˀ tꞌaywóˀdi iˀowójénde wáˀ.” ");
INSERT INTO tew_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Hewänbo Jesus-di iˀ kwee óetu̖ˀan, “Uví wä̖yu̖ úmuuḏiho wônˀowójé. Ánshaaginpíḏíboˀ ópûn.” ");
INSERT INTO tew_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iweḏi wí hä̖́yú̖ thaa iwe Jesus báyékí búˀây eejepiye namää, heḏi iˀ híwóˀdi tun ovâytꞌôekanhon háa Jôesi Táḏá nakhâymuu waa tꞌowa ovâysígíhóníḏí. Iví tä̖ˀḏi wíje (12) khä̖geˀnin wáˀ i-áḏíbá dijiˀ. ");
INSERT INTO tew_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Wên kwiyä̖ˀ wáˀ Jesus-áḏí dijiˀ, indá Mary-á, Joanna-á heḏá Susanna-á dimuu. Nä́ˀin kwiyä̖ˀ dihaywän heḏá yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏá óemáawän, hewänbo Jesus-di hehkháa ovâymä́gi. Mary-á tꞌowaḏi óekhá̖yä̖́ˀdeˀ “Magdala búˀwi kwee” gin, heḏá Jesus-di tséḏí dijiˀin yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ ivíˀweḏi ônkhehpiye. Joanna-ví sedó Chuza-á iˀ nanagewi tsondi Herod-ví kꞌaygi iwe ihä̖ä̖wíˀá̖yí̖ˀdoˀ. Wây-á báyékí kwiyä̖ˀ wáˀ Jesus-áḏí iví khä̖geˀnindáḏí dimän, heḏi iˀ hä̖ä̖wí nä́ˀin kwiyä̖ˀ dínkwꞌóˀdi Jesus-á iví khä̖geˀnindá diyä̖́mu. ");
INSERT INTO tew_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tꞌowa báyékí búˀây eejeḏi Jesus-víˀpiye dimää, heḏi báyékí ditꞌowawéˀgepóe ihayḏi Jesus-di nä́ˀin há̖hkangíˀin óˀgéḏí ovâytu̖ˀan: ");
INSERT INTO tew_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wí koˀjikwoˀi namää iví koˀji wóegé, heḏi ee nava i̖ˀge ikoˀjiwáḏe. Wáy wí koˀji in pꞌôeˀay nava pínu nakꞌóe i̖ˀge najemu, heḏi tꞌowa diphaḏemändi iˀ koˀji kwꞌáayé dívíˀa̖hsaa, heḏi tsíḏé dívíshunwá̖veḏi iˀ koˀji dâykꞌoe. ");
INSERT INTO tew_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wíyá koˀji-á nakꞌuunáˀ deeḏá najemu, heḏi natsijópúpóe wänbo wínaˀomúnáhpíḏí natꞌaa. ");
INSERT INTO tew_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wíyá koˀji-á wä̖́ä̖ˀi phéˀyä̖́vi jâa-á najemu, heḏi iˀ phéˀyä̖́vi nasôeḏi óeˀánhógi. ");
INSERT INTO tew_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hewänbo wíyá koˀji-á híwóˀdi nan deeḏá najemu, heḏi tä̖gintä̖ (100) maˀkwꞌanukí shánkí napaa.” Gin Jesus-di ovâytu̖ˀan heḏáháˀ kayˀindi natú̖, “Toˀwên naví híˀ ditꞌoeˀindá híwó dívítꞌôeyaaníˀin dínkhâyˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesus-ví khä̖geˀnindi óetsikaˀyan hân nä́ˀin óˀgéḏí natundaˀin. ");
INSERT INTO tew_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Heḏi Jesus-di ovâytu̖ˀan, “Jôesi Táḏáḏí wovâymä́gi íkaˀpóewíḏí háḏíḏí iˀḏi nää tꞌowa ovâysígíhóndeˀ i̖ˀgeḏi, hewänbo in wéˀgendá dovâyhá̖ˀoḏi óˀgéḏíḏa̖ˀ dovâytu̖máa, heḏânho wíḏikaˀpóewípíḏí. Jôesi Táḏáví taˀnin diwe ginnân inbí̖ˀgeḏi nataˀmuu: Tobáháa dâymúnde wänbo wíḏínkeepoeˀopí, heḏá ditꞌoeˀo wänbo wíḏikaˀpóyaˀpí. ");
INSERT INTO tew_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nä́ˀi híˀ iˀ koˀji i̖ˀgeḏi ginnân natundaˀ: Iˀ koˀji-á Jôesi Táḏáví tun waagiˀbá namuu. ");
INSERT INTO tew_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wáy wên tꞌowa iˀ nan nava pínu napꞌôeˀaymän niˀge nakâymuuˀi waaginbá dimuu. Jôesi Táḏáví tun ditꞌoe, hewänbo Penísendi naˀä̖ä̖ḏi iˀ tun inbí píˀnä́ khóˀjéḏí ovâywhahóndeˀ, heḏiho wíḏívíwä̖yundepíḏí háˀto ovâyˀaywoení. ");
INSERT INTO tew_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wây-á tꞌowa-á iˀ nan nakꞌuunáˀdi waaginbá-á dimuu. Jôesi Táḏáví tun ditꞌoeḏi híhchandi dâysígíˀoˀ, hewänbo wíḏipúumuupí waagibá dimuu. Hây tä̖hkíḏa̖ˀ dívíwä̖yundeˀ, hewänbo ovâytayindeˀ ihayḏá wíyá wíḏívíwä̖yundepí. ");
INSERT INTO tew_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wây-á tꞌowa-á iˀ wä̖́ä̖ˀi phéˀyä̖́vi nasaaˀi nan iwáygé wí koˀji najemuˀi waagiˀbá-á dimuu. Jôesi Táḏáví tun ditꞌoe, hewänbo báyékí hä̖ä̖wí nä́ä oepáa kꞌayḏiwiḏi ovâyˀá̖yîngimäˀ, dikoḏitꞌowamúuníˀindá didaˀ, heḏá háa dihíhchanpúuwí i̖ˀgeḏiḏa̖ˀ dívíˀánshaaˀoˀ. Heḏânho hanbá dínpoeˀo iˀ koˀji óeˀánhógiˀi waagibá, inbíˀweḏi hä̖́ä̖bo wínapayeḏeeˀipí waagibá napoeˀo. ");
INSERT INTO tew_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hewänbo wây-á tꞌowa-á iˀ híwóˀdi nan iwáygé wí koˀji najemuˀi waagiˀbá-á dimuu. Jôesi Táḏáví tun ditꞌoeḏi pín taˀgeḏi inbí píˀnä́ khóˀjé dâyhóndeˀ, heḏá híwóˀnin ánshaaˀin dimuuḏi wíḏâyjoeˀopí, heḏi dívíyä̖́ä̖ˀoḏibo híwóˀdi hä̖ä̖wí dívíˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Toˀwí wänbo wên phakó ikoˀankíḏí wí sä̖ˀwéḏí wíˀikaajopí háa whohte phoˀ wíˀitóeˀópí. Hewänbo wên phakóbay iwân ikéeˀí, heḏânho toˀwí íve natsꞌûndi iˀ ko imúuníḏí. ");
INSERT INTO tew_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Heḏi hanbá hä̖ä̖wí tꞌä̖hkí nää nakaamuuˀi-áho owáy hä̖̂ä̖ḏibo nakeepúuwí, heḏá hä̖ä̖wí nää nakaˀpowamuupîˀ-áho owáy hä̖̂ä̖ḏibo nathaypúuwí nakaˀpowapúuwíḏí. ");
INSERT INTO tew_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Heḏânho á̖yîngiḏi naví híˀ dîntꞌôeyanbe. Toˀwí itꞌôeyandeḏi naví híˀ dînkaˀpóyaˀdi-á shánkí wänbo óekaˀpowamä̂äní. Hewänbo toˀwí nakaˀpóyaˀpîˀ-á, tobá nakaˀpóyaˀ gin naˀánde wänboˀ, i hí̖yä̖̂ä̖ ho nakaˀpówáˀiˀ ônkaaya̖mí” gin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus-ví jíyá-áḏí iví tíˀûuwindáḏí ee Jesus naˀä́n diwepiye dimää, hewänbo báyékí ditꞌowajiḏi wíḏínkoḏipí iví tsowa dívíhâ̖a̖ḏi-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Toˀwíḏí Jesus óetu̖ˀan, “Uví jíyá-áḏí uví tíˀûuwindáḏí oe jáˀwé diwin heḏi wóemúuníˀin didaˀ.” ");
INSERT INTO tew_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus-di in tꞌowa ovâytu̖ˀan, “In toˀwên Jôesi Táḏáví tun dâytꞌôeyandeḏi dâyˀaˀgindoˀinnânho naví jíyá-á naví tíˀûuwindá dînmuu.” ");
INSERT INTO tew_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wí thaa Jesus-áḏí iví khä̖geˀnindáḏí wí kophé iwe dívítógi, heḏi Jesus-di ovâytu̖ˀan, “Jaho oe pꞌoekwí̖ˀ pꞌä̖́näpiye gimú-í.” Heḏiho iwepiye dimää. ");
INSERT INTO tew_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Waˀ pꞌoe iwéngé dimän dihayhä̖̂ä̖ Jesus najókhá̖. Ihayḏibá wí wa̖a̖ hânho kayˀiˀ iˀ pꞌoekwíngé napówá, heḏi hânho napꞌoetꞌúkhú̖poeˀoḏi inbí kophé dínpꞌohkuuḏee heḏi ovâyˀu̖gekhâyˀan. ");
INSERT INTO tew_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesus nakꞌóe iwepiye dimääḏi óejóhsan, heḏi óetu̖ˀan, “Nanbí tsondiˀ, dípꞌotꞌakha̖nukhâyˀoˀ.” Heḏi Jesus ishaaḏi kayˀindi iˀ wa̖a̖-á i heˀendi pꞌoetꞌúkhú̖-á ovä̂nhéeˀan, heḏi iˀ wa̖a̖ nawóyí̖ˀdee, iˀ pꞌoe-á nahángípóe. ");
INSERT INTO tew_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ihayḏá iví khä̖geˀnin itu̖ˀan, “Heháaḏan wä̖yu̖píˀin ímuu?” In khä̖geˀnindá dikhunwôedaˀḏá ovâyháaˀan, heḏi dívípitu̖máa, “Háawi sennan nä́ˀi namuu? Wa̖a̖-á pꞌoe-á wänbo ijôndi óeˀaˀgindoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Oe pꞌoekwí̖ˀ pꞌä̖́nä ee Gerasene-bí nange dipówá, owáy hánä pꞌoekwí̖ˀ pꞌä̖́näḏá Galilee-á naná. ");
INSERT INTO tew_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesus owáy nange wáypiye iˀ kophé iweḏi nawá̖ˀ dihayḏi, wí sen iˀ búˀwi namuuˀi naˀä̖ä̖ óejay-íḏí. Nä́ˀi sendá yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi óemáa, heḏá báyékí pa̖a̖yo aapíḏíboˀ ijíyéndeˀ, heḏi tewhá ee wínathaapí, hewänbo tꞌowápho eejân nathaa, dâypeníkhä̖ˀkwꞌóeˀó iwe. ");
INSERT INTO tew_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi iˀ sen hä̖́yä́nbo óekaygiˀan iˀa̖míḏí háa iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ nadaˀ waagi, heḏi tobáháa tꞌowaḏi iˀ sen wí pan waagibá kaḏénaḏi óemanwhiˀo heḏá óekwä̖́kꞌukhú̖whiˀo wänboˀ, ihayḏa̖ˀ iwhiˀtsꞌâˀḏi namaˀpꞌä́ndeˀ, heḏá iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi oe ahkónupiye óeshavekandoˀ. Jesus-di iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ óejôn iˀ senbíˀweḏi napee-íḏí, heḏi iˀ sendi Jesus óemûˀḏi iví páaḏépiye idégeˀdisóge heḏi itu̖wí̖nú, “Heháaḏan u̖ˀḏi ánpí wíḏíˀohpí Jesus, u̖ Jôesi Táḏá iˀ shánkí kwꞌáye naˀä́ndiví ay unmuuˀiˀ? Naaḏi kayˀindi wídaˀmáa, wíḏítꞌôephaḏekannamípí.” ");
INSERT INTO tew_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus-di óetsikaˀyan, “Hân unkhá̖wä̖́?” Heḏi natú̖, “Gá ‘Báyékí’ gân.” Gin natú̖ gá báyékí yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi óemáaḏân. ");
INSERT INTO tew_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","In yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi Jesus kayˀindi óedaaˀan oe péyégépiye wíˀovâysaanípí. ");
INSERT INTO tew_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Iwe tsowa wáy okú wáhkí báyékí pehtsuḏe dihúujiˀ. In yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi Jesus kayˀindi óedaaˀan ovâymä̂äníḏí in pehtsuḏeví túˀ eeje dívítôeníḏí, heḏiho ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","In yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ iˀ senbíˀweḏi dipeeḏi in pehtsuḏevíˀye dívítógi, heḏi in báyékí pehtsuḏe iˀ okú wáhkí oe áagépiye dívíˀä̖ä̖wá̖ve, heḏi iˀ pꞌoekwí̖ˀ diwe diwândi dívípꞌotꞌahá̖nú. ");
INSERT INTO tew_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","In pehtsuḏe á̖yí̖ˀnin háa napóeˀin dâymûˀḏi dijân, heḏi iwáy búˀ heḏá búˀḏí jáˀwé-á i̖ˀgeḏi dâytꞌôehoˀ, ");
INSERT INTO tew_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","heḏiho in tꞌowa dimää dâymúuníḏí. Oe Jesus naˀä́n diwe dipówá ihayḏá iˀ sen ivíˀweḏi in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ ovâykhehpiyeˀi Jesus-ví ân núˀ naˀä́ndí dâyshaa. Nää-á naˀaamuu heḏá iví hangintandá imáa. Óemûˀ ihayḏi dikhunwôedaˀpóe. ");
INSERT INTO tew_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Heḏi in tꞌowa háa napóeˀin dâymûˀindi in wéˀgen dipówáˀin ovâytu̖ˀan háḏíḏí iˀ sen ônhehkháaˀannin. ");
INSERT INTO tew_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Heḏi in Gerasene-win tꞌowa heḏá in tsowa dithaaˀindá dikhunwôedaˀḏi Jesus óedaaˀan inbí nangeḏi ijâatä̖ä̖-íḏí. Heḏiho iˀ kophé iwe itógi pꞌoˀ pꞌä̖́näpiye nawáymú-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iˀ sen in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ ivíˀweḏi ônjâaˀandiˀḏi Jesus pín taˀgeḏi óedaaˀan, “Naa u̖-áḏí dípunmä́ä.” Hewänbo Jesus-di óepunjôndi óetu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uvíˀpiye ópûn, tꞌä̖hkí háa Jôesi Táḏáḏí u̖gîˀ wônˀannin ovâytꞌôeˀa̖mí.” Heḏiho namääḏi toˀwên tꞌä̖hkí ee búˀ ovâytu̖ˀan háa Jesus-di igîˀ ônˀannin. ");
INSERT INTO tew_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus oe pꞌoekwí̖ˀ pꞌä̖́näḏi nawáyˀä̖ä̖, heḏi napówá ihayḏi báyékí tꞌowa óetsíkhaˀmáaˀindi óesígíkêˀ. ");
INSERT INTO tew_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wí sen Jairus gin nakhá̖wä̖́ˀi naˀä̖ä̖, i-á in Huḏíyoví méesateˀaywi pꞌóˀḏéḏîˀ namuu, heḏi Jesus-ví páaḏépiye idégeˀdisógeḏi pín taˀgeḏi Jesus óedaaˀan iví tewhá ipiye namú-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Iví wêe aˀyú̖ ûnˀä́ndiˀ ûnchuwamääˀä̖. Iˀ aˀyú̖-á maḏi tä̖ˀḏi wíje (12) pa̖a̖yoˀi namuu. Jesus iˀ táḏá-áḏí namääḏi in tꞌowa iví núˀ dívítꞌä̖́ˀtꞌä̖́ˀbóeḏímáa. ");
INSERT INTO tew_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wí kwee wáˀ ûnwóemän, i-á napꞌóehayḏi tä̖ˀḏi wíje (12) pa̖a̖yo iví ûnpꞌoe wíˀûnwóyí̖ˀdeeˀipí, heḏi toˀwí wänbo wíˀûnkoḏipí ônhehkháaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nä́ˀi kwee-á Jesus-ví tíˀûupha̖ˀgeḏi naˀä̖ä̖ḏi iví kꞌéwéˀin toˀ kꞌáygéḏí ôntä̖ge, heḏi wesebo iví ûnpꞌoe ûnwóyí̖ˀdee. ");
INSERT INTO tew_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus natsikapóe, “Toˀḏan naa dítä̖ge?” Hewänbo tꞌä̖hkí ditú̖, “Naa-á joe.” Heḏá Peter-dá óetu̖ˀan, “Há̖hkandiˀ, báyékí tꞌowa dijiḏi nä́ä uví núˀpiye dívíkha̖ḏimáˀḏí wóetꞌä̖́ˀtꞌä̖́ˀchä̖numáa.” ");
INSERT INTO tew_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hewänbo Jesus natú̖, “Toˀwíḏáho dítä̖ge-ákun. Naa dînhanginná hehkháa pínnán navíˀweḏi dînpeeˀin.” ");
INSERT INTO tew_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iˀ kwee nää ûnhanginná háˀto ikaamáˀve-íˀin, heḏiho natha̖tha̖póeḏí naˀä̖ä̖ḏi Jesus-ví páaḏépiye idégeˀdisóge, heḏi in tꞌowaví páaḏépiyebo ithayyan háaḏí Jesus óetä̖geˀin heḏá háa wesebo-á nahewówaˀindá. ");
INSERT INTO tew_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus-di óetu̖ˀan, “Naví ay, uví wä̖yu̖ úmuuḏi unhewówa. Ánshaaginpíḏíboˀ ópûn.” ");
INSERT INTO tew_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Waˀḏi ihíˀmáa ihayḏibo wí toˀwí iˀ méesatewi pꞌóˀḏédîˀví tewhá iweḏi napówá heḏi natú̖, “Jairus, uví ayú̖káy ho úchuu. Iˀ há̖hkandiˀ ánpí óˀan.” ");
INSERT INTO tew_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hewänbo Jesus nä́ˀi natꞌoeḏi Jairus óetu̖ˀan, “Wíˀunkhunwôedaˀípí. Biwänpiwä̖ä̖yú̖-í-á nawôewa-íˀin heḏiho nawôewa-í-ákun.” ");
INSERT INTO tew_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","I tewhá ee dipówá ihayḏi Peter-á John-dá James-á heḏá i ayú̖káyví táḏá-áḏí jíyá-áḏí Jesus-di ovâytsuḏemä́gi, wíyá toˀwí wänbo-á joe. ");
INSERT INTO tew_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iˀ ayú̖káy nachuuḏi tꞌä̖hkíḏíbo dívísíhtu̖wí̖núndeḏá dívípí̖hkhú̖mahpúuḏeˀ, hewänbo Jesus-di ovâytu̖ˀan, “Wíˀúvísíhtä̖ä̖-ípí. Wínachumuupí, nawänpijókha̖wä̖kꞌóe-á.” ");
INSERT INTO tew_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Indi ônwänpipꞌáhkaa, dínhanginnândi iˀ ayú̖káy-á ho nachuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hewänbo Jesus-di iví man ônyâ̖ˀḏi kaygi óetu̖ˀan, “Óshaa ayú̖káy.” ");
INSERT INTO tew_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","I ayú̖káy nawáywówápóe, heḏi wesebo ishaa, heḏi Jesus-di ovâytu̖ˀan, “Wí hä̖ä̖wí binmä́ä ikꞌoˀíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iˀ táḏá-á iˀ jíyá-á hânho ovä̂nháaˀan, hewänbo Jesus-di ovä̂nkhâ̖a̖kꞌûˀ toˀwí wänbo wíḏä̂nhanginˀânnamípíˀin háa napóeˀin. ");
INSERT INTO tew_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus iví tä̖ˀḏi wíje (12) khä̖geˀnin iwéˀgeˀandi pínnán ovâymä́gi heḏá ovâykꞌûˀ in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpeeyé-íḏí, heḏá inbí hay-á ovâyjâaˀa̖míḏá. ");
INSERT INTO tew_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Heḏáháˀ ovâypunjôn in tꞌowa ovâytu̖ˀa̖míḏí Jôesi Táḏávíˀpiye dívímä̂äníḏí, heḏá ovâyhehkháaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ovâytu̖ˀan, “Hä̖ä̖wí wänbo wívînhûuwípí ímändi, wên uḏuphé wänbo joe, háa wí múu bînhä̖ä̖wíkuu-ígîˀ, háa wí koegîˀ, háa wí chä̖ˀ, háa wây-á wéhpêe to wänbo wívînhûuwípí. ");
INSERT INTO tew_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wí tewhá iwe wovâysígíˀan deebo úvíwóyí̖ˀní, wíyá wáypiye ímää píhay. ");
INSERT INTO tew_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hewänbo wáygé wíwovâysígíˀanpíˀwe, iweḏi ípeemän dihayḏi unbí anto iweḏi bînnaˀjeepêeḏi-í in tꞌowa dínhanginnáaníḏí híwó wíḏívíˀanpíˀin” gin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Heḏiho iví khä̖geˀnin iweḏi dímääḏi iˀ búˀây i̖ˀge tꞌä̖hkí dívítsiˀhon. Jôesi Táḏáví híwó̖ˀdi tun in tꞌowa ovâytꞌôekanhon, heḏá in dihaymuuˀindá hehkháa ovâypä̖hon. ");
INSERT INTO tew_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod iˀ Galilee nangewi tsondi namuuˀi háa napuwamännin ûnhanginpóe, heḏi wíˀûnhanginnáhpí háa nä́ˀi hä̖ä̖wí i̖ˀgeḏi iˀánshaaˀa̖míˀin, gá wáy wên tꞌowa Jesus-ví̖ˀgeḏi ditû̖ˀdân i-á John iˀ pꞌóˀpꞌoekandi namuu nawáywówápóeˀiˀ, ");
INSERT INTO tew_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","heḏá wây-á ditû̖ˀ Elijah nawáykeepóeˀin, heḏá wáˀ wây-á ditû̖ˀ wénä wí in Jôesi Táḏáví hä́nˀoeˀin tukheˀmin nawáywówápóeˀin. ");
INSERT INTO tew_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod natú̖, “Naa otsonpóe John iˀ pꞌóˀpꞌoekandi óekꞌéˀtsꞌâa-íˀin. To-angú nä́ˀi sen namuu, iví̖ˀgeḏi nä́ˀi hä̖ä̖wí otꞌoeˀoˀiˀ?” Heḏiho ikhä̖ä̖ḏe Jesus óemúuníˀin. ");
INSERT INTO tew_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesus-ví tꞌôekhuwaˀin diwáypówá ihayḏi Jesus óetꞌôeˀan háa dívíˀannin tꞌä̖hkí. Heḏi oe Bethsaida búˀaypiye i-áḏí ovâyhoˀ wíˀbo dikwoníḏí. ");
INSERT INTO tew_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hewänbo in tꞌowa dínhanginpóe wáypiye namääˀin, heḏiho tꞌä̖hkíḏíbo ûnwóemää. Iˀḏá tꞌä̖hkí ovâysígíˀan, heḏi ovâyhéeˀan háa Jôesi Táḏá nakhâymuu waa tꞌowa ovâysígíhóeníḏí i̖ˀgeḏi, heḏá in toˀwên dínhehkháatáyˀindá hehkháa-á ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nakinmän dihayḏi iví tä̖ˀḏi wíje (12) khä̖geˀnin ivíˀpiye ûnˀä̖ä̖ḏi óetu̖ˀan, “Nä́ˀin tꞌowa ovâypunjônbe iˀ búˀâypiye heḏá nava hä̖ä̖ tsowa nanân deejepiyá, wáygé dívíwhoˀkwꞌôeníˀin dâynuuwä̖́-íḏí heḏá dâykoegiˀhóeníḏá, gá nä̂äwá ahkonda̖ˀ nanândân.” ");
INSERT INTO tew_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hewänbo Jesus-di ovâytu̖ˀan, “Undânho bînhúujôení.” Indi óetu̖ˀan, “Naˀindá pꞌánú páváˀâyḏa̖ˀ heḏá wíje paˀâyḏa̖ˀbá âymáa. Tꞌä̖hkí nä́ˀin tꞌowagîˀ wígínkoegiˀsaapí, âykoegiˀkumäḏiḏa̖ˀmânhoˀ.” Gin ditú̖ gá in senäˀda̖ˀdibo pꞌánú maapaasôn (5,000) ihay dijiḏân. ");
INSERT INTO tew_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jesus-di ovâytu̖ˀan, “Bintu̖ˀan in tꞌowa pꞌánä́n tä̖gin (50’s) dívíwéˀgeˀa̖mí heḏá hä̖ä̖ nangá dívíkwꞌôení.” ");
INSERT INTO tew_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Heḏiho iví khä̖geˀnin háa ovâytu̖ˀan waagi dívíˀandi tꞌä̖hkí in tꞌowa dívíkwꞌôení gin ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Heḏi Jesus iˀ pꞌánú pává-á heḏá in wíje paa-á ihógi, heḏi makówápiye ibéeḏí ikú̖ˀdaaˀandi iˀ pává-á heḏá in paa-á iháve. Heḏáháˀ iví khä̖geˀnin ovâyˀan in tꞌowa ovâyphaaḏé-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tꞌä̖hkí in tꞌowa dívíhú̖u̖yandi dívíshu̖ˀan, heḏi in khä̖geˀnin tä̖ˀḏi wíje (12) tꞌún pꞌéeḏí iˀ naphaḏeˀi koegiˀ dâywéˀgeˀan. ");
INSERT INTO tew_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wí thaa Jesus wíˀbo ijûusoˀoˀ. Iví khä̖geˀnin iwáy tsowa dijiˀ, heḏi ovâytsikaˀyan, “To-an naa omuu gân nä́ˀin tꞌowa ditû̖ˀ?” ");
INSERT INTO tew_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Indi óetu̖ˀan, “Wên ditû̖ˀ John iˀ pꞌóˀpꞌoekandi-ân unmuu. Wây-á wêndá ditû̖ˀ Elijah-ân unmuu, heḏá waˀḏi wáy wêndá ditû̖ˀ wí Jôesi Táḏáví hä́nˀoeˀi tukheˀbi nawáywówápóeˀi-ân unmuu.” ");
INSERT INTO tew_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Heḏi ovâytsikaˀyan, “Heḏi undá, to-á naa-á omuu gân íˀándeˀ?” Peter-di óetu̖ˀan, “Gá iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, i-ân unmuu.” ");
INSERT INTO tew_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Heḏi kayˀindi ovâykhâ̖a̖kꞌûˀ wíyá toˀwí wänbo wíḏâyhanginˀânnamípíḏí toˀwí namuuˀin, ");
INSERT INTO tew_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","heḏá wáˀ ovâytu̖ˀan, “Naa tꞌowa tꞌä̖hkígîˀ oˀaypu̖yä̖ˀi taˀgendi báyékí dontꞌôephaḏekhâymáa. In Hudíyo tsonnin heḏá in owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá naa díjoegikhâymáa. Díkheˀkhâymáa, hewänbo iweḏi poje thaa iwe owáywówápuwagíˀo.” ");
INSERT INTO tew_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Heḏáháˀ tꞌä̖hkí in tꞌowa ovâytu̖ˀan, “Toˀwên naa-áḏí dikä̖ˀä̖ä̖daˀindá wíḏínkhâyˀä̖hpí háa diwänpidaˀ waagi dívíˀa̖miˀin, hewänbo hä̖̂ä̖ḏi wänbo tꞌä̖hkí inbí phéˀwin dâyhûuwí, heḏá naa-á díyu̖u̖hûuwí. ");
INSERT INTO tew_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Toˀwên inbí wówátsi dâywänpiˀaywoeníˀin didin heḏá in owhaˀ pꞌóˀḏéḏáˀindá inbí wówátsi dipeḏeegíˀo. Hewänbo toˀwên naagîˀ inbí wówátsi dívímä́giˀin, indá inbí wówátsi ditꞌanpúuwí. ");
INSERT INTO tew_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tobá wí toˀwí hä̖ä̖wí tꞌä̖hkí nä́ä oepáa kꞌayḏi nakwꞌóˀdi ihógi wänboˀ, iví wówátsi ipeḏeeˀandi tuhchä̖nu iwân napówáḏá wéˀinnan wên híwó nä́ˀi hä̖ä̖wíḏí óekhâymáa? ");
INSERT INTO tew_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀi saˀwóˀdi kohthay wóegé owáyˀä̖ˀ. Nä́ˀin kohthay-á navîˀ-áḏí naví Táḏávîˀ-áḏí in yä̖ˀḏâaˀin makówáwin tꞌôepa̖ˀa̖a̖ˀinbîˀ-áḏí gínmuu. Heḏi toˀwên nää naa díwôedaˀin heḏá naví há̖hkan dînwôedaˀindá, owáy naa owáyˀä̖ä̖ ihayḏi naaḏi wáˀ in dovâywôedaˀí. ");
INSERT INTO tew_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Taˀgendi wâytu̖máa, naa tsondi omuuˀin bînpu̖wä̖khâymáa, heḏi nä́ˀin napúuwí waˀḏi wáy wên nä́we íjiˀin íhánpíḏíboˀ.” ");
INSERT INTO tew_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wí jâaḏi naphaḏe ihayḏi, Jesus-di tꞌä̖hkí nä́ˀi ovâytu̖ˀan diweḏi, Peter-á James-á John-dá oe pꞌin kwꞌáyepiye i-áḏí ovâyhoˀ ijûusuˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Heḏi iwáygé ijûusuˀoˀ ihayḏi iví tsꞌay háa ûncha̖a̖ˀin piháa ûnkeepóe, heḏi iví aa tꞌä̖hkí tsꞌä̖ä̖ otsꞌáˀiˀ ûnpóe. ");
INSERT INTO tew_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Tsíkhagipí wíje senäˀ kohthay jâaḏiḏi dakeepóe, indá Moses-á Elijah-á damuu, heḏi Jesus-áḏí dänhíˀmáa háa Jesus oe Jerusalem nachuwagíˀo i̖ˀgeḏi, Jôesi Táḏá iˀánshaamä́gi waagi. ");
INSERT INTO tew_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter-áḏí in wéˀgendáḏá té̖e̖gîndi dijókha̖wä̖kwꞌó, hewänbo dijósaˀwo, heḏi Jesus iˀ kohthay jâaḏiḏi dâymûˀ, in wíje senäˀ i-áḏí dawinnindáḏí. ");
INSERT INTO tew_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","In wíje senäˀ Jesus-víˀweḏi dänjâakhâymáawän, heḏi Peter-di óetu̖ˀan, “Há̖hkandiˀ, híwó namuu nä́we gijiˀin. Jaho poje óhkhunteˀây âykwꞌôení, wêe u̖gîˀ, wíyá Moses-gîˀ-á, heḏá wíyá Elijah-gîˀ-á.” Hewänbo iˀánshaaˀanpíḏíbo natu̖hpee. ");
INSERT INTO tew_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Gin natú̖ ihayḏibo wí okhúwá napówáḏí ovâyˀóhkhunnan, heḏi iˀ okhúwáḏí ovâyˀánhógiḏi dikhunwôedaˀpóe. ");
INSERT INTO tew_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Heḏi nä́ˀi tun okhúwá jâaḏiḏi napee: “Nä́ˀi-ân naví ay dînmuu, i-ân dódeˀman. Iˀ bîntꞌôeyaaní.” ");
INSERT INTO tew_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Iˀ tun nahán dihayḏi, Jesus wíˀbo najiˀ iví khä̖geˀnindáḏí. Nä́ˀin napóeˀin iví khä̖geˀnin inbí píˀnä́bo dâymáa, heḏi ihayḏi toˀwí wänbo wíḏâytꞌôeˀanpí háa iˀ thaa dâymûˀin, tíˀúugéḏânho dâyhanginˀânnan. ");
INSERT INTO tew_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wíyá tháwä́n oe pꞌin kwꞌáyeḏi diwáywá̖ˀ dihayḏi báyékí tꞌowa Jesus ûnˀayjaymää, ");
INSERT INTO tew_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","heḏi in tꞌowa jâageḏi wí sendi kaygi óetu̖ˀan, “Há̖hkandiˀ, kaygindi wídaˀmáa unˀä̖ä̖-íḏí naví eˀnú dînmúuníḏí. Iˀḏa̖ˀ dînˀeˀnúˀä́n. ");
INSERT INTO tew_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ginnân nä́ˀi ûnpoeˀo: Wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óekéndeḏáháˀ tsíkhagipí óetu̖hkwínkandoˀ, heḏi túˀ tꞌä̖hká natha̖tha̖poeˀoḏi sóphogeḏi nasóˀokhópeeˀi, heḏi óechä̖nundeḏi óeteetsá̖wä̖́ˀoˀ túˀ tꞌä̖hkí. Hây tä̖hkí wänbo nä́ˀi yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi wíˀóejoeˀohpí. ");
INSERT INTO tew_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naaḏi uví khä̖geˀnin kaygindi dovâydaaˀan nä́ˀi pꞌoewa̖a̖hâ̖a̖ óekhehpeeyé-íḏí, hewänbo wíḏínkoḏipí.” ");
INSERT INTO tew_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus natú̖, “Un nääwin tꞌowa-á wä̖yu̖píˀin ímuu heḏá piˀwên pꞌôe i̖ˀge ímän. Ti undáḏí hä̖̂ä̖ḏi wänbo tꞌä̖hkí dáyyä̖́ä̖ˀa̖mí gáhân?” Heḏáháˀ iˀ táḏá óetu̖ˀan, “Uví enúkáy nä́äpiye mänmáˀ.” ");
INSERT INTO tew_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Waˀ iˀ eˀnú naˀä̖ˀ ihayḏi iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óekanu heḏá óetha̖tha̖kannan. Jesus-di iˀ pꞌoewa̖a̖hâ̖a̖ óetꞌeˀyan heḏi iˀ eˀnú óehehkháamä́gi, heḏi iˀ eˀnúví táḏá óetu̖ˀan, “Nä́we uví eˀnú úˀä́n.” ");
INSERT INTO tew_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Toˀwên tꞌä̖hkí nä́ˀi Jôesi Táḏáví pínnán dâymûˀḏi ovâyháaˀandi ditû̖ˀ, “Tꞌä̖hkí Jesus ikanhondi-á wä̖yu̖píwóˀdi namuu.” Waˀḏi kin dívíhíˀmáaḏí Jesus iví khä̖geˀnin itu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nä́ˀin wâytu̖hkankhâymáaˀin híwó bítꞌôeyan: Naa tꞌowa tꞌä̖hkígîˀ oˀaypu̖yä̖ˀiˀ omuuˀi wây-á tꞌowaví mangepiye díkáaní.” ");
INSERT INTO tew_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iví khä̖geˀnin wíḏínhanginnáhpí háa nä́ˀi tun natundaˀin. Inbíˀweḏi waˀḏi in tun nakaamuu, heḏânho wíḏikaˀpówápí. Hewänbo diwôedaˀ óetsikaˀyâ̖a̖míḏí i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesus-ví khä̖geˀnin dívítu̖hkanmáa wénä wí in diweḏi shánkí hayˀi namuu i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hewänbo Jesus ûnhanginná háa diˀánshaamuuˀin, heḏiho wí ay óekêˀḏi iví hângeḏi óewí̖nú, ");
INSERT INTO tew_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","heḏi ovâytu̖ˀan, “Toˀwíḏí naa dídaˀḏi nä́ˀi ay óesígíkéndeḏi, naa wáˀ dísígíkénde waabá iˀoˀ. Heḏi toˀwí naa dísígíkêˀiˀḏi iˀ toˀwí naa dísandi wáˀ óesígíkéndeˀ. Wí toˀwí un diweḏi shánkí hí̖yä̖̂ä̖ˀiˀ ipipaˀi-á taˀgendi hayˀi namuu.” ");
INSERT INTO tew_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John-di Jesus óetu̖ˀan, “Há̖hkandiˀ, toéwí sen âymûˀ yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpiyendeḏi uví khá̖wä̖́ natû̖ˀdi, hewänbo âykhâ̖a̖ˀa̖míˀin gidaˀ, naˀin diweḏiˀi wínamuupíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Hewänbo Jesus natú̖ “Toˀwí giˀbi wívînkhâ̖a̖ˀa̖mípí. Toˀwí unbíˀpiye háa nacha̖a̖pîˀ-á unbíˀnäpiyeˀiˀbá napoeˀo.” ");
INSERT INTO tew_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iˀ thaa tsowa napowaˀä̖ˀ Jesus wíyá oe makówápiye napee-íḏí, heḏi kaygindi iˀánshaamä́gi oe Jerusalem-piye nawáymú-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Heḏi wên senäˀ iví páaḏé ovâysan wáygé nachangíˀoˀin dâykhâyˀa̖míḏí. Wí Samaria-wi búˀay iwe dipówá, ");
INSERT INTO tew_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","hewänbo in tꞌowa wíḏidaˀpí óesígíkáyjíˀin, gá oe Jerusalem-piye naˀa̖hchândân. ");
INSERT INTO tew_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wíje iví khä̖geˀnin James-áḏí John-dáḏí damuuˀin háa óeˀan niˀgeḏi datꞌoe, heḏi óetu̖ˀan, “Nanbí Sedó, ti undaˀ wí phaa ä́ntu̖hkánnamí makówáḏí nawa̖a̖níḏí tꞌä̖hkí nä́ˀin tꞌowa ovâyphahá̖a̖nú-íḏí?” ");
INSERT INTO tew_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hewänbo Jesus inbíˀpiye ibéeḏí ovä̂ntu̖ˀan, “Haˀwâagi wíḏänhéeˀa̖mípí.” ");
INSERT INTO tew_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Iweḏi wíyá búˀaypiye dimää. ");
INSERT INTO tew_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pꞌóegé dimän dihayḏi wí sendi Jesus óetu̖ˀan, “Wáy unmää eeje wänboˀ, naa eejepiyebá u̖-áḏí omú-í.” ");
INSERT INTO tew_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus-di óetu̖ˀan, “In déˀây nan deeḏi dínphohsaa dívíthaayé-íḏí, heḏá in tsíḏé-á dínyä̖́hsaa, hewänbo naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi wáygé dáykaykhanwówáˀa̖mígîˀ wíḏînnáhpí.” ");
INSERT INTO tew_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesus-di wíyá sen óetu̖ˀan, “Naa díyu̖u̖máˀí.” Hebo iˀ sendi óetu̖ˀan, “U̖-áḏí omääpíḏíbo díwáypunmä́ä naví táḏá dînchuu píhay heḏânho donkhä̖ˀkꞌúuwíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus-di óetu̖ˀan, “In dichumuuˀin waagin dimuuˀindá inbí tꞌowa dínchuuˀin ovâykhä̖ˀkwꞌôení. U̖-áho ópûn tꞌowa ovâytu̖ˀa̖míḏí Jôesi Táḏávíˀpiye dívímä̂äníˀin.” ");
INSERT INTO tew_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wíyá toˀwíḏí óetu̖ˀan, “Nanbí Sedó, naa odaˀ u̖-áḏí omú-íˀin. Hebo u̖-áḏí omääpíḏíbo dípunmä́ä naví kꞌaygiˀin dovâysengitu̖ˀâ̖a̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus-di óetu̖ˀan, “Han biˀandáho wíˀunchä̖ˀmuupí Jôesi Táḏágîˀ bitꞌôeˀa̖míḏí. Wí toˀwí iwhä̖ä̖ḏeḏi ihayḏa̖ˀ tíˀûupiye ibéeḏeˀi waagiˀbá unmuu.” ");
INSERT INTO tew_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nä́ˀi naphaḏe ihayḏi Nanbí Sedó Jesus-di wây-á tségíntä̖ˀḏi wíje (72) senäˀdá ovâydeˀman, heḏá wíˀjengin ovâysan iví páaḏé dimú-íḏí, iˀ búˀây eeje heḏá ówînge eejá wáy namän deepiye tꞌä̖hkí. ");
INSERT INTO tew_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iˀḏi ovâytu̖ˀan, “Báyékí tꞌowa dijiˀ Jôesi Táḏágîˀ ovâywéˀgeˀa̖míḏí, tꞌowa dâyhä̖ä̖wéˀgeˀoˀ waabá, hebo tꞌôeˀindá hä̖́yú̖ wänbo wíḏijihpí. In tꞌowa-á Jôesi Táḏávíˀin ûnmuu, heḏiho ivíˀpiyeˀ úvíjûusuˀa̖mí wây-á tꞌôeˀin ovâysaaníḏí heḏânho báyékí nä́ˀin tꞌowa ônwéˀgeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jaho bípûn, nää wên kꞌúwáˀây ímuu waaginbá naaḏi wâysandeˀ in toˀwên khunjó waaginbá dimuuˀin dijiˀ iwepiye. ");
INSERT INTO tew_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wívînchä̖ˀhûuwípí, wí múu bînhä̖ä̖wíkuu-ígîˀ wänbo-á joe, in íˀantomuuˀinda̖ˀdibo ímú-í. Wíˀúvíhayjêeˀa̖mípí hä̖ä̖ pꞌóegé tꞌowa bînjayˀin thaa tꞌä̖hkí bînhéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Heḏi wáy wí tewhá ítsꞌú̖ˀ deewá, páaḏé in tꞌowa bînsengitu̖ˀâ̖a̖míḏí ginnân ítú̖u̖ní, ‘Jôesi Táaḏáho wovâykhä̖geˀnamí heḏânho nä́ä tewhá íthaaˀin ánshaaginpíḏíboˀ íkwoní.’ ");
INSERT INTO tew_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wí toˀwí háa bîntu̖ˀan waa isígíˀi naˀä́ndáhoˀ, unbí sengitun i-áḏí ûnjoekandee-í, hewänbo toˀwí iwe naˀä́ndiˀ ha̖ˀbi namuupíḏá, unbí híˀ wíˀûnchä̖ˀpúuwípí. ");
INSERT INTO tew_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Iˀ tewhá eebo úvíwóyí̖ˀní heḏá indáḏá úvíhú̖u̖ya̖mí, gá wí tꞌôeˀi-á iví wáˀâaho itꞌandân. Nä̂äwá hä̖ä̖wá oe-á wíyá tewhá eeje wíˀímú-ípí wovâyˀá̖yîngiˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Heḏi wí búˀ iwe ítsꞌûndi wovâysígíˀandi, hä̖ä̖wí wovâysaaˀi bînkꞌoˀí. ");
INSERT INTO tew_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","In dihayˀin iˀ búˀ ee dikwꞌóˀnin bînhehkháamä̂äní, heḏi ovâytu̖ˀâ̖a̖mí, ‘Nää-á Jôesi Táḏáḏí wovâytu̖máa iví tꞌowa ímúuníḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hebo wí búˀ ee ítsꞌûndi wovâysígíˀanpíḏá, ee búˀwi pꞌóegé i̖ˀge ímú-í heḏi ovâytu̖ˀâ̖a̖mí, ");
INSERT INTO tew_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Iˀ naˀjee unbí búˀwi nanbí anto eeje dîntsîndi wänbo ívípêeḏi-í wâykeeya̖míḏí híwó wíˀúvíˀohpíˀin ídaˀpíḏí Jôesi Táḏáví tꞌowa ímúuníḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Naaḏi wâytu̖máa, owáy iˀ thaa Jôesi Táḏáḏí tꞌowa háa híwó háa híwóhpí dívíˀannin ovâytu̖ˀan dihayḏi, giˀbi búˀwin tꞌowa shánkí dâytꞌôephaḏekhâymáa in Sodom búˀwin tꞌowavíˀweḏi.” ");
INSERT INTO tew_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Heḏi Jesus nä́ˀin wáˀ natú̖, “In tꞌowa iˀ búˀay Chorazin gin dâytu̖ˀoˀ iweˀin tꞌôephaḏe dínpúuwí. In tꞌowa iˀ búˀay Bethsaida gin dâytu̖ˀoˀ iweˀindá wáˀ tꞌôephaḏe dínpúuwí. Pínnán tꞌôe-áho inbí jâa ovâyˀan, hebo inbí tꞌaywóˀdi wíḏívíjâaˀanpí. Nä́ˀi pínnán tꞌôebá in búˀ Tyre-áḏí Sidon-dáḏí gin dâytu̖ˀoˀ eeje hä́nˀoe ovâyˀandáhoˀ, in Tyre-ˀindá in Sidon-ˀindá wíḏívíhayjêeˀamípíwän kꞌoeˀi aa dívíˀaawé-íḏí, heḏá nûu ee-á dívíkwꞌôeníwän, dâykeeya̖míḏí inbí tꞌaywóˀdi dâyjoeˀannin. ");
INSERT INTO tew_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Heḏânho in Chorazin-windá in Bethsaida-windá shánká dâytꞌôephaḏekhâymáa in Tyre-windá heḏá Sidon-windá inbíˀweḏi owáy Jôesi Táḏáḏí tꞌowa háa híwó háa híwóhpí dívíˀannin ovâykeekwꞌóeˀó ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Maḏi in tꞌowa Capernaum búˀaywin diˀándeˀ oe makówápiye ovâytegekhâymáaˀin, hewänbo indá oe péyégépiyânho diwha̖vemän.” ");
INSERT INTO tew_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Heḏáháˀ iví khä̖geˀnin itu̖ˀan, “Toˀwên wovâytꞌôeyandeˀindáho naa wáˀ dîntꞌôeyande waagibá dívíˀoˀ. Heḏi toˀwên un wovâyjoegiˀannindáho naa wáˀ díjoegiˀoˀ, heḏi toˀwêndi naa díjoegiˀoḏá gindiḏi iˀ toˀwí naa dísandi wáˀ óejoegiˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tíˀúugéḏí in tségíntä̖ˀḏi wíje (72) senäˀ híhchangiḏi diwáyˀä̖ä̖, heḏi ditú̖, “Nanbí Sedó, in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi wänbo naˀin díˀaˀgin, uví khä̖́wä̖́ wînkhá̖yä̖́ˀdi.” ");
INSERT INTO tew_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus-di ovâytu̖ˀan, “Naaḏi wáˀ dómûˀ Satan iˀ Penísendi oe makówáḏí tsíkhagipí nakeˀtꞌândi, tsígówä̖́nú nawândi waabá. ");
INSERT INTO tew_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bítꞌôeyan, naaḏi wâykꞌûˀ yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ bîntꞌaaníḏí, wí pä̖́ä̖yu̖ háa wí tsꞌeˀkꞌâ̖a̖vîˀḏi úvíˀa̖hsaa waagibá, heḏá shánkí kay-á wâymä́gi in kay iˀ Penísendi unbí hä́nbiˀ únmuu imáaˀivíˀweḏi, heḏiho háˀto hä̖ä̖wíḏí wänbo wovâywa̖ˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hewänbo tobá in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi wovâyˀaˀginnandi íhíhchan wänboˀ, únkhâyˀä̖ˀ shánkí íhíhcha̖a̖-íˀin unbí khá̖wä̖́ oe makówá úntaˀmuuḏi.” ");
INSERT INTO tew_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ihayḏibá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi báyékí híhchan Jesus óemä́gi, heḏi Jesus natú̖, “Naví Táḏá, u̖-á oe makówá-áḏí heḏá nä́ä oepáa kꞌayḏá shánkí untsonjiˀiˀ unmuu. Heḏi nä́ˀi hä̖ä̖wí naví khä̖geˀnin dâymûˀi-á in báyékí dínhanginnáˀninbíˀweḏá in dihá̖ˀinbíˀweḏá nâakaayan heḏânho wíḏâymúunípíḏí, heḏi nä́ˀin namuuḏi naaḏi wíkú̖ˀdaaˀoˀ. Naví Táḏá, gin biˀa̖míḏí wóehíhchanmä́gi.” ");
INSERT INTO tew_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Heḏáháˀ in tꞌowa ovâytu̖ˀan, “Naví Táḏáḏí hä̖ä̖wí tꞌä̖hkí naví mange dînjoeˀan. Tóebo taˀgendi wíˀûnhanginnáhpí toˀwí omuuˀin, naví Táḏáḏa̖ˀmân ûnhanginná. Heḏá tóebo-á wáˀ wíˀûntaˀgendihanginnáhpí toˀwí naví Táḏá dînmuuˀin, naa iví ay omuuˀiˀḏa̖ˀmân dînhanginná. Heḏá wáy wêndiḏáho óetaa-í, toˀwí namuuˀin naaḏi dovâykeeyandáhoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Heḏi iví khä̖geˀninbíˀpiye ibéeḏí Jesus-di ovâytu̖ˀan inda̖ˀ ditꞌoe-íḏí, “Undá híhchan bînmáˀve-í nä́ˀi hä̖ä̖wí napóeˀi bînmúndeḏi. ");
INSERT INTO tew_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Wâytu̖ˀâ̖a̖mí, báyékí in hä́nˀoeˀin tsonnindá in Jôesi Táḏáví tukheˀmindá didaˀ dâymúuníˀin iˀ hä̖ä̖wí nää bînmúndeˀiˀ, hewänbo wíḏâymûˀpí, heḏá iˀ hä̖ä̖wí un ítꞌoeˀoˀindá didaˀ ditꞌoe-íˀin, hewänbo wíḏitꞌoepí.” ");
INSERT INTO tew_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wí sen in Huḏíyoví khuu dâyhá̖ˀoˀin diweḏiˀi namuuˀi Jesus-víˀwe napówá óetayi̖ˀníḏí, heḏi óetsikaˀyan, “Há̖hkandiˀ, hân dáyˀa̖mí in wówátsi nahándepíˀin donkáyjíḏí?” ");
INSERT INTO tew_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus-di óetsikaˀyan, “Hân natû̖ˀ iˀ tsontun Moses itaˀnandiˀ? Hä̖ä̖-an iwe nâatunnan?” ");
INSERT INTO tew_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iˀ sendi Jesus óetu̖ˀan, “Gá ginnân: Iˀ shánkí natsonjiˀiˀ unbí Jôesi únmuuˀiˀ undá únkhâyˀä̖ˀ pín taˀgeḏi bînsígí-íˀin, unbí píˀnä́ khóˀjé-á, unbi hâ̖a̖ iwá, unbí kay tꞌä̖hkíḏá, heḏá unbí ánshaaḏá.” Heḏá wáˀ natú̖, “Háa un wíˀbo úvípisígí waagibá, wéˀgen tꞌowa wáˀ bînsígíhûuwí.” ");
INSERT INTO tew_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus-di óetu̖ˀan, “Híwó bihéeˀan, heḏiho háa untú̖ waa biˀâ̖a̖mí, heḏânho wówátsi wóemä̂äní.” ");
INSERT INTO tew_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hewänbo in Huḏíyoví há̖hkandi nadaˀ ipikeeya̖míˀin híwóˀdi namuu waagibá, heḏiho Jesus óetsikaˀyan, “Wéˀin tꞌowa dovâysígí-í?” ");
INSERT INTO tew_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus-di ônthayya̖míḏí ginnân óetu̖ˀan: “Wí sen oe Jerusalem búˀ iweḏi iˀ búˀ Jericho iwepiye namän, heḏi wên sänmindi óeyâ̖ˀḏi iví aa óepꞌä̖́ḏi heḏi hânho óemahpúuḏí chuˀi waagibá óejoeˀan. ");
INSERT INTO tew_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Heḏi ihayḏibá wí Huḏíyo owhaˀ-á ee pꞌóegá namän, heḏi iˀ sen óemûˀ iwe nakꞌóeḏí, heḏi pꞌôe pꞌä̖́näpiye naphaḏeḏi iweḏi namää. ");
INSERT INTO tew_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hây napóe ihayḏá hanbá napóe. Wíyá wêe sendá naˀä̖ä̖, i-á iˀ méesate hayˀiwi khä̖geˀdi namuu, hewänbo iˀ wáˀ pꞌôe pꞌä̖́näpiye naphaḏeḏi iweḏi namää. ");
INSERT INTO tew_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Heḏi wí sen oe Samaria nangewi namuuˀiˀ oe pꞌóegé namän, heḏi iˀ sen nakꞌóe iwe núˀ napówá, heḏi óemûˀḏi ivíˀpiye nasehkanäpóe. ");
INSERT INTO tew_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Heḏiho ee nakꞌóe iwepiye namääḏi iví tsaa eeje olive ka̖ˀpꞌoe-áḏí méena-áḏí ônˀeweḏi aaˀâyḏi ônwhiˀan, heḏáháˀ iví búdu eeḏi óeˀíˀkꞌûˀḏi wí whohkwo tewhá iwepiye óehoˀ, heḏi iwe óeˀá̖yîngiˀan. ");
INSERT INTO tew_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Iˀ tháwä́ndá wíje thaa tꞌôeˀi chä̖ˀ iví chä̖ˀ múu iweḏi iwhahógiḏi iˀ whohkwo tewháwi pꞌóˀḏéḏîˀ ônˀandi óetu̖ˀan, ‘Nä́ˀi sen nâaˀá̖yîngiˀa̖mí, heḏi wíyá shánkí úchä̖ˀmuuḏáhoˀ owáy owáyˀä̖ä̖ ihayḏi wíwáˀâa-í.’ ” ");
INSERT INTO tew_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Heḏi Jesus-di iˀ há̖hkandi óetsikaˀyan, “Hân unˀân, wéˀiḏan in poje iweḏi iˀ sen in sänmindi óeyâ̖ˀiˀ taˀgendi óeseegí?” ");
INSERT INTO tew_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Iˀ há̖hkandiˀḏi Jesus óetu̖ˀan, “Gá iˀ nasehkanäpóeˀiˀḏân.” Jesus-di óetu̖ˀan, “Jaˀ ópûn, háa iˀan waa óˀan.” ");
INSERT INTO tew_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus-áḏí iví khä̖geˀnindáḏí iweḏi dimääḏi wí búˀay iwe dipówá, heḏi wí kwee Martha gin nakhá̖wä̖́ˀiˀḏi ovâysígíˀandi iví tewhá eepiye ovâytsꞌúḏe. ");
INSERT INTO tew_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martha-á wí tíˀûu Mary gin nakhá̖wä̖́ˀi-á ûnˀä́n, heḏi i-á ee nange Jesus-ví ân núˀ isóge iví há̖hkan ôntꞌôeyaaníḏí. ");
INSERT INTO tew_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha hânho najashapoeˀo báyékí tꞌôe ûnjiḏi ovâyhúujôeníḏí, heḏiho Jesus-víˀpiye namääḏi óetu̖ˀan, “Nanbí Sedó, ti á̖yîngi wíwóemähpíˀan naví tíˀûuḏi wíˀbo díjoeˀandi iˀ koegîˀ dókhâyˀa̖míḏí? Nátu̖ˀan díkhä̖geˀnamíˀin.” ");
INSERT INTO tew_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesus-di óetu̖ˀan, “Sehkanä Martha, u̖-á hä̖ä̖wí tꞌä̖hkí i̖ˀgeḏi báyékí á̖yîngiḏi wóemáa, ");
INSERT INTO tew_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","hebo wí hä̖ä̖wíḏa̖ˀmânho taˀgendi natáy, heḏi Mary-áho iˀ ideˀman. Heḏi nä́ˀi shánkí híwóˀdi namuuˀiˀ ideˀmandi-á ivíˀweḏi háˀto óekwee-í.” ");
INSERT INTO tew_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesus-á wíyá wä̖́hä̖̂ä̖ ijûusuˀoˀ, heḏi ibowa ihayḏá wêe iví khä̖geˀdiˀḏi óetu̖ˀan, “Nanbí Sedó, naˀin wáˀ díjûusuhá̖ˀan, John iví khä̖geˀnin ijûusuhá̖ˀan waabá.” ");
INSERT INTO tew_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus-di ovâytu̖ˀan, “Úvíjûusuˀandá gin waagi ítú̖u̖ní: Táḏá, uví khá̖wä̖́ wînˀaˀginnamí. Uví tsonkhuu wóegé ówhanbe naˀin dítsonnamíḏí. ");
INSERT INTO tew_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Thamuwaagi iˀ húugîˀ gíntáyˀi dímä́ä. ");
INSERT INTO tew_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nanbí tꞌaywóˀdi dînˀowójé, in naˀinbíˀpiye dívítꞌaywóˀnannin âyˀowójénde waagibá. Heḏi wígínpúuwípí wä̖hphaḏe dítayi̖ˀníḏí.” ");
INSERT INTO tew_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Heḏáháˀ Jesus-di ovâytu̖ˀan, “Heyâagú khunpinuḏi wí kꞌemaví tewhá eepiye ímääḏi bîntu̖ˀandi, ‘Kꞌema, poje pává dípíyémä́ä. ");
INSERT INTO tew_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wíyá kꞌema nä́ngé naphaḏemändi nää navîˀ napówá, hebo naa hä̖́ä̖bo wíḏînsaapí dókoejôeníḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Heyâagú iˀḏi oe íveḏi wovâytu̖ˀandi, ‘Ánpí díˀan, in phóḏi-áho naphéhtoˀon heḏi naví áyyä̖̂ä̖-áḏí naa-áḏí giwhoˀkwꞌó, heḏiho naa wíḏînkoḏipí dáyshaa-íḏí hä̖ä̖wí wímä̂äníḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Naaḏi wâytu̖ˀâ̖a̖mí, tobá hä̖ä̖wí wíwovâymä̂änípí wänbo unbí kꞌema únwänpimuuḏiboˀ, ihayḏa̖ˀ bîndaˀmáaḏáhoˀ ishaa-í, heḏi hä̖ä̖wí úntáyˀi wovâymä̂äní. ");
INSERT INTO tew_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Heḏi hanbá namuu úvíjûusuˀandi: Bîndaˀmáˀve-í hä̖ä̖wí, heḏiho bînhóení. Bîntu̖wä̖máˀve-í hä̖ä̖wí, heḏiho bînshaa-í. Bînpópóˀâ̖a̖mí, heḏiho in phóḏi-áho ungîˀ wovâyhuu-í. ");
INSERT INTO tew_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Toˀwên ihayḏa̖ˀ dâydaˀmáaˀindáho dâyhóení, toˀwên ihayḏa̖ˀ dâytu̖wä̖máaˀindáho dâyshaa-í, heḏi toˀwên ihayḏa̖ˀ dâypópóˀoˀindáho in phóḏi ingîˀ ovâyhuu-í. ");
INSERT INTO tew_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","“Un táḏáˀin ímuuˀin, unbí eˀnúḏí wí paa wovâydaaˀandi ikꞌoˀíḏí, ti wí pä̖́ä̖yu̖ bînmä̂äní? Heḏiháa wí wáa wovâydaaˀandi ti wí tsꞌeˀkꞌâ̖a̖ bînmä̂äní? Joe, háˀtoˀ. ");
INSERT INTO tew_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tobá híwóhpíˀin ímuu wänbo undá únhanginná háḏíḏí híwóˀdi hä̖ä̖wí unbí áyyä̖̂ä̖ bînmä̂äníˀin. Heḏiho shánkí wänbo iˀ Táḏá oe makówá naˀä́ndiˀḏi in toˀwên óedaaˀannin iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ ovâymä̂äní.” ");
INSERT INTO tew_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus-di wí sen tunpîˀvíˀweḏi wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ ônkhehpiye. Iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ napee ihayḏi iˀ sen ûnhíˀkoḏi, heḏi in tꞌowa ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hewänbo wáy wêndáho ditú̖, “Iˀ Penísendi Beelzebul gin nakhá̖wä̖́ˀiˀ, iˀ yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ví pꞌóˀḏéḏîˀ dínmuuˀiˀḏân Jesus óekhä̖geˀdo nä́ˀin yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpeeyé-íḏí.” ");
INSERT INTO tew_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Heḏá wây-á wêndá didaˀ Jesus óetayi̖ˀníˀin, heḏiho óedaaˀan wên pínnán taa makówáḏí ovâykeeya̖míḏí, heḏânho dínhanginnáaníḏí háa Jôesi Táḏáḏí óesandiˀ namuuˀin háa joe. ");
INSERT INTO tew_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hewänbo háa dívíˀánshaamáaˀin Jesus-á ûnhanginná, heḏiho ovâytu̖ˀan, “Wí nangewin tꞌowa wíˀbo dívípihä́nboḏáhoˀ inbí nangeho dâypiháˀḏä̂nnamí. Heḏi tꞌowa inbí kꞌaygi ee wíˀbo dívípiyándeḏáhoˀ, iˀ kꞌaygá háˀto nakâypúuwí. ");
INSERT INTO tew_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Heḏi hanbá Penísendi wíˀbo ipiyándeḏáho háˀto hä̖̂ä̖ḏi wänbo natsonyê̖e̖ní. Undi dítu̖ˀan Penísendiḏânho naa díkhä̖geˀmáa, heḏânho in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi dovâykhehpiyendeˀ. ");
INSERT INTO tew_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hewänbo handiḏi dovâykhehpiyendeḏáhoˀ, háḏíḏan unbí tꞌowaˀindi ovâykhehpiyendeˀ? Unbí tꞌowaho ditú̖u̖ní in taˀgen wíˀúvíhéeˀopíˀin. ");
INSERT INTO tew_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hewänbo Jôesi Táḏáví pínnándânho in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ dovâykhehpiyendeˀ, heḏi nä́ˀindiho únhanginná Jôesi Táḏáḏí naa dítsondisógeˀin. ");
INSERT INTO tew_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Wí sen kayˀi tꞌä̖hkí iví kꞌuuphé hä̖ä̖wíḏí iví tewhá iˀá̖yîngiˀoḏi, tꞌä̖hkí iˀ hä̖ä̖wí ivîˀ ûnmuuˀiˀ híwó ûnkwꞌó. ");
INSERT INTO tew_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hewänbo wí toˀwí iví shánkí kayˀi namuuˀi naˀä̖ä̖ḏá iˀ sendáḏí iyâ̖a̖-íḏí, iˀ sen óetꞌaaní, heḏi tobá iˀ sen kwä̖́kꞌu hä́n aa natoˀon wänboˀ, heḏá naˀándeˀ nä́ˀi kwä̖́kꞌu aaḏi óekhä̖geˀnamíˀin, nä́ˀi wêe sen shánkí kayˀi namuuˀiˀḏi iˀ senbí hä̖ä̖wí ônhóení, heḏi iví kꞌemaˀindáḏí dívíweejé-í. ");
INSERT INTO tew_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Toˀwí navíˀnäpiye namuupîˀ-á navíˀpiye háa nacha̖a̖, heḏi toˀwí in tꞌowa navíˀpiye ovâymáyä̖ˀpîˀ-áhoˀ ovâykhehpiyende waagibá iˀoˀ. ");
INSERT INTO tew_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ wí tꞌowavíˀweḏi napeeḏi oe ahkónupiye namändi wáy ithaayé-í iwe itu̖wä̖máa, heḏi ishaapíḏáho wíˀbo natû̖ˀ, ‘Wáy dójoeˀan diwepiyebá owáymú-í, iˀ toˀwívíˀpiye naví tewhá waagiˀbá dînmúˀdeˀiˀ.’ ");
INSERT INTO tew_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Heḏi nawáymää ihayḏá nä́ˀi toˀwíbá óeshaaḏeˀ, wí tewhá naˀaanândá napiˀḏindá waabá namuu. ");
INSERT INTO tew_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Heḏáháˀ wíyá napeeḏi tsé ihay wây-á yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ iví shánkí yä̖ˀḏâapíˀin dimuuˀin ovâymáˀ, heḏi nä́ˀi toˀwívíˀpiyebá ovâyhon iwe dívíthaayé-íḏí, heḏiho nä́ˀi toˀwí-á shánkí pꞌä́ndíkîˀ-á napoeˀo páaḏéḏí namuuˀivíˀweḏi.” ");
INSERT INTO tew_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gin Jesus natú̖ ihayḏá wí kwee oe tꞌowa jâaḏá kaygá natú̖, “Iˀ kwee wóeˀayyandiˀ heḏá wóetsä̖ä̖ˀandi-á híhchan imáa.” ");
INSERT INTO tew_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesus natú̖, “Hebo shánkí dihíhchan in toˀwên Jôesi Táḏáví híˀ dâytꞌôeyandeˀin heḏá dâyˀaˀgindoˀindá.” ");
INSERT INTO tew_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","In tꞌowa Jesus-víˀwe shánkí diwéˀgepoeˀo, heḏi ovâytu̖ˀan, “Un nääwin tꞌowa-á yä̖ˀḏâapí unbí wówátsi bînhon. Ihayḏa̖ˀ wí pínnán taa bînmúuníḏí Ídaˀpoeˀo, hewänbo wêeḏa̖ˀ pínnán bînmúuní, i-á Jonah ikeeyandiˀ waagiˀbá namúuní. ");
INSERT INTO tew_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Háa Jonah ûnpóeˀin namuuḏi in tꞌowa Ninevah búˀwin dínhanginná taˀgendi Jôesi Táḏáḏí óesannin, heḏi hanbá nää naa tꞌowa tꞌä̖hkígîˀ oˀaypu̖yä̖ˀi háa dînpúuwíˀin namuuḏi in nääwin tꞌowa dínhanginnáaní taˀgendi Jôesi Táḏáḏí dísannin. ");
INSERT INTO tew_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Heḏânho owáy iˀ thaa Jôesi Táḏáḏí tꞌowa háa híwó háa híwóhpí dívíˀannin ovâykeekwꞌóeˀó ihayḏi, iˀ kwee oe Sheba nange pꞌóˀḏéḏîˀ namúˀdeˀiˀ iˀa̖htuyeḏi un nääwin tꞌowaví wä̖yu̖pí wovâykeeya̖mí. Hä́nˀoe i-á kayi̖ˀ wä̖́hä̖̂ä̖wi nangeḏá naˀä̖ä̖ hä̖́yú̖ Solomon ûnhanginnáˀdiˀ ôntꞌôeyaaníḏí, hewänbo tobá naa Solomon-bí shánkí hayˀi omuu wänbo heḏá nä́we undáḏí oji wänboˀ, undi naa wíḏîntꞌôeyandepí. ");
INSERT INTO tew_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Heḏá wáˀ owáy iˀ thaa Jôesi Táḏáḏí tꞌowa háa híwó háa híwóhpí dívíˀannin ovâykeekwꞌóeˀó ihayḏi, in tꞌowa iˀ búˀ Ninevah-win dívíˀa̖htuyeḏi un nääwin tꞌowaví wä̖yu̖pí wovâykeeya̖mí. Hä́nˀoe Jonah-ḏi Jôesi Táḏáví tun ovâytꞌôeˀoḏi hä̖ˀin Ninevah-win tꞌowa ditꞌoeḏi indá inbí tꞌaywóˀdi dâyjoeˀan, hewänbo tobá naa Jonah-ví shánkí hayˀi omuu wänbo heḏá nä́we undáḏí oji wänboˀ, unbí tꞌaywóˀdi wívînjoeˀohpí.” ");
INSERT INTO tew_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Toˀwí wänbo wên phakó ikoˀandi pho iwe wíˀikaakéeˀípí, háa wên tꞌún napekicháˀnin phoˀ wíˀikéeˀípí, hewänbo wên phakóki eeḏân ikéeˀí heḏânho toˀwên ditsꞌúyaˀnin iˀ ko dâymúuníḏí. ");
INSERT INTO tew_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tꞌowaví tsée-á wên phakó ingîˀ namuu, heḏi híwóˀnin tsée dínmuuḏáho in tséeḏá tꞌä̖hkí ovâykoˀ. Hewänbo híwóhpíˀin tsée dínmuuḏáhoˀ tꞌä̖hkí ovâyphahkhunjoˀ waagiˀbá dínpoeˀo. ");
INSERT INTO tew_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Heḏânho úvíˀá̖yîngiˀa̖mí unbí tséeḏí in ko óetsuḏemä̂äníˀin, khun niˀge wíˀíyê̖e̖nípíḏí. ");
INSERT INTO tew_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wí toˀwí taˀgendi ûnkonândá heḏá wáygé wänbo wíˀûnphahkhunáhpíḏá, tꞌä̖hkího ûnkohkeenáaní, wên phakó ûnkohkay waagibá.” ");
INSERT INTO tew_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus ihíˀbowa ihayḏá wí Pharisee-ḏá óehúutu̖ˀan, heḏiho iˀ Pharisee-ví tewhá eepiye datsꞌûndi Jesus ihúusóge. ");
INSERT INTO tew_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Iˀ Pharisee óeháaˀan Jesus óemûˀḏi ihúusógeḏi waˀḏi imanˀowíḏipíḏíboˀ in Huḏíyoví khuu waagibá. ");
INSERT INTO tew_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Heḏiho Nanbí Sedó Jesus-di óetu̖ˀan, “Naa dîntꞌôeyan, un Pharisees-á tꞌowa waaginbá ímuu inbí húugîˀ kꞌéḏé-á sä̖ˀwé woegiˀ-á jáˀwéḏíḏa̖ˀ dâyˀowíḏíndeˀin. Undá ídaˀ híwó íkeetꞌôeníˀin, hewänbo unbí píˀnä́ khóˀjé nakeetꞌóepí iwá ha̖ˀtꞌaaˀinda̖ˀ heḏá yä̖ˀḏâapíˀinda̖ˀ ímuu. ");
INSERT INTO tew_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Un ánshaapíˀin, Jôesi Táḏá-á hä̖ä̖wí nakeetꞌóeˀiˀ ipaa. Ti iˀbá hä̖ä̖wí nakeetꞌóepîˀ wáˀ wíˀipaapíˀan? ");
INSERT INTO tew_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Únkhâyˀä̖ˀ hä̖ä̖wí unbí sä̖ˀwé únsaaˀiˀ in sehkanäwó diwówájiˀin bînmä̂äníˀin, handiḏibo yä̖ˀḏâaˀin wówátsi bînhûuwí. ");
INSERT INTO tew_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tꞌôephaḏe un Pharisees únpúuwí. Undá iˀ suˀtsꞌígíˀ-á tsímáháa-á heḏá wéˀgeˀi hä̖ä̖wí haˀwâagiˀiˀ bînpaye iweḏi tä̖ taa únkwꞌôndi Jôesi Táḏá wêe bînmäˀ, hewänbo tꞌowa-áho taˀge wívînˀohpí heḏá Jôesi Táḏá-á wívînsígípí. Hä̖ä̖wí bîntꞌandeḏi taˀgendi únkhâyˀä̖ˀ tä̖ taa únkwꞌôn diweḏi Jôesi Táḏá wêe bînmä̂äníˀin, hewänbo wíˀúnˀôeḏe-ípí nä́ˀi wéˀgeˀi híwóˀdi hä̖ä̖wí wáˀ úvíˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Tꞌôephaḏe un Pharisees únpúuwí. Undá iˀ méesate páaḏépiye úvíkwꞌôeníˀin wovâyhí̖ˀan, heḏá oe bûu pinge wovâyhí̖ˀan tꞌowaḏi aˀgindi wovâysengitu̖ˀâ̖a̖míˀin. ");
INSERT INTO tew_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tꞌôephaḏe únpúuwí, gá undá wáy pení ovâykhä̖ˀkwꞌóḏi eeje nataamuupîˀ waaginbá ímuuḏân, tꞌowa dívíˀa̖hsahondi wíḏínhanginnáhpí iwe nakwꞌóˀnin.” ");
INSERT INTO tew_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wí Huḏíyoví khuu ovâyhá̖ˀoˀiˀḏi óetu̖ˀan, “Há̖hkandiˀ, in Pharisees-bí̖ˀgeḏi haˀwâa bihéeˀoḏi naˀinbí̖ˀgeḏi wáˀ jänäkí bihéeˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus natú̖, “Tꞌôephaḏe un Huḏíyoví khuu bînhá̖ˀoˀin wáˀ únpúuwí. In tꞌowa kâyˀi hä̖ä̖wí dívíˀa̖míˀin bîntu̖ˀoˀ, hewänbo undá hây wänbo wívînkhä̖geˀdopí dâyˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Tꞌôephaḏe únpúuwí, gá undá wáy in Jôesi Táḏáví tukheˀmin ovâykhä̖ˀkwꞌóḏi eeje bînkoḏiˀoḏân, inbá unbí hehä̖̂ä̖win thehtáy pahpáˀindi ovâyhá̖nú. Hewänbo han bînˀandi nakeepoeˀo únchanpóeˀin háa unbí páaḏé kä̖ˀä̖ä̖ˀin dívíˀannin híwó namuuˀin, gá indá in Jôesi Táḏáví tukheˀmin ovâyhá̖nú wänbo undá inbí penípho bînwänpikoḏiˀoḏân. ");
INSERT INTO tew_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Heḏânho Jôesi Táḏá báyékí hangintan imáaḏí ginnân natú̖, ‘Naví tukheˀmindá heḏá naví tꞌôekhuwaˀindá in tꞌowavíˀpiye donsaaní, heḏi in tꞌowaḏi wáy wên in dovâysannin jänäkí ovâyˀa̖mí, wáy wêndá ovâyhá̖a̖nú-í.’ ");
INSERT INTO tew_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Heḏiho un tꞌowa nääwin wovâychä̖nukhâymáa in Jôesi Táḏáví tukheˀmin nä́ä oepáa kꞌayḏi nakhíˀjen dihayḏiboˀ ovâyhá̖núḏí. ");
INSERT INTO tew_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Iˀ páaḏé óehayˀi-á Abel namuu, heḏi iˀ tíˀúugé óehayˀi-á Zechariah-á namuu, i-á iˀ méesate-á iˀ antâa jáˀwé nakꞌóeˀi-á inbí pinuḏi óehay. Naaḏi wâytu̖ˀâ̖a̖mí, undáho in tꞌä̖hkí ovâyhá̖núḏí taˀgendi wovâytuhchä̖nukhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Un Huḏíyoví khuu bînhá̖ˀoˀin tꞌôephaḏe únpúuwí. In taˀgen namuuˀin bînkaajo waagibá úvíˀoˀ, in tꞌowa wíḏihá̖hpúuwípíḏí. Undáho wíˀíhá̖hpóepí, heḏi in wéˀgen tꞌowa dihá̖hpúuwíˀin didaˀindáho wívînmähpí dihá̖hpúuwíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesus nä́ˀi Pharisee-ví tewhá iweḏi napee, heḏi iˀ thaa iweḏi páaḏépiye in Huḏíyoví khuu dâyhá̖ˀoˀindá heḏá in Pharisees-á hânho i-áḏí ditꞌayyaapóe, heḏá hânho-á dívíkhä̖ä̖ḏeˀ tꞌä̖mäge i̖ˀgeḏi óetsikaˀya̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Wên phay igîˀ nawhêe-íḏí ônkꞌúyaˀ waabá muuˀin bînkaajo waagibá úvíˀoˀ, in tꞌowa wíḏihá̖hpúuwípíḏí. Undáho wíˀíhá̖hpóepí, heḏi in wéˀgen tꞌowa dihá̖hpúudívíˀandi ditsíkha wên háawên híwóhpíˀin natu̖hpee-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","2","Ihayḏi báyékí maapaasôn (1,000’s) tꞌowa diwéˀgejiˀ, heḏi hânho dibáˀyendi dívíḏachä̖nuˀoˀ. Jesus-di in tꞌowa ovâyhéeˀan, hebo iví khä̖geˀnin páaḏé itu̖ˀan, “Úvíˀá̖yîngiˀa̖mí hä̖ˀin Pharisees waaginbá wíˀípúuwípíḏí, indá paa dívíjánúmáaˀin waaginbá dimuu. Iˀ híwóhpîˀ dívíˀoˀi-áho dínsôe-í oewáasee nä́ˀi oewáa iwe natoˀondi nasôˀ waagibá. Heḏi hanbá tꞌä̖hkí nää nakumukꞌóe wänbo nakumukhuuḏee-í, heḏá tꞌä̖hkí nää nakaakꞌóe wänbo óepeeyé-í napu̖ˀwä̖ä̖níḏí. ");
INSERT INTO tew_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Heḏiho wên háawên phahkhun dee ítú̖ˀindáhoˀ, thaaḏi ditꞌoe-í, heḏi wên háawên toˀwíví oje phóge bînsänhéeˀandi in phóḏi natiˀḏindi, indáho whaˀkꞌayḏi dívítu̖wé̖e̖nú-í, tꞌä̖hkí ditꞌoe-íḏí.” ");
INSERT INTO tew_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Naví kꞌemaˀin, wâytu̖ˀâ̖a̖mí, wívînkhunwôedaˀípí in toˀwên unbí túˀ dâyhá̖a̖nú-íḏí dínkoḏi wänbo shánkí wovâyˀa̖míḏí wíḏínkoḏipí. ");
INSERT INTO tew_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Naaḏi wâythayya̖mí toˀwí namuuˀin iˀ bînkhunwôedaˀíˀiˀ: Jôesi Táḏá-ânho bînkhunwôedaˀí. I-á ûnkoḏi wovâyhá̖a̖nú-íḏí heḏá wáˀ ûnkꞌóe péyégépiye wovâysaaníḏí. ");
INSERT INTO tew_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Pꞌánú tsꞌí̖ˀ tsíḏéˀây wíje thígí̖ˀdiḏibo ovâyku̖ˀchꞌáaḏepíˀan. Hewänbo tobá wä̖hphaḏe dichä̖ˀmuupí wänbo Jôesi Táḏáḏá wêe wänbo in diweḏi wíˀóeˀóḏéndepí. ");
INSERT INTO tew_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hewänbo undá Jôesi Táḏágîˀ báyékí tsíḏéví shánkí íchä̖ˀmuu. I-á ûnhanginná hä̖́yú̖ phó unbí pꞌóˀḏé únsaaˀin wänboˀ, heḏiho wíˀíkhunwôedaˀípí.” ");
INSERT INTO tew_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Naaḏi wâytu̖ˀâ̖a̖mí, toˀwên in tꞌowaví páaḏépiye navíˀin dimuuˀin ditú̖ˀin, naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀi wáˀ in Jôesi Táḏáví makówáwin tꞌôepa̖ˀa̖a̖ˀinbí páaḏépiye otú̖u̖ní innân navíˀin dînmuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Hewänbo toˀwên in tꞌowaví páaḏépiyebo ditú̖ˀin navíˀin wíḏimuupíˀin, naa wáˀ in Jôesi Táḏáví makówáwin tꞌôepa̖ˀa̖a̖ˀinbí páaḏépiye otú̖u̖ní navíˀin wíḏînmuupíˀin. ");
INSERT INTO tew_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nakoḏi tꞌä̖hkí tꞌowa dínˀowóˀjayníḏí hä̖ä̖wí híwóhpí dívíhéeˀannin naví̖ˀgeḏi, naa tꞌowa tꞌä̖hkígîˀ oˀaypu̖yä̖ˀiˀ omuuˀiˀ, hewänbo toˀwên jänäkí iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ví̖ˀgeḏi dívíhéeˀannindáho háˀto dínˀowóˀjayní. ");
INSERT INTO tew_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Owáy in méesate eejeˀin pꞌóˀḏéḏíˀinbíˀpiye háa in nangewin tsonninbíˀpiye wovâytunjóˀnamíḏí wovâyhoˀ ihayḏi, wíˀíˀá̖yîngi-ípí háa ítú̖u̖níˀin úvíˀaywoeníḏí, háa úvíhéeˀa̖míˀin wíwovâyˀá̖yîngimä̂änípí, ");
INSERT INTO tew_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","gá ihayḏáho iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi iˀ híˀ wovâymä̂äníḏân heḏânho híwó úvíhéeˀa̖míḏí” gin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wí sen in tꞌowaví jâa najiˀiˀḏi Jesus óetu̖ˀan, “Há̖hkandiˀ, naví páˀḏây dîntu̖ˀan iˀ hä̖ä̖wí nanbí táḏáḏí naˀin dînjoeˀandi naa-áḏí iweejé-í.” ");
INSERT INTO tew_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hebo Jesus-di iˀ sen óetu̖ˀan, “Toˀwíḏí wänbo naa wíḏînkꞌûˀpí otú̖u̖níḏí háa unbí hä̖ä̖wí dänweejé-íˀin.” ");
INSERT INTO tew_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Heḏáháˀ Jesus-di tꞌä̖hkí in tꞌowa ovâytu̖ˀan, “Hä̖̂ä̖ḏi wänbo tꞌä̖hkí úvíˀá̖yîngiˀa̖mí heḏânho ha̖ˀtꞌaaˀinda̖ˀ wíˀímúunípíḏí. Toˀwí wänbo híwóˀnin wówátsi wíˀimáapí báyékí hä̖ä̖wí ûnwänpikwꞌôndiboˀ.” ");
INSERT INTO tew_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Heḏáháˀ nä́ˀin há̖hkangíˀin óˀgéḏí ovâytu̖ˀan, “Wí koḏitꞌowa sen ûnnavakwꞌó, heḏi báyékí ûnpayeḏee. ");
INSERT INTO tew_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Heḏiho ginnân naˀân: “Wä̖́hä̖̂ä̖ naví hä̖ä̖wí dînpaaˀi donkwꞌôení wíḏînnáhpí. Hân hîn dáyˀa̖mí? ");
INSERT INTO tew_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Maˀ ginnân dáyˀa̖mí: Naví denkwoˀi tewhá dontsꞌáveḏi wíyá shánkí heˀendi donkwꞌôení, heḏiho ee naví táhtândá naví wéˀgeˀi hä̖ä̖wí-á dondenkwꞌôení. ");
INSERT INTO tew_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Heḏáháˀ gindá opitú̖u̖ní: ‘Nää-áho báyékí híwóˀdi hä̖ä̖wí híwó hay pa̖a̖yogîˀ dîndenkwꞌóhoˀ, nää-áho wíyá wíḏáytꞌôeˀa̖mípí. Húukandá su̖wä̖-áḏá dáyˀa̖mí, heḏá naví wówátsi-á híhchandi donhûuwí.’ ");
INSERT INTO tew_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hewänbo Jôesi Táḏáḏí iˀ sen óetu̖ˀan, ‘U̖ˀ ánshaapîˀ, nää khunbo uví wówátsi wînkekhâymáa. Ihayḏáho to-an hä̖ˀi hä̖ä̖wí u̖gîˀ mändenkwꞌóḏiˀiˀ ikhonkhâymáa?’ ” ");
INSERT INTO tew_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Heḏi Jesus-di in tꞌowa ovâytu̖ˀan, “Haˀwâagiˀinnânkun in tꞌowa dimuu báyékí hä̖ä̖wí dâydenkwꞌóeˀóˀin hewänbo Jôesi Táḏá-á natû̖ˀ taˀgendi koḏitꞌowa wíḏimuupíˀin.” ");
INSERT INTO tew_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Heḏáháˀ iví khä̖geˀnin itu̖ˀan, “Heḏânkun wâytu̖máa, wä̖hphaḏe wíˀúvíˀánshaamáˀve-ípí iˀ koegîˀ úntáyḏí íwówáyê̖e̖níḏí, háa iˀ aa úntáyḏí unbí túˀgîˀ. ");
INSERT INTO tew_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Unbí wówátsi-á shánkí únchä̖ˀmuu koegîˀḏa̖ˀbíˀweḏi, heḏá unbí túˀ-á aaḏa̖ˀbí shánkí únchä̖ˀmuu. ");
INSERT INTO tew_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","In odoví̖ˀgeḏi úvíˀánshaaˀa̖mí. Indá wíḏâykoˀjikopí, heḏá wíḏâyhä̖ä̖wéˀgeˀopí, heḏá wä̖́hä̖̂ä̖ dâyhä̖ä̖wídenkwꞌôeníˀi wänbo wíḏínnáhpí, hewänbo Jôesi Táaḏáho ovâyhúujómäˀ. Heḏi undá shánkí íchä̖ˀmuu nä́ˀin tsíḏévíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wénä wí wänbo háˀto unbí wówátsi wíyá wêe thaa wänbo bîntä̖ä̖-í íwänpiˀá̖yîngiḏiboˀ. ");
INSERT INTO tew_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hä̖ä̖wí hí̖yä̖̂ä̖ˀi haˀwâagiˀi wänbo háˀto úvíˀa̖mí, heḏiho háaḏan wíyá hä̖ä̖wí i̖ˀgeḏi úvíˀá̖yîngimäˀ? ");
INSERT INTO tew_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Úvíˀánshaaˀa̖mí hä̖ˀi ahkónuwi póviˀây háa nakeetꞌóe waa. Wíḏívítꞌôeˀopí wíḏâypa̖ˀpꞌándepí wänboˀ, Jôesi Táḏá saˀwóˀdi aa waagi ovâymäˀ. Solomon-dá hânho hayˀi namúˀde wänboˀ iˀ póvi waabá saˀwó wíˀiˀawepí. ");
INSERT INTO tew_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jôesi Táa saˀwóˀdi aa waagi iˀ ahkónuwi phéˀyä̖́vigîˀ ônpaa, tobá nä́ˀi phéˀyä̖́vi-á wêe thaaḏa̖ˀ nasaa wänbo heḏá wíyá tháwä́ndáho tꞌowa dâyphaˀkwꞌôení dâyhä̖ä̖háaˀa̖míḏí, heḏiho un wáˀ shánkí híwó wänbo wovâyˀaawé-ípíˀan. Undá únkhâyˀä̖ˀ nä́ˀin úvíwä̖ä̖yú̖-íˀin, hewänbo hí̖yä̖̂ä̖ḏa̖ˀ wä̖yu̖ bînmáaˀin ímuu. ");
INSERT INTO tew_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ihayḏa̖ˀ wíˀítú̖ˀbe-ípí, ‘Hä̖ä̖-angú âykꞌoˀí, hä̖ä̖-angú âysu̖u̖wä̖́-í?’ Wä̖hphaḏe wíˀúvíˀánshaamáˀve-ípí i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tꞌä̖hkí tꞌowa Jôesi Táḏá óetaapíˀindá hânho dívíwänpikhä̖ä̖ḏe nä́ˀi hä̖ä̖wí dâyhóeníḏí, hebo unbí Táḏá oe makówá naˀä́ndi-á ho ûnhanginná undá úntáyˀin. ");
INSERT INTO tew_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Undá shánkíḏí únkhâyˀä̖ˀ Jôesi Táḏáví tsonkhuu iˀpiye úvíkhä̖ä̖-íˀin, heḏi gin úvíˀandáho nä́ˀi hä̖ä̖wí úntáyˀi bînhóení. ");
INSERT INTO tew_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Wíˀíkhunwôedaˀípí tobá hí̖yä̖̂ä̖ḏi wên kꞌúwá waa íji wänboˀ. Unbí Táḏá makówáwi-áho nahíhchan oe makówápiye wovâyhûuwíḏí. ");
INSERT INTO tew_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hä̖ä̖wí únkwꞌóˀdiˀ bînku̖ˀchꞌâaní, heḏi iˀ chä̖ˀdá in sehkanäwó diwówájiˀindá bînmä̂äní. Gindiḏáho wí chä̖ˀmúu háˀto únwhéepúuwíˀiˀ waagibá bînmáˀve-í, heḏânho iˀ hä̖ä̖wí únchä̖ˀmuuˀi-á oe makówá úndenkwoḏee-í. Iwá hä̖ä̖wí unbîˀ únmuuˀi háˀto únhá̖a̖ní, háa wên sänmin wänbo háˀto dâytä̖ä̖gé-í, háa wên kha̖ˀnin wänbo háˀto dâyha̖ˀní. ");
INSERT INTO tew_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wä̖́hä̖̂ä̖ unbí hä̖ä̖wí únchä̖ˀmuuˀiˀ únkwꞌôn diwebá unbí píˀnä́ khóˀjé ídaˀí íkwoníˀin.” ");
INSERT INTO tew_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Wên tꞌôeˀin waabá únkhâyˀä̖ˀ ímúuníˀin, inbí pꞌóˀḏéḏîˀ wên khóhtsa̖a̖ shánkíˀeeḏi iweḏi iweemáˀíḏí dâytsíkhaˀmáaˀin. Indá dívítꞌôeˀa̖mígîˀ diˀaamuu, inbí phakó-á dínkomuu, heḏânho napówá ihayḏi oe phóḏi ipópóˀandi wese igîˀ dâyhuu-í. ");
INSERT INTO tew_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nä́ˀin tꞌôeˀin inbí pꞌóˀḏéḏîˀ dínpówá ihayḏi á̖yîngiḏi dikwꞌóˀnin ovâyshaaḏá híhchan dâymáˀve-í. Wâytu̖ˀâ̖a̖mí, i-á ipiˀaawé-í ovâyhúukhâysaa-íḏí, heḏi ovâytu̖ˀâ̖a̖mí dívíkwꞌôení dívíhú̖u̖ya̖míḏí, heḏi hä̖ä̖wí ovâysaa-í. ");
INSERT INTO tew_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tobá khun pinuḏi háa shánkí hä̖̂ä̖ḏanho nanân wänbo naˀä̖ä̖ ihayḏi, dikhâymuuḏi ovâyshaaḏáho híhchan dâymáˀve-í. ");
INSERT INTO tew_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nä́ˀin taˀgendi únhanginnáaní: Wí toˀwí ûntewhákꞌóeˀi hä̖̂ä̖ḏi wí sänbiˀ iˀ tewhá eepiye naˀä̖ˀin ûnhanginnândáhoˀ, háˀto óemä̂äní in phóḏi ithâaníˀin háa wháphóḏi ihâave-íˀin natsꞌú̖u̖níḏí. ");
INSERT INTO tew_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Heḏi un wáˀ íkhâymúuní, gá naa tꞌowa tꞌä̖hkígîˀ oˀaypu̖yä̖ˀiˀ omuuˀi wáˀ hä̖̂ä̖ḏi nanân wänboˀ owáyˀä̖ḏân, dítsíkhaˀmáapí ihayḏi oˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter-di Jesus óetsikaˀyan, “Nanbí Sedó, ti naˀinda̖ˀmân nä́ˀi híˀ dítu̖máa, háa tꞌä̖hkí in wéˀgen tꞌowa wáˀ ovâytu̖máa?” ");
INSERT INTO tew_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesus-di óetu̖ˀan, “Wí tꞌôeˀi hä̖ä̖wí nawóˀnáˀdiˀ híwó iˀoˀi heḏá híwóˀdi hangintan imáaˀi-á waaginbá únkhâyˀä̖ˀ ímúuníˀin. Giˀbi tꞌôeˀi-ânho iví pꞌóˀḏéḏîˀḏi óesôege-í iˀ tewhá ee in wéˀgen tꞌôeˀinbí tsondi dínmúuníḏí, heḏi inbí koegîˀ hä̖ä̖wí ovâymâ̖ḏân, dítsíkhaˀmáaääníḏí hä̖̂ä̖ḏi ihayḏi napóe ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Híhchan iˀ tꞌôeˀi imáˀve-í iví pꞌóˀḏéḏîˀḏi gin iˀoḏi óeshaaḏi ivîˀ iweemaa ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Taˀgendi wâytu̖ˀâ̖a̖mí, iˀ tewhá pꞌóˀḏéḏîˀḏi giˀbi tꞌôeˀi óesôege-í tꞌä̖hkí iví hä̖ä̖wí ônˀá̖yînmáˀve-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hebo iˀ tꞌôeˀi híwó iˀa̖mívíˀweḏi wíˀbo natú̖ḏáhoˀ, ‘Naví tsondi-á nahayjêepóe naˀä̖ä̖-íḏí,’ heḏiho in wéˀgen tꞌôeˀin kwiyä̖ˀdá senäˀdá ovâymahpúovâymâ̖ḏân, dítsíkhaˀmáauchä̖numáaḏá, heḏi i-á húukangîˀ-á su̖wä̖gîˀ-áḏíḏa̖ˀbá-á namuuḏá, heḏá naháapoeˀoḏá, ");
INSERT INTO tew_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","gin iˀandáhoˀ iví pꞌóˀḏéḏîˀ ûnwáyˀä̖ä̖-í óetsíkhaˀmáapíḏí, hä̖̂ä̖ḏi iˀ tꞌôeˀiˀ ûnhanginnáhpí ihayḏi, heḏi iˀ pꞌóˀḏéḏîˀ-á natsonpúuwí iˀ tꞌôeˀi hânho óetuhchä̖ä̖nú-íˀin, heḏá óesaaní in wéˀgen tꞌowa tꞌôeyanpíˀinda̖ˀ dimuuˀin dikwꞌôn diwepiye. ");
INSERT INTO tew_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Wí tꞌôeˀi-á háa iví pꞌóˀḏéḏîˀ ûndaˀ waa ûnhanginnân wänbo hä̖́ä̖bo wíˀiˀanpíḏí, i-áho báyékí whä̖ḏiḏi óetuhchä̖ä̖nú-í. ");
INSERT INTO tew_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hewänbo wí tꞌôeˀi híwóhpí iˀandi gindiḏi ûnkhâyˀä̖ˀ whä̖ḏiḏi ótuhchä̖ä̖nú-íˀin, hewänbo háa iví pꞌóˀḏéḏîˀ ûndaˀin taˀgendi wíˀûnhanginnáhpíḏí, i-áho wä̖hphaḏe wíˀóetuhchä̖ä̖nú-ípí. Toˀwên tꞌä̖hkí báyékí ovâymä́giˀindáho báyékíbá dínkhâyˀä̖ˀ dâywáymä̂äníˀin, heḏi toˀwên inbí mange báyékí ovâykwꞌóḏiˀindáho báyékíbá dínkhâyˀä̖ˀ iweḏi dívíˀa̖míˀin.” ");
INSERT INTO tew_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Naa nä́ä oepáa kꞌayḏipiye oˀä̖ä̖ wí phaa waabá namuuˀi dómáˀíḏí, heḏi hânho odaˀ ho nakojeˀníˀin. ");
INSERT INTO tew_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Naa dînkhâyˀä̖ˀ dontꞌôephaaḏé-íˀin, heḏi naví píˀnä́ khóˀjé hânho ochanpúuwí gin dînpóe píhay. ");
INSERT INTO tew_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hân íˀándeˀ? Ti tꞌowa dívíwóení naa nä́ä oepáa kꞌayḏipiye oˀä̖ä̖ḏiboˀ? Joe, tꞌowa-á dívíweejé-í. ");
INSERT INTO tew_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nää iweḏáho gin waagi namúuní: Maḏi pꞌánú tꞌowa wêe tewhá iwe dithaa, heḏi diwijeḏeeḏi wêegeˀin dipúuwí, wíjeḏiho wéˀge, pojeḏá wéˀgá, heḏi in wíjeḏiho in pojevíˀpiye háa dicha̖a̖-í, heḏá in pojeḏá in wíjevíˀpiyá. ");
INSERT INTO tew_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iˀ táḏá-áho iví eˀnúvíˀpiye háa nacha̖a̖-í heḏi iˀ eˀnú-áho iví táḏávíˀpiyá. Iˀ jíyá-áho iví aˀyú̖víˀpiye háa nacha̖a̖-í, heḏi iˀ aˀyú̖-á iví jíyávíˀpiyá. Iˀ jahkwíjo iví sâaˀivíˀpiye háa nacha̖a̖-í, heḏi iˀ sâaˀi-á iví jahkwíjovíˀpiyá.” ");
INSERT INTO tew_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Heḏáháˀ in báyékí tꞌowa iwe dikwꞌóˀnin ovâytu̖ˀan, “Wí okhúwá oe tsânpiyeḏi naˀä̖ḏi bînmûˀḏi, wese ítû̖ˀ ikwa̖hkhâymáaˀin, heḏi híwó ítû̖ˀ gá han napúuwíḏân. ");
INSERT INTO tew_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Heḏi oe aakonpha̖ˀgeḏi wovâywa̖a̖námäˀdi, ítû̖ˀ hânho itsá̖wä̖khâymáaˀin, heḏi híwó ítû̖ˀ, gá han napúuwíḏân. ");
INSERT INTO tew_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Undá paa dívíjánúmáaˀin waaginbá ímuu. Nä́ä oepáa kꞌayḏá heḏá makówá-á háa iˀ okhúwá-á wa̖a̖-á nakeetꞌóe waa bînmúndeḏi únhanginná háa nanáaníˀin, heḏi háaḏan handi wíˀúnkeepoeˀopí háa natundaˀin iˀ wéˀgeˀi hä̖ä̖wí nää nä́ˀi thaa eeje Jôesi Táḏá iˀoˀiˀ? ");
INSERT INTO tew_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Heḏi háaḏan unbo wíˀúvípiˀánshaaˀohpí únhanginnáaníḏí wéˀi wí hä̖ä̖wí híwóˀdi namuuˀin úvíˀa̖míḏí? ");
INSERT INTO tew_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Heyâagú wí toˀwíḏí háawên wovâychä̖nundeḏi heḏá wovâytunjóˀdiwehondá, waˀ ímändiboˀ i-áḏí úvíkoḏiˀa̖mí heḏânho iˀḏi wovâymaˀpꞌä̖̂ä̖ḏi-íḏí heḏá iˀ tsondiví páaḏépiye wíwovâyhûuwípí. Eepiye wovâyhoˀḏáho maḏi iˀ tsondiḏáho iˀ pan á̖yí̖ˀdiví mangá wovâyjoeˀa̖mí heḏá iˀḏáho wovâypanhûuwí. ");
INSERT INTO tew_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wâytu̖ˀâ̖a̖mí, gin únpóeḏáho háˀto wovâymaˀpꞌä̖̂ä̖ḏi-í hä̖́yú̖ íphaamuu tꞌä̖hkí úvíwáˀâa píhay” gin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ihayhä̖̂ä̖bá wên tꞌowa iwe dijiˀindá Jesus-á óetu̖ˀan háa wên Galilee nangewin dínpóeˀin. Ditú̖ iˀ méesate hayˀi ee Pilate-di nä́ˀin Galilee-ˀin ovâyhá̖nú waˀ dâyˀanimâahá̖núndeḏibo Jôesi Táḏá óemä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus-di ovâytsikaˀyan, “Heḏi hân íˀándeˀ? Ti hä̖ˀin Galilee-ˀin haˀwâa dínpóeḏíbo shánkí tꞌaywóhkannin dimuu in wéˀgen Galilee-winbíˀweḏi? ");
INSERT INTO tew_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Joe, háˀtoˀ. Wâytu̖máa, undá wáˀ unbí tꞌaywóˀdi bînjoeˀanpíḏá íchuu-í. ");
INSERT INTO tew_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Heḏi in tä̖ˀḏi kháve (18) tꞌowa oe Siloam tsowa ovâyhá̖núˀin iˀ tewhá tu̖ˀwändi dínkanuḏi, hândá inbí̖ˀgeḏi íˀándeˀ? Ti indá shánkí híwóhpí dívíˀoˀindá dimuuwän in wéˀgen tꞌowa oe Jerusalem búˀ dithaaˀinbíˀweḏi? ");
INSERT INTO tew_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Joe, háˀtoˀ. Wâytu̖máa, undá wáˀ unbí tꞌaywóˀdi bînjoeˀanpíḏá íchuu-í.” ");
INSERT INTO tew_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Heḏáháˀ nä́ˀin há̖hkangíˀin óˀgéḏí ovâytu̖ˀan: “Wên fig tay wí senbí nava iwe ûnchá, heḏi iˀ sen namää ihä̖ä̖pꞌaynuuwä̖́-íḏí, hebo hä̖́ä̖bo wíˀishaapí. ");
INSERT INTO tew_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Heḏiho iví nava tꞌôeˀi itu̖ˀan, ‘Ótꞌôeyan, nää-áḏího poje pa̖a̖yoho oˀä̖ä̖ donhä̖ä̖pꞌaynuuwä̖́-íḏí nä́ˀin tay iwe, hewänbo waˀḏi hä̖́ä̖bo wíḏonshaapí. Nátsꞌaˀ, nawänpiḏachá.’ ");
INSERT INTO tew_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hebo iˀ nava tꞌôeˀiˀḏi óetu̖ˀan, ‘Naví tsondiˀ, wíyá wêe pa̖a̖yowän nâasôemä̂äní, heḏi ee napúujiˀ i̖ˀge dónahpaa-í heḏá dósáˀkwꞌôení. ");
INSERT INTO tew_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Heḏiho nää wíyá pa̖a̖yo nahä̖ä̖pꞌaypóeḏáhoˀ, híwó, hebo napaapíḏáho natsaaḏee-í.’ ” ");
INSERT INTO tew_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wí kaykhanwówá thaa Jesus-di in tꞌowa in Huḏíyoví méesateˀay ee ovâyhá̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wí kwee wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáaˀiˀ iwe najiˀ, heḏi tä̖ˀḏi kháve (18) pa̖a̖yo óehayˀan, heḏi naḏapháygípóeḏí wínataˀgepoeˀopí. ");
INSERT INTO tew_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus-di iˀ kwee óemûˀḏi óetu̖ˀan, “Kóˀôe, nä́ˀi hay wóemáaˀi wînjâaˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Heḏi iˀ kwee óetä̖geḏi wesebo nataˀgepóe, heḏi iˀḏi Jôesi Táḏá-á kwꞌáayéboˀ óemáa. ");
INSERT INTO tew_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hewänbo iˀ Huḏíyoví méesateˀay pꞌóˀḏéḏîˀ natꞌayjiˀ, kaykhanwówá thaa Jesus-di iˀ kwee óehehkháamä́giḏi, heḏiho in tꞌowa ovâytu̖ˀan, “Sí tꞌôe thaa naná jâaḏi waa, heḏi iweḏi wéˀi wí thaa wänbo íˀä̖ä̖-í wovâyhehkháamä̂äníḏí, iˀ kaykhanwówá thaa-á joe.” ");
INSERT INTO tew_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nanbí Sedó Jesus-di ovâytu̖ˀan, “Un paa waaginbá úvíjánúmáaˀin ímuuˀin, ti kaykhanwówá thaa nanân wänbo toˀwíḏí wänbo un diweḏi unbí wáasí háa búdu wívînwhisuuḏepíˀan heḏânho phéhkhaa iweḏi napee-í bînpꞌoemä̂äníḏí? ");
INSERT INTO tew_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Heḏi nä́we nä́ˀi kwee Abraham-bí ây iweḏiˀiˀbá namuuˀi najiˀ, i-á iˀ Penísendi Satan-di tä̖ˀḏi kháve (18) pa̖a̖yo óewhiˀan waagibá. Ti híwó wínamuupíˀan óemaˀpꞌä̖̂ä̖ḏi-íḏí kaykhanwówá thaa nanân wänboˀ?” ");
INSERT INTO tew_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Heḏiho tꞌä̖hkí in óetunsúumáaˀin diwôedaˀpóe, heḏá tꞌä̖hkí in wéˀgen tꞌowa-á dihíhchanpóe, tꞌä̖hkí hä̖ä̖wí heˀendi híwó iˀandi. ");
INSERT INTO tew_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus-di wíyá ovâyhéeˀandi ovâytu̖ˀan, “Hân wâytu̖ˀa̖mí únhanginnáaníḏí háawin Jôesi Táḏáví há̖hkan ûnmuu waa. Háḏíḏan wâythayya̖mí hä̖ä̖ waagi namuuˀin? Gá ginnân: ");
INSERT INTO tew_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wí hínchä̖̂ä̖ˀi mustard koˀji wí sen ikêˀḏi iví nava iwe ikoeˀi waagiˀbá namuu. Natsijópúpóeḏí nasôeḏá wên tay napaa, heḏi in tsíḏé dívíshunwá̖ve iˀ waˀjáy khóe eeje dâyyä̖́hpaˀíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Heḏá wíyá ovâytu̖ˀan, “Hân wâytu̖ˀâ̖a̖mí wâythayya̖míḏí hä̖ä̖ waagi Jôesi Táḏáví há̖hkan ûnmuuˀin? ");
INSERT INTO tew_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gá ginnân: Wí oewáasee wí kwee báyékí khändáḏí iwóndiˀ waagiˀbá namuu, heḏi nasôeḏi hanwaapíḏíboˀ iˀ oewáa tꞌä̖hkí napee.” ");
INSERT INTO tew_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus oe Jerusalem búˀpiye namän, heḏi iˀ búˀây eeje ówînge eejá namändi tꞌowa ovâyhá̖hkanhon. ");
INSERT INTO tew_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Heḏi wí toˀwíḏí óetsikaˀyan, “Nanbí Sedó, ti wí hí̖yä̖̂ä̖ḏi tꞌowaḏa̖ˀ ovâyˀaywoení?” ");
INSERT INTO tew_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jesus-di in iwe dijiˀin ovâytu̖ˀan, “In makówáwin phóḏi hí̖yä̖̂ä̖ saygiˀinda̖ˀ namuu, heḏiho hânho úvíkhä̖ä̖-í iwe ítsꞌú̖u̖níḏí. Wâytu̖ˀâ̖a̖mí, báyékí un ítsuḏedaˀí, hebo háˀto únkoeḏí-í. ");
INSERT INTO tew_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jôesi Táḏá iˀ iweˀiˀ pꞌóˀḏéḏîˀ namuuˀi-áho in phóḏi itꞌêeḏi-í, heḏi un ho ítsꞌú̖hpíˀindá jáˀwébo-áho wovâyjoeˀa̖mí, heḏi bînpópóˀoḏi ítú̖u̖ní, ‘Nanbí Sedó, nä́ˀin phóḏi dînhuu heḏânho gitsꞌú̖u̖níḏí.’ Hewänbo i-á natú̖u̖ní, ‘Toˀwên ímuuˀin naa wíḏînhanginnáhpí.’ ");
INSERT INTO tew_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Heḏi undi bîntu̖ˀâ̖a̖mí, ‘U̖-áḏí ívíhú̖u̖yan, heḏi nanbí búˀ iwe u̖ˀḏi díhá̖ˀan.’ ");
INSERT INTO tew_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hewänbo i-á natú̖u̖ní, ‘Wâytu̖ˀanpíˀan, toˀwên ímuuˀin naa wíḏînhanginnáhpí. Un yä̖ˀḏâapí tsiyekannin ímuuˀin, navíˀweḏi bíjâatä̖ä̖.’ ");
INSERT INTO tew_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Heḏi Abraham-dá Isaac-á Jacob-á heḏá tꞌä̖hkí in Jôesi Táḏáví tukheˀmindá oe makówá bînpu̖wä̖khâymáa, hebo undá jáˀwébo-á wovâyjoeˀa̖mí. Ihayḏiho ítꞌayḏi úvísíhtä̖ä̖khâymáaḏáháˀ úvíwä̖ˀtsꞌeekhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iwe tꞌowa-áho pꞌinpha̖ˀgeḏá tsânpha̖ˀgeḏá aakonpha̖ˀgeḏá thanpha̖ˀgeḏá diwéˀgepóewí, heḏi dínshánkíˀeeḏinân waabá dínpúuwí. ");
INSERT INTO tew_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Heḏi ihayḏi wên toˀwên nää tíˀúugéˀin waa díncha̖a̖ˀindá pꞌóˀḏéḏíˀin dipúuwí, heḏi wên toˀwên pꞌóˀḏéḏíˀin dimuu gin diˀándeˀindáho tíˀúugéˀindáho dipúuwí.” ");
INSERT INTO tew_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ihayhä̖̂ä̖bá wên Pharisees-á oe Jesus naˀä́n diwá dipówáḏí óetu̖ˀan, “Shánkí híwó nä́weḏi unmú-í, gá Herod iˀ pꞌóˀḏéḏîˀ namuuˀi wóeháyjíˀin nadaˀḏân.” ");
INSERT INTO tew_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus-di ovâytu̖ˀan, “Jaˀ bintu̖ˀan hä̖ˀi pꞌóséwhâa, wí hä̖́yú̖ thaawän tꞌowa dovâyhehkháamáˀve-í, in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖-á dovâykhehpíyeˀbe-í, heḏi ihayḏânho naa naví tꞌôe donboewá-í. ");
INSERT INTO tew_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hewänbo nää nä́ˀi thaa eeje waˀḏi oe Jerusalem búˀpiye omän. Wí Jôesi Táḏáví tukheˀbi óehayḏá, nakhâyˀä̖ˀ oe Jerusalem diweḏa̖ˀmânho ûnpúuwíˀin. ");
INSERT INTO tew_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Un tꞌowa oe Jerusalem-win, in Jôesi Táḏáví tukheˀmin bîndahá̖núndeˀ, heḏá in tꞌôepa̖ˀa̖a̖ˀin Jôesi Táḏáḏí unbíˀpiye wovâysannindá bînkꞌusä̖yundeˀ. Hä̖́yä́nnanho odaˀ wâybaˀaaˀa̖míˀin, wí dee iví deeˀây ikꞌu̖ˀaanúˀhónde waabá, hewänbo undi wíḏímähpí. ");
INSERT INTO tew_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Heḏânho wáy íthaa iwáho wí tayjee waabá únjoekandee-í. Wâytu̖ˀâ̖a̖mí, háˀto wíyá undi dímúuní owáy iˀ thaa napówá píhay naví̖ˀgeḏi ítú̖ ihayḏi, ‘Jôesi Táḏáḏí híwó óeˀâ̖a̖mí iˀ toˀwí ônkꞌûˀiˀ naˀä̖ä̖-íḏí.’ ” ");
INSERT INTO tew_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wí kaykhanwówá thaa Jesus wí pꞌóˀḏéḏîˀ Pharisee-ví tewhá eepiye namää ihú̖u̖ya̖míḏí, heḏi in tꞌowa dikwꞌóˀnindi hânho á̖yîngiḏi óemúndeˀ. ");
INSERT INTO tew_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wí sen iví núˀ naˀä́n, i-á iví túˀ tꞌä̖hkí hânho ûnteemuu. ");
INSERT INTO tew_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus-di in Huḏíyoví khuu dâyhá̖ˀoˀindá in Pharisees-á ovâytsikaˀyan, “Ti iˀ tsontundi naˀin dímäˀ wí toˀwí kaykhanwówá thaa nanân wänbo âyhehkháamä̂äníḏí háa joe?” ");
INSERT INTO tew_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hewänbo indá háabo wíḏitú̖hpí. Heḏiho Jesus-di iˀ sen óetä̖geḏi óehehkháamä́gi, heḏi iweḏi óesan. ");
INSERT INTO tew_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Heḏáháˀ ovâytu̖ˀan, “Wénä wí un wí eˀnú háa wí wáasí úˀä́ndiˀ wí pꞌobúˀ iwe nakeˀtꞌândi, ti wesebo wímänwhahkáyjípíˀan tobá kaykhanwówá thaa nanân wänboˀ?” ");
INSERT INTO tew_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hebo háawin wên wänbo wíḏínhanginnáhpí óetu̖ˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Heḏi Jesus-di ovâymûˀ wáy wên ovâyhúutu̖ˀannin in shánkí kwꞌáyeˀinbí soge eeje dívíkwꞌóeˀóḏí, heḏiho nä́ˀi tumakhe ovâytu̖ˀan: ");
INSERT INTO tew_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wí toˀwíḏí wí khóhtsa̖a̖ shánkíˀeeḏipiye wovâytu̖ˀandá, in kwꞌáyeˀin dimuuˀinbí soge eejá wíˀúvíkwꞌôenípí. Maḏi wây toˀwên unbí shánkí kwꞌáyeˀin dimuuˀin wáˀ ovâyhúutu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","heḏiho iˀ toˀwí in wéˀgendáḏí undáḏí un tꞌä̖hkí ihúutu̖ˀandiˀḏi wovâytu̖ˀâ̖a̖mí, ‘Un bíha̖ḏi, nä́ˀin wéˀgen senäˀ nä́we dívíkwꞌôení,’ heḏi íwôedaˀpóeḏí úvíkwꞌôení wáy in shánkí áagéˀin dívíkwꞌóeˀó eeje. ");
INSERT INTO tew_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hewänbo wovâyhúutu̖ˀandá gin úvíˀa̖mí: In shánkí heˀennin dimuupíˀinbí soge eeje úvíu̖ní, ‘Hä̖ˀindá hîn kwꞌáyeˀinnânkun dimuu.’ ");
INSERT INTO tew_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Toˀwên tꞌä̖hkí heˀennin dívípipaˀindáho hí̖ˀínnin ovâypaˀí, heḏá toˀwên hí̖ˀínnin dívípipaˀindáho heˀennindá ovâypaˀí.” ");
INSERT INTO tew_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Heḏáháˀ Jesus-di nä́ˀi sen iˀ óehúutu̖ˀandiˀ óetu̖ˀan, “Wên shánkíˀeeḏi mänpaaḏi tobá hä̖̂ä̖ḏi nanân wänboˀ, wímänhúutu̖ˀâ̖a̖mípí uví kꞌemaˀinda̖ˀ, háa uví páˀḏâyˀindá tíˀûuwindá inda̖ˀ, háa uví maatuˀinda̖ˀ, háa uví ówí̖nn dimuupíˀinbí soge eeje úvíä́ˀin koḏitꞌowa dimuuˀinda̖ˀ. Indáho wóewáyhúutu̖ˀâ̖a̖mí, heḏi gindiḏiho wóewáˀâa-í. ");
INSERT INTO tew_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hewänbo wên shánkíˀeeḏi mänpaaḏá ovâyhúutu̖ˀâ̖a̖mí in sehkanäwó diwówájiˀindá, in dikhóhaymuuˀindá, in ditsiˀḏeeˀipíˀindá, heḏá ditsítꞌaamuuˀindá. ");
INSERT INTO tew_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Gin biˀandáho báyékí unhíhchaaní. Indá háˀto dínkoeḏí-í wóewáywáˀâa-íḏí, hewänbo owáy in tꞌowa inbí wówátsi taˀge dâyhonnin diwáywówápóe ihayḏi Jôesi Táaḏáho wóewáywáˀâa-í.” ");
INSERT INTO tew_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wí toˀwí iˀ mä́äsa naˀä́ndiˀ nä́ˀi natꞌoeḏi Jesus óetu̖ˀan, “In toˀwên oe makówá dikwoníˀin híhchan dâymáˀve-í. Indá wí shánkíˀeeḏi nanáˀ diwe dikwꞌôn waabá dínpúuwí.” ");
INSERT INTO tew_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hebo Jesus-di óetu̖ˀan, “Wí sen wí hayˀi shánkíˀeeḏi ipaa heḏi báyékí tꞌowa ovâyhúutu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nahä̖ä̖wíkhâymuu ihayḏi iví tꞌôeˀiˀ itu̖ˀan, ‘In tꞌowa ovâytu̖ˀâ̖a̖mí, Bíkä̖ˀve, hä̖ä̖wí tꞌä̖hkí nakhâymuu.’ ");
INSERT INTO tew_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Heḏi tꞌä̖hkíḏíbo wíˀínbo diˀowójédaˀpóe. Wí wêe natú̖, ‘Naa wí nava dontsꞌankumä heḏiho omän donmúuníḏí. Nâatu̖ˀâ̖a̖mí dînˀowóejé-íḏí iˀ shánkíˀeeḏipiye wíḏînpu̖hkoḏipíḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wíyá wêe-á natú̖, ‘Pꞌánú puˀwaˀin wéyu dontsꞌankumä heḏi omän dovâyjâyyé-íḏí, heḏiho nâatu̖ˀâ̖a̖mí dînˀowóejé-í iˀ shánkíˀeeḏipiye wíḏînpu̖hkoḏipíḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Heḏá wíyá wêe-á natú̖, ‘Naa dáytsꞌankhóˀyâ̖ˀ, heḏiho wíḏînkoḏipí omú-íḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Iˀ tꞌôeˀi nawáymääḏi iví pꞌóˀḏéḏîˀ itu̖ˀan háa ditú̖ˀin, heḏi iˀ pꞌóˀḏéḏîˀ natꞌayjaapóeḏí iˀ tꞌôeˀiˀ óetu̖ˀan, ‘Ówä̖́näkiˀ iˀ búˀwi pꞌóegé eeje iˀ pꞌôeˀây eejá ópûn, in sehkanäwó diwówájiˀindá in dikhóhaymuuˀindá ditsíˀtꞌaamuuˀindá heḏá in ditsiˀḏeeˀipíˀindá ovâymáˀí.’ ");
INSERT INTO tew_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Heḏiho iˀ tꞌôeˀi namää, heḏi nawáyˀä̖ä̖ḏi óetu̖ˀan, ‘Naví tsondiˀ, háa untú̖ waa naa dáyˀan, hewänbo waˀ wây-á tꞌowagîˀ najâaná.’ ");
INSERT INTO tew_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Heḏiho iví tꞌôeˀiˀ itu̖ˀan, ‘Ópûn oe pꞌóegé heˀendi-á hí̖ˀíndi-á oe búˀ jáˀwé eeje, heḏi kayˀindi in tꞌowa ovâytu̖ˀâ̖a̖mí naví tewhá eepiye diˀä̖ä̖-í heḏânho ditꞌowabáˀyayníḏí. ");
INSERT INTO tew_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Wítu̖máa, in páaḏéḏí ovâyhúutu̖ˀannin diweḏi tóebo naví shánkíˀeeḏi koegiˀ háˀto ikꞌoˀí.’ ” ");
INSERT INTO tew_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Heḏi Jesus iweḏi namääḏi wây-á báyékí tꞌowaḏi óeyu̖u̖hoˀ, heḏi ibéeḏí ovâytu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Wí toˀwí navíˀpiye naˀä̖ä̖ḏáho naví khä̖geˀdi dînmúuníḏí, hewänbo naaho shánkí wíḏísígípíḏí iví táḏá-á jíyá-á inbíˀweḏi, háa iví kwee-á áyyä̖̂ä̖-á páˀḏâyˀindá tíˀûuwindá inbíˀweḏi, heḏá iví wówátsivíˀweḏi wänbo-á, háˀto taˀgendi naví khä̖geˀdi napúuwí. ");
INSERT INTO tew_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wí toˀwí iví phéˀwin ihonpíḏí heḏá naa díyu̖u̖honpíḏí, háˀto naví khä̖geˀdi napúuwí. ");
INSERT INTO tew_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Wí toˀwí wí tewhá hayˀi ikꞌúuwíˀin nadaˀḏá, hä̖́yú̖ chä̖ˀ ûntáyˀin páaḏé imaapaˀí heḏânho ûnhanginnáaníḏí háa ihay chä̖ˀ imáaˀin iboewá-íḏí háa joe. ");
INSERT INTO tew_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Heḏi páaḏé imaapaapíḏí maḏi iví tepúḏa̖ˀmân iboewá-í, heḏi iˀ tewhá-á háˀto ûnkoeḏí-í iboewá-íḏí, heḏi in toˀwên gin ûnpoeˀoḏi dâymûˀindáho ônpꞌáhkáˀve-í, ");
INSERT INTO tew_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","heḏi ditú̖u̖ní, ‘Nä́ˀi sendá wí tewhá itsꞌanpáaḏékúyaˀ, hewänbo háˀto iboewá-í.’ ");
INSERT INTO tew_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Heḏá wí nangewi pꞌóˀḏéḏîˀ-á wétä̖ maapaasôn (20,000) sundaḏo ûnkwꞌóˀdi wíyá nangewi pꞌóˀḏéḏîˀ óeyâ̖a̖-íḏí namääḏá, heḏi nä́ˀi-á tä̖ maapaasônda̖ˀbá (10,000) ûnkwꞌó, waˀḏi dívíyâ̖ˀpíḏíboˀ iˀ tä̖ maapaasônda̖ˀ ûnkwꞌóˀdi-áho páaḏé iˀánshaaˀa̖mí heḏi ipitsikaˀyâ̖a̖mí háa natꞌanpúuwíˀin háa joe. ");
INSERT INTO tew_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Heḏi natꞌanpúuwípíḏáhoˀ waˀ in wéˀgen kayi̖ˀ deeḏi diˀä̖ḏiboˀ iví tꞌôekhuwaˀin isaaní iˀ wêe pꞌóˀḏéḏîˀ óetsikaˀya̖míḏí háa dänˀa̖míˀin heḏânho dänyâ̖a̖-ípíḏí. ");
INSERT INTO tew_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Heḏiho un wáˀ hanbá híwó úvíˀánshaaˀa̖mí. Unbí hä̖ä̖wí íjoekandaˀpíḏáho háˀto naví khä̖geˀnin ípúuwí.” ");
INSERT INTO tew_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“A̖a̖yä̖ä̖-á híwóˀdi namuu, hewänbo naˀá̖hhándáho háˀto wíyá á̖hsä̖ä̖ˀi napúuwí. ");
INSERT INTO tew_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nä́ˀi a̖a̖yä̖ä̖ naˀá̖hhándá wínachä̖ˀmuupí. Híwó wínamuupí óewóeníḏí nandáḏí háa nasátä̖́bóeḏíˀä́ndi-áḏí wänboˀ, i-á dâywänpichꞌáaḏeˀ. Tꞌä̖hkí naví híˀ ditꞌoeˀin dínkhâyˀä̖ˀ híwó dîntꞌôeyaaníˀin” gin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Báyékí tax phahsannindáḏí heḏá wéˀgen tꞌowa tꞌôeyanpíˀin gin ovâytu̖máaˀindáḏí diˀä̖ä̖ˀä̖ Jesus-ví híˀ ôntꞌôeyaaníḏí. ");
INSERT INTO tew_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","In Pharisees-áḏí heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindáḏí háa napoeˀoˀin wíˀovâyhí̖ˀanpí, heḏiho ditú̖, “Nä́ˀi sendá hä̖ˀin tꞌaywóhkannin ovâysígíˀo heḏá inḏáḏá ihúujoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Heḏiho Jesus-di in Pharisees nä́ˀi há̖hkangîˀ híˀ ovâytu̖ˀan: ");
INSERT INTO tew_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Wí sen tä̖gintä̖ (100) kꞌúwá ipamáaḏí, wí wêe ûnpeḏeeḏi hân iˀa̖mí? Gá in whä̖gintä̖ˀḏi whä̖nu (99) ee pꞌohtsaa búge dijiˀin ovâyjoeˀankíḏí namú-ípíˀan iˀ wêe napeḏeeˀiˀ óenuuwä̖́-íḏí ishaa píhay. ");
INSERT INTO tew_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Heḏi ishaa ihayḏi hânho nahíhchanpóeḏí iví kꞌuuwoe eeḏi ikꞌúuwí, ");
INSERT INTO tew_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","heḏi ivíˀpiye ihoˀḏi tꞌä̖hkí iví kꞌemaˀindá iví ówí̖nä́ˀindá iví kꞌaygipiye itu̖hkánnamí, heḏi ovâytu̖ˀa̖mí, ‘Naa-áḏí úvíhíhchannamí, gá nää-á naví kꞌúwá dînpeḏeeˀi donshaaḏân.’ ” ");
INSERT INTO tew_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Heḏáháˀ Jesus natú̖, “Naaḏi wâytu̖máa, oe makówá wáˀ ginbá namuu. Oe makówá dívíhíhchando wêe wänbo tꞌaywóhkandi namuuˀiˀ iví tꞌaywóˀdi ijoeˀan dihayḏi, hewänbo whä̖gintä̖ˀḏi whä̖nu (99) tꞌowa diˀándeˀin inbí wówátsi taˀge dâyhonninbí̖ˀgeḏá oe makówá wíḏívíhíhchandopí.” ");
INSERT INTO tew_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Heḏi wí kwee tä̖ ihay kwä̖́kꞌu tsꞌä̖ˀi chä̖ˀ ûnjiḏi wêe wáy ihoˀḏi, ikoˀa̖mípíˀan, heḏá iví tewhá ee tꞌä̖mäpiye iˀaaˀa̖mí iˀ chä̖ˀ inuuwä̖́-íḏí ishaa píhay. ");
INSERT INTO tew_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Heḏi ishaa ihayḏá iví kꞌemaˀindáḏí heḏá iví ówí̖nä́ˀindáḏí iví kꞌaygipiye itu̖hkánnamí heḏi ovâytu̖ˀa̖mí, ‘Naa-áḏí úvíhíhchannamí, nää-á naví kwä̖́kꞌu tsꞌä̖ˀi donwáyhoˀi donshaa.’ ” ");
INSERT INTO tew_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Heḏáháˀ Jesus natú̖, “Naaḏi wâytu̖máa, hanbá oe makówá napoeˀo. Wêe wänbo tꞌaywóhkandiˀ iví tꞌaywóˀdi ijoeˀandá Jôesi Táḏáví makówáwin tꞌôepa̖ˀa̖a̖ˀin dívíhíhchandoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ihayḏáháˀ Jesus-di ovâytu̖ˀan, “Wí sen wíje eˀnûn ûnˀä́n. ");
INSERT INTO tew_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iˀ tíˀúugéˀiˀ eˀnú iví táḏá itu̖ˀan, ‘Táa, nää naa dímä́ä uví hä̖ä̖wí iweḏi iˀ dînˀä̖ˀiˀ.’ Heḏiho iˀ táḏá iˀ hä̖ä̖wí ûnkwꞌóˀdiˀ iví wíje eˀnûn ovä̂nwije. ");
INSERT INTO tew_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wíyá hä̖́yú̖ thaa naphaḏe ihayḏi nä́ˀi tíˀúugéˀiˀ eˀnú iví hä̖ä̖wí iku̖ˀchꞌáakíḏí iví táḏáví kꞌaygiḏi napee iˀ chä̖ˀ wóegé, heḏi wí nange kayi̖ˀ nanáˀ diwepiye namää, heḏi háa nawänpidaˀ waagi iví wówátsi ihondi iví chä̖ˀ tꞌä̖hkí iwänpihá̖nú. ");
INSERT INTO tew_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Iví chä̖ˀ tꞌä̖hkí ihá̖nú ihayhä̖̂ä̖bá iˀ nange iwáygá hânho diha̖a̖póe, heḏiho hä̖ä̖wíḏí iví wówátsi iˀa̖míˀin wíˀûnkwꞌóhpí. ");
INSERT INTO tew_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Heḏiho itꞌôenuuwä̖́-íḏí namää, heḏi wí sendi óetꞌôemä́giḏi owáy iví nava iwáygépiye óesan iví pehtsuḏe ovâyhúujôeníḏí. ");
INSERT INTO tew_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hânho nadaˀ iˀ hä̖ä̖wí pehtsuḏe dâykꞌoˀi wänbo ikꞌoˀíˀin nashu̖ˀmúuníḏí, khúnkhowa hä̖ä̖wí namuu wänboˀ, hebo toˀwíḏí wänbo koegîˀ wänbo wíˀóemä́gipí. ");
INSERT INTO tew_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Heḏáháˀ wí thaa iví hangintan iwáykêˀḏi gin iˀánshaaˀan: Naví táḏáví tꞌôeˀin wänbo hä̖́yú̖ dívíshiví wówátsi iˀa̖míˀin wíˀû̖ˀa̖míˀin koegîˀ dínkwꞌó, heḏá shánkí wänbo-á dínkwꞌó, heḏi nä̂äwá naa-á oha̖hchuwamääˀä̖ḏá oˀä́n. ");
INSERT INTO tew_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Naví táḏávíˀpiye omú-í heḏi dótu̖ˀâ̖a̖mí, Táa, naa dáytꞌaywóˀnan iˀ makówá naˀä́ndivíˀpiye, heḏá uvíˀpiyá. ");
INSERT INTO tew_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Naa ihay híwóˀdi wóˀmuupí uví ay gin wíyá dítu̖ˀâ̖a̖míḏí, hewänbo uví tꞌôeˀi waagibá dímáˀve-í.’ ");
INSERT INTO tew_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Heḏiho iví táḏávíˀpiye namää, hewänbo waˀ kayi̖ˀdi naˀä̖ḏiboˀ iví táḏáḏí óemûˀ, heḏi iˀ táḏá iví eˀnúvíˀpiye nasehkanäpóeḏí iˀ eˀnúvíˀpiye iˀä̖ä̖ heḏi óebaˀaaˀandá óesígípꞌohtsä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Heḏi iˀ eˀnú iví táḏá itu̖ˀan, ‘Táa, naa dáytꞌaywóˀnan iˀ makówá naˀä́ndivíˀpiye heḏá uvíˀpiyá. Naa ihay híwóˀdi wóˀmuupí uví ay gin wíyá dítu̖ˀâ̖a̖míḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hewänbo iˀ táḏá iví tꞌôeˀin itu̖ˀan, ‘Bíwä̖́näsaḏi wên saˀwóˀnin kꞌéwéˀin to binmáˀ, heḏi bintoˀ, heḏá iví mankhú̖ eeḏá binmankhútoˀan, heḏá iví ân deeḏá binˀantoˀan. ");
INSERT INTO tew_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Heḏá iˀ wáasíˀay âytûuˀoˀi binmáˀ âyháyjíḏí, heḏi âyshánkíˀeeḏipaˀí. ");
INSERT INTO tew_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nä́ˀi naví eˀnú-á nachuu waagibá ûnpóe, hewänbo nää nawáywówápóe. Napeḏee waagibá, hewänbo nää-á donwáyshaa.’ Heḏiho dâyshánkíˀeeḏipaa. ");
INSERT INTO tew_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nä́ˀi tꞌä̖hkí napuwamän dihayḏi iˀ páaḏéˀi eˀnú owáy nava iwáygé najiˀ, heḏi iweḏi naˀä̖ḏi owáy tewhá tsowa wáy napowaˀä̖ˀ ihayḏi dâykhaˀwoḏá dâypúwhä̖ä̖ˀoḏá heḏá dívíjáḏéndeḏá natꞌoe. ");
INSERT INTO tew_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Heḏiho wí tꞌôeˀi óetu̖hkánnandi óetsikaˀyan, ‘Hânnan napoeˀo?’ ");
INSERT INTO tew_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Iˀ tꞌôeˀiˀḏi óetu̖ˀan, ‘Uví tíˀûu-ân iwáyweekán, heḏiho unbí táḏá natsonpóe iˀ wáasíˀay âytûuˀoˀi dâyháyjíˀin, gá iví eˀnú bahpíbo ûnwáypówáḏân.’ ");
INSERT INTO tew_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iˀ páaḏéˀi eˀnú nä́ˀi natꞌoeḏi natꞌayjaapóe, heḏi owáy tewhá ívepiye wínatsuḏehíjepí. Iví táḏá ûnpeeḏi óedaaˀan natsꞌú̖u̖níḏí. ");
INSERT INTO tew_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hewänbo iví táḏá itu̖ˀan, ‘Otꞌôeyan táḏá, naa báyékí pa̖a̖yo hânho u̖gîˀ dáytꞌôemáa, hä̖̂ä̖ḏi wänbo tꞌä̖hkí háa untsonpóe waagi dáyˀaˀgindoˀ, hewänbo wí kꞌúwáˀay síˀjaaˀi wänbo wíḏímä́gipí naví kꞌemaˀindáḏí donshánkíˀeeḏipaˀíḏí. ");
INSERT INTO tew_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hewänbo nä́ˀi wêe eˀnú uvîˀ úmuuˀi-á hä̖ä̖wí tꞌä̖hkí nâamä́giˀiˀ ipeḏeeˀan. Iví chä̖ˀdá tꞌä̖hká ihá̖nú aˀyûn tꞌaywóhkannin dimuuˀindáḏí iwhoˀkꞌúwíḏí, heḏi nää iweekándá iˀ wáasíˀay âytûuˀoˀi-á iˀgîˀ-á mânhay.’ ");
INSERT INTO tew_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Iˀ táḏáḏí óetu̖ˀan, ‘Naví ay, u̖ hä̖̂ä̖ḏi wänbo tꞌä̖hkí naa-áḏí unˀä́n, heḏi hä̖ä̖wí naa dînkwꞌóˀdi-á uvîˀ wáˀ úmuu. ");
INSERT INTO tew_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hewänbo gínkhâyˀä̖ˀ âyshánkíˀeepaˀíˀin heḏá gihíhcha̖a̖-íˀin. Nä́ˀi uví tíˀûu úmuuˀi nachuu waagibá, hewänbo nää-á nawáywówápóe, i-á napeḏeejiwän, hewänbo nää-á âywáyshaa.’ ” ");
INSERT INTO tew_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus-di iví tꞌôeˀin gin wáˀ ovâytu̖ˀan, “Wí koḏitꞌowa sen wí tꞌôeˀiˀ ûnˀä́n, heḏi iˀ sendi hä̖ä̖wí ûnkwꞌóˀdi tꞌä̖hkí iˀ tꞌôeˀiˀ óeˀá̖yînjoeˀan. Heḏi wí toˀwíḏí iˀ sen óetu̖ˀan, ‘Hä̖ˀi tꞌôeˀiˀ úˀä́ndiḏá uví hä̖ä̖wí wônwänpipeḏeeˀoˀ.’ ");
INSERT INTO tew_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Heḏiho iˀ koḏitꞌowa sen iví tꞌôeˀiˀ itu̖hkánnandi óetu̖ˀan, ‘Háa biˀoˀin naa dînhanginpóe. Nátaˀnan hä̖́yú̖ chä̖ˀ in tꞌowavíˀweḏi nâahógiˀin heḏá hä̖́yú̖-á nâahá̖núˀindá. Nää iweḏi naví hä̖ä̖wí dînˀá̖yînmáaˀi wíyá wúˀmúunípí.’ ");
INSERT INTO tew_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iˀ tꞌôeˀi-á ginnân iˀánshaaˀan: ‘Naví tsondiḏá nää naví tꞌôe dínjâakankhâymáa. Hândá naa dáyˀa̖mí? Naa ihay wóˀkaypí nava tꞌôe dáyˀa̖míḏí, heḏá owôedaˀ ohä̖ä̖daˀyê̖e̖níḏí. ");
INSERT INTO tew_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nää-á dînhanginná háa dáyˀa̖míˀin, heḏânho owáy nä́ˀi tꞌôe dóˀoˀi dînjâaˀan dihayḏi hä̖ˀin tꞌowaḏi inbí kꞌaygi eeje dísígíˀa̖míḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Heḏiho wíˀín wíˀíngin in tꞌowa iví tsondi ûnphaamuuˀin ovâytu̖hkánnan, heḏi iˀ páaḏéˀi napówáˀiˀ óetsikaˀyan, ‘Hä̖́yú̖-an naví tsondi unphaamuu?’ ");
INSERT INTO tew_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iˀ sendi óetu̖ˀan, ‘Gá tä̖gintä̖ (100) kwä̖́ä̖bay olive ka̖ˀpꞌoe-ân.’ Iˀ tꞌôeˀiˀḏi óetu̖ˀan, ‘Nä́ä uví phahsan taˀnin. Ówä̖́näkiˀ, ósoge heḏi náˀegóˀan pꞌánä́ntä̖ (50) kwä̖́ä̖bay gin natú̖u̖níḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wíyá wêe sen napówáˀi-á óetu̖ˀan, ‘Heyâa u̖-á, hä̖́yú̖-á unphaamuu?’ Iˀ sen natú̖, ‘Wêe maapaasôn (1,000) múu táhtân.’ Iˀ tꞌôeˀiˀḏi iˀ sen óetu̖ˀan, ‘Nä́ä uví phahsan taˀnin. Náˀegóˀan khávén tä̖gintä̖ (800) gin natú̖u̖níḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Iˀ tꞌôeˀiví tsondi natú̖ nä́ˀi hójoˀi tꞌôeˀi híwóˀnin napꞌônbaymuu, gá híwó ipiˀá̖yîngiˀandân. Taˀgendi wâytu̖máa, in toˀwên Jôesi Táḏá dâytaapíˀin ívíwo dihá̖ in wéˀgen tꞌowa in waaginbá dimuuˀindáḏí híwó dívíkanhûuwíḏí heḏânho híwó dívípiˀá̖yîngiˀa̖míḏí, hebo Jôesi Táḏáví ây ûnmuuˀindá wáyjéḏí ihay wíḏihá̖hpí. ");
INSERT INTO tew_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Heḏiho unho naaḏi wâytu̖máa, tobá wáy wên tꞌowa híwóhpîˀḏi dâychä̖ˀhónde wänboˀ, undá únkhâyˀä̖ˀ tꞌowa bînkhä̖ˀgeˀnandi unbí chä̖ˀdibo bînkꞌemahóeníˀin, heḏânho owáy iˀ chä̖ˀ wíyá wínachä̖ˀmuupí ihayḏá, wí wháagé nahándepí iwe oe makówá wovâysígíhóení. ");
INSERT INTO tew_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wí toˀwí chä̖̂ä̖ḏa̖ˀ ônjoeˀandi híwó iˀá̖yîngikanhondi-á hä̖ä̖wí hehä̖́yú̖ˀi wáˀ híwó iˀá̖yîngikhâymáa, heḏi wí toˀwí chä̖̂ä̖ḏa̖ˀ ônjoeˀandi isä̖boˀi-á hä̖ä̖wí shánkí hehä̖́yú̖ˀi wáˀ isä̖ˀmamí. ");
INSERT INTO tew_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Heḏiho nä́ˀi chä̖ˀ nä́ä oepáa kꞌayḏiwi nawänpimuuˀi híwó wívînˀá̖yîngiˀanpíḏá, háˀto iˀ hä̖ä̖wí taˀgendi nachä̖ˀmuuˀiˀ unbí mange wovâyjoeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Heḏi híwó iˀ hä̖ä̖wí wíyá toˀwívîˀ únmuuˀi bînˀá̖yîngiˀanpíḏá, háˀto wovâymä̂äní iˀ hä̖ä̖wí wovâypä̖khâymáawän. ");
INSERT INTO tew_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Wí tꞌôeˀi-á wíˀûnkoḏipí wíje tsonningîˀ híwó itꞌôemáˀve-íḏí. Iˀ wêe óetꞌay-í heḏá óejoegiˀa̖mí, iˀ wêe-á óesígí-í heḏá óeˀaˀgeení. Chä̖ˀgîˀḏa̖ˀ úvítꞌôemáaḏáhoˀ wíˀúnkoḏipí Jôesi Táḏágîˀ-á wáˀ úvítꞌôeˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","In Pharisees nä́ˀi híˀ tꞌä̖hkí ditꞌoeˀo, heḏi indi Jesus tꞌä̖mäge óetu̖máa, gá indá dichä̖ˀha̖ˀtꞌaaḏân. ");
INSERT INTO tew_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Heḏiho Jesus-di ovâytu̖ˀan, “Undá ídaˀ tꞌowa diˀâ̖a̖níˀin unbí wówátsi taˀge bînhonnin, hewänbo Jôesi Táḏá-á ûnhanginná háa unbí píˀnä́ khóˀjé bînmáaˀin. Wáy wí hä̖ä̖wí in tꞌowa diˀánde shánkí híwóˀdi namuu, inbí ánshaa piháa dínmuuḏi, hebo Jôesi Táḏágîˀ-á nä́ˀi hä̖ä̖wí-á wíˀûnchä̖ˀmuupí. ");
INSERT INTO tew_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“John iˀ pꞌóˀpꞌoekandi napówá píhay iˀ tsontun Moses itaˀnandáḏí heḏá iˀ hä̖ä̖wí Jôesi Táḏáví tukheˀmin dâytaˀnandaḏí únkwꞌó wovâyhá̖ˀa̖míḏí. Hewänbo John napówá iweḏi iˀ híwóˀdi tun makówá i̖ˀgeḏi tꞌowa ovâytꞌôeˀoˀ, heḏi hânho báyékí tꞌowa iˀpiye dívíkhä̖ä̖ḏeˀ. ");
INSERT INTO tew_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Shánkí wínabâapuˀwanpí makówá-á nä́ˀi oepáa kꞌayḏá nahá̖a̖níḏí, in shánkí hínchä̖̂ä̖ˀin híˀay Jôesi Táḏáví taˀnin diwe nakꞌóeˀin nahá̖a̖nívíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Gá ginnân: Wí sen iví kwee ijoeˀandi wíyá kwee-áḏí ikhóˀyâ̖ˀḏá itꞌaywóˀdoˀ, heḏi wí sen wáˀ iˀ kwee óejoeˀandi-áḏí ikhóˀyâ̖ˀḏá itꞌaywóˀdoˀ.” ");
INSERT INTO tew_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Wí koḏitꞌowa sen saˀwó iˀawendeˀ aa báyékí nachä̖ˀmuuˀiˀḏi, heḏá thamu waagá hânho híwóˀdá ihúujoˀ. ");
INSERT INTO tew_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Iví tewháwin phóḏi wáy wí sen sehkanäwó nawówájiˀi naha̖a̖peˀkꞌóe, i-á Lazarus gin nakhá̖wä̖́. Nadaˀ iˀ koegîˀtä̖́ iˀ koḏitꞌowa senbí mä́äsa iweḏi najemuˀiˀḏi iha̖wówáˀa̖míˀin. Túˀ tꞌä̖hkí naphéemuuḏi in tséḏí iˀ phée ônhä̖ˀtꞌaaḏeˀ. ");
INSERT INTO tew_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nä́ˀi sen sehkanäwó nawówájiˀi-á nachuu heḏi in makówáwin tꞌôepa̖ˀa̖a̖ˀindi makówápiye óepiye, heḏi Abraham-bí hângebá óesóge. Iˀ koḏitꞌowa sen wáˀ nachuu, heḏi óekhä̖ˀkꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Iˀ koḏitꞌowa sendá oe péyégé naˀä́ndí itꞌôephaḏendeˀ, heḏi ibéeḏí kayi̖ˀ diwe Abraham naˀä́ndí óemûˀ heḏá Lazarus-á wáˀ Abraham-bí hângebá naˀä́n. ");
INSERT INTO tew_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Heḏi kaygi natú̖, ‘Táḏá Abraham, navíˀpiye ósehkanäpuwave. Lazarus nátu̖ˀan imankhú̖pꞌohtógikíḏí navíˀpiye naˀä̖ä̖-í, heḏi naví hän dînpꞌoeˀa̖mí dînˀoetꞌêepúuwíḏí. Naa nä́ä phaa iwe hânho dontꞌôephaḏendeˀ.’ ");
INSERT INTO tew_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hewänbo Abraham-di óetu̖ˀan, ‘Naví ay, ti wíˀúˀánshaapíˀan waˀ unwówájiˀ ihayḏi hânho híwóˀdi hä̖ä̖wí úkwꞌóˀnin, hewänbo Lazarus-á híwóhpîˀ-á ûnkwꞌó. Hewänbo nää-á nä́we híwó iphaḏendeˀ, heḏi u̖-á mäntꞌôephaḏendeˀ. ");
INSERT INTO tew_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Heḏá wáˀ wên heˀyin kôndá hä̖ä̖ pinuḏi nakꞌóe, in toˀwên nä́we dikwꞌóˀnin wíḏínkoḏipíḏí nä́näḏi hä̖näpiye diphaaḏé-íḏí, tobá didaˀ wänboˀ, heḏá wáˀ wínakoḏipí hä̖näḏi nä́näpiye diphaaḏé-íḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Iˀ koḏitꞌowa sen natú̖, ‘Heḏá nää kayˀindi wídaˀmáa táḏá Abraham, Lazarus nâasaaní naví táḏáví tewhá iwepiye. ");
INSERT INTO tew_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pꞌánú tíˀûuwin naa dînkwꞌó, heḏi Lazarus-di ovâytu̖ˀâ̖a̖mí naa dáyˀan waagi wíḏívíˀa̖mípí, heḏânho nä́we naa dontꞌôephaḏendeˀ iwebá wíḏipóewípíḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Hewänbo Abraham-di óetu̖ˀan, ‘Moses itaˀnannindáḏí in Jôesi Táḏáví tukheˀmin dâytaˀnannindáḏí dínkwꞌó. Háa hä̖ˀin dâytaˀnan waa uví tíˀûuwin dínkhâyˀä̖ˀ dâyˀaˀginnamíˀin.’ ");
INSERT INTO tew_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Iˀ koḏitꞌowa sen natú̖, ‘Joe, Táḏá Abraham, háˀto han dívíˀa̖mí. Hewänbo wí toˀwí dichuˀkwꞌóˀ diweḏi inbíˀpiye namääḏáhoˀ, indá dívíwä̖yu̖ḏi inbí tꞌaywóˀdi dâyjoeˀa̖mí.’ ");
INSERT INTO tew_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham-di óetu̖ˀan, ‘Moses-áḏí in Jôesi Táḏáví tukheˀmindáḏí ovâytꞌôeyanpíḏá, háˀto toˀwíḏí wänbo ovâywä̖yu̖kannamí, tobá chuwa iweḏi nawáywówápóe wänboˀ.’ ” ");
INSERT INTO tew_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus iví khä̖geˀnin itu̖ˀan, “Taˀgendi tobá hä̖̂ä̖ḏi nanân wänbo hä̖ä̖wíḏí wänbo-á in tꞌowa tꞌaywóˀ diwe ovâytóeˀó, hewänbo toˀwí nä́ˀi tꞌaywóhkan ovâykeejoˀiˀ tꞌôephaḏe ûnpuwagíˀo. ");
INSERT INTO tew_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wí toˀwí gin ovâykeejoˀi-á shánkí híwó ûnpúuwí wí kꞌuu kháaˀiˀ iví kꞌáy eeḏi ônwhisógedi mâapꞌoe iwe óechä̖ä̖nú-íḏí, wêe wänbo nä́ˀin hí̖ˀínnin diweḏi óetꞌaywóhá̖ˀa̖mívíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Úvíˀá̖yîngiˀa̖mí háa úvíˀo waagi. Unbí kꞌema itꞌaywóˀnandáho kaygindi bînkhâ̖a̖ˀa̖mí wíyá wíˀitꞌaywóˀnamípíḏí. Hewänbo iví tꞌaywóˀdigîˀ naˀowójédaˀpóeḏá bînˀowóejé-í. ");
INSERT INTO tew_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tobáháa uvíˀpiye tségín wí thaa itꞌaywóˀnan wänboˀ, tségín naˀowójédaˀä̖ä̖ḏi mânˀowóejé-í.” ");
INSERT INTO tew_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesus-ví tꞌôekhuwaˀindi óetu̖ˀan, “Díkhä̖geˀnan heḏânho wíyá shánkí uvíˀpiye ívíwä̖ä̖yú̖-íḏí.” ");
INSERT INTO tew_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesus-di ovâytu̖ˀan, “Unbí wä̖yu̖-á wí hânho hínchä̖̂ä̖ˀi tânˀayví hayˀiḏa̖ˀ únmúuní wänboˀ, únkoeḏí-í nä́ˀin tay hayˀin nä́we nacháˀnin bîntu̖ˀa̖míḏí, ‘Púu iweḏi ópúwhahkeˀḏi oe pꞌoekwíngé ókhä̖htoˀ,’ heḏi háa ítú̖ waagi iˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Wí toˀwí wí pantꞌôeˀiˀ ûnˀä́ndí iwhä̖ä̖ḏeḏi háa ônkꞌúwáˀá̖yînmáaḏí, nava iweḏi iweetsꞌúḏeḏi, ti óetu̖ˀa̖mí, ‘Ósogeḏi wese óhú̖u̖yan’ gin? Heḏân joe. ");
INSERT INTO tew_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Haˀwâa óetu̖ˀa̖mívíˀweḏi ginnân óetu̖ˀâ̖a̖mí: ‘Dînhúukhâyˀan, heḏá uví aa óˀegóˀandá díˀá̖yîngiˀan naa dáyhúubowa píhay, ihayḏânho bitsꞌanhú̖u̖ya̖mí u̖ˀ.’ ");
INSERT INTO tew_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Heḏi iˀ pantꞌôeˀi háa óejôn waa iˀan dihayḏi, ti óekú̖ˀdaaˀoˀ? Heḏân joe, i-á panda̖ˀ namuu. ");
INSERT INTO tew_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ungîˀ wáˀ hanwaagibá namuu. Iˀ hä̖ä̖wí wovâyjôndi bînbowa ihayḏá ítú̖u̖ní, ‘Wíḏíkú̖ˀdaaˀâ̖a̖mípí. Háa gínkhâyˀä̖ˀ waagiḏa̖ˀmân ívítsiyeˀan.’ ” ");
INSERT INTO tew_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus oe Jerusalem-piye namän, heḏi Samaria-áḏí Galilee-áḏí inbí nantaa kíngé namän. ");
INSERT INTO tew_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wí búˀ tsowa napowamän dihayḏi tä̖ senäˀ diphéetaymuuˀindi óemûˀ, heḏi ivíˀweḏi kayi̖ˀ diwebo dívíwóyí̖ˀ, ");
INSERT INTO tew_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","heḏi Jesus kaygi óetu̖ˀan, “Jesus, há̖hkandiˀ, naˀinbíˀpiye ósehkanäpuwave.” ");
INSERT INTO tew_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus-di ovâymûˀḏi ovâytu̖ˀan, “Jaˀ bípûn iˀ méesate ipiye in owhaˀḏi wovâymúuníḏí íwówaˀin.” Heḏiho iweḏi dimää, heḏi waˀ pꞌóegé dimändibo diwówa. ");
INSERT INTO tew_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Heḏi in senäˀ diwówaˀin diweḏi wêe iwáybun Jesus óekú̖ˀdaaˀa̖míḏí nawówaḏi, heḏi kaygi ihíˀmáaḏí Jôesi Táḏá-á kwꞌáayéboˀ óemáa. ");
INSERT INTO tew_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesus-ví ân núˀ idégeˀdisógeḏi ipꞌóˀtꞌä̖́ä̖ḏí óekú̖ˀdaaˀan. Nä́ˀi sendá Samaria-wi namuu. ");
INSERT INTO tew_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus-di óetsikaˀyan, “Ti tä̖ ihay wíˀíwówapíˀan? Wáyho in wéˀgen whä̖nu? ");
INSERT INTO tew_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nä́ˀi piˀwí nangewi senda̖ˀmân ibun Jôesi Táḏá óekú̖ˀdaaˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Heḏáháˀ iˀ sen óetu̖ˀan, “Ówí̖núḏí ópûn, uví wä̖yu̖ úmuuḏiho unwówa.” ");
INSERT INTO tew_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wên Pharisees-di Jesus óetsikaˀyan, “Hä̖̂ä̖ḏan Jôesi Táaḏí tꞌowa ovâytsonkhâymáa?” Jesus-di ovâytu̖ˀan, “Iˀ hä̖ä̖wí bînmúndeˀiˀḏiḏa̖ˀ háˀto únhanginpúuwí Jôesi Táḏáḏí tꞌowa ovaytsonmáaˀin. ");
INSERT INTO tew_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Heḏi toˀwí wänbo wíˀûnkhâyˀä̖hpí natú̖u̖níˀin oweḏaˀ háa wíyá wáygéḏa̖ˀ Jôesi Táḏáḏí tꞌowa ovâytsonmáaˀin, gá unbí jâa iwebo tꞌowa ovâytsonmáaḏân.” ");
INSERT INTO tew_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ihayḏáháˀ iví khä̖geˀnin itu̖ˀan, “Owáy wí thaa naˀnáˀ dihayḏi un hânho ídaˀí dímúuníˀin naa, tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀi wí hây tä̖hkí wänbo otsonjiḏi, hewänbo ihayḏi háˀto únkoeḏí-í. ");
INSERT INTO tew_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tꞌowaḏi naví̖ˀgeḏi wovâytu̖ˀa̖mí, ‘Hä̖we hîn najiˀ,’ háa ‘Nä́we hîn najiˀ.’ Hewänbo indáḏí wíˀímú-ípí. ");
INSERT INTO tew_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Owáy naví thaa owáyˀä̖ä̖-íḏí dînpówá ihayḏi, tsígówä̖́nú hä̖ä̖ makówá nä́weḏá onähay namuwä̖poeˀo waagibá naa opóewí. ");
INSERT INTO tew_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Hewänbo owáypówápíḏíbo páaḏé báyékí dontꞌôephaḏekhâymáa, heḏá in tꞌowa nää diwówájiˀindá díjoegikhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Heḏi naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀiˀ owáyˀä̖ä̖ ihayḏibá tꞌowa dívíˀâ̖a̖mí háa hä́nˀoˀa̖mí, ‘Hä̖we hîn najiˀ,’ háa ‘Nä́we hîn najiˀ.’ Hewänboe in tꞌowa dívíˀo waagibá Noah nawówájiˀ ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iˀ thaa Noah iˀ kophé hayˀi ipaa-íḏí ikhâyˀan diweḏi iˀ wêe thaa ibowaḏi itógi píhay, in tꞌowa húukandáḏí su̖wä̖-áḏí dívíwänpiˀo heḏá dívíkhóˀyándeˀ. Ihayhä̖̂ä̖bá iˀ kwa̖ˀpꞌoe napówáḏí tꞌä̖hkí in wéˀgen tꞌowa ovâypꞌotꞌahá̖nú. ");
INSERT INTO tew_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Heḏi hanwaagibá napóe Lot nawówájiˀ ihayḏi. Tꞌowa dívíwänpihúujoˀ, dâysu̖wändeˀ, dâyhä̖ä̖wíkumändeˀ heḏá dâyhä̖ä̖wíku̖ˀchꞌáaḏeˀ, dâykoˀ, heḏá dâytewhákwꞌóeˀó. ");
INSERT INTO tew_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hewänbo iˀ thaa Lot iˀ búˀ Sodom diweḏi napee ihayḏá wí phaa makówáḏí najemu, heḏá kꞌuu nakojeˀdi-á wáˀ kwan waagibá najemu, heḏi tꞌä̖hkí tꞌowa ovâyhá̖nú. ");
INSERT INTO tew_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Haˀwâagibá dívíkanhûuwí owáy iˀ thaa naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀiˀ owáykeepóe ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ihay thaa-á wí toˀwí whaˀkꞌayḏi najiḏi nawândi wíˀûnkhâyˀä̖hpí iví tewhá ee natsꞌú̖u̖níˀin iví hä̖ä̖wí ee ûnkwꞌóˀdiˀ ihóeníḏí. Heḏi wí toˀwí nava iwe najiˀi-á wíˀûnkhâyˀä̖hpí iví tewhá iwepiye ibuuníḏí. ");
INSERT INTO tew_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Wíˀúnˀôeḏe-ípí háa Lot-ví kwee ûnpóeˀin Sodom búˀpiye iwáybuuníḏí ibée ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wí toˀwí iví wówátsi iˀgîˀḏa̖ˀ nadaˀḏi, iví wówátsibá iwänpipeḏeeˀa̖mí. Hewänbo wí toˀwí iví wówátsi in wéˀgengîˀ imä́giˀi-á iví wówátsibá iˀaywondeˀ. ");
INSERT INTO tew_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Wâytu̖ˀa̖mí, owáy iˀ thaa naa owáyˀä̖ä̖-íḏí napówá ihayḏá wíje senäˀ wí íve dajóˀkꞌóeˀin diweḏi Jôesi Táḏáḏí wêe óekekhâymáa, iˀ wêe-á iwebo-á óejoekankhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wíje kwiyä̖ˀ dä̂nˀoˀtꞌaˀin diweḏi wêe óekekhâymáa, iˀ wêe-á iwebo-á óejoekankhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wíje senäˀdá nava iwá dajiˀin diweḏi wêe óekekhâymáa, iˀ wêe-á iwebo-á óejoekankhâymáa” gin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iví khä̖geˀnindi óetsikaˀyan, “Nanbí Sedó, wáygan nä́ˀi napuwagíˀo?” Jesus-di ovâytu̖ˀan, “Wáygé iˀ pení nakꞌóe iwânho in oeka̖wä̖ dívíwéˀgekhâymáa.” ");
INSERT INTO tew_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus-di wên há̖hkangíˀin óˀgéḏí ovaytu̖ˀan ovâyhá̖ˀa̖míḏí dínkhâyˀä̖ˀ hä̖̂ä̖ḏi wänbo tꞌä̖hkí dívíjûusuˀâ̖a̖míˀin heḏi wíḏívíjûusuwóyí̖ˀnípí. ");
INSERT INTO tew_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ginnân ovâytu̖ˀan: “Wí sen tson diwe naˀä́ndiˀ wí búˀ iwe nathaa, hewänbo Jôesi Táḏá wíˀóeˀaˀginmähpí, in tꞌowa wänbo-á wíˀovâyˀaˀginpí. ");
INSERT INTO tew_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Iwáy búˀ iwáygébá wí kwee iví sen ûnchuuˀi nathaa, heḏi ihayḏa̖ˀ nä́ˀi tsondivíˀpiye nakhä̖geˀdaˀmääˀäḏi óetu̖ˀoˀ, ‘Díkhä̖geˀnan heḏânho iˀ toˀwí naa díhä̖ä̖wíkweeḏeˀi wíḏítꞌaanípíḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Thamuwaagi iˀ tsondivíˀwepiye nakhä̖geˀdaˀmääˀä̖, hewänbo wíˀôntꞌôeyandepí. Tꞌôeḏiwän iˀ sen natú̖, ‘Tobáháa Jôesi Táḏá dóˀaˀginmähpí wänboˀ, heḏá tꞌowa wáˀ dovâyˀaˀginpí wänboˀ, nä́ˀi kwee dókhä̖geˀnamí, gá dókhä̖geˀnanpíḏá ihayḏa̖ˀ naˀä̖ä̖ˀä̖ḏi naa báyékí díkayhá̖a̖nú-íḏân.’ ” ");
INSERT INTO tew_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ihayḏi Jesus-di ovâytu̖ˀan, “Ítꞌoe háa nä́ˀi híwóhpîˀ tsondi natú̖ˀin. Tobá híwóhpí namuu wänbo iˀ kwee óekhä̖geˀnan. ");
INSERT INTO tew_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Hewänbo Jôesi Táaḏí shánkí wänbo in toˀwên ûndeˀmuuˀin ovâykhä̖geˀnamípíˀan, khu̖u̖-á thaa-á pín taˀgeḏi ivíˀpiye dívíjûusuˀoḏi. Ti thaa tꞌä̖hkí iˀḏi ovâytsíkhakannamí? Joe, háˀtoˀ. ");
INSERT INTO tew_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Naaḏi wâytu̖máa, iˀḏá wesebo ovâykhä̖geˀnamí. Hewänbo owáy naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀi omuuˀi nä́ä oepáa kꞌayḏipiye owáyˀä̖ä̖ ihayḏá, ti tꞌowa dovâyshaa-í waˀ navíˀpiye dívíwä̖yundeˀin?” ");
INSERT INTO tew_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wên tꞌowa diˀándeˀ inbí wówátsi taˀge dâyhonnin heḏiho wéˀgen tꞌowaví shánkí híwóˀnin dimuu. Heḏiho Jesus-di nä́ˀin há̖hkangíˀin óˀgéḏí ovâytu̖ˀan: ");
INSERT INTO tew_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wíje senäˀ iˀ méesate hayˀi ee datsꞌú̖ dänjûusuˀa̖míḏí, wí wêe sen Pharisee namuu, heḏá iˀ wêe-á tax phahsandi-á. ");
INSERT INTO tew_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Iˀ Pharisee wíˀbo nawindi ginnân ijûusuˀan: ‘Jôesi Táa, naaḏi wíkú̖ˀdaaˀoˀ naa tꞌaywóhkandiˀ wóˀmuupíḏí wáy wên tꞌowa dimuu waagibá. Indá dihójo, heḏá sänmindá dimuu, inbí wówátsi-á taˀgeˀindá wíḏínmuupí, heḏá piˀwênbí kwiyä̖ˀdáḏá dívíwhohkwomáa. Heḏá wíkú̖ˀdaaˀo wáˀ hä̖ˀi tax phahsandiˀ owe nawindi waagiˀbá wänbo wóˀmuupíˀin. ");
INSERT INTO tew_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jâaḏi waa wáygín dáyha̖a̖ḏä́ˀoˀ, heḏá tꞌä̖hkí tä̖ hä̖ä̖wí dontꞌan diweḏá wêe-á wímäˀ.’ ");
INSERT INTO tew_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hewänbo iˀ tax phahsandi-á hây kayi̖ˀ diwe wíˀbo nawindi nawôedaˀ makówápiye ibée-íḏí. Ipí̖hkhú̖mahpúuḏe nataachanpóeḏí itꞌaywóˀnandi, heḏi natú̖, ‘Jôesi Táa, navíˀpiye ósehkanäpuwave. Naa wí tꞌaywóhkandiḏa̖ˀmân omuu.’ ");
INSERT INTO tew_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Heḏi wíˀgín dänweehoˀ. Naaḏi wâytu̖ˀa̖mí, Jôesi Táḏáḏí nä́ˀi tax phahsandiví tꞌaywóˀdi ônˀowójé, iˀ Pharisee-vîˀ-á joe. Toˀwên tꞌä̖hkí heˀennin dívípipaˀindáho hí̖ˀínninda̖ˀbá ovâypaˀí, heḏá toˀwên hí̖ˀínnin dívípipaˀindáho heˀennindá ovâypaˀí.” ");
INSERT INTO tew_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wên tꞌowa inbí hí̖ˀínnin áyyä̖̂ä̖ Jesus-víˀwe dâykán iˀḏi ovâytä̖ä̖gé-íḏí. Iví khä̖geˀnindi gin dâymûˀḏi in tꞌowa-á ovâytꞌeˀyandi ovâytu̖ˀan haˀwâa wíḏívíˀa̖mípí. ");
INSERT INTO tew_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hebo Jesus-di in táḏáˀin jíyáˀin ovâytu̖ˀan inbí áyyä̖̂ä̖ iví núˀpiye dâymáˀí, heḏi iví khä̖geˀnin itu̖ˀan, “In áyyä̖̂ä̖ navíˀpiye binkä̖ˀä̖ä̖mä́ä, wívînkhâ̖a̖ˀa̖mípí. Toˀwên nä́ˀin áyyä̖̂ä̖ waaginbá dimuuˀindá Jôesi Táḏávíˀin ûnmuu. ");
INSERT INTO tew_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Taˀgendi wâytu̖máa, toˀwí Jôesi Táḏávîˀ wínapúuwípí wí hínchä̖̂ä̖ˀiˀ ay waagibá iwä̖yu̖píḏí.” ");
INSERT INTO tew_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wí kwꞌáyewi sen namuuˀiˀḏi Jesus óetsikaˀyan, “Híwóˀdi há̖hkandiˀ, hân dáyˀa̖mí heḏânho in wówátsi nahándepíˀin donkáyjíḏí?” ");
INSERT INTO tew_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus-di óetsikaˀyan, “Ti úhanginná háa untû̖ˀnin naa híwóˀdi gin dítu̖ˀoḏi? Jôesiḏa̖ˀmân híwóˀdi namuu, wíyá toˀwí-á joe. ");
INSERT INTO tew_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jôesi Táḏáví tsontun ho mântaa. I-á natú̖ wíyá toˀwíví kwee-áḏí háa sendáḏí wíˀúvíwhohkwomáˀve-ípí, wívîntꞌowatꞌahá̖a̖nú-ípí, wíˀúvísä̖ˀmamípí, tꞌowaví̖ˀgeḏi wíˀúvíhójoˀa̖mípí, unbí táḏá-á jíyá-á bînˀaˀginmáˀve-í.” ");
INSERT INTO tew_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iˀ sendi Jesus óetu̖ˀan, “Nä́ˀi tsontun tꞌä̖hkí dóˀaˀgin enúkáy omuuḏiboˀ.” ");
INSERT INTO tew_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesus nä́ˀin natꞌoe ihayḏá iˀ sen óetu̖ˀan, “Waˀḏi wây-á háawên biˀa̖míˀin útáy. Hä̖́yú̖ úkwꞌóˀdi tꞌä̖hkí mänku̖ˀchꞌâaní, heḏi iˀ chä̖ˀ mänhógiˀiˀ in tꞌowa sehkanäwó diwówájiˀin ovâymä̂äní, heḏânho koḏitꞌowa unmúuní oe makówá. Heḏi nâaku̖ˀchꞌáaḏá ovâymä́giḏá naa-áḏí ókä̖ˀve.” ");
INSERT INTO tew_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nä́ˀin natꞌoe ihayḏi iˀ sen iví píˀnä́ khóˀjé báyékí nataachanpóe, gá báyékí hä̖ä̖wí ûnkwꞌôndân, heḏi wínaku̖chadaˀpí. ");
INSERT INTO tew_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus-di iˀ sen háa nacha̖a̖ waagi óemúndeḏi natú̖, “Báyékí kâyˀin namuu wí toˀwí nakoḏitꞌowamuuˀi háa Jôesi Táḏá natú̖ waa iˀa̖míḏí heḏânho ônˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nabâapuˀwan wí kamä́yo wên agúusa tsípho i̖ˀge natsꞌú̖u̖níḏí, hewänbo shánkí nabâapuˀwan wí toˀwí koḏitꞌowa namuuˀi háa Jôesi Táḏá natú̖ waa iˀa̖míḏí heḏânho ônˀaywoeníḏí.” ");
INSERT INTO tew_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","In toˀwên nä́ˀi híˀ ditꞌoeˀindá ditsikapóe, “Gin namuuḏá to-an ûnkoḏi ûnˀaywondee-íḏí?” ");
INSERT INTO tew_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Heḏi Jesus-di ovâytu̖ˀan, “Háa tꞌowa dínkoḏipíˀindá Jôesi Táḏá-áho ûnkoḏi.” ");
INSERT INTO tew_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter-di Jesus óetu̖ˀan, “Naˀindá hä̖ä̖wí tꞌä̖hkí gínkwꞌóˀdiˀ âyjoeˀan u̖-áḏí gimú-íḏí.” ");
INSERT INTO tew_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus-di ovâytu̖ˀan, “Naaḏi taˀgendi wâytu̖máa, háa Jôesi Táḏá natú̖ waa ônˀaˀginnamíḏí wí toˀwí iví tewhá ijoeˀandi, háa iví kwee, háa iví tíˀûuwindá páˀḏâyˀindá, iví jíyá-á táḏá-á, háa iví ây-á ijoeˀandá, ");
INSERT INTO tew_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","i-á taˀgendi báyékí shánkí maˀkwꞌanukí ihóení waˀ nä́ä oepáa kꞌayḏi najiˀ ihayḏi, heḏá iví wówátsi nä́ä oepáa kꞌayḏi ûnboˀwan diˀan, “Naˀindá hä̖ä̖wí tꞌä̖hayḏá in wówátsi nahándepíˀindá imáˀve-í.” ");
INSERT INTO tew_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus iví tä̖ˀḏi wíje khä̖geˀnin wéhánäpiye ihoˀ, heḏi ovâytu̖ˀan, “Bítꞌôeyan, nää-á Jerusalem-piye gimän, heḏi eewá naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi dînpúuwí háa in Jôesi Táḏáví tukheˀmin naví̖ˀgeḏi dâytaˀnan waa. ");
INSERT INTO tew_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tꞌowaḏi in Huḏíyo dimuupíˀinbí mange díkáaní, heḏá indá dînpꞌáhkaakhâymáa, heḏá díjänäkíkhâymáa, heḏá díˀohphaykhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Púwhí̖ˀdí díwhä̖ḏikhâymáa, heḏá díkheˀkhâymáa. Hewänbo iweḏi iˀ powageˀi thaa iwe owáywówápúuwí.” ");
INSERT INTO tew_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hewänbo Jesus-ví khä̖geˀnin nä́ˀi natú̖ˀi hä̖́ä̖bo wíḏikaˀpówápí. Háa ovâytu̖ˀandi-á wíḏínthaypóepí, heḏiho hä̖ä̖wí i̖ˀgeḏi ihíˀmáaˀin wíḏikaˀpówápí. ");
INSERT INTO tew_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericho búˀ tsowa Jesus napowamän dihayhä̖̂ä̖, wí sen tsíˀtꞌaaˀi namuuˀiˀ owáy pꞌôe hángé wáy nahä̖ä̖daˀä́n. ");
INSERT INTO tew_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Iˀ sen in báyékí tꞌowa diphaḏemännin natꞌoe, heḏi natsikapóe, “Hân napoeˀo?” ");
INSERT INTO tew_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Indi óetu̖ˀan, “Jesus Nazareth-wi-ân naˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Heḏi iˀ sen itu̖wí̖nú, “Jesus, u̖ David-ví ây iweḏiˀiˀ unmuuˀiˀ, navíˀpiye ósehkanäpuwave.” ");
INSERT INTO tew_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","In ton Jesus-ví páaḏé dimännindá iˀ sen óetꞌeˀyandi óetu̖ˀan, “Hânda̖ˀdiboˀ.” Hewänbo iˀ sendá shánkí kaygá itu̖wí̖nú, “U̖ David-ví ây iweḏiˀiˀ unmuuˀiˀ, navíˀpiye ósehkanäpuwave.” ");
INSERT INTO tew_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus iwóyí̖ˀ, heḏi ovâytu̖ˀan iˀ sen ivíˀpiye óemáˀíˀin, heḏi Jesus-víˀwe napówá ihayḏi Jesus-di óetsikaˀyan, ");
INSERT INTO tew_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Hânnan wînˀa̖míˀinnan undaˀ?” Iˀ sendi óetu̖ˀan, “Nanbí Sedó, naa odaˀ dînkeepúuwíˀin.” ");
INSERT INTO tew_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus-di óetu̖ˀan, “Uví keetan mänkeˀ. Uví wä̖yu̖ úmuuḏân unwówa.” ");
INSERT INTO tew_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wesebo iˀ sen ûnkeepóe, heḏi Jesus-áḏí namändi Jôesi Táḏá kwꞌáayéboˀ óemáa. Heḏi tꞌä̖hkí in tꞌowa dâymûˀin ditû̖ˀ Jôesi Táḏá-á hayˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus oe Jericho búˀpiye namää, heḏi i̖ˀge naphaḏemän dihayḏi ");
INSERT INTO tew_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","wí sen Zaccheus gin nakhá̖wä̖́ˀiˀ iwáygé naˀä́n. I-á in tax phahsanninbí pꞌóˀḏéḏîˀ-ân namuu, heḏá koḏitꞌowa-á namuu. ");
INSERT INTO tew_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zaccheus-á ikhä̖ä̖ḏeˀ Jesus óemúuníḏí ûnhanginpúuwíḏí toˀwí namuuˀin, hewänbo hínchä̖̂ä̖ˀiḏa̖ˀ Zaccheus namuu heḏá báyékí ditꞌowajiˀ, heḏiho wíˀûnkeetꞌóepí. ");
INSERT INTO tew_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Heḏiho in tꞌowaví páaḏé iˀä̖ä̖ḏi wên sycamore tay ee nacháˀnin kwꞌáye ituye, heḏânho Jesus naphaḏemändi óemúuníḏí. ");
INSERT INTO tew_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesus in tay iwe napówáḏí kwꞌáye ibéeḏí Zaccheus óetu̖ˀan, “Zaccheus, ówä̖́näkiḏi ówhanbe, nää thaa uví kꞌaygi dáywóyí̖ˀkhâymáa.” ");
INSERT INTO tew_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaccheus tay kwꞌáyeḏi iwä̖́näwá̖ve, heḏi híhchangiḏi Jesus iví kꞌaygipiye óehoˀ. ");
INSERT INTO tew_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","In tꞌowa nä́ˀin dâymûˀ ihayḏá tꞌayḏi ditû̖ˀ, “Nä́ˀi sendá wí tꞌaywóhkandiví tewhá iwepiye naˀáḏâamää.” ");
INSERT INTO tew_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hewänbo Zaccheus iwí̖núḏí Nanbí Sedó Jesus óetu̖ˀan, “Nanbí Sedó, iˀ hä̖ä̖wí naa dînkwꞌóˀ diweḏi píngé hay dówijekhâymáaḏáháˀ in sehkanäwó diwówájiˀin tꞌowa dovâypä̖khâymáa, heḏi wí toˀwí dósä̖ˀmandi-á jónä́n maˀkwꞌanukí dópä̖khâymáa.” ");
INSERT INTO tew_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus natú̖, “Nää thaa nä́ä kꞌaygiwiˀ ônˀaywon. Nä́ˀi sendá wáˀ Abraham-bí ây iweḏiˀiˀbá namuu. ");
INSERT INTO tew_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀiˀ oˀä̖ä̖ in dipeḏeejiˀin dovâynuuwä̖́-íḏí heḏá dovâyˀaywoeníḏí.” ");
INSERT INTO tew_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nää-á Jerusalem tsowa dipowamändi in tꞌowa diˀánde wesebo natsondisogeḏee-íˀin, heḏiho Jesus-di wây-á há̖hkangíˀin óˀgéḏí ovâytu̖ˀan ovâythayya̖míḏí han wínapúuwípíˀin. ");
INSERT INTO tew_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ginnân ovâytu̖ˀan: “Wí sen kwꞌáyewi namuuˀiˀ ipikhâyˀowän wí nange kayi̖ˀ wä̖́hä̖̂ä̖ iwepiye namú-íḏí. Iwe iˀ tsondi shánkí pꞌóˀḏéḏîˀḏi nä́ˀi sen óetsondipakhâymáa heḏânho iví nangepiyebá nawáymú-íḏí natsonsogeḏee-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hewänbo waˀ iˀ wêe nangepiye namääpíḏíbo tä̖ ihay iví tꞌôeˀin itu̖hkánnandi wíˀínbo wí chä̖ˀ ovâyˀan, heḏi ovâytu̖ˀan, ‘Nä́ˀi chä̖ˀdi wí hä̖ä̖wí bînkuumä́-í, heḏáháˀ i-á bînku̖ˀchꞌâaní, heḏânho wíyá shánkí chä̖ˀ dîntꞌaaníḏí.’ Heḏáháˀ namää. ");
INSERT INTO tew_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hewänbo in tꞌowa iví nangeˀindá nä́ˀi sen óetꞌay, heḏi wên tꞌôekhuwaˀin iˀ namää iwepiye dâysan, iˀ tsondi pꞌóˀḏéḏîˀ óetu̖ˀa̖míḏí, ‘Nä́ˀi sendá wígidaˀpí nanbí tsondi gínmúuníˀin.’ ");
INSERT INTO tew_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Hewänbo óetsondisóge, heḏáháˀ iví nangepiyebá nawáymää. Heḏi iví tꞌôeˀin itu̖hkánnan, in ton ovâychä̖ˀannin, heḏânho imúuníḏí hä̖́yú̖ ônchä̖ˀtꞌannin. ");
INSERT INTO tew_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wí napówáḏí óetu̖ˀan, ‘Naví tsondiˀ, naa tä̖gin maˀkwꞌanukí chä̖ˀ dótꞌan u̖ˀḏi dînˀan diweḏi.’ ");
INSERT INTO tew_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Iˀ tꞌôeˀi óetu̖ˀan, ‘Híwó biˀan, u̖-á híwóˀdi tꞌôeˀi unmuu. Naa dînhanginná u̖-á háa úkhâyˀä̖ˀ waa biˀan hínchä̖̂ä̖ hä̖ä̖wíḏíboˀ. Heḏiho nää-á tä̖ búˀ eeje ovâytsonmáˀve-íḏí wísôege-í.’ ");
INSERT INTO tew_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wíyá wêe tꞌôeˀi natsꞌú̖ˀdi-á natú̖, ‘Naví tsondiˀ, iˀ chä̖ˀ naa dînˀan diweḏi pꞌánú maˀkwꞌanukí chä̖ˀ dótꞌan.’ ");
INSERT INTO tew_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Iˀ tsondiḏi óetu̖ˀan, ‘U̖-á pꞌánú búˀ eeje wí tsondi wísôege-í.’ ");
INSERT INTO tew_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ihayḏá wíyá tꞌôeˀi-á natsꞌú̖, heḏi natú̖, ‘Naví tsondiˀ, uví chä̖ˀ dînˀandi-á wên aa iwe dóˀánnan. Námúˀḏí, nä́we dómáa. ");
INSERT INTO tew_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Wíkhunwôedaˀ, jänäkîˀ unmuuḏi. U̖-á hä̖ä̖wí uvîˀ úmuupîˀ nâahóndeˀ, heḏi wáy piˀwên tꞌowa dâykoe iwe nâahä̖ä̖wéˀgeˀoˀ.’ ");
INSERT INTO tew_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Iˀ tsondiḏi óetu̖ˀan, ‘U̖-á wí tꞌôeˀi háagîˀ wänbo unchä̖ˀmuupîˀ unmuu. Nää-á háa naví̖ˀgeḏi untú̖ waagi omúuní, heḏi wítuhchä̖nukhâymáa. Unchanpoeˀo naa jänäkîˀ sen omuuˀin, heḏân hä̖ä̖wí dînmuupîˀ dóhóndeˀ. ");
INSERT INTO tew_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Háaḏan handi hä̖ˀi chä̖ˀ wínâahoˀpí wä̖́hä̖̂ä̖ dívíchä̖ˀpíyémäˀ iwepiye? Haˀwâa biˀandáho indá naví chä̖ˀ dînpíyémä̂äníwän, heḏi iweḏiho wíyá shankí dîntꞌaaníwän, heḏiho owáyˀä̖ä̖ ihayḏá shánkí báyékí dînchä̖ˀkwoníwän.’ ");
INSERT INTO tew_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Heḏáháˀ iˀ tsondiḏi in iwáygé diwinnindá ovâytu̖ˀan, ‘Iˀ chä̖ˀ bînkwee-í nä́ˀi sen, heḏi iˀ sen iˀ tä̖gin maˀkwꞌanukí chä̖ˀ itꞌandi bînmä̂äní.’ ");
INSERT INTO tew_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Hebo indi iˀ tsondi óetu̖ˀan, ‘Nanbí tsondiˀ, i-áho tä̖ ihay chä̖ˀ ho imáa.’ ");
INSERT INTO tew_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Iˀḏá ovâytu̖ˀan, ‘Naaḏi wâytu̖máa, wí toˀwí anbo toˀwí báyékí imáapîˀ-á, iˀ hínchä̖̂ä̖ imáaˀi wänbo óekwee-í. ");
INSERT INTO tew_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Heḏi nää nä́we binmáˀ in tꞌowa naa dítꞌayḏi inbí tsondi omúuníˀin wíḏidaˀpíˀin, heḏi nä́ä naví páaḏépiyebo bintꞌahá̖a̖nú-í.’ ” ");
INSERT INTO tew_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesus ihíˀbowa ihayḏi oe Jerusalem shánkí tsowapiye ihon. ");
INSERT INTO tew_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iˀ okú “Olive Okú” gin dâytu̖ˀoˀ iwe núˀ wáy nä́ˀin wíje búˀây daná, Bethpage-áḏí Bethany-áḏí. Iwáy tsowa wáy napowamän dihayhä̖̂ä̖ wíje iví khä̖geˀnin ovä̂nsan dapáaḏémú-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ovä̂ntu̖ˀan, “Jaho bápûn hä̖ˀi búˀay nanbí páaḏépiye nanân diwepiye, heḏi datsꞌú̖ˀ dihayḏá wí búduˀay tsꞌa̖a̖bi namuuˀi nawhiwindi dä̂nshaa-í, i-á waˀ wáymûu wänbo toˀwí wänbo wíˀiˀíhsógepí. Dä̂nwhihsuuḏi nä́we dä̂nmáˀí. ");
INSERT INTO tew_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Heḏi toˀwíḏí wovä̂ntsikaˀyandáhoˀ, ‘Háaḏan dä̂nwhihsuuḏeˀ?’, ginnân dä̂ntu̖ˀâ̖a̖mí: ‘Gá Nanbí Sedó iˀ ûntáyḏân.’ ” ");
INSERT INTO tew_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Heḏiho in wíje damääḏi dä̂nshaa háa Jesus-di ovä̂ntu̖ˀan waagibá. ");
INSERT INTO tew_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Heḏi iˀ búduˀay dä̂nwhihsuuḏeˀ ihayḏi in tꞌowa inbí búduˀay dínmuuˀindi ovä̂ntsikaˀyan, “Heháaḏan dä̂nwhihsuuḏeˀ?” ");
INSERT INTO tew_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ovâytu̖ˀan, “Gá Nanbí Sedó iˀ ûntáyḏân.” ");
INSERT INTO tew_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Heḏi iˀ búduˀay Jesus ônhoˀ, heḏáháˀ inbí kꞌéwéˀin to dänpꞌä̖́ḏiḏá iˀ búdu kꞌéwé ônpa̖ˀkꞌûˀ, heḏi Jesus óetege iˀíhsôege-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Heḏi iwáy pꞌóegé wáy óeˀíhhon dihayḏá in tꞌowa inbí kꞌéwéˀi to dívípä̖ḏihondá oe teˀpꞌóegá ônpa̖ˀkwohon. ");
INSERT INTO tew_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerusalem tsowa napowamän dihayḏi in pꞌôe owáy Olive Okú áagé wáypiyeˀ nawándeˀ iwáygé báyékí in tꞌowa Jesus-víˀpiye dívíwä̖yundeˀin dijiˀ, heḏi híhchandi dívítu̖wí̖núndeḏi ditû̖ˀ Jôesi Táḏá-á hayˀi namuuˀin, iˀ báyékí pínnán tꞌôe ho dâymûˀi namuuḏi. ");
INSERT INTO tew_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jesus-ví̖ˀgeḏi kaygi ditû̖ˀ, “U̖-á tsondi hayˀiˀ unmuu.” “Nanbí Sedó Jôesi Táḏáḏí wóesan heḏiho híwó wóeˀâ̖a̖mí.” “Hä̖ä̖ tꞌä̖hkí saˀwó namuu oe makówá, heḏá oe kwꞌáyebá ditú̖u̖ní Jôesi Táḏá-á hayˀi namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hewänbo wên Pharisees in tꞌowa-áḏí dijiˀindi Jesus óetu̖ˀan, “Há̖hkandiˀ, uví khä̖geˀnin ovâytu̖ˀan ditu̖há̖a̖níˀin.” ");
INSERT INTO tew_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus-di ovâytu̖ˀan, “Naaḏi wâytu̖máa, hä̖ˀin hânda̖ˀdibo dijiḏá, háa ditû̖ˀ waa hä̖ˀi kꞌuu iwe nakwꞌóˀdi wänbo hanbá dívítu̖wé̖e̖nú-í.” ");
INSERT INTO tew_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesus oe Jerusalem búˀ shánkí tsowa namän dihayḏi, iˀ búˀ imûˀḏibo isíhtä̖ä̖, ");
INSERT INTO tew_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","heḏi natú̖, “Jerusalem, nääho hây uví tꞌowa wáˀ dínhanginnândi híhchandi inbí wówátsi dínmúuníˀin, hewänbo nää-á háˀto dínhanginpúuwí. ");
INSERT INTO tew_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wáy wí thaa nanáˀ dihayḏi in wóehä́nboˀindi uví tehpaa nuuge wônnanbóeḏíkwokhâymáa, dívítuuyé-íḏí oe búgepiye ditsꞌú̖u̖níḏí, heḏá wóebúgeˀandá tꞌä̖mäpha̖ˀgeḏá wóehä́nkhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Uví tewhá tꞌä̖hkí wônnayu̖khâymáa, heḏá in tꞌowa uvíˀwe dithaaˀindá ovâykha̖nukhâymáa. Háˀto wí kꞌuu wänbo natehpaaˀä́ndí wônjoekankhâymáa. Nä́ˀi tꞌä̖hkí úpúuwí gá Jôesi uvíˀwe napówáḏân wônˀaywoeníḏí, hebo wíˀúhanginnáhpí naˀä̖ä̖ˀin.” ");
INSERT INTO tew_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ihayḏá Jesus oe méesate hayˀi eepiye namää, heḏi in tꞌowa dâyhä̖ä̖wíku̖ˀchꞌáaḏeˀin iweḏi ovâykhehpiye. ");
INSERT INTO tew_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ovâytu̖ˀan, “Jôesi Táḏáví taˀnin deewá nä́ˀin háa natú̖ˀin nataˀmuu: Naví tewhá-á jûusugîˀ-ân namuu, hewänbo undá iˀ bînˀegóˀan sänmin dívíwéˀgeˀa̖mígîˀ namúuníḏí.” ");
INSERT INTO tew_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Thamuwaagi ee méesate hayˀi iwe Jesus-di in tꞌowa ovâyhá̖ˀoˀ. In owhaˀ pꞌóˀḏéḏíˀindá, in Huḏíyoví khuu dâyhá̖ˀoˀindá, heḏá wây-á Huḏíyo pꞌóˀḏéḏíˀindá dâytu̖wä̖máa háḏíḏí óeháyjíˀin. ");
INSERT INTO tew_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Hewänbo háa dívíˀa̖míˀin wíḏâyshaaḏepí, in tꞌowa háa natú̖ˀin tꞌä̖hkí hânho dívítꞌôeyandeḏi. ");
INSERT INTO tew_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wí thaa Jesus-di iˀ méesate hayˀi ee in tꞌowa ovâyhá̖ˀoˀ heḏá Jôesi Táḏáví híwó̖ˀdi tun ovâytꞌôeˀoˀ. In owhaˀ pꞌóˀḏéḏíˀindá, in Huḏíyoví khuu dâyhá̖ˀoˀindá heḏá wây-á Huḏíyo tsonnindá ûnpówá, ");
INSERT INTO tew_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","heḏi óetu̖ˀan, “Dítu̖ˀan, háawinnan uví tsonkhuu úmuu háa biˀo waa biˀa̖míḏí? Toˀḏan nä́ˀin taˀgen wônkꞌûˀ?” ");
INSERT INTO tew_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus-di ovâytu̖ˀan, “Nää-á naaḏá wáˀ wí hä̖ä̖wí wâytsikaˀya̖mí un. ");
INSERT INTO tew_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Dítu̖ˀâ̖a̖mí, toˀḏan John ônkꞌûˀ tꞌowa ovâypꞌóˀpꞌoeˀa̖míḏí, ti Jôesi Táḏáḏí háa tꞌowaḏi?” ");
INSERT INTO tew_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Heḏi wíˀnä́ táye dívítu̖máa, “Jôesi Táḏáḏí John ônkꞌûˀ gin gitú̖ḏáhoˀ, Jesus-di dítsikagíˀo, ‘Heḏi háaḏan handi wíˀúvíwä̖yu̖pí háa John natú̖ˀin?’ ");
INSERT INTO tew_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Hewänbo tꞌowaḏiḏa̖ˀ ônkꞌûˀ gin gitú̖ḏá, nä́ˀin tꞌowa nä́we dijiˀindá naˀin díkꞌusä̖ä̖yú̖-í díháyjíḏí, gá John-dá Jôesi Táḏáví tukheˀbi ûnmuuˀin dívíwä̖yundeḏân.” ");
INSERT INTO tew_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Heḏiho indi Jesus óetu̖ˀan, “Naˀindá wígínhaginnáhpí toˀwíḏí ônkꞌûˀin.” ");
INSERT INTO tew_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Heḏi Jesus-di ovâytu̖ˀan, “Heḏáhoˀ, naaḏi wänbo wáˀ wíwâytu̖ˀa̖mípí toˀwíḏí naa dînkꞌûˀin dóˀa̖míḏí nä́ˀi hä̖ä̖wí dóˀoˀiˀ.” ");
INSERT INTO tew_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ihayḏá Jesus-dá nä́ˀin há̖hkangíˀin óˀgéḏí in tꞌowa ovâytu̖ˀan: “Wí sen iˀúuvaˀáakhä̖hsaa, heḏáháˀ iˀ úuva nava-á wên senäˀ úuva áaphä̖ä̖ á̖yí̖ˀnin dimuuˀin ovâypíyémä́gi, heḏáháˀ wíyá piˀwí nangepiyá namää, heḏi báyékí pꞌóe iwe iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Iˀ úuva napꞌeˀyin dihayḏi wí tꞌôeˀiˀ óesan iˀ nava iwepiye heḏânho in senäˀ dâynavapíyéˀannindi iˀ úuva nayä̖́muˀiˀ óemä̂äníḏí. Hewänbo indi iˀ tꞌôeˀi óewhä̖́ḏiḏáháˀ manda̖ˀdibo-á óewáybun. ");
INSERT INTO tew_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Heḏi iˀ sendá wíyá tꞌôeˀi-á óesan, hewänbo indi iˀ wáˀ óewhä̖́ḏi heḏá jänäkí-á óeˀan, heḏi iˀ wáˀ manda̖ˀdibo-á óewáybun. ");
INSERT INTO tew_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ihayḏá iˀ powageˀi tꞌôeˀi-á óesan. Iˀ wáˀ óewa̖ˀan, heḏá nava iweḏá óechä̖nu. ");
INSERT INTO tew_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Heḏiho iˀ sen iˀ nava ûnmuuˀi ginnân iˀánshaaˀan: ‘Hân hîn dáyˀa̖mí? Gá ginnân: Nää-á naví eˀnú donsígíˀi donsaaní. I-áho maḏânho óeˀaˀgeení.’ ");
INSERT INTO tew_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hewänbo in dâynavapíyéˀannindi iˀ senbí eˀnú ûnˀä̖ḏi óemûˀ ihayḏá wéˀge dívíhéeˀandi ditú̖, ‘Nä́ˀi-ânkun namuu nä́ˀi hä̖ä̖wí tꞌä̖hkí ûnjoepuwagíˀoˀiˀ. Jaho âyháyjí heḏânho nä́ˀi hä̖ä̖wí nayä̖́muˀi-á gínmúuníḏí.’ ");
INSERT INTO tew_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Heḏiho iˀ nava iweḏi óepꞌégiḏi óehay.” Heḏi Jesus-di in tꞌowa ovâytsikaˀyan, “Hân iˀ nava ûnmuuˀiˀḏi in senäˀ dâynavapíyéˀannin ovâyˀa̖mí? ");
INSERT INTO tew_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Gá namääḏá iˀḏá ovâyhá̖a̖nú-í, ihayḏá iˀ nava-á wây-á toˀwêndá ovâypíyémä̂äní.” In tꞌowa nä́ˀi ditꞌoe ihayḏá ditú̖, “Haˀwâa wínakhâyˀä̖hpí napúuwíˀin.” ");
INSERT INTO tew_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus-di tsíhtáye ovâymúndeḏi ovâytu̖ˀan, “Heḏi hân handi nä́ˀi Jôesi Táḏáví taˀnin diwe ûntaˀmuuˀi natundaˀ?: Iˀ kꞌuu in tewhátehpaaˀin dâyjoegiˀandá nää shánkí natáyˀi kꞌuu tehpaa béˀḏí napóe. ");
INSERT INTO tew_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hä̖ˀi kꞌuu-á wí kꞌuu wí toˀwí eeḏi iˀânchä̖nuḏi nakaanú-íˀi waagiˀbá namuu, heḏi nä́ˀi toˀwí nakanuḏi iví túˀ ikhoejée-í heḏá ipóeˀa̖mí. Heḏi iˀ kꞌuubá ivîˀḏi ûnkeˀtꞌândáho óetꞌä̖́ä̖-í.” ");
INSERT INTO tew_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","In Huḏíyoví khuu dâyhá̖ˀoˀindáḏí heḏá in owhaˀ pꞌóˀḏéḏíˀindáḏí dínhanginná Jesus nä́ˀi híˀ inbí̖ˀgeḏiho ihéeˀannin, heḏiho didaˀ wesebo Jesus óepankáyjíˀin, hewänbo in tꞌowa dâykhunwôedaˀmáaḏí wíˀóepankêˀpí. ");
INSERT INTO tew_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","In Hudíyo tsonnindi á̖yîngiḏi Jesus óemúndeḏi didaˀ óekáyjíˀin híwó wíˀihíˀmáapíḏí, heḏânho in Rome-ˀinbí tunjó óemangekáaníḏí, nä́ˀi tunjó-á shánkí tsonkhuu imáaḏí. Heḏiho wên senäˀ kaaḏibo ovâywáˀâa Jesus hä̖ä̖wí óetsikaˀyâ̖a̖míḏí. Nä́ˀin senäˀdá hójoˀinda̖ˀ dimuu, hewänbo híwóˀnin dimuu waa dívíkhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Heḏi nä́ˀin hójoˀin senäˀdi Jesus óetu̖ˀan, “Há̖hkandiˀ, naˀindá gínhanginná u̖-á taˀgeḏa̖ˀ bihéeˀo heḏá ovâyhá̖ˀoˀ, u̖ˀḏá tꞌä̖hkí tꞌowa-á handa̖ˀbá ovâymáa, heḏiho taˀgendá Jôesi Táḏáví khuu i̖ˀgeḏá ovâyhá̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dítu̖ˀan, hânnan nanbí tsontun gíntû̖ˀ, ti híwó namuu in Rome-winbí tsondi Caesar ây-tax-wáˀâa-íḏí háa joe?” ");
INSERT INTO tew_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hewänbo Jesus-á wesebo ûnhanginná háa inbí hójoˀi ánshaa dínmuuˀin, heḏiho ovâytu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Wí denarius chä̖ˀ dînkeeyan. Toví tsꞌay heḏá toví khá̖wä̖́-á eeḏi ûnkꞌóe?” Óetu̖ˀan, “Gá Caesar-víˀinnân.” ");
INSERT INTO tew_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Heḏi Jesus-di ovâytu̖ˀan, “Heḏáhoˀ, hä̖ä̖wí Caesar-vîˀ ûnmuuˀi Caesar-bá binmä́ä, heḏi wáˀ hä̖ä̖wí Jôesi Táḏávîˀ ûnmuuˀi-á Jôesi Táḏá-á binmä́ä.” ");
INSERT INTO tew_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wíḏínkoḏipí wên piháawin híˀ óetu̖hkannamíḏí in tꞌoa ditꞌoe-íḏí, heḏi iví híˀḏí ovâyháaˀandi wíyá háabo wíˀóetu̖ˀanpí. ");
INSERT INTO tew_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wên Sadducee tꞌowa Jesus-víˀpiye diˀä̖ä̖ hä̖ä̖wí óetsikaˀya̖míḏí (In Sadducees-á dívíwä̖yundeˀ in tꞌowa dichuuˀin háˀto wíyá diwáywówápúuwíˀin.) Indi óetu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Há̖hkandiˀ, Moses nä́ˀin tsontun dîntaˀnan: Wí sen âypíḏíbo nachuuḏi iví kwee waˀ ûnwówájiḏá, i senbí tíˀûu ûnkhâyˀä̖ˀ iˀ kwee-áḏí ikhóˀyâ̖a̖-íˀin heḏânho dä̂nˀâykwꞌôeníḏí, iˀ páˀḏâyví khá̖wä̖́ ônhûuwíḏí. ");
INSERT INTO tew_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hebo ginnân napóe: Tsé ihay tíˀûuwin senäˀ dijiˀ. Iˀ shánkí páaḏéˀiˀ ikhóˀyâ̖ˀ, hebo âypíḏíbo nachuu. ");
INSERT INTO tew_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Iˀ eeḏiˀi-á wáˀ iˀ kwee-áḏí ikhóˀyâ̖ˀ, heḏá nä́ˀi sen wáˀ âypíḏíbo-áho nachuu. ");
INSERT INTO tew_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ihayḏáháˀ iˀ powageˀi-á wáˀ hanbá ûnpóe. Heḏi handa̖ˀ tꞌä̖hkí in tséḏí dijiˀin tíˀûuwin dínpóe, tꞌä̖hkí wíˀínbo iˀ kwee-áḏí dívíkhóˀyâ̖ˀḏi dichuu dâyˀâykwꞌóḏipíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tꞌä̖ˀgeḏá iˀ kwee-á wáˀ nachuu. ");
INSERT INTO tew_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nä́ˀin tsé ihay tíˀûuwinho i-áḏí dikhóhtsa̖a̖kwꞌônwän, heḏiho nää naˀin dítu̖ˀan, owáy tꞌowa wíyá diwáywówápóe ihayḏi, toˀwíví kwee-an ûnmúuní?” ");
INSERT INTO tew_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus-di ovâytu̖ˀan, “Kwiyä̖ˀdáḏí senäˀdáḏí dívíkhóˀyándeˀ waˀ nä́ä oepáa kꞌayḏi diwówájiˀ ihayḏiboˀ. ");
INSERT INTO tew_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hewänbo toˀwên Jôesi Táḏá natú̖ makówápiye dimännindá, in chuwa iweḏi ovâywáywówápakhâymáa heḏiho háˀto wíyá dichuu-í, heḏânho ihayḏi senäˀdá kwiyä̖ˀdá wíyá wíḏívíkhóhtsa̖a̖khâymáapí, ");
INSERT INTO tew_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","gá gindiḏi in makówáwin tꞌôepa̖ˀa̖a̖ˀin waaginbá dimúuníḏân. Heḏi Jôesi Táḏáví ây dimuu gá iˀḏá wíyá ovâywáywówápakhâymáaḏân. ");
INSERT INTO tew_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Jôesi Táḏáḏí tꞌä̖hkí tꞌowa ivíˀin ûnmuuˀin ovâymúnde diwówájiˀin dimuu waagibá. Moses wänbo nä́ˀin híwó ithayyan iˀ wä̖́ä̖ˀi phéˀyä̖́vi nakojeˀ niˀgeḏi itaˀnan dihayḏi. Iwe natú̖ Nanbí Sedó Jôesi Táḏá-á Abraham-bí Jôesi namuu, heḏá Isaac-vîˀ-á heḏá Jacob-vîˀ-á, tobá nä́ˀin ho dichuu wänboˀ. Heḏiho dichuu wänbo taˀgendi diwówájiˀ gá Jôesi Táḏá-á in diwówájiˀinbí Jôesi-ân dínmuuḏân, in dichumuuˀinbîˀ-á joe.” ");
INSERT INTO tew_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wên in Huḏíyo-ví khuu dâyhá̖ˀoˀindi óetu̖ˀan, “Há̖hkandiˀ, híwó bihéeˀan.” ");
INSERT INTO tew_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Heḏi diwôedaˀ wíyá hä̖ä̖wí óetsikaˀya̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Heḏi Jesus-di ovâytsikaˀyan, “Heháaḏan tꞌowa ditû̖ˀ iˀ toˀwí Jôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí David-ví ây iweḏiˀiˀḏa̖ˀ ûnmuu? ");
INSERT INTO tew_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Iˀ Psalms nataˀmuu iwe David-bo natú̖: Naví tsondi hayˀi Nanbí Sedó Jôesi Táḏáḏí óetu̖ˀan, ‘Naví koˀḏíngéḏí ósoge, heḏi uví hä́nmin dovâytꞌaaní heḏá uví mangá wînkáaní.’ ");
INSERT INTO tew_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nä́ˀi toˀwí Jôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí David-dibo iví tsondi hayˀi gin óetu̖ˀoˀ. Gin namuuḏá háḏíḏanho David-ví ây iweḏiˀiˀḏa̖ˀ ûnmúuní?” ");
INSERT INTO tew_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Waˀḏi tꞌä̖hkí in tꞌowaḏi Jesus ôntꞌôeyandeˀ ihayḏi iví khä̖geˀnin itu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nä́ˀin tꞌowa Huḏíyoví khuu dâyhá̖ˀoˀin dimuuˀinbíˀweḏi bíˀá̖yîngiˀan. To whaaḏiˀindi ditoˀondi dijiˀ dâykeeya̖míḏí toˀwên dimuuˀin, heḏá hânho-á ovâyhí̖ˀan tꞌowaḏi aˀgindi ovâysengitu̖ˀâ̖a̖míˀin iˀ búˀ pinge i̖ˀge dijiḏi, heḏá wáˀ in Huḏíyoví méesate eeje heḏá nashánkíˀeeḏináˀ dihayḏá in tsonninbí soge eeḏi dívíkwꞌôeníˀin didaˀ. ");
INSERT INTO tew_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kwiyä̖ˀ inbí senäˀ dínchuuˀinbí tewhá ovâykweeḏeˀ, heḏáháˀ thaa tꞌä̖hkí dívíjûusuˀoḏi híwóˀnin dimuu waagi dívípiḏaˀoˀ. Gin dívíˀoḏi Jôesi Táḏáḏí shankí ovâytuhchä̖nukhâymáa.” ");
INSERT INTO tew_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus ipu̖wä̖béeḏeˀ iˀ hayˀi méesate iwe in tꞌowa dijiˀ i̖ˀge, heḏi in koḏitꞌowa dimuuˀin inbí chä̖ˀ dâykuuḏeḏi iˀ chä̖ˀ phébay iwe ovâymúndeˀ. ");
INSERT INTO tew_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Heḏá wí kwee iví sen ûnchuuˀiˀ sehkanäwó nawówájiˀi wáˀ wíje chä̖ˀ pꞌíˀin itógiḏi óemûˀ. ");
INSERT INTO tew_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Heḏi natú̖, “Taˀgendi wâytu̖ˀâ̖a̖mí, nä́ˀi kwee iví sen ûnchuuˀi sehkanäwó nawówájiˀi-á shánkí itógi tꞌä̖hkí in wéˀgen dâykuuˀinbíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","In wéˀgendáho inbí chä̖ˀ dínphaḏe iweḏi dívímä́gi, hewänbo nä́ˀi kwee-á báyékí ûnkwꞌóhpí wänbo tꞌä̖hkí iví wówátsi iˀa̖mígîˀ imáaˀiˀ itógi.” ");
INSERT INTO tew_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wáy wên iví khä̖geˀnin iˀ méesate hayˀi i̖ˀgeḏi dívíhíˀmáa, heḏi ditû̖ˀ, “Saˀwó naná saˀwóˀdi kꞌuuḏi napaˀandiˀ namuuḏi heḏá iˀ hä̖ä̖wí ee nakwꞌóˀdiˀ in tꞌowaḏi Jôesi Táḏá óemä́giˀi namuuḏá.” ");
INSERT INTO tew_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jesus-di ovâytu̖ˀan, “Nää-áho nä́ˀi saˀwóˀdi hä̖ä̖wí bînmúndeˀ, hewänbo wáy wí thaa nanáˀ dihayḏi nä́ˀi méesate-á tꞌowa dâynayu̖khâymáa, heḏi wêe wänbo wí kꞌuu hä̖ˀi tehpaa iweḏi wínateˀḏeegíˀopí.” ");
INSERT INTO tew_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Indi óetsikaˀyan, “Há̖hkandiˀ, hä̂nhay-an nä́ˀi hä̖ä̖wí i̖ˀgeḏi dítu̖ˀandiˀ napuwagíˀo? Háawin taa-an nakeepúuwí heḏânho gínhanginnáaníḏí hä̖̂ä̖ḏi natsꞌanpúuwíˀin?” ");
INSERT INTO tew_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus-di ovâytu̖ˀan, “Bíˀá̖yîngiˀan toˀwíḏí wänbo piháa wíwovâywä̖yu̖kannamípíḏí. Báyékí tꞌowa naví khá̖wä̖́ i̖ˀgeḏi dikä̖ˀä̖ä̖gíˀo, heḏi wíˀínbo ditú̖u̖ní innânho dimuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. Heḏá wáˀ ditú̖u̖ní iˀ tꞌä̖ˀge thaa tsowa nanânhoˀ. Hewänbo inbíˀnäpiyá wíˀímú-ípí. ");
INSERT INTO tew_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Heḏi tꞌowa-á inbí tsonnindáḏí háa wíyá nangewin tꞌowa-áḏí dívíhä́nboˀ i̖ˀgeḏi ítꞌoeḏá, báyékí wíˀúvíˀá̖yîngiˀa̖mípí. Nakhâyˀä̖ˀ nä́ˀi hä̖ä̖wí napúuwíˀin, hewänbo owáy napóe ihayḏá iˀ tꞌä̖ˀge thaa wesebo wínaˀä̖hpí.” ");
INSERT INTO tew_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Heḏáháˀ ovâytu̖ˀan, “Tꞌowa wêe nangewin dívíhä́nkhâymáa wây-á tꞌowa wíyá wêe nangewindáḏí, heḏá nangewin tsonnindá wáˀ dívíhä́nkhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Wáyjé tꞌä̖hkí nananˀa̖ˀyä̖puwagíˀo heḏá báyékí diha̖a̖puwagíˀo, heḏá báyékí tꞌowa-á ihayḏiḏa̖ˀbá dihaypóeḏá dichuwagíˀo, heḏá tꞌowa-á dâypu̖wä̖khâymáa wí taa heˀendi oe makówá nakeepoeˀoḏi báyékí ovâykhunwôedaˀa̖míˀiˀ. ");
INSERT INTO tew_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Hewänbo gin napóepíḏíbo wovâypanhóení, heḏá unbí wä̖yu̖ únmuuḏibo jänäká wovâyˀa̖mí, heḏá in Huḏíyoví méesatewin pꞌóˀḏéḏíˀinbí mangá wovâyjoeˀa̖mí wovâytsondiwekáaníḏí, heḏá wovâypankwꞌôení, heḏá in nangewin pꞌóˀḏéḏíˀinbíˀpiye heḏá wéˀgen tsonninbíˀpiyá wovâyhûuwí. Nä́ˀi tꞌä̖hkí wovâyˀa̖mí navíˀin ímuuḏiboˀ. ");
INSERT INTO tew_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hewänbo nä́ˀi hä̖ä̖wí únpúuwíˀi namuuḏi únkoeḏí-í naví̖ˀgeḏi bîntꞌôeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Heḏiho waˀ napóepíḏíbo bíˀánshaamä́ä wíˀúvíjâyye-ípíˀin háa ítú̖u̖níˀin úvípiˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Naaḏi iˀ híˀ-á iˀ hangintandá wâymä̂äní, heḏânho toˀwên wänbo wovâytꞌeˀpꞌíḏéndeˀin háˀto dínkoeḏí-í dâykeeya̖míḏí háa ítú̖ waa taˀgen wínamuupíˀin, heḏá wíyá hä̖ä̖wí wänbo wíḏâymáˀve-ípí ditú̖u̖níḏí. ");
INSERT INTO tew_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Unbí hä́nminbí mangepiye unbí jíyáˀindi táḏáˀindi wänbo wovâykáaní, háa unbí tíˀûuwindá páˀḏâyˀindá han wovâyˀa̖mí, háa unbí maatuˀindi háa unbí kꞌemaˀindi wänboˀ, heḏi wáy wên un wovâyhá̖a̖nú-í. ");
INSERT INTO tew_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Heḏi báyékí tꞌowaḏáho wovâytꞌaykhâymáa navíˀin ímuuḏi. ");
INSERT INTO tew_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Hewänbo Jôesi Táḏáḏí wovâyˀá̖yîngimáˀve-í, wí hây tä̖hkí wänbo háˀto iˀḏi wovâyjoeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Úvítꞌôephaḏeyä̖́ä̖ˀandáhoˀ in taˀgen wówátsi ítꞌanpúuwí.” ");
INSERT INTO tew_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Hewänbo báyékí sundaḏo Jerusalem búˀ jáˀwé bûu kꞌúwákí dijiˀin bînmûˀ ihayḏi, únhanginnáaní hanwaapíḏíboˀ iˀ búˀ nanda̖ˀ dâyjoekankhâymáaˀin. ");
INSERT INTO tew_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Heḏi ihayḏá in Judea nange dikwꞌóˀnin dínkhâyˀä̖ˀ oe okú eepiye dijáaníˀin, heḏá in toˀwên oe Jerusalem búˀ iwe dijiˀindáho iweḏáho dipee-í, heḏá in oe nava eeje dijiˀindáho oe búˀpiyá wíḏimú-ípí, ");
INSERT INTO tew_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","gá ihayhä̖̂ä̖báho Jôesi Táḏáḏí in tꞌowa Jerusalem-win ovâytuhchä̖nukhâymáaḏân, heḏi tꞌä̖hkí háa Jôesi Táḏáví taˀnin diwe nataˀmuuˀin iˀ thaa i̖ˀgeḏi napúuwí. ");
INSERT INTO tew_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Owáy iˀ thaa napówá ihayḏá, sehkanä in kwiyä̖ˀ disâamuuˀin heḏá in dâyˀâytsä̖ä̖ˀoˀindá, gá ingîˀ-á nakâypúuwíḏân dijáaníḏí. Tꞌowa dâytꞌôephaḏegíˀo nä́ˀi nange i̖ˀge tꞌä̖hkí, heḏi Jôesi Táḏáḏáho in tꞌowa ovâytuhchä̖nugíˀo, indáḏí natꞌayḏi. ");
INSERT INTO tew_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wáy wên tsijópháˀḏí ovâyhá̖a̖nú-í, wây-á wêndá ovâypanhógiḏá báyékí wíyá piˀwáy nan deepiyá ovâyhûuwí. In Huḏíyo dimuupíˀin tꞌowaḏá in tꞌowa Jerusalem-win ovâytsonmáˀve-í owáy inbí thaa gin dívíˀa̖míḏí dínphaḏe píhay.” ");
INSERT INTO tew_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nä́ˀi taa-áho oe makówá gin nakeetꞌôení: Iˀ thandá pꞌóe-á agóyó-á piháa nakeepúuwí, heḏá nä́ä oepáa kꞌayḏá tꞌä̖hkí nangewin tꞌowa-á háa dívíˀa̖míˀin heḏá háa dívíˀánshaaˀa̖míˀin háˀto dínhanginnáaní, iˀ mâapꞌoe hânho nasaatû̖ˀdi heḏá iˀ heˀendi pꞌoetꞌúkhú̖ namuuḏá. ");
INSERT INTO tew_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tꞌowa-á hânho dikhunwôedaˀpuwagíˀoḏi dinagokhangíˀo, háa nä́ä oepáa kꞌayḏi tꞌä̖hkí napuwagíˀo i̖ˀgeḏi dívíˀánshaamáaḏí. Tꞌä̖hkí oe makówá nasaaˀi-á naˀa̖ˀyä̖púuwí. ");
INSERT INTO tew_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Heḏi ihayḏi in tꞌowaḏi naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi dímúuní okhúwá jâa oˀä̖ḏi, pínnán kay wóegé heḏá kohthay wóegá oˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Owáy nä́ˀi hä̖ä̖wí natsꞌanpuwamän dihayḏá wíyá wíˀúvípꞌóhwháyeˀbé-ípí, kwꞌáyepiye úvíbée-í, gá tsowa wovâyˀaywoeníḏí napuwamändân.” ");
INSERT INTO tew_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Heḏáháˀ Jesus-di ginnân ovâytu̖ˀan wíyá ovâythayya̖míḏí: “Iˀ fig tay i̖ˀgeḏi heḏá wéˀgeˀi tay i̖ˀgeḏá bíˀánshaaˀan. ");
INSERT INTO tew_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Natsꞌantsá̖wä̖́puwamän dihayḏi unbo bînmúndeḏi únhanginná nata̖ˀánpowaˀä̖ˀinpíˀan. ");
INSERT INTO tew_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Heḏi gindiḏibá owáy nä́ˀi hä̖ä̖wí i̖ˀgeḏi naaḏi wâytꞌôeˀan bînmûˀ ihayḏá únhanginnáaní ho púnúˀ naná naa owáyˀä̖ä̖-íˀin otsondisogeḏee-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Taˀgendi wâytu̖máa, tꞌä̖hkí in nääwin tꞌowa háˀto dihá̖a̖ní waˀḏi nä́ˀi hä̖ä̖wí tꞌä̖hkí páaḏé natsꞌanpoeˀopíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Makówá-á heḏá oepáa kꞌayḏá tꞌä̖hkí nakhangíˀo, hewänbo naví tundá háˀto dînhá̖a̖ní.” ");
INSERT INTO tew_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Úvíˀa̖yîngiˀa̖mí hä̖ä̖wí i̖ˀgeḏi úvíˀánshaahondiˀ. Báyékí húukandá heḏá háapuwa-á wíˀúvíˀâ̖a̖mípí, heḏi wä̖hphaḏe wíˀúvíˀánshaamáˀve-ípí háa unbí wówátsigîˀ úvíˀa̖míˀin. Wáy iˀ thaa natꞌôephaḏepúuwíˀiˀ únpóewí waˀḏi únhanginpóepíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ihayḏibá tꞌä̖mäpiye in nä́ä oepáa kꞌayḏi dithaaˀin wên phay iwe diwêegíˀo waagibá dínpúuwí. ");
INSERT INTO tew_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Heḏiho hä̖̂ä̖ḏi wänbo tꞌä̖hkí íkhâymúuníˀin únkhâyˀä̖ˀ, heḏá úvíjûusumáˀve-í heḏânho nä́ˀi hä̖ä̖wí tꞌä̖hkí napuwagíˀoˀi-á úvíyä̖́ä̖ˀa̖mí, heḏá owáy naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiví páaḏépiye íwin dihayḏi híwó únpúuwí” gin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Ihayhä̖̂ä̖bá thamuwaa héḏéndí héˀḏibo tꞌowa dipóyaˀ ee hayˀi méesate iwe Jesus-ví híˀ ôntꞌôeyaaníḏí. Thaaḏá iˀḏi in tꞌowa iwe ovâyhá̖ˀoˀ, heḏá nakin dihayḏá iˀ búˀ iweḏi napeeˀi oe Olive Okú gin dâytu̖ˀoˀ iweboˀ iwhonwóyí̖ˀníḏí khu̖ˀḏéeḏí. ");
INSERT INTO tew_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","I shánkíˀeeḏi Passover gin dâytu̖ˀoˀi púnúˀ naná, iˀ oewáaseepîˀ pává dâykꞌoˀiˀ. ");
INSERT INTO tew_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","In owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá háḏíḏí Jesus óeháyjíˀin dâytu̖wä̖máa, hewänbo kaaḏibo dívíˀa̖míˀin didaˀ, gá in tꞌowa-á dâykhunwôedaˀḏân. ");
INSERT INTO tew_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Heḏá Satan iˀ Penísendi-á Judas-ví píˀnä́ khóˀjé-á ûntsꞌú̖. Judas-á Iscariot gin wáˀ óetu̖ˀoˀ, heḏi Jesus-ví tä̖ˀḏi wíje khä̖geˀnin diweḏiˀiˀbá namuu. ");
INSERT INTO tew_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Heḏáháˀ namää in owhaˀ pꞌóˀḏéḏíˀindá heḏá in sundaḏo iˀ hayˀi méesate dâyˀá̖yí̖ˀdoˀinbí tsonnindá inbíˀpiye. Nadaˀ ovâyhéeˀa̖míˀin háḏíḏí Jesus óeku̖ˀpꞌâyní i̖ˀgeḏi, heḏânho inbí mange óekáaníḏí. ");
INSERT INTO tew_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Indá dihíhchanpóeḏí Judas óetu̖ˀan chä̖ˀ óewáˀâa-íˀin, ");
INSERT INTO tew_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","heḏi i-á nahíjeḏiho itu̖wä̖máa háḏíḏí Jesus inbí mange óekáaníˀin in tꞌowa dínhanginnáhpíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","In Huḏíyoví shánkíˀeeḏi dínpówá iˀ oewáaseepîˀ pává dâykꞌoˀiˀ, heḏi ihay thaa-á naná in kꞌúwáˀây-á dâyhá̖núndeˀ, Passover koegîˀ gin dâytu̖ˀoˀi dâykꞌoˀíḏí. ");
INSERT INTO tew_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Heḏi Jesus-di Peter-áḏí John-dáḏí ovä̂ntu̖ˀan, “Jaho iˀ hä̖ä̖wí binkhâyˀan iˀ Passover koegîˀ âykꞌoˀíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Indiḏá óetsikaˀyan, “Wä̖́hä̖̂ä̖-an undaˀ gamú-íˀin ä́nkhâyˀa̖míḏí?” ");
INSERT INTO tew_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Iˀḏi ovä̂ntu̖ˀan, “Gá ginnân: Oe Jerusalem búˀpiye bápûn, heḏi iwe datsꞌûndi wí sen wên pꞌonbay ihondiˀḏi wovä̂njay-í. I-áḏíbá damú-í heḏá iˀ tewhá ee natsꞌûndibá datsꞌú̖u̖ní, ");
INSERT INTO tew_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","heḏi iˀ sen iví tewhá ûnmuuˀi dä̂ntu̖ˀâ̖a̖mí, ‘Nanbí há̖hkandiˀḏi dítu̖ˀan wítsikaˀyâ̖a̖míḏí, Wéˀi íve eewan naví khä̖geˀnindáḏí nä́ˀi Passover koegîˀ âykꞌoˀí?’ ");
INSERT INTO tew_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Heḏi i sendi wí whaˀkꞌay íve hayˀi wovä̂nkeeya̖mí, hä̖ä̖ tꞌä̖hkí gíntáyˀi nakwꞌóˀdiˀ. Ee-áho iˀ koegîˀ-á dä̂nkhâyˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Heḏiho damääḏi hä̖ä̖wí tꞌä̖hkí dä̂nshaa Jesus natú̖ waagibá, heḏiho i Passover koegîˀ dä̂nkhâyˀan. ");
INSERT INTO tew_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Húukandi ihayḏi napóe ihayḏi Jesus-áḏí iví khä̖geˀnindáḏí iˀ mä́äsa iwe dívíhúukwꞌóḏi, ");
INSERT INTO tew_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","heḏi ovâytu̖ˀan, “Hânho nä́ˀi Passover koegîˀ undáḏí okoedaˀ, waˀ ochuupíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Naaḏá wâytu̖máa, háˀto Passover koegîˀ wíyá dókꞌoˀí i taˀgendi Passover shánkíˀeeḏi napóe píhay, owáy otsondisogeḏee ihayḏi.” ");
INSERT INTO tew_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ihayḏáháˀ in kꞌéḏé méena nasaaˀin ikêˀḏi ikú̖ˀdaaˀandi ovâytu̖ˀan, “Nä́ˀin binkeˀḏi wí binsú̖wä̖́ wíˀínboˀ. ");
INSERT INTO tew_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Naaḏi wâytu̖máa, nää-á wíyá wíḏóméenasu̖u̖wä̖́-ípí hebo Jôesi Táḏáḏí dítsondisóge ihayḏáho wíyá méena waagibá dósu̖wä̖khâymáa.” ");
INSERT INTO tew_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Heḏáháˀ wí pává-á ikêˀḏi Jôesi Táḏá óekú̖ˀdaaˀan, heḏáháˀ iháveḏá ovâymä́gi, heḏi ovâytu̖ˀan, “Nä́ˀi-á naví túˀ dînmuu, heḏi naví túˀ-á ungîˀ dáypä̖khâymáa. Nä́ˀi pává-á bînkꞌoˀí naví̖ˀgeḏi úvíˀánshaamáˀve-íḏí.” ");
INSERT INTO tew_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Heḏi dívíkindihúubowaḏá in kꞌeḏe-á wíyá ovâyphaḏe heḏi ovâytu̖ˀan, “Nä́ˀi-á naví ûnpꞌoe dînmuu. Ungîˀ naví ûnpꞌoe donchaˀgíˀo, heḏi owáy gin dáyˀandiho Jôesi Táḏáví tsꞌa̖a̖bi tun imä́giˀi ho ûnpúuwí. ");
INSERT INTO tew_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nää bítꞌôeyan, iˀ toˀwí naa díku̖hpekhâymáaˀi-á nä́ä naví núˀ naˀä́n, heḏi iˀ mä́äsa eeḏi namankꞌóe. ");
INSERT INTO tew_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naa tꞌowa tꞌä̖hkígîˀ oˀaypu̖yä̖ˀiˀ ochuwagíˀo, Jôesi Táḏá hä́nˀoe natú̖ waagi, hewänbo nä́ˀi toˀwí díku̖hpekhâymáaˀi-á tꞌôephaḏe ûnpúuwí.” ");
INSERT INTO tew_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Heḏáháˀ iví khä̖geˀnin dívítsikaˀmáa, “Wéˀi-angú naˀin diweḏi nä́ˀin natú̖ˀin ikhâymáa?” ");
INSERT INTO tew_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ihayḏáháˀ in khä̖geˀnin dívítu̖hkandoˀ wéˀi-an in diweḏi shánkí hayˀi namuu i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus-di ovâytu̖ˀan, “Nä́ˀin Huḏíyo dimuupíˀinbí tsonnindi ovâytsonmáa, heḏá didaˀ tꞌowa ditú̖u̖níˀin inbí̖ˀgeḏi, ‘Iˀḏá híwó naˀin díˀoˀ.’ ");
INSERT INTO tew_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Hewänbo ha̖ˀmindá wíˀímúunípí. Ginnân únkhâyˀä̖ˀ ímúuníˀin: Iˀ shánkí hayˀi namuuˀi-áho ûnkhâyˀä̖ˀ hí̖yä̖̂ä̖ˀi-áho ipipaˀíˀin, heḏi iˀ toˀwí itsonmáaˀi-áho khä̖geˀdiḏa̖ˀbáho ipipaˀí. ");
INSERT INTO tew_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wéˀi-an iˀ shankí hayˀi namuu, ti iˀ mä́äsa iwe nahúuˀä́ndiˀ háa iˀ tꞌôeˀiˀ ônkoegîˀmáyä̖ˀdiˀ? Iˀ mä́äsa nahúuˀä́ndi-á iˀ shánkí hayˀi namuupíˀan. Hewänbo naa undáḏí waˀ ojiˀ ihayḏibo wí tꞌôeˀi waagiˀbá omuu. ");
INSERT INTO tew_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Undá naa-áḏí úvíwóyí̖ˀ tobáháa dontꞌôephaḏende wänboˀ, ");
INSERT INTO tew_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","heḏiho naaḏá wâykꞌúuwí tsonnin ímúuníḏí, naví Táḏáḏí naa otsonyê̖e̖níḏí dînkꞌûˀ waagibá. ");
INSERT INTO tew_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Heḏiho owáy otsonjiˀ ihayḏi undáho naví mä́äsa iwe naa-áḏí úvíhú̖u̖ya̖mí, heḏá tsonninbí púwéḏé eejá úvíkwꞌôení, heḏi in Israel-ˀin tä̖ˀḏi wêegeˀin tꞌowa ovâytu̖ˀâ̖a̖mí háa híwó háa híwóhpí dívíˀannin” gin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Heḏáháˀ Jesus-di Simon Peter óetu̖ˀan, “Simon, ótꞌôeyan: Iˀ Penísendi Satan nadaˀpóe un tꞌä̖hkí wovâyhóeníḏí heḏânho wovâytayi̖ˀníḏí, heḏi wí toˀwí itáhêejo waagibá wovâykhâymáa. ");
INSERT INTO tew_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Hewänbo naaḏi wînjûusuˀan, heḏânho uví wä̖yu̖ wíˀúhá̖a̖nípíḏí. Heḏihoˀ owáy navíˀpiye biwáybun dihayḏi nä́ˀin uví tíˀûuwin páaḏéˀin úmuuˀin ovâykhä̖geˀnamí heḏânho inbí wä̖yu̖ navíˀpiye shánkí dínkaypúuwíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter-di Jesus óetu̖ˀan, “Nanbí Sedó, naa okhâymuu u̖-áḏí dípansôege-íḏí heḏá díháyjíḏá.” ");
INSERT INTO tew_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus-di óetu̖ˀan, “Peter, nä́ˀin wítu̖ˀâ̖a̖mí: Nä́ˀi khun waˀ wí dee sen ikinpíḏíboˀ u̖-á powin untú̖u̖ní naa wíḏítaapíˀin.” ");
INSERT INTO tew_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ihayḏi Jesus iví khä̖geˀnin itu̖ˀan, “Hä̂nhay wâysan dihayḏi naví híˀ in tꞌowa ovâytꞌôeˀa̖míḏí, chä̖ˀdá heḏá wí múu unbí hä̖ä̖wí bînkuu-ígîˀ-á heḏá wây-á anto-á wívînhoˀpí. Ihayḏi ti wí hä̖ä̖wí úntáywän?” Heḏi óetu̖ˀan, “Joe, hä̖́ä̖bo joe.” ");
INSERT INTO tew_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Heḏáháˀ ovâytu̖ˀan, “Nää-á toˀwí ûnchä̖ˀkwꞌóˀdi-áho iví chä̖ˀ ihûuwí, heḏá wí múu-á ihä̖ä̖wíkuu-ígîˀ wáˀ, heḏi toˀwí wên tsijó pháˀ ûnkꞌóepîˀ-á iví kꞌéwéˀin to-á iku̖ˀpꞌâyní wên tsijó pháˀ ikuumä́-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Naaḏi wâytu̖máa nakhâyˀä̖ˀ nä́ˀi tun Jôesi Táḏáví taˀnin diwe naví̖ˀgeḏi nataˀmuuˀi napúuwíˀin: Tꞌowa ditú̖u̖ní i-á wáˀ wí jänäkíkandi-ân namuu gin. Hä̖ä̖wí tꞌä̖hkí naví̖ˀgeḏi nataˀmuuˀi-áho napuwagíˀo-ákun.” ");
INSERT INTO tew_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iví khä̖geˀnindi óetu̖ˀan, “Nanbí Sedó, námúˀḏí, nä́we wíje tsijó pháˀ.” Iˀḏi ovâytu̖ˀan, “Hä̖hay.” ");
INSERT INTO tew_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ihayḏáháˀ Jesus iˀ búˀḏí napee heḏi oe Olive Okú gin dâytu̖ˀoˀ iwepiye namää heḏá iví khä̖geˀnindá ûnwóemää. Iwáho hä̖́yä́n wänbo najiwän. ");
INSERT INTO tew_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Iwe dipówá ihayḏá ovâytu̖ˀan, “Úvíjûusuˀa̖mí heḏânho wovâytayindeˀ ihayḏi híwóhpí wíˀúvíˀa̖mípíḏí.” ");
INSERT INTO tew_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Heḏi ovâyjoeˀandi wí hây namää, wí kꞌuu bînsä̖ä̖yú-í iwehaybá, heḏi idégeˀdisógeḏi ginnân ijûusuˀan: ");
INSERT INTO tew_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Táḏá, undaˀḏáho in tꞌôephaḏe donkhâymáaˀin naa dînjâaˀa̖mí. Hewänbo háa u̖-á undaˀ waa tobá napúuwí, naa odaˀ waagá joe.” ");
INSERT INTO tew_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Heḏi wí makówáwi tꞌôepa̖ˀa̖a̖ˀi-á ivíˀwe ûnkwi̖nuḏee heḏi kay óemä́gi. ");
INSERT INTO tew_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Heḏi hânho itꞌôephaḏendeḏi shánkí kayˀindi ijûusuˀan, heḏi hânho naseepꞌojaaḏeḏi iˀ seepꞌo-á wí ûnpꞌoetä̖́ heˀendi waagibá nange ûntä́ndeˀ. ");
INSERT INTO tew_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Heḏáháˀ wáy ijûusuˀoˀ iweḏi iwí̖núḏí iví khä̖geˀnin dikwꞌôn diwepiye nawáymää. Indá hânho dikꞌáykháaḏá dikaykhanmuu, heḏiho dijókhá̖. ");
INSERT INTO tew_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Heḏi ovâyjóhsandi ovâytu̖ˀan, “Heháaḏan íjókhá̖? Bíshaaḏi úvíjûusuˀa̖mí heḏânho wovâytayindeˀ ihayḏi híwóhpí wíˀúvíˀa̖mípí.” ");
INSERT INTO tew_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Waˀḏi ihíˀmáaḏíbo báyékí tꞌowa dipówá. Judas-di ovâypáaḏémáˀ, i-á wêe in tä̖ˀḏi wíje khä̖geˀnin diweḏiˀiˀbá namuu, heḏi Jesus nawin diwepiye namää óepꞌohtsä̖ä̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Hewänbo Jesus-di óetu̖ˀan, “Judas, ti naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀi dípꞌohtsä̖ä̖ nä́ˀin tꞌowaví mange díkáaníḏí?” ");
INSERT INTO tew_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Háa Jesus óekhâymáaˀin iví khä̖geˀnin i-áḏí dijiˀin dâymûˀ, heḏi óetsikaˀyan, “Nanbí Sedó, ti nanbí tsijó pháˀḏí hä̖ˀin tꞌowa âyyâ̖a̖-í?” ");
INSERT INTO tew_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wí wêe iví khä̖geˀnin diweḏi iví tsijó pháˀḏí iˀ owhaˀ pꞌóˀḏéḏîˀví tꞌôeˀi pꞌóˀḏé óewhä̖́ḏi, heḏi iví koˀḏíngéḏíwin oje heˀyinboˀ ôntꞌó̖ˀtsꞌâˀ. ");
INSERT INTO tew_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hewänbo Jesus-di ovâytu̖ˀan, “Wíyá haˀwâa wíˀúvíˀa̖mípí,” heḏi iˀ senbí oje ônwáykíḏiḏi ûnwówa. ");
INSERT INTO tew_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nä́ˀin diˀä̖ä̖ˀin Jesus óekáyjíḏí in owhaˀ pꞌóˀḏéḏíˀindá heḏá iˀ hayˀi méesatewin sundaḏoví tsonnindá heḏá wây-á Huḏíyoví tsonnindá dimuu. Jesus-di ovâytsikaˀyan, “Heháaḏan unbí tsijó pháˀ wóegé unbí phé wóegá íˀä̖ä̖ naa díyâ̖a̖-íḏí wí jänäkíkandiˀ omuu waagibá? ");
INSERT INTO tew_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Thamuwaagi iˀ méesate hayˀi ee naa undáḏí ojiˀ, heḏi wíḏípankêˀpí. Hewänbo nää-á ihayḏihoˀ un únná nä́ˀin úvíˀa̖míḏí, heḏá iˀ Penísendi-á ihayḏiho ûnná iví kay ikeeya̖míḏí, i-á wáy tꞌowa dínkhunnáˀ diwe natsonjiˀi-á namuu.” ");
INSERT INTO tew_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesus óepankêˀḏi iˀ owhaˀ shánkí pꞌóˀḏéḏîˀví tewhá eepiyeˀ óehoˀ, heḏi óetsꞌúḏe. Waˀ óehon dihayḏi Peter-á tíˀúugá kayi̖ˀdiḏibo-á nawóemän. ");
INSERT INTO tew_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Iˀ tewháví tehpaa búge wáy ho naphahteˀen, heḏi i̖ˀge wên tꞌowa dívíkwꞌóḏi. Peter-á inbí jâa isóge. ");
INSERT INTO tew_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iwe naˀä́ndí phaaḏi óekonámäˀ heḏi wí tꞌôeˀi aˀyú̖ḏí óeḏamúndeḏi natú̖, “Nä́ˀi sennânkun Jesus-áḏíbá najiwän.” ");
INSERT INTO tew_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hewänbo Peter natú̖, “Joe, naaḏá wíḏótaapí.” ");
INSERT INTO tew_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hây napóe ihayḏá wíyá toˀwíḏá Peter-á óemûˀḏá óetu̖ˀan, “In Jesus-víˀin diweḏi unmuu-ákun.” Hewänbo Peter-di óetu̖ˀan, “Joe, naa-á joe.” ");
INSERT INTO tew_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Heḏi maˀ wí óḏa naphaḏe ihayḏá wíyá wêe-á kayˀindi natú̖, “Nä́ˀi sendá Galilee-wibá namuuḏi taˀgendi Jesus-áḏíbá najiwän.” ");
INSERT INTO tew_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hewänbo Peter-di óetu̖ˀan, “Naa wíḏînhanginnáhpí hä̖ä̖wí i̖ˀgeḏi bihíˀmáaˀin.” Waˀḏi ihíˀmáa ihayḏibo wí dee sen ikin. ");
INSERT INTO tew_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ihayḏibá tewhá íveḏi Nanbí Sedó Jesus ibéeḏí Peter óeḏamûˀ, heḏi Peter ûnˀánpówá háa Jesus-di óetu̖ˀan waa: “Thaˀdi héḏéndí waˀ iˀ dee sen ikinpíḏíboˀ, powin untú̖u̖ní naa wíḏítaapíˀin” gin ho óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Heḏi Peter iˀ tehpaa jáˀwépiye napeeḏi hânho isíhtä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","In senäˀ Jesus óeˀá̖yînmáaˀindi tꞌä̖mäge óetu̖máa heḏá óemahpúudeˀ. ");
INSERT INTO tew_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Heḏá óetsíwhiˀandi óetu̖ˀan, “U̖-á úhanginná háa napuwagíˀoˀin waˀ napóepíḏíboˀ. Dítu̖ˀan, toˀḏan wóemahpúu?” ");
INSERT INTO tew_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Heḏá wíyá shánkílilee-wibá namuuḏi taˀgendi Je tꞌä̖mäge háa óetu̖máa. ");
INSERT INTO tew_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Waˀḏéeḏí nanân dihayḏi in Huḏíyo tsonnindá in owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá dívíwéˀgeˀan, indá in Huḏíyoví tunjowaˀ dimuu, heḏi Jesus in tunjowaˀ wháagépiye óehoˀ, ");
INSERT INTO tew_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","heḏi óetsikaˀyan, “Ti taˀgendi u̖-ân unmuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí? Dítu̖ˀan.” Iˀḏi ovâytu̖ˀan, “Wâytu̖ˀan wänbo háˀto dînwä̖ä̖yú̖-í, ");
INSERT INTO tew_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","heḏi naaḏá undá hä̖ä̖wí wâytsikaˀyandá háˀto hä̖́ä̖bo dítꞌôeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hewänbo nää iweḏi páaḏépiye naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀi Jôesi Táḏáví koˀḏíngéḏí ochangíˀo, i-á tꞌä̖hkí kay imáaˀi namuu.” ");
INSERT INTO tew_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Heḏáháˀ tꞌä̖hkíḏíbo óetsikaˀyan, “Ti untundaˀ u̖-ân Jôesi Táḏáví ay unmuuˀin?” Iˀḏi ovâytu̖ˀan, “Háa unbo ítú̖ waa.” ");
INSERT INTO tew_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Heḏáháˀ dívítu̖ˀan, “Wây-á toˀwên wígíntáypí iví̖ˀgeḏi dítu̖ˀâ̖a̖míḏí. Iví sópho iweḏibo nä́ˀi tun gip itꞌoe.” ");
INSERT INTO tew_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Heḏi in tunjowaˀ tꞌä̖hkí dívíwí̖nú, heḏi indiho Jesus oe Pilate-víˀpiye óehoˀ. ");
INSERT INTO tew_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Heḏi Pilate-víˀwe óekándí ôntꞌaywóˀdichä̖nundeḏi ditú̖, “Nä́ˀi sendá nanbí tꞌowa ovâytꞌeˀyaˀdoˀ, heḏá iˀḏi ovâytu̖ˀan Caesar wíˀóe-tax-wáˀâa-ípí, heḏá wáˀ natú̖ i-á namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, heḏânho natundaˀ wí tsondi hayˀibá namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate-di Jesus óetsikaˀyan, “Ti u̖-á in Huḏíyoví tsondi hayˀi unmuu?” Jesus-di óetu̖ˀan, “Háa u̖ˀbo untú̖ waa.” ");
INSERT INTO tew_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate-di in owhaˀ pꞌóˀḏéḏíˀin heḏá in báyékí tꞌowa iwe diwinnindá ovâytu̖ˀan, “Nä́ˀi sendá naaḏi wên tꞌaywóˀnin wänbo wíḏônshaapí.” ");
INSERT INTO tew_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hewänbo indá kayˀindi Pilate óetu̖máa, “Iˀḏá iví há̖hkan ûnmuuˀiˀḏi nanbí tꞌowa ovâytꞌeˀyaˀdoˀ. Oe Galilee nange iwe páaḏé gin itsꞌanˀan, iweḏá Judea nange i̖ˀgá tꞌä̖hká, heḏá nää-á nä̂äwá napówá hanbá iˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate nä́ˀin natꞌoeḏi ovâytsikaˀyan, “Ti nä́ˀi sendá Galilee-wi namuu?” ");
INSERT INTO tew_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Heḏi “hoi” gin ditú̖ ihayḏi Pilate-di Jesus oe Herod-víˀpiye óesan, gá Herod-dá oe Galilee pꞌóˀḏéḏîˀ namuuḏân, heḏi nää-á oe Jerusalem-dá naˀä́n. ");
INSERT INTO tew_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod nahíhchanpóe Jesus óemûˀḏi. Gáhä̖̂ä̖ḏibo napu̖wä̖daˀ, iví̖ˀgeḏiho natꞌoeḏi, heḏiho nadaˀ Jesus-di wên pínnán ônˀa̖míḏí imúuníˀin. ");
INSERT INTO tew_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod-di báyékí tsika óetsikaˀyan, hebo Jesus-dá háabo wíˀóetu̖ˀanpí. ");
INSERT INTO tew_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","In owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá iwe diwindi kaygindi Jesus ônhíwóhpíchä̖nundeˀ. ");
INSERT INTO tew_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heḏi Herod-dáḏí in sundaḏo-áḏí tꞌä̖mäge Jesus óeˀoˀ, heḏáân, heḏi jänäkí-á i-áḏá dimuu. Herod-dá ovâytu̖ˀan wên saˀwóˀnin kꞌéwéˀin to Jesus óeˀaawé-í, heḏáháˀ Pilate-víˀpiye óewáysan. ");
INSERT INTO tew_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Páaḏé ihayḏibo Herod-áḏí Pilate-áḏí hä́nmindá damuuwän, hebo ihay thaabá híwóˀnin kꞌemaˀindá dapóe. ");
INSERT INTO tew_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate-di in owhaˀ pꞌóˀḏéḏíˀindá heḏá in wéˀgen Huḏíyoví pꞌóˀḏéḏíˀindáḏí wây-á tꞌowa-áḏí ovâywéˀgetu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","heḏi ovâytu̖ˀan, “Undá nä́ˀi sen naví páaḏépiye dînmaa, heḏi dítu̖ˀan tꞌowa ovâytꞌeˀyaˀdoˀin. Unbí páaḏépiyebo naaḏi iví̖ˀgeḏi dótsikaˀyan, hebo háawin tꞌaywóˀnin bînchä̖nunde wänbo wíḏônshaapí. ");
INSERT INTO tew_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod-di wänbo-á háawin wên tꞌaywóˀnin wíˀônshaapí, heḏiho nanbíˀpiyebá óewáysan. Nä́ˀi sendá hä̖ä̖wí híwóhpí wíˀiˀanpí óeháyjíḏí. ");
INSERT INTO tew_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Heḏiho otsonpúuwí púwhí̖ˀdí óewhä̖́ä̖níˀin heḏáháˀ dómaˀpꞌä̖̂ä̖ḏi-í.” ");
INSERT INTO tew_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pa̖a̖yo pꞌóe waa iˀ Passover shánkíˀeeḏi nanáˀ dihayḏi Pilate-di wêe pan óemaˀpꞌä̖́ḏíndeˀ, heḏânho gin natú̖. ");
INSERT INTO tew_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hewänbo tꞌä̖hkí in tꞌowa dívítu̖wí̖nú, “Nä́ˀi sen náheˀ, heḏi Barabbas-á naˀingîˀ nâamaˀpꞌä̖̂ä̖ḏi-í.” ");
INSERT INTO tew_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas-á oe pan diwe óesóge gá in tꞌowa iˀ búˀ iweˀin pꞌóˀḏéḏíˀindáḏí ovâytsa̖a̖kannandân, heḏá iˀḏá ovâytꞌowatꞌahá̖nú.) ");
INSERT INTO tew_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Hewänbo Pilate nadaˀ Jesus óemaˀpꞌä̖̂ä̖ḏi-íˀin, heḏiho in tꞌowa wíyá ovâyhéeˀan. ");
INSERT INTO tew_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hebo indá ihayḏa̖ˀ dívítu̖wí̖núndeˀ, “Wên phéˀwin deeḏi nátꞌóhtä̖gekꞌuˀꞌꞌ” ");
INSERT INTO tew_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate-di powingeḏi ovâytu̖ˀan, “Háaḏan gin dóˀa̖mí? Háawin yä̖ˀḏâapíˀinnan iˀan? Naaḏi háawin tꞌaywóˀnin wänbo wíḏônshaapí óeháyjíḏí. Heḏiho otsonpúuwí púwhí̖ˀdí óewhä̖́ä̖níˀin heḏá dómaˀpꞌä̖̂ä̖ḏi-í.” ");
INSERT INTO tew_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hewänbo kaygindi iheˀjiḏiḏa̖ˀ ditû̖ˀ Pilate-dá Jesus phéˀwin deeḏi óetꞌóhtä̖gekꞌúuwíˀin, heḏi hânho dívítu̖wí̖núndeḏiho ditꞌanpóe. ");
INSERT INTO tew_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilate nahíje háa óedaaˀan waa iˀa̖míḏí, ");
INSERT INTO tew_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","heḏiho Barabbas, iˀ sen in tsonnin ovâyyâ̖ˀiˀ heḏá ovâytꞌowatꞌahá̖núˀiˀ namuuˀiˀ óemaˀpꞌä̖́ḏi, hewänbo natsonpóe Jesus óeˀa̖míˀin háa didaˀ waa. ");
INSERT INTO tew_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Heḏáháˀ Jesus iweḏi óehoˀ. Dimän dihayḏá wí sen Cyrene nangewi namuuˀiˀ, Simon gin nakhá̖wä̖́ˀiˀ, oe nava iweḏi iˀ búˀ eepiye naˀä̖ḏi óejay, heḏi in sundaḏoḏi in phéˀwin ivîˀḏi ônˀíˀkꞌûˀḏi Jesus-ví tíˀúugé óepu̖ˀnan. ");
INSERT INTO tew_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Báyékí tꞌowa wáˀ Jesus ûnwóemän, heḏá wên kwiyä̖ˀ dimännindá hânho ditaachanpóeḏá dívípí̖hkhú̖mahpúuḏeˀ, heḏá háa iphaḏendeˀin namuuḏi diséejiˀ. ");
INSERT INTO tew_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus ibéeḏí ovâytu̖ˀan, “Un kwiyä̖ˀ Jerusalem-win, naa omuuḏi wíˀúvísíhtä̖ä̖-ípí, hewänbo ungîˀ-á unbí áyyä̖̂ä̖gîˀ-á úvísíhtä̖ä̖-í. ");
INSERT INTO tew_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wáy wí thaa nanáˀ dihayḏi tꞌowa ditú̖u̖ní ‘Híhchan dâymáˀve-í in dínkoḏipíˀin dívíˀâyya̖míḏí, heḏá in hä̂nhay wänbo dívíˀayyanpíˀindá wí ay wänbo dâyˀâytsä̖ä̖ˀanpíˀindá wáˀ híhchan dâymáˀve-í.’ ");
INSERT INTO tew_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ihayḏáho in Jerusalem-ˀin tꞌowa didaˀí iˀ pꞌin inbîˀḏi nakaanú-íˀin heḏá iˀ okúḏá ovâykhä̖ˀkwꞌôeníˀindá. ");
INSERT INTO tew_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Naa wên tay wówáˀin waagiˀbá omuuˀi híwóhpí dînpoeˀo. Hewänbo indá tay tꞌaaˀi waaginbá dimuuḏi shánkí pꞌä́ndíkí dínpuwagíˀo.” ");
INSERT INTO tew_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Heḏá wây-á wíje senäˀdá Jesus-áḏíbá ovä̂nhon ovä̂nháyjíḏí. Nä́ˀin senäˀdá jänäkíkanninnân damuu. ");
INSERT INTO tew_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Heḏi wên okú iwe dipówá, “In pꞌóhkhú̖bay” gin dâytu̖ˀoˀ, heḏi Jesus phéˀwin deeḏi óetꞌóhtä̖gekꞌûˀ, heḏá in wíje jänäkíkannindá wáˀ hanbá ovä̂nˀan. Wêe Jesus-ví yä̖́ˀmä́ngéḏí óewí̖nú heḏá iˀ wêe-á iví koˀḏíngéḏá. ");
INSERT INTO tew_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Heḏi Jesus natú̖, “Táḏá, ovâyˀowóejé-í, háa dívíˀoˀin wíḏínhanginnáhpíḏí.” In sundaḏo-á dívíˀáywan iví aa dívíweejé-íḏí. ");
INSERT INTO tew_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","In tꞌowa iví núˀ iwe diwindi óemúndeˀ, heḏá in Huḏíyo pꞌóˀḏéḏíˀindá tꞌä̖mägá óetu̖máa. Ditû̖ˀ, “Piˀwêndá iˀḏi ovâyˀaywon, heḏi i-á iˀ toˀwí Jôesi Táḏáḏí tꞌowa ovâyˀaywoeníḏí óesógeˀiˀ namuuḏá, wíˀbo ipiˀaywoeníˀin ûnkhâyˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Heḏi in sundaḏoḏi wáˀ tꞌä̖mäge háa óeˀoˀ. Ivíˀpiye dimääḏi wí méena ojohayˀi-á ônpä̖htuye, ");
INSERT INTO tew_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","heḏi óetu̖ˀan, “In Huḏíyoví tsondi hayˀi unmuuḏá wíˀbo ópiˀaywon.” ");
INSERT INTO tew_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wên phépháˀay iví phéˀwin kwꞌáye natꞌiˀkꞌóe eeḏi ginnân nataˀmuu: “Nä́ˀi-á in Huḏíyoví tsondi hayˀi namuu.” ");
INSERT INTO tew_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wêe tꞌaywóhkandiˀ phéˀwin deeḏi nawhiˀwondiˀḏi óejänäkítu̖máaḏí, óetu̖ˀan, “Untú̖hpíˀan u̖-ân unmuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. Heḏáho wíˀbo ópiˀaywon, heḏá naˀindá wáˀ dînˀaywoení.” ");
INSERT INTO tew_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hebo iˀ wêe natú̖, “Haˀwâa wívihéeˀa̖mípí. Ti Jôesi Táḏá oe makówá naˀä́ndiˀ wínâaˀaˀginpíˀan? Nä́ˀi sen óetuhchä̖nunde waagibá u̖ wáˀ wóetuhchä̖nundeˀ, ");
INSERT INTO tew_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","heḏi u̖-áḏí naa-áḏí dítuhchä̖nundeḏi híwó namuu, gá híwóhpí ä́nˀandi nanbí tuhchä̖nu-á gä́nˀä̖ä̖ḏân. Hebo nä́ˀi sendá háabo híwóhpîˀ wíˀiˀanpí.” ");
INSERT INTO tew_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Heḏáháˀ Jesus óetu̖ˀan, “Jesus, owáy unpꞌóˀḏéḏîˀsogeḏeeḏi unwáyˀä̖ä̖ ihayḏi naa wíḏíˀóḏéˀnípí.” ");
INSERT INTO tew_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus-di óetu̖ˀan, “Nä́ˀin wítu̖ˀâ̖a̖mí, nää thaa-á owáy tꞌä̖hkí saˀwó nanáˀ diwe naa-áḏí unchaní.” ");
INSERT INTO tew_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Taagepiye iwáypiye naná, hebo iˀ than namuwä̖hán, heḏi i̖ˀge tꞌä̖hkí nakhunpóe thíˀêeḏi poje puwahay. ");
INSERT INTO tew_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ihayhä̖̂ä̖bá in aa nakhaanáˀnin iˀ méesate hayˀi khóˀjé nawhiˀwonnindá pínu-á nasiveḏee. ");
INSERT INTO tew_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Heḏáháˀ Jesus kaygi natú̖, “Táḏá, naa uví mange dáymäˀ, naví pꞌoewa̖a̖hâ̖a̖ dînkeˀ.” Heḏi gin natú̖ ihayḏiho tꞌä̖ˀgeḏi ihâ̖a̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iˀ sundaḏo pꞌóˀḏeḏîˀ iwe nawindi háa napóeˀin imûˀḏi Jôesi Táḏá kwꞌáayéboˀ óemáa, heḏi natú̖, “Taˀgendi nä́ˀi sendá iví wówátsi taˀge ihon.” ");
INSERT INTO tew_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","In báyékí tꞌowa iwe dikꞌaapu̖wä̖winnin háa napóeˀin dâymûˀḏi inbíˀpiye dívíweehoˀ, heḏi inbí pí̖hkhú̖ dâymahpúuḏe ditaachanpóeḏí. ");
INSERT INTO tew_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Hebo wáy wên kwiyä̖ˀ Galilee nange iweḏi Jesus-áḏí diˀä̖ä̖ˀin, heḏá wây-á tꞌowa iví kꞌemaˀin ûnmuuˀindá, kayi̖ˀ diwebo diwin dâymúndeḏi. ");
INSERT INTO tew_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Wí sen Joseph gin nakhá̖wä̖́ˀi wáˀ iwebá najiˀ, oe Judea nangewi búˀay iweˀi-ân namuu, Arimathea gin dâytu̖ˀoˀiˀ. I-á iví wówátsi taˀge ihon, heḏi natsíkhajiˀ Jôesi Táḏáḏí óesôege-íḏí iˀ toˀwí tꞌowa ovâyˀaywoeníˀiˀ. I-á wínachanpóepí híwóˀnin namuuˀin háa in Huḏíyo tunjowaˀ dívíˀánshaamä́giˀindá heḏá dívíˀannindá Jesus óeháyjí gin ditú̖ ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Heḏiho Jesus nachuu ihayḏi Joseph oe Pilate-víˀpiye namää óedaaˀa̖míḏí iˀ pení óemä̂äníḏí óekhä̖ˀkꞌúuwíḏí. ");
INSERT INTO tew_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Heḏi óemä́giḏi in phéˀwin diweḏi óewá̖ve, heḏá wên híwóˀnin aa iwá óeˀánkꞌûˀ, heḏi wí khä̖hkugîˀ pho ee óekꞌûˀ, iˀ tꞌowáwi kꞌuu iwe dâytsꞌâˀiˀ, iwá waˀḏi tóebo wíˀóekhä̖ˀkꞌûˀpí. ");
INSERT INTO tew_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iˀ thaa-á in Huḏíyo dívíhä̖ä̖wíkhâyˀoˀ kaykhanwówá thaagîˀ, heḏi iˀ kaykhanwówá thaa-á ho napowaˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","In kwiyä̖ˀ Jesus-áḏí oe Galilee nangeḏi diˀä̖ä̖ˀindá Joseph-á ûnwóemää, heḏi háa Jesus oe tꞌowápho ee óekꞌûˀ waa dâymûˀ. ");
INSERT INTO tew_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Heḏi inbíˀpiye diwáymää, heḏi wí saˀwó nasundi woe-áḏí ka̖ˀpꞌoe-áḏí dâykhâyˀan iˀ pení óeˀä̖ä̖yú̖-íḏí. Hebo wíyá tháwä́n iˀ kaykhanwówá thaa nanândi wíḏívítꞌôeˀanpí in Huḏíyoví khuu dínmuuḏi. ");
INSERT INTO tew_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wíyá tháwä́ndá Dumîngu naná, heḏi nathamupuwaˀä̖ˀ ihayḏi in kwiyä̖ˀ i penípho iwepiye diwáymää i saˀwó nasundi woe dâykhâyˀandi wóegé. ");
INSERT INTO tew_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Iwe iˀ kꞌuu iˀ tꞌowápho iweḏi ho nahângemuuḏi dâymûˀ, ");
INSERT INTO tew_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","heḏiho ee ditsꞌú̖, hebo Nanbí Sedó Jesus natꞌahándi wíḏâyshaapí. ");
INSERT INTO tew_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Iwe diwänpiwindi wíḏínhanginnáhpí háa dívíˀánshaaˀa̖míˀin. Ihayḏi tsíkhagipí wíje senäˀ waabá dä́ncha̖a̖ˀin inbí núˀ dakwi̖nuḏee, hânho otsꞌáˀiḏa̖ˀ daˀaˀwennin. ");
INSERT INTO tew_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","In kwiyä̖ˀ hânho dikhunwôedaˀḏi dívíwänpipꞌóˀtꞌá̖ä̖, heḏi in senäˀdi ovâytu̖ˀan, “Heháaḏan wí nawówájiˀiˀ in pení ovâykhä̖ˀkwꞌóeˀó ee bîntu̖wä̖máa? ");
INSERT INTO tew_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesus-á nä́we wínakꞌóepí, i-á nawáywówápóe-á. Ti wíˀúnˀánshaapíˀan háa wovâytu̖ˀannin waˀ oe Galilee najiˀ ihayḏi? ");
INSERT INTO tew_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ginnân natú̖: ‘Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀi-á in yä̖ˀḏâapíˀin tꞌowaví mange díkáaní. Heḏá phéˀwin deeḏá díkheˀkhâymáa, hewänbo iweḏi iˀ powageˀi thaa iwe owáywówápuwagíˀo.’ ” ");
INSERT INTO tew_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ihayḏi in kwiyä̖ˀ dínˀánpówá háa Jesus-di ovâytu̖ˀannin, ");
INSERT INTO tew_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","heḏi iweḏi dimääḏi in tä̖ˀḏi wêe Jesus-ví khä̖geˀnindá heḏá wây-á iví kꞌemaˀindá háa napóeˀin ovâytꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nä́ˀinnân dimuu in kwiyä̖ˀ: Mary Magdalene-dá heḏá Joanna-á, heḏá wíyá Mary-á, James-ví jíyá ûnmuuˀiˀ, heḏá wây-á kwiyä̖ˀdá wáˀ indáḏí dijiˀ. ");
INSERT INTO tew_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hewänbo Jesus-ví khä̖geˀnin diˀân háa in kwiyä̖ˀdi ovâytu̖ˀan waa wä̖yu̖pîˀ híˀḏa̖ˀmân namuuˀin, heḏiho háa ditú̖ˀin wíḏívíwä̖yu̖pí. ");
INSERT INTO tew_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hewänbo Peter-á napeeḏi iˀ penípho iwepiye iˀä̖ä̖, heḏi itꞌä̖́ä̖ḏí itsíhkíḏi, heḏi wí aaḏa̖ˀ Jesus naˀánmúˀdeˀiˀ imûˀ, heḏi ivíˀpiye nawáymääḏi naˀándeˀ, “Hân hîn napóe?” ");
INSERT INTO tew_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Iˀ thaabá-á wíje Jesus-ví kꞌemaˀin wí búˀaypiye damän, iwá Emmaus gin dâytu̖ˀoˀ, i-á maḏi tsé ihay míya-á Jerusalem-di naná. ");
INSERT INTO tew_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","In wíje nä́ˀi háa napóe i̖ˀgeḏi wíˀbo dänhíˀmáa, heḏi däntsikaˀmáa “Háaḏangú nä́ˀi tꞌä̖hkí gin napóe?” Jesus-di ovä̂nkáa, heḏi indáḏíbá namää. ");
INSERT INTO tew_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hewänbo indá wíˀóetaapí, inbí tsée iweḏi dä́nkaapóeḏí. ");
INSERT INTO tew_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Heḏi Jesus-di ovä̂ntsikaˀyan, “Hä̖ä̖ i̖ˀgeḏan hânho jashawóˀ dänhíˀmáa damändi?” In wíje däntsiˀwóyí̖ˀ heḏi daboˀaatsꞌaymuu, ");
INSERT INTO tew_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","heḏi iˀ wêe Cleophas gin nakhá̖wä̖́ˀiˀḏi óetu̖ˀan, “U̖ˀḏa̖ˀmân kavêe tꞌä̖hkí in oe Jerusalem diˀáḏâajiˀin diweḏi wíˀúhanginnáhpí háa nä́ˀi phaḏe thaa eeje napoeˀoˀin.” ");
INSERT INTO tew_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesus-di ovä̂ntsikaˀyan, “Hân handi napoeˀo?” Óetu̖ˀan, “Gá Jesus oe Nazareth-wi háa ûnpóeˀinnân. I-á Jôesi Táḏáví tukheˀbi ûnmuu, heḏi Jôesi Táḏá-áḏí heḏá in tꞌowa-áḏí dâymûˀ iví híˀ-á iví tsiyekandá ûnkayˀin. ");
INSERT INTO tew_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nanbí owhaˀ pꞌóˀḏéḏíˀindá heḏá wây-á nanbí tsonnindá in Rome-winbí mange Jesus óekán heḏânho indá óetuhchä̖nuḏi óeháyjíḏí, heḏiho phéˀwin deeḏi óetꞌóhtä̖gekꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hewänbo naˀindá giˀân i-ân iˀ namuu naˀin Israel-ˀin dímahpä̖ḏikhâymáaˀiˀ. Heḏi nää thaa-á iˀ poje thaa-áho naná han napóe iweḏi. ");
INSERT INTO tew_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Heḏá wáˀ wên kwiyä̖ˀ naˀinbíˀweḏi dimuuˀindi dítu̖ˀan wên háawên naˀin díháaˀannin. Héḏéndí héˀḏibo ee Jesus óekhä̖ˀkꞌûˀ iwáygé dijiˀ, ");
INSERT INTO tew_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","hewänbo wíˀóeshaapí. Diwáyˀä̖ä̖ḏi ditú̖ wên makówáwin tꞌôepa̖ˀa̖a̖ˀin inbíˀpiye dakeepóeḏí ovâytu̖ˀan Jesus-á nawówájiˀin. ");
INSERT INTO tew_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wáy wên naˀindáḏí dijiˀin iˀ penípho iwepiye dimää, heḏi háa in kwiyä̖ˀ ditú̖ waa dâymûˀ, hewänbo Jesus-á wíḏâymûˀpí” gin in wíjeḏi Jesus óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ihayḏáháˀ Jesus-di ovä̂ntu̖ˀan, “Undá ánshaapíˀin damuu, heḏá dawä̖yu̖kâymuuḏi tꞌä̖hkí háa in Jôesi Táḏáví tukheˀmin ditú̖ waa wíḏänwä̖yundepí. ");
INSERT INTO tew_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ditú̖hpíˀan iˀ toˀwí Jôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí taˀgendi nä́ˀi hä̖ä̖wí itꞌôephaḏekhâymáaˀin, heḏáháˀ ên naˀin díháaˀannin. Héḏéshánkí tsondi hayˀi-á óepaˀí.” ");
INSERT INTO tew_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Heḏi Jesus-di háa Jôesi Táḏáví taˀnin diwe iví̖ˀgeḏi natû̖ˀnin tꞌä̖hkí ovä̂nthayyan. Háa Moses natú̖ˀin páaḏé ovä̂ntu̖ˀan, iweḏáháˀ in Jôesi Táḏáví tukheˀmindá in wéˀgen taˀkannindá háa ditú̖ˀindá. ");
INSERT INTO tew_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Iˀ búˀay dimän diwe tsowa dipowamän, heḏi Jesus-á waˀḏi wíyá wáypiye namän waagibá iˀan. ");
INSERT INTO tew_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hewänbo óepunmä̂äníˀin wíḏadaˀpí, heḏihoˀ óetu̖ˀan, “Naˀindáḏí ówóyí̖ˀ. Hä̖̂ä̖ḏanho napuwamän, nathaaphaḏemänhoˀ.” Heḏiho indáḏí iˀ tewhá ee natsꞌûndi iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Indáḏí nahúuˀä́n dihayḏi iˀ pává ikêˀḏi ikú̖ˀdaaˀan, heḏá iháve, heḏá ovä̂nmä́gi. ");
INSERT INTO tew_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ihayḏibá datsíwaaḏee waa dapóe, heḏiho toˀwí namuuˀin dä̂ntaa, hewänbo wesebo wíyá wínakeepóepí. ");
INSERT INTO tew_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Heḏi däntu̖máa, “Oe pꞌóegé gimän dihayḏi, Jôesi Táḏáví híˀ i̖ˀgeḏá dînthayjoḏi, nanbí pín kaygi gä́nˀa̖ˀyä̖póepíˀan.” ");
INSERT INTO tew_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wesebo oe Jerusalem-piye dawáymää, heḏi Jesus-ví tä̖ˀḏi wêe khä̖geˀnindáḏí heḏá wây-á wên diwéˀgekwꞌôndáḏí dä̂nshaa. ");
INSERT INTO tew_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nä́ˀin diwéˀgekwꞌóˀnindi ovä̂ntu̖ˀan, “Nanbí Sedó Jesus-á taˀgendi nawáywówápóe, heḏi Simon Peter-bíˀpiye nakeepóe.” ");
INSERT INTO tew_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ihayḏáháˀ in wíjeḏi ovâytu̖ˀan háa napóeˀin ee pꞌóegé damän dihayḏi, heḏá háḏíḏí Nanbí Sedó Jesus dä̂ntaaˀindá iˀ pává iháve ihayḏi. ");
INSERT INTO tew_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Waˀḏi dänhíˀmáa ihayḏibo Jesus-á inbí páaḏépiyá nakwi̖nuḏee, heḏi ovâytu̖ˀan, “Ánshaaginpíḏíboˀ íkwoní.” ");
INSERT INTO tew_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hânho ovâypíhä̖ä̖ḏi diˀân wí pꞌoewa̖a̖hâ̖a̖-ân dínkeepóeˀin. ");
INSERT INTO tew_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Hewänbo Jesus-di ovâytsikaˀyan, “Heháaḏan íkhunwôedaˀ? Háaḏan íˀándeˀ maḏi naa taˀgendi wóˀmuupíˀin? ");
INSERT INTO tew_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Naví mandá naví ândá dînmúˀḏí. Naa-ânkun omuu. Dítä̖ä̖gé-í, heḏânho únhanginnáaní wí pꞌoewa̖a̖hâ̖a̖ wóˀmuupíˀin. Naa tûu-á phéhkhú̖-á omuu. Wí pꞌoewa̖a̖hâ̖a̖-á haˀwâaˀi wínamuupí.” ");
INSERT INTO tew_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Heḏi haˀwâa natú̖ ihayḏá iví mandá iví ândá ovâykeeyan. ");
INSERT INTO tew_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hânho dihíhchan wänbo ovâyháaˀan, heḏá kâyˀindá dínpoeˀo dívíwä̖ä̖yú̖-íḏí háa natú̖ˀin. Iˀḏi ovâytsikaˀyan, “Ti koegîˀ hä̖ä̖wí nä́ä únsaa?” ");
INSERT INTO tew_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Heḏiho wí paa natseemuuˀiˀ óemä́gi, heḏi inbí páaḏépiyebo ikꞌoe. ");
INSERT INTO tew_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ihayḏáháˀ ovâytu̖ˀan, “Undáḏíbo waˀ ojiˀ ihayḏi naaḏi wâytu̖ˀan hä̖ä̖wí Jôesi Táḏáví taˀnin diwe natû̖ˀdi-áho nakhâyˀä̖ˀ napúuwíˀin, tꞌä̖hkí háa Moses itaˀnandi-á, Jôesi Táḏáví tukheˀmin ditú̖ˀi-á, heḏá iˀ Psalms gin dâytu̖ˀoˀ iwe nataˀmuuˀi-á.” ");
INSERT INTO tew_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Heḏi ovâykhä̖geˀnan híwó dikaˀpóewíḏí háa Jôesi Táḏáví taˀnin diwe nataˀmuuˀin. ");
INSERT INTO tew_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ovâytu̖ˀan, “Nä́ˀi tundáho nataˀmuu: Iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí itꞌôephaaḏé-í nachuu píhay, hedi iweḏá iˀ powageˀi thaa iwá nawáywówápúuwí, ");
INSERT INTO tew_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","heḏi i-á natsonpúuwí páaḏé in Jerusalem-win heḏá iweḏá wéngé tꞌä̖hkíˀin tꞌowa-á ovâytu̖ˀâ̖a̖mí inbí tꞌaywóˀdi dâyjoeˀa̖mí heḏânho ovâyˀowóejé-íḏí, gin nataˀmuu. ");
INSERT INTO tew_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Heḏi undá nä́ˀi hä̖ä̖wí bînmûˀ i̖ˀgeḏi tꞌowa bîntꞌôeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Heḏi nää iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ unbíˀpiye wâysaaní, i-á naví Táḏáḏí wovâytu̖ˀan wovâymä̂äníˀin. Hewänbo nä́ä Jerusalem-bo úvíwóyí̖ˀní unbí kay oe makówáḏí wovâymä́gi píhay.” ");
INSERT INTO tew_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Heḏáháˀ Jerusalem diweḏi ovâypiyeḏi iˀ búˀay Bethany gin dâytu̖ˀoˀ iwehay ovâyhoˀ, heḏi ikhóhtegeḏi Jôesi Táḏá óedaaˀan híwó ovâyˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Waˀ gin iˀoḏiboˀ inbíˀweḏi iwijeḏi oe makówápiye napee. ");
INSERT INTO tew_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Indá dívídégeˀdikwꞌóḏi óeˀaˀginmä̂äníḏí, heḏáháˀ oe Jerusalem-piyá hânho híhchandi diwáymää. ");
INSERT INTO tew_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Oe méesate hayˀi eebo ihayḏa̖ˀ dimääˀä̖ heḏá ditû̖ˀ Jôesi Táḏá-á hayˀi namuuˀin.");
INSERT INTO tew_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hä́nˀoe tsꞌanpáaḏé nanân diwe i toˀwí In Tu̖u̖ gin nakhá̖wä̖́ˀi nayihoˀ. I-á Yôesi Táḏá-áḏí nayiˀ, heḏi i-á Yôesibá namuu. ");
INSERT INTO tew_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","I-áho oe tsꞌanpáadé nanân diwe Yôesi Táḏá-áḏí nayiˀ. ");
INSERT INTO tew_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hä̖ä̖wí tꞌä̖hkí ikhíyé, heḏi i-á wíˀikhíyépíḏá hä̖́ä̖bo wínakhíˀyenpí. ");
INSERT INTO tew_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","I-á wíˀbo wówátsi napä̖yiˀ, heḏi nä́ˀin wówátsi-á ko nakeepoˀ tꞌowagîˀ waagiˀbá namuu. ");
INSERT INTO tew_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nä́ˀi ko nakhu̖u̖náˀ dee nakeepoˀ, heḏi hä̖̂ä̖ḏi wänbo tꞌä̖hkí nakeepoˀ tobáháa nakhu̖u̖nân wänboˀ. ");
INSERT INTO tew_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Wí sen John gin nakhá̖wä̖́ˀi Yôesi Táḏáḏí óesan nä́ˀi ko i̖ˀgeḏi tꞌowa ovâytu̖ˀâ̖a̖míḏí, heḏânho John-bí híˀ ditꞌoeḏi toˀwên tꞌä̖hkí dívíwhä̖yú̖-íḏí i toˀwí i ko namuuˀivíˀpiyeˀ. ");
INSERT INTO tew_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","John-dá i ko-á wínamuupí, hewänbo i naˀä̖ä̖ tꞌowa ovâytu̖ˀâ̖a̖míḏí toˀwí i ko namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nä́ˀi toˀwí In Tu̖u̖ gin nakhá̖wä̖́ˀiˀ i taˀgendi ko namuu, heḏi nä́ä oepáa kꞌayḏipiyeˀ naˀä̖ä̖ḏi tꞌä̖hkí tꞌowa ovâykohthayyoˀ. ");
INSERT INTO tew_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nä́ä oepáa kꞌayḏi i nayiˀ, hebo tobáháa nä́ˀi oepáa ho ikhíyé wänboˀ, in tꞌowa nä́äḏí diyiˀindi wíˀóetaapí. ");
INSERT INTO tew_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I hä̖ä̖wí ikhíyéˀi ivîˀ ûnmuu, heḏi ipiyeˀ naˀä̖ä̖, hewänbo iví tꞌowaḏi wänbo wíˀóeséegíˀanpí. ");
INSERT INTO tew_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Hewänbo wáy wêndiḏá óeséegíˀandá ivíˀpiyeˀ dívíwhä̖yu̖, heḏi nä́ˀin tꞌä̖hkí iḏi ovâymä́gi Yôesi Táḏáví ây dipúwíḏí. ");
INSERT INTO tew_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Heḏi Yôesi Táḏáví ây dipóe ihayḏi wíyá diˀâypu̖yä̖ waa dínpóe, hewänbo tꞌowa diˀâypu̖yä̖ nä́ä oepáa kꞌayḏi waagibá wíḏiˀâypu̖yä̖pí, heḏiháa i táḏá-áḏí i yíyá-áḏí dachanpóeḏíbo wänbo-á yoe, heḏiháa wí sen nawänpitú̖ḏíbo wänbo-á yoe. Yôesi Táḏáḏân nä́ˀin wówátsi ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","I toˀwí In Tu̖u̖ gin nakhá̖wä̖́ˀi wí tꞌowa napaa, heḏi wí hây tä̖hkí naˀindáḏí nayiˀ. Báyékí hayˀi namuuˀin âymûˀ, gá Yôesi Táḏáví wîˀ ayḏa̖ˀ ûnˀä́ndiˀ namuuḏân. I-á báyékí séegísehkanä imáa, heḏi háa i natú̖ waa tꞌä̖hkí taˀgen namuu. ");
INSERT INTO tew_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Toˀwí i namuuˀin John-di in tꞌowa ovâytu̖ˀan. Oe ahkon deeḏi John nayiḏi kaygi ovâytu̖máa, “Naaḏi wâytu̖ˀan naví tíˀúugébá wí toˀwí napowagítꞌóeˀin, heḏi i-á naví shánkí kwꞌáye namuu, gá naa oˀaypu̖yä̖píḏíboˀ i-á hä̖̂ä̖ḏi wänbo tꞌä̖hkí nawówáyiḏân. Nä́ˀi-ânkun i namuu iví̖ˀgeḏi wâyhíˀmáaˀiˀ.” ");
INSERT INTO tew_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Báyékí séegísehkanä imáaḏí, ihayḏa̖ˀ híwó̖ˀdi hä̖ä̖wí ivíˀweḏi gínˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yôesi Táḏáḏí Moses óetu̖ˀan iví tsontu̖u̖ naˀin dímä̂äníˀin, hewänbo Jesus Christ-ân óesan séegísehkanä-á heḏá in taˀgen namuuˀindá dînkeeya̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Toˀwíḏí wänbo hä̂nhay wänbo Yôesi Táḏá wíˀóemûˀpí. Hewänbo háawi i namuuˀin iví wîˀḏa̖ˀ ay ûnmuuˀiˀ iví núˀ naˀä́ndiḏân naˀin dînkeeyan. ");
INSERT INTO tew_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Owáy Jerusalem búuˀú wä̖́hä̖̂ä̖ḏi in Huḏíyoví pꞌóˀḏéḏíˀindi wên owhaˀ-á heḏá wên méesateˀin khä̖ge̖ˀnindá ovâysan John i pꞌóˀpꞌoekandiˀ óetsikáyi̖ˀníḏí, “To-an unmuu” gin, ");
INSERT INTO tew_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","heḏi kinnân iḏi ovâytu̖ˀan: “Naa i toˀwí Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí wóˀmuupí.” Kaaginpíḏíbo thayˀeeḏi kin ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Heḏi óetsikáyin, “Heḏi to-an unmuu? Ti Elijah-ân unmuu?” Iḏi ovâytu̖ˀan, “Naa-á i wóˀmuupí.” Heḏáháˀ óetsikáyin, “Ti Yôesi Táḏáví tukhe̖ˀbiˀ i âytsíkhaˀmáaˀi-ân unmuu?” ");
INSERT INTO tew_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Heḏi ovâytu̖ˀan, “Yoe.” Heḏáháˀ óetu̖ˀan, “Dítu̖ˀan to-an unmuu, heḏânho in toˀwên naˀin dísannin âytꞌôeˀa̖míḏí háa untú̖ˀin. Uví̖ˀgeḏi dítꞌôeˀan.” ");
INSERT INTO tew_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John-di ovâyhéeˀan heḏânho dínˀánpówá-íḏí háa Yôesi Táḏáví tukhe̖ˀbiˀ Isaiah hä́nˀoebo natú̖ˀin, heḏi nä́ˀi-á Isaiah-ví híˀ ûnmuu: Wí toˀwí oe ahkon deeḏi ûntu̖hkwíntú̖ní, ‘In pꞌôe bintaˀgeˀan i shánkí natsonyiˀigîˀ.’ “Nä́ˀi toˀwí han natú̖ˀi waagiˀbá naa omuu” gin John-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wáy wên in ovâysannin John óetsikáyi̖ˀníḏí Pharisees dimuu, ");
INSERT INTO tew_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","heḏi indi óetu̖ˀan, “I toˀwí Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí wíˀunmuupí, Elijah wänbo-á yoe, háa Yôesi Táḏáví tukhe̖ˀbi âytsíkhaˀmáaˀi wänbo-á yoe. Heḏi háaḏan handi nä́ˀin tꞌowa ovâypꞌóˀpꞌoeˀoˀ?” ");
INSERT INTO tew_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","John-di ovâytu̖ˀan, “Naaḏá pꞌoeḏiḏa̖ˀ dovâypꞌóˀpꞌoeˀoˀ, hewänbo unbí yâaḏi wáyḏí wí toˀwí bîntaapîˀ nayiˀ, heḏi tobá naví tíˀúugé napówá wänboˀ, naa ihay híwó̖ˀdi wóˀmuupí iví anto wänbo dônmaˀpꞌä̖́ḏi-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tꞌä̖hkí nä́ˀi owáy Bethany búuˀúˀay wä̖́hä̖̂ä̖ napóe, oe Jordan pꞌoˀ pꞌä̖́näḏi John nayiḏi in tꞌowa ovâypꞌóˀpꞌoeˀoˀ iwe. ");
INSERT INTO tew_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wíyá tháwä́n John-di Jesus óemûˀ ee nayiˀ iwepiyeˀ naˀä̖ḏi, heḏi iví̖ˀgeḏi natú̖, “Binmúˀḏí i naˀä̖ˀiˀ. I-á Yôesi Táḏáḏí óesan wí kꞌúwáˀay waagiˀbá nachúu-íḏí, tꞌä̖hkí tꞌowaví tꞌaywó̖ˀdi ovâyyâaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nä́ˀibá i namuu iví̖ˀgeḏi wâyhéeˀan. Naa otú̖, ‘Naví tíˀúugébá wí sen napówá-í, heḏi i-á naví shánkí kwꞌáye namuu, gá naa oˀaypu̖yä̖píḏíboˀ i-á hä̖̂ä̖ḏi wänbo tꞌä̖hkí nawówáyiḏân.’ ");
INSERT INTO tew_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tobá toˀwí namúníˀin naa wíḏînhanginnáhpí wänboˀ, naa oˀä̖ä̖-á pꞌoeḏi wâypꞌóˀpꞌoeˀa̖míḏí, heḏânho un Israel-ˀin tꞌowa i bîntáa-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","John-di háa imûˀin ovâytu̖ˀan. Natú̖, “Páaḏéḏí naa wíḏînhanginnáhpí toˀwí Jesus namuuˀin, hewänbo Yôesi Táḏáḏí dísan pꞌoeḏi wâypꞌóˀpꞌoeˀa̖míḏí, heḏá iḏá dítu̖ˀan, ‘I Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ nawhândi nâapu̖wä̖khâymáa, heḏi wí toˀwívîˀḏi isogekhâymáa. Heḏi nä́ˀi toˀwíḏân i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ tꞌowa ovâymä̂äní wí pꞌóˀpꞌoekan waagibá’ kin Yôesi Táḏáḏí dítu̖ˀan. Heḏihoˀ i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ makówáḏí nawhândi wí kꞌoˀwee waagibá dómûˀ-ákun, heḏi Jesus-vîˀḏi isóge. ");
INSERT INTO tew_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naa kin napóeḏí dómûˀ, heḏânho naaḏi wâytu̖máa Jesus-á Yôesi Táḏáví ay ûnmuu.” ");
INSERT INTO tew_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Wíyá tháwä́n John-dáḏí heḏá wíye iví khä̖ge̖ˀnindáḏí Jesus naphaḏemändi óemûˀ, heḏi Jesus-ví̖ˀgeḏi John natú̖, “Binmúˀḏí i Yôesi Táḏáḏí óesandiˀ namuuˀiˀ. Wí kꞌúwáˀay waagiˀbá nachúu-í.” ");
INSERT INTO tew_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","John-bí wíye khä̖ge̖ˀnin háa John natú̖ˀin datꞌoe, heḏi Jesus-ví tíˀúugé dawóemää. ");
INSERT INTO tew_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus ibéeḏí ûnwóeˀä̖ḏi ovä̂nmûˀ, heḏi ovä̂ntsikáyin, “Hä̖ä̖-an dadaˀ?” Óetsikáyin, “Rabbi, wä̖́hä̖̂ä̖-an unthaa?” (Rabbi-á “há̖hkandi” gin natu̖ˀdaˀ.) ");
INSERT INTO tew_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iḏi ovä̂ntu̖ˀan, “Naa-áḏí bákä̖ˀve, heḏânho wä̂nkeeya̖míḏí.” Heḏihoˀ i-áḏí damääḏi wáygé nathaaˀin dä̂nmûˀ. Dipówá ihayḏáho théˀêeḏi yôenu iwepiyeˀ naná, heḏihoˀ i-áḏíbo dänwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrew-á Simon Peter-ví tíˀûu ûnmuu, heḏi i-á in wíye in John-bí híˀ datꞌoeḏi Jesus-áḏí damääˀin diweḏiˀibá namuu. ");
INSERT INTO tew_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Wesebo Andrew iví páˀḏây Simon itu̖wä̖hoˀ, heḏi óeshaa ihayḏi óetu̖ˀan, “Naˀindi i Messiah âyshaa.” (In híˀ Messiah-á natu̖ˀdaˀ “i toˀwí Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí” gin.) ");
INSERT INTO tew_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Heḏi Andrew-ḏi Simon Jesus-víˀpiyeˀ óehoˀ. Jesus-di Simon óemûˀ ihayḏi óetu̖ˀan, “U̖-á Simon unmuu, John-bí ay, hewänbo nää iweḏi páaḏépiyeˀ Cephas gin unkhá̖wä̖́-í. (Nä́ˀin khá̖wä̖́ Cephas-á Peter-ân namuu, heḏi natu̖ˀdaˀ “wí kꞌuu” gin.) ");
INSERT INTO tew_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wíyá tháwä́n Jesus iˀánshaamä́gi oe Galilee nangepiyeˀ namú-íḏí, heḏi Philip óemûˀḏi óetu̖ˀan, “Naa-áḏí ókä̖ˀve.” ");
INSERT INTO tew_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip-á Bethsaida-wi namuu, i búuˀúˀay Andrew-áḏí Peter-áḏí datháˀḏe iwebá. ");
INSERT INTO tew_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip-di Nathanael óetu̖wä̖hoˀ, heḏi óeshaa ihayḏi óetu̖ˀan, “I toˀwí Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí âyshaa, i-á Jesus oe Nazareth-wi-ân namuu, Joseph-ví ay. Iví̖ˀgeḏân Moses ita̖ˀnan iví ta̖ˀnin diwe, heḏá in Yôesi Táḏáví tukheˀmin wáˀ iví̖ˀgeḏi dâyta̖ˀnan.” ");
INSERT INTO tew_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael-di Philip óetu̖ˀan, “Naa wóˀânpí hä̖ä̖wí wänbo Nazareth-wi-á híwó̖ˀdi namuuˀin.” Philip-di Nathanael óetu̖ˀan, “Ókä̖ˀve naa-áḏí heḏiho wíˀbo nâapimúní.” ");
INSERT INTO tew_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus-di Nathanael ivíˀpiyeˀ naˀä̖ḏi óemûˀ, heḏi iví̖ˀgeḏi natú̖, “Hä̖webâa wí naˀä̖ˀ in Israel-wi khuu taˀgendi ihondiˀ, i-á wínahôeyóhá̖hpí.” ");
INSERT INTO tew_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael-di óetsikáyin, “Háḏíḏan naa dítaa?” Jesus-di óetu̖ˀan, “I fig tay óhkhu̖u̖ núˀ unˀä́n dihayḏi naaḏi wímûˀ, Philip-di wóetu̖kánnanpíḏíboˀ.” ");
INSERT INTO tew_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael-di óetu̖ˀan, “Há̖hkandiˀ, näbâa dînhanginná u̖-á Yôesi Táḏáví ay-ân unmuuˀin, u̖-á in Israel tꞌowaví tsondi hayˀi unmuu.” ");
INSERT INTO tew_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus-di Nathanael óetu̖ˀan, “Nää navíˀpiyeˀ biwhä̖yundeˀ gá wítu̖ˀandân in fig tay núˀ naaḏi wímûˀin, hewänbo hä̖ˀi wítsꞌantu̖ˀandiví shánkí heˀendi hä̖ä̖wí nâapu̖wä̖khâymáa. ");
INSERT INTO tew_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Taˀgendi wítu̖máa, makówá nakhuuḏeeḏi bînpu̖wä̖gítꞌóe, heḏá naa tꞌowa tꞌä̖hkígîˀ oˀaypu̖yä̖ˀivíˀwe in Yôesi Táḏáví tꞌôepa̖ˀa̖a̖ˀin diwhándeḏá diwáypiˀḏá bînpu̖wä̖khâymáa.” ");
INSERT INTO tew_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wíye thaa naphaḏe ihayḏi owáy Galilee nange wä̖́hä̖̂ä̖ dínkhóhtsa̖a̖shánkîˀḏiná, i búuˀúˀay Cana gin dâytu̖ˀoˀ iwe. Jesus-ví yíyá páaḏébo namääḏihoˀ iwe naˀä́n, ");
INSERT INTO tew_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","heḏá Jesus-á iví khä̖ge̖ˀnindáḏá wáˀ ovâyhúutu̖ˀandiho dimää. ");
INSERT INTO tew_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tꞌä̖hkí i méena dínhán dihayḏi Jesus-ví yíyáḏí óetu̖ˀan, “Wíyá wíḏínméenasaapí.” ");
INSERT INTO tew_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus-di óetu̖ˀan, “Yíyá, háaḏan kin dítu̖máa? Waˀḏi ihayḏi wíḏînnáhpí naví tꞌôe donˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iví yíyáḏí in húukhâysaˀin ovâytu̖ˀan, “Háa iḏi wovâytu̖ˀan waa úvíˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Iwe sí pꞌonbay kꞌuuḏi napaˀandi nasaa, tꞌowa dipówáˀin dívíˀowíḏi-íḏí in Huḏíyoví khuu dínmuu waagi. Nä́ˀi pꞌonbay eeye wétä̖ háa powintä̖ galôn dihay nasaḏiˀ. ");
INSERT INTO tew_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus-di in dâyhúukhâysaaˀin ovâytu̖ˀan, “Nä́ˀi pꞌonbay binpꞌiḏe,” heḏiho pꞌéeḏí taye dâypꞌíḏe. ");
INSERT INTO tew_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Heḏáháˀ ovâytu̖ˀan, “Hä̖weḏiho wí binwhahóˀgí, heḏi unbí tsondivíˀwe binhûu.” Heḏiho háa ovâytu̖ˀan waa dívíˀan. ");
INSERT INTO tew_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","I pꞌoe dâyhoˀi naméenapaa, heḏi in húukhâysaˀinbí tsondi idä̂ä, hebo wíˀûnhanginnáhpí wáygé dâyhógiˀin. In wé̖ˀgeˀin dâyhúukhâysandeˀinda̖ˀmân dínhanginná. Heḏihoˀ iḏi i soyingi óetu̖kánnan, ");
INSERT INTO tew_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","heḏi óetu̖ˀan, “Wây-á tꞌowa i shánkí híwó̖ˀdi méena páaḏé dâykhâysandeˀ, heḏi tꞌowa dívíˀihayˀan dihayḏânho i shánkí nakꞌâ̖a̖gipîˀ dâykhâysandeˀ. Hewänbo u̖-á han wíviˀanpí, u̖-á bitsíkhaˀan i shánkí híwó̖ˀdi tíˀúugé ovâykhâysáa-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nä́ˀin Jesus ee Cana búuˀúˀay Galilee nange wä̖́hä̖̂ä̖ iˀannin in páaḏéˀin pínnán tꞌôe ovâykeeyannin namuu, heḏi indiho in tꞌowa ikeeyan i-ân hayˀi namuuˀin, heḏi iví khä̖ge̖ˀnin shánkí wänbo ivíˀpiyeˀ dívíwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tꞌä̖hkí nä́ˀi naphaḏe ihayḏi Jesus-á iví yíyá-á iví tíˀûuwindá heḏá iví khä̖ge̖ˀnindáḏí Capernaum búuˀúˀaypiyeˀ dimää, heḏi iweho wí hä̖́yú̖ thaa dívíwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","In Huḏíyoví shánkîˀḏi púnúˀ naná, Passover gin dâytu̖ˀoˀiˀ, heḏi Jesus oe Jerusalem-piyeˀ namää. ");
INSERT INTO tew_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","I méesate hayˀi tehpaa búge in tꞌowa dâyhä̖ä̖wênku̖ˀchꞌáaḏeḏi ovâymûˀ, wéyu-á kꞌúwá-á kꞌoˀwee-á dâyku̖ˀchꞌáaḏeˀ, heḏá wáˀ in dâychä̖ˀegóˀoˀin inbí mä́äsa eeye dikwꞌôndi ovâymûˀ. ");
INSERT INTO tew_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wên púwhí̖ˀ whihkannindi ipaa, heḏi tꞌä̖hkí i méesate hayˀi iweḏi ovâykhe̖hpiye inbí kꞌúwá-á inbí wéyu-á wóegé, heḏi in dâychä̖ˀegóˀoˀindá inbí chä̖ˀ tꞌä̖mäpiyeˀ ovâychꞌáa heḏi inbí mä́äsa ovâyyánú. ");
INSERT INTO tew_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Heḏá in dâykꞌoˀweeku̖ˀchꞌáaḏeˀindá ovâytu̖ˀan, “Binyâaˀan nä́ˀi hä̖ä̖wí nä́weḏi. Nä́ˀi méesate-á naví Táḏáví wháagé ûnná. Wí ku̖hteˀi waagibá wíyá wívînpáa-ípí.” ");
INSERT INTO tew_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Heḏihoˀ iví khä̖ge̖ˀnin dínˀánpówá háa toˀwí Yôesi Táḏáví ta̖ˀnin diwe natú̖ˀin kin: Hânho uví wháagéḏí díˀá̖yîngimäḏi wí phaaḏi naa díphakha̖nukhâymáa waagibá ochanpoˀ, heḏi dâymûˀ Jesus hanbá nacha̖a̖ˀin. ");
INSERT INTO tew_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","In Huḏíyoví pꞌóˀḏéḏíˀin iwáygé diyiˀindi Jesus óetsikáyin, “Háawin wên pínnán ú̖koeḏi dînkeeya̖míḏí, heḏânho gínhanginnáníḏí u̖ ú̖kꞌóeˀin nä́ˀin tꞌowa ovâykhe̖hpiyé-íḏí?” ");
INSERT INTO tew_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus-di ovâytu̖ˀan, “Nä́ˀi méesate bînnayu̖ḏi poeye thaa iwebo naa wíyá dótegé-í.” ");
INSERT INTO tew_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Indi óetu̖ˀan, “Yónä́ntä̖ˀḏi sí (46) pa̖a̖yo ovâyhoˀ nä́ˀi méesate dâytegé-íḏí, heḏi háḏíḏan poeye thaa iwebo wíyá nâategé-í?” ");
INSERT INTO tew_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Hewänbo Jesus-á iví túuˀú i̖ˀgeḏân ovâyhíˀmáa, i méesate hayˀi i̖ˀgeḏá yoe. ");
INSERT INTO tew_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Heḏiho chuwa iweḏi nawáywówápóe ihayḏi, iví khä̖ge̖ˀnin nä́ˀin natú̖ˀin dínˀánpówá, heḏi Yôesi Táḏáví ta̖ˀnin diwe háa nata̖ˀmuuˀin heḏá nä́ˀi tu̖u̖ Jesus ihéeˀandi-á dívíwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Waˀḏi Jesus oe Jerusalem búuˀú nayiˀ ihayḏi, in Huḏíyoví shánkîˀḏi thaa Passover gin dâytu̖ˀo nanáˀ dihayḏi, báyékí tꞌowa i pínnán ovâykeeyandi dâymûˀḏi ivíˀpiyeˀ dívíwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Hewänbo Jesus wíˀipimä́gipí inbí mange. I-á wíˀûntáypí wí toˀwíḏí tꞌowaví̖ˀgeḏi óetu̖ˀâ̖a̖míḏí, i-áho ûnhanginná háawin tꞌowa dimuuˀin heḏá háa inbí píˀnä́ khóˀyé diˀánshaamuuˀindá. ");
INSERT INTO tew_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Wí sen Nicodemus gin nakhá̖wä̖́ˀi Jesus-víˀpiyeˀ khu̖ˀḏéeḏí namää. I-á Pharisee tꞌowa namuu heḏá in Huḏíyoví tsonnin diweḏiˀibá namuu. Iḏi Jesus óetu̖ˀan, “Há̖hkandiˀ, gínhanginná Yôesi Táḏáḏí wóesan naˀin díhá̖ˀa̖míḏí. Wí toˀwí Yôesi Táḏáḏí óekhä̖ge̖ˀmáaˀiḏa̖ˀmân ûnkoeḏi ikeeya̖míḏí i pínnán u̖ḏi dînkeeyo waagibá.” ");
INSERT INTO tew_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus-di óetu̖ˀan, “Taˀgendi wítu̖máa, in toˀwên wíyíḏí.” ");
INSERT INTO tew_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus-di óetsikáyin, “Háḏíḏan wí toˀwí nasówéboˀwandiˀ wíyá nawáyˀaypu̖yä̖́-í? Wíˀûnkoeḏipí iví yíyáví aymúu iwe nawáytsꞌú̖níḏí wíyá naˀaypu̖yä̖́-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus-di óetu̖ˀan, “Taˀgendi wítu̖máa, in toˀwên pꞌoe iweḏi heḏá i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖víˀweḏá diˀâypu̖yä̖ˀinda̖ˀmân dínkoeḏi makówápiyeˀ dimú-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Toˀwên tꞌowavíˀweḏi diˀâypu̖yä̖ˀin tꞌowaḏa̖ˀmân dimuu, hewänbndi wítu̖máa, in toˀwên wíyó toˀwên i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖víˀweḏi diˀâypu̖yä̖ˀindá i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dâymáa. ");
INSERT INTO tew_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wíwóeháaˀa̖mípí naaḏi wítu̖ˀandi, wíyá íˀâypu̖yä̖́-íˀin únkhâyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Oepiyá nä́äpiyá iwa̖a̖ˀoˀ, heḏi i wa̖a̖ ítꞌoˀ, hewänbo wíˀúnhanginnáhpí wä̖́hä̖̂ä̖pha̖ˀgeḏi naˀä̖ˀin háa wáypiyeˀ namännin. Heḏi hanbá wíˀíkaˀpóya̖ˀpí háḏíḏí wí toˀwí i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖víˀweḏi naˀaypu̖yä̖ˀin.” ");
INSERT INTO tew_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus-di óetsikáyin, “Ti nakoeḏí-í nä́ˀi hä̖ä̖wí untû̖ˀdiˀ napúwíḏí? Hândiḏan napúwí?” ");
INSERT INTO tew_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus-di óetu̖ˀan, “U̖-á wí Israel-ˀinbí há̖hkandi unmuu, heḏi háaḏan nä́ˀi hä̖ä̖wí i̖ˀgeḏi wíˀunkaˀpóya̖ˀpí? ");
INSERT INTO tew_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Taˀgendi wítu̖máa, nä́ˀi dînhanginnân niˀgeḏi ívíhéeˀoˀ, heḏá i hä̖ä̖wí âymûˀ i̖ˀgeḏá wâytu̖ˀoˀ, hewänbo undá háa gitû̖ˀnin wíḏînséegíˀopí. ");
INSERT INTO tew_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nä́ˀi oepáa kꞌayḏiwi hä̖ä̖wí i̖ˀgeḏi naaḏi wâytu̖ˀan, heḏi un wíˀúvíwhä̖yundepí, heḏiho háḏíḏan úvíwhä̖yú̖-í makówáwi hä̖ä̖wí i̖ˀgeḏi wâytu̖ˀandi? ");
INSERT INTO tew_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Makówápiyeˀ wíyá toˀwí wänbo wínapeepí, i makówá iweḏi nawhá̖ˀdiḏa̖ˀmân, heḏi naa-ân i omuu, tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ. ");
INSERT INTO tew_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses owáy ahkónu wáy i pä̖́ä̖yu̖ kwä̖́kꞌuḏi napaˀandiˀ wên phé eeḏi iwhiˀkꞌûˀḏi itege waagibá, naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ omuuˀiˀ wáˀ phé eeḏi dítegé-í. Kin nakhâyˀä̖ˀ napúwíˀin ");
INSERT INTO tew_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","heḏiho toˀwên tꞌä̖hkí navíˀpiyeˀ dívíwhä̖yundeˀin wówátsi nahándepíˀin dâymáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yôesi Táḏáḏí tꞌä̖hkí tꞌowa hânho ovâyséegíḏí iví wîˀ ayḏa̖ˀ ûnˀä́ndiˀ imä́gi, heḏiho toˀwên tꞌä̖hkí iví ayvíˀpiyeˀ dívíwhä̖yu̖ˀin háˀto dipeḏée-í hewänbo wówátsi nahándepíˀin dâymáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yôesi Táḏá iví ay isan nä́ä oepáa kꞌayḏipiyeˀ in tꞌowa ovâyˀaywoeníḏí, dínkhâyˀä̖ˀ ovâytuchä̖nú-íˀin ovâytu̖ˀâ̖a̖míḏá yoe. ");
INSERT INTO tew_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Toˀwên tꞌä̖hkí Yôesi Táḏáví ayvíˀpiyeˀ dívíwhä̖yundeˀin háˀto ovâytu̖ˀa̖mí ovâytuchä̖nú-íˀin, hewänbo Yôesi Táḏá ho natú̖ in toˀwên dívíwhä̖yu̖píˀindá ovâytuchä̖nukhâymáaˀin, gá iví wîˀ ayḏa̖ˀ ûnˀä́ndivíˀpiyeˀ wíḏívíwhä̖yu̖píḏân. ");
INSERT INTO tew_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yôesi Táḏáví ay nä́ä oepáa kꞌayḏipiyeˀ naˀä̖ä̖ wí kohthay waagibá namúníḏí heḏânho tꞌowa dínkeepúwíḏí, hewänbo tꞌowa yä̖ˀḏâapí dívítsiyekanhondi khu̖u̖ eeyebo diyê̖e̖níˀin shánkí ovâyhí̖ˀan i kohthay ipiyeˀ dimú-ívíˀweḏi. Heḏânho Yôesi Táḏáḏí nä́ˀin tꞌowabá ovâytuchä̖nukhâymáa. ");
INSERT INTO tew_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Toˀwên tꞌä̖hkí yä̖ˀḏâapí dívítsiyekanhonnindá i kohthay dâytꞌay, heḏiho ipiyeˀ wíḏimänpí, háa dívítsiyekanhonnin dínkeepúwíˀin wíḏidaˀpíḏí. ");
INSERT INTO tew_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hewänbo toˀwên in taˀgen dívíkanhonnin i kohthay ipiyeˀ dimän, heḏânho nakeepúwíḏí hä̖ä̖wí dívíkanhondi Yôesi Táḏáḏí ovâykhä̖ge̖ˀdoḏi dívíˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Heḏáháˀ Jesus-á iví khä̖ge̖ˀnindáḏí oe Judea nangepiyeˀ dimää, heḏi iwáy wä̖́hä̖̂ä̖ diyiˀ ihayḏi wên tꞌowa ovâypꞌóˀpꞌoeˀan. ");
INSERT INTO tew_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","In Huḏíyo tsonnindi John i pꞌóˀpꞌoekandi waˀ wíˀóepansógepí, heḏi iḏi wáˀ tꞌowa ovâypꞌóˀpꞌoeˀoˀ. Kin iˀoˀ oe Aenon diwe, i-á Salim tsoˀwa naná, iwe báyékí pꞌoe nayiḏi, heḏi tꞌowa ivíˀpiyeˀ dimäˀ ovâypꞌóˀpꞌoeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ihayḏá John-bí khä̖ge̖ˀnin wí Huḏíyo-áḏí pꞌóˀpꞌoekan niˀgeḏi dívítu̖hä́nboˀ. ");
INSERT INTO tew_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Heḏiho John-bíˀpiyeˀ dimääḏi óetu̖ˀan, “Há̖hkandiˀ, i to sen oe Jordan pꞌoˀ pꞌä̖́nä hä̂nhay u̖-áḏí nayiˀi heḏá iví̖ˀgeḏi in tꞌowa u̖ḏi ovâytu̖ˀandiˀ, nää báyékí tꞌowa ivíˀpiyeˀ dimän iḏi ovâypꞌóˀpꞌoeˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John-di ovâytu̖ˀan, “Hä̖ä̖wí i toˀwí oe makówá naˀä́ndiḏi dímä́giˀiḏa̖ˀmân âyhóndeˀ. ");
INSERT INTO tew_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hä̖̂ä̖ḏankánbo naa otú̖ i to Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí wóˀmuupí, hebo iví páaḏébo Yôesi Táḏáḏí naa dísan, heḏi undá háa otú̖ waa ítꞌoe. ");
INSERT INTO tew_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Hä̖̂ä̖ḏi dínkhóhtsa̖a̖náˀ dihayḏi i soyingi namuuˀiví kꞌema iví núˀ nawin, heḏi i soyingi ihíˀmáaḏí natꞌoeḏi nä́ˀi kꞌema báyékí nahíhchanpóe, heḏi i sâaˀi i soyingivîˀ ho namuu. Nää-á hanbá naa-á i soyingiví kꞌema waagibá hânho ohíhcha̖a̖, gá in tꞌowa Jesus-víˀpiyeˀbá dimändân ivíˀin ûnmúníḏí. ");
INSERT INTO tew_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nakhâyˀä̖ˀ Jesus-á shánkí kwꞌáyepiyeˀ óetegé-íˀin, heḏá naa-á hä̖́ä̖bo omuupí waa opúwí. ");
INSERT INTO tew_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Jesus-á oe makówáḏí naˀä̖ä̖, heḏiho tꞌä̖hkíví shánkí hayˀi namuu. Naa nä́ä oepáa kꞌayḏiwiˀ omuu, heḏiho wí nä́äḏíwi waagibá dáyhéeˀoˀ nä́äḏíˀiḏa̖ˀ omuuḏi, hewänbo i-á makówáḏí naˀä̖ä̖ḏi tꞌä̖hkíví shánkí hayˀi namuu. ");
INSERT INTO tew_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hä̖ä̖wí imûˀ i̖ˀgeḏi heḏá natꞌoe i̖ˀgeḏá ihéeˀoˀ, hewänbo wên hä̖́yú̖hayḏiḏa̖ˀ tꞌowa háa natû̖ˀnin ônséegíˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Hewänbo toˀwên iví híˀ dâyséegíˀoḏi handiḏi dâykeeyoˀ dívíwhä̖yundeˀin Yôesi Táḏá taˀge ihéeˀoˀin. ");
INSERT INTO tew_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yôesi Táḏáví ay isandi-á Yôesi Táḏáví híˀ ihéeˀoˀ, gá Yôesi Táḏáḏá khâ̖a̖gipí i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ ho óemä́giḏân. ");
INSERT INTO tew_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yôesi Táḏá iví ay iséegíḏí tꞌä̖hkí tsonkhuu óemä́gi hä̖ä̖wí tꞌä̖hkí i̖ˀgeḏi natsonyê̖e̖níḏí. ");
INSERT INTO tew_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Toˀwên tꞌä̖hkí Yôesi Táḏáví ayvíˀpiyeˀ dívíwhä̖yundeˀin wówátsi nahándepíˀin dâymáa, hewänbo toˀwên iví ay ôntꞌóyandepíˀindá nä́ˀin wówátsi wíḏâymáˀve-ípí, indá Yôesi Táḏáḏí hä̂nhay wänbo tꞌä̖hkí ovâytuchä̖́nuˀbé-í.” ");
INSERT INTO tew_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","In Pharisees dínhanginpóe shánkí báyékí tꞌowa Jesus-víˀpiyeˀ dívíwhä̖yundeˀin, heḏá John i pꞌóˀpꞌoekandiví shánkí Jesus-di ovâypꞌóˀpꞌoeˀoˀ. (Hewänbo Jesus-ví khä̖ge̖ˀnindiḏa̖ˀ tꞌowa ovâypꞌóˀpꞌoeˀoˀ, iḏá yoe.) Heḏi nä́ˀi hä̖ä̖wí i̖ˀgeḏi in Pharisees ditꞌoeˀin Jesus ûnhanginpóe ihayḏi, i-áḏí iví khä̖ge̖ˀnindáḏí Judea nangeḏi dipee heḏi oe Galilee nangepiyeˀ dimää. ");
INSERT INTO tew_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galilee-piyeˀ namän dihayḏi oe Samaria nange i̖ˀgeḏi ûnpu̖hpoˀ. ");
INSERT INTO tew_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Taage púnúˀ nanáˀ dihayḏi wí Samaria-wi búuˀúˀay Sychar gin dâytu̖ˀoˀ iwe napówá. Sychar-á kayi̖ˀ wínanáhpí wí nava iweḏi hä́nˀoebo Jacob-di iví ay Joseph óemä́giˀiˀ. Ee dâypꞌoewhahóndeˀ iwe Jacob ishä̖ä̖ˀi naná, heḏi Jesus kayi̖ˀ wä̖́hä̖̂ä̖ḏi naˀä̖ä̖ḏiho nakaykhanmuuḏi ee hânge isóge ikaykhanwówáˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Wí Samaria-wi kwee ipꞌoewhahóníḏí napówá, heḏi Jesus-di óetu̖ˀan, “Wí pꞌoe dímä́ä donsu̖wä̖́-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jesus-ví khä̖ge̖ˀnin i búuˀúˀaypiyeˀ ho dikoegiˀkunmää, heḏiho i-á wíˀbo naˀä́n. ");
INSERT INTO tew_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Huḏíyo-áḏí Samaria-ˀindáḏí wíḏívíwóndepí, heḏiho i kweeḏi óetu̖ˀan, “U̖-á Huḏíyo unmuu, heḏi naa-á Samaria-wi-á omuu. Heḏi háaḏan u̖ḏi dípˀoesu̖wä̖gîˀdaˀmáa?” ");
INSERT INTO tew_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus-di óetu̖ˀan, “Wíˀú̖hanginnáhpí hä̖ä̖wí Yôesi Táḏá napä̖yiˀin, heḏá wáˀ toˀwí naa i wípꞌoedaˀmáaˀiˀ omuuˀin wíˀú̖hanginnáhpí. Ú̖hanginnândáhoˀ u̖ḏá naa dípꞌoesu̖wä̖daaˀa̖míwän, heḏi naaḏá pꞌoe nawówátsipä̖yiˀi wímä̂äníwän.” ");
INSERT INTO tew_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","I kweeḏi óetu̖ˀan, “Mä́ˀmä̂ä, hä̖ä̖wí wänbo wínâamáapí pꞌoewhakhongíˀin, heḏi nä́we dâypꞌoewhahóndeˀ iwá nawä̖ˀän. Heḏi hândiḏan nä́ˀi pꞌoe nawówátsipä̖yiˀi nâawhahóní? ");
INSERT INTO tew_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Naˀinbí hehä̖̂ä̖wi thehtáy pahpâa Jacob-di nä́ä dâypꞌoewhahóndeˀ iwe naˀin dînyoeˀan. I-áḏí iví eˀnûndáḏí heḏá iví hä̖ä̖pan hä̖ä̖wêndáḏí i pꞌoe nä́weḏi dâywhahógiˀi dâysu̖wändeˀ. Ti unˀándeˀ u̖-á Jacob-ví shánkí hayˀi unmuuˀin gáhân?” ");
INSERT INTO tew_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus-di óetu̖ˀan, “Toˀwên tꞌä̖hkí nä́weḏi dâypꞌoesu̖wändeˀin wíyá dipꞌoesáˀaapúwí, ");
INSERT INTO tew_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","hewänbo nä́ˀi pꞌoe naaḏi tꞌowa dovâymäˀiˀ-á dâysu̖wä̖ḏá, háˀto wíyá dipꞌoesáˀaapúwí. I pꞌoe naaḏi dovâymäˀi-á wí pꞌohpee inbí píˀnä́ waagibá napúwí, heḏi iweḏiho in wówátsi nahándepíˀin dâykéyí.” ");
INSERT INTO tew_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","I kweeḏi óetu̖ˀan, “Mä́ˀmä̂ä, nä́ˀi pꞌoe i̖ˀgeḏi bihíˀmáaˀi dímä́ä, wíyá wíˀopꞌoesáˀaapúwípíḏí, heḏânho ihayḏa̖ˀ nä́we wíˀopꞌohkhonnä́ˀbe-ípíḏí.” ");
INSERT INTO tew_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus-di óetu̖ˀan, “Yaˀ ópûn, uví sedó mänkéyí heḏá nä́äpiyeˀ nâamáˀí.” “Wíḏînsennä́npí” gin i kweeḏi óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jesus-di óetu̖ˀan, “Taˀgendi untú̖ wíˀú̖sennä́npíˀin. ");
INSERT INTO tew_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pꞌá̖nä́n khóhtsa̖a̖ˀi unmuu, heḏi nä́ˀi sen nää unthaaˀi-áḏí uví sedó taˀgendi wíˀú̖muupí.” ");
INSERT INTO tew_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","I kweeḏi óetu̖ˀan, “Mä́ˀmä̂ä, nää naa dînkeeyan wí Yôesi Táḏáví tukhe̖ˀbiˀ unmuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naˀin Samaria-ˀin tꞌowa gimuuˀinbí páaḏé kä̖ˀä̖ä̖ˀindi Yôesi Táḏá nä́ˀi pꞌin kwꞌáye óeˀaˀginmäˀ, hewänbo un Huḏíyo-á ítû̖ˀ oe Jerusalem búuˀú iwebo tꞌowa dínkhâyˀä̖ˀ Yôesi Táḏá óeˀaˀginmä̂äníˀin.” ");
INSERT INTO tew_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus-di i kwee óetu̖ˀan, “Biwhä̖yú̖-í nä́ˀin: Owáy wí thaa nanáˀ diwe tꞌowaḏi Yôesi Táḏá óeˀaˀginmä̂äní nä́ˀi pꞌin diweḏa̖ˀbá yoe háa oe Jerusalem diweḏa̖ˀbá yoe. ");
INSERT INTO tew_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Un Samaria-ˀin taˀgendi wíˀúnhanginnáhpí toˀwí bînˀaˀginmäˀin, hewänbo naˀin Huḏíyo-á gínhanginná toˀwí âyˀaˀginmäˀin, gá Yôesi Táḏáḏí naˀin Huḏíyo díde̖ˀmandân heḏiho i toˀwí tꞌowa ovâyˀaywonkhâymáaˀi-á Huḏíyo-ân namuu. ");
INSERT INTO tew_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Heḏi nää iweḏi páaḏépiyeˀ in toˀwên Yôesi Táḏá dâyˀaˀginmäˀindi taˀgendá heḏá pín taˀgehayḏá óeˀaˀginpä̖khâymáa. Ki̖ˀmin tꞌowa-áho i Táḏá nadaˀ óeˀaˀginmä̂äníˀin. ");
INSERT INTO tew_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yôesi Táḏá-á pꞌoewa̖a̖hâ̖a̖ḏa̖ˀ namuu, heḏi in óeˀaˀginmäˀin dínkhâyˀä̖ˀ taˀgendá heḏá pín taˀgehayḏá óeˀaˀginmä̂äníˀin.” ");
INSERT INTO tew_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","I kweeḏi óetu̖ˀan, “Naa dînhanginná i toˀwí Yôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí naˀä̖ˀ, Christ gin óetu̖ˀoˀiˀ. Napówá ihayḏi hä̖ä̖wí tꞌä̖hkí dînthaykankhâymáa naˀin.” ");
INSERT INTO tew_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus-di óetu̖ˀan, “Naaḏi wíhíˀmáaˀi-ân i omuu.” ");
INSERT INTO tew_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ihayḏibá Jesus-ví khä̖ge̖ˀnin diwáypówá, heḏi hânho ovâyháaˀan wí kwee-áḏí ihíˀmáaḏí, hewänbo toˀwíḏí wänbo i kwee wíˀóetsikáyinpí, “Hä̖ä̖-an undaˀ?” heḏi Jesus wänbo wáˀ wíˀóetsikáyinpí, “Háaḏan i kwee-áḏí bihíˀmáa?” ");
INSERT INTO tew_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ihayḏihoˀ i kwee iví pꞌonbay iwe iyoeˀandi i búuˀúˀaypiyeˀ namää, heḏi in tꞌowa ovâytu̖ˀan, “Bíkä̖ˀve bînmúníḏí wí sen tꞌä̖hkí háa naa dáyˀannin dítu̖ˀandiˀ. Tigúbá i-á i toˀwí namuu Yôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí.” ");
INSERT INTO tew_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Heḏihoˀ in tꞌowa i búuˀúˀay iweḏi dipeeḏi iwáy Jesus nayiˀ iwepiyeˀ dimää. ");
INSERT INTO tew_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Waˀḏi in tꞌowa búuˀúḏí diˀä̖ḏibá Jesus-ví khä̖ge̖ˀnindi óetu̖máa, “Há̖hkandiˀ, shánkí yänbeḏi nääbo bihú̖u̖ya̖mí.” ");
INSERT INTO tew_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Iḏi ovâytu̖ˀan, “Naa piháawi koegîˀ dómáa, un i̖ˀgeḏi wíˀúnhanginnáhpí.” ");
INSERT INTO tew_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Iví khä̖ge̖ˀnin wíˀnä́ táye dívítsikaˀmáa, “Ti wí toˀwíḏí ônkoegiˀkán, gáhân?” ");
INSERT INTO tew_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus-di ovâytu̖ˀan, “Háa i toˀwí naa dísandiˀ nadaˀ waagibo naa dáyˀoˀ, heḏi in tꞌôe iḏi naa díkanyônnin dóbowakhâymáa. Nä́ˀi hä̖ä̖wí dóˀoˀiˀ naví koegîˀ waagiˀbá dînmuu. ");
INSERT INTO tew_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","36","Kin tꞌowa ditû̖ˀpíˀan: Dâykoˀyikoˀ iweḏi dâyhä̖ä̖wíwé̖ˀgeˀo puˀwahay yôenu pꞌóe naná. Hewänbo naaḏi wâytu̖máa, híwó̖ˀgí binmúˀḏí in tꞌowa hä̖ä̖ nava i̖ˀge diˀä̖ˀin. Hä̖ˀin tꞌowa-á dikhâymuu ovâywé̖ˀgeˀa̖míḏí hä̖ä̖wí napaaˀi waagibá, heḏi undá hä̖ä̖wí wé̖ˀgekannin waagiˀinbá-á ímuuḏi hä̖ˀin tꞌowa-á bînwé̖ˀgeˀa̖mí Yôesi Táḏávíˀpiyeˀ bînhûuwíḏí. Heḏi kin úvíˀan dihayḏá Yôesi Táḏáḏí wovâywáˀâa-í, heḏi in tꞌowa-á in wówátsi nahándepíˀin dâykéyí. Wây-á wêndá ho Yôesi Táḏáví híˀ ovâykoe inbí píˀnä́ khóˀyé, wí toˀwí ikoˀyikoˀ waagibá, heḏi in wé̖ˀgeˀindáḏí undáḏí úvíhíhchannamí hä̖ˀin tꞌowa bînwé̖ˀgeˀan dihayḏi. ");
INSERT INTO tew_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tꞌowa ditû̖ˀpíˀan: Wí toˀwí ikoˀ, wíyá toˀwí-á ihä̖ä̖wé̖ˀgeˀoˀ. Heḏi háa ditû̖ˀ waa nää taˀgendi napúwí. ");
INSERT INTO tew_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wáy úvítꞌôeˀanpíˀyepiyeˀ naaḏi wâysangítꞌóe in tꞌowa Yôesi Táḏágîˀ bînwé̖ˀgeˀa̖míḏí. Unbí páaḏébo wây-á toˀwên dívítꞌôeˀan, heḏi in tꞌôe dívíˀannin namuuḏi undáho in tꞌowa bînwé̖ˀgekhâymáa.” ");
INSERT INTO tew_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Oe Sychar búuˀú báyékí tꞌowa Jesus-víˀpiyeˀ ho dívíwhä̖yu̖ gá i kweeḏi ovâytu̖ˀandân, “Jesus-di háa dáyˀannin tꞌä̖hkí naa dítu̖ˀan.” ");
INSERT INTO tew_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hediho nä́ˀin tꞌowa Jesus-víˀwe dipówá ihayḏi óedaaˀan indáḏí nacha̖ˀníḏí, heḏiho wíye thaa iwe iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tíˀúugéḏí wây-á shánkí báyékí tꞌowa iweˀin Jesus-ví híˀ ditꞌoeḏi ivíˀpiyeˀ dívíwhä̖yu̖, ");
INSERT INTO tew_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","heḏi nä́ˀin tꞌowaḏi i kwee óetu̖ˀan, “Näbáhaˀ ivíˀpiyeˀ naˀin ívíwhä̖yu̖, hewänbo u̖ untú̖ḏíḏa̖ˀbá yoe, naˀin wíˀbo iví híˀ gitꞌoe, heḏá gínhanginná taˀgendi nä́ˀi-ân tꞌä̖hkí tꞌowagîˀ i aywondi namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","In wíye thaa daphaḏe ihayḏi Jesus iwáygéḏí iyâaˀoḏi oe Galilee nangepiyeˀ namää. ");
INSERT INTO tew_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","I-á wíˀbo ho natú̖, “Wí Yôesi Táḏáví tukíˀwe dipówá ihayḏi óedaaˀanhe̖ˀbiˀ iví nangebo wíḏâyˀaˀginpí,” ");
INSERT INTO tew_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","hewänbo oe Galilee nange Jesus napówá ihayḏi in Galilee-windi óeséegíkêˀ, gá oe Jerusalem dínshánkîˀḏináˀ dihayḏi in wáˀ iwebá diyiḏân, heḏi tꞌä̖hkí iˀandiˀ óemûˀ. ");
INSERT INTO tew_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ee Galilee nange iwebá, i búuˀúˀay Cana gin dâytu̖ˀo iwepiyeˀ Jesus nawáymää. Iwânkun naná hä́ndíḏí pꞌoeḏi ho iméenapaa. Ee Cana wí sen hayˀi nayiˀ, heḏi iví eˀnú oe Capernaum búuˀúˀay iwe ûnhaykꞌóe. ");
INSERT INTO tew_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nä́ˀi sendá ûnhanginpóe Jesus oe Judea nangeḏi naˀä̖ä̖ḏi Galilee nange napówáˀin, heḏiho Jesus naˀä́n diwepiyeˀ namääḏi óetsikáyin, “Ti navíˀpiyeˀ unmú-í naví ay dînhehkháamä̂äníḏí? I-á chuwa kꞌáygé nakꞌóe.” ");
INSERT INTO tew_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus-di óetu̖ˀan, “Un tꞌowa tꞌä̖mägîˀ pínnán tꞌôe bînmúndepíḏá háˀto navíˀpiyeˀ úvíwhä̖yú̖-í.” ");
INSERT INTO tew_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","I sendi Jesus óetu̖ˀan, “Naˀinbí Sedó, naa-áḏí ókä̖ˀve naví ay hehkháa dînmä̂äníḏí wíḏînchúu-ípíḏí.” ");
INSERT INTO tew_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus-di óetu̖ˀan, “Uvíˀpiyeˀ ópûn, uví ay ú̖wówahoˀ.” I sen háa Jesus-di óetu̖ˀan waa iwhä̖yu̖, heḏihoˀ iweḏi namää. ");
INSERT INTO tew_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Waˀḏi namän dihayḏiboˀ iví tꞌôeˀindi óeyayḏi óetu̖ˀan iví ay ûnwówaˀin. ");
INSERT INTO tew_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iḏi ovâytsikáyin, “Hä̖́yú̖ ihayḏan naná ûnhehkháapóe ihayḏi?” Óetu̖ˀan, “Tsá̖ˀdi théˀêeḏi wîˀ iwe i tsá̖wä̖pꞌíḏe ûnhán.” ");
INSERT INTO tew_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","I táḏá ûnˀánpówá wîˀ ihayḏibá nanáˀnin Jesus-di óetu̖ˀan dihayḏi, “Uví ay ú̖wówa,” heḏihoˀ i-áḏí iví kꞌaygiˀindáḏí Jesus-víˀpiyeˀ dívíwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus Judea-ḏi namääḏi oe Galilee waˀ nayiˀ ihayḏi, nä́ˀinho in wáygíngíˀin pínnán ovâykeeyannin namuu. ");
INSERT INTO tew_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wíyá hä̖̂ä̖ḏi nanáˀ diwe in Huḏíyo dínshánkîˀḏiná, heḏi Jesus oe Jerusalem-piyeˀ nawáymää. ");
INSERT INTO tew_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Oe Jerusalem wí pꞌobúˀay nakꞌóe, i-á Hebrew tu̖u̖ḏi “Bethesda” gin dâytu̖ˀoˀ. Pꞌo kíngé pꞌá̖a̖nú pohtâaˀây nawhaaḏikwꞌó̖, heḏi iwe núˀ wên phóḏi nachá̖ i búuˀúˀin tehpaa iwe, “Kꞌúwágíˀin Phóḏi” gin dâytu̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","5","Nä́ˀi pohtâa phoeˀo eeye báyékí tꞌowa dihaywhaakwꞌó̖. Wáy wên ditsíˀtꞌaamuu, wáy wêndá pówhá̖ˀnin dimuu, heḏá wây-á wíḏínˀa̖ˀyä̖kankoeḏipí. Iwe wí sen powintä̖ˀḏi khâave pa̖a̖yo nahayˀiˀ nakꞌóe. ");
INSERT INTO tew_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus-di nä́ˀi sen iwe nakꞌóeḏí óemûˀ, heḏi ûnhanginná báyékí pa̖a̖yo nahayˀin, heḏihoˀ óetsikáyin, “Ti ú̖hehkháapúwíˀin undaˀ?” ");
INSERT INTO tew_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","I nahayˀiḏi Jesus óetu̖ˀan, “Mä́ˀmä̂ä, naa toˀwí wänbo wíḏînˀä́npí dípꞌosóge-íḏí napꞌoˀa̖ˀyä̖poˀ ihayḏi. Waˀḏi otsꞌú̖níḏí dáysóˀḏíndeˀ ihayḏiboˀ, wíyá toˀwí-á naví páaḏébo-á natsꞌúya̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus-di óetu̖ˀan, “Ówí̖nú, uví who̖hpa̖ˀay mänkeˀḏi óyíyé.” ");
INSERT INTO tew_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wesebo i sen nawówaḏi iwí̖nú, heḏi iví who̖hpa̖ˀay ikêˀḏi natsiyeḏee. I thaa nä́ˀin napóe ihayḏi Huḏíyoví kaykhanwówá thaa-á naná. ");
INSERT INTO tew_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","In pꞌóˀḏéḏíˀin Huḏíyoḏi i sen óetu̖ˀan, “Nää thaa kaykhanwówá thaa naná. Nakhâ̖a̖kꞌóe uví who̖hpa̖ˀay wóegé unyê̖e̖níḏí.” ");
INSERT INTO tew_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Iḏi ovâytu̖ˀan, “I sen dînhehkháaˀandiḏân dítu̖ˀan, ‘Uví who̖hpa̖ˀay mänkeˀḏi óyíyé.’ ” ");
INSERT INTO tew_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","13","Indi óetsikáyin, “To-an i sen namuu haˀwâa wóetu̖ˀandiˀ?” Hewänbo i sen nawówaˀiˀ wíˀûnhanginnáhpí toˀwí namuuˀin, gá báyékí tꞌowa iwe diyiḏân, heḏi Jesus-á óemûˀpíḏíbo iweḏi iyâaˀan. ");
INSERT INTO tew_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hây napóe ihayḏi Jesus-di i sen i méesate hayˀi iwe óeyay, heḏi óetu̖ˀan, “Ótꞌóyan, ú̖hehkháapóe, heḏiho nää-á wíyá wívitꞌaywó̖ˀnâamípí, hä̖ä̖wí shánkí pꞌä́ndíkîˀ wíˀú̖púwípíḏí.” ");
INSERT INTO tew_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","I sen iwáygéḏí namääḏi in Huḏíyoví pꞌóˀḏéḏíˀin ovâytu̖ˀan Jesus-dânho hehkháa óemä́giˀin. ");
INSERT INTO tew_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Heḏiho nä́ˀindi Jesus óeyanäkímáa, gá ki̖ˀbi hä̖ä̖wí ikanhondân kaykhanwówá thaa eeye wänboˀ. ");
INSERT INTO tew_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus-di ovâytu̖ˀan, “Naví Táḏá hä̖̂ä̖ḏi wänbo tꞌä̖hkí itꞌôemáa, heḏi naa-á hanbá, heḏânho nä́ˀi hä̖ä̖wí dókanhon.” ");
INSERT INTO tew_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nä́ˀin natú̖ ihayḏi in Huḏíyoví pꞌóˀḏéḏíˀin shánkí wänbo didaˀ óeḏahéyíˀin, i kaykhanwówá thaa iˀaˀginhá̖núndeḏiḏa̖ˀbá yoe, hewänbo wáˀ natú̖ḏân Yôesi Táḏá-á iví táḏá ûnmuu, heḏi kindiḏihoˀ hä̖ä̖wí i-áḏí Yôesi Táḏá-áḏí handa̖ˀ damuu waagibá iˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus-di ovâytu̖ˀan, “Háa i Táḏá iˀoˀin naa dómúndeˀ, heḏi inbá naa dáyˀoˀ. Naa i ay omuuˀi wíḏînkoeḏipí hä̖ä̖wí wíˀbo dáyˀa̖míḏí. Hä̖ä̖wí i Táḏá iˀoˀi naa hanbá dáyˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","I Táḏáḏí naa díséegí, heḏiho hä̖ä̖wí tꞌä̖hkí iˀoˀi dînkeeyoˀ, heḏi iḏá hä̖ä̖wí shánkí heˀendi-á dóˀa̖míˀiˀin naa dînkeekankhâymáa, heḏânho un wovâyháaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","I Táḏáḏí tꞌowa dichuuˀin ovâywáywówápaˀ, heḏi handiḏibá naa i ay omuuˀiḏi in toˀwên naa odaˀin wówátsi dovâymä̂äní. ");
INSERT INTO tew_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","I Táḏá wänbo wínatú̖nípí tꞌowaví̖ˀgeḏi háa híwó̖ˀ háa híwó̖ˀpí dívíˀannin. Iḏi naa i ay omuuˀi dînkꞌûˀ han dóˀa̖míḏí, heḏânho tꞌä̖hkí tꞌowaḏi naa díˀaˀgeeníḏí, i Táḏá óeˀaˀgin waabá. Toˀwêndi naa i ay omuuˀiˀ wíḏíˀaˀginpíḏí i Táḏá naa dísandiˀ wänbo-á wíḏâyˀaˀginpí. ");
INSERT INTO tew_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Taˀgendi wâytu̖máa, toˀwên naví híˀ dîntꞌóyandeḏi heḏá i naa dísandivíˀpiyeˀ dívíwhä̖yundeḏá wówátsi nahándepíˀin dâymáa, heḏi wíˀovâytuchä̖nú-ípí. Chuˀin waagiˀinbá nää wíḏimuupí, gá wówátsi dâykêˀḏân. ");
INSERT INTO tew_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Taˀgendi wâytu̖máa, nää iweḏi páaḏépiyeˀ in chuˀin waagiˀinbá dimuuˀin naví tu̖u̖ ditꞌóe-í, naa Yôesi Táḏáví ay omuuˀiˀ, heḏi in dívítꞌóyandeˀindá wówátsi dâykéyí. ");
INSERT INTO tew_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","I Táḏá in wówátsi napä̖yiˀ, heḏi handiḏibá naa i ay omuuˀi dînkꞌûˀ tꞌowa dovâywówátsimä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Heḏá iḏá naa dînkꞌûˀ tꞌowa dovâykeekwꞌôeníḏí háa híwó̖ˀ háa híwó̖ˀpí dívíˀannin, gá naa wáˀ tꞌowabá opóeḏân. ");
INSERT INTO tew_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nä́ˀin naví híˀ wâytu̖máaˀindi wíwovâyháaˀa̖mípí. Owáy wí thaa nanáˀ diwe in penípho eeye dikwꞌó̖ˀnin naví tu̖u̖ ditꞌóe-í, ");
INSERT INTO tew_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","heḏi ee dikhä̖ˀkwꞌó̖ˀ deeyeḏi dipeegítꞌóe. In toˀwên híwó̖ˀ dívítsiyeˀannin chuwa iweḏi ovâypiyegítꞌóe wówátsi dâykéyíḏí, heḏi in toˀwên yä̖ˀḏâapí dívítsiyeˀannindá chuwa iweḏi wáˀ ovâypiyekhâymáa inbí tuchä̖nu dâykéyíḏí. ");
INSERT INTO tew_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Naa wíˀbo háabo wíḏînkoeḏipí dáyˀa̖míḏí, hewänbo naa tꞌowaví̖ˀgeḏi otû̖ˀ háawin dimuuˀin Yôesi Táḏáḏí dítu̖ˀan waabá, heḏânho háa otû̖ˀ waa inbí̖ˀgeḏi taˀgen namuu, gá dáyˀoḏân háa i Táḏá naa dísandiˀ nadaˀ waagi, háa naa owänpidaˀ waagá yoe.” ");
INSERT INTO tew_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Naa wíˀbo naví̖ˀgeḏi dáyhíˀmáaḏí maˀḏân un ítú̖ní naví híˀ taˀgen wíḏînmuupíˀin. ");
INSERT INTO tew_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hewänbo wíyá toˀwí naví̖ˀgeḏi ihéeˀoˀi nayiˀ, heḏi naa dînhanginná háa naví̖ˀgeḏi ihéeˀoˀin taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Undá John i pꞌóˀpꞌoekandivíˀpiyeˀ tꞌowa bînsan óehéeˀa̖míḏí, heḏi i-á in taˀgen naví̖ˀgeḏi natú̖. ");
INSERT INTO tew_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Háa tꞌowa naví̖ˀgeḏi ditû̖ˀ waa naa-á wíḏîntáypí, hewänbo John-bí híˀ i̖ˀgeḏi wâytu̖máa heḏânho háa natú̖ˀin úvíwhä̖yú̖-íḏí heḏá wovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John-dá wên phakó nakomuuḏi nakohkeepä̖yiˀin waagibá namúˀde, heḏi wí hây tä̖hkí ho iví kohthayḏi wovâyhíhchannan. ");
INSERT INTO tew_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Hewänbo wí hä̖ä̖wí shánkí hayˀi namuu John-bí híˀvíweḏi, heḏi nä́ˀi hä̖ä̖wíḏá wovâykeeyoˀ toˀwí omuuˀin. Kinnân namuu: Háa i Táḏáḏí díyôn waa dáykanhon, heḏi nä́ˀi hä̖ä̖wí dáykanhondiˀ bînmûˀḏi wovâykeeyoˀ i Táḏáḏí naa dísannin. ");
INSERT INTO tew_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Heḏá i Táḏá dísandiˀ wáˀ naví̖ˀgeḏi ihéeˀan. Hewänbo undá hä̂nhay wänbo iví tu̖u̖ wíˀítꞌoepí, heḏi háawi i namuuˀin wívînmûˀpí, ");
INSERT INTO tew_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","heḏi iví híˀ unbí píˀnä́ khóˀyé wívînmáapí, gá navíˀpiyeˀ wíˀúvíwhä̖yundepíḏan, tobá iḏi dísan wänboˀ. ");
INSERT INTO tew_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yôesi Táḏáví ta̖ˀnin á̖yîngiḏi bîntu̖u̖ˀoˀ, gá íˀándeḏân iwe únhanginpúwíˀin háḏíḏí wówátsi nahándepíˀin bînkéyíˀin, heḏi nä́ˀin ta̖ˀnin diwebá naví̖ˀgeḏi natû̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hewänbo navíˀpiyá wíˀíkä̖ˀä̖ä̖daˀpí nä́ˀin wówátsi bînkéyíḏí. ");
INSERT INTO tew_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Tꞌowa naví̖ˀgeḏi híwó̖ˀ dívíhéeˀa̖míˀin naa wóˀwänpitꞌoedaˀpí. ");
INSERT INTO tew_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Háawin un ímuuˀin naa dînhanginná. Unbi píˀnä́ khóˀyé Yôesi Táḏá wívînséegípí. ");
INSERT INTO tew_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naví Táḏáḏí dísandibo oˀä̖ä̖ heḏi undi wíḏíséegíkêˀpí. Hewänbo wíyá toˀwí wíˀbo nawänpiˀä̖ä̖ḏá, i-á maˀ bînséegíkéyí. ");
INSERT INTO tew_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Háa i wîˀḏa̖ˀ Yôesi naˀä́ndiˀ unbí̖ˀgeḏi natû̖ˀnin á̖yîngi wíwovâymähpí, háa híwó̖ˀgí natû̖ˀ háa yoe, hewänbo in tꞌowa híwó̖ˀ unbí̖ˀgeḏi dívíhéeˀoḏá inbí tu̖u̖ híhchandi bînhóndeˀ. Heḏânho wíˀúnkoeḏipí navíˀpiyeˀ úvíwhä̖yú̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Hewänbo wíˀíˀâ̖a̖nípí naaḏân unbí tꞌaywó̖ˀdi i̖ˀgeḏi i Táḏá dótꞌehpiḏekhâymáaˀin. Íˀándeˀ nä́ˀi híˀ Moses ita̖ˀnandiḏi wovâyˀaywonkhâymáaˀin, hewänbo iví híˀḏíbá unbí tꞌaywó̖ˀdi únkeepúwí, heḏiho iḏân wovâytꞌehpiḏekhâymáa. ");
INSERT INTO tew_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses naví̖ˀgeḏi ita̖ˀnan, heḏiho iví híˀ taˀgendi bînwhä̖yu̖ḏáho navíˀpiyeˀ wáˀ úvíwhä̖yú̖-íwän. ");
INSERT INTO tew_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hewänbo háa ita̖ˀnannin wívînwhä̖yundepí, heḏânho háḏíḏan naví híˀ dînwhä̖yú̖-í?” kin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wíyá hä̖̂ä̖ḏi Jesus oe Galilee pꞌoekwí̖ˀ pꞌä̖́näpiyeˀ namää. (Nä́ˀi pꞌoekwîndá Tiberias wáˀ gin dâytu̖ˀoˀ.) ");
INSERT INTO tew_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Báyékí tꞌowaḏi iví pínnán ovâykeeyandi in dihayˀin ovâyhehkháamä̖ḏi dâymûˀḏi óeyu̖u̖hon. ");
INSERT INTO tew_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","In Huḏíyoví shánkîˀḏi Passover gin dâytu̖ˀoˀi púnúˀ naná. Jesus-á iví khä̖ge̖ˀnindáḏí oe pꞌin kwꞌáyepiyeˀ dipee heḏi iwe dívíkwꞌóḏi. ");
INSERT INTO tew_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus ibéeḏí báyékí tꞌowa ivíˀpiyeˀ diˀä̖ḏi ovâymûˀ, heḏiho Philip óetsikáyin, “Wä̖́hä̖̂ä̖-an ihay koegiˀ âyku̖mä́-í tꞌä̖hkí nä́ˀin tꞌowa dâykꞌóe-ígîˀ?” ");
INSERT INTO tew_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesus-á wíˀbo ûnhanginná háa ikhâymáaˀin, hewänbo nä́ˀin Philip óetsikáyin óetayi̖ˀníḏí hânnangúbá natú̖níˀin. ");
INSERT INTO tew_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip-di óetu̖ˀan, “Wáygín tä̖gintä̖ (200) thaa tꞌôe dívíˀandi wáˀâa ihay waˀ wínayipí ovâykoegiˀku̖mä́-íḏí, tobá tꞌä̖hkíḏíbo hí̖ˀínda̖ˀ diyä̖́mu wänboˀ.” ");
INSERT INTO tew_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Wíyá khä̖ge̖ˀdiˀ Andrew gin nakhá̖wä̖́ˀiˀ, i-á Simon Peter-ví tíˀûu ûnmuuˀiḏi Jesus óetu̖ˀan, “Nä́we wí enúkáy nayiˀ, i-á pꞌá̖a̖nú táhtá̖ phóˀi páváˀây heḏá wíye paa-á imáa, hewänbo hä̖ˀi-á ihay wínayipí tꞌä̖hkí nä́ˀin tꞌowa ovâyhúuyôeníḏí.” ");
INSERT INTO tew_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iwáygé báyékí natáasaa, heḏiho Jesus iví khä̖ge̖ˀnin itu̖ˀan in tꞌowa nangeboˀ ovâykwoyôení, heḏi han dívíˀan. In senäˀda̖ˀdibo pꞌá̖a̖nú maapaasôn (5,000) ihay diyiˀ. ");
INSERT INTO tew_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus i pává ihógiḏi Yôesi Táḏá óekú̖ˀdaaˀan, heḏi iví khä̖ge̖ˀnin ovâyˀandi ovâytu̖ˀan in tꞌowa iwáygé dikwꞌó̖ˀnin wí̖ˀínboˀ ovâymä̂äníḏí, heḏi hanbá in paa-á ovâymä́gi. Hä̖́yú̖ in tꞌowa didaˀ ihay dâykꞌoe, ");
INSERT INTO tew_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","heḏi dívíshu̖ˀan dihayḏi Jesus iví khä̖ge̖ˀnin itu̖ˀan, “Binwé̖ˀgeˀan hä̖ˀi dínphaḏeˀiˀ, heḏânho hä̖ä̖wí wänbo wínapeḏée-ípíḏí.” ");
INSERT INTO tew_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Heḏiho tꞌä̖hkí dâywé̖ˀgeˀan dihayḏi, tä̖ˀḏi wíye tꞌún dâypꞌíḏe i naphaḏeˀi pává iweḏi, in tꞌowa i pꞌá̖a̖nú páváˀây dâykꞌoe ihayḏi. ");
INSERT INTO tew_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","In tꞌowa nä́ˀin pínnán ovâykeeyannin dâymûˀḏi ditú̖, “Taˀgendi nä́ˀi-ân i Yôesi Táḏáví tukhe̖ˀbiˀ namuu, iví̖ˀgeḏi nata̖ˀmuu nä́ä oepáa kꞌayḏipiyeˀ naˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus ûnhanginná didaˀ óekaygikhâymáaˀin inbí tsondi hayˀiˀ óesóge-íḏí, heḏihoˀ iwáygéḏí wíyá oe pꞌin kwꞌáyepiyeˀbá wíˀbo namää. ");
INSERT INTO tew_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kindi napuwamän dihayḏi Jesus-ví khä̖ge̖ˀnin oe pꞌoekwíngépiyeˀ diwhá̖. ");
INSERT INTO tew_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wí kophênbay iwe dívítógi, pꞌoekwí̖ˀ pꞌä̖́näpiyeˀ oe Capernaum-piyeˀ diwáymu-íḏí. Waˀ dimän dihayḏiboˀ nakhu̖u̖póe, heḏi Jesus inbíˀwe waˀḏi wínapówápí. ");
INSERT INTO tew_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ihayḏi kaygi iwa̖a̖ˀan heḏi hânho napꞌoetꞌúkhú̖póe. ");
INSERT INTO tew_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","I kophênbay i dâyˀosandeˀi phéḏí dâysayḏeˀ, heḏi maˀḏi poeye háa yôenu míya dimää ihayḏi Jesus pꞌoe kwꞌáayé nayiḏi i kophênbay tsoˀwapiyeˀ naˀä̖ḏi óemûˀ, heḏi dikhuwôedaˀpóe. ");
INSERT INTO tew_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Hebo iḏá ovâytu̖ˀan, “Naa Jesus-ân omuu, wíˀíkhuwôedaˀípí.” ");
INSERT INTO tew_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Heḏiho híhchandi kophênbay iwe óetógi, heḏi pꞌo kí̖ˀge dimänninnäpiyeˀ wesebo dipówá. ");
INSERT INTO tew_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","In báyékí tꞌowa waˀḏi oe pꞌoˀ pꞌä̖́näbo diyiˀindi Jesus-ví khä̖ge̖ˀnin ho ovâymûˀ i kophênbay iwe wíˀbo dívítógiḏi iweḏi dimú-íḏí, heḏiho dínhanginná Jesus indáḏí wínamääpíˀin. Wîˀḏa̖ˀ wí kophênbay iwe naˀä́nwän, heḏiho diˀân Jesus-á waˀḏi iwebo naˀä́nnin. ");
INSERT INTO tew_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wíyá tháwä́ndá wây-á kophênbay hí̖ˀínnin oe Tiberias búuˀúḏí diˀä̖ä̖, heḏi iwáy Jesus i pávágîˀ ikú̖ˀdaamä́giḏi in tꞌowa dâykꞌoe iwe tsoˀwa diwhiˀkwꞌó̖. ");
INSERT INTO tew_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Heḏi Jesus-á iví khä̖ge̖ˀnindá iwe wíḏiyipíˀin in tꞌowa dâymûˀ ihayḏi, in kophênbay eeye dívítógikíḏí oe Capernaum búuˀúˀaypiyeˀ dimää óenuwä̖́-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","In tꞌowaḏi Jesus oe pꞌoˀ pꞌä̖́nä óeshaaḏi óetsikáyin, “Há̖hkandiˀ, hä̖̂ä̖ḏan unpówá nä́we?” ");
INSERT INTO tew_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus-di ovâytu̖ˀan, “Taˀgendi wâytu̖máa, i pínnán naaḏi wâykeeyandibo nakeepoˀ naa Yôesi Táḏávíˀweḏi oˀä̖ä̖ˀin, hewänbo hä̖ˀi bînmûˀḏi naa ví khä̖ge̖ˀnindá iwe wíḏiyiwíḏítu̖wä̖máapí, i pává bînkꞌoeḏi íshu̖hpóeḏíbo dítu̖wä̖máa. ");
INSERT INTO tew_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","I koegîˀ wówátsi nahándepíˀin napä̖yiˀipiyeˀ úvíkhä̖ä̖-í, i koegîˀ naháˀḏä̂npoˀipiyeḏa̖ˀbá yoe. Naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiḏi ki̖ˀbi koegîˀ wâymä̂äní, gá Yôesi Táḏáḏí keeˀeeḏi dînkꞌûˀḏân kin dáyˀa̖míḏí” kin ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Heḏiho óetsikáyin, “Hânnan ívíˀa̖mí Yôesi Táḏá âyhíhchanmä̂äníḏí?” ");
INSERT INTO tew_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus-di ovâytu̖ˀan, “Gá kinnân: Naa i Yôesi Táḏáḏí dísandivíˀpiyeˀ úvíwhä̖yú̖-í. Nä́ˀinnân Yôesi Táḏá nadaˀ úvíˀa̖míˀin.” ");
INSERT INTO tew_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Indi óetsikáyin, “Háawin pínnánnan u̖ḏi dînkeeya̖mí heḏânho wînwhä̖yú̖-íḏí? Hânnan bikhâymáa? ");
INSERT INTO tew_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Naˀinbí hehä̖̂ä̖win thehtáy pahpáˀin gínmuuˀin owáy ahkónu iwéngé diyiˀ ihayḏi nä́ˀi koegîˀ manna gin dâytu̖ˀoˀi dâykꞌoe. Yôesi Táḏáví ta̖ˀnin diwe kinnân nata̖ˀmuu: Pává makówáḏí ovâymä́gi dâykꞌóe-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ti hä̖ä̖wí ihaybá ú̖koeḏi?” Jesus-di ovâytu̖ˀan, “Taˀgendi wâytu̖máa, Moses-á hä̖ˀi pává wíˀimä́gipí, naví Táḏá-ân imä́gi. Heḏi hä̖ˀi pává-á koḏi̖ˀdi makówáwi pává wínamuupí, hewänbo nää-á naví Táḏáḏá taˀgendi makówáwi pává wovâymäˀ. ");
INSERT INTO tew_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Heḏi nä́ˀi pává Yôesi Táḏá napä̖yiˀi-á makówáḏí naˀä̖ä̖ˀi namuu, heḏi tꞌä̖hkí tꞌowa wówátsi ovâymäˀ.” ");
INSERT INTO tew_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Indi óetu̖ˀan, “Naˀinbí Sedó, hä̖̂ä̖ḏi wänbo tꞌä̖hkí ki̖ˀbi pává dímä́ˀve-í.” ");
INSERT INTO tew_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus-di ovâytu̖ˀan, “Naa-ân pává waagiˀbá omuu, tꞌowa wówátsi napä̖yiˀiˀ. Toˀwí navíˀpiyeˀ naˀä̖ä̖ˀi-á háˀto naha̖hséní, heḏi toˀwí navíˀpiyeˀ iwhä̖yu̖ˀi-á háˀto napꞌoesáˀaapúwí. ");
INSERT INTO tew_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Hewänbo ho wâytu̖ˀan waa, tobáháa dímûˀ wänboˀ, naa wíḏînwhä̖yundepí. ");
INSERT INTO tew_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Toˀwên naví Táḏáḏí naa dímäˀin navíˀpiyeˀ diˀä̖́ä̖-í, heḏi toˀwí wänbo navíˀpiyeˀ naˀä̖ä̖ˀi-á naaḏi háˀto dóyoegiˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Naa oe makówáḏí owhá̖ dáyˀa̖míḏí háa iḏi dísandiˀ nadaˀ waagi, háa naa odaˀ waagá yoe. ");
INSERT INTO tew_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","I dísandiˀ nadaˀ in tꞌowa naa dímä́giˀin naaḏi dovâyˀá̖yîngiˀa̖míˀin heḏânho wîˀ wänbo in diweḏi wínapeḏée-ípí, hewänbo i tꞌä̖ˀgi thaa nanáˀ dihayḏi naaḏi in tꞌä̖hkí wíyá dovâywáywówápaa-í. ");
INSERT INTO tew_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kinho naví Táḏá nadaˀ dáyˀa̖míˀin, gá nadaˀḏân tꞌä̖hkí in dínhanginnáˀnin naa iví ay omuuˀin, heḏá navíˀpiyeˀ dívíwhä̖yundeˀin wówátsi nahándepíˀin dâymáˀve-íˀin. Heḏi i tꞌä̖ˀgi thaa nanáˀ dihayḏi naaḏá wíyá dovâywáywówápaa-í” kin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","In Huḏíyoví pꞌóˀḏéḏíˀin iví̖ˀgeḏi dívítꞌayhíˀmáa, gá natú̖ḏân, “Naa-á i pává makówáḏí owhá̖ˀdi-ân omuu.” ");
INSERT INTO tew_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kinnân ditû̖ˀ: “Nä́ˀi-á Jesus namuu, i-á Joseph-ví ay namuupíˀan. Iví táḏá-á iví yíyá-á âytaa. Heḏi háaḏan nää-á natû̖ˀ makówáḏí nawhân gin?” ");
INSERT INTO tew_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus-di ovâytu̖ˀan, “Haˀwâagi wíˀúvítꞌayhíˀmáˀve-ípí. ");
INSERT INTO tew_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Toˀwí wänbo wíˀûnkoeḏipí navíˀpiyeˀ naˀä̖́ä̖-íḏí, naví Táḏá i dísandiḏi navíˀpiyeˀ óemaaḏiḏa̖ˀmânhoˀ. Heḏi in navíˀpiyeˀ diˀä̖ä̖ˀindá dovâywáywówápaa-í i tꞌä̖ˀgi thaa nanáˀ dihayḏi. ");
INSERT INTO tew_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wí Yôesi Táḏáví tukhe̖ˀbiˀ hä́nˀoe kinnân ita̖ˀnan: Yôesi Táḏáḏân tꞌä̖hkí tꞌowa ovâyhá̖ˀa̖mí. Heḏiho nää toˀwên naví Táḏá ôntꞌóyannindi ivíˀweḏi dihá̖hpóeˀin navíˀpiyeˀ diˀä̖́ä̖-í. ");
INSERT INTO tew_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Naa wóˀtû̖ˀpí toˀwíḏí i Táḏá óemûˀin. Naaḏiḏa̖ˀmân Yôesi Táḏá dómûˀ, gá ee naˀä́n diweḏi oˀä̖ä̖ḏân. ");
INSERT INTO tew_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Taˀgendi wâytu̖máa, toˀwí wänbo navíˀpiyeˀ iwhä̖yundeˀi wówátsi nahándepíˀin imáa. ");
INSERT INTO tew_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naa pává in tꞌowa nawówátsipä̖yiˀi waagiˀbá omuu. ");
INSERT INTO tew_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tobá unbí hehä̖̂ä̖win thehtáy pahpáˀin oe ahkónu wéngé diyiˀ ihayḏi i koegîˀ manna kin dâytu̖ˀoˀiḏi ovâykhóekhú̖u̖mä́gi wänboˀ, tíˀúugéḏí ditꞌa̖hán. ");
INSERT INTO tew_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hewänbo nää naaḏá pává makówáḏí nawhân niˀgeḏi wâytu̖máa, heḏi wí toˀwí nä́ˀiḏi óekhóekhú̖u̖mä́giˀi háˀto nahá̖a̖ní. ");
INSERT INTO tew_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naa-ân i pává makówáḏí naˀä̖ä̖ḏi wówátsi napä̖yiˀi waagiˀbá omuu. Toˀwên nä́ˀi páváḏí ovâykhóekhú̖u̖mä́giˀin hä̂nhay wänbo tꞌä̖hkí dâywówátsimáˀve-í. Nä́ˀi pává naví túuˀú dînmuu tꞌä̖hkí tꞌowa dovâypä̖gítꞌóeˀi dâywówátsikéyíḏí” kin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ihayḏiho in Huḏíyoví pꞌóˀḏéḏíˀin dívítu̖hkannan. Wáy wên ditsikapóe, “Hândiḏan nä́ˀi sendi iví túuˀú dípä̖gítꞌóe díkhóekhú̖u̖mä̂äníḏí?” ");
INSERT INTO tew_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus-di ovâytu̖ˀan, “Taˀgendi wâytu̖máa, naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiví tûu ûnpꞌoeḏi wíwovâykhóekhú̖u̖mä́gipíḏáhoˀ, wówátsi wänbo wívînmáapí. ");
INSERT INTO tew_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Toˀwên tꞌä̖hkí naví tûu ûnpꞌoeḏi ovâykhóekhú̖u̖mä́giˀindá wówátsi nahándepíˀin dâymáa, heḏá naaḏá i tꞌä̖ˀgi thaa nanáˀ dihayḏi dovâywáywówápaa-í. ");
INSERT INTO tew_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Naví túuˀú taˀgendi koegîˀ waagiˀbá namuu, heḏá naví ûnpꞌoe-á taˀgendi su̖wä̖gîˀ waagiˀbá-á. ");
INSERT INTO tew_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Toˀwí naví tûu ûnpꞌoeḏi óekhóekhú̖u̖mä́giˀi-á naa-áḏí namuu heḏá naa-á i-áḏá. ");
INSERT INTO tew_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Naví Táḏáḏí naa dísandi-á i hä̖̂ä̖ḏi wänbo tꞌä̖hkí nawówáyiˀi namuu, heḏi i-á nawówáyiḏi naa-á owówáyiˀ. Handiḏibá toˀwí naaḏi dókhóekhú̖u̖mä́giˀi navíˀweḏi íwówátsikéyí. ");
INSERT INTO tew_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Heḏiho naa-ân i pává makówáḏí naˀä̖ä̖ˀiˀ omuu, i pává unbí hehä̖̂ä̖win thehtáy pahpáˀin dâykꞌoeˀiˀ waagiˀbá wíˀomuupí. Hä̖ˀi pává dâykꞌoe wänbo tíˀúugéḏí ditꞌa̖hán. Hewänbo toˀwên i pává naa omuuˀiˀ dâykꞌoeˀindá hä̂nhay wänbo tꞌä̖hkí dâywówátsimáˀve-í.” ");
INSERT INTO tew_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus nä́ˀin natú̖ oe Capernaum búuˀúˀay, i Huḏíyoví méesateˀay iwe in tꞌowa ovâyhá̖ˀoˀ ihayḏi. ");
INSERT INTO tew_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Báyékí i-áḏí dimäˀnin ditꞌoeḏi ditú̖, “Nä́ˀi híˀ-á nakâymuu âyhóníḏí. To-an iséegíˀa̖mí?” ");
INSERT INTO tew_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hewänbo toˀwíḏí wänbo óetu̖ˀanpíḏí Jesus ûnhanginná nä́ˀi ovâytu̖ˀan niˀgeḏi dívítꞌayhíˀmáaˀin, heḏihoˀ ovâytsikáyin, “Ti nä́ˀi naaḏi wâytu̖ˀandiˀ wíwovâyhí̖ˀanpíḏí naa-áḏí wíyá wíˀípundaˀpí? ");
INSERT INTO tew_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hân íˀâ̖a̖ní undi naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀi dímûˀḏi kwꞌáyepiye owáypeeḏi páaḏé oˀä́n diwepiyeˀbá? ");
INSERT INTO tew_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","I Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ nawówátsipä̖yiˀ, tꞌowa-á wíˀbo wíḏínkoeḏipí. I híˀ naaḏi wâytu̖máaˀiˀ i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖víˀweḏi naˀä̖ˀ heḏi nä́ˀi híˀ-áho nawówátsipä̖yiˀ. ");
INSERT INTO tew_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hewänbo wáy wên un wíˀúvíwhä̖yundepí.” Jesus-di haˀwâa ovâytu̖ˀan gá páaḏéḏíbo ho ûnhanginnândân toˀwên ivíˀpiyeˀ wíḏívíwhä̖yu̖khâymáapíˀin dimuuˀin, heḏá ûnhanginnân wáˀ toˀwíḏí óeku̖hpegítꞌóeˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Heḏá wáˀ ovâytu̖ˀan, “Kindiḏânkun wâytu̖ˀan, toˀwí wänbo navíˀpiyeˀ wíˀûnkä̖ˀä̖ä̖koeḏipí naví Táḏáḏí óemä́giḏiḏa̖ˀmân.” ");
INSERT INTO tew_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iví híˀ ûnmuuḏi báyékí in óeyu̖u̖honnin i-áḏí wíyá wíḏipundaˀpí, heḏiho óeyoeˀan. ");
INSERT INTO tew_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Heḏi Jesus iví tä̖ˀḏi wíye khä̖ge̖ˀnin itu̖ˀan, “Heyâa un, ti undi wáˀ díyoeˀa̖míˀin ídaˀ?” ");
INSERT INTO tew_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter-di óetu̖ˀan, “Naˀinbí Sedó, tovíˀpiyanho gimú-í? U̖ḏiḏa̖ˀmân dítu̖máa háḏíḏí nä́ˀin wówátsi nahándepíˀin âykéyíˀin. ");
INSERT INTO tew_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Naˀin ívíwhä̖yu̖mä́giho heḏá gínhanginnânhho u̖ i shánkí yä̖ˀḏâaˀi unmuuˀin, i Yôesi Táḏáḏí wóesandiˀ.” ");
INSERT INTO tew_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus-di ovâytu̖ˀan, “Naaḏi wíˀbo un tä̖ˀḏi wíye wâyde̖ˀmanpíˀan, hewänbo wîˀ unbíˀweḏi Penísendi waagiˀbá namuu.” ");
INSERT INTO tew_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Simon Iscariot-ví ayví̖ˀgeḏi ihíˀmáa, i-á Judas gin nakhá̖wä̖́, heḏi Penísendi waagiˀbá namuu gin Jesus-di óetu̖ˀan gá tobá in tä̖ˀḏi wíye khä̖ge̖ˀninbíˀweḏi namuu wänbo Jesus óeku̖hpekhâymáaḏân. ");
INSERT INTO tew_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nä́ˀi hä̖ä̖wí naphaḏe ihayḏi Jesus oe Galilee nange i̖ˀge tꞌä̖hkí nayiˀ. Judea nangepiyeˀ wínamääpí, in Huḏíyoví pꞌóˀḏéḏíˀin háḏíḏíḏa̖ˀmân dítu̖máa háḏíḏí óehéyíˀin dâytu̖wä̖máaḏí. ");
INSERT INTO tew_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","In Huḏíyoví shánkîˀḏi púnúˀ naná, dáyˀóhkhu̖u̖teˀâykwꞌóeˀóˀi shánkîˀḏi gin dâytu̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Heḏiho Jesus-ví tíˀûuwindi óetu̖ˀan, “Nä́weḏi ópûn heḏi oe Judea nangepiyeˀ unmú-í, heḏânho in tꞌowa uvíˀpiyeˀ dívíwhä̖yundeˀin iwe diyiˀindi i pínnán tꞌôe biˀoˀin wóemúníḏí. ");
INSERT INTO tew_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Toˀwí in tꞌowaḏi keeˀeeḏi óetaa-íˀin nadaˀḏi kaaḏibo háawên wíˀiˀopí. Heḏânho ki̖ˀbi hä̖ä̖wí bikanhondi, ú̖khâyˀä̖ˀ toˀwên tꞌä̖hkíví páaḏépiyeˀ biˀâ̖a̖míˀin.” ");
INSERT INTO tew_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Haˀwâa óetu̖ˀan, gá tobá iví tíˀûuwin dimuu wänboˀ ivíˀpiyeˀ wíḏívíwhä̖yundepíḏân. ");
INSERT INTO tew_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus-di ovâytu̖ˀan, “Naagîˀ ihayḏi waˀ wíḏînnáhpí, hewänbo ungîˀ-á hä̖̂ä̖ḏi wänbo tꞌä̖hkí híwó̖ˀ dihayḏi únná. ");
INSERT INTO tew_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","In tꞌowa Yôesi Táḏá dâytaapíˀin dimuuˀin háˀto wovâytꞌáy-í, hewänbo naa-ân dítꞌay, gá dovâytu̖máaḏân inbí yä̖ˀḏâapí tsiyekan niˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Unnân wáy dínshánkîˀḏináˀ diwepiyeˀ bípûn. Naa-á waˀḏi wóˀmänpí híwó̖ˀ dihayḏi naagîˀ wínanáhpíḏí” kin ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Heḏihoˀ oe Galilee nange iwebo iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iví tíˀûuwin oe dínshánkîˀḏináˀ diwepiyeˀ dimää ihayḏi tíˀúugéḏí i wáˀ namää, hewänbo kaaḏibo-ân namää, keeḏibo-á yoe. ");
INSERT INTO tew_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","In Huḏíyoví pꞌóˀḏéḏíˀindi ee dínshánkîˀḏináˀ diwe óetu̖wä̖máa, heḏi dívítsikaˀmáa, “Wáyho i toˀ?” ");
INSERT INTO tew_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","In báyékí tꞌowa iwe diyiˀin báyékí dívíkaahíˀmáa iví̖ˀgeḏi. Wên ditû̖ˀ, “Híwó̖ˀdi sen namuu” gin. Wây-á ditû̖ˀ, “Yoe, handá yoe. Iḏi báyékí tꞌowa in taˀgen namuu iweḏi ovâyyâaˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hewänbo tꞌä̖hkí in tꞌowa in Huḏíyoví pꞌóˀḏéḏíˀin dâykhuwôedaˀmáaḏí kaaḏibo iví̖ˀgeḏi dívíhíˀmáa. ");
INSERT INTO tew_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","I shánkîˀḏi píngé hayḏi naphaḏe ihayḏi Jesus i méesate hayˀi ee natsꞌú̖ heḏi in tꞌowa ovâyhá̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","In Huḏíyoví pꞌóˀḏéḏíˀin ovâyháaˀandi ditú̖, “Hândiḏangú nä́ˀi sen hânho ûnhanginná, toˀwíḏí óehá̖ˀanpí wänboˀ?” ");
INSERT INTO tew_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus-di ovâytu̖ˀan, “Naví há̖hkan navíˀinda̖ˀ wíḏînmuupí, hewänbo i dísandivíˀin wáˀ ûnmuu. ");
INSERT INTO tew_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","In toˀwên háa Yôesi Táḏá natú̖ waa dikandaˀindáho dínhanginpúwí naví há̖hkan niˀgeḏi, háa Yôesi Táḏá natú̖ waa dikandaˀindáho dínhanginpúwí naví há̖hkan niˀgeḏi, háa Yôesi Táḏávíˀweḏi dînˀä̖ä̖ˀin heḏiháa naví ánshaa i̖ˀgeḏibo dáypihíˀmáaˀin. ");
INSERT INTO tew_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","In toˀwên inbí ánshaa dínmuuˀiḏa̖ˀ dívíhéeˀoˀindá dívípitegé-íˀin didaˀ. Hewänbo toˀwên i ovâysandiˀ kwꞌáye óetegé-íˀin didaˀindá in taˀgen dívíhéeˀoˀ, heḏá inbí píˀnä́ khóˀyé-á hôeyó wänbo wíḏâymáapí. ");
INSERT INTO tew_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses-di Yôesi Táḏáví tsontu̖u̖ wovâyta̖ˀnanpíˀan, hewänbo wénä wí wänbo un iví ta̖ˀkan wívînˀaˀgindopí. Háaḏan naa díhéyíˀin ídaˀ?” ");
INSERT INTO tew_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Toˀwíḏí in tꞌowa yâaḏi óetu̖ˀan, “Háaḏan untú̖, toˀwí nadaˀ wóehéyíˀin? U̖-á wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi wóemáa, heḏânho haˀwâa untú̖.” ");
INSERT INTO tew_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus-di ovâytu̖ˀan, “Wên pínnán tꞌôe kaykhanwówá thaa iwe dáyˀandibo un tꞌä̖hkí wovâyháaˀan, ");
INSERT INTO tew_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","hewänbo undá unbí eˀnûn áyyä̖̂ä̖ in Huḏíyoví kꞌewe̖ˀ taaḏi bîntaaˀoˀ inbí thaa dínnáˀ dihayḏi tobá kaykhanwówá thaa nanân wänboˀ, gá hä́nˀoe Moses-di han wovâyyôndân. (Moses-á i páaḏéˀi wínamuupí nä́ˀin khuu iˀandiˀ, hewänbo in shánkí hä́nˀoeˀindáho hanho dívíˀan.) ");
INSERT INTO tew_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nää wí enúkáy nä́ˀin kꞌewe̖ˀ taaḏi óetaaˀoˀ kaykhanwówá thaa nanân wänboˀ, heḏânho Moses-ví tsontu̖u̖ wívînˀaˀginhá̖nú-ípíḏí. Heḏi háaḏan handi naa-áḏí ítꞌay wí sen túuˀú tꞌä̖hkíbo dônhehkháaˀandi kaykhanwówá thaa nanân wänboˀ? ");
INSERT INTO tew_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wí hä̖ä̖wí háa pu̖wä̖ḏi nakeetꞌóeˀin bînwänpimûˀḏiboˀ wesebo wíˀítú̖nípí, ‘Kinnân namuu,’ hewänbo páaḏé á̖yîngiḏi bînnuwä̖́ˀí-á háa namuuˀin, heḏânho únkoeḏí-í ítú̖níḏí taˀgendi háa namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wên tꞌowa ee Jerusalem diweˀin ditú̖, “Ti nä́ˀi sen i toˀwí naˀinbí tsonnindi óehéyíˀin didaˀi wínamuupíˀan? ");
INSERT INTO tew_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Binmúˀḏí, hä̖ˀin tꞌowa tꞌä̖hkíví páaḏépiyeˀ ihíˀmáa, heḏi toˀwí wänbo háabo wínatû̖ˀpí óewóyí̖ˀníḏí. Tigú in tsonnin dívíwhä̖yunde nä́ˀi-ân namuu i toˀwí Yôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Hewänbo kavêe i-á wínamuupí. I toˀwí Yôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí naˀä̖ä̖ ihayḏá, toˀwí wänbo wíˀûnhanginnánípí wä̖́hä̖̂ä̖wi namuuˀin, hewänbo tꞌä̖hkíḏíbo gínhanginná wä̖́hä̖̂ä̖wi nä́ˀi sen namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus-di i méesate hayˀi iwe ovâyhá̖ˀoˀ ihayḏi kaygi ovâytu̖ˀan, “Ítû̖ˀ únhanginná toˀwí omuuˀin heḏá wä̖́hä̖̂ä̖wi omuuˀindá. Naa wíˀbo opichanpóeḏíbo wóˀä̖ä̖pí. I toˀwí naa dísandiˀ taˀgendi nawówáyiˀ, heḏi undi wívîntaapí, ");
INSERT INTO tew_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","hewänbo naaḏá dótaa, gá ivíˀweḏi oˀä̖ä̖ḏân, heḏá iḏá dísan.” ");
INSERT INTO tew_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jesus-ví híˀ ûnmuuḏi óepankéyíˀin didaˀ, hewänbo óekéyí ihayḏi waˀ wíˀûnnáhpíḏí toˀwíḏí wänbo wíˀóeyâ̖ˀpí. ");
INSERT INTO tew_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hewänbo báyékí tꞌowa iwe diyiˀin ivíˀpiyeˀ dívíwhä̖yu̖. Kin ditû̖ˀ: “I-ânkun i namuu Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. Wíyá toˀwí-á háˀto naˀä̖́ä̖-í shánkí báyékí pínnán ikeeya̖míḏí nä́ˀi senbíˀweḏi.” ");
INSERT INTO tew_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","In Pharisees ditꞌoe in tꞌowa nä́ˀi hä̖ä̖wí Jesus-ví̖ˀgeḏi dívíkaahíˀmáaḏí, heḏiho indáḏí heḏá in owhaˀ pꞌóˀḏéḏíˀindáḏí wên sundaḏo i méesate hayˀi dâyˀá̖yí̖ˀdoˀin ovâysan óepankéyíḏí. ");
INSERT INTO tew_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus-di in tꞌowa ovâytu̖ˀan, “Hây tä̖hkíḏa̖ˀ undáḏí dáywóyí̖ˀní, heḏáháˀ owáymän i dísandivíˀwepiyeˀ. ");
INSERT INTO tew_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Heḏáháˀ undá dínuwä̖́-í, hewänbo háˀto díshaa-í. Wáy naa omän diwepiyeˀ wíˀúnpu̖hkoeḏí-ípí.” ");
INSERT INTO tew_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","In Huḏíyo tsonnin dívítu̖ˀan, “Wáypiyan nä́ˀi sen namän? Natû̖ˀ háˀto âysháa-í gin. Ti namän gáhân wáy in Huḏíyo diwaḏekwꞌó̖ˀ deeyepiyeˀ, in Huḏíyo dimuupíˀin tꞌowaví yâa natháa-íḏí, hä̖ˀin Huḏíyo dimuupíˀin ovâyhá̖ˀa̖míḏí? ");
INSERT INTO tew_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Iḏi dítu̖ˀan, ‘Undi dínuwä̖́-í hewänbo háˀto díshaa-í. Wáy ochangítꞌóe iwepiyeˀ wíˀúnpu̖hkoeḏí-ípí.’ Hânnangú iví híˀ ûntu̖ˀdaˀ?” ");
INSERT INTO tew_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","I tꞌä̖ˀgi shánkîˀḏi thaa-á shánkí hayˀi thaa namuu, heḏi Jesus iwe nawindi kaygi ovâytu̖ˀan, “Toˀwí napꞌoesáˀaaḏi navíˀpiyeˀ naˀä̖́ä̖-í isu̖wä̖́-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yôesi Táḏáví ta̖ˀnin diwe kinnân nata̖ˀmuu: Toˀwên navíˀpiyeˀ dívíwhä̖yundeˀinbí píˀnä́ khóˀyé wí pꞌoˀkꞌay waagibá dâymáa, heḏi i pꞌoe-á nawówátsipä̖yiˀi namuu.” ");
INSERT INTO tew_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I pꞌoe i̖ˀgeḏi ihéeˀandi-á i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-ân namuu, heḏi toˀwên ivíˀpiyeˀ dívíwhä̖yundeˀin i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dâykéyí. Hewänbo nä́ˀi Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-á waˀḏi wíˀovâymä́gipí, Jesus waˀḏi makówápiyeˀ wínapeepíḏí. ");
INSERT INTO tew_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","In tꞌowa nä́ˀin ovaytu̖máaˀin ditꞌoe ihayḏi wáy wên ditú̖, “Taˀgendi nä́ˀi-á Yôesi Táḏáví tukhe̖ˀbiˀ âytsíkhaˀmáaˀi namuu.” ");
INSERT INTO tew_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hewänbo wây-á ditú̖, “I-á namuu i toˀwí Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí.” Heḏá wáˀ wây-á ditú̖, “Hewänbo i toˀwí Yôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí Galilee-wi wínamúnípí. ");
INSERT INTO tew_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ti Yôesi Táḏáví ta̖ˀnin diwe wínatú̖hpíˀan, i toˀwí iḏi óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí David-ví ây iweḏiˀibá namúní, heḏá oe Bethlehem-dá naˀaypu̖yä̖gítꞌóe, i búuˀúˀay David naˀaypu̖yä̖ iwebá.” ");
INSERT INTO tew_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Heḏiho in tꞌowa Jesus-ví̖ˀgeḏi handa̖ˀ wídívíˀánshaamáapíḏí wêegeˀin dipóe. ");
INSERT INTO tew_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wáy wêndi óepankéyíˀin didaˀ, hewänbo toˀwíḏí wänbo wíˀóeyâ̖ˀpí. ");
INSERT INTO tew_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","In méesateˀin sundaḏo diwáymää in owhaˀ pꞌóˀḏéḏíˀindá heḏá in Pharisees-á dikwꞌó̖ˀ diwepiyeˀ, heḏi in sundaḏo ovâytsikáyin, “Heḏi háaḏan i sen wívînmaapí?” ");
INSERT INTO tew_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Indi in Pharisees ovâytu̖ˀan, “Hä̂nhay wänbo wí toˀwí wíˀihéeˀanpí hä̖ˀi sen ihéeˀo waagibá.” ");
INSERT INTO tew_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","In Pharisees-di ovâytsikáyin, “Ti un wáˀ in taˀgen namuu iweḏi iḏi wovâyyâaˀan? ");
INSERT INTO tew_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ti wíˀúnhanginnáhpíˀan wîˀ wänbo naˀin tsonnindá heḏá naˀin Pharisees-á ivíˀpiyeˀ wíˀívíwhä̖yundepíˀin? ");
INSERT INTO tew_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yôesi Táḏáḏí nä́ˀin tꞌowa ivíˀpiyeˀ dívíwhä̖yundeˀin ovâytuchä̖nukhâymáa, indá i tsontu̖u̖ Moses itaˀnandi wíḏâytaapí.” ");
INSERT INTO tew_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wí sen in diweḏi Nicodemus gin nakhá̖wä̖́ˀiḏi ovâyhéeˀan, i-á hä̂nhaybo Jesus-víˀpiyeˀ namääˀiˀ namuu. ");
INSERT INTO tew_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Kinnân ovâytu̖ˀan: “Wígínkoeḏipí gitú̖níḏí háa wí toˀwí híwó̖ˀ háa híwó̖ˀpí iˀannin páaḏé iví tu̖u̖ gitꞌoepíḏíboˀ, heḏá háawên iˀannindá gínhanginpóepíḏíboˀ. Naˀinbí tsontu̖u̖ ki̖ˀmin gínmuupíˀan.” ");
INSERT INTO tew_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Indi óetu̖ˀan, “Háaḏan igîˀ bikhä̖ge̖ˀhéeˀoˀ? Ti u̖ wáˀ Galilee iweˀibá unmuu gáhân? Á̖yîngiḏi Yôesi Táḏáví ta̖ˀnin mântu̖u̖ˀa̖mí, heḏân ú̖hanginpúwí wîˀ wänbo wí Yôesi Táḏáví tukhe̖ˀbiˀ Galilee-wi wínamuupíˀin.” ");
INSERT INTO tew_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tꞌä̖hkíḏíbo inbíˀpiyeˀ dívíweehoˀ. ");
INSERT INTO tew_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hewänbo Jesus-á oe Olive Okú gin dâytu̖ˀoˀ iwepiyeˀ namää. ");
INSERT INTO tew_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wíyá tháwä́n héˀḏiboˀ iˀ méesate hayˀi eepiyeˀ nawáymää. Báyékí tꞌowa ûnpówáḏí indáḏí isóge heḏi ovâyhá̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Heḏi in Huḏíyoví khuu dâyhá̖ˀoˀindáḏí in Pharisees-áḏí wí kwee Jesus naˀä́n diwepiyeˀ óehoˀ. Nä́ˀi kwee-á wíyá kweeví sendáḏí däntꞌaywó̖ˀdoḏi óekêˀ. In tꞌowaví páaḏépiyeˀ óekwi̖nuˀan, ");
INSERT INTO tew_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","heḏi indi Jesus óetu̖ˀan, “Há̖hkandiˀ, nä́ˀi kwee-á wíyá kweeví sendáḏí däntꞌaywó̖ˀdoḏiboˀ óekêˀ. ");
INSERT INTO tew_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","I tsontu̖u̖ Moses ita̖ˀnan diwe kinnân díyôn: Wí kwee kin iˀoˀiˀ âykꞌusä̖yu̖héyíˀin gínkhâyˀä̖ˀ. Heyâa u̖, hân ú̖chanpoˀ?” ");
INSERT INTO tew_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nä́ˀin Jesus óetu̖ˀan óetayi̖ˀníḏí wên háawên híwó̖ˀpíˀin natu̖hpée-íḏí heḏânho ôntꞌaywó̖ˀdichä̖nú-íḏí. Jesus itꞌä̖́ä̖ḏí oe nange iví mankhú̖ḏí hä̖ä̖wí ita̖ˀnan. ");
INSERT INTO tew_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hewänbo ihayḏa̖ˀ óetsikáyíndeˀ, heḏihoˀ idaygiˀandi ovâytu̖ˀan, “Wénä wí unbíˀweḏi wíˀitꞌaywó̖ˀnanpîˀḏi, iḏân i kwee páaḏé óekꞌusä̖yú̖-í.” ");
INSERT INTO tew_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","9","Heḏi wíyá itꞌä̖́ä̖ḏí oe nange iwáyta̖ˀnan. In senäˀ i kwee óetsꞌúḏeˀin nä́ˀin ditꞌoeḏi wí̖ˀíngin tꞌä̖hkí iweḏi dipee, in shánkí saydôe páaḏé, heḏi Jesus-áḏí i kwee-áḏí wíˀbo iwe dawindi ovä̂nyoeˀan. ");
INSERT INTO tew_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus wíyá idaygiˀandi i kwee óetsikáyin, “Wáyho in ton? Ti wîˀ wänbo wínatú̖hpíˀan wóetuchä̖nú-íˀin ú̖khâyˀä̖ˀ?” ");
INSERT INTO tew_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","I kweeḏi óetu̖ˀan, “Mä́ˀmä̂ä, toˀwí wänbo háabo wínatú̖hpí.” Jesus-di óetu̖ˀan, “Naa wänbo-á yoe. Heḏiho ópûn, nää iweḏi páaḏépiyeˀ wíyá wívitꞌaywó̖ˀnamípí.” ");
INSERT INTO tew_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus wíyá ihéeˀandi in tꞌowa ovâytu̖ˀan, “Naa wí kohthay waagiˀbá omuu tꞌowa tꞌä̖hkígîˀ. Toˀwí naa-áḏí nayiˀi háˀto khu̖u̖ i̖ˀge nayê̖e̖ní, hewänbo i kohthay nawówátsipä̖yiˀiˀ imáˀve-í.” ");
INSERT INTO tew_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","In Pharisees-di óetu̖ˀan, “U̖-á wíˀbo uví̖ˀgeḏi bipihíˀmáa, heḏânho háa untû̖ˀnin toˀwí wänbo wíˀûnkhâyˀä̖hpí iwhä̖yú̖-íˀin.” ");
INSERT INTO tew_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus-di ovâytu̖ˀan, “Tobá wíˀbo naví̖ˀgeḏi wâytu̖ˀan wänboˀ, háa naaḏi wâytu̖ˀan waa taˀgen namuu, gá naa dînhanginnândân wä̖́hä̖̂ä̖ḏi oˀä̖ä̖ˀin heḏá wä̖́hä̖̂ä̖piyeˀ omännindá. Hewänbo undá wä̖́hä̖̂ä̖ḏi oˀä̖ä̖ˀin háa wä̖́hä̖̂ä̖piyeˀ omännin wíˀúnhanginnáhpí. ");
INSERT INTO tew_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Undi tꞌowa bînwänpimúndeḏibo bîntꞌaywó̖ˀdichä̖nundeˀ. Naaḏá toˀwí wänbo wíḏônchä̖nundepí. ");
INSERT INTO tew_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Hewänbo wí toˀwí dônchä̖nuḏáhoˀ, híwó̖ˀ dáyˀa̖mí, gá wíˀbo wíḏáyˀopíḏân, hewänbo i dísandi-áḏí naa-áḏí handa̖ˀ gatû̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Unbí tsontu̖u̖ ta̖ˀnin diwe wänbo kinnân nata̖ˀmuu: Wí toˀwí óetsondiwekán dihayḏi wên wíyeḏi handa̖ˀ iví̖ˀgeḏi datû̖ˀdáhoˀ, únkhâyˀä̖ˀ úvíwhä̖yú̖-íˀin háa datú̖ waa taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naa i wîˀ omuu naví̖ˀgeḏi dáypihéeˀoˀiˀ, heḏá naví Táḏá dísandiˀ wáˀ naví̖ˀgeḏi ihéeˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Indi óetsikáyin, “Wáyhoˀ uví táḏá?” Jesus-di ovâytu̖ˀan, “Undiḏá naa wíḏítaapí, naví Táḏá wänbo-á wíḏîntaapí. Naa dítaaḏáhoˀ, naví Táḏá wáˀ dîntáa-íwän.” ");
INSERT INTO tew_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tꞌä̖hkí nä́ˀin Jesus natú̖ i méesate hayˀi ee ovâyhá̖ˀo ihayḏi, i chä̖ˀ nateˀkwꞌó̖ˀdi íve núˀ nanáˀ diwe. Heḏi toˀwíḏí wänbo wíˀóepankêˀpí, ihayḏi waˀḏi wíˀûnpóepíḏí óekéyíḏí. ");
INSERT INTO tew_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus wíyá ovâyhéeˀandi ovâytu̖ˀan, “Naa nä́weḏi omän, heḏi undi dítu̖wä̖khâymáa, hewänbo unbí tꞌaywó̖ˀdi waˀḏi bînmáaḏíboˀ íchuwagítꞌóe. Wáy omän diwepiyeˀbá wíˀúnkoeḏí-ípí ímu-íˀin.” ");
INSERT INTO tew_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Heḏiho in Huḏíyoví pꞌóˀḏéḏíˀin dívítu̖ˀan, “I natú̖ wáy i namän deepiyeˀbá wígínkoeḏí-ípí gimú-íˀin. Háaḏan kin natú̖? Ti wíˀbo ikheˀkhâymáa gáhân?” ");
INSERT INTO tew_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iḏi ovâytu̖ˀan, “Undá nä́ä áagéwin ímuu, naa-á oe kwꞌáyewi-á. Undá nä́ä oepáa kꞌayḏiwinda̖ˀ ímuu, naa-á yoe. ");
INSERT INTO tew_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Heḏânkun naaḏi wâytu̖ˀan, unbí tꞌaywó̖ˀdi bînmáaḏíboˀ íchuwagítꞌóe, heḏi toˀwí naa omuuˀin úvíwhä̖yundepíḏáho taˀgendi unbí tꞌaywó̖ˀdi bînmáaḏíboˀ íchuwagítꞌóeˀin únpúwí. ");
INSERT INTO tew_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Heḏi óetsikáyin, “To-an unmuu?” Jesus-di ovâytu̖ˀan, “Naaḏi páaḏéḏíbo wâytu̖máa toˀwí omuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wíyá báyékí hä̖ä̖wí unbí̖ˀgeḏi otú̖níˀi naa dómáa, heḏá báyékí híwó̖ˀpîˀ úvíˀandi namuuḏi naa dînkoeḏi wâytꞌeˀpꞌíḏe-íḏí. Hewänbo háa i dísandivíˀweḏi otꞌoeˀinda̖ˀ tꞌä̖hkí tꞌowa dovâytu̖ˀoˀ, heḏi i-á in taˀgenda̖ˀ ihéeˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hewänbo nä́ˀin Húḏíyoví pꞌóˀḏéḏíˀin wíḏikaˀpówápí i óesandi-á Yôesi Táḏá namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Heḏiho Jesus-di ovâytu̖ˀan, “Owáy naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ undi dítꞌóhtä̖getege ihayḏáhoˀ únhanginnání toˀwí naa omuuˀin, heḏá únhanginpúwí naa wíˀbo háawên wíḏáyˀopíˀin, hewänbo háa naví Táḏáḏí díhá̖ˀandiḏa̖ˀ dáyhéeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","I dísandiˀ naa-áḏí nayiˀ. Wíˀbo wíḏíyoeˀanpí, gá naa-á hä̖̂ä̖ḏi wänbo tꞌä̖hkí i óehíhchandoˀiḏa̖ˀ dáyˀoḏân.” ");
INSERT INTO tew_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Heḏi kin ovâyhíˀmáa ihayḏi báyékí tꞌowa ivíˀpiyeˀ dívíwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","Jesus-di nä́ˀin Huḏíyo ivíˀpiyeˀ dívítsꞌanwhä̖yu̖ˀin ovâytu̖ˀan, “Naví híˀ hä̖̂ä̖ḏi waa dînˀaˀginhondáhoˀ, taˀgendi navíˀweḏi íhá̖hpúwíˀin ímuu, heḏá únhanginnání hä̖ä̖wí in taˀgen namuuˀin, heḏi pan waagiˀinbá wíyá wíˀímúnípí.” ");
INSERT INTO tew_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Heḏi óetu̖ˀan, “Naˀindá Abraham-bí ây iweḏiˀinnân gimuu. Naˀindá hä̂nhay wänbo toˀwênbí pan wígimuupí. Heḏi háaḏan untú̖ pan waagiˀinbá wíyá wígimúnípí gin?” ");
INSERT INTO tew_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus-di ovâytu̖ˀan, “Taˀgendi wâytu̖máa, toˀwên tꞌä̖hkí dívítꞌaywó̖ˀkanhonnindá, tꞌaywó̖ˀdiḏi ovâymáaḏí pantꞌôeˀin waagiˀin dimuu. ");
INSERT INTO tew_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wí toˀwí pantꞌôeˀi namuuˀi-á iví tsondiví kꞌaygi iwe hä̖̂ä̖ḏi wänbo tꞌä̖hkí wínacha̖ˀnípí, hewänbo i tsondiví ay ûnmuuˀi-áho hä̂nhay wänbo tꞌä̖hkí kꞌaygiwi-ân namuu. ");
INSERT INTO tew_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Heḏi naa Yôesi Táḏáví ay omuuˀiḏi unbí tꞌaywó̖ˀdi iweḏi wâywhimaˀpꞌä̖́ḏiḏáhoˀ, ihayḏibâa taˀgendi íwhimaˀpꞌä̖́ní. ");
INSERT INTO tew_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Naa dînhanginná un Abraham-bí ây iweḏiˀin ímuuˀin, hewänbo undá ídaˀ díhéyíˀin, gá naví híˀ unbí píˀnä́ khóˀyé wívînmáapíḏân. ");
INSERT INTO tew_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Háa naví Táḏáḏí dînkeeyannin naaḏi wâytu̖ˀan, hewänbo undá háa unbí táḏávíˀweḏi ítꞌoe waagibá úvíkanhon” kin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Heḏiho indi óetu̖ˀan, “Abraham-dá naˀinbí hä́nˀoeˀiˀ táḏá gínmuu.” Jesus-dá ovâytu̖ˀan, “Abraham-bí ây taˀgendi ímuuḏáhoˀ, háa Abraham iˀan waabá úvíˀâ̖a̖míwän. ");
INSERT INTO tew_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hewänbo nää undiḏá díhéyíˀin ídaˀ, tobáháa in taˀgen naví Táḏávíˀweḏi otꞌoeˀinda̖ˀ wâytu̖ˀan wänboˀ. Abraham-dá haˀwâa wíˀiˀanpí. ");
INSERT INTO tew_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Undá háa unbí táḏá iˀo waabá úvíˀoˀ.” Heḏi óetu̖ˀan, “Táḏápíˀin ây wígimuupí. Wîˀḏa̖ˀ wí táḏá gínˀä́n, i-á Yôesi Táḏá namuu.” ");
INSERT INTO tew_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus-di ovâytu̖ˀan, “Yôesi Táḏá taˀgendi unbí táḏá únmuuḏáhoˀ, naa díséegí-íwän, gá ivíˀweḏi oˀä̖ä̖ḏân, heḏânho nää-á nä́we oyiˀ. Naa opichanpóeḏíbo wóˀä̖ä̖pí, iḏân naa dísan. ");
INSERT INTO tew_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Háaḏan wíˀíkaˀpóya̖ˀpí háa wâytu̖máaˀin? Gá naví híˀ wíˀítꞌóyandaˀpíḏân. ");
INSERT INTO tew_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Penísendi-ân unbí táḏá únmuu, heḏi undá íkandaˀ háa unbí táḏá nadaˀ waa. Páaḏéḏí waabo nää iwehay Penísendi-á tꞌowa tꞌa̖kha̖nuˀi namuu, heḏá in taˀgen namuuˀin iví píˀnä́ wíˀihonpíḏí iweḏi ihângeˀoˀ. Hä̖̂ä̖ḏi wên hôeyó natú̖ ihayḏá háawi namuuˀin ipikeeyoˀ, gá wí hôeyóˀi namuuḏân, heḏá in dihôeyóˀinbí táḏá-á dínmuu. ");
INSERT INTO tew_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hewänbo naaḏá in taˀgen wâytu̖ˀoˀ, heḏânho wíḏînwhä̖yundepí. ");
INSERT INTO tew_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wénä wí-an un taˀgendi ítú̖ní naa dáytꞌaywó̖ˀnannin? Tóebo yoe. Hewänbo naaḏi in taˀgenda̖ˀ wâytu̖máa, heḏiho háaḏan wíḏînwhä̖yundepí? ");
INSERT INTO tew_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wí toˀwí Yôesi Táḏávîˀ ûnmuuˀiḏá iví híˀ ôntꞌóyandeˀ. Hewänbo undá Yôesi Táḏávíˀin ímuupíḏânkun wívîntꞌóyandepí” kin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","In Huḏíyoví pꞌóˀḏeḏíˀindi óetu̖ˀan, “In taˀgen gitú̖hpíˀan, u̖-á Samaria-wi waagiˀbá unmuu, naˀinbí khuu wínâaˀaˀginpíḏí, heḏá wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi wóemáa.” ");
INSERT INTO tew_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus-di ovâytu̖ˀan, “Naa wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi wíḏímáapí. Naa naví Táḏáví̖ˀgeḏi híwó̖ˀda̖ˀ dáyhéeˀoˀ, hewänbo undá naví̖ˀgeḏi híwó̖ˀpí úvíhíˀmáa. ");
INSERT INTO tew_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wíˀbo wóˀdaˀpí otú̖níˀin naa hayˀi omuuˀin. Yôesi Táḏá-ânho namuu i nadaˀi kin natú̖níˀin, i-áho natû̖ˀ háa undá in taˀgen bînmáaˀin heḏiháa naa-á. ");
INSERT INTO tew_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Naaḏi taˀgendi wâytu̖máa, wí toˀwí naví híˀ dînˀaˀgindoˀi-á chuwa iwe háˀto napówá-í.” ");
INSERT INTO tew_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","In Huḏíyoví pꞌóˀḏéḏíˀindi óetu̖ˀan, “Näbáhaˀ gínhanginná wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi wóemáaˀin. Abraham nachuu, heḏá tꞌä̖hkí in Yôesi Táḏáví hä́nˀoeˀin tukhe̖ˀmindá wáˀ ditꞌa̖hán. Hebo u̖-á untû̖ˀ wí toˀwí uví híˀ iˀaˀgindoˀi háˀto hä̂nhay wänbo chuwa iwe napówá-í. ");
INSERT INTO tew_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ti naˀinbí hehä̖̂ä̖wi thehtáy pahpâa Abraham-bí shánkí hayˀi unmuu gáhân? I-á heḏá Yôesi Táḏáví tukhe̖ˀmindá ditꞌa̖hán. To-an u̖ˀ unmuu gân unˀándeˀ?” ");
INSERT INTO tew_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus-di ovâytu̖ˀan, “Naa wíˀbo hayˀi dáypipaaḏáhoˀ háagîˀ wänbo wínachä̖ˀmuupí. Hewänbo naví Táḏáḏân naa hayˀi dípaa, heḏi ítû̖ˀ i-ân unbí Yôesi únmuu. ");
INSERT INTO tew_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Undiḏá hä̂nhay wänbo wívîntaapí, hewänbo naaḏá i dótaa. Wíḏótaapí gin otú̖ḏáho naa wí hôeyóˀiˀ omúní, un waagibá. Hewänbo naaḏá taˀgendi dótaa, heḏi iví híˀ dônˀaˀgindoˀ. ");
INSERT INTO tew_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Unbí thehtáy pahpâa Abraham nahíhcha̖a̖ gá i thaa oˀä̖ä̖ˀiˀ ipu̖wä̖khâymáaḏân, heḏi imûˀ ihayḏiho nahíhchanpóe.” ");
INSERT INTO tew_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","In Huḏíyoví pꞌóˀḏéḏíˀindi óetu̖ˀan, “Pꞌá̖nä́ntä̖ pa̖a̖yoˀi wänbo waˀḏi wú̖ˀmuupí. Hândiḏan Abraham nâamûˀ?” ");
INSERT INTO tew_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus-di ovâytu̖ˀan, “Taˀgendi wâytu̖máa, waˀ Abraham naˀaypu̖yä̖píḏíbo naa oyihoˀ.” ");
INSERT INTO tew_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Heḏiho dâykꞌuuwóehógi óekꞌusä̖yu̖héyíḏí, hewänbo i meesate íveḏi kaaḏibo napee. ");
INSERT INTO tew_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus oe pꞌóegé wáy namändi wí sen óemûˀ, i-á tsíˀtꞌaaˀibo naˀaypu̖yä̖. ");
INSERT INTO tew_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesus-ví khä̖ge̖ˀnindi óetsikáyin, “Há̖hkandiˀ, ti nä́ˀi sen wên tꞌaywó̖ˀnin iˀandân, háa iví táḏáˀin däntꞌaywó̖ˀnandi tsíˀtꞌaaˀi naˀaypu̖yä̖?” ");
INSERT INTO tew_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus-di ovâytu̖ˀan, “Wên tꞌaywó̖ˀnin iˀannin namuuḏi kin wíˀûnpóepí, háa iví táḏáˀin däntꞌaywó̖ˀnandi wänbo-á yoe. Nä́ˀindá ûnpóe heḏânho Yôesi Táḏáḏí wên háawên ônˀa̖míḏí, heḏi kindiḏi nakeepúwíḏí Yôesi Táḏá-á nakayˀin. ");
INSERT INTO tew_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Thaaḏi tꞌowa dívítꞌôeˀa̖mígîˀ naná, khu̖ˀḏéeḏá yoe. Heḏi hanbá nää-ân naná i naa dísandiví tꞌôe ívíˀa̖míḏí waˀḏi gínkoeḏiḏiboˀ, gá owáy wí thaa nanáˀ diwe naˀin wíyá háˀto gínkoeḏí-í ívítꞌôeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Waˀ nä́ä oepáa kꞌayḏi oyiḏibo naa wí kohthay tꞌä̖hkí tꞌowagîˀ waagiˀbá omuu.” ");
INSERT INTO tew_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kin natú̖ ihayḏi ee nange isópꞌohén, heḏi iví sóˀpꞌoeḏi wí napꞌoˀay ipaaḏi i sen natsíˀtꞌaamuuˀi tsée eeḏi óeˀä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Heḏáháˀ óetu̖ˀan, “Yaˀ ópûn oe pꞌobúˀay iwepiyeˀ, Siloam kin dâytu̖ˀoˀiˀ, heḏi uví tsée mänˀowíḏi-í.’ (Nä́ˀin khá̖wä̖́ Siloam-dá natu̖ˀdaˀ “óesandiˀ” gin.) Heḏiho i sen namääḏi iˀoewä̖́ä̖, heḏi iwáybun dihayḏihoˀ iví keetan imáa. ");
INSERT INTO tew_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","In toˀwên i senbí tsoˀwa dithaaˀin heḏá in toˀwên ihä̖ä̖daˀsógéndeḏi óemûˀin dívítsikaˀmáa, “Ti nä́ˀi i to sen ihä̖ä̖daˀsógéndeˀi wínamuupíˀan?” ");
INSERT INTO tew_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wên ditú̖, “I-ânkun namuu.” Wây-á wêndá ditú̖, “Yoe” gin, “i waagibá ûnwänpicha̖a̖.” Hewänbo i sendá natú̖, “Naa-ânkun i omuu.” ");
INSERT INTO tew_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Heḏiho óetsikáyin, “Hândiḏan handi uví keetan mänkêˀ?” ");
INSERT INTO tew_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Iḏi ovâytu̖ˀan, “Wí sen Jesus gin nakhá̖wä̖́ˀi wí napꞌoˀay ipaa, heḏi naví tsée eeḏi díˀä̖yu̖, heḏi dítu̖ˀan oe pꞌobúˀay Siloam gin dâytu̖ˀoˀ iwe dáyˀowíḏi-í. Heḏihoˀ omääḏi dáyˀoewä̖́ä̖, heḏi naví keetan donkêˀ.” ");
INSERT INTO tew_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Óetsikáyin, “Wáyho iˀ?” “Gáwáy” gin ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","I thaa Jesus i napꞌo ipaaḏi i sen natsíˀtꞌaamúˀdeˀiví keetan óemä́gi ihayḏá Huḏíyoví kaykhanwówá thaa naná. Heḏiho toˀwêndi in Pharisees-víˀpiyeˀ i sen óehoˀ indi óehéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","In Pharisees-di wáˀ óetsikáyin háḏíḏan iví keetan ikêˀin. Iḏá ovâytu̖ˀan, “Wí sendi nä́ä tsée eeḏi dínapꞌoˀä̖yu̖, heḏá dáyˀoewä̖́ä̖, heḏi nää dînkeepóe.” ");
INSERT INTO tew_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wáy wên in Pharisees ditú̖, “I sen kin iˀandi-á Yôesi Táḏáḏí wíˀônkꞌûˀpí, gá nä́ˀi kaykhanwówá thaa wíˀiˀaˀginpíḏân.” Hewänbo wây-á wêndá ditú̖, “Wí toˀwí tꞌaywó̖ˀtoˀi namuuˀi ki̖ˀbi pínnán háˀto ikeeya̖mí.” Heḏiho wêegeˀin dipóe. ");
INSERT INTO tew_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Heḏi wíyá in Pharisees-di i sen natsíˀtꞌaamúˀdeˀiˀ óetsikáyin, “Heyâa u̖, hân iví̖ˀgeḏi ú̖chanpoˀ? U̖-ân unmuu uví keetan mänkêˀiˀ.” I sendi ovâytu̖ˀan, “I-á Yôesi Táḏáví tukhe̖ˀbi namuu.” ");
INSERT INTO tew_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hewänbo in Huḏíyoví pꞌóˀḏéḏíˀin wíḏívíwhä̖yu̖pí nä́ˀi sen taˀgendi natsíˀtꞌaamuuwän hebo nää ûnkeepóe, heḏihoˀ iví táḏáˀin ovä̂ntu̖kánnan iví̖ˀgeḏi ovä̂ntsikáyi̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Heḏi ovä̂ntsikáyin, “Ti unbí ay nä́ˀi dä́nmuu? Ti tsíˀtꞌaaˀi naˀaypu̖yä̖ˀin datú̖ní? Háḏídan handi nää ûnkeená?” ");
INSERT INTO tew_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","I senbí táḏáˀindi ovâytu̖ˀan, “Gä́nhanginnândákun naˀinbí ay gä́nmuuˀin heḏá tsíˀtꞌaaˀi naˀaypu̖yä̖ˀindá. ");
INSERT INTO tew_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Hewänbo háaḏí nää ûnkeenáˀnin wígä́nhanginnáhpí, heḏá wáˀ wígä́nhanginnáhpí toˀwíḏí óekeetanmä́giˀin. Bintsikáyi̖ˀbe iˀ. Senho namuu. Igîˀ wíˀbo ipihéeˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","I senbí táḏáˀin in Huḏíyoví pꞌóˀḏéḏíˀin dä̂nkhuwôedaˀmáa, gá dâywéhpêeˀandân i méesate ee ovâytsuḏekhâ̖a̖ˀa̖míḏí toˀwên ditû̖ˀnin Jesus-á namuu i toˀwí Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Handiḏânkunho datú̖, “Senho namuu, heḏiho bintsikáyi̖ˀbe iˀ.” ");
INSERT INTO tew_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Heḏiho wáygíngîˀ i sen natsíˀtꞌaamúˀdeˀiˀ óetsꞌúḏeḏi óetu̖ˀan, “Yôesi Táḏáví páaḏépiyeˀ uví tu̖u̖ bimä̂äní in taˀgen untú̖níḏí. Gínhanginná nä́ˀi sen iví̖ˀgeḏi bihéeˀandi-ân tꞌaywó̖ˀtoˀi namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Iḏi ovâytu̖ˀan, “Naa wíḏînhanginnáhpí háa tꞌaywó̖ˀtoˀi namuuˀin háa yoe, hewänbo nä́ˀin taˀgendi dînhanginná: Tobáháa hä́ndíḏí otsíˀtꞌaamúˀde wänboˀ, nää-á dînkeená.” ");
INSERT INTO tew_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Heḏiho óetsikáyin, “Hânnan wóeˀan? Hândiḏan wóekeetanmä́gi?” ");
INSERT INTO tew_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Heḏi ovâytu̖ˀan, “Wâytu̖ˀanhoˀ, hewänbo wíˀúvítꞌóyanpí. Háaḏan wíyá ítꞌoe-íˀin ídaˀ? Ti ídaˀ gáhân un wáˀ iḏi wovâyhá̖ˀa̖míˀin heḏânho ivíˀpiyeˀ úvíwhä̖yú̖-íḏí?” ");
INSERT INTO tew_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Indi i sen hä̖ä̖wí nachä̖ˀmuupí waagi óehéeˀandi óetu̖ˀan, “U̖-ân hä̖ˀi sendi wóehá̖ˀoˀiˀ unmuu. Naˀindá Moses-ví híˀḏí díhá̖ˀanninnân gimuu. ");
INSERT INTO tew_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yôesi Táḏáḏí Moses óehéeˀannin gínhanginná. Hewänbo hä̖ˀi sendá, wígínhanginnáhpí toˀwíḏí óesannin.” ");
INSERT INTO tew_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","I sendi ovâytu̖ˀan, “Whä̖yu̖píwó̖ˀnin namuu. Tobáháa naví keetan iḏi dímä́gi wänboˀ un wíˀúnhanginnáhpí toˀwíḏí óesannin. ");
INSERT INTO tew_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Gínhanginná Yôesi Táḏáḏí in tꞌaywó̖ˀtoˀin wíˀovâykhä̖ge̖ˀdopíˀin híwó̖ˀ dívíˀa̖míḏí, hewänbo in toˀwên óeˀaˀgindoˀindá heḏá toˀwên háa natú̖ waa dívíˀoˀindá, innânho iḏi ovâykhä̖ge̖ˀdoˀ. ");
INSERT INTO tew_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","I nan oepáa nakhíˀyen dihayḏi waagibo nää puˀwahayḏi toˀwí wänbo wíˀûnkoeḏipí wí tsíˀtꞌaaˀi naˀaypu̖yä̖ˀiví keetan óemä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hä̖ˀi sen Yôesi Táḏáḏí óesanpíḏáho háˀto ûnkoeḏí-í háawên wänbo iˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Indi óetu̖ˀan, “U̖-á tꞌaywó̖ˀtoˀiḏa̖ˀ unˀaypu̖yä̖. Ti unˀánde gáhân u̖ ú̖koeḏiˀin naˀin díhá̖ˀa̖míḏí?” Heḏi iwáygéḏí óekhe̖hpiyeḏi óekhâ̖a̖ˀan i méesate ee wíyá natsꞌú̖níḏí. ");
INSERT INTO tew_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus ûnhanginpóe i sen óekhe̖hpiyeˀin, heḏi óenuwä̖ḏi óeshaa, heḏi óetsikáyin, “Ti i toˀwí tꞌä̖hkí tꞌowagîˀ naˀaypu̖yä̖ˀivíˀpiyeˀ biwhä̖yundeˀ?” ");
INSERT INTO tew_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","I sendi Jesus óetsikáyin, “Mä́ˀmä̂ä, to-an nä́ˀi toˀwí namuu, tꞌä̖hkí tꞌowagîˀ naˀaypu̖yä̖ˀiˀ? Dítu̖ˀan toˀwí namuuˀin, heḏânho naa dînkoeḏí-í ivíˀpiyeˀ dáywhä̖yú̖-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus-di óetu̖ˀan, “U̖ḏi nâamûˀhoˀ. Naaḏi wíhíˀmáaˀi-ân i omuu.” ");
INSERT INTO tew_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","I sendi óetu̖ˀan, “Naˀinbí Sedó, naa uvíˀpiyeˀ dáywhä̖yundeˀ,” heḏi Jesus-ví páaḏépiyeˀ idéˀgendisóge. ");
INSERT INTO tew_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus natú̖, “Naa nä́ä oepáa kꞌayḏipiyeˀ oˀä̖ä̖ heḏânho nakeepúwíḏí toˀwên híwó̖ˀ dívíkanhonnin dimuuˀin heḏá toˀwên híwó̖ˀpí dívíkanhonnin dimuuˀindá. Naa oˀä̖ä̖ in toˀwên wíḏâymúndepíˀin dínhanginnáˀnin dínkeepúwíḏí, heḏá in toˀwên dínkeetꞌóe gin diˀándeˀindá ditsíˀtꞌaamuu waagibá dipúwí.” ");
INSERT INTO tew_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wên Pharisees iwe tsoˀwa diwinnindi óetsikáyin, “Ti unˀánde gáhân naˀin wáˀ gitsíˀtꞌaamuuˀin waagiˀinbá gimuu?” ");
INSERT INTO tew_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus-di ovâytu̖ˀan, “Ítsíˀtꞌaamuu gin únhanginnândáhoˀ, tꞌaywó̖ˀdi wívînmáˀve-ípí. Hewänbo nää ítû̖ˀ únkeetꞌóe gin, heḏiho waˀḏi unbí tꞌaywó̖ˀdi wíwovâyyâaˀanpí.” ");
INSERT INTO tew_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Naaḏi taˀgendi wâytu̖máa, wí toˀwí kwꞌáayéḏí oe kꞌúwá phéhkhaa búge natsꞌû̖ˀdi i phéhkhaa phóḏi i̖ˀgeḏi natsꞌú̖nívíˀweḏi, i-á wí sänbiḏa̖ˀ namuu. ");
INSERT INTO tew_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Hewänbo i toˀwí khaa phóḏi i̖ˀgeḏi natsꞌúya̖ˀdi-á i kꞌúwá á̖yí̖ˀdi namuu. ");
INSERT INTO tew_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","I toˀwí in khaa phóḏi iˀá̖yînmáaˀiḏi i kꞌúwá á̖yí̖ˀdigîˀ ônhuuḏeˀ, heḏi i kꞌúwá á̖yí̖ˀdiḏi in kꞌúwá ovâykhá̖yä̖́ˀdeḏi iví tu̖u̖ ditꞌoeḏi in khaa phóḏi i̖ˀgeḏá ovâypahpiyendeˀ. ");
INSERT INTO tew_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tꞌä̖hkí iví kꞌúwá i khaa búgeḏi ovâypiye ihayḏi inbí páaḏépiyeˀ namäˀ, heḏi indá iví tu̖u̖ ôntaaḏi ûnwóemäˀ. ");
INSERT INTO tew_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Indá wíyá toˀwí dâytaapîˀvîˀḏi háˀto diwóemu-í, hewänbo ivíˀweḏi dishání, gá wíyá piˀwíví tu̖u̖ wíˀôntaapíḏân.” ");
INSERT INTO tew_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kin Jesus-di kꞌúwáví̖ˀgeḏi in Pharisees ovâyhéeˀan hä̖ä̖wí ovâyhá̖ˀa̖míḏí, hewänbo wíḏikaˀpóya̖ˀpí háa natu̖ˀdaˀin. ");
INSERT INTO tew_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Heḏiho wíyá ovâyhéeˀandi kinnân ovâythayyan: “Taˀgendi wâytu̖máa, wên phéhkhaa phóḏi waagi omuu in kꞌúwágîˀ. ");
INSERT INTO tew_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Báyékí in naví páaḏé diˀä̖ä̖ˀin sänmin waagiˀinbá dimuu, hewänbo in tꞌowa naví kꞌúwá waagiˀinbá dimuuˀindi wíˀovâytꞌóyanpí. ");
INSERT INTO tew_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naa wên khaa phóḏi waagiˀinbá omuu, heḏá in navíˀpiyeˀ dívíwhä̖yundeˀin wên kꞌúwá in phéhkhaa búge ditsꞌú̖ˀnin waagiˀinbá-á dimuu. Heḏi kꞌúwá dipiˀ inbí koegîˀ dâysháa-íḏí heḏá wíyá ditsꞌúya̖ˀ waagibá, in navíˀpiyeˀ dívíwhä̖yundeˀin ovâyˀaywoení heḏá hä̖ä̖wí díntáyˀi-á dâymáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wí sänbiˀ-á naˀä̖ˀ in kꞌúwá ovâysänhóníḏí heḏá ovâytꞌa̖há̖nú-íḏá, heḏá ovâyháˀḏä̂nnamíḏá. Hewänbo naa-á oˀä̖ä̖ tꞌowa dovâywówátsimä̂äníḏí, heḏi nä́ˀin wówátsi dovâymäˀi-á shánkí híwó̖ˀnin namuu. ");
INSERT INTO tew_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Naa-á híwó̖ˀdi kꞌúwá á̖yí̖ˀdi waagiˀbá omuu. Wí híwó̖ˀdi kꞌúwá á̖yí̖ˀdi-á nakhâymuu iví wówátsi iví kꞌúwágíˀin imä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Wí toˀwí ikꞌúwáˀá̖yí̖ˀnamíḏí óewáˀándeˀi-á i koḏi̖ˀdi kꞌúwá á̖yí̖ˀdi wínamuupí, heḏi in kꞌúwá-á ivíˀindá wíˀûnmuupí. Heḏiho wí khu̖u̖yó naˀä̖ḏi imúndeḏi nashándeˀ, gá wáˀâaḏiḏa̖ˀ itꞌôeˀoḏân, heḏiho in kꞌúwáḏí taˀgendi wä̖hphaḏe wíˀóeˀá̖yîngimähpí. Heḏiho i khu̖u̖yó naˀä̖ä̖ḏi in kꞌúwá ovâykhugihónde heḏá ovâywaḏeyíyéndeˀ. ");
INSERT INTO tew_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Naa i híwó̖ˀdi kꞌúwá á̖yí̖ˀdi waagiˀbá omuu. Naví Táḏáḏí naa dítaa, heḏá naaḏá i-á dótaa, heḏi hanbá in navíˀin dînmuuˀin dontaa, heḏá indiḏá naa-á dítaa, heḏi in dimuuḏi naví wówátsi wänbo dáymä̂äní. ");
INSERT INTO tew_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wây-á tꞌowa nä́wewin dimuupíˀin diyiˀ, indá wáˀ naví kꞌúwá waagiˀinbá dimuu, heḏi naa dînkhâyˀä̖ˀ in wáˀ dovâywé̖ˀgeˀa̖míˀin. Indá naví tu̖u̖ dîntꞌóyaaní, heḏi in wé̖ˀgeˀindáḏí wîˀḏa̖ˀ dipúwí, heḏá wîˀḏa̖ˀ wí á̖yí̖ˀdi díncha̖ˀní. ");
INSERT INTO tew_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Naví wówátsi dáymä̂äní heḏá donwáykéyí. Handiḏânkun naví Táḏáḏí naa díséegí. ");
INSERT INTO tew_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Toˀwíḏí wänbo naví wówátsi wíḏíkwee-ípí. Naví wówátsi-á wíˀbo dáypä̖khâymáa. Naa dînkꞌóe naví wówátsi dáymä̂äníḏí heḏá donwáykéyíḏá, gá naví Táḏáḏí díyôndân kin dáyˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesus kin natú̖ ihayḏi in Huḏíyo inbí ánshaa iwe wêegeˀin dipóe. ");
INSERT INTO tew_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Báyékí kin ditú̖, “Wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáa heḏá bondoeˀi-á namuu. Heháaḏan bîntꞌóyandeˀ?” ");
INSERT INTO tew_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Hewänbo wây-á wêndá ditú̖, “Wí toˀwí wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáaˀi háˀto ihéeˀa̖mí nä́ˀi sen ihéeˀo waagi. Heḏá wáˀ ti wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ ûnkoeḏi wí natsíˀtꞌaamuuˀiví keetan óewáymä̂äníḏí? Heḏân yoe.” ");
INSERT INTO tew_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Teˀnúḏí nanáˀ dihayḏi oe Jerusalem búuˀú dínshánkîˀḏipóe, háa i méesate hayˀi hä́nˀoe dâywáytege waa dínˀánshaa-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus nä́ˀi méesate iwe nayiˀ, ee Solomon-bí pohtâa gin dâytu̖ˀoˀ i̖ˀge. ");
INSERT INTO tew_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","In Huḏíyoví pꞌóˀḏéḏíˀindi óebûukêˀḏi óetu̖ˀan, “Hä̖̂ä̖ḏi puˀwahay-an naˀin dítsíkhakankhâymáa dítu̖ˀâ̖a̖míḏí toˀwí unmuuˀin? I toˀwí Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí unmuuḏáhoˀ, nääbo thayˀeeḏi dítu̖ˀan.” ");
INSERT INTO tew_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus-di ovâytu̖ˀan, “Naaḏi wâytu̖ˀanhoˀ, hewänbo wíˀúvíwhä̖yundepí. Tꞌä̖hkí pínnán tꞌôe dókanhondi-á naa dáyˀoˀ gá naví Táḏáḏí dînkꞌûˀḏân, heḏiho háa naa dáyˀoˀindibo wovâykeeyoˀ toˀwí omuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Hewänbo naví kꞌúwá waagiˀinbá wíˀímuupíḏího wíˀúvíwhä̖yundepí. ");
INSERT INTO tew_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","In toˀwên naví kꞌúwá waagiˀinbá dimuuˀindi naví tu̖u̖ dîntꞌóyandeˀ, heḏi naaḏá in dovâytaa, heḏi naa díyu̖u̖máˀ, ");
INSERT INTO tew_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","heḏi wówátsi nahándepíˀin dovâymäˀ, heḏi háˀto hä̂nhay wänbo dihá̖a̖ní, heḏá háˀto-á toˀwíḏí wänbo naví mangeḏi ovâyhóní. ");
INSERT INTO tew_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Naví Táḏáḏí in dímä́gi, heḏi i-á tꞌä̖hkíví shánkí hayˀi-ân namuu, heḏi toˀwí wänbo wíˀûnkoeḏipí naví Táḏáví mangeḏi ovâyhóníḏí. ");
INSERT INTO tew_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Naa-áḏí naví Táḏá-áḏí wîˀḏa̖ˀ gamuu.” ");
INSERT INTO tew_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wíyá in Huḏíyoví pꞌóˀḏéḏíˀin dâykꞌuuwóehógi óekꞌusä̖yu̖héyíḏí. ");
INSERT INTO tew_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus-di ovâytu̖ˀan, “Báyékí híwó̖ˀdi hä̖ä̖wí bînmúnígîˀ naa dóˀan, naví Táḏáḏí dítu̖ˀan waagi. Heḏi wéˀin hä̖ä̖wên dáyˀannin namuuḏan nää naa díkꞌusä̖yu̖khâymáa?” ");
INSERT INTO tew_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","In Huḏíyoví pꞌóˀḏéḏíˀindi óetu̖ˀan, “Naˀindá wên háawên híwó̖ˀnin biˀannin namuuḏi wíwíkꞌusä̖yu̖khâymáapí, hewänbo aˀginhá̖hpíwó̖ˀdi Yôesiví̖ˀgeḏi bihíˀmáaḏânho wíkꞌusä̖yu̖khâymáa. U̖-á tꞌowaḏa̖ˀmân unmuu, hewänboänbo untú̖ Yôesi unmuu gin.” ");
INSERT INTO tew_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Jesus-di ovâytu̖ˀan, “In ta̖ˀnin ungîˀ wovâyta̖ˀnannin diwe natû̖ˀpíˀan, Yôesiḏi in tsonnin ovâytu̖ˀan i waagiˀinbá dimuu. Hä̖ˀin tꞌowa Yôesiḏi hä́nˀoe iví tu̖u̖ ovâymä́giˀin han ovâytu̖ˀan, heḏi iví híˀ hä̂nhay wänbo tꞌä̖hkí taˀgen ûnmuu, ");
INSERT INTO tew_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","heḏi háaḏan handi nää ítû̖ˀ naaḏi Yôesi Táḏá dóˀaˀginhá̖núndeˀin iví ay omuuˀin otú̖ḏí? Naa-ânkun naví Táḏáḏí díde̖ˀman iví tꞌôe dônˀa̖míḏí, heḏá nä́ä oepáa kꞌayḏipiyá dísan. ");
INSERT INTO tew_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Naa naví Táḏáví tꞌôe dáyˀopíḏáhoˀ, wíḏînwhä̖yú̖-ípí. ");
INSERT INTO tew_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Hewänbo naa iví tꞌôe dáyˀo-ákun, heḏiho in dáyˀoˀin namuuḏi únkhâyˀä̖ˀ navíˀpiye úvíwhä̖yú̖-íˀin, tobáháa in otû̖ˀnin bînwhä̖yundepí wänboˀ. Handiḏânho taˀgendi únhanginpúwí naví Táḏá naa-áḏí namuuˀin heḏá naa-á naví Táḏá-áḏá omuuˀindá” kin Jesus-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ihayḏi wíyá óepankéyíˀin didaˀ, hewänbo inbíˀweḏi namapꞌä̖́. ");
INSERT INTO tew_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesus oe Jordan pꞌoˀpꞌä̖́näpiyeˀ nawáymää, John-di páaḏéḏí in tꞌowa ovâypꞌóˀpꞌoeˀan diwepiyeˀbá, heḏi iwebo iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Báyékí tꞌowa ivíˀpiyeˀ dimää. Ditú̖, “John hä̖ä̖wí wänbo pínnán wíˀikeeyanpí, hewänbo hä̖ä̖wí tꞌä̖hkí nä́ˀi senbí̖ˀgeḏi natú̖ˀi taˀgen namuu.” ");
INSERT INTO tew_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Heḏi iwáygé báyékí tꞌowa ivíˀpiyeˀ dívíwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Wí sen Lazarus gin nakhá̖wä̖́ˀi nahaypóe. I-áḏí Mary-áḏí heḏá Martha-áḏí ditíˀûuwinmuu, heḏi Bethany búuˀúˀay iweˀin dimuu. Mary-ânkunho i ka̖ˀpꞌo sawó̖ˀ nasu̖u̖ˀi Jesus-ví ân deeḏi óekä̖yu̖khâymáaˀi heḏáháˀ iví phóḏá óepiḏikhâymáaˀi namuu. ");
INSERT INTO tew_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mary-áḏí Martha-áḏí Jesus ôntꞌôesandi óetu̖ˀan, “Naˀinbí Sedó, ótꞌóyan, i nâaséegíˀi nahay.” ");
INSERT INTO tew_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus nä́ˀin natꞌoe ihayḏi natú̖, “Tobáháa nahay wänbo nawówáyê̖e̖ní, heḏiho háa ûnpúwíˀin namuuḏi in tꞌowa dâymûˀḏi Yôesi Táḏá kwꞌáayéboˀ óemáˀve-í, heḏá naa iví ay omuuˀi wáˀ kwꞌáayébo dímáˀve-í.” ");
INSERT INTO tew_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tobá Jesus-di Martha-á Mary-á heḏá Lazarus-á ovâyséegí wänboˀ, ");
INSERT INTO tew_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lazarus nahayˀin ûnhanginpóe ihayḏi wíye thaa waˀḏi iwáygéboˀ itsíkhaˀandi wíˀûnpu̖wä̖määpí. ");
INSERT INTO tew_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ihayḏáhoˀ iví khä̖ge̖ˀnin itu̖ˀan, “Yahoˀ oe Judea-piyeˀ giwáymú-í.” ");
INSERT INTO tew_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Iví khä̖ge̖ˀnindi óetu̖ˀan, “Há̖hkandiˀ, hä̂nhayboˀ in Huḏíyoví pꞌóˀḏéḏíˀindi wóekꞌusä̖yu̖héyíˀin didaˀpíˀan. Heḏi háaḏan eepiyeˀ unwáypundaˀ?” ");
INSERT INTO tew_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus-di ovâytu̖ˀan, “Thaaḏi nanáˀ dihayḏi tä̖ˀḏi wíye óḏa nakeenáhpíˀan. Wí toˀwí thaaḏi iyíyéndeˀi wínakanundepí, gá i ko nä́ä oepáa kꞌayḏigîˀ namuuˀiḏi nakeenândân heḏiho wáy namän niˀge imúndeˀ. ");
INSERT INTO tew_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Hewänbo wí toˀwí khu̖u̖ḏi iyíyéndeˀi-á nakanunde wíˀûnkohthaynáhpíḏi.” ");
INSERT INTO tew_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ihayḏáháˀ Jesus-di ovâytu̖ˀan, “Naˀinbí kꞌema Lazarus nayókhá̖, heḏi naa omän dóyóhsaaníḏí.” ");
INSERT INTO tew_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Iví khä̖ge̖ˀnindi óetu̖ˀan, “Há̖hkandiˀ, Lazarus nayókhândáho handiḏi nahewówa-í.” ");
INSERT INTO tew_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Indá diˀánde Jesus natu̖ˀdaˀin Lazarus taˀgendi nayókhá̖wä̖́kꞌóeˀin, hewänbo ho nachuuˀin natu̖ˀdaˀ-á. ");
INSERT INTO tew_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Heḏiho thayˀeeḏi ovâytu̖ˀan, “Lazarus-á ho nachuu. ");
INSERT INTO tew_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Heḏi ungîˀ shánkí híwó̖ˀ namuu naa iwe wóˀyipíḏí i nachuu ihayḏi, gá bînpu̖wä̖khâymáaḏân háa dônkhâymáaˀin, heḏi handiḏi shánkí navíˀpiyeˀ úvíwhä̖yu̖mä̂äní. Nää yahoˀ ivíˀpiyeˀ gimú-í.” ");
INSERT INTO tew_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas i kwâati gin dâykhá̖yä̖́ˀdeˀiḏi in wé̖ˀgeˀin khä̖ge̖ˀnin ovâytu̖ˀan, “Yaho gimú-í, heḏi Jesus óehayḏáhoˀ i-áḏíbá gichúu-í.” ");
INSERT INTO tew_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesus oe Bethany búuˀúˀay tsoˀwa napowaˀä̖ˀ ihayḏi óetu̖ˀan Lazarus óekhä̖ˀkꞌûˀ iweḏi yôenu thaahonaphaḏeˀin. ");
INSERT INTO tew_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany-á Jerusalem diweḏi kayi̖ˀ wínanáhpí, wíye míya ihayhä̖́yú̖, ");
INSERT INTO tew_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","heḏi Mary-á Martha-á inbíˀwe báyékí Huḏíyo dipówá ovä̂nsíwówáˀa̖míḏí, inbí tíˀûu dä́nmääḏi. ");
INSERT INTO tew_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesus naˀä̖ˀin Martha ûnhanginpóe ihayḏi naˀayyaypee, hewänbo Mary-á oe kꞌaygibo iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha-ḏi óeyayḏi óetu̖ˀan, “Naˀinbí Sedó, naví tíˀûu nahay ihayḏi hây nä́we unyiḏi háˀto nahá̖a̖níwän. ");
INSERT INTO tew_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Hebo naa dînhanginná nääbo hä̖ä̖wí Yôesi Táḏá nâadaaˀandiˀ iḏi wóemä̂äní.” ");
INSERT INTO tew_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus-di óetu̖ˀan, “Uví tíˀûu ú̖wáywówápúwí.” ");
INSERT INTO tew_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha-ḏi óetu̖ˀan, “Naa dînhanginná i tꞌä̖ˀgi thaa nanáˀ diwe tꞌä̖hkí tꞌowa ovâywáywówápaa ihayḏi nawáywówápuwagítꞌóeˀin.” ");
INSERT INTO tew_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus-di óetu̖ˀan, “Naa-ân i omuu tꞌowa dovâywáywówápaˀiˀ, naaḏi dovâywówátsimäˀ. Toˀwí navíˀpiyeˀ iwhä̖yu̖ˀiˀ iwówátsimáˀve-í tobá nachuu wänboˀ. ");
INSERT INTO tew_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Heḏi wí toˀwí waˀḏi nawówáyiˀi navíˀpiyeˀ iwhä̖yu̖ḏi háˀto nachúu-í. Ti biwhä̖yunde nä́ˀin?” ");
INSERT INTO tew_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha-ḏi óetu̖ˀan, “Heḏân ha̖a̖, Naˀinbí Sedó, naa dáywhä̖yundeˀ u̖-ân unmuu i Yôesi Táḏáḏí wóesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, Yôesi Táḏáví ay-ân unmuu. Ívítsíkhaˀmáawän nä́ä oepáa kꞌayḏipiyeˀ unˀä̖́ä̖-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kin natú̖ ihayḏiho Martha iweehoˀ, heḏi iví tíˀûu Mary itu̖ˀan iˀä̖ä̖hângeˀa̖míḏí heḏi óesäntu̖ˀan, “I há̖hkandi ho napówá heḏi u̖-áḏí nahíˀdaˀ.” ");
INSERT INTO tew_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary nä́ˀin natꞌoe ihayḏi weseboˀ iwí̖nú heḏi ee Jesus nayiˀ iwepiyeˀ namää. ");
INSERT INTO tew_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus i búuˀúˀay iwe waˀ wínapówápí, hewänbo waˀḏi Martha-ḏi óeyay iwáygébo nayiˀ. ");
INSERT INTO tew_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","In Huḏíyo ee tewhá íve dikwꞌó̖ˀnin Mary óesíwówáˀoˀindi óemûˀ wese iwí̖núḏí yáˀwépiyeˀ napeeḏi, heḏi diˀân Lazarus nakhä̖ˀkꞌóe iwepiyeˀ namännin isíhtä̖ä̖-íḏí, heḏiho ûnwóemää. ");
INSERT INTO tew_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary oe Jesus nayiˀ iwe napówá, heḏi óemûˀ ihayḏi iví páaḏépiyeˀ idéˀgendisógeḏi óetu̖ˀan, “Naˀinbí Sedó, naví tíˀûu nahay ihayḏi hây nä́we unyiḏi háˀto nahá̖a̖níwän.” ");
INSERT INTO tew_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mary-á in Huḏíyo ûnwóeˀä̖ä̖ˀindá dívísíhtu̖wí̖núndeḏi Jesus-di ovâymûˀ ihayḏi, iví píˀnä́ khóˀyé hânho nataachanpóe heḏi natha̖tha̖póe, ");
INSERT INTO tew_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","heḏi ovâytsikáyin, “Wáygan Lazarus óekhä̖ˀkꞌûˀ?” Óetu̖ˀan, “Naˀinbí Sedó, hêe naˀindáḏí ókä̖ˀveḏi nâamúníḏí.” ");
INSERT INTO tew_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus isíhtä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Heḏiho in Huḏíyo ditú̖, “Binmúˀḏí, taˀgendi Lazarus óeséegí.” ");
INSERT INTO tew_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hewänbo wáy wên ditú̖, “I to sen natsíˀtꞌaamuuˀiví keetan óemä́gi. Ti wáˀ wíˀûnkoeḏipíˀan Lazarus ônhehkháaˀa̖míḏí waˀ nachuupíḏíbo heḏânho wínachúu-ípíḏí?” ");
INSERT INTO tew_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus wíyá iví píˀnä́ khóˀyé hânho nataachanpóe, heḏi wí tꞌovápho nachá̖ˀ diwe i pení nakꞌóe iwe napówá. Wí kꞌuu pháagîˀ nakhaawin tꞌovápho ee. ");
INSERT INTO tew_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus-di ovâytu̖ˀan, “Hä̖ˀi kꞌuu wéhánäpiyeˀ binhângeˀan.” I nachuuˀiví páˀḏây Martha-ḏi Jesus óetu̖ˀan, “Naˀinbí Sedó, nää-áho nasu̖hkay, nää-á yôenu thaa nahán diweḏi ûnná.” ");
INSERT INTO tew_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus-di óetu̖ˀan, “Naaḏi wítu̖ˀanpíˀan, biwhä̖yu̖ndeḏáho nâamúní Yôesi Táḏá hânho nakayˀin.” ");
INSERT INTO tew_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Heḏi i kꞌuu wéhánäpiyeˀ dâyhângeˀan, heḏi Jesus oe makówápiyeˀ ibéeḏí natú̖, “Táḏá, naaḏi wíkú̖ˀdaaˀo naví yûusu dîntꞌóyandi. ");
INSERT INTO tew_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Heḏá dînhanginná hä̖̂ä̖ḏi wänbo tꞌä̖hkí dîntꞌóyandeˀin, hewänbo naa nä́ˀi tu̖u̖ otú̖ nä́ˀin tꞌowa nä́we diyiˀin ditꞌóe-íḏí u̖ḏi naa dísannin dívíwhä̖yu̖mä̂äníḏí.” ");
INSERT INTO tew_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ihayḏáháˀ kaygi natú̖, “Lazarus, ópive.” ");
INSERT INTO tew_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Heḏi i sen nachuˀkꞌóeˀi napee. Waˀḏi aa saygi̖ˀdiḏi naˀánmuu, iví ândá mandá wänboˀ, heḏá iví tsꞌay-á wáˀ aaḏi ûnˀánmuu. Jesus-di in tꞌowa ovâytu̖ˀan, “Binˀánsuu heḏânho ivíˀpiyeˀ namú-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Báyékí in Huḏíyo Mary-víˀpiyeˀ diˀáḏâapóya̖ˀnin háa Jesus iˀannin dâymûˀ, heḏi ivíˀpiyeˀ dívíwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Hewänbo wây-á in Pharisees-víˀpiyeˀ dimää ovâytu̖ˀâ̖a̖míḏí háa Jesus iˀannin. ");
INSERT INTO tew_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Heḏiho in owhaˀ pꞌóˀḏéḏíˀindáḏí heḏá in Pharisees-áḏí in Huḏíyoví tu̖yowaˀ ovâywé̖ˀgeˀan, heḏi ovâytsikáyin, “Hânnan ívíˀa̖mí? Nä́ˀi sendá báyékí ipínnántꞌôeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kin ikanhondi âymä́giḏáhoˀ, toˀwên tꞌä̖hkí ivíˀpiyeˀ dívíwhä̖yú̖-í, heḏá in Rome-win sundaḏo diˀä̖́ä̖-í heḏi naˀinbí méesate hayˀi dînnayú̖-í heḏá naˀinbí tꞌowa-á dînwáḏe-í.” ");
INSERT INTO tew_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wí sen in diweḏi ihay pa̖a̖yo naˀowhaˀpꞌóˀḏéḏîˀä́n, i-á Caiaphas kin nakhá̖wä̖́, heḏi iḏá ovâytu̖ˀan, “Undá hä̖ä̖wí wänbo wíˀúnhanginnáhpí. ");
INSERT INTO tew_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ti wíˀúnhanginnáhpíˀan shánkí yänbeḏi híwó̖ˀ namúníˀin ungîˀ wîˀḏa̖ˀ wí toˀwí tꞌä̖hkí naˀinbí tꞌowagîˀ iví wówátsi imä̂äníḏí, heḏi handiḏi naˀinbí tꞌowa tꞌä̖hkí wíˀovâyhá̖nú-ípí.” ");
INSERT INTO tew_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","I-á iví ánshaa iweḏibo nä́ˀi híˀ wínatú̖hpí, hewänbo wí Yôesi Táḏáví tukhe̖ˀbi namuu waagibá ihéeˀandânho háa napuwagítꞌóeˀin natú̖, gá i pa̖a̖yo owhaˀ pꞌóˀḏéḏîˀ namuuḏân. Heḏânkunho natú̖ Jesus-á tꞌä̖hkí in Israel tꞌowagîˀ nachuwagítꞌóeˀin. ");
INSERT INTO tew_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hewänbo ingîˀḏa̖ˀ wínachuwagítꞌóepí, in toˀwên Yôesi Táḏáví ây ûnmuuˀin wéngé tꞌä̖hkí diwaḏekwꞌó̖ˀningîˀ-ân wáˀ nachuwagítꞌóe, heḏânho ovâywé̖ˀgeˀa̖míḏí, heḏá wîˀḏa̖ˀ dipúwí. ");
INSERT INTO tew_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","I thaa iweḏi páaḏépiyeˀ in Huḏíyoví pꞌóˀḏéḏíˀin dívíhíˀmáa háḏíḏí óehéyí i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Heḏiho Jesus wíyá keeˀeeḏi wíˀiyíyéndepí, in Huḏíyoví pꞌóˀḏéḏíˀindi wíˀóemúnípíḏí, hewänbo iweḏi iyâatä̖ä̖ḏi oe ahkónu núˀ nanáˀ diwepiyeˀ namää, wí búuˀúˀay Ephraim gin dâytu̖ˀoˀ iwepiyeˀ, heḏi iwáygé iví khä̖ge̖ˀnindáḏí iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ihayhä̖̂ä̖bá in Huḏíyoví shánkîˀḏi púnúˀ naná, Passover gin dâytu̖ˀoˀiˀ. Waˀ i shánkîˀḏi thaa napówápíḏíbo báyékí tꞌowa Jerusalem búuˀúḏí yáˀwé dithaaˀin iwepiyeˀ dimää dívípikhâyˀa̖míḏí in Huḏíyoví khuu dínmuu waa. ");
INSERT INTO tew_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesus óetu̖wä̖máa, heḏi iwáygé méesate hayˀi íve diyiḏi dívítu̖máa, “Tigúba i nashánkîˀḏiˀä̖́ä̖-í?” ");
INSERT INTO tew_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","In owhaˀ pꞌóˀḏéḏíˀindáḏí heḏá in Pharisees-áḏí in tꞌowa ovâyyôn Jesus wáygé nayiˀin dínhanginpóeḏí ovâytꞌôeˀamí, heḏânho óepankéyíḏí. ");
INSERT INTO tew_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Waˀḏi sí thaa natáy nä́ˀin Huḏíyoví shánkîˀḏi Passover gin dâytu̖ˀoˀi dínnáníḏí, heḏi Jesus oe Bethany búuˀúˀay iwepiyeˀ nawáymää. Iwânkun Lazarus naˀä́n, i-á i sen Jesus-di óewáywówápaaˀibá namuu. ");
INSERT INTO tew_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Iweho Jesus ônkindihúukhâyˀan. Martha-ḏi ovâysä̖ä̖sandeˀ, heḏi Lazarus wáˀ in wé̖ˀgeˀindáḏí nahúuˀä́n. ");
INSERT INTO tew_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Heḏi Mary wí ka̖ˀpꞌoe saˀwó̖ˀ nasu̖u̖ˀi nard kin dâytu̖ˀoˀiˀ imaa. I ka̖ˀpꞌoe-á wîˀ taa nakháa heḏá hânho nachä̖ˀmuu. Heḏáháˀ Jesus-ví ân deeḏi ônˀewe, heḏá iví phóḏá Jesus-ví ân deeḏi óepíḏi. I ka̖ˀpꞌoeḏi ee íve i̖ˀge tꞌä̖hkí saˀwó̖ˀ nasu̖ˀpꞌíḏe. ");
INSERT INTO tew_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","6","Hewänbo wîˀ iví khä̖ge̖ˀninbíˀweḏi natsikapóe, “Háaḏan nä́ˀi ka̖ˀpꞌoe saˀwó̖ˀ nasu̖u̖ˀiˀ wíˀiku̖ˀchꞌáapí poewin tä̖gintä̖ (300) thaa tꞌôe dívíˀandi wáˀâaḏi, i chä̖ˀ in sehkanäwó̖ˀ diwówáyiˀin ovâymä̂äníḏí?” Nä́ˀi sen kin natú̖ˀi-á nakhá̖wä̖́ Judas Iscariot gin, i-á Jesus óeku̖hpekhâymáaˀi-ân namuu, heḏi nä́ˀin natú̖ sänbiˀ namuuḏi, in sehkanäwó̖ˀ diwówáyiˀindi óeˀá̖yîngimäḏá yoe. Iḏá in khä̖ge̖ˀninbí chä̖ˀ ovâyˀá̖yînmáa, heḏi iweḏiboˀ isänhóndeˀ. ");
INSERT INTO tew_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Hewänbo Jesus-di Judas óetu̖ˀan, “I kwee ánpí náˀan. Tobá hä̖ˀi ka̖ˀpꞌoe imáˀve-í. I thaa díkhä̖ˀkꞌúwígîˀ namuu. ");
INSERT INTO tew_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hä̖̂ä̖ḏi wänbo tꞌä̖hkí in sehkanäwó̖ˀ diwówáyiˀin tꞌowa undáḏí diyê̖e̖ní bînhä̖ä̖wímä̂äníḏí, hewänbo nä́we naa-á hä̂nhay wänbo tꞌä̖hkí háˀto undáḏí ocha̖ˀní.” ");
INSERT INTO tew_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Báyékí Huḏíyo dínhanginpóe Jesus oe Bethany nayiˀin, heḏiho iwepiyeˀ dimää Jesus nayiḏiḏa̖ˀbá yoe, hewänbo Lazarus i sen Jesus-di óewáywówápaaˀiˀ óemúníḏí wáˀ. ");
INSERT INTO tew_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Jesus-di Lazarus óewáywówápaa ihayḏi báyékí Huḏíyoḏi inbí pꞌóˀḏéḏíˀin ovâyyoekanhondi Jesus-víˀpiyeḏa̖ˀ dívíwhä̖yu̖hon, heḏiho in owhaˀ pꞌóˀḏéḏíˀin dâywéhpêeˀan Lazarus wáˀ óehéyíḏí. ");
INSERT INTO tew_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wíyá tháwä́n in báyékí tꞌowa in Passover shánkîˀḏipiyeˀ dipówáˀin dínhanginpóe Jesus oe Jerusalem-piyeˀ naˀä̖ˀin, ");
INSERT INTO tew_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","heḏi palm taykhóe dâytsꞌâˀḏi ûnˀayyaymää, heḏi kinnân dívítu̖hkwi̖nuhon: “Wíséegíkéndeˀ.” “Naˀinbí Sedó Yôesi Táḏáḏí wóesan, heḏiho híwó̖ˀ wóeˀâ̖a̖mí.” “U̖-á Israel-ví tsondi hayˀi unmuu.” ");
INSERT INTO tew_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Jesus wí búnduˀay ho ônkêˀḏi iwe naˀíˀä́n, heḏiho Yôesi Táḏáví ta̖ˀnin diwe háa ûntû̖ˀ waagibá napóe. Kinnân nata̖ˀmuu: Un tꞌowa Zion-win wíyá wíˀíkhuwôedaˀípí. Binmúˀḏí, unbí tsondi hayˀi wí búnduˀay kꞌéwéḏí únˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Ihayḏiho Jesus-ví khä̖ge̖ˀnin nä́ˀi hä̖ä̖wí napoˀiˀ wíḏikaˀpóya̖ˀpí, hewänbo tíˀúugéḏí Jesus wíyá oe makówápiyeˀ nawáypee ihayḏânho nä́ˀin iví̖ˀgeḏi nata̖ˀmuuˀin dínˀánpówá, heḏá dínhanginná háa nata̖ˀmuu waabá óeˀannin.) ");
INSERT INTO tew_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Hä̖̂ä̖ḏankánbo báyékí tꞌowa Jesus-áḏí diyiˀ i thaa iḏi Lazarus óewáywówápaaḏi penípho iweḏi napée-í kin óetu̖ˀan, heḏi nää nä́ˀin tꞌowaḏibá in wé̖ˀgeˀin tꞌowa ovâytu̖máa háa iwe iˀannin. ");
INSERT INTO tew_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Heḏiho nä́ˀin wé̖ˀgeˀin tꞌowa dínhanginpóe Jesus-á nä́ˀin pínnán tꞌôe iˀannin, heḏânkunho ûnˀayyaymää. ");
INSERT INTO tew_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","In Pharisees wíˀnä́ táye dívíchä̖nuˀoḏi ditû̖ˀ, “Ti wívînmúndepíˀan háa ídaˀ waagi wíˀúnpuwamänpíˀin. Binmúˀḏí, báyékí tꞌowa i-áḏíḏa̖ˀ dimän.” ");
INSERT INTO tew_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wên Greeks dimuuˀin in wé̖ˀgeˀin tꞌowa-áḏí diyiˀ, in oe Jerusalem dínshánkîˀḏináˀ diwepiyeˀ diˀä̖ä̖ˀin Yôesi Táḏá óeˀaˀginmä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Indá Philip-víˀpiyeˀ dimää (i-á Bethsaida búuˀúˀay oe Galilee nangewi namuu), heḏi óetu̖ˀan, “Kꞌema, Jesus-áḏí gihíˀdaˀ.” ");
INSERT INTO tew_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip namää Andrew óetu̖ˀâ̖a̖míḏí, heḏáháˀ Philip-á Andrew-áḏá Jesus-víˀpiyeˀ damää óetu̖ˀâ̖a̖míḏí háa ditú̖ˀin. ");
INSERT INTO tew_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus natú̖, “Ihayḏi púnúˀ nanânho nakeepúwíḏí hayˀi omuuˀin, naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ. ");
INSERT INTO tew_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hebo taˀgendi wâytu̖máa, wí táhtá̖ koˀyi óekoeḏi iví wówátsi imäˀ waagibá ûnpoˀ heḏânho shánkí báyékí iweḏi natá̖hpaa-íḏí, heḏi iví wówátsi imähpíḏá iweḏi hä̖́ä̖bo wínapaˀpí, iwebo wíˀbo nawänpikꞌóe. ");
INSERT INTO tew_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Toˀwên inbí wówátsi nä́ä oepáa kꞌayḏi ingîˀḏa̖ˀ dínmuuˀindá inbí wówátsi dipeḏée-í, hewänbo toˀwên inbí wówátsi nä́ä oepáa kꞌayḏi ingîˀḏa̖ˀ wíḏínmuupíˀindá, inbí wówátsi hä̂nhay wänbo tꞌä̖hkí dâymáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Toˀwên naagîˀ dívítꞌôeˀa̖míˀin didaˀḏi naa díyu̖u̖máˀve-íˀin dínkhâyˀä̖ˀ, heḏihoˀ iwáygé naa oyiˀ iwe, naví tꞌôeˀin iwáygébá diyê̖e̖ní. Toˀwên naagîˀ dívítꞌôeˀoˀin naví Táḏáḏí ovâytu̖ˀâ̖a̖mí híwó̖ˀ dívítsiyeˀannin.” ");
INSERT INTO tew_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nääho naví píˀnä́ khóˀyé dînkháapóe. Ti naví Táḏá dondaaˀa̖mí nä́ˀin dînpuwagítꞌóeˀin diweḏi dînˀaywoeníḏí? Heḏân yoe, nä́ˀin dînpuwagítꞌóeˀin namuuḏânkun nä́ä oepáa kꞌayḏipiyeˀ oˀä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Heḏânho nä́ˀin wídaˀmáa naví Táḏá, ovâykeeya̖mí u̖-á hayˀi unmuuˀin” kin Jesus natú̖. Ihayḏi nä́ˀi tu̖u̖ makówáḏí natꞌoetꞌóe: “Han dáyˀanhoˀ, heḏá waˀ wíyá hanbá dáykhâymáa.” ");
INSERT INTO tew_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","In tꞌowa iwáygé diwinnin i tu̖u̖ ditꞌoe, heḏi wáy wên ditú̖, “Ikwa̖hta̖a̖ˀan” gin, heḏá wây-á ditú̖, “Wí makówáwi tꞌôepa̖ˀa̖a̖ˀiḏi óehéeˀan.” ");
INSERT INTO tew_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus-di ovâytu̖ˀan, “Nä́ˀi tu̖u̖-á naagîˀḏa̖ˀ wínamuupí, hewänbo ungîˀ wáˀ namuu. ");
INSERT INTO tew_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ihayḏi púnúˀ naná Yôesi Táḏáḏí in óetaapíˀin ovâykeekwꞌôeníḏí híwó̖ˀpí dívíˀannin, heḏá Penísendi inbí tsondi dínmuuˀi-á óetꞌaaníḏá. ");
INSERT INTO tew_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hewänbo naa nä́ä nangeḏi dítꞌóhtä̖gekꞌúwíḏí dítege ihayḏi naaḏi tꞌä̖hkí tꞌowa dovâytu̖kánnamí navíˀpiyeˀ diˀä̖́ä̖-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nä́ˀin natú̖ ovâythayya̖míḏí háawin chuwa ûnpuwagítꞌóeˀin. ");
INSERT INTO tew_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ee tꞌowa yâageḏi toˀwíḏí óetu̖ˀan, “Yôesi Táḏáví ta̖ˀnin diwe nata̖ˀmuu i toˀwí iḏi óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí hä̂nhay wänbo tä̖hkí nawówáyê̖e̖níˀin. Heháaḏan untû̖ˀ i to tꞌä̖hkí tꞌowagîˀ naˀaypu̖yä̖ˀiˀ óetegé-í óetꞌóhtä̖gekꞌúwíḏí? To-an namuu nä́ˀi toˀwí tꞌä̖hkí tꞌowagîˀ naˀaypu̖yä̖ˀiˀ? Ti i-á namuu i toˀwí Yôesi Táḏáḏí óesogekhâymáaˀi tꞌowa ovâyˀaywoeníḏí?” ");
INSERT INTO tew_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus-di ovâytu̖ˀan, “Wí kohthay waagiˀbá omuu, hewänbo undáḏí wí hây tä̖hkíḏa̖ˀ ochangítꞌóe. Naa oyiˀ iwe nakeená, heḏiho waˀḏi nää undáḏí oyiḏiboˀ unbí wówátsi naa-áḏí binhûu, heḏânho nakhu̖u̖náˀ niˀge wíˀíyê̖e̖nípíḏí. Toˀwí khu̖u̖ i̖ˀge namändi-á wáy namän niˀge wíˀûnhanginnáhpí. ");
INSERT INTO tew_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Naa i kohthay omuuˀivíˀpiyeˀ bíwhä̖́yú̖ waˀ undáḏí oyiḏiboˀ, heḏânho tꞌowa i kohthay iwe íthaaˀin ípúwíḏí.” Nä́ˀin Jesus natú̖ ihayḏihoˀ iwáygéḏí namääḏi ikaayan wíˀóeshaa-ípíḏí. ");
INSERT INTO tew_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hewänbo tobá báyékí pínnán inbí páaḏépiyeˀ ikeeyan wänboˀ, waˀḏi ivíˀpiyeˀ wíḏívíwhä̖yundepí. ");
INSERT INTO tew_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Heḏiho háa Yôesi Táḏáví tukhe̖ˀbiˀ Isaiah ita̖ˀnan waagi napóe. I-á hä́nˀoe natú̖, Naˀinbí Sedó, i híˀ gitú̖ˀiˀ wíḏívíwhä̖yu̖pí. Heḏi unkayˀin wíḏínhanginnáhpí. ");
INSERT INTO tew_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Heḏiho wíḏínkoeḏipí dívíwhä̖yú̖-íḏí, gá dínpóeḏân háa wíyá wáygé Isaiah ita̖ˀnan waa: Yôesi Táḏáḏí inbí tsée ovâykhaayan, heḏânho wíḏínkeepoˀpí waagibá dínpúwíḏí, heḏá inbí hangintandá ovâyyâaˀan, heḏânho wíḏikaˀpówá-ípíḏí, heḏi navíˀpiyeˀ wíḏiˀä̖ˀpí dovâyˀowóyé-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah nä́ˀin ita̖ˀnan gá Jesus-á hayˀi napuwagítꞌóeˀin ho ûnkeepóeḏân, heḏânkun iví̖ˀgeḏi ihéeˀan. ");
INSERT INTO tew_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hebo tobá Jesus-víˀpiyeˀ wáy wên wíḏívíwhä̖yu̖pí wänboˀ, báyékí in Huḏíyo pꞌóˀḏéḏíˀin wänbo ivíˀpiyeˀ dívíwhä̖yu̖mä́gi, hewänbo keeˀeeḏi wíḏitú̖hpí dívíwhä̖yu̖ˀin gá in Pharisees-di i méesate eepiyeˀ ovâytsuḏekhâ̖a̖ˀa̖míḏí dikhuwôedaˀḏân, ");
INSERT INTO tew_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","heḏi nä́ˀin Huḏíyo pꞌóˀḏéḏíˀin shánkí didaˀ tꞌowa híwó̖ˀ inbí̖ˀgeḏi dívíhéeˀa̖míˀin Yôesi Táḏá híwó̖ˀ inbí̖ˀgeḏi dívíhéeˀa̖mívíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Heḏi Jesus-di kaygi ovâytu̖ˀan, “Toˀwí navíˀpiyeˀ iwhä̖yundeˀi-á navíˀpiyeḏa̖ˀ wíˀiwhä̖yundepí, hewänbo i naa dísandivíˀpiyân wáˀ iwhä̖yundeˀ. ");
INSERT INTO tew_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Heḏi toˀwíḏí naa dímúndeḏi i naa dísandiˀ wáˀ óemúndeˀ. ");
INSERT INTO tew_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naa nä́ä oepáa kꞌayḏipiyeˀ oˀä̖ä̖ wí kohthay waagiˀbá omúníḏí, heḏânho toˀwên navíˀpiyeˀ dívíwhä̖yundeˀin khu̖u̖ i̖ˀge wíḏiyê̖e̖nípíḏí. ");
INSERT INTO tew_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Naa wóˀtû̖ˀpí in toˀwên naví híˀ ditꞌoeḏi hewänbo wíḏâyˀaˀgindopíḏí dínkhâyˀä̖ˀ ovâytuchä̖nú-íˀin. Naa oˀä̖ä̖ tꞌowa dovâyˀaywoeníḏí, dínkhâyˀä̖ˀ ovâytuchä̖nú-íˀin otú̖níḏá yoe. ");
INSERT INTO tew_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","I tꞌä̖ˀgi thaa nanáˀ diwe nä́ˀi naví híˀ ho dovâytu̖ˀandiˀ namuuḏânkun in toˀwên naa díyoegiˀannin heḏá háa otú̖ waa wíḏînséegíˀanpíˀin ovâytuchä̖nukhâymáa, ");
INSERT INTO tew_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","gá naa háa naví Táḏáḏí dísandiḏá naa díyôn waagiḏa̖ˀ dáyhéeˀoˀ, háa owänpidaˀ waagá yoe. ");
INSERT INTO tew_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Heḏi dînhanginná i tsontu̖u̖ naví Táḏá imä́giˀi wówátsi nahándepíˀin napä̖yiˀin. Heḏânho háa naví Táḏáḏí dítu̖ˀanninda̖ˀ naa otû̖ˀ heḏá haˀwâa dáyhéeˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wîˀ thaa waˀ natáy i Passover shánkîˀḏi thaagîˀ. Jesus ûnhanginná i thaa napowaˀä̖ˀin nä́ä oepáa kꞌayḏi iweḏi iví Táḏávíˀpiyeˀ namú-íḏí. Hä̖̂ä̖ḏi wänbo tꞌä̖hkí in ivíˀin ûnmuuˀin ovâyséegí waˀ nä́äḏí nayiˀ ihayḏi, heḏi nää ovâykeekankhâymáa hânho ovâyséegíˀin. ");
INSERT INTO tew_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wé̖ˀge dívíkindihúuyoˀ ihayḏi, Penísendiḏi Simon-bí ay Judas Iscariot i ánshaa ho óemä́gi Jesus óeku̖ˀpꞌâyníḏí. ");
INSERT INTO tew_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus ûnhanginná iví Táḏáḏí tꞌä̖hkí kay óemä́giˀin, heḏá ûnhanginná Yôesi Táḏávíˀweḏi naˀä̖ä̖ˀin heḏi ivíˀpiyeˀbá nawáymännin, ");
INSERT INTO tew_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","heḏihoˀ ee nahúuˀä́n diweḏi iwí̖núḏí iví kꞌéwéˀin to ipꞌä̖́ḏi, heḏi wên pꞌoepiḏiˀin aaḏi iseebaˀáaˀan. ");
INSERT INTO tew_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Heḏáháˀ wên oewä̖́ä̖bay iwe ipꞌoesaaḏi iví khä̖ge̖ˀnin iˀânˀowíḏíhon heḏá in pꞌoepiḏiˀin aa naseebaˀáamuuˀindiḏá ovâyˀânpíḏi. ");
INSERT INTO tew_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Peter-víˀwe napówá ihayḏi Peter-di óetsikáyin, “Naˀinbí Sedó, ti u̖ḏi naa díˀânˀowíḏíkhâymáa?” ");
INSERT INTO tew_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus-di óetu̖ˀan, “Nää wíˀunhanginnáhpí háaḏí kin dáyˀoˀin, hewänbo wáy wí thaa ú̖hanginpúwí.” ");
INSERT INTO tew_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter-di óetu̖ˀan, “Háˀto díˀânˀowíḏi-íˀin wímä̂äní.” Jesus-di óetu̖ˀan, “Naaḏi wíˀowíḏipíḏá navîˀ wú̖ˀmuupíhoˀ.” ");
INSERT INTO tew_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter-di óetu̖ˀan, “Heḏáhoˀ, Naˀinbí Sedó, naví man dînˀowiḏi heḏá naví pꞌôndá, naví ânda̖ˀbá yoe.” ");
INSERT INTO tew_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus-di óetu̖ˀan, “Toˀwí iˀoeˀiví túuˀú tꞌä̖hkí khá̖a̖pîˀ ûnmuu, iví ânda̖ˀ ûnˀowíḏítáy. Heḏi undá khá̖a̖píˀin ímuu, hewänbo un tꞌä̖hkíḏíbo-á yoe.” ");
INSERT INTO tew_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus ûnhanginná toˀwíḏí óeku̖hpegítꞌóeˀi namuuˀin, heḏânho natú̖, “Tꞌä̖hkíḏíbo khá̖a̖píˀin wíˀímuupí” gin. ");
INSERT INTO tew_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tꞌä̖hkí inbí ân ovâyˀowíḏíbowa ihayḏi iví kꞌéwéˀin to iwáytógi, heḏi indáḏí iwáysóge. Ihayḏi ovâytsikáyin, “Ti únhanginná háaḏí kin wâyˀannin? ");
INSERT INTO tew_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Undi naa dítu̖ˀo há̖hkandi-áḏí pꞌóˀḏéḏîˀ-áḏí, heḏi híwó̖ˀ kin ítû̖ˀ, ha̖ˀbi-ânkun omuuḏi. ");
INSERT INTO tew_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Heḏihoˀ undá únkhâyˀä̖ˀ wíˀnä́ táye bînˀânˀowíḏi-íˀin, gá naa unbí há̖hkandiˀ heḏá pꞌóˀḏéḏîˀ omuuˀiḏi wâyˀânˀowíḏiḏân. ");
INSERT INTO tew_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nä́ˀi háa dáyˀannin naaḏi wâykeeyan heḏânho háa naaḏi wâyˀan waagibá un wáˀ wíˀnä́ táye úvíkanhûuwí. ");
INSERT INTO tew_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Taˀgendi wâytu̖máa, wí tꞌôeˀi-á iví tsondiví shánkí hayˀi wínamuupí, heḏá wí tꞌôekhuwaˀi-á i óeyôndiví shánkí hayˀi wínamuupí. ");
INSERT INTO tew_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Háa wâytu̖ˀan waa íkaˀpóya̖ˀdáhoˀ, naví híˀ bînˀaˀginnamí heḏiho íhíhcha̖a̖-í. ");
INSERT INTO tew_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Hewänbo naa wóˀtû̖ˀpí un tꞌä̖hkíḏíbo háa wâytu̖ˀan waa úvíkhâymáaˀin. Naa dînhanginná toˀwên in dovâyde̖ˀmannin dimuuˀin. Hewänbo nä́ˀin háa Yôesi Táḏáví ta̖ˀnin diwe natû̖ˀ waa ûnkhâyˀä̖ˀ napúwíˀin: I toˀwí naa-áḏí ihú̖u̖yandi wänbo híwó̖ˀpîˀ naa díkhâymáa. ");
INSERT INTO tew_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nää wâytu̖máa háa napuwagítꞌóeˀin waˀ napóepíḏíboˀ, heḏânho napóe ihayḏá úvíwhä̖yú̖-í naa i omuu hä́nˀoeḏiboˀ oyiˀiˀ. ");
INSERT INTO tew_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Taˀgendi wâytu̖máa, toˀwêndi wí naaḏi dósandiˀ óeséegíˀoḏi, indi naa wáˀ díséegíˀo waagibá dívíˀoˀ, heḏi toˀwêndi naa díséegíˀoḏá, i naa dísandiˀ wáˀ óeséegíˀo waagibá dívíˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus-di nä́ˀin ovâytu̖ˀan dihayḏihoˀ iví píˀnä́ ûnkháapóe, heḏi thayˀeeḏi ovâytu̖ˀan, “Taˀgendi wâytu̖máa, un diweḏi wîˀḏi naa díku̖hpekhâymáa.” ");
INSERT INTO tew_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iví khä̖ge̖ˀnin dívíwänpipu̖wä̖ˀoˀ, toˀwíví̖ˀgeḏi ihíˀmáaˀin wíḏínhanginnáhpíḏí. ");
INSERT INTO tew_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","I khä̖ge̖ˀdi Jesus-di óeséegíˀiˀ iví núˀbá naˀä́n. ");
INSERT INTO tew_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Heḏiho Simon Peter imannan nä́ˀi khä̖ge̖ˀdiḏi óemúníḏí, heḏi óetu̖ˀan, “Jesus nátsikáyin toví̖ˀgeḏan ihíˀmáaˀin.” ");
INSERT INTO tew_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Heḏihoˀ i khä̖ge̖ˀdi Jesus-ví shánkí núˀ ihá̖ḏiḏi óetsikáyin, “Naˀinbí Sedó, to-an i namuu wóeku̖hpekhâymáaˀiˀ?” ");
INSERT INTO tew_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus-di óetu̖ˀan, “Naa wí pává i sä̖ä̖ iwe dópꞌohtôení, heḏi wí toˀwí dópä̖gítꞌóe. Iví̖ˀgeḏân dáyhíˀmáa.” Heḏi wí pává ikêˀḏi ipꞌohtógiḏi Judas óemä́gi, i-á Simon Iscariot-ví ay namuu. ");
INSERT INTO tew_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas i pává ikêˀ ihayḏi weseboˀ i Penísendi iví píˀnä́ ûntsꞌú̖, heḏi Jesus-di óetu̖ˀan, “Hä̖ä̖wí háa bikhâymáaˀi wesebo náˀan.” ");
INSERT INTO tew_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Hewänbo toˀwí wänboˀ in dihúukwꞌó̖ˀnin diweḏi wíˀûnhanginnáhpí háaḏí Jesus-di kin óetu̖ˀannin. ");
INSERT INTO tew_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas-á i chä̖ˀ múu imáa, heḏiho wên diˀân Jesus-di óetu̖ˀan hä̖ä̖wí i shánkîˀḏigîˀ díntáyˀiˀ iku̖mä́-íˀin, heḏá wây-á wêndá diˀân in sehkanäwó̖ˀ diwówáyiˀin wí hä̖ä̖wí ovâymä̂äní gân óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Heḏiho Judas i pává ikêˀḏi wesebo napee. Ihayḏiho nakhu̖u̖ná. ");
INSERT INTO tew_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas napee ihayḏi Jesus natú̖, “Ihayḏi nanânho tꞌowa dínhanginpúwíḏí naa tꞌä̖hkí tꞌowagîˀ oˀaypu̖yä̖ˀiˀ hayˀiˀ omuuˀin, heḏá háa naa dînpuwagítꞌóeˀin namuuḏi dínhanginpúwí Yôesi Táḏá wáˀ hayˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Heḏiho Yôesi Táḏáḏí hayˀi naa dípaa-í iví haybá omúníḏí, heḏá nä́ˀin ikhâymáa weseboˀ. ");
INSERT INTO tew_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Naví áyyä̖̂ä̖, wí hä̖́yú̖ thaaḏa̖ˀ undáḏí ochangítꞌóe, heḏi nää in Huḏíyoví pꞌóˀḏéḏíˀin dovâytu̖ˀan waagibá un wáˀ wâytu̖máa, undi dítu̖wä̖khâymáa, hewänbo wáy omän diwepiyeˀ wíˀúnkoeḏí-ípí nää ímu-íˀin. ");
INSERT INTO tew_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Naaḏi wên tsꞌa̖a̖min tsontu̖u̖ nää wâypä̖khâymáa, heḏi kinnân namuu: Wíˀnä́ táye úvíséegíhûuwí. Naaḏi wâyséegí waagibá, hanbá wíˀnä́ táye úvíséegíhûuwí. ");
INSERT INTO tew_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Úvíséegíhondáho toˀwên tꞌä̖hkí dínhanginnání naví khä̖ge̖ˀnin ímuuˀin.” ");
INSERT INTO tew_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter-di óetsikáyin, “Naˀinbí Sedó, wépiyan unmän?” Jesus-di óetu̖ˀan, “Nää-á wíˀú̖koeḏipí wáy omän deepiyeˀ díyu̖u̖hûuwíḏí, hewänbo wáy wí thaa wáy omän diwepiyeˀbá unmú-í.” ");
INSERT INTO tew_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Simon Peter-di óetsikáyin, “Naˀinbí Sedó, háaḏan wíḏînkoeḏipí wíyu̖u̖hûuwíḏí nää? Naa okhâymuu naví wówátsi u̖gîˀ dáymä̂äníḏí.” ");
INSERT INTO tew_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus-di óetu̖ˀan, “Ti naa omuuḏi unkhâymuu uví wówátsi bimä̂äníḏí? Nä́ˀin taˀgendi wítu̖ˀâ̖a̖mí: Wí dee sen waˀ ikinpíḏíboˀ u̖-á poewin untú̖ní wíḏítaapíˀin.” ");
INSERT INTO tew_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Heḏáháˀ Jesus tꞌä̖hkí iví khä̖ge̖ˀnin itu̖ˀan, “Ánshaa iwe wíˀíkwo̖ˀnípí. Yôesi Táḏávíˀpiyeˀ úvíwhä̖yu̖hûuwí heḏá navíˀpiyá. ");
INSERT INTO tew_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Naví Táḏáví kꞌaygi ûnnáˀ diwe báyékí ûnˀívená. Nä́ˀin taˀgen namuupíḏáho háˀto wâytu̖ˀâ̖a̖míwän taˀgen namuuˀin. Heḏiho nää omän wí íve wí̖ˀínbo wâykhâyˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Heḏi wí íve wâykhâyˀa̖míḏí omääḏá wíyá owáyˀä̖ä̖-í un wâyhûuwíḏí naa-áḏí, heḏânho wáy oˀä́n diwebá un wáˀ íkwo̖ˀní. ");
INSERT INTO tew_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Un únhanginná wáypiyeˀ omännin, heḏá in pꞌôe naa omän deepiyeˀ wáˀ únhanginná.” ");
INSERT INTO tew_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas-di óetu̖ˀan, “Naˀinbí Sedó, wígínhanginnáhpí wáypiyeˀ unmännin wänboˀ. Heḏi háḏíḏan in pꞌôe unmän deepiyeˀ gínhanginnání?” ");
INSERT INTO tew_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus-di óetu̖ˀan, “Naa-á in pꞌôe omuu, heḏá in taˀgendá, heḏá in wówátsi-á. Toˀwí wänbo wûnkoeḏipí naví Táḏávíˀpiyeˀ namú-íḏí, navíˀpiyeˀ páaḏé naˀä̖ä̖ḏiḏa̖ˀmânhoˀ. ");
INSERT INTO tew_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Toˀwí naa omuuˀin taˀgendi ûnhanginnândáho naví Táḏá wáˀ dîntáa-íwän. Nää iweḏiho bîntaa heḏá bînmûˀ.” ");
INSERT INTO tew_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip-di Jesus óetu̖ˀan, “Naˀinbí Sedó, i Táḏá naˀin dînkeeya̖mí. Hä̖hayḏa̖ˀ gíntáy.” ");
INSERT INTO tew_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus-di óetu̖ˀan, “Philip, gáhä̂nhay waaboˀ undáḏí oyihoˀ, hebo waˀḏi wíˀú̖hanginnáhpí toˀwí omuuˀin. Toˀwên naa dímûˀindá i Táḏá wáˀ dâymûˀ. Heḏi háaḏan dítu̖máa i Táḏá wâykeeya̖mí gin? ");
INSERT INTO tew_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Háaḏan wíviwhä̖yundepí i Táḏá-áḏí omuuˀin heḏi i Táḏá-á naa-áḏá omuuˀindá? Nä́ˀi híˀ wâytu̖ˀoˀi navîˀḏa̖ˀ wíḏînmuupí, hewänbo naa dáyhíˀmáa ihayḏi naví Táḏá naa-áḏí namuuˀiˀ iví tꞌôe iˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nä́ˀi naaḏi wâytu̖máaˀi binwhä̖́yú̖: Naa-á i Táḏá-áḏí omuu, heḏá i Táḏá-á naa-áḏá namuu. Hewänbo naví híˀ dînwhä̖yundepíḏáhoˀ, i hä̖ä̖wí dáyˀoˀi namuuḏi bíwhä̖́yú̖ wé̖ˀge gamuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Taˀgendi wáytu̖máa, toˀwên navíˀpiyeˀ dívíwhä̖yundeˀindá, naa dáyˀan waabá in wáˀ dívíkankhâymáa, heḏá waˀḏi shánkí heˀendi hä̖ä̖wí-á dívíkankhâymáa, gá naa naví Táḏávíˀpiyeˀ omändân. ");
INSERT INTO tew_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Úvíwhä̖yundeḏáho naa dînkꞌóeˀin wâyˀa̖míḏí i ídaˀpoˀiˀ, naaḏi wâyˀa̖mí-ákun, heḏi hä̖ä̖wí naa Yôesi Táḏáví ay omuuˀi dóˀoˀiḏi tꞌowa dínhanginnání i Táḏá hayˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hä̖ä̖wí namúní wänbo ídaˀpoˀḏi, naa dînkꞌóeˀin wâyˀa̖míḏí úvíwhä̖yundeḏá, naa dóˀa̖mí-ákun.” ");
INSERT INTO tew_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Undi díséegíḏáhoˀ i tsontu̖u̖ wâymä́giˀi dînˀaˀginnamí. ");
INSERT INTO tew_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Heḏi naaḏi naví Táḏá dódaaˀamí wíyá toˀwí wovâykhä̖ge̖ˀnamíˀi wovâysaaníḏí, heḏi han i Táḏá iˀa̖mí. Nä́ˀi wovâykhä̖ge̖ˀkhâymáaˀi-á hä̖̂ä̖ḏi wänbo tꞌä̖hkí undáḏí nayê̖e̖ní, i-á i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ namuu, heḏi in taˀgen nahá̖hkanyiˀ. ");
INSERT INTO tew_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","In toˀwên Yôesi Táḏá dâytaapíˀindá nä́ˀi Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ wíˀóemúndepíḏí heḏá wíˀóetaapíḏí háˀto daykéyí. Hewänbo undiḏân bîntaa, undáḏí nayiḏi, heḏá unbí píˀnä́ khóˀyé i bînmáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Naaḏi wên táḏápíˀin yíyápíˀin waagiˀinbá wíwâyyoekankhâymáapí, naa-á unbíˀpiyeˀ owáyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hây napóe ihayḏi in tꞌowa Yôesi Táḏá dâytaapíˀindi naa wiya wíḏímúnípí, hewänbo undáho dímúní, heḏá íwówáyê̖e̖ní gá naa owówáyiḏân. ");
INSERT INTO tew_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Heḏi i thaa napówá ihayḏá únhanginnání naa naví Táḏá-áḏí omuuˀin, heḏá undáḏí naa-áḏí wé̖ˀge gimuuˀindá wáˀ únhanginnání. ");
INSERT INTO tew_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Toˀwên naví tsontu̖u̖ dînhógiˀin heḏá dînˀaˀgindoˀindá, indânho naa díséegí, heḏi toˀwên naa díséegíˀindá naví Táḏáḏí ovâyséegí, heḏá naaḏi wáˀ dovâyséegí, heḏi dovâykhä̖ge̖ˀna̖mí shánkí híwó̖ˀ dítaa-íḏí” kin Jesus natú̖. ");
INSERT INTO tew_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Wí khä̖ge̖ˀdiˀ Judas gin nakhá̖wä́ˀiˀ, hebo Judas Iscariot-dá yoe, iḏân Jesus óetsikáyin, “Naˀinbí Sedó, heháaḏan naˀinda̖ˀ díkhä̖ge̖ˀkhâymáa shánkí híwó̖ˀ wítaa-íḏí, heḏi hä̖ˀin tꞌowa Yôesi Táḏá dâytaapíˀindá yoe?” ");
INSERT INTO tew_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus-di óetu̖ˀan, “Toˀwên naa díséegíˀindá naví híˀ dînˀaˀgindoˀ, heḏi naví Táḏáḏáho ovâyséegímáˀve-í, heḏi naví Táḏá-áḏí naa-áḏí inbí píˀnä́ khóˀyé änthayé-í. ");
INSERT INTO tew_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Toˀwên naa díséegípíˀindá naví híˀ wíḏînˀaˀgindopí. Heḏi i híˀ naaḏi wâytu̖ˀandi-á navîˀḏa̖ˀ wíḏînmuupí, naví Táḏáḏí dísandiví híˀ-ân ûnmuu. ");
INSERT INTO tew_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nä́ˀi hä̖ä̖wí naaḏi wâytu̖máa waˀḏi nä́ä undáḏí oyiḏiboˀ. ");
INSERT INTO tew_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Hewänbo i toˀwí wovâykhä̖ge̖ˀnamíˀiḏá tꞌä̖hkí úntáyˀi wovâyhá̖ˀa̖mí, heḏá tꞌä̖hká naaḏi wâytu̖ˀandi-á wovâyˀánshaakannamí. I-á i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-ân namuu, heḏi naví Táḏádí i wovâysaaní gá han dódaaˀandân. ");
INSERT INTO tew_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Naaḏi wâykhä̖ge̖ˀnamí heḏânho ánshaa iwe wíˀíkwo̖ˀnípíḏí. Naaḏa̖ˀ dînkoeḏi han wâyˀa̖míˀin, in toˀwên Yôesi Táḏá dâytaapíˀindá wíḏínkoeḏipí. Unbí píˀnä́ khóˀyé wíˀíˀá̖yîngi-ípí heḏá wíˀíkhuwôedaˀípí. ");
INSERT INTO tew_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Naví Táḏávíˀpiyeˀ omän heḏá unbíˀpiyá owáyˀä̖ˀ gin wâytu̖ˀandi ítꞌoe. Naví Táḏá-á naví shánkí hayˀi namuu heḏi taˀgendi undi naa díséegíḏáhoˀ íhíhcha̖a̖-í ivíˀpiyeˀ omändi. ");
INSERT INTO tew_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nä́ˀi tꞌä̖hkí nää wâytu̖máa waˀḏi napóepíḏíboˀ, heḏânho owáy napóe ihayḏá undi naví híˀ dînwhä̖yú̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Wíyá shánkí naaḏi wíwâytu̖ˀa̖mípí, gá i Penísendi naˀä̖ḏân, i-á in Yôesi Táḏá dâytaapíˀinbí tsondi dínmuu. Iḏá naa wíḏítsonmáapí. ");
INSERT INTO tew_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Hewänbo nää naví Táḏáḏí naa díyôn waa dáykhâymáa, tꞌä̖hkí tꞌowa dínhanginnáníḏí i-ân dóséegíˀin. “Bíwí̖nú, yaho nä́weḏi gimú-í.” ");
INSERT INTO tew_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Naa wên híwó̖ˀnin úuva áaphä̖ä̖ waagiˀbá omuu, heḏi naví Táḏá-á i áaphä̖ä̖ á̖yí̖ˀdi waagiˀbá-á namuu. ");
INSERT INTO tew_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","In tꞌowa navíˀin dînmuuˀin áaphä̖ä̖ waˀyáy khóe waagiˀinbá dimuu. Tꞌä̖hkí waˀyáy khóe naˀúuvapaapîˀ naví Táḏá itsꞌándeḏi iyâaˀoˀ, heḏá i waˀyáy khóe naˀúuvapaa iweḏá i hí̖ˀíndi híwó̖ˀpîˀ namuuˀi-á iyâaˀo shánkí báyékí híwó̖ˀ napáa-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Undá i híwó̖ˀpîˀ ho únyâamuu i híˀ naaḏi wâytu̖ˀandi bîntꞌóyandi. ");
INSERT INTO tew_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Hä̖̂ä̖ḏi wänbo tꞌä̖hkí naa-áḏí ímúníˀin únkhâyˀä̖ˀ, heḏi naa-á hä̖̂ä̖ḏi wänbo tꞌä̖hká undáḏí omúní. Wên waˀyáy khóe wänbo wíˀbo wínahä̖ä̖paˀpí, nä́ˀin waˀyáy khóe in áaphä̖ä̖ eeḏi nachândiḏa̖ˀmân nahä̖ä̖paˀ, heḏi hanbá un naa-áḏí hä̖̂ä̖ḏi wänbo tꞌä̖hkí ímuupíḏáhoˀ, háˀto únkoeḏí-í híwó̖ˀdi hä̖ä̖wí úvíˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Toˀwên hä̖̂ä̖ḏi wänbo tꞌä̖hkí naa-áḏí dimuuˀin heḏá naa-á indáḏí omuuḏá, indá báyékí híwó̖ˀ dívíˀa̖mí. Naa-áḏí ímuupíḏí hä̖ä̖wí wänbo háˀto bînˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","In toˀwên naa-áḏí hä̖̂ä̖ḏi wänbo dimuupíˀindá waˀyáy khóe tꞌowa dâytsꞌâˀiˀ waagibá dínpúwí. Ki̖ˀbi waˀyáy khóe-á dâychꞌáaḏí natꞌaˀ, heḏi dâywé̖ˀgeˀandi dâyphamääḏeˀ. ");
INSERT INTO tew_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Naa-áḏí hä̖̂ä̖ḏi wänbo tꞌä̖hkí íkwꞌôndá naví híˀ-á unbí píˀnä́ khóˀyé bînmáaḏá, únkoeḏi hä̖ä̖wí wänbo ídaˀi Yôesi Táḏá bîndaaˀa̖míḏí, heḏi iḏá wovâymä̂äní, ");
INSERT INTO tew_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","heḏânho tꞌowa dínhanginnání naví Táḏá hayˀi namuuˀin, heḏihoˀ undá báyékí híwó̖ˀ úvíˀâ̖a̖mí, heḏi kindiḏiho taˀgendi naví khä̖ge̖ˀnin ímúní. ");
INSERT INTO tew_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Naví Táḏáḏí naa díséegí waagibá naaḏi wâyséegí. Naví séegí wóegé hä̖̂ä̖ḏi wänbo tꞌä̖hkí ímúní. ");
INSERT INTO tew_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Naa naví Táḏáví tsontu̖u̖ dônˀaˀgindoḏi iví séegí wóegé hä̖̂ä̖ḏi wänbo tꞌä̖hkí omuu. Heḏá undá hanbá naví tsontu̖u̖ dînˀaˀginhondáhoˀ, naví séegí wóegé hä̖̂ä̖ḏi wänbo tꞌä̖hkí ímúní. ");
INSERT INTO tew_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nä́ˀi tꞌä̖hkí wâytu̖ˀan heḏânhoˀ i híhchan dómáa waagibá un wáˀ unbí píˀnä́ khóˀyé bînmáˀve-íḏí, heḏá tꞌä̖hkí híhchanda̖ˀ bînmáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nä́ˀin tsontu̖u̖ naaḏi wâytu̖máa: Wíˀnä́ táye úvíséegíhûuwí naaḏi wâyséegí waagibá. ");
INSERT INTO tew_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","In toˀwên inbí wówátsi inbí kꞌemaˀingîˀ dívímä́giˀindá shánkí hayˀin séegí namúníˀin dâymáa. ");
INSERT INTO tew_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Heḏi undá hä̖ä̖wí naaḏi wâyyôn waagi bînkanhondáho naví kꞌemaˀin ímuu. ");
INSERT INTO tew_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nää iweḏi páaḏépiyeˀ naví tꞌôeˀin ginda̖ˀ naaḏi wíwâytu̖kankhâymáapí, gá wí tsondi-á iví tꞌôeˀin háa ikhâymáaˀin wíˀitu̖ˀopíḏân, hewänbo naví kꞌemaˀinnân gin wâytu̖ˀâ̖a̖mí, gá hä̖ä̖wí naví Táḏáḏí dítu̖ˀandiˀ naaḏi wâyhanginˀânnandân. ");
INSERT INTO tew_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Undi naa wíḏíde̖ˀmanpí, naaḏá un wâyde̖ˀman, heḏá wovâykwꞌóḏi báyékí híwó̖ˀ úvíˀa̖míḏí, heḏi i híwó̖ˀ úvíˀoˀi-á nakâypúwí. Naví Táḏáḏí naa dînkꞌûˀ hä̖ä̖wí ídaˀpóeˀiˀ wâyˀa̖míḏí, heḏiho úvíwhä̖yundeḏáhoˀ iḏi wovâymä̂äní. ");
INSERT INTO tew_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kinnân naaḏi wâytsonmáa: Wíˀnä́ táye úvíséegíhûuwí.” ");
INSERT INTO tew_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“In tꞌowa Yôesi Táḏá dâytaapíˀindi wovâytꞌayḏáho wíˀúnˀóḏe-ípí unbí páaḏébo naa dítꞌayˀin. ");
INSERT INTO tew_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","In Yôesi Táḏá dâytaapíˀin tꞌowa waagiˀinbá ímuuḏáhoˀ, indi wovâyséegí-í, inbíˀin dínmuuˀin dâyséegí waagibá. Hewänbo in waagiˀinbá wíˀímuupí. Naaḏi wâyde̖ˀman Yôesi Táḏá bîntáa-íḏí, heḏânkun indiho wovâytꞌay. ");
INSERT INTO tew_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Wíˀúnˀóḏe-ípí háa wâytu̖ˀannin: Wí tꞌôeˀi-á iví tsondiví shánkí hayˀi wínamuupí. Heḏiho toˀwên naa dítꞌôephaḏekannannindi un wáˀ wovâytꞌôephaḏekannamí, heḏi toˀwên naví híˀ dînˀaˀginnannindi unbîˀ wáˀ wovâyˀaˀginnamí. ");
INSERT INTO tew_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Navíˀin ímuuḏibo tꞌä̖hkí nä́ˀi híwó̖ˀpîˀ hä̖ä̖wí tꞌowaḏi wovâyˀa̖mí. Háaḏí? Gá i naa dísandiˀ wíḏâytaapíḏân. ");
INSERT INTO tew_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Naaḏi naví híˀ dovâytu̖ˀâ̖a̖míḏí oˀä̖ä̖píḏáho nä́ˀi tꞌaywó̖ˀdi wíḏínmuupíwän. Hewänbo oˀä̖ä̖-ákun, heḏânho nää wîˀ wänbo wíˀûnkoeḏipí natú̖níḏí, ‘Naa wíḏînhanginnáhpí dáytꞌaywó̖ˀnannin.’ ");
INSERT INTO tew_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Toˀwên naa dítꞌayˀindá naví Táḏá wáˀho dîntꞌay. ");
INSERT INTO tew_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Waˀḏi indáḏí oyiˀ ihayḏi báyékí hä̖ä̖wí dáyˀan wíyá toˀwí wänbo hä̂nhay wänbo iˀanpîˀ. Ki̖ˀbi tꞌôe dáyˀanpíḏáho nä́ˀi tꞌaywó̖ˀdi wíḏínmuupíwän. Hewänbo háa naa dáyˀannin dâymûˀ-ákun, heḏi naa-áḏí naví Táḏá-áḏí wí̖ˀgíndíbo dítꞌay. ");
INSERT INTO tew_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Heḏi kin dívíˀandi naa háa inbí ta̖ˀkan naví̖ˀgeḏi nata̖ˀmuu waa dînpóe, kinnân: Wên híwó̖ˀpíˀin wíḏáyˀanpí wänbo naa dítꞌay. ");
INSERT INTO tew_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Owáy naví Táḏávíˀwe opówá ihayḏi i toˀwí wovâykhä̖ge̖ˀkhâymáaˀi-á naaḏi wâysangítꞌóe. Nä́ˀi naví Táḏávíˀweḏi unbíˀpiyeˀ nakä̖ˀä̖ä̖gítꞌóeˀi-á i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ namuu. Heḏi napówá ihayḏi naví̖ˀgeḏi ihéeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Heḏá undá wáˀ tꞌowa naví̖ˀgeḏi bîntu̖ˀâ̖a̖mí, gá páaḏé naví tꞌôe dontsꞌanˀan diweḏiboˀ un naa-áḏí íyiḏân. ");
INSERT INTO tew_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nä́ˀi hä̖ä̖wí naaḏi wâytu̖ˀan heḏânho unbí whä̖yu̖ wíˀúnhá̖a̖nípíḏí. ");
INSERT INTO tew_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","In Huḏíyoḏi inbí méesate íve wovâytsuḏekhâ̖a̖ˀa̖mí, heḏá wáˀ shánkí wänbo únpúwí, wáy wí thaa nanáˀ diwe wovâytꞌa̖há̖núḏáho diˀâ̖a̖ní Yôesi Táḏágîˀ dívítꞌôemáaˀin. ");
INSERT INTO tew_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Háaḏan kin dívíkhâymáa? Gá Yôesi naví Táḏá dînmuuˀi wíḏîntaapíḏân, heḏá naa wáˀ wänbo wíḏítaapí. ");
INSERT INTO tew_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nä́ˀi napuwagítꞌóeˀi wâytu̖máa waˀ napóepíḏíboˀ, heḏânho napóe ihayḏá naaḏi wâytu̖ˀan niˀgeḏi únˀánpowagítꞌóe. Naaḏi nä́ˀi hä̖ä̖wí wíwâytu̖ˀanpí páaḏé naví tꞌôe dontsꞌanˀan dihayḏi, gá waˀḏi undáḏí oyiḏân.” ");
INSERT INTO tew_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Nää tobá i naa dísandivíˀpiyeˀ omän wänboˀ, wénä wí wänbo undi wíḏítsikaˀmáapí wä̖́hä̖̂ä̖piyeˀ omännin. ");
INSERT INTO tew_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nä́ˀi hä̖ä̖wí wâytu̖ˀandiḏihoˀ unbí píˀnä́ khóˀyé nää báyékí únkháapoˀ. ");
INSERT INTO tew_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Hewänbo in taˀgen wâytu̖máa: Ungîˀ shánkí yänbeḏi híwó̖ˀ namuu naa omú-íḏí, gá naa omääpíḏáhoˀ i toˀwí wovâykhä̖ge̖ˀkhâymáaˀi wínaˀä̖́ä̖-ípíḏân, hewänbo omääḏáhoˀ i dósaaní unbíˀpiyeˀ. ");
INSERT INTO tew_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Heḏi owáy napówá ihayḏá tꞌowa ovâythayya̖mí piháa diˀánshaamuuḏi wíḏikaˀpóya̖ˀpíˀin inbí tꞌaywó̖ˀdi i̖ˀgeḏi, heḏá i híwó̖ˀdi namuu i̖ˀgeḏá, heḏá Yôesi Táḏáḏí tꞌowa ovâytuchä̖nukhâymáa i̖ˀgeḏá. ");
INSERT INTO tew_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iḏi ovâythayya̖mí dívítꞌaywó̖ˀnannin, navíˀpiyeˀ wíḏívíwhä̖yundepíḏí. ");
INSERT INTO tew_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Naa híwó̖ˀdiˀ omuu i̖ˀgeḏi ovâythayya̖mí, gá naa i híwó̖ˀdiˀ omuuˀi naví Táḏávíˀpiyeˀ omändân, heḏi wíyá wíḏímúnípí. ");
INSERT INTO tew_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yôesi Táḏáḏí tꞌowa ovâytuchä̖nukhâymáa i̖ˀgeḏi ovâythayya̖mí, gá ho natú̖ḏân iḏi i Penísendi óetuchä̖nukhâymáa, i-á in tꞌowa Yôesi Táḏá dâytaapíˀinbí tsondi dínmuu. ");
INSERT INTO tew_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Naa waˀḏi báyékí wâytu̖ˀâ̖a̖míˀin odaˀ, hewänbo nää wíˀúnkoeḏipí ihay bînhóníḏí. ");
INSERT INTO tew_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Hewänbo owáy i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ napówá ihayḏi, i-á in taˀgen tꞌä̖hkí nahá̖hkanyiˀiˀ namuu, iḏi wovâykhä̖ge̖ˀkhâymáa in taˀgen namuuˀin naví̖ˀgeḏi taˀgendi únhanginpúwíḏí, gá iví ánshaa ûnmuuˀiḏa̖ˀ wíˀihíˀkhâymáapíḏân, hewänbo háa Yôesi Táḏáḏí óetu̖ˀan waagi natú̖ní, heḏá háa napuwagítꞌóeˀin wovâytu̖ˀâ̖a̖mí. ");
INSERT INTO tew_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Háa natú̖níˀin navíˀweḏi ihóní heḏi wovâytu̖ˀâ̖a̖mí. Handiḏi wovâyhanginˀânnamí naa hayˀi omuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Naví Táḏáví há̖hkan ûnmuuˀi-á navîˀ wáˀ dînmuu. Heḏânho naa otú̖, i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ háa wovâytu̖ˀâ̖a̖míˀin navíˀweḏi ihóní.” ");
INSERT INTO tew_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Hanwaapíḏíboˀ undi wíḏímúnípí, heḏá iweḏá hanwaapíḏíbo-á undi naa wíyá díwáymúní.” ");
INSERT INTO tew_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wên iví khä̖ge̖ˀnin wíˀnä́ táye dívítu̖ˀan, “Hânnan hêe nä́ˀin dítu̖ˀannin natu̖ˀdaˀ? Natú̖, ‘Hanwaapíḏíbo wíḏímúnípí’ gin, heḏá ‘Iweḏá hanwaapíḏíbo-á wíyá naa díwáymúní’ gân. Heḏá wáˀ natú̖, ‘Kin napúwí gá naví Táḏávíˀpiyeˀ omändân.’ ");
INSERT INTO tew_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Heḏi hânnangú iví híˀ ‘hanwaapíḏíboˀ’ ûntu̖ˀdaˀ? Hä̖ä̖wí i̖ˀgeḏi ihíˀmáaˀin wígínhanginnáhpí.” ");
INSERT INTO tew_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus ûnhanginná ditsikapúwíˀin didaˀ, heḏihoˀ ovâytsikáyin, “Ti úvítsikaˀmáa háa otu̖ˀdaˀin wâytu̖ˀandi, ‘Hanwaapíḏíboˀ undi wíḏímúnípí, hebo iweḏá hanwaapíḏíbo-á wíyá díwáymúní’? ");
INSERT INTO tew_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Taˀgendi wâytu̖máa, undá íséeyê̖e̖ní heḏá úvísíhtu̖wí̖nú-í, hewänbo in tꞌowa Yôesi Táḏá dâytaapíˀindá dihíhchanpúwí. Hebo íkꞌáykháapóe wänbo nä́ˀi-á únphaḏé-í heḏi híhchan bînmáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wí kwee naˀeyekhâyyiˀi hânho nachanpoˀ, naˀeyehaypúwí ihay nanândi. Hewänbo iví ay ûnˀaypu̖yä̖ ihayḏá, iví hay i̖ˀgeḏi wíyá wíˀûnˀánpóya̖ˀpí, gá nahíhchanpóeḏân iví ay ûnˀaypu̖yä̖ḏi. ");
INSERT INTO tew_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Heḏi hanbá undá nää únpoˀ. Un íkꞌáykháapoˀ naa wáypiyeˀ omändi, hewänbo owáy naa wíyá oˀä̖ä̖ ihayḏá unbí píˀnä́ khóˀyé íhíhcha̖a̖-í, heḏi toˀwí wänbo wíˀûnkoeḏí-ípí unbí híhchan únmuuˀin wovâykwée-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Heḏi ihayḏi wíˀúntâynípí hä̖ä̖wí wänbo dítsikáyi̖ˀníḏí. Taˀgendi wâytu̖máa, hä̖ä̖wí naví Táḏá bîndaaˀandiˀ, navíˀpiyeˀ úvíwhä̖yundeḏi, iḏi wovâymä̂äní. ");
INSERT INTO tew_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nää puˀwahay waˀḏi hä̖ä̖wí wänbo wíˀídaˀpóepí navíˀpiyeˀ úvíwhä̖yunde wänboˀ. Nää bindaaˀan, heḏânho bînhóní, heḏá báyékí híhchan bînmáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nä́ˀi hä̖ä̖wí wâytu̖ˀandi wâyhá̖ˀa̖míḏí ûnthaykantáy, hewänbo owáy wí thaa nanáˀ diwe kindiḏi wíyá wíwâyhéeˀa̖mípí, thayˀeeḏân naví Táḏáví̖ˀgeḏi wâytu̖ˀâ̖a̖mí. ");
INSERT INTO tew_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Heḏi ihayḏi shánkí híwó̖ˀ bîntaaḏi un íhä̖ä̖wídaˀpúwí navíˀpiyeˀ úvíwhä̖yundeḏi, heḏi wíyá wínatâynípí naa naví Táḏávíˀpiyeˀ wâyyûusuˀa̖míḏí, hewänbo iḏi wovâyséegíḏí unnânho ivíˀpiyeˀ úvíyûusuˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Heḏi iḏi wovâyséegí gá undi naa díséegíḏân heḏá úvíwhä̖yundeḏá naa ivíˀweḏi oˀä̖ä̖ˀin. ");
INSERT INTO tew_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nä́ä oepáa kꞌayḏipiyeˀ naví Táḏávíˀweḏân oˀä̖ä̖-ákun. Heḏi nää-á nä́weḏi naví Táḏávíˀpiyebá ováymän.” ");
INSERT INTO tew_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iví khä̖ge̖ˀnindi óetu̖ˀan, “Näbáhaˀ thayˀeeḏi bihíˀmáa, nää-á uví híˀ-á ûnthaykantáyˀiˀ wíˀú̖muupí. ");
INSERT INTO tew_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nää gínhanginpóe u̖ hä̖ä̖wí tꞌä̖hkí ú̖hanginnáˀnin, heḏá hä̖ä̖wí toˀwíḏí wóetsikáyi̖ˀníˀin nadaˀiˀ u̖ ú̖hanginnânho waˀ wóetsikáyi̖ˀpíḏíboˀ. Heḏânho ívíwhä̖yunde Yôesi Táḏávíˀweḏi unˀä̖ä̖ˀin.” ");
INSERT INTO tew_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus-di ovâytu̖ˀan, “Nää-á ítû̖ˀ navíˀpiyeˀ úvíwhä̖yundeˀin, ");
INSERT INTO tew_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","hewänbo nää iweḏi un tꞌä̖hkí íwaḏeḏée-í, heḏi wí̖ˀínboˀ unbí pꞌóegé bînkéyí heḏi naa wíˀbo díyoeˀa̖mí. Hewänbo naví Táḏá naa-áḏí nayiḏi taˀgendi wíˀbo háˀto oyê̖e̖ní. ");
INSERT INTO tew_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Naaḏi tꞌä̖hkí nä́ˀi wâytu̖ˀan heḏânho naa-áḏí ímuuḏi ánshaa iwe wiˀíkwo̖ˀnípíḏí. In Yôesi Táḏá dâytaapíˀinbí yáagé waˀ íyiˀ ihayḏibo bîntꞌôephaḏekhâymáa, hewänbo kayˀindi úvíwí̖nú-í, naa i yä̖ˀḏâapîˀ nä́ä oepáa kꞌayḏiwi dótꞌan.” ");
INSERT INTO tew_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus iví khä̖ge̖ˀnin nä́ˀi tꞌä̖hkí itu̖ˀan dihayḏi makówápiyeˀ ibéeḏí kinnân iyûusuˀan: “Táḏá, ihayḏiho dînná. Nää ovâykeeyan naa uví ay omuuˀi hayˀi omuuˀin, heḏânho u̖-á hayˀi unmuuˀin naaḏi dovâykeeya̖mí. ");
INSERT INTO tew_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","U̖ḏi dísóge tꞌä̖hkí tꞌowaví tsondi omúníḏí, heḏânho naaḏi tꞌä̖hkí in u̖ḏi dímä́giˀin in wówátsi nahándepíˀin dovâymä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","U̖ḏa̖ˀ i taˀgendi Yôesi unmuu, heḏá naa-á Jesus omuu, i u̖ḏi dísandiˀ tꞌowa dovâyˀaywoeníḏí, heḏi in toˀwên u̖-áḏí naa-áḏí dítaaˀindáho wówátsi nahándepíˀin dâymáa. ");
INSERT INTO tew_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Waˀḏi nä́ä oepáa kꞌayḏi oyiˀ ihayḏi in tꞌowa dovâykeeyan u̖-á hayˀi unmuuˀin, gá in tꞌôe u̖ḏi díkanyônnin tꞌä̖hkí dóbowaḏân. ");
INSERT INTO tew_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Táḏá, naa hayˀi omuu waˀḏi u̖-áḏí oyiˀ ihayḏiboˀ, waˀ hä̖ä̖wí wänbo nakhíˀyenpí ihayḏiboˀ. Nää uvíˀpiyeˀ owáymän, heḏiho ovâykeeya̖mí naa hayˀi omuuˀin, háa omúˀde waagibá. ");
INSERT INTO tew_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“In toˀwên nä́ä oepáa kꞌayḏi u̖ḏi naa dímä́giˀin dovâykeeyan háawi unmuuˀin. Indá páaḏéboˀ uvíˀin ú̖muu, heḏá u̖ḏá indá dímä́gi, heḏi uví híˀ wônˀaˀginnan. ");
INSERT INTO tew_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nää in dínhanginpóe hä̖ä̖wí tꞌä̖hkí u̖ḏi dímä́giˀi taˀgendi uvíˀweḏi naˀä̖ˀin, ");
INSERT INTO tew_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","gá hä̖ä̖wí u̖ḏi naa dítu̖ˀandiˀ naaḏi dovâytu̖ˀandân, heḏi dâyséegíˀan. In dínhanginná taˀgendi uvíˀweḏi oˀä̖ä̖ˀin, heḏá dívíwhä̖yundeˀ u̖ḏi dísannin. ");
INSERT INTO tew_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Naaḏi ingîˀ dovâyyûusuˀoˀ. Nää tꞌä̖hkí tꞌowagíˀin wíḏáyyûusuˀopí, hewänbo in u̖ḏi dímä́giˀingíˀinḏa̖ˀmân dáyyûusuˀoˀ, indá uvíˀin ú̖muuḏi. ");
INSERT INTO tew_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tꞌä̖hkí navíˀin dînmuuˀin uvíˀin wáˀ ú̖muu, heḏi uvíˀin ú̖muuˀindá navíˀinbá dînmuu. Heḏi háa inbí wówátsi dâyhon waagiḏibo nakeepoˀ naa hayˀi omuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nää uvíˀpiyeˀ omän, heḏi nä́ä oepáa kꞌayḏi wóˀyê̖e̖nípí, hewänbo nä́ˀindá nä́äḏíbo waˀḏi diyiˀ. Naví Táḏá, u̖ shánkí yä̖ˀḏâaˀi unmuuˀiˀ, uví kay ú̖muuˀiḏi á̖yîngiḏiboˀ ovâymáˀve-í, i kay u̖ḏi dímä́giˀiḏibá, heḏânho wîˀḏa̖ˀ waagibá dimúníḏí, naa-áḏí u̖-áḏí wîˀḏa̖ˀ gamuu waagibá. ");
INSERT INTO tew_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Waˀḏi indáḏí oyiˀ ihayḏi á̖yîngiḏi híwó̖ˀ dovâymáa uví kay ú̖muuˀiḏi, i kay dímä́giˀiḏibá, heḏá dovâyˀá̖yîngimáaḏí wîˀḏa̖ˀmân in diweḏi napeḏee, i-á i ha̖ˀbi namuu napeḏeegítꞌóeˀiˀ, heḏiho háa uví ta̖ˀnin diwe iví̖ˀgeḏi nata̖ˀmuu waa ûnpóe. ");
INSERT INTO tew_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Heḏi nää uvíˀpiyeˀ omän, heḏi dáyyûusuˀoḏi nä́ˀi tꞌä̖hkí otû̖ˀ waˀḏi nä́ä oepáa kꞌayḏi oyiḏiboˀ, heḏânho inbí píˀnä́ khóˀyé tꞌähkí híhchan dâymáˀve-í, naa dómáa waagibá. ");
INSERT INTO tew_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naaḏi uví híˀ dovâymä́gi, heḏi in tꞌowa wóetaapíˀindi ovâytꞌay, hä̖ˀin tꞌowa waagiˀin wíḏimuupíḏí, naa wänbo wáˀ in waagi wóˀmuupí waagibá. ");
INSERT INTO tew_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Naaḏi wíwídaˀmáapí nä́ä oepáa kꞌayḏi iweḏi ovâyyâaˀa̖míḏí, hewänbo wídaˀmáa u̖ḏi á̖yîngiḏiboˀ ovâymáˀve-íḏân, heḏânho i Penísendiḏi wíˀovâyhónípíḏí. ");
INSERT INTO tew_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","In wóetaapíˀin waagiˀinbá wíḏimuupí, naa wänbo wáˀ-á yoe. ");
INSERT INTO tew_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","In taˀgen ovâyhá̖ˀa̖mí heḏânho taˀgendi uvíˀpiyeˀ dívímä̂äníḏí. Uví híˀ-á in taˀgen namuu. ");
INSERT INTO tew_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","U̖ḏi naa nä́ä oepáa kꞌayḏipiyeˀ dísan waagibá, naaḏi nä́ˀin navíˀin dînmuuˀin wáˀ tꞌä̖mäpiyeˀ nä́ä oepaa kꞌayḏi dovâysankhâymáa. ");
INSERT INTO tew_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","In navíˀin dînmuuḏi naa uvíˀpiyeˀ dáymäˀ heḏânho in wáˀ taˀgendi uvíˀpiyeˀ dívímä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Naaḏi nä́ˀingíˀinda̖ˀ wíḏáyyûusuˀopí, hewänbo wé̖ˀgeˀin tꞌowagîˀ wáˀ dáyyûusuˀoˀ, in toˀwên nä́ˀinbí híˀ dínmuuˀiḏi navíˀpiyeˀ dívíwhä̖yu̖khâymáaˀin, heḏiho wîˀḏa̖ˀ waagibá dipúwíḏí. ");
INSERT INTO tew_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Naví Táḏá, u̖-á naa-áḏí unmuu, heḏá naa-á u̖-áḏá omuu, heḏi hanbá innân wáˀ naˀindáḏí dimúníˀin naa odaˀ. Heḏi kin naa dáyyûusuˀoˀ heḏânho tꞌä̖hkí tꞌowa dívíwhä̖yú̖-íḏí u̖ḏi naa dísannin. ");
INSERT INTO tew_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Naaḏi heˀennin dovâypáa-í, u̖ḏi naa hayˀi dípaa waagibá, heḏânho wîˀḏa̖ˀ dipúwíḏí, u̖-áḏí naa-áḏí wîˀḏa̖ˀ gamuu waagibá. ");
INSERT INTO tew_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naa indáḏí omuu, heḏi u̖-á naa-áḏá unmuu, heḏiho taˀgendi wîˀḏa̖ˀ dipúwí, heḏi handiḏi tꞌä̖hkí tꞌowa dínhanginnání u̖ḏi naa dísannin, heḏá dínhanginnání wáˀ u̖ḏi nä́ˀin naa-áḏí dimuuˀin ovâyséegíˀin, u̖ḏi naa díséegí waagibá. ");
INSERT INTO tew_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Naví Táḏá, naa odaˀ in u̖ḏi dímä́giˀin naa-áḏí dikwo̖ˀníˀin wáy naa ochangítꞌóe iwebá, heḏânho u̖ḏi naa hayˀi dípaaˀin dâymúníḏí. U̖ḏi naa hayˀi dípaa gá ho waˀḏi nä́ˀi nan oepáa nâakhíyépíḏíbo naa díséegíḏân. ");
INSERT INTO tew_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Táḏá, u̖ taˀgeḏa̖ˀ biˀoˀiˀ unmuuˀiˀ, tobá báyékí tꞌowaḏi wíwóetaapí wänboˀ, naaḏi wítaa, heḏi nä́ˀin navíˀin dînmuuˀin dínhanginná u̖ḏi naa dísannin. ");
INSERT INTO tew_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Háawi unmuuˀin naaḏi dovâyhanginˀânnan, heḏá shánkí híwó̖ˀ dovâyhanginˀânkhâymáa, heḏânho u̖ḏi naa díséegí waagibá ha̖ˀbi séegíbá inbí píˀnä́ khóˀyé dâymáˀve-íḏí, heḏá naa-á indáḏá omúní.” ");
INSERT INTO tew_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus iyûusubowa ihayḏi iví khä̖ge̖ˀnindáḏí iweḏi dimää, heḏi owáy Kidron kó̖ˀ pꞌä̖́näpiyeˀ dimää. Iwáygé wí navaˀay na-olive-taysaaˀi nakꞌóe, heḏi Jesus-áḏí iví khä̖ge̖ˀnindáḏí i navaˀay iwe ditsꞌú̖. ");
INSERT INTO tew_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas i Jesus óeku̖ˀpꞌégiˀiˀ ûnhanginná wáygé iwe nanáˀnin, hä̖́yä́n wänbo Jesus iví khä̖ge̖ˀnindáḏí iwepiyeˀ namääḏi. ");
INSERT INTO tew_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Heḏiho Judas-di wên Rome-win sundaḏo-á wên sundaḏo i méesate hayˀi dâyˀá̖yí̖ˀdoˀindá heḏá wên Pharisees-á ovâymaa, heḏi phakó-á kohséephé naphaamuuˀi-á inbí kꞌuuphé-á dínmahkä́nmuuˀi wóegé iwe dipówá. ");
INSERT INTO tew_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus ûnhanginná hä̖ä̖wí tꞌä̖hkí háa ûnpuwagítꞌóeˀin, heḏiho iˀa̖htuyeḏi inbí páaḏépiyeˀ iwí̖nú, heḏi ovâytsikáyin, “To-an bîntu̖wä̖máa?” ");
INSERT INTO tew_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Gá Jesus i Nazareth-wi-ân” kin óetu̖ˀan. Iḏá ovâytu̖ˀan, “Naa-ân i omuu.” Judas i óeku̖ˀpꞌégiˀiˀ iwebá indáḏí nayiˀ. ");
INSERT INTO tew_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Naa-ân i omuu” gin ovâytu̖ˀan dihayḏi tíˀûupiyeˀ dívíhá̖ḏiḏi dikanu. ");
INSERT INTO tew_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Heḏáháˀ wíyá ovâytsikáyin, “To-an bîntu̖wä̖máa?” Indi óetu̖ˀan, “Gá Jesus i Nazareth-wi-ân.” ");
INSERT INTO tew_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus-di ovâytu̖ˀan, “Wâytu̖ˀanho naa-ân i omuu. Heḏiho naaḏa̖ˀ dítu̖wä̖máaḏá, nä́ˀin wé̖ˀgeˀin binpunmä́ä.” ");
INSERT INTO tew_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Haˀwâagi ovâytu̖ˀan dihayḏi háa hä̖̂ä̖ḏankánboˀ iyûusuˀan waa napóe. Kinnânho iyûusuˀan: “Wîˀ wänbo in dímä́giˀin diweḏi wíḏînpeḏée-ípí.” ");
INSERT INTO tew_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Peter wí tsiyó pháˀ imáa, heḏi iwhahkêˀḏi i owhaˀ pꞌóˀḏéḏîˀví tꞌôeˀi Malchus gin nakhá̖wä̖́ˀiˀ óewhä̖́ḏiḏi iví koˀḏíngéḏíˀin oeyay heˀyinbo ôntꞌó̖ˀtsꞌâˀ. ");
INSERT INTO tew_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus-di Peter óetu̖ˀan, “Uví tsiyó pháˀ hä̖ˀi súḏe iwebá mänwáytoˀ. Nä́ˀin tꞌôephaḏe naví Táḏáḏí naa dînsannindá dînkhâyˀä̖ˀ donphaḏé-íˀin.” ");
INSERT INTO tew_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","In sundaḏo-áḏí inbí tsondi-áḏí in hayˀi méesatewin á̖yí̖ˀnindáḏí Jesus óepankêˀḏi óekhówhiˀan. ");
INSERT INTO tew_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Iweḏi oe Annas-víˀpiyeˀ páaḏé óehoˀ. Ihay pa̖a̖yo-á Caiaphas naˀowhaˀpꞌóˀḏéḏîˀä́n, heḏi Annas-á Caiaphas-ví yahsédo-á ûnmuu. ");
INSERT INTO tew_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiaphas-dá in Huḏíyoví pꞌóˀḏéḏíˀin hä̖̂ä̖ḏankánbo ovâytumakheˀoḏi ovâytu̖ˀan, “Shánkí yänbeḏi híwó̖ˀ namúní wîˀḏa̖ˀ wí toˀwí tꞌä̖hkí in tꞌowagîˀ nachúu-íḏí.” ");
INSERT INTO tew_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","Simon Peter-áḏí wíyá khä̖ge̖ˀdi-áḏí Jesus-ví tíˀúugé damän. I owhaˀ pꞌóˀḏéḏîˀḏi nä́ˀi khä̖ge̖ˀdiˀ óetaa, heḏiho i khä̖ge̖ˀdiˀ ûnkoeḏi natsꞌú̖níḏí i tewhá tehpaa búge i owhaˀ pꞌóˀḏéḏîˀ nathaa iwe. Peter-á oe tehpaa yáˀwébo-á phóḏi núˀ óeyoeˀan, heḏiho i khä̖ge̖ˀdi nawáypee nä́ˀi a̖ˀyú̖ iphóḏiˀá̖yînmáaˀiˀ óehéeˀa̖míḏí, heḏi Peter oe tehpaa búgepiyeˀ óetsꞌúḏe. ");
INSERT INTO tew_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","I a̖ˀyú̖ḏí Peter óetu̖ˀan, “Hä̖ˀi sen óepankêˀiví khä̖ge̖ˀdibá unmuupíˀan.” Peter natú̖, “Naa-á yoe.” ");
INSERT INTO tew_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Natꞌêeḏiho in tꞌôeˀindá in hayˀi méesatewin sundaḏo-á phaaˀuuḏi dâyphaˀtꞌégi, heḏi phaa núˀ disúwáwin. Peter wáˀ iwebá iwí̖nú. ");
INSERT INTO tew_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","I tewhá íve i owhaˀ pꞌóˀḏéḏîˀḏi Jesus óetsikaˀmáa iví khä̖ge̖ˀninbí̖ˀgeḏi heḏá iví híˀ in tꞌowa ovâyhá̖ˀoˀ i̖ˀgeḏá. ");
INSERT INTO tew_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus-di óetu̖ˀan, “Naa tꞌowa tꞌä̖hkíví páaḏépiyeˀ dáyhéeˀowän, heḏi hä̖̂ä̖ḏi wänbo tꞌä̖hkí dovâyhá̖ˀowän inbí méesate hí̖ˀíndiˀ eeye heḏá inbí méesate hayˀiˀ ee-á, wáygé tꞌä̖hkí in Huḏíyo dívíwé̖ˀgeˀoˀ eeye. Hä̖ä̖wí wänbo kaaḏibo wóˀtú̖hpí. ");
INSERT INTO tew_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Heháaḏan nä́ˀi hä̖ä̖wí naa dítsikaˀmáa? In toˀwên dîntóyannin ovâytsikáyi̖ˀní háa dovâytu̖ˀannin. Indá dínhanginná háa otú̖ˀin.” ");
INSERT INTO tew_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus nä́ˀin natú̖ ihayḏi, wí méesatewi sundaḏo iwe núˀ nawindiḏi Jesus óetsꞌemapháve, heḏi óetu̖ˀan, “Haˀwâagá i owhaˀ pꞌóˀḏéḏîˀ wínâahéeˀa̖mípí.” ");
INSERT INTO tew_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus-di óetu̖ˀan, “Wên háawên híwó̖ˀpíˀin naa otú̖ḏáhoˀ, ú̖khâyˀä̖ˀ ovâytu̖ˀâ̖a̖míˀin hä̖ä̖wí namuuˀin. Hewänbo háa otú̖ waa in taˀgen namuu-ákun, heḏânho wíˀú̖kꞌóepí dítsꞌemapháve-íˀin.” ");
INSERT INTO tew_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Heḏáháˀ Annas natsonpóe Jesus nakhówhimuuḏi i owhaˀ pꞌóˀḏéḏîˀ Caiaphas-víˀpiyeˀ óesaaníḏí. ");
INSERT INTO tew_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Oe yáˀwé Peter waˀḏi nasúwáwin, heḏi in wé̖ˀgeˀin iwe diwinnindi óetsikáyin, “Ti u̖ wáˀ hä̖ˀi senbí khä̖ge̖ˀdibá wíˀunmuupíˀan?” “Yoe,” kin natú̖, “naa-á yoe.” ");
INSERT INTO tew_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wí sen i owhaˀ pꞌóˀḏéḏîˀví tꞌôeˀibá namuuˀiˀ iwe wáˀ nawin, i-á i sen Peter-di óeˀoyetsꞌâˀiví maatuˀiˀ ûnmuu, heḏi iḏi Peter óetsikáyin, “Ti Jesus-áḏí oe na-olive-taysaa iwe wíwímûˀpíˀan?” ");
INSERT INTO tew_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter wíyá natú̖ “yoe” gin, heḏi wesebo wí dee sen ikin. ");
INSERT INTO tew_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Waˀḏéeḏíbo naná, heḏi Jesus-á Caiaphas-víˀweḏi óehoˀ i Rome-wi tu̖u̖yônbí tewhá hayˀi iwepiyeˀ. In Huḏíyo nä́ˀi Rome-wi tu̖u̖yônbí tewhá ee wíḏitsꞌú̖hpí, gá inbí khuu dínmuuḏi dínkhâ̖a̖kꞌóeḏân ditsꞌú̖níˀin, heḏiho ditsꞌûndáhoˀ wíḏínˀä̖hpí nä́ˀi Passover shánkîˀḏi koegiˀ dâykꞌóe-íˀin. ");
INSERT INTO tew_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Heḏiho Pilate oe yáˀwépiyeˀ napee, heḏi in tꞌowa ovâytsikáyin, “Háawin tꞌehpiḏe-an nä́ˀi senbí̖ˀgeḏi dînmáˀ?” ");
INSERT INTO tew_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","In Huḏíyoḏi óetu̖ˀan, “Nä́ˀi sen wên tꞌaywó̖ˀnin iˀanpíḏá háˀto uvíˀpiyeˀ âymáˀíwän.” ");
INSERT INTO tew_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate-di ovâytu̖ˀan, “Un wíˀbo binpihûu iˀ, heḏá bintu̖yóˀnandi binˀan unbí tsontu̖u̖ úntû̖ˀ waagibá.” In Huḏíyoḏá óetu̖ˀan, “Hewänbo un Rome-ˀindá naˀin Huḏíyo wíḏînkꞌúya̖ˀpí wí toˀwí âyhéyíˀin, yä̖ˀḏâapí iˀandi âyshaa wänboˀ.” ");
INSERT INTO tew_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nä́ˀin ditú̖ˀ dihayḏi Jesus-ví híˀ háa nachuwagítꞌóe i̖ˀgeḏi taˀgen napee. ");
INSERT INTO tew_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate iví tu̖u̖yôn tewhá ee nawáytsꞌú̖, heḏi Jesus óetu̖kánnandi óetsikáyin, “Ti u̖-á in Huḏíyoví tsondi hayˀi-ân unmuu?” ");
INSERT INTO tew_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus-di óetsikáyin, “Ti u̖-ân wíˀbo unhanginˀândaˀ, háa in Huḏíyoḏi naví̖ˀgeḏi wóetu̖ˀandibo dítsikaˀmáa?” ");
INSERT INTO tew_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate-di óetu̖ˀan, “Ti naa-ân Huḏíyo omuu gin unˀánde gáhân? Uví tꞌowaḏibo heḏá in owhaˀ pꞌóˀḏéḏíˀindáḏí naví mange wóekán. Háawin tꞌaywó̖ˀninnan biˀan?” ");
INSERT INTO tew_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus-di óetu̖ˀan, “Naa tsondi hayˀiˀ omuu, hewänbo in nä́ä oepáa kꞌayḏiwin tsonnin waagá yoe. Ha̖ˀbi tsondi omuuḏáhoˀ in toˀwên dovâytsonmáaˀin dívíhä́nsaa-íwän naa in Huḏíyoví mange wíḏíkáanípíḏí. Hewänbo otú̖ waa, nä́äḏíwin tsonnin waagi wóˀmuupí.” ");
INSERT INTO tew_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate-di óetsikáyin, “Heḏáhoˀ, ti taˀgendi wí tsondi hayˀi-ân unmuu?” Jesus-di óetu̖ˀan, “U̖ˀbo untú̖ waa, ha̖ˀbiˀ omuu. Heḏi nä́ä oepáa kꞌayḏipiyeˀ oˀä̖ä̖ heḏá oˀaypu̖yä̖, in taˀgen namuu i̖ˀgeḏi dáyhéeˀa̖míḏí. Toˀwên in taˀgen ho dínhanginnáˀnindá naa dîntꞌóyandeˀ.” ");
INSERT INTO tew_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate-di óetsikáyin, “Hândiḏan toˀwí ûnhanginnání hä̖ä̖wí in taˀgen namuuˀin?” Pilate nä́ˀin natú̖ ihayḏi in Huḏíyo ee diyiˀ iwepiyeˀ nawáypeeḏi ovâytu̖ˀan, “Naaḏi wên tꞌaywó̖ˀnin nä́ˀi sen iˀannin wänbo wíḏônshaapí. ");
INSERT INTO tew_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hewänbo pa̖a̖yo pꞌóe waagi nä́ˀi Passover shánkîˀḏi nanáˀ dihayḏi undi dídaaˀoˀ wí pan wâymaˀpꞌä̖́ḏi-íḏí. Ti nää nä́ˀi Huḏíyoví tsondi hayˀi dómaˀpꞌä̖́ḏi-íˀin ídaˀ?” ");
INSERT INTO tew_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dívítu̖wí̖nú, “Hä̖ˀi-á yoe. Barabbas-ân gidaˀ nâamaˀpꞌä̖́ḏi-íˀin.” Barabbas-á sänbi namuu. ");
INSERT INTO tew_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Heḏiho Pilate natsonpóe waa in sundaḏoḏi Jesus óepiye heḏi púwhí̖ˀdí óewhä̖́hwhä̖́ˀnan. ");
INSERT INTO tew_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","In sundaḏo wên wä̖́ä̖khän dâyˀophíḏéˀandi óepꞌó̖htógi. Heḏáháˀ wên pꞌí tsá̖a̖wä̖́ˀin kꞌéwéˀin to-á óetógi, tsondi hayˀiví aa waagiˀinbá namuuˀin, ");
INSERT INTO tew_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","heḏi wí̖ˀín wí̖ˀíngin in sundaḏo iví páaḏépiyeˀ diphaḏemändi óeyanäkítu̖máa, “Hânnan unˀä́n, u̖ Huḏíyoví tsondi hayˀiˀ unmuuˀiˀ,” heḏá óetsꞌemapháve. ");
INSERT INTO tew_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate wíyá oe yáˀwépiyeˀ napeeḏi in tꞌowa ovâytu̖ˀan, “Bítꞌóyan, naaḏi i dópiyegítꞌóe undi bînmúníḏí, heḏânho únhanginnáníḏí naaḏi wên tꞌaywó̖ˀnin iˀannin wänbo wíḏônshaapíˀin.” ");
INSERT INTO tew_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Heḏiho Jesus oe yáˀwépiyeˀ óepiye. In wä̖́ä̖khän ônˀophíḏéˀannin napꞌó̖htoˀon, heḏá in pꞌí tsá̖a̖wä̖́ˀin kꞌéwéˀin to-á natoˀon. Heḏi Pilate-di in tꞌowa ovâytu̖ˀan, “Binmúˀḏí, nä́we i sen nawin.” ");
INSERT INTO tew_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","In owhaˀ pꞌóˀḏéḏíˀindáḏí heḏá in hayˀi méesateˀin sundaḏo-áḏí óemûˀ ihayḏi hä̖́yä́n wänbo dívítu̖wí̖nú, “Wên phéˀwan deeḏi nátꞌóhtä̖gekꞌuˀ.” Pilate-di ovâytu̖ˀan, “Unnân binhûu bîntꞌóhtä̖gekꞌúwíḏí. Naaḏá wên háawên tꞌaywó̖ˀnin iˀannin wänbo wíḏônshaapí.” ");
INSERT INTO tew_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","In Huḏíyoḏi Pilate óetu̖ˀan, “I-á natú̖ Yôesi Táḏáví ay namuuˀin, heḏi wên tsontu̖u̖ gínkꞌóeˀin natû̖ˀ, wí toˀwí kin ihéeˀoˀi-á nachúu-íˀin ûnkhâyˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilate nä́ˀi híˀ natꞌoe ihayḏi shánkí wänbo nakhuwôedaˀpóe, ");
INSERT INTO tew_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","heḏihoˀ iví tu̖u̖yôn tewhá ívepiyeˀ nawáytsꞌú̖, heḏi Jesus óetsikáyin, “Taˀgendi wä̖́hä̖̂ä̖wi-an unmuu?” Hewänbo Jesus-di háabo wíˀóetu̖ˀanpí. ");
INSERT INTO tew_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate-di oetsikáyin, “Ti wíḏíhéeˀa̖mípíˀan? Ti wíˀú̖hanginnáhpíˀan naaḏa̖ˀmân dînkꞌóe háa wímaˀpꞌä̖́ḏi-íˀin heḏiháa u̖ dovâymä̂äníˀin phéˀwan deeḏi wóetꞌóhtä̖gekꞌúwíḏí?” ");
INSERT INTO tew_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus-di óetu̖ˀan, “Yôesi Táḏáḏí wíwônkꞌûˀpíḏáho háˀto ú̖kuˀníwän háa wänbo naa díˀa̖míḏí. Heḏiho i sen uví mange naa díkándi-áho uví shánkí itꞌaywó̖ˀnan.” ");
INSERT INTO tew_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilate nä́ˀin natꞌoe ihayḏi shánkí wänbo nadaˀ Jesus óemaˀpꞌä̖́ḏi-íˀin, hewänbo in Huḏíyo dívítu̖wí̖nú, “Nä́ˀi sen nâamaˀpꞌä̖́ḏiḏá, u̖ i tsondi Caesar-víˀnäpiyeˀ wíˀunmuupí. Wí toˀwí wí tsondi hayˀi namuu gin natû̖ˀdi-á Caesar-ví hä́nbiˀ namuu.” ");
INSERT INTO tew_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Háa ditú̖ waa Pilate natꞌoe ihayḏi Jesus oe yáˀwépiyeˀ óepiye, heḏi in tꞌowa ovâytu̖yóˀdoˀ iwe Pilate isóge. Iwáho dâytu̖ˀo nakꞌuupháagíkwꞌó̖ˀ diwe gin, heḏi Hebrew tu̖u̖ḏáho “Gabbatha” gin dâytu̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Waˀḏi Passover shánkîˀḏi yâaḏi naná. Ihay thaa-á dâyhä̖ä̖wíkhâyˀo wíyá tháwä́ngîˀ, kaykhanwówá thaa nanáníˀiˀ. Nää taage iwáypiyeˀ naná. Pilate-di in Huḏíyo ovâytu̖ˀan, “Binmúˀḏí, nä́we unbí tsondi hayˀi únwin.” ");
INSERT INTO tew_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dívítu̖wí̖nú, “Nä́weḏi náyâaˀan, phéˀwan deeḏi nátꞌóhtä̖gekꞌuˀ.” Pilate-di ovâytsikáyin, “Ti unbí tsondi hayˀi wâytꞌóhtä̖gekꞌúwí?” In owhaˀ pꞌóˀḏéḏíˀindi óetu̖ˀan, “I-á naˀinbí tsondi hayˀi wígínmuupí. Naˀindá wîˀḏa̖ˀ tsondi hayˀi gínˀä́n, i-á Caesar-ân namuu.” ");
INSERT INTO tew_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Heḏiho Pilate-di Jesus inbí mange óeyoeˀan phéˀwan deeḏi óetꞌóhtä̖gekꞌúwíḏí. ");
INSERT INTO tew_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Heḏáháˀ Jesus óehoˀḏi iweḏi napee wên phéˀwan igíˀin ipiˀíhhondi, heḏi in okú “Pꞌó̖hkhú̖bay” gin dâytu̖ˀoˀ iwe dipówá, Hebrew tu̖u̖ḏá ditû̖ˀ “Golgotha” gin. ");
INSERT INTO tew_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Iweho in sundaḏoḏi Jesus in phéˀwan deeḏi óetꞌóhtä̖gekꞌûˀ, heḏá wáˀ wây-á wíye senäˀdá Jesus-ví wíˀnä́ kíngéḏí hanbá ovä̂nˀan, heḏi Jesus-ví phéˀwan pinuḏi ônkíḏi. ");
INSERT INTO tew_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate natsonpóe wên phépháˀ eeḏi nä́ˀi tu̖u̖ dâyta̖ˀnamí gin: “Nä́ˀi-á Jesus oe Nazareth-wi namuu, Huḏíyoví tsondi hayˀiˀ,” heḏi kin dâyta̖ˀnandi in phépháˀ-á ee phéˀwa̖ˀ kwꞌáye dâytꞌóhtä̖gekꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesus phéˀwan deeḏi óetꞌóhtä̖gekꞌûˀ iwe oe Jerusalem búuˀú tsoˀwa naná, heḏiho báyékí Huḏíyo iwe diyiˀ, heḏi in phépháˀ ee háa nata̖ˀmuuˀin dâytu̖u̖ˀan. Hebrew tu̖u̖ḏá, Latin tu̖u̖ḏá, heḏá Greek tu̖u̖ḏá nata̖ˀmuu. ");
INSERT INTO tew_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","In Huḏíyo owhaˀ pꞌóˀḏéḏíˀindi Pilate óetu̖ˀan, “Wíˀú̖khâyˀä̖hpí nâata̖ˀnamíˀin nä́ˀi híˀ ‘Huḏíyoví tsondi hayˀi’ gin, hewänbo kinnân nâata̖ˀnamí: ‘Nä́ˀi sennân natú̖, Naa in Huḏíyoví tsondi hayˀi omuu.’ ” ");
INSERT INTO tew_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate-di ovâytu̖ˀan, “Háa otsonpóe waa dâyta̖ˀnamíˀin wíḏóˀegókhâymáapí.” ");
INSERT INTO tew_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","In yôenu sundaḏoḏi Jesus phéˀwan deeḏi óetꞌóhtä̖gekꞌûˀ ihayḏi iví aa dívíwiye, heḏi piˀḏinbo wí̖ˀíngí dâyhógi. Hewänbo iví kꞌéwéˀin to heˀyinbo namuuḏi wáygé wänbo wíˀûnpänyeˀenpí. ");
INSERT INTO tew_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Heḏiho ditú̖, “Hä̖ˀin kꞌéwéˀin to-á wíˀâysíve-ípí, hewänbo ívíˀáywa̖mí âymúníḏí to-angú in natꞌanpúwíˀin.” Heḏi han dívíˀandi nä́ˀin Yôesi Táḏáví ta̖ˀnin diwe ho nata̖ˀmuuˀin napóe: Naví aa dívíwiyeḏi piˀḏinbo wí̖ˀíngí dâyhógi, heḏá naví kꞌéwéˀin togíˀin dívíˀáywan. ");
INSERT INTO tew_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesus-ví phéˀwan núˀ nä́ˀin yôenu kwiyä̖ˀ diwin: Jesus-ví yíyá-á, heḏá Jesus-ví yíyáví tíˀûu-á, heḏá Clopas-ví kwiyó Mary-á, heḏá Mary Magdalene-dá. ");
INSERT INTO tew_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus iví yíyá iwe nawindi imûˀ, heḏá iví khä̖ge̖ˀdiˀ iséegíˀi wáˀ imûˀ, heḏiho iví yíyá itu̖ˀan, “Yíyá, nää iweḏi hä̖ˀi sen uví ay waagiˀbá ú̖múní.” ");
INSERT INTO tew_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Heḏáháˀ iví khä̖ge̖ˀdiˀ itu̖ˀan, “Nä́ˀi-á uví yíyá waagiˀbá ú̖muu nää.” Heḏiho i khä̖ge̖ˀdiḏi iví wháagépiyeˀ Mary óehoˀ óeˀá̖yîngiˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus-áho ûnhanginná nä́ˀi tꞌä̖hkí iphaḏeˀin heḏânho háa Yôesi Táḏáví ta̖ˀnin diwe iví̖ˀgeḏi nata̖ˀmuu waagibá napúwíḏí. Ihayḏáháˀ natú̖, “Naa opꞌoesáˀaa.” ");
INSERT INTO tew_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Iwe núˀ wên sä̖ˀä̖́wé whoegiˀin naméenaˀoyohayˀisaaˀin nachá̖, heḏiho wên hä̖ä̖wên napꞌohsaaḏeeˀin i méena iwe dâypꞌohtógi, heḏi wên poesú hyssop kin dâytu̖ˀoˀ eeḏi dâytꞌiˀkꞌûˀḏi Jesus-ví sóe iwepiyeˀ ôntegeḏi, ");
INSERT INTO tew_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","i méena ipꞌohún. Ihayḏáháˀ natú̖, “Naví tꞌôe dînboˀwanhoˀ,” heḏi ipꞌó̖hwhayeḏiboˀ ipichuwamä́gi. ");
INSERT INTO tew_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","I thaa in Huḏíyo dâyhä̖ä̖wíkhâyˀoˀi kaykhanwówá thaagîˀ naná, heḏi nä́ˀi kaykhanwówá thaa naˀä̖ˀi shánkí hayˀi thaa dínmuuḏi wíḏidaˀpí in chuˀin ee phéˀwan deeḏi ovâyyoeˀa̖míˀin. Heḏiho Pilate óedaaˀan natsonpúwíḏí in ditꞌóhtä̖gekwꞌó̖ˀnin ovâypóthâaníˀin shánkí a̖ˀyu̖u̖gi dichúu-íḏí, heḏá phéˀwan deeyeḏá ovâywhá̖ve-í. ");
INSERT INTO tew_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Heḏihoˀ in sundaḏo dimääḏi in senäˀ Jesus-áḏíbá phéˀwan deeyebá ovä̂ntꞌóhtä̖gekꞌûˀin wí̖ˀgíndíboˀ ovä̂npótháa. ");
INSERT INTO tew_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hewänbo Jesus-víˀwe dipówáḏí óemûˀ ho nachuuˀin, heḏihoˀ iví pó wíˀôntháapí. ");
INSERT INTO tew_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wí sundaḏo iví yún phéḏí Jesus waˀmä́ägé óeyún, heḏi pꞌoe-áḏí ûndáḏí wónkí ûnpee. ");
INSERT INTO tew_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Kin napóeˀin naa nä́ˀin dóta̖ˀdoˀi dómûˀ, heḏiho i̖ˀgeḏiho dóta̖ˀdoˀ, heḏânho un wáˀ nä́ˀi hä̖ä̖wí úvíwhä̖yú̖-íḏí. Háa otû̖ˀ waa taˀgen namuu, naa dînhanginná in taˀgen otú̖ˀin.) ");
INSERT INTO tew_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Haˀwâa Jesus óeˀan dihayḏi nä́ˀi Yôesi Táḏáví ta̖ˀnin diwe nata̖ˀmuu waa napóe: Wéhpêe wänbo iví phéhkhú̖u̖ wíˀônthâanípí. ");
INSERT INTO tew_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Heḏá wáˀ wíyá wáygé Yôesi Táḏáví ta̖ˀnin diwe kinnân nata̖ˀmuu: In tꞌowaḏi i toˀwí óeyúndiˀ óemúní. ");
INSERT INTO tew_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Wí sen Joseph gin nakhá̖wä̖́ oe Arimathea búuˀúˀaywi namuu, heḏi Jesus-víˀpiyeˀ iwhä̖yundeˀ, hewänbo in Huḏíyoví pꞌóˀḏéḏíˀin ovâykhuwôedaˀḏi näähayḏi wínadaˀpí tꞌowa dínhanginnáníˀin iwhä̖yundeˀin. Jesus nachuu ihayḏi Joseph-di Pilate óedaaˀan i pení óekhuˀwamä̂äníḏí, heḏiho Pilate-di óemä́giḏi óehoˀ. ");
INSERT INTO tew_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Heḏá Nicodemus wáˀ napówá wí woe saˀwó̖ˀ nasu̖u̖ˀi tä̖gintä̖ (100) taa nakháaˀiˀ ikándí, nä́ˀi woe-á myrrh-áḏí aloe-áḏí nawóemuu. (Nicodemus-á hä̂nhay Jesus-víˀpiyeˀ khu̖ˀḏéeḏí namääˀi-ân namuu.) ");
INSERT INTO tew_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Joseph-áḏí Nicodemus-áḏí i pení óehoˀḏi híwó̖ˀdi aa tsꞌä̖ˀi iwe óeˀánnan i saˀwó̖ˀ nasu̖u̖ˀi woe wóegé. Kindiḏân in Huḏíyoḏi wí pení óekhä̖hkukhâymáaˀi óekhâyˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesus phéˀwan deeḏi óetꞌóhtä̖gekꞌûˀ iwáy tsoˀwa wáy wí navaˀay nataysaaˀi nakꞌóe, heḏi iwe wí khä̖hkugîˀ tꞌovápho tsꞌa̖a̖bi nachá̖, iwe toˀwí wänbo waˀḏi wíˀóekhä̖ˀkꞌûˀpí. ");
INSERT INTO tew_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Heḏiho tsoˀwabo nanândi, heḏá ihay tháwä́ndá in Huḏíyoví kaykhanwówá thaa dínnândi dívíkhâyˀa̖míˀin dínkhâyˀä̖ḏi, Jesus iwe óekhä̖ˀkꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dumîngu nanáˀ dihay thaa Mary Magdalene i tꞌovápho Jesus óekhä̖ˀkꞌûˀ iwepiyeˀ namää. Héˀḏéndí héˀḏibo waˀḏi nakhu̖u̖nândibo namää. Napówáḏí i kꞌuu pháagîˀ dâytꞌíḏiˀi wéhánäpiyeˀ nahângewindi imûˀ. ");
INSERT INTO tew_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Heḏiho Mary iweḏi iˀä̖ä̖ḏi Simon Peter-áḏí i wîˀ khä̖ge̖ˀdi Jesus-di óeséegíˀi-áḏi ovä̂nshaa, heḏi ovä̂ntu̖ˀan, “Naˀinbí Sedó Jesus i tꞌovápho iwe óeyâaˀan, heḏi wáygé óewáykꞌûˀin wígínhanginnáhpí.” ");
INSERT INTO tew_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Heḏiho Peter-áḏí i wîˀ khä̖ge̖ˀdi-áḏí Jerusalem búuˀúḏí dapeeḏi i tꞌovápho iwepiye damää dä̂nmúníḏí háa iwe nakꞌóeˀin háa yoe. ");
INSERT INTO tew_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wí̖ˀgíndíbo dänˀä̖ä̖hon, hewänbo i wîˀ khä̖ge̖ˀdi shánkí nasháaḏí Peter-ví páaḏé iˀä̖ä̖hondi páaḏébo napówá. ");
INSERT INTO tew_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Itꞌä̖́ä̖ itsíhkêeníḏí, heḏi i aa Jesus óeˀánnandiˀ oe íve nange nakwꞌôndi imûˀ, hewänboˀ ee tꞌovápho ee wínatsꞌú̖hpí. ");
INSERT INTO tew_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Iví tíˀúugé Simon Peter napówá, heḏi i-á ee tꞌovápho ívepiyeˀ natsꞌú̖, ");
INSERT INTO tew_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","heḏá i wáˀ i aa iwe nakwꞌôndi imûˀ, heḏá in aa Jesus napꞌó̖ˀánmuuˀindá wáˀ imûˀ. Nä́ˀindá naˀíhpaˀandi oe wéhánäpiyeˀ wíˀbo nakꞌóe, i wé̖ˀgeˀi aa-áḏá wínakꞌóepí. ");
INSERT INTO tew_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Heḏihoˀ i wîˀ khä̖ge̖ˀdi páaḏé napówáˀi wáˀ tꞌovápho ee natsꞌú̖, heḏi nä́ˀi aa nakwꞌôndihoˀ imûˀḏi Jesus nawáywówápóeˀin iwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Yôesi Táḏáví ta̖ˀnin diwe natû̖ˀ Jesus nawáywówápuwagítꞌóeˀin, hewänbo Jesus-ví khä̖ge̖ˀnin waˀḏi nä́ˀi hä̖ä̖wí i̖ˀgeḏi wíḏikaˀpóya̖ˀpí.) ");
INSERT INTO tew_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","In wíye khä̖ge̖ˀnindá inbíˀwepiyeˀ dänweehoˀ. ");
INSERT INTO tew_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary-á oe tꞌovápho iwe napówáḏí yáˀwébo naséewin, heḏi waˀḏi naséeyiḏi itꞌä̖́ä̖ḏí i tꞌovápho ívepiyeˀ itsíhkíḏi. ");
INSERT INTO tew_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Heḏi wíye makówáwin tꞌôepa̖ˀa̖a̖ˀin daˀaatsꞌä̖ˀimuuˀin Jesus nakꞌóewän diwe daˀä́ndí ovä̂nmûˀ, i wîˀ iví pꞌôn ûnkꞌóewän diwe naˀä́n, heḏi i wîˀ-á iví ân ûnkꞌóewän diwá. ");
INSERT INTO tew_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Indi Mary óetsikáyin, “Háaḏan unséeyiˀ?” Ovä̂ntu̖ˀan, “Gá naví tsondi dînpiyeḏân, heḏi wáygé óekꞌûˀin wíḏînhanginnáhpí.” ");
INSERT INTO tew_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kin natú̖ ihayḏibá ibée, heḏi Jesus iwe nawindi óemûˀ, hewänbo taˀgendi Jesus namuuˀin wíˀûnhanginnáhpí. ");
INSERT INTO tew_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus-di Mary óetsikáyin, “Háaḏan unséeyiˀ? To-an nâatu̖wä̖máa?” Mary-á naˀân Jesus-á i nava á̖yí̖ˀdi namuuˀin heḏihoˀ óetu̖ˀan, “Mä́ˀmä̂ä, wáygépiyeˀ nâahoˀḏáhoˀ, dítu̖ˀâ̖a̖mí wáygé nâakꞌûˀin heḏânhoˀ omú-í dókéyíḏí.” ");
INSERT INTO tew_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ihayḏi Jesus-di óekhá̖yä̖́ˀ, “Mary.” Mary-á wíyá ibéeḏí Jesus-vîˀḏi itsa̖a̖kíḏi heḏi óetu̖ˀan, “Rabboni.” (Rabboni-á Hebrew tu̖u̖ḏi natu̖ˀdaˀ “há̖hkandi” gin.) ");
INSERT INTO tew_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus-di óetu̖ˀan, “Navîˀḏi wívitsa̖a̖kêenípí, waˀḏi i Táḏávíˀpiyeˀ wóˀpeepíḏí. Hewänbo ópûn, in toˀwên naví tíˀûuwin páaḏéˀin waagiˀinbá dînmuuˀin ovâytu̖ˀan naví Táḏávíˀpiyeˀ omän, i-á unbí Táḏábáhoˀ únmuu, i-á naví Yôesi dînmuu heḏá unbí Yôesibá únmuu.” ");
INSERT INTO tew_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Heḏiho Mary Magdalene iweḏi namääḏi in khä̖ge̖ˀnin ovâytu̖ˀan, “Naˀinbí Sedó Jesus dómûˀ,” heḏi ovâytꞌôeˀan háa Jesus-di óetu̖ˀan waa. ");
INSERT INTO tew_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Waˀḏi Dumîngu naná, heḏi nakin dihayḏi Jesus-ví khä̖ge̖ˀnin wí tewhá íve diwé̖ˀgekwꞌó̖. In Huḏíyoví pꞌóˀḏéḏíˀin ovâykhuwôedaˀḏi tꞌä̖hkí i phóḏi dínphéhtiˀḏin. Ihayḏi Jesus inbí páaḏépiyeˀ nakeepóeḏí ovâytu̖ˀan, “Ánshaaginpíḏíboˀ íkwo̖ˀní.” ");
INSERT INTO tew_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kin natú̖ ihayḏi iví mandá heḏá iví waˀmä́ägé-á háa ûnmuuˀin ovâykeeyan heḏânho óetaa-íḏí. Iví khä̖ge̖ˀnin báyékí dihíhchanpóe Naˀinbí Sedó Jesus óemûˀḏi. ");
INSERT INTO tew_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Heḏáháˀ wíyá ovâyhéeˀandi ovâytu̖ˀan, “Ánshaaginpíḏíboˀ íkwo̖ˀní. Naaḏi naví tꞌôe dînˀa̖míḏí wâysankhâymáa, naví Táḏáḏí iví tꞌôe dônˀa̖míḏí dísan waagibá.” ");
INSERT INTO tew_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kin natú̖ ihayḏi iví hâ̖a̖ḏi ovâysiphayḏi, heḏi ovâytu̖ˀan, “I Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ unbí píˀnä́ khóˀyé úntsꞌú̖ní. ");
INSERT INTO tew_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Toˀwênbí tꞌaywó̖ˀdi dínˀowóˀyennin ítú̖ḏáhoˀ, ho dínˀowóˀyen. Hewänbo wíḏínˀowóˀyenpí gin ítú̖ḏáhoˀ, waˀ wíḏínˀowóˀyenpí.” ");
INSERT INTO tew_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Hewänbo wîˀ in tä̖ˀḏi wíye iweḏi in wé̖ˀgeˀindáḏí wínaˀä́npíwän Jesus dínpówá ihayḏi. Nä́ˀi khä̖ge̖ˀdi-á Thomas gin nakhá̖wä̖́, heḏi Kwâati wáˀ gin óetu̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Heḏihoˀ in wé̖ˀgeˀin khä̖ge̖ˀnindi Thomas óetu̖máa, “Naˀindá Naˀinbí Sedó Jesus âymûˀ.” Hewänbo Thomas natú̖, “Naaḏá i kwä̖́kꞌu ônkhä̖hkíḏi iwe dómûˀpíḏá, heḏi namanphohchân deeḏi naví mankhú̖ḏí dótä̖gepíḏá, heḏá oe waˀmä́ägé ûnphohchân diwe wáˀ naví mandi dótä̖gepíḏá, háˀto dáywhä̖yú̖-í nawówáyiˀin.” ");
INSERT INTO tew_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wí yâaḏi naphaḏe ihayḏi iví khä̖ge̖ˀnin tewhá íve wíyá dikwꞌó̖, heḏi Thomas-á indáḏí nää naˀä́n. Tꞌä̖hkí i phóḏi naphéhtiˀḏin, hewänbo Jesus inbí páaḏépiyeˀ nakwi̖nuḏeeḏi ovâytu̖ˀan, “Ánshaaginpíḏíboˀ íkwo̖ˀní.” ");
INSERT INTO tew_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Heḏi Jesus-di Thomas óetu̖ˀan, “Nä́we uví mankhú̖ḏí dítä̖gé-í. Naví man dînmúˀḏí. Ómankiˀ naví waˀmä́ägé iwe. Whä̖yu̖pîˀ wíyá wíˀunmúnípí, hewänbo biwhä̖yú̖-í-á.” ");
INSERT INTO tew_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas-di Jesus óetu̖ˀan, “U̖-ân naví tsondi dînmuu, naví Yôesi-á.” ");
INSERT INTO tew_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus-di óetu̖ˀan, “Ti näbáhaˀ biwhä̖yu̖ dímûˀḏi? Hewänbo in dívíwhä̖yundeˀindá shánkí dihíhcha̖a̖ tobá dímûˀpí wänboˀ.” ");
INSERT INTO tew_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus-ví khä̖ge̖ˀnindi báyékí wíyá pínnán tꞌôe iˀandiˀ óemûˀ, hewänbo nä́ˀin ta̖ˀnin deeḏá tꞌä̖hkí i pínnán tꞌôe iˀan niˀgeḏi wínata̖ˀmuupí. ");
INSERT INTO tew_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Hewänbo nä́ˀi híˀ-á nata̖ˀmuu heḏânho úvíwhä̖yú̖-íḏí Jesus-áho namuu i toˀwí Yôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, heḏá wáˀ úvíwhä̖yú̖-íḏí Yôesi Táḏáví ay-á namuu, heḏânho han úvíwhä̖yundeḏi in wówátsi nahándepíˀin imäˀin bînmáˀve-í. ");
INSERT INTO tew_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wí hä̖́yú̖ thaa naphaḏe ihayḏi, Jesus iví khä̖ge̖ˀninbíˀpiyeˀ wíyá ipikeeyan oe Tiberias pꞌoekwíngé. Kinnân napóe: ");
INSERT INTO tew_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nä́ˀinho wé̖ˀge diyiˀ: Simon Peter-á, Thomas-á (i-á Kwâati gin óetu̖ˀoˀ), heḏá Nathanael-á (i-á Galilee nangewi búuˀúˀay Cana gin dâytu̖ˀo iweˀi namuu), heḏá Zebedee-ví eˀnûndá, heḏá wây-á wíye Jesus-ví khä̖ge̖ˀnindáḏí. ");
INSERT INTO tew_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter-di in wé̖ˀgeˀin ovâytuˀan, “Naa opaapꞌokumän,” heḏi óetu̖ˀan, “Naˀin wáˀ u̖-áḏí gimän.” Heḏiho dimääḏi wí kophênbay iwe dívítógi, hewänbo khu̖u̖ tꞌä̖hkí wíḏiséegípóepí. ");
INSERT INTO tew_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nathayˀä̖ˀ ihayḏi Jesus oe pꞌoekwí̖ˀ kꞌáygé nawin, hewänbo iví khä̖ge̖ˀnindá wíḏínhanginnáhpí i namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Heḏi Jesus-ḏi ovâytsikáyin, “Kꞌemaˀin, ti hä̖́ä̖bo wíˀíséegípóepíˀan?” Óetu̖ˀan “yoe” gin. ");
INSERT INTO tew_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iḏi ovâytu̖ˀan, “Unbí paapꞌokuˀin hä̖ˀi kophênbay koˀḏínä́piyeˀ pꞌoe iwe bînchä̖nú-í, heḏi iwe bînhóní wên.” Heḏiho háa natú̖ waa dívíˀan, heḏi báyékí in ton paa dâywhahógiḏi wíḏínkoeḏipí in paapꞌokuˀin dâytegé-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","I khä̖ge̖ˀdi Jesus-di óeséegíˀiḏi Peter óetu̖ˀan, “I-á Naˀinbí Sedó Jesus namuu.” Simon Peter iví kꞌéwéˀin to napä̖ˀḏin itꞌôeˀa̖míḏí, heḏi nä́ˀin óetu̖ˀannin natꞌoe ihayḏi iwáytógikíḏí ipipꞌohkeˀtꞌáve oe pꞌoˀ kꞌáygépiye ikohsáy-íḏí. ");
INSERT INTO tew_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","I kophênbay pꞌoˀ kꞌáygéḏí kayi̖ˀ diwe wínaˀä́npí, maˀ háḏí poewintä̖ (30) kwiˀó̖hpa taa iwehayḏiḏa̖ˀ, heḏihoˀ in wé̖ˀgeˀin khä̖ge̖ˀnindá i kophênbay iweḏi eepiye dimää, in paapꞌokuˀin napaapiˀḏendi dâytä̖ä̖hondi. ");
INSERT INTO tew_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pꞌoˀ kꞌáygé dipówá ihayḏi i kophênbay iweḏi dipee, heḏi wí phaaˀuu phaa iwe dipaakhoˀkwꞌôndi dâymûˀ, heḏá wí pává-á nakhâykwꞌó̖. ");
INSERT INTO tew_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus-di ovâytu̖ˀan, “Binmáˀ wên paa hä̖ˀin bînwhahógiˀin diweḏi.” ");
INSERT INTO tew_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter i kophênbay iwe itógiḏi in paapꞌokuˀin oe pꞌoˀ kꞌáygé iwhaapiye. Tä̖gintä̖ḏáháˀ pꞌá̖nä́ntäˀḏi poeye (153) paa gáhä̖́ˀännin ditoˀon, hewänbo tobá báyékí dipaatoˀon wänboˀ in paapꞌokuˀindá wáyḏí wänbo wínasiˀvenpí. ");
INSERT INTO tew_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus-di ovâytu̖ˀan, “Bíkä̖ˀve, bíhéˀḏéndíhú̖u̖yan.” Tꞌä̖hkíḏíbo diwôedaˀ óetsikáyi̖ˀníḏí “To-an unmuu” gin, i-á Naˀinbí Sedó Jesus namuuˀin dínhanginnândi. ");
INSERT INTO tew_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Heḏi Jesus i húugîˀ nasaa iwepiyeˀ namääḏi i pává ihógi heḏi ovâymä́gi, heḏá i paa wáˀ ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","(Nää poewingîˀ Jesus iví khä̖ge̖ˀninbíˀpiyeˀ ipikeeyan nawáywówápóe iweḏi.) ");
INSERT INTO tew_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Dívíhúubowa ihayḏi Jesus-di Simon Peter óetsikáyin, “Simon, John-bí ay, ti u̖ḏi naa díséegí nä́ˀin wé̖ˀgeˀindiví shánkí?” Peter-di óetu̖ˀan, “Hoi, Naˀinbí Sedó, u̖-ân ú̖hanginná naaḏi wíséegíˀin.” Jesus-di óetu̖ˀan, “In tꞌowa naví kꞌúwáˀây waagiˀinbá dînmuuˀin ovâyhúuyôení.” ");
INSERT INTO tew_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wáygíngîˀ óetsikáyin, “Simon, John-bí ay, ti naa díséegí?” Peter-di óetu̖ˀan, “Hoi, Naˀinbí Sedó, u̖-ân ú̖hanginná wíséegíˀin.” Jesus-di óetu̖ˀan, “In tꞌowa naví kꞌúwá waagiˀinbá dînmuuˀin ovâyˀá̖yîngiˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Poewingíˀwe Jesus-di Peter óehéeˀandi óetsikáyin, “Simon, John-bí ay, ti naa díséegí?” Peter naháachanpóe nää poewingîˀ Jesus-di óetsikáyindi, “Ti naa díséegí” gin, heḏihoˀ óetu̖ˀan, “Naˀinbí Sedó, hä̖ä̖wí tꞌä̖hkí ú̖hanginná, naaḏi wíséegíˀin ú̖hanginná.” Jesus-di óetu̖ˀan, “In tꞌowa naví kꞌúwá waagiˀinbá dînmuuˀin ovâyhúuyôení. ");
INSERT INTO tew_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Taˀgendi wítu̖máa, shánkí tsꞌa̖a̖biˀ unmuu ihayḏi wíˀbo bipiˀawendeˀ heḏá biyíyéndeˀ wéngé undaˀ i̖ˀge tꞌä̖hkí. Hewänbo owáy unsedópaa ihayḏá bikhóhtä̖ä̖khâymáa heḏi wíyá toˀwíḏí wônwhiˀa̖mí heḏá wóepahkekhâymáa heḏá wáy unpundaˀpíˀwepiyeˀ wóehûuwí.” ");
INSERT INTO tew_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kin natú̖ḏího Jesus-di ônthaykꞌûˀ háawin chuwa ûnpuwagítꞌóeˀin, hewänbo nä́ˀin iví chuwa ûnmuuˀindá tꞌowa dínhanginnání Yôesi Táḏá hayˀi namuuˀin. Heḏá Peter óetu̖ˀan, “Naa-áḏí ókä̖ˀve.” ");
INSERT INTO tew_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter ibéeḏí i khä̖ge̖ˀdi Jesus-di óeséegíˀi dä́nwóeˀä̖ḏi óemûˀ. Hä̖̂ä̖ḏankánboˀ i khu̖u̖ dívíkindihúuyoˀ ihayḏi nä́ˀi-ânkun namuu i khä̖ge̖ˀdi Jesus-ví núˀ naˀä́ndí óetsikáyin, “Naˀinbí Sedó, wéˀi-an namuu i wóeku̖hpegítꞌóeˀiˀ?” ");
INSERT INTO tew_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Heḏi nää Peter-di i óemûˀḏi Jesus óetsikáyin, “Heyâa nä́ˀi sen, Naˀinbí Sedó?” ");
INSERT INTO tew_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus-di Peter óetu̖ˀan, “Owáy naa owáyˀä̖ä̖ píhay i nawówáyê̖e̖níˀin odaˀḏáhoˀ, naví á̖yîngi-ân dînmuu, uvîˀ-á yoe. U̖-ân naa-áḏí ókä̖ˀve.” ");
INSERT INTO tew_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Heḏi in Jesus-ví khä̖ge̖ˀnin ditû̖ˀ nä́ˀi khä̖ge̖ˀdi háˀto nachúu-íˀin. Hewänbo Jesus-á wínatú̖hpí i khä̖ge̖ˀdi wínachuwagítꞌóepíˀin, hewänbo nawänpitú̖-á, “Owáy naa owáyˀä̖ä̖ píhay i nawówáyê̖e̖níˀin odaˀḏáhoˀ, naví á̖yîngi-ân dînmuu, uvîˀ-á yoe.” ");
INSERT INTO tew_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nä́ˀi Jesus-ví khä̖ge̖ˀdi-ân namuu nä́ˀi hä̖ä̖wí ita̖ˀnandiˀ, heḏi ibá natû̖ˀ taˀgendi napóeˀin. Heḏi naˀin gínhanginná háa i natú̖ˀin in taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus wíyá báyékí hä̖ä̖wí iˀan nä́ˀin ta̖ˀnin diwe nata̖ˀmuupîˀ, heḏi hä̖ä̖wí tꞌä̖hkí i̖ˀgeḏi nata̖ˀmuuḏáhoˀ, oˀánde tꞌä̖hkí nä́ä oepáa kꞌayḏi háˀto nayâanáníˀin i ta̖ˀdi dâyta̖ˀnamíˀigîˀ.");
INSERT INTO tew_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","4","Kꞌema Theophilus, in páaḏéˀin taˀnin wîntaˀnannin diwe wítu̖ˀanpíˀan tꞌä̖hkí nä́ˀi hä̖ä̖wí Jesus-di in tꞌowa ovâyhá̖ˀandi heḏá iˀandi-á páaḏé itꞌôeˀan dihayḏi waabo oe makówápiye napee píhay. Nachuuḏáháˀ nawáywówápóe ihayḏi, iví tꞌôekhuwaˀin hä́ndíḏíbo ovâydeˀmanninbíˀpiye hä̖́yä́nbo ipikeeyan. Jónä́ntä̖ (40) thaa tꞌä̖hkí báyékí hä̖ä̖wí iˀan ovâykeeya̖míḏí taˀgendi wíyá nawáywówápóeˀin, heḏá Jôesi Táḏáví khuu i̖ˀgeḏi ovâytu̖máa. Napeepíḏíboˀ, waˀḏi indáḏí najiḏiboˀ iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ óekaymä́giḏi ovâytu̖ˀan, “Nä́ä Jerusalem-di wíˀípee-ípí. Naaḏi ho wâytu̖ˀan naví makówáwi Táḏá iví tun imä́gi wí toˀwí wovâysangíˀoˀin. Heḏiho nää úvítsíkhaˀa̖mí nä́ˀi naˀä̖ä̖ píhay. ");
INSERT INTO tew_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John iˀ pꞌóˀpꞌoekandiḏá ho wovâypꞌópˀpꞌoeˀan pꞌoeḏiḏa̖ˀ, hewänbo nää iweḏi báyékí thaa naphaḏepíḏíboˀ iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ bînkáyjí wí pꞌóˀpꞌoekan bînkêˀ waagibá.” ");
INSERT INTO tew_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","In Jesus-ví tꞌôekhuwaˀin i-áḏí diwéˀgejiˀindi óetsikaˀyan, “Nanbí Sedó, ti nää-ân ihayḏi naná untsondisogeḏee-íˀin heḏânho naˀin Israel-ˀin tꞌowa dímaˀpꞌä̖̂ä̖ḏi-íḏí in Rome-ˀinbíˀweḏi?” ");
INSERT INTO tew_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus-di ovâytu̖ˀan, “Wíwovâymä́gipí nä́ˀi hä̖ä̖wí i̖ˀgeḏi únhanginnáaníˀin. Naví Táḏáḏa̖ˀmân ûnkꞌóe ûnhanginnáaníˀin hä̖̂ä̖ḏi háa wéˀi thaa-á nä́ˀi hä̖ä̖wí napuwagíˀoˀin. ");
INSERT INTO tew_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hewänbo ginnân undá únpuwagíˀo: Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ únwá̖a̖ní heḏi ihayḏá in kay bînkaykhâymáa, heḏi tꞌowa tꞌä̖hkí naví̖ˀgeḏi bîntu̖ˀâ̖a̖mí nä́ä Jerusalem búˀ, heḏá tꞌä̖hkí Judea nange i̖ˀge Samaria nange i̖ˀgá, heḏá tꞌä̖mäpiye nä́ä oepáa kꞌayḏi i̖ˀge tꞌä̖hká.” ");
INSERT INTO tew_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jesus-di ovâyhíˀbowa ihayḏi, waˀḏi óemúndeḏibo makówápiye Jôesi Táḏáḏí óepiye, heḏi okhúwá jâa natsꞌûndi wíyá wíˀóemûˀpí. ");
INSERT INTO tew_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hewänbo waˀḏi kwꞌáyepiye napeemändi óemúndeˀ ihayḏiboˀ, tsíkhagipí wíje senäˀ waagiˀinbá dä́ncha̖a̖ˀin, tsꞌä̖ˀi daˀaamuuˀin, inbí hânge dakwi̖nuḏee. ");
INSERT INTO tew_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nä́ˀin wíjeḏi ovâytu̖ˀan, “Un Galileeˀin senäˀ, kwꞌáyepiye íbéesaaḏi wíˀíwe̖e̖nípí. Tobá Jesus makówápiye napee wänboˀ, iˀbo háa nää namääˀin bînmûˀ waagibá nawáyˀä̖ˀ.” ");
INSERT INTO tew_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Heḏiho Jesus-ví tꞌôekhuwaˀin okú kwꞌáyeḏi diwândi oe Jerusalem búˀpiye dimää. In okú-á “Olive okú” gin dâytu̖ˀoˀ, heḏi Jerusalem tsowa naná, maḏi píngé míyaḏa̖ˀ iweḏi. ");
INSERT INTO tew_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Oe Jerusalem dipówá ihayḏi iˀ tewhá ee dithaa iwe oe whaˀkꞌay ívepiye dipee. Ginnân dikhá̖wä̖́: Peter-á, John-dá, James-á, Andrew-á, Philip-á, Thomas-á, Bartholomew-á, Matthew-á, wíyá James-á (i-á Alpheus-ví ay ûnmuu), Simon-dá (i-á páaḏéḏí Zealot tꞌowa iwe natoˀonwän), heḏá Judas-á (i-á wíyá wêe James ginbá nakhá̖wä̖́ˀiví ay ûnmuu). ");
INSERT INTO tew_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nä́ˀin senäˀdá heḏá wên kwiyä̖ˀdá heḏá Jesus-ví jíyá Mary-á heḏá Jesus-ví tíˀûuwindáḏí hä̖́yä́nbo dívíwéˀgeˀoˀ dívíjûusuˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wí thaa in Jesus-víˀpiye dívíwä̖yundeˀin diwéˀgekwꞌó, maḏi tä̖gintä̖ḏáháˀ wétä̖ (120) ihay dijiˀ, heḏi Peter iwí̖nú ovâyhéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ovâytu̖ˀan, “Tíˀûuwin páaḏéˀin, hä́nˀoeboˀ iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi David óetu̖ˀan háa Judas Iscariot ûnpuwagíˀoˀin, heḏi David háa óetu̖ˀan waa itaˀnan. Heḏi nä́ˀin David itaˀnannindá ûnkhâyˀä̖ˀ napúuwíˀin. Judas-dân in tꞌowa ovâykeeyan wáygé Jesus najiˀin, indi óepankáyjíḏí. ");
INSERT INTO tew_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas-á nanbíˀweḏiˀiˀbá namuu, gá óedeˀmandân naˀin ívíˀoˀinbá iˀa̖míḏí” gin Peter-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Nä́ˀi Judas-á in Huḏíyo pꞌóˀḏéḏíˀindi óewáˀâa yä̖ˀḏâapí hä̖ä̖wí iˀa̖míḏí heḏáháˀ iˀ chä̖ˀ ihógiˀiˀḏi wí nava ônkumä, heḏi iwebá páaḏépiye nakeˀtꞌândi nange nawoe, heḏi nasihpândi iví see tꞌä̖hkí ûnpee. ");
INSERT INTO tew_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tꞌä̖hkí in tꞌowa Jerusalem dithaaˀin dínhanginpóe nä́ˀin ûnpóeˀin, heḏiho inbí tundi iˀ nava dâytu̖ˀoˀ “Akeldama” gin. Akeldama-á natundaˀ “nava naˀûnpꞌoechaˀḏee iwe” gin.) Heḏi gin wáˀ Peter natú̖, ");
INSERT INTO tew_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“In taˀnin Psalms diwe Judas-ví̖ˀgeḏi gin nataˀmuu: Iví wháagé ônjoeˀa̖mí, heḏi tóebo iwe háˀto ithaayé-í. Heḏá nä́ˀin wáˀ nataˀmuu: Wíyá toˀwíḏí iví tꞌôe ônˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Heḏânkun gínkhâyˀä̖ˀ wíyá sen âysôege-íˀin tꞌowa ovâytu̖ˀâ̖a̖míḏí Nanbí Sedó Jesus nawáywówápóeˀin, naˀindi âytu̖máa waagibá. Nakhâyˀä̖ˀ nä́ˀi âydeˀmamíˀi-á namúuníˀin wí toˀwí naˀindáḏíbá namääˀiˀ tꞌä̖hkí iˀ thaa waˀḏi Jesus naˀindáḏí najiˀ ihayḏiboˀ, John iˀ pꞌóˀpꞌoekandiḏi in tꞌowa ovâypꞌóˀpꞌoeˀoˀ ihayḏi waabo Jesus oe makówápiye napee píhay” gin Peter-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Heḏihoˀ in iwe dikwꞌóˀnindi wíje senäˀ ovä̂ndeˀman. Iˀ wêe Joseph Barsabbas gin nakhá̖wä̖́, Justus gin wáˀ óetu̖ˀoˀ, heḏá iˀ wêe-á Matthias-ân namuu. ");
INSERT INTO tew_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Heḏi ginnân dívíjûusuˀan: “Nanbí Sedó Jôesi Táa, u̖-á úhanginná tꞌowa tꞌä̖hkíví píˀnä́ khóˀjé háa diˀánshaamuuˀin. Judas uví tꞌôekhuwaˀiˀ úmuuwän, hewänbo iví tꞌôe ijoeˀandi in tuhchä̖nu ûnˀä̖ˀin ûnpóe. Nää naˀin dînkeeya̖mí wéˀi-an nä́ˀin wíje iweḏi âysôege-íḏí Judas-ví tꞌôe ônˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Heḏi wíje kꞌuˀây eeḏi in senäˀbí khá̖wä̖́ ovä̂ntaˀkꞌûˀ, heḏi wêe kꞌuu dâykêˀ Matthias-ví khá̖wä̖́ ûnkꞌóeˀiˀ. Heḏiho Matthias-á wí Jesus-ví tꞌôekhuwaˀi-á napóeḏí in wéˀgen tꞌôekhuwaˀindáḏíbá iwón. ");
INSERT INTO tew_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","In Huḏíyoví shánkíˀeeḏi thaa dínpówá, Pentecost gin dâytu̖ˀoˀ, heḏi tꞌä̖hkí in Jesus-víˀpiye dívíwä̖yundeˀin oe Jerusalem búˀ dijiˀin iˀ tewhá ee diwéˀgekwꞌo. ");
INSERT INTO tew_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tsíkhagipí hä̖ä̖wí ditꞌoe wí wa̖a̖ hânho kaygi waagibá makówáḏí nawândi, heḏi iˀ wa̖a̖ íve tꞌä̖hkí najiˀ. ");
INSERT INTO tew_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Heḏi báyékí phaˀây waagibá nakeetꞌóeˀi dâymûˀ, hänˀây waagibá namuuˀiˀ, heḏi nä́ˀi nawaḏeḏeeḏi wíˀínbo ovâytä̖ge. ");
INSERT INTO tew_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Heḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi dâymáaḏí ovâykhä̖geˀnan báyékí wíyá piˀwí tundi dínhíˀkoeḏí-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Oe Jerusalem báyékí Huḏíyo tꞌowa dithaa, báyékí nange eejeḏi dipówáˀin, indá Jôesi Táḏá óeˀaˀginmäˀin dimuu. ");
INSERT INTO tew_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nä́ˀin tꞌowa hä̖ä̖wí wí wa̖a̖ waagiˀbá namuuˀiˀ ditꞌoe ihayḏi, báyékí iˀ tewhá eepiye dimää. Wíḏínhanginnáhpí háa napoeˀoˀin, gá tꞌä̖hkí inbí tundi wíˀínbo dipitꞌoeḏân in Jesus-ví tꞌôekhuwaˀin dívíhíˀmáaḏí. ");
INSERT INTO tew_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Heḏiho ditꞌoeḏi hânho ovâyháaˀan, heḏi ditú̖, “Nä́ˀin tꞌowa dívíhíˀmáaˀindá, ti tꞌä̖hkí Galilee nangeˀinda̖ˀ wíḏimuupíˀan? ");
INSERT INTO tew_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Heḏi háaḏan handi nanbí nangeˀi híˀ dívíhíˀmáaḏí gitꞌoeˀo? ");
INSERT INTO tew_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Naˀindá Parthia-windá gimuu, heḏá Media-windá, Elam-windá, Mesopotamia-windá, Judea-windá, Cappadocia-windá, Pontus-windá, Asia-windá, Phrygia-windá, Pamphylia-windá, Egypt-windá, Crete-windá, Arabia-windá, heḏá Libya-windá oe Cyrene búˀ tsowa, heḏá wáy wên naˀindá Rome búˀḏá giˀáḏâapówá. Wáy wên naˀin Huḏíyo gimuu, heḏá wáy wêndá Huḏíyo gimuupí wänbo nä́ˀin Huḏíyoví khuu âyhon. Hewänbo tobá wä̖́hä̖̂ä̖win gimuu wänboˀ, nä́ˀin senäˀ nanbí tundi dívíhíˀmáaḏí gitꞌoeˀo, heḏi dítu̖máa iˀ báyékí heˀendi Jôesi Táḏá iˀan niˀgeḏi.” ");
INSERT INTO tew_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tꞌä̖hkí in tꞌowa ovâyháaˀandi wíḏínhanginnáhpí háa dívíˀánshaaˀa̖míˀin, heḏiho wíˀnä́ táye dívítsikaˀmáa, “Hânnangú napoeˀo nä́we?” ");
INSERT INTO tew_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Hewänbo wáy wêndi in Jesus-ví tꞌôekhuwaˀin ovâywänpipꞌâamáaḏí ditú̖, “Nä́ˀindá báyékí diméenamuu.” ");
INSERT INTO tew_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","In tä̖ˀḏi wíje (12) Jesus-ví tꞌôekhuwaˀin in tꞌowaví páaḏépiye dimää, heḏi Peter-di kaygi ovâytu̖ˀan, “Un tꞌowa naˀin waagin Huḏíyobá ímuuˀin, un kayi̖ˀ wä̖́hä̖̂ä̖ḏi íˀä̖ä̖ˀin heḏá nä́ä Jerusalem íthaaˀindá, nä́ˀi hä̖ä̖wí wâytu̖hkankhâymáaˀin naa odaˀ únhanginpúuwíˀin, heḏiho á̖yîngiḏi bítôeyanbe. ");
INSERT INTO tew_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Un íˀánde naˀin giháapoeˀo, hewänbo wígipoeˀopí, héḏéndí whä̖nu iwe natsꞌannândi. ");
INSERT INTO tew_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nä́ˀi hä̖ä̖wí nää bînmúndeˀi-á Jôesi Táḏáví tukheˀbi Joel hä́nˀoe natú̖ napuwagíˀoˀin. Ginnân itaˀnan: ");
INSERT INTO tew_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nanbí Sedó Jôesi Táḏá natú̖, ‘Iˀ tꞌä̖ˀgeˀi thaa púnúˀ napuwamän dihayḏi gin naa dáykhâymáa: Naví Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ khâ̖a̖gipíḏíbo dovâymä̂äní tꞌä̖hkí nangeˀin tꞌowa. Ihayḏá unbí ây dívíhéeˀa̖mí naví tukheˀmin waagibá, in eˀnûndá hä̖ä̖wí dovâykeeyandiˀ dâymúuní waagibá dínpúuwí, heḏá in saydôe-á inbí ä̖̂ä̖ iwebo-á dovâyhéeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Owáy iˀ thaa napówá ihayḏi tꞌä̖hkí in naagíˀin dívítꞌôemáaˀin naví Pꞌoewa̖a̖hâ̖a̖ khâ̖a̖gipíḏíbo dovâymä̂äní, kwiyä̖ˀdá senäˀdá iˀ dovâymä̂äní, heḏânho in wáˀ naví tukheˀmin waagibá dívíhéeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Heḏi makówá-á heḏá nä́ä oepáa kꞌayḏá i̖ˀge tꞌä̖hkí wí taa wâykeeya̖mí wovâyhá̖ˀa̖míˀiˀ: Ûnpꞌoe hä̖ä̖wí waagiˀbá bînpu̖wä̖khâymáa, heḏá phaa-á, heḏá e̖e̖yä̖ä̖ khunwi-á. ");
INSERT INTO tew_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Iˀ than nakhunpúuwí, heḏá iˀ pꞌóe-á pꞌîˀ-á napúuwí ûnpꞌoe waagibá. Nä́ˀi tꞌä̖hkí napuwagíˀo iˀ shánkí hayˀi thaa naa dódeˀmandiˀ napówápíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hebo toˀwên tꞌä̖hkí naa díkhá̖yä̖́ˀdeḏi díkhä̖geˀdaaˀannin dovâyˀaywoení,’ gin Jôesi Táḏáví híˀ ûnmuu Joel itaˀnandiˀ.” ");
INSERT INTO tew_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Heḏi Peter waˀḏi ihíˀmáaḏí natú̖, “Un tꞌowa Israel-win, bítꞌôeyan háa wâytu̖hkankhâymáaˀin. Jesus Nazareth-wi tꞌä̖mägeˀi pínnán tꞌôe iˀan. Jôesi Táḏáḏí Jesus in kay óemä́gi nä́ˀi hä̖ä̖wí iˀa̖míḏí heḏi handiḏi wovâykeeyan taˀgendi óesannin. Unbo únhanginná háa napóeˀin, hä̖ä̖wí Jesus iˀandi bînpimûˀḏi. ");
INSERT INTO tew_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Hä́nˀoebo Jôesi Táḏá iˀánshaamä́gi heḏá ûnhanginná háa ikhâymáaˀin, heḏiho Jesus-áho unbí mange wovâyjoeˀan, heḏi undá in toˀwên in tsontun dâyˀaˀginpíˀinbí mangá bînkán wên phéˀwin deeḏi óetꞌóhtä̖ä̖gé-íḏí, heḏânkun undi bînhay. ");
INSERT INTO tew_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hewänbo nä́ˀi tꞌôephaḏe iphaḏeˀiˀ nachuu ihayḏi Jôesi Táḏáḏí ônjâaˀan, heḏá óewáywówápaa, gá chuwa-á in kay wíˀimáapíḏân iˀ óetꞌaaníḏí. ");
INSERT INTO tew_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hä́nˀoebo Jesus-ví̖ˀgeḏi David itaˀnandi gin natú̖: Nanbí Sedó, naa dînhanginná u̖-á hä̂nhay wänbo tꞌä̖hkí naa-áḏí unjiˀin, naví páaḏépiyá naví koˀḏínäpiyá naa-áḏí unjiˀ, heḏânho kayˀindi dáywí̖núndeˀ ánshaaginpíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Heḏiho naví píˀnä́ khóˀjé ohíhchan, heḏi naví híhchan niˀgeḏi dáyhéeˀa̖mí. Tobá naví túˀ dînchuu wänboˀ, naa dînhanginná heḏá dótsíkhaˀmáa owáywówápúuwíˀin. ");
INSERT INTO tew_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Jôesi Táḏá, naa uví yä̖ˀḏâaˀi tꞌôeˀi omuuḏi u̖ˀḏi háˀto naví hâ̖a̖ dînjoeˀa̖mí in chuˀindáḏí, owáy ochuu ihayḏi háˀto naví túˀ dînsijemä̂äní. ");
INSERT INTO tew_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","U̖ˀḏá naa dînkeeyan in pꞌôe i̖ˀge dáyˀa̖htuyehûuwíˀin wówátsi donkáyjíḏí, heḏá naa-áḏí unjiḏi u̖ˀḏi báyékí díhíhchanmä̂äní, gin David itaˀnan Jesus-ví̖ˀgeḏi.” ");
INSERT INTO tew_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Heḏi Peter waˀḏi ihíˀmáaḏí natú̖, “Tíˀûuwin páaḏéˀin, nää thayˀeeḏi wâytu̖hkankhâymáa nanbí hehä̖̂ä̖wi thehtáy pahpâa David-ví̖ˀgeḏi háa ûnpóeˀin. I-á nachuu heḏá óekhä̖ˀkꞌûˀ, heḏi waˀḏi gínhanginná wáy nakhä̖ˀkꞌóe iwe, nä́wáy wáyḏí tsowa naná. ");
INSERT INTO tew_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David-á Jôesi Táḏáví tukheˀbi namuu, heḏi David ûnhanginná Jôesi Táḏá iví tun taˀgendi imä́giˀin iví thehtáy pahpáˀây iweḏi wí wêe ôntsondisogekhâymáaˀin, David natsondiˀä́n waagibá. ");
INSERT INTO tew_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Háa napuwagíˀoˀin David ho imûˀ waagibá napóe, heḏi ûnhanginná iˀ toˀwí Jôesi Táḏáḏí óesogekhâymáaˀiˀ tꞌowa ovâyˀaywoeníḏí nawáywówápuwagíˀoˀin, heḏiho David nä́ˀi toˀwíví̖ˀgeḏi ihéeˀandi natú̖, in chuˀindáḏí wíˀóejoekankhâymáapí, iví túˀ wänbo wíˀûnsijegíˀopí. ");
INSERT INTO tew_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","I toˀwí Jôesi Táḏáḏí óewáywówápaaˀi-á Jesus-ân namuu, heḏi naˀin iví tꞌôekhuwaˀin gimuuˀindiho âymûˀḏi gínhanginná nawáywówápóeˀin. ");
INSERT INTO tew_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jôesi Táḏáḏí Jesus-á makówápiye óepiyeḏi iví koˀḏíngéḏí óesóge. Jôesi Táḏá iví tun imä́gi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-á Jesus óemä̂äníḏí, heḏi háa natú̖ waa iˀan. Heḏiho iˀ hä̖ä̖wí nää nä́we ítꞌoeˀoˀiˀ heḏá bînmúndeˀi-á iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-ân iˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","David-á iví̖ˀgeḏi wíˀbo wíˀihíˀmáapí makówápiye napee-íˀin, hewänbo Jesus-ví̖ˀgeḏân ihíˀmáa. Ginnân David natú̖: Naví tsondi hayˀiˀ óetu̖ˀan Nanbí Sedó Jôesi Táḏáḏí, ‘Naví koˀḏíngéḏí ósoge, heḏi uví hä́nmindá dovâytꞌaaní heḏá uví mangá wînmáˀí.’ ");
INSERT INTO tew_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Un Israel tꞌowa tꞌä̖hkí únkhâyˀä̖ˀ nä́ˀin taˀgendi únhanginnáaníˀin: Tobá Jôesi Táḏá natú̖ wänbo Jesus-ân namuu iˀ shánkí natsonjiˀi-á heḏá iˀ toˀwí tꞌowa ovâyˀaywoeníḏí óesógeˀi-á, unḏá ídaˀpóe wên phéˀwin deeḏi óetꞌóhtä̖gekꞌúuwíˀin” gin Peter-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","In tꞌowa háa Peter-di ovâytu̖ˀan waa ditꞌoe ihayḏi píˀnä́ khóˀjé ditaachanpóe, heḏi indi Peter-á heḏá in wéˀgen Jesus-ví tꞌôekhuwaˀindá ovâytsikaˀyan, “Tíˀûuwin páaḏéˀin, hânnan nää gínkhâyˀä̖ˀ ívíˀa̖míˀin?” ");
INSERT INTO tew_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter-di ovâytu̖ˀan, “Un tꞌä̖hkí unbí tꞌaywóˀdi binjoeˀan heḏá ípꞌóˀpꞌoepúuwí bînkeeya̖míḏí Jesus Christ-víˀpiye úvíwä̖yundeˀin, heḏiho unbí tꞌaywóˀdi wovâyˀowóejé-íḏí, heḏá Jôesi Táḏáḏá nä́ˀi wovâypä̖gíˀoˀi bînkáyjí, i-á iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ namuu, ");
INSERT INTO tew_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","gá Jôesi Táḏá iví tun imä́giḏân iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-á ovâypä̖hkhâymáaˀin toˀwên tꞌä̖hkí ivíˀpiye ovâytu̖hkánkhâymáaˀin — undáḏí, unbí tíˀúugé kä̖ˀä̖ä̖ˀindáḏí, heḏá wéˀgen tꞌowa owáy kayi̖ˀ niˀgeḏi dithaaˀindáḏí.” ");
INSERT INTO tew_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Báyékí wíyá ha̖ˀbibá Peter-di kayˀindi ovâytu̖ˀan, heḏá háa dívíˀa̖míˀin ovâytumakheˀandi ovâytu̖ˀan: “Úntáy wovâyˀaywoeníˀin heḏânho wíwovâytuhchä̖ä̖nú-ípíḏí nä́ˀin híwóhpíˀin tꞌowa nä́we dithaaˀin ovâytuhchä̖nukhâymáa waagibá.” ");
INSERT INTO tew_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nä́ˀin tꞌowa Peter-ví híˀ dâysígíkêˀin ovâypꞌóˀpꞌoeˀan, heḏi iˀ thaa maḏi poje maapaasôn (3,000) wây-á tꞌowa in wéˀgen ho dívíwä̖yu̖ˀindáḏí dívíwón. ");
INSERT INTO tew_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Heḏi ginnân dívíkanhon: In Jesus-ví tꞌôekhuwaˀinbí há̖hkan tꞌä̖hkí dâytꞌôeyandeḏá dâysígíhóndeˀ, heḏá in wéˀgen dívíwä̖yu̖ˀindáḏí híhchandi dívíwéˀgeˀoˀ, heḏá wéˀgá dívíhúujoḏá dívíjûusuˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jôesi Táḏáḏí in Jesus-ví tꞌôekhuwaˀin ovâykhä̖geˀnan báyékí tꞌä̖mägeˀi pínnán tꞌôe dâyˀa̖míḏí, heḏiho in tꞌowa nä́ˀi hä̖ä̖wí dâymúndeḏi ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tꞌä̖hkí in Jesus-víˀpiye dívíwä̖yu̖ˀin wêe kꞌaygiˀinda̖ˀ waagiˀinbá dimuu, heḏá hä̖ä̖wí tꞌä̖hkí dínkwꞌóˀdi-á dívíwijendeˀ. ");
INSERT INTO tew_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Hä̖̂ä̖ḏi inbí tewhá-á nava-á heḏá wíyá hä̖ä̖wí dínkwꞌóˀdi-á dâyku̖ˀchꞌáa ginhay-á, in díntáyˀindáḏí iˀ chä̖ˀ dâyhógiˀi dívíwijendeˀ. ");
INSERT INTO tew_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Thamu waa iˀ méesate hayˀiˀ iwe dívíwéˀgeˀoˀ, heḏi wí thaa wí toˀwívíˀwe dívíhúujoˀ, wíyá thaa-á wíyá toˀwívíˀwá. Híhchandá khâ̖a̖gipíḏíbo-á wéˀge dívíhúujoˀ. ");
INSERT INTO tew_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ihayḏa̖ˀ ditû̖ˀ Jôesi Táḏá-á hânho híwóˀdi namuu, heḏi tꞌä̖hkí in wéˀgen tꞌowa inbíˀpiye híwó dicha̖a̖. Thamu waa Nanbí Sedó Jôesi Táḏáḏí wây-á shánkí báyékí tꞌowa ovâyˀaywondeˀ, heḏânho shánkí ditꞌowasôemän. ");
INSERT INTO tew_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wí thaa Peter-áḏí John-dáḏí iˀ Huḏíyoví méesate hayˀi eepiye damää. Thamuwaa thíˀêeḏi poje iwe in tꞌowa dívíjûusuˀoˀ, heḏi ihayḏibá dapówá. ");
INSERT INTO tew_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","In méesate phóḏi, “Saˀwóˀnin Phóḏi” gin dâytu̖ˀoˀ iwe wí sen naˀä́n. Nä́ˀi sendá iví wówátsi thaa tꞌä̖hkí naˀaypu̖yä̖ ihayḏi waabo wûntsiˀkoḏipí, heḏi iví kꞌemaˀindi in méesate phóḏi eepiye thamuwaa óemáyä̖ˀ, in tꞌowa ditsuḏemännin ovâychä̖ˀdaaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Peter-á John-dá iˀ méesate eepiye datsuḏemändi iˀ sendi ovä̂nmûˀ, heḏi ovä̂nchä̖ˀdaaˀan. ");
INSERT INTO tew_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Indi taˀgebo óemúndeḏi Peter-di óetu̖ˀan, “Hîn naˀin dímúˀḏí.” ");
INSERT INTO tew_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iˀ sen inbíˀpiye ibéeḏí itsíkhaˀan hä̖ä̖wí óemä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hebo Peter-di óetu̖ˀan, “Chä̖ˀ wänbo wíḏómáapí, hewänbo hä̖ä̖wí dómáaˀiˀá wípä̖gíˀo. Jesus Christ Nazareth-wiḏi dînkꞌûˀ wítu̖ˀâ̖a̖míḏí, ówí̖núḏí ójíyé.” ");
INSERT INTO tew_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Heḏi Peter-di iˀ senbí koˀḏíngéḏíˀin man ônyâ̖ˀḏi óekwi̖nukhä̖geˀnan. Wesebo iví ândá á̖nä́pêndá ûnkaypóe. ");
INSERT INTO tew_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","9","Kwꞌáyepiye ichä̖nuḏi iwí̖nú, heḏi wesebo natsiˀḏee, heḏi in wíje-áḏí iˀ méesate eepiye ditsꞌú̖. Ee íve oepiyá nä́äpiyá najiˀ heḏá ichä̖numáa, heḏi natû̖ˀ Jôesi Táḏá-á hânho hayˀi namuuˀin. In tꞌowa tꞌä̖hkí ee dijiˀindi iˀ óemûˀ, heḏá háa natû̖ˀnindá ditꞌoe. ");
INSERT INTO tew_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Heḏi óemûˀḏi óetaa toˀ namuuˀin — nä́ˀi-ânkun in saˀwóˀnin méesate phóḏi iwe ichä̖ˀdaˀsógéndeˀi namuu. Heḏiho nää nawówaḏi hânho báyékí ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Iˀ sen Peter-áḏí John-dáḏí inbîˀḏi natsa̖a̖chá owáy iˀ méesate pohtâa iwe diwin diwe. (Nä́ˀi pohtâa-á “Solomon-bí pohtâa” gin dâytu̖ˀoˀ.) In tꞌowa tꞌä̖hkí hânho ovâyháaˀandi in poje senäˀbíˀpiye dívíwä̖́nähoˀ. ");
INSERT INTO tew_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Háa dívíˀoˀin Peter imûˀ ihayḏi ovâytu̖ˀan, “Un tꞌowa Israel-win, háaḏan wovâyháaˀan nä́ˀi sen nawówaḏi, heḏi háaḏan naˀin díḏamúndeˀ? Ti íˀándeˀ nä́ˀi sen ônhehkháaˀannin naˀinnân kay ä́nmáaḏíboˀ, heḏiháa Jôesi Táḏá ä́nwänpiˀaˀgindiboˀ? Handá wínapóepí. ");
INSERT INTO tew_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham-dá, Isaac-á, heḏá Jacob-á, nanbí hehä̖̂ä̖win thehtáy pahpáˀin gínmuuˀindi Jôesi Táḏá óeˀaˀginmä́gi, heḏi i-ânkun iví ay Jesus shánkí kwꞌáye isóge. Nä́ˀi Jesus-bá undi in tsonninbí mange bînkán, heḏi Pilate-di óemahpä̖ḏikhâymáawän, hebo undá wíˀíhíjepí. ");
INSERT INTO tew_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesus-á yä̖ˀḏâaˀiḏa̖ˀ namuu heḏá iví wówátsi taˀge ihon, hewänbo undi bînjoegiˀandi Pilate bîndaaˀan wí toˀwí tꞌowa tꞌakha̖nuˀi namuuˀiˀ óemaˀpꞌä̖̂ä̖ḏi-íḏí, heḏá Jesus iˀ nawówátsipä̖jiˀi namuuˀi-á bînhay. ");
INSERT INTO tew_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hewänbo Jôesi Táḏáḏí iˀ óewáywówápaa, heḏi naˀindiboˀ iˀ wíyá nawówájiḏi âypimûˀ. ");
INSERT INTO tew_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Naˀin Jesus-víˀpiye änwä̖yundeˀ, heḏi iˀḏânkun nä́ˀi sen nä́we bînmúndeˀi heḏá bîntaaˀiˀ óekaymä́gi. Jesus-di in wä̖yu̖ dímä́giḏi nä́ˀi sen unbí páaḏépiye nahehkháapóe. ");
INSERT INTO tew_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Heḏiho nää gin wâytu̖hkankhâymáa, tíˀûuwin páaḏéˀin: Naa dînhanginná undá heḏá unbí tsonnindá úvíˀannin háa Jesus bînˀan waa wíˀúnhanginnáhpíḏí taˀgendi toˀwí namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Hä́nˀoebo Jôesi Táḏá iví tukheˀmin itu̖ˀan nä́ˀi hä̖ä̖wí háa napuwagíˀoˀin, heḏiho indá dâytaˀnan iˀ toˀwí iˀḏi óesogekhâymáaˀi tꞌowa ovâyˀaywoeníḏí itꞌôephaḏekhâymáaˀin. Háa Jôesi Táḏá natú̖ waa napóe. ");
INSERT INTO tew_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Heḏiho nää unbí tꞌaywóˀdi binjoeˀandi Jôesi Táḏávíˀpiye bípimä́ä, ihayḏá iˀḏi unbí tꞌaywóˀdi únmuuˀi wovâyjâaˀa̖mí, heḏânho shánkí híwóˀdi híhchandi wówátsi thaa Nanbí Sedóḏí wovâymä̂äní, ");
INSERT INTO tew_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","heḏá wáˀ Jesus unbíˀpiye wovâywáysaaní, i-ân iˀ namuu Jôesi Táḏáḏí óedeˀmandiˀ tꞌowaví aywondiˀ óesôege-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hewänbo Jesus-á oe makówá wä̖́hä̖̂ä̖ nachangíˀo owáy Jôesi Táḏá hä̖ä̖wí tꞌä̖hkí tsꞌa̖a̖biˀ iwáypaˀíḏí nakhâymuupíhay. Hä́nˀoebo Jôesi Táḏáḏí iví yä̖ˀḏâaˀin tukheˀminbí sóphogeḏi dítu̖ˀan gin ikhâymáaˀin. ");
INSERT INTO tew_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Heḏiho Moses-di nanbí hehä̖̂ä̖win thehtáy pahpáˀin ginnân ovâytu̖ˀan: Nanbí Sedó Jôesi Táḏáḏí wí tukheˀbiˀ unbí tꞌowa iweḏiˀiˀbo namuuˀi wovâysangíˀo, naa dísan waagibá, Undá tꞌä̖hkí iˀḏi wovâytu̖hkankhâymáaˀi bînˀaˀginnamí, ");
INSERT INTO tew_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","heḏi wí toˀwí iví híˀ ôntꞌôeyanpíḏí, i-áho iví tꞌowa iweḏi óeweejé-í heḏá óeháyjí. ");
INSERT INTO tew_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Samuel wáˀ, heḏá tꞌä̖hkí in wéˀgen Jôesi Táḏáví tukheˀmin Samuel-ví wówátsi thaa iweḏi páaḏépiye diwówájiˀindá, indi dítꞌôeˀan háa nää nä́ˀi thaa eeje napuwagíˀoˀin. ");
INSERT INTO tew_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hewänbo háa in Jôesi Táḏáví tukheˀmin ditú̖ waa ungîˀ-ânkun ditú̖, heḏá háa Jôesi Táḏá unbí páaḏé kä̖ˀä̖ä̖ˀindáḏí iwéhpêeˀan waa, undáḏí wáˀ inbá iwéhpêeˀan. Ginnân Abraham óetu̖ˀan: Wí uví ây iweḏiˀi namuuˀiˀḏi tꞌowa tꞌä̖hkí nä́ä oepáa kꞌayḏi dikwꞌóˀnin ovâyhíwóˀnamí. ");
INSERT INTO tew_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Heḏiho Jôesi Táḏáḏí Jesus-á óedeˀman iví tꞌôeˀi namúuníḏí, heḏi unbíˀpiye páaḏé óesan wovâyhíwóˀnamíḏí unbí tꞌaywóˀdi únmuu iweḏi wovâyjâaˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Waˀḏi Peter-áḏí John-dáḏí in tꞌowa dä̂nhíˀmáa ihayḏi, wên Huḏíyo owhaˀ-á Sadducee tꞌowa-á heḏá iˀ méesate á̖yí̖ˀdi sundaḏo pꞌóˀḏéḏîˀ-áḏí in dawin diwepiye dimää. ");
INSERT INTO tew_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Háa in wíjeḏi in tꞌowa ovâyhá̖ˀoˀin wíˀovâyhí̖ˀanpí, gá Jesus nawáywówápóe i̖ˀgeḏi ovâytu̖máaḏân, heḏi nä́ˀi natundaˀ wéˀgen tꞌowa ho dichuuˀin wáˀ diwáywówápuwagíˀo. ");
INSERT INTO tew_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Heḏiho ovä̂npansóge, heḏi kindi nanândiho wíyá tháwä́n puwahayḏi pan tewhá eeboˀ ovä̂njoeˀan. ");
INSERT INTO tew_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Hewänbo báyékí tꞌowa inbí híˀ ditꞌoeˀin Jesus-víˀpiye dívíwä̖yu̖, heḏi nää tꞌä̖hkí in tꞌowa dívíwä̖yu̖ˀin diweḏibo háḏée maˀ pꞌánú maapaasôn (5,000) ihay dijiˀ in senäˀda̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wíyá tháwä́n in Huḏíyo pꞌóˀḏéḏíˀindá in tsonnindá heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá tꞌä̖hkíḏíbo ee Jerusalem dívíwéˀgeˀan. ");
INSERT INTO tew_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas iˀ owhaˀ pꞌóˀḏéḏîˀ namuuˀiˀ iwebá naˀä́n, heḏá Caiaphas-á, heḏá wíyá sen John ginbá nakhá̖wä̖́ˀi-á, Alexander-á, heḏá wây-á Annas-ví maatu tꞌowaˀindá dikwꞌó. ");
INSERT INTO tew_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Peter-á John-dá ovä̂ntsꞌúḏe in tꞌowaví páaḏépiye ovä̂nwé̖e̖nú-íḏí, heḏi ovä̂ntsikaˀyan, “Toˀḏan in kay wovä̂nmä́gi nä́ˀi sen hehkháa dä̂nmä̂äníḏí? Toˀḏan wovä̂nkꞌûˀ han dä̂nˀa̖míḏí?” ");
INSERT INTO tew_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Heḏi Peter pín taˀgeḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ imáaḏí ovâytu̖ˀan, “Un Huḏíyo pꞌóˀḏéḏíˀindáḏí tsonnindáḏí, ");
INSERT INTO tew_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nää thaa undi dítsikaˀmáa wên háawin híwóˀnin háa wí sen nahaywän ûnpóe i̖ˀgeḏi, heḏá háḏíḏí ûnhehkháapóeˀindá. ");
INSERT INTO tew_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Heḏânho un tꞌowa tꞌä̖hkí heḏá tꞌä̖hkí in wéˀgen Israel-ˀindá únkhâyˀä̖ˀ nä́ˀin únhanginpúuwíˀin: Jesus Christ oe Nazareth-wiḏi naˀin dînkꞌûˀ nä́ˀi sen unbí páaḏépiye nawindiˀ ä́nhehkháaˀa̖míḏí. Heḏi Jesus-bá phéˀwin deeḏi bîntꞌóhtä̖gekꞌûˀ, hewänbo Jôesi Táḏáḏí óewáywówápaa. ");
INSERT INTO tew_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesus-ví̖ˀgeḏi ginnân nataˀmuu: I-ânkun wí kꞌuu waagiˀbá namuu heḏi undá tewhátehpaaˀin waaginbá-á ímuu. Heḏi tobá bînjoegiˀan wänboˀ i-á iˀ kꞌuu shánkí natáyˀi waagibá napóe tehpaa béˀḏí. ");
INSERT INTO tew_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iˀḏa̖ˀmân ûnkoḏi tꞌowa ovâyˀaywoeníḏí. Nä́ä oepáa kꞌayḏi tꞌä̖hkí wíyá toˀwí wänbo wíˀônkꞌûˀpí dînˀaywoeníḏí, nä́ˀi Jesus gin nakhá̖wä̖́ˀiḏa̖ˀmân” gin Peter-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","In Huḏíyoví pꞌóˀḏéḏíˀin ovâyháaˀan Peter-áḏí John-dáḏí wôedaˀginpíḏíbo dänhéeˀandi ditꞌoeḏi, dínhanginnândi nä́ˀin wíjeḏá tꞌowa heˀennin háa taˀdihá̖ˀin wíḏamuupíˀin. Heḏi ihayḏi dínˀánpówá Jesus-áḏí dänjíyéndeˀin damuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Heḏi iˀ sen ônhehkháaˀandiˀ iwebá nawindi dâymûˀḏiho wíyá háa wänbo wíḏínkꞌóepí ovä̂ntu̖ˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Heḏiho ovä̂ntu̖ˀan in tunjowaˀ diwéˀgekwꞌóˀ diweḏi jáˀwépiye dapee-íˀin wíˀbo dívíhéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Heḏi wíˀnä́ táye dívítsikaˀyan, “Hânnan nä́ˀin senäˀ âyˀa̖mí? Báyékí in tꞌowa nä́ä Jerusalem-ˀin dínhanginná nä́ˀin pínnán tꞌôe hayˀin dä̂nˀannin, heḏiho naˀindá wígínkoḏipí gitú̖u̖níḏí wíḏä̂nˀanpíˀin. ");
INSERT INTO tew_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nää nä́ˀin wíje senäˀ âytu̖ˀâ̖a̖mí Jesus-ví̖ˀgeḏi wíyá dänhéeˀandáho âytuhchä̖nukhâymáa, heḏânho wây-á shánkí tꞌowa nä́ˀi hä̖ä̖wí i̖ˀgeḏi wíḏitꞌoe-ípíḏí.” ");
INSERT INTO tew_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Heḏiho wíyá ovä̂ntsuḏejôndi ovä̂ntu̖ˀan wíyá wänbo Jesus-ví̖ˀgeḏi wíḏänhéeˀa̖mípí heḏá wíḏä̂nhá̖ˀa̖mípí. ");
INSERT INTO tew_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Hewänbo Peter-áḏí John-dáḏí ovâytu̖ˀan, “Wéˀinnan ä́nˀa̖mí? Ti undi dítu̖ˀan waa háa Jôesi Táḏáḏí dítu̖ˀan waa naˀin ä́nˀaˀginnamí? Undá únkhâyˀä̖ˀ úvíˀánshaaˀa̖míˀin wéˀinnan Jôesi Táḏá natú̖u̖níˀin shánkí híwóˀnin namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Hebo naˀindá wígä́nkoḏipí hânda̖ˀdibo gachaníḏí. Gä́nkhâyˀä̖ˀ tꞌowa ä́ntu̖ˀâ̖a̖míˀin háa ä́nmûˀindá gatꞌoeˀindá.” ");
INSERT INTO tew_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Heḏáháˀ in Huḏíyo pꞌóˀḏéḏíˀindi shánkí kayˀindi ovä̂ntu̖ˀan ovä̂ntuhchä̖nukhâymáaˀin, hewänbo ovä̂nmaˀpꞌä̖́ḏi. Wên tꞌaywóˀnin wänbo ovä̂ntuhchä̖ä̖nú-íˀin wíˀovä̂nshaapí, heḏi ovä̂ntuhchä̖nuḏáho in tꞌowa háˀto ovâyhí̖ˀa̖mí. In tꞌowaḏi Jôesi Táḏá kwꞌáayéboˀ óemáa, iví pínnándí nä́ˀi sen ûnhehkháapóeḏí. Iˀ sendá jónä́ntä̖ (40) pa̖a̖yoˀiví shánkîˀ namuu. ");
INSERT INTO tew_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ovä̂nmaˀpꞌä̖́ḏi ihayḏi wesebo Peter-á John-dá inbí kꞌemaˀinbíˀpiye damää, heḏi ovâytu̖ˀan háa in Huḏíyo owhaˀ pꞌóˀḏéḏíˀin heḏá in tsonnin ditú̖ˀin tꞌä̖hkí. ");
INSERT INTO tew_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Inbí kꞌemaˀin nä́ˀin ditꞌoe ihayḏi Jôesi Táḏávíˀpiye tꞌä̖hkíḏíbo ginnân dívíjûusuˀan: “Nanbí Sedó Jôesi Táa, u̖-ân hä̖ä̖wí tꞌä̖hkí nâakhíjé. Makówá-á, nä́ä oepáa kꞌayḏi i̖ˀgá, mâapꞌoe-á, heḏá hä̖ä̖ tꞌä̖hkí iwe nasaaˀi-á nakwꞌóˀdi-á dijiˀi-á nâakhíjé. ");
INSERT INTO tew_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Hä́nˀoeboˀ iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi naˀin díhéeˀan nanbí hehä̖̂ä̖wi thehtáy pahpâa David-ví sóphogeḏi. I-á uví tꞌôeˀi úmuu, heḏi ginnân itaˀnan: Háaḏan in Huḏíyo dimuupíˀin dívítꞌayjaaˀoˀ? Háaḏan in Huḏíyo dimuuˀin hä̖ä̖wí nachä̖ˀmuupí i̖ˀgeḏi dívíˀánshaamáa? In tsonnin tꞌä̖hkí nangewin dívítꞌaywí̖nú, heḏi dívíwéˀgeˀan dívíhä́nsaˀíḏí Nanbí Sedó Jôesi Táḏávíˀpiye heḏá iˀ toˀwívíˀpiyá iˀḏi óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Heḏiho taˀgendi han napóe. Nä́ˀi búˀ iwe Herod-á Pontius Pilate-á in Huḏíyo dimuupíˀindá heḏá in Huḏíyo-áḏí tꞌä̖hkí dívíwéˀgeˀan uví yä̖ˀḏâaˀi tꞌôeˀi Jesus óehä́nmamíḏí, i-á u̖ˀḏi nâasóge tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","U̖-á báyékí hangintandá kay-á mänmáaḏí untú̖ nä́ˀi tꞌä̖hkí ûnkhâyˀä̖ˀ napúuwíˀin, heḏi tꞌä̖hkí háa untú̖ waa napóe. ");
INSERT INTO tew_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nanbí Sedó Jôesi Táa, nää-á inbí híˀ háa ditû̖ˀnin ótꞌôeyanbe. Ditû̖ˀ indi jänäkí naˀin díkhâymáaˀin, hewänbo naˀin uví tꞌôeˀin gimuuḏi u̖ˀḏá kay dímä̂äní uví híˀ khunwôedaˀginpíḏíbo wînhéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wídaˀmáa tꞌowa ovâykeeya̖míˀin in kay úkꞌóeˀin ovâyhehkháaˀa̖míḏí, heḏá ovâykeeya̖mí uví yä̖ˀḏâaˀi tꞌôeˀi Jesus-ví kayḏi tꞌä̖mägeˀi pínnán tꞌôe-á nakoḏiˀin.” ");
INSERT INTO tew_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dívíjûusubowa ihayḏi ee diwéˀgekwꞌóˀ diwe tꞌä̖hkí naˀa̖ˀyä̖póe, pín taˀgeḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dâymáa, heḏi khunwôedaˀginpíḏíbo Jôesi Táḏáví tun tꞌowa ovâytꞌôeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tꞌä̖hkí in Jesus-víˀpiye dívíwä̖yundeˀin handa̖ˀ diˀánshaapóe, heḏá wêeḏa̖ˀ dimuu waa dicha̖a̖ inbí píˀnä́ khóˀjé. Toˀwí wänbo wínatú̖hpí, “Nä́ˀi naa dómáaˀiˀ navîˀḏa̖ˀ dînmuu,” hewänbo tꞌä̖hkíḏíbo inbí hä̖ä̖wí tꞌä̖hkí dívíyä̖́múndeˀ. ");
INSERT INTO tew_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jôesi Táḏáḏí in Jesus-ví tꞌôekhuwaˀin báyékí ovâykaymä́gi in tꞌowa ovâytu̖ˀâ̖a̖míḏí Nanbí Sedó Jesus nawáywówápóe i̖ˀgeḏi, heḏá Jôesi Táḏá-á tꞌä̖hkí indáḏá hânho híwóˀdi-á namuu. ");
INSERT INTO tew_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Heḏiho tóebo hä̖ä̖wí wänbo wíˀûntáypí. Toˀwí wänbo wí nava háa wí tewhá ûnmuuˀiˀ iku̖ˀpꞌégiḏá, iˀ chä̖ˀ ihógiˀi-á in Jesus-ví tꞌôekhuwaˀinbíˀpiye ihújaˀ ovâyˀa̖a̖níḏí, heḏá indá in shánkí díntáyˀinbíˀpiye ovâywijendeˀ. ");
INSERT INTO tew_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Wí sen Joseph gin nakhá̖wä̖́ˀi ginbá iˀan. Wí nava ivîˀ ûnmuuˀiˀ iku̖ˀpꞌégi, heḏi iˀ chä̖ˀ in Jesus-ví tꞌôekhuwaˀinbíˀpiye ihoˀḏi ovâyˀan. Nä́ˀi sendá wí Levi-ví ây iweḏiˀiˀbá namuu, oe Cyprus naˀaypu̖yä̖ˀiˀ, heḏi in tꞌôekhuwaˀindi óekhá̖yä̖́ˀ “Barnabas” gin. (Nä́ˀin khá̖wä̖́-á Huḏíyoví tundi natundaˀ “Wí toˀwí tꞌowa ovâykhä̖geˀdoˀiˀ kwee waa sen waa diˀâ̖a̖níḏí” gin.) ");
INSERT INTO tew_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wí sen Ananias gin nakhá̖wä̖́ˀi-á iví kwee Sapphira-áḏí inbí nava dä̂nku̖ˀpꞌégi, ");
INSERT INTO tew_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","heḏi iˀ chä̖ˀ dä̂nhógi iweḏi wí hä̖́yú̖ Ananias ikaakwꞌóḏi ingîˀ, heḏi iˀ naphaḏeˀi chä̖ˀ in Jesus-ví tꞌôekhuwaˀinbíˀpiye ihoˀ ovâyˀa̖a̖níḏí. Iví kwee ûnhanginná háa iˀannin tꞌä̖hkí. ");
INSERT INTO tew_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peter-di óetu̖ˀan, “Ananias, Satan iˀ Penísendi uví píˀnä́ khóˀjépiye nâatsuḏemä́gipíˀan. Iˀḏá wóetu̖ˀan iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖víˀpiye bihójoˀa̖míˀin, heḏiho tꞌä̖hkí iˀ chä̖ˀ iˀ nava dä̂nku̖ˀpꞌégi iweḏiˀiˀ wínâamaapí. ");
INSERT INTO tew_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Iˀ nava mänku̖ˀpꞌégipíḏíboˀ, ti uvîˀ wíˀúmuupíˀan? Heḏá mänku̖ˀpꞌégi ihayḏá, ti háa undaˀ waagi iˀ chä̖ˀdi biˀa̖míˀin wíˀúkoḏipíˀan? Hebo nä́ˀin yä̖ˀḏâapíˀin ánshaaḏi wóekêˀḏi Jôesi Táḏávíˀpiye bihójoˀan, tꞌowavíˀpiyeḏa̖ˀbá joe.” ");
INSERT INTO tew_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias nä́ˀin híˀ natꞌoe ihayḏi nachuhkanu, heḏi in tꞌowa háa napóeˀin dínhanginpóe ihayḏi báyékí dikhunwôedaˀpóe. ");
INSERT INTO tew_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","In eˀnûn iwe dijiˀin iˀ pení wên aa iwe dâyˀánkꞌûˀ, heḏi iweḏi óepiyeḏi óekhä̖ˀkꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Maḏi poje óḏa naphaḏe ihayḏi Ananias-ví kwee ûnpówá, hewänbo waˀḏi wíˀûnhanginnáhpí háa iví sen ûnpóeˀin. ");
INSERT INTO tew_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter-di óetu̖ˀan, “Dítu̖ˀan, ti nä́hayḏa̖ˀmân iˀ chä̖ˀ wovä̂nwáˀâa iˀ nava dä̂nku̖ˀpꞌégi ihayḏi?” I-á natú̖, “Heḏi ha̖a̖, hä̖hayḏa̖ˀmânkun.” ");
INSERT INTO tew_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter-di óetsikaˀyan, “Háaḏan wíˀgíndíbo dä̂nwéhpêeˀan Nanbí Sedóví Pꞌoewa̖a̖hâ̖a̖ dä̂ntayi̖ˀníḏí dä̂nshaa-íḏí tigúba wovä̂ntuhchä̖ä̖nú-í ivíˀpiye dänhójoˀandi? Ótꞌôeyan, hä̖ä̖ phóḏi jáˀwé in uví sen óetsꞌankhä̖ˀkꞌûˀin dínˀa̖hsaatû̖ˀ, heḏi indibá chuˀi wóepiyegíˀo.” ");
INSERT INTO tew_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wesebo iˀ kwee Peter-ví ân núˀ nachuhkanu. In eˀnûn ditsꞌûndi óechuhshaaḏá iweḏi óepiye, heḏi iví senbí núˀbá óekhä̖ˀkꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tꞌä̖hkí in méesateˀin tꞌowa heḏá tꞌä̖hká in wéˀgen tꞌowa nä́ˀin háa napóeˀin dínhanginpóeḏí khunwôedaˀḏi ovâyhógi. ");
INSERT INTO tew_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","In Jesus-ví tꞌôekhuwaˀin báyékí tꞌä̖mägeˀi pínnán tꞌôe dâyˀoˀ in tꞌowa dâymúuníḏí. Tꞌä̖hkí in Jesus-víˀpiye dívíwä̖yundeˀin dívíwéˀgeˀoˀ iˀ méesate hayˀiwi pohtâa iwe, “Solomon-bí pohtâa” gin dâytu̖ˀoˀiˀ. ");
INSERT INTO tew_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","In wéˀgen tꞌowa híwó dívíhéeˀan in Jesus-víˀin dimuuˀinbí̖ˀgeḏi, tobá indáḏí dívíwéˀgeˀa̖míḏí dikhunwôedaˀ wänboˀ. ");
INSERT INTO tew_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Hewänbo shánkí wänbo tꞌowa Nanbí Sedó Jesus-víˀpiye dívíwä̖yu̖, senäˀdáḏí kwiyä̖ˀdáḏí, heḏi in wéˀgen ho dívíwä̖yu̖ˀindáḏí dívíwón. ");
INSERT INTO tew_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Háa napoeˀoˀin in tꞌowa dâymûˀḏi báyékí in dihayˀin oe pꞌóegépiye ovâyhoˀ, heḏi inbí whohpa̖ˀ eeje ahkhây eejá ovâykwꞌóḏi, heḏânho maḏân Peter naphaḏemändi iví óhkhundi wänbo ovâynáaní, heḏi handiḏi wáy wên ovâyhehkháaˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Heḏá in tꞌowaḏá i búˀây oe Jerusalem tsowa iwéngé nakwꞌóˀ deejeḏá in dihayˀin ovâymáyä̖ˀ, heḏá in toˀwên in yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ḏi ovâytꞌôephaḏekandoˀin wáˀ ovâymáyä̖ˀ, heḏi tꞌä̖hkí ovâyhehkháaˀan. ");
INSERT INTO tew_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Heḏihoˀ iˀ Huḏíyo owhaˀ pꞌóˀḏéḏîˀ heḏá in i-áḏí dijiˀindá, Sadducee tꞌowa dimuuˀin, hânho dithúupóe. ");
INSERT INTO tew_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Heḏiho in Jesus-ví tꞌôekhuwaˀinbíˀpiye dikhenmääḏi in yä̖ˀḏâapí tsiyekannin dipankwꞌóˀ diwebá ovâypankwꞌóḏi. ");
INSERT INTO tew_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Hewänbo iˀ khun Nanbí Sedó Jôesi Táḏáḏí wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ óesan iˀ pan tewhá phóḏi ihuu-íḏí, heḏi iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi ovâypiyeḏi ovâytu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Jaho bípûn oe méesate hayˀi eepiye, heḏi owe úvíwé̖e̖nú-í, heḏi in tꞌowa nä́ˀin wówátsi tsꞌa̖a̖min niˀgeḏi bîntꞌôeˀa̖mí.” Heḏiho háa ovâytu̖ˀan waa dívíˀan. ");
INSERT INTO tew_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nathayˀä̖ˀ ihayḏi iˀ méesate hayˀi eepiye ditsꞌú̖, heḏi in tꞌowa ovâyhá̖hkanhon. Waˀ han dívíˀoḏiboˀ iˀ owhaˀ pꞌóˀḏéḏîˀ heḏá in i-áḏí dijiˀindá inbíˀwe dívíwéˀgeˀandi in seˀdaa in Israel tunjowaˀ dimuuˀin ovâytu̖hkánnan, heḏi wên sundaḏo oe pan tewhá eepiye dâysan in Jesus-ví tꞌôekhuwaˀin ovâymáˀíḏí. ");
INSERT INTO tew_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Hewänbo iˀ pan tewhá iwe dipówá ihayḏi wíˀovâyshaapí, heḏiho dívíwáybundi inbí tsonnin ovâytꞌôeˀan i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ovâytu̖ˀan, “Naˀin âymûˀ iˀ pan tewhá phóḏi té̖e̖gítꞌaa natiˀḏinnin, heḏá in pan á̖yí̖ˀnin ee phóḏi núˀ-á diwinnindá. Hebo in phóḏi âyhuuḏi gitsꞌú̖ˀ dihayḏi wénä wí wänbo in senäˀ wíˀâyshaapí.” ");
INSERT INTO tew_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Iˀ méesate á̖yí̖ˀdi pꞌóˀḏéḏîˀ heḏá in owhaˀ pꞌóˀḏéḏíˀindá nä́ˀin ditꞌoe ihayḏi wíḏínhanginnáhpí háa dívíˀa̖míˀin. Wíˀnä́ táye dívíwänpitsikaˀmáa, “Hânnangú dínpóe? Hânnan wíyá napuwagíˀo?” ");
INSERT INTO tew_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ihayḏi wí toˀwí natsꞌûndi ovâytu̖ˀan, “Bítꞌôeyan, in senäˀ bînpankwꞌóḏiˀin oe méesate hayˀiˀ íve diwindi in tꞌowa ovâyhá̖ˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Heḏiho iˀ méesatewin sundaḏoví pꞌóˀḏéḏîˀ iví khä̖geˀnin wóegé iˀ méesate hayˀiˀ iwepiye dimää, heḏi in Jesus-ví tꞌôekhuwaˀin ovâywáymaa, hewänbo wíˀovâywa̖ˀanpí, gá han dívíˀandá dikhunwôedaˀḏân in tꞌowaḏi ovâykꞌuhsä̖ä̖yú̖-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Heḏi in tunjowaˀ diwéˀgekwꞌóˀ diwepiye nä́ˀin Jesus-ví tꞌôekhuwaˀin ovâytsꞌúḏeḏi in tunjowaˀví páaḏépiye ovâywí̖nú, heḏi iˀ owhaˀ pꞌóˀḏéḏîˀḏi ovâytꞌeˀpꞌíḏe gin: ");
INSERT INTO tew_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Naˀindi kayˀindi ho wâytu̖ˀan in tꞌowa wívînhá̖ˀâ̖a̖mípí nä́ˀi Jesus gin nakhá̖wä̖́ˀiví̖ˀgeḏi, hebo nää-á undá nä́ä Jerusalem i̖ˀge tꞌä̖hkí in tꞌowa shánkí wänbo bînhá̖ˀoˀ, heḏá wáˀ Jesus-ví chuwa ûnmuuḏi naˀin dînchä̖ä̖nú-íˀin ídaˀ.” ");
INSERT INTO tew_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter-áḏí in wéˀgen Jesus-ví tꞌôekhuwaˀindáḏí óetu̖ˀan, “Shánkí gínkhâyˀä̖ˀ Jôesi Táḏá háa dítu̖ˀan waa âyˀaˀginnâamíˀin tꞌowaví tun âyˀaˀginnamívíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Undi Jesus phéˀwin deeḏi bîntꞌóhtä̖geḏi bînhay, hewänbo Jôesi Táḏá, iˀ toˀwí nanbí páaḏé kä̖ˀä̖ä̖ˀindi óeˀaˀginmäˀiˀḏibá óewáywówápaa. ");
INSERT INTO tew_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jesus-ân Jôesi Táaḏí iví koˀḏíngéḏí óesóge, tsondi-á aywondi-á namúuníḏí, nä́ˀin Israel tꞌowa ovâykhä̖geˀnamíḏí inbí tꞌaywóˀdi dâyjoeˀa̖míḏí heḏânho ovâyˀowóejé-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Naˀin gínhanginná nä́ˀi tꞌä̖hkí napóeˀin, heḏânho i̖ˀgeḏi wâytu̖máa, heḏá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏá hanbá wovâytu̖máa, nä́ˀi Pꞌoewa̖a̖hâ̖a̖-á Jôesi Táḏáḏí in toˀwên óeˀaˀginmäˀin ovâymä́gi.” ");
INSERT INTO tew_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","In Huḏíyo pꞌóˀḏéḏíˀin nä́ˀi híˀ ditꞌoe ihayḏi hânho ditꞌayyaapóe, heḏi in Jesus-ví tꞌôekhuwaˀin ovâytꞌahá̖a̖nú-íˀin didaˀ. ");
INSERT INTO tew_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Hewänbo wí Pharisee sen Gamaliel gin nakhá̖wä̖́ˀiˀ iwí̖nú in tunjowaˀ ovâyhéeˀa̖míḏí. I-á Huḏíyoví khuu há̖hkandi namuu, heḏi tꞌä̖hkí in tꞌowaḏi óeˀaˀgin. Iˀḏá wên senäˀ ovâytu̖ˀan in Jesus-ví tꞌôekhuwaˀin oe jáˀwépiye ovâypeeyé-íˀin, iwe wí hây tä̖hkí dívítsíkhaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Heḏi Gamaliel-di in tunjowaˀ ovâytu̖ˀan, “Naví tꞌowa Israel-win, híwó bíˀánshaaˀan waˀḏi nä́ˀin senäˀ háawên bînˀanpíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ti wíˀúnˀánshaapíˀan wí sen Theudas gin nakhá̖wä̖́ˀi wí hä̖́yú̖ pa̖a̖yo phaḏe nä́ngé najiˀ, heḏi nä́ˀi Theudas-á natú̖, ‘Naa-ân hayˀi omuu,’ heḏi maḏi jónä́n tä̖gintä̖ (400) senäˀ i-áḏí dívíwón. Hewänbo wên sundaḏoḏi óehay, heḏáháˀ in óeyu̖u̖máaˀin tꞌä̖mäpiye diwijeḏee, heḏi hä̖ä̖wí tꞌä̖hkí dâyˀandiˀ háagîˀ wänbo wíḏínchä̖ˀpóepí. ");
INSERT INTO tew_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Heḏáháˀ wíyá hä̖́yú̖ pa̖a̖yo naphaḏe ihayḏi, tꞌowa ovâykhá̖wä̖́hóndeˀi pa̖a̖yo nanáˀ dihayḏi, Judas iˀ Galilee-wi sen naˀä̖ä̖, heḏi báyékí tꞌowa ovâyhéeˀandi i-áḏí dívíwón. Heḏi háa Theudas ûnpóe waabá Judas wáˀ ûnpóe. I-á óehayḏá tꞌä̖hkí in óeyu̖u̖máaˀin diwijeḏee. ");
INSERT INTO tew_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Heḏânho nää wâytu̖máa, háa nä́ˀin senäˀ bînˀoˀin úvíwóyí̖ˀní. Ánpí binˀan. Háa dikandaˀin heḏá inbí tꞌôe-á inbí ánshaaḏa̖ˀ dínpimuuḏáhoˀ, háa Theudas-á Judas-á dä́npóe waagibá dínpúuwí, heḏiho háˀto háa dívíˀo waa dínkâypúuwí. ");
INSERT INTO tew_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Hewänbo Jôesi Táḏáḏânho inbí tꞌôe iwe ovâykhä̖geˀmáaḏáhoˀ, nä́ˀin senäˀdá háˀto bîntꞌaaní, heḏá wáˀ maḏi Jôesi Táḏávíˀpiyeḏa̖ˀ úvíwänpihä́nsaˀí.” ");
INSERT INTO tew_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Heḏiho in Huḏíyo pꞌóˀḏéḏíˀindi Gamaliel-ví tumakhe ôntꞌôeyan. In Jesus-ví tꞌôekhuwaˀin ovâywáytsuḏejôn, heḏi ditsonpóe in sundaḏoḏi púwhí̖ˀdí ovâywhä̖́ä̖níˀin, heḏi Jesus-ví̖ˀgeḏi wíyá wíḏívíhéeˀa̖mípí gin ovâytu̖ˀandiho ovâymaˀpꞌä̖́ḏi. ");
INSERT INTO tew_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Heḏiho tunjówháagéḏí dipee. Hânho dihíhchanpóe, gá Jôesi Táḏá indáḏí báyékí nahíhchandi iˀḏi ovâymä́giḏân nä́ˀin wôedaˀ iwehay ovâykáaníḏí Jesus namuuḏi. ");
INSERT INTO tew_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Heḏi thamuwaagi iˀ méesate hayˀi ee heḏá tewhá i̖ˀge tꞌä̖hká dívíjíyéndeḏá tꞌowa Jesus-ví̖ˀgeḏi ovâytꞌôekanhon, heḏi ovâyhá̖ˀoˀ Jesus-ân namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ihayhä̖̂ä̖bá shánkí wänbo tꞌowa Jesus-víˀpiye dívíwä̖yundeˀ, heḏi in Israel nangeḏi jáˀwéḏí diˀä̖ä̖ˀin Huḏíyo in koḏi Israel-ˀinbíˀpiyeˀ ditꞌayyaapóe. Ditû̖ˀ in kwiyä̖ˀ inbí senäˀ díntꞌahánnin thamuwaagi ovâykoegîˀhä̖ä̖wímäˀ dihayḏi nä́ˀin jáˀwéḏí diˀä̖ä̖ˀin kwiyä̖ˀ shánkí hí̖ˀínda̖ˀ ovâykoegiˀmäˀ in koḏi Huḏíyo kwiyä̖ˀvíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Heḏiho in tä̖ˀḏi wíje Jesus-ví tꞌôekhuwaˀindi in wéˀgen Jesus-víˀpiye dívíwä̖yundeˀin tꞌä̖hkí ovâywéˀgeˀandi ovâytu̖ˀan, “Naˀindá gínwóˀná Jôesi Táḏáví híˀ âytꞌôeˀoḏi, heḏiho híwó wínamúunípí nanbí tꞌôe âyjoeˀa̖míḏí âywänpikoegîˀphaaḏé-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Heḏânho tíˀûuwin páaḏéˀin, tséḏí wên senäˀ unbíˀweḏi bindeˀman âykwꞌôeníḏí nä́ˀi koegîˀ ovâymä̂äníḏí. Nä́ˀin senäˀ giˀmin dimúuníˀin dínkhâyˀä̖ˀ: Tꞌowa ditû̖ˀ híwóˀnin senäˀ dimuuˀin, heḏá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi dâymáaˀindá híwóˀdi hangintan dâymáaˀindá dimúuní. ");
INSERT INTO tew_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Heḏi naˀin Jesus-ví tꞌôekhuwaˀin gimuuˀindáho ívíjûusuˀa̖mí heḏá Jôesi Táḏáví híˀ âyhá̖ˀa̖mí, heḏi nä́ˀindáho nanbí tꞌôe-á gínmúuní.” ");
INSERT INTO tew_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tꞌä̖hkí in méesate ee dikwꞌóˀnin háa in Jesus-ví tꞌôekhuwaˀin ditú̖ˀin ovâyhí̖ˀan, heḏiho Stephen óedeˀman, i-á báyékí wä̖yu̖ imáaˀiˀ namuu, heḏá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi imáaˀi-á. Nä́ˀin wéˀgen senäˀ wáˀ ovâydeˀman: Philip-á, Prochorus-á, Nicanor-á, Timon-dá, Parmenas-á, heḏá Nicholas oe Antioch-wi-á (i-á Huḏíyo namuupí wänbo in waagibá iwä̖yundeˀiˀ namuu). ");
INSERT INTO tew_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Heḏi nä́ˀin senäˀ ovâydeˀmannin in Jesus-ví tꞌôekhuwaˀinbíˀpiye ovâykán, heḏi inbîˀḏi in tꞌôekhuwaˀin dívímankwꞌóḏiḏi ingîˀ ovâyjûusuˀan. ");
INSERT INTO tew_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Shánkí wänbo tꞌowa Jôesi Táḏáví híˀ ditꞌoe, heḏi oe Jerusalem in Jesus-víˀpiye dívíwä̖yundeˀin disôemän. Báyékí in Huḏíyo owhaˀ wänbo nä́ˀi híˀ dâyˀaˀgindi dívíwä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen báyékí Jôesi Táḏáví sígísehkanä imáa, heḏi Jôesi Táḏáḏí kay óemä́gi, heḏiho tꞌä̖mägeˀi pínnán tꞌôe heˀendi iˀoˀ in tꞌowa dâymúuníḏí. ");
INSERT INTO tew_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Hewänbo wên senäˀ Stephen-dáḏí dívítu̖hkandoˀ. Indá nä́ˀi Huḏíyoví méesatewin dimuu, “Ovâymaˀpꞌä̖́ˀḏiˀin Pantꞌôeˀinbí Méesate” gin dâytu̖ˀoˀ, heḏi Cyrene-windá Alexandria-windá Cilicia-windá heḏá Asia-windá dimuu. ");
INSERT INTO tew_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Hewänbo iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi Stephen báyékí híwóˀdi hangintan óemä́gi ihéeˀa̖míḏí, heḏiho in senäˀ wíḏínkoḏipí óetꞌaaníḏí. ");
INSERT INTO tew_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Heḏiho indi wên senäˀ ovâywáˀâa iví̖ˀgeḏi dívíhójoˀa̖míḏí, heḏi nä́ˀin ditú̖, “Naˀin gitꞌoe aˀginpí waagi ihéeˀandi Moses-ví̖ˀgeḏi heḏá Jôesi Táḏáví̖ˀgeḏá.” ");
INSERT INTO tew_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Gindiḏiho in tꞌowa heḏá in Huḏíyo tsonnin heḏá in Huḏíyoví khuu dâyhá̖ˀoˀindá tꞌä̖hkí ovâytꞌeˀyaˀnan, heḏiho Stephen-bíˀpiye dikhenmääḏi óeyâ̖ˀ, heḏi khóhkaydi in tunjowaˀvíˀpiye óehoˀ. ");
INSERT INTO tew_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Heḏi wên senäˀ ovâytsꞌúḏe iví̖ˀgeḏi dívíhójoˀa̖míḏí. Ginnân ditú̖: “Nä́ˀi sendá hä̖̂ä̖ḏi wänbo tꞌä̖hkí híwóhpí ihéeˀo nä́ˀi Jôesi Táḏáví méesate i̖ˀgeḏi heḏá iˀ tsontun Moses itaˀnan niˀgeḏá. ");
INSERT INTO tew_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Heḏi gitꞌoe natú̖ḏí, nä́ˀi sen Jesus oe Nazareth-wi nä́ˀi méesate hayˀiˀ inayu̖khâymáaˀin heḏá nä́ˀi khuu Moses-di dímä́giˀi-á tꞌä̖hkí iˀegókhâymáaˀin.” ");
INSERT INTO tew_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tꞌä̖hkí in tunjowaˀdi tsíhtáye Stephen óemúndeˀ, heḏi iví tsꞌay wí makówáwi tꞌôepa̖ˀa̖a̖ˀivíˀin waagibá ûnkeepóeˀin dâymûˀ. ");
INSERT INTO tew_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Iˀ owhaˀ pꞌóˀḏéḏîˀḏi Stephen óetsikaˀyan, “Ti nä́ˀi ditû̖ˀdi tꞌä̖hkí taˀgen namuu?” ");
INSERT INTO tew_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen-di ovâytu̖ˀan, “Mä́ˀmä̂äˀindá tíˀûuwin páaḏéˀindá, naa dîntꞌôeyan. Jôesi Táḏá iˀ saˀwóˀdi kohthay eeḏi nathaaˀi nanbí páaḏéˀi thehtáy pahpâa Abraham-bíˀpiye ipikeeyan, waˀḏi Abraham owáy Mesopotamia nange wä̖́hä̖̂ä̖ nathaa ihayḏiboˀ, oe Haran búˀpiye waˀ namääpíḏíboˀ, ");
INSERT INTO tew_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","heḏi Jôesi Táḏáḏí óetu̖ˀan, ‘Uví maatu tꞌowa mänjoeˀa̖mí heḏá uví nangá, heḏi unmú-í nä́ˀi nange wînkeekankhâymáa iwepiye.’ ");
INSERT INTO tew_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Heḏiho in Chaldean-bí nangeḏi napeeḏi oe Haran wä̖́hä̖̂ä̖piye ithayegihoˀ. Iví táḏá ûnchuu ihayḏá Jôesi Táḏáḏí óetu̖ˀan iweḏá namú-íˀin, heḏi nä́ä nange nää githaa iwe napówá. ");
INSERT INTO tew_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Jôesi Táḏáḏí Abraham hä̖ä̖wí wänbo nä́ˀi nange iwe wíˀóemä́gipí ivîˀ ûnmúuníḏí, wí nan iˀa̖hkêeníˀi wänbo joe. Hewänbo Jôesi Táḏá iví tun imä́gi wáy wí thaa nä́ˀi nan óepä̖hkhâymáaˀin ivîˀ ûnmúuníḏí, heḏá owáy nachuu ihayḏá iví tíˀúugé kä̖ˀä̖ä̖ˀindá inbîˀ dínpuwagíˀo. Heḏi nä́ˀi tꞌä̖hkí Jôesi Táḏáḏí Abraham óetu̖ˀan waˀḏi iví páaḏéˀi ay ûnpu̖yä̖píḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Óetu̖ˀan wáˀ iví tíˀúugé kä̖ˀä̖ä̖ˀin wíyá nange inbîˀ dínmuupíˀwe dívíthayekhâymáaˀin, heḏi ee nangeˀin tꞌowaḏi jónä́n tä̖gintä̖ (400) pa̖a̖yo tꞌä̖hkí ovâypankhonkhâymáaḏá ovâytꞌôephaḏekankhâymáa. ");
INSERT INTO tew_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Hebo óetu̖ˀan wáˀ, ‘Naaḏá in tꞌowa uví tíˀúugé kä̖ˀä̖ä̖ˀin ovâypanhógiˀin dovâytuhchä̖nukhâymáa, heḏá hä̖ˀin tꞌowaví nangeḏi uví tíˀúugé kä̖ˀä̖ä̖ˀin dipeegíˀo, heḏi nä́ˀi nangepiye diˀä̖ä̖-í, heḏi nä́we naa díˀaˀginmä̂äní.’ ");
INSERT INTO tew_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Heḏiho Jôesi Táḏá gin iwéhpêeˀandi Abraham óetu̖ˀan wên kꞌewe taaḏi óetaaˀa̖míˀin, Abraham ikeeya̖míḏí nahíjeˀin. Heḏi Abraham wí eˀnú ûnpu̖yä̖, i-á Isaac gin nakhá̖wä̖́, heḏi kháve thaa naphaḏe ihayḏi nä́ˀin kꞌewe taaḏibá óetaaˀan. Heḏá Isaac wáˀ iví eˀnú Jacob hanbá iˀan, heḏá Jacob-á iví tä̖ˀḏi wíje (12) eˀnûn hanbá-á, indá nanbí hehä̖̂ä̖win thehtáy pahpáˀin gínmuu. ");
INSERT INTO tew_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Nä́ˀindá inbí tíˀûu Joseph-víˀpiye dithúupóeḏí óeku̖ˀpꞌégi, heḏi wây-á senäˀ oe Egypt-piye dimännindi óekumäḏi indáḏí óehoˀ. ");
INSERT INTO tew_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Hewänbo Jôesi Táḏá wáˀ i-áḏí namää, heḏi tꞌä̖hkí iví tꞌôephaḏe iweḏi óejâaˀan. Jôesi Táḏáḏí Joseph óekhä̖geˀnandiho iˀ Egypt-wi tsondi pꞌóˀḏéḏîˀ Pharaoh gin óetu̖ˀoˀiˀḏi báyékí óehí, heḏá óemûˀ híwóˀdi hangintan imáaˀin, heḏiho iˀḏi Joseph óesóge in Egyptˀinbí tunjó dínmúuníḏí heḏá iví hä̖ä̖wí tꞌä̖hkí ônˀá̖yîngiˀa̖míḏá. ");
INSERT INTO tew_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ihayhä̖̂ä̖bá oe Egypt nange heḏá Canaan nangá wéngé tꞌä̖hkí diha̖a̖póe, heḏiho báyékí tꞌowa dâytꞌôephaḏendeˀ. Nanbí thehtáy pahpáˀin wänbo wíḏâykoegiˀshaaḏepí. ");
INSERT INTO tew_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Heḏi oe Egypt dínkoegiˀbáˀyennin Jacob ûnhanginpóe, heḏiho iví eˀnûn nanbí thehtáy pahpáˀin gínmuuˀin iwepiye isan dâykoegîˀkuumä́-íḏí. Ihayḏá páaḏé iwepiye ditsꞌanmää. ");
INSERT INTO tew_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Heḏi wíyá dimää ihayḏi Joseph-di ovâykeeyan i-á inbí tíˀûu dínmuuˀin, heḏá Pharaoh-á ûntsꞌanhanginpóe toˀwên Joseph-ví tꞌowa ûnmuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Heḏi Joseph-di iví maatu tꞌowa-á heḏá iví táḏá Jacob-á ovâytꞌôesan ivíˀpiye oe Egypt diˀä̖ä̖-íˀin. Indá tségíntä̖ˀḏi pꞌánú (75) ihay dijiˀ. ");
INSERT INTO tew_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Heḏiho gindiḏi Jacob-áḏí nanbí wéˀgen thehtáy pahpáˀindáḏí oe Egypt-piye dimää, heḏi iwe dívíthaye dichuu píhay. ");
INSERT INTO tew_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tíúugéḏí iˀ pení phéhkhún Egypt-di oe Shechem-piye dâyhoˀ heḏi iwe wí tꞌowápho iwe wíyá dâywáykhä̖ˀkwꞌóḏi. Báyékí pa̖a̖yo phaḏe nä́ˀi hä̖ä̖wí napóepíḏíbo nä́ˀi tꞌowápho-á Abraham wí chä̖ˀdi ho ikumä Hamor-ví eˀnûnbíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Iweḏi báyékí pa̖a̖yo naphaḏe, heḏi nanbí tꞌowa oe Egypt nange wä̖́hä̖̂ä̖ báyékí diˀâytꞌowasôe, heḏi iˀ thaa tsowa naˀä̖ˀ Jôesi Táḏá iˀa̖míḏí háa iˀḏi Abraham óetu̖ˀan waa óekhâymáaˀin. ");
INSERT INTO tew_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Heḏi ihayḏi wíyá tsondi pꞌóˀḏéḏîˀ tsꞌa̖a̖biˀ Egypt nange nasogeḏee, i-á hä̖ä̖wí wänbo Joseph-ví̖ˀgeḏi ûnhanginnáhpîˀ namuu. ");
INSERT INTO tew_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","I-á wên háawên jänäkíˀin nanbí tꞌowavíˀpiye iˀan, iˀḏá nanbí thehtáy pahpáˀin ovâykaygiˀan inbí ây hí̖ˀínnin jáˀwébo dâyjoeˀa̖míḏí dínchuu-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ihayḏibá Moses naˀaypu̖yä̖, heḏi hânho saˀwóˀdi-á naˀaymuu. Iví jíyá-áḏí iví táḏá-áḏí poje pꞌóe tꞌä̖hkí inbí kꞌaygibo óeˀá̖yîngiˀan. ");
INSERT INTO tew_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ihayḏáháˀ oe jáˀwépiye óepiye óejoeˀa̖míḏí, hebo Pharaoh-ví aˀyú̖ ûnˀä̖ä̖ḏi óeshaaḏi ivíˀpiye óehoˀ, heḏi ivîˀ ûnmuu waabá óesówé. ");
INSERT INTO tew_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses-á nä́ˀin Egypt-winbí há̖hkan tꞌä̖hkí nahá̖hpóe, heḏi iví híˀ-á heḏá tꞌä̖hkí iˀannindá ûnkay. ");
INSERT INTO tew_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses-á jónä́ntä̖ (40) pa̖a̖yoˀi napuwamän dihayḏi iˀánshaamä́gi iví tꞌowa in Israel-ˀin napu̖wä̖mú-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Heḏi namää ihayḏi wí Egypt-wi sendi wí Israel-ˀiˀ sen óewa̖ˀoḏi óemûˀ, heḏiho Moses-di nä́ˀi Israel-ˀiˀ ônˀaywoeníḏí namää, heḏi háa iˀ Egypt-wiḏi iˀ Israel-ˀiˀ óeˀan waabá Moses-di iˀ Egypt-wi óeˀan óeḏahay píhay. ");
INSERT INTO tew_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses naˀándeˀ iví tꞌowa dínhanginnáaníˀin Jôesi Táḏáḏí óesógeˀin inbí tꞌôephaḏe iweḏi ovâymaˀpꞌä̖̂ä̖ḏi-íḏí, hewänbo indá wíḏínhanginnáhpí. ");
INSERT INTO tew_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Wíyá tháwä́n nawáyˀä̖ä̖ ihayḏi wíje Israel-ˀin dänyándeḏi ovä̂nmûˀ, heḏi ovä̂nkꞌemakannamíḏí ikhä̖ä̖. Ovä̂ntu̖ˀan, ‘Bátꞌôeyanbe un senäˀ, undá tíˀûuwin waaginbá damuu, heḏi háaḏan wíˀnä́ táye dänwa̖ˀoˀ?’ ");
INSERT INTO tew_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Hewänbo iˀ sendi iˀ wêe sen óewa̖ˀoˀiˀḏi Moses óewänpichä̖nuḏi óetu̖ˀan, ‘Toˀḏan wônkꞌûˀ naˀin dítsonmáˀve-íḏí háa dítu̖ˀâ̖a̖míḏí híwóhpí änˀoˀin? ");
INSERT INTO tew_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ti naa wáˀ díháyjíˀin undaˀ, tsá̖ˀdi iˀ Egypt-wi nâaˀan waabá?’ ");
INSERT INTO tew_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses nä́ˀin natꞌoeḏi Egypt-di nashavepee, heḏi oe Midian nangepiye namääḏi iwe wí jáˀwéḏíˀi waagibá ithaye. Iwáy wä̖́hä̖̂ä̖ho wíje eˀnûn ûnpu̖yä̖. ");
INSERT INTO tew_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Wíyá jónä́ntä̖ (40) pa̖a̖yo naphaḏe ihayḏi wí thaa oe Sinai pꞌin núˀ ahkónu wáy najiˀ ihayḏi, wí makówáwi tꞌôepa̖ˀa̖a̖ˀi wên wä̖́ä̖ˀi phéˀyä̖́vi nakojeˀnin jâage nawindi óemûˀ. ");
INSERT INTO tew_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses nä́ˀi imûˀḏi óeháaˀan, heḏi shánkí núˀpiye ihá̖ḏi híwó imúuníḏí, heḏi Nanbí Sedó Jôesi Táa ihéeˀandi natꞌoe. Gin Moses óetu̖ˀan: ");
INSERT INTO tew_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Naa-á Jôesi Táḏá omuu, uví thehtáy pahpáˀin Abraham-dá Isaac-á heḏá Jacob-á indi díˀaˀginmä́giˀiˀ.’ Moses nakhunwôedaˀpóeḏí natha̖tha̖póe, heḏi wíyá imúuníˀin wínadaˀpí. ");
INSERT INTO tew_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Hebo Nanbí Sedó Jôesi Táaḏí óetu̖ˀan, ‘Óˀantopꞌä̖ḏi, hä̖ˀi nan unwin diwe báyékí naˀaˀginmuu, navîˀ dînmuuḏi. ");
INSERT INTO tew_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Taˀgendi naa dómûˀ háa in Egypt-windi naví tꞌowa ovâytꞌôephaḏekandoˀin, heḏá inbí haytu̖hkwíndá otꞌoe, heḏiho dovâymaˀpꞌä̖̂ä̖ḏi-íḏí owá̖. Nää-á u̖-á bikhâyˀa̖mí, oe Egypt-piye wíwáysankhâymáa ovâykhä̖geˀnamíḏí.’ ");
INSERT INTO tew_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Heḏiho Jôesi Táḏáḏí Moses óesan in Israel tꞌowaví tsondi dínmúuníḏí heḏá ovâymaˀpꞌä̖̂ä̖ḏi-íḏá, tobá hä́ndíḏí indi óejoegiˀandi óetu̖ˀan wänboˀ, ‘Toˀḏan wônkꞌûˀ nanbí tsondi gínmúuníḏí heḏá dítu̖ˀâ̖a̖míḏá háa híwó háa híwóhpí ívíˀoˀin?’ Heḏi Moses in Israel tꞌowavíˀpiye namää ihayḏi iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ in wä̖́ä̖ˀi phéˀyä̖́vi nakojeˀnin jáagé nawindi óehéeˀandiˀbá i-áḏí namää óekhä̖geˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nä́ˀi Moses-á tꞌä̖mäge ipínnántꞌôeˀan oe Egypt nange wä̖́hä̖̂ä̖, heḏá iˀ pꞌîˀ mâapꞌoe gin dâytu̖ˀoˀ iwe tsowa-á, heḏá iˀ ahkónu iwá jónä́ntä̖ (40) pa̖a̖yo dijiˀ ihayḏi. Handiḏiho iˀḏi in Israel tꞌowa Egypt nangeḏi ovâypiye. ");
INSERT INTO tew_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nä́ˀi Moses-dânkun in Israel tꞌowa ginnân ovâytu̖ˀan: ‘Jôesi Táḏáḏí wí tukheˀbiˀ unbí tꞌowa iweḏiˀibo namuuˀi wovâysangíˀo, naa dísan waagibá.’ ");
INSERT INTO tew_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nä́ˀi Moses-á in Israel-ˀindáḏí najiˀ oe ahkónu i̖ˀge. Oe Sinai pꞌin núˀ nanbí thehtáy pahpáˀindáḏí najiˀ, iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi wíyá óehéeˀan dihayḏi, heḏi iˀ tꞌôepa̖ˀa̖a̖ˀiˀḏi óehéeˀandi wí híˀ nahándepîˀ ihógi naˀin dítu̖ˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Hebo nanbí thehtáy pahpáˀin wíḏidaˀpí Moses ôntꞌôeyaaníˀin, heḏiho óewänpijoegiˀan, heḏá oe Egypt-piye diwáypundaˀḏi diboˀaakwꞌó. Heḏiho Aaron dâytu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","‘Wí hä̖ä̖wí âyˀaˀginmä̂änígîˀ heḏá dînpáaḏéhûuwígîˀ-á dînpaˀí. Nä́ˀi sen Moses oe Egypt-di dípiyeˀi-á, wígínhanginnáhpí háa ûnpóeˀin.’ ");
INSERT INTO tew_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ihayhä̖̂ä̖ḏi wí hä̖ä̖wí wí wáasíˀay waa ûncha̖a̖ˀi dâypaa, i-á inbí jôesi dínmuu waa dâycha̖a̖, heḏá dâyˀanimâatꞌahá̖nú inbí aˀgin dívímä̂äníḏí, heḏi nä́ˀi hä̖ä̖wí inbí mandibo dâypaaˀiˀḏi báyékí ovâyhíhchanmä́gi. ");
INSERT INTO tew_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Heḏiho Jôesi Táḏáḏí ovâyjoeˀan heḏânho iˀ thandá pꞌóe-á heḏá in agóyó oe makówá disaaˀindá dâyˀaˀginmä̂äníḏí. Hä́nˀoebo wí Jôesi Táḏáví tukheˀbi itaˀnan háa Jôesi Táḏá natú̖ˀin, ginnân: Un Israel tꞌowa, oe ahkónu jónä́ntä̖ (40) pa̖a̖yo íjiˀ ihayḏi, bînˀanimâatꞌahá̖núndeḏi unbí aˀgin bînmä̂äníḏí, taˀgendi naagîˀ wíˀúvíˀanpí. ");
INSERT INTO tew_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Naa díˀaˀginmä̂änívíˀweḏi wí hí̖yä̖̂ä̖ˀi teˀaaˀay phoˀ Moloch bînsóge bînhûuwíḏí, heḏá wí hä̖ä̖wí wí agóyó waabá ûncha̖a̖ˀiˀ Rephan gin dâytu̖ˀoˀi-á bînhon. Nä́ˀin wíjeḏi mandibo bînpaaˀin bînˀaˀginmä́gi. Heḏânho wên tꞌowa dovâysankhâymáa wovâyhúuwíḏí kayi̖ˀ wä̖́hä̖̂ä̖piye oe Babylon-ví shánkí onäḏi. ");
INSERT INTO tew_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Jôesi Táḏáḏí Moses óehéeˀan nanbí thehtáy pahpáˀin ovâytu̖ˀa̖míḏí wí teˀaa gáhä̖́yú̖ˀi dâypaˀíˀin, heḏi Moses ônkeeyan háa nakeetꞌôení waa. Nä́ˀi teˀaa gáhä̖́yú̖ˀi-á íve iˀ kꞌuu pháagîn dakꞌóe Jôesi Táḏáví tsontun eeḏi nataˀmuuˀiˀ, heḏi iˀ teˀaa dâykéeˀí oe ahkónu i̖ˀge dijiˀ ihayḏi. ");
INSERT INTO tew_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Heḏi nanbí thehtáy pahpáˀindá iˀ teˀaa gáhä̖́yú̖ˀi-á inbí ây ovâyjoeˀan, heḏáháˀ inbí ây-á iˀ teˀaa dâymaa Joshua-ḏi nä́ä nange ovâytsꞌúḏe ihayḏi. Ihayḏibá in tꞌowa nä́ˀi nan diwewin dimúˀdeˀin Jôesi Táḏáḏí ovâykhehpiye. Heḏi nä́ˀi teˀaa dínkꞌóe inbí tsondi hayˀi David-ví thaa puwahay. ");
INSERT INTO tew_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David-dá Jôesi Táḏá óehíhchannan, heḏi gin ijûusuˀan: ‘Nanbí Sedó Jôesi Táa, u̖ Jacob-di hä́nˀoe wóeˀaˀginmäˀiˀ, wí wháagé u̖gîˀ wînkꞌúuwíˀin naa dímä́ä.’ ");
INSERT INTO tew_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Hebo David-ví ay Solomon-dân Jôesi Táḏágîˀ ôntewhákꞌûˀ, David-dá joe. ");
INSERT INTO tew_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Hewänbo Jôesi Táḏá iˀ shánkí kwꞌáyewi namuuˀiˀ iˀ tewhá tꞌowa inbí mandi dâykwꞌóḏi eejeḏa̖ˀbá wínathaapí, i-á tꞌä̖mäpiye nathaa. Hä́nˀoe wí iví tukheˀbiˀ gin itaˀnan: ");
INSERT INTO tew_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Jôesi Táa natú̖, ‘Makówá tꞌä̖hkí naví sogeˀi waagiˀbá dînmuu, heḏá nä́ä oepáa kꞌayḏá wí ân kaykhanwówákandi waagibá-á naagîˀ namuu. Wí wháagé dítôeníḏí wänbo wíˀúnkoḏipí bînkꞌúuwíḏí, heḏi wáygé dáykaykhanwówáˀa̖míˀin wíḏîntáypí. ");
INSERT INTO tew_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ti naví mandibo hä̖ä̖ tꞌä̖hkí wíḏókhíjépíˀan?’ gin Jôesi Táa natú̖. ");
INSERT INTO tew_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Un tꞌowa pꞌóhkâyˀinda̖ˀ ímuu, heḏi wä̖yu̖píˀin ímuuḏi Jôesi Táḏáví híˀ píˀnä́ khóˀjé wíˀúntsꞌúyaˀpí heḏá wíˀítꞌoeˀopí. Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ hä̖̂ä̖ḏi wänbo tꞌä̖hkí bînjoegimáa. Háa unbí hehä̖̂ä̖win thehtáy pahpáˀin dívíˀan waagibá úvíkanhon. ");
INSERT INTO tew_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Indá Jôesi Táḏáví tukheˀmin tꞌä̖hkí ovâytꞌôephaḏekannanpíˀan. Ovâytꞌahá̖nú in tꞌôepa̖ˀa̖a̖ˀin hä́nˀoe ditú̖ˀin nä́ˀi toˀwí iví wówátsi taˀge ihondi namuuˀi nakä̖ˀä̖ä̖gíˀoˀin. Heḏi iˀ napówá ihayḏá undiḏá tunjówháagé bînmangekán, heḏi handiḏi undibo bînhay. ");
INSERT INTO tew_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tobá Jôesi Táḏáḏí in makówáwin tꞌôepa̖ˀa̖a̖ˀin ovâysan wänbo iví tsontun wovâymä̂äníḏí, nä́ˀi tsontundá wívînˀaˀginnanpí.” ");
INSERT INTO tew_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Waˀḏi Stephen-di ovâyhíˀmáaḏí in Huḏíyo pꞌóˀḏéḏíˀin hânho ditꞌayyaapóeḏí ôndawä̖ˀtsꞌíndeˀ. ");
INSERT INTO tew_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Hewänbo Stephen-dá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi imáaḏí oe kwꞌáyepiye ibée, heḏi oe makówá Jôesi Táḏáví saˀwóˀdi kohthay ônmûˀ, heḏá Jesus-á Jôesi Táḏáví koˀḏíngéḏí nawindi óemûˀ. ");
INSERT INTO tew_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Heḏi Stephen natú̖, “Binmúˀḏí, makówá nakhuuḏeeḏi dómúndeˀ, heḏá iˀ tꞌowa tꞌä̖hkígîˀ naˀaypu̖yä̖ˀi-á Jôesi Táḏáví koˀḏíngéḏá nawin.” ");
INSERT INTO tew_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","In iwe diwinnin dívíˀojemankwꞌóḏiḏi dívítu̖wí̖nú, heḏá tꞌä̖hkíḏíbo wéˀge ivíˀpiye dikhenmää. ");
INSERT INTO tew_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Heḏi khóhkayḏi oe búˀ jáˀwépiye óehoˀ, heḏi in ôntꞌeˀpꞌíḏeˀin inbí kꞌéwéˀi to dívípꞌä̖́ḏiḏi wí eˀnú Saul gin nakhá̖wä̖́ˀiví núˀ dâyjoeˀan iˀá̖yîngiˀa̖míḏí, heḏáháˀ Stephen óekꞌusä̖yu̖ óeháyjíḏí. ");
INSERT INTO tew_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Waˀḏi óekꞌusä̖yundeˀ ihayḏibo ijûusuˀan gin: “Nanbí Sedó Jesus, naví hâ̖a̖ dînkeˀ.” ");
INSERT INTO tew_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Heḏi idégeˀdisógeḏi gin kaygi natú̖, “Nanbí Sedó Jôesi Táa, in tꞌaywóˀnin nä́ˀin tꞌowa dívíˀoˀin wíˀovâychä̖ä̖nú-ípí.” Gin natú̖ḏíhoˀ iví wówátsi ibowa ijóˀkꞌûˀ waagibá. ");
INSERT INTO tew_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Stephen óehayḏi Saul-dá óehí̖ˀan. Hebo wây-á senäˀ Jôesi Táḏá óeˀaˀgindoˀindiḏá báyékí dívísíhtä̖ä̖ḏi Stephen óekhä̖ˀkꞌûˀ. Iˀ thaa iweḏi páaḏépiye tꞌä̖hkí in Jesus-víˀpiye dívíwä̖yundeˀin oe Jerusalem dikwꞌóˀnin báyékí ovâytꞌôephaḏekandoˀ, heḏi in tꞌä̖hkí dijândi tꞌä̖mäpiye diwaḏeḏee oe Judea nange Samaria nangá i̖ˀge tꞌä̖hkí. In Jesus-ví tꞌôekhuwaˀinda̖ˀ Jerusalem-bo dívíwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul-di in méesateˀin tꞌowa báyékí ovâyjänäkíˀoˀ. Tewhá ee tꞌä̖hkí ijíyéndeḏi kwiyä̖ˀdá senäˀdá inbíˀjeḏibo ovâywhaapiyendeˀ, heḏá ovâypankwꞌóeˀó. ");
INSERT INTO tew_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Heḏiho in tꞌä̖mäpiye dishavepeeˀin wéngé tꞌä̖hkí dívíjíyéndeḏi Jôesi Táḏáví híˀ ôntꞌôekanhon. ");
INSERT INTO tew_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip wí Samaria-wi búˀpiye namääḏi Jesus-ví̖ˀgeḏi ovâytꞌôeˀoˀ. Ovâytu̖máa Jesus-á namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Báyékí tꞌowa dívíwéˀgeˀan heḏá háa Philip-di ovâytu̖máaˀin á̖yîngiḏi dívítꞌôeyandeˀ, iˀ pínnán tꞌôe iˀandi dâymûˀḏi. ");
INSERT INTO tew_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Báyékí yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ dívítu̖wí̖núndeḏi in tꞌowa ovâymáaˀin diweḏi dipee, heḏá báyékí in dínˀa̖ˀyä̖kankoḏipíˀindá dipóhayˀindá ovâyhehkháaˀan. ");
INSERT INTO tew_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Heḏânho in búˀwin hânho dihíhchanpóe. ");
INSERT INTO tew_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Ee búˀ wí sen Simon gin nakhá̖wä̖́ˀi wíˀbo natû̖ˀ i-á hayˀi namuuˀin, heḏi ichugetꞌôeˀoḏi báyékí pa̖a̖yo in Samaria nangeˀin tꞌowa ovâyháaˀoˀ. Heḏiho gin iˀoḏi tꞌä̖hkí tꞌowa heˀennin dimuuˀindá heˀennin dimuupíˀindá ôntꞌôeyandeˀ, heḏi ditû̖ˀ, “Nä́ˀi sendá iˀ namuu Jôesi Táḏáḏí óepínnánkaymä́giˀiˀ.” ");
INSERT INTO tew_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Hebo Philip-á iˀ híwóˀdi tun Jôesi Táḏáví khuu i̖ˀgeḏi ovâytꞌôeˀoˀ heḏá ovâytu̖máa Jesus-ân namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, heḏi in tꞌowa dívíwä̖yu̖ḏi ovâypꞌóˀpꞌoeˀan, kwiyä̖ˀdá senäˀdá. ");
INSERT INTO tew_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon wänbo wáˀ iwä̖yu̖, heḏi óepꞌóˀpꞌoeˀan dihayḏi Philip-áḏí wéˀge dänjíyéndeˀ, heḏi hânho óeháaˀoˀ tꞌä̖mägeˀi pínnán tꞌôe Philip iˀoˀiˀ imûˀḏi. ");
INSERT INTO tew_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Oe Jerusalem in Jesus-ví tꞌôekhuwaˀin ditꞌoe in Samaria-ˀin tꞌowa Jôesi Táḏáví tun ônkêˀin, heḏiho Peter-á John-dá inbíˀpiye ovä̂nsan. ");
INSERT INTO tew_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Nä́ˀin wíje dapówá ihayḏi in dívítsꞌanwä̖yu̖ˀingîˀ ovâyjûusuˀan iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dâykáyjíḏí, gá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ waˀḏi inbíˀpiye wíḏínˀä̖ä̖píḏân. Ovâywänpipꞌóˀpꞌoeˀan Nanbí Sedó Jesus-víˀpiye dívíwä̖yu̖ḏi. ");
INSERT INTO tew_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Heḏáháˀ inbîˀḏi wíˀíngin dänmankꞌûˀḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dâykêˀ. ");
INSERT INTO tew_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Heḏi nä́ˀin Jesus-ví tꞌôekhuwaˀin in tꞌowavîˀḏi dänmankꞌûˀḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dâykêˀin Simon imûˀḏi ovä̂nchä̖ˀmä̂äníˀin nadaˀ, ");
INSERT INTO tew_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","heḏi ovä̂ntu̖ˀan, “Naa wáˀ dînkꞌuˀ heḏânho tꞌä̖hkí naa inbîˀḏi dáymankꞌûˀin iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dâykáyjíḏí.” ");
INSERT INTO tew_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Hebo Peter-di óetu̖ˀan, “Uví chä̖ˀ wóegébo péyégépiye unmú-í, gá unˀándeḏân iˀ hä̖ä̖wí Jôesi Táḏá imäˀi chä̖ˀdi nâakuumä́-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jôesi Táḏáḏí wóemúnde píˀnä́ khóˀjé taˀge wíˀunmuupíˀin heḏiho nä́ˀin tꞌôe háˀto úkoeḏí-í biˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nää-á nä́ˀi yä̖ˀḏâapíkan unkandaˀi nájoeˀan, heḏi pín taˀgeḏi Nanbí Sedó Jôesi Táḏávíˀpiye bijûusuˀa̖mí háḏéebá nakoḏiḏi nä́ˀi gin unˀánshaamuuˀiˀ wônˀowóejé-í. ");
INSERT INTO tew_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Naa-á dînhanginná hânho unthúutꞌóeˀin, heḏá uví tꞌaywóˀdiḏi wóewhimáa waagibá úpóe.” ");
INSERT INTO tew_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon-di ovä̂ntu̖ˀan, “Nanbí Sedó Jôesi Táḏávíˀpiye dînjûusuˀa̖mí heḏânho nä́ˀi dítu̖ˀandi naa wíḏînpúuwípíḏí.” ");
INSERT INTO tew_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Heḏi Peter-áḏí John-dáḏí hä̖ä̖wí Jesus-ví̖ˀgeḏi dä́nhanginnáˀdiˀ in tꞌowa ovâytu̖ˀan dihayḏi, heḏá Nanbí Sedó Jôesi Táḏáví tun ovâytꞌôeˀan dihayḏi, Jerusalem-piye dawáymää. Dänweehon dihayḏi báyékí Samaria nangewi búˀây i̖ˀgeḏi daphaḏe, heḏi Jôesi Táḏáví híwóˀdi tun ovâytꞌôekanhon. ");
INSERT INTO tew_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ihayhä̖̂ä̖ḏibá wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi Philip óetu̖ˀan, “Ókhâyˀandi nä́ˀin aakonpiyeˀin pꞌôe i̖ˀge unmú-í, indá Jerusalem-di Gaza-piye namän.” (Iwe wí ahkónu naná.) ");
INSERT INTO tew_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Heḏiho ikhâyˀandi namää. Pꞌóegé iwéngé namän dihayḏi wí sen óemûˀ. Nä́ˀi sendá Ethiopia-wi tsondi namuu, in Ethiopia-winbí tsondi pꞌóˀḏéḏîˀ kweeví chä̖ˀ tꞌä̖hkí ônˀá̖yînmáaˀi namuu, iˀ kwee-á Candace gin nakhá̖wä̖́. Nä́ˀi sen oe Jerusalem-dá najiwän Jôesi Táḏá óeˀaˀginmä̂äníḏí, ");
INSERT INTO tew_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","heḏi nää ivíˀpiye iweehon dihayḏi iví te phoge naˀä́ndí in taˀnin Jôesi Táḏáví tukheˀbi Isaiah itaˀnannin itundoˀ. ");
INSERT INTO tew_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi Philip óetu̖ˀan, “Jaˀ unmú-í hä̖ˀi te nâakâaníḏí.” ");
INSERT INTO tew_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Heḏiho Philip iwä̖́näkíḏiḏi óekáa, heḏi iˀ sen itundoḏi natꞌoe, heḏi óetsikaˀyan, “Ti unkaˀpóyaˀ hä̖ˀi nâatundoˀiˀ?” ");
INSERT INTO tew_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Óetu̖ˀan Philip, “Hândiḏan okaˀpóewí wí toˀwíḏí wíḏînthayyohpíḏí? Han unchanpóeḏí ti nä́ä te phoge bitôení naa-áḏí bisôege-íḏí?” ");
INSERT INTO tew_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jôesi Táḏáví taˀnin diwe itundoˀi ginnân natû̖ˀ: Wí kꞌúwá óekheˀgíˀoˀi dâyhújaˀ waagibá óehoˀ, heḏi wí kꞌúwáˀay óephóˀkꞌowandeḏi sígínpíḏíbo hânda̖ˀdibo nawänpikꞌóe waagibá, iˀbá wáˀ háabo wínatú̖hpí. ");
INSERT INTO tew_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Óewôedaˀiwekán, heḏá híwóˀdá wíˀôntunjóˀnanpí. Toˀwí wänbo háabo wíˀûnkoḏipí natú̖u̖níḏí iví tíˀúugé kä̖ˀä̖ä̖ˀinbí̖ˀgeḏi gá iví wówátsi nä́ä oepáa kꞌayḏi ûnbowaḏeeḏân. ");
INSERT INTO tew_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Heḏi iˀ Ethiopia-wi tsondiḏi Philip óetsikaˀyan, “Toví̖ˀgeḏan Isaiah ihíˀmáa? Ti wíˀbo iví̖ˀgeḏi háa wíyá toˀwíví̖ˀgeḏi itaˀnan? Ti u̖ˀḏi dítu̖ˀa̖mí?” ");
INSERT INTO tew_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Heḏiho Philip-di ônthayyan nä́ˀi híˀ Isaiah itaˀnandi-á Jesus-ví̖ˀgeḏân namuuˀin, heḏáháˀ iˀ híwóˀdi tun Jesus-ví̖ˀgeḏi shánká ônthayyan. ");
INSERT INTO tew_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iwáy pꞌóegé wáy damändi napꞌoˀkꞌóe iwe dapówá, heḏi iˀ tsondiḏi Philip óetu̖ˀan, “Hîn námúˀḏí, hä̖we napꞌoˀkꞌóe. Ti wínakoḏipíˀan dípꞌóˀpꞌoeˀa̖míḏí?” ");
INSERT INTO tew_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip-di óetu̖ˀan, “Híwó namuu-ákun unpꞌóˀpꞌoepúuwíḏí, pín taˀgeḏi biwä̖yundeḏi.” Heḏi óetu̖ˀan Philip “Naa dáywä̖yunde-ákun Jesus Christ-á Jôesi Táḏáví ay namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Heḏihoˀ iˀ tsondiḏi iˀ sen isanhondiˀ óetu̖ˀan iˀ te iwóyí̖ˀní gin, heḏi Philip-áḏí iˀ tsondi-áḏí ee napꞌoˀkꞌóe iwe dawá̖, heḏi Philip-di óepꞌóˀpꞌoeˀan. ");
INSERT INTO tew_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pꞌoe iweḏi dapee ihayḏi Nanbí Sedó Jôesi Táaví Pꞌoewa̖a̖hâ̖a̖ḏi tsíkhagipí Philip iweḏi óehoˀ, heḏi iˀ tsondiḏi wíyá wíˀóemûˀpí, hebo ivíˀpiye namän dihayḏi báyékí nahíhchanpóe. ");
INSERT INTO tew_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip-á oe Azotus búˀ óekán, heḏi iweḏihoˀ iˀ búˀây i̖ˀge tꞌä̖hkí Jôesi Táḏáví híwó̖ˀdi tun ovâytꞌôekanhon oe Caesarea búˀ napówá píhay. ");
INSERT INTO tew_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ihayhä̖̂ä̖bá Saul ívíwo jänäkí in Nanbí Sedó Jesus-víˀpiye dívíwä̖yundeˀinbí̖ˀgeḏi ihíˀmáa. Natû̖ˀ iˀḏi ovâytꞌakha̖nukhâymáaˀin. ");
INSERT INTO tew_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Heḏiho in Huḏíyoví owhaˀ pꞌóˀḏéḏîˀvíˀpiye namää wí taˀdi óedaaˀa̖míḏí. Nä́ˀi taˀdi ihondiho in taˀge óemä́gi iˀ Huḏíyoví méesate oe Damascus búˀ eejepiye namú-íḏí, heḏiho wên tꞌowa, háa kwiyä̖ˀ háa senäˀ dimuuˀin Jesus-ví pꞌôe i̖ˀge dimännin ovâyshaaḏá, oe Jerusalem-piye ovâypanmáˀí ovâypankwꞌôeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","In pꞌóegé Damascus-piye namän dihayḏi, tsowa napowamändi, tsíkhagipí wí ko makówáḏí nawá̖, heḏi óeˀánkêˀ. ");
INSERT INTO tew_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Heḏi nange nakanu, heḏi wí toˀwíḏí óehéeˀandi natꞌoe. Óetsikaˀyan, “Saul, Saul, háaḏan u̖ˀḏi naa dítꞌôephaḏekandoˀ?” ");
INSERT INTO tew_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul natsikapóe, “Nanbí Sedó, to-an unmuu?” Heḏi óetu̖ˀan, “Naa Jesus-ân omuu, u̖ˀḏi naa dítꞌôephaḏekandoˀiˀ. ");
INSERT INTO tew_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ówí̖nú, heḏi iˀ búˀpiye unmú-í. Iwânho wóetu̖ˀa̖mí háa biˀa̖míˀin.” ");
INSERT INTO tew_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","In senäˀ i-áḏí dimännin diwänpikwi̖nuḏeeḏi háabo wíḏitundeepí. Diwänpitꞌoe hewänbo hä̖́ä̖bo wíḏâymûˀpí. ");
INSERT INTO tew_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul iwí̖nú, hewänbo itsíwaa ihayḏá hä̖́ä̖bo wíˀûnkeetꞌóepí, heḏiho Damascus-piye óepahoˀ. ");
INSERT INTO tew_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Poje thaa iví keetan wíˀimáapí heḏá wáˀ húukan wänbo su̖wä̖ wänbo wíˀiˀohpí. ");
INSERT INTO tew_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nä́ˀi búˀ Damascus iwáho wí sen Jesus-víˀpiye iwä̖yundeˀiˀ Ananias gin nakhá̖wä̖́ˀi nathaa. Nanbí Sedó Jesus-di óekhá̖yä̖́ˀdeḏi waagibá ûntꞌoepóe, heḏi Ananias natú̖, “Nanbí Sedó, hä̖ä̖-an undaˀ?” ");
INSERT INTO tew_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Heḏi Nanbí Sedó Jesus-di óetu̖ˀan, “Wesebo Judas-ví tewhá eepiye unmú-í. Iví tewhá-á nä́ä búˀwin pꞌôe iwe naˀä́n, Taˀgeˀin Pꞌôe gin dâytu̖ˀoˀ. Eeḏi wí sen Saul gin nakhá̖wä̖́ˀiví̖ˀgeḏi untsikapúuwí, Tarsus búˀwi-ân iˀ namuu. ");
INSERT INTO tew_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nääbo ijûusuˀoˀ, heḏi iˀ tewhá ee naˀä́n diwe untsuḏemändi wóemúnde waagibá nääho ûntsꞌanpuwamän, heḏá wáˀ wóemúndeˀ uví mandá nâatä̖geḏá iví keetan wíyá ikáyjíḏí.” ");
INSERT INTO tew_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hewänbo Ananias natú̖, “Nanbí Sedó, báyékí tꞌowaḏi nä́ˀi senbí̖ˀgeḏi dítꞌôeˀan. Ditú̖ uví tꞌowa Jerusalem-windá iˀḏi hânho ovâyjänäkíˀan. ");
INSERT INTO tew_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Heḏá in Huḏíyoví owhaˀ pꞌóˀḏéḏíˀindi ônkꞌûˀ nä́we wáˀ in tꞌowa tꞌä̖hkí wóekhá̖yä̖́ˀdeˀin dívíjûusuˀoḏi ovâypankwꞌôeníḏí.” ");
INSERT INTO tew_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Hewänbo Nanbí Sedó Jesus-di óetu̖ˀan, “Ópûn, naaḏân wíˀbo dódeˀman naví tꞌôe dînˀa̖míḏí. Iˀḏá in Israel tꞌowa-á heḏá in wéˀgen tꞌowa wáˀ inbí tsonnin wóegé ovâytꞌôeˀa̖mí toˀwí omuuˀin naa. ");
INSERT INTO tew_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Naaḏân wíˀbo dônthayya̖mí báyékí itꞌôephaḏekhâymáaˀin naví tꞌôe dînˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Heḏiho Ananias iˀ tewhá óetu̖ˀan deepiye namää, heḏi natsꞌú̖. Heḏi iví mandi Saul óetä̖geḏi óetu̖ˀan, “Tíˀûu páaḏéˀi Saul, hä̖ˀin pꞌóegé nä́ä Damascus búˀpiye unˀä̖ˀ ihayḏi Nanbí Sedó Jesus uvíˀpiye ipikeeyan. Heḏi iˀḏibá naa dísan wíyá úkeepúuwíḏí, heḏá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi mänmáˀve-íḏí.” ");
INSERT INTO tew_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wesebo wí hä̖ä̖wí paa okhowa waagiˀbá namuuˀiˀ Saul-ví tsée iweḏi ûnjâapóe, heḏi wíyá ûnkeepóeḏí iwí̖nú. ");
INSERT INTO tew_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ihayḏiho óepꞌóˀpꞌoeˀan, heḏi ihú̖u̖yandi iví kay iwáykêˀ. Saul wí hä̖́yú̖ thaa oe Damascus-bo iwóyí̖ˀ in tꞌowa Jesus-víˀpiye dívíwä̖yundeˀindáḏí. ");
INSERT INTO tew_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Heḏi wesebo iˀ Huḏíyoví méesate eeje namää, heḏi ovâythayjoˀ Jesus-á Jôesi Táaví ay-ân ûnmuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","In tꞌowa iví híˀ ditꞌoeˀin tꞌä̖hkí ovâyháaˀandi dívípitu̖máa, “Ti nä́ˀi-ân wínamuupíˀan iˀ toˀwíḏí oe Jerusalem ovâyhá̖núndeˀiˀ tꞌä̖hkí in Jesus óekhá̖yä̖́ˀdeˀin dívíjûusuˀoḏi? Ti nä́äpiye wínaˀä̖ä̖píˀan ha̖ˀmin tꞌowa ovâywänpipanhóeníḏí, in Huḏíyoví owhaˀ pꞌóˀḏéḏíˀinbíˀpiye ovâyhûuwíḏí?” ");
INSERT INTO tew_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Hebo Saul-ví híˀ-á shánkí wänbo ûnkaypuwamändi ovâythayyan Jesus-áho taˀgendi namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, heḏiho in Damascus-ˀin Huḏíyo hä̖́ä̖bo wíḏâyshaapí óetu̖ˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Báyékí thaa naphaḏe ihayḏi in Huḏíyo dívíwéˀgeˀan háawin wên ánshaa dâykꞌúuwíḏí háḏíḏí Saul óeháyjíḏí waagi. ");
INSERT INTO tew_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Khu̖u̖-á thaa-á iˀ búˀ tehpaa phóḏi iwe óetsíkhaˀmáa óeháyjíḏí. Hewänbo Saul ûnhanginpóe háa óekhâymáaˀin, ");
INSERT INTO tew_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","heḏi wí khun wên iví híˀ iwe dívíwä̖yundeˀindi iˀ búˀwi tehpaa iwepiye óehoˀ, heḏi naphohcháˀ diwe wên tꞌúnbay hayˀin diweḏi óewá̖ve. ");
INSERT INTO tew_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul Damascus-di oe Jerusalem-piye namää, heḏi in wéˀgen Jesus-víˀpiye dívíwä̖yundeˀindáḏí iwóeníˀin nadaˀ. Hewänbo tꞌä̖hkíḏíbo iˀ dâykhunwôedaˀ, wíḏiˀânpíḏí taˀgendi Jesus-víˀpiye iwä̖yundeˀin. ");
INSERT INTO tew_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hewänbo Barnabas-di in Jesus-ví tꞌôekhuwaˀinbíˀpiye óehoˀ indi óetaa-íḏí, heḏi ovâytu̖ˀan háa Saul ûnpóeˀin in pꞌóegé oe Damascus-piye namändi. Háa Saul-di Nanbí Sedó Jesus óemûˀ waagi heḏá Jesus-dá óehéeˀan waagá ovâytu̖ˀan. Ovâytu̖ˀan wáˀ háa Saul khunwôedaˀginpíḏíboˀ in tꞌowa oe Damascus Jesus-ví̖ˀgeḏi ovâytꞌôeˀannin. ");
INSERT INTO tew_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Heḏiho in Jesus-ví tꞌôekhuwaˀindi Saul óesígíkêˀ, heḏi i-á oe Jerusalem i̖ˀge tꞌä̖hkí indáḏí najiˀ. Iwe wáˀ khunwôedaˀginpíḏíboˀ in tꞌowa Nanbí Sedó Jesus-ví̖ˀgeḏi ovâytꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wên tꞌowa iwe dijiˀ, Huḏíyobá dimuu hebo Israel nange jáˀwéḏí diˀä̖ä̖. Indáḏí wáˀ ihíˀmáaḏáháˀ itu̖hkannan, heḏi ditꞌaypóeḏí háḏíḏí óeháyjíˀin dâytu̖wä̖máa. ");
INSERT INTO tew_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Hewänbo in tíˀûuwin páaḏéˀin háa óekhâymáaˀin dínhanginpóe ihayḏi, oe Caesarea búˀpiye óeshavehoˀ, heḏá iweḏáháˀ wíyá búˀ Tarsus-piye óesan. ");
INSERT INTO tew_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nä́ˀi naphaḏe ihayhä̖̂ä̖ in méesateˀin tꞌowa dívíwéˀgeˀoˀin iˀ nange Judea-á Galilee-á Samaria-á toˀwíḏí wänbo wíˀovâyjänäkíˀohpí, heḏi shánkí dikaypóe. Heḏi Nanbí Sedó Jôesi Táa báyékí dâyaˀginmäˀ heḏá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi ovâykhä̖geˀmáa, heḏânkun shánkí wänbo ditꞌowasôe. ");
INSERT INTO tew_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ihayḏibá Peter tꞌä̖mäpiye namändi Jôesi Táḏáví tꞌowa oe Lydda búˀ dikwꞌóˀnin napu̖wä̖pówá. ");
INSERT INTO tew_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Iwe wí sen Aeneas gin nakhá̖wä̖́ˀiˀ óejay. Nä́ˀi sendá wíˀûnˀa̖ˀyä̖kankoḏipíḏí kháve pa̖a̖yo wíˀûnkoḏipí ishaa-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter-di óetu̖ˀan, “Aeneas, nää-á Jesus Christ-di wóehehkháamä́gi. Óshaa, mänpa̖ˀshâa.” Heḏi wesebo han iˀan. ");
INSERT INTO tew_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","In tꞌowa Lydda búˀ dithaaˀin tꞌä̖hkí heḏá o̖ˀge oe Sharon nange dithaaˀindá háa ûnpóeˀin dâymûˀ, heḏi báyékí in diweḏi Nanbí Sedó Jesus-víˀpiye dívíwä̖yundeˀin dipóe. ");
INSERT INTO tew_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ihayḏibá wí kwee Tabitha gin nakhá̖wä̖́ˀiˀ, Jesus-víˀpiye iwä̖yundeˀiˀ, ee Joppa búˀ nathaa. (Iví khá̖wä̖́-á Greek tundi “Dorcas” ûnmuu, heḏi nä́ˀin híˀ Dorcas-á “Pä̖́ä̖” gin natundaˀ.) Nä́ˀi kweeḏá hä̖̂ä̖ḏi wänbo tꞌä̖hkí tꞌowa híwó ovâyˀoˀ, heḏá in sehkanäwó diwówájiˀindá ovâykhä̖geˀmáa. ");
INSERT INTO tew_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","I-á nahaypóeḏí nachuu, heḏi iˀ pení óeˀowíḏi inbí khuu dínmuu waagibá, heḏi oe whaˀkꞌay íve óekꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lydda iweḏi Joppa-á kayi̖ˀ wínanáhpí, heḏi ee Joppa in Jesus-víˀpiye dívíwä̖yundeˀin dínhanginpóe Peter-á oe Lydda najiˀin, heḏi wíje senäˀ ivíˀpiye ovä̂nsan óetu̖ˀâ̖a̖míḏí, “Ti wesebo naˀindáḏí wíˀunˀä̖ä̖-ípíˀan, heḏi a̖ˀyu̖u̖gi giwáymú-í.” ");
INSERT INTO tew_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Heḏiho Peter wesebo ikhâyˀandi indáḏí namää. Iˀ tewhá ee dipówá ihayḏi oe whaˀkꞌay ívepiye óepiye. Tꞌä̖hkí in kwiyä̖ˀ dikwꞌóˀnin inbí senäˀ díntꞌahánnin Peter-ví núˀ diwindi diséejiˀ, heḏi ônkeejoˀ iˀ báyékí to-á kꞌéwéˀi aa-á Dorcas ipaaˀiˀ waˀ nawówájiˀ ihayḏiboˀ. ");
INSERT INTO tew_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter-di tꞌä̖hkí ovâypeejôndi idégeˀdisóge ijûusuˀa̖míḏí, heḏi ibéeḏí iˀ pení óemúndeḏi natú̖, “Tabitha, óshaa.” Iˀ kwee itsíwaaḏi Peter óemûˀḏi ishaasóge. ");
INSERT INTO tew_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter-di óemanyâ̖ˀḏi óekwi̖nukhä̖geˀnandá in kwiyä̖ˀdáḏí in wéˀgen Jôesiví tꞌowa-áḏí ovâytu̖hkánnan ditsꞌú̖u̖níḏí, heḏi iˀ kwee wíyá nawówápóeˀin ovâykeeyan. ");
INSERT INTO tew_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","In Joppa-win tꞌowa dínhanginpóe háa napóeˀin heḏi báyékí Nanbí Sedó Jesus-víˀpiye dívíwä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter ee Joppa nä́ˀi sen Simon gin nakhá̖wä̖́ˀivíˀwebo híwó hay thaa iwóyí̖ˀ. Simon-dá púje tä̖́vikandiˀ-ân namuu. ");
INSERT INTO tew_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Oe Caesarea búˀ wí sen Cornelius gin nakhá̖wä̖́ˀi nathaa. I-á tä̖gintä̖ (10) sundaḏoví tsondi namuu, heḏi iví sundaḏo-á “Italy-win” gin ovâytu̖ˀoˀin diweḏiˀin dimuu. ");
INSERT INTO tew_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I-áḏí iví kꞌaygiˀindáḏí hä̖̂ä̖ḏi wänbo Jôesi Táḏá óeˀaˀginmäˀ tobá Huḏíyo dimuupí wänboˀ, heḏi in sehkanäwó diwówájiˀin Huḏíyo tꞌowa hä̖́yú̖-anho ovâychä̖ˀmäˀ ovâykhä̖geˀnamíḏí, heḏá hä̖̂ä̖ḏi waa Jôesi Táḏávíˀpiye ijûusuˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wí thaa thíˀêeḏi poje iwáypiye nanândi, wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ Cornelius ûnpówáḏí keeˀeeḏi óemûˀ waagibá ûnpóe, heḏi óekhá̖yä̖́ˀ. ");
INSERT INTO tew_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelius hânho óepíhä̖ä̖, heḏi iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ óeḏamúndeḏi óetu̖ˀan, “Nanbí Sedó, háaḏan unˀä̖ä̖?” Heḏi iˀ tꞌôepa̖ˀa̖a̖ˀiˀḏi óetu̖ˀan, “Jôesi Táḏá uví jûusu natꞌoe, heḏá wóemûˀ in sehkanäwó diwówájiˀin tꞌowa ovâychä̖ˀmä́giˀin heḏiho háa biˀannin wíˀûnˀôeḏe-ípí. ");
INSERT INTO tew_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nää-á wên senäˀ Joppa búˀpiye u̖ˀḏi ovâysaaní, indá wí sen Simon gin nakhá̖wä̖́ˀiˀ óenuuwä̖́-í nä́wepiye óemáˀíḏí, iˀ sendá Peter gin wáˀ nakhá̖wä̖́. ");
INSERT INTO tew_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","I-á iwóyíndeˀ wí púje tä̖́vikandiˀ Simon ginbá nakhá̖wä̖́ˀiví tewhá ee, nä́ˀi tewhá-á mâapꞌoe núˀ nakꞌóe.” ");
INSERT INTO tew_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi Cornelius óehíˀbowa ihayḏi ijâaˀan, heḏi Cornelius-di wíje iví tewháˀin tꞌôeˀindá heḏá wí sundaḏo-á ovâytu̖hkánnan, nä́ˀi sundadoḏá hä̖̂ä̖ḏi waa Cornelius óekhä̖geˀdo heḏá Jôesi Táḏá óeˀaˀginmäˀ. ");
INSERT INTO tew_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Háa iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óetu̖ˀan waa Cornelius-di ovâythayyan, heḏáháˀ Joppa-piye ovâysan. ");
INSERT INTO tew_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wíyá tháwä́n taagepiye waˀḏi in senäˀ pꞌóegé dimändi, iˀ búˀ tsowa dipowamän dihayḏiboˀ, Peter oe whaˀkꞌaypiye napee ijûusuˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Naha̖hséhpóeḏí ihú̖u̖ya̖míˀin nadaˀ, hebo waˀ dâyhä̖ä̖háaˀoḏibo naˀä̖̂ä̖kꞌóe waagibá ûnpóe, heḏi makówá nakhuuḏeeˀin ûnkeepóe, heḏi wí hä̖ä̖wí nangepiye nawha̖veˀä̖ḏi imûˀ, i-á wên aa pháagíˀin waagiˀinbá namuu, heḏi jónu wéegé eeje nawhimuu. ");
INSERT INTO tew_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","In aa iwe tꞌä̖mägeˀin animâa hä̖ä̖wên dikwꞌôn, hä̖ä̖pandá pꞌoekanu-á pä̖́ä̖yu̖-á heḏá tsíḏé-á. ");
INSERT INTO tew_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Heḏi toˀwíḏí óehíˀmáaḏí natꞌoe ginnân: “Peter, ówí̖nú, ovâyhá̖nú hä̖ˀin heḏá ovâykꞌôe.” ");
INSERT INTO tew_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Hebo Peter natú̖, “Joe, háˀto, Nanbí Sedó. Naa hä̂nhay wänbo wíḏókꞌoepí hä̖ä̖wí nanbí khuu gínmuuḏi gínkhâ̖a̖kꞌóeˀiˀ, giˀbi hä̖ä̖wí khá̖a̖ˀi gin âytu̖máaˀiˀ.” ");
INSERT INTO tew_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Heḏá wíyá iˀ híˀ natꞌoe ginnân: “Wíˀúkhâyˀä̖hpí untú̖u̖níˀin nakhâ̖a̖kꞌóeˀin hä̖ä̖wí Jôesi Táḏá natú̖ˀi híwóˀdi namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Powin gin napóe, heḏi ihayḏi in aa pháagíˀin wesebo makówápiye óetege. ");
INSERT INTO tew_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter iˀánshaamáa hä̖ä̖-angú iˀ hä̖ä̖wí ûnkeepóeˀiˀ namuuˀin, heḏi ihayḏibá in senäˀ Cornelius-di ovâysannin wáy Simon-ví tewhá ûnkꞌóeˀin dâyshaa, heḏi oe tehpaa phóḏi dipówá. ");
INSERT INTO tew_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Heḏi ditu̖hkwínpóeḏí ditsikapóe, “Ti nä́we Simon Peter iwóyí̖ˀ?” ");
INSERT INTO tew_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Waˀḏi Peter iˀ hä̖ä̖wí ûnkeepóe i̖ˀgeḏi iˀánshaamáaḏí iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi óetu̖ˀan, “Ótꞌôeyanbe, poje senäˀdi wóetu̖wä̖máa. Nää-áho ówhanbe, heḏi ánshaaginpíḏíboˀ indáḏí ópûn. ");
INSERT INTO tew_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Naaḏân dovâytu̖ˀan nä́äpiye diˀä̖ä̖-íˀin.” ");
INSERT INTO tew_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Heḏi Peter in senäˀ dijiˀ iwepiye nawân heḏi ovâytu̖ˀan, “Naa-ân iˀ omuu undi dítu̖wä̖máaˀiˀ. Háaḏan íˀä̖ä̖?” ");
INSERT INTO tew_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","In senäˀdi óetu̖ˀan, “Cornelius-dáho naˀin dísan, i-á sundáḏoví tsondi namuu. I-á iví wówátsi taˀge ihon, Jôesi Táḏá óeˀaˀgin, heḏi iví̖ˀgeḏi in Huḏíyo tꞌä̖hkí híwó dívíhéeˀoˀ. Wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi óetu̖ˀan u̖ wóetu̖ˀâ̖a̖míḏí iví tewhá eepiye unmú-íḏí, heḏânho wí híˀ uvíˀweḏi natꞌoe-íḏí.” ");
INSERT INTO tew_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Heḏiho Peter-di ovâytu̖ˀan ditsꞌú̖u̖ní gin, iwebo dívíwhoˀkwꞌôeníḏí iˀ khun. Heḏi iˀ tháwä́ndá héˀḏibo Peter ishaaḏi ipikhâyˀan, heḏi indáḏí namää, heḏá wên Joppa-win Jesus-víˀpiye dívíwä̖yundeˀindá wáˀ dimää. ");
INSERT INTO tew_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wíyá tháwä́ndá oe Caesarea dipówá. Cornelius-áho ivíˀwe natsíkhaˀä́n, iví ây-á maatuˀindá kꞌemaˀindá ovâywéˀgeˀannin wóegé. ");
INSERT INTO tew_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","In Peter-ˀin tꞌä̖hkí iˀ tewhá ee dipówá ihayḏi Cornelius-di óesengitu̖ˀan, heḏi Peter-ví páaḏépiye idégeˀdisóge óeˀaˀgeeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Hebo Peter-di óekwi̖nukhä̖geˀnan, heḏi óetu̖ˀan, “Ówí̖nú, u̖ˀ waagibá naa wí tꞌowaḏa̖ˀmân omuu.” ");
INSERT INTO tew_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Heḏi dänhíˀhondi iˀ tewhá íve datsꞌú̖. Peter-di in báyékí tꞌowa iwe diwéˀgekwꞌóˀnin ovâymûˀ, ");
INSERT INTO tew_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","heḏi ovâytu̖ˀan, “Ti wíˀúnhanginnáhpíˀan wí Huḏíyo ûnkhâ̖a̖kꞌóeˀin iví khuu ûnmuuḏi piˀwên tꞌowa-áḏí iwóeníˀin heḏá inbíˀpiye naˀáḏâamú-íˀindá? Hebo Jôesiḏi naa nä́ˀin díhá̖ˀan: Naa wíḏînkhâyˀä̖hpí otú̖u̖níˀin wây-á tꞌowa híwóˀnin wíḏimuupíˀin háa naa dînkhâ̖a̖kꞌóeˀin indáḏí dáywóeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Heḏânkun nä́wepiye oˀä̖ä̖-íḏí dídaaˀandi naa ‘joe’ gin wóˀtú̖hpí. Heḏi nää-á dítu̖ˀâ̖a̖mí háaḏí u̖ˀḏi dítu̖hkánnannin.” ");
INSERT INTO tew_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius-di óetu̖ˀan, “Poje thaa phaḏe poje iwe thíˀêeḏi, nää waabá naná, heḏi naví tewhá ee dáyjûusuˀoḏi oˀä́n, heḏi tsíkhagipí wí sen otsꞌáˀi aa natoˀondi dînkeepóe, heḏi naví hânge nakwi̖nuḏee. ");
INSERT INTO tew_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Iˀḏi naa dítu̖ˀan, ‘Cornelius, Jôesi Táḏá uví jûusu natꞌoe, heḏá iˀ hä̖ä̖wí u̖ˀḏi in sehkanäwó diwówájiˀin ovâymä́giˀiˀ imûˀ, heḏi háa biˀoˀin háˀto ûnˀôeḏe-í. ");
INSERT INTO tew_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nää-á wí toˀwí oe Joppa-piye násân, Simon óetu̖ˀâ̖a̖míḏí uvíˀpiye naˀä̖ä̖-íḏí, i-á Peter gin wáˀ nakhá̖wä̖́. Wí púje tä̖́vikandiˀvíˀwe naˀä́n, i-á Simon ginbá nakhá̖wä̖́, heḏi mâapꞌoe núˀ nathaa.’ ");
INSERT INTO tew_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Heḏiho wesebo wên senäˀ dovâysan wóetu̖hkánnamíḏí, heḏi u̖-á wesebo unˀä̖ä̖ḏi híwó biˀan. Nää-á nä́we tꞌä̖hkí gikwꞌó, heḏá Jôesi Táḏá-á wáˀ nä́we naˀindáḏíbá naˀä́n. Nää gikwꞌó ívítꞌôeyaaníḏí hä̖ä̖wí tꞌä̖hkí háa Nanbí Sedó Jôesi Táḏáḏí wóetu̖ˀan waa naˀin dítꞌôeˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Heḏi ginnân Peter natú̖: “Nää naa dînhanginná taˀgendi Jôesi Táḏáḏí tꞌowa tꞌä̖hkí handa̖ˀ ovâymáaˀin. ");
INSERT INTO tew_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tꞌä̖hkí toˀwên iˀ dâyˀaˀginnin heḏá híwó dívíˀoˀindá iˀḏi ovâysígíhóndeˀ, tobá wä̖́hä̖̂ä̖win dimuu wänboˀ. ");
INSERT INTO tew_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Iˀḏi iví tun in Israel tꞌowa ovâymä́gi, heḏi ovâytu̖ˀan dínkoḏi i-áḏí dívíwóeníḏí Jesus Christ iˀandi namuuḏi, i-á tꞌowa tꞌä̖hkígîˀ shánkí natsonjiˀi-ân namuu. ");
INSERT INTO tew_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Un únhanginná háa tíˀúugéḏí napóeˀin oe Galilee nange heḏá hä̖́yú̖ Judea nange nanáˀ tꞌä̖hká, John iˀ pꞌóˀpꞌoekandiˀḏi in tꞌowa dipꞌóˀpꞌoepúuwíˀin ovâytu̖ˀan dihayḏi. ");
INSERT INTO tew_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Únhanginná Jôesi Táḏáḏí iví Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ ônsannin Jesus Nazareth-wiˀ, heḏânho Jesus-áho óesógeˀin ikeeya̖míḏí heḏá in pínnándá óemä̂äníḏá, heḏi Jôesi Táḏá i-áḏí najiḏi Jesus-di híwó in tꞌowa ovâyˀoˀ wáy namää wänboˀ, heḏá hä̖́yú̖ iˀ Penísendiḏi ovâytꞌôephaḏekannannin hehkháa ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Hä̖ä̖wí Jesus-ví̖ˀgeḏi gínhanginnáˀdi naˀindi tꞌowa âytꞌôeˀoˀ, háa iˀan waa ee Jerusalem búˀ heḏá iˀ wéˀgeˀi búˀây in Huḏíyoví nange tꞌä̖hká nanáˀdiˀ. I-á óetꞌóhtä̖gekꞌûˀḏi óehay. ");
INSERT INTO tew_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","I-ânkun iˀ namuu Jôesi Táḏáḏí óewáywówápaaˀiˀ, heḏi dînkeeyan iˀ powageˀi thaa nachuu iweḏi wíyá nawówápóeˀin. ");
INSERT INTO tew_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tꞌä̖hkí tꞌowaḏá wíˀóemûˀpí, hebo naˀin iví̖ˀgeḏi ívíhéeˀa̖míḏí páaḏébo dídeˀmannindânho iˀ âymûˀ. Wíyá nawówápóe ihayḏi i-áḏí ívíhú̖u̖yan. ");
INSERT INTO tew_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Heḏi iˀḏi naˀin díjôn Jôesi Táḏáví tun in tꞌowa âytunphaaḏé-íḏí, heḏá âytu̖ˀâ̖a̖míḏá taˀgendi i-ânkun namuu Jôesi Táḏáḏí óesógeˀiˀ tꞌä̖hkí tꞌowa ovâykeekwꞌôeníḏí háa híwó háa híwóhpí dívíˀannin, wíˀgíngí in ho dichuuˀindá in waˀ diwówájiˀindá. ");
INSERT INTO tew_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tꞌä̖hkí Jôesi Táḏáví tukheˀmindi dítu̖ˀan, tꞌä̖hkí toˀwên Jesus-víˀpiye dívíwä̖yundeˀinbí tꞌaywóˀdi dínˀowóˀjen. Jesus-ânkun ônkꞌûˀ gin dînˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Waˀḏi Peter-di gin ovâytu̖máaḏí iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ nawá̖ tꞌä̖hkí in iví híˀ ôntˀôeyandeˀinbíˀwepiye. ");
INSERT INTO tew_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Heḏi in Huḏíyo Jesus-víˀpiye dívíwä̖yundeˀin Peter-áḏí diˀä̖ä̖ˀin hânho ovâyháaˀan, iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ in Huḏíyo dimuupíˀin wáˀ báyékíbo ovâymä́giḏi. ");
INSERT INTO tew_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dínhanginpóe ovâymä́giˀin inbí híˀ ho ditꞌoeḏi, gá piˀwí tundi dívíhéeˀoḏân, heḏá Jôesi Táḏá ívíwo hayˀi namuu gin ditû̖ˀdá. ");
INSERT INTO tew_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Heḏi Peter-di in i-áḏí diˀä̖ä̖ˀin ovâytu̖ˀan, “Nä́ˀin tꞌowa-á iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dâykêˀ, naˀin iˀ âykêˀ waabá. Heḏânkun tóebo wíˀûnkꞌóepí ovâykhâ̖a̖ˀa̖míḏí pꞌoeḏi ovâypꞌóˀpꞌoeˀa̖míˀin, hewä̖.” ");
INSERT INTO tew_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Heḏiho in Cornelius-ˀin ovâytu̖ˀan dínkhâyˀä̖ˀ dipꞌóˀpꞌoepúuwíˀin, dâykeeya̖míḏí Jesus Christ-víˀin dimuuˀin. Heḏáháˀ indi óedaaˀan wí hä̖́yú̖ thaa indáḏí iwóyí̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","In Jesus-ví tꞌôekhuwaˀindá heḏá in wéˀgen Jesus-víˀpiye dívíwä̖yundeˀin oe Judea tꞌä̖hkí dikwꞌóˀnindá dínhanginpóe in Huḏíyo dimuupíˀin tꞌowa wáˀ Jôesi Táḏáví híˀ iwe dívíwä̖yu̖ˀin. ");
INSERT INTO tew_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Hebo wáy wên tꞌowa Jerusalem búˀwin dichanpóe tꞌä̖hkí tꞌowa Jesus-víˀpiye dívíwä̖yundeˀin dínkhâyˀä̖ˀ in Huḏíyoví khuu wáˀ dâyhûuwíˀin. Heḏiho Peter Jerusalem-piye namää ihayḏi indi óetu̖ˀan, “Hä̖ä̖wí gínkhâ̖a̖kꞌóeˀi biˀan. Heháaḏan in Huḏíyoví kꞌewe taa dâymáapíˀin tꞌowavíˀwe unjiˀ, heḏá indáḏá bihú̖u̖yan?” ");
INSERT INTO tew_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Heḏi Peter-di ovâythayyan tꞌä̖hkí háa páaḏé iweḏibo napóeˀin. ");
INSERT INTO tew_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ginnân natú̖: “Oe Joppa búˀ oˀä́n dihayḏi naa dáyjûusuˀoˀ, heḏi oˀä̖̂ä̖kꞌóe waagibá dînpóeḏí wí hä̖ä̖wí dînkeepóe. Wên aa pháagîn waaginbá namuuˀin makówáḏí nawândi dînkeepóe, jónu wéegé eeje nawhimuuˀin, heḏá naví núˀ dînpówá. ");
INSERT INTO tew_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Heḏi híwó in aa phoge dómûˀ, heḏi tꞌä̖mägeˀin hä̖ä̖pandá pꞌoekanu-á pä̖́ä̖yu̖-á tsíḏé-á dovâymûˀ. ");
INSERT INTO tew_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Heḏi toˀwíḏí díhíˀmáaḏí otꞌoe. Ginnân dítu̖ˀan: ‘Peter, ówí̖núḏí ovâyhá̖nú hä̖ˀin heḏá ovâykꞌôe.’ ");
INSERT INTO tew_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Hebo naa-á otú̖, ‘Joe, háˀto Nanbí Sedó. Hä̂nhay wänbo naví sóphoge wíḏótógipí wí hä̖ä̖wí nanbí khuu gínmuuḏi gínkhâ̖a̖kꞌóeˀiˀ, giˀbi hä̖ä̖wí khá̖a̖ˀi gin âytu̖máaˀiˀ.’ ");
INSERT INTO tew_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Hebo oe makówáḏí wíyá iˀ híˀ otꞌoe, gin: ‘Wíˀúkhâyˀä̖hpí untú̖u̖níˀin nakhâ̖a̖kꞌóeˀin hä̖ä̖wí Jôesi Táḏá natú̖ˀi híwóˀdi namuuˀin.’ ");
INSERT INTO tew_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Powin gin napóe, heḏá hä̖ä̖ tꞌä̖hkí makówápiye óewáytege. ");
INSERT INTO tew_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ihayḏibáho poje senäˀ Caesarea búˀ iweḏi ovâysannin iˀ tewhá ee oˀä́n diwe dipówá. ");
INSERT INTO tew_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Heḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi dítu̖ˀan, ‘Ánshaaginpíḏíboˀ indáḏí ópûn.’ Wên sí tíˀûuwin páaḏéˀindá wáˀ naa-áḏí dimää, heḏi iˀ sen dítu̖hkánnandiví tewhá ee gitsꞌú̖. ");
INSERT INTO tew_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Iˀḏân naˀin dítu̖ˀan wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ iví tewhá íve nawindi óemûˀ, heḏi iˀ tꞌôepa̖ˀa̖a̖ˀiˀḏi ginnân óetu̖ˀan: ‘Wên senäˀ oe Joppa-piye ovâysân nä́ˀi Simon nä́we óemáˀíḏí, i-á Peter gin wáˀ nakhá̖wä̖́. ");
INSERT INTO tew_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iˀḏibá wovâytꞌôekankhâymáa háḏíḏí u̖-á heḏá hä̖́yú̖ uví kꞌaygiˀindá wovâyˀaywoeníˀin.’ ");
INSERT INTO tew_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Cornelius-di naa díhíˀbowa ihayḏáháˀ naaḏá dovâyhéeˀan. Waˀḏi báyékí otú̖hpíḏíbo iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ inbíˀwepiye nawân, páaḏé naˀin gínpóe waagibá. ");
INSERT INTO tew_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Heḏi dînˀánpówá iˀ to híˀ Nanbí Sedó Jesus hä̖̂ä̖ḏi wänbo natû̖ˀdiˀ, gin: ‘John-di tꞌowa pꞌoeḏiḏa̖ˀ ovâypꞌóˀpꞌoeˀan, hebo undá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-á bînkáyjí wí pꞌóˀpꞌoekan waagibá.’ ");
INSERT INTO tew_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jôesi Táḏáḏí iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ ovâymä́gi, heḏá hanbá naˀin dímä́gi, Nanbí Sedó Jesus Christ-víˀpiye ívíwä̖yu̖ ihayḏi. Heḏiho hä̖ä̖-an naa omuu, ti naa dînkꞌóe Jôesi Táḏá dówóyí̖ˀníḏí? Naa-á joe.” ");
INSERT INTO tew_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Heḏiho in tꞌowa háa Peter-di ovâytu̖ˀannin ditꞌoe ihayḏi wíyá wíḏitú̖hpí híwóhpí iˀannin. Ditú̖, “Jôesi Táḏá hânho hayˀi namuu. Iˀḏi in Huḏíyo dimuupíˀin tꞌowa wáˀ ovâykhä̖geˀnan inbí tꞌaywóˀdi dâyjoeˀa̖míḏí, wówátsi nahándepíˀin dâymáˀve-íḏí.” ");
INSERT INTO tew_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephen óehay ihayḏi pha̖a̖piyeḏi in Jesus-víˀpiye dívíwä̖yu̖ndeˀin ovâyjänäkíˀoˀ heḏiho tꞌä̖mäpiye dishavemää. Wáy wên oe Phoenicia nangepiye dimää, wây-á oe Cyprus nangepiyá, heḏá wây-á oe Antioch búˀpiyá. Eeje indi in Huḏíyo tꞌowaḏa̖ˀmânho Jesus-ví̖ˀgeḏi ovâytu̖ˀan, in Huḏíyo dimuupíˀin tꞌowa-á joe. ");
INSERT INTO tew_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Hewänbo wáy wên in dijáˀnin senäˀdáho oe Antioch búˀpiyebá dimäaˀindá in Huḏíyo dimuupíˀin wáˀ Nanbí Sedó Jesus-ví̖ˀgeḏi ovâytꞌôeˀoˀ. Nä́ˀin senäˀdá Cyprus-windá heḏá Cyrene-windá dimuu. ");
INSERT INTO tew_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Heḏi Nanbí Sedó Jôesi Táḏáḏí nä́ˀin senäˀ ívíwo ovâykaymä́giḏi híwóhay tꞌowa Nanbí Sedó Jesus-víˀpiye dívíwä̖yu̖ḏi ivíˀpiyá dívímä́gi. ");
INSERT INTO tew_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Oe Jerusalem in méesateˀin tꞌowa háa oe Antioch napóeˀin dínhanginpóe, heḏiho iwepiye Barnabas óesan. ");
INSERT INTO tew_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnabas-á híwóˀdi sen namuu, heḏi pín taˀgeḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-á imáa, heḏi ívíwo Jesus-víˀpiye iwä̖yu̖. Heḏi oe Antioch napówá ihayḏi imûˀ hânho híwóˀdi Jôesi Táḏáḏí ovâyˀoˀin, heḏiho nahíhchanpóe, heḏi ovâytumakheˀan pín taˀgeḏi Nanbí Sedó Jesus-áḏí dimúuníḏí. Báyékí tꞌowa Nanbí Sedó Jesus-víˀpiye dívítsꞌanwä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","26","Ihayḏáháˀ Barnabas-á Antioch iweḏi oe Tarsus búˀ nanáˀ diwepiye namää Saul óenuuwä̖́-íḏí, heḏi óeshaa ihayḏi oe Antioch eepiyebá óemaa. Iwânho indá heḏá in wéˀgen méesateˀin tꞌowa-á wí pa̖a̖yo tꞌä̖hkí dívíwéˀgeˀoˀ, heḏi in wíjeḏi báyékí tꞌowa ovâyhá̖ˀan. Ee Antioch in Jesus-víˀpiye dívíwä̖yundeˀin páaḏé ovâytsꞌankhá̖yä̖́ˀ “Christian” gin. ");
INSERT INTO tew_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ihayḏibá wên Jôesi Táḏáví tukheˀmin Jerusalem diweḏi oe Antioch-piye dimää. ");
INSERT INTO tew_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wí wêe in diweḏi Agabus gin nakhá̖wä̖́ˀiˀ iwí̖nú, heḏi in méesateˀin tꞌowa ovâytu̖ˀan, “Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi naa dînhanginˀânnan diha̖a̖puwagíˀoˀin wä̖́hä̖̂ä̖ tꞌä̖hkí.” Háa Agabus natú̖ waa taˀgendi napóe Claudius natsondimuu ihayḏi. ");
INSERT INTO tew_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Heḏiho in Antioch-win Jesus-víˀpiye dívíwä̖yundeˀin tꞌä̖hkí dâywéhpêeˀan hä̖́yú̖ dínkoḏi ihay inbí chä̖ˀ dâywéˀgeˀa̖míˀin, in tíˀûuwin páaḏéˀin oe Judea dithaaˀinbíˀwepiye ovâysaaníḏí. ");
INSERT INTO tew_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Heḏiho han dívíˀandi Barnabas-áḏí Saul-áḏí iˀ chä̖ˀ ovä̂nˀan, heḏi indá in Jerusalem méesateˀin tsonninbíˀwepiye dä̂nhoˀ. ");
INSERT INTO tew_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ihayhä̖̂ä̖ han napoeˀo iwáyḏí iˀ nangewi tsondi Herod wên méesateˀin tꞌowa ovâyjänäkíˀa̖míḏí natsonpóe. ");
INSERT INTO tew_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Heḏá wáˀ natsonpóe James wí tsijó pháˀḏí óeháyjíḏí, i-á John-bí páˀḏây ûnmuu. ");
INSERT INTO tew_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herod ûnhanginpóe háa iˀannindi in Huḏíyo ovâyhíhchannannin, heḏiho Peter wáˀ óepankáyjíḏí natsonpóe. Gin iˀan nä́ˀi Huḏíyoví shánkíˀeeḏi dínnáˀ dihayḏi, “Oewáaseepîˀ pává koe shánkíˀeeḏi” gin dâytu̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peter óeyâ̖ˀḏi óepansóge, heḏi tä̖ˀḏi sí (16) sundaḏoḏi óeˀá̖yînmáa, jóˀnängin dívíˀegóˀoˀ. Iweḏânho iˀ Huḏíyoví shánkíˀeeḏi Passover gin dâytu̖ˀo naphaḏe ihayḏi, Herod-di Peter óepiyekhâymáawän in tꞌowaví páaḏépiye ôntunjóˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hebo waˀḏi Peter napannä́n dihayḏi, in méesateˀindi ihayḏa̖ˀ ônjûusuˀoˀ Jôesi Táḏáḏí óekhä̖geˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Khu̖ˀḏéeḏí naná, heḏi wíyá tháwä́n héḏénpiye Herod-di Peter óepiyekhâymáawän. Perer-á nakaḏénawhimuu wíje sundaḏoví jáagé, heḏi handiḏi najóˀkꞌóe. In wây-á wíje sundaḏo-á oe pan tewhá jáˀwéˀin phóḏi iwe daˀá̖yînwin. ");
INSERT INTO tew_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tsíkhagipí wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ iwe nakwi̖nuḏee, heḏi pan tewhá íve nakohkeepóe. Iˀ makówási tꞌôepa̖ˀa̖ˀiḏi Peter kꞌuuwoe eeḏi óewáḏáˀandi óekhehshaa, heḏi óetu̖ˀan, “Ówä̖́näkiˀ, óshaa.” Heḏi iˀ kaḏéna khóe eeje nawhimuuˀiˀ ûnwhihsuu. ");
INSERT INTO tew_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Heḏi Peter óetu̖ˀan, “Uví sibaˀáa-áḏí uví anto-áḏí ótoˀ.” Heḏiho Peter han iˀan. Heḏáháˀ óetu̖ˀan, “Nää-á uví kꞌéwéˀin to-á wáˀ ótoˀ, heḏi naví tíˀúugé unwóeˀä̖ä̖-í.” ");
INSERT INTO tew_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Heḏiho Peter pan tewhá iweḏi i-áḏí napee, hebo wíˀûnhanginnáhpí háa iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀi iˀoˀin taˀgendi napoeˀoˀin háa háḏéewáy iví ánshaa iwe waagi nä́ˀi hä̖ä̖wí imúndeˀin. ");
INSERT INTO tew_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wêe sundaḏo naˀá̖yînwin diwe daphaḏe, heḏá wíyá wêe-á, heḏáháˀ in kwä̖́kꞌu phóḏi iwe dapówá, iˀ búˀ pꞌóegé iwe nacháˀnin. In phóḏi wíˀbo napikhuuḏee. Heḏi dapee, heḏi wéhpêe pꞌôe daphaḏe, ihayḏáháˀ iˀ makówáwi tꞌôepa̖ˀa̖a̖ˀi wáypiye napóeḏí Peter wíˀbo óejoeˀan. ");
INSERT INTO tew_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nää-á Peter ûnhanginpóe nä́ˀi hä̖ä̖wí taˀgendi ûnpóeˀin, ä̖̂ä̖ḏa̖ˀ wínamuupí, heḏi ginnân iˀánshaaˀan: “Näbâa dînhanginná taˀgendi Nanbí Sedó Jôesi Táḏá iví tꞌôepa̖ˀa̖a̖ˀi isan naa Herod-ví mangeḏi heḏá in Huḏíyo tꞌowavíˀweḏá dînˀaywoeníḏí, heḏânho háawên jänäkíˀin dikandaˀin wíḏíˀa̖mípíḏí.” ");
INSERT INTO tew_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ihayḏáháˀ John Mark-ví jíyá Mary-víˀpiye namää. Ee-á hä̖́yú̖-anho tꞌowa dívíjûusuˀoḏi dikwꞌó. ");
INSERT INTO tew_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Napówá ihayḏi in jáˀwéˀin tehpaa phóḏi iwe ipópóˀan, heḏi wí tewhá tꞌôeˀi aˀyú̖, Rhoda gin nakhá̖wä̖́ˀi namää imúuníḏí to-angú namuu. ");
INSERT INTO tew_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Peter ihéeˀandi natꞌoeḏi iˀ aˀyú̖ wese ûnhanginná toˀwí namuuˀin. Hânho nahíhchanpóeḏí in phóḏi ihuu-ívíˀweḏi oe ívepiye iˀä̖ä̖tsꞌúḏe in tꞌowa ovâytꞌôeˀa̖míḏí, “Peter oe jáˀwé tehpaa phóḏi iwe nawin.” ");
INSERT INTO tew_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Indi óetu̖ˀan, “U̖-ân unbondoemuu.” Hebo iˀ aˀyú̖-á iheˀjiḏiḏa̖ˀ natû̖ˀ, “Háa wâytu̖ˀan waa taˀgennânkun namuu.” Indi óetu̖ˀan, “Háḏéewáy wí makówáwi tꞌôepa̖ˀa̖a̖ˀi namuu, Peter óeˀá̖yînmáaˀiˀ.” ");
INSERT INTO tew_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Waˀḏi dívíhíˀmáaḏíbo Peter-á iheˀjiḏiḏa̖ˀ ipópóˀoˀ, heḏi in phóḏi dâyhuu ihayḏi toˀwí namuuˀin dâymûˀḏi ovâyháaˀan. ");
INSERT INTO tew_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peter imannan ditu̖há̖a̖níḏí, heḏi ovâytꞌôeˀan háa Nanbí Sedó Jôesi Táa iví makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ isan waa iˀ pan tewhá iweḏi óepeeyé-íḏí. Heḏáháˀ ovâytu̖ˀan, “James-á heḏá in wéˀgen tíˀûuwin páaḏéˀindá bintˀôeˀan háa dînpóeˀin.” Heḏi iweḏi wíyá wáypiye namää. ");
INSERT INTO tew_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nahéˀḏénpóe ihayḏi in sundaḏo hânho díntû̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","“Wáyho Peter?” gin dívítsikaˀmáa. Herod natsonpóe dâynuuwä̖́-íḏí, hebo wíˀóeshaapí. Heḏiho Herod-di in á̖yí̖ˀnin ovâytsikaˀyan háa napóeˀin, heḏi in wíḏínhanginnáhpíḏí natsonpóe ovâyhá̖a̖nú-íḏí. Ihayḏáháˀ Herod-dá Judea nange iweḏi oe Caesarea búˀpiye namää, heḏi wí hä̖́yú̖ thaa iwe iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod hânho natꞌay in tꞌowa Tyre-á Sidon-dá dithaaˀinbíˀpiye. In tꞌowa nä́ˀin wíje búˀwin Herod-ví nange iweḏi inbí húugîˀ dínˀä̖ä̖ˀä̖, heḏânho dívíwéˀgeˀan dívíhéeˀa̖míḏí, heḏáháˀ wên senäˀ ivíˀpiye ovâysan. Indá Herod-ví tewhá ee pꞌóˀḏéḏîˀ tꞌôeˀi-áḏí dívíkꞌemaˀan, i-á Blastus gin nakhá̖wä̖́, heḏi iˀ óetu̖ˀan Herod óedaaˀa̖míḏí wíyá indáḏí wínatꞌay-ípíḏí. ");
INSERT INTO tew_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herod wí thaa ovâyhéeˀa̖míḏí ideˀman. Iví tsondiwi aa iˀawe, heḏáháˀ iˀ tsondi púwéḏé eeḏi isóge, heḏi thaa tꞌä̖hkí in tꞌowa ovâyhéeˀan. ");
INSERT INTO tew_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ihíˀmáa ihayḏi in tꞌowa ginnân dívítu̖wí̖núndeˀ, “Jôesiḏân díhíˀmáa waagibá natꞌoetꞌóe, wí sendiḏa̖ˀbá joe.” ");
INSERT INTO tew_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wesebo Nanbí Sedó Jôesi Táḏáḏí wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀ óesan Herod óehayˀámíḏí, heḏi pubä́ḏí iví see ônkꞌoeḏiho nachuu. Han ûnpóe iḏi in tꞌowa wíˀovâytu̖ˀanpíḏí Jôesi Táḏáḏa̖ˀmân hayˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Hewänbo báyékí tꞌowa Nanbí Sedó Jôesi Táḏáví tun shánkí wänbo ditꞌoeˀo, heḏá báyékí ônsígíhóndeˀ. ");
INSERT INTO tew_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ihayhä̖̂ä̖bá Barnabas-á Saul-áḏí inbí tꞌôe oe Jerusalem dä̂nbowa, iˀ chä̖ˀ in méesateˀin tsonnin ovâymä́giḏi, heḏi iweḏi oe Antioch-piye dawáymää. John wáˀ indáḏí dä̂nhoˀ, i-á Mark gin wáˀ nakhá̖wä̖́. ");
INSERT INTO tew_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Oe Antioch búˀ iwe in wéˀgen méesateˀindáḏí wên Jôesi Táḏáví tukheˀmindá heḏá wên iví híˀ ovâyhá̖ˀoˀindá dijiˀ. Ginnân dikhá̖wä̖́: Barnabas-á, Saul-á, Simeon-dá (i-á “Phéndi Sen” gin óetu̖ˀoˀ), Lucius-á (i-á Cyrene nangeˀi namuu), Manaen-dá (i-áḏí heḏá iˀ tsondi Herod-áḏí wéˀge dasôe). ");
INSERT INTO tew_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wí thaa diwéˀgekwꞌó Nanbí Sedó Jôesi Táḏá óeˀaˀginmä̂äníḏí heḏá dívíha̖a̖ḏä́ˀa̖míḏá, heḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi ovâytu̖ˀan, “Naaḏi Barnabas-á Saul-áḏí dovä̂ndeˀman wí tꞌôe hä̖ä̖wí dînˀa̖míḏí. Nää-á undá in wíjebá bînsôege-í han dänˀa̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Heḏiho wíyá dívíha̖a̖ḏä́ˀan, heḏi in wíjevîˀḏi dívímankwˀóḏiḏi ovä̂njûusuˀan, heḏi ovä̂nsan. ");
INSERT INTO tew_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Heḏiho Barnabas-á Saul-áḏí damää, iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi ovä̂ntu̖ˀan waa. John Mark wáˀ indáḏí najiˀ ovä̂nkhä̖geˀnamíḏí. Oe Seleucia búˀpiye dimää, iweḏáháˀ kophé iweḏi wí pꞌojâaḏi Cyprus gin dâytu̖ˀoˀ iwepiye dimää. Heḏi Salamis búˀ-á dipówá, heḏi iwe Jôesi Táḏáví tun in Huḏíyoví méesate eeje ovâytꞌôeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","In poje senäˀ nä́ˀi pꞌojâaḏi i̖ˀge tꞌä̖hkí dijiˀ, ihayḏáháˀ oe Paphos búˀ dipówá. Iwe wí Huḏíyo sen óemûˀ, Bar-Jesus gin nakhá̖wä̖́ˀiˀ (Greek tundi “Elymas” gin nakhá̖wä̖́). I-á pínnándi namuu heḏi natû̖ˀ i-á Jôesi Táḏáví tukheˀbi-ân namuu, hewänbo ihójomáa. ");
INSERT INTO tew_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nä́ˀi sendá iˀ nangewi tsondi Sergius Paulus-ví kꞌema ûnmuu. Sergius Paulus-á hânho há̖ˀi sen namuu, heḏi Jôesi Táḏáví híˀ natꞌôeyandaˀḏi Barnabas-á Saul-á ovä̂ntu̖hkánnan. ");
INSERT INTO tew_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Hebo nä́ˀi pínnándi nadaˀ ovä̂nkhâ̖a̖ˀa̖míḏí, heḏânho iˀ tsondiˀ óetu̖máa, “Wíviwä̖ä̖yú̖-ípí háa wóetu̖máaˀin.” ");
INSERT INTO tew_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Heḏi Saul (nää Paul gin wáˀ óekhá̖yä̖́ˀdeˀ) iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ pín taˀgeḏi imáa, heḏi tsíhtáye Elymas óeḏamúndeˀ, ");
INSERT INTO tew_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","heḏi óetu̖ˀan, “U̖-á Penísendiví ay-ân kavêe unmuu, u̖-á wí hójoˀiḏa̖ˀ unmuu, hä̖ä̖wí biˀoˀi-á yä̖ˀḏâapîˀḏa̖ˀ namuu, hä̖ä̖wí híwóˀdi namuuˀi-á nâatꞌay, u̖-á Jôesi Táḏáví taˀgeˀin pꞌôe mânmäägiˀa̖míˀin undaˀ. ");
INSERT INTO tew_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nää-á ótꞌôeyanbe, Nanbí Sedó Jôesi Táḏáḏá wóetuhchä̖nukhâymáa, heḏânho untsíˀtꞌaapúuwí, heḏá ívíwo hay thaa iˀ than wänbo wí hí̖yä̖̂ä̖ wänbo wínâamúunípí.” Paul ihíˀbowa ihayḏi wesebo Elymas-ví tsée iwe ûnkhaaḏeeḏi tꞌä̖hkí ûnkhunpóe, heḏi oepiyá nä́äpiyá najiḏi wí toˀwí óetu̖wä̖máa óepaamáˀve-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Háa Elymas ûnpóeˀin iˀ tsondiḏi óemûˀ ihayḏi Jôesi Táḏáví tun iwä̖yu̖. Iˀ hä̖ä̖wí Nanbí Sedó Jôesi Táḏáví̖ˀgeḏi nahá̖hpóeˀiˀḏi óeháaˀan. ");
INSERT INTO tew_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul-áḏí iví kꞌemaˀindáḏí Paphos-di kophé iweḏi dimää, heḏi oe Pamphylia nange iwe Perga búˀ dipówá. Iwe John Mark-di Paul-á Barnabas-á ovä̂njoeˀan heḏáháˀ i-á Jerusalem-piye nawáymää. ");
INSERT INTO tew_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perga iweḏi in wíje damää, heḏáháˀ Antioch búˀ oe Pisidia nange dapówá. Heḏi kaykhanwówá thaa in Huḏíyoví méesateˀay ee datsꞌú̖ Jôesi dä̂nˀaˀginmä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wí toˀwí wí hä̖́yú̖ háa Moses itaˀnan diweḏi itunnan, heḏá wíyá toˀwí-á hä̖́yú̖-á in Jôesi Táḏáví hä́nˀoeˀin tukheˀmin dâytaˀnan diweḏá itunnan. Dä̂ntunkanbowa ihayḏi in méesate pꞌóˀḏéḏíˀindi toˀwí óetu̖ˀan Barnabas-á Saul-áḏí ovä̂ntu̖ˀa̖míḏí, “Tíˀûuwin páaḏéˀin, ti wên tumakhe wänbo nä́ˀin tꞌowa ovâymä̂äní? Dadaˀḏáho nää ovâyhéeˀa̖mí.” ");
INSERT INTO tew_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Heḏiho Paul iwí̖núḏí imannan dívítꞌôeyaaníḏí, heḏi ginnân ovâytu̖ˀan: “Un Israel tꞌowa, heḏá un wéˀgen tꞌowa Jôesi bînˀaˀginmäˀindá, bítꞌôeyanbe. ");
INSERT INTO tew_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Naˀin Israel tꞌowa Jôesi Táḏávíˀpiye ívíwä̖yundeˀ, heḏi hä́nˀoeboˀ iˀḏân nanbí thehtáy pahpáˀin dîndeˀman, heḏá oe Egypt nange dithaa ihayḏi ovâykhä̖geˀnan dívíˀâytꞌowasôewé-íḏí, tobá iwewin wíḏimuupí wänboˀ, heḏáháˀ iví kayḏi hä̖ˀi nange iweḏi ovâypiye. ");
INSERT INTO tew_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Heḏi jónä́ntä̖ pa̖a̖yo ahkon niˀge dijiˀ ihayḏi ovâyˀá̖yîngiˀan. ");
INSERT INTO tew_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Heḏi Jôesi Táḏáḏí ovâykhä̖geˀnan tsé ihay hä̖̂ä̖geˀin tꞌowa nä́ˀi nange Canaan gin dâytu̖ˀan diwe ovâyhá̖a̖nú-íḏí, heḏáháˀ iˀḏi in Israel tꞌowa Canaan ovâywije. ");
INSERT INTO tew_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Jónä́n tä̖gintä̖ḏáháˀ pꞌánä́ntä̖ (450) pa̖a̖yo óehoˀ nä́ˀi tꞌä̖hkí napúuwíḏí. “Iweḏáho Jôesi Táḏáḏí ovâytsonninkwꞌóeˀó, iví tukheˀbi Samuel óesóge puwahay. ");
INSERT INTO tew_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Heḏi in tꞌowaḏi Samuel óedaaˀan wí kwꞌáyeˀi tsondi ovâysôege-íḏí, iˀ wéˀgeˀi nangeˀin tꞌowa dínˀä́n waagibá, heḏiho Jôesi Táḏáḏí Saul ovâymä́gi, i-á Kish-ví ay ûnmuu, heḏi in Benjamin-bí ây iweḏiˀiˀbáho namuu. Saul-á jónä́ntä̖ (40) pa̖a̖yo inbí kwꞌáyeˀi tsondi dínmuu. ");
INSERT INTO tew_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ihayḏiho híwóhpí iˀandi Jôesi Táḏáḏí óejâaˀan, heḏi David óesóge inbí kwꞌáyeˀi tsondi dínmúuníḏí, i-á Jesse-ví ay ûnmuu. Jôesi Táḏá natú̖, ‘Naa dînhanginná David-ví ánshaa-á navîˀ waagibá ûnmuuˀin, heḏá i-á hä̖ä̖wí tꞌä̖hkí háa naa otú̖ waa ikanhûuwí.’ ");
INSERT INTO tew_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jôesi Táḏá iví tun imä́gi David-ví thehtáy pahpáˀây iweḏi wí naˀä̖ˀin nä́ˀin Israel-win tꞌowa ovâyˀaywoeníḏí, heḏi i-áho nää napówá, i-á Jesus-ânho namuu. ");
INSERT INTO tew_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Hewänbo waˀḏi Jesus iví tꞌôe itsꞌanˀanpíḏíboˀ, John iˀ pꞌóˀpꞌoekandiˀḏi in Israel-win tꞌowa tꞌä̖hkí ovâytu̖máa, ‘Unbí tꞌaywóˀdi binjoeˀan, ihayḏânho wâypꞌóˀpꞌoeˀa̖mí.’ ");
INSERT INTO tew_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Heḏi John iví tꞌôe ibowakhâyˀoˀ ihayḏi, ihayḏa̖ˀ ovâytu̖máa, ‘Ti naa-ân iˀ bîntsíkhaˀmáaˀiˀ omuu gin íˀándeˀ? Naa-á joe. Bítꞌôeyanbe, naví shánkí tíˀúugá wíyá toˀwí napowagíˀo, i-á naví shánkí itsonmáaˀiˀ namuu. Naa ihay híwóˀdi wóˀmuupí iví anto wänbo dônpꞌä̖̂ä̖ḏi-íḏí,’ ginnânho John natú̖. ");
INSERT INTO tew_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Tíˀûuwin páaḏéˀin, un Abraham-bí ây iweḏiˀin ímuuˀindá heḏá un wéˀgen tꞌowa Jôesi Táḏá bînˀaˀginmäˀindá, undáḏí naˀindáḏí Jôesi Táḏáḏí dítu̖ˀan háḏíḏí in tꞌowa ovâyˀaywondeˀin. ");
INSERT INTO tew_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Hewänbo in tꞌowa Jerusalem dithaaˀin heḏá inbí tsonnindá taˀgendi wíḏínhanginnáhpí toˀ Jesus namuuˀin, heḏá iˀ híˀ Jôesi Táḏáví tukheˀmin Jesus-ví̖ˀgeḏi dâytaˀnandi wíḏikaˀpóyaˀpí. Tobá inbí méesate eeje kaykhanwówá thaa waa nä́ˀi híˀ dâytundo wänboˀ, híwó wíḏikaˀpóyaˀpí. Heḏânho ditú̖ Jesus óeháyjíˀin ûnkhâyˀäˀ, heḏiho háa in Jôesi Táḏáví hä́nˀoeˀin tukheˀmin dâytaˀnan waa taˀgendi napóe. ");
INSERT INTO tew_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","29","Hä̖ä̖wí tꞌä̖hkí Jesus óeˀandi Jôesi Táḏáví taˀnin diwe ho nataˀmuu. Nä́ˀin tꞌowaḏi Pilate óedaaˀan natsonpúuwíḏí Jesus óeháyjíḏí, tobá wên tꞌaywóˀnin wíˀônshaapí wänboˀ. Heḏi han óeˀandá nachuuḏá in phéˀwin diweḏi óewá̖ve, heḏá wí tꞌowápho ee óekꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","31","“Hewänbo Jôesi Táḏáḏí óewáywówápaa. Hä̖́yä́n wänbo wên tꞌowavíˀpiye Jesus ipikeeyan, indá dimuu in toˀwên óeyu̖u̖honnin Galilee iweḏi Jerusalem iwehay waˀ nachuupíḏíboˀ. Heḏi nä́ˀin tꞌowaḏá wéˀgen tꞌowa ovâytu̖máa nawáywówápóeˀin dâymûˀ. ");
INSERT INTO tew_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Heḏi nää-á naˀindá wáˀ nä́ˀiˀ híwóˀdi tun wâytꞌôeˀoˀ: Jôesi Táḏá nanbí hehä̖̂ä̖wi thehtáy pahpáˀin iví tun imä́gi Jesus óewáywówápakhâymáaˀin, heḏi háa ovâytu̖ˀan waa naˀin inbí ây iweḏiˀin gimuuˀingîˀ iˀan. In eeḏiˀin Psalm diwebo háa Jôesi Táḏáḏí Jesus óetu̖ˀan waa ginnân nataˀmuu: Nää thaa dovâykeeyan naa uví Táḏáho omuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wíyá wáygé Jôesi Táḏá gin wáˀ natú̖: Naaḏi David dótu̖ˀan taˀgendi hânho híwó dókhâymáaˀin, heḏi un wáˀ hanbá wâykhâymáa. Heḏi nä́ˀi híˀ-á ginnân natundaˀ: Jesus-ví túˀ-á wíˀûnseejé-ípí gá óewáywówápakhâymáaḏân, heḏi háˀto wíyá nachuu-í. ");
INSERT INTO tew_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Heḏânho David-di wây-á wéhpêe Psalm itaˀnan diwe Jôesi Táḏá gin óetu̖ˀan: Uví yä̖ˀḏâaˀi ayví túˀ wínâasijepä̖khâymáapí. ");
INSERT INTO tew_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David-á wíˀbo iví̖ˀgeḏi wíˀihíˀmáapí. Iví thaa waˀ nawówájiˀ ihayḏi háa Jôesi Táḏáḏí óetu̖ˀan waa iví tꞌowagîˀ iˀan, ihayḏáháˀ nachuu, heḏi iví páaḏé kä̖ˀä̖ä̖ˀin ovâykhä̖ˀkwꞌóḏi iwebá óekhä̖ˀkꞌûˀ, heḏiho iví túˀho ûnsije. ");
INSERT INTO tew_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Hewänbo Jesus-ví túˀ-á wíˀûnsijepí, i-á iˀ Jôesi Táḏáḏí óewáywówápaaˀi namuu. ");
INSERT INTO tew_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Tíˀûuwin páaḏéˀin, naa odaˀ íkapóewíˀin nä́ˀin nää wâytu̖hkankhâymáaˀin: Háa Jesus iˀannin namuuḏi unbí tꞌaywóˀdi wovâyˀowóejé-í. Tobá iˀ tsontun Moses itaˀnandi bînˀaˀginnamíḏí úvíkhä̖ä̖ḏe wänboˀ, háˀto unbí tꞌaywóˀdi wovâyjâaˀa̖mí, hewänbo Jesus-víˀpiye úvíwä̖yundeḏáho wovâyjâaˀa̖mí-ákun. ");
INSERT INTO tew_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nää undá bíˀá̖yîngiˀan heḏânho nä́ˀin Jôesi Táḏáví híˀ iví tukheˀmin dâytaˀnannin wíˀúnpúuwípíḏí: ");
INSERT INTO tew_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Un ítú̖ˀin naví híˀ wíḏînchä̖ˀmuupíˀin bítꞌôeyan. Unbí thaa eeje wí hä̖ä̖wí wä̖yu̖píwóˀdi namuuˀi hânho hayˀi namuuḏi naa dáykhâymáa, heḏi wíˀúvíwä̖yu̖khâymáapí tobá wí toˀwíḏí wovâythayjo wänboˀ. Heḏiho wovâyháaˀa̖mí, hewänbo wíˀúvíwä̖ä̖yú̖-ípí, heḏânho íchuuwí.” ");
INSERT INTO tew_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul ihíˀbowa, heḏi i-áḏí Barnabas-áḏí iˀ Huḏíyoví méesate iweḏi dapeemän dihayḏi in tꞌowa didaˀjiˀ owáy wíyá kaykhanwówá thaa nä́ˀi hä̖ä̖wí ditꞌoe i̖ˀgeḏibá shánkí ovâyhéeˀa̖míˀin, ");
INSERT INTO tew_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","heḏi dínwéˀgekꞌeweˀ dihayḏi, báyékí in tꞌowa Paul-áḏí Barnabas-áḏí dimää, heḏi in wíjeḏi ovâytumakheˀan Jôesi Táḏáví sígísehkanä iwe dívíwä̖yu̖hûuwíḏí. Wáy wên nä́ˀin tꞌowa-á Huḏíyo dimuu, wây-á wêndá Huḏíyo dimuupí wänbo in Huḏíyoví khuubá dâyhon. ");
INSERT INTO tew_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Wíyá jâaḏi iˀ kaykhanwówá thaa nanáˀ diwe, tꞌä̖hkí waa in búˀwin tꞌowa dívíwéˀgeˀan nä́ˀi Jôesi Táḏáví tun Paul-áḏí Barnabas-áḏí dä̂ntꞌôeˀoḏi ditꞌoe-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","In Huḏíyoví pꞌóˀḏéḏíˀindi nä́ˀin báyékí tꞌowa in wíjevíˀpiye dimändi ovâymûˀ ihayḏi, ívíwo dithúupóe, heḏi ovâytu̖máa Paul-ví híˀ-á taˀgen wíˀûnmuupí, heḏá iví̖ˀgeḏá híwóhpí dívíhéeˀan. ");
INSERT INTO tew_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hebo Paul-áḏí Barnabas-áḏí khunwôedaˀginpíḏíboˀ ovâyhéeˀan. Ginnân datú̖: “Nakhâyˀä̖ˀ Jôesi Táḏáví híˀ un Huḏíyo páaḏé wâytꞌôeˀa̖míˀin, heḏiho han änˀan. Hebo bînjoegiˀandi úvíkeejoˀ undá in wówátsi nahándepíˀin bînkáyjíˀin wíˀímuupíˀin, heḏânho nää naˀindi wâyjoekankhâymáa, heḏá in Huḏíyo dimuupíˀinbíˀpiye gamän, ");
INSERT INTO tew_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","gá Nanbí Sedó Jôesi Táḏáḏí iví taˀnin diwe naˀin ginnân dítu̖ˀandân: Naaḏi u̖ˀ wídeˀman wí ko waagiˀbá unmúuníḏí, in Huḏíyo dimuupíˀinbíˀpiye unmú-íḏí, in tꞌowa tꞌä̖hkí nä́ä oepáa kꞌayḏi háḏíḏí ovâyˀaywoeníˀin ovâytu̖ˀâ̖a̖míḏí.” ");
INSERT INTO tew_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","In Huḏíyo dimuupíˀin iwebá dijiˀin nä́ˀi híˀ ditꞌoeḏi hânho dihíhchanpóe, heḏi ditú̖, “Nanbí Sedó Jôesi Táḏáví híˀ híwóˀdi ûnmuu.” Heḏi tꞌä̖hkí in toˀwên Jôesi Táḏáḏí ovâydeˀmannin nä́ˀin wówátsi nahándepíˀin dâykáyjíḏí ivíˀpiye dívíwä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Heḏi shánkí wänbo tꞌowa iˀ nange tꞌä̖hkí dikwꞌóˀnin Nanbí Sedó Jôesi Táḏáví tun ditꞌoemän. ");
INSERT INTO tew_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Hewänbo in Huḏíyoḏi in búˀwin kwiyä̖ˀ koḏitꞌowa dimuuˀin Jôesi Táḏá óeˀaˀginnin ovâytꞌeˀyaˀnan, heḏá in senäˀ kwꞌáyeˀin dimuuˀin wáˀ, heḏiho nä́ˀindá Paul-á Barnabas-á ovä̂njänäkíˀan heḏá inbí nan diweḏi ovä̂nkhehpiye. ");
INSERT INTO tew_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Heḏiho inbí anto iweḏi dä̂nnaˀjeepíḏi in tꞌowa ovâykeeya̖míḏí koḏi wíḏívíˀanpíˀin, heḏáháˀ nä́ˀi wêe búˀ Iconium eepiye damää. ");
INSERT INTO tew_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Heḏi in Antioch búˀ dithaaˀin Jesus-víˀpiye dívíwä̖yundeˀin hânho dihíhchanpóe, heḏá pín taˀgeḏá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-á dâymáa. ");
INSERT INTO tew_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Háa Paul-á Barnabas-á oe Antioch dä́npóe waabá oe Iconium wáˀ dä́npóe. Iˀ Huḏíyoví méesateˀay ee datsꞌú̖, heḏi hânho híwó ovâyhéeˀandi báyékí tꞌowa Huḏíyo dimuuˀindá Huḏíyo dimuupíˀindá Jesus-víˀpiye dívíwä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Hewänbo wên Huḏíyo inbí híˀ dívíwä̖yundepíˀindá wây-á Huḏíyo dimuupíˀin ovâytꞌeˀyaˀnan, heḏiho nä́ˀin Huḏíyo dimuupíˀin in Jesus-víˀpiye dívíwä̖yundeˀinbíˀpiye háa dicha̖a̖. ");
INSERT INTO tew_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Hebo Paul-á Barnabas-á híwó hay jâaḏi iwebo dänwóyí̖ˀ, heḏi khunwôedaˀginpíḏíbo Nanbí Sedó Jesus-ví̖ˀgeḏi dänhíˀmáa. Heḏi iˀḏá ovä̂nkaymä́gi pínnán tꞌôe dä̂nˀa̖míḏí, heḏânho in tꞌowa ovâykeeya̖míḏí iˀ híˀ iví sígísehkanä ûnmuu i̖ˀgeḏá taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Hebo in tꞌowa iˀ búˀwindá ditꞌoeḏi handa̖ˀ wíḏiˀánshaamuupí. Wêndá in Huḏíyo-áḏí dipóe, wêndá in wíje Jesus-ví tꞌôekhuwaˀindáḏá. ");
INSERT INTO tew_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Heḏiho wên Huḏíyo-áḏí wên Huḏíyo dimuupíˀindáḏí in búˀwin pꞌóˀḏéḏíˀin wóegé dívíˀánshaamä́gi ovä̂nwa̖ˀa̖míḏí heḏá ovä̂nkꞌusä̖ä̖yú̖-íḏá. ");
INSERT INTO tew_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Hebo háa ovä̂nkhâymáaˀin Paul-á Barnabas-á dä́nhanginpóe, heḏiho oe Lycaonia nangepiye dajân, heḏi wíje búˀ Lystra-á Derbe-á iwe heḏá i̖ˀge tꞌä̖hká Jôesi Táḏáví híwóˀdi tun in tꞌowa ovâytꞌôekanhon. ");
INSERT INTO tew_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nä́ˀi búˀ Lystra iwe wí sen natsiˀḏeeˀipîˀ naˀä́n. Naˀaypu̖yä̖ḏibo ha̖ˀbi namuu, heḏiho wáymûu wänbo wíˀijíyépí. ");
INSERT INTO tew_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Paul ihíˀmáaḏí nä́ˀi sendá natꞌôeyannä́n. Paul-dá taˀgebo óemûˀḏi ûnhanginná iˀ sen in wä̖yu̖ ûnhehkháapúuwíḏí imáaˀin, ");
INSERT INTO tew_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","heḏiho kaygi óetu̖ˀan, “Ótaˀgewí̖nú.” Heḏi iˀ sen ichä̖nuwí̖núḏí natsiˀḏee. ");
INSERT INTO tew_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","In báyékí tꞌowa iwe dijiˀin háa Paul iˀannin dâymûˀḏi diˀánde wên wíje inbí jôesi damuuˀin, heḏiho kaygi ditú̖ inbí tundi, “Wên jôesi damuuˀin makówáḏí nanbíˀwepiye dawân heḏi naˀin tꞌowa waaginbá dapaa.” ");
INSERT INTO tew_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ditú̖ Barnabas-á Zeus-ân namuu, heḏi Paul-á Hermes gân óekhá̖yä̖́ˀ, gá Paul shánkí ihíˀmáaḏân. ");
INSERT INTO tew_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Wí méesate hayˀi oe búˀḏí jáˀwé nakꞌóe, iwe in tꞌowa Zeus dâyˀaˀginmäˀ. Iˀ méesatewi owhaˀ wên tôeḏo-á heḏá póvi ophíḏéˀi-á iˀ búˀ tehpaa phóḏi iwepiye imaa, heḏi i-áḏí in tꞌowa-áḏí in tôeḏo dâytꞌahá̖a̖nú-íˀin didaˀ ovä̂nˀaˀginmä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Hebo Paul-á Barnabas-á háa in tꞌowa dívíkhâymáaˀin dä́nhanginpóe ihayḏi inbí kꞌéwéˀin to dä̂nwhéeˀan ovâykeeya̖míḏí háa dívíˀo waa wíˀovä̂nhí̖ˀanpíˀin, heḏá in tꞌowaví jâa dänˀä̖ä̖tsꞌúḏeḏi däntu̖wí̖nú, ");
INSERT INTO tew_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Háaḏan gin úvíˀoˀ? Naˀindá tꞌowaḏa̖ˀ gamuu un waaginbá. Naˀindá gaˀä̖ä̖ Jôesi Táḏáví híwóˀdi tun wâytꞌôeˀa̖míḏí, heḏânho nä́ˀi hä̖ä̖wí nachä̖ˀmuupîˀ úvíˀoˀi bînjoeˀa̖míḏí, heḏá iˀ nawówájiˀi Jôesivíˀpiye úvíwä̖ä̖yú̖-íḏá. I-ân makówá-á nandá mâapꞌoe-á heḏá hä̖ä̖wí tꞌä̖hkí eeje nakwꞌóˀdi-á ikhíjé. ");
INSERT INTO tew_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Heḏi tobá hä́nˀoebo nää puwahay wáyjé tꞌä̖hkíˀin tꞌowa háa dívíˀa̖míˀin didaˀ waa Jôesi Táḏáḏí ovâykanmä́gi wänboˀ, ");
INSERT INTO tew_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","thayˀeeḏi ovâykeeyan háawi iˀ namuuˀin hânho híwó ovâyˀandi. Iˀḏân in kwan makówáḏí wovâyjemu, iˀḏibá hä̖ä̖wí iˀ nan diweḏi napaaˀi wovâypaye. Iˀḏân koegiˀ wovâymäˀ heḏá wíyá hä̖ä̖wí unbí píˀnä́ wovâyhíhchannamígîˀ-á,” gin Paul-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hebo tobá tꞌä̖hkí nä́ˀi ovâytu̖máa wänboˀ, báyékí tꞌôe dä́npóe in tꞌowa ovâywóyí̖ˀníḏí in tôeḏo wíḏâytꞌahá̖a̖nú-ípíḏí in ovä̂nˀaˀginmä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ihayḏibá wên Huḏíyo Antioch búˀwin heḏá Iconium búˀwindá dipówá, heḏi Paul-á Barnabas-á ovä̂ntunsúumáaḏí in Lystra-win tꞌowa háa nä́ˀin dipówáˀin ditú̖ waagiḏa̖ˀ dívíwä̖yu̖. Heḏiho Paul óekꞌusä̖yu̖ heḏi óehay gin dichanpóeḏí ee búˀḏí jáˀwépiye óewhaapiye. ");
INSERT INTO tew_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Hewänbo wên Jesus-víˀpiye dívíwä̖yundeˀin Paul-víˀwepiye diˀä̖ä̖, heḏi waˀḏi iví̖ˀge dibûuwin dihayḏi iwí̖nú, heḏá wíyá iˀ búˀ iwebá nawáytsꞌú̖. Wíyá tháwä́ndá i-áḏí Barnabas-áḏí oe Derbe búˀpiye damää. ");
INSERT INTO tew_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Oe Derbe búˀ Jôesi Táḏáví híwóˀdi tun ovâytꞌôeˀan, heḏi báyékí tꞌowa Jesus-víˀpiye dívíwä̖yu̖. Ihayḏiho oe Lystra-á Iconium-dá i̖ˀgepiye heḏá Pisidia nangewi búˀ Antioch-piyá dawáymää. ");
INSERT INTO tew_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nä́ˀi búˀ eeje in Jesus-víˀpiye dívíwä̖yundeˀin ovâykhä̖geˀnan shánkí kayˀindi dívíwä̖ä̖yú̖-íḏí, heḏá dä̂ntumakheˀan taˀgendi dívíwä̖yu̖hûuwíˀin. Ovâytu̖ˀan, “Tꞌä̖hkí naˀin âytꞌôephaaḏé-íˀin gínpúuwí oe makówá gipówápíḏíboˀ.” ");
INSERT INTO tew_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Heḏi tꞌä̖hkí iˀ méesate eeje tsonnin ovâykwꞌóḏi, heḏáháˀ dänjûusuˀandá dänha̖a̖ḏä́ˀandá tꞌä̖hkí in dívíwä̖yu̖ˀin ovâytu̖ˀan, “Nanbí Sedó Jôesi Táḏáḏí wovâypahûuwí.” ");
INSERT INTO tew_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nää-á Pisidia nange i̖ˀge daphaḏemää, heḏá Pamphylia nange iwá dapówá. ");
INSERT INTO tew_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Iwe in Perga búˀwin tꞌowa Jôesi Táḏáví tun ovâytꞌôeˀan, heḏá iweḏá wíyá wêe búˀ Attalia-piye damää. ");
INSERT INTO tew_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Iweḏáháˀ kophé iweḏá iˀ wêe Antioch búˀ iwepiye dawáymää. Iweḏânho hä́n páaḏéḏí wáypiye damää heḏi damääpíḏíbo in méesate iweˀin tꞌowaḏi ovä̂njûusuˀan Jôesi Táḏáví sígísehkanäḏi ovä̂nˀá̖yîngiˀa̖míḏí, iví tꞌôe dä̂nˀa̖míḏí. Heḏi nää-á inbí tꞌôe-á dä̂nbowaḏi dawáyˀä̖ä̖. ");
INSERT INTO tew_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Oe Antioch dapówá ihayḏi tꞌä̖hkí in méesateˀin tꞌowa ovâywéˀgeˀan, heḏi ovâytu̖ˀan háa Jôesi Táḏáḏí ovä̂nkhä̖geˀnannin iˀ tꞌôe dänˀandi tꞌä̖hkí, heḏá ovâythayyan háa in Huḏíyo dimuupíˀin wáˀ Jôesi Táḏáḏí ovâymä́giˀin dívíwä̖ä̖yú̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Báyékí thaa oe Antioch in Jesus-víˀpiye dívíwä̖yundeˀindáḏí dänwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wên senäˀ oe Antioch dipówá Judea nange iweḏi, heḏi indi in Jesus-víˀpiye dívíwä̖yundeˀin ovâyhá̖ˀoˀ. Gin ovâytu̖ˀan: “In Huḏíyo waaginbá íkꞌewetaamuupíḏá Moses natsonpóe waa, undá háˀtoˀ oe makówápiye ímú-í.” ");
INSERT INTO tew_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul-á Barnabas-á ívíwo wíˀovä̂nhí̖ˀanpí háa in senäˀ dipówáˀin ditû̖ˀnin, heḏi indáḏí báyékí dívítu̖hkannan. Heḏiho Paul-á Barnabas-á heḏá wây-á wên Antioch-win senäˀdá ovâydeˀman Jerusalem-piye dimú-íḏí, iwe ovâyhéeˀa̖míḏí in Jesus-ví tꞌôekhuwaˀindá in méesateˀin tsonnindáḏí nä́ˀi hä̖ä̖wí napóe i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Heḏiho nä́ˀin senäˀ Antioch iweḏi ovâysandi nä́ˀin wíje nange Phoenicia-á Samaria-á i̖ˀge diphaḏe. Eeje in Jesus-víˀpiye dívíwä̖yundeˀin ovâytu̖ˀan hä̖ä̖wí tꞌä̖hkí háa in Huḏíyo dimuupíˀin dínpóeˀin, inbi khuu dâyjoeˀandi Jesus-víˀpiye dívímä́gi. Heḏi nä́ˀi híˀ ditꞌoeḏi hânho dihíhchanpóe. ");
INSERT INTO tew_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem búˀ in senäˀ dipówá ihayḏi, in méesateˀin tꞌowa-áḏí in Jesus-ví tꞌôekhuwaˀindáḏí heḏá in méesate iweˀin tsonnindáḏí in ovâysígíhógi. Ihayḏiho Paul-áḏí Barnabas-áḏí ovâytu̖ˀan tꞌä̖hkí iˀ hä̖ä̖wí Jôesi Táḏáḏí ovâykhä̖geˀnandi dívíˀa̖míḏí i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Hebo wên Jesus-víˀpiye dívíwä̖yundeˀindá Pharisee tꞌowa-ân dimuu, heḏi dívíwí̖núḏí ginnân ditú̖, “In Huḏíyo dimuupíˀin tꞌowa-á dínkhâyˀä̖ˀ in Huḏíyoví kꞌewe taaḏi ovâytaaˀa̖míˀin, heḏá wáˀ nakhâyˀä̖ˀ ovâytu̖ˀâ̖a̖míˀin tꞌä̖hkí iˀ tsontun Moses itaˀnandiˀ dâyˀaˀginnamí.” ");
INSERT INTO tew_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Heḏiho indáḏí in Jesus-ví tꞌôekhuwaˀindáḏí in méesate iweˀin tsonnindáḏí dívíwéˀgeˀan nä́ˀi hä̖ä̖wí i̖ˀgeḏi dívíhéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Híwó hayho dívíhéeˀan, ihayḏiho Peter iwí̖núḏí ovâytu̖ˀan, “Tíˀûuwin páaḏéˀin, únhanginná hä̖́yú̖ hay pa̖a̖yo phaḏe Jôesi Táḏáḏí naa dídeˀmannin in Huḏíyo dimuupíˀin dovâyhéeˀa̖míḏí iví híwóˀdi tun ditꞌoe-íḏí heḏá iˀpiye dívíwä̖ä̖yú̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Jôesi Táḏá tꞌowa tꞌä̖hkíví ánshaa ûnhanginná, heḏi naˀin dînkeeyan iˀḏá in Huḏíyo dimuupíˀin wáˀ ovâysígíhógiˀin iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ ovâymä́giḏi. Naˀin dímä́gi waabá in ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Heḏá ikeeyan tꞌä̖hkí indáḏí naˀindáḏí handa̖ˀ dímáaˀin, gá indi iví híˀ ônwä̖yu̖ḏi iˀḏá inbí tꞌaywóˀdi inbí píˀnä́ḏí ovâyjâaˀandân. ");
INSERT INTO tew_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Heháaḏanho nää un ídaˀ Jôesi Táḏá bîntꞌayjaaˀa̖míˀin? Undá ítsonpoeˀo in Huḏíyo dimuupíˀin Jesus-víˀpiye dívíwä̖yu̖ˀin wên hä̖ä̖wên kâyˀin dívíˀa̖míˀin, hewänbo háa bîntsonmáaˀindá naˀin wígínkoḏipí ívíˀa̖míḏí, nanbí thehtáy pahpáˀin wáˀ wänbo wíḏínkoḏipí. Wí hä̖ä̖wí kháaˀi inbí tꞌúˀkꞌeegi bînˀíˀkꞌúyaˀ waagibá úvíˀoˀ. Haˀwâa wíˀúvíˀa̖mípí. ");
INSERT INTO tew_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Naˀindá ívíwä̖yunde Nanbí Sedó Jesus-ví sígísehkanä ûnmuuḏibo dînˀaywoeníḏí, heḏá in Huḏíyo dimuupíˀin wáˀ handiḏibá ovâyˀaywoení.” ");
INSERT INTO tew_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ihayḏáháˀ Barnabas-áḏí Paul-áḏí ovâyhéeˀan. In tꞌowa tꞌä̖hkí diwéˀgekwꞌóˀnin hânda̖ˀ dikwoḏee ovä̂ntꞌôeyandeḏi in wíjeḏi ovâytu̖máaḏí háa Jôesi Táḏáḏí ovä̂nkhä̖geˀnannin tꞌä̖mägeˀi pínnán tꞌôe dä̂nˀa̖míḏí in Huḏíyo dimuupíˀin tꞌowa-áḏí dajiˀ ihayḏi. ");
INSERT INTO tew_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Dänhíˀbowa, ihayḏáháˀ James-dá ginnân ihéeˀan: “Tíˀûuwin páaḏéˀin, nää-á naa-áháˀ dîntꞌôeyan. ");
INSERT INTO tew_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Peter-di naˀin dítu̖ˀan Jôesi Táḏáḏí in Huḏíyo dimuupíˀin tꞌowa wáˀ ovâyˀá̖yîngimáaˀin, heḏi handiḏi dînkeeyan wên in diweḏi ovâyhógiˀin ivíˀin ûnmúuníḏí. ");
INSERT INTO tew_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","In Jôesi Táḏáví tukheˀmin hä́nˀoebo hanbá ditú̖, heḏi háa Nanbí Sedó Jôesi Táḏá natú̖ˀin ginnân dâytaˀnan: ");
INSERT INTO tew_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","18","‘Iˀ tsondi David-ví ây iweḏiˀinbí tsonkhuu dínhándí wí tewhá nakanuˀi waagiˀinbá dipóe, hewänbo wáy wí thaa naa owáyˀä̖ˀ heḏá inbí tsonkhuu dovâywáymä̂äní. Háa dimúˀde waagibá dovâywáykwohkhâymáa. Naa han dáykhâymáa heḏânho tꞌä̖hkí in wéˀgen tꞌowa didaˀíḏí dítaa-íˀin, hä̖́yú̖ in Huḏíyo dimuupíˀin dovâyhógiˀin navíˀin dînmúuníḏí.’ Ginho Nanbí Sedó Jôesi natú̖, iˀḏá hä́nˀoe nä́ˀi hä̖ä̖wí tꞌowa ovâyhanginˀânnan.” ");
INSERT INTO tew_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Heḏá James gin wáˀ natú̖, “Nä́ˀi híˀ Jôesi Táḏá natú̖ˀi namuuḏi, ginnân naa dînchanpoeˀo: Wígínkhâyˀä̖hpí in Huḏíyo dimuupíˀin Jôesivíˀpiye dívítsꞌanwä̖yu̖ˀin âytu̖ˀâ̖a̖míˀin háawin kâyˀin dâyˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Han ívíˀa̖mívíˀweḏi, âytaˀnamí ginnân âytu̖ˀâ̖a̖míḏí: Wíḏâykꞌoˀípí iˀ koegîˀ nakoekhâ̖a̖kꞌóeˀi gá in wéˀgen tꞌowa inbí jôesi dâymä́giḏân, heḏá wíyá toˀwíví kwee-áḏí háa sendáḏí wíḏívíwhoˀkwꞌôenípí, heḏá in animâa ovâykꞌéwhihá̖núˀinbí píví iˀ ûnpꞌoe napeepîˀ-á wíḏâykꞌoˀípí, heḏá iˀ ûnpꞌoe wänbo-á wíḏâykꞌoˀípí. ");
INSERT INTO tew_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gin naa otû̖ˀ gá nä́ˀi hä̖ä̖wí i̖ˀgeḏi Moses itaˀnandân, heḏi kaykhanwówá thaa waagi Huḏíyoví méesate eeje báyékí pa̖a̖yo phaḏe waabo nä́ˀin Moses itaˀnannin tꞌowa dâytundoˀ, heḏá iví híˀ-á tꞌä̖hkí búˀ nanáˀ deeje ôntꞌôeˀoˀ.” ");
INSERT INTO tew_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Heḏiho in Jesus-ví tꞌôekhuwaˀindá in méesateˀin tsonnindá heḏá tꞌä̖hkí in wéˀgen méesateˀindá ginnân ditú̖, “Wên senäˀ naˀinbíˀweḏibá dimuuˀin âydeˀmamí, heḏi Antioch-piye âysaaní Paul-á Barnabas-á indáḏí.” Heḏiho Silas-á Judas-á ovä̂nkêˀ, nä́ˀi Judas-áho Barsabbas gin wáˀ nakhá̖wä̖́. In méesateˀin tꞌowaḏi nä́ˀin senäˀ báyékí ovä̂nˀaˀgin. ");
INSERT INTO tew_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Heḏi wên taˀnin indáḏí dâyhoˀ ginnân nataˀmuuˀin: “Un Huḏíyo ímuupíˀin hebo nanbí tíˀûuwin páaḏéˀin ímuuˀin, un oe Antioch búˀ heḏá in nange Syria-á Cilicia-á íthaaˀin, naˀin Jesus-ví tꞌôekhuwaˀindá heḏá in méesateˀin tsonnindá unbí tíˀûuwin páaḏéˀin gimuuˀindi wâysengitu̖máa. ");
INSERT INTO tew_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Naˀin gínhanginpóe wên tꞌowa nä́weḏi dimääˀindi piháawi hä̖ä̖wí wovâytu̖ˀannin, heḏiho inbí híˀ dínmuuḏi wíˀúnhanginnáhpí háa úvíˀa̖míˀin, heḏá tꞌä̖hkí únbéeḏee. Hebo naˀindá hä̖ˀin tꞌowa wíˀâytu̖ˀanpí haˀwâa dívíˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Heḏânho ívíwéˀgeˀan heḏi âywéhpêeˀandi gitú̖ híwó namúuníˀin Paul-á Barnabas-á unbíˀpiye wâysaaníḏí. Indá senäˀ âysígíˀin damuu, heḏá dakhâymuu inbí wówátsi Nanbí Sedó Jesus Christ-gîˀ dänmä̂äníḏí. Heḏá wáˀ gitú̖ híwó namúuníˀin wây-á wên senäˀ âydeˀmamíḏí indáḏí damú-íḏí, ");
INSERT INTO tew_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","heḏiho Judas-á Silas-á âysan. Háa nä́ˀin taˀnin diwe âytaˀnan waa indibo hanbá wovâytu̖hkankhâymáa. ");
INSERT INTO tew_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ natú̖ híwó wínamuupíˀin wí hä̖ä̖wí kâyˀi wâytu̖ˀâ̖a̖míḏí úvíˀa̖míḏí heḏá naˀin wáˀ hanbá gicha̖a̖. Hebo nä́ˀi híˀ-áho únkhâyˀä̖ˀ bînˀaˀginnamíˀin: Wívînkꞌoˀípí iˀ koegîˀ in wéˀgen tꞌowa inbí jôesi dâymä́giˀiˀ, heḏá wívînˀûnpꞌoekꞌoˀípí, heḏá in animâa ovâykꞌéwhihá̖núˀinbí píví iˀ ûnpꞌoe napeepîˀ wívînkꞌoˀípí, heḏá wíyá toˀwíví kwee-áḏí háa sendáḏí wíˀúvíwhoˀkwꞌôenípí. Nä́ˀi hä̖ä̖wí wíˀúvíˀanpíḏí híwó únpúuwí. Sndgiḏihoˀ.” ");
INSERT INTO tew_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Heḏiho Judas-á Silas-á Barnabas-ä haḏa Paul-á Antioch-piye ovâysan. Dipówá ihayḏi in méesateˀin tꞌowa tꞌä̖hkí ovâywéˀgeˀan heḏi in taˀnin ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","In tꞌowa dâytunnan dihayḏi hânho dihíhchanpóe in híwóˀnin tumakhe ditꞌoeḏi. ");
INSERT INTO tew_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas-áḏí Silas-áḏí Jôesi Táḏáví tukheˀmin damuuḏi in Jesus-víˀpiye dívíwä̖yundeˀin báyékí ovâyhéeˀandi ovâytu̖ˀan kwee waa sen waa diˀâ̖a̖níḏí, heḏi inbí híˀḏí ovâykhä̖geˀnan shánkí kayˀindi dívíwä̖ä̖yú̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Ihay hä̖́yú̖ thaa iwe daˀä́n, ihayḏáháˀ datú̖ Jerusalem-piye dawáymú-íˀin, iweḏibáho páaḏé ovä̂npunjôn. In Jesus-víˀpiye dívíwä̖yundeˀin Antioch-ˀin dimuuˀindi ovä̂ntu̖ˀan, “Jôesi Táḏáḏí wovä̂nˀá̖yîngihûuwí hä̖ä̖ pꞌóegé damändi,” heḏi damää. ");
INSERT INTO tew_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Hebo Paul-á Barnabas-áḏí oe Antioch-bo dänwóyí̖ˀ. Eewân indá heḏá báyékí wây-á dikwꞌóˀnindáḏí Nanbí Sedó Jôesi Táḏáví híˀ in tꞌowa ovâytꞌôeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wí hä̖́yú̖ thaa naphaḏe ihayḏi Paul-di Barnabas óetu̖ˀan, “Jaho gawáymú-í tꞌä̖hkí búˀ eeje, hä̖ä̖ Nanbí Sedó Jôesi Táḏáví tun ä́ntunphaḏe eeje, heḏá hä̖ˀin méesateˀin tíˀûuwin páaḏéˀin ä́nmúuní, gä́nhanginpúuwíḏí tigú híwóˀgí dimän.” ");
INSERT INTO tew_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas-á nadaˀ John Mark indáḏíbá dä̂nhúuwíˀin. ");
INSERT INTO tew_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Hebo Paul-á wínahíjepí. Iheˀjiḏiḏa̖ˀ natû̖ˀ Mark-á indáḏí wíḏä̂nhûuwípí, gá oe Pamphylia nange dijiˀ ihayḏi ovä̂njoeˀandân, heḏi iwe Mark wíyá wínadaˀpí indáḏí in tꞌôe iˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Heḏi ívíwo däntu̖hkannandi dänwije. Barnabas-di Mark óekêˀ i-áḏí damú-íḏí, heḏi kophé iweḏi oe Cyprus-piye damää. Hewänbo Paul-dá Silas-á óedeˀman. ");
INSERT INTO tew_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","In Jesus-víˀpiye dívíwä̖yundeˀin dívíjûusuˀan Jôesi Táḏáḏí ovä̂nsígíˀá̖yînhûuwíˀin, heḏi damää. ");
INSERT INTO tew_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","In nange Syria-á Cilicia-á i̖ˀge damää, heḏi in méesateˀin tꞌowa ovâykhä̖geˀnan shánkí kayˀindi dívíwä̖ä̖yú̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Cilicia nange iweḏi Paul-á Silas-á nä́ˀi búˀ Derbe-piye damää, heḏá wíyá búˀ Lystra-á. Iwe wí sen Timothy gin nakhá̖wä̖́ˀiˀ nathaa, i-á Jesus-víˀpiye iwä̖yundeˀi namuu. Iví jíyá Huḏíyo-ân ûnmuu, heḏi iˀ wáˀ Jesus-víˀpiye iwä̖yu̖, hebo iví táḏá-á Greek-ân ûnmuu. ");
INSERT INTO tew_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","In Jesus-víˀpiye dívíwä̖yundeˀin oe Lystra-á Iconium-dá dithaaˀin ditû̖ˀ Timothy-á híwóˀdi sen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul nadaˀ Timothy-ḏi ovä̂nyu̖u̖hûuwíˀin, hewänbo páaḏé óehoˀ iˀ Huḏíyoví kꞌewe taaḏi óetaaˀa̖míḏí, gá ee dimän niˀge báyékí Huḏíyo dithaaḏân, heḏi indá tꞌä̖hkí dínhanginná Timothy-ví táḏá Greek ûnmuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Iwáy búˀ iwéngé dimän dihayḏi in méesateˀin tꞌowa ovâyhanginˀânnan háa in Jesus-ví tꞌôekhuwaˀindá heḏá in méesateˀin tsonnindá oe Jerusalem ditú̖ˀin, heḏá ovâytu̖ˀan nä́ˀi híˀ dâyˀaˀginnamíˀin. ");
INSERT INTO tew_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Heḏi in méesateˀin tꞌowa shánkí kayˀindi dívíwä̖yu̖, heḏá shánkí wänbo tꞌowa-á dívíwä̖yu̖hon. ");
INSERT INTO tew_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Oe Asia iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi Jôesi Táḏáví híˀ i̖ˀgeḏi wíˀovâyhíˀmä́gipí, heḏiho in nange Phrygia-á Galatia-á i̖ˀge diphaḏe. ");
INSERT INTO tew_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Oe Mysia nange nantaa dipówá ihayḏi nä́ˀi nange Bythinia ditsuḏedaˀ, hewänbo iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi ovâykhâ̖a̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Heḏiho Mysia nange i̖ˀge wáˀ daphaḏe, heḏi Troas búˀ iwá dapówá. ");
INSERT INTO tew_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Iˀ khun Paul wí hä̖ä̖wí ûnkeepóeḏí imûˀ waagibá ûnpóe. Wí sen Macedonia-wi iví páaḏépiye nawindi kayˀindi óedaˀmáa, “Nä́ä Macedonia-piye ókäˀve naˀin díkhä̖geˀnamíḏí.” ");
INSERT INTO tew_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Heḏi Paul nä́ˀi ûnkeepóe i̖ˀgeḏi dítu̖ˀan dihayḏi wesebo naˀin ívíkhâyˀan Macedonia-piye gimú-íḏí, gínhanginnândi taˀgendi Jôesi Táḏá nadaˀ iví híwó̖ˀdi tun in tꞌowa iweˀin âytꞌôeˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas-di kophé iweḏi gimääḏi iˀ pꞌojâaḏi Samothrace-piye gipówá, heḏá wíyá tháwä́ndá iweḏáháˀ nä́ˀi búˀ Neapolis-piyá gimää. ");
INSERT INTO tew_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Iwe iˀ kophé iweḏi giwá̖, heḏi nangeḏibo oe Philippi-piye gimää. Philippi-á hayˀi búˀ namuu Macedonia nange iwe, heḏi báyékí Rome-ˀin tꞌowa iwe dithaa. Hä̖́yú̖ thaa iwebo ívíwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Iˀ kaykhanwówá thaa-á iˀ búˀ tehpaa phóḏi jáˀwépiye gipee, ihayḏáháˀ pꞌoˀkꞌáygépiyá gimää, gá gichanpóeḏân in Huḏíyo tꞌowa iwepiye dimääˀä̖ dívíjûusuˀa̖míḏí. Iwá wên kwiyä̖ˀ diwéˀgekwꞌó, heḏi nange ívíkwꞌóḏiḏi âyhéeˀan. ");
INSERT INTO tew_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wí kwee in diweḏi nakhá̖wä̖́ Lydia gin. I-á Thyatira búˀwi-ân namuu, heḏi iˀ aa pꞌí tsá̖a̖wä̖́ˀiˀ ívíwo nachä̖ˀmuuˀi ku̖hchaˀi namuu. Iˀḏá Jôesi Táḏá óeˀaˀginmäˀ, heḏi Paul-ví híˀ ôntꞌôeyandeḏi Nanbí Sedó Jôesiḏi óekhä̖geˀnan háa natú̖ˀin isígíkáyjíḏí. ");
INSERT INTO tew_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lydia-á heḏá iví kꞌaygiˀindá dívíwä̖yu̖ḏi ovâypꞌóˀpꞌoeˀan. Ihayḏiho iˀḏi naˀin dítu̖ˀan, “Nää-á únhanginpóe naa taˀgendi Nanbí Sedóvíˀpiye dáywä̖yundeˀin. Heḏáho naví tewhá eepiye bíkä̖ˀve, heḏi iwebo úvíwóyí̖ˀní.” Hânho kayˀindi dítu̖máaḏího gimää. ");
INSERT INTO tew_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wí thaa ee dívíjûusuˀoˀ ipiye gimän dihayḏi, wí aˀyú̖ḏí díjay. Nä́ˀi aˀyú̖-á wên tꞌowaḏi óekumä, heḏi wí yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáa. Nä́ˀi pꞌoewa̖a̖hâ̖a̖ḏi hä̖ä̖ tꞌä̖hkí híˀ óetu̖ˀoˀ natú̖u̖níḏí háa tꞌowa dínpuwagíˀoˀin. Iví tsonnin hä̖́yú̖-anho dâychä̖ˀhóndeˀ iˀ iˀoˀiˀḏi. ");
INSERT INTO tew_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Heḏi Paul-á naˀindá iˀ aˀyú̖ gínwóejiˀḏi itu̖wí̖núndeˀ ginnân: “Nä́ˀin senäˀdá Jôesigîˀ dívítꞌôemáa, i-á iˀ shánkí kwꞌáyewi namuu. Indá wovâytu̖ˀâ̖a̖mí háḏíḏí wovâyˀaywoeníˀin.” ");
INSERT INTO tew_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hä̖́yú̖ thaa ginho iˀoˀ Paul natꞌayjaapóe píhay, heḏiho ibéeḏí iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ óetu̖ˀan, “Jesus Christ-di naa dînkꞌûˀ wíjôeníḏí, hä̖ˀi aˀyú̖víˀweḏi ópeeve.” Heḏi iˀ pꞌoewa̖a̖hâ̖a̖ wesebo ûnpee. ");
INSERT INTO tew_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Iˀ aˀyú̖ví tsonnin dínhanginná iˀ aˀyú̖ḏí wíyá wíˀovâychä̖ˀtꞌankhâymáapíˀin, heḏiho indi Paul-á Silas-á ovä̂nyâ̖ˀḏi ovä̂nkhóhkayˀan iˀ búˀwin pꞌóˀḏéḏíˀin dikwꞌóˀ diwepiye iˀ búˀ pinge, ");
INSERT INTO tew_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","heḏá ovâytu̖ˀan, “Nä́ˀin Huḏíyo senäˀdá nanbí búˀ iwe in tꞌowa ovâytꞌeˀyaˀdoˀ. ");
INSERT INTO tew_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Indá inbí khuu nanbí tꞌowa ovâyhá̖ˀoˀ, heḏi naˀin gínkhâ̖a̖kꞌóe nä́ˀin khuu âykáyjíˀin háa âyˀaˀginnamíˀin, naˀindá Rome tꞌowa gimuuḏi.” ");
INSERT INTO tew_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Heḏiho in wéˀgen tꞌowa iwe dijiˀindi Paul-á Silas-á ovä̂nyâ̖ˀ, heḏi in búˀwin tsonnindi inbí aa ovä̂nwhéeˀan, heḏi ditsonpóe ovä̂nwhä̖́ä̖níˀin. ");
INSERT INTO tew_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Báyékí ovä̂nwhä̖́ḏi ihayḏáháˀ ovä̂npansóge, heḏi iˀ pan tewhá á̖yí̖ˀdi óetu̖ˀan híwó ovä̂nˀá̖yîngiˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Gin óetu̖ˀan dihayḏi iˀḏá pan tewhá pinge ovä̂nsóge, heḏi ovä̂npóˀtꞌä̖́ä̖kꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Khun pinuḏi hä̖̂ä̖ḏi Paul-á Silas-á dänjûusuˀoˀ heḏá dä̂nkhaˀwoˀ Jôesi Táḏá óekú̖ˀdaaˀa̖míḏí. In wéˀgen pan dikwꞌóˀnindi ovä̂ntꞌôeyandeˀ. ");
INSERT INTO tew_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ihayḏi tsíkhagipí iˀ nan hânho naˀa̖ˀyä̖póe, heḏi iˀ pan tewhá tepú wänbo naˀa̖ˀyä̖póe. Wesebo iˀ pan tewhá phóḏi nakhuuḏee, heḏi iˀ kaḏéna in pan ovâywhiˀkwꞌóḏiˀi dínwhisuuḏee. ");
INSERT INTO tew_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Iˀ pan tewhá á̖yí̖ˀdi najósaˀwo heḏi iˀ pan tewhá phóḏi nakhuˀundi imûˀ, heḏiho naˀân tꞌä̖hkí in pan dishavepeeˀin, heḏiho iví tsijó pháˀ iwhahkêˀ heḏi ipikheˀkhâymáawän. ");
INSERT INTO tew_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Hebo Paul itu̖wí̖nú, “Wíˀbo wíviwa̖ˀa̖mípí. Naˀindá tꞌä̖hkí waˀḏi nä́äbo gikwꞌôn.” ");
INSERT INTO tew_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Iˀ pan tewhá á̖yí̖ˀdiḏi wí toˀwí óetu̖ˀan, “Wên phakó dînmáˀ,” heḏi ônmaaḏi iˀ pan tewhá ee iwä̖́nätsꞌúḏe. Hânho natha̖tha̖poeˀo nakhunwôedaˀḏi, heḏi wesebo Paul-áḏí Silas-áḏí inbí páaḏépiye idégeˀdisóge. ");
INSERT INTO tew_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Heḏi iwí̖núḏí oe jáˀwépiye ovä̂npiye heḏi ovä̂ntu̖ˀan, “Naví sedóˀin, hânnan dáyˀa̖mí naa dînˀaywoeníḏí?” ");
INSERT INTO tew_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Indi óetu̖ˀan, “Nanbí Sedó Jesus-víˀpiye bíwä̖́yú̖, u̖-áḏí uví kꞌaygiˀindáḏí, handiḏânho wovâyˀaywoení.” ");
INSERT INTO tew_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Heḏi Paul-áḏí Silas-áḏí Nanbí Sedó Jôesi Táḏáví híˀ iˀ pan á̖yí̖ˀdi-á heḏá tꞌä̖hkí iví kꞌaygiˀindá ovâytu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","heḏi wese iˀ khun iˀ pan á̖yí̖ˀdiḏi ovä̂nhoˀ ovä̂nˀowêeḏi-íḏí ee datsaˀan deeje, heḏá wesebo-á i-á heḏá in wéˀgen iví kꞌaygiˀindá ovâypꞌóˀpꞌoeˀan. ");
INSERT INTO tew_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Heḏáháˀ Paul-á Silas-áḏí iví tewhá eepiye ovä̂npiye heḏá ovä̂nhúujôn. I-á iví kꞌaygiˀindá tꞌä̖hkí ívíwo dihíhchanpóe, nää-áho Jôesi Táḏávíˀpiye dívíwä̖yu̖ḏi. ");
INSERT INTO tew_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wíyá tháwä́n héḏéndí in búˀwin tsonnindi wên á̖yí̖ˀnin senäˀ ovâysan iˀ pan á̖yí̖ˀdi óetu̖ˀâ̖a̖míḏí Paul-á Silas-á ovä̂nmaˀpꞌä̖̂ä̖ḏi-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Iˀ pan á̖yí̖ˀdiḏi Paul óetu̖ˀan, “In búˀwin tsonnindi naa dítu̖ˀan wä̂nmaˀpꞌä̖̂ä̖ḏi-íˀin. Nää-áho damú-í. Jôesi Táaḏáho wovä̂nˀá̖yîngihûuwí.” ");
INSERT INTO tew_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Hebo Paul-dá in á̖yí̖ˀnin senäˀ dipówáˀin ovâytu̖ˀan, “Tobá wí tꞌaywóˀdi wíḏînshaapí wänboˀ, heḏá tobá oe Rome gä́nkhá̖wä̖́taˀkꞌóe wänboˀ, in búˀwin tsonnin ditsonpóe naˀin díwhä̖́ä̖níˀin in tꞌowa tꞌä̖hkí dímúuní iwe, heḏáháˀ dípansóge. Heḏá nää-á kaaḏibo wáypiye dísaaníˀin didaˀ. Hebo háˀto han díˀa̖mí. Jaˀ ovâytu̖ˀan nä́we wíˀbo diˀä̖ä̖-í heḏi indân dípeemä̂äní.” ");
INSERT INTO tew_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Heḏiho in á̖yí̖ˀnin senäˀdi in búˀwin tsonnin ovâytꞌôeˀan háa Paul natú̖ˀin. In wíje Rome-ˀin damuuˀin in tsonnin dínhanginpóe ihayḏi hânho dikhunwôedaˀpóe, ");
INSERT INTO tew_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","heḏiho iˀ pan tewhá eepiye dimää heḏi kayˀindi ovä̂ntu̖ˀan, “Dînˀowójé undi.” Heḏáháˀ iweḏi ovä̂npiye heḏi ovä̂ndaaˀan iˀ búˀḏí dapee-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Heḏiho pan tewhá eeḏi dapeeḏi Lydia-víˀpiye damää. Iwe in Jesus-víˀpiye dívíwä̖yundeˀin ovâykweewaasenwaatu̖ˀandi ee búˀḏí dapee. ");
INSERT INTO tew_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paul-á Silas-á nä́ˀin wíje búˀ Amphipolis-á Apollonia-á i̖ˀge daphaḏe, ihayḏáháˀ Thessalonica búˀ dapówá. Iwe wí Huḏíyoví méesateˀay dínkꞌóe. ");
INSERT INTO tew_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Heḏi Paul iˀ Huḏíyoví méesate eepiye namää, ihayḏa̖ˀ iˀo waabá wä̖́hä̖̂ä̖ namää wänboˀ. Eewá poje jâaḏi kaykhanwówá thaa eeje Jôesi Táḏáví taˀnin ovâytundoˀ, heḏi i-áḏí indáḏí dívíhéeˀan itunnan niˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Háa Jôesi Táḏáví taˀnin natundaˀin ovâythayyan, heḏá ovâykeeyan nä́ˀin taˀnin taˀgendi natû̖ˀnin iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí itꞌôephaḏekhâymáaḏáháˀ nachuwagíˀo, hebo wíyá nawáywówápuwagíˀo. Heḏá ovâytu̖ˀan wáˀ, “Nä́ˀi Jesus, iví̖ˀgeḏi naaḏi wâytu̖máaˀiˀ, i-ân iˀ namuu Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí.” ");
INSERT INTO tew_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wên Huḏíyo iwe dijiˀindá heḏá báyékí Huḏíyo dimuupíˀin Jôesi Táḏá dâyˀaˀginmäˀindá, heḏá báyékí pꞌóˀḏéḏíˀin kwiyä̖ˀ wáˀ, indá dívíwä̖yu̖ taˀgen namuuˀin háa Paul natû̖ˀnin, heḏi Paul-áḏí Silas-áḏí dívíwón. ");
INSERT INTO tew_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Hewänbo in wéˀgen Huḏíyo-á dithúupóe báyékí tꞌowa dívíwä̖yu̖ḏi, heḏiho wên senäˀ dichä̖ˀmuupíˀin hä̖̂ä̖ḏi waa ee búˀ pinge dívíkwi̖numáaˀin ovâyhógiḏáháˀ báyékí wây-á tꞌowa ovâywéˀgeˀan, heḏi ovâytꞌeˀyaˀnandi ee búˀ tꞌä̖hkí dínwänpitú̖. Ihayḏáháˀ in Huḏíyo-áḏí in senäˀdáḏí wí sen Jason gin nakhá̖wä̖́ˀiví tewhá eepiye dimää, i-á Jesus-víˀpiye iwä̖yundeˀi namuu, heḏi in phóḏi ônthâaníˀin dívíkhä̖ä̖ḏeˀ. Paul-á Silas-á ovä̂ntu̖wä̖máa oe jáˀwé ovä̂npeeyé-íḏí in tꞌowaví páaḏépiye. ");
INSERT INTO tew_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hebo in wíje wíˀovä̂nshaapí, heḏiho in senäˀdi ovâypiye Jason-dá heḏá in wéˀgen Jesus-víˀpiye dívíwä̖yundeˀindáḏí. Khóhkayḏi in búˀ tsonninbíˀpiye ovâyhoˀ, heḏi dívítu̖wí̖núndeḏi ditû̖ˀ, “Nä́ˀin senäˀdi wä̖́hä̖̂ä̖ dimää wänbo tꞌowa ovâytꞌeˀyaˀdoˀ, heḏi nää-á nä̂äwá dipówá. ");
INSERT INTO tew_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Heḏi nä́ˀi Jason-dá ovâysígíhógi. Tꞌä̖hkí nä́ˀin tꞌowa iˀ tsondi Caesar-ví tsontun dâyˀaˀginhá̖núndeˀ. Ditû̖ˀ wí toˀwí Jesus gin nakhá̖wä̖́ˀiˀ iˀ koḏi tsondi namuu.” ");
INSERT INTO tew_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Heḏiho in tꞌowa tꞌä̖hkí heḏá in búˀwin tsonnindá ditꞌoe ihayḏi ditꞌayyaapóe. ");
INSERT INTO tew_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ihayḏiho in tsonnindi Jason-dá in i-áḏí dijiˀindáḏí ovâychä̖ˀwáˀâakannan ovâymaˀpꞌä̖̂ä̖ḏi-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Wesebo iˀ khun in Jesus-víˀpiye dívíwä̖yundeˀindi Paul-á Barnabas-á wíyá búˀpiye ovä̂nsan, Berea gin dâytu̖ˀoˀiˀ. Iwe dapówá ihayḏi iˀ Huḏíyoví méesateˀay eepiye damää. ");
INSERT INTO tew_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","In tꞌowa iweˀindá in Thessalonica-winbí shánkí dikhâymuu ovä̂ntꞌôeyaaníḏí. Háa datú̖ˀin ditꞌôeyandaˀ, heḏi thamuwaagi Jôesi Táḏáví taˀnin dâytundoˀ dínhanginpúuwíḏí tigúba háa ovâytu̖ˀan waa taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Báyékí tꞌowa inbí híˀ ovä̂nwä̖yu̖, in diweḏi wên pꞌóˀḏéḏíˀin Greek senäˀdá kwiyä̖ˀdá dijiˀ. ");
INSERT INTO tew_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Hewänbo wên Thessalonica-win Huḏíyo dínhanginpóe Paul-dá Jôesi Táḏáví híˀ oe Berea wáˀ ovâytꞌôeˀoˀ, heḏiho iwepiye dimääḏi báyékí tꞌowa hânho ovâytꞌeˀyaˀnan. ");
INSERT INTO tew_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wesebo in Jesus-víˀpiye dívíwä̖yundeˀindi Paul oe mâapꞌoe kꞌáygépiye óesan, hebo Silas-á Timothy-á Berea-bo dänwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wên tꞌowa-áḏí Paul namää, heḏi indi Athens búˀpiye óehoˀ. Iwe iˀḏi ovâytu̖ˀan oe Berea-piye diwáymú-íˀin, Silas-á Timothy-áḏí ovä̂ntu̖ˀâ̖a̖míḏí hä̖̂ä̖ḏi dä́nkoḏi ihayḏi ivíˀpiye daˀä̖ä̖-íˀin. Heḏiho han dívíˀan. ");
INSERT INTO tew_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Waˀḏi Paul-di Silas-á Timothy-á oe Athens ovä̂ntsíkhaˀmáaḏíbo koḏi wínachanpóepí imúndeḏi báyékí hä̖ä̖wí dínkwꞌóˀdiˀ in tꞌowa dâykhíjéḏí inbí jôesi dínmuu waa dâycha̖a̖ˀiˀ. ");
INSERT INTO tew_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Heḏiho in Huḏíyoví méesateˀay ee báyékí ovâyhéeˀan Huḏíyo-á Huḏíyo dimuupíˀindá, toˀwên Jôesi Táḏá dâyˀaˀginmäˀin. Heḏá wáˀ thamuwaa-á búˀ pinge dâyhä̖ä̖wíku̖ˀchꞌáaḏeˀ iwe in toˀwên diphaḏemännindá ovâyhéeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Heḏá wêndá senäˀ wáˀ iwe dijiˀ, indá in Epicurean tꞌowa-á Stoic tꞌowa-á inbí há̖hkan dínmuuˀin dívíhá̖ˀoˀ. Nä́ˀin senäˀ Paul-áḏí dívítu̖hkandoḏi wên ditsikapóe, “Hânnan nä́ˀi hä̖hsóˀyó natunjiˀ?” Heḏá wêndá ditú̖, “Háḏéewáy piˀwên tꞌowaví jôesiví̖ˀgeḏi ihíˀmáa.” Gin ditû̖ˀ gá Paul-di Jesus-ví̖ˀgeḏi ovâytꞌôeˀoḏân, heḏi ovâytu̖máa nachuuˀin heḏá nawáywówápóeˀindá. ");
INSERT INTO tew_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Heḏiho in tunjowaˀvíˀpiye óehoˀ, ee okú eeḏi Areopagus gin dâytu̖ˀoˀiˀ, heḏi óetu̖ˀan, “Naˀindá gihanginˀândaˀ nä́ˀi tsꞌa̖a̖biˀ hä̖ä̖wí i̖ˀgeḏi u̖ˀḏi tꞌowa ovâyhá̖ˀoˀiˀ. Ti naˀin dítꞌôeˀa̖mí i̖ˀgeḏi? ");
INSERT INTO tew_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Báyékí hä̖ä̖wí nä́we bihéeˀandi wémûu wänbo wígitꞌoepí, heḏânho háa natundaˀin gínhanginnáaníˀin gidaˀ.” ");
INSERT INTO tew_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(In Athens-windáḏí heḏá in jáˀwéˀin tꞌowa iwe dithaaˀindáḏí hä̖̂ä̖ḏi wänbo tꞌä̖hkí hä̖ä̖wí wänbo tsꞌa̖a̖biˀ namuu i̖ˀgeḏiḏa̖ˀ dívíhíˀmáa heḏá ditꞌoeˀo. Heḏânkun han óetu̖ˀan Paul.) ");
INSERT INTO tew_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Heḏiho Paul in tunjowaˀví páaḏépiye iwí̖nú heḏi ovâytu̖ˀan, “Un Athens-ˀin tꞌowa, naaḏi wâymúndeˀ un báyékí únhä̖ä̖wíkwꞌóˀnin bînˀaˀginmäˀin. ");
INSERT INTO tew_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Unbí búˀ i̖ˀge ojiḏi wáyjé unbí jôesi bînˀaˀginmäˀi dómûˀ, heḏá wáˀ wí antâa-á dómûˀ, iwe bînhä̖ä̖wíkwꞌóeˀó iˀ bînˀaˀginmäˀigîˀ, heḏi eeḏi gin nataˀmuu: Wí jôesigîˀ nä́ˀi antâa âypaa, tobá iˀ âytaapí wänboˀ.’ Nä́ˀi maḏi bînˀaˀginmäˀ tobá bîntaapí wänboˀ, heḏiho nää-á iví̖ˀgeḏá naaḏá wâytꞌôekankhâymáa. ");
INSERT INTO tew_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“I-á Jôesi Táḏá namuu, i-á nä́ˀi nan oepáa-á heḏá iˀ hä̖ä̖wí tꞌä̖hkí iwe nakwꞌóˀdi-á ikhíjé, heḏi i-á oe makówá-á nä́ä nangá shánkí natsonjiˀ. Heḏânkun iˀ méesate tꞌowa dâykwꞌóḏi eejeḏa̖ˀmân wínathaapí. ");
INSERT INTO tew_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Heḏiho tꞌowavíˀweḏi khä̖geˀ wänbo wíˀûntáypí, gá hä̖ä̖wí wänbo tꞌowa dâypaˀi wíˀûntáypíḏân. Iˀḏânkun tꞌowa tꞌä̖hkí inbí wówátsi-á inbí hâ̖a̖-á heḏá hä̖ä̖wí díntáyˀi tꞌä̖hká ovâymäˀ. ");
INSERT INTO tew_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Jôesi Táḏáḏí wêe sen ikhíjé, heḏi iweḏiho tꞌä̖hkí nangeˀin tꞌowa dipu̖yä̖ nä́ä oepáa kꞌayḏi tꞌä̖hkí dívíthaayé-íḏí. Hewänbo in dipu̖yä̖píḏíboˀ Jôesi Táḏá iˀánshaaˀan hä̖̂ä̖ḏi heḏá wéngé dívíthaayé-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Jôesi Táḏáḏí in tꞌowa ovâykhíjé indi óenuuwä̖́-íḏí, heḏi háḏéebá óeshaa-í óetu̖wä̖máaḏí. Hewänbo taˀgendi naˀin tꞌowavíˀweḏi kayi̖ˀ wínajihpí, wêevíˀweḏi wänbo-á joe. ");
INSERT INTO tew_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jôesi Táḏá namuuḏânkun naˀin giwówájiˀ, heḏá ívíˀa̖ˀyänmáa, heḏá tꞌowa-á gimuu. Wáy wên unbí taˀkannin wänbo ditú̖, ‘Naˀin wänbo iví ây gimuu.’ ");
INSERT INTO tew_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Heḏiho Jôesi Táḏáví ây gimuuḏi wígínkhâyˀä̖hpí giˀâ̖a̖níˀin i-á wí hä̖ä̖wí waagiˀbá namuuˀin tꞌowa i̖ˀgeḏi diwänpiˀánshaapóeḏí inbí mandibo dâypaaˀiˀ óeḏoḏi háa kwä̖́kꞌu tsꞌä̖ˀiˀḏi háa kꞌuuḏi. ");
INSERT INTO tew_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Jôesiví̖ˀgeḏi tꞌowa híwó wíḏikaˀpóyaˀpí ihayḏi, iˀḏi wíˀovâytu̖ˀanpí ihayḏiho naná ovâytuhchä̖ä̖nú-íˀin, hewänbo nää tꞌowa tꞌä̖hkí wéngé tꞌä̖hkí dijiˀin ovâytu̖máa inbí tꞌaywóˀdi dâyjoeˀa̖míḏí wíˀovâytuhchä̖ä̖nú-ípíḏí, ");
INSERT INTO tew_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","gá owáy wí thaa ideˀmandiˀ nanáˀ diwe ovâytaˀgekeekwꞌôení tꞌä̖hkí tꞌowa háa híwó háa híwóhpí dívíˀannin, heḏi wí senho óesóge gin ovâytu̖ˀa̖míḏí, heḏi nä́ˀi sen óewáywówápaaḏi thayˀeeḏi dînkeeyan óesógeˀin” gin Paul-di ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wí toˀwí nachuuˀi nawáywówápóe i̖ˀgeḏi ditꞌoe ihayḏi, wên dipꞌâajiḏi tꞌä̖mäge Paul óetu̖máa, hewänbo wây-á wêndá ditú̖, “Owáy wíyá hä̖̂ä̖ḏi nä́ˀi bihéeˀandiˀ wíyá gitꞌoe-íˀin gidaˀ.” ");
INSERT INTO tew_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Heḏi Paul iweḏiho namää. ");
INSERT INTO tew_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wên senäˀ iví híˀ ônwä̖yu̖ḏi i-áḏí dívíwón. Wí sen in diweḏi Dionysius gin nakhá̖wä̖́, i-á Areopagus-wi tunjowaˀ diweḏiˀiˀbá namuu. Wí kwee wáˀ iwä̖yu̖, Damaris gin nakhá̖wä̖́ˀiˀ. Heḏá wáy wây-á tꞌowa iwe dijiˀin wáˀ dívíwä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nä́ˀi naphaḏe ihayḏi Paul Athens-di namää, heḏi Corinth búˀ napówá. ");
INSERT INTO tew_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Iwe wí Huḏíyo sen Aquila gin nakhá̖wä̖́ˀiˀ óetsꞌantaa, i-á oe Pontus nange naˀaypu̖yä̖. Iví kwijó Priscilla-áḏí Italy nange wä̖́hä̖̂ä̖ḏi datsꞌanpówá, gá iˀ Rome-wi tsondi pꞌóˀḏéḏîˀ Claudius-di tꞌä̖hkí in Huḏíyo oe Rome-di ovâykhehpiyeḏân. ");
INSERT INTO tew_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paul-á nä́ˀin wíjeˀinbíˀpiye namää heḏi indáḏí iwóyí̖ˀ. I-áḏí indáḏí teˀaapaˀin dimuuḏi wéˀge dívítꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kaykhanwówá thaa eeje Huḏíyoví méesateˀay eepiye Paul namääˀä̖, heḏi kayˀindi ovâyhéeˀoˀ. Ikhä̖ä̖ḏe Huḏíyo dimuuˀin heḏá Huḏíyo dimuupíˀindá iví híˀ ônsígíˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas-áḏí Timothy-áḏí Macedonia-ḏi dapówá ihayḏiho Paul wíyá wíˀiteˀaapaapí, hebo thaa tꞌä̖hkí Jôesi Táḏáví híˀ in tꞌowa ovâytꞌôeˀoˀ, heḏi thayˀeeḏi in Huḏíyo ovâyhá̖ˀoˀ Jesus-áho namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Hewänbo wíˀônsígíˀanpíḏí ivíˀpiye ditꞌayjaapóe, heḏá híwóhpîˀḏa̖ˀ iví̖ˀgeḏi dívíhéeˀan. Heḏiho iví aa iweḏi inaˀjeepíḏi ovâykeeya̖míḏí ovâyjoekankhâymáaˀin. Ovâytu̖ˀan, “Jôesi Táḏávíˀweḏi ípeḏeeḏá, unbíˀinnân únmuu, naa wíḏînchä̖ä̖nú-ípí. Nää iweḏi páaḏépiye in Huḏíyo dimuupíˀinnân nä́ˀi híˀ dovâytꞌôekankhâymáa.” ");
INSERT INTO tew_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Heḏiho ovâyjoeˀandi wí sen Justus gin nakhá̖wä̖́ˀivíˀpiye namää. Justus-á i Huḏíyoví méesateˀay núˀ nathaa, heḏi Jôesi Táḏá báyékí óeˀaˀgin. ");
INSERT INTO tew_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Iˀ Huḏíyo méesate pꞌóˀḏéḏîˀ nakhá̖wä̖́ Crispus gin. I-áḏí iví kꞌaygiˀindáḏí tꞌä̖hkí Nanbí Sedó Jesus-víˀpiye dívíwä̖yu̖, heḏá báyékí wây-á nä́ˀin Corinth-win tꞌowa wáˀ Jôesi Táḏáví tun ditꞌoeḏi dívíwä̖yu̖ḏáháˀ ovâypꞌóˀpꞌoeˀan. ");
INSERT INTO tew_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Wí khun Paul-di Nanbí Sedó Jesus óemûˀ waagibá ûnpóe, heḏi Paul óetu̖ˀan, “Wíˀunkhunwôedaˀípí ovâytꞌôeˀâ̖a̖míḏí naví̖ˀgeḏi, wíviwóyí̖ˀnípí. ");
INSERT INTO tew_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Naaḏi wíˀá̖yîngimáa, heḏiho wí toˀwíḏí wóeyâ̖ˀḏá háˀto wóewa̖ˀa̖mí, gá nä́ä búˀ báyékí tꞌowa navíˀin dînpúuwíˀin dithaaḏân.” ");
INSERT INTO tew_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Heḏiho Paul wí pa̖a̖yoḏá píngé ee búˀ iwóyí̖ˀ Jôesi Táḏáví híˀ ovâyhá̖ˀoḏi. ");
INSERT INTO tew_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Oe Achaia nange wä̖́hä̖̂ä̖ Gallio óepꞌóˀḏéḏîˀsóge ihayhä̖̂ä̖ḏibá, in Huḏíyo dívíwéˀgeˀandi Paul ûnkenmää, heḏi oe tunjó wháagépiye óehoˀḏi Gallio óetu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Nä́ˀi sendá tꞌowa ovâyhá̖ˀoˀ Jôesi Táḏá piháa óeˀaˀginmä̂äníḏí, nanbí khuu gínmuu waagá yoe.” ");
INSERT INTO tew_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul ihíˀkhâymáawän hebo Gallio-ḏi in Huḏíyo ovâytu̖ˀan, “Nä́ˀi sen wên háawin tꞌaywóˀnin heḏiháa wên háawin wä̖hphaḏe yä̖ˀḏâapíˀin namuuˀin iˀandáhoˀ, ihayḏânho híwó namúuní naa dáytsíkhaˀa̖mí unbí tꞌehpiḏe tun ivíˀpiye wâytꞌôeyaaníḏí. ");
INSERT INTO tew_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Hewänbo nää úvíwänpitu̖hä́nbo wáy wí tun namuu i̖ˀgeḏi, wáy wí khá̖wä̖́ namuu i̖ˀgeḏá, heḏá unbí khuu i̖ˀgeḏá. Heḏáho unnânho únpikhâyˀä̖ˀ nä́ˀi hä̖ä̖wí bînkoḏiˀa̖míˀin. Naa wóˀdaˀpí otú̖u̖níˀin giˀbi hä̖ä̖wí háa híwóˀdi háa híwóhpîˀ namuuˀin.” ");
INSERT INTO tew_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gin Gallio-ḏi ovâytu̖ˀan dihayḏi iˀ tunjó wháagé iweḏi ovâykhehpiye. ");
INSERT INTO tew_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ihayḏi in tꞌowaḏi nä́ˀi Huḏíyoví méesate pꞌóˀḏéḏîˀ óeyâ̖ˀ, i-á Sosthenes gin nakhá̖wä̖́, heḏi Gallio-ví páaḏépiyebo óewhä̖ˀ, hewänbo háa dívíˀoˀindi Gallio wíˀóeˀá̖yîngimä́gipí. ");
INSERT INTO tew_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul oe Corinth búˀbo wíyá hä̖́yú̖ thaa iwóyí̖ˀ, heḏáháˀ in wéˀgen Jesus-víˀpiye dívíwä̖yundeˀin ovâyjoeˀandi i-áḏí Priscilla-áḏí heḏá Priscilla-ví sen Aquila-áḏí oe Cenchrea búˀpiye dimää. Cenchrea iwe Paul óekꞌowa, tꞌowa ovâykeeya̖míḏí iˀannin háa Jôesi Táḏávíˀpiye iví tun imä́gi waa. Iweḏáháˀ kophé iweḏá oe Syria nangepiyá dimän. ");
INSERT INTO tew_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Hebo iwe dipówápíḏíboˀ oe Ephesus búˀpiye dimää, heḏi Aquila-áḏí Priscilla-áḏí ee búˀbo dänwóyí̖ˀ. Paul-dá ovä̂njoeˀandi in Huḏíyoví méesateˀay eepiyá namää, heḏi iwe in Huḏíyo-áḏí báyékí ihéeˀan. ");
INSERT INTO tew_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wêndi óedaaˀan báyékí thaa indáḏí iwóyí̖ˀníḏí, hewänbo Paul wínahíjepí. ");
INSERT INTO tew_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ovâysengitu̖ˀandi ovâytu̖ˀan, “Jôesi Táḏá natú̖ḏáho naa wíyá unbíˀpiye owáyˀä̖ä̖-í.” Heḏi iweḏi kophé iweḏi namää. ");
INSERT INTO tew_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Oe Caesarea búˀ napówá, iweḏáháˀ oe Jerusalem-piye namää in iweˀin méesateˀin tꞌowa ovâysengitu̖ˀâ̖a̖míḏí. Iweḏáháˀ oe Antioch-piyá namää. ");
INSERT INTO tew_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Iwáy wä̖́hä̖̂ä̖ báyékí thaa naˀä́n, heḏi iweḏi oe Galatia nange i̖ˀge tꞌä̖hkí heḏá Phrygia nange i̖ˀgá namää in Jesus-víˀpiye dívíwä̖yundeˀin ovâykhä̖geˀnamíḏí shánkí kayˀindi dívíwä̖ä̖yú̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ihayhä̖̂ä̖ḏibá wí Huḏíyo sen Alexandria búˀ iwe naˀaypu̖yä̖ˀiˀ Apollos gin nakhá̖wä̖́ˀiˀ oe Ephesus-bá napówá. Nä́ˀi sendá nahíˀmagan, heḏá Jôesi Táḏáví taˀnindá híwóˀdá ôntaa. ");
INSERT INTO tew_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","I-á Nanbí Sedó Jesus-ví khuu i̖ˀgeḏi ûnhanginná, heḏiho pín taˀgeḏi wây-á tꞌowa i̖ˀgeḏi ovâyhíˀmáa, heḏá á̖yîngiḏá Jesus-ví̖ˀgeḏi ovâyhá̖ˀoˀ, tobá John iˀ pꞌóˀpꞌoekandiví há̖hkan niˀgeḏiḏa̖ˀ ûnhanginnân wänboˀ. ");
INSERT INTO tew_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Khunwôedaˀginpíḏíboˀ in Huḏíyoví méesateˀay ee Apollos-di ovâyhéeˀan. Priscilla-áḏí Aquila-áḏí datꞌoe ihayḏi inbíˀpiye óehoˀ, heḏi Jôesi Táḏáví khuu shánkí thayˀeeḏi ônthayyan. ");
INSERT INTO tew_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Heḏáháˀ Apollos-á Achaia nangepiye napundaˀ, heḏi in Jesus-víˀpiye dívíwä̖yundeˀindi óetu̖ˀan híwó namuuˀin namú-íḏí, heḏiho indi in Achaia-win Jesus-víˀinbá ûnmuuˀin ovâytaˀnan Apollos óesígíkáyjíˀin. Apollos-á oe Achaia napówá ihayḏi báyékí ovâykhä̖geˀnan in toˀwên Jôesi Táḏáví sígísehkanä ûnmuuḏi Jesus-víˀpiye dívíwä̖yu̖ˀin. ");
INSERT INTO tew_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Iví tun ûnkay, heḏi in tꞌowa tꞌä̖hkíví páaḏépiye in Huḏíyo ovâytu̖ˀan piháa dívíwä̖yundeˀin, heḏi Jôesi Táḏáví taˀnin ovâytundoḏi ovâythayyan Jesus-á namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Waˀḏi Apollos oe Corinth búˀ wáy najiˀ ihayḏi, Paul iˀ nange i̖ˀgeḏi naˀä̖ä̖ḏi Ephesus búˀ napówá, heḏi wên tꞌowa John iˀ pꞌóˀpꞌoekandiví híˀ ônwä̖yu̖ˀin ovâymûˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paul-di ovâytsikaˀyan, “Ti nä́ˀi Yä̖ˀḏâaˀi pꞌoewa̖a̖hâ̖a̖ bînkêˀ úvíwä̖yu̖ ihayḏi?” Indi óetu̖ˀan, “Naˀin wígínhanginnáhpí wí Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ wänbo najiˀin.” ");
INSERT INTO tew_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paul-di ovâytsikaˀyan, “Háaḏan handi wovâypꞌóˀpꞌoeˀan?” Indi óetu̖ˀan, “Gá John iˀ pꞌóˀpꞌoekandiví há̖hkan âywä̖yu̖ḏân.” ");
INSERT INTO tew_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul-di ovâytu̖ˀan, “John-di in tꞌowa ovâypꞌóˀpꞌoeˀan gá inbí tꞌaywóˀdi dâyjoeˀandân, heḏi ovâytu̖máa, ‘Naví tíˀúugé wí napowagíˀoˀivíˀpiye úvíwä̖ä̖yú̖-í.’ Heḏi hä̖ˀi-á Jesus-ân namuu.” ");
INSERT INTO tew_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Paul-ví híˀ ditꞌoe ihayḏi ovâypꞌóˀpꞌoeˀan dâykeeya̖míḏí Nanbí Sedó Jesus-víˀpiye dívíwä̖yu̖ˀin. ");
INSERT INTO tew_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Heḏi Paul ivîˀḏi imankꞌûˀḏi iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ dínwân, heḏi wíyá piˀwí tundi dívíhíˀmáa, heḏá Jôesi Táḏáví tukheˀmin waabá dívíhéeˀan. ");
INSERT INTO tew_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Maḏi tä̖ˀḏi wíje senäˀ iwe dijiˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Poje pꞌóe tꞌä̖hkí Paul in Huḏíyoví méesate eepiye namääˀä̖, heḏi khunwôedaˀginpíḏíboˀ in tꞌowa ovâyhíˀmáa. Ovâythayjoˀ Jesus-ân namuu iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí, heḏi ikhä̖ä̖ḏeˀ iví híˀ ônsígíˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Hebo wáy wên dívípꞌóhkâyˀandi wíḏívíwä̖yu̖pí, heḏá Jesus-ví pꞌôe i̖ˀgeḏá híwóhpí-á in iwe dikwꞌóˀnin ovâyhéeˀan. Heḏânho Paul-di nä́ˀin ovâyjoeˀandi in Jesus-víˀpiye dívíwä̖yundeˀin i-áḏí ovâyhoˀ, heḏi wí tewhá eepiye dimää, wí sen Tyrannus gin nakhá̖wä̖́ˀiˀḏi tꞌowa ovâyhá̖ˀoˀ iwe. Iwá Paul-di thamuwaagi Jôesi Táḏáví híˀ ovâythayjoˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Wíje pa̖a̖yo tꞌä̖hkí Paul gin iˀan, heḏi handiḏi in tꞌowa Asia iwéngé dithaaˀin Naˀinbí Sedó Jesus-ví̖ˀgeḏi ditꞌoe, Huḏíyo dimuuˀindáḏí Huḏíyo dimuupíˀindáḏí. ");
INSERT INTO tew_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","12","Jôesi Táḏáḏí Paul óekhä̖geˀnan pínnán tꞌôe iˀa̖mídí, giˀbi hä̖ä̖wí in tꞌowa wémûu wänbo dâymûˀpîˀ, heḏiho aaˀây hä̖ä̖wí deḏantâa hä̖ä̖wí itä̖geˀiˀ in dihaykwꞌóˀninbíˀpiye ovâyhoˀ, heḏi dihehkháapóe, heḏá yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖-á in tꞌowa ovâymáaˀin dínpee. ");
INSERT INTO tew_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ihayhä̖̂ä̖bá wên Huḏíyo wáˀ wéngé tꞌä̖hkí dívíjíyénde nä́ˀin yä̖ˀḏâapíˀin pꞌoewa̖a̖hâ̖a̖ tꞌowavíˀweḏi ovâykhehpeeyé-íḏí. Nää-á indá dívíkhä̖ä̖ḏe hanbá dívíˀa̖míḏí Jesus-ví khá̖wä̖́ ônkhá̖yä̖́ˀdeḏi. Ginnân ovâytu̖máa in pꞌoewa̖a̖hâ̖a̖: “Nä́ˀi Jesus-ví khá̖wä̖́ dônkhá̖yä̖́ˀdeˀ, iví̖ˀgeḏi Paul-di in tꞌowa ovâytꞌôeˀoˀ, heḏiho naaḏi wítsonmáa nääbo ópeeve nä́ˀi tꞌowavíˀweḏi.” ");
INSERT INTO tew_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wí Huḏíyo owhaˀ pꞌóˀḏéḏîˀ Sceva gin nakhá̖wä̖́ˀi tsé ihay eˀnûn gin dívíˀoˀin ûnkwꞌó. ");
INSERT INTO tew_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Hewänbo han ditú̖ ihayḏi, iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi ovâytu̖ˀan, “Jesus dótaa, heḏá toˀwí Paul namuuˀindá dînhanginná. Hebo undá — toˀinnan ímuu?” ");
INSERT INTO tew_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Heḏi iˀ sen iˀ yä̖ˀḏâapîˀ pꞌoewa̖a̖hâ̖a̖ḏi óemáaˀiˀḏi ovâytsa̖a̖chä̖nuḏi hânho ovâymahpúu ovâytꞌan píhay, heḏi aawhée buugiˀnin diwa̖hkanmuuˀin iˀ tewhá iweḏi dishavepee. ");
INSERT INTO tew_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","In Ephesus búˀ dithaaˀin Huḏíyo-á Huḏíyo dimuupíˀindá dínhanginpóe háa dínpóeˀin, heḏiho dikhunwôedaˀpóe, heḏi ditû̖ˀ Nanbí Sedó Jesus hânho hayˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Heḏi báyékí in Jesus-víˀpiye dívíwä̖yu̖ˀin Paul-víˀwe dipówá, heḏi dívítꞌaywóˀdihä̖ä̖tsiˀandá dâykeekwꞌóḏi háa dívítsiyekanhonnin. ");
INSERT INTO tew_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wáy wên dichugekanhá̖ˀindá inbí chuge há̖hkan taˀdi dâykán, heḏi dâyphahá̖nú in tꞌowa tꞌä̖hkí dâymúuníḏí. Iˀ taˀdi hä̖́yú̖ nachä̖ˀmuuˀin dâymaapaa ihayḏi pꞌánä́ntä̖ maapaasôn (50,000) kwä̖́kꞌu tsꞌä̖ˀi chä̖ˀ napóe. ");
INSERT INTO tew_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Handiḏiho shánkí wänbo tꞌowa Nanbí Sedó Jôesi Táḏáví híˀ ditꞌoeˀo heḏá iˀpiyá dívíwä̖yundeˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nä́ˀi hä̖ä̖wí napóeˀi naphaḏe ihayḏi, Paul iˀánshaamä́gi namú-íḏí oe Macedonia nangepiye heḏá Achaia nangepiyá heḏáháˀ oe Jerusalem búˀpiyá. Natú̖, “Owáy eepiye omää ihayḏáháˀ dînkhâyˀä̖ˀ oe Rome-piye wáˀ omú-íˀin.” ");
INSERT INTO tew_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Oe Macedonia-piye wíje iví khä̖geˀnin isan, Timothy-á Erastus-á damuu, hebo i-á shánkí hây tä̖hkí oe Asia nangebo iwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ihayhä̖̂ä̖ḏi oe Ephesus báyékí tꞌowa ditꞌayyaapóe in Jesus-ví pꞌôe i̖ˀge dimänninbíˀwepiye. ");
INSERT INTO tew_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wí sen Demetrius gin nakhá̖wä̖́ˀiˀ iwe naˀä́n, i-á kwä̖́kꞌu tsꞌä̖ˀiˀḏi ihä̖ä̖wípaˀi namuu, heḏi méesate hí̖ˀíndi ipaˀ, nä́ˀi méesate-á iˀ kwee Diana dâyˀaˀginmäˀ iweˀi méesate hayˀi waagibá nakeetꞌóeˀiˀ. Demetrius-á heḏá in wéˀgen i-áḏí dívítꞌôemáaˀindá híwó hay chä̖ˀ díntsꞌúyaˀ inbí tꞌôe iweḏi. ");
INSERT INTO tew_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Heḏiho Demetrius-di iví tꞌôeˀin heḏá wây-á wêndá ha̖ˀbi tꞌôebá dívíˀoˀindá ovâywéˀgeˀan, heḏi ovâytu̖ˀan, “Kꞌemaˀin, únhanginná báyékí chä̖ˀ nanbí tꞌôe iweḏi gíntsꞌúyaˀnin. ");
INSERT INTO tew_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Unbo bînmûˀ heḏá ítꞌoe háa nä́ˀi sen Paul ikanhonnin. Iˀ natû̖ˀ in jôesi tꞌowa dâypaˀin dâyˀaˀginmä̂äníḏí taˀgennin jôesi wíḏimuupí, heḏi wíˀgíngí nä́ä Ephesus-á heḏá nä́ˀi Asia nange tꞌä̖hká tꞌowa iví híˀ ovâywä̖yu̖kannan, heḏá iví híˀ ûnmuuḏi báyékí tꞌowa Diana-víˀweḏi dívíjâaˀan. ");
INSERT INTO tew_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Háḏée nanbí tꞌôe i̖ˀgeḏi tꞌowa híwóhpí dívíˀánshaaˀa̖míˀin napúuwí. Heḏá iweḏá maḏi wáˀ napúuwí tꞌowa diˀâ̖a̖níˀin iˀ hayˀi kwee Diana iˀ toˀwí naˀindi âyˀaˀginmäˀiví méesate wíˀûnchä̖ˀmuupíˀin. Heḏá tobáháa tꞌä̖hkí tꞌowa nä́ä Asia-windáḏí heḏá in wéˀgen hä̖wéngé tꞌä̖hkí dithaaˀindáḏí nää óeˀaˀginmäˀ wänboˀ, maḏi nää iweḏi páaḏépiye diˀâ̖a̖ní hayˀi wínamuupíˀin.” ");
INSERT INTO tew_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","In tꞌowa háa Demetrius natú̖ˀin ditꞌoe ihayḏi hânho ditꞌayyaapóe, heḏi dívítu̖wí̖núnde gin, “Diana nä́ä Ephesus-wi namuuˀi báyékí hayˀi namuu.” ");
INSERT INTO tew_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Heḏi shánkí báyékí tꞌowa diwéˀgepóe, heḏi dívítꞌehtu̖wí̖núndeˀ, heḏi wên wíje senäˀ ovä̂nyâ̖ˀḏi ovä̂nkhóhkayˀan oe búˀ pinge tꞌowa dívíwéˀgeˀoˀ iwepiye. In senäˀdá Gaius-á Aristarchus-á gin dakhá̖wä̖́, indá Macedonia nangewin damuu, heḏi Paul-áḏí wéngé tꞌä̖hkí dänjíyéndeˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul in tꞌowa dikwꞌóˀ diwepiye natsuḏedaˀ ovâyhéeˀa̖míḏí, hewänbo in Jesus-víˀpiye dívíwä̖yundeˀindi óekhâ̖a̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Heḏá wên Asia-win pꞌóˀḏéḏíˀin senäˀ Paul-ví kꞌemaˀin ûnmuuˀindi Paul ôntꞌôesan óetu̖ˀâ̖a̖míḏí in tꞌowaví páaḏépiye wíˀikeehûuwípíˀin. ");
INSERT INTO tew_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","In tꞌowa tꞌä̖hkí wéˀge shánkí díntu̖hkwíntû̖ˀ. Wênho wên háawên dívítu̖wí̖núndeˀ, heḏá wây-á shánkí piháa wänbo-á. Wên hä̖́yú̖hayḏiḏa̖ˀ tꞌowa dínhanginná háaḏí diwéˀgepóeˀin. ");
INSERT INTO tew_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Heḏi in Huḏíyoḏi wí sen Alexander gin nakhá̖wä̖́ˀiˀ oe páaḏépiye óewí̖núḏí óetu̖ˀan háa natú̖u̖níˀin. Heḏiho Alexander imannan in tꞌowa dívítꞌôeyaaníḏí. Nadaˀ in tꞌowa ovâytu̖ˀâ̖a̖míˀin in Huḏíyo wíˀovâyhíwóhpíchä̖ä̖nú-ípíḏí nä́ˀi napuwamän niˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Hebo Alexander-á Huḏíyo namuuˀin in tꞌowa dínhanginpóe ihayḏi tꞌä̖hkíḏíbo maḏi wíje ôeḏa tꞌä̖hkí shánkí kaygi wänbo dívítu̖wí̖núndeˀ, “Nä́ˀi Ephesus-winbí Diana hânho hayˀi namuu” gin. ");
INSERT INTO tew_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tꞌôeḏiwän iˀ búˀwi taˀkandiḏi hânda̖ˀ ovâykannan in tꞌowa, heḏi ovâytu̖ˀan, “Un Ephesus-win ímuuˀin, tꞌä̖hkí tꞌowa wéngé tꞌä̖hkí dikwꞌóˀnin dínhanginnáhpíˀan naˀin Ephesus búˀwin tꞌowa nä́ˀi hayˀi Diana-ví méesate ûnmuuˀiˀ âyˀá̖yîngimáaˀin, heḏá iˀ kꞌuu Diana waagibá ûncha̖a̖ˀiˀ oe makówáḏí ûnkeˀtꞌá̖ˀdi-á wáˀ âyˀaˀgindoˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tóebo wûnkoḏipí natú̖u̖níḏí nä́ˀi hä̖ä̖wí taˀgen wínamuupíˀin. Heḏânho ánpí íkwoˀní, heḏi wíyá háawên wíˀúvíˀa̖mípí híwó úvíˀánshaapíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Undi nä́ˀin wíje senäˀ nä́äpiye bînmaa tobá hä̖ä̖wí wänbo méesate iweḏi wíḏä̂nsä̖ˀmanpí wänboˀ, heḏiháa nanbí Diana âyˀaˀginmäˀiví̖ˀgeḏi háawin tꞌaywóˀnin wíḏatú̖hpí wänboˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Heḏiho Demetrius-áḏí in i-áḏí dívítꞌôemáaˀindáḏí wí toˀwí ôntꞌeˀpꞌêeḏe-íˀin didaˀḏá, dínkhâyˀä̖ˀ óetsondiwekáaníˀin. In tsonnin dívíwéˀgekwꞌóeˀó tꞌowa ovâytunjóˀnamíḏí, heḏi in tꞌowaví tꞌehpiḏe tun ovâytꞌôeyandeˀ. ");
INSERT INTO tew_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Hebo wíyá hä̖ä̖wí i̖ˀgeḏi íhéedaˀḏá, heḏân úntsíkhakanpoeˀo in búˀwin pꞌóˀḏéḏíˀindi in tꞌowa tꞌä̖hkí ovâywéˀgeˀan píhay. ");
INSERT INTO tew_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nä́ˀi gin otú̖, gá maḏi in Rome-win tsonnin ditú̖u̖níḏân un nä́wewin tꞌowa unbí pꞌóˀḏéḏíˀindáḏíbo úvípihä́nmáaˀin. Háa nää thaa napóe waa wínakhâyˀä̖hpí napúuwíˀin, heḏi tóebo wíˀûnkoḏipí ovâytu̖ˀâ̖a̖míḏí háaḏí un tꞌowa úvítꞌaywéˀgeˀandi.” ");
INSERT INTO tew_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Heḏi han natú̖ ihayḏi ovâytu̖ˀan tꞌä̖hkíḏíboˀ inbíˀpiye dimú-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tꞌä̖hkí hânda̖ˀ napóe ihayḏi Paul-di in Jesus-víˀpiye dívíwä̖yundeˀin ovâywéˀgeˀan, heḏi ovâytu̖ˀan kwee waa sen waa diˀá̖ˀbe-íḏí. Heḏáháˀ ovâysengitu̖ˀandi ovâyjoeˀan oe Macedonia nangepiye namú-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ee Macedonia iwéngé tꞌä̖hkí ijíyéndeḏi in dívíwä̖yundeˀin iwe dikwꞌóˀnin wáˀ hanbá ovâyhéeˀan, heḏáháˀ oe Greece-piyá namää. ");
INSERT INTO tew_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Iwáy wä̖́hä̖̂ä̖ poje pꞌóe naˀä́n. Ihayḏáháˀ ikhâyˀan oe Syria nangepiye kophé iweḏi namú-íḏí, hewänbo ûnhanginpóe in Huḏíyo óeháyjí i̖ˀgeḏi dívíhíˀmáaḏí, heḏiho iví ánshaa iˀegóˀandi oe Macedonia nange i̖ˀge nawáymää. ");
INSERT INTO tew_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nä́ˀin senäˀ i-áḏí dimää: Sopater oe Berea búˀwiˀ, i-á Pyrrhus-ví eˀnú ûnmuu; Aristarchus-á heḏá Secundus-á oe Thessalonica búˀwin damuuˀindá; Gaius oe Derbe búˀwi-á; Tychicus-áḏí Trophimus-áḏí oe Asia nangewindá; heḏá Timothy-á. ");
INSERT INTO tew_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","6","Nä́ˀin senäˀ oe Troas búˀpiye dipáaḏémää, heḏi Paul-áḏí naa-áḏí oe Philippi búˀbo änwóyí̖ˀ, in Huḏíyoví shánkíˀeeḏi dínphaḏe píhay, nä́ˀi shánkíˀeeḏi dâytu̖ˀoˀ “Owáaseepîˀ Pává Dâykꞌoˀi Thaa” gin. Ihayḏá iweḏá kophé iweḏi gamää, heḏi pꞌánú thaa naphaḏe ihayḏi oe Troas gapówá, in wéˀgendi naˀin dítsíkhaˀmáa iwe, heḏi wí jâaḏi iwe gikwꞌó. ");
INSERT INTO tew_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dumîngu iwe ívíwéˀgeˀan iˀ méesa buwá âykꞌoˀíḏí, heḏi Paul-di díhíˀmáa. Khunpinu puwahayḏi ihéeˀan gá wíyá tháwä́n iweḏi ijâakankhâymáaḏân. ");
INSERT INTO tew_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tꞌä̖hkíḏíbo oe whaˀkꞌay íve giwéˀgekwꞌó, heḏi báyékí naphakókohsaa. ");
INSERT INTO tew_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Wí eˀnú Eutychus gin nakhá̖wä̖́ˀi nawháphóḏikhuucháˀ deeḏi naˀä́n, heḏi hânho najôedaˀpuwamän Paul thaa tꞌä̖hkí ihíˀmáaḏí. Té̖e̖gîndi najókhândi, naˀä́n diweḏi oe jáˀwépiye najókeˀtꞌá̖, heḏi óedaygiˀan dihayḏi chuˀi óeshaa. ");
INSERT INTO tew_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paul whaˀkꞌayḏi nawá̖, heḏi idégeˀdisógeḏi iˀ eˀnú óebaˀaakêˀ, heḏi ovâytu̖ˀan, “Ívíwoˀgi wíˀítaachanpúuwípí. Nä́ˀi-á nää nawówámuu.” ");
INSERT INTO tew_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Heḏiho wíyá oe whaˀkꞌaypiye napee, heḏi indáḏí ipáváháveḏi ihú̖u̖yan, heḏá shánkí ovâyhéeˀan nathay píhay. Ihayḏá ovâyjoeˀan. ");
INSERT INTO tew_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iˀ eˀnú ivíˀpiye indi wówáˀi óehoˀ, heḏi báyékí dihíhchan. ");
INSERT INTO tew_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","14","Paul-di ho dítu̖ˀan kophé iweḏi gipáaḏémú-í oe Assos búˀpiye iˀ âytsíkhaˀa̖míḏí, hebo i-á nangeḏibo namú-í heḏi iwe iˀ wáˀ iˀ kophé itokhâymáa. Heḏiho han ívíˀan, heḏáháˀ Assos iweḏá Mitylene búˀpiyá gimää. ");
INSERT INTO tew_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Iweḏá waˀḏi kophé iweḏi Chios-piye gimää, i-á pꞌojâaḏi namuu, heḏá wíyá tháwä́ndá wíyá pꞌojâaḏi Samos-á gipówá. Oe Trogyllium búˀ ívíwóyí̖ˀ, heḏá wíyá tháwä́ndá oe Miletus búˀ gipówá. ");
INSERT INTO tew_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul iˀánshaamä́gi oe Ephesus wíˀiwóyí̖ˀnípíḏí, báyékí thaa oe Asia nange i̖ˀge wínayê̖e̖nípíḏí. I-á nawóˀon oe Jerusalem napóewíḏí híwóˀ dihayḏiboˀ, in Huḏíyoví shánkíˀeeḏi thaa Pentecost gin dâytu̖ˀo dínnáhpíḏíboˀ, háḏéeho ûnkoḏiḏi. ");
INSERT INTO tew_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Waˀḏi Miletus wáy najiˀ ihayḏiboˀ, oe Ephesus búˀpiye itꞌôesan, in méesateˀin tsonnin ovâytu̖ˀa̖míḏí ivíˀpiye diˀä̖ä̖-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","In dipówá ihayḏi ovâytu̖ˀan, “Un tꞌä̖hkí únhanginná háawi sen omuuˀin iˀ páaḏéˀi thaa Asia opówá ihayḏi waabo nää puwahay. ");
INSERT INTO tew_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Naa Nanbí Sedó Jesus-gîˀ dáytꞌôeˀandi wíḏáypitegendepí. Hä̖́yä́n wänbo dáysíhtä̖ä̖ in tꞌowaví̖ˀgeḏi oˀá̖yîngipóeḏí. Báyékí tꞌôephaḏe dînpówá in Huḏíyoḏi díˀannin namuuḏi. ");
INSERT INTO tew_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Un únhanginná naa wíḏáywóyí̖ˀpíˀin hä̖ä̖wí wänbo úntáyˀi wâytu̖ˀoḏi wâykhä̖geˀnamíḏí, heḏá íwéˀgekwꞌóˀ deejá unbí wháagé i̖ˀgá wâyhá̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kayˀindi naaḏi wâytu̖ˀan wíˀgín Huḏíyo-á Huḏíyo ímuupíˀindá unbí tꞌaywóˀdi bînjoeˀa̖míˀin heḏá Jôesi Táḏávíˀpiye úvíbée-íˀindá, heḏá Nanbí Sedó Jesus Christ-víˀpiye úvíwä̖ä̖yú̖-í. ");
INSERT INTO tew_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Nää-á Jerusalem-piye omän, ginho iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi dítu̖ˀandi. Naa wíḏînhanginnáhpí háa owáy wä̖́hä̖̂ä̖ dînpuwagíˀoˀin, hewänbo nä́ˀindáho dînhanginná: ");
INSERT INTO tew_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nä́ä búˀ i̖ˀge otsꞌú̖ eeje tꞌä̖hkí, iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi dînthayyan taˀgendi dípansogekhâymáaˀin heḏá dontꞌôephaḏekhâymáaˀindá. ");
INSERT INTO tew_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Hewänbo háa dînpóe wänbo hä̖́ä̖bo wíḏînmuupí, tobáháa díháyjí háa owówápee-í wänboˀ. Naa owänpidaˀ dóboewá-íˀin in tꞌôe Nanbí Sedó Jesus-di dítu̖ˀan dóˀa̖míˀin. Heḏi nä́ˀin tꞌôe-á ginnân namuu: Iˀ híwó̖ˀdi tun Jôesi Táḏáví sígísehkanä i̖ˀgeḏi pín taˀgeḏi in tꞌowa dovâytꞌôeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Undáḏí naa ojiˀ Jôesi Táḏáví khuu i̖ˀgeḏi wâytꞌôeˀoḏi. Hewänbo nää dînhanginná wêeḏi wänbo un diweḏi háˀto wíyá dímúuníˀin. ");
INSERT INTO tew_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Heḏânho nää-á naaḏi taˀgendi wâytu̖ˀâ̖a̖mí nä́ˀin: Wí toˀwí Jôesi Táḏávíˀweḏi napeḏeeḏáhoˀ, tóebo wíˀûnkoḏipí naa dînchä̖ä̖nú-íḏí, ");
INSERT INTO tew_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","gá wóˀkhunwôedaˀpíḏân wâytu̖ˀâ̖a̖míḏí hä̖ä̖wí tꞌä̖hkí Jôesi Táḏá ikhâymáaˀin. ");
INSERT INTO tew_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Wíˀbo bípiˀá̖yîngiˀan, heḏá tꞌä̖hkí hä̖ˀin tꞌowa Jôesi Táḏávíˀin ûnmuuˀindá binˀá̖yîngiˀan, wí kꞌúwá á̖yí̖ˀdiˀ iví kꞌúwá iˀá̖yí̖ˀdo waagibá. Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi un wovâytsonninkwꞌóḏi, wên kꞌúwá á̖yí̖ˀnin waaginbá ímúuníḏí. In tꞌowa Jôesi Táḏáví méesate eejeˀin dimuuˀin ivíˀin ûnmuu, ingîˀ iví ay imä́giḏi iví ûnpꞌoe ichꞌâaníḏí. ");
INSERT INTO tew_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Naa dînhanginná owáy naaḏi wâyjoeˀan dihayḏáhoˀ, wây-á wên tꞌowa unbíˀye dipowagíˀo, wên tꞌayjaaˀin khunjó in kꞌúwá dâyhá̖a̖nú-íḏí diˀä̖ä̖ˀä̖ waagibá, ");
INSERT INTO tew_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","heḏi wáy wên unbí jâa dijiˀindi wänbo in Jesus-víˀpiye dívíwä̖yu̖ˀin ovâyhójoˀa̖mí, indáḏí dâypu̖hkannamíḏí. ");
INSERT INTO tew_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Heḏânho bíˀá̖yîngiˀan ha̖ˀmin tꞌowaḏi, heḏá wíˀúnˀôeḏe-ípí naaḏi poje pa̖a̖yo tꞌä̖hkí khu̖u̖-á thaa-á wâyhá̖ˀannin, heḏá un ímuuḏiho naví tsíˀpꞌoe donchꞌáa. ");
INSERT INTO tew_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nää wâytu̖máa, Jôesi Táḏáḏí wovâyˀá̖yîngiˀa̖mí heḏá wovâysígísehkanäˀoˀin wovâyhanginˀânnamí. Iˀ ûnkoḏi wovâykhä̖geˀnamíḏí kayˀin ípaa-íḏí heḏânho shánkí ivíˀpiye úvíwä̖ä̖yú̖-íḏí, heḏá wáˀ ûnkoḏi iˀ kä̖ˀä̖ä̖ únmuuˀi wovâydenkwꞌóḏiˀi wovâymä̂äníˀin. Heḏá toˀwên tꞌä̖hkí iˀḏi ovâydeˀmannin wáˀ nä́ˀi híwóˀdi hääwíbá diyä̖́mu-í. ");
INSERT INTO tew_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Wíyá toˀwíví chä̖ˀdá aa-á naagîˀ wóˀdaˀpí. ");
INSERT INTO tew_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Naví mandi dáytꞌôeˀandi iˀ dîntáyˀi donhógi, heḏá hanbá in toˀwên naa-áḏí dijiˀin díntáyˀi wáˀ ingîˀ dovâyhógi. Un tꞌä̖hkí nä́ˀin únhanginná. ");
INSERT INTO tew_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Naa hä̖̂ä̖ḏi wä̂nbo tꞌä̖hkí haˀwâa dáyˀan wâykeeya̖míḏí háa únkhâyˀä̖ˀin úvíˀa̖míˀin. Hânho úvíkhä̖ä̖-í toˀwên díntáyˀin bînkhä̖geˀnamíḏí. Wíˀúnˀôeḏe-ípí nä́ˀi tun Nanbí Sedó Jesus-ân wíˀbo natú̖ˀin: ‘Toˀwí imäˀi-á shánkí nahíhchan toˀwí ihóndeˀivíˀweḏi.”’ ");
INSERT INTO tew_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paul ihíˀbowa ihayḏi idégeˀdisóge heḏi tꞌä̖hkí in wéˀgendáḏí dívíjûusuˀan. ");
INSERT INTO tew_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tꞌä̖hkíḏíbo hânho dívísíhtä̖ä̖ḏi Paul óebaˀaakêˀ heḏi hânho óesígísengitu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Dikꞌáykháapóe iˀḏi ovâytu̖ˀandi, “Undi wíyá háˀto dímúuní” gin. Heḏáháˀ tꞌä̖hkíḏíbo naˀindáḏí iˀ kophé iwepiye dimää dísengitu̖ˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Naˀindi in tꞌowa âyjoeˀan dihayḏi iˀ pꞌojâaḏi Cos gin dâytu̖ˀoˀ iwepiye taˀgebo gimää. Wíyá tháwä́n oe pꞌojâaḏi Rhodes gin dâytu̖ˀoˀ iwepiye gimää, iweḏáháˀ oe Patara búˀpiyá. ");
INSERT INTO tew_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Iwe wíyá kophé oe Phoenicia nangepiye namändi naˀä́n, heḏi ívítógiḏi iweḏi gimää. ");
INSERT INTO tew_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Cyprus pꞌojâaḏi nanbí yä̖́ˀmä́ngéḏí nakꞌóe, heḏi iˀ giphademändi âymûˀ. Iweḏá oe Syria nangepiye gimää, heḏi Tyre búˀ gipówá. Wí hé iwepiye dâyhondiˀ dâydaykhâymáa. ");
INSERT INTO tew_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Waˀ gin dívíˀoḏi wên Jesus-víˀpiye dívíwä̖yundeˀin âynuwä̖, heḏi âyshaaḏi wí jâaḏi indáḏí ívíwóyí̖ˀ. Indi Paul óetu̖ˀan Jerusalem-piye wínamú-ípí gin, gá iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi ovâytu̖ˀandân háa ûnpuwagíˀoˀin. ");
INSERT INTO tew_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Naˀin kophépiye wíyá gimú-íḏí napóe ihayḏi, tꞌä̖hkí in senäˀ inbí kwiyä̖ˀ heḏá inbí áyyä̖̂ä̖ wóegé oe búˀ jáˀwépiye dípahoˀ, heḏi mâapꞌoe kíngéwi okhá̖ˀ deeḏi ívídégeˀdikwꞌóḏiḏi ívíjûusuˀan. ");
INSERT INTO tew_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ívísengitu̖hkanbowa ihayḏi naˀin gimännin iˀ kophé iwe ívítógi, heḏi in Tyre-windá dívíweehoˀ. ");
INSERT INTO tew_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tyre iweḏi gimää heḏi oe Ptolmais búˀ gipówá. In Jesus-víˀpiye dívíwä̖yundeˀin iwe dithaaˀin âysengitu̖ˀan, heḏi wí thaa indáḏí ívíwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wíyá tháwä́n iweḏi gipee, heḏi oe Caesarea búˀ gipówá. Wí sen Philip gin nakhá̖wä̖́ˀivíˀpiye gimää, i-á Jôesi Táḏáví híwó̖ˀdi tun ovâytꞌôeˀoˀi namuu, heḏi i-áḏí ívíwóyí̖ˀ. I-á wêe namuu in tséḏí dijiˀin senäˀ diweḏi, in oe Jerusalem ovâydeˀmannin in Jesus-ví tꞌôekhuwaˀin ovâykhä̖geˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Philip-á jónu aˀyûn khóhtsa̖a̖píˀin ûnkwꞌó, indá Jôesi Táḏáví tukheˀminnân ûnmuu. ");
INSERT INTO tew_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Hä̖́yú̖ thaa iwe gikwꞌôn dihayḏi wí sen Agabus gin nakhá̖wä̖́ˀiˀ oe Judea nangeḏi napówá. I-á wáˀ Jôesi Táḏáví tukheˀbibá namuu. ");
INSERT INTO tew_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Iˀ sen nanbíˀpiye naˀä̖ä̖, heḏi Paul-ví baˀáa ônkêˀḏi wíˀbo iví ândáḏí iví mandáḏí ipiwhiˀan, heḏi natú̖, “Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ natú̖, ginbá in Jerusalem-win Huḏíyoḏi óewhihkankhâymáa toˀwí nä́ˀin baˀáa ivíˀin ûnmuuˀiˀ, heḏá in Huḏíyo dimuupíˀinbí mange óekánkhâymáa.” ");
INSERT INTO tew_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nä́ˀin gitꞌoe ihayḏi in wéˀgen tꞌowa-áḏí kayˀindi Paul âytu̖máa oe Jerusalem-piye wínamú-ípí gin. ");
INSERT INTO tew_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Hebo Paul natú̖, “Hânnan úvíˀoˀ? Háaḏan íséejiˀ? Háaḏan díkꞌáykháaˀoˀ? Naa okhâymuu tꞌowaḏi díwhiˀa̖míḏíḏa̖ˀbá joe, okhâymuu wáˀ oe Jerusalem Nanbí Sedó Jesus-gîˀ ochuu-íḏí.” ");
INSERT INTO tew_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Wígínkoḏipí âyhíjekannamíḏí, heḏiho giwänpitú̖, “Háa Nanbí Sedó Jôesi Táḏá natú̖ waa napúuwí,” heḏi wíyá wíˀâytu̖ˀanpí. ");
INSERT INTO tew_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wíyá hä̖́yú̖ thaa naphaḏe ihayḏi nanbí hä̖ä̖wí âykhâyˀan heḏi Jerusalem-piye gimää. ");
INSERT INTO tew_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wên Caesarea-win Jesus-víˀpiye dívíwä̖yundeˀin naˀindáḏí dimää. Oe Jerusalem gipówáḏí Mnason-bí tewhá eepiye díhoˀ iwe gikwoníḏí. Nä́ˀi sendá Cyprus-wi namuu, heḏi wí in páaḏéˀin Jesus-víˀpiye dívíwä̖yundeˀinbíˀweḏiˀiˀbá namuu. ");
INSERT INTO tew_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","In Jerusalem-win Jesus-víˀpiye dívíwä̖yundeˀindi híhchandi dísígíhógi. ");
INSERT INTO tew_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wíyá tháwä́n Paul-áḏí naˀindáḏí James-víˀpiye gipu̖wä̖mää. Tꞌä̖hkí in méesateˀin tsonnin wáˀ iwe dikwꞌó. ");
INSERT INTO tew_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul-di ovâysengitu̖ˀan, heḏáháˀ tꞌä̖hkí háa napóe waabá ovâytu̖ˀan, háa Jôesi Táḏáḏí in Huḏíyo dimuupíˀin ovâyˀan waa in tꞌôe Paul iˀannin namuuḏi. ");
INSERT INTO tew_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ovâytꞌôeˀandi ditꞌoe ihayḏi Jôesi Táḏá kwꞌáayébo dâymáa. Heḏáháˀ Paul-á óetu̖ˀan, “Tíˀûu páaḏéˀiˀ, úhanginná báyékí maapaasôn in Huḏíyo wáˀ Jesus-víˀpiye dívíwä̖yu̖mä́giˀin, heḏi indá iˀ tsontun Moses itaˀnan deepiye hânho dívíkayˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nä́ˀin Huḏíyo uví̖ˀgeḏi ginnân ovâytu̖ˀan: U̖ˀḏi tꞌä̖hkí Huḏíyo in Huḏíyo dimuupíˀinbí nange eeje dithaaˀin ovâyhá̖ˀoˀ Moses-ví híˀ dâyˀaˀginnamípíˀin, heḏá inbí áyyä̖̂ä̖ in Huḏíyoví kꞌewe taaḏi wíˀovâytaaˀa̖mípíˀin, heḏá in Huḏíyoví khuu-á wíḏâyˀá̖yîngiˀa̖mípíˀindá. ");
INSERT INTO tew_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nä́ˀin Huḏíyo dimuuˀin Jesus-víˀpiye dívíwä̖yu̖ˀin taˀgendi dínhanginpúuwí u̖ nä́we unpówáˀin. Heḏiho ívítsikaˀyan háa gínkhâyˀä̖ˀ ívíˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Gá ginnân: U̖-á nä́ˀin wítu̖hkankhâymáaˀin óˀan. Nanbí jâa jónu senäˀ dijiˀ, inbí tun Jôesi Táḏá dâymä́giˀin háa igîˀ dívíkhâymáaˀin. ");
INSERT INTO tew_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Indáḏí ópûn, heḏi háa ditú̖ waa dívíbowaˀin dâykeeyan dihayḏi, u̖-á háa dívíˀo waa hanbá biˀa̖mí, heḏá ingîˀ ovâywáˀâa-í tꞌä̖hkí ovâykꞌoewá-íḏí. Gin biˀandáho tꞌä̖hkí tꞌowa dínhanginnáaní nä́ˀi Moses-ví tsontun mânˀaˀgindoˀin, heḏiho hä̖ä̖wí uví̖ˀgeḏi ditû̖ˀdi-á taˀgen wínamuupíˀin. ");
INSERT INTO tew_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Hewänbo in Huḏíyo dimuupíˀin Jesus-víˀpiye dívíwä̖yundeˀin naˀindi âytaˀnan âytu̖ˀâ̖a̖míḏí nä́ˀin naˀin âywéhpêeˀannin: Wíḏâykꞌoˀípí iˀ koegîˀ in wéˀgen tꞌowa inbí jôesi dâymä́giˀiˀ, heḏá wíḏâyˀûnpꞌoekꞌoˀípí, heḏá in animâa ovâykꞌéwhihá̖núˀinbí píví iˀ ûnpꞌoe napeepîˀ wáˀ wíḏâykꞌoˀípí, heḏá wíyá toˀwíví kwee-áḏí háa sendáḏí wíḏívíwhoˀkwꞌôenípí.” ");
INSERT INTO tew_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Heḏiho Paul-di in jónu senäˀ i-áḏí ovâyhoˀ, heḏi wíyá tháwä́n indáḏí háa dínkhâyˀä̖ˀ waa dívíˀan inbí khuu dâyˀaˀginnamíḏí, heḏi iˀ méesate hayˀi ee ditsꞌú̖ in owhaˀ ovâytu̖ˀâ̖a̖míḏí hä̖́yú̖ thaa ovâyhûuwíˀin nä́ˀi tꞌä̖hkí dâyboewá-íḏí. Ihayḏânho dâykꞌúwákha̖nugíˀo wíˀíngîˀ Jôesi Táḏá óemä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Heḏi iˀ jâaḏi naphaḏemän dihayḏi wên Huḏíyo Asia-windi Paul ee méesate hayˀiˀ iwe óemûˀ, heḏi indi in tꞌowa iwáygé dijiˀin Paul-víˀpiye ovâytꞌayjaaˀandáháˀ óeyâ̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ginnân dívítu̖wí̖núndeˀ: “Un tꞌowa Israel-win, díkhä̖geˀnan. Nä́ˀi-ân namuu iˀ sen wéngé tꞌä̖hkí tꞌowa ovâytu̖máaˀi nanbí khuu gínmuuˀi heḏá nanbí tꞌowa-á heḏá nä́ˀi méesate hayˀi-á háagîˀ wänbo wígínchä̖ˀmuupíˀin, heḏá wáˀ nä́ˀin Huḏíyo dimuupíˀin wänbo nä́ˀi méesate ee iˀḏi ovâytsꞌúḏe, heḏânho nä́ˀi tewhá Jôesi Táḏávîˀ ûnmuuˀiˀ ônˀaˀginhá̖nú.” ");
INSERT INTO tew_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Gin ditú̖ gá Trophimus oe Ephesus-wi óemûˀḏân Paul-áḏí oe búˀ i̖ˀge dajiḏi, heḏiho diˀân Paul-di iˀ méesate ee óetsꞌúḏeˀin. ");
INSERT INTO tew_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","In tꞌowa ee búˀ i̖ˀge tꞌä̖hkí ditꞌayjaapóe, heḏi wáy Paul nawin diwepiye dívíwä̖́nähoˀḏi óeyâ̖ˀḏi iˀ méesate eeḏi jáˀwépiye khóhkayḏi óehoˀ, heḏi in phóḏi dâytꞌíḏi. ");
INSERT INTO tew_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paul óeháyjíˀin didaˀ, heḏiho toˀwí iˀ Rome-win sundaḏoví pꞌóˀḏéḏîˀ tsondivíˀpiye namää óetꞌôeˀm̖íḏí in Jerusalem-win tꞌowa tꞌä̖hkí báyékí ditꞌayjaapóeˀin. ");
INSERT INTO tew_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Wesebo iˀḏi wên sundaḏo inbí tsonnin wóegé ovâywéˀgeˀan, heḏi indá owáy in tꞌowa dijiˀ iwepiye dívíˀä̖ä̖hoˀ. Iví sundaḏo wóegé dipówáḏí in tꞌowaḏi ovâymûˀ ihayḏi wesebo Paul óewhä̖́ḏiḏi dívíwóyí̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Iˀ sundaḏoví pꞌóˀḏéḏîˀ Paul-víˀpiye namääḏi iví khóe ônyâ̖ˀ, heḏi in sundaḏo ovâytu̖ˀan kaḏénaḏi óewhiˀa̖mí gin, heḏá in tꞌowa ovâytsikaˀyan, “To-an nä́ˀi sen namuu? Hânnan iˀan?” ");
INSERT INTO tew_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wên tꞌowa wí hä̖ä̖wí dívítu̖wí̖núndeˀ, wây-á wêndá hä̖ä̖wí piháa-á, heḏânho hânho díntu̖hkwíntû̖ˀdi wíˀûnkoḏipí ûnhanginpúuwíˀin taˀgendi háa napóeˀin. Heḏiho in sundaḏo ovâytu̖ˀan, “Nanbí sundaḏo tewhá iwepiyebo bîntsꞌûuḏe-í” gin. ");
INSERT INTO tew_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","In sundaḏoḏi iwáy sheˀáy iwepiye óehoˀ, heḏi iweḏáháˀ óetegekêˀḏi kwꞌáyepiye óepiye, gá in tꞌowa hânho dívítꞌayyaaˀoḏân, ");
INSERT INTO tew_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","heḏi Paul ûnwóemändi dívítu̖wí̖núndeˀ “Jaˀ âyháyjí” gin. ");
INSERT INTO tew_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","In sundaḏoḏi Paul inbíˀpiye óetsuḏehon dihayḏi, Paul-di Greek tundi iˀ sundaḏo pꞌóˀḏéḏîˀ óetu̖ˀan, “Ti wên háawên wítu̖ˀâ̖a̖mí?” Iˀḏi Paul óetu̖ˀan, “Naa wíḏînhanginnáhpíwän Greek tundi bihéeˀoˀin. ");
INSERT INTO tew_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Heḏiho u̖-á wíˀunmuupí iˀ to Egypt-wiˀ, wên tꞌowa iˀ nangewin tsonnindaḏí ovâyhä́nkannandiˀ, heḏáháˀ iˀḏi in jónu maapaasôn (4,000) senäˀ oe ahkónupiye ovâyhoˀ, tꞌowa tꞌakha̖nuˀin gin ovâytu̖ˀoˀin.” ");
INSERT INTO tew_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","“Joe” gin Paul natú̖, “Naa Huḏíyo-ân omuu. Tarsus búˀwibá omuu, hä̖ˀi-á wí búˀ hayˀiˀ oe Cilicia nange iweˀi namuu, heḏi iwe otháˀḏe. Ti nä́ˀin tꞌowa naa díhíˀmä̂äní?” ");
INSERT INTO tew_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Heḏiho in tꞌowa ovâyhéeˀa̖míḏí óemä́giḏi Paul sheˀáy kwꞌáye wáy iwí̖nú, heḏi imannan dívítꞌôeyaaníḏí. Ditu̖hán dihayḏi inbí Hebrew tundi ovâyhéeˀan. Ginnân ovâytu̖ˀan: ");
INSERT INTO tew_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mä́ˀmä̂äˀindá tíˀûuwin páaḏéˀindá, bítꞌôeyan. Naaḏi wâytu̖hkankhâymáa naa háawên wänbo híwóhpíˀin wíḏáyˀanpíˀin.” ");
INSERT INTO tew_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebrew tundi ovâyhíˀmáaḏi ditꞌoe ihayḏi shánkí wänbo hânda̖ˀ dínpóe. ");
INSERT INTO tew_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Heḏáháˀ ovâytu̖ˀan, “Naa Huḏíyo-ân omuu. Oe Tarsus búˀ Cilicia nange iwe oˀaypu̖yä̖, hewänbo nä́ä Jerusalem osôe. Gamaliel naví há̖hkandi dînmuu, heḏi iˀḏi á̖yîngiḏi nanbí thehtáy pahpáˀinbí khuu naa díhá̖ˀan. Háa Jôesi Táḏá nadaˀ waagi naa pín taˀgeḏi odaˀ dáyˀa̖míˀin, nää thaa un íkandaˀ waagibá, ");
INSERT INTO tew_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","heḏânho naa osôeḏi oˀân híwó namúuníˀin hä̖ˀin Jesus-ví pꞌóegé diˀa̖hsaaˀin báyékí tꞌôephaḏe iwe dovâykáaníḏí ovâytꞌahá̖a̖nú-íḏí, heḏi naa otsonpóeḏí kwiyä̖ˀdá senäˀdá ovâywhiˀankíḏáháˀ ovâypankwꞌóḏi. ");
INSERT INTO tew_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Iˀ owhaˀ pꞌóˀḏéḏîˀ-áḏí heḏá in tunjowaˀ-áḏí dínkoḏi wovâytu̖ˀâ̖a̖míḏí naaḏi in taˀgen wâytu̖máaˀin. Indá wí taˀdi naa dímä́gi nanbí Huḏíyo tꞌowa oe Damascus búˀ dovâymä̂äníḏí, heḏi naa omää in tꞌowa Jesus-víˀpiye dívíwä̖yundeˀin owáy wä̖́hä̖̂ä̖ dikwꞌóˀnin dovâypanhóeníḏí heḏá nä́ä Jerusalem-piye dovâywáymáˀíḏí ovâytuhchä̖ä̖nú-íḏí.” ");
INSERT INTO tew_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Naa pꞌóegé omändi oe Damascus búˀ opowamän dihayḏi taage púnúˀḏí naná. Tsíkhagipí wí ko makówáḏí nawá̖ heḏi díˀánkêˀ. ");
INSERT INTO tew_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nangepiye okanu, heḏi wí toˀwíḏí naa díhíˀmáaḏí otꞌoe. Ginnân natú̖: ‘Saul, Saul, háaḏan u̖ˀḏi naa dítꞌôephaḏekandoˀ?’ ");
INSERT INTO tew_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Naa otsikapóe, ‘Nanbí Sedó, to-an unmuu?’. Iˀḏá dítu̖ˀan, ‘Naa Jesus Nazareth-wi omuu. Naa iˀ u̖ˀḏi dítꞌôephaḏekandoˀi-ân omuu.’ ");
INSERT INTO tew_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","In toˀwên naa-áḏí dijiˀin iˀ ko dâymûˀ, hebo iˀ toˀwíḏí díhíˀmáaˀiví tun wíḏikaˀpówápí. ");
INSERT INTO tew_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Naa otú̖, ‘Nanbí Sedó, hânnan dáyˀa̖mí?’ Iˀḏi dítu̖ˀan, ‘Ówí̖núḏí oe Damascus-piye ópûn, heḏi iwe wóetu̖ˀa̖mí háa úkhâyˀä̖ˀ biˀa̖míˀin.’ ");
INSERT INTO tew_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Iˀ ko hânho nakayḏi naa otsíˀtꞌaapóe, heḏiho in naa-áḏí dijiˀindi naa dípahtsa̖a̖kêˀ, heḏi handiḏi oe Damascus opówá. ");
INSERT INTO tew_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Wí sen Ananias gin nakhá̖wä̖́ˀiˀ iwe nathaa. Nä́ˀi sendá taˀgendi Jôesi Táḏá óeˀaˀgin, heḏá in Huḏíyoví khuu-á tꞌä̖hkí ihon, heḏi tꞌä̖hkí in Huḏíyo Damascus dithaaˀin ditû̖ˀ híwóˀdi sen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Navíˀpiye naˀä̖ä̖ḏi naví núˀ iwí̖nú, heḏi dítu̖ˀan, ‘Tíˀûu páaḏéˀi Saul, uví keetan mänkeˀ.’ Wesebo naví keetan donkêˀḏi iˀ dómûˀ. ");
INSERT INTO tew_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Iˀḏi naa ginnân dítu̖ˀan: ‘Jôesi Táḏá nanbí thehtáy pahpáˀindi óeˀaˀginmäˀiˀḏân wóedeˀman háa nakandaˀin úhanginnáaníḏí, heḏá Jesus i toˀwí iví wówátsi taˀge ihondi namuuˀi nâamúuníḏá, heḏá iˀ tun wóetu̖hkankhâymáaˀiˀ untꞌoe-íḏá. ");
INSERT INTO tew_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Taˀgendân u̖ˀ iˀgîˀ bihéeˀa̖mí, heḏi u̖ˀḏi tꞌowa tꞌä̖hkí hä̖ä̖wí nâamûˀi heḏá untꞌoeˀi-á ovâytu̖ˀâ̖a̖mí. ");
INSERT INTO tew_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Heḏiho nää wíyá shánkí wívitsíkhaˀa̖mípí. Ópûn, unpꞌóˀpꞌoepúuwí, heḏá Jesus nádaaˀan uví tꞌaywóˀdi wônjâaˀa̖míḏí,’ gin Ananias-di dítu̖ˀan.” ");
INSERT INTO tew_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalem-piye owáymää ihayḏi iˀ méesate hayˀi ee otsꞌú̖ˀdi oˀä̖̂ä̖jiˀ waabá dînpóe. ");
INSERT INTO tew_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Iˀ ä̖̂ä̖ iwe Nanbí Sedó Jesus dómûˀ, heḏi dítu̖ˀan, ‘Oe Jerusalem hä̖ä̖wí naví̖ˀgeḏi ovâytu̖hkankhâymáaˀi háˀto wônsígíˀa̖mí, heḏiho ówä̖́näkiˀ, iweḏi ópeeve.’ ");
INSERT INTO tew_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Heḏi naa otú̖, ‘Hewänbo Nanbí Sedó, indá dínhanginnân naa wéngé tꞌä̖hkí iˀ Huḏíyoví méesate eeje dáyjíyéndewän in uvíˀpiye dívíwä̖yundeˀin dovâypanhóeníḏí heḏá dovâywhä̖́ä̖níḏá. ");
INSERT INTO tew_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Heḏi Stephen iˀ uví̖ˀgeḏi ovâytꞌôeˀandiví ûnpꞌoe ônchꞌáa ihayḏi, naa wáˀ okꞌaawin ee núˀ. In toˀwêndi óehéyi̖ˀninbí kꞌéwéˀi aa dovâyˀá̖yînmáa, heḏi híwó dívíˀoˀ gin naa oˀân.’ ");
INSERT INTO tew_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Hewänbo Nanbí Sedó Jesus-di dítu̖ˀan, ‘Ópûn, naaḏi kayi̖ˀ wä̖́hä̖̂ä̖piye wísankhâymáa, in Huḏíyo dimuupíˀinbíˀwepiye.’ ” ");
INSERT INTO tew_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","In tꞌowaḏi Paul ôntꞌôeyandeˀ, hewänbo nä́ˀi híˀ in Huḏíyo dimuupíˀinbí̖ˀgeḏi natú̖ ihayḏi dívítꞌehtu̖wí̖nú, “Binheˀ, wínachä̖ˀmuupí nawówáyê̖e̖níḏí.” ");
INSERT INTO tew_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wíḏitu̖hándepíḏí shánkí dívítu̖wí̖núndeˀ, heḏi inbí kꞌéwéˀi aa dâytha̖tha̖ˀoˀ heḏá kwꞌáyepiye dâynahchä̖nunde dâykeeya̖míḏí ditꞌayˀin. ");
INSERT INTO tew_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Iˀ Rome sundaḏo pꞌóˀḏéḏîˀḏi in sundaḏo ovâytu̖ˀan Paul inbíˀpiye óetsꞌûuḏe-íˀin óewhä̖́hwhä̖́ˀnamíḏí heḏânho ûnhanginpúuwíḏí háaḏí in tꞌowa Paul-víˀpiye dívítꞌehtu̖wí̖núndeˀ. ");
INSERT INTO tew_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Heḏiho óewhiwí̖nú púwhí̖ˀdí óewhä̖́ä̖níḏí, hebo Paul-di óetu̖ˀan in tä̖gintä̖ (100) sundaḏoví tsondi iwe tsowa nawindiˀ, “Ti iˀ tsontun natû̖ˀ úkꞌóeˀin naa díwhä̖́ä̖níḏí? Naa-á oe Rome dînkhá̖wä̖́taˀkꞌóe, heḏi waˀḏi wívînkeekꞌûˀpí háa naa híwóhpí dáyˀannin háa joe.” ");
INSERT INTO tew_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nä́ˀin natꞌoe ihayḏi in sundaḏoví shánkí pꞌóˀḏéḏîˀvíˀpiye namää heḏi óetu̖ˀan, “Ti úhanginná háa bitsiyekhâyˀoˀin? Nä́ˀi sendá oe Rome ûnkhá̖wä̖́taˀkꞌóe.” ");
INSERT INTO tew_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Iˀ sundaḏoví shánkí pꞌóˀḏéḏîˀ Paul-víˀpiye namääḏi óetu̖ˀan, “Dítu̖ˀan, ti oe Rome úkhá̖wä̖́taˀkꞌóe?” “Heḏân hoi” gin Paul natú̖. ");
INSERT INTO tew_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Óetu̖ˀan Paul, “Naa oe Rome dînkhá̖wä̖́taˀkꞌúwíḏí báyékí chä̖ˀ dáywáˀâa.” Paul-di óetu̖ˀan, “Naví táḏáˀin Rome-win tꞌowa damuuḏiho naa wáˀ Rome-wibá omuu.” ");
INSERT INTO tew_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wesebo in toˀwên Paul óetsikakhâymáaˀin ivíˀweḏi dívíjâatä̖ä̖. Iˀ sundaḏo tsondi pꞌóˀḏéḏîˀ wänbo nakhunwôedaˀpóe ûnhanginpóeḏí Paul-á Rome-wi tꞌowabá namuuˀin, gá iˀbáho natsonpóeḏân kaḏénaḏi Paul óewhiˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Iˀ sundaḏo tsondi pꞌóˀḏéḏîˀ nahanginˀândaˀ taˀgendi háawin híwóhpíˀin in Huḏíyoḏi Paul ônchä̖nundeˀin, heḏiho wíyá tháwä́n óewhihsuu heḏi in Huḏíyo owhaˀ pꞌóˀḏéḏíˀin heḏá in wéˀgen Huḏíyo pꞌóˀḏéḏíˀindá dívíwéˀgeˀa̖míˀin ovâytu̖ˀan. Ihayḏiho Paul óetsꞌúḏe inbí páaḏépiye óewé̖e̖nú-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul-di in tunjowaˀ taˀge ovâymúndeḏi ovâytu̖ˀan, “Tíˀûuwin páaḏéˀin, Jôesi Táḏáví páaḏépiye nä́ˀin naaḏi wâytu̖ˀâ̖a̖mí: Naví píˀnä́ khóˀjé dînhanginná naví wówátsi thaa tꞌä̖hkí híwóˀnin wówátsi donhonnin.” ");
INSERT INTO tew_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nä́ˀin natꞌoeḏi Ananias iˀ owhaˀ pꞌóˀḏéḏîˀ namuuˀiˀḏi in Paul-ví núˀ diwinnin ovâytu̖ˀan sóe eeḏi óemaphâave-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paul-di óetu̖ˀan, “U̖-ân Jôesi Táḏáḏí wóemaphavekhâymáa. Wí paa ijánúmáaˀi waagiˀbá unmuu. Úkhâyˀä̖ˀ úhanginpúuwíˀin háa wên tꞌaywóˀnin dáyˀannin háa joe, nä́ˀi tsontun namuuˀi natû̖ˀ waagi, hewänbo u̖ wíˀbo hä̖ˀi tsontunbá wínâaˀaˀginpí, nä́ˀin tꞌowa dísómaphâave-íˀin ovâytu̖ˀandi.” ");
INSERT INTO tew_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","In iwe diwinnindi Paul óetu̖ˀan, “Háaḏan Jôesi Táḏáví owhaˀ pꞌóˀḏéḏîˀ uví híˀḏí mânˀaˀginhá̖núndeˀ?” ");
INSERT INTO tew_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul-di ovâytu̖ˀan, “Tíˀûuwin páaḏéˀin, naa wíḏînhanginnáhpí owhaˀ pꞌóˀḏéḏîˀ namuuˀin. Dînhanginnândáho háˀto han otú̖u̖níwän, gá Jôesi Táḏáví taˀnin diwe ginnân nataˀmuuḏân: Wígínkhâyˀä̖hpí wên háawên tꞌaywóˀnin nanbí tꞌowaví tsonninbí̖ˀgeḏi gitú̖u̖níˀin.” ");
INSERT INTO tew_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Heḏi Paul-di ovâymûˀ wáy wên in iwe dijiˀin Sadducee tꞌowa dimuuˀin heḏá wêndá Pharisee tꞌowa-á. Heḏiho kaygi in tunjowaˀ ovâytu̖ˀan, “Tíˀûuwin páaḏéˀin, naa Pharisee tꞌowa-ân omuu, naví táḏá Pharisee-bá dînmuu. Nä́we dítsondiwekán gá in dichuuˀin diwáywówápúuwíˀin dáywä̖yundeḏân.” ");
INSERT INTO tew_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Han ovâytu̖ˀan dihayḏi in Pharisees-áḏí in Sadducees-áḏí dívítu̖hkannan, heḏi diwijeḏeeḏi wêegeˀin dipóe. ");
INSERT INTO tew_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Gin dívíˀan gá in Sadducee tꞌowa wíḏívíwä̖yundepíḏân in dichuuˀin wíyá diwáywówápúuwíˀin, heḏá pꞌoewa̖a̖hâ̖a̖-á makówáwin tꞌôepa̖ˀa̖a̖ˀindá dijiˀin wíḏívíwä̖yundepí; hewänbo in Pharisee tꞌowa-á dívíwä̖yunde diji-ákun. ");
INSERT INTO tew_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","In tꞌowa tꞌä̖hkí shánkí kaygi dívítu̖wí̖núndeˀ, heḏi wên Huḏíyoví khuu dâyhá̖ˀoˀin, Pharisee tꞌowabá dimuuˀin, dívíwí̖núḏí kayˀindi ditú̖, “Nä́ˀi sendá wên háawin tꞌaywóˀnin iˀannin wänbo wíˀâyshaaḏepí. Maḏi háḏéewáy wí pꞌoewa̖a̖hâ̖a̖ḏi háa wí makówáwi tꞌôepa̖ˀa̖a̖ˀiˀḏi taˀgendi óehéeˀan.” ");
INSERT INTO tew_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hânho dívítu̖hkandoḏi dívítsa̖a̖khâyˀoˀ, heḏiho iˀ sundaḏo tsondi pꞌóˀḏéḏîˀ nakhunwôedaˀpóe. Naˀánde Paul hânho óewa̖ˀa̖míˀin, heḏiho in sundaḏo ovâyjôn, “Jaˀ bípûn, Paul bînkêˀḏi hä̖ˀin Huḏíyovíˀweḏi bînjâaˀa̖mí, heḏi unbíˀpiyebo bintsꞌuḏe.” ");
INSERT INTO tew_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Iˀ khun Paul-ví hânge Nanbí Sedó Jesus nakwi̖nuḏeeḏi óetu̖ˀan, “Wíˀunkhunwôedaˀípí. U̖ˀ oe Jerusalem naví̖ˀgeḏi ho bihéeˀan, heḏá oe Rome hanbá bikhâymáa.” ");
INSERT INTO tew_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Wíyá tháwä́n héḏéndí wên Huḏíyo dívíwéˀgeˀan dívíhéeˀa̖míḏí wên ánshaa dâykꞌúuwíḏí. Ditú̖, “Ívíha̖a̖ḏä́khâymáa, heḏi wíˀívíhúukankhâymáapí Paul âyhay píhay. Han ívíˀanpíḏá, tobá Jôesi Táḏáḏí dítuhchä̖ä̖nú-í.” Nä́ˀin gin ditú̖ˀin jónä́ntä̖ˀḏiví (40) shánkí dijiˀ. ");
INSERT INTO tew_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Heḏi dimää in owhaˀ pꞌóˀḏéḏíˀindá heḏá in Huḏíyo tsonnindá inbíˀwepiye, heḏi háa dâywéhpêeˀannin ovâytu̖ˀan. Háa dikandaˀ i̖ˀgeḏi ovâythayyan dihayḏiho ovâytu̖ˀan, ");
INSERT INTO tew_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","“Nää undáḏí heḏá in tunjowaˀdáḏá iˀ sundaḏoví tsondi pꞌóˀḏéḏîˀ bintꞌôesân. Bintu̖ˀan Paul nä́ä unbíˀpiye óemáˀíˀin. Bintu̖ˀan shánkí íhanginˀândaˀ háa Paul iˀannin. Naˀindáho gikhâymúuní âyháyjíḏí nä́ä tsowa napówápíḏíboˀ.” ");
INSERT INTO tew_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Hebo Paul-ví mä́ämäˀay natꞌoe dívíkhakwogíˀoˀin óeháyjíḏí, heḏiho in sundaḏovíˀpiye natsꞌûndi i̖ˀgeḏi Paul óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paul-di wí tä̖gintä̖ (100) sundaḏoví tsondi óetu̖hkánnandi óetu̖ˀan, “Nä́ˀi eˀnú iˀ sundaḏo tsondi pꞌóˀḏéḏîˀvíˀpiye náhûu. Iˀ eˀnúḏí wên háawên óetu̖ˀa̖míˀin nadaˀ.” ");
INSERT INTO tew_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Heḏiho iˀ eˀnú iˀ sundaḏoví tsondi pꞌóˀḏéḏîˀvíˀpiye óehoˀ, heḏi óetu̖ˀan, “Paul iˀ to gínpannä́ndiˀḏi naa dítu̖hkánnandi dítu̖ˀan nä́ˀi eˀnú uvíˀpiye dómáˀí gin, wên háawên wóetu̖ˀâ̖a̖míˀin nadaˀḏi.” ");
INSERT INTO tew_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Iˀ sundaḏoví tsondi pꞌóˀḏéḏîˀḏi iˀ eˀnú oe hângepiye óepahtsa̖a̖kêˀ wíˀbo dayê̖e̖níḏí, heḏi óetsikaˀyan, “Hä̖ä̖-an naa dítꞌôeˀa̖míˀin undaˀ?” ");
INSERT INTO tew_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Iˀ eˀnúḏí óetu̖ˀan, “In Huḏíyo dâywéhpêeˀan wóedaaˀa̖míḏí thaˀdi Paul tunjówháagépiye óehûuwíḏí, háa iˀannin shánkí dihanginˀândaˀ waagibá. ");
INSERT INTO tew_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Hebo wíwóewä̖yu̖kannamípí. Jónä́ntä̖ˀḏiví (40) shánkí senäˀ dívíkhakwꞌó óeháyjíḏí. Jôesi Táḏáví páaḏépiye dívítunmä́gi wíḏívíhú̖u̖ya̖mípíˀin wíḏâypꞌoesu̖u̖wä̖́-ípíˀin Paul óehay píhay. Nää dikhâymuu heḏi ditsíkha u̖ˀ untú̖u̖níḏí iˀ nâasaaníˀin.” ");
INSERT INTO tew_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Óetu̖ˀan iˀ eˀnú, “Toˀwí wänbo wínâatu̖ˀâ̖a̖mípí nä́ˀi dítꞌôeˀandiˀ.” Heḏi iwáygéḏí óesan. ");
INSERT INTO tew_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Heḏi iˀ sundaḏoví tsondi pꞌóˀḏéḏîˀḏi wây-á wíje senäˀ ovä̂ntu̖hkánnan, indá tä̖gintä̖ (100) sundaḏo dä̂ntsonmáaˀin damuu, heḏi ovä̂ntu̖ˀan, “Wíje tä̖gintä̖ (200) sundaḏo nangeḏiˀindá, heḏá tségíntä̖ (70) kwä̖́ä̖jêe kꞌéwéḏíˀin sundaḏo-á, heḏá wây-á wíje tä̖gintä̖ (200) júnphé wóegéˀin sundaḏo-á ovâytu̖ˀan dívíkhâyˀa̖míˀin, nää khun whä̖nu iwáypiye oe Caesarea-piye dimú-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Heḏá wíje wên kwä̖́ä̖jêe Paul iˀíhsôege-ígîˀ binpútesoge, heḏi oe Felix iˀ tunjóvíˀwepiye binˀá̖yînhûu.” ");
INSERT INTO tew_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Heḏi wên taˀnin itaˀnandi gin natú̖: ");
INSERT INTO tew_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Naví tunjó Felix hânho wíˀaˀgindiˀ, naa Claudius Lysias-di wísengitu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Wên Huḏíyoḏi wí sen Paul gin nakhá̖wä̖́ˀiˀ óeyâ̖ˀḏi óekheˀkhâymáawän, hewänbo naa dînhanginpóe i-á oe Rome ûnkhá̖wä̖́taˀkꞌoeˀin, heḏiho in sundaḏo-áḏí omää inbí mangeḏi dójâaˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Háawin híwóhpíˀin ônchä̖nundeˀin naa ohanginˀândaˀ, heḏiho inbí tunjówháagépiye naaḏi dóhoˀ. ");
INSERT INTO tew_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Naa dînhanginpóe in híwóhpíˀin ôntꞌeˀpꞌíḏéndeˀindá wên háawin kâyˀin wänbo óepansôege-íḏí háa óeháyjíḏí wínamuupíˀin. In Huḏíyo wên háawên inbí khuu i̖ˀgeḏiḏa̖ˀ dívíwänpihíˀmáa. ");
INSERT INTO tew_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ihayḏáháˀ toˀwíḏí naa dítꞌôeˀan dâywéhpêeˀannin nä́ˀi sen óekhegíˀoˀin, heḏiho wesebo uvíˀpiye iˀ dósan, heḏi in toˀwên in híwóhpíˀin ôntꞌeˀpꞌíḏéndeˀin dovâytu̖ˀan uvíˀpiyân dimú-íˀin wóetu̖ˀâ̖a̖míḏí háaḏí ivíˀpiye ditꞌayˀin” gin itaˀnan. ");
INSERT INTO tew_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Heḏiho in sundaḏo háa ovâyjôn waagi dívíˀan. Khu̖ˀḏéeḏí oe Antipatris búˀpiye Paul óehoˀ. ");
INSERT INTO tew_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wíyá tháwä́n in sundaḏo kwä̖́ä̖jêe kꞌéwéḏíˀindiḏa̖ˀ Paul óehon, heḏi in wéˀgen sundaḏo inbíˀwepiye dívíweehoˀ. ");
INSERT INTO tew_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Oe Caesarea búˀ in Paul-ˀin dipówá ihayḏi iˀ tunjó in taˀnin ônˀan heḏi Paul iwebo óejoeˀan. ");
INSERT INTO tew_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","In taˀnin iˀ tunjó itunkanbowa ihayḏi Paul óetsikaˀyan, “Wéˀi nangewi-an unmuu?” “Oe Cilicia-wi-ân” gin Paul-di óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Iˀ tunjó nä́ˀin natꞌoeḏi Paul óetu̖ˀan, “Owáy in toˀwên wôntꞌeˀpꞌíḏéndeˀin dipówá ihayḏânho naaḏi wîntunjóˀnamí.” Ihayḏá in á̖yí̖ˀnin ovâyjôn Paul híwó óeˀá̖yîngiˀa̖míˀin iˀ tewhá hayˀi Herod ikꞌûˀ iwe. ");
INSERT INTO tew_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pꞌánú thaa naphaḏe ihayḏi, Ananias iˀ owhaˀ pꞌóˀḏéḏîˀ namuuˀi-á heḏá wên Huḏíyo tsonnindá dipówá. Wí sen Tertullus gin nakhá̖wä̖́ˀiˀ hânho nahíˀhá̖ˀi namuuˀiˀ indáḏí dâykán, heḏi iˀ tunjóvíˀpiye dimää iˀ tunjó óetu̖ˀâ̖a̖míḏí háa Paul iˀannin. ");
INSERT INTO tew_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Paul óetsꞌúḏe, heḏi Tertullus-di iˀ tunjó óehéeˀan Paul ôntꞌeˀpꞌêeḏe-íḏí. Ginnân natú̖: “Nanbí tunjó Felix, u̖ˀ báyékí wíˀaˀgindiˀ, báyékí gikú̖ˀdaapóe tꞌä̖hkí naˀingîˀ wéngé tꞌä̖hkí biˀandi namuuḏi. U̖ˀ unmuuḏânkunho hä́npíḏíbo báyékí pa̖a̖yo githaa, heḏá uví hangintandi báyékí híwóhpîˀ nanbí nan diweḏi dînjâaˀan. ");
INSERT INTO tew_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nää naa wóˀdaˀpí hânho wíjâapꞌíḏeˀa̖míˀin, heḏiho unsehkanätꞌóeḏí wí hây tä̖hkíwän dîntꞌôeyaaní, han unchanpóeḏí. ");
INSERT INTO tew_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ginnân hîn napóe: Naˀindi nä́ˀi sen ovâytꞌowatꞌeˀyaˀdoḏi âymûˀ. Nä́ˀin Huḏíyo wéngé tꞌä̖hkí ovâypitsa̖a̖kandoˀ, heḏá i-á pꞌóˀḏéḏîˀ namuu in toˀwên iˀ Nazareth-wi senbí há̖hkan deepiye dívíwä̖yundeˀingîˀ. ");
INSERT INTO tew_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Nanbí méesate hayˀi wänbo iˀaˀginhá̖nú, heḏânkun âypankêˀ. Gidaˀwän âytunjóˀnamíˀin âynuuwä̖́-íḏí háa taˀgendi nanbí khuu iˀaˀginnanpíḏí háa joe. Hebo Lysias iˀ sundaḏoví tsondi pꞌóˀḏéḏîˀ napówá, heḏi kayˀindi nanbí man diweḏi óejâaˀan, heḏáháˀ ovâyjôn in toˀwên ôntꞌeˀpꞌíḏeˀin uví páaḏépiye diˀä̖ä̖-íḏí. U̖ˀḏi wíˀbo híwó nä́ˀi sen nâatsikaˀyandáho úhanginpúuwí tꞌä̖hkí nä́ˀi iví̖ˀgeḏi wítꞌeˀpꞌíḏéndeˀi taˀgen namuuˀin” gin ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tꞌä̖hkí nä́ˀi Tertullus Paul-ví̖ˀgeḏi natû̖ˀdiˀ in Huḏíyo hanbá ditú̖, heḏá ditú̖ iˀ tꞌehpiḏe tun Tertullus ihíˀmáaˀi taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Iˀ tunjó imannan Paul óehíˀmä̂äníḏí, heḏiho ginnân Paul-di óetu̖ˀan: “Naa dînhanginná báyékí pa̖a̖yo nä́ˀin tꞌowagíˀin tunjówháagé unˀä́nnin, heḏânho báyékí ohíhchan dáyhéeˀa̖míḏí wíˀbo dáyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Maḏi tä̖ˀḏi wíje (12) thaa phaḏe ihayḏi naa Jerusalem-piye omää Jôesi Táḏá dóˀaˀginmä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Tꞌôepíḏíbo úhanginpúuwí nä́ˀi taˀgendi namuuˀin. Naa toˀwí-áḏí wíḏáytu̖hä́nbopí, heḏá wíḏovâytꞌowatꞌeˀyaˀnanpí iˀ Huḏíyo méesate hayˀiˀ iwe, háa inbí méesate hí̖ˀíndi eeje wänbo joe, heḏiháa iˀ búˀ i̖ˀge wänbo joe. ");
INSERT INTO tew_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Indá wíḏínkeekankoḏipí nä́ˀi naví̖ˀgeḏi dîntꞌeˀpꞌíḏéndeˀi taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Hebo nä́ˀinnân naa otú̖u̖ní: In pꞌóegé iwe naa dáyˀa̖htuyendeˀindá nä́ˀin tꞌowa ditû̖ˀ piˀwên pꞌóegé namuuˀin, hewänbo i̖ˀge dáyˀa̖htuyendeḏi Jôesi Táḏágîˀ dáytꞌôemáa, i-á nanbí thehtáy pahpáˀindi óeˀaˀginmäˀ. Tꞌä̖hkí nä́ˀi khuu Moses itaˀnandiˀ heḏá in Jôesi Táḏáví tukheˀmin dâytaˀnandi-á naa dáywä̖yundeˀ. ");
INSERT INTO tew_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Háa nä́ˀin tꞌowa dívíwä̖yundeˀin napuwagíˀoˀinbá naa wáˀ dáywä̖yundeˀ, heḏi ginnân namuu: Jôesi Táḏáḏí tꞌä̖hkí in dichuuˀin ovâywówápakhâymáa, híwóˀnindá híwóhpíˀindá. ");
INSERT INTO tew_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Heḏi gin dáywä̖yundeḏi, hä̖̂ä̖ḏi wänbo tꞌä̖hkí dáykhä̖ä̖ḏe Jôesi Táḏáví páaḏépiye heḏá tꞌowaví páaḏépiyá híwó dáytsiyeˀa̖míḏí, heḏânho naví píˀnä́ khóˀjé dînhanginnáaníḏí híwó dáykanhonnin. ");
INSERT INTO tew_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Báyékí pa̖a̖yo Jerusalem búˀ iwe wóˀä́npíwän, heḏáháˀ dáywáybun wí chä̖ˀ in naví tꞌowa dikä̖ä̖kwꞌóˀnin dovâymä̂äníḏí, heḏá wí naví hä̖ä̖wí dînmúuníˀi-á Jôesi Táḏá-á dómä̂äníḏá. ");
INSERT INTO tew_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Iˀ méesate hayˀi ee gin dáyˀoˀ ihayḏi in tꞌowaḏi naa dímûˀ. Naa dáykhâyˀanhoˀ Jôesi Táḏá dóˀaˀginmä̂äníḏí, nanbí khuu gínmuu waabá. Báyékí tꞌowa iwe wíḏijihpí, heḏi tꞌä̖hkí hânda̖ˀ naná. ");
INSERT INTO tew_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Wên Asia-win Huḏíyo wáˀ iwe dijiˀ. Indáho dínkhâyˀä̖ˀ wóetu̖ˀâ̖a̖míˀin háawin wên tꞌaywóˀnin naa dáyˀannin, naví̖ˀgeḏi wóetꞌeˀpꞌêeḏe-íˀin didaˀḏi. ");
INSERT INTO tew_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Hewänbo nää nä́we wíḏijihpíḏí, tobá nä́ˀin dijiˀindân wóetu̖ˀâ̖a̖mí háawin tꞌaywóˀnin dáyˀannin dínhanginpóeˀin in Huḏíyoví tunjówháagépiye díkán dihayḏi. ");
INSERT INTO tew_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nä́ˀin wéhpêeḏa̖ˀmân dáyˀan iwe owin dihayḏi: Dáytu̖wí̖núḏí dovâytu̖ˀan, ‘Naa dítsondiwekán gá in dichuuˀin diwáywówápúuwíˀin dáywä̖yundeḏân’ ” gin Paul-di óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felix Jesus-ví pꞌôe i̖ˀgeḏi híwó ûnhanginná, heḏiho in iwe dijiˀin ovâytu̖ˀan, “Nää-á wíyá wíˀívíhéeˀa̖mípí. Owáy Lysias iˀ sundaḏoví tsondi pꞌóˀḏéḏîˀ napówá ihayḏânho naaḏi wâytu̖ˀâ̖a̖mí háa unbí híˀ i̖ˀgeḏi oˀándeˀin.” ");
INSERT INTO tew_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Heḏiho wí sundaḏoví tsondi gin óetu̖ˀan, “Nä́ˀi sen náˀá̖yîngiˀan, hewänbo napannä́n waagiḏá joe. Iví kꞌemaˀin iˀ ovâypu̖wä̖mä̂äní, iˀ hä̖ä̖wí ûntáyˀiˀ ônkáaníḏí.” ");
INSERT INTO tew_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Wí hä̖́yú̖ thaa naphaḏe ihayḏi Felix nawáyˀä̖ä̖ iví kwee Drusilla wóegé, i-á Huḏíyo kwee-ân namuu. Paul óetsꞌúḏeḏi däntꞌôeyansóge, heḏi Paul-di ovä̂nthaykꞌûˀ háḏíḏí toˀwí Christ Jesus-víˀpiye iwä̖ä̖yú̖-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Iˀḏi ovä̂nhíˀmáa háḏíḏí inbí wówátsi taˀge dä̂nhûuwí i̖ˀgeḏi, heḏá háa dawänpidaˀ waa dä̂nkanhûuwíˀin wíḏä́nkhâyˀä̖hpí i̖ˀgeḏá, heḏá iˀ thaa Jôesiḏi tꞌowa ovâykeekwꞌôení háa híwó háa híwóhpí dívíˀan niˀgeḏá. Han ihíˀmáaḏí Felix nakhunwôedaˀpóeḏí óetu̖ˀan, “Nä́weḏi ópeeve wíyá wítu̖hkánnan píhay, hä̖̂ä̖ḏi naa dînpóe ihayḏi.” ");
INSERT INTO tew_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Hebo Felix natsíkha Paul-di óechä̖ˀmä̂äníḏí, heḏânho óewáˀâaḏá óemaˀpꞌä̖̂ä̖ḏi-í, heḏiho ihayḏa̖ˀ óetu̖hkándoˀ i-áḏí ihéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Wíje pa̖a̖yo daphaḏe ihayḏi Felix óetunjójâaˀan heḏi Porcius Festus natunjósogeḏee. Felix-di Paul oe pan diwebo óejoeˀan, in Huḏíyo-áḏí nakꞌemamúuníˀin nadaˀḏi. ");
INSERT INTO tew_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus iˀ tunjó tsꞌa̖a̖bi namuuˀiˀ oe Caesarea búˀ napówá, heḏi poje thaa naphaḏe ihayḏá iweḏá oe Jerusalem búˀpiyá namää. ");
INSERT INTO tew_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Oe Jerusalem napówá ihayḏi in owhaˀ pꞌóˀḏéḏíˀindáḏí heḏá in wéˀgen Huḏíyo senäˀ heˀennindáḏí Paul wíyá ôntꞌeˀpꞌíḏe, heḏi kayˀindi Festus didaˀpóe wên hä̖ä̖wên ovâyˀa̖míḏí. Didaˀ Paul oe Jerusalem-piye óemáˀíˀin, gá dínwéhpêemuuḏân dívíkhakwꞌôeníˀin óeháyjíḏí waˀ pꞌóegé namändiboˀ. ");
INSERT INTO tew_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","5","Felix-di ovâytu̖ˀan, “Paul-á oe Caesarea napannä́n. Naa wí hä̖́yú̖ thaa iwe oepiye owáymän. Heḏáho wên unbí senäˀ heˀennin bîntu̖ˀâ̖a̖mí naa-áḏí dimú-í, heḏi wên híwóhpíˀin Paul iˀandáhoˀ, indi óetunjóˀdiwekáaní.” ");
INSERT INTO tew_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus maḏi wíyá kháve háa tä̖ thaa iwebo iwóyí̖ˀ, heḏáháˀ Caesarea-piye nawáymää. Wíyá tháwä́n ovâytsonnamíḏí isóge, heḏi in sundaḏo ovâytu̖ˀan Paul dikenmú-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paul óekán, heḏi natsꞌú̖ˀ dihayḏi in Huḏíyo oe Jerusalem-di diˀä̖ä̖ˀin iví núˀ iwéngé diwindi ôntꞌeˀpꞌíḏéndeḏi ditû̖ˀ báyékí kâyˀi hä̖ä̖wí híwóhpîˀ iˀandi, hewänbo wíḏínkoḏipí taˀgendi dâythayya̖míḏí nä́ˀi ditû̖ˀdi taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paul wíˀbo iˀaywoeníḏí ihéeˀandi gin natú̖: “Naaḏi in Huḏíyoví khuu wíḏovâyˀaˀginhá̖núpí, heḏá nä́ˀi Huḏíyoví méesate hayˀi ee aˀginkha̖nugîˀ wóˀtsꞌú̖hpí, heḏá wên háawin tꞌaywóˀnin wänbo in Rome-ˀinbí tsondi Caesar-víˀpiye wíḏáyˀanpí.” ");
INSERT INTO tew_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Hebo Festus in Huḏíyo ovâyhíwóˀnamíˀin nadaˀ, heḏiho Paul óetsikaˀyan, “Ti oe Jerusalem-piye unpundaˀ iwe naví páaḏépiye wîntsonnamíḏí nä́ˀi wôntꞌeˀpꞌíḏéndeˀ i̖ˀgeḏi?” ");
INSERT INTO tew_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul-di óetu̖ˀan, “Joe, nä́webânkun dîntsonnamíˀin odaˀ. Nä́ä uví páaḏépiye owindi iˀ tsondi Caesar-ví páaḏépiye owin dîntsonnamíḏí waagibá namuu. Heḏá wáˀ u̖-á wíˀbo híwó úhanginná wên háawên tꞌaywóˀnin wänbo in Huḏíyovíˀpiye wíḏáyˀanpíˀin. ");
INSERT INTO tew_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Wáy wên háawên tꞌaywóˀnin dáyˀandáhoˀ, heḏi nä́ˀin tꞌaywóˀnin namuuḏi ochuu-íˀin dînkhâyˀä̖ḏáhoˀ, háˀto otú̖u̖ní wíḏíháyjípíˀin. Hebo nää hä̖ä̖wí nä́ˀin tꞌowaḏi dîntꞌeˀpꞌíḏéndeˀi taˀgen namuupíḏá, toˀwí wänbo wíˀûnkꞌóepí inbí mangepiye díkáaníˀin. Heḏiho oe Rome diwe Caesar-ví tunjówháagé iwe dîntunjóˀnamíˀin odaˀ” gin Paul-di óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus-di in óetumakhemáaˀin ovâyhéeˀan, ihayḏáháˀ Paul-víˀpiyá ibéeḏí óetu̖ˀan, “Caesar-ví tunjówháagé iwe wôntunjóˀnamíˀin undaˀḏiho ivíˀpiye wísaaní.” ");
INSERT INTO tew_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Hä̖́yú̖ thaa naphaḏe ihayḏi iˀ tsondi Agrippa iví kwee Bernice-áḏí oe Caesarea dapówá Festus óesengitu̖ˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Wí hä̖́yú̖ thaa daˀä́n dihayḏi Festus-di Paul-ví̖ˀgeḏi Agrippa óetꞌôeˀan. Ginnân óetu̖ˀan: “Nä́ä pan diwe wí sen naˀä́n Felix iˀ tunjó phaḏeˀiˀḏi óejoeˀandiˀ. ");
INSERT INTO tew_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Naa oe Jerusalem ojiˀ ihayḏi in Huḏíyo owhaˀ pꞌóˀḏéḏíˀindi heḏá in tsonnindá hä̖ˀiví̖ˀgeḏi dítꞌeˀpꞌíḏe, heḏi in didaˀ otú̖u̖níˀin hä̖ˀi tꞌehpiḏe tun taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Hewänbo dovâytu̖ˀan, ‘In Rome-windi hä̂nhay wänbo wí toˀwí wíˀóekándepí in toˀwên ôntꞌeˀpꞌíḏéndeˀinbí mange. Páaḏé nakhâyˀä̖ˀ in toˀwên ôntꞌeˀpꞌíḏéndeˀinbí páaḏépiye iwé̖e̖nú-íˀin, heḏân wíˀbo iˀaywoeníḏí ihéeˀa̖mí nä́ˀi hä̖ä̖wí ôntꞌeˀpꞌíḏéndeˀ i̖ˀgeḏi.’ ");
INSERT INTO tew_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Heḏiho nä́we diwéˀgepóe ihayḏi wíḏáytsíkhaˀanpí. Wíyá tháwä́nho dovâytsonnamíḏí dáysóge, heḏi in sundaḏo dovâytu̖ˀan iˀ sen óetsꞌûuḏe-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Iví̖ˀgeḏi dítꞌeˀpꞌêeḏe-íḏí dívíwí̖nú ihayḏi, naa oˀân wên háawin kâyˀin iˀannin dítu̖hkankhâymáaˀin, hebo han wíḏívíˀanpí. ");
INSERT INTO tew_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nä́ˀi sen Paul gin nakhá̖wä̖́ˀi-áḏí dívíwänpitu̖hkandoˀ inbí wä̖yu̖ dínmuu i̖ˀgeḏi heḏá wí sen Jesus gin nakhá̖wä̖́ˀiví̖ˀgeḏá, i-á nachuu wänbo Paul natú̖ nawówájiˀ gin. ");
INSERT INTO tew_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Naa wíḏînhanginnáhpí háḏíḏí dóshaa-íˀin nä́ˀi hä̖ä̖wí háawin namuuˀin, heḏiho dótsikaˀyan, ‘Ti oe Jerusalem-piye unpundaˀ, iwe nä́ˀi hä̖ä̖wí wôntꞌeˀpꞌíḏéndeˀ i̖ˀgeḏi wîntunjóˀnamíḏí?’ ");
INSERT INTO tew_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Hebo Paul nadaˀpóe nää pan diwebo nachaníˀin heḏá iweḏá Caesar-ví tunjówháagépiye namú-í Caesar-di ôntunjóˀnamíḏí. Heḏiho in sundaḏo dovâytu̖ˀan óeˀá̖yí̖ˀnamíˀin Caesar-víˀpiye dósan píhay” gin Festus-di Agrippa óetu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Heḏi Agrippa natú̖, “Naa wáˀ nä́ˀi sen háa natû̖ˀnin otꞌoe-íˀin odaˀ.” Festus-di óetu̖ˀan, “Thaˀdibo untꞌoe-í-áhay.” ");
INSERT INTO tew_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wíyá tháwä́n Agrippa-áḏí Bernice-áḏí nä́ˀi íve hayˀi datsꞌú̖, wên sundaḏo tsonnin heˀennin wóegé heḏá wây-á búˀwin tsonnin wóegá. Saˀwó daˀaamuu, heḏá hä̖ä̖wí tꞌä̖hkí hânho saˀwó nakeetꞌóe. Festus natsonpóe Paul óetsꞌûuḏe-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Heḏi Festus-di ovâytu̖ˀan, “Tsondi Agrippa heḏá un tꞌowa nä́we íjiˀin tꞌä̖hkí, binmúˀḏí nä́ˀi sen. Iví̖ˀgeḏi tꞌä̖hkí in Huḏíyoḏi oe Jerusalem-windáḏí heḏá nä́we dijiˀindáḏí naa díhéeˀan. Dívítu̖wí̖núndeḏi naa dítu̖ˀan nä́ˀi sen óeháyjíˀin ûnkhâyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Naaḏi wên háawin wänbo wíḏônshaapí óeháyjíḏí. Hebo i-á wíˀbo nadaˀpóe Caesar-di ôntunjóˀnamíˀin, heḏiho naa dáyˀánshaamä́gi Caesar-víˀpiye dósaaníˀin. ");
INSERT INTO tew_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Hebo hä̖ä̖wí wänbo wíḏînhanginnáhpí nä́ˀi senbí̖ˀgeḏi naví tsondi pꞌóˀḏéḏîˀ Caesar dôntaˀnamíˀin. Heḏânho un tꞌä̖hkíví páaḏépiye dómaa bînhéeˀa̖míḏí, heḏi shánkíḏí uví páaḏépiye, naví tsondi Agrippa. Heḏi bîntsikabowa ihayḏi shánkí dînhanginpúuwí hä̖ä̖wí i̖ˀgeḏi Caesar dôntaˀnamíˀin. ");
INSERT INTO tew_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Han dáyˀan, gá dînchanpóeḏân bondoeˀi namúuníˀin wí pan dósaaníḏí páaḏé wídovâythayyanpíḏí hä̖ä̖ i̖ˀgeḏi ôntꞌeˀpꞌíḏéndeˀin.” ");
INSERT INTO tew_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa-ḏi Paul óetu̖ˀan, “Naaḏi wînkꞌúyaˀ uví̖ˀgeḏi bipihéeˀa̖míḏí.” Heḏi Paul imannandi ihéeˀan wíˀbo iˀaywoeníḏí. Gin natú̖: ");
INSERT INTO tew_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Tsondi Agrippa, nää naaḏi wítu̖hkankhâymáa naví̖ˀgeḏi heḏá nä́ˀi hä̖ä̖wí nä́ˀin Huḏíyoḏi naa dîntꞌeˀpꞌíḏéndeˀ i̖ˀgeḏá, heḏi naa ohíhchan u̖-ân iˀ unmuuˀin uví páaḏépiye owindi. ");
INSERT INTO tew_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Heḏi shánkíḏí ohíhchan u̖-á taˀgendi nä́ˀi Huḏíyoví khuu dínmuu i̖ˀgeḏi úhanginnândi, heḏá úhanginná wáygéhä̖̂ä̖ handa̖ˀ wíḏívíˀánshaaˀopíˀin. Heḏiho pín taˀgeḏi wídaˀmáa dîntꞌôeyaaníˀin. ");
INSERT INTO tew_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Tꞌä̖hkí in Huḏíyo dínhanginná háa naví wówátsi donphaḏeˀin oˀeˀnújiˀ ihayḏi waagiboˀ, wíˀgín oe naví nangá heḏá oe Jerusalem búˀ iwá. ");
INSERT INTO tew_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Heḏi in didaˀḏáho wóetu̖ˀâ̖a̖mí nä́ˀin: Báyékí pa̖a̖yo dínhanginná naa páaḏéḏíbo Pharisee omuuˀin, heḏi nä́ˀin Pharisee tꞌowa-á nanbí khuu shánkí kayˀin dâyhújaˀ nä́ˀin wéˀgen Huḏíyo tꞌowavíˀweḏi. ");
INSERT INTO tew_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nää naa dítunjóˀdiwekán gá dáywä̖yundeḏân Jôesi Táḏá iˀa̖míˀin iví tun nanbí thehtáy pahpáˀin ovâymä́giˀin. ");
INSERT INTO tew_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Tꞌä̖hkí in tä̖ˀḏi wíje Israel-ví eˀnûnbí ây iweḏiˀin wáˀ nä́ˀin in Jôesi Táḏá natú̖ˀin ikhâymáaˀinbá dívíwä̖yundeˀ, heḏiho khu̖u̖-á thaa-á iˀ óeˀaˀginmäˀ. Heḏi nää, naví tsondi unmuuˀiˀ, naa wáˀ hanbá dáywä̖yundeḏiboˀ in Huḏíyoḏi naa dîntꞌeˀpꞌíḏéndeˀ. ");
INSERT INTO tew_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Heháaḏan un Huḏíyo wíˀúnkoḏipí úvíwä̖ä̖yú̖-íḏí Jôesi Táḏáḏí in dichuuˀin ovâywáywówápaˀin? ");
INSERT INTO tew_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Naa-ân oˀânwän báyékí dînjänäkíkanpoeˀoˀin nä́ˀi Jesus oe Nazareth-wi gin nakhá̖wä̖́ˀivíˀpiye. ");
INSERT INTO tew_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Heḏiho oe Jerusalem han dáyˀan. In owhaˀ pꞌóˀḏéḏíˀindi naa dînkꞌûˀ báyékí tꞌowa Jesus-víˀin ûnmuuˀin dovâypankwꞌôeníˀin, heḏá ovâytꞌakha̖nukhâymáa ihayḏi naví tun wáˀ eepiyebá dáymä́gi. ");
INSERT INTO tew_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Hä̖́yä́nbo naa omää in Huḏíyoví méesate eejepiye otsonpúuwíḏí ovâywhä̖́hwhä̖́ˀnamíḏí, heḏá dáykhä̖ä̖ dovâykaygiˀa̖míḏí ditú̖u̖níḏí Jesus-víˀpiye wíḏívíwä̖yundepíˀin. Naa hânho inbíˀpiye otꞌayyaapóeḏí Huḏíyo namuupîˀwi búˀ i̖ˀge dáykhenjíyénde dovâyhóeníḏí.” ");
INSERT INTO tew_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Heḏiho han dáyˀa̖míḏí naa oe Damascus búˀpiye omänwän. In owhaˀ pꞌóˀḏéḏíˀindi wên taˀnin ho dînˀan dóhûuwíḏí dînkꞌúuwíḏí in Jesus-víˀpiye dívíwä̖yundeˀin dovâypanhóeníḏí. ");
INSERT INTO tew_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Naví tsondi unmuuˀiˀ, taageḏi oe pꞌóegé omän dihayḏi wí ko oe makówáḏí nawândi dómûˀ, iˀ thanbí shánkí nakohkayˀi namuu, heḏi nä́ˀi koḏi naˀin gimännin tꞌä̖hkí díˀánhógi. ");
INSERT INTO tew_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tꞌä̖hkíḏíbo nange gikanu. Ihayḏi wí toˀwíḏí Hebrew tundi díhéeˀandi otꞌoe. Dítu̖ˀan, ‘Saul, Saul, háaḏan naa dítꞌôephaḏekandoˀ? U̖ wíˀbo biwänpiwa̖ˀoˀ, wí búdu in phékꞌeˀindi óesanhonnin iˀa̖ˀtsꞌáḏíndeḏi ipiwa̖ˀoˀ waagibá.’ ");
INSERT INTO tew_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Naa otsikapóe, ‘Nanbí Sedó, to-an unmuu?’ Iˀḏi dítu̖ˀan, ‘Jesus-ân omuu, u̖ˀḏi dítꞌôephaḏekandoˀiˀ. ");
INSERT INTO tew_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nää ówí̖nú. Naa uvíˀpiye dáykeeyan gá wídeˀmandân naví tꞌôe dînˀa̖míḏí, heḏi u̖ˀḏi tꞌowa ovâytꞌôekankhâymáa nää thaa dímûˀin, hewänbo nä́ˀiḏa̖ˀbá joe, owáy wíyá uvíˀpiye dáykeeyandi hä̖ä̖wí wítu̖hkangíˀoˀi wáˀ ovâytꞌôekankhâymáa. ");
INSERT INTO tew_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Naaḏi wísankhâymáa wíˀgín in Huḏíyo dimuuˀinbíˀpiye heḏá in Huḏíyo dimuupíˀinbíˀpiyá, heḏi inbíˀweḏi naaḏi wînˀaywoení. ");
INSERT INTO tew_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Dínkhunná waagibá dikwꞌó, hewänbo u̖ˀḏi ovâykhä̖ge̖ˀkhâymáa dínkeepúuwíḏí heḏá Jôesi Táḏáví ko i̖ˀge dívíhûuwíḏí. Heḏá Satan iˀ Penísendiví mangeḏi ovâyjâaˀandi Jôesi Táḏáví mange ovâykwohkhâymáa. Heḏiho navíˀpiye dívíwä̖yundeḏi inbí tꞌaywóˀdi ovâyˀowóejé-í, heḏá in wéˀgen navíˀpiye dívíwä̖yundeḏi navíˀin dînmuuˀindáḏí dívíwóení’ gin Jesus-di dítu̖ˀan.” ");
INSERT INTO tew_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Heḏiho tsondi Agrippa, háa Jesus-di dítu̖ˀan waa makówáḏí dînkeepóeḏí díhéeˀandi naa dáyˀaˀginnan. ");
INSERT INTO tew_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Páaḏé in Damascus búˀwin dovâyhéeˀan, iweḏá in Jerusalem-indá, heḏá oe Judea nange i̖ˀgeˀin tꞌä̖hká, heḏá in Huḏíyo dimuupíˀin wänbo-á. Dovâytu̖ˀan inbí tꞌaywóˀdi dâyjoeˀandi Jôesi Táḏávíˀpiye dívíhâ̖a̖ḏi-í, heḏá híwó dívítsiyeˀa̖mí dâykeeya̖míḏí taˀgendi inbí tꞌaywóˀdi dâyjoeˀannin. ");
INSERT INTO tew_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Gin dáyˀoḏiho wên Huḏíyoḏi iˀ méesate hayˀi khóˀjé díyâ̖ˀ heḏi díháyjíˀin dívíkhä̖ä̖ḏeˀ. ");
INSERT INTO tew_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Hewänbo Jôesi Táḏáḏí hä̖̂ä̖ḏi wänbo tꞌä̖hkí naa díkhä̖geˀdoˀ, heḏiho nää nä́we owindi in taˀgen namuuˀin tꞌä̖hkí tꞌowa dovâytu̖máa, tobáháa heˀennin dimuu háa heˀennin dimuupí wänboˀ. Hä̖ä̖wí tꞌä̖hkí nä́ˀin tꞌowa dovâytu̖máaˀi-á, Moses-áḏí in Jôesi Táḏáví tukheˀmindáḏí ditú̖ˀin napuwagíˀoˀinbá namuu, heḏi wíyá hä̖ä̖wí wänbo wóˀtû̖ˀpí. ");
INSERT INTO tew_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Indá ditú̖ iˀ toˀwí Jôesi Táḏáḏí óesógeˀiˀ tꞌowa ovâyˀaywoeníḏí itꞌôephaḏekhâymáaˀin nachuu píhay, heḏi i-á iˀ páaḏéˀi namúuní chuwa iweḏi nawáywówápúuwíḏí, heḏânho iˀḏi wíˀgín Huḏíyo-á Huḏíyo dimuupíˀindá Jôesi Táḏáví pꞌóegé ovâykeekankhâymáa.” ");
INSERT INTO tew_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Waˀḏi Paul nä́ˀi hä̖ä̖wí ithaykwꞌóeˀó ihayḏi Festus tsíkhagipí itu̖wí̖nú, “Paul, u̖-á bondoeˀi-ân unmuu. Báyékí bihá̖ˀan, heḏânkun unbondoepuwamän.” ");
INSERT INTO tew_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Hebo Paul-di óetu̖ˀan, “Aˀgindi Festus, naa bondoeˀi wóˀmuupí. Naa híwó donhangintanmáaḏí in taˀgen namuuˀinda̖ˀ dáyhíˀmáa. ");
INSERT INTO tew_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Iˀ tsondi Agrippa nä́we naˀä́ndiˀ ûnhanginná nä́ˀi hä̖ä̖wí tꞌä̖hkí i̖ˀgeḏi. Heḏânkun iví páaḏépiye dáyhíˀmáaḏí hä̖ä̖wí wänbo wíḏókaayohpí. Naa híwó dînhanginná tꞌä̖hkí nä́ˀi hä̖ä̖wí napóe i̖ˀgeḏi Agrippa-á natꞌoeˀin, gá kaaḏi wínapóepíḏân. ");
INSERT INTO tew_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Tsondi Agrippa, ti biwä̖yundeˀ háa in Jôesi Táḏáví tukheˀmin ditú̖ˀin? Dînhanginnân biwä̖yundeˀin” gin Paul natú̖. ");
INSERT INTO tew_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa-di Paul óetu̖ˀan, “Ti unˀân gáhân u̖ˀḏi wesebo wí Christian dípaˀíˀin?” ");
INSERT INTO tew_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul-di óetu̖ˀan, “Háḏéebá wesebo háa wíyá shánkí díhûuwí. Hebo naa Jôesi Táḏávíˀpiye dáyjûusuˀoˀ u̖-áḏí heḏá tꞌä̖hkí nä́ˀin nää thaa ditꞌôeyankwꞌóˀnindáḏí naa waagibá ípúuwíˀin. Hewänbo naa wóˀdaˀpí kaḏénaḏi íwhimúuníˀin, naa owhimuu waagibá.” ");
INSERT INTO tew_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","31","Paul ihíˀbowa ihayḏi iˀ tsondi Agrippa heḏá iˀ tunjó Festus-á, Bernice-á, heḏá in wéˀgen iwe dikwꞌóˀnindá dívíwí̖nú, heḏi oe jáˀwépiye dipeeḏi dívíhéeˀan. Ditú̖, “Nä́ˀi sendá háawin wên wänbo wíˀiˀanpí óeháyjíḏí háa napanchaníḏí wänboˀ.” ");
INSERT INTO tew_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Heḏi Agrippa-ḏi Festus óetu̖ˀan, “Nä́ˀi sen dómaˀpꞌä̖̂ä̖ḏi-íˀin dînkoḏiwän, hewänbo nää wíḏînkoḏipí, gá Caesar-di ôntunjóˀnamíˀin nadaˀpóeḏân.” ");
INSERT INTO tew_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Heḏiho in tsonnin diˀánshaapóe naˀin kophé iweḏi oe Italy-piye dísaaníḏí, heḏiho Paul heḏá wây-á pandáḏí ovâyjoeˀan wí tä̖gintä̖ (100) sundaḏo ovâytsonmáaˀiví mange. Nä́ˀi sendá Julius gin nakhá̖wä̖́, heḏi in sundaḏo iˀ Rome-wi tsondi pꞌóˀḏéḏîˀvíˀin gin ovâykhá̖yä̖́ˀdeˀin diweḏiˀi-ân namuu. ");
INSERT INTO tew_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Wí sen Aristarchus gin nakhá̖wä̖́ˀi wáˀ naˀindáḏí najiˀ, i-á Macedonia nangewi búˀ Thessalonica iweḏiˀi namuu. Heḏi wí kophé Adramyttium búˀ iweḏiˀiˀ ívítógi. Nä́ˀi kophé-á nakhâymuu iˀ búˀây eeje oe Asia nange pꞌo kíngé i̖ˀgepiye namú-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wíyá tháwä́n oe Sidon búˀ iwe ívíwóyí̖ˀ. Julius-di Paul híwó óeˀandi iví kꞌemaˀin óepu̖wä̖mä́gi, indi hä̖ä̖wí ûntáyˀiˀ óemä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Iweḏá iˀ kophé iweḏi gimää, hewänbo iˀ wa̖a̖ḏi tíˀûupiye díchä̖nuhújaˀ, heḏiho oe Cyprus pꞌojâaḏi shánkí nawa̖a̖kaypí i̖ˀgeḏi gimää. ");
INSERT INTO tew_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Oe pꞌoˀ pꞌä̖́näpiye giphaḏe, heḏi Cilicia nange heḏá Pamphylia nangá pꞌo kíngé i̖ˀge gimää, heḏáháˀ oe Lycia nange wí búˀ Myra gin dâytu̖ˀoˀ iwe gipówá. ");
INSERT INTO tew_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Iwe iˀ sundaḏoví tsondi wíyá piˀwí kophé Alexandria-wi namuuˀiˀ ishaa. Nä́ˀi kophé-á Italy-piye namän, heḏiho dítu̖ˀan iwe ívítôeníˀin. ");
INSERT INTO tew_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Iˀ wa̖a̖ hânho nakayḏi jóngíḏa̖ˀ wí hä̖́yú̖ thaa gipundee, heḏá báyéká ívítꞌôeˀandi Cnidus búˀ tsowa gipówá. Iˀ wa̖a̖ kayˀi namuuḏi ee gimän diwepiye wíyá wígínpu̖hkoḏipí, heḏiho Crete kꞌáygé i̖ˀgeḏi giphaḏe, Salmone gin dâytu̖ˀoˀ iwe, heḏá nawa̖a̖kaypíˀwe i̖ˀgeḏá gimän. ");
INSERT INTO tew_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Jóngíḏa̖ˀ pꞌo kíngé i̖ˀge gipundee, heḏi wí búˀ Lasea gin dâytu̖ˀoˀi tsowa gipówá. Nä́we nanáˀ diwá dâytu̖ˀoˀ “Híwó naná iˀ kophé dívíwóyí̖ˀnígîˀ” gin. ");
INSERT INTO tew_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Iwebá híwó hay thaa gikwꞌó. Ihayḏi nateˀnúpuwamändi híwó wínamuupí wíyá shánkí gimú-íḏí, heḏânho Paul-di ginnân ovâytumakheˀan: ");
INSERT INTO tew_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Kꞌemaˀin, naa ochanpoeˀo wíyá shánkí nä́weḏi gimääḏá âytꞌôephaḏekhâymáa. Nä́ˀi kophé-á hé wóegébo gipeḏée-í, heḏá wây wên wáˀ dívípꞌotꞌahá̖a̖nú-í.” ");
INSERT INTO tew_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Hebo iˀ sundaḏoví tsondi Paul-ví híˀ ôntꞌôeyaanívíˀweḏi iˀ sen iˀ kophé ivîˀ ûnmuuˀi heḏá iˀ sen isanhondi-á inbí híˀ-á shánkí ovä̂ntꞌôeyan. ");
INSERT INTO tew_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nä́ˀi kophé nawhiˀä́n diwe wä̖hphaḏe híwóˀ diwe wínanáhpí dâyteˀnúphaaḏé-íḏí, heḏiho tꞌä̖hkí waa dívíˀánshaamä́gi iˀ kophé iweḏi wíyá búˀay Phoenix gin dâytu̖ˀoˀiˀ oe Crete nangebá nanáˀ diwepiye dimú-íḏí, iwe dâyteˀnúphaaḏé-íḏí. Oe Phoenix dâykophéwhikwꞌóeˀó, heḏi aakonpiye thanpiye jâaḏi heḏá pꞌinpiye thanpiye jâaḏá óewa̖a̖ˀahkhándeˀ. ");
INSERT INTO tew_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Heḏiho aakonpha̖ˀgeḏi hí̖yä̖̂ä̖ iwa̖a̖ˀan dihayḏi diˀân háa ditú̖ waagi dívíˀa̖míˀin, heḏiho iweḏi gimääḏi nä́ˀi Crete pꞌojâaḏi tsowa pꞌo kíngé i̖ˀgeḏi gimän. ");
INSERT INTO tew_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Hebo hây napóe ihayḏi wí wa̖a̖ hânho kayˀi nä́ˀi Crete nange i̖ˀge iwa̖a̖ˀan, iˀ wa̖a̖-á pꞌinpiye thanpiye jâaḏiˀi wa̖a̖ gin dâytu̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Iˀ wa̖a̖ hânho nakayḏi iˀ kophé óenándí wíyá páaḏépiye wíˀûnpu̖hkoḏipí, heḏiho iˀ kophé dâybée, heḏi wáy iˀ wa̖a̖ḏi díhon diwepiyeḏa̖ˀ gimää. ");
INSERT INTO tew_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wí pꞌojâaḏiˀay Cauda gin dâytu̖ˀoˀi tsowa giphaḏe, iˀ wa̖a̖ wä̖hphaḏe wínakaypí iwe, heḏi báyékí ívítꞌôeˀan iˀ kophéˀay âywhimáaˀi nä́ˀi kophé gáhä̖́yú̖ˀiˀ iwe kwꞌáye âytaygé-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Iˀ kophéˀay dâywhisóge ihayḏá iˀ kophé gáhä̖́yú̖ˀi whihkannin kayˀindi dâywhibuugiˀan wínathaˀḏee-ípíḏí. Heḏá iˀ teˀaa iˀ wa̖a̖ḏi iˀ kophé óechä̖nundeˀi-á dâywá̖ve, gá dikhunwôedaˀḏân oe Syrtis gin dâytu̖ˀoˀ iwe dikhä̖hkwoḏee-íˀin, iˀ pꞌoe iwe wä̖hphaḏe wínawä̖ˀänpíḏí. Heḏiho iweḏi díwänpipꞌomáa. ");
INSERT INTO tew_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Wíyá tháwä́n wáˀ iˀ wa̖a̖ hânho nakay, heḏiho in kophéˀin senäˀ wí hé iˀ kophé iwe nakuˀundi pꞌoe iwepiye dâychä̖nu, iˀ kophé wä̖hphaḏe wínakháa-ípíḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Heḏá wíyá tháwä́ndá inbo iˀ kophéˀi hä̖ä̖wí wáˀ pꞌoe iwe dâychä̖nu. ");
INSERT INTO tew_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Báyékí thaa agóyó wänbo than wänbo wíˀâymûˀpí, heḏi iˀ wa̖a̖ nahánpíḏí kayˀi iwa̖a̖ˀoˀ. Heḏiho giˀân háˀto wówáˀin gipee-íˀin. ");
INSERT INTO tew_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Báyékí thaa wíˀívíhú̖u̖yanpí. Heḏi Paul inbí páaḏépiye nawindi ovâytu̖ˀan, “Kꞌemaˀin, shánkí híwó namúuníwän naví tun dîntꞌôeyaaníḏí Crete diweḏi wígipee-ípíˀin otú̖ waa. Hây úvítꞌôeyandáho háˀto nä́ˀi kây iwe gipóewíwän heḏá iˀ hä̖ä̖wí háˀto gipeḏée-íwän. ");
INSERT INTO tew_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Hebo nää wíˀúvíˀá̖yîngimä̂änípí. Tobáháa nä́ˀi kophé nathaˀḏee wänbo háˀto toˀwí wänbo óepꞌoháyjí. ");
INSERT INTO tew_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Naa Jôesi Táḏávîˀ omuu, heḏá iví tꞌôe-á dônˀoˀ, heḏi khu̖ˀḏi wêe iví makówáwi tꞌôepa̖ˀa̖a̖ˀi dînpówá, ");
INSERT INTO tew_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","i-á naví núˀ nawindi ginnân dítu̖ˀan: ‘Paul, wíˀunkhunwôedaˀípí. U̖ˀ taˀgendi Caesar-ví páaḏépiye bikwi̖nugíˀo, heḏi u̖ˀ unmuuḏi nä́ˀin u̖-áḏí dijiˀin háˀto wêe wänbo nachuu-í.’ ");
INSERT INTO tew_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Heḏânho kꞌemaˀin, wíˀíkhunwôedaˀípí. Naa dáywä̖yunde nä́ˀin Jôesi Táḏá natú̖ˀinbo napuwagíˀoˀin. ");
INSERT INTO tew_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Hewänbo wí pꞌojâaḏi eeḏi gikhä̖hkwoḏee-í.” ");
INSERT INTO tew_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Wíje jâaḏi daphaḏe, heḏi waˀḏi iˀ wa̖a̖ḏi iˀ mâapꞌoe Adriatic gin dâytu̖ˀoˀ i̖ˀge díchä̖nuhon. Khun pinuḏi hä̖̂ä̖ḏi nanáˀ dihayḏi in kophéˀin senäˀ ditú̖ nan tsowa núˀ gipowamännin. ");
INSERT INTO tew_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Dâywä̖ˀäntaayan, heḏi wétä̖ˀḏi jónu (24) kwiˀóhpa taa nawä̖ˀän gin dâyshaa. Wíyá shánkí hây dimääḏá wíyá dâywä̖ˀäntaayan dihayḏá tä̖ˀḏi kháve (18) kwiˀóhpa taa-á nawä̖ˀän. ");
INSERT INTO tew_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Dikhunwôedaˀ iˀ kophé kꞌuu eeḏi óechä̖nukhâymáaˀin, heḏiho iˀ kophé tíˀûupha̖ˀgeḏi jónu kháaˀi kwä̖́kꞌu maayä̖́ä̖ˀi dâywaje whihkannin eeje, heḏá diwówáyê̖e̖níḏí nathay píhay dívíjûusuˀan. ");
INSERT INTO tew_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nä́ˀin kophéˀin tꞌôeˀin iˀ kophé iweḏi diwha̖vedaˀ dijáaníḏí, heḏiho iˀ kophéˀay pꞌoe iwe dâywá̖ve. Heḏáháˀ iˀ kophé gáhä̖́yú̖ˀi páaḏépiyeḏi wíyá maayä̖́ä̖ˀi dâywajekhâymáa waagibá dívíˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Hebo Paul-di in sundaḏo heḏá inbí tsondi-á ovâytu̖ˀan, “Nä́ˀin kophéˀin tꞌôeˀin nä́ˀi kophé iwe dívíwóyí̖ˀpíḏá, undá háˀto wówáˀin ípee-í.” ");
INSERT INTO tew_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Heḏiho in sundaḏo i kophéˀay nawhiˀä́ndiví whihkannin dâytsꞌâˀ, heḏi i kophéˀay namaˀpꞌä̖́. ");
INSERT INTO tew_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nathaypuwamän dihayḏi Paul-di ovâytu̖ˀan dívíhú̖u̖ya̖mí gin. Ovâytu̖ˀan, “Wíje jâaḏi tꞌä̖hkí hânho úvíˀánshaamáaḏí húukanpíˀinbo íjiˀ. ");
INSERT INTO tew_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Heḏiho nää naaḏi kayˀindi wâytu̖máa, háawin wên híwóhpíˀin wänbo wíˀúnpuwagíˀopí, heḏânho bíhú̖u̖yan, wí koegîˀ úntáy íchuu-ípíḏí.” ");
INSERT INTO tew_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ihíˀbowa ihayḏi wí pává ikêˀḏi Jôesi Táa ikú̖ˀdaaˀan, heḏi wí iháveḏi ikꞌoe. ");
INSERT INTO tew_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Indi gin iˀannin óemûˀḏi shánkí híwó dichanpóeḏí in wáˀ dívíhú̖u̖yan. ");
INSERT INTO tew_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wégín tä̖gintä̖ḏáháˀ tségíntä̖ˀḏi sí (276) tꞌowa iˀ kophé iwe gitoˀon. ");
INSERT INTO tew_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Tꞌä̖hkí dívíshu̖ˀan dihayḏi, iˀ táhtân pꞌoe iwe dâychä̖nu, iˀ kophé ihay wínakhaa-ípíḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nathanpee ihayḏi, in kophéˀin tꞌôeˀin iˀ nan dâymûˀiˀ wíḏâytaapí. Hewänbo naˀokhânná heḏá napꞌoehángínáˀ diwe dâymûˀ, heḏiho dívíˀánshaamä́gi dínkoḏiḏáho iˀ kophé dâypu̖hkannamíḏí iwepiye, heḏânho iˀ okhân deeḏi dâywóyí̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Iˀ kwä̖́kꞌu maayä̖́ä̖ˀi nawhiˀwaˀjendiví whihkannin dâytsꞌâˀ, heḏi iˀ pꞌoe iwebo dâyjoeˀan. Heḏi ihayḏibá iˀ kophé óebéeḏeˀi phépháˀ nawhimuuˀi whihkannin dâywhihsuu. Heḏáháˀ in páaḏépiyeˀin teˀaa dâytege, iˀ wa̖a̖ḏi iˀ kophé ee naˀokhânnáˀ diwepiye óechä̖nutsꞌûuḏe-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Hebo wíˀnä́pha̖ˀgeḏi napꞌohkayjiˀ iwe naˀokhânbóeḏíˀä́n, heḏi iwe iˀ kophé páaḏépiye ichä̖nuḏi nakhä̖hsogeḏeeḏi wínajâapóepí. Ihayḏá iˀ kophé tíˀûupiyeˀiˀ iˀ pꞌoe oepiyá nä́äpiyá kaygindi naˀa̖ˀyä̖poeˀoḏi óewhéekanhon. ");
INSERT INTO tew_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","In sundaḏo dívíˀánshaamáa in pan ovâyhá̖a̖nú-íḏí, heḏânho nan diwepiye wíḏívíkohsáy-ípíḏí dijáaníḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Hewänbo Paul-ví wówátsi ônˀaywoeníˀin iˀ sundaḏoví tsondi nadaˀḏi toˀwí wänbo wíˀovâykheˀmä́gipí. In toˀwên dikohsayhá̖ˀin ovâyjôn pꞌoe iwe dívíjaymú-í nan diwepiye dívíkohsáy-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ihayḏáháˀ in wéˀgendá ovâytu̖ˀan iˀ phépháˀ háa iˀ kophéwi phéhwhée óepꞌomáaˀiˀḏi dívítsa̖hsaa-íˀin. Handiḏânho tꞌä̖hkíḏíbo nan diwe wówáˀin gipówá. ");
INSERT INTO tew_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tꞌä̖hkíḏíbo nan deeḏi wówáˀin gipówá ihayḏi, nä́ˀi pꞌojâaḏi Malta gin dâytu̖ˀoˀin gínhanginpóe. ");
INSERT INTO tew_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","In tꞌowa iweˀindi híwó dísígíˀan. Ikwa̖ˀdoḏi natꞌêe, heḏiho dâyphaˀtꞌégi, heḏi dítu̖ˀan iˀ phaa núˀpiye ívíhâ̖a̖ḏi-íḏí ívísúwáˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul iphéˀâywéˀgeˀan iphaˀkwꞌôeníḏí, heḏi iphaˀkwꞌóeˀó ihayḏi wí pä̖́ä̖yu̖ phaaḏi óesúwánándi phé jâaḏi napee, heḏi Paul-ví man deeḏi ikhuugeewhiˀkꞌûˀ. ");
INSERT INTO tew_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","In tꞌowa iˀ nangeˀindi iˀ pä̖́ä̖yu̖ Paul-ví man deeḏi nawhiˀkꞌóeˀin óemûˀ, heḏi dívítu̖ˀan, “Nä́ˀi sendá maḏi taˀgendi tꞌowa tꞌakha̖nuˀiˀ namuu, heḏi tobá óepꞌohaypí wänboˀ, nanbí jôesi ‘Ovâytꞌowatuhchä̖nundeˀiˀ’ gin gínkhá̖wä̖́ˀiˀḏi háˀto óewówápeemä̂äní.” ");
INSERT INTO tew_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Hewänbo Paul iví man iwáḏâaˀandi iˀ pä̖́ä̖yu̖ iˀ phaa iwe nakeˀtꞌá̖, heḏi háabo Paul wíˀûnpóepí. ");
INSERT INTO tew_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","In tꞌowa diˀándeˀ iˀ pä̖́ä̖yu̖ḏi óekhuugee ee ûntee-íˀin, háa maḏi wesebo nachuhkaanú-í. Hewänbo thaa tꞌä̖hkí dívítsíkhaˀandi Paul háabo wíˀûnpóepí, heḏiho inbí ánshaa dâyˀegóˀandi dívítu̖ˀan, “Taˀgendi nä́ˀi sendá Jôesi waagiˀbá namuu.” ");
INSERT INTO tew_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Iˀ sen nä́ˀi pꞌojâaḏi ee natsonnä́ndiˀ Publius gin nakhá̖wä̖́. Ívísúwáˀoˀ iwe tsowa ûnnavakwꞌó, heḏi sígíḏí naˀin díhógiḏi iví tewhá ûnnáˀ diwe poje thaa díwóyí̖ˀmä́gi heḏá híwóˀdá díˀá̖yîngiˀan. ");
INSERT INTO tew_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publius-ví táḏá whohte eeḏi ûnhaykꞌóe. Natsá̖wä̖pꞌíḏeˀ heḏá nasihayḏi óeˀä̖ä̖ḏeˀ. Ee nahaykꞌóe eepiye Paul natsꞌú̖, heḏi iví mandi óetä̖geḏi ônjûusuˀandi hehkháa óemä́gi. ");
INSERT INTO tew_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nä́ˀin napóe ihayḏi báyékí in wéˀgen nangewin dihayˀin Paul-víˀpiye diˀä̖ä̖, heḏi in wáˀ hehkháa ovâymä́gi. ");
INSERT INTO tew_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Indi báyékí díhä̖ä̖wímä́gi naˀin, heḏi poje pꞌóe naphaḏe ihayḏi iweḏi gimän dihayḏi iˀ gíntáyˀiˀ tꞌä̖hkí dímä́gi. ");
INSERT INTO tew_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Wí kophé Alexandria-wi namuuˀiˀ iˀ pꞌojâaḏi iwebá iteˀnúphaḏeˀiˀ iwe ívítógi. Iˀ kophé-á Castor-áḏí Pollux-áḏí gin dâytu̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","13","Oe Syracuse búˀ gipówá, heḏi poje thaa iwe ívíwóyí̖ˀ. Iweḏi pꞌo kíngé i̖ˀgeḏa̖ˀ gimää, heḏi Rhegium búˀ iwe gipówá. Wíyá tháwä́n aakonpha̖ˀgeḏi iwa̖a̖ˀan, heḏiho wíyá tháwä́ndá Puteoli búˀ gipówá. ");
INSERT INTO tew_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","15","Iwe wên Jesus-víˀpiye dívíwä̖yundeˀin âyshaa, heḏi indi kayˀindi dítu̖ˀan indáḏí wêe jâaḏi ívíwóyí̖ˀníˀin. Iweḏi wíyá gimändi oe Rome-piye wây-á tíˀûuwin páaḏéˀin Rome-win dimuuˀin nanbí̖ˀgeḏi dínhanginpóe, heḏiho gínˀayjayˀä̖ä̖. Dâyhä̖ä̖wíku̖ˀkwꞌóeˀó iwe Appius gin dâytu̖ˀoˀ iwehay wáy wên diˀä̖ä̖, wây-á wêndá wä̖hphaḏe kayi̖ˀ wíḏiˀä̖hpíḏí oe “Poje Kaykhanwówá Tewhá” gin dâytu̖ˀoˀ iwe díjay. Paul-di ovâymûˀ ihayḏi Jôesi Táḏá óekú̖ˀdaaˀan, heḏá iví píˀnä́ khóˀjé-á shánkí nakaypóe. Han âyphaḏe, ihayḏáháˀ wí hä̖́yú̖ thaa iwe oe Rome gipówá. ");
INSERT INTO tew_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Oe Rome gipówá ihayḏi Paul wíˀbo óethayemä́gi, hewänbo wí sundaḏoḏi óeˀá̖yîngimáa. ");
INSERT INTO tew_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Poje thaa naphaḏe ihayḏi Paul-di in Huḏíyo pꞌóˀḏéḏíˀin oe Rome dithaaˀin ivíˀwe ovâywéˀgetu̖ˀan. Dipówá ihayḏi ovâytu̖ˀan, “Tíˀûuwin páaḏéˀin, tobá nanbí thehtáy pahpáˀinbí khuu aˀginkha̖nu naa wíḏáyˀanpí wänboˀ, heḏá nanbí tꞌowavíˀpiye wên yä̖ˀḏâapíˀin wänbo wíḏáyˀanpí, in Jerusalem-win pꞌóˀḏéḏíˀindi dípankêˀ, heḏi nä́ˀin Rome-winbí mange díkán. ");
INSERT INTO tew_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","In Rome-windi háawin tꞌaywóˀnin naa dáyˀannin dînnuwä̖, hewänbo indá dínhanginpóe háawin díháyjíˀin wänbo wíḏáyˀanpíḏí, heḏiho dímaˀpꞌä̖̂ä̖ḏi-íˀin didaˀwän. ");
INSERT INTO tew_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Hewänbo in Huḏíyo wíḏidaˀpí in Rome-windi dímaˀpꞌä̖̂ä̖ḏi-íˀin, heḏiho shánkí híwó dînpóe otú̖u̖níḏí Caesar-ví tunjówháagé iwe dîntunjóˀnamíˀin. Naa gin dáyˀan tobá wên tꞌehpiḏe tun wíḏómáapí wänbo naví tꞌowa in Hudíyo dimuuˀin dovâytꞌeˀpꞌêeḏe-íḏí. ");
INSERT INTO tew_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Heḏânkun naaḏi wâytu̖hkánnan nä́ˀi hä̖ä̖wí i̖ˀgeḏi wâyhéeˀa̖míḏí. Iˀ toˀwí in Israel-win tꞌowaḏi óetsíkhaˀmáaˀivíˀpiyebá naa dáywä̖yundeḏânho nä́ˀi kaḏénaḏi owhimuu.” ");
INSERT INTO tew_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Indi Paul óetu̖ˀan, “Naˀin wên taˀnin wänbo uví̖ˀgeḏi natû̖ˀnin oe Judea-ḏi wíˀâykêˀpí, háa wí Huḏíyo tíˀûu páaḏéˀi oweḏi naˀä̖ä̖ˀi wänbo wên híwóhpíˀin natꞌoeˀin uví̖ˀgeḏi wínatú̖hpí. ");
INSERT INTO tew_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Hebo naˀin gínhanginná toˀwên tꞌä̖hkí híwóhpí dívíhíˀmáaˀin nä́ˀin tsꞌa̖a̖min há̖hkan niˀgeḏi. Heḏânho gidaˀ u̖ˀḏi dítu̖ˀâ̖a̖míˀin háawi uví wä̖yu̖ úmuuˀin.” ");
INSERT INTO tew_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Heḏiho in Huḏíyo wí thaa dâydeˀman wíyá diˀä̖ä̖-ígîˀ, heḏi iˀ thaa napówá ihayḏi báyékí diˀä̖ä̖. Héḏéndí héˀḏibo iweḏi nakin diwehay báyékí hä̖ä̖wí Paul-di ovâyhéeˀan. Háa Jôesi Táḏáḏí tꞌä̖hkí tꞌowa ovâysígíhóeníˀin nadaˀ waa ovâythayyan, heḏi Moses-ví tun niˀgeḏi heḏá Jôesi Táḏáví tukheˀminbí tun niˀgeḏá ovâytꞌôeˀandi ikhä̖ä̖ḏe Jesus-víˀpiye ovâywä̖yu̖kannamíḏí. ");
INSERT INTO tew_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Paul-ví híˀ dâysígíˀandi dívíwä̖yu̖ wáy wên, wáy wêndá joe. ");
INSERT INTO tew_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Heḏi in Huḏíyo handa̖ˀ wíḏínˀánshaamuupíḏí iweḏi dívíjâaˀan, hewänbo waˀ dipeepíḏíbo Paul-di nä́ˀi tꞌä̖ˀge híˀ ovâytu̖ˀan: “Iˀ Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi hä́nˀoe Isaiah óetu̖ˀan unbí thehtáy pahpáˀinbíˀpiye namú-íḏí nä́ˀi Jôesi Táḏáví híˀ ovâytu̖ˀâ̖a̖míḏí: ");
INSERT INTO tew_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ihayḏa̖ˀ ítꞌóˀve-í, hewänbo háˀto íkaˀpóewí, ihayḏa̖ˀ bînmúˀbe-í, hewänbo háˀto únkeepúuwí. ");
INSERT INTO tew_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ípꞌóhkâymuuḏi wíˀíkaˀpóyaˀpí. Úvíˀojemankwꞌóḏiḏáháˀ úvítsíkhä̖mu. Gin úvíˀanpíḏá unbí tséeḏí bînmúuní heḏá unbí ojeḏá ítꞌoe-í heḏá taˀgendi íkaˀpóewí, heḏá navíˀpiye íˀä̖ä̖-í yä̖ˀḏâaˀin wâypaˀíḏí, gin Jôesi Táḏá natú̖. Nä́ˀi híˀ natú̖ˀi-á taˀgen namuu. ");
INSERT INTO tew_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Heḏânho nää nä́ˀin únkhâyˀä̖ˀ únhanginnáaníˀin: Jôesi Táḏáví híˀ in Huḏíyo dimuupíˀin ovâysan ovâyˀaywoeníḏí. Innânkun dívítꞌôeyaaní.” ");
INSERT INTO tew_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paul ihíˀbowa ihayḏi in Huḏíyo dívítu̖hä́nboḏi dipee. ");
INSERT INTO tew_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paul wíje pa̖a̖yo iwe naˀä́n, heḏi iwáˀâa iˀ tewhá ee nachaníḏí. Toˀwên ûnpu̖wä̖pówáˀin tꞌä̖hkí ovâysígíhógi. ");
INSERT INTO tew_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Iˀḏi Jôesi Táḏáví khuu i̖ˀgeḏi ovâytꞌôeˀan, heḏá Jesus Christ iˀ shánkí natsonjiˀiví̖ˀgeḏá ovâyhá̖ˀan. Khunwôedaˀginpíḏíbo ihéeˀan, heḏi toˀwíḏí wänbo wíˀóekhâ̖a̖ˀanpí.");
INSERT INTO tew_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Naa Paul omuuˀiˀ, Jesus Christ-gîˀ dáytꞌôeˀoˀiḏi nä́ˀin ta̖ˀnin wâysandeˀ un Rome búuˀú iwe íthaaˀin. Yôesi Táḏáḏí naa díde̖ˀman heḏá dísaanígîˀ dísóge iví híwó̖ˀdi tu̖u̖ tꞌowa dovâytꞌôeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Hä́nˀoebo Yôesi natú̖ nä́ˀi híwó̖ˀdi tu̖u̖ naˀin dímä̂äníˀin, heḏi iví tukhe̖ˀmin iví ta̖ˀnin diwe i dâyta̖ˀnan. ");
INSERT INTO tew_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Iví ay Jesus Christ naˀinbí tsondi hayˀi gínmuuˀiví̖ˀgeḏi dâyta̖ˀnan. Naˀaypu̖yä̖ ihayḏi natꞌowasenpaa, heḏi iví thehtáy pahpâa David i hä́nˀoeˀi tsondi namuuˀiví tíˀúugé kä̖ˀä̖ä̖ˀinbíˀweḏiho naˀaypu̖yä̖. Heḏi Jesus nachuuḏi nawáywówápóe ihayḏi i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi dînkeeyan taˀgendi Yôesi Táḏáví ay wáˀ ûnmuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Háa Jesus iˀan waa namuuḏi Yôesi Táḏá navíˀpiyeˀ híwó̖ˀdi namuu, heḏiho in Huḏíyo dimuupíˀin tꞌowa wéngé tꞌä̖hkí dithaaˀinbíˀpiyeho naa dísan dovâykhä̖ge̖ˀnamíḏí iví tu̖u̖ ipiyeˀ dívíwhä̖yú̖-íḏí heḏá ônˀaˀginnamíḏá. Kin dáyˀoˀ heḏânho tꞌowaḏi óetegé-íḏí. ");
INSERT INTO tew_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Heḏá un wáˀ Yôesi Táḏáḏí wovâytu̖kánnan Jesus Christ-víˀin ímúníḏí. ");
INSERT INTO tew_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Heḏiho un tꞌä̖hkí oe Rome íkwꞌó̖ˀnin wâysengitu̖máa. Yôesi Táḏáḏí wovâyséegí heḏá wovâyde̖ˀman iví tꞌowa ímúníḏí. Iḏá heḏá Naˀinbí Sedó Jesus Christ-diḏá séegísehkanä wovâymä̂äní heḏá wovâykhä̖ge̖ˀnamí ánshaaginpíḏíboˀ íkwo̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Heḏi nää-á hä̖̂ä̖ḏi Jesus Christ dóhéeˀan ginhay-á Yôesi naví Táḏá dókú̖ˀdaaˀoˀ un tꞌä̖hkí ímuuḏi, gá wéngé tꞌä̖hkí tꞌowa dívíhíˀmáaḏân unbí whä̖yu̖ i̖ˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","10","Yôesi Táḏá-áho ûnhanginná nä́ˀi naa otû̖ˀdi taˀgen namuuˀin. Igîˀ pín taˀge hayḏi dáytꞌôemáa tꞌowa dovâytu̖ˀoḏi i híwó̖ˀdi tu̖u̖ iví ay Jesus-ví̖ˀgeḏi, heḏi hä̖̂ä̖ḏi wänbo tꞌä̖hkí wâyyûusuˀoˀ. Yôesi dódaˀmáa i-á natú̖ḏáho hanwaapíḏíbo unbíˀpiyeˀ dípunmä̂äní, ");
INSERT INTO tew_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","gá hânho oˀáḏâapundaˀḏân. Naa odaˀ hä̖ä̖wí i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi naa díhá̖ˀandiˀ wâyphaḏé-íˀin, heḏânho unbí whä̖yu̖ shánkího únkay-íḏí. ");
INSERT INTO tew_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Kinnân otu̖ˀdaˀ: Undáḏí naa-áḏí wé̖ˀge ívíkhä̖ge̖ˀnamí kwee waa sen waa giˀâ̖a̖níḏí, handa̖ˀ ívíwhä̖yundeḏi. ");
INSERT INTO tew_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Tíˀûuwin páaḏéˀin, odaˀ únhanginnáníˀin hä̖́yä́n wänbo dáyˀánshaamáa omú-íḏí unbíˀpiyeˀ, hewänbo hä̖̂ä̖ḏi waa hä̖ä̖wíḏí díˀahkhándeˀ. Hânho odaˀ báyékíḏí unbí búuˀúwin Jesus-víˀpiyeˀ dovâywhä̖yu̖ˀa̖míˀin, in wé̖ˀgeˀin Huḏíyo dimuupíˀin tꞌowa dovâywhä̖yu̖ˀan waagibá. ");
INSERT INTO tew_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","15","Naa tꞌä̖hkí tꞌowa hä̖ä̖wí ophaamuu waagibá ocha̖a̖, tobá háawin dimúní wänboˀ, in Greek tu̖u̖ḏi dívíhéeˀoˀindá in piˀwí tu̖u̖ḏi dívíhéeˀoˀindá, in hânho dihá̖ˀindá in dihá̖hpíˀindá, gá Yôesiḏi naa dísógeḏân iví híwó̖ˀdi tu̖u̖ tꞌä̖hkí tꞌowa dovâytꞌôeˀa̖míḏí. Heḏânho shánkí odaˀ un oe Rome diwe íkwꞌó̖ˀnin wáˀ wâytꞌôeꞌa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Yôesi Táḏáví híwó̖ˀdi tu̖u̖ḏi naa wíḏíwôedaˀmähpí. Nä́ˀi tu̖u̖-ân nakay, heḏi i̖ˀgeḏi Yôesiḏi tꞌä̖hkí tꞌowa in ipiyeˀ dívíwhä̖yundeˀin ovâyˀaywondeˀ, páaḏé in Huḏíyo dimuuˀindá, heḏá in Huḏíyo dimuupíˀindá wáˀ. ");
INSERT INTO tew_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Nä́ˀi híwó̖ˀdi tu̖u̖ḏi díhá̖ˀandi gínhanginná háa Yôesi Táḏáḏí tꞌowa ovâycha̖a̖máaˀin tꞌaywó̖ˀdi dâymáapí waagi. Hewänbo inbí whä̖yu̖ dínmuuˀiḏiḏa̖ˀ kin iˀoˀ, hä̖ä̖wí híwó̖ˀdi dívíˀoˀi namuuḏá yoe, iví ta̖ˀnin diwe ûnta̖ˀmuu waagi: Wí toˀwí Yôesivíˀpiyeˀ taˀgendi iwhä̖yundeḏáhoˀ, iví whä̖yu̖ ûnmuuḏibo Yôesiḏi óecha̖a̖máa tꞌaywó̖ˀdi imáapí waagi, heḏi wówátsi óemä̂äní. ");
INSERT INTO tew_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Yôesi Táḏá oe makówá naˀä́ndiḏi dînkeeyoˀ ovâytuchä̖nukhâymáaˀin in toˀwên óeˀaˀginpíˀindá heḏá in yä̖ˀḏâapîˀ dívíˀoˀindá, háa dívíˀoˀin namuuḏi natꞌayḏi. Heḏi híwó̖ˀpí dívíˀoḏibo Yôesiví taˀgen ûnmuuˀin ônkaayo heḏânho wé̖ˀgeˀin tꞌowa wíḏâytáa-ípíḏí. ");
INSERT INTO tew_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Dínkoeḏi híwó̖ˀ dínhanginnáníḏí Yôesiví̖ˀgeḏi, gá iḏi ovâyhanginˀânnandân. ");
INSERT INTO tew_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Yôesi Táḏá pínnán kay imáa hä̂nhay wänbo nahándepíˀin, heḏi iḏa̖ˀ Yôesi namuu hä̂nhay nanân wänboˀ. Tobá tséeḏí Yôesi âymúndepí wänboˀ, nä́ˀi nan oepáa ikhíyé ihayḏi waaboˀ thayˀeeḏi nä́ˀi hä̖ä̖wí gínhanginná iví̖ˀgeḏi i hä̖ä̖wí ipaaˀiḏi. Heḏânkun tꞌowa wíḏínkoeḏipí ditú̖níḏí wíḏínhanginnáhpíˀin. ");
INSERT INTO tew_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Hewänbo tobá Yôesiví̖ˀgeḏi tꞌowa dínhanginnân wänboˀ, óeˀaˀginnamívíˀweḏi heḏiháa óekú̖ˀdaaˀa̖mívíˀweḏi dínkhâyˀä̖ˀ waagi, inbí ánshaa wíḏínchä̖ˀmuupí heḏá inbí hangintandá dâymáapíḏí khu̖u̖ i̖ˀgebo diyiˀ. ");
INSERT INTO tew_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Báyékí dihá̖ kin diˀándeˀ, hewänbo hanginta̖hpíˀinda̖ˀ dimuu. ");
INSERT INTO tew_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Tobá Yôesi-á tꞌä̖hkíví kwꞌáye namuu wänboˀ, heḏá iví wówátsi-á hä̂nhay wänbo wíˀûnhándepí, nä́ˀin tꞌowaḏáho wíyá wíˀóeˀaˀginmähpí; heḏi tobá Yôesi nachuˀpí wänbo heḏá tꞌowa-á ditꞌa̖hánde wänboˀ, báyékí hä̖ä̖wí tꞌowa waabá díncha̖a̖ˀin dâykhíyé inbí yôesi dínmúníḏí, heḏá báyékí wíyá hä̖ä̖wí-á dâypaa, tsíḏé-á pꞌoekanu-á hä̖ä̖pandá pä̖́ä̖yu̖-á waagá díncha̖a̖ˀiˀ, heḏi nä́ˀi hä̖ä̖wí dâypaaˀi wáˀ dâyˀaˀginmäˀ. ");
INSERT INTO tew_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Heḏiho Yôesiḏi ovâyyoeˀoˀ dívíˀa̖míḏí nä́ˀi yä̖ˀḏâapîˀ inbí píˀnä́ khóˀyéḏí dikandaˀiˀ, heḏi wôedaˀginpíḏí yä̖ˀḏâapîˀ hä̖ä̖wí wíˀnä́ táyeḏi inbí túuˀúḏí dívítsiyeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wíyá wíḏívítꞌóyandepí in taˀgen namuuˀin Yôesiví̖ˀgeḏi, heḏi i hôeyó namuuˀiḏa̖ˀ dívíwhä̖yundeˀ. I hä̖ä̖wí Yôesi ikhíyéˀiḏa̖ˀ dâyˀaˀginmäˀ heḏá ipiyeˀ dívíyûusuˀoˀ, Yôesivíˀpiyá yoe, i-á nä́ˀi hä̖ä̖wí ikhíyéˀi namuu. Iḏa̖ˀmân hayˀi namuu kin tꞌowa dínkhâyˀä̖ˀ hä̖̂ä̖ḏi wänbo tꞌä̖hkí ditú̖níˀin. Hamân. ");
INSERT INTO tew_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Heḏi in tꞌowa nä́ˀi yä̖ˀḏâapíkan dívíˀoˀindá Yôesiḏi ovâyyoeˀoˀ i wôedaˀwó̖ˀgí hä̖ä̖wí hânho dikandaˀi wíyá dívíˀâ̖a̖míḏí. In kwiyä̖ˀ wänbo háa inbí wówátsi thaa dínmúní waagi wíḏithaapí, heḏá wây-á kwiyä̖ˀdáḏí inbí túuˀúḏí dívítꞌaywó̖ˀkanmáa. ");
INSERT INTO tew_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Heḏi in senäˀ wáˀ han waagibá dívíkanhon. Inbí kweeyôe-áḏí dívítháye̖ˀbé-ívíˀweḏi dínkhâyˀä̖ˀ waagi, shánkíḏí didaˀ wây-á senäˀdáḏí inbí túuˀúḏí dívítꞌaywó̖ˀkanmáˀve-íˀin. Heḏi nä́ˀin senäˀ wôedaˀwó̖ˀgí wíˀnä́ táyeḏi dívítsiyeˀoḏi i tuchä̖nu dínˀä̖ˀi ovâymäˀ, heḏi inbí tꞌaywó̖ˀdi dínmuuḏi inbí túuˀú dâypeḏeeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Dichanpoˀ wínachä̖ˀmuupíˀin Yôesiví̖ˀgeḏi taˀge dívíˀánshaaˀâ̖a̖míḏí, heḏiho Yôesiḏi ovâyyoeˀoˀ inbí yä̖ˀḏâapîˀ ánshaa-áḏí, i hä̖ä̖wí dínkankhâyˀä̖hpîˀ dívíˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Yä̖ˀḏâapîˀ-áḏí híwó̖ˀpîˀ-áḏíḏa̖ˀ inbí píˀnä́ khóˀyé díntoˀon; hânho diha̖ˀtꞌaa; wây-á toˀwêndáḏá háaˀwänbo-á dimuu; hânho dithúutꞌóe; hä̖̂ä̖ḏi wänbo tꞌä̖hkí ditꞌowatꞌa̖kha̖nudaˀ; hânho dívítꞌaymáa; hä̖̂ä̖ḏi wänbo tꞌä̖hkí dívíhôeyómáa; wây-á tꞌowaví̖ˀgeḏi yanäkí dívíˀánshaamáa heḏá dívíhíˀmáa; ");
INSERT INTO tew_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","tꞌowa dâytu̖u̖súuˀoˀ; Yôesi dâytꞌay; tꞌowa tꞌä̖mägîˀ dâytu̖máa; dívíyêngi; dívípiphuuḏeˀ; wíyá shánkí tꞌaywó̖ˀdi tsꞌa̖a̖bi i̖ˀgeḏi dívíˀánshaamáa dívíˀa̖míḏí; inbí táḏá-á yíyá-á wíḏâytꞌóyandepí; ");
INSERT INTO tew_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","inbí ánshaa-á wíḏínchä̖ˀmuupí; háa dívítu̖u̖ˀan waa wíḏívíˀopí; inbí maatuˀindá wíḏâyséegípí; wây-á toˀwênbíˀpiyeˀ wíḏiˀiyapoˀpí. ");
INSERT INTO tew_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Yôesi natsonpóe in toˀwên haˀwâa dívíˀoˀindá dínkhâyˀä̖ˀ dihá̖a̖níˀin, hewänbo nä́ˀi dínhanginnân wänbo handa̖ˀ dívíkanhon, heḏá hä̖ˀiḏa̖ˀbá yoe, ovâyhí̖ˀan wây-á toˀwên hanbá dívíˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Heḏiho wí toˀwíḏí wây-á tꞌowa ovâytu̖u̖súuˀoḏi natû̖ˀ tꞌaywó̖ˀtoˀin dimuuˀin, i-á háˀto ûnkoeḏí-í natú̖níˀin wíˀbo wíˀitꞌaywó̖ˀnanpíˀin, tobá toˀwí namúní wänboˀ. In wé̖ˀgeˀinbí̖ˀgeḏi kin waagi ihéeˀoḏi, wíˀbo iví tꞌaywó̖ˀdi ipikeekwꞌóeˀó, gá in waagibá itꞌaywó̖ˀdoḏân. ");
INSERT INTO tew_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Heḏi gínhanginná Yôesi híwó̖ˀ iˀoˀin in tꞌowa kin dívíˀoˀin ovâytuchä̖nuḏi, gá i-á ûnhanginnândân taˀgendi háawin dimuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nä́ˀi toˀwíḏí wây-á toˀwên ovâytu̖u̖súuˀoḏi hewänbo in waagibá itꞌaywó̖ˀdoḏi maˀḏi naˀánde Yôesiḏi háˀto óetuchä̖nú-íˀin. ");
INSERT INTO tew_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Heḏá wáˀ tobá Yôesi naˀinbíˀpiyeˀ híwó̖ˀdi namuu wänbo heḏá hânho naboˀatä̖́ wänbo-á, maˀḏi nä́ˀi toˀwí naˀánde hä̖́ä̖bo wínamuupíˀin. Ti wíˀûnhanginnáhpíˀan Yôesi i-áḏí híwó̖ˀdi namuuˀin, gá Yôesi nadaˀḏân nä́ˀi toˀwí iví tꞌaywó̖ˀdi iyoeˀa̖míˀin? ");
INSERT INTO tew_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Hewanbo tꞌóyanpîˀḏa̖ˀ namuuḏi heḏá iví tꞌaywó̖ˀdi iyoeˀanpíḏí, iví tuchä̖nu shánkí pínˀaywó̖ˀnin ûnmúní owáy Yôesiḏi tꞌowa ovâytuchä̖nu ihayḏi, inbí tꞌaywó̖ˀdi dínmuuḏi natꞌayḏi. Ihayḏá Yôesi in tꞌowa ovâytaˀgekeekwꞌôení háa híwó̖ˀ háa híwó̖ˀpí dívíˀannin. ");
INSERT INTO tew_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Wêndá híwó̖ˀ ívíˀoˀ, heḏá wêndá híwó̖ˀpí ívíˀoˀ, heḏi Yôesiḏi naˀin wí̖ˀínbo dímä̂äní hä̖ä̖wí gínˀä̖ˀiˀ. ");
INSERT INTO tew_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Wáy wên tꞌowa-á hä̖̂ä̖ḏi wänbo tꞌä̖hkí híwó̖ˀ dívíkanhon, heḏi didaˀ Yôesiḏi ovâytegé-íˀin heḏá híwó̖ˀ ovâymáˀve-íˀin, heḏá didaˀ hä̂nhay wänbo tꞌä̖hkí diwówáyê̖e̖níˀin. Nä́ˀin tꞌowa-á Yôesiḏi wówátsi nahándepíˀin ovâymä̂äní. ");
INSERT INTO tew_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Wây-á tꞌowa-á dihä̖ä̖khâ̖a̖ḏá ingîˀḏa̖ˀ hä̖ä̖wí tꞌä̖hkí dikandaˀ, heḏi Yôesiví taˀgen ûnmuuˀin wíˀônˀaˀginpí, hewänbo shánkíḏí in yä̖ˀḏâapíˀin namuuˀin dívíkanhon. Ki̖ˀmin tꞌowa-áho Yôesiḏi ovâytuchä̖nukhâymáa, indáḏí natꞌayḏi. ");
INSERT INTO tew_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Toˀwên tꞌä̖hkí dívíyä̖ˀḏâapítsiyeˀannindá wí̖ˀínbo báyékí tꞌôephaḏe dínpúwí, páaḏé in Huḏíyo dimuuˀindá, hewänbo wáˀ in Huḏíyo dimuupíˀindá. ");
INSERT INTO tew_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Hewänbo in tꞌowa híwó̖ˀ dívíˀannindá Yôesiḏi ovâytegé-í heḏá híwó̖ˀ ovâymáˀve-í, heḏá híhchan ánshaa-á ovâymä̂äní, páaḏé in Huḏíyo dimuuˀindá, hewänbo wáˀ in Huḏíyo dimuupíˀindá, ");
INSERT INTO tew_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","gá Yôesiḏá tꞌä̖hkí tꞌowa handa̖ˀ ovâymáaḏân. ");
INSERT INTO tew_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","In Huḏíyo dimuupíˀin wíḏâytaapí i tsontu̖u̖ Moses ita̖ˀnandiˀ, hewänbo dívítꞌaywó̖ˀdoḏiboˀ ovâytuchä̖nú-í tobá i tsontu̖u̖ dâymáapí wänboˀ. Heḏá in Huḏíyo-á nä́ˀi tsontu̖u̖-á dâytaa wänboˀ, dívítꞌaywó̖ˀdoḏibo i tsontu̖u̖ḏá inbí tꞌaywó̖ˀdi dínmuuˀi ovâykeekwꞌôení. ");
INSERT INTO tew_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","In toˀwên Yôesiví tsontu̖u̖ dâyˀaˀginnannindáho Yôesiḏi ovâycha̖a̖máa tꞌaywó̖ˀdi wíḏâymáapí waagi, in toˀwên diwänpitꞌoˀinda̖ˀbá yoe. ");
INSERT INTO tew_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Tobá in Huḏíyo dimuupíˀin Moses-ví tsontu̖u̖ dâymáapí wänboˀ, háa nä́ˀi tsontu̖u̖ natû̖ˀ waagi wíˀbo dívíˀoḏá, kindiḏi nakeepoˀ ho dínhanginnáˀnin háa híwó̖ˀdi namuuˀin heḏá háa híwó̖ˀdi namuupíˀindá, ");
INSERT INTO tew_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","heḏiho háa dívíˀoˀin namuuḏi nakeepoˀ i tsontu̖u̖ Moses ita̖ˀnandibá inbí ánshaa iwebo dâymáaˀin, heḏi inbí píˀnä́ khóˀyé wáˀ ditaachanpoˀ háa híwó̖ˀ dívíˀoˀin háa yoe. ");
INSERT INTO tew_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Heḏiho i thaa napówá-í Yôesi Táḏáḏí tꞌä̖hkí tꞌowa ovâykeekwꞌôeníḏí háa híwó̖ˀ háa híwó̖ˀpí dívíˀannin, tobá kaaḏi dívíˀan wänboˀ. Heḏi Christ Jesus-áho i namuu óesógeˀi kin ovaytu̖ˀa̖míḏí. Kindá ihayḏa̖ˀ tꞌowa dovâytu̖ˀoˀ, Yôesiví híwó̖ˀdi tu̖u̖ dovâytꞌôeˀoḏi. ");
INSERT INTO tew_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Maˀḏi wí toˀwí wíˀbo iví̖ˀgeḏi ihíˀmáaḏí natû̖ˀ wí koḏi̖ˀdi Huḏíyo namuuˀin, heḏi naˀánde Moses-ví tsontu̖u̖ itaaḏiboˀ ônˀaywoeníˀin, heḏi iyêngihéeˀoḏi natû̖ˀ Yôesi óeˀaˀginmäˀin. ");
INSERT INTO tew_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","I-á ûnhanginná háa Yôesi nadaˀin iˀa̖míˀin, heḏá ûnhanginná wáˀ wéˀi wí yä̖ˀḏâaˀi namuuˀin wéˀi wí yä̖ˀḏâapîˀ namuuˀindá gá Yôesiví tsontu̖u̖ iweḏi nahá̖hpóeḏân, ");
INSERT INTO tew_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","heḏiho naˀándeˀ ovâypahûuwíˀin in toˀwên tsíˀtꞌaaˀin waagiˀinbá dimuuˀin, Yôesiví̖ˀgeḏi wíḏínhanginnáhpíḏí, heḏá in toˀwên phahkhu̖u̖ ee dikwꞌó̖ˀningîˀ-á wí kohthay waagibá namuu gin naˀándeˀ. ");
INSERT INTO tew_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Heḏá wáˀ nadaˀ in toˀwên Yôesiví̖ˀgeḏi hä̖́ä̖bo wíḏínhanginnáhpíˀin ovâyhä̖ä̖wíthayya̖míˀin, heḏá in toˀwên áyyä̖̂ä̖ waagiˀinbá dimuuˀin ovâyhá̖ˀa̖mí, gá nä́ˀi tsontu̖u̖ imáaˀin diweḏi ûnhanginnândân tꞌä̖hkí in taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Iḏi piˀwên tꞌowa ovâyhá̖ˀoˀ, heḏi háaḏan i-á wíˀbo wíˀipihá̖ˀopí? Iḏi ovâytumakheˀo wíḏívísä̖ˀmamípíḏí, heḏi háaḏan i isä̖ˀboˀ? ");
INSERT INTO tew_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Wây-á tꞌowa ovâytu̖ˀo wíyá toˀwíví sedó-áḏí háa kwiyó-áḏí wíḏívíwho̖hkwomáˀve-ípí gin, heḏi háaḏan i-á wíˀbo kinbá itꞌaywó̖ˀdoˀ? I natû̖ˀ itꞌayˀin i hä̖ä̖wí tꞌowa dâykhíyéˀiˀ inbí yôesi dínmuu waa dâycha̖a̖ˀiˀ, heḏi háaḏan i-á nä́ˀi hä̖ä̖wíbá isä̖ˀboˀ i tewhá wáyyé nakwꞌó̖ˀ deeye? ");
INSERT INTO tew_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Iphuuḏeḏi natû̖ˀ Yôesiví tsontu̖u̖ itaaˀin, heḏi háaḏan nä́ˀi tsontu̖u̖ iˀaˀgindopíḏí Yôesi wôedaˀ iwe óesógéndeˀ? ");
INSERT INTO tew_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Háa Yôesiví ta̖ˀnin diwe nata̖ˀmuu waa napoˀ, kinnân natû̖ˀdi: Háa un Huḏíyo ímuuˀin úvíˀoˀin namuuḏi nä́ˀin Huḏíyo dimuupíˀin Yôesiví̖ˀgeḏi yanäkí dívíhéeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Wí Huḏíyo Yôesiví tsontu̖u̖ iˀaˀgindoḏáhoˀ, in Huḏíyoví kꞌewe̖ˀ taa imáaˀindá ûnchä̖ˀmuu; hewänbo nä́ˀi tsontu̖u̖ iˀaˀgindopíḏá, tobá nataamuu wänboˀ iví taa wíˀûnchä̖ˀmuupí. ");
INSERT INTO tew_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Heḏi wí Huḏíyo namuupîˀ Yôesiví tsontu̖u̖ iˀaˀgindoḏi tobá in Huḏíyoví kꞌewe̖ˀ taa imáapí wänboˀ, Yôesiḏi óecha̖a̖ nataamuu waagibá. ");
INSERT INTO tew_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Wí toˀwí iví túuˀú ûnkꞌewe̖ˀtaamuupíḏí hewänbo i tsontu̖u̖ iˀaˀgindoḏá un Huḏíyo ímuuˀin wovâykeekwꞌóeˀó híwó̖ˀ wíˀúvíˀopíḏí, gá i tsontu̖u̖ wívînˀaˀgindopíḏân, tobá nä́ˀi tsontu̖u̖-á únta̖ˀmuu wänbo heḏá tobá íkꞌewe̖ˀtaamuu wänboˀ. ");
INSERT INTO tew_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","29","Toˀwí wänbo wí Huḏíyo waa nawänpiˀaypu̖yä̖ḏibo taˀgendi Huḏíyo wínamuupí. Heḏi wí toˀwí in taˀgennin kꞌewe̖ˀ taa wíˀimáapí wên kꞌewe̖ˀ taaḏi iví túuˀú eeḏi óewänpitaaˀandiboˀ. Hewänbo nakhâyˀä̖ˀ wí toˀwí iví píˀnä́ khóˀyé-áho koḏi̖ˀdi Huḏíyo namúníˀin heḏânho taˀgendi ha̖ˀbi namúníḏí, heḏá in taˀgennin kꞌewe̖ˀ taa-á píˀnä́ khóˀyébá imáˀve-íˀindá ûnkhâyˀä̖ˀ. Heḏi kin waagi ûnpoˀ i tsontu̖u̖ iwänpiˀaˀgindoḏiḏa̖ˀbá yoe, hewänbo i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi óetaaˀan waagibá nakhâyˀä̖ˀ. Wí toˀwí ha̖ˀbiví̖ˀgeḏi Yôesi-ân híwó̖ˀ ihéeˀoˀ, tꞌowaḏa̖ˀbá yoe. ");
INSERT INTO tew_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Maˀḏi toˀwí naˀâ̖a̖ní, “Hä̖ä̖-an in Huḏíyo dâymáa in wé̖ˀgeˀin tꞌowa dâymáapîˀ? Heḏi háagíˀinnan nachä̖ˀmuu hä̖ˀin Huḏíyoví kꞌewe̖ˀ taa?” ");
INSERT INTO tew_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Gá báyékígíˀinnân. Páaḏé iweho Yôesiḏi in Huḏíyo iví tsontu̖u̖ ovâymä́gi dâyˀá̖yîngiˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Heḏi tobá wáy wên in háa dínkhâyˀä̖ˀ waagi wíḏívíˀopí wänboˀ, ti Yôesi wáˀ ûnˀóḏe-í iˀa̖míḏí háa itu̖u̖ˀan waagi? ");
INSERT INTO tew_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Yoe, háˀto ûnˀóḏe-í. Gínkhâyˀä̖ˀ gitú̖níˀin Yôesi-á wíˀihôeyóˀopíˀin tobá tꞌä̖hkí tꞌowa dihôeyó wänboˀ. Yôesiví ta̖ˀnin diwe iví̖ˀgeḏi ûntû̖ˀ waa: Ihéeˀandá tꞌowa dínhanginnání taˀge ihíˀmáaˀin. Heḏi tꞌowaḏi ôntꞌeˀpꞌíḏénde wänbo dínhanginpúwí hä̂nhay wänbo híwó̖ˀpí wíˀiˀopíˀin. ");
INSERT INTO tew_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Hewänbo maˀḏi wí toˀwí tꞌowaḏa̖ˀ namuuḏibo kin naˀándeˀ: “Naa dáyhíwó̖ˀpíˀandá, Yôesi-á shánkí híwó̖ˀdá iˀoˀin nakeepoˀ; heḏânkun híwó̖ˀ wínamuupí Yôesiḏi dítuchä̖nú-íˀin.” ");
INSERT INTO tew_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Hewänbo wígínkhâyˀä̖hpí kin waagi ívíhéeˀa̖míˀin. Yôesi wíˀbo híwó̖ˀ iˀopíḏá, hândiḏan i-á ûnkoeḏí-í taˀge natú̖níˀin in tꞌowa dívítꞌaywó̖ˀnannin? ");
INSERT INTO tew_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","8","Heḏi maˀḏi toˀwí kinnân natú̖ní: “Naa dáyhôeyóˀandáhoˀ, iweḏi nakeepoˀ Yôesi-á shánkí hayˀi namuuˀin, gá i-á wínahôeyópíḏân. Heḏiho kin napoˀḏi Yôesi wíˀûnkꞌóepí dítu̖ˀâ̖a̖míḏí tꞌaywó̖ˀtoˀi omuuˀin.” Hewänbo toˀwí kin ihéeˀandiví híˀ ûntu̖ˀdaˀ gínkhâyˀä̖ˀ ívítꞌaywó̖ˀnâamíˀin, heḏânho naˀinbí tꞌaywó̖ˀdi iweḏi hä̖ä̖wí híwó̖ˀdi napúwí. Wên tꞌowa yanäkí naví̖ˀgeḏi dívíhôeyóhíˀmáaḏí ditû̖ˀ kin waagi naa ohá̖hkanyiˀin. Ha̖ˀmin tꞌowa-áho i tuchä̖nu dínˀä̖ˀiˀ dâyhóní-áheˀ. ");
INSERT INTO tew_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Nää otsikapúwí, ti naˀin Huḏíyo shánkí híwó̖ˀnin gimuu in wé̖ˀgeˀin tꞌowavíˀweḏi? Heḏân yoe. Naaḏi ho wâykeekwꞌóḏi tꞌä̖hkíḏíbo tꞌaywó̖ˀtoˀinda̖ˀ gimuuˀin, naˀin Huḏíyo-á heḏá in Huḏíyo dimuupíˀindá. ");
INSERT INTO tew_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Yôesiví ta̖ˀnin diwe kinnân ûnta̖ˀmuu: Toˀwí wänbo iví wówátsi taˀge wíˀihonpí, wîˀ wänbo yoe. ");
INSERT INTO tew_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Toˀwí wänbo wínakaˀpóya̖ˀpí háa in yä̖ˀḏâaˀin namuuˀin, toˀwí wänbo wínadaˀpí Yôesi óetaa-íˀin. ");
INSERT INTO tew_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Tꞌä̖hkíḏíbo Yôesivíˀweḏi dívíhângeˀan, inbí wówátsi-á hä̖́ä̖bo wíḏínchä̖ˀmuupí, wîˀ wänbo wínaˀä́npí híwó̖ˀ iˀoˀiˀ. ");
INSERT INTO tew_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Wí penípho óehuuḏi nasu̖u̖ waagibá inbí híˀ-á tayˀi dínmuu, hôeyóḏa̖ˀ inbí hän diwe dínkwꞌó̖, háa ditû̖ˀ waa whä́npû̖u̖ví sóˀpꞌoe waagiˀbá dínmuu, ");
INSERT INTO tew_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","heḏi inbí sóphogeḏi tꞌaywó̖ˀdi híˀ-á heḏá híˀ nawha̖hkantꞌóeˀi-á báyékího dínpiˀ. ");
INSERT INTO tew_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Hä̖̂ä̖ḏi wänbo tꞌä̖hkí dikhâymuu dâytꞌowatꞌa̖há̖nú-íḏí, ");
INSERT INTO tew_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","wä̖́hä̖̂ä̖ dimää wänbo hä̖ä̖wí dâypeḏeeˀoˀ, heḏá tꞌowa-á ovâyḏaháachandoˀ. ");
INSERT INTO tew_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Háa inbí wówátsi tsa̖a̖ginpíḏíbo dâyhûuwíˀin wíḏínkoeḏihanginnáhpí, ");
INSERT INTO tew_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","heḏi Yôesi-á hây wänbo-á wíḏâyˀaˀginpí. ");
INSERT INTO tew_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Gínhanginná tꞌä̖hkí Yôesiví tsontu̖u̖ natû̖ˀdi-á in toˀwên dâyˀaˀginnamíḏí dívísóˀḏêeˀingíˀin namuuˀin, heḏânho wíḏitú̖nípíḏí wíḏívítꞌaywó̖ˀnanpíˀin, heḏiho tꞌä̖hkí tꞌowa dínhanginnání Yôesivíˀpiyeˀ dívítꞌaywó̖ˀnannin. ");
INSERT INTO tew_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Yôesi háˀto natú̖ní wí toˀwí tꞌaywó̖ˀdi imáapîˀ waagi namuu iví tsontu̖u̖ ônˀaˀginnamíḏí iwänpisóˀḏíndeḏiboˀ, gá nä́ˀi tsontu̖u̖ḏá in tꞌowa ovâykeekwꞌóeˀóḏân dívítꞌaywó̖ˀdoˀin. ");
INSERT INTO tew_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","22","Heḏiho nää-áho nä́ˀin nathaypóe háa tꞌä̖hkí Yôesiví ta̖ˀnin diwe ûntû̖ˀ waa: Yôesiḏi in tꞌowa ovâycha̖a̖máa tꞌaywó̖ˀdi wíḏâymáapí waagibá inbí whä̖yu̖ Jesus Christ-víˀpiyeˀ dínmuuḏi, i tsontu̖u̖ dâyˀaˀginnamíḏí dívísóˀḏíndeḏiḏa̖ˀbá yoe. Nä́ˀi tu̖u̖-á tꞌä̖hkí tꞌowagîˀ namuu, tꞌä̖hkí tꞌowa ha̖ˀminda̖ˀ gimuuḏi, ");
INSERT INTO tew_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","gá tꞌä̖hkíḏíbo ívítꞌaywó̖ˀnandân, heḏiho toˀwí wänbo yä̖ˀḏâaˀiḏa̖ˀ wínamuupí Yôesi tꞌä̖hkí yä̖ˀḏâaˀi namuu waagibá. ");
INSERT INTO tew_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Gíntꞌanmuupí wänbo Christ Jesus iví ûnpꞌoeḏi iwáˀâa naˀinbí tꞌaywó̖ˀdi iweḏi dímaˀpꞌä̖́ḏi-íḏí, heḏi nä́ˀi namuuḏiho Yôesi Táḏáḏí iví séegísehkanä ûnmuuḏi dícha̖a̖máa tꞌaywó̖ˀdi wíˀâymáapí waagibá. ");
INSERT INTO tew_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Hä́nwänbo Yôesi Táḏá iˀánshaamä́gi Jesus óesaaníḏí, iví ûnpꞌoe ichꞌâaníḏí, heḏânho ivíˀpiyeˀ ívíwhä̖yundeḏáho naˀinbí tꞌaywó̖ˀdi dînyâaˀa̖mí. Hä̂nhay waabo tꞌowa dívítꞌaywó̖ˀnan wänbo Yôesi Táḏá naboˀatä̖́ḏí itsíkhaˀandi wesebo wíˀovâytuchä̖nupí dínˀä̖ waagi. I-á wíˀbo tꞌaywó̖ˀdi wíˀimáapí kin iˀan wänboˀ, gá Jesus-dáho in tꞌowaví tꞌaywó̖ˀdi ovâyyâakankhâymáaḏân. Heḏiho nää-á híwó̖ˀda̖ˀ iˀoˀin naˀin dînkeeyoˀ, toˀwên Jesus-víˀpiyeˀ dívíwhä̖yundeˀin ovâycha̖a̖máaḏí tꞌaywó̖ˀdi wíḏâymáapí waagibá. ");
INSERT INTO tew_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Heḏiho Yôesi Táḏáḏí haˀwâa naˀingîˀ iˀandi, ti gínkꞌóe ívíyêngihéeˀa̖míḏí? Heḏân yoe. Háaḏí? Gá Yôesi Táḏáḏí dícha̖a̖máaḏân tꞌaywó̖ˀdi wíˀâymáapí waagi hä̖ä̖wí híwó̖ˀdi ívíˀandi namuuḏá yoe, hewänbo Jesus-víˀpiyeˀ ívíwänpiwhä̖yundeḏân. ");
INSERT INTO tew_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Heḏânho gínhanginná Yôesi Táḏáḏí tꞌowa ovâycha̖a̖máa tꞌaywó̖ˀdi wíḏâymáapí waagi inbí whä̖yu̖ dínmuuḏiboˀ, i tsontu̖u̖ dâyˀaˀginnamíḏí dívíkhä̖ä̖ḏeḏiḏa̖ˀbá yoe. ");
INSERT INTO tew_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Heḏi ti giˀâ̖a̖ní Yôesi-á in Huḏíyovîˀḏa̖ˀ namuuˀin, in Huḏíyo dimuupíˀinbîˀ-á yoe? Heḏân yoe. Yôesi-á in Huḏíyo dimuupíˀinbîˀ wáˀ namuu, ");
INSERT INTO tew_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","gá wîˀḏa̖ˀ wí Yôesi naˀä́ndân, heḏi iḏáho ovâycha̖a̖máa in Huḏíyo dimuuˀin Jesus-víˀpiyeˀ dívíwhä̖yundeˀin tꞌaywó̖ˀdi wíḏâymáapí waagibá, heḏá in Huḏíyo dimuupíˀin wáˀ hanbá. ");
INSERT INTO tew_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Heḏânho naˀinbí whä̖yu̖ gínmuuḏibo ti nä́ˀi tsontu̖u̖-á âyyoegiˀoˀ? Heḏân yoe. Nää-á shánkí gínkoeḏi âyˀaˀginnamíḏí háa natû̖ˀ waa. ");
INSERT INTO tew_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Nää wâyhíˀkhâymáa Abraham-bí̖ˀgeḏi háa ûnpóeˀin, i-á naˀin Huḏíyo gimuuˀinbí páaḏéˀi thehtáy pahpâa gínmuu. ");
INSERT INTO tew_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Yôesi natú̖ḏáho iḏá Abraham-dá óecha̖a̖máaˀin tꞌaywó̖ˀdi imáapí waagi híwó̖ˀ iˀoḏiboˀ, heḏânho Abraham ûnkoeḏí-íwän iví híwó̖ˀdi tsiyekan niˀgeḏi iyêngihéeˀa̖míḏí. Hewänbo Yôesi wínatú̖hpí Abraham-dá ûnkoeḏi iyêngihéeˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Yôesiví ta̖ˀnin diwe kinnân nata̖ˀmuupíˀan: Abraham Yôesivíˀpiyeˀ iwhä̖yu̖ḏânkun Yôesiḏi óecha̖a̖máa tꞌaywó̖ˀdi wíˀimáapí waagi. ");
INSERT INTO tew_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kin waagi namuupíˀan: Toˀwí itꞌôeˀandi-á óewáˀándeˀ, heḏi iví wáˀâa ûntꞌanmuu hä̖́yú̖ itꞌôeˀan waagiḏi, wíˀóewänpiḏamähpí. ");
INSERT INTO tew_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Hewänbo toˀwí wänbo híwó̖ˀdi hä̖ä̖wí iˀandi nawänpimuuḏibo háˀto ûnkoeḏí-í natú̖níḏí tꞌaywó̖ˀdi wíˀimáapí waagiˀbá namuu. Yôesiḏa̖ˀmân ûnkꞌóe wí toˀwí óecha̖a̖máˀve-íḏí tꞌaywó̖ˀdi wíˀimáapí waagi, nä́ˀi toˀwí tꞌaywó̖ˀtoˀi namuu wänboˀ, heḏi kin óecha̖a̖máa iví whä̖yu̖ ûnmuuḏiboˀ, híwó̖ˀ iˀa̖míḏí iwänpikhä̖ä̖ḏeḏiḏá yoe. ");
INSERT INTO tew_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Heḏânkun David hä́nˀoe natú̖ in toˀwên Yôesiḏi ovâycha̖a̖máaˀin tꞌaywó̖ˀdi wíḏâymáapí waagi dihíhcha̖a̖-í, hewänbo híwó̖ˀ dívíˀa̖míḏí dívíkhä̖ä̖ḏeˀin namuuḏá yoe. ");
INSERT INTO tew_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Kinnân ita̖ˀnan: In toˀwên inbí yä̖ˀḏâapí tsiyekan ovâyˀowóyéˀindáḏí in toˀwên inbí tꞌaywó̖ˀdi ovâyyâaˀannindáḏí dihíhcha̖a̖. ");
INSERT INTO tew_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","I toˀwí Yôesiḏi wíyá wíˀóetu̖ˀopí tꞌaywó̖ˀkandi gin nahíhcha̖a̖. ");
INSERT INTO tew_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Heḏi toˀgîˀ-an nä́ˀi híhchan namúní? Ti in Huḏíyogîˀḏa̖ˀ? Yoe, in Huḏíyo dimuupíˀingîˀ wáˀ namuupíˀan. Gínhanginnáhpíˀan Yôesi natú̖ˀin iḏi Abraham óecha̖a̖máa tꞌaywó̖ˀdi wíˀimáapí waagi iví whä̖yu̖ ûnmuuḏi. ");
INSERT INTO tew_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Hewänbo ti Abraham in Huḏíyo-ví kꞌewe̖ˀ taaḏi ho nataamuu ihayḏân kin Yôesi iví̖ˀgeḏi natú̖? Yoe, waˀḏi óetaaˀanpíḏíbo-ân. ");
INSERT INTO tew_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Tíˀúugéḏân Yôesi natú̖ Abraham in taa ikéyíˀin nathaypúwíḏí Yôesiḏi ho óecha̖a̖máaˀin tꞌaywó̖ˀdi wíˀimáapí waagi. Hewänbo kin Yôesi ho iˀan Abraham-bí whä̖yu̖ ûnmuuḏibo waˀ in taa imáapíḏíboˀ. Heḏânkun Abraham-dá tꞌä̖hkí in toˀwên taˀgendi Yôesivíˀpiyeˀ dívíwhä̖yundeˀinbí táḏá waagiˀbá dínmúní, tobá nä́ˀin Huḏíyoví kꞌewe̖ˀ taa dâymáapí wänboˀ, heḏi in wáˀ Yôesiḏi ovâycha̖a̖máa tꞌaywó̖ˀdi wíḏâymáapí waagi. ");
INSERT INTO tew_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Heḏá in toˀwên kin ditaamuuˀindá wáˀ Abraham-dá inbí táḏá waagiˀbá dínmuu, hewänbo in tꞌä̖hkívîˀ-á yoe. Abraham-bí ây waagiˀin taˀgendi dimúníḏí, indá díntáy iví a̖htaa eeye dívíˀa̖htuyé-íḏí, i waagibá whä̖yu̖ dâymáˀvé-íḏí, in taaḏa̖ˀbá yoe, gá nä́ˀi whä̖yu̖-áho Abraham imáaḏân waˀ in taa ikêˀpíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Yôesiḏi iví tu̖u̖ Abraham óemä́gi iḏi Abraham-dáḏí iví ây iweḏiˀindáḏí ovâymä̂äníˀin hä̖ä̖wí tꞌä̖hkí nä́ä oepáa kꞌayḏiwiˀ, hewänbo kin natú̖ gá Abraham óecha̖a̖máaḏân tꞌaywó̖ˀdi wíˀimáapí waagi iví whä̖yu̖ ûnmuuḏi, i tsontu̖u̖ iˀaˀginnamíḏí ikhä̖ä̖ḏeḏiḏá yoe. ");
INSERT INTO tew_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Yôesiḏi i hä̖ä̖wí ipä̖khâymáaˀiˀ in toˀwên i tsontu̖u̖ dâyˀaˀginnamíḏí dívísóˀḏíndeˀin ovâymä̂äníḏáhoˀ, in whä̖yu̖ ivíˀpiyeˀ wínatâynípí, heḏi i tu̖u̖ Yôesi imä́giˀi-á hä̖́ä̖bo wíˀûnmúnípí. ");
INSERT INTO tew_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Hewänbo wí toˀwí i tsontu̖u̖ iˀaˀginhá̖núḏá Yôesiḏi óetuchä̖nundeˀ. Tsontu̖u̖ wänbo nayipíḏá háˀto nakoeḏí-í wí toˀwí iˀaˀginhá̖nú-íḏí, hewänbo nayi-ákun nä́ˀi tsontu̖u̖. ");
INSERT INTO tew_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Heḏânkun hä̖ä̖wí híwó̖ˀdi ívíˀanpíḏíbo Yôesi iví tu̖u̖ imä́gi tꞌä̖hkí in Abraham-bí ây iweḏiˀin dimuuˀin dínkoeḏi iví séegísehkanä dâykéyíˀin inbí whä̖yu̖ dínmuuḏi. Heḏi kin Yôesiḏi ovâyˀâ̖a̖mí in toˀwên i tsontu̖u̖ dâymáaˀinda̖ˀbá yoe, hewänbo tꞌä̖hkí in toˀwên dívíwhä̖yundeˀin Abraham iwhä̖yu̖ waagibá. Abraham-dá táḏá waagiˀbá gínmuu tꞌä̖hkí naˀin taˀgendi Yôesivíˀpiyeˀ ívíwhä̖yundeˀingîˀ. ");
INSERT INTO tew_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Yôesiví ta̖ˀnin diwe ûnkwꞌó̖ háa Yôesi natú̖ waagi: Abraham, wí táḏá waagi wísóge báyékí tꞌowagîˀ wéngé dithaa wänboˀ. Abraham-dá Yôesivípiyeˀ iwhä̖yundeˀ, heḏiho Yôesiḏi i-á ho óecha̖a̖ hä̖ˀin tꞌowaví táḏá dínmuu waagi. Yôesi-á ûnkoeḏi chuˀin wänbo ovâywówápaa-íḏí, heḏá tobáháa hä̖ä̖wí waˀ wínapóepí wänboˀ, napúwí gin Yôesi natú̖ḏáhoˀ, napúwí-ákun. ");
INSERT INTO tew_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Heḏiho tobá whä̖yu̖píwó̖ˀ waa namuu wänboˀ Abraham-dá iwhä̖yu̖ báyékí tꞌowa wéngé tꞌä̖hkí dithaaˀinbí táḏá dínpuwagítꞌóeˀin, gá Yôesiḏi óetu̖ˀandân báyékí tíˀúugé kä̖ˀä̖ä̖ˀin ûnkwo̖ˀgítꞌóeˀin, heḏi han ûnpóe. ");
INSERT INTO tew_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Iví túuˀú i̖ˀgeḏi iˀánshaamáaḏí, háˀto iˀâykwꞌôení waa nacha̖a̖, maˀḏi tä̖gintä̖ (100) pa̖a̖yoˀi ho namuuḏi, heḏá iví kwiyó Sarah-á wä̖hphaḏe kwiyó nää ûnmuuḏihoˀ, háˀto nasáhpúwí i̖ˀgeḏi wáˀ iˀánshaaˀan. Hewänbo tobá kin namuu wänbo iví whä̖yu̖ waˀḏi ûnkay. ");
INSERT INTO tew_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Yôesiví tu̖u̖ óemä́giˀin ônwhä̖yu̖, heḏi iví whä̖yu̖ ûnhá̖á̖nívíˀweḏi shánkí ûnkaypóe, heḏiho Yôesi-áho kwꞌáayéboˀ óemáa. ");
INSERT INTO tew_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Iví píˀnä́ khóˀyéhoˀ ûnhanginná Yôesi ûnkoeḏiˀin hä̖ä̖wí tꞌä̖hkí natú̖ˀiˀ iˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Heḏânkun Yôesi natú̖ iḏi Abraham óecha̖a̖máa tꞌaywó̖ˀdi wíˀimáapí waagi iví whä̖yu̖ ûnmuuḏi. ");
INSERT INTO tew_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Hewänbo nä́ˀi híˀ Abraham-bí̖ˀgeḏi Yôesi natú̖ˀiˀ Abraham-gîˀḏa̖ˀ wínata̖ˀmuupí, ");
INSERT INTO tew_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","hewänbo naˀingîˀ-ân wáˀ nata̖ˀmuu, gá Yôesi-á natú̖ḏân naˀin wáˀ dícha̖a̖ tꞌaywó̖ˀdi wíˀâymáapí waagi ivíˀpiyeˀ ívíwhä̖yundeḏi, iḏá Jesus naˀinbí tsondi shánkí hayˀi gínmuuˀiˀ óewáywówápaa. ");
INSERT INTO tew_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yôesi Táḏáḏí Jesus óemä́gi naˀinbí tꞌaywó̖ˀdi gínmuuḏi nachúu-íḏí, heḏá óewáywówápaa nakeepúwíḏí dícha̖a̖máaˀin tꞌaywó̖ˀdi wíˀâymáapí waagi. Jesus-víˀpiyeˀ ívíwhä̖yundeḏáho Yôesi Táḏáḏí dícha̖a̖máa tꞌaywó̖ˀdi wíˀâymáapí waagi. ");
INSERT INTO tew_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Heḏiho nää Naˀinbí Sedó Jesus Christ-di naˀindáḏí Yôesi Táḏá-áḏí díwón, gá Yôesi Táḏáḏá dícha̖a̖máaḏân tꞌaywó̖ˀdi wíˀâymáapí waagi naˀinbí whä̖yu̖ gínmuuḏi. ");
INSERT INTO tew_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Heḏi naˀinbí whä̖yu̖ gínmuuḏibá Jesus-di Yôesi Táḏávíˀpiyeˀ díkán, iví séegísehkanä âytáa-íḏí, heḏi hä̖̂ä̖ḏi wänbo tꞌä̖hkí nä́ˀi séegísehkanä-á âymáˀve-í. Heḏi hânho ívíhíhchandoˀ, gá gínhanginnândân wáy wí thaa-á Yôesiví saˀwó̖ˀdi kohthay iwe i-áḏí gikwo̖ˀgítꞌóeˀin. ");
INSERT INTO tew_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hewänbo hä̖hayḏiˀḏa̖ˀbá wígihíhchanpí. Gihíhchan wáˀ âytˀôephaḏende wänboˀ, gá tobáháa gínpóe wänbo nä́ˀi tꞌôephaḏe namuuˀiḏi gihá̖hpoˀḏân ívíyä̖́ä̖ˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Heḏá ívíyä̖́ä̖ˀandá shánkí gikweesenpaˀ, heḏi gikweesenpaa iweḏáho shánkí gínhanginná ho napúwíˀin háa Yôesi natú̖ waa dípä̖gítꞌóeˀin. ");
INSERT INTO tew_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Heḏi kin ívíwhä̖yundeḏá háˀto gichanpúwí híwó̖ˀpîˀpiyeˀ ívíwhä̖yundeˀin, gá i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ Yôesiḏi dímä́giˀi naˀinbí píˀnä́ khóˀyé âymáaḏân, heḏi iḏá dînthayyo Yôesi Táḏáḏí hânho naˀin díséegíˀin. ");
INSERT INTO tew_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Waˀḏi wíˀbo ívípikhä̖ge̖ˀnamíḏí yä̖ˀḏâaˀin gimúníḏí gínkoeḏipíḏíboˀ, híwó̖ˀ nanáˀ dihayḏân Christ nachuu naˀin gimuuḏi, in Yôesi âyˀaˀginpíˀin gimuu wänboˀ. ");
INSERT INTO tew_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nabâapuˀwan óeshaa-íḏí wí toˀwí nahíye-íˀi wíyá toˀwígîˀ nachúu-íḏí, tobáháa i wíyá toˀwí i tsontu̖u̖ iˀaˀgindo wänboˀ. Maˀḏân wí toˀwí nahíye-í wíyá toˀwí iví wówátsi taˀge ihondi namuuˀigîˀ nachúu-íḏí. ");
INSERT INTO tew_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Hewänbo waˀḏi naˀinbí wówátsi thaa tꞌaywó̖ˀdiwe gikwꞌó̖ˀ dihayḏibo Christ naˀingîˀ nachuu. Kindiḏân Yôesi Táḏáḏí dînkeeyan naˀin hânho díséegíˀin. ");
INSERT INTO tew_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Heḏânkun taˀgendi gínhanginná Jesus-di dînˀaywoeníˀin Yôesi Táḏáḏí wíḏítuchä̖nú-ípíḏí, gá naˀingîˀ ho nachuuḏi iví ûnpꞌoe ichꞌáaḏân, heḏânho Yôesi Táḏáḏí dícha̖a̖máˀve-íḏí tꞌaywó̖ˀdi wíˀâymáapí waagi. ");
INSERT INTO tew_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Yôesi Táḏáví hä́nmin gimúˀdewän, hewänbo nää-á i-áḏí ívíwón iví ay naˀingîˀ nachuuḏi. Heḏiho nää Yôesi Táḏá-áḏí ívíwóndí gínhanginná taˀgendi dînˀaywoeníˀin gá iví ay wíyá ûnwówápóeḏân. ");
INSERT INTO tew_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Hewänbo hä̖hayḏa̖ˀbá wínamuupí, nää-á gihíhchan wáˀ gá Jesus Christ, i shánkí natsonyiˀi namuuˀi heḏá i Yôesi Táḏá-áḏí díwóndi-á, iḏiho dînkeeyan háawi Yôesi Táḏá namuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Wí wîˀ toˀwí Adam gin nakhá̖wä̖́ˀiˀ itꞌaywó̖ˀnan, heḏi i-á itꞌaywó̖ˀnandi tꞌä̖hkí tꞌowa tꞌaywó̖ˀdi giyä̖́mu. Adam-dá itꞌaywó̖ˀnandi nachuu, heḏi naˀin wáˀ ívítꞌaywó̖ˀnandibo tꞌä̖hkíḏíbo gitꞌa̖há̖a̖ní. ");
INSERT INTO tew_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Wí tsontu̖u̖ wänbo nayipíḏáho Yôesi háˀto natú̖ní tꞌowa wíḏâytsontu̖u̖ˀaˀginmáapíˀin heḏiho wínatú̖nípí dívítꞌaywó̖ˀnannin. Hewänbo nä́ä oepáa kꞌayḏi in tꞌowa-á dívítꞌaywó̖ˀdoho waˀḏi Moses i tsontu̖u̖ ita̖ˀnanpíḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Nä́ˀin gínhanginná gá Adam-bí thaa iweḏi Moses-ví thaa iwehay chuwa-á tꞌä̖hkí tꞌowa dínpówáḏân, tobá inbí tꞌaywó̖ˀdi dínmuuˀi Adam-bí tꞌaywó̖ˀdi waagi wíḏínmuupí wänboˀ. ");
INSERT INTO tew_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Háa Adam ûnpóeˀindi díhá̖ˀo Jesus-ví̖ˀgeḏi, i-á Adam-bí wówátsi thaa ihayḏi waˀ nä́ä oepáa kꞌayḏi wínapówápí. Hewänbo háa Adam iˀannindá heḏá háa Jesus iˀannindá handa̖ˀ wíḏä́nmuupí. Hä̖ä̖wí Yôesiḏi khâ̖a̖gipí dímäˀi-á Adam-bí tꞌaywó̖ˀdiví shánkí nakay. Wîˀ wí sen Adam namuuˀi Yôesiví pꞌóegéḏí ihângeˀandibo tꞌä̖hkí tꞌowa ditꞌa̖hán. Hewänbo Yôesiví séegísehkanä-á heḏá hä̖ä̖wí dímäˀi-á shánkí gáhä̖́yú̖ˀi ûnmuu Adam-bí tꞌaywó̖ˀdi ûnmuuˀivíˀweḏi, heḏi tꞌä̖hkí tꞌowa dínkoeḏi nä́ˀi Yôesi imäˀi dâyhóníḏí, wîˀ wí sen Jesus Christ namuuˀiví séegísehkanä ûnmuuḏi. ");
INSERT INTO tew_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Heḏi háa napóeˀin i Yôesi Táḏáḏí dímäˀ iweḏi heḏá háa napóeˀin Adam-bí tꞌaywó̖ˀdi iweḏá handa̖ˀ wíḏä́nmuupí. Nä́ˀin wéhpêe tꞌaywó̖ˀnin Adam iˀannin namuuḏá Yôesi Táḏá natú̖ tuchä̖nu-á naˀä̖́ä̖-í, hewänbo tobá báyékí wây-á tꞌowa báyékí tꞌaywó̖ˀ dívíˀo wänboˀ, Yôesiḏi wí híwó̖ˀdi hä̖ä̖wí wáˀâapíḏíbo naˀin dímäˀ waagibá iḏi dícha̖a̖máa tꞌaywó̖ˀdi wíˀâymáapí waagi. ");
INSERT INTO tew_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Heḏânkun wí wîˀ sen itꞌaywó̖ˀnandibo chuwaḏi naˀin tꞌä̖hkí díhógi. Hewänbo háa nä́ˀi wíyá wí sen Jesus Christ namuuˀiˀ iˀannindá shánkí hayˀin namuu. Iḏá hânho báyékí séegísehkanä-á dímäˀ, heḏi kinnân dítu̖máa: Tobá gíntꞌanmuupí wänboˀ, i-á natû̖ˀ iḏi dícha̖a̖máa tꞌaywó̖ˀdi wíˀâymáapí waagi, heḏi wówátsi nahándepíˀin âymáˀve-í, heḏá iwe tsonnin waagiˀinbá githáa-í. ");
INSERT INTO tew_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Heḏiho haˀwâagi napóe. Wéhpêe tꞌaywó̖ˀnin Adam iˀannin namuuḏiho tuchä̖nu napówá tꞌä̖hkí tꞌowagîˀ, heḏá han waagibá wí wîˀ taˀgeḏa̖ˀ hä̖ä̖wí Jesus iˀannin namuuḏi nakoeḏi tꞌä̖hkí tꞌowa ovâytu̖ˀa̖míḏí tꞌaywó̖ˀdi dâymáapíˀin waagiˀin dimuu, heḏá wówátsi nahándepíˀindá ovâymä̂äní. ");
INSERT INTO tew_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Wí wîˀ toˀwí Adam namuuˀi háa Yôesi Táḏáḏí óetu̖ˀan waa wíˀiˀaˀginpíḏího tꞌä̖hkí tꞌowa ditꞌaywó̖ˀtoˀinpaa. Hanbá i wíyá wîˀ toˀwí Jesus namuuˀiˀ iˀaˀginnandibo tꞌä̖hkí tꞌowa dínkoeḏ dipúwíˀin in Yôesiḏi ovâycha̖a̖máaˀin tꞌaywó̖ˀdi wíḏâymáapí waagi. ");
INSERT INTO tew_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Yôesi iví tsontu̖u̖ imä́gi tꞌowa ovâythayya̖míḏí hä̖́yú̖ hânho dívítꞌaywó̖ˀnannin. Hewänbo i tꞌaywó̖ˀdi gínkeepóe ihayḏá Yôesiví séegísehkanä-á shánkí wänbo-á ûnkeepóe. ");
INSERT INTO tew_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Heḏiho i tꞌaywó̖ˀdi kayˀi namuuḏibo tꞌowa ovâytꞌandânho chuwaho dínkꞌóe, hewänbo Yôesi Táḏáví séegísehkanä-á tꞌaywó̖ˀdiví shánkí ûnkay, heḏiho naˀin dícha̖a̖máa tꞌaywó̖ˀdi wíˀâymáapí waagi heḏânho wówátsi nahándepíˀin âykéyíḏí, háa Jesus Christ naˀinbí tsondi hayˀi gínmuuˀi naˀingîˀ iˀannin namuuḏi. ");
INSERT INTO tew_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Báyékí tꞌaywó̖ˀdi dînˀowóyéndeḏiho Yôesiví séegísehkanä shánkí ûnkeepoˀ. Heḏiho hân gínkhâyˀä̖ˀ ívíˀa̖míˀin? Ti in taˀgen gínkꞌóe ívítꞌaywó̖ˀkanhûuwíḏí wíyá shánkí iví séegísehkanä ûnkeepúwíḏíboˀ? ");
INSERT INTO tew_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Heḏân yoe. Tꞌowa chuˀin dimuuˀindá wíḏívítꞌaywó̖ˀdopí, heḏiho tꞌowa chuˀin waagiˀinbá gínkhâyˀä̖ˀ gimúníˀin heḏânho tꞌaywó̖ˀdi eeye wíˀívíhûuwípíḏí. ");
INSERT INTO tew_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Naˀin dípꞌóˀpꞌoeˀan âykeeya̖míḏí Christ Jesus-áḏí wîˀḏa̖ˀ gimuuˀin. Ti wíˀúnhanginnáhpíˀan dípꞌóˀpꞌoeˀan dihayḏi i-áḏí gichuu waagibá âykeeyan. ");
INSERT INTO tew_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Heḏânkun dípꞌóˀpꞌoeˀan dihayḏi, i-áḏí gichuuḏáháˀ díkhä̖ˀkwꞌóḏi waagibá napoé, heḏânho Yôesi Táḏáví pínnán kayḏi Christ nawáywówápóe waagibá, naˀindá wáˀ wówátsi tsꞌa̖a̖min âymáˀve-í. ");
INSERT INTO tew_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","I-áḏí gichuu waagibá gipóe, heḏiho kindiḏi i-áḏí wîˀḏa̖ˀ waagibá gipóe. Heḏânkun i nawáywówápóe waagibá naˀin wáˀ díwáywówápaa-í. ");
INSERT INTO tew_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Gínhanginná nä́ˀin: Tꞌaywó̖ˀtoˀin tꞌowa gimuuwän, hewänbo Jesus-áḏí phéˀwan deeḏi gichuu waagibá gínpóe heḏânho háa gimúˀde waagiˀin wíyá wígimúnípíḏí, heḏá iweḏá i tꞌaywó̖ˀdi iweḏi dímaˀpꞌä̖́ḏi-í, ");
INSERT INTO tew_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","gá toˀwên dichuuˀindá tꞌaywó̖ˀ diweḏi dimaˀpä̂ndân. ");
INSERT INTO tew_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nä́ˀin ívíwhä̖yundeˀ: Christ-áḏí gichuuḏá i-áḏíbá giwówáyê̖e̖ní, ");
INSERT INTO tew_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","heḏi gínhanginná Christ nawáywówápóeḏí hä̂nhay wänbo wíyá wínachúu-ípí. Chuwaḏi háˀto wíyá óetꞌaaní. ");
INSERT INTO tew_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Christ nachuuḏiho tꞌaywó̖ˀdiḏi háˀto wíyá óekéyí, heḏi nää wíyá nawáywówápóeḏá hä̂nhay wänbo tꞌä̖hkí nawówáyê̖e̖ní i Táḏá óehíhchanmä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Heḏi un wáˀ chuˀin ímuu waagi kin únkhâyˀä̖ˀ íˀâ̖a̖níˀin heḏânho wíˀúvítꞌaywó̖ˀkanhûuwípíḏí. Nää-á Jesus Christ-áḏí ímuuḏi unbí wówátsi bînˀa̖mí Yôesi Táḏá bînhíhchannamíḏí. ");
INSERT INTO tew_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Heḏânkun wíˀúvímä̂änípí i tꞌaywó̖ˀdiḏi wovâytꞌaaníḏí, heḏi unbí túuˀú iwe háa íwänpicha̖a̖ waagi wíˀúvíkanhûuwípí, nä́ˀi túuˀú-á wáy wí thaa únkhangítꞌóe. ");
INSERT INTO tew_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Wáy wí wänboˀ unbí túuˀúḏí tꞌaywó̖ˀkan wänbo yä̖ˀdâapíkan wänbo wívînkanmä̂änípí. Shánkíḏí kinnân úvíˀa̖mí: Unbí wówátsi-á Yôesi Táḏá bînmä̂äní gá iḏân chuwa iweḏi wovâywhahógiḏi wówátsi tsꞌa̖a̖min wovâymä́giḏân, heḏá unbí túuˀú tꞌä̖hkíḏá híwó̖ˀdiḏa̖ˀ Yôesi Táḏágîˀ bînˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nää iweḏi tꞌaywó̖ˀdiḏi wíyá wíwovâytꞌankhâymáapí gá wíˀúvíwänpisóˀḏíndepíḏân híwó̖ˀnin ípúwíḏí i tsontu̖u̖ bînˀaˀgindoḏiboˀ, hewänbo Yôesiví séegísehkanäḏân wovâykhä̖ge̖ˀdo híwó̖ˀ úvíkanhûuwíḏí. ");
INSERT INTO tew_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Heḏiho kin napoˀḏi hânnan nää ívíˀa̖mí? Ti gínkꞌóe i tsontu̖u̖ âyˀaˀginhá̖nú-íḏí heḏi kin ívítꞌaywó̖ˀnâamí? Heḏân yoe. ");
INSERT INTO tew_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Únpihanginnáhpíˀan wí toˀwívíˀpiyeˀ úvímä́giḏá igîˀḏa̖ˀ úvítꞌôeˀa̖míḏí heḏá iḏa̖ˀ bînˀaˀginnamíḏá, heḏân nä́ˀi toˀwíví pantꞌôeˀin waagiˀinbá ímuu. Heḏiho hanbá úvíwänpitꞌaywó̖ˀkanhondá kindiḏi tꞌaywó̖ˀdiví panho ímuu, heḏá íchúu-í. Hewänbo Yôesivíˀpiyeˀ úvímä́giḏá bînˀaˀginnamíḏí, iví pantꞌôeˀin waagiˀin ímuu, heḏi iḏá wovâycha̖a̖máa tꞌaywó̖ˀdi wívînmáapí waagi. ");
INSERT INTO tew_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Naaḏi Yôesi dókú̖ˀdaaˀoˀ, gá tobá úvítꞌaywó̖ˀdoḏi nä́ˀi tꞌaywó̖ˀdiví pantꞌôeˀin waagiˀin ímúˀde wänboˀ, nää-á pín taˀge hayḏi in taˀgen há̖hkan wovâymä́giˀin bînˀaˀgindoḏân. ");
INSERT INTO tew_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Nää-áho tꞌaywó̖ˀdi iweḏi ímaˀpꞌä̖́, heḏi unbí wówátsi thaa úvímä́gi híwó̖ˀdiḏa̖ˀ úvíˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Yä̖ˀḏâakan niˀgeḏá tꞌôeḏi íkaˀpóya̖ˀ, heḏânho nä́ˀin pantꞌôeˀinbí̖ˀgeḏi naaḏi wâyhíˀmáa wâythayya̖míḏí shánkí íkaˀpówá-íḏí. Wáymûu-áho úvítꞌaywó̖ˀdoḏi wên pantꞌôeˀin waagiˀinbá ímuuwän, heḏiho unbí túuˀú tꞌä̖hkíḏí úvítꞌaywó̖ˀdowän, heḏá hä̖̂ä̖ḏi wänbo tꞌä̖hkí híwó̖ˀpîˀ úvíˀowän. Hewänbo nää-á Yôesivíˀpiyeˀ úvípimä̂äní iví pantꞌôeˀin waagiˀin ímúníḏí, unbí wówátsi taˀge bînhûuwíḏí, heḏânho yä̖ˀḏâaˀinda̖ˀ ímúníḏí háa Yôesi nadaˀ waagi. ");
INSERT INTO tew_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Tꞌaywó̖ˀdiví pantꞌôeˀin ímuu ihayḏi wíˀídaˀpíwän unbí wówátsi taˀge bînhûuwíḏí. ");
INSERT INTO tew_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","I tꞌaywó̖ˀdi hä̖ä̖wí úvíˀandiḏi nää wovâywôedaˀmäˀ, heḏi hândiḏan nä́ˀi tꞌaywó̖ˀdiḏi wovâykhä̖ge̖ˀnan? Wéngéḏí wänbo yoe. I tꞌaywó̖ˀdi úvíˀoˀi namuuḏi chuwa iwe ípowagítꞌóewän. ");
INSERT INTO tew_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Hewänbo tꞌaywó̖ˀdi iweḏi ímaˀpꞌä̂ndi nää-á Yôesiví pantꞌôeˀin waagiˀin ímuu, heḏi iḏi wovâykhä̖ge̖ˀdoˀ yä̖ˀḏâaˀin ípúwíḏí. Heḏi Yôesivíˀpiyeˀ úvímä́giḏiho wówátsi nahándepíˀin bînkéyí. ");
INSERT INTO tew_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Tꞌaywó̖ˀdigîˀ ívítꞌôeˀandá chuwa-ân naˀinbí wáˀâa-á gínmúní. Hewänbo Jesus Christ naˀinbí tsondi hayˀi-víˀin gimuuḏá, in wówátsi nahándepíˀin Yôesi Táḏáḏí dímäˀ. ");
INSERT INTO tew_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Tíˀûuwin páaḏéˀin, tsontu̖u̖ i̖ˀgeḏi únhanginnáˀnin ímuu, heḏiho wâyhíˀkhâymáa kinnân: Únhanginnáhpíˀan únkhâyˀä̖ˀ nä́ˀi tsontu̖u̖ bînˀaˀginnamíˀin hä̖́yú̖ wówátsi úntä̖ˀän diwe puˀwahayḏa̖ˀ. ");
INSERT INTO tew_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Gá kinnân: Wí kwee nakhóhtsa̖a̖ˀä́ndi-á ûnkhâyˀä̖ˀ iví sedó-áḏíḏa̖ˀ natháa-íˀin hä̖́yú̖ wówátsi thaa iví sedó ûntä̖ˀän diwehay. Hewänbo iví sedó ûnchuu ihayḏáho iví sedó-áḏí wíyá wínawhiˀä́npí. Hannânho natû̖ˀ in khóhtsa̖a̖ tsontu̖u̖. ");
INSERT INTO tew_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Heḏi wíyá piˀwí sendáḏí ithayeḏá waˀḏi iví sedó ûnwówáyiḏiboˀ, iví sedóvíˀpiyeˀ itꞌaywó̖ˀdoˀ. Hewänbo iví sedó ûnchuuḏáho in khóhtsa̖a̖ tsontu̖u̖ iweḏi nawhimaˀpꞌä̖́, heḏiho wíyá piˀwí sendáḏí ikhóˀyâ̖ˀḏáho tꞌaywó̖ˀtoˀi wínamúnípí. ");
INSERT INTO tew_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Un wáˀ kin waagibá únpoˀ, naví tíˀûuwin páaḏéˀin. Christ-ví túuˀú ûnchuu ihayḏá un wáˀ íchuu waagibá únpóe heḏi kindiḏi nä́ˀi tsontu̖u̖ Moses ita̖ˀnan diweḏi wovâywiye. Heḏiho nää-á únkoeḏi wíyá toˀwívîˀ ímúníˀin, i toˀwí nawáywówápóeˀi-ân i namuu. Heḏiho nää-á ivîˀ gimuuḏi gínkoeḏi híwó̖ˀdi hä̖ä̖wí Yôesi Táḏágîˀ ívíˀâ̖a̖míˀin. ");
INSERT INTO tew_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Háa giwänpidaˀ waagi ívítꞌaywó̖ˀdoḏi naˀinbí wówátsi âyhonwänhoˀ, heḏi ihayḏá wíyá shánkí ívítꞌaywó̖ˀnamíˀin gidaˀpoˀ nä́ˀi tsontu̖u̖ gitꞌoˀḏi, heḏi chuwa iwe gipóya̖ˀwän nä́ˀi tꞌaywó̖ˀdiḏi naˀinbí túuˀú dîntsonmáaḏíboˀ. ");
INSERT INTO tew_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Hewänbo nää-á i tsontu̖u̖ iweḏi gimaˀpꞌä̖́. Nää-á Christ-áḏí gichuu waagibá gínpoˀḏi i tsontu̖u̖ḏi wíḏítsonmáapí. Nää-á wíyá tsꞌa̖a̖bi gihá̖hpóe Yôesi âyˀaˀginmä̂äníḏí i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi díhá̖ˀo waagi, háa ívíˀowän waagá yoe i tsontu̖u̖ nata̖ˀmuuˀiˀ âyˀaˀginnamíḏí ívísóˀḏínde ihayḏi. ");
INSERT INTO tew_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Heḏi ti gitú̖ní nä́ˀi tsontu̖u̖-á tꞌaywó̖ˀdi namuu gin? Heḏân yoe. I tsontu̖u̖ḏiḏa̖ˀmânho dînkeeyan hä̖ä̖wí taˀgendi tꞌaywó̖ˀdi namuuˀin. Gá kinnân: I tsontu̖u̖-á natû̖ˀ, Hä̖ä̖wí wíyá toˀwí ûnkwꞌó̖ˀdiˀ wíˀídaˀípí. Han natú̖nípíḏá háˀto naa dînhanginnáníwän wíyá toˀwíví hä̖ä̖wí oḏadaˀḏi dáytꞌaywó̖ˀdoˀin. ");
INSERT INTO tew_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Hewänbo hä̖ˀin tsontu̖u̖ i̖ˀgeḏi ohá̖hpóe ihayḏá shánkí dáytꞌaywó̖ˀnamíˀindá odaˀpóe, heḏiho wíyá i hä̖ä̖wí navîˀ namuupîˀ shánkí owänpidaˀ. Hewänbo i tsontu̖u̖ nakꞌóepíḏá háˀto taˀgendi dînhanginnáníwän dáytꞌaywó̖ˀnannin. ");
INSERT INTO tew_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","10","Naa oˀân owówámuuˀin waˀ Yôesiví tsontu̖u̖ okaˀpówápí ihayḏiboˀ. Hewänbo nä́ˀin tsontu̖u̖ natú̖ˀin wíḏînkhâyˀä̖hpí wíyá toˀwíví hä̖ä̖wí odaˀíˀin taˀgendi okaˀpówá ihayḏá, shánká dáytꞌaywó̖ˀnamíˀindá odaˀ, heḏi ochuu waagibá dînhanginpóe. Heḏiho tobá naˀin wówátsi âykéyíḏí Yôesiḏi iví tsontu̖u̖ dímä́gi wänboˀ, naa-á in chuwaḏa̖ˀ dînkán. ");
INSERT INTO tew_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","I tsontu̖u̖ i̖ˀgeḏi ohá̖hpóe ihayḏá, i tꞌaywó̖ˀdiḏá in taˀgen nä́ˀi tsontu̖u̖ i̖ˀgeḏi namuuˀin dînkaayan, heḏi nä́ˀi tꞌaywó̖ˀdiḏibá díhay waagibá dînpóe. ");
INSERT INTO tew_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","I tsontu̖u̖ Moses ita̖ˀnandi-á Yôesivíˀweḏi naˀä̖ä̖, heḏi tꞌä̖hkí i híˀ iwe nata̖ˀmuuˀi yä̖ˀḏâaˀi-á taˀgendi-á híwó̖ˀdi-á namuu. ");
INSERT INTO tew_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ti nä́ˀi híwó̖ˀdi tsontu̖u̖ḏi wíˀbo in chuwa dînkán? Heḏân yoe. Naví tꞌaywó̖ˀdiḏân in chuwa dînkán. Hewänbo tobá nä́ˀi tsontu̖u̖-á híwó̖ˀdi namuu wänboˀ, naa dáytꞌaywó̖ˀnandânho i tsontu̖u̖ natú̖ chuwa iwe díkáaníˀin. Heḏiho dînhanginpóe taˀgendi háawi i tꞌaywó̖ˀdi namuuˀin. I tsontu̖u̖ḏân dînthayyan tꞌaywó̖ˀdi-á hânho yä̖ˀḏâapîˀ namuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Gínhanginná Yôesiví Pꞌoewa̖a̖hâ̖a̖ḏi nä́ˀi tsontu̖u̖ dímä́giˀin. Hewänbo naa-á wí toˀwí háa okandaˀ waagi dáywänpiˀoˀi omuu, gá tꞌaywó̖ˀdiví pantꞌôeˀi waagibá omuuḏân. ");
INSERT INTO tew_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Naa wíḏînhanginnáhpí háaḏí kin waagi dáyˀoˀin. Tobá híwó̖ˀ okandaˀ wänboˀ, híwó̖ˀ wíḏáyˀopí, hewänbo i híwó̖ˀpîˀ dótꞌayˀi-á ihayḏa̖ˀ dáyˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Heḏi híwó̖ˀpîˀ taˀgendi wóˀkandaˀpí wänbo dáyˀoḏá, iweḏi nakeepoˀ naa ochanpoˀin i tsontu̖u̖-á híwó̖ˀdi-ânkun namuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Heḏiho nää-á naa-á wíˀbo i wóˀmuupí haˀwâagi dáyˀoˀiˀ, hewänbo i tꞌaywó̖ˀdi naví píˀnä́ dînkwꞌôndiḏân kin waagi díkandoˀ. ");
INSERT INTO tew_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Tꞌowa-ân omuuḏi hä̖́ä̖bo híwó̖ˀdi naví píˀnä́ khóˀyé wíḏînkwꞌó̖hpí. Nä́ˀi-á dînhanginná gá tobá híwó̖ˀ okandaˀ wänbo wíḏînkoeḏipíḏân. ");
INSERT INTO tew_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Wíyá otú̖ní: I híwó̖ˀdi okandaˀi-á wíḏáyˀopí, hewänbo i híwó̖ˀpîˀ-áho dáyˀoˀ, odaˀpí wänboˀ. ");
INSERT INTO tew_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Heḏi i okandaˀpîˀ-á dáyˀandáhoˀ, naa-á wíˀbo i wóˀmuupí haˀwâagi dáyˀoˀiˀ, hewänbo i tꞌaywó̖ˀdi naví píˀnä́ dînkwꞌôndiḏân kin waagi díkandoˀ. ");
INSERT INTO tew_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Heḏânkun kin waagi hä̖̂ä̖ḏi wänbo tꞌä̖hkí dînpoˀ naa: Híwó̖ˀ okandaˀ wänboˀ, shánkí wíḏînbâapuˀwanpí dáytꞌaywó̖ˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Naví píˀnä́ khóˀyé-á ochanpoˀ Yôesiví tsontu̖u̖-á híwó̖ˀdiḏa̖ˀ namuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Hewänbo dînhanginná hä̖̂ä̖ḏi wänbo tꞌä̖hkí naví túuˀú tꞌä̖hkí iwe wíyá piˀwí hä̖ä̖wí nayiˀ, i-á naví híwó̖ˀdi ánshaa-áḏí ihä́nbo waagibá, heḏi naví túuˀú iweḏi owänpitꞌaywó̖ˀdikandaˀḏi wí pantꞌôeˀi waagi opoˀ. ");
INSERT INTO tew_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","25","Heḏi kindiḏiho naví píˀnä́ khóˀyé-á taˀgendi Yôesigîˀḏa̖ˀ otꞌôedaˀ. Hewänbo naa tꞌowaḏa̖ˀ omuuḏi dáytꞌaywó̖ˀdoˀ. Áhkhiˀyowän, toˀḏan díkhä̖ge̖ˀnamí naa, heḏânho nä́ˀi túuˀúḏí chuwa iwe wíḏíkáanípíḏí? Naaḏi Yôesi Táḏá dókú̖ˀdaaˀoˀ gá Jesus Christ i shánkí natsonyiˀi namuuˀiḏáho díkhä̖ge̖ˀdoḏân. ");
INSERT INTO tew_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Heḏiho nää-á in toˀwên Christ Jesus-áḏí dimuuˀindá Yôesi Táḏáḏí wíˀovâytuchä̖nú-ípí, ");
INSERT INTO tew_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","gá Christ Jesus-áḏí wîˀḏa̖ˀ waagibá gimuuḏi i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ i wówátsi napä̖yiˀiˀ ûnkoeḏiḏân dímaˀpꞌä̖́ḏi-íḏí tꞌaywó̖ˀdiweḏi heḏá chuwa iweḏá. ");
INSERT INTO tew_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Naˀindá tꞌowaḏa̖ˀ gimuuḏi wígikaypí, heḏiho Yôesiví tsontu̖u̖ ihay wíˀâyˀaˀgindopí heḏânho tꞌaywó̖ˀdiweḏi dînˀaywoeníḏí. Hewänbo Yôesi Táḏá-ânho ûnkoeḏi dînˀaywoeníḏí. Kin iˀa̖míḏí iví ay dînsan wí tꞌowa napáa-íḏí, naˀin kaypíˀin tꞌaywó̖ˀtoˀin tꞌowa waagibá napóe, heḏi tobá tꞌaywó̖ˀdi wíˀiˀanpí wänbo naˀinbí tꞌaywó̖ˀdi gínmuuḏi nachuu. Handiḏiho nä́ˀi tꞌaywó̖ˀdi-á óetꞌan, heḏânho tꞌaywó̖ˀdiḏi naˀin wíyá wíḏítꞌaanípíḏí. ");
INSERT INTO tew_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Heḏi kin iˀan heḏânho Yôesiví tsontu̖u̖ natú̖ waa naˀinbí wówátsi taˀge âyhûuwí. Heḏi nää-á háa giwänpidaˀ waagiḏa̖ˀ wíˀívíkanhonpí, hewänbo háa i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ natú̖ ívíˀa̖mí waagân. ");
INSERT INTO tew_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","In toˀwên háa diwänpidaˀ waagi dívíˀoˀindá hä̖̂ä̖ḏi wänbo tꞌa̖hkí dívíˀánshaaˀo hä̖ä̖wí dikandaˀ i̖ˀgeḏiḏa̖ˀ, hewänbo in toˀwên háa i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ nadaˀ waagi dívíˀoˀindá hä̖̂ä̖ḏi wänbo tꞌä̖hkí dívíˀánshaaˀoˀ i hä̖ä̖wí i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ nadaˀpóeˀiˀ. ");
INSERT INTO tew_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Heḏi háa giwänpidaˀ waagi ívíˀa̖míˀin niˀgeḏiḏa̖ˀ ívíˀánshaamáaḏá chuwa iwe gipówá-í, hewänbo háa i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi dítu̖ˀan waagi i̖ˀgeḏi ívíˀánshaamáaḏá taˀgennin wówátsi-á híhchan ánshaa-á gínˀä̖ä̖-í. ");
INSERT INTO tew_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Heḏânkun wí toˀwí háa nawänpidaˀ waagi iˀa̖míˀinda̖ˀ iˀánshaaˀoḏi Yôesiví hä́nbiˀ waagiˀbá namuu, gá Yôesiví tsontu̖u̖ wíˀiˀaˀgindopíḏân, heḏi wíˀûnkoeḏipí ônˀaˀginnamíḏí. ");
INSERT INTO tew_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Heḏi ki̖ˀmin tꞌowaḏá háˀto Yôesi óehíhchannamí. ");
INSERT INTO tew_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Hewänbo Yôesiví Pꞌoewa̖a̖hâ̖a̖ taˀgendi unbí píˀnä́ khóˀyé únthaaḏá háa i natû̖ˀ waagi úvíkanhûuwí, háa íwänpidaˀ waagiḏa̖ˀbá yoe. Wí toˀwí iví píˀnä́ khóˀyé i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ Christ-di ônsandiˀ imáapíḏá Christ-vîˀ wínamuupí. ");
INSERT INTO tew_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Hewänbo tobá unbí tꞌaywó̖ˀdi únmuuḏi unbí túuˀú únchúwí wänboˀ, Christ unbí píˀnä́ khóˀyébo bînmáaḏá i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi wówátsi nahándepíˀin wovâymäˀ, gá Yôesi Táḏáḏí wovâycha̖a̖máaḏân tꞌaywó̖ˀdi wívînmáapí waagibá. ");
INSERT INTO tew_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yôesi Táḏáḏí Jesus óewáywówápaa, heḏi iví Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ unbí píˀnä́ khóˀyé únthaaḏá, i Táḏáḏíbá undá wíyá wovâywówápaa-í, Christ Jesus óewáywówápaa waagibá. Tobá unbí túuˀú únchuu wänboˀ, Yôesiví Pꞌoewa̖a̖hâ̖a̖ unbí píˀnä́ khóˀyé únthaaḏi Yôesiḏi wówátsi wovâymä̂äní. ");
INSERT INTO tew_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Heḏiho tíˀûuwin páaḏéˀin, nää-á hä̖ä̖wí giphaamuu waagibá hä̖ä̖wí híwó̖ˀdi gínkhâyˀä̖ˀ ívíˀa̖míˀin, háa giwänpidaˀ waagiḏa̖ˀbá yoe. ");
INSERT INTO tew_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Háa íwänpidaˀ waagiḏa̖ˀ unbí wówátsi bînhondá íchuu-í. Hewänbo i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ úvímä́giḏáho wovâykhä̖ge̖ˀnamíḏí i tꞌaywó̖ˀdi unbí túuˀúḏí úvíˀoˀi bînyâaˀa̖míḏí, kindiḏânho in taˀgennin wówátsi bînkéyí. ");
INSERT INTO tew_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Tꞌä̖hkí in toˀwên Yôesiví Pꞌoewa̖a̖hâ̖a̖ḏi ovâypahonnindá Yôesiví ây dimuu. ");
INSERT INTO tew_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Yôesiví Pꞌoewa̖a̖hâ̖a̖ bînkêˀ ihayḏá pantꞌôeˀin dikhuwôedaˀin waagiˀin wíˀímuupí, páaḏéḏí ícha̖a̖ waagibá. Hewänbo i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi wovâyséegíhógi Yôesi Táḏáví ây ímúníḏí, heḏânho Yôesivíˀpiyeˀ úvíyûusuˀoˀ ihayḏá wí̖ˀínbo bînkhá̖yä̖́ˀní “Naví Táḏá” gin. ");
INSERT INTO tew_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","I Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏânho naˀinbí píˀnä́ khóˀyé díhanginˀândoˀ Yôesi Táḏáví ây gimuu gin. ");
INSERT INTO tew_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Heḏi iví âyho gimuuḏi i hä̖ä̖wí iví âygîˀ iwiyekwꞌóḏiˀiˀ âyhóní. Christ-áḏí wé̖ˀge nä́ˀi hä̖ä̖wí âyhóní. Christ-víˀin gimuuḏibo âytꞌôephaḏendeˀ i itꞌôephaḏe waagibá, heḏiho i-áḏíbá Yôesi Táḏáḏí heˀennin dípaa-í. ");
INSERT INTO tew_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nä́ˀi saˀwó̖ˀdi hä̖ä̖wí Yôesiḏi dînkhâymáa i̖ˀgeḏi dáyˀánshaamáaḏí, naa ochanpoˀ nä́ä oepáa kꞌayḏiwi tꞌôephaḏe-á hä̖́ä̖bo wínamuupí waagibá. ");
INSERT INTO tew_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Hä̖ä̖ tꞌä̖hkí nakhíˀyendi-á nawóˀonpoˀḏi natsíkha Yôesi Táḏá ikeekwꞌôeníḏí naˀin taˀgendi iví ây gimuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","21","Yôesi Táa iˀánshaamä́gi hä̖ä̖wí tꞌä̖hkí nakhíˀyendiˀ nachä̖ˀmuupí waagibá napúwíˀin. Nä́ˀi hä̖ä̖wí wíˀbo kin waagi wínapuwagítꞌóepí, hebo Yôesi-ân natú̖ kin napúwíˀin. Hewänbo wáˀ natú̖ nä́ˀi hä̖ä̖wí nakhíˀyendibá wíyá híwó̖ˀdi napúwí heḏânho wínakhanmú-ípíḏí. Kindiḏi owáy Yôesi Táḏáví ây chuwa iweḏi dimaˀpꞌä̂ndi hä̖ä̖ tꞌä̖hkí saˀwó̖ˀ ingîˀ dínpóeḏí, nä́ˀi hä̖ä̖wí nakhíˀyendi-á wáˀ hanbá napúwí. ");
INSERT INTO tew_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nä́ˀi gínhanginná, wí kwee naˀeyehayḏi ûnhaytû̖ˀ waagibá, nä́ˀi hä̖ä̖wí tꞌä̖hkí nakhíˀyendi-á wáˀ han waagibá napoˀ, waˀḏi wíyá tsꞌa̖a̖bi wínakhíˀyenpíḏí. ");
INSERT INTO tew_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Heḏi kin waagi wíˀûnpoˀpí nä́ˀi hä̖ä̖wí nakhíˀyendiḏa̖ˀ. Naˀin wänbo gínhaytû̖ˀ waagibá gínpoˀ, giwóˀonpoˀḏi gitsíkhakwꞌôndi Yôesi Táḏá ikeeya̖míḏí naˀin iví ây gipúwíḏí díséegíhógiˀin, heḏá naˀinbí túuˀú tsꞌa̖a̖bi dînpáa-íḏí wáˀ gitsíkhakwꞌó̖. Heḏi dînkeeya̖míḏí han dînkhâymáaˀin, iḏi i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ naˀin dímä́gi. ");
INSERT INTO tew_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Yôesiḏi dînˀaywon dihayḏi waabo nä́ˀi napúwíḏí ívítsíkhahon. Wí toˀwí wí hä̖ä̖wí itsíkhaˀmáaˀi ho ikêˀḏáhoˀ, heḏáho waˀḏi wínatsíkhapí. Háaḏan wí toˀwí wíyá itsíkhaˀa̖mí wí hä̖ä̖wí ho ikêˀḏi? ");
INSERT INTO tew_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Hewänbo hä̖ä̖wí âykêˀpîˀ waˀḏi âytsíkhaˀmáaḏáhoˀ, nakhâyˀä̖ˀ giboˀatä̖́-íˀin tobá wóˀondi âytsíkhaˀmáa wänboˀ. ");
INSERT INTO tew_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Heḏá wáˀ kay gíntáyḏí i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏá díkhä̖ge̖ˀdoˀ. Kaypíˀin gimuuḏi wáyyéḏí wígiyûusuhá̖hpí, heḏi i híˀ wíˀâyshaaḏepíḏí gínwänpihaytû̖ˀ. Hewänbo kin gínpoˀḏi, naˀinbí haytu̖u̖ iweḏiboˀ i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏá naˀingîˀ Yôesi Táḏá óehéeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Yôesi Táḏá-á ûnhanginná hä̖ä̖wí naˀinbí píˀnä́ khóˀyé gínkwꞌó̖ˀdiˀ, heḏiho ûnhanginná háa i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ natu̖ˀdaˀin, gá Yôesi Táḏá nadaˀ waagi i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖-á Yôesi Táḏáví tꞌowagîˀ iyûusuˀoḏân. ");
INSERT INTO tew_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Nä́ˀi wáˀ gínhanginná: Tobáháa napoˀ wänboˀ, nä́ˀi hä̖ä̖wí napoˀiḏiho Yôesi-á híwó̖ˀ ikhâymáa in toˀwên i óeséegíˀingîˀ, innânkun ivíˀin ûnmúníḏí ovâytu̖kánnan, iˀánshaamä́gi waagi. ");
INSERT INTO tew_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Hä́nˀoebo ûnhanginná toˀwên dimúníˀin in ivíˀin ûnpuwagítꞌóeˀin, heḏi iwéhpêeˀan indá iví ay Jesus ûnmuuˀi waagibá dipúwíˀin. Kindiḏiho Jesus wí páˀḏây waagibá namúní heḏá naˀindá báyékí tíˀûuwin waagiˀinbá-á. ");
INSERT INTO tew_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","In toˀwên ha̖ˀmin dipúwíˀin Yôesi Táḏá iwéhpêeˀan dimuuˀindá iḏi ovâytu̖kánnan ivíˀin ûnmúníḏí, heḏi ivíˀin ûnmúníḏí ovâytu̖kánnandá natú̖ tꞌaywó̖ˀdi wíḏâymáapíˀin waagiˀin dimuu, heḏi nä́ˀin tꞌaywó̖ˀdi wíḏâymáapíˀin waagiˀin dimuuˀin ovâytu̖ˀannindá heˀennin ovâypáa-í, háa Jesus namuu waagibá. ");
INSERT INTO tew_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Heḏânkun, nä́ˀi hä̖ä̖wí tꞌä̖hkí i̖ˀgeḏi gínhanginnândi, nää-á taˀgendi nä́ˀin gínkoeḏi gitú̖níḏí: Yôesi Táḏá-á naˀinbíˀnäpiyeˀ namuuḏiho toˀwíḏí wänbo háˀto dítꞌaaní. ");
INSERT INTO tew_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Yôesi Táḏá-á wínakhâ̖a̖póepíḏí iví ay Jesus imä́gi naˀin tꞌowa tꞌä̖hkígîˀ nachúu-íḏí. Heḏi kin iˀandânkun, nakhâ̖a̖píḏí tꞌä̖hkí wé̖ˀgeˀi híwó̖ˀdi hä̖ä̖wí wáˀ taˀgendi dímä̂äní. ");
INSERT INTO tew_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Yôesi Táḏá-ân namuu i natû̖ˀdiˀ in toˀwên ovâyde̖ˀmannindá tꞌaywó̖ˀdi wíḏâymáapíˀin waagiˀin dimuu, heḏânho toˀwí wänbo wíˀûnkoeḏipí taˀgendi dîntꞌaywó̖ˀdichä̖nú-íˀin. ");
INSERT INTO tew_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Heḏiho toˀwí wänbo wíˀûnkꞌóepí natú̖níḏí naˀinbí tꞌaywó̖ˀdi gínmuuḏi gínkhâyˀä̖ˀ dítuchä̖nú-íˀin, gá Christ naˀin gimuuḏi nachuuḏân, heḏá wíyá shánká hä̖ä̖wí-á iˀan, i-á nawáywówápóe-á, heḏi nää-á Yôesi Táḏáví koˀḏínäḏá naˀä́n, heḏi iweḏi naˀingîˀ dînyûusuˀoḏiho Yôesi Táḏá dîndaˀmáa. ");
INSERT INTO tew_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Christ-di díséegíḏí toˀwíḏí wänbo háˀto díwiyé-í ivíˀweḏi, tobá âytꞌôephaḏende wänboˀ, háa sehkanäwó̖ˀ naˀinbí thaa gínmuu wänboˀ, háa naˀinbí whä̖yu̖ gínmuuḏi tꞌowaḏi díyanäkíˀo wänboˀ, háa koegîˀ-á awegîˀ-á gíntáy wänboˀ, háa díwha̖ˀa̖míˀindá dítꞌa̖há̖nú-íˀindá tꞌowa didaˀ wänboˀ. ");
INSERT INTO tew_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kin gínpoˀ háa Yôesiví ta̖ˀnin diwe nata̖ˀmuu waagi: Naˀinbí Sedó Yôesi, uvíˀin gimuuḏibo naˀindá hä̖̂ä̖ḏi wänbo tꞌä̖hkí dítꞌa̖kha̖nukhâyˀoˀ. Wên kꞌúwá ovâytꞌa̖há̖nú-íˀin gimuu waagi tꞌowaḏi dímáa. ");
INSERT INTO tew_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Hewänbo tobáháa nä́ˀi tꞌä̖hkí gínpoˀ wänboˀ, wéngéḏí wänbo wíḏítꞌaanípí, hewänbo naˀindáho gitꞌanpoˀ, gá Christ i díséegíˀi namuuḏân, heḏi díkhä̖ge̖ˀdoˀ. ");
INSERT INTO tew_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","Naa dáykoeḏiwhä̖yunde hä̖ä̖wíḏí wänbo háˀto díwiyé-í Yôesi Táḏáví séegí iweḏi, nä́ˀi séegí-á Jesus Christ naˀinbí tsondi hayˀi gínmuuˀiḏi dímä́gi. Tobá giwówáyiḏi háa gichuu wänboˀ, háˀto iweḏi giwiyeḏée-í. Makówáwin tꞌôepa̖ˀa̖a̖ˀindi wänbo háˀto iweḏi díwiyé-í, háa pꞌoewa̖a̖hâ̖a̖ví tsonnindi heḏiháa wáy wíyá toˀwí tsonkhuu imáaˀiḏi. Tobáháa napóe wänbo nää háa páaḏépiyeˀ gimän diwe, háa hä̖ä̖wí oepáa kwꞌáye heḏiháa nansoge núugé naˀä́ndiḏi, háa wáy wíyá hä̖ä̖wí nakhíˀyendiḏi háˀto iví séegí iweḏi díwiyé-í. ");
INSERT INTO tew_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Naa háa otu̖gítꞌóeˀindá taˀgen namuu, naa wíḏáyhôeyómáapí, gá Christ-vîˀ omuuḏân, heḏá i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏá naví píˀnä́ khóˀyé donmáaḏí díhanginˀândo taˀge dáyhíˀmáaˀin. ");
INSERT INTO tew_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","3","Naa hânho okꞌáykháa, heḏá naví píˀnä́ khóˀyé hä̖̂ä̖ḏi wänbo tꞌä̖hkí otaachanpoˀ dáyˀánshaamáaḏí naví tꞌowaví̖ˀgeḏi, indá nää oepáa kꞌayḏi naví maatuˀin dimuu. Híhchangiḏi Christ-víˀweḏá owiyeḏée-í, kin naa dînpóeˀindi ovâykhä̖ge̖ˀnamíḏáhoˀ. ");
INSERT INTO tew_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Indá Israel-ví ây iweḏiˀinbá dimuu, heḏi Yôesi Táḏáḏí ovâyhógi iví sówéˀây waagiˀinbá dimúníḏí, heḏá iḏá iví saˀwó̖ˀdi kohthay ivíˀweḏi ûnˀä̖ˀiˀ ovâykeeyan. Háa iwéhpêeˀannin in Israel-ˀinbá ovâytu̖ˀan, heḏá iví tsontu̖u̖-á ovâymä́gi. Ovâyyéye háa óeˀaˀginmä̂äníḏí, heḏá háa ovâykhâymáaˀin ovâytu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","In hä́nˀoeˀin seˀdaa-á nä́ˀin Israel-ˀinbí thehtáy pahpáˀin dínmuu, heḏi Christ natꞌowapaa ihayḏi inbíˀweḏiˀibá namuu. I-á Yôesi namuu, i-á tꞌä̖hkí itsonmáa, heḏi tꞌowa dínkhâyˀä̖ˀ hä̂nhay wänbo tꞌä̖hkí óetége̖ˀbé-íˀin. Hamân. ");
INSERT INTO tew_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Hewänbo naa okꞌáykháa gá tobá nä́ˀi tꞌä̖hkí dâymáa wänboˀ, Yôesi-áḏí wíḏimuupíḏân. Naa wóˀtû̖ˀpí Yôesi Táḏá-á wíˀiˀaˀginpíˀin iví tu̖u̖ imä́giˀin, hewänbo kinnân napoˀ: Báyékí in Israel-ví ây iweḏiˀindá koḏi̖ˀnin Israel-ˀin wíḏimuupí, ");
INSERT INTO tew_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","heḏá wáˀ tꞌä̖hkí in Huḏíyo iweḏiˀindá Abraham-bí koḏi̖ˀnin ây iweḏiˀin wíḏimuupí iví tûu ûnpꞌoe diwänpimuuḏiboˀ, hewänbo kinnân Yôesi Táḏáḏí óetu̖ˀan Abraham: Uví ay Isaac ú̖muuˀiví ây iweḏiˀinda̖ˀmânho taˀgendi uví tíˀúugé kä̖ˀä̖ä̖ˀin kin ovâytu̖ˀâ̖a̖mí. ");
INSERT INTO tew_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nä́ˀi híˀ kinnân natu̖ˀdaˀ: Tꞌä̖hkí Abraham-bí tûu ûnpꞌoe-á Yôesi Táḏáví ây wíḏimuupí, hewänbo in toˀwên háa Yôesi Táḏá iví tu̖u̖ imä́gi waa diˀâypu̖yä̖ˀin, inbí̖ˀgeḏiḏa̖ˀmân gitú̖ní taˀgendi Abraham-bí ây iweḏiˀin dimuu. ");
INSERT INTO tew_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kinnânho Yôesi Táḏáḏí iví tu̖u̖ Abraham óemä́gi háa ônkhâymáaˀin: Wí pa̖a̖yo nää iweḏi uvíˀpiyeˀ owáyˀä̖ä̖-í, heḏi ihayḏá uví kwiyó Sarah wí enúkáy ho iˀaypu̖yä̖khâymáa. ");
INSERT INTO tew_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","12","Hebo Yôesi wíyá shánkí natú̖. Rebecca-ḏi wên kwâati ovä̂nˀayyan, heḏi in áyyä̖̂ä̖-á wîˀḏa̖ˀ táḏá dä́nmuu, i-á naˀinbí thehtáy pahpâa Isaac namuu, Abraham-bí eˀnú. Hewänbo waˀḏi in áyyä̖̂ä̖ daˀaypu̖yä̖píḏíboˀ, waˀḏi háawên dänˀanpíḏíboˀ, háa híwó̖ˀdi háa híwó̖ˀpîˀ, Yôesiḏi Rebecca kinnân óetu̖ˀan: I páaḏéˀi-á i tíˀúugéˀigîˀ itꞌôeˀa̖mí. Heḏi Yôesi-á kin iˀan nahanginpúwíḏí i-ân namuu tꞌowa ovâyde̖ˀboˀiˀ, háawên dívíˀannin namuuḏiḏa̖ˀbá yoe, hewänbo iḏânho toˀwên napidaˀin ovâyde̖ˀboḏân. ");
INSERT INTO tew_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Yôesi Táḏá-á iví ta̖ˀnin diwe kinnân natû̖ˀ: Jacob-á dóde̖ˀman, hewänbo iví páˀḏây Esau-á dóyoegiˀan. ");
INSERT INTO tew_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","15","Heḏân ti gitú̖ní Yôesi Táḏá-á taˀge wíˀiˀopí wí toˀwí óede̖ˀboḏi heḏá wíyá toˀwí óeyoegiˀoḏá? Heḏân yoe. I-áho ûnkoeḏi kin iˀa̖míḏí, heḏiho Moses óetu̖ˀan, Toˀwívíˀpiyeˀ naa odaˀi-áho oˀiyapúwí, toˀwívíˀpiyeˀ osehkanäkandaˀi-áho dósehkanäˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Heḏânkun Yôesiví iya ûnmuuḏibo wí toˀwí ide̖ˀboˀ, nä́ˀi toˀwí óede̖ˀmamíˀin nawänpidaˀḏibo-á yoe, háa isóˀḏíndeḏibo-á yoe. ");
INSERT INTO tew_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Yôesi Táḏáví ta̖ˀnin diwá ûnta̖ˀmuu háa iḏi i Egypt-wi tsondi hayˀi óetu̖ˀan waa, kinnân: Naaḏi wînkꞌûˀ untsoncha̖ˀníḏí heḏânho háa wíkhâymáaˀin namuuḏi naví kay dînmuuˀin donkeeya̖míḏí, heḏá nä́ä oepáa kꞌayḏi tꞌä̖hkí tꞌowa háawi naa omuuˀin dínhanginnání. ");
INSERT INTO tew_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Heḏânkun Yôesi háa nadaˀ waa iˀoḏi wáy wênbíˀpiyeˀ naˀiyapoˀ, heḏá wây-á wêndá tꞌóyanpíˀin dimúní gin ovâykannan. ");
INSERT INTO tew_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Maˀḏi wí toˀwíḏí dítsikáyi̖ˀní naa, “Haˀwâagi Yôesi iˀoḏá háaḏan iḏi in tꞌowa ovâytꞌeˀpꞌíḏéndeˀ? Tóebo wíˀûnkoeḏipí Yôesi óekhâ̖a̖ˀa̖míḏí iˀa̖míḏí háa nadaˀ waagi.” ");
INSERT INTO tew_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Hewänbo naaḏá i kin natû̖ˀdi kinnân dótu̖ˀa̖mí: “To-an unmuu Yôesi nâatu̖whä́nnamíḏí, tꞌowaˀayḏa̖ˀ unmuuḏi? Ti wí natꞌúḏí ûnkꞌóe i natꞌúpaˀiˀ óetu̖ˀâ̖a̖míḏí, ‘Wíˀú̖khâyˀä̖hpí háa omuu waagi naa dípaa-íˀin’? Heḏân yoe. ");
INSERT INTO tew_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","I natꞌúpaˀi-á ûnkꞌóepíˀan i píˀîndi hä̖ä̖wí nadaˀiˀ ipáa-íḏí. Nä́ˀi píˀîn diweḏiboˀ ûnkoeḏi wên natꞌú saˀwó̖ˀgíˀinda̖ˀ ipáa-íḏí, heḏá wây-á hä̖ä̖háakangíˀindá.” ");
INSERT INTO tew_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Heḏânho Yôesi Táḏá wáˀ ûnkꞌóe kinnân iˀa̖míḏí: Tobáháa nadaˀ wänbo ikeeya̖míˀin hânho natꞌayˀin tꞌowaví tꞌaywó̖ˀdi dínmuuḏi, heḏá iví kay ûnmuuˀin âytáa-íˀin nadaˀ wänbo-á, owáy oeḏi i-á naboˀatä̖́ḏí itsíkhaˀoˀ ovâytuchä̖nú-íḏí in toˀwên inbí tꞌaywó̖ˀdi dínmuuḏi natꞌayḏi, inbáhoˀ ovâyhá̖nú-íˀin dínkhâyˀä̖ˀ. ");
INSERT INTO tew_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Heḏá wáˀ nadaˀ in toˀwên iví iya ônhógiˀin ovâyhanginˀânnamíˀin háa hayˀi i namuuˀin, inbá páaḏéḏíboˀ ovâyde̖ˀman báyékí híwó̖ˀdi hä̖ä̖wí dâyhóníḏí. ");
INSERT INTO tew_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Heḏi naˀinnân gimuu in Yôesi Táḏáḏí dítu̖kánnannin iví iya âyhóníḏí. Wáy wêndá Huḏíyo gimuu, hewänbo wây-á wígimuupí. ");
INSERT INTO tew_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kinnân Yôesi Táḏá natú̖, heḏi Hosea-á hä́nˀoe ita̖ˀnan: In toˀwên naví tꞌowa dînmuupíˀindáho naaḏi dovâytu̖ˀa̖mí naví tꞌowa gin. In toˀwên naaḏi wíḏovâyséegípíwän, indá nää-á in toˀwên dovâyséegí gin dovâytu̖ˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Heḏi wáy Yôesiḏi wáymûu ovâytu̖ˀan diwe, “Undá naví tꞌowa wíˀímuupí” gin, iwebáho nää-á ovâytu̖ˀâ̖a̖mí “Yôesi i nawówáyiˀiví ây” gin. ");
INSERT INTO tew_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Heḏá hä́nˀoe Isaiah-á in Israel tꞌowaví̖ˀgeḏi kaygi̖ˀdi natú̖: Tobáháa in Israel-win tꞌowa hânho báyékí diyi wänboˀ, hä̖́yú̖ okhá̖ i mâapꞌoe kꞌáygé i̖ˀge nakwꞌó̖ˀ dihaybá, wên hä̖́yú̖ḏíḏa̖ˀ ovâyˀaywoení, ");
INSERT INTO tew_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","gá Naˀinbí Sedó Yôesi-á wínahayyêepúwípíḏí iví tuchä̖nu ibowá-íḏí nä́ä oepáa kꞌayḏi, háa natú̖ waagi. ");
INSERT INTO tew_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Isaiah wáˀ natú̖ kinnân napúwí gin: Naˀinbí Sedó i hä̖ä̖wí tꞌä̖hkí itsonmáaˀi namuuˀiḏi wên tíˀúugé kä̖ˀä̖ä̖ˀin dînyoeˀanpíḏá, gihá̖a̖níwän in tꞌowa Sodom búuˀúwindáḏí Gomorrah-windáḏí tꞌä̖hkí dihán waagibá. ");
INSERT INTO tew_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Heḏiho háa otsꞌantú̖ waa kinnân natu̖ˀdaˀ: In tꞌowa Huḏíyo dimuupíˀin dívíwhä̖yundeḏi dipóe in toˀwên Yôesi Táḏáḏí ovâycha̖a̖máaˀin tꞌaywó̖ˀdi wíḏâymáapí waagi, tobáháa háḏíḏí ki̖ˀmin dipúwíˀin dâytu̖wä̖máapí wänboˀ. ");
INSERT INTO tew_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Hewänbo in Israel-ˀindá dâynuwände háḏíḏí tꞌaywó̖ˀdi wíḏâymáapíˀin waagiˀin dipúwíˀin, hewänbo wíḏâyshaaḏepí. ");
INSERT INTO tew_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","33","Heḏi háaḏan wíḏâyshaaḏepí? Gá dívíwänpiwhä̖yú̖-ívíˀweḏi dívíkhä̖ä̖ḏeḏân híwó̖ˀ dívíˀa̖míḏí heḏânho Yôesiḏi ovâycha̖a̖máˀve-íḏí tꞌaywó̖ˀdi wíḏâymáapí waagi. Wí kꞌuu Yôesi Táḏáví ta̖ˀnin diwe i̖ˀgeḏi nata̖ˀmuuˀiˀ iwe dipꞌíḏeḏi dikanu waagibá dínpóe. Kinnân natû̖ˀ: Bítꞌóyan, oe Zion búuˀú iwe wí dósóge. I-á wí kꞌuu waagiˀbá namuu, tꞌowa iwe dipꞌíḏeḏi dikanundeˀ, hewänbo toˀwên ivíˀpiyeˀ dívíwhä̖yundeˀindá háˀto dichanpúwí híwó̖ˀpîˀpiyeˀ dívíwhä̖yundeˀin. ");
INSERT INTO tew_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Tíˀûuwin páaḏéˀin, pín taˀge hayḏi Yôesi Táḏá dódaˀmáa naví tꞌowa in Israel-ˀin dimuuˀin ovâyˀaywoeníḏí. ");
INSERT INTO tew_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Taˀgendi wâytu̖máa, indá hânho didaˀ Yôesi óehíhchanmä̂äníˀin, hewänbo piháa dívísóˀḏínde dívíˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ho wíḏínhanginnáhpí háa Yôesi iˀoˀin heḏânho iḏi tꞌowa ovâycha̖a̖máˀve-íḏí tꞌaywó̖ˀdi wíḏâymáapí waagi, heḏiho indá dâytu̖wä̖máa háḏíḏí ha̖ˀmin wíˀbo dívípipáa-íḏí, heḏiho háa Yôesiḏi kin ovâyˀa̖míˀin wíḏâyhóndepí. ");
INSERT INTO tew_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Nääho tꞌä̖hkí in toˀwên Christ-víˀpiyeˀ dívíwhä̖yundeˀindá wíyá ho wíḏíntáypí dívísóˀḏêe-íḏí i tsontu̖u̖ dâyˀaˀginnamíḏí heḏânho dipúwíḏí in toˀwên Yôesi Táḏáḏí ovâycha̖a̖máaˀin tꞌaywó̖ˀdi wíḏâymáapí waagi. ");
INSERT INTO tew_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","In tꞌowa dívísóˀḏíndeˀin Yôesiví tsontu̖u̖ dâyˀaˀginnamíḏí heḏânho Yôesiḏi ovâycha̖a̖máˀve-íḏí tꞌaywó̖ˀdi wíḏâymáapí waagi, inbí̖ˀgeḏi Moses kinnân ita̖ˀnan: Wí toˀwí tꞌä̖hkí Yôesiví tsontu̖u̖ iˀaˀgindoˀi-á wówátsi imáˀve-í. ");
INSERT INTO tew_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Hewänbo kinnân nata̖ˀmuu in toˀwênbí̖ˀgeḏi inbí whä̖yu̖ dínmuuḏi Yôesiḏi ovâycha̖a̖ˀin tꞌaywó̖ˀdi wíḏâymáapí waagi: Wíˀítú̖nípí, “Toˀwí ûnkhâyˀä̖ˀ makówápiyeˀ napée-íˀin.” (Nä́ˀindá natu̖ˀdaˀ, Christ óedaaˀa̖míḏí makówáḏí nawha̖veˀä̖́ä̖-íḏí.) Heḏá wáˀ nata̖ˀmuu: ");
INSERT INTO tew_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Wíˀítú̖nípí, “Toˀwí ûnkhâyˀä̖ˀ in chuˀin dikwꞌó̖ˀ diwepiyeˀ nawhá̖níˀin.” (Nä́ˀindá natu̖ˀdaˀ, in chuwaˀinbíˀweḏi Christ óetegé-íḏí óewówápaa-íḏí.) ");
INSERT INTO tew_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Hewänbo kinnân nata̖ˀmuu: Yôesiví tu̖u̖-á undáḏího nayiˀ, unbí sóeḏí ítú̖ní heḏi unbí píˀnä́ khóˀyé-á bînmáa. Heḏi nä́ˀi tu̖u̖ whä̖yu̖ i̖ˀgeḏi namuuˀi-á tꞌowa âytꞌôeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Heḏânkun tꞌowaví páaḏépiyeˀ ítú̖ḏí Jesus-á i shánkí natsonyiˀi namuuˀin, heḏá Yôesi Táḏáḏí wíyá óewáywówápaaˀindá unbí píˀnä́ khóˀyé-á úvíwhä̖yundeḏi, wovâyˀaywoení, ");
INSERT INTO tew_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","gá naˀinbí píˀnä́ khóˀyé Jesus-víˀpiyeˀ ívíwhä̖yundeḏá Yôesi Táḏáḏí dícha̖a̖máa tꞌaywó̖ˀdi wíˀâymáapí waagi, heḏi ivíˀpiyeˀ ívíwhä̖yundeˀin gitú̖ḏá, dînˀaywoení. ");
INSERT INTO tew_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Yôesiví ta̖ˀnin diwá ûntû̖ˀ, In toˀwên ivíˀpiyeˀ dívíwhä̖yundeˀindá háˀto dichanpúwí híwó̖ˀpîˀpiyeˀ dívíwhä̖yundeˀin. ");
INSERT INTO tew_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Tꞌä̖hkí tꞌowagîˀ handa̖ˀ napoˀ, in Huḏíyogíˀindá, in Huḏíyo dimuupíˀingíˀindá wáˀ, gá tꞌä̖hkí tꞌowagîˀ wîˀḏa̖ˀ wí shánkí natsonyiˀi naˀä́ndân, heḏi iḏá báyékí híwó̖ˀdi ovâymäˀ in toˀwên ivíˀpiyeˀ dívíyûusuˀannin ovâykhä̖ge̖ˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Yôesiví ta̖ˀnin diwá ûntû̖ˀ waagi: Toˀwên i shánkí natsonyiˀivíˀpiyeˀ dívíyûusuˀandi diˀaywondaˀpóeḏí iḏá ovâyˀaywoení-ákun. ");
INSERT INTO tew_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Hewänbo háḏíḏan ivíˀpiyeˀ kin dívíyûusuˀa̖mí ivíˀpiyeˀ wíḏívíwhä̖yundepíḏí, heḏá háḏíḏan dívíwhä̖yú̖-í iví̖ˀgeḏi wíḏínhanginnáhpíḏí, heḏá háḏíḏan dínhanginpúwí toˀwíḏí iví tu̖u̖ wíˀovâytꞌôeˀanpíḏí, ");
INSERT INTO tew_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","heḏá háḏíḏan wí toˀwíḏí ovâytꞌôeˀa̖mí Yôesiḏi wíˀóesanpíḏí? Kinnân Yôesiví ta̖ˀnin diwe nata̖ˀmuu: In toˀwên wí híwó̖ˀdi tu̖u̖ dâymáyä̖ˀinbí a̖htaa-á saˀwó̖ˀ dínkeetꞌóe. ");
INSERT INTO tew_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Hewänbo Isaiah natú̖ waagibá, tꞌä̖hkí in Huḏíyo Yôesiví híwó̖ˀdi tu̖u̖ wíḏâyséegíˀanpí. Kinnân ita̖ˀnan: Naˀinbí Sedó Yôesi, wên hä̖́yú̖hayḏiḏa̖ˀ tꞌowa i hä̖ä̖wí navíˀweḏi ditꞌoeˀiˀ dívíwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Heḏânkun Yôesivíˀpiyeˀ ívíwhä̖yú̖-íḏí, gíntáy iví tu̖u̖ gitꞌóe-íḏí, heḏá nä́ˀi tu̖u̖-á gitꞌoˀ wí toˀwíḏí Christ-ví̖ˀgeḏi dítꞌôeˀoḏi. ");
INSERT INTO tew_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Héyâa in Israel-ˀin, ti Yôesiví tu̖u̖ wíḏitꞌoepíˀan? Ditꞌoe-ákun, Yôesiví ta̖ˀnin diwe ûntû̖ˀ waa: Yôesiví tu̖u̖-á nä́ä oepáa kꞌayḏi tꞌä̖hkí ûntu̖u̖mää, heḏiho tꞌowa tꞌä̖hkí wáyyé tꞌä̖hkí dikwꞌó̖ˀnin nä́ˀi tu̖u̖ dínpówá. ");
INSERT INTO tew_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Heḏânkun in Israel-ˀin dínhanginnândákun háa Yôesi ikhâymáaˀin. Kin Moses páaḏé ita̖ˀnan háa Yôesiḏi ovâytu̖ˀan waa: Wây-á piˀwên tꞌowa dimuuˀin naaḏi dovâyˀaywondibo wâythúukannamí, Háa hä̖ˀin tꞌowa hangintan dâymáapíˀingîˀ dovâykhâymáaˀin namuuḏi wâytꞌeˀyaˀnamí. ");
INSERT INTO tew_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Heḏá Isaiah-á shánkí kayˀindá ihíˀmáaḏí nä́ˀi Yôesiví híˀ ûntú̖: In toˀwên naa wíḏítu̖wä̖máapíˀindi naa díshaa. Inbíˀpiyeˀ dáykeeyan, naví̖ˀgeḏi ditsikayipí wänboˀ. ");
INSERT INTO tew_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Hewänbo in Israel tꞌowaví̖ˀgeḏi Yôesi kinnân ihíˀmáa: Hä̖̂ä̖ḏi wänbo tꞌä̖hkí okhóewaaˀä́n nä́ˀin tꞌowa dovâyséegíˀa̖míḏí, tobá wíḏíˀaˀginmáapí wänboˀ heḏá naví tu̖u̖ dînyoegiˀo wänbo-á. ");
INSERT INTO tew_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Heḏiho ti giˀâ̖a̖ní Yôesi Táḏá iví Israel-ˀin tꞌowa iyoegiˀannin? Heḏân yoe. Naa wáˀ Israel-wibá omuu, naa-á Abraham-bí ây iweḏiˀibá omuu, heḏá Benjamin-bí tꞌowa iweḏiˀbá omuu. ");
INSERT INTO tew_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Heḏiho Yôesi-á iví tꞌowa wíˀiyoegiˀanpí, indá hä́nˀoebo ûnhanginná ivíˀin ûnmúníˀin. Taˀgendi un únhanginnáhpíˀan háa iví ta̖ˀnin diwe Elijah-ví̖ˀgeḏi ûntû̖ˀnin. Elijah-ḏi in Israel-ˀinbí̖ˀgeḏi Yôesi óehíˀmáaḏí kinnân ovâytꞌeˀpꞌíḏe: ");
INSERT INTO tew_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Naˀinbí Sedó, tꞌä̖hkí in wé̖ˀgeˀin uví tukhe̖ˀmin wôntꞌa̖há̖nú, heḏá tꞌä̖hkí uví antâa-á wônnayu̖. Naaḏa̖ˀmân oteˀḏee, heḏi tꞌowa háḏíḏí naa díhéyíˀin ditu̖wä̖yiˀ. ");
INSERT INTO tew_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Heḏi kinnân Yôesiḏi óetu̖ˀanpíˀan: Tsé maapaasôn (7,000) ihay senäˀ dovâyˀá̖yîngimáa heḏi waˀḏi navíˀnäpiyebo dimuu, indá Baal-ví páaḏépiyeˀ wíḏívídéˀgendikwꞌóḏipí óeˀaˀginmä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nää waˀḏi hanbo napoˀ. Yôesi-á naséegísehkanätꞌóeḏí waˀḏi wên hä̖́yú̖ hayḏi Israel-ˀin Yôesiḏi ovâyde̖ˀmannin dikwꞌôn. ");
INSERT INTO tew_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Hewänbo iví séegísehkanä ûnwänpimuuḏibo Yôesiḏi ovâyde̖ˀman, hä̖ä̖wí híwó̖ˀdi dívíˀandiḏiḏa̖ˀbá yoe. Heḏi hä̖ä̖wí híwó̖ˀdi indá dívíˀandiḏibo iḏi ovâyde̖ˀmandáhoˀ, háˀto iví séegísehkanä ûnmuuˀiḏiḏa̖ˀ ovâyde̖ˀmamíwän. ");
INSERT INTO tew_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Heḏiho kinnân napóe: Tꞌä̖hkí in Israel-win tꞌowa wíḏínhanginpóepí háḏíḏí dipúwíˀin in toˀwên Yôesiḏi ovâycha̖a̖máaˀin tꞌaywó̖ˀdi wíḏâymáapí waagi, hewänbo in toˀwên Yôesi Táḏáḏí ovâyde̖ˀmannindáho dínhanginpóe, heḏi in wé̖ˀgeˀindá tꞌóyanpíˀinda̖ˀ dipóe. ");
INSERT INTO tew_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Yôesi Táḏáví ta̖ˀnin diwá nä́ˀin wé̖ˀgeˀin tꞌowaví̖ˀgeḏi kinnân nata̖ˀmuu: Yôesiḏi inbí hangintan ovâypeḏeeˀan, heḏi tsée nakeetꞌóepîˀ-á, oeyay natꞌoˀpîˀ-á ovâymä́gi, heḏi nää thaa puˀwahay kinbo dínpoˀ. ");
INSERT INTO tew_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","David wáˀ hä́nˀoe inbí̖ˀgeḏibá natú̖, Báyékí hä̖ä̖wí dínkwꞌó̖ˀdibo diˀánde híwó̖ˀ dínpoˀin, hewänbo Yôesi dódaˀmáa nä́ˀi hä̖ä̖wí dínkwꞌó̖ˀdibá wên phay iwe diwhêeˀin waagibá dínpúwíḏí, háa hä̖ä̖wí iwe dipꞌíḏeḏi waagibá dínpúwí iwe dikanú-íḏí, heḏá iwebo inbí tuchä̖nu dínˀä̖ˀi-á dâyhóní. ");
INSERT INTO tew_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ditsíkhä̖mugíˀtꞌóe waagibá dínpúwí heḏânho wíḏínkeetꞌôenípíḏí, heḏá hä̖̂ä̖ḏi wänbo tꞌä̖hká inbí túuˀú-á dínbéˀgayní dínhéhkháaḏí waagibá. ");
INSERT INTO tew_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Heḏiho hânnan natu̖ˀdaˀ nä́ˀi otú̖ˀiˀ? Ti natu̖ˀdaˀ nä́ˀin Israel-ˀin tꞌowa dikanuˀin wíyá háˀto dikwi̖nuḏée-í waagibá dínpóe? Heḏân yoe. In Israel tꞌowaví tꞌaywó̖ˀdi dínmuuḏiho Yôesiḏi in Israel-ˀin dimuupíˀin tꞌowa-áho ovâyˀaywon, heḏi iweḏihoˀ in Israel-ˀin tꞌowa wáˀ hânho didáˀí hanbá dínpúwíˀin. ");
INSERT INTO tew_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","In Israel-ˀin tꞌowa peḏee iwe dipówáḏí Yôesivíˀweḏi dívíhângeˀan, hebo iweḏi tꞌä̖hkí in wé̖ˀgeˀin tꞌowa Israel-ˀin dimuupíˀin Yôesiví tu̖u̖ dâyhógi, heḏi handiḏân dikoḏitꞌowapaa waagiˀinbá dipóe. Heḏiho owáy in Israel-win dívíwhä̖yundeˀin shánkí báyékí dipóe ihayḏá, in wé̖ˀgeˀin tꞌowa-á wáˀ wíyá shánká híwó̖ˀ dínpúwí. ");
INSERT INTO tew_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Un Huḏíyo ímuupíˀin, nää-á undá wâyhíˀkhâymáa: Yôesi Táḏáḏí naa unbíˀpiyeˀ dísan, heḏiho naa ochanpoˀ naví tꞌôe-á báyékí dînˀaˀginmuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Hä̖ä̖wên naaḏi wâyˀoˀin namuuḏi, maˀḏi in toˀwên naa waagibá Israel-ˀin dimuuˀin wáˀ hânho didáˀí i tu̖u̖ un wâymäˀi dâyhóníḏí, heḏi kindiḏi wáy wên in wáˀ ovâyˀaywoení. ");
INSERT INTO tew_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Yôesi Táḏáḏí in Huḏíyo ovâyyoegiˀan dihayḏi iḏi in wé̖ˀgeˀin tꞌowa tꞌä̖mäpiyeˀ nä́ä oepáa kꞌayḏi dithaaˀin ovâykꞌemahógi. Heḏânkun owáy iḏi in Huḏíyo ovâywáyséegíˀan dihayḏá, shánkí wänbo híwó̖ˀ namúní, ihayḏá indá chuˀin diwáywówápóeˀin waagiˀinbá dimúní. ");
INSERT INTO tew_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","I páaḏéˀi pává dâywhahkêˀi Yôesi óemä́giḏá, tꞌä̖hkí i wé̖ˀgeˀi pává wáˀ ivîˀḏa̖ˀ ûnmuu. Heḏá i taypúu Yôesi óemä́giḏá, i waˀyáy khóe wáˀ ivîˀbá ûnmuu. ");
INSERT INTO tew_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","In Huḏíyo wên olive tay óekhä̖hkíḏiˀin waagiˀinbá dimuu, hewänbo wáy wên in diweḏi waˀyáy khóe dâytsꞌâˀi waagiˀinbá dimuu, heḏi un Huḏíyo ímuupíˀindá wên olive tay nawänpisôeˀinbí waˀyáy khóe waagiˀinbá-á ímuu, nä́ˀi waˀyáy dâytsꞌâˀi-á i wé̖ˀgeˀi waˀyáy-áḏí dâywänpitꞌihsaa, heḏiho i taypúu iweḏiwi taypꞌoeḏi i waˀyáy khóe dâytꞌihsaaˀi híwó̖ˀ nasôemän waagibá, nää-á hanbá hä̖ä̖wí in Huḏíyo iweḏi naˀä̖ä̖ˀiḏi híwó̖ˀ undá wáˀ únpoˀ. ");
INSERT INTO tew_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Heḏiho nää-á wíˀíˀâ̖a̖nípí i wé̖ˀgeˀi waˀyáyví shánkí híwó̖ˀnin ímuuˀin. Wíˀúvíyêngihéeˀa̖mípí, undá waˀyáy khóe waagiˀinda̖ˀ ímuuḏi, heḏiho nä́ˀi taypꞌoe wívînmähpí i taypúu nawówámúníḏí, i taypúuḏân un unbí wówátsi khóekhú̖u̖-á wovâymäˀ. ");
INSERT INTO tew_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Hewänbo maˀḏi wí Huḏíyo namuupîˀ-á kin natú̖ní, “I wé̖ˀgeˀi waˀyáy khóe-á óetsꞌâˀ heḏânho naˀin dítꞌihsáa-íḏí.” ");
INSERT INTO tew_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Nä́ˀindá taˀgen namuu. In Huḏíyo ovâytsꞌâˀ gá Christ-víˀpiyeˀ wíḏívíwhä̖yu̖píḏân, heḏi undá unbí whä̖yu̖ únmuuḏi wovâytꞌihsaa. Hewänbo úvíyêngihíˀmáˀve-ívíˀweḏi únkhâyˀä̖ˀ hânho úvíˀá̖yîngiˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Yôesiḏi in Huḏíyo ovâytuchä̖nu, tobá in tayví koḏi̖ˀdi waˀyáy khóe waagiˀinbá dimuu wänboˀ, heḏiho háa dívíˀan waagibá úvíˀoḏáho hanwaagibá un wáˀ wovâytuchä̖nú-í. ");
INSERT INTO tew_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Heḏiho iweḏi nakeepoˀ Yôesi-á tꞌowavíˀpiyeˀ hânho híwó̖ˀdi namuuˀin, hewänbo wáy wênbíˀpiyá kháaˀi namuu. In toˀwên ivíˀweḏi dívíhângeˀannindá ovâytuchä̖nundeˀ, hewänbo unbíˀpiyá híwó̖ˀdi namuu, heḏi nä́ˀi híwó̖ˀdi wovâyˀoˀi bînséegíkéndeḏá kin waagibá waˀḏi ikanhûuwí. Hewänbo bînséegíhógipíḏá un wáˀ wí waˀyáy khóe waagibá wovâytsꞌâa-í. ");
INSERT INTO tew_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Heḏi in Huḏíyo ovâytsꞌâˀin dívíˀegóˀandáháˀ wíyá dívíwhä̖yu̖ḏá, Yôesi Táḏáḏí ovâywáytꞌihsáa-í, gá i-á ûnkoeḏiḏân han iˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Heḏânkun un tꞌowa Huḏíyo ímuupíˀin wên olive tay napisôeˀinbí waˀyáy khóe waagiˀinbá ímuu, heḏi iweḏi wovâytsꞌâˀḏi wây-á olive tay óekoeˀin deeḏi wovâytꞌihsaa, tobá páaḏéḏí iweḏiˀin ímuupí wänboˀ. Heḏiho shánkí wínabâapuˀwanpí in Huḏíyo in tay eeḏibá ovâywáytꞌihsáa-íḏí, gá indá in tayví koḏi̖ˀdi waˀyáy khóe waagiˀinbá-á dimuuḏân. ");
INSERT INTO tew_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Tíˀûuwin páaḏéˀin, naa odaˀ un Huḏíyo ímuupíˀin wên taˀgen niˀgeḏi íkaˀpówá-íˀin, heḏânho únhanginnândi wíˀúvícha̖a̖ˀâ̖a̖mípí. Nä́wehayḏi nä́ˀin taˀgen waˀḏi wínakaˀpowamuupí, heḏi kinnân in namuu: Tä̖hkí in Israel-win tꞌowa háˀto hä̖̂ä̖ḏi wänbo tꞌä̖hkí yoegikannin dimúní, hewänbo báyékí in Huḏíyo dimuupíˀin tꞌowa Yôesivíˀpiyeˀ dívíwhä̖yu̖ iwehayḏa̖ˀmân ha̖ˀmin dimúní. ");
INSERT INTO tew_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Heḏi owáy nä́ˀin wé̖ˀgeˀin tꞌowa Yôesivíˀpiyeˀ diˀä̖ä̖ ihayḏânho tꞌä̖hkí in Israel-ˀin wáˀ ovâyˀaywoení. Yôesi Táḏáví ta̖ˀnin diwe ûnta̖ˀmuu háa i natú̖ˀin: I aywondi-á Zion diweḏi nakä̖ˀä̖ä̖gítꞌóe, heḏi in Israel-ˀinbí yä̖ˀḏâapíkan ovâyyâaˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Heḏi owáy inbí tꞌaywó̖ˀdi dovâyˀowóyé ihayḏáho háa ingîˀ dovâyˀa̖míḏí dówéhpêeˀan waa napúwí. ");
INSERT INTO tew_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Yôesiví híwó̖ˀdi tu̖u̖ in Huḏíyo dâyyoegiˀandi nää-á Yôesiví hä́nmin dipóe. Hewänbo háa dívíˀannin namuuˀindi un Huḏíyo ímuupíˀin wovâykhä̖ge̖ˀnan Yôesi bîntáa-íḏí. Hewänbo Yôesiḏi nä́ˀin Huḏíyo tꞌowa ovâyséegí gá iví hehä̖̂ä̖win thehtáy pahpáˀin ovâyde̖ˀmandân. ");
INSERT INTO tew_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Yôesiḏá in toˀwên ovâyde̖ˀmannin wíˀovâyyoegiˀopí, heḏá i hä̖ä̖wí híwó̖ˀdi ovâymä́giˀi wíˀovâykweeḏepí. ");
INSERT INTO tew_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Wáymûu un Huḏíyo ímuupíˀindá Yôesi Táḏá wívînˀaˀginmáapí, hewänbo nää in Huḏíyoḏi óeˀaˀgindopíḏíhoˀ unbíˀpiyeˀ naˀiyapoˀ. ");
INSERT INTO tew_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Hanwaagibá in Huḏíyoḏi nää Yôesi wíˀóeˀaˀgindopí, hewänbo unbíˀpiyeˀ naˀiyapoˀḏi inbíˀpiyeˀ wáˀ naˀiyapúwí. ");
INSERT INTO tew_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Yôesi-á natú̖ tꞌä̖hkí tꞌowaḏi wíˀóeˀaˀgindopíḏí inbí tꞌaywó̖ˀdi dínmuuˀiḏiho pan waagiˀinbá dipaa, heḏi kindiḏi tꞌä̖hkí tꞌowa handa̖ˀ ovâymáaḏí tꞌä̖hkívíˀpiyeˀ naˀiyapúwí. ");
INSERT INTO tew_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Yôesi-á hânho hayˀi namuu. Iví hangintandá há̖ˀi-á hânho báyékí ûnmuuḏi háˀto âytaaya̖mí, heḏi háˀto gínhanginnání háaḏí háa hândiḏi iˀoˀ háa ikanhonnin. ");
INSERT INTO tew_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","35","Iví ta̖ˀnin diwe ûnta̖ˀmuu waa: Toˀwí wänbo wíˀûnhanginnáhpí háa Yôesi Táḏá naˀánshaamuuˀin, toˀwí wänbo wíˀûnkoeḏipí óetumakhemä̂äníḏí. Toˀwí wänbo wíˀûnkoeḏipí natú̖níḏí, “Naaḏi hä̖ä̖wí Yôesi dómä́gi, heḏânho i-á ûnkhâyˀä̖ˀ díwáywáˀâa-íˀin.” ");
INSERT INTO tew_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Yôesi-áho hä̖ä̖wí tꞌä̖hkí ikhíyé. Hä̖ä̖ tꞌä̖hkí waˀḏi namän Yôesiví mange imáaḏí, heḏá hä̖ä̖ tꞌä̖hká ivîˀ-á ûnmuu. Heḏiho hä̂nhay wänbo tꞌä̖hkí kwꞌáayéboˀ âymáˀve-í. Hamân. ");
INSERT INTO tew_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Tíˀûuwin páaḏéˀin, Yôesiḏi iví séegísehkanä wovâykeekwꞌóḏi, heḏiho nä́ˀin namuuḏi kaygi̖ˀdi kinnân wâytu̖máa: Tꞌowaḏi in animâa dâytꞌa̖há̖núˀin Yôesi óemäˀ, heḏi han waagibá unho unbí túuˀú úvímä̂äní, hewänbo wówáˀinnân, heḏá wáˀ yä̖ˀḏâaˀinda̖ˀ ímúní heḏânho bînhíhchanmä̂äníḏí. Kindiḏân unbí píˀnä́ khóˀyé Yôesi bînˀaˀginmä̂äní. ");
INSERT INTO tew_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Háa in tꞌowa Yôesi dâytaapíˀin dívíˀo waagibá wíˀúvíkanhûuwípí, hewänbo binmä́ä Yôesiḏi ánshaa tsꞌa̖a̖bi wovâymä̖̂ä̖níḏí, heḏi handiḏiho unbí wówátsi wovâyˀegóˀa̖míḏí. Kindiḏânho únhanginpúwí háa Yôesi nadaˀin úvíˀa̖míˀindá híwó̖ˀninda̖ˀ namuuˀin, heḏá óehíhchandoˀindá, heḏá tꞌä̖hkí taˀgennindá. ");
INSERT INTO tew_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Heḏi Yôesiḏi naa dînkꞌûˀ un wí̖ˀínbo nä́ˀin wâytumakheˀa̖míḏí: Wíˀíˀâ̖a̖nípí heˀennin ímuuˀin ha̖ˀmin ímuupíḏí, hewänbo taˀgendi unbí̖ˀgeḏi úvíˀánshaaˀa̖mí, heḏânho únhanginnáníḏí háa únkoeḏi úvíˀa̖míḏí i whä̖yu̖ Yôesiḏi wovâymä́giˀiḏi. ");
INSERT INTO tew_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","5","Naˀinbí túuˀú-á hä̖́yú̖ḏíbo gínpaˀan, hewänbo nä́ˀi hä̖ä̖wí-á handa̖ˀ wíˀitꞌôeˀopí. Hanwaagiˀinbá naˀin gimuu. Tobáháa báyékíḏí giyi wänbo wîˀḏa̖ˀ waagibá gimuu, gá Christ-áḏí wîˀḏa̖ˀ gimuuḏân, heḏá giwhiˀkwꞌó̖ wéhpêe túuˀú gimúníḏí waagibá. ");
INSERT INTO tew_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Yôesiḏi piˀḏinbo magan dímä́gi, hewänbo tꞌä̖hkí ha̖ˀbiḏa̖ˀ wígínmuupí. Wí toˀwí ûnkoeḏiḏi wí Yôesiví tukhe̖ˀbi waagibá ihéeˀa̖míḏí, i-á ûnkhâyˀä̖ˀ kin iˀa̖míˀin hä̖́yú̖ iví whä̖yu̖ ûnmuu ihay iweḏi. ");
INSERT INTO tew_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Toˀwí méesatewi khä̖ge̖ˀdiˀ namúníˀin ûnkoeḏiˀi-á ûnkhâyˀä̖ˀ híwó̖ iˀa̖míˀin. Toˀwí Yôesiví tu̖u̖ ovâyhá̖ˀa̖míˀi namuuˀi-á ûnkhâyˀä̖ˀ híwó̖ˀ ovâyhá̖ˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Toˀwí natumakhehá̖ˀi-á ûnkhâyˀä̖ˀ iví tumakhe imä̂äníˀin. Toˀwí iví hä̖ä̖wí ûnkwꞌó̖ˀdi iwiyendeḏi wé̖ˀgeˀindáḏí, i-á pín taˀge hayḏi ovâymä̂äní. Toˀwí óetsondisógeˀi namuuˀi-á ûnkhâyˀä̖ˀ hânho itꞌôeˀa̖míˀin. Toˀwí in sehkanäwó̖ˀ diwówáyiˀin ovâykhä̖ge̖ˀdoˀi-á ûnkhâyˀä̖ˀ híhchangiḏi kin iˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Un Únkhâyˀä̖ˀ taˀgendi bîntꞌowaséegíhûuwíˀin, wänpiḏiḏa̖ˀbá yoe. I hä̖ä̖wí tꞌaywó̖ˀdi namuuˀi-á bînyoeˀa̖mí heḏá hä̖ä̖wí yä̖ˀḏâaˀi namuu eeḏá té̖e̖gí tꞌaagá úvítsa̖a̖sáa-í. ");
INSERT INTO tew_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Wíˀnä́ táye úvíséegíhûuwí tíˀûuwin páaḏéˀin dínkhâyˀä̖ˀ waagi, heḏá úvíˀaˀginmáˀve-í hä̖̂ä̖ḏi wänbo tꞌä̖hkí. ");
INSERT INTO tew_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Wíˀíbâa-ípí, hewänbo pín taˀge hayḏi Naˀinbí Sedó Yôesigîˀ úvítꞌôeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Yôesiví híwó̖ˀdi hä̖ä̖wí wovâypä̖gítꞌóeˀi bîntsíkhaˀmáaḏíboˀ íhíhcha̖a̖-í. Bîntꞌôephaḏende wänbo bíyä̖́ä̖ˀan. Hä̖̂ä̖ḏi wänbo tꞌä̖hkí úvíyûusuˀâ̖a̖mí. ");
INSERT INTO tew_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Yôesiví tꞌowa hä̖ä̖wí díntáyˀindáḏí i hä̖ä̖wí únkwꞌó̖ˀdi bînwiyé-í, heḏá unbí kꞌaygipiyá bînséegíˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Yôesi bîndaaˀa̖mí iḏi híwó̖ˀda̖ˀ ovâyˀâ̖a̖míḏí in toˀwên wovâytꞌôephaḏekandoˀin. Híwó̖ˀ gin otú̖, híwó̖ˀpí-á yoe. ");
INSERT INTO tew_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Wí toˀwí nahíhcha̖a̖ˀi-áḏíbá íhíhcha̖a̖-í. Wí toˀwí naséeyiḏá i-áḏíbá úvísíhtä̖ä̖-í. ");
INSERT INTO tew_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Tꞌä̖hkíḏí handa̖ˀ úvímáˀve-í. Wíˀúvíyêngiˀánshaamáˀve-ípí, hewänbo in wä̖hphaḏe kwꞌáyeˀin dimuupíˀindáḏí úvíwóení. Wíˀíˀâ̖a̖nípí hä̖ä̖ tꞌä̖hkí íhá̖ˀin. ");
INSERT INTO tew_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Wí toˀwíḏí yanäkí wovâyˀoḏá yanäkíḏíbá wívînwáˀâa-ípí. I hä̖ä̖wí tꞌowa tꞌä̖hkí dínhanginnáˀdi híwó̖ˀdi namuuˀindá bînˀâ̖a̖mí. ");
INSERT INTO tew_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Unnânho únkꞌóe úvíkhä̖ä̖-íḏí heḏânho nakoeḏiḏáho tꞌä̖hkí tꞌowa-áḏí tsa̖a̖ginpíḏíbo unbí wówátsi bînhûuwí. ");
INSERT INTO tew_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Un wâyséegíˀin, nä́ˀin wâytu̖ˀa̖mí. In tꞌowa un wovâywha̖ˀoˀin wívînwha̖ˀa̖mípí, hewänbo Yôesivíˀwe binyoeˀan nä́ˀi tuchä̖nu, gá Yôesiví ta̖ˀnin diwe kinnân ûnta̖ˀmuuḏân: “Naa-ân dînkꞌóe tꞌowa dovâytuchä̖nú-íḏí, naa-ân dînkꞌóe dovâymä̂äníḏí hä̖ä̖wí dínˀä̖ˀiˀ,” kin Naˀinbí Sedó Yôesi natú̖. ");
INSERT INTO tew_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Kin wáˀ nata̖ˀmuu: Uví hä́nbi naha̖hsêndi nákoegîˀmä́ä, heḏi napꞌoesáˀaaḏá nápꞌoemä́ä. Kin úvíˀoḏá i-á hânho nawôedaˀpóeḏí iví wôedaˀḏi óephahá̖núnde waagibá nachanpúwí. ");
INSERT INTO tew_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Wívînmä̂änípí hä̖ä̖wí yä̖ˀḏâapîˀ namuuˀiḏi wovâytꞌaaníḏí, hewänbo híwó̖ˀ úvíˀoḏibo yä̖ˀḏâapîˀ hä̖ä̖wí namuuˀiˀ bîntꞌaaní. ");
INSERT INTO tew_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Naˀin tꞌä̖hkí gínkhâyˀä̖ˀ in toˀwên dítsonmáaˀinbí khómaphoˀ ívíkwꞌôeníˀin, gá Yôesi natú̖ḏího gíntsonninkwꞌôndân, heḏiho Yôesiḏânho inbí tsonkhuu ovâymäˀ. ");
INSERT INTO tew_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Heḏânkun toˀwíḏí in toˀwên dâytsonkhuumáaˀin ovâyˀaˀgindopíḏí, hä̖ä̖wí Yôesi ikꞌûˀi wänbo wíˀiˀaˀginpí, heḏi wí toˀwí kin iˀoˀi-áho óetuchä̖nú-í. ");
INSERT INTO tew_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","In toˀwên híwó̖ˀ dívíˀoˀindá in tsonnin wíḏâykhuwôedaˀípí, hewänbo in yanäkí dívíˀoˀindáho dikhuwôedaˀí. Heḏiho i toˀwí natsonnä́ndiˀ wívînkhuwôedaˀípíˀin ídaˀḏáhoˀ, híwó̖ˀda̖ˀ úvíkanhûuwí, heḏi unbí̖ˀgeḏi híwó̖ˀda̖ˀ ihéeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","I-á Yôesiví tꞌôeˀi waagiˀbá namuu, i-á unbí híwó̖ˀgîˀḏa̖ˀ iˀoˀ. Hewänbo úvíyä̖ˀḏâapíˀoḏá, íkhuwôedaˀí, nä́ˀi tsondi-á wên taˀgen ûnkꞌóeḏí wovâytuchä̖nú-íḏí, gá Yôesiví tꞌôeˀi waagiˀbá namuuḏiho tuchä̖nu imáyä̖ˀdân in toˀwên dívíyä̖ˀḏâapíˀoˀingîˀ. ");
INSERT INTO tew_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Heḏiho un únkhâyˀä̖ˀ in tsonnin dimuuˀin bînˀaˀginnamíˀin, hewänbo i tuchä̖nu bînkhuwôedaˀḏiḏa̖ˀbá yoe. Shánkíḏí bînˀaˀginnamí gá unbí píˀnä́ khóˀyé un únhanginnândân nä́ˀindá in taˀgeˀin namuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Heḏiho i tax chä̖ˀ in tsonnindi wovâyphahsandeˀi-á úvíwáˀándeˀ, gá indá inbí tꞌôe dâyˀoḏibo Yôesigîˀ waagibá dívítꞌôemáaḏân. ");
INSERT INTO tew_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Heḏiho in tꞌä̖hkí bînmä̂äní hä̖ä̖wí dínˀä̖ˀiˀ. Hä̖ä̖wí in tsonnindi wovâyphahsandeˀi tꞌä̖hkí úvíwáˀâa-í, heḏá in toˀwên in tsonkhuu dâymáaˀindá hânho-á bînpiˀaˀgeení. ");
INSERT INTO tew_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Únkhâyˀä̖ˀ unbí séegí wíˀnä́ táye hä̖̂ä̖ḏi wänbo tꞌä̖hkí íphaamúníˀin, hewänbo wíyá hä̖ä̖wí wänbo-á yoe. Wí toˀwíḏí tꞌowa ovâyséegíhondáhoˀ, kindiḏi tꞌä̖hkí Yôesiví tsontu̖u̖ ônˀaˀgindoˀ. ");
INSERT INTO tew_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","I tsontu̖u̖ kinnân namuu: Wíyá toˀwíví sedó-áḏí háa kwiyó-áḏí wíˀúvíwho̖hkwomáˀve-ípí, wívîntꞌowatꞌa̖há̖nú-ípí, wíˀúvísä̖ˀmâamípí, thúuḏí wíyá toˀwíví hä̖ä̖wí wíˀídaˀípí, heḏá wíyá ha̖ˀbi tsontu̖u̖ wáˀ nakwꞌó̖. Hewänbo tꞌä̖hkí nä́ˀi tsontu̖u̖ wé̖ˀge wên wéhpêeḏa̖ˀ tsontu̖u̖ waagiˀbá namuu, kinnân: Háa un wíˀbo úvípiséegí waagibá, wé̖ˀgeˀin tꞌowa wáˀ bînséegíhûuwí. ");
INSERT INTO tew_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Wí toˀwí tꞌowa tꞌä̖hkí iséegíˀi-á háˀto wíyá toˀwí yanäkí óeˀa̖mí. Heḏiho taˀgendi bîntꞌowaséegíḏá, kindiḏi tꞌä̖hkí i tsontu̖u̖ bînˀaˀgindoˀ. ");
INSERT INTO tew_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Nä́ˀi wâytu̖ˀandi-á úvíˀâ̖a̖mí, gá únhanginnândân hä̖̂ä̖ḏi nanáˀnin. Nää-á shánkí tsoˀwa naná Jesus nawáypówá-íḏí dînˀaywoeníḏí páaḏé ivíˀpiyeˀ ívítsꞌanwhä̖yu̖ ihayḏivíˀweḏi, heḏiho nää-á ihayḏiho nanân íyósaˀwó-íḏí waagíbá namuu. ");
INSERT INTO tew_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Nää-á waˀ nawáypówápíḏíbo gínkhu̖u̖ná waagibá gínpuwamän, hewänbo i khu̖u̖ naphaḏemän heḏi nathayˀä̖ˀ kin waagibá napoˀ, heḏiho i tꞌaywó̖ˀdi in tꞌowa nakhu̖u̖náˀ dihayḏi dívíˀoˀiˀ âyyoeˀa̖mí, heḏi sundaḏo inbí kwä̖́kꞌu hä́n aaḏi diˀaamuuˀin waagiˀinbá gimúní, nathaynáˀ diwe ívíyíyé-íḏí. ");
INSERT INTO tew_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Nää-á tꞌowa thaaḏi dínkhâyˀä̖ˀ waagibá, híwó̖ˀ naˀinbí wówátsi âyhûuwí. Wáy dínshánkîˀḏipoˀḏi dívítꞌaywó̖ˀdoˀ eeye wíˀívímáˀve-ípí, wígisu̖wä̖tsitꞌôenípí, tsé waagiˀinbá wígiyê̖e̖nípí, wíˀívítꞌaymáˀve-ípí, heḏá wíˀívíthúumáˀve-ípí. ");
INSERT INTO tew_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Hewänbo wí kwä̖́kꞌu hä́n aaḏi wovâyˀá̖yîngiˀo waagibá, Naˀinbí Sedó Jesus Christ-dân wíˀbo wovâyˀá̖yîngiˀa̖mí, heḏi i tꞌaywó̖ˀdi kaygi̖ˀdi íkandaˀ i̖ˀgeḏi wíˀúvíˀánshaamáˀve-ípí. ");
INSERT INTO tew_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Wí toˀwí iví whä̖yu̖ kayˀin wíˀûnmuupí wänbo binséegíkeˀ, hewänbo hä̖ä̖wí híwó̖ˀ nakaˀpóya̖ˀpí i̖ˀgeḏiḏa̖ˀ i-áḏí úvítu̖hä́nmâamíḏá yoe. ");
INSERT INTO tew_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Gá kinnân: Maˀḏi wí toˀwí iwhä̖yundeˀ hä̖ä̖wí koegîˀ namuu wänbo ikꞌoeḏi wíˀitꞌaywó̖ˀdopíˀin, hewänbo wíyá toˀwí iví whä̖yu̖ kaypíˀin ûnmuuˀi-á wíˀipívíkꞌohpí. ");
INSERT INTO tew_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","I toˀwí koegîˀ tꞌä̖hkí ikꞌoˀi-á wíˀûnkhâyˀä̖hpí naˀâ̖a̖níˀin i toˀwí ipívíkꞌohpîˀví hânho shánkí híwó̖ˀdi namuuˀin, heḏi i toˀwí ipívíkꞌohpîˀ wáˀ wínatú̖nípí ipívíkꞌoˀi-á yä̖ˀḏâapí iˀoˀin, gá Yôesiḏi i wáˀ óeséegímáaḏân. ");
INSERT INTO tew_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","U̖-á wíˀú̖kꞌóepí wíyá toˀwíví tꞌôeˀi mântu̖u̖súuˀa̖míḏí. I tꞌôeˀiví tsondiḏa̖ˀmân ûnkꞌóe óetu̖ˀa̖míḏí háa híwó̖ˀ háa híwó̖ˀpîˀ iˀoˀin. Heḏi taˀgendi Naˀinbí Sedóví tꞌôeˀi híwó̖ˀ iˀa̖mí, gá Naˀinbí Sedó ûnkoeḏiḏân óekhä̖ge̖ˀnamíḏí. ");
INSERT INTO tew_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Heḏá wáˀ maˀḏi wí toˀwí nachanpoˀ wí thaa shánkí naˀaˀginmuu wé̖ˀgeˀi thaavíˀweḏi, hewänbo wíyá toˀwí-á nachanpoˀ tꞌä̖hkí thaa ha̖ˀbi thaaḏa̖ˀ nanáˀnin. Gínkhâyˀä̖ˀ wí̖ˀínbo ívípiˀánshaamä̂äníˀin nä́ˀin niˀgeḏi. ");
INSERT INTO tew_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","I toˀwí wí thaa wíyá thaaví shánkí iˀaˀgindoˀi-á Naˀinbí Sedó óeˀaˀginnamíḏân iˀoˀ. Heḏi i toˀwí tꞌä̖mägîˀ koegiˀ ikꞌoˀi-á wáˀ Naˀinbí Sedó óeˀaˀgeeníḏí kin iˀoˀ, gá i koegiˀ óemä́giḏi Yôesi óekú̖ˀdaaˀoḏân, heḏi i toˀwí wí hä̖ä̖wí ikꞌohpîˀ-á Naˀinbí Sedó óeˀaˀgeeníḏí kin iˀoˀ, i wáˀ nakú̖ˀdaapóeḏí kinbá iˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","8","Tobá giwówáyiḏi háa gichuu wänboˀ, wîˀ wänbo naˀingîˀḏa̖ˀmân kin wíˀívíˀopí, gá giwówáyiḏá Naˀinbí Sedógîˀ-ân giwówáyiˀ, heḏi gichuuḏá Naˀinbí Sedógîˀbá gichuˀ. Heḏiho tobá giwówáyiḏi háa gichuu wänbo Naˀinbí Sedóvíˀinda̖ˀ gimuu. ");
INSERT INTO tew_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Christ nachuu heḏá nawáywówápóe heḏânho tꞌowa tꞌä̖hkígîˀ i shánkí pꞌóˀḏéḏîˀ namúníḏí, in ho dichuuˀingîˀ-á heḏá in waˀḏi diwówáyiˀingîˀ-áḏí. ");
INSERT INTO tew_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Heḏiho wîˀ wänbo wíˀúnkꞌóepí unbí tíˀûuwin páaḏéˀin bîntu̖u̖súuˀa̖míˀin, heḏi wíˀúnkꞌóepí íchanpúwíˀin undá inbí shánkí híwó̖ˀnin ímuuˀin. Wáy wí thaa wänbo naˀin tꞌä̖hkí Yôesiví páaḏépiyeˀ gikwi̖nuḏée-í, heḏi ihayḏi i-ânho natú̖ní taˀgendi háawin gimuuˀin. ");
INSERT INTO tew_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Kinnân Yôesiví ta̖ˀnin diwe nata̖ˀmuu: “Taˀgendi naa owówáyiˀ” kin natú̖ Naˀinbí Sedó, “heḏi taˀgendibá tꞌä̖hkí tꞌowa naví páaḏépiyeˀ dívídéˀgendikwokhâymáa, heḏá tꞌä̖hkíḏíbo-á ditu̖gítꞌóe naa-ânkun taˀgendi Yôesi omuuˀin.” ");
INSERT INTO tew_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Heḏi nä́ˀi híˀ natu̖ˀdaˀ naˀin tꞌä̖hkí gínkhâyˀä̖ˀ Yôesi âytu̖ˀa̖míˀin háa ívíˀannin heḏá háaḏí ívíˀannindá. ");
INSERT INTO tew_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Heḏânkun wíyá ívítu̖u̖súuˀâ̖a̖mívíˀweḏi, ívíˀánshaamä̂äní hä̖ä̖wí wänbo wíˀívíˀa̖mípíˀin naˀinbí tíˀûu páaḏéˀiˀ óetꞌaywó̖ˀkannamíˀiˀ. ");
INSERT INTO tew_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Naˀinbí Sedó Jesus-áḏí omuuḏiho naa dîntaˀgendihanginná hä̖́ä̖bo wíˀbo wígínkhâ̖a̖kꞌóepíˀin, hewänbo wí toˀwí wí hä̖ä̖wí igîˀ ûnkhâ̖a̖kꞌóeˀin nachanpóeḏáhoˀ, heḏân taˀgendi hä̖ˀi hä̖ä̖wí-áho ûnkhâ̖a̖kꞌóe-ákun. ");
INSERT INTO tew_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Gá kinnân: Hä̖ä̖wí bînkꞌoeˀi namuuḏi unbí tíˀûu páaḏéˀi bînháachanmáaḏíhoˀ, háa úvíˀoˀindáho nakeepuwagítꞌóe taˀgendi wívînséegíhonpíˀin. I hä̖ä̖wí bînkꞌoˀiḏân wíyá toˀwíví wówátsi wívînpeḏeeˀa̖mípí, igîˀ Christ nachuuḏi. ");
INSERT INTO tew_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Tobáháa híwó̖ˀgí úviˀo kin íchanpoˀ wänboˀ, hä̖ä̖wí úvíˀoˀi yanäkí namuu gin tꞌowa ditú̖ḏáhoˀ, wíyá wíˀúvíˀâ̖a̖mípí. ");
INSERT INTO tew_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Yôesigîˀ naˀinbí wówátsi âyhondáho hä̖ä̖wí koegîˀ-á su̖wä̖gîˀ-á namuu i̖ˀgeḏiḏa̖ˀ wíˀívíˀánshaamáapí, hewänbo nä́ˀiˀ i̖ˀgeḏân: I Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi naˀin díkhä̖ge̖ˀmáa in taˀgeˀin pꞌóegé i̖ˀge gimú-íḏí, heḏá tsa̖a̖ginpíḏíbo-á naˀinbí wówátsi-á âyhon, heḏá híhchandá âymáa. ");
INSERT INTO tew_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Toˀwí ki̖ˀbi namuuˀi Christ-gîˀ itꞌôeˀoˀiḏá Yôesi óehíhchanmäˀ heḏi tꞌowa-á wáˀ ditú̖ní híwó̖ˀ iˀoˀin. ");
INSERT INTO tew_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Heḏânkun nää-á ívísóˀḏêe-í ívíˀa̖míḏí i hä̖ä̖wí díkhä̖ge̖ˀdoˀi naˀinbí wówátsi wé̖ˀge saˀwó̖ˀgí âyhûuwíḏí, nä́ˀi hä̖ä̖wíḏíbá díkhä̖ge̖ˀnamí wíˀnä́ táye naˀinbí whä̖yu̖ ívíkayˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Hä̖ä̖wí íwänpikoedaˀḏibo wívînpeḏeeˀa̖mípí háa Yôesi wí toˀwígîˀ iˀannin. Hä̖ä̖wí koegîˀ wänbo wínakhâ̖a̖kꞌóepí óekꞌoe-íḏí, hewänbo híwó̖ˀ wínamuupí wí hä̖ä̖wí toˀwí ikꞌóe-íḏí, han iˀoḏá wíyá toˀwí-á in taˀgeˀin pꞌóegéḏí óehângeˀoḏi. ");
INSERT INTO tew_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Shánkí híwó̖ˀ namúní wívînpívíkꞌoe-ípí háa wívînméenasu̖wä̖́-ípí háa wíyá hä̖ä̖wí unbí tíˀûu páaḏéˀiˀ in taˀgeˀin pꞌóegé iweḏi óehângeˀoˀi wíˀúvíˀa̖mípí. ");
INSERT INTO tew_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Tobáháa háa nä́ˀi hä̖ä̖wí i̖ˀgeḏi wí toˀwí nacha̖a̖ wänboˀ, i-áḏí Yôesi-áḏíḏa̖ˀ dä́nkhâyˀä̖ˀ dä́nhanginnáníˀin. Wí toˀwí híwó̖ˀ iˀo gin ûnchanpoˀḏi, heḏá tíˀúugéḏá híwó̖ˀpí iˀannin wínachanpóepíḏí, i-á nahíhcha̖a̖. ");
INSERT INTO tew_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Hewänbo wí toˀwí wí hä̖ä̖wí ikꞌoeḏáhoˀ, hewänbo wíˀûnkoeḏihanginnáhpí híwó̖ˀ namuuˀin ikꞌóe-íḏí, Yôesi-á natú̖ní híwó̖ˀpí iˀannin, gá nä́ˀi toˀwí-á taˀgendi wíˀûnhanginnáhpíḏân háa híwó̖ˀ iˀannin háa yoe, heḏi wí hä̖ä̖wí ívíˀoḏá hewänbo taˀgendi wígichanpoˀpí híwó̖ˀ namuuˀin kin ívíˀa̖míḏí, hä̖ˀindá tꞌaywó̖ˀnin namuu naˀingîˀ. ");
INSERT INTO tew_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Naˀinbí whä̖yu̖ kayˀin gínmuuḏá gínkhâyˀä̖ˀ in toˀwên inbí whä̖yu̖ kayˀin dínmuupíˀin âykhä̖ge̖ˀnâamíˀin, wí toˀwíḏí wíyá toˀwíví hé ôntegende waagibá, heḏi háa giwänpidaˀ waagiḏa̖ˀ wíˀívíˀâ̖a̖mípí. ");
INSERT INTO tew_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Gínkhâyˀä̖ˀ naˀinbí tíˀûuwin páaḏéˀinbí̖ˀgeḏi ívíˀánshaaˀâ̖a̖míˀin heḏá ingîˀ híwó̖ˀdá ívíˀâ̖a̖mí heḏânho inbí whä̖yu̖ dínkeˀenníḏí, ");
INSERT INTO tew_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","gá Christ wänbo-á wíˀbo iví̖ˀgeḏiḏa̖ˀ wíˀiˀánshaaˀanpíḏân. Yôesi Táḏáví ta̖ˀnin diwe kinnân nata̖ˀmuupíˀan háa Christ-di óetu̖ˀannin Yôesi Táḏá: I yanäkí híˀ uví̖ˀgeḏi dívíhéeˀandi-á navíˀwebá dînpówá. ");
INSERT INTO tew_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Heḏi nä́ˀi hä̖ä̖wí Yôesi Táḏáví ta̖ˀnin diwe hä́nˀoe dâyta̖ˀnandi-á nata̖ˀmuu heḏânho naˀin díháˀa̖míḏí âytsíkhaˀa̖míḏí i hä̖ä̖wí híwó̖ˀdi Yôesiḏi naˀingîˀ dînkhâymáaˀiˀ, gá i hä̖ä̖wí iwe nata̖ˀmuuˀiḏá naˀin díkweewaasenwaatu̖máaḏân heḏá díkhä̖ge̖ˀdoˀ ívíyä̖́ä̖ˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","6","Yôesiḏânho díkweewaasenwaatu̖máa, heḏi tobá háa gínpoˀ wänbo díkhä̖ge̖ˀdoˀ ívíyä̖́ä̖ˀa̖míḏí, heḏi iḏá wovâykhä̖ge̖ˀnamí wáˀ wîˀḏa̖ˀ waagi unbí píˀnä́ khóˀyé ímúníḏí. Kindiḏiho úvíˀâ̖a̖mí háa Christ iˀan waagibá, heḏânho tꞌä̖hkíḏíbo wé̖ˀge Yôesi Táḏá kwꞌáayéboˀ óemáˀve-íḏí, i-á Naˀinbí Sedó Jesus Christ-ví Táḏá ûnmuu. ");
INSERT INTO tew_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Wíˀnä́ táye bíséegíhóˀgí. Christ-di un wovâyséegíhógi waagibá, un wáˀ wíˀnä́ táye úvíséegíhûuwí, heḏânho tꞌowa Yôesi Táḏá dâytegé-íḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Wíˀúnˀóḏe-ípí nä́ˀin: Christ wí khä̖ge̖ˀdi waagi in Huḏíyovíˀwe napówá, tꞌowa ovâykeekwꞌôeníḏí Yôesi Táḏá-á taˀgendi iˀoˀin háa naˀinbí hehä̖̂ä̖win thehtáy pahpáˀin ovâytu̖ˀan waa ikhâymáaˀin, ");
INSERT INTO tew_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","heḏá wáˀ Christ wí khä̖ge̖ˀdi waagi napóe heḏânho in Huḏíyo dimuupíˀinbíˀpiyeˀ naˀiyapoˀḏi indá Yôesi Táḏá kwꞌáayéboˀ âymáˀve-íḏí. Kinnân Yôesiví ta̖ˀnin diwe ûnta̖ˀmuu: In Huḏíyo dimuupíˀindáḏí oyiḏi naaḏi wítegé-í, heḏá iwebá dókhaˀwoḏi uví khá̖wä̖́ wînkhá̖yä̖́ˀní. ");
INSERT INTO tew_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Wíyá wáygá kinnân nata̖ˀmuu: Un Huḏíyo ímuupíˀin Yôesiví tꞌowa-áḏí bíhíhchanpuwave. ");
INSERT INTO tew_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Heḏá wíyá wáygá wáˀ nata̖ˀmuu: Un Huḏíyo ímuupíˀindi Naˀinbí Sedó bintégé, un tꞌowa tꞌä̖mäpiyeˀ ówîngeˀindi báyékí bintégé. ");
INSERT INTO tew_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Isaiah wáˀ kinnân ita̖ˀnan: Wí Jesse-ví ây iweḏiˀi naˀaypu̖yä̖ˀi-á in Huḏíyo dimuupíˀingîˀ ôntsondisogekhâymáa, heḏi i-ân namuu i dâytsíkhaˀmáaˀiˀ híwó̖ˀ ingîˀ ovâyˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Yôesi Táḏáḏá naˀin díhanginˀândoˀ híwó̖ˀdi dînkhâymáaˀin, heḏihoˀ ivíˀpiyeˀ úvíwhä̖yundeḏi iḏibá báyékí wovâyhíhchanmä̂äní heḏá wovâykhä̖ge̖ˀnamí ánshaa iwe wíˀíkwo̖ˀnípíḏí, heḏânho i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi kay wovâymä̂äní hä̖ä̖wí Yôesi Táḏáḏí naˀin dînkhâymáaˀiˀ hä̖̂ä̖ḏi wänbo tꞌä̖hkí ítsíkhakwo̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Naví tíˀûuwin páaḏéˀin, naa-á taˀgendi dáywhä̖yundeˀ undá hânho híwó̖ˀnin ímuuˀin, undá Yôesiví khuu i̖ˀgeḏi báyékí únhanginná, undá únkoeḏi wíˀnä́ táye úvítumakheˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","16","Hewänbo wáy wí hä̖ä̖wí i̖ˀgeḏi wóˀyoegipíḏí wâyta̖ˀnan heḏânho únˀánpówá-íḏí. Kin waagi wâyta̖ˀnan gá Yôesi Táḏá navíˀpiyeˀ híwó̖ˀdí namuuḏi wên tꞌôe dímä́giḏân dáyˀa̖míḏí, heḏiho nää Christ Jesus-gîˀ dáytꞌôemáa un tꞌowa Huḏíyo ímuupíˀin wâykhä̖ge̖ˀnamíḏí. Wí owhaˀ hä̖ä̖wí Yôesi Táḏávíˀpiyeˀ ihúya̖ˀ waagibá, naaḏá Yôesiví híwó̖ˀdi tu̖u̖ in Huḏíyo dimuupíˀin dovâytꞌôeˀoˀ heḏânho indá Yôesi Táḏávíˀpiyeˀ dovâyhûuwíḏí, heḏi iḏá ovâyséegíhónde gá i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi ovâykhä̖ge̖ˀnandân ivíˀin dimúníḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Heḏiho Christ Jesus-áḏí wé̖ˀge gamuuḏi naa dînkoeḏi naví tꞌôe Yôesigîˀ i̖ˀgeḏi híwó̖ˀ dáyhéeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","19","Hewänbo hä̖ä̖wí Christ-di díkhä̖ge̖ˀnan dáyˀa̖mí i̖ˀgeḏiḏa̖ˀmânho wôedaˀginpíḏíbo dáyhéeˀa̖mí. Háa otú̖ waagiḏá háa dáyˀan waagiḏá, heḏá i tꞌä̖mägîˀ pínnán tꞌôe i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi díkhä̖ge̖ˀnandi dóˀa̖míḏí namuuḏá, in Huḏíyo dimuupíˀin tꞌowaḏi Yôesi óeˀaˀgindoˀ. Heḏiho Jerusalem búuˀú iweḏi oe Illyricum nangepiyeˀ tꞌä̖mäpiyeˀ omändi nä́ˀi híwó̖ˀdi tu̖u̖ Christ-ví̖ˀgeḏi dovâytꞌôekanhon. ");
INSERT INTO tew_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Hä̖̂ä̖ḏi wänbo tꞌä̖hkí wáy Christ-ví̖ˀgeḏi wíḏitꞌoepí eeyeḏa̖ˀ naa dáysóˀḏínde nä́ˀi Yôesiví híwó̖ˀdi tu̖u̖ tꞌowa dovâytꞌôeˀa̖míḏí. Wáy wíyá toˀwí naví páaḏébo ipúupaa iwebá naa wóˀdaˀpí wí hä̖ä̖wí dópaa-íˀin, ");
INSERT INTO tew_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","hewänbo háa Yôesi Táḏáví ta̖ˀnin diwe ûnta̖ˀmuu waa odaˀ napúwíˀin, kinnân: Toˀwên waˀḏi toˀwíḏí wänbo Yôesiví̖ˀgeḏi ovâytꞌôeˀanpíˀindá dínthaypúwí, in toˀwên waˀḏi iví̖ˀgeḏi ditꞌoepíˀindá dikaˀpówí. ");
INSERT INTO tew_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Heḏiho kin dáyˀoḏi hânho dînwóˀnândi waˀḏi wíḏînkoeḏipí unbíˀpiyeˀ omú-íḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","24","Hewänbo nää-á naví tꞌôe tꞌä̖hkí nä́ngé donbowa, heḏi báyékí pa̖a̖yo wâymúníˀin odaˀḏi nää-á maˀḏi unbíˀpiyeˀ omú-í. Oe Spain-piyeˀ ophaḏemändiboˀ odaˀ wâymúníˀin, heḏá wí hä̖́yú̖ yâaḏi undáḏí oˀáḏâacha̖ˀní heḏi ihayḏi naa odaˀ undi díkhä̖ge̖ˀnamíˀin eepiyeˀ omú-íḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Hewänbo nää-á oe Jerusalem-piyeˀ omän wí hä̖ä̖wí in Yôesiví tꞌowa iweˀin dovâyhûuwíḏí, ");
INSERT INTO tew_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","gá in Macedonia-áḏí Greece-áḏíwin méesateˀin tꞌowa wí chä̖ˀ dâywé̖ˀgeˀa̖míḏí dívíˀánshaamä́giḏân, in toˀwên Yôesiví tꞌowa sehkanäwó̖ˀ diwówáyiˀin oe Jerusalem dimuuˀin ovâymä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","In Macedonia-windá in Greece-ˀindáḏí wíˀbo ditú̖ híwó̖ˀ namúní kin dívíˀa̖míḏí, hewänbo taˀgendi hä̖ä̖wí in Jerusalem-ˀin dínphaamuuˀiˀ ovâywáywáˀánde waagibá dívíˀoˀ, gá in Huḏíyo dimuuˀindi páaḏé in Huḏíyo dimuupíˀin ovâyyä̖́múḏân i híwó̖ˀdi hä̖ä̖wí Yôesi Táḏáḏí inbí hâ̖a̖gîˀ ovâymä́giˀiˀ, heḏi nää-á in Huḏíyo dimuupíˀindá dínkhâyˀä̖ˀ ovâyyä̖́mú-íˀin i hä̖ä̖wí in Huḏíyo dimuuˀin díntáyˀi híwó̖ˀ ovâykhóekhú̖u̖mä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Nä́ˀi tꞌôe dînbowaḏee ihayḏi i chä̖ˀ in Jerusalem-ˀinbí mange dovâykándí, iweḏi oe Spain-piyeˀ omän, heḏi ihayḏá dáywóyí̖ˀní wâymúníḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Naa dînhanginná owáy unbíˀwe opówá ihayḏá báyékí híwó̖ˀdi hä̖ä̖wí Christ-víˀweḏi wâyyoeˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Tíˀûuwin páaḏéˀin, unbí whä̖yu̖ Naˀinbí Sedó Jesus Christ-víˀpiyeˀ únmuuḏi heḏá in séegí i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi naˀin dímä́giˀin namuuḏá, kaygi̖ˀdi naaḏi wâydaˀmáa Yôesi Táḏávíˀpiyeˀ pín taˀge hayḏi dînyûusuˀa̖míḏí, naa wíˀbo wâyyûusuˀo waagibá. ");
INSERT INTO tew_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Úvíyûusuˀa̖mí heḏânho in Judea nangewin tꞌowa Yôesi óeˀaˀgindopíˀindi bahpíbo naa díphaḏemä̂äní, heḏá Yôesi Táḏáví tꞌowa oe Jerusalem-windá in khä̖ge̖ˀ dovâyhonnin híhchandi dâyséegíˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Heḏiho Yôesi Táḏá natú̖ḏáho unbíˀwe híhchandibo opówá-í, heḏá undáḏí oˀä́n dihayḏi dînkoeḏí-í dáykaykhanwówáˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Yôesi Táḏáḏí naˀin díkhä̖ge̖ˀdoˀ ánshaaginpíḏíbo gikwo̖ˀníḏí, ibá un tꞌä̖hkí-áḏí nacha̖ˀní. Hamân. ");
INSERT INTO tew_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Naa odaˀ naˀinbí tíˀûu páaḏéˀi Phoebe bîntáa-íˀin, I-á i Cenchrea búuˀúwi méesateˀi khä̖ge̖ˀdi namuu. ");
INSERT INTO tew_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","I-á Naˀinbí Sedóvîˀ ûnmuuḏi binséegíˀan, Yôesiví tꞌowa dínkhâyˀä̖ˀ waagibá, heḏá hä̖ä̖wí i ûntáyḏá, hä̖ˀi únkwꞌó̖ˀ diweḏi bînyä̖́mú-í, gá iḏá báyékí tꞌowa ovâykhä̖ge̖ˀnandân, heḏá naa wáˀ díkhä̖ge̖ˀnan. ");
INSERT INTO tew_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Priscilla-áḏí Aquila-áḏí naví sengitu̖u̖-á dovä̂nsan, indá naa-áḏí Christ Jesus-gîˀ ívítꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Indá dakhâymuu inbí wówátsi dänmä̂äníḏí naa bahpíbo opúwíḏí. Heḏiho dovä̂nkú̖ˀdaaˀoˀ, hewänbo naaḏiḏa̖ˀbá yoe, tꞌä̖hkí in Huḏíyo dimuupíˀin méesateˀindi wáˀ ovä̂nkú̖ˀdaaˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Heḏá in tꞌowa inbí tewhá ee dívíwé̖ˀgeˀoˀin Yôesi óeˀaˀginmä̂äníḏí, in wáˀ bînsengitu̖ˀâ̖a̖mí. Heḏá nä́ˀin wé̖ˀgeˀin tꞌowa wáˀ dînsengitu̖ˀâ̖a̖mí: Epanetus, naaḏi dóséegíˀiˀ, i-á oe Asia nange i páaḏéˀi Christ-víˀpiyeˀ iwhä̖yu̖ˀi namuu, ");
INSERT INTO tew_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","heḏá Mary-á, hânho ungîˀ itꞌôeˀoˀi namuu, ");
INSERT INTO tew_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","heḏá Andronicus-áḏí Junius-áḏí naví tꞌowa dînmuuˀindá. Naa-áḏí indáḏí wé̖ˀge gipankwꞌônwän, heḏi Yôesiví tꞌôekhuwaˀindi híwó̖ˀ ovä̂ntaa. Indá naví páaḏébo Christ-víˀpiyeˀ dänwhä̖yu̖. ");
INSERT INTO tew_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Heḏá Ampliatus-á wáˀ dînsengitu̖ˀâ̖a̖mí, i-á dóséegí heḏi i wáˀ Naˀinbí Sedóvíˀpiyeˀ iwhä̖yundeˀ, ");
INSERT INTO tew_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","heḏá Urbanus-á, i-á naˀindáḏí Christ-gîˀ itꞌôeˀan, heḏá Stachys-á, i-á dóséegí, ");
INSERT INTO tew_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","heḏá Apelles-á, nakeepoˀ i-á taˀgendi Christ-vîˀ ûnmuuˀin, heḏá Aristobulus-ví kꞌaygiˀindá, ");
INSERT INTO tew_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","heḏá Herodion-dá, i-á naví tꞌowabá dînmuu, heḏá in toˀwên Narcissus-ví kꞌaygiˀin diweḏi Naˀinbí Sedóvíˀpiyeˀ dívíwhä̖yundeˀindá. ");
INSERT INTO tew_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Heḏá wáˀ dînsêngitu̖ˀâ̖a̖mí Tryphena-áḏí Tryphosa-áḏí, indá Naˀinbí Sedógîˀ hânho däntꞌôeˀoˀ, heḏá Persis-á, i-á dóséegí, heḏá i wáˀ Naˀinbí Sedógîˀ hânho itꞌôeˀan. ");
INSERT INTO tew_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Rufus-á wáˀ dînsengitu̖ˀâ̖a̖mí, i-á Yôesiḏi óede̖ˀmandiˀ namuu, heḏá iví yíyá-á, naví yíyá waagibá dócha̖a̖. ");
INSERT INTO tew_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Dînsengitu̖ˀâ̖a̖mí Asyncritus-á, Phlegon-dá, Hermes-á, Patrobus-á, Hermas-á heḏá in tíˀûuwin páaḏéˀin indáḏí diyiˀindá. ");
INSERT INTO tew_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Heḏá wáˀ dînsengitu̖ˀâ̖a̖mí Philologus-áḏí Julia-áḏí, heḏá Nereus-áḏí heḏá i kwee iví tíˀûu ûnmuuˀi-áḏí, heḏá Olympas-á, heḏá tꞌä̖hkí in wé̖ˀgeˀin Yôesiví tꞌowa indáḏí diyiˀindá. ");
INSERT INTO tew_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Wíˀnä́ táye úvíséegísengitu̖ˀâ̖a̖mí. Tꞌä̖hkí Christ-ví méesate eeyewin tꞌowa tꞌä̖mäpiyeˀ dikwꞌó̖ˀnindi wovâysengitu̖ˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Tíˀûuwin páaḏéˀin kaygi̖ˀdi wâytumakhemáa, in toˀwên wovâywiyé-íˀin heḏá in taˀgeˀin pꞌôe iweḏi wovâyhângeˀa̖míˀin didaˀinbí̖ˀgeḏi úvíˀá̖yîngiˀa̖mí, indáho hä̖ä̖wí íhá̖hpóeˀivíˀweḏi wíyá piháawi wovâyhá̖ˀoˀ. Inbíˀweḏi úvíyâaˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Ki̖ˀmin tꞌowa-á Naˀinbí Sedó Christ-gîˀ wíḏívítꞌôeˀopí, hewänbo ingîˀḏa̖ˀ háa didaˀ waagi dívíwänpiˀoˀ. Tꞌowaví̖ˀgeḏi dívíhíˀmáaḏí inbí híˀ saˀwó̖ˀ díntꞌoetꞌóe, hewänbo kindiḏi in toˀwên ihay kaˀpowa dâymáapíˀin ovâyhôeyóˀoˀ. ");
INSERT INTO tew_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Tꞌä̖hkí tꞌowa dínhanginná undi Yôesi bînˀaˀgindoˀin, heḏiho naa ohíhcha̖a̖ han úvíˀoḏi. Hewänbo naa odaˀ in hangintan bînmáˀve-íˀin heḏânho únhanginnáníḏí wéˀi wí híwó̖ˀdi namuuˀin heḏi iweḏiho tꞌaywó̖ˀkanhá̖ˀin ímúnípíḏí. ");
INSERT INTO tew_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Yôesi Táḏáḏí naˀin díkhä̖ge̖ˀdoˀ ánshaaginpíḏíbo gikwo̖ˀníḏí, heḏi iḏibáho hây napóe ihayḏi Penísendiví kay ônhá̖nú-í heḏânho undi bîntꞌáaníḏí. Christ-ví séegísehkanä-á bînmáˀve-í. ");
INSERT INTO tew_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timothy naa-áḏí Yôesigîˀ itꞌôeˀoˀiḏi wovâysengitu̖ˀan, heḏá Lucius-á Jason-dá heḏá Sopater-á naví tꞌowa dînmuuˀindi wáˀ wovâysengitu̖ˀan. ");
INSERT INTO tew_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","(Naa Tertius omuuˀiˀ dóta̖ˀdo háa Paul natú̖ˀin, heḏá naaḏi wáˀ Naˀinbí Sedóvîˀ omuuḏi wâysengitu̖máa.) ");
INSERT INTO tew_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gaius-di wáˀ wovâysengitu̖ˀan. Naa iví kꞌaygi oˀä́n, iwebá tꞌä̖hkí in Jesus-víˀpiyeˀ dívíwhä̖yundeˀin nä́ˀi búuˀúwin dimuuˀin dívíwé̖ˀgeˀoˀ. Heḏá Erastus-á nä́ˀi búuˀúwi chä̖ˀ iˀá̖yí̖ˀdoˀiḏi wáˀ wovâysengitu̖ˀan, heḏá naˀinbí tíˀûu páaḏéˀi Quartus-di wáˀ. ");
INSERT INTO tew_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Naˀinbí Sedó Jesus Christ-ví séegísehkanä bînmáˀve-í tꞌä̖hkíḏíboˀ. Hamân.");
INSERT INTO tew_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Naˀin Paul-áḏí Timothy-áḏí Christ Jesus-gîˀ äntꞌôemáa. Nä́ˀin ta̖ˀnin wâyta̖ˀdoˀ un méesateˀin pꞌóˀḏéḏíˀindáḏí in khä̖ge̖ˀnindáḏí hä̖ä̖ Philippi búuˀú íthaaˀin, heḏá tꞌä̖hká un wé̖ˀgeˀin Yôesi Táḏáví tꞌowa Christ Jesus-áḏí ímuuˀin wáˀ wâyta̖ˀdoˀ. ");
INSERT INTO tew_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Yôesi Táḏá naˀinbí Táḏá gínmuuˀi-áḏí heḏá Naˀinbí Sedó Jesus Christ-áḏí séegísehkanä wovâymä̂äní heḏá wovâykhä̖ge̖ˀnamí ánshaaginpíḏíboˀ íkwo̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Hä̖̂ä̖ḏi unbí̖ˀgeḏi dáyˀánshaaˀan ginhay naaḏi naví Yôesi donkú̖ˀdaaˀoˀ un ímuuḏi, ");
INSERT INTO tew_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","heḏi hä̖̂ä̖ḏi wänbo un tꞌä̖hkígîˀ dáyyûusuˀan ginhay-á híhchandi kin dáyˀoˀ, ");
INSERT INTO tew_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","gá i páaḏéˀi thaa úvíwhä̖yu̖ iweḏibo nää puˀwahayḏi naˀin díkhä̖ge̖ˀnandân i híwó̖ˀdi tu̖u̖ Jesus-ví̖ˀgeḏi tꞌowa âytꞌôeˀa̖míḏí. Páaḏé úvítsꞌanwhä̖yu̖ ihayḏi Yôesi Táḏá unbí píˀnä́ khóˀyé wí hä̖ä̖wí híwó̖ˀdi iˀan, ");
INSERT INTO tew_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","heḏi naa taˀgendi dînhanginná Yôesi Táḏábá namuu nä́ˀi ikhâymáaˀiˀ nää iweḏi páaḏépiyeˀ, heḏi owáy i thaa Christ Jesus nawáypówá ihayḏá nä́ˀi híwó̖ˀ wovâyˀoˀi-á únbowaḏée-í. ");
INSERT INTO tew_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Heḏi híwó̖ˀ namuu kin ochá̖a̖-íḏí unbíˀpiyeˀ, hä̖̂ä̖ḏi wänbo tꞌä̖hkí naví píˀnä́ khóˀyé híhchandi unbí̖ˀgeḏi dáyˀánshaamáaḏí. Yôesi Táḏá navíˀpiyeˀ híwó̖ˀ nacha̖a̖ḏi wí tꞌôe dímä́gi dônˀa̖míḏí, heḏi undiḏá naa díkhä̖ge̖ˀmáa nä́ˀi tꞌôe dáyˀa̖míḏí. Nä́ˀin khä̖ge̖ˀ undi dímäˀ tobá opannä́n wänbo háa hä̖ˀin tsonninbí páaḏépiyeˀ owin wänbo Yôesi Táḏáví híwó̖ˀdi tu̖u̖ dônˀá̖yînmáˀve-íḏí heḏá dovâythayya̖míḏí taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Yôesi Táḏá ûnhanginná in taˀgen naa otû̖ˀnin, unbíˀpiyeˀ báyékí otaachanpoˀ. Háa Christ Jesus iví píˀnä́ khóˀyé naséegímuu waagibá naa wáˀ hanbá unbíˀpiyeˀ ocha̖a̖. ");
INSERT INTO tew_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Heḏiho nä́ˀin namuuḏi naaḏi wâyyûusuˀoˀ kin únpúwíḏí: Shánkí wänbo unbí séegí únsôe-í, heḏi iweḏá wíyá shánkí híwó̖ˀdi hangintandá kaˀpowa-á wovâymä̂äní. ");
INSERT INTO tew_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Kindiḏânho únhanginnání wéˀi wí híwó̖ˀdi namuuˀin heḏá wéˀi wí híwó̖ˀpîˀ namuuˀindá, heḏânho i híwó̖ˀpîˀ namuu iweḏi úvíyâaˀa̖mí, heḏiho owáy i thaa Christ nawáypówá ihayḏi yä̖ˀḏâaˀinda̖ˀ ímúní heḏá toˀwíḏí wänbo-á háˀto wovâytꞌeˀpꞌíḏe-í. ");
INSERT INTO tew_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Jesus Christ-dânho wovâykhä̖ge̖ˀnamí báyékí híwó̖ˀdi hä̖ä̖wí úvíˀâ̖a̖míḏí, heḏânho tꞌowaḏi Yôesi Táḏá kwꞌáayéboˀ óemáˀve-í, heḏá ditú̖ní hayˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Tíˀûuwin páaḏéˀin, naa odaˀ nä́ˀin únhanginnáníˀin: Háa naa dînpóe waagiḏi shánkí báyékí tꞌowa i híwó̖ˀdi tu̖u̖ Jesus-ví̖ˀgeḏi ditꞌoe, ");
INSERT INTO tew_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","heḏiho tꞌä̖hkí in á̖yí̖ˀnin sundaḏo nä́ˀi tsondiví tewhá iweˀin dimuuˀindá heḏá in wé̖ˀgeˀin tꞌowa nä́we dithaaˀindá dínhanginpóe naa Christ-gîˀ dáywänpitꞌôemáaḏíboˀ opannä́nnin. ");
INSERT INTO tew_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Heḏá naa opannä́nnin dínhanginnândiho tꞌä̖hkí waa in tíˀûuwin páaḏéˀin nä́ä Rome dithaaˀinbí whä̖yu̖ Naˀinbí Sedó Yôesivíˀpiyeˀ shánkí dínkaymän, heḏá nää inbí khuwôedaˀ dínhándeḏi Yôesi Táḏáví tu̖u̖ in tꞌowa shánkí ovâytꞌôeˀoˀ. ");
INSERT INTO tew_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","17","Wáy wên inbí ánshaa híwó̖ˀdi dínmuuḏiho Christ-ví̖ˀgeḏá tꞌowa ovâytꞌôeˀoˀ, heḏi indá naa díséegíḏí kin dívíˀoˀ, dínhanginnândi Yôesi Táḏáḏí naa dísógeˀin i híwó̖ˀdi tu̖u̖ Jesus-ví̖ˀgeḏi dóˀá̖yîngiˀa̖míḏí. Hewänbo wây-á wêndá naa díwänpithúumáaḏí heḏá ditu̖hä́ntꞌóeḏá in tꞌowa Christ-ví̖ˀgeḏi ovâytꞌôeˀoˀ, heḏiho pín taˀge hayḏi wíḏívíˀopí, indá ingîˀḏa̖ˀmân dívíˀoˀ. Diˀánde naa waˀ nä́ä pan dee oˀä́ndí shánkí wänbo tꞌôephaḏe iwe dítôeníˀin. ");
INSERT INTO tew_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Hewänbo háa indi díˀo wänbo wíḏíˀá̖yîngimähpí. Háa híwó̖ˀ háa híwó̖ˀpí divíˀánshaamáa wänboˀ, Christ-ví̖ˀgeḏi in tꞌowa ovâytꞌôeˀoḏá híwó̖ˀdi namuu, heḏiho shánkí wänbo naa díhíhchandoˀ. ");
INSERT INTO tew_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Heḏi waˀḏi híhchandiboˀ omúní. Un tꞌä̖hkíḏíbo naa dînyûusuˀoḏi, heḏá i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ Jesus Christ-di dímäˀiḏi naa díkhä̖ge̖ˀdoḏá, handiḏi dînhanginná tꞌä̖hkí híwó̖ˀ naa dînpuwagítꞌóeˀin. ");
INSERT INTO tew_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Hânho wên hä̖ä̖wên odaˀ, heḏi dáywhä̖yunde nä́ˀin odaˀin dînpuwagítꞌóeˀin, heḏi nä́ˀinnân in namuu: Háˀto hä̖ä̖wíḏí díwôedaˀmä̂äníˀi dáyˀa̖mí. Nää puˀwahay khuwôedaˀginpíḏíboˀ oyiˀ, heḏi nää ha̖ˀbibo omúníˀin odaˀ, heḏânho háa naví wówátsi donhon waagiḏi tꞌowa ditú̖níḏí Christ hayˀi namuuˀin, tobáháa owówáyiˀ háa díhay wänboˀ. ");
INSERT INTO tew_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Kinnân naagîˀ namuu: Christ-ân naví wówátsi waagiˀbá dînmuu, heḏi ochuuḏáho shánkí wänbo i-áḏí ocha̖ˀní. ");
INSERT INTO tew_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Hewänbo waˀḏi nä́ä oepáa kꞌayḏibo naví wówátsi dîntä̖ˀändáhoˀ, shánkí wänbo híwó̖ˀdi hä̖ä̖wí naví tꞌôe iweḏi dînpée-í, heḏiho naa wíḏînhanginnáhpí wéˀi wí dóde̖ˀmamíˀin, háa owówáyê̖e̖níˀin háa ochúu-íˀin. ");
INSERT INTO tew_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Naa wêegeˀin ánshaa-á donmáa. Nä́ä oepáa kꞌayḏiˀin wówátsi dóyoeˀa̖míˀin odaˀ Christ-áḏí ocha̖ˀníḏí, gá han dînpóeḏáho shánkí híwó̖ˀ naagîˀ namúníḏân. ");
INSERT INTO tew_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Hewänbo ungîˀ-áho shánkí natáy waˀḏi nä́äḏí dáywóyí̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Naa dînhanginná nä́ˀin wâytu̖máaˀin taˀgen namuuˀin, heḏiho wáˀ dînhanginná nä́äḏíbo dáywóyí̖ˀníˀin undáḏí owówáyê̖e̖níḏí, heḏânho unbí whä̖yu̖ únmuuˀi shánkí únkay-íḏí heḏá iweḏá shánká íhíhcha̖a̖-í, ");
INSERT INTO tew_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","heḏá owáy unbíˀwe wíyá opówá ihayḏá Christ-di shánkí báyékí wovâyhíhchanmä̂äní naa omuuḏi. ");
INSERT INTO tew_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Hewänbo tobáháa napóe wänbo híwó̖ˀnin wówátsi bînhûuwí, i híwó̖ˀdi tu̖u̖ Christ-ví̖ˀgeḏi natû̖ˀ waabá íthaa-íḏí. Kin únkhâyˀä̖ˀ úvíˀa̖míˀin heḏânho tobá unbíˀpiyeˀ opu̖wä̖mää wänbo háa omääpí wänboˀ, naa dînhanginnání kayˀindi íwinnin, heḏá unbí ánshaa-á unbí taachandá waˀḏi wêeḏa̖ˀ únmuuˀindá, heḏá i híwó̖ˀdi tu̖u̖ Jesus-ví̖ˀgeḏi tꞌowa dívíwhä̖yú̖-íḏí un wé̖ˀge úvísóˀḏíndeˀindá. ");
INSERT INTO tew_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","Toˀwên unbíˀpiyeˀ híwó̖ˀ dicha̖a̖píˀin hây wänbo wívînkhuwôedaˀípí. Íkhuwôedaˀpíˀin wovâymúndeḏi bînkeekwꞌôení indá dipeḏeemuuˀin, hewänbo undá Yôesi Táḏáḏânho wovâyˀaywoeníˀin. ");
INSERT INTO tew_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Yôesi Táḏáḏí wovâymäˀ Christ namuuḏi bîntꞌôephaḏé-íḏí, ivíˀpiyeˀ úvíwhä̖yú̖-íḏíḏa̖ˀbá yoe. ");
INSERT INTO tew_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Undiḏá naa ho dímûˀ háa wí Yôesi Táḏáví sundaḏo waagibá dáyhä́nboˀin, heḏá nää-á únhanginpóe waˀḏi hanbo dáyˀoˀin. Heḏá un wáˀ nää hanbá bînphaḏendeˀ. ");
INSERT INTO tew_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Christ-áḏí gimuuḏi gínkoeḏi wíˀnä́ táye ívíkweewaasenwaatu̖ˀâ̖a̖míḏí. Iḏi díséegíḏí gínkoeḏi wíˀnä́ táye ívíboˀaawówáˀa̖míḏí. I Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi díwóndeḏi gínkoeḏi wîˀḏa̖ˀ gimuu waabá gichá̖a̖-íḏí. Naˀinbí píˀnä́ khóˀyé gitaachanpoˀḏi gínkoeḏi wíˀnä́ táye ívísehkanähûuwíḏí. ");
INSERT INTO tew_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","Heḏiho únkhâyˀä̖ˀ wéhpêeḏa̖ˀ íˀánshaamúníˀin heḏá wíˀnä́ táye-á úvíséegíhûuwíˀin heḏá tꞌä̖hkí unbí hâ̖a̖-á unbí taachandá handa̖ˀ únmúníˀindá. Handiḏiho shánkí wänbo naa díhíhchanmä̂äní. ");
INSERT INTO tew_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Wên háawên wänbo ungîˀḏa̖ˀ, háa úvípitegé-íḏíḏa̖ˀ wíˀúvíˀâ̖a̖mípí, hewänbo áagé úvípikwꞌôení heḏá in wé̖ˀgeˀin tꞌowa-á unbí shánkí híwó̖ˀnin dimuu waagibá íchanpúwí. ");
INSERT INTO tew_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Wây-á wé̖ˀgeˀin tꞌowaví wówátsi bînˀá̖yîngimáˀve-í, unbîˀḏa̖ˀbá yoe. ");
INSERT INTO tew_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Háa Christ Jesus iˀánshaaˀan waabá un wáˀ únkhâyˀä̖ˀ hanbá úvíˀánshaaˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Tobá háa Yôesi Táḏá namuu waagiˀbá Christ wáˀ hä̖̂ä̖ḏi wänbo tꞌä̖hkí ha̖ˀbibá namuu wänboˀ, wínachanpóepí ûnkhâyˀä̖ˀin waˀḏi ha̖ˀbibo namúníˀin, ");
INSERT INTO tew_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","heḏiho napidaˀḏi iví hä̖ä̖wí tꞌä̖hkí iyoeˀan wí pantꞌôeˀi waagibá napáa-íḏí. Wí tꞌowa waagibá naˀaypu̖yä̖ heḏá wí tꞌowa waagibá-á iví wówátsi ihoˀ. ");
INSERT INTO tew_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Heḏáháˀ Yôesi Táḏá óeˀaˀginnandi iví wówátsi imä́giḏi wên phéˀwan deeḏi nachuu. ");
INSERT INTO tew_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Heḏi han iˀandi Yôesi Táḏáḏí shánkí kwꞌáye óesóge, heḏá natú̖ i-á toˀwên tꞌä̖hkíví shánkí hayˀi namuuˀin, ");
INSERT INTO tew_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","heḏiho tꞌä̖hkíḏíbo dívídéˀgendikwꞌôení Jesus óeˀaˀginmä̂äníḏí, tꞌä̖hkí oe makówá dikwꞌó̖ˀnindá, nä́ä oepáa kꞌayḏi i̖ˀge diyiˀindá, heḏá nan soge núugé dikwꞌó̖ˀnindáḏí, ");
INSERT INTO tew_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","heḏá tꞌä̖hkíḏíbo-á ditú̖ní Jesus Christ i shánkí pꞌóˀḏéḏîˀ namuuˀin, heḏi kindiḏi nakeepúwí Yôesi Táḏá hayˀi namuuˀin. ");
INSERT INTO tew_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Kꞌemaˀin, undáḏí oyiˀ ihayḏi hä̖̂ä̖ḏi wänbo tꞌä̖hkí naví híˀ dîntꞌóyandeˀ, heḏiho nää-á wáˀ tobá undáḏí wóˀyipí wänbo shánkí dîntꞌóyaaní. Yôesi Táḏáḏí wovâyˀaywon, heḏiho ihayḏa̖ˀ úvísóˀḏí̖ˀbe-í hä̖ä̖wí únkhâyˀä̖ˀiˀ úvíkanhûuwíḏí, heḏânho tꞌowa bînkeeya̖míḏí in wovâyˀaywonnin ímuuˀin. ");
INSERT INTO tew_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Yôesi Táḏá-ân unbí píˀnä́ khóˀyé únˀä́ndí iwebá itꞌôemáa, heḏá iḏáho wovâykhä̖ge̖ˀmáa heḏânho ídaˀíḏí háa i natsonpóe waa úvíkanhûuwíˀin, heḏá wáˀ wovâykhä̖ge̖ˀdoˀ kin úvíˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Tu̖tꞌayginpíḏíbo tu̖whä́npíḏíbo hä̖ä̖wí tꞌä̖hkí bînˀa̖mí. ");
INSERT INTO tew_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","Handiḏi tꞌowaḏi wíwovâytu̖u̖súuˀa̖mípí, heḏi unbí píˀnä́ khóˀyé-á yä̖ˀḏâaˀinda̖ˀ ímúní, heḏânho úvípikeekwꞌôení Yôesi Táḏáví ây taˀgendi ímuuˀin, heḏá yä̖ˀḏâaˀindá unbí wówátsi-á bînhûuwí tobá in híwó̖ˀpíˀin tꞌowaví yâa íthaa wänboˀ, indá in taˀgeˀin pꞌóegé namuupí i̖ˀgeḏa̖ˀ dimän. Oe makówá in agóyóḏí dînkoˀoˀ waagibá nakhâyˀä̖ˀ nä́ä oepáa kꞌayḏibo un wáˀ wí ko waagiˀinbá ímúníˀin, ");
INSERT INTO tew_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","i tu̖u̖ nawówátsipä̖yiˀiˀ in tꞌowa ovâyhondi. Kin úvíˀandá, owáy i thaa Christ nawáypówá ihayḏi naa dînkoeḏí-í híhchandi otú̖níḏí híwó̖ˀ dáyˀannin, heḏá wí ä̖ä̖ˀiˀ ikhä̖ä̖ḏe waagibá naa wáˀ ochanpúwí hânho dáykhä̖ä̖ˀin, heḏiho hä̖ä̖wí dáyˀandiˀ wíḏînpeḏeepí. ");
INSERT INTO tew_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Tꞌowaḏi animâa dâytꞌa̖há̖núˀin Yôesi Táḏá óemäˀ waagibá, undá ivíˀpiyeˀ úvíwhä̖yundeḏi unbí wówátsi-á ivíˀpiyeˀ úvímä́gi heḏá igîˀ úvítꞌôemáa. Maˀḏi naví ûnpꞌoe donchꞌâaní heḏânho unbí tꞌôe Yôesigîˀ únbowaḏée-íḏí, hebo tobá han dînpóe wänbo naa ohíhchanpoˀ, heḏá un wáˀ ki̖ˀmin híhchan bînmáˀve-íˀin odaˀ. ");
INSERT INTO tew_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Naa ohíhcha̖a̖ waagibá un wáˀ únkhâyˀä̖ˀ íhíhcha̖a̖-íˀin, heḏiho unbí híhchan oyä̖́mu-í. ");
INSERT INTO tew_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Naˀinbí Sedó Jesus natú̖ḏáho hanwaapíḏíbo Timothy unbíˀpiyeˀ dósaaní heḏânho háa íkwꞌó̖ˀnin dînhanginpúwíḏí heḏi kindiḏi naa oboˀaawówápúwí. ");
INSERT INTO tew_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Wíyá toˀwí wänbo i waagi naa-áḏí wínaˀä́npí. Iḏa̖ˀmân naˀá̖yîngiḏi taˀgendi unbí̖ˀgeḏi iˀánshaaˀoˀ. ");
INSERT INTO tew_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Tꞌä̖hkí in wé̖ˀgeˀin inbí wówátsi i̖ˀgeḏiḏa̖ˀ dívíˀánshaamáa, Christ Jesus-ví tꞌôe i̖ˀgeḏá yoe. ");
INSERT INTO tew_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Unbo únpihanginná Timothy-ḏá dînkeeyannin i-á taˀgendi báyékí nachä̖ˀpoˀin. Wí ay iví táḏá ikhä̖ge̖ˀdo waagibá, iḏá naa báyékí díkhä̖ge̖ˀnan i híwó̖ˀdi tu̖u̖ Jesus-ví̖ˀgeḏi ä́ntꞌôeˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Heḏiho owáy háa naa dînpuwagítꞌóeˀin dînhanginpóe ihayḏi, wesebo unbíˀpiyeˀ i dósaaní, ");
INSERT INTO tew_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","heḏi naví píˀnä́ khóˀyé ocha̖a̖ Naˀinbí Sedó Yôesiḏi hanwaapíḏíbo naa wáˀ unbíˀpiyeˀbá dípu̖hpä̖gítꞌóeˀin. ");
INSERT INTO tew_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Hewänbo naa ochanpoˀ nakhâyˀä̖ˀin Epaphroditus unbíˀpiyeˀ wesebo dówáysaaníḏí. Dînkhä̖ge̖ˀtáy ihayḏi undá navíˀpiyeˀ i dînsan, heḏi naagîˀ wí tíˀûu waagiˀbá namuu, naa-áḏá wé̖ˀgá äntꞌôeˀan, heḏá wíye sundaḏo wé̖ˀge änhä́nboḏi waagiˀinbá gamuu. ");
INSERT INTO tew_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Nää hânho un napu̖wä̖daˀ, heḏá natꞌoe un únhanginpóeˀin i-á nahayˀin, heḏi hä̖ˀindá óeˀá̖yîngimä́gi heḏiho unbíˀpiyeˀ dówáysaaní. ");
INSERT INTO tew_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Taˀgendi hânho nahaywän, chuwa kꞌáygého naˀä́nwän. Hewänbo Yôesi Táḏá ûnˀiyapóeḏí óehehkháamä́gi. Heḏi han iˀandi navíˀpiyeˀ wáˀ naˀiyapóe, heḏânho wíyá shánkí wänbo wóˀkꞌáykháapúwípíḏí. ");
INSERT INTO tew_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Heḏiho wíyá shánkí wóˀtsíkhadaˀpí unbíˀpiyeˀ dówáysaaníḏí, heḏânho i bînmúníḏí heḏá íhíhchanpúwíḏí, heḏi handiḏi naa-á ánshaa iwe wóˀcha̖ˀnípí. ");
INSERT INTO tew_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","I-á Naˀinbí Sedó Jesus-vîˀ namuuḏi híwó̖ˀ híhchandi bînséegíkéyí. I-áḏí heḏá toˀwên i waagiˀbá dimuuˀindáḏí bînˀaˀginnamí, ");
INSERT INTO tew_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","gá Christ-ví tꞌôe ônˀoḏi chuwa kꞌáygéhay napówáḏân, heḏá hä̖ä̖wí naagîˀ iˀandi i-á nakhâymuu iví wówátsi imä̂äníḏí. Nä́ˀi hä̖ä̖wí undá wíˀúnkoeḏipí dînˀa̖míḏí navíˀweḏi kayi̖ˀ diwe íkwꞌôndi. ");
INSERT INTO tew_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Tíˀûuwin páaḏéˀin, nää nä́ˀi wâytu̖ˀâ̖a̖mí: Naˀinbí Sedó Jesus-víˀin ímuuḏihoˀ úvíhíhchanmáˀve-í. Tobá nä́ˀi hä̖ä̖wí i̖ˀgeḏi wâyta̖ˀnan wänboˀ, kaykhan wíḏînpoˀpí inho wâyta̖ˀnanninbá nää wíyá wâyta̖ˀnamíḏí, heḏi nä́ˀi híˀ wâyta̖ˀdoˀiḏá wovâyˀaywoení. ");
INSERT INTO tew_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Úvíˀá̖yîngiˀâ̖a̖mí hä̖ˀin hôeyóˀin há̖hkannin dimuuˀinbíˀweḏi, indá yä̖ˀḏâapîˀḏa̖ˀ dívíˀoˀ, indá in Huḏíyoví kꞌewe̖ˀ taaḏi ovâytaaˀan wänbo nä́ˀin taa-á wên tsaa nachä̖ˀmuupíˀinda̖ˀmân inbí túuˀú dínmuu. ");
INSERT INTO tew_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Naˀinnân in taˀgen kꞌewe̖ˀ taa waagiˀinbá âymáaˀin gimuu, gá Yôesiví Pꞌoewa̖a̖hâ̖a̖ḏi naˀin díkhä̖ge̖ˀdoḏân Yôesi Táḏá âyˀaˀginmä̂äníḏí, heḏá naˀindá híhchandi gitû̖ˀ Christ Jesus-víˀin gimuuˀin, heḏá wíˀívíwhä̖yundepí hä̖ä̖wí wíˀbo ívíˀoˀiḏibo naˀin dînˀowóyé-íˀin. ");
INSERT INTO tew_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Maˀḏi wí toˀwí nachanpoˀ híwó̖ˀdi hä̖ä̖wí iˀoḏiboˀ ônˀowóyé-íˀin, hewänbo kinho nachanpóeḏáho naa-á dînkoeḏí-í iví shánkí ochanpúwíˀin i hä̖ä̖wí naa dáyˀandibo dînˀowóyé-íˀin. ");
INSERT INTO tew_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Naa-á khâave thaa ihayˀi omuuḏi in Huḏíyoví kꞌewe̖ˀ taaḏi dítaaˀan; naví táḏá-á yíyá-á Israel-ˀin dînmuu; wí Benjamin-bí ây iweḏiˀi-ân omuu, heḏânho wí koḏi̖ˀdi Hebrew omuu, heḏi Pharisee tꞌowabá omuuḏi in waagibá Moses-ví khuu tꞌä̖hkí dônhon; ");
INSERT INTO tew_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","heḏi pín taˀge hayḏi naví whä̖yu̖ khuu donhondi in Jesus-víˀpiyeˀ dívíwhä̖yundeˀin tꞌowa tꞌôephaḏe iwe dovâykwꞌóḏi. I tsontu̖u̖ Moses ita̖ˀnandiˀ tꞌä̖hkí dóˀaˀgindoḏi toˀwí wänbo wíˀûnkoeḏipí dîntꞌeˀpꞌíḏe-íḏí. ");
INSERT INTO tew_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Nä́ˀi hä̖ä̖wí namuuḏi naa dáyyêngiˀowän, hewänbo nää Christ dóséegíḏí nä́ˀi hä̖ä̖wí nachä̖ˀmuupí waabá dînchanpoˀ. ");
INSERT INTO tew_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Heḏi nä́ˀi hä̖ä̖wíḏa̖ˀbá yoe, hä̖ä̖wí tꞌä̖hkân nachä̖ˀmuupí waagibá dînchanpoˀ, gá nää-á Christ Jesus naví pꞌóˀḏéḏîˀ dînmuuˀi dontaaḏân, heḏi i-á shánkí híwó̖ˀdi namuu hä̖ä̖wí tꞌä̖hkívíˀweḏi. Heḏi nää Jesus dótaaḏi nä́ˀi wé̖ˀgeˀi hä̖ä̖wí dînpeḏee waagibá dócha̖a̖, heḏi nä́ˀi hä̖ä̖wí-á phéˀyä̖́vi whée óechaˀgítꞌóeˀiḏa̖ˀ waagiˀbá namuu gin otú̖ní heḏânho Christ shánkí híwó̖ˀ dótaa-íḏí. ");
INSERT INTO tew_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","Naa odaˀ Christ-áḏí wîˀḏa̖ˀ gamúníˀin heḏânho Yôesi Táḏáḏí dícha̖a̖máˀve-íḏí tꞌaywó̖ˀdi wíḏómáapí waagi. Hewänbo háˀto kin dícha̖a̖-í i tsontu̖u̖ Moses ita̖ˀnandiˀ dóˀaˀginnamíḏí dáykhä̖ä̖ḏeḏiboˀ, hewänbo Christ-víˀpiyeˀ dáywhä̖yundeḏân, gá Yôesi Táḏá natû̖ˀdân in toˀwên Christ-víˀpiyeˀ dívíwhä̖yundeˀinnân iḏi ovâycha̖a̖máa tꞌaywó̖ˀdi wíḏâymáapí waagi. ");
INSERT INTO tew_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Naa odaˀ taˀgendi Christ dótaa-íˀin. I-á nawáywówápóeḏí in kay imáaˀin napä̖yiˀ, heḏi naa odaˀ nä́ˀin kaybá dímä̂äníˀin dómáˀve-íḏí. Heḏá i-á itꞌôephaḏe waagibá naa wáˀ hanbá dontꞌôephaḏé-íˀindá odaˀ, heḏá háa i namuu waagibá nachuu ihayḏi, naa wáˀ hanbá omúníˀindá odaˀ, ");
INSERT INTO tew_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","heḏânho tobáháa napóe wänboˀ owáy naa ochuu ihayḏi owáywówápúwí. ");
INSERT INTO tew_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Naa wóˀtû̖ˀpí Christ ho dótaaˀin háa dînkhâyˀä̖ˀ waa, heḏi naa wóˀtû̖ˀpí ho opóeˀin háa dînkhâyˀä̖ˀ omúní waagi, hewänbo ha̖ˀbi opúwíḏí ihayḏa̖ˀ dáykhä̖ä̖ḏeˀ i dîntáyˀi donhóníḏí, gá hangîˀ-ân Christ Jesus-diḏá ho naa díkêˀḏân. ");
INSERT INTO tew_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Tíˀûuwin páaḏéˀin, wíˀochanpoˀpí tꞌä̖hkí hä̖ˀi dîntáyˀi ho donhógiˀin, hewänbo nä́ˀinda̖ˀ dáyˀoˀ: Háa ho dînpóeˀindá dáyˀannindá i̖ˀgeḏi wíḏáyˀánshaaˀopí, hewänbo shánkíḏí háa dáykhâymáa i̖ˀgeḏân dáyˀánshaakanhon. ");
INSERT INTO tew_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Wí ä̖ä̖ˀiˀ páaḏébo napówá-íḏí ikhä̖ä̖ḏe waabá naa wáˀ dáykhä̖ä̖ḏe heḏânho hä̖ä̖wí Yôesi Táḏáḏí dímä̂äníˀin otꞌanpúwíḏí. Heḏi kinnân iḏi dînkhâymáa: Christ Jesus naagîˀ iˀannin namuuḏi Yôesi Táḏáḏí makówápiyeˀ dítu̖kánkhâymáa. ");
INSERT INTO tew_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Tꞌä̖hkíḏíbo hangintan dâymáaḏí taˀgendi dikweesenpaaˀindá dínkhâyˀä̖ˀ dívíˀánshaamä̂äníˀin nä́ˀi otú̖ˀi híwó̖ˀdi namuuˀin. Heḏi wí toˀwí hây piháa iˀánshaamáaḏá, Yôesi Táḏáḏí nä́ˀin wänbo ônthaykꞌúwí. ");
INSERT INTO tew_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Heḏiho in nähayḏi gihá̖hpóeˀinbá ívíkanhondi, hanbá naˀinbí wówátsi âyhûuwí. ");
INSERT INTO tew_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Tíˀûuwin páaḏéˀin, háa naa naví wówátsi donhon waabá un wáˀ tꞌä̖hkí hanbá unbí wówátsi bînhûuwí. In toˀwên yä̖ˀḏâaˀin wówátsi dâyhonnin háa wâykeeyan waagibá híwó̖ˀ bînmúní, heḏi háa dívíˀo waa un wáˀ hanbá úvíˀâ̖a̖mí. ");
INSERT INTO tew_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Hä̖́yä́n wänbo wâytu̖ˀan heḏi nää-á séeˀindiḏá wíyá wâytu̖máa, báyékí tꞌowa háa inbí wówátsi dâyhon diweḏi nakeepoˀ dâyyoegimáaˀin háa Christ-di naˀingîˀ dînˀan waa phéˀwan deeḏi nachuu ihayḏi. ");
INSERT INTO tew_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Indáho péyégépiyeho dimän. Yôesi dâyˀaˀginmä̂änívíˀweḏi húukandá su̖wä̖-á i̖ˀgeḏi shánkí dívíˀánshaaˀoˀ. Hä̖ä̖wí wôedaˀwó̖ˀdi dívíˀoˀ i̖ˀgeḏá dívíyêngihéeˀoˀ. Indá i hä̖ä̖wí nä́ä oepáa kꞌayḏiwi i̖ˀgeḏiḏa̖ˀ dívíˀanshaamáa. ");
INSERT INTO tew_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Hewänbo naˀindáho makówá i̖ˀgeḏá ívíˀánshaaˀoˀ, gá iwá naˀinbí ú̖wä̖́nä́ waagibá gínnândân, heḏiho pín taˀge hayḏi âytsíkhaˀmáa naˀinbí aywondi gínmuuˀiˀ iweḏi gínwáyˀä̖ä̖-íḏí, i-á Naˀinbí Sedó Jesus Christ namuu, ");
INSERT INTO tew_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","heḏi i-áho in kay imáaḏí naˀinbí túuˀú kaypîˀ gínmuuˀi gínchuwagítꞌóe wänbo dînˀegókhâymáaḏáháˀ tsꞌa̖a̖bi dînpakhâymáa, háa ivîˀ ûnmuu waagibá nawówápóe waaboˀ. I-áho hä̖ä̖wí tꞌä̖hkí i̖ˀgeḏi natsonyiḏi ûnkoeḏi kin iˀa̖míḏí. ");
INSERT INTO tew_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Heḏiho naví tíˀûuwin páaḏéˀin, Naˀinbí Sedó Yôesivíˀpiyeˀ kayˀindi úvíwhä̖yu̖hûuwí. Naaḏá un báyékí wâyséegíḏí wâymúníˀin odaˀ. Undiḏá naa díhíhchandoˀ, heḏi hä̖ä̖wí dáyˀandi otꞌanpóeˀi waagiˀinbá ímuu gin wâycha̖a̖. ");
INSERT INTO tew_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Euodia-áḏí Syntyche-áḏí kaygi̖ˀdi dovä̂ntu̖máa dänwóení heḏi wîˀ dänpáa-í, indáho Naˀinbí Sedó Jesus-víˀin wí̖ˀgín damuuḏi. ");
INSERT INTO tew_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Heḏá u̖ taˀgendi naa-áḏí bitꞌôeˀoˀiˀ unmuuḏi, wídaˀmáa nä́ˀin kwiyä̖ˀ ovä̂nkhä̖ge̖ˀnamíḏí wîˀ dapúwíḏí, indá däntꞌôeˀoˀ i híwó̖ˀdi tu̖u̖ Jesus-ví̖ˀgeḏi tꞌowa dä̂ntꞌôeˀa̖míḏí. Heḏá Clement-dáḏí wây-á wé̖ˀgeˀindáḏí hanbá dívítꞌôeˀoˀ, inbí khá̖wä̖́-áho in ta̖ˀnin diwe dínta̖ˀmuu, iwe natû̖ˀ toˀwên dimuu in wówátsi nahándepíˀin dâymáaˀin. ");
INSERT INTO tew_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Naˀinbí Sedó Jesus-víˀin ímuuḏi hä̖̂ä̖ḏi wänbo tꞌä̖hkí úvíhíhchanmáˀve-í, heḏá wíyá hanbá wâytu̖ˀâ̖a̖mí, úvíhíhchanmáˀve-í. ");
INSERT INTO tew_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Tꞌä̖hkí tꞌowa-áḏí híwó̖ˀda̖ˀ ímúní, Naˀinbí Sedó Jesus-áho hanwaapíḏíbo naˀä̖ḏi. ");
INSERT INTO tew_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","Báyékí ánshaa iwe wíˀíkwo̖ˀnípí, hewänbo hä̖ä̖wí tꞌä̖hkí i̖ˀgeḏi úvíyûusuˀâ̖a̖mí-á, heḏá Yôesi Táḏá-á hä̖ä̖wí úntáyˀi bîndaaˀa̖mí, heḏi kin úvíˀoḏi bînkú̖ˀdaaˀâ̖a̖mí wáˀ. ");
INSERT INTO tew_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Yôesi Táḏáḏí díkhä̖ge̖ˀdoˀ ánshaaginpíḏíbo gikwo̖ˀníḏí, tobá naˀin tꞌowaḏa̖ˀ gimuuḏi wígínhanginnáhpí wänbo háa kin dînˀoˀin. Heḏi kin wovâyˀoḏi tꞌä̖hkí unbí píˀnä́ khóˀyé bînmáaˀi-á unbí hangintandá wovâyˀá̖yînmáˀve-í, Christ Jesus wé̖ˀge ímuuḏi. ");
INSERT INTO tew_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Tíˀûuwin páaḏéˀin, nä́ˀi-á naví tꞌä̖ˀgiḏi híˀ unbíˀpiye dînmuu: Hä̖̂ä̖ḏi wänbo tꞌä̖hkí nä́ˀi hä̖ä̖wí i̖ˀgeḏi úvíˀánshaaˀâ̖a̖mí: hä̖ä̖wí taˀgen namuuˀindá naˀaˀginmuuˀi-á, in taˀgeˀin pꞌóegé i̖ˀge wovâyhondi-á, i yä̖ˀḏâaˀi namuuˀi-á, naséegímuuˀi-á, tꞌowa tꞌä̖hkí ovâyhí̖ˀandi-á, i shánkí híwó̖ˀdi namuuˀi-á, heḏá i̖ˀgeḏi tꞌowa híwó̖ˀ dívíhéeˀoˀi-á. ");
INSERT INTO tew_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Naví híˀ ítꞌoe heḏá naví tsiyekan dînmûˀ, heḏiho tꞌä̖hkí navíˀweḏi íhá̖hpóeˀi-áḏí i há̖hkan navíˀweḏi bînhógiˀi-áḏí ihayḏa̖ˀ úvíkanhûuwí, heḏi kin úvíˀoḏá Yôesi Táḏá undáḏí nayê̖e̖ní, iḏá díkhä̖ge̖ˀdoˀ ánshaaginpíḏíbo gikwo̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Tobá híwó̖ˀ hay thaa naphaḏe wänbo nää undi wíyá naa díˀánshaamáa díkhä̖ge̖ˀnamíḏí, heḏi handiḏân Naˀinbí Sedóḏi báyékí híhchan naa dímä́gi. Naa dînhanginná taˀgendi naví̖ˀgeḏi ho úvíˀánshaaˀoˀin, hebo nää puˀwahayḏi wíˀúnkoeḏipí háa ícha̖a̖ˀin dînkeeya̖míḏí. ");
INSERT INTO tew_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Naa dînhä̖ä̖wítáyˀin wóˀtû̖ˀpí. Ohá̖hpóe ohíhcha̖a̖-íḏí tobá hä̖́yú̖ dînkwꞌôn wänboˀ. ");
INSERT INTO tew_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Naa dînhanginná naví wówátsi donhûuwíˀin wí sehkanäwó̖ˀ nawówáyiˀi waagibá háa wí koḏitꞌowa namuuˀi waagibá. Naa ohá̖hpóe háḏíḏí ohíhchanpúwíˀin, tobá híwó̖ˀ dáyhúuyo háa oha̖hsên wänboˀ, tobá báyékí dînkwꞌôn háa hä̖ä̖wí dîntáy wänboˀ. ");
INSERT INTO tew_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Christ-di in kay dímäḏiho nä́ˀi hä̖ä̖wí tꞌä̖hkí dînkoeḏi dáyˀa̖míˀin. ");
INSERT INTO tew_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Hewänbo tobá hä̖ä̖wí tꞌä̖hkí dîntáyˀi dómáa waabá ocha̖a̖ wänboˀ, undá navíˀpiyeˀ híwó̖ˀnin ímuu díkhä̖ge̖ˀnandi waˀ nä́we dontꞌôephaḏendeḏiboˀ. ");
INSERT INTO tew_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Un Philippians, unbo nä́ˀi únhanginná: Oe Macedonia nange iweḏi opáaḏépee ihayḏi i híwó̖ˀdi tu̖u̖ Jesus-ví̖ˀgeḏi tꞌowa dovâytꞌôeˀa̖míḏí, undiḏa̖ˀmân hä̖ä̖wí naa díyä̖́mú, wây-á méesate iweˀindiḏá yoe, undiḏa̖ˀmân dînchä̖ˀsan. ");
INSERT INTO tew_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Oe Thessalonica búuˀú wänbo oˀä́ndí dînkhä̖ge̖ˀtáy ihayḏi undi wáymûuví shánkí hä̖ä̖wí dînsan. ");
INSERT INTO tew_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Wíˀíˀâ̖a̖nípí nää wâydaˀmáaˀin wíyá hä̖ä̖wí dímä̂äníḏí, hewänbo odaˀ unnânho báyékí híwó̖ˀdi bînhóníˀin Yôesivíˀweḏi, wí toˀwí iví tꞌôe iweḏi báyékí wáˀâa ihónde waagibá. ");
INSERT INTO tew_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Nää-á hä̖ä̖wí dîntáyˀi-á heḏá shánkí wänbo dîntáyˀivíˀweḏi dómáa. Nä́ˀi báyékí hä̖ä̖wí-á dómáa gá Epaphroditus-di hä̖ä̖wí undi dînsandiˀ dînkándân. Tꞌowaḏi hä̖ä̖wí saˀwó̖ˀ nasu̖u̖ˀi-áḏí heḏá animâa dâyhá̖núˀindáḏí Yôesi Táḏá ônhon óemä̂äníḏí, heḏi i-á iséegíhógiḏi nahíhchanpoˀ. Heḏi hanbá nä́ˀi hä̖ä̖wí undi naa dînsandiḏá wáˀ Yôesi Táḏá óehíhchandoˀ. ");
INSERT INTO tew_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Heḏiho Christ Jesus-víˀin ímuuḏi naví Yôesiḏiho hä̖ä̖wí un úntáyˀi wovâymä̂äní iví báyékí híwó̖ˀdi hä̖ä̖wí ûnkwꞌó̖ˀ diweḏi. ");
INSERT INTO tew_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Hä̂nhay wänbo tꞌä̖hkí naˀinbí Yôesi kwꞌáayéboˀ âymáˀve-í, i-á naˀinbí Táḏá gínmuu. Hamân. ");
INSERT INTO tew_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","22","Yôesi Táḏáví tꞌowa tꞌä̖hkí ovâysengitu̖ˀâ̖a̖mí, indá Christ Jesus-víˀin dimuuḏi. In tíˀûuwin páaḏéˀin naa-áḏí diyiˀindá heḏá tꞌä̖hkí in wé̖ˀgeˀin Yôesi Táḏáví tꞌowa nä́ä dikwꞌó̖ˀnindá wovâysengitu̖ˀan, i tsondi Caesar-ví tewhá ee dikwꞌó̖ˀnindi shánkí wänboˀ. ");
INSERT INTO tew_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Naˀinbí Sedó Jesus Christ-ví séegísehkanä unbí píˀnä́ khóˀyé bînmáˀve-í.");
INSERT INTO tew_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Naˀin Paul-á Silas-á heḏá Timothy-á gimuuˀindi un méesateˀin tꞌowa oe Thessalonica búuˀú íthaaˀin wâyta̖ˀdoˀ, undá Yôesi naˀinbí Táḏávíˀin heḏá Naˀinbí Sedó Jesus Christ-víˀindá ímuu. Yôesiví séegísehkanä bînmáˀve-í, heḏi iḏi wovâykhä̖ge̖ˀnamí ánshaaginpíḏíboˀ íkwo̖ˀníḏí. ");
INSERT INTO tew_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Hä̖̂ä̖ḏi waa ívíyûusuˀoˀ ihayḏi Yôesi Táḏá âykú̖ˀdaaˀoˀ un ímuuḏi, ");
INSERT INTO tew_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","heḏi Yôesi naˀinbí Táḏávíˀpiyeˀ ívíhá̖ḏíndeḏi ívíyûusuˀa̖míḏí hä̖̂ä̖ḏi wänbo tꞌä̖hkí ívíˀánshaaˀoˀ háa úvíˀoˀin Jesus-víˀpiyeˀ úvíwhä̖yundeḏi, heḏá háa báyékí úvítꞌôemáaˀindá Jesus bînséegíḏí, heḏá háa úvíyä̖́ä̖ˀoˀindá Naˀinbí Sedó Jesus Christ nawáyˀä̖ä̖-íḏí úvítsíkhaˀmáaḏí. ");
INSERT INTO tew_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Tíˀûuwin páaḏéˀin, un Yôesi Táḏáḏí wovâyséegíˀin, gínhanginná iḏi wovâyde̖ˀmannin ivíˀin ímúníḏí. ");
INSERT INTO tew_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Yôesi Táḏáví híwó̖ˀdi tu̖u̖ naˀindi wâymä́giˀi tu̖u̖ḏa̖ˀ wínamuupí, hewänbo hä̖ä̖wí kayˀi namuu, heḏi wâytꞌôeˀoḏi i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ naˀindáḏí nayiˀ, heḏi gínhanginná nä́ˀi tu̖u̖-á taˀgen namuuˀin. Undá únhanginná háawin wówátsi âyhonnin undáḏí giyiˀ ihayḏi, heḏi tꞌä̖hkí ívíˀandi-á ungîˀḏa̖ˀ namuu. ");
INSERT INTO tew_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Heḏi ihayḏi úvísóˀḏêe naˀin waagiˀinbá heḏá Naˀinbí Sedó Jesus waagiˀbá-á ímúníḏí, heḏi tobáháa báyékí tꞌôephaḏe únpówá wänboˀ, i Yä̖ˀḏâaˀi Pꞌoewa̖a̖hâ̖a̖ḏi híhchan wovâymä́gi naˀinbí tu̖u̖ dînhógi ihayḏi. ");
INSERT INTO tew_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Heḏiho tꞌä̖hkí in wé̖ˀgeˀin Jesus-víˀpiyeˀ dívíwhä̖yundeˀin oe Macedonia nange heḏá Greece nangá dikwꞌó̖ˀnin undá bînkeeyan háawin wówátsi in dínkhâyˀä̖ˀ dâyhûuwíˀin. ");
INSERT INTO tew_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","I tu̖u̖ Naˀinbí Sedó Jesus-ví̖ˀgeḏi thayˀeeḏi unbíˀweḏi napeeḏi oe Macedonia-piyeˀ heḏá Greece-piyá nawaḏeḏee, hewänbo iwepiyeḏa̖ˀbá yoe, wéngé tꞌä̖hkí tꞌowa ho ditꞌoe háa Yôesivíˀpiyeˀ úvíwhä̖yundeˀin, heḏiho wínatáypí wíyá háawên unbí whä̖yu̖ i̖ˀgeḏi âytu̖ˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Hä̖ˀin tꞌowabo unbí̖ˀgeḏi ditû̖ˀ háa undi naˀin díséegíˀannin, heḏá háa hä̖ä̖wí bînkhíyéḏí unbí yôesi waa bîncha̖a̖ˀi bînyoeˀannin Yôesivíˀpiyeˀ úvíwhä̖yú̖-íḏí, heḏá háa nää-á i koḏi̖ˀdi Yôesi bînˀaˀginmäˀin, i-á i taˀgendi nawówáyiˀi namuu, ");
INSERT INTO tew_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","heḏá wáˀ ditꞌoe háa nää iví ay ûnmuuˀi bîntsíkhaˀmáa makówáḏí nawáyˀä̖ä̖-íḏí, i-á Jesus namuu, i Yôesi Táḏáḏí óewáywówápaaˀiˀ, heḏi iḏibá dînˀaywonkhâymáa owáy ihay thaa Yôesi Táḏáḏí tꞌowa ovâytuchä̖nu iwe, inbí tꞌaywó̖ˀdi dínmuuḏi natꞌayḏi. ");
INSERT INTO tew_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Tíˀûuwin páaḏéˀin, únhanginná unbíˀwe giyiˀ ihayḏi háa ívíˀan waa wínapeḏeepí. ");
INSERT INTO tew_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Undá únhanginná unbíˀwe gipówápíḏíbo báyékí dítꞌôephaḏekannannin heḏá báyékí híwó̖ˀpîˀ naˀin díhéeˀannindá oe Philippi búuˀú. Hewänbo tobáháa báyékí tꞌowaḏi díˀahkhâaˀa̖míˀin didaˀ wänbo naˀinbí Yôesiḏi khuwôedaˀ dînyâaˀan iví híwó̖ˀdi tu̖u̖ wâytu̖ˀâ̖a̖míḏí. ");
INSERT INTO tew_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Naˀindi wâywhä̖yu̖ˀa̖míḏí ívísóˀḏíndeˀ ihayḏi, in taˀgen namuu iweḏi wíˀívíhângeˀanpí, heḏá naˀinbí ánshaa-á yä̖ˀḏâapîˀ wígínmuupí, heḏi hä̖ä̖wí wänbo unbíˀweḏi wíˀâykaayanpí. ");
INSERT INTO tew_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Yôesi Táḏáḏí naˀin dítayi̖ˀ, heḏá dímûˀ ihay híwó̖ˀnin gimuuˀin iví híwó̖ˀdi tu̖u̖ âytꞌôeˀa̖míḏí. Heḏiho ívíhíˀmáaḏí wíˀívísóˀḏíndepí tꞌowa âywänpihíhchannamíḏí, hewänbo Yôesi Táḏá-ân âyhíhchannamíḏân. I-áho hä̖ä̖wí tꞌä̖hkí naˀinbí píˀnä́ khóˀyé âymáaˀiˀ imúndeˀ. ");
INSERT INTO tew_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Un únhanginná saˀwó̖ˀgí unbí̖ˀgeḏi wíˀívíwänpihéeˀanpí, heḏá wáˀ wíˀívíhôeyóˀanpí undi hä̖ä̖wí dímä̂äníḏí. Yôesi Táḏá ûnhanginná nä́ˀindá in taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Heḏá undáḏí giyiˀ ihayḏá wíˀívísóˀḏíndepí tꞌowa naˀinbí̖ˀgeḏi híwó̖ˀ dívíhéeˀa̖míḏí, un wänbo-á háa wây-á toˀwên wänbo-á yoe, tobáháa Christ-ví tꞌôekhuwaˀin gimuuḏi gínkꞌóe wänbo heˀennin dípaa-íḏí. ");
INSERT INTO tew_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Hewänbo naˀin undáḏí giyiˀ ihayḏi, wí yíyá iví áyyä̖̂ä̖ itsä̖ä̖ˀoḏi ovâyˀá̖yînmáa waagibá wâysehkanäˀan. ");
INSERT INTO tew_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Naˀindi báyékí wâydaˀ, heḏi naˀinbí séegí unbíˀpiyeˀ gínmuuḏânkun gikhâymuu Yôesi Táḏáví híwó̖ˀdi tu̖u̖ wâymä̂äníḏíḏa̖ˀbá yoe, hewänbo naˀinbí wówátsi wáˀ. ");
INSERT INTO tew_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Tíˀûuwin páaḏéˀin, ti wíˀúnˀánshaapíˀan, undáḏí gikwꞌó̖ˀ dihayḏi báyékí ívítꞌôeˀan. Yôesi Táḏáví híwó̖ˀdi tu̖u̖ wâytu̖u̖phaḏendeˀ ihayḏibá khu̖u̖-á thaa-á ívítꞌôeˀan wáˀ âychä̖ˀtꞌaaníḏí, heḏânho un wíˀbo wíˀúntâynípí hä̖ä̖wí gíntáyˀi dímä̂äníḏí. ");
INSERT INTO tew_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Un Christ-víˀpiyeˀ úvíwhä̖yundeˀindáḏí naˀin gikwꞌó̖ˀ dihayḏi, háa naˀinbí wówátsi âyhon waagi yä̖ˀḏâaˀindá taˀgeˀindá gínmuu, heḏá toˀwí wänbo-á wíˀûnkoeḏipí wên háawên wänbo naˀinbíˀpiyeˀ dîntꞌeˀpꞌíḏe-íḏí. Un únhanginná heḏá Yôesi Táḏá wáˀ ûnhanginná nä́ˀin in taˀgen namuuˀin. ");
INSERT INTO tew_vpl VALUES ("H12_11","082_2_11","1TH","2","11","12","Heḏá wáˀ un únhanginná wí̖ˀínbo wâyhéeˀannin, heḏi naˀindi wâytumakheˀan wí táḏá iví áyyä̖̂ä̖ ihéeˀo waagibá, heḏá wâykweewaasenwaatu̖ˀan, heḏá kaygi̖ˀdiḏá wâyhéeˀan unbí wówátsi híwó̖ˀ bînhûuwíḏí heḏânho Yôesi Táḏá nahíhcha̖a̖-íḏí. Iḏânho wóvâytu̖kánnan ivíˀpiyeˀ íˀä̖ä̖-íḏí makówápiyeˀ ímu-íḏí heḏá iwá heˀennin ípúwíḏí. ");
INSERT INTO tew_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Heḏi wíyá hä̖ä̖wí namuuḏi wáˀ Yôesi Táḏá hä̖̂ä̖ḏi wänbo tꞌä̖hkí âykú̖ˀdaaˀoˀ. Nä́ˀi tu̖u̖ wâytu̖máaˀiˀ un ítꞌoeḏi heḏá bînséegíˀandá Yôesivíˀweḏi naˀä̖ä̖ˀin úvíwhä̖yu̖, tꞌowavíˀweḏiḏa̖ˀbá yoe. Heḏi taˀgendi Yôesiví tu̖u̖-ân ûnmuu, heḏi nä́ˀi tu̖u̖bá un ipiyeˀ úvíwhä̖yundeˀinbí píˀnä́ khóˀyé itꞌôemáa. ");
INSERT INTO tew_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Tíˀûuwin páaḏéˀin, háa in Judea nangewin méesateˀin tꞌowa Yôesi Táḏá óeˀaˀginmäˀin heḏá Christ Jesus-víˀpiyá dívíwhä̖yundeˀin dínpóe waagibá un hanbá únpóe. Unbí ówîngeˀin tꞌowaḏibo wovâytꞌôephaḏekannan in Huḏíyoḏi inbí tꞌowa oe Judea ovâytꞌôephaḏekannan waagibá. ");
INSERT INTO tew_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","In Huḏíyoḏânkun hä́nˀoe Yôesi Táḏáví tukhe̖ˀmin ovâyhá̖nú, heḏá indibá Naˀinbí Sedó Jesus óehay, heḏá naˀindá wáˀ díkhe̖hpiye. Indiḏá Yôesi Táḏá hây wänbo wíˀóehíhchandopí, heḏá toˀwên tꞌä̖hkí dâyyoegiˀoˀ. ");
INSERT INTO tew_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Dívísóˀḏêe díˀahkhâa-íḏí in Huḏíyo dimuupíˀin tꞌowa háḏíḏí ovâyˀaywoeníˀin wíˀâytꞌôeˀâ̖a̖mípíḏí, heḏi handiḏi nä́ˀin Huḏíyoví tꞌaywó̖ˀdi dínsôemän, heḏiho Yôesi Táḏá inbíˀpiyeˀ natꞌayḏi nää inbí tuchä̖nu ho dínpówá. ");
INSERT INTO tew_vpl VALUES ("H12_17","082_2_17","1TH","2","17","18","Tíˀûuwin páaḏéˀin, unbíˀweḏi wí hây tä̖hkí giwiyeḏee, hewänbo tobá undáḏí wígikwꞌó̖hpí wänbo waˀḏi naˀinbí píˀnä́ khóˀyé unbí̖ˀgeḏi wâyˀánshaamáa, heḏiho hânho wíyá wâymúníˀin gidaˀ, heḏi unbíˀpiyeˀ gimú-íḏí ívísóˀḏíndeˀ. Naa Paul hä̖́yä́nbo dáysóˀḏêe wâymúníḏí, hewänbo i Penísendiḏi díˀahkhándeˀ. ");
INSERT INTO tew_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Owáy Naˀinbí Sedó Jesus nawáyˀä̖ä̖ḏi iví páaḏépiyeˀ giwin dihayḏi, gitsíkha unnân iwebá wâymúníḏí, heḏá un ímuuḏá gihíhchangítꞌóe, heḏá unbí̖ˀgeḏá ívíyêngihéeˀa̖mí, wí hä̖ä̖wí gitꞌanpóeˀiˀ ímuu waagibá. ");
INSERT INTO tew_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Un ímuuḏânkun naˀin hânho híwó̖ˀ gichanpoˀ heḏá ívíhíhchandoˀ. ");
INSERT INTO tew_vpl VALUES ("H13_1","082_3_1","1TH","3","1","3","Naˀin hânho gihanginˀândaˀ háa un únpoˀin, heḏi báyékí gitaachanpóeḏí wígitsíkhakandaˀpí gínhanginpúwíˀin, heḏânho giˀân shánkí híwó̖ˀ namúní kinnân ívíˀa̖míˀin: Naa oe Athens oˀä́n dihayḏi iwebo dáywóyí̖ˀ, heḏi iweḏi naˀinbí tíˀûu páaḏéˀi Timothy unbíˀpiyeˀ âysan, i-á naˀindáḏí itꞌôeˀoˀ tꞌowa ovâytꞌôeˀa̖míḏí Yôesi Táḏáví híwó̖ˀdi tu̖u̖ Christ-ví̖ˀgeḏi. Heḏiho unbíˀpiyeˀ i wâysan wovâykweewaasenwaatu̖ˀâ̖a̖míḏí heḏá wovâykhä̖ge̖ˀnamíḏí shánkí kayˀindi Christ-víˀpiyeˀ úvíwhä̖yú̖-íḏí, heḏânho i tꞌôephaḏe únpóeˀiˀ namuuḏi wíˀúvíyâaˀa̖mípíḏí unbí whä̖yu̖ iweḏi. Unbo únpihanginná Yôesi Táḏáḏí nä́ˀi tꞌôephaḏe dînpúuwíˀin imäˀ. ");
INSERT INTO tew_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Waˀḏi undáḏí giyiˀ ihayḏibo waˀ napóepíḏíboˀ ihayḏa̖ˀ wâytu̖ˀoˀ âytꞌôephaḏegítꞌóeˀin, heḏi únhanginná hanho napóeˀin. ");
INSERT INTO tew_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Heḏânkun báyékí otaachanpóeḏí wíḏîntsíkhakoeḏipí Timothy unbíˀpiyeˀ dósaaníḏí. Naa hânho ohanginˀândaˀ unbí whä̖yu̖ i̖ˀgeḏi háa kayˀin únmuuˀin háa yoe. Á̖yîngi iwe oˀä́nwän gá oˀândân háḏíwáy i Penísendiḏi wovâytꞌannin, heḏi wovâytꞌandá hä̖ä̖wí tꞌä̖hkí ungîˀ ívíˀandi peḏeeˀin gínpúwí. ");
INSERT INTO tew_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Hewänbo nää-á Timothy naˀinbíˀwe nawáypówá, heḏi wí híwó̖ˀdi tu̖u̖ úvíkanhon niˀgeḏi dînkán. Iḏi dítu̖ˀan unbí whä̖yu̖ waˀḏi únkayˀin heḏá séegí-á bînmáaˀin, heḏá hä̖̂ä̖ḏi wänbo tꞌä̖hkí naˀinbí̖ˀgeḏi híwó̖ˀda̖ˀ úvíˀánshaamáaˀin, heḏá taˀgendá ídaˀin wíyá díwáymúníˀin, naˀindi wâymúníˀin gidaˀ waagibá. ");
INSERT INTO tew_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Heḏânho tíˀûuwin páaḏéˀin, waˀḏi híwó̖ˀbo úvíwhä̖yundeˀin gínhanginpóe ihayḏi báyékí gihíhchanpóe, tobáháa báyékí kâyˀi tꞌôephaḏe iwe gikwꞌôn wänboˀ. ");
INSERT INTO tew_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Nää gínhanginná unbí whä̖yu̖ Naˀinbí Sedó Jesus-víˀpiyeˀ kayˀin únmuuˀin, heḏiho hânho saˀwó̖ˀ naˀinbí wówátsi âyhon. ");
INSERT INTO tew_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Naˀindi Yôesivíˀpiyeˀ wâyyûusuˀoḏi hânho gihíhchanpoˀ, heḏiho u