﻿USE sofia;
DROP TABLE IF EXISTS sofia.tet_vpl;
CREATE TABLE tet_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tet_vpl WRITE;
INSERT INTO tet_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Uluk fohon, Maromak naseꞌi laleꞌan no raiklaran. ");
INSERT INTO tet_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Raiklaran sei la dadi dauk, sa-saa hotu-hotu sei nahutan karin. Wee mak iha, mais nakukun luri taka nola tomak. Maromak Kmalar laleok iha wee fohon nia. ");
INSERT INTO tet_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hotu, Maromak katak naꞌak, “Musti noo kroman.” Katak notu, kroman moos dadi. ");
INSERT INTO tet_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Naree kroman nia, Maromak neon boot, tan saa mak Nia naseꞌi nia, kabaas tebes. Hotu, Nia naketak kroman no kukun, ida-idak no oras duꞌuk. ");
INSERT INTO tet_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nia nanaran kroman naꞌak, ‘loron’, nakukun naꞌak, ‘kalan’. Hodi nunia, dadi loron no kalan. Lia nia mak Maromak nalo baa loron dala uluk. ");
INSERT INTO tet_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Hotu, Maromak katak tenik naꞌak, “Musti noo fatin mamuk atu hodi keta faꞌe wee, nebee noo wee iha leten no wee iha ohak.” Katak notu, wee moos naketak aan faꞌe baa rua. ");
INSERT INTO tet_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Maromak nanaran fatin mamuk iha leten naꞌak, ‘laleꞌan’. Lia nia mak Maromak nalo baa loron dala rua. ");
INSERT INTO tet_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hotu, Maromak katak tenik naꞌak, “Wee iha ohak musti naklibur aan fatin ida, nebee noo rai maran!” Katak notu, rai maran moos dadi. ");
INSERT INTO tet_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nia nanaran rai nia naꞌak, “rai maran”. Nanaran wee klibur nia naꞌak, “tasi”. Naree nunia, Maromak neon boot, tan saa mak Nia naseꞌi nia, kabaas tebes. ");
INSERT INTO tet_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hotu, Maromak katak tenik naꞌak, “Rai maran musti natubu ai horis mahoo fuan, mahoo musan, no mahoo tahan matak. Nebee ai horis ida-idak nafini, tuir oik duꞌuk.” Katak notu, ai horis moos dadi. ");
INSERT INTO tet_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Iha rai maran ai horis sia nafini, tuir oik ida-idak. Naree nunia, Maromak neon boot, tan saa mak Nia naseꞌi nia, kabaas tebes. ");
INSERT INTO tet_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Lia nia mak Maromak nalo baa loron dala tolu. ");
INSERT INTO tet_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Hotu, Maromak katak tenik naꞌak, “Iha leten musti noo makroman oi-oik, nebee bele naroma raiklaran! Musti noo makroman baa kalan, no makroman baa loron. Makroman nia sia dadi tadak nebee bele sura loron no tinan.” Katak notu, makroman sia moos dadi. ");
INSERT INTO tet_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Makroman boot, oik rua. Mak boot liu nakroma baa oras loron; kiꞌik nakroma baa kalan. Maromak moos naseꞌi fitun sia, ");
INSERT INTO tet_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","no babilan makroman nia sia iha laleꞌan, nebee naroma raiklaran ");
INSERT INTO tet_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","baa kalan no loron. Hodi nunia, kroman naketak nosi makukun. Naree nunia, Maromak neon boot, tan saa mak Nia naseꞌi nia, kabaas tebes. ");
INSERT INTO tet_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Lia nia mak Maromak nalo baa loron dala haat. ");
INSERT INTO tet_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Hotu, Maromak katak tenik naꞌak, “Musti noo makmoris iha wee laran. No manu mak semo iha leten.” ");
INSERT INTO tet_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Hotu, Maromak naseꞌi makmoris iha wee laran. Nia moos naseꞌi manu mak semo iha leten. Naree nunia, Maromak neon boot, tan saa mak Nia naseꞌi nia, kabaas tebes. ");
INSERT INTO tet_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Maromak natuun matak-malirin baa sia hotu-hotu naꞌak, “Makmoris iha wee laran musti bea tuꞌan, nebee nakonu nola wee iha fatin hotu-hotu! Manu iha leten moos musti bea tuꞌan!” ");
INSERT INTO tet_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Lia nia mak Maromak nalo baa loron dala lima. ");
INSERT INTO tet_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Hotu, Maromak katak tenik naꞌak, “Musti noo makmoris iha rai maran! Nuꞌu osa no lotuk mak hakiak, osa no lotuk mak fuik, no osa no lotuk mak maneꞌek. Ida-idak tuir niakaan oik duꞌuk!” Katak notu, sia hotu-hotu moos dadi. Naree nunia, Maromak neon boot, tan saa mak Nia naseꞌi nia, kabaas tebes. ");
INSERT INTO tet_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hotu, Maromak katak tenik naꞌak, “Diꞌak liu, Ita haseꞌi ema tuir Itakaan ilas, nebee sia babilan naꞌan tasi iha tasi laran, manu iha leten, osa no lotuk hakiak no osa no lotuk seluk sia iha rai maran.” ");
INSERT INTO tet_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hotu, Maromak naseꞌi ema tuir Niakaan ilas. Nia naseꞌi sia, feto no mane. ");
INSERT INTO tet_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Hotu, Nia natuun matak-malirin baa sia naꞌak, “Emi musti bea tuꞌan, nebee hakonu hola no babilan raiklaran neꞌe. Haꞌu klatan beran hodi babilan naꞌan tasi iha tasi laran, manu ai leten, no osa no lotuk hotu-hotu iha rai maran. ");
INSERT INTO tet_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Haꞌu moos latan baa emi hahaak oi-oik iha raiklaran. Neꞌe mak, ai horis mahoo fuan no mahoo musan. ");
INSERT INTO tet_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Haꞌu klatan no ai horis mahoo tahan matak oi-oik bodik osa no lotuk haan. Noo haan bodik osa no lotuk hakiak, osa no lotuk fuik, osa no lotuk maneꞌek no manu ai leten.” Katak notu, hahaak hotu-hotu moos iha. ");
INSERT INTO tet_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Naree nunia, Maromak neon boot, tan saa mak Nia naseꞌi nia, kabaas tebes. Lia nia mak Maromak nalo baa loron dala neen. ");
INSERT INTO tet_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Hodi nunia, Maromak naseꞌi laleꞌan no raiklaran no sasoin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Awan, kona baa loron dala hitu. Baa loron nia, Maromak nanawa serwisu. ");
INSERT INTO tet_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Hodi nunia, Nia nalo loron dala hitu nia, dadi baa loron boot. Nia nalo nunia, tan hotu-hotu mak Nia naseꞌi nia, tetuk no nesan tiꞌan. Hotu Nia nanawa baa loron dala hitu. ");
INSERT INTO tet_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Lia Maromak naseꞌi laleꞌan no raiklaran, nunia. ");
INSERT INTO tet_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","MAROMAK foin nahuu naseꞌi laleꞌan no raiklaran, ");
INSERT INTO tet_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","ai horis la noo dauk, tan MAROMAK la natuun udan dauk. Baa oras nia, ababun dei saꞌe nosi rai, nabotes rai. Ema bodik nalo toꞌos moos, la noo dauk. ");
INSERT INTO tet_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hotu MAROMAK nola rai isin oan ida, nodi naseꞌi ema. Nia nuu natama nawan baa ema nia inun, hotu ema nia moris. ");
INSERT INTO tet_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hotu MAROMAK loke toꞌos ida iha rai Eden lorosaꞌe. Nia natama ema nia nein iha toꞌos nia. ");
INSERT INTO tet_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Iha toꞌos nia laran, MAROMAK nahoris ai horis kabaas oi-oik mak ema bele naa. Nia moos nahoris ai huun rua iha toꞌos klaran. Kalo ema naa ai huun ida fuan, bele moris nima-nimak. Naa ai huun ida seluk fuan, bele natene saa mak diꞌak no saa mak aat. ");
INSERT INTO tet_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Noo mota ida mak suli nabotes toꞌos nia. Suli sai nosi toꞌos nia, noo sorun haat. ");
INSERT INTO tet_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sorun ida, naran Pison. Sorun nia, suli nalik rai Hawila mak noo mean waꞌin. ");
INSERT INTO tet_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Iha nia, noo mean isin, ai horis mahoo raan morin no fatuk mahoo matan leen. ");
INSERT INTO tet_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mota sorun ida tenik, naran Gihon. Sorun nia nalik rai Kus. ");
INSERT INTO tet_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Mota sorun ida tenik, naran Tigris. Sorun neꞌe, dadi kladik iha rai Asyur lorosaꞌe. Mota sorun ida tenik, naran Efrat. ");
INSERT INTO tet_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","MAROMAK natama ema nia baa toꞌos Eden atu babilan toꞌos nia diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Nia naruka naꞌak, “O bele maa ai fuan hotu-hotu iha toꞌos neꞌe laran. ");
INSERT INTO tet_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mais noo ai fuan ida mak o la bele maa. Ai fuan nia, nosi ai huun mak foo natene saa mak diꞌak no saa mak aat. Kalo o maa ai fuan nia, o nanis mate.” ");
INSERT INTO tet_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hotu MAROMAK katak naꞌak, “La furak ema neꞌe moris mesan. Diꞌak liu, Haꞌu kaseꞌi foo maluk ida mak makonak no nia.” ");
INSERT INTO tet_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Baa oras nia, MAROMAK raꞌut nola rai isin nalo baa osa no lotuk no manu oi-oik. Hotu, Nia nodi sia baa ema nia, nebee ema nia tau naran baa sia. Ema nia nanaran kedan osa no lotuk no manu nia sia, ida-idak no naran duꞌuk. Mais nia duꞌuk, la noo maluk makonak. ");
INSERT INTO tet_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hotu MAROMAK nalo ema nia toba dukur. Oras toba dukur, MAROMAK nasai nola nosen ruin ida, hotu taka nikar kanek nia. ");
INSERT INTO tet_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nia naseꞌi feto ida nosi nosen ruin nia, hotu latan baa ema nia. ");
INSERT INTO tet_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Naree feto nia, ema nia dale naꞌak, “Haa! Neꞌe lai! Neꞌe foin kona baa haꞌu! Niakaan ruin manesak no haꞌukaan. Niakaan isin moos manesak no haꞌukaan. Haꞌu kanaran nia ‘feto’, tan nia dadi nosi mane.” ");
INSERT INTO tet_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tan lia nia, mane musti laꞌo nela inan no aman, nebee moris neon ida no feen, tan sia dadi mesak tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Oras nia, sia rua sei nakwalan, mais sia la moe. ");
INSERT INTO tet_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nosi osa no lotuk fuik hotu-hotu mak MAROMAK naseꞌi tiꞌan iha raiklaran, samea mak matenek beꞌur. Baa dala ida, samea ida nusu feto nia naꞌak, “Tebes ka? Naꞌi Maromak badu naꞌak, la bele haa ai fuan nosi toꞌos neꞌe ka?” ");
INSERT INTO tet_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Feto nia nataa naꞌak, “Lale! Ami bele haa! Ai huun ida dei iha toꞌos klaran mak Naꞌi Maromak badu. Ami la bele haa ai huun nia fuan. Kaer dei moos, la bele, tan ami nanis mate!” ");
INSERT INTO tet_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mais samea nataa naꞌak, “Lahoos nunia! Emi la mate! ");
INSERT INTO tet_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Naꞌi Maromak badu nunia, tan Nia natene kalo emi haa ai fuan nia, emi dadi matenek manesak no Nia! Emi moos bele hatene saa mak diꞌak no saa mak aat.” ");
INSERT INTO tet_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Rona nola nunia, feto nia naree ai huun nia kabaas lo-loos. Fuan moos arumak midar tebes. Nia naneo naꞌak, “Kalo haꞌu kaa ai fuan neꞌe, haꞌu nanis matenek ona.” Hotu, nia kuꞌu nola, naa kedan. Nia moos nodi foo baa laꞌen. Laꞌen moos naa. ");
INSERT INTO tet_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Sia rua naa notu, sarebak natene baa, sia nakwalan. Hotu, sia noman ai tahan nodi taka isin lolon, tan sia moe. ");
INSERT INTO tet_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Loro malirin, sia rona MAROMAK laꞌo iha toꞌos laran. Mais sia nakfunin iha ai huun kotuk, nebee MAROMAK la naree sia. ");
INSERT INTO tet_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Hotu, MAROMAK bolu mane nia naꞌak, “Hei Adam! O iha nabee?” ");
INSERT INTO tet_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Mane nia nataa naꞌak, “Haꞌu koꞌi rona Naꞌi Maromak lian iha neꞌe. Mais haꞌu kmoe aan, tan kakwalan. Foin, haꞌu kalai baa kakfunin.” ");
INSERT INTO tet_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Rona nola nunia, Maromak nusu naꞌak, “See mak katak naꞌak o makwalan? Keta arumak o maa tiꞌan ai fuan mak Haꞌu kbadu nia!” ");
INSERT INTO tet_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nia moos nataa naꞌak, “Feto mak Naꞌi Maromak latan namalu haꞌu nia, mak foo haꞌu kaa ai fuan nia!” ");
INSERT INTO tet_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Rona nola nunia, MAROMAK nusu feto nia naꞌak, “Tan saa o malo nunia?” Feto nia nataa naꞌak, “Tan samea mak beꞌur haꞌu, foin haꞌu kaa ai fuan nia.” ");
INSERT INTO tet_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hotu, MAROMAK natuun kastikar baa samea naꞌak, “Tan okaan hahalok neꞌe, haꞌu ktaa ukun baa o. Osa no lotuk seluk sia la kona ukun neꞌe. Nahuu baa oras neꞌe toꞌo o mate, o maneꞌe loos modi o kabun no o maa iha rai dei. ");
INSERT INTO tet_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","O mo feto neꞌe, funu malu nima-nimak. Emikaan husar-binan moos nunia. Okaan husar-binan atu nadodok ema ain nuban. Mais feto neꞌe niakaan husar-binan ida atu nadodok okaan ulun.” ");
INSERT INTO tet_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nunia hotu, Maromak katak baa feto nia naꞌak, “Haꞌu atu tuꞌan okaan susar baa oras koꞌus, no tuꞌan moras baa oras mahoris. Masik nunia moos, o sei beer okaan laꞌen bei-beik! Nia moos ukun o!” ");
INSERT INTO tet_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Nunia hotu, Maromak katak tenik baa mane naꞌak, “O la tuir Haꞌukaan ukun, mais tuir okaan feen hakaran, toꞌo o maa ai fuan mak Haꞌu kbadu nia. Tan lia nia, o moos kona kastikar. Rai moos kona kastikar. Nahuu baa oras neꞌe toꞌo o mate, o musti serwisu susi ruin fila rai, nebee bele metan haan. Modi serwisu nunia, foin o bele moris. ");
INSERT INTO tet_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Masik o furi oi-oik moos, rai natubu ai tarak no meik. ");
INSERT INTO tet_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","O musti serwisu susi ruin, foin rai foo haan baa o. O musti serwisu masai kosar nunia, toꞌo mate. Haꞌu kaseꞌi o kosi rai. Oras o mate, o fila mikar baa rai.” ");
INSERT INTO tet_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Nunia hotu, Adam nanaran feen naꞌak Efa, tan nia mak ema horis hotu-hotu inan. (Iha lia Ibrani, efa lia isin naꞌak ‘mak moris’.) ");
INSERT INTO tet_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Hotu, MAROMAK nola kulit, nalo baa tais, foo baa sia rua natais. ");
INSERT INTO tet_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hotu, MAROMAK katak naꞌak, “Oras neꞌe, ema natene tiꞌan saa mak diꞌak no saa mak aat, hanesan Ita. Keta toꞌo, sia naa tenik ai fuan nosi ai huun mak foo moris nima-nimak.” ");
INSERT INTO tet_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hotu, MAROMAK teꞌur sai Adam no Efa nosi toꞌos Eden, baa fatin seluk atu moris nosi fila rai. Tan ema huun nosi rai, sia musti moris nosi rai. ");
INSERT INTO tet_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Teꞌur sai tiꞌan, Maromak naruka Niakaan makbukar laleꞌan mahoo liras sia, baa daka toꞌos nia iha lorosaꞌe. Sia kaer surik lakan nuꞌu haꞌi, bakut baa-mai. Naruka sia taka dalan tataman, tan la noꞌuk ema kuꞌu nola ai fuan mak foo moris nima-nimak. ");
INSERT INTO tet_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Hotu, Adam toba no feen Efa. Efa koꞌus, hotu nahoris oan mane ida. Nia dale naꞌak, “Haꞌu kahoris kasai oan mane ida, tan MAROMAK tulun haꞌu.” Nia tau naran baa oan nia naꞌak, Kain (tan kain lia isin naꞌak ‘hasai’). ");
INSERT INTO tet_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ikus, Efa nahoris tenik oan mane ida. Nia tau naran, Habel. Oan rua nia boot mai, Habel bali bibi no bibi malae, Kain serwisu toꞌos. ");
INSERT INTO tet_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Dala ida, Kain nodi niakaan toꞌos isin balu, sera baa MAROMAK. ");
INSERT INTO tet_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel moos nola bibi malae oan ulun sia. Nia noꞌo, hotu nodi naꞌan kabaas sia, sera baa MAROMAK. Naree nunia, MAROMAK neon diꞌak baa Habel, tan sera nia. ");
INSERT INTO tet_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mais MAROMAK la nakara Kain niakaan sera. Tan baa nia, Kain krakat, toꞌo oin kadubuk. ");
INSERT INTO tet_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Naree nunia, MAROMAK nusu Kain naꞌak, “Hoi Kain! O oin kadubuk baa saa? ");
INSERT INTO tet_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kalo o malo diꞌak, Haꞌu moos simu diꞌa-diꞌak. Mais, sintidu! Kalo o malo aat, aꞌaat nia atu naa fila o, hanesan busa sobak laho. Kalo o makara malo aat, diꞌak liu dudu sees hanoin aat nia kedan!” ");
INSERT INTO tet_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nunia hotu, dala ida Kain namaus Habel naꞌak, “Ali! Mai ita baa toꞌos lai!” Hotu sia baa. Toꞌo toꞌos baa, teki-tekis Kain taꞌe noꞌo alin. ");
INSERT INTO tet_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Naree nunia, MAROMAK nusu Kain naꞌak, “Hoi Kain! O alin iha nabee?” Kain nataa naꞌak, “Haꞌu la katene! Haꞌu mak kaer nia ain ka?” ");
INSERT INTO tet_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Hotu, MAROMAK dale naꞌak, “Tan saa o malo aat nunia? Keta maneo o bele subar o alin raan baa rai. Haꞌu karee tiꞌan! ");
INSERT INTO tet_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Oras neꞌe, kastikar saꞌe kona o ona. Oras o moꞌo o alin, rai norut nola niakaan raan. Tan baa nia, rai la bele foo tenik moris baa o. ");
INSERT INTO tet_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kalo o malo toꞌos, rai la foo isin baa o. Nahuu baa oras neꞌe, o tablaun lerek hanesan ema susar mak buka moris iha raiklaran.” ");
INSERT INTO tet_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Rona nola nunia, Kain sakar MAROMAK naꞌak, “Adeei Naꞌi Maromak! Keta matuun kastikar todan liu resik nunia, toꞌo la kbele katiu! ");
INSERT INTO tet_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kalo Naꞌi Maromak teꞌur sai haꞌu kosi fatin neꞌe, haꞌu kdook nanis kosi Naꞌi Maromak tiꞌan. Haꞌu tablaun lerek dei ona. Ema mak nasoru haꞌu, nanis noꞌo haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mais, MAROMAK nataa fila naꞌak, “Lahoos nunia! Kalo ema noꞌo o, Haꞌu atu kastikar nia isin hitu todan liu tan!” Hotu, MAROMAK tau marak baa Kain, nebee ema bele natene naꞌak, la bele hoꞌo nia. ");
INSERT INTO tet_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Hotu, Kain laꞌo nela fatin nia, baa nadook aan nosi MAROMAK, toꞌo fatin ida naran Nod, iha toꞌos Eden lorosaꞌe. Nod neꞌe lia isin naꞌak ‘tablaun’. Hotu, Kain nein iha nia. ");
INSERT INTO tet_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nosi ikus, Kain nola feto. Hotu, feen koꞌus toꞌo nahoris oan mane ida, naran Henok. Kain moos nariik nola leo ida. Nia nanaran leo nia naꞌak, Henok, tuir oan naran. ");
INSERT INTO tet_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Nosi ikus, Henok netan oan, naran Irad. Irad oan, Mehuyael. Mehuyael oan, Metusael. Metusael oan, Lamek. ");
INSERT INTO tet_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek feen rua. Ida naran Ada, ida tenik, Sila. ");
INSERT INTO tet_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada oan, Yabel. Yabel husar-binan dadi makbalin. Sia lori baa-mai, nein iha batane. ");
INSERT INTO tet_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabel alin, Yubal. Yubal husar-binan dadi makdiuk bareka no mahuu kfui. ");
INSERT INTO tet_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek feen Sila nahoris Tubal Kain. Tubal Kain husar-binan dadi badaen besi no besi riti. Tubal Kain feton, naran Naꞌama. ");
INSERT INTO tet_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Dala ida, Lamek loko aan iha feen sia oin naꞌak, “Emi rona! Foin da-dauk neꞌe, mane nurak ida atu taꞌe haꞌu, mais haꞌu ktuku koꞌo nia. ");
INSERT INTO tet_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kalo ema noꞌo Kain, netan kastikar dala hitu. Mais, kalo ema nakara rai hirus baa haꞌu, atu netan kastikar dala hitu nulu resin hitu.” ");
INSERT INTO tet_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nosi ikus, Adam feen Efa nahoris tenik oan mane ida naran Set. Hotu, Efa dale naꞌak, “Naꞌi Maromak foo oan neꞌe baa haꞌu atu seluk Habel, mak Kain noꞌo tiꞌan nia!” ");
INSERT INTO tet_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kleu-leur Set moos netan oan mane ida naran Enos. Natoon baa oras nia, ema nahuu natene MAROMAK nodi loꞌu-sudur baa Nia. ");
INSERT INTO tet_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Oras Maromak naseꞌi ema, naseꞌi siakaan ilas hanesan Nia duꞌuk. Naseꞌi feto no mane, hotu temi sia naꞌak “ema” nodi natuun matak-malirin baa sia. Ema uluk fohon basuk, naran Adam. Adam husar-binan mak neꞌe: ");
INSERT INTO tet_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Oras Adam otas tinan atus ida tolu nulu, netan oan mane ida, ilas nuꞌu nia. Nia tau naran, Set. ");
INSERT INTO tet_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Hotu, Adam sei moris tenik tinan atus walu, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Hotu, nia mate baa otas tinan atus siwi tolu nulu. ");
INSERT INTO tet_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Oras Set otas tinan atus ida lima, netan oan mane ida naran Enos. ");
INSERT INTO tet_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Hotu, Set sei moris tenik tinan atus walu hitu, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Hotu, nia mate baa otas tinan atus siwi sanulu resin rua. ");
INSERT INTO tet_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Oras Enos otas tinan siwi nulu, netan oan mane ida naran Kenan. ");
INSERT INTO tet_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Hotu, Enos sei moris tenik tinan atus walu sanulu resin lima, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Hotu, nia mate baa otas tinan atus siwi lima. ");
INSERT INTO tet_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Oras Kenan otas tinan hitu nulu, netan oan mane ida naran Mahalalel. ");
INSERT INTO tet_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Hotu, Kenan sei moris tenik tinan atus walu haat nulu, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Hotu, nia mate baa otas tinan atus siwi sanulu. ");
INSERT INTO tet_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Oras Mahalalel otas tinan neen nulu resin lima, netan oan mane ida naran Yared. ");
INSERT INTO tet_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Hotu, Mahalalel sei moris tenik tinan atus walu tolu nulu, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Hotu, nia mate baa otas atus walu siwi nulu resin lima. ");
INSERT INTO tet_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Oras Yared otas tinan atus ida neen nulu resin rua, netan oan mane ida naran Henok. ");
INSERT INTO tet_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Hotu, Yared sei moris tenik tinan atus walu tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Hotu, nia mate baa otas tinan atus siwi neen nulu resin rua. ");
INSERT INTO tet_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Oras Henok otas tinan neen nulu resin lima, netan oan mane ida naran Metusalak. ");
INSERT INTO tet_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henok moris neon ida no Maromak, toꞌo tinan atus tolu tenik. Nia moos netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Tan moris neon ida bei-beik no Maromak, baa otas tinan atus tolu neen nulu resin lima, Maromak foti saꞌe nia, toꞌo lakon. ");
INSERT INTO tet_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Oras Metusalak otas tinan atus ida walu nulu resin hitu, netan oan mane ida naran Lamek. ");
INSERT INTO tet_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Hotu, Metusalak sei moris tenik tinan atus hitu walu nulu resin rua, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Hotu, nia mate baa otas tinan atus siwi neen nulu resin siwi. ");
INSERT INTO tet_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Oras Lamek otas tinan atus ida walu nulu resin rua, netan oan mane ida. ");
INSERT INTO tet_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Hotu nia dale naꞌak, “Oan neꞌe atu nadiꞌak itakaan neon, toꞌo haluꞌa itakaan serwisu todan iha rai mak Maromak kastikar tiꞌan.” Etuk, nanaran oa nia, Noh (tan lia fuan ‘noh’ hanesan lia fuan Ibrani ida naꞌak ‘hadiꞌak neon’). ");
INSERT INTO tet_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Hotu, Lamek sei moris tenik tinan atus lima siwi nulu resin lima, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Hotu, nia mate baa otas tinan atus hitu, hitu nulu resin hitu. ");
INSERT INTO tet_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Oras Noh otas tinan atus lima, netan oan mane naꞌin tolu, mak: Sem, Yafet no Ham. ");
INSERT INTO tet_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Oras nia, ema hetak bea tuꞌan. Sia moris keke lema rai tiꞌan. Sia moos nahoris oan feto kabaas. ");
INSERT INTO tet_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Hotu, Maromak oan mane sia naree feto oan nia sia. Sia moos nola sia, tuir siakaan beer. ");
INSERT INTO tet_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Loron ikus, MAROMAK katak naꞌak, “Haꞌu kole resik tiꞌan, tan ema raiklaran moris la loos! Haꞌukaan Kmalar mak foo moris baa sia. Mais oras neꞌe, Haꞌu la koꞌuk sia moris nohuun. Nahuu baa oras neꞌe, sia la bele moris otas naruk ona, mais sia musti mate. Sia bele moris toꞌo otas tinan atus ida rua nulu dei.” ");
INSERT INTO tet_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Baa oras nia no otas ikus tenik, ema bei balera moris iha raiklaran. Maromak oan mane sia nola ema oan feto sia, hotu sia nahoris ema balera nia sia. Sia dadi meo ulun mak ema hotu-hotu natene tuir lia uluk. ");
INSERT INTO tet_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Oras nia, MAROMAK naree ema raiklaran hahalok aat liu resik. Sia natene loos nanoin aat dei. ");
INSERT INTO tet_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","MAROMAK laran moras, tan naseꞌi tiꞌan ema raiklaran. ");
INSERT INTO tet_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Etuk, MAROMAK katak naꞌak, “Tan siakaan aꞌaat nia, Haꞌu atu kabeꞌo dodok ema raiklaran mak kaseꞌi tiꞌan nia. Haꞌu moos kabeꞌo dodok manu no osa no lotuk hotu-hotu. Haꞌu laran moras kaseꞌi sia tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Baa oras nia, Noh mesan mak nalo MAROMAK neon diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Lia nosi Noh niakaan dalan moris nuneꞌe. Noh oan mane naꞌin tolu, naran Sem, Yafet no Ham. Noh moris loos, la nalo aat. Nia mesan dei mak diꞌak, tan nia moris kreꞌis baa Maromak. ");
INSERT INTO tet_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Mais Maromak naree ema seluk sia, aat hotu. Iha nabee dei, sia moris aat liu resik, toꞌo Maromak naree aꞌaat dei iha raiklaran. ");
INSERT INTO tet_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Naree nunia, Maromak katak baa Noh naꞌak, “Iha fatin hotu-hotu, Haꞌu karee aꞌaat dei. Dadi, Haꞌu kakotu tiꞌan atu kabeꞌo dodok raiklaran neꞌe no sasoin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Mais nuneꞌe, Noh! O musti malo roo boot ida modi ai monas! Malo keꞌan iha laran. Hotu, tukir roo molin modi hanit. ");
INSERT INTO tet_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Roo nia naruk musti roꞌa atus ida tolu nulu resin tolu, belar roꞌa rua nulu resin rua, aas roꞌa sanulu resin tolu. ");
INSERT INTO tet_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Soor roo nia. Malo soor no leet nosi kadidin leten, takseer roꞌa baluk ida. Faꞌe roo nia malo baa tetu tetek tolu. Hotu, malo odamatan ida baa roo sorin! ");
INSERT INTO tet_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Manoin diꞌa-diꞌak, tan Haꞌu atu katuun motasaꞌe boot, kodi koꞌo hotu-hotu mak moris iha raiklaran neꞌe. Toꞌo la hela sa-saa! ");
INSERT INTO tet_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mais, Haꞌu atu kamate menon ko o, Noh. O musti mola o feen, o oan, no o oan feen sia, tama baa roo nia. ");
INSERT INTO tet_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Mola tenik osa no lotuk hotu-hotu, inan no aman ida-idak. Mola mak hakiak, mak maneꞌek, no manu ai leten sia. Matama sia baa roo, nebee moris namutuk no o. Hodi nunia, sia bele moris. ");
INSERT INTO tet_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","O moos musti loi matama haan oi-oik bodik emi ho osa no lotuk nia sia.” ");
INSERT INTO tet_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Rona nola nunia, Noh moos nalaꞌok tuir Maromak harukan hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hotu, MAROMAK katak baa Noh naꞌak, “Haꞌu karee ema iha fatin hotu-hotu tiꞌan, mais o mesan dei mak loos! Tan lia nia, o mo okaan uma isin sia tama baa roo ona! ");
INSERT INTO tet_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Osa no lotuk oi-oik mak bele haa, no mak bele sera baa Haꞌu, modi inan no aman hitu-hitu, tama baa roo. Manu oi-oik moos, modi inan no aman hitu-hitu. Mais, osa no lotuk seluk sia, modi inan no aman ida-idak dei. Hodi nunia, sia dadi baa fini, nebee bea bei-beik. ");
INSERT INTO tet_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Rona diꞌa-diꞌak! Hela loron hitu dei, Haꞌu atu katuun udan mak la nanawa, toꞌo kalan haat nulu, loron haat nulu! Kodi nunia, Haꞌu koꞌo mohu hotu-hotu mak moris iha rai maran, mak Haꞌu kaseꞌi tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Hotu Noh nalo tuir MAROMAK harukan hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Oras motasaꞌe nia, Noh otas tinan atus neen. ");
INSERT INTO tet_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nia tama baa roo no feen, no oan, no oan feen sia, nebee sori aan nosi motasaꞌe boot nia. ");
INSERT INTO tet_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Oras nia moos, manu oi-oik no osa no lotuk seluk sia mai baa Noh. Osa no lotuk nia sia, inan no aman ida-idak, nosi mak ema bele naa no ema la bele naa. Sia tama bele-bele baa roo namutuk no Noh, tuir MAROMAK harukan. ");
INSERT INTO tet_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Loron hitu liu, motasaꞌe moos nakfakar mai, toꞌo nahuu taka nola raiklaran neꞌe. ");
INSERT INTO tet_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Kona baa Noh otas tinan atus neen, liu fulan rua no loron sanulu resin hitu, motasaꞌe nia toꞌo mai. Udan nakfakar tuun hanesan laleꞌan odamatan nakloke. Wee matan hotu-hotu iha rai kidun moos taba no nakduar sai. ");
INSERT INTO tet_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Udan moos la nanawa kois loron-kalan, toꞌo loron haat nulu. ");
INSERT INTO tet_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mais loron nia, Noh tama baa roo laran no feen, oan naꞌin tolu, mak Sem, Yafet no Ham, no oan feen hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Sia tama bele-bele no osa no lotuk mak hakiak, mak fuik, mak maneꞌek, no manu ai leten, no osa no lotuk seluk mahoo liras sia. ");
INSERT INTO tet_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Osa no lotuk inan no aman ida-idak nosi hotu-hotu mak moris, tama baa roo namutuk no Noh, tuir Maromak harukan nia. Sia hotu-hotu tama tiꞌan, MAROMAK moos kusa roo odamatan. ");
INSERT INTO tet_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Udan boot tuun bei-beik, toꞌo loron haat nulu. Motasaꞌe nia moos hetak aas tuꞌan, toꞌo roo naklele. Wee saꞌe bei-beik, toꞌo taka nola foho aas sia. ");
INSERT INTO tet_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Wee nia saꞌe la nanawa kois, toꞌo aas roꞌa hitu iha foho leten. ");
INSERT INTO tet_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Hodi nunia, hotu-hotu mak moris iha rai maran, mate fasi. Neꞌe mak: ema, osa no lotuk mak hakiak, mak fuik, mak maneꞌek no manu ai leten. Hela mesan Noh no hotu-hotu iha roo laran nia, mak moris. ");
INSERT INTO tet_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Wee nia la moti kois, toꞌo loron atus ida lima nulu. ");
INSERT INTO tet_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mais Maromak la naluꞌa Noh no osa no lotuk sia hotu-hotu iha roo nia. Nia foo anin nuu namoti wee motasaꞌe nia. ");
INSERT INTO tet_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nia moos taka wee matan hotu-hotu, no sena udan. ");
INSERT INTO tet_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Wee nahuu moti oa-oan. Loron atus ida lima nulu siku liu tiꞌan, wee moos nahuu nakraik. ");
INSERT INTO tet_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Natoon besik baa fulan hitu liu loron sanulu resin hitu, sura hosi udan nakfakar tuun nia, roo nia baken aan baa foho leten aas ida naran Ararat. ");
INSERT INTO tet_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Wee moti bei-beik toꞌo loron dala uluk fulan sanulu, foho dikin sia moos tadu nikar. ");
INSERT INTO tet_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Loron haat nulu siku liu tiꞌan, Noh loke kuak anin ida nosi roo nia. ");
INSERT INTO tet_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Hotu, nia nabusik sai manu kawaa ida. Manu nia semo baa-mai. Oras wee motasaꞌe nia moti, nia la fila nikar baa roo. ");
INSERT INTO tet_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hotu, Noh moos nabusik manu lakateu ida, atu nodi natene, wee moti tebes tiꞌan ka, sei. ");
INSERT INTO tet_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mais, tan wee sei taka nola raiklaran, manu nia la netan rani fatik. Hotu, nia fila nikar baa roo. Noh lolo liman, simu nola manu nia, natama nikar baa roo laran. ");
INSERT INTO tet_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Hotu, Noh nein loron hitu tenik, foin nia nabusik nikar manu nia. ");
INSERT INTO tet_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Loro malirin, manu nia fila nikar mai baa Noh, mais tutu nodi ai saitun tahan ida, mak foin tutu silu nola. Naree nunia, Noh bele natene wee moti tebes tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nia nein loron hitu tenik, foin nabusik tenik manu nia. Mais dala ida neꞌe, manu nia la fila mai. ");
INSERT INTO tet_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Oras Noh otas tinan atus neen ida, wee motasaꞌe nia nakraik tebe-tebes, kona baa fulan ida loron dala uluk. Noh loke kuak anin nodi titu satan leur, foin natene naꞌak, rai atu maran ona. ");
INSERT INTO tet_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Liu fulan ida loron sanulu resin hitu tenik, rai maran tebe-tebes tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Hotu, Maromak naruka Noh naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Oras neꞌe, emi hotu-hotu tuun hosi roo ona. ");
INSERT INTO tet_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Masai osa no lotuk nia sia hotu-hotu. Masai mak hakiak, mak fuik, mak maneꞌek no manu ai leten sia. Mabusik sia, nebee sia bea tuꞌan, nakonu nola raiklaran neꞌe.” ");
INSERT INTO tet_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Rona nola nunia, Noh moos tuun nosi roo no feen, oan sia, no oan feen sia hotu-hotu. Osa no lotuk nia sia moos sai, tuir oik ida-idak. ");
INSERT INTO tet_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Sai nosi roo tiꞌan, Noh nada fatuk taroman, nodi nalo sera baa MAROMAK. Nosi osa no lotuk no manu ai leten mak bele sera, Noh nola matan ida-idak, koꞌa noꞌo, hotu tunu baa taroman nia leten, nalo sera baa MAROMAK. ");
INSERT INTO tet_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","MAROMAK noran nola sera tunun nuhar morin nia, Nia neon diꞌak. Hotu, naneo naꞌak, “Nahuu baa oras neꞌe, Haꞌu la kastikar tenik raiklaran ona, tan ema siakaan aꞌaat. Masik sia naneo mesan aat dei, Haꞌu la kabeꞌo tenik ona sa-saa mak moris, nuꞌu Haꞌu kalo tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Oras raiklaran neꞌe sei iha, loro no kalan musti laꞌo bei-beik atu babilan oras furi no oras kuꞌu, oras malirin no oras manas, oras loro falin no oras rai udan.” ");
INSERT INTO tet_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Hotu, Maromak natuun matak-malirin baa Noh no oan sia nodi katak naꞌak, “Emi hahoris bea hakonu hikar raiklaran neꞌe. ");
INSERT INTO tet_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Osa no lotuk no manu ai leten no naꞌan tasi wee laran, hotu-hotu atu nataꞌuk emi. Emi mak babilan sia. ");
INSERT INTO tet_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Emi bele haa siakaan naꞌan. Emi moos bele haa ai fuan nosi ai horis sia. Neꞌe sia hotu-hotu, Haꞌu klatan baa emi. ");
INSERT INTO tet_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Mais, emi la bele haa siakaan naꞌan kalo sei noo raan, tan sia moris nosi raan nia. ");
INSERT INTO tet_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Haꞌu kaseꞌi ema tuir Haꞌukaan ilas. Tan lia nia, la bele hoꞌo ema. Kalo ema ida noꞌo ema, musti ukun mate nia. Kalo osa no lotuk sia noꞌo ema, musti hoꞌo. Ukun neꞌe, nosi Haꞌu. ");
INSERT INTO tet_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Emi musti hahoris bea hakonu hikar raiklaran neꞌe.” ");
INSERT INTO tet_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hotu, Maromak katak tenik naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Oras neꞌe, Haꞌu atu kamate menon ko emi no emikaan husar-binan! ");
INSERT INTO tet_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Mamenon neꞌe moos kona baa hotu-hotu mak moris. Neꞌe mak, osa no lotuk mak hakiak, mak fuik no manu ai leten sia. Mamenon neꞌe kona baa sa-saa hotu-hotu mak sai namutuk no emi nosi roo nia. ");
INSERT INTO tet_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mamenon nia nuneꞌe: Haꞌu la katuun tenik motasaꞌe boot ona atu kabeꞌo dodok raiklaran neꞌe no sa-saa mak moris. ");
INSERT INTO tet_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Haꞌu ktau Haꞌukaan baur iha laleꞌan dadi baa tadak, nebee emi bele hatene Haꞌukaan mamenon la nakotu baa emi no baa sa-saa mak moris iha raiklaran neꞌe. ");
INSERT INTO tet_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Kalo kaloꞌan saꞌe iha laleꞌan, hotu baur tubu, baur nia foo natene baa Haꞌu naꞌak, Haꞌu kameno tiꞌan, motasaꞌe boot la bele nabeꞌo dodok tenik sa-saa mak moris. Baur nia moos dadi tadak naꞌak, Haꞌu kamate menon tiꞌan ko emi no sa-saa hotu-hotu mak moris.” ");
INSERT INTO tet_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noh oan sia mak sai mai nosi roo, sia mak Sem, Yafet no Ham (Ham nia, Kanaꞌan aman). ");
INSERT INTO tet_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ema hotu-hotu iha raiklaran neꞌe husar-binan mai nosi Noh oan naꞌin tolu nia. ");
INSERT INTO tet_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh nia, ema mafaho rai. Nia mahalo toꞌos anggor uluk fohon. ");
INSERT INTO tet_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Baa dala ida, Noh nemu anggor toꞌo lanu todan. Nia kolu tais, toba nakwalan iha batane laran. ");
INSERT INTO tet_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham naree nola aman nakwalan nunia, nia moos nalai sai baa katak maun Sem no Yafet. ");
INSERT INTO tet_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem no Yafet nola tais ida, hotu felar nodi sakat baa siakaan baas. Hotu, sia laꞌo nakiduk, tama baa batane laran, nafuꞌut siakaan aman. Sia nalo nunia, nebee sia duꞌuk la naree aman nakwalan. Hotu, sia sai. ");
INSERT INTO tet_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noh oin moo tiꞌan, foin natene nola oan ikun hahalok. ");
INSERT INTO tet_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Hotu nia katak naꞌak, “Hoi Ham, Kanaꞌan aman! Haꞌu kastikar o! O atu dadi baa okaan maun sia atan. ");
INSERT INTO tet_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nebee MAROMAK atu natuun matak-malirin baa Sem! Mais o oan Kanaꞌan atu dadi baa Sem atan. ");
INSERT INTO tet_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nebee Maromak naluan Yafet rain. Niakaan husar-binan moris dame no Sem husar-binan. Mais, o oan Kanaꞌan atu dadi baa Yafet atan.” ");
INSERT INTO tet_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Motasaꞌe hotu tiꞌan, Noh sei moris tinan atus tolu lima nulu tenik. ");
INSERT INTO tet_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Otas tinan atus siwi lima nulu, foin Noh mate. ");
INSERT INTO tet_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Motasaꞌe hotu tiꞌan, Noh oan Sem, Yafet no Ham netan husar-binan. ");
INSERT INTO tet_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Yafet oan sia mak: Gomer, Magog, Madai, Yawan, Tubal, Mesek no Tiras. Ida-idak no lian duꞌuk, ema hunun duꞌuk, no rain duꞌuk. Gomer oan sia mak: Askenas, Rifat no Togarma. Yawan oan sia mak: Elisa, Tarsis, Kitim no Dodanim. Sia neꞌe, mak ema maktuun tasi uluk fohon. ");
INSERT INTO tet_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham oan sia mak Kus, Misraim, Put no Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus oan sia mak Seba, Hawila, Sabta, Raema no Sabteka. Raema oan sia mak Syeba no Dedan. ");
INSERT INTO tet_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus oan mane ida tenik, naran Nimrod. Nia meo ulun mak uluk fohon. ");
INSERT INTO tet_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nia simu niakaan makaꞌas nia nosi MAROMAK, toꞌo nia dadi baa ema maktama hae matenek kaliuk. Tan lia nia, ema nanis dale naꞌak “Nebee, o dadi ema maktama hae matenek, hanesan Nimrod mak simu makaꞌas nosi MAROMAK.” ");
INSERT INTO tet_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Uluk fohon, Nimrod rain nahuu nosi Babel, Erek Akad no Kalne, hotu-hotu iha rai Sinear. ");
INSERT INTO tet_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nosi Sinear, nia ukun tenik rai Asyur. Nariik kota Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO tet_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","no Resen, mak iha Niniwe no Kala leet. Kota nia sia, hotu-hotu kota boot. ");
INSERT INTO tet_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim husar-binan mak ema Ludim, ema Ananim, ema Lehabim, ema Naftuhim, ");
INSERT INTO tet_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ema Patrusim, ema Kasluhim, no ema Kaftorim. Ema Kasluhim nia, mak ema Filistin bei uluk. ");
INSERT INTO tet_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaꞌan oan ulun, Sidon. Kanaꞌan moos dadi bei uluk nosi ema Het, ");
INSERT INTO tet_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ema Yebusi, ema Amori, ema Girgasi, ");
INSERT INTO tet_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ema Hewi, ema Arki, ema Sini, ");
INSERT INTO tet_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ema Arwadi, ema Semari no ema Hamati. Kanaꞌan husar-binan sia keen karin malu do-dook, ");
INSERT INTO tet_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","toꞌo siakaan rai kladik, nosi Sidon, baa Gerar, toꞌo Gasa. Nosi nia, baa Sodom, Gomora, Adma no Seboim, toꞌo Lasa. ");
INSERT INTO tet_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Sia hotu-hotu nia, Ham husar-binan. Ida-idak no lian duꞌuk, ema hunun duꞌuk, no rain duꞌuk. ");
INSERT INTO tet_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet maun Sem dadi baa ema Eber bei uluk. ");
INSERT INTO tet_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem oan sia mak Elam, Asyur, Arpaksad, Lud no Aram. ");
INSERT INTO tet_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram oan sia mak Us, Hul, Geter no Mas. ");
INSERT INTO tet_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad oan, Sela. Hotu Sela oan, Eber. ");
INSERT INTO tet_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber netan oan mane naꞌin rua. Baa oras nia, ema faꞌe karin malu iha raiklaran neꞌe. Etuk, Eber nanaran oan ulun naꞌakPelek (tan pelek lia isin naꞌak ‘faꞌe karin malu’). Hotu, nanaran alin, Yoktan. ");
INSERT INTO tet_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan oan sia mak: Almodad, Selef, Hazar-Mawet, Yera, ");
INSERT INTO tet_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO tet_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO tet_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila no Yobab. Sia hotu-hotu nia, Yoktan oan. ");
INSERT INTO tet_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Siakaan nein fatin nia, nosi Mesa, liu toꞌo Sefar, fatin foho iha lorosaꞌe. ");
INSERT INTO tet_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sia hotu-hotu nia, Sem husar-binan. Ida-idak no lian duꞌuk, ema hunun duꞌuk, no rain duꞌuk. ");
INSERT INTO tet_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ema hotu-hotu nia, Noh husar-binan. Ida-idak no ema hunun duꞌuk. Motasaꞌe boot mohu tiꞌan, sia neꞌe faꞌe karin malu, nakonu nola raiklaran. ");
INSERT INTO tet_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Uluk fohon, ema hotu-hotu iha raiklaran dale nodi lia ida dei. ");
INSERT INTO tet_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Sia balu lori baa lorosaꞌe toꞌo rai fehan ida iha Sinear. Hotu, sia nein iha nia. ");
INSERT INTO tet_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Hotu, sia kabuar lia fuan naꞌak, “Mamaluk sia! Diꞌak liu, ita hariik hola kota boot ida. Ita halo fatuk mean, tunu toꞌo monas. Hotu, ita hada baa malu hodi hanit atu hariik uma tetu ida mak aas toꞌo laleꞌan. Hodi nunia, ita hetan naran boot. Ita bele dadi klubun boot ida, la faꞌe karin malu ona.” ");
INSERT INTO tet_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Hotu, MAROMAK tuun nateke kota nia no uma tetu boot mak sia nariik nia. ");
INSERT INTO tet_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Naree nunia, MAROMAK naneo naꞌak, “Ema neꞌe sia, ema klubun ida mak dale lia ida dei. Saa mak sia nalo baa oras neꞌe, foin hakat uluk fohon dei. Awan-wainrua, kalo sia metis malu nohuun, sia bele nalo sa-saa dei. ");
INSERT INTO tet_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Diꞌak liu, Ita tuun baa, tokar siakaan lian, nebee sia la bele natene malu lian.” ");
INSERT INTO tet_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Hotu, MAROMAK tuun, tokar lauk siakaan lian. Nodi nunia, Nia nalo ema nia sia faꞌe karin malu baa fatin hotu-hotu iha raiklaran. Sia moos nanawa nariik kota nia. ");
INSERT INTO tet_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tan MAROMAK tokar lauk siakaan lian, nodi nalo sia keen karin malu baa fatin hotu-hotu iha raiklaran, sia nanaran kota nia naꞌak, Babel, (tan lia fuan ‘babel’ neꞌe, hanesan lia fuan Ibrani ida mak naꞌak ‘benar karin’). ");
INSERT INTO tet_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Neꞌe, Sem husar-binan. Motasaꞌe boot nia nanawa tiꞌan tinan rua, Sem moos otas tinan atus ida. Hotu, netan oan mane ida, naran Arpaksad. ");
INSERT INTO tet_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem sei moris tinan atus walu tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Baa oras Arpaksad otas tinan tolu nulu resin lima, netan oan mane ida, naran Sela. ");
INSERT INTO tet_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpaksad sei moris tinan atus haat tolu tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela otas tinan tolu nulu, netan oan mane ida, naran Eber. ");
INSERT INTO tet_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sela sei moris tinan atus haat tolu tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber otas tinan tolu nulu resin haat, netan oan mane ida, naran Pelek. ");
INSERT INTO tet_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber sei moris tinan atus haat tolu nulu tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek otas tinan tolu nulu, netan oan mane ida, naran Rehu. ");
INSERT INTO tet_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelek sei moris tinan atus rua siwi tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu otas tinan tolu nulu resin rua, netan oan mane ida, naran Seruk. ");
INSERT INTO tet_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rehu sei moris tinan atus rua hitu tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk otas tinan tolu nulu, netan oan mane ida, naran Nahor. ");
INSERT INTO tet_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Seruk sei moris tinan atus rua tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor otas tinan rua nulu resin siwi, netan oan mane ida, naran Tera. ");
INSERT INTO tet_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor sei moris tinan atus ida sanulu resin siwi tenik, nodi netan tuꞌan oan feto, oan mane. ");
INSERT INTO tet_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera otas tinan hitu nulu, netan oan mane naꞌin tolu, mak Abram, Nahor no Haran. ");
INSERT INTO tet_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Neꞌe, mak Tera husar-binan. Tera oan sia, mak Abram, Nahor no Haran. Haran netan oan mane ida, naran Lot. ");
INSERT INTO tet_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran mate iha leo huun, naran Ur iha ema Kasdim rain. Oras nia mate, aman Tera sei moris. ");
INSERT INTO tet_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram nola feto ida, naran Sarai, nalo baa feen. Nahor nola nikar Haran oan feto, naran Milka. Hotu, Haran netan oan mane ida, naran Yiska. ");
INSERT INTO tet_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Mais, Sarai sei kiuk. ");
INSERT INTO tet_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Dala ida, Tera nodi oan Abram, oan feen Sarai, no bein oan Lot, sai nela leo huun Ur atu baa rai Kanaꞌan. Mais, toꞌo rai Haran, sia nein iha nia dei. ");
INSERT INTO tet_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Hotu, Tera mate iha nia, baa otas tinan atus rua lima. ");
INSERT INTO tet_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Abram aman Tera mate tiꞌan, MAROMAK katak baa Abram naꞌak, “Abram! Laꞌo mela okaan leo, okaan familin no okaan ama uman! Baa fatin ida mak Haꞌu atu katudu baa o. ");
INSERT INTO tet_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Haꞌu atu katuun matak-malirin baa o. Okaan husar-binan atu bea tuꞌan, dadi ema klubun boot, toꞌo ema iha fatin hotu-hotu natene okaan naran. O moos dadi matak-malirin bodik ema seluk. ");
INSERT INTO tet_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Haꞌu katuun matak-malirin baa ema mak tulun o. Mais, katuun kastikar baa ema mak nasusar o. Rona diꞌa-diꞌak! Tan o, ema klubun hotu-hotu iha raiklaran netan matak-malirin.” ");
INSERT INTO tet_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Oras Abram otas tinan hitu nulu resin lima, nodi feen Sarai, alin oan Lot, eman serwisu hotu-hotu, no bein sasoin hotu-hotu mak nia netan iha leo Haran. Sia laꞌo nela Haran, baa fatin ida naran Kanaꞌan. Fatin nia mak MAROMAK natudu baa Abram. ");
INSERT INTO tet_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Toꞌo nebaa, Abram laꞌo toꞌo kreꞌis baa leo ida, naran Sikem. Hotu, sia nein heik kreꞌis baa ai huun boot ida iha More. Baa oras nia, ema Kanaꞌan sia sei nein iha nia. ");
INSERT INTO tet_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Iha fatin nia, MAROMAK natadu aan baa Abram naꞌak, “Haꞌu klatan rai neꞌe baa okaan husar-binan.” Rona nola nunia, Abram nariik taroman nodi natetu sera baa MAROMAK, mak natadu aan tiꞌan iha nia. ");
INSERT INTO tet_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hotu, Abram sia lori saꞌe baa foho iha lorokbelan baa. Sia nein heik iha fatin ida iha leo Betel no leo Ai leet. Iha nia, Abram nariik taroman ida, nodi loꞌu-sudur baa MAROMAK. ");
INSERT INTO tet_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hotu, nia lori baa-mai, toꞌo rai ida, naran Negeb, iha rai Kanaꞌan lorokbelan baa. ");
INSERT INTO tet_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Baa tinan ida, rai salaen boot iha rai Kanaꞌan. Tan baa nia, Abram sia lori soruk tenik baa lorokbelan, toꞌo rai Mesir. Sia nein heik iha nia. ");
INSERT INTO tet_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Oras sia atu tama baa rai Mesir, Abram katak baa feen Sarai naꞌak, “Sarai, o neꞌe, feto kabaas basuk. ");
INSERT INTO tet_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kalo ema Mesir sia naree o kabaas nuneꞌe, nanis sia atu noꞌo haꞌu, tan haꞌu neꞌe okaan laꞌen! Hodi nunia, sia bele nola o. ");
INSERT INTO tet_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Diꞌak liu, o katak baa sia maꞌak, haꞌu neꞌe okaan maun. Hodi nunia, sia la noꞌo haꞌu. Mais sia diꞌa-diꞌak no haꞌu, tan o.” ");
INSERT INTO tet_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Sia toꞌo Mesir tiꞌan, ema naree nola feto kabaas basuk nia. ");
INSERT INTO tet_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Baa oras naꞌi Mesir klosan sia naree nola nia, sia moos tonu feto kabaas nia iha naꞌin oin. Hotu, sia nodi feto nia baa naꞌin tofatik. ");
INSERT INTO tet_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Naꞌin diꞌa-diꞌak no Abram, tan Sarai. Nia foo loos bibi no bibi malae, karau baka, kuda keledai no kuda unta baa Abram. Naꞌin moos foo loos ata feto no ata mane. ");
INSERT INTO tet_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mais, MAROMAK natuun kastikar oi-oik baa naꞌin nia no niakaan ema sia, tan nola ema feen, natama baa tofatik. ");
INSERT INTO tet_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Hotu, naꞌin bolu nola Abram nodi nusu naꞌak, “Abram! O malo nunabee baa haꞌu neꞌe? Tan saa o la katak sain maꞌak feto neꞌe, okaan feen? ");
INSERT INTO tet_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mais o maꞌak, o alin! Teni oan ida dei, kola nia baa haꞌukaan feen tiꞌan! Tan nia neꞌe okaan feen, oras neꞌe modi baa ona. Sees ona mosi haꞌukaan oin!” ");
INSERT INTO tet_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Hotu, naꞌin naruka klosan sia teꞌur nasai Abram no Sarai sai nosi rai nia, nodi siakaan naha hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hotu, Abram laꞌo nela Mesir, baa nikar rai Negeb. Nodi feen no sasoin hotu-hotu. Alin oan Lot moos tuir no. ");
INSERT INTO tet_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Oras nia, Abram soi tebes. Niakaan bibi no karau sia, waꞌin basuk. Niakaan mean-mutin moos, waꞌin tebes. ");
INSERT INTO tet_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nosi Negeb, Abram lori baa-mai toꞌo nikar fatin uluk mak nariik taroman iha leo Betel no leo Ai leet. ");
INSERT INTO tet_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Toꞌo fatin nia, nia nalo sera nodi loꞌu-sudur baa MAROMAK iha taroman nia. ");
INSERT INTO tet_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Oras nia, Lot namutuk no Abram. Lot moos noo bibi no karau waꞌin. Niakaan ema serwisu moos waꞌin. ");
INSERT INTO tet_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Abram no Lot la bele nein namutuk iha fatin nia, tan loot basuk. Siakaan makbalin sia toe malu, tan hae iha fatin nia la toꞌo bodik siakaan bibi no karau sia. (Baa oras nia, ema Kanaꞌan no ema Feris moos sei nein iha nia). ");
INSERT INTO tet_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Hotu, Abram katak baa oan Lot naꞌak, “Lot! Ita neꞌe, oan-aman. Keta toꞌo ita rua la kona malu, hotu itakaan ema serwisu sia moos nakaat malu bei-beik. ");
INSERT INTO tet_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Diꞌak liu, ita rua faꞌe malu ona. Rai neꞌe luan. Kalo o boi mola rai iha sorin karuk, haꞌu kola iha sorin kwana. Mais, kalo o boi mola iha sorin kwana, haꞌu kola iha karuk.” ");
INSERT INTO tet_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Rona nola nunia, Lot titu satan leur. Titu naree rai fehan mota Yordan mak noo wee soe haa haat, toꞌo leo Soar. Fatin nia boran tebe-tebes, manesak no MAROMAK toꞌos etu, no rai Mesir. (Baa oras nia, MAROMAK sei la nabeꞌo dodok dauk kota Sodom no kota Gomora. Dadi, rai nia sei furak). ");
INSERT INTO tet_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","12","Hotu, Lot boi nola rai hotu-hotu iha rai fehan mota Yordan nia. Hotu, sia rua faꞌe malu. Abram nein nafati iha rai Kanaꞌan. Lot baa lorosaꞌe, nein iha leo mak kreꞌis kota Sodom iha rai fehan mota Yordan. ");
INSERT INTO tet_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Iha rai nia, ema Sodom sia aat liu resik, toꞌo la noꞌuk rona baa MAROMAK. ");
INSERT INTO tet_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot no Abram faꞌe malu tiꞌan, MAROMAK katak baa Abram naꞌak, “Abram! Soe kokon matan satan leur, mana fatin hotu-hotu mosi o mariik fatik nia. Maree diꞌa-diꞌak oin-kotuk, karuk-kwana. ");
INSERT INTO tet_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tan rai hotu-hotu mak o maree nia, Haꞌu atu klatan baa o mo okaan husar-binan, dadi baa emikaan bein sasoin toꞌo nima-nimak. ");
INSERT INTO tet_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Haꞌu atu kalo okaan husar-binan bea waꞌin, hanesan raihenek iha tasi tehen mak ema la bele sura nola. ");
INSERT INTO tet_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Oras neꞌe, laꞌo masirin rai neꞌe naruk no belar. Tan Haꞌu atu klatan hotu-hotu baa o!” ");
INSERT INTO tet_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Hotu, Abram sia moos lori baa nein nikar iha fatin kreꞌis baa ai huun boot sia iha Mamre, mak kreꞌis leo Hebron. Toꞌo baa, nia nalo tenik taroman, nodi loꞌu-sudur baa MAROMAK. ");
INSERT INTO tet_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Baa oras nia, naꞌin haat libur malu. Sia nia, Amrafel, naꞌi rai Sinear. Ariok, naꞌi rai Elasar. Kedarlaomer, naꞌi rai Elam. No Tideal, naꞌi rai Goyim. ");
INSERT INTO tet_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Baa oras nia moos, naꞌin lima seluk moos libur malu. Sia nia, Bera, naꞌi rai Sodom. Birsa, naꞌi rai Gomora. Sinab, naꞌi rai Adema. Semeber, naꞌi rai Seboim. No Bela, naꞌi rai Soar. Hotu, naꞌin haat ohin nia natuda sakar naꞌin lima seluk nia. ");
INSERT INTO tet_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Naꞌin lima nia libur malu no siakaan sondadu sia iha rai fehan Sidim (mak oras neꞌe ema temi naꞌak, Tasi Maten). ");
INSERT INTO tet_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Hatuda nia, lia huun-abut nuneꞌe: Uluk, naꞌin lima nia loꞌu baa naꞌi Kedarlaomer toꞌo tinan sanulu resin rua. Mais tama baa tinan sanulu resin tolu, naꞌin lima nia moos nariik sakar nia. ");
INSERT INTO tet_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tama baa tinan sanulu resin haat, naꞌi Kedarlaomer no niakaan mamaluk naꞌin tolu nia, mai nodi siakaan sondadu sia. Hotu, sia natuda natoba nola ema rai hira sia, mak ema Refaim iha rai Asterot-Karnaim, ema Susim iha rai Ham, ema Emim iha rai Sawe-Kiryataim, ");
INSERT INTO tet_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","no ema Hori, mak nein iha foho Seir toꞌo raihenek molik El Paran diꞌin. ");
INSERT INTO tet_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hotu, sia laꞌo sees liu baa En Mispat, (mak oras neꞌe naran Kades). Hotu, sia nabeꞌo dodok ema Amalek rain, no ema Amori, mak nein iha rai Haseson-Tamar. ");
INSERT INTO tet_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Nosi ikus, naꞌin lima nia nahulin siakaan sondadu sia iha rai fehan Sidim, nodi natuda sakar naꞌin haat nia. ");
INSERT INTO tet_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Iha rai fehan nia, noo debu kriꞌit waꞌin. Baa oras sia natuda nia, naꞌi Sodom no naꞌi Gomora no siakaan sondadu sia niꞌit aan nalai lakon. Balu monu tama baa debu kriꞌit nia sia. Balu tenik nalai baa foho. ");
INSERT INTO tet_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Hotu, naꞌin haat mak natoba nola funu nia sia, tama baa nadau nola naha no haan hotu-hotu nosi kota Sodom no Gomora. ");
INSERT INTO tet_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Baa oras nia, Abram alin oan Lot, sei nein iha kota Sodom. Naꞌin haat nia moos kohi nodi Lot sia, nodi nadau nola siakaan naha hotu-hotu. Hotu, naꞌin haat nia sia nahuu fila nikar. ");
INSERT INTO tet_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mais, ema ida nakbois sai. Nia nalai kedan baa katak Abram, ema Ibrani nia. Baa oras nia, Abram nein kreꞌis baa ema ida niakaan ai horis boot. Ema nia, ema Amori, naran Mamre. Mamre alin sia, Eskol no Aner. Sia neꞌe dadi baa Abram niakaan partee. ");
INSERT INTO tet_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram rona nola ema kohi nola niakaan alin oan Lot, nia libur niakaan meo sia. Sura sia hotu-hotu, ema naꞌin atus tolu sanulu resin walu. Hotu, sia baa teꞌur tuir naꞌin haat nia, toꞌo leo Dan mak dook iha lorokaras. ");
INSERT INTO tet_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Toꞌo nebaa, Abram faꞌe niakaan meo sia, nalo baa klibur hira sia. Baa kalan nia, sia natuda funu sia nodi teꞌur toꞌo leo Hoba iha kota Damsik lorokaras. ");
INSERT INTO tet_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hotu, Abram nadau nola nikar Lot no niakaan ema sia, no siakaan naha hotu-hotu, no ema seluk sia. ");
INSERT INTO tet_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram fila nikar nosi natuda natoba naꞌin haat nia, naꞌi Sodom mai nasoru nia iha rai fehan Sawe (mak ema temi naꞌak, Rai Fehan Naꞌin). ");
INSERT INTO tet_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Baa oras nia, noo kota Salem naꞌin naran Melkisedek. Nia moos naꞌilulik nosi Maromak mak Aas Kaliuk. Melkisedek mai foo tubi no anggor ween baa Abram. ");
INSERT INTO tet_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Hotu, nia nusu matak-malirin bodik Abram nodi katak naꞌak, “Maromak, mak Aas Kaliuk no mak naseꞌi laleꞌan no raiklaran. Haꞌu kaloon nebee Nia natuun matak-malirin baa o. Tonu Maromak! Nia mak nalo o matoba mola funu sia!” Hotu, Abram faꞌe foo baa Melkisedek, faꞌek ida nosi fafaꞌek sanulu nosi sa-saa hotu-hotu mak nia nadau nola nikar nia. ");
INSERT INTO tet_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nunia hotu, naꞌi Sodom katak baa Abram naꞌak, “Ama Abram! Naha hotu-hotu mak ama nadau nola nosi haꞌukaan funu sia, ama nola dei ona! Haꞌu kusu kikar haꞌukaan ema sia dei.” ");
INSERT INTO tet_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mais Abram nataa naꞌak, “Haꞌu karai aan iha Maromak oin. Nia mak Aas Kaliuk, no mak naseꞌi laleꞌan no raiklaran. ");
INSERT INTO tet_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Kaꞌak, haꞌu la kola naha saa ida kosi okaan naha sia! Masik kabas lahon ida moos, haꞌu la kola! Hodi nunia, o la bele dale maꞌak, ‘Abram soi tan haꞌu.’ ");
INSERT INTO tet_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Haꞌu la kbuka sa-saa. Haꞌu ksimu loos saa mak haꞌukaan ema sia netan tiꞌan. Mais habusik haꞌukaan mamaluk naꞌin tolu neꞌe, mak Aner, Eskol no Mamre, ida-idak nola siakaan fafaꞌek.” ");
INSERT INTO tet_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hotu, MAROMAK natadu aan baa Abram naꞌak, “Hei Abram! Lalika mataꞌuk! Haꞌu mak sara kola o nosi funu! Haꞌu moos atu foo sotir boot baa o!” ");
INSERT INTO tet_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Mais Abram nataa naꞌak, “Aaa! Naꞌi Maromak! Masik foo waꞌin nunia moos, la no folin! Tan haꞌu la koo oan atu foo husar-binan baa haꞌu! Masik koo sasoin oi-oik moos, kodi kalo saa? Tan Haꞌu la koo oan, habusik haꞌukaan atan Eliasar nosi Damsik dei mak netan Haꞌukaan sasoin hotu-hotu!” ");
INSERT INTO tet_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mais MAROMAK nataa naꞌak, “La nunia! Okaan oan duꞌuk mak netan okaan sasoin nia. Lahoos okaan atan.” ");
INSERT INTO tet_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nunia tiꞌan, Maromak nalaꞌo nodi Abram sai, hotu katak baa nia naꞌak, “Tanaat baa laleꞌan! Maree kokon fitun nia sia. O bele sura mola sia ka lale? Okaan husar-binan nanis atu bea hanesan fitun nia sia!” ");
INSERT INTO tet_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Rona nola nunia, Abram fiar kedan baa MAROMAK. Hotu, MAROMAK nafoli Abram naꞌak, ema loos, tan Abram niakaan fiar. ");
INSERT INTO tet_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Hotu, MAROMAK natutan tenik naꞌak, “Haꞌu neꞌe Maromak mak kodi o sai kosi leo Ur iha ema Kasdim rain, nebee Haꞌu klatan rai neꞌe baa o, dadi baa sasoin bodik o mo okaan husar-binan sia.” ");
INSERT INTO tet_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mais Abram nusu naꞌak, “MAROMAK? Oin nunabee, haꞌu kbele katene rai neꞌe nanis dadi baa haꞌukaan sasoin?” ");
INSERT INTO tet_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Maromak nataa naꞌak, “Ita halo lahan ida lai, atu hamate lia mak Haꞌu kdale ohin nia. Lahan nia nuneꞌe! O baa mola karau baka inan matan ida, bibi inan matan ida, no bibi malae aman matan ida. Ida-idak musti otas tinan tolu tiꞌan. Hotu, modi tenik mai, manu lakateu matan ida no manu lakateu sina matan ida.” ");
INSERT INTO tet_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Rona nola nunia, Abram baa nola kedan. Hotu, nia saki faꞌe rua karau baka, bibi no bibi malae nia. Nahulin naꞌan nia sia, faꞌe baa rua, butuk iha rai. Faꞌek ida seꞌi oin baa ida, dadi baa tuik rua. Mais nia la saki faꞌe manu nia sia. ");
INSERT INTO tet_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nunia hotu, manu kawaa sia semo mai atu naa naꞌan nia sia. Mais Abram nabuꞌa lakon sia. ");
INSERT INTO tet_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Loro monu, Abram toba dukur. Nia meꞌi naꞌak, nakukun luri taka nola nia, toꞌo nia nataꞌuk tebe-tebes. ");
INSERT INTO tet_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Hotu, Maromak katak baa Abram naꞌak, “Abram! O atu moris toꞌo katuas basuk. O moos mate no-nook. Foin sia nakoi o diꞌa-diꞌak! Mais, okaan husar-binan sia atu dadi ema maktabar iha ema rain. Ema rai nia atu nalo sia baa ata, no tonan nasusar sia toꞌo tinan atus haat laran. Mais, Haꞌu nanis kastikar ema rai nia! Haꞌu atu kodi okaan husar-binan sai kosi rai nia. Sia moos loi nodi sasoin waꞌin nosi rai nia. ");
INSERT INTO tet_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Haꞌu moos kahulin nebee okaan husar-binan dala lima sia, fila nikar mai rai neꞌe. Oras neꞌe, ema Amori sia mak sei nein iha rai neꞌe. Sia moris aat, mais sei la duun resik. Nosi ikus, kalo okaan husar-binan sia fila mai nikar tiꞌan, Haꞌu kodi sia kalaꞌok kastikar, kodi kabeꞌo dodok ema Amori sia, tan baa oras nia, siakaan hahalok aat naksoit liu kladik tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Maromak katak tiꞌan, Abram moos naktekir. Kalan nia, teki-tekis sasanan rai ida nakboo, no klonus ida laka, nakfodak nalai liu tuir naꞌan tuik rua nia leet. ");
INSERT INTO tet_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Oras nia moos, MAROMAK namate menon no Abram naꞌak, “Haꞌu kameno atu klatan rai neꞌe baa okaan husar-binan. Nahuu nosi mota Mesir, toꞌo mota Efrat, ");
INSERT INTO tet_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","no rai ema Keni, rai ema Kenas, rai ema Kadmon, ");
INSERT INTO tet_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","rai ema Het, rai ema Feris, rai ema Refaim, ");
INSERT INTO tet_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","rai ema Amori, rai ema Kanaꞌan, rai ema Girgasi no rai ema Yebus sia.” ");
INSERT INTO tet_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Nunia tiꞌan, Abram nein iha Kanaꞌan tinan sanulu. Mais feen Sarai la netan oan dauk. Baa oras nia, Sarai noo ata feto ida nosi Mesir, naran Hagar. Dala ida, Sarai dale no Abram naꞌak, “Ama! MAROMAK sena-natoos haꞌukaan oa fatin tiꞌan. Diꞌak liu, ama toba mo haꞌukaan atan Hagar, nebee nia nahoris oan foo baa haꞌu.” Rona nola nunia, Abram simu feen dalen nia. Sarai latan Hagar, dadi baa Abram feen kiꞌik. ");
INSERT INTO tet_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram toba no Hagar, toꞌo koꞌus. Mais, baa oras Hagar natene nia koꞌus tiꞌan, nia loko aan nodi naraik Sarai. ");
INSERT INTO tet_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Natene nola nunia, Sarai dale baa Abram naꞌak, “Haꞌu mak klatan ata nia, dadi baa okaan feen kiꞌik. Mais baa oras nia natene nia koꞌus tiꞌan, nia naraik haꞌu! Neꞌe, okaan salan hotu-hotu! Habusik MAROMAK mak nakotu itakaan lia. Foin o matene!” ");
INSERT INTO tet_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Mais Abram nataa naꞌak, “Nuneꞌe! O neꞌe, feen kawaꞌik. Nia, feen kiꞌik dei! O mak moo beran ukun nia. O makara malo saa baa nia, loos o!” Hotu, Sarai natudu hahalok makaꞌas no Hagar, toꞌo Hagar niꞌit aan nalai. ");
INSERT INTO tet_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nia nalai toꞌo raihenek molik ida. MAROMAK Niakaan makbukar laleꞌan ida mai nasoru nia kreꞌis wee matan ida iha dalan baa Sur. ");
INSERT INTO tet_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Makbukar nia dale baa Hagar naꞌak, “Hei! O neꞌe, Hagar mak Sarai atan. Tan saa o iha neꞌe? O mosi nabee, atu baa nabee?” Hagar nataa naꞌak, “Haꞌu kalai kela haꞌukaan ina boot tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Hotu, makbukar nia namaus nia naꞌak, “Nuneꞌe! Diꞌak liu, o fila mikar baa okaan ina boot! Nia nalo saa baa o moos, simu dei. ");
INSERT INTO tet_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Keta mataꞌuk, tan Haꞌu atu kalo okaan husar-binan bea tebe-tebes, toꞌo ema la bele sura nola. ");
INSERT INTO tet_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Oras neꞌe, o moꞌi koꞌus. La kleur, o mahoris oa mane ida. O musti manaran nia, Ismael tan MAROMAK rona okaan tanis tiꞌan. (Isma-el neꞌe, lian hanesan lia fuan Ibrani naꞌak ‘Maromak rona’.) ");
INSERT INTO tet_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mais hanoin! Oan nia boot tiꞌan, nia atu moris nadook aan nosi maun-alin sia! Nia la natene rona ukun, hanesan kuda madaꞌek. Nia sakar se-see dei. Ema hotu-hotu moos atu sakar fila nia.” ");
INSERT INTO tet_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Rona nola nunia, Hagar naneo naꞌak, “Haꞌu karee MAROMAK tiꞌan. Nia mak titu no daka haꞌu.” Nahuu oras nia, Hagar bolu Maromak nodi naran “Maromak Mak Naliku Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tan lia nia, ema nanaran wee matan nia naꞌak, Beer Lahai Roi. Lia isin naꞌak, “wee matan nosi Nia mak moris, mak naliku haꞌu.” Wee matan nia, toꞌo oras neꞌe sei iha leo Kades no leo Beret leet. ");
INSERT INTO tet_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hotu, Hagar fila nikar. Nia moos nahoris oan mane ida mak Abram nanaran Ismael. ");
INSERT INTO tet_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Oras Hagar nahoris Ismael, Abram otas tinan walu nulu resin neen tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Oras Abram otas tinan siwi nulu resin siwi, MAROMAK natadu aan baa nia nodi naꞌak, “Haꞌu neꞌe, Maromak mak noo Beran Kaliuk! O musti tuir bei-beik Haꞌukaan hakara modi moris tuir dalan loos! ");
INSERT INTO tet_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Haꞌu atu kamate menon ko o, kodi kalo okaan husar-binan bea tebe-tebes!” ");
INSERT INTO tet_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Rona nola nunia, Abram nakniꞌa loꞌu-sudur toꞌo rai. Hotu, Maromak katak liu naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Haꞌu kamate menon ko o nuneꞌe: o atu dadi bei uluk bodik ema klubun waꞌin! Tan lia nia, nahuu oras neꞌe, okaan naran lahoos Abram tenik, mais Abraham (tan abraham lia isin naꞌak ‘bei uluk mak nariik ema klubun waꞌin’). ");
INSERT INTO tet_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Haꞌu atu kalo okaan husar-binan bea tebe-tebes! Haꞌu moos atu kariik ema klubun waꞌin nosi sia, kodi foti naꞌin lear nosi sia! ");
INSERT INTO tet_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Haꞌu kaer metis Haꞌukaan mamenon ko o mo okaan husar-binan toꞌo nima-nimak! Mamenon neꞌe la nakotu, nebee Haꞌu kdadi Maromak bodik o mo okaan husar-binan. ");
INSERT INTO tet_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Haꞌu atu klatan to-tomak rai Kanaꞌan neꞌe baa o mo okaan husar-binan! Oras neꞌe, o mein heik iha neꞌe dei! Mais okaan husar-binan atu netan rai Kanaꞌan neꞌe toꞌo nima-nimak! Haꞌu atu kdadi baa siakaan Maromak! ");
INSERT INTO tet_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Mais o mo okaan husar-binan musti malaꞌo mamenon neꞌe hodi tadak hamane aan! ");
INSERT INTO tet_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Nahuu baa oras neꞌe, ema mane hotu-hotu musti namane aan, nahuu nosi otas foin loron walu. Okaan familin, okaan ema serwisu, no okaan ata mak o sosa tiꞌan mosi rai seluk, hotu-hotu musti namane aan! Hamane aan nia dadi tadak hamate menon bodik ita rua. Tadak nia atu nakriꞌit aan baa emi ida-idak! ");
INSERT INTO tet_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mane nabee mak la namane aan, nia la tama baa Haꞌukaan mamenon neꞌe. Nia moos la dadi baa Haꞌukaan ema!” ");
INSERT INTO tet_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Hotu, Maromak katak liu naꞌak, “Nahuu oras neꞌe, keta bolu tenik o feen maꞌak Sarai. O musti bolu nia maꞌak Sara! ");
INSERT INTO tet_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Haꞌu atu katuun matak-malirin waꞌin baa Sara, nebee nia nahoris oan mane ida foo baa o! Tebes! Sara atu dadi bei uluk bodik ema klubun waꞌin. Haꞌu moos atu foti naꞌin lear nosi niakaan husar-binan!” ");
INSERT INTO tet_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Rona nola nunia, Abraham nakniꞌa loꞌu-sudur toꞌo rai. Mais, nia nanasa iha neon naꞌak, “Mane katuas otas tinan atus ida nuꞌu haꞌu neꞌe, oin nunabee sei bele ketan oan tenik? Sara moos ferik maran tiꞌan, otas tinan siwi nulu ona. Oin nunabee, nia sei bele nahoris?” ");
INSERT INTO tet_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Hotu, Abraham nasara baa Maromak naꞌak, “MAROMAK! Masik Ismael dei mak netan haꞌukaan sasoin moos, la saa ida!” ");
INSERT INTO tet_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mais Maromak nataa naꞌak, “Lale, Abraham! Okaan feen Sara atu nahoris oan mane ida! O musti tau naran baa nia, Isak! Haꞌukaan mamenon atu tuun baa nia no niakaan husar-binan toꞌo nima-nimak! ");
INSERT INTO tet_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mais Haꞌu moos rona tiꞌan, saa mak o musu bodik Ismael! Tan nia, Haꞌu moos katuun matak-malirin baa nia, kodi kalo bea niakaan husar-binan toꞌo dadi baa ema klubun boot. Ema fukun naꞌin sanulu resin rua atu mosu nosi husar-binan nia! ");
INSERT INTO tet_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Masik nunia moos, Haꞌukaan mamenon neꞌe nakriꞌit baa okaan oan Isak dei! Tinan oin, kona baa oras nuneꞌe, Sara nahoris oan nia!” ");
INSERT INTO tet_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Katak notu tiꞌan, Maromak laꞌo nela Abraham. ");
INSERT INTO tet_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Baa loron nia moos, Abraham nalaꞌo kedan tuir Maromak ukun. Nia naꞌin duꞌuk namane aan. Hotu, nia nalo hamane aan baa Ismael, no ema mane hotu-hotu iha niakaan uman laran. Nia moos nalo hamane aan baa niakaan ata mane sia hotu-hotu. Baa oras nia, Abraham otas tinan siwi nulu resin siwi tiꞌan. Ismael, otas tinan sanulu resin tolu. ");
INSERT INTO tet_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Oras Abraham nein kreꞌis baa ai huun boot sia iha Mamre, MAROMAK natadu aan baa nia. Lia nia nuneꞌe: loron nia, manas basuk. Tan baa nia, Abraham tuur nola anin iha batane oin. ");
INSERT INTO tet_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Nia foti oin, naree ema naꞌin tolu nariik iha nebaa. Hotu, nia nalai baa nasoru sia. Nia moos nakniꞌa ");
INSERT INTO tet_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","nodi dale naꞌak, “Ama sia! Kalo bele, tuli sala-sala iha haꞌukaan batane lai. Masik hemu loos wee tanan dei moos, diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Emi bele hanawa kole iha ai leon. Oan sia atu nodi wee mai fasi ama sia ain. ");
INSERT INTO tet_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Haꞌu moos kadiꞌa haan bodik ama sia nebee hetan biit oda, foin ama sia laꞌo liu. Haꞌu neon diꞌak, kalo bele kaliku ama sia.” Rona nola nunia, sia nataa naꞌak, “Diꞌak. Ami tuli.” ");
INSERT INTO tet_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Hotu, Abraham nalai baa batane, katak baa Sara naꞌak, “Lai-lais! Mola tubi rahun kabaas kakaluk ida, malo baa tubi.” ");
INSERT INTO tet_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nia moos nalai baa karau baka laluꞌan, boi nola karau baka oan bokur ida. Naruka ata sia koꞌa karau baka nia. ");
INSERT INTO tet_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Hotu, nia nola susu, susu kedu no naꞌan tasan nia, foo baa bainaka sia. Oras sia naa, Abraham nariik nodi naliku sia iha ai leon. ");
INSERT INTO tet_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nunia hotu, sia nusu baa Abraham naꞌak, “O feen Sara iha nabee?” Nia nataa naꞌak, “Iha batane laran.” ");
INSERT INTO tet_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Hotu, bainaka ida naꞌak, “Takseer tinan oin, haꞌu kmai kikar. Baa oras nia, o feen Sara nahoris oan mane ida tiꞌan.” Oras sia dale nunia, Sara nanono nosi batane laran. ");
INSERT INTO tet_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Rona sia dale nunia, Sara nanasa iha neon, tan Abraham no Sara otas basuk tiꞌan. Sara moos nanawa nasoru fulan tiꞌan. Nia naneo naꞌak, “Adeei! Haꞌu neꞌe, ferik maran tiꞌan! Haꞌukaan laꞌen moos katuas basuk tiꞌan! Nunabee ami sei beer malu nuꞌu ema uma kain foun mak atu buka oan?” ");
INSERT INTO tet_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Hotu, MAROMAK nusu baa Abraham naꞌak, “Sara nanasa baa saa? Arumak nia naneo haꞌu kdale neꞌe la bele dadi, tan nia ferik tiꞌan? ");
INSERT INTO tet_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Haꞌu neꞌe, MAROMAK! La noo saa mak Haꞌu la kbele kalo! Manoin diꞌa-diꞌak! Tinan oin Haꞌu kmai kikar neꞌe, Sara nahoris nola oa mane ida tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Rona nunia, Sara nataꞌuk. Hotu nia neli naꞌak, “Haꞌu la kanasa!” Mais Maromak nataa naꞌak, “Tebes! Ohin o manasa.” ");
INSERT INTO tet_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hotu, bainaka naꞌin tolu nia moos tami, atu baa kota Sodom. Abraham no nela sia baa, toꞌo dalan klaran. Nosi fatin nia, sia bele naree kota Sodom. ");
INSERT INTO tet_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Hotu, MAROMAK naneo naꞌak, “Diꞌak liu, Haꞌu katak baa Abraham lia saa mak atu kalo baa kota Sodom. ");
INSERT INTO tet_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tan Abraham husar-binan atu bea tuꞌan, dadi baa ema klubun boot. Nia moos dadi matak-malirin bodik ema klubun hotu-hotu iha raiklaran. ");
INSERT INTO tet_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Haꞌu kboi nia tiꞌan, nebee nanorin niakaan oan, no ema seluk sia atu tuir bei-beik Haꞌukaan dalan nodi moris loos no moon. Kalo sia moris nunia, Haꞌu moos kalaꞌo Haꞌukaan mamenon ko Abraham.” ");
INSERT INTO tet_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Naneo notu nunia, MAROMAK katak baa Abraham naꞌak, “Nuneꞌe! Haꞌu krona tiꞌan ema waꞌin nakroꞌan, tan ema Sodom no Gomora siakaan aꞌaat! ");
INSERT INTO tet_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tan lia nia, Haꞌu ktuun duꞌuk atu katene lia mak Haꞌu krona nia, tebes ka lale.” ");
INSERT INTO tet_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","MAROMAK sei dale no Abraham, bainaka naꞌin rua laꞌo liu baa kota Sodom. ");
INSERT INTO tet_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Hotu, Abraham nareꞌis aan baa Maromak nodi namaus naꞌak, “Nunabee? Ama nakara nadodok ema diꞌak no aat bele-bele ka? ");
INSERT INTO tet_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kalo noo ema diꞌak naꞌin lima nulu iha kota nia, Ama sei nadodok luku kota nia ka lale? ");
INSERT INTO tet_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Keta hadodok. Keta toꞌo ema diꞌak sia moos mate, tan Ama nakara nadodok ema aat. Ama mak Makotu Lia bodik laleꞌan no raiklaran. Ama duꞌuk natene, hahalok nunia la moon.” ");
INSERT INTO tet_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","MAROMAK nataa naꞌak, “Kalo Haꞌu ketan ema diꞌak naꞌin lima nulu iha kota Sodom, Haꞌu la kastikar kota nia.” ");
INSERT INTO tet_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham moos dale tenik naꞌak, “Ama, atu kusu leet oda, kalo haꞌu kbele dale tenik. Haꞌu neꞌe, ema raiklaran la katene sa-saa. ");
INSERT INTO tet_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kalo ema diꞌak la toꞌo naꞌin lima nulu, mais Ama netan loos naꞌin haat nulu resin lima dei, nunabee? Kalo la noo ema naꞌin lima dei, Ama sei nadodok kota nia ka?” Maromak nataa naꞌak, “Kalo Haꞌu ketan ema diꞌak, naꞌin haat nulu resin lima iha nia, Haꞌu la kadodok kota nia.” ");
INSERT INTO tet_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Hotu, Abraham namaus tenik naꞌak, “Kalo Ama netan loos ema diꞌak naꞌin haat nulu dei, nunabee?” Maromak nataa naꞌak, “Kalo Haꞌu ketan ema naꞌin haat nulu, Haꞌu la kastikar kota nia.” ");
INSERT INTO tet_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Hotu, Abraham namaus tenik naꞌak, “Ama keta kanarak. Kalo ema diꞌak naꞌin tolu nulu dei, nunabee?” Maromak nataa naꞌak, “Kalo Haꞌu ketan ema naꞌin tolu nulu, Haꞌu la kastikar kota nia.” ");
INSERT INTO tet_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham namaus taꞌe natuun tenik naꞌak, “Ama keta kanarak kalo haꞌu kusu oda tenik. Kalo Ama netan loos ema naꞌin rua nulu dei, nunabee?” Maromak moos nataa tenik naꞌak, “Kalo Haꞌu ketan ema naꞌin rua nulu, Haꞌu la kadodok kota nia!” ");
INSERT INTO tet_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Hotu, Abraham moos taka lia naꞌak, “Ama! Haꞌu kdale dala ida tenik, mais ama keta kanarak haꞌu! Kalo Ama netan loos ema diꞌak naꞌin sanulu dei, nunabee?” Maromak moos nataa naꞌak, “Kalo Haꞌu ketan ema diꞌak naꞌin sanulu iha nia, Haꞌu la kadodok kota nia.” ");
INSERT INTO tet_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Dale hotu baa malu nunia, MAROMAK laꞌo liu. Abraham moos fila. ");
INSERT INTO tet_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Maromak sei dale no Abraham, makbukar laleꞌan naꞌin rua nia liu baa kota Sodom. Toꞌo nebaa, loro atu monu ona. Baa oras nia, Lot noꞌi tuur iha kota odamatan nanokar. Naree ema rua nia, Lot baa nasoru sia. Hotu, nia nakniꞌa nodi loꞌu-sudur baa sia. ");
INSERT INTO tet_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Nia moos dale naꞌak, “Ama sia! Tuli heik iha haꞌukaan uman lai! Fasi ain lai, hotu toba iha haꞌukaan uma. Awan seisawan, foin ama sia laꞌo liu.” Mais sia nataa naꞌak, “Lalika! Ami toba iha kota rai molik dei.” ");
INSERT INTO tet_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mais Lot namaus sia bei-beik, toꞌo sia moos simu. Hotu Lot sia nalo tubi, nadiꞌa haan waꞌin, hotu sia naa bele-bele. ");
INSERT INTO tet_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bainaka nia sia sei la toba dauk, ema mane Sodom kiꞌik-boot hotu-hotu, mai lisuk nola Lot uman. ");
INSERT INTO tet_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Sia nahii nakaꞌas baa Lot naꞌak, “Hoi Lot! Mane rua ohin nia iha nabee? Masai sia mai, nebee ami saꞌe heet sia!” ");
INSERT INTO tet_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Rona nunia, Lot sai baa, taka kedan odamatan. ");
INSERT INTO tet_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Nia dale baa sia naꞌak, “Maun-alin sia! Emi keta halo aat nunia baa haꞌukaan bainaka. ");
INSERT INTO tet_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Emi rona! Haꞌu koo oa feto naꞌin rua. Sia sei lawarik. Soꞌin baa, haꞌu klatan sia rua baa emi. Emi hakara halo saa baa sia, loos emi dei. Mais emi keta halo sa-saa ho haꞌukaan bainaka neꞌe sia, tan tuir amikaan adat, haꞌu kmusti kaliku sia diꞌa-diꞌak.” ");
INSERT INTO tet_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mais ema Sodom sia nahii naꞌak, “O keta kahur! O ema maktabar dei iha neꞌe! O ema luan. O la moo beran babilan ami. Diꞌak liu, o sees sai mosi neꞌe. Kalo lale, ami halo o todan liu tan ema rua nia!” Sia moos dudu sees Lot, hotu sia baa basak bele-bele odamatan atu nadodok uma nia odamatan. ");
INSERT INTO tet_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mais bainaka rua nia lolo liman, dada natama Lot baa uma laran, hotu kusa kedan odamatan. ");
INSERT INTO tet_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hotu, sia nadelek ema Sodom nia sia matan. Tan baa nia, ema Sodom sia naꞌin lelemas buka odamatan, mais sia la netan. ");
INSERT INTO tet_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Hotu, bainaka rua nia dale baa Lot naꞌak, “Lot! MAROMAK natene kota neꞌe niakaan aꞌaat tiꞌan. Nia solok ami mai nebee hadodok kota neꞌe. O sei moo famili seluk iha neꞌe ka lale? Kalo o moo oan mane, lale oan feto, lale oa laꞌen, lale se-see dei, diꞌak liu mola sia sai mosi kota neꞌe ona!” ");
INSERT INTO tet_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Rona nola nunia, Lot baa nasoru niakaan oan feto sasudin naꞌin rua. Nia katak naꞌak, “Rona! Emi musti sai lai-lais hosi kota neꞌe ona, tan MAROMAK atu nadodok kota neꞌe!” Mais sia naꞌak falik Lot dale nakdiuk dei. ");
INSERT INTO tet_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Awan seisawan, makbukar naꞌin rua nia moos seten Lot sai lai-lais ona. Sia naꞌak, “Lot! Madeer! Modi okaan feen, no oan feto rua nia, halai ona! Halai hela kota neꞌe. Keta toꞌo emi mate butan, dodok ho kota neꞌe.” ");
INSERT INTO tet_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tuir loos, MAROMAK nakara sori Lot. Mais nia sei naleur aan. Tan lia nia, bainaka rua nia kaer nola siakaan liman, dada sai Lot no familin sia nosi kota nia. ");
INSERT INTO tet_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Hotu, bainaka ida naruka naꞌak, “Halai lai-lais, baa sori aan! Keta mana baa kotuk! Keta hanawa iha rai fehan! Halai saꞌe liu baa foho nebaa, nebee keta mate!” ");
INSERT INTO tet_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mais Lot nataa naꞌak, “Adeei, ama! Keta nunia! ");
INSERT INTO tet_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ama tulun no sori ami tiꞌan! Mais foho nia dook resik! Keta-keta, ami sei la toꞌo daꞌuk, dinu toma ami tiꞌan iha dalan klaran! ");
INSERT INTO tet_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ama maree lai! Noo leo kiꞌik ida la dook nosi neꞌe! Masik leo nia la noo folin, kalo ama makara, soꞌin baa, ami baa sori aan iha nebaa dei.” ");
INSERT INTO tet_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Hotu, bainaka nia naꞌak, “Bele! Baa ona! Haꞌu la kadodok leo nia. ");
INSERT INTO tet_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Lai-lais baa nebaa ona! Tan haꞌu la kbele kalo sa-saa ida, kalo emi sei la toꞌo dauk.” Nahuu baa oras nia, ema nanaran leo nia naꞌak, ‘Soar’. Lia isin naꞌak, ‘kiꞌik’. ");
INSERT INTO tet_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Loro atu saꞌe, Lot sia toꞌo Soar. ");
INSERT INTO tet_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Teki-tekis, MAROMAK fakar haꞌi no fatuk laak lobot nosi laleꞌan, tuun baa Sodom no Gomora. ");
INSERT INTO tet_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","MAROMAK nadodok mohu kota no leo hotu-hotu iha rai nia. Nadodok ema no hotu-hotu mak moris iha nia. ");
INSERT INTO tet_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Baa oras sia nalai, Lot feen mana nikar kotuk. Sarebak, nia dadi kedan ai riin masin ida. ");
INSERT INTO tet_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Awan seisawan, Abraham baa nikar fatik hori sehik nia nodi namaus MAROMAK. ");
INSERT INTO tet_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Nia mana tuun baa Sodom no Gomora, no rai fehan nia tomak. Iha fatin hotu-hotu, nia naree haꞌi dubun saꞌe baa laleꞌan. Haꞌi naa mohu sa-saa hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Oras Maromak nadodok kota nia sia, Nia nanoin Niakaan mamenon baa Abraham. Tan lia nia, Nia nasai Lot nosi fatin mak kona kastikar nia. ");
INSERT INTO tet_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Hotu Lot no oan feto naꞌin rua nia lori baa foho. Sia nein iha fatuk kuak ida, tan sia nataꞌuk nein nafati iha leo Soar. ");
INSERT INTO tet_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Dala ida, oan feto biin dale baa alin naꞌak, “Iha neꞌe la noo mane ida atu nola ita. Itakaan ama hetak katuas. La kleur, ama la bele netan oan tenik ona. ");
INSERT INTO tet_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Diꞌak liu, ita haroo halanu ama, nebee bele ita toba ho ama, atu hatutan niakaan husar-binan.” ");
INSERT INTO tet_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Kalan nia moos, sia naroo nalanu aman nodi anggor ween. Hotu, oan feto biin toba no aman. Mais katuas lanu todan basuk, toꞌo la natene nia nalo saa tiꞌan no oan feto nia. ");
INSERT INTO tet_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Baa awan, biin katak baa alin naꞌak, “Ali! Haꞌu ktoba ko ama tiꞌan. Ohin kalan neꞌe, ita haroo halanu tenik ama, nebee o moos toba mo nia! Hodi nunia, ita rua bele hetan oan, nebee atu hatutan ama husar-binan.” ");
INSERT INTO tet_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kalan nia moos, sia naroo nalanu aman tenik. Hotu, oan ikun tama toba no aman. Mais katuas lanu todan basuk, toꞌo la natene nia nalo saa tiꞌan no oan feto. ");
INSERT INTO tet_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Hodi hahalok nunia, sia rua koꞌus nosi aman susun duꞌuk. ");
INSERT INTO tet_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nosi ikus, oan feto biin nahoris nola oan mane ida. Nia nanaran oa nia naꞌak Moab (tan moab neꞌe, lian hanesan lia fuan Ibrani naꞌak ‘mai nosi ama’). Oa nia, mak dadi baa ema Moab oras neꞌe, siakaan bei uluk. ");
INSERT INTO tet_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Hotu, oan feto alin moos nahoris nola oan mane ida. Nia nanaran oa nia naꞌak Ben Ami (tan ben-ami neꞌe, lian hanesan lia fuan Ibrani naꞌak ‘oa nosi haꞌukaan eman sia’). Oa nia, mak dadi baa ema Amon oras neꞌe, siakaan bei uluk. ");
INSERT INTO tet_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Hotu, Abraham lori nosi Mamre baa rai Negeb iha rai Kanaꞌan lorokbelan. Nia nein iha fatin ida iha leo Kades no leo Syur leet. Hotu, nia lori tenik baa leo Gerar atu nein heik iha nia. ");
INSERT INTO tet_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Toꞌo nebaa, nia katak baa ema naꞌak, Sara nia, niakaan alin. Oras nia, naꞌi rai Gerar naran Abimelek. Rola nola lia nia, Abimelek naruka niakaan ema sia baa saka nola Sara, nodi baa naꞌin tofatik. ");
INSERT INTO tet_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mais kalan ida, Maromak natadu aan baa Abimelek tuir meꞌi naꞌak, “O makara buka mate mak neꞌe! Tan o mola ema seluk feen.” ");
INSERT INTO tet_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Mais naꞌin simu naꞌak, “Naꞌi Maromak! Haꞌu ksei la rose aan baa feto nia. Haꞌu la sala. Abraham mak naꞌak duꞌuk, feto nia niakaan alin! Feto nia duꞌuk moos katak nunia! Tan lia nia, haꞌu karuka ema baa nola nia, kodi neon moos! Dadi Naꞌi Maromak keta masalak haꞌu!” ");
INSERT INTO tet_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Hotu, Maromak nataa naꞌak, “Tebes. Haꞌu katene o neon moos! Tan baa nia, Haꞌu ksaseni o, nebee keta rose aan baa feto nia! Hodi nunia, o la malo sala. ");
INSERT INTO tet_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Oras neꞌe, o musti solok fila feto nia baa laꞌen! Laꞌen nia, Haꞌukaan makoꞌan. Musu nia namulak bodik o, nebee o keta mate. Mais, kalo o la solok fila, manoin diꞌa-diꞌak! Tan o mo okaan ema sia hotu-hotu nanis mate!” ");
INSERT INTO tet_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Baa seisawan, Abimelek bolu nola niakaan klosan sia, hotu nasara meꞌi nia. Rona meꞌi nia, sia hotu-hotu nataꞌuk. ");
INSERT INTO tet_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Hotu, Abimelek bolu nola Abraham nodi nusu naꞌak, “Haꞌu kalo sala saa baa o, toꞌo o malo dinu kona baa haꞌu ko haꞌukaan renun nuneꞌe? La bele malo nuneꞌe. ");
INSERT INTO tet_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","O maneo saa, toꞌo malo nuneꞌe?” ");
INSERT INTO tet_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham nataa naꞌak, “Ama Naꞌi! Haꞌu kaꞌak falik emi la hatene Maromak! Tan baa nia, kataꞌuk ema atu noꞌo haꞌu, hotu nola haꞌukaan feen. ");
INSERT INTO tet_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Haꞌu kdale nia tebes, tan nia haꞌukaan alin tebes. Ami, aman ida, inan rua! Tan baa nia, ami hola malu dadi baa feen-laꞌen! ");
INSERT INTO tet_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Dadi, baa oras Maromak naruka ami rua baa ema rain, haꞌu katak baa haꞌukaan feen kaꞌak, ‘Kalo ita rua baa nabee dei, hotu ema nusu itakaan hatalin malu neꞌe, kalo o madomi haꞌu, o mataa maꞌak ita rua feton-naan’.” ");
INSERT INTO tet_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Rona nola nuneꞌe, naꞌi Abimelek foo fila Sara nodi katak baa naꞌak, “Oras neꞌe, haꞌu kselu baa okaan naan osan murak tomak rihun ida, dadi tadak naꞌak, haꞌu la kalo sala saa ida ko o! Nebee, ema hotu-hotu natene!” Hotu, naꞌin dale baa Abraham naꞌak, “Abraham! Haꞌukaan rai neꞌe, luan bodik o. O makara mein iha nabee dei moos, bele.” Hotu, naꞌin latan baa Abraham, karau baka, bibi no bibi malae. Naꞌin moos latan ata feto, ata mane. ");
INSERT INTO tet_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Uluk, MAROMAK taka notak feto hotu-hotu mak nein iha Abimelek rain, tan Abimelek nadau nola Abraham feen. Mais, oras Abimelek foo fila Sara, Abraham moos namulak, nebee Maromak loke nikar feto hotu-hotu notak. Hamulak tiꞌan, feto mak iha rai nia nahuu nahoris tenik. ");
INSERT INTO tet_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Nosi ikus, MAROMAK moos natuun matak-malirin baa Sara, tuir Niakaan mamenon. Baa oras Abraham katuas tiꞌan, Sara moos koꞌus. Toꞌo niakaan oras, Sara nahoris nola oa mane ida. Hotu, Abraham nanaran oa nia, Isak (tan ‘isak’ lia isin naꞌak ‘hanasa’.) Baa oras Sara nahoris Isak nia, Abraham otas tinan atus ida ona. Sara katak naꞌak, “Maromak nalo haꞌu kanasa. Haꞌu neon diꞌak. Ema naneo naꞌak, haꞌu la kbele ketan oan baa otas ferik nuneꞌe. Haꞌukaan laꞌen moos katuas basuk tiꞌan, mais haꞌu ksei bele kahoris oan bodik nia! Dadi, oras neꞌe, se-see dei mak rona lia neꞌe, sia moos nanasa bele-bele no haꞌu.” Baa oras lawarik nia otas loron walu, Abraham moos nalo hamane aan baa nia, tuir Maromak ukun. ");
INSERT INTO tet_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Hotu, Isak hetak boot. Baa oras Sara atu keta nia, Abraham nalo dahur boot. ");
INSERT INTO tet_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Baa oras nia, Sara naree Abraham feen kiꞌik Hagar oan Ismael kakoen Isak. Naree nunia, Sara katak baa laꞌen naꞌak, “Teꞌur sai ata feto Mesir neꞌe no niakaan oan! Haꞌu la koꞌuk niakaan oan simu itakaan sasoin! Haꞌukaan oan Isak dei, mak netan hotu-hotu.” ");
INSERT INTO tet_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Rona nola nunia, Abraham noran la diꞌak, tan Ismael moos niakaan oan susu. ");
INSERT INTO tet_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mais, Maromak katak baa Abraham naꞌak, “Abraham! Keta maneo feen kiꞌik no oan nia. Tuir Sara hakaran dei, tan o metan husar-binan mak Haꞌu kameno tiꞌan nia, tuir Isak. ");
INSERT INTO tet_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mais Haꞌu moos katuun matak-malirin baa okaan feen kiꞌik oan Ismael. Tan Ismael moos, okaan oan susu duꞌuk. Nosi ikus, niakaan husar-binan dadi ema klubun ida!” ");
INSERT INTO tet_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Rona nola nunia, awan seisawan Abraham nalo bakae, foo baa Hagar, no tara wee fatik boot ida baa niakaan baas. Hotu, nia nabusik feto nia no oan Ismael laꞌo. Hagar no oan Ismael moos laꞌo nasirin rai mamuk ida kreꞌis Beer Syeba. ");
INSERT INTO tet_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Baa oras wee hemun moos tiꞌan, Hagar laꞌo nela Ismael iha ai huun kiꞌik ida leon, ");
INSERT INTO tet_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","tan nia naneo naꞌak, “Haꞌu la kterus karee oan neꞌe mate.” Hotu, Hagar nakiduk takseer roꞌa lima nulu nosi oan nia, hotu tuur, tanis nadeꞌun aan. ");
INSERT INTO tet_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ismael moos tanis. Maromak moos rona niakaan lian. Hotu, Maromak Niakan makbukar laleꞌan ida bolu Hagar naꞌak, “Hagar! Tan saa o susar nuneꞌe? Keta mataꞌuk, tan Maromak rona tiꞌan okaan oan tanis. ");
INSERT INTO tet_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mariik, baa maliku nia! Makbiit niakaan neon, tan Haꞌu atu kalo niakaan husar-binan dadi ema klubun boot.” ");
INSERT INTO tet_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Hotu, Maromak namoo Hagar matan, toꞌo nia bele naree wee knuuk ida. Nia nodi wee fatik baa tii wee, nodi naroo oan nia. ");
INSERT INTO tet_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Nunia hotu, Ismael no inan Hagar nein iha raihenek molik ida, naran Paran. Ismael boot mai, nia dadi ema mahanak matenek. Niakaan inan moos sasudin nia no feto Mesir ida. Hotu-hotu neꞌe dadi, tan Maromak namutuk no Ismael. ");
INSERT INTO tet_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Baa oras nia, Naꞌi Abimelek niakaan meo ulun ida, naran Pikol. Baa loron ida, sia rua mai nasoru Abraham. Naꞌi Abimelek dale baa Abraham naꞌak, “Abraham! Ami hatene Maromak namutuk no o. Etuk, o malo sa-saa dei, dadi. ");
INSERT INTO tet_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Oras neꞌe, haꞌu kusu o mameno modi marai aan iha Maromak oin maꞌak, o la beꞌur haꞌu ko haꞌukaan husar-binan. Haꞌu diꞌak ko o tiꞌan, dadi o moos musti diꞌak mo haꞌu ko haꞌukaan renun rai neꞌe.” ");
INSERT INTO tet_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham moos simu naꞌak, “Diꞌak! Haꞌu karai aan.” ");
INSERT INTO tet_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mais la kleur, Abraham nasaꞌe lia baa Naꞌi Abimelek naꞌak, “Ama naꞌi eman sia nadau nola haꞌukaan wee knuuk ida tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Rona nola nunia, Naꞌi Abimelek naꞌak, “Hei! Haꞌu kfoin rona lia neꞌe. Tan saa o la masara kedan lia nia? Haꞌu la katene see mak nadau.” ");
INSERT INTO tet_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Nunia hotu, Abraham no Naꞌi Abimelek namate menon no malu. Abraham nola karau baka no bibi malae, latan baa naꞌin. Hotu, Abraham boi nasai tuꞌan bibi malae inan salak matan hitu. ");
INSERT INTO tet_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Naree nunia, Naꞌi Abimelek nusu nia naꞌak, “Tan saa o malo nunia?” ");
INSERT INTO tet_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham nataa naꞌak, “Ama naꞌi simu bibi malae matan hitu neꞌe ona, atu dadi tadak naꞌak, ama naꞌi simu haꞌu mak keꞌe wee knuuk nia.” ");
INSERT INTO tet_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tan sia rua narai aan iha nia, sia moos nanaran fatin nia naꞌak, Beer Syeba. Neꞌe naꞌak, ‘wee knuuk harai aan’. ");
INSERT INTO tet_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Hotu tiꞌan, Naꞌi Abimelek no niakaan meo ulun fila nikar baa siakaan rai Filistin. ");
INSERT INTO tet_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Hotu, Abraham taman ai tamariska huun ida iha Beer Syeba. Nahuu baa oras nia, ai huun nia foo natene baa Abraham naꞌak, fatin nia, fatin loꞌu-sudur baa MAROMAK Mak Moris Nima-nimak. ");
INSERT INTO tet_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Hotu Abraham nein heik toꞌo kleur iha ema Filistin rain nia. ");
INSERT INTO tet_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","La kleur falik, Maromak koko Abraham neon atu natene Abraham rona baa Nia ka lale. Maromak bolu naꞌak, “Abraham!” Abraham moos nataa naꞌak, “Heꞌe, Naꞌi Maromak!” ");
INSERT INTO tet_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Hotu Maromak naruka naꞌak, “Rona diꞌa-diꞌak! Mola okaan oan mane mesak mak o madomi tebe-tebes nia, modi baa rai Moria, malo nia baa sera tunun bodik Haꞌu. Toꞌo nebaa, foin Haꞌu katudu sera fatik iha foho ida.” ");
INSERT INTO tet_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Awan seisawan, Abraham nola ai maran, tula baa kuda keledai. Hotu, nia no Isak no klosan naꞌin rua baa fatin mak Maromak katak tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sia laꞌo bei-beik toꞌo wainrua, Abraham titu naree foho nia nosi dook. ");
INSERT INTO tet_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Hotu, nia katak baa klosan rua nia naꞌak, “Emi naꞌin rua hein heik iha neꞌe, hodi daka kuda keledai. Haꞌu ko haꞌukaan oan baa loꞌu-sudur baa Maromak iha leten nebaa. Loꞌu-sudur tiꞌan, ami fila hikar mai.” ");
INSERT INTO tet_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Dale hotu nunia, Abraham nola ai maran nia sia, nasaan baa Isak. Nia naꞌin duꞌuk nodi tudik no haꞌi. Sia rua sei laꞌo, ");
INSERT INTO tet_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak bolu aman naꞌak, “Ama!” Abraham nataa naꞌak, “Saa Isak!” Isak moos nusu naꞌak, “Ama! Ita atu tunu sera! Haꞌi no ai maran iha neꞌe tiꞌan! Mais bibi malae oan mak ita atu halo baa sera nia, iha nabee?” ");
INSERT INTO tet_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham nataa naꞌak, “Oa! Maromak duꞌuk mak atu foo Niakaan bibi malae oan, nebee halo baa sera.” Sia rua moos saꞌe liu, ");
INSERT INTO tet_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","toꞌo fatin mak Maromak katak tiꞌan nia. Hotu Abraham nalo taroman, nodi nada ai maran baa fohon. Hotu, nia kesi niakaan oan, natoba baa ai maran leten. ");
INSERT INTO tet_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Hotu, nia nola tudik atu nodi sona noꞌo ");
INSERT INTO tet_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mais teki-tekis MAROMAK Niakaan makbukar nahii nosi laleꞌan naꞌak, “Abraham, Abraham!” Abraham nataa naꞌak, “Haꞌu iha neꞌe, Naꞌi Maromak. Nansaa?” ");
INSERT INTO tet_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Hotu lia maliak nia moos nataa naꞌak, “Keta moꞌo oan nia! Keta malo sa-saa baa nia! Oras neꞌe, Haꞌu katene tiꞌan kaꞌak, o tuir tebe-tebes Haꞌukaan hakaran modi madiꞌa aan tiꞌan, latan okaan oan mane mesak nia, dadi baa sera bodik Maromak.” ");
INSERT INTO tet_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Rona nola nunia, Abraham naree bibi malae aman ida mak dikur tatalik baa ai tarak sorun. Abraham baa nola bibi malae nia, hotu tunu nalo baa sera bodik Maromak, seluk niakaan oan. ");
INSERT INTO tet_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Tan lia nia, Abraham nanaran fatin nia Yahofa Yire, tan lia isin naꞌak ‘Maromak atu nadiꞌa saa mak ita buka’. Etuk, toꞌo oras neꞌe moos, ema naꞌak, “Iha MAROMAK foho leten, Nia atu nadiꞌa saa mak ita buka.” ");
INSERT INTO tet_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Hotu, MAROMAK Niakaan makbukar nahii tenik nosi laleꞌan naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“MAROMAK duꞌuk naꞌak, ‘O madiꞌa aan tiꞌan atu foo okaan oan mesak nia, dadi sera bodik Haꞌu. Dadi, Haꞌu karai aan kodi Haꞌukaan naran duꞌuk ");
INSERT INTO tet_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","kaꞌak, Haꞌu kameno katuun matak-malirin waꞌin lear baa o mo okaan husar-binan. Sia atu bea tuꞌan hanesan fitun iha laleꞌan, no raihenek iha tasi tehen mak ema la bele sura nola. Okaan husar-binan sia atu natoba nola funu. ");
INSERT INTO tet_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nosi okaan husar-binan, ema klubun hotu-hotu iha raiklaran netan matak-malirin, tan o tuir Haꞌukaan ukun.’ ” ");
INSERT INTO tet_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hotu, Abraham no Isak tuun mai nikar baa klosan naꞌin rua nia, atu fila nikar bele-bele baa Beer Syeba. Sia moos nein ona iha nebaa. ");
INSERT INTO tet_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nunia hotu, Abraham rona naꞌak, alin Nahor feen Milka, nahoris oan tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Oan ulun naran Us. Alin naran Bus. Bus alin naran Kemuel (mak Aram aman). ");
INSERT INTO tet_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Hotu, Kesed, Haso, Pildasy, Yidlaf no Betuel. ");
INSERT INTO tet_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel nia, Ribka aman. ");
INSERT INTO tet_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor moos netan oan nosi feen kiꞌik, naran Reuma. Reuma nahoris Teba, Gaham, Tahas no Maaka. ");
INSERT INTO tet_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Nosi ikus, Sara mate baa otas tinan atus ida rua nulu resin hitu. Oras mate, Abraham sia nein iha rai Kanaꞌan, iha leo Kiryat-Arba (neꞌe mak Hebron). Abraham tanis nadeꞌun aan, daka feen maten. ");
INSERT INTO tet_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Nia baa nasoru ema Het sia, hotu katak naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Haꞌu neꞌe, ema maktabar dei iha emikaan leet. Haꞌu la koo rai atu kakoi haꞌukaan feen. Dadi, kalo bele, haꞌu ksosa kola emikaan rai rohan ida, bodik kakoi haꞌukaan feen.” ");
INSERT INTO tet_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Sia nataa naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Nuneꞌe, ama! Hori wain neꞌe, ami filak ama, hanesan ema matas mak ami hakneter. Dadi, ama boi duꞌuk dei rai kabaas mak ama nakara. Ami nanis simu dei. La noo ida dudu.” ");
INSERT INTO tet_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Rona nola nunia, Abraham sudur kedan, foo kneter baa rai naꞌin, mak ema Het sia. ");
INSERT INTO tet_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Hotu, nia dale naꞌak, “Kalo emi simu haꞌu, haꞌu kusu tulun nebee emi dale ho katuas Sohar oan mane Efron. ");
INSERT INTO tet_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Emi husu, kalo bele, nia faꞌan fatuk kuak naran Makpela iha niakaan toꞌos diꞌin. Nusu folin hira-hira, nanis haꞌu kselu. Haꞌu kakara selu kotu iha emikaan oin, nebee rai nia dadi baa haꞌukaan rai duꞌuk. Haꞌu atu kalo baa amikaan rate fatik.” ");
INSERT INTO tet_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Baa oras nia, Efron duꞌuk tuur namutuk no ema Het sia. Nia moos rona Abraham dalen nia. Hotu, nia nariik nataa Abraham iha fukun hotu-hotu oin naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Keta nunia, ama! Nuneꞌe. Haꞌu klatan toꞌos no fatuk kuak Makpela nia bodik ama! Ama nakoi ama feen iha nia. Haꞌu klatan rai nia baa ama iha haꞌukaan ema oin, nebee sia hotu-hotu dadi saksiin!” ");
INSERT INTO tet_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Rona nola nunia, Abraham sudur tenik baa ema Het sia. ");
INSERT INTO tet_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Hotu, nia moos dale no Efron naꞌak, “Nunia moos diꞌak, mais emi hotu-hotu rona haꞌu lai. Haꞌu kakara sosa kotu rai nia, nebee haꞌu kbele kakoi haꞌukaan ema sia iha nia.” ");
INSERT INTO tet_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Rona nola nunia, Efron moos nataa naꞌak, “Rai nia folin, osan murak tomak atus haat dei! Halo saa, ita rua hatuun folin baa-mai tan osan oan nia? Ama baa makoi o feen iha nebaa ona.” ");
INSERT INTO tet_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham moos simu rai folin nia tuir Efron dalen. Hotu, nia sura nola osan murak tomak atus haat iha ema Het sia oin, nodi selu baa Efron. ");
INSERT INTO tet_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","Hodi nunia, Abraham netan Efron rain, nalo baa niakaan rain duꞌuk. Rai nia, iha Makpela, kreꞌis Mamre. Nia sosa kotu rai nia no toꞌos, fatuk kuak, no ai huun hotu-hotu. Fukun Het hotu-hotu dadi saksiin naꞌak, rai nia no isin hotu-hotu, dadi tiꞌan baa Abraham niakaan. Hotu, Abraham nakoi Sara iha fatuk kuak Makpela laran, kreꞌis Mamre (neꞌe mak Hebron), iha rai Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hodi nunia, toꞌos no fatuk kuak mak uluk ema Het rain, dadi baa Abraham rain duꞌuk, atu nalo baa siakaan rate fatik. ");
INSERT INTO tet_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham otas naruk toꞌo katuas basuk. MAROMAK daka nia diꞌa-diꞌak, toꞌo nia moris manek no dame. ");
INSERT INTO tet_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Noo Abraham klosan ida, mak nia fiar. Ema nia naliku Abraham sasoin sia. Dala ida, Abraham bolu nola klosan nia, hotu naꞌak, “Rona diꞌa-diꞌak! Haꞌu kusu o marai aan modi Maromak naran, tan Nia mak naseꞌi laleꞌan no raiklaran! O mameno maꞌak, o la mola feto nosi ema Kanaꞌan neꞌe, atu malo baa haꞌukaan oan Isak feen. ");
INSERT INTO tet_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mais, o musti baa haꞌukaan familin sia iha haꞌukaan uma huun. Buka mola feto ida iha nia bodik haꞌukaan oan.” ");
INSERT INTO tet_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Rona nola nunia, klosan nia nusu Abraham naꞌak, “Diꞌak, ama! Mais, kalo feto nia la noꞌuk tuir mai, haꞌu kmusti ko ama oan baa nola malu iha nebaa ka, nunabee?” ");
INSERT INTO tet_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham nataa naꞌak, “Manoin diꞌa-diꞌak! Masik nunabee moos, o la bele modi haꞌukaan oan baa! ");
INSERT INTO tet_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Manoin! MAROMAK makaer beran iha laleꞌan. Nia mak nodi haꞌu sai tiꞌan kosi haꞌukaan uma huun, nalaꞌo haꞌu toꞌo rai neꞌe. Nia moos namate menon no haꞌu naꞌak, ‘Haꞌu klatan to-tomak rai neꞌe bodik okaan husar-binan.’ Dadi, lalika mataꞌuk! Baa ona! Tan Maromak nanis naruka Niakaan makbukar laleꞌan mai loke dalan bodik o, nebee o bele masoru feto mak atu dadi baa haꞌukaan oa feen. ");
INSERT INTO tet_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mais, kalo feto nia la noꞌuk mai, o makbois mosi harai aan neꞌe. Surak o la modi haꞌukaan oan baa.” ");
INSERT INTO tet_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Hotu, Abraham klosan nia narai aan tuir mohu Abraham hakaran. ");
INSERT INTO tet_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hotu, klosan nia boi nola kuda unta matan sanulu. Nia tula naha kabaas oi-oik baa. Hotu, nia baa Nahor niakaan kota iha Mesopotamia. ");
INSERT INTO tet_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Toꞌo kota nia, nia kesi kuda unta sia nanawa kole iha kota diꞌin, kreꞌis baa wee knuuk ida. Oras nia, loro malirin tiꞌan. Baa oras nia, oa feto sia mai nakonu wee iha wee knuuk nia. ");
INSERT INTO tet_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Naree nunia, klosan nia moos namulak naꞌak, “MAROMAK, mak haꞌukaan ama boot Abraham niakaan Maromak! Tulun loke dalan, nebee haꞌu ketan sotir diꞌak. Manoin Ama mamenon bodik haꞌukaan ama boot. Nebee haꞌu kbele ketan Isak sasudin. ");
INSERT INTO tet_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Naꞌi Maromak! Haꞌu kariik iha wee knuuk diꞌin neꞌe! Feto nosi kota neꞌe, mai nakonu wee iha neꞌe. ");
INSERT INTO tet_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Dadi, haꞌu kakroꞌan nuneꞌe: kalo haꞌu kdale ko feto ida kaꞌak, ‘Bete! Tulun matuun okaan lolo, foo haꞌu kemu lai.’ Kalo feto nia nataa naꞌak, ‘Ama memu ona! Haꞌu moos karoo okaan kuda unta sia,’ lia nia dadi tadak naꞌak, feto nia mak Naꞌi Maromak boi dadi baa Isak feen! Tuir tadak nunia, haꞌu kbele katene kaꞌak, Naꞌi Maromak natudu dadiꞌak bodik haꞌukaan ulun Abraham.” ");
INSERT INTO tet_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Oras Abraham klosan nia sei namulak, feto ida moos mai. Feto nia naran Ribka. Nia, Abraham alin Nahor no feen Milka, siakaan bein oan. Ribka aman naran Betuel. Ribka nia, sei feto lawarik mak kabaas tebe-tebes. Nia tuun baa wee knuuk nia, kuru nakonu lolo, hotu saꞌe nikar. ");
INSERT INTO tet_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Oras Ribka saꞌe toꞌo leten, Abraham klosan moos nalai baa, hotu nusu naꞌak, “Bete. Tulun foo haꞌu kemu lai!” ");
INSERT INTO tet_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rona nola nunia, Ribka nataa naꞌak, “Memu baa, ama!” Nia moos natuun lai-lais lolo, foo wee baa klosan nia. ");
INSERT INTO tet_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nemu notu tiꞌan, Ribka dale naꞌak, “Mabusik haꞌu mak kuru wee bodik kuda unta sia, nebee sia nemu toꞌo bosu.” ");
INSERT INTO tet_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hotu, Ribka fui wee resin baa kuda unta hemun fatik. Hotu, nia kuru wee saꞌe-tuun nodi naroo kuda unta nia sia hotu-hotu toꞌo bosu. ");
INSERT INTO tet_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abraham klosan nariik no-nook mana feto nia serwisu. Nia nanoin baa-mai naꞌak, “Feto neꞌe mak Naꞌi Maromak boi ka?” ");
INSERT INTO tet_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kuda unta sia nemu toꞌo bosu tiꞌan, klosan nia nola fafutar mean nosi naha mak nia nodi. Nia foo karabu inun mean no riti mean rua, tau baa feto nia liman karuk-kwana. ");
INSERT INTO tet_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Hotu, nia nusu naꞌak, “Bete aman, naran see? Haꞌu kbele toba heik iha bete aman uman ka?” ");
INSERT INTO tet_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Feto nia moos nataa naꞌak, “Haꞌukaan ama, naran Betuel. Haꞌukaan bei mane, naran Nahor. Bei feto, naran Milka. ");
INSERT INTO tet_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Iha amikaan uman, noo toba fatik bodik ama sia. Hae moos waꞌin bodik kuda unta sia.” ");
INSERT INTO tet_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Rona nola nunia, klosan nia loꞌu-sudur baa MAROMAK ");
INSERT INTO tet_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","nodi nakroꞌan naꞌak, “Tonu-kaboot Naꞌi Maromak! Nia loke dalan baa haꞌu, toꞌo haꞌu kbele kasoru haꞌukaan ulun Abraham familin sia. Hodi nunia, Maromak nalaꞌok tiꞌan Niakaan mamenon bodik haꞌukaan ulun Abraham.” ");
INSERT INTO tet_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Hotu, feto nia nalai fila lai-lais. Toꞌo uma, nia dale baa ema uma isin, saa mak dadi ohin nia. ");
INSERT INTO tet_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka naan, naran Laban. Oras Laban naree naha mean sia, no rona Ribka dalen, nia nalai sai lai-lais baa nasoru klosan mak sei nariik no kuda unta sia iha wee knuuk nia. ");
INSERT INTO tet_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Hotu, Laban dale baa klosan nia naꞌak, “Ama! MAROMAK nalaꞌo ama diꞌa-diꞌak toꞌo neꞌe tiꞌan! Keta mariik iha luan dei! Mai tama ona. Ami hadiꞌa keꞌan tiꞌan. Hahaak bodik kuda unta sia moos, waꞌin basuk.” ");
INSERT INTO tet_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Rona nola nunia, klosan nia tuir Laban tama baa Betuel uman. Laban sia moos natuun tuꞌan naha nosi kuda unta sia. Hotu, sia tau hae. Sia moos nodi wee fasi ain foo baa klosan no niakaan ema sia. ");
INSERT INTO tet_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Oras sia nadiꞌa haan tiꞌan, klosan nia katak naꞌak, “Ita atu haa ona, mais haꞌu kusu leet ida atu katak sain lia ida neꞌe lai.” Laban nataa naꞌak, “Ama katak baa dei.” ");
INSERT INTO tet_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Klosan nia moos dale naꞌak, “Haꞌu neꞌe, emikaan bei Abraham klosan. ");
INSERT INTO tet_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","MAROMAK natuun tiꞌan matak-malirin waꞌin baa haꞌukaan ulun nia, toꞌo soi liu resik. Maromak natuun baa nia mean-mutin, ata feto, ata mane, no bibi no karau waꞌin basuk, nuꞌu karau baka, kuda unta, kuda keledai, bibi no bibi malae. ");
INSERT INTO tet_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Baa oras haꞌukaan ulun sia feen-laꞌen otas tiꞌan, ina Sara nahoris oa mane ida, foo baa haꞌukaan ulun Abraham. Oan nia mak atu simu aman sasoin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Foin da-dauk neꞌe, haꞌukaan ulun Abraham naruka haꞌu karai aan kaꞌak, ‘Haꞌu la kola feto Kanaꞌan bodik niakaan oan Isak. ");
INSERT INTO tet_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mais, haꞌu kmusti kola feto nosi niakaan familin duꞌuk, dadi baa niakaan oan feen.’ ");
INSERT INTO tet_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mais, haꞌu kusu baa haꞌukaan ulun kaꞌak, ‘Kalo feto nia la noꞌuk tuir haꞌu, nunabee?’ ");
INSERT INTO tet_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Hotu, nia nataa naꞌak, ‘Haꞌu ktuir MAROMAK hakaran nohuun. Tan baa nia, nanis Nia naruka makbukar laleꞌan mai buka dalan bodik o, nebee o bele metan feto ida nosi haꞌukaan familin duꞌuk, atu dadi baa haꞌukaan oan feen. ");
INSERT INTO tet_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mais, kalo haꞌukaan familin sia dudu, lale, sia la noꞌuk nabusik feto nia mai neꞌe, o makbois mosi harai aan nia.’ ");
INSERT INTO tet_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Dadi, ohin haꞌu toꞌo wee knuuk nia, haꞌu kamulak iha neon laran kaꞌak, ‘MAROMAK, mak haꞌukaan ulun Abraham niakaan Maromak. Tulun loke dalan, nebee haꞌukaan dalan neꞌe netan sotir diꞌak. Nebee kasoru Isak sasudin. ");
INSERT INTO tet_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Naꞌi Maromak, haꞌu kariik iha wee knuuk diꞌin neꞌe. Feto sia nosi kota neꞌe mai nakonu wee iha neꞌe. Dadi, haꞌu kusu nuneꞌe: kalo haꞌu kdale ko feto ida kaꞌak, “Bete! Tulun matuun lolo, foo haꞌu kemu lai,” ");
INSERT INTO tet_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","hotu feto nia nataa naꞌak, “Ama memu baa! Haꞌu moos atu karoo ama niakaan kuda unta sia,” lia nia dadi tadak naꞌak feto nia mak Naꞌi Maromak boi tiꞌan, dadi haꞌukaan ulun oan Isak feen!’ ");
INSERT INTO tet_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Haꞌu ksei kamulak nunia, bete Ribka mai nodi lolo atu nakonu wee iha wee knuuk nia. Oras nia foin saꞌe baa leten, haꞌu kusu kedan kaꞌak, ‘Bete! Foo haꞌu kemu lai.’ ");
INSERT INTO tet_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Hotu, nia moos natuun lai-lais lolo, nodi naꞌak, ‘Ama memu baa! Haꞌu moos atu karoo ama niakaan kuda unta sia.’ Rona nunia, haꞌu moos kemu. Haꞌukaan kuda unta sia moos nemu. ");
INSERT INTO tet_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Hotu, haꞌu kusu kaꞌak, ‘Bete aman, naran see?’ Nia moos nataa naꞌak, ‘Haꞌukaan ama, naran Betuel. Haꞌukaan bei mane, naran Nahor. Bei feto, naran Milka.’ Rona Ribka dalen nia, haꞌu moos tau karabu baa inun, no riti mean rua baa liman karuk-kwana. ");
INSERT INTO tet_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hotu, haꞌu kloꞌu-sudur baa Maromak kaꞌak, ‘Tonu-kaboot Naꞌi Maromak! Tan Naꞌi Maromak loke dalan baa haꞌu tiꞌan, toꞌo haꞌu kbele kasoru haꞌukaan ulun Abraham familin sia iha neꞌe. Haꞌu moos bele kasoru haꞌukaan ulun oan Isak sasudin.’ ");
INSERT INTO tet_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Dadi, oras neꞌe, kalo ama sia nadomi haꞌukaan ulun Abraham, katak malorek baa haꞌu. Kalo lale moos, katak malorek. Nebee haꞌu kbele katene, haꞌu kmusti kalo saa.” ");
INSERT INTO tet_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Rona nola nunia, Laban no Betuel dale naꞌak, “Kalo MAROMAK babilan nunia tiꞌan, ita atu dale saa tenik? ");
INSERT INTO tet_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Bete Ribka iha neꞌe. Mola nia modi baa. Nebee dadi bei Abraham oa feen, tuir MAROMAK babilan.” ");
INSERT INTO tet_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Rona tiꞌan lia nunia, Abraham klosan nia sudur toꞌo rai, sera dodan baa MAROMAK. ");
INSERT INTO tet_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Hotu, nia foti sai naha mean mutin no tais kabaas sia, foo baa Ribka. Nia moos foo sasolok folin todan sia baa Ribka inan no Ribka naan. ");
INSERT INTO tet_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hotu, sia hotu-hotu tuur naa dahur. Abraham klosan no niakaan ema sia moos toba iha nia. Awan seisawan, sia nadeer. Hotu, klosan nia katak baa ema uma naꞌin sia naꞌak, “Kalo bele, oras neꞌe ami fila baa amikaan ulun ona.” ");
INSERT INTO tet_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mais Ribka inan no Ribka naan katak naꞌak, “Hakara fila lai-lais baa saa? Habusik Ribka nein no ami loron sanulu sia lai! Foin hodi nia baa.” ");
INSERT INTO tet_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mais klosan nia nataa naꞌak, “Adeei! Keta saseni haꞌu! MAROMAK tulun haꞌu tiꞌan, toꞌo kasoru tiꞌan haꞌukaan ulun oan feen. Dadi, ina sia habusik ami ona, nebee ami fila baa hasara lia baa haꞌukaan ulun lai.” ");
INSERT INTO tet_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Sia nataa naꞌak, “Nuneꞌe! Ita husu kokon baa Ribka duꞌuk. Nia nakara, nunabee?” ");
INSERT INTO tet_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Hotu, sia bolu Ribka nodi nusu naꞌak, “Ribka! Oras neꞌe, loos o dei. O makara tuir kedan mo ema neꞌe ka, nunabee?” Hotu, Ribka nataa naꞌak, “Kakara.” ");
INSERT INTO tet_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Hotu, sia nabusik Ribka tuir Abraham klosan sia. Ata feto mak naliku Ribka hori sei kiꞌik no ata feto seluk sia moos atu tuir Ribka. Ribka familin sia naloon foo matak-malirin baa nia naꞌak, “Ribka! Ami haloon, nebee Naꞌi Maromak nalo o mahoris oan waꞌin lear, toꞌo okaan husar-binan dadi maliun-maliun. Ami moos haloon, nebee okaan husar-binan sia natoba nola funu!” ");
INSERT INTO tet_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hotu, Ribka no ata feto sia nahulin naha. Nahulin hotu, sia saꞌe kuda unta tuir kedan Abraham klosan sia. ");
INSERT INTO tet_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Oras nia, Isak nein iha rai Negeb. Nia foin fila nosi wee knuuk iha Beer Lahai Roi. ");
INSERT INTO tet_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Loraik ida, nia sai nosi batane, laꞌo nola anin. Nia foti oin, titu naree kuda unta sia laꞌo lolok mai. ");
INSERT INTO tet_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Baa oras Ribka naree nola Isak, nia tuun lai-lais nosi kuda unta. ");
INSERT INTO tet_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Nia nusu baa Abraham klosan nia naꞌak, “Ama! Ema mak laꞌo nebaa nia, see ida?” Klosan nia nataa naꞌak, “Nia, mak haꞌukaan ulun oan.” Rona nola nunia, Ribka foti nola tais oan, taka sara oin. ");
INSERT INTO tet_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Toꞌo tiꞌan, klosan nia nasara lia hotu-hotu baa Isak. ");
INSERT INTO tet_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Hotu, Isak no Ribka nola malu. Isak natama Ribka baa inan Sara batanen. Isak nadomi Ribka tebe-tebes, toꞌo Isak la duun susar ona baa inan mamaten. ");
INSERT INTO tet_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nosi ikus, Abraham nola tenik feto ida, naran Ketura. ");
INSERT INTO tet_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura nahoris oa hira foo baa Abraham. Oa nia sia naran: Simran, Yoksan, Medan, Midian, Isbak no Sua. ");
INSERT INTO tet_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan oan sia mak: Seba no Dedan. Dedan husar-binan sia mak: ema Asyur, ema Letus no ema Leum. ");
INSERT INTO tet_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian oan sia mak: Efa, Efer, Henok, Abida no Eldaa. Sia hotu-hotu nia, Ketura husar-binan. ");
INSERT INTO tet_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Oras Abraham sei moris, nia faꞌe foo kedan fafaꞌek baa Hagar no Ketura oan sia ida-idak. Hotu, nia naruka sia nein iha rai Kanaꞌan lorosaꞌe, dook nosi oan Isak. Mais, nia latan niakaan sasoin hotu-hotu baa Isak. ");
INSERT INTO tet_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Nosi ikus, Abraham mate baa otas tinan atus ida hitu nulu resin lima. ");
INSERT INTO tet_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Niakaan oan Isak no Ismael nakoi nia iha fatuk kuak Makpela, kreꞌis baa Mamre. Uluk Abraham sosa nola toꞌos ida nosi ema Het ida, naran Efron, mak Sohar oan, nalo baa siakaan rate fatik. Uluk sia nakoi Sara baa fatuk kuak iha nia. ");
INSERT INTO tet_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham mate tiꞌan, Maromak moos natuun matak-malirin baa Isak, toꞌo nia moris manek no dame. Baa oras nia, Isak nein kreꞌis wee knuuk ida, naran Beer Lahai Roi. ");
INSERT INTO tet_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Neꞌe, lia Ismael. Nia neꞌe, Abraham feen kiꞌik Hagar oan. Hagar nia, Sara ata feto nosi Mesir. ");
INSERT INTO tet_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael oan mane naꞌin sanulu resin rua. Siakaan naran tuir malu nosi ulun toꞌo ikun, mak neꞌe: Nebayot, Kedar, Adbeel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis no Kedma. Oan nia sia dadi bei uluk nosi ema klubun sanulu resin rua, ida-idak no rain duꞌuk. Sia nanaran rai nia sia, ida-idak tuir siakaan bei uluk naran. ");
INSERT INTO tet_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael mate baa otas tinan atus ida tolu nulu resin hitu. ");
INSERT INTO tet_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Mais, niakaan husar-binan sia funu malu. Sia nein fatin keen kari malu, nahuu nosi rai Hawila toꞌo rai Syur mak kladik no rai Mesir, liu toꞌo Asyur. ");
INSERT INTO tet_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Neꞌe, lia Isak. Nia neꞌe Abraham feen boot Sara oan. ");
INSERT INTO tet_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Baa oras Isak nola Ribka baa feen, nia otas tinan haat nulu. Ribka aman, naran Betuel. Naan, naran Laban. Sia nia, ema Aram nosi Padan Aram. ");
INSERT INTO tet_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak no Ribka nola malu kleur tiꞌan, mais la netan oan. Tan baa nia, Isak namulak baa MAROMAK. Nia nusu nebee loke Ribka notak. MAROMAK moos rona niakaan namulak, hotu Ribka koꞌus. ");
INSERT INTO tet_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Natene nodi baa, nia koꞌus oa karuak. Mais oan rua nia te-tei malu nohuun iha inan notak. Toꞌo Ribka naneo naꞌak, “Tan saa oan rua neꞌe te-tei malu nuneꞌe?” Hotu, nia nusu lia nia baa MAROMAK. ");
INSERT INTO tet_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","MAROMAK moos nataa naꞌak, “Iha okaan notak nia, noo ema klubun rua. Sia atu funu malu nohuun! Oan ikun biit liu oan ulun. Maun atu serwisu bodik alin.” ");
INSERT INTO tet_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Toꞌo niakaan oras, Ribka nahoris oa mane karuak. ");
INSERT INTO tet_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Oa kawaꞌik ilas mean, isin marahuk. Etuk oin, sia nanaran nia, Esau (tan lia fuan esau isin naꞌak ‘marahuk’). ");
INSERT INTO tet_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Oras alin sai, nia kaer maun ain nuban. Etuk oin, sia nanaran nia, Yakob (tan lia fuan yakob isin naꞌak ‘ain nuban’). Baa oras oan rua nia moris, aman Isak otas tinan neen nulu tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Baa oras oa rua nia boot tiꞌan, Esau dadi maktama alas. Nia beer nein iha alas laran. Mais Yakub dadi ema mak la duun dale. Nia beer nein iha uma dei. ");
INSERT INTO tet_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak beer basuk naa naꞌan fuik. Tan lia nia, nia nadomi liu Esau. Mais Ribka nadomi liu Yakob. ");
INSERT INTO tet_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Dala ida, Yakob daꞌan fore mean. Oras nia moos, Esau fila mai nosi alas. Nia kole no salaen tebe-tebes. ");
INSERT INTO tet_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Naree alin Yakob noꞌi daꞌan fore, nia moos nusu naꞌak, “Ali! Foo okaan fore mean daꞌan oan ida lai, nebee atu kaa, tan haꞌu ksalaen mate ona.” (Tan baa nia, ema moos bolu Esau naꞌak, Edom, tan edom neꞌe, lian hanesan lia fuan Ibrani ida naꞌak ‘mean laak’.) ");
INSERT INTO tet_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakob nataa naꞌak, “Diꞌak mau. Mais latan okaan beran oa ulun baa haꞌu lai, foin haꞌu kfoo!” ");
INSERT INTO tet_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau nataa naꞌak, “Basa klerek beran oa ulun nia! Mola baa o dei. Surak modi fore daꞌan nia mai, tan haꞌu ksalaen mate ona.” ");
INSERT INTO tet_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Mais Yakob nataa tenik naꞌak, “Mein lai, mau! Marai aan uluk lai maꞌak, mau latan beran nia baa haꞌu, foin haꞌu kfoo.” Hotu, Esau moos narai aan tuir Yakob hakaran. ");
INSERT INTO tet_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Hotu, Yakob foo fore daꞌan no tubi baa nia. Naa-nemu notu, Esau moos nariik laꞌo. Hodi nunia, Esau soe lerek niakaan beran oa ulun. ");
INSERT INTO tet_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Baa tinan ida, rai salaen boot iha rai nia, manesak no rai salaen baa oras Abraham sei moris. Tan baa nia, Isak baa nusu baa ema Filistin siakaan naꞌin, naran Abimelek, nebee nia bele nein iha Gerar. ");
INSERT INTO tet_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nia nalo nunia, tan MAROMAK natadu aan baa nia naꞌak, “Keta baa Mesir. Haꞌu atu katudu fatin seluk baa o. ");
INSERT INTO tet_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Kalo o dadi ema maktabar iha fatin nia, Haꞌu atu kamutuk ko o, kodi katuun matak-malirin oi-oik baa o. Haꞌu moos kalo okaan husar-binan sia bea tuꞌan, hanesan fitun iha laleꞌan. Haꞌu moos latan baa o mo okaan husar-binan sia, rai nia tomak. Nosi okaan husar-binan, ema klubun hotu-hotu iha raiklaran netan matak-malirin. Hodi nunia, Haꞌu kalaꞌo Haꞌukaan mamenon baa okaan aman Abraham. ");
INSERT INTO tet_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Haꞌu kalo lia neꞌe sia hotu-hotu, tan okaan aman tuir tiꞌan Haꞌukaan hakaran, Haꞌukaan harukan, no Haꞌukaan ukun.” ");
INSERT INTO tet_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tan Maromak lian nia, Isak nein kreꞌis kota ida iha rai Gerar, dadi ema maktabar. ");
INSERT INTO tet_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Isak feen Ribka, kabaas basuk. Baa oras ema iha nia sia naree nola nia, sia nusu natiꞌi lia nosi nia. Mais Isak nataa naꞌak, “Ribka nia, haꞌukaan feton.” Nia naneo naꞌak, kalo nia katak naꞌak, Ribka nia, niakaan feen, ema nia sia nanis noꞌo nia, nebee nola Ribka. ");
INSERT INTO tet_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak nein kleu-leur iha rai nia, dala ida naꞌin nateke nosi kuak anin, naree Isak no Ribka nakoꞌak malu. ");
INSERT INTO tet_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Naree nunia, naꞌin naruka bolu Isak nodi deꞌan naꞌak, “Isak! Oras neꞌe, foin haꞌu katene malorek kaꞌak, feto nia, okaan feen! Tan saa o katak maꞌak okaan feton?” Isak nataa naꞌak, “Nuneꞌe ama! Haꞌu kataꞌuk, kalo haꞌu kaꞌak nia haꞌukaan feen, nanis ema noꞌo haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Naꞌin nataa naꞌak, “Kalo ema iha neꞌe toba no okaan feen, nanis ami hatiu hola sala nia! Tan saa o malo nunia mo ami?” ");
INSERT INTO tet_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hotu, Naꞌi Abimelek foo natene makaꞌas baa renun sia naꞌak, “Emi hotu-hotu hanoin diꞌa-diꞌak! See mak naksakar aan kakoen ema neꞌe, lale, kakoen niakaan feen, nanis haꞌu ktaa ukun mate baa nia.” ");
INSERT INTO tet_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Baa oras nia, Isak furi fini iha rai nia. Nia netan nikar toꞌos isin dala atus ida, tan MAROMAK natuun matak-malirin baa nia. ");
INSERT INTO tet_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Niakaan sasoin tuꞌan bei-beik, toꞌo soi basuk. ");
INSERT INTO tet_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Niakaan karau baka, bibi no bibi malae, bea tuꞌan. Niakaan ata feto no ata mane moos waꞌin. Toꞌo ema Filistin sia hirus nia. ");
INSERT INTO tet_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Uluk, Isak aman Abraham eman sia keꞌe nela wee knuuk waꞌin tiꞌan. Mais, oras neꞌe ema Filistin sia baa tunin wee knuuk nia sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Hotu, Naꞌi Abimelek katak baa Isak naꞌak, “Diꞌak liu, o laꞌo mela rai neꞌe ona. Tan okaan beran liu ami tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Hotu, Isak nakiduk nosi fatin nia, baa nein iha fatin seluk iha rai fehan Gerar. ");
INSERT INTO tet_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Nia moos suu nikar wee knuuk nia sia mak ema tunin tiꞌan nia. Hotu, nia nanaran wee knuuk nia sia, tuir aman nanaran nela. ");
INSERT INTO tet_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Oras Isak eman sia keꞌe wee knuuk iha rai fehan Gerar nia, sia keꞌe kona wee matan mak nakduar sai waꞌin. ");
INSERT INTO tet_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mais makbalin Gerar sia toe malu tenik no Isak makbalin sia, tan wee nia. Sia katak naꞌak, “Wee neꞌe, amikaan!” Tan lia nia, Isak nanaran wee knuuk nia, Esek, tan lia isin naꞌak ‘toe malu’. ");
INSERT INTO tet_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hotu, Isak eman sia keꞌe tenik wee knuuk ida. Mais sia toe malu tenik baa wee knuuk nia. Tan lia nia, Isak nanaran wee knuuk nia, Sitna. Lia isin naꞌak ‘hakaat ho malu’. ");
INSERT INTO tet_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hotu, Isak laꞌo nela fatin nia, baa keꞌe wee knuuk ida seluk. Oras neꞌe, sia la toe malu ona. Tan lia nia, Isak nanaran wee knuuk nia, Rehobot. Lia isin naꞌak, ‘fatin luan’. Isak katak naꞌak, “Oras neꞌe, MAROMAK foo leet baa ita bele hein iha rai luan! Iha neꞌe foin ita bele bea tuꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Nosi nia, Isak sia laꞌo tenik, baa nein iha Beer Syeba. ");
INSERT INTO tet_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Toꞌo nebaa, kalan nia kedan MAROMAK natadu aan baa nia naꞌak, “Isak! Haꞌu neꞌe, okaan ama Abraham niakaan Maromak! Keta mataꞌuk, tan Haꞌu kdaka o! Haꞌu atu katuun matak-malirin baa o. Okaan husar-binan nanis bea tuꞌan. Haꞌu kalo nuneꞌe tan Haꞌu kameno tiꞌan baa okaan ama.” ");
INSERT INTO tet_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hotu, Isak nada fatuk, nalo taroman iha nia. Nia namulak sera dodan baa MAROMAK. Hotu, nia nein iha fatin nia. Niakaan ema sia moos nahuu keꞌe tenik wee knuuk. ");
INSERT INTO tet_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Oras nia, Naꞌi Abimelek mai nosi Gerar bele-bele no niakaan maluk Ahusat, no niakaan meo ulun Pikol, atu nasoru Isak. ");
INSERT INTO tet_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Naree sia mai, Isak nusu naꞌak, “Ama naꞌi! Uluk emi teꞌur sai ami tiꞌan. Oras neꞌe, emi mai halo saa?” ");
INSERT INTO tet_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Sia nataa naꞌak, “Nuneꞌe! Oras neꞌe, ami hatene MAROMAK mak daka o. Dadi ami hanoin, diꞌak liu ita hamate menon. Mamenon nia nuneꞌe: o marai aan maꞌak, ");
INSERT INTO tet_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","emi la halo aat ho ami, ami moos harai aan haꞌak, ami la halo aat ho emi. Ami laran diꞌak ho emi. Tan hori hirak nia, emi sai diꞌa-diꞌak hosi amikaan rain. Ami hatene tebes MAROMAK natuun matak-malirin baa emi.” ");
INSERT INTO tet_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Hotu, Isak nalo dahur. Sia naa bele-bele. ");
INSERT INTO tet_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Awan seisawan, sia moos namate menon nodi narai aan. Hotu, Isak nabusik sia fila nodi dame. ");
INSERT INTO tet_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Baa loron nia, Isak eman serwisu sia mai katak lia nosi wee knuuk mak sia noꞌi keꞌe nia naꞌak, “Ama! Ami hetan wee tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Hotu, Isak nanaran wee knuuk nia, Syeba, tan lia isin naꞌak ‘harai aan’. Tan baa nia, ema bolu kota nia Beer Syeba, toꞌo baa oras neꞌe. ");
INSERT INTO tet_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau otas tinan haat nulu, nia nola feto naꞌin rua nosi ema hunun Het, nalo baa feen. Ida, Beeri oan, naran Yudit. Ida tenik, Elon oan, naran Basmat. ");
INSERT INTO tet_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Feto rua nia nalo Isak no Ribka neon susar. ");
INSERT INTO tet_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Oras Isak hetak katuas, matan moos malahuk basuk tiꞌan. Loron ida, nia bolu oan ulun Esau mak nia nadomi basuk naꞌak, “Esau, mai neꞌe lai!” Esau nataa naꞌak, “Heꞌe ama.” ");
INSERT INTO tet_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Hotu, Isak katak baa Esau naꞌak, “Haꞌu katuas tiꞌan, la katene wainhira haꞌu kmate. ");
INSERT INTO tet_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Oras neꞌe, o mola rama no diman, baa buka mola naꞌan fuik ida bodik haꞌu! ");
INSERT INTO tet_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Hotu teꞌin, malo midar tuir haꞌukaan beer. Hotu, modi mai haꞌu. Kaa kotu, haꞌu kfoo kedan matak-malirin baa o. Kalo haꞌu kfoo matak-malirin baa o tiꞌan, haꞌu kmate moos, bele ona.” ");
INSERT INTO tet_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rona nola nunia, Esau sai baa buka naꞌan fuik. Mais natoon baa oras Isak dale no Esau, Ribka moos rona. ");
INSERT INTO tet_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Hotu, Ribka baa katak Yakob naꞌak, “Hei Yakob! Rona diꞌa-diꞌak! Foin da-dauk, haꞌu krona okaan aman dale baa Esau, naꞌak nuneꞌe: ");
INSERT INTO tet_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Baa buka mola naꞌan fuik ida. Hotu, teꞌin, malo midar, modi mai haꞌu. Kaa kotu tiꞌan, haꞌu kfoo kedan matak-malirin baa o iha MAROMAK oin.’ ");
INSERT INTO tet_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tan okaan ama naꞌak nunia, o rona diꞌa-diꞌak modi malo tuir haꞌukaan harukan neꞌe. ");
INSERT INTO tet_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Baa itakaan bibi natar, boi mola bibi salak bokur matan rua. Koꞌa mola isin, modi mai haꞌu. Haꞌu atu kteꞌin, tuir okaan aman beer. ");
INSERT INTO tet_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Teꞌin kotu tiꞌan, o musti modi baa okaan ama naa, nebee oras nia sei moris neꞌe, nia foo kedan matak-malirin baa o ona. Hodi nunia, o mak metan matak-malirin. Lahoos okaan maun.” ");
INSERT INTO tet_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mais Yakob dale baa inan naꞌak, “Nuneꞌe ina. Mau Esau isin marahuk, mais haꞌu lale! ");
INSERT INTO tet_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Keta arumak ama kaer kona haꞌukaan isin, hotu natene kedan naꞌak, haꞌu kbeꞌur nia. Hotu nia kastikar haꞌu!” ");
INSERT INTO tet_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mais inan katak naꞌak, “Yakob! Keta mataꞌuk. Ina mak nahulin! Kalo ama kastikar o, soꞌin ina mak natiu! Baa mola bibi nia sia ona.” ");
INSERT INTO tet_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Rona nola nunia, Yakob baa boi nola bibi. Hotu, koꞌa nodi foo baa inan. Ribka moos teꞌin kedan tuir Isak beer. ");
INSERT INTO tet_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hotu Ribka baa nola faru ida mak Esau tau nanis, foo baa Yakob tau. ");
INSERT INTO tet_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Nia moos falun Yakob liman no kokorok nodi bibi kulit mak noo rahun. ");
INSERT INTO tet_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Hotu nia foo baa Yakob haan midar nia no tubi mak nia nalo tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Hotu, Yakob nodi haan nia baa aman nodi katak naꞌak, “Ama! Haꞌu kmai tiꞌan.” Isak nataa naꞌak, “O see?” ");
INSERT INTO tet_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob nataa naꞌak, “Haꞌu, ama oan ulun, Esau! Haꞌu kalo tiꞌan tuir ama nakara ohin nia. Madeer, maa ona. Haꞌu kteꞌin tiꞌan naꞌan nia mak kola iha alas laran. Maa hotu, foo kedan matak-malirin baa haꞌu ona.” ");
INSERT INTO tet_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Rona nola nunia, Isak katak naꞌak, “O makaꞌas tebes! O bele metan lais nunia?” Yakob nataa naꞌak, “Haꞌu ketan neꞌe, tan MAROMAK mak ama loꞌu-sudur baa, tulun haꞌu!” ");
INSERT INTO tet_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Hotu, Isak bolu Yakob naꞌak, “Mareꞌis aan mai, nebee haꞌu kaer kokon o! O neꞌe, Esau tebes ka, lahoos?” ");
INSERT INTO tet_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Hotu, Yakob nareꞌis aan baa aman. Katuas nahuu kaer nia nodi naꞌak, “Lia maliak neꞌe, Yakob lian! Mais liman neꞌe, Esau liman.” ");
INSERT INTO tet_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isak la natene Yakob, tan liman marahuk hanesan Esau. Isak simu atu foo matak-malirin baa Yakob, ");
INSERT INTO tet_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","mais nia sei nusu tenik naꞌak, “O neꞌe, Esau tebes ka?” Yakob nataa naꞌak, “Tebes, ama!” ");
INSERT INTO tet_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Hotu, Isak dale naꞌak, “Lolo soruk naꞌan nia mai, nebee haꞌu kaa. Kaa kotu, haꞌu kfoo matak-malirin baa o.” Yakob moos lolo soruk naꞌan nia no anggor ween baa, Aman moos naa. ");
INSERT INTO tet_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Naa-nemu notu, aman katak naꞌak, “Oa! Mareꞌis aan mai, deꞌi haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakob moos nareꞌis aan baa deꞌi aman. Isak moos noran nola Esau farun nuhar. Hotu, nia foo matak-malirin baa Yakob naꞌak, “Haꞌukaan oan nuhar, hanesan hae molik mak MAROMAK natuun matak-malirin baa. ");
INSERT INTO tet_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nebee, Maromak natuun maꞌun nosi laleꞌan, nalo okaan toꞌos dadi boꞌas no boran! Nebee, Maromak foo o hare waꞌin lear, no anggor fuan bokar tebe-tebes. ");
INSERT INTO tet_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ema klubun sia atu dadi baa okaan atan. Ema hunun sia atu loꞌu-sudur no foo kneter baa o. Nebee, o ukun baa okaan maun-alin sia hotu-hotu. Sia moos nakniꞌa baa o. See mak kastikar o, sia moos netan kastikar. See mak foo matak-malirin baa o, sia moos netan matak-malirin.” ");
INSERT INTO tet_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak foo matak-malirin baa Yakob tiꞌan, Yakob sai nela aman. La kleur, maun Esau fila mai, nodi naꞌan mak foin kohi nola. ");
INSERT INTO tet_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nia baa teꞌin, hotu nodi baa aman. Nia bolu naꞌak, “Ama! Haꞌu kmai tiꞌan. Madeer maa ona. Haꞌu kteꞌin tiꞌan naꞌan fuik mak ama nusu nia. Ama naa notu, foo matak-malirin baa haꞌu ona.” ");
INSERT INTO tet_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Rona nola nunia, Isak blaar! Hotu nia nusu naꞌak, “Hoi! O neꞌe, see tenik?” Esau nataa naꞌak, “Haꞌu, Esau. Ama oan ulun.” ");
INSERT INTO tet_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Rona nola nunia, Isak kiki. Hotu nia nusu naꞌak, “Kalo nunia, see mak ohin nodi naꞌan baa haꞌu kaa nia? Haꞌu kfoo matak-malirin baa nia tiꞌan! La bele fokit kikar ona.” ");
INSERT INTO tet_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Rona aman dale nunia, Esau laran moras kedan. Nia tanis nodi nusu naꞌak, “Adeei, ama! Foo tenik matak-malirin baa haꞌu!” ");
INSERT INTO tet_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isak moos nataa naꞌak, “Okaan alin mai beꞌur nola haꞌu, nodi nanaꞌo nola okaan matak-malirin tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Hotu Esau dale naꞌak, “Nia beꞌur haꞌu dala rua tiꞌan. Uluk fohon, beꞌur nola haꞌukaan beran oa ulun! Oras neꞌe, beꞌur nola tenik haꞌukaan matak-malirin. Etuk oin, nia naran ‘Yakob’. Tan lisan tebe-tebes tuir naran ‘beꞌur teen’. Mais ama sei noo matak-malirin seluk bodik haꞌu ka lale?” ");
INSERT INTO tet_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak nataa naꞌak, “Haꞌu kfoti tiꞌan nia dadi baa okaan ulun. Niakaan maun-alin hotu-hotu, atu dadi baa niakaan atan! Haꞌu kfoo tiꞌan baa nia, hare waꞌin lear no anggor fuan bokar tebe-tebes. Dadi, oa! Oras neꞌe, matak-malirin saa tenik mak atu kfoo baa o? La noo tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Rona nola nunia, Esau nusu bei-beik baa aman naꞌak, “Ama noo matak-malirin mesak ida dei ka? Nanis, ama sei bele buka matak-malirin seluk bodik haꞌu. Masik oan ida dei moos, diꞌak!” Hotu, Esau tanis tenik. ");
INSERT INTO tet_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isak moos nataa nikar nia naꞌak, “O atu moris dook mosi toꞌos boran, tan maꞌun la tuun nosi laleꞌan nabotes okaan rain. ");
INSERT INTO tet_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Okaan surik naruk mak atu foo moris baa o. Masik nunabee moos, o dadi ata baa okaan alin. Kalo o bele maksakar aan mo nia, foin o bele makbudi sai mosi niakaan liman.” ");
INSERT INTO tet_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Nunia hotu, Esau hirus tebe-tebes Yakob, tan nia nadau nola niakaan matak-malirin. Mais Esau naneo naꞌak, “La kleur, ama mate. Dadi, haꞌu kein dei, toꞌo loron daka ama maten liu tiꞌan, foin haꞌu koꞌo nia!” ");
INSERT INTO tet_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Mais Ribka rona Esau lia kakotun nia. Hotu, nia bolu nola Yakob nodi katak naꞌak, “Rona diꞌa-diꞌak! Okaan maun hirus o toꞌo atu noꞌo o. Dadi, malai lai-lais baa okaan tua naꞌi Laban iha leo Haran. ");
INSERT INTO tet_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Baa mein heik iha nebaa, toꞌo okaan maun laran malirin. ");
INSERT INTO tet_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Nosi ikus, kalo nia naluꞌa tiꞌan okaan hahalok baa nia, foin haꞌu karuka ema bolu nikar o. Tan haꞌu la koꞌuk, haꞌukaan oan rua-rua lakon loron ida.” ");
INSERT INTO tet_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hotu, Ribka katak baa Isak naꞌak, “Haꞌu la kbeer tiꞌan Esau feen ema Het nia! Kalo Yakob moos nola feto Het, diꞌak liu haꞌu kmate.” ");
INSERT INTO tet_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Rona Ribka dale nunia, Isak bolu nola Yakob. Nia foo lia tateꞌan no nusu matak-malirin naꞌak, “Rona diꞌa-diꞌak, Yakob! O keta mola feto Kanaꞌan! ");
INSERT INTO tet_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Baa okaan bein Betuel uman iha Padan Aram. Mola okaan tua naꞌi Laban oan feto ida. ");
INSERT INTO tet_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nebee Maromak mak Beran Kaliuk natuun matak-malirin baa o. Nebee okaan husar-binan bea dadi baa ema klubun waꞌin boot! ");
INSERT INTO tet_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Nebee Maromak mamenon mak Nia namate no okaan bei Abraham, tuun baa o mo okaan husar-binan. O metan rai neꞌe, mak MAROMAK nameno tiꞌan latan baa bei Abraham.” ");
INSERT INTO tet_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Dale notu nunia, Isak moos nabusik Yakob baa tua naꞌi Laban no bei Betuel uman iha Padan-Aram. ");
INSERT INTO tet_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Baa oras nia, Esau rona nola naꞌak Isak foo lia tateꞌan baa Yakob tiꞌan naꞌak, keta nola feto Kanaꞌan, mais baa nola tua naꞌi oan feto ida iha Padan-Aram. ");
INSERT INTO tet_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau moos natene Yakob laꞌo tiꞌan baa Padan-Aram, tuir inan-aman hakaran. ");
INSERT INTO tet_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tan baa nia, Esau natene kedan naꞌak, aman la nakara niakaan feen sia mak ema Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tan lia nia, Esau baa niakaan ama boot Ismael, hotu nola Ismael oan feto ida, naran Mahalat, nalo tenik baa feen. Mahalat neꞌe, Nebayot feton. ");
INSERT INTO tet_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Oras nia, Yakob laꞌo nela Beer Syeba, atu baa leo Haran. ");
INSERT INTO tet_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Toꞌo dalan klaran, loro monu tiꞌan. Oras nia atu toba, nia nola fatuk ida nalo baa kluni. ");
INSERT INTO tet_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Baa kalan nia, nia meꞌi naꞌak, nia naree asodan ida nariik lolo, dikin aas toꞌo laleꞌan. Maromak Niakaan makbukar sia saꞌe-tuun asodan nia. ");
INSERT INTO tet_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Iha meꞌi nia moos, Yakob naree MAROMAK nariik iha niakaan sorin nodi naꞌak, “Haꞌu neꞌe, MAROMAK mak okaan bei Abraham no okaan ama Isak loꞌu-sudur baa. Haꞌu atu klatan rai neꞌe, bodik o mo okaan husar-binan. ");
INSERT INTO tet_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Okaan husar-binan sia atu bea waꞌin hanesan raihenek! Sia atu keke lema baa fatin hotu-hotu. Nosi okaan husar-binan, ema klubun hotu-hotu iha raiklaran neꞌe, atu netan matak-malirin. ");
INSERT INTO tet_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Manoin diꞌa-diꞌak! O baa nabee dei, Haꞌu kamalu. Haꞌu moos kdaka o. Haꞌu atu kodi o fila mikar mai rai neꞌe. Haꞌu la klaꞌo kela o. Mamenon hotu-hotu mak Haꞌu kameno baa o neꞌe, nanis dadi.” ");
INSERT INTO tet_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Oras Yakob naktekir, nia dale naꞌak, “Haꞌu kfoin katene, MAROMAK moos iha neꞌe!” ");
INSERT INTO tet_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Mais nia moos nataꞌuk nodi naneo naꞌak, “Adeei! Fatin neꞌe, nanis fatik lulik. Arumak Maromak Tofatik, mak odamatan baa laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Awan seisawan, Yakob nadeer. Nia foti nola fatuk kluni nia, nariik fatuk nia, nalo baa tadak. Hotu, nia fui mina baa fatuk leten, nodi loꞌu-sudur baa Maromak. ");
INSERT INTO tet_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nia nanaran fatin nia, Betel, tan lia fuan bet-el naꞌak ‘Maromak Tofatik’. (Uluk, fatin nia naran Lus.) ");
INSERT INTO tet_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Hotu, Yakob narai aan naꞌak, “Kalo Naꞌi Maromak namutuk haꞌu no daka haꞌu iha haꞌukaan dalan neꞌe, nodi foo haan no tais baa haꞌu, ");
INSERT INTO tet_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","toꞌo haꞌu fila kikar diꞌa-diꞌak, haꞌu atu kloꞌu-sudur baa Nia mesan dei. ");
INSERT INTO tet_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Fatuk mak haꞌu kariik tiꞌan neꞌe, dadi fatik loꞌu-sudur baa Maromak. Sa-saa hotu-hotu mak Maromak latan baa haꞌu, haꞌu moos foo kikar faꞌek ida nosi fafaꞌek sanulu.” ");
INSERT INTO tet_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hotu, Yakob laꞌo liu baa lorosaꞌe. ");
INSERT INTO tet_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Loron ida, nia naree wee knuuk kreꞌis baa leo ida. Bibi no bibi malae nako tolu nein atu nemu iha nia. Mais, noo fatuk boot ida mak taka nola wee knuuk nia. ");
INSERT INTO tet_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Hahalok nanis iha nia, bibi no bibi malae hotu-hotu libur malu tiꞌan, foin makbalin foti sees fatuk nia, nebee nakonu wee nodi naroo bibi sia. Naroo hotu, sia taka nikar wee knuuk nia. ");
INSERT INTO tet_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Toꞌo wee nia, Yakob nusu makbalin iha nia sia naꞌak, “Emi hosi nabee?” Sia nataa naꞌak, “Ami hosi leo Haran neꞌe.” ");
INSERT INTO tet_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakob nusu tenik naꞌak, “Emi hatene haꞌukaan tua naꞌi Laban ka lale? Nia mak Nahor bein oan!” Sia moos nataa naꞌak, “Ami hatene.” ");
INSERT INTO tet_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Hotu Yakob nusu tenik naꞌak, “Nia diꞌa-diꞌak dei ka?” Sia nataa nikar naꞌak, “Ama katuas diꞌa-diꞌak dei. Mana kokon nebaa. Niakaan oan feto Rahel nalaꞌo nodi bibi malae sia mai atu nemu wee iha neꞌe. Mein dei.” ");
INSERT INTO tet_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Rona nola nunia, Yakob dale tenik naꞌak, “Oras neꞌe loro sei aas! Diꞌak liu emi haroo bibi sia ona mak naklibur tiꞌan iha neꞌe. Hotu, halaꞌo hodi baa hae molik, nebee naa tenik hae.” ");
INSERT INTO tet_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mais sia sakar Yakob naꞌak, “La bele nunia! Ami musti hein makbalin sia hotu-hotu nodi bibi sia mai naklibur iha neꞌe lai, foin ami foti sees fatuk nia, hodi haroo bibi sia.” ");
INSERT INTO tet_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob sei dale no makbalin nia sia, Rahel moos toꞌo mai. Rahel nalaꞌo nodi aman niakaan bibi malae sia, tan loron-loron nia mak naliku. ");
INSERT INTO tet_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Naree Rahel no bibi sia mai, Yakob baa loke kedan wee knuuk tatakan nia. Hotu, nia naroo bibi sia. ");
INSERT INTO tet_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Hotu, nia nakoꞌak deꞌi Rahel nodi tanis naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","“Ali! Haꞌu neꞌe, o aman feton Ribka oan.” Rona nola nunia, Rahel nalai fila kedan baa katak aman. ");
INSERT INTO tet_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban rona Rahel dale naꞌak Yakob, mak nia feton Ribka oan, nia nalai baa nasoru. Nasoru nola tiꞌan, Laban nakoꞌak deꞌi Yakob, nodi baa uma. Yakob moos nasara lia hotu-hotu baa tua naꞌi Laban. ");
INSERT INTO tet_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Rona hotu-hotu tiꞌan, Laban simu naꞌak, “Tebes! Ita neꞌe famili malu.” ");
INSERT INTO tet_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Yakob tuur no sia fulan ida tiꞌan, ");
INSERT INTO tet_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","foin Laban katak baa Yakob naꞌak, “Nuneꞌe, Yakob! Ita rua famili malu. Haꞌu la koꞌuk o serwisu loos bodik haꞌu. O musu kansera hira?” ");
INSERT INTO tet_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Oras nia, Laban noo oan feto naꞌin rua. Biin naran Lea. Alin naran Rahel. ");
INSERT INTO tet_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea matan krai-raik. Mais Rahel oin kabaas lo-loos, isin moos furak. ");
INSERT INTO tet_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Tan Yakob beer Rahel, nia nataa Laban naꞌak, “Haꞌu atu kserwisu bodik tua naꞌi tinan hitu, surak haꞌu kola Rahel.” ");
INSERT INTO tet_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Rona nola nunia, Laban simu naꞌak, “Kakara! Diꞌak liu o mak mola Rahel, tan o haꞌukaan familin duꞌuk! Hein baa neꞌe dei, serwisu bodik haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hotu, Yakob serwisu tinan hitu, nebee netan Rahel. Nia beer Rahel liu resik. Dadi, tinan hitu nia, nia noran nuꞌu loron hira dei. ");
INSERT INTO tet_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Tinan hitu siku tiꞌan, Yakob foo natene baa Laban naꞌak, “Haꞌu kserwisu tinan hitu tiꞌan bodik tua naꞌi. Dadi, latan Rahel baa haꞌu ona.” ");
INSERT INTO tet_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Hotu, Laban nalo dahur, namata ema hotu-hotu iha rai nia. ");
INSERT INTO tet_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Mais kalan nia, Laban la latan Rahel baa Yakob. Nia naruka Lea mak tama baa Yakob batanen. Hotu, Yakob toba no Lea. Baa awan, foin Yakob natene naꞌak nia nola Lea, lahoos Rahel. Nia baa kedan naksuhuk baa Laban naꞌak, “Tan saa tua naꞌi maktolek haꞌu? Haꞌu kserwisu susi ruin tinan hitu tiꞌan atu ketan Rahel! Tan saa seluk Rahel hodi Lea?” Hotu Laban nataa naꞌak, “Keta nawan saꞌe nunia! Tuir amikaan adat iha neꞌe, alin la bele noo uluk laꞌen. Diꞌak liu, o mein toꞌo dahur loron hitu neꞌe hotu lai, foin haꞌu klatan tenik Rahel. Surak o serwisu bodik haꞌu tinan hitu tenik.” Baa oras nia, Laban moos latan ata feto ida naran Silpa, dadi baa Lea atan. ");
INSERT INTO tet_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Rona nola Laban dalen, Yakob moos simu. Oras dahur loron hitu nia hotu tiꞌan, Laban latan Rahel baa Yakob. ");
INSERT INTO tet_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban moos latan tenik ata feto ida naran Bilha, dadi baa Rahel atan. ");
INSERT INTO tet_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Hotu, Yakob toba no Rahel. Nia beer basuk Rahel liu nosi Lea. Nia moos serwisu tuꞌan tenik tinan hitu bodik niakaan banin mane. ");
INSERT INTO tet_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","MAROMAK natene Yakob beer Rahel liu Lea. Tan lia nia, MAROMAK nakara Lea nahoris oan. Mais Rahel la noo oan. ");
INSERT INTO tet_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea moos koꞌus, hotu netan oan mane ida. Nia dale naꞌak “MAROMAK naree haꞌukaan susar tiꞌan! Oras neꞌe, haꞌukaan laꞌen nakara haꞌu ona.” Hotu, Lea nanaran oan nia, naran Ruben (tan lia fuan ruben hanesan lia fuan ida naꞌak, “Nia naree haꞌukaan susar tiꞌan”). ");
INSERT INTO tet_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Hotu, Lea koꞌus, netan tenik oan mane ida. Nia dale naꞌak, “MAROMAK rona tiꞌan haꞌukaan laꞌen la naliku haꞌu. Tan baa nia, MAROMAK foo tuꞌan tenik oan ida baa haꞌu.” Hotu, Lea nanaran oan nia, naran Simeon (tan lia fuan simeon isin naꞌak ‘rona tiꞌan’). ");
INSERT INTO tet_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hotu, Lea koꞌus, netan tenik oan mane ida. Nia dale naꞌak, “Kodi oan neꞌe, haꞌukaan lia mohu tiꞌan. Haꞌukaan laꞌen nanis nametis aan no haꞌu, tan haꞌu kahoris oan mane naꞌin tolu tiꞌan bodik nia.” Tan baa nia, Lea nanaran oan nia, naran Lewi (tan lia fuan lewi isin naꞌak ‘hametis aan’). ");
INSERT INTO tet_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nosi ikus, Lea koꞌus, netan tenik oan mane ida. Nia dale naꞌak, “Dala ida neꞌe, haꞌu kakara tonu-kaboot MAROMAK!” Hotu, Lea nanaran oan nia, naranYahuda (tan lia fuan yahuda isin naꞌak ‘tonu-haboot’). Nunia tiꞌan, Lea la nahoris ona. ");
INSERT INTO tet_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Oras nia, Rahel sei dauk netan oan. Tan lia nia, Rahel hirus biin. Nia dale baa laꞌen naꞌak, “Ama! Foo oan baa haꞌu lai! Kalo lale, diꞌak liu haꞌu kmate.” ");
INSERT INTO tet_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Rona Rahel naksuhuk nunia, Yakob nakanas naꞌak, “O maneo haꞌu neꞌe, Maromak mak bele foo oan baa o ka!?” ");
INSERT INTO tet_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rahel nataa naꞌak, “Nuneꞌe! Diꞌak liu, o mola haꞌukaan atan Bilha, toba mo nia, nebee nahoris oan bodik haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Hotu, Rahel latan Bilha baa laꞌen. Yakob moos toba no nia. ");
INSERT INTO tet_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha koꞌus, hotu nahoris oan mane ida. ");
INSERT INTO tet_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Naree nunia, Rahel dale naꞌak, “Maromak rona haꞌukaan hamulak tiꞌan nodi foo oan mane ida baa haꞌu! Nia nakotu haꞌukaan lia nodi moon!” Hotu, Rahel nanaran oan nia, naran Dan (tan lia fuan dan isin naꞌak ‘hakotu lia hodi moon’). ");
INSERT INTO tet_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Hotu, Bilha koꞌus, netan tenik oan mane ida. ");
INSERT INTO tet_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel moos dale tenik naꞌak, “Haꞌu ko haꞌukaan biin sita malu tiꞌan. Haꞌu mak kodi nia.” Tan baa nia, Rahel nanaran oan nia, naran Naftali (tan lia fuan naftali isin naꞌak ‘sita malu’). ");
INSERT INTO tet_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Oras Lea noran la netan oan tenik, nia latan atan Silpa baa Yakob, atu nalo baa feen. ");
INSERT INTO tet_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Hotu, Silpa koꞌus, nahoris oan mane ida. ");
INSERT INTO tet_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Naree nunia, Lea dale naꞌak, “Haꞌu ketan sotir diꞌak tiꞌan.” Tan baa nia, Lea nanaran oan nia, naran Gad (tan lia fuan gad isin naꞌak ‘sotir diꞌak’). ");
INSERT INTO tet_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Hotu, Silpa koꞌus, nahoris tenik oan mane ida. ");
INSERT INTO tet_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Naree nunia, Lea moos dale naꞌak, “Haa! Oras neꞌe, foin haꞌu neon diꞌak! Lei haree! Feto hotu-hotu atu dale naꞌak, haꞌu ketan sotir diꞌak basuk tiꞌan.” Tan baa nia, Lea nanaran oan nia, naran Aser (tan lia fuan aser isin naꞌak ‘neon diꞌak’). ");
INSERT INTO tet_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Dala ida, oras kuꞌu hare, Ruben baa alas laran. Nia netan ai horis ida dadi aitahan mak bele nalo ema netan oan. Nia nodi mai baa inan Lea. Naree nunia, Rahel nusu baa Lea naꞌak, “Bii! Aitahan mak ohin Ruben nodi mai nia, foo oan ida baa haꞌu lai.” ");
INSERT INTO tet_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Mais Lea nataa naꞌak, “Hoi! O neꞌe, liu resik! O madau mola haꞌukaan laꞌen tiꞌan. Oras neꞌe, o nmakara madau mola tenik aitahan mosi haꞌukaan oan. O neꞌe moe lalek!” Mais Rahel dale naꞌak, “Nuneꞌe bii. Kalo haꞌu ketan aitahan nia, ohin kalan neꞌe o bele toba mo Yakob!” Rona nola nunia, Lea moos nakara. ");
INSERT INTO tet_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Loro malirin, Yakob fila nikar nosi toꞌos. Lea baa nasoru Yakob nodi naꞌak, “Yakob! Kalan neꞌe, o musti toba mo haꞌu, tan haꞌu kselu kedan tiꞌan, kodi haꞌukaan oan aitahan.” Hotu, Yakob toba no Lea baa kalan nia. ");
INSERT INTO tet_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Tan Maromak rona Lea namulak, Lea moos koꞌus, hotu nahoris oan mane nomer lima. ");
INSERT INTO tet_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nia dale naꞌak, “Maromak selu haꞌukaan kolen tiꞌan, tan haꞌu klatan Silpa dadi baa haꞌukaan laꞌen feen.” Tan baa nia, Lea nanaran oan nia, naran Isaskar (tan lia fuan isaskar naꞌak ‘selu kolen’). ");
INSERT INTO tet_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nosi ikus, Lea koꞌus, hotu nahoris tenik oan mane nomer neen. ");
INSERT INTO tet_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Nia dale naꞌak, “Maromak foo loos lia kabaas ida baa haꞌu tiꞌan. Oras neꞌe, haꞌukaan laꞌen musti nakneter haꞌu, tan haꞌu kahoris oan mane naꞌin neen tiꞌan bodik nia.” Hotu, Lea nanaran oan nia, naran Sebulon (tan lia fuan sebulon isin naꞌak ‘hakneter’). ");
INSERT INTO tet_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Nosi ikus, Lea nahoris oan feto ida. Nia nanaran oan nia, naran Dina. ");
INSERT INTO tet_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nosi ikus, Maromak nanoin Rahel nodi rona niakaan hamulak. Maromak loke Rahel notak, ");
INSERT INTO tet_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","hotu Rahel koꞌus, nahoris oan mane ida. Hotu nia dale naꞌak, “Maromak foti soe haꞌukaan moe tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nia moos dale naꞌak, “Nebee Maromak foo tuꞌan oan mane ida tenik baa haꞌu.” Tan baa nia, Rahel nanaran oan nia, naran Yusuf (tan lia fuan yusuf isin naꞌak ‘kusu nebee foo tuꞌan’). ");
INSERT INTO tet_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahel nahoris Yusuf tiꞌan, Yakob dale no Laban naꞌak, “Ama! Kalo bele, haꞌu kfila uma lai, ");
INSERT INTO tet_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ko haꞌukaan feen no oan sia. Ama natene haꞌu kserwisu susi ruin bodik selu kotu sia tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Rona mane foun dale nunia, banin mane nataa naꞌak, “Oa, rona lai! Kodi kleno urat, haꞌu katene MAROMAK natuun matak-malirin baa haꞌu, tan o. ");
INSERT INTO tet_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Dadi, makara musu hira moos, haꞌu kselu! Surak, tuur mafati iha neꞌe, modi serwisu nima-nimak bodik haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Rona nola nunia, Yakob nataa naꞌak, “Ama naree duꞌuk tiꞌan, haꞌukaan serwisu makaꞌas. Tan haꞌu serwisu makaꞌas nunia, ama niakaan bibi no karau sia bea bei-beik. ");
INSERT INTO tet_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Oras haꞌu ksei la mai dauk, ama sasoin sia sei la duun waꞌin nunia. Mais oras neꞌe, ama soi tiꞌan. MAROMAK natuun matak-malirin baa ama, tan haꞌukaan serwisu nia. Oras toꞌo tiꞌan, haꞌu atu kserwisu bodik haꞌukaan feen-oan.” ");
INSERT INTO tet_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Rona nola nunia, Laban nusu naꞌak, “Haꞌu kmusti selu nunabee baa o?” Yakob nataa naꞌak, “Ama lalika foo sa-saa baa haꞌu. Haꞌu atu kaliku ama niakaan bibi sia bei-beik, surak haꞌu kbele kalo lia ida nuneꞌe. ");
INSERT INTO tet_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ohin loron neꞌe kedan, foo leet baa haꞌu kbaa ama niakaan bibi no bibi malae sia, nebee kboi kola balu. Rahun la makerek, dadi baa ama niakaan. Mais kalo rahun makerek, dadi baa haꞌukaan. Haꞌu moos kola bibi malae metan hotu-hotu. Bibi nia sia, hodi selu haꞌukaan kolen. ");
INSERT INTO tet_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Baa loron ikus, ama bele natene haꞌu neꞌe moon ka lale. Oras nabee dei, ama bele mai naree haꞌukaan bibi sia. Kalo ama naree bibi rahun la makerek, lale haree bibi malae mutik, ama natene kedan naꞌak, haꞌu kanaꞌo kola bibi nia sia.” ");
INSERT INTO tet_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Rona nola nunia, Laban simu nodi naꞌak, “Diꞌak! Nunia dei.” ");
INSERT INTO tet_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","36","Mais loron nia moos, Laban beꞌur kedan Yakob, nodi faꞌe salin bibi mak rahun makerek no mak rahun metan. Hotu, nia naruka oan sia nalaꞌo nodi kedan bibi nia sia baa fatin ida mak salin dook nosi Yakob. Fatin nia, laꞌo rai loron tolu laran. Hotu, sia naliku bibi nia sia iha nia. Mais Yakob sei naliku banin mane niakaan bibi no bibi malae seluk sia. ");
INSERT INTO tet_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Hotu, nia taa nola ai sorun nosi ai huun oik tolu. Nia loke ai kulit nia sia nalo makerek mak noo kaketak. ");
INSERT INTO tet_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Nia tau ai makerek mak noo keketak nia sia baa bibi hemun fatik. Bibi sia nanis naklaꞌok malu iha nia. ");
INSERT INTO tet_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tan bibi sia naklaꞌok malu iha ai makerek mak noo keketak nia sia, oan sia moris mai, rahun makerek. ");
INSERT INTO tet_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Oras Laban niakaan bibi sia naklaꞌok malu, Yakob feur sia seꞌi oin baa bibi rahun makerek. Hotu, oan sia moos rahun makerek hotu. Nodi nunia, Yakob niakaan bibi sia bea tuꞌan. Hotu, nia sasa faꞌe sia, nosi Laban niakaan bibi sia. ");
INSERT INTO tet_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Baa oras bibi mak biit naklaꞌok malu, Yakob tau ai makerek iha siakaan oin iha siakaan hemun fatik. ");
INSERT INTO tet_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mais, kalo naree bibi biit lalek sia naklaꞌok malu, nia la rai ai baa. Hodi nunia, Laban netan bibi biit lalek hotu-hotu. Mais, Yakob netan bibi mak biit hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hodi nunia, Yakob soi tebe-tebes. Niakaan bibi, bibi malae, kuda unta, kuda keledai no ata sia, waꞌin liu resik. ");
INSERT INTO tet_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Dala ida, Yakob rona Laban oan sia dale baa malu naꞌak, “Yakob neꞌe soi basuk, tan nia koi namara itakaan aman sasoin tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Baa oras nia moos, Yakob naree banin mane Laban oin kadubuk no la diꞌak no nia hanesan uluk. ");
INSERT INTO tet_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hotu, MAROMAK naruka Yakob naꞌak, “Oras toꞌo tiꞌan. Fila mikar baa o inan-aman ona. Haꞌu nanis kamalu o.” ");
INSERT INTO tet_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Rona Maromak naruka nunia, Yakob moos naruka ema bolu Rahel no Lea mai nasoru nia iha hae molik. ");
INSERT INTO tet_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Feen sia toꞌo mai tiꞌan, Yakob katak baa naꞌak, “Loron hira neꞌe, haꞌu karee emikaan aman oin kadubuk no la diꞌak no haꞌu hanesan uluk. Mais haꞌu katene kaꞌak, Maromak mak haꞌukaan ama tonu-naboot, nanis namutuk no haꞌu. ");
INSERT INTO tet_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Emi rua hatene haꞌu kserwisu susi ruin kleur tiꞌan bodik emikaan aman. ");
INSERT INTO tet_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mais nia beꞌur nakdiuk haꞌu! Nia seluk nakdiuk haꞌukaan saseban toꞌo dala sanulu. Masik nunia moos, Maromak daka diꞌa-diꞌak haꞌu. ");
INSERT INTO tet_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Oras emikaan aman nameno baa haꞌu naꞌak, ‘Bibi rahun makerek sia dadi baa okaan saseban,’ foin bibi nahoris oan rahun makerek hotu. Baa dala seluk nia dale tenik naꞌak, ‘Oras neꞌe, bibi rahun falatak sia dadi baa okaan saseban.’ Foin bibi sia nahoris oan rahun falatak hotu. ");
INSERT INTO tet_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Maromak mak nalo nunia, nebee nola emikaan aman bibin, foo baa haꞌu. ");
INSERT INTO tet_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Dala ida, oras bibi sia naklaꞌok malu, haꞌu kmeꞌi karee kaꞌak bibi aman mak naklaꞌok nia sia, rahun makerek no falatak mohu. ");
INSERT INTO tet_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Hotu, Maromak Niakaan makbukar laleꞌan ida bolu haꞌu iha meꞌi nia naꞌak, ‘Hei Yakob!’ Haꞌu ksimu kaꞌak, ‘Heꞌe Naꞌi Maromak?’ ");
INSERT INTO tet_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Nia moos katak naꞌak, ‘Maree lai! Bibi aman mak naklaꞌok nia sia, rahun makerek no falatak mohu. Haꞌu mak babilan nunia, tan Haꞌu karee tiꞌan saa mak Laban nalo baa o. ");
INSERT INTO tet_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Haꞌu neꞌe, Maromak. Haꞌu mak katadu aan baa o iha Betel. Iha nebaa, o mariik fatuk ida, o fui mina baa leten, modi loꞌu-sudur baa Haꞌu. Hotu, o mamate menon mo Haꞌu iha nia. Oras neꞌe, o musti laꞌo mela rai neꞌe, fila mikar baa okaan inan-aman rain.’ ” ");
INSERT INTO tet_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rona laꞌen dale nunia, Rahel no Lea nataa naꞌak, “Diꞌak! Ami tuir dei, tan ami la hetan tenik sasoin tiꞌan nosi ama Laban! ");
INSERT INTO tet_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nia nalo ami hanesan ema seluk! Nia faꞌan ami, hotu naa lakon amikaan folin! ");
INSERT INTO tet_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Sasoin hotu-hotu mak Maromak nola tiꞌan nosi ama Laban, oras neꞌe dadi bein sasoin bodik ami ho amikaan oan sia! Tan lia nia, kalo Maromak katak nunia tiꞌan, ami tuir baa dei!” ");
INSERT INTO tet_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Feen sia simu nunia, Yakob moos nahuu nadiꞌa naha sia. Nia nasaꞌe feen-oan hotu-hotu baa kuda unta, no naha mak nia netan tiꞌan iha Padan-Aram. Nia nalaꞌo nodi bibi no karau hotu-hotu, fila nikar baa rai Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Oras Yakob sia atu laꞌo, Laban la iha uma, tan nia baa teri bibi malae rahun. Naree nunia, Rahel foti nanaꞌo nodi aman niakaan aiꞌoi lulik sia. ");
INSERT INTO tet_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob sia laꞌo, la tami niakaan banin mane. ");
INSERT INTO tet_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Sia laꞌo lai-lais nodi sasoin hotu-hotu, nakur mota boot, liu baa foho Gilead. ");
INSERT INTO tet_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Loron tolu liu tiꞌan, foin Laban natene naꞌak Yakob sia nalai tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Hotu, Laban libur niakaan ema sia, teꞌur tuir Yakob sia. Tuir toꞌo loron hitu, foin toma sia iha foho Gilead sia. ");
INSERT INTO tet_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Baa kalan nia, Maromak natadu aan baa Laban iha meꞌi naꞌak, “Laban! Kalo o dale mo Yakob, daka ibun diꞌa-diꞌak.” ");
INSERT INTO tet_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Kalan nia, Yakob nariik batane iha foho Gilead sia. Laban sia moos nariik batane la dook nosi nia. ");
INSERT INTO tet_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Baa awan, Laban mai nasoru Yakob nodi katak naꞌak, “Yakob! Tan saa o malai no-nook modi haꞌukaan oan feto sia? Hanesan o modi ema mak o kohi mola iha hatuda laran. ");
INSERT INTO tet_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","O malai no-nook, o la tami haꞌu tenik! Kalo o katak diꞌa-diꞌak haꞌu, nanis haꞌu kalo dahur, kalaꞌo emi kodi likurai no bareka, foin emi laꞌo! ");
INSERT INTO tet_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Okaan salan ida tenik, o la foo leet baa haꞌu kdeꞌi haꞌukaan oan no bein oan sia. Okaan hahalok neꞌe, beik liu resik! ");
INSERT INTO tet_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Haꞌu atu kasusar o, bele basuk! Mais hori kalan, Maromak mak okaan ama loꞌu-sudur baa, deꞌan haꞌu naꞌak, kalo haꞌu kdale ko o, haꞌu kmusti daka ibun diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Haꞌu katene o laꞌo neꞌe tan o makara fila mikar! Mais, tan saa o sei manaꞌo modi tenik haꞌukaan aiꞌoi lulik sia?” ");
INSERT INTO tet_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakob nataa naꞌak, “Tua naꞌi keta deꞌan haꞌu! Haꞌu klaꞌo no-nook, tan haꞌu kataꞌuk keta arumak tua naꞌi natoos oan neꞌe sia, hotu nunabee?” ");
INSERT INTO tet_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yakob dale nunia, mais nia duꞌuk la natene feen Rahel nanaꞌo nodi aiꞌoik nia sia. Hotu, nia dale tenik naꞌak, “Tua naꞌi! Lia aiꞌoi lulik nia, buka baa! Kalo o metan, taa ukun mate baa ema mak nodi. Sobu karin hotu-hotu dei! Kalo ama naꞌi metan sasoin seluk sia moos, mola mikar. Nebee, ema neꞌe sia hotu-hotu dadi saksiin.” ");
INSERT INTO tet_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Hotu, Laban baa buka aiꞌoik nia sia iha ida-idak batanen. Uluk fohon, Yakob niakaan. Hotu, Lea niakaan. Liu baa, ata feto rua siakaan. Mais, nia la netan aiꞌoik nia sia. Ikus basuk, nia tama baa Rahel batanen. ");
INSERT INTO tet_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mais, Rahel rai subar aiꞌoik nia sia iha kusin kuda unta ohak. Hotu, nia tuur natoos. Laban buka nasirin Rahel batanen, mais la netan. ");
INSERT INTO tet_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Oras nia Rahel dale baa aman naꞌak, “Ama keta kanarak. Haꞌu la kbele kariik, tan haꞌu koꞌi kasoru fulan.” Laban buka baa-mai, mais la netan. ");
INSERT INTO tet_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Hotu, Yakob nawan saꞌe. Nia dale makaꞌas baa Laban naꞌak, “Haꞌu kalo aat saa tiꞌan baa tua naꞌi, toꞌo teꞌur tuir haꞌu hanesan ema aat! ");
INSERT INTO tet_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tua naꞌi sobu karin naha sia tiꞌan! Hotu, hetan saa? Kalo hetan saa, rai baa oin neꞌe, nebee ita hotu-hotu haree! Nebee ema neꞌe sia bele nakotu, see niakaan! ");
INSERT INTO tet_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Tinan rua nulu tiꞌan, haꞌu kserwisu bodik tua naꞌi. Oras haꞌu kdaka tua naꞌi niakaan bibi no karau sia, la noo matan ida mak lonus. Matan ida moos, haꞌu la kaa kola. ");
INSERT INTO tet_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kalo asu fuik noꞌo tua naꞌi bibin, haꞌu la kasara baa tua naꞌi. Mais haꞌu mak selu duꞌuk. Tenik, kalo ema nanaꞌo tua naꞌi bibin, tua naꞌi naruka haꞌu mak selu, masik haꞌu la sala! ");
INSERT INTO tet_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Oras loro makas, loro tunu nawai haꞌu. Baa kalan, haꞌu kiki tan malirin. Masik haꞌu kakati moos, haꞌu kdaka tua naꞌi bibin sia loron-kalan. ");
INSERT INTO tet_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tinan rua nulu nia, tebes! Haꞌu kserwisu tinan sanulu resin haat, nebee haꞌu ketan tua naꞌi oan feto sia! Hotu kserwisu tenik tinan neen, nebee haꞌu ketan bibi sia! Haꞌu kserwisu kleur nunia, mais tua naꞌi seluk nakdiuk haꞌukaan saseban sia, toꞌo dala sanulu. ");
INSERT INTO tet_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mais haꞌu ksotir tan Maromak mak Bei Abraham no Ama Isak loꞌu-sudur baa. Kalo Maromak la daka haꞌu, nanis tua naꞌi naruka ema nabuꞌa fila haꞌu, laꞌo kodi liman mamuk. Mais Maromak la taka matan baa haꞌukaan susar. Nia naree haꞌukaan serwisu hotu-hotu. Etuk hori fonin, Nia mai naruka tua naꞌi daka ibun.” ");
INSERT INTO tet_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Rona Yakob dale nunia, Laban dale naꞌak, “Nuneꞌe! Feto naꞌin rua nia, haꞌukaan oan. Oan mak sia nahoris moos haꞌukaan bein oan sia. Bibi no karau hotu-hotu neꞌe moos, haꞌukaan. Sa-saa hotu-hotu mak o maree iha neꞌe, nanis haꞌukaan! Mais, haꞌu la kbele katoos. ");
INSERT INTO tet_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Diꞌak liu, ita rua hamate menon, nebee ita moris tuir mamenon nia.” ");
INSERT INTO tet_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hotu, Yakob foti nola fatuk boot ida, taman nariik fatuk nia atu nalo tadak. ");
INSERT INTO tet_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Nia moos naruka niakaan ema sia libur fatuk nodi butuk. Hotu, Yakob no Laban sia hotu-hotu tuur atu nalo lahan nodi naa iha nia. ");
INSERT INTO tet_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban tau naran baa fatuk butuk nia nodi lia Aram naꞌak Yegar Sahaduta (lia isin naꞌak ‘fatuk saksiin’). Yakob moos foo naran nodi lia Ibrani naꞌak Galeed (lia neꞌe moos naꞌak ‘fatuk saksiin’). ");
INSERT INTO tet_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Hotu, Laban katak naꞌak, “Fatuk butuk neꞌe, dadi saksiin bodik ita rua.” (Tan lia nia, ema nanaran fatin nia naꞌak Galeed.) ");
INSERT INTO tet_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban moos katak naꞌak, “Nanis MAROMAK duꞌuk mak daka ita rua, nebee masik ita rua dook malu, ita keta hakur mamenon neꞌe.” Etuk, nia moos nanaran fatin nia, Mispa (tan lia fuan mispa neꞌe, lian hanesan lia fuan naꞌak ‘daka fatin aas’). ");
INSERT INTO tet_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Hotu Laban dale tenik naꞌak, “Kalo o malo aat mo haꞌukaan oan sia, lale o mola tenik feto, haꞌu la katene. Mais manoin! Maromak mak dadi saksiin baa o mo haꞌu. ");
INSERT INTO tet_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Maree kokon fatuk hariik no fatuk butuk neꞌe. Fatuk neꞌe sia dadi kladik. O la bele makur liu fatuk neꞌe sia, modi malo aat baa haꞌu. Haꞌu moos la bele kakur liu fatuk neꞌe sia, kodi kalo aat baa o. ");
INSERT INTO tet_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ita rua hamate menon neꞌe, hodi itakaan bei siakaan Maromak, mak okaan bei Abraham no haꞌukaan bei Nahor loꞌu-sudur baa. Maromak duꞌuk mak dadi makotu lia bodik ita.” Hodi nunia, Yakob moos tuir narai aan nodi Maromak naran, mak niakaan aman Isak loꞌu-sudur baa. ");
INSERT INTO tet_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hotu, Yakob nalo sera baa Maromak iha foho nia leten. Nia moos bolu ema hotu-hotu iha nia sia atu mai naa bele-bele, nodi daka toꞌo seisawan. ");
INSERT INTO tet_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Seisawan oan, Laban nakoꞌak deꞌi oan no bein oan sia hotu-hotu. Nia naloon foo matak-malirin baa sia. Hotu, nia fila nikar. ");
INSERT INTO tet_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laban fila nikar tiꞌan, Yakob sia moos laꞌo liu. Hotu, Maromak Niakaan makbukar laleꞌan sia mai nasoru nia. ");
INSERT INTO tet_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Naree sia nunia, Yakob dale naꞌak, “Fatin neꞌe, nanis Maromak hanawa fatin!” Tan baa nia, Yakob nanaran fatin nia, Mahanaim (tan mahanaim lia isin naꞌak ‘hanawa fatin rua’). ");
INSERT INTO tet_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Hotu, Yakob naruka niakaan klosan naꞌin hira, baa uluk rai Edom (neꞌe mak rai Seir), nebee katak baa maun Esau naꞌak nia atu mai. ");
INSERT INTO tet_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakob katak baa klosan sia naꞌak, “Emi baa katak baa haꞌukaan maun Esau nuneꞌe: ‘Ama boot Esau! Ama boot atan, ali Yakob, solok tabe hakneter waꞌin lo-loos. Nahuu hori laꞌo uluk nia, toꞌo oras neꞌe, ama boot atan neꞌe, tuur iha tua naꞌi Laban uman. ");
INSERT INTO tet_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Oras neꞌe, ama boot atan neꞌe, noo karau baka, kuda keledai, bibi, bibi malae, ata feto no ata mane. Nia solok ami neꞌe mai uluk, katak ama boot nosi niakaan mamain. Nia naloon, nebee ama boot simu ami nodi liman rua.’ ” Yakob naruka nunia, klosan sia moos baa. ");
INSERT INTO tet_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Klosan sia nasoru Esau tiꞌan, sia fila nikar, nasara baa Yakob naꞌak, “Ami hasoru tiꞌan ama maun, Esau. Oras neꞌe, nia laꞌo mai nasoru ama nodi mane naꞌin atus haat.” ");
INSERT INTO tet_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Rona nola nunia, Yakob neon kiki, tan nia nataꞌuk tebes. Nia faꞌe niakaan ema no karau no bibi sia hotu-hotu, nalo baa lolok rua. ");
INSERT INTO tet_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nia naneo naꞌak, “Kalo Esau mai, hotu nalatu ema lolok uluk, lolok ikus bele nalai sori aan.” ");
INSERT INTO tet_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakob moos namulak naꞌak, “Maromak, mak haꞌukaan bei Abraham no ama Isak loꞌu-sudur baa. Rona haꞌu lai! Hori hirak nia, Maromak naruka haꞌu kmai kikar haꞌukaan familin sia iha rai neꞌe. MAROMAK mak namate menon tiꞌan naꞌak, Maromak mak atu babilan nalo diꞌak hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Haꞌu la kfatan simu Maromak dadomin mak la natuka! Uluk, oras haꞌu kakur mota Yordan neꞌe, kodi knoꞌan dei. Mais, oras neꞌe haꞌu kmai kikar, kodi ema no karau no bibi lolok rua. ");
INSERT INTO tet_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Haꞌu kataꞌuk arumak mau Esau mai noꞌo ami. Tan lia nia, haꞌu kakroꞌan, nebee Naꞌi Maromak sori haꞌu ko haꞌukaan feen-oan hotu-hotu, bele hakbois hosi mau Esau. ");
INSERT INTO tet_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Naꞌi Maromak mak namate menon naꞌak, atu natuun matak-malirin waꞌin baa haꞌu, nodi nalo haꞌukaan husar-binan bea tuꞌan, hanesan raihenek iha tasi tehen mak ema la bele sura nola.” ");
INSERT INTO tet_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Namulak notu, Yakob toba iha nia. Baa awan, nia nadiꞌa bibi no karau sia atu foo baa maun. ");
INSERT INTO tet_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Nia boi nola bibi inan matan atus rua, bibi aman matan rua nulu, bibi malae inan matan atus rua, bibi malae aman matan rua nulu, ");
INSERT INTO tet_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kuda unta matan tolu nulu no oan sei susu, karau baka inan matan haat nulu, karau baka aman matan sanulu, kuda keledai inan matan rua nulu no kuda keledai aman matan sanulu. ");
INSERT INTO tet_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Hotu, nia faꞌe oik ida, lolok ida. Hotu, nalo lolok ida noo makbalin duꞌuk. Nia katak baa makbalin sia naꞌak, “Emi laꞌo uluk. Haꞌu ktuir kosi kotuk! Mais musti daka, nebee lolok ida dook netik nosi lolok ida seluk.” ");
INSERT INTO tet_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Hotu, Yakob naruka makbalin lolok uluk naꞌak, “Kalo haꞌukaan maun Esau nasoru emi, hotu nusu naꞌak, ‘Emi atu baa nabee? Emi neꞌe see klosan? Bibi no karau neꞌe sia see niakaan?’ ");
INSERT INTO tet_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","emi musti hataa haꞌak, ‘Bibi no karau neꞌe sia, ama boot atan Yakob niakaan! Nia solok baa maun, ama boot Esau. Mais, nia duꞌuk sei ikus.’ ” ");
INSERT INTO tet_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Yakob moos naruka baa makbalin hotu-hotu nosi lolok seluk sia naꞌak, “Kalo emi hasoru mau Esau, latan bibi no karau neꞌe sia baa nia, hotu katak haꞌak, haꞌu ksei iha ikus.” Yakob naruka nunia, tan nia nanoin, kalo nia latan bibi no karau nia sia hotu-hotu baa Esau, Esau laran bele malirin no nia. ");
INSERT INTO tet_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tan lia nia, nia solok uluk bibi no karau nia sia baa. Mais kalan nia, nia sei iha Mahanaim. ");
INSERT INTO tet_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Baa kalan nia, Yakob nadeer, babilan feen kawaꞌik rua, feen kiꞌik rua, no oan naꞌin sanulu resin ida, atu nakur mota Yabok balu. ");
INSERT INTO tet_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Toꞌo balu baa, Yakob moos solok niakaan sasoin hotu-hotu baa. ");
INSERT INTO tet_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nunia hotu, Yakob mesan sei iha nia. Hotu, mane ida mai nakteꞌur no nia, toꞌo kreꞌis loro saꞌe. ");
INSERT INTO tet_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mane nia noran atu monu, nia moos tuku Yakob kidan fukun, toꞌo ruin naklosu sai nosi tuur fatin. ");
INSERT INTO tet_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Hotu, mane nia dale naꞌak, “Mabusik haꞌu, tan loro atu saꞌe ona.” Mais Yakob nataa naꞌak, “Matuun matak-malirin baa haꞌu lai, foin kabusik o!” ");
INSERT INTO tet_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Hotu, mane nia nusu naꞌak, “O naran see?” Nia nataa naꞌak, “Yakob.” ");
INSERT INTO tet_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Hotu, mane nia naꞌak, “Okaan naran lahoos Yakob tenik! Nahuu baa oras neꞌe, ema atu bolu o Israꞌel, tan o makteꞌur tiꞌan sakar ema raiklaran no sakar Maromak, toꞌo o modi sia.” (Naran Isra-el neꞌe naꞌak ‘nia mak nakteꞌur no Maromak’.) ");
INSERT INTO tet_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Hotu, Yakob moos nusu naꞌak, “O naran see?” Mais, mane nia nataa naꞌak, “O musu haꞌukaan naran atu malo saa?” Hotu, nia natuun matak-malirin baa Yakob iha nia. ");
INSERT INTO tet_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nunia hotu, Yakob dale naꞌak, “Haꞌu karee besik Maromak oin tiꞌan, mais haꞌu ksei moris.” Tan baa nia, Yakob nanaran fatin nia naꞌak, Peniel. Lia isin naꞌak, ‘Maromak Oin’. ");
INSERT INTO tet_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Loro saꞌe tiꞌan, foin Yakob laꞌo nela fatin nia. Mais nia laꞌo la diꞌak, tan kidan fukun naksala. ");
INSERT INTO tet_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tan baa nia, toꞌo oras neꞌe, ema Israꞌel sia la naa naꞌan kidan fukun, tan Maromak taꞌe naksala bei Yakob kidan fukun baa oras nia. ");
INSERT INTO tet_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Loron nia, Yakob naree Esau lolok mai no niakaan ema naꞌin atus haat. Hotu, Yakob faꞌe oan sia, foo baa inan ida-idak. ");
INSERT INTO tet_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Nahulin feen kiꞌik rua no oan sia laꞌo iha oin. Foin, Lea no oan sia. Hotu, Rahel no oan Yusuf ikus basuk. ");
INSERT INTO tet_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakob laꞌo iha oin basuk. Kreꞌis baa maun, nia nakniꞌa nodi sudur isin hitu. ");
INSERT INTO tet_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Naree alin, Esau moos nalai baa nasoru. Hotu nakoꞌak deꞌi nia. Sia rua moos tanis. ");
INSERT INTO tet_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau moos nusu naꞌak, “Feto no oan neꞌe sia hotu-hotu, see?” Yakob nataa naꞌak, “Sia neꞌe, mak Maromak foo baa mau atan, haꞌu neꞌe.” ");
INSERT INTO tet_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hotu, Yakob feen kiꞌik sia no oan sia, mai sudur baa Esau. ");
INSERT INTO tet_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Hotu, Lea no oan sia mai sudur baa Esau. Ikus basuk, Yusuf no inan Rahel, mai sudur baa. ");
INSERT INTO tet_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Hotu, Esau nusu naꞌak “Bibi no karau mak o solok ohin nia, atu halo baa saa?” Yakob nataa naꞌak, “Nuneꞌe mau! Haꞌu kfoo baa mau, nebee mau simu ami nodi laran maluak.” ");
INSERT INTO tet_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mais Esau dale naꞌak, “Ali Yakob! Haꞌukaan sasoin moos waꞌin. Lalika foo tenik sa-saa baa haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakob nataa naꞌak, “Keta nunia, mau! Mau musti simu, atu dadi baa tadak naꞌak mau simu haꞌu nodi liman rua. Tan oras haꞌu karee mau nanasa ohin nia, hanesan haꞌu karee Maromak mak nanasa no hꞌau. ");
INSERT INTO tet_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Dadi, haꞌu kusu no kakneter, nebee mau simu buat mak la no folin neꞌe sia. Maromak diꞌak liu resik baa haꞌu tiꞌan. Nia foo sa-saa hotu-hotu, mak haꞌu kbuka.” Yakob namaus Esau nohuun nunia, toꞌo Esau moos simu. ");
INSERT INTO tet_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hotu Esau naꞌak, “Kalo nunia, hadiꞌa aan laꞌo ona! Haꞌu ko kela emi baa.” ");
INSERT INTO tet_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mais Yakob nataa naꞌak, “Lalika mau! Mau naꞌin naree baa! Oan sia sei kiꞌik, la bele laꞌo lai-lais. Bibi no karau mak foin nahoa sia moos waꞌin. Kalo seten sia laꞌo lai-lais, loron ida dei sia bele mate mohu. ");
INSERT INTO tet_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Diꞌak liu, mau sia uluk ona. Ami tuir nai-naik. Ami toꞌo tiꞌan, foin haꞌu kmai karee mau iha Seir.” ");
INSERT INTO tet_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Rona Yakob dale nunia, Esau katak naꞌak, “Kalo nunia, haꞌu kela klosan balu atu no nela emi baa.” Mais Yakob nataa naꞌak, “Mau lalika hakole aan! Surak mau simu haꞌu dei, toꞌo tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Rona nunia, Esau laꞌo nela sia, fila baa Seir. ");
INSERT INTO tet_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mais Yakob la baa Seir. Nia baa fatin ida seluk, naran Sukot. Iha nebaa, nia nariik uma hein heik nodi nalo laluꞌan bodik bibi no karau sia. Tan nia nariik uma hein heik iha nia, ema nanaran fatin nia naꞌak Sukot. (Naran sukot lia isin naꞌak ‘uma hein heik’.) ");
INSERT INTO tet_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Nosi ikus, Yakob sia moos lori baa leo Sikem iha rai Kanaꞌan. Hodi nunia, sia laꞌo no dame nosi Padan-Aram toꞌo Kanaꞌan. Hotu, sia nariik batane kreꞌis baa leo Sikem. ");
INSERT INTO tet_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Rai mak Yakob nariik batane fatik nia, nia sosa nola nosi Hemor, mak Sikem aman. Nia selu kotu nodi osan murak tomak atus ida. ");
INSERT INTO tet_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nia moos nada fatuk, nalo taroman iha nia. Hotu, nia nanaran fatin nia, El-Elohe-Israꞌel. Lia isin naꞌak ‘Maromak mak Israꞌel loꞌu-sudur baa’. ");
INSERT INTO tet_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Baa oras nia, Yakob no Lea oan feto Dina, boot tiꞌan. Dala ida, Dina baa nasoru mamaluk feto sia iha rai nia. ");
INSERT INTO tet_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Rai nia naꞌin, naran Hemor. Hemor nia, nosi ema hunun Hewi. Niakaan oan mane, naran Sikem. Oras Sikem naree Dina, nia lemas nola, nalo lia kfoꞌer no nia. ");
INSERT INTO tet_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikem neon monu baa Dina toꞌo nakara basuk. Nia dale namaus Dina, nebee simu nia. ");
INSERT INTO tet_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Nia moos katak baa aman naꞌak, “Ama! Tulun tama musu Dina, nebee kalo baa haꞌukaan feen.” ");
INSERT INTO tet_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","La kleur, Yakob rona naꞌak ema nalo lia kfoꞌer no oan feto. Nia no-nook dei, tan oan mane sia sei daka bibi iha hae molik. Nia sei nein sia fila mai. ");
INSERT INTO tet_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Baa oras nia moos, Sikem no aman Hemor mai nasoru Yakob atu tama nusu Dina. ");
INSERT INTO tet_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Oras sia sei dale, Yakob oan sia fila mai. Sia rona Sikem nalo lia kfoꞌer tiꞌan no siakaan feton, sia laran moras nodi krakat naꞌak, “Lia nuneꞌe la bele kona baa Yakob familin! Ita la bele simu ema hahalok aat nuneꞌe.” ");
INSERT INTO tet_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Mais Hemor namaus tenik Yakob no oan sia naꞌak, “Maluk Yakob! Haꞌukaan oan Sikem beer tebe-tebes baa maluk oan feto. Dadi, haꞌu kusu nebee foo leet baa haꞌukaan oan nola nia. ");
INSERT INTO tet_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kalo bele, itakaan oan sia nola malu. Emikaan oan mane sia nola amikaan oan feto sia! Amikaan oan mane sia nola emikaan oan feto sia. ");
INSERT INTO tet_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Nebee emi tuur ho ami iha neꞌe. Emi naꞌin boi duꞌuk, hakara tuur iha nabee dei. Hotu, emi bele buka moris hodi hetan sasoin iha nia.” ");
INSERT INTO tet_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Hotu, Sikem dale no Dina aman no maun sia naꞌak, “Emi hakara saa dei, haꞌu ktuir. Emi tate osan taka odamatan no husu folin hira moos, haꞌu kselu. Surak emi foo leet baa haꞌu kola Dina.” ");
INSERT INTO tet_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yakob oan mane sia hirus tan Sikem nalo lia kfoꞌer no siakaan feton Dina tiꞌan. Hotu, sia nataa asufanu baa Sikem no aman Hemor ");
INSERT INTO tet_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","naꞌak, “Ami la bele latan amikaan feton baa ema mak la namane aan! Lia nia namoe ami! ");
INSERT INTO tet_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mais, dalan sasain nuneꞌe: emikaan mane hotu-hotu, kiꞌik-boot, musti hamane aan nuꞌu ami. ");
INSERT INTO tet_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kalo emi halo nunia tiꞌan, foin ita bele hola malu. Ami moos bele tuur hamutuk ho emi, nebee ita dadi ema klubun ida. ");
INSERT INTO tet_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mais kalo emi la tuir amikaan hakara neꞌe hodi la hamane aan, ami hola hikar amikaan feton, hotu ami laꞌo sai hosi rai neꞌe.” ");
INSERT INTO tet_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Rona nola nunia, Hemor no Sikem moos simu. ");
INSERT INTO tet_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sikem la terus nein ona, tan nia beer Dina liu resik tiꞌan. Ema iha rai nia moos, nakneter Sikem. ");
INSERT INTO tet_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Dadi, Hemor no Sikem baa kedan hakotu lia fatin iha leo odamatan nanokar. Sia koꞌa kabuar lia no ema hotu-hotu iha rai nia nodi dale naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Mamaluk sia hotu-hotu! Ema Israꞌel neꞌe sia nakara moris dame no ita. Dadi habusik sia nein namutuk no ita iha neꞌe. Rai neꞌe luan bodik ita hotu-hotu. Ita bele hola siakaan oan feto. Sia moos bele nola itakaan oan feto. ");
INSERT INTO tet_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mais sia nusu loos lia kiꞌik oan ida nosi ita. Neꞌe, mak ita mane hotu-hotu musti hamane aan nuꞌu sia. ");
INSERT INTO tet_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kalo ita hamutuk tiꞌan, nanis siakaan bibi no karau no sasoin hotu-hotu bele dadi baa itakaan. Diꞌak liu ita simu siakaan hakaran. Ita hotu-hotu hamane aan bele-bele! Hakara ka?” ");
INSERT INTO tet_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Rona nola nunia, ema hotu-hotu mak libur malu iha nia, nakara tuir Hemor no Sikem. Mane sia hotu-hotu iha rai nia moos namane aan bele-bele. ");
INSERT INTO tet_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Baa wainrua, oras mane hotu-hotu sei moras tan namane aan, Dina naan Simeon no Lewi losu surik naruk. Sia tama no-nook baa kota laran, noꞌo mane hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Sia moos noꞌo Hemor no Sikem. Hotu, sia dada nodi fila Dina sai nosi Sikem uman. ");
INSERT INTO tet_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Hotu, Yakob oan mane rumak sia tama nadau nola sasoin hotu-hotu iha nia. Sia kanarak, tan ema nalo lia kfoꞌer no siakaan feton. ");
INSERT INTO tet_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Sia nadau nola ema naha uma laran hotu-hotu, nodi nalaꞌo nola bibi no karau hotu-hotu iha hae molik. ");
INSERT INTO tet_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Sia moos nodi feto hotu-hotu no oan sia, no nadau nola naha folin todan hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Oras Yakob natene nola, nia deꞌan Simeon no Lewi naꞌak, “Emi beik saa tiꞌan? Emi hasusar haꞌu dei! Nanis ema Kanaꞌan, ema Peris no ema hotu-hotu iha rai neꞌe atu hirus ita. Sia waꞌin liu ita. Kalo sia nababu ita, ita dodok welon.” ");
INSERT INTO tet_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mais sia nataa nodi krakat naꞌak, “Ama! La kona basuk ami habusik sia nalo amikaan feton nuꞌu feto aat!” ");
INSERT INTO tet_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hotu, Maromak katak baa Yakob naꞌak, “Haꞌu neꞌe, Maromak mak natadu aan baa o, baa oras o malai mosi okaan maun Esau. Oras neꞌe, lori baa Betel ona. Toꞌo nebaa, mariik taroman bodik Haꞌu. Hotu, tuur iha nia.” ");
INSERT INTO tet_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Tan lia nia, Yakob katak baa niakaan ema uma laran sia naꞌak, “Oras neꞌe, ita lori baa Betel. Uluk, oras haꞌu iha susar laran, Maromak tulun haꞌu iha nia. Haꞌu kakara kariik taroman ida iha nia. Tan baa nia, emi musti soe emikaan aiꞌoi lulik sia hotu-hotu. Hamoos isin lolon, foin seluk tais, tan ita atu loꞌu-sudur baa Maromak.” ");
INSERT INTO tet_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Rona nola nunia, Yakob ema uma laran sia moos latan kedan siakaan aiꞌoi lulik no karabu sia hotu-hotu. Hotu, Yakob nakoi naha nia sia iha ai huun boot ida ohak kreꞌis leo Sikem. ");
INSERT INTO tet_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Oras Yakob sia laꞌo lolok nosi Sikem, Maromak nalo nataꞌuk ema iha rai nia, toꞌo sia la naksakar aan nalo aat baa Yakob sia. ");
INSERT INTO tet_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Hodi nunia, Yakob no niakaan ema sia, laꞌo no dame toꞌo leo Betel (mak uluk naran ‘Lus’) iha rai Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Toꞌo nia, Yakob nariik taroman. Nia nanaran fatin nia El Betel, tan lia isin naꞌak, ‘Maromak iha Betel’. Uluk Maromak natadu aan baa Yakob iha nia, baa oras nia nalai nosi maun. ");
INSERT INTO tet_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kreꞌis leo Betel, no ai huun boot ida naran Alon Bakut. Lia isin naꞌak, ‘ai tanis hadeꞌun aan’. Ai naran nunia, tan Ribka inan haliku naran Debora, mate, hotu sia nakoi nia iha ai nia ohak. ");
INSERT INTO tet_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakob fila nikar nosi Padan-Aram, Maromak natadu aan tenik nodi natuun matak-malirin baa nia ");
INSERT INTO tet_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","naꞌak, “Nahuu baa oras neꞌe, okaan naran lahoos Yakob tenik. Haꞌu ktau naran foun baa o kaꞌak, Israꞌel. ");
INSERT INTO tet_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Haꞌu neꞌe, Maromak mak Beran Kaliuk. O atu metan husar-binan waꞌin lear! Ema klubun sia atu mosu mai nosi okaan husar-binan. O moos mahoris naꞌin lear. ");
INSERT INTO tet_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Rai mak Haꞌu klatan baa okaan bei Abraham no okaan aman Isak nia, oras neꞌe Haꞌu klatan baa o mo okaan husar-binan sia.” ");
INSERT INTO tet_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Rona notu nunia, Yakob nariik fatuk ida iha fatin nia, dadi tadak ida, nebee nodi nanoin Maromak mamenon. Nia fui kedan anggor ween no mina morin iha fatuk nia leten, nodi loꞌu-sudur baa Maromak. ");
INSERT INTO tet_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakob nanaran fatin nia, Betel. ");
INSERT INTO tet_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Hotu, Yakob sia laꞌo nela Betel. Oras nia Rahel koꞌus. Oras sia sei dook nosi leo Efrata (mak oras neꞌe, ema temi naꞌak Betlehem), Rahel loron nahoris moos toꞌo mai. Mais nia nahoris susar, ");
INSERT INTO tet_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","toꞌo makaer mii katak baa nia naꞌak, “Ina Rahel! Makbiit neon! Ina netan oan mane ida tenik!” ");
INSERT INTO tet_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Masik Rahel nawan kreꞌis atu kotu moos, nia sei tau nela naran baa oa nia naꞌak, Ben-Oni (tan ben-oni lia isin naꞌak ‘oa susar’). Hotu, nawan moos kotu. Mais Yakob nanaran oan nia, Benyamin (tan benyamin lia isin naꞌak ‘oa liman kwana’). ");
INSERT INTO tet_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Hotu, sia nakoi Rahel iha dalan tehen baa Efrata (mak oras neꞌe, ema temi naꞌak Betlehem). ");
INSERT INTO tet_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nakoi tiꞌan, Yakob nariik fatuk rate ida iha nia. Toꞌo oras neꞌe moos, Rahel niakaan fatuk rate nia sei nafati. ");
INSERT INTO tet_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nunia hotu, Yakob lori baa-mai bei-beik. Dala ida, nia nariik batane iha tetu Eder sorin. ");
INSERT INTO tet_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Oras sia nein iha nia, Ruben toba no aman feen kiꞌik, Bilha. Yakob moos natene nola lia nia. Yakob oan mane sia, naꞌin sanulu resin rua. ");
INSERT INTO tet_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea oan sia, Ruben (mak Yakob oan ulun), Simeon, Lewi, Yahuda, Isaskar no Sebulon. ");
INSERT INTO tet_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel oan sia, Yusuf no Benyamin. ");
INSERT INTO tet_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel ata feto Bilha oan sia, Dan no Naftali. ");
INSERT INTO tet_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Hotu, Lea ata feto Silpa oan sia, Gad no Aser. Yakob netan oan nia sia iha Padan-Aram. ");
INSERT INTO tet_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Hotu, Yakob baa naree aman Isak iha Mamre, kreꞌis baa kota Kiriat Arba (mak oras neꞌe naran Hebron). Uluk, niakaan bei Abraham moos nein iha nia. ");
INSERT INTO tet_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak moris toꞌo otas tinan atus ida walu nulu, foin mate. Hotu, niakaan oan Esau no Yakob nakoi nia. ");
INSERT INTO tet_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Neꞌe mak Esau husar-binan sia. Esau niakaan naran seluk, Edom. ");
INSERT INTO tet_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nia nola feto Kanaꞌan naꞌin rua nalo baa feen. Feto ida, naran Ada. Ada nia, ema Het ida naran Elon oan. Esau feen ida tenik, ema Hewi, naran Oholibama. Oholibama aman, naran Anah. Bein, naran Sibeon. ");
INSERT INTO tet_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau moos nola noo Ismael oan feto ida, naran Basmat. Basmat maun, naran Nebayot. ");
INSERT INTO tet_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau feen Ada nahoris Elifas. Basmat nahoris Rehuel. ");
INSERT INTO tet_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama nahoris Yeus, Yalam no Kora. Esau feen sia nahoris oan neꞌe sia hotu-hotu iha rai Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Dala ida, Esau lori baa rai seluk, dook nosi Yakob. Nodi feen-oan, ema serwisu, bibi no karau no naha hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau sasa aan nosi Yakob, tan bibi no karau no sasoin seluk sia waꞌin liu resik toꞌo sia moris seti malu iha rai nia. ");
INSERT INTO tet_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tan lia nia, Esau (mak Edom), baa tuur iha rai foho iha Seir. ");
INSERT INTO tet_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Neꞌe, Esau husar-binan, mak ema temi naꞌak, ‘ema Edom’. Sia tuur iha rai foho iha Seir. ");
INSERT INTO tet_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau feen Ada nahoris oan mane ida, naran Elifas. Elifas netan oan mane naꞌin lima mak: Teman, Omar, Sefo, Gatam no Kenas. Elifas feen kiꞌik, naran Timna. Nia nahoris oan mane ida naran Amalek. Esau feen Basmat nahoris oan mane ida naran Rehuel. Hotu, Rehuel netan oan mane naꞌin haat mak: Nahat, Sera, Syama no Misa. ");
INSERT INTO tet_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau feen Oholibama, Anah oan, mak Sibeon oa bein nia. Nahoris oan mane naꞌin tolu, mak: Yeus, Yalam no Kora. ");
INSERT INTO tet_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau oan no bein oan sia sasa faꞌe malu, dadi ema hunun waꞌin, ida-idak no duꞌuk fukun. Esau oan ulun, Elifas oan sia, dadi baa fukun Teman, fukun Omar, fukun Sefo, fukun Kenas, fukun Kora, fukun Gatam no fukun Amalek. Sia hotu-hotu nia, mak Esau no feen Ada husar-binan. ");
INSERT INTO tet_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau oan Rehuel oan sia, dadi fukun Nahat, fukun Sera, fukun Syama no fukun Misa. Sia hotu-hotu nia, mak Esau no feen Basmat husar-binan. ");
INSERT INTO tet_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau no feen Oholibama oan sia, dadi fukun Yeus, fukun Yalam no fukun Kora. ");
INSERT INTO tet_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ema hunun nia sia hotu-hotu, mak Esau husar-binan. ");
INSERT INTO tet_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Iha fatin nia moos noo ema Hori ida, naran Seir. Niakaan oan sia sasa faꞌe malu, dadi baa ema hunun waꞌin, ida-idak no duꞌuk fukun. Oan sia dadi baa fukun Lotan, fukun Sobal, fukun Sibeon, fukun Anah, fukun Dison, fukun Eser no fukun Disan. ");
INSERT INTO tet_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan oan sia mak Hori no Heman. (Lotan feton mak Timna). ");
INSERT INTO tet_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal oan sia mak Alwan, Manahat, Ebal, Sefo no Onam. ");
INSERT INTO tet_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon oan sia mak Aya no Anah. Anah nia mak netan nola wee matan manas iha raihenek raat, oras naliku aman kuda keledai sia. ");
INSERT INTO tet_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah oan feto mak Oholibama. No oan mane mak Dison. Dison oan mak Hemdan, Esban, Yitran no Keran. ");
INSERT INTO tet_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser oan mak Bilhan, Saꞌawan, no Akan. ");
INSERT INTO tet_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan oan mak Us no Aran. ");
INSERT INTO tet_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Fukun ema hunun Hori sia mak neꞌe: Lotan, Sobal, Sibeon, Anah, Dison, Eser no Disan. Sia hotu-hotu nein iha rai Seir. ");
INSERT INTO tet_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Rai Israꞌel sei dauk no naꞌin, rai Edom no naꞌin tiꞌan. Naran sia tuir malu, nuneꞌe: ");
INSERT INTO tet_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Sia foti Beor oan Bela, dadi naꞌin kota Dinhaba. ");
INSERT INTO tet_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela mate, Yobab seluk nia. Yobab aman, naran Sera nosi leo Bosra. ");
INSERT INTO tet_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab mate, Husam seluk. Husam nia, nosi ema Teman rain. ");
INSERT INTO tet_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam mate, Hadad seluk. Hadad aman, naran Bedad, nosi leo Awit. (Hadad neꞌe, mak natoba nola ema Midian, baa oras sia natuda iha Moab). ");
INSERT INTO tet_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad mate, Samla seluk. Samla nia, nosi leo Masreka. ");
INSERT INTO tet_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla mate, Saul seluk. Saul nia, nosi leo Rehobot iha mota diꞌin. ");
INSERT INTO tet_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul mate, Baꞌal-Hanan seluk. Baꞌal-Hanan aman, Akbor. ");
INSERT INTO tet_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baꞌal-Hanan mate, Hadar seluk. Hadar nia, nosi leo Pahu. Niakaan feen naran Mehetabel. Mehetabel aman, naran Matret. Bein, naran Mesahab. ");
INSERT INTO tet_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Fukun nosi Esau sia, mak neꞌe: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel no Iram. Sia ida-idak nanaran rai, tuir siakaan naran duꞌuk. Nunia dei, Esau husar-binan mak ema Edom. ");
INSERT INTO tet_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Lia neꞌe kona baa Yakob no niakaan husar-binan sia. Hori hirak nia, Yakob neꞌe fila baa tuur iha rai Kanaꞌan. Rai nia, mak niakaan aman Isak tuur fatin hori uluk kedan. ");
INSERT INTO tet_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Yakob oan mane ida nosi feen Rahel, naran Yusuf. Yusuf otas tinan sanulu resin hitu, sura loron nia no maun sia baa daka bibi no bibi malae sia. Yusuf maun sia, mak oan nosi Yakob feen kiꞌik sia, mak Bilha no Silpa. Yusuf neꞌe nasaꞌe lia nanis baa aman, tan maun siakaan hahalok. ");
INSERT INTO tet_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Baa oras Yusuf moris, Yakob katuas tiꞌan. Tan baa nia, Yakob dadobe Yusuf liu nosi oan seluk sia. Dala ida Yakob nalo nola faru klobor kabaas ida bodik Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Maun sia naree siakaan aman dadobe Yusuf liu resik, sia rai hirus no Yusuf, toꞌo sia la noꞌuk dale diꞌa-diꞌak tenik no nia. ");
INSERT INTO tet_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Baa kalan ida, Yusuf meꞌi. Nia nadeer mai, nia nalore meꞌi nia baa maun sia naꞌak, “Mau sia! Rona lai! Haꞌu kmeꞌi kaꞌak ita hotu-hotu hoꞌi kesi hare gandum iha toꞌos laran. Haꞌukaan hare gandum mak kesi tiꞌan, nariik lo-loos. Mais emikaan sia, nariik satan nola no sudur baa haꞌukaan.” Rona nola nunia, maun sia hetak hirus nia. ");
INSERT INTO tet_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Sia deꞌan Yusuf naꞌak, “O maneo, o neꞌe naꞌin ka? O atu ukun ami ka?” Sia hirus Yusuf liu resik, tan nia nalore meꞌi nia. ");
INSERT INTO tet_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Baa kalan ida seluk, Yusuf meꞌi tenik. Hotu, nia nalore baa maun sia naꞌak, “Mau sia! Haꞌu kmeꞌi tenik! Haꞌu karee loro, no fulan no fitun sanulu resin ida. Buat nia sia hotu-hotu sudur baa haꞌu.” ");
INSERT INTO tet_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Dale baa maun sia tiꞌan, Yusuf baa katak lia meꞌi nia baa aman. Mais aman deꞌan makaꞌas nia naꞌak, “Meꞌi saa mak nia! O maneo, haꞌu ko okaan inan no okaan maun-alin sia atu mai deꞌi o ain ka? O neꞌe, liu resik!” ");
INSERT INTO tet_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tan lia nia, Yusuf maun sia hirus nia tebe-tebes. Mais aman sura bei-beik meꞌi nia sia isin iha neon laran. ");
INSERT INTO tet_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Baa loron ida, Yusuf maun sia nalaꞌo aman niakaan bibi no bibi malae sia, toꞌo kreꞌis leo Sikem. ");
INSERT INTO tet_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","La kleur falik, Yusuf aman dale naꞌak, “Yusuf! Okaan maun sia naliku bibi no bibi malae sia kreꞌis baa Sikem. O madiꞌa aan baa maree sia lai!” Rona aman dale nunia, Yusuf nataa naꞌak, “Diꞌak, ama!” ");
INSERT INTO tet_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Loron hira siku, aman naruka Yusuf naꞌak, “Oras neꞌe o baa maree okaan maun sia no bibi no bibi malae sia. Maree sia hotu, fila mai katak haꞌu.” Rona nola nunia, Yusuf moos baa. Nia laꞌo nosi rai Hebron, toꞌo leo Sikem. ");
INSERT INTO tet_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Toꞌo nebaa, nia buka maun sia nasirin hae molik iha nia. Hotu, nia nasoru ema ida. Ema nia nusu naꞌak, “O moꞌi buka saa?” ");
INSERT INTO tet_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuf nataa naꞌak, “Haꞌu koꞌi buka haꞌukaan maun sia! Sia nodi bibi no bibi malae sia, buka hae kreꞌis iha neꞌe. Ama naree sia ka?” ");
INSERT INTO tet_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Hotu, ema nia katak naꞌak, “Sia la iha neꞌe tiꞌan! Haꞌu krona sia katak naꞌak sia atu baa kreꞌis leo Dotan.” Rona nola nunia, Yusuf baa tuir maun sia iha Dotan. Sei dook, nia naree maun sia tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Maun sia moos naree nola Yusuf tiꞌan. Hotu, sia kabuar lia fuan atu noꞌo nia. ");
INSERT INTO tet_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Sia katak baa malu naꞌak, “Mana lai! Meꞌi ulun mai tiꞌan! ");
INSERT INTO tet_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mai ita hoꞌo nia ona! Hoꞌo tiꞌan, ita soe baa wee knuuk aat nia laran! Hotu, ita katak baa ama haꞌak, asu fuik folan nola nia tiꞌan! Foin ita haree, meꞌi nia sia nunabee!” ");
INSERT INTO tet_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rona nola nunia, Yusuf maun Ruben buka dalan sori Yusuf. Nia katak baa alin sia naꞌak, “Ita keta hoꞌo nia! ");
INSERT INTO tet_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Diꞌak liu, ita soe nia baa wee knuuk aat nia, nebee nia naꞌin mate! Surak, ita keta haduar raan! Fatin neꞌe mamuk. Ema nanis la natene!” Maun Ruben dale nunia, tan nia nakara sori no-nook Yusuf nodi naruka fila nikar baa aman. ");
INSERT INTO tet_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusuf toꞌo siakaan oin tiꞌan, maun sia kaer nola nia, nodi kolu nasai faru kabaas nia. ");
INSERT INTO tet_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Hotu, sia dada sarat Yusuf, natama baa wee knuuk aat nia. ");
INSERT INTO tet_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Hotu, sia moos fila baa naa. Baa oras sia sei noꞌi naa, teki-tekis sia naree ema lolok ida moos mai. Ema lolok nia siakaan kuda unta, tula naha, nuꞌu ai raan morin, ai babudun sia, no aitahan oi-oik, atu nodi baa faꞌan. Ema lolok nia, ema Ismael mak mai nosi leo Gilead. Sia laꞌo dalan dook tebes, baa rai Mesir. ");
INSERT INTO tet_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Naree nunia, Yahuda katak baa maun-alin sia naꞌak, “Diꞌak liu, nuneꞌe dei! Ita keta hoꞌo nia! Ita hetan sotir saa? Masik nunabee moos, ita la bele subar niakaan raan! ");
INSERT INTO tet_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Diꞌak liu, ita faꞌan nia baa ema Ismael nia sia! Masik ita halo oin nunabee baa nia moos, nia neꞌe itakaan alin susu! Tan baa nia, ita la bele hahoras nia!” Rona Yahuda dale nunia, sia moos simu. ");
INSERT INTO tet_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Baa oras ema makfaꞌan sa-saa nia sia atu laꞌo liu, Yusuf maun sia dada nasaꞌe nia nosi wee knuuk nia. Sia moos faꞌan nia baa ema Ismael nia sia nodi nola folin osan murak tomak rua nulu. Hotu, ema Ismael sia nola Yusuf, nodi baa rai Mesir. ");
INSERT INTO tet_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Baa oras sia faꞌan Yusuf, maun Ruben la natene. Nia fila baa wee knuuk nia, nia sarebak tebe-tebes, tan la naree Yusuf tiꞌan. Nia lees karin niakaan tais, tan noran susar basuk. ");
INSERT INTO tet_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Hotu nia fila baa alin sia, nodi dale naꞌak, “Adeei! Oa nia la iha wee knuuk nia tiꞌan! Oras neꞌe, haꞌu atu kalo saa tenik?” ");
INSERT INTO tet_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hotu, sia sona noꞌo bibi matan ida. Sia moos nola Yusuf farun kabaas nia, loban baa bibi raan, ");
INSERT INTO tet_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","nodi baa siakaan aman Yakob. Sia katak naꞌak, “Ama! Ami hili hola faru neꞌe! Ama naree kokon! Arumak neꞌe, ali Yusuf farun!” ");
INSERT INTO tet_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Naree nola faru nia, Yakob natene kedan. Nia dale naꞌak, “Adeei! Neꞌe nanis haꞌukaan oan farun. Asu fuik sira karin nia tiꞌan! Adeei! Haꞌukaan oan mate tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakob moos lees karin niakaan faru, seluk nodi tais hene metan, tan nia susar basuk. Nia tanis kleur tebes baa oan Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Masik Yakob oan mane no feto hotu-hotu mai namaus nia moos, la bele. Nia dale naꞌak, “Haꞌu la kanawa tanis toꞌo haꞌu kmate, tan haꞌu la kbele kaluꞌa oan ida neꞌe!” Yakob neon susar bei-beik, tan nia nanoin oan Yusuf mak mate tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yakob sei noran susar nunia, ema mak faꞌan sa-saa nia sia toꞌo Mesir tiꞌan. Hotu, sia faꞌan Yusuf baa ema boot ida, naran Potifar. Ema boot neꞌe, naꞌi Mesir niakaan daka rai ulun. ");
INSERT INTO tet_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yahuda laꞌo nela niakaan maun-alin sia, baa tuur namutuk no niakaan maluk ida naran Hira iha leo Adulam. ");
INSERT INTO tet_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Iha nia, no ema katuas Kanaꞌan ida, naran Syua. Yahuda nakara Syua oan feto ida. Sia rua moos nola malu. Hotu, sia netan oan mane naꞌin hira, moris tuir malu. ");
INSERT INTO tet_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Oan ulun, naran Er. ");
INSERT INTO tet_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Oan nomer rua, naran Onan. ");
INSERT INTO tet_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Oan nomer tolu, naran Syela. Syela sei dauk moris, Yahuda sia lori tiꞌan baa fatin seluk, naran leo Kesib. ");
INSERT INTO tet_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Oan ulun Er boot tiꞌan, Yahuda baa nusu nola feto nurak ida naran Tamar, foo baa Er. Hotu, sia rua nola malu. ");
INSERT INTO tet_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mais Er nia, aat liu resik toꞌo Maromak natuun dinu, nalo nia mate, la noo oan. ");
INSERT INTO tet_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Hotu, Yahuda naruka oan nomer rua naꞌak, “Onan! Okaan maun mate tiꞌan, mais la noo oan! Tuir ema matas siakaan adat, oras neꞌe o musti seluk okaan maun, mola mikar niakaan feen Tamar! Nebee o foo husar-binan bodik okaan maun!” ");
INSERT INTO tet_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan natene nanis adat nia tiꞌan. Mais nia la noꞌuk foo husar-binan bodik maun Er. Tan baa nia, sura oras toba namutuk no Tamar, Onan soe sai niakaan fini nebee Tamar keta koꞌus. ");
INSERT INTO tet_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan niakaan hahalok nia, nalo Maromak krakat basuk, toꞌo Maromak natuun dinu, nalo nia mate. ");
INSERT INTO tet_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yahuda naree nola oan naꞌin rua mate tiꞌan, nia nataꞌuk tan sia ida-idak nola Tamar. Nia naneo naꞌak, kalo oan ikun Syela moos nola Tamar, keta-keta nia moos mate tenik. Tan lia nia, Yahuda katak baa uma naꞌin Tamar naꞌak, “Uma naꞌin! Diꞌak liu o fila mikar baa okaan inan-aman dei ona! Loron ikus, kalo haꞌukaan oan Syela boot tiꞌan, foin o mai mikar nebee emi hola malu.” Rona nola nunia, Tamar moos fila nikar baa inan-aman. ");
INSERT INTO tet_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","La kleur, Yahuda feen moos mate. Nia namuka aan, toꞌo loron susar nia siku liu. Hotu tiꞌan, Nia bolu nola niakaan maluk naran Hira, nebee sia rua baa leo Timna, tan iha fatin nia, ema noꞌi teri bele-bele bibi malae rahun atu faꞌan. ");
INSERT INTO tet_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ema mak natene lia nia, katak baa Tamar naꞌak, “Okaan banin mane baa leo Timna tiꞌan, atu tuir teri bibi malae rahun.” ");
INSERT INTO tet_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Baa oras nia, Yahuda oan ikun Syela boot ona. Mais Tamar natene nanis naꞌak, banin mane la nakara sasudin nia no Syela. Tan lia nia, Tamar naꞌin buka duꞌuk dalan atu netan oan. Nia kolu niakaan tais hene metan, seluk nodi tais kabaas ida. Nia moos nodi tais oan taka ulun no sara oin. Hotu, nia baa tuur iha leo Enaim odamatan nanokar, kona besik baa dalan baa leo Timna. ");
INSERT INTO tet_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Baa oras Yahuda laꞌo tuir odamatan nanokar nia, nia naree feto ida iha nia. Nia naneo naꞌak, arumak feto nia feto aat, tan Tamar natudu ilas, nodi tais kabaas, no taka tenik oin, ");
INSERT INTO tet_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","toꞌo Yahuda la natene naꞌak feto nia, niakaan uma naꞌin. Hotu, nia nareꞌis aan baa feto nia, nodi nusu naꞌak, “Hoi! Kalo haꞌu atu kola o, o musu hira?” Tamar nataa naꞌak, “Loos o dei!” ");
INSERT INTO tet_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Rona nola nunia, Yahuda taa kokon folin naꞌak, “Kalo haꞌu kfoo bibi matan ida baa o, o manoin nunabee?” Tamar moos nataa naꞌak, “Diꞌak ama! Surak latan uluk lai naha kakaer ida baa haꞌu. Toꞌo wainhira ama solok bibi nia mai.” ");
INSERT INTO tet_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Rona nola nunia, Yahuda nataa tenik naꞌak, “Haꞌu kfoo naha kakaer saa baa o?” Tamar nataa nikar naꞌak, “Ama latan baa haꞌu, marak mahoo talin mak ama nahenu nia, no ama knoꞌan.” Rona nola nunia, Yahuda moos latan naha nia sia baa Tamar. Hotu, sia rua moos baa toba namutuk. Hotu tiꞌan, Tamar fila kedan. Toꞌo uma tiꞌan, nia kolu tais kabaas no tais oan nia, hotu natais nikar tais hene metan. Mais Tamar koꞌus tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","La kleur falik, Yahuda nusu tulun baa niakaan maluk naran Hira naꞌak, “O tulun modi bibi neꞌe, foo baa feto aat mak iha leo Enaim nebaa. Hotu musu mola mikar haꞌukaan naha sia mak feto nia kaer tiꞌan.” Rona nola nunia, maluk Hira moos baa. Toꞌo nebaa tiꞌan, nia nusu nodi buka feto nia baa-mai, mais la nasoru kois. ");
INSERT INTO tet_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nia nusu baa ema iha nia sia naꞌak, “Hoi! Emi haree feto aat mak tuur nanis iha odamatan nanokar neꞌe ka lale? Oras neꞌe, nia iha nabee?” Mais sia nataa naꞌak, “Ama! Iha neꞌe la no feto aat!” ");
INSERT INTO tet_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tan baa nia, Hira fila nikar baa Yahuda. Nia katak naꞌak, “Haꞌu la kasoru feto nia. Haꞌu kbuka tebe-tebes, mais ema iha nia sia katak naꞌak, iha fatin nia la no feto aat.” ");
INSERT INTO tet_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Rona nola nunia, Yahuda nataa naꞌak, “Habusik baa nia nola naha nia baa nia! Surak ema keta namoe ita! Haꞌu kakara selu baa nia, mais la hasoru nia!” ");
INSERT INTO tet_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Fulan tolu siku tiꞌan, no ema mai nasaꞌe lia baa Yahuda naꞌak, “Okaan uma naꞌin Tamar nia, nalo aan nuꞌu feto aat tiꞌan. Oras neꞌe, koꞌus tiꞌan!” Rona nola nunia, Yahuda krakat tebe-tebes. Nia naruka ema nia sia naꞌak, “Baa dada hodi feto nia mai! Musti sunu horis nia!” ");
INSERT INTO tet_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Hotu, ema nia sia baa atu dada nola Tamar. Mais Tamar nalore marak no knoꞌan nia. Nia naruka ema nia sia fila katak baa banin naꞌak, “Ama! Ita musti leno kokon naha neꞌe sia lai! Marak no knoꞌan neꞌe naꞌin mak nalo haꞌu koꞌus nuneꞌe!” ");
INSERT INTO tet_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Naree nola naha nia sia, Yahuda moos natene kedan naꞌak, naha nia sia niakaan tebes. Hotu, nia katak naꞌak, “Tebes! Feto nia la sala! Haꞌu mak sala! Haꞌu kmusti sasudin nia no haꞌukaan oan Syela, mais haꞌu la kakara!” Tan lia nia, Yahuda la krakat tiꞌan. Nia moos la toba namutuk tenik no Tamar ona. ");
INSERT INTO tet_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Baa oras Tamar loron nahoris toꞌo mai, nia nahoris oa karuak. ");
INSERT INTO tet_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Oras nahoris, oan ida liman sai uluk. Hotu, makaer mii kesi kabaas mean baa liman nodi katak naꞌak, “Ida neꞌe, mak oan ulun!” ");
INSERT INTO tet_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mais, oan nia dada natama nikar liman. Hotu, niakaan maluk sai, moris uluk. Naree nunia, makaer mii moos katak naꞌak, “Hei, o neꞌe biit tebes! O mesuk aan atu sai uluk!” Hotu makaer mii tau naran baa oan nia, naꞌak Peres (tan lia fuan peres isin naꞌak, ‘mahesuk aan atu sai’). ");
INSERT INTO tet_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Peres sai tiꞌan, foin alin mak netan tiꞌan kabaas mean nia sai mai. Sia nanaran oan nia, naꞌak Sera (tan lia fuan sera isin naꞌak, ‘mean lakan’). ");
INSERT INTO tet_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Hori hirak nia, ema Ismael sia nodi tiꞌan Yusuf baa rai Mesir. Iha rai nia, no ema boot ida naran Potifar. Potifar neꞌe, ulun bodik sondadu hotu-hotu mak daka naꞌi Mesir tofatik. Nia sosa nola Yusuf nosi ema sia, atu nalo baa ata iha uman. Iha uma nia, MAROMAK tulun Yusuf, toꞌo niakaan serwisu sia hotu-hotu laꞌo diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Yusuf ulun Potifar naree niakaan serwisu diꞌak nunia, nia moos natene ona naꞌak, MAROMAK mak nanis tulun Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tan baa nia, Potifar nakara no fiar baa Yusuf, toꞌo foti nia nalo baa klosan ulun iha uman laran. Nia moos fiar baa Yusuf, nebee babilan uman no bein sasoin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tan Yusuf tuur iha Potifar uman, MAROMAK moos natuun matak-malirin baa Potifar, ema Mesir nia. Potifar sasoin uma laran, bein sasoin, toꞌos, no serwisu sia hotu-hotu laꞌo diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tan Yusuf nalaꞌo diꞌa-diꞌak serwisu sia hotu-hotu, Potifar la nanoin sa-saa ona. Nia natene loos naa dei. Baa oras nia, Yusuf isin lolon kabaas tebe-tebes. ");
INSERT INTO tet_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Nia tuur iha nebaa sei la kleur falik, Potifar feen neon monu baa nia. Tan baa nia, feto neꞌe tene Yusuf nebee sia rua toba namutuk. ");
INSERT INTO tet_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mais Yusuf la noꞌuk. Nia katak baa feto nia naꞌak, “Keta nunia, ina! Haꞌukaan ama boot Potifar foo tiꞌan beran baa haꞌu atu kodi kaliku sa-saa hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Iha uma neꞌe, la no ema ida tenik mak netan beran liu haꞌu, tan ama boot naruka haꞌu tiꞌan atu kaliku sa-saa hotu-hotu. Hela mesan ina dei mak haꞌu la kbele kaliku. Oin nunabee, haꞌu kbele kalo hahalok aat nunia! Hahalok nia moos sakar Maromak hakaran!” ");
INSERT INTO tet_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Masik Yusuf la noꞌuk nalo aat nunia moos, sura loron Potifar feen tene Yusuf bei-beik. Yusuf moos dudu bei-beik. ");
INSERT INTO tet_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Baa loron ida Yusuf tama baa uma laran atu serwisu. Baa oras nia, la no ema seluk iha uma. ");
INSERT INTO tet_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Natene nola nunia, Potifar feen kaer nola Yusuf farun liman. Hotu, nia dada seten Yusuf nodi naꞌak, “Mai ona! Oras neꞌe ita rua mesan tiꞌan! Mai ita baa toba ona!” Mais Yusuf la noꞌuk. Nia nakfodak sai toꞌo farun nakolu. Hotu, nia nalai sai. Mais feto nia kaer natoos Yusuf farun. ");
INSERT INTO tet_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Oras Potifar feen naree naꞌak Yusuf nalai nela farun, ");
INSERT INTO tet_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","nia bolu ema serwisu sia nodi katak naꞌak, “Emi mai haree lai! Ohin nia, mane Ibrani nia tama baa haꞌukaan keꞌan laran! Nia atu nalo aat no haꞌu, mais haꞌu kahii makaꞌas, toꞌo nia nalai nela niakaan faru neꞌe! Haꞌukaan laꞌen nodi ema notar lalek neꞌe mai, atu namoe ita dei!” ");
INSERT INTO tet_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potifar feen moos rai Yusuf farun nia, toꞌo laꞌen fila mai. ");
INSERT INTO tet_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Laꞌen fila mai tiꞌan, feen nasaꞌe lia naꞌak, “Ama! Ema Ibrani mak ama nodi mai tiꞌan nia, foin da-dauk neꞌe tama baa haꞌukaan keꞌan laran atu nalo lia kfoꞌer no haꞌu! ");
INSERT INTO tet_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mais haꞌu kakrake makaꞌas, kodi bolu ema! Hotu mane nia nalai nela niakaan faru neꞌe!” ");
INSERT INTO tet_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Rona tiꞌan feen dale nunia, Potifar krakat tebe-tebes. ");
INSERT INTO tet_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Nia naruka ema baa kohi nola Yusuf. Hotu, sia natama Yusuf baa naꞌi Mesir niakaan bui. ");
INSERT INTO tet_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mais MAROMAK la naluꞌa Yusuf. Nia tulun nima-nimak, toꞌo bui ulun moos nakara Yusuf tebe-tebes, ");
INSERT INTO tet_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","no fiar baa Yusuf. Nia latan beran baa Yusuf atu naliku ema bui sia hotu-hotu, no nalaꞌok serwisu hotu-hotu iha nia. ");
INSERT INTO tet_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tan Naꞌi Maromak tulun Yusuf nunia, serwisu hotu-hotu iha bui nia laꞌo diꞌa-diꞌak, toꞌo bui ulun moos la nanoin sa-saa ona iha bui nia. ");
INSERT INTO tet_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Iha bui laran nia no klosan ulun naꞌin rua mak kaer serwisu iha naꞌi Mesir tofatik. Klosan ida naliku naꞌin hemun, ida tenik naliku naꞌin tubi. Dala ida, ama naꞌi nahibu sia, hotu natama sia baa bui. Tan lia nia, sia rua namutuk fatin ida no Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Bui ulun naruka Yusuf naliku sia tinan ida-rua tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Baa kalan ida, klosan rua nia meꞌi. Ida-idak netan meꞌi duꞌuk. Meꞌi isin moos se-seluk. ");
INSERT INTO tet_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Seisawan, oras Yusuf mai baa sia, nia naree siakaan oin mara loos tan noran susar. ");
INSERT INTO tet_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Naree nunia, Yusuf nusu naꞌak, “Tan saa ohin loron neꞌe, emi oin mara nunia?” ");
INSERT INTO tet_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Sia moos nataa naꞌak, “Hori fonin ami hetan meꞌi, mais la noo mak bele nalore meꞌi nia isin!” Hotu Yusuf dale naꞌak, “La no ema ida mak natene meꞌi isin. Maromak mesan mak natene. Emi dale kokon meꞌi nia lai, foin haꞌu kamulak kodi kusu meꞌi isin baa Maromak.” ");
INSERT INTO tet_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Rona Yusuf dale nunia, klosan mak naliku naꞌin hemun dale naꞌak, “Nuneꞌe! Iha haꞌukaan meꞌi laran, haꞌu karee ai anggor huun ida. ");
INSERT INTO tet_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ai anggor nia nasoru tolu. Ai nia nataha kedan, nafuna kedan, nasare kedan no nafua toꞌo naktasak. ");
INSERT INTO tet_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Iha meꞌi nia moos, haꞌu kaer ama naꞌi fatik hemun. Haꞌu moos kola anggor fuan sia, kois ween baa ama naꞌi fatik hemun nia. Hotu, haꞌu katetu anggor ween nia bodik ama naꞌi nalamak.” ");
INSERT INTO tet_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Rona nola nunia, Yusuf moos katak naꞌak, “Ama! Meꞌi nia malorek nuneꞌe: ai sorun tolu nia naꞌak, loron tolu. ");
INSERT INTO tet_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Iha loron tolu neꞌe laran, ama naꞌi atu nasai ama nosi bui neꞌe. Hotu, nia atu foti nikar ama, dadi baa ulun mak babilan hemun, hanesan uluk. ");
INSERT INTO tet_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kalo ama netan sotir diꞌak tiꞌan nunia, ama keta naluꞌa haꞌu! Kalo ama nadomi haꞌu, ama tulun katak baa ama naꞌi, nebee nia moos nasai haꞌu nosi fatin neꞌe! ");
INSERT INTO tet_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tuir lia loos, sia nokbiit nanaꞌo nola haꞌu nosi rai ema Ibrani. Iha rai neꞌe moos, haꞌu la kalo sala saa ida. Mais teki-tekis, sia natama haꞌu baa bui laran neꞌe, nuꞌu haꞌu neꞌe ema aat.” ");
INSERT INTO tet_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Rona tiꞌan meꞌi isin kabaas nunia, klosan mak babilan naꞌin tubi nia moos dale baa Yusuf naꞌak, “Ali! Haꞌu moos meꞌi kaꞌak, haꞌu ktutur tetek koꞌe tolu! ");
INSERT INTO tet_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Iha koꞌe mak leten basuk laran, no naꞌi niakaan tubi oi-oik. Mais manu ai leten sia mai tutu karin tubi nia nosi koꞌe laran iha haꞌukaan ulun.” ");
INSERT INTO tet_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Rona nola nunia, Yusuf moos nataa naꞌak, “Ama meꞌin nia, nuneꞌe: koꞌe tolu nia moos naꞌak, loron tolu. ");
INSERT INTO tet_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Iha loron tolu neꞌe laran, ama naꞌi atu naruka ema taa kotu ama ulun. Hotu, sia nisa ama isin baa ai riin ida. Manu ai leten sia moos atu mai tutu karin ama isin.” ");
INSERT INTO tet_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Nunia dei, meꞌi isin mak Yusuf katak baa klosan rua nia sia. Loron tolu nia, kona baa naꞌin loron moris. Hotu, naꞌin nalo dahur nodi namata ema boot iha rai nia. Nia moos naruka ema baa nola klosan naꞌin rua nia nosi bui laran. ");
INSERT INTO tet_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nasai nola tiꞌan, ama naꞌin foti nikar klosan mak naliku hemun, nebee babilan nikar naꞌin hemun. ");
INSERT INTO tet_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mais klosan mak babilan naꞌin tubi, ama naꞌi naruka taa kotu ulun. Hotu sia nisa isin baa ai riin. Lia neꞌe kona besik tuir saa mak Yusuf nalore kedan tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Nunia tiꞌan, klosan mak naliku naꞌin hemun la nanoin tenik Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tinan rua liu tiꞌan, naꞌi Mesir moos meꞌi. Nia meꞌi naꞌak, nia nariik iha mota Nil tehen. ");
INSERT INTO tet_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Teki-tekis naree karau baka matan hitu. Karau nia sia bokur no leen tebes. Sia sai nosi mota atu naa hae. ");
INSERT INTO tet_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Hotu, karau baka matan hitu seluk sai mai nosi mota. Karau nia sia rekas, hela mesan ruin. Sia nariik kreꞌis baa karau bokur sia. ");
INSERT INTO tet_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","La oras, karau rekas sia folan nola karau bokur sia hotu-hotu. Naree nunia, naꞌin sarebak, hotu naktekir. ");
INSERT INTO tet_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Naktekir la kleur, naꞌin toba nikar. Hotu, nia meꞌi tenik naꞌak, nia naree hare fulin hitu mak isin makonuk. Hare fulin nia sia tubu nosi hare kain boꞌas ida. ");
INSERT INTO tet_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hotu, nia naree tenik hare abas fulin hitu mak naklaik tiꞌan, tan kona anin manas. ");
INSERT INTO tet_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Teki-tekis hare abas nia sia folan nola hare mahoo isin makonuk sia. Naree nunia, naꞌin sarebak, hotu naktekir. Foin nia natene naꞌak, nia meꞌi tenik. ");
INSERT INTO tet_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Baa seisawan nia, naꞌin noran la diꞌak. Nia naruka klosan sia baa bolu nola ema makdook no ema matenek sia hotu-hotu iha rai Mesir. Sia mai hotu tiꞌan, naꞌin moos katak meꞌi nia. Mais la no mak bele nalore meꞌi nia isin baa nia. ");
INSERT INTO tet_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Rona lia nia, klosan ulun mak babilan naꞌin hemun foin nanoin nola Yusuf. Hotu nia katak baa naꞌin naꞌak, “Ama naꞌi! Haꞌu kmusti katak sain haꞌukaan salan! ");
INSERT INTO tet_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Uluk, ama naꞌi krakat haꞌu ko haꞌukaan maluk, hotu ama natama ami baa bui laran. ");
INSERT INTO tet_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Iha nia, kalan ida ami naꞌin rua moos meꞌi. Ida-idak netan meꞌi se-seluk. ");
INSERT INTO tet_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Iha bui laran nia, no ema Ibrani nurak ida, mak Potifar atan. Ami katak meꞌi baa nia. Hotu, nia nalore. ");
INSERT INTO tet_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tuir meꞌi nia, foin ama foti nikar haꞌu. Mais haꞌukaan maluk netan ukun mate. Hahalok nia sia hotu-hotu kona besik baa saa mak ema Ibrani nalore nia!” ");
INSERT INTO tet_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Rona nola nunia, naꞌin naruka kedan klosan sia lai-lais baa nola Yusuf nosi bui laran. Sai nosi bui, Yusuf koi timi rahuk no nadiꞌa aan atu baa nataa ama naꞌi. ");
INSERT INTO tet_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Toꞌo baa, naꞌin dale baa Yusuf naꞌak, “Hei, lawarik! Haꞌu ko meꞌi ida, mais la no ema mak bele nalore meꞌi nia isin! Mais ema katak baa haꞌu naꞌak, o neꞌe bele!” ");
INSERT INTO tet_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Rona nola nunia, Yusuf nataa naꞌak, “Ama naꞌi! Haꞌu moos la katene sa-saa! Maromak mesan mak bele nalore meꞌi isin! Nia nanis beer nalore lia mak diꞌak bodik ama naꞌi!” ");
INSERT INTO tet_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Hotu naꞌin katak naꞌak, “Iha meꞌi nia, haꞌu koꞌi kariik iha mota Nil tehen. ");
INSERT INTO tet_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Hotu haꞌu karee karau baka mak bokur no leen matan hitu sai nosi mota, hotu naa hae iha mota tehen. ");
INSERT INTO tet_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Hotu karau baka matan hitu seluk moos mai. Mais sia rekas, hela mesan ruin. Iha rai Mesir neꞌe, haꞌu la karee karau rekas oin nunia! ");
INSERT INTO tet_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Mais haꞌu kblaar tebes! Tan teki-tekis, karau rekas matan hitu nia folan nola hotu karau bokur nia sia! ");
INSERT INTO tet_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Masik folan nola nunia moos, karau nia sia rekas nafati dei! Meꞌi tiꞌan, haꞌu moos kaktekir! ");
INSERT INTO tet_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","La kleur, haꞌu ktoba dukur kikar. Hotu haꞌu kmeꞌi tenik. Karee hare isin makonuk fulin hitu, tubu nosi hare kain boꞌas ida. ");
INSERT INTO tet_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Nunia hotu, karee tenik hare abas fulin hitu mak naklaik tiꞌan, tan kona anin manas. ");
INSERT INTO tet_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Mais teki-tekis, hare abas nia sia folan nola hotu hare isin makonuk sia. Hotu, haꞌu kaktekir. Haꞌu moos katak meꞌi nia baa ema matenek sia. Mais la no ema ida moos mak bele nalore meꞌi nia isin!” ");
INSERT INTO tet_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Rona nola meꞌi nia sia, Yusuf katak baa naꞌin naꞌak, “Ama naꞌi! Meꞌi rua nia, isin manesak! Maromak beer katak kedan baa ita boot saa mak Nia atu nalo! ");
INSERT INTO tet_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Meꞌi nia sia isin, nuneꞌe: karau baka bokur matan hitu, no hare isin makonuk fulin hitu nia, neꞌe naꞌak, rai bosu tinan hitu laran. ");
INSERT INTO tet_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nunia moos, karau baka rekas matan hitu, no hare abas fulin hitu nia, neꞌe naꞌak, rai salaen tinan hitu laran. ");
INSERT INTO tet_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Hodi meꞌi nia sia, Maromak katak sain kedan lia mak Nia atu nalo. Lia nia hanesan ohin haꞌu kfoin katak nia. ");
INSERT INTO tet_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ita atu hetan rai bosu tinan hitu laran iha rai Mesir. ");
INSERT INTO tet_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Hotu tiꞌan, foin ita hetan rai salaen tinan hitu laran. Rai salaen nia boot tebes, toꞌo la no haan tenik iha rai Mesir tomak. Ema hotu-hotu salaen mate, toꞌo la nanoin tenik rai bosu uluk nia. ");
INSERT INTO tet_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Tan ama naꞌi meꞌi rua nia isin manesak, neꞌe naꞌak, Maromak nakotu kedan tiꞌan atu nalaꞌok tuir meꞌi nia sia. La kleur, saa mak Nia nakotu tiꞌan nia, nanis dadi. ");
INSERT INTO tet_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tan lia nia, haꞌu kusu baa ama naꞌi, nuneꞌe: Diꞌak liu, ama foti nola ema matenek ida mak bele naliku sa-saa nalo diꞌak. Foti hotu, foo beran baa nia nebee nodi babilan rai Mesir neꞌe diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Oras rai bosu tinan hitu nia, diꞌak liu, ama foti tenik ema nebee libur nola rai isin resin sia. Ema musti faꞌe rai isin sia, nalo baa lima, hotu rai natoos faꞌek ida. ");
INSERT INTO tet_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ema musti nalo tuir ama naꞌin ukun, nodi libur hare nosi leo hotu-hotu iha rai Mesir. Hotu, sia musti rai natoos hare nia iha kanaha uman nodi daka diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Hodi nunia, oras rai salaen tinan hitu nia toꞌo, ita sei ho haan. Kalo ama naꞌi nadiꞌa kedan nunia, nanis la no ema mak mate salaen.” ");
INSERT INTO tet_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Rona Yusuf dale nunia, naꞌi no niakaan klosan boot sia, simu Yusuf lia fuan. ");
INSERT INTO tet_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Naꞌin dale naꞌak, “Maromak Kmalar Lulik nanis tuun baa Yusuf neꞌe! Ita la bele hetan seluk ema mak diꞌak liu nia!” ");
INSERT INTO tet_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hotu, naꞌin dale baa Yusuf naꞌak, “Maromak katak tiꞌan lia hotu-hotu baa o, lawarik! Oras neꞌe, foin ami hatene haꞌak o neꞌe matenek! Okaan hanoin liu nosi ema hotu-hotu! ");
INSERT INTO tet_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tan baa nia, oras neꞌe haꞌu kfoti o baa haꞌukaan liman kwana. Nebee renu hotu-hotu tuir okaan harukan. Haꞌu mesan, mak boot liu o!” ");
INSERT INTO tet_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Dale notu tiꞌan, naꞌin kolu nola niakaan kadeli mahoo matan marak, tau baa Yusuf liman fuan nodi naꞌak, “Kodi kadeli neꞌe, haꞌu kfoti o kalo baa haꞌukaan liman kwana iha rai Mesir neꞌe tomak!” Hotu, nia moos natais Yusuf nodi faru klobor mamar kabaas ida, nodi tara henu mean ida baa Yusuf kokorok. ");
INSERT INTO tet_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Naꞌin moos latan kedan baa Yusuf, niakaan kareta kuda fohorai kabaas ida, mak bodik ema boot nomer rua. Oras Yusuf saꞌe kareta nia, no ema nalai uluk iha kareta oin nodi nahii bei-beik naꞌak, “Hoi! Loke dalan! Foo tabe! No ema boot atu laꞌo liu!” Nodi nadahur nunia, naꞌin foti Yusuf nalo baa liman kwana iha rai Mesir. ");
INSERT INTO tet_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Hotu, naꞌin moos katak baa Yusuf naꞌak, “Nuneꞌe. O matene tiꞌan, haꞌu neꞌe mak naꞌin. Mais haꞌu katak tiꞌan ema hotu-hotu iha rai Mesir neꞌe kaꞌak, kalo o la mabusik sa-saa, sia nanis la bele nalo!” ");
INSERT INTO tet_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Hotu, naꞌin nanaran Yusuf naꞌak, Safnat Panea, tuir ema Mesir naran. Nia moos sasudin Yusuf no feto ida, naran Asnat. Yusuf banin mane, naran Potifera. Nia neꞌe, naꞌilulik ulun iha kota On. Hodi nunia, Yusuf dadi ema boot iha rai Mesir. ");
INSERT INTO tet_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Baa oras naꞌin foti nia, Yusuf otas tinan tolu nulu. Nosi ikus, Yusuf baa laꞌo nasirin fatin hotu-hotu iha rai Mesir. ");
INSERT INTO tet_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Iha tinan hitu rai bosu nia, toꞌos isin waꞌin tebes. ");
INSERT INTO tet_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Oras nia, Yusuf libur no bali nola toꞌos isin resin sia. Hare resin nosi fatin kreꞌis baa kota nabee dei, Yusuf rai baa kanaha uman iha kota nia. ");
INSERT INTO tet_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Hare resin nia sia waꞌin lo-loos, hanesan raihenek tasi tehen, toꞌo ema la bele sukat. ");
INSERT INTO tet_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Oras rai salaen sei la toꞌo dauk, Yusuf feen Asnat nahoris oan mane naꞌin rua. ");
INSERT INTO tet_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Baa oras nia, Yusuf katak naꞌak, “Maromak nalo haꞌu kaluꞌa tiꞌan haꞌukaan susar baa oras haꞌu ksai kosi haꞌukaan ama uman!” Nodi nanoin lia nia, Yusuf nanaran oan ulun nia naꞌak, Manase (tan lian hanesan lia fuan Ibrani ida naꞌak ‘haluꞌa’). ");
INSERT INTO tet_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Baa oras netan oan nomer rua, Yusuf katak naꞌak, “Haꞌu ketan susar waꞌin tiꞌan iha fatin neꞌe, mais Maromak natuun matak-malirin baa haꞌu, toꞌo haꞌu ketan oan iha neꞌe!” Nodi nanoin lia neꞌe, Yusuf nanaran oan nomer rua nia naꞌak, Efraim (tan efraim lia isin naꞌak ‘hetan oan’). ");
INSERT INTO tet_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nosi ikus, rai bosu tinan hitu nia siku. ");
INSERT INTO tet_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Hotu, rai salaen moos toꞌo, kona besik no Yusuf lian uluk nia. Iha fatin seluk sia, ema salaen tiꞌan, mais iha rai Mesir sei noo haan. ");
INSERT INTO tet_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","La kleur, ema Mesir sia moos salaen. Hotu, sia baa nusu haan iha naꞌin. Naꞌin moos naruka sia baa Yusuf, mais musti tuir Yusuf ukun. ");
INSERT INTO tet_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Rai salaen nia hetak boot toꞌo kona fatin hotu-hotu iha rai Mesir. Yusuf nahuu loke kanaha uman, nebee faꞌan hare baa ema Mesir sia. ");
INSERT INTO tet_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Rona lia nia, ema fatin hotu-hotu iha Mesir mai sosa haan nosi Yusuf. Rai salaen nia aat tebe-tebes iha raiklaran tomak. ");
INSERT INTO tet_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Baa oras nia, Yakob rona naꞌak, noo haan iha rai Mesir. Nia moos dale baa oan sia naꞌak, “Oa sia! Tan saa emi tuur no-nook dei!? ");
INSERT INTO tet_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Haꞌu krona iha rai Mesir noo haan! Diꞌak liu, emi baa sosa haan iha nebaa, nebee ita keta mate salaen!” ");
INSERT INTO tet_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Rona Yakob naruka nunia, Yusuf maun naꞌin sanulu nia moos nadiꞌa aan baa. ");
INSERT INTO tet_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mais Yakob la nabusik Yusuf alin ikun Benyamin tuir maun sia, tan Yakob naneo naꞌak, “Arumak oan ikun nia netan maufinu tenik!” ");
INSERT INTO tet_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Hodi nunia, Yakob oan naꞌin sanulu dei mak baa sosa haan iha rai Mesir. Oras nia, ema waꞌin nosi rai Kanaꞌan moos baa sosa haan iha Mesir, tan rai salaen nia toꞌo rai Kanaꞌan tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Baa oras nia, naꞌi Mesir foti Yusuf tiꞌan baa niakaan liman kwana iha rai Mesir. Kalo ema mai nosi nabee dei atu sosa hare, Yusuf mak faꞌan baa sia. Tan baa nia, baa oras maun sia toꞌo, sia nakniꞌa loꞌu-sudur baa Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Naree maun sia mai, Yusuf natene nola kedan. Mais nia nalo aan nuꞌu ema Mesir, toꞌo maun sia la natene nia. Nia nusu nodi lian makaꞌas naꞌak, “Emi neꞌe hosi nabee?” Maun sia moos simu naꞌak, “Ami neꞌe hosi Kanaꞌan. Ami mai atu sosa haan nosi ama naꞌi!” ");
INSERT INTO tet_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Rona maun sia nataa nunia, Yusuf nanoin nola niakaan meꞌi uluk nia. Hotu, nia dale nataꞌuk sia naꞌak, “Haꞌu la kfiar emi! Emi neꞌe nanis mai atu buka rai Mesir ain! Hotu emi fila hikar mai hatuda ho ami!” ");
INSERT INTO tet_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Rona Yusuf lian nia, sia nataa naꞌak, “Lale, ama! Ami neꞌe, ama naꞌi eman haruka sia dei! Tebes ama. Ami mai atu sosa haan! ");
INSERT INTO tet_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ami hotu-hotu neꞌe, aman ida dei! Ami la mai buka lia, ama! Ami neꞌe, ema diꞌak!” ");
INSERT INTO tet_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Rona nola nunia, Yusuf dale makaꞌas tenik naꞌak, “Hoi! Emi neꞌe bosok teen! Keta tolek haꞌu! Emi nanis mai atu buka rai neꞌe ain!” ");
INSERT INTO tet_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Mais maun sia sakar naꞌak, “Lale ama! Ami neꞌe, ama naꞌi eman haruka sia dei! Ami mai hosi rai Kanaꞌan! Ami neꞌe, maun-alin naꞌin sanulu resin rua! Ami hotu-hotu neꞌe, aman ida dei! Amikaan alin ikun nein no ama iha uma. No tenik amikaan alin ida, mais nia la iha tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Hotu Yusuf nataa nikar naꞌak, “Lale! Lia mak haꞌu kdale nia, tebes! Emi neꞌe, nanis mai buka rai neꞌe ain. ");
INSERT INTO tet_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Haꞌu kusu emi hatudu kakaer ida baa haꞌu, nebee kodi katene emikaan dalen nia tebes ka lale. Haꞌu karai aan! Kalo emikaan alin ikun nia la mai neꞌe, emi la bele laꞌo hela rai neꞌe! ");
INSERT INTO tet_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Emi musti boi hola emi naꞌin ida, nebee nia fila baa saka nola alin ikun nodi mai! Seluk sia haꞌu keti katoos baa neꞌe! Emikaan alin mai tiꞌan lai, foin haꞌu katene emi dale loos. Kalo lale, malorek tiꞌan emi neꞌe mai buka rai Mesir ain.” ");
INSERT INTO tet_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Hotu, Yusuf naruka niakaan ema sia neti natoos maun sia iha bui loron tolu laran. ");
INSERT INTO tet_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sia tama loron tolu tiꞌan, Yusuf baa dale no sia iha bui laran naꞌak, “Haꞌu neꞌe, ema mak nataꞌuk Maromak. Haꞌu moos tuir Niakaan hakaran nohuun! Haꞌu kakara kabusik emi, nebee emi bele moris. ");
INSERT INTO tet_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mais, emi musti hatudu kakaer nebee haꞌu katene emi neꞌe, ema loos! Nuneꞌe: Haꞌu keti katoos emi naꞌin ida iha neꞌe! Emi seluk sia bele fila, hodi haan foo baa emikaan familin sia! Tan sia noꞌi nein emi fila hodi haan! ");
INSERT INTO tet_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Toꞌo nebaa tiꞌan, emi musti fila hikar mai hodi emikaan alin nia, nebee hatudu haꞌak emi neꞌe ema loos! Kalo lale, haꞌu ktaa ukun mate baa emi!” Rona nola nunia, sia moos simu. ");
INSERT INTO tet_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Hotu, sia dale baa malu naꞌak, “Haa! Oras neꞌe, ita musti selu itakaan salan mak uluk ita halo tiꞌan baa itakaan alin. Baa oras nia, nia susar tebes toꞌo nusu tulun baa ita, mais ita la mana nia kois. Tan baa nia, oras neꞌe ita moos kona susar nuneꞌe!” ");
INSERT INTO tet_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Hotu, Ruben foo natene baa alin sia naꞌak, “Hei ali sia! Uluk haꞌu kakahik emi tiꞌan nebee keta halo saa ida baa lawarik nia. Mais emi la rona! Etuk, oras neꞌe ita hatiu hola Yusuf raan ona!” ");
INSERT INTO tet_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Maun sia dale nunia, mais sia la natene naꞌak Yusuf moos natene siakaan lia. Baa oras nia Yusuf dale no sia nodi lia Mesir, foin niakaan ibun-nanaan salin baa lia Ibrani. ");
INSERT INTO tet_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Rona maun sia dale nunia, Yusuf nariik kedan baa tanis mesan iha fatik seluk. Tanis notu, nia fila nikar baa maun sia. Hotu, nia naruka niakaan ema sia kesi nola maun Simeon iha maun-alin sia oin. ");
INSERT INTO tet_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Hotu, Yusuf naruka klosan sia natama hare baa maun kakaluk sia, nodi natama nikar no-nook ida-idak osan baa kakaluk laran. Nia moos naruka foo bakae baa sia. Rona nola nunia, klosan sia nalaꞌok Yusuf harukan nia. ");
INSERT INTO tet_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Nunia hotu, Yusuf maun sia nasaꞌe kakaluk sia baa siakaan kuda keledai. Hotu, sia moos fila. ");
INSERT INTO tet_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Toꞌo dalan klaran, sia nanawa kole. Hotu, ida kore niakaan kakaluk atu nahaan kuda keledai. Mais nia sarebak, tan naree niakaan osan iha kakaluk laran. ");
INSERT INTO tet_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nia nahii kedan naꞌak, “Adeei! Mai haree lai! Neꞌe, ita susar tiꞌan! Sia tau nikar haꞌukaan osan baa kakaluk laran!” Naree nola nunia, siakaan neon lakon kedan, tan sia nataꞌuk tebes. Sia moos dale baa malu naꞌak, “Maromak natuun tenik saa baa ita tiꞌan?” ");
INSERT INTO tet_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Hotu, sia laꞌo liu. Toꞌo Kanaꞌan tiꞌan, sia katak baa ama Yakob lia hotu-hotu mak kona baa sia tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Sia katak naꞌak, “Ama! Naꞌi Mesir ema liman kwana nia, makaꞌas resik! Niakaan dalen makaꞌas tebes! Nia duu ami naꞌak, ami mai buka rai Mesir ain. ");
INSERT INTO tet_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mais ami hataa haꞌak, ‘Lale! Ami dale lia loos! Ami la mai buka rai Mesir ain. ");
INSERT INTO tet_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ami neꞌe, ema diꞌak! Ami hotu-hotu, maun-alin naꞌin sanulu resin rua! Amikaan aman, ida dei! Amikaan alin ida mate tiꞌan! Alin ikun nein no amikaan ama iha Kanaꞌan!’ ");
INSERT INTO tet_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Rona ami dale nunia, naꞌin liman kwana nia naꞌak, ‘Haꞌu atu karee kokon, emi neꞌe loos ka lale! Ida nosi emi musti nein heik iha neꞌe! Emi seluk sia bele fila, hodi hare baa emikaan famili sia, nebee sia keta mate salaen! ");
INSERT INTO tet_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mais emi musti hodi alin nia mai lai, nebee haꞌu kbele katene, emi neꞌe dale loos, la mai buka lia iha rai neꞌe. Foin haꞌu kbele kabusik emikaan maluk mak keti katoos neꞌe! Hotu haꞌu moos foo leet baa emi baa nabee dei iha rai neꞌe!’ ” ");
INSERT INTO tet_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Dale hotu nunia, sia nahuu kore no namamu sai kakaluk isin sia. Sia sarebak, tan naree sia ida-idak osan iha kakaluk laran. Naree nunia, Yakob no oan sia hotu-hotu nataꞌuk tebes. ");
INSERT INTO tet_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Hotu, Yakob dale baa oan sia naꞌak, “Emi neꞌe halakon mohu haꞌukaan oan sia! Yusuf la iha tiꞌan! Simeon moos nunia tenik! Oras neꞌe, emi hakara hola tenik Benyamin hodi baa. Emi neꞌe tebe-tebes atu hasusar haꞌu dei!” ");
INSERT INTO tet_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rona aman katak nunia, Ruben moos dale baa aman naꞌak, “Ama! Latan Benyamin baa haꞌu! Haꞌu mak katiu kola lia neꞌe! Haꞌu karai aan, haꞌu atu foo kikar nia baa ama! Kalo lale, ama bele noꞌo haꞌukaan oan mane rua nia!” ");
INSERT INTO tet_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mais Yakob nataa nikar naꞌak, “La bele! Emi la bele hodi Benyamin baa! Maun Yusuf mate tiꞌan! Oras neꞌe, hela mesan nia dei! Kalo nia moos netan maufinu iha dalan lolon, emi halo haꞌukaan ulun moras tuꞌan tan tenik, toꞌo haꞌu ktama rate!” ");
INSERT INTO tet_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","2","Baa oras nia, rai salaen iha Kanaꞌan hetak boot tuꞌan. Yakob familin sia naa namohu haan mak uluk sia sosa iha Mesir. Hotu, Yakob katak baa oan sia naꞌak, “Oa sia! Diꞌak liu emi fila hikar baa rai Mesir, sosa tenik haan baa ita lai!” ");
INSERT INTO tet_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Rona nola nunia, Yahuda moos nataa naꞌak, “Ama! Hori hirak nia, naꞌi Mesir ema liman kwana nia foo natene makaꞌas baa ami naꞌak, ami la bele hatudu oin tenik baa nia, kalo ami la hodi ama oan ikun Benyamin baa. ");
INSERT INTO tet_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ama musti nabusik ali Benyamin tuir ami, foin ami bele baa sosa haan tenik. ");
INSERT INTO tet_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kalo ama la nabusik, ami moos la bele baa, tan ema boot Mesir nia dale makaꞌas tiꞌan nunia!” ");
INSERT INTO tet_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakob moos deꞌan sia naꞌak, “Tan saa emi katak baa ema nia haꞌak, emi sei hoo alin ida tenik?! Emi buka lia atu hasusar haꞌu ba-baa dei!” ");
INSERT INTO tet_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Rona nola nunia, sia namaus naꞌak, “Ama! Ema nia nakusuk ami bei-beik, atu nodi natene itakaan familin sia hotu-hotu! Nia nusu naꞌak, ‘Nunabee? Emikaan ama sei moris ka? Emi sei hoo alin mane ida tenik ka?’ Tan nia seten ami bei-beik, ami katak lo-loos ona! See mak natene naꞌak, nia atu naruka ami hodi ali baa nebaa?” ");
INSERT INTO tet_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Yahuda moos dale tuꞌan naꞌak, “Ama! Mabusik oan nia baa no ami ona! Haꞌu karai aan, kalo saa ida kona nia, haꞌu mak seluk nia! Kalo haꞌu la kodi kikar nia sei moris mai baa ama, ama tau sala nia baa haꞌu dei, toꞌo haꞌu kmate! Dadi, ama mabusik oan nia ona, tan ami atu laꞌo ona! Diꞌak liu, ami baa lai-lais, nebee keta no ema ida mate salaen! ");
INSERT INTO tet_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Hanoin kokon! Kalo ami la hein toꞌo kleur nuneꞌe, ami nanis baa-mai isin rua tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Hotu, Yakob katak naꞌak, “Kalo nunia, emi halo nuneꞌe dei! Baa hola rai neꞌe isin kabaas sia. Nuꞌu wani ween, ai babudun, ai morin ween, aitahan ween, kiar isin no ai horis isin seluk sia. Hotu, hodi baa hatetu foo baa naꞌi Mesir liman kwana nia, hodi hasara baa nia haꞌak, neꞌe amikaan sera bodik ama! ");
INSERT INTO tet_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Emi moos musti hodi kedan osan waꞌin liu osan uluk nia dala rua, tan emi musti foo fila osan mak emi hetan iha emikaan kakaluk laran hori hirak nia! Arumak, ema nia sia sura sala! ");
INSERT INTO tet_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Emi moos bele hodi emikaan alin baa, mais hodi hikar mai lai-lais! ");
INSERT INTO tet_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Haꞌu kaloon nebee Maromak mak Beran Kaliuk, nalo naꞌi Mesir liman kwana nia neon monu baa emi! Nebee nia bele foo fila Benyamin no Simeon baa emi, atu fila mai bele. Kalo haꞌukaan oan sia lakon, soꞌin baa. Haꞌu kterus susar nia!” ");
INSERT INTO tet_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Rona tiꞌan Yakob dale nunia, oan sia moos nahulin buat nia sia no osan, atu nodi baa Mesir. Sia moos no Benyamin baa. Toꞌo Mesir tiꞌan, sia baa nasoru Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Naree Benyamin no maun sia mai, Yusuf naruka klosan serwisu ulun naꞌak, “Modi ema neꞌe sia baa haꞌukaan uma! Hoꞌo karau baka ida, teꞌin malo midar! Tan loro natetu neꞌe, sia atu naa bele no haꞌu!” ");
INSERT INTO tet_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Rona Yusuf naruka nunia, klosan nia nalo tuir. Nia moos nalaꞌo nodi Yusuf maun sia baa Yusuf uman. ");
INSERT INTO tet_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Iha dalan klaran, Yusuf maun sia nataꞌuk basuk. Sia dale baa malu naꞌak, “Hoi! Tan saa nia naruka nodi ita mai iha neꞌe? Arumak, nia atu nasusar ita, tan osan mak uluk sia natama nikar iha itakaan kakaluk laran nia. Keta-keta sia nodi fudi nalaꞌo ita mai iha neꞌe, nebee kohi ita, nalo baa ata. Hotu, sia nadau nola itakaan kuda keledai sia!” ");
INSERT INTO tet_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Oras sia kreꞌis baa Yusuf uman, sia moos dale baa klosan nia naꞌak, ");
INSERT INTO tet_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ama! Ami bele husu lia ida ka? Uluk ami mai sosa haan iha neꞌe tiꞌan! ");
INSERT INTO tet_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Baa oras ami fila, ami hanawa iha dalan atu toba! Ami moos kore kakaluk sia atu hahaan kuda keledai. Teki-tekis, ami hetan hikar amikaan osan ida-idak, mak ami hodi sosa hare nia. Ami la hatene see mak natama nikar osan nia! Tan baa nia, oras neꞌe ami hodi hikar osan nia sia hotu-hotu tiꞌan! Dadi ama keta krakat ami! Ama moos bele natene, oras neꞌe ami hodi tenik osan seluk atu sosa haan foun!” ");
INSERT INTO tet_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Rona nola nunia, klosan nia nataa naꞌak, “Emi no-nook dei! Lalika hataꞌuk! Arumak emikaan Maromak nia, mak natuun matak-malirin baa emi iha kakaluk laran nia sia! Baa loron nia, haꞌu mak simu emikaan osan hotu-hotu! Emi la hoo tusan!” Hotu, klosan nia moos nabusik Simeon sai mai nasoru sia. ");
INSERT INTO tet_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nunia hotu, sia tama baa Yusuf uman. Klosan nia nola wee, foo baa sia atu fasi ain. Nia moos nahaan siakaan kuda keledai. ");
INSERT INTO tet_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Hotu, nia katak baa sia naꞌak, “Oras ida, emi haa hamutuk ho ama ulun!” Sia sei noꞌi nein Yusuf mai, sia nadiꞌa kedan siakaan naha sera sia. ");
INSERT INTO tet_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusuf toꞌo mai, sia moos nakniꞌa sudur iha Yusuf oin. Hotu, sia foti soruk naha sera sia, natetu baa Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusuf moos nusu baa sia naꞌak, “Nunabee? Emi hotu-hotu diꞌa-diꞌak dei ka? Nunabee baa emikaan ama katuas nia? Nia moos diꞌa-diꞌak dei ka?” ");
INSERT INTO tet_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Sia moos nataa naꞌak, “Ama atan katuas, mak amikaan aman susu nia, sei noꞌi diꞌa-diꞌak, ama!” Sia moos sudur foo tenik kneter baa Yusuf. ");
INSERT INTO tet_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusuf foti matan titu satan leur, toꞌo kona alin Benyamin. Nia dale naꞌak, “Neꞌe, mak emikaan alin ikun, mak emi dale tiꞌan baa haꞌu hori hirak nia ka?” Hotu, Yusuf katak baa Benyamin naꞌak, “Oa! Haꞌu kaloon nebee Maromak natuun matak-malirin waꞌin baa o!” ");
INSERT INTO tet_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Naree nola Benyamin, Yusuf laran hanesan atu nakduar sai ona, tan nia nadomi alin Benyamin liu resik. Tan la bele terus laran moras, Yusuf laꞌo nela sia lai-lais, tama baa keꞌan, hotu tanis. ");
INSERT INTO tet_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tanis notu, nia naroꞌis. Neon noku tiꞌan, foin nia sai nikar baa nasoru sia. Hotu nia naruka klosan sia baa nadiꞌa haan. ");
INSERT INTO tet_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Hotu, sia nadiꞌa salin Yusuf haan iha fatin ida. Maun-alin sia, salin iha fatin seluk. Yusuf niakaan maluk ema Mesir sia mak naa bele no nia, iha fatin ida duꞌuk. Sia nalo nunia, tan ema Mesir sia nakribi tuur naa namutuk no ema Ibrani. ");
INSERT INTO tet_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Hotu, sia natuur Yusuf mane malun sia, seꞌi oin baa Yusuf. Natuur sia, ida-idak tuir otas, nahuu nosi maun ulun toꞌo alin ikun. Naree fatin tuur oin nunia, Yusuf maun sia moos blaar. ");
INSERT INTO tet_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Hotu, Yusuf naruka klosan sia foti haan nosi niakaan fatin haan duꞌuk, foo baa maun-alin sia. Mais nia naruka foo baa Benyamin, waꞌin liu dala lima. Hotu, sia moos naa-nemu toꞌo bosu basuk. ");
INSERT INTO tet_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sia naa hotu tiꞌan, Yusuf naruka klosan serwisu ulun naꞌak, “O baa matama hare baa siakaan kakaluk ida-idak, toꞌo nakonu. Hotu, matama mikar siakaan osan ida-idak baa kakaluk! ");
INSERT INTO tet_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Hotu tiꞌan, foti mola haꞌukaan hemun fatik murak, matama baa oa ikun kakaluk!” Rona nola nunia, klosan nia moos nalo tuir. ");
INSERT INTO tet_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Seisawan oan, Yusuf maun sia tami atu fila. Sia laꞌo nodi kuda keledai mak tula haan. ");
INSERT INTO tet_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Sia sei la laꞌo dook nosi kota nia, Yusuf katak baa klosan ulun nia naꞌak, “O lai-lais baa tuir ema sia lai! Toma sia tiꞌan, maꞌak nuneꞌe: ‘Tan saa emi haseꞌi hahalok aat ho ama boot? Emi selu niakaan dadiꞌak, hodi hahalok aat nuneꞌe ka? ");
INSERT INTO tet_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tan saa emi hanaꞌo hodi ama boot hemun fatik murak? Emi la hatene ka? Fatik murak nia, lahoos bodik hemun dei! Mais nodi buka moris loron ikus! Buat nia, buat lulik! Emikaan hahalok neꞌe, aat resik!’ ” ");
INSERT INTO tet_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Rona nola nunia, klosan nia moos tuir sia toꞌo netan. Nia katak baa sia, tuir Yusuf harukan. ");
INSERT INTO tet_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mais sia sakar naꞌak “Ama naꞌak nunabee? Maromak naree ami! Ami la bele halo aat nunia! ");
INSERT INTO tet_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ama duꞌuk matene! Osan iha kakaluk laran hori hirak nia sia, ami foo fila tiꞌan. Nunabee ami bele hanaꞌo hola ama ulun niakaan mean-mutin hosi uma laran! ");
INSERT INTO tet_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ama, mai maree duꞌuk baa! Kalo hetan buat nia iha see niakaan kakaluk, taa ukun mate baa nia! Ami rumak sia moos dadi baa ata!” ");
INSERT INTO tet_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Hotu klosan simu naꞌak, “Lale! Nuneꞌe dei! Hetan iha see, nia mak dadi baa haꞌukaan atan. Emi rumak sia bele fila!” ");
INSERT INTO tet_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Hotu sia natuun lai-lais kakaluk nodi kore. ");
INSERT INTO tet_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Klosan naree sura kakaluk, nahuu nosi maun ulun niakaan, toꞌo alin ikun niakaan. Nia netan hemun fatik nia iha Benyamin kakaluk. ");
INSERT INTO tet_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Naree nunia, Benyamin maun sia laran dodok tebes. Sia moos nasaꞌe nikar kakaluk baa kuda keledai, hotu fila baa kota. ");
INSERT INTO tet_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Toꞌo Yusuf uman baa, Yusuf sei iha nia. Sia tama nodi nakniꞌa sudur baa nia. ");
INSERT INTO tet_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusuf nakanas naꞌak, “Tan saa emi halo nuneꞌe? Arumak emi la hatene, ema boot nuꞌu haꞌu neꞌe bele leno hodi buka ema lian kabun laran?” ");
INSERT INTO tet_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Rona nola nunia, Yahuda nataa naꞌak, “Adeei! Maromak loke malorek amikaan salan sia tiꞌan! Ami atu haꞌak saa tenik, ama! Ami atu haloos aan nunabee tenik? Kalo ama neti natoos amikaan alin ikun neꞌe, diꞌak liu ama neti natoos ami hotu, dadi baa ata.” ");
INSERT INTO tet_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mais Yusuf nataa naꞌak, “Lale! Hetan iha see, nia mak dadi haꞌukaan atan! Emi seluk sia, bele fila baa emikaan aman!” ");
INSERT INTO tet_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Rona Yusuf dale nunia, Yahuda nareꞌis aan baa Yusuf nodi naꞌak, “Ama boot. Haꞌu katene ama beran hanesan naꞌi boot. Dadi kakroꞌan ama keta kanarak haꞌu. Kalo bele, foo leet baa haꞌu atu katak lia ida baa ama! ");
INSERT INTO tet_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Hori hirak nia, ama boot nusu ami naꞌak, ‘Emikaan ama no emikaan alin sei iha ka?’ ");
INSERT INTO tet_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Hotu, ami hataa haꞌak, ‘Amikaan ama no amikaan ali ikun sei iha. Oras ali ikun nia moris, amikaan ama katuas tiꞌan. Ali ikun maun susu naꞌin ida, mais la iha tiꞌan. Siakaan inan mate tiꞌan. Oras neꞌe ali ikun mesan dei tiꞌan. Tan baa nia, amikaan ama dadobe nia tebes.’ ");
INSERT INTO tet_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ami dale hotu baa ama boot nunia tiꞌan, ama naruka ami hodi alin ikun mai neꞌe, nebee ama boot bele naree nia. ");
INSERT INTO tet_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ami hataa haꞌak, lawarik nia la bele laꞌo nela niakaan ama. Kalo laꞌo nela, nanis aman mate. ");
INSERT INTO tet_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Hotu ama boot moos nataa ami naꞌak, ‘Kalo emi la hodi alin nia mai, emi keta mai ona.’ ");
INSERT INTO tet_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Rona nola ama boot lia nia, ami moos fila. Toꞌo baa, ami katak ama boot lia fuan sia hotu baa amikaan ama. ");
INSERT INTO tet_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","La kleur, amikaan haan moos. Hotu amikaan ama naruka ami mai hikar Mesir, atu sosa tenik haan. ");
INSERT INTO tet_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mais ami hataa haꞌak, ‘Ama! Ami la bele baa hikar! Naꞌin liman kwana nia naꞌak, kalo ami la hodi alin ikun baa, ami keta mai ona! Tan baa nia, ali ikun musti tuir, foin ami bele baa!’ ");
INSERT INTO tet_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Hotu, amikaan ama dale tenik naꞌak, ‘Emi hatene tiꞌan, haꞌukaan feen Rahel oan, naꞌin rua dei! ");
INSERT INTO tet_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Oan ulun la iha tiꞌan! Asu fuik folan nola nia tiꞌan, toꞌo la karee nia ona. ");
INSERT INTO tet_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kalo emi hola tenik ali ikun hodi baa, hotu nia kona maufinu, emi hasusar haꞌu katuas neꞌe, toꞌo tama rate!’ ");
INSERT INTO tet_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Dadi nuneꞌe, ama boot! Kalo haꞌu kfila baa haꞌukaan ama, la kodi kikar ali ikun neꞌe, nanis ama mate. Tan amikaan aman kmalar nakriꞌit no lawarik neꞌe. Nia katuas basuk tiꞌan. Kalo ami tuꞌan tenik susar neꞌe, nanis nia mate! ");
INSERT INTO tet_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Haꞌu moos kamate lia ko haꞌukaan ama kaꞌak, haꞌu mak kataa bodik lawarik neꞌe. Haꞌu kamate lia tiꞌan kaꞌak, kalo haꞌu la kodi fila lawarik neꞌe baa, haꞌu katiu sala toꞌo mate. ");
INSERT INTO tet_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Haꞌu kaloon baa ama boot nuneꞌe: Haꞌu mak kein iha neꞌe, seluk nia. Haꞌu mak dadi ama boot atan dei. Surak ama boot nabusik lawarik neꞌe fila no maun sia. ");
INSERT INTO tet_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ama boot! Kalo lawarik neꞌe la tuir, haꞌu moos la fila. Tan haꞌu la kbele terus karee haꞌukaan ama susar toꞌo mate.” ");
INSERT INTO tet_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Rona nola Yahuda dale nunia, Yusuf laran dodok basuk, toꞌo la bele naterus nola iha klosan sia oin ona. Tan baa nia, nia naruka klosan sia sai, nebee nia bele mesan no maun-alin sia. Hodi nunia, nia bele katak sain naꞌak nia neꞌe, see. ");
INSERT INTO tet_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Klosan sia sai hotu, Yusuf tanis nodi nakrake, toꞌo ema Mesir iha keꞌan molin no iha naꞌin uman moos bele rona. ");
INSERT INTO tet_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Hotu, Yusuf katak sain lia baa maun-alin sia naꞌak, “Mane malun sia! Haꞌu neꞌe, Yusuf, emikaan maun no emikaan alin! Ama sei moris tebes ka?” Mais Yusuf maun-alin sia la nataa saa ida, sia tan nataꞌuk basuk. ");
INSERT INTO tet_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Hotu, Yusuf baku liman bolu sia naꞌak, “Kreꞌis mai lai!” Sia moos nareꞌis aan baa nia. Hotu nia katak tenik naꞌak, “Haꞌu neꞌe, Yusuf, mak hori uluk nia, emi faꞌan lakon baa Mesir! ");
INSERT INTO tet_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tebes, emi faꞌan lakon haꞌu tiꞌan! Mais keta hataꞌuk. Keta tula sala malu! Maromak duꞌuk mak nodi haꞌu kmai iha rai neꞌe! Nodi dalan oin nunia, Nia nodi haꞌu ksori ema lear nosi mate salaen! ");
INSERT INTO tet_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Oras neꞌe, rai salaen foin tinan rua laran! Sei tinan lima tenik. Baa tinan lima nia laran, ema la fila rai, la furi, no la netan rai isin ida kois! ");
INSERT INTO tet_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mais Maromak nodi haꞌu kmai uluk emi iha neꞌe, nebee emi ho emikaan bein oan sia bele hetan moris. Maromak Niakaan hahalok neꞌe, makaꞌas tebes! ");
INSERT INTO tet_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Haꞌu kmai neꞌe, lahoos tan emikaan hahalok, mais tan Maromak Niakaan hahalok! Nia mak nalo haꞌu kdadi baa naꞌin liman kwana. Haꞌu moos dadi ulun iha naꞌin tofatik fohorai! La no ema seluk mak boot liu haꞌu iha rai Mesir neꞌe! ");
INSERT INTO tet_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Oras neꞌe, emi lai-lais fila ona! Toꞌo uma, katak baa ama nuneꞌe: ‘Ama oan Yusuf sei moris. Nia dadi ema boot tiꞌan iha rai Mesir. Nia nusu ama baa lai-lais Mesir! ");
INSERT INTO tet_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ama bele tuur iha rai Gosen, kreꞌis no Yusuf. Fatin nia, fatin diꞌak no luan. Iha fatin nia, ama bele nakiak bibi no karau. Yusuf moos nusu, nebee ama baa bele-bele no ama oan sia no bein oan sia. Naha uma laran no sasoin sia hotu-hotu, hodi bele, nebee tuur hafati iha nebaa. ");
INSERT INTO tet_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kalo ama tuur iha rai Gosen, Yusuf bele naliku ama. Rai salaen sei tinan lima. Tan baa nia, Yusuf atu naliku ama no familin sia, no ama niakaan bibi no karau sia hotu-hotu, nebee keta susar sa-saa.’ ” ");
INSERT INTO tet_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Katak hotu nunia, Yusuf natebes tenik naꞌak, “Oras neꞌe, emi naꞌin haree duꞌuk! O moos nunia, Benyamin! Haꞌu neꞌe, Yusuf! ");
INSERT INTO tet_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Fila baa, katak ama haꞌak haꞌukaan beran iha Mesir, boot lo-loos! Emi moos musti katak malorek nosi sa-saa hotu-hotu mak emi haree tiꞌan! Hotu, emi lai-lais hodi ama mai!” ");
INSERT INTO tet_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Dale hotu tiꞌan, Yusuf nakoꞌak nola alin Benyamin. Sia rua moos tanis. ");
INSERT INTO tet_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Hotu Yusuf nakoꞌak maun sia ida-idak nodi deꞌi. Nunia hotu, foin maun-alin sia nahuu dale no nia. ");
INSERT INTO tet_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Oras Naꞌi Mesir no niakaan ema sia rona naꞌak Yusuf maun-alin sia mai tiꞌan, sia hotu-hotu neon diꞌak. ");
INSERT INTO tet_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Naꞌin moos katak baa Yusuf naꞌak, “Yusuf! Katak baa okaan maun-alin sia, nebee tula hare baa kuda keledai nodi fila baa Kanaꞌan! ");
INSERT INTO tet_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Maruka sia baa nola okaan aman no okaan familin sia hotu-hotu, lori mai neꞌe! Haꞌu atu kfoo rai ida mak boran basuk iha Mesir neꞌe bodik sia. Sia bele moris nodi naa nosi rai nia isin. ");
INSERT INTO tet_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Maruka sia dada nodi kedan kareta hira sia nosi neꞌe, nebee bele tula lawarik kiꞌik oan sia no okaan aman. ");
INSERT INTO tet_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Sia keta hanoin sasoin oi-oik tenik. Tan sia atu netan sa-saa hotu mak diꞌak kaliuk iha rai Mesir neꞌe!” ");
INSERT INTO tet_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Rona naꞌin lian nia, Yusuf moos foo kareta hira no bakae baa maun-alin sia, tuir naꞌin harukan. Maun-alin sia moos nadiꞌa aan fila, tuir naꞌin harukan. ");
INSERT INTO tet_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuf moos foo faru foun baa maun sia ida-idak tahan ida. Mais baa alin Benyamin, nia foo osan murak tomak atus tolu, no faru foun tahan lima. ");
INSERT INTO tet_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Nia moos solok baa aman, sa-saa mak kabaas liu iha Mesir. Sia tula naha sia baa kuda keledai aman matan sanulu. Nia foo tuꞌan hare, tubi, no haan oi-oik mak sia tula tenik baa kuda keledai inan matan sanulu, nebee nalo baa bakae, baa oras sia mai nikar Mesir. ");
INSERT INTO tet_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Nunia hotu, Yusuf nabusik sia fila nodi foo natene naꞌak, “Emi keta toe malu iha dalan!” ");
INSERT INTO tet_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Hotu, Yusuf maun-alin sia fila baa siakaan aman iha rai Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Toꞌo nebaa, sia katak baa aman naꞌak, “Ama! Ama oan Yusuf sei moris! Nia dadi ema boot tiꞌan mak kaer ukun iha rai Mesir!” Rona nola nunia, Yakob nakaka loos, tan nia la fiar. ");
INSERT INTO tet_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mais oras sia katak Yusuf mamenon, no oras Yakob naree kareta mak Yusuf solok mai atu hodi tula nia baa Mesir, foin nia fiar. ");
INSERT INTO tet_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Hotu Yakob moos dale naꞌak, “Adeei! Haꞌukaan oan Yusuf sei moris ka? Nunia, foin haꞌu neon diꞌak! Haꞌu kmusti baa karee nia lai, foin haꞌu kmate!” ");
INSERT INTO tet_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nunia hotu, Yakob nahulin naha hotu-hotu atu laꞌo nela rai Kanaꞌan. Toꞌo leo Barseba, nia nalo sera tunun, nodi natetu baa Naꞌi Maromak mak uluk niakaan ama Isak loꞌu-sudur baa. ");
INSERT INTO tet_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Baa kalan ida, Yakob meꞌi. Nia rona Maromak bolu nia naꞌak, “Yakob! Yakob! Madeer! Rona mai!” Hotu, Yakob nataa naꞌak, “Haꞌu iha neꞌe, Ama.” ");
INSERT INTO tet_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Hotu Maromak katak naꞌak, “Haꞌu neꞌe Maromak mak okaan ama tonu nanis baa hori uluk! Keta mataꞌuk baa Mesir! Tan Haꞌu atu kalo okaan husar-binan dadi klubun boot iha nebaa! ");
INSERT INTO tet_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Haꞌu klaꞌo ko o baa Mesir! Loron ikus, Haꞌu moos kodi kikar okaan husar-binan fila mai rai Kanaꞌan! Baa oras o mate, o oan Yusuf mak toma o nawan!” ");
INSERT INTO tet_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Meꞌi notu tiꞌan, Yakob no oan sia laꞌo nela leo Barseba. Nia no feen-oan saꞌe kareta mak naꞌin solok nia. Sia hotu-hotu nahuu laꞌo baa Mesir. ");
INSERT INTO tet_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Sia nodi bein sasoin no bibi no karau hotu-hotu mak sia netan iha rai Kanaꞌan. Yakob baa Mesir nia, no oan feto, oan mane, no bein oan sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakob funan klaut mak lori tuir baa Mesir, mak neꞌe: Ruben, Yakob oan ulun. ");
INSERT INTO tet_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben oan naꞌin haat mak: Henok, Palu, Hesron no Karmi. ");
INSERT INTO tet_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon, no oan naꞌin neen mak: Yemuel, Yamin, Ohad, Yakin no Sohar; no oan tenik mak Saul, nosi feen ema Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi, no oan naꞌin tolu mak: Gerson, Kehat no Merari. ");
INSERT INTO tet_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Tuir loos, Yahuda no oan naꞌin lima, mak: Er, Onan, Sela, Peres no Sera. Mais, Er no Onan mate tiꞌan iha Kanaꞌan. Yahuda nodi no Peres oan naꞌin rua mak: Hesron no Hamul. ");
INSERT INTO tet_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar, no oan naꞌin haat mak: Tola, Pua, Ayub no Simron. ");
INSERT INTO tet_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon, no oan naꞌin tolu mak: Sered, Elon no Yahleel. ");
INSERT INTO tet_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yakob no oan mane naꞌin neen nia, no tenik oan feto ida, naran Dina. Sia neꞌe, funan klaut nosi Yakob no feen Lea, baa oras sia tuur iha Mesopotamia. Yakob no Lea oa feto, oa mane no bei oan hotu-hotu, naꞌin tolu nulu resin tolu. ");
INSERT INTO tet_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Yakob moos no oan nosi feen kiꞌik, naran Silpa. Oan ida naran Gad. Gad oan naꞌin hitu mak: Sifion, Hagi, Suni, Esbon, Eri, Arodi no Areli. ");
INSERT INTO tet_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Oan ida tenik, naran Aser. Aser oan naꞌin lima mak: Yimna, Yiswa, Yiswi, Beria, no alin feto, naran Sera. Beria moos no oan naꞌin rua mak: Heber no Malkiel. ");
INSERT INTO tet_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Yakob no Silpa funan klaut hotu-hotu, naꞌin sanulu resin neen. Silpa neꞌe, ata feto mak uluk Laban foo baa niakaan oan feto Lea, mak Yakob feen kawaꞌik nia. ");
INSERT INTO tet_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakob feen ida seluk, naran Rahel. Siakaan oan naꞌin rua mak: Yusuf no Benyamin. ");
INSERT INTO tet_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Oras nia, Yusuf nola feto Mesir ida tiꞌan, naran Asnat. Asnat aman, naran Potifera, mak naꞌilulik ulun iha kota On. Yusuf no Asnat oan naꞌin rua mak: Efraim no Manase. ");
INSERT INTO tet_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin moos baa Mesir, nodi oan naꞌin sanulu mak: Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim no Ared. ");
INSERT INTO tet_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yakob no Rahel funan klaut hotu-hotu, naꞌin sanulu resin haat. ");
INSERT INTO tet_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Yakob feen kiꞌik ida tenik, naran Bilha. Siakaan oan naꞌin rua mak: Dan no Naftali. Dan oan ida naran Husim. ");
INSERT INTO tet_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali oan naꞌin haat mak: Yasel, Guni, Yeser no Silem. ");
INSERT INTO tet_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob no Bilha funan klaut hotu-hotu, naꞌin hitu. Bilha neꞌe, ata feto mak uluk Rahel netan nosi niakaan ama Laban. ");
INSERT INTO tet_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakob funan klaut hotu-hotu mak lori nosi Kanaꞌan baa Mesir, ema naꞌin neen nulu resin neen. ");
INSERT INTO tet_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tuꞌan baa Yusuf oan naꞌin rua iha Mesir, Yakob funan klaut hotu-hotu mak tuur iha rai Mesir, naꞌin hitu nulu. ");
INSERT INTO tet_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Oras Yakob sia nareꞌis aan baa rai Mesir, nia naruka oan Yahuda laꞌo uluk baa bolu Yusuf, nebee mai nasoru sia iha rai Gosen. Sia toꞌo rai Gosen, ");
INSERT INTO tet_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf moos saꞌe kareta atu baa nasoru aman iha nia. Baa oras sia rua aman oan nasoru malu tiꞌan, Yusuf nakoꞌak aman nodi tanis kleur basuk. ");
INSERT INTO tet_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Hotu, Yakob dale no oan Yusuf naꞌak, “Adeei, oa! Oras neꞌe, haꞌu karee o tiꞌan kodi matan duꞌuk! Haꞌu katene tiꞌan, o sei moris! Masik oras neꞌe haꞌu kmate moos, diꞌak!” ");
INSERT INTO tet_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Rona tiꞌan aman lian nunia, Yusuf katak baa maun-alin sia hotu-hotu naꞌak, “Haꞌu kmusti baa kasara baa ama naꞌi kaꞌak, haꞌukaan familin sia mai tiꞌan nosi rai Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Haꞌu moos katak sain kaꞌak emi neꞌe, makbalin. Tan baa nia, emi mai neꞌe, emi hodi kedan bibi no karau no bein sasoin sia hosi rai Kanaꞌan. ");
INSERT INTO tet_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kalo oras ida ama naꞌi bolu emi, hotu nusu emi naꞌak, emi serwisu saa, ");
INSERT INTO tet_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","emi musti hasara baa nia haꞌak, emi makbalin hori sei kiꞌik toꞌo oras neꞌe, hanesan emikaan bei uluk sia. Hodi nunia, ama naꞌi atu naruka emi tuur iha rai Gosen.” Yusuf katak nunia, tan ema Mesir sia noran nakribi, kalo sia tuur namutuk fatin ida no ema makbalin. ");
INSERT INTO tet_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Katak tiꞌan baa maun-alin sia, Yusuf no mane malun naꞌin lima baa nasoru kedan naꞌin. Yusuf nasara baa naꞌin naꞌak, “Ama naꞌi boot! Ama atan oan sia, haꞌukaan aman no haꞌukaan maun-alin sia, toꞌo mai tiꞌan nosi Kanaꞌan. Sia mai nodi siakaan bibi, bibi malae, karau baka no naha sia hotu-hotu. Oras neꞌe, sia hotu-hotu iha rai Gosen tiꞌan!” Yusuf nasara nunia tiꞌan, nia moos naruka mane malun naꞌin lima nia, ida-idak katak naran baa ama naꞌi. ");
INSERT INTO tet_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Hotu naꞌi nusu baa sia naꞌak, “Emi serwisu saa?” Sia nataa naꞌak, “Ama atan ami neꞌe, ema makbalin, hanesan amikaan bei uluk sia. ");
INSERT INTO tet_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Oras neꞌe, rai loro falin naruk basuk iha amikaan rai Kanaꞌan, toꞌo haan no hae la iha tiꞌan. Tan baa nia, ata ami neꞌe, mai iha rai neꞌe atu hein heik. Ami ata moos hodi bibi no karau oan sia. Ami ata haloon baa ama naꞌi boot, nebee foo leet baa ami ata neꞌe bele hein heik iha rai Gosen, atu hodi haliku bibi no karau oan sia.” ");
INSERT INTO tet_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Rona tiꞌan nunia, naꞌin katak sain niakaan hakaran baa Yusuf naꞌak, “Oras neꞌe, o aman no o maun-alin sia mai baa o tiꞌan! ");
INSERT INTO tet_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Sia bele nalo rai neꞌe, nuꞌu siakaan rain duꞌuk! Haꞌu katene rai Gosen nia, rai diꞌak kaliuk iha Mesir neꞌe! Tan baa nia, diꞌak liu sia tuur iha nebaa ona! Kalo noo nosi sia, mak natene naliku bibi no karau nalo kabaas, sia moos bele naliku haꞌukaan sia iha nebaa!” ");
INSERT INTO tet_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Naꞌin dale hotu nunia, Yusuf natudu niakaan ama Yakob baa naꞌin. Yakob moos namulak kedan nodi naloon nebee Naꞌi Maromak natuun matak-malirin baa naꞌi. ");
INSERT INTO tet_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Hotu naꞌin nusu baa Yakob naꞌak, “Ama! Ita otas tinan hira ona?” ");
INSERT INTO tet_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob nataa naꞌak, “Haꞌu kmoris tinan atus ida tolu nulu ona, mais la tuur metin iha fatin ida. Haꞌukaan bei uluk sia moos nunia. Kalo haꞌu kanesa baa sia, haꞌukaan otas sei badak liu sia, mais haꞌukaan moris nakonu no susar.” ");
INSERT INTO tet_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Dale notu nunia, Yakob moos tami naꞌi. Mais sei la sai dauk, nia namulak nodi naloon tenik, nebee Naꞌi Maromak natuun matak-malirin bodik naꞌi. ");
INSERT INTO tet_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Nasoru naꞌin tiꞌan, Yusuf nalo tuir naꞌin harukan, nodi baa natudu fatin iha rai Gosen bodik aman no maun-alin sia. Fatin nia diꞌak liu resik. (Nosi ikus, Yakob sia nanaran fatin nia naꞌak, Rameses.) Sia tuur nafati iha nia. ");
INSERT INTO tet_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Hotu, Yusuf naliku nodi foo haan baa aman, no maun-alin sia, no siakaan feen-oan sia hotu-hotu, sura tuir uma kain kiꞌik no boot. ");
INSERT INTO tet_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Baa oras nia, rai salaen hetak naruk, toꞌo la no haan tiꞌan iha rai Mesir toꞌo rai Kanaꞌan. Ema hotu-hotu isin olek, tan salaen. ");
INSERT INTO tet_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tan baa nia, sia mai atu sosa haan iha Yusuf. Hotu, Yusuf libur nola haan folin sia hotu-hotu, nodi baa rai iha naꞌin tofatik. ");
INSERT INTO tet_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Loron ikus, ema Mesir no ema Kanaꞌan osan sia mohu tiꞌan, toꞌo la bele sosa haan ona. Tan baa nia, sia baa Yusuf nodi naꞌak, “Ama boot! Ama foo haan lai, nebee ami keta mate salaen! Tan amikaan osan mohu tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusuf nataa naꞌak, “Soꞌin! Bele sosa haan hodi bibi no karau!” ");
INSERT INTO tet_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Rona nola nunia, ema sosa haan nodi kuda, bibi, bibi malae, karau baka no kuda keledai. Sia nalo nunia, tan Yusuf nameno nunia tiꞌan. ");
INSERT INTO tet_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tinan oin tenik, ema sia mai tenik baa Yusuf nodi naꞌak, “Ama boot! Ami katak malolok dei! Amikaan osan no amikaan bibi no karau sia mohu tiꞌan! Hela mesan amikaan isin lolon no amikaan rain dei! ");
INSERT INTO tet_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ama keta habusik ami mate! Tan kalo ami mate, see mak babilan rai nia sia? Diꞌak liu, ami mataroos baa ama boot! Ama boot bele hola amikaan rain sia, mais foo fini, nebee ami furi bodik ama boot! Hodi nunia, ama boot bele selu ami hodi haan. Surak ami keta mate!” ");
INSERT INTO tet_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tan rai salaen nia hetak tuꞌan, ema Mesir sia faꞌan hotu rai sia baa Yusuf. Yusuf sosa nola hotu-hotu, nalo baa naꞌin bein sasoin. ");
INSERT INTO tet_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Hodi nunia, renu Mesir sia hotu-hotu dadi mataroos bodik naꞌin. ");
INSERT INTO tet_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mais Yusuf la sosa nola naꞌilulik rain, tan sia netan haan bei-beik nosi naꞌin. Tan baa nia, naꞌilulik sia la faꞌan siakaan rain. ");
INSERT INTO tet_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Baa loron nia, Yusuf katak baa renu sia naꞌak, “Oras neꞌe, emi hotu-hotu atu dadi mataroos bodik ama naꞌi, tan emikaan rain sia, haꞌu ksosa kotu tiꞌan bodik ama naꞌi! Dadi, emi musti hola fini neꞌe, hodi baa furi ona! ");
INSERT INTO tet_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Baa oras emi kuꞌu, halo baa faꞌek lima. Faꞌek ida, hatama baa ama naꞌi. Faꞌek haat, halo baa fini no halo baa haan bodik emi.” ");
INSERT INTO tet_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Rona nola nunia, sia simu naꞌak, “Ama boot sori ami tiꞌan nosi salaen boot neꞌe. Tan baa nia, ami atu dadi mataroos baa ama naꞌi. Hodi nunia, ami bele sera dodan baa ama boot.” ");
INSERT INTO tet_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nosi ikus, hahalok mak Yusuf nalo nia, dadi ukun baa rai Mesir tomak. Hare mak renu sia kuꞌu, musti faꞌe baa faꞌek lima. Faꞌek ida hatama baa naꞌin. Faꞌek haat bodik sia duꞌuk. Sia nalaꞌok ukun nia iha Mesir toꞌo oras neꞌe. Hela mesan naꞌilulik rain sia dei mak naꞌin la nola. ");
INSERT INTO tet_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nahuu hori nia, ema Israꞌel sia tuur nametin aan iha rai Gosen, toꞌo sia soi iha nia. Siakaan husar-binan moos hetak waꞌin tuꞌan. ");
INSERT INTO tet_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakob nein iha rai Mesir, toꞌo tinan sanulu resin hitu. Hotu, nia mate baa otas tinan atus ida haat nulu resin hitu. ");
INSERT INTO tet_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kreꞌis atu mate, Yakob bolu nola oan Yusuf nodi naꞌak, “Oa! Haꞌu koran la kleur Naꞌi Maromak bolu nikar haꞌu ona! Tan baa nia, kalo o madomi haꞌu, mamate lia mo haꞌu, nebee o keta makoi haꞌu iha rai Mesir neꞌe! ");
INSERT INTO tet_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kalo haꞌu kmate, o musti modi mikar haꞌu baa makoi iha itakaan bei uluk rate fatik! Haꞌu kakara nunia!” Yusuf nataa naꞌak, “Diꞌak ama! Kalo ama nakara tiꞌan nunia, haꞌu moos tuir!” ");
INSERT INTO tet_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakob moos simu naꞌak, “Kalo nunia, oa, o marai aan maꞌak o atu tuir tebe-tebes o aman hakaran!” Yusuf moos narai aan kedan, tuir aman hakaran. Hotu, aman moos nakniꞌa iha toba fatik nodi namulak sera dodan baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nunia hotu, Yusuf fila. La kleur, ema mai katak naꞌak, aman moras todan. Rona nola nunia, Yusuf bolu nola niakaan oan naꞌin rua, mak Manase no Efraim. Hotu sia baa naree Yakob. ");
INSERT INTO tet_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Baa oras Yakob rona naꞌak, Yusuf no oan sia mai, nia nakaꞌas aan nadeer tuur baa toba fatik. ");
INSERT INTO tet_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Hotu, nia katak baa Yusuf naꞌak, “Oa Yusuf! Hori hirak nia, Maromak natadu aan baa haꞌu iha leo Lus iha rai Kanaꞌan. Nia mak Beran Boot Kaliuk. Nia nameno baa haꞌu iha nebaa ");
INSERT INTO tet_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","naꞌak, ‘Haꞌu atu kalo okaan husar-binan sia hetak waꞌin tuꞌan, nebee sia dadi klibur boot! Haꞌu atu kfoo rai neꞌe bodik sia, nebee dadi bein sasoin, toꞌo rai falu fila!’ ");
INSERT INTO tet_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tan lia nia, oras neꞌe haꞌu atu katak lia ida bodik okaan oan Efraim no Manase. Natoon baa haꞌu kmai iha Mesir, sia rua moris tiꞌan. Masik nunia moos, oras neꞌe haꞌu kalo sia dadi baa haꞌukaan oan duꞌuk, hanesan okaan maun Ruben no Simeon! ");
INSERT INTO tet_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mais nosi ikus, kalo o metan oan tenik, filak sia nuꞌu okaan oan duꞌuk. Sia musti simu sasoin nosi maun Efraim no Manase. ");
INSERT INTO tet_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Haꞌu kalo nunia, atu kodi temi okaan inan Rahel. Tan oras ami fila hikar hosi Mesopotamia atu baa Kanaꞌan, okaan inan mate nahoris iha dalan. Nia mate kreꞌis baa leo Efrata, iha rai Kanaꞌan. Oras nia, haꞌu laran moras resik, tan kakoi okaan inan iha dalan tehen baa leo Efrata!” (Oras neꞌe, ema nanaran leo nia naꞌak, Betlehem.) ");
INSERT INTO tet_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Dale notu nunia, Yakob foti oin nodi titu baa Yusuf oan sia. Hotu nia nusu Yusuf naꞌak, “Sia neꞌe, see niakaan oan sia?” ");
INSERT INTO tet_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusuf nataa naꞌak, “Neꞌe sia, ama bein oan sia mak Naꞌi Maromak foo tiꞌan baa haꞌu iha rai Mesir neꞌe!” Rona nunia, Yakob katak naꞌak, “Kalo nunia, mareꞌis oan sia mai haꞌu. Haꞌu atu kamulak kodi kaloon nebee Maromak natuun matak-malirin baa sia!” ");
INSERT INTO tet_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Tan Yakob katuas tiꞌan, matan malahuk ona. Nia titu la malorek tiꞌan. Rona aman naruka nunia, Yusuf nareꞌis oan sia baa Yakob. Hotu, Yakob nakoꞌak nodi deꞌi sia rua. ");
INSERT INTO tet_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Hotu, Yakob dale tenik no Yusuf naꞌak, “Kleur tiꞌan haꞌu kaꞌak falik la kasoru o ona! Mais oras neꞌe Maromak nalo liu tenik, toꞌo haꞌu moos bele karee okaan oan sia!” ");
INSERT INTO tet_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Hotu, Yusuf dada sees oan sia nosi Yakob. Hotu nia nakniꞌa nodi sudur baa aman. ");
INSERT INTO tet_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Hotu, nia nariik. Nia moos dada nareꞌis tenik oan rua nia baa aman Yakob, nebee nia namulak nodi nusu matak-malirin baa sia. Yusuf nariik oan ulun Manase iha Yakob sorin kwana. Oan nomer rua Efraim iha karuk. ");
INSERT INTO tet_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mais, baa oras Yakob rai liman baa sia atu namulak, Yakob rai seluk liman. Nia rai liman kwana baa alin Efraim ulun, liman karuk baa maun Manase ulun. ");
INSERT INTO tet_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hotu, nia namulak nusu matak-malirin bodik Yusuf naꞌak, “Okaan bein Isak aman Abraham, no okaan bein Isak duꞌuk, sia rua moris tuir bei-beik Maromak hakaran. Maromak moos naliku tiꞌan haꞌu, hori sei nurak toꞌo oras neꞌe! ");
INSERT INTO tet_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Maromak sori haꞌu tiꞌan nosi maufinu oi-oik. Tan lia nia, haꞌu moos kaloon, nebee Nia natuun matak-malirin baa oan neꞌe sia no siakaan husar-binan. Hanoin. Kalo sia namulak baa Maromak, sia keta naluꞌa temi bei Abraham naran, no bei Isak naran no haꞌukaan naran! Hodi nunia, siakaan husar-binan hetak waꞌin tuꞌan, dadi klubun boot iha raiklaran neꞌe!” ");
INSERT INTO tet_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yakob namulak nunia, mais baa oras Yusuf naree aman rai liman kwana baa alin Efraim ulun, nia moos kaer nola aman liman nia, atu rai seluk baa maun Manase ulun. ");
INSERT INTO tet_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Nia katak baa aman naꞌak, “Ama! Keta malo nunia! Oan ulun lahoos Efraim, tan Manase nahali Efraim! Ama musti rai liman kwana baa maun Manase ulun, tan nia mak oa ulun.” ");
INSERT INTO tet_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mais aman Yakob la noꞌuk. Nia dale naꞌak, “Oa! Haꞌu katene nanis! Nosi ikus Manase dadi ema boot. Niakaan husar-binan moos hetak waꞌin tuꞌan, toꞌo dadi ema klubun boot! Mais alin Efraim atu dadi ema boot liu tan tenik! Niakaan husar-binan sia moos waꞌin liu resik, toꞌo dadi baa ema klubun waꞌin mak boot liu tan tenik!” ");
INSERT INTO tet_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Hotu Yakob katak baa lawarik rua nia naꞌak, “Nosi ikus, kalo ema Israꞌel naloon baa Naꞌi Maromak, nebee natuun matak-malirin baa ema, sia atu temi emikaan naran. Sia atu naloon naꞌak, ‘Nebee Naꞌi Maromak natuun matak-malirin baa o, hanesan Nia natuun tiꞌan matak-malirin baa Efraim no Manase!’ ” Hodi nunia, Yakob temi uluk alin Efraim naran, foin maun Manase naran. ");
INSERT INTO tet_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hotu Yakob katak baa Yusuf naꞌak, “Oa! La kleur haꞌu kmate ona! Mais Naꞌi Maromak nanis tulun emi! Nia atu nodi fila emi baa emikaan bei uluk rain. ");
INSERT INTO tet_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Oras neꞌe, haꞌu klatan baa o liu nosi okaan maun-alin sia! Tan haꞌu klatan tuꞌan baa o, foho iha rai Kanaꞌan mak uluk haꞌu kola tiꞌan kosi ema Amori, baa oras haꞌu katuda ko sia!” ");
INSERT INTO tet_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Dale notu no Yusuf, Yakob bolu nola oan sia hotu-hotu, hotu katak naꞌak, “Oa sia! Emi hareꞌis aan mai haꞌu lai! Haꞌu atu kalore kedan emi ida-idak moris lalaꞌok baa loron ikus!” ");
INSERT INTO tet_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Hotu Yakob moos nahuu katak baa oan sia naꞌak, “Yakob oan sia! Mai hariik satan mola haꞌu! Mai rona emikaan aman Israꞌel neꞌe atu dale! ");
INSERT INTO tet_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! O neꞌe, haꞌukaan oa ulun. Tan lia nia, ema kneter o. O neꞌe, haꞌukaan knoꞌa no haꞌukaan liman kwana! ");
INSERT INTO tet_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mais o neon la metis. O la matene makara nabee! Sarebak, o toba mo haꞌukaan feen Bilha, modi madoor okaan aman toba fatik! Tan lia nia, haꞌu la kfilak o baa oa ulun ona. ");
INSERT INTO tet_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon no Lewi! Emi rua neꞌe, manesak dei! Emi rua beer hasusar ema hodi surik. ");
INSERT INTO tet_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Emi beer taa siit karau baka kloor, toꞌo nakfeur atu mate! Emikaan aꞌaat ida tenik, emi ruun neꞌan hodi hoꞌo ema! Tan hahalok nia, haꞌu la kakara rona emi! Haꞌu moos la kakara kahur emikaan lia! ");
INSERT INTO tet_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tan emikaan krakat aat liu resik nia, haꞌu katuun dinu baa emi! Emi kanarak toꞌo la ho dadomin! Tan baa nia, emi musti hatiu duꞌuk emikaan aꞌaat nia! Nosi ikus Maromak keke karin emikaan husar-binan, toꞌo sia tuur keen karin malu iha rai Israꞌel! ");
INSERT INTO tet_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! Okaan naran naꞌak ‘tonu’! Okaan maun-alin sia atu tonu o nodi loꞌu baa o! O moos atu tonan okaan funu sia, toꞌo la nakfodak! ");
INSERT INTO tet_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O neꞌe, hanesan busa fuik boot ida, mak buka biit haan duꞌuk! O moos hanesan busa fuik boot aman, mak fofen aan baa noku; la noo ema ida mak naksakar aan koen o! O moos hanesan busa fuik boot inan, mak daka oan: la noo ema ida mak naksakar aan koen o! Ema nakerat o, toꞌo la noo ida mak naksakar aan atu nalo oi-oik baa o! ");
INSERT INTO tet_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Loron ikus, o atu kaer ukun! Okaan husar-binan moos atu kaer ukun tuir malu, toꞌo noo husar-binan ida mak beran kaliuk mak tuur kaer ukun nia! Hotu, ema klubun hotu-hotu atu loꞌu-sudur no rona baa Nia! ");
INSERT INTO tet_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","12","O atu moris diꞌak! O makara saa, iha! Okaan bibi no karau no toꞌos isin moos hetak waꞌin tuꞌan, toꞌo soe hahaat. O maa-memu midar nohuun. ");
INSERT INTO tet_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon! Rai mak dadi okaan bein sasoin, niakaan luan nosi tasi tehen toꞌo kladik no kota Sidon. Roo tasi nosi rai seluk sia tama soe sao mamatek iha okaan namon! ");
INSERT INTO tet_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! O neꞌe biit hanesan kuda keledai! Mais kalo o toba tiꞌan iha dalan klaran, la no ida bele fuꞌa nadeer o, nebee laꞌo liu! Kalo o maree mola leo diꞌak ida iha sorin balu nebaa, masik ida la naruka moos, o matiu mola okaan naha sia, modi baa! O neꞌe, nunia ona! ");
INSERT INTO tet_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! Okaan naran ‘Dan’ neꞌe, lia isin naꞌak ‘maktetu no makotu lia’! O mo okaan husar-binan atu natetu no nakotu okaan ema klubun lian, nalo tetuk no nesan! Hotu, o dadi maun bodik ema hunun sia iha Israꞌel! ");
INSERT INTO tet_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","O neꞌe moos, karonak hanesan samea mahoo raso mak noꞌi noku iha dalan tehen! Kalo ema saꞌe kuda liu nia, teki-tekis o tutu kuda nuban, toꞌo ema mak saꞌe monu! ");
INSERT INTO tet_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Aaa, MAROMAK! Haꞌu kamulak kodi kaloon, nebee Ita foo moris baa ami hotu-hotu! ");
INSERT INTO tet_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! Okaan naran ‘Gad’ neꞌe, lian kreꞌis hanesan ‘hababu’! Ema naꞌok sia mai nadau o, mais o madau fila sia, toꞌo matoba mola sia! ");
INSERT INTO tet_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Nosi ikus, okaan toꞌos isin kabaas lo-loos! Toꞌo o bele malo tubi midar oi-oik. Hotu naꞌin sia mai sosa iha o! ");
INSERT INTO tet_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! O neꞌe, hanesan bibi fuik mak nakbois sai, tan la noo ema ida bele lituk nola o! O moos metan oan kabaas sia! ");
INSERT INTO tet_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf! O neꞌe, hanesan ai maneꞌek mak moris kreꞌis wee matan! Okaan sorun sia naneꞌe saꞌe baa kadidin fatuk aas sia! ");
INSERT INTO tet_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Noo ema mak rai hirus baa o, hanesan funu nana dama baa o! ");
INSERT INTO tet_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mais Naꞌi Maromak mak haꞌu kloꞌu-sudur baa, Nia nanis tulun o! Nia nakbiit okaan liman, toꞌo o bele sakar funu sia modi dama, masik mosi dook! O bele matoba mola sia, tan Maromak tulun o. Nia mak beran boot kaliuk! Tan lia nia, haꞌu kakrai aan baa Nia! Nia mak daka haꞌu! ");
INSERT INTO tet_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nia moos daka o nodi foo matak-malirin baa o. Matak-malirin nosi laleꞌan, matak-malirin nosi raiklaran, no matak-malirin toꞌo hetan oan waꞌin mak isin diꞌak! ");
INSERT INTO tet_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Matak-malirin mak haꞌu kusu foo baa o neꞌe, kasalak liu nosi foho mak nariik nafati sia! Nebee matak-malirin hotu-hotu neꞌe, nakduar baa o. Tan o neꞌe, liu mosi okaan maun-alin sia hotu-hotu! ");
INSERT INTO tet_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! O sakar manesak no asu fuik mak salaen! Seisawan oan, nia tama rai kohi haan, hotu naa. Mais kalan, nia faꞌe haan resin baa oan sia! Okaan husar-binan moos, atu makaꞌas nunia!” ");
INSERT INTO tet_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Hodi nia, Yakob katak kedan moris lalaꞌok nosi oan sia ida-idak no husar-binan sia baa loron ikus. Sia hotu-hotu nia, mak nahoris ema Israꞌel hunun sanulu resin rua. ");
INSERT INTO tet_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Nunia hotu, Yakob katak baa oan sia naꞌak, “La kleur haꞌu kmate ona! Kalo haꞌu kmate tiꞌan, emi musti baa hakoi haꞌu iha bei Abraham raten! Rate nia, iha fatuk kuak ida kreꞌis leo Makpela no Mamre iha rai Kanaꞌan! Uluk bei Abraham sosa nola fatuk kuak nia no toꞌos, nalo baa rate fatik. Nia sosa kotu tiꞌan nosi ema Het ida naran Efron! ");
INSERT INTO tet_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Iha rate fatik nia, ema nakoi tiꞌan bei Abraham no bei Sara, namutuk no haꞌukaan aman Isak no haꞌukaan inan Ribka! Tan baa nia, emi musti hakoi haꞌu iha nebaa, iha haꞌukaan feen Lea sorin! ");
INSERT INTO tet_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Haꞌu kameno tenik, nebee emi keta haluꞌa hakoi haꞌu iha fatuk kuak, mak bei Abraham sosa nola tiꞌan nia!” ");
INSERT INTO tet_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Dale notu nunia, Yakob toba nikar. Hotu nawan kotu. ");
INSERT INTO tet_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Naree aman mate tiꞌan, Yusuf nakoꞌak nola, nodi tanis. Nia moos deꞌi bei-beik. ");
INSERT INTO tet_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hotu, Yusuf naruka klosan maktebar maten sia, nebee kahur ai morin oi-oik, nodi tebar Yakob maten. ");
INSERT INTO tet_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Klosan maktebar maten sia babilan Yakob maten nia, toꞌo loron haat nulu, tuir siakaan adat. Ema Mesir sia hotu-hotu moos tanis, tan Yakob mate. Sia nalaꞌok hahalok nia, toꞌo loron hitu nulu, ahan ema boot ida mak mate. ");
INSERT INTO tet_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Loron hitu nulu siku liu tiꞌan, Yusuf katak baa klosan sia naꞌak, “Emi rona! Emi baa hodi haꞌukaan lia fuan neꞌe, hasara baa ama naꞌi haꞌak nuneꞌe: ");
INSERT INTO tet_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Natoon baa oras haꞌukaan aman kreꞌis atu mate, nia nusu nebee haꞌu kodi niakaan maten, baa kakoi iha rai Kanaꞌan! Tan baa nia, haꞌu kusu ama naꞌi foo leet, nebee haꞌu kbele baa kakoi haꞌukaan aman. Hotu tiꞌan, foin haꞌu kfila mai.’ ” ");
INSERT INTO tet_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Rona nola nunia, naꞌin moos nataa naꞌak, “Kalo Yusuf namate lia no aman nunia tiꞌan, haꞌu moos kakara. Baa hakoi maten iha nebaa ona!” ");
INSERT INTO tet_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Hotu, Yusuf baa nakoi aman. Ema waꞌin moos tuir. Sia nia mak naꞌin klosan sia hotu-hotu, no ema boot hotu-hotu nosi Mesir. ");
INSERT INTO tet_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusuf maun-alin no siakaan ema serwisu sia hotu-hotu moos baa bele. Hela mesan feen no lawarik sia no bibi no karau sia iha Gosen. ");
INSERT INTO tet_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sondadu waꞌin moos tuir. Balu saꞌe kareta, balu tenik saꞌe kuda. Ema mak tuir maten nia waꞌin basuk, toꞌo ema lolok nia, naruk lo-loos. ");
INSERT INTO tet_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ema lolok nia nakur mota Yordan iha fatin ida naran Atad. Ema taꞌe nanis hare iha nia. Toꞌo nia, Yusuf sia tanis aman maten. Sia moos daka maten kalan hitu laran tenik. ");
INSERT INTO tet_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Naree sia susar nunia, ema Kanaꞌan dale baa malu naꞌak, “Haree lai! Ema Mesir sia daka maten nodi tanis, toꞌo nalo ita moos laran moras!” Tan baa nia, ema Kanaꞌan nanaran fatin nia naꞌak, Abel-Misraim. Neꞌe naꞌak ‘ema Mesir siakaan susar’. ");
INSERT INTO tet_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hotu, Yakob oan sia nalaꞌok tuir lia mamenon mak sia nameno tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Sia foti nola aman Yakob maten, nodi baa nakoi iha fatuk kuak iha leo Makpela, kreꞌis baa Mamre. Abraham sosa nola rai nia nosi ema Het ida naran Efron, nalo baa siakaan rate fatik. ");
INSERT INTO tet_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Nakoi aman tiꞌan, Yusuf no maun-alin sia fila nikar baa Mesir. Nunia moos, ema mak tuir sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Toꞌo Mesir tiꞌan, Yusuf maun sia nahuu nataꞌuk, tan siakaan aman Yakob la iha tiꞌan. Sia dale baa malu naꞌak, “Hei! Hanoin lai! Arumak Yusuf sei rai hirus baa ita, hotu atu selu nikar itakaan hahalok aat uluk nia sia. Kalo dadi tebes nunia, nunabee?” ");
INSERT INTO tet_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tan baa nia, sia kabuar lia, hotu solok baa Yusuf naꞌak, “Ama Naꞌi! Oras itakaan aman sei moris, nia naruka kedan ami ");
INSERT INTO tet_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","atu katak baa ama nuꞌu neꞌe: ‘Masik ami halo aat baa Yusuf, mais Yusuf musti naluꞌa lakon amikaan salan nia.’ Ami neꞌe, Maromak atan, mak itakaan ama loꞌu-sudur baa. Tan baa nia, ami atu mai husu pardua, tan ami hotu-hotu halo sala tiꞌan baa ama naꞌi.” Rona lia solok nia, Yusuf moos tanis. ");
INSERT INTO tet_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hotu Yusuf maun sia moos mai duꞌuk. Sia loꞌu-sudur baa nia nodi naꞌak, “Ami mai atu mataroos baa ama.” ");
INSERT INTO tet_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mais Yusuf nataa sia naꞌak, “Mau sia! Emi lalika hataꞌuk ona! Maromak mesan no beran kastikar ema! Haꞌu neꞌe, la ko beran. ");
INSERT INTO tet_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tebes! Uluk nia, emi koꞌa kabuar lia hodi hahaat haꞌu! Mais Naꞌi Maromak nalo emikaan aꞌaat nia, dadi baa dadiꞌak! Hodi nunia, Nia foti haꞌu kdadi ema boot, nebee ema waꞌin bele netan moris! ");
INSERT INTO tet_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tan lia nia, emi keta hataꞌuk, tan haꞌu kamate lia tiꞌan atu kaliku emi ho emikaan oan sia hotu-hotu!” Nodi dale diꞌa-diꞌak nunia, Yusuf nametis niakaan maun sia neon. ");
INSERT INTO tet_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Hotu, Yusuf tuur nametin aan iha rai Mesir, namutuk no maun-alin sia hotu-hotu. Nia moris toꞌo tinan atus ida sanulu. ");
INSERT INTO tet_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Nia sei noo leet naree Efraim oan no bein oan sia. Nia naꞌin duꞌuk mak nawaꞌi Manase bein oan, mak Makir oan sia. ");
INSERT INTO tet_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Nosi ikus, Yusuf katak baa maun-alin sia naꞌak, “Mane malun sia! Haꞌu koran haꞌukaan loron mate kreꞌis tiꞌan! Mais haꞌu kfiar Naꞌi Maromak nanis naliku emi! Nia atu nalaꞌo emi sai hosi rai neꞌe, baa hikar rai mak Nia nameno tiꞌan no bei Abraham, no bei Isak no ama Yakob!” ");
INSERT INTO tet_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Hotu, Yusuf nusu sia naꞌak, “Emi musti harai aan baa haꞌu! Kalo toꞌo baa oras Naꞌi Maromak nalaꞌo emi nodi nikar baa rai Kanaꞌan, emi musti foti hodi haꞌukaan maten!” ");
INSERT INTO tet_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","La kleur, Yusuf mate iha Mesir baa otas tinan atus ida sanulu. Sia tebar kedan maten nia, hotu natama baa ai balun. ");
INSERT INTO tet_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Hakerek neꞌe katak lia nosi Yesus Kristus, Ema mak Naꞌi Maromak nameno kedan hori uluk atu solok mai. Nia neꞌe, Naꞌi Daud husar-binan no Bei Abraham husar-binan. Nahuu nosi Bei Abraham toꞌo Naꞌi Daud, siakaan husar-binan mane, dalas sanulu resin haat. Siakaan naran, mak neꞌe: Abraham oan, naran Isak. Isak oan, naran Yakob. Yakob oan, naran Yahuda. Yahuda moos sei noo maun-alin tenik. ");
INSERT INTO tet_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda oan, naran Peres no Sera (siakaan inan, naran Tamar). Peres oan, naran Herson. Herson oan, naran Ram. ");
INSERT INTO tet_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram oan, naran Aminadab. Aminadab oan, naran Nahason. Nahason oan, naran Salmon. ");
INSERT INTO tet_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon oan, naran Boas (Boas inan, naran Rahab). Boas oan, naran Obet (Obet inan, naran Rut). Obet oan, naran Isai. ");
INSERT INTO tet_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai oan, naran Daud. ");
INSERT INTO tet_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Nosi Daud toꞌo oras ema Israꞌel kona soe baa Babilon, siakaan husar-binan mane, dalas sanulu resin haat tenik, mak neꞌe: Daud oan, naran Salomo (Salomo inan, uluk Uria feen). Salomo oan, naran Rehabeam. Rehabeam oan, naran Abia. Abia oan, naran Asaf. Asaf oan, naran Yosafat. Yosafat oan, naran Yoram. Yoram oan, naran Usia. Usia oan, naran Yotam. Yotam oan, naran Ahas. Ahas oan, naran Heskia. Heskia oan, naran Manase. Manase oan, naran Amos. Amos oan, naran Yosias. Yosias oan, naran Yekonya. (Yekonya no niakaan alin sia moris baa oras ema Israꞌel sia kona soe baa Babilon.) ");
INSERT INTO tet_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Baa oras sia kona soe baa Babilon toꞌo baa Yesus, siakaan husar-binan mane, dalas sanulu resin haat tenik, mak neꞌe: Yekonya oan, naran Saltiel. Saltiel oan, naran Serubabel. Serubabel oan, naran Abihut. Abihut oan, naran Elyakim. Elyakim oan, naran Asor. Asor oan, naran Sadok. Sadok oan, naran Akim. Akim oan, naran Eliut. Eliut oan, naran Eliasar. Eliasar oan, naran Matan. Matan oan, naran Yakob. Yakob oan, naran Yusuf. Yusuf neꞌe mak Maria laꞌen. Maria neꞌe mak niti baa Yesus. Yesus neꞌe mak Kristus, mak Naꞌi Maromak boi kedan hori uluk. ");
INSERT INTO tet_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nahuu nosi Abraham toꞌo Daud, husar-binan dalas sanulu resin haat; nosi Daud toꞌo oras sia kona soe baa Babilon, husar-binan dalas sanulu resin haat; no nosi Babilon toꞌo Kristus, husar-binan dalas sanulu resin haat. ");
INSERT INTO tet_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lia Maria nahoris Yesus nuneꞌe: Maria sasudin no Yusuf tiꞌan. Mais sia naꞌin rua sei la namutuk dauk hanesan feen-laꞌen, Maria netan tiꞌan nosi Kmalar Lulik. ");
INSERT INTO tet_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Baa oras Yusuf natene naꞌak Maria netan tiꞌan, nia nakara sia rua faꞌe malu. Mais Yusuf nia, ema moon. Nia la noꞌuk namoe Maria iha ema lear oin. Tan lia nia, Yusuf buka dalan atu faꞌe malu no-nook dei. ");
INSERT INTO tet_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mais baa kalan ida, oras Yusuf sei nanoin baa-mai, nia meꞌi. Iha meꞌi nia, nia naree Maromak Niakaan makbukar laleꞌan ida mai katak baa nia naꞌak, “Yusuf! O neꞌe, Naꞌi Daud husar-binan. Keta makerat atu mola Maria, tan lawarik oan mak iha niakaan notak nia, Maromak Kmalar Lulik mak naseꞌi. ");
INSERT INTO tet_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria atu nahoris oan mane ida. O musti manaran nia maꞌak, Yesus, tan Nia mak atu sori Naꞌi Maromak eman sia nosi sala.” ");
INSERT INTO tet_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lia nia atu natoꞌo saa mak Naꞌi Maromak katak kedan hori uluk. Tan Nia naruka makoꞌan Yesaya nakerek nela naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hanono, mai! Feto lawarik ida mak sei la natene mane, atu netan. Hotu nia nahoris mane oan ida. Sia atu nanaran Nia naꞌak, Emanuel.” (Iha lia Ibrani, Emanuel lia isin naꞌak, Naꞌi Maromak namutuk no ita.) ");
INSERT INTO tet_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf meꞌi notu, nia nadeer. Hotu nia nalo tuir kedan saa mak Naꞌi Maromak naruka nia. Nia nola Maria nalo baa feen, ");
INSERT INTO tet_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","mais la namutuk no Maria hanesan feen-laꞌen, toꞌo Maria nahoris Oan nia tiꞌan. Oa nia moris, Yusuf moos nanaran nia naꞌak Yesus. ");
INSERT INTO tet_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Baa oras Maria nahoris Yesus iha leo Betlehem iha rai Yudea, Naꞌi Herodes mak kaer ukun iha nia. Oras nia moos, ema naꞌin hira mai iha kota Yerusalem nosi fatin dook iha lorosaꞌe baa. Sia nia, ema matenek leno fitun. ");
INSERT INTO tet_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Toꞌo Yerusalem baa, sia nusu baa-mai naꞌak, “Ema Yahudi siakaan naꞌi mak foin moris nia, iha nabee? Ami haree tiꞌan fitun ida iha lorosaꞌe mak natudu tadak naꞌak, Nia moris tiꞌan. Tan lia nia, ami mai atu loꞌu-sudur baa Nia.” ");
INSERT INTO tet_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rona nola nunia, Naꞌi Herodes neon la noku. Ema hotu-hotu iha Yerusalem moos nunia. ");
INSERT INTO tet_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hotu Naꞌi Herodes libur nola ema Yahudi siakaan naꞌilulik ulun sia no manorik ukun sia hotu-hotu. Nia nusu baa sia naꞌak, “Emi katak kokon baa haꞌu lai! Kristus mak Naꞌi Maromak nameno tiꞌan nia, ema atu nahoris nia iha nabee?” ");
INSERT INTO tet_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sia nataa naꞌak, “Iha Betlehem, iha rai Yudea, ama naꞌi. Maromak makoꞌan Mika nakerek kedan hori uluk nuneꞌe: ");
INSERT INTO tet_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hei, emi ema Betlehem iha rai Yudea. Keta hakraik emikaan leo nia, leo kiꞌik mak la noo folin. Tan Ema boot ida atu mosu mai nosi nebaa. Nia atu dadi makbalin bodik Haꞌukaan ema Israꞌel sia.’ ” ");
INSERT INTO tet_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Rona nola nunia, Naꞌi Herodes bolu no-nook ema matenek leno fitun sia. Nia moos nusu baa sia naꞌak, “Wainhira emi haree fitun nia mosu iha laleꞌan?” Sia moos katak baa nia. ");
INSERT INTO tet_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Rona tiꞌan, nia naruka sia baa Betlehem nodi nameno naꞌak, “Baa buka Oa nia iha Betlehem. Kalo hasoru tiꞌan, fila mai katak haꞌu, tan haꞌu moos beer baa loꞌu-sudur baa Nia.” ");
INSERT INTO tet_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Rona notu naꞌi dale nia, sia moos baa. Hatene hodi baa, sia titu-naree tenik fitun mak uluk sia naree iha lorosaꞌe nia. Fitun nia mosu iha siakaan oin, hotu laꞌo uluk sia toꞌo nanawa besik baa Oa nia moris fatin. ");
INSERT INTO tet_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Naree fitun nia, sia neon diꞌak tebe-tebes. ");
INSERT INTO tet_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Toꞌo fatin nia, sia tama baa uma laran, hotu naree Oa nia no Niakaan ina Maria. Sia nakniꞌa loꞌu-sudur baa Oa nia. Sia loke siakaan naha, hotu natetu buat folin todan sia baa Oa nia. Buat nia sia, mak mean isin, ai morin no ai morin raan. ");
INSERT INTO tet_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Baa oras nia moos, sia netan meꞌi nosi Naꞌi Maromak naꞌak, “Keta fila tenik baa Naꞌi Herodes.” Tan lia nia, sia fila baa siakaan rai tuir dalan seluk. ");
INSERT INTO tet_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baa oras ema matenek leno fitun sia fila tiꞌan, Maromak Niakaan makbukar laleꞌan ida mai katak baa Yusuf iha meꞌi laran naꞌak, “Yusuf! Madeer lai-lais ona! Malai modi Oan nia no niakaan ina baa rai Mesir nebaa. Hein hafati iha nebaa toꞌo Haꞌu katak wainhira emi bele fila. Tan Naꞌi Herodes noꞌi buka atu noꞌo Oan nia!” ");
INSERT INTO tet_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Meꞌi notu, Yusuf nadeer. Baa kalan nia kedan, nia nodi feen no Oan nia, nalai baa Mesir. ");
INSERT INTO tet_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sia nein iha nebaa toꞌo Herodes mate. Lia nia natoꞌo saa mak Naꞌi Maromak katak kedan baa makoꞌan Hosea hori uluk naꞌak, “Haꞌu kbolu kikar Haꞌukaan Oan sai nosi Mesir.” ");
INSERT INTO tet_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Baa oras Naꞌi Herodes natene nola ema matenek leno fitun sia tolek nia tiꞌan, nia nawan saꞌe tebe-tebes. Nia naruka niakaan sondadu sia naꞌak, “Baa leo Betlehem no leo mak kreꞌis iha nia sia. Hoꞌo mohu lawarik mane hotu-hotu mak otas sei la toꞌo tinan rua dauk.” Herodes naruka nunia, tan nanoin nola ema matenek siakaan lia. Nia sura tinan nahuu nosi sia naree fitun nia mosu iha laleꞌan. ");
INSERT INTO tet_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Lia neꞌe sia natoꞌo saa mak Maromak makoꞌan Yeremia nakerek kedan hori uluk naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Noo ema mak tanis naboo aan iha leo Rama. Rahel tanis roꞌan aan, tan niakaan oan sia mate mohu tiꞌan. Nia la noꞌuk ema mai namaus nia, tan niakaan oan sia la iha tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nosi ikus, Naꞌi Herodes mate. Oras nia, Yusuf sia sei iha Mesir. Hotu Maromak Niakaan makbukar laleꞌan ida mai natadu aan baa Yusuf iha meꞌi laran naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Yusuf! Madeer ona! Modi mikar Oa nia no niakaan ina baa Israꞌel ona. Ema mak buka atu noꞌo Oa nia, mate tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Rona nola nunia, Yusuf moos nadeer. Hotu nodi nikar sia baa rai Israꞌel. ");
INSERT INTO tet_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mais baa oras nia, Naꞌi Herodes oan Arkalaus dadi nikar naꞌin iha rai Yudea. Rona nola lia nia, Yusuf nataꞌuk fila baa Yudea. Hotu Naꞌi Maromak moos naruka nia iha meꞌi laran tenik naꞌak, “Yusuf! Keta baa mein iha Yudea.” Tan lia nia, Yusuf baa nein iha Galilea, ");
INSERT INTO tet_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","iha leo ida naran Nasaret. Lia nia natoꞌo saa mak Naꞌi Maromak katak kedan baa makoꞌan hori uluk naꞌak, “Sia atu temi Nia, Ema Nasaret.” ");
INSERT INTO tet_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Baa oras Yesus boot tiꞌan, Yohanis Mak Sarani Ema nahuu nanorin ema iha fatin fuik sia iha rai Yudea. ");
INSERT INTO tet_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nia katak naꞌak, “Mamaluk sia! Emi musti laꞌo hela emikaan salan, hodi fila hikar baa Naꞌi Maromak ona. Oras neꞌe, ema hotu-hotu bele tama ona dadi baa Naꞌi Maromak eman.” ");
INSERT INTO tet_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Uluk, Maromak makoꞌan ida naran Yesaya nakerek kedan nosi Yohanis naꞌak, “Ema ida atu nahii iha fatin fuik naꞌak, ‘Ema hotu-hotu musti hadiꞌa dalan, hodi simu Naꞌi Maromak mai! Haweer dalan atu simu Nia!’ ” ");
INSERT INTO tet_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanis niakaan moris lalaꞌok, hanesan Maromak makoꞌan uluk sia. Niakaan tais, halo hosi onta rahun. Niakaan bolas, halo hosi kulit. Niakaan haan, kalaꞌek no wani ween. ");
INSERT INTO tet_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Oras nia, ema lear mai atu nasoru Yohanis. Sia mai nosi kota Yerusalem no rai Yudea tomak. Sia moos mai nosi leo sia mak kreꞌis no mota Yordan. ");
INSERT INTO tet_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sia loke neon nodi naꞌak nasai siakaan salan. Hotu Yohanis sarani sia iha mota Yordan. ");
INSERT INTO tet_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Baa oras nia, ema nosi partee Farisi no partee Saduki moos mai nusu nebee Yohanis sarani sia. Mais Yohanis nakbehek naꞌak, “Hoi! Emi neꞌe nuꞌu samea tolek teen! Naꞌi Maromak atu kastikar emi tan emikaan hahalok aat sia. Keta haneo emi bele hakbois hosi Niakaan kastikar nia. ");
INSERT INTO tet_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Diꞌak liu fila hikar baa Naꞌi Maromak ona, hodi soe hela emikaan salan. Hotu halo hahalok diꞌak sia, nudaar ai huun mak nasai fuan diꞌak. ");
INSERT INTO tet_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Keta haneo emi sotir tan emi Bei Abraham husar-binan. Fiar haꞌu! Naꞌi Maromak bele naseꞌi fatuk neꞌe sia dadi Bei Abraham husar-binan. ");
INSERT INTO tet_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sintidu! Noo ema mak kaer nola baliun tiꞌan. Nia nadiꞌa aan atu nuꞌan ai huun hotu-hotu mak la nasai fuan diꞌak. Nuꞌan notu, soe baa haꞌi. ");
INSERT INTO tet_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tebes. Haꞌu ksarani emi kodi wee. Neꞌe dadi tadak naꞌak emi laꞌo hela emikaan salan tiꞌan. Mais ema ida mak makaꞌas liu haꞌu atu mai. Masik dadi baa Niakaan ata moos, haꞌu la kfatan. Nia atu nalo liu haꞌu, tan Nia atu fakar Maromak Kmalar Lulik baa emi. Nia moos atu namoos emikaan neon, hanesan ema nodi haꞌi sunu lere. ");
INSERT INTO tet_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nia kaer lafatin atu tataꞌek nasai hare abas. Hotu Nia natama hare isin baa kanaha. Mais hare abas, Nia soe baa haꞌi mak laka bei-beik.” ");
INSERT INTO tet_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Baa oras nia, Yesus tuun nosi Galilea baa mota Yordan. Nia mai nusu nebee Yohanis sarani Nia, ");
INSERT INTO tet_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","mais Yohanis la noꞌuk. Nia saseni naꞌak, “Nunabee, haꞌu mak musti sarani Ita Boot? La baku fila ka? Ita Boot mak musti sarani haꞌu. Haꞌu kakara mak nia!” ");
INSERT INTO tet_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mais Yesus nataa naꞌak, “La saa ida. Oras neꞌe, mau mak sarani Haꞌu dei. Kalo mau nalo nunia, ita halo tuir Naꞌi Maromak hakaran tiꞌan.” Rona nola nunia, Yohanis nataa naꞌak, “Loos Ita Boot baa dei.” Hotu nia sarani Yesus. ");
INSERT INTO tet_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sarani notu, Yesus sai nosi mota. Teki-tekis, laleꞌan nakloke. Hotu Nia titu-naree Maromak Kmalar tuun mai baa Nia, hanesan manu lakateu sina. ");
INSERT INTO tet_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hotu Naꞌi Maromak lian maliak sai nosi laleꞌan naꞌak, “Neꞌe mak Haꞌukaan Oan dadobe. Nia nalo Haꞌu neon diꞌak tebes.” ");
INSERT INTO tet_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nunia hotu, Maromak Kmalar Lulik dada nodi Yesus baa fatin fuik ida, nebee diabu ulun koko Nia. ");
INSERT INTO tet_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iha nia, Yesus nalirin aan loron haat nulu, kalan haat nulu. Nia noran salaen tebe-tebes, ");
INSERT INTO tet_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","hotu diabu ulun mai koko Nia naꞌak, “O neꞌe tebe-tebes Naꞌi Maromak Oan ka? Kalo tebes, maruka fatuk neꞌe sia dadi haan, nebee O maa.” ");
INSERT INTO tet_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mais Yesus nataa naꞌak, “Hakerek tiꞌan iha Hakerek Moon naꞌak: ‘Ema raiklaran la moris nosi haan dei. Mais sia moos musti nanono Maromak Manfatin, nodi nalo tuir Niakaan beer.’ ” ");
INSERT INTO tet_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hotu diabu nia dada nodi Yesus baa kota Yerusalem, mak Naꞌi Maromak Niakaan kota lulik. Nia dada nasaꞌe Yesus baa Naꞌi Maromak Niakaan Uma Hamulak Huun fafuhun. ");
INSERT INTO tet_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hotu nia dale naꞌak, “Kalo O neꞌe tebe-tebes Naꞌi Maromak Oan, maksoit tuun kokon baa rai. Nanis O la metan susar, tan hakerek tiꞌan iha Hakerek Moon naꞌak, ‘Naꞌi Maromak naruka Niakaan makbukar laleꞌan sia, mai daka O.’ Hakerek Moon moos naꞌak, ‘Sia atu tane nola O nodi siakaan liman, toꞌo masik O ain atu sidi kona fatuk moos, lale kedas.’ ” ");
INSERT INTO tet_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mais Yesus nataa naꞌak, “Hakerek Moon naꞌak, ‘Naꞌi Maromak nia, okaan Naꞌin. Keta maruka Nia nodi Niakaan beran atu natudu kakaer naꞌak, Nia mak tebe-tebes Maromak.’ ” ");
INSERT INTO tet_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hotu diabu nia nodi tenik Yesus saꞌe baa foho dikin ida. Nia natudu naꞌi raiklaran hotu-hotu siakaan fohorai, no siakaan kabaas hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Natudu mohu tiꞌan, diabu katak baa Yesus naꞌak, “Haꞌu klatan fohorai nia sia hotu-hotu baa O, surak O makniꞌa loꞌu-sudur baa haꞌu.” ");
INSERT INTO tet_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mais Yesus nakbehek naꞌak, “Hoi, Diabu! Sees mosi neꞌe! Hakerek Moon naꞌak, ‘O musti loꞌu-sudur baa Naꞌi Maromak, no serwisu bodik Nia mesan dei.’ ” ");
INSERT INTO tet_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Rona nola nunia, diabu moos laꞌo nela Yesus. Hotu makbukar laleꞌan sia mai naliku Yesus. ");
INSERT INTO tet_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Baa oras nia, Naꞌi Herodes natama Yohanis Mak Sarani Ema baa bui. Rona nola lia nia, Yesus fila baa Galilea. ");
INSERT INTO tet_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nia baa Niakaan leo Nasaret, hotu laꞌo liu baa nein iha leo Kapernaum. Leo nia iha debu boot Galilea tehen, iha ema Sebulon no ema Naftali rain. ");
INSERT INTO tet_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hodi nunia, Yesus natoꞌo saa mak Maromak makoꞌan Yesaya nakerek kedan hori uluk naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Rai Sebulon no Rai Naftali, mak kreꞌis debu boot Galilea, iha mota Yordan loromonu. Ema maktabar waꞌin nein iha nia. ");
INSERT INTO tet_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Sia moris iha makukun laran, mais oras neꞌe, sia naree Kroman tiꞌan. Oras neꞌe, Kroman naksinak tiꞌan bodik ema hotu-hotu mak sei la natene dauk Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nahuu baa oras nia, Yesus nanorin ema naꞌak, “Emi musti laꞌo hela emikaan salan, nebee moris loos ona! Tan oras neꞌe, ema hotu-hotu bele tama tiꞌan dadi baa Naꞌi Maromak eman.” ");
INSERT INTO tet_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Baa loron ida, Yesus laꞌo iha debu boot Galilea tehen. Nia nasoru ema naꞌin rua, maun-alin. Maun naran Simon, mais loron-loron ema temi nia naꞌak Petrus. Niakaan alin, naran Andreas. Sia noꞌi tiha naꞌan tasi iha debu laran, tan sia naꞌin rua nia, ema maktuun tasi. ");
INSERT INTO tet_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nasoru tiꞌan, Yesus bolu sia naꞌak, “Hei, mai tuir Haꞌu ona! Loro-loron emi buka naꞌan tasi, mais oras neꞌe Haꞌu atu kanorin emi atu buka ema, nebee sia moris tuir Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Rona nola nunia, sia rua laꞌo nela siakaan daitiha, hotu tuir kedas Yesus. ");
INSERT INTO tet_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Laꞌo soruk tenik baa, Yesus naree ema naꞌin rua tenik. Sia, Sebadeus oan. Maun, naran Yakobus. Alin, naran Yohanis. Sia naꞌin rua noꞌi nadiꞌa daitiha bele-bele no siakaan ama iha bero laran. Yesus moos bolu sia naꞌin rua atu tuir Nia. ");
INSERT INTO tet_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Rona nola nunia, sia moos laꞌo nela siakaan ama no siakaan bero, hotu tuir kedas Yesus. ");
INSERT INTO tet_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hotu Yesus laꞌo nasirin rai Galilea atu nanorin iha uma hamulak Yahudi. Nia nanorin Naꞌi Maromak Manfatin Diꞌak nodi nalore oin nunabee ema bele tuir Naꞌi Maromak ukun. Nia moos nadiꞌak nola ema nosi siakaan moras oi-oik. ");
INSERT INTO tet_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","La kleur, lia nosi Niakaan hahalok nia keke lema rai Siria. Hotu ema nodi siakaan ema moras oi-oik mai baa Nia. Sia moos nodi ema mak diabu tekar, ema mak horak bibi maten, no ema mak ain asak. Nia nadiꞌak nola hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Baa oras nia, ema lear mai tuir Yesus. Sia mai nosi rai Galilea, nosi rai Kota Sanulu mak ema temi naꞌak Dekapolis. Seluk sia mai nosi kota Yerusalem, nosi rai Yudea, no nosi mota Yordan sorin balu baa. ");
INSERT INTO tet_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Baa oras Yesus titu-naree ema lear lolok mai, Nia saꞌe baa foho kiꞌik ida atu tuur iha nia. Maktuir sia mak Nia boi tiꞌan nia mai kreꞌis atu nanono Nia. ");
INSERT INTO tet_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hotu Nia nahuu nanorin sia. ");
INSERT INTO tet_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Yesus nanorin naꞌak, “Ema kiak sia, sia sotir, tan Naꞌi Maromak duꞌuk mak siakaan Naꞌin iha laleꞌan. ");
INSERT INTO tet_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ema mak laran susar sia, sia sotir, tan Naꞌi Maromak duꞌuk namaus sia. ");
INSERT INTO tet_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ema kiꞌik sia, sia sotir, tan sia atu simu fafaꞌek nosi Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ema mak buka Naꞌi Maromak dalan moris loos, sia sotir, tan Naꞌi Maromak atu foo saa mak sia buka. ");
INSERT INTO tet_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ema mak neon monu baa ema, sia sotir, tan Naꞌi Maromak moos atu neon monu baa sia. ");
INSERT INTO tet_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ema mak neon moon sia, sia sotir, tan sia atu naree duꞌuk Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ema mak nalo ema dame malu, sia sotir, tan Naꞌi Maromak atu temi sia naꞌak, ‘Haꞌukaan oan.’ ");
INSERT INTO tet_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ema mak netan susar tan tuir Naꞌi Maromak, sia sotir, tan Naꞌi Maromak duꞌuk mak siakaan Naꞌin iha laleꞌan. ");
INSERT INTO tet_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kalo ema nasusar emi tan emi tuir Haꞌu, emi moos sotir. Kalo sia dale aat baa emi, no naktolek emi, nodi nahaat emikaan naran, emi moos sotir. ");
INSERT INTO tet_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Emi musti neon boot, tan Naꞌi Maromak atu foo saseban boot baa emi iha laleꞌan. Mais hanoin! Lahoos emi mesan mak hetan susar nunia, tan ema moos nalo aat nunia baa Maromak makoꞌan uluk aan sia.” ");
INSERT INTO tet_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Hotu Yesus dale naꞌak, “Emikaan moris musti dadi hanesan masin bodik ema raiklaran. Kalo ema beer haan midar, sia musti tau masin. Mais, kalo masin miis tiꞌan, la noo folin ona. Ema soe loos baa dalan, hotu sama tan. ");
INSERT INTO tet_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Emikaan moris moos musti dadi hanesan kroman bodik ema raiklaran. Emi musti haksinak hanesan kota ida iha foho leten mak ema waꞌin bele titu-naree. ");
INSERT INTO tet_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ema mak nalaka badut, la subar badut nia iha sasanan laran. Mais sia rai baa fatin aas, nebee bele naroma uma isin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Emi musti moris nunia. Emi musti haksinak, nebee ema waꞌin bele titu-naree emikaan moris mak diꞌak, toꞌo sia tonu naꞌak, ‘Emikaan Aman iha laleꞌan, makaꞌas tebes!’ ” ");
INSERT INTO tet_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Hotu Yesus dale naꞌak, “Arumak emi haneo haꞌak, Haꞌu kmai iha raiklaran neꞌe atu kalakon Ukun-badu mak Naꞌi Maromak foo baa Bei Musa ka? Lale! Arumak emi haneo haꞌak, Haꞌu la ktitu saa mak Maromak makoꞌan sia nanorin hori uluk ka? Lale! Haꞌu kmai neꞌe, atu kalaꞌo katoꞌo lia nia sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Kalo laleꞌan no raiklaran sei iha, Ukun-badu nia sia nafati nohuun. Masik lia lotun oan ida moos, la lakon. Hotu-hotu nafati toꞌo tetuk. ");
INSERT INTO tet_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Noo ema mak la titu ukun balu, tan sia naneo naꞌak, ‘Ukun ida neꞌe, lia kiꞌik. Dadi, haꞌu la ktuir!’ Hotu ema nia nanorin baa ema seluk, nebee keta tuir. Tan lisan nunia, Naꞌi Maromak iha laleꞌan atu nafoli ema nia naꞌak, ema kiꞌik. Mais ema mak nalaꞌo ukun nia sia nodi nanorin ema seluk nebee nalo tuir, Naꞌi Maromak atu nafoli ema nia naꞌak, ema boot. ");
INSERT INTO tet_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Fiar Haꞌu! Kalo emi la moris tuir Naꞌi Maromak hakaran liu nosi ema manorik ukun no ema partee Farisi sia, emi la bele tama Niakaan fohorain no la bele dadi baa Niakaan ema.” ");
INSERT INTO tet_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Hotu Yesus dale naꞌak, “Emi hatene tiꞌan ukun sia mak Naꞌi Maromak foo baa itakaan bei uluk sia naꞌak, ‘Keta hoꞌo ema. Noo tenik, kalo ema noꞌo ema, musti kona kastikar.’ ");
INSERT INTO tet_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mais haꞌu katak nuneꞌe: keta nawan saꞌe malu, tan ema mak nawan saꞌe niakaan maluk, nia sala. Ema mak deꞌan niakaan maluk naꞌak, ‘O momok!’, ema nia musti nataa iha makotu lia oin. No ema mak nakbehek niakaan maluk naꞌak, ‘O bulak!’, nia atu kona kastikar iha haꞌi naraka. ");
INSERT INTO tet_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tan lia nia, kalo o modi sera baa Naꞌi Maromak, hotu manoin maꞌak okaan maluk sei nawan saꞌe o, ");
INSERT INTO tet_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","diꞌak liu rai hein sera nia lai, hotu baa dame malu, foin mai matetu sera nia baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kalo ema nalo lia baa o, diꞌak liu lai-lais baa musu dame mo nia. Kalo lale, ema nia atu dada nodi o baa makotu lia oin. Hotu makotu lia atu latan o baa ema makdaka bui, nebee natama o baa bui laran. ");
INSERT INTO tet_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Haꞌukaan dalen neꞌe, tebes no loos! O atu mein bei-beik iha bui laran, toꞌo selu kotu okaan tusan hotu-hotu.” ");
INSERT INTO tet_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Hotu Yesus dale naꞌak, “Emi hatene tiꞌan ukun-badu naꞌak, ‘Keta halo lia kfoꞌer.’ ");
INSERT INTO tet_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mais Haꞌu katak nuneꞌe: Ema mak foti matan titu-naree feto ida, hotu nia beer toba no feto nia, ema nia nalo lia kfoꞌer tiꞌan iha neon laran. ");
INSERT INTO tet_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tan lia nia, kalo o malo sala modi okaan matan kwana, sukit soe dei. Diꞌak liu o tama laleꞌan modi matan mesak dei, nosi o kona soe baa haꞌi naraka modi matan rua. ");
INSERT INTO tet_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kalo o malo sala modi okaan liman kwana, taa kotu baa dei. Diꞌak liu o tama laleꞌan modi liman sorin dei, nosi o kona soe baa haꞌi naraka modi liman rua.” ");
INSERT INTO tet_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Hotu Yesus dale naꞌak, “Emi hatene tiꞌan ukun-badu naꞌak, ‘Ema mak soe feen, musti foo hakerek soe malu baa feto nia.’ ");
INSERT INTO tet_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mais Haꞌu katak nuneꞌe: Kalo laꞌen soe feen, mais feen la isin ida nakur biti-kluni, laꞌen nalo nia nakur biti-kluni tiꞌan. Kalo mane seluk nola feto nia, mane nia moos nakur biti-kluni.” ");
INSERT INTO tet_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Hotu Yesus dale naꞌak, “Emi hatene tiꞌan ukun-badu mak Naꞌi Maromak foo baa itakaan bei uluk sia naꞌak, ‘Kalo ema namate menon nodi narai aan temi Naꞌi Maromak naran, ema nia tatalik no mamenon nia tiꞌan.’ ");
INSERT INTO tet_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mais Haꞌu katak nuneꞌe: Keta harai aan hodi temi laleꞌan, tan laleꞌan nia, Naꞌi Maromak Niakaan tofatik. ");
INSERT INTO tet_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Keta harai aan hodi temi raiklaran, tan raiklaran nia, Naꞌi Maromak Niakaan tau ain fatik. Keta harai aan hodi temi Yerusalem, tan Yerusalem nia, Naꞌi Boot Niakaan kota. ");
INSERT INTO tet_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Keta harai aan hodi temi okaan ulun, tan okaan ulun nia la noo beran atu naruka fuuk lahon ida moos atu dadi metan lale mutin. ");
INSERT INTO tet_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kalo o makara mamate menon, katak dei maꞌak, ‘Tebes’. Kalo la makara, katak dei maꞌak ‘Lale’. Kalo maꞌak liu tan tenik, lia nia nahabut baa diabu.” ");
INSERT INTO tet_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Hotu Yesus dale naꞌak, “Emi hatene tiꞌan ukun-badu naꞌak, ‘Kalo ema nahaat okaan matan, mahaat sakar niakaan matan. Kalo ema nahonu okaan neꞌan, mahonu sakar niakaan neꞌan.’ ");
INSERT INTO tet_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mais Haꞌu katak nuneꞌe: Keta selu aat hodi aat. Kalo ema basa okaan hasan sorin, mabusik basa tenik sorin balu. ");
INSERT INTO tet_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kalo ema nalo lia baa o atu nola okaan faru, foo tenik okaan faru klobor baa. ");
INSERT INTO tet_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kalo sondadu seten o atu matiu niakaan naha toꞌo laꞌo kilo ida, matiu modi liu baa, toꞌo kilo rua. ");
INSERT INTO tet_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kalo ema nusu okaan naha ida, foo baa dei. Kalo ema beer nola hein okaan naha ida, foo baa dei.” ");
INSERT INTO tet_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Hotu Yesus dale naꞌak, “Emi rona tiꞌan ukun-badu naꞌak, ‘Madomi okaan maluk, mais hirus ema mak hirus o.’ ");
INSERT INTO tet_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mais Haꞌu katak nuneꞌe: Musti madomi ema mak hirus o, modi makroꞌan nebee Naꞌi Maromak natuun matak-malirin baa ema mak nasusar o. ");
INSERT INTO tet_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kalo o malo nunia, o matudu maꞌak, o neꞌe Ama iha laleꞌan Niakaan oan. Nia naseꞌi loro matan atu naksinak bodik ema diꞌak. Nia moos naseꞌi atu naksinak bodik ema aat. Nia natuun udan ween bodik ema mak nalo tuir Niakaan haruka, namutuk no ema mak sakar Niakaan haruka. ");
INSERT INTO tet_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kalo o madomi loos ema mak nadomi o, o maneo maꞌak Naꞌi Maromak musti selu matak-malirin baa o ka? Lale! Tan ema aat moos nadomi siakaan belu mak nadomi sia. ");
INSERT INTO tet_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kalo o foo loos dame baa okaan belu, niakaan saa mak liu? Tan ema mak la fiar baa Naꞌi Maromak moos nalo tuir nunia. ");
INSERT INTO tet_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hanoin! Okaan Ama iha laleꞌan nadomi ema hotu-hotu. O moos musti malo tuir nunia!” ");
INSERT INTO tet_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Hotu Yesus nanorin tenik naꞌak, “Hanoin! Keta tuir ukun-badu nebee ema tonu emi. Tan kalo halo nunia, emikaan Ama iha laleꞌan la selu sa-saa baa emi. ");
INSERT INTO tet_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kalo emi hakara tulun ema kiak sia, keta dale hamina aan iha ema waꞌin oin. Tan kalo halo nunia, emi halo tuir ema mak dale seluk, nalo seluk. Sia labu baa uma hamulak nebee ema tonun sia naꞌak, ‘Ema neꞌe, ema boot!’ Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Nodi netan tonun nunia, sia simu mohu siakaan saseban tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dadi, kalo emi hakara tulun ema kiak sia, keta katak baa se-see. ");
INSERT INTO tet_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hodi nunia, ema iha raiklaran la natene. Mais emikaan Ama iha laleꞌan natene saa mak emi halo no-nook nia. Nia nanis selu nikar baa emi.” ");
INSERT INTO tet_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Hotu Yesus dale naꞌak, “Baa oras emi hamulak, keta halo aan hanesan ema mak dale seluk, nalo seluk. Sia nakara baa labu iha dalan dahur, nodi nariik iha uma hamulak, nebee ema lear naree nodi tonun sia naꞌak, ‘Ema neꞌe, ema moos tebes!’ Mais rona! Nodi simu tonun nunia, sia simu mohu siakaan saseban tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Emi keta nunia. Oras hamulak, tama baa keꞌan laran, taka odamatan, foin hamulak no-nook baa emikaan Ama. Masik ema seluk la naree moos, emikaan Ama naree. Nia nanis selu baa emi. ");
INSERT INTO tet_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Oras hamulak, keta dale laleꞌu baa-mai. Tan ema mak la natene Naꞌi Maromak moos bele namulak nunia. Sia naneo naꞌak Naꞌi Maromak beer siakaan hamulak mak naru-naruk nia. ");
INSERT INTO tet_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Keta halo tuir sia! Masik emi sei la husu baa Ama iha laleꞌan moos, Nia natene tiꞌan saa mak emi buka. ");
INSERT INTO tet_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dadi kalo hamulak, tuir knaninuk neꞌe: ‘Amikaan Ama iha laleꞌan! Ita Boot naran mak lulik kaliuk. Nebee ema hotu-hotu foti-nahaas Ita Boot naran. ");
INSERT INTO tet_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nebee Ita Boot dadi Naꞌin bodik ema hotu-hotu! Nebee ema hotu-hotu nalo tuir Ita Boot harukan iha raiklaran, oin nudaar makbukar laleꞌan sia nalo tuir Ita Boot harukan iha laleꞌan. ");
INSERT INTO tet_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Foo baa ami haan mak toꞌo sura loron. ");
INSERT INTO tet_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Maluꞌa lakon amikaan salan, hanesan ami moos haluꞌa lakon salan mak ema nalo baa ami. ");
INSERT INTO tet_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Daka ami nebee ami keta halo aat. Sori ami mosi diabu niakaan aꞌaat. Tan Ita Boot beran kaliuk, makaꞌas kaliuk. Ita Boot mak kaer ukun hori nima-nimak toꞌo nima-nimak. Nunia tebes. Amen.’ ");
INSERT INTO tet_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Hanono diꞌa-diꞌak! Kalo emi haluꞌa lakon sala mak ema nalo baa emi, emikaan Ama iha laleꞌan moos atu naluꞌa lakon emikaan salan. ");
INSERT INTO tet_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mais, kalo emi la hoꞌuk haluꞌa lakon sala mak ema nalo baa emi, emikaan Ama moos la naluꞌa lakon emikaan salan.” ");
INSERT INTO tet_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Hotu Yesus dale naꞌak “Kalo emi hamulak hodi halirin aan, keta hakfinik oin hanesan ema mak dale seluk, nalo seluk. Sia nalo nunia, nebee ema tonun sia naꞌak, ‘Ema neꞌe, ema moon tebes!’ Mais rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Nodi simu tonun nunia, sia simu mohu siakaan saseban tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kalo emi halirin aan, haroꞌis halo moos, hodi sisi fuuk diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nodi nunia, ema mak naree emi la natene naꞌak, emi hoꞌi halirin aan. Mais emikaan Ama natene. Nia nanis selu baa emi.” ");
INSERT INTO tet_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Hotu Yesus dale naꞌak, “Keta serwisu makaꞌas atu libur sasoin iha raiklaran. Tan fuhuk no besi teen bele nahaat sasoin nia. Ema naꞌok moos bele sobu, foti nodi baa. ");
INSERT INTO tet_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Diꞌak liu emi serwisu makaꞌas atu libur sasoin iha laleꞌan. Iha nebaa, fuhuk no besi teen la bele nahaat. Ema naꞌok moos la bele mai sobu nodi baa. ");
INSERT INTO tet_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Emi rai emikaan sasoin iha nabee, emikaan neon moos nanis nakriꞌit aan iha nebaa.” ");
INSERT INTO tet_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Hotu Yesus dale naꞌak, “Ema matan, hanesan badut mak naroma neon laran. Kalo matan nakroma, nia laꞌo tuir dalan loos, hanesan ema mak laꞌo iha kroman. ");
INSERT INTO tet_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mais, kalo matan babaur, nia la laꞌo tuir dalan, hanesan ema mak laꞌo lemas aan iha makukun. Kalo kroman iha emikaan neon laran makukun tiꞌan, neꞌe naꞌak emi moris iha makukun.” ");
INSERT INTO tet_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hotu Yesus dale naꞌak, “Ema ida la bele serwisu bodik ulun naꞌin rua, tan nia nanis beer ida, taliꞌur ida. Kalo ita hanaꞌi baa osan, ita la fatan haꞌak Naꞌi Maromak mak itakaan Naꞌin. ");
INSERT INTO tet_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Haꞌu katak nuneꞌe: Lalika malau aan modi neo-neon maꞌak, ‘Haꞌu atu kmoris oin nunabee? Haꞌu atu kaa saa, atu kemu saa, atu ktau saa?’ Emi haneo haꞌak moris nia bodik haa dei ka? Isin moos, bodik tau faru dei ka? Lahoos nunia. ");
INSERT INTO tet_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Haree kokon manu ai leten sia mak semo iha kaloꞌan. Sia la nalau aan atu kuda no kuꞌu. Sia la rai haan iha kanaha uman. Mais emikaan Ama iha laleꞌan naliku sia nohuun. Nia nanis bele naliku emi diꞌak liu nosi sia tenik. Hanoin diꞌa-diꞌak, tan Nia nafoli emi liu tan manu ai leten sia. ");
INSERT INTO tet_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kalo ema nariik iha lalenok oin, hotu nalau aan no niakaan isin lolon, nia bele nalo niakaan isin hetak aas ka? La bele! ");
INSERT INTO tet_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kalo la bele, tan saa emi neo-neon atu hatais saa? Baa haree kokon ai funan sia iha hae molik. Sia la niri kabas, la soru tais. ");
INSERT INTO tet_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mais hanono diꞌa-diꞌak! Naꞌi Soleman niakaan isi belun mak kabaas basuk moos, la bele liu ai funan nia siakaan kabaas. ");
INSERT INTO tet_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Naꞌi Maromak rai neon baa ai funan mak moris baa ohin loron, mais awan mate, hotu ema soe baa haꞌi. Kalo Nia rai neon nunia, Nia nanis natais emi liu tan ai funan nia sia. Dadi, tan saa emi la fiar tebe-tebes baa Nia? ");
INSERT INTO tet_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lalika neo-neon haꞌak, ‘Ita atu haa saa? Atu hemu saa? Atu tau saa?’ ");
INSERT INTO tet_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ema mak la fiar baa Naꞌi Maromak narui aan atu buka lia nia sia hotu-hotu. Mais emi keta nunia, tan emikaan Ama iha laleꞌan natene hotu-hotu mak emi buka. ");
INSERT INTO tet_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mais emi musti halaꞌo uluk Niakaan serwisu no tuir uluk Niakaan ukun lai, foin Nia foo tuꞌan lia hotu-hotu mak emi buka. ");
INSERT INTO tet_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tan lia nia, keta neo-neon baa saa mak emi buka bodik awan. Tan awan noo niakaan halau aan duꞌuk. Susar ohin loron neꞌe, toꞌo tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Hotu Yesus dale naꞌak, “Keta tula lia baa ema, nebee Naꞌi Maromak la tula lia baa emi. ");
INSERT INTO tet_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Emi hafoli ema seluk oin nunabee, Naꞌi Maromak moos nafoli emi oin nunia. Emi sukat ema seluk salan oin nunabee, Naꞌi Maromak moos atu sukat emi oin nunia. ");
INSERT INTO tet_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tan saa emi hatadan ema seluk salan kiꞌik, mais emikaan salan boot, emi filak la noo? Nudaar emi haree rai ahun musan iha maluk matan. Mais ai baluk boot ida mak neli emikaan matan, emi la horan. ");
INSERT INTO tet_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Oin nunabee emi bele dale haꞌak, ‘Belu! Mai nebee haꞌu koꞌas kasai rai ahun nia kosi okaan matan.’ Emi dale nunia, mais emi duꞌuk la bele haree, tan ai baluk sara natoos emikaan matan. ");
INSERT INTO tet_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Etuk oin, emi neꞌe huun oin-kotuk tebes! Foti soe ai baluk nia hosi emikaan matan lai, nebee bele haree hikar, foin hoꞌas rai ahun nia hosi belun matan. ");
INSERT INTO tet_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Keta hanorin lia moon hosi Naꞌi Maromak bodik ema maleuk teen sia. Sia nia, hanesan asu krakat mak atu tata fila emi. Sia moos beik nuꞌu fahi. Kalo ema foo henu mahoo folin baa, fahi la titu! Nia sama loos dei.” ");
INSERT INTO tet_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Hotu Yesus dale naꞌak, “Oras hamulak, kalo hakroꞌan bei-beik baa Naꞌi Maromak; Nia nanis foo. Kalo buka bei-beik; Nia nanis natudu dalan. Kalo bolu bei-beik; Nia nanis loke odamatan. ");
INSERT INTO tet_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ema mak nakroꞌan bei-beik baa Naꞌi Maromak, nanis simu. Ema mak buka bei-beik, nanis netan. Ema mak bolu bei-beik, nanis Nia loke odamatan. ");
INSERT INTO tet_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hanoin kokon! Kalo oan nusu tubi, aman foo fatuk ka? Lale! ");
INSERT INTO tet_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kalo nusu naꞌan tasi, ama foo samea ka? Lale! ");
INSERT INTO tet_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Emikaan Ama iha laleꞌan, laran diꞌak tebes. Kalo emi ema raiklaran mak nalo aat sei nakara foo buat diꞌak baa oan, nuꞌu saa tenik emikaan Ama! Nia nanis foo saa mak emi husu. ");
INSERT INTO tet_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Saa mak emi hakara ema seluk nalo bodik emi, emi musti halo nunia bodik nia. Lia neꞌe, lia tatuur nosi lia hotu-hotu mak Bei Musa no Maromak makoꞌan seluk sia nanorin kedan hori uluk aan.” ");
INSERT INTO tet_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Hotu Yesus dale naꞌak, “Kalo ema beer tama laleꞌan, musti laꞌo tuir odamatan mak loot. Ema lear nakara laꞌo tuir dalan mak maus, no odamatan maluak. Mais sintidu, tan dalan oin nunia, nodi ema baa moris dodok. ");
INSERT INTO tet_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ema mak beer tama laleꞌan musti laꞌo tuir dalan mak susar no tama tuir odamatan mak loot. Masik ema naꞌin hira dei mak laꞌo tuir nia moos, dalan loot nia mak nodi ema baa Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Hotu Yesus dale naꞌak, “Sintidu ho ema maktolek teen mak asu fanu naꞌak, sia Maromak makoꞌan. Sia nalo aan diꞌak nuꞌu bibi malae. Mais tuir loos, sia ema aat nuꞌu asu fuik mak mai folan bibi malae. ");
INSERT INTO tet_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Emi bele hatene ema oin nunia sia nuneꞌe: haree loos saa mak sia nalo, hanesan emi haree ai fuan atu hatene fuan nia nosi ai huun nabee. Ita hatene fuan diꞌak, la sai nosi huun aat. ");
INSERT INTO tet_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kalo huun diꞌak, fuan diꞌak. Huun aat, fuan aat. ");
INSERT INTO tet_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Huun diꞌak la nafua fuan aat. Nunia moos, huun aat la nafua fuan diꞌak. ");
INSERT INTO tet_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ai huun mak nafua fuan aat, nanis ema mai nuꞌan nola, soe baa haꞌi. ");
INSERT INTO tet_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Emi moos bele hatene makoꞌan tolek teen nia sia, hosi siakaan hahalok.” ");
INSERT INTO tet_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Hotu Yesus dale naꞌak, “Ema waꞌin temi Haꞌu naꞌak, ‘Ita Boot!’ nudaar Haꞌu neꞌe, tebe-tebes siakaan Ulun. Mais sia temi iha ibun dei. Nosi ikus, Naꞌi Maromak iha laleꞌan atu dudu sai sia. Hela mesan ema mak tuir tebe-tebes Niakaan hakara mak Nia simu nola dadi baa Niakaan ema. ");
INSERT INTO tet_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Baa oras rai falu fila, ema waꞌin atu katak sain naꞌak, Haꞌu neꞌe siakaan Ulun. Sia atu namaus Haꞌu naꞌak, ‘Ita Boot! Ami baa keke lema tiꞌan Itakaan hanorin. Ami teꞌur sai diabu sia hodi Itakaan naran. Ami moos haseꞌi tadak blaar oi-oik hodi Itakaan beran.’ ");
INSERT INTO tet_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Masik sia namaus Haꞌu bei-beik moos, Haꞌu atu kataa sia kaꞌak, ‘Emi neꞌe see? La katene emi! Emi la moris tuir Naꞌi Maromak hakaran. Sees hosi neꞌe!’ ” ");
INSERT INTO tet_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Hotu Yesus dale naꞌak, “Ema mak nanono baa Haꞌu nodi nalaꞌo Haꞌukaan dalen, ema nia hanesan ema matenek mak nariik uma iha tatuur fatuk leten. ");
INSERT INTO tet_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kleu-leur udan boot tuun toꞌo motasaꞌe. Anin makaꞌas moos basak uma nia, mais la nakroꞌon tan nariik iha tatuur fatuk monas leten. ");
INSERT INTO tet_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ema mak nanono baa Haꞌu mais la nalaꞌo Haꞌukaan dalen, ema nia hanesan ema beik mak nariik uma baa raihenek. ");
INSERT INTO tet_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kleu-leur udan boot tuun toꞌo motasaꞌe. Anin makaꞌas moos basak uma nia, toꞌo nakroꞌon hotu.” ");
INSERT INTO tet_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus dale notu nunia, ema hotu-hotu moos blaar karin, ");
INSERT INTO tet_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tan Nia natene tebe-tebes hanorin nia isin. Niakaan hanorin lalaꞌok la manesak no siakaan ema manorik sia. ");
INSERT INTO tet_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nunia hotu, Yesus tuun nosi foho kiꞌik nia. Ema lear moos baa tuir Nia. ");
INSERT INTO tet_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Teki-tekis, ema ida mak moras funi mea mai nasoru Yesus. Ema nia nakniꞌa, hotu nusu baa Yesus naꞌak, “Ama Boot! Tulun haꞌu lai! Kalo Ita Boot hakara, Ita bele halakon moras neꞌe, nebee ema keta nakribi haꞌu ona.” ");
INSERT INTO tet_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Rona nola nunia, Yesus lolo liman baa, kaer ema moras funi mea nia, nodi dale naꞌak, “Haꞌu kakara. O diꞌak ona!” Teki-tekis, moras nia lakon kedas. ");
INSERT INTO tet_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hotu Yesus katak baa ema nia naꞌak, “Manoin! O diꞌak tiꞌan, mais keta katak baa se-see o! Musti malaꞌo uluk ukun nosi Bei Musa lai. Baa naꞌilulik, hotu musu nebee nia leno okaan isin, atu natene okaan moras lakon tebes ka sei. Hotu musti matetu sera nebee ema hotu-hotu natene naꞌak, o diꞌak tebes tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hotu Yesus tama baa leo Kapernaum. Iha nia, sondadu ulun Roma ida mai nusu tulun naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ama Boot! Haꞌukaan ema serwisu ida moras todan iha uma. Nia la bele nadeer nosi toba fatin ona, tan nia susar basuk.” ");
INSERT INTO tet_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus nataa naꞌak, “Diꞌak! Haꞌu atu kbaa kadiꞌak kola nia.” ");
INSERT INTO tet_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mais sondadu ulun nia naꞌak, “Ama Boot! Ita Boot lalika hakole aan mai ona, tan haꞌu la kfatan simu Ita Boot iha haꞌukaan uma. Surak Ita Boot dale hosi neꞌe dei, nia diꞌak kedan. ");
INSERT INTO tet_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Haꞌu katene lia neꞌe, tan haꞌukaan ulun sia noo beran atu naruka haꞌu. Haꞌu moos koo beran atu karuka haꞌukaan sondadu sia. Kalo karuka haꞌukaan ain-liman sia kaꞌak, ‘Baa nebaa!’ nanis sia baa. Kalo kaꞌak, ‘Mai neꞌe!’ nanis sia mai. Tenik, kalo karuka ema serwisu sia kaꞌak, ‘Serwisu neꞌe!’ nanis sia nalo nunia. Dadi, surak Ita Boot dale dei, nanis haꞌukaan ema nia diꞌak kedan.” ");
INSERT INTO tet_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Rona nola nunia, Yesus moos blaar. Nia dale baa ema lear mak tuir Nia naꞌak: “Haꞌu kblaar! Kleur tiꞌan nuneꞌe, Haꞌu la kasoru ema Yahudi ida mak fiar biit manesak no ema Roma neꞌe! ");
INSERT INTO tet_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Rona! Ema matak waꞌin manesak no ema Roma neꞌe. Sia atu mai nosi lorosaꞌe no loromonu atu tuur naa nodi nadahur bele-bele no Bei Abraham, Bei Isak, Bei Yakob no Naꞌi Maromak Niakaan ema seluk sia iha laleꞌan. ");
INSERT INTO tet_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tuir loos, Naꞌi Maromak boi tiꞌan ema Yahudi dadi baa Niakaan ema, mais balu la titu Nia. Nosi ikus, Nia atu dudu sees sia baa fatin makukun. Iha nia, sia noran susar basuk nodi tanis la nanawa.” ");
INSERT INTO tet_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dale notu nunia, Yesus naruka sondadu ulun nia naꞌak, “Ama fila ona. Ama eman nia diꞌak tiꞌan, tuir ama niakaan fiar.” Baa oras nia moos, ema nia diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Baa loron ida, Yesus baa Petrus uman. Nia naree Petrus banin feto toba iha toba fatin, tan moras kiki. ");
INSERT INTO tet_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus kaer ferik nia liman, moras nia moos lakon kedas. Hotu ferik nia nadeer, baa naliku Yesus. ");
INSERT INTO tet_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Baa oras loro atu monu, ema mai nodi siakaan ema mak diabu tekar. Hotu Yesus teꞌur sai diabu naꞌak, “Hoi diabu! Sai mosi ema neꞌe!” Hotu diabu sia sai kedas. Yesus moos nadiꞌak nola ema moras hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nia nalo lia neꞌe sia hotu-hotu atu natoꞌo saa mak Maromak makoꞌan Yesaya nakerek kedan hori uluk naꞌak, “Nia nadiꞌak nola itakaan moras. Nia moos natiu nola itakaan susar.” ");
INSERT INTO tet_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nunia hotu, Yesus naree ema lear mai nalik Nia. Nia naruka Niakaan maktuir sia naꞌak, “Mai ita hodi bero baa debu balu baa.” ");
INSERT INTO tet_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sia atu baa, ema ida mai baa Yesus. Ema nia, manorik ukun Yahudi. Nia dale baa Yesus naꞌak, “Ama Manorik! Ama atu baa nabee dei, haꞌu atu ktuir Ama!” ");
INSERT INTO tet_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mais Yesus nataa naꞌak, “Diꞌak! Mais manoin nuneꞌe. Ema hotu-hotu noo siakaan hein fatin. Asu fuik fila baa kuak. Manu ai leten fila baa knuuk. Mais Haꞌu neꞌe, Ema Raiklaran Isin Nosi Laleꞌan. Haꞌu la koo uma atu kfila baa. Kluni bodik ulun moos, la koo.” ");
INSERT INTO tet_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hotu ema ida seluk mak tuir Yesus mai nusu naꞌak, “Ama Boot! Haꞌu moos kakara tuir Ita Boot, mais habusik haꞌu kfila baa babilan ema matas sia lai. Kalo haꞌukaan ama mate ona, foin haꞌu kfila mai tuir Ita Boot.” ");
INSERT INTO tet_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mais Yesus nataa naꞌak, “Nuneꞌe! Mabusik ema mak la fiar Naꞌi Maromak babilan siakaan ema maten. Kalo makara tuir Haꞌu, tuir kedas ona!” ");
INSERT INTO tet_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nunia hotu, Yesus saꞌe baa bero laran bele-bele no Niakaan maktuir sia. ");
INSERT INTO tet_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Laꞌo tiꞌan, Yesus toba. La kleur, anin dadurus mai. Laloran boot moos mai toꞌo wee tama bero laran. ");
INSERT INTO tet_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Naree nunia, maktuir sia baa fanun nadeer Yesus naꞌak, “Ama Boot! Hadeer! Mai sori ami lai! Ita atu mate mout mak neꞌe ona!” ");
INSERT INTO tet_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mais Yesus katak naꞌak, “Hoi! Tan saa emi hataꞌuk nuneꞌe? La fiar baa Haꞌu ka?” Hotu Nia nadeer, nakahik anin no laloran nia naꞌak, “Manawa ona!” Laloran no anin nia moos nakmatek kedas. ");
INSERT INTO tet_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Naree nunia, Yesus Niakaan maktuir sia blaar nodi naꞌak, “Nia neꞌe see?! Oin nunabee toꞌo Nia bele naruka anin no laloran tuir Niakaan hakara!?” ");
INSERT INTO tet_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","La kleur falik, sia toꞌo debu balu baa, iha ema Gadara rain. Iha nia, noo ema naꞌin rua mak diabu tekar. Sia nein iha fatuk kuak mak ema maten fatin. Sia krakat aat basuk, toꞌo la noo ema ida moos naksakar aan laꞌo tuir fatin nia. Baa oras ema rua nia naree Yesus mai, ");
INSERT INTO tet_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","sia nahii naꞌak, “Hoi! Naꞌi Maromak Oan! Tan saa O mai koen ami? Oras atu kastikar ami, sei la toꞌo dauk!” ");
INSERT INTO tet_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","La dook nosi nia, fahi lear noꞌi sosok rai, buka haan. ");
INSERT INTO tet_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Diabu nia sia nusu baa Yesus naꞌak, “Maruka ami tama baa fahi nia sia dei!” ");
INSERT INTO tet_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus moos naruka diabu nia sia naꞌak, “Baa ona!” Hotu diabu nia sia sai nela ema naꞌin rua nia, tama baa fahi nia sia. Fahi nia sia hotu-hotu bula, nalai lakon tuun nosi foho nia, tama baa debu boot laran. Hotu mate mout. ");
INSERT INTO tet_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Titu-naree nunia, ema makdaka fahi nia sia nalai fila baa leo laran, hotu nasara lia nia. ");
INSERT INTO tet_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Rona sia dale nunia, ema lear sai baa fatin nia baa nasoru Yesus. Hotu sia dedes nebee Nia laꞌo nela siakaan rai nia. ");
INSERT INTO tet_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nunia hotu, Yesus sia saꞌe nikar bero atu baa Yesus Niakaan leo duꞌuk iha debu balu baa. ");
INSERT INTO tet_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Toꞌo nebaa, ema loi nodi siakaan maluk ai kmaꞌas ida, mai baa Nia. Naree nunia, Yesus natene sia fiar naꞌak Nia bele nadiꞌak nola siakaan maluk nia. Hotu Yesus dale baa ema kmaꞌas nia naꞌak, “Oa! Makbiit neon. Haꞌu kasu mohu okaan salan sia tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Baa oras nia, ema manorik ukun Yahudi naꞌin hira iha nia. Rona nola Yesus dale nunia, sia laran namanas kedas. Sia dale baa malu naꞌak, “Ema neꞌe naksakar aan liu resik! Naꞌi Maromak mesan mak bele kasu ema salan. Ema neꞌe nahaat Naꞌi Maromak tiꞌan, tan nalo aan nuꞌu Naꞌi Maromak!” ");
INSERT INTO tet_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mais Yesus natene siakaan neon laran. Nia dale naꞌak, “Tan saa emi haneo haꞌak Haꞌu kahaat Naꞌi Maromak? ");
INSERT INTO tet_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Haꞌu neꞌe, Ema Raiklaran Isin nosi laleꞌan. Kalo haꞌu katak baa ema neꞌe kaꞌak, ‘Haꞌu kasu mohu okaan salan sia tiꞌan’ emi la haree haꞌukaan beran. Mais, kalo Haꞌu katak baa nia kaꞌak, ‘madeer ona’ hotu nia nadeer kedas, emi bele haree duꞌuk no bele hatene duꞌuk Haꞌukaan beran atu kasu ema salan.” Hotu Yesus naruka ema kmaꞌas nia naꞌak, “Madeer! Foti toba fatin, fila ona!” ");
INSERT INTO tet_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hotu ema kmaꞌas nia nadeer kedas, laꞌo fila nikar. ");
INSERT INTO tet_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Naree nunia, ema hotu-hotu blaar. Sia dale foti-nahaas Naꞌi Maromak naran naꞌak, “Naꞌi Maromak makaꞌas liu resik toꞌo foo beran nuneꞌe baa ema raiklaran.” ");
INSERT INTO tet_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hotu Yesus laꞌo baa fatin seluk. Iha nia, noo ema ida naran Mateus. Niakaan serwisu, sisi bea. Oras Yesus naree nia iha niakaan serwisu fatin, Yesus bolu nia naꞌak, “Mai tuir Haꞌu!” Rona nola nunia; Mateus moos nariik, tuir kedas Yesus. ");
INSERT INTO tet_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hotu Mateus sale Yesus sia mai naa iha niakaan uma. Nia moos sale niakaan mamaluk maksisi bea sia no bainaka seluk sia, nebee mai naa bele. ");
INSERT INTO tet_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mais ema naꞌin hira nosi partee Farisi mai nakusuk baa Yesus Niakaan maktuir sia naꞌak, “Tan saa emikaan ulun tuur naa namutuk no ema folin lalek sia, nuꞌu maksisi bea no siakaan mamaluk aat sia?” ");
INSERT INTO tet_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mais Yesus katak baa sia naꞌak, “Ema moras, buka makdook. Mais ema isin diꞌak, la buka makdook. ");
INSERT INTO tet_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Diꞌak liu emi fila baa leno diꞌa-diꞌak Maromak Manfatin mak uluk makoꞌan Hosea nakerek naꞌak, ‘Haꞌu kakara nebee Haꞌukaan ema sia nadomi malu no dodan malu. Kalo sia la nalo nunia, sera tunun mak sia nodi natetu baa Haꞌu la noo folin saa ida.’ Naꞌi Maromak katak tebes nunia. Tan lia nia, Haꞌu la kmai kaliku ema mak filak aan ema loos tiꞌan. Haꞌu kmai atu kaliku ema maksalan mak nakara buka moris loos.” ");
INSERT INTO tet_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baa oras nia, ema mak tuir Yohanis Mak Sarani Ema mai baa Yesus nodi nusu naꞌak, “Ami mak tuir Yohanis halirin aan nanis. Ema Farisi sia moos nalirin aan. Mais, tan saa Ama Niakaan maktuir sia naa-nemu bei-beik? Sia la natene nalirin aan ka?” ");
INSERT INTO tet_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mais Yesus nataa nodi lia hatetek naꞌak, “Nuneꞌe. Oras dahur hola malu, bainaka sia la nalirin aan. Sia naa toꞌo bosu. Kalo sasudin mane sei iha nia, nanis sia hotu-hotu naa bele-bele. Mais, kalo dala ida, ema seluk kohi nodi sasudin mane nia, niakaan mamaluk sia noran susar. Baa oras nia, foin sia nalirin aan. ");
INSERT INTO tet_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kalo faru naksira, ita la hola tais foun rohan ida, hodi baban hikar baa faru tuan mak naklees nia. Tan kalo ita fasi, tais foun nia nanis nakruꞌu, nalo faru tuan nia hetak naklees. ");
INSERT INTO tet_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nunia moos, ita la salin tua foun baa knaban tuan. Tan knaban tuan nia atu naksira, hotu tua ween nanii mohu. Musti salin tua ween foun baa knaban foun, nebee metin diꞌa-diꞌak!” Nodi nunia, Yesus nanorin naꞌak Niakaan hanorin nia, hanorin foun. Keta kahur no hanorin tuan. ");
INSERT INTO tet_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iha nia, noo ema uma hamulak ulun ida. Baa oras Yesus sei dale no Yohanis niakaan maktuir sia, nia mai nasoru Yesus. Nia nakniꞌa iha Yesus oin nodi nusu naꞌak, “Ama! Tulun lai! Haꞌukaan oan feto foin mate. Ita Boot tulun rai liman baa nia, nebee bele moris nikar.” ");
INSERT INTO tet_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Rona nola nunia, Yesus no Niakaan maktuir sia tuir kedas ema nia. ");
INSERT INTO tet_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Iha dalan klaran, noo feto ida. Tinan sanulu resin rua tiꞌan, feto nia netan fulan la nanawa tuir loos. Nia moos laꞌo tuir Yesus sia nodi naneo naꞌak, “Surak haꞌu koko loos Yesus farun dei moos, haꞌu kbele diꞌak.” Tan nia, nia baa koko Yesus faru ninin. ");
INSERT INTO tet_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Oras Yesus noran nola, Nia mana atu naree feto nia. Nia moos dale naꞌak, “Bii! Makbiit okaan neon. Tan o fiar tebe-tebes baa Haꞌu, o diꞌak tiꞌan.” Baa oras nia moos, feto nia diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hotu Yesus sia laꞌo liu baa uma hamulak ulun uman. Toꞌo nebaa, Nia tama baa naree ema tanis naroꞌan aan no ema nuu kfui, tuir siakaan adat ema maten. ");
INSERT INTO tet_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Naree nunia, Yesus dale baa sia naꞌak, “Hanawa tanis ona. Fila ona, tan lawarik neꞌe la mate. Nia toba dei.” Rona Yesus dale nunia, sia nanasa nodi nakmulis ibun baa Nia. ");
INSERT INTO tet_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Oras ema nia sia sai mohu tiꞌan, Yesus tama baa lawarik nia keꞌan, hotu kaer baa liman. Lawarik nia moos moris nikar kedas. ");
INSERT INTO tet_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Naree nola nunia, ema katak nasirin rai-rai nosi lia saa mak Yesus nalo tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hotu Yesus laꞌo liu. Iha dalan klaran, noo ema matan delek naꞌin rua. Sia laꞌo tuir Yesus nodi nahii naꞌak, “Naꞌi Daud husar-binan! Madomi ami lai!” ");
INSERT INTO tet_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hotu Yesus tama baa uma ida, ema matan delek naꞌin rua nia moos tuir mai. Hotu Yesus nusu sia naꞌak, “Emi fiar tebe-tebes haꞌak Haꞌu koo beran atu kalo emi bele haree ka?” Sia moos nataa naꞌak, “Aikee! Lia nia Ama lalika nusu ona.” ");
INSERT INTO tet_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Rona nola nunia, Yesus koko siakaan matan nodi dale naꞌak, “Kalo nunia, nebee dadi tuir emikaan fiar!” ");
INSERT INTO tet_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus dale notu nunia, sia moos bele naree kedas. Mais Yesus katak baa sia nodi makaꞌas naꞌak, “Hanoin! Keta katak baa se-see nosi saa mak dadi tiꞌan neꞌe!” ");
INSERT INTO tet_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mais sia la bele neti neon. Sia laꞌo nasirin rai nia nodi keke lema lia Yesus Niakaan hahalok nia. ");
INSERT INTO tet_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Delek naꞌin rua nia sai tiꞌan, ema nodi tenik ema ida seluk mai baa Yesus. Ema nia nunuk, tan diabu tekar. ");
INSERT INTO tet_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Naree nola nunia, Yesus naruka diabu sai nela ema nia. Diabu sai tiꞌan, ema nia moos dale kedas. Hotu ema lear iha nia blaar karin naꞌak, “Aikee! Ita ema Yahudi foin haree nuneꞌe!” ");
INSERT INTO tet_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Masik nunia moos, ema Farisi sia noran la diꞌak. Hotu sia dale naꞌak, “Diabu ulun mak foo beran baa Nia, foin Nia bele teꞌur sai diabu.” ");
INSERT INTO tet_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hotu Yesus laꞌo nasirin kota no leo waꞌin, nodi nanorin iha uma hamulak sia. Nia nanorin ema nosi Naꞌi Maromak Manfatin Diꞌak, no oin nunabee sia bele tama dadi baa Niakaan hutun-renu. Nia moos nadiꞌak nola ema moras sia, no ema mak isin la diꞌak sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Naree ema lear nia sia, Yesus dodan sia tan sia la natene atu nalo nunabee tenik. Sia hotu-hotu hanesan bibi malae mak la noo makbalin. ");
INSERT INTO tet_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hotu Yesus dale baa Niakaan maktuir sia naꞌak, “Ema lear neꞌe, nuꞌu toꞌos isin. Toꞌos isin waꞌin tiꞌan, mais ema serwisu la toꞌo atu kuꞌu nola toꞌos isin nodi rai baa kanaha uman. ");
INSERT INTO tet_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tan lia nia, emi musti husu baa Toꞌos Naꞌin, nebee Nia solok ema serwisu atu baa libur nola Niakaan toꞌos isin.” ");
INSERT INTO tet_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nunia hotu, Yesus bolu nola maktuir naꞌin sanulu resin rua atu libur malu. Nia latan beran baa sia atu teꞌur sai diabu, nodi nadiꞌak nola ema moras oi-oik. ");
INSERT INTO tet_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Maktuir naꞌin sanulu resin rua mak Nia boi nia atu dadi baa Niakaan klosan, siakaan naran mak neꞌe: Mak dala uluk, naran Simon (nia mak ema temi naꞌak ‘Petrus’), no alin, naran Andreas. Hotu Yakobus no alin, naran Yohanis (sia naꞌin rua nia, Sebadeus oan). ");
INSERT INTO tet_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Noo tenik Filipus no Bartolomeus. Hotu Tomas no Mateus (ema maksisi bea). Hotu Yakobus (Alfeus oan) no Tadeus. ");
INSERT INTO tet_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Hotu Simon (mak tuir partee politik Selot) no Yudas Iskariot (nosi ikus, nia mak faꞌan lakon Yesus). ");
INSERT INTO tet_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Nunia hotu, Yesus solok Niakaan maktuir naꞌin sanulu resin rua nia nodi naruka naꞌak, “Haꞌu ksolok emi baa itakaan ema Yahudi sia tan sia waꞌin la tuir Naꞌi Maromak dalan. Sia hanesan bibi malae mak laꞌo sala dalan. Tan lia nia, emi musti baa sia dei. Keta baa ema seluk nuꞌu ema Samaria. ");
INSERT INTO tet_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Baa katak haꞌak, ‘Naꞌi Maromak Niakaan oras toꞌo tiꞌan, nebee ema hotu-hotu bele tama dadi baa Niakaan hutun-renu.’ ");
INSERT INTO tet_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Baa hadiꞌak hola ema moras, halo ema maten moris nikar, hadiꞌak hola ema moras funi mea, no teꞌur sai diabu sia. Naꞌi Maromak foo waꞌin baa emi tiꞌan, mais Nia la nusu nikar sa-saa. Tan lia nia, oras neꞌe emi musti baa foo waꞌin baa ema seluk sia, mais lalika husu hikar sa-saa. ");
INSERT INTO tet_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Baa laꞌo tanan dei. Lalika hodi osan, ");
INSERT INTO tet_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","bakae, tais selu, kaso, lale ai knoꞌan. Tan ema musti foo baa ema serwisu, saa mak sia fatan simu. ");
INSERT INTO tet_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kalo emi tama baa kota, lale baa leo, buka ema mak nakara simu emi. Hotu hein iha nia toꞌo laꞌo hela. ");
INSERT INTO tet_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kalo tama baa ema uman, hasee sia haꞌak, ‘Dame!’ ");
INSERT INTO tet_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kalo sia simu emi diꞌa-diꞌak, hakroꞌan nebee Naꞌi Maromak natuun matak-malirin baa sia. Mais, kalo sia la simu emi, Naꞌi Maromak moos la natuun matak-malirin baa sia. ");
INSERT INTO tet_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kalo ema la noꞌuk nanono baa emi, sai hosi uma nia, lale kota nia. Hotu hisik hela ahukresan hosi emikaan ain atu dadi baa tadak naꞌak, sia naꞌin nataa duꞌuk baa siakaan hahalok. ");
INSERT INTO tet_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nosi ikus, kalo Naꞌi Maromak natuun kastikar baa ema raiklaran neꞌe, nanis Nia natuun kastikar todan baa ema Sodom no ema Gomora mak uluk aat basuk nia. Mais rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Naꞌi Maromak atu natuun kastikar todan liu tan tenik baa ema mak la noꞌuk simu emi.” ");
INSERT INTO tet_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Hanoin! Haꞌu ksolok emi hanesan Haꞌu ksolok bibi malae baa asu fuik krakat leet. Tan lia nia, emi musti hodi kakutak hanesan samea matenek. Emikaan neon moos musti loos hanesan manu lakateu sina mak la natene buka lia. ");
INSERT INTO tet_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sintidu, tan ema atu naloot emi hanesan asu fuik krakat tata noꞌo bibi malae. Sia atu dada nodi emi baa moon-metan fatin. Sia moos atu taꞌe emi iha uma hamulak laran sia. ");
INSERT INTO tet_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sia atu dada nodi emi baa hataa gubernur no naꞌin sia tan tuir Haꞌu. Mais emi musti hodi leet nia atu katak baa sia hosi Haꞌu. Hodi nunia, ema mak la natene Naꞌi Maromak moos bele rona lia nosi Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Baa oras sia dada nodi emi nunia, emi lalika hataꞌuk haꞌak, ‘Haꞌu atu kdale kaꞌak saa? Haꞌu atu kataa kaꞌak saa?’ Lalika hataꞌuk nunia, tan toꞌo baa niakaan oras, emikaan Ama iha laleꞌan atu katak lia saa mak emi musti dale. ");
INSERT INTO tet_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Baa oras nia, saa mak emi dale, la nahabut baa emi duꞌuk, mais nahabut baa Naꞌi Maromak Kmalar Lulik mak atu nanorin emi atu dale saa. ");
INSERT INTO tet_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Emi lei haree! Kalo noo ema mak fiar baa Haꞌu iha uma ida laran, niakaan maun-biin-alin duꞌuk atu buka dalan noꞌo nia. Kalo oan fiar, niakaan ama mak buka dalan noꞌo nia. Kalo inan-aman fiar, siakaan oan duꞌuk mak buka dalan noꞌo sia. ");
INSERT INTO tet_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lei haree! Ema hotu-hotu atu hirus emi tebe-tebes tan tuir Haꞌu. Mais ema mak naterus aan bei-beik toꞌo mohu, Naꞌi Maromak atu sori nia. ");
INSERT INTO tet_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kalo ema naloot emi iha kota ida, hiꞌit aan halai baa kota seluk. Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Haꞌu neꞌe, Ema Raiklaran Isin nosi laleꞌan. Emi sei la laꞌo hasiri mohu dauk kota hotu-hotu iha rai Israꞌel neꞌe, mais Haꞌu kmai kikar tiꞌan. Nunia tebes! ");
INSERT INTO tet_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kalo ema la nakara ema manorik ida, sia moos la nakara niakaan maktuir sia. Kalo ema la nakara ema boot ida, sia moos la nakara niakaan ema serwisu sia. ");
INSERT INTO tet_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kalo maktuir nanorin aan toꞌo matenek manesak no niakaan ema manorik, nia noran toꞌo tiꞌan. Kalo ema serwisu nanorin aan toꞌo matenek manesak no niakaan ulun, nia moos noran toꞌo tiꞌan. Hanoin! Kalo ema dale nahaat uma ida naꞌin naꞌak, ‘O neꞌe Baalsebul mak diabu ulun!’ ema uma laran moos nanis netan naran aat liu tan.” ");
INSERT INTO tet_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Hotu Yesus dale baa Niakaan maktuir sia naꞌak, “Lalika hataꞌuk baa ema mak sakar emi. Nosi ikus, lia mak oras neꞌe sei subar, ema hotu-hotu atu natene. ");
INSERT INTO tet_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lia mak haꞌu kanorin baa emi mesan, emi musti katak baa ema hotu-hotu. Lia mak Haꞌu katak no-nook baa emi, emi musti katak hasirin fatin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Keta hataꞌuk ema raiklaran. Masik sia bele noꞌo emi moos, sia la bele noꞌo emikaan kmalar. Musti hataꞌuk Naꞌi Maromak dei, tan Nia mesan mak noo beran atu natama emikaan isin no kmalar baa haꞌi naraka. ");
INSERT INTO tet_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Emi musti hakbiit neon. Ema faꞌan manu harek nodi folin kmaan basuk. Mais la noo manu ida kois mak monu mate, kalo emikaan Ama iha laleꞌan la foo leet. ");
INSERT INTO tet_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Emikaan Ama iha laleꞌan moos lituk emi toꞌo lia mak kiꞌik oan basuk sia. Emikaan fuuk lahon iha ulun moos, Nia sura nola tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dadi keta hataꞌuk! Naꞌi Maromak nafoli emi liu nosi manu harek nia sia.” ");
INSERT INTO tet_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nunia hotu, Yesus dale tenik naꞌak, “Ema mak nakberan aan katak sain Haꞌu iha ema lear oin iha raiklaran neꞌe, Haꞌu moos atu katak sain nia iha Haꞌukaan Ama oin iha laleꞌan kaꞌak, ‘Ema neꞌe, Haꞌukaan ema.’ ");
INSERT INTO tet_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mais ema mak neli Haꞌu iha ema lear oin naꞌak, nia la natene Haꞌu, nosi ikus Haꞌu moos atu katak baa Haꞌukaan Ama iha laleꞌan kaꞌak, ‘Haꞌu la katene ema nia.’ ” ");
INSERT INTO tet_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Hotu Yesus dale naꞌak, “Keta haneo haꞌak, Haꞌu kmai kodi dame baa raiklaran. Lale. Haꞌu kmai atu kalo ema raiklaran sakar malu. ");
INSERT INTO tet_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Haꞌu kmai tuir saa mak Maromak makoꞌan dale kedan hori uluk naꞌak, ‘Oan mane sakar aman, oan feto sakar inan, oan feen sakar banin feto, ");
INSERT INTO tet_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","tan ema uma laran duꞌuk atu funu malu.’ ");
INSERT INTO tet_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ema mak nakara tuir Haꞌu tebe-tebes, musti nadomi Haꞌu liu hotu-hotu: liu nosi inan no aman, no liu nosi oan sia. Kalo lale, nia la fatan dadi baa Haꞌukaan ema. ");
INSERT INTO tet_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ema mak nakara tuir Haꞌu, mais la noꞌuk natiu susar, nia moos la bele dadi baa Haꞌukaan ema. ");
INSERT INTO tet_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ema mak nadiꞌa aan mate tan tuir Haꞌu, nia atu netan moris nima-nimak no Naꞌi Maromak. Mais ema mak moris bodik isin lolon duꞌuk, niakaan moris atu lakon nunia dei!” ");
INSERT INTO tet_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Hotu Yesus dale naꞌak, “Ema mak simu emi diꞌa-diꞌak, sia moos simu Haꞌu. Ema mak simu Haꞌu, sia moos simu Maromak mak solok Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kalo ema simu Maromak makoꞌan ida tan sia fiar naꞌak makoꞌan nia tebe-tebes mai nosi Maromak, nosi ikus Naꞌi Maromak atu selu baa sia hanesan Nia selu baa makoꞌan nia. Kalo ema simu ema ida mak neon loos, tan sia fiar naꞌak ema nia tuir Maromak hakaran, nosi ikus Naꞌi Maromak atu selu baa sia hanesan Nia selu baa ema loos nia. ");
INSERT INTO tet_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ema mak simu emi tan tuir Haꞌu, Naꞌi Maromak nanis selu nikar baa sia. Rona! Haꞌukaan dalen neꞌe, tebes no loos! Masik ema foo wee moon hemu fatik ida dei moos, Naꞌi Maromak la naluꞌa.” ");
INSERT INTO tet_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus solok notu Niakaan maktuir naꞌin sanulu resin rua nia, Nia baa nasirin leo iha rai nia atu nanorin ema nodi katak Naꞌi Maromak Manfatin Diꞌak. ");
INSERT INTO tet_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Baa oras nia, Yohanis iha bui laran tiꞌan. Rona nola lia hotu-hotu mak Yesus nalo, Yohanis naruka niakaan maktuir baa nusu Yesus naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Naꞌi Maromak nameno kedan hori uluk naꞌak Nia atu solok Kristus mai nebee sori ita ema Yahudi. Ama neꞌe mak Kristus ka? Lale, ami musti hein tenik ema seluk ka?” Rona nola Yohanis dale baa sia nunia, sia moos baa nusu Yesus. ");
INSERT INTO tet_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hotu Yesus nataa sia naꞌak, “Fila baa, katak Mau Yohanis lia hotu-hotu mak emi rona no haree duꞌuk tiꞌan. Lia nia sia tuir saa mak Maromak makoꞌan Yesaya nakerek kedan naꞌak: ");
INSERT INTO tet_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ema matan delek, bele titu-naree. Ema ain asak, bele nariik laꞌo. Ema moras funi mea, isin dadi moos. Ema diuk, bele rona. Ema maten, moris nikar. Ema kiak, rona Manfatin Diꞌak. ");
INSERT INTO tet_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Katak baa Mau Yohanis haꞌak nia atu netan sotir kalo fiar bei-beik baa Haꞌu. Tan Naꞌi Maromak atu natuun matak-malirin baa ema mak la taliꞌur Haꞌu!” ");
INSERT INTO tet_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yesus dale notu nunia, Yohanis niakaan maktuir sia moos fila. Hotu Yesus dale no ema lear sia nosi lia Yohanis naꞌak, “Baa oras emi baa buka Yohanis iha fatin fuik nia, emi haneo haꞌak emi atu hasoru ema raiklaran oin nunabee? Emi baa iha nebaa, nanis emi la buka hasoru ema mak mamar, hanesan au mak kakoen tuir anin nuu! ");
INSERT INTO tet_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Emi baa iha nebaa, nanis emi la buka haree ema mak natais tais folin todan, tan ema oin nunia nein iha tofatik dei! ");
INSERT INTO tet_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dadi emi baa buka see iha nebaa? Emi baa buka Maromak makoꞌan ka? Tebes! Yohanis nia, makoꞌan makaꞌas tebes. ");
INSERT INTO tet_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Noo hakerek kedan iha Hakerek Moon nosi lia Yohanis naꞌak, ‘Rona! Haꞌu ksolok Haꞌukaan ema baa loke dalan bodik O.’ ");
INSERT INTO tet_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tan lia nia, rona diꞌa-diꞌak! Haꞌukaan dalen neꞌe, tebes no loos! Iha raiklaran la noo ema ida kois mak makaꞌas liu Yohanis. Mais iha Naꞌi Maromak fohorain, ema mak ikus basuk moos makaꞌas liu Yohanis. ");
INSERT INTO tet_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nahuu hori Yohanis nalaꞌo niakaan serwisu toꞌo oras neꞌe, noo ema mak sakar nebee ema la bele tama dadi baa Naꞌi Maromak eman. ");
INSERT INTO tet_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bei Musa no Maromak makoꞌan seluk sia nakerek kedan tiꞌan hori uluk nosi lia nia sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sia nakerek naꞌak Elia atu mai nikar. Fiar Haꞌu! Yohanis nia mak Elia. Maromak makoꞌan sia katak kedan nosi niakaan mamain. ");
INSERT INTO tet_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","See mak bele tolan lia neꞌe, nanono diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Haꞌu atu kfoo lia hatetek, nebee emi bele hatene emi ema raiklaran oras neꞌe, oin nuꞌu saa. Emi nuꞌu lawarik oan mak naꞌin tu-tuur iha dalan, nodi nahii baa mamaluk sia naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Hoi! Ami huu kfui bele-bele, mais emi la hoꞌuk bidu hodi neon diꞌak. Ami hananu kananuk susar, mais emi la hoꞌuk tanis.’ ");
INSERT INTO tet_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Emi neꞌe hanesan lawarik oan mak nakara oi-oik. Baa oras Yohanis mai, nia nalirin aan no la nemu anggor ween. Mais emi haꞌak, ‘Diabu tekar nia’. ");
INSERT INTO tet_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Oras neꞌe, Ema Raiklaran Isin neꞌe mai tiꞌan. Haꞌu kemu anggor ween no la kalirin aan. Mais emi sei haꞌak, ‘Etuk oin, Nia ema rotus teen! Tua lanuk teen! Nadulur no ema maksisi bea! Partee ida no ema mak la noo folin!’ Mais emi lei haree Haꞌukaan dalen neꞌe! Naꞌi Maromak Niakaan matenek nanis atu dadi malorek iha Niakaan eman moris.” ");
INSERT INTO tet_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nunia hotu, Yesus nahuu deꞌan ema mak nein iha leo sia iha rai Galilea. Nia naseꞌi tadak blaar waꞌin boot iha nebaa, mais sia la noꞌuk laꞌo nela siakaan salan no tuir Naꞌi Maromak dalan loos. ");
INSERT INTO tet_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus deꞌan naꞌak, “Emi, ema Korasin no ema Betsaida sia, sintidu! Emi atu hetan dinu! Haꞌu kaseꞌi tiꞌan tadak blaar oi-oik iha emikaan oin, mais emi la hoꞌuk fiar baa Naꞌi Maromak. Tuir loos, emi neꞌe ema Yahudi mak haꞌak hatene Naꞌi Maromak. Mais, kalo uluk aan ema kota Tirus no kota Sidon naree tadak blaar mak haꞌu kaseꞌi iha emikaan leo nia sia, sia nanis nalo neon aat nodi laꞌo nela siakaan salan atu tuir Naꞌi Maromak dalan loos. Sia moos nanis natais tais hene metan, nodi tau ahukresan baa ulun, atu dadi tadak naꞌak siakaan neon monu baa siakaan salan. Mais tuir loos, ema Tirus no ema Sidon uluk nia, lahoos ema Yahudi. Sia la natene Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lei haree dei! Nosi ikus, oras Naꞌi Maromak natetu ema hotu-hotu siakaan moris, emikaan kastikar todan liu nosi ema Tirus no ema Sidon siakaan kastikar. ");
INSERT INTO tet_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Emi, ema Kapernaum sia, sintidu! Keta hanoin haꞌak, Naꞌi Maromak atu foti saꞌe emi natama baa laleꞌan. Lale! Naꞌi Maromak atu soe lerek emi tama baa naraka! Kalo tadak blaar sia mak Haꞌu kaseꞌi iha emikaan leo, dadi uluk tiꞌan iha kota Sodom, nanis Naꞌi Maromak la nadodok kota aat nia. Tan kalo ema Sodom naree tadak blaar nia sia, nanis sia laꞌo nela siakaan aꞌaat. ");
INSERT INTO tet_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tebes! Lei haree dei! Nosi ikus, oras Naꞌi Maromak natetu ema hotu-hotu siakaan moris, emikaan kastikar todan liu sia!” ");
INSERT INTO tet_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dale notu nunia, Yesus namulak baa Naꞌi Maromak naꞌak, “Ama! Ita Boot mak Ulun Boot iha laleꞌan no raiklaran. Haꞌu ksera dodan tan Ama subar lia nia sia nosi ema mak nafolin aan matenek no ema mak loko aan sia. Mais Ama loke lia nia sia bodik ema kiꞌik no ema mak naraik aan sia. ");
INSERT INTO tet_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tebes Ama! Tan lia nia nalo Ama neon diꞌak!” ");
INSERT INTO tet_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Namulak notu nunia, Yesus katak baa ema iha nia sia naꞌak, “Rona diꞌa-diꞌak! Haꞌukaan Ama iha laleꞌan latan beran hotu-hotu baa Haꞌu. Haꞌukaan Ama mesan dei mak natene diꞌa-diꞌak Haꞌu. Haꞌu neꞌe, Niakaan Oan. Haꞌu mesan dei katene diꞌa-diꞌak Nia. Mais Haꞌu kboi ema atu katak nalore baa sia nosi Haꞌukaan Ama, nebee sia moos bele natene diꞌa-diꞌak Nia. ");
INSERT INTO tet_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Emi hotu-hotu mak kole, mai tuir Haꞌu! Emi hotu-hotu mak hatiu todan, mai baa Haꞌu! ");
INSERT INTO tet_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Simu Haꞌukaan hanorin no laꞌo hamutuk ho Haꞌu, nebee ita rua ahan karau baka matan rua mak dada bele-bele ai suak ida. Hodi nunia, emi bele dadi biit hikar. Tan Haꞌu laran diꞌak. Haꞌu neon kraik. ");
INSERT INTO tet_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Haꞌukaan hanorin, la susar. Haꞌukaan harukan, la todan.” ");
INSERT INTO tet_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Baa loron ida, kona baa ema Yahudi siakaan loron hanawa serwisu, Yesus no Niakaan maktuir sia laꞌo tuir toꞌos ida. Tan salaen, maktuir sia kuꞌu nola hare gandum, nodi naa la-laꞌok. ");
INSERT INTO tet_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iha nia moos, noo ema naꞌin hira nosi partee Farisi. Sia kaer metin adat Yahudi. Oras titu-naree Yesus maktuir sia kuꞌu hare gandum baa loron hanawa serwisu, sia nasee Yesus naꞌak, “La bele nunia! Kuꞌu hare gandum baa loron hanawa serwisu, nakur itakaan ukun-badu!” ");
INSERT INTO tet_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Mais Yesus nataa naꞌak, “Nunabee? Emi la hanoin lia Bei Daud iha Hakerek Moon ka? Oras uluk nia, Bei Daud no niakaan maktuir sia kabun nakeo, tan salaen tebe-tebes. Sia tama baa Batane Hamulak, hotu naa nola tubi mak naꞌilulik sia sera tiꞌan baa Naꞌi Maromak. Tuir loos, naꞌilulik sia mesan mak bele naa tubi nia. Ema seluk la bele. Mais masik Bei Daud sia naa moos, ema la nasalak sia. Emi nuꞌu la leno Hakerek Moon! ");
INSERT INTO tet_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Iha Hakerek Moon moos hakerek nosi naꞌilulik sia mak serwisu iha uma hamulak kona baa loron hanawa serwisu. Sia moos la sala. ");
INSERT INTO tet_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hanono! Uluk, uma hamulak mak folin. Mais oras neꞌe, Haꞌu, Ema Raiklaran Isin mai tiꞌan. Haꞌu folin liu tenik uma hamulak. ");
INSERT INTO tet_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iha Hakerek Moon, Naꞌi Maromak katak naꞌak, ‘Haꞌu kakara nuneꞌe: Haꞌukaan eman sia musti dodan malu. Kalo lale, sera tunun mak sia nodi natetu baa Haꞌu, la noo folin.’ Kalo emi hatene diꞌa-diꞌak Naꞌi Maromak hakaran nia, nanis emi la tula sala baa Haꞌukaan maktuir sia! Tan sia la sala. ");
INSERT INTO tet_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Haꞌu neꞌe, Ema Raiklaran Isin nosi laleꞌan. Haꞌu mak koo beran atu kakotu saa mak ema bele nalo baa loron hanawa serwisu.” ");
INSERT INTO tet_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nunia hotu, Yesus laꞌo nela fatin nia atu baa uma hamulak. ");
INSERT INTO tet_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iha uma hamulak nia, noo mane ida mak liman sorin matek. Ema Farisi sia buka dalan atu tula sala baa Yesus kalo nia nadiꞌak nola ema nia kona baa loron hanawa serwisu. Tan lia nia, sia nusu baa Yesus naꞌak, “Tuir itakaan ukun-badu, ema bele nadiꞌak nola ema kona baa loron hanawa serwisu ka lale?” ");
INSERT INTO tet_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus nataa naꞌak, “Kalo bibi malae monu baa kuak kona baa loron hanawa serwisu, bibi malae naꞌin nanis baa foti nasai. ");
INSERT INTO tet_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Naꞌi Maromak nadomi nanis ema raiklaran liu nosi bibi malae naꞌin nadomi niakaan bibi malae. Tan lia nia, ita hatene haꞌak ema bele nalo lia diꞌak kona baa loron hanawa serwisu.” ");
INSERT INTO tet_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hotu Yesus dale baa ema liman matek nia naꞌak, “Mau! Lolo liman mai!” Ema nia moos lolo liman baa. Baa oras nia moos, liman diꞌak kedas nuꞌu liman sorin mak diꞌak nia. ");
INSERT INTO tet_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Naree nola nunia, ema Farisi sia krakat tebe-tebes. Sia nariik laꞌo nela uma hamulak nia, baa dale kabuar lia naꞌak, “Ita musti buka dalan hoꞌo Nia!” ");
INSERT INTO tet_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mais Yesus natene siakaan kakotun aat nia. Tan lia nia, Yesus laꞌo nela fatin nia. Ema waꞌin moos tuir. Nia moos nadiꞌak nola ema moras hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mais Nia nakahik sia naꞌak, “Keta katak ema seluk haꞌak, Haꞌu neꞌe see. ");
INSERT INTO tet_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Lia nia natoꞌo saa mak Naꞌi Maromak katak kedan baa makoꞌan Yesaya hori uluk naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Haree kokon! Ema neꞌe, mak Haꞌukaan ema ain-liman mak Haꞌu kboi tiꞌan. Haꞌu kadomi nia. Nia nalo Haꞌu neon diꞌak tebes. Haꞌu atu kfoo Haꞌukaan Kmalar baa nia, nebee nia baa nanorin ema klubun hotu-hotu nosi Haꞌukaan dalan moris mak loos. ");
INSERT INTO tet_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nia la basa karas. Nia la naksaꞌek aan. ");
INSERT INTO tet_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nia laran diꞌak. Nia la nasusar ema. Ai mak kreꞌis naktohar, nia la silu. Badut lakan mak kreꞌis mate, nia la nuu namate. Nia nanorin ema toꞌo ema hotu-hotu natene tuir Naꞌi Maromak dalan loos. ");
INSERT INTO tet_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ema nosi klubun hotu-hotu iha raiklaran atu haloon baa Nia, tan sia natene Nia neꞌe see.’ ” ");
INSERT INTO tet_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dala ida, ema nodi ema moras ida mai baa Yesus. Ema nia, diabu tekar toꞌo matan delek no la bele dale. Yesus moos nadiꞌak nola nia nodi teꞌur sai diabu. Hotu ema nia matan moon. Nia moos bele dale kedas. ");
INSERT INTO tet_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naree nola nunia, ema hotu-hotu blaar karin nodi naꞌak, “Arumak Ema neꞌe Daud husar-binan mak Naꞌi Maromak nameno hori uluk atu solok mai. Nia neꞌe nanis Ema mak ita hei-hein tiꞌan nia!” ");
INSERT INTO tet_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mais oras ema Farisi sia rona nola nunia, sia la simu. Sia dale naꞌak, “Lale! Ema neꞌe bele teꞌur sai diabu tan diabu ulun Baalsebul mak foo beran baa Nia.” ");
INSERT INTO tet_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mais Yesus natene ema Farisi siakaan hanoin. Nia katak baa sia naꞌak, “Emi dale nia la tama kakutak! Kalo renu rai ida natuda malu, oin nunabee rai nia bele nariik metin! Nunia moos kalo ema kota ida, lale ema uma laran ida, toe malu, sia nanis keen karin malu toꞌo dodok welon. ");
INSERT INTO tet_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dadi kalo diabu sia funu malu no teꞌur malu, siakaan ulun la bele kaer ukun kleur. ");
INSERT INTO tet_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hanoin! Emikaan ema sia moos teꞌur diabu. Sia nodi beran nosi diabu ka? Lale! Dadi keta naꞌin da-dale haꞌak, Haꞌu kodi diabu beran kteꞌur diabu. Emikaan ema duꞌuk atu nakotu naꞌak sala mak emi tula nia la kona. ");
INSERT INTO tet_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mais hanoin! Kalo Haꞌu kteꞌur diabu kodi Naꞌi Maromak beran, lia nia natudu naꞌak Naꞌi Maromak kaer ukun tiꞌan iha emikaan oin. ");
INSERT INTO tet_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kalo ema mai atu nadau nola naha iha ema biit ida uman, nia musti kesi uluk ema nia lai, foin bele nadau nola naha. ");
INSERT INTO tet_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Hanoin! Ema mak la nakbelan no Haꞌu, nia funu Haꞌu. Ema mak la tulun Haꞌukaan serwisu, nia tokar lauk. ");
INSERT INTO tet_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hanono diꞌa-diꞌak Haꞌukaan dalen neꞌe! Naꞌi Maromak nadiꞌa aan tiꞌan atu kasu ema salan. Kalo ema ida dale nahaat ema seluk, Naꞌi Maromak kasu sala nia. Mais, kalo ema naksakar aan dale nahaat Maromak Kmalar Lulik, Naꞌi Maromak la kasu sala nia. ");
INSERT INTO tet_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Haꞌu neꞌe, Ema Raiklaran Isin nosi laleꞌan. Kalo ema dale nahaat Haꞌu, Naꞌi Maromak sei kasu sala nia. Mais, kalo dale nahaat Maromak Kmalar Lulik, masik toꞌo rai falu fila moos, Naꞌi Maromak la kasu sala nia!” ");
INSERT INTO tet_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Hotu Yesus dale liu baa ema Farisi sia naꞌak, “Ai huun diꞌak nasai fuan diꞌak. Ai huun aat nasai fuan aat. Nosi ai fuan, ema bele natene ai huun nia, diꞌak ka lale. ");
INSERT INTO tet_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Emi neꞌe, hanesan samea maktolek teen! Emi la hatene dale lia diꞌak, tan lia mak emi rai iha neon laran, nia mak atu sai nosi emikaan ibun. ");
INSERT INTO tet_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ema diꞌak nanis dale lia diꞌak tan nia rai lia diꞌak iha neon laran. Ema aat nanis dale aat tan nia rai lia aat iha neon laran. ");
INSERT INTO tet_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Fiar Haꞌu! Oras rai falu fila Naꞌi Maromak atu natetu ema hotu-hotu siakaan moris. Baa oras nia, ema ida-idak musti nataa nosi niakaan lia fuan mak sai nosi ibun. ");
INSERT INTO tet_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dadi sintidu! Naꞌi Maromak atu tetu emikaan lia fuan sia nodi nakotu naꞌak, emi kona kastikar ka lale.” ");
INSERT INTO tet_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Rona nola Yesus dale nunia, manorik ukun Yahudi naꞌin hira no ema Farisi sia nusu baa Nia naꞌak, “Ama Manorik, ami husu Ama nalo tadak blaar, nebee ami bele hatene Ama beran nia tebe-tebes nosi Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mais Yesus nakbehek sia naꞌak, “Hoi! Emi, ema oras neꞌe, la hoꞌuk tuir Naꞌi Maromak! Emi hatene halo aat dei! Masik emi husu tadak blaar moos, Haꞌu la kfoo. Uluk, Naꞌi Maromak foo tiꞌan tadak blaar nodi Niakaan makoꞌan Yunus. Nia toꞌo tiꞌan! ");
INSERT INTO tet_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Baa oras nia, Yunus nein loron tolu, kalan tolu, iha naꞌan tasi boot kabun laran. Nunia moos Haꞌu, mak Ema Raiklaran Isin nosi laleꞌan. Haꞌu atu kein loron tolu, kalan tolu iha fatuk kuak iha ema maten fatin. ");
INSERT INTO tet_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Baa loron rai falu fila, Naꞌi Maromak atu nariik dadi makotu lia. Ema Niniwe sia moos atu nariik dadi baa mataa lia, nodi tula sala baa emi naꞌak, ‘Emi hotu-hotu neꞌe, beik!’ Uluk, ema Niniwe nia sia nanono baa Maromak makoꞌan Yunus, hotu sia laꞌo nela siakaan salan. Mais emi lale! Tuir loos, oras neꞌe noo tiꞌan Ema ida iha emikaan klaran mak makaꞌas liu Yunus. Nia mak Haꞌu neꞌe. Mais emi la titu kedan. ");
INSERT INTO tet_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Baa loron rai falu fila, Naꞌi Maromak nariik dadi makotu lia, Naꞌi Feto Seba nosi lorokbelan nebaa moos atu nariik dadi baa mataa lia. Nia atu natudu liman fuan nodi tula sala baa emi hotu-hotu mak moris baa oras neꞌe naꞌak, ‘Emi neꞌe hotu-hotu, beik!’ Uluk, naꞌi feto nia mai nosi rai dook atu naree nodi matan duꞌuk Naꞌi Salomo niakaan matenek. Tuir loos, oras neꞌe noo tiꞌan Ema ida iha emikaan klaran mak makaꞌas liu Naꞌi Salomo. Nia mak Haꞌu neꞌe. Mais emi la titu kedan.” ");
INSERT INTO tet_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Hotu Yesus dale naꞌak, “Kalo diabu kona teꞌur sai nosi ema ida, diabu nia baa fatin fuik atu buka hanawa fatin. Mais, kalo la netan fatin makonak, ");
INSERT INTO tet_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nia naneo naꞌak, ‘Aa! Tan la ketan fatin, diꞌak liu haꞌu kfila kikar baa kein iha ema uluk nia.’ Hotu diabu nia fila nikar, naree fatin nia tetuk no nesan tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hotu nia baa bolu tenik niakaan maluk naꞌin hitu mak aat liu tan nia. Sia hotu-hotu baa nein iha ema nia nodi nababu nia bele-bele. Tan baa nia, ema nia moris hetak susar tenik.” ");
INSERT INTO tet_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Baa oras Yesus sei dale no ema lear, Niakaan inan no alin sia mai atu nasoru Nia. Sia nariik iha luan, naruka ema bolu Yesus. ");
INSERT INTO tet_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hotu ema baa katak baa Nia naꞌak, “Ama! Ama inan no ama alin sia iha luan. Sia atu nasoru Ama.” ");
INSERT INTO tet_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mais Yesus nataa naꞌak, “Haꞌukaan inan malolok mak see? Haꞌukaan alin malolok mak see?” ");
INSERT INTO tet_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hotu Nia natudu ema mak tuur iha nia sia nodi naꞌak, “Titu baa! Sia neꞌe mak Haꞌukaan familin malolok sia. ");
INSERT INTO tet_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ema mak nalo tuir Haꞌukaan Ama iha laleꞌan hakaran, sia mak Haꞌukaan familin malolok.” ");
INSERT INTO tet_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Baa loron nia moos, Yesus sai nosi uma nia, baa tuur iha debu Galilea tehen. ");
INSERT INTO tet_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ema lear moos mai kabuun nola Nia. Naree nunia, Nia saꞌe baa bero ida mak nanawa iha nia, nebee ema hotu-hotu iha rai leten bele rona Niakaan hanorin. ");
INSERT INTO tet_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Oras nia, Nia nanorin lia waꞌin nodi lia hatetek. Nia foti lia naꞌak, “Noo ema mahalo toꞌos ida. Nia baa kari fini iha toꞌos. ");
INSERT INTO tet_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Baa oras kari, fini balu monu baa dalan. Hotu manu ai leten sia mai tutu nola fini nia notu. ");
INSERT INTO tet_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Fini balu monu baa rai fatuk. Fini nia tubu lais, tan kona rai niꞌis. ");
INSERT INTO tet_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mais baa oras loro manas, tubun nia naklaik toꞌo mate maran tan abut tama la leꞌan. ");
INSERT INTO tet_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Fini balu monu baa ai tarak laran. Ai tarak nia nabit noꞌo fini tubun sia. ");
INSERT INTO tet_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mais fini balu tenik monu baa rai isin. Sia tubu, hotu boot toꞌo nafua. Balu foo nikar folin toꞌo isin tolu nulu, balu toꞌo isin neen nulu, balu tenik toꞌo isin atus ida. ");
INSERT INTO tet_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","See mak noo tilun, rona diꞌa-diꞌak!” ");
INSERT INTO tet_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nunia hotu, Yesus Niakaan maktuir sia mai nusu naꞌak, “Tan saa Ama nanorin ema nia sia nodi lia hatetek?” ");
INSERT INTO tet_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus nataa naꞌak, “Emi neꞌe beer hatene tebe-tebes Naꞌi Maromak ukun. Tan lia nia, Haꞌu kloke malorek lia hatetek nia isin baa emi. Mais, kalo ema seluk, Haꞌu kanorin kodi lia hatetek dei. ");
INSERT INTO tet_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ema mak buka atu natene tebe-tebes Naꞌi Maromak Niakaan beer, nia hetak natene. Mais ema mak la nanono baa Naꞌi Maromak Niakaan beer, nia hetak beik. ");
INSERT INTO tet_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Haꞌu kanorin sia kodi lia hatetek nunia tan: ‘Sia naree tiꞌan, mais la noꞌuk tolan. Sia rona tiꞌan, mais la noꞌuk natene.’ ");
INSERT INTO tet_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sia nia hanesan ema mak Maromak makoꞌan Yesaya nakerek kedan naꞌak, ‘Emi atu rona, mais emi la hoꞌuk tolan. Emi atu haree, mais emi la hoꞌuk hatene saa mak dadi tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ema neꞌe sia, neon monas. Sia nadiuk tilun. Sia nadelek matan. Habusik baa, nebee siakaan tilun diuk nunia dei, Habusik baa, nebee siakaan matan delek nunia dei. Nebee Haꞌu lalika kadiꞌak sia, tan sia la nikir Haꞌu.’ ");
INSERT INTO tet_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mais emi neꞌe, sotir tebes tan haree tiꞌan hodi matan duꞌuk, no rona tiꞌan hodi tilun duꞌuk. ");
INSERT INTO tet_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rona! Haꞌukaan dalen neꞌe, tebes no loos! Uluk aan, Maromak makoꞌan no ema neon loos sia beer atu naree saa mak emi haree tiꞌan neꞌe, mais la bele. Sia moos beer atu rona saa mak emi rona tiꞌan neꞌe, mais la bele.” ");
INSERT INTO tet_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Dale notu nunia, Yesus katak baa sia naꞌak, “Tan emi beer hatene Naꞌi Maromak ukun, hanono diꞌa-diꞌak lia hatetek nia isin. ");
INSERT INTO tet_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Fini mak monu baa dalan, hanesan ema mak rona Manfatin nosi lia Naꞌi Maromak kaer ukun, mais la tolan tebe-tebes. Hotu diabu ulun mai nadau nola Manfatin nia nosi neon. ");
INSERT INTO tet_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Fini mak monu baa rai fatuk, hanesan ema mak rona Naꞌi Maromak Manfatin, hotu simu nodi neon diꞌak. ");
INSERT INTO tet_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mais Manfatin nia la nahabut, tan ema nia la rai iha neon. Baa oras ema seluk nasusar nia tan nia simu Manfatin nia, nia nabusik nela kedan. ");
INSERT INTO tet_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Fini mak monu iha ai tarak laran, hanesan ema mak rona nola Manfatin nia. Mais, tan nia nalau aan nodi lisan oi-oik atu moris furak, nia sesu sai Manfatin nia nosi neon, toꞌo la no folin tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mais fini mak monu baa rai isin, hanesan ema mak simu Naꞌi Maromak Manfatin, hotu nalo tuir Niakaan beer. Nia nalo lia diꞌak, hanesan fini mak nafua waꞌin toꞌo isin tolu nulu, isin neen nulu, no isin atus ida.” ");
INSERT INTO tet_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Hotu Yesus katak tenik lia hatetek ida naꞌak, “Naꞌi Maromak babilan renun nuneꞌe. Noo ema ida kari fini iha toꞌos. ");
INSERT INTO tet_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Baa kalan, nia toba dukur bele-bele no niakaan ema serwisu sia. Hatene hodi baa, ema aat mai kari fini hae fuik iha toꞌos nia. ");
INSERT INTO tet_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Baa oras toꞌos nahuu nasai isin, ema serwisu naree nola hae fuik moos tubu iha nia. ");
INSERT INTO tet_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hotu sia baa katak toꞌos naꞌin naꞌak, ‘Ama boot! Hori hirak nia ama kuda fini diꞌak iha toꞌos. Tan saa oras neꞌe hae waꞌin mak tubu?’ ");
INSERT INTO tet_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ulun nia nataa naꞌak, ‘Nia, funu niakaan hahalok.’ Hotu niakaan ema serwisu katak naꞌak, ‘Ama boot, ami baa hafaho mohu hae nia sia ka?’ ");
INSERT INTO tet_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mais ulun nataa naꞌak, ‘Keta! Tan oras emi hafaho hae nia sia, itakaan ai horis diꞌak sia moos nakfokit tuir. ");
INSERT INTO tet_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Habusik baa, nebee sia tubu bele-bele. Toꞌo oras kuꞌu, foin haꞌu katak baa ema makuꞌu sia kaꞌak, “Libur uluk hae fuik nia sia. Hotu kesi hola, sunu mohu. Foin libur hola toꞌos isin diꞌak sia, hatama baa kanaha uman.” ’ ” ");
INSERT INTO tet_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Hotu Yesus dale tenik naꞌak, “Haꞌu ktuꞌan tenik lia hatetek ida, nebee emi bele hatene oin nunabee Naꞌi Maromak renun tuꞌan waꞌin. Uluk fohon, Naꞌi Maromak renun naꞌin hira dei, hanesan ai fuan musan kiꞌik oan mak ema kuda iha toꞌos. ");
INSERT INTO tet_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masik ai fuan nia musan kiꞌik oan basuk, kalo moris mai tiꞌan, nia dadi ai huun mak boot kaliuk iha toꞌos nia. Toꞌo manu ai leten sia moos mai nalo knuuk iha sorun.” ");
INSERT INTO tet_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Hotu Yesus tuꞌan tenik lia hatetek ida naꞌak, “Naꞌi Maromak renun moos hanesan tua teen mak ema kahur baa tubi rahun. Tubi rahun nia saꞌe toꞌo boot, tan tua teen mak oan basuk nia.” ");
INSERT INTO tet_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Oras nia, Yesus nanorin ema lear nodi lia hatetek oi-oik nunia. Nia la nodi lia seluk, mais nodi loos lia hatetek dei. ");
INSERT INTO tet_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nia nanorin nunia atu natoꞌo saa mak Maromak makoꞌan nakerek kedan hori uluk naꞌak, “Haꞌu atu kanorin kodi lia hatetek. Haꞌu atu katak lia sia mak ema sei la rona dauk, nahuu hori Naꞌi Maromak naseꞌi raiklaran toꞌo oras neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hotu Yesus laꞌo nela ema lear nia sia, fila baa uma. Niakaan maktuir sia moos mai nusu baa Nia naꞌak, “Ama! Tulun malore lia hatetek hae fuik nia!” ");
INSERT INTO tet_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus nataa naꞌak, “Ema mak kari fini diꞌak nia, neꞌe mak Haꞌu, Ema Raiklaran Isin nosi laleꞌan. ");
INSERT INTO tet_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Toꞌos nia, mak raiklaran neꞌe. Fini diꞌak nia, mak Naꞌi Maromak eman. Hae fuik nia, mak diabu ulun eman sia. ");
INSERT INTO tet_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ema aat mak mai kari hae fini nia, mak diabu ulun duꞌuk. Oras kuꞌu toꞌos isin nia, mak oras rai falu fila. Ema makuꞌu toꞌos isin nia, mak Maromak Niakaan makbukar laleꞌan sia. ");
INSERT INTO tet_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Baa loron rai falu fila, sia atu libur nola hae nia sia, hotu sunu mohu. ");
INSERT INTO tet_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Haꞌu neꞌe, Ema Raiklaran Isin, mak atu solok makbukar laleꞌan sia mai. Sia atu baa libur nola ema hotu-hotu mak la tuir Naꞌi Maromak ukun. Sia moos libur nola ema hotu-hotu mak sokur ema seluk, nebee keta tuir Naꞌi Maromak ukun. ");
INSERT INTO tet_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Hotu sia atu soe ema aat nia sia hotu-hotu baa haꞌi naraka, hanesan hae mak kona sunu nia. Iha nia, sia noran susar tebe-tebes nodi tanis nadeꞌun aan la nanawa. ");
INSERT INTO tet_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mais ema mak nalo tuir Naꞌi Maromak hakaran, sia atu nein nima-nimak no siakaan Ama Naꞌi iha laleꞌan. Iha nia, sia naksinak nakroma hanesan loro. Rona mai! Ema mak noꞌuk nanono baa Haꞌu, taꞌan tilun diꞌa-diꞌak!” ");
INSERT INTO tet_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Hotu Yesus tuꞌan tenik lia hatetek ida naꞌak, “Ema mak nakara dadi Naꞌi Maromak eman, hanesan ema ida mak nakara nola sasoin mahoo folin todan. Noo ema ida mak netan nola sasoin mean-matak iha rai rohan ida. Naree nola tiꞌan, nia neon diꞌak nodi nakoi nikar kedas. Hotu fila lai-lais, baa faꞌan mohu niakaan sasoin hotu-hotu. Hotu nia mai sosa nola kedan rai rohan nia, nebee sasoin folin todan nia dadi niakaan.” ");
INSERT INTO tet_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hotu Yesus tuꞌan tenik naꞌak, “Ema mak nakara dadi Naꞌi Maromak eman, sia moos hanesan ema makfaꞌan sa-saa ida mak nakara netan fatuk mahoo matan mak folin todan. ");
INSERT INTO tet_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Baa oras nasoru fatuk mahoo matan mak diꞌak basuk, nia fila lai-lais, baa faꞌan mohu sasoin seluk sia hotu-hotu. Hotu nia mai sosa nola fatuk mahoo matan nia, nebee dadi baa niakaan.” ");
INSERT INTO tet_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Hotu Yesus tuꞌan tenik naꞌak, “Naꞌi Maromak moos ukun fohorain hanesan lia neꞌe. Noo ema maktuun tasi nodi daitiha ida baa tiha iha debu laran. ");
INSERT INTO tet_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Daitiha nia nakonu tiꞌan, sia firi saꞌe baa tasi tehen. Hotu sia tuur nili naꞌan tasi nosi daitiha nia. Naꞌan tasi mak diꞌak, sia natama baa koꞌe. Naꞌan tasi mak la diꞌak, sia soe lerek. ");
INSERT INTO tet_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nunia moos baa oras rai falu fila. Maromak Niakaan makbukar laleꞌan sia atu mai faꞌe salin ema aat no ema diꞌak. ");
INSERT INTO tet_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Sia soe ema aat sia hotu-hotu baa haꞌi naraka. Iha nia, sia noran susar basuk nodi tanis la nanawa.” ");
INSERT INTO tet_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dale notu nunia, Yesus nusu baa sia naꞌak, “Emi hatene lia hotu-hotu mak Haꞌu kdale tiꞌan nia ka lale?” Sia nataa naꞌak, “Ami hatene, Ama Boot!” ");
INSERT INTO tet_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hotu Yesus nataa fila naꞌak, “Diꞌak! Lia nia nuꞌu ema manorik ukun ida mak natene tebe-tebes hanorin uluk aan nosi Hakerek Moon. Hotu nia moos simu tenik Haꞌukaan hanorin baa oras neꞌe. Nia hanesan uma ida naꞌin mak loke niakaan tanasak atu lalore niakaan sasoin tuan bele-bele no sasoin foun.” ");
INSERT INTO tet_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus nanorin notu ema lear nodi lia hatetek, Nia moos laꞌo nela fatin nia ");
INSERT INTO tet_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","atu fila baa Niakaan leo. Toꞌo baa, Nia tama baa uma hamulak atu nanorin ema. Ema hotu-hotu mak rona Nia, blaar tebe-tebes nodi dale baa malu naꞌak, “Ema neꞌe, matenek tebes! See mak nanorin nia? Oin nunabee toꞌo Nia bele nalo tadak blaar nia sia? ");
INSERT INTO tet_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tuir loos, Nia neꞌe, badaen ai ida oan loos dei. Ita hatene Niakaan inan Maria, no niakaan alin sia, mak Yakobus, Yusuf, Yudas no Simon. ");
INSERT INTO tet_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ita moos hatene Niakaan alin feto sia tan ita hotu-hotu leo ida! Nia netan Niakaan matenek nia, nosi nabee tenik? Nia netan Niakaan beran makaꞌas nia, nosi see tenik?” ");
INSERT INTO tet_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tan baa nia, sia la noꞌuk rona baa Yesus tenik. Mais Yesus katak baa sia naꞌak, “Tebes! Ema nakneter Maromak makoꞌan nosi fatin seluk, liu nosi makoꞌan leo duꞌuk.” ");
INSERT INTO tet_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tan sia la noꞌuk fiar baa Yesus, Yesus moos la nalo tadak blaar waꞌin iha leo nia. ");
INSERT INTO tet_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Baa oras nia, Naꞌi Herodes kaer ukun iha rai Galilea. Nia rona nola lia oi-oik nosi Yesus tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Hotu nia katak baa eman serwisu sia naꞌak, “Yesus neꞌe, nanis Yohanis Mak Sarani Ema. Hori hirak nia, haꞌu karuka taa hola Yohanis ulun tiꞌan. Oras neꞌe nia moris nikar tiꞌan. Tan lia nia, Yesus noo beran nalo tadak blaar nia sia.” ");
INSERT INTO tet_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Naꞌi Herodes dale nunia, tan uluk nia nalo lia no Yohanis, toꞌo natama Yohanis baa bui. Lia nia nuneꞌe: Naꞌi Herodes nola alin Filipus feen, naran Herodias. Mais tuir loos, Filipus no Herodias sei la soe malu dauk. ");
INSERT INTO tet_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tan nia, Yohanis deꞌan hei-hein naꞌak, “Ama Naꞌi la bele nola ama alin feen. Lia nia nakur itakaan adat Yahudi!” ");
INSERT INTO tet_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mais Herodes la noꞌuk rona. Nia nola luku Herodias dei. Nia moos buka dalan noꞌo Yohanis Mak Sarani Ema. Mais nia nakerat ema lear, tan sia fiar naꞌak Yohanis nia, mak Maromak makoꞌan. Tan baa nia, Herodes naruka niakaan ema sia natama Yohanis baa bui. ");
INSERT INTO tet_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kleu-leur Herodes nalo niakaan dahur loron moris. Baa oras nia, ina Herodias oan feto ida bidu iha bainaka sia oin. Nia bidu furak basuk, toꞌo nalo Herodes neon diꞌak lo-loos. ");
INSERT INTO tet_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bidu notu, Herodes bolu nola oan feto nia nodi naꞌak, “O makara musu saa baa haꞌu, katak baa dei! Haꞌu nanis foo baa o. Haꞌu kaꞌak tebe-tebes kodi Naꞌi Maromak naran.” ");
INSERT INTO tet_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Rona naꞌin dale nunia, ina Herodias sasuku niakaan oan. Hotu oan baa nusu ama naꞌi naꞌak, “Ama! Haꞌu kusu Yohanis Mak Sarani Ema niakaan ulun. Tau baa hanematan, hodi mai neꞌe, foo baa haꞌu.” ");
INSERT INTO tet_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Rona oan nusu nunia, Herodes neon lakon kedas. Mais nia la bele dada nikar niakaan lia fuan, tan bainaka hotu-hotu rona nola tiꞌan. Tan baa nia, nia tuir oan nia beer dei. ");
INSERT INTO tet_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nia naruka ema baa taa nola Yohanis ulun iha bui laran. ");
INSERT INTO tet_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Taa nola tiꞌan, sia tau baa hanematan, nodi foo baa oan nia. Nia simu nola hanematan nia, tane nodi foo baa inan. ");
INSERT INTO tet_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Baa oras Yohanis niakaan maktuir sia rona naꞌak ema taa nola Yohanis ulun tiꞌan, sia mai nola niakaan maten, nodi baa nakoi. Hotu sia baa nasara lia nia baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Baa oras Yesus rona lia Yohanis mate, Nia no Niakaan maktuir sia laꞌo nela fatin nia. Sia saꞌe bero baa fatin fuik ida atu nanawa kole iha nia. Mais ema lear naree Yesus siakaan bero laꞌo tuir debu tehen. Sia moos sai nosi leo, laꞌo tesi tuir rai maran, toꞌo uluk Yesus. ");
INSERT INTO tet_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Baa oras Yesus tuun nosi bero, Nia naree ema lear noꞌi nein Nia tiꞌan. Naree nunia, neon monu baa sia. Nia moos nadiꞌak nola siakaan ema moras sia. ");
INSERT INTO tet_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Loron malirin, Yesus Niakaan maktuir sia mai katak baa Nia naꞌak, “Ama! Loraik tiꞌan! Diꞌak liu Ama naruka ema neꞌe sia baa sosa haan iha leo kreꞌis neꞌe sia. Tan iha fatin fuik neꞌe la noo haan.” ");
INSERT INTO tet_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mais Yesus nataa naꞌak, “Lalika! Emi mak hahaan sia dei.” ");
INSERT INTO tet_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sia nataa naꞌak, “Aikee, Ama! Ami la hoo sa-saa atu hodi hahaan ema lear neꞌe. Ami atu halo nunabee? Ami hoo loos tubi baluk lima no naꞌan tasi lolon rua!” ");
INSERT INTO tet_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Rona nola nunia, Yesus dale naꞌak, “Soꞌin! Hodi mai ona!” ");
INSERT INTO tet_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hotu Nia naruka ema nia sia tuur libur malu baa hae fohon. Hotu Nia nola tubi nia no naꞌan tasi nia. Nia tanaat baa laleꞌan nodi sera dodan baa Naꞌi Maromak. Hotu Nia tohi faꞌe tubi nia sia, lolo baa maktuir sia nebee faꞌe baa ema nia sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sia hotu-hotu naa toꞌo bosu. Naa notu, maktuir sia baa libur nola haan resin sia, nakonu nola koꞌe sanulu resin rua. ");
INSERT INTO tet_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ema hotu-hotu mak tuur naa nia, takseer ema mane rihun lima. Sei la sura dauk feto no lawarik oan sia. ");
INSERT INTO tet_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ema lear nia hotu-hotu naa tiꞌan, Yesus naruka Niakaan maktuir sia saꞌe bero, baa uluk debu balu baa. Nia duꞌuk sei nein iha nia atu naruka ema lear nia fila nikar. ");
INSERT INTO tet_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sia hotu-hotu fila tiꞌan, Yesus saꞌe baa foho ida leten atu namulak. Toꞌo kalan, Nia mesan sei iha nia. ");
INSERT INTO tet_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Baa oras nia, Niakaan maktuir siakaan bero dook tiꞌan iha debu klaran. Mais sia fofer makaꞌas tebe-tebes, tan bero laꞌo sakar anin. Laloran boot moos basak bero nia. ");
INSERT INTO tet_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kreꞌis rai naroma, Yesus baa tuir sia, laꞌo tuir wee leten. ");
INSERT INTO tet_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Naree nola nunia, maktuir sia sarebak basuk. Sia nataꞌuk nodi dale naꞌak, “Hoi! Saa mak nia? Ema kmalar ka?!” ");
INSERT INTO tet_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mais Yesus dale baa sia naꞌak, “No-nook baa dei. Haꞌu neꞌe Yesus! Keta hataꞌuk.” ");
INSERT INTO tet_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Rona nola nunia, Petrus nataa naꞌak, “Kalo tebe-tebes Ama Boot, maruka haꞌu klaꞌo iha wee leten tone Ama.” ");
INSERT INTO tet_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus nataa naꞌak, “Diꞌak! Mai ona!” Petrus moos sai nosi bero baa Yesus, nodi laꞌo tuir wee leten. ");
INSERT INTO tet_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mais oras noran anin makaꞌas, nia nataꞌuk tan atu mout ona. Nia nahii naꞌak, “Adeei Ama Boot! Tulun haꞌu lai!” ");
INSERT INTO tet_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus moos lolo liman lai-lais, nodi kaer nola Petrus. Hotu Yesus dale naꞌak, “Petrus! Tan saa o neon ruak nunia? O la duun fiar baa Haꞌu ka?” ");
INSERT INTO tet_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hotu sia naꞌin rua tama baa bero laran. Anin moos nakmatek kedas. ");
INSERT INTO tet_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Naree nola nunia, Niakaan maktuir sia foti tonu-naboot Nia naꞌak, “Aikee! Ama neꞌe, tebe-tebes Naꞌi Maromak Oan!” ");
INSERT INTO tet_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Toꞌo debu balu baa, Yesus sia tuun baa leo Genesaret. ");
INSERT INTO tet_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Baa oras tuun, ema lear titu-naree tiꞌan. Sia nahii naꞌak, “Hoi! Yesus mai tiꞌan!” Sia moos nalai baa katak nasirin lia nia, toꞌo ema nodi ema moras hotu-hotu mai baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sia nusu nebee bele koko Yesus farun, tan naneo naꞌak, “Surak ema moras koko Yesus faru ninin dei moos, bele diꞌak.” Baa oras nia moos, ema moras hotu-hotu mak koko Yesus farun, diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Baa loron ida, ema manorik ukun Yahudi no ema Farisi sia mai nosi Yerusalem atu nalo lia no Yesus, ");
INSERT INTO tet_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","tan sia rona nola tiꞌan naꞌak Yesus Niakaan maktuir sia naa la fasi uluk liman tuir adat. Sia kanarak, tan sia kaer metin siakaan adat Yahudi. Tan lia nia, sia mai tula sala baa Yesus naꞌak, “Tan saa okaan maktuir sia naa, mais la fasi uluk liman? Lia nia sakar tiꞌan itakaan bei uluk siakaan ukun!” ");
INSERT INTO tet_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mais Yesus nataa naꞌak, “Emi neꞌe dale seluk, halo seluk! Emi matenek sakar Naꞌi Maromak hakaran hodi seluk bei uluk siakaan hakaran dei. ");
INSERT INTO tet_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Naꞌi Maromak naruka tiꞌan naꞌak, ‘Hakneter emikaan inan-aman.’ Tuꞌan tenik naꞌak, ‘Kalo ema ida deꞌan aat baa inan-aman, musti taa ukun mate baa ema nia.’ ");
INSERT INTO tet_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Naꞌi Maromak nanorin tebes nunia, mais emi hanorin seluk. Emi haꞌak, ‘Ema ida lalika nodi niakaan naha atu tulun inan-aman, kalo nia nameno tiꞌan atu sera naha nia baa Naꞌi Maromak. Masik inan-aman susar basuk moos, lalika foo.’ Hodi hanorin nunia, emi soe tiꞌan Naꞌi Maromak ukun, seluk hodi emikaan ukun duꞌuk. ");
INSERT INTO tet_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tan baa nia, Haꞌu katak ohin kaꞌak, emi neꞌe dale seluk, halo seluk! Maromak makoꞌan Yesaya nakerek kedan hori uluk nosi emi naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ema nia sia tonun Haꞌu, nodi ibun dei, la nodi neon. ");
INSERT INTO tet_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tonun oin nunia, butan dei. Sia la nikir Haꞌukaan ukun, sia nikir loos ema raiklaran ukun dei.’ ” ");
INSERT INTO tet_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nunia hotu, Yesus bolu nola ema seluk iha nia, hotu nanorin sia naꞌak, “Taꞌan tilun diꞌa-diꞌak, nebee emi bele tolan! ");
INSERT INTO tet_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Saa mak tama baa ema ibun laran la nalo ema kadoor. Mais saa mak sai nosi ibun mak nalo kadoor.” ");
INSERT INTO tet_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hotu Yesus Niakaan maktuir sia mai nusu Nia naꞌak, “Ama, matene ka lale? Ema Farisi sia laran moras, tan rona Ama dale nia.” ");
INSERT INTO tet_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mais Yesus nataa naꞌak, “Haꞌukaan Ama iha laleꞌan atu fokit soe ema mak la nanorin tuir Niakaan beer. Nia atu fokit sia hanesan ema fokit mohu ai horis mak ema la beer. ");
INSERT INTO tet_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dadi lalika hanoin baa ema Farisi nia sia! Sia nia, hanesan ema matan delek mak nadaek malu. Toꞌo ikus, sia monu bele-bele tama baa kuak laran.” ");
INSERT INTO tet_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Hotu Petrus dale naꞌak, “Ama, malore baa ami lai lia hatetek nia isin!” ");
INSERT INTO tet_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus nataa naꞌak, “Emi moos sei la hatene dauk ka? ");
INSERT INTO tet_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Lia isin nuneꞌe: Saa mak ema haa, tama tuir ibun, liu baa kabun, hotu sai nikar baa luan. ");
INSERT INTO tet_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mais saa mak sai nosi ibun, lia nia mak nalo ema kadoor, toꞌo Naꞌi Maromak nakribi ema nia. ");
INSERT INTO tet_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Lia aat waꞌin sai nosi ema neon! Hanesan hanoin aat, hoꞌo ema, hakur biti-kluni, halo lia kfoꞌer, hanaꞌo, hataa lia tolek, no dale hahaat ema. ");
INSERT INTO tet_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Lia oin nunia sia mak nalo ema kadoor. Mais, kalo ema naa nodi la fasi uluk liman tuir adat, nia la dadi baa lia.” ");
INSERT INTO tet_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hotu Yesus laꞌo nela fatin nia, baa rai mak kreꞌis no kota Tirus no kota Sidon. ");
INSERT INTO tet_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Iha nia, noo feto ida nosi rai nia. Feto nia lahoos ema Yahudi. Mais baa oras rona Yesus mai tiꞌan, nia mai nusu tulun baa Yesus naꞌak, “Naꞌi Daud husar-binan! Madomi haꞌu lai! Diabu tekar haꞌukaan oan feto toꞌo nia susar basuk.” ");
INSERT INTO tet_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mais Yesus no-nook dei, la nataa saa ida. Hotu Niakaan maktuir sia mai nasara naꞌak, “Ama, feto neꞌe nahii nalau aan dei. Diꞌak liu Ama naruka nia sees nosi neꞌe ona!” ");
INSERT INTO tet_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus nataa naꞌak, “Naꞌi Maromak naruka Haꞌu kmai atu tulun itakaan ema Yahudi, tan sia hanesan bibi malae mak laꞌo sala dalan. Nia la naruka Haꞌu kmai tulun ema seluk.” ");
INSERT INTO tet_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mais feto nia mai kre-reꞌis tenik baa Yesus. Nia nakniꞌa nusu tulun naꞌak, “Ama Boot! Ama tulun haꞌu lai!” ");
INSERT INTO tet_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hotu Yesus soe lia naꞌak, “La kona kalo hola haan hosi lawarik oan, foo baa asu.” Lia isin subar naꞌak, Yesus musti tulun Niakaan ema Yahudi, lahoos ema seluk. ");
INSERT INTO tet_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mais feto nia nataa naꞌak, “Tebes, Ama! Mais asu nia iha hadak ohak. Nia moos bele naa saa mak monu nosi lawarik oan bikan.” Lia isin subar naꞌak, baa oras lawarik oan naa, asu moos bele naa. Masik Yesus tulun Niakaan ema sia moos, Nia musti tulun no ema seluk. ");
INSERT INTO tet_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Rona nola nunia, Yesus katak baa feto nia naꞌak, “Ina, tan o fiar tebe-tebes, fila ona. Saa mak o musu nia dadi tiꞌan!” Hotu feto nia fila. Toꞌo uma baa, naree oan diꞌak tebes tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nunia hotu, Yesus no Niakaan maktuir sia laꞌo nela fatin nia, laꞌo nalolon tuir debu Galilea tehen. Hotu sia saꞌe liu baa foho ida atu nein heik iha nia. ");
INSERT INTO tet_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ema lear moos mai baa Yesus. Sia nodi ema ai kmaꞌas, ema matan delek, ema ai asak, ema nunuk, no ema moras seluk sia. Sia rai ema moras nia sia kre-reꞌis baa Yesus ain. Hotu Nia nadiꞌak nola sia. ");
INSERT INTO tet_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Titu-naree nunia, ema lear nia moos blaar. Sia dale naꞌak, “Makaꞌas liu resik! Ema ai kmaꞌas, bele laꞌo. Ema matan delek, bele naree. Ema ai asak, bele diꞌak. Ema nunuk, bele dale! Neꞌe nanis Naꞌi Maromak mak nalo. Nia mak ema Yahudi sia loꞌu-sudur baa.” ");
INSERT INTO tet_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nunia hotu, Yesus bolu nola Niakaan maktuir sia nodi dale naꞌak, “Haꞌu kdodan tebes ema lear neꞌe sia. Balu mai nosi dook. Sia namutuk iha neꞌe loron tolu tiꞌan, toꞌo haan la noo ona. Diꞌak liu sia keta fila nodi kabun mamuk. Keta toꞌo sia nakloti iha dalan klaran tan salaen.” ");
INSERT INTO tet_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mais Yesus Niakaan maktuir sia nataa naꞌak, “Ama! Fatik neꞌe dook nosi leo. Ita la bele hahaan ema lear nuneꞌe.” ");
INSERT INTO tet_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mais Yesus nusu sia naꞌak, “Emi hoo tubi baluk hira?” Sia nataa naꞌak, “Baluk hitu dei! No naꞌan tasi oan ida!” ");
INSERT INTO tet_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hotu Yesus naruka ema nia sia hotu-hotu tuur baa rai. ");
INSERT INTO tet_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nia nola tubi baluk hitu no naꞌan tasi nia, hotu sera dodan baa Naꞌi Maromak. Hotu Nia tohi faꞌe, foo baa maktuir sia nebee faꞌe baa ema nia sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sia hotu-hotu moos naa toꞌo bosu. Naa notu, maktuir sia libur nola haan resin sia, nakonu koꞌe boot hitu. ");
INSERT INTO tet_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ema hotu-hotu mak naa nia, takseer mane naꞌin rihun haat. Sei la sura dauk feto no lawarik oan sia. ");
INSERT INTO tet_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nunia hotu, Yesus naruka ema lear nia fila nikar. Hotu Nia saꞌe baa bero atu baa rai Magadan. ");
INSERT INTO tet_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Baa loron ida, ema Farisi no ema Saduki naꞌin hira mai baa Yesus. Sia nakara nakusuk lia fuan no Nia atu nahonu Nia. Tan lia nia, sia nusu Yesus naꞌak, “Ama! Tulun matudu tadak blaar lai, nebee dadi kakaer naꞌak Ama netan beran nosi Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mais Yesus nataa naꞌak, “Kalo loro monu no kaloꞌan ilas mean, emi hatadan haꞌak, ‘Awan la udan.’ ");
INSERT INTO tet_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kalo loro saꞌe nodi kaloꞌan metan, emi hatadan haꞌak, ‘Ohin loron neꞌe atu udan.’ Kalo emi bele leno tadak nunia, tan saa emi la bele leno tadak nosi Naꞌi Maromak? ");
INSERT INTO tet_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hoi! Emi ema oras neꞌe hatene loos halo aat dei! Emi la hikir Naꞌi Maromak! Masik emi husu tadak blaar moos, Haꞌu la kfoo. Uluk Naꞌi Maromak nalo tadak blaar tiꞌan nodi Niakaan makoꞌan Yunus. Nia, toꞌo tiꞌan!” Dale notu nunia, Yesus laꞌo nela sia. ");
INSERT INTO tet_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hotu Yesus sia saꞌe baa bero. Toꞌo debu klaran baa, foin maktuir sia nanoin nola naꞌak sia naluꞌa tubi bakae. ");
INSERT INTO tet_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Rona nola sia dale nunia, Yesus moos katak naꞌak, “Musti sintidu ho ema Farisi no ema Saduki siakaan tua teen tubi.” ");
INSERT INTO tet_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rona nola nunia, maktuir sia benar karin. Sia dale baa malu naꞌak, “Itakaan Ama dale saa mak nia? Arumak Nia dale nunia tan ita la hodi tubi ka?” ");
INSERT INTO tet_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mais Yesus natene siakaan neon. Nia moos katak naꞌak, “Hoi! Emi neꞌe liu resik tiꞌan! Tan saa emi dale hosi tubi! Emi sei la duun fiar baa Haꞌu ka? ");
INSERT INTO tet_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Emi sei la duun hatene Haꞌukaan beran ka? Oras Haꞌu ktohi faꞌe tubi baluk lima kodi kahaan ema naꞌin rihun lima nia, koꞌe hira mak emi hodi libur hola tubi resin nia sia? ");
INSERT INTO tet_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nunabee tenik, hodi tubi baluk hitu nia mak Haꞌu ktohi faꞌe foo baa ema naꞌin rihun haat nia? Koꞌe hira mak emi hodi libur hola tubi resin nia sia? ");
INSERT INTO tet_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tan saa emi sei la hatene Haꞌukaan dalen nia? Haꞌu la kdale kosi tubi. Haꞌu kdale kosi ema Farisi no ema Saduki siakaan aꞌaat. Tan siakaan sasuꞌat nia bele beꞌur nola ema waꞌin, hanesan tua teen oan ida nalo tubi dadi boot.” ");
INSERT INTO tet_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus dale nunia, foin sia natene naꞌak Nia la dale nosi tubi. Nia dale nosi ema Farisi no ema Saduki siakaan hanorin mak la loos. ");
INSERT INTO tet_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nunia hotu, Yesus sia laꞌo baa kota Kaisarea Filipi. Iha dalan klaran, Nia nusu baa Niakaan maktuir sia naꞌak, “Tuir ema dalen, Haꞌu, Ema Raiklaran Isin neꞌe, see?” ");
INSERT INTO tet_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sia nataa naꞌak, “Ema balu naꞌak Ama neꞌe, Yohanis Mak Sarani Ema mak moris nikar. Seluk naꞌak, arumak Ama neꞌe, Bei Elia. Seluk tenik naꞌak, Bei Yeremia. Kalo lale, Maromak makoꞌan uluk aan ida seluk.” ");
INSERT INTO tet_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hotu Yesus nusu tenik naꞌak, “Mais, kalo tuir emi duꞌuk, Haꞌu neꞌe, see?” ");
INSERT INTO tet_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus nataa naꞌak, “Ama neꞌe, Kristus, Ema mak Naꞌi Maromak nameno tiꞌan hori uluk atu solok mai! Ama neꞌe moos Naꞌi Maromak mak moris nima-nimak Oan.” ");
INSERT INTO tet_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hotu Yesus naꞌak, “Simon, Yunus oan, o neꞌe sotir! Lahoos ema raiklaran mak katak lia neꞌe baa o, mais Haꞌukaan Ama iha laleꞌan mak katak baa o. ");
INSERT INTO tet_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Rona! Haꞌu ktau naran baa o kaꞌak ‘Petrus’, mak lia isin naꞌak fatuk. Tan okaan fiar biit tiꞌan nuꞌu fatuk, o atu dadi uma tatuur fatuk bodik Haꞌukaan ema makfiar sia. Masik diabu nodi beran aat hotu-hotu sokur Haꞌukaan ema sia moos, la bele natoba nola. ");
INSERT INTO tet_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Haꞌu klatan beran baa o, nebee maliku Haꞌukaan ema sia. Neꞌe, hanesan o kaer sabi laleꞌan. Saa mak o badu iha raiklaran, Naꞌi Maromak moos badu tiꞌan iha laleꞌan. Saa mak o mabusik iha raiklaran, Naꞌi Maromak moos nabusik tiꞌan iha laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dale notu nunia, Yesus nakahik sia nebee keta katak baa se-see naꞌak, Nia mak Kristus. ");
INSERT INTO tet_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nahuu nosi oras nia, Yesus nalore kedan baa Niakaan maktuir sia nosi lia saa mak atu dadi baa Nia. Nia katak naꞌak, “Haꞌu kmusti baa Yerusalem. Iha nebaa, Haꞌu atu ketan susar waꞌin boot kosi itakaan ema Yahudi fukun sia, naꞌilulik ulun sia, no manorik ukun sia. Sia atu noꞌo Haꞌu, mais baa wainrua Haꞌu kmoris kikar.” ");
INSERT INTO tet_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Oras Yesus katak nunia, Petrus dada nodi Nia baa sorin hotu nasee naꞌak, “Ama, keta dale nunia! Haꞌu kaloon baa Naꞌi Maromak nebee keta nabusik Ama!” ");
INSERT INTO tet_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mais Petrus dalen nia la kona baa Naꞌi Maromak hakaran. Tan lia nia, Yesus nasee nikar Petrus naꞌak, “Hoi! Sees mosi neꞌe! Okaan lia fuan nia, diabu ulun mak dale! Keta saseni Haꞌu! O manoin loos ema raiklaran hakaran dei, lahoos Naꞌi Maromak hakaran!” ");
INSERT INTO tet_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hotu Yesus nanorin baa maktuir sia naꞌak, “Ema mak nakara tuir Haꞌu, musti naterus aan tuir bei-beik sura loron! Nia musti naluꞌa lakon niakaan hakaran duꞌuk, nebee tuir Naꞌi Maromak hakaran dei. Masik ema atu noꞌo nia moos, nia musti tuir bei-beik, hanesan ema ida natiu niakaan ai karuus atu baa mate. ");
INSERT INTO tet_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ema mak simu mate tan tuir Haꞌu, nia atu netan moris nima-nimak no Haꞌu. Mais ema mak nakara moris loos bodik isin lolon duꞌuk, niakaan moris nia atu lakon nunia dei! ");
INSERT INTO tet_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Rona! Kalo o metan raiklaran sasoin hotu-hotu, mais Naꞌi Maromak dudu sees o, niakaan sotir mak saa? Masik o loi modi raiklaran sasoin hotu-hotu moos, sasoin nia la bele seluk okaan kmalar! ");
INSERT INTO tet_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Haꞌu katak lia neꞌe sia hotu-hotu baa emi, tan Haꞌu neꞌe, mak Ema Raiklaran Isin nosi laleꞌan. Nosi ikus, Haꞌu atu kmai kikar kodi Haꞌukaan Aman beran makaꞌas, bele-bele ko Niakaan makbukar laleꞌan sia. Baa oras nia, Haꞌu atu kselu baa ema ida-idak tuir niakaan hahalok. ");
INSERT INTO tet_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Nosi emi hotu-hotu iha neꞌe, ema naꞌin hira la mate dauk toꞌo naree Haꞌu, Ema Raiklaran nosi laleꞌan, kaer ukun nodi beran boot hanesan Naꞌin.” ");
INSERT INTO tet_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Loron neen hotu, Yesus bolu nola Petrus, Yakobus no alin Yohanis. Nia tene sia atu saꞌe bele-bele baa foho aas ida, nebee sia mesan iha nebaa. ");
INSERT INTO tet_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Toꞌo foho leten baa, sia titu-naree Yesus nakfilas. Niakaan oin naksinak hanesan loro. Niakaan tais moos dadi mutin molen. ");
INSERT INTO tet_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Teki-tekis, sia titu-naree tenik Nia noꞌi dale no Bei Elia no Bei Musa. ");
INSERT INTO tet_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Naree nola nunia, Petrus benar toꞌo dale karin naꞌak, “Ama! Ami horan furak tiꞌan iha neꞌe! Diꞌak liu ami hariik hola batane tolu. Ida bodik Ama, ida bodik Bei Musa, no ida tenik bodik Bei Elia.” ");
INSERT INTO tet_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Baa oras Petrus sei dale nunia, teki-tekis kaloꞌan tuun mai nakalus nola sia. Sia moos blaar tan rona lia maliak ida sai nosi kaloꞌan nia naꞌak, “Rona lai! Yesus neꞌe, Haꞌukaan Oan dadobe. Nia nalo Haꞌu neon diꞌak tebes. Rona diꞌa-diꞌak baa Nia!” ");
INSERT INTO tet_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Rona nola nunia, maktuir nia sia nataꞌuk basuk toꞌo nakloti tabarakat. ");
INSERT INTO tet_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mais Yesus mai kebit sia nodi dale naꞌak, “Hadeer ona! Keta hataꞌuk!” ");
INSERT INTO tet_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Rona nola nunia, sia foti oin mais la titu-naree se-see tenik iha nia. Hela mesan Yesus dei mak iha nia. ");
INSERT INTO tet_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Oras sia nahuu tuun nosi foho nia, Yesus nakahik sia naꞌak, “Saa mak emi foin haree nia, keta katak baa se-see! Tan Haꞌu neꞌe, Ema Raiklaran Isin mak tuun mai nosi laleꞌan. Haꞌu kmusti mate uluk lai. Haꞌu kmoris kikar tiꞌan, foin emi bele katak baa ema seluk.” ");
INSERT INTO tet_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hotu sia nusu baa Nia naꞌak, “Ama neꞌe, Kristus tebes. Mais Bei Elia iha nabee? Manorik ukun sia nanorin naꞌak, Bei Elia musti mai uluk lai, foin Kristus mai. Mais tuir Ama, nunabee?” ");
INSERT INTO tet_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus nataa naꞌak, “Tebes. Bei Elia musti mai uluk nebee loke dalan bodik Kristus. ");
INSERT INTO tet_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mais rona diꞌa-diꞌak! Bei Elia mai tiꞌan, mais ema la natene nia. Sia nasusar nia tuir siakaan hakaran dei. Sia moos atu nalo nunia baa Haꞌu neꞌe, mak Ema Raiklaran Isin nosi laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Rona notu nunia, foin sia natene naꞌak Bei Elia mak Yesus dale nia, Yohanis Mak Sarani Ema. ");
INSERT INTO tet_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Baa oras Yesus sia fila nikar, noo ema lear mak nein sia tiꞌan. Hotu katuas ida mai nakniꞌa nodi nusu tulun baa Yesus naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ama Boot! Madomi haꞌukaan oan lai! Nia moras horak bibi maten toꞌo nia susar basuk. Kalo nasaꞌe horak, naꞌin monu aan baa wee laran, lale, baa haꞌi laran. Tulun lai, Ama Boot! ");
INSERT INTO tet_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Haꞌu kodi nia baa Ama Boot Niakaan maktuir sia tiꞌan, mais sia la bele nadiꞌak nola nia.” ");
INSERT INTO tet_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Rona nola nunia, Yesus nakbehek Niakaan maktuir sia naꞌak, “Hoi! Emi neꞌe liu resik tiꞌan! Haꞌu kanorin emi hei-hein tiꞌan, mais emi la tolan. Tan saa emi sei la duun fiar baa Haꞌu? Haꞌu kmusti katerus aan baa emi toꞌo wainhira tenik? Hodi lawarik nia mai!” ");
INSERT INTO tet_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sia nodi lawarik nia mai, hotu Yesus teꞌur sai diabu nia. Diabu sai tiꞌan, lawarik nia moos diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Baa oras Yesus no Niakaan maktuir sia mesan, sia nusu baa Nia naꞌak, “Ama! Tan saa ami la bele teꞌur sai diabu ohin nia?” ");
INSERT INTO tet_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus nataa fila naꞌak, “Emi la bele teꞌur sai diabu nia, tan emi la fiar tebe-tebes. Hanoin! Kalo emi fiar tebe-tebes, masik fiar oan ida dei moos, la noo saa ida mak la bele halo. Emi bele haruka foho ida haꞌak, ‘Hoi foho! Lori baa nebaa!’ Foho nia moos, nanis lori. ");
INSERT INTO tet_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mais rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Diabu sia aat tebes. Kalo emi la hamulak no halirin aan hodi husu tulun baa Naꞌi Maromak, emi la bele teꞌur sai diabu oin nunia.” ");
INSERT INTO tet_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Baa loron ida, Yesus no maktuir sia libur malu iha rai Galilea. Nia katak baa sia naꞌak, “La kleur ona, ema atu faꞌan Haꞌu baa ema seluk. ");
INSERT INTO tet_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hotu sia noꞌo Haꞌu, Ema Raiklaran Isin nosi laleꞌan neꞌe. Haꞌu nanis kmate, mais baa wainrua, Haꞌu kmoris kikar.” Rona nola Nia dale nunia, maktuir sia noran susar basuk. ");
INSERT INTO tet_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Baa loron ida, Yesus no maktuir sia baa leo Kapernaum. Toꞌo nebaa, ema nosi Naꞌi Maromak Niakaan Uma Hamulak Huun mai baa Petrus nodi nusu naꞌak, “Okaan manorik selu bea baa Uma Hamulak Huun ka lale?” ");
INSERT INTO tet_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus nataa naꞌak, “Selu!” Hotu Petrus fila nikar baa siakaan hein fatin. Nia sei la nasara lia nia baa Yesus, Yesus katak kedan baa nia naꞌak, “Simon! Manoin kokon! Naꞌin sia iha raiklaran neꞌe nola bea nosi see? Nosi siakaan oan duꞌuk ka, nosi siakaan hutun-renu?” ");
INSERT INTO tet_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus nataa naꞌak, “Nosi hutun-renu!” Yesus natutan tenik naꞌak, “Kalo nunia, naꞌin oan duꞌuk la kona bea. ");
INSERT INTO tet_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nunia moos, bea Uma Hamulak Huun. Mais ita lalika buka lia ho maksisi bea sia. Diꞌak liu, o baa makair naꞌan tasi iha debu dei. Kohi mola naꞌan tasi uluk fohon, hotu loke naan tasi nia nunun. O atu metan osan murak tomak ida iha nunun laran. Hotu foti mola, modi baa selu bea bodik ita rua. Tan osan nia toꞌo tiꞌan bodik ita rua.” ");
INSERT INTO tet_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Baa oras nia, Yesus Niakaan maktuir sia mai nusu baa Nia naꞌak, “Ama! Nosi Naꞌi Maromak eman hotu-hotu, see mak boot kaliuk?” ");
INSERT INTO tet_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Rona nunia, Yesus bolu nola lawarik oan ida, hotu natuur baa siakaan klaran. ");
INSERT INTO tet_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Hotu Nia dale naꞌak, “Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Ema mak nakara dadi baa Naꞌi Maromak eman, nia musti filas neon no laran, nebee dadi hanesan lawarik oan mak neon loos. ");
INSERT INTO tet_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ema mak naraik aan hanesan lawarik oan neꞌe, ema nia mak boot kaliuk iha Naꞌi Maromak oin. ");
INSERT INTO tet_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kalo noo ema simu ema kiꞌik tan fiar baa Haꞌu, hanesan lawarik oan neꞌe, neꞌe naꞌak, ema nia moos simu Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Hotu Yesus katak tenik baa sia naꞌak, “Kalo ema sasuꞌat ema kiꞌik ida nebee nia tuir dalan sala toꞌo la fiar tenik baa Haꞌu, ema nia musti sintidu! Diꞌak liu kesi fatuk boot ida baa niakaan kakorok, hodi baa tonan mout baa tasi laran. ");
INSERT INTO tet_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Raiklaran neꞌe nanis fatin mak nakonu dinu, tan noo lia waꞌin mak nalo ema toꞌo monu baa sala. Mais ema mak netan dinu kaliuk, neꞌe mak, ema mak naseꞌi dalan aat toꞌo ema seluk nalo sala. ");
INSERT INTO tet_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kalo malo sala modi okaan liman, lale, okaan ain, taa kotu baa dei! Diꞌak liu o tama laleꞌan modi liman sorin dei, lale, ain sorin dei, nosi sia soe o baa haꞌi naraka modi liman rua no ain rua. ");
INSERT INTO tet_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kalo o malo sala modi matan, sukit sai dei! Diꞌak liu o tama laleꞌan modi matan sorin dei, nosi sia soe o baa haꞌi naraka modi matan rua.” ");
INSERT INTO tet_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Hotu Yesus dale tenik naꞌak, “Sintidu! Keta toꞌo emi titu haraik ema kiꞌik hanesan lawarik neꞌe sia, tan Naꞌi Maromak Niakaan makbukar laleꞌan daka sia. Baa oras nabee dei, makbukar laleꞌan nia sia bele tama baa Naꞌi Maromak atu nasara siakaan lia. ");
INSERT INTO tet_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Rona mai. Noo ema makbalin ida, niakaan bibi malae matan atus ida. Baa loron ida, bibi malae matan ida lakon. Emi haneo makbalin nia musti nalo saa? Nia nanis laꞌo nela niakaan bibi malae matan siwi nulu resin siwi nia iha foho leten, baa buka bibi malae matan ida mak lakon nia. Netan nikar tiꞌan, makbalin nia neon diꞌak tebes naree bibi malae matan ida mak lakon nia, liu nosi nia naree niakaan bibi malae matan siwi nulu resin siwi mak la lakon. Haꞌu neꞌe, Ema Raiklaran Isin nosi laleꞌan. Haꞌu kmai atu sori ema mak lakon nosi dalan moris loos. ");
INSERT INTO tet_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Masik mak lakon nia, lawarik kiꞌik oan ida dei moos, Haꞌukaan Ama iha laleꞌan la nakara.” ");
INSERT INTO tet_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Hotu Yesus dale tenik naꞌak, “Kalo okaan maluk nalo sala baa o, o duꞌuk mak musti baa masoru nia. Emi naꞌin rua mesan tiꞌan lai, foin katak niakaan salan. Kalo nia rona o, emi dame malu tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mais, kalo la noꞌuk rona, baa mola mamaluk ida-rua seluk. Hotu baa bele-bele hasoru ema nia, nebee dale tenik ho nia. Hakerek Moon naꞌak, ‘Iha lia ida, musti noo ema naꞌin rua-tolu mak naree nodi matan duꞌuk, foin bele simu siakaan dale.’ ");
INSERT INTO tet_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mais, kalo ema nia sei la noꞌuk rona emi, baa katak baa fukun sarani sia. Kalo nia la noꞌuk rona tenik, filak nia baa ema mak la natene Naꞌi Maromak. Kalo lale, filak nia baa ema matak, hanesan ema maksisi bea sia. ");
INSERT INTO tet_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Haꞌukaan dalen neꞌe, tebes no loos! Saa mak emi hakahik iha raiklaran, Naꞌi Maromak nakahik tiꞌan iha laleꞌan. Saa mak emi habusik iha raiklaran, Naꞌi Maromak nabusik tiꞌan iha laleꞌan. ");
INSERT INTO tet_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Haꞌu kdale tebes tenik kaꞌak, masik emi naꞌin rua dei hamulak hodi neon ida, Haꞌukaan Ama iha laleꞌan atu foo saa mak emi husu. ");
INSERT INTO tet_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kalo ema libur malu tan Haꞌu, masik naꞌin rua-tolu dei moos, Haꞌu kamutuk ko sia iha nia.” ");
INSERT INTO tet_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yesus dale notu nunia, Petrus mai nusu baa Nia naꞌak, “Ama Boot, haꞌu atu kusu oan ida. Kalo haꞌukaan belun nalo sala rua-ruan baa haꞌu, haꞌu kmusti foo pardua baa nia isin hira? Toꞌo isin hitu ka?” ");
INSERT INTO tet_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus nataa naꞌak, “Lale! Musti foo pardua baa belun isin hitu dala hitu nulu toꞌo la bele sura hola. ");
INSERT INTO tet_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tan Naꞌi Maromak moos atu sura nunia, hanesan naꞌin iha lia hatetek neꞌe. Rona mai! Noo naꞌin ida mak nakara sura tusan nosi eman serwisu sia. ");
INSERT INTO tet_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nia naruka ema baa bolu nola ema serwisu ida mak natusan maliun-maliun baa nia. ");
INSERT INTO tet_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mais nia la bele selu nola tusan nia. Rona nola nunia, naꞌin naruka naꞌak, ‘Baa faꞌan ema neꞌe no feen-oan sia hotu-hotu, dadi baa ata. Hotu faꞌan niakaan naha sia hotu-hotu, hodi selu niakaan tusan.’ ");
INSERT INTO tet_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Rona nola nunia, ema serwisu nia nakniꞌa iha naꞌin oin nodi nakroꞌan naꞌak, ‘Adeei ama! Tulun foo leet oan ida baa haꞌu lai, foin haꞌu kselu moos haꞌukaan tusan.’ ");
INSERT INTO tet_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Rona nola nunia, naꞌin neon monu. Nia moos noꞌas mohu tusan nia sia hotu-hotu, hotu nabusik ema serwisu nia. ");
INSERT INTO tet_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mais baa oras ema serwisu nia sai, nia nasoru nola belun ida mak natusan oan ida baa nia. Nia kohi nola kedan belun nia, misak baa kakorok nodi nakbehek naꞌak, ‘Hoi! Selu kedan okaan tusan oras neꞌe ona!’ ");
INSERT INTO tet_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Rona nola nunia, belun nia moos nakniꞌa nodi nakroꞌan naꞌak, ‘Adeei belu! Tulun foo leet oan ida baa haꞌu lai, foin haꞌu kselu moos haꞌukaan tusan baa o.’ ");
INSERT INTO tet_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mais ema nia naꞌak, ‘La bele! Musti selu kedan!’ Hotu nia natama belun baa bui, toꞌo belun selu mohu niakaan tusan. ");
INSERT INTO tet_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Baa oras naꞌin eman seluk sia rona saa mak dadi tiꞌan nia, sia noran susar. Hotu sia baa nasara kedan baa naꞌin. ");
INSERT INTO tet_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Rona nola nunia, naꞌin bolu nola ema mak la natene aan nia. Nia deꞌan naꞌak, ‘Hoi ema aat! O musu haꞌu nebee kadomi o, hotu haꞌu koꞌas mohu okaan tusan hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mais, tan saa o la madomi okaan belun hanesan haꞌu kadomi o nia?’ ");
INSERT INTO tet_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Naꞌin krakat toꞌo naruka dada hatama ema nia baa bui, nebee ema tonan naloot toꞌo nia selu mohu niakaan tusan sia hotu-hotu.” ");
INSERT INTO tet_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hotu Yesus taka lia hatetek nia nodi katak naꞌak, “Haꞌukaan Ama iha laleꞌan moos atu sura nunia, kalo emi la haluꞌa lakon emikaan belun salan.” ");
INSERT INTO tet_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nanorin notu lia nia sia hotu-hotu, Nia laꞌo nela Galilea atu baa rai Yudea iha mota Yordan sorin balu baa. ");
INSERT INTO tet_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ema lear moos tuir. Toꞌo nebaa, Nia nadiꞌak nola ema moras iha nia. ");
INSERT INTO tet_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Baa oras nia, ema Farisi naꞌin hira moos mai. Sia buka dalan atu nahonu Yesus nodi nusu naꞌak, “Ama! Tuir itakaan ukun-badu Yahudi, kalo mane noo feen tiꞌan, nia bele soe feen tan sohan saa dei ka, nunabee?” ");
INSERT INTO tet_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus nataa naꞌak, “Emi neꞌe ema matenek. Tan saa emi la hatene Hakerek Moon isin? Hakerek Moon naꞌak Naꞌi Maromak naseꞌi ema raiklaran, feto no mane. ");
INSERT INTO tet_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Noo hakerek tenik naꞌak, ‘Tan lia nia, mane musti laꞌo nela inan-aman, atu moris neon ida no feen, tan sia rua dadi mesak tiꞌan.’ ");
INSERT INTO tet_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kalo Naꞌi Maromak duꞌuk nalo sia rua dadi mesak tiꞌan, ema raiklaran keta sasa faꞌe ona!” ");
INSERT INTO tet_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Rona nola Yesus dale nunia, ema Farisi nia sia nusu tenik naꞌak, “Kalo nunia, tan saa Bei Musa foo ukun naꞌak, laꞌen bele soe feen, surak foo uluk hakerek soe malu baa feen?” ");
INSERT INTO tet_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus nataa naꞌak, “Bei Musa nabusik emikaan bei uluk sia soe feen, tan sia ulun fatuk hanesan emi! Mais baa oras Naꞌi Maromak naseꞌi raiklaran neꞌe, Nia la nakara nunia. ");
INSERT INTO tet_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mais tuir Haꞌu nuneꞌe: kalo feen nakur uluk biti-kluni, laꞌen bele soe feen. Mais, kalo feen la nakur biti-kluni, hotu laꞌen soe nia no nola tenik feto, neꞌe naꞌak, laꞌen nia nakur biti-kluni tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Rona nola nunia, Yesus Niakaan maktuir sia moos dale naꞌak, “Kalo nunia, diꞌak liu lalika ho feen dei.” ");
INSERT INTO tet_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesus nataa naꞌak, “Lahoos ema hotu-hotu mak bele simu Haꞌukaan dalen neꞌe. Hela mesan ema mak Naꞌi Maromak boi dei. ");
INSERT INTO tet_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Noo ema mak la noo feen, tan moris nodi nunia tiꞌan. Balu moos la noo feen, tan ema nalo nunia baa nia. Noo tenik ema mak boi la noo feen, tan beer nalaꞌo Naꞌi Maromak Niakaan serwisu. Nebee ema mak bele simu hanorin neꞌe, nia nalo tuir.” ");
INSERT INTO tet_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Baa oras nia, ema nakaꞌu nodi siakaan oan sia mai baa Yesus, nebee Nia rai liman baa, nodi dale natuun matak-malirin baa sia. Naree nunia, Niakaan maktuir sia nakahik ema nia sia. ");
INSERT INTO tet_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mais Yesus krakat nodi naꞌak, “Habusik lawarik nia sia mai baa Haꞌu! Keta saseni sia! Tan ema oin nunia sia mak Naꞌi Maromak eman.” ");
INSERT INTO tet_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hotu Yesus rai liman baa oan nia sia nodi nakroꞌan nebee Naꞌi Maromak natuun matak-malirin baa. Hotu, Nia laꞌo nela fatin nia. ");
INSERT INTO tet_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baa loron ida, ema ida mai nusu baa Yesus naꞌak, “Ama Manorik! Haꞌu kmusti kalo lia diꞌak oin nunabee, nebee haꞌu katene fukur kaꞌak, haꞌu kbele tama laleꞌan atu kmoris kamutuk ko Naꞌi Maromak?” ");
INSERT INTO tet_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus nataa naꞌak, “Tan saa o musu Haꞌu kosi lia saa mak diꞌak? Naꞌi Maromak mesan dei mak diꞌak. Kalo makara moris mo Nia, tuir lo-loos Niakaan ukun.” ");
INSERT INTO tet_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mais ema nia nusu tenik naꞌak, “Ukun mak nabee?” Yesus nataa naꞌak, “Keta hoꞌo ema; keta hakur biti-kluni; keta hanaꞌo; keta mataa lia tolek; ");
INSERT INTO tet_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","makneter inan-aman; tenik, madomi okaan maluk hanesan madomi isin lolon duꞌuk.” ");
INSERT INTO tet_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Rona nola nunia, ema nia nataa naꞌak, “Haꞌu kalaꞌo tiꞌan ukun nia sia hotu-hotu. Saa tenik mak sei la toꞌo dauk?” ");
INSERT INTO tet_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus nataa naꞌak, “Kalo makara tuir tebe-tebes Naꞌi Maromak beer, fila baa, faꞌan okaan sasoin sia hotu-hotu. Hotu faꞌe osan nia baa ema mukit sia. Halo hotu nunia lai, foin mai tuir Haꞌu. Nosi ikus, Naꞌi Maromak atu selu nikar sasoin waꞌin iha laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Rona nola nunia, ema nia fila nodi neon susar, tan nia soi basuk. ");
INSERT INTO tet_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hotu Yesus dale baa Niakaan maktuir sia naꞌak, “Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Ema maksoin sia mak susar kaliuk tama baa laleꞌan. ");
INSERT INTO tet_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kuda onta boot la bele tama baa laluꞌan tuir daun kuak. Nunia moos ema mak naloon loos baa sasoin dei, no la naloon baa Naꞌi Maromak. Sia la bele tama laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Rona nola nunia, maktuir sia blaar karin. Sia moos nataa naꞌak, “Kalo nunia, see mak bele tama laleꞌan?” ");
INSERT INTO tet_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus mana sia diꞌa-diꞌak, hotu dale naꞌak, “Kalo ema raiklaran mak nalo, nanis la bele. Mais, kalo Naꞌi Maromak mak nalo, hotu-hotu nanis bele!” ");
INSERT INTO tet_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hotu Petrus katak naꞌak, “Ama! Ami laꞌo hela tiꞌan amikaan sasoin hotu-hotu atu tuir Ama. Mais ami hetan saa?” ");
INSERT INTO tet_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus nataa naꞌak, “Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Nosi ikus, kalo Naꞌi Maromak nalo hotu-hotu dadi foun tiꞌan, Haꞌu, Ema Raiklaran Isin neꞌe, atu tuur baa kadera ukun boot. Tan emi tuir Haꞌu, emi atu tuur no baa kadera ukun sanulu resin rua, nebee dadi makotu lia bodik itakaan ema hunun Israꞌel sanulu resin rua! ");
INSERT INTO tet_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ema mak laꞌo nela niakaan uma, niakaan maun-alin, niakaan inan-aman, niakaan oan sia, no niakaan toꞌos atu tuir Haꞌu, ema nia atu simu nikar toꞌo isin atus ida. Hotu, kalo rai falu fila, nia moos netan moris no Naꞌi Maromak toꞌo nima-nimak. ");
INSERT INTO tet_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hanoin! Ema waꞌin naboot aan, mais Naꞌi Maromak atu nafoli sia naꞌak, ema kiꞌik kaliuk. Ema mak nakiꞌik aan, Naꞌi Maromak atu nafoli sia naꞌak, ema boot.” ");
INSERT INTO tet_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nunia hotu, Yesus nanorin naꞌak, “Naꞌi Maromak kaer ukun, hanesan toꞌos naꞌin iha lia hatetek neꞌe. Noo toꞌos naꞌin ida mak sai tuku neen seisawan, baa buka ema atu serwisu iha niakaan toꞌos anggor. ");
INSERT INTO tet_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Netan tiꞌan, nia namate lia no sia, nebee sia serwisu loron ida, selu osan murak tomak ida tuir folin nanis. Hotu nia naruka sia baa serwisu iha niakaan toꞌos. ");
INSERT INTO tet_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tuku siwi seisawan, nia sai tenik baa dalan. Nia nasoru tenik ema naꞌin hira mak noꞌi tuur lerek dei. ");
INSERT INTO tet_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nia katak baa sia naꞌak, “Hei mau sia! Emi hoꞌuk serwisu iha haꞌukaan toꞌos ka lale? Haꞌu atu kselu tuir folin mak nanis.” Rona nola nunia, sia moos noꞌuk. Hotu sia baa serwisu kedan. ");
INSERT INTO tet_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tuku sanulu resin rua, no tuku tolu loron malirin, toꞌos naꞌin sai buka tenik ema serwisu. ");
INSERT INTO tet_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Loro malirin tiꞌan, takseer tuku lima, nia moos sai tenik. Nia buka baa-mai ema mak nariik loos sia dei. Hotu nia nusu sia naꞌak, ‘Tan saa emi hariik loos hori seisawan toꞌo loro malirin la halo sa-saa?’ ");
INSERT INTO tet_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Sia nataa naꞌak, ‘Serwisu la noo.’ Hotu toꞌos naꞌin nia naꞌak, ‘Kalo nunia, baa serwisu iha haꞌukaan toꞌos ona!’ ");
INSERT INTO tet_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Oras tuku hanawa serwisu toꞌo tiꞌan, toꞌos naꞌin bolu nola niakaan mataroos ulun nodi naꞌak, ‘Bolu mola mataroos sia, hotu selu siakaan osan serwisu ida-idak, nahuu nosi ema mak tama ikus, toꞌo ema mak tama uluk.’ ");
INSERT INTO tet_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Rona nola nunia, mataroos ulun bolu nola ema mak nahuu serwisu nosi tuku lima loro malirin. Nia selu baa sia ida-idak osan murak tomak ida. ");
INSERT INTO tet_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hotu mataroos ulun bolu nola mataroos seluk sia, toꞌo baa mataroos mak serwisu nahuu nosi tuku neen seisawan. Sia naneo naꞌak, sia nanis simu waꞌin liu nosi ema mak foin serwisu baa tuku lima loro malirin nia. Mais hatene hodi baa, sia moos simu osan murak tomak ida. ");
INSERT INTO tet_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Naree nunia, sia naksuhuk baa toꞌos naꞌin naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Hoi! La bele nuneꞌe ama! Ema mak mai ikus basuk, serwisu tuku ida dei. Mais ami mak tama seisawan, serwisu kreꞌis mate toꞌo kosar turu! Tan saa ama selu ami manesak ho sia?’ ");
INSERT INTO tet_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Toꞌos naꞌin nataa baa ida nosi sia naꞌak, ‘Mau! Haꞌu la kliꞌis. Mau duꞌuk mak simu serwisu loron ida, seba osan murak tomak ida. Tebes ka? Haꞌu ktuir tiꞌan itakaan lia mamaten nia. ");
INSERT INTO tet_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Diꞌak liu mau simu mau osan seba, modi fila ona. Haꞌu kakara selu baa ema mak tama serwisu ikus, manesak no mau. ");
INSERT INTO tet_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","O laran moras baa saa? Haꞌu naꞌin kasai osan duꞌuk. Nansaa mau nawan saꞌe haꞌu, tan haꞌu laran diꞌak baa ema?’ ” ");
INSERT INTO tet_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hotu Yesus natuka lia hatetek nia naꞌak, “Nunia moos, baa oras Naꞌi Maromak dadi Naꞌin baa Niakaan hutun-renu sia. Ema kiꞌik, Nia nafoli naꞌak, ema boot. Ema boot, Nia nafoli naꞌak, ema kiꞌik.” ");
INSERT INTO tet_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nunia hotu, Yesus sia atu laꞌo baa Yerusalem. Iha dalan klaran, Nia bolu Niakaan maktuir sia naklibur mesan no Nia. Hotu Nia katak baa sia naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Rona mai! Oras neꞌe ita atu baa Yerusalem. Iha nebaa, ema atu faꞌan Haꞌu, Ema Raiklaran Isin neꞌe, baa naꞌilulik ulun sia no manorik ukun sia. Hotu sia taa ukun mate baa Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sia moos latan Haꞌu baa ema seluk mak la natene Naꞌi Maromak. Hotu sia dale namoe Haꞌu. Sia noꞌat nadodok Haꞌukaan isin. Foin sia nedi noꞌo Haꞌu baa ai karuus. Haꞌu kmate tebes. Mais baa wainrua, Haꞌu kmoris kikar.” ");
INSERT INTO tet_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nunia hotu, Sebadeus feen mai baa Yesus, bele-bele no oan Yakobus no Yohanis. Nia nakniꞌa nodi nakneter, tan nakara nola Yesus neon. ");
INSERT INTO tet_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Hotu Yesus nusu baa nia naꞌak, “Ina atu musu saa?” Nia nataa naꞌak, “Nuneꞌe Ama! Haꞌu kusu nebee, kalo Ama kaer ukun tiꞌan, Ama foti haꞌukaan oan naꞌin rua neꞌe, nebee sia moos kaer ukun bele-bele no Ama. Haꞌu kusu nebee Ama natuur ida iha Ama sorin kwana, no ida iha sorin karuk.” ");
INSERT INTO tet_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Rona feto nia nusu nunia, Yesus katak baa Yakobus no Yohanis naꞌak, “Emi la hatene saa mak emi husu. Haꞌu atu ketan susar waꞌin. Emi haneo haꞌak emi moos bele hatiu susar nunia ka?” Sia rua nataa diꞌa-diꞌak dei naꞌak, “Bele basuk, Ama!” ");
INSERT INTO tet_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hotu Yesus nataa tenik naꞌak, “Tebes. Emi moos atu hatiu susar hanesan Haꞌu. Mais see mak atu tuur iha Haꞌukaan sorin kwana no karuk, lia nia lahoos Haꞌu mak kakotu. Naꞌi Maromak duꞌuk mak nakotu. Nia nakotu kedan se-see mak tuur iha fatik nia.” ");
INSERT INTO tet_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Baa oras maktuir sanulu rumak sia rona Yakobus no Yohanis nusu nunia, sia moos krakat. ");
INSERT INTO tet_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mais Yesus bolu nola sia hotu-hotu nodi naꞌak, “Nuneꞌe! Emi hatene tiꞌan haꞌak, naꞌin sia iha raiklaran tonan nanis siakaan renun, toꞌo renun la bele nakfodak. Ulun sia nosi ema klubun mak la natene Maromak, sia moos foo ukun liu kladik toꞌo renun la bele foti ulun. ");
INSERT INTO tet_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mais emi la bele halo nunia! See mak nakara dadi ema boot, nia musti dadi mataroos nodi naliku ema seluk. ");
INSERT INTO tet_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","See mak nakara dadi ulun, nia musti dadi ata. ");
INSERT INTO tet_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Haꞌu, Ema Raiklaran Isin nosi laleꞌan, moos nunia. Haꞌu kmai, lahoos nebee ema naliku Haꞌu. Mais Haꞌu kmai atu kaliku ema, kodi latan Haꞌukaan moris tomak atu sori ema waꞌin.” ");
INSERT INTO tet_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nunia hotu, Yesus sia laꞌo liu. Baa oras sia sai nosi kota Yeriko, ema lear moos laꞌo tuir. ");
INSERT INTO tet_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iha nia, noo ema matan delek naꞌin rua. Sia noꞌi tuur iha dalan tehen. Baa oras sia rona nola naꞌak ema mak laꞌo liu nia, Yesus nosi Nasaret, sia moos nahii nodi lian makaꞌas naꞌak, “Ama Boot! Naꞌi Daud husar-binan! Madomi ami lai!” ");
INSERT INTO tet_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Rona nola sia nahii nunia, ema sia iha nia nakahik sia naꞌak, “Hoi! Emi rua keta hanoro!” Mais sia nahii hetak makaꞌas tenik naꞌak, “Ama Boot! Naꞌi Daud husar-binan! Madomi ami lai!” ");
INSERT INTO tet_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Baa oras Yesus rona nola sia, Nia nanawa nodi nusu naꞌak, “Emi hakara Haꞌu atu kalo saa baa emi?” ");
INSERT INTO tet_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Sia dale naꞌak, “Ama Boot! Tulun lai, nebee ami bele haree.” ");
INSERT INTO tet_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Rona nola nunia, Yesus neon monu baa sia. Nia koko siakaan matan, hotu matan moon kedas. Hotu, sia moos tuir Nia. ");
INSERT INTO tet_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nunia hotu, Yesus sia laꞌo liu baa leo ida naran Betfage iha Foho Saitun tehen. Leo nia kreꞌis baa kota Yerusalem. Iha nia, sia nanawa heik. Hotu Yesus solok Niakaan maktuir naꞌin rua baa uluk. ");
INSERT INTO tet_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nia naruka sia naꞌak, “Emi rua baa leo nebaa. Oras emi tama baa, emi atu haree kuda keledai inan ida no oan, mak ema kesi iha nia. Baa kore hola, dada hodi mai Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kalo ema mai nusu emi naꞌak, ‘Tan saa emi dada hodi ema niakaan kuda keledai?’ Emi musti hataa haꞌak, ‘Naꞌin atu saꞌe. Saꞌe notu, Nia solok nikar mai kedas.’ ");
INSERT INTO tet_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lia neꞌe sia hotu-hotu natoꞌo lia mak Maromak makoꞌan nakerek kedan hori uluk naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Hei, emi ema Yerusalem sia! Mana lai! Emikaan Naꞌin namaan aan mai. Nia namaan aan mai nodi naraik aan. Nia namaan aan mai saꞌe kuda keledai oan.’ ” ");
INSERT INTO tet_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesus naruka nunia tiꞌan, maktuir nia sia baa, nalo tuir hotu-hotu mak Yesus nameno nia. ");
INSERT INTO tet_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sia dada nodi kuda keledai inan nia no oan mai baa Yesus. Hotu sia taka siakaan tais hafuꞌut baa, nebee Yesus saꞌe, tama baa kota. ");
INSERT INTO tet_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ema lear moos nola siakaan tais hafuꞌut no tais sakat, naꞌe baa dalan. Balu moos baa taa nola beet tahan felar keke baa dalan klaran. Hodi nunia, sia foo kneter nodi simu Yesus hanesan naꞌin. ");
INSERT INTO tet_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Baa oras nia, ema balu laꞌo uluk Yesus, balu tenik tuir nosi kotuk. Sia nahii bele-bele naꞌak, “Hosana! Ami tonu-haboot Naꞌi Maromak! Naꞌi Daud husar-binan namaan aan mai tiꞌan! Hosana! Ami tonu-haboot Naꞌi Maromak! Naꞌi Maromak solok Ema neꞌe mai tiꞌan. Hosana! Ami tonu-haboot Naꞌi Maromak, mak nabesi aan iha laleꞌan mak aas kaliuk!” ");
INSERT INTO tet_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Baa oras Yesus tama Yerusalem nodi dahur nunia, ema kota laran tomak sai mai nodi nusu naꞌak, “Hoi! See mak mai nia?” ");
INSERT INTO tet_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ema lear nia nataa naꞌak, “Ema neꞌe, mak Maromak makoꞌan, naran Yesus. Nia, ema Nasaret nosi rai Galilea.” ");
INSERT INTO tet_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hotu Yesus sia laꞌo liu toꞌo Naꞌi Maromak Niakaan Uma Hamulak Huun. Iha Uma Hamulak Huun lalawar, noo ema makfaꞌan oi-oik iha nia. Titu-naree nunia, Yesus baa nalatu sai sia nodi sobu karin fatin sia mak sia nodi taruka osan, no faꞌan manu lakateu sina mak ema nalo baa sera. ");
INSERT INTO tet_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hotu Nia katak baa sia naꞌak, “Maromak makoꞌan nakerek kedan hori uluk naꞌak, ‘Haꞌu kariik Haꞌukaan Uma, nebee dadi fatin hamulak.’ Naꞌi Maromak nakara nunia, mais emi halo Uma neꞌe, dadi baa ema naꞌok knuuk!” ");
INSERT INTO tet_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nunia hotu, ema matan delek no ema ai asak sia mai baa Yesus iha Uma Hamulak Huun. Nia moos nadiꞌak nola sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mais baa oras naꞌilulik ulun sia no manorik ukun sia titu-naree Yesus nalo tadak blaar nunia, sia krakat. Iha nia moos lawarik oan sia nahii bele-bele naꞌak, “Hosana! Ami tonu-haboot Naꞌi Maromak, tan Naꞌi Daud husar-binan mai tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Rona lawarik oan sia nahii nunia, naꞌilulik ulun sia krakat liu tan tenik, tan sia la simu dalen nia. Hotu sia katak baa Yesus naꞌak, “Hoi! O rona lawarik oan nia sia ka lale?” Yesus nataa naꞌak, “Haꞌu krona. Nansaa? Emi sei la leno dauk iha Hakerek Moon nosi lawarik oan mak tonu-naboot Naꞌi Maromak ka? Hakerek tiꞌan naꞌak, ‘Naꞌi Maromak babilan kau mea oan no lawarik kiꞌik oan sia, nebee sia tonu-naboot Nia.’ ” ");
INSERT INTO tet_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hotu Yesus no Niakaan maktuir sia sai nela kota, baa toba iha leo Betania. ");
INSERT INTO tet_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Baa awan seisawan, Yesus sia baa nikar kota Yerusalem. Mais iha dalan klaran, Yesus noran salaen. ");
INSERT INTO tet_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hotu titu-naree ai huun ida iha dalan tehen. Ema naa nanis ai huun nia fuan. Nia baa nareꞌis aan baa ai huun nia atu naree kokon, noo fuan ka lale. Mais toꞌo baa, Nia la naree fuan ida kois, tan ai huun nia foin nataha. Nia moos dale baa ai huun nia naꞌak, “Tan o la masai fuan baa Haꞌu, o la mafua ona!” Dale notu nunia, ai huun nia moos maran kedas. ");
INSERT INTO tet_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Naree nunia, Niakaan maktuir sia sarebak. Sia nusu naꞌak, “Tan saa, teki-tekis dei, ai huun neꞌe maran kedas?” ");
INSERT INTO tet_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus nataa naꞌak, “Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Kalo emi fiar tebe-tebes baa Naꞌi Maromak hodi la hakerat kedan, emi bele halo nuꞌu Haꞌu kalo baa ai huun nia. Lahoos nia dei, tan emi moos bele halo liu tan tenik. Emi bele haruka foho ida niꞌit aan lori baa tasi. Naꞌi Maromak nanis lori foho nia kedas, surak emi fiar tebe-tebes baa Nia! ");
INSERT INTO tet_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lia hotu-hotu mak emi husu baa Naꞌi Maromak, emi nanis simu, surak fiar tebe-tebes baa Nia.” ");
INSERT INTO tet_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hotu Yesus sia laꞌo liu. Toꞌo Yerusalem baa, sia tama nikar baa Uma Hamulak Huun. Baa oras foin tama baa lalawar, naꞌilulik ulun sia no fukun adat sia mai nakusuk baa Yesus naꞌak, “Hori sehik aan, see mak naruka o mai tokar lauk iha neꞌe? See mak latan beran nia baa o?” ");
INSERT INTO tet_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mais Yesus natene sia buka dalan atu nahonu Nia. Hotu Nia nataa naꞌak, “Haꞌu moos kakara kusu lia ida baa emi. Emi hataa Haꞌu lai, foin kataa emi. ");
INSERT INTO tet_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Haꞌu atu kusu nuneꞌe: ita hotu-hotu hatene Yohanis, ema nia mak sarani ema. See mak latan beran baa nia nebee nia sarani ema? Naꞌi Maromak ka, ema raiklaran?” Rona nola Yesus dale nunia, sia nanoin baa-mai nodi dale baa malu naꞌak, “Adeei! Ita kona diꞌa tiꞌan! Kalo ita hataa haꞌak, ‘Naꞌi Maromak mak latan beran’, Nia atu nataa fila naꞌak, ‘Kalo nunia, tan saa emi la fiar Yohanis!’ ");
INSERT INTO tet_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mais ita moos la bele hataa haꞌak, ‘Ema raiklaran mak latan beran’, tan ema hotu-hotu bele krakat ita. Sia fiar naꞌak, Yohanis nia, Maromak makoꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tan lia nia, sia nataa Yesus naꞌak, “Ami la hatene.” Yesus moos simu naꞌak, “Kalo nunia, Haꞌu moos lalika katak see mak latan beran baa Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Hotu Yesus dale liu no ema boot nia sia naꞌak, “Emi hanoin nunabee baa lia hatetek nuneꞌe: Noo ama ida no oan mane naꞌin rua. Baa loron ida, Aman naruka oan naꞌin ida naꞌak, ‘Oa! Ohin loron neꞌe, o baa serwisu iha toꞌos lai.’ ");
INSERT INTO tet_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mais oan nia nataa naꞌak, ‘Aa! Haꞌu la kbaa.’ Mais la kleur, oan nia sadiꞌa. Hotu nia baa. ");
INSERT INTO tet_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Hotu ama nia naruka oan ida tenik naꞌak, ‘Oa! Ohin loron neꞌe, o baa serwisu iha toꞌos lai.’ Hotu oan nia nataa naꞌak, ‘Diꞌak ama. Haꞌu kbaa’. Mais hatene hodi baa, nia la baa.” ");
INSERT INTO tet_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dale notu nunia, Yesus nusu baa sia naꞌak, “Oras neꞌe Haꞌu atu kusu nuneꞌe: Nosi oan naꞌin rua nia, nabee mak nalo tuir aman harukan?” Sia moos nataa naꞌak, “Mak uluk!” Hotu Yesus dale naꞌak, “Tebes! Mais rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Ema aat nuꞌu ema maksisi bea no feto dalan aat sia atu tama uluk emi, dadi baa Naꞌi Maromak eman. Tan emi hatene simu loos Naꞌi Maromak dei, mais la halo tuir Niakaan hakara. ");
INSERT INTO tet_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Uluk, Yohanis Mak Sarani Ema nanorin emi tiꞌan, oin nunabee emi bele moris loos. Mais emi la hikir nia. Tuir loos, ema aat sia moos nanono baa Yohanis tiꞌan. Sia laꞌo nela siakaan salan nodi nalo tuir niakaan hanorin. Mais emi la hoꞌuk hanawa hosi emikaan salan no halo tuir niakaan hanorin.” ");
INSERT INTO tet_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nunia hotu, Yesus dale lia hatetek ida tenik baa ema boot nia sia naꞌak, “Noo ema rai naꞌin ida. Nia loke niakaan rai rohan ida, nalo baa toꞌos foun atu kuda ai anggor baa. Hotu nia baꞌa nalik. Nia moos keꞌe kuak ida, atu nalo baa fatik rai anggor ween. Nia moos nariik uma toꞌos aas ida atu nodi daka toꞌos. Hotu nia seba toꞌos nia baa ema serwisu toꞌos, nebee sia faꞌe toꞌos isin no nia. Hotu nia laꞌo baa rai dook. ");
INSERT INTO tet_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Toꞌo oras kuꞌu, toꞌos naꞌin solok niakaan ema ain-liman sia baa ema serwisu toꞌos nia, atu nusu niakaan fafaꞌek. ");
INSERT INTO tet_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mais ema serwisu sia la nikir sia. Niakaan ema ain-liman balu kona taꞌe, balu kona hoꞌo, no balu tenik kona tuda hodi fatuk. ");
INSERT INTO tet_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Natene nola nunia, toꞌos naꞌin solok tenik ema ain-liman klibur boot ida, liu nosi mak nia solok uluk nia. Mais ema serwisu nia sia moos nalo aat baa sia. ");
INSERT INTO tet_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kleu-leur, ema toꞌos naꞌin solok oan duꞌuk. Nia naneo naꞌak, ‘Kalo haꞌu ksolok haꞌukaan oan duꞌuk, sia nanis simu nia no nanono baa nia.’ ");
INSERT INTO tet_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mais baa oras ema serwisu sia naree nola oan nia, sia moos dale baa malu naꞌak, ‘Mana lai! Katuas solok oan duꞌuk. Nia mak atu simu katuas sasoin hotu-hotu. Diꞌak liu ita hoꞌo nia ona, nebee hola toꞌos neꞌe baa ita.’ ");
INSERT INTO tet_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hotu sia kohi nola oan nia, dada baa toꞌos luan, hotu noꞌo nia.” ");
INSERT INTO tet_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dale notu nunia, Yesus natuka lia hatetek nia nodi nusu baa ema boot nia sia naꞌak, “Oras neꞌe, atu kusu nuneꞌe: Kalo toꞌos naꞌin nia mai nikar, emi hanoin nia nalo oinsaa baa ema serwisu nia sia?” ");
INSERT INTO tet_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hotu ema boot nia sia nataa naꞌak, “Nanis nia noꞌo ema aat nia sia hotu-hotu. Hotu nia seba toꞌos nia baa ema seluk mak faꞌe toꞌos isin kona baa niakaan oras.” ");
INSERT INTO tet_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hotu Yesus dale tenik naꞌak, “Arumak emi sei la leno dauk saa mak hakerek tiꞌan iha Hakerek Moon naꞌak, ‘Noo fatuk ida mak badaen fatuk sia soe lerek tiꞌan. Mais oras neꞌe fatuk nia dadi baa uma tatuur fatuk tiꞌan! Naꞌi Maromak duꞌuk mak boi nola, nodi natuur fatuk nia. Etuk ita haree baa, kabaas tebes!’ ” ");
INSERT INTO tet_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hotu Yesus dale natutan naꞌak, “Rona! Uluk, Naꞌi Maromak boi ita ema Yahudi neꞌe, nebee ita dadi baa Niakaan ema. Mais, tan emi la hoꞌuk hikir Haꞌu, Naꞌi Maromak atu boi ema seluk, tan ema mak tuir Niakaan hakara dei mak bele tama dadi baa Niakaan ema. ");
INSERT INTO tet_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Rona diꞌa-diꞌak! Ema mak nakloti kona fatuk neꞌe, nanis netan kastikar. Mais, kalo fatuk nia monu kona ema, ema nia netan kastikar todan liu.” ");
INSERT INTO tet_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Rona nola Yesus dale nunia, ema boot nia sia natene naꞌak, Nia nakrai lia baa sia. Sia manesak no ema serwisu toꞌos mak aat nia, no badaen fatuk mak soe lerek fatuk tatuur nia. ");
INSERT INTO tet_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tan baa nia, sia nawan saꞌe tebe-tebes. Sia moos buka dalan atu kohi nola Nia. Mais sia nakerat ema lear, tan ema lear sia filak Yesus naꞌak, Maromak makoꞌan. Tan lia nia, ema boot nia sia la nalo sa-saa baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Hotu Yesus dale tenik nodi lia hatetek naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Naꞌi Maromak kaer ukun nia, hanesan naꞌin ida mak nalo dahur tan oan mane nola feto. ");
INSERT INTO tet_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Baa oras dahur tetuk tiꞌan, nia naruka atan baa katak ema mak kona hamata sia naꞌak, ‘Mai ona, tan dahur atu nahuu ona.’ Mais ema nia sia la noꞌuk mai. ");
INSERT INTO tet_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hotu ata nia fila baa nasara baa naꞌin. Rona nola nunia, naꞌin naruka ata seluk sia naꞌak, ‘Baa katak baa ema mak kona hamata sia nebee mai ona, tan dahur tetuk tiꞌan. Haꞌu koꞌo karau teꞌin kalo midar tiꞌan. Haruka sia mai ona, tan hotu-hotu tetuk tiꞌan.’ ");
INSERT INTO tet_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Hotu ata nia sia baa katak nunia. Mais ema mak kona hamata nia sia la nikir nola. Balu baa toꞌos, balu baa serwisu fatin, ");
INSERT INTO tet_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","no balu tenik kohi nola ata nia sia, naloot sia toꞌo mate. ");
INSERT INTO tet_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Rona nola nunia, naꞌin nawan saꞌe tebe-tebes. Nia naruka sondadu sia baa noꞌo ema mak noꞌo atan sia. Hotu sondadu nia sia moos sunu kota nia toꞌo weer baa rai. ");
INSERT INTO tet_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hotu naꞌin nia bolu nola atan seluk sia, nodi katak baa naꞌak, ‘Dahur tetuk tiꞌan, mais ema mak haꞌu kamata tiꞌan sia, la fatan tuir haꞌukaan dahur. ");
INSERT INTO tet_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Oras neꞌe, emi sai baa dalan sia, hamata hola se-see dei mak emi hasoru hola iha nia.’ ");
INSERT INTO tet_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hotu ata nia sia sai baa dalan. Sia nodi mai ema waꞌin, toꞌo ema diꞌak no ema aat nakonu nola dahur fatin nia. ");
INSERT INTO tet_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hotu naꞌi nia tama baa dahur fatin nia atu naree niakaan bainaka. Nia titu-naree bainaka ida mak la tau tais dahur. ");
INSERT INTO tet_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hotu naꞌin nusu naꞌak, ‘Hoi maluk! Tan saa o tama iha neꞌe, la tau tais dahur?’ Mais ema nia la nataa. ");
INSERT INTO tet_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hotu naꞌi naruka kedan niakaan ema serwisu sia naꞌak, ‘Futu ema neꞌe ain-liman, soe baa luan. Habusik nia tanis no susar iha fatin makukun nebaa.’ ” ");
INSERT INTO tet_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dale notu nunia, Yesus natuka lia hatetek nia naꞌak, “Nunia moos Naꞌi Maromak. Nia bolu ema waꞌin. Mais ema naꞌin hira dei mak fatan dadi baa Niakaan eman.” ");
INSERT INTO tet_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nunia tiꞌan, ema Farisi sia baa kabuar lia atu buka Yesus ain nodi tula lia baa Nia. ");
INSERT INTO tet_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hotu sia naruka siakaan ema no ema nosi partee Herodes, baa bele-bele nusu lia baa Yesus. Toꞌo Yesus baa, sia mose Nia naꞌak, “Ama Manorik! Ami hatene Ama neon loos. Ama la natene tolek, no la fihir oin. Ama moos nanorin Naꞌi Maromak dalan moris nodi loos. ");
INSERT INTO tet_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Oras neꞌe, ami atu husu lia ida: Tuir itakaan ukun-badu Yahudi, ita musti selu bea baa liurai Roma ka lale?” ");
INSERT INTO tet_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mais Yesus natene naꞌak, sia atu rai diꞌa baa Nia, nebee dale sakar liurai Roma. Tan lia nia, Nia nataa naꞌak, “Etuk oin emi neꞌe, ema oin-kotuk! Nansaa emi buka Haꞌukaan ain hodi lia nia? ");
INSERT INTO tet_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hatudu kokon osan murak tomak ida mak emi hodi selu bea!” Sia moos natudu osan murak tomak ida baa Nia. ");
INSERT INTO tet_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Hotu Nia nusu baa sia naꞌak, “Neꞌe, see niakaan oin? Neꞌe, see niakaan naran?” ");
INSERT INTO tet_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sia nataa naꞌak, “Nia, Keser, mak liurai Roma.” Hotu Yesus katak baa sia naꞌak, “Kalo nunia, foo baa ukunrai saa mak ukunrai niakaan. No foo baa Maromak saa mak Maromak Niakaan.” ");
INSERT INTO tet_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Rona nola Yesus nataa nunia, sia hotu-hotu blaar karin, tan saa mak Yesus dale nia, makonak. Tan sia la bele nahonu nola Yesus, sia moos laꞌo nela Nia. ");
INSERT INTO tet_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Baa loron nia moos, ema nosi partee Saduki mai baa Yesus. Ema Saduki sia nanorin naꞌak, nosi ikus baa oras rai falu fila, ema mak mate tiꞌan la moris nikar ona. Hori hirak nia, sia mak buka dalan atu nadiꞌa Yesus, mais la bele. Tan baa nia, sia mai nusu tenik lia baa Nia naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ama Manorik! Bei Musa nakerek nela baa ita ema Yahudi, ukun-badu ida naꞌak: kalo mane ida mate nela feen, mais la noo oan, alin musti nola feto faluk nia, nebee foo husar-binan baa maun mak mate nia. ");
INSERT INTO tet_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Uluk Bei Musa nanorin nunia tebes. Mais noo lia ida nuneꞌe: Noo mane maun-alin naꞌin hitu. Mane ulun nola feen, hotu mate mais la noo oan. Hotu alin mak tuir nia, nola nikar feto faluk nia. ");
INSERT INTO tet_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","La kleur falik, alin nia moos mate la noo oan. Nunia tenik, alin susu dala rua, nola feto faluk nia, mais nia moos mate la noo oan. Nunia bei-beik toꞌo alin ikun moos mate. ");
INSERT INTO tet_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","La kleur feto faluk nia moos mate. ");
INSERT INTO tet_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Oras neꞌe ami atu husu nuneꞌe: Feto nia nola mane naꞌin hitu tiꞌan. Nosi ikus baa oras rai falu fila, kalo Naꞌi Maromak nalo ema mak mate tiꞌan moris nikar, feto nia dadi mane mak nabee feen?” ");
INSERT INTO tet_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Rona nola nunia, Yesus nataa naꞌak, “Kalo emi husu nunia, emi sala tiꞌan! Emi la hatene Hakerek Moon lia isin. Emi moos la hatene Naꞌi Maromak beran! ");
INSERT INTO tet_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Rona! Lia loos mak neꞌe! Naꞌi Maromak Niakaan makbukar laleꞌan la nola malu. Oras rai falu fila Naꞌi Maromak atu nalo ema mak mate tiꞌan moris nikar. Mais sia la nola malu ona, hanesan Niakaan makbukar laleꞌan sia. ");
INSERT INTO tet_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Haꞌu moos kalore tenik kosi lia ema mak mate tiꞌan bele moris nikar ka lale. Iha Hakerek Moon, no lia nosi lia neꞌe. Emi sei la leno dauk ka? Iha nia Naꞌi Maromak katak baa Bei Musa naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Haꞌu neꞌe, okaan Bei Abraham, Bei Isak, no Bei Yakob, siakaan Maromak. Sia hotu-hotu loꞌu-sudur baa Haꞌu hori uluk toꞌo oras neꞌe.’ Kalo ita leno nunia, ita hatene haꞌak, baa oras Naꞌi Maromak dale nunia, bei nia sia mate kleur tiꞌan. Masik nunia moos, Naꞌi Maromak katak naꞌak, sia sei loꞌu-sudur baa Nia. Lia nia naꞌak, siakaan kmalar sei moris. Dadi, masik ema mate tiꞌan, bele moris nikar.” ");
INSERT INTO tet_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Rona nola Yesus nanorin nunia, ema Saduki nia sia la bele nataa sa-saa tenik. Mais ema lear mak iha nia blaar karin nodi dale naꞌak, “Ema neꞌe nanorin makaꞌas basuk!” ");
INSERT INTO tet_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Baa oras ema Farisi sia natene naꞌak ema Saduki sia la bele nataa sa-saa tenik baa Yesus, sia moos naklibur buka dalan nebee buka Yesus ain. ");
INSERT INTO tet_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sia solok siakaan ibun-nanaan matenek ida atu baa nahonu Yesus. Toꞌo tiꞌan, nia katak naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ama Manorik! Haꞌu atu kusu nuneꞌe: Itakaan ukun-badu nosi Bei Musa, waꞌin toꞌo. Nosi ukun hotu-hotu nia, ukun nabee mak boot kaliuk?” ");
INSERT INTO tet_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus nataa naꞌak, “Ukun mak boot kaliuk nia, mak neꞌe: ‘Naꞌi Maromak nia, mak itakaan Maromak. Ita musti hadomi Nia liu hotu-hotu. Ita musti beer Nia bei-beik, no hakaꞌas aan hatene diꞌa-diꞌak Nia.’ ");
INSERT INTO tet_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ukun nia mak boot kaliuk no makaꞌas kaliuk! ");
INSERT INTO tet_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","No tenik ukun dala rua mak neꞌe: ‘Ita musti hadomi itakaan maluk, oin nudaar ita hadomi itakaan isin lolon duꞌuk.’ ");
INSERT INTO tet_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ukun rua neꞌe huun nosi Bei Musa niakaan ukun-badu no makoꞌan seluk siakaan hanorin hotu-hotu. Ema la bele tuir ukun seluk, kalo la tuir uluk ukun boot rua neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Baa oras ema Farisi nia sia sei libur malu iha nia, Yesus nusu baa sia naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Hori uluk aan Naꞌi Maromak nameno tiꞌan atu solok Kristus, nebee sori Niakaan ema sia. Tuir emi, Kristus nia, see husar-binan?” Sia nataa naꞌak, “Naꞌi Daud husar-binan.” ");
INSERT INTO tet_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hotu Yesus dale tenik naꞌak, “Kalo nunia, tan saa Naꞌi Maromak Kmalar Lulik katak baa Naꞌi Daud, nebee nia temi Kristus naꞌak ‘Naꞌi’? Tan Naꞌi Daud nakerek tiꞌan naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Naꞌi Maromak katak tiꞌan baa haꞌukaan Naꞌin naꞌak, “Mai tuur baa fatin kneter kaliuk neꞌe iha Haꞌukaan sorin kwana. Tan Haꞌu atu kalo okaan funu sia, loꞌu baa o.’ ” ");
INSERT INTO tet_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nosi hakerek nia, ita bele hatene haꞌak Naꞌi Daud duꞌuk temi Kristus naꞌak, ‘Naꞌi’. Tan lia nia, kalo ema naꞌak Kristus Naꞌi Daud husar-binan loos dei, lia nia sei la toꞌo dauk! Tan Nia moos Naꞌi Daud Naꞌin.” ");
INSERT INTO tet_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Rona nola Yesus dale nunia, ema Farisi sia no-nook dei, tan la noo ema ida kois mak bele nataa Yesus. Nahuu nosi loron nia, sia la naksakar aan tenik atu nahonu kokon Nia. ");
INSERT INTO tet_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nunia hotu, Yesus nanorin Niakaan maktuir sia namutuk no ema lear mak iha nia. ");
INSERT INTO tet_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Nia katak naꞌak, “Manorik ukun sia no ema Farisi sia kaer beran atu nanorin Ukun-badu Bei Musa. ");
INSERT INTO tet_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tan lia nia, emi musti hanono baa sia no tuir siakaan hanorin. Mais keta tuir saa mak sia nalo, tan sia duꞌuk la nalo tuir siakaan hanorin nia. ");
INSERT INTO tet_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sia seten ema atu natiu ukun-badu todan, mais sia duꞌuk la noꞌuk tulun ema atu tuir ukun-badu nia sia. ");
INSERT INTO tet_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hotu-hotu mak sia nalo, sia buka nebee ema tonu sia. Baa oras namulak, sia kesi Hakerek Moon baa ulun no nisa fafutar oi-oik baa faru klobor. Sia nalo bo-boot nunia, nebee ema mose sia naꞌak, ‘Ema nia sia, moon tebes!’ ");
INSERT INTO tet_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kalo tama uma hamulak, lale, tama nadahur, sia buka tuur fatik iha oin, nebee ema waꞌin titu-naree sia. ");
INSERT INTO tet_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kalo laꞌo baa nabee, sia moos rotus kneter. Sia buka ema sudur baa sia naꞌak, ‘Tabe, Ama Manorik.’ ");
INSERT INTO tet_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mais emi keta tuir siakaan moris lalaꞌok nia! Keta buka ema temi emi naꞌak, ‘Ulun’, tan emikaan Ulun mesak ida dei. Emi hotu-hotu moos, maun-alin. ");
INSERT INTO tet_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tan baa nia, keta mose ema iha raiklaran haꞌak, ‘Ama’, tan emikaan Ama iha laleꞌan mesak ida dei. ");
INSERT INTO tet_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Emi moos keta buka ema temi emi naꞌak, ‘Manorik’, tan emikaan Manorik mesak ida dei. Nia, mak Kristus. ");
INSERT INTO tet_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tan lia nia Haꞌu katak kaꞌak, keta foti aan hanesan ema mak rotus kneter sia. Emi see mak nakara dadi ema boot, nia musti dadi baa mataroos. ");
INSERT INTO tet_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ema mak foti aan, Naꞌi Maromak atu naraik nia. Mais ema mak naraik aan, Naꞌi Maromak atu nasaꞌek nia.” ");
INSERT INTO tet_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Hotu Yesus dale tenik naꞌak, “Hoi emi ema manorik ukun no ema Farisi sia! Etuk oin emi oin-kotuk! Emi nanis hetan dinu! Ema buka dalan atu tama dadi Naꞌi Maromak eman, mais emi saseni hola sia! Emi duꞌuk la hoꞌuk tama, mais emi saseni hola ema seluk. ");
INSERT INTO tet_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Hoi emi ema manorik ukun no ema Farisi sia! Etuk oin emi oin-kotuk! Emi nanis hetan dinu! Emi tolek bosok feto faluk sia, hodi hadau hola siakaan uma. Mais iha ema lear oin, emi taka emikaan aꞌaat nia, hodi hariik hamulak kleu-leur, nebee ema mose naꞌak emi, ema neon moos. Mais nosi ikus, Naꞌi Maromak atu taa ukun todan kaliuk baa emi. ");
INSERT INTO tet_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hoi emi ema manorik ukun no ema Farisi sia! Etuk oin emi oin-kotuk! Emi nanis hetan dinu! Emi saꞌe foho, tuun tasi, buka loos ema naꞌin ida, nebee nia dadi baa emikaan maktuir. Mais, kalo hetan tiꞌan, emi hanorin nia atu tuir emikaan aꞌaat, toꞌo nia moris aat liu tan tenik. Nosi ikus, nia atu netan kastikar iha haꞌi naraka, isin rua todan liu emi. ");
INSERT INTO tet_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Emi neꞌe, ema momok mak matan tomak! Tan saa emi sei hakara hatudu dalan baa ema seluk? Emi atu hetan dinu, tan emi hanorin hahutan karin haꞌak, ‘Kalo ema ida namate menon nodi nabasuk lian temi Naꞌi Maromak Niakaan Uma Hamulak Huun, ema nia la kesi aan no mamenon nia. Mais, kalo nabasuk lian temi naha mean mak iha Uma Hamulak Huun, foin nia kesi aan no mamenon nia.’ ");
INSERT INTO tet_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Emi neꞌe, ema momok mak matan tomak! Emi haneo haꞌak, Naꞌi Maromak nafoli naha mean liu nosi Niakaan Uma Hamulak Huun ka? Lale! Tan Uma nia mak nalo naha nia sia dadi moos! ");
INSERT INTO tet_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Emi moos hanorin hahutan karin haꞌak, ‘Kalo ema ida namate menon nodi nabasuk lian temi sera fatin mak iha Uma Hamulak Huun, ema nia la kesi aan no mamenon nia. Mais, kalo nabasuk lian temi sera mak iha fatin nia leten, foin nia kesi aan no mamenon nia.’ ");
INSERT INTO tet_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Emi neꞌe, delek tebe-tebes tiꞌan. Fatin sera nia, nanis folin liu sera mak iha fatin nia leten. Tan fatin nia, naꞌilulik nodi sera saa mak ema nodi foo baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kalo ema ida nabasuk lian temi sera fatin, neꞌe naꞌak, nia temi sera fatin no hotu-hotu mak iha fatin nia leten. ");
INSERT INTO tet_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kalo ema nabasuk lian temi Uma Hamulak Huun, neꞌe naꞌak, nia temi Uma Hamulak no Naꞌi Maromak naran, tan Nia mak nein iha nia. ");
INSERT INTO tet_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kalo ema nabasuk lian temi laleꞌan, neꞌe naꞌak, nia temi Naꞌi Maromak naran no Niakaan kadera ukun, tan Nia mak nabesi aan kaer ukun iha nia. ");
INSERT INTO tet_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hoi emi ema manorik ukun no ema Farisi sia! Etuk oin emi oin-kotuk! Emi nanis hetan dinu! Emi matenek basuk sura emikaan sasoin, nebee bele foo faꞌek ida nosi fafaꞌek sanulu baa Naꞌi Maromak. Emi sura lotu-lotuk, toꞌo toꞌos isin kiꞌik oan sia moos, emi sura mate. Emi sura lotu-lotuk emikaan salasi oan, kwenter oan no lisa oan sia, mais Ukun-badu mak folin kaliuk, emi haluꞌa lakon. Emi la tuir dalan moris loos. Emi la hadomi ema mukit sia. Emi la kalolon emikaan mamenon. Diꞌak liu, tuir lia nia sia hotu-hotu lai, foin sura emikaan babudun sia, nebee foo faꞌek ida baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Emi matan tomak tiꞌan! Tan saa emi sei hakara hatudu dalan baa ema seluk? Emi haseꞌi ukun lotu-lotuk hodi haruka ema seluk nalo tuir. Mais Ukun-badu mak folin kaliuk, emi duꞌuk la halo tuir. Hanesan emi taꞌes hasai lalar kiꞌik oan nosi emikaan wee hemu, mais buat boot nuꞌu karau, emi folan hola to-tomak dei! ");
INSERT INTO tet_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hoi emi ema manorik ukun no ema Farisi sia! Etuk oin emi oin-kotuk! Emi nanis hetan dinu! Emi hanesan ema mak fasi haa-hemu fatin toꞌo milat, mais milat iha luan dei. Tan emikaan madauk teen no rotus teen nia nalo emikaan neon laran, sei mahobos no sei kadoor. ");
INSERT INTO tet_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hoi emi ema Farisi matan tomak sia! Fasi uluk laran lai! Hodi nunia, foin luan moos dadi moos! ");
INSERT INTO tet_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Hoi emi mak ema manorik ukun no ema Farisi sia! Etuk oin emi oin-kotuk! Emi nanis hetan dinu! Emi hanesan rate mak ema kaser mutin. Ema naree nosi luan, kabaas basuk. Mais iha laran, nakonu no ema maten ruin no dois aat oi-oik. ");
INSERT INTO tet_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Emi moos nunia! Ema naree emi nosi luan, nuꞌu ema neon loos. Mais emikaan neon laran, nakonu no lia aat oi-oik. Emi dale seluk, halo seluk, hodi haluꞌa lakon Naꞌi Maromak ukun sia. ");
INSERT INTO tet_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hoi emi ema manorik ukun no ema Farisi sia! Etuk oin emi oin-kotuk! Emi atu hetan dinu! Emi halo rate kabaas bodik Maromak makoꞌan mak emikaan bei uluk sia noꞌo, no emi hafutar rate bodik ema moon mak emikaan bei uluk sia nadodok. ");
INSERT INTO tet_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hotu emi katak haꞌak, ‘Kalo ami moris otas ida ho amikaan bei uluk sia, ami nanis la tuir sia hodi hoꞌo Maromak makoꞌan sia.’ ");
INSERT INTO tet_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mais hodi nunia, emi lalore aan haꞌak, emi neꞌe ema aat husar-binan. ");
INSERT INTO tet_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Soꞌin baa, halo aat baa dei! Kalolon emikaan bei uluk sia! ");
INSERT INTO tet_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Emi neꞌe aat hanesan samea mahoo raso. Emi haneo Naꞌi Maromak la kastikar emi ka? Keta haloon kedan! Nia nanis soe lerek emi baa haꞌi naraka! ");
INSERT INTO tet_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Rona! Haꞌu atu ksolok Haꞌukaan ema sia atu nanorin emi no natudu Naꞌi Maromak dalan moris baa emi. Mais emi atu hoꞌo balu, no hedi mate balu baa ai karuus. Balu moos emi fota hoꞌat iha uma hamulak laran. Balu tenik, emi haloot toꞌo sia nalai nosi kota ida baa kota ida. ");
INSERT INTO tet_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Uluk aan, emikaan bei uluk sia noꞌo ema moon sia hosi otas baa otas, nahuu nosi Habel toꞌo Sakarias, mak Bakaria oan. Sia noꞌo Sakarias nia iha Uma Hamulak Huun lalawar, kreꞌis baa sera fatin. Mais, tan emi kalolon emikaan bei uluk siakaan aꞌaat, emi moos musti hatiu hola raan nosi ema moon nia sia. ");
INSERT INTO tet_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tebes! Haꞌukaan dalen neꞌe, tebes no loos! Emi mak moris baa oras neꞌe, atu kona kastikar tan lia aat mak emikaan bei uluk sia nalo hori uluk nia.” ");
INSERT INTO tet_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Hotu Yesus katak tenik naꞌak, “Hoi ema Yerusalem sia! Emi neꞌe mak hoꞌo hei-hein Maromak makoꞌan sia. Emi neꞌe mak hodi fatuk tuda hoꞌo ema mak mai tulun emi. Dala waꞌin tiꞌan Haꞌu atu klibur kodi lituk emi kosi aat, hanesan manu inan taka nola oan nodi liras. Mais emi la hoꞌuk. ");
INSERT INTO tet_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tan lia nia, Naꞌi Maromak la nikir tenik emikaan uma. Awan-wainrua, uma nia atu mamuk ona. ");
INSERT INTO tet_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rona! Emi la haree Haꞌu tenik ona, toꞌo oras emi katak sain haꞌak, ‘Ita husu nebee Naꞌi Maromak natuun matak-malirin baa Ema neꞌe, tan Naꞌi Maromak mak solok Nia.’ Emi katak sain nunia lai, foin bele haree hikar Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nunia hotu, Yesus laꞌo nela Uma Hamulak Huun. Baa oras sai, Niakaan maktuir sia natudu Uma Hamulak Huun niakaan kabaas baa Nia. ");
INSERT INTO tet_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mais Nia nataa naꞌak, “Uma neꞌe kabaas tebes! Mais rona, tan Haꞌukaan dalen neꞌe, tebes no loos! La kleur ona, ema atu nakroꞌon mohu fatuk neꞌe sia hotu-hotu.” ");
INSERT INTO tet_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hotu, Yesus baa tuur iha Foho Saitun. Niakaan maktuir sia mai atu dale mesan no Nia naꞌak, “Ama! Katak mikar kokon Ama dale ohin nia. Niakaan oras, wainhira toꞌo? Niakaan tadak, nunabee?” ");
INSERT INTO tet_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus nataa naꞌak, “Emi musti daka aan diꞌa-diꞌak, nebee keta kona beꞌur. ");
INSERT INTO tet_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ema oi-oik atu mai nodi basa karas naꞌak, ‘Haꞌu neꞌe, Kristus mak Naꞌi Maromak solok mai.’ Nodi nunia, sia beꞌur nola ema waꞌin. ");
INSERT INTO tet_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kalo emi haree ema natuda malu, lalika hataꞌuk. Kalo rona lia naꞌak, hatuda iha nabee dei, lalika hataꞌuk. Tan lia oin nunia, musti dadi. Mais loron rai falu fila sei la toꞌo dauk. ");
INSERT INTO tet_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ema hunun ida atu natuda sakar hunun seluk. Rai ida atu natuda sakar rai seluk. Rai nakdoko iha nabee dei. Rai salaen moos, boot basuk. ");
INSERT INTO tet_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mais lia nia hotu-hotu foin tadak uluk fohon naꞌak, oras rai falu fila kreꞌis ona. Hanesan feto mak foin noran moras, tan oras nahoris kreꞌis ona. ");
INSERT INTO tet_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Emi musti daka aan diꞌa-diꞌak, tan ema atu naloot nodi noꞌo emi. Ema nosi rai hotu-hotu atu hirus emi, tan tuir Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Baa oras nia, ema waꞌin atu taliꞌur Haꞌu. Ema atu hirus malu, nodi faꞌan malu. ");
INSERT INTO tet_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ema bosok teen moos atu mai nodi naꞌak, sia nia Maromak makoꞌan, toꞌo ema waꞌin moos fiar baa sia. ");
INSERT INTO tet_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Baa oras nia, ema siakaan aꞌaat hetak kleur, hetak waꞌin, toꞌo ema la nadomi malu ona. ");
INSERT INTO tet_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mais ema mak naterus aan toꞌo mate, Naꞌi Maromak nanis sori nia. ");
INSERT INTO tet_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Manfatin Diꞌak nosi lia Naꞌi Maromak kaer ukun musti keke lema raiklaran sikun sia, nebee ema hotu-hotu bele rona lai, foin rai falu fila.” ");
INSERT INTO tet_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Hotu Yesus dale liu tenik naꞌak, “Maromak makoꞌan Daniel nakerek kedan nosi ema aat basuk ida. Ema nia atu mai, tama baa nariik iha fatin lulik iha Naꞌi Maromak Niakaan Uma Hamulak Huun. Nodi nunia, nia nalo ema nakribi fatin nia, toꞌo Naꞌi Maromak moos taliꞌur laꞌo nela fatin nia. Dadi, kalo emi haree nunia tiꞌan, sintidu! (Ema mak leno hakerek neꞌe moos musti natene diꞌa-diꞌak!) ");
INSERT INTO tet_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Lia nia dadi tadak naꞌak, loron susar sia kreꞌis iha odamatan tiꞌan. Kalo haree nunia tiꞌan, ema rai Yudea hariik halai baa foho ona. ");
INSERT INTO tet_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ema mak sai nosi uma tiꞌan, keta fila baa nola naha tenik. Halai lai-lais ona, nebee keta kona dinu. ");
INSERT INTO tet_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ema mak iha toꞌos, keta fila baa nola tais manas tenik. Halai liu ona! ");
INSERT INTO tet_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Baa oras nia, ema susar kaliuk, neꞌe mak, feto makoꞌus no mak sei nasusu oan, tan sia la bele nalai lai-lais. ");
INSERT INTO tet_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Diꞌak liu, hamulak hodi hakroꞌan, nebee dinu nia keta mai kona baa rai udan, lale, kona baa loron hanawa serwisu. ");
INSERT INTO tet_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Loron nia sia, susar basuk! Nahuu nosi Naꞌi Maromak naseꞌi raiklaran toꞌo oras neꞌe, ema sei la naree dauk susar boot oin nunia. Ema moos la naree tenik susar oin nunia ona. ");
INSERT INTO tet_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kalo Naꞌi Maromak la nabadak loron susar nia sia, la noo ema ida mak bele moris. Mais, tan Nia nadomi Niakaan ema mak Nia boi nola, Nia atu nabadak loron susar nia sia. ");
INSERT INTO tet_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kalo loron nia toꞌo mai ona, emi atu rona ema naꞌak, ‘Haree lai! Kristus iha neꞌe!’ Ema seluk moos naꞌak, ‘Kristus iha nebaa!’ Mais keta fiar! ");
INSERT INTO tet_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ema atu mosu mai nodi basa karas naꞌak, ‘Haꞌu neꞌe, Kristus!’ Balu tenik naꞌak, ‘Haꞌu neꞌe, Maromak makoꞌan.’ Sia atu naseꞌi tadak blaar oi-oik nodi diabu beran toꞌo tolek nola ema. Sia sokur kokon, nebee Naꞌi Maromak eman sia moos bele kona beꞌur! ");
INSERT INTO tet_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dadi, emi musti daka aan diꞌa-diꞌak! Loron susar nia sia sei la toꞌo dauk, mais Haꞌu katak kedan baa emi! ");
INSERT INTO tet_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kalo ema katak baa emi naꞌak, ‘Kristus mai tiꞌan iha rai molik nebaa!’, keta baa nebaa. Kalo ema naꞌak, ‘Kristus mai iha uma laran neꞌe tiꞌan!’, keta fiar siakaan tolek nia. ");
INSERT INTO tet_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Haꞌu neꞌe, Ema Raiklaran Isin nosi laleꞌan. Baa oras Haꞌu kmai kikar iha raiklaran neꞌe, ema hotu-hotu atu titu-naree Haꞌu, hanesan ema naree mameran laka nosi lorosaꞌe baa loromonu. ");
INSERT INTO tet_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Baa oras Haꞌu kmai kikar, emi atu hatene malorek Haꞌu iha nabee. Hanesan ema natene malorek, manu kawaa naklibur iha fatin nabee, nanis noo naꞌan dodok iha nebaa.” ");
INSERT INTO tet_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Hotu Yesus katak natutan tenik baa Niakaan maktuir sia naꞌak, “Kalo loron susar nia sia siku tiꞌan, ‘Loro matan atu nakukun luri. Fulan moos la nakroma tenik ona. Fitun sia mosar nosi laleꞌan mai. Beran hotu-hotu iha laleꞌan sia moos nahutan karin.’ ");
INSERT INTO tet_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hotu, ema atu naree tadak iha laleꞌan mak natudu naꞌak, Ema Raiklaran Isin atu namaan aan mai nikar. Naree nola nunia, ema nosi rai hotu-hotu iha raiklaran, atu nataꞌuk toꞌo tanis. Haꞌu ktuun mai kodi kaloꞌan, foin sia naree Haꞌukaan beran no Haꞌukaan makaꞌas. ");
INSERT INTO tet_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hotu, Haꞌu atu karuka Naꞌi Maromak Niakaan makbukar laleꞌan sia, nebee baa libur nola ema hotu-hotu mak Haꞌu kboi kola tiꞌan, kosi rai ulun toꞌo rai ikun, kosi lorosaꞌe toꞌo loromonu, kosi lorokaras toꞌo lorokbelan.” ");
INSERT INTO tet_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Hotu Yesus dale tenik naꞌak, “Haꞌu kola knaninuk nuꞌu ai huun. Kalo ai tahan nahuu nakmodok, nia foo tadak naꞌak loro falin kreꞌis mai ona. ");
INSERT INTO tet_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nunia moos, loron susar mak Haꞌu katak ohin nia sia. Kalo loron susar nia sia toꞌo mai tiꞌan, nia foo tadak naꞌak, Haꞌu kreꞌis mai ona. ");
INSERT INTO tet_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Nosi ema hotu-hotu mak moris baa oras neꞌe, balu sei la mate dauk, mais loron susar nia sia mai tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Masik laleꞌan no raiklaran lakon mohu moos, Haꞌukaan Manfatin neꞌe nafati nohuun.” ");
INSERT INTO tet_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Hotu Yesus katak naꞌak, “La noo ema ida mak natene wainhira Haꞌu kmai kikar. Naꞌi Maromak Niakaan makbukar laleꞌan sia la natene. Haꞌu moos la katene. Haꞌukaan Ama mesan, mak natene. ");
INSERT INTO tet_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Haꞌu neꞌe, Ema Raiklaran Isin nosi laleꞌan. Oras Haꞌu kmai kikar, nuꞌu oras uluk aan, mak oras Noh sei moris. ");
INSERT INTO tet_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Baa oras nia, motasaꞌe boot sei la mai dauk. Ema moris hanesan da-dauk dei. Sia naa-nemu namidar aan, nodi nola malu bele-bele, toꞌo Noh tama baa roo boot nia laran. ");
INSERT INTO tet_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Oras motasaꞌe mai, lulun nodi sia, foin siakaan matan nakloke, no sia natene nola saa mak dadi tiꞌan nia. Nunia moos, baa oras Haꞌu kmai kikar. ");
INSERT INTO tet_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kalo ema naꞌin rua serwisu iha toꞌos, teki-tekis Naꞌi Maromak foti nodi ida, nela ida. ");
INSERT INTO tet_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kalo feto naꞌin rua fai hare, teki-tekis Naꞌi Maromak foti nodi ida, nela ida. ");
INSERT INTO tet_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tan lia nia, emi musti daka aan loron-kalan, tan la hatene wainhira emikaan Naꞌin atu namaan aan mai nikar. ");
INSERT INTO tet_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hanoin! Kalo ema uma naꞌin natene naꞌak, kalan neꞌe ema naꞌok atu mai, nanis nia daka bei-beik. ");
INSERT INTO tet_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Emi moos musti daka bei-beik nunia, tan emi la hatene wainhira Haꞌu kmai kikar.” ");
INSERT INTO tet_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Hotu Yesus dale tenik naꞌak, “Emi musti dadi hanesan ema ain-liman mak tuir bei-beik ulun hakaran. Lia hatetek nuneꞌe. Noo ulun ida atu baa fatin dook. Nia foti ema ain-liman ida atu naliku haa-hemu bodik niakaan ema uma laran. ");
INSERT INTO tet_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kalo ulun nia mai nikar, hotu naree nia serwisu diꞌa-diꞌak, nanis nia neon diꞌak no ema nia. ");
INSERT INTO tet_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rona! Haꞌukaan dalen neꞌe, tebes no loos! Kalo ema ain-liman serwisu diꞌa-diꞌak nunia, nanis niakaan ulun atu foo beran baa nia nebee naliku ulun sasoin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mais, kalo ema ain-liman nia aat, nia atu dale iha neon laran naꞌak, ‘Diꞌak tiꞌan! Ulun laꞌo tiꞌan nuneꞌe, sei kleur foin nia mai!’ ");
INSERT INTO tet_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nanoin nunia, nia nahuu taꞌe ema serwisu seluk sia. Nia tuur naa-nemu namidar aan bele-bele no ema tua lanuk teen sia. ");
INSERT INTO tet_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mais la nanoin nola, teki-tekis ulun fila mai. ");
INSERT INTO tet_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hotu ulun naloot nia tebe-tebes, toꞌo soe lerek nia baa luan, nebee nein namutuk no ema oin-kotuk sia. Iha fatin nia, ema noran susar basuk nodi tanis la nanawa.” ");
INSERT INTO tet_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Hotu Yesus dale natutan naꞌak, “Emi musti hadiꞌa aan atu simu Haꞌu kmai kikar, hanesan feto matenek iha lia hatetek neꞌe: Noo feto nurak naꞌin sanulu. Kalan ida, sia sai nodi badut atu baa simu sasudin mane ida iha siakaan maluk uman. ");
INSERT INTO tet_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nosi sia, noo lima mak momok. Lima seluk, matenek. ");
INSERT INTO tet_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mak momok sia, naluꞌa nodi mina resin. ");
INSERT INTO tet_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mais mak matenek sia, nodi kedas. ");
INSERT INTO tet_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Toꞌo uma nia baa, sasudin sei la mai dauk. Kleu-leur feto nurak nia sia matan nakati, toꞌo toba dukur. ");
INSERT INTO tet_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Baa kalan boot, ema nahii naꞌak, ‘Hoi! Sasudin mane mai tiꞌan! Mai simu nia!’ ");
INSERT INTO tet_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Rona nola nunia, feto nurak nia sia nadeer bele-bele. Hotu sia baa nola siakaan badut atu simu sasudin mane nia. ");
INSERT INTO tet_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mais feto momok sia nusu baa feto matenek sia naꞌak, ‘Hoi mamaluk sia! Tulun foo ami mina oan ida lai, tan amikaan badut atu mate ona!’ ");
INSERT INTO tet_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mais feto matenek sia nataa naꞌak, ‘Aikee! Keta nawan saꞌe, tan la bele. Amikaan mina neꞌe la toꞌo bodik ita hotu-hotu! Diꞌak liu emi baa sosa iha makfaꞌan mina sia.’ ");
INSERT INTO tet_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hotu sia sai baa sosa mina. Mais baa oras sia sai tiꞌan, sasudin mane moos toꞌo mai. Feto matenek sia tama baa dahur fatin bele-bele no sasudin no bainaka hotu-hotu. Tama hotu tiꞌan, ema sena odamatan. ");
INSERT INTO tet_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","La kleur, feto momok sia fila mai. Sia nariik iha luan nodi nahii naꞌak, ‘Ama Naꞌi! Ama Naꞌi! Tulun loke odamatan baa ami lai!’ ");
INSERT INTO tet_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mais naꞌin nataa naꞌak, ‘Hoi! La bele! Haꞌu la katene emi!’ ” ");
INSERT INTO tet_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hotu Yesus taka lia hatetek nia naꞌak, “Emi moos musti hadiꞌa aan nohuun, tan emi la hatene Haꞌu kmai kona baa loron saa, lale, kona baa tuku hira.” ");
INSERT INTO tet_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Hotu Yesus dale natutan nodi lia hatetek ida tenik naꞌak, “Kalo Haꞌu klaꞌo kela emi tiꞌan, emi musti serwisu diꞌa-diꞌak bodik Haꞌu, hanesan lia hatetek neꞌe: Noo ema ulun ida atu baa rai dook. Oras atu laꞌo, nia bolu nola niakaan ema serwisu naꞌin tolu, hotu naruka naꞌak, ‘Hola osan neꞌe, halo baa osan naꞌin. Kalo haꞌu kmai kikar, emi musti hasara baa haꞌu, emi hetan funan hira tiꞌan.’ ");
INSERT INTO tet_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Dale notu nunia, nia foo osan kakaluk lima baa ema serwisu nomer ida, nebee nia nalaꞌo osan nia toꞌo noo funan. Hotu nia foo osan kakaluk rua baa ema serwisu nomer rua, no osan kakaluk ida baa ema serwisu nomer tolu, tuir ida-idak niakaan babelen. Hotu ulun nia laꞌo baa rai dook. ");
INSERT INTO tet_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Simu nola osan nia, ema serwisu nomer ida sai kedan baa fatin faꞌan. La kleur, nia netan funan kakaluk lima. ");
INSERT INTO tet_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nunia moos ema serwisu nomer rua. Nia netan funan kakaluk rua. ");
INSERT INTO tet_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mais ema serwisu nomer tolu mak simu nola osan kakaluk ida nia, nia baa keꞌe kuak, hotu rai subar osan nia. ");
INSERT INTO tet_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","La kleur, ulun mai nikar. Nia libur nola niakaan ema serwisu naꞌin tolu nia atu leno niakaan osan mak sia babilan tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ema serwisu nomer ida tama baa, latan osan kakaluk sanulu. Nia dale naꞌak, ‘Ama boot! Hori hirak nia ita boot latan osan kakaluk lima baa haꞌu. Oras neꞌe, ketan osan funan kakaluk lima tenik.’ ");
INSERT INTO tet_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Rona nola nunia, ulun neon diꞌak. Nia dale naꞌak, ‘Kabaas! O neꞌe, ema serwisu mak diꞌak. Masik haꞌu la iha neꞌe moos, o serwisu bei-beik tuir haꞌukaan harukan. Tan o bele babilan lia kiꞌik nuneꞌe, haꞌu kfoti o atu babilan lia mak boot kaliuk. Haꞌu moos kalo dahur, nebee ita hotu-hotu neon diꞌak bele-bele.’ ");
INSERT INTO tet_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hotu ema serwisu nomer rua mai latan osan kakaluk haat. Nia dale naꞌak, ‘Ama boot! Uluk ita boot latan osan kakaluk rua baa haꞌu. Ita haree mai, tan haꞌu ketan osan funan kakaluk rua tenik.’ ");
INSERT INTO tet_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Rona nola nunia, ulun moos neon diꞌak. Nia dale naꞌak, ‘Kabaas! O neꞌe moos ema serwisu mak diꞌak. Masik haꞌu la iha neꞌe moos, o serwisu bei-beik tuir haꞌukaan harukan. Tan o bele babilan lia kiꞌik nuneꞌe, haꞌu kfoti o atu babilan lia mak boot kaliuk. Haꞌu moos kalo dahur, nebee ita hotu-hotu neon diꞌak bele-bele.’ ");
INSERT INTO tet_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Hotu ema serwisu nomer tolu tama. Nia dale naꞌak, ‘Ama boot! Haꞌu katene ita boot, ema mak laran makaꞌas. Ita boot hola saa mak ema seluk nalo, no kuꞌu hola saa mak ema seluk kuda. ");
INSERT INTO tet_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Haꞌu kataꞌuk, keta toꞌo osan neꞌe lakon mohu, hotu ita boot taa ukun baa haꞌu. Tan lia nia, haꞌu ksubar osan neꞌe diꞌa-diꞌak. Neꞌe, ama boot! Mola mikar ona ama boot osan kakaluk ida neꞌe, tan nafati dei!’ ");
INSERT INTO tet_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Rona nola nunia, ulun nakbehek nia naꞌak, ‘O neꞌe, ema serwisu mak aat no baruk teen! Kalo o matene tiꞌan maꞌak, haꞌu kola saa mak ema seluk nalo, no kuꞌu kola saa mak ema seluk kuda, ");
INSERT INTO tet_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","tan saa o la baa rai osan neꞌe iha uma rai osan dei? Nebee kalo haꞌu kmai kikar, bele ketan funan. Masik oan ida dei moos, soꞌin!’ ");
INSERT INTO tet_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hotu ulun naruka niakaan ema serwisu seluk sia naꞌak, ‘Hola hikar osan hosi ema neꞌe, latan baa ema serwisu mak netan funan kakaluk lima nia. ");
INSERT INTO tet_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ema mak babilan diꞌa-diꞌak saa mak nia kaer tiꞌan, nia atu netan hetak waꞌin tenik. Mais ema mak la noꞌuk babilan saa mak nia kaer tiꞌan, ema atu nola nikar hotu-hotu nosi nia.’ ");
INSERT INTO tet_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hotu ulun natutan tenik naꞌak, ‘Kohi hola ema serwisu mak la folin neꞌe. Dada sarat hodi nia baa luan. Habusik nia noran susar basuk nodi tanis la nanawa iha fatin makukun nebaa!’ ” ");
INSERT INTO tet_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Hotu Yesus dale liu naꞌak, “Haꞌu neꞌe, Ema Raiklaran Isin nosi laleꞌan. Haꞌu atu ktuun mai kikar kodi Haꞌukaan Ama beran mak makaꞌas, bele-bele ko Niakaan makbukar laleꞌan sia. Hotu Haꞌu kabesi aan baa Haꞌukaan kadera ukun makaꞌas, nebee kleno ema ida-idak hahalok, tuir saa mak sia nalo tiꞌan iha raiklaran. ");
INSERT INTO tet_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Baa oras nia, ema nosi rai hotu-hotu iha raiklaran naklibur. Sia ida-idak atu mai nasoru Haꞌu. Haꞌu atu ksasa-faꞌe sia, hanesan ema makbalin sasa faꞌe bibi malae nosi bibi dadi baa klibur rua. ");
INSERT INTO tet_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ema sia mak nalo tuir Naꞌi Maromak hakaran, Haꞌu atu ktau sia baa Haꞌukaan sorin kwana. Mais seluk sia, Haꞌu atu ktau baa sorin karuk. ");
INSERT INTO tet_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Baa oras nia, Haꞌu kaer ukun Naꞌin. Haꞌu katak baa ema mak iha Haꞌukaan sorin kwana kaꞌak, ‘Emi neꞌe mak simu matak-malirin hosi Haꞌukaan Ama. Mai tama baa fatin kabaas mak Nia babilan kedan bodik emi. Oras raiklaran sei la iha dauk, Nia babilan kedan tiꞌan fatin Nia bodik emi. ");
INSERT INTO tet_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Emi bele tama, tan uluk baa oras Haꞌu ksalaen, emi hahaan Haꞌu. Baa oras Haꞌu kanroo, emi haroo Haꞌu. Haꞌu kmai hanesan ema matak, emi simu Haꞌu iha emikaan uma. ");
INSERT INTO tet_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Haꞌu la koo tais, emi foo tais baa Haꞌu. Haꞌu kmoras, emi mai babilan Haꞌu. Haꞌu iha bui, emi mai haliku Haꞌu.’ ");
INSERT INTO tet_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Rona nola nunia, ema moon sia iha Haꞌukaan sorin kwana atu nataa nikar naꞌak, ‘Ama naꞌi boot, neꞌe nunabee tiꞌan? Ama naꞌi naꞌak, Ama naꞌi salaen, ami hahaan. Ama naꞌi nanroo, ami haroo. ");
INSERT INTO tet_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ama naꞌi hanesan ema matak, ami simu iha amikaan uma. Ama naꞌi la noo tais, ami foo tais. ");
INSERT INTO tet_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ama naꞌi moras, ami baa babilan. Ama naꞌi iha bui, ami haliku. Hori hirak ami halo lia nia sia?’ ");
INSERT INTO tet_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Haꞌu atu kataa sia kaꞌak, ‘Rona! Haꞌukaan dalen neꞌe, tebes no loos! Baa oras emi halo lia nunia sia bodik Haꞌukaan ema, masik sia ema kiꞌik basuk moos, emi halo tiꞌan bodik Haꞌu!’ ");
INSERT INTO tet_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hotu Haꞌu katak kedan baa ema seluk sia mak iha Haꞌukaan sorin karuk kaꞌak, ‘Hoi ema aat sia! Sees hosi neꞌe! Naꞌi Maromak lelen emi. Nia atu soe tama emi baa haꞌi naraka mak laka la nanawa. Nia nadiꞌa tiꞌan fatin susar nia bodik diabu sia no siakaan ulun. ");
INSERT INTO tet_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Emi kona lelen nia, tan oras Haꞌu ksalaen, emi la hahaan haꞌu. Oras Haꞌu kanroo, emi la haroo Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Haꞌu kmai hanesan ema matak, emi la simu Haꞌu iha emikaan uma. Haꞌu la koo tais, emi la foo. Haꞌu kmoras, emi la babilan. Haꞌu iha bui, emi la haliku.’ ");
INSERT INTO tet_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Rona nola nunia, ema aat nia sia atu nataa naꞌak, ‘Ama naꞌi boot, neꞌe nunabee tiꞌan? Ama naꞌi naꞌak, Ama naꞌi salaen, ami la hahaan. Ama naꞌi nanroo, ami la haroo. Ama naꞌi mai hanesan ema matak, ami la simu iha amikaan uma. Ama naꞌi la noo tais, ami la foo. Ama naꞌi moras, ami la babilan. Ama naꞌi iha bui, ami la haliku. Hori hirak ami halo ama naꞌi nunia?’ ");
INSERT INTO tet_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hotu Haꞌu atu kataa sia kaꞌak, ‘Rona! Haꞌukaan dalen neꞌe, tebes no loos! Baa oras emi la tulun Haꞌukaan ema kiꞌik sia, emi la tulun Haꞌu tiꞌan.’ ");
INSERT INTO tet_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hotu ema aat nia sia netan kastikar nima-nimak. Mais ema moon nia sia netan moris nima-nimak.” ");
INSERT INTO tet_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus nanorin notu lia nia sia hotu-hotu, Nia katak baa Niakaan maktuir sia naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Emi hatene tiꞌan haꞌak baa loron rua tenik, itakaan loron diꞌak sia toꞌo mai ona. Loron diꞌak nia mak ita halo Dahur Tubi Bakae. Kalo loron diꞌak nia toꞌo tiꞌan, ema atu faꞌan Ema Raiklaran Isin neꞌe. Hotu sia nedi noꞌo Haꞌu baa ai karuus.” ");
INSERT INTO tet_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Baa oras Yesus dale nunia, naꞌilulik ulun sia no fukun adat sia naklibur iha Kayafas uman. Kayafas nia, mak naꞌilulik ulun boot. ");
INSERT INTO tet_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kayafas sia buka dalan atu kohi no-nook Yesus, nebee sia bele noꞌo Nia. ");
INSERT INTO tet_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mais sia nahulin dalan naꞌak, “Hein lai! Keta kohi Nia baa loron diꞌak sia, tan ema lear sia bele nakfetik ita.” ");
INSERT INTO tet_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Baa oras nia, noo ema ida naran Simon. Nia nein iha leo Betania. Uluk, ema nakribi nia tan kona moras funi mea. Mais oras neꞌe, nia diꞌak tiꞌan. Baa oras loron diꞌak nia sia sei la toꞌo dauk, Yesus sia baa naa iha Simon uman. ");
INSERT INTO tet_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Baa oras sia naa, feto ida mai nasoru Yesus. Feto nia kaer botir ida mak ema nalo nosi fatuk mahoo folin todan. Botir nia moos nahisi mina morin isin mak folin todan basuk. Toꞌo Yesus baa, feto nia fui nanii mina nia baa Yesus ulun atu dadi tadak naꞌak nia nakneter Yesus. ");
INSERT INTO tet_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mais baa oras Yesus Niakaan maktuir sia titu-naree nunia, sia krakat naꞌak, “Hoi! Feto saa mak neꞌe, toꞌo soe butan mina morin mahoo folin todan basuk nia! ");
INSERT INTO tet_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Diꞌak liu faꞌan mina nia dei, nebee faꞌe osan waꞌin nia baa ema mukit!” ");
INSERT INTO tet_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mais Yesus natene siakaan neon. Nia dale naꞌak, “Keta hasusar feto neꞌe! Haꞌu neon diꞌak, tan nia fui tiꞌan mina morin neꞌe baa Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ema mukit sia namutuk no emi bei-beik. Mais la kleur ona, Haꞌu la kamutuk ko emi tenik, ");
INSERT INTO tet_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","tan Haꞌu atu kmate ona. Nodi fui mina morin neꞌe baa Haꞌu, feto neꞌe nahulin tiꞌan Haꞌukaan isin, hanesan nia kari kedan ai funan baa Haꞌukaan maten. ");
INSERT INTO tet_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rona! Haꞌukaan dalen neꞌe, tebes no loos! Oras ema keke lema Naꞌi Maromak Manfatin Diꞌak baa fatin hotu-hotu iha raiklaran tomak, sia moos nanis dale feto neꞌe niakaan dadiꞌak. Hodi nunia, ema nanoin feto neꞌe toꞌo nima-nimak.” ");
INSERT INTO tet_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nosi Yesus Niakaan maktuir naꞌin sanulu resin rua nia, naꞌin ida naran Yudas Iskariot. Baa loron nia, nia sai baa buka naꞌilulik ulun sia. ");
INSERT INTO tet_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Toꞌo sia baa, nia nusu naꞌak, “Ama sia! Kalo haꞌu kbele tulun emi kohi Yesus, emi foo saa baa haꞌu?” Sia moos nataa naꞌak, “Kalo makara faꞌan Nia baa ami, ami nanis selu.” Hotu sia sura nola osan murak tomak tolu nulu, latan baa Yudas. ");
INSERT INTO tet_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hotu Yudas sai atu buka dalan latan Yesus baa sia. ");
INSERT INTO tet_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sura tinan ema Yahudi sia nadahur loron diꞌak, loron hitu laran. Sia nanaran loron diꞌak nia sia naꞌak, ‘Dahur Tubi Bakae’. Baa oras dahur nia atu nahuu ona, Yesus Niakaan maktuir sia mai nusu baa Nia naꞌak, “Ama! Ohin kalan neꞌe ita musti loke Dahur Tubi Bakae hodi hoꞌo bibi malae atu haa baa Paska. Ama nakara ami baa hadiꞌa dahur fatik iha nabee?” ");
INSERT INTO tet_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hotu Yesus nataa naꞌak, “Emi tama baa kota laran, hotu atu hasoru hola katuas ida. Katak baa nia haꞌak nuneꞌe, ‘Ama! Amikaan Ama Manorik nusu fatin ida iha ama uman atu nadahur Paska no Niakaan maktuir sia.’ ” ");
INSERT INTO tet_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesus naruka notu nunia, Niakaan maktuir sia moos baa nalo tuir nunia. Hotu sia nadiꞌa dahur Paska iha fatin nia. ");
INSERT INTO tet_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kalan tiꞌan, Yesus no Niakaan maktuir naꞌin sanulu resin rua tuur nadahur. ");
INSERT INTO tet_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Baa oras sia naa, Yesus dale naꞌak, “Fiar Haꞌu! Ema ida nosi emi atu latan Haꞌu baa ema seluk.” ");
INSERT INTO tet_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rona nola nunia, sia noran la diꞌak. Sia ida-idak nusu baa Yesus naꞌak, “Ema mak Ita Boot dale nia, haꞌu ka?” ");
INSERT INTO tet_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nia moos nataa naꞌak, “Ema mak loban tubi namutuk no Haꞌu baa haan fatik neꞌe, nia mak atu faꞌan lakon Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hanoin! Ema Raiklaran Isin neꞌe musti mate atu natoꞌo saa mak Maromak makoꞌan sia nakerek kedan hori uluk. Mais sintidu! Ema mak faꞌan Haꞌu, nia atu natiu niakaan dinu! Diꞌak liu niakaan inan la nahoris kedan nia!” ");
INSERT INTO tet_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hotu Yudas, mak atu faꞌan Yesus, moos nusu kalolon naꞌak, “Nanis ema mak Ama dale nia, lahoos haꞌu ka?” Yesus nataa naꞌak, “O naꞌin duꞌuk mak maꞌak nunia tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Baa oras sia sei naa, Yesus foti nola tubi baluk ida, nodi sera dodan baa Naꞌi Maromak. Hotu Nia tohi faꞌe tubi nia, lolo foo baa Niakaan maktuir sia. Nia katak naꞌak, “Tubi neꞌe, Haꞌukaan isin. Simu, haa baa ona!” ");
INSERT INTO tet_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nunia hotu, Nia nola hemu fatik ida mak nakonu anggor ween. Nia namulak tenik, sera dodan baa Naꞌi Maromak. Hotu Nia lolo foo baa Niakaan maktuir sia. Nia katak naꞌak, “Simu, hemu baa ona. ");
INSERT INTO tet_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Anggor ween neꞌe, Haꞌukaan raan mak atu nakduar nodi sori ema lear nosi sala. Nodi raan neꞌe, Naꞌi Maromak namate menon foun no emi. ");
INSERT INTO tet_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mais nebee emi hatene, nahuu nosi oras neꞌe, Haꞌu la kemu tenik anggor ween ona, toꞌo Haꞌukaan Ama nabesi aan kaer ukun iha laleꞌan tiꞌan, foin Haꞌu kemu tenik ko emi.” ");
INSERT INTO tet_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yesus dale notu nunia, sia nananu kananuk ida nodi tonun Naꞌi Maromak. Baa kalan nia moos, sia laꞌo kedan baa Foho Saitun. ");
INSERT INTO tet_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Baa oras sia laꞌo nia, Yesus katak baa Niakaan maktuir sia naꞌak, “Ohin kalan neꞌe, emi hotu-hotu atu halai hela Haꞌu. Hori uluk Maromak makoꞌan nakerek nela kedan nosi lia neꞌe naꞌak, ‘Haꞌu atu koꞌo makbalin. Hotu niakaan bibi malae sia nalai keen karin.’ ");
INSERT INTO tet_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nanis Haꞌu kmate. Mais, kalo Haꞌu kmoris kikar tiꞌan, Haꞌu atu kbaa uluk kein emi iha rai Galilea nebaa.” ");
INSERT INTO tet_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Rona nola nunia, Petrus sakar naꞌak, “La bele nunia Ama! Masik ema seluk sia hotu-hotu nalai nela Ama moos, haꞌu la klaꞌo kela Ama!” ");
INSERT INTO tet_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus nataa naꞌak, “Nunia ka? Rona mai Petrus. Haꞌukaan dalen neꞌe, tebes no loos! Ohin kalan neꞌe, manu sei la kokoreek dauk, o meli Haꞌu isin tolu tiꞌan maꞌak, o la matene Haꞌu!” ");
INSERT INTO tet_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mais Petrus sakar tenik naꞌak, “Lale Ama! Kalo Ama mate, haꞌu moos mate tuir. Haꞌu la kalai kela Ama!” Petrus niakaan mamaluk sia ida-idak moos naꞌak nunia. ");
INSERT INTO tet_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hotu Yesus sia laꞌo iha Foho Saitun, toꞌo toꞌos ida naran ‘Getsemani’. Iha nia Yesus katak baa Niakaan maktuir sia naꞌak, “Tuur heik iha neꞌe lai, tan Haꞌu atu kbaa kamulak iha nebaa.” ");
INSERT INTO tet_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mais Nia bolu nola Petrus, Yakobus no Yohanis, nebee sia baa bele-bele no Nia. Nahuu baa oras nia, Nia noran susar basuk no neon la metin. ");
INSERT INTO tet_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hotu Nia katak baa sia naꞌak, “Haꞌukaan neon susar basuk! Koran nuꞌu atu kmate dei. Emi tuur daka ho Haꞌu iha neꞌe lai.” ");
INSERT INTO tet_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hotu Nia laꞌo soruk oan ida tenik. Nia nakniꞌa sudur baa rai nodi namulak naꞌak, “Ama! Kalo Ama nakara, Haꞌu lalika katiu kola susar neꞌe. Mais keta tuir Haꞌukaan hakaran, tuir Ama hakaran dei.” ");
INSERT INTO tet_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Namulak notu, Yesus fila baa Niakaan maktuir naꞌin tolu nia. Mais sia toba dukur. Nia nafanun sia nodi dale baa Petrus naꞌak, “Hoi Petrus! Nansaa emi toba? Haꞌu iha nebaa la oras dei, mais emi la bele hadeer tuur daka oan ida no! ");
INSERT INTO tet_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kose haroma emikaan matan lai, hotu daka ho Haꞌu! Emikaan neon nanis nakara nalo diꞌak, mais emikaan isin la biit. Diꞌak liu emi hamulak, nebee kalo kona sokur, emi bele terus.” ");
INSERT INTO tet_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hotu Nia baa namulak tenik naꞌak, “Ama! Kalo Haꞌu kmusti katiu kola susar neꞌe, nebee tuir Ama hakaran dei.” ");
INSERT INTO tet_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Namulak notu, Nia fila nikar baa Niakaan maktuir naꞌin tolu nia. Mais sia toba nikar tiꞌan, tan matan nakati todan. ");
INSERT INTO tet_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hotu Nia laꞌo nela sia, baa namulak isin ida tenik. Nia nakroꞌan nikar baa Aman, nebee keta nabusik lerek Nia natiu susar nia, mais nebee tuir Aman hakaran dei. ");
INSERT INTO tet_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Namulak notu, Nia fila nikar baa nafanun Niakaan maktuir sia naꞌak, “Emi sei toba ka? Haree lai! Niakaan oras toꞌo ona. Ema mak atu faꞌan Ema Raiklaran Isin mai tiꞌan. Ema mai kohi Haꞌu atu latan Haꞌu baa ema aat liman. ");
INSERT INTO tet_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hadeer ona! Loke matan, mana kokon baa nebaa lai! Ema mak faꞌan Haꞌu mai tiꞌan. Mai ita baa hasoru nia ona!” ");
INSERT INTO tet_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus sei dale nunia, Niakaan maktuir ida naran Yudas mai no ema waꞌin. Sia mai nodi surik no ai kaliduk atu kohi Yesus. Sia tuir ukun nosi ema boot sia, mak naꞌilulik ulun sia no fukun adat sia. ");
INSERT INTO tet_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uluk Yudas foo kedan tadak baa sia naꞌak, “Haree diꞌa-diꞌak! Ema mak haꞌu kdeꞌi, kohi hola Nia ona! Tan Nia mak emi buka!” ");
INSERT INTO tet_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Toꞌo Yesus baa, Yudas liu kedan baa Niakaan oin nodi naꞌak, “Tabe, Ama Boot!” Hotu Yudas nakoꞌak nodi deꞌi Nia. ");
INSERT INTO tet_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus nusu nia naꞌak, “Yudas! O mai neꞌe atu malo saa?” Hotu ema lear nia kabuun baa, kohi nola Yesus. ");
INSERT INTO tet_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mais la natene falik, Yesus eman ida losu nola taha, taa kotu ema ida tilun sorin. (Ema kanek nia, naꞌilulik ulun boot atan.) ");
INSERT INTO tet_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naree nunia, Yesus katak baa ema mak taa nia naꞌak, “Maknua mikar okaan taha, tan ema mak nakaat nodi taha, nia moos atu mate kona taha. ");
INSERT INTO tet_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","O la matene ka? Haꞌu kbele kusu Haꞌukaan Ama nebee solok Niakaan makbukar maliun-maliun mai nosi laleꞌan atu tulun Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mais lalika. Habusik baa, nebee ema neꞌe sia kohi nola Haꞌu. Tan lia neꞌe sia hotu-hotu natoꞌo saa mak hakerek kedan hori uluk iha Hakerek Moon.” ");
INSERT INTO tet_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hotu Yesus dale baa ema lear nia sia naꞌak, “Hoi! Nansaa mai kohi Haꞌu hodi surik no ai kaliduk? Haꞌu neꞌe, ema aat ka? Sura loron Haꞌu kanorin ema iha Uma Hamulak Huun, mais emi la mai kohi Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mais soꞌin baa dei! Kohi hola Haꞌu ona! Tan lia neꞌe natoꞌo saa mak Maromak makoꞌan sia nakerek kedan hori uluk iha Hakerek Moon.” Titu-naree ema lear kohi Yesus nunia, Niakaan maktuir sia nataꞌuk tebes toꞌo niꞌit aan nalai nela Nia. ");
INSERT INTO tet_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Baa oras nia, naꞌilulik ulun sia, manorik ukun sia, no fukun Yahudi sia naklibur tiꞌan iha naꞌilulik ulun boot Kayafas uman. Ema mak kohi Yesus ohin nia, sia nodi Nia baa Kayafas uman. ");
INSERT INTO tet_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus moos tuir no-nook nosi kotuk. Toꞌo uma nia baa, Petrus moos tama baa lalawar, hotu tuur bele-bele no ema iha nia. Nia buka natene saa mak atu dadi baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Iha uma nia laran, ema boot sia buka lia kakaer atu nodi nasalak Yesus, tan nakara taa ukun mate baa Nia. ");
INSERT INTO tet_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Masik sia natama ema mataa lia tolek waꞌin moos, sia la netan lia kakaer ida kedan. Mais ikus basuk, foin netan ema naꞌin rua ");
INSERT INTO tet_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","mak nataa naꞌak, “Ami rona Ema neꞌe dale naꞌak, ‘Haꞌu atu karoꞌon Uma Hamulak Huun. Mais toꞌo wainrua, Haꞌu kariik kikar.’ ” ");
INSERT INTO tet_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hotu Kayafas nariik iha oin nodi nusu baa Yesus naꞌak, “Ema waꞌin tula sala baa O. Tan saa O no-nook dei?” ");
INSERT INTO tet_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mais Yesus la nataa kois. Hotu naꞌilulik nia nusu tenik naꞌak, “Haꞌu atu kusu neꞌe, mais O musti mataa tebe-tebes hanesan O mataa baa Naꞌi Maromak mak moris iha laleꞌan. Ema balu naꞌak, O neꞌe Kristus, Naꞌi Maromak Oan. Lia nia tebes ka lale?” ");
INSERT INTO tet_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus nataa naꞌak, “Ama dale nia tebes. Nosi ikus, emi atu haree Haꞌu, mak Ema Raiklaran Isin, tuur iha laleꞌan iha Naꞌi Maromak sorin kwana. Haꞌu atu kaer ukun kamutuk ko Nia mak beran kaliuk nia. Emi moos haree Haꞌu kmai kikar, ktuun kodi kaloꞌan.” ");
INSERT INTO tet_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Rona nola Yesus nataa nunia, naꞌilulik nia nawan saꞌe tebe-tebes, toꞌo lees nasira niakaan faru klobor. Hotu nia katak baa ema hotu-hotu iha nia naꞌak, “Ita lalika buka ema mataa lia tenik! Emi rona duꞌuk Nia foti aan nuꞌu Naꞌi Maromak Oan. Nia dale nahaat Naꞌi Maromak tiꞌan! Tuir itakaan ukun, kalo ema nalo aan nuꞌu Naꞌi Maromak, ema nia musti mate! ");
INSERT INTO tet_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dadi, ita atu hakotu nunabee?” Sia hotu-hotu nahii naꞌak, “Ema neꞌe, sala tebes! Musti taa ukun mate baa Nia!” ");
INSERT INTO tet_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hotu ema naꞌin hira soruk baa soe kaban baa Yesus. Sia moos basa nakdiuk Nia ");
INSERT INTO tet_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nodi naleuk naꞌak, “Hoi! Kalo O neꞌe Kristus tebes, O maꞌak kokon see mak tuku O neꞌe?” ");
INSERT INTO tet_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Baa oras nia, Petrus sei tuur iha lalawar. Hotu ata feto ida mai dale no nia naꞌak, “Ohin nia, o moos bele-bele mo Yesus, ema Nasaret nia ka?” ");
INSERT INTO tet_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mais Petrus neli iha ema waꞌin nia oin naꞌak, “Lale! Nansaa o musu nunia? Haꞌu la katene ema nia.” ");
INSERT INTO tet_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hotu Petrus sai baa nariik iha odamatan nanokar oin. Feto ida seluk naree nia, hotu katak baa ema sia iha nia naꞌak, “Ohin nia, ema neꞌe moos bele-bele no Yesus, ema Nasaret nia.” ");
INSERT INTO tet_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mais Petrus sakar naꞌak, “O bula arumak! Haꞌu ktuku fatuk la katene ema nia!” ");
INSERT INTO tet_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","La kleur tenik, ema seluk dale baa Petrus naꞌak, “Hoi! Keta maktolek tenik maꞌak o la matene ema nia! Tan okaan lia klalain, manesak no ema Galilea sia!” ");
INSERT INTO tet_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mais Petrus sakar nodi nabasuk lian tenik naꞌak, “Hoi! Haꞌu ktuku fatuk la katene ema nia!” Baa oras nia moos, manu kokoreek. ");
INSERT INTO tet_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Rona nola manu kokoreek, Petrus moos nanoin nola Yesus Niakaan lia fuan ohin nia mak naꞌak, “Manu sei la kokoreek dauk, o meli Haꞌu isin tolu tiꞌan, maꞌak o la matene Haꞌu.” Nanoin nola nunia, Petrus sai nikar baa luan nodi tanis nanseꞌur aan. ");
INSERT INTO tet_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Seisawan oan, ema hotu-hotu mak iha moon-metan Yahudi nia, kabuar lia atu noꞌo Yesus. ");
INSERT INTO tet_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hotu sia kesi Nia nodi baa gubernur Pilatus, tan sia nakara nebee gubernur taa ukun mate baa Nia. ");
INSERT INTO tet_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Baa oras Yudas natene naꞌak naꞌilulik ulun sia no fukun adat sia nakotu atu noꞌo Yesus, nia neon monu baa niakaan salan, tan nia mak faꞌan lakon Yesus baa sia. Hotu Yudas baa nasoru sia atu foo nikar siakaan osan murak tomak tolu nulu nia. ");
INSERT INTO tet_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nia katak naꞌak, “Haꞌu kalo sala tiꞌan, tan haꞌu klatan baa emi ema mak la noo sala sa-saa.” Mais sia nataa naꞌak, “Hoi! Ami la hatene o ona! O musti matiu duꞌuk sala nia.” ");
INSERT INTO tet_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hotu Yudas soe lerek osan nia iha Uma Hamulak Huun laran. Hotu nia sai, baa nisa aan toꞌo mate. ");
INSERT INTO tet_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Rona nola lia nia, naꞌilulik sia libur nola osan nia hotu dale naꞌak, “Ita la bele hatama hikar osan neꞌe baa osan sera fatin, tan osan neꞌe kadoor tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ita rona badaen sasanan ida atu faꞌan niakaan rai. Diꞌak liu ita hodi osan neꞌe baa sosa hola rai nia. Hodi nunia, ita bele halo rai nia dadi rate fatin bodik ema matak sia, kalo sia mate iha Yerusalem neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hotu sia nodi osan nia, baa sosa nola rai nia. Toꞌo baa oras neꞌe, ema sei temi rai nia naꞌak, ‘Rai Raa’. ");
INSERT INTO tet_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lia neꞌe natoꞌo saa mak Maromak makoꞌan Yeremia nakerek kedan hori uluk naꞌak, “Hori uluk aan ema Israꞌel sia nodi osan murak tomak tolu nulu atu sosa nola ata ida. Tan lia nia, sia nola osan murak tomak tolu nulu atu sosa nola rai rohan ida. ");
INSERT INTO tet_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rai nia, sia sosa nola nosi badaen sasanan, tuir saa mak Naꞌi Maromak naruka tiꞌan baa haꞌu.” ");
INSERT INTO tet_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ema nodi Yesus toꞌo gubernur baa tiꞌan, gubernur nusu Yesus naꞌak, ‘ ‘Ema neꞌe sia naꞌak O neꞌe, Naꞌin Yahudi. Tebes ka lale?” Yesus nataa naꞌak, “Tebes. Ama dale nia loos.” ");
INSERT INTO tet_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hotu naꞌilulik ulun sia no fukun adat sia tula lia waꞌin baa Yesus, mais la nataa kedan. ");
INSERT INTO tet_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hotu gubernur nusu nikar naꞌak, “O la rona sia dale nia ka? Sia tula sala waꞌin baa O tiꞌan. Tan saa O la mataa?!” ");
INSERT INTO tet_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mais Nia la nataa kedan, toꞌo gubernur moos benar. ");
INSERT INTO tet_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sura tinan, natoon baa ema Yahudi nadahur Paska, gubernur nabusik ema bui ida tuir ema lear boi. ");
INSERT INTO tet_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Baa oras nia, noo ema bui ida naran Barabas. Ema hotu-hotu natene nia, tan nia ema aat basuk. ");
INSERT INTO tet_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Baa loron nia, ema lear moos baa gubernur Pilatus atu nusu nebee nia nabusik sai ema bui ida, tuir siakaan adat. Rona nunia, Pilatus nusu baa sia naꞌak, “Diꞌak! Mais haꞌu atu kabusik see? Iha neꞌe, Barabas no Yesus mak ema temi naꞌak Kristus. Haꞌu kabusik mak nabee? Emi naꞌin boi duꞌuk.” ");
INSERT INTO tet_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Gubernur dale nunia, tan nia natene tiꞌan naꞌilulik ulun sia nodi Yesus baa nia, tan sia rai hirus baa Yesus.) ");
INSERT INTO tet_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Oras gubernur sei tuur leno lia nia, niakaan feen solok lia baa nia naꞌak, “Ama sintidu! Keta taa ukun baa Yesus nia, tan Nia ema moon. Hori fonin aan haꞌu kmeꞌi la diꞌak. Toꞌo oras neꞌe moos, haꞌu ksei koran la diꞌak.” ");
INSERT INTO tet_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mais naꞌilulik ulun sia no fukun adat sia sasuku bei-beik ema lear nia, nebee sia nusu gubernur nabusik Barabas no taa ukun mate baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tan baa nia, gubernur nusu tenik baa sia naꞌak, “Nosi ema naꞌin rua neꞌe, haꞌu kabusik ida nabee?” Sia moos nataa bele-bele naꞌak, “Barabas! Mabusik Barabas dei!” ");
INSERT INTO tet_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hotu gubernur nusu tenik naꞌak, “Kalo nunia, haꞌu kalo nunabee baa Yesus neꞌe, mak ema temi Kristus?” Sia hotu-hotu moos nahii bele-bele naꞌak, “Hoꞌo Nia dei! Hedi Nia baa ai karuus!” ");
INSERT INTO tet_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hotu gubernur nusu tenik naꞌak, “Mais Nia sala saa? Haꞌu kleno Nia tiꞌan, mais la ketan sala kois!” Masik nunia moos, sia hotu-hotu nahii makaꞌas liu tenik naꞌak, “Hoꞌo Nia! Hedi Nia baa ai karuus ona!” ");
INSERT INTO tet_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","La kleur falik, gubernur natene naꞌak nia la bele nalo saa tenik, tan ema lear nia atu krakat toꞌo nakfetik. Tan lia nia, nia nola wee nodi fasi liman iha siakaan oin. Nia moos katak baa sia naꞌak, “Haꞌu la katiu ema neꞌe niakaan mate! Emi hotu-hotu mak hatiu!” ");
INSERT INTO tet_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ema lear nia moos nahii nodi nataa naꞌak, “Soꞌin baa! Habusik ami ho amikaan bein oan sia mak hatiu hola Niakaan raan!” ");
INSERT INTO tet_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Rona nola nunia, gubernur dale naꞌak, “Loos emi dei.” Hotu nia nabusik Barabas tuir siakaan hakaran. Mais nia naruka ema noꞌat Yesus nodi oe besi tarak. Noꞌat notu, nia latan Yesus baa sondadu sia, nebee sia nodi baa atu nedi noꞌo baa ai karuus. ");
INSERT INTO tet_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nunia hotu, sondadu sia dada nodi Yesus baa siakaan fatin iha gubernur tofatik. Hotu sia bolu nola mai siakaan mamaluk sia hotu. ");
INSERT INTO tet_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sia kolu Yesus Niakaan tais no natais nikar Nia nodi faru klobor ida. Faru nia ilas mean asuaten, hanesan naꞌin sia natais. ");
INSERT INTO tet_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Hotu sia nola ai tarak lain, noman nalo baa sabeo tarak. Hotu sia tau sabeo nia baa Yesus ulun nodi naleuk nakdiuk Nia, hanesan sia foti naꞌi foun nodi sabeo naꞌin. Sia moos nakaer ai knoꞌan ida baa Yesus liman kwana, hanesan knoꞌan ukun. Sia nakniꞌa seꞌi oin baa Nia, nodi naleuk naꞌak, “Tabe, Naꞌin Yahudi.” ");
INSERT INTO tet_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sia moos soe kaban baa Nia. Sia nola knoꞌan nia nosi Yesus liman, nodi taꞌe nakdiuk Niakaan ulun. ");
INSERT INTO tet_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Naleuk nakdiuk Nia notu, sia kolu faru klobor nia, hotu natais nikar Niakaan tais baa. Hotu sia nodi Nia sai baa kota Yerusalem luan atu nedi noꞌo Nia baa ai karuus. ");
INSERT INTO tet_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Oras sia dada nodi Yesus baa, sia nasoru nola ema naꞌin ida iha dalan klaran. Ema nia naran Simon. Nia nosi kota Kirene. Hotu sondadu sia seten nia natiu Yesus Niakaan ai karuus. ");
INSERT INTO tet_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hotu sia laꞌo toꞌo fatin ida naran Golgota. (Naran neꞌe naꞌak, “fatin ulun ruin”.) ");
INSERT INTO tet_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iha nia, sia atu naroo Yesus nodi anggor ween kahur ai moruk, nebee Nia bele terus moras. Yesus norut oan ida, hotu dudu fila. ");
INSERT INTO tet_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hotu sia nedi Nia baa ai karuus, hotu taman ai karuus nia. Hotu sondadu sia suut liman atu nodi natene see mak netan Yesus farun. ");
INSERT INTO tet_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hotu sia tuur daka iha nia. ");
INSERT INTO tet_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sia moos nakerek baa ai kabelak ida naꞌak, “NEꞌE YESUS, NAꞌI YAHUDI” Hotu sia nedi kedan ai kabelak nia baa ai karuus iha Yesus ulun leten, nebee ema bele natene lia krarain taa ukun mate baa Nia. ");
INSERT INTO tet_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Iha nia moos, sia nedi noꞌo ema madauk teen naꞌin rua. Ida iha Yesus sorin kwana, ida tenik iha sorin karuk. ");
INSERT INTO tet_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ema hotu-hotu mak laꞌo tuir nia, titu-naree Yesus. Sia nakmulis ibun nodi naleuk Nia. ");
INSERT INTO tet_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Sia nahii baa Nia naꞌak, “Hoi! O maꞌak O bele maroꞌon Uma Hamulak Huun, toꞌo baa wainrua mariik mikar tiꞌan. Tebes ka? Kalo O tebe-tebes Naꞌi Maromak Oan, sori aan tuun mosi ai nia ona.” ");
INSERT INTO tet_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nunia moos, naꞌilulik ulun sia, manorik ukun sia, no fukun adat sia naleuk Nia naꞌak, ");
INSERT INTO tet_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nia bele sori ema seluk, mais la bele sori aan duꞌuk. Uluk Nia katak naꞌak, Nia ema Israꞌel siakaan naꞌin! Kalo nunia, diꞌak liu Nia tuun nosi ai nia lai, foin ita fiar Nia. ");
INSERT INTO tet_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kalo Nia tebe-tebes Naꞌi Maromak Oan, habusik nebee ‘Nia naloon baa Naꞌi Maromak. Kalo Naꞌi Maromak beer Nia, habusik Naꞌi Maromak mak sori Nia.’ ” ");
INSERT INTO tet_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ema madauk naꞌin rua nia moos tuir naleuk Nia nunia. ");
INSERT INTO tet_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nunia hotu, nakukun luri taka nola rai nia nosi loro natetu toꞌo tuku tolu loro malirin. ");
INSERT INTO tet_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kreꞌis tuku tolu loro malirin, Yesus nahii nodi siakaan lia Aram naꞌak, “Eli! Eli! Lema sabaktani?” (Lia isin naꞌak, “Haꞌukaan Maromak! Haꞌukaan Maromak! Tan saa Ama taliꞌur laꞌo mela Haꞌu nuneꞌe?”) ");
INSERT INTO tet_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ema naꞌin hira mak kreꞌis ai karuus nia rona nola Yesus lian maliak nia. Sia moos dale naꞌak, “Hoi! Rona lai. Nia bolu Elia, mak Maromak makoꞌan uluk nia!” ");
INSERT INTO tet_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hotu ema ida nalai kedan baa nola wee teen, loban tama baa tua siin. Nia tuu wee teen nia nodi ai knoꞌan rohan, hotu lolo soruk baa Yesus ibun, nebee Nia norut. ");
INSERT INTO tet_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mais ema seluk tenik dale naꞌak, “Hein lai! Ita haree kokon! Elia atu mai sori Nia ka lale?” ");
INSERT INTO tet_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hotu Yesus nahii tenik nodi lian makaꞌas. Hotu nawan kotu. ");
INSERT INTO tet_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iha Uma Hamulak Huun noo tais odamatan boot ida mak neli Naꞌi Maromak Keꞌan Lulik Kaliuk. Natoon baa Yesus nawan kotu, tais odamatan nia naksira faꞌe baa rua, nosi leten toꞌo raik. Baa oras nia moos, rai kakekuk toꞌo fatuk boot nakfera. ");
INSERT INTO tet_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rate sia moos nakloke. Naꞌi Maromak eman sia mak mate tiꞌan, Nia nalo balu moris nikar. ");
INSERT INTO tet_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Baa oras Yesus moris nikar tiꞌan, sia sai mai nosi siakaan rate tama baa Yerusalem. Ema lear moos naree nodi matan duꞌuk. ");
INSERT INTO tet_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Iha Golgota, sondadu ulun no niakaan ain-liman sia daka Yesus Niakaan ai karuus. Baa oras sia naree rai kakekuk no lia hotu-hotu mak dadi nia, sia nataꞌuk basuk. Sia dale naꞌak, “Adeei! Ema neꞌe, Naꞌi Maromak Oan tebes!” ");
INSERT INTO tet_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Feto naꞌin hira moos titu Yesus mate nosi dook. Sia tuir Nia tiꞌan nosi Galilea, tan uluk sia mak naliku Yesus no Niakaan ema sia. ");
INSERT INTO tet_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iha feto nia sia, noo Maria nosi leo Magdala, Maria ida tenik (mak Yakobus no Yusuf inan), no Sebadeus feen (mak Yakobus no Yohanis inan). ");
INSERT INTO tet_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yesus mate nia, kona baa loron lima. Awan, kona baa ema Yahudi siakaan loron hamulak, mak loron hanawa serwisu. Iha nia noo ema ida naran Yusuf. Nia ema maksoin nosi leo Arimatea. Nia moos tuir Yesus hanorin kleur tiꞌan. Baa oras loro atu monu baa loron lima nia, Yusuf buka dalan atu natuun kedan Yesus maten nosi ai karuus, tan loron hanawa serwisu atu toꞌo ona. ");
INSERT INTO tet_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tan baa nia, loro sei la monu dauk, Yusuf baa Gubernur Pilatus atu nusu Yesus maten. Gubernur moos nakara, hotu latan maten nia baa Yusuf. ");
INSERT INTO tet_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hotu Yusuf baa Golgota, natuun nola Yesus maten nosi ai karuus. Nia falun diꞌa-diꞌak nodi tais foun mak folin todan. ");
INSERT INTO tet_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Baa oras nia, ema foin baꞌat notu fatuk kuak atu nadiꞌa kedan rate bodik Yusuf no familin sia. Hotu Yusuf no niakaan ema sia natama Yesus maten baa kuak nia. Hotu sia dudu nola fatuk belar boot ida nodi taka kuak nia. Hotu Yusuf sia fila nikar. ");
INSERT INTO tet_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Baa oras nia, Maria nosi Magdala no Maria ida seluk nia moos tuir toꞌo nebaa. Sia tuur nodi mana baa kuak nia. ");
INSERT INTO tet_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Awan, kona baa ema Yahudi siakaan loron hamulak, naꞌilulik ulun sia no ema Farisi sia baa nasoru gubernur. ");
INSERT INTO tet_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Toꞌo baa, sia katak naꞌak, “Ama Gubernur, ami hanoin hori hirak nia, baa oras ema tolek teen nia sei moris, nia katak naꞌak nuneꞌe, ‘Haꞌu nanis mate, mais baa wainrua, Haꞌu kmoris kikar.’ ");
INSERT INTO tet_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tan baa nia, Ama tulun maruka daka diꞌa-diꞌak rate nia, toꞌo wainrua. Hodi nunia, Niakaan maktuir sia la bele nanaꞌo nola Niakaan maten, hotu tolek ema naꞌak Nia moris nikar tiꞌan. Tan kalo sia tolek nunia, hahalok nia aat liu tan siakaan hahalok uluk nia baa oras sia dale naꞌak, Nia mak Kristus.” ");
INSERT INTO tet_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Rona nola nunia, gubernur nataa naꞌak, “Diꞌak! Hodi makdaka rai baa daka diꞌa-diꞌak fatin nia.” ");
INSERT INTO tet_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hotu sia baa fatin nia nodi makdaka rai. Toꞌo nebaa, sia nanit mate rate nia odamatan. Hotu naruka makdaka rai sia daka bei-beik, nebee ema keta mai nanaꞌo nola maten nia. ");
INSERT INTO tet_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ema Yahudi siakaan loron hamulak siku tiꞌan, awan kona baa loron domiku. Baa loron domiku seisawan oan, Maria nosi Magdala no Maria seluk nia, baa naree Yesus raten. ");
INSERT INTO tet_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Teki-tekis, rai kakekuk boot. Maromak Niakaan makbukar laleꞌan ida tuun mai, baa dudu sees fatuk boot mak taka kuak nia. Hotu makbukar nia tuur baa fatuk nia leten. ");
INSERT INTO tet_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Niakaan oin naksinak hanesan mameran, no niakaan tais mutin moos. ");
INSERT INTO tet_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Naree nunia, makdaka rai sia nataꞌuk basuk toꞌo kiki lirin. Sia la bele kakoen aan, ahan ema maten. ");
INSERT INTO tet_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hotu makbukar laleꞌan nia katak baa feto nia sia naꞌak, “Lalika hataꞌuk! Haꞌu katene emi mai buka Yesus, Ema mak sia nedi noꞌo baa ai karuus nia. ");
INSERT INTO tet_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mais Nia la iha neꞌe ona. Nia moris nikar tiꞌan, tuir saa mak Nia dale kedan tiꞌan. Mai tama baa haree duꞌuk maten fatin nia. Mamuk tiꞌan! ");
INSERT INTO tet_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Rona! Fila lai-lais baa katak baa Yesus Niakaan maktuir sia haꞌak, Nia moris nikar tiꞌan. Nia uluk baa Galilea tiꞌan. Sia musti baa nasoru Nia iha nebaa, hanesan Nia nameno kedan tiꞌan baa sia. Haꞌukaan dalen neꞌe, tebes.” ");
INSERT INTO tet_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Rona nola nunia, feto nia sia nalai sai laꞌo nela fatin nia. Sia noran nataꞌuk, mais sia moos noran diꞌak. Sia fila lai-lais atu katak lia nia hotu-hotu baa Yesus Niakaan maktuir sia. ");
INSERT INTO tet_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mais toꞌo dalan klaran, sarebak Yesus nasoru sia nodi dale naꞌak, “Saloom!” Naree nunia, sia moos nareꞌis aan, baa nakoꞌak Niakaan ain nodi loꞌu-sudur baa Nia. ");
INSERT INTO tet_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nia moos dale naꞌak, “Keta hataꞌuk! Baa katak Haꞌukaan maktuir sia, nebee sia baa nein Haꞌu iha Galilea.” ");
INSERT INTO tet_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Baa oras feto nia sia sei iha dalan klaran, makdaka rai sia moos fila baa kota. Sia baa nasara lia hotu-hotu mak dadi tiꞌan nia baa naꞌilulik ulun sia. ");
INSERT INTO tet_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Rona nola nunia, naꞌilulik ulun nia sia koꞌa lia fuan no fukun adat sia atu selu osan waꞌin nodi taka makdaka rai ibun. ");
INSERT INTO tet_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Sia katak baa makdaka rai sia naꞌak, “Hoi! Kalo ema nusu emi, emi hataa nuneꞌe: Kalan boot ami toba dukur. La hatene falik, Niakaan maktuir sia mai nanaꞌo nola Niakaan maten. ");
INSERT INTO tet_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kalo Ama Gubernur rona nola lia nia, emi lalika hataꞌuk, tan ami mak atu hahulin ama boot nia.” ");
INSERT INTO tet_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hotu makdaka rai sia simu nola osan nia, no nalo tuir siakaan hakaran. Etuk, toꞌo baa oras neꞌe moos, ema Yahudi sia sei fiar lia tolek nia. ");
INSERT INTO tet_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nunia hotu, Yesus Niakaan maktuir naꞌin sanulu resin ida baa Galilea atu nasoru Nia iha foho ida, tuir Niakaan mamenon uluk nia. ");
INSERT INTO tet_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Baa oras sia naree Nia iha nebaa, sia loꞌu-sudur baa Nia. Masik nunia moos, balu sei neon ruak. ");
INSERT INTO tet_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hotu Yesus mai nareꞌis aan baa sia, nodi dale naꞌak, “Naꞌi Maromak latan beran baa Haꞌu tiꞌan, nebee Haꞌu ukun hotu-hotu iha laleꞌan no raiklaran. ");
INSERT INTO tet_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tan lia nia, emi musti baa raiklaran tomak, katak Haꞌukaan Manfatin Diꞌak baa ema nosi rai hotu-hotu. Hatudu dalan nebee sia dadi baa Haꞌukaan ema. Sarani sia nebee foo tadak naꞌak sia talin malu tiꞌan no Ama, no Niakaan Oan, no Niakaan Kmalar Lulik. ");
INSERT INTO tet_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hotu hanorin nebee sia nalo tuir ukun hotu-hotu mak Haꞌu katak tiꞌan baa emi. Hanoin diꞌa-diꞌak! Haꞌu kafati ko emi toꞌo rai falu fila.” ");
INSERT INTO tet_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Manfatin neꞌe, Lia Diꞌak nosi Naꞌi Maromak Oan, naran Yesus. Yesus neꞌe, Kristus mak Naꞌi Maromak nameno kedan hori uluk. Yesus Niakaan lia nahuu nodi lia Yohanis nuneꞌe: ");
INSERT INTO tet_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Baa oras Yesus sei la nahuu dauk Niakaan serwisu, Naꞌi Maromak solok kedan ema ida naran Yohanis atu nasori dalan bodik Yesus atu mai. Uluk, Maromak naruka makoꞌan ida naran Yesaya, nebee nia nakerek nela kedan nosi lia nia naꞌak, “Rona mai! Haꞌu atu ksolok Haꞌukaan ema ida, nebee nia nasori dalan bodik O. ");
INSERT INTO tet_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ema nia atu baa rai fuik ida, nodi nahii naꞌak, ‘Ema hotu-hotu hadiꞌa dalan bodik Naꞌin atu mai! Ema hotu-hotu haweer dalan atu simu Nia.’ ” ");
INSERT INTO tet_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Yohanis neꞌe, mak sarani ema. Nia tuur iha rai fuik. Niakaan tais halo hosi kuda unta rahun. Niakaan bolas halo hosi kulit. Niakaan haan, kalaꞌek no wani ween alas laran. Niakaan moris lalaꞌok neꞌe, hanesan Maromak makoꞌan ida hori uluk, naran Elia. Baa oras Yohanis baa rai fuik nia, ema waꞌin nosi kota Yerusalem no rai Yudea tomak, mai nasoru Nia iha nebaa. Yohanis katak baa sia naꞌak, “Emi musti katak hasai emikaan salan, hotu laꞌo hela sala nia sia, nebee Naꞌi Maromak foo pardua baa emi. Hotu, emi musti simu sarani, hanesan marak ida naꞌak, emi diꞌa-diꞌak tiꞌan ho Naꞌi Maromak.” Rona nola nunia, ema nia sia katak nasai kedan siakaan salan. Hotu, Yohanis sarani sia iha mota Yordan. ");
INSERT INTO tet_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nia moos katak baa sia naꞌak, “Ema ida mak boot liu haꞌu, atu mai. Dadi baa Niakaan ata moos, haꞌu la kfatan. ");
INSERT INTO tet_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Haꞌu ksarani emi kodi wee dei. Mais Nia nalo liu tan haꞌu. Tan Nia atu nakonu nola emikaan neon no laran, nodi Maromak Kmalar Lulik.” ");
INSERT INTO tet_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Baa oras nia, Yesus mai nosi leo ida naran Nasaret iha rai Galilea, atu nasoru Yohanis. Nasoru tiꞌan, Yohanis sarani Yesus iha mota Yordan. ");
INSERT INTO tet_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Baa oras Yesus sai nosi wee laran, teki-tekis naree laleꞌan nakloke. Hotu, Maromak Kmalar tuun baa Nia, hanesan manu lakateu sina ida. ");
INSERT INTO tet_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hotu, ema rona Naꞌi Maromak lian nosi laleꞌan naꞌak: “Oa! O neꞌe, Haꞌukaan Oan mak kakara no kadomi. O malo Haꞌu neon diꞌak.” ");
INSERT INTO tet_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hotu, Maromak Kmalar dada nodi Yesus baa rai fuik ida. ");
INSERT INTO tet_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nia tuur nein iha fatik nia namutuk no osa no lotuk alas laran sia, toꞌo loron haat nulu, kalan haat nulu. Iha nia, diabu ulun moos mai sokur Yesus, nebee atu tuir nia. Mais, la bele. Hotu, Naꞌi Maromak Niakaan makbukar laleꞌan sia mai naliku Yesus. ");
INSERT INTO tet_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Baa oras nia, ema natama Yohanis baa bui laran. Yesus moos baa rai Galilea, atu nalore Naꞌi Maromak Manfatin Diꞌak iha nebaa. ");
INSERT INTO tet_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nia katak baa ema naꞌak, “Rona! Oras neꞌe, Naꞌi Maromak Niakaan oras toꞌo tiꞌan. Oras neꞌe, Naꞌi Maromak nabesi aan kaer ukun iha raiklaran. Emi musti hanawa hosi hahalok aat ona! Hotu mai tuir Naꞌi Maromak dalan moris.” ");
INSERT INTO tet_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Loron ida, Yesus laꞌo tuir debu boot Galilea tehen. Nia naree ema maun-alin naꞌin rua. Maun naran Simon, alin naran Andreas. Sia rua noꞌi tiha naꞌan tasi, tan sia buka moris nunia. ");
INSERT INTO tet_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hotu, Yesus bolu sia naꞌak, “Hei! Emi mai tuir Haꞌu ona! Uluk emi buka naꞌan tasi. Mais Haꞌu atu kanorin emi buka ema, nebee sia tuir Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rona nola nunia, sia rua laꞌo nela kedas siakaan daitiha, hotu tuir Yesus. ");
INSERT INTO tet_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sia laꞌo liu baa, Yesus naree tenik ema naꞌin rua. Sia neꞌe, Sebadeus oan. Maun naran Yakobus, alin naran Yohanis. Sia noꞌi nadiꞌa daitiha iha bero laran. ");
INSERT INTO tet_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus bolu sia naꞌak, “Hei! Emi mai tuir Haꞌu ona!” Rona nola nunia, sia laꞌo nela kedas siakaan aman no ema serwisu sia iha bero laran. Hotu sia tuir Yesus. ");
INSERT INTO tet_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hotu, Yesus no ema naꞌin haat nia laꞌo toꞌo leo ida, naran Kapernaum. Ema Yahudi siakaan loron hamulak toꞌo mai, Yesus tama baa nanorin iha siakaan uma hamulak. ");
INSERT INTO tet_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rona Yesus nanorin, ema hotu-hotu blaar, tan Nia seluk nosi manorik ukun Yahudi sia. Nia natene tebe-tebes lia hanorin isin. ");
INSERT INTO tet_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Iha uma hamulak nia laran noo ema ida mak diabu tekar. Baa oras nia, diabu mak tekar ema nia nahii naꞌak, ");
INSERT INTO tet_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Hoi! Yesus, ema Nasaret! O mai malo saa!? O moo lia saa mo ami!? O mai keen karin ami baa saa! Ami hatene O neꞌe, ema moon nia mak Naꞌi Maromak nameno atu solok mai.” ");
INSERT INTO tet_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Rona nola nunia, Yesus teꞌur diabu nia naꞌak, “Taka ibun! Sai mosi ema nia!” ");
INSERT INTO tet_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Diabu nia moos tekar ema nia, toꞌo isin makaꞌas karin. Hotu, diabu kakaur nodi sai nela ema nia. ");
INSERT INTO tet_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Naree nunia, ema hotu-hotu iha uma hamulak nia blaar karin. Sia dale baa malu naꞌak, “See mak neꞌe, toꞌo Nia bele naruka diabu sia sai. Hotu sia sai kedas, tuir Niakaan hakara. Niakaan hanorin neꞌe, oin seluk! Furak tebes!” ");
INSERT INTO tet_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nunia hotu, ema dale lia neꞌe nosi ibun baa ibun, toꞌo keke lema rai Galilea tomak. ");
INSERT INTO tet_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hotu, Yesus no Niakaan maktuir sia sai nosi uma hamulak nia baa Simon no Andreas uman. ");
INSERT INTO tet_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Oras nia, Simon banin feto noꞌi toba, tan moras kiki. Yesus sia tama uma laran, ema mai katak baa sia naꞌak, “Ferik moras.” ");
INSERT INTO tet_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Rona nola nunia, Yesus nareꞌis aan baa ferik nia. Nia kaer baa liman, nodi foti nadeer nia. Moras kiki nia moos lakon kedas. Hotu, ferik nia baa naliku Yesus sia. ");
INSERT INTO tet_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kreꞌis loro atu monu, ema waꞌin nodi siakaan ema moras no ema diabu tekar mai nusu tulun baa Yesus, ");
INSERT INTO tet_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","toꞌo ema leo nia tomak mai nakonu nola uma nia oin. ");
INSERT INTO tet_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hotu, Yesus nadiꞌak nola ema waꞌin nosi moras oi-oik. Nia moos teꞌur sai diabu waꞌin. Mais Nia la foo leet baa diabu sia dale, tan sia natene tebes Nia. ");
INSERT INTO tet_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hotu nunia, Yesus no Niakaan maktuir sia toba iha leo nia, tan kalan tiꞌan. Seisawan oan, Yesus nadeer uluk maktuir sia, hotu sai baa namulak iha fatin mamuk ida. ");
INSERT INTO tet_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Oras Simon sia nadeer, sia la naree Yesus. Hotu, sia baa buka. ");
INSERT INTO tet_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sia nasoru Yesus tiꞌan, sia nasee naꞌak, “Ama, ema buka Ama. Mai ita fila ona.” ");
INSERT INTO tet_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mais Yesus nataa naꞌak, “Diꞌak. Mais diꞌak liu, ita baa leo kreꞌis iha neꞌe sia lai, nebee Haꞌu kalore Naꞌi Maromak Manfatin iha nebaa. Tan Naꞌi Maromak solok Haꞌu kmai, atu kalaꞌok serwisu nia.” ");
INSERT INTO tet_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hotu, Yesus laꞌo lema rai Galilea tomak, nodi nalore Naꞌi Maromak Manfatin iha uma hamulak sia. Nia moos teꞌur nasai diabu waꞌin. ");
INSERT INTO tet_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Baa oras nia, ema ida mak moras funi mea mai baa Yesus. Nia nakniꞌa nodi nakroꞌan naꞌak, “Ama! Tulun haꞌu lai! Haꞌu katene Ama bele nalakon haꞌukaan moras neꞌe, nebee ema keta nakribi haꞌu ona. Surak, Ama nakara.” ");
INSERT INTO tet_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Rona nola nunia, Yesus neon monu. Nia lolo liman nodi kaer ema nia. Hotu, Nia nataa naꞌak, “Tebes! Haꞌu kakara. O diꞌak ona!” ");
INSERT INTO tet_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Laku matan dei, ema nia diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Hotu, Yesus naruka fila, nodi katak naꞌak, ");
INSERT INTO tet_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Rona diꞌa-diꞌak! O diꞌak tiꞌan, mais keta masara baa ema. O musti malaꞌok ukun nosi Bei Musa. Baa malore okaan isin lolon baa naꞌilulik lai, nebee sia leno okaan isin no sia bele natene naꞌak, okaan moras neꞌe lakon tiꞌan. Hotu, o matetu sera baa Naꞌi Maromak, nebee ema hotu-hotu bele natene naꞌak, o diꞌak tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Masik Yesus nakahik nunia moos, ema nia baa keke luku lia nia. Rona nola lia nia, ema lear mai buka Yesus, toꞌo Yesus la bele nasai oin iha leo hotu-hotu. Tan lia nia, Yesus nein iha rai leet dei. Mais ema rai-rain lolok mai buka Nia. ");
INSERT INTO tet_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Siku loron hira tiꞌan, Yesus fila nikar baa leo Kapernaum. Ema naree Nia, hotu sia baa katak lema leo nia naꞌak, “Yesus fila uma tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Rona nola nunia, ema waꞌin lolok mai, toꞌo sesuk malu iha uma nia. Odamatan moos nakonu ema. Hotu, Yesus nalore Naꞌi Maromak Manfatin baa sia. ");
INSERT INTO tet_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Baa oras Yesus sei nanorin, ema naꞌin haat leba nodi ema kmaꞌas ida mai. ");
INSERT INTO tet_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mais sia la bele tama toꞌo Yesus oin, tan ema waꞌin sesuk malu. Tan baa nia, sia saꞌe baa, sobu nakuak uma leten, kona besik baa Yesus oin. Hotu, sia natuun ema kmaꞌas nia nodi biti, baa Yesus oin. ");
INSERT INTO tet_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Naree nunia, Yesus natene naꞌak sia fiar tebe-tebes. Tan lia nia, Nia katak baa ema kmaꞌas nia naꞌak, “Oa! Haꞌu kasu tiꞌan okaan salan sia!” ");
INSERT INTO tet_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Baa oras nia, manorik ukun Yahudi naꞌin hira moos tuur iha nia. Rona Yesus dale nunia, sia hirus ");
INSERT INTO tet_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","nodi namaas baa malu naꞌak, “Nia la bele dale nunia, tan Naꞌi Maromak mesan mak bele kasu ema salan! Nia nalo aan nuꞌu Maromak. Nia nahaat Maromak naran tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mais Yesus natene kedan siakaan neon. Nia katak baa sia naꞌak, “Hoi, maluk sia! Emi keta haneo nunia! ");
INSERT INTO tet_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Haꞌu neꞌe, Ema Raiklaran Isin mak ketan beran kosi Maromak. Haꞌu koo beran atu foo pardua baa ema. Mais hanoin! Kalo Haꞌu kdale baa ema neꞌe kaꞌak, ‘O metan pardua tiꞌan,’ emi la haree Haꞌukaan beran. Mais kalo Haꞌu karuka nia kaꞌak, ‘Madeer ona!’ foin emi bele haree Haꞌukaan beran.” Dale notu nunia, Yesus katak baa ema kmaꞌas nia naꞌak, ");
INSERT INTO tet_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“O rona! Oras neꞌe, o diꞌak tiꞌan! Madeer! Lulun biti, modi fila ona!” ");
INSERT INTO tet_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Rona nola nunia, ema kmaꞌas nia moos nadeer kedas. Hotu, nia foti biti nodi sai. Ema hotu-hotu iha nia blaar karin nodi naꞌak, “Adeei! Ami foin haree hahalok nuneꞌe! Naꞌi Maromak beran boot tebes!” ");
INSERT INTO tet_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hotu, Yesus fila baa debu boot Galilea tehen. Ema waꞌin mai baa Nia, hotu Nia nanorin sia. ");
INSERT INTO tet_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iha fatin nia no ema ida naran Lewi. Lewi aman, naran Alfeus. Lewi nia, maksisi bea bodik ukunrai Roma. Oras Yesus laꞌo tuir nia, Nia naree Lewi. Hotu, Nia bolu naꞌak, “Hei! Mai tuir Haꞌu!” Rona Yesus bolu nunia, Lewi nariik, tuir kedas Yesus. ");
INSERT INTO tet_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Loron ida, Yesus no Niakaan maktuir sia baa naa iha Lewi uman. Sia naa namutuk no Lewi niakaan mamaluk maksisi bea sia no ema seluk sia mak ema Yahudi sura naꞌak, ema lisan aat. Mais sia mak nakara duꞌuk atu rona Yesus hanorin. ");
INSERT INTO tet_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iha nia moos, noo manorik ukun nosi partee Farisi. Sia naree Yesus naa namutuk no ema maksisi bea no ema lisan aat nia sia. Hotu sia nusu baa Yesus Niakaan maktuir sia naꞌak, “Tan saa emikaan ulun tuur naa namutuk no ema maksisi bea no ema lisan aat sia?” ");
INSERT INTO tet_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Rona sia nusu nunia, Yesus katak baa sia naꞌak, “Ema moras buka makdook. Ema isin lolon diꞌak, la buka makdook. Haꞌu kmai atu babilan ema mak aat, lahoos atu babilan ema mak noran aan diꞌak.” ");
INSERT INTO tet_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Baa loron ida, ema Farisi sia nalirin aan. Yohanis Niakaan maktuir sia moos nalo tuir. Mais ema Farisi sia naree Yesus Niakaan maktuir sia la nalirin aan. Hotu, sia mai nusu Yesus naꞌak, “Ama! Ami halirin aan. Yohanis Niakaan maktuir sia moos nalirin aan. Mais tan saa Okaan maktuir sia la nalirin aan?” ");
INSERT INTO tet_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Rona nola nunia, Yesus nataa naꞌak, “Emi hatene tiꞌan, kalo ema nalo dahur uma kain foun, bainaka sia la nalirin aan, mais sia naa toꞌo bosu. Kalo sasudin mane sei iha nia, sia naa bele-bele. ");
INSERT INTO tet_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mais awan-wainrua, kalo ema seluk mai kohi nola sasudin mane nia, niakaan maluk sia noran susar. Foin, sia nalirin aan.” ");
INSERT INTO tet_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hotu, Yesus foo lia hatetek ida naꞌak, “Kalo faru naksira, ita la baban hodi tais foun. Tan kalo fasi, tais foun nia nakruꞌu, toꞌo faru tuan nia naksira tuꞌan. ");
INSERT INTO tet_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","No tenik, ita la salin tua midar foun baa knaban tuan. Tan knaban tuan laꞌok, hotu tua midar nia nanii mohu. Ita musti salin tua midar foun baa knaban foun.” Hodi nunia, Yesus naꞌak, niakaan hanorin nia, foun. Keta kahur ho ema Farisi siakaan hanorin tuan. ");
INSERT INTO tet_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Baa loron ida, kona baa ema Yahudi siakaan loron hamulak no loron hanawa serwisu, Yesus no Niakaan maktuir sia laꞌo tuir toꞌos ida. Maktuir sia kuꞌu nola hare gandum, nodi naa la-laꞌok. ");
INSERT INTO tet_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mais noo ema Farisi mak naree. Hotu, sia nusu Yesus naꞌak, “Tan saa Okaan maktuir sia nakur itakaan ukun-badu? Sia kuꞌu hare gandum baa loron hanawa serwisu! La bele nunia!” ");
INSERT INTO tet_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Mais Yesus nataa naꞌak, “Emi la hanoin lia Bei Daud ka? Naꞌilulik boot baa oras nia, naran Abiatar. Natoon baa nia, Bei Daud no niakaan maktuir sia salaen basuk. Sia tama baa Batane Hamulak. Hotu, sia naa nola tubi mak naꞌilulik sia sera tiꞌan baa Naꞌi Maromak. Tuir loos, naꞌilulik sia mesan dei mak bele naa tubi nia. Mais, hanoin. Tan masik Bei Daud sia naa nola moos, la no ema mak nasalak sia.” ");
INSERT INTO tet_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hotu, Yesus nalore tenik naꞌak, “Emi keta haluꞌa haꞌak, Naꞌi Maromak naseꞌi loron hanawa serwisu nebee dadi matak-malirin bodik ema raiklaran. Nia la naseꞌi ema raiklaran nebee tuir ukun loron hanawa serwisu. ");
INSERT INTO tet_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Haꞌu neꞌe, Ema Raiklaran Isin mak ketan beran kosi Maromak. Haꞌu koo beran atu kakotu saa mak ema bele nalo baa loron hanawa serwisu.” ");
INSERT INTO tet_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hotu, Yesus baa nikar uma hamulak. Iha nia, noo ema ida mak liman matek. ");
INSERT INTO tet_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iha nia moos, noo ema naꞌin hira mak buka dalan atu nasalak Yesus. Sia namoo matan baa Yesus atu nodi natene naꞌak, Nia nadiꞌak nola ema moras baa loron hanawa serwisu ka, lale. ");
INSERT INTO tet_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mais Yesus bolu nola ema liman matek nia, nodi naꞌak, “Mariik baa oin neꞌe!” ");
INSERT INTO tet_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hotu, Yesus nusu baa ema nia sia hotu-hotu naꞌak, “Tuir itakaan ukun-badu, ita bele halo saa kona baa loron hanawa serwisu? Ita bele halo lia diꞌak ka, keta? Ita bele hadiꞌak hola ema ka, ita hoꞌo ema?” Mais sia hotu-hotu no-nook dei. ");
INSERT INTO tet_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Naree nunia, Yesus laran moras tebes, tan ema nia sia naliku loos siakaan ukun-badu dei; la naliku ema liman matek nia. Yesus moos nawan saꞌe nodi mana baa-mai baa ema nia sia. Hotu, Nia katak baa ema moras nia naꞌak, “Lolo o liman mai!” Ema nia lolo liman baa. Laku matan dei, liman diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Naree nunia, ema Farisi sia sai nela uma hamulak nia, baa dale kabuar lia fuan no ema partee politik Herodes, atu buka dalan noꞌo Yesus. ");
INSERT INTO tet_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Baa loron ida, Yesus no Niakaan maktuir sia laꞌo tenik baa debu boot Galilea tehen. Ema waꞌin mai nosi leo-leo atu tuir Yesus, tan sia rona tiꞌan saa mak Nia nalo. Sia mai nosi rai Galilea, rai Yudea, no rai Idumea. Ema balu moos mai nosi kota Yerusalem, leo Sidon, no leo Tirus. Balu tenik mai nosi mota Yordan lorosaꞌe. Sia hotu-hotu mai buka Yesus. ");
INSERT INTO tet_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tan ema nia sia waꞌin basuk, Yesus naruka Niakaan maktuir sia nadiꞌa bero ida bodik Nia. Nia atu nanorin nosi bero leten, nebee ema keta sara Nia, no ema hotu-hotu bele rona. ");
INSERT INTO tet_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ema moras sia mai sesu malu atu koko Yesus tan sia rona Yesus nadiꞌak nola ema waꞌin tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Oras ema mak kona diabu tekar naree Yesus, sia nakloti tabarakat aan iha Yesus oin, tan nataꞌuk. Sia nahii naꞌak, “Ita Boot neꞌe, Naꞌi Maromak Oan tebes!” ");
INSERT INTO tet_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mais, Yesus nakahik makaꞌas sia naꞌak, “Keta hasara baa ema haꞌak, Haꞌu neꞌe, see.” ");
INSERT INTO tet_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hotu, Yesus saꞌe baa foho ida. Nia bolu nola ema naꞌin hira mak kona baa Niakaan neon. Sia moos tuir Nia. ");
INSERT INTO tet_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Toꞌo baa, Nia boi nola ema naꞌin sanulu resin rua, nodi katak baa sia naꞌak, “Haꞌu kboi kola emi atu dadi baa Haꞌukaan maktuir. Haꞌu atu karuka emi baa keke lema Naꞌi Maromak Manfatin. ");
INSERT INTO tet_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Haꞌu moos atu klatan beran baa emi, nebee emi bele teꞌur sai diabu.” ");
INSERT INTO tet_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ema naꞌin sanulu resin rua nia, naran mak neꞌe: Simon (Yesus moos nanaran nia naꞌak, Petrus), Yakobus, Yohanis (Yohanis no maun Yakobus ohin nia, Sebadeus oan. Yesus moos nanaran sia naꞌak ‘Boanerges.’ Neꞌe naꞌak ‘hanesan kokur.’) Andreas, Filipus, Bartolomeus, Mateus, Tomas, Yakobus (Alfeus oan), Tadeus, Simon (nia neꞌe mak tuir Partee Selot), Yudas Iskariot (nia neꞌe mak atu faꞌan lakon Yesus). ");
INSERT INTO tet_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hotu, Yesus no Niakaan maktuir sia tuun nikar nosi foho nia, tama baa uma ida laran. La kleur, ema waꞌin mai baa Nia, toꞌo la no leet atu naa. ");
INSERT INTO tet_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Naree nunia, ema naꞌak, “Yesus neꞌe, ema oin saa? Nia naluꞌa tiꞌan isin lolon duꞌuk.” Oras Yesus familin sia rona nola nunia, sia moos mai atu nodi Nia fila. ");
INSERT INTO tet_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Baa oras nia, manorik ukun Yahudi sia moos mai nosi kota Yerusalem. Sia katak baa ema hotu-hotu naꞌak, “Hoi! Emi keta tuir Yesus nia. Nia bele teꞌur sai diabu waꞌin nunia, tan nola beran nosi diabu ulun, mak naran Baalsebul.” ");
INSERT INTO tet_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Rona nola nunia, Yesus bolu sia nodi katak naꞌak, “La tama kakutak! Oin nunabee diabu ulun naꞌin teꞌur duꞌuk aan?!” Hotu Yesus foo lia hatetek naꞌak, ");
INSERT INTO tet_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Kalo ema fohorai ida funu malu, oin nunabee fohorai nia bele manek toꞌo kleur?! La bele! ");
INSERT INTO tet_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kalo ema uma kain ida la kona malu, oin nunabee sia bele moris namutuk toꞌo kleur?! La bele! ");
INSERT INTO tet_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nunia moos, kalo diabu sia funu malu, sia nanis keen karin malu toꞌo dodok welon! ");
INSERT INTO tet_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kalo ema beer nanaꞌo iha ema biit ida uman, nia kesi uluk uma naꞌin lai, foin nia bele nola naha. ");
INSERT INTO tet_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Naꞌi Maromak nanis kasu ema raiklaran salan. Kalo ema dale nahaat ema seluk, Naꞌi Maromak sei kasu siakaan salan. ");
INSERT INTO tet_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mais kalo ema dale nahaat Maromak Kmalar Lulik, Naꞌi Maromak la kasu sala nia, toꞌo rai falu fila.” ");
INSERT INTO tet_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus katak nunia, tan sia tula sala baa Nia naꞌak: “Ema nia, diabu kaer!” ");
INSERT INTO tet_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hotu, Yesus inan no Yesus alin sia mai iha uma nia atu nasoru Nia. Toꞌo baa, sia nariik iha luan dei, nodi naruka ema bolu Nia. ");
INSERT INTO tet_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yesus sei tuur nodi nanorin ema waꞌin, ema mai nasee nia naꞌak, “Ama! Itakaan inan no Itakaan alin sia iha luan. Itakaan familin sia beer atu nasoru Ama.” ");
INSERT INTO tet_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mais Yesus nataa naꞌak, “Haꞌukaan familin malolok, mak see?” ");
INSERT INTO tet_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hotu, Nia titu baa-mai baa ema mak tuur satan Nia. Nia moos katak naꞌak, “Emi hotu-hotu neꞌe, mak Haꞌukaan familin malolok. ");
INSERT INTO tet_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tan ema mak nalo tuir Naꞌi Maromak hakaran, sia mak Haꞌukaan familin malolok.” ");
INSERT INTO tet_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Baa loron ida, Yesus fila baa debu boot Galilea. Ema waꞌin moos mai kabuun nola Nia. Hotu, Nia saꞌe baa bero ida mak nanawa iha nia, nebee ema hotu-hotu iha rai bele rona Nia. ");
INSERT INTO tet_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nia nanorin lia waꞌin baa sia, nodi lia hatetek naꞌak, ");
INSERT INTO tet_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Rona diꞌa-diꞌak! Noo ema mahalo toꞌos ida baa kari fini iha toꞌos. ");
INSERT INTO tet_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Baa oras kari, fini balu monu baa dalan. Hotu, manu ai leten sia mai tutu nola mohu. ");
INSERT INTO tet_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Fini balu monu baa rai fatuk. Fini nia sia tubu lai-lais tan kona rai isin niꞌis. ");
INSERT INTO tet_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mais oras loro kona, tubun nia naklaik hotu mate, tan abut la tama leꞌan. ");
INSERT INTO tet_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fini balu tenik, monu baa ai tarak laran. Fini nia sia tubu buras, mais ai tarak neti nola toꞌo la nafua. ");
INSERT INTO tet_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Fini balu tenik, monu baa rai isin. Fini nia sia tubu toꞌo boot no nafua waꞌin. Oras kuꞌu, balu foo nikar folin toꞌo isin tolu nulu, balu toꞌo isin neen nulu, balu tenik toꞌo isin atus ida. ");
INSERT INTO tet_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","See mak noo tilun, rona diꞌa-diꞌak!” ");
INSERT INTO tet_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Baa oras Yesus tuur mesan, Niakaan maktuir naꞌin sanulu resin rua no ema seluk mak rona tiꞌan lia hatetek nosi fini nia, sia mai nusu lia nia isin baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesus nataa naꞌak, “Tan emi neꞌe beer hatene tebe-tebes Naꞌi Maromak ukun, Haꞌu kloke malorek lia hatetek nia isin baa emi. Mais kalo ema seluk mak la noꞌuk natene, Haꞌu kanorin kodi lia hatetek dei. ");
INSERT INTO tet_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Maromak makoꞌan ida nakerek nela kedan kona baa ema hanesan sia naꞌak: ‘Sia naree tiꞌan, mais la noꞌuk natene. Sia rona tiꞌan, mais la noꞌuk rai baa neon. Dadi habusik baa, nebee sia lalika fiar baa Naꞌi Maromak, nebee Naꞌi Maromak moos lalika kasu siakaan salan.’ ” ");
INSERT INTO tet_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hotu, Yesus katak tenik naꞌak, “Kalo emi sei la kohi dauk lia hatetek nia isin, nunabee tenik baa lia hatetek seluk sia? ");
INSERT INTO tet_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nuneꞌe: Ema mak kari fini nia, hanesan ema mak katak keke Naꞌi Maromak Manfatin. ");
INSERT INTO tet_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Fini mak monu baa dalan nia, mak manu ai leten tutu nola, hanesan ema mak rona Naꞌi Maromak Manfatin, mais nia la rai diꞌa-diꞌak baa neon. Hotu, diabu ulun mai foti nola. ");
INSERT INTO tet_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Fini mak monu baa rai fatuk, hanesan ema mak rona tiꞌan Naꞌi Maromak Manfatin, hotu nia simu diꞌa-diꞌak nodi neon no laran. ");
INSERT INTO tet_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mais Manfatin nia la nahabut, tan ema nia la rai diꞌa-diꞌak baa neon. Baa oras ema seluk nasusar nia tan nia simu Manfatin nia, nia nataꞌuk, toꞌo nabusik nela Manfatin nia. ");
INSERT INTO tet_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Fini mak monu baa ai tarak laran, hanesan ema mak rona nola Manfatin nia, ");
INSERT INTO tet_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mais nia nalai baa-mai buka soi no moris furak, toꞌo naluꞌa Manfatin nia. ");
INSERT INTO tet_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mais fini mak monu baa rai isin, hanesan ema mak taꞌan tilun nodi simu Manfatin nia. Hotu, nia moris tuir Naꞌi Maromak hakaran. Nia moos nalo lia diꞌak, hanesan fini mak nafua waꞌin, toꞌo isin tolu nulu, isin neen nulu, no isin atus ida.” ");
INSERT INTO tet_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hotu, Yesus nanorin natutan tenik nosi bero nia, nodi lia hatetek ida seluk naꞌak, “Kalo ita sunu badut, ita taka hodi hanek ka? Lale, ita rai iha koi ohak ka? Lale! Kalo nunia, badut nanis la nakroma ona. Ita rai baa fatin aas, nebee laka naroma fatin nia. ");
INSERT INTO tet_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nunia moos, lia hotu-hotu mak sei nakfunin baa oras neꞌe, atu naksain. Lia hotu-hotu mak ema sei la hatene baa oras neꞌe, ema atu natene. ");
INSERT INTO tet_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","See mak no tilun, rona diꞌa-diꞌak!” ");
INSERT INTO tet_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hotu, Yesus katak tenik naꞌak, “Hanoin diꞌa-diꞌak lia neꞌe! Kalo emi sukat ema seluk, ema moos sukat fila emi. Naꞌi Maromak moos atu sukat emi. Mais Niakaan sasukat, todan liu tenik. ");
INSERT INTO tet_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ema mak beer tebe-tebes atu natene Naꞌi Maromak hakaran, nia hetak natene. Mais ema mak la noꞌuk natene Naꞌi Maromak hakaran, nia hetak beik.” ");
INSERT INTO tet_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Hotu, Yesus nalore tenik naꞌak, “Naꞌi Maromak hutun-renun hanesan fini mak ema kari iha toꞌos laran. ");
INSERT INTO tet_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kari hotu, ema nia fila nikar, toba-nadeer, la nanoin tenik fini nia. Masik nunia moos, fini nia tubu duꞌuk toꞌo boot. ");
INSERT INTO tet_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hotu nataha, nasorun, nafuna, nafua, toꞌo noo isin. ");
INSERT INTO tet_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Oras naktuuk tiꞌan, foin ema nia mai kuꞌu. Nunia moos Naꞌi Maromak hutun-renun sia. Sia moris tan Naꞌi Maromak mak foo moris baa sia. Lahoos ema raiklaran.” ");
INSERT INTO tet_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Hotu, Yesus katak tenik naꞌak, “Haꞌu tuꞌan tenik lia hatetek ida, nebee emi bele hatene oin nunabee Naꞌi Maromak dadi Naꞌin bodik ema lear. Uluk fohon, Naꞌi Maromak renun naꞌin hira dei, mais kleu-leur hetak waꞌin tuꞌan. ");
INSERT INTO tet_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sia nahuu hanesan ai fuan musan mak kiꞌik oan basuk. ");
INSERT INTO tet_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mais kalo kuda baa rai tiꞌan, nia moris dadi ai huun boot, toꞌo manu ai leten mai rani baa, no nalo knuuk iha sorun.” ");
INSERT INTO tet_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Hodi nunia, Yesus nanorin ema tuir siakaan babelen. ");
INSERT INTO tet_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kalo nanorin ema waꞌin, Nia nodi lia hatetek dei. Mais kalo nanorin Niakaan maktuir sia duꞌuk, Nia nalore lia hatetek isin sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yesus nanorin ema nia sia nosi bero nia, toꞌo loro malirin. Hotu, Nia tene Niakaan maktuir sia naꞌak, “Mai ita baa balu baa.” ");
INSERT INTO tet_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Rona nola nunia, Niakaan maktuir sia saꞌe tuir baa bero. Hotu, sia laꞌo nela ema waꞌin nia, mais ema balu tuir nodi bero seluk. ");
INSERT INTO tet_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Baa oras laꞌo, Yesus toba luni kluni toꞌo dukur iha bero ikun. La kleur, anin dadurus mai. Laloran moos basak natama wee baa bero laran, toꞌo kreꞌis nakonu. Yesus Niakaan maktuir sia nataꞌuk tebes. Hotu, sia fuꞌa nadeer Nia naꞌak, “Ama! Madeer lai! Ama la madomi ami ka?! Ita atu mate mout ona!” ");
INSERT INTO tet_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Rona nola nunia, Yesus nadeer, hotu nakahik anin nia naꞌak, “Makmatek!” Nia moos naruka debu boot nia naꞌak, “Noo-nook ona!” Hotu, anin nia nanawa kedas. Nunia moos, laloran iha debu nia nakmatek kedas. ");
INSERT INTO tet_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hotu Yesus nasee Niakaan maktuir sia naꞌak, “Tan saa emi hataꞌuk nunia? Emi sei la fiar baa Haꞌu ka?” ");
INSERT INTO tet_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mais sia hotu-hotu nataꞌuk no blaar. Sia namaas baa malu naꞌak, “Nia neꞌe see? Toꞌo anin no laloran moos rona baa Nia!” ");
INSERT INTO tet_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hotu, Yesus no Niakaan maktuir sia toꞌo debu Galilea balu baa, iha fatin ida naran Gerasa. ");
INSERT INTO tet_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Iha nia, noo mane ida mak diabu tekar toꞌo bula. Nia nein iha rate sia. Loron-kalan nia nakwalan dei, saꞌe-tuun foho nodi nahii nahutan karin. Nia nitak aan nodi fatuk, toꞌo isin lolon kanek mohu. Nia biit tebes, toꞌo ema la bele kesi nola nia. Ema kesi rua-ruan niakaan ain-liman nodi besi talik, mais nia nasiit nosi liman, no natohar nosi ain. Nia biit resik, toꞌo la noo ema ida mak bele namaus nola. Baa oras Yesus no Niakaan maktuir sia tuun nosi bero, sama ain baa rai maran, ema bulak nia naree sia nosi dook. Hotu, nia nalai sai nosi rate baa Yesus. Toꞌo baa, nia nakniꞌa iha Yesus oin. ");
INSERT INTO tet_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Naree nola nunia, Yesus naruka naꞌak, “Hoi! Diabu aat! Sai mela ema neꞌe ona!” Hotu, ema nia nahii makaꞌas naꞌak, “Hoi! Ita Boot atu halo saa baa haꞌu?! Haꞌu katene Ita Boot neꞌe Yesus, mak Naꞌi Maromak Boot Kaliuk Oan. Haꞌu kaloon nebee Ita Boot keta hasusar haꞌu.” ");
INSERT INTO tet_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hotu, Yesus nakusuk nia naꞌak, “O naran see?” Ema nia nataa naꞌak, “Haꞌu naran Legion, tan ami neꞌe waꞌin lear, hanesan sondadu klibur boot ida!” ");
INSERT INTO tet_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hotu, diabu nodi ema nia atu nakroꞌan nebee Yesus keta naruka sia sai nosi rai nia. ");
INSERT INTO tet_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kreꞌis baa nia, ema naꞌin hira noꞌi daka fahi lear mak buka haan iha foho leten. Sura fahi nia sia hotu-hotu, bele tama matan rihun rua. ");
INSERT INTO tet_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Diabu sia nakroꞌan baa Yesus naꞌak, “Ita Boot haruka ami tama baa fahi nia sia dei.” ");
INSERT INTO tet_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Rona nola nunia, Yesus moos noꞌuk. Hotu, diabu sia nalai sai nela ema nia, tama kedan baa fahi nia sia. Fahi nia sia hotu-hotu bula karin, nalai lakon tuun nosi foho nia, tama baa debu boot laran. Hotu, mate mout. ");
INSERT INTO tet_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Titu-naree nunia, ema makdaka fahi nia sia nataꞌuk tebes. Sia nalai baa katak ema sura leo. Rona sia dale nunia, ema lear nalai sai mai atu naree saa mak dadi nia. ");
INSERT INTO tet_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sia baa nasoru Yesus, hotu naree ema mak diabu tekar nia noꞌi tuur iha nia. Nia diꞌak nikar no tau tais tiꞌan. Naree nunia, sia nataꞌuk hotu, tan sia natene nanis, see mak bele teꞌur sai diabu nosi ema nia, makaꞌas tebes. ");
INSERT INTO tet_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hotu, sia baa katak lema rai naꞌak, sia naree duꞌuk ema bulak nia diꞌak tiꞌan, no fahi nia sia moos mate mout tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sia moos nakroꞌan, nebee Yesus sai nela rai nia. ");
INSERT INTO tet_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Oras Yesus saꞌe baa bero, ema bulak ohin nia nakroꞌan atu tuir no Yesus. ");
INSERT INTO tet_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mais, Yesus la noꞌuk. Nia katak naꞌak, “Diꞌak liu o fila mikar, baa masara okaan familin sia nosi lia mak Naꞌi Maromak nalo tiꞌan baa o. O moos katak maꞌak, Naꞌi Maromak nadomi tebes o.” ");
INSERT INTO tet_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hotu, ema nia baa laꞌo lema rai ida mak noo leo sanulu, mak ema nanaran naꞌak, ‘Dekapolis’. Nia katak saa mak Yesus nalo tiꞌan baa nia. Rona nola nunia, ema hotu-hotu blaar nodi naꞌak, “Makaꞌas tebes!” ");
INSERT INTO tet_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Hotu, Yesus no maktuir sia saꞌe bero, fila nikar debu boot balu baa. Oras sia tuun, ema waꞌin mai baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iha nia noo ema ida naran Yairus. Nia, mak ema uma hamulak ulun iha leo nia. Oras naree Yesus, nia mai nakniꞌa iha Yesus oin, ");
INSERT INTO tet_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nodi nakroꞌan naꞌak, “Ama, tulun lai! Haꞌukaan oan feto moras todan atu mate. Niakaan otas foin tinan sanulu resin rua. Kalo bele, Ama tulun haꞌu. Mai iha haꞌukaan uma, madiꞌak mola nia lai.” ");
INSERT INTO tet_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Rona nola nunia, Yesus tuir kedas baa Yairus uman. Mais oras sia atu laꞌo, ema waꞌin moos tuir, toꞌo sia sesu malu oin-kotuk no karuk-kwana. ");
INSERT INTO tet_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iha ema waꞌin nia klaran, noo feto ida. Tinan sanulu resin rua tiꞌan, nia netan fulan mak la nanawa tuir loos. ");
INSERT INTO tet_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nia namohu niakaan osan no sasoin hotu-hotu, nodi selu makdook sia, nebee nadiꞌak nola nia. Mais, la noo makdook ida mak bele nadiꞌak nola nia. Niakaan moras nia, hetak kleur, hetak tuꞌan. ");
INSERT INTO tet_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Nia rona tiꞌan lia waꞌin nosi Yesus. Tan lia nia, nia nakaꞌas aan iha ema waꞌin klaran, atu bele toꞌo baa Yesus nosi kotuk. Nia naneo naꞌak, “Surak haꞌu koko Niakaan faru dei, nanis haꞌu diꞌak!” Oras nia koko lerek Yesus farun, laku matan dei, niakaan moras nanawa kedas. Nia noran diꞌak tebes. ");
INSERT INTO tet_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Oras nia moos, Yesus noran beran sai. Tan baa nia, Nia titu fila baa ema waꞌin nia nodi nusu naꞌak, “See mak koko Haꞌukaan faru?” ");
INSERT INTO tet_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mais Niakaan maktuir sia nataa naꞌak, “Ama! Ama maree duꞌuk baa. Ema lear sesu malu nuneꞌe. Oin nunabee, ita bele hatene see?” ");
INSERT INTO tet_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mais Yesus titu baa-mai atu nodi natene see mak koko farun. ");
INSERT INTO tet_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Rona nola Yesus nusu nunia, feto nia nataꞌuk tebe-tebes. Hotu, nia nakniꞌa iha Yesus oin nodi naberan aan katak naꞌak, “Ama! Haꞌu mak koko Ita Boot farun!” ");
INSERT INTO tet_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesus moos nataa naꞌak, “Tan ina fiar tebe-tebes baa Haꞌu, ina diꞌak tiꞌan. Oras neꞌe, ina fila baa uma ona modi neon diꞌak.” ");
INSERT INTO tet_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus sei dale nunia, ema ida mai nosi Yairus uman nodi katak naꞌak, “Aikee! Ama oan mate tiꞌan. Lalika makole Ama Boot ona.” ");
INSERT INTO tet_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mais Yesus la titu dalen nia. Nia katak baa Yairus naꞌak, “Keta mataꞌuk! Fiar baa dei.” ");
INSERT INTO tet_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hotu, Yesus laꞌo nela Niakaan maktuir rumak sia, nodi mesan Petrus, Yakobus, no Yohanis liu baa. ");
INSERT INTO tet_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Oras toꞌo Yairus uman baa, sia naree ema nalai baa-mai, no rona ema tanis nakrake. ");
INSERT INTO tet_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hotu, Yesus tama liu baa uma laran, nusu baa ema nia sia naꞌak, “Tan saa emi hasusar aan hodi tanis nunia? Oa neꞌe la mate. Nia toba dei.” ");
INSERT INTO tet_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Rona nola Yesus dale nunia, sia nanasa Nia. Mais Yesus naruka sia sai hotu. Nia bolu nola maktuir naꞌin tolu nia, no oa nia inan-aman, tama baa keꞌan laran. ");
INSERT INTO tet_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesus kaer oa nia liman, hotu katak nodi siakaan lian naꞌak, “Talita kum!” Neꞌe naꞌak, “Bete! Madeer ona!” ");
INSERT INTO tet_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Laku matan dei, oa nia nadeer nodi laꞌo kedas. Hotu, Yesus naruka oa nia inan naꞌak, “Mahaan nia lai!” Ema hotu-hotu mak naree, blaar karin. Mais Yesus nakahik sia naꞌak, “Keta hasara baa ema, haꞌak Haꞌu mak kalo nia moris nikar!” ");
INSERT INTO tet_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hotu, Yesus no Niakaan maktuir sia fila nikar baa Yesus Niakaan leo Nasaret. ");
INSERT INTO tet_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Loron hamulak toꞌo, ema waꞌin baa namulak. Yesus moos tama baa uma hamulak atu nanorin. Baa oras nanorin, ema nia sia blaar nodi tonun naꞌak, “Ema neꞌe matenek liu! Nia moos no beran! Oin nunabee Nia bele nunia? ");
INSERT INTO tet_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tuir loos, Nia neꞌe badaen ai dei. Ita hatene Niakaan inan mak Maria no Niakaan alin sia mak Yakobus, Yoses, Yudas no Simon. Nia moos no alin feto. Ita hatene malu, tan ita leo ida!” Masik nunia moos, sia sei hirus Yesus toꞌo la noꞌuk rona tenik baa Nia. ");
INSERT INTO tet_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Natene nola nunia, Yesus katak naꞌak, “Tebes! Maromak makoꞌan ida baa iha nabee dei, ema nakneter nia. Mais niakaan ema sia iha leo duꞌuk la nakneter nia.” ");
INSERT INTO tet_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Yesus blaar tan ema Nasaret sia la noꞌuk fiar baa Nia. Tan lia nia, Nia la natudu beran waꞌin iha leo nia. Nadiꞌak nola loos ema moras ida-rua dei. ");
INSERT INTO tet_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Hotu, Yesus tuur sura leo mak kreꞌis nia sia nodi nanorin ema. ");
INSERT INTO tet_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nia moos bolu nola Niakaan maktuir naꞌin sanulu resin rua nodi solok sia naꞌin rua-rua baa keke lema Naꞌi Maromak Manfatin. Nia moos foo beran baa sia atu nodi teꞌur sai diabu. ");
INSERT INTO tet_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Nia naruka sia naꞌak, “Emi musti laꞌo tanan dei. Lalika hodi bakae, osan no kakaluk. Hodi mesan kaso ain no faru tahan ida, no kaer hodi knoꞌa ida dei. ");
INSERT INTO tet_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kalo ema simu emi iha siakaan uma, hein iha nia toꞌo laꞌo. ");
INSERT INTO tet_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mais, kalo emi toꞌo fatin ida, hotu ema la noꞌuk simu emi, laꞌo hela fatin nia hodi katak baa sia haꞌak, ‘Tan emi la hoꞌuk rona Naꞌi Maromak Manfatin, ami hisik hela ahukresan leo neꞌe hosi amikaan ain atu dadi tadak naꞌak, emi naꞌin duꞌuk mak hatiu dinu.’ ” ");
INSERT INTO tet_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hotu sia baa keke lema Naꞌi Maromak Manfatin nodi katak baa ema, nebee sia nanawa nalo sala nodi moris tuir Naꞌi Maromak hakaran. ");
INSERT INTO tet_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sia teꞌur sai diabu. Sia kose mina baa ema moras ulun nodi namulak atu nadiꞌak nola sia. Hotu, ema moras sia moos diꞌak. ");
INSERT INTO tet_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Baa oras nia, ema nosi fatin hotu-hotu natene Yesus tiꞌan. Lia nosi Yesus beran nia moos toꞌo Naꞌi Herodes tilun tiꞌan. Noo ema mak naꞌak, “Yesus neꞌe, Yohanis Mak Sarani Ema. Yohanis mate tiꞌan, mais moris nikar iha Yesus isin lolon. Tan baa nia, Yesus bele nalo tadak blaar oi-oik.” ");
INSERT INTO tet_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mais noo ema balu mak naꞌak, “Lale! Yesus neꞌe, Maromak makoꞌan Elia hori uluk. Nia mak moris nikar iha Yesus isin lolon.” Balu tenik naꞌak, “Lahoos nunia! Yesus neꞌe, Maromak makoꞌan foun ida, hanesan makoꞌan uluk sia.” ");
INSERT INTO tet_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mais oras Naꞌi Herodes rona lia nia sia, nia nalore naꞌak, “Yesus neꞌe, nanis Yohanis. Uluk haꞌu karuka ema taa kotu ulun, mais oras neꞌe, nia moris nikar!” ");
INSERT INTO tet_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Uluk Naꞌi Herodes naruka nunia, tan nia nalo lia boot no Yohanis. Lia nia, nuneꞌe: Uluk naꞌi Herodes nola nikar alin Filipus feen, naran Herodias. Mais tuir loos, Filipus no Herodias la soe malu dauk. Tan lia nia, Yohanis nakahik Naꞌi Herodes bei-beik naꞌak, “Ama Naꞌi! Ita Boot la bele hola hikar itakaan alin feen. Lia nia nakur naksoit itakaan adat Yahudi!” Mais, Naꞌi Herodes nola luku dei. Hotu, nia moos naruka ema kohi nola Yohanis natama baa bui. ");
INSERT INTO tet_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tan Yohanis nakahik sia bei-beik, Ina Naꞌi Herodias moos hirus toꞌo atu noꞌo Yohanis. Mais la noo leet, tan Naꞌi Herodes natama Yohanis iha bui tiꞌan, ");
INSERT INTO tet_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","no naruka sondadu sia nebee daka metin nia. Naꞌi Herodes duꞌuk nakerat Yohanis. Nia natene naꞌak, Naꞌi Maromak mak naruka Yohanis mai. Liu tenik, Yohanis neꞌe, ema diꞌak no loos. Naꞌi Herodes duꞌuk nakara rona Yohanis. Mais isin ida-idak, nia moos noran la diꞌak rona Yohanis dalen. ");
INSERT INTO tet_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nosi ikus, Ina Naꞌi Herodias netan leet noꞌo Yohanis. Loron nia, sia nadahur Naꞌi Herodes loron moris nodi namata ema boot sia mai hotu. Ema nia sia, mak makaer ukun, sondadu ulun, no fukun rai Galilea tomak. ");
INSERT INTO tet_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Oras sia nadahur, Ina Naꞌi Herodias oan feto tama bidu. Nia bidu furak lo-loos toꞌo Naꞌi Herodes no bainaka sia neon diꞌak tebes. Tan baa nia, Naꞌi Herodes bolu nola oa nia hotu katak naꞌak, “Oa! O makara saa, katak mai! Haꞌu atu kfoo baa o! ");
INSERT INTO tet_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Masik o musu haꞌukaan fohorai neꞌe faꞌe rua moos, haꞌu nanis foo. Karai aan kodi laleꞌan no raiklaran, kalo mamenon neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hotu, oa feto nia baa nusu inan naꞌak, “Ina! Ina nakara haꞌu kusu saa baa Ama Herodes?” Hotu, inan nataa naꞌak, “Aaa! O baa musu Yohanis ulun dei!” ");
INSERT INTO tet_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hotu, oa nia baa nikar Naꞌi Herodes, hotu katak naꞌak, “Ama! Haꞌu kusu Yohanis ulun. Tau baa bikan ida, hodi mai baa haꞌu oras neꞌe ona!” ");
INSERT INTO tet_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rona nola nunia, Naꞌi Herodes neon lakon kedan. Mais nia la bele dada nikar niakaan lia fuan nia, tan nia nameno tiꞌan, no ema waꞌin moos rona tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tan baa nia, Naꞌi Herodes naruka sondadu ulun ida baa taa kotu Yohanis ulun iha bui laran. ");
INSERT INTO tet_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Taa nola Yohanis ulun tiꞌan, sia tau baa bikan ida, nodi mai foo baa oa feto nia. Oa nia simu nola, hotu foo baa inan. ");
INSERT INTO tet_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Oras Yohanis niakaan maktuir sia rona nola naꞌak ema taa kotu Yohanis ulun tiꞌan, sia moos mai nasai nola Yohanis maten nodi baa nakoi. Lia Yohanis mate, nunia dei. ");
INSERT INTO tet_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Baa loron ida, Yesus Niakaan maktuir sia mak Nia solok tiꞌan nia, fila nikar mai namutuk no Nia. Sia katak lia hotu-hotu mak sia nalo no nanorin tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Baa oras nia moos, ema waꞌin laꞌo baa-mai buka Yesus, toꞌo Nia no Niakaan maktuir sia la noo leet atu naa. Naree nunia, Yesus katak baa Niakaan maktuir sia naꞌak, “Mai ita baa fatin mamuk ida, nebee ita hanawa sala-sala lai.” ");
INSERT INTO tet_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hotu, sia saꞌe bero baa buka fatin mamuk ida mak dook nosi leo nia. ");
INSERT INTO tet_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mais ema waꞌin nia naree siakaan bero tuir debu boot tehen. Sia moos sai nosi leo laran, laꞌo tesi tuir rai maran, toꞌo uluk Yesus sia. ");
INSERT INTO tet_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Oras Yesus sia tuun, ema waꞌin nia nein tiꞌan. Naree nunia, Yesus neon monu, tan ema nia sia la natene atu nalo saa. Sia hanesan bibi malae mak la noo makdaka. Nia moos nanorin sia ");
INSERT INTO tet_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","nosi loro natetu toꞌo loro malirin. Oras loro malirin tiꞌan, Yesus Niakaan maktuir sia katak baa Nia naꞌak, “Ama! Diꞌak liu, maruka ema waꞌin neꞌe baa sosa haan iha leo kreꞌis neꞌe sia, tan haan la noo iha neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mais Yesus nataa naꞌak, “Lalika! Emi mak hahaan sia dei!” Mais sia nataa nikar naꞌak, “Aikee! Kalo ami mak hahaan ema lear neꞌe, ami musti hasai osan lear boot, hanesan ema kansera tinan ida! Oin nunabee, ami bele hetan osan lear nunia?” ");
INSERT INTO tet_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mais Yesus nataa naꞌak, “Emi baa buka lai, keta noo ema mak nodi bakae.” Sia moos baa buka, hotu mai nikar katak baa Yesus naꞌak, “Ami hetan loos tubi baluk lima no naꞌan tasi lolon rua.” ");
INSERT INTO tet_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hotu, Yesus naruka ema lear nia tuur naklibur baa hae fohon. ");
INSERT INTO tet_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Sia moos tuur naklibur nunia. Klibur balu, ema naꞌin atus ida, balu tenik, naꞌin lima nulu. ");
INSERT INTO tet_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hotu, Yesus nola tubi baluk lima nia no naꞌan tasi lolon rua nia. Nia tanaat baa laleꞌan nodi nusu matak-malirin baa Naꞌi Maromak. Hotu, Nia tohi faꞌe tubi nia, lolo baa maktuir sia, nebee sia faꞌe nadaar baa ema hotu-hotu. Nunia moos, naꞌan tasi lolon rua nia. ");
INSERT INTO tet_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ema lear nia moos naa toꞌo bosu. ");
INSERT INTO tet_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sia naa notu tiꞌan, Yesus Niakaan maktuir sia libur nola haan resin sia, nakonu koꞌe sanulu resin rua. ");
INSERT INTO tet_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ema lear nia bele tama naꞌin rihun lima. Nia, foin sura mane dei. Sei la sura feto no lawarik sia. ");
INSERT INTO tet_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hotu, Yesus naruka Niakaan maktuir sia saꞌe bero, uluk Nia baa leo Betsaida iha debu boot balu baa. Mais Nia duꞌuk sei nein atu naruka ema lear nia fila. ");
INSERT INTO tet_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ema nia sia fila hotu tiꞌan, Nia saꞌe baa foho leten atu namulak. ");
INSERT INTO tet_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Kreꞌis kalan ona, Nia tuun nikar. Nia naree Niakaan maktuir siakaan bero toꞌo debu boot klaran tiꞌan. Mais sia fofer mate sala, tan sakar anin. Kreꞌis rai naroma, Yesus moos baa tuir sia. Mais, Nia laꞌo iha wee leten dei. Baa oras Nia atu taliꞌur bero nia, maktuir sia naree Nia. Sia sarebak tekis, nodi nusu baa malu naꞌak, “Hoi! Saa mak nia? Ema kmalar ka?!” Mais Yesus katak baa sia naꞌak, “Keta hataꞌuk! Haꞌu neꞌe Yesus!” ");
INSERT INTO tet_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hotu, Yesus saꞌe baa bero laran. Anin moos nanawa kedan. Niakaan maktuir sia blaar hotu. ");
INSERT INTO tet_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sia foin naree Yesus nasai beran nodi nahaan ema rihun lima resin, mais sia sei la natene tebe-tebes Niakaan beran, tan siakaan neon no laran sei monas. ");
INSERT INTO tet_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Toꞌo debu boot balu baa, Yesus sia tuun, hotu kesi bero iha leo ida naran Genesaret. ");
INSERT INTO tet_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Oras nia, ema waꞌin naree, hotu sia nahii naꞌak, “Hoi! Yesus mai tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Sia moos nalai baa katak ema hotu-hotu iha leo laran. Rona nola nunia, ema natiu nodi mai siakaan ema moras sia. Rona loos dei naꞌak Yesus iha fatin ida, ema mai natoba lerek ema moras sia iha fatin nia. Tan sia naneo naꞌak, “Surak koko loos Yesus farun ninin dei moos, ema moras diꞌak kedas.” ");
INSERT INTO tet_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Baa loron ida, ema Farisi kabuun ida no manorik ukun Yahudi naꞌin hira, mai nosi Yerusalem atu nasoru Yesus. ");
INSERT INTO tet_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Ema Farisi sia kaer metin adat nosi bei uluk Yahudi sia. Sia nalo nuneꞌe: kalo haa, musti fasi uluk liman tuir adat. Nunia moos, mai hikar hosi faꞌan fatik iha nabee dei, musti hariis kedan tuir adat. Toꞌo bahoꞌak uma laran, nuꞌu bikan-mako, musti fasi lai tuir adat, foin bele hodi haa. Kalo ema Yahudi seluk la tuir adat nia, ema Farisi sia nawan saꞌe. Tan baa nia, oras ema Farisi sia naree Yesus Niakaan maktuir sia naa la fasi uluk liman tuir siakaan adat nia, sia nawan saꞌe. Hotu, sia mai nasalak Yesus naꞌak, “Tan saa okaan maktuir sia la fasi uluk liman lai tuir itakaan adat, foin naa? Sia nakur tiꞌan itakaan adat nosi bei uluk sia!” ");
INSERT INTO tet_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Mais Yesus nataa naꞌak, “Emi neꞌe, liu resik tiꞌan! Emi katak seluk, halo seluk! Hori uluk, Maromak naruka makoꞌan Yesaya nakerek nela kedan naꞌak, ‘Ema nia sia tonun Haꞌu nodi ibun dei, la nodi neon. Tonun oin nunia, butan dei. Sia la nikir Haꞌukaan ukun. Sia nikir loos ema raiklaran ukun dei.’ Emi moos halo nunia. ");
INSERT INTO tet_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Emi taliꞌur Naꞌi Maromak ukun, hotu kaer metin adat ema raiklaran. Emi matenek basuk halo nunia! ");
INSERT INTO tet_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Uluk bei Musa natuun ukun-badu nosi Naꞌi Maromak naꞌak, ‘Ita musti hakneter ina-ama.’ Liu tenik, ‘Kalo ema ida deꞌan nahaat inan-aman, musti taa ukun mate baa ema nia.’ ");
INSERT INTO tet_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Naꞌi Maromak nakara nunia, mais emi hanorin seluk. Emi haꞌak, lalika tulun ina-ama. Lalika foo naha baa sia, surak katak baa sia haꞌak naha mak o atu foo baa sia, o mameno tiꞌan atu sera baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tebes. Hodi nunia, emi taliꞌur Naꞌi Maromak Manfatin, hotu selu hodi emikaan hanorin duꞌuk. Emi halo oin nunia, dala waꞌin tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hotu, Yesus bolu nola ema seluk mak iha nia nodi naꞌak, “Rona, nebee emi hatene diꞌa-diꞌak lia neꞌe! ");
INSERT INTO tet_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Saa mak tama baa ema kabun laran, la nalo ema kadoor. Mais, saa mak sai nosi ema neon laran, mak nalo kadoor. ");
INSERT INTO tet_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","See mak no tilun, rona diꞌa-diꞌak!” ");
INSERT INTO tet_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hotu, Yesus no Niakaan maktuir sia laꞌo nela ema nia sia, tama baa uma ida. Iha nia, maktuir sia nusu lia hatetek nia isin. ");
INSERT INTO tet_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Hotu, Yesus nataa naꞌak, “Emi sei la hatene dauk ka? Lia isin nuneꞌe: saa mak ema naa, la nalo kadoor. Mais, saa mak sai nosi ema neon laran, mak nalo kadoor. Tebes. Saa mak ita haa, tama kabun hotu sai nikar. (Hodi lia nia, Yesus nanorin seluk nosi ema Farisi sia. Tan Nia nanorin naꞌak, ema raiklaran bele naa sa-saa dei. La noo mak luli.) ");
INSERT INTO tet_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Saa mak sai nosi ema neon laran, mak nalo ema kadoor, toꞌo Naꞌi Maromak moos nakribi, hotu la noꞌuk namutuk no nia ona. ");
INSERT INTO tet_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Noo lia aat waꞌin mak sai nosi ema neon laran nuꞌu lia aat, lia sala kfoꞌer, lia hanaꞌo, lia hoꞌo ema, ");
INSERT INTO tet_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lia rotus, lia hakur biti-kluni, lia hahalok aat, lia bosok teen, lia nawan aat, lia tinu aat, lia dale hahaat ema, lia loko aan, lia notar lalek, no lia ulun fatuk. ");
INSERT INTO tet_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lia aat nia sia hotu-hotu sai nosi ema neon laran. Lia nia sia mak nalo ema kadoor, toꞌo Naꞌi Maromak moos nakribi.” ");
INSERT INTO tet_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hotu, Yesus sia laꞌo nela fatin nia, baa leo ida naran Tirus. Toꞌo baa, sia tama lai-lais baa uma ida, tan Yesus la noꞌuk ema natene Nia mai tiꞌan. Mais Nia la bele nakfunin. ");
INSERT INTO tet_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Iha leo nia noo ferik ida. Ferik nia lahoos ema Yahudi. Nia ema maktabar mak moris mai iha Fenisia, iha rai Siria baa. Oras rona Yesus mai, nia baa nakroꞌan nebee Yesus teꞌur nasai diabu nosi niakaan oan feto. ");
INSERT INTO tet_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mais Yesus nataa nodi soe lia naꞌak, “Lawarik sia musti naa uluk lai, foin bele foo hahaak resin baa asu.” Lia isin naꞌak, Yesus musti tulun uluk niakaan ema Yahudi sia lai, foin bele tulun ema seluk. ");
INSERT INTO tet_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mais ferik nia nataa naꞌak, “Tebes, Ama! Mais asu nia iha hadak ohak. Nia moos bele naa haan mumun mak monu nosi lawarik siakaan bikan.” Lia isin naꞌak, baa oras lawarik sia naa, asu moos bele naa. Masik Yesus tulun niakaan ema, Nia moos musti tulun ema seluk. ");
INSERT INTO tet_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Rona nola nunia, Yesus nataa naꞌak: “Kona! Ina dale nia tebes! Tan nunia, diabu nia sai tiꞌan nosi ina oan! Ina bele fila ona.” ");
INSERT INTO tet_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Rona nola nunia, ferik nia moos fila. Toꞌo uma baa, naree oan toba dukur, tan diabu sai nela nia tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hotu, Yesus sia laꞌo nela leo Tirus, tuir tasi tehen toꞌo leo Sidon. Hotu, sia laꞌo liu toꞌo nikar debu boot Galilea baa. Hotu, sia laꞌo liu toꞌo rai ida no leo sanulu, naran ‘Dekapolis’. ");
INSERT INTO tet_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iha rai nia, noo ema ida mak diuk no la bele dale. Niakaan mamaluk sia nodi nia baa Yesus hotu nakroꞌan naꞌak, “Ama! Tulun ami lai! Ami husu Ama rai liman baa, hodi hadiꞌak hola ema neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Rona nola nunia, Yesus nodi ema nia mesan baa fatin ida, laꞌo nela ema waꞌin nia sia. Hotu, Yesus natama liman fuan baa ema nia tilun karuk-kwana. Nia moos nola kaban, tau baa ema nia nanaan. ");
INSERT INTO tet_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hotu, Nia tanaat baa laleꞌan, nola nawan, hotu naruka naꞌak, “Efata!” (Lia fuan neꞌe naꞌak, “Makloke ona!”) ");
INSERT INTO tet_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yesus naruka loos nunia dei, ema nia rona kedas. Nanaan makaꞌas nia, moos mamar kedas, toꞌo nia bele dale diꞌak. ");
INSERT INTO tet_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hotu, Yesus no ema nia fila nikar baa ema waꞌin nia. Mais Yesus nakahik sia naꞌak, “Rona lai! Keta katak baa ema seluk haꞌak Haꞌu mak kadiꞌak kola ema neꞌe!” Masik Yesus nakahik moos, sia katak luku lia nia keke lema rai. ");
INSERT INTO tet_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ema mak rona lia nia, blaar tebes. Sia tonun Yesus naꞌak, “Tebes! Ema neꞌe nalo hotu-hotu dadi diꞌak! Ema diuk, bele rona! Ema mak la bele dale moos, bele dale!” ");
INSERT INTO tet_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Baa oras nia, ema waꞌin mai atu rona Yesus nanorin. Sia tuir Yesus loron tolu, toꞌo la noo bakae ona. Naree nunia, Yesus bolu Niakaan maktuir sia naꞌak, “Haꞌu kadomi ema waꞌin neꞌe sia. Balu mai nosi fatin dook, libur malu loron tolu tiꞌan, toꞌo la no bakae ona. Diꞌak liu, sia keta fila kabun mamuk. Keta toꞌo siakaan oin nakukun, hotu nakloti iha dalan klaran.” ");
INSERT INTO tet_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mais maktuir sia nataa naꞌak, “Ama! Fatin neꞌe dook nosi leo. Ami la bele hahaan hola ema waꞌin neꞌe!” ");
INSERT INTO tet_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mais Yesus nusu baa sia naꞌak, “Emi hoo tubi baluk hira iha nia?” Sia nataa naꞌak, “Baluk hitu dei!” ");
INSERT INTO tet_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hotu, Yesus naruka ema lear nia tuur baa rai. Nia nola tubi baluk hitu nia, nusu matak-malirin baa Naꞌi Maromak. Hotu, Yesus faꞌe tubi nia foo baa maktuir sia, nebee faꞌe nadaar baa ema lear nia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iha nia moos, noo naꞌan tasi lolon hira. Yesus moos nusu matak-malirin baa Naꞌi Maromak, hotu naruka Niakaan maktuir sia faꞌe nadaar tenik baa ema lear nia. ");
INSERT INTO tet_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Sura ema hotu-hotu mak naa nia, bele tama rihun haat. Sia hotu-hotu naa toꞌo bosu. Hotu tiꞌan, Yesus Niakaan maktuir sia libur nola haan resin sia, nakonu nola koꞌe boot hitu. Hotu, Yesus naruka fila ema nia sia. ");
INSERT INTO tet_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nunia tiꞌan, Yesus no Niakaan maktuir sia saꞌe bero atu baa fatin ida naran Dalmanuta. ");
INSERT INTO tet_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yesus sia toꞌo Dalmanuta tiꞌan, ema partee Farisi naꞌin hira mai nasoru Nia. Sia taruka lia fuan no Yesus, tan atu kohi Nia. Sia nusu naꞌak, “Ama! Matudu tadak blaar baa ami lai, nebee dadi kakaer naꞌak Naꞌi Maromak mak latan beran baa Ama.” ");
INSERT INTO tet_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mais Yesus nola nawan hotu katak baa sia naꞌak, “Kalo Haꞌu krona emi dale nunia, Haꞌu laran moras! Tan saa ema oras neꞌe nusu tadak blaar? Keta nunia! Haꞌu nanis bele kalo, mais Haꞌu la katudu baa emi!” ");
INSERT INTO tet_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hotu, Yesus laꞌo nela ema Farisi sia, saꞌe nikar bero no Niakaan maktuir sia, nakur baa debu boot balu baa. ");
INSERT INTO tet_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Toꞌo debu klaran, foin Yesus Niakaan maktuir sia nanoin nola naꞌak, sia naluꞌa bakae. Sia nodi loos tubi baluk ida dei. ");
INSERT INTO tet_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Rona nola sia temi tubi, Yesus katak naꞌak, “Musti sintidu baa naꞌi Herodes no ema Farisi sia, tan siakaan hahalok hanesan tua teen tubi.” ");
INSERT INTO tet_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Rona nola Yesus temi tua teen tubi, maktuir sia moos neon tabasar. Sia nusu baa malu naꞌak, “Itakaan Ama dale saa mak nia? Keta arumak Nia dale nunia tan ita la hodi tubi.” ");
INSERT INTO tet_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mais Yesus natene siakaan neon. Hotu, Nia nusu naꞌak, “Tan saa emi hanoin baa tubi dei? Tan saa emi sei la hatene Haꞌukaan lia isin? Emikaan kakutak naktomak tebes! ");
INSERT INTO tet_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Emi haree duꞌuk tiꞌan, mais emi sei nuꞌu ema delek. Emi rona duꞌuk tiꞌan, mais emi sei nuꞌu ema diuk. ");
INSERT INTO tet_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tubi baluk lima mak Haꞌu ktohi faꞌe kodi kahaan ema rihun lima nia, emi haluꞌa tiꞌan ka? Baa oras nia, emi libur hola tubi resin sia, nakonu koꞌe hira?” Sia nataa naꞌak, “Koꞌe sanulu resin rua Ama!” ");
INSERT INTO tet_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hotu, Yesus nusu tenik naꞌak “Tubi mak Haꞌu ktohi faꞌe kodi kahaan ema rihun haat nia, emi haluꞌa tiꞌan ka? Baa oras nia, emi libur hola tubi resin sia nakonu koꞌe boot hira?” Sia nataa naꞌak, “Koꞌe hitu Ama!” ");
INSERT INTO tet_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Rona nola nunia, Yesus naꞌak, “Loos tebes! Emi haree duꞌuk tiꞌan, mais tan saa emi sei la hatene dauk See mak latan beran nia baa Haꞌu?” ");
INSERT INTO tet_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hotu, Yesus sia toꞌo leo Betsaida. Iha nia noo ema delek ida. Ema nodi nia mai baa Yesus. Sia nakroꞌan nebee Yesus koko ema nia nodi nadiꞌak nola nia. ");
INSERT INTO tet_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Rona nola nunia, Yesus kaer ema delek nia liman, nalaꞌo nodi baa kota luan. Toꞌo baa, Nia taniru kaban baa ema delek nia matan, hotu rai liman baa, nodi nusu naꞌak, “Nunabee? O maree tiꞌan ka sei?” ");
INSERT INTO tet_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hotu, ema nia foti oin, nodi titu karuk-kwana. Hotu, nia nataa naꞌak, “Tebes! Haꞌu kbele karee. Haꞌu karee ema sia laꞌo baa-mai, mais nuꞌu ai huun mak laꞌo!” ");
INSERT INTO tet_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tan ema nia titu sei ba-baur, Yesus rai tenik liman baa matan. Hotu, ema nia loke tenik matan, naree malorek tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hotu, Yesus naruka nia fila nodi foo natene naꞌak, “Fila ona! Mais keta fila mikar baa Betsaida!” ");
INSERT INTO tet_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hotu, Yesus no Niakaan maktuir sia laꞌo nasirin leo iha rai Kaisarea Filipi. Toꞌo dalan klaran, Yesus nusu baa sia naꞌak, “Tuir ema dalen, Haꞌu neꞌe See?” ");
INSERT INTO tet_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sia nataa naꞌak, “Ema balu naꞌak, Ita Boot neꞌe Yohanis Mak Sarani Ema. Seluk naꞌak, Ita Boot neꞌe Elia mak Maromak makoꞌan uluk. Balu tenik naꞌak, Maromak makoꞌan ida seluk.” ");
INSERT INTO tet_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Rona nunia, Yesus nusu tenik naꞌak, “Mais kalo tuir emi duꞌuk, Haꞌu neꞌe See?” Petrus nataa naꞌak, “Ita Boot neꞌe Kristus mak Naꞌi Maromak boi kedan hori uluk!” ");
INSERT INTO tet_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Rona nola nunia, Yesus nakahik sia naꞌak, “Keta katak lia neꞌe baa ema!” ");
INSERT INTO tet_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nahuu nosi oras nia, Yesus katak baa Niakaan maktuir sia naꞌak, “Haꞌu neꞌe, Ema Raiklaran Isin. Haꞌu atu katiu susar oi-oik, tan fukun sia, naꞌilulik sia, no manorik ukun sia, hotu-hotu la simu Haꞌu. Sia nanis noꞌo Haꞌu. Mais toꞌo wainrua, nanis Haꞌu kmoris kikar.” ");
INSERT INTO tet_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Rona nola nunia, Petrus dada nola Yesus baa sorin, hotu nakahik naꞌak, “Ita Boot keta katak nunia! Haꞌu la ksimu!” ");
INSERT INTO tet_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mais Petrus dale nia la kona baa Naꞌi Maromak hakaran. Yesus titu fila baa maktuir rumak sia. Hotu, Nia deꞌan Petrus naꞌak, “Okaan dale nia, diabu ulun lian. Sai mosi neꞌe! O manoin loos ema raiklaran hakaran, la manoin Naꞌi Maromak hakaran!” ");
INSERT INTO tet_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hotu, Yesus bolu nola ema waꞌin mai namutuk no Niakaan maktuir sia. Nia nanorin sia naꞌak, “Ema mak noꞌuk tuir Haꞌu, musti naterus aan bei-beik sura loron. Nia musti naluꞌa lakon niakaan hakara duꞌuk, nebee tuir Naꞌi Maromak hakaran. Masik ema atu noꞌo nia moos, nia musti tuir bei-beik, hanesan ema mak natiu ai karuus atu baa mate. ");
INSERT INTO tet_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ema mak moris bodik isin lolon duꞌuk, niakaan moris atu lakon mohu. Mais ema mak nadiꞌa aan mate, tan nakara tuir Haꞌu no katak Haꞌukaan Manfatin Diꞌak, ema nia netan moris nima-nimak no Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Rona mai! Kalo ema netan raiklaran sasoin tomak, mais Naꞌi Maromak soe nia, nia netan sotir saa? ");
INSERT INTO tet_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","La noo saa ida iha raiklaran tomak, mak ema bele nodi selu niakaan kmalar! ");
INSERT INTO tet_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ema raiklaran oras neꞌe, siakaan hahalok aat oi-oik! Sia la nikir Naꞌi Maromak. Mais hanoin diꞌa-diꞌak! Ema mak moe tuir Haꞌu no Haꞌukaan hanorin, Haꞌu moos moe katene nia iha Naꞌi Maromak oin. Haꞌu neꞌe, Ema Raiklaran Isin. Nosi ikus, Haꞌu kmai kikar kosi laleꞌan bele-bele ko Naꞌi Maromak Niakaan makbukar laleꞌan sia. Ami tuun hodi Ama Niakaan beran boot, foin ema natene malorek naꞌak, Haꞌu neꞌe See. ");
INSERT INTO tet_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Nosi emi hotu-hotu neꞌe, balu la mate toꞌo naree Naꞌi Maromak kaer ukun nodi beran boot kaliuk.” ");
INSERT INTO tet_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Loron neen siku tiꞌan, Yesus no Petrus, Yakobus no Yohanis saꞌe baa foho aas ida mak la noo ema. Toꞌo baa, maktuir naꞌin tolu nia sarebak, tan sia naree Yesus nakfilas. ");
INSERT INTO tet_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Niakaan faru moos naksinak. Iha raiklaran tomak la no saa ida mak mutin liu faru nia. ");
INSERT INTO tet_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Teki-tekis, sia moos naree Yesus dale no Bei Elia no Bei Musa, mak Maromak makoꞌan uluk sia. ");
INSERT INTO tet_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Maktuir naꞌin tolu nia nataꞌuk tebe-tebes. Neon moos tabasar toꞌo Petrus dale karin baa Yesus naꞌak, “Ama! Ita iha neꞌe, furak tiꞌan. Diꞌak liu ami hariik batane tolu: ida bodik Ita Boot, ida bodik Bei Elia, no ida tenik bodik Bei Musa.” ");
INSERT INTO tet_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Teki-tekis, ababun tuun taka nola sia hotu. Sia rona lia maliak ida mai nosi ababun laran naꞌak, “Rona mai! Neꞌe, Haꞌukaan Oan mak Haꞌu kadomi! Rona diꞌa-diꞌak baa Nia!” ");
INSERT INTO tet_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Rona tiꞌan lia maliak nia, Petrus sia titu baa-mai. Mais sia la naree ema seluk, hela mesan Yesus. ");
INSERT INTO tet_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hotu, Yesus sia tuun nikar nosi foho nia. Oras laꞌo, Yesus nakahik maktuir sia naꞌak, “Saa mak emi foin haree ohin nia, keta katak baa ema. Haꞌu neꞌe, Ema Raiklaran Isin. Nanis Haꞌu kmate. Mais kalo Haꞌu kmoris kikar tiꞌan, foin emi bele katak hasai lia mak emi haree tiꞌan nia baa ema.” ");
INSERT INTO tet_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rona nola nunia, sia rai Yesus mamenon nia. Mais sia nakusuk baa malu naꞌak, “Nia katak naꞌak Nia nanis mate, hotu moris nikar. Lia saa mak oin nunia?” ");
INSERT INTO tet_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sia moos nusu baa Yesus naꞌak, “Tuir manorik ukun siakaan hanorin, Maromak makoꞌan Elia musti mai uluk lai, foin Kristus mai. Mais tuir Ita Boot hanorin, nunabee?” ");
INSERT INTO tet_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus nataa naꞌak, “Tebes! Elia musti mai uluk atu nasori dalan bodik Kristus. Maromak makoꞌan sia moos nakerek kedan hori uluk nosi lia Ema Raiklaran Isin naꞌak, ema atu nasusar toꞌo noꞌo Nia. Tan saa emi sei la hatene lia neꞌe? ");
INSERT INTO tet_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Rona diꞌa-diꞌak! Elia nia mai tiꞌan. Mais ema noꞌo nia, tuir siakaan hakara. Hodi nunia, sia natoꞌo saa mak makoꞌan sia nakerek nela tiꞌan.” Hodi katak nunia, Yesus nalore naꞌak makoꞌan Elia mak nasori dalan bodik Kristus, nia mak Yohanis. ");
INSERT INTO tet_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus no Niakaan maktuir naꞌin tolu nia mai nikar tiꞌan nosi foho nia, sia naree ema waꞌin naklibur nodi nobun Yesus Niakaan maktuir rumak sia. Sia noꞌi toe malu no manorik ukun Yahudi sia. ");
INSERT INTO tet_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Oras sia naree Yesus mai, sia sarebak, tan sia naꞌak falik Yesus sei iha foho leten baa. Hotu, sia nalai baa nasoru Nia. ");
INSERT INTO tet_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus moos nusu baa sia naꞌak, “Emi toe malu baa saa?” ");
INSERT INTO tet_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mais ema ida mai nusu teri baa Yesus naꞌak, “Ama! Tulun lai! Haꞌu kodi haꞌukaan oan mane mai, nebee Ama nadiꞌak nola nia. Haꞌukaan oan neꞌe la bele dale, tan diabu tekar. ");
INSERT INTO tet_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Oras diabu tekar, nia nitak lawarik neꞌe baa rai. Hotu, kaban furin sai no ruun neꞌan. Isin moos makaꞌas nuꞌu ai. Haꞌu kakroꞌan tiꞌan baa Okaan maktuir sia nebee teꞌur sai diabu nia. Mais sia la bele nalo saa ida.” ");
INSERT INTO tet_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Rona nola nunia, Yesus deꞌan Niakaan maktuir sia naꞌak, “Emi neꞌe, liu resik tiꞌan! Haꞌu kamutuk ko emi kleur tiꞌan, mais emi la fiar Haꞌu! Haꞌu kmusti katerus aan ko emi toꞌo wainhira? Modi lawarik nia mai!” ");
INSERT INTO tet_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hotu, sia nakaꞌu nodi lawarik nia mai. Mais oras diabu naree Yesus, nia nitak tenik lawarik nia baa rai nodi naduir baa-mai toꞌo kaban furin sai. ");
INSERT INTO tet_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Naree nunia, Yesus nusu baa lawarik nia aman naꞌak, “O oan dadi nuneꞌe hori hirak tiꞌan?” Ama nia nataa naꞌak, “Hori sei kiꞌik. ");
INSERT INTO tet_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kleur tiꞌan, diabu beer noꞌo lawarik neꞌe. Naloti lawarik baa haꞌi, no namout baa wee. Kalo bele, Ita Boot tulun no hadomi ami. Hadiꞌak hola lawarik neꞌe lai.” ");
INSERT INTO tet_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Hotu Yesus nataa naꞌak, “Tan saa o katak maꞌak, ‘kalo bele’? Haꞌu kbele kalo sa-saa hotu-hotu, surak ema fiar tebe-tebes.” ");
INSERT INTO tet_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Rona nola nunia, ama nia nataa nodi tanis naꞌak, “Ama! Haꞌu kfiar tebe-tebes. Mais tulun haꞌu, nebee haꞌukaan fiar neꞌe, bele hetak biit.” ");
INSERT INTO tet_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Baa oras nia, ema waꞌin mai kabuun nola Yesus. Naree nunia, Yesus moos naruka diabu nia naꞌak, “Hoi diabu aat! Sai mela lawarik neꞌe, nebee nia bele rona no bele dale. Keta tama mikar tenik baa nia ona.” ");
INSERT INTO tet_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Rona Yesus dale nunia, diabu nia nahii makaꞌas nodi naloti lawarik nia baa rai, toꞌo nasaꞌe horak, foin sai nela. Hotu, lawarik mate sala, toꞌo ema nia sia dale naꞌak, “Adeei! Lawarik neꞌe mate tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mais Yesus kaer nola lawarik nia liman, nodi foti nadeer. Lawarik nia moos nadeer kedas. ");
INSERT INTO tet_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nunia hotu, Yesus no Niakaan maktuir sia laꞌo nela fatin nia, tama baa uma ida. Iha nia, maktuir sia no Yesus mesan, hotu sia nusu Yesus naꞌak, “Ama! Tan saa ami la bele teꞌur sai diabu ohin nia?” ");
INSERT INTO tet_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus moos katak nalore baa sia naꞌak, “Diabu oin nunia, aat basuk! Emi musti hamulak hodi haloon baa Naꞌi Maromak, foin bele teꞌur sai diabu oin nunia.” ");
INSERT INTO tet_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hotu, Yesus no Niakaan maktuir sia laꞌo nela fatin nia, tama baa rai Galilea. Sia toꞌo tiꞌan, mais Yesus la noꞌuk ema natene naꞌak Nia iha nia, ");
INSERT INTO tet_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tan Nia nakara nanorin Niakaan maktuir sia mesan. Hotu, Nia katak baa Niakaan maktuir sia naꞌak, “La kleur ona, ema atu faꞌan Haꞌu baa ema seluk. Hotu, sia noꞌo Haꞌu, Ema Raiklaran Isin neꞌe. Nanis Haꞌu kmate, mais wainrua, Haꞌu kmoris kikar.” ");
INSERT INTO tet_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Rona nola nunia, maktuir sia neon tabasar. Mais sia nakerat nusu tenik lia nia isin. ");
INSERT INTO tet_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hotu, Yesus no Niakaan maktuir sia laꞌo toꞌo Kapernaum. Baa oras sia iha uma ida laran, Yesus nusu sia naꞌak, “Ohin nia emi toe malu baa saa?” ");
INSERT INTO tet_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mais la noo maktuir ida mak nataa. Tan tebes! Ohin nia sia toe malu iha dalan klaran baa lia see mak boot. ");
INSERT INTO tet_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hotu, Yesus tuur nodi nanorin sia naꞌak, “See mak nakara dadi ema boot, nia musti dadi ema kiꞌik nodi naliku ema seluk.” ");
INSERT INTO tet_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hotu, Yesus baa nakaꞌu nola lawarik oan ida, nodi mai baa siakaan klaran. Hotu, katak naꞌak, ");
INSERT INTO tet_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ema mak tuir Haꞌu musti naliku ema kiꞌik nudaar lawarik oan neꞌe. Hodi nunia, nia naliku Haꞌu no Haꞌukaan Ama mak solok Haꞌu kmai raiklaran neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hotu, Yesus Niakaan maktuir naꞌin ida naran Yohanis nasaꞌe lia naꞌak, “Ama! Loron ida, ami haree ema ida teꞌur sai diabu nodi Ita Boot naran. Mais ami hakahik nia, tan nia lahoos itakaan ema.” ");
INSERT INTO tet_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Rona nola nunia, Yesus nataa naꞌak, “Keta makahik nia. Tan, see mak nalo tadak blaar nodi Haꞌukaan naran, nia la nahaat Haꞌukaan naran. ");
INSERT INTO tet_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kalo nia la sakar ita, nia nanis itakaan ema. ");
INSERT INTO tet_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Kalo ema naliku emi tan emi tuir Kristus, nanis Naꞌi Maromak la naluꞌa ema nia. Masik nia tulun emi nodi wee hemu fatik ida dei moos, Naꞌi Maromak la naluꞌa nia.” ");
INSERT INTO tet_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Hotu, Yesus katak tenik baa sia naꞌak, “Kalo ema sasuꞌat ema kiꞌik ida tuir dalan kaleꞌuk toꞌo ema kiꞌik nia la fiar tenik baa Haꞌu, ema nia, sintidu! Diꞌak liu kesi fatuk boot ida baa niakaan kakorok, hotu tonan mout baa tasi laran. ");
INSERT INTO tet_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kalo o malo sala modi o liman, taa kotu baa dei! Diꞌak liu o tama laleꞌan modi liman mesak, nosi baa o tama haꞌi naraka modi liman rua. ");
INSERT INTO tet_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Haꞌi naraka neꞌe, fatin susar basuk. Iha nia, kniba tota bei-beik. Haꞌi moos laka la nanawa. ");
INSERT INTO tet_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kalo o malo sala modi o ain, taa kotu baa dei. Diꞌak liu, o tama laleꞌan modi ain mesak, nosi baa o tama haꞌi naraka modi ain rua. ");
INSERT INTO tet_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Haꞌi naraka neꞌe, fatin susar basuk. Iha nia, kniba tota bei-beik. Haꞌi moos laka la nanawa. ");
INSERT INTO tet_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kalo o malo sala modi o matan, sukit soe baa dei. Diꞌak liu, o tama laleꞌan modi matan mesak, nosi baa o tama haꞌi naraka modi matan rua. ");
INSERT INTO tet_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Haꞌi naraka neꞌe, fatin susar basuk. Iha nia, kniba tota bei-beik. Haꞌi moos laka la nanawa.’ ");
INSERT INTO tet_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Haꞌukaan hanorin neꞌe, todan tebes. Tan ema mak nakara tuir Haꞌu, musti naterus aan tuir bei-beik, hanesan naꞌan hameer mak tamun baa haꞌi, nebee bele rai kleur. ");
INSERT INTO tet_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masin nanis diꞌak. Ita hodi hamidar haan. Mais kalo masin nia la meer ona, la no folin tiꞌan. Nunia moos emi. Emi musti dadi hanesan masin bodik raiklaran, nebee emi bele moris diꞌa-diꞌak ho ema hotu-hotu.” Hodi nunia, Yesus nanorin baa Niakaan maktuir sia naꞌak, keta toe malu baa lia see mak boot, see mak kiꞌik. ");
INSERT INTO tet_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hotu, Yesus no Niakaan maktuir sia baa rai Yudea no rai seluk sia iha mota Yordan lorosaꞌe. Iha nia ema waꞌin moos mai baa Yesus. Hotu, Nia nanorin sia nuꞌu wai-wain. ");
INSERT INTO tet_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Iha nia moos, noo ema Farisi naꞌin hira. Sia mai atu talik nahonu Yesus. Sia nusu baa Nia naꞌak, “Tuir itakaan ukun-badu, kalo mane ida no feen tiꞌan, nia bele soe feen ka lale?” ");
INSERT INTO tet_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Rona nola nunia, Yesus nataa naꞌak, “Hanoin diꞌa-diꞌak lai! Ukun-badu feen-laꞌen mak Bei Musa rai nela baa ita naꞌak saa?” ");
INSERT INTO tet_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sia nataa naꞌak, “Bei Musa ukun-badu nia naꞌak, ‘Laꞌen bele soe feen, surak foo uluk hakerek soe malu baa feen.’ ” ");
INSERT INTO tet_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus moos nataa nikar naꞌak, “Tan emi ulun fatuk, foin bei Musa nakerek nela tiꞌan nunia. ");
INSERT INTO tet_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mais keta haluꞌa lia hori uluk fohon, baa oras Naꞌi Maromak naseꞌi laleꞌan no raiklaran. Lia nia naꞌak, ‘Naꞌi Maromak naseꞌi ema, feto no mane. ");
INSERT INTO tet_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tan lia nia, mane musti laꞌo nela inan-aman atu moris neon ida, laran ida no feen, ");
INSERT INTO tet_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tan sia rua dadi mesak tiꞌan.’ ");
INSERT INTO tet_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Naꞌi Maromak duꞌuk mak kesi namutuk sia rua tiꞌan. Ema la bele sasa faꞌe ona!” ");
INSERT INTO tet_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nunia hotu, Yesus no Niakaan maktuir sia mesan tama baa uma ida. Iha nia maktuir sia nusu nebee Yesus katak nalore hanorin ohin nia baa sia. ");
INSERT INTO tet_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nia katak naꞌak, “Mane mak soe feen, hotu nola tenik feto, mane nia nakur biti-kluni. ");
INSERT INTO tet_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Feto moos nunia! Feto mak soe laꞌen, hotu nola tenik mane, feto nia moos nakur biti-kluni.” ");
INSERT INTO tet_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Baa loron ida, ema nodi siakaan oan sia baa Yesus. Sia nusu Yesus rai liman baa lawarik sia, nebee simu matak-malirin. Mais Yesus Niakaan maktuir sia saseni ema nia sia. ");
INSERT INTO tet_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Naree nunia, Yesus krakat baa maktuir sia naꞌak, “Habusik lawarik sia mai baa Haꞌu! Keta saseni sia! Tan ema oin nunia sia, mak Naꞌi Maromak eman. ");
INSERT INTO tet_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Ema mak nakara dadi baa Naꞌi Maromak eman, nia musti nakriꞌit aan baa Naꞌi Maromak hanesan lawarik oan nakriꞌit aan baa inan-aman. Kalo lale, ema nia la fatan dadi baa Naꞌi Maromak eman.” ");
INSERT INTO tet_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hotu, Yesus nakoꞌak nola lawarik nia sia. Nia rai liman baa sia ida-idak, nodi foo matak-malirin baa sia. ");
INSERT INTO tet_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Baa oras Yesus sia atu laꞌo, ema maksoin ida nalai mai nasoru sia. Nia nakniꞌa baa Yesus nodi nusu naꞌak, “Ama Boot! Ama Boot neꞌe, ema diꞌak. Tan baa nia, haꞌu kusu Ama nanorin lia ida baa haꞌu. Lia nia nuneꞌe, Ama Boot. Haꞌu kmusti kalo saa, nebee katene malorek kaꞌak haꞌu kbele tama laleꞌan atu moris kamutuk ko Naꞌi Maromak?” ");
INSERT INTO tet_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus moos nataa naꞌak, “Tan saa o temi Haꞌu maꞌak ema diꞌak? La no ema ida mak diꞌak. Naꞌi Maromak mesan dei mak diꞌak. ");
INSERT INTO tet_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O matene tiꞌan Naꞌi Maromak ukun naꞌak: ‘Keta hoꞌo ema; Keta hakur biti-kluni; Keta hanaꞌo; Keta hataa hodi lia tolek; Keta beꞌur ema hodi hola siakaan sa-saa; No ita musti hakneter itakaan inan-aman.’ ” ");
INSERT INTO tet_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hotu, ema nia nataa naꞌak, “Tebes, Ama Boot! Haꞌu kalo tuir tiꞌan ukun nia sia hotu-hotu hori sei kiꞌik.” ");
INSERT INTO tet_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Rona nola nunia, Yesus nadomi ema nia. Nia katak naꞌak, “Kona! Mais sei no lia ida tenik. O musti fila, baa faꞌan mohu okaan sasoin sia. Hotu, faꞌe osan nia baa ema kiꞌik no ema susar sia, foin fila mikar mai tuir Haꞌu. Nosi ikus, Naꞌi Maromak nanis foo seluk sasoin baa o iha laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Rona nola Yesus dale nunia, ema nia neon dodok. Hotu, nia fila nodi neon susar loos, tan nia soi toꞌo. ");
INSERT INTO tet_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hotu, Yesus titu Niakaan maktuir sia baa-mai nodi katak naꞌak, “Rona! Kalo maksoin ida nakara tama baa laleꞌan atu dadi Naꞌi Maromak eman, lia nia kole basuk.” ");
INSERT INTO tet_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Rona nola nunia, maktuir sia moos benar. Mais, Yesus katak nalore tenik naꞌak, “Rona diꞌa-diꞌak! Dadi Naꞌi Maromak eman, kole basuk! Keta hanoin haꞌak lia nia maus! ");
INSERT INTO tet_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lia hatetek nudaar kuda unta ida kole basuk tama lalutuk tuir daun kuak. Kole liu tenik, maksoin ida tama baa laleꞌan dadi Naꞌi Maromak eman.” ");
INSERT INTO tet_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lia hatetek nia nalo maktuir sia hetak benar. Hotu, sia nusu tenik naꞌak, “Kalo kole basuk nunia, see mak bele netan moris?” ");
INSERT INTO tet_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus titu baa sia ida-idak nodi katak naꞌak, “Kalo ema raiklaran mak nalo, nanis la bele. Mais, kalo Naꞌi Maromak mak nalo, nanis hotu-hotu bele!” ");
INSERT INTO tet_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hotu, Petrus foti lia naꞌak, “Ama! Ami laꞌo hela tiꞌan amikaan sasoin sia hotu-hotu atu tuir Ita Boot. Mais, ami hetan saa?” ");
INSERT INTO tet_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus nataa naꞌak, “Rona mai Petrus! Haꞌukaan dalen neꞌe, tebes no loos! Kalo ema ida laꞌo nela niakaan inan-aman, maun-biin-alin, niakaan oan, niakaan toꞌos, niakaan serwisu, niakaan uma laran isin hotu-hotu, tan tuir Haꞌu nodi keke lema Naꞌi Maromak Manfatin Diꞌak, ema nia nanis simu nikar isin atus ida. Hotu-hotu mak nia laꞌo nela nia, nia simu nikar liu tan tenik. Ema nanis nasusar nia, tan tuir Haꞌu. Mais, baa oras rai falu fila, nia netan moris nima-nimak no Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hanoin diꞌa-diꞌak! Ema mak naksaꞌek aan dadi ema boot, nosi ikus Naꞌi Maromak nafoli nia naꞌak, ema kiꞌik. Ema mak naraik aan hanesan ema kiꞌik, nosi ikus Naꞌi Maromak nafoli nia naꞌak, ema boot.” ");
INSERT INTO tet_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hotu, Yesus no Niakaan maktuir ema naꞌin sanulu resin rua no ema seluk sia baa kota Yerusalem. Yesus laꞌo nosi oin. Naree nunia, Niakaan maktuir sia benar no nataꞌuk, tan nanoin nola lia mak uluk Yesus katak naꞌak, ema atu noꞌo Nia iha Yerusalem. Yesus natene nola sia nataꞌuk nunia, Nia bolu nola maktuir sia mesan, hotu Nia katak nalore lia saa mak ema atu nalo baa Nia iha Yerusalem. ");
INSERT INTO tet_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nia katak naꞌak, “Rona! Oras neꞌe, ita baa Yerusalem ona! Iha nia ema atu faꞌan Haꞌu, mak Ema Raiklaran Isin neꞌe. Hotu, sia latan Haꞌu baa naꞌilulik ulun sia no manorik ukun sia. Hotu, sia taa ukun mate baa Haꞌu. Sia moos latan Haꞌu baa ema seluk sia mak la natene Maromak. ");
INSERT INTO tet_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hotu, sia dale namoe Haꞌu, soe kaban baa Haꞌu, no noꞌat nadodok Haꞌukaan isin. Hotu, sia noꞌo Haꞌu. Haꞌu nanis mate. Mais baa wainrua, Haꞌu kmoris kikar.” ");
INSERT INTO tet_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yesus dale notu nunia, Sebadeus oan Yakobus no Yohanis nareꞌis aan baa Yesus, hotu nusu naꞌak, “Ama Boot! Ami atu husu oan ida.” ");
INSERT INTO tet_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus moos nusu sia naꞌak, “Emi hakara saa?” ");
INSERT INTO tet_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sia nataa naꞌak, “Nuneꞌe Ama Boot! Nosi ikus, kalo Ama Boot nabesi aan tiꞌan nodi kaer ukun, ami haloon nebee Ama bele foo fatik bodik ami rua neꞌe. Ida iha Ama sorin kwana, ida tenik iha sorin karuk, nebee ami rua moos bele tuir kaer ukun.” ");
INSERT INTO tet_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Rona nola nunia, Yesus nataa naꞌak, “Emi la hatene saa mak emi husu! Haꞌu atu ketan susar waꞌin. Dadi, hanoin diꞌa-diꞌak lai. Emi bele terus susar toꞌo mate hamutuk ho Haꞌu ka lale?” ");
INSERT INTO tet_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sia moos nataa naꞌak, “Bele basuk Ama!” Hotu, Yesus nataa tenik naꞌak, “Tebes! La kleur ona, emi moos atu hatiu susar hanesan Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mais, see mak tuur iha Haꞌukaan sorin kwana no karuk, lia nia lahoos Haꞌu mak kakotu. Naꞌi Maromak duꞌuk mak nakotu tiꞌan se-see mak tuur iha fatik nia.” ");
INSERT INTO tet_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baa oras Yesus Niakaan maktuir sanulu rumak sia rona nola Yakobus no Yohanis nusu nunia, sia moos krakat. ");
INSERT INTO tet_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hotu, Yesus bolu nola maktuir sia hotu-hotu, nodi katak nalore naꞌak, “Emi hatene tiꞌan haꞌak, liurai mak kaer ukun iha raiklaran, sia tonan siakaan renun, toꞌo la nakfodak. Ema boot nosi klubun mak la natene Naꞌi Maromak moos, foo ukun liu kladik, toꞌo renu la bele foti ulun. ");
INSERT INTO tet_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mais, emi la bele halo nunia! Tan see mak nakara dadi ema boot, nia musti dadi ema kiꞌik nodi naliku ema seluk. ");
INSERT INTO tet_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","See mak nakara dadi ulun, nia musti dadi ata. ");
INSERT INTO tet_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Haꞌu mak Ema Raiklaran Isin neꞌe moos kalo nunia. Haꞌu kmai, lahoos atu buka ema naliku Haꞌu. Mais Haꞌu kmai atu kaliku ema, kodi latan Haꞌukaan moris tomak nebee sori ema waꞌin nosi siakaan salan.” ");
INSERT INTO tet_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hotu, Yesus no Niakaan maktuir sia no ema waꞌin nia sia, toꞌo Yeriko. Baa oras sia atu laꞌo liu, noo ema delek ida noꞌi tuur iha dalan tehen nodi nadidu. Ema nia, naran Bartimeus. Aman, naran Timeus. ");
INSERT INTO tet_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Oras Bartimeus rona naꞌak ema mak laꞌo liu nia, Yesus nosi Nasaret, nia nahii makaꞌas naꞌak, “Yesus! Naꞌi Daud husar-binan! Madomi haꞌu lai!” ");
INSERT INTO tet_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Rona nahii nunia, ema krakat nodi deꞌan nia naꞌak, “Hoi! Noo-nook!” Mais Bartimeus nahii makaꞌas tenik naꞌak, “Yesus! Naꞌi Daud husar-binan! Madomi haꞌu lai!” ");
INSERT INTO tet_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Rona nola nunia, Yesus moos nanawa, hotu naruka ema nia sia naꞌak, “Hodi nia mai!” Sia moos baa katak baa delek nia naꞌak, “Neon diꞌak baa ona, tan Ama Boot bolu o. Mai ona!” ");
INSERT INTO tet_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Rona nola nunia, Bartimeus nariik, soe nela kedan niakaan tais, baa nasoru Yesus. ");
INSERT INTO tet_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Hotu, Yesus nusu nia naꞌak, “O makara saa?” Nia nataa naꞌak, “Ama Boot! Haꞌu kusu nebee bele karee!” ");
INSERT INTO tet_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus moos katak naꞌak, “Diꞌak. Tan o fiar maꞌak Haꞌu kbele kadiꞌak kola o, oras neꞌe moos, o diꞌak kedan! Fila ona!” Baa oras nia moos, Bartimeus matan moon kedas. Hotu, nia tuir Yesus. ");
INSERT INTO tet_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hotu, Yesus sia laꞌo liu toꞌo kreꞌis Yerusalem. Sia nanawa sala-sala kreꞌis leo rua iha Foho Saitun tehen. Leo rua nia, ida naran Betfage, ida naran Betania. Iha nia, Yesus naruka Niakaan maktuir naꞌin rua baa uluk. ");
INSERT INTO tet_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nia katak naꞌak, “Emi naꞌin rua baa uluk leo nebaa. Oras tama baa, emi atu haree kuda keledai oan matan ida mak ema kesi iha nia. Kuda keledai nia, ema sei la saꞌe dauk. Baa kore hola hodi mai. ");
INSERT INTO tet_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kalo ema nusu naꞌak, ‘Tan saa emi kore kuda keledai nia?’ emi musti hataa haꞌak, ‘Naꞌin atu saꞌe. Saꞌe notu, Nia solok fila kedan.’ ” ");
INSERT INTO tet_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Rona nola nunia, maktuir naꞌin rua nia baa. Toꞌo baa, sia netan kuda keledai oan nia, ema kesi iha dalan tehen. Sia moos kore nola, atu nodi baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Haree nunia, ema mak nariik iha nia sia nusu naꞌak, “Tan saa emi kore hola ema niakaan kuda keledai nia?” ");
INSERT INTO tet_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sia moos nataa naꞌak, “Naꞌin atu saꞌe. Saꞌe notu, Nia solok fila mai kedan.” Rona nola nunia, ema nia sia nabusik sia nodi baa. ");
INSERT INTO tet_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Toꞌo Yesus baa, sia nola tais nalo baa sela, taka baa kuda keledai nia. Hotu, Yesus saꞌe baa. ");
INSERT INTO tet_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Oras Yesus sia tama kota laran, ema waꞌin moos nola siakaan tais, naꞌe baa dalan klaran. Balu baa taa nola beet tahan iha dalan tehen, nodi baa, naꞌe keke iha dalan klaran. Nodi nafutar nunia, sia foo tadak naꞌak, sia simu Yesus nodi kneter, hanesan sia simu naꞌin boot. ");
INSERT INTO tet_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ema nia sia balu laꞌo uluk Yesus, balu tenik nosi kotuk. Sia nahii bele-bele naꞌak, “Hosana! Ami tonu-haboot Naꞌi Maromak, tan Nia natuun matak-malirin baa Ema mak mai nodi Niakaan naran. ");
INSERT INTO tet_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Ami tonu-haboot Naꞌi Maromak, tan Nia atu nariik nikar Naꞌi Daud fohorain! Hosana! Ami tonu-haboot Naꞌi Maromak, tan Nia nabesi aan iha laleꞌan mak aas kaliuk!” ");
INSERT INTO tet_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Toꞌo kota laran, Yesus sia tama baa Uma Hamulak Huun. Iha Uma Hamulak Huun lalawar, Nia titu satan leur fatik nia. Mais, tan atu kalan ona, sia moos fila baa leo Betania. ");
INSERT INTO tet_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Baa awan seisawan, Yesus sia sai nosi Betania, baa nikar Yerusalem. Toꞌo dalan klaran, Yesus salaen. ");
INSERT INTO tet_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nia naree ai huun ida iha dalan tehen. Ai nia fuan ema bele naa. Hotu, Yesus nareꞌis aan baa, atu naree kokon ai nia noo fuan ka lale. Mais, ai nia la no fuan, tan foin nataha. ");
INSERT INTO tet_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Naree nunia, Yesus nasee ai nia naꞌak, “Tan o la mafua bodik Haꞌu, nahuu baa oras neꞌe moos, o la mafua tenik bodik ema ona!” Yesus Niakaan maktuir sia moos rona Nia nasee nunia. ");
INSERT INTO tet_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus sia laꞌo liu toꞌo kota Yerusalem, hotu tama tenik baa Maromak Uma Hamulak Huun. Iha lalawar nia, noo ema mak faꞌan manu lakateu sina mak ema nalo baa sera oras namulak. Titu-naree nunia, Yesus baa teꞌur sai sia. Nia soe karin hadak mak ema nalo baa fatik taruka osan. Nia moos baku fila fatik mak ema nodi faꞌan manu lakateu. ");
INSERT INTO tet_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nia moos badu ema hotu-hotu, nebee keta hodi siakaan naha sai-tama tesi tuir Uma Hamulak lalawar nia. ");
INSERT INTO tet_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hotu, Nia katak baa ema nia sia naꞌak, “Hori uluk Maromak naruka Niakaan makoꞌan nakerek nela naꞌak, ‘Haꞌu kariik Haꞌukaan Uma, nebee ema raiklaran tomak bele mai namulak baa Haꞌu iha nia!’ Emi hatene lia nia tiꞌan, mais emi sei halo luku Uma neꞌe dadi baa ema naꞌok nuuk!” ");
INSERT INTO tet_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Oras naꞌilulik no manorik ukun Yahudi sia rona lia nosi Yesus Niakaan hahalok nia, sia hirus tebes. Sia buka dalan atu noꞌo Yesus, mais sia nakerat ema waꞌin mak beer basuk Yesus Niakaan hanorin. ");
INSERT INTO tet_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kreꞌis loro monu, Yesus sia sai nela kota Yerusalem, fila baa toba iha Betania. ");
INSERT INTO tet_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Baa awan seisawan, Yesus sia fila nikar baa Yerusalem. Toꞌo dalan klaran, sia laꞌo liu ai huun mak hori sehik Yesus nasee nia. Niakaan maktuir sia blaar, tan ai nia mate maran tiꞌan toꞌo abut. Petrus moos nanoin nola Yesus nasee hori sehik nia, hotu katak baa Yesus naꞌak, “Ama Boot! Haree lai! Ai huun mak Ama nasai lian manas hori sehik nia, mate maran tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus nataa naꞌak, “Tebes! Surak emi fiar baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kalo emi fiar tebe-tebes, emi bele haruka foho ida nakfokit lori baa tasi. Nanis foho nia nakfokit lori baa tasi, surak emi fiar metis hodi neon no laran. ");
INSERT INTO tet_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Keta haluꞌa! Kalo emi hamulak hodi husu sa-saa baa Naꞌi Maromak, Nia nanis foo baa emi. Surak emi fiar tebe-tebes! ");
INSERT INTO tet_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mais baa oras hamulak, kalo ema ida nosi emi laran sei manas no ema seluk, musti baa diꞌak hikar ho ema nia lai. Foin, emikaan Ama iha laleꞌan kasu mohu emikaan salan. ");
INSERT INTO tet_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kalo emi rai hirus hodi la foo pardua baa ema, emikaan Ama iha laleꞌan moos la foo pardua baa emi.” ");
INSERT INTO tet_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nunia hotu, Yesus sia laꞌo liu. Toꞌo Yerusalem baa, sia tama nikar baa Uma Hamulak Huun. Baa oras tama baa lalawar, naꞌilulik ulun sia no manorik ukun sia mai ");
INSERT INTO tet_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nusu baa Yesus naꞌak, “Tan saa hori sehik O mai tokar lauk iha neꞌe?! See mak naruka O?” ");
INSERT INTO tet_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mais Yesus natene sia buka Niakaan ain. Hotu, Nia nataa naꞌak, “Haꞌu moos kakara kusu lia ida baa emi. Emi hataa Haꞌu lai, foin Haꞌu kataa emi. ");
INSERT INTO tet_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Haꞌu kakara kusu nuneꞌe: ita hotu-hotu hatene Yohanis nia mak sarani ema. See mak latan beran baa nia, nebee nia sarani ema? Naꞌi Maromak ka, ema raiklaran?” ");
INSERT INTO tet_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Rona nola nunia, sia nanoin baa-mai. Hotu, sia kabuar lia fuan naꞌak, “Adeei! Ita kona diꞌa tiꞌan! Kalo ita hataa haꞌak, ‘Naꞌi Maromak mak latan beran,’ Nia atu nataa nikar naꞌak, ‘Kalo nunia, tan saa emi la fiar Yohanis?’ ");
INSERT INTO tet_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mais ita moos la bele hataa haꞌak, ‘Ema raiklaran mak latan beran’ keta arumak ema lear krakat ita, tan sia fiar naꞌak, Yohanis nia, Maromak makoꞌan.” ");
INSERT INTO tet_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Koꞌa notu lia, sia nataa badak dei naꞌak, “Ami la hatene!” Yesus moos nataa nikar baa sia naꞌak, “Kalo nunia, Haꞌu moos la katak baa emi, see mak latan beran baa Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hotu, Yesus dale tenik baa ema boot nia sia nodi lia hatetek naꞌak, “Noo ema ida nalo toꞌos baa niakaan rai rohan atu kuda ai anggor baa. Hotu, nia nalo baꞌa satan leur. Nia moos keꞌe kuak ida, nalo baa anggor ween fatik. Nia moos nariik uma tetu aas ida atu nodi daka toꞌos. Hotu, nia seba toꞌos nia baa ema mak serwisu toꞌos, nebee sia faꞌe rua toꞌos isin. Nakotu lia tiꞌan, toꞌos naꞌin nia laꞌo baa rai dook. ");
INSERT INTO tet_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Toꞌo oras kuꞌu, toꞌos naꞌin nia solok niakaan ema ain-liman ida baa nusu niakaan fafaꞌek. ");
INSERT INTO tet_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mais, ema serwisu toꞌos nia sia, kohi nola nodi taꞌe ema nia. Hotu, sia teꞌur fila nodi liman mamuk. ");
INSERT INTO tet_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Rona nola nunia, toꞌos naꞌin nia solok ema ida seluk baa. Mais, ema mak serwisu toꞌos nia sia taꞌe nia, toꞌo ulun fatun kanek karin. Sia moos deꞌan namoe nia, hotu nalatu fila. ");
INSERT INTO tet_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Rona tenik nunia, toꞌos naꞌin nia solok tenik ema ida baa. Mais ema serwisu toꞌos nia sia noꞌo nia. Masik sia nalo aat nunabee moos, toꞌos naꞌin solok niakaan ema sia baa bei-beik. Mais, ema serwisu toꞌos nia sia taꞌe balu, noꞌo balu. ");
INSERT INTO tet_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Baa ikus, hela mesan ema ida dei. Ema nia, toꞌos naꞌin oan mane mesak mak nia dadobe tebes. Tan la noo dalan seluk tiꞌan, toꞌos naꞌin solok luku oan baa. Nia naneo naꞌak, ‘Kalo haꞌu ksolok haꞌukaan oan duꞌuk, sia nanis simu diꞌa-diꞌak nodi rona baa nia.’ ");
INSERT INTO tet_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mais baa oras ema serwisu toꞌos nia sia naree oan nia mai, sia namaas baa malu naꞌak, ‘Hoi! Haree baa! Katuas naruka oan duꞌuk mak mai! Awan-wainrua, kalo katuas mate, nia neꞌe mak atu netan sasoin hotu-hotu. Diꞌak liu, ita hoꞌo nia ona, nebee ita hadau hola toꞌos neꞌe!’ ");
INSERT INTO tet_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hotu, sia kohi nola oan nia. Sia noꞌo tiꞌan, hotu soe maten baa toꞌos luan.” ");
INSERT INTO tet_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Hotu Yesus natuka lia hatetek nia, nodi nusu baa ema boot nia sia naꞌak, “Oras neꞌe, Haꞌu atu kusu nuneꞌe: Toꞌos naꞌin nia atu nalo saa baa ema serwisu sia? Tuir Haꞌu, nia nanis mai noꞌo mohu sia. Hotu, nola nikar toꞌos nia, foo baa ema seluk. ");
INSERT INTO tet_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Arumak emi sei la leno dauk saa mak hakerek tiꞌan iha Hakerek Moon naꞌak, ‘Noo fatuk ida mak badaen fatuk sia soe lerek tiꞌan. Mais, oras neꞌe fatuk nia dadi baa uma tatuur fatuk ona. ");
INSERT INTO tet_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Naꞌi Maromak duꞌuk mak boi nola no natuur fatuk nia. Etuk oin, ita haree baa, kabaas tebes!’ ” ");
INSERT INTO tet_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Rona nola nunia, ema boot sia natene kedan naꞌak, Yesus Niakaan lia hatetek nia kona baa sia. Sia manesak no ema serwisu aat nia sia no badaen mak soe fatuk nia. Tan lia nia, sia buka dalan atu kohi Yesus. Mais, sia nakerat ema lear mak nakara Yesus Niakaan hanorin. Hotu, sia laꞌo nela Yesus dei. ");
INSERT INTO tet_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nunia hotu, ema boot Yahudi sia bolu nola ema Farisi no maktuir Herodes naꞌin hira, nebee baa naseꞌi lia atu nahonu Yesus. ");
INSERT INTO tet_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hotu, sia moos baa nusu Yesus naꞌak, “Ama Boot! Ami hotu-hotu hatene haꞌak, Ama neon loos. Ama nanorin loke fore Naꞌi Maromak hakaran, no la fihir oin. Oras neꞌe, ami atu husu lia ida nuneꞌe: tuir itakaan ukun-badu Yahudi, ita musti selu bea baa liurai Roma ka lale?” ");
INSERT INTO tet_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mais Yesus natene sia atu nahonu Nia, nebee dale sakar ukunrai Roma. Tan baa nia, Nia nataa naꞌak, “Tan saa emi haseꞌi lia atu hahonu Haꞌu!? Hatudu kokon osan murak tomak ida baa Haꞌu!” ");
INSERT INTO tet_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hotu, sia nodi osan murak tomak ida baa Yesus. Nia simu nola, hotu leno. Hotu, Nia nusu baa sia naꞌak, “Neꞌe, see niakaan oin? Neꞌe, see niakaan naran?” Sia nataa naꞌak, “Nia, Keser mak liurai Roma.” ");
INSERT INTO tet_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hotu, Yesus dale tenik naꞌak, “Kalo nunia, foo baa ukunrai saa mak ukunrai niakaan. No foo baa Maromak saa mak Maromak Niakaan.” Rona nola Yesus nataa nunia, sia blaar karin, tan Yesus dale nia makonak. Masik sia buka Yesus ain moos, la bele. ");
INSERT INTO tet_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hotu, ema naꞌin hira seluk mai baa Yesus. Sia nia, nosi partee Saduki mak nanorin naꞌak, nosi ikus baa oras rai falu fila, ema mak mate tiꞌan, la moris nikar. ");
INSERT INTO tet_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Sia katak baa Yesus naꞌak, “Ama Boot! Bei Musa nakerek nela ukun-badu baa ita ema Yahudi naꞌak: Kalo mane ida mate nela feen, mais la noo oan, niakaan alin musti nola feto faluk nia, nebee foo husar-binan baa niakaan maun mak mate tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Uluk bei Musa nanorin nunia tebes. Mais noo lia ida nuneꞌe: Noo mane maun-alin naꞌin hitu. Mane ulun nola feen, hotu mate, mais la noo oan. ");
INSERT INTO tet_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hotu, alin mak tuir nia, nola nikar feto faluk nia. Mais la kleur, alin nia moos mate, la noo oan. Nunia tenik alin susu dala rua. Nia nola feto nia. Mais nia moos mate, la noo oan tenik. ");
INSERT INTO tet_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nunia bei-beik toꞌo alin ikun moos mate. Nosi ikus, feto faluk nia moos mate. ");
INSERT INTO tet_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Oras neꞌe ami atu husu nuneꞌe: Feto nia nola mane naꞌin hitu tiꞌan. Nosi ikus, baa oras rai falu fila Naꞌi Maromak nalo ema mate tiꞌan sia moris nikar, feto nia dadi baa mane ida nabee feen?” ");
INSERT INTO tet_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Rona nola nunia, Yesus nataa naꞌak, “Kalo emi husu nunia, emi sala tiꞌan! Emi la hatene Hakerek Moon isin. Emi moos la hatene Naꞌi Maromak beran makaꞌas! ");
INSERT INTO tet_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rona! Lia loos mak neꞌe! Naꞌi Maromak Niakaan makbukar laleꞌan la nola malu. Oras rai falu fila Naꞌi Maromak nalo ema mate tiꞌan sia moris nikar, sia moos la nola malu ona, hanesan makbukar laleꞌan sia. ");
INSERT INTO tet_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Haꞌu moos kalore tenik kosi lia ema mak mate tiꞌan bele moris nikar ka lale. Uluk aan, Bei Musa nakerek lia nosi ai huun kiꞌik mak haꞌi naa mais la namotuk. Emi la leno lia nia ka? Baa oras haꞌi naa ai huun nia, Naꞌi Maromak foo natene baa Bei Musa naꞌak, ‘Haꞌu neꞌe Maromak, mak okaan Bei Abraham, Bei Isak no Bei Yakob, siakaan Maromak. Sia hotu-hotu loꞌu-sudur baa Haꞌu hori uluk toꞌo oras neꞌe.’ ");
INSERT INTO tet_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kalo ita leno nunia, ita hatene haꞌak, baa oras Naꞌi Maromak dale nunia, bei nia sia mate kleur tiꞌan. Masik nunia moos, Naꞌi Maromak katak naꞌak, sia sei loꞌu-sudur baa Nia. Lia nia naꞌak, sia sei moris. Dadi, masik ema mate tiꞌan, bele moris nikar. Ema moris mak loꞌu-sudur baa Naꞌi Maromak, lahoos ema mate! Kalo emi kaer metis hanorin mak naꞌak ema mak mate tiꞌan la bele moris nikar, emi sala tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Baa oras nia, noo manorik ukun Yahudi ida mak tuir rona Yesus nanorin ema partee Saduki sia. Manorik ukun nia naneo naꞌak, Yesus nataa diꞌa-diꞌak lia mak sia nusu ohin nia. Hotu, nia nusu baa Yesus naꞌak, “Ama Boot! Haꞌu atu kusu lia ida nuneꞌe: Itakaan ukun-badu nosi Bei Musa, waꞌin loos. Nosi ukun nia sia hotu-hotu, ukun nabee mak boot kaliuk?” ");
INSERT INTO tet_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus moos nataa naꞌak, “Ukun mak boot kaliuk mak neꞌe: ‘Ema hotu-hotu iha rai Israꞌel, rona diꞌa-diꞌak! Naꞌi Maromak mak itakaan Naꞌin, no itakaan Maromak! La noo seluk tenik. Nia mesan dei. ");
INSERT INTO tet_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dadi, ita musti hadomi Nia liu hotu-hotu. Ita musti beer Nia bei-beik. Ita musti hatene diꞌa-diꞌak Nia. Tenik, ita musti hakaꞌas aan tuir Niakaan hakaran.’ ");
INSERT INTO tet_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","No ukun dala rua mak neꞌe: ‘Ita musti hadomi itakaan maluk, oin nudaar ita hadomi itakaan isin lolon duꞌuk.’ Ukun rua neꞌe, mak boot kaliuk. La no ukun seluk tenik mak boot liu ukun rua neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hotu, manorik ukun nia simu Yesus naꞌak, “Tebes Ama! Saa mak Ama Boot katak nia loos. Naꞌi Maromak ida dei! La noo seluk tenik. Nia mesan dei. ");
INSERT INTO tet_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ita musti hadomi Nia liu hotu-hotu. Ita musti beer Nia bei-beik. Ita musti hatene diꞌa-diꞌak Nia, no ita musti hakaꞌas aan tuir Niakaan hakaran. Ita moos musti hadomi itakaan maluk, oin nudaar ita hadomi itakaan isin lolon duꞌuk. Nia, mak Naꞌi Maromak beer liu nosi itakaan sera hotu-hotu baa Nia.” ");
INSERT INTO tet_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Rona nola nunia, Yesus natene naꞌak manorik ukun nia natene tebes tiꞌan. Hotu Yesus katak baa nia naꞌak, “Ama kreꞌis tiꞌan dadi Naꞌi Maromak eman.” Nunia hotu, la noo ema seluk tenik mak naksakar aan toe no Yesus, tan la noo mak bele nahonu Nia. ");
INSERT INTO tet_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hotu, Yesus nanorin tenik ema iha Uma Hamulak Huun. Nia katak nalore naꞌak, “Hori uluk aan Naꞌi Maromak nameno tiꞌan atu solok Kristus nodi sori Niakaan ema sia. Itakaan manorik ukun Yahudi sia nanorin naꞌak, Kristus nia, Naꞌi Daud husar-binan. Mais siakaan hanorin nia, sei la toꞌo dauk. ");
INSERT INTO tet_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tan uluk Maromak Kmalar Lulik naruka Naꞌi Daud nakerek nosi lia Kristus naꞌak: ‘Naꞌi Maromak katak tiꞌan baa haꞌukaan Ulun Boot naꞌak, “Mai tuur baa fatik kneter kaliuk neꞌe iha Haꞌukaan sorin kwana, tan Haꞌu atu kalo okaan funu sia loꞌu baa o.’ ” ");
INSERT INTO tet_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Nosi hakerek nia, ita hatene malorek haꞌak, Naꞌi Daud duꞌuk temi Kristus naꞌak ‘Ulun’. Dadi, kalo ema naꞌak Kristus nia, Naꞌi Daud husar-binan loos dei, lia nia sei la toꞌo dauk, tan Kristus moos, Naꞌi Daud Ulun!” ");
INSERT INTO tet_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Rona Yesus nanorin nunia, ema waꞌin beer tebes. ");
INSERT INTO tet_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Hotu, Yesus katak tenik naꞌak, “Sintidu baa manorik ukun sia. Sia tau faru klobor nodi laꞌo baa-mai lalore aan baa ema waꞌin, nebee ema tonu sia naꞌak, ‘Ema nia sia, moon tebes!’ ");
INSERT INTO tet_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Oras tama uma hamulak, sia buka tuur fatik iha oin, nebee ema waꞌin titu-naree sia. Iha dahur moos, sia nalo nunia. ");
INSERT INTO tet_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mais sintidu, tan sia bosok feto faluk sia, nodi nadau nola siakaan uma. Mais iha ema lear oin, sia subar mate siakaan aꞌaat. Sia nariik nodi namulak kleu-leur, tan sia beer ema tonu naꞌak, sia ema moon. Mais nosi ikus, sia simu kastikar todan liu.” ");
INSERT INTO tet_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Hotu, Yesus baa tuur kreꞌis baa ai balun sera fatik iha Uma Hamulak Huun. Nia naree ema mai natama osan sera baa ai balun. Baa oras nia, ema maksoin sia mai natama osan waꞌin boot. ");
INSERT INTO tet_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","La oras, feto faluk mukit ida moos mai namulak. Nia natama osan lahon rua baa ai balun nia. Osan nia folin kiꞌik basuk. ");
INSERT INTO tet_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Naree nunia, Yesus bolu nola Niakaan maktuir sia, hotu katak naꞌak, “Haree baa! Feto mukit neꞌe natama osan lahon rua dei, mais niakaan sera nia, boot liu ema hotu-hotu siakaan sera. ");
INSERT INTO tet_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ema seluk sia foo sera nosi siakaan osan resin. Mais, feto faluk neꞌe sera mohu niakaan osan hotu-hotu, toꞌo osan atu nola haan moos, la noo ona.” ");
INSERT INTO tet_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hotu, Yesus no Niakaan maktuir sia nariik atu laꞌo nela Uma Hamulak Huun. Baa oras sai, maktuir ida natudu Uma Hamulak nia baa Yesus nodi naꞌak, “Ama Boot! Haree kokon! Uma neꞌe, kabaas tebes! Ema nada fatuk boot sia diꞌak basuk!” ");
INSERT INTO tet_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mais Yesus nataa naꞌak, “Uma neꞌe kabaas tebes. Mais la kleur ona, ema atu naroꞌon mohu fatuk neꞌe sia hotu-hotu.” ");
INSERT INTO tet_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hotu, Yesus baa tuur iha Foho Saitun, nebee bele mana mai Naꞌi Maromak Niakaan Uma Hamulak Huun. Niakaan maktuir naꞌin haat mak Petrus, Yakobus, Yohanis no Andreas baa tuir Nia atu dale mesan no Nia. ");
INSERT INTO tet_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Sia nusu baa Yesus naꞌak, “Ama! Katak malore lia mak Ama dale ohin nia nosi Uma Hamulak Huun. Wainhira loron nia toꞌo? Niakaan tadak oin nunabee?” ");
INSERT INTO tet_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus nataa naꞌak, “Emi musti daka aan diꞌa-diꞌak, nebee keta kona beꞌur. ");
INSERT INTO tet_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ema oi-oik atu mai loko aan naꞌak, ‘Haꞌu neꞌe, Kristus, mak Naꞌi Maromak nameno kedan hori uluk.’ Hodi nunia, sia beꞌur nola ema waꞌin. ");
INSERT INTO tet_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mais, lalika hataꞌuk kalo emi haree ema natuda malu, lale emi rona haꞌak ema natuda iha fatin hotu-hotu. Hahalok oi-oik nunia, musti mosu uluk lai, foin rai falu fila. ");
INSERT INTO tet_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ema klubun ida atu natuda sakar klubun seluk. Rai ida atu natuda sakar rai seluk. Rai kakekuk mosu iha nabee-nabee. Dinu salaen boot basuk moos mosu mai. Lia nia hotu-hotu foo tadak naꞌak, oras rai falu fila kreꞌis ona, hanesan feto mak notak moras tiꞌan, tan oras nahoris kreꞌis ona. ");
INSERT INTO tet_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Emi musti daka aan diꞌa-diꞌak! Ema atu mai kohi emi, hotu dada nodi baa moon-metan, tan emi tuir Haꞌu. Sia moos taꞌe nababu emi iha uma hamulak laran. Sia moos kesi nola emi baa hataa ema makaer ukun sia. Mais emi musti katak malorek Haꞌukaan Manfatin Diꞌak baa sia. ");
INSERT INTO tet_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Haꞌukaan Manfatin Diꞌak nia musti keke lema baa ema klubun hotu-hotu iha raiklaran tomak, foin rai falu fila. ");
INSERT INTO tet_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hanoin diꞌa-diꞌak! Kalo ema kesi emi nodi baa moon-metan, keta makerat. Keta neo-neon haꞌak emi atu hataa saa, tan Maromak Kmalar Lulik foo lia fuan baa emi atu hodi hataa. ");
INSERT INTO tet_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Hanoin! Ema mak fiar baa Haꞌu, ema atu hirus nia, toꞌo niakaan familin duꞌuk buka dalan noꞌo nia. Kalo aman fiar, oan duꞌuk mak atu noꞌo aman. Kalo oan fiar, inan-aman duꞌuk mak atu noꞌo oan. ");
INSERT INTO tet_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ema hotu-hotu atu hirus emi, tan fiar Haꞌu. Mais ema mak naterus aan tuir Haꞌu bei-beik, nia nanis netan moris toꞌo nima-nimak.” ");
INSERT INTO tet_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Hotu, Yesus nanorin tenik naꞌak, “Ema aat basuk ida atu mai, tama baa nariik iha fatik lulik iha Naꞌi Maromak Niakaan Uma Hamulak Huun, toꞌo ema nakribi fatik nia. Naꞌi Maromak moos taliꞌur nela. Dadi, kalo emi haree nunia tiꞌan, sintidu! (Ema mak leno neꞌe moos, musti sintidu!) Hahalok nia foo tadak naꞌak, loron susar toꞌo tiꞌan. Kalo naree nunia tiꞌan, ema rai Yudea musti nalai saꞌe baa foho ona. ");
INSERT INTO tet_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Musti halai lai-lais, nebee keta kona susar. Ema mak sai nosi uma tiꞌan, keta fila baa nola bahoꞌak ona. ");
INSERT INTO tet_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ema mak iha toꞌos, keta fila baa nola tais ona. Halai liu baa ona! ");
INSERT INTO tet_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Baa oras nia, ema susar kaliuk, mak feto makoꞌus no feto mak sei nasusu lawarik oan, tan sia la bele nalai lai-lais. ");
INSERT INTO tet_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Diꞌak liu, hamulak hodi hakroꞌan, nebee loron aat nia sia keta mosu mai kona baa rai udan. ");
INSERT INTO tet_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Loron nia sia, susar basuk! Nahuu nosi Naꞌi Maromak naseꞌi raiklaran toꞌo oras neꞌe, ema sei la naree dauk susar boot oin nunia. Ema moos la naree tenik susar oin nunia. ");
INSERT INTO tet_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kalo Naꞌi Maromak la nabadak loron susar nia sia, la noo ema ida moos mak bele moris. Mais Nia nadomi Niakaan ema mak Nia boi nola tiꞌan. Tan lia nia, Nia nabadak loron susar nia sia. ");
INSERT INTO tet_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kalo loron susar nia sia toꞌo tiꞌan, emi atu rona ema naꞌak, ‘Haree lai! Kristus iha neꞌe!’ Ema seluk naꞌak, ‘Kristus iha nebaa!’ Mais keta fiar! ");
INSERT INTO tet_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ema atu mosu mai nodi nola aan naꞌak, ‘Haꞌu neꞌe, Kristus!’ Balu tenik naꞌak, ‘Haꞌu neꞌe, Maromak makoꞌan.’ Sia atu naseꞌi tadak blaar oi-oik nodi diabu beran toꞌo beꞌur nola ema. Sia buka dalan nebee Naꞌi Maromak eman sia moos bele kona beꞌur! ");
INSERT INTO tet_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dadi, emi musti daka aan diꞌa-diꞌak! Loron susar nia sia sei la toꞌo dauk, mais Haꞌu foo katene kedan baa emi!” ");
INSERT INTO tet_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Hotu, Yesus katak kedan tenik baa Niakaan maktuir sia naꞌak, “Kalo loron susar nia sia siku tiꞌan, ‘Loro matan atu nakukun luri. Fulan la nakroma ona. ");
INSERT INTO tet_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Fitun nakodan nosi laleꞌan. Beran hotu-hotu iha laleꞌan moos nahutan karin.’ ");
INSERT INTO tet_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lia nia sia siku tiꞌan, foin emi bele haree hikar Haꞌu, Ema Raiklaran Isin neꞌe. Baa oras nia, Haꞌu ktuun mai kodi kaloꞌan. Ema hotu-hotu atu naree Haꞌukaan beran no Haꞌukaan makaꞌas. ");
INSERT INTO tet_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hotu, Haꞌu atu karuka Maromak Niakaan makbukar laleꞌan sia, nebee baa libur nola ema hotu-hotu mak Haꞌu kboi kola tiꞌan kosi rai ulun toꞌo rai ikun, kosi lorosaꞌe toꞌo loromonu, nosi lorokaras toꞌo lorokbelan.” ");
INSERT INTO tet_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Hotu, Yesus katak tenik nodi lia hatetek nosi ai huun naꞌak, “Kalo ai tahan nahuu nakmodok, nia foo tadak naꞌak, loro falin kreꞌis mai ona. ");
INSERT INTO tet_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nunia moos, loron susar mak Haꞌu katak ohin nia sia. Kalo loron susar nia sia toꞌo mai tiꞌan, nia foo tadak naꞌak, Haꞌu kreꞌis mai ona. ");
INSERT INTO tet_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Nosi ema hotu-hotu mak moris baa oras neꞌe, balu sei la mate dauk, mais loron susar nia sia mai tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Masik laleꞌan no raiklaran lakon mohu, Haꞌukaan Manfatin nafati nohuun!” ");
INSERT INTO tet_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hotu, Yesus katak tenik naꞌak, “Oras neꞌe, Haꞌu kfoo katene kosi oras Haꞌu kmai kikar. La noo ema ida mak natene niakaan loron no niakaan oras. Maromak Niakaan makbukar laleꞌan sia la natene. Haꞌu naꞌin duꞌuk moos la katene. Haꞌukaan Ama mesan mak natene. ");
INSERT INTO tet_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tan baa nia, musti daka aan diꞌa-diꞌak, tan emi la hatene wainhira oras nia toꞌo mai. ");
INSERT INTO tet_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","La kleur ona, Haꞌu atu klaꞌo kela emi, mais nosi ikus Haꞌu kmai kikar. Lia nia hanesan ema ida mak laꞌo nela uman, baa fatin dook. Nia naruka niakaan ema serwisu atu babilan diꞌa-diꞌak niakaan uma. Nia faꞌe serwisu baa sia ida-idak no naruka makdaka odamatan nanokar atu daka diꞌa-diꞌak toꞌo nia mai nikar. ");
INSERT INTO tet_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nunia moos emi. Musti daka aan loron-kalan, tan emi la hatene wainhira uma naꞌin mai nikar. Nia fila baa loron ka, kalan boot ka, oras loro saꞌe ka, emi la hatene. ");
INSERT INTO tet_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Keta arumak nia mai nikar teki-tekis, toma nola emi sei toba. ");
INSERT INTO tet_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lia mak Haꞌu katak baa emi neꞌe, Haꞌu moos katak baa ema hotu-hotu kaꞌak, ‘Daka aan diꞌa-diꞌak hodi hein Haꞌukaan mamain.’ ” Yesus nanorin Niakaan maktuir sia iha foho Saitun nunia dei. ");
INSERT INTO tet_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Oras nia, naꞌilulik ulun no manorik ukun Yahudi sia buka dalan kohi no-nook Yesus, tan atu noꞌo Nia. Mais sia dale baa malu naꞌak, “Hein lai! Ita keta kohi nia lai-lais, tan loron boot sia kreꞌis mai ona. Keta arumak ema waꞌin nakfetik baa ita.” Sia koꞌa lia nunia, tan ema Yahudi siakaan loron boot sia nahuu baa wainrua. Loron boot nia sia, ema temi naꞌak, ‘Dahur Paska’ no ‘Dahur Tubi Bakae.’ Sia nadahur loron nia sia nodi nanoin baa oras siakaan bei uluk sia sai nosi rai Mesir. ");
INSERT INTO tet_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iha leo Betania, noo ema ida naran Simon. Uluk, ema nakribi nia tan kona moras funi mea. Mais oras neꞌe, nia diꞌak tiꞌan. Loron boot nia sia sei la toꞌo dauk, Yesus sia baa naa iha Simon uman. Sia noꞌi naa, feto ida mai nasoru Yesus. Feto nia kaer nodi mina morin botir ida. Mina morin nia folin todan. Botir moos noo folin tan halo hosi fatuk. Toꞌo Yesus baa, feto nia taꞌe naroe botir matan. Hotu, fui nanii mina nia baa Yesus ulun atu foo tadak naꞌak nia nakneter Yesus. ");
INSERT INTO tet_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Oras nia, ema seluk moos tuir naa. Sia naree feto nia nalo nunia, sia dale baa malu nodi naksaꞌek aan naꞌak, “Hoi! Feto saa mak neꞌe, toꞌo soe butan mina morin folin todan basuk nia! ");
INSERT INTO tet_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Diꞌak liu, faꞌan mina nia dei, nebee faꞌe osan baa ema mukit sia! Mina nia folin manesak no ema ida kansera tinan ida.” Hotu, sia krakat feto nia. ");
INSERT INTO tet_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mais Yesus dale naꞌak, “Keta hasusar feto neꞌe! Habusik baa! Haꞌu neon diꞌak tan nia fui mina neꞌe baa Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ema mukit sia namutuk no emi bei-beik. Emi bele tulun sia hei-hein. Mais la kleur ona, Haꞌu la kamutuk ko emi tiꞌan, ");
INSERT INTO tet_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","tan Haꞌukaan moris la kleur ona. Nodi fui mina baa Haꞌu, feto neꞌe nahulin kedan Haꞌukaan isin, hanesan nia falun tiꞌan Haꞌukaan maten. ");
INSERT INTO tet_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Oras ema keke lema Naꞌi Maromak Manfatin Diꞌak baa raiklaran tomak, sia moos katak feto neꞌe niakaan dadiꞌak, nebee ema hotu-hotu nanoin baa nia.” ");
INSERT INTO tet_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nosi Yesus Niakaan maktuir naꞌin sanulu resin rua nia, ida naran Yudas Iskariot. Baa loron nia, nia baa buka naꞌilulik ulun sia atu latan Yesus baa sia. Toꞌo baa, nia katak niakaan hakara. ");
INSERT INTO tet_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rona nola Yudas hakaran nia, ema boot nia sia neon diꞌak lo-loos. Sia namate lia no Yudas naꞌak, “Kalo o makara faꞌan Yesus, nanis ami sosa.” Hotu, Yudas sai baa buka dalan atu latan Yesus baa sia. ");
INSERT INTO tet_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hotu, ema Yahudi siakaan loron boot sia toꞌo mai tiꞌan. Baa loron dala uluk, sia tunu tubi mak la kahur tua teen tubi, no noꞌo bibi malae. Baa loron nia Yesus Niakaan maktuir sia mai nusu baa Nia naꞌak, “Ama! Ohin kalan neꞌe ita musti hahuu Dahur Tubi Bakae hodi koꞌa bibi malae atu haa baa Paska. Dadi, Ama nakara ami baa hadiꞌa dahur nia iha nabee?” ");
INSERT INTO tet_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Rona nola nunia, Yesus naruka maktuir naꞌin rua naꞌak, “Emi baa uluk iha kota laran. Iha nebaa, emi atu hasoru hola mane ida noꞌi natiu lolo no wee. Emi baa tuir nia. ");
INSERT INTO tet_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kalo nia tama baa uma nabee, emi moos tama tuir. Hotu, husu baa uma naꞌin haꞌak, ‘Mau! Ama Boot nusu fatik ida atu nodi naa Dahur Paska no Niakaan maktuir sia.’ ");
INSERT INTO tet_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hotu, uma naꞌin nia atu natudu keꞌan luan ida iha tetu leten. Nia nadiꞌa tetuk tiꞌan keꞌan nia. Emi baa hadiꞌa loos haan dei.” ");
INSERT INTO tet_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Rona nola nunia, sia naꞌin rua moos baa. Toꞌo baa, sia naree sa-saa hotu-hotu, tuir saa mak Yesus katak tiꞌan baa sia. Sia moos nadiꞌa dahur Paska iha nia. Hotu, sia baa bolu Yesus no maktuir rumak sia. ");
INSERT INTO tet_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Oras loro atu monu, Yesus no maktuir naꞌin sanulu resin rua nia moos baa fatik nia. ");
INSERT INTO tet_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Toꞌo baa, sia tuur naa. Baa oras naa, Yesus katak naꞌak, “Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Ema ida nosi emi atu faꞌan Haꞌu baa ema seluk.” ");
INSERT INTO tet_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rona nola nunia, maktuir sia noran la diꞌak. Sia ida-idak katak baa Yesus naꞌak, “Lahoos haꞌu mak Ama dale nia. Tebes ka Ama?” ");
INSERT INTO tet_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus nataa naꞌak, “Ema mak lobas tubi baa mako neꞌe laran namutuk no Haꞌu, nia mak atu faꞌan Haꞌu. ");
INSERT INTO tet_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hanoin diꞌa-diꞌak! Haꞌu neꞌe, Ema Raiklaran Isin. Haꞌu musti mate tuir saa mak hakerek kedan tiꞌan iha Hakerek Moon. Mais sintidu! Ema mak faꞌan Haꞌu nia atu natiu niakaan dinu! Diꞌak liu, niakaan inan la nahoris kedan nia!” ");
INSERT INTO tet_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Baa oras sia naa, Yesus foti nola tubi baluk ida. Nia nusu matak-malirin baa Naꞌi Maromak, hotu tohi faꞌe tubi nia, lolo baa Niakaan maktuir sia nodi katak naꞌak, “Tubi neꞌe, Haꞌukaan isin. Simu hola, haa baa ona!” ");
INSERT INTO tet_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nunia hotu, Nia nola hemu fatik ida mak noo anggor ween. Nia sera dodan baa Naꞌi Maromak, hotu lolo baa Niakaan maktuir sia, nebee sia nemu. ");
INSERT INTO tet_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nia moos katak naꞌak, “Anggor ween neꞌe, Haꞌukaan raan mak atu nakduar nodi foo moris baa ema lear. Hodi raa neꞌe, Naꞌi Maromak namate menon foun no emi. ");
INSERT INTO tet_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Nahuu baa oras neꞌe, Haꞌu la kemu tenik anggor ween ona, toꞌo Haꞌu kabesi aan kaer ukun ko Haꞌukaan Ama iha laleꞌan tiꞌan, foin Haꞌu kemu kikar.” ");
INSERT INTO tet_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hotu, sia nananu kananuk ida nodi tonu-naboot Naꞌi Maromak. Kalan nia moos, sia laꞌo kedan baa foho Saitun. ");
INSERT INTO tet_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oras sia laꞌo, Yesus katak baa Niakaan maktuir sia naꞌak, “Ohin kalan neꞌe, emi hotu-hotu atu halai hela Haꞌu. Hori uluk Maromak makoꞌan nakerek nela kedan nosi lia neꞌe naꞌak, ‘Haꞌu atu koꞌo makbalin. Hotu, niakaan bibi malae sia nalai keen karin.’ ");
INSERT INTO tet_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nunia tebes. Haꞌu nanis mate. Mais, moris kikar. Oras moris kikar tiꞌan, Haꞌu kbaa uluk kein emi iha rai Galilea nebaa.” ");
INSERT INTO tet_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Rona nola nunia, Petrus sakar naꞌak, “La bele nunia Ama! Masik ema hotu-hotu nalai nela Ama moos, haꞌu lale!” ");
INSERT INTO tet_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mais Yesus nataa naꞌak, “Petrus! Rona mai, tan Haꞌukaan dalen neꞌe, tebes no loos! Ohin kalan neꞌe moos manu sei la kokoreek isin rua dauk, o meli Haꞌu isin tolu tiꞌan maꞌak, o la matene Haꞌu!” ");
INSERT INTO tet_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mais Petrus nakaꞌas aan nodi nataa naꞌak, “Lale Ama! Kalo Ama mate, haꞌu moos mate tuir. Haꞌu la keli Ama.” Petrus niakaan mamaluk sia ida-idak moos dale nunia. ");
INSERT INTO tet_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hotu, Yesus sia laꞌo liu baa toꞌos ida iha foho Saitun lolon. Toꞌos neꞌe naran ‘Getsemani’. Toꞌo baa, Yesus katak baa Niakaan maktuir sia naꞌak, “Tuur hein iha neꞌe lai, tan Haꞌu atu kbaa kamulak.” ");
INSERT INTO tet_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mais nia bolu nola Petrus, Yakobus no Yohanis atu baa no Nia. Nahuu baa oras nia, Nia noran susar toꞌo, no neon la metin. ");
INSERT INTO tet_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nia katak baa sia naꞌin tolu naꞌak, “Haꞌukaan neon susar basuk! Koran nuꞌu atu mate dei. Emi tuur daka iha neꞌe lai.” ");
INSERT INTO tet_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Hotu, Nia laꞌo soruk tenik oda baa, foin nakniꞌa sudur toꞌo rai nodi namulak naꞌak, “Ama! Kalo Ama nakara, Haꞌu lalika katiu kola susar neꞌe. Haꞌu katene la noo saa ida mak Ama la bele nalo. Dadi, kalo bele, Ama foti nola susar neꞌe soe dook nosi Haꞌu. Mais keta tuir Haꞌukaan hakaran. Tuir Ama hakaran dei.” ");
INSERT INTO tet_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Namulak notu, Yesus baa nikar maktuir naꞌin tolu nia. Mais, sia toba dukur. Hotu, Nia katak baa Petrus naꞌak, “Hoi, Petrus! O toba ka? Tan saa emi la bele daka oda no? ");
INSERT INTO tet_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Haroma emikaan matan, hotu hamulak nebee keta kona sokur. Emikaan neon nanis nakara nalo diꞌak, mais emikaan isin lolon la biit.” ");
INSERT INTO tet_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hotu, Yesus baa namulak nodi nakroꞌan tenik baa Naꞌi Maromak, nebee Nia lalika natiu susar nia. Mais keta tuir Niakaan hakaran, tuir Aman hakaran dei. ");
INSERT INTO tet_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Namulak notu, Nia fila nikar baa maktuir naꞌin tolu nia. Mais, sia toba nikar tiꞌan tan matan nakati tebes. Nia nasee tenik baa sia, mais sia la natene atu dale saa. ");
INSERT INTO tet_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hotu, Yesus laꞌo nela sia baa namulak baa dala tolu. Namulak notu, nia fila nikar baa sia nodi naꞌak, “Emi sei toba ka? Toꞌo ona! Oras neꞌe, ema mak atu faꞌan Haꞌu Ema Raiklaran Isin neꞌe, mai tiꞌan. Nia atu kohi Haꞌu, latan baa ema aat liman. ");
INSERT INTO tet_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hadeer! Haree kokon iha nebaa! Ema mak atu faꞌan Haꞌu nia, mai tiꞌan. Mai ita baa hasoru nia!” ");
INSERT INTO tet_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus sei dale nunia, teki-tekis Niakaan maktuir ida naran Yudas mai no ema waꞌin. Sia mai nodi surik no ai kaliduk atu kohi Yesus. Sia nalo nunia, tan ema boot Yahudi sia mak naruka. Ema boot nia sia, mak naꞌilulik ulun sia, manorik ukun sia, no fukun adat sia. ");
INSERT INTO tet_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Uluk Yudas foo kedan tadak baa sia naꞌak, “Haree diꞌa-diꞌak! Ema mak haꞌu deꞌi, kohi hola nia hodi baa ona, tan Nia mak emi buka!” ");
INSERT INTO tet_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tan nameno tiꞌan nunia, baa oras Yudas toꞌo baa, nia laꞌo natutuk kedan baa Yesus nodi nasee naꞌak, “Tabe, Ama Boot!” Hotu nia moos nakoꞌak nodi deꞌi Yesus. ");
INSERT INTO tet_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Naree tadak nia, ema waꞌin nia moos soruk baa, kohi nola Yesus. ");
INSERT INTO tet_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ema ida iha nia moos losu nola surik, nodi taa kotu ema ida tilun tahan. Ema kanek nia, naꞌilulik ulun boot atan. ");
INSERT INTO tet_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hotu, Yesus moos katak baa ema waꞌin nia naꞌak, “Tan saa emi mai kohi Haꞌu hodi surik no ai kaliduk?! Emi haneo, Haꞌu neꞌe, ema aat ka? ");
INSERT INTO tet_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sura loron Haꞌu kamutuk ko emi oras kanorin iha Uma Hamulak Huun, mais emi la kohi Haꞌu. Mais soꞌin baa! Kohi hola Haꞌu ona! Maromak makoꞌan sia nakerek nela kedan lia neꞌe hori uluk.” ");
INSERT INTO tet_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Titu-naree nunia, Yesus Niakaan maktuir sia nataꞌuk tebes toꞌo niꞌit aan nalai nela Nia. ");
INSERT INTO tet_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Iha nia moos noo ema nurak ida mak laꞌo tuir Yesus nosi kotuk. Nia nafuꞌut loos tais. Ema nia sia moos atu kohi nia, ");
INSERT INTO tet_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mais sia kaer nola niakaan tais dei. Hotu, nia nalai fila nodi walan dei, tan nataꞌuk tebes. ");
INSERT INTO tet_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hotu, sia dada nodi Yesus baa naꞌilulik ulun boot uman. Iha nia, ulun boot Yahudi sia naklibur tiꞌan atu nalo moon-metan. Ema nia sia, mak naꞌilulik ulun sia, manorik ukun sia, no fukun adat sia. ");
INSERT INTO tet_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Oras sia dada nodi Yesus baa, Petrus tuir no-nook nosi kotuk. Nia moos tama baa uma nia lalawar atu naniruk haꞌi bele-bele no ema mak daka iha nia. ");
INSERT INTO tet_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iha uma nia laran, ulun boot sia koꞌa lia. Sia buka lia kakaer atu nodi nasalak Yesus, tan sia nakara taa ukun mate baa Nia. Mais sia la netan lia kakaer. ");
INSERT INTO tet_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Masik sia natama mataa lia tolek waꞌin atu nodi nahonu Yesus, siakaan lia fuan moos la kona malu. ");
INSERT INTO tet_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nosi ikus, ema ida tenik nariik nodi nataa tolek naꞌak, ");
INSERT INTO tet_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ami rona Ema neꞌe katak naꞌak, ‘Haꞌu atu karoꞌon Uma Hamulak Huun mak ema raiklaran nalo. Toꞌo wainrua, Haꞌu kariik kikar, mais la kodi ema raiklaran liman.’ ” ");
INSERT INTO tet_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mais siakaan dale nia sia moos, la kona malu tenik. ");
INSERT INTO tet_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hotu, naꞌilulik ulun boot nia nariik baa ema hotu-hotu oin, hotu nusu baa Yesus naꞌak, “Ema waꞌin tula sala baa O. Tan saa o no-nook dei?” ");
INSERT INTO tet_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mais, Yesus la nataa kois. Hotu, naꞌilulik ulun boot nia nusu tenik naꞌak, “O katak lai! Hori uluk Naꞌi Maromak nameno kedan atu solok Kristus mai. O neꞌe Kristus, mak Naꞌi Maromak Oan ka?” ");
INSERT INTO tet_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus nataa naꞌak, “Tebes! Haꞌu mak Kristus. Emi hotu-hotu atu haree Haꞌu, Ema Raiklaran Isin neꞌe, kabesi aan kaer ukun iha Naꞌi Maromak mak beran kaliuk sorin kwana. Nosi ikus, Haꞌu moos atu kamaan aan mai kikar kosi laleꞌan kodi kaloꞌan.” ");
INSERT INTO tet_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Rona nola Yesus dale nunia, naꞌilulik ulun boot nia krakat tebes, toꞌo lees nahaat niakaan faru klobor. Hotu, nia katak baa ema nia sia naꞌak, “Ita lalika buka tenik mataa lia ona! ");
INSERT INTO tet_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Emi rona tiꞌan Nia naꞌin duꞌuk katak naꞌak, Nia neꞌe Naꞌi Maromak Oan. Neꞌe naꞌak, Nia dale nahaat Naꞌi Maromak tiꞌan! Tuir itakaan ukun, kalo ema ida nalo aan nuꞌu Maromak, ema nia musti mate! Dadi, ita atu hakotu nunabee?” Rona nola nunia, sia moos nakotu lia naꞌak, “Ema neꞌe, sala tebes. Musti taa ukun mate baa Nia!” ");
INSERT INTO tet_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hotu, ema naꞌin hira soruk baa nodi taniru Yesus. Sia tutus Niakaan matan, hotu taꞌe nakdiuk Nia. Sia naleuk Nia naꞌak, “Kalo O Maromak makoꞌan tebes, O katak kokon see mak taꞌe O nia?” Hotu, sia naruka makdaka Uma Hamulak Huun mai nola Nia nodi baa. Oras sia nodi Yesus baa, sia moos basa nakdiuk Nia. ");
INSERT INTO tet_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Baa oras nia, Petrus sei tuur naniruk haꞌi iha uma nia lalawar. Naꞌilulik ulun boot atan feto ida mai naree Petrus iha nia. Feto nia nahilas diꞌa-diꞌak Petrus oin, hotu nasee naꞌak, “Ohin nia o moos bele-bele mo Yesus, ema Nasaret nia. Tebes ka lale?” ");
INSERT INTO tet_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mais Petrus nataa naꞌak, “Lale! Tan saa o musu nunia?! Haꞌu la katene ema nia!” Hotu, Petrus sai baa nariik iha baꞌa odamatan oin. Baa oras nia moos, manu kokoreek. ");
INSERT INTO tet_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","La oras, feto nia mana tenik Petrus. Hotu, nia foo natene baa ema iha nia sia naꞌak, “Nia neꞌe, ema ida nosi sia!” ");
INSERT INTO tet_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mais, Petrus sakar naꞌak, “O bula arumak! Haꞌu la katene ema nia!” La kleur falik, ema ida seluk nasee Petrus naꞌak, “O keta maktolek tenik maꞌak, o la mamutuk mo ema nia sia! Emi hotu-hotu neꞌe ema Galilea.” ");
INSERT INTO tet_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mais, Petrus sakar tenik naꞌak, “Tuku fatuk! Haꞌu la katene ema nia!” ");
INSERT INTO tet_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Oras Petrus katak nunia, manu moos kokoreek isin rua. Rona nola nunia, Petrus nanoin nola Yesus lia fuan ohin nia naꞌak, “Manu sei la kokoreek isin rua dauk, o meli Haꞌu isin tolu tiꞌan maꞌak, o la matene Haꞌu.” Nanoin nola nunia, Petrus moos tanis no aan. ");
INSERT INTO tet_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Seisawan oan, ema hotu-hotu iha moon-metan nia kabuar lia atu noꞌo Yesus. Hotu, sia kesi Nia, nodi baa gubernur Pilatus, tan gubernur mak bele taa ukun mate baa ema. ");
INSERT INTO tet_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Toꞌo baa, gubernur nusu Yesus naꞌak, “Ema neꞌe sia naꞌak O neꞌe, ema Yahudi Naꞌin. Nunia tebes ka?” Yesus nataa naꞌak, “Tebes! Ama dale nia loos.” ");
INSERT INTO tet_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Oras nia, naꞌilulik ulun sia tula lia waꞌin baa Yesus nodi katak baa gubernur naꞌak, “Ema neꞌe, nalo sala waꞌin tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hotu, Gubernur nusu tenik Yesus naꞌak, “O la rona siakaan dale nia ka? Sia tula sala waꞌin boot baa O. Mataa lai!” ");
INSERT INTO tet_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mais Yesus la nataa kedan, toꞌo Gubernur moos benar. ");
INSERT INTO tet_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sura tinan, natoon baa loron ema Yahudi nadahur Paska, gubernur nabusik ema bui ida tuir ema lear boi. ");
INSERT INTO tet_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Baa tinan nia, noo ema bui ida naran Barabas. Uluk ema kohi nia no niakaan maluk sia, tan sakar ukunrai Roma. Nia moos noꞌo ema. ");
INSERT INTO tet_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tan loron boot sia toꞌo tiꞌan, ema waꞌin baa Gubernur Pilatus nodi nusu naꞌak, “Ama Gubernur! Dahur Paska toꞌo ona! Kalo bele, ama nabusik ema bui ida tuir itakaan adat!” ");
INSERT INTO tet_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Rona nola nunia, Gubernur nataa naꞌak, “Tebes! Mais haꞌu kabusik see? Nunabee kalo kabusik ema Yahudi Naꞌin neꞌe? Bele ka?” ");
INSERT INTO tet_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gubernur nusu nunia, tan natene naꞌak naꞌilulik ulun sia nodi Yesus baa nia, tan sia rai hirus baa Yesus. ");
INSERT INTO tet_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Rona gubernur dale nunia, naꞌilulik ulun sia sasuꞌat ema waꞌin nia, nebee sia hotu-hotu nataa gubernur naꞌak, “Ami la hoꞌuk ema nia! Habusik Barabas dei!” ");
INSERT INTO tet_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hotu, Gubernur nusu tenik naꞌak, “Kalo nunia, haꞌu kmusti kalo saa baa Yesus neꞌe mak emi temi haꞌak, ‘Naꞌi Yahudi’?” ");
INSERT INTO tet_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sia moos nahii bele-bele naꞌak, “Hoꞌo nia dei! Hedi Nia baa ai karuus!” ");
INSERT INTO tet_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hotu, Gubernur nusu tenik naꞌak, “Mais Nia sala saa? Haꞌu kleno Nia tiꞌan, mais la ketan sala ida kois!” Mais sia nahii makaꞌas liu tenik naꞌak, “Hoꞌo nia! Hedi nia baa ai karuus!” ");
INSERT INTO tet_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tan gubernur nakara nalo ema waꞌin nia neon diꞌak, nia moos nabusik Barabas tuir siakaan hakara. Hotu nia naruka sondadu taꞌe noꞌat Yesus nodi oe besi tarak. Noꞌat notu, nia latan Yesus baa sondadu sia, nebee sia nodi baa, nedi noꞌo baa ai karuus. ");
INSERT INTO tet_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nunia hotu, sondadu sia dada nodi Yesus baa lalawar boot ida iha siakaan fatin. Hotu, sia bolu nola siakaan mamaluk klibur boot ida. ");
INSERT INTO tet_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sia moos natais Yesus nodi faru klobor ida. Faru nia ilas mean asuaten, hanesan naꞌin siakaan tais. Hotu, sia nola ai tarak lain, noman nalo baa sabeo tarak. Hotu, tuku natama sabeo tarak nia baa Yesus ulun nodi naleuk nakdiuk Nia, hanesan sia foti naꞌin foun nodi sabeo naꞌin. ");
INSERT INTO tet_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hotu, sia tabe naleuk nia naꞌak, “Tabe, Naꞌi Yahudi!” ");
INSERT INTO tet_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sia asufanu sudur baa Yesus. Sia moos taniru Nia, no taꞌe nakdiuk Niakaan ulun. ");
INSERT INTO tet_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Naleuk nakdiuk Nia notu, sia kolu faru klobor nia, hotu natais nikar Niakaan tais baa. Hotu, sia nodi Nia sai baa kota Yerusalem luan, atu nedi noꞌo baa ai karuus. ");
INSERT INTO tet_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Oras sai nosi Yerusalem, sia nasoru ema ida nosi leo Kirene iha dalan klaran. Ema nia naran Simon. Nia, mak Aleksander no Rufus aman. Oras nia atu tama Yerusalem, sondadu sia kohi nola nia. Hotu sia seten nia natiu Yesus Niakaan ai karuus. ");
INSERT INTO tet_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Hotu, sia dada Yesus toꞌo fatik ida naran Golgota. (Naran neꞌe naꞌak, ‘fatin ulun ruin’.) ");
INSERT INTO tet_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iha nia, sia foo Yesus nemu kokon tua kahur ai moruk, nebee Nia bele terus moras. Mais Yesus la noꞌuk. ");
INSERT INTO tet_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Baa oras takseer tuku siwi seisawan, sia nedi Yesus baa ai karuus, hotu taman ai karuus nia. Nunia hotu, sondadu sia suut liman atu nodi natene see mak bele netan Yesus farun. ");
INSERT INTO tet_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sia moos nakerek baa ai kabelak ida naꞌak, “Ema neꞌe, Naꞌi Yahudi” Hotu, sia nedi ai kabelak nia baa ai karuus iha Yesus ulun fafuhun leten, nebee ema bele natene lia krarain taa ukun mate baa Nia. ");
INSERT INTO tet_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Iha fatin nia sia moos nedi noꞌo ema madauk teen naꞌin rua. Ida iha Yesus sorin kwana, ida iha sorin karuk. ");
INSERT INTO tet_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nodi nalo nunia, sia nalo tuir saa mak hakerek hori uluk iha Hakerek Moon naꞌak, “Ema nalo Nia nuꞌu ema aat.” ");
INSERT INTO tet_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ema hotu-hotu mak laꞌo tuir fatin nia naree Yesus iha ai karuus. Sia nakmulis ibunnodi naleuk Nia naꞌak, “O mak dale maꞌak, O bele maroꞌon Uma Hamulak Huun, hotu baa wainrua O mariik mikar. Tebes ka? ");
INSERT INTO tet_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kalo nunia, sori aan ona, tuun mosi ai karuus nia! Nunia lai, foin ami bele fiar haꞌak, o neꞌe tebe-tebes Naꞌi Maromak Oan!” ");
INSERT INTO tet_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Naꞌilulik ulun sia no manorik ukun sia moos naleuk Yesus naꞌak, “Nia bele sori ema seluk, mais la bele sori aan duꞌuk! ");
INSERT INTO tet_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Uluk Nia naꞌak, Nia neꞌe ‘Kristus’ mak Naꞌi Maromak nameno kedan hori uluk. Ema seluk dale naꞌak, nia neꞌe ema Yahudi Naꞌin. Kalo nunia tebes, habusik Nia tuun duꞌuk nosi ai karuus, nebee ita haree. Nunia tiꞌan, foin ita bele fiar.” Ema madauk teen naꞌin rua iha Yesus sorin moos naleuk Nia. ");
INSERT INTO tet_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nunia hotu, nakukun luri taka nola rai nia nosi loro natetu toꞌo tuku tolu loro malirin. ");
INSERT INTO tet_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Baa oras tuku tolu loro malirin, Yesus nahii nodi siakaan lia Aram naꞌak, “Eloi! Eloi! Lema sabaktani?” (Lia fuan nia naꞌak, “Haꞌukaan Maromak! Haꞌukaan Maromak! Tan saa taliꞌur laꞌo mela Haꞌu nuneꞌe?”) ");
INSERT INTO tet_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Oras ema naꞌin hira mak kreꞌis ai karuus nia rona Yesus lian nia, sia dale baa malu naꞌak, “Rona lai. Nia bolu Elia, mak Maromak makoꞌan uluk nia!” ");
INSERT INTO tet_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hotu, ema ida nalai baa nola wee teen, lobas tama baa tua siin. Nia tuu wee teen nia nodi ai lolon ida, hotu lolo baa Yesus ibun, nebee Yesus modas. Ema nia dale naꞌak, “Hein lai! Ita haree kokon! Arumak Elia mai natuun Nia nosi ai karuus neꞌe.” ");
INSERT INTO tet_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hotu, Yesus nahii tenik nodi lian makaꞌas. Nahii notu, nawan moos kotu. ");
INSERT INTO tet_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iha Uma Hamulak Huun laran no tais odamatan boot ida mak ema nisa nodi neli Naꞌi Maromak Keꞌan Lulik Kaliuk. Natoon baa Yesus nawan kotu, tais odamatan nia naksira faꞌe baa rua nosi leten toꞌo raik. ");
INSERT INTO tet_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iha Golgota, noo sondadu ulun ida mak daka kreꞌis baa Yesus Niakaan ai karuus. Oras naree Yesus mate, nia sarebak nodi naꞌak, “Adeei! Ema neꞌe, Naꞌi Maromak Oan tebes.” ");
INSERT INTO tet_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Iha nia moos noo feto waꞌin mak nariik nosi dook, titu Yesus mate. Uluk, sia mak naliku Yesus no niakaan ema sia iha Galilea. Nosi feto nia sia, noo Salome, Maria nosi leo Magdala, Maria ida tenik (mak Yakobus no Yoses inan) no feto waꞌin tenik mak tuir Yesus mai bele iha Yerusalem. ");
INSERT INTO tet_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Baa oras nia, noo ema boot ida naran Yusuf nosi leo Arimatea. Nia tuur iha moon-metan Yahudi. Nia ema laran diꞌak mak noꞌi nei-nein Naꞌi Maromak kaer ukun. Natene nola Yesus mate tiꞌan, nia buka dalan atu natuun Yesus maten nosi ai karuus. Yesus mate nia, kona baa loron lima. Awan, kona baa ema Yahudi siakaan loron hamulak. Tan lia nia, oras loro atu monu baa loron lima nia, Yusuf nakbiit neon baa nusu kedan Yesus maten nosi gubernur Pilatus. ");
INSERT INTO tet_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Rona Yusuf nusu nunia, gubernur moos blaar hotu katak naꞌak, “Adeei! Ema nia mate tiꞌan ka?! Haꞌu kanoin, sei dauk!” Hotu, gubernur naruka ema baa bolu sondadu ulun mai. Toꞌo mai tiꞌan, gubernur nusu nia naꞌak, “Nunabee? Yesus nia mate tiꞌan ka?” ");
INSERT INTO tet_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sondadu ulun nataa naꞌak, “Nia mate hori ohin tiꞌan ama!” Rona nola nunia, gubernur moos foo leet baa Yusuf atu baa nola Yesus maten. ");
INSERT INTO tet_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hotu, Yusuf baa sosa tais foun ida mak folin todan. Sosa notu, nia baa Golgota. Toꞌo baa, nia natuun nola Yesus maten nosi ai karuus. Hotu, nia falun diꞌa-diꞌak nodi tais foun nia. Baa oras nia, ema foin baꞌat notu fatuk kuak ida atu nadiꞌa kedan rate bodik Yusuf no familin sia. Hotu, Yusuf sia nakelu natama Yesus maten baa rate nia. Hotu, sia dudu nola fatuk boot ida, nodi taka kuak nia. Hotu, sia fila. ");
INSERT INTO tet_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Baa oras nia, Maria nosi Magdala no Maria ida seluk (mak Yoses inan), sia moos tuir toꞌo nebaa. Sia naree diꞌa-diꞌak, nebee bele natene dalan baa rate nia. ");
INSERT INTO tet_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Awan nia, kona loron neen. Loron nia, mak ema Yahudi siakaan loron hamulak. Baa oras loro monu tiꞌan, Salome, Maria nosi leo Magdala, no Maria ida seluk (mak Yakobus inan), sia baa sosa mina morin, nebee awan sia baa nisik Yesus maten tuir siakaan adat. ");
INSERT INTO tet_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Loron domiku seisawan oan, sia naꞌin tolu moos baa rate nia. ");
INSERT INTO tet_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Iha dalan klaran, sia dale baa malu naꞌak, “Adeei! See mak bele dudu sees fatuk boot nia nosi rate odamatan? Fatuk nia boot basuk! Ita neꞌe la biit!” Mais toꞌo baa, sia naree fatuk nia nakduir sai tiꞌan. ");
INSERT INTO tet_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Naree nunia, sia tama baa rate laran. Mais sia sarebak tebe-tebes, tan sia naree mane nurak ida noꞌi tuur iha siakaan sorin kwana. Niakaan tais, mutin naksinak. ");
INSERT INTO tet_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nia katak baa sia naꞌak, “Keta hataꞌuk! Haꞌu katene emi mai buka Yesus, ema Nasaret nia. Ema noꞌo Nia tiꞌan iha ai karuus, mais Nia moris nikar tiꞌan! Mai, haree duꞌuk fatik mak ema rai Niakaan maten baa. Mamuk tiꞌan! ");
INSERT INTO tet_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Diꞌak liu, ina sia fila ona! Baa katak Petrus no niakaan mamaluk sia haꞌak, Yesus moris nikar tiꞌan. Nia laꞌo uluk baa Galilea. Sia musti baa nasoru Nia iha nebaa, tuir saa mak Nia nameno kedan baa sia.” ");
INSERT INTO tet_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hotu, feto nia sia sai nosi rate nia. Sia fila lai-lais tan benar no nataꞌuk. Mais sia la katak lia nia baa ema ida moos iha dalan, tan nataꞌuk tebes. ");
INSERT INTO tet_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Loron domiku seisawan nia, Yesus natadu aan uluk baa Maria nosi leo Magdala. Uluk Yesus teꞌur sai diabu hitu nosi feto neꞌe. ");
INSERT INTO tet_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naree notu Yesus, Maria moos baa kedan katak baa ema hotu-hotu mak uluk tuir Yesus. Sia sei naklibur nodi neon susar no tanis, tan Yesus Niakaan mate. ");
INSERT INTO tet_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Toꞌo baa, Maria katak baa sia naꞌak, “Tan saa emi sei susar? Keta susar ona, tan Yesus moris nikar tiꞌan. Haꞌu kfoin kasoru kola Nia neꞌe!” Mais, sia hotu-hotu katak naꞌak, “Hoi! Keta bosok!” ");
INSERT INTO tet_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Natoon baa nia moos, Yesus Niakaan maktuir naꞌin rua baa leo ida. Toꞌo dalan klaran, Yesus natadu aan baa sia nodi ilas seluk. Mais la oras, sia moos natene Nia. ");
INSERT INTO tet_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Naree nunia, sia moos fila baa katak siakaan mamaluk sia naꞌak, “Hei, rona lai! Ami foin hasoru hola Yesus iha dalan!” Mais siakaan mamaluk sia hotu-hotu deꞌan naꞌak, “Hoi! Keta bosok!” ");
INSERT INTO tet_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nunia hotu, Yesus natadu aan baa Niakaan maktuir naꞌin sanulu resin ida, baa oras sia tuur naa. Nia nasee sia naꞌak, “Hoi! Emi neꞌe ulun fatuk tebe-tebes! Ema katak tiꞌan naꞌak, sia naree Haꞌu nodi matan duꞌuk, mais emi la fiar! Emi haꞌak, bosok! Tan lia nia, oras neꞌe Haꞌu kmai duꞌuk, nebee emi naꞌin haree hodi matan. Haꞌu kmate, mais oras neꞌe Haꞌu kmoris kikar tiꞌan! Haree baa! ");
INSERT INTO tet_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nahuu baa oras neꞌe, emi musti baa raiklaran tomak keke lema Haꞌukaan Lia Diꞌak baa ema hotu-hotu! ");
INSERT INTO tet_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ema mak fiar baa Haꞌu no simu sarani, sia netan moris nima-nimak no Naꞌi Maromak iha laleꞌan. Mais ema mak la fiar, Naꞌi Maromak kastikar sia nodi lelen sia toꞌo nima-nimak. ");
INSERT INTO tet_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ema mak fiar baa Haꞌu atu nalo tadak blaar oi-oik, nebee ema hotu-hotu natene naꞌak, siakaan beran nia nanis mai nosi Naꞌi Maromak. Sia atu teꞌur sai diabu nodi Haꞌukaan naran. Sia atu dale nodi lia fuan seluk mak Naꞌi Maromak natuun baa sia. ");
INSERT INTO tet_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kalo sia kaer samea mahoo raso, lale, sia nemu raso, sia la kona dinu. Kalo sia koko ema moras ulun, nanis ema moras nia moos diꞌak.” ");
INSERT INTO tet_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesus dale notu no Niakaan maktuir sia, Naꞌi Maromak moos foti saꞌe Nia baa laleꞌan. Iha nia, Nia nabesi aan iha Naꞌi Maromak liman kwana nodi kaer ukun namutuk no Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nunia hotu, Yesus Niakaan maktuir sia nalo tuir Niakaan haruka. Sia baa fatin hotu-hotu nodi keke lema Niakaan Lia Diꞌak. Naꞌi Maromak moos natuun beran baa sia, nebee sia nalo tadak blaar mak Yesus katak kedan nia. Ema waꞌin moos fiar baa Yesus, tan sia natene naꞌak, Lia Diꞌak nia, tebes no loos. ");
INSERT INTO tet_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Ama Teofilus mak haꞌu kakneter! Tabe. Ema waꞌin nakerek kokon tiꞌan lia nosi Yesus mak dadi iha amikaan leet, mak natoꞌo Naꞌi Maromak mamenon hori uluk. Sia nakerek lia Yesus nia, nodi libur lia mak uluk ami dale hosi ibun baa ibun, no lia mak ami rona hosi Yesus eman sia, no lia mak ami rona hosi ema seluk mak naree nodi matan duꞌuk. Haꞌu kleno lotu-lotuk lia nia sia hotu-hotu, kosi huun toꞌo rohan. Hotu, haꞌu kakotu atu kakerek kalo ta-taek. Hodi nunia, ama bele natene malorek. ");
INSERT INTO tet_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ama moos bele fiar lia mak ama rona tiꞌan nia, lahoos lia tolek, mais lia tebes. ");
INSERT INTO tet_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lia nosi Yesus huun nuneꞌe: Baa oras Naꞌi Herodes kaer ukun iha rai Yudea, noo katuas ida naran Sakarias. Nia, naꞌilulik Yahudi nosi Bei Abia klibur naꞌilulik sia. Sakarias feen, naran Elisabet. Nia moos nosi naꞌilulik husar-binan, tan nia, husar-binan nosi Bei Musa alin Harun. ");
INSERT INTO tet_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sia rua moris moon tuir Naꞌi Maromak harukan no ukun-badu hotu-hotu. Ema moos nakneter sia. ");
INSERT INTO tet_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sia rua otas tiꞌan, mais la noo oan tan Elisabet kiuk. ");
INSERT INTO tet_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Baa loron ida, Sakarias no naꞌilulik seluk sia nosi klibur Abia netan leet atu serwisu iha Uma Hamulak Huun iha kota Yerusalem. ");
INSERT INTO tet_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tuir siakaan adat, naꞌilulik sia suut liman, atu nodi natene see mak netan leet atu tama baa Keꞌan Lulik Kaliuk, nebee sunu ai morin iha Naꞌi Maromak oin. Baa loron nia, suut liman kona baa Sakarias. ");
INSERT INTO tet_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hotu, Sakarias tama baa. Baa oras nia sunu ai morin iha Keꞌan nia, ema lear namulak iha lalawar. ");
INSERT INTO tet_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Teki-tekis, Maromak Niakaan makbukar laleꞌan ida natadu aan iha ai morin fatin sorin kwana. ");
INSERT INTO tet_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Naree nunia, Sakarias nataꞌuk tebes. ");
INSERT INTO tet_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mais makbukar laleꞌan nia katak naꞌak, “Sakarias! Keta mataꞌuk! Naꞌi Maromak rona tiꞌan okaan hamulak. Okaan feen atu nahoris oa mane ida bodik o. O musti manaran oan nia maꞌak, Yohanis. ");
INSERT INTO tet_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Oan nia atu nalo o neon boot. Ema waꞌin moos neon diꞌak bele-bele no o, tan oan nia. ");
INSERT INTO tet_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nahuu nosi inan sei koꞌus, Kmalar Lulik tuun baa oan nia tiꞌan. Nia musti naluli nemu lanuk hotu-hotu. Baa oras boot tiꞌan, Naꞌi Maromak atu foti nia baa ema mak noo folin. ");
INSERT INTO tet_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nia atu namaus ema Israꞌel waꞌin atu fila tuir Naꞌi Maromak, dadi baa siakaan Ulun. ");
INSERT INTO tet_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Oan nia lisan no beran nuꞌu Bei Elia, mak Maromak makoꞌan hori uluk. Oan nia mai uluk lai, foin Naꞌi Maromak solok Niakaan ema mak Nia nameno kedan hori uluk. Oan nia atu nalo ina-ama sia nadomi nikar siakaan oan. Ema mak seꞌi kotuk baa Naꞌi Maromak, nia atu filas sia nebee tuir nikar Naꞌi Maromak. Hodi nunia, nia nalo ema nadiꞌa neon atu simu Naꞌi Maromak eman mak Nia nameno tiꞌan nia.” ");
INSERT INTO tet_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Makbukar laleꞌan dale notu nunia, Sakarias nusu fila naꞌak, “Nunabee lia nia bele dadi? Haꞌu ko haꞌukaan feen otas tiꞌan! Oinsaa haꞌu kbele katene kaꞌak dale nia tebes?” ");
INSERT INTO tet_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Makbukar laleꞌan nataa naꞌak, “Nuneꞌe! Haꞌu neꞌe, Gabriel, Maromak Niakaan makbukar. Nia duꞌuk naruka haꞌu kmai katak lia diꞌak neꞌe baa o. ");
INSERT INTO tet_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mais, tan o la fiar baa haꞌukaan dalen, o atu metan tadak nuneꞌe: nahuu baa oras neꞌe toꞌo oan nia moris, okaan nanaan dadi matek. Hodi nunia, o bele matene duꞌuk, saa mak haꞌu kdale neꞌe atu dadi tebes, kona baa niakaan oras.” ");
INSERT INTO tet_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oras makbukar laleꞌan dale no Sakarias nunia, ema lear mak namulak iha luan benar karin, tan Sakarias la sai. ");
INSERT INTO tet_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mais baa oras nia sai mai, nia la bele dale ona. Nia foo tadak baa sia nodi liman, foin sia natene naꞌak Naꞌi Maromak natudu lia blaar ida baa nia iha Keꞌan Lulik Kaliuk nia. ");
INSERT INTO tet_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Serwisu mohu, Sakarias fila uma. ");
INSERT INTO tet_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","La kleur, Elisabet moos koꞌus. Nia namuka aan fulan lima laran nodi dale naꞌak, “Tonu Naꞌi Maromak! Nosi ikus Naꞌi Maromak natudu laran diꞌak baa haꞌu. Kalo haꞌu ketan husar-binan tiꞌan, ema la namoe haꞌu ona.” ");
INSERT INTO tet_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Baa oras Elisabet koꞌus tama fulan neen tiꞌan, Naꞌi Maromak solok Niakaan makbukar laleꞌan Gabriel baa leo ida naran Nasaret iha rai Galilea. ");
INSERT INTO tet_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iha nia noo feto nurak ida, naran Maria. Nia sasudin tiꞌan no mane ida, naran Yusuf. Yusuf nia, Naꞌi Daud husar-binan. Gabriel baa nasoru Maria, ");
INSERT INTO tet_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","hotu nia nareꞌis aan baa feto nurak nia nodi naꞌak, “Tabe! Naꞌi Maromak boi bete tiꞌan atu nalo lia kabaas ida bodik bete. Naꞌi Maromak namutuk no bete.” ");
INSERT INTO tet_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Rona nola nunia, Maria benar. La natene lia nia naꞌak saa. ");
INSERT INTO tet_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hotu makbukar nia natutan naꞌak, “Maria! Lalika mataꞌuk. Tan Naꞌi Maromak atu natudu laran diꞌak baa o. ");
INSERT INTO tet_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","La kleur, o atu koꞌus. Hotu, o atu mahoris oa mane ida. Musti manaran Nia maꞌak, Yesus. ");
INSERT INTO tet_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nia atu dadi ema boot. Naꞌi Maromak atu temi Nia naꞌak, ‘Haꞌukaan Oan.’ Nia, Oa nosi Naꞌi Maromak Mak Aas Kaliuk. Naꞌi Maromak atu foti Nia kaer ukun, nuꞌu Niakaan Bei Daud. ");
INSERT INTO tet_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nia atu kaer ukun nima-nimak baa ema Israꞌel sia. Niakaan ukun atu nafati nohuun.” ");
INSERT INTO tet_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Rona nola nunia, Maria nusu baa Gabriel naꞌak, “Haꞌu neꞌe sei la katene mane dauk! Nunabee haꞌu kbele koꞌus?” ");
INSERT INTO tet_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gabriel nataa naꞌak, “Nuneꞌe bete! Maromak Kmalar Lulik atu tuun baa o. Beran nosi Maromak Mak Aas Kaliuk moos atu taka nola o. Hodi nunia, Oa mak atu moris nia, moon tebe-tebes tan Nia, Naꞌi Maromak Oan. ");
INSERT INTO tet_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Keta blaar! Bete familin ida naran Elisabet moos koꞌus tiꞌan. Tuir ema, nia la bele nahoris ona tan otas tiꞌan. Mais baa oras neꞌe, nia koꞌus fulan neen laran tiꞌan, ");
INSERT INTO tet_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","tan la noo lia ida mak Naꞌi Maromak la bele nalo!” ");
INSERT INTO tet_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Rona nola nunia, Maria nataa naꞌak, “Diꞌak. Haꞌu neꞌe, Naꞌi Maromak atan. Haꞌu kadiꞌa aan simu Niakaan hakaran. Nebee, lia hotu-hotu neꞌe dadi tuir saa mak o dale tiꞌan nia.” Nunia hotu, makbukar laleꞌan nia laꞌo nela Maria. ");
INSERT INTO tet_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Loron hira siku tiꞌan, Maria laꞌo nela Nasaret, lai-lais baa Sakarias leon iha rai Yudea foho leten. Toꞌo nebaa, nia tama baa Sakarias uman nodi foo tabe baa Elisabet. ");
INSERT INTO tet_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Baa oras Elisabet rona Maria foo tabe, oa iha niakaan notak nakfodak. Elisabet moos nakonu no Maromak Kmalar Lulik. ");
INSERT INTO tet_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hotu, nia dale nodi makaꞌas naꞌak, “Maria! Ema atu foti-nahaas okaan naran liu feto hotu-hotu iha raiklaran neꞌe! Sia moos atu foti-nahaas oa mak iha okaan notak! ");
INSERT INTO tet_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Haꞌu neon boot, tan haꞌukaan Naꞌin inan mai nateke haꞌu. ");
INSERT INTO tet_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Oras o tama foo tabe baa haꞌu, oa iha haꞌukaan notak nakfodak kedas, tan neon diꞌak. ");
INSERT INTO tet_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Naꞌi Maromak natudu laran diꞌak baa o, tan o fiar maꞌak, Nia atu nalaꞌok Niakaan mamenon.” ");
INSERT INTO tet_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hotu Maria foti lian naꞌak, “Haꞌu kfoti-kahaas no tonu-kaboot Naꞌi Maromak kodi neon no laran tomak. ");
INSERT INTO tet_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Haꞌu neon diꞌak, tan Naꞌi Maromak, mak haꞌukaan Maksorin. ");
INSERT INTO tet_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nia tau matan baa haꞌu, rai matan baa haꞌu, masik haꞌu neꞌe, Niakaan ata mak la folin. Nahuu baa oras neꞌe, ema hotu-hotu nafoli haꞌu naꞌak, feto mak sotir basuk, ");
INSERT INTO tet_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tan Naꞌi Maromak naseꞌi lia boot bodik haꞌu. Nia, mak Beran Kaliuk, Lulik Kaliuk. ");
INSERT INTO tet_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nia natudu dadomin baa ema hotu-hotu mak nakneter no loꞌu baa Nia, nosi husar-binan ida baa husar-binan ida. ");
INSERT INTO tet_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nia nodi Niakaan beran, atu tokar lauk ema mak loko aan, no ema mak naksaꞌek aan. ");
INSERT INTO tet_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nia natuun makaer ukun mak nahaas aan. Mais Nia nahaas ema mak naraik aan. ");
INSERT INTO tet_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nia nahaan ema salaen toꞌo bosu, mais teꞌur nasai ema maksoin sia nebee sia laꞌo nodi liman mamuk. ");
INSERT INTO tet_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nia tulun Niakaan ema Israꞌel sia, tan Nia nadomi sia nohuun. ");
INSERT INTO tet_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Uluk Nia namate menon no itakaan bei uluk, mak Bei Abraham no niakaan husar-binan hotu-hotu. Baa oras neꞌe, mamenon nia metin nafati.” ");
INSERT INTO tet_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tonu notu nunia, Maria nein no Elisabet toꞌo fulan tolu laran. Foin nia fila baa Nasaret. ");
INSERT INTO tet_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet loron nahoris toꞌo tiꞌan, nia moos nahoris oa mane ida. ");
INSERT INTO tet_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hotu lia nia keke lema baa familin no ema leo laran sia naꞌak, Naꞌi Maromak natudu tiꞌan laran diꞌak nodi foo oa ida baa Elisabet. Rona nola nunia, sia hotu-hotu moos neon diꞌak. ");
INSERT INTO tet_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Oan nia otas loron walu tiꞌan, sia nalo lahan hamane aan baa nia, tuir ema Yahudi ukun-badu. Sia nakara nanaran nia Sakarias, tuir aman naran. ");
INSERT INTO tet_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mais inan la noꞌuk naꞌak, “La bele nunia! Musti hanaran nia Yohanis!” ");
INSERT INTO tet_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mais sia nataa naꞌak, “Tan saa mili naran Yohanis? La noo ema ida iha emikaan familin mak tau naran nia!” ");
INSERT INTO tet_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hotu sia foo tadak baa Sakarias atu nodi natene nia nakara tau naran saa baa oa nia. ");
INSERT INTO tet_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hotu Sakarias foo tadak nodi nusu fatuk hakerek. Sia foo baa, nia nakerek naꞌak, “Naran Yohanis!” Naree nunia, ema nia sia hotu-hotu moos blaar karin. ");
INSERT INTO tet_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Baa oras nia moos, Sakarias nanaan matek nia, mamar kedas. Nia moos tonu kedan Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ema hotu-hotu iha nia, nataꞌuk no blaar. Lia nia keke lema nosi ibun baa ibun, toꞌo ema iha rai Yudea foho leten sia moos natene hotu. ");
INSERT INTO tet_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ema mak rona lia nia nanoin naꞌak, “Malorek tebes! Naꞌi Maromak beran tuun baa oan nia. Nia boot mai, nia atu dadi saa?” ");
INSERT INTO tet_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Baa oras nia, Sakarias nakonu no Maromak Kmalar Lulik. Hotu nia dale naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Haꞌu ktonu-kaboot haꞌukaan Naꞌin. Nia, mak ema Israꞌel siakaan Maromak! Nia namaan aan mai tiꞌan atu sori Niakaan hutun-renu nosi moris nuꞌu ata. ");
INSERT INTO tet_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nia foti tiꞌan Ema ida nosi Naꞌi Daud husar-binan. Ema nia atu sori ita, nodi Niakaan beran boot. ");
INSERT INTO tet_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Naꞌi Maromak nameno kedan lia nia hori uluk, nodi Niakaan makoꞌan moon sia. ");
INSERT INTO tet_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Oras neꞌe, Nia loke dalan atu nabusik ita nosi funu, no nosi ema mak laran moras baa ita. ");
INSERT INTO tet_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Nia natudu laran diꞌak baa itakaan bei uluk sia, tan nanoin bei-beik Niakaan mamenon mak Nia namate hori uluk no Bei Abraham. ");
INSERT INTO tet_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nia nabusik ita nosi funu, nebee ita bele loꞌu baa Nia, no la hataꞌuk tenik. ");
INSERT INTO tet_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nia nabusik ita nebee ita bele moris moon no loos iha Niakaan oin nohuun. ");
INSERT INTO tet_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yohanis! O neꞌe, haꞌukaan oan. O boot mai, ema atu natene naꞌak, o neꞌe, makoꞌan baa Maromak Mak Aas Kaliuk. O atu baa katak ema, nebee sia simu Naꞌin namaan aan mai. ");
INSERT INTO tet_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","O atu baa matudu dalan baa Niakaan eman sia, nebee sia natene naꞌak, sia bele moris no Naꞌi Maromak, tan Nia kasu siakaan salan. ");
INSERT INTO tet_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Naꞌi Maromak neon monu baa ita, toꞌo Nia foo leet foun baa ita, nuꞌu loro foun nasai kroman foun. Bodik ita mak moris iha makukun laran, no ita mak hataꞌuk mate, kroman mai tiꞌan atu nalaꞌo ita baa dalan dame.” ");
INSERT INTO tet_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nunia hotu, Yohanis hetak kleur, hetak boot. Maromak Kmalar Lulik moos nakbiit nia. Boot tiꞌan, nia baa nein iha rai fuik, toꞌo nahuu nalaꞌok serwisu bodik ema Israꞌel. ");
INSERT INTO tet_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Baa oras Kireneus dadi gubernur iha Siria, Liurai Agustus nasai ukun naꞌak, “Ema hotu-hotu mak iha ukunrai Roma liman laran, ida-idak musti fila baa natama naran iha leo huun!” Oras nia, oras dala uluk bodik ukunrai Roma sura hutun-renu nunia. ");
INSERT INTO tet_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tan nia, ema hotu-hotu fila baa leo huun atu natama naran. ");
INSERT INTO tet_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Baa oras nia, noo mane ida naran Yusuf. Nia nein iha leo Nasaret iha rai Galilea. Nia sasudin tiꞌan no feto nurak ida, naran Maria. Maria nia noꞌi koꞌus. Tan Yusuf nia, Naꞌi Daud husar-binan, nia musti fila baa natama naran iha Naꞌi Daud niakaan kota Betlehem iha rai Yudea. Tan lia nia, sia rua baa kota Betlehem. ");
INSERT INTO tet_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Toꞌo nebaa, Maria loron nahoris moos toꞌo mai. ");
INSERT INTO tet_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Iha Betlehem nia, noo uma bodik ema hein heik, mais sia la netan fatik iha nia. Tan baa nia, sia tama baa natar ida laran. Iha nia Maria nahoris oa ulun, oa mane ida. Maria nafuꞌut Nia nodi tais, hotu natoba baa bibi no karau haan fatik. ");
INSERT INTO tet_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Baa kalan nia, makbalin naꞌin hira daka bibi malae iha kota luan. ");
INSERT INTO tet_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Teki-tekis, sia naree Maromak Niakaan makbukar laleꞌan ida. Hotu, Naꞌi Maromak kroman naksinak baa sia, toꞌo sia nataꞌuk liu. ");
INSERT INTO tet_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mais makbukar nia katak naꞌak: “Keta hataꞌuk! Rona mai! Haꞌu kmai katak lia diꞌak baa emi. Ema hotu-hotu mak rona lia neꞌe, nanis neon diꞌak. ");
INSERT INTO tet_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lia diꞌak nia nuneꞌe: Baa loron neꞌe, feto ida nahoris Kristus iha Betlehem, Naꞌi Daud niakaan kota! Kristus nia, mak Naꞌi Maromak nameno tiꞌan hori uluk. Naꞌi Maromak solok Nia mai atu sori ema nosi sala! Nia neꞌe, mak ema atu temi naꞌak ‘Ulun’! ");
INSERT INTO tet_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Emi bele hatene Nia nuneꞌe: Emi atu hasoru kau mea oan ida mak inan nafuꞌut nodi tais. Nia toba iha bibi no karau haan fatik laran.” ");
INSERT INTO tet_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Teki-tekis, Maromak Niakaan makbukar laleꞌan lear mai namutuk no makbukar uluk nia. Sia tonu-naboot Naꞌi Maromak nodi nananu naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ita foti-hahaas Naꞌi Maromak naran! Nia mak nabesi aan kaer ukun iha laleꞌan mak aas kaliuk. Nia atu foo dame baa ema raiklaran mak kona baa Niakaan neon!” ");
INSERT INTO tet_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hotu makbukar sia fila baa laleꞌan. Makbalin nia sia dale baa malu naꞌak, “Hei! Mai ita baa Betlehem atu haree oa nia lai! Tan Naꞌi Maromak solok lia nia baa ita tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hotu, sia lai-lais baa Betlehem. Toꞌo nebaa, sia netan Maria no Yusuf no kau mea oan mak noꞌi toba iha bibi no karau haan fatik laran. ");
INSERT INTO tet_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Naree oa nia, sia moos katak baa ema naꞌak, “Ohin nia, Maromak Niakaan makbukar laleꞌan sia katak lia oa neꞌe baa ami!” Hotu sia katak lia nia toꞌo mohu. ");
INSERT INTO tet_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ema hotu-hotu mak rona, blaar karin. ");
INSERT INTO tet_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mais Maria rai lia nia sia baa neon laran, nodi naneo atu buka lia nia sia isin. ");
INSERT INTO tet_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Makbalin sia naree notu oa nia, sia moos fila nikar baa siakaan bibi malae. Sia tonu-naboot Naꞌi Maromak naran nodi sera dodan baa Nia, tan saa mak sia rona no sia naree, manesak no saa mak Maromak Niakaan makbukar dale tiꞌan baa sia. ");
INSERT INTO tet_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kau mea oa nia, otas loron walu tiꞌan, sia nalo lahan hamane aan baa Nia, tuir ema Yahudi siakaan ukun-badu. Niakaan inan no aman nanaran Nia, ‘Yesus’. Naran nia mak uluk makbukar laleꞌan katak kedan baa oras Yesus inan sei la koꞌus Nia dauk. ");
INSERT INTO tet_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ukun-badu ida nosi Bei Musa naꞌak, feto mak nahoris loron haat nulu tiꞌan, musti nalaꞌok adat hamoos aan iha Uma Hamulak Huun. Hodi nunia, nia bele tama nikar baa ema Yahudi siakaan uma hamulak. Tan nunia, Yusuf no Maria baa nalaꞌok adat nia iha kota Yerusalem. Sia moos nodi siakaan oan Yesus baa Uma Hamulak Huun, atu latan baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hodi nunia, sia tuir Naꞌi Maromak ukun-badu mak naꞌak, “Feto mak nahoris oa ulun mak mane, musti latan oan nia baa Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tuir Naꞌi Maromak ukun-badu, kalo inan no aman latan oan baa Naꞌi Maromak, sia musti sera lakateu inan ida no aman ida, lale, lakateu sina tulan matan rua. Yusuf no Maria moos nalaꞌok ukun-badu nia. ");
INSERT INTO tet_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Natoon baa nia, noo katuas ida naran Simeon. Nia nein iha kota Yerusalem. Nia ema moon mak beer Naꞌi Maromak. Kmalar Lulik katak kedan baa nia tiꞌan naꞌak, nia atu naree uluk Kristus lai, foin nia bele mate. ");
INSERT INTO tet_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Baa oras Yesus inan no aman nodi Nia baa Uma Hamulak Huun atu latan baa Naꞌi Maromak, Kmalar Lulik moos nalaꞌo nodi Simeon baa. ");
INSERT INTO tet_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Oras naree oan nia, katuas Simeon nakaꞌu nola, nodi tonu-naboot Naꞌi Maromak naꞌak: ");
INSERT INTO tet_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Haꞌu ktonu Naꞌi Maromak! Tan Nia nalaꞌok mamenon baa haꞌu tiꞌan. Oras neꞌe, Naꞌi Maromak bele nabusik haꞌu, nebee haꞌu kmate no-nook ona. ");
INSERT INTO tet_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Haꞌu karee tiꞌan Ema mak Naꞌi Maromak solok mai atu sori ita nosi itakaan salan! ");
INSERT INTO tet_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Naꞌi Maromak nakara nodi oan neꞌe atu sori ema klubun hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nia atu dadi hanesan kroman. Nia atu nodi kneter bodik Naꞌi Maromak eman Israꞌel sia. Nia moos atu natudu Naꞌi Maromak dalan loos baa ema seluk sia.” ");
INSERT INTO tet_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Rona nola nunia, Yusuf no Maria blaar karin tan katuas Simeon nasee nunia. ");
INSERT INTO tet_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hotu, Simeon nusu matak-malirin bodik sia. Nia moos katak kedan baa Maria naꞌak, “Yesus inan! Ema waꞌin iha Israꞌel neꞌe atu dudu sees oan neꞌe. Mais nosi ikus, siakaan hahalok nia atu nahonu fila sia. Oan neꞌe moos atu nalo ema waꞌin neon boot. ");
INSERT INTO tet_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Hodi nunia, Naꞌi Maromak loke hotu ema neon. Mais rona! Ina atu hetan susar todan, hanesan surik naruk sona borut okaan hirus.” ");
INSERT INTO tet_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Iha Uma Hamulak Huun nia moos, noo ferik ida naran Hana. Niakaan otas tinan walu nulu resin haat tiꞌan. Aman, naran Fanuel, nosi ema hunun Aser. Ferik nia foin noo laꞌen tinan hitu, laꞌen mate nela tiꞌan. Ferik nia moos Maromak makoꞌan ida mak namulak no nalirin aan loron-kalan iha Uma Hamulak Huun. ");
INSERT INTO tet_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Baa oras Simeon dale baa Yusuf no Maria, ferik nia mai kre-reꞌis nanono sia. Nia rona Simeon dale nunia, nia tonu-naboot Naꞌi Maromak. Nia moos dale kedan lia Yesus bodik ema hotu-hotu mak sei noꞌi nei-nein siakaan Naꞌin mak Naꞌi Maromak nameno atu solok mai sori ema Israꞌel. ");
INSERT INTO tet_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusuf no Maria nalaꞌok mohu Bei Musa Ukun-badu sia iha kota Yerusalem tiꞌan, sia moos fila baa siakaan leo Nasaret iha rai Galilea. ");
INSERT INTO tet_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Hotu Yesus hetak boot, hetak biit, hetak matenek toꞌo natene lia waꞌin. Naꞌi Maromak moos natudu laran diꞌak baa Nia. ");
INSERT INTO tet_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sura tinan, Yusuf no Maria baa kota Yerusalem atu tuir nadahur Paska. ");
INSERT INTO tet_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Dala ida, baa oras Yesus otas tinan sanulu resin rua, sia baa kota Yerusalem bele-bele atu tuir dahur nia. ");
INSERT INTO tet_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Dahur Paska nia hotu tiꞌan, Yusuf no Maria fila baa Nasaret no ema lear mak fila bele-bele baa rai Galilea. Sia la natene naꞌak, Yesus sei nein iha Yerusalem. Sia naneo naꞌak, Nia laꞌo namutuk no Niakaan mamaluk sia. Mais toꞌo loro malirin, sia sei la naree Nia dauk. Hotu sia buka baa-mai iha siakaan familin no mamaluk sia. ");
INSERT INTO tet_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mais sia la netan, sia fila nikar baa buka Nia iha Yerusalem. ");
INSERT INTO tet_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Toꞌo nebaa, sia buka Nia loron tolu laran, foin netan iha Uma Hamulak Huun. Nia noꞌi taruka lia fuan no ema manorik ukun Yahudi sia. ");
INSERT INTO tet_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ema hotu-hotu mak tuur nanono, blaar karin, tan Nia natene tebe-tebes Hakerek Moon isin. Nia moos nataa sia diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Naree nola nunia, Yesus inan no aman moos blaar. Hotu inan katak naꞌak, “Yesus! Tan saa O masusar ami nuneꞌe? Ami rua O aman benar karin tiꞌan buka O!” ");
INSERT INTO tet_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mais Yesus nataa naꞌak, “Tan saa ina no ama hasusar aan buka Haꞌu? Musti hatene! Haꞌu koo serwisu iha Haꞌukaan Ama Uman.” ");
INSERT INTO tet_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mais sia la natene Niakaan hakara nia. ");
INSERT INTO tet_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nunia hotu, sia fila nikar bele-bele baa Nasaret. Yesus moris tuir inan no aman harukan. Niakaan ina rai lia nia sia hotu-hotu baa neon laran. ");
INSERT INTO tet_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nunia ona, Yesus hetak boot, hetak matenek. Nia moos hetak kona baa Naꞌi Maromak neon no ema raiklaran neon. ");
INSERT INTO tet_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Baa oras nia, Tiberius mak liurai Roma. Nia kaer ukun tinan sanulu resin lima tiꞌan. Pontius Pilatus, mak gubernur rai Yudea. Herodes, mak gubernur rai Galilea. Herodes maun Filipus, mak gubernur rai Iturea no rai Trakonitis. Lisanas, mak gubernur rai Abilene. Baa oras nia moos, Hanas no Kayafas, mak naꞌilulik ulun boot iha kota Yerusalem. Natoon baa oras nia, Yohanis, Sakarias oan, nein iha fatin fuik dook nosi leo. Iha nebaa, Naꞌi Maromak tau lia baa nia. ");
INSERT INTO tet_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Rona nola tiꞌan, Yohanis baa leo hotu-hotu mak kreꞌis baa mota Yordan, atu katak ema naꞌak, “Emi musti katak sain no laꞌo hela emikaan salan sia, nebee Naꞌi Maromak kasu mohu hotu-hotu. Hotu, emi musti simu sarani, hanesan marak ida naꞌak, emi neꞌe diꞌa-diꞌak tiꞌan ho Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Uluk, Maromak makoꞌan Yesaya nakerek nola lia nosi Yohanis nia nuneꞌe: “Noo ema ida iha rai fuik mak nahii naꞌak: ‘Hadiꞌa dalan atu simu Naꞌin namaan aan mai! Hamoos dalan atu simu Nia. ");
INSERT INTO tet_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tunin haweer sura horun. Taa haweer sura foho. Haloos dalan kaleꞌuk sia. Haweer dalan karutas sia. ");
INSERT INTO tet_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nebee ema rai hotu-hotu bele natene naꞌak, Naꞌi Maromak nakara sori ema nosi siakaan salan.’ ” ");
INSERT INTO tet_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Baa oras nia ema mai nosi fatin hotu-hotu, atu nusu Yohanis sarani sia. Mais nia nakanas sia naꞌak, “Hoi! Tolek teen sia! Emi nuꞌu samea mak noo raso! Keta haneo haꞌak, emi bele hakbois hosi Naꞌi Maromak kastikar! Lale! Tan la kleur ona, Naꞌi Maromak natuun kastikar baa ema hotu-hotu mak la diꞌak no Nia. ");
INSERT INTO tet_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Keta haneo haꞌak, emi la hetan kastikar tan emi Bei Abraham husar-binan. Lale! Emi Bei Abraham husar-binan tebes, mais lia nia la nalo emi moon. Naꞌi Maromak bele nalo fatuk neꞌe sia dadi baa Bei Abraham husar-binan. Haꞌu katak emi. Hatudu kakaer hodi emikaan moris, nebee ema natene tebe-tebes naꞌak, emi seꞌi kotuk tiꞌan laꞌo hela emikaan salan sia, hodi tuir hikar Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Emi musti halo lia diꞌak sia. Kalo lale, Naꞌi Maromak natuun kastikar todan baa emi, hanesan ema nodi baliun nuꞌan ai huun. Nunia tebes! Ai huun la noo folin, kalo la nafua diꞌak! Diꞌak liu huꞌan, soe baa haꞌi dei.” ");
INSERT INTO tet_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Rona nola Yohanis dale nunia, ema nia sia nusu nia naꞌak, “Kalo nunia, ami musti halo saa?” ");
INSERT INTO tet_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nia nataa naꞌak, “Kalo moo faru tahan rua, foo tahan ida baa ema faru lalek. Kalo moo haan, faꞌe foo baa ema haan lalek.” ");
INSERT INTO tet_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ema maksisi bea sia moos mai nusu baa Yohanis, nebee nia sarani sia. Sia nusu naꞌak, “Ama boot! Tulun hanorin ami atu halo saa.” ");
INSERT INTO tet_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nia nataa naꞌak, “Uluk, emi tolek teen. Mais oras neꞌe, emi musti serwisu halo loos. Keta husu bea liu nosi ukun. Nebee hutun-renu selu bea kona besik no ukun-badu.” ");
INSERT INTO tet_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sondadu naꞌi hira moos iha nia. Sia nusu baa Yohanis naꞌak, “Kalo ami, nunabee? Ami musti halo saa?” Nia nataa naꞌak, “Keta todak ema niakaan osan tuir emikaan hakara. Keta duu karin ema. Oras simu kansera, musti neon boot hodi horan toꞌo.” ");
INSERT INTO tet_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Rona Yohanis dale nunia, ema hotu-hotu kebit malu nodi namaas baa malu naꞌak, “Hoi! Keta arumak Yohanis neꞌe. Kristus mak hori uluk Naꞌi Maromak nameno atu solok mai!” ");
INSERT INTO tet_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mais Yohanis katak baa sia naꞌak, “Rona diꞌa-diꞌak! Ema ida mak boot liu haꞌu atu mai. Masik haꞌu kdadi baa niakaan atan moos, haꞌu la kfatan. Haꞌu ksarani ema kodi wee dei, mais Nia atu nalo liu tan haꞌu, tan Nia atu nakonu emikaan neon no laran nodi Maromak Kmalar Lulik. Nia atu namoos emi, hanesan badaen mean namoos mean nodi haꞌi, atu soe mean teen, nebee netan mean isin. ");
INSERT INTO tet_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nia moos hanesan ema mafaho rai laliki nasai hare abas. Nia rai hare moos baa kanaha laran, mais namotu hare abas. Nunia moos Naꞌi Maromak. Nia atu kastikar ema mak seꞌi kotuk baa Nia, nodi soe lakon sia baa haꞌi laran mak laka bei-beik.” ");
INSERT INTO tet_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hodi nunia, Yohanis foo natene lia oi-oik baa ema, nodi katak Naꞌi Maromak Manfatin Diꞌak baa sia. ");
INSERT INTO tet_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Baa oras nia moos, Yohanis nahuu dale malorek Herodes niakaan hahalok aat sia. Niakaan lia nuneꞌe: Herodes nia, gubernur rai Galilea. Niakaan salan butuk bein tiꞌan. Nia moos nadau nola alin feen, naran Herodias. Mais tuir loos, alin sei moris no sei la soe malu dauk no feen Herodias. Tan Herodes hahalok aat nia sia, Yohanis deꞌan nia loke fore, toꞌo Herodes krakat, hotu kohi nola nia, soe baa bui. ");
INSERT INTO tet_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Uluk, oras Herodes sei la kohi Yohanis dauk, Yohanis sarani ema waꞌin. Nia moos sarani Yesus. Sarani hotu, Yesus namulak. Oras nia moos, laleꞌan nakloke. ");
INSERT INTO tet_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Hotu Maromak Kmalar Lulik namaan aan tuun baa Yesus. Kmalar Lulik nia ilas nuꞌu lakateu sina. Baa oras nia moos, noo lia maliak ida nosi laleꞌan naꞌak: “O neꞌe, Haꞌukaan Oan mak Haꞌu kakara no kadomi. O malo Haꞌu neon diꞌak.” ");
INSERT INTO tet_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Baa oras Yesus nahuu katak lia nosi Naꞌi Maromak, Niakaan otas takseer tinan tolu nulu. Ema natene Yesus nia, Yusuf oan. Yusuf bein uluk sia mak neꞌe: Yusuf aman, Eli. ");
INSERT INTO tet_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli aman, Matat. Matat aman, Lewi. Lewi aman, Melki. Melki aman, Yanai. Yanai aman, Yusuf. ");
INSERT INTO tet_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf aman, Matatias. Matatias aman, Amos. Amos aman, Nahum. Nahum aman, Hesli. Hesli aman, Nagai. ");
INSERT INTO tet_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai aman, Maat. Maat aman, Matatias. Matatias aman, Semein. Semein aman, Yosek. Yosek aman, Yoda. ");
INSERT INTO tet_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda aman, Yohanan. Yohanan aman, Resa. Resa aman, Serubabel. Serubabel aman, Sealtiel. Sealtiel aman, Neri. ");
INSERT INTO tet_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri aman, Melki. Melki aman, Adi. Adi aman, Kosam. Kosam aman, Elmadam. Elmadam aman, Er. ");
INSERT INTO tet_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er aman, Yosua. Yosua aman, Elieser. Elieser aman, Yorim. Yorim aman, Matat. Matat aman, Lewi. ");
INSERT INTO tet_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi aman, Simeon. Simeon aman, Yahuda. Yahuda aman, Yusuf. Yusuf aman, Yonam. Yonam aman, Elyakim. ");
INSERT INTO tet_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim aman, Melea. Melea aman, Mena. Mena aman, Matata. Matata aman, Natan. Natan aman, Daud. ");
INSERT INTO tet_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud aman, Isai. Isai aman, Obed. Obed aman, Boas. Boas aman, Salmon. Salmon aman, Nahason. ");
INSERT INTO tet_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason aman, Aminadab. Aminadab aman, Admin. Admin aman, Arni. Arni aman, Hesron. Hesron aman, Peres. Peres aman, Yahuda. ");
INSERT INTO tet_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda aman, Yakob. Yakob aman, Isak. Isak aman, Abraham. Abraham aman, Tera. Tera aman, Nahor. ");
INSERT INTO tet_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor aman, Seruk. Seruk aman, Rehu. Rehu aman, Pelek. Pelek aman, Eber. Eber aman, Sela. ");
INSERT INTO tet_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela aman, Kenan. Kenan aman, Arpaksad. Arpaksad aman, Sem. Sem aman, Noh. Noh aman, Lamek. ");
INSERT INTO tet_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek aman, Metusalak. Metusalak aman, Henok. Henok aman, Yared. Yared aman, Mahalalel. Mahalalel aman, Kenan. ");
INSERT INTO tet_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan aman, Enos. Enos aman, Set. Set aman, Adam. Adam nia, Naꞌi Maromak mak naseꞌi. ");
INSERT INTO tet_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus simu sarani tiꞌan, Nia laꞌo nela mota Yordan. Maromak Kmalar Lulik namutuk no Nia, no nalaꞌo Nia baa fatin fuik ida. ");
INSERT INTO tet_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus nein iha fatin nia toꞌo loron haat nulu. Nia la naa sa-saa, toꞌo salaen mate. Hotu diabu ulun mai sokur kokon Nia. ");
INSERT INTO tet_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nia dale baa Yesus naꞌak, “Kalo O Naꞌi Maromak Oan tebes, O moo beran. Dadi maruka fatuk neꞌe sia dadi tubi, nebee O maa toꞌo bosu.” ");
INSERT INTO tet_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mais Yesus nataa naꞌak, “Lale! Hakerek Moon naꞌak, ‘Ema raiklaran moris lahoos nosi haan dei!’ ” ");
INSERT INTO tet_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Nunia hotu, diabu ulun nalaꞌo Yesus baa fatin aas ida. Nia natudu kabaas nosi ukunrai hotu-hotu iha raiklaran. Nia namaus Yesus naꞌak, “Ukunrai beran no kabaas hotu-hotu neꞌe sia, haꞌukaan. Haꞌu koo beran atu kfoo baa see dei mak kakara. ");
INSERT INTO tet_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Haꞌu kbele foo baa O, surak O loꞌu-sudur baa haꞌu. Nia dei!” ");
INSERT INTO tet_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mais Yesus nataa naꞌak, “Lale! Hakerek Moon naꞌak, ‘Ita musti loꞌu no sudur baa Naꞌi Maromak dei. Nia, mak ita musti haliku.’ ” ");
INSERT INTO tet_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nunia hotu, diabu ulun nalaꞌo Yesus baa kota Yerusalem. Hotu nia nodi Yesus saꞌe baa fatin mak aas kaliuk iha Uma Hamulak Huun. Hotu nia katak naꞌak, “Kalo O Naꞌi Maromak Oan tebes, soe aan tuun ona! ");
INSERT INTO tet_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tan Hakerek Moon naꞌak, ‘Naꞌi Maromak atu naruka Niakaan makbukar laleꞌan sia, nebee sia daka nola O. ");
INSERT INTO tet_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Sia mai tane nola O, nebee Okaan ain la roos aan baa fatuk.’ ” ");
INSERT INTO tet_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mais Yesus nataa naꞌak, “Keta kli-liꞌis mo haꞌu. Tan Hakerek Moon naꞌak, ‘Keta sokur Maromak!’ ” ");
INSERT INTO tet_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hodi nunia, diabu ulun koko Yesus nodi dalan oi-oik, mais la bele sokur nola. Hotu, nia nakiduk nela Yesus atu nein leet seluk. ");
INSERT INTO tet_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nunia hotu, Kmalar Lulik nalaꞌok Yesus fila nikar baa rai Galilea. La kleur, ema rai nia tomak natene tiꞌan Niakaan naran. ");
INSERT INTO tet_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nia nanorin iha ema Yahudi siakaan uma hamulak sia. Ema hotu-hotu mose naꞌak, “Yesus nia, makaꞌas tebes!” ");
INSERT INTO tet_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dala ida, Yesus mai Niakaan leo Nasaret duꞌuk. Natoon baa ema Yahudi siakaan loron hamulak, Yesus tama uma hamulak hanesan Nia nalo sura loron hamulak. Iha uma hamulak nia laran, Nia nariik atu leno Hakerek Moon. ");
INSERT INTO tet_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Sia lolo foo Bei Yesaya niakaan hakerek. Nia loke, hotu leno naꞌak: ");
INSERT INTO tet_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Naꞌi Maromak Kmalar Lulik natuun beran baa Haꞌu. Nia boi Haꞌu atu katak Manfatin Diꞌak baa ema susar. Nia solok Haꞌu atu katak kaꞌak, ema bui, atu sai; ema delek, atu naree; ema mak oin kraik, atu foti ulun. ");
INSERT INTO tet_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tan oras neꞌe, Naꞌi Maromak oras toꞌo tiꞌan atu sori Niakaan ema.” ");
INSERT INTO tet_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Leno notu, Yesus lulun nikar hakerek nia, hotu foo baa uma hamulak ulun. Hotu Nia tuur. Ema hotu-hotu iha nia nobun Nia bei-beik. ");
INSERT INTO tet_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hotu Nia katak baa sia naꞌak, “Lia mak emi rona ohin nia, oras neꞌe dadi tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Rona nola nunia, ema nia sia mose Yesus naꞌak, “Adeei! Saa mak Nia dale ohin nia, kabaas liu! Mais Nia neꞌe, Yusuf oan! Tan saa bele nuneꞌe?” ");
INSERT INTO tet_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesus nataa naꞌak, “Noo lia hatetek naꞌak, ‘Hoi, makdook! Malo okaan isin lolon diꞌak uluk lai, foin madiꞌak ema seluk.’ Nanis emi hatene tiꞌan lia hatetek nia. Emi balu hakara hodi lia nia taꞌe fila Haꞌu, hodi husu Haꞌu haꞌak, ‘Tan saa O la maseꞌi tadak blaar bodik ami iha neꞌe, hanesan uluk O maseꞌi iha kota Kapernaum?’ ");
INSERT INTO tet_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Ema la nakara simu Maromak makoꞌan iha siakaan leo duꞌuk. ");
INSERT INTO tet_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Hola lia hatetek ida hosi Maromak makoꞌan uluk Elia. Baa dala ida, udan la tau rai tinan tolu no balun. Baa oras nia, feto faluk waꞌin iha Israꞌel. Masik nunia moos, Naꞌi Maromak la solok Elia baa tulun sia hotu iha Israꞌel. Nia solok Elia baa feto faluk mesak ida iha leo Sarfat kreꞌis kota Sidon. Tuir loos, ferik nia lahoos ema Yahudi, mais tan nia fiar baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hola lia hatetek seluk hosi Maromak makoꞌan Elisa. Baa oras nia, ema Yahudi waꞌin moras funi mea iha Israꞌel. Mais Naꞌi Maromak la nadiꞌak nola sia. Naꞌi Maromak naruka Elisa nadiꞌak nola ema moras funi mea mesak ida dei. Ema nia, naran Naaman. Tuir loos, nia ema Siria, lahoos ema Yahudi, mais tan nia fiar baa Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Rona Yesus dale nunia, sia hotu-hotu krakat. ");
INSERT INTO tet_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sia nariik bele-bele, nabuꞌa sai Nia nosi uma hamulak nia. Sia dada nodi Nia baa leo diꞌin, atu soe baa horun laran. ");
INSERT INTO tet_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mais Nia sai luku tuir ema lear nia leet. Hotu Nia laꞌo nela sia. ");
INSERT INTO tet_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nunia hotu, Yesus tuun baa kota Kapernaum iha debu boot Galilea tehen. Sura loron hamulak, Nia nanorin ema iha uma hamulak Yahudi. ");
INSERT INTO tet_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ema mak nanono Nia dale, blaar karin tan Nia natene tebes hanorin nia isin. ");
INSERT INTO tet_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dala ida, oras Yesus nanorin iha uma hamulak, noo ema ida mak diabu tekar. Nia nakrake makaꞌas naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hoi Yesus, ema Nasaret! O moo lia saa mo ami! O mai atu madodok ami ka? Ami hatene O. O neꞌe, Ema Moon mak uluk Naꞌi Maromak nameno atu solok mai.” ");
INSERT INTO tet_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mais Yesus nakanas nia naꞌak, “Taka ibun! Sai mela ema nia!” Teki-tekis diabu nia foti ema nia nitak baa rai iha ema sia leet. Nitak notu, diabu moos sai nela nodi la nahoras tenik nia. ");
INSERT INTO tet_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ema hotu-hotu blaar. Sia dale naꞌak, “Ita blaar tebes! Ema neꞌe dalen, noo beran makaꞌas! Toꞌo diabu sia moos tuir Niakaan haruka nodi sai nela ema!” ");
INSERT INTO tet_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hotu ema nia sia laꞌo nasirin rai nia, katak lia nosi Yesus baa ema hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus sai nosi uma hamulak nia tiꞌan, Nia baa ema ida uman. Ema nia naran, Simon. Simon banin feto moras kiki. Sia nusu baa Yesus naꞌak, “Ama! Tulun madiꞌak mola ferik nia lai!” ");
INSERT INTO tet_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Rona nola nunia, Yesus baa nariik kreꞌis ferik nia toba fatin. Hotu Nia teꞌur sai moras kiki nia nosi nia. Oras nia moos, moras kiki nia lakon kedas. Ferik nia moos nadeer kedan, baa nadiꞌa haan bodik sia. ");
INSERT INTO tet_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kreꞌis loro monu ona, ema loi nodi siakaan ema mak moras oi-oik baa Yesus. Nia rai liman baa, nadiꞌak nola sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ema mak moras nia sia, naꞌin hira diabu tekar. Yesus moos nesi diabu sia sai nela ema nia sia. Sia sai nodi nakrake naꞌak, “O neꞌe, Naꞌi Maromak Oan!” Tebes. Diabu nia sia natene naꞌak, Yesus nia, Kristus, mak uluk Naꞌi Maromak nameno atu solok mai. Tan baa nia, Yesus nakahik diabu sia nebee keta dale lia fuan ida moos nosi Nia. ");
INSERT INTO tet_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Baa awan kreꞌis rai naroma, Yesus nadeer atu baa fatin mamuk ida iha kota luan. La kleur, ema buka Nia nasiri fatin hotu-hotu. Sia nasoru tiꞌan, sia namaus Nia naꞌak, “Ama, mein mo ami dei! Lalika baa fatin seluk sia!” ");
INSERT INTO tet_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mais Yesus nataa naꞌak, “La bele! Haꞌu kmusti baa leo seluk sia atu katak Manfatin Diꞌak nosi Naꞌi Maromak ukunrai. Tan Nia solok Haꞌu kmai atu kalaꞌok serwisu nia.” ");
INSERT INTO tet_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hotu Yesus nosi leo ida baa leo ida iha rai Yudea, nodi nanorin iha uma hamulak sia. ");
INSERT INTO tet_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dala ida, Yesus nanorin ema iha debu boot Galilea tehen. Ema waꞌin mai atu rona Maromak Manfatin, toꞌo seti malu satan nola Yesus. ");
INSERT INTO tet_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kreꞌis baa nia, ema mak tuun tasi sia namoos daitiha iha rai maran. Yesus naree bero mamuk rua nakrai aan iha nia. ");
INSERT INTO tet_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bero ida, Simon beron. Yesus saꞌe baa Simon beron, hotu naruka dudu soruk oda baa. Hotu Yesus tuur nodi nanorin ema waꞌin nia sia. ");
INSERT INTO tet_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesus nanorin notu, Nia dale baa Simon naꞌak, “Simon! Fofer soruk tenik leꞌan baa, hotu soe daitiha. Emi nanis hetan naꞌan tasi lear.” ");
INSERT INTO tet_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mais Simon nataa naꞌak, “Ama! Ami harui aan kalan tomak ida tiꞌan, mais lolon ida moos, la hetan! Mais tan Ama naruka, ami hatuun kokon.” ");
INSERT INTO tet_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hotu sia baa natuun daitiha. Oras dada saꞌe, daitiha nia nakonu no naꞌan tasi, toꞌo daitiha atu naklees ona. ");
INSERT INTO tet_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Naree nunia, Simon nahii bolu niakaan mamaluk sia nosi bero ida seluk, nebee mai tulun. Hotu sia raꞌut natama naꞌan tasi baa bero rua nia toꞌo nakonu kreꞌis mout. ");
INSERT INTO tet_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Nosi Simon mamaluk sia, noo Sebadeus oan rua, naran Yakobus no Yohanis. Sia moos blaar tan netan naꞌan tasi lear nia. Naree naꞌan tasi lear nia, Simon sudur kedas baa Yesus oin, nodi naꞌak, “Haꞌu neꞌe, ema maksalan. Diꞌak liu, Ama keta kreꞌis haꞌu.” Mais Yesus nataa naꞌak, “Simon. Keta neon kiꞌik, tan Haꞌu kakara karuka emi. Emi serwisu loron-loron buka naꞌan tasi. Mais oras neꞌe, Haꞌu atu kanorin emi buka ema, nebee sia tuir Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nunia hotu, sia dada nasaꞌe kedan bero baa rai maran. Hotu sia laꞌo nela hotu-hotu, baa tuir Yesus. ");
INSERT INTO tet_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iha leo ida, Yesus nasoru ema ida mak moras funi mea lema isin lolon tomak. Ema nia naree Yesus, nia nakniꞌa sudur nodi dale naꞌak, “Ama! Tulun haꞌu lai! Haꞌu katene Ama bele nalakon haꞌukaan moras neꞌe, nebee ema keta nakribi haꞌu ona. Surak Ama nakara.” ");
INSERT INTO tet_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus lolo liman baa, koko ema nia nodi katak naꞌak, “Haꞌu kakara! Diꞌak ona!” Yesus dale notu nunia, moras funi mea nia lakon mohu kedas. ");
INSERT INTO tet_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hotu Yesus katak naꞌak, “Manoin diꞌa-diꞌak! O diꞌak tiꞌan, mais la bele katak baa ema! O musti tuir uluk Bei Musa ukun-badu lai. Baa matudu isin lolon baa naꞌilulik, nebee nia leno okaan isin atu natene okaan moras lakon tebes tiꞌan ka, sei. Hotu, o musti matama osan baa naꞌilulik atu nalo baa sera, nebee ema hotu-hotu bele natene naꞌak, o diꞌak tebes tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Masik Yesus nakahik nunia moos, lia nosi Yesus beran nia keke lema nosi ibun baa ibun. Tan baa nia, ema lolok mai bei-beik atu nanono Niakaan hanorin. Nia moos nadiꞌak nola ema lear nosi moras oi-oik. ");
INSERT INTO tet_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hotu Nia nakiduk nela ema lear, atu baa namulak iha fatin mamuk. ");
INSERT INTO tet_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dala ida, Yesus nanorin ema iha uma ida. Baa oras nia, ema naꞌin hira mai nanono Nia. Sia, ema nosi partee Farisi no ema manorik ukun Yahudi. Sia mai nosi leo sia iha rai Galilea, nosi rai Yudea, no nosi kota Yerusalem. Oras nia, Naꞌi Maromak latan beran baa Yesus atu nadiꞌak nola ema moras sia. ");
INSERT INTO tet_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Tan baa nia, ema naꞌin hira natiu ema ai kmaꞌas ida baa tane lolo, nodi mai Yesus. Sia narui aan atu tama uma nia, mais uma nia naksetik basuk no ema tiꞌan, toꞌo la bele tama. Tan baa nia, sia nodi ema kmaꞌas nia saꞌe baa uma leten. Sia sobu nakuak uma leten, hotu natuun tane lolo nia baa Yesus oin iha ema lear leet. ");
INSERT INTO tet_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Naree nunia, Yesus natene sia fiar Nia bele nalo siakaan maluk nia diꞌak. Nia dale baa ema kmaꞌas nia naꞌak, “Maluk! Haꞌu kasu mohu okaan salan sia tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Rona Yesus dale nunia, ema Farisi no ema manorik ukun nia sia naneo naꞌak, “Hoi! Maromak mesan mak noo beran kasu ema salan. Nia neꞌe see, toꞌo nalo aan nuꞌu Naꞌi Maromak! Neꞌe nahaat Maromak tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mais Yesus natene siakaan neon. Nia dale naꞌak, “Tan saa emi haneo haꞌak, Haꞌu kahaat Maromak? ");
INSERT INTO tet_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Haꞌu neꞌe, Ema Raiklaran Isin. Haꞌu koo beran kasu ema salan. Kalo Haꞌu katak baa ema kmaꞌas neꞌe kaꞌak, ‘Haꞌu kasu mohu okaan salan sia tiꞌan,’ emi la haree kakaer. Mais kalo Haꞌu katak kaꞌak, ‘Madeer! Foti tane lolo, fila ona,’ hotu ema kmaꞌas neꞌe nadeer kedan, foin emi haree kakaer.” Yesus dale notu nunia, Nia fila baa ema kmaꞌas nia nodi naꞌak, “Mariik! Foti tane lolo, fila ona!” ");
INSERT INTO tet_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Oras nia moos, ema kmaꞌas nia nariik kedas iha ema lear oin, hotu foti tane lolo, fila nodi tonu Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Naree nunia, ema hotu-hotu nataꞌuk no blaar. Sia moos foti-nahaas Naꞌi Maromak naran naꞌak, “Naꞌi Maromak makaꞌas! Ohin loron, ita haree duꞌuk lia kasalak basuk!” ");
INSERT INTO tet_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","La kleur, Yesus sai nosi uma nia. Hotu Nia naree ema maksisi bea ida tuur iha niakaan serwisu fatik. Ema nia, naran Lewi. Yesus tene ema nia naꞌak, “Mai tuir Haꞌu!” ");
INSERT INTO tet_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Rona nola nunia, Lewi nariik kedas, laꞌo nela hotu-hotu, baa tuir Yesus. ");
INSERT INTO tet_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nunia hotu, Lewi nalo dahur boot. Nia namata Yesus no mamaluk maksisi bea no bainaka seluk sia. ");
INSERT INTO tet_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mais ema partee Farisi naꞌin hira no ema manorik ukun Yahudi sia nakmuuk Yesus eman maktuir sia naꞌak, “Tan saa emi haa hamutuk ho ema la noo folin? Tan saa emi kahur ho ema maksisi bea no ema lisan aat sia? Ema diꞌak la bele kahur no ema oin nunia sia!” ");
INSERT INTO tet_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mais Yesus katak baa sia naꞌak, “Ema moras, buka makdook. Ema isin diꞌak, la buka makdook. ");
INSERT INTO tet_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Haꞌu kmai atu kaliku ema maksalan, lahoos atu kaliku ema mak filak aan ema loos.” ");
INSERT INTO tet_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nunia hotu, ema partee Farisi no ema manorik ukun Yahudi sia nakmuuk Yesus naꞌak, “Nuneꞌe, Ama! Yohanis eman maktuir sia nalirin aan no namulak nohuun. Ema Farisi sia moos nunia. Mais tan saa Ama eman sia naa-nemu nohuun? La natene nalirin aan ka?” ");
INSERT INTO tet_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mais Yesus nataa naꞌak, “Kalo halo dahur hola malu, emi haruka bainaka nalirin aan ka? Lale! Nanis emi haruka naa toꞌo bosu. Kalo mane foun sei iha nia, musti haa bele-bele. ");
INSERT INTO tet_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mais nosi ikus, kalo ema kohi nola mane foun nodi baa tiꞌan, foin bainaka sia noran susar toꞌo nalirin aan.” ");
INSERT INTO tet_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hotu Yesus foo lia hatetek ida tenik naꞌak, “Kalo faru naksira, ita la tabar hodi tais foun. Tan kalo fasi, tais tatabar foun atu nakruꞌu, nalo faru tuan hetak naksira. ");
INSERT INTO tet_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Nunia moos, ita la fui tua foun baa knaban laꞌok. Tan knaban nia beꞌo, tua moos nanii mohu. Tan baa nia, musti fui tua foun baa knaban foun. Hodi nunia, Yesus nanorin sia naꞌak, Niakaan hanorin foun, keta kahur no ema Farisi siakaan hanorin tuan. ");
INSERT INTO tet_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mais ema mak nemu tiꞌan anggor ween tuan, sia la noꞌuk nemu anggor ween foun. Tan naneo naꞌak, ‘Anggor ween tuan mak midar kaliuk!’ ” ");
INSERT INTO tet_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Dala ida, natoon ema Yahudi loron hanawa serwisu, Yesus no maktuir sia laꞌo tuir toꞌos ida. Tan salaen basuk, maktuir sia kuꞌu nola hare gandum, nodi naa la-laꞌok. ");
INSERT INTO tet_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iha nia noo ema nosi partee Farisi naꞌin hira. Sia mak kaer metin siakaan adat Yahudi. Oras sia naree maktuir sia kuꞌu hare gandum, sia nasee Yesus naꞌak, “Tan saa okaan maktuir sia nakur itakaan ukun-badu? Maree! Sia kuꞌu tiꞌan. Neꞌe naꞌak, sia serwisu baa loron hanawa serwisu! La bele nunia!” ");
INSERT INTO tet_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Mais Yesus nataa naꞌak, “Nuꞌunabee? Emi la hanoin Bei Daud lian uluk nia ka? Oras nia, Bei Daud no niakaan ema sia salaen. Sia tama baa Batane Hamulak, nola tubi mak naꞌilulik sia sera tiꞌan baa Naꞌi Maromak. Hotu sia naa. Tuir loos, naꞌilulik sia mesan mak bele naa tubi nia. Ema seluk la bele. Mais oras Bei Daud sia naa, la noo ema ida nasalak sia. Emi la leno Naꞌi Maromak Hakerek Moon ka? ");
INSERT INTO tet_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Rona mai! Haꞌu neꞌe, Ema Raiklaran Isin. Haꞌu mak koo beran atu karuka saa mak ema raiklaran bele nalo baa loron hanawa serwisu.” ");
INSERT INTO tet_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Baa loron hanawa serwisu seluk, Yesus baa nanorin iha uma hamulak. Iha nia, noo mane ida mak liman sorin matek. ");
INSERT INTO tet_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iha nia moos noo ema manorik ukun Yahudi no ema partee Farisi naꞌin hira. Sia mai buka leet atu nahonu Yesus. Sia nein keta arumak Yesus nadiꞌak nola ema liman matek nia natoon baa loron hanawa serwisu. Hodi nunia, sia bele tula sala baa Nia iha ema oin. ");
INSERT INTO tet_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mais Yesus natene siakaan neon aat. Tan lia nia, Nia bolu liman matek nia naꞌak, “Mau! Mai klaran neꞌe!” Liman matek nia moos baa kedas. ");
INSERT INTO tet_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hotu Yesus nusu baa ema hotu-hotu iha nia naꞌak, “Haꞌu kusu kokon emi. Tuir itakaan ukun-badu, ita bele halo saa baa loron hanawa serwisu? Ita halo diꞌak ka, halo aat? Ita sori ema ka, ita hoꞌo ema?” ");
INSERT INTO tet_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hotu Yesus titu satan leur sia nodi katak baa liman matek naꞌak, “Lolo o liman mai!” Nia lolo baa, liman diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Naree nunia, ema mak funu Yesus krakat. Hotu sia buka dalan aat naꞌak, “Ita buka seluk leet atu hahonu Nia!” ");
INSERT INTO tet_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","La kleur, Yesus baa foho ida atu namulak. Nia namulak iha nebaa kalan ida tomak. ");
INSERT INTO tet_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Baa awan seisawan, Nia bolu ema mak tuir Nia hotu-hotu. Hotu, Nia boi nola ema naꞌin sanulu resin rua, nalo baa klosan. Klosan nia sia, naran mak neꞌe: ");
INSERT INTO tet_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Yesus bolu nia ‘Petrus’), Andreas (Simon alin), Yakobus, Yohanis (Yakobus alin), Filipus, Bartolomeus, ");
INSERT INTO tet_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus, Tomas, Yakobus (Alfeus oan), Simon (ema maktuir partee politik Selot), ");
INSERT INTO tet_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobus oan), no Yudas Iskariot (mak atu faꞌan lakon Yesus). ");
INSERT INTO tet_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nunia hotu, Yesus no Niakaan maktuir sia tuun nosi foho, baa rai fehan ida. Ema waꞌin naklibur iha nia tiꞌan. Sia mai nosi rai Yudea, nosi kota Yerusalem, nosi kota Tirus no kota Sidon mak iha tasi tehen. ");
INSERT INTO tet_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sia mai rona Yesus no nusu Nia nebee nadiꞌak nola ema moras sia. Hotu, Nia nadiꞌak nola sia. Nia moos nadiꞌak nola ema diabu tekar, nodi teꞌur nasai diabu nosi ema nia sia. ");
INSERT INTO tet_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ema hotu-hotu nakara koko Nia, tan kalo koko kona Nia, Niakaan beran sai nadiꞌak nola sia. ");
INSERT INTO tet_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hotu Yesus seꞌi oin baa Niakaan maktuir sia, nodi nanorin naꞌak: “Ema mukit sia! Emi hetan sotir, tan Naꞌi Maromak duꞌuk mak emikaan Naꞌin! ");
INSERT INTO tet_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ema salaen sia! Emi hetan sotir, tan Naꞌi Maromak atu naliku emi toꞌo bosu. Ema mak tanis no neon susar sia! Emi hetan sotir, tan emi atu hanasa no neon diꞌak. ");
INSERT INTO tet_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Ema mak kona susar tan tuir Haꞌu, Ema Raiklaran Isin neꞌe! Emi hetan sotir, tan Naꞌi Maromak atu selu baa emi iha laleꞌan. Masik ema hirus emi, nahaat emikaan naran, sama emi, nabuꞌa sai emi hanesan ema aat, emi hetan sotir, tan Naꞌi Maromak la naluꞌa emi iha laleꞌan. Kalo ema nasusar emi nunia, neon boot baa dei! Lalika blaar, tan ema mak nasusar emi baa oras neꞌe, uluk siakaan bei uluk duꞌuk mak nasusar Maromak makoꞌan sia. Kalo emi hetan susar nunia, halo neon boot baa dei, tan Naꞌi Maromak atu selu waꞌin boot baa emi iha laleꞌan! ");
INSERT INTO tet_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mais ema maksoin sia! Emi hetan dinu, tan emikaan moris furak, toꞌo neꞌe ona! ");
INSERT INTO tet_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ema makbosu sia! Emi hetan dinu, tan rai salaen boot saꞌe kona emi. Ema mak nanasa sia! Emi hetan dinu, tan emi kona susar toꞌo tanis hadeꞌun aan. ");
INSERT INTO tet_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ema mak buka ema mose sia! Emi hetan dinu, tan uluk emikaan bei uluk sia, mose makoꞌan bosok teen sia!” ");
INSERT INTO tet_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Hotu Yesus natutan liu naꞌak, “Rona mai! Ita musti hadomi funu no halo diꞌak baa ema mak hirus ita. ");
INSERT INTO tet_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ita musti hamulak husu Naꞌi Maromak nalo diꞌak bodik ema mak tolak nahaat ita. ");
INSERT INTO tet_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kalo ema basa itakaan hasan sorin, foo tenik sorin baa. Kalo ema nadau nola itakaan faru klobor, foo tenik faru baa. ");
INSERT INTO tet_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kalo ema nusu buat ida, foo baa. Kalo ema foti nodi buat ida, habusik nola baa. Keta baa husu hikar. ");
INSERT INTO tet_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ita musti halo baa ema seluk, nuꞌu ita hakara ema nalo baa ita. ");
INSERT INTO tet_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ita hadomi itakaan ema duꞌuk. Kona. Mais ita hetan saa? Tan ema aat sia moos nadomi siakaan ema duꞌuk. ");
INSERT INTO tet_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kalo ita halo diꞌak baa ema mak nalo diꞌak baa ita, ita hetan saa? Tan ema aat sia moos nalo diꞌak baa malu. ");
INSERT INTO tet_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kalo ita foo tusan osan baa ema mak bele selu nikar, ita hetan saa? Tan ema aat sia moos foo tusan, surak awan-wainrua sia simu nikar tomak. ");
INSERT INTO tet_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lia nuneꞌe: Hadomi funu! Halo diꞌak baa sia. Saa mak sia buka, foo baa. Lalika haneo, sia atu foo nikar ka, lale. Hodi nunia, Naꞌi Maromak selu baa ita. Ita moos dadi oan baa Maromak Mak Aas Kaliuk, tan ita moris hanesan itakaan Ama. Nia nalo diꞌak baa ema aat sia. Nia moos nalo diꞌak baa ema mak la natene dodan sia. ");
INSERT INTO tet_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tan lia nia, ita musti hadomi ema, hanesan itakaan Ama iha laleꞌan nadomi ita.” ");
INSERT INTO tet_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Hotu Yesus nanorin natutan naꞌak, “Keta sukat ema, nebee ema keta sukat fila emi. Keta hasalak ema, tan sia atu nasalak nikar emi. Haluꞌa lakon ema salan, nebee sia naluꞌa lakon emikaan salan. ");
INSERT INTO tet_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kalo foo baa ema saa mak sia buka, emi simu hikar nakonu babuꞌun. Hanesan ema namamu fore baa fatik sasukat, hotu doko, tonan tuun, nahisi tenik toꞌo nakduar sai. Mak emi atu simu, oin nunia. Kalo emi foo oan ida, emi simu fila oan ida. Kalo emi foo waꞌin, emi simu fila waꞌin.” ");
INSERT INTO tet_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hotu Yesus nanorin nodi lia hatetek naꞌak, “Ema delek la bele nadaek ema delek. Tan sia rua monu baa kuak bele-bele! ");
INSERT INTO tet_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Lawarik sakola la bele liu nosi niakaan manorik. Mais kalo nia tuir hanorin diꞌa-diꞌak, nia bele dadi manesak no niakaan manorik nia. ");
INSERT INTO tet_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Emi hakara hatadan ema salan kiꞌik. Mais emikaan salan boot, emi halo aan, la noo sala. Hahalok nia nuꞌu emi haliku ahukresan lotun ida iha ema matan. Mais emi la horan noo ai rohan boot neli emikaan matan. ");
INSERT INTO tet_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nuꞌunabee emi haksakar aan haꞌak, ‘Belu! Mai nebee haꞌu kasai ahukresan nia nosi okaan matan.’ Mais emi duꞌuk la bele haree sa-saa, tan noo ai rohan boot neli emikaan matan! Etuk oin! Emi huun oin kotuk! Masai ai rohan boot nia nosi okaan matan lai, foin bele masai ahukresan lotun nia nosi okaan belun matan.” ");
INSERT INTO tet_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Hotu Yesus nanorin soruk naꞌak, “Ai huun diꞌak la nafua aat. Ai huun aat, la nafua diꞌak. ");
INSERT INTO tet_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ita bele hatene ai huun hosi fuan. Ita la bele kuꞌu dila fuan, lale, anggor fuan, hosi ai tarak. ");
INSERT INTO tet_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nunia moos ema diꞌak, nalo lia diꞌak. Ema aat, nalo lia aat. Tan itakaan dalen, natudu itakaan neon ain.” ");
INSERT INTO tet_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hotu Yesus natutan tenik naꞌak, “Loron-kalan emi bolu Haꞌu haꞌak, ‘Naꞌi’. Mais, tan saa emi la halo tuir Haꞌukaan dalenn? ");
INSERT INTO tet_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ema mak mai nanono Haꞌu, hotu nalo tuir Haꞌukaan dalen, ema nia hanesan ");
INSERT INTO tet_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ema mak nakara nariik uma mak biit. Nia keꞌe diꞌa-diꞌak rai kuak tatuur iha rai isin, toꞌo kona fatuk. Hotu nia nalo tatuur baa fatuk leten, foin nariik uma. Kalo motasaꞌe kona, uma nia la nawae, tan noo tatuur biit. ");
INSERT INTO tet_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mais ema mak rona nodi neon baluk no la tuir Haꞌukaan dalen, ema nia hanesan ema mak nakara nariik uma, surak nariik dei. Nia la nalo tatuur, mais nariik uma baa rai fohon mota tehen. Hotu motasaꞌe mai, naroꞌon nola uma nia!” ");
INSERT INTO tet_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nanorin notu nunia, Yesus fila nikar baa kota Kapernaum. ");
INSERT INTO tet_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Noo sondadu ulun Roma ida iha nebaa. Niakaan ema serwisu ida mak nia fiar, moras todan kreꞌis mate. ");
INSERT INTO tet_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sondadu ulun nia rona nola lia Yesus, hotu nia solok fukun Yahudi naꞌin hira atu baa nusu Yesus nebee mai nadiꞌak nola niakaan ema nia. ");
INSERT INTO tet_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sia toꞌo mai tiꞌan, sia nakroꞌan nebee Yesus mai no sia. Sia katak naꞌak, “Ama! Ema Roma nia, ema diꞌak! Fatan Ama tulun nia. ");
INSERT INTO tet_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nia nariik uma hamulak ida bodik ita, tan nadomi ita ema Yahudi.” ");
INSERT INTO tet_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Rona nola nunia, Yesus moos baa no sia. Sia sei la toꞌo dauk, ulun nia solok mamaluk mai nasoru Yesus nodi katak naꞌak, “Ama Boot lalika hakole aan, tan haꞌu la kfatan simu Ama iha haꞌukaan uma. ");
INSERT INTO tet_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Haꞌu moos la fatan mai kasoru Ama, tan katene malorek Ama noo beran. Surak Ama dale hosi neꞌe dei, haꞌukaan ema serwisu diꞌak kedan. Haꞌu katene lia neꞌe, tan haꞌukaan ulun sia noo beran naruka haꞌu. Haꞌu moos koo beran karuka haꞌukaan sondadu sia. Kalo karuka sasiꞌan kaꞌak, ‘Baa nebaa!’ nia nanis baa. Kalo kaꞌak, ‘Mai neꞌe!’ nia nanis mai. Kalo karuka haꞌukaan ema serwisu kaꞌak, ‘Serwisu neꞌe!’ nia nanis nalo. Dadi surak Ama dale dei, haꞌukaan ema moras, diꞌak kedan.” ");
INSERT INTO tet_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Rona nola nunia, Yesus blaar. Hotu Nia feur oin baa ema mak tuir no Nia sia. Nia katak naꞌak, “Haꞌu kblaar! Hori wain tiꞌan Haꞌu la kasoru dauk ema Yahudi ida mak fiar biit nuꞌu ema Roma neꞌe!” ");
INSERT INTO tet_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dale notu nunia, Yesus laꞌo toꞌo nia dei. Sondadu ulun mamaluk sia moos fila. Oras sia toꞌo ulun uman baa, sia naree ema moras nia diꞌak tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Baa awan, Yesus no maktuir sia baa leo ida, naran Nain. Ema waꞌin laꞌo bele-bele no sia. ");
INSERT INTO tet_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kreꞌis baa leo nanokar, ema lolok ida sai baa nakoi maten. Maten nia, feto faluk ida oan mane mesak. ");
INSERT INTO tet_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naree feto faluk nia, Yesus neon monu. Hotu Nia katak baa naꞌak, “Ina! Toꞌo ona, lalika tanis!” ");
INSERT INTO tet_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hotu Yesus nareꞌis aan baa, lolo liman koko ai balun maten nia. Ema matiu ai balun moos nanawa laꞌo. Hotu Yesus dale baa maten nia naꞌak, “Manek! Madeer ona!” ");
INSERT INTO tet_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Oras nia moos, oa nia moris nikar. Nia nadeer kedas, hotu tuur nodi dale no ema iha nia sia. Hotu Yesus katak baa inan naꞌak, “Ina! Neꞌe, okaan oan.” ");
INSERT INTO tet_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ema iha nia sia hotu-hotu nataꞌuk liu! Sia moos tonu-naboot Naꞌi Maromak naꞌak, “Naꞌi Maromak namaan aan mai tiꞌan iha itakaan klaran! Nia solok tiꞌan Niakaan makoꞌan makaꞌas ida baa ita!” ");
INSERT INTO tet_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hotu lia nia keke lema fatin hotu-hotu iha rai Yudea, toꞌo rai seluk sia. ");
INSERT INTO tet_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Baa oras nia, Yohanis niakaan maktuir sia moos rona lia Yesus. Hotu sia baa nasara Yohanis iha bui laran. Rona nola lia Yesus nunia, Yohanis solok niakaan ema naꞌin rua baa nusu Yesus naꞌak, “Ama neꞌe, tebe-tebes Kristus mak ami hein ka, ami musti hein tenik ema seluk?” Nasoru nola Yesus, Yohanis eman sia nusu nunia. ");
INSERT INTO tet_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Baa oras sia mai nia, Yesus noꞌi nadiꞌak nola ema moras oi-oik. Nia moos teꞌur sai diabu nosi ema. No nadiꞌak nola ema delek. ");
INSERT INTO tet_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesus katak baa Yohanis eman sia naꞌak, “Fila baa katak Mau Yohanis maꞌak, hotu-hotu mak emi rona no emi haree duꞌuk nia, dadi tuir saa mak Maromak makoꞌan Yesaya nakerek nela kedan naꞌak: ‘Ema delek, bele naree. Ema ai kmaꞌas, bele laꞌo. Ema moras funi mea, bele dadi moos. Ema diuk, bele rona. Ema mak mate tiꞌan, bele moris nikar. Ema mukit, bele rona Manfatin Diꞌak.’ ");
INSERT INTO tet_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Fila baa, katak Mau Yohanis haꞌak, ‘Ema mak la moe simu Haꞌu, atu netan sotir.’ ” ");
INSERT INTO tet_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Rona nola nunia, Yohanis eman sia moos fila. Hotu Yesus katak baa ema waꞌin nia sia lia nosi Yohanis naꞌak, “Uluk emi buka Yohanis iha fatin fuik nebaa, emi hanoin emi atu hasoru ho ema ilas oin nuꞌu saa? Nanis emi la buka ema mak naweruk aan, nuꞌu au mak anin nuu. ");
INSERT INTO tet_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nanis emi la buka ema mak tau tais kabaas, tan ema nunia iha tofatik dei! ");
INSERT INTO tet_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Uluk nia, emi baa buka see? Emi buka Maromak makoꞌan ka? Tebes! Yohanis nia, makoꞌan makaꞌas basuk. ");
INSERT INTO tet_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iha Hakerek Moon noo lia nosi Yohanis naꞌak: ‘Rona! Haꞌu ksolok Haꞌukaan ema, atu loke dalan bodik O.’ ");
INSERT INTO tet_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iha raiklaran neꞌe, la noo ema ida moos mak boot liu Yohanis. Mais iha Naꞌi Maromak fohorai, ema mak kiꞌik basuk dei moos, boot liu Yohanis.” ");
INSERT INTO tet_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ema mak rona Yesus dalen nia, sia simu, tan sia natene tiꞌan naꞌak, Naꞌi Maromak dalan nia, loos no tebes. Sia simu nunia, tan uluk Yohanis sarani sia no nanorin sia. Ema maksisi bea sia moos simu nunia. ");
INSERT INTO tet_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mais ema nosi partee Farisi no ema manorik ukun Yahudi sia, la simu. Uluk sia moos la noꞌuk Yohanis sarani sia. ");
INSERT INTO tet_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hotu Yesus nusu naꞌak, “Haꞌu atu katete ema raiklaran oras neꞌe baa saa? Sia ema oin nuꞌu saa? ");
INSERT INTO tet_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nuneꞌe. Sia hanesan lawarik mak naꞌi tu-tuur iha dalan. Sia nahii baa malu naꞌak, ‘Ami huu kfui bele-bele, mais emi la bidu hadiꞌak neon. Ami hananu kananuk lakumerin, mais emi la tanis.’ ");
INSERT INTO tet_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Uluk Yohanis Mak Sarani Ema sei iha emikaan klaran. Nia nalirin aan no la nemu anggor ween. Mais emi hasalak nia haꞌak, ‘Diabu tekar!’ ");
INSERT INTO tet_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mais Haꞌu neꞌe, Ema Raiklaran Isin kosi laleꞌan. Loron-kalan Haꞌu kaa tubi no kemu anggor ween. Emi moos hasalak Haꞌu haꞌak, ‘Rotus teen! Lanuk teen! Nia nadulur no maksisi bea sia! Nia partee ida no ema mak la noo folin sia! Nia la natene aan!’ ");
INSERT INTO tet_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tebes! Emi hasalak Haꞌu nunia. Mais hatadan Haꞌukaan dalen neꞌe! Ema mak natene tebes Naꞌi Maromak, sia mak moris tuir Maromak dalan.” ");
INSERT INTO tet_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iha kota nia, noo ema Farisi ida naran Simon. Dala ida, nia namata Yesus sia mai niakaan uma. Simu nola hamata nia, Yesus sia baa. Toꞌo baa, ema naliku sia tuur naa. ");
INSERT INTO tet_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Oras nia, feto aat ida rona Yesus atu naa iha Simon uma nia. Feto nia moos mai, kaer nodi botir ida nahisi no mina morin folin todan. ");
INSERT INTO tet_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nia nareꞌis aan baa Yesus nosi kotuk. Hotu nia nakniꞌa iha Yesus ain. Nia tanis nadeꞌun aan, toꞌo luun turu kona Yesus ain. Nia noꞌas Yesus ain nodi fuuk duꞌuk, hotu deꞌi Yesus ain. Hotu nia fui mina morin nia baa Yesus ain. ");
INSERT INTO tet_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon natene feto nia tuur-hariik. Nia naneo naꞌak, “Hahalok neꞌe dadi kakaer tiꞌan naꞌak, Yesus neꞌe lahoos Maromak makoꞌan. Kalo tebe-tebes Maromak mak solok Nia, nanis Nia natene feto mak roos aan baa Nia neꞌe, feto aat. Maromak makoꞌan lahoos nuꞌu Nia neꞌe, tan ema moos la bele nareꞌis aan baa ema sasobos!” ");
INSERT INTO tet_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mais Yesus natene Simon neon. Nia dale baa Simon naꞌak, “Mau Simon! Haꞌu atu katak lia ida baa mau nuneꞌe.” Simon nataa naꞌak, “Diꞌak, Ama! Katak baa dei.” ");
INSERT INTO tet_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hotu Yesus soe lia naꞌak, “Noo ema ida mak buka moris nodi foo tusan osan baa ema seluk. Dala ida, nia foo tusan bodik ema naꞌin rua. Bodik ida, nia foo murak mutin atus lima. Bodik ida seluk, lima nulu. ");
INSERT INTO tet_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Toꞌo oras foo fila, sia rua la bele selu. Mais makfoo tusan nia, neon monu baa sia rua. Hotu nia noꞌas siakaan tusan. Oras neꞌe, Haꞌu atu kusu nuneꞌe: tuir mau, nosi ema naꞌin rua nia, nabee mak nadomi liu ema makfoo tusan?” ");
INSERT INTO tet_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon nataa kedan naꞌak, “Nanis, mak natusan boot kaliuk!” Yesus nataa nikar naꞌak, “Kona, mau!” ");
INSERT INTO tet_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hotu Yesus mana nikar baa feto nia, nodi katak baa Simon naꞌak, “Mau Simon, titu feto neꞌe. Hori ohin nia nakniꞌa iha neꞌe. Oras haꞌu ktama mai mau uman, mau la nadiꞌa wee atu fasi Haꞌukaan ain tuir itakaan adat. Mais feto neꞌe nabotes Haꞌukaan ain nodi luun, hotu noꞌas namara nodi fuuk. ");
INSERT INTO tet_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ohin nia moos, Haꞌu ktama mau uman, mau la deꞌi Haꞌu tuir itakaan adat. Mais nahuu nosi Haꞌu ktama baa uma neꞌe laran, feto neꞌe la nanawa deꞌi Haꞌukaan ain. ");
INSERT INTO tet_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mau moos naluꞌa adat fui mina baa bainaka ulun. Mais feto neꞌe fui mina morin mak folin todan kaliuk baa Haꞌukaan ain. ");
INSERT INTO tet_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Rona mai, mau! Feto neꞌe noo sala waꞌin tebes. Mais Naꞌi Maromak kasu mohu tiꞌan, tan nia natudu dadomin waꞌin baa Haꞌu. Ema mak la noo sala waꞌin, la natudu dadomin waꞌin nunia baa Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dale hotu nunia, Yesus katak baa feto nia naꞌak, “Haꞌu kasu mohu okaan salan sia tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Rona nola Yesus dalen nia, ema mak tuur naa bele-bele iha nia namaas baa malu naꞌak, “Hoi! Nia naneo naꞌak, Nia neꞌe, see?! Nia naberan aan kasu ema salan! Tuir loos, Maromak mesan dei mak noo beran kasu mohu ema salan! Lalika hanono!” ");
INSERT INTO tet_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mais Yesus katak baa feto nia naꞌak, “Tan o fiar tiꞌan, Naꞌi Maromak sori o tiꞌan. Fila ona modi dame!” ");
INSERT INTO tet_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","La kleur, Yesus no Niakaan maktuir naꞌin sanulu resin rua, laꞌo nasirin kota no leo iha nebaa, nodi katak Lia Diꞌak nosi Naꞌi Maromak ukunrai. ");
INSERT INTO tet_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Feto naꞌin hira moos laꞌo no sia. Uluk, feto balu moras oi-oik, balu diabu tekar. Mais Yesus nadiꞌak nola sia. Feto nia sia, mak Maria nosi leo Magdala. Uluk, Yesus teꞌur sai diabu hitu nosi nia. ");
INSERT INTO tet_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Iha nia moos, noo Susana no ina Yohana. Ina Yohana neꞌe, ama Kusa feen. Kusa nia, ulun mak babilan iha naꞌi Herodes tofatik. Sei noo feto waꞌin seluk mak laꞌo bele-bele no Yesus sia. Feto neꞌe sia nodi siakaan osan duꞌuk, sosa bakae bodik Yesus sia iha dalan. ");
INSERT INTO tet_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dala ida tenik, ema lear sai nosi leo waꞌin atu buka Yesus. Sia libur malu tiꞌan, Yesus nanorin sia nodi lia hatetek. Dala ida neꞌe, Nia dale nuneꞌe: ");
INSERT INTO tet_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Noo ema mafaho rai ida baa kari fini iha toꞌos. Fini balu monu baa dalan. Baa oras ema laꞌo tuir nia, sia sama fini nia sia. Hotu manu mai tutu nola. ");
INSERT INTO tet_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Fini balu tenik monu baa rai fatuk. Fini nia sia tubu, mais naklaik mohu, tan wee la toꞌo. ");
INSERT INTO tet_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fini balu seluk monu baa rai mak noo ai tarak. Baa oras fini nia sia nahuu tubu, ai tarak neti noꞌo. ");
INSERT INTO tet_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mais fini seluk tenik, monu kona rai isin. Sia tubu, hotu boot toꞌo nafua. Fini nia sia foo nikar fuan dala atus ida.” Dale notu nunia, Yesus taka lia hatetek nia naꞌak, “See mak noo tilun, rona diꞌa-diꞌak!” ");
INSERT INTO tet_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nunia hotu, Yesus maktuir sia nusu lia hatetek nia isin. ");
INSERT INTO tet_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nia nataa naꞌak, “Nuneꞌe! Tan emi tuir Naꞌi Maromak dalan tiꞌan, Haꞌu katak malorek nebee emi bele hatene Naꞌi Maromak fohorai no oin nunabee Nia naliku hutun-renun. Mais ema seluk sia mak la noꞌuk tuir Naꞌi Maromak dalan, Haꞌu kanorin sia kodi lia hatetek dei. Maromak makoꞌan nakerek kedan tiꞌan lia nosi ema nia sia naꞌak, ‘Sia naree tiꞌan, mais la noꞌuk natene. Sia rona tiꞌan, mais la noꞌuk simu.’ ” ");
INSERT INTO tet_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hotu Yesus nalore lia hatetek nia isin naꞌak, “Fini nia, nuꞌu Maromak Manfatin. ");
INSERT INTO tet_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fini mak monu baa dalan, nuꞌu ema mak rona Maromak Manfatin, mais la kleur diabu ulun mai nadau nola Manfatin nia nosi niakaan neon. Tan nunia, ema nia la fiar Naꞌi Maromak, no la netan moris. ");
INSERT INTO tet_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Fini mak monu baa rai fatuk, nuꞌu ema mak rona Maromak Manfatin no simu nodi neon diꞌak. Mais abut tama la leꞌan. Nia nahuu fiar, mais kalo susar saꞌe tan, nia monu maꞌas. ");
INSERT INTO tet_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Fini mak monu baa rai mak noo ai tarak, nuꞌu ema mak rona nodi simu Maromak Manfatin. Mais la kleur, nia naluꞌa lakon, tan nia nalau aan no niakaan lia duꞌuk, no naha oi-oik, nodi moris nafurak aan dei. Nosi ikus, niakaan fiar nia la nafua saa ida. ");
INSERT INTO tet_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mais fini mak monu baa rai isin, nuꞌu ema neon loos. Nia rona Maromak Manfatin, hotu rai diꞌa-diꞌak baa neon. Hodi nunia, nia fiar nohuun nodi nalo lia diꞌak waꞌin.” ");
INSERT INTO tet_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hotu Yesus nanorin tenik naꞌak, “Ita sunu badut, hotu taka hodi hanek ka? Ita sunu badut, hotu rai iha koi ohak ka? Lale! Ita rai badut baa fatin aas, nebee laka naroma ema mak tama mai. ");
INSERT INTO tet_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tan hotu-hotu mak sei nakfunin baa oras neꞌe, atu naksain. Hotu-hotu mak ita sei la hatene baa oras neꞌe, ita atu hatene. ");
INSERT INTO tet_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hanoin diꞌa-diꞌak lia neꞌe sia. Ema mak nakara buka tebe-tebes Naꞌi Maromak beer, nia hetak natene. Mais ema mak la nakara rona Naꞌi Maromak beer, nia hetak la natene.” ");
INSERT INTO tet_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Baa dala ida, Yesus sei dale no ema lear. Hotu Yesus inan no Yesus alin sia mai atu nasoru Nia. Mais sia la bele kre-reꞌis baa Nia, tan ema waꞌin resik. ");
INSERT INTO tet_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hotu ema baa katak Yesus naꞌak, “Ama! Okaan inan no alin sia iha luan. Sia atu nasoru O.” ");
INSERT INTO tet_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesus nataa naꞌak, “Heꞌe! Mais nuneꞌe. Ema mak rona Maromak Manfatin hotu nalo tuir, sia mak Haꞌukaan inan no Haꞌukaan alin tebes.” ");
INSERT INTO tet_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Baa dala ida, Yesus tene Niakaan maktuir sia naꞌak, “Mai ita saꞌe bero, baa debu balu baa.” Sia moos saꞌe bero, laꞌo baa. ");
INSERT INTO tet_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Baa oras laꞌo, Yesus toba. La kleur, anin dadurus toma sia. Laloran nakfake tama baa bero, toꞌo sia kreꞌis netan dinu. ");
INSERT INTO tet_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Naree nunia, ema maktuir sia fuꞌa nadeer Yesus naꞌak, “Ama Boot! Ama Boot! Madeer lai! Ita atu mate mout ona!” Yesus moos nadeer, hotu nakahik anin no laloran naꞌak, “Manawa ona!” Laloran no anin moos nakmatek kedas. ");
INSERT INTO tet_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hotu Yesus deꞌan Niakaan maktuir sia naꞌak, “Tan saa emi la fiar Haꞌu?” Mais sia nataꞌuk no blaar. Sia moos nusu baa malu naꞌak, “Hoi! Yesus neꞌe, see? Oin nunabee Nia bele naruka anin no laloran, toꞌo tuir Niakaan harukan?” ");
INSERT INTO tet_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","La kleur, Yesus sia toꞌo rai Garasa iha debu boot Galilea balu baa. ");
INSERT INTO tet_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Iha nebaa, noo ema ida mak diabu tekar kleur tiꞌan. Nia la nein iha uma. Nia nein dei iha rate fatik sia. Sura loron nia nakwalan nodi laꞌo baa-mai, tan diabu sia naruka nia nohuun. Ema kesi nia rua-ruan tiꞌan nodi besi talik, mais nia nasiit mohu. Hotu, diabu sia naloot nia toꞌo nalai baa rai fuik. Oras Yesus sia tuun nosi bero, ema bulak nia mai nasoru. Nia nakrake, nodi soe aan baa Yesus oin. Hotu Yesus naruka naꞌak, “Hoi, diabu! Sai mela ema neꞌe!” Hotu ema bulak nia nakrake naꞌak, “Hoi! Keta kakoen haꞌu! Tan haꞌu katene O neꞌe Yesus, Maromak Mak Aas Kaliuk Oan! Keta masusar haꞌu!” ");
INSERT INTO tet_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hotu Yesus nusu baa nia naꞌak, “O naran see?” Diabu nataa naꞌak, “Legion, tan ami lear hanesan sondadu rihun-rihun.” Bulak dale nunia, tan diabu waꞌin nein iha niakaan laran. ");
INSERT INTO tet_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hotu diabu nia sia nakroꞌan baa Yesus nebee keta naruka sia baa Kuak Kastikar, mak diabu siakaan kastikar fatin. ");
INSERT INTO tet_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kreꞌis baa nia, noo fahi klibur ida. Fahi nia sia noꞌi naa iha foho tehen. Diabu nia sia nakroꞌan baa Yesus naꞌak, “Maruka ami tama baa fahi nia sia dei!” Yesus moos nalo tuir nunia. ");
INSERT INTO tet_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Diabu nia sia sai nela bulak nia, tama kedan baa fahi nia sia. Fahi nia sia hotu-hotu bula, nalai lakon tuun nosi foho nia, tama baa debu boot laran. Hotu-hotu mate mout. ");
INSERT INTO tet_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Naree nola nunia, makdaka fahi sia nalai baa nasirin leo sia iha nia, nodi katak lia nia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Rona nola nunia, ema lear sai baa fatin nia atu naree duꞌuk saa mak dadi. Toꞌo nebaa, sia naree ema diabu tekar nia tuur mamatek kreꞌis Yesus ain. Nia moon tiꞌan no tau tais tiꞌan. Naree nunia, sia hotu-hotu nataꞌuk. ");
INSERT INTO tet_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hotu ema mak ohin naree lia nia sia, katak baa ema mak foin mai sia, nunabee ema bulak nia bele diꞌak nikar. ");
INSERT INTO tet_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mais ema Gerasa hotu-hotu mak nein iha rai nia, nusu Yesus nebee laꞌo nela rai nia, tan sia hotu-hotu nataꞌuk. Rona nola nunia, Yesus sia saꞌe baa bero, atu fila nikar baa debu balu baa. ");
INSERT INTO tet_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mais ema mak ohin diabu tekar nia, namaus Yesus naꞌak, “Ama! Kalo bele, haꞌu ktuir Ama!” Mais Yesus nataa naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nuneꞌe dei! Diꞌak liu, o fila mikar baa okaan familin sia modi katak baa sia lia Naꞌi Maromak Niakaan dadiꞌak baa o.” Hotu, ema nia baa nasirin kota nia, katak baa ema hotu-hotu nosi lia Yesus nadiꞌak nola nia. ");
INSERT INTO tet_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nunia hotu, Yesus sia fila baa debu boot Galilea balu baa. Baa oras sia tuun nosi bero, ema lear nein tiꞌan. Sia kabuun mai, simu Yesus. ");
INSERT INTO tet_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Iha nia moos, noo ema ida naran Yairus. Nia, uma hamulak ulun iha kota nia. Niakaan oan feto mesak ida, otas tinan sanulu resin rua. Oa feto nia moras todan kreꞌis mate. Tan baa nia, oras Yairus naree Yesus mai, nia baa nakniꞌa iha Yesus oin. Nia nakroꞌan nebee Yesus mai niakaan uma, nadiꞌak nola oan. Yesus simu. Hotu sia baa Yairus uman. Ema lear moos tuir, toꞌo laꞌo seti malu. ");
INSERT INTO tet_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Iha nia, noo feto ida mak tuir sia. Feto nia kona moras raa naruk tinan sanulu resin rua tiꞌan. Nia namohu osan no naha tiꞌan, nodi selu makdook sia. Mais la noo makdook ida mak bele nadiꞌak nola nia. Niakaan moras hetak tuꞌan. ");
INSERT INTO tet_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Baa oras nia, nia nareꞌis aan baa Yesus nosi kotuk atu koko Yesus faru ninin. Koko tiꞌan, nia diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Teki-tekis Yesus nariik nodi nusu naꞌak, “See mak koko Haꞌu neꞌe?” La noo ema ida mak nataa. Hotu Petrus dale naꞌak, “Ama Boot! Ema lear seti malu! Sia dudu malu nosi kotuk.” ");
INSERT INTO tet_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mais Yesus nataa naꞌak, “Lale! Ohin nia, Haꞌu koran Haꞌukaan beran sai. Katene ema ida koko Haꞌu nodi neon no laran.” ");
INSERT INTO tet_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Rona Yesus dale nunia, feto nia noran la bele nakfunin toꞌo nataꞌuk liu. Nia kiki, nodi nakniꞌa baa Yesus oin. Nia katak lia huun iha ema lear oin. Hotu nia moos katak naꞌak, “Natoon baa haꞌu koko kona Yesus, haꞌu diꞌak kedas.” ");
INSERT INTO tet_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hotu Yesus katak baa nia naꞌak, “Bii! O diꞌak, tan fiar baa Haꞌu. Fila ona modi neon diꞌak!” ");
INSERT INTO tet_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus sei dale no feto nia, Yairus eman ida mai katak baa nia naꞌak, “Aikee, Ama! Ama oan la no ita tiꞌan! Lalika makole Ama Boot tenik.” ");
INSERT INTO tet_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Rona ema nia nasara, Yesus dale baa Yairus naꞌak, “Mau! Lalika mataꞌuk! Fiar baa Naꞌi Maromak dei. Nia atu sori mau oan.” ");
INSERT INTO tet_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Toꞌo Yairus uman, ema nakonu uma nodi tanis nadeꞌun aan. Yesus nakahik sia naꞌak, “Hanawa tanis ona! Oa neꞌe la mate. Nia toba dei!” Rona Yesus dale nunia, ema nia sia nanasa nodi nakmulis ibun baa Nia, tan sia naree duꞌuk oa nia nawan kotu tiꞌan. Mais Yesus bolu nola oan nia inan-aman, Petrus, Yohanis no Yakobus, tama bele-bele no Nia. Nia moos naruka ema seluk sia nein iha luan. ");
INSERT INTO tet_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tama tiꞌan baa, Yesus kaer nola oa nia liman, nodi bolu naꞌak, “Bete! Madeer ona!” ");
INSERT INTO tet_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Natoon nia moos, oa nia moris nikar, hotu nadeer. Yesus naruka inan naꞌak, “Foo nia naa lai!” ");
INSERT INTO tet_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Inan-aman blaar tebe-tebes. Mais Yesus nakahik sia nebee keta keke lia neꞌe. ");
INSERT INTO tet_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Baa dala ida, Yesus libur nola Niakaan maktuir naꞌin sanulu resin rua. Nia latan beran baa sia, nebee bele teꞌur diabu, no bele nadiꞌak nola ema nosi moras oi-oik. ");
INSERT INTO tet_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nia solok sia baa katak lia nosi Naꞌi Maromak fohorai nodi nalore oin nunabee Naꞌi Maromak naliku hutun-renun. Nia moos solok sia atu nadiꞌak nola ema moras. ");
INSERT INTO tet_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mais Nia nameno baa sia naꞌak, “Hanoin diꞌa-diꞌak! Emi baa, lalika hodi sa-saa. Hodi loos faru iha isin dei. Lalika hodi knoꞌa, kakaluk, bakae, lale, osan. Faru selu moos, lalika hodi. ");
INSERT INTO tet_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kalo tama baa leo ida, hotu ema simu emi, emi hein iha siakaan uma nia dei. Keta boi uma. Hein iha nia toꞌo laꞌo hela leo nia. ");
INSERT INTO tet_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kalo tama baa leo ida, mais ema la simu emi, hiꞌit aan laꞌo hela sia. Baa oras sai hosi leo nia, musti halo tuir adat hodi hisik hela ahukresan iha emikaan ain, hotu katak baa sia haꞌak, ‘Tan emi la hoꞌuk rona, habusik emi hatiu hola duꞌuk.’ ” ");
INSERT INTO tet_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Rona notu nunia, ema maktuir sia baa laꞌo sura leo. Sia katak baa ema lia Naꞌi Maromak Manfatin Diꞌak. Sia moos nadiꞌak nola ema moras sia. ");
INSERT INTO tet_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Baa oras nia, lia oi-oik nosi Yesus toꞌo Naꞌi Herodes Antipas tilun tiꞌan. Rona nola lia nia sia, Herodes benar tan noo ema naꞌin hira mak naꞌak, “Yesus nia, Yohanis Mak Sarani Ema. Nia moris nikar tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Balu tenik naꞌak, “Yesus nia, Bei Elia mak moris nikar. Kalo lale, ida seluk nosi Maromak makoꞌan uluk sia.” ");
INSERT INTO tet_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mais Herodes naneo naꞌak, “Hori hirak nia, haꞌu karuka taa kotu Yohanis ulun tiꞌan. Oras neꞌe, nia moris nikar tiꞌan ka? Kalo lahoos nia, ida neꞌe, see tenik?” Tan Herodes benar nunia, nia buka dalan atu nasoru duꞌuk Yesus. ");
INSERT INTO tet_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Baa leet ida, maktuir mak Yesus solok nia sia, fila mai naklibur nikar no Nia. Sia nasara baa Nia saa hotu-hotu mak sia nalo tiꞌan. Hotu sia bele-bele laꞌo no-nook baa fatin ida kreꞌis leo Betsaida atu nanawa. ");
INSERT INTO tet_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mais ema lear noran nola sia baa, hotu sia moos tuir. Yesus simu sia diꞌa-diꞌak, nodi nadiꞌak nola ema moras hotu-hotu. Nia moos katak baa sia lia Naꞌi Maromak Fohorai nodi nalore oin nunabee Naꞌi Maromak naliku hutun-renun. ");
INSERT INTO tet_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Loro malirin tiꞌan, maktuir naꞌin sanulu resin rua nia baa katak Yesus naꞌak, “Diꞌak liu Ama naruka ema neꞌe sia, baa leo kreꞌis iha neꞌe sia, nebee sia buka haan duꞌuk. Sia moos musti buka fatin duꞌuk bodik toba. Tan fatin neꞌe, fatin fuik.” ");
INSERT INTO tet_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Mais Yesus nataa naꞌak, “Nuneꞌe! Emi mak musti hahaan sia!” Mais sia sakar naꞌak, “Adeei, Ama! Oin nuꞌu saa bele nunia? Ema neꞌe sia rihun lima resin! Nia foin mane dei, sei la sura feto no lawarik dauk! Itakaan tubi moos, baluk lima dei. Naꞌan tasi moos, lolon rua dei. Neꞌe la toꞌo! Kalo Ama nakara ami hahaan sia, nunabee ami bele sosa haan waꞌin bodik sia?!” Mais Yesus naruka sia naꞌak, “Haruka ema neꞌe sia tuur naklibur, sura klibur ema naꞌin lima nulu.” ");
INSERT INTO tet_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hotu sia baa nahulin nunia. ");
INSERT INTO tet_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ema nia sia tuur tiꞌan, Yesus nola tubi baluk lima no naꞌan tasi lolon rua nia. Nia tanaat baa laleꞌan, nodi namulak baa Maromak. Hotu, Nia tohi faꞌe tubi no naꞌan tasi nia, lolo baa maktuir sia nebee faꞌe baa ema nia sia. ");
INSERT INTO tet_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sia hotu-hotu naa toꞌo bosu. Hotu maktuir sia libur nola haan resin sia, toꞌo nakonu koꞌe sanulu resin rua. ");
INSERT INTO tet_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dala ida, Yesus namulak mesan iha fatin ida. Hotu Niakaan maktuir sia mai naklibur no Nia. Namulak notu, Nia nusu baa sia naꞌak, “Tuir ema dalen, Haꞌu neꞌe see?” ");
INSERT INTO tet_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sia nataa naꞌak, “Noo ema naꞌak, Ama neꞌe, Yohanis Mak Sarani Ema. Seluk tenik naꞌak, arumak Ama neꞌe, Bei Elia. Kalo lale, ida seluk nosi Maromak makoꞌan uluk sia, mak moris nikar tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesus nusu natiꞌi sia tenik naꞌak, “Tuir emi duꞌuk, Haꞌu neꞌe see?” Petrus nataa naꞌak, “Ama neꞌe, Kristus mak uluk Naꞌi Maromak nameno kedan atu solok mai.” ");
INSERT INTO tet_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Petrus nataa nunia, hotu Yesus nakahik sia nebee keta katak baa se-see haꞌak, Nia neꞌe, mak Kristus. ");
INSERT INTO tet_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nunia hotu, Yesus dale tuꞌan baa Niakaan maktuir sia naꞌak, “Haꞌu neꞌe, Ema Raiklaran Isin kosi laleꞌan. Haꞌu kmusti katiu susar todan oi-oik. Fukun adat sia, naꞌilulik ulun sia, no manorik ukun Yahudi sia la simu naꞌak, Haꞌu neꞌe, mak Kristus. Sia atu noꞌo Haꞌu. Nanis Haꞌu kmate, mais wainrua, Haꞌu kmoris kikar!” ");
INSERT INTO tet_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hotu, Yesus moos dale baa ema lear sia naꞌak, “Ema mak nakara tuir Haꞌu, nia musti tuir bei-beik sura loron! Nia musti naluꞌa niakaan hakara duꞌuk, nebee tuir Naꞌi Maromak hakaran. Masik ema noꞌo nia moos, nia musti tuir, hanesan ema natiu niakaan ai karuus atu baa niakaan mate fatin. ");
INSERT INTO tet_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ema mak moris nodi nadiꞌa aan simu mate tan tuir Haꞌu, nia netan moris no Naꞌi Maromak nima-nimak. Mais ema mak moris tuir hakaran duꞌuk, nia la netan moris no Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kalo ema netan raiklaran sasoin tomak, mais la netan moris no Naꞌi Maromak, nia netan sotir saa? ");
INSERT INTO tet_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Haꞌu neꞌe, Ema Raiklaran Isin kosi laleꞌan. Ema mak moe aan tuir Haꞌu, no moe aan kaer Haꞌukaan hanorin, baa oras Haꞌu kfila kikar kosi laleꞌan mai, Haꞌu moos moe aan katene ema nia iha Naꞌi Maromak oin. Nosi ikus, Haꞌu atu ktuun mai kodi Ama beran makaꞌas, bele-bele ko Niakaan makbukar laleꞌan sia. ");
INSERT INTO tet_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Keta haluꞌa lia fuan neꞌe! Nosi emi hotu-hotu neꞌe, balu la mate dauk, toꞌo naree Naꞌi Maromak kaer ukun.” ");
INSERT INTO tet_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Loron walu siku, Yesus nodi Petrus, Yohanis no Yakobus saꞌe baa foho ida atu namulak. ");
INSERT INTO tet_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Baa oras namulak, Yesus ilas nakfilas aan. Niakaan tais mutin naksinak. ");
INSERT INTO tet_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Teki-tekis, ema naꞌin rua mosu mai. Sia rua, mak Bei Musa no Bei Elia. Sia dale no Yesus. ");
INSERT INTO tet_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sia moos tadu naksinak. Sia naꞌin tolu dale baa malu nosi lia Yesus mate iha Yerusalem. ");
INSERT INTO tet_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Baa oras nia, Petrus no mamaluk naꞌin rua nakati la bele netu aan, toꞌo toba. Baa oras naktekir, sia titu-naree Yesus nariik no ema naꞌin rua. Sia moos titu-naree Yesus sinak nakroma. ");
INSERT INTO tet_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Naree Bei Musa no Bei Elia atu fila ona, Petrus benar nodi dale karin naꞌak, “Ama Boot! Ami horan diꞌak iha neꞌe. Diꞌak liu ami hariik batane tolu. Ida bodik Ama Boot, ida bodik Bei Musa, ida tenik bodik Bei Elia.” ");
INSERT INTO tet_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus sei dale nunia, kaloꞌan tuun, taka nola sia. Naree nunia, Petrus sia nataꞌuk. ");
INSERT INTO tet_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sia moos rona noo lia maliak nosi kaloꞌan naꞌak, “Neꞌe, Haꞌukaan Oan mak Haꞌu kboi kedan! Rona diꞌa-diꞌak baa Nia!” ");
INSERT INTO tet_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nunia hotu, Petrus sia titu-naree Yesus mesan dei. Sia naꞌin tolu taka ibun, la dale baa se-see saa mak sia naree tiꞌan nia. Kleur, foin loke ibun dale baa ema seluk. ");
INSERT INTO tet_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Baa awan, oras Yesus no Petrus sia tuun nosi foho nia, ema lear mai nasoru Yesus. ");
INSERT INTO tet_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Noo ema ida nahii baa Yesus naꞌak, “Ama Boot! Maree kokon haꞌukaan oan mane mesak neꞌe lai! ");
INSERT INTO tet_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tan diabu tekar nia, nalo nia sarebak nakrake, nodi nitak nia toꞌo kaban furin sai. Diabu moos taꞌe rua-ruan no kakoen nia nohuun. ");
INSERT INTO tet_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Haꞌu kusu baa Ama maktuir sia tiꞌan nebee teꞌur sai diabu nia, mais sia la bele!” ");
INSERT INTO tet_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Rona nola nunia, Yesus nakanas maktuir sia naꞌak, “Hoi! Emi neꞌe etuk oin, huun la fiar no la loos! Toꞌo wainhira Haꞌu katerus aan ko emi?” Dale notu nunia, Nia katak baa ama nia naꞌak, “Modi o oan mai!” ");
INSERT INTO tet_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Baa oras nodi oan baa Yesus, diabu nitak baa rai nodi doko nia. Mais Yesus teꞌur diabu sai nela oan nia. Hotu oan nia diꞌak kedas. Yesus moos latan nikar baa aman. ");
INSERT INTO tet_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Ema hotu-hotu mak naree Yesus beran makaꞌas nia, blaar karin. ");
INSERT INTO tet_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Ema hotu-hotu sei dale tadak blaar mak Yesus naseꞌi nia, Nia katak Niakaan maktuir sia naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Hatadan diꞌa-diꞌak lia neꞌe! Haꞌu neꞌe, Ema Raiklaran Isin kosi laleꞌan. La kleur ona, ema atu faꞌan lakon Haꞌu, hotu latan Haꞌu baa ema seluk.” ");
INSERT INTO tet_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Rona nola nunia, Yesus Niakaan maktuir sia benar karin, tan la natene lia nia isin. Mais sia moos nataꞌuk nusu lia nia isin naꞌak saa. ");
INSERT INTO tet_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Baa dala ida, Yesus Niakaan maktuir sia toe malu baa lia see mak boot kaliuk. ");
INSERT INTO tet_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mais Yesus natene sia toe malu tan lia nia. Hotu Nia nola lawarik ida, nalo nariik iha Niakaan sorin. ");
INSERT INTO tet_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Hotu Nia katak baa sia naꞌak, “Rona diꞌa-diꞌak! Ema mak simu ema kiꞌik hanesan lawarik neꞌe, ema nia moos simu Haꞌu no Haꞌukaan Ama mak solok Haꞌu kmai iha raiklaran neꞌe. Ema waꞌin naraik ema kiꞌik sia, mais Naꞌi Maromak nafoli kaliuk, ema mak naliku ema kiꞌik sia.” ");
INSERT INTO tet_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nunia hotu, Yohanis nasara baa Yesus naꞌak, “Ama Boot! Baa dala ida, ami haree ema ida teꞌur sai diabu nodi temi Ama naran. Ami hakahik nia nebee keta temi nodi Ama naran, tan nia lahoos itakaan eman.” ");
INSERT INTO tet_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mais Yesus nataa naꞌak, “Hoi! Keta hakahik nia! Tan ema mak la sakar ita, nia itakaan eman.” ");
INSERT INTO tet_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus natene naꞌak, Niakaan loron saꞌe baa laleꞌan kreꞌis ona. Hotu, Nia nakotu atu baa kota Yerusalem. ");
INSERT INTO tet_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mais Nia naruka ema naꞌin hira atu baa uluk, nebee babilan haa-hemu no fatin bodik sia nein heik. Hotu ema nia sia moos baa, tama leo ida iha rai Samaria. ");
INSERT INTO tet_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mais ema Samaria iha nia la simu Yesus sia, tan sia atu baa loꞌu-sudur baa Maromak iha kota Yerusalem. ");
INSERT INTO tet_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Baa oras Yakobus no Yohanis rona ema Samaria la simu Yesus nunia, sia namaus Yesus naꞌak, “Ama Boot! Kalo ita husu Naꞌi Maromak solok haꞌi nosi kaloꞌan mai naa mohu sia, nunabee?” ");
INSERT INTO tet_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mais Yesus seꞌi oin baa sia rua nodi deꞌan naꞌak, “Keta nunia.” ");
INSERT INTO tet_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Hotu sia laꞌo liu baa leo seluk. ");
INSERT INTO tet_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Baa oras sia sei laꞌo, ema ida dale baa Yesus naꞌak, “Ama Boot! Ama baa nabee dei, haꞌu ktuir bei-beik!” ");
INSERT INTO tet_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mais Yesus nataa naꞌak, “Diꞌak no! Mais manoin nuneꞌe. Ema hotu-hotu noo fatin duꞌuk. Asu fuik fila baa fatuk kuak. Manu fila baa knuuk. Mais Haꞌu neꞌe, la koo uma toba fatin. Tan Haꞌu neꞌe, Ema Raiklaran Isin kosi laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Baa dala ida Yesus bolu ema ida seluk naꞌak, “Mai, tuir Haꞌu atu dadi baa Haꞌukaan ema.” Ema nia nataa naꞌak, “Diꞌak! Mais nuneꞌe, Ama Boot. Mabusik haꞌu kfila, baa babilan ema matas sia lai. Kalo haꞌukaan ama mate tiꞌan, foin haꞌu kmai tuir Ama.” ");
INSERT INTO tet_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mais Yesus dale baa nia naꞌak, “Nuneꞌe! Mabusik ema mak la fiar Maromak, babilan siakaan ema maten. Mais emi mak fiar baa Maromak, musti baa katak lia nosi Nia babilan hutun-renun.” ");
INSERT INTO tet_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Baa dala ida seluk, ema ida tenik naꞌak, “Diꞌak no, Ama Boot! Haꞌu kakara tuir Ama Boot bei-beik. Mais mabusik haꞌu kbaa katak haꞌukaan famili sia lai, foin haꞌu kmai tuir Ama.” ");
INSERT INTO tet_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mais Yesus katak baa nia naꞌak, “Nuneꞌe! Kalo ema nahuu fila rai, hotu nalau aan no serwisu seluk sia toꞌo naluꞌa furi, niakaan toꞌos la dadi. Nunia moos, ema mak nakara tuir Haꞌu. Kalo nia nanoin bei-beik moris uluk, nia la noo folin dadi ema mak serwisu iha Naꞌi Maromak fohorai.” ");
INSERT INTO tet_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nunia hotu, Yesus boi nola maktuir seluk sia. Sia naꞌin hitu nulu resin rua. Hotu, Nia faꞌe sia nalo naꞌin rua-rua atu baa uluk Nia, baa fatin mak Nia atu baa. ");
INSERT INTO tet_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nia solok sia nodi naꞌak, “Ema lear hanesan hare mak naktuuk tiꞌan. Hein loos ema serwisu mai kuꞌu. Tan baa nia, emi musti hamulak, husu baa Naꞌi Maromak tuꞌan Niakaan ema serwisu, nebee sia baa nanorin ema atu tuir Haꞌu. Tan ema waꞌin mak nakara tuir. Mais ema mak serwisu, la duun waꞌin. ");
INSERT INTO tet_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Oras neꞌe, emi baa ona! Haꞌu ksolok emi atu serwisu baa ema lear. Mais hanoin! Emi neꞌe, hanesan bibi malae oan mak laran diꞌak. Oras neꞌe, emi baa asu fuik leet. ");
INSERT INTO tet_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Emi lalika hodi osan, tais, lale, kaso resin iha dalan. Keta soe butan leet hodi hasee ema iha dalan. ");
INSERT INTO tet_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Kalo tama baa leo ida, keta lori hosi uma baa uma. Kalo ema simu emi iha uma ida, hein iha nia dei, da-dau toꞌo laꞌo hela leo nia. Husu nebee Naꞌi Maromak natuun matak-malirin baa ema uma laran nia. Kalo uma naꞌin ida simu emi, nanis Naꞌi Maromak natudu laran diꞌak baa ema nia. Mais kalo la noꞌuk simu emi, habusik Naꞌi Maromak natudu laran diꞌak baa emi dei. Kalo tama baa uma ida, lale leo ida, haa-hemu saa dei mak sia foo. Simu hodi neon diꞌak, tan fatan sia foo baa emi, atu selu emikaan kolen. ");
INSERT INTO tet_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hadiꞌak hola siakaan ema moras. Katak baa sia haꞌak, ‘Naꞌi Maromak oras toꞌo tiꞌan atu babilan Niakaan hutun-renun.’ ");
INSERT INTO tet_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mais iha leo seluk, kalo ema la noꞌuk simu emi, baa hariik iha leo nia dalan, hodi katak haꞌak, ");
INSERT INTO tet_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hoi, ema leo neꞌe! Rona! Ami mai hodi Maromak Manfatin bodik emi, mais emi la titu netik. Oras neꞌe, ami hisik hela ahukresan leo neꞌe hosi amikaan ain, atu dadi baa tadak naꞌak, emi hatiu dinu duꞌuk. Mais hanoin diꞌa-diꞌak! Naꞌi Maromak oras toꞌo tiꞌan atu babilan Niakaan hutun-renun!’ ” ");
INSERT INTO tet_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hotu Yesus katak tenik baa maktuir naꞌin hitu nulu resin rua nia naꞌak, “Hanoin ema kota Sodom siakaan aꞌaat. Mais Haꞌu katak nuneꞌe: Kalo rai falu fila, Naꞌi Maromak nanis kastikar ema mak dudu emi, todan liu tan nosi Nia kastikar ema Sodom!” ");
INSERT INTO tet_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Hotu Yesus katak tuꞌan tenik naꞌak, “Hoi! Ema leo Korasin no ema leo Betsaida. Sintidu! Dinu atu kona emi! Haꞌu kaseꞌi lia kasalak basuk oi-oik iha emikaan oin tiꞌan, mais emi la fiar kois. Tuir loos, emi neꞌe, ema Yahudi mak katak sain haꞌak emi hatene Maromak. Mais kalo lia kasalak basuk mak Haꞌu kaseꞌi iha emikaan leo, tadu iha leo Tirus no leo Sidon, nanis ema leo rua nia laꞌo nela siakaan salan atu tuir Naꞌi Maromak. Masik sia lahoos ema Yahudi, sia nanis tau tais neon susar, nodi tau ahukresan baa ulun dadi tadak naꞌak, sia neon aat tan siakaan salan. ");
INSERT INTO tet_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tebes! Haree dei! Nosi ikus Naꞌi Maromak nakotu ema hotu-hotu lian, Nia kastikar ema Tirus no ema Sidon kmaan liu nosi Nia kastikar emi. ");
INSERT INTO tet_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hoi, ema leo Kapernaum! Sintidu! Keta haneo Naꞌi Maromak atu foti saꞌe emi, tama baa laleꞌan. Lale! Naꞌi Maromak atu soe emi, tama baa naraka!” ");
INSERT INTO tet_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hotu Yesus katak tenik baa maktuir sia naꞌak, “Hanoin diꞌa-diꞌak! Ema mak rona emi, sia moos rona Haꞌu. Ema mak dudu emi, sia moos dudu Haꞌu. Liu tan tenik, sia dudu Maromak mak solok Haꞌu kmai iha raiklaran neꞌe.” ");
INSERT INTO tet_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nunia hotu, Yesus Niakaan maktuir naꞌin hitu nulu resin rua nia moos baa, nalo tuir Niakaan haruka. Oras sia mai nikar, sia neon boot. Sia katak baa Yesus naꞌak, “Makaꞌas tebes Ama! Oras ema nusu ami hadiꞌak hola ema mak diabu tekar, ami teꞌur diabu nia hodi Ama naran. Diabu rona baa ami, hotu sia sai! Makaꞌas resik Ama!” ");
INSERT INTO tet_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Rona sia dale nunia, Yesus nataa naꞌak, “Tebes! Baa oras emi halo nunia, Haꞌu karee Naꞌi Maromak soe diabu ulun nosi laleꞌan, hanesan mameran laka karuk-kwana nosi kaloꞌan. ");
INSERT INTO tet_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hanoin! Diabu ulun nia, itakaan funu mak noo beran. Mais Haꞌu kfoo beran baa emi hodi hatohar niakaan beran nia. Kalo emi sama kona samodo mak noo raso, emi la kona sa-saa. Kalo emi sama kona sakunar, emi la kona sa-saa. Tan la noo saa ida mak bele nalo dinu kona emi. ");
INSERT INTO tet_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kalo emi neon boot tan diabu rona baa emi, lia nia diꞌak. Mais lia nia, lia kiꞌik! Diꞌak liu, emi neon boot tan Naꞌi Maromak nakerek nola emikaan naran nebee emi dadi Niakaan ema mak tama baa laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Baa oras nia, Maromak Kmalar Lulik nalo Yesus neon boot. Hotu Nia tonu-naboot Naꞌi Maromak naꞌak, “Ama! Ama mak Naꞌin Boot iha laleꞌan no raiklaran. Haꞌu kamulak sera dodan baa Ama, tan Ama subar lia neꞌe bodik ema mak naneo aan matenek no mak nahaas aan. Mais Ama nalore bodik ema kiꞌik no ema mak naraik aan. Tebes, Ama! Tan lia nia mak kona baa Ama neon!” ");
INSERT INTO tet_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Hamulak notu nunia, Yesus katak baa ema lear naꞌak, “Rona! Haꞌukaan Ama iha laleꞌan latan beran hotu-hotu baa Haꞌu. Mais ema la natene Haꞌu neꞌe, see. Haꞌukaan Ama mesan mak natene. Ema moos la natene Haꞌukaan Ama nia, see. Haꞌu mak katene. Haꞌu moos foo katene baa ema mak Haꞌu kboi.” ");
INSERT INTO tet_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dale hotu baa ema lear nunia, Yesus seꞌi oin baa maktuir sia, nodi katak baa sia mesan naꞌak, “Emi sotir tebes, tan emi bele haree Naꞌi Maromak beran tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Naꞌin sia no makoꞌan uluk sia beer basuk naree saa mak emi haree, mais la bele. Sia moos beer basuk rona saa mak emi rona, mais la bele.” ");
INSERT INTO tet_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Baa dala ida, ema matenek ukun Yahudi ida nariik atu buka Yesus ain. Nia nusu Yesus naꞌak, “Ama Boot! Ama Boot hanorin haꞌu lai! Haꞌu kmusti kalo saa, nebee katene haꞌu kbele moris kamutuk ko Naꞌi Maromak iha laleꞌan toꞌo nima-nimak?” ");
INSERT INTO tet_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus nataa naꞌak, “Bei Musa nakerek saa nosi lia neꞌe? Ita hatene saa hosi lia neꞌe?” ");
INSERT INTO tet_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ema nia nataa naꞌak, “Bei Musa nakerek naꞌak: ‘Ita musti beer Maromak, mak itakaan Naꞌin, liu hotu-hotu. Ita musti hadomi Nia nohuun, Ita musti hakaꞌas aan atu tuir Niakaan hakaran no hakaꞌas aan atu hatene diꞌa-diꞌak Nia.’ Hakerek ida tenik naꞌak, ‘Ita musti hadomi itakaan maluk, hanesan ita hadomi itakaan isin lolon duꞌuk.’ ” ");
INSERT INTO tet_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus nataa naꞌak, “Tebes Ama! Kalo o halo tuir nunia, o bele moris nima-nimak mo Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mais ema nia nalo aan nuꞌu ema matenek. Nia nusu tenik Yesus naꞌak, “Mais haꞌukaan ‘maluk’ nia, mak see?” ");
INSERT INTO tet_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus nataa naꞌak, “Nuneꞌe! Haꞌu atu katak lia hatetek ida, nebee ama boi ema ida nabee mak dadi ‘maluk’ tebe-tebes. Lia nia nuneꞌe: Baa loron ida, noo ema Yahudi ida laꞌo nosi kota Yerusalem, tuun baa Yeriko. Mais teki-tekis, ema madauk teen sia mai nadau naloot nia. Sia taꞌe nia, nadau nola niakaan osan no tais sia hotu-hotu. Sia soe lerek nia iha dalan tehen, hotu laꞌo nela nia kreꞌis mate. ");
INSERT INTO tet_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mais la hatene falik, naꞌilulik Yahudi ida laꞌo tuir nia. Nia titu-naree ema kanek nia toba iha dalan tehen, mais nia la nanawa atu tulun nia. Nia sees, laꞌo liu dei. ");
INSERT INTO tet_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","La kleur falik, ema ida seluk moos laꞌo tuir nia. Ema nia nosi hunun Lewi, mak serwisu iha Naꞌi Maromak Uma Hamulak Huun. Nia titu-naree ema nia toba iha dalan tehen. Nia moos nareꞌis aan baa naree, mais la tulun. Nia sees, laꞌo liu dei. ");
INSERT INTO tet_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","La kleur falik, ema ida nosi rai Samaria liu iha nia nodi kuda keledai. Ema Yahudi la nafolin ema Samaria. Mais baa oras ema Samaria nia titu-naree ema mak kona hadau nia, nia neon monu baa ema nia. Nia mai nareꞌis aan, hotu tulun ema nia. Nia fui anggor ween nodi namoos kanek, hotu tau mina baa. Nia falun diꞌa-diꞌak, hotu nakaꞌu saꞌe ema kanek nia baa kuda keledai leten, nodi baa kota. Nia natama kedan ema nia iha uma ida, nodi bali nia diꞌa-diꞌak. ");
INSERT INTO tet_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Baa awan, ema Samaria nia selu kedan osan murak tomak rua baa uma naꞌin, nodi katak naꞌak, ‘Ama hodi osan neꞌe bali diꞌa-diꞌak ema neꞌe toꞌo diꞌak. Kalo osan neꞌe la toꞌo, modi heik okaan lai. Baa oras haꞌu kfila mai, foin haꞌu kselu kikar.’ ” ");
INSERT INTO tet_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus Niakaan lia hatetek toꞌo nia dei. Hotu Nia nusu ema matenek ukun nia naꞌak, “Tuir ama, ema nabee mak dadi ‘maluk’ tebe-tebes bodik ema mak kona hadau ohin nia?” ");
INSERT INTO tet_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ema nia nataa naꞌak, “Nanis ema mak neon monu baa ema kanek nia.” Yesus naꞌak, “Tebes! Surak o moos malo tuir nunia.” ");
INSERT INTO tet_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Nunia hotu, Yesus no Niakaan maktuir sia laꞌo liu baa Yerusalem. Sia tuli iha leo ida. Iha leo nia, noo feto biin-alin naꞌin rua, naran Marta no Maria. Oras sia naree Yesus, Marta mai nusu baa Yesus nebee nein sa-sala lai iha siakaan uman. Yesus moos nakara. Hotu Yesus tuur nodi nanorin ema iha siakaan uma. Baa oras nia, Marta nalau aan nadiꞌa haa-hemu iha kotuk baa. Mais alin Maria tuur nareꞌis aan baa Yesus ain, nanono Nia dale. La kleur, Marta tama mai nakmuuk baa Yesus naꞌak, “Ama! Nuꞌunabee tiꞌan! Haꞌu kalo aan kadiꞌa haa-hemu, mais haꞌukaan alin tuur diꞌa-diꞌak iha neꞌe dei. Ama maruka nia serwisu tuan haꞌu iha kotuk nebaa lai!” ");
INSERT INTO tet_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mais Yesus nataa naꞌak, “Marta, Marta. O malau aan modi maneo oi-oik. ");
INSERT INTO tet_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Lia nia diꞌak, mais noo lia ida mak diꞌak kaliuk. Nodi tuur nanono Haꞌukaan Manfatin, Maria boi lia mak diꞌak kaliuk. Tan ema la bele nadau nola Manfatin nia nosi nia.” ");
INSERT INTO tet_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Baa dala ida, Yesus baa namulak. Namulak notu, Niakaan maktuir ida mai nusu naꞌak, “Ama Boot! Yohanis Mak Sarani Ema nanorin niakaan maktuir sia nebee natene namulak. Ami husu nebee Ama Boot moos hanorin ami hamulak lai!” ");
INSERT INTO tet_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Rona nola nunia, Yesus nataa naꞌak, “Diꞌak no! Hamulak hodi lia lalaꞌok nuneꞌe: Ama! Ama naran lulik kaliuk. Nebee, ema hotu-hotu foti-nahaas Ama naran kabaas nia! Nebee, Ama dadi Naꞌin bodik ema hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nebee, sura loron Ama foo haan mak toꞌo baa ami. ");
INSERT INTO tet_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nebee, Ama naluꞌa lakon amikaan salan sia, hanesan ami moos haluꞌa lakon ema salan baa ami. Nebee, Ama daka ami, keta monu baa aat.” ");
INSERT INTO tet_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Hotu, Yesus nanorin tuꞌan baa sia naꞌak, “Lia hatetek ida nuneꞌe. Kalan boot, okaan maluk ida mai nosi rai dook atu toba heik iha okaan uma. Mais o la moo sa-saa atu mahaan nia. Hotu o baa maluk seluk uman, deku odamatan mosi luan modi maꞌak, ‘Maluk! Foo heik tubi baluk tolu baa haꞌu lai! Haꞌu koo bainaka iha uma, mais ami mamuk liu! Tulun lai! Baluk tolu dei! Haꞌu lei kfoo kikar!’ ");
INSERT INTO tet_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Takseer, okaan maluk nia atu nataa fila o naꞌak, ‘Ema toba dukur tiꞌan moos, o sei mai kakoen! Odamatan kusa tiꞌan! Oan sia moos toba tiꞌan. Keta nawan saꞌe o! Hein rai nakroma lai!’ ");
INSERT INTO tet_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Manoin diꞌa-diꞌak. Masik nia la nakara nadeer tulun o tan o niakaan maluk, kalo o deku bei-beik, nanis nia nadeer tulun o. ");
INSERT INTO tet_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nunia moos, oras hamulak. Kalo husu bei-beik baa Naꞌi Maromak, Nia nanis foo. Buka bei-beik, Nia nanis natudu dalan. Bolu bei-beik, Nia nanis loke odamatan. ");
INSERT INTO tet_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ema hotu-hotu mak nakroꞌan bei-beik baa Naꞌi Maromak, nanis sia simu. Ema mak buka bei-beik, nanis sia netan. Ema mak bolu bei-beik, nanis Nia loke odamatan foo baa. ");
INSERT INTO tet_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hanoin kokon! Iha emi, kalo oan nusu naꞌan tasi baa aman, aman foo samea ka? ");
INSERT INTO tet_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kalo oan nusu manu tolun, aman foo sakunar ka? Lale. ");
INSERT INTO tet_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Masik ema raiklaran huun aat nanis, la noo ama ida iha raiklaran mak nalo nunia. Emikaan Ama iha laleꞌan huun diꞌak nanis. Kalo ema raiklaran mak aat nunia sei nakara foo buat diꞌak baa oan, saa tenik Ama iha laleꞌan! Nia nanis foo Niakaan Kmalar Lulik baa ema mak nakroꞌan baa Nia.” ");
INSERT INTO tet_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Baa dala ida, Yesus teꞌur sai diabu nosi ema nunuk ida. Hotu, nunuk nia bele dale nikar. Ema hotu-hotu blaar karin. ");
INSERT INTO tet_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mais noo ema ida mak dale naꞌak, “Tebes! Nia bele teꞌur diabu, tan netan beran nosi diabu ulun naran Baalsebul.” ");
INSERT INTO tet_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ema seluk moos nakara sokur kokon Yesus. Sia nusu nebee naseꞌi tadak blaar tenik, atu natudu baa sia naꞌak Niakaan beran nia, nosi Naꞌi Maromak ka, lale. ");
INSERT INTO tet_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mais Yesus natene kedan siakaan kakutak kadoor nia. Hotu Nia dale naꞌak, “Kalo ema fohorai ida funu malu, nanis fohorai nia dodok welon. Kalo ema uma laran toe malu, nanis ema iha uma kain nia faꞌe karin malu. ");
INSERT INTO tet_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nunia moos, kalo diabu sia funu malu no nabuꞌa malu, siakaan ulun la bele kaer ukun kleur. La tama kakutak kalo emi haꞌak, Haꞌu kodi diabu beran teꞌur diabu. ");
INSERT INTO tet_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hanoin! Emikaan ema sia moos natene teꞌur diabu. Sia nodi beran nosi diabu ka? Lale! Dadi keta dale karin haꞌak, Haꞌu kodi diabu beran teꞌur diabu. Emikaan ema duꞌuk atu nakotu naꞌak, saa mak emi dale nia, la kona. ");
INSERT INTO tet_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mais kalo tebe-tebes Haꞌu kteꞌur diabu kodi beran nosi Naꞌi Maromak, lia nia natudu naꞌak, Naꞌi Maromak kaer ukun tiꞌan iha emikaan oin, mais emi la hatene. ");
INSERT INTO tet_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kalo ema ida nodi roꞌat-meik daka uman, niakaan naha hotu-hotu nanis mamatek dei. ");
INSERT INTO tet_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mais kalo ema ida seluk mak biit liu nia mai sakar, ema biit nia bele nadau nola roꞌat no meik nia sia, raꞌut nola naha sia, hotu faꞌe baa niakaan maktuir sia. Masik uluk ema nia rai neon baa niakaan roꞌat-meik kleur tiꞌan, oras neꞌe, nia la bele rai tenik neon baa. ");
INSERT INTO tet_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Hanoin! Ema mak la namutuk no Haꞌu, sia sakar Haꞌu. Ema mak la serwisu namutuk no Haꞌu, sia tokar lauk.” ");
INSERT INTO tet_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Hotu Yesus natutan naꞌak, “Kalo ita teꞌur sai diabu hosi ema ida, diabu nia laꞌo nasirin fatin fuik buka hanawa fatin. Kalo nia la netan fatin makonak, nia naneo naꞌak, ‘Aa! La ketan fatin diꞌak nuneꞌe. Diꞌak liu, fila kikar baa ema uluk nia.’ ");
INSERT INTO tet_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hotu, nia fila baa, netan fatin uluk nia moos no tetuk tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hotu, nia baa bolu nola mamaluk naꞌin hitu mak aat liu nia. Sia tama bele-bele baa ema nia, nodi sira lisuk nia. Toꞌo ema nia moris susar liu tenik.” ");
INSERT INTO tet_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus sei dale no ema lear nia, feto ida nahii naꞌak, “Ama Boot inan mak sotir, tan nia bele nahoris nola Ama Boot no bele nasusu Ama Boot!” ");
INSERT INTO tet_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Rona nola nunia, Yesus nataa naꞌak, “Tebes, ina! Mais ema mak nanono Maromak Manfatin hotu nalo tuir, ema nia mak sotir kaliuk!” ");
INSERT INTO tet_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Baa oras nia, ema lear kabuun satan nola Yesus. Nia moos nanorin sia naꞌak, “Ema oras neꞌe, natene nalo aat dei. Sia nusu tadak blaar nohuun, nebee netan kakaer naꞌak, Haꞌu neꞌe, tebe-tebes Naꞌi Maromak eman. Mais tuir loos, uluk Naꞌi Maromak natudu tiꞌan tadak blaar, nodi makoꞌan Yunus. Lia nia toꞌo tiꞌan! ");
INSERT INTO tet_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Lia Yunus dadi kakaer bodik ema Niniwe naꞌak, Naꞌi Maromak mak solok nia. Nunia moos Haꞌu neꞌe. Lia Ema Raiklaran Isin dadi kakaer bodik ema oras neꞌe naꞌak, Naꞌi Maromak mak solok Haꞌu. ");
INSERT INTO tet_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Baa oras rai falu fila, Naꞌi Maromak nariik atu dadi makotu lia, naꞌi feto nosi lorokbelan atu moris nikar dadi saksiin. Nia atu tula sala baa emi, ema mak moris oras neꞌe naꞌak, ‘Emi neꞌe, lokok tebes!’ Naꞌi feto nia atu dale nunia, tan uluk nia mai nosi rai dook atu naree duꞌuk Naꞌi Soleman matenek. Tuir loos, oras neꞌe Ema mak makaꞌas liu Naꞌi Soleman iha emikaan klaran. Mais emi la titu kois Nia! ");
INSERT INTO tet_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mais lahoos naꞌi feto nia dei mak atu tula sala baa emi! Ema Niniwe sia moos atu tula sala naꞌak, ‘Emi neꞌe, lokok tebes!’ Sia atu dale nunia, tan uluk Yunus baa katak Naꞌi Maromak hakaran baa sia, sia neon aat kedas. Tuir loos, oras neꞌe Ema mak makaꞌas liu Yunus iha emikaan klaran. Mais emi la halo neon aat kois!” ");
INSERT INTO tet_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hotu Yesus nanorin natutan naꞌak, “Kalo ita sunu badut, ita la taka hodi hanek. Ita rai baa fatin aas, nebee naroma keꞌan bodik ema hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Itakaan matan hanesan badut. Kalo matan moon, ita bele haree malorek. Mais kalo matan babaur, hotu-hotu makukun. ");
INSERT INTO tet_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nunia moos itakaan neon laran. Kalo Naꞌi Maromak naroma tiꞌan itakaan neon laran tiꞌan, ita musti daka diꞌa-diꞌak, keta halo makukun tenik. ");
INSERT INTO tet_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kalo Naꞌi Maromak naroma ita tiꞌan, toꞌo la noo makukun ona, neꞌe naꞌak itakaan moris hanesan badut mak laka naroma bodik ema hotu-hotu.” ");
INSERT INTO tet_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus nanorin notu, ema ida nosi partee Farisi tene Nia mai niakaan uma. Toꞌo nebaa, Yesus tama baa uma laran, hotu tuur atu naa-nemu. ");
INSERT INTO tet_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Baa oras nia, uma naꞌin blaar, tan naree Yesus la fasi liman tuir ema Farisi siakaan ukun-badu. ");
INSERT INTO tet_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mais Yesus katak baa nia naꞌak, “Emi, ema Farisi, makaꞌas! Emi hanesan ema mak fasi haa-hemu fatik iha luan dei, mais laran sei kadoor. Emi kaer metin emikaan ukun-badu hamoos aan mak ema bele naree, mais emi la hamoos emikaan neon laran mak sei sasobos no rotus. ");
INSERT INTO tet_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hoi beik sia! Keta haneo haꞌak Naꞌi Maromak naseꞌi itakaan isin lolon dei. Tan Nia moos naseꞌi itakaan neon no laran. ");
INSERT INTO tet_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Diꞌak liu, hola saa mak emi hoo, foo baa ema mukit sia, nebee emikaan neon bele dadi moos iha Naꞌi Maromak oin. ");
INSERT INTO tet_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hoi! Farisi sia! Dinu atu kona emi! Oras emi sera baa Naꞌi Maromak faꞌek ida nosi fafaꞌek sanulu, emi sura lotu-lotuk. Toꞌo babudun musan nosi toꞌos moos, emi sura hotu. Mais emi la titu lia mak noo folin. Emi la titu lia moon. Emi la hadomi Naꞌi Maromak. Tebes! Ita musti sera faꞌek baa Naꞌi Maromak. Mais keta haluꞌa lia mak folin kaliuk. ");
INSERT INTO tet_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hoi! Farisi sia! Dinu atu kona emi, tan emi buka fatin kabaas iha uma hamulak laran. Emi buka kneter iha fatin dahur. ");
INSERT INTO tet_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Hoi! Farisi sia! Dinu atu kona emi! Emi nuꞌu rate mak la hatadan. Ema sama kona, mais la natene iha laran noo sasobo no dois. Iha luan emi halo aan moos liu. Mais iha neon laran, sasobo no dois.” ");
INSERT INTO tet_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesus dale notu nunia, ema matenek ukun Yahudi ida sobak nola naꞌak, “Ama! Lia nia naraik ami!” ");
INSERT INTO tet_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus nataa naꞌak, “Kona! Emi matenek ukun sia moos atu hetan dinu! Emi hatodan ema hodi tula emikaan ukun-badu oi-oik baa. Mais emi duꞌuk la hodi liman fuan ida hatiu bodik. ");
INSERT INTO tet_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hoi! Emi atu hetan dinu! Emi halau aan hariik fatuk atu hodi hanoin no hakneter Maromak makoꞌan uluk sia. Mais tuir loos, emikaan bei uluk duꞌuk mak noꞌo makoꞌan nia sia! ");
INSERT INTO tet_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Emi oik ida ho emikaan bei uluk nia sia. Uluk sia dudu sees Maromak makoꞌan sia, hotu noꞌo sia. Oras neꞌe, emi hariik rate fatuk bodik sia hodi hanoin emikaan bei uluk siakaan hahalok nia. ");
INSERT INTO tet_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mais Naꞌi Maromak hakaran malorek tiꞌan. Uluk Nia dale naꞌak, ‘Haꞌu atu ksolok Haꞌukaan makoꞌan no klosan seluk sia mai baa ema nia sia. Toꞌo baa, ema nasusar balu, ema noꞌo balu.’ ");
INSERT INTO tet_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ema mak moris oras neꞌe, musti natiu nola siakaan salan nia. Lia nia sai hori Naꞌi Maromak naseꞌi raiklaran neꞌe, nahuu nosi Habel mate, da-dau toꞌo Sakaria mak ema noꞌo iha sera fatin no Keꞌan Lulik leet iha Naꞌi Maromak Niakaan Uma Hamulak Huun laran. Emi musti hatiu hola siakaan kastikar nia! ");
INSERT INTO tet_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Hoi! Emi matenek ukun sia! Emi atu hetan dinu! Emi kaer odamatan kakoren baa Maromak, mais emi duꞌuk la tama. Aat liu tenik, emi saseni hola ema nebee keta tama!” ");
INSERT INTO tet_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesus dale notu nunia, matenek ukun no Farisi sia krakat. Nahuu baa oras nia, sia nusu lia oi-oik atu nahonu Nia. Sia moos buka dalan bei-beik atu nalo lia no Nia. ");
INSERT INTO tet_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Baa oras nia, ema rihun hira mai atu nanono Yesus. Sia seti malu nodi kabuun nola Nia. Naree nunia, Yesus dale baa Niakaan maktuir sia naꞌak, “Sintidu baa ema Farisi sia, tan sia dale seluk, nalo seluk. ");
INSERT INTO tet_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mais hahalok nunia atu naksain, tan hotu-hotu mak sei nakfunin, atu naksain. ");
INSERT INTO tet_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rona! Saa mak emi dale subar, ema atu rona malorek. Saa mak emi hamaas iha keꞌan, ema atu nahii iha ema lear oin.” ");
INSERT INTO tet_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Hotu Yesus nanorin natutan naꞌak, “Maluk sia! Lalika hataꞌuk kalo ema atu noꞌo emi. Masik sia noꞌo emi moos, sia la bele nahaat emikaan kmalar. ");
INSERT INTO tet_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Haꞌu atu katak baa emi, emi musti hataꞌuk see. Emi musti hataꞌuk Maromak, tan Nia mak bele noꞌo emi, hotu soe tama emi baa naraka. Tebes! Nia, mak emi musti hataꞌuk. ");
INSERT INTO tet_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Haneo kokon! Manu harek folin hira? Folin kmaan basuk! Matan lima, foin osan lahon rua. Masik nunia moos, Naꞌi Maromak la naluꞌa matan ida no. ");
INSERT INTO tet_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nia nanis tau neon baa emi liu tan manu harek nia sia. Nia natene malorek fuuk lahon hira iha emikaan ulun. Keta hataꞌuk, tan Naꞌi Maromak nafoli emi, liu tan manu harek nia sia.” ");
INSERT INTO tet_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Hotu Yesus dale tenik baa Niakaan maktuir sia naꞌak, “Rona diꞌa-diꞌak! Kalo ema raiklaran temi Haꞌu iha ema lear oin naꞌak ‘Haꞌu neꞌe, Yesus eman,’ Haꞌu moos temi ema nia iha Maromak Niakaan makbukar laleꞌan sia oin kaꞌak, ‘Nia, Haꞌukaan ema.’ ");
INSERT INTO tet_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mais kalo ema dale iha ema raiklaran oin naꞌak, ‘Haꞌu la katene Yesus,’ Haꞌu moos dale iha makbukar laleꞌan sia oin kaꞌak, ‘Haꞌu la katene ema nia.’ ");
INSERT INTO tet_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Haꞌu neꞌe, Ema Raiklaran Isin kosi laleꞌan. Kalo ema dale nadois Haꞌukaan naran, Naꞌi Maromak sei kasu niakaan salan nia. Mais kalo dale nadois Kmalar Lulik naran, Naꞌi Maromak la naluꞌa kedan sala nia. ");
INSERT INTO tet_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kalo ema nodi emi baa moon-metan, lale, nodi emi baa ema makaer ukun, tan emi fiar Haꞌu, emi lalika hataꞌuk atu haloos aan nunabee. ");
INSERT INTO tet_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tan baa oras nia moos, Kmalar Lulik atu nanorin emi lia fuan makonak atu hodi hataa sia.” ");
INSERT INTO tet_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nunia hotu, ema ida nosi ema lear nia nusu Yesus naꞌak, “Ama Boot! Tulun maruka haꞌukaan maun nebee nia faꞌe foo baa haꞌu, amikaan aman bein sasoin.” ");
INSERT INTO tet_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mais Yesus nataa naꞌak, “Hoi! See foti Haꞌu kdadi makotu lia baa emi rua?” ");
INSERT INTO tet_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hotu Yesus dale baa ema lear nia naꞌak, “Sintidu! Keta rotus! Tan naha waꞌin la foo moris manek.” ");
INSERT INTO tet_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hotu Yesus dale lia hatetek ida naꞌak, “Noo ema maksoin ida. Niakaan toꞌos nasai isin waꞌin. ");
INSERT INTO tet_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kanaha uman sia naksetik tiꞌan, toꞌo nia la natene atu nalo nunabee tenik. ");
INSERT INTO tet_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nia naneo naꞌak, ‘Diꞌak liu, haꞌu kalo nuneꞌe! Haꞌu ksobu kahaat kanaha uman tuan neꞌe, kariik seluk kanaha uman boot kaliuk, nebee rai toꞌos isin no naha seluk hotu-hotu baa. ");
INSERT INTO tet_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kariik tiꞌan, haꞌu kdale duꞌuk kaꞌak, “Kanaha uman boot nakonu tiꞌan. Haan naresin tiꞌan, hemun naresin tiꞌan. Haꞌu kaa-kemu kamidar aan kodi kakoen ain dei nosi tinan baa tinan.’ ” ");
INSERT INTO tet_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hanoin! Masik ema nia naneo nunia moos, Naꞌi Maromak atu katak baa nia naꞌak, ‘Hoi, beik! Ohin kalan neꞌe moos, o mate. Hotu, see mak netan okaan kanaha uman isin hotu-hotu?’ ");
INSERT INTO tet_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Rona diꞌa-diꞌak! Ema bele libur sasoin lear iha raiklaran neꞌe, bodik isin lolon. Mais iha Naꞌi Maromak oin, sia mukit teen.” ");
INSERT INTO tet_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hotu, Yesus nanorin tenik Niakaan maktuir sia naꞌak, “Emi keta haneo baa emikaan moris loron-loron haꞌak, ‘Haꞌu atu kaa saa? Atu ktau saa?’ ");
INSERT INTO tet_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tan emikaan moris folin liu nosi saa mak emi haa, no saa mak emi tau. ");
INSERT INTO tet_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Haree kokon baa kawaa sia! Sia la furi, la kuꞌu, la noo kanaha uman atu rai haan baa. Mais Naꞌi Maromak naliku sia. Nia moos nanis naliku emi. Tan Nia nafoli emi liu nosi manu ai leten sia. ");
INSERT INTO tet_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kalo ema nariik iha lalenok oin, nalau aan no isin lolon, nia bele nalo isin hetak aas ka? La bele! ");
INSERT INTO tet_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kalo emi la bele halo lia kiꞌik nunia, tan saa haneo baa lia boot? ");
INSERT INTO tet_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Haree kokon baa ai funan fuik sia. Sia la serwisu toꞌos. Sia la soru tais. Mais siakaan kabaas, liu nosi Naꞌi Soleman niakaan tais kabaas. ");
INSERT INTO tet_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Naꞌi Maromak naliku ai funan fuik mak la noo folin. Ohin loron sia moris, awan mate, hotu ema soe baa haꞌi. Kalo nunia, Naꞌi Maromak moos nanis naliku emi, mak hoo folin liu tan ai funan fuik nia sia. Tan saa emi la haloon tebe-tebes baa Nia? ");
INSERT INTO tet_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Keta haneo baa lia haa-hemu. Tan Naꞌi Maromak mak nahulin. ");
INSERT INTO tet_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ema mak la naloon baa Nia, sia susi ruin baa lia nia sia. Mais emi keta nunia, tan emikaan Ama iha laleꞌan natene hotu-hotu mak emi buka. ");
INSERT INTO tet_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Emi musti halaꞌok uluk Niakaan serwisu, foin Nia nahulin lia neꞌe sia bodik emi.” ");
INSERT INTO tet_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Hotu Yesus natutan tenik naꞌak, “Emi hanesan bibi malae klibur kiꞌik ida mak biit lalek. Mais keta hataꞌuk, tan emikaan Ama iha laleꞌan, Naꞌi Boot. Saa mak Niakaan, Nia nakara foo baa oan sia. ");
INSERT INTO tet_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tan lia nia, baa faꞌan lakon emikaan sasoin sia, hotu faꞌe osan baa ema mukit sia. Hodi nunia, emi rai sasoin iha laleꞌan. Laleꞌan, fatin manek. Ema naꞌok la bele tama. Heꞌas moos la bele tota nahaat. ");
INSERT INTO tet_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Emi rai sasoin iha nabee, emikaan neon moos iha nebaa.” ");
INSERT INTO tet_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Nunia hotu, Yesus dale tenik naꞌak, “Emi musti hadiꞌa aan loron-kalan atu hein Ema Raiklaran Isin mai nikar. Lia nia hanesan ema makdaka uma sia nein uma naꞌin fila mai nosi dahur. Kalo uma naꞌin toꞌo mai, hotu deku odamatan, makdaka sia musti loke lai-lais. ");
INSERT INTO tet_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kalo uma naꞌin naree sia daka nunia, sia nanis sotir, tan uma naꞌin atu natudu laran diꞌak baa sia. Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Uma naꞌin nia atu nalo aan nuꞌu ata, hotu naliku sia nodi haan midar. ");
INSERT INTO tet_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sia sotir tan sia naliku siakaan ulun diꞌa-diꞌak. Masik ulun mai baa tuku hira, baa kalan boot ka, kreꞌis rai naroma ka, sia nadiꞌa aan bei-beik. ");
INSERT INTO tet_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hanoin diꞌa-diꞌak! Kalo uma naꞌin natene tuku hira ema naꞌok atu mai, nia la foo leet baa naꞌok sobu uma. ");
INSERT INTO tet_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mais tan la noo ema ida mak natene wainhira Ema Raiklaran Isin atu mai nikar, emi musti hadiꞌa aan loron-kalan.” ");
INSERT INTO tet_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hotu Petrus nusu Yesus naꞌak, “Ama Boot! Lia hatetek mak Ama hanorin ohin nia, kona ami mesan ka, kona no ema hotu-hotu?” ");
INSERT INTO tet_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Yesus nataa naꞌak, “Lia hatetek nia kona baa ema hotu-hotu mak natene serwisu moon bodik ulun. Nosi ikus, ulun atu foti nia, nebee nia faꞌe haan bodik ema seluk sia. Masik ulun mai wainhira moos, ema mak madinas, nia nalo tuir ulun beer nohuun. Nia sotir, tan ulun atu foti nia nebee naliku ulun sasoin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mais dinu atu kona baa ema serwisu mak naneo naꞌak, ‘Katuas sei kleur foin mai nikar.’ Hotu ema nia nahuu taꞌe ema serwisu seluk sia, feto-mane. Hotu nia tuur naa-nemu nafurak aan toꞌo lanu. ");
INSERT INTO tet_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mais baa loron ida, oras ema nia la naneo falik, teki-tekis ulun toꞌo mai. Naree nunia, ulun atu taꞌe ema nia, hotu nabuꞌa sai nia, nebee netan kastikar iha luan, bele-bele no ema seluk mak la tuir ulun beer. ");
INSERT INTO tet_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ema serwisu mak natene ulun beer, mais la nadiꞌa aan tuir, lale, la noꞌuk tuir, ema nia kona kastikar todan. ");
INSERT INTO tet_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mais, ema serwisu mak serwisu la makonak tan nia la natene ulun beer, ema nia kona kastikar kmaan. Tan ema mak netan waꞌin, niakaan hataa moos waꞌin. Ema mak simu boot, niakaan hataa moos boot.” ");
INSERT INTO tet_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Hotu Yesus natutan naꞌak, “Haꞌu kmai kodi haꞌi baa raiklaran. Haꞌu kakara nebee haꞌi nia laka iha fatin hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mais Haꞌu kmusti katiu uluk susar todan lai, toꞌo oras mohu. ");
INSERT INTO tet_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Emi haneo, Haꞌu kmai kodi dame baa raiklaran ka? Lale! Haꞌu kmai atu kalo ema nakaat malu no toe malu, toꞌo faꞌe karin malu tan Haꞌukaan hanorin. ");
INSERT INTO tet_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nahuu oras neꞌe, ema mak famili malu sia, faꞌe karin malu. Tolu sakar rua, rua sakar tolu. ");
INSERT INTO tet_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aman sakar oan, oan sakar aman. Inan sakar oan, oan sakar inan. Banin feto sakar uma naꞌin, Uma naꞌin sakar banin feto.” ");
INSERT INTO tet_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hotu Yesus dale kedas no ema lear nia naꞌak, “Kalo ita haree kaloꞌan maꞌar mosu iha loromonu, ita hatadan haꞌak, ‘Udan atu tuun.’ Tebes. ");
INSERT INTO tet_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kalo anin lorokbelan nuu, ita hatadan haꞌak, ‘Loro makas toꞌo mai.’ Tebes. ");
INSERT INTO tet_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mais emi neꞌe, liu resik tiꞌan! Tan saa emi hatene leno tadak nosi raiklaran, mais la hatene leno tadak nosi Naꞌi Maromak?” ");
INSERT INTO tet_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Hotu Yesus dale tuꞌan naꞌak, “Kalo emi halo lia, tan saa emi la bele hakotu duꞌuk! Diꞌak liu, babilan dame malu. Keta toꞌo makotu lia oin, hotu nia nakotu atu natama emi baa bui. ");
INSERT INTO tet_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kalo nunia tiꞌan, emi la bele sai ona, da-dau toꞌo emi selu mohu osan tate mak makotu lia fake baa emi.” ");
INSERT INTO tet_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Baa oras nia, noo ema katak baa Yesus naꞌak, Gubernur Pilatus noꞌo ema Yahudi naꞌin hira nosi Galilea, oras sia nodi sera baa Naꞌi Maromak iha Uma Hamulak Huun iha Yerusalem. ");
INSERT INTO tet_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Rona nola nunia, Yesus nusu naꞌak, “Nuꞌunabee? Ema Galilea mak kona hoꞌo nia sia, siakaan salan, boot liu nosi ema Galilea seluk ka? ");
INSERT INTO tet_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lale! Mais kalo emi la halo neon aat baa emikaan salan, hodi fila baa Naꞌi Maromak, emi moos atu dodok nuꞌu sia. ");
INSERT INTO tet_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Uluk, noo ema naꞌin sanulu resin walu mak mate tan tetu aas nakroꞌon kona sia iha Siloam. Siakaan salan boot liu nosi ema Yerusalem seluk sia ka? ");
INSERT INTO tet_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lale! Mais kalo emi la halo neon aat baa emikaan salan, hodi fila baa Naꞌi Maromak, emi moos atu dodok nuꞌu sia.” ");
INSERT INTO tet_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hotu Yesus katak lia hatetek ida naꞌak, “Noo ema ida mak noo ai huun mafuak iha toꞌos. Nia mai bei-beik tanaat atu natene ai huun nia nafua tiꞌan ka, sei. Mais mana baa mai, sei dauk. ");
INSERT INTO tet_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Naree nunia, ema nia naruka mafaho toꞌos naꞌak, ‘Tinan tolu tiꞌan, haꞌu kmai bei-beik buka ai huun neꞌe fuan, mais la ketan. Diꞌak liu, muꞌan ona, tan naa fatik dei.’ ");
INSERT INTO tet_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mais mafaho toꞌos nataa naꞌak, ‘Ama keta kanarak. Foo leet baa ai huun neꞌe tinan ida tenik. Mabusik haꞌu kafaho kodi babilan. ");
INSERT INTO tet_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kalo tinan oin neꞌe sei la nafua, foin huꞌan.’ ” ");
INSERT INTO tet_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ema Yahudi loron hamulak toꞌo mai tiꞌan, Yesus baa nanorin iha uma hamulak. ");
INSERT INTO tet_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Iha nia, noo feto ida mak kotuk fuꞌur tinan sanulu resin walu tiꞌan, tan diabu hahalok. Feto nia la bele nalolo aan. ");
INSERT INTO tet_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Titu-naree feto nia, Yesus dale naꞌak, “Ina! Ina diꞌak ona.” ");
INSERT INTO tet_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesus moos rai liman baa feto nia. Teki-tekis, niakaan kotuk fuꞌur naklolok kedas. Nia moos tonu-naboot Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mais uma hamulak ulun krakat, tan Yesus nadiꞌak nola ema baa loron hamulak. Nia katak baa ema nia sia naꞌak, “Domiku ida, serwisu loron neen. Diꞌak liu, hadiꞌak hola ema moras baa loron serwisu dei, keta baa loron hamulak!” ");
INSERT INTO tet_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mais Yesus nataa naꞌak, “Hoi! Tolek teen! Baa loron hamulak, emi moos serwisu. Emi habusik karau baka no kuda keledai atu haroo. ");
INSERT INTO tet_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ina neꞌe, Bei Abraham husar-binan, hanesan emi. Diabu ulun kesi nia tinan sanulu resin walu tiꞌan. Kalo Haꞌu kabusik nia baa loron hamulak, lia nia sala ka?” ");
INSERT INTO tet_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Rona nola nunia, Yesus funun sia moe. Mais ema lear neon diꞌak tan Niakaan serwisu kabaas. ");
INSERT INTO tet_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hotu Yesus dale natutan tenik naꞌak, “Haꞌu atu kanesa Naꞌi Maromak hutun-renu nuꞌu saa? ");
INSERT INTO tet_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nuneꞌe: uluk fohon, sia naꞌin hira dei. Mais kleu-leur sia hetak waꞌin. Sia nahuu hanesan ai fuan musan kiꞌik basuk mak ema furi iha toꞌos. Kleu-leur moris mai, dadi ai huun boot. Toꞌo manu ai leten sia mai, nalo knuuk iha sorun.” ");
INSERT INTO tet_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hotu Yesus dale tenik naꞌak, “Haꞌu atu kanesa Naꞌi Maromak hutun-renu nuꞌu saa tenik? ");
INSERT INTO tet_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nuneꞌe: sia hanesan tua teen mak feto sia kahur baa tubi rahun atu nalo tubi. Tubi nia saꞌe toꞌo boot, tan tua teen oan nia. Naꞌi Maromak hutun-renu moos keke lema nunia.” ");
INSERT INTO tet_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nunia hotu, Yesus sia nahuu laꞌo baa kota Yerusalem. Iha dalan sia tuur tuli iha kota no leo nodi nanorin ema. ");
INSERT INTO tet_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iha fatin ida, noo ema ida nusu baa Yesus naꞌak, “Ama Boot! Tuir Ama hanorin, ema uit dei mak bele netan moris ka?” ");
INSERT INTO tet_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesus nataa naꞌak, “Laleꞌan odamatan tataman nia, loot basuk. Harui aan diꞌa-diꞌak, nebee bele tama. Oras rai falu fila, ema waꞌin nakara tama, mais la bele ona, tan la noo leet tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Keta toꞌo uma naꞌin kusa odamatan tiꞌan, hotu emi hariik deku-deku odamatan, hodi husu tulun haꞌak, ‘Ama boot! Loke lai!’ Masik emi husu tulun nunia moos, uma naꞌin nia atu nataa naꞌak, ‘Emi neꞌe see? Haꞌu la katene emi!’ ");
INSERT INTO tet_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hotu emi hataa haꞌak, ‘Oin nuꞌu saa, ama boot la matene ami? Ami mak loron-loron haa-hemu ho ama boot. Ama boot moos nanorin ami iha amikaan leo.’ ");
INSERT INTO tet_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mais uma naꞌin nia nataa tenik naꞌak, ‘Haꞌu katak tiꞌan! Haꞌu la katene emi! Emi neꞌe, mahalok aat. Sees hosi neꞌe!’ ");
INSERT INTO tet_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hotu emi atu tanis hadeꞌun aan hodi ruun neꞌan, tan titu-haree Bei Abraham, Bei Isak, Bei Yakob no makoꞌan hotu-hotu tuur bele-bele iha Naꞌi Maromak tofatik tiꞌan. Mais emi kona teꞌur baa luan. ");
INSERT INTO tet_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ema seluk sia moos tuur naa bele-bele iha nia. Sia mai nosi rai ikun toꞌo rai ulun, nosi lorosaꞌe toꞌo loromonu, nosi lorokaras toꞌo lorokbelan. ");
INSERT INTO tet_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hatadan lia neꞌe diꞌa-diꞌak: Baa oras rai falu fila, ema mak uluk ema kiꞌik, Naꞌi Maromak nafoli naꞌak, ema boot. Mais ema mak uluk ema boot, Naꞌi Maromak nafoli naꞌak, ema kiꞌik.” ");
INSERT INTO tet_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Baa oras nia, ema Farisi naꞌin hira mai nasoru Yesus nodi katak naꞌak, “Diꞌak liu Ama Boot hakiduk baa fatin seluk, tan Naꞌi Herodes buka Ama atu noꞌo.” ");
INSERT INTO tet_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Mais Yesus nataa naꞌak, “Hoi! Ama katuas nia nuꞌu meda karonak! Baa katak nia haꞌak, ‘Haꞌu ksei teꞌur diabu no kadiꞌak kola ema moras baa ohin loron no awan. Wainrua, foin Haꞌu kserwisu mohu.’ Haꞌu la kakiduk baa fatin seluk, mais atu laꞌo liu baa Yerusalem, tan ema nakara noꞌo Maromak makoꞌan sia iha nebaa. ");
INSERT INTO tet_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Adeei! Ema Yerusalem sia! Emi neꞌe mak hoꞌo Maromak makoꞌan sia. Emi moos mak tuda hoꞌo klosan mak mai natudu Niakaan dalan baa emi. Dala waꞌin tiꞌan Haꞌu kbeer klibur kodi lituk emi kosi aꞌaat, hanesan manu inan lituk oan nodi liras. Mais emi la hoꞌuk. ");
INSERT INTO tet_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Oras neꞌe, Naꞌi Maromak seꞌi kotuk tiꞌan baa emikaan uma hamulak. Tan baa nia, awan-wainrua uma nia mamuk ona. Rona! Emi la haree tenik Haꞌu ona, toꞌo oras emi katak sain haꞌak: ‘Naꞌi Maromak natuun matak-malirin baa ema mak mai nodi Niakaan naran.’ ” ");
INSERT INTO tet_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Loron ida, kona baa loron hamulak, ema Farisi ulun ida tene Yesus mai naa iha niakaan uma. Toꞌo baa, ema mana Yesus tan nakara naree Nia atu nalo saa baa loron hamulak. ");
INSERT INTO tet_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Baa oras nia, noo ema ida moras isin bubuk tuur iha nia. ");
INSERT INTO tet_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Naree ema nia, Yesus nusu ema Farisi no matenek ukun mak tuir naa iha nia naꞌak, “Tuir Bei Musa Ukun-badu, ita bele hadiꞌak hola ema moras baa loron hamulak ka, lale?” ");
INSERT INTO tet_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mais la noo ema ida loke ibun. Hotu Yesus kaer ema moras nia. Ema nia moos diꞌak kedas. Hotu, Yesus naruka nia fila. ");
INSERT INTO tet_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nunia hotu, Yesus nusu tenik baa ema nia sia naꞌak, “Kalo lawarik monu baa wee knuuk kona baa loron hamulak, emi dada hasai nia ka, lale? Karau baka monu baa wee knuuk, emi habusik ka, dada hasai? Nanis emi dada hasai. Lia nia naꞌak, emi serwisu tiꞌan kona baa loron hamulak!” ");
INSERT INTO tet_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Rona Yesus dale nunia, la noo ema ida mak bele nataa. ");
INSERT INTO tet_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Oras nia, Yesus naree ema mai iha uma nia. Sia waꞌin boi tuur iha fatin oin. Naree nunia, Nia dale naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kalo ema nalo dahur hola malu, hotu namata emi mai, keta buka tuur iha ema boot fatin, tan keta toꞌo dahur naꞌin natuur ema mak boot liu emi. ");
INSERT INTO tet_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Keta toꞌo nia dale baa emi naꞌak, ‘Maluk, keta krakat! Tulun lori baa fatin kotuk lai, tan kadiꞌa fatin neꞌe tiꞌan bodik ema boot sia.’ Hotu emi musti hariik hela fatin nia hodi moe, baa tuur iha kotuk baa. ");
INSERT INTO tet_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kalo ema namata mai dahur, tuur iha fatin kotuk dei. Oras dahur naꞌin titu-naree, nia atu mai naꞌak, ‘Mai tuur iha oin baa.’ Hodi nunia, emi hetan kneter iha bainaka hotu-hotu oin. ");
INSERT INTO tet_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tan ema mak naksaꞌek aan, Naꞌi Maromak nahonu nia. Mais ema mak nalo aan hanesan ema kiꞌik, Naꞌi Maromak foti saꞌe nia.” ");
INSERT INTO tet_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hotu, Yesus dale baa uma naꞌin naꞌak, “Loron seluk, kalo halo dahur, keta hamata famili no ema maksoin dei, tan sia bele namata fila ama. ");
INSERT INTO tet_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mais kalo halo dahur, hamata ema mukit, ema ai asak, ema ai kmaꞌas, no ema delek sia. ");
INSERT INTO tet_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nanis sia la bele namata selu ama. Mais kalo hamata sia, Naꞌi Maromak mak selu baa ama. Nosi ikus, oras Nia nalo ema mak fiar moris nikar, Nia la naluꞌa okaan dadiꞌak nia.” ");
INSERT INTO tet_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Rona nola nunia, ema ida mak tuur naa-nemu no Yesus dale naꞌak, “Ema mak sotir liu, neꞌe mak, ema mak tuir naa-nemu bele-bele iha Naꞌi Maromak tofatik.” ");
INSERT INTO tet_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus nataa naꞌak, “Noo lia ida nuneꞌe: Ema ida nalo dahur boot nodi namata ema lear. ");
INSERT INTO tet_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dahur tetuk tiꞌan, nia naruka atan baa bolu ema mak kona hamata sia naꞌak, ‘Mai ona, tan dahur atu nahuu ona.’ ");
INSERT INTO tet_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mais ema mak kona hamata nia sia, naseꞌi sohan oi-oik. Ida foo sohan naꞌak, ‘Aikee! Haꞌu kfoin sosa kola toꞌos, dadi musti baa karee kokon lai. Keta krakat, tan haꞌu la kbele mai.’ ");
INSERT INTO tet_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Seluk foo sohan naꞌak, ‘Haꞌu kfoin sosa kola karau baka sama rai, inan lima, aman lima. Haꞌu kmusti baa matan sia. Haꞌu kusu pardua oo!’ ");
INSERT INTO tet_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Seluk tenik naꞌak, ‘Haꞌu kfoin kola feto, dadi la bele laꞌo kela.’ ");
INSERT INTO tet_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Rona sohan nia sia hotu, ata nia fila nasara baa naꞌin. Rona nola sohan nia sia, naꞌin krakat liu. Hotu nia naruka tenik ata naꞌak, ‘Kalo nunia, sai lai-lais baa dalan boot no dalan inuk sia. Mamata mola ema mukit, ema ai asak, ema delek no ema ai kmaꞌas sia.’ ");
INSERT INTO tet_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Rona nola nunia, ata nia baa namata ema nia sia. Namata hotu, nia fila mai nasara naꞌak, ‘Ama! Sia mai hotu tiꞌan, mais fatin mamuk sei waꞌin.’ ");
INSERT INTO tet_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hotu naꞌin naruka tenik naꞌak, ‘Kalo nunia, o baa tenik toꞌo leo sikun hotu-hotu. Mamaus mola ema se-see dei modi mai. Surak nakonu nola fatin neꞌe. ");
INSERT INTO tet_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rona! Ema mak dudu haꞌukaan hamata la bele noran dahur mamidar!’ ” ");
INSERT INTO tet_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nunia hotu, Yesus sia laꞌo liu baa Yerusalem. Ema waꞌin moos tuir. Hotu Yesus seꞌi oin baa sia, nodi dale naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ema mak tebe-tebes nakara tuir Haꞌu, nia musti beer Haꞌu liu nosi sa-saa hotu-hotu: liu nosi inan-aman, liu nosi feen-oan, liu nosi maun-alin, no liu nosi isin lolon duꞌuk. Kalo lale, nia la fatan dadi baa Haꞌukaan maktuir. ");
INSERT INTO tet_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ema mak la noꞌuk natiu susar tan tuir Haꞌu, nia la fatan dadi Haꞌukaan ema. Masik ema seluk nakara noꞌo nia moos, nia musti natiu nohuun. ");
INSERT INTO tet_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kalo hakara tuir Haꞌu, haneo diꞌa-diꞌak uluk lai, hanesan lia hatetek neꞌe. Noo ema ida mak atu nariik uma boot. Nia naneo uluk folin toꞌo lotu-lotuk, keta-keta osan la toꞌo. ");
INSERT INTO tet_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kalo la haneo lotu-lotuk nunia, arumak nia foin nalo uma tatuur, osan mohu tiꞌan. Hotu ema nanasa namoe nia ");
INSERT INTO tet_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","naꞌak, ‘Haree kokon ema nia lai! Nia foin nalo uma tatuur, la saa ida dauk, osan mohu tiꞌan.’ ");
INSERT INTO tet_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Haꞌu kfoo lia hatetek ida tenik kodi lia hatuda. Noo naꞌin ida mak atu natuda. Nia musti tuur nodi sura uluk no niakaan mamaluk sia. Kalo nia noo sondadu rihun sanulu, takseer nia bele naloti funu rihun rua nulu ka, lale? ");
INSERT INTO tet_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kalo la bele, baa oras funu sei iha dook, diꞌak liu nia solok kedan klosan baa babilan dame. ");
INSERT INTO tet_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nunia moos ema mak nakara tuir Haꞌu. Nia musti sura diꞌa-diꞌak lai, nebee natene nia bele laꞌo nela hotu-hotu ka, lale.” ");
INSERT INTO tet_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Hotu Yesus natutan dalen nodi lia hatetek seluk tenik naꞌak, “Masin noo folin, tan ita hodi hamidar haan. Mais kalo masin miis tiꞌan, folin saa? Ita la bele hodi hamidar haan tenik. Halo baa babudun moos, la bele. Ita foti soe dei! Hanono! Ema mak noo tilun, rona diꞌa-diꞌak lia neꞌe!” ");
INSERT INTO tet_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Baa oras nia, ema maksisi bea no ema seluk sia, mai hei-hein baa Yesus atu nanono Nia. Tuir loos, ema Yahudi ulun sia filak ema oin nunia sia baa ema lisan aat. ");
INSERT INTO tet_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Titu-naree ema nia sia mai baa Yesus, ema Farisi no matenek ukun Yahudi sia nakmuuk naꞌak, “Hoi! Yesus neꞌe namalu no ema lisan aat sia!” ");
INSERT INTO tet_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Rona nola nunia, Yesus dale baa sia nodi lia hatetek naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Noo makbalin ida. Niakaan bibi malae matan atus ida. Dala ida, matan ida lakon. Hotu, nia musti nalo saa? Nanis nia laꞌo nela matan siwi nulu resin siwi iha fatin manek, hotu baa buka bibi malae mak lakon nia toꞌo netan. ");
INSERT INTO tet_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Netan tiꞌan, nia neon boot. Hotu, nia nasaan nodi nikar mai. ");
INSERT INTO tet_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Toꞌo uma, nia bolu nola mamaluk sia nodi katak naꞌak, ‘Hei! Mai neon boot bele-bele ho haꞌu lai, tan haꞌukaan bibi malae mak lakon nia, ketan tiꞌan.’ ");
INSERT INTO tet_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iha laleꞌan moos nunia. Kalo ema maksalan ida nalo neon aat nodi fila baa Naꞌi Maromak, laleꞌan isin tomak neon boot. Tebes. Sia neon boot tan ema naꞌin ida fila baa Naꞌi Maromak, liu nosi neon boot baa ema naꞌin siwi nulu resin siwi mak moris loos no la laꞌo sala dalan.” ");
INSERT INTO tet_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Hotu, Yesus dale lia hatetek ida tenik naꞌak, “Noo feto ida mak noo osan murak tomak sanulu. Dala ida, osan ida lakon. Hotu, nia musti nalo saa? Nanis nia sunu badut nodi leno nasirin. Nia saar uma nosi lidun baa lidun, buka diꞌa-diꞌak osan mak lakon nia toꞌo netan. ");
INSERT INTO tet_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Netan tiꞌan, nia bolu nola ema mak uma kreꞌis malu sia, nodi katak naꞌak, ‘Hei! Mai neon boot bele-bele ho haꞌu lai, tan haꞌukaan osan mak lakon nia, ketan tiꞌan!’ ");
INSERT INTO tet_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iha laleꞌan moos nunia. Kalo maksalan ida nalo neon aat nodi fila baa Naꞌi Maromak, nanis makbukar laleꞌan sia hotu-hotu neon boot.” ");
INSERT INTO tet_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hotu, Yesus natutan lia nodi lia hatetek ida seluk tenik naꞌak, “Noo ama ida. Niakaan oan mane, naꞌin rua. ");
INSERT INTO tet_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Baa loron ida, oa ikun katak baa aman naꞌak, ‘Ama! Faꞌe kedan, foo baa haꞌu haꞌukaan fafaꞌek nosi ama sasoin ona!’ Rona nola nunia, aman moos faꞌe foo kedan niakaan sasoin baa oan naꞌin rua. ");
INSERT INTO tet_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","La kleur, oa ikun faꞌan moos niakaan fafaꞌek. Hotu, nia nahulin niakaan naha sia, laꞌo baa rai dook. Toꞌo baa, nia soe karin osan nodi moris namidar aan dei. ");
INSERT INTO tet_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Baa oras osan mohu, rai nia moos kona salaen boot, toꞌo nia moris namukit aan. ");
INSERT INTO tet_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hotu, nia buka serwisu, tan salaen. Ema ida simu nia no naruka nia nahaan fahi. ");
INSERT INTO tet_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mais tan la noo ema mak foo haan baa nia, nia la terus salaen, toꞌo nakara atu naa fahi haan. ");
INSERT INTO tet_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kleu-leur, nia nanoin baa-mai naꞌak, ‘Iha haꞌukaan ama uman, mataroos hotu-hotu naa bosu toꞌo naresin. Mais haꞌu iha neꞌe, atu mate salaen ona. ");
INSERT INTO tet_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Diꞌak liu, haꞌu kfila baa haꞌukaan ama. Toꞌo nebaa, haꞌu katak baa nia kaꞌak, “Ama! Haꞌu kalo sala boot tiꞌan baa Naꞌi Maromak no baa ama. ");
INSERT INTO tet_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Haꞌu la kfatan dadi baa ama oan tenik. Masik ama simu haꞌu kdadi mataroos dei moos, diꞌak!’ ” ");
INSERT INTO tet_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naneo notu nunia, nia nariik, fila baa ama uman. Oras nia sei dook, aman titu-naree nia tiꞌan. Aman neon monu kedas baa nia. Hotu aman nalai sai nosi uma, baa nasoru oan mak fila mai nia. Hotu, nia nakoꞌak nola nodi deꞌi nia. ");
INSERT INTO tet_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hotu, oa nia dale baa aman naꞌak, ‘Ama! Haꞌu kalo sala boot tiꞌan baa Naꞌi Maromak no baa ama. Haꞌu la kfatan dadi baa ama oan tenik.’ ");
INSERT INTO tet_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mais aman naruka kedan ema serwisu sia naꞌak, ‘Hoi, lai-lais! Baa hola faru klobor kabaas ida, tau baa nia. Tau kadeli baa liman fuan, no tau kaso baa ain. ");
INSERT INTO tet_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Hotu baa dada hola karau baka mak kesi nia, koꞌa, nebee ita halo dahur bele-bele. ");
INSERT INTO tet_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tan haꞌukaan oan neꞌe, nuꞌu mate tiꞌan, mais oras neꞌe moris nikar. Nia lakon tiꞌan, mais oras neꞌe, ketan kikar tiꞌan.’ Aman dale notu nunia, sia nahuu nadahur bele-bele. ");
INSERT INTO tet_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Baa oras nia, oa ulun serwisu iha toꞌos baa. Oras fila mai uma, sei iha dook nia rona ema nakdiuk bareka nodi bidu no naksoke. ");
INSERT INTO tet_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nia bolu nola ata ida, nusu naꞌak, ‘Hoi! Dahur saa mak neꞌe?’ ");
INSERT INTO tet_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ata nia nataa naꞌak, ‘O alin mai nikar tiꞌan. O aman mak naruka koꞌa karau baka hodi halo dahur boot, tan oan fila mai nodi manek.’ ");
INSERT INTO tet_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Rona nola nunia, oa ulun krakat, toꞌo la noꞌuk tama baa uma laran. Aman baa namaus nia, nebee tama baa uma laran. ");
INSERT INTO tet_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mais nia krakat naꞌak, ‘Ama! Manoin kokon lai! Hori wain neꞌe, haꞌu kserwisu susi ruin hanesan mataroos bodik ama. Haꞌu la kakur ama hakaran. Masik nunia moos, sei la dala ida dauk, ama foo bibi oan matan ida kodi kadahur ko haꞌukaan mamaluk sia. ");
INSERT INTO tet_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mais katene kodi baa, ama oan labuk teen neꞌe, baa nakdiuk feto namohu ama osan sia. Oras neꞌe nia fila mai, ama noꞌo karau baka isin furak basuk, hodi halo dahur boot bodik nia.’ ");
INSERT INTO tet_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Rona nola nunia, aman nataa naꞌak, ‘Oa mak haꞌu kadomi! Rona diꞌa-diꞌak! O mein mamutuk mo haꞌu. Hotu-hotu mak haꞌukaan moos, okaan. ");
INSERT INTO tet_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Oras neꞌe, ita musti hadahur, tan okaan alin mesak neꞌe. Uluk, nuꞌu nia mate tiꞌan, mais oras neꞌe nia moris nikar tiꞌan. Nia lakon tiꞌan, mais oras neꞌe ita hetan hikar tiꞌan.’ ” ");
INSERT INTO tet_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hotu, Yesus dale lia hatetek ida tenik baa Niakaan maktuir sia naꞌak, “Noo maksoin ida. Nia foti eman serwisu ida dadi baa serwisu ulun. Mais kleu-leur, nia rona lia iis naꞌak, serwisu ulun nia nahuu naktolek atu nahonu nia. ");
INSERT INTO tet_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hotu nia bolu nola serwisu ulun nia, nodi nusu naꞌak, ‘O neꞌe, nunabee? Haꞌu krona o tokar lauk haꞌukaan sasoin sia. Baa makerek okaan serwisu lalaꞌok, nebee karee lai. Hotu, haꞌu kasai o.’ ");
INSERT INTO tet_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Rona nola nunia, serwisu ulun naneo baa-mai naꞌak, ‘Haꞌu kole tiꞌan! Atu kalo saa? Fila rai, haꞌu la kbiit. Dadi ema madiduk moos, haꞌu kmoe aan. ");
INSERT INTO tet_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kalo haꞌu la kbele serwisu iha neꞌe ona, haꞌu kmusti buka dalan nebee ema seluk bele simu haꞌu.’ ");
INSERT INTO tet_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hotu, nia bolu nola ema hotu-hotu mak natusan baa niakaan ulun. Nia nusu ema nomer ida naꞌak, ‘O matusan hira baa haꞌukaan ulun?’ ");
INSERT INTO tet_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ema nia nataa naꞌak, ‘Katusan mina saitun, liter rihun haat.’ Hotu serwisu ulun naꞌak, ‘Tebes! Neꞌe okaan hakerek tusan. Oras neꞌe sira mahaat ona, hotu makerek lai-lais hakerek tusan foun, maꞌak o matusan liter rihun rua dei.’ ");
INSERT INTO tet_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Hotu nia baa nusu ema nomer rua naꞌak, ‘O tenik, matusan hira?’ Nia nataa naꞌak, ‘Katusan hare kakaluk rihun ida.’ Serwisu ulun katak naꞌak, ‘Sira mahaat okaan hakerek tusan nia, hotu makerek foun maꞌak, kakaluk atus walu dei.’ ");
INSERT INTO tet_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Serwisu ulun nalo nunia toꞌo ulun natene nola niakaan dalan. Mais ulun mose nia naꞌak, serwisu ulun nia, matenek buka dalan nebee ema simu nia. Haꞌu katak lia hatetek neꞌe baa emi, nebee emi hatene haꞌak, ema mak la fiar baa Naꞌi Maromak, sia matenek liu buka dalan baa malu bodik moris. Mais ema mak fiar baa Naꞌi Maromak, sia moris iha kroman. Siakaan kakutak la matenek nuꞌu ema mak la fiar nia sia. ");
INSERT INTO tet_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Haneo kokon! Ema raiklaran nakdiuk kadoor nodi siakaan sasoin. Diꞌak liu emi hodi sasoin raiklaran tulun ema. Hodi nunia, emi hetan mamaluk waꞌin. Baa oras sasoin nia mohu, Naꞌi Maromak simu emi atu moris nima-nimak iha laleꞌan. ");
INSERT INTO tet_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kalo ema moon baa lia kiꞌik, nanis nia moos moon baa lia boot. Mais kalo ema naktolek baa lia kiꞌik, nanis nia moos naktolek baa lia boot. ");
INSERT INTO tet_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kalo ema la bele fiar emi atu babilan lia kiꞌik iha raiklaran, nunabee Naꞌi Maromak bele fiar emi atu babilan lia boot? ");
INSERT INTO tet_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kalo emi la bele babilan ema seluk sasoin, la noo mak nakara foo sasoin baa emi atu babilan dadi baa emikaan sasoin duꞌuk. ");
INSERT INTO tet_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ata ida la bele serwisu namutuk bodik ulun naꞌin rua, tan nia beer ida, hirus ida. Nia titu ida, la titu ida. Nunia moos emi. Emi la bele serwisu hamutuk bodik Naꞌi Maromak no serwisu bodik osan.” ");
INSERT INTO tet_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Baa oras nia, noo ema Farisi naꞌin hira mak tuir nanono Yesus dale ohin nia. Sia naleuk Nia, tan sia beer osan. ");
INSERT INTO tet_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mais Yesus dale tenik naꞌak, “Hoi! Masik emi hamoon aan iha ema oin, Naꞌi Maromak natene emikaan neon aat. Noo lia waꞌin mak ema raiklaran tonu no mose. Mais Naꞌi Maromak nakribi lia nia sia. ");
INSERT INTO tet_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Uluk ita ema Yahudi moris tuir Ukun-badu nosi Bei Musa no nosi Maromak makoꞌan sia, da-dau toꞌo oras Yohanis Mak Sarani Ema mai. Oras neꞌe, Manfatin Diꞌak keke lema tiꞌan naꞌak, Maromak dadi Naꞌin bodik ema raiklaran. Ema waꞌin moos narui aan atu moris tuir Naꞌi Maromak dalan foun nia. ");
INSERT INTO tet_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Masik nunia moos, Ukun-badu uluk nia sia sei nafati. Laleꞌan no raiklaran bele lakon, mais Ukun-badu nia sia la lakon. ");
INSERT INTO tet_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tan lia nia, keta haluꞌa Ukun-badu mak naꞌak, ‘Ema mak soe feen, hotu nola tenik feto, nia nakur biti-kluni.’ ” ");
INSERT INTO tet_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Hotu, Yesus dale tenik naꞌak, “Noo ema maksoin ida. Nia nakara tau tais kabaas mak lita hosi tais mamar. Loron-kalan nia naa midar nodi nadahur nohuun. ");
INSERT INTO tet_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Iha nia moos noo ema mukit ida naran Lasarus. Mirik aat nakonu niakaan isin. Sura loron niakaan belun sia rai nia iha maksoin nia odamatan nanokar. ");
INSERT INTO tet_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nia buka haan nosi maksoin haan mumun sia, mais la netan. Asu sia dei mak mai belo mirik aat ween. ");
INSERT INTO tet_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","La kleur, Lasarus mate. Makbukar laleꞌan sia mai nola nia, natuur baa Abraham sorin. La kleur falik, maksoin moos mate. Hotu, ema nakoi nia. ");
INSERT INTO tet_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mais nia la tama laleꞌan. Nia tama baa naraka, mak ema maten fatin. Iha nia, nia noran susar bei-beik. Mais dala ida, nia foti oin, titu-naree Lasarus tuur neon diꞌak iha Abraham sorin. ");
INSERT INTO tet_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Maksoin nahii naꞌak, ‘Bei Abraham! Madomi haꞌu lai! Maruka Lasarus loban liman fuan dikin baa wee, nebee mai nabotes nola haꞌukaan nanaan lai, tan haꞌu ksusar tebes iha haꞌi naraka neꞌe.’ ");
INSERT INTO tet_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mais Abraham nataa naꞌak, ‘Oa! Manoin diꞌa-diꞌak lai. Uluk oras o sei moris, o metan diꞌak hotu-hotu. Mais Lasarus netan susar. Oras neꞌe, Naꞌi Maromak nalo Lasarus neon diꞌak iha neꞌe, mais o mak metan susar. ");
INSERT INTO tet_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Saa tenik, iha itakaan leet neꞌe, Naꞌi Maromak tau horun boot. Ema nosi neꞌe la bele baa nia, ema nosi nia moos la bele mai neꞌe.’ ");
INSERT INTO tet_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mais maksoin nusu tenik naꞌak, ‘Kalo nunia, bei tulun maruka Lasarus baa haꞌukaan ama uman lai. ");
INSERT INTO tet_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Haꞌu ksei ko alin naꞌin lima iha nebaa. Maruka Lasarus baa foo natene, nebee sia fiar baa Naꞌi Maromak ona. Nebee oras sia mate, sia la tama dinu fatin neꞌe.’ ");
INSERT INTO tet_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mais Abraham nataa naꞌak, ‘Naꞌi Maromak foo tiꞌan hakerek nosi Musa no Niakaan makoꞌan sia. Habusik okaan alin sia leno duꞌuk hakerek nia isin, nebee sia natene Naꞌi Maromak hakaran.’ ");
INSERT INTO tet_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mais maksoin nakrake naꞌak, ‘Lia nia sei la toꞌo dauk! Masik sia leno duꞌuk moos, sia sei la fiar. Musti noo ema mak mate tiꞌan sai nosi rate baa katak sia lai, foin sia rona baa Maromak.’ ");
INSERT INTO tet_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mais Abraham nataa naꞌak, ‘Kalo sia la noꞌuk nanono baa Musa no Maromak makoꞌan sia, masik noo ema mak mate tiꞌan sai nosi rate moos, sia la nanono baa.’ ” ");
INSERT INTO tet_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Hotu, Yesus katak tenik baa Niakaan maktuir sia naꞌak, “Dala waꞌin, ema monu baa sala tan ema seluk niakaan hahalok. Hanono! Ema mak sasuꞌat ema toꞌo monu baa sala, ema nia netan dinu boot. ");
INSERT INTO tet_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kalo ema sasuꞌat ema kiꞌik ida toꞌo nia la fiar baa Haꞌu, Naꞌi Maromak atu taa ukun todan liu baa ema nia. Diꞌak liu, kesi fatuk boot ida baa niakaan kakorok, hotu soe nia baa tasi. ");
INSERT INTO tet_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Daka aan diꞌa-diꞌak, nebee keta halo ema monu baa sala. Kalo maluk ida nalo sala, deꞌan nia. Kalo nia nalo neon aat, hotu nia mai nusu pardua, maluꞌa lakon niakaan salan nia. ");
INSERT INTO tet_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kalo baa loron ida laran, maluk ida nalo sala dala hitu baa o, hotu nia nalo neon aat nodi nusu pardua kedas, o musti maluꞌa lakon niakaan salan dala hitu nia.” ");
INSERT INTO tet_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Baa loron ida, Yesus klosan sia mai nasoru Nia nodi nusu naꞌak, “Ama Boot! Amikaan fiar la biit. Tulun makbiit tuꞌan amikaan fiar lai.” ");
INSERT INTO tet_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesus nataa naꞌak, “Kalo fiar baa Naꞌi Maromak, masik fiar oan ida dei moos, ita bele haruka ai boot ida haꞌak, ‘Makfokit lori baa tasi.’ Ai nia nanis nakfokit kedas lori baa tasi.” ");
INSERT INTO tet_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Hotu, Yesus dale tenik naꞌak, “Lia nuneꞌe: noo ata ida mak fila rai iha naꞌin niakaan toꞌos no daka naꞌin niakaan bibi malae iha hae molik. Serwisu notu, ata nia fila uma. Toꞌo baa, kalo naꞌin dale baa nia naꞌak, ‘Mai ita rua haa ona!’ lia nia fatan ka? Lale! ");
INSERT INTO tet_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Fatan, kalo naꞌin naruka naꞌak, ‘Baa mahulin haa-hemu bodik haꞌu! Haꞌu kaa uluk lai, foin o maa.’ ");
INSERT INTO tet_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kalo ata nalo tuir naꞌin hakaran, naꞌin musti tonu nia ka? Lale! ");
INSERT INTO tet_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nunia moos emi. Kalo serwisu hotu tiꞌan bodik Naꞌi Maromak, emi musti dale haꞌak, ‘Ami neꞌe, ata dei. Ami la buka tonun. Ami halaꞌok naꞌin hakaran dei.’ ” ");
INSERT INTO tet_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Oras baa Yerusalem, Yesus sia toꞌo rai Galilea no rai Samaria kladik. ");
INSERT INTO tet_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tama baa leo ida, ema moras funi mea naꞌin sanulu mai nasoru Yesus. Sia nariik nosi dook, ");
INSERT INTO tet_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nodi nahii bele-bele naꞌak, “Ama Boot Yesus! Hadomi ami lai!” ");
INSERT INTO tet_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Titu-naree sia, Yesus naruka naꞌak, “Baa hatudu isin lolon baa naꞌilulik, nebee leno emikaan moras lakon tiꞌan ka sei.” Rona Yesus naruka nunia, sia moos baa. Iha dalan klaran, teki-tekis sia hotu-hotu diꞌak tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Haree nunia, sia laꞌo liu nodi neon diꞌak. Mais ema ida nosi sia fila baa Yesus nodi nahii naꞌak, “Tonu-haboot Naꞌi Maromak! Haꞌu diꞌak tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hotu nia nakniꞌa nodi sera dodan baa Yesus. (Tuir loos, ema ida neꞌe lahoos ema Yahudi, mais ema Samaria. Ema Samaria no ema Yahudi sakar malu nohuun.) ");
INSERT INTO tet_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Naree ema nia fila mai nunia, Yesus katak naꞌak, “Ohin nia Haꞌu kadiꞌak kola emi naꞌin sanulu! Naꞌin siwi iha nabee? ");
INSERT INTO tet_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tan saa ema maktabar neꞌe mesan mak mai tonu-naboot Naꞌi Maromak?” ");
INSERT INTO tet_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hotu Yesus katak tenik baa ema nia naꞌak, “Tan o fiar Haꞌu tebe-tebes, o diꞌak tiꞌan. Mariik! Fila ona!” ");
INSERT INTO tet_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Baa loron ida, ema Farisi naꞌin hira mai nusu baa Yesus naꞌak, “Ama Boot! Katak kokon lai! Wainhira Naꞌi Maromak nahuu nalaꞌok Niakaan ukun?” Yesus nataa naꞌak, “Lia nuneꞌe! Keta haneo Naꞌi Maromak nalaꞌok Niakaan ukun nodi tadak oi-oik mak ema raiklaran bele leno. Kalo ema katak naꞌak, ‘Haree kokon mai! Naꞌi Maromak nalaꞌok Niakaan ukun iha neꞌe!’, keta fiar. Kalo ema seluk naꞌak, ‘Naꞌi Maromak nalaꞌok Niakaan ukun iha nebaa!’, keta fiar. Ema la netan kakaer nunia, tan Naꞌi Maromak nalaꞌok Niakaan ukun iha itakaan neon laran.” ");
INSERT INTO tet_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hotu Yesus katak baa Niakaan maktuir sia naꞌak, “La kleur ona Haꞌu, Ema Raiklaran Isin neꞌe, la kamutuk ko emi tiꞌan. Loron susar toꞌo, emi atu beer Haꞌu, mais Haꞌu la iha ona. ");
INSERT INTO tet_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kalo ema balu mai katak naꞌak, ‘Kristus iha neꞌe!’ lale ema seluk katak naꞌak, ‘Kristus iha nebaa!’, lalika halau aan buka baa-mai, tan sia naktolek aan. ");
INSERT INTO tet_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Oras Ema Raiklaran Isin namaan aan mai nikar, niakaan tadak malorek basuk, hanesan mameran mak laka naroma laleꞌan nosi rohan baa rohan. ");
INSERT INTO tet_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mais Nia musti natiu susar oi-oik uluk lai, tan ema oras neꞌe la noꞌuk rona baa Nia. Sia moos atu dudu sees Nia. ");
INSERT INTO tet_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nosi ikus, oras Nia namaan aan mai nikar, ema atu moris nalo aat nuꞌu ema mak moris oras Noh otas. ");
INSERT INTO tet_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Baa otas nia, ema la noꞌuk rona. Sia naa-nemu, nalo dahur hola malu, toꞌo loron Noh tama baa roo. Teki-tekis, motasaꞌe boot mai, nadodok sia hotu. ");
INSERT INTO tet_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nosi ikus, oras Ema Raiklaran Isin namaan aan mai nikar, ema sia moos atu moris hanesan ema mak moris baa oras Lot otas. Baa otas nia, ema kota Sodom moris nalo aat nodi naa-nemu, nodi faꞌan no sosa, nodi serwisu toꞌos, no nariik uma. ");
INSERT INTO tet_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mais sia moos la noꞌuk rona. Hotu, baa seisawan ida, Lot nalai nela kota Sodom. Teki-tekis, fatuk laak mak nasai dubun raso monu nosi laleꞌan mai, sunu mohu ema Sodom sia. ");
INSERT INTO tet_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dadi, sintidu! Oras Ema Raiklaran Isin namaan aan mai nikar, keta toꞌo emi moris halo aat nunia, tan teki-tekis Nia mosu mai. ");
INSERT INTO tet_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Baa loron nia, ema mak iha uma tehen, keta tama uma ona atu nahulin naha. Ema mak serwisu iha toꞌos, keta fila uma ona atu nola naha. ");
INSERT INTO tet_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Hanoin saa mak uluk dadi baa Lot feen. Nia mate, tan nanoin naha iha uma. ");
INSERT INTO tet_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ema mak la noꞌuk tuir Haꞌu tan beer aan duꞌuk, nosi ikus, nia moris butan. Mais ema mak noꞌuk tuir toꞌo latan moris tan beer Haꞌu, nosi ikus, nia netan moris nohuun no Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Rona! Nosi ikus, oras Ema Raiklaran Isin namaan aan mai nikar, ema naꞌin rua toba iha fatik ida. Teki-tekis Naꞌi Maromak foti nola ida, nabusik nela ida. ");
INSERT INTO tet_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Feto naꞌin rua ledu hare namutuk, Naꞌi Maromak foti nola ida, nabusik nela ida. ");
INSERT INTO tet_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ema naꞌin rua serwisu namutuk iha toꞌos, Naꞌi Maromak foti nola ida, nabusik nela ida.” ");
INSERT INTO tet_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Rona nola nunia, Yesus Niakaan maktuir sia nusu naꞌak, “Ama Boot! Lia nia sia atu dadi iha nabee?” Hotu, Yesus soe lia naꞌak, “Naꞌan dodok iha nabee, manu kawaa iha nebaa.” Yesus dale lia funin naꞌak, oras Kristus namaan aan mai nikar, ema hotu-hotu bele naree. ");
INSERT INTO tet_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Baa dala ida, Yesus nanorin Niakaan maktuir sia nodi lia hatetek, nebee sia namulak la nakotu, neon la naklara, no fiar baa Naꞌi Maromak nohuun. ");
INSERT INTO tet_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Lia nia nuneꞌe: “Noo ema makotu lia ida iha kota ida. Nia la fiar baa Naꞌi Maromak. Nia la titu ema ida no. ");
INSERT INTO tet_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Iha kota nia moos, noo feto faluk ida. Nia mai hei-hein baa makotu lia nia nodi nusu naꞌak, ‘Ama makotu lia! Makotu haꞌukaan lia malo loos!’ ");
INSERT INTO tet_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Uluk fohon makotu lia nia la titu feto faluk nia. Mais feto nia mai hei-hein toꞌo makotu lia la noꞌuk rona ona, nodi naneo naꞌak, ‘Uras Naꞌi Maromak dei, haꞌu la ktitu tiꞌan, saa tenik baa ema raiklaran. ");
INSERT INTO tet_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mais tan feto neꞌe nalo haꞌukaan ulun kalanuk, diꞌak liu kakotu niakaan lia kalo loos. Kalo lale, nia mai hei-hein nakole haꞌu nohuun.’ ” ");
INSERT INTO tet_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hotu Yesus katak tenik baa maktuir sia naꞌak, “Emi hanoin kokon baa makotu lia neꞌe lian. Masik nia la loos, kleu-leur nia tulun feto faluk nia. ");
INSERT INTO tet_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kalo ema mak la loos nakara tulun ema nunia, Naꞌi Maromak nanis nakara tulun Niakaan eman mak namulak loron-kalan nusu tulun baa Nia. Mais Nia la nalo nuꞌu makotu lia nia, ");
INSERT INTO tet_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","tan Nia babilan kedas. Haꞌu kusu nuneꞌe: kalo Haꞌu, Ema Raiklaran Isin neꞌe, mai kikar tiꞌan, takseer Haꞌu ksei bele kasoru ema makfiar iha raiklaran neꞌe ka, lale?” ");
INSERT INTO tet_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus dale tenik lia hatetek ida, nosi lia ema mak nahaas aan nodi titu naraik ema seluk. Nia dale naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Noo mane naꞌin rua baa namulak iha uma hamulak. Ida nosi partee Farisi, ida tenik maksisi bea. Ema Yahudi sia nafoli ema Farisi naꞌak, ema moos. Mais nafoli maksisi bea naꞌak, ema lisan aat. ");
INSERT INTO tet_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Toꞌo uma hamulak baa, ema Farisi nariik namulak nodi foti aan duꞌuk naꞌak, ‘Haꞌu kamulak sera dodan baa Naꞌi Maromak, tan haꞌu ema diꞌak. Haꞌu la aat nuꞌu ema seluk sia. Haꞌu la kanaꞌo. Haꞌu la krotus. Haꞌu la kakur biti-kluni. Haꞌu moos la aat nuꞌu maksisi bea neꞌe. ");
INSERT INTO tet_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Haꞌu madinas kalirin aan domiku ida, dala rua. Haꞌu moos foo faꞌek ida nosi fafaꞌek sanulu mak haꞌu ketan.’ Ema Farisi nia namulak nunia. ");
INSERT INTO tet_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mais ema maksisi bea nia nariik dook iha kotuk baa. Nia la naksakar aan foti oin atu titu baa laleꞌan. Nia namulak sudur ulun nodi neon dodok naꞌak, ‘Aaa, Naꞌi Maromak. Madomi haꞌu ema sala neꞌe! Foo pardua baa haꞌu lai!’ ” ");
INSERT INTO tet_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Dale notu, Yesus nusu naꞌak, “Baa oras mane rua nia fila uma, see mak diꞌa-diꞌak nikar no Naꞌi Maromak? Ema Farisi ka, ema maksisi bea? Nanis Naꞌi Maromak simu diꞌa-diꞌak maksisi bea mak naraik aan. Mais la rona ema Farisi nia. Tan Naꞌi Maromak naraik ema mak loko aan, mais foti saꞌe ema mak naraik aan.” ");
INSERT INTO tet_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Baa dala ida, ema nakaꞌu nodi lawarik oan sia mai baa Yesus, nebee Nia rai liman nodi foo matak-malirin baa sia. Naree nunia, Yesus Niakaan maktuir sia deꞌan ema nia sia. ");
INSERT INTO tet_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Mais Yesus simu oa nia sia mai baa Nia. Nia deꞌan maktuir sia naꞌak, “Habusik lawarik oan sia mai baa Haꞌu. Keta saseni sia! Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Ema mak nakara dadi baa Naꞌi Maromak eman, musti nakriꞌit aan baa Naꞌi Maromak, hanesan lawarik oan nakriꞌit aan baa inan-aman.” ");
INSERT INTO tet_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Baa dala ida, naꞌilulik Yahudi ida mai nusu baa Yesus naꞌak, “Ama Boot mak kneter basuk! Ama tulun manorin Haꞌu nebee haꞌu kbele katene oin nunabee, haꞌu kbele tama laleꞌan atu moris nima-nimak ko Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus nataa naꞌak, “Tan saa o masee Haꞌu, ‘mak kneter basuk’? Kmesak ida dei mak kneter basuk. Nia mak Maromak. ");
INSERT INTO tet_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O matene nanis ukun-badu hori uluk naꞌak: Keta halo lia kfoꞌer; keta hoꞌo ema; keta hanaꞌo; keta dale hahaat ema; no musti hakneter inan-aman.” ");
INSERT INTO tet_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ema nia nataa naꞌak, “Tebes, Ama! Haꞌu ktuir ukun-badu nia sia tiꞌan, nahuu hori ksei kiꞌik.” ");
INSERT INTO tet_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Rona nola nunia, Yesus naꞌak, “Diꞌak! Mais lia nia sei la toꞌo dauk. O musti baa faꞌan okaan sasoin sia hotu-hotu. Hotu, faꞌe osan baa ema mukit sia. Halo nunia lai, foin mai tuir Haꞌu. Nosi ikus, Naꞌi Maromak selu sasoin iha laleꞌan baa o.” ");
INSERT INTO tet_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Rona nola nunia, ema nia neon susar, tan soi toꞌo. ");
INSERT INTO tet_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hotu, nia fila nodi neon dodok. Naree nunia, Yesus katak baa Niakaan maktuir sia naꞌak, “Maksoin susar basuk tama laleꞌan. ");
INSERT INTO tet_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hanesa no lia seluk mak naꞌak, kuda unta la bele tama laluꞌan tuir daun kuak. Nunia moos ema mak naloon loos baa sasoin dei, la naloon baa Naꞌi Maromak. Nia la bele tama laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hotu, ema sia mak rona Yesus dale nunia, nusu naꞌak, “Kalo susar tebes maksoin tama laleꞌan, ema oin nunabee mak bele netan moris?” ");
INSERT INTO tet_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus nataa naꞌak, “Noo lia waꞌin mak ema raiklaran la bele nalo. Mais Naꞌi Maromak bele nalo lia hotu-hotu.” ");
INSERT INTO tet_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hotu Petrus natutan naꞌak, “Ama! Ami laꞌo hela tiꞌan amikaan sasoin sia hotu-hotu atu tuir Ama. Mais ami atu hetan saa?” ");
INSERT INTO tet_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus nataa naꞌak, “Petrus! Rona diꞌa-diꞌak, tan Haꞌukaan dalen neꞌe, tebes no loos! Ema mak laꞌo nela niakaan uma, niakaan feen, niakaan maun-biin-alin, niakaan inan-aman, lale niakaan oan sia, tan nia nalaꞌok Naꞌi Maromak serwisu, ");
INSERT INTO tet_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nanis nia simu nikar waꞌin liu iha raiklaran neꞌe. Nosi ikus, oras raiklaran falu fila, nia moos simu moris nima-nimak no Naꞌi Maromak.” ");
INSERT INTO tet_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nunia hotu, Yesus nodi Niakaan maktuir naꞌin sanulu resin rua laꞌo liu baa, nebee Nia dale mesan baa sia naꞌak, “Oras neꞌe ita atu baa kota Yerusalem. Toꞌo nebaa, lia hotu-hotu mak Maromak makoꞌan sia nakerek kedan nosi lia Ema Raiklaran Isin atu dadi, tuir saa mak sia nakerek nela. ");
INSERT INTO tet_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ema atu latan Haꞌu baa ema maktabar sia mak la fiar baa Maromak. Hotu sia naleuk Haꞌu, nahaat Haꞌu oi-oik, soe kaban baa Haꞌu, ");
INSERT INTO tet_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","taꞌe Haꞌu, hotu noꞌo Haꞌu. Mais baa wainrua, Haꞌu kmoris kikar.” ");
INSERT INTO tet_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Rona nola Yesus dale nunia, maktuir sia benar, tan sia sei la bele kohi dauk lia fuan nia isin. ");
INSERT INTO tet_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Baa oras Yesus no Niakaan maktuir sia atu tama baa kota Yeriko, sia nasoru nola ema delek ida mak tuur nodi nadidu iha dalan tehen. ");
INSERT INTO tet_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Rona ema lear laꞌo tuir nia, delek nia nusu naꞌak, “Hei! See neꞌe sia?” ");
INSERT INTO tet_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ema katak baa delek nia naꞌak, “Yesus, ema Nasaret, laꞌo tuir neꞌe.” ");
INSERT INTO tet_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Rona nola lia nia, delek nia nahii makaꞌas naꞌak, “Yesus! Naꞌi Daud husar-binan! Madomi haꞌu lai!” ");
INSERT INTO tet_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nia nahii nunia, mais ema mak laꞌo iha Yesus oin nakahik nebee nia no-nook. Mais nia hetak nahii tuꞌan naꞌak, “Hei! Naꞌi Daud husar-binan! Madomi haꞌu lai!” ");
INSERT INTO tet_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Rona nola delek nia nahii, Yesus moos nariik. Nia naruka ema nalaꞌok nodi delek nia mai. Toꞌo Yesus oin, Yesus nusu baa delek nia naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O makara kalo saa baa o?” Delek nia nataa naꞌak, “Ama Boot! Haꞌu kakara nebee haꞌu kbele karee.” ");
INSERT INTO tet_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus nataa naꞌak, “Diꞌak. Tan o fiar maꞌak, Haꞌu kbele kadiꞌak kola o, oras neꞌe moos, okaan matan moon ona.” ");
INSERT INTO tet_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesus dale nunia, delek nia matan moon kedas. Hotu, nia tuir Yesus nodi tonu-naboot Naꞌi Maromak. Ema hotu-hotu mak naree, sia moos tonu-naboot Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nunia hotu, Yesus sia tama tuir kota Yeriko atu laꞌo liu baa Yerusalem. ");
INSERT INTO tet_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Iha kota Yeriko nia, noo ema ida naran Sakeos. Sakeos nia, maksisi bea ulun bodik ukunrai Roma. Nia moos ema maksoin. ");
INSERT INTO tet_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Baa oras rona naꞌak Yesus atu laꞌo liu, Sakeos nakara naree Yesus. Mais Sakeos basuk basuk. Nia la bele titu-naree Yesus diꞌa-diꞌak, tan ema lear kabuun nola Yesus tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tan baa nia, nia nalai uluk, saꞌe baa ai ida leten iha dalan tehen mak Yesus atu laꞌo tuir. ");
INSERT INTO tet_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Toꞌo ai nia, Yesus tanaat baa leten nodi bolu naꞌak, “Sakeos! Sakeos! Tuun mai lai-lais! Tan ohin loron neꞌe, Haꞌu atu ktuli iha okaan uma.” ");
INSERT INTO tet_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Rona nola nunia, Sakeos blaar karin. Nia tuun lai-lais, hotu nodi Yesus baa uma. Nia neon boot lo-loos. ");
INSERT INTO tet_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mais ema waꞌin nakmuuk naꞌak, “Hoi! Ema hotu-hotu natene Sakeos neꞌe lisan aat! Tan saa Yesus tuli niakaan uma?!” ");
INSERT INTO tet_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Toꞌo uma baa, Sakeos nariik iha Yesus oin, hotu dale naꞌak, “Ama Boot! Nahuu ohin loron neꞌe, haꞌu kfaꞌe baa rua haꞌukaan sasoin hotu-hotu, nebee faꞌek ida haꞌu kfoo baa ema mukit sia. Bodik ema mak haꞌu kusu bea liu, haꞌu kselu kikar isin haat.” ");
INSERT INTO tet_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus nataa naꞌak, “Diꞌak. Ohin loron neꞌe Naꞌi Maromak sori o mo okaan ema uma laran hotu-hotu tiꞌan, tan o fiar Naꞌi Maromak nuꞌu Bei Abraham. ");
INSERT INTO tet_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Naꞌi Maromak solok Haꞌu kdadi Ema Raiklaran Isin iha raiklaran neꞌe. Haꞌu kmai atu buka ema mak sees nosi Naꞌi Maromak dalan, nebee Haꞌu ksori sia.” ");
INSERT INTO tet_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Baa oras nia, ema waꞌin tuir nanono Yesus. Toꞌo kreꞌis kota Yerusalem, sia naneo naꞌak Yesus atu nalaꞌok Naꞌi Maromak ukun hanesan naꞌin ona. Mais tan sia nanoin sala nunia, Yesus dale baa sia lia hatetek ida ");
INSERT INTO tet_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","naꞌak, “Noo naꞌin kiꞌik ida. Nia atu baa rai seluk, nebee ema foti nia dadi baa naꞌin boot. Foti tiꞌan, foin nia mai nikar. ");
INSERT INTO tet_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Baa oras nia nadiꞌa aan atu laꞌo, nia bolu nola niakaan ata naꞌin sanulu. Nia faꞌe baa ida-idak osan mean matak ida. Hotu nia naruka sia naꞌak, ‘Halo osan neꞌe dadi baa osan naꞌin. Kalo haꞌu kmai kikar, emi musti hasara funan hira.’ Dale notu nunia, nia moos laꞌo. ");
INSERT INTO tet_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mais niakaan hutun-renu sia hirus nia. Sia solok klosan tuir baa nebaa atu katak naꞌak, ‘Ami la hoꞌuk ema neꞌe kaer ukun baa ami.’ ");
INSERT INTO tet_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Masik nunia moos, sia foti nia dadi baa naꞌin boot. Foti tiꞌan, nia fila. Toꞌo uma baa, nia bolu nola ata sanulu nia, nodi nusu naꞌak, ‘Emi hetan funan hira hosi osan mak haꞌu kfoo baa emi nia?’ ");
INSERT INTO tet_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ata nomer ida nasara naꞌak, ‘Ama naꞌi! Haꞌu ketan funan dala sanulu.’ ");
INSERT INTO tet_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naꞌin nataa naꞌak, ‘Kabaas! O neꞌe, ata diꞌak. Haꞌu kbele fiar o kodi lia kiꞌik. Tan baa nia, haꞌu kfoti o kaer ukun baa kota sanulu.’ ");
INSERT INTO tet_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hotu, ata nomer rua nasara naꞌak, ‘Ama naꞌi! Ketan funan dala lima.’ ");
INSERT INTO tet_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naꞌin tonu nia naꞌak, ‘Kabaas! Kalo nunia, haꞌu kfoti o kaer ukun baa kota lima.’ ");
INSERT INTO tet_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mais ata nomer tolu, nodi nikar niakaan osan mai. Nia nasara naꞌak, ‘Neꞌe, ama naꞌi osan! Haꞌu kfalun kodi subar diꞌa-diꞌak, nebee keta lakon. ");
INSERT INTO tet_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Haꞌu kalo nunia, tan kataꞌuk. Haꞌu katene ama neꞌe, makaꞌas. Ama nakara nola saa mak lahoos ama niakaan, no kuꞌu nola saa mak lahoos ama kuda.’ ");
INSERT INTO tet_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Rona nola nunia, naꞌin nakanas ata nia naꞌak, ‘Hoi! Notar lalek! Okaan dale nia kastikar okaan isin lolon duꞌuk. O matene tiꞌan, haꞌu neꞌe ema makaꞌas, mak kola saa mak lahoos haꞌukaan, kodi kuꞌu kola saa mak lahoos haꞌu kuda. ");
INSERT INTO tet_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tan saa o la rai osan nia iha uma rai osan? Nebee oras haꞌu kfila mai, bele ketan funan. Masik oan ida dei moos, diꞌak.’ ");
INSERT INTO tet_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hotu naꞌin naruka ema seluk sia naꞌak, ‘Hola osan nia, latan baa ata mak netan funan dala sanulu.’ ");
INSERT INTO tet_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mais sia nataa naꞌak, ‘Ama! Ema nia netan toꞌo tiꞌan. Tan saa hola hosi ema mak netan oan ida dei, hotu foo tuꞌan baa ema mak netan waꞌin?’ ");
INSERT INTO tet_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naꞌin nataa naꞌak, ‘Hanoin diꞌa-diꞌak! Ema mak natene babilan saa mak ema fiar atu foo baa nia, ema nia atu netan tuꞌan tenik. Mais ema mak baruk babilan, ema seluk atu nola mohu saa mak niakaan. ");
INSERT INTO tet_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Baa kohi haꞌukaan funu sia mak la nakara haꞌu kdadi naꞌin! Hodi mai neꞌe, hotu hoꞌo hotu-hotu iha haꞌukaan oin. Baa ona!’ ” ");
INSERT INTO tet_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus dale notu nunia, sia laꞌo liu baa Yerusalem. Yesus laꞌo iha oin. ");
INSERT INTO tet_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nareꞌis aan baa leo Betfage no leo Betania iha Foho Saitun tehen, Nia naruka Niakaan maktuir naꞌin rua baa uluk ");
INSERT INTO tet_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nodi naꞌak, “Emi rua baa leo iha oin nia. Emi atu haree kuda keledai oan ida, ema noꞌi kesi iha nia. Ema sei la saꞌe dauk. Kore, hodi mai. ");
INSERT INTO tet_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kalo ema nusu naꞌak, ‘Tan saa emi kore kuda keledai nia?’ emi hataa sia haꞌak, ‘Ulun atu saꞌe.’ ” ");
INSERT INTO tet_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hotu, sia baa. Sia netan kuda keledai oan nia, tuir Yesus dalen. ");
INSERT INTO tet_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Baa oras sia kore, kuda naꞌin nusu sia naꞌak, “Tan saa emi kore kuda keledai neꞌe?” ");
INSERT INTO tet_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sia moos nataa naꞌak, “Ulun atu saꞌe.” ");
INSERT INTO tet_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kuda naꞌin moos simu. Hotu sia rua dada nodi baa Yesus. Sia taka tais hafuꞌut baa kuda keledai, hotu Yesus saꞌe baa. ");
INSERT INTO tet_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ema lear iha nia nola siakaan tais hafuꞌut no tais sakat, naꞌe baa dalan. Hodi nunia, sia simu Yesus hanesan simu Naꞌi boot. ");
INSERT INTO tet_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oras Yesus nahuu tuun nosi Foho Saitun, ema lear nia no Niakaan maktuir sia nahii tonu-naboot Naꞌi Maromak, tan tadak blaar hotu-hotu mak sia naree tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sia nahii naꞌak, “Ema neꞌe, Naꞌin mak Maromak solok mai! Maromak foo matak-malirin baa Nia! Oras neꞌe, ema raiklaran bele dame malu no Maromak iha laleꞌan ona. Tonu-haboot Maromak mak nabesi aan kaer ukun iha laleꞌan mak aas kaliuk.” ");
INSERT INTO tet_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oras nia, noo ema Farisi sia iha ema lear nia leet. Sia nasara baa Yesus naꞌak, “Ama! Kahi sia nebee sia keta nahii nunia! Neꞌe, liu resik tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mais Yesus nataa naꞌak, “Hoi! Haꞌu katak kedan! Kalo ema neꞌe sia taka ibun, fatuk sia mak tonu-naboot Maromak!” ");
INSERT INTO tet_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kreꞌis Yerusalem ona, Yesus titu-naree kota nia. Nia tanis nodi naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Adeei, ema Yerusalem sia! Haꞌu kakara nebee emi simu dame mak kodi mai baa loron neꞌe. Mais emi la titu Maromak. Oras neꞌe, la noo leet ona. Dame dook tiꞌan nosi emi. ");
INSERT INTO tet_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Emikaan funu sia atu butuk satan nola emikaan kota, toꞌo emi la bele sasin. Hotu sia tama tuda emi, ");
INSERT INTO tet_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","nodi naroꞌon emikaan kota weer toꞌo rai. Hotu sia noꞌo emi ho emikaan oan hotu-hotu. La nela fatuk ida mak nariik, tan Maromak namaan aan mai atu sori emi, mais emi la simu Nia!” ");
INSERT INTO tet_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nunia hotu, Yesus tama baa Uma Hamulak Huun. Iha lalawar laran, ema faꞌan bibi no karau no manu mak ema sosa atu sera baa Naꞌi Maromak. Titu-naree nunia, Yesus teꞌur sai sia. ");
INSERT INTO tet_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nia nakanas naꞌak, “Maromak makoꞌan nakerek kedan naꞌak, ‘Haꞌu kariik Uma neꞌe, nebee ema hotu-hotu bele mai namulak baa.’ Mais emi halo fatik neꞌe dadi baa ema naꞌok nuuk!” ");
INSERT INTO tet_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesus dale notu nunia, sura loron Nia baa Uma Hamulak Huun atu nanorin. Mais naꞌilulik Yahudi, manorik ukun Yahudi, no fukun Yahudi sia buka dalan atu noꞌo Nia. ");
INSERT INTO tet_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mais sia la netan dalan, tan ema lear beer basuk nanono baa Yesus. ");
INSERT INTO tet_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Loron ida Yesus baa Uma Hamulak Huun, hotu nanorin Manfatin Diꞌak iha lalawar laran. Baa oras nia, naꞌilulik sia, manorik ukun sia, no fukun Yahudi sia mai nusu lia baa Nia ");
INSERT INTO tet_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","naꞌak, “Hori hirak nia, O tokar lauk iha neꞌe! See mak latan beran nia baa O? Katak kokon lai!” ");
INSERT INTO tet_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus nataa naꞌak, “Haꞌu kakara kusu lia ida lai, foin Haꞌu kataa emi. ");
INSERT INTO tet_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nuneꞌe: Ita hotu-hotu hatene Yohanis, ema nia mak sarani ema. See mak latan beran baa nia nebee sarani ema? Naꞌi Maromak ka, ema raiklaran? Emi haꞌak kokon!” ");
INSERT INTO tet_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Rona nola nunia, sia koꞌa lia baa-mai nodi dale naꞌak, “Adeei! Ita tatalik tiꞌan. Kalo ita haꞌak, ‘Naꞌi Maromak mak latan beran,’ Nia atu nataa nikar naꞌak, ‘Kalo nunia, tan saa emi la fiar Yohanis?’ ");
INSERT INTO tet_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mais ita moos la bele haꞌak, ‘Ema raiklaran mak latan beran,’ tan kalo ita haꞌak nunia, ema neꞌe sia atu foti fatuk nitak noꞌo ita. Tan sia fiar naꞌak, Yohanis nia, Maromak makoꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sia nanoin baa-mai nunia, hotu sia nataa Yesus naꞌak, “Ami la hatene.” ");
INSERT INTO tet_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus moos nataa nikar naꞌak, “Kalo nunia, Haꞌu moos la kaꞌak baa emi, see mak latan beran baa Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hotu, Yesus dale baa ema lear iha nia nodi lia hatetek naꞌak, “Noo ema ida mak nalo toꞌos anggor. Hotu nia seba toꞌos nia baa ema serwisu toꞌos, nebee sia faꞌe toꞌos isin baa malu. Hotu toꞌos naꞌin lori baa rai seluk, nein kleu-leur iha nebaa. ");
INSERT INTO tet_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Toꞌo oras kuꞌu, toꞌos naꞌin naruka niakaan ema ain-liman ida baa simu niakaan fafaꞌek. Mais ema mak serwisu toꞌos nia sia taꞌe nahoras ema nia, hotu teꞌur fila nodi liman mamuk. ");
INSERT INTO tet_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Naree nunia, toꞌos naꞌin solok ema ain-liman ida seluk baa. Mais ema serwisu sia moos taꞌe nahoras nodi namoe nia. Hotu sia teꞌur fila tenik nodi liman mamuk. ");
INSERT INTO tet_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nunia hotu, toꞌos naꞌin solok tenik niakaan ema nomer tolu baa. Mais sia taꞌe nakane nia, hotu soe sai. ");
INSERT INTO tet_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Naree nunia, toꞌos naꞌin naneo naꞌak, ‘Haꞌu kmusti kalo nunabee tenik? Diꞌak liu, haꞌu ksolok haꞌukaan oan dadobe. Kalo haꞌu ksolok nia, nanis sia simu no rona nia diꞌa-diꞌak.’ Hotu, nia moos nakotu solok oan dadobe baa. ");
INSERT INTO tet_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mais baa oras ema serwisu sia titu-naree oan nia mai, sia dale baa malu naꞌak, ‘Hoi, haree lai! Ama katuas solok oan duꞌuk mai tiꞌan. Nia neꞌe mak atu simu katuas sasoin hotu-hotu. Diꞌak liu ita hoꞌo nia, nebee hola toꞌos neꞌe bodik ita.’ ");
INSERT INTO tet_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Oan nia toꞌo baa, sia dada sai nia nosi toꞌos, hotu noꞌo.” Dale notu nunia, Yesus nusu baa ema boot nia sia naꞌak, “Oras neꞌe, Haꞌu atu kusu nuneꞌe: Toꞌos naꞌin nia atu nalo saa baa ema serwisu toꞌos nia sia? ");
INSERT INTO tet_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tuir Haꞌu, nia nanis mai noꞌo mohu sia, hotu foo toꞌos nia baa ema seluk.” Rona nola Yesus dale nunia, ema boot nia sia natene naꞌak Yesus soe lia baa sia. Hotu sia nataa naꞌak, “Kalo bele, keta toꞌo noo kastikar nunia!” ");
INSERT INTO tet_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mais Yesus natutuk makaꞌas sia, nodi nusu naꞌak, “Kalo la noo kastikar nunia, tan saa Maromak makoꞌan nakerek nela kedan naꞌak: ‘Noo fatuk ida mak badaen fatuk sia soe lerek tiꞌan. Mais oras neꞌe fatuk nia dadi baa uma tatuur fatuk tiꞌan.’? ");
INSERT INTO tet_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Rona diꞌa-diꞌak. Ema mak nakloti kona fatuk nia, nanis netan kastikar. Mais kalo fatuk nia monu kona ema, ema nia netan kastikar todan liu tan.” ");
INSERT INTO tet_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Rona nola nunia, manorik ukun no naꞌilulik sia natene naꞌak Yesus soe lia baa sia nodi lia hatetek nia. Sia manesak no ema serwisu toꞌos lisan aat sia no badaen mak soe fatuk nia. Tan baa nia, sia buka dalan atu kohi kedas Yesus. Mais sia nakerat baa ema lear mak beer Yesus hanorin. Hotu sia laꞌo nela Yesus. ");
INSERT INTO tet_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Baa oras nia, ema mak funu Yesus buka dalan atu kohi Nia. Sia dale kabuar lia atu solok ema mak bele nalo aan nuꞌu ema matenek, atu baa nahonu Yesus. Sia nakara nebee Yesus sakar ukunrai Roma. Hodi nunia, sia bele nasaꞌe lia baa gubernur, nebee gubernur kohi Yesus. ");
INSERT INTO tet_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dale notu tiꞌan, sia solok ema baa nalo lia no Yesus. Toꞌo baa, ema nia nasee Yesus naꞌak, “Ama Boot! Ami hatene Ama neon loos. Ama la naktolek, no la fihir oin. Ama moos nanorin Maromak dalan moris nodi moon. ");
INSERT INTO tet_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Oras neꞌe, ami atu husu lia ida baa Ama nuneꞌe: Tuir itakaan ukun-badu Yahudi, ita musti selu bea baa liurai Roma ka, lale?” ");
INSERT INTO tet_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesus natene siakaan kakutak aat nia. Hotu nataa naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Hatudu kokon osan murak tomak ida baa haꞌu lai.” Hotu sia natudu osan baa. Yesus simu nola nodi leno diꞌa-diꞌak, hotu nusu baa sia naꞌak, “Neꞌe, see niakaan oin? Neꞌe, see niakaan naran?” Sia nataa naꞌak, “Nia, Keser, mak liurai Roma.” ");
INSERT INTO tet_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesus moos katak naꞌak, “Kalo nunia, foo baa ukunrai, saa mak ukunrai niakaan. Foo baa Maromak, saa mak Maromak Niakaan.” ");
INSERT INTO tet_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Rona nola nunia, sia blaar karin, tan la bele nahonu Nia iha ema waꞌin oin. Tan lia nia, sia taka ibun dei. ");
INSERT INTO tet_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nunia hotu, ema naꞌin hira nosi partee Saduki mai buka atu nahonu Yesus. Ema Saduki sia nanorin naꞌak, loron ikus baa oras rai falu fila, ema mak mate tiꞌan, la moris nikar. Etuk, sia nalo lia no Yesus naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ama Boot! Ami husu Ama hanorin ami lia neꞌe lai. Bei Musa nakerek nela baa ita ema Yahudi, ukun-badu neꞌe naꞌak: Kalo mane ida mate nela feen, mais la noo oan, niakaan alin musti nola feto faluk nia, nebee foo husar-binan baa niakaan maun mak mate tiꞌan nia. ");
INSERT INTO tet_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bei Musa nanorin uluk tebes nunia. Mais noo lia ida nuneꞌe: Noo mane maun-alin naꞌin hitu. Mane ulun nola feto, hotu mate, mais la noo oan. ");
INSERT INTO tet_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hotu, alin mak tuir nia, nola nikar feto faluk nia. Mais la kleur, alin moos mate, la noo oan. ");
INSERT INTO tet_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nunia tenik, alin susu dala rua. Nia nola feto nia. Mais nia moos mate, la noo oan tenik. Nunia bei-beik toꞌo alin ikun moos mate. ");
INSERT INTO tet_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nosi ikus, feto faluk nia moos mate. ");
INSERT INTO tet_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Oras neꞌe, ami hakara husu Ama nuneꞌe: Feto nia nalaꞌe mane naꞌin hitu tiꞌan. Nosi ikus, baa oras rai falu fila, Naꞌi Maromak nalo ema maten sia moris nikar, feto nia dadi feen bodik mane mak nabee?” ");
INSERT INTO tet_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Rona nola nunia, Yesus nataa naꞌak, “Ema raiklaran nola malu iha raiklaran neꞌe dei. ");
INSERT INTO tet_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Iha laleꞌan, ema la nola malu tenik. Iha nebaa moos, sia la mate tenik. Tan sia dadi nuꞌu Maromak Niakaan makbukar laleꞌan sia tiꞌan. Baa oras Naꞌi Maromak nalo ema mak mate tiꞌan sia moris nikar, Nia moos boi nola sia, dadi baa Niakaan oan. ");
INSERT INTO tet_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Haꞌu moos kalore tenik kosi lia ema mak mate tiꞌan sia bele moris nikar ka, lale. Uluk aan, Bei Musa nakerek lia nosi ai huun kiꞌik mak haꞌi naa mais la namotuk. Baa oras haꞌi naa ai huun nia, Bei Musa temi Naꞌi Maromak naꞌak, ‘Haꞌukaan Bei Abraham, Bei Isak no Bei Yakob, siakaan Maromak. Sia hotu-hotu loꞌu-sudur baa Naꞌi Maromak hori uluk toꞌo oras neꞌe.’ ");
INSERT INTO tet_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kalo ita leno lia nia, ita hatene haꞌak, baa oras Bei Musa dale nunia, bei nia sia mate kleur tiꞌan. Mais Bei Musa dale naꞌak, sia sei loꞌu-sudur baa Naꞌi Maromak. Lia nia naꞌak, siakaan kmalar sei moris. Dadi, masik ema mate tiꞌan moos, bele moris nikar. Tan ema mak moris dei mak bele loꞌu-sudur baa Naꞌi Maromak!” ");
INSERT INTO tet_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Rona Yesus nataa nunia, manorik ukun naꞌin hira moos dale naꞌak, “Ama Boot hataa nunia, kona basuk.” ");
INSERT INTO tet_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nahuu baa oras nia, la noo ema ida mak naksakar aan nusu tenik Yesus, tan la noo mak bele nahonu Nia. ");
INSERT INTO tet_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hotu, Yesus nanorin tenik ema iha Uma Hamulak Huun. Nia nusu fila sia naꞌak, “Tuir emikaan hanoin, nunabee? Itakaan ema manorik sia nanorin naꞌak, Kristus nia, Ema mak Naꞌi Maromak natudu hori uluk. Tuir sia, Nia dadi Naꞌi Daud husar-binan loos dei. Mais lia nia sei la toꞌo dauk. ");
INSERT INTO tet_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tan uluk Naꞌi Daud duꞌuk nakerek iha Kananuk laran naꞌak, ‘Naꞌi Maromak foo natene baa haꞌukaan naꞌi naꞌak, “Mai tuur baa fatin kneter neꞌe, iha haꞌukaan sorin kwana. ");
INSERT INTO tet_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tan haꞌu atu kalo okaan funu sia, toꞌo loꞌu baa o.’ ” ");
INSERT INTO tet_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nosi hakerek nia, ita hatene Naꞌi Daud duꞌuk temi Kristus nia naꞌak, ‘Naꞌi.’ Tan lia nia, ita bele hatene kalo ema naꞌak Kristus nia, Naꞌi Daud husar-binan loos dei, lia nia sei la toꞌo dauk! Tan Nia moos Naꞌi Daud Naꞌin!” ");
INSERT INTO tet_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Baa oras ema hotu-hotu taꞌan tilun nanono Yesus, Nia moos dale baa Niakaan maktuir sia naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sintidu baa ema manorik ukun sia. Sia tau faru klobor dasa rai, nodi labu baa nasoru ema lear, nebee ema tonu sia naꞌak, ema moon. Sia buka fatik kneter kaliuk iha uma hamulak, iha dahur, no iha ema lear oin. ");
INSERT INTO tet_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mais sintidu! Tan sia naktolek feto faluk toꞌo nadau nola siakaan uma. Mais iha ema lear oin, sia subar mate siakaan aꞌaat. Sia nariik nodi namulak toꞌo kleu-leur, tan nakara nebee ema tonu sia naꞌak, ema moon. Mais Naꞌi Maromak natene siakaan aꞌaat. Nosi ikus, Nia atu natuun kastikar todan liu baa sia.” ");
INSERT INTO tet_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Baa oras Yesus nanorin iha Uma Hamulak Huun, Nia titu-naree maksoin sia natama osan baa ai balun sera. ");
INSERT INTO tet_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","La kleur, feto faluk mukit ida moos mai tuir namulak. Nia natama osan lahon rua baa ai balun nia. Osan nia folin, kiꞌik basuk. ");
INSERT INTO tet_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Naree nunia, Yesus dale baa Niakaan maktuir sia naꞌak, “Haree baa lai! Feto faluk mukit neꞌe natama osan lahon rua dei, mais niakaan sera nia, boot liu nosi ema hotu-hotu siakaan sera. ");
INSERT INTO tet_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ema seluk sia foo sera nosi siakaan osan resin. Mais feto faluk neꞌe sera mohu niakaan osan hotu-hotu, toꞌo osan atu nola haan moos, la nela.” ");
INSERT INTO tet_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Baa oras nia, Yesus Niakaan maktuir sia mose Uma Hamulak Huun naꞌak, “Ama! Haree kokon! Uma neꞌe, kabaas basuk! Ema nada fatuk fera boot sia, diꞌak basuk. Sia moos sera naha folin todan hodi hafutar Naꞌi Maromak Uman neꞌe!” Mais Yesus nataa naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Uma neꞌe kabaas tebes. Mais la kleur ona, ema atu naroꞌon mohu fatuk neꞌe sia, toꞌo weer baa rai.” ");
INSERT INTO tet_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hotu Yesus Niakaan maktuir sia nusu naꞌak, “Ama Boot! Hanorin ohin nia, wainhira atu dadi? Kalo kreꞌis tiꞌan, niakaan tadak oin nunabee?” ");
INSERT INTO tet_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus nataa naꞌak, “Emi musti daka aan diꞌa-diꞌak, nebee keta kona beꞌur. Tan ema oi-oik atu mai loko aan naꞌak, ‘Haꞌu neꞌe, Kristus.’ Balu tenik naꞌak, ‘Kristus namaan aan mai nikar tiꞌan!’ Mais lalika fiar! ");
INSERT INTO tet_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kalo rona lia naꞌak, ema rakut malu no natuda malu iha nabee dei, lalika sarebak. Tebes! Lia nia sia hotu-hotu musti dadi, mais rai falu fila sei la toꞌo dauk. ");
INSERT INTO tet_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ema hunun ida atu natuda no hunun seluk. Ema rai ida natuda sakar rai seluk. ");
INSERT INTO tet_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Rai atu kakekuk boot, no salaen boot. Moras maufinu mosu lema rai. Ema atu naree lia mak nalo isin rahun nafuna, no tadak makaꞌas iha laleꞌan. ");
INSERT INTO tet_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lia neꞌe sia hotu-hotu sei la dadi dauk, mais ema kohi nola emi nodi nahoras, tan emi fiar Haꞌu. Hotu, sia nodi emi baa uma hamulak atu tula lia baa emi, no neti emi iha bui laran. Sia moos naruka emi baa hataa lia baa naꞌin no ukunrai seluk sia. Hotu-hotu neꞌe sia atu dadi baa emi, tan tuir Haꞌu. ");
INSERT INTO tet_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mais emi musti hodi leet nia sia, atu katak malorek Haꞌukaan Manfatin Diꞌak baa sia. ");
INSERT INTO tet_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Keta neo-neon haꞌak, emi atu haloos aan nunabee. ");
INSERT INTO tet_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tan Haꞌu atu kfoo emi lia fuan makonak atu hodi haloos aan. Hodi nunia, emikaan funu sia benar karin. ");
INSERT INTO tet_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Ema waꞌin atu hirus emi, tan tuir Haꞌu. Emikaan familin duꞌuk, nuꞌu inan no aman, maun no alin, mamaluk sia no belun sia atu buka dalan faꞌan emi, toꞌo noꞌo emi balu. ");
INSERT INTO tet_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mais lalika hataꞌuk, tan Naꞌi Maromak la naluꞌa emi. Fuuk lahon ida moos la bele nakodan nosi emikaan ulun, kalo Nia la nakara. ");
INSERT INTO tet_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mais kalo emi haterus aan bei-beik, Naꞌi Maromak nanis sori emi.” ");
INSERT INTO tet_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Hotu, Yesus dale natutan naꞌak, “Kalo emi haree funu sia kabuun nola kota Yerusalem, emi bele hatene haꞌak, Yerusalem kreꞌis dodok ona. ");
INSERT INTO tet_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Naree nunia, ema iha rai Yudea musti nariik nalai baa foho. Ema iha kota moos, nalai ona. Ema iha leo lalika tama kota tenik. ");
INSERT INTO tet_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tan Naꞌi Maromak solok susar nia sia, atu kastikar ema mak la noꞌuk nanono baa Nia. Lia nia sia hotu-hotu kona besik baa saa mak Niakaan makoꞌan nakerek kedan hori uluk. ");
INSERT INTO tet_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Baa oras susar nia toꞌo, ema mak susar kaliuk, mak feto makoꞌus no feto mak nasusu oan. Baa oras nia, raiklaran tomak netan susar. Ema Yahudi sia moos kona susar, tan Naꞌi Maromak nahibu sia. ");
INSERT INTO tet_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Funu atu noꞌo sia balu, no sena balu dadi ata iha rai hotu-hotu. Ema maktabar mak la natene Maromak atu mai sama nadoor kota Yerusalem, nodi kaer nola kota isin, toꞌo siakaan oras nia mohu.” ");
INSERT INTO tet_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Hotu, Yesus katak tenik naꞌak, “Baa oras Haꞌu, Ema Raiklaran Isin neꞌe mai kikar, tadak sia sai iha loro, iha fulan no iha fitun. Iha raiklaran moos noo tadak nuꞌu tasi nakali saꞌe, no anin dadurus boot. Lia neꞌe sia hotu-hotu nalo ema raiklaran nataꞌuk toꞌo benar. ");
INSERT INTO tet_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Fafutar laleꞌan sia moos nawae karin. Naree nunia, ema nataꞌuk basuk, tan raiklaran atu netan dinu. ");
INSERT INTO tet_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nunia tiꞌan, foin ema titu-naree ‘Ema Raiklaran Isin namaan aan tuun nodi kaloꞌan’. Baa oras nia, Haꞌu atu ktuun kodi beran no ahar kabaas. ");
INSERT INTO tet_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hanoin! Kalo tadak neꞌe hotu-hotu dadi tiꞌan, foti ulun ona, tan Naꞌi Maromak oras sori emi, toꞌo mai tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hotu, Yesus foti lia hatetek ida naꞌak, “Ita hatadan diꞌa-diꞌak baa ai huun sia. ");
INSERT INTO tet_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kalo ai tahan nahuu nakmodok, nia foo tadak naꞌak loro falin kreꞌis mai ona. ");
INSERT INTO tet_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nunia moos, loron susar nia sia. Kalo loron susar nia sia toꞌo mai tiꞌan, nia foo tadak naꞌak, Naꞌi Maromak kreꞌis atu nabesi aan nodi kaer ukun ona. ");
INSERT INTO tet_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos! Haꞌu katak kedan lia nuneꞌe. Nosi ema hotu-hotu oras neꞌe, balu sei la mate dauk, toꞌo loron susar nia sia mosu mai. ");
INSERT INTO tet_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Masik laleꞌan no raiklaran lakon moos, Haꞌukaan lia fuan sia nafati nohuun.” ");
INSERT INTO tet_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hotu, Yesus dale natutan naꞌak, “Sintidu, tan Haꞌu atu kmosu mai teki-tekis! Keta toꞌo emi haluꞌa moris makonak, hotu hemu lanuk, hodi hafurak aan dei. Keta toꞌo emi la leno niakaan tadak, tan halau aan baa serwisu seluk. ");
INSERT INTO tet_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Oras Haꞌu kmai kikar, la noo ema ida moos bele nakfunin nosi Haꞌu. ");
INSERT INTO tet_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dadi, sintidu nohuun. Hamulak bei-beik, nebee bele terus susar nia sia hotu-hotu. Kalo emi halo nunia, oras Haꞌu, Ema Raiklaran Isin neꞌe mai kikar, emi la moe hariik iha Haꞌukaan oin.” ");
INSERT INTO tet_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sura loron Yesus baa nanorin iha Uma Hamulak Huun. Mais kalan, Nia sai nosi Yerusalem, baa toba iha leo ida iha Foho Saitun tehen baa. ");
INSERT INTO tet_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Seisawan nurak ema lear libur malu tiꞌan atu rona Nia nanorin iha Uma Hamulak Huun. ");
INSERT INTO tet_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oras nia, ema Yahudi siakaan loron diꞌak kreꞌis mai ona. Loron diꞌak nia, sia temi naꞌak, Dahur Tubi Bakae. Sia moos temi naꞌak, Dahur Paska. Baa loron nia, sia koꞌa bibi malae nodi nanoin baa otas uluk, oras siakaan bei uluk sia sai nosi rai Mesir. ");
INSERT INTO tet_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Baa oras loron diꞌak nia kreꞌis mai tiꞌan, naꞌilulik no manorik ukun Yahudi sia buka dalan atu noꞌo Yesus. Mais sia buka dalan no-nook, tan sia nataꞌuk baa ema lear mak nakara rona Yesus. ");
INSERT INTO tet_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nosi Yesus Niakaan maktuir naꞌin sanulu resin rua nia, ema naꞌin ida naran Yudas Iskariot. Baa oras ema buka dalan atu noꞌo Yesus, diabu ulun tama baa Yudas neon. ");
INSERT INTO tet_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hotu, Yudas sai baa buka naꞌilulik ulun sia no makdaka ulun sia iha Uma Hamulak Huun, tan nakara faꞌan Yesus baa sia. ");
INSERT INTO tet_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Rona nola Yudas dale nunia, sia neon diꞌak tebes. Sia namate lia naꞌak, “Diꞌak tiꞌan! Kalo o makara faꞌan Yesus baa ami, ami nanis sosa.” ");
INSERT INTO tet_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Rona nola nunia, Yudas simu. Hotu, nia nahuu buka leet atu faꞌan no-nook Yesus baa sia, nebee ema lear lalika natene. ");
INSERT INTO tet_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hotu, ema Yahudi siakaan loron boot nia sia toꞌo. ");
INSERT INTO tet_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus naruka Petrus no Yohanis naꞌak, “Emi rua baa uluk, atu hadiꞌa kedan fatin nebee ita hodi hadahur Paska bele-bele.” ");
INSERT INTO tet_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Rona nola nunia, sia rua nusu naꞌak, “Ama! Ami musti baa hadiꞌa fatin iha nabee?” ");
INSERT INTO tet_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesus nataa naꞌak, “Baa oras tama kota Yerusalem, emi hasoru mane ida noꞌi loi lolo nakonu wee. Emi baa tuir nia toꞌo uma baa. ");
INSERT INTO tet_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Toꞌo baa, katak baa uma naꞌin haꞌak, ‘Ama Boot nusu fatin ida atu nadahur Paska no Niakaan maktuir sia. Bele ka?’ ");
INSERT INTO tet_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hotu, uma naꞌin nia atu natudu keꞌan luan ida iha tetu leten mak nadiꞌa kedan tiꞌan. Hela emi hadiꞌa loos haan dei.” ");
INSERT INTO tet_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Rona nola nunia, sia rua moos baa. Toꞌo baa, sia netan hotu-hotu tuir saa mak Yesus katak tiꞌan nia. Hotu, sia nadiꞌa haan Paska iha nia. ");
INSERT INTO tet_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hotu-hotu tetuk tiꞌan, Yesus no maktuir seluk sia moos toꞌo. Yesus tuur atu naa-nemu no klosan sia. ");
INSERT INTO tet_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nia katak baa sia naꞌak, “Oras Haꞌu sei dauk ketan susar, Haꞌu kbeer basuk kaa Dahur Paska neꞌe ko emi. ");
INSERT INTO tet_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hatadan lia neꞌe diꞌa-diꞌak. Haꞌu la kaa tenik Dahur Paska ko emi ona. Da-dau toꞌo Haꞌukaan Ama nabesi aan kaer ukun tiꞌan, foin Haꞌu kaa tenik.” ");
INSERT INTO tet_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hotu, Yesus foti nola hemu fatik mak noo anggor ween. Nia namulak sera dodan baa Naꞌi Maromak, hotu lolo foo hemu fatik nia baa sia, nodi dale naꞌak, “Simu hola hemu fatik neꞌe, nebee emi ida-idak hemu. ");
INSERT INTO tet_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Hanoin Haꞌukaan dalen neꞌe! Nahuu baa ohin kalan neꞌe, Haꞌu la kemu tenik anggor ween ona. Da-dau toꞌo Haꞌukaan Ama nabesi aan kaer ukun tiꞌan, foin Haꞌu kemu tenik.” ");
INSERT INTO tet_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hotu, Nia foti nola tubi baluk ida. Nia namulak sera dodan baa Naꞌi Maromak, hotu tohi faꞌe tubi nia, lolo foo baa sia nodi naꞌak, “Tubi neꞌe, Haꞌukaan isin mak Haꞌu atu klatan bodik emi hotu-hotu. Emi haa neꞌe, hodi hanoin Haꞌu nohuun.” ");
INSERT INTO tet_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Baa oras sia naa notu, Nia nola hemu fatik mak noo anggor ween. Nia dale tenik naꞌak, “Anggor ween neꞌe, Haꞌukaan raan mak atu nakduar bodik emi. Naꞌi Maromak namate menon foun no emi, nodi raa neꞌe. ");
INSERT INTO tet_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mais sintidu, tan ema ida mak tuur namutuk no ita iha neꞌe, atu faꞌan Haꞌu. ");
INSERT INTO tet_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tebes! Ema Raiklaran Isin musti mate tuir Naꞌi Maromak hakaran. Mais rona, tan ema mak faꞌan Haꞌu nia, atu natiu dinu duꞌuk!” ");
INSERT INTO tet_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Rona nola nunia, Yesus klosan sia nahuu nusu baa malu naꞌak, “See mak atu naseꞌi aat baa Nia nunia?” ");
INSERT INTO tet_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hotu, Yesus klosan sia toe malu nosi lia see mak boot liu. ");
INSERT INTO tet_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Rona nola nunia, Yesus deꞌan sia naꞌak, “Naꞌin mak la natene Maromak, sia ukun hutun-renu todan liu resik. Masik nunia moos, hutun-renu simu nodi naꞌak, naꞌin nia naliku sia. ");
INSERT INTO tet_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mais emi keta nunia. Ema mak boot, musti lisan hanesan ema kiꞌik, nebee naliku ema hotu-hotu. Ema mak ulun, musti lisan hanesan ema ain-liman, nebee serwisu bodik ema hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Katak kokon, ema nabee mak boot. Ema mak tuur naa ka, ema mak naliku haan? Nanis, ema mak tuur naa, nia mak boot. Mais Haꞌu la kalo aan nunia, tan Haꞌu kmai atu kaliku emi. ");
INSERT INTO tet_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Baa oras Haꞌu ksusar, emi neꞌe mak hamutuk ho Haꞌu. ");
INSERT INTO tet_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Haꞌukaan Ama foti Haꞌu tiꞌan atu kaer ukun iha Niakaan Fohorai. Oras neꞌe Haꞌu moos foti emi ");
INSERT INTO tet_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","atu tuur haa hamutuk ho Haꞌu iha laleꞌan. Haꞌu moos latan beran baa emi atu kaer ukun baa ema Israꞌel hunun sanulu resin rua.” ");
INSERT INTO tet_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Hotu Yesus katak baa Petrus naꞌak, “Petrus! Diabu ulun atu sasa karin emi hosi Haꞌu, hanesan ema tataꞌek foos. ");
INSERT INTO tet_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mais Haꞌu kamulak bodik o, Petrus, nebee o fiar Haꞌu bei-beik. Kalo o fila mikar mai Haꞌu tiꞌan, o musti makbiit mamaluk sia neon.” ");
INSERT INTO tet_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus nataa naꞌak, “Lale Ama! Haꞌu la klaꞌo kela Ama. Haꞌu kadiꞌa aan tama bui ko Ama. Masik haꞌu kmate ko Ama moos, diꞌak.” ");
INSERT INTO tet_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mais Yesus nataa naꞌak, “Petrus, rona diꞌa-diꞌak! Ohin kalan neꞌe moos, manu sei la kokoreek dauk, o meli Haꞌu dala tolu tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hotu Yesus nusu baa sia naꞌak, “Hori hirak nia, baa oras Haꞌu ksolok emi baa katak Haꞌukaan Manfatin Diꞌak iha fatin hotu-hotu, Haꞌu kakahik emi nebee keta hodi osan, keta hodi kakaluk, no keta hodi kaso. Baa oras nia, emikaan saa mak la toꞌo?” Sia nataa bele-bele naꞌak, “Toꞌo hotu, Ama.” ");
INSERT INTO tet_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hotu Yesus dale tenik naꞌak, “Mais oras neꞌe, seluk tiꞌan. Kalo emi hoo osan, hodi baa. Kalo hoo kakaluk, hodi no. Kalo la hoo surik, baa faꞌan emikaan faru, hotu sosa. ");
INSERT INTO tet_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tan ema Yahudi sia filak Haꞌu baa ema aat. La oras ona sia mai kohi Haꞌu. Tebes. Tan lia nia natoꞌo saa mak Yesaya nakerek nela kedan naꞌak: ‘Sia nalo nia nuꞌu ema aat!’ ” ");
INSERT INTO tet_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Rona Yesus dale nunia, sia katak naꞌak, “Ama! Ami hodi surik rua.” Yesus nataa naꞌak, “Toꞌo ona.” ");
INSERT INTO tet_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus no klosan sia naa notu Dahur Paska, sia sai baa foho Saitun, hanesan loron-loron. ");
INSERT INTO tet_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Toꞌo baa, Yesus katak baa sia naꞌak, “Hamulak nebee emi keta monu baa sala.” ");
INSERT INTO tet_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hotu Nia nakiduk nela sia. La dook nosi sia, Nia nakniꞌa nodi namulak naꞌak, ");
INSERT INTO tet_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama! Kalo Ama nakara, tulun foti sees susar neꞌe nosi Haꞌu. Mais keta tuir Haꞌukaan hakara, tuir Ama nakara dei.” ");
INSERT INTO tet_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hotu makbukar laleꞌan ida, mai nakbiit Yesus neon. ");
INSERT INTO tet_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tan Yesus susar basuk, Niakaan kosar turu hanesan raa. ");
INSERT INTO tet_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Namulak notu, Yesus nariik baa matan Niakaan maktuir sia. Mais Nia netan sia toba dukur, tan sia kole no neon susar. ");
INSERT INTO tet_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naree nunia, Nia nasee sia naꞌak, “Aikee! Tan saa emi toba?! Diꞌak liu hamulak nebee emi keta monu baa sala.” ");
INSERT INTO tet_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus sei dale nunia, Niakaan maktuir ida naran Yudas mai no ema waꞌin. Nia mai nareꞌis aan baa Yesus nodi nakoꞌak deꞌi Nia. ");
INSERT INTO tet_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mais Yesus nasee nia naꞌak, “Hoi, Yudas! Modi deꞌi, o faꞌan Ema Raiklaran Isin neꞌe ka?” ");
INSERT INTO tet_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Baa oras ema maktuir seluk sia natene nola Yudas naneo aat nunia, sia moos nusu baa Yesus naꞌak, “Ama! Ami hodi surik! Ami sakar sia ka?” ");
INSERT INTO tet_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hotu ema ida nosi maktuir sia losu surik, taa siit ema ida tilun tahan kwana. Ema kanek nia, naꞌilulik ulun boot atan. ");
INSERT INTO tet_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mais Yesus nataa naꞌak, “Toꞌo ona! Keta sakar!” Nia moos koko ema nia tilun, hotu diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ema mak kohi Yesus nia sia, mak naꞌilulik ulun sia, fukun sia no makdaka ulun nosi Uma Hamulak Huun. Yesus nusu baa sia naꞌak, “Nunabee toꞌo emi haneo haꞌak, Haꞌu neꞌe ema aat, hotu emi mai kohi Haꞌu hodi surik no ai kaliduk! ");
INSERT INTO tet_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sura loron Haꞌu kamutuk ko emi iha Uma Hamulak Huun. Tan saa emi la kohi Haꞌu iha nia? Mais soin baa dei, tan emikaan oras toꞌo tiꞌan. Oras neꞌe, diabu ulun mak ukun ona!” ");
INSERT INTO tet_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sia kohi nola Yesus, hotu dada nodi Nia baa naꞌilulik ulun boot uman. Petrus moos tuir no-nook nosi kotuk. ");
INSERT INTO tet_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Iha uma nia lalawar ema nalaka haꞌi atu naniruk. Petrus moos baa naniruk iha nia. ");
INSERT INTO tet_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Oras naniruk, ata feto ida naree Petrus nodi nahilas diꞌa-diꞌak. Hotu feto nia nasaꞌe lia baa ema iha nia sia naꞌak, “Hoi! Ema neꞌe moos tuir no Yesus!” ");
INSERT INTO tet_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mais Petrus neli naꞌak, “Lale! La katene ema nia. O matene saa?” ");
INSERT INTO tet_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","La kleur tenik, ema ida seluk soe matan nahilas Petrus nodi dale naꞌak, “Tebes! O neꞌe, Yesus eman ida!” Mais Petrus sakar naꞌak, “Lale! Lahoos haꞌu!” ");
INSERT INTO tet_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","La kleur, ema seluk tenik dale naꞌak, “Hoi! Ema neꞌe, Yesus eman ida, tan nia moos ema Galilea ida!” ");
INSERT INTO tet_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mais Petrus neli nakaꞌas naꞌak, “O dumatak ema dei!” Petrus dale notu nunia, manu kokoreek kedas. ");
INSERT INTO tet_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Baa oras nia moos, Yesus fila kotuk mana baa Petrus. Naree nunia, Petrus nanoin nola Yesus dalen ohin nia naꞌak, “Ohin kalan neꞌe, manu sei la kokoreek dauk, o meli Haꞌu dala tolu tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nanoin nunia, Petrus sai nosi lalawar nia nodi tanis nadeꞌun aan. ");
INSERT INTO tet_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hotu, ema mak daka Yesus sia naleuk Nia, nodi taꞌe nakdiuk Nia. ");
INSERT INTO tet_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sia tutus Yesus matan, hotu nusu naꞌak, “Hoi! Kalo o neꞌe Maromak makoꞌan tebes, katak kokon see mak tuku o neꞌe?” ");
INSERT INTO tet_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hotu sia moos tolak nasasi Nia. ");
INSERT INTO tet_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Seisawan tiꞌan, naꞌilulik, manorik ukun, no fukun adat sia libur malu atu leno Yesus lian ona. Sia naruka ema dada nodi Yesus mai baa moon-metan laran. ");
INSERT INTO tet_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yesus tama tiꞌan, sia nusu Nia naꞌak, “O katak kokon lai! O neꞌe tebe-tebes Kristus ka, lale?” Yesus nataa naꞌak, “Masik Haꞌu kataa moos, emi la fiar. ");
INSERT INTO tet_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kalo Haꞌu kusu lia ida baa emi, emi moos la hataa Haꞌu. ");
INSERT INTO tet_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","La kleur ona, Naꞌi Maromak atu nodi Niakaan beran makaꞌas foti saꞌe Haꞌu, mak Ema Raiklaran Isin neꞌe. Hotu, Haꞌu ktuur iha Niakaan sorin kwana atu kaer ukun kamutuk ko Nia.” ");
INSERT INTO tet_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Rona nola nunia, sia hotu-hotu nusu naꞌak, “Kalo nunia, O maneo Naꞌi Maromak Oan mak O ka?” Yesus nataa naꞌak, “Tebes. Nuꞌu emi dale nia!” ");
INSERT INTO tet_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hotu, ema sia mak leno Yesus lia dale bele-bele naꞌak, “Ita hotu-hotu rona duꞌuk tiꞌan! Nia foti aan dadi Naꞌi Maromak Oan. Tuir itakaan ukun-badu, kalo ema nalo aan nuꞌu Maromak, nia musti mate. Nunabee? Ita lalika buka tenik saksiin ona. Taa ukun mate baa Nia dei.” ");
INSERT INTO tet_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tuir ukun oras nia, ema mak tuur iha moon-metan Yahudi la noo beran taa ukun mate baa ema. Tan baa nia, ema mak leno Yesus nodi Nia baa Gubernur Pilatus, tan gubernur mak kaer ukunrai Roma. Sia nakara nebee gubernur taa ukun mate baa Yesus. ");
INSERT INTO tet_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Toꞌo baa, sia katak Yesus salan sia naꞌak, “Ema neꞌe, maksakar ukunrai Roma. Nia nanorin naꞌak, keta selu bea baa ukunrai. Nia moos naksaꞌek aan naꞌak, nia neꞌe Kristus, mak ema Yahudi Naꞌin.” ");
INSERT INTO tet_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Rona nola nunia, gubernur nusu baa Yesus naꞌak, “Nunia tebes ka? O neꞌe, ema Yahudi Naꞌin tebes ka?” Yesus nataa naꞌak, “Tebes! Ama dale nia, loos.” ");
INSERT INTO tet_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Leno notu, gubernur seꞌi oin baa naꞌilulik sia no ema lear nia nodi dale naꞌak, “Nuneꞌe. Haꞌu la ketan ema neꞌe salan.” ");
INSERT INTO tet_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mais sia nakaꞌas aan dale naꞌak, “Lale ama! Ema neꞌe nanorin iha nabee dei, sasuku hutun-renu naksakar aan. Nia tokar lauk nahuu nosi rai Galilea toꞌo kota Yerusalem neꞌe.” ");
INSERT INTO tet_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Rona nola nunia, gubernur nusu baa sia naꞌak, “Kalo nunia, Ema neꞌe, ema Galilea ka?” Sia nataa naꞌak, “Tebes, Ama! Nia nosi Galilea.” ");
INSERT INTO tet_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Natene nola nunia, gubernur solok Yesus baa naꞌi Herodes, tan Herodes mak kaer ukun baa rai Galilea. Baa oras nia, Herodes iha Yerusalem. ");
INSERT INTO tet_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes rona waꞌin nosi lia Yesus tiꞌan. Nia nakara atu nasoru Yesus, tan naloon nebee bele naree Yesus natudu tadak blaar ida-rua sia. Tan lia nia, baa oras ema nalaꞌo nodi Yesus baa, Herodes neon diꞌak. ");
INSERT INTO tet_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nia nusu lia oi-oik baa Yesus, mais Yesus la nataa kois. ");
INSERT INTO tet_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nia sei dale no Yesus, naꞌilulik no manorik ukun sia hetak tula sala oi-oik baa Yesus. ");
INSERT INTO tet_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hotu Herodes no niakaan sondadu sia tuir naleuk nahaat Yesus. Sia natais faru klobor kabaas ida baa Nia, nodi naleuk Nia hanesan naꞌin. Hotu sia solok Nia fila baa gubernur Pilatus. ");
INSERT INTO tet_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tuir loos, uluk Gubernur Pilatus no Naꞌi Herodes funu malu. Mais nahuu baa oras nia, sia rua soman malu nikar. ");
INSERT INTO tet_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Naree ema nodi Yesus mai nikar, Gubernur Pilatus bolu nola naꞌilulik no fukun Yahudi sia, namutuk no ema lear, atu mai rona niakaan lia kakotun. ");
INSERT INTO tet_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nia katak naꞌak, “Emi hodi Yesus mai baa haꞌu, hodi tula sala baa nia haꞌak, nia sasuku hutun-renu atu sakar ukunrai Roma. Haꞌu kleno nia toꞌo lotu-lotuk iha emikaan oin tiꞌan, mais la ketan sala ida kois. ");
INSERT INTO tet_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Naꞌi Herodes moos leno tenik Nia tiꞌan, mais nia moos la netan sala ida no. Tan baa nia, Naꞌi Herodes solok nikar ema neꞌe baa haꞌu. Mais haꞌu la kbele taa ukun mate baa Nia, tan Nia la noo sala saa ida. ");
INSERT INTO tet_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Dadi haꞌu kakotu nuneꞌe: Haꞌu karuka taꞌe nia dei. Taꞌe hotu, foin haꞌu kabusik Nia.” ");
INSERT INTO tet_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Rona nola nunia, ema lear nahii bele-bele naꞌak, “La bele! Musti hoꞌo Nia. Habusik Barabas dei.” Sia nahii nunia, tan sura tinan oras ema Yahudi sia nadahur Paska, gubernur nabusik ema bui ida, tuir siakaan hakara. ");
INSERT INTO tet_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas neꞌe, tama bui tan nia sasuꞌat aat ema. Nia nakara sakar ukunrai Roma iha kota Yerusalem. Nia moos noꞌo ema.) ");
INSERT INTO tet_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Masik ema lear nahii nunia moos, gubernur nakara nabusik luku Yesus. Nia nusu tenik baa ema lear sia naꞌak, “Kalo haꞌu kabusik Yesus, nunabee?” ");
INSERT INTO tet_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mais sia nahii bele-bele naꞌak, “Lale! Musti hoꞌo Nia! Hedi baa ai karuus!” ");
INSERT INTO tet_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mais gubernur noran la makonak. Nia nusu tenik baa dala tolu naꞌak, “Tan saa emi hakara haꞌu kmusti koꞌo Nia? Niakaan aꞌaat saa? Haꞌu la ketan lia krarain ida moos bodik taa ukun mate baa Nia. Dadi haꞌu atu karuka taꞌe nia dei, foin kabusik.” ");
INSERT INTO tet_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mais ema nia sia hotu-hotu hetak nahii tuꞌan atu naseten luku gubernur nebee nisa Yesus baa ai karuus. Nosi ikus, gubernur la bele terus ona. ");
INSERT INTO tet_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nia nakotu tuir ema lear hakaran. ");
INSERT INTO tet_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nia nabusik Barabas, maksakar teen no mahoꞌo ema nia. Mais latan Yesus, nebee sia nalo baa Nia tuir siakaan hakaran. ");
INSERT INTO tet_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Gubernur Pilatus taa ukun mate baa Yesus tiꞌan, sondadu Roma dada nodi Nia sai nosi kota Yerusalem. Iha dalan klaran sia nasoru ema ida, naran Simon. Nia foin mai nosi kota Kirene. Sia seten nia seluk Yesus natiu ai karuus. ");
INSERT INTO tet_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Baa oras nia, ema lear mai nobun Yesus. Naree Yesus nunia, feto sia tanis nadeꞌun aan. ");
INSERT INTO tet_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Rona sia tanis nunia, Yesus titu fila baa sia nodi katak naꞌak, “Feto Yerusalem sia! Keta tanis baa Haꞌu. Diꞌak liu tanis baa emikaan isin lolon duꞌuk, no emikaan oan sia. ");
INSERT INTO tet_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Awan-wainrua susar boot atu mai, toꞌo ema dale naꞌak, ‘Sotir kaliuk, bodik feto kiuk mak la nasusu kedas oan.’ ");
INSERT INTO tet_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Baa oras susar boot nia mai, ema susar liu, toꞌo sia nakroꞌan naꞌak, ‘Diꞌak liu foho nakroꞌon nola ita!’ Sia moos atu dale naꞌak, ‘Tan susar oin nuneꞌe, diꞌak liu foho tunin nola ita!’ ");
INSERT INTO tet_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kalo ema moon nuꞌu Haꞌu neꞌe bele netan susar nuneꞌe, saa tenik baa ema seluk?” ");
INSERT INTO tet_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oras sondadu sia nodi Yesus baa, sia moos dada nodi no ema aat naꞌin rua, nebee sia simu ukun mate bele-bele no Yesus. ");
INSERT INTO tet_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sia laꞌo toꞌo fatin ida, naran ‘Fatin Ulun Ruin’. Toꞌo baa, sia nedi Yesus no ema aat naꞌin rua nia ida-idak baa ai karuus. Hotu, taman nariik ai karuus tolu nia. Ema aat ida iha Yesus sorin kwana, ida iha sorin karuk. ");
INSERT INTO tet_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Baa oras nia, Yesus namulak naꞌak, “Ama! Maluꞌa lakon siakaan salan, tan sia la natene saa mak sia nalo.” Hotu, sondadu sia suut liman atu nodi natene see mak atu netan Yesus farun. ");
INSERT INTO tet_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Baa oras nia ema waꞌin mai nobun. Yahudi ulun sia moos naleuk Yesus naꞌak, “Nia bele sori ema seluk, mais la bele sori aan duꞌuk. Kalo Nia tebe-tebes Kristus mak mai nosi Naꞌi Maromak, habusik Nia naꞌin tuun nosi ai karuus.” ");
INSERT INTO tet_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sondadu nia sia moos naleuk Nia. Sia naroo Nia nodi tua siin, ");
INSERT INTO tet_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nodi nahii naleuk naꞌak, “Kalo O neꞌe tebe-tebes ema Yahudi naꞌin, sori aan duꞌuk ona!” ");
INSERT INTO tet_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hotu sia nakerek baa ai kabelak ida naꞌak, “Neꞌe, ema Yahudi Naꞌin.” Hotu, sia nedi ai kabelak nia baa Yesus ulun fafuhun, atu katak lia krarain mak sia nodi taa ukun mate baa Nia. ");
INSERT INTO tet_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ema aat ida mak sia nisa iha Yesus sorin moos tuir naleuk naꞌak, “O Kristus tebes ka? Kalo nunia tebes, sori mola ita hotu-hotu ona.” ");
INSERT INTO tet_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mais niakaan maluk deꞌan nia naꞌak, “Hoi! O la mataꞌuk Maromak ka? O moos metan ukun mate nuꞌu ema neꞌe. ");
INSERT INTO tet_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ita rua kona ukun makonak no itakaan aꞌaat. Mais ema neꞌe la nalo aat.” ");
INSERT INTO tet_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hotu, ema nia dale tuꞌan naꞌak, “Yesus! Oras Ama tama baa Ama Fohorai, manoin haꞌu.” ");
INSERT INTO tet_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus nataa naꞌak, “Rona mai! Haꞌukaan dalen neꞌe, tebes no loos! Haꞌu katak kedan, ohin loron neꞌe moos, o tama laleꞌan bele-bele mo Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Baa oras nia, loro natetu tiꞌan. Mais loro matan la laka. Nakukun luri taka nola fatin nia, toꞌo tuku tolu loro malirin. Iha Uma Hamulak Huun noo tais odamatan belar, mak naꞌilulik sia nodi heli Naꞌi Maromak Keꞌan Lulik Kaliuk. Teki-tekis, tais odamatan nia naksira faꞌe baa rua. ");
INSERT INTO tet_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iha Golgota, Yesus nahii naꞌak, “Ama! Oras neꞌe, Haꞌu klatan Haꞌukaan kmalar baa Ama liman.” Dale notu nunia, Yesus nawan kotu. ");
INSERT INTO tet_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Noo sondadu ulun Roma ida mak nariik kreꞌis baa Yesus karuus. Baa oras titu-naree Yesus nawan kotu, nia tonu Naꞌi Maromak naꞌak, “Adeei! Ema neꞌe tebe-tebes ema moon!” ");
INSERT INTO tet_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ema waꞌin iha nia titu-naree Yesus nawan kotu, sia laran moras. Hotu sia fila nodi neon susar. ");
INSERT INTO tet_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesus eman sia mak nariik nosi dook moos naree Nia nawan kotu. Feto sia mak tuir Nia nosi Galilea toꞌo Yerusalem, moos iha nia. ");
INSERT INTO tet_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yesus mate tiꞌan, ema ida buka dalan atu natuun Yesus maten nosi ai karuus. Ema nia, naran Yusuf nosi kota Arimatea. Nia ema moon mak nalo lia diꞌak waꞌin. Nia nein bei-beik, nebee Naꞌi Maromak kaer ukun baa hutun-renu. Nia moos ema mak leno lia iha moon-metan Yahudi. Mais nia la simu siakaan lia kakotun ohin nia mak taa ukun mate baa Yesus. ");
INSERT INTO tet_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tan Yusuf nakara natuun Yesus maten nosi ai karuus, nia baa gubernur Pilatus atu nusu nahulin maten nia. ");
INSERT INTO tet_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Gubernur foo leet tiꞌan, Yusuf moos baa natuun maten nia, falun nodi tais mamar. Hotu nia baa rai iha rate fatuk kuak ida, mak ema foin baꞌat notu. Rate nia sei foun. ");
INSERT INTO tet_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yesus mate nia, kona baa loron lima. Baa oras sia nakoi Yesus, loro malirin tiꞌan. Kalo loro monu ona, ema Yahudi siakaan loron hamulak nahuu ona. ");
INSERT INTO tet_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Feto mak mai namutuk no Yesus nosi Galilea sia moos tuir Yusuf atu naree Yusuf rai Yesus maten iha rate nabee. ");
INSERT INTO tet_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Naree rate fatik tiꞌan, feto nia sia fila nadiꞌa ai morin no mina morin. Mais tan loro monu ona, sia musti nanawa serwisu, tuir ema Yahudi siakaan ukun-badu baa loron hamulak. Sia nein toꞌo loron hamulak siku lai, foin sia baa nisik Yesus maten. ");
INSERT INTO tet_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Baa loron domiku seisawan oan, feto nia sia nodi ai morin no mina morin baa Yesus raten. ");
INSERT INTO tet_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Toꞌo nebaa, sia titu-naree fatuk boot mak ema nodi taka rate odamatan. Mais fatuk nia nakduir baa tehen tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hotu sia tama baa rate laran, mais Yesus maten la iha tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sia moos benar karin. Mais teki-tekis, ema naꞌin rua nariik iha siakaan sorin. Sia rua tau faru naksinak. ");
INSERT INTO tet_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Naree nunia, feto nia sia nataꞌuk toꞌo sudur baa rai. Hotu, ema naꞌin rua nia nusu baa sia naꞌak, “Tan saa ina sia mai ema maten fatik atu buka ema mak moris? ");
INSERT INTO tet_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesus la iha neꞌe! Nia moris nikar tiꞌan. Ina sia naluꞌa Niakaan dale baa oras Nia sei iha Galilea ka? ");
INSERT INTO tet_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Uluk, Nia dale tiꞌan naꞌak, ema atu faꞌan Ema Raiklaran Isin baa ema aat liman. Hotu, sia nedi noꞌo baa ai karuus. Mais wainrua, Nia moris nikar.” ");
INSERT INTO tet_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Rona nola nunia, foin feto nia sia nanoin nola Yesus dalen uluk nia. ");
INSERT INTO tet_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sia fila lai-lais, nasara lia hotu-hotu nia baa Yesus klosan naꞌin sanulu resin ida, no ema seluk sia mak tuir no Yesus. ");
INSERT INTO tet_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(Feto sia mak baa rate nia, neꞌe mak Yakobus inan Maria, Maria nosi leo Magdala, Yohana, no feto seluk naꞌin hira tenik. Sia nia, mak baa nasara lia neꞌe baa Yesus klosan sia.) ");
INSERT INTO tet_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Rona nola feto nia sia dalen, klosan sia naneo naꞌak feto nia sia dale bosok. ");
INSERT INTO tet_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Masik nunia moos, Petrus nariik nalai baa rate. Toꞌo nebaa, nia nateke baa rate laran. Naree loos tais mak hodi falun maten. Hotu nia fila kedan nodi naneo naꞌak, “Neꞌe, nunabee tiꞌan?” ");
INSERT INTO tet_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Baa loron nia moos, noo ema naꞌin rua baa leo ida, naran Emaus. Leo nia dook nosi kota Yerusalem kreꞌis kilo sanulu resin ida. Uluk, sia rua moos tuir Yesus, ");
INSERT INTO tet_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","etuk sia laꞌo nodi dale lia Yesus mamaten. ");
INSERT INTO tet_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Teki-tekis, Yesus nareꞌis aan baa sia, hotu laꞌo no sia. ");
INSERT INTO tet_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mais sia la natene Nia, tan Naꞌi Maromak nalo sia keta natene. ");
INSERT INTO tet_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hotu Yesus nusu baa sia naꞌak, “Emi hoꞌi dale saa?” Rona nola nunia, sia oin tuun kedas, hotu sia nariik. ");
INSERT INTO tet_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ida mak naran Kleopas, nusu Yesus naꞌak, “Ama neꞌe, ema foun ka? Ama la natene lia mak foin dadi iha Yerusalem neꞌe ka?” ");
INSERT INTO tet_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesus moos nusu naꞌak, “Lia saa nia?” Sia nataa naꞌak, “Lia Yesus nosi Nasaret! Nia tebe-tebes Maromak makoꞌan. Naꞌi Maromak latan beran baa Nia nebee naseꞌi tadak blaar oi-oik. Nia moos matenek nanorin ema. Ema hotu-hotu beer Nia. Naꞌi Maromak moos beer Nia. ");
INSERT INTO tet_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mais hatene hodi baa, naꞌilulik no fukun Yahudi sia kohi nola Nia, latan baa gubernur nebee taa ukun mate baa Nia. Hotu, sia nedi noꞌo Nia baa ai karuus. ");
INSERT INTO tet_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Uluk fohon ami hotu-hotu haloon, nebee Nia mak Kristus. Tan kleur tiꞌan ami hein Kristus mai atu nabusik amikaan ema nosi ukunrai Roma mak tonan ami. Mais loron lima foin dau-dauk neꞌe, sia noꞌo Nia tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Oras neꞌe, ami hetak benar. Tan ohin nia amikaan feto sia mai katak naꞌak, sia baa rate seisawan oan. ");
INSERT INTO tet_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mais sia la naree Yesus maten. Hotu makbukar laleꞌan katak baa sia naꞌak, Yesus moris nikar tiꞌan! ");
INSERT INTO tet_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Rona nola nunia, amikaan mamaluk naꞌin hira nalai baa rate. Sia moos naree manesak nuꞌu feto sia dalen. Yesus maten la iha tebes.” ");
INSERT INTO tet_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ema rua nia dale notu nunia, Yesus deꞌan naꞌak, “Beik sia! Tan saa la hoꞌuk fiar saa mak Maromak makoꞌan sia katak kedan hori uluk ");
INSERT INTO tet_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","naꞌak, Kristus musti netan susar oi-oik lai, foin simu kneter no beran makaꞌas.” ");
INSERT INTO tet_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hotu Yesus nanorin sia lia hotu-hotu mak Maromak makoꞌan sia nakerek nela kedan nosi Kristus. Nahuu nosi Bei Musa toꞌo makoꞌan seluk sia siakaan hakerek. ");
INSERT INTO tet_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kreꞌis leo Emaus, Yesus asufanu atu laꞌo liu. ");
INSERT INTO tet_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mais sia rua tene naꞌak, “Ama! Mein heik mo ami ohin kalan neꞌe, tan loro atu monu ona.” Yesus moos simu nodi tama namutuk no sia baa uma laran. ");
INSERT INTO tet_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Baa oras sia tuur naa, Yesus nola tubi rohan ida. Nia namulak sera dodan baa Naꞌi Maromak, hotu tohi faꞌe tubi nia. Nia lolo foo baa sia rua, ");
INSERT INTO tet_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","foin sia natene naꞌak, Nia neꞌe mak Yesus. Mais Nia lakon tekis nosi siakaan oin. ");
INSERT INTO tet_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sia moos dale naꞌak, “Etuk oin! Baa oras ita rona Nia nalore makoꞌan siakaan hakerek, itakaan neon malirin.” ");
INSERT INTO tet_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dale notu nunia, sia fila kedan baa Yerusalem. Toꞌo nebaa, sia nasoru nola Yesus klosan naꞌin sanulu resin ida, no ema seluk sia mak naklibur iha nia. ");
INSERT INTO tet_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yesus klosan sia katak baa sia naꞌak, “Tebes! Yesus moris nikar tiꞌan! Ohin nia, Nia natadu aan baa Mau Petrus.” ");
INSERT INTO tet_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hotu, ema naꞌin rua nia moos dale lia hotu-hotu mak dadi iha dalan, toꞌo sia bele natene ema nia mak Yesus, baa oras Nia tohi faꞌe tubi. ");
INSERT INTO tet_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ema naꞌin rua nia sei noꞌi dale no maktuir seluk nunia, teki-tekis Yesus nariik iha siakaan klaran. Nia foo tabe naꞌak, “Dame!” ");
INSERT INTO tet_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mais sia hotu-hotu sarebak no nataꞌuk, tan sia naneo naꞌak ema kmalar. ");
INSERT INTO tet_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mais Yesus nusu naꞌak, “Tan saa emi hataꞌuk nuneꞌe? Emi la fiar haꞌak, Haꞌu mak neꞌe ka? Haꞌu kmoris kikar tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tebes! Haree kokon haꞌukaan liman no ain. Lolo emikaan liman hodi koko duꞌuk baa, nebee emi fiar haꞌak, Haꞌu neꞌe lahoos ema kmalar. Tan ema kmalar la noo isin, mais Haꞌu koo isin.” ");
INSERT INTO tet_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesus dale nunia nodi natudu kanek fitar iha liman no ain. ");
INSERT INTO tet_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hotu, sia neon boot tan natene naꞌak Yesus moris nikar tiꞌan. Mais sia sei benar, tan la natene, nunabee bele dadi nunia. Hotu Yesus nusu baa sia naꞌak, “Emi haa saa iha neꞌe?” ");
INSERT INTO tet_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sia moos lolo foo naꞌan tasi tunun rohan ida baa Nia. ");
INSERT INTO tet_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesus simu nola naꞌan tasi nia, hotu naa iha siakaan oin. ");
INSERT INTO tet_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hotu Yesus dale naꞌak, “Nunabee? Emi sei hanoin oras Haꞌu kamutuk ko emi ka? Hori hirak nia, Haꞌu katak tiꞌan kaꞌak, lia hotu-hotu mak Maromak makoꞌan sia nakerek nosi Haꞌu, musti dadi. Hori uluk Bei Musa no makoꞌan seluk sia nakerek nela kedan lia nosi Haꞌu iha Hakerek Moon. Iha Kananuk sia moos, noo hakerek nosi Haꞌu.” ");
INSERT INTO tet_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dale hotu nunia, Yesus natutan tenik nodi hanorin malorek nebee sia natene tebe-tebes Hakerek Moon isin. ");
INSERT INTO tet_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nia dale naꞌak, “Maromak makoꞌan sia nakerek lia nosi Kristus mak Naꞌi Maromak nameno atu solok mai. Kristus musti netan susar oi-oik lai, foin mate. Mais, baa wainrua, Nia moris nikar. Sia nakerek kedan lia nia sia hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Oras neꞌe, Haꞌu klatan beran baa emi nebee emi hodi Manfatin Diꞌak nia baa ema iha rai-rai, nahuu nosi Yerusalem neꞌe. Katak baa sia haꞌak, ema mak nalo neon aat tan siakaan salan no fila baa Naꞌi Maromak, Naꞌi Maromak nanis kasu mohu siakaan salan hotu-hotu. ");
INSERT INTO tet_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Emi musti baa foo hatene haꞌak, Haꞌu ketan susar, Haꞌu kmate, hotu moris kikar tiꞌan. ");
INSERT INTO tet_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Haꞌu moos atu solok Kmalar Lulik, mak Haꞌukaan Ama nameno kedan tiꞌan. Mais, emi musti hein iha Yerusalem neꞌe lai, toꞌo simu hola beran nosi laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Baa loron ida, Yesus nodi Niakaan maktuir sia sai nosi kota. Kreꞌis leo Betania, Nia foti liman nodi dale natuun matak-malirin baa sia. ");
INSERT INTO tet_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Oras sei foo matak-malirin nunia, Nia moos niꞌit aan saꞌe baa laleꞌan. ");
INSERT INTO tet_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Titu-naree nunia, sia hotu-hotu nakniꞌa nodi loꞌu-sudur baa Nia. Nunia hotu, sia fila baa Yerusalem nodi neon boot lo-loos. ");
INSERT INTO tet_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sura loron, sia naklibur iha Uma Hamulak Huun nodi tonu-naboot Naꞌi Maromak. Ama Teofilus! Haꞌukaan lia nosi Yesus toꞌo neꞌe dei. Tabe, Lukas ");
INSERT INTO tet_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Uluk fohon, Naꞌi Maromak Manfatin iha kedan tiꞌan. Manfatin nia, manesak no Ema ida. Nia namutuk no Naꞌi Maromak. Nia duꞌuk moos Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tebes. Hori uluk fohon, Nia namutuk kedan no Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Naꞌi Maromak nodi Nia naseꞌi nola hotu-hotu. La noo saa ida mak Nia la naseꞌi. ");
INSERT INTO tet_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nia, mak Moris Huun. Nia moos, Kroman maksinak naroma ema neon. ");
INSERT INTO tet_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kroman nia, naksinak nima-nimak, toꞌo makukun moos la bele terus. ");
INSERT INTO tet_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Noo ema raiklaran ida, naran Yohanis. Naꞌi Maromak solok nia ");
INSERT INTO tet_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","atu foo natene nosi Kroman nia, nebee ema hotu-hotu bele fiar baa Nia. ");
INSERT INTO tet_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanis neꞌe, lahoos Kroman nia. Mais Naꞌi Maromak solok nia mai atu katak baa ema nosi Kroman nia. ");
INSERT INTO tet_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tan Kroman nia, Kroman malolok mak mai baa raiklaran neꞌe, atu naroma ema hotu-hotu neon. ");
INSERT INTO tet_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Masik Naꞌi Maromak nodi Nia naseꞌi hotu-hotu moos, ema la natene Nia baa oras Nia mai nein iha raiklaran neꞌe. ");
INSERT INTO tet_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Niakaan ema sia moos la noꞌuk simu Nia. ");
INSERT INTO tet_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mais ema mak simu Nia nodi fiar baa Nia, Naꞌi Maromak foo beran baa sia atu dadi baa Niakaan oan. ");
INSERT INTO tet_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sia dadi baa Naꞌi Maromak oan, la manesak no ema nahoris oan. Lahoos tan mane ida beer netan husar-binan. Lale. Sia dadi baa Naꞌi Maromak oan, tan Nia duꞌuk mak foo moris nunia baa sia. ");
INSERT INTO tet_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Naꞌi Maromak Manfatin dadi baa ema raiklaran. Nia tuur heik iha itakaan klaran. Ita hobun Niakaan kabaas, tan Nia, Naꞌi Maromak Oan mesak mak kabaas manesak no Aman. Nia natudu laran diꞌak baa ita, tan lisan nunia tebes. Nia nanis tebes no loos. ");
INSERT INTO tet_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanis foo natene Naꞌi Maromak Manfatin nia see, nodi nahii naꞌak, “Rona mai! Neꞌe, ema mak haꞌu kdale tiꞌan baa emi kaꞌak, ‘Ema ida atu mai. Nia boot liu haꞌu, tan haꞌu ksei la moris dauk, Nia iha kedan tiꞌan!’ ” ");
INSERT INTO tet_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yohanis dale nunia, tan Ema nia beer basuk natudu laran diꞌak baa ita nima-nimak. ");
INSERT INTO tet_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Uluk aan, itakaan bei uluk sia simu Ukun-badu nosi Bei Musa. Mais oras neꞌe, ita simu matak-malirin no hanorin loos nosi Yesus Kristus. ");
INSERT INTO tet_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","La noo ema ida mak naree Naꞌi Maromak. Oan mesak duꞌuk mak naree. Oan nia bele nalore Naꞌi Maromak baa ita, tan Nia namutuk kedan no Aman. ");
INSERT INTO tet_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Dala ida, ema Yahudi ulun sia iha Yerusalem bolu naꞌilulik naꞌin hira, no ema naꞌin hira nosi hunun Lewi mak naliku Naꞌi Maromak Niakaan Uma Hamulak Huun. Bolu nola notu, sia solok ema nia sia baa mota Yordan balu baa, atu nusu Yohanis Mak Sarani Ema naꞌak, “O neꞌe, Kristus mak Naꞌi Maromak nameno tiꞌan atu solok mai ka?” Rona sia nusu nunia, Yohanis ");
INSERT INTO tet_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","nataa naꞌak, “Lale. Haꞌu neꞌe, lahoos Kristus.” ");
INSERT INTO tet_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hotu, sia nusu tenik naꞌak, “Kalo nunia, o neꞌe see? Bei Elia ka?” Yohanis nataa tenik, naꞌak, “Lale.” Hotu sia nusu tenik naꞌak, “Keta toꞌo o neꞌe, Maromak makoꞌan seluk mak ida nia ka?” Nia nataa naꞌak, “Lale.” ");
INSERT INTO tet_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hotu, sia nusu tenik naꞌak, “Kalo nunia, o neꞌe see? Katak malorek lai, tan ami musti fila baa hasara hikar baa amikaan ulun sia mak solok ami.” ");
INSERT INTO tet_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Rona nola nunia, Yohanis nataa sia tuir saa mak Yesaya nakerek kedan hori uluk naꞌak, “Haꞌu neꞌe, ema mak nahii iha rai fuik naꞌak, ‘Ema hotu-hotu hadiꞌa dalan, atu simu Naꞌin! Haweer dalan, hodi simu Nia.’ ” ");
INSERT INTO tet_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Baa oras nia, ema naꞌin hira nosi partee Farisi moos mai baa Yohanis. ");
INSERT INTO tet_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Sia nusu nia naꞌak, “Lia nuneꞌe. Kalo o lahoos Kristus, lahoos bei Elia, no lahoos Maromak makoꞌan seluk nia, tan saa o sarani ema? See mak foo beran nia baa o?” ");
INSERT INTO tet_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanis nataa naꞌak, “Haꞌu neꞌe, sarani ema kodi wee dei. Mais noo Ema ida iha emikaan klaran tiꞌan mak emi la hatene. ");
INSERT INTO tet_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Masik haꞌu kahuluk Nia moos, Nia boot liu haꞌu. Haꞌu kdadi ata baa Nia moos, haꞌu la kfatan.” ");
INSERT INTO tet_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lia neꞌe sia hotu-hotu dadi iha leo Betania, iha mota Yordan balu baa. Yohanis no niakaan maktuir sia sarani ema iha fatin nia. ");
INSERT INTO tet_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Baa awan, Yohanis naree Yesus mai baa sia. Hotu Yohanis dale naꞌak, “Mana lai! Bibi malae oan mak Naꞌi Maromak nadiꞌa kedan, Nia mai tiꞌan. Nia mak atu dadi sera, kasu ema raiklaran salan. ");
INSERT INTO tet_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ema nia mak hori sehik haꞌu katak kaꞌak, “Ema ida atu mosu mai. Nia boot liu haꞌu, tan oras haꞌu ksei la moris dauk, Nia iha tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Uluk, haꞌu la katene ema neꞌe mak Kristus. Mais Naꞌi Maromak solok haꞌu baa ema Israꞌel sia, atu foo katene nosi lia Kristus. Tan lia nia, haꞌu kmai sarani sia kodi wee. ");
INSERT INTO tet_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Uluk, Naꞌi Maromak katak baa haꞌu naꞌak, ‘Ema ida atu mai baa o. Hotu, Haꞌukaan Kmalar Lulik atu tuun mai nein iha Nia. Hotu, Nia nodi Haꞌukaan Kmalar Lulik, foo beran baa Haꞌukaan ema sia.’ Naꞌi Maromak katak kedan nunia, mais baa oras Ema neꞌe mai baa haꞌu, haꞌu la katene Nia mak Kristus. Dau-dau haꞌu ktitu-karee Maromak Kmalar Lulik tuun nosi laleꞌan hanesan lakateu sina, hotu nein baa Nia, foin haꞌu katene kaꞌak, ‘Nia neꞌe, mak Kristus!’ ");
INSERT INTO tet_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Lia nia, karee kodi matan duꞌuk. Etuk, haꞌu katak baa emi kaꞌak, ‘Ema mak mai neꞌe, Naꞌi Maromak Oan!’ ” ");
INSERT INTO tet_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Baa awan, Yohanis noꞌi nariik no niakaan maktuir naꞌin rua. ");
INSERT INTO tet_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Naree Yesus laꞌo liu, nia katak baa maktuir sia naꞌak, “Mana lai! Ema nia, bibi malae oan mak Naꞌi Maromak nadiꞌa kedan atu dadi baa sera!” ");
INSERT INTO tet_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Rona nola nunia, Yohanis niakaan ema maktuir naꞌin rua nia, laꞌo nela nia, baa tuir Yesus. ");
INSERT INTO tet_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus mana kotuk, naree sia tuir Nia. Hotu Nia nusu sia naꞌak, “Nunabee? Emi tuir Haꞌu baa saa?” Sia nusu fila baa Nia naꞌak, “Rabi hein iha nabee?” Iha siakaan lia Aram, sia temi ema boot naꞌak ‘Rabi’. Lia isin naꞌak, ‘ema manorik’. ");
INSERT INTO tet_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Hotu Yesus nataa naꞌak, “Mai, baa haree duꞌuk.” Hotu sia tuir Nia, baa naree Niakaan hein fatin. Toꞌo nebaa, takseer tuku haat loro malirin. Sia moos nein no Nia toꞌo loro monu. ");
INSERT INTO tet_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ema naꞌin rua mak tuir Yohanis, hotu tuir Yesus nia, ida naran Andreas, Simon Petrus alin. ");
INSERT INTO tet_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Fila no fila, Andreas lai-lais baa buka maun Simon nodi katak naꞌak, “Hei, mau! Ami hasoru Mesias tiꞌan!” Iha siakaan lia Aram, ‘Mesias’ naꞌak, ‘Kristus.’ Kristus nia, mak Naꞌi Maromak nameno kedan atu solok mai. ");
INSERT INTO tet_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hotu, Andreas no maun baa nasoru Yesus. Toꞌo baa, Yesus mana Simon nodi katak naꞌak, “O neꞌe, Simon. Okaan aman, mak Yohanis. Nahuu baa oras neꞌe, ema bolu o naꞌak, ‘Kefas’ ” ‘Kefas’ lia isin manesak no ‘Petrus’ mak naꞌak ‘fatuk’. ");
INSERT INTO tet_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Iha fatin nia moos, noo ema ida seluk naran Filipus. Niakaan leo huun naran Betsaida. Petrus no Andreas moos huun nosi leo nia. Baa awan, Yesus nakotu atu baa rai Galilea. Toꞌo baa, Yesus nasoru Filipus, hotu tene naꞌak, “Mai tuir Haꞌu, dadi baa Haꞌukaan ema!” ");
INSERT INTO tet_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Rona nola nunia, Filipus baa buka nola ema ida naran Natanel. Nia katak naꞌak, “Mau! Ami hasoru tiꞌan Ema mak ita hoꞌi hei-hein nia. Nia naran Yesus, nosi leo Nasaret. Aman, naran Yusuf. Ema nia mak hori uluk Bei Musa no Maromak makoꞌan seluk sia nakerek nela kedan iha Hakerek Moon.” ");
INSERT INTO tet_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Rona nola nunia, Natanel naꞌak, “Ema Nasaret!? Aikee! Leo nia, la noo folin. La noo diꞌak saa mak naksain nosi leo nia.” Mais Filipus nakahik nia naꞌak, “Hoi! Keta nunia. Mai maree duꞌuk baa!” ");
INSERT INTO tet_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Rona nola nunia, Natanel moos nakara, hotu baa. Oras Yesus titu-naree Natanel, Yesus katak naꞌak, “Ema neꞌe, ema Israꞌel isin. Nia ema moon mak la natene tolek.” ");
INSERT INTO tet_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Rona nola nunia, Natanel nusu naꞌak, “Nunabee Ita Boot bele hatene haꞌu?” Yesus nataa naꞌak, “Nuneꞌe. Baa oras Filipus la baa bolu o dauk, o sei tuur iha ai ohak nia, Haꞌu ktitu-karee o tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hotu Natanel katak naꞌak, “Ita Boot neꞌe, Naꞌi Maromak Oan tebe-tebes! Ita Boot neꞌe, tebe-tebes Naꞌin bodik ita ema Israꞌel!” ");
INSERT INTO tet_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mais Yesus nusu baa nia naꞌak, “Arumak o fiar baa Haꞌu, tan ohin nia Haꞌu katak kaꞌak, ‘Baa oras o sei tuur iha ai ohak nia, Haꞌu ktitu-karee o tiꞌan.’ Nunia ka? Manoin, tan o atu maree lia mak makaꞌas liu tenik lia neꞌe! ");
INSERT INTO tet_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Haꞌukaan dalen neꞌe, tebes no loos. Loron ikus, emi atu haree laleꞌan nakloke no Naꞌi Maromak Niakaan makbukar laleꞌan sia saꞌe-tuun iha Haꞌukaan sorin, tan Haꞌu neꞌe, Ema Raiklaran Isin mak tuun mai nosi laleꞌan.” ");
INSERT INTO tet_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Baa wainrua, noo ema nalo uma kain foun, hotu sia nalo dahur iha leo Kana iha rai Galilea. Yesus inan iha nia. ");
INSERT INTO tet_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus no Niakaan maktuir sia moos kona hamata. Hotu, sia baa. ");
INSERT INTO tet_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mais kleu-leur, anggor ween nahuu mohu iha dahur nia. Yesus inan mai katak baa Nia naꞌak, “Oa! Tulun lai! Siakaan anggor ween mohu tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesus nataa naꞌak, “Ina. Tan saa ina nakara Haꞌu mak babilan? Haꞌukaan oras sei la toꞌo dauk.” ");
INSERT INTO tet_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mais inan katak baa ema makserwisu iha nia sia naꞌak, “Rona! Nia naruka halo saa, halo tuir baa dei.” ");
INSERT INTO tet_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Iha fatin nia noo kusi fatuk neen. Kusi ida-idak nahisi wee takseer liter hitu nulu resin lima toꞌo atus ida sanulu resin lima. Ema Yahudi tau wee baa kusi nunia sia, atu nodi namoos aan tuir siakaan adat. ");
INSERT INTO tet_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Baa oras nia, Yesus naruka baa ema makserwisu sia naꞌak, “Hola wee, tau hakonu kusi neꞌe sia.” Rona nola nunia, ema makserwisu sia tau nakonu wee baa kusi nia sia. ");
INSERT INTO tet_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hotu Yesus naruka naꞌak, “Oras neꞌe, kuru hola oda, foo baa dahur naꞌin.” Sia moos nalo tuir. ");
INSERT INTO tet_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Toꞌo nebaa, dahur naꞌin nemu kokon wee nia. Natene nodi baa, wee nia dadi anggor ween tiꞌan! Dahur naꞌin benar, tan nia la natene sia netan anggor ween nia nosi nabee. (Mais ema makserwisu sia natene.) Hotu, dahur naꞌin bolu nola sasudin mane. ");
INSERT INTO tet_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nia katak naꞌak, “Tuir loos, ema foo uluk anggor ween mak diꞌak. Ema nemu waꞌin tiꞌan, foin nasai anggor ween la duun diꞌak. Mais o malo baku fila. O masai uluk anggor ween la duun diꞌak, foin o masai anggor ween diꞌak.” ");
INSERT INTO tet_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Lia nia dadi iha leo Kana, iha rai Galilea. Oras nia, Yesus naseꞌi tadak blaar uluk fohon mak ema bele naree. Nia natudu Niakaan kabaas nunia, toꞌo Niakaan maktuir sia fiar baa Nia. ");
INSERT INTO tet_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nunia hotu, Yesus no Niakaan inan, Niakaan alin sia, no Niakaan maktuir sia, tuun baa kota Kapernaum. Mais sia nein iha nia loron hira dei. ");
INSERT INTO tet_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ema Yahudi siakaan loron boot Paska kreꞌis mai ona, Yesus saꞌe baa kota Yerusalem. ");
INSERT INTO tet_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Toꞌo Uma Hamulak Huun lalawar, Nia naree ema faꞌan karau baka, bibi malae, no manu lakateu sina. Sia faꞌan buat nia sia baa ema mak mai Uma Hamulak Huun atu nalo sera tunun bodik Naꞌi Maromak. Iha nia moos, Yesus naree ema tuur taruka osan mak ema nodi sera baa Naꞌi Maromak. ");
INSERT INTO tet_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Naree notu nunia, Yesus nodi oe teꞌur sai ema hotu-hotu nosi nia. Nia moos nabuꞌa sai karau baka no bibi malae sia. Nia naloti fatin taruka osan, nodi fakar keke karin osan nia sia. ");
INSERT INTO tet_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hotu Nia naruka ema makfaꞌan lakateu sina nia sia naꞌak, “Hasai naha neꞌe sia hosi neꞌe! Fatik neꞌe lahoos faꞌan fatin! Keta halo Haꞌukaan Ama Uman dadi faꞌan fatin!” ");
INSERT INTO tet_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Baa oras nia moos, Niakaan maktuir sia nanoin nola Hakerek Moon naꞌak, “Haꞌu kadomi basuk Naꞌi Maromak Uman. Etuk haꞌu kbeer basuk daka Niakaan naran diꞌak.” ");
INSERT INTO tet_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nunia hotu, Yahudi ulun sia nusu Yesus naꞌak, “Tan saa o teꞌur ema nunia? Kalo O tebe-tebes moo beran nunia, matudu tadak blaar ida baa ami nebee dadi kakaꞌer.” ");
INSERT INTO tet_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mais Yesus nataa naꞌak, “Masik emi hadodok fatin lulik neꞌe moos, baa wainrua Haꞌu kariik kikar.” ");
INSERT INTO tet_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mais sia sakar naꞌak, “Hetan hosi nabee? Ema nariik Uma Hamulak Huun neꞌe, tinan haat nulu resin neen laran. Tan saa O maneo maꞌak, loron tolu dei O bele mariik mikar?!” ");
INSERT INTO tet_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sia nusu nunia, tan sia la natene Yesus natetek Niakaan isin lolon no fatin lulik ida. ");
INSERT INTO tet_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesus mate tiꞌan, hotu moris nikar, foin Niakaan maktuir sia nanoin nola saa mak Nia katak kedan baa sia nunia. Hodi nunia, sia moos fiar baa lia saa mak Maromak makoꞌan uluk aan sia nakerek nela kedan iha Hakerek Moon nosi lia Yesus nia. ");
INSERT INTO tet_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Baa oras nia, Yesus nein heik iha kota Yerusalem atu tuir loron boot Paska iha nia. Ema waꞌin moos fiar baa Nia, tan sia naree tadak blaar mak Nia naseꞌi. ");
INSERT INTO tet_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Mais Yesus la fiar sia, tan Nia natene nanis ema raiklaran neon. Nia la buka ema nalore ema raiklaran lisan baa Nia, tan Nia natene nanis. ");
INSERT INTO tet_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Noo ema naꞌin ida naran Nikodemus. Nia, ema Yahudi siakaan ulun boot ida nosi partee Farisi. ");
INSERT INTO tet_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Baa kalan ida, nia mai nasoru Yesus nodi katak naꞌak, “Ita Boot! Ami hatene Naꞌi Maromak mak solok Ita Boot atu mai nanorin ami. Tadak blaar mak Ita Boot naseꞌi, foo lia kakaer baa ami naꞌak, Naꞌi Maromak mak foo beran baa Ita Boot. Tan, kalo lahoos nunia, tadak blaar nia sia la bele dadi.” ");
INSERT INTO tet_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Rona nola Nikodemus dale nunia, Yesus nataa naꞌak, “Tebes. Naꞌi Maromak mak foo beran baa Haꞌu. Mais rona, tan Haꞌukaan dalen neꞌe, tebes no loos: kalo ema nakara dadi Naꞌi Maromak eman, musti noo mak nahoris nikar nia.” ");
INSERT INTO tet_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Rona nola nunia, Nikodemus benar. Nia nusu naꞌak, “Mais nunabee bele nahoris nikar ema? Ema la bele tama nikar baa inan notak, hotu inan nahoris nikar nia. La bele.” ");
INSERT INTO tet_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus nataa naꞌak, “Tebes! Mais rona, tan Haꞌukaan dalen neꞌe, tebes no loos: kalo Naꞌi Maromak la nodi Kmalar no wee atu foo moris foun baa ema, ema la bele dadi baa Niakaan ema. ");
INSERT INTO tet_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ema raiklaran nahoris ema raiklaran. Mais Maromak Kmalar mak foo moris foun baa ema. ");
INSERT INTO tet_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Keta blaar, kalo Haꞌu katak kaꞌak, ‘Musti noo mak nahoris nikar ema.’ ");
INSERT INTO tet_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hanoin kokon anin. Ita la bele haruka anin, tan anin nuu tuir niakaan hakara. Ita bele rona niakaan iis, mais ita la hatene anin mai nosi nabee, atu baa nabee. Ema moos simu moris foun nosi Maromak Kmalar nunia.” ");
INSERT INTO tet_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Rona nola nunia, Nikodemus nusu naꞌak, “Nunabee, toꞌo bele dadi nunia?” ");
INSERT INTO tet_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus nataa naꞌak, “Ama neꞌe, ema manorik boot bodik ita ema Israꞌel tomak. Tan saa ama la natene lia neꞌe sia? ");
INSERT INTO tet_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rona, tan Haꞌukaan dalen neꞌe, tebes no loos: Haꞌu ko Haꞌukaan ema sia hatene lia neꞌe sia, tan ami haree duꞌuk tiꞌan. Ami katak baa emi tiꞌan, mais emi la simu. ");
INSERT INTO tet_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kalo Haꞌu katak kosi lia mak dadi iha raiklaran, emi la fiar. Saa tenik, kalo katak kosi saa mak dadi iha laleꞌan. Emi nanis hetak la fiar! ");
INSERT INTO tet_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Emi la hatene saa mak dadi iha laleꞌan baa, tan la noo ema ida kois mak bele saꞌe baa laleꞌan. Mais Haꞌu katene, tan Haꞌu neꞌe, Ema Raiklaran Isin mak tuun mai nosi laleꞌan. ");
INSERT INTO tet_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Uluk aan, oras itakaan bei uluk sia sei iha fatin fuik, Bei Musa naseꞌi samea ida nosi besi riti, hotu nisa baa ai leten. Hodi nunia, ema moras mak naree samea nia, bele netan isin diꞌak. Nunia moos Haꞌu, Ema Raiklaran Isin neꞌe. Ema atu nisa Haꞌu baa ai leten, ");
INSERT INTO tet_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nebee ema mak fiar baa Haꞌu, netan moris nima-nimak. ");
INSERT INTO tet_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Naꞌi Maromak nadomi ema raiklaran, toꞌo Nia solok Oan Mane mesak mai raiklaran neꞌe. Hodi nunia, ema hotu-hotu mak fiar baa Oan, la kona kastikar mak sasa faꞌe sia nosi Naꞌi Maromak ona, mais sia netan moris nima-nimak no Nia. ");
INSERT INTO tet_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tebes. Naꞌi Maromak solok Oan baa raiklaran neꞌe, lahoos atu taa ukun baa ema maksalan, mais atu sori ema maksalan nosi kastikar. ");
INSERT INTO tet_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Naꞌi Maromak la taa ukun baa ema mak fiar baa Oan. Mais Nia taa ukun baa ema mak la fiar, tan sia la fiar baa Oan Mane mesak neꞌe. ");
INSERT INTO tet_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lia nuneꞌe: Naꞌi Maromak solok kroman mai tiꞌan atu naksinak iha raiklaran neꞌe. Mais ema la noꞌuk moris iha kroman nia. Sia nakara fila baa moris iha makukun, tan sia beer nalo aat. Etuk, Naꞌi Maromak atu kastikar sia. ");
INSERT INTO tet_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ema hotu-hotu mak moris nalo aat, hirus kroman nia. Sia la nakara kroman nia naksinak baa sia, nebee kroman la loke loren siakaan hahalok aat. ");
INSERT INTO tet_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mais ema mak moris tuir hanorin loos, sia mai baa kroman nia. Hotu kroman nia naksinak nalore siakaan hahalok mak sia nalo, tuir Naꞌi Maromak beer.” ");
INSERT INTO tet_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nunia hotu, Yesus no Niakaan maktuir sia sai nosi kota Yerusalem, mais sia nein heik iha rai Yudea. Iha nia, sia sarani ema. ");
INSERT INTO tet_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Baa oras nia, Naꞌi Herodes sei la natama dauk Yohanis baa bui. Oras nia, Yohanis moos sarani ema iha leo Ainon, kreꞌis baa leo Salim, tan iha nia no wee waꞌin. Ema mai hei-hein baa Yohanis iha nia, sia nusu nebee Yohanis sarani sia. ");
INSERT INTO tet_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Baa oras nia, ema Yahudi naꞌin ida nalo lia no Yohanis niakaan maktuir sia, nosi siakaan adat Yahudi naꞌak, ema musti namoos uluk isin, foin bele namulak. ");
INSERT INTO tet_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tan baa nia, maktuir sia mai nusu Yohanis naꞌak, “Ama Manorik! Hanoin kokon Ema ohin nia mak buka ama iha mota Yordan nebaa, mak ama naꞌak Kristus? Oras neꞌe, Ema nia sarani ema iha nebaa! Keta toꞌo ema la mai baa ita tenik, tan hotu-hotu baa Nia bele!” ");
INSERT INTO tet_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mais Yohanis nataa naꞌak, “Nuneꞌe! Ema la bele nalo sa-saa kalo Naꞌi Maromak la loke dalan bodik nia. ");
INSERT INTO tet_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Emi duꞌuk rona tiꞌan haꞌu katak malorek kaꞌak, ‘Haꞌu neꞌe, lahoos Kristus. Mais Naꞌi Maromak solok uluk haꞌu atu kloke dalan bodik Kristus. Nunia dei!’ ");
INSERT INTO tet_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Hola hatetek hosi dahur uma kain foun. Ita mai tuir dahur, tan ita hakara haree sasudin mane nola feto. Lahoos haree niakaan matas hariik. Mais matas nia, musti nakara rona sasudin mane dalen. Nuneꞌe! Yesus, hanesan sasudin. Haꞌu, mak Niakaan matas hariik. Oras neꞌe, haꞌu neon diꞌak, kalo ema nanono baa Nia. ");
INSERT INTO tet_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nia mak ema musti nakneter kaliuk, lahoos haꞌu.” ");
INSERT INTO tet_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hotu, Yohanis dale natutan naꞌak, “Tebes. Yesus nia boot kaliuk, tan Nia tuun mai nosi Naꞌi Maromak iha laleꞌan. Ema mak mai nosi raiklaran, nia ema raiklaran dei. Nia moos dale loos lia raiklaran. Mais Yesus seluk, tan Nia mai nosi laleꞌan. ");
INSERT INTO tet_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nia dale lia mak Nia naree no rona tiꞌan iha laleꞌan. Masik nunia moos, ema la noꞌuk simu. ");
INSERT INTO tet_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mais kalo ema simu Nia, sia natebes naꞌak, Naꞌi Maromak Manfatin, tebes no loos. ");
INSERT INTO tet_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Naꞌi Maromak solok Nia mai atu katak Niakaan mamenon. Naꞌi Maromak moos fakar Niakaan Kmalar baa Nia. ");
INSERT INTO tet_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ama Maromak nadomi tebe-tebes Oan nia toꞌo latan hotu-hotu baa Nia. ");
INSERT INTO tet_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ema mak fiar baa Oan nia, simu moris nima-nimak. Mais ema mak la nanono baa Nia, la simu moris nia, tan Naꞌi Maromak nahibu sia nima-nimak.” ");
INSERT INTO tet_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Baa oras nia ema hetak waꞌin mai baa Yesus nodi nusu atu simu sarani, toꞌo ema mak tuir Yesus waꞌin liu ema mak tuir Yohanis. (Tuir loos, Yesus duꞌuk la sarani ema, Niakaan maktuir sia mak sarani ema.) La kleur, ema nosi partee Farisi moos rona nola naꞌak, ema hetak waꞌin tuir Yesus. Baa oras Yesus natene nola ema Farisi rona nunia tiꞌan, ");
INSERT INTO tet_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nia no maktuir sia laꞌo nela rai Yudea, fila baa rai Galilea. ");
INSERT INTO tet_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iha dalan, sia laꞌo tuir rai Samaria, atu borut baa Galilea. ");
INSERT INTO tet_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Iha Samaria sia toꞌo leo ida naran Sikar, kreꞌis baa rai mak uluk aan Bei Yakob foo baa oan Yusuf. ");
INSERT INTO tet_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Iha leo diꞌin, noo wee knuuk ida, naran ‘wee knuuk Yakob’. Loro natetu, Yesus sia toꞌo wee knuuk nia. Hotu Yesus nanawa kole iha nia. Niakaan maktuir sia laꞌo nela Nia mesan, baa sosa hahaak iha leo laran. La kleur, feto ida nosi leo nia mai nola wee. Yesus nusu baa nia naꞌak, “Bii. Haꞌu kbele kusu wee hemu oan ida ka?” ");
INSERT INTO tet_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Rona nola nunia, feto nia sarebak, tan tuir loos, ema Yahudi la kahur no ema Samaria. Nia nusu fila baa Yesus naꞌak, “Ama! Ama, ema Yahudi. Haꞌu neꞌe, ema Samaria. Ama nusu wee hemu baa haꞌu, kona ka?” ");
INSERT INTO tet_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus katak naꞌak, “Nuneꞌe. Kalo bii natene saa mak Naꞌi Maromak nakara foo baa ema, no natene See mak nusu wee hemu neꞌe, bii nanis nusu fila wee baa Haꞌu. Hotu, Haꞌu moos foo wee mak nodi moris.” ");
INSERT INTO tet_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Feto nia nataa naꞌak, “Ama la noo kakuruk wee. Wee knuuk neꞌe moos leꞌan. Oin nunabee, Ama bele netan wee mak nodi moris nia? ");
INSERT INTO tet_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Uluk aan Bei Yakob rai nela wee knuuk neꞌe baa ami. Bei Musa duꞌuk nemu nosi wee neꞌe. Niakaan oa sia moos nemu. Niakaan bibi no karau moos nemu. Keta manoin, ama bele netan wee mak diꞌak liu wee neꞌe!” ");
INSERT INTO tet_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus nataa naꞌak, “Ema mak nemu nosi wee neꞌe, nanis nanroo nikar tenik. ");
INSERT INTO tet_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mais ema mak nemu wee mak Haꞌu kfoo, sia la nanroo kedas. Tan wee mak Haꞌu kfoo, hanesan wee matan ida, mak nakfuka saꞌe foo moris toꞌo nima-nimak.” ");
INSERT INTO tet_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Feto nia nataa naꞌak, “Kalo nunia, Ama foo wee nia baa haꞌu lai, nebee haꞌu lalika kanroo tenik! Hodi nunia, haꞌu lalika mai kuru tenik wee ona.” ");
INSERT INTO tet_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hotu Yesus naruka naꞌak, “Bii fila lai, baa bolu mola okaan laꞌen mai neꞌe.” ");
INSERT INTO tet_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Nia nataa naꞌak, “Mais haꞌu la koo laꞌen.” Yesus moos naꞌak, “Tebes. Bii dale moon. O moo laꞌen lima tiꞌan. Mane mak iha baa oras neꞌe moos, lahoos okaan laꞌen.” ");
INSERT INTO tet_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hotu, feto nia dale naꞌak, “Adeei! Ama neꞌe, nanis Maromak makoꞌan. ");
INSERT INTO tet_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Haꞌu atu kusu lia ida baa Ama nuneꞌe: ami ema Samaria, amikaan bei uluk sia loꞌu-sudur baa Naꞌi Maromak iha foho Gerisim neꞌe. Mais, emi, ema Yahudi haꞌak, kalo loꞌu-sudur baa Naꞌi Maromak, musti baa Yerusalem. Tuir Ama, lia malolok mak nabee?” ");
INSERT INTO tet_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesus nataa naꞌak, “Bii, fiar Haꞌu. Loꞌu-sudur baa Naꞌi Maromak iha foho neꞌe ka, iha Yerusalem ka, nosi ikus lia nia la noo folin. ");
INSERT INTO tet_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Emi ema Samaria, la hatene see mak emi loꞌu-sudur baa. Mais ami ema Yahudi hatene Maromak mak ami loꞌu-sudur baa, tan Nia nameno tiꞌan nodi ami atu loke dalan, nebee ema hotu-hotu bele netan moris. ");
INSERT INTO tet_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Toꞌo baa niakaan oras, ema mak loꞌu-sudur baa itakaan Ama tuir hanorin loos, sia atu loꞌu-sudur baa Nia nodi beran nosi Niakaan Kmalar Lulik. (Tuir loos, oras nia toꞌo tiꞌan.) Ema mak loꞌu-sudur oin nunia, mak Ama iha laleꞌan nakara. ");
INSERT INTO tet_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Naꞌi Maromak neꞌe, kmalar mak moris. Nia iha fatin hotu-hotu. Dadi, ema mak loꞌu-sudur baa Nia tuir hanorin loos, musti loꞌu-sudur baa Nia nodi beran nosi Kmalar Lulik.” ");
INSERT INTO tet_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Rona nola Yesus dale nunia, feto nia katak naꞌak, “Haꞌu katene Mesias atu mai. Nia mak ema temi naꞌak, ‘Kristus’, tan Naꞌi Maromak nameno kedan atu solok Nia mai. Kalo Nia mai tiꞌan, nanis Nia nalore lia hotu-hotu baa ita.” ");
INSERT INTO tet_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus nataa naꞌak, “Ema nia mak Haꞌu, mak noꞌi dale no o neꞌe.” ");
INSERT INTO tet_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Oras nia moos, Yesus Niakaan maktuir sia mai nikar nosi leo laran. Naree Nia noꞌi dale no feto Samaria nia, sia blaar. Mais la noo ida nusu baa feto nia naꞌak, “O makara saa?” La noo ida moos nusu baa Yesus naꞌak, “Tan saa Ama Boot dale no feto nia?” ");
INSERT INTO tet_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hotu, feto nia laꞌo nela niakaan kusi iha nia, fila baa leo laran. Nia dale baa ema iha nia sia naꞌak, ");
INSERT INTO tet_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mai haree kokon ema neꞌe lai! Nia dale loke fore hotu-hotu mak haꞌu kalo tiꞌan. Keta arumak, Nia neꞌe Kristus, mak Naꞌi Maromak nameno kedan atu solok mai!” ");
INSERT INTO tet_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Rona nola nunia, ema nia sia sai nosi leo laran, baa naree Nia. ");
INSERT INTO tet_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Oras feto nia foin fila, Yesus Niakaan maktuir sia namaus Nia naꞌak, “Ita Boot! Mai haa lai!” ");
INSERT INTO tet_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mais Yesus nataa naꞌak, “Haꞌu koo tiꞌan hahaak mak emi la hatene.” ");
INSERT INTO tet_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Rona nola nunia, Niakaan maktuir sia nakusuk malu naꞌak, “Nunabee tiꞌan? See mak mai foo hahaak baa Nia?” ");
INSERT INTO tet_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mais Yesus katak naꞌak, “Nuneꞌe mai. Naꞌi Maromak solok Haꞌu atu kalo tuir Niakaan beer, kodi kalaꞌo Niakaan serwisu toꞌo mohu. Lia nia manesak nuꞌu hahaak bodik Haꞌu. ");
INSERT INTO tet_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lia hatetek nuneꞌe. Toꞌos naꞌin naꞌak, ‘Sei fulan haat lai, foin bele kuꞌu.’ Mais haꞌu kaꞌak, ‘Mana lai baa toꞌos nebaa sia. Tetuk tiꞌan atu kuꞌu.’ Toꞌos isin nia sia, hanesan ema lear mak mai baa ita. Sia nadiꞌa aan tiꞌan atu fiar baa Haꞌu. ");
INSERT INTO tet_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ema mak kuꞌu no libur toꞌos isin, simu siakaan saseban. Sia nuꞌu ema mak natudu dalan, nebee ema fiar baa Haꞌu, hotu netan moris nima-nimak. Hodi nunia, ema mak kuda fini, no ema mak kuꞌu toꞌos isin, neon diꞌak bele-bele. ");
INSERT INTO tet_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lia fuan ida naꞌak, ‘Ema ida kuda fini; seluk sia libur toꞌos isin.’ Tebes. ");
INSERT INTO tet_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Haꞌu ksolok emi baa libur toꞌos isin mak ema seluk kuda. Emi hetan sotir hosi siakaan kolen.” ");
INSERT INTO tet_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Baa oras nia, ema Samaria waꞌin fiar baa Yesus iha leo nia, tan feto nia nasara naꞌak, “Nia dale loke fore hotu-hotu mak haꞌu kalo tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ema nia sia moos mai naroꞌan baa Yesus naꞌak, “Ama Boot, hein ho ami iha neꞌe dei!” Nia moos nein iha nia toꞌo loron rua. ");
INSERT INTO tet_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Rona Yesus dale duꞌuk, ema waꞌin tenik moos fiar baa Nia. ");
INSERT INTO tet_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sia katak baa feto nia naꞌak, “Hori sehik nia, ami rona loos o dale dei. Mais oras neꞌe, ami fiar, tan rona duꞌuk hosi Nia. Ami hatene tebes haꞌak, Ema neꞌe, Maksorin raiklaran.” ");
INSERT INTO tet_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Loron rua nia siku tiꞌan, Yesus sia laꞌo liu baa rai Galilea mak Yesus rai huun. ");
INSERT INTO tet_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Uluk, dala ida Yesus dale naꞌak, “Ema la nakneter Maromak makoꞌan iha niakaan leo duꞌuk.”) ");
INSERT INTO tet_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mais baa oras neꞌe, ema Galilea waꞌin simu Nia diꞌa-diꞌak, tan sia tuir tiꞌan dahur Paska iha Yerusalem, no sia naree nodi matan duꞌuk hotu-hotu mak Nia nalo iha nebaa. ");
INSERT INTO tet_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hotu, Yesus sia laꞌo baa leo Kana, leo mak uluk Nia nalo wee dadi baa anggor ween. Kreꞌis leo nia, noo ema boot ida iha kota Kapernaum. Niakaan oan mane moras. ");
INSERT INTO tet_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Oras nia rona nola naꞌak Yesus mai nikar tiꞌan nosi rai Yudea, nia moos laꞌo saꞌe baa buka Yesus iha Kana. Nasoru nola tiꞌan, nia namaus nebee Yesus tuun mai, nadiꞌak nola oan, tan kreꞌis mate ona. ");
INSERT INTO tet_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mais Yesus katak baa ema nia naꞌak, “Kalo emi la haree Haꞌu kaseꞌi tadak blaar oi-oik, emi la hoꞌuk fiar baa Haꞌu!” ");
INSERT INTO tet_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ema nia nataa naꞌak, “Ama Boot. Tulun mai lai. Kalo lale, haꞌukaan oa mate ona.” ");
INSERT INTO tet_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Rona nola nunia, Yesus katak naꞌak, “Fila ona. O oan diꞌak tiꞌan.” Hotu, ema nia taliꞌur nodi fila, tan nia fiar Yesus dalen. ");
INSERT INTO tet_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Baa oras fila, niakaan ema serwisu sia mai nasoru nia iha dalan, nodi naꞌak, “Lalika susar ona, tan ama oan diꞌak tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hotu, nia nusu baa sia naꞌak, “Nia nahuu diꞌak baa tuku hira?” Sia nataa naꞌak, “Nahuu baa hori sehik, tuku ida loron natetu niakaan manas tuun kedas.” ");
INSERT INTO tet_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hotu, ema boot nia nanoin nola naꞌak, niakaan oa nia nahuu diꞌak, kona besik baa oras Yesus katak naꞌak, “Ama oan diꞌak tiꞌan.” Hotu, nia no niakaan ema uma laran sia fiar bele-bele baa Yesus. ");
INSERT INTO tet_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tadak blaar nia, tadak blaar dala rua mak Yesus naseꞌi baa oras Nia sai nosi Yudea baa Galilea. ");
INSERT INTO tet_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nunia hotu, loron boot Yahudi ida toꞌo mai tiꞌan. Yesus sia fila baa kota Yerusalem atu nadahur loron boot nia. ");
INSERT INTO tet_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iha Yerusalem, noo wee lalihuk ida kreꞌis baa odamatan nanokar ida naran, Odamatan Bibi Malae. Iha siakaan lia Aram, wee lalihuk nia naran ‘Wee Lalihuk Batesda’. Noo tetek lima kreꞌis baa wee lalihuk nia. ");
INSERT INTO tet_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Loro-loron ema mak moras waꞌin tuur nein iha tetek nia sia. Nuꞌu: ema matan delek, ema ain asak, no ema mak la bele koen aan. Sia nein, toꞌo wee nia nahuu kakoen. ");
INSERT INTO tet_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tan isin ida-idak, Maromak Niakaan makbukar laleꞌan tama baa kakoen wee nia. Hotu, ema moras mak tama uluk baa wee nia laran, nia diꞌak kedas. ");
INSERT INTO tet_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Baa oras Yesus sia toꞌo baa fatin nia, noo ema ida mak moras tinan tolu nulu resin walu tiꞌan. ");
INSERT INTO tet_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Titu-naree ema nia noꞌi toba iha nia, Yesus natene kedan ema nia moras kleur tiꞌan. Hotu Yesus nusu nia naꞌak, “Mau! O makara dadi diꞌak ka?” ");
INSERT INTO tet_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ema nia nataa naꞌak, “Kakara liu Ama Boot. Mais noo sohan boot. Kalo wee kakoen, la noo ema ida mak nakaꞌu natama haꞌu baa. Kalo haꞌu kakoen atu tama duꞌuk, ema seluk tama uluk tiꞌan.” ");
INSERT INTO tet_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Rona nola nunia, Yesus naruka naꞌak, “Mariik! Lulun mola okaan biti, fila ona.” ");
INSERT INTO tet_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yesus dale notu nunia, ema nia moos diꞌak kedas. Hotu, nia nariik, foti nola niakaan biti atu fila. Lia nia kona besik baa ema Yahudi siakaan loron hamulak. ");
INSERT INTO tet_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tan lia nia, oras ema Yahudi ulun sia naree ema mak foin diꞌak nia, sia nasee nia naꞌak, “Hoi! O matene ka lale? Ohin loron neꞌe, loron hanawa serwisu. Tuir itakaan ukun-badu, ema la bele natiu biti baa loron hanawa serwisu. Tan hatiu biti, neꞌe naꞌak, serwisu tiꞌan!” ");
INSERT INTO tet_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ema nia nataa naꞌak, “Adeei, ama sia! Keta krakat, tan Ema mak nadiꞌak nola haꞌu, Nia mak naruka haꞌu naꞌak: ‘Lulun mola okaan biti, fila ona.’ ” ");
INSERT INTO tet_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hotu ulun sia nusu baa nia naꞌak, “Ema mak naruka o nia, see?” ");
INSERT INTO tet_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mais ema mak foin diꞌak nia la natene Yesus nia, see, tan Yesus la iha nia tiꞌan. Yesus sai no-nook tiꞌan, tuir ema waꞌin leet. ");
INSERT INTO tet_vpl VALUES ("JN5_14","07