﻿USE sofia;
DROP TABLE IF EXISTS sofia.terNT_vpl;
CREATE TABLE terNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES terNT_vpl WRITE;
INSERT INTO terNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Enepora yutoéti, koati koyuhó'inoviti iháhiko ne oxúnoekene Jesus Kristu, ámoripono Ndávi, ámoriponoikomaka Âbraum. ");
INSERT INTO terNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eneponeko Âbraum, há'ane neko Izáki. ");
INSERT INTO terNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Kene Njúda, Pêre yoko Nzêra itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Kene Âraum, Aminâdabi itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Kene Sâumom, Mbôa itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Eneponeko Njése, énomone itúko há'a neko Ndávi, nâti mekúke. ");
INSERT INTO terNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Kene Salúmaum, Robôaum itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Kene Âza, Njozáfa itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Kene Ûziya, Njótaum itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kene Ezékiya, Manáse itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Kene Njôziya, Njekóniya yoko po'ínuhiko itukoa há'a ya kaxénake íteokonoku ne viyénoxapa jûdeu xapa isukókoti yaneko omopókononehiko itúkeovo kaúti ya Mbabílonea. ");
INSERT INTO terNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Eneponeko Njekóniya, ápe xé'a koéhati Salatíye ike omópinekono viyénoxapa ya Mbabílonea. ");
INSERT INTO terNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Kene Nzorobâbe, Ambiûdi itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Kene Âzo, Sadóki itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Kene Eliûdi, Eleâza itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Kene Njáko, Yûse, ima Mâriya, itukoa há'a. ");
INSERT INTO terNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Enepone oxúnoekene Jesus yutoxóvoti îha yarâ'a, kátoze kôe ukeâti kaxena Âbraum tukú koeti kaxena Ndávi. Kene ukeâti kaxena Ndávi tukú koeti omópeokonoku viyénoxapa ya Mbabílonea, kátoze koépomaka îha ne oxúnoekene yutoxóvoti yarâ'a. Kene ukeâti kaxena omópeokonoku viyénoxapa ya Mbabílonea tukú koeti ápepe Mésiya, kátoze koépomaka îha. ");
INSERT INTO terNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hara kôe kixoku koêku inâ ipuhíko ne Jesus Kristu yara kúveu mêum. Enepone Mâriya, eno Jesus, hoenáxokonotine itúkeovo yenomo Yûse. Itea koeku âvoyea ava xoko Yûse koane âvoyea akápinea, ihaikó koéne neko Mâriya ya xunákoke Sasá'iti Omíxone Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoko enepone Yûse, imamo Mâriya, koati itípakovoti hóyeno, epó'oxo koati ponóvoti kixoku itúkeovo. Exoâne Yûse íhaikea ne Mâriya, ápene isóneuke kotóhineopea mani kóyenoyea. Itea ako akáha'a ómea yuhoíkovokutike, puvâti váherexea yuhó'inokono ne Mâriya. ");
INSERT INTO terNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Koeku ixómoyea itúkinoa isóneu Yûse, símoa ánju, ovoxe Itukó'oviti ukeâti vanúke. Hopúneke vekínoa. Hara kíxoa: —Yusé, iti ámoripono Ndávi, hako pivôa kéyenoyi ne Mâriya, vo'oku enepone íhaikea, koati Sasá'iti Omíxone Itukó'oviti porexôa kó'iyeaneye. ");
INSERT INTO terNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Apêtimo xe'éxa, hóyenomo kalivôno. Jesus íheximo, vo'oku koíteovomo xanéna ya pahúnevo —kíxoane ánju neko Yûse. ");
INSERT INTO terNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kó'inokeneye uhá koêti yanekôyo, vo'oku simóvotine kaxéna neko yuho Itukó'oviti ya yuhóke porófeta, enepone koyúhoti emo'u Itukó'oviti mekúke. Énomone neko emo'úti koêti: ");
INSERT INTO terNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Apêtimo ârunoe ihaíkoti ákoti hóyeno yuhó'ixoati. Koxe'éxatimo hóyeno kalivôno. Emanûe íhaxeokonomo” koêti. (Yoko enepone Emanûe koêti, anéye Itukó'oviti xapákuke ûti koêti.) ");
INSERT INTO terNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iyukóvone neko Yûse, itúkoa neko emó'uinoa ánju. Ako kuríkapa Mâriya, yane kâsatuxonehiko. ");
INSERT INTO terNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Itea kóyeane âvoyea yúha'ixa imókone ipuhíko neko kalivôno. Yoko Jesus íhaxea Yûse ne kalivôno. ");
INSERT INTO terNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Enepo ipuhíkone Jesus yara kúveu mêum, Mbélem ipúhiko, pitivóko ya Njúdeya. Yaneko káxehiko, kaxénake itúkeovo nâti ne Êrodi, apé koéne hóyenohiko simôti ya Njeruzálem ukeâti úkeaku ihâroti. Enepohikone hóyeno, koati hána'iti ko'éxoneti ihíkaxovoti koeku hékerehiko. ");
INSERT INTO terNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Simoné'eya, hara koe épemoke xanéhiko: —Na óvo ne hóyeno kalivôno ínati ipuhíko, enepone natínamo jûdeuhiko? Kenó'okinoke ûti, vo'oku koeku vóvea vóvokuke ya úkeaku ihâroti, noixoâti ûti ne hékere hoénaxovope. Vihayú'ikoponoati simínoke ûti —koe yûho. ");
INSERT INTO terNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kamoáne Êrodi neko koekúti, yupihovó koene itúkinoa isóneu. Uhá kôe xanéhiko ya Njeruzálem itúkinoamaka isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yane ho'úxoanehiko Êrodi ne uhá koeti tutíhiko inuxínoti jûdeu hó'eke yóko'o ne ihíkaxotihiko ya hó'eke, ina epemó'ikoahiko koeku yuho porófeta mekúke ipúhikokumo ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne. ");
INSERT INTO terNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ina yumopâhiko: —Mbélem ya Njúdeya, enemo ipúhiko. Vo'oku hara kôe ne yútoe porófeta koyúhoti emo'u Itukó'oviti mekúke: ");
INSERT INTO terNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Enepone Mbélem ya poké'exa Njúdeya, ako apáya'i itea haina ákoti itúkokonoke ya xapákuke ne koati hána'itinoe pitivóko ya Njúdeya, vo'oku énomonemo íhonea ne pahúkoti, enepone inuxínoatimo ne njanéna íhae Izarâe” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yane he'onó kíxoane Êrodi iháxikea neko hóyenohiko ukeâti úkeaku ihâroti, epemó'ikoati itukóvotiye káxe koane kohê ipúhikeaku neko hékere noíxonehiko. ");
INSERT INTO terNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ina pahukoâhiko ya Mbélem. Hara kíxoa: —Pîhe, kókoyuse íxea yépemo'iki koêku ne kalivôno. Enepomo inixépanane, yéta'akapanumo motovâtimaka mbíheaya inzáyu'ikoponea —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Úkeane pího neko hóyenohiko ixikó'okoanehiko nâti. Ya xenékuke, ápeponemaka ne hékere, enepone noíxonehiko koeku óvea óvokuke ya úkeaku ihâroti inuxó kó'iyea tumúnekehiko tukú koeti símo xoko yónoku. Simoné'e xoko óvoku ne kalivôno, xe'ó koéne neko hékere koati oúkeke. ");
INSERT INTO terNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Noixópanemaka hóyenohiko neko hékere, yupihovó koéne úhepeyeahiko isóneu koane êno elókeko okóvo. ");
INSERT INTO terNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ina urúkovahiko neko ovokúti, yane noíxoane ne kalivôno yoko Mâriya, êno. Ipuyuké kó'iyeanehiko nonékuke ne kalivôno ihayú'ikoati, koane míhe'okeahiko neko íhaku iparáti omínoakehiko ina porexôa neko omínoake, ôro, yoko kohépiti xêru êno úheti ihópune koéhati mîra, yoko po'inu xêru koéhati ísensu. ");
INSERT INTO terNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ina kouhápu'ikinoa Itukó'oviti neko hóyenohiko ya hopúneke ákoyeane vekapa xoko Êrodi. Énomone vekópinohiko po'íke xêne koeku aúkopeovo poké'exake. ");
INSERT INTO terNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Enepo pihopóne neko hóyenohiko noixóponoti Jesus, yane símoane ánju ne Yûse ya hopúneke. Hara kíxoa: —Keúsakapu, yáma ne kalivôno yoko êno. Íkeha'ixa ya Ejítu. Yâvaheixanemo tukú koeti endá'akapapimaka motó'iyeovanemo yaúkopivo, vo'oku opósi'ixoane Êrodi ra kalivôno kaha'âti koépekea —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yane koúsokovone Yûse, úkeane pího ya yóti ikóho'ixoati ne kalivôno yoko êno ya Ejítu. ");
INSERT INTO terNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ôvoheixoane ya Ejítu tukú koeti ivokóvone Êrodi. Kó'inokeneye maka kaúsakapune neko yuho Vúnae ya xoko porófeta koyúhoti emo'u Itukó'oviti mekúke, enepone koêti: “Koeku ukópea Ejítu, undíne ihaxíkopa neko nje'éxa” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Exoâne Êrodi itúkeovo aupú'ikoatine hóyenohiko ukeâti úkeaku ihâroti, yupihovó koene ímaikeovo. Yane pahúkoane koépekexeokono neko uhá koeti inámatiko kalivôno ya Mbélem pi'âtine xoénaena poké'eke, koánemaka xapa ko'óvokutihiko oveâti xêrerekuke. Itúkinovoke kalivôno pi'âtine xoénaena poké'eke vo'oku yûho neko hóyenohiko ukeâti úkeaku ihâroti kuteâti yé'akeneye xoénae ike ipúhikine neko hékere. ");
INSERT INTO terNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yane koúsokovone neko kúxoti yútoe porofeta Njerémiya, enepone koêti: ");
INSERT INTO terNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ya Râma, ápe kámone xanéhiko, êno hónoti iyókexoti kotíveti koeku yaíkea. Manîrapo Rákeu iyôti vo'oku xe'éxaxapa. Yoko ako itoâti iyúni'ikea vo'oku heú koe ívohikeovo xe'éxaxapa” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ivokóvone neko Êrodi, apé kó'ino Yûse ya hopúneke ne ánjuna Vúnae. Yoko Ejítuke ovó'iko ne Yûse. Hara kíxoa ánju: ");
INSERT INTO terNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Keúsakapapune, yamápanemaka ne kalivôno yoko êno, yaúkapapune ya poké'exa Izarâe, vo'oku ivókovonehiko neko kaha'âti koépekea ne kalivôno —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yane omópane Yûse ne kalivôno yoko êno. Poké'exa Izarâe yonópohiko. ");
INSERT INTO terNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Itea eyekóxoane Yûse itúkeovo Arkílau, xé'a Êrodi, ahe'ókopo haíkene natíxea ya Njúdeya, píkoane yonópeaya. Yane éxokoa Itukó'oviti ne Yûse yonópokumo ya hopúneke. Énomone pihópino Ngalíleyake ");
INSERT INTO terNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","xoko pitivóko koéhati Nazâre. Kó'inokeneye, koati tokopóvoti neko kúxoti yuho porófeta mekúke, enepone koêti: “Iháxeokonotimo íhae Nazâre” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yaneko mekúke, pîho Xuaum Mbátita ya Njúdeya yaneko mêum ákoti apêti, koyúhoti emo'u Itukó'oviti xapa xâne kamokénoponoati. ");
INSERT INTO terNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Hara kôe: —Ikétivexanoe iséneuke ne pehúnevo koane kiríkapa, vo'oku yé'exovone kaxena natíxea ne Íhae Vanúke xapa xâne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yoko Xuaum Mbátita kíxo ne porofeta Izâiya mekúke yaneko kó'iyeaku: “Énomonemo ne kohonókoti emó'u ya mêum ákoti apêti xapa xâne kamokénoponoati. Haramo koe yûho: ‘Míhe'akinanoe oxéne ne Vúnae itúkea ítuke xepákukenoe. Kéyusea kixeku itíkivo nonékuke’ ” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoko evo'i kámelu itúko ípovo neko Xuâum. Vakamóto itúko hô'e. Kene vohóho yoko ho'o mópo íhae mêum itúko nîka. ");
INSERT INTO terNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Enepohikoneko íhae pítivokona Njeruzálem, yoko uhá koeti íhae Njúdeya, koane uhá koeti íhae xe'ókuke ne huvêo iháxoneti Njôrdaum, pihóhiko kamokénoponoti Xuâum. ");
INSERT INTO terNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Enepohikone xâne koyuhópoti pahúnevo, áhikoahiko Xuâum yane huvêo. ");
INSERT INTO terNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noixoâne Xuâum símeahikomaka êno farîzeu yoko sadúseu, enepohikone payásoti ya hó'eke jûdeu, hara kíxovokoxoa: —Itínoe ámoripono xâne kutí koeti koati ipúhokovoti koéxoe, ikítixatinoe itívoatimo ne ipíhoponopemo Itukó'oviti pohúneti vo'oku yáhikivo njokóyoke? Ako kalíhuina! ");
INSERT INTO terNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Konókoti itíkinoe únati motovâti iyúseyea itíkivonoe ikotívexoati isóneuke ne pahúnevo koane kirikópati. ");
INSERT INTO terNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Uti ámoripono Âbraum” hákonoe koe iséneupinovo, pe'okoâti itíkivo aha Itukó'oviti vo'ókuke. Vo'oku eneponi itukápu énomone kahá'a ne Itukó'oviti, mani pahukoâti itúkopeovo ámoripono Âbraum ra itátanehiko mopôi. ");
INSERT INTO terNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","—Kuteâti koêku ne povôti usó koyêtine tetúkea tikótihiko ukeâti poéheveke, enepohikone uhá koeti ákoti parêxa únati há'i, ina kurikókono yúkuke, énomonemakamo kíxoaneye Itukó'oviti ne xâne váhere kixoku itúkeovo. ");
INSERT INTO terNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kaná'uti ánjikeopinoe ya úne, yéxokovope ikétivexi iséneuke ne pehúnevo koane kirikópati, itea ya ingénepoke, harakénemo koati hána'iti teyonéti ya undíke. Muhíkova anjí'okeova koane omínoam perékatana, ako omóndokea. Énomonemo ahíko xâne, haînati ya úne itea ya xunákoke Sasá'iti Omíxone Itukó'oviti, enepone kutí koetimo xunako yúku kasása'ikea. ");
INSERT INTO terNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kutí koetímo xâne omó'ixoti kasása'ikope ya vo'ókuke, kuteâti ápa. Kuteâti kixókonoku tirîku kasasá'ikokono, énomonemo kixóneye xâne nê'e. Kuteâti kixókonoku ha'i tirîku ipíhopokono íhakuke, énomonemo kixóneye xâne únati kixoku itúkeovo. Kene ne xâne kutí koeti tuti tiríku ákoti aunáti, oro'ókoatinemo yúkuke xoko ákotinemo ípukeovoku —kíxovokoxoane Xuaum Mbátita. ");
INSERT INTO terNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yaneko káxehiko, ipúhikea Ngalíleya ne Jesus. Hara yóno huveóke, enepone Njôrdaum, motovâti áhikeovo xoko Xuaum Mbátita. ");
INSERT INTO terNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ina kixôa Xuâum: —Mani îti motokêa áhikeonu itea itukovó koe ûndi yépemo áhikeopi —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ina yumopâ Jesus: —Ako yuvâti vo'oku koeku kó'iyeaneye, koati kousókoati ûti ne uhá koeti ínixone Itukó'oviti itúkeovo ponóvoti —kíxoane. Yane kúteanemaka isóneu Xuaum Mbátita, áhikoane. ");
INSERT INTO terNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ehá'axo ipúhikopea úne ne Jesus yaneko ahíkovo, mihe'ó kó'inoane vanúke koane noíxea Sasá'iti Omíxone Itukó'oviti evesékoti xokóyoke kutí koeti kurûte. ");
INSERT INTO terNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Énomone yanê'e, apé koene emo'úti inu'íxoti vanúkeke kámone. Hara kôe: —Eneporâ'a, énomone Nje'éxa koati ákoti omotóva ongóvo, porexónuti hána'iti elókeko ongóvo —kôe. ");
INSERT INTO terNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Énomone yaneko ike áhikinevo ne Jesus, ómane Sasá'iti Omíxone Itukó'oviti ya mêum ákoti apêti, hixopâti Ndeâpu íkorokea pahunévotike. ");
INSERT INTO terNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Itopónone koarenta koeti káxe koane koarenta koeti yóti ákoyea nîka ne Jesus, yane épekoane hímakati. ");
INSERT INTO terNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yanê'e, pihínoane Ndeâpu, enepone íkorokenati xâne pahunévotike. Hara kíxoa: —Enepo itikápuxo Xe'exa Itukó'oviti, pehúkaikopo sá'iri'okopeovo pâum ra itátanehiko mopôi —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ina kixôa Jesus: —Hara koe yutoéti emó'uke Itukó'oviti: “Haina póhutine nikokónoti koxunáko xâne, itea kóxunakomaka ne uhá koeti emó'uinovi Itukó'oviti” kôe —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Úkeane óma Ndeâpu ya Njeruzálem, enepone iháxoneti Sasá'iti Pitivóko. Hara iyónoa xoko koati vanúke'exeaku yane hána'iti imokóvokuti, enepone témpulu ");
INSERT INTO terNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ina kixôa: —Enepo itikápuxo Xe'exa Itukó'oviti, kepúhakapu poké'eke yukîti ra vanúke, vo'oku hara kôe ne yutoéti ya emó'uke Itukó'oviti: “Pahukoâtimo Itukó'oviti ne ánjuhiko, enepone ovóxe íhae vanúke kóyonoyeopi. Énomonemo namukópopi ya vô'u maka hákone okó'okoa mopôi ne hîvi” kôe —kíxoane Ndeâpu. ");
INSERT INTO terNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Itea hara kíxoa Jesus: —Ako kalíhuina, vo'oku haramaka kôe ya po'íke yutoéti emó'uke Itukó'oviti: “Hako yoposí'okovo Yúnae Itukó'oviti” kôe —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ina omopómaka Jesus ne Ndeâpu oúke êno hána'iti mopôi, exókoati uhá koeti pahúkoku payásotihiko yara kúveu mêum, koáne ne êno úhe'ene ");
INSERT INTO terNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ina kixôa: —Mborexópeatimo uhá koêti ra koekúti neíxone kó'oyene enepo ipiyíkexa nonénguke kutí kixénuti Itukó'oviti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ina kixôa Jesus: —Yahíkuxipunu Satanaé, vo'oku hara kôe emó'uke Itukó'oviti: “Ópoehane Yúnae Itukó'oviti ipíyikexino. Poéhane motovâ kíxeokononeye” kôe —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Noixoâne Ndeâpu ákoyea íta, yane ahíkuxopeovane. Yane ápehiko ánju, enepone ovoxe Itukó'oviti ukeâti vanúke simohíkoati ne Jesus kaxunákoponoati. ");
INSERT INTO terNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Exoâne Jesus iká'akeovone ne Xuaum Mbátita, aúkopovo ya Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pohu vekó koepo Nazâre yonópoti Kafanâum. Hane óvo ne pitivóko xe'ókuke Mar-na Ngalíleya xoko po'i iháxakoku poké'exa Ngalíleya iháxoneti Nzebûlom yoko Nafitáli. ");
INSERT INTO terNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Énomone yaneko pihópeaku Jesus ya Ngalíleya, koúsokoa ne yútoe porofeta Izâiya mekúke koyuhó'iyeati koêku, enepone koêti: ");
INSERT INTO terNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Enepone poké'e íhauti Nzebûlom yoko Nafitáli ovoti íyeuke Hána'iti Mar poixô'oke huvêo koéhati Njôrdaum, énomone ne Ngalíleya iháxoneti óvoku ne xanéhiko ákoti itukapu jûdeu. ");
INSERT INTO terNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Enepohikone xanéhikoya ovóheixoti hahákutike, noíxone êno hána'iti uhapú'iti. Epó'oxo enepohikone ovâti neko poké'e, óvohikoku xâne hoenáxovotine yonópea ipihóponovokutike, koúhapu'ikoane êno hána'iti uhapú'iti” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Énomone yanekôyo, turíxovone ne Jesus koyúhoyea ne emo'u Itukó'oviti. Hara koe yûho xapa xâne: —Ikétivexa iséneuke ne pehúnevo koane kiríkapa, vo'oku kaxénane natíxea ne Íhae Vanúke xapa xâne —kôe. ");
INSERT INTO terNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Koeku yónea ne Jesus xe'ókuke Mar-na Ngalíleya, tokononé koéne pi'âti kopo'ínukokoti, Símaum iháxoneti Pêturu, yoko Ándere ixómoti kurîko númikuxope vo'oku itúkeovo itúkovokenehiko. ");
INSERT INTO terNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ina kixoáhiko Jesus: —Hekánunoe. Hainá'ikomo hôe yíxovonoe itea indukópopitinenoemo ihíkaxoti xâne hókeonu —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Énomone yaneko ókoku ôra, kurí kíxoane neko númikuxope, pihónehiko ikéneke Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yane kali tumûneke, tokononé koéne po'i pi'âti kopo'ínukokoti ixómoti koyúseopo númikuxope kúveuke vatékena. Énomone ne Teâku yoko Xuâum, xé'ahiko Nzebêdeu. Yoko ápemaka há'a yane vatékenake. Yane ítaikoane Jesus neko pi'âti hókeamaka. ");
INSERT INTO terNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kurí kixónehiko há'a koane vatékena, pihónehiko ikéneke Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Uhá kíxoa Jesus yónea neko poké'exa Ngalíleya koane íhikaxea emo'u Itukó'oviti ya sinâgoga, enepone íhikaxovoku hó'e jûdeuhiko, koane koyúhoyeamaka ne inámati ihíkauvoti koyúhoti kixoku natíxea Itukó'oviti xapa xâne. Koítovamaka Jesus uhá koeti koêkuti kó'iyeovoku aríne neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eyekóxokonone koeku ítuke ne Jesus ya uhá koeti poké'exa Sîrea, omókonone uhá koêti ne ka'aríneti xokóyoke. Yoko ako tôpi kó'iyeovoku arinéti yuvâtihiko. Ápe xâne ûroevo ndémoniu. Ápemaka ákoti aunáti tûti pepokehí koêti, koane isayú'ixovoti ákoti ehevákapu mûyo. Koítovahiko Jesus uhá koêti. ");
INSERT INTO terNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Koati ênoti xâne íhae Ngalíleya hokó'ixoati, koane íhae iháxoneti Yehí Koeti Pitivóko, koánemaka íhae Njeruzálem, yoko íhae Njúdeya, koánemaka íhae poixô'oke huvêo, enepone Njôrdaum. ");
INSERT INTO terNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Noixoâne Jesus neko êno xâne, pihóne oúke kali mopôi. Ivatákone, ina ahi'ókova íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Énomone yanê'e, turíxoane Jesus íhikaxeahiko. Hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Koati únati koêku ne xâne inixópovoti itúkeovo hána'iti ikonóko'ixovoti nonékuke ne Íhae Vanúke, vo'oku yonópotimo natíxokuke nê'e. ");
INSERT INTO terNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Koati únati koêku ne xâne hokónuti, iyôti koeku kó'oyene, vo'oku kouhépekopinoatimo Itukó'oviti isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—Koati únati koêku ne xâne ákoti kapayásakapu, vo'oku ítukenemo ra poké'e ika'ínamakapakanane. ");
INSERT INTO terNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Koati únati koêku ne xâne kutí koeti épeu úne yoko épeu hímakati koeku yupíheovo kahá'ayea itúkea ponóvoti nonékuke Itukó'oviti, vo'oku kousókinoatimo Itukó'oviti ne âha. ");
INSERT INTO terNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Koati únati koêku ne xâne seánati, vo'oku koseánakonotimakamo. ");
INSERT INTO terNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—Koati únati koêku ne xâne póhutine ponóvoti koekúti opósi'ixo itúkea, vo'oku iníxotimo Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—Koati únati koêku ne xâne oposí'ixoti íkasaxea omíxone po'ínuhiko xâne, vo'oku iháxeokonotimo xe'exa Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—Koati únati koêku ne xâne ikoítoponokonoti kotíveti vo'oku únati ítuke, vo'oku yonópotimo natíxokuke Íhae Vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Koati únati kêkunoe enepo apê ihakópiti, koane vaheréxoti ítukeinopi, koane apémaka ákoti tôpi kixoku yûho itúkoheyea kêku vo'oku itíkivo hokónuti. ");
INSERT INTO terNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yupihovó ákoenoe elókeko yokóvo ixekánaneye, vo'oku koati hána'itimo némoepo vanúkeke. Yoko énomonemaka kixókononeye váherexea ítukeinokono neko porófetahiko koyúhoti emo'u Itukó'oviti nóvo, enepohikoneko inúxoti ya utíke. ");
INSERT INTO terNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Kuteâti koeku itúkeovo únati kixoku koúhekea xánena ne yúki, énomonemaka kénenoeye xapa xâne kîrivokoevo yara kúveu mêum. Itea enepo auké'e taú'iko ne yúki, ákonemo oxéne aúkopinokono taú'iko, yane ákonemo itúkovoke, poéhane kuríkeokono koane kapásikexeokono xoko kuríkokonoku. Yokóhiyanavo mará'inamo yakútea ne yúki ákotine taú'iko. ");
INSERT INTO terNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Kuteâti koeku yúku kouhápu'ikopeti, énomonemaka kénenoeye xapa xâne yara kúveu mêum. Epó'oxo kuteâti koeku pitivóko ovoti oúkeke kali mopôi ákoti itoâti hé'onea, énomonemaka kénenoeye. ");
INSERT INTO terNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ako ihúxoti koúhapu'ikope xovo'ú kixoâti, itea enepo ihúxokono, koati xoko ókoku yúku ixíkokono motovâti koúhapu'ikea uhá koeti ovâti ne kúveu ovokúti. ");
INSERT INTO terNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Énomonemaka ákoeneye únati kixeku itíkivo maka naíxane xanéhiko ne únati ítike, epó'oxo maka iháyu'ikanehiko Itukó'oviti, enepone Yá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Hákonoe ikitíxa nzimínoti ungé'exoponea ra Ponóvoti Kixovókuti ya yútoeke Muîse, koánemaka ne yútoe porófeta koyúhoti emo'u Itukó'oviti mekúke. Haina nzimínoti ungé'exoponea, itea nzimínoti indúkea uhá koêti ne yutoxóvotiya. ");
INSERT INTO terNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Koati emo'úti ra yunzó'inopinoe: Koêkumo âvoyea aúke'e ra vanúke koáne ra poké'e, ákomo ápahuina koekúti veyopóvoti yane Ponóvotike Kixovókuti yútoe Muîse. Muhíkova póhuti kali létara itukovo póhuti kali telépu'i, ákomo veyápapu ya koeku âvoyea kaúsakapu uhá koeti yutoxóvotiya. ");
INSERT INTO terNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Enepone xâne ákoti itukâ ne páhoenokono itúkea yane yutoéti, yusíkoti itúkeovo ínixone ákoyea koati itúkovoke, ina ihíkaxamaka po'i xâne ákoyea itúka, koati énomonemo okopô koati ikenétike ivávakopeokono ya natíxokuke Íhae Vanúke. Itea enepone xâne itukoâti uhá koêti neko yutoéti koane ihíkaxotimaka po'i xâne itúkea, énomonemo itukóvo koati teyonétiya. ");
INSERT INTO terNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Koati ngixópitinoe: Enepone kixeku itíkivo, konókoti yupíheovo anú'ukea ponóvoko kixoku itúkeovo ne éskiriba yoko farîzeu, enepohikone inuxínoti xanéhiko hó'eke. Hákoti koené'eye, ákomo kalíhuina yenópi natíxokuke Íhae Vanúke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ina kixovókoxopamaka Jesus: —Kémoanenoe koêku neko páhoenokono voxúnoekene itúkea, enepone “Hako kepéko” koêti, koánemaka ne koêti: “Enepone koepékoti, omokónotimo yuhoíkovokutike maka ipíhapanakanane” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Itea hara ngixópinoe: Uhá koeti imaíkinovoti po'i xâne, omokónotimakamo yuhoíkovokutike maka ipíhapanakanane. Kene ne vaheréxinoti yuhó'ino po'ínu, omokónotimo xoko koati payásoti yuhoíkovokuti maka ipíhapanakanane. Kene ne koyúhoti itúkeovo ákoti isóneu ne po'ínu, naíxapu nê'e mará'inamo iyánapakana ipihóponovokutike xapa yúku. ");
INSERT INTO terNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Itukovo yomoti iké'iparaxoke Itukó'oviti, ipíheati átake ina puyakápanapu yokóvo ápeyea pe'ínu vaheréxinopiti isóneu, ");
INSERT INTO terNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kurí íxeavo ne yómone xoko áta, pihéne yího'ixoponi ne pe'ínu inúxotike motovâti unátipinokokonoe iséneu, ínamo yaukápapu peréxi Itukó'oviti ne íperaxike. ");
INSERT INTO terNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—Enepone xâne apêti évotikopike, omópiti yuhoíkovokutike, yapásika kíxeaku unátipinoa iséneu ya xenékuke tumúneke sími yuhoíkovokutike. Hákoti koené'eye, itukapu simetíne yuhoíkovokutike, konokoâtimo yéni nonékuke ne pahúkotiya. Yane pahukópitimo kiríkikono xoko pulísea, ínamo kirikákana ika'ákovokutike. ");
INSERT INTO terNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Koati emo'úti ra yunzó'inopinoe: Ákomo ipíhikapa koeku âvoyea peréxapa uhá koêti ne yoréveu —kíxovokoxoane Jesus, exókoatihiko kónokea épemea Itukó'oviti kotúyopinoa pahúnevo tumúneke seópea nonékuke. ");
INSERT INTO terNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ina kixovókoxopamaka Jesus: —Kémoanenoe neko yuhôti koêti: “Hákonoe kepiné'iyi múxone ne po'i xâne” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Itea hara ngixópinoe: Itukovo apêti hóyeno komómoti sêno xaneâti íyokeova, koeku kó'iyeaneye isóneu, koati pahukóvotine vo'ókuke ne váhere oveâti isóneuke. ");
INSERT INTO terNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Enepo itukapu yûke, enepone koâti mbiú koeti ínixepe váherexino ne ítike, yusikóneni meréki koane kiríki ákotike malîka motovâti ákoyea váherexa ítike. Mani unatíne ákoyea poixo'o yûke yenópi vanúke yaneko usokó kó'iyea yûke itea yenópoti ipihóponovokutike. ");
INSERT INTO terNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Koane itukapu veô'u, enepone koati íhinovoke váherexino ítike, yusikóneni titúki koane kiríki ákotike malîka motovâti ákoyea váherexea ítike. Mani unatíne ákoyea poixo'o veô'u yenópi vanúke yaneko usokó kó'iyea veô'u itea yenópoti ipihóponovokutike —kíxovokoxoane Jesus, exókoatihiko kónokea ákoyea íyuhixapapu sayá'ikopeova ne váhere ítuke. ");
INSERT INTO terNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ina kixovókoxopaikomaka Jesus: —Hara koemáka po'i yutoéti: “Enepone kuríkoti yêno, paréxapa koyuhópeti kotuyôpeati îha itúkeovo ko'ímati” koé'epepo. ");
INSERT INTO terNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Itea hara ngixópinoe: Koêkuti kuríkoti yêno ákoti itukapu vo'oku aupú'ikoati yêno yuhó'ixoti po'i hóyeno, koati vaheréxoti ítuke nê'e, epó'oxo koatímakamo kutí'inoke pahukóvoti ne yêno oko'ímapo. Koánemaka ne koyenópati ne sêno, kutí koetímakamo ixómoti aupú'ikea inúxoti îma ne sêno koeku kóyenopea. ");
INSERT INTO terNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Koáne kémoanenoe koêku neko páhoenokono ne voxúnoekene itúkea, enepone koêti: “Hako simikíkixo koeku itúkeovo iháke Itukó'oviti keyúhoyi, itíkoti koati yuhôti. Konókotimaka kéveseki koêkuti yiûho kuteâti. Koati kenokoâti itíki ne yiûho keyúhone iháke Itukó'oviti” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Itea hara ngixópinoe: Hako itukóvo ya iháke koêkuti ihâe keyúhoyi. Muhíkova ya iháke “vanúke” ako yusíka, vo'oku koati ivátakoku Itukó'oviti natíxea nê'e. ");
INSERT INTO terNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Muhíkovamaka ya iháke “poké'e” ákomaka yusíka, vo'oku kutí kôe ómomikoaku Itukó'oviti ne hêve. Muhíkovamaka ya iháke “Njeruzálem” ákomaka yusíka vo'oku itúkeovo pítivokona Nâti koati payásoti ya uhá koêti. ");
INSERT INTO terNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Muhíkovamaka ya iháke “tiûti” ákomaka yusíka, vo'oku enepone póhuti kali híyeu tiûti, ako ítea kehópu'iki, áko'o itukovo keha'âti keháha'ikopi, ákomaka ítea itíki. ");
INSERT INTO terNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Péhuxaikopo ne yiûho. Itukovo “Êm” kêti, énomone yákoe koáne itíka ákoti ike'ítukexa po'i ihâe ikéna'uxi. Itukovo “Áko'o” kêti, énomone yákoe, koane itíka ákoti po'i ihâe vínoake keha'âti ikéna'uxi. Yoko áva po'i vínoake keyúhoyi, koati ukeâti xoko Satánae nê'e. ");
INSERT INTO terNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ina kixovókoxopamaka Jesus: —Kémoanenoe neko emo'úti koêti: “Itukovo apêti okó'okoti uke po'i xâne, konokoâtimaka óko'okeokono ûke. Kúteanemaka koêku áva kehókoti oe po'i xâne, konokoâtimaka kehókeokono ôe” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Itea hara ngixópinoe: Hako itikópono yésa'i enepo áva vaheréxoti ítukeinopi. Itukovo apêti ipusóhovoxopiti, síkeanemaka ipúsokea poixô'oke. ");
INSERT INTO terNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Koáne enepo áva mani iyonópiti yuhoíkovokutike koyúhoti kónokea peréxi ripíno, síkeane omópeamaka keápana. ");
INSERT INTO terNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Koáne áva pahukópiti keínoinoa ínone ovâti póhuti kílomituru, yamína ya pi'âti kílomituru. ");
INSERT INTO terNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Koáne áva epemópiti ítikevo, peréxa. Áva kahá'ati váxeopi ítikevo, ívexamaka. ");
INSERT INTO terNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Kémoanenoe neko emo'úti “Hako motovâ yokóvo ne ínikene koane pívamaka ne puvópiti” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Itea hara ngixópinoe: Hako motovâ yokóvo ne puvópiti. Itíkina orásaum ne vaheréxoti ítukeinopi. ");
INSERT INTO terNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yane itínenoemo itukóvo koati kaná'uti xe'éxaxapa Itukó'oviti ya vanúke. Vo'oku poréxoa Yá'a íhae vanúke uhápu'iyea ne káxe xapa xâne ákoti aunáti, koánemaka xapa únati xâne. Kúteanemaka kíxoaku poréxea úko ne xâne ponóvoti ítuke, koánemaka ne ákoti aunáti ítuke. ");
INSERT INTO terNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Itukapu póhutine xâne ákoti omotóvopi okóvo ako omótovo yokóvo, namo kíxoaye ápeyea némoepo xoko Itukó'oviti? Muhíkova ne koperáxinotihiko nâti, enepone yómoti ánu'ukea kóperau, ákomaka kamáxatika ne ákoti omotóva okóvo. ");
INSERT INTO terNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Itukapu póhutine ínikene itíkino únati, koati kutipasí keâti ne ákotihiko êxa Itukó'oviti, vo'oku énomonemaka kixóhiko itúkeovo. ");
INSERT INTO terNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hukinóvoti ngíxeopinoe: Itíkapunoe ponóvoti kixoku itúkeovo kuteâti koêku Itukó'oviti, enepone Yá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ina kixovókoxopamaka Jesus: —Yokóhiyanavonoe, hako yoposíko noíxeokono ne únati ítike keha'âti iháyu'ikeopi po'ínuhiko xâne, vo'oku enepo akoéneye ne ítike, ákomo némoepo xoko Itukó'oviti, enepone Yá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Enepo áva peréxoake ne xâne apêti nókone, hako kutí koe pehúkoti inuxínopiti oxoti torombéta keha'âti noíxeokono ne ítike, kuteâti kixoku itúkeovo ne xâne ikútixapovoti koati sasá'iti ya po'ínuhiko. Vo'oku enepo apê pôreu ya íhikaxovoku hó'e koáne ya none ovokúti, énomone kixínoakeneye kaha'âtihiko ápeyea ihayú'ikoati. Koati emo'úti ra yunzó'inopinoe: Vo'oku íkomumuxeovone xâne, usóne námoepo nê'e. Yane ákonemo námoepo xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Itea enepo áva hivó'oe, hako kalihú'ina yopósiki ápeyea po'i exoâti, muhíkova ne ínikene koati ákoti omotóva yokóvo ");
INSERT INTO terNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","maka hákone exókono. Yane apêtimo némoepo xoko Itukó'oviti, enepone Yá'a íhae vanúke iníxoti koekúti ákoti po'i noixoâti. ");
INSERT INTO terNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Enepo itikánoe orásaum, hako kitêa ne xâne ikútixapovoti koati sasá'iti ya po'ínuhiko. Vo'oku enepo itûko orásaum, áhatihiko xe'ó kó'iyea ya íhikaxovoku hó'e koánemaka ya none ovokúti vékoheixoku xâne, kahá'ati noíxeokono. Koati emo'úti ra yunzó'inopinoe: Vo'oku íkomumuxeovone xâne, usóne námoepo nê'e. Yane ákonemo námoepo xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kene îti, enepo itîka orásaum, urukú yákoepo kúveu yóvoku. Exexó íxea ne péhapetea. Yépema ne Yá'a íhae vanúke, enepone ákoti inixoâti, yane iko'íparaxopeatimo nê'e. Koáhati iníxoti koekúti ákoti po'i noixoâti. ");
INSERT INTO terNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Koáne enepo itîka orásaum, hako kitêa ne xâne ákoti êxa Itukó'oviti yómoti káyuixea yûho enepo itûko orásaum. Koati ikutíxatihiko yumopókonotimo vo'oku ixómoyea káyuixoa ne yûho. ");
INSERT INTO terNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hako ikítipasikova ne xâne kuteâti nê'e, vo'oku exo nékone ne Itukó'oviti, enepone Yá'a íhae vanúke. Tumúneke yépemi, éxoane ne nékone. ");
INSERT INTO terNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Itea hara yákoe enepo itîka orásaum: “Iti Ha'a ûti íhae vanúke, émbemo téyeamo sasá'iti îhe ne uhá koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Émbemopi ukóponeamo ne netíxi yâye xapákuke ûti, uti xâne. Itúkapu yâha kousókovo yara poké'e kuteâti koeku koúsokeovo ya vanúkeke. ");
INSERT INTO terNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Peréxavi nika ûti itukovo káxe. ");
INSERT INTO terNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ketúyapa pahúnevo ûti koêkumaka kóseanayea ûti ne po'ínuhiko xâne vaheréxinoviti ítuke, kutí kixoâti uti ákoti pahukápu. ");
INSERT INTO terNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hako sike'évi víkorokeovo pahunévotike itea peréxavi víteova ne váhere kixovókuti, (vo'oku poéhane îti itukóvo hána'iti nâti ya uhá koêti. Poéhane îti apê xunáko oúkeke uhá koêti. Poéhanemaka îti itukóvo hána'iti ihayú'iuti ya uhá koêti, ákotinemo hunókoku. Itúkapu énomoneoxo koéneye)” yákoe itîka orásaum —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Vo'oku enepo kutí ixêa ákoti váherexeaku ítukeinopi ne po'inu xâne, kúteanemakamo kixópiku Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Itea enepo hákoti kixeáneye (ne váhere ítukeinopi po'i xâne), ákomakamo katúyapa váhere ítike ne Itukó'oviti, enepone Yá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ina kixovókoxopamaka Jesus: —Enepo jejuá yakôe, hako isone'ekovoo keyê kuteâti kóyeku ne xanéhiko ikútixapovoti sasá'iti ya po'ínuhiko, kahá'atimaka éxokeovo po'ínuhiko xâne itúkeovo jejuá koêti. Ivévaka ra yunzó'inopinoe: Vo'oku íkomumuxeovone xâne, usóne námoepo nê'e. Yane ákonemo námoepo xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kene îti, enepo jejuá yakôe, hako kixevóneye, itea kímanduxapu ina kevaríkapu koane kipénaneapu, ");
INSERT INTO terNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","maka hákone exôa po'ínuhiko xâne itúkeovo jejuá kêti, itea itúkapune póhutine Itukó'oviti exôa, enepone Yá'a íhae vanúke iníxoti koekúti ákoti po'i noixoâti. Yane apêtimo némoepo xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Hako yoposí'ixo kirí'uxi apeínopiti yara poké'e ya ákoyeaku oríkoa kálihunoe hó'openo níkoheyea, koáne ya ápeyeaku iko'íhomuyoxoati, koánemaka xoko ápeyeaku urukú koeti oméxoponea. ");
INSERT INTO terNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Itea itúkapu vanúkeke ítixe apeínopiti xoko ákoyeaku aúke'e, koáne xoko ákoyeakunemo kálihunoe hó'openo nikóheati, koáne xoko ákoyeaku iko'íhomuyoxoati itukovo koesáyu'ixoati, koáne xoko ákoyeakunemo urukú koeti oméxoponea. ");
INSERT INTO terNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Vo'oku koêkuti yunákoaku ne apeínopiti, itukapu vanúkeke áko'o itukapu poké'eke, énomoneoxo yónoheixo iséneu —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Kuteâti koeku yúku kouhápu'ikopeti, énomone koéneye ne uke xâne koxé'uke. Enepo aunáti ne yûke, uhapú'itikemo yóvoheixo. ");
INSERT INTO terNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kene itukapu ákoti aunáti ne yûke, hahákutikemo yóvoheixo. Kúteanemaka koêku ne kouhápu'ikoti isóneu xâne. Enepo itukapu hahakú kixópiti ne mani kouhápu'ikopiti, yupihovó koetíneoxomo itúkeovo hahákutike yóvoheixo. ");
INSERT INTO terNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ina kixovókoxopamaka Jesus: —Ako xâne motovâti pi'á kíxea pátarauxa. Vo'oku koêkumo ákoyea omótova okóvo ne po'ínu, yane ákomo itúkoake ne po'ínu, áko'o enepo itukapu yuíxovoxo ítukexeake ne po'ínu, yane ákomo itúkoake ne po'ínu. Koane enepo yixápu kirí'uxi apeínopiti, ákomo yoxéne yíxivo ítuke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Énomone ngixínopinoe ákoyea ixomo ipúpakina yokóvo ne kixékumo kêku itukovo káxe, ukínopikumo nîke yoko yêka, koane nókone kexé'u kixékumo iké'ipovoxopivo. Vo'oku enepone kéyeku itukovo káxe, haina pohúneti níki. Koane haina pohúneti iké'ipovoxopivo yápeino. ");
INSERT INTO terNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ivévakapihi koêku ne hó'openohiko ôti. Ako nâ. Koane ako ítixeaku ha'i nóne. Ákomaka unákoku nîka, koane ákomaka óvoku ítixoku êno nikokónoti, itea kóyeane poréxea Itukó'oviti nîka, enepone Yá'a íhae vanúke. Hainá'ikopo itínoe yupihóvo itóponone nonékuke Itukó'oviti yane hó'openohiko? ");
INSERT INTO terNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ako ápahuina ya xepákukenoe itotimo koúkoponea kaxena ivókovope, yusíkoti yupíheovo kóxunakeovo kahá'ayea koúkoponea. ");
INSERT INTO terNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—Ná'ikopo koeti yupíhinovo yónea iséneu ne kixékumo iké'ipovoxopivo? Ivévakapihi koeku payá'iyea ne koati uhé'ekoti hîu itunoêvoti ya mêum, enepone humanévoti. Ako okó'ituke, koane ákomaka ixúxuka kuteâti koeku xâne. ");
INSERT INTO terNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Itea koati ngixópitinoe: Muhíkova neko uhá koeti úhe'ene Salúmaum, enepone hána'iti nâti iríku mekúke, ako itápana úhe'ene hîu ne itunoêvotihiko íhae mêum. ");
INSERT INTO terNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Katarákoapo Itukó'oviti ne itunoêvoti íhae mêum mapini póhutine kó'oyene ápeyea, ihârotike oro'ókokonotinemo yúkuke, ínapomo hako katarákopi itínoe xâne ôriti kúveova. ");
INSERT INTO terNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hákoikopo pipokéxo iséneu ixómoyea yépemo'ixopovo ukínopikumo ne nîke yoko yêka koane ípevo. ");
INSERT INTO terNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Enepora uhá koeti koekúti, koati xâne ákoti êxa Itukó'oviti yonóheixoa isóneu. Yoko éxoa Itukó'oviti, enepone Yá'a íhae vanúke, kénokinoe uhá koêti ra koekútihiko. ");
INSERT INTO terNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hane itíka yónoheixoku iséneu inúxotike, ítuke Itukó'oviti koánemaka péni kixeku itíkivo kuteâti ahá'inopi. Yanê'e, kousókinopeatinoemo Itukó'oviti ne uhá koeti po'ínuhiko nékone. ");
INSERT INTO terNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hako pipokéxo iséneu vo'oku nékonemo ihârotike, vo'oku apépotimakamo po'i yónoku iséneu ihârotike. Ópoehane yónoku iséneu ne nékone ya póhutihiko káxe. Hákone kiri'úxoa pipókexinoa iséneu ne nékone ya keno'ókoti káxe —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ina kixovókoxopaikomaka Jesus: —Hákonoe itikóvo xâne húketi isóneuno po'ínuhiko xâne inixeâti ákoyea aúnati enepo hákoti yexôa koêku, mará'inamakamo íxekananeye. ");
INSERT INTO terNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Vo'oku kuteâti kíxeaku iséneunoa ne po'ínuhiko xâne, énomonemakamo kixékononeye. Kuteâtimaka ítikeinoa ne po'ínuhiko xâne, énomonemakamo koéneye ítikeinokono. ");
INSERT INTO terNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—Na koeti yíxinova kemómoyi ne kutí koeti kalîhuti koekúti yonoti ukeku pe'ínu, koeku ákoyea ínixepa ne kutí koeti koati hána'iti itátane tikóti yonoti yukékuke? ");
INSERT INTO terNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na kíxoaye yéxoki po'i xâne pahúnevo koeku ákoyea ínixepa ne pehúnevo? Mani kutí keti xâne ákoti eapâ ne hána'iti itátane tikóti yoneâti ukéku, itea kóyeane kíxea ne po'ínu: “Veyámbinapeavo ne kali koekúti yonoti yukékuke” kixoâti. ");
INSERT INTO terNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Itínoe ikútixapovoti koati sasá'iti ya po'ínuhiko, viyápa inúxotike ne kutí koeti hána'iti itátane tikóti yonoti yukékuke, maka sásasa ákoyepone ínixi. Ínamo omotóva viyópi ne kutí koeti kali koekúti yoneâti ukékuke ne pe'ínu. ");
INSERT INTO terNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Hako kutí kê xâne poréxoti tamúku koati únati yoko sasá'iti koekúti. Hákomaka kutí kê xâne kuríkoti uhé'ekoti iyoyónevoti yupihóvati hepíko xapa kûre, mará'inamo ákanukexa, yane koímaiti okópeopi koane óko'okeopi. ");
INSERT INTO terNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Yépema Itukó'oviti ne yâha vo'oku porexópeatimo. Kéxuna'ixapu yopósiki vo'oku itepónoatimo. Hako imaxovó kixêa yépemo'ixi, kuteâti koeku ixómoti ipusóko pahapéti ehane míhe'okinokonoa. ");
INSERT INTO terNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vo'oku uhá koeti epémoti, poréxokonoa ne épemone. Koáne ne koxuná'ixovoti opósikea ne nókone, itóponoa. Koáne ne kutí kixóvoti ipusókoti pahapéti, mihe'ókinokonoatimo. ");
INSERT INTO terNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Itínoe apêti xe'éxa, maní'ikopomea perexoâti mopôi ne xi'íxa epemápi pâum? ");
INSERT INTO terNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Manímea koéxoe peréxoa epemápi hôe? ");
INSERT INTO terNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Muhíkinova itínoe mapini váhere xâne pahukóvoti nonékuke Itukó'oviti, itea peréxoa únati koekúti ne xi'íxa. Ínapoxo ne Ha'a ûti íhae vanúke, koatimo únati koekúti poréxoa ne xâne epemoâti. ");
INSERT INTO terNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Kuteâti koeku yâha kíxeopineye ne po'íhiko xâne, énomonemaka íxeaneye, vo'oku énomone itukóvo ne koati kaná'uti kixó'ekone ne Ponóvoti Kixovókuti yútoe Muîse, koánemaka ne íhikauvi yútoe porófetahiko koyúhoti emo'u Itukó'oviti mekúke. ");
INSERT INTO terNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ina kixovókoxopamaka Jesus: —Hara víka xoko pahapéti iyonópoti xâne xoko Itukó'oviti, enepone kutí koeti kalíkuti. Vo'oku enepone pahapéti koáne ne xêne yonópoti ipihóponovokutike, koati vákuti nê'e, koane êno xâne vekoâti. ");
INSERT INTO terNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Itea enepone xêne yonópoti xoko Itukó'oviti, ako ávaku koánemaka ne páhapetea, yoko ako axú'ina xâne itoâti vékea. ");
INSERT INTO terNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Yokóhiyanavoa ne xâne ákoti okoyúhoa ne kaná'uti emo'u Itukó'oviti, vo'oku upánini kutí'iyea éxoko su'ûso simopínoe, koatíhiko kutí koeti koyuvôrixovoti yovîre ákoti iyuhixa hopéno'iu enepo isukôa. ");
INSERT INTO terNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ya kixoku itúkeovo, énomonemo yéxi itukóvotiye kuteâti yéxi koêku ne xuve tikóti vo'oku há'i. Ápeikopo xâne veyoti úva xuvékuke topekóxe? itukovo veyoti fîgu ka'ávetike nonéti xapa úhiti? ");
INSERT INTO terNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Vo'oku uhá koeti únati xuve tikóti, únatimaka ne há'i pôreu. Kene ne váhere xuve tikóti, váheremaka ne há'i pôreu. ");
INSERT INTO terNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ako yusíka poréxea váhere há'i ne koati únati xuve tikóti. Ákomaka parexa únati há'i ne váhere xuve tikóti. ");
INSERT INTO terNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Uhá koeti xuve tikóti ákoti parêxa únati há'i, tetúkokono ina kurikókono yúkuke. ");
INSERT INTO terNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kúteanemaka koeku nekôyohiko, vo'oku enepone há'i pôreu, énomonemakamo yéxi itukóvotiye neko xâne. ");
INSERT INTO terNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Hainamo uhá koeti xâne “Unaém, Unaém” kixónuti ûrukopeovomo natíxokuke Íhae Vanúke. Poéhanemo neko itúkoti ahá'inoa Nzá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yaneko káxe, enómo xâne kixónuti: “Unaém, Unaém, koyúhopepo uti yemó'u xapa xâne vitúkoti péhoenovi. Ihékemaka veínoa ûti kópuhikopea ûti ne ndémoniu urúkovoti xoko xâne. Ihékemaka veínoa ûti vitúkea êno iyupánevoti” kixónutimo. ");
INSERT INTO terNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yane ínamo injâ: “Hainánoe iti ovónje. Yahíkuxipunu itínoe itúkoti váhere” ngixoâtimo. ");
INSERT INTO terNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ina kixovókoxopamaka Jesus: —Uhá koeti xâne kamokénoati ra emó'um koane itukoâti, hane koéneye ko'isóneuti hóyeno itúkoti pêno xoko poké'e mopoíxoti. ");
INSERT INTO terNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Keno'óko êno úko, koínikone huvêo ina kayakákoa êno xúnati ihunóvoti neko ovokúti, itea ako íkarakapu vo'oku itúkeovo xoko poké'e mopoíxoti ixíkokono. ");
INSERT INTO terNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","—Kene uhá koeti kamoâti ra emó'um ákoti itukâ, hane koéneye xâne ákoti isóneu itúkoti pêno xoko poké'e hariríxoti. ");
INSERT INTO terNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Keno'óko êno úko, koiníkone huvêo ina kayakákoa êno xúnati ihunóvoti neko ovokúti, yane íkorokovone. Heu-heú kôe itáhineyea —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Uke'éxone koyúhoyea ne Jesus, enepohikoneko êno xâne kamokénoati, yupíhova iháyu'ikea ne ihíkauvoti íhikaxone, ");
INSERT INTO terNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","vo'oku koati iyúseoti itúkeovo úkeakune xokóyoke ne hána'iti exóneti íhikaxone ne Jesus, kene haina kuteâti ne éskiribahiko, enepone ihíkaxoti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Evesékopeane Jesus oúke neko kali mopôi, yupihovó koe êno xâne hokopâti. ");
INSERT INTO terNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yane apé koéne hóyeno ahi'ókovoti Jesus. Enepone hóyeno, yúvone koati váhere arinéti iháxoneti lépara. Ipuyuké koéne nonékuke Jesus koane kíxea: —Unaém, enepo yakahá'a, motóva kesása'ikopinu yara arínem —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ina sipo'ókoa Jesus koane kíxea: —Ngahá'a, sesá'ipine ra yaríne —kíxoane. Ehá'axo koyúhoa Jesus, má koépone neko aríne, unátipone. ");
INSERT INTO terNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ina kixôa Jesus: —Hako yetó'oko koêkuti xâne ra índukeinopi, itea yéxakapanapa ne sasedóti, enepone inuxínoti xâne hó'eke. Yamína iké'iparaxoke Itukó'oviti kuteâti koeku páhoenovi yútoe Muîse, yéxokovope itúkeovo yunatípotine —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Simoáne Jesus ne Kafanâum, ápe ikoseânaxovati, hóyeno ákoti itukapu jûdeu, tuti póhuti séndu húndaru íhae Róma. ");
INSERT INTO terNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Hara kíxoa: —Unaém, anêko anzínoe ka'aríneti óvonguke. Ákone ita ehévokeovo mûyo. Koati yupihóvotine koítoponeovo kotíveti vo'ókuke ne aríne. ");
INSERT INTO terNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ina kixôa Jesus: —Mbihotímo yóvokuke, ngoitóvatimo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Itea hara kíxoa tuti húndaru: —Unaém, ako yomótokea yûrukivo óvonguke. Pohu pahú íxea unátipea ne anzínoe, yane itóvotinemo. ");
INSERT INTO terNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vo'oku undímaka hóyeno konókoti itúkea páhoenonu payásoti ya undíke. Koane ápe húndaru konókoti itúkea mbáhoenoa. Poéhane kónoko “Pîhe” ngíxea, yane pihotíne. Kene po'ínu, “Kiná'aka” ngixôa, kenó'oko. Koane anzínoe, “Hara itíka” ngixôa, itúkoa ne mbáhoenoa itúkea —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kamoáne Jesus neko emó'uinoa tuti húndaru, yupíhova iháyu'ikea, ina kixôa neko xanéhiko hokoâti: —Koati emo'úti ra yunzó'inopinoe: Ako noínjeaku xâne koati kuvovónuti kuteâti râ'a, muhíkova xapákuke íhae Izarâe —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ina koe'íkomaka: —Koati ngixópitinoe: Enómo xâne ukeâti po'íkehiko poké'e ya xoko úkeaku ihâroti koáne ya xoko kíyo'i káxe ivatákoponotimo ya xe'o mêsa ya ayuíti xapákuke evo Âbraum, Izáki yoko Njáko ya natíxokuke Íhae Vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Itea enepohikone íhae Izarâe, enepone mani koati noivókoeti yonópea, kurikókonotimo xapa êno hahákuti, óvoku iyókexoti yoko ngarutútukexoti ôe vo'oku tiveko koêku —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ina kixôa Jesus neko tuti húndaru: —Pihépane yóvokuke. Vo'oku kívivonu, énomone ákoeneye kuteâti yâha —kíxoane. Énomone yaneko ókoku káxe, unátipone ahínoe neko tuti húndaru. ");
INSERT INTO terNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Simoné'e ne Jesus óvokuke Pêturu, inu'í kíxeane imóse ípeke, yupihóvoti otuko mûyo. ");
INSERT INTO terNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yane namú kíxeane vô'u Jesus. Uké'epone neko otuko mûyo, ina exepúkopo neko sêno, yane kátarakopone Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yaneko kíyo'i káxe, omókonone xoko Jesus neko êno xâne ûroevo ndémoniu. Yane pohu pahú kixópa Jesus neko ndémoniuhiko, ipúhikoponehiko, yoko koítovamaka uhá koêti neko xâne ka'aríneti. ");
INSERT INTO terNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kó'inokeneye motovâti koúsokeovo neko yuho Itukó'oviti, yútoeke porofeta Izâiya mekúke, enepone koêti: “Koati énomone veyopínovi varíne, koane oúkeke yonópo uhá koêti ne veópone” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Noixoâne Jesus yupíheovo êno xâne hokó'ixoati, pahúkoane neko íhikauhiko usó kíxoixea vatéke tarú'uxope poixô'oke neko Mar-na Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yane ápene éskiriba, enepone ihíkaxoati ne Ponóvoti Kixovókuti yútoe Muîse, ahi'ókovoti Jesus. Hara kíxoa: —Ihikaxotí, nzokópitimo koêkuti yénoku. ");
INSERT INTO terNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ina kixôa Jesus: —Enepone úkoe, ápe úhorona, koáne ne hó'openohiko ôti, ápe môko. Kene ûndi, undi íhae vanúke ikútipasikoponovoti xâne, ako óvongu yonómboku ómomingea yara kúveu mêum —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ínamaka apê po'i hokoti Jesus kixoâti: —Unaém, sikénuvo engóxeakomo nzá'a inúxotike enepo ivakápune, ínamo nzakâpi. ");
INSERT INTO terNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Itea hara kíxoa Jesus: —Kiná'akane ingéneke. Síkeane ne kutí koeti ivokóvotinehiko ákoti yuixápu ítuke Itukó'oviti ekóxopeamo ne ivokóvoti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yane úsa'ixovane Jesus ne vatéke koane íhikauhiko ikéneke. ");
INSERT INTO terNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Koeku píhea, apé koéne êno xúnati ihunóvoti. Koati xúnati ovóxokeovo ne úne enó'inoke úne urúkovati ne vatéke. Yoko imókoti ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ina ahi'ókova íhikauhiko koyúkoati. Hara kíxoa: —Unaém, yokótixovi mará'inamo vívahikapu. ");
INSERT INTO terNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ina kixovókoxoa Jesus: —Na koeti itíkinovonoe îreti? Koati itínoe xâne ôriti kúveovonu —kíxovokoxoane. Ina exepúko ne Jesus pahukôa ókea ne ihunóvoti koane kóyunukeovo ne úne. Yane huvemoo koépone ikéne. ");
INSERT INTO terNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yupihovó koe píkeahiko neko íhikau. Hara kixókoko: —Kutimea itukóvoye ra hóyeno? Muhíkinova úne yoko ihunóvoti itúkea yûho —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Simoné'e ne Jesus poixô'oke neko Mar-na Ngalíleya xoko poké'e koéhati Ngâdara, apé koéne pi'âti hóyeno okotúmonexoati ukeâti pe'áxatike, ainóvoti ûroevo ndémoniu. Yoko hi'imé koéne xâne pikoâti vékea xe'ókuke neko óvoheixoku, vo'oku itúkeovo koati koímaitine neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yane kóhonokone emó'u neko pi'âti. Hara kôe: —Jesus, Xe'exa Itukó'oviti, na koeti yího'ixopoinovi? Simínetine ipíheponivi tumúneke símea kaxéna? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yoko ápe êno kûre ixómotihiko níko xêrerekuke neko óvoheixoku. ");
INSERT INTO terNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ina kixopómaka Jesus neko ndémoniuhiko: —Enepo itukapu pehukópoviti, hane pehúkapavi xapákuke ne êno kûre —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Pihépanenoekopoya —kíxoane Jesus. Ipuhíkopeanehiko, ponokó koépone xapákuke neko êno kûre. Yane heú koéne éhahikeovo neko kûre koane íkorono'ekeovohiko úneke ukeâti oúke ne mopôi. Heú koéne yúpuririhikeovo. ");
INSERT INTO terNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kene enepohikone koyonoâti neko kûrehiko, kohó'ikene. Simoné'e pitivókoke, koyúhoahiko uhá koêti neko koekúti koánemaka koépoku neko pi'âti hóyeno ûroevo ndémoniu. ");
INSERT INTO terNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yane pihónehiko ne ko'óvokuti noíxoponea Jesus. Simohíko xokóyoke, koyúhoinoahiko kahá'ainoa ipúhikopea yane poké'exa. ");
INSERT INTO terNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ina urúkopovamaka Jesus ne vatéke yanekôyoke. Taru'úxoane neko úne, yane pihópone ya pitivóko éxokexeaku. ");
INSERT INTO terNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Énomone yanê'e, apé koénehiko xâne ominoâti hóyeno isayú'ixovoti ákoti ehevákapu mûyo. Ixané kíxoahiko poúke. Noixoâne Jesus itúkeovohiko koati kuvovâti, ina kixôa neko isayú'ixovoti: —Nje'exá, aúhepepone iséneu, itúyopone pehúnevo. ");
INSERT INTO terNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yoko ápe ihíkaxoti yútoe Muîse, enepone éskiribahiko xapákuke. Ina kôe isóneunoahiko: “Enepora hóyeno, koati itûkovoti Itukó'oviti” koénehiko isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yane exó kíxeane Jesus isóneuhiko, ina kixoáhiko: —Na koeti váherexino iséneunonu? ");
INSERT INTO terNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kuti itukóvoxo ákoti hé'onoke'e ngíxea ra isayú'ixovoti: “Itúyopone pehúnevo?” áko'o “Yexépukapa, yenápa” ngíxea. ");
INSERT INTO terNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Itea kó'oyene, enjókopitinoe ápeyea njunáko yâye yara poké'e ngotúyopea pahunévoti, undi íhae vanúke ikútipasikoponovoti xâne —koéne. Ina kixôa Jesus ne isayú'ixovoti: —Yexépukapa, viyápa ne peúke, pihépane yóvokuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yane xépu koépone neko isayú'ixovoti, pihópone óvokuke. ");
INSERT INTO terNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Enepohikoneko ênoti xâne noixoâti, yupíhova iyúpaxeova ne koekúti koane iháyu'ikeahiko Itukó'oviti vo'oku poréxea xunakóti ne xâne yara poké'e kíxeaneye ne ítuke, ikutíxatihiko xanehí koêti ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Úkeane ukopóno ne Jesus, yane noíxone hóyeno koéhati Máteu, vaata koyêti xoko kóperaxoku vo'oku itúkeovo koperáxinoti nâti. Ina kixôa Jesus: —Kiná'aka ingéneke. Yane xepú koéne ne Máteu, pihóne hókea Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ikénepoke, ixómoti níko ne Jesus yoko íhikauhiko óvokuke Máteu, simóne êno po'ínuhiko koperáxinoti nâti, enepone yómoti ánu'ukea kóperau, koánemaka xâne pahukóvoti kaha'íneti Jesus níkeahiko xe'ókuke mêsa. ");
INSERT INTO terNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Noixoâne farîzeu, enepohikone yuixóvoti hókea yútoe Muîse, hara kixo íhikauhiko Jesus: —Na koeti ínikinoa ihíkaxopiti ne koperáxinotihiko nâti koáne ne xâne pahukóvoti? —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kamoáne Jesus épemo'ikeokono ne íhikauhiko, hara koéne: —Enepohikone xâne ákoti yuvâti, ako okónoko ipixáxoati. Poéhane ka'aríneti konokôa. ");
INSERT INTO terNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Itea pihénoe, yapásika yéxi kixó'ekone ne yutoéti emó'uke Itukó'oviti, enepone koêti: “Hane ngahá'a itíkivo seánati, kene haina ngahá'ati iké'iparaxinu hó'openo képeu” koêti. Vo'oku haina nzimínoti xâne ponóvoti kixoku itúkeovo, itea hane nzimíno, xâne pahukóvoti (maka ikátivexane isóneuke ne pahúnevo koane kuríkopea) —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yane pihóne xoko Jesus ne íhikauhiko Xuaum Mbátita. Hara kíxoahiko: —Na kó'inoaye iséneu ne jejuá kó'iyea xâne? Vo'oku ûti, uti íhikau Xuâum, kóyekune jejuá kó'iyea ûti koánemaka ne farîzeuhiko, itea ako jejuá ákoe ne íhikeuhiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ina kixôa Jesus: —Yusíkoikopo ikáxu'iyea okóvo ne húpiu kasâtuxoti koêkuiko ápeyea ne koyénoti híyeuke? Ako kalíhuina. Itea simóvotimo káxe veyópeokonokumo ne koyénoti xapákuke. Yane ínamo jejuá akôe —kíxovokoxoane Jesus, kixopóvoti yane éxetina. ");
INSERT INTO terNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ina koe'íkomaka Jesus: —Ako veyoti inámati ipovóti itukoâti ihápa'akope xoko yékoteno ipovóti, vo'oku mani koukóponoati ívarereoku ne yékoteno ipovóti —kíxovokoxoane, ihókoati inámati ipovóti ne ihíkauvoti íhikaxone ákoti akutêa ne kúxoti hó'e xâne. ");
INSERT INTO terNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ina koe'íkomaka: —Ákomaka yusíka unákeovo inámati víyum ya yékoteno íhaku itukéti ya vakamóto, mará'inamo ívarerea ne yékoteno íhaku enepo ihiyáka ne inámati víyum. Yane mani evókovoti ne víyum koánemaka ne íhaku. Itea konókoti ímeokono inámatike íhaku ne inámati víyum. Yane ákomo évakapu ne íhaku koáne ne ovâti —kíxovokoxoane, itúkoti po'i íhokoake ne ihíkauvoti íhikaxone. ");
INSERT INTO terNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ixómoiko koyûho ne Jesus, símoane hóyeno teyonéti ya hó'eke jûdeu. Ipuyuké koéne nonékuke Jesus koane kíxea: —Ínati ivokóvo kali inzíne. Yaxénapanu óvonguke. Pohu ipihó íxepana veô'u xokóyoke, iyukópovotimo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yane exépuko ne Jesus, úkeane pího ikéneke koánemaka íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yane apé koene sêno nduse koetine xoénae ká'arine. Akó'oti áka evésekea aríne. Akéneke Jesus véko sipóheoponeati heve ípovo, ");
INSERT INTO terNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","vo'oku hara koeti isóneu: “Enepomo pohu nzipáheyea ípovo, indóvotimo” koeti isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yane na'akené koéne ne Jesus. Noixoâne neko sêno, hara kíxoa: —Nje'exá, aúhepepone iséneu. Itévone vo'oku kívivonu —kíxoane. Énomone yanê'e unátipone neko sêno. ");
INSERT INTO terNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Úkeane ukopóno ne Jesus óvokuke neko hóyeno inuxínoti xanéhiko ya hó'eke. Simoné'eya, noíxoane neko êno xâne oxoti étakati ikotívexoati isóneuke ne ivokóvoti, koane ákoyea tôpi kixóvoku íyokexeahiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ina kixovókoxoa Jesus: —Yahíkuxapunoe vo'oku haina ivokóvoti râ'a, pohu imókoti —kíxovokoxoane. Yane koémoke'eanehiko neko yuho Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ipuhíhikopone neko êno xâne, yane ûrukovone Jesus, ina namukêa vô'u neko seno kalivôno, yane exépukopone. ");
INSERT INTO terNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Koati ákoti malîka yónoku eyékoxeokono neko koekúti yaneko poké'e. ");
INSERT INTO terNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ipuhíkopeane evo Jesus neko pitivóko, ápe pi'âti komítiti hokoâti koane kóhonokea emó'u kíxea: —Iti ámoripono Ndávi, yokóseanavi —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Urúkovone ovokútike ne Jesus, ahí'okovane ne pi'âti komítiti, ina kixoáhiko Jesus: —Kitípoaxo motó'iyeova ngoíteovopinoe? —Êm Unaém, ngutípopi —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ina ipiho vô'u ukékuke neko komítiti xaneâti kíxea: —Vo'oku kívivonu, énomone ákoeneye kuteâti yâha —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yane ínixoponehiko. Yoko í'ixiko'o kíxoixoa Jesus. Hara kíxoa: —Hako kalihú'ina yéto'oki koêkuti xâne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Itea koeku pihópeahiko, inamá'axone koyuhópa ne koekúti. Koati ákoti malíka yónoku itóhineyea ne eyekoûti ya uhá koêti neko poké'e. ");
INSERT INTO terNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pihopónehiko neko pi'âti, omókono xoko Jesus hóyeno mókere ûroevo ndémoniu. ");
INSERT INTO terNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yane kópuhikopa Jesus neko ndémoniu, ina koyuhópo neko hóyeno. Enepohikoneko êno xâne noixoâti, yupíhova iyúpaxeova neko koekúti koane kó'iyeahiko: —Ako noíxeaku ûti kuteâti yara poké'exa ûti, uti íhae Izarâe —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Itea poé'ainoa isóneu farîzeuhiko. Hara koéhiko vo'ókuke: —Enepora hóyeno, hane porexôa xunakóti kópuhikopea ndémoniu tûti ne uhá koeti ndémoniu —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yónoa Jesus xapa uhá koêti neko pitivóko yoko ipuxóvokutihiko, ihíkaxoti íhikaxovokuke hó'e jûdeuhiko, koyuhó'inoati ne inámati ihíkauvoti koeku natíxea Itukó'oviti xapa xâne koane koitóvotimaka xâne ka'aríneti, koêkuti kó'iyeovoku aríne koane eóponehiko. ");
INSERT INTO terNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Noixoâne Jesus neko êno xâne, yupihovó koéne kóseanayea, vo'oku koati kotíveti koêkuhiko, koane mómitihiko kuteâti koeku su'ûso pihohí koêti ákoti koyonoâti. ");
INSERT INTO terNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ina kixovókoxoa Jesus ne íhikau: —Koati hána'iti ra itukéti, kuteâti kavâne ainóvoti itóvotine ha'i nonéti ovâti, itea ako axú'inahiko ra ko'itúkeati. ");
INSERT INTO terNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yépemanoekopo Itukó'oviti, Únae ra itukéti, pahúkea po'ínuhiko ko'itúkeati. ");
INSERT INTO terNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ina ihaxíkoa Jesus ne nduse koeti íhikau, porexoâti xunakóti kópuhikopea ndémoniuhiko urúkovoti xoko xâne koane koíteovomaka ka'aríneti koêkuti kó'iyeovoku aríne yoko eópone neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yoko ká'aye koéhahiko neko nduse koeti ápostulu páhoe Jesus koyúhoyea emó'u xapa xâne: Enepone inúxoti, Símaum koéha. Pêturu yonópo îha; ina apê Ándere, po'inu Pêturu; ina keno'óko Teâku yoko Xuâum, xé'ahiko Nzebêdeu; ");
INSERT INTO terNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","koane Filípi; Mbatulúmeu; Túme; yoko Máteu, enepone koperáxinoti nâti; koane Teâku, xé'a Áfeu; koane Tádeu; ");
INSERT INTO terNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","yoko Simaum Nzelóti; yoko Njuda Iskarióti, eneponeko itûkoheovoti koeku hókea Jesus koane kurikoâti xoko xanéhiko puvâti. ");
INSERT INTO terNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Enepohikoneko nduse koêti, énomone pahúko ne Jesus xapa xâne. Hara kíxovokoxoa inâ pahukôa: —Hákonoe yéno xapákuke xâne ákoti itukapu jûdeu. Hákomaka píhe pítivokonake íhaehiko Samâriya. ");
INSERT INTO terNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Itea hane yapásika xanena ûti, uti íhae Izarâe, enepohikone kutí koeti moyónitihiko su'ûso ákoti koyonoâti. ");
INSERT INTO terNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pihénenoe, yokóyuhopoinoa itúkeovo kaxénane natíxea ne Íhae Vanúke xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Keítapanoe ne ka'aríneti koane kéxepukapanoe ne xâne ivokóvoti. Keítapamaka ne xâne yúvone lépara, koane képuhikapamaka ne ndémoniu urúkovoti xoko xâne. Kuteâti ngixópiku ákoti ngaperáxapi, énomonemaka íxeaneye itíki ne itukéti ákoti keperáxa xâne. ");
INSERT INTO terNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Hákonoe yómo tiûketi piúsunake, enepone ôro, péhu yoko níki. ");
INSERT INTO terNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Hákonoemaka yómo íhaku ípevo koeku yéni, koane hako yómo yesá'ikovope koane piríkatana. Muhíkova piló'ina hako yomâ, vo'oku koati motokeâti koúsokinokono nókone ne xâne ko'ítuketi. ");
INSERT INTO terNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Itukovo apêti pitivóko, áko'o ipuxóvokuti símeku, yapásika xâne usó koyêti poréxeopi yóki óvokuke. Énomone yávaheixa xokóyoke tukú koeti ipíhikopiku ne pitivóko. ");
INSERT INTO terNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Koeku yûrukivoa ne ovokúti símeku, yépemina unako koêku ukeâti xoko Itukó'oviti ne ko'óvokuti. ");
INSERT INTO terNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Enepone xâne ovâti ne ovokúti, itukapu usó koyêti poréxeopi yóki óvokuke, kousókinokonoatimo kuteâti yépeminoake xoko Itukó'oviti. Kene enepo hákoti koené'eye, hákoti unâti kixópiku, yoúkekemo yonópo ne yépeminoake xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Koêkuti ákoti akahá'api, ákotimaka akahá'a kámokenoyea yiûho, enepo ipihíkapi óvoku itukovo pítivokona, ikétatahevexapapu. Kiríkapa ne ipú'ine poké'e hivíkuke, yexókoati ákoyeane omótokea íkameokono emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Koati emo'úti ra yunzó'inopinoe: Simapúne kaxena ipíhoponope Itukó'oviti, muhíkova ne koati váhere xâne mekúke íhae Sódoma yoko íhae Ngómora, ákomo itápana tiveko ipíhoponeake Itukó'oviti ne xanéhiko íhae neko pitivóko ákoti akahá'apinoe. ");
INSERT INTO terNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ina kixovókoxopamaka Jesus neko íhikauhiko: —Koeku mbahúkeopinoe, kutí koe mbahúkoti su'ûso ya xapa yovîre. Itíkapunoekopo usokó koyêti kuteâti koeku koéxoe, koane itíkapumaka ákoti vaheréxa ítuke kuteâti koeku kurûte. ");
INSERT INTO terNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yokóhiyanavonoe, vo'oku apêtimo xâne iyonópitinoe yuhoíkovokutike koane yehepóke'exopitinoemo xoko íhikaxovoku hó'e xanena ûti. ");
INSERT INTO terNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Vo'oku itíkivonoe hokónuti, yomokónotinoemo yíhoikikono nonékuke ngovenâdo yoko nonékuke nâti. Itea kixínekonokenemoye motovâti keyúhoyi nonékukehiko, koánemaka nonékuke ne ákoti itukapu viyéno jûdeu koêku ra kitípone. ");
INSERT INTO terNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Enepo yamakánanenoe nonékukehiko, hako pipokéxinoa iséneu ne kixékumo yimópi, vo'oku yaneko káxe, yexókokonotimo yimópike. ");
INSERT INTO terNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Vo'oku hainamo ukeâti iséneuke ne yimópope, itea koati ukeâti xoko Itukó'oviti, enepone Yá'a íhae vanúke koeku itúkeovo Sasá'iti Omíxone koyuhô xikóyoke. ");
INSERT INTO terNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Apêtimo xâne kuríkoti koati po'ínu xoko payásotihiko, motovâti koépekeokono. Kúteanemakamo kíxoaku hóyeno ne xé'a. Apêtimakamo okópoti koati há'a yoko êno, kuri'ókoatimaka xâne koepékoatimo. ");
INSERT INTO terNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yupihóvatimo púveopi uhá koeti xâne vo'oku itíkivonoe hokónuti. Itea enepone koxuná'ixovoti ingéneke ákoti aukápapu ikéne tukú koeti hunókokuke, énomonemo pihopô vanúkeke xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Enepo pivakána, hako'óne keyunúkokono yane pitivóko yóvoheixoku, yokóho'i po'íke pitivóko. Koati emo'úti ra yunzó'inopinoe: Ákomo yuké'exa yénoheyi ra uhá koeti pítivokona Izarâe tumúneke aúngopovope yara kúveu mêum, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Enepone ihíkaxovoti, haina énomone payasô ya ihíkaxoati. Koáne ne ahinoêti, haina énomone payasô ya pátarauxa. ");
INSERT INTO terNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Itea enepone ihíkaxovoti, motóva kúxea kutipasí kó'iyea ihíkaxoati. Kúteanemaka koêku ne ahinoêti, motóva kúxea kutipasí kó'iyea pátarauxa. Itukovo mbuvokónoti, undi yúnae, koeku ínzaxeokono Mbezêbu, enepone tuti uhá koeti ndémoniu, ínapoxomo itínoe ovónje. ");
INSERT INTO terNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ina kixovókoxopamaka Jesus: —Hákonoe píke xâne. Ako kixovókuti pikonéti éxeokono kó'oyene ákotimo exákana. Kúteanemakamo ne he'onó koêti kó'oyene, kóyeanemo urápu'ipea. ");
INSERT INTO terNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Enepone yunzó'inopinoe vainóvone, akô'o po'inu xâne, yokóyuhoanenoemo xapa xanéhiko. Koáne ne ínzikaxeopike vainóvone, kéhanakanemo keyúhopi motovâti éxea uhá koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hákonoe píke xâne motovâti koépekeopi, vo'oku poéhane kexé'u íto, itea ako xunáko iyónopeopi ipihóponovokutike. Hane tíya Itukó'oviti, enepone apêti xunáko koépekea xâne koane iyónopea ipihóponovokutike. ");
INSERT INTO terNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Hainá'ikopo kali póhuti pe'u tiûketi, ákoti axu'ína ovâti ko'ésa'i ne pi'âti kálihunoe hó'openo ôti kavanékono? Itea ako ápahuina ivokóvoti xapákukehiko ákoti exâ Itukó'oviti, enepone Yá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kene itínoe, muhíkova yé'akeye ne híyeu tiûti, heú kíxoa éxea Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hákoikopo píke, vo'oku itínenoe yupihóvo itóponone nonékuke Itukó'oviti yane ênoti hó'openo ôti. ");
INSERT INTO terNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Uhá koeti koyúhoti nonékuke xanéhiko itúkeovo hokónuti, kúteanemakamo ngíxoaku ngoyúhoyea itúkeovo hokónuti nonékuke Nzá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Itea enepone koyúhoti nonékuke xanéhiko ákoyea itúkapu hokónuti, ngoyuhópatimakamo nonékuke Nzá'a íhae vanúke ákoyea itúkapu hokónuti. ");
INSERT INTO terNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Hákonoe ikitíxa nzimínoti omínoam úhepeyea isóneunokoko ne xâne yara kúveu mêum. Haina énomone nzimíno, itea koati apêtimo okopókokoti vo'ónguke. ");
INSERT INTO terNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Enepora nzímea, énomone kutí'ino apêtimo hóyeno poe'aînoti isóneu há'a. Énomonemaka kutí'ino apêtimo sêno poe'aînoti isóneu êno. Kúteanemakamo koêku ne sêno yoko imóse. ");
INSERT INTO terNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yane koati iyénoxapa kúveuke ne óvoku puvopâmo ne xâne hokónuti. ");
INSERT INTO terNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Enepone xâne yupihóvoti ákoyea omótovo okovo há'a yoko êno ya undíke, ako omótokea itúkeovo hokónuti. Koánemaka ne xâne yupihóvoti ákoyea omótova okóvo ne xé'a itukovo ihíne ya undíke, ákomaka omótokea itúkeovo hokónuti. ");
INSERT INTO terNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Enepone ákoti usó akóye koítoponeovo kotíveti ingéneke kuteâti koeku xâne koinópoti kurúhuna iyonókonone xoko kurúhuxokonokumo, ákomaka omótokea hókeonu. ");
INSERT INTO terNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Koêkuti xâne yuixóvoti koúhepekeovo óvea yara kúveu mêum, énomonemo evókoa ne koati kaná'uti apéyeati ákoti hunókoku xoko Itukó'oviti. Itea enepone usó koyêti évokea úhepeko kóyeku yara kúveu mêum vo'ónguke, énomonemo itopóno inamápoti apéyeati ákotinemo hunókoku xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ina kixovókoxopamaka Jesus: —Koêkuti xâne únati kixópiku simêa óvokuke, undímaka kixóneye. Epó'oxo koêkuti kixónutineye, hanemaka kixóneye Itukó'oviti, enepone pahukónuti yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Koêkuti xâne ákoti kamaxátika porófeta, enepone koyúhoti emo'u Itukó'oviti, koane teyoâti vo'oku itúkeovo ovoxe Itukó'oviti, apêtimo námoepo nê'e xoko Itukó'oviti kuteâti ne námoepomo porófeta. Koane koêkutimaka ákoti kamaxátika xâne ponóvoti kixoku itúkeovo, koane teyoâti vo'oku ponóvoko ítuke, apêtimo námoepo xoko Itukó'oviti kuteâti námoepo ne ponóvoti kixoku itúkeovo huvó'oe. ");
INSERT INTO terNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Koati emo'úti ra yunzó'inopinoe: Koêkuti xâne apêti póneake ne koati ákoti apayáso xapákuke ne hokónuti, teyoâti vo'oku itúkeovo ínzikau, yusíkoti itúkeovo kali póhuti enovópeti puhí koeti kásati úne poréxoa, ákomo kalíhuina évokea námoepo xoko Itukó'oviti vo'ókuke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Uke'éxoane Jesus koyúhoinoa nókonehiko itúkea ne nduse koeti íhikau páhoe koyúhoyea emó'u, ina pího po'íkehiko pitivóko yaneko poké'e ihíkaxoti koane koyúhoti emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yoko ika'ákovokutike ovóne ne Xuaum Mbátita. Kamoné'e koeku ítuke Jesus Kristu, yane pahúkone íhikauhiko épemo'ikoponea Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Hara kixóponoa: —Énomone îti ne kuxonéti símeamo? áko'o kónokoako kúxeako uti po'ínu. ");
INSERT INTO terNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ina kixôa Jesus: —Yaúkapapu xoko Xuâum. Yéta'akapa koêku ra kémone koáne ra neíxone. Hara íxepamo: ");
INSERT INTO terNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Ínixopone ne komítiti. Yonópone ne mohéveu. Unátiponehikomaka ne yúvone koati váhere arinéti, enepone lépara. Kamópone ne mókere. Iyúkopovone ne ivokóvoti, koane koyúhovone xapa xâne ákoti apeínoati ne inámati ihíkauvoti ítuke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Koati únati koêku ne xâne ákoti opoé'ainonu isóneu” íxepamo —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pihopóne neko íhikauhiko Xuâum, turíxovone Jesus koyúhoinoa xanéhiko koêku ne Xuâum. Hara kíxovokoxoa: —Enepo pihenôe neíxoponi Xuâum ya mêum ákoti apêti, kutí'ikopo kixónoe neíxi? Xâne muyá'iti kuteâti koeku hí'e kayákae ihunóvoti? Ako kalíhuina. ");
INSERT INTO terNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kutí'ikopoya ne neíxopono? Hóyeno yupihóvoti úhe'ekea ípovo? Ako kalíhuina kó'iyeaneye ko'ípovoyea nê'e. Vo'oku poéhane óvokuke nâti óvo xâne kuteâti nê'e. ");
INSERT INTO terNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kutí'ikopoya ne neíxopono? Porófeta koyúhoti emo'u Itukó'oviti? Êm, koati porófeta nê'e, koane koati ngixópitinoe yupíheovo anú'ukea itúkeovo teyonéti ya po'ínuhiko porófeta. ");
INSERT INTO terNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Vo'oku enepone neíxoponone, hara koe yuho Itukó'oviti emó'uke vo'ókuke: “Mbahukoâtimo timúneke ne koyuhó'inonuti emó'um maka míhe'akinapine yoxéne itíki índukexeopike xapákuke xâne” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ina kixovókoxoakomaka Jesus neko xâne: —Koati emo'úti ra yunzó'inopinoe: Xapákuke xâne yara kúveu mêum, ako teyonéti ya Xuaum Mbátita. Itea upánini itúkeovo koati hána'iti teyonéti ne Xuâum yâye yara kúveu mêum, koati yupihóvotimo anú'ukea itúkeovo teyonéti ya Xuâum ne xanéhiko ya natíxokuke Íhae Vanúke, muhíkova ne ákoti apayáso xapákuke. ");
INSERT INTO terNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ukeátine ya kaxénake Xuaum Mbátita tukú koeti kó'oyene, enepone inámati ihíkauvoti koyúhoti koeku natíxea ne Íhae Vanúke xapa xâne, koati xúnati yúmo'ixeova xanéhiko éxea koêku. Yoko enepohikone koxuná'ixovoti éxea koêku, énomone itopónoa. ");
INSERT INTO terNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Vo'oku ukeátine mekúke tukú koeti kaxénake Xuâum, ápe yútoeke porófetahiko koane Ponóvotike Kixovókuti yútoe Muîse koyúhoti koêku ne natíxea Itukó'oviti xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Epó'oxo yakahá'anoe kitípi yútoe ne porófetahiko, kitipoâtimo itúkeovo Xuâum itukóva ne Îliya, enepone koyúhone porófetahiko símeamo. ");
INSERT INTO terNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Koêkuti kamoâti ra yûnzo, ivávaka. ");
INSERT INTO terNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Kutimea motóvo ínzokea ra xanéhiko apêti yara káxehiko kó'oyene? Hara ínzokoa kalivónohiko vataká koyêti ya none ovokúti ákoti ínixone unáko apê po'ínuhiko kalivôno kaha'âti ikómohixea. Yane hara kixókonohiko: ");
INSERT INTO terNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Voxone oxokénati móhikena elóketi okóvo, itea ákonoe yakáha'a kemóhiyi. Vimókovonemaka akene imokó'ikoti ivokóvoti, itea ákomaka yakáha'a” kixókonone. ");
INSERT INTO terNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ina kixovókoxopamaka Jesus: —Énomonemaka kénenoeye vo'oku simóne Xuaum Mbátita yuixóvoti jejuá kó'iyea yoko ákoyea énapu víyum, itea ako ínixeanoe unáko, epó'oxo “ûroevo ndémoniu nê'e” kíxeanoe. ");
INSERT INTO terNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ina nzímo xepákukenoe iníngoti xâne, undi íhae vanúke ikútipasikoponovoti xâne, itea ákomaka ínixeanoe unáko. Hara kôe iséneunonu: “Koati nípati yoko énovokenati víyum ne hóyeno, koane yómoti aínavokoxeovo koperáxinoti nâti yoko po'ínuhiko xâne pahukóvoti” kixénunoe. Itea enepone koati kaná'uti exóneti, kóyeanemo iyúseyea kó'iyeaneye vo'oku kixoku itúkeovo ne xanéhiko hokoâti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yane turíxovone Jesus koyúhoyea motókeyea ipíhoponeokono ne ko'óvokuti yane pitivókohiko vékoku itúkea êno iyupánevoti, vo'oku ákoyeahiko ikátivexa isóneuke ne pahúnevo koane kuríkopea. Hara koe yuho Jesus vo'ókuke: ");
INSERT INTO terNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Koati kotívetimo kêku, itínoe íhae Korâzim, keánemaka itínoe íhae Mbetâsaida, vo'oku eneponi itukapu ya pítivokona ákoti êxa Itukó'oviti, enepone Tîru yoko Sîdom, indúkoahiko ne iyupánevoti índuke xepákuke, mani mékutine kuríkopo váherevoko ne xanéhikoya. Mani ko'ipóvotinehiko ko'ixéhiti xáku koáne mani purapú'ikovotinehiko pôu, éxokovopehiko yupíheovo ikótivexea isóneuke ne êno pahúnevohiko. ");
INSERT INTO terNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Koati enjókopeatinoe koêkumo: Simapúne kaxena ipíhoponope ne Itukó'oviti, koati iyuhí kixokónotimo tiveko ipíhoponeokono ne íhae Tîru yoko íhae Sîdom ya itíke. ");
INSERT INTO terNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kene itínoe íhae Kafanâum, itínoe po'okoâti yupíheovomo kahána'ikeokono ya po'ínuhiko xâne, kirikókonotinoemo ipihóponovokutike. Vo'oku eneponi itukapu ya xapákukehiko ne koati váhere xâne íhae Sódoma indúkoa ne iyupánevoti kuteâti índuke xepákukenoe, mani kutipónutinehiko. Epó'oxo ákoni uké'exa Itukó'oviti, itea mani anéyetiko tukú koeti kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Koati enjókopeatinoe koêkumo: Simapúne kaxena ipíhoponope ne Itukó'oviti, iyuhii kixokónotimo tiveko ipíhoponeokono ne íhae Sódoma ya itíke —kíxovokoxoane Jesus neko xâne. ");
INSERT INTO terNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Énomone yaneko ókoku ôra hara kixo Itukó'oviti ne Jesus: —Aínapo yákoe Pai, iti Únae vanúke koane poké'e, vo'oku ákoyea itúkapu hána'itinoe ko'éxoneti yoko hána'itinoe ihíkaxovoti yara kúveu mêum yéxokoa ra koekúti, itea itúkeovo xâne inixóneti ákotihiko itóponone keúhapu'ikinoa ra koekúti. ");
INSERT INTO terNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Koati énomone kíxea ne ítike Pai, vo'oku ínixi unáko kó'iyeaneye —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ina koe'íkomaka ne Jesus: —Uhá koeti koekúti, kurí'okoponoane Nzá'a. Ako exónuti, undi Xe'exa Itukó'oviti, ákoti itukapu Nzá'a. Poéhane exónu. Koane ákomaka exoâti ne Nzá'a ákoti itukapu ûndi, undi Xe'éxa, yoko koêkuti xâne ânja énjokea. ");
INSERT INTO terNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Yahí'akapununoe, itínoe kutí koeti xâne koínoti êno ínati koekúti, itínoe yupihóvotine momí'iyea, yoko undínemo kayapáhikopinopea. ");
INSERT INTO terNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Itíka ne índukexeopike, enepone kutí koeti íngoinoxeopike, vo'oku ngaha'ínepitimoya. Íhikexapu njokóyoke ngixoku indúkeovo, vo'oku undi itúpa'ikoti, koane ako ngapáyasakapu, ínamo mbarexápinoe hána'iti ómomikea iséneu. ");
INSERT INTO terNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Vo'oku enepone kutí koeti íngoinoxeopike, haina kutí koeti êno ínati koekúti motovâti hí'inaxeokono, itea koati yáyapahi koyêti —kíxovokoxoane Jesus neko xâne. ");
INSERT INTO terNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yaneko káxehiko, vekónehiko kali xêne vekoti kavâne ne evo Jesus ya xapa itóvope ha'i nonéti. Yoko sâputu nekôyo, káxe sasá'itino jûdeuhiko. Epékexoatine hímakati ne íhikauhiko. Yane turíxovone marékeahiko ha'i tirîku koane níkea. ");
INSERT INTO terNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Noixoâne farîzeuhiko, hara kixo Jesus: —Yokómoma itúkovoke ne íhikeuhiko. Koati itúkoti koekúti ákoti parexá'avea Ponóvoti Kixovókuti hó'e ûti vitúkea ya sâputu. ");
INSERT INTO terNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ina yumopâhiko Jesus: —Ákoikopo yíhoikikunoe ya emó'uke Itukó'oviti koeku ítuke ne Ndávi mekúke yaneko epékoa hímakati koánemaka ha'ínehiko? ");
INSERT INTO terNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Vo'oku yaneko urúkova Ndávi neko óvoku Itukó'oviti, níkoa neko pâum ikó'iparaxokonoke Itukó'oviti, itúkoti koekúti ákoti parexâ yútoe Muîse itúkea. Kúteanemaka koêku ne ha'ínehiko, mani ákoti omotóva níkea neko pâum. Poéhane sasedóti, enepohikone inuxínoti xanéhiko hó'eke motovâ níkea. ");
INSERT INTO terNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ákoikopomaka yíhoikiku Ponóvotike Kixovókuti yútoe Muîse koêku ne sasedótihiko? Koati ko'ítuketi hána'itike imokóvokuti ya sâputu, upánini ákoyea paréxakana xanéhiko ko'ítukeyea ya sâputu, itea ako pahúkapuhiko koeku ko'ítukeyea. ");
INSERT INTO terNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Koati ngixópitinoe kó'oyene: Anéyene koati teyonéti yane hána'iti imokóvokuti, enepora yuhó'ixopitinoe. ");
INSERT INTO terNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Eneponi yexâ koati kixó'ekone ne yutoéti emó'uke Itukó'oviti, enepone koêti: “Itíkivo seánati, ene ngahá'a, kene haina iké'iparaxinu oró'oeti hó'openo” koêti, ákoni váherexinanoe iséneu ne ákoti pahúnevo. ");
INSERT INTO terNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Vo'oku undíne exêa koêku ne sâputu, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Úkeane ukopóno ne Jesus. Ina urúkova ne íhikaxovoku hó'e xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yoko ápe hóyenoya timovó'uti. Enepohikone xâne oposí'ixoatine évekinoaku yuhóhiko itúkeovo pahukóvoti ne Jesus, hara kíxoahiko: —Yane Ponóvoti Kixovókuti yútoe Muîse, motóvaikopo koíteovokono ne ka'aríneti ya sâputu? ");
INSERT INTO terNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ina kixovókoxoa Jesus: —Ínani áva xepákukenoe apêti su'úsona ikoróno'ekovoti uhoróku ya sâputu. Ákonikopomea ituka xunáko veyópea? ");
INSERT INTO terNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yoko yupihóvone ápeyea itóponone ne xâne ya su'ûso. Motóvaikopo vitúkea únati koekúti ya sâputu. ");
INSERT INTO terNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ina kixôa neko hóyeno: —Kepáya'akapa ne veô'u. Koáne, itúkoa ne yuhó'inoa Jesus. Yane unátipone. Kutipasí koépokokone ne vô'u. ");
INSERT INTO terNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yane ipúhihikopone ne farîzeuhiko, koane ixómoyeahiko oposí'ixo kixókumo koépekea Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Exoâne Jesus isóneunoa ne puvâtihiko, ákone ávaheixa xapákuke. Koati êno xâne pihôti ikéneke Jesus. Yane koítova Jesus uhá koêti ne ka'aríneti xapákuke. ");
INSERT INTO terNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Itea ixíko'okoa ákoyea okóyuhoahiko xapákuke xâne neko ítukeinoa. ");
INSERT INTO terNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kó'inokeneye, koati simóvotine kaxéna neko yuho Itukó'oviti xokóyoke ne porofeta Izâiya mekúke, enepone koêti: ");
INSERT INTO terNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Anéye ra ovónje noívongoe, ákoti omotóva ongóvo, ominónuti hána'iti elókeko ongóvo. Mborexoâtimo ovo'ó kó'iyea ne Sasá'iti Omínjone, koane koyuhoâtimo xapa xâne ákoti itukapu jûdeu ne Ponóvoti Kixovókuti íhae njokóyoke. ");
INSERT INTO terNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ákomo itúkapu yumópokenati nê'e, koane ákomo vaúka xapa xâne, koane ákomo itúkapu hónoti koyúhoyea ya none ovokúti. ");
INSERT INTO terNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Koseánatimakamo ne xâne ákotine xunáko, enepohikone kutí koeti kalísoti ókono hí'e ekehókotine. Koane koseánatimakamo ne xâne kutí koeti páviu enepo kaha'áne ípukeovo. Ákomo kutí íxa ipukoâti. Énomonemo koe ítuke imókonemo uke'éxapa uhá koêti ne vaherévokoti itukápumo ainóvoti ponóvoti kixovókuti apê. ");
INSERT INTO terNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yoko énomonemo itúko kúxoixone ne uhá koeti xâne, koêkuti óvohikoku yara kúveu mêum” koe yútoe Izâiya. ");
INSERT INTO terNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yane omókonone xoko Jesus hóyeno mókere komítiti, ûroevo ndémoniu. Koítova Jesus. Yane koyúhopone koane ínixopone neko mókere komítiti. ");
INSERT INTO terNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyúpaxova heú koeti xâne noixoâti koane kó'iyeahiko: —Eneporâ'a, hainá'ikopomea ne Ámoripono Ndávi kixonéti, enepone páhoe Itukó'oviti koíteovo xâne kúxone ûti? —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Itea enepohikone farîzeu, kameáne yuhóhiko, poé'ainoa isóneu koane kó'iyeahiko: —Ako po'i xunakóti veínoake kópuhikopea ndémoniuhiko ra hóyeno ákoti itukapu xunako Mbezêbu, enepone pahúkoti uhá koeti ndémoniu —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yoko exó kíxea Jesus ne isóneuhiko. Yane hara kíxovokoxoa: —Uhá koeti natixókuti óvoku xâne ixómoti okopókoko, itohíneotimo xanéhikoya, ákonemo ovâti. Kúteanemakamo koêku ne pitivóko yoko ko'óvokutihiko ovoti póhutike ovokúti, itukovo ixómoti okopókoko, uke'épotinemo itúkeovo póhutine óvohikoku. ");
INSERT INTO terNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eneponi itukapu Satánae kopúhikopo po'íhiko ndémoniu ovóxehiko, mani koati okopópovoti. Yane mani uké'etine xunáko. ");
INSERT INTO terNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Koáne, eneponi itukapu xunákoke Mbezêbu ngópuhikopea ndémoniuhiko kuteâti iséneunonunoe, ná'ikopo kó'inoaye iséneu ne he'ínehiko ya hé'eke kopúhikopotimaka ndémoniu? Ako kalíhuina kó'inoaneye yihó'inoa kuteâti ra yihó'inonu. Koati énomonehikomo kouhápu'iko itúkeovo pahukóvoti ne iséneunonu. ");
INSERT INTO terNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Koeku itúkeovo ya xunákoke Sasá'iti Omíxone Itukó'oviti ngópuhikopea ndémoniuhiko, koati iyúseoti símeovone kaxena natíxea Itukó'oviti xepákuke. ");
INSERT INTO terNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Maní'ikopo motovâti ápeyea urúkeovoti óvokuke xúnati hóyeno omópea ítukevo ákoti ika'áka inúxotike? Konókoti iká'akea inúxotike, ínamo itâ omópea ítukevo —kíxovokoxoane Jesus, ihókoati xúnati hóyeno ne Satánae, koane kixopóvoti itúkeovo xunané'e ya Satánae. ");
INSERT INTO terNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ina koe'íkomaka: —Enepone xâne ákoti huva'áxanu, koati okopónuti. Koane enepone ákoti itukapu nza'íne índukeke, itopó kíxoa ukóponea ne itukéti índuke. ");
INSERT INTO terNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hukinóvoti ngíxeopinoe: Heú koeti kó'iyeovoku váhere ítuke ne xâne, motóva kotúyopeovo, muhíkova ne koemóke'eti Itukó'oviti, itea enepone koyúhoti itúkeovo ítuke Satánae ne ítuke Sasá'iti Omíxone Itukó'oviti, ákonemo itúyopeaku ne pahúnevo. ");
INSERT INTO terNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Enepone vaheréxoti emó'uinonu, undi íhae vanúke ikútipasikoponovoti xâne, apêtikomo oxéne itúyopea pahúnevo. Itea enepone koyúhoti itúkeovo ukeâti xoko Satánae ne ítuke Sasá'iti Omíxone Itukó'oviti, ákonemo itúyopeaku ne pahúnevo kó'oyene yara koeku óvea yara kúveu mêum, koánemakamo ikénepoke —kíxovokoxoane Jesus neko xâne. ");
INSERT INTO terNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ina koe'íkomaka ne Jesus, itukínoatihiko íhokoake ne âha íhikaxea: —Enepone únati xuve tikóti, únatimaka ne há'i pôreu. Kene ne váhere xuve tikóti, váheremaka ne há'i. Vo'oku hane éxeokono ne xuve tikóti, há'i pôreu. ");
INSERT INTO terNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Itínoe ámoripono xâne kutí koeti koâti ipúhokovoti koéxoe, na kíxeaye keyúhoyi únati koekúti? Vo'oku hane koyúho ne xâne, oveâti isóneuke. ");
INSERT INTO terNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Enepone únati xâne, aínovo únatinoe koyúho ukeâti ne únatinoe koekúti unakóvoti isóneuke. Kene ne váhere xâne, aínovo ákoti aunáti koyúho ukeâti ne váhere koekúti unakóvoti isóneuke. ");
INSERT INTO terNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","—Koati ngixópitinoe kó'oyene: Uhá koeti emo'úti koyuhohí kíxone xâne, konokoâtimo yumópea Itukó'oviti vo'ókuke yaneko káxe yuhaíkapane Itukó'oviti ne xanéhiko vo'oku kixoku itúkeovo. ");
INSERT INTO terNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vo'oku hanemo exôa kixékonokumo, kixeku keyúhoyi, itukapu pehukópokonotimo ipihóponovokutike, áko'o itukapu iyenópokonotimo xapa kasása'iupo Itukó'oviti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yane hara kixo Jesus ne evo éskiriba yoko farîzeu, enepohikone xâne teyonéti hó'eke jûdeu: —Ihikaxotí, kahá'ati noíxea uti itíki iyupánevoti, hoénaxovope ápeyea xunako Itukó'oviti xikóyoke. ");
INSERT INTO terNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ina yumopâhiko Jesus: —Koati ákoti aunáti ra xanéhiko yara káxehiko símokune ûti. Koati ákotimaka kuvâpu Itukó'oviti, épemoikomaka noíxea iyupánevoti índukeinoa, hoénaxovope itúkeovo xoko Itukó'oviti úkea njunáko. Itea ákomo ápahuina iyupánevoti noíxonemo, ákoti itukapu kuteâti koeku kixókonoku porofeta Njóna mekúke. ");
INSERT INTO terNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kuteâti mopó'ayea káxe yoko yóti óvoheixea okóvoike hána'iti hôe neko Njóna, kúteanemakamo mopó'ayea káxe koane yóti ómbonea opékuke poké'e, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Epó'oxo simapúne kaxena yúhoikopeakumo Itukó'oviti ne xanéhiko, hanekóxonomo ne xâne íhae Nínivi xapákuke ne xanéhiko apêti kó'oyene. Exepúkotimo neko íhaehiko Nínivi, exókoatimo pahúnevo ne xanéhiko apêti kó'oyene. Vo'oku ikótivexoa isóneuke váherevoko neko íhae Nínivi koane kuríkopea kamoné'e yuho Njóna koyúhoti emo'u Itukó'oviti mekúke. Yoko anéyene koati payásoti ya Njóna, enepora yuhó'ixopitinoe itea ako itúkokonoke yûho. ");
INSERT INTO terNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Koánemaka neko seno nâti mekúke íhae poké'e koéhati Sâba, hanekóxonomo xapákuke ne xanéhiko apêti kó'oyene, yaneko káxe yuhaíkapa Itukó'oviti ne xanéhiko. Exepúkotimo neko sêno exókoatimo pahúnevo ne xanéhiko apêti kó'oyene, vo'oku yupíheovo ákoyea malíka úkeaku neko sêno kámokenoponea ne êno hána'iti kó'exoneyea Salúmaum. Yoko anéyene kó'oyene koati payásoti ya Salúmaum, enepora yuhó'ixopitinoe, itea ako itúkokonoke yûho —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ina kixovókoxopamaka Jesus neko xâne: —Enepo ipuhíkopea xâne ûroevo ne ndémoniu, píhoheo ya mêum ákoti apêti oposíkoti ókoku itea ako ínixapana. ");
INSERT INTO terNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Énomone kó'ino: “Aungópovotiko xoko imbúhikopeakumeku” kôe. Yane aúkopovane, yoko inú'ikopane ákoyea ovâti, koane sásasa koyépotine, yoko êno úhe'ene vo'oku ákoyea inú'epoya. ");
INSERT INTO terNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ina itaíkopono po'i seti koeti ndémoniu itúkoti xanépone. Yoko aínovo koati váhere yane inúxoti. Ina urúhikopova neko hóyeno. Yane yupihovó koépone váherexea koépoku ne hóyeno yane inúxoti koêku. Yoko énomonemo koéneye xokóyoke ra váherehiko xâne apêti yara káxehiko símokune ûti váherexeamo koépoku hunókokuke yane inúxotike —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Koêkuiko koyúhoyea ne Jesus xapákuke neko xâne, simó koene eno Jesus yoko ámeno kaha'âti yúho'ixoponea. Yoko meúkeke óvoheixohiko. ");
INSERT INTO terNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ina apê kixopónoati ne Jesus: —Anêko mémaina yoko yámeno meúkeke kahá'ati yúho'ixeopi. ");
INSERT INTO terNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yane hara koe Jesus: —Enepone ênom yoko mbo'ínuhiko, harâ'ahiko —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ina so'ixôa ne íhikauhiko, koáne kíxea: —Enepohikorâ'a, énomonemaka indúko ênom yoko mbo'ínuhiko. ");
INSERT INTO terNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vo'oku koêkuti xâne itúkoti ahá'inoa Nzá'a íhae vanúke, énomonemaka indúko koati mbo'ínu, mongéxa, yoko ênom —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Koati énomone yaneko káxe, ipúhikea óvoku ne Jesus ivatákoponoti xe'ókuke Mar-na Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yane ho'uxo-ho'uxó koéne êno xâne xokóyoke. Vo'ókuke neko êno xâne, ûrukovo kúveuke vatéke ne Jesus ina ivatáko. Kene neko xanéhiko, óvane xe'ókuke úne xe'okó koyêti. ");
INSERT INTO terNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Êno ihíkauvoti íhikaxone Jesus ya xêti apêti íhokoake ne âha íhikaxea. Hara kíxovokoxoa: —Ápe hóyeno nopónoti ake nonéti. ");
INSERT INTO terNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Koeku kásahikea, ápe irihíkovoti xe'ókuke xêne. Yane kenó'okone hó'openo ôti nikopâti neko ake nonéti. ");
INSERT INTO terNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kene po'ínuhiko, xapákuke mopôi îrihikovo xoko ákoyeaku axú'ina móte. Koati ákotihiko oríko íhonopea vo'oku ákoyea axú'ina móte xoko îrihikovoku. ");
INSERT INTO terNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Itea ako oríkoa oró'okea káxe vo'oku ákoyea yónoku poéheve. Yane movohí koéne. ");
INSERT INTO terNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Koane ápemaka irihíkovoti xapa tôpe. Yane inuxó koéne payákeyea ne xuve tôpe. Yane ákone oxéne payákeyea ne nonéti vo'oku huruvokó kó'iyea tôpe. ");
INSERT INTO terNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ina apémaka irihíkovoti únatike poké'e. Énomone porexô há'i. Ápe porexópoti póhuti séndu há'i ya póhuti áke úkeaku. Ina apémaka porexópoti sesenta koêti yoko tirinta koêti ya póhuti úkeaku. ");
INSERT INTO terNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Koêkuti kamoâti ra yûnzo, ivávaka —koéne ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ina ahi'ókovoxo Jesus ne íhikauhiko koane kíxea: —Na koeti itúkinovo exetínati vínoa íhikexi ne xanéhiko? ");
INSERT INTO terNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ina kixovókoxoa Jesus: —Vo'oku enepone koekúti kixoku natíxea ne Íhae Vanúke xapa xâne ákoti po'i exeâti koêku, itínoe porexókono éxea. Kene po'ínuhiko xâne, ako paréxakana éxea koêku. ");
INSERT INTO terNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Vo'oku enepone apêti námoe yara yunzóke, kuri'úxovotineoxomo námoe koane yupihovó koetíneoxomo. Kene ne ákoti axu'ína námoeya, muhíkova ne íkutixane apêti xokóyoke, evókoatimo. ");
INSERT INTO terNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Énomone itúkinovo exetínati apêti íhokovoke veínoam ínzikaxea ne xanéhiko. Vo'oku upánini noíxoahiko, itea kutí koe ákoti inixâ. Koane upánini kámoa, itea kutí koe ákoti kamâ, koane ákomaka éxina isóneu koêku. ");
INSERT INTO terNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Koáhati simóvotine kaxéna neko yuho Izâiya koyúhoti emo'u Itukó'oviti mekúke, enepone koêti: “Kemoâtinoemo, itea ákomo kalíhuina yéxinoanoe iséneu ne kémone. Neixoâtinoemo, itea ákomo kalíhuina iyúseinopi koêku ne neíxone. ");
INSERT INTO terNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Vo'oku títiu kóyeyea omíxone ra xanéhiko, exexó kixóhiko kêno koane ûke. Yane ako ínixone koane kámone. Ákomaka éxina isóneu koêku. Yane ákomaka aúkapapu njokóyoke, koane ákomaka ngaítapahiko —koe Itukó'oviti.” ");
INSERT INTO terNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ina koe'íkomaka ne Jesus: —Koati únatinoe kêku vo'oku ápe itópoinopike neíxi koane ápe itópoinopike kémokenoyi. ");
INSERT INTO terNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Koati emo'úti ra yunzó'inopinoe: Êno porófeta koyúhoti emo'u Itukó'oviti mekúke, yoko enómaka po'ínuhiko xâne koati ponóvoti kixoku itúkeovo mekúke yumó'ixovati noíxea kuteâti ne neíxonenoe kó'oyene, itea ako naíxa. Koane enómaka yúmo'ixeova kámea kuteâti ra kémonenoe kó'oyene, itea ako káma —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Yakámokenoanoe kixó'ekone ra énjetina apêti íhokovoke koêku ne hóyeno nôti. ");
INSERT INTO terNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Uhá koeti xâne kamoâti ne emo'u Itukó'oviti koyúhoti kixoku koeku natíxea ne Itukó'oviti xapa xâne, koeku ákoyea éxina isóneu, yane kenó'okone Satánae veyopeâti isóneuke ne kámone. Énomone kuteâti ne ake nonéti irihíkovoti xe'ókuke xêne. ");
INSERT INTO terNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kene ne ake nonéti irihíkovoti xapákuke mopôi xoko ákoyeaku axú'ina móte, énomone kuteâti ne xâne namukoâti ne emo'u Itukó'oviti inâ kamôa, xaneâtimaka hána'iti elókeko okóvo, ");
INSERT INTO terNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","itea vo'oku kutí kó'iyea nonéti ákoti poéheve, ako áxu'ikene hókea. Enepo simôa kotíveti koekúti itukovo apêti ikoítoponoati kotíveti vo'oku kutípea emo'u Itukó'oviti, yane itavókeatine. ");
INSERT INTO terNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kene enepone ake nonéti irihíkovoti xapa xuve tôpe, énomone kuteâti ne xâne kamoâti ne emo'u Itukó'oviti itea pepoké kixoti isóneu vo'oku nókone yara kúveu mêum, koane iyókovotimaka enó'iyea apeínoati. Énomone ákoino ukápana ítukeke Itukó'oviti, koane ákomaka únati ítukeino Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Itea enepone ake nonéti irihíkovoti únatike poké'e, énomone kuteâti ne xâne kamoâti ne emo'u Itukó'oviti, epó'oxo koati exínoati isóneu. Yane koâti apêti únati ítukeino Itukó'oviti kuteâti koêku ne ake nonéti porexópoti póhuti séndu há'i ya póhuti áke úkeaku itukovo sesenta koêti, áko'o itukovo tirinta koêti ya póhuti úkeaku. ");
INSERT INTO terNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ina koyuhó'inoamaka Jesus po'i xêti apêti íhokovoke. Hara kíxoahiko: —Enepone kixoku natíxea ne Íhae Vanúke xapa xâne, hane koéneye hóyeno nôti koati únati ake nonéti isáneke. ");
INSERT INTO terNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Itea ya yóti koeku imókeahiko xâne, sîmo anáne neko hóyeno ina nopóno váhere úhiti koati ákoti pahuíxa tirîku xapákuke ne nóne tirîku. Yane pihópeane. ");
INSERT INTO terNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ihonópone neko nonétihiko, koane kaha'ínemaka, xané kíxoanemaka ne váhere úhiti. ");
INSERT INTO terNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ina pihinôa ahínoehiko neko únae kavâne. Hara kíxoa: “Unaém, aínovopepo únatinoe ake nonéti nêo iséneke. Námea koeti ápeino ne váhere úhiti xapákuke?” ");
INSERT INTO terNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","—“Vanáne nopónoa” kíxoane únae ne kavâne. —Ina kixoá'ikomaka ahínoehiko: “Kehá'a mârekexopea ûti ne úhiti?” ");
INSERT INTO terNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—Ina yumopâ únae ne kavâne: “Ávavone mará'inamo ixané íxea tirîku ímarekea ne úhiti enepomo merekânoe kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Síkeavone ne tirîku payákeyea, koáne ne úhiti xapákuke tukú koeti ítixovope ne há'i. Yane ínamo injâ ne itíxotihiko: ‘Ítixepa inúxotike ne úhiti, ínamo ikenúkuxa motovâti orópukuxeovo yúkuke. Itea yunákapanoe ne tirîku xoko unákovoku íhae inzáne’ ngixoâtihikomo” koéne. ");
INSERT INTO terNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ina apémaka po'i yuhó'inoa Jesus ya exetínati apêti íhokoake. Hara kíxovokoxoa: —Enepone natíxea Íhae Vanúke xapa xâne, hane koéneye ukóponea áke ne mostarda, enepo nôa xâne isáneke. ");
INSERT INTO terNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yoko kaná'uteoxo itúkeovo koati kalîhuti ya uhá koeti ake nonéti, itea enepo ihonópone, anu'ú kíxoahiko ne po'inu nonéti ya kavâne. Kutí koe xuve tikóti kutí'inoke motovâti hó'openo ôti itúkea môko káva'oke. ");
INSERT INTO terNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ina koyuhó'inoamaka Jesus po'i xêti apêti íhokoake. Hara kíxovokoxoa: —Enepone ukóponea ne natíxea Íhae Vanúke xapa xâne, hane koéneye kohiyákopeti pâum veínoake sêno ánahixea mopo'âti ihíxopeti tirîku. Ehane heú kíxoa kohíyakea ne tirîku —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Uhá koêti ra ihíkauvoti íhikau Jesus, aínovo exetínati apêti íhokoake veínoa íhikaxea ne êno xâne hokoâti. Ako íhikaxa ákoti itukapu ya exetínati apêti íhokoake. ");
INSERT INTO terNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kó'inokeneye, hane simovóne kaxéna yútoe porófeta mekúke, enepone koêti: “Aínovomo exetínati apêti ínzokoake ngoyúho. Ngouhápu'ikoatinemo ne koekútihiko ákoti po'i exoâti, ukeátine inâ apê ra mêum” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yane íkopova Jesus neko êno xâne koane pihópea óvokuke. Ina ahi'ókova íhikauhiko. Hara kíxoa: —Keúhapu'ikapinavea kixó'ekone ne yéxetinameku koêku ne úhiti híyeuke nonétihiko. ");
INSERT INTO terNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ina kixovókoxoa Jesus: —Enepone noâti ne únati ake nonéti, ûndi kixó'eko, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kene ne kavâne óvoku ne nonétihiko, hane kixó'eko kúveu ra mêum. Kene ne únatinoe ake nonéti, aínovone xâne yonópoti natíxokuke Itukó'oviti. Kene ne úhiti ákoti pahuíxa tirîku, hane kixó'eko xâne váhere kixoku itúkeovo itúkoti ahá'inoa Satánae. ");
INSERT INTO terNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kene noâti ne úhiti, enepone anáne neko únae kavâne, énomone ne Ndeâpu. Kene ítixopovope ne ha'i nonéti, hane kixó'eko, simapúne hunókoku ra kúveu mêum. Kene ne ahinoêti itixópati ne ha'i nonéti, énomone ne ánjuhiko íhae vanúke ovóxehiko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kuteâti kixókonoku ikánukuxopeokono neko úhiti yoko kuríkeokono yúkuke, énomonemakamo koéneye hunókokuke ra mêum. ");
INSERT INTO terNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Vo'oku mbahúkotimo ovónjehiko, enepohikone ánju, undi íhae vanúke ikútipasikoponovoti xâne, yane veyopâtihikomo ne uhá koeti xâne yómoti kátavokea po'ínuhiko váhereke, yóko'o ne xâne váhere kixoku itúkeovo, haxakeâti ya xapákuke ne xâne iyónombonemo nandíxokuke. ");
INSERT INTO terNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yane kurihíkoatimo yúkuke ipihóponovokutike, óvokumo íyokexea xâne koánemo ngarútutukexea ôe vo'oku tiveko koêku. ");
INSERT INTO terNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yóko'o ne xâne ponóvoti kixoku itúkeovo, kutí koetimo uhápu'ine káxe seapánehiko vanúkeke xoko natíxoku Há'a íhae vanúke. Koêkuti kamoâti ra yûnzo, ivávaka —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Enepo inâ iyukínova isóneu xâne éxea itúkeovo koekúti yupihóvoti unáko ne itúkopeovo xanena Íhae Vanúke koane yonópea natíxokuke, hane koéneye kuteâti koêku tokononé kôa xâne ne koati únati koane kohépiti koekúti ya mêum opékuke poké'e ákoti exoâti ápeyeaya. Koati yupihovó koeti elókeyea okóvo koeku tokónoneyeova. Yane imôpanemaka xoko ínixoponeaku koeku píheako kaváneponea uhá koeti ítukevo, itúkoti vanéxopeakemo ne poké'e óvoku neko koekúti koati únati ya uhá koêti. ");
INSERT INTO terNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ina kixovókoxopamaka Jesus: —Enepone itúkopeovo xanena Íhae Vanúke ne xâne koane yonópea natíxokuke enepo inâ exôa unáko, hanemaka koéneye, kuteâti koeku xâne yómoti vanéxea koane kaváneyea êno uhé'ekoti uhá'iti mopôi iháxoneti pêrula, ixómoti oposí'ixo koati únatinoe. ");
INSERT INTO terNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tokonóneova póhuti iyoyónevoti kuteâti, koati yupihóvoti unáko, kaváneane ne uhá koeti apeínoati ina vanexópa neko pêrula. ");
INSERT INTO terNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Enepone natíxea Íhae Vanúke xapa xâne, hanemaka koéneye enepo kurikókono úneke ne hána'iti namukópeti hôe. Yane ako tôpi kó'iyeovoku hôe námoe. ");
INSERT INTO terNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Puhi-puhí kôa hôe, ina mikukópa numíkuxotihiko xe'ókuke úne. Yane vatá kó'inoane koane noívokoxopea ne únatinoe koane ipíhea xoko íhakuxoake. Kene ne ákotihiko aunáti, kûrihikoa. ");
INSERT INTO terNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Énomonemakamo koéneye ya hunókokuke ra mêum. Keno'ókotimo ne ánjuhiko ukeâti vanúke, enepone ovoxe Itukó'oviti veyohíkopatimo koane haxakoâtimo ne váherehiko xâne ya xapákuke ne ponóvoti kixoku itúkeovo. ");
INSERT INTO terNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ínamo kurihíka koatíke kótuti yúku ipihóponovokutike, óvokumo íyokexea xâne koánemo ngarútutukexea ôe vo'oku tiveko koêku. ");
INSERT INTO terNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ina kixovókoxopamaka Jesus neko íhikauhiko: —Yéxinoanoe iséneu uhá koeti kixó'ekone ra yûnzo? —Êm, véxoa —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yane ina koe'íkomaka ne Jesus: —Énomone ngixínopinoe: Uhá koeti éxoti íhikaxea yútoe Muîse, exeâtimaka koêku ne inámati ihíkauvoti koyúhoti koeku natíxea ne Íhae Vanúke xapa xâne, inamá'axo kuri'úxovo éxone íhikaxea. Hane koéneye ha'a kalivôno, únae ovokúti ênoti koekúti íhakuke kaúnae, enepone inámati ípihoneya koánemaka ne kúxoti kaúnae, aínovo véyone apê nókone xe'éxaxapa —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Uke'éxoane Jesus koyúhoyeahiko ra xêti apêti íhokovoke, yane pihópone. ");
INSERT INTO terNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Seopóne pítivokonake, íhikaxomaka xanéhiko ya íhikaxovoku hó'e. Koati yupihóvati iyúpaxeova xanéhiko ne ihíkauvoti íhikaxone Jesus. Hara koéhiko: —Namea úkea ne exóneti éxone râ'a koánemaka ne xunakóti veínoake itúkea ne ítuke? ");
INSERT INTO terNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hainá'ikopo ne xé'a karapínteru nê'e? Hainá'ikopomaka ne koéhati Mâriya ko'éno? Kene po'ínuhiko, hainá'ikopo Teâku, Yûse, Símaum yoko Njûda? ");
INSERT INTO terNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hainá'ikopomaka ovoti xapákuke ûti ne uhá koeti mokéxahiko? Na kixoâtiye éxea ne exóneti éxone? —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yane yupihovó koene poé'ainoa isóneu xanéhiko. Itea hara kíxovokoxoa Jesus: —Koati teyonéti ne xâne koyúhoti emo'u Itukó'oviti. Poéhane poké'exake yoko óvokuke, ako teyoâti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yoko vo'oku ákoyea akútipoa xanéhiko, ako axú'ina iyupánevoti ítuke ne Jesus xapákuke. ");
INSERT INTO terNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yaneko káxehiko, eyékoxoa Êrodi, enepone nâti, ákoyea malíka yónoku iháyu'ikeokono ne iha Jesus vo'ókuke neko ítuke. ");
INSERT INTO terNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ina kixôa Êrodi ne ko'itúkeinoatihiko: —Koatímea Xuaum Mbátita ne exepúkopone ukópea xapa ivokóvoti. Énomone ápeino xunáko itúkea ne iyupánevoti ítuke —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yoko kó'inokeneye isóneu vo'oku itúkeovo énomone pahukôa ne namukóponoati yoko ikavó'uxoponoati ne Xuâum yanekôyoke. Ínamaka kurikókono ika'ákovokutike. Yoko hara yuvâ, koati koyenópati Êrodi ne énomea koéhati Erôdiya, yeno Filípi, enepone po'inu Êrodi. ");
INSERT INTO terNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yoko kali êno sayá'ikeaku Xuâum vo'ókuke. Hara kíxoa: “Yane Ponóvoti Kixovókuti yútoe Muîse, ako omótova kéyenopi yeno pe'ínu” koéne. ");
INSERT INTO terNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kene Êrodi, mani kahá'ati koépekea Xuâum itea ako kaépeka vo'oku píkea ímaikea xanéhiko. Koati inixoâti heú koeti xâne itúkeovo porófeta koyúhoti emo'u Itukó'oviti ne Xuâum. ");
INSERT INTO terNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Simovóne kaxena ipúhikope Êrodi, ituko hána'iti ayuíti. Yane híyokexone ihíne ne Erôdiya nonékuke uhá koêti neko hupiúti yane ayuítike. Yupihovó koene ínixea Êrodi úhe'ekea. ");
INSERT INTO terNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hukinóvoti kíxea neko ihínexaka yusíkea itúkea épemone xokóyoke, vo'oku poréxeamo koêkuti âha épemone xokóyoke. Yoko koyúhoinoa nâti itúkeovo koati yuhôti neko yûho ákotinemo aukápapu ikéne. ");
INSERT INTO terNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ina kixôa ihínexaka: —Peréxanuikopo yâyeke tuti Xuaum Mbátita utókuke kó'oyene —kíxoane. Yoko enepone yûho, koati kuteâti páhoenoa êno épemea. ");
INSERT INTO terNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yane ikáxu'ine okóvo neko nâti kamoáne épemone ne ihínexaka. Mani kaha'âti ákoyeani itúkina neko épemone, itea vo'oku itúkeovo koati yuhôti neko yuhó'inoa, epó'oxo vo'ókuke neko xanéhiko xe'o mêsa húpiu, ene pahúkino poréxeokonoa ihínexaka ne épemone. ");
INSERT INTO terNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yane pahúkone tetunôponoti Xuâum ika'ákovokutike. ");
INSERT INTO terNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ina ominókonoa ârunoe ne tuti Xuâum utókuke. Yane kuríkoponoane ârunoe xoko êno. ");
INSERT INTO terNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ina pího íhikauhiko Xuâum veyóponea mûyo, ina ekoxóponoa. Ikénepoke, pihónehiko éto'okoponea Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Eyekóxoane Jesus neko koekúti, ipúhikopeane neko óvoheixoku koánemaka íhikauhiko. Hane yonópo mêum ákoyeaku xâne. Vatéke ivú'ixopo. Itea exeâne êno xâne neko yonópoku, ipúhikeane ne pitivóko úkohikeaku hokotíhiko Jesus. Poké'e vékohiko, huse'ó kixoâti ne xe'o úne. ");
INSERT INTO terNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Evesékeane Jesus ne vatéke, noixoâne neko êno xâne, yupihovó koene kóseanayea koane koíteovamaka ne ka'aríneti xapákuke. ");
INSERT INTO terNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kiyoné'e káxe, ahí'okovone Jesus ne íhikauhiko. Hara kíxoa: —Ako apêti yara vóvoheixoku, epó'oxo kiyóne káxe. Mani únati pehukâ pihópea ra êno xâne motovâti vanéxopeahiko kali nîka ya ipuxóvokutihiko vekópoku. ");
INSERT INTO terNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Itea hara kíxoahiko Jesus: —Ako okónoko pihópeahiko râ'a. Itínenoe parexâ nîka —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ina yumopâ íhikauhiko: —Itea enepora nikokónoti apêti yâyeke xoko ûti, poéhane kali singu koeti pâum yoko pi'âti hôe, koékune. ");
INSERT INTO terNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ina kixoáhiko Jesus: —Námane yâkeneye. ");
INSERT INTO terNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yane pahúkoane Jesus neko êno xâne ivátakea xapa ngaráma. Ina veyôa neko singu koeti pâum yóko'o neko pi'âti hôe, ina komômo vanúke ikoró'ixovoti xoko Itukó'oviti vo'ókuke ne nikokónoti. Yane ina hono'ékexoa ne pâum koane poréxea ne íhikauhiko pôrekexeamaka neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Uhá koéhiko níkea koane imátaxeovohiko. Ina itixópa íhikauhiko Jesus neko itátane nikokónoti haxâti, kopúhikopoikomaka nduse koeti sésta. ");
INSERT INTO terNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yoko kalíhanini itóponea singu koeti mili hóyeno neko nikôtihiko ákoti kayumákexapu senóhiko yoko kalivôno. ");
INSERT INTO terNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Koati ikénepoke nê'e, pahúkoa Jesus neko íhikauhiko ivú'ixopea vatékena koane inúxopinoa, yonotíhiko poixô'oke ne Mar-na Ngalíleya koêkuiko pahúkea Jesus pihópea neko êno xâne. ");
INSERT INTO terNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pihopónehiko, ina pího ne Jesus oúke neko kali mopôi itukóponoti orásaum pohúxovoti. Yaneko yotixóne, ôvoheixoakone póhuxeovo. ");
INSERT INTO terNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yoko ákone malika kukúke úne ne vatéke ivú'e ne íhikauhiko. Ákonemaka íyuhixapu ovóxokeovo neko úne koane amátitikopea ikéneke, ne vatéke vo'oku yupihovó koetíne xunáko ne ihunóvoti. ");
INSERT INTO terNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kaha'áne yúponiyea, ina pihinoâhiko Jesus yonó koeti inúkuke úne. ");
INSERT INTO terNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Noixónehiko yonôti inúkuke úne ne íhikau, hána'iti kónoko'iyeahiko. Koati yupihovó koeti píkeahiko, ina yaîko koane kó'iyeahiko: —Harakéne ipíkoti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Itea yanê'e, hara kíxovokoxoa Jesus: —Aúhepepone iséneu. Undíneye, hákonoe píke. ");
INSERT INTO terNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ina kixôa Pêturu: —Unaém, enepo itukápuxo îti, pehúkanumaka yóneam inúkuke úne, mbihôti xikóyoke —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Yókoneikopo —kíxoane Jesus. Ina evesékea vatéke ne Pêturu, yane yonónemaka inúkuke úne itôkopovoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Itea koeku yónea koane komómoyea neko êno xúnati ihunóvoti. Yane turíxovone píkea koane yúpuririkeovo. Ina koe vaúkea: —Yokótixonu Unaém —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ehá'axo vaúko ne Pêturu, namú kixópeane vô'u Jesus, ina kixôa: —Hoyenó, imáko itúkinovo kalîhuti ne kívivonu! Na koeti ákoino átiu'i ne iséneu kívivonu? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yane ûrukopovone Jesus yoko Pêturu kúveuke vatéke, koane má koépone neko xúnati ihunóvoti. ");
INSERT INTO terNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yane koati ihayú'ikoti Jesus ne íhikauhiko koane kó'iyeahiko: —Koati kaná'uti itíkivo Xe'exa Itukó'oviti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Taru'úxoane neko mar, simónehiko ya poké'exa Njenezâre. ");
INSERT INTO terNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yoko exó kixópono Jesus ne xanéhiko. Énomone kutí'inoke pahúkotihiko eyékoxoponoati uhá koêti ne ko'óvokutiya koáne yane ipuxóvokutihiko xêrerekuke. Yane omókono xoko Jesus ne uhá koeti xâne ka'aríneti. ");
INSERT INTO terNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Enepohikone omâti, épemohiko Jesus yusíkea pohu sipohí kíxea ka'arínetihiko ne heve ípovo. Yoko uhá koêti neko sipóheati, unátipohiko. ");
INSERT INTO terNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yane ápe farîzeu yoko éskiriba ukeâti ya Njeruzálem pihôti xoko Jesus. Hara kixóponoahiko: ");
INSERT INTO terNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Na koeti ákoino háka íhikeuhiko ne ihíkauvoti hó'e voxúnoekene? Vo'oku enepo nikohíko, ako kipáva'uxapu kuteâti kixoku kipóvo'uxeovo ûti, kuteâti páhoenovi hó'e ûti. ");
INSERT INTO terNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ina yumopâ Jesus: —Kene itínoe, ná'ikopo koeti itúkinovo kixoku itúkeovo yoxúnoekene héko ya koêkuni héki páhoenopi Itukó'oviti itíki? ");
INSERT INTO terNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Vo'oku hara koe páhoe Itukó'oviti nókone xâne itúkea: “Tiyánoe yá'a koane yêno” kôe. Ina koe'íkomaka: “Konókoti koépekeokono ne vaheréxinoti yuhó'ino há'a, áko'o itukovo êno” koémaka. ");
INSERT INTO terNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Itea koati ihíkexotinoe xanéhiko yusíkea kíxea ne há'a yoko êno itúkeovo poréxoke Itukó'oviti ne tiûketi mani huvó'oxeake ne há'a yoko êno. ");
INSERT INTO terNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yane kuteâti kixeku íhikexi, koati ákotihiko teyâ ne há'a yoko êno ya koeku ákoyea kátaraka. Yanê'e, ákone itíkoake ne emo'u Itukó'oviti vo'ókuke ne kixoku itúkeovo yoxúnoekene íhikexone. ");
INSERT INTO terNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Itínoe ikútixapovoti sasá'iti ya po'ínuhiko xâne, koati tokopóvoti neko yuho porofeta Izâiya mekúke ve'ókukenoe, enepone koêti: ");
INSERT INTO terNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Enepora xanéhiko, pohu koyuhó kixo téyeonu itea ya isóneuke, ako malíkanuhiko. ");
INSERT INTO terNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Koati hokohí kixónuti, ihíkaxotihiko ihíkauvoti ainóvoti isoneú kixone xâne” kôe —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ina ihaxíkoa Jesus neko êno xâne. Hara kíxovokoxoa: —Yakámokenonu maka yéxinanoene iséneu ra yûnzo: ");
INSERT INTO terNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Haina koekúti urúkovoti pahákuke xâne ikopíti'ikoa, itea enepone ipuhíkeati pahákuke hainápo, énomone ikopíti'ikoa —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ina ahi'ókovo Jesus ne íhikauhiko. Hara kíxoa: —Yéxoa yupíheovo ikótivexea farîzeuhiko ne yihómeku? ");
INSERT INTO terNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ina yumopâhiko Jesus itukínoatihiko íhixoake: —Uhá koeti nonéti ákoti itukapu none Nzá'a íhae vanúke, marekéxokonotimo. ");
INSERT INTO terNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hako itíkoake nekôyohiko vo'oku koati ainóvotihiko xâne komítiti, hiríkotimaka po'i komítiti. Yoko enepo hirîko komítiti ne po'i komítiti, heú koetímo ne pi'âti íkorono'ekeovo uhorókuke. ");
INSERT INTO terNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ina kixôa Pêturu: —Keúhapu'ikinavea kixó'ekone íhekoake ne yihómeku. ");
INSERT INTO terNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ina kixovókoxoamaka Jesus: —Ákonoekopomaka yéxa kixó'ekone? ");
INSERT INTO terNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ákoikopo yéxanoe koêku ne uhá koeti urúkovoti pahákuke xâne? Koati yonoti xoko íhaku nîka ina ipuhíkopomaka. ");
INSERT INTO terNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Itea enepone ipuhíkeati pahákuke, koati isóneuke úkea. Yoko koati énomone ikopíti'ikoa ne xâne. ");
INSERT INTO terNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vo'oku koati isóneuke xâne úkea ne váherehiko âha itúkea, kuteâti kahá'ayea koépekea yoko aúpu'ikea yêno áko'o itukovo îma, kapíneti ákoti itukapu koati múxone. Koati isóneukemaka úkea kahá'ayea koyenohí kó'iyea, koane ko'imahí kó'iyea, yoko oméxea, koane itúkoheyea koeku po'ínuhiko xâne, yoko ihéki po'i xâne. ");
INSERT INTO terNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Koati énomone ikopíti'iko xâne, kene haina koekúti kuteâti ákoyea kipáva'uxapu enepo níko —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yane ipúhikopeane Jesus neko óvoheixoku. Hane yóno ya poké'e xe'ókuke ne pitivókohiko koéhati Tîru yoko Sîdom. ");
INSERT INTO terNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yoko ápe seno kanáneya, ko'óvokuti yaneko poké'e óvoku xanéhiko ákoti itukapu jûdeu. Enepone sêno, pihóne vá'uixea ikéneke Jesus. Hara koe yûho vaúkea: —Unaém, iti ámoripono Ndávi, yokóseananu. Ápe inzíne yupihóvotine ákoyea aúnati vo'oku ndémoniu urúkovati —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Itea ako yumápa Jesus. Ina ahi'ókovo Jesus ne íhikauhiko koane kíxea: —Mani únati pehukâ pihópea ne sêno hokó'ixoviti, vo'oku vímaxovane vá'uixea vikéneke —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ina kixôa Jesus neko sêno: —Ako po'i mbahúkinokonoke ákoti itukapu nzuvó'oxoponea xanéhiko íhae Izarâe, enepone kutí koeti su'ûso moyóniti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yane ipuyuké koéponone ne sêno poké'eke nonékuke Jesus koane kíxea: —Hivá'axanu Unaém. ");
INSERT INTO terNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ina kixôa Jesus ne sêno: —Ako yusíka véyeokono itátane pâum nika xe'éxaxapa ne koati ko'óvokuti, ina parexákana ne kálihunoe tamúku —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yane ina yumopâ sêno: —Kaná'uteoxo Unaém, itea enepone kálihunoe tamúku, níkoamaka ne íhone nikokónoti irikóvoti opékuke mesana únae. ");
INSERT INTO terNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ina kixôa Jesus: —Senó, koati hána'iti ne kívivonu. Ákoeneye kuteâti koêku ne yâha —kíxoane. Énomone yanê'e, unátipone ihíne neko sêno. ");
INSERT INTO terNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ipuhíkopeane evo Jesus neko óvoheixoku, aúkopovo xe'ókuke ne Mar-na Ngalíleya. Pihónehiko oúkeke kali mopôi, ina ivatáko ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Énomone yanê'e, koati ênoti xâne pihinoâti, ominoâti xâne mohéveu koane xâne isayú'ixovoti poixo'o mûyo, koane komítiti yoko mókere, koane ênotimaka po'ínuhiko ka'aríneti. Ípihokononehiko poké'eke nonékuke Jesus koane koíteovahiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yane yupíhova iyúpaxeova xanéhiko noixópanehiko ne mókere koyúhopea koáne ne isayú'ixovoti poixo'o mûyo unátipea, koáne ne mohéveu yonópea yóko'omaka ne komítiti ínixopeane. Yane êno iháyu'ikeahiko Itukó'oviti, enepone kutípone íhae Izarâe, vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ina ihaxíkoa Jesus ne íhikauhiko. Hara kíxovokoxoa: —Ngóseanane ra xanéhiko vo'oku ákone nikokónoti nikáhiko. Yoko mopó'apene káxe óvoheixohiko njokóyoke kó'oyene. Ako angáha'a pahú ngixópea pihópeahiko ákoti níka, mará'inamo íkarakahiko hímakati xenékuke —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ina kixôa íhikauhiko: —Ná'ikopomo vínixoponea pâum yara mêum ákoti apêti motovâti imátaxeovo ra êno xâne? ");
INSERT INTO terNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ina kixovókoxoa Jesus: —Ná'ikopo yé'aye pâum apêti xepákuke? —Seti kôe, yoko kali ye'á koeti kálihunoe hôe —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yane pahúkoane Jesus neko xâne ivátahikea poké'eke. ");
INSERT INTO terNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ina veyôa ne seti koeti pâum yóko'o ne hôe, ina ikoró'ixovo xoko Itukó'oviti. Yane honó'ekexoane, ina porekéxoa ne íhikauhiko pahukoâti pôrekexeamaka neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Uhá koe níkea koane imátaxeovohiko. Ina itixópa íhikauhiko Jesus itátane neko nikokónoti haxâti, kopúhikopoikomaka seti koeti sésta. ");
INSERT INTO terNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yoko koaturu koe mili hóyeno neko nikôti ákoti kayumákexapu senóhiko yoko kalivôno. ");
INSERT INTO terNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yane pahúkoane Jesus pihópea neko êno xâne. Ina urúkopova ne vatéke yonópoti íyeu pitivóko koéhati Magádam. ");
INSERT INTO terNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yane pihóhiko xoko Jesus ne farîzeu yoko sadúseu oposí'okoponovoti Jesus, epemoâtihiko itúkea iyupánevoti, hoénaxovope itúkeovo xoko Itukó'oviti úkea xunáko. ");
INSERT INTO terNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ina kixovókoxoa Jesus: —Itukovo ínati hâraramo vanúke ya íyeu kíyo'i káxe, hara kénoe: “Únatimo káxe ihâroti vo'oku ina hâraramo vanúke” kénoe. ");
INSERT INTO terNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Koane itukovo ya yuponii koêti, “Kevotímo úko, vo'oku ina hahá'i hâraramoyea” kénoe. Kemomónoe vanúke, yéxoa kéveamo, áko'o áko'oyeamo úko yaneko káxe, itea ákonoe yéxa koêku ne koekútihiko exókoveati koêku ra káxehiko símokune ûti. ");
INSERT INTO terNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Koati ákotinehiko aunáti ra xâne yara káxehiko símokune ûti kó'oyene. Ákone yuíxapuhiko itúkea ahá'inoa Itukó'oviti, épemoikomaka noíxea iyupánevoti índukeinoa. Itea ákomo ápahuina iyupánevoti noíxonehiko ákoti itukapu kuteâti koêku xoko Njóna mekúke —kíxovokoxoane Jesus. Yane pihópeane. ");
INSERT INTO terNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yane tarú'uxoane Jesus yoko íhikauhiko poixô'oke ne mar. Yoko inótovone okovo ómea pâum ne íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ina kixovókoxoa Jesus: —Neíxapunoe, yokóhiyanavoa ne kutí koeti kohiyákopeti pâum ánahixope evo farîzeu yoko sadúseu —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yane turíxovone yúho'ixeokoko ne íhikau vo'ókuke. Hara kixókoko: —Koatímea vo'oku ákoyea vama pâum kó'inoneye yuhó'inovi —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yoko exó kíxea Jesus ne isóneuhiko. Énomone kíxovokoxinoa: —Na koeti ixómoinonoe yího'ixokoko vo'oku ákoyea pâum yómonenoe? itínoe hóyeno ákoti koâti kúveovonu. ");
INSERT INTO terNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Âvonoe yéxina iséneu? Inótovanenoemea yokóvo ne singu koeti pâum koimátaxoti singu koeti mili hóyeno, koánemaka neko yé'akeye sésta kepúhiupo yane haxâtihiko? ");
INSERT INTO terNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ákonemaka puyákapanapanoe yokóvo neko seti koeti pâum, níngaxeake neko koaturu koeti mili hóyeno koane yé'akeye sésta kepúhiupo itixépoanoe neko haxâti? ");
INSERT INTO terNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ákonoe yéxa ákoyea itúkapu koati pâum ne ngíxo? Itea hara ngixópinoe: Yokóhiyanavoa ne kutí koeti kohiyákopeti pâum ítuke evo farîzeu yoko sadúseu —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yane ínati exoâhiko íhikau Jesus ákoyea itúkapu koati kohiyákopeti pâum kónoko kóhiyanayeova, itea itúkeovo ihíkauvoti, íhikau evo farîzeu yoko sadúseu kixínoa Jesus, enepone ákoti oríko ukóponea xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ya koeku píhea ne evo Jesus ya íyeu pitivóko koéhati Sezâreya óvoku natíxea Filípi, hara kixo íhikauhiko: —Kutimea íkutixanu ra xanéhiko, undi íhae vanúke ikútipasikoponovoti xâne? ");
INSERT INTO terNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ina kixôa íhikauhiko: —Ápe koyuhoâti itíkivo Xuaum Mbátita iyukópovotine. Kene po'ínuhiko, koyúhoa itíkivo Îliya iyukópovotine. Kene po'ínuhiko, koyúhoa itíkivo Njerémiya, áko'o po'ímea porófeta koyúhoti emo'u Itukó'oviti mekúke iyukópovotine —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Kene itínoe, kuti keyúho indúkeova? ");
INSERT INTO terNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ina kixôa Simaum Pêturu: —Iti Mésiya, enepone páhoe Itukó'oviti koíteovo xâne. Iti Xe'exa koati kaná'uti Itukó'oviti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ina kixôa Jesus: —Koâti únati kêku Simaúm, iti xé'a Xuâum, vo'oku haina xâne yara poké'e kouhápu'ikinopea itea koati Nzá'a íhae vanúke kouhápu'ikinopea. ");
INSERT INTO terNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Haramaka ngixópi: Iti Pêturu. Yoko enepora yiuhómeku vo'ónguke, kutí koe mopôi poéheve péti, poéhevemakamo kutípone ne uhá koeti xâne hokónutimo ya nandíxoku injíkonemo yara poké'e. Yoko ákomo itoâti uké'exea muhíkova Satánae yoko uhá koeti ovóxe. ");
INSERT INTO terNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mborexópitimo keyúhoyi ne ihíkauvoti ínzikaxeopikenoe, enepone kutí koeti xáve poréxoti xâne ûrukeovo natíxokuke Íhae Vanúke. Koêkuti yexéxone yâye yara poké'e, kúteanemakamo koêku ya vanúke. Koane koêkuti míhi'oe yâye yara poké'e, kúteanemakamo koêku ya vanúkeke. ");
INSERT INTO terNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ina ixikó'oko íhikauhiko ákoyea koyúhoinoake itúkeovoxo Mésiya, páhoe Itukó'oviti koíteovo xâne. ");
INSERT INTO terNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ukeátine neko káxe, turíxoane Jesus Kristu koúhapu'ikinoa ne íhikauhiko kixókonokumo tumúneke. Hara kíxovokoxoa: —Ngónoko yóneam ya Njeruzálem koane íngoitoponeokonomo kotíveti vo'oku ákoyea tôpi váhere ítukeinonumo tutíhiko viyéno jûdeu, koánemaka ne payásotihiko sasedóti inuxínoti xanena ûti hó'eke, yóko'o ne ihíkaxoti yútoe Muîse, enepohikone éskiriba. Koepékonutihikomo itea ya mopó'apeke káxe ikéne, enjepúkopotinemo ungópea xapa ivokóvoti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yane ahikú kixone Jesus ne Pêturu, ina kixôa ákoyea yusíka kó'iyeaneye kuteâti koêku ne yûho. Hara kíxoa: —Ákomo síka Itukó'oviti kó'iyeaneye. Ákomo kalíhuina kíxikononeye Unaém. ");
INSERT INTO terNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ina inonéxinovo Pêturu ne Jesus xaneâti kíxea: —Yahíkuxipunu Satanaé. Iti kutí koeti pú'iti mopôi onjéneke mani ikorókonuti, vo'oku haina ukeâti xoko Itukó'oviti ne iséneu, itea koati kixoku ko'ísoneuyea xâne yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ina kixôa Jesus ne íhikauhiko: —Enepone kahá'ati hókeonu, ako yusíka yuíxeovo koúhepekea kóyeku yara kúveu mêum. Konókoti hókeonu ya usó koyêti ínonexinovo tiú'iti koekúti kuteâti koeku xâne koinópoti kurúhuna iyonókonone xoko kurúhuxokonoku. Yane kená'akane ingéneke. ");
INSERT INTO terNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Vo'oku enepone xâne yuixóvoti koúhepekea kóyeku yara kúveu mêum, evókoatimo ne mani unako koépoku xoko Itukó'oviti. Itea enepone xâne usó koyêti évokea úhepeko kóyeku yara kúveu mêum vo'ónguke, énomonemo unatî koépoku xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kutí'ikopo itópoino xâne ápeinoa uhá koeti únatinoe koekúti yara kúveu mêum itea evókoti mani unako koépoku xoko Itukó'oviti? Ápeikopomea koekúti yara kúveu mêum motovâti ko'ésa'iyea mani unako koépoku xoko Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yoko aungópovotimo yara kúveu mêum, undi íhae vanúke ikútipasikoponovoti xâne, epó'oxo yaneko káxe, iyúseotimo indúkeovo êno hána'iti ihayú'iuti kuteâti koeku Itukó'oviti Nzá'a. Xané ngixópotinemo ovónje, ánjuhiko íhae vanúke. Yane ínamo ongoyúho námoepo póhutihiko xâne. Yoko kixoku itúkeovo póhutihiko xâne exoâmo ne námoepo. ");
INSERT INTO terNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Koati emo'úti ra yunzó'inopinoe: Anéye xâne xepákukenoe âvotimo ivakápu koeku âvoyea naíxanu indúkeovo hána'iti ihayú'iuti nandixáne, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sei koe káxe ikénepoke, xánea Jesus ne Pêturu yóko'o neko pi'âti kopo'ínukokoti, Teâku yoko Xuâum oúke koati hána'iti mopôi. Yoko ainóvotinehiko, ákoti po'ínuhiko xâne xapákuke. ");
INSERT INTO terNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ina ipokóvo koêku ne Jesus nonékukehiko. Ú'uhapu'i-ú'uhapu'i koéne ne nône. Kutí koéne uhá'iko káxe. Kúteanemaka koêku ne ípovo, hóhopu-hóhopu kóyene kuteâti koeku xúnati uhapú'iti. ");
INSERT INTO terNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yane apé kó'inoanehiko Muîse yoko Îliya, enepohikoneko koyúhoti emo'u Itukó'oviti mekúke, yuhó'ixoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ina kíxo Jesus ne Pêturu: —Unaém, koati únati vápeyea yâyeke. Enepo yakahá'a, indúkotimo mopo'âti kálihunoe péti hú koeti yâyeke. Poéhamo ítike, poéhamo ítuke Muîse, koane poéhamo ítuke Îliya —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ixómoiko koyûho ne Pêturu, apé koene kapási êno ú'uha koyêti rama'úxoatihiko, inú'ixoku emo'úti koêti: —Énomone Nje'éxa râ'a, ákoti omotóva ongóvo, porexónuti hána'iti elókeko ongóvo. Yakámokenoyinoe yûho —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kamoáne íhikauhiko neko emo'úti, yupihovó koéneoxo píkea. Xovokuké koéne íkorohikeovo poké'eke. ");
INSERT INTO terNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ina ahi'ókovahiko Jesus ipíhoa vô'u xokóyokehiko koane kíxea: —Yexépukapa. Hákonoe píke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ina noiméxohiko, áko'oponehiko neko po'i noíxone. Poéhapoane Jesus noíxo. ");
INSERT INTO terNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Koeku ukópeahiko oúke neko hána'iti mopôi, hara koe ixíko'okoakehiko Jesus: —Hákoxovonoe yetó'oko po'i xâne koêku ra neíxone kó'oyene imókonemo enjepúkapane ungópea xapa ivokóvoti, undi íhae vanúke ikútipasikoponovoti xâne —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ina kixôa íhikauhiko: —Ná'ikopo koeti koyúhoinoa éskiriba, enepohikone ihíkaxoti yútoe Muîse, kónokea itúkeovo Îliya ne inuxómo sîmo? ");
INSERT INTO terNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ina yumopâ Jesus: —Kaná'uteoxo símeane Îliya inúxotike kóyuseyea uhá koêti. ");
INSERT INTO terNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Itea koati ngixópitinoe símeane ne Îliya, itea ako éxa xanéhiko itúkeova, koane itúkinoahiko uhá koêti neko váhere âha itúkinoa. Énomonemakamo kixónuneyehiko íkoitoponeonu kotíveti, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yane éxoanehiko íhikau Jesus itúkeovo Xuaum Mbátita kíxo yane yuhó'inoahiko. ");
INSERT INTO terNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yane koeku káyukopeovo evo Jesus xapákuke neko êno xâne, apé koene hóyeno ahi'ókovati ne Jesus. Yane ipuyuké kó'iyeane nonékuke koane kíxea: ");
INSERT INTO terNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Unaém, yokóseana nje'éxa. Akó'oti aunáti tûti, pepokehí koêti. Koati yupihóvotine koítoponeovo kotíveti vo'ókuke. Enóne íkoroukeyeovo yúku áko'o itukovo ikoróno'ekovoti úneke. ");
INSERT INTO terNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ómanem xoko íhikeuhiko itea ako íta koíteova. ");
INSERT INTO terNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ina kôe ne Jesus: —Imáko itúkinovo tiú'iti kutípea koane váhere ra xanéhiko yara káxehiko kó'oyene. Ná'ikopomeamo hunóko óvonzeixea xepákukenoe? Ná'ikopomeamo nzunóko índea ákoyeanoe yakútiponu? Yáma yâkeneye ne homoêhou —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yane pahúkoane Jesus ne ndémoniu ipúhikopea xokóyoke. Koáne, ipúhikopeane. Énomone yaneko ókoku ôra, unátipone ne homoêhou. ");
INSERT INTO terNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ikénepoke, ina ahi'ókovo Jesus ne íhikauhiko koeku ákoyea po'ínuhiko xâne xapákuke koane kíxeahiko: —Na koeti ákoino víta kópuhikopea ûti ne ndémoniu? ");
INSERT INTO terNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ina kixovókoxoa Jesus: —Vo'oku yupihovó kó'iyea kalîhuyea ne kívivonu. Koati emo'úti ra yunzó'inopinoe: Enepone kívivonu, muhíkovani akutêa itóvoku kalîhuko ake nonéti, enepone mostarda, mani motovâti pehúki ahíkuxeovo xoko óvoku ne koati hána'iti mopôi pihópea po'íke. Koáne, mani ipokóvoti. Eneponi akoéneye kívivonu, ákoni ápahuina koekúti ákoti keusákinakana. ");
INSERT INTO terNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Itea enepora kó'iyeovoku ndémoniu, ako kopúhikopati ákoti itukapu ya orásaum koáne ya jejuá kó'iyea) —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yanekôyoke koeku ho'úxeovohiko ya Ngalíleya, hara kíxovokoxoa Jesus ne íhikauhiko: —Yé'exovone ngurí'okeokonokumo xunako xanéhiko, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yane ínamo kaepékanuhiko, itea mopó'apeke káxe ikénepo, enjepúkopotinemo ungópea xapa ivokóvoti —kíxovokoxoane. Yane yupihovó koénehiko ikáxu'iyea okóvo ne íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Simoné'e ne Jesus yoko íhikauhiko ya pítivokona Kafanâum, simino Pêturu ne koperáxotihiko tiûketi, nókone jûdeu poréxea, iko'ítukeuti ya témpulu, enepone hána'iti imokóvokuti. Hara kixóhiko Pêturu: —Enepone ihíkaxopitinoe, ako parexa tiûketi iko'ítukeuti ya témpulu? ");
INSERT INTO terNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Êm, poréxoa —kíxoane Pêturu. Ehá'axo ûrukovo ne Pêturu óvokuke, tumuné koéne koyúhoinoa Jesus koêku, âvoti yuho Pêturu etó'okoati. Hara kíxoa Jesus: —Simaúm, na kó'inoaye iséneu? Enepohikone nâti yara poké'e, enepo koperáxohiko, kuti konokôa poréxea, xanéna? áko'o íhae po'i poké'e ákoti itukapu xanéna. ");
INSERT INTO terNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ina kixôa Pêturu: —Hane konokôa poréxea íhae po'i poké'e. Yane hara kíxoa Jesus: —Iyúseoneikopo ákoyea okónoko poréxea ne koati ko'óvokutihiko íhae ne poké'e. ");
INSERT INTO terNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Itea mará'inamo ópoe'ainovi isóneu ne koperáxotihiko, pîhe xe'ókuke úne ya mar ínamo kirîka nímikuna. Enepone inúxoti hôe itéponemo, míhi'akimo pâho. Yane inixéponotimo póhuti pe'u tiûketi pahákuke ne hôe, ínamo píhe peréxopoinonu nóngone mboréxea koánemaka nékone peréxopi —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Énomone yaneko ókoku ôra, ahí'okovo Jesus ne íhikauhiko. Hara kixóhiko Jesus. —Kuti itukóvo koâti payásoti ya xapákuke xâne natíxoku ne Íhae Vanúke? ");
INSERT INTO terNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ina ihaxíko kalivôno ne Jesus imôa nonékukehiko ");
INSERT INTO terNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ina kôe: —Koati emo'úti ra yunzó'inopinoe: Enepomo hákoti ipokóvo ne kixeku itíkivo, koane hákoti ikítipasikovo kálihunoe kalivôno, ákomo kalíhuina yûrukopivo natíxokuke Íhae Vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Itea enepone ákoti kapayásakapu kuteâti koêku ra kalivôno, énomone itukóvoxo koâti payásoti xapákuke xâne natíxoku ne Íhae Vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Koêkuti ivavákoati kuteâti ra kalivôno njokóyoke koane itukínoati únati, undímaka kixóneye —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ina koe'íkomaka: —Koêkuti xâne vaheréxoti ítuke itávokinoke hókeonu ne póhuti xapákuke ra kálihunoe kutipónuti, yusikóneni iká'akeokono êno pú'iti mopôi anúkuke tumúneke koésayu'ixea isoneu po'i xâne, ínani kuriná'ekakana upénoyeaku úne xoko mar, maka hákone koesáyu'ixea isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kotíveti koêku ra xanéhiko yara kúveu mêum vo'ókuke ne koekúti kopoé'akeati isóneu itopâti kutípeonu. Koati kóyekutinemo ápeyea koekúti kuteâti, itea koâti kotívetimo koêku ne xâne kixotíneye po'ínu. ");
INSERT INTO terNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—Énomone ngixínopinoe: Enepo itukapu veô'u áko'o hîvi váherexino ítike, yusikóneni titúki koane kiríki ákotike malîka, motovâti ákoyea váherexa ítike. Mani unatíne ákoyea poixo'o veô'u, áko'o poixo'o hîvi yenópi vanúke yaneko usokó kó'iyea veô'u, áko'o hîvi itea kirikópokonoti ipihóponovokutike xapa yúku ákotinemo ípukeovoku. ");
INSERT INTO terNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kúteanemaka koêku itukapu yûke váherexino ítike. Yusikóneni meréki koane kiríki ákotike malîka, motovâti ákoyea váherexa ítike. Mani unatíne yenópi vanúke ákoti poixo'o yûke, yaneko usokó kó'iyea yûke itea kirikópokonoti ipihóponovokutike xapa yúku ákotinemo ípukeovoku —kíxovokoxoane Jesus, exókoatihiko kónokea ákoyea íyuhixapapu sayá'ikopeova ne váhere ítuke. ");
INSERT INTO terNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ina kixovókoxopaikomaka Jesus: —Muhíkova póhuti xapákuke ne kálihunoe kutipónuti, hako ikitíxa ákoti itúkovoke, vo'oku koati ngixópitinoe itúkeovo xoko Nzá'a íhae vanúke óvoheixo ne ánjuhiko koyonoâti ne kálihunoe kutipónutihiko. ( ");
INSERT INTO terNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Vo'oku hane nzimíno ngoíteova ne xâne pahukóvoti, undi íhae vanúke ikútipasikoponovoti xâne.) ");
INSERT INTO terNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—Na kó'inoaye iséneu? Itukovo apêti hóyeno póhuti séndu su'úsona, ínani omoyóni póhutiya, ákonikopomea kurí íxahiko oúke kali mopôi ne noventai nove koêti koeku opósikoponea neko póhuti moyóniti? ");
INSERT INTO terNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Koati ngixópitinoe: Inixápanane, yupihóvotimo elókeko okóvo vo'ókuke ne póhuti kovú'e yane po'ínuhiko noventai nove koeti ákoti omoyóni. ");
INSERT INTO terNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Énomonemaka koéneye ne Yá'a íhae vanúke ákoyea akáha'a évokeovo póhuti yara kálihunoe kutipónuti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ina koe'íkomaka: —Enepo vaheréxa ítukeinopi ne po'inu xâne, pihínea yéxokoponi pahúnevo pi'eátinenoe ákoti po'i xâne xikóyokenoe. Enepo akamókenopi, itepoâtimo keúnatikopi isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Itea enepo hákoti kahâ'a kámokenoyeopi, yusikóne yaúkinova xeneti póhuti, áko'o itukovo pi'âti xâne motovâti iyúseyeaxo ne koekúti koeku pí'ayea, áko'o mopó'ayea noixoâti, motovâtimaka koyúhopea koêku. ");
INSERT INTO terNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yane enepo hákoti kahâ'a kámokenoyea xené'inoake, yáma ne koekúti nonékuke po'ínuhiko xâne ya imokóvokutike. Yane itukovo kóyekutine ákoyea akáha'a kámokenoyea isóneunoa xanéhiko imokóvokutike, kutí íxepane xâne ákoti êxa Itukó'oviti, koane kutí íxepanemaka kuteâti koperáxinoti nâti, enepone ákoti oponóvo ítuke. ");
INSERT INTO terNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Koati emo'úti ra yunzó'inopinoe: Uhá koeti koêkuti seyá'iumo yara poké'e, kúteanemakamo koeku vanúkeke. Koánemaka ne síkenemo yâyeke yara poké'e, kúteanemakamo koeku vanúkeke. ");
INSERT INTO terNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","—Koati emo'úti ra yunzó'inopinoe: Itukovo apêti yâye yara poké'e pi'âti xâne xepákuke kutikokó koinoâti isóneu ne âha épemea ya orásaum, kousókinoatimo Nzá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Koeku ápeyea pi'âti áko'o mopo'âti xâne ho'uxínovoti itúkea orásaum ya inzáke, anêngomakamo xapákukehiko —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yane ina ahi'ókovo Jesus ne Pêturu. Hara kíxoa: —Unaém, enepo vaheréxa ítukeinonu ne mbo'ínu, namo yé'aye ixómoyea ngóseanapoa, kutí ngixopâti ákoti vaheréxinanu ítuke? Seti koetímeamo? ");
INSERT INTO terNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ina kixôa Jesus: —Ako yusíka itúkeovo pohu seti koêti késeanapoa, itea hara ngixópi setenta koetimo seti. ");
INSERT INTO terNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Vo'oku enepone natíxea ne Íhae Vanúke xapa xâne, hane koéneye nâti komomópoti yé'akeye orévexoake ahínoehiko. ");
INSERT INTO terNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Turixoâne ne ítuke, omínokonone po'i ahínoe koâti yupihóvoti orévexoake ovâti ênoti mili tiûketi. ");
INSERT INTO terNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yoko koati ákoti tiûketina mani poréxopeake neko oréveu. Yane pahúkoane pátarauxa kaváneyeokono neko ahínoe, koane yêno, xe'éxaxapa yoko uhá koeti apeínoati, motovâti isúkopeovo neko oréveu. ");
INSERT INTO terNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yane ipuyuké koéne neko ahinoêti nonékuke pátarauxa. Hara koéne: “Yokóseananu, kali kuxoo íxenuvo, vo'oku kóyeanemo mboréxopeopea uhá koêti ne orévenjopike” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—Yane yupihovó koéne kóseanayea pátarauxa neko ahínoe. Yane pahúkoane pihópea koane ákoyeane káperaxapa neko orévexoake. ");
INSERT INTO terNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pihopóne neko ahinoêti, tokononé koene ha'íne ko'ítukeyea orevéxoati kali póhuti séndu pe'u tiûketi. Yane kóperaxoane. Namú kíxeane ánu kotitínoati. “Peréxapana ne yorévexonuke” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—Yane ipuyuké kó'iyeane neko ha'íne nonékuke. Hara kíxoa: “Yokóseananu, kali kuxoo íxenuvo, vo'oku kóyeanemo mboréxopea ne orévenjopike” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—Itea ako kali kaha'á íxa. Yane kuríkoponoane ika'ákovokutike tukú koeti isúkopea neko orévexoake. ");
INSERT INTO terNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Enepohikone po'i ahinoêti ha'íne ko'ítukeyea, noixoâne neko koekúti, yupíhova ikótivexea isóneuke. Úkeane pihohíko éto'okoponea ne pátarauxa. Uhá kíxoa koyúhoinoa ne koekúti. ");
INSERT INTO terNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ina ihaxíkoa pátarauxa neko ahínoe. Hara kíxoa: “Koati iti váhere ahinoêti! Koseaná ngixópipepo. Ako ngáperaxapapea neko yorévexonuke vo'oku yépeminu ngóseanayeopi. ");
INSERT INTO terNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mani konokoâtimaka késeanayi ne he'íne orevéxopiti kuteâtimaka ngixópiku ngóseanayeopi” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","—Yane yupihovó koene ímaikinova pátarauxa, ina pahukôa iká'akeovo koane kurí'okeokono, ikoítoponoati kotíveti tukú koetímo parexápa neko orévexoake —koéne ne Jesus ");
INSERT INTO terNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ina koe'íkomaka: —Énomonemakamo kixópinenoeye ne Nzá'a íhae vanúke enepomo yunakâ iséneuke ne váhere ítukeinopi pe'ínu hákotimo keseánapoa —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Uke'éxone koyúhoyea ne Jesus, ipúhikopeane Ngalíleya yonópoti Njúdeya poixô'oke húveona Njôrdaum. ");
INSERT INTO terNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Koati ênoti xâne hokó'ixoati koane koíteova Jesus ne ka'arínetihiko xapákuke. ");
INSERT INTO terNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ápemaka farîzeuhiko, enepone yuixóvoti hókea yútoe Muîse pihinoâti oposí'okoponovati. Ina epemó'ikohiko Jesus kaha'aînoati pahúkeovo ya yumópope. Hara kíxoahiko: —Motóva kuríkea yêno ne hóyeno ya uhá koêti koêkuti évotikoake? ");
INSERT INTO terNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ina yumopâ Jesus: —Ákoikopo yíhoikiku emó'uke Itukó'oviti koyuhoâti koêku inâ itukôa Itukó'oviti ne xâne itúkeamaka hóyeno yoko sêno? ");
INSERT INTO terNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ina koemáka: “Énomone kuríkino há'a yoko êno ne koyénoti motovâti komúxoneyea yêno. Yane koati póhutipone ne pi'âti” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ákone apí'a, koati póhutipone. Koeku koyúhoyea Itukó'oviti poéhapeane ne pi'âti, ako yusíka ápeyea xâne haxakópati —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yane ina kixôa farîzeuhiko: —Ná'ikopo koeti ápeino yútoe Muîse koyúhoti yusíkea kuríkea yêno ne hóyeno, koane poréxea koyuhópeti kotuyôpeati îha itúkeovo koyenókokoti? ");
INSERT INTO terNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yane hara kíxoa Jesus: —Poréxinopeakenoe Muîse kiríki yîno vo'oku tiú'ikonoe yomíxone. Itea yaneko inúxotike inâ apê ra mêum, ako yusíka kuríkeokoko. ");
INSERT INTO terNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hara ngixópinoe vo'ókuke: Enepone kuríkoti yêno ina okoyénopomaka, ákoti itukapu vo'oku itúkeovo aupú'ikoati yêno yuhó'ixoti po'i hóyeno, ya xoko Itukó'oviti, koati pahukóvoti nê'e, koane koati aupú'ikoti inúxoti yêno. (Koánemaka ne koyenópati ne kûrene îma, ya xoko Itukó'oviti, kutí kôe aupú'ikeati inúxoti îma ne sêno.) ");
INSERT INTO terNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ina kíxo Jesus ne íhikauhiko: —Koeku kó'iyeaneye, yusikóneikopo ákoyea okóyenokoko ne xâne. ");
INSERT INTO terNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yane hara kíxovokoxoa Jesus: —Haina hi'imé koeti xâne itoti ákoyea okóyeno. Poéhane itôa ne xâne poréxone Itukó'oviti kó'iyeaneye. ");
INSERT INTO terNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ápe hóyeno ákoti okoyéno vo'oku omeátinekeneye inâ ipuhíko ápeyea isáyunevo ákoinoke omótova kóyenoyea. Ápemaka hóyeno kapáxovoti. Kene po'ínu, kaha'âne ákoyea okóyeno motovâti yuíxeovo koúkoponea natíxea Íhae Vanúke xapa xâne. Koêkuti eopâti isóneuke ítea kó'iyeaneye, ene itukâ kuteâti ra yûnzo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yane ápe xâne omotíhiko kalivôno xoko Jesus motovâti ípihea vô'u tutíkuke, itea sayá'ikoa íhikauhiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ina kôe ne Jesus: —Síkeane kenó'okea ne kálihunoe kalivôno njokóyoke. Hako seya'íkoa, vo'oku kuteâti koeku usó kóyeyea kenó'okinonu râ'a, énomonemaka kónoko kó'iyeaneye ne xâne yonópoti natíxokuke Íhae Vanúke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yane ípihoane ne vô'u tutíkukehiko. Úkeane pihôpo. ");
INSERT INTO terNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yane apé koéne xâne ahi'ókoponovoti Jesus. Hara kíxoa: —Ihikaxotí, kuti itukóvo únati koekúti nóngone indúkea motovâti ómbea xoko Itukó'oviti ákotinemo hunókoku? ");
INSERT INTO terNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ina kixôa Jesus: —Ákoikopo yéxa itukóvotiye ne koati únati? Enepone koâti únateoxo, poéhaxo, ako po'ínu. Yakaha'a ákoyea hunókoku yópi xokóyoke, itíka ne páhoenopi Ponóvoti Kixovókuti yútoe Muîse nékone itíki —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Kuti itukóvoye xapákuke neko yutoéti? —koéne neko hóyeno. Yane hara kíxoa Jesus: —Enepone koêti: “Hako kepéko. Hako yaupú'iko po'i xâne kepiné'iyiti yêno. Hako yomêxo. Hákomaka itikóheo koeku po'i xâne. ");
INSERT INTO terNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tiya yá'a yoko yêno. Koane hákomaka motovâ yokóvo ne po'ínuhiko xâne. Kuteâti kixépovoku ákoyea kemáxatikapapu, énomonemaka íxeaneye ákoyea omótova yokóvo ne po'ínuhiko xâne” koêti —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ina kôe neko hóyeno: —Heú ngíxoa indúkea nê'e. Kutí'ikopo ngónokoiko? ");
INSERT INTO terNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ina kixôa Jesus: —Enepo yakaha'a itíkivo koati ponóvoti ákoti ovópiku, yakávaneponoa uhá koêti ne apeínopiti, ina perekéxa xâne ákoti apeínoati ne ésa'i. Yane apêtimo apeínopiti vanúkeke, ina kina'áka ingéneke hékinu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kamoáne hóyeno ne emó'uinoa Jesus, yupihovó koe isóne'ekeovo koeku pihópea kama'âti ne êno apeínoati. ");
INSERT INTO terNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ina kixovókoxoa Jesus ne íhikauhiko: —Koati emo'úti ra yunzó'inopinoe: Koati tiú'itimo yonópea natíxokuke Íhae Vanúke ne xâne ênoti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Koati ngixópitinoe: Ako'óneni oríko vékea kámelu xoko kali ihínone tôpe uhe'ókopeti yane yonópea natíxokuke Itukó'oviti vanúkeke ne xâne iríku —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kameáne íhikauhiko Jesus neko yûho, yupihovó koéneoxo iyúpaxeovahiko, ina koehíko: —Yane kuteâti koeku yiûho, kutí'ikopomo motovâ itúkeovo koítovone Itukó'oviti koane yonópea xokóyoke? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pono-ponó kixínoane ûke Jesus ina kixovókoxoa: —Enepone ínixone xâne itúkeovo yupihóvoti tiú'iko, ako átiu'i xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ina kixôa Pêturu: —Kurí kíxoa ûti ne uhá koeti koekúti koeku hókeopi ûti. Namo koéneye ûti? ");
INSERT INTO terNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ina yumopâ Jesus: —Koati emo'úti ra yunzó'inopinoe: Itínoe hokónuti, yaneko káxe ainámapone uhá koeti koekúti, ivandákapane xoko ivándakoku nandíxea koeku indúkeovo hána'iti ihayú'iuti, undi íhae vanúke ikútipasikoponovoti xâne, keha'ínenutimakamo ivétaki xoko nduse koeti ivatákokuti kuteâti ivándakoku nandíxea, motovâti yíhoikopi ne nduse koeti iháxakexoku xanena Izarâe, neixoti unátiyea, áko'o ákoyea aúnati ne ítuke. ");
INSERT INTO terNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Koane enepone uhá koeti xâne ákoti okotíxo ítukevo vo'ónguke, kuteâti óvoku, po'ínuhiko, há'a, êno, (yêno), xe'éxaxapa, áko'o itukovo poké'exa, yupihovó koetimo námoepo yane koekúti ákoti okotíxoa, yoko ko'ipâratimakamo ópea xoko Itukó'oviti ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Itea enómo xâne teyonéti koeku kó'oyene okópotimo ikenétike. Kene ne ákoti apayáso ovoti ikenétike koeku kó'oyene, énomonemo itukóvoxo koati teyonéti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ina kôe ne Jesus: —Enepone natíxea ne Íhae Vanúke xapa xâne, hane koéneye hóyeno itúkoti kavâne ipuhíkeati óvoku ya mâturukata oposíkoponoti ko'itúkeinoati kátarakinoa ne nóne úva. ");
INSERT INTO terNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kousókone emó'uinoa ne ahinoêtihiko itúkeovomo póhuti pe'u tiûketi poréxea ya káxe, yane pahúkoanehiko ko'ítukepoinoa xapa nóne úva. ");
INSERT INTO terNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ya nove ôra ya yupóniti, pihóponemaka neko hóyeno opósikoponea po'i ko'itúkeinoati. Yane noíxone po'ínuhiko xâne parásake ákoti itúkovoke. ");
INSERT INTO terNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ina kixoáhiko: “Pihénoemaka xapa nónem úva, yokó'itukepoinonu ínamo mbarexápapinoe yé'akeye ésa'i ne ke'ítukeyi” kíxovokoxoane. —Úkeane pihohíko. ");
INSERT INTO terNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ye'ékotine itumúkoti, koáne ya mopo'âti ôra, pihóponemaka neko hóyeno opósikoponea po'i xâne. Yane pahúkopomaka po'i ko'itúkepoinoati. Yoko kúteapoanemaka yuhó'inoa ne po'ínuhiko ahinoêti. ");
INSERT INTO terNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ya kuteâti síngu ôra ya kiyakáxe, pihóponemaka neko hóyeno opósikoponea po'i ko'itúkeinoati. Yane noíxoponemaka po'ínuhiko xâne ákoti itúkovoke. Hara kíxovokoxo: “Na koeti herú kixínenoe káxe yóvoheixi yâyeke ákoti yoko'ítuke?” ");
INSERT INTO terNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—Ina yumopâhiko: “Vo'oku akó'oti pahukó'oviti.” —Ina kixovókoxopamaka únae úva: “Pihé'ikoponoemaka, yokó'itukepoinonu xapa nónem úva” kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Yaneko kiyoné'e káxe, pahúkoane únae úva ne exeâti koêku ne ítuke. Hara kíxoa: “Ihéxihika uhá koêti ne ko'ítuketi. Peréxapa námoepo. Hane ínixa peréxopi koati okoti ikenéti turíxeovo ko'ítukeyea, ínamo perexápa ne inúxoti turíxovo ko'ítukeyea” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—Enepohikoneko ahinoêti turixeôvoti ko'ítukeyea síngu ôra ya kiyakáxe, poéha pe'u tiûketi námoepo póhutihiko. ");
INSERT INTO terNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Itea enepohikoneko inúxoti ko'ítuke, ikútixa xu'inánemo námoepo yane po'ínuhiko ahinoêti. Itea poéhamaka pe'u tiûketi námoepo póhutihiko. ");
INSERT INTO terNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Namukópanehiko ne tiûketi, turíxovonehiko kapáhakinovo pátarauxa. ");
INSERT INTO terNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hara koéhiko: “Enepohikora turixeôvoti koati ikenéti ko'ítukeyea, pohu poéha ôra ko'ítukehiko. Na koeti kutipasí kixínea námoepo ûti, uti koitóponovoti kotíveti xapa kótuti káxe?” kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—Ina kixôa únae úva ne póhuti ya xapákuke ne ahínoe: “Iningoné, ako váherexa índukeinopi. Ákoikopo usó yákoye itúkeovo póhuti pe'u tiûketi nemúko enepo inâ yuhó'ixinokoko ûti koêku? ");
INSERT INTO terNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kó'oyene nemúka ne tiûketi yêho. Pihépane vo'oku ngahá'a íngutipasikea némoepo ne námoepo okoti ikenéti ko'ítuke. ");
INSERT INTO terNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ákoikopo omótova indúkea kuteâti anjá'inoa ngíxeaneye ne índukevo? áko'o inixeâtimea váherexea indúkeovo koati únati xâne” kíxoane neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ina kôe ne Jesus: —Énomonemo koéneye inuxó koépeamo ne xâne ovoti ikenétike koêku kó'oyene. Kene ne inúxotihiko koêku kó'oyene, ikenétike ópomo. (Vo'oku êno xâne iháxiuti, itea ákomo axú'ina ne koati noivókoetihiko) —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pihoné'e ne evo Jesus ya Njeruzálem, koêku yóneahiko, ahikú kíxoa Jesus neko nduse koeti íhikau yane po'ínuhiko xâne. Hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Kó'oyene, Njeruzálem vonóne. Nguri'ókokonoatinemo ne tutíhiko sasedóti inuxínoti viyénoxapa hó'eke, koáne ne éskiriba, enepohikone ihíkaxoti yútoe Muîse. Koati ngixókonokunemo, undi íhae vanúke ikútipasikoponovoti xâne ínamo pahukáhiko ngoépekeokono, ");
INSERT INTO terNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ínamakamo kurikánuhiko xoko ákoti itukapu viyénoxapa jûdeu éxoti koêku poké'exa ûti. Yane koemóke'enutihikomo koane yehepóke'exonutihikomakamo, ínamo kuruhúxanuhiko, itea mopó'apeke káxe enjepúkopotimo ungópea xapa ivokóvoti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ina pihîno Jesus ne yeno Nzebêdeu. Xe'éxaxapa xané'inoa. Yane ipuyuké koéne neko sêno nonékuke Jesus koane épemea itúkinoa âha. ");
INSERT INTO terNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—Kuti kehá'a? —kíxoane Jesus. Ina yumopâ ne sêno: —Mani ngaha'âti peréxi ra pi'âti njé'a itúkeovo teyonéti koane ivátakea xîririkuke, póhuti yéxopeke kene po'ínu lepékuke ya netíxokuke. ");
INSERT INTO terNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ina kixôa Jesus: —Ákonoe koati yéxi koêku ne yépemonuke. Iteâtinoekopomo víki ne êno kotíveti koekúti véngokuikomo? —kíxoane. —Êm, vitoâtimo —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ina kixoáhikomaka Jesus: —Vikoâtinoexomo ne tiú'iti véngokuikomo, itea enepone ivétaki énjopeke yoko lombékuke xoko nandíxoku, hainamo ûndi noivókoxoa ivatákoatimoya, vo'oku Nzá'a kousókinoa ivatákoatimo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kamoánehiko po'i yéhi koeti íhikau Jesus, ímaikinovahiko neko pi'âti kopo'ínukokoti. ");
INSERT INTO terNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ina ihaxíhikoa Jesus ne íhikau ahí'okeovaxo. Hara kíxovokoxoa: —Yéxoanenoe itúkeovo payásotihiko pahukô xapa xâne. Koatine nâtihiko exêa koêku. ");
INSERT INTO terNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Itea xepákukenoe, ako ákoeneye, pó'iti koêku. Koêkuti kahá'ati itúkeovo payásoti xepákukenoe, konókoti usó kóyeyea itúkeovo yovóxenoe. ");
INSERT INTO terNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Koane koêkuti kahá'ati itúkeovo koati teyonéti ya uhá koêti xepákukenoe, konókoti itúkeovo ovoxéti híyeuke itínoe ");
INSERT INTO terNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kuteâtimaka ngoêku, undi íhae vanúke ikútipasikoponovoti xâne. Vo'oku hainámaka nzimínoti enó'iyea ovónje kouhépekoti ngóyeku, itea nzimínoti indúkeovo ovoxéti yoko ivóngeovo motovâti enó'iyea xâne ngoítovone —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ipuhíkeane pitivóko koéhati Njeríko ne evo Jesus, koati ênoti xâne hokó'ixoati. ");
INSERT INTO terNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yoko ápe pi'âti komítiti vataká koyêti xe'ókuke xêne. Kamoáne itúkeovo Jesus vekôa neko xêne, vaúkoanehiko. Hara koe yuhóhiko vaúkea: —Unaém, ámoripono Ndávi, yokóseanavi. ");
INSERT INTO terNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yane sayá'ikoa xanéhiko pahukoâti kóyunuhikeovo, itea inamá'axohiko kohonóko emó'u vaúkea: —Unaém, ámoripono Ndávi, yokóseanavi —kóyehiko. ");
INSERT INTO terNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yane xe'ó kó'inoane Jesus, ina ihaxíkoa koane kíxeahiko: —Kuti kehá'anoe indúkinopea? ");
INSERT INTO terNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Unaém, kahá'ati uti vínixopea —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kóseanane Jesus, ina ipíhoa vô'u ukékuke. Énomone yaneko ókoku ôra, ínixoponehiko koane hokópeahiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ye'éxoane evo Jesus ne Njeruzálem, simoáne ne ipuxóvokuti koéhati Mbetefâje xêrerekuke kali mopôi koéhati Olívera, yane pahúkone pi'âti íhikau ne Jesus inuxó kó'iyea tumúneke. Hara kíxoanehiko: ");
INSERT INTO terNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Pihénenoe yane kali ipuxóvokuti timúneke. Ehá'axomo símea, inixéponotinoemo seno njuméntu ika'ó koyêti yoko xe'éxa. Kíxeanoemo, ínamo yamapâ yâkeneye. ");
INSERT INTO terNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Enepomo áva epemó'ikopiti itíkoake, haramo íxea: “Konokoâtiko Vúnae râ'a” íxeamo. Yane sikópitinoemo yomópi yâkeneye —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yoko kó'inokeneye, hane simovóne kaxéna yuho porófeta mekúke, enepone koêti: ");
INSERT INTO terNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Hara íxeahiko ne íhae Njeruzálem: Yokómoma rakene netínanoe ivu'íxoti njuméntu. Ako kapáyasakapu nê'e. Koati xe'éxaiko njuméntu ivú'ixo” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yane pihóne neko pi'âti íhikau Jesus, itúkoane neko páhoenokono. ");
INSERT INTO terNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ina omopâ ne seno njuméntu yoko xe'éxa. Ipíhoanehiko kápana oúkeke, ina ivu'íxoa Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yoko xapákuke neko êno xâne, ako yumáxapu ikapákinoati kápana xenékuke. Ina apémaka tetúkoti tuti exáte ipíhoati xenékuke kouhé'ekinoati vékoku. ");
INSERT INTO terNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eneponeko êno xâne tumúneke koane ikéneke, aínovo kohonókoti yûho kóyeyea: —Koati hána'iti ihayú'iuti rakene ámoripono Ndávi. Viháyu'ika páhoenovi Vúnae Itukó'oviti. Koati hána'iti ihayú'iuti ne Itukó'oviti yâkonoye vanúkeke —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Simoné'e Njeruzálem ne Jesus, iyúpaxova uhá koeti xanéhiko yane pitivóko koane kíxeahiko: —Kutímeaya rakéne? ");
INSERT INTO terNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ina kôe yûho vaúkexea neko êno xâne hokoti Jesus: —Eneporâ'a, énomone ne porófeta íhae Nazâre ya Ngalíleya —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Urúkovane Jesus ne témpulu, enepone hána'iti imokóvokuti, xoko kíndana, kópuhihikopo xâne kaváneti yoko vanéxotiya, koane kasá'irikexea mesána neko koperáxoti xanéhiko esa'íkoti tiûketi, koánemaka ivátakokuhiko neko kaváneti kurûte. ");
INSERT INTO terNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ina kôe ne Jesus: —Hara kôe emó'uke Itukó'oviti: “Enepora imokóvokuti óvongu, iháxeokonotimo óvoku itúkoti orásaum” kôe. Itea itíkoanenoe óvoku ómevotihiko —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yane ina pihîno Jesus ne xâne komítiti yoko mohéveu yane hána'iti imokóvokuti koane koíteovahiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Itea enepohikone tuti sasedóti inuxínoti xâne hó'eke koánemaka ne éskiribahiko ihíkaxoti yútoe Muîse, ímaikovo noixoâne ítuke ne Jesus ákoti kuteâti, yóko'o ne kalivónohiko vaukéxoti koane kó'iyeahiko: —Koati hána'iti ihayú'iuti ra ámoripono Ndávi —kóyehiko. Ina kíxo Jesus ne tutíyehiko: ");
INSERT INTO terNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—Ako kéma koêku yûho ne kalivónohiko? Ina kixôa Jesus: —Ngámoane. Âvonoekopomea yíhoikiku emó'uke Itukó'oviti râ'a? “Iti Itukó'oviti, enepone kálihunoe kalivôno koánemaka ne ovotí'iko takikútike, peréxoa kaná'uyeaxo iháyu'ikeopi” ákoikopo ákoe? —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yane pihópeanehiko Jesus. Ipuhíkopeane ne pítivokona Njeruzálem, pihópone ya Mbétanea imókopoku. ");
INSERT INTO terNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yuponii kôe, káyukopovomaka ne Jesus ya Njeruzálem. Yoko epékoatine hímakati. ");
INSERT INTO terNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ina noîxo xuve fîgu xe'ókuke xêne, itea pihoné'eya, ako ápahuina há'i noíxone. Poéhane êno tûti apê. Ina kôe: —Ukeátine kó'oyene, hunókokunemo kahá'iyea râ'a —koéne. Yane movo'ó koéne neko xuve fîgu. ");
INSERT INTO terNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Noixoâne íhikauhiko Jesus, yupihovó koe iyúpaxeova, koane kó'iyea: —Imáko ákoino oríko movó'oyea ne xuve fîgu. ");
INSERT INTO terNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ina kixovókoxoa Jesus: —Koati emo'úti ra yunzó'inopinoe: Enepo itukapu koati kaná'uti kívivonu, hákotimaka muyâ'i iséneu yane kívivonu, itikoâtimo kuteâti ngíxoaku ra xuve fîgu. Haina póhutine itea muhíkovani pehukâ ra koati hána'iti mopôi áhikuxeova ne ókoku koane kuríno'ekopeova ne mar, mani ipokóvoti. ");
INSERT INTO terNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yoko uhá koeti koêkuti yépemone ya orásaum, enepo yakutípoaxo yimópikonomo, itikínokonoatimo. ");
INSERT INTO terNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Simoné'e ne Jesus yane hána'iti imokóvokuti, ixómoti ihíkaxo. Yane yakukú kíxoane tutíhiko sasedóti, enepone inuxínoti jûdeuhiko hó'eke, yoko po'ínuhiko teyonéti xapákuke tuti jûdeu. Hara kixóhiko Jesus: —Na úkea ne xunakóti itíkike ra koekútihiko? Kuti porexópi kíxineye ne ítike? ");
INSERT INTO terNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ina yumopâ Jesus: —Anéyemaka émbemopikenoe. Enepomo íte yimópinunoe, ínamo enjákapea porexónoati indúkea ra koekútihiko índuke. ");
INSERT INTO terNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kuti porexôa ne Xuaum Mbátita áhikea? Íhae Vanúke? áko'o xâne yara poké'e. Yane ina kixokókohiko: —Enepomo vokoyúhoa itúkeovo Íhae Vanúke pahukôa, “Ná'ikopo koeti ákoino yakútipoanoe ne Xuâum?” kixo'óvitimo. ");
INSERT INTO terNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Itea enepomo vokoyúhoa itúkeovo xâne yara poké'e pahukôa, pikómaka uti kixó'ovikumo xanéhiko, vo'oku heú koe xâne ínixea itúkeovo páhoe Itukó'oviti koyúhoyea emó'u ne Xuâum —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Énomone kixínohiko Jesus: —Ako véxa. Ina kixovókoxopamaka Jesus: —Ákoikopomaka ongóyuhoinopeanoe porexónoati indúkea ra koekútihiko índuke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ina koe'íkomaka ne Jesus: —Na kó'inoaye iséneu râ'a? Ápe hóyeno pi'âti xé'a. Koêku pihínoa ne xuvé'eti, hara kíxoa: “Nje'exá, yokó'itukepono xapa nónem úva.” ");
INSERT INTO terNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","—Ina kixôa xé'a: “Ako angáha'a mbíhea” kíxoane. —Itea itúkopinoa isóneu, yane pihóne xoko pahúkokonoku. ");
INSERT INTO terNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","—Ínamaka pího neko hóyeno xoko po'i xé'a. Kúteanemaka yuhó'inoa. Ina yumopâ xé'a: “Êm, mbihotímo” kíxoane. —Itea ako pîha. ");
INSERT INTO terNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—Yara pi'âti, kuti itukôa ne páhoenoa há'a? Ina yumopâhiko: —Xuvé'eti. Ina kixovókoxoa Jesus: —Koati emo'úti ra yunzó'inopinoe: Enepohikone koperáxinoti nâti ánu'ukenati kóperau, yóko'ohiko ne mohîti sêno, énomonemo yonopô natíxokuke Itukó'oviti vanúkeke ya itíke. ");
INSERT INTO terNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Vo'oku énomone simíno Xuaum Mbátita éxokeopinoe ponóvoti xêne yonópoti xoko Itukó'oviti, itea ákonoe kali yakútipoa. Kene ne koperáxinoti nâti yóko'o ne mohîti sêno, kutípoahiko. Upánini neíxoanoe ne koekúti, itea kóyeane ákoyea ikétivexanoe iséneuke ne váhere kixeku itíkivo koane kiríkopi, koane ákomaka yakútipoanoe —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ina koe'íkomaka ne Jesus: —Ivévakanoe ra po'i exetínati apêti ínzokoake: Ápe hóyeno itúkoti kavâne nôti êno xuve úva. Itúkinoa îpi neko nóne. Ina itûko tángi kótikovoku ho'o úva itûko víyum. Ínamaka koexépuko óvoku koyonínoati ne nóne, éyevoti vanúkeke motovâti ákoyea malíka ínixoku ne koyonoâti. Yane kurí'okoane ne katarákinoati ne nóne motovâti haxákopea avané'e êho. Yane pihóne po'i poké'e. ");
INSERT INTO terNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Simovóne kaxena veyóvope ha'i nonéti, pahúkone ahínoehiko ne únae kavâne xokóyoke ne katarákinoati ne nóne motovâti veyópoinoa námoepo. ");
INSERT INTO terNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Itea eneponeko katarákinoati nóne, namú kíxoane neko pahoétihiko. Yane yehépoke'exoa póhuti. Kene po'ínu, koépekoa. Kene po'ínu, hepókoa ya mopôi koepékoatimaka. ");
INSERT INTO terNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yane koxú'inakoane únae kavâne ne páhoepomaka, itea enepone katarákinoati nóne, kúteanemaka kíxoaku neko inúxotihiko pahoéti. ");
INSERT INTO terNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Koati ikenétike, pahúkoa únae kavâne ne xé'a xapákuke, vo'oku hara koêti isóneu: “Teyoâtihikomo ra nje'éxa” koeti isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Itea noixeânehiko xé'a, hara kixókokonehiko ne katarákinoati nóne: “Eneporâ'a, koati ítukenemo ra poké'e ivakápune há'a. Hingá, kaépeka ûti maka vitúkapeane ne mani ítuke íkuinoake há'a ivakápu” kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","—Yane namú kíxoanehiko koane kópuhikopea yaneko kavâne, ina koepékoamaka. ");
INSERT INTO terNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ina kixovókoxoa Jesus: —Enepo kayukápapu ne únae nonéti, namo kíxoaneye ne katarákinoati nóne? ");
INSERT INTO terNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ina yumopâhiko: —Koati kotívetimo kíxoaku kaepéka neko váherehiko xâne, ínamo kuri'ákapa po'ínuhiko xâne motovâti kátarakinoa ne nóne, xâne porexópatimo ne námoepo simapúne kaxena veyóvope —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ina kixovókoxopamaka Jesus: —Ákoikoponoe yíhoikiku ne yutoéti emó'uke Itukó'oviti, enepone koêti? “Enepone mopôi noívokoxine itúkoti péti, ainovó kôe itukóvo koati turíxeovoku uhá koêti kuteâti koeku koati inúxoti mopôi turíxeokonoke péti. Koati Vúnae Itukó'oviti kixoáneye. Yoko vínixoa itúkeovo koati êno ihayú'iuti koekúti ne ítuke” koêti ne yutoéti —kíxovokoxoane Jesus ihókopovati ne mopôi noivókoxineti. ");
INSERT INTO terNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ina kixovókoxopamaka Jesus neko xâne: —Énomone ngixínopinoe: Mani itínoe ne xanena Itukó'oviti yonópoti natíxokuke. Itea ákonenoemo yenápa. Porexókonotimo po'ínuhiko xâne yonópeaya, xâne kouhápu'ikoti ya kixoku itúkeovo ápeyea há'i pôreupo Itukó'oviti kuteâti kúxone. ");
INSERT INTO terNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Enepora mopôi ngixínopike, uhá koeti xâne ikoró'uxovati, kutí koetímo póte enepo itatáko. Kene ne xâne irípu'ikovoke, ákonemo ipíxa. Kutí koetímo póte muvake-muvaké koetímo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Enepone tutíhiko sasedóti inuxínoti jûdeuhiko hó'eke yóko'o ne farîzeuhiko, kamoáne neko exetínati apêti íhokovoke, exó kíxoanehiko itúkeovo énomonehiko kíxo Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yane opósi'ixinoanehiko kixoku iká'akea ne Jesus, itea koati pikoti xanéhiko vo'oku aínovo inixoâti itúkeovo páhoe Itukó'oviti koyúhoyea emó'u ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Aúkopovo ne Jesus koyúhoyea exetínati apêti íhokovoke. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Enepone natíxea Íhae Vanúke xapa xâne, hane koéneye nâti itúkoti hána'iti ayuíti kasátuxo xé'a. ");
INSERT INTO terNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ápe ahínoehiko ne nâti páhoe iháxihikoponea ne húpiuhiko oránake ne ayuíti. Itea ákohiko he'énka ne húpiuhiko. ");
INSERT INTO terNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yane pahúkone po'íhiko ahínoe neko nâti koane kíxea: “Hara íxepana ne nzúpiuhiko: ‘Ngoúsokoane uhá koêti ne nikokónoti nókone áyuim. Ngoépekone vûi koane kínati xe'exa váka. Usóne uhá koêti. Kiná'akanenoe ayuítike índukeino nje'éxa kasâtuxotine’ íxeahikomo” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—Itea eneponeko hupiútihiko, ako itúkeake yûho ne hupixoâti. Pihóne óyonokuke ne po'ínu. Kene po'ínu, po'i itúkovoke yuíxovo. ");
INSERT INTO terNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kene po'ínuhiko, namúkoa ne ahinoêtihiko hupixóponoati, íkoitoponoa kotíveti ina koepékoahikomaka. ");
INSERT INTO terNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yane yupihovó koe ímaikeovo neko nâti. Pahuko húndaruna koépekexoponea uhá koêti neko xâne koepékexeati ahínoe koane oró'okeamaka pítivokonahiko. ");
INSERT INTO terNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ina kíxo po'i ahínoehiko: “Usóne uhá koeti nókone ra áyui, itea ako omótokea hupíxeokono nekôyohiko. ");
INSERT INTO terNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pihénoekopo ya none ovokúti xoko koati vékoku xanéhiko. Hipíxapanamo ne uhá koeti koêkuti xâne tekópone” kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—Ina pihohíko ne ahinoêti ya none ovokúti. Ho'úxoa uhá koêti ne xâne tokópone, xâne únati koánemaka váhere pahukoâti píhea ayuítike. Yane puhi-puhí kôe neko ovokúti ya êno hupiúti. ");
INSERT INTO terNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ina urúkovo neko nâti xapákuke ne húpiuhiko noíxoponea ne xâne ovoti xe'o mêsa. Ya xapákuke neko êno xâne, ápe hóyeno noíxone ákoti oko'ípovo kuteâti nókone ko'ípovoyea yonoti xapa áyui koyénoti. ");
INSERT INTO terNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ina kixôa nâti: “Iningoné, na kíxoaye yûrukivo yâye ákoti yoko'ípova ne nékone ke'ípovoyi xapa áyui kasâtuxoti?” —Yane yunu-yunú kixóvone neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ina kixôa nâti ne ahínoehiko: “Iké'akinoe hêve râ'a koane vô'u ina kirikâ xapa êno hahákuti, óvokumo iyókexoti yoko ngarutútukexoti ôe vo'oku êno tiveko koêku” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ina koe'íkomaka ne Jesus: —Êno xâne iháxiuti, itea ako axú'ina ne koati noivókoetihiko —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ipuhíkopeane farîzeuhiko xapákuke ne xanéhiko, ho'úxovonehiko oposíkoti kixoku iyupaxó kíxea Jesus épemo'ikea, kaha'aînoati pahúkeovo ya kixoku yumópea. ");
INSERT INTO terNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yane pahúkoane farîzeu ne íhikauhiko koánemaka xanena Êrodi xoko Jesus. Hara kixóponoahiko: —Ihikaxotí, véxoa itíkivo koati ponóvoti koane yíxivoa ne kaná'uti kixovókuti ihíkexoati ne páhoenovi Itukó'oviti. Ako yokómomoyi payásoko ne xâne vo'oku kutíkokone uhá koeti xâne xikóyoke. ");
INSERT INTO terNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ná'ikopo kó'inoaye iséneunoa ra koekúti? Yimápavi yarâ'a: Pahúkovi Ponóvoti Kixovókuti hó'e ûti poréxea ûti ne kóperaxovike Sêza, enepone nâti ya Róma exoti koeku ûti? áko'o ákoyea —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Itea exó kíxea Jesus ne váhere isóneuhiko. Yane hara kíxovokoxoa: —Na koeti yopósi'okinovonunoe kehá'atinoe mbahúkeovo ya yumómbope? Koati itínoe itûkoheovoti! ");
INSERT INTO terNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yéxakana ne tiûketi kóperau nâti. Yane omínoanehiko póhuti pe'u tiûketi. ");
INSERT INTO terNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ina kôe ne Jesus: —Kutí'ikopo itukoa nône yoko îha ovâ ra tiûketi? Ina yumopâhiko: ");
INSERT INTO terNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Sêza. Ina kixovókoxopamaka Jesus: —Enepone ítuke nâti, peréxapa. Koáhati ítukene. Kúteanemaka koêku xoko Itukó'oviti, koêkuti páhoenopi, konokoâtimaka itíki —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kamoánehiko neko yuho Jesus, yupíhova iyúpaxeova unáko ne yumópope. Yane kurí kíxoane épemo'ikea koane pihópeahiko. ");
INSERT INTO terNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Koati énomone yaneko káxe, ahí'okovo Jesus ne sadúseuhiko, enepone koyúhoti ákoyeamo exépukapa ne ivokóvoti. Hara kixóhiko Jesus: ");
INSERT INTO terNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ihikaxotí, hara kôe yútoe Muîse: “Enepo ivakápu hóyeno ákoti apáhuina xe'éxainoa ne yêno, konokoâti itúkeovo po'ínu ne ivokóvoti koyenópea yêno ne po'ínuikene maka avané'e xe'éxainoamaka, kutí ákoepone xe'éxa ne ivokóvotine” koe yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yoko ya xapákuke ûti, ápe nóvo seti koeti hóyeno kopo'ínukokoti. Kóyenone neko xuvé'eti. Ivokóvone, ako ápahuina xe'éxa. Kurí kíxoane neko yêno xoko atípo. ");
INSERT INTO terNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kúteanemaka koêku ne po'ínu, ivókovone ákotimaka xe'éxainoa ne sêno. Ina keno'óko ne mopó'ape, kúteanemaka koêku. Yane ehane uhá koe ívohikeovo neko seti koêti. ");
INSERT INTO terNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ivokóvone uhá koêti neko kopo'ínukokoti, yane ivókovomaka ne sêno. ");
INSERT INTO terNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yane kuteâti koêku, eneponi akaná'u exépuhikopea ne ivokóvoti, kutí'ikoponi itukópaxo koati yêno ne sêno xapákukehiko ne seti koeti hóyeno kopo'ínukokoti? vo'oku heú koéhiko kóyenoyea ne sêno —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ina yumopâhiko Jesus: —Koati pahukóvotinoe iséneunoa ra koekúti, vo'oku ákoyea yéxa koêku ne yutoéti ya emó'uke Itukó'oviti koánemaka ne xunako Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Vo'oku enepomo exepúhikapane ne ivokóvoti, ákonemo koyénoti koane ko'ímati. Kutí koépotinehikomo ánju íhae vanúke, ovóxehiko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yoko enepone exépuhikopeamo ne ivokóvoti, ákoikopo yíhoikiku ya emó'uke Itukó'oviti koêku? Énomone neko koêti: ");
INSERT INTO terNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Undi Itukó'oviti kuvóvone Âbraum, kuvóvonemaka Izáki yoko Njáko” koêti. Yanê'e, hainá'ikopo kuvóvone ivokóvotine ne Itukó'oviti, ínapo “Âbraum-kene” akôe, itea koati kuvóvone xâne iyukóvoti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kamoáne xanéhiko neko yuho Jesus, yupíhova iháyu'ikea ne ihíkauvoti íhikaxone. ");
INSERT INTO terNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yane ho'úxovonehiko ne farîzeu, enepohikone yuixóvoti hókea yútoe Muîse exoânehiko ákoyea íta sadúseuhiko kóteyokea ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yoko ápe póhuti farîzeuya ihíkaxoti Ponóvoti Kixovókuti yútoe Muîse oposí'okovoti Jesus, kaha'aînoati pahúkeovo ya yumópope. Hara kíxoa: ");
INSERT INTO terNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ihikaxotí, kuti itukóvoxo koâti nókone xâne itúkea yane uhá koeti páhoenovi Itukó'oviti Ponóvotike Kixovókuti yútoe Muîse? ");
INSERT INTO terNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ina yumopâ Jesus: —“Heru'ó íxea yomíxone koane iséneu ákoyea omótova yokóvo ne Itukó'oviti Yúnae.” ");
INSERT INTO terNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Énomone itukóvoxo koati hána'iti nokonéti ya uhá koêti páhoenokono xâne itúkea. ");
INSERT INTO terNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kene ne pí'ape, po'ínumaka kuteâti, harâ'amaka: “Hako motovâ yokóvo ne po'ínuhiko xâne. Kuteâti kixépovoku ákoyea kemáxatikapapu, énomonemaka íxeaneye ne po'ínuhiko xâne.” ");
INSERT INTO terNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Vo'oku enepora pi'âtihiko páhoenokono xâne itúkea, koeku ikána'uxea xâne ya xokóyoke, koatímaka itukoâti uhá koêti ne po'ínuhiko páhoenokono itúkea yútoeke Muîse koánemaka yútoeke porófetahiko —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Koeku ho'uxo-ho'uxó kó'inoa farîzeuhiko, hara kíxovokoxoa Jesus: ");
INSERT INTO terNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Na kó'eye iséneunoanoe ne Mésiya, páhoe Itukó'oviti koíteovo xâne? Kuti itukoa ámoripono? —kíxovokoxoane. —Ámoripono Ndávi —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ina kixovókoxopamaka Jesus: —Ná'ikopo koeti “Unaém” kixínoa Ndávi, koyúhoti ya xunákoke Sasá'iti Omíxone Itukó'oviti? Vo'oku hara koé'epepo: ");
INSERT INTO terNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Hara kíxoa Itukó'oviti ne Únaem: ‘Ivétakapa énjopeke xoko ivátakoku koati ngapáyasokone imókonemo ipuyúkexa nenékuke ne uhá koeti koêkuti okopópiti’ ” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Koati “Unaém” kixoâti Ndávi. Ápeikopo oxéne itúkeovo ámoripono Ndávi ne Mésiya? —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yoko ako ápahuina xâne itoâti yumópea, epó'oxo ukeátine neko káxe, ákone mapikóvati épemo'ikea ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ina kixovókoxoa Jesus neko íhikauhiko koáne neko êno xâne hokoâti: ");
INSERT INTO terNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Enepohikone éskiriba yoko farîzeu, koati ahukoâti íhikaxea ne Ponóvoti Kixovókuti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Itíkaikopo koane héka ne uhá koeti íhikaxeopike, itea hákonoe ihemákova ne kixoku itúkeovo, vo'oku upánini íhikaxo, itea ako kalíhuina itúkea kuteâti ne íhikaxone. ");
INSERT INTO terNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kutí koe ika'ákoti êno ínati inonéti ikoínoxoti po'ínuhiko xâne (ákoti itâ xâne koínoyea), itea ako kalíhuina yónea isóneu koínoyea póhuti kali koekúti yane íkoinoxoke po'ínuhiko. ");
INSERT INTO terNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Enepohikone farîzeu yoko éskiriba, itúkinoake uhá koêti ne ítukehiko, hane kahá'a éxokeovo po'ínuhiko xâne. Énomone kapáya'ikinoa ne íhaku yutoéti ukeâti emó'uke Itukó'oviti, iká'aehiko ya inúkuke itukovo takíkuke, kaha'âti noíxeokono. Énomonemaka kapáya'ikinoa ne iyóyonevo hevékuke ípovo, kaha'âti ápeyea koyuhoâti itúkeovo teyonéti. ");
INSERT INTO terNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Koáne ya xapa ayuíti yoko ya íhikaxovokuke hó'e, yómotihikomaka ivátakea xoko ivatákokuti ya nonekútike xoko ivátakoku koati payásotihiko. ");
INSERT INTO terNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Enepo yuhoíkokono, koeku vékea ya none ovokúti, ahá'axomaka éxeokono itúkeovo teyonéti. Koati áhatimaka “ihikaxotí” kíxeokono. ");
INSERT INTO terNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kene itínoe, ako yusíka “ihíkaxoti” kíxikono, vo'oku poéhaxo ne koati kaná'uti ihíkaxopitinoe, kene aínovonoe iti kopo'ínukokoti. ");
INSERT INTO terNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Poéhaxo ne Yá'a, enepone Itukó'oviti íhae vanúke. Hákoikopo kepayásoko po'ínuhiko xâne yara poké'e, kutí kixeâti Itukó'oviti, enepone Yá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Epó'oxo ákomaka yusíka “inuxínoviti” kíxeopi po'i xâne, vo'oku poéhane Mésiya, enepone páhoe Itukó'oviti koíteovo xâne itukóva. ");
INSERT INTO terNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Itea hanemo itukóvo koati payásoti xepákukenoe, enepone usó koyêti itúkeovo ovoxe po'ínuhiko. ");
INSERT INTO terNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Enepone kapayásokopovoti, koteyókokonotimo. Kene ne ákoti kapayásakapapu, énomonemo kahaná'ikokono —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—Koati kotívetimo kêku itínoe éskiriba yoko farîzeu, ikítixapovoti koati sasá'iti ya po'ínuhiko xâne, vo'oku kutí koe yexexîti páhapetea natíxoku Íhae Vanúke. Ákonoe yûrukapa koane itopó kíxeamaka ne po'ínuhiko xâne kaha'âti ûrukeova. ( ");
INSERT INTO terNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Koati kotívetimo kêku itínoe éskiriba yoko farîzeu, ikítixapovoti koati sasá'iti ya po'ínuhiko xâne, itea inípono kíxeaku ne senóhiko ivokóvoti îma, kutí koe hi'ixîti óvoku. Yane vo'oku ké'umoki itíki orásaum, kutí koe itínoe koati ponóvoti. Itea énomone kutí'ino yupihóvotimo tivéko ipíheponikonoke ya po'ínuhiko xâne.) ");
INSERT INTO terNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Koati kotívetimo kêku itínoe éskiriba yoko farîzeu, ikítixapovoti koati sasá'iti ya po'ínuhiko xâne. Ako malíka yénoku íhikexoponi póhuti koxe'u xâne, keha'aînoati hókea ne hékone. Muhíkova terú'uxi úne ya mar, koane píhi po'íke poké'e, usó kéyenoe. Yoko apê yehónoe, inamá'axo yupihóvo évokeovo ya itíke koane motókea yonópea ipihóponovokutike vo'oku hokópea kixeku itíkivo. ");
INSERT INTO terNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Koati kotívetimo kêku itínoe kutí koeti xâne komítiti inuxínoti po'ínuhiko xâne, vo'oku hara kénoe: “Haina koati yuhôti itukovo ya iháke hána'iti imokóvokuti, enepone témpulu, koyúhoyea ne xâne. Ako koêku enepo hákotimo kousókokono ne yuhôti kuteâti. Poéhane itukápu ya iháke ôro ovâti ne témpulu hainápo, konókoti itúkeokono ne yuhôti” kénoe. ");
INSERT INTO terNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Itínoe ákoti isóneu koane kutí koeti komítiti, pó'itinopikopo sasá'iko ôro yane sasá'iko témpulu, keyúhoinoake ákoyea koêku enepo hákotimo kousókokono ne yuhôti koyuhóvoti ya iháke témpulu? Ako kalíhuina kó'iyeaneye. Koati vo'ókuke ne témpulu itúkinovo sasá'iti nonékuke Itukó'oviti ne ôro ovâti. ");
INSERT INTO terNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Haramaka kénoe: “Haina koati yuhôti itukovo ya iháke áta, enepone imókonoku íparaxokonoke Itukó'oviti témpuluke, koyúhoyea ne xâne. Ako koêku enepo hákotimo kousókokono ne yuhôti kuteâti. Poéhane itukápu ya iháke íparaxokonoke Itukó'oviti ovâti neko áta hainápo, konókoti itúkeokono ne yuhôti” kénoemaka. ");
INSERT INTO terNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Itínoe kutí koeti komítiti, pó'itinopikopo sasá'iko ne áta yane íparaxokonoke Itukó'oviti ovâti, keyúhoinoake ákoyea koêku enepo hákoti kousókokono yuhôti koyuhóvoti ya iháke áta? Ako kalíhuina kó'iyeaneye. Koati vo'ókuke ne áta itúkinovo sasá'iti nonékuke Itukó'oviti ne íparaxokonoke ovâti. ");
INSERT INTO terNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Énomone ngixínopinoe: Enepone koyuhoâti ya iháke áta, koatine áta yoko uhá koeti ovâti ne áta koyúhoyea ya iháke. ");
INSERT INTO terNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Koáne enepone koyuhoâti ya iháke hána'iti imokóvokuti, koatine sasá'iti péti yoko Itukó'oviti, enepone Únae, koyúhoyea ya iháke. ");
INSERT INTO terNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Koáne enepone koyuhoâti ya iháke vanúke, koatine iháke ivátakoku Itukó'oviti natíxea koyúhoyea yoko ihákemaka Itukó'oviti, enepone ivatákoati. ");
INSERT INTO terNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Koati kotívetimo kêku itínoe éskiriba yoko farîzeu, ikítixapovoti koati sasá'iti ya po'ínuhiko xâne. Kaná'uti ápeyea íperaxoke Itukó'oviti, hexakínoati póhuti yane uhá koeti yehí koeti ítikevo perêxo ndîzimu. Muhíkinova ne kálihunoe neóne xe'ókuke yóvoku kuteâti otélam yoko ereva ndúse koane kómiyum, peréxomaka ndîzimu ya koêkuti yé'akeye yêho. Itea enepone koâti nékone itíki yane Ponóvoti Kixovókuti yútoe Muîse, enepone itíki ponóvoti, koane itíkivo seánati, yoko kívivo Itukó'oviti, ákonoe itíka. Yoko énomone itukóvoxo koati nékone itíki ákotimaka kurí ixêa itíki ne po'ínuhiko koekúti. ");
INSERT INTO terNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Itínoe kutí koeti komítiti inuxínoti po'ínuhiko xâne. Kutí kénoemaka xâne yuixóvoti veyópea kálihunoe hikê irinó'ekeovati ekáke ya koeku ákoyea itíkoake ne koâti hána'iti koekúti kuteâti itóvoku kámelu irinó'ekovati. Huirí kíxea nê'e, ako itíkoake. ");
INSERT INTO terNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Koati kotívetimo kêku itínoe éskiriba yoko farîzeu, ikítixapovoti koati sasá'iti ya po'ínuhiko xâne. Koati kutí ketínoe xâne kókoyuse kixoíxoti kipó'ikea enovópeti yoko ûto meúkeke, itea kúveuke koati ênoti ihómuyo. Énomone kénenoeye koeku itúkeovo ainóvoti váhere koekúti ovâ ne iséneu yoko kehá'ayi yaúpu'iki po'ínuhiko xâne, kutí kixévoti xâne hu'uxeâti ítukevo motovâti kirí'uxi apeínopiti. ");
INSERT INTO terNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Itínoe farîzeu, koati kutí ketínoe komítiti. Kuteâti koeku kónokea sasá'iyea kúveuke ne enovópeti kipo'íkokono, énomonemaka koéneye kónokea sasá'ipea iséneu inúxotike motovâti sasá'iyeamaka heú koeti kixeku itíkivo. ");
INSERT INTO terNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Koati kotívetimo kêku itínoe éskiriba yoko farîzeu, ikítixapovoti koati sasá'iti ya po'ínuhiko xâne, vo'oku kutí kénoe katátumbana ivokóvoti hóhopu koyêti homóxeovo, uhé'ekoti xoko noixoâti, itea ya opékuke aínovo ope ivokóvoti ovâ yoko imuyúkoti. ");
INSERT INTO terNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Énomonemaka kénenoeye noixópi po'ínuhiko xâne, kutí kénoe ponóvoti, itea enepone iséneu, aínovo semekénovo'iti yoko ákoti tôpi kó'iyeovoku vaherévokoti ovâ —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Koati kotívetimo kêku itínoe éskiriba yoko farîzeu, ikítixapovoti koati sasá'iti ya po'ínuhiko xâne, vo'oku kéxepuko katátumbana porófetahiko koyúhoti emo'u Itukó'oviti mekúke, koane keúhe'ekinoa katátumbana neko xâne ponóvoti kixoku itúkeovo ivokóvotine. ");
INSERT INTO terNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ina kenôe: “Eneponi itukapu kaxena voxúnoekene vápeyea, ákoni vaxéna nekôyohiko koepéko porófetahiko mekúke” kénoe. ");
INSERT INTO terNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yane yiûho, koati keyuhópovoti itíkivo ámoripono koepékoati ne koyúhotihiko emo'u Itukó'oviti mekúke. ");
INSERT INTO terNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Koeku kó'iyeaneye, keúkapanaikopo ne váhere itukéti tûriu ne yoxúnoekene. ");
INSERT INTO terNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Itínoe kutí koeti koéxoe! Itínoemaka ámoripono xâne kutí koeti koâti ipúhokovoti koéxoe! Ákonemo yoxéne ítivoa ne ipíhoponope Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yane apêtimo porófeta koyúhoti emo'u Itukó'oviti mbáhoe xepákukenoe, koane hóyeno ko'éxoneti yoko ihíkaxoti emo'u Itukó'oviti, itea apêtimo képeu xapákuke. Kene po'ínuhiko, kiruhúxoatimo. Kene po'ínuhiko, yihipóke'exoatimo he'úxinovokuke hé'e koane hekó'ixoatinoemo ya koêkuti pitivóko óvohikoku váherexea ítikeinoa. ");
INSERT INTO terNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Itea kó'inokenemoye, motovâti itúkeovo yoúkekenoe yóno itina uhá koêti neko xâne ponóvoti kixoku itúkeovo, koépeuhiko yoxúnoekene ukeâti kaxénake koépekeokonoku Âmbeu, enepone ponóvoti kixoku itúkeovo, tukú koeti kaxénake koépekeokonoku Nzakâriya, xé'a Mbarákiya, képeunoe ukeâti ne hána'iti imokóvokuti yonoti xoko áta yane kíndanake hána'iti imokóvokuti. ");
INSERT INTO terNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Koati emo'úti ra yunzó'inopinoe: Vo'ókukehiko ra koekúti, oúkekemo ra xanéhiko apêti kó'oyene yonómo uhá koêti ra koekúti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ina koe'íkomaka ne Jesus: —Imáko ké'iyivoku itínoe íhae Njeruzálem. Aínovonoe iti xâne yómoti koépekea porófeta koyúhoti emo'u Itukó'oviti. Aínovonoemaka iti koépekenati ovoxe Itukó'oviti páhoe xepákukenoe, hipokoâti ya mopôi. Kuteâti kíxoaku tapî'i ho'úxea ne xe'éxaxapa opékuke kêvi, ene ngahá'amaka ngíxeopineye, itea ákonoe yakáha'a. ");
INSERT INTO terNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yara kuteâti kêkunoe, ákonemo ovâti ra yóvoku, kurí kixokónotimo. ");
INSERT INTO terNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Koati ngixópitinoe: Ukeátine kó'oyene, ákonenoemo neíxapanu tukú koeti yaneko káxe ké'iyikumo: “Viháyu'ika rakene keno'ókoti páhoenovi Vúnae Itukó'oviti” yakoénoe —koéne ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ipuhíkopeane Jesus ne témpulu, enepone hána'iti imokóvokuti, koeku pihópea, ahí'okovone Jesus ne íhikauhiko, ina so'ixínoahiko uhá koêti ne koexépoeti ítuke ne hána'iti imokóvokuti koáne oveâti xe'ókuke ipixoâti. ");
INSERT INTO terNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ina kixovókoxoa Jesus: —Neíxoanenoe koeku uhá koeti râ'a? Koati emo'úti ra yunzó'inopinoe: Ákomo ápahuina mopôi pâredena ákoti katahínekexakana. Heu-heú koetimo kotóhinekexeokono —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yoko hane ivátaheixo ne Jesus oúkeke neko kali mopôi iháxoneti Olívera. Yane ahí'okovahiko íhikau. Koati ainóvotinehiko ákoti po'i xâne xapákuke. Ina kixohíko Jesus: —Yokóyuhoinovea ápepemo ra koekúti kixínevikemeku, yoko itukóvotimoye koekúti hoénaxovope ne kaxena itíkopivokumo nâti, yoko uké'eyeakumakamo ra kúveu mêum —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ina kixovókoxoa Jesus: —Yokóhiyanavonoe maka hákone aupú'ikopiti. ");
INSERT INTO terNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vo'oku enómo xâne simôti xepákuke iko'ítukexoti înza. “Undi Mésiya, páhoe Itukó'oviti koíteovo xâne” koetímo. Epó'oxo enómo xâne ítone aúpu'ikea. ");
INSERT INTO terNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Koane yeyekóxotimo ápeyeane ákoti tôpi óvoku isukókoti, koane kemotímakamo po'ínuhiko eyekoûti ápeyea kahá'ati isúkeokoko, itea hákonoemo kenóko'i. Konókoti kó'iyeanemoye, itea haina hunókokumo ra mêum nê'e. ");
INSERT INTO terNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vo'oku inúxotike apêtimo íhae po'i poké'e isukóponoti xanéhiko íhae po'i poké'e. Koane apêtihikomakamo nâti isukókoti. Enómakamo hímakati yara kúveu mêum, koane ákomo tôpi óvoku iyuyôti poké'e. ");
INSERT INTO terNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Enepora koekútihiko, koati turí'ikonemo hána'iti tiveko koekúti. ");
INSERT INTO terNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Ikeítoponokonotinoemo kotíveti, koane apêtimo koépeuti xepákukenoe, epó'oxo yupihóvatimo púveopinoe ne xanéhiko ya uhá koeti koêkuti poké'e óvohikoku yara kúveu mêum vo'oku itíkivo hokónuti. ");
INSERT INTO terNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yaneko káxehiko, enómo kuríkoti hókeonu, koane enómo xâne itukóheovoti, kuríkotihikomo po'ínuhiko hokónuti xoko xanéhiko puvâti. Enómakamo puvokókoti. ");
INSERT INTO terNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Enómo xâne koyúhoti itúkeovo páhoe Itukó'oviti koyúhoyea emó'u itea ákomo akána'uhiko, koane enómo xâne ítone aúpu'ikea. ");
INSERT INTO terNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Epó'oxo vo'oku yupíheovomo ukóponea ne vaherévokoti, yupihovó koetímo xâne hokónuti isomókoti ákoyea omótovokoko okóvo. ");
INSERT INTO terNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Itea enepone koxuná'ixovoti ingéneke ákoti aukápapu ikéne tukú koeti hunókokuke, énomonemo pihopô vanúkeke xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yoko koyuhóvotimo ya uhá koeti kúveu mêum ra inámati ihíkauvoti koyúhoti koeku natíxea ne Itukó'oviti xapa xâne, motovâti kámea xanéhiko ya uhá koeti koêkuti poké'e óvohikoku yara kúveu mêum. Yane simóvotinemo hunókoku ra mêum —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ina koe'íkomaka ne Jesus: —Enepo neixânenoe ne êno váhere koekúti yane óvoku koati sasá'iti kixovókuti, koesáyu'ixoati koane kotohínekexopati, kuteâti koeku yuhóke porofeta Ndaníye koyúhoti emo'u Itukó'oviti mekúke, hara ngôe vo'ókuke: (Yoko koêkuti yuhoíkoati râ'a, apásika éxea koeku kixó'ekone.) ");
INSERT INTO terNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Enepohikone xâne ovotíya Njúdeya, okóho'inehiko xapa kali mopôi. ");
INSERT INTO terNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kene koêkuti xâne ovoti ómomikokuke oúke pêno, hákone urúkopovo kúveu óvoku veyóponea koêkuti apeínoati, itea aká'ikaneye okóho'i. ");
INSERT INTO terNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kúteanemaka koêku ne ovóheixoti ya mêum, hákone aukópovo veyóponea po'i ípovo óvokuke. ");
INSERT INTO terNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Hanemo kixovóhiko yaneko káxe, sêno ihaíkoti yoko ohíkotiko xe'éxa. ");
INSERT INTO terNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yépemaikoponoe Itukó'oviti ákoyeamo itúkapu ya xapa kásati, áko'o ya sâputu ápeyeamo ra koekútihiko, ");
INSERT INTO terNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","vo'oku yaneko káxehiko, koati yupihóvatimo tivéko ne koekútihiko ákoti ápeyeaku kuteâti inâ turixóvo ra kúveu mêum tukú koeti kó'oyene, epó'oxo ákonemo ápeyeaku kuteâti tivéko ra koekúti. ");
INSERT INTO terNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yoko eneponi kaxu'íkenexakana neko káxehiko, ákoni iteóvati. Itea vo'ókukehiko ne noívokoe Itukó'oviti, enepohikone koati xanéna, énomonemo ákoino káxu'ikenexakana. ");
INSERT INTO terNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Yane enepomo áva kixópitinoe: “Harâ'a ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne”, áko'o “Anêko yâko” ixekána, hákonoemo kitipôa. ");
INSERT INTO terNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vo'oku enómo xâne koyúhoti itúkeovo Mésiya, itea ákomo akána'u. Yoko enómakamo mahi porófeta koyúhoti emo'u Itukó'oviti, itea aínovomo ákoti akaná'u. Itúkotihikomo êno hána'itinoe iyupánevoti yoko koekútihiko ákoti noíxeokonoku. Muhíkovamo ne koati noívokoe Itukó'oviti, enepohikone koati xanéna, mani koímaitimo íteokono vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Neíxapuikopo, vo'oku endó'okopitinoene tumúneke símeovomo neko káxe. ");
INSERT INTO terNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Énomone ngixínopinoe: Áva kixópitinoe: “Harakóxono ne Mésiya ya mêum ákoti apêti” ixâpi, hákonoe pihinêa. Koáne, “Harakóno he'onóvoti kúveuke ovokúti” áva kixópiti, hákonoemo kitipôa. ");
INSERT INTO terNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Vo'oku kuteâti koeku ipixéneneoti uhá kíxea koúhapu'ikea vanúke ukeâti úkeaku ihâroti tukú koêti ya xoko onómekovoku káxe, énomonemo koéneye iyúseyea ne ngáyukopovope, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ina itukínoamaka íhokoake ne kíxone. Hara kôe: —Koêkutimo óvoku ne ivokóvoti, énomonemakamo ho'úxovo varutútuhiko —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ina koe'íkomaka ne Jesus: —Koati ikénepokemo ne kotíveti koekútihiko ngixínopikenoe yaneko káxehiko, ákonemo parexa uhápu'ine ne káxe, hahakú koetínemo. Koánemaka ne kohê, ákonemo aúhapu'i. Irihíkovotimo ne hékere. Koáne ne po'ínuhiko koekúti apêti ya vanúkeke, itohínekexotimakamo. ");
INSERT INTO terNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yane apé koetínemo vanúkeke hoénaxovope nzeópope, undi íhae vanúke ikútipasikoponovoti xâne. Iyókexotimo uhá koeti xâne yara kúveu mêum, koane noixóponutinemo ngena'ákapa xapákuke kapási ya vanúke. Xané ngixópotinemo njunáko koane êno únje'ene koeku indúkeovo hána'iti ihayú'iuti. ");
INSERT INTO terNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yane ínamo mbahuhíka ovónje, enepohikone ánju íhae vanúke óxea êno hónoti emo'u torombéta. Yane ho'uxópatihikomo ánju ne noívongoe, enepohikone koati njanéna koêkutimo óvohikoku yara uhá koeti kúveu mêum, omopâtihikomo vanúkeke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ina koe'íkomaka ne Jesus: —Ivévakaikopo koêku ra xuve fîgu koáne ne ihíkauvoti ínzokoake. Enepo inamápone ne káva'o koane tûti, yéxoanenoe yé'exopeovone kaxena kevópope úko. ");
INSERT INTO terNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kúteanemaka koêku enepo neixânenoe uhá koêti ra koekúti ngixínopikemeku, yexoâtinemo yé'exeovone kaxéna. ");
INSERT INTO terNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Koati emo'úti ra yunzó'inopinoe: Enepone xanéhiko apêtimo yaneko káxehiko, ákomo ivákapu koeku âvoyea kaúsakapu uhá koêti ra koekúti ngixínopikenoe ápeyeamo. ");
INSERT INTO terNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Uké'etimo ra vanúke koánemaka ra poké'e, itea enepora emó'um, ákomo uké'eyeaku. ");
INSERT INTO terNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Enepone kaxéna yoko orána ápepemo ne koekútihiko, ako exoâti itukóvotimoye, muhíkova ne ánju, enepohikone ovoxe Itukó'oviti íhae vanúke, muhíkovamaka ûndi, undi Xe'exa Itukó'oviti. Poéhane Nzá'a exôa. ");
INSERT INTO terNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yoko kuteâti koeku yaneko kaxénake Nôe, énomonemakamo koéneye enepo simapúne kaxena aúngopovope, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Vo'oku yaneko mekúke tumúneke ápepe neko êno koiníkoti, poéhane níkea, énoyeovo koane kâsatuxea yuíxovo neko xanéhiko tukú koeti yaneko káxe urúkovane Nôe neko hána'iti vatéke. ");
INSERT INTO terNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ákohiko iyúkinapa isóneu xanéhiko neko koekúti imókone apê neko koiníkoti. Yane heú kíxoane koúpa'ixeahiko. Énomonemakamo koéneye ne ngáyukopovope yara kúveu mêum, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yaneko káxe, apêtimo pi'âti xâne ya mêum. Poéhamo veyopókonoti, kene po'ínu, iríkovokunemo. ");
INSERT INTO terNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Koane apêtimo pi'âti sêno kaha'ínekokoti itútukea. Poéhamo veyopókonoti, kene po'ínu iríkovokunemo. ");
INSERT INTO terNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Usokó yákoyenoe, itíkapu iyukóvoti isóneu vo'oku ako yéxanoe kaxena nzeópope, undi Yúnae. ");
INSERT INTO terNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Itíkinanoe iséneu râ'a: Eneponi exâ hóyeno únae ovokúti símeamo oméxoti koane ókoku símope, mani kuxó kixoíxoati. Ákoni síka ûrukeova ne óvoku. ");
INSERT INTO terNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Énomonemaka kónokino usó kéyeyi, vo'oku ya koati ákoyeakumo kixápanu, énomonemo ngáyukopeovo, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ina kixovókoxopamaka Jesus: —Itíkina iséneu koêku ne ahinoêti koati yuixóvoti ítukexeokonoke koane ponóvoti isóneu ítukeke, enepone ípihinoake pátarauxa éxea koêku ne po'ínuhiko ahínoe motovâti koúnakinoa nókone koatíke kaxénaxeokonoke. ");
INSERT INTO terNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Koati únati koêku ne ahinoêti kuteâti, enepone inú'epo pátarauxa kíxeaneye ko'ítukeyea aukápapu. ");
INSERT INTO terNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Koati emo'úti ra yunzó'inopinoe: Kuri'ó kixoâtimo pátarauxa kóyoninoa uhá koeti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Itea enepo itukápu váhere ne ahinoêti, epó'oxo akoémaka isóneu: “Yupíhovane xu'íkeneyea ne mbátarauxa” akôe, ");
INSERT INTO terNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ina turixápu yehépoke'exea ne po'ínuhiko ahinoêti ha'íne, koane yuixápu níkea, énoyeovo yoko kohíhiyea, naíxapu nê'e. ");
INSERT INTO terNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Vo'oku seopó koetimo pátarauxa ya káxe koati ákoyeaku kuxápa, koáne ya ôra ákoyeakumaka éxa káyukopeovokumo. ");
INSERT INTO terNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yane koati kotívetimo kíxoaku pátarauxa ipihápana. Iyonópatimo xoko iyónopaku ne xâne ákoti aunáti kixoku itúkeovo ikútixapovoti sasá'iti ya po'ínuhiko. Koáne enómo iyókexoti koane ngarútutukexea ôe vo'oku hána'iti tiveko koêku ya xoko iyónopokonokuhiko. ");
INSERT INTO terNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ina kixovókoxopamaka Jesus: —Enepone natíxea Íhae Vanúke xapa xâne, hane koéneye yehí koeti ârunoe, ainóvoti omoti íhaku yukúna koúhapu'ikope okotúmonexoponoti koyénotimo. ");
INSERT INTO terNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ápe singu koeti xapákukehiko ákoti isóneu. Kene ne po'i singu koêti, aínovo ko'isóneuti. ");
INSERT INTO terNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Enepohikone ákoti isóneu, omo íhaku yukúna, itea ako amína po'i hô'o ne yukúna. ");
INSERT INTO terNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kene ne ko'isóneutihiko, ápe po'i hô'o ne yukúna ómone xané kixoâti ne íhaku yukúna. ");
INSERT INTO terNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Koeku ko'ókoriyea seópea ne kúxoixopone, uhékene ixépa koane imókeahiko. ");
INSERT INTO terNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Ya kuku yóti, apé koene emo'u vaúkoti: “Harakénepo ne kuxopóneti. Yakátumanexapanoe” koe yûho. ");
INSERT INTO terNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","—Yane heú koene íyuhikeovo neko ârunoe, ina ihúxoa ne yukúna. ");
INSERT INTO terNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Enepone ârunoehiko ákoti isóneu, ákone áhupa irúmene yukúna. Ina kixohíko ârunoe ko'isóneutihiko: “Peréxavi kalihú koeti ho'o yikúna, vo'oku kahá'ane ípukeovo ra yukuna ûti” koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—Ina yumopâ ârunoehiko ko'isóneuti: “Ako yusíka, mará'inamo heú vákoe kónokinovovi. Pihé'evonoe xoko kavaneâti, venéxapana” kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—Koáne, pihónehiko vanéxoponea. Itea koeku píheahiko, seópone ne koyénoti kúxoixoponehiko. Yane enepohikone usokó koyêti, xané kixópanehiko ne koyénoti úsa'ixopeovo xoko áyui kasâtuxoti. Yane exéxopovone ne pahapéti. ");
INSERT INTO terNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Kali xu'ikénene, aúkopovohiko neko ârunoe ákoti isóneu. Ina vaukóhiko: “Unaém, Unaém, míhe'akinavea ra pahapéti” koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—Ina yumopâ inu'íxinoati kúveuke ovokúti: —“Koati ngixópitinoe ákoyea énjapi.” ");
INSERT INTO terNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ina kixovókoxoa Jesus: —Usokó yákoyenoe, itíkapu iyukóvoti isóneu vo'oku ako yéxa itukóvotimoye kaxéna koane orána ne aúngopovope —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ina koepómaka ne Jesus: —Enepone natíxea Itukó'oviti xapa xâne, hanemaka koéneye hóyeno yonoti po'íke poké'e. Tumúneke píhea, iháxihiko ahínoe porexoâti kóyoninoa apeínoati óvokuke. ");
INSERT INTO terNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ina porêxo po'i ahínoe, singu koeti pe'u tiûketi. Yoko póhutihiko pê'u, êno ovâti. Kene ne po'ínu ahínoe, pí'a pê'u námoe. Kene po'ínu, poéha pê'u. Hara exôa poréxokonoke póhutihiko ahínoe kuteâti kixoku ahúkoko ya itukétike. Yane pihóne neko pátarauxa. ");
INSERT INTO terNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Eneponeko ahinoêti namúkoti singu koeti pe'u tiûketi, ehá'axo namúkoa, pihóne oposíkoati kíxoaku kohíyakea neko tiûketi. Yane ápene ehópo po'i singu koeti pê'u. ");
INSERT INTO terNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kúteanemaka koêku neko namúkoti pi'âti pê'u, ítoamaka po'i pi'âti pê'u ehópo. ");
INSERT INTO terNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Itea eneponeko namúkoti póhuti pê'u, pihóne kehókoponea uhôro iyónoaku hé'onea neko tiûketina pátarauxa. ");
INSERT INTO terNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Xu'ikénene, ina kayukópovo pátarauxa epemópatihiko kíxoaku neko tiûketi. ");
INSERT INTO terNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ina ahi'ókovo pátarauxa neko namúkoti singu koeti pe'u tiûketi. Yane poréxopane po'i singu koeti pê'u tiûketi êho, koane kíxea: “Unaém, singu koé'epepo pe'u tiûketi peréxonuke. Kó'oyene anéyepo po'i singu koeti pê'u enjó'inopi” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—Ina kixôa pátarauxa: “Mbiú koe ítike. Iti koati únati ahinoêti yuixóvoti ítuke. Koeku kó'iyeaneye ítike yane kali mboréxopike, kó'oyene mborexópitinemo yéxi koeku koati xu'ínatiya. Yókopone, kaha'iné íxepanu ya elókeyea ongóvo” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Yane ina ahi'ókovo neko ahinoêti namúkoti pi'âti pe'u tiûketi. Hara kôe: “Unaém, pí'apepo pe'u tiûketi peréxonuke. Kó'oyene anéyepo po'i pi'âti pê'u enjó'inopi” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—Ina kixôa pátarauxa: “Mbiú koe ítike. Iti koati únati ahinoêti yuixóvoti ítuke. Koeku kó'iyeaneye ítike yane kali mboréxopike, mborexópitinemo yéxi koeku koati xu'ínatiya. Yókopone, kaha'iné íxepanu ya elókeyea ongóvo” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Koati hunókokuke, simóne ne namúkoti póhuti pe'u tiûketi. Hara koéne: “Unaém, enjoâti itíkivo hóyeno ákoti omotóva ikómohixeokono. Iti xâne itíxoti upánini ákoyea neóne. Ápemaka yêho upánini ákoyea nêa. ");
INSERT INTO terNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Koati mbikoâti ingó'itukexea ne tîketina, ene njé'oninoa ne pénenu. Harâ'apo kó'oyene” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—Ina kixôa pátarauxa: “Koati iti váhere ahinoêti ákoti yuixápu ítuke. Yéxoanini indúkeovo xâne itíxoti xoko ákoyeaku nóne, koane ápeyea ênjo xoko ákoyeaku ngurika ake nónem. ");
INSERT INTO terNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mani konokoâti ípihi bánkuke ne ndiûketina motovâti ikó'itukexeokono. Yane koeku nzeópea kó'oyene mani ihiyákotine” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—Ina kixôa únae tiûketi ne po'ínuhiko ahínoe: “Viyápinoe tiûketina nê'e. Hane peréxapa apêti yehí koeti pê'u. ");
INSERT INTO terNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Vo'oku uhá koeti xâne xu'ínati êho, kuri'úxinokonoatimo. Yanê'e, yupihovó koetíneoxomo êho. Itea enepone ákoti axu'ína êho, muhíkova ne kali apêti xokóyoke veyopeôkonoatimo. ");
INSERT INTO terNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kene ne ahínoe ákoti yuixápu ítuke, kiríkanoe xapa êno hahákuti, óvokumo iyókexoti yoko ngarutútukexoti ôe vo'oku êno tiveko koêku” kíxoane pátarauxa —kôe éxetina Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ina koe'íkomaka ne Jesus: —Enepomo aungápapune, undi íhae vanúke ikútipasikoponovoti xâne, exákanane indúkeovo koati hána'iti ihayú'iuti nâti, anjenápanemaka uhá koeti ánju íhae vanúke, enepohikone ovoxe Itukó'oviti, ínamo ivandákapa xoko ivándakoku nandíxea koeku indúkeovo hána'iti nâti. ");
INSERT INTO terNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yane ho'uxóvotimo uhá koeti xâne nonénguke ukeâti póhutihiko poké'e, koêkuti óvohikoku yara kúveu mêum. Ínamo nzaxakéxapa ne xanéhiko kuteâti kíxoaku koyónoti su'ûso háxakexopea ne su'ûso yoko váxikita. ");
INSERT INTO terNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Haramo injíkopahiko ne njanéna, enepohikone ínzokoke su'ûso, énjopeke xoko óvokumo ne ngahána'iu. Kene ne ínzokoke váxikitahiko, lombékukemo injíkopahiko. ");
INSERT INTO terNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yane ínamo injâ ne ovotíhiko énjopeke yaneko exákanane indúkeovo koati hána'iti nâti: “Kiná'akapa, itínoe itúkinokemo únati ne Nzá'a. Yûrukapapa ra natíxoku Itukó'oviti koúnaenopine ukeâti inâ apê ra kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Vo'oku yaneko épekeonuku hímakati, peréxonunoe nînga. Epékonu úne, peréxonunoemaka úne. Koeku úngea po'i poké'e, peréxonu óngea yóvokuke. ");
INSERT INTO terNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Akô'o ímbovo, peréxonunoemaka ímbovo. Nga'aríne, kétarakonunoe. Óvom ika'ákovokutike, neíxopononu” ngixoâtihikomo. ");
INSERT INTO terNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Yane ínamo ixânu ne ponóvoti kixoku itúkeovo: “Unaém, ná'aye noíxeopi ûti épekeopi hímakati ina porexópi uti nikokónoti? Ná'ayemaka poréxeopi uti úne epékopi? ");
INSERT INTO terNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ná'aye poréxeopimaka uti yóki vóvokuke yukêa po'i poké'e? Ná'aye noíxeopi ûti ákoyeaku ípevo, ina porexópi uti ípevo? ");
INSERT INTO terNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ná'ayemaka noíxeopi ûti ké'arineyi yoko iké'akivo ina noixóponopi ûti?” ");
INSERT INTO terNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—Ínamo injâ yaneko exákanane indúkeovo koati hána'iti nâti: “Koati emo'úti ra yunzó'inopinoe: Heú koeti apê ítikeinoa ra kálihunoe hokónuti, enepone kutí ngíxone mbo'ínuhiko, koati undímaka kixéneye.” ");
INSERT INTO terNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Ínamakamo injâ ne ovoti lombékuke: “Yahíkuxipununoe, itínoe imbíhopononemo. Yenápanoe ipihóponovokutike xapa yúku ákotinemo ípukeovoku koúsokinokonoake ne Ndeâpu yoko uhá koeti ndémoniuhiko ovóxe. ");
INSERT INTO terNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Vo'oku yaneko épekeonuku hímakati, ákonoe peréxanu nînga. Epékonu úne, ákonoemaka peréxanu úne. ");
INSERT INTO terNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Koeku úngea po'i poké'e, ákonoe peréxanu óngea yóvokuke. Akô'o ímbovo, ákonoe peréxanu ímbovo. Nga'aríne koane óvom ika'ákovokutike, ákonoe neíxapananu” ngixoâtimo. ");
INSERT INTO terNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Ínamo ixanúhiko: “Unaém, ná'aye noíxeopi ûti épekeopi hímakati, áko'o epékopi úne? Ná'ayemaka noíxeopi ûti yukîti po'i poké'e, itukovo ákoti ípevo, áko'o itukovo ke'aríneti itukovo ike'ákovoti, ákoti katarákapi ûti?” ");
INSERT INTO terNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—Yane ínamo injáhiko: “Koati emo'úti ra yunzó'inopinoe: Heú koeti akô'o ketaráka ne koati kálihunoe hokónuti, koati undínemaka kixéneye” ngixoâtihikomo. ");
INSERT INTO terNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Yane yonópotihikomo ipihóponovokutike nekôyo ákotinemo hunókoku. Kene ne ponóvoti kixoku itúkeovo, ákonemo hunókoku ópea xoko Itukó'oviti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Uke'éxoane Jesus íhikaxea uhá koêti ra ihíkauvoti íhikaxone, hara kíxovokoxo íhikauhiko: ");
INSERT INTO terNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Yéxoanoe pí'ayeane káxe âvoti simóvotinemo kaxena kóyuipe ûti, enepone Páskoa. Yane nguri'ókokonotinemo xanéhiko kuruhúxonutimo, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yoko enepohikone tuti sasedóti inuxínoti jûdeu hó'eke, koáne ne po'ínuhiko teyonéti xapákuke tuti jûdeu, ho'úxovonehiko yane óvoku koati payásoti ya uhá koeti sasedóti koéhati Kaífa. ");
INSERT INTO terNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yane opósikonehiko isóneu kixókumo omé kíxeahiko Jesus iká'akea koane koépekea. ");
INSERT INTO terNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hara koéhiko: —Itea ako yusíka itúkeovo xapa ayuíti mará'inamo ímaikexapu ra xanéhiko —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yoko Mbétanea óvoheixo ne Jesus óvokuke Símaum, eneponeko unatípeati koati váhere arinéti iháxoneti lépara. ");
INSERT INTO terNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yane ahí'okovane sêno omoti íhaku xêru, itukéti ya hopú'iti mopôi iháxoneti alabásturu. Yoko puhí kôa êno kohépiti xêru iháxoneti báusamu. Ina ovopú'iko Jesus yane xêru koeku vatá kóyeyea xe'ókuke mêsa. ");
INSERT INTO terNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Noixoâne íhikauhiko Jesus, êno poé'ainoahiko isóneu neko sêno. Hara koéhiko: —Na koeti évokinovo ra êno kohépiti xêru? ");
INSERT INTO terNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mani êno tiûketi ovâti akavánevo, ínani parekéxakana xanéhiko ákoti apeínoati ne ésa'i —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yoko kámeane Jesus neko yûho. Yane hara kíxovokoxoa: —Na koeti ikétivexinoanoe koêku ra sêno? Koati únati koekúti ítukeinonu. ");
INSERT INTO terNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vo'oku kóyekunemo xepákukenoe ne xâne ákoti apeínoati. Kene ûndi, ákomo ángoyeneye xepákukenoe. ");
INSERT INTO terNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Koeku óvo'okeonoa ra xêru, koati inúxinonoatine ne kixókonokumo mûyom engaxápune. ");
INSERT INTO terNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Koati emo'úti ra yunzó'inopinoe: Ya uhá koeti kúveu mêum, koêkutimo koyúhovoku ra inámati ihíkauvoti ínzikaxone, koyuhókonotimakamo ítukeinonu ra sêno, puyákoponeovakemo okóvo xâne ra sêno —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yanê'e, ápe póhuti yane nduse koeti íhikau Jesus, enepone koéhati Njuda Iskarióti, pihôti yúho'ixoponea neko tutíhiko sasedóti inuxínoti jûdeu hó'eke. Hara kôe yuhópoinoa: ");
INSERT INTO terNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Namo yé'aye peréxonuke nguri'ákapeanoe ne Jesus? —kíxovokoxoane. Yane poréxoanehiko tirinta koeti pe'u tiûketi péhu. ");
INSERT INTO terNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ukeátine neko káxe, opósi'ixoane Njûda kíxoaku kuríkea Jesus xokóyokehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yaneko inúxoti káxe xapa áyui jûdeu hó'eke, níkeakuhiko pâum ákoti kohiyákoati, ahí'okovo Jesus ne íhikauhiko koane kíxea: —Na kehá'a kóyuseoponea ûti ne vóvokumo níkea ûti xapa ayuíti? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ina yumopâ Jesus: —Pîhe pitivókoke xoko xâne ngixínopike. Hara íxepana: “Pahukó'oviti yâyeke ne Ihíkaxoti. Hara koe páhoenovi koyúhopoinopea ûti: ‘Simóvone oránam. Yóvokukemo óvom níngea xapa ayuíti, ûndi yoko ínzikauhiko’ íxeamo” —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Koane itúkoahiko ne páhoenoa Jesus. Yane koúsokoanehiko neko nikámo xapa áyui Páskoa. ");
INSERT INTO terNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hahaméne yanekôyoke, ivátakone ne Jesus xe'o mêsa, koáne neko nduse koeti íhikau xánena. ");
INSERT INTO terNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Koeku níkeahiko, hara kíxovokoxoa Jesus: —Koati emo'úti ra yunzó'inopinoe: Anéye póhuti xepákukenoe itûkoheovoti koeku hókeonu, yoko kurikónutimo xoko xanéhiko puvónuti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yane yupihovó koénehiko ikáxu'iyea okóvo koane turíxeovonehiko pohú pohu kó'iyea kíxea Jesus: —Unaém, undíperameamo? ");
INSERT INTO terNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ina kixovókoxoa Jesus: —Enepone xané kixónuti yendémekea utókuke, énomone itûkoheovoti koeku hókeonu nê'e, kurikónutimo xoko xanéhiko puvónuti. ");
INSERT INTO terNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Koati kaná'uti ngoépekeokonomo kuteâti koeku yutóxeovo ya emó'uke Itukó'oviti vo'ónguke, undi íhae vanúke ikútipasikoponovoti xâne, itea koati kotívetimo koêku ne kurikónutimo xoko xanéhiko puvónuti. Yusikóneni ákoyea ipúhika yara kúveu mêum —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yane ina kôe ne Njûda, enepone kurikoâtimo xoko xanéhiko puvâti: —Ihikaxotí, undíperameamo? Ina yumopâ Jesus: —Enepone yépemonuke, kaúhapu'ikoa itúkeovomo îti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Koeku níkeahiko, veyo pâum ne Jesus, ina ikoró'ixovo xoko Itukó'oviti. Yane honó'ekexoa ne pâum, ina porekéxoamaka íhikau koane kíxovokoxea: —Víyanoe, níkeanoe. Enepora pâum, mûyom kixó'eko —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yane ina namukôa Jesus ne enovópeti koane íkoro'ixeovo xoko Itukó'oviti. Yane pôrekexoane íhikau koane kíxovokoxea: —Yénapa, heú ketínoe. ");
INSERT INTO terNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Vo'oku enepora víyum, hane kixó'eko indína ovokínovotimo êno xâne, ésa'i (inámati) kixovókuti ítukeino xâne ne Itukó'oviti motovâti itúyopea pahúnevo. ");
INSERT INTO terNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Koati ngixópitinoe: Ukeátine ra káxe kó'oyene ákoyeanemo énoyeovangu hô'o ra ha'i úva tukú koetímo neko káxe angahá'inepopinenoe vénoyeovomaka inámati ho'o úva ya natíxoku Nzá'a vanúkeke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ina imokóvohiko akenéti. Ikénepoke, ina pihohíko oúke kali mopôi iháxoneti Olívera. ");
INSERT INTO terNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ina kixovókoxoamaka Jesus ne íhikau: —Enepoyara yóti, hána'itimo poé'ayeanoe iséneunonu, koane uhá ketínoemo kiríkinu kuteâti koeku yuho Itukó'oviti emó'uke, enepone koêti: “Ngoepékoatimo ne koyónoti su'ûso, yane uhá koetimo itóhineheyea ne óyonone” kôe —kíxovokoxoane Jesus ihókovati ne koyónoti su'ûso. ");
INSERT INTO terNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ina kixovókoxopakomaka: —Itea enjepúkapane ungópea xapa ivokóvoti, inuxó ngoépotimo timúnekenoe ya Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yane ina kixôa Pêturu: —Yusíkotimo poé'ayea isóneunopi ne uhá koeti po'ínuhiko xâne koane kuríkeopihiko, itea ûndi, ákomo kalíhuina nguríkea nzókeopi. ");
INSERT INTO terNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ina kixôa Jesus ne Pêturu: —Koati emo'úti ra yunzó'inopi: Kó'oyene yara yóti tumúnekemo éneyea tapî'i, mopo'âtinemo keyuho ákoyea yéxanu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ina kixopâmaka Pêturu: —Ákomo kalíhuina ngoyúhoyea ákoyea énjapi, muhíkova okonókovo xané ngíxeopi képekikono —kíxoane. Kúteanemaka yûho ne po'ínuhiko íhikau Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Úkeane pího ne Jesus yoko íhikauhiko ya xoko omómikokuti iháxoneti Njetisémani. Simoánehiko, hara kíxovokoxoa Jesus ne íhikau: —Ivétakavonoe yâye koeku indúkoponeako orásaum yâko tumûneke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ina ómo Pêturu yóko'o neko pi'âti xé'a Nzebêdeu. Yane turíxovone ikáxu'iyea okóvo ne Jesus yoko yupíheovo kotíveyea isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hara kíxoahiko Jesus: —Yupihovó koéne êno hána'iko ra ikáxu'ine ongóvo, kutí koe tiveko pevóti. Yavânenoeye njokóyoke. Hákonoe imêko koeku kehá'ineyinu —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kali ahikú koéne ne Jesus, yane ipúyukexo xaneâti ísu'okea nône poké'eke epémoti Itukó'oviti. Hara koe yûho: —Pai, yáhikuxapinana ra êno hána'iti tiveko ngoêkumo enepo yakahá'a. Itea haináya anjáke itea itúkapu yahá'inonu kousókovo ya njokóyoke —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yane ina kayukópovo xoko íhikauhiko. Inu'í kixópane imókeahiko. Ina kíxo Pêturu: —Ákonoe ite ákoyea iméka koeku kehá'ineyinu ya kúveu póhuti kali ôra? ");
INSERT INTO terNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hákonoe imêko, koane itíkanoe orásaum maka hákone ikerókovo enepo simâpi tiú'iti koekúti hixépikonoke. Vo'oku ya iséneuke, usó kéyenoe, itea ya oránake mani kénokiku kétiu'ikivoxo, ú'uso koyéneoxo muyá'iyea iséneunoe —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ina kayukópovamaka itúkoponea orásaum. Hara koépomaka yûho: —Pai, enepora êno tiveko ngoêkumo, itukapu konokoâti ákoyea ahíkuxeapunu, ongonókoa véngeako, itúkapuikopo yahá'inonu kousókovo ya njokóyoke —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yane káyukopovonemaka xoko íhikauhiko. Inu'í kixópanemaka ímohikea. Koáhati yupihóvoti uheko ixépahiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ina kayukópovomaka itúkoponea orásaum. Yoko mopó'apene ituko orásaum. Kuteâti koeku yûho inúxotike, énomoponemaka koéneye. ");
INSERT INTO terNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ina kayukópovomaka xoko íhikauhiko. Hara kíxoahiko: —Yanéyeikonoe iméki koane yómomiki? Simóvone ne ôra, nguri'ókokonotinemo xanéhiko váhere kixoku itúkeovo, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yexépukanoe, hingá! Kenó'okone ne itûkoheovoti ingéneke, enepone kurikónutimo xoko xanéhiko puvónuti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ixómoiko koyûho ne Jesus, simóne Njûda, póhuti yane nduse koeti íhikau. Yoko koati opoíkovoti xánena omotíhiko hána'itinoe pirítau yoko pulô'i isukópeti. Aínovo páhoe tutíhiko sasedóti inuxínoti jûdeu hó'eke koane po'ínuhiko teyonéti xapákuke tuti jûdeu. ");
INSERT INTO terNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yoko enepone hóyeno kuríkoti Jesus xoko xanéhiko puvâti, ápe emó'uinoa ne xánena tumúneke píheahiko. Hara kíxoa: “Enepone hóyeno nziúnoneumo, énomonemo nê'e. Iké'akanenoemo” kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ehá'axo sîmo ne Njûda, ahí'okovone Jesus koane yúhoikea: —Únati Ihikaxotí —kíxoane, koane siunoné kíxeane. ");
INSERT INTO terNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Itea hara kíxoa Jesus: —Iningoné, enepone simíneke, ípiheane kó'oyene, hákone ike'ókorixoa —kíxoane. Ina ahi'ókovo Jesus ne xanéhiko, yane namúkoanehiko, ina ika'ákoa. ");
INSERT INTO terNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Itea apé koene póhuti yane xáneheixone Jesus hekoti hána'iti pirítau. Maturukenó kixone ahínoe koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke. ");
INSERT INTO terNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ina kixôa Jesus: —Yunákapa ne hána'iti piríteuna. Vo'oku uhá koeti xâne ikoítukexoti hána'iti pirítau isúkea, pirítaumakamo veyópinokono koépekeokono. ");
INSERT INTO terNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ikítixati mani ákoti pahukínanu Nzá'a ákoti yumaxápu ovóxe, enepone ánju íhae vanúke kotíxoponeonu yara ókoku ôra eneponi embemâ? ");
INSERT INTO terNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Itea eneponi akoéneye, ákoni kaúsakapu ne yutoéti emó'uke Itukó'oviti koyúhoti kónokea ngíxeokononeye —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yane hara kíxovokoxoa Jesus neko êno xâne: —Undí'ikopo koati koyuvôrixovoti ísukenati omó kixínekenoe hána'iti pirítau yoko pulô'i isukópeti nemúkoponinunoe? Uhá koeti káxe, koati óvonzeixokunepepo xepákukenoe ya hána'itike imokóvokuti inzíkaxoti, yoko ákonoe iké'akanu. ");
INSERT INTO terNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Itea kó'inokeneye uhá koêti ra koekútihiko, koati simóvotine kuteâti ne yútoehiko porófeta nóvo ya emó'uke Itukó'oviti —kíxovokoxoane. Yane kurí kixone Jesus ne íhikauhiko, kohó'ikene. ");
INSERT INTO terNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yane enepohikone ika'ákoti Jesus, omópanehiko óvokuke Kaífa, enepone koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke. Yoko ho'úxovonemakaya ne éskiriba, enepohikone ihíkaxoti yútoe Muîse, koánemaka ne po'ínuhiko teyonéti xapákuke tuti jûdeu. ");
INSERT INTO terNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kene Pêturu, ákone malíka kixoku hókea Jesus. Tukú kíxoa kíndanake óvoku koati payásoti ya uhá koeti sasedóti. Yane ûrukovone, ina ivatáko xapákuke neko ahinoêtihiko kaha'âti noíxea kixókonokumo ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yóko'o neko tutíhiko sasedóti inuxínoti jûdeu hó'eke, koane uhá koêti neko pahúkotihiko xoko koati payásoti yúhoikovoku jûdeuhiko, opósiko xâne usó koyêti itúkoheyeamo koeku Jesus motovâti koyúhoyea motókeyea koépekeokono. ");
INSERT INTO terNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Itea ako ínixahiko kuteâti ne âha upánini enó'iyea koyúhoti nonekútike yane yuhoíkovokuti, itukóheyeati koêku. Ehane ápe pi'âti hóyeno koêti: ");
INSERT INTO terNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Hara koe yûho ra hóyeno: “Motóva ngotóhineyea ra sasá'iti óvoku Itukó'oviti koane ngoéxepukopeamaka ya kúveu mopo'âti káxe” kôe —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yane exépuko ne koati payásoti ya uhá koeti sasedóti inuxínoti jûdeuhiko hó'eke. Hara kixo Jesus: —Ákomo se'íkapa yûho ra xanéhiko koyúhoti ápeyea váhere ítike? ");
INSERT INTO terNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Itea yunu-yunú koéne ne Jesus. Ina koepómaka ne koati payásoti ya uhá koeti sasedóti: —Ya iháke koati kaná'uti Itukó'oviti mbahúkopi yimópinu. Iti Mésiya, páhoe Itukó'oviti koíteovo xâne, enepone Xe'exa Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ina kixôa Jesus: —Koati yépemonuke kouhápu'ikoa indúkeova. Yoko koati ngixópitinoe: Keno'ókoti káxe neixóponutimo, undi íhae vanúke ikútipasikoponovoti xâne vatá ngoyépotimo éxopeke Itukó'oviti, enepone apêti xunáko pahúkea uhá koêti. Neixónutimo ungapeâne vanúke koeku evénzekopea xapa kapásihiko —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Énomone yanê'e, kávarerekexopone ípovo muyókuke ne koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke, éxokovope yupíheovo ímaikinova neko yuho Jesus, ina kôe: —Koati itûkovoti Itukó'oviti râ'a. Ákone vokónoko po'i koyuhó'inoveati pahúnevo. Kéminenoe yûho. Koati itûkovoti Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ná'ikopo kó'inoayenoe iséneu kó'oyene? Ina yumopâ po'ínuhiko tuti jûdeu: —Konókoti koépekeokono —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yane ápenehiko apurúnoneati. Kene po'ínuhiko ipúsokoa. Ina apémaka po'ínuhiko isukoâti koeku kó'iyeahiko: ");
INSERT INTO terNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Mahí'ipepo iti koati Mésiya, enepone páhoe Itukó'oviti koíteovo xâne. Íhexaikopo itukóvotiye ra isukópiti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yoko vaata kóye Pêturu meúkeke kíndanake ne ovokúti. Yane apé koéne seno ahinoêti ahi'ókovati. Hara kíxoane: —Koati itímaka xáneheixone ne Jesus, enepone íhae Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Itea hara kíxoa Pêturu nonékuke uhá koêti neko xâne: —Ako énja ne kíxene —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ina pihôpo xoko vekokúti xe'ókuke pahapéti. Yane apé koéponemaka po'i seno ahinoêti noixoâti. Ina kixôa neko po'ínuhiko xanéya: —Enepora hóyeno, xáneheixonemaka Jesus, enepone íhae Nazâre —koéne. ");
INSERT INTO terNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yane ina koepómaka ne Pêturu: —Ako énja ne hóyeno kíxene —koéne. Yoko ihákemaka Itukó'oviti koyúhoyea itúkeovo koati kaná'uti ne yûho ákoyea éxa. ");
INSERT INTO terNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Avo áxu'ikene, ina ahi'ókovohikomaka Pêturu ne xanéhiko yane óvoheixoku. Hara kíxoahiko: —Koati kaná'uti itíkivo po'ínumaka xáneheixone ne hóyeno vo'oku í'iyuse kóyeyea ya kixeku keyúhoyi —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yane ina ikaná'uxoaxo Pêturu koyúhoyea ákoyea éxa. Hara koépomaka: —Ako énja ne kíxenenoe. Ngayumákapunemo, ipihápananu Itukó'oviti enepo nzemekékexinapinoe —koéne. Ehá'axo koyúhoa Pêturu nê'e, éneone tapî'i. ");
INSERT INTO terNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yane puyákoponovane okóvo neko yuhó'inoa Jesus, enepone koêti: “Tumúneke éneyea tapî'i, mopo'âtinemo keyuho ákoyea yéxanu” koêti. Ina ipuhíkopea Pêturu neko óvoheixoku. Koati iyôti koeku yupíheovo kotíveyea isóneu. ");
INSERT INTO terNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yuponíne, ho'úxovone uhá koêti neko tutíhiko sasedóti inuxínoti jûdeu hó'eke, koáne ne po'ínuhiko teyonéti xapákuke tuti jûdeu, oposíkinoati isóneu kixókumo koépekea Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yane iká'akonehiko Jesus koane ómea xoko Pilátu, enepone ngovenâdo, kurikoâtihiko xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yóko'o ne Njûda, enepone kuríkoti Jesus xoko xanéhiko puvâti, noixoâne koúsokeanehiko isóneu koépekeamo Jesus, yupihovó koene ikótivexea isóneuke ne ítuke. Úkeane aukópovo xoko tutíhiko sasedóti yoko po'ínuhiko teyonéti xapákuke tuti jûdeu. Yane kuríkopa neko tirinta koeti pe'u tiûketi, péhu xokóyokehiko koane kíxovokoxea: ");
INSERT INTO terNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Koati hána'iti mbahúnevo, vo'oku ako váhere ítuke ne hóyeno ngurí'okopikenoe. Ina kixoáhiko: —Keyumákapune. Yoúkekemo yóno ne koekúti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ina kurihíkopa Njûda ne tiûketi kúveuke neko hána'iti imokóvokuti. Yane ipúhikopeanehiko ina kotitínoponovo. ");
INSERT INTO terNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yane veyópane tutíhiko sasedóti neko tiûketi koane kó'iyeahiko: —Ako yusíka vípihea ra tiûketi xoko unákovoku tiûketi íparaxeokonoke Itukó'oviti, pôreu xanéhiko, vo'oku itúkeovo ésa'i óvokeovo íti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kousókonehiko isóneunoa, ina vanêxo itátane poké'e yane tiûketi xoko véyokuhiko móte ne ipôti, itukópatihiko ekóxopoku ivokóvotihiko ákoti itukapu íhae ne poké'exa. ");
INSERT INTO terNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Énomone kutí'ino iháxeokonoti “Poké'exa Íti” neko itátane poké'e tukú koeti kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Énomone yanê'e, koúsokovone neko kúxoti yutoéti ya emó'uke Itukó'oviti, yútoe porofeta Njerémiya, enepone koêti: “Eneponeko tirinta koeti pe'u péhu, ésa'ixeake po'ínuhiko íhae Izarâe neko hóyeno, ");
INSERT INTO terNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","énomone veínoa vanéxeahiko itátane poké'e xoko véyokuhiko móte ne ipôti, kuteâti páhoenonu Vúnae kó'iyeaneye” koêti. ");
INSERT INTO terNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yoko xe'ó kóyene ne Jesus nonékuke Pilátu, enepone ngovenâdo. Ina kixôa Pilátu: —Ití'oxo natina jûdeuhiko? Ina yumopâ Jesus: —Enepone yépemonuke, kaúhapu'ikoa indúkeova —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yane koyúhoa tutíhiko sasedóti inuxínoti jûdeu hó'eke ápeyea váhere ítuke ne Jesus. Kúteanemaka yûho ne po'ínuhiko teyonéti xapákuke tuti jûdeu, itea ako yumápa Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ina kixôa Pilátu: —Ako kéma ra êno yihó'inokono? ");
INSERT INTO terNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Itea yunu-yunú koéne ne Jesus. Ako ápahuina yumópeake. Koati hána'iti iyúpaxeova Pilátu. ");
INSERT INTO terNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yóko'o yaneko káxehiko, kaxena áyui jûdeuhiko, kóyekune kuríkopea póhuti iká'aeti ne Pilátu, koêkuti épemone xanéhiko kuríkopeokono. ");
INSERT INTO terNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yaneko káxehiko, ápe iká'aeti koéhati Mbarâba, éxone heú koeti xâne vo'oku váhere ítuke. ");
INSERT INTO terNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Koeku ho'uxoké kóyeyea neko xanéhiko, hara kíxovokoxoane Pilátu: —Kuti kehá'a nguríkopinopeanoe, Mbarâba? áko'o Jesus, enepone iháxoneti páhoe Itukó'oviti koíteovo xâne, enepone Mésiya kixoneti —kíxovokoxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yoko éxoa Pilátu ímaikinovo Jesus ne tuti jûdeu vo'oku íyokeovahiko xunáko kutí'inoke kurikoâtihiko xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Koeku óvoheixea Pilátu yuhoíkovokutike, apé koene ominoâti yuho yêno. Hara koe yuho páhoenoa: —Néxipa ne yâha kíxi ra hóyeno ponóvoti kixoku itúkeovo, vo'oku yara yóti, ngoítoponovo kotíveti ya njopúneke vo'ókuke ra hóyeno —kôe. ");
INSERT INTO terNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Itea enepohikoneko tuti sasedóti yóko'o neko po'ínuhiko teyonéti xapákuke tuti jûdeu, ítokuxo okóvo xanéhiko épemea itúkeovo Mbarâba kurikópokono koeku koépekeokonomo ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ina kixovókoxopamaka Pilátu neko xâne: —Kuti kehá'a nguríkopea yara pi'âti? Ina yumopâhiko: —Hane kiríkapinavi Mbarâba. ");
INSERT INTO terNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ina koepómaka ne Pilátu: —Kene ra Jesus iháxoneti Mésiya, na ínjaye? —Kirúhuxa —koénehiko uhá koêti neko xâne. ");
INSERT INTO terNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—Kutí'ikopo itúko pahúnevo ra hóyeno? —kíxovokoxopanemaka Pilátu. Itea inamá'axo koxunáko vaúkexea neko xanéhiko kónokea kurúhuxeokono ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Noixoâne Pilátu ákoyeanemo íta ípokea isóneuhiko koane yupíheovo ukóponea omoxohí kó'iyea yoko ímaikexeovo neko xanéhiko, yane pahúkone veyóponeokono úne. Ina kipovó'uxovo nonékuke neko xanéhiko koane kó'iyea: —Hainamo oúngeke yóno itína ra hóyeno (ponóvoti kixoku itúkeovo). Itínenoemo exâ koêku enepo yakahá'a képeki —kíxovokoxoane Pilátu. ");
INSERT INTO terNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yane hara koéne uhá koêti neko xanéhiko: —Kayumákapunemo itúkeovo voúkeke yóno itína yoko oúkeke xe'éxaxapa ûti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yane kuríkopinoanehiko Pilátu neko Mbarâba. Ina pahûko yehépoke'exeokono Jesus yane kurí'okoanehikomaka kurúhuxoponea. ");
INSERT INTO terNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Énomone yanê'e, enepohikone húndaruna Pilátu, omopo Jesus óvokuke Pilátu, enepone óvokumaka natíxea. Yane heú kíxoane ho'úxea ne po'ínuhiko húndaru xoko Jesus. Yakuku-yakukú kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yane veyónehiko ípovo Jesus, ina iko'ípovoxoahiko harará'iti ipovóti kuteâti ípovo nâti hamá koêti, ");
INSERT INTO terNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ínamaka itukínoahiko kôroa. Yoko ainóvoti ka'áveti káva'o tikóti veínoa úhekexea, ina ipíhea tutíkuke koane itúkinoahikomaka puló'ina, ómo'ixone éxopeke vô'u kuteâti koeku ómo'ixone nâti, hoénaxovope itúkeovo pahúkoti. Yane ina ipuyúkexinoahiko húndaru koemóke'eati koane kó'iyeahiko: —Iháyu'ikakana ra natina jûdeuhiko —koénehiko koémoke'eyea. ");
INSERT INTO terNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ínamaka apurú'okoahiko koane ipúsopu'ikeahiko yane pulô'i ómo'ixone. ");
INSERT INTO terNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Uke'éxoanehiko komóhiyea, ina veyopeâhiko ne harará'iti hamá koeti ípovoxeakemekuhiko, ina itukópinoamaka ne koati ípovo. Úkeane omáhiko kurúhuxoponea. ");
INSERT INTO terNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Koeku píheahiko kurúhuxoponea Jesus, tokononé koénehiko hóyeno koéhati Símaum, íhae pitivóko koéhati Sîreni. Énomone íkoinoxohiko kurúhuna Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yane simónehiko ya xoko iháxoneti Ngoûgota. Yoko “óvoku opepú'iti” koêti ne Ngoûgota koêti. ");
INSERT INTO terNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ina porexóhiko Jesus víyum apêti ánahi kosuvá'ikoati, iyuhii kixoti ohonéti. Itea hixopâne Jesus, ako akáha'a. Ákomaka énapa. ");
INSERT INTO terNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yane kurúhuxoanehiko. Ínamaka haxakéxokokoahiko ne ípovo Jesus. Yoko kuríkohiko inúxotike komomâti itukóvotiye ítukemo póhutihiko kó'iyeovoku ípovo Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yane vaataka kóyenehiko ne húndaru koyonoâti ne kurúhuxone. ");
INSERT INTO terNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ápemaka yutoéti tutíkuke ne kurûhu ípihonehiko, koyuhoâti kurúhuxinokonoke. Hara kôe neko yutoéti: “Jesus râ'a, natina jûdeuhiko” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yoko ápemaka pi'âti ómevoti, ha'ine Jesus kurúhuxeokono. Poéha éxopeke, poéhamaka lopékuke. ");
INSERT INTO terNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ápemaka xâne hunoneâti, koemóke'eti Jesus koane kayakákinoati tûti. Hara koéhiko: ");
INSERT INTO terNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Mahi ketohíneatimo ne sasá'iti óvoku Itukó'oviti koane mahi kexépukopatimakamo ya kúveu mopo'âti káxe, keítapapuikopo itikápuxo koati Xe'exa Itukó'oviti, koane yevésekapi ne kurûhu —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kúteanemaka kíxoaku tutíhiko sasedóti koémoke'eyea, koánemaka ne éskiriba, enepohikone ihíkaxoti yútoe Muîse, koánemaka ne po'ínuhiko teyonéti xapákuke tuti jûdeu. Hara koéhiko: ");
INSERT INTO terNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Eneporâ'a, koítovopepo po'ínuhiko xâne itea kó'oyene ákone xunáko koítopeovovo. Hainá'ikopo natina Izarâe? Evésekapeakopo ne kurûhu, ínamo vakutípoa. ");
INSERT INTO terNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Hainá'ikopo koati kuvóvoti Itukó'oviti râ'a? Naíxavo ûti kahá'ayea koíteova Itukó'oviti kó'oyene, vo'oku koyúhopepo itúkeovo Xe'exa Itukó'oviti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Koánemaka neko ómevoti ha'ine Jesus kurúhuxeokono, koémoke'eamaka. ");
INSERT INTO terNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ukeâti itumúkoti káxe tukú koeti mopo'âti ôra ya kiyakáxe, hahamó kôe uhá koeti kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ya kuteâti mopo'âtimea ôra ya kíyo'i káxe, koati kohonókoti emó'u ne Jesus. Hara koe yûho: —“Eli, Eli, lema sabakitáni?” koéne. Yoko “Unaém, Unaém, na koeti kurí kixínenu?” koêti neko yûho. ");
INSERT INTO terNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","—Îliya iháxiko nê'e —koéhiko ne po'ínuhiko xâne kamoâti. ");
INSERT INTO terNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ina ehakóvo póhuti xapákuke neko xâne veyopónoti esponja kalaká'ikopoinoati xoko viyum-hí koêti, ina ipíhoa kirípuhike étakati ipíhoati pahákuke Jesus iyúkoati. ");
INSERT INTO terNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Itea ápe po'ínuhiko xapákuke neko xâne koêti: —Hákoxovo. Vokómomavo koíteovaxomo Îliya —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ina apépomaka koati êno hónoti emó'u ne Jesus. Yane îhunokoane ne omíxone kuri'ókopati xoko Itukó'oviti. Yane ivókovone. ");
INSERT INTO terNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yoko énomone yaneko ókoku ôra, ívarereo neko êno kopópoti váhere haxakoâti kúveu neko hána'iti imokóvokuti. Koati kukúkeke ívarereo ukeâti vanúkeke yonoti poké'eke. Iyúyomaka ne poké'e epó'oxo ítaukexomaka ne mopôi. ");
INSERT INTO terNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Koane imíhe'okopohikomaka ne ekóxovoku kasása'iupo Itukó'oviti ivokóvotine, yoko enómaka exepúhikopotiya. ");
INSERT INTO terNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ike exépukopine ne Jesus ukópea xapa ivokóvoti, exépuhikopomaka neko ivokóvoti ukopeâti xoko ekóxovoku, koane úsa'ixovahiko ne Njeruzálem, enepone iháxoneti Sasá'iti Pitivóko, koane êno xâne noixópatihiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Eneponeko tuti húndaru yóko'o neko po'ínuhiko húndaru, ha'íne kóyonoyea Jesus xoko kurúhuxovoku, noixoânehiko iyúyoyea ne poké'e koane ápeyea uhá koêti neko po'ínuhiko koekúti, yupihovó koénehiko píkea. Hara koéhiko: —Koati kaná'uteoxo itúkeovo Xe'exa Itukó'oviti ra hóyeno —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yoko enómaka senóhikoya ákoti malîka okínoaku ixómoyea komóma. Aínovonehiko neko xáneheixone Jesus ukeâti Ngalíleyake ixómotihiko katarákoa ya nókoneke. ");
INSERT INTO terNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Xapákuke neko senóhiko, ápe Mariya Mandâlena; koane po'ímaka Mâriya, enepone êno ne kopo'ínukokoti Teâku yoko Yûse; yoko yêno Nzebêdeu. ");
INSERT INTO terNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kiyoné'e káxe, sîmo hóyeno iríku koéhati Yûse íhae pitivóko koéhati Arimáteya. Enepone hóyeno, íhikaumaka Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Eneponê'e, pîho xoko Pilátu epemóponoati yusíkea veyópea muyo Jesus kuruhúke. Yane pahúkoane Pilátu poréxopeokonoa ne muyo Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Veyopâne Yûse, ina aupíxoa ya koati sasá'iti kalísoti ipovóti líyum, ");
INSERT INTO terNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ina ipíhoponoa kúveuke neko uhôro kehoéti mopoíke âvoti ekoxóvati, ínamaka kohokôroroko êno pú'iti mopôi exéxeake ne uhôro. Yane pihópone. ");
INSERT INTO terNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yoko ápe ne Mariya Mandâlena koáne ne po'inu koéhatimaka Mâriya vataká koyêtihiko nonékuke ne ekóxovoku Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Poéhapoane káxe ikéne, énomone yaneko sâputu, ho'úxovonehiko ne tutíhiko sasedóti inuxínoti jûdeu hó'eke yóko'o ne farîzeuhiko. Ina pihohíko xoko Pilátu. Hara kixóponoahiko: ");
INSERT INTO terNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Puyákoponova vokóvo emó'u neko semékenovo'iti avô'o ivakápu. Hara koé'epepo: “Mopó'amo káxe ike engóxinevo, enjepúkopotinemo” kôe. ");
INSERT INTO terNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Poéhane pehúki kókoyuse kíxeokono kóyonoyeokono ne ekóxovoku tukú koêti neko mopó'ape káxe, mará'inamo améxapanea íhikauhiko mûyo, okóyuhoinoamo xanéhiko itúkeovo exepúkopotine. Yane mani yupihovó koeti váherexea hunókokuke yane inúxoti semékenovo'i —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ina kixoáhiko Pilátu: —Anéye ra húndaruhiko. Pihénenoe. Koêkuti yâha motovâti títiu kóyeyea kóyonoyeokono, itínenoe exâ kíxoaku —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Úkeane pihohíko. Ixíkoahikoya koyonoâti neko ekóxovoku Jesus. Ípihinoamaka hoénaxope xoko êxe ne ekóxovoku motovâti iyúseyea áva yuhó'ixoati. Yane ôvoheixoanehiko ne húndaru koyonoâti. ");
INSERT INTO terNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Evesékone ne sâputu, yuponii koeti lûmingu, pîho Mariya Mandâlena koánemaka ne po'i koéhati Mâriya, noixóponoati ne ekóxokonoku Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yoko apé koéne xúnati iyuyôti poké'e vo'oku símeane ánju ukeâti vanúke, ovoxe Vúnae veyopâti neko mopôi, exéxeokonoke ne ekóxokonoku Jesus, ina ivatáko oúkeke. ");
INSERT INTO terNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kutí koe uhápu'ine ipixéneneoti neko ánju. Hóhopu kóye ípovo kuteâti koeku hopú'iko imatákoti. ");
INSERT INTO terNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yupihovó koene píkea ne koyónotihiko, koane ínayea honóno'okohiko. Kutí koénehiko ivokóvotine. ");
INSERT INTO terNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yane ina kixôa ánju ne senóhiko: —Hákonoe píke. Énjoa itúkeovo Jesus yopósikopono, eneponeko kuruhúxoneti. ");
INSERT INTO terNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Áko'one yâyeke nê'e. Exépukopone kuteâti yuhó'inopi yanekôyoke. Yókonenoe, yokómomoponoapihi ra ekóxokonoku. ");
INSERT INTO terNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yéhakapunoe, yéta'akapana íhikauhiko exépukopeane Únae ukópea xapa ivokóvoti koane inuxó koépea tumúnekehiko ya Ngalíleya. Yâkonoye, noixópatihikomo. Koati kaná'uti ra yunzó'inopinoe —kíxoanehiko ánju. ");
INSERT INTO terNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Úkeane pihopóhiko ehákopeovo ukópea xoko ekóxokonoku Jesus. Koati konóko'itihiko xaneâti êno hána'iti elókeko okóvo koeku ehákeovo éto'okoponea ne íhikauhiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yane apé kó'inoane Jesus tumúneke. —Aúhepeponoe iséneu —kíxoanehiko. Yane ahí'okovane senóhiko. Ipuyuké kó'inoanemaka koane opóno'ekea hêve ihayú'ikoati. ");
INSERT INTO terNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ina kixoáhiko Jesus: —Hákonoe píke, itea íxepana ne ínzikauhiko, enepone kutí ngíxone mbo'ínuhiko, píheamo ya Ngalíleya. Énomonemo noíxopeonuhiko —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Koeku píheako ne senóhiko, ápe xapákuke neko koyónoti ekóxokonoku Jesus aukópovoti pitivókoke éto'okoponea ne tutíhiko sasedóti uhá koêti neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ina ho'uxóvohiko neko sasedóti koánemaka ne po'ínuhiko teyonéti xapákuke tuti jûdeu. Yane poréxoahiko êno tiûketi ne húndaruhiko koyónoti ekóxovoku Jesus koane kíxeahiko: ");
INSERT INTO terNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Yokóyuhoanoemo itúkeovo íhikauhiko omexóponea mûyo ya yóti koeku imékinoe. ");
INSERT INTO terNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Enepomo eyekáxa ngovenâdo ne koekúti, kotixópitimo ûti nonékuke. Síkeanemo, vexoâtimo kíxoaku ûti. Yane ákonoemo yuvópiti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yane namúkoane koyónotihiko neko tiûketi. Úkeane pihohíko itukoâti kuteâti ne íhikaxokonoke koyúhoyea. Énomone koéneye itóhineyea xapa jûdeu oméxoponeokono ne muyo Jesus. Yoko anéyeiko tukú koeti kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Úkeane pihohíko ya Ngalíleya neko unze koeti íhikau Jesus xokóyoke neko kali mopôi kixínoake Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Noixónehiko Jesus, ipuyuké kó'inoane iháyu'ikea, itea ápe xapákukehiko ákoti koâti kutípea itúkeovo Jesus. ");
INSERT INTO terNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ina ahi'ókovahiko Jesus. Hara kíxovokoxoa: —Mboréxokonoane ne uhá koeti xunakóti ya vanúke koáne ya poké'e. ");
INSERT INTO terNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pihénenoekopo xapa uhá koeti xâne, koêkuti poké'e óvohikoku yara kúveu mêum. Íhikexahiko hókeonu koane yáhikamaka ya iháke Itukó'oviti Nzá'a, koáne ya inzáke, undi Xe'éxa, yoko ya iháke Sasá'iti Omíxone Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Íhikexamaka itúkea uhá koeti mbáhoenopinoe itíki. Yoko anéyemom xikóyokenoe uhá koeti káxe tukú koeti hunókokukemo ra mêum —kíxovokoxoane Jesus. Hunókokune.");
INSERT INTO terNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hara kôe kixoku koêku inâ turixôa Jesus Kristu, enepone Xe'exa Itukó'oviti koyúhoyea ra inámati ihíkauvoti omínovike. ");
INSERT INTO terNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Koati kuteâti koeku yuho Itukó'oviti yútoeke Izâiya. Hara kôe: “Mbahukoâtimo timúneke ne koyuhó'inonutimo emó'um maka míhe'akinapine yoxéne itíki índukexeopikemo xapákuke xâne. ");
INSERT INTO terNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Énomonemo ne kohonókoti emó'u ya mêum ákoti apêti xapa xâne kamokénoponoati. Haramo koe yûho: ‘Míhi'akinanoe oxéne ne Vúnae itúkea ítuke xepákukenoe. Kéyusea kixeku itíkivo nonékuke’ koetímo” koe yútoe Izâiya. ");
INSERT INTO terNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yoko énomone koéneye yaneko simoné'e ne Xuaum Mbátita yaneko mêum ákoti apêti koyuhó'inoati ne xanéhiko nókone itúkea motovâti áhikexeovo xokóyoke. Koyúhoinoa kónokeahiko ikótivexea isóneuke ne pahúnevo koane kuríkopea motovâti kotúyopinoa Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Heú kôe neko íhae Njúdeya koánemaka íhae Njeruzálem píhea kamokénoponoti Xuâum. Yane áhikexoa Xuâum ya huvêo, enepone Njôrdaum, enepo koyuhópohiko pahúnevo. ");
INSERT INTO terNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoko evo'i kámelu itúko ípovo neko Xuâum. Vakamóto itúko hô'e. Vohóho yoko ho'o mópo íhae mêum itúko nîka. ");
INSERT INTO terNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hara koe yûho xapa xâne: —Ya ingénepoke, harakénemo koati hána'iti teyonéti ya undíke. Muhíkova anjí'okeova ngúxeinoa imo perékatana, ako omóndokea. ");
INSERT INTO terNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kaná'uti ánjikeopinoe ya úne, itea eneporakéne, ahíkotimo xanéhiko ya xunákoke Sasá'iti Omíxone Itukó'oviti kene haînati ya úne —kôe. ");
INSERT INTO terNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Énomone yaneko káxehiko, kenó'okone Jesus ukeâti Nazâre, pitivóko ya Ngalíleya. Yane áhikoane Xuaum Mbátita ya húveona Njôrdaum. ");
INSERT INTO terNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ehá'axo ipúhikopea úneke ne Jesus, noíxone imíhe'okea vanúke koane evésekea xokóyoke ne Sasá'iti Omíxone Itukó'oviti kutí koeti kurûte. ");
INSERT INTO terNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yane apé koene emo'úti inu'íxoti vanúkeke koêti: —Iti Nje'éxa koati ákoti omotóva ongóvo, perexónuti hána'iti elókeko ongóvo —koêti. ");
INSERT INTO terNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ikénepoke ne koekúti, iyónoa Sasá'iti Omíxone Itukó'oviti ne Jesus ya mêum ákoti apêti. ");
INSERT INTO terNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Koarenta koe káxe óva koane hixópea Satánae íkorokea pahunévotike. Yoko poéhane ipúhokovotihiko hó'openo apê yaneko óvoheixoku. Itea káxunakopo Jesus ne ánjuhiko, enepone ovoxe Itukó'oviti ukeâti vanúke. ");
INSERT INTO terNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ika'ákovone Xuaum Mbátita, ina aukópovo ne Jesus ya Ngalíleya koane koyúhoyea ne inámati ihíkauvoti omínoke xâne. ");
INSERT INTO terNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ká'aye koe yûho: —Simóvone kaxena natíxea Itukó'oviti xapa xâne. Koati kaxénane turíxeovomo. Ikétivexa iséneuke ne pehúnevo koane kiríkapa. Yakútipoamaka ra inámati ihíkauvoti ínzikaxopikenoe —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Koeku yónea ne Jesus xe'ókuke ne Mar-na Ngalíleya, tokononé koene pi'âti kopo'ínukokoti, Símaum yoko Ándere ixómoti kurîko númikuxope, koáhati itúkovokenehiko. ");
INSERT INTO terNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ina kixôa Jesus: —Hekánunoe! Hainá'ikomo hôe yíxovonoe, itea indukópopitinenoemo ihíkaxoti xâne hókeonu —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ehá'axo uké'exo koyúhoyea ne Jesus, kurí kixónehiko númikuxope neko pi'âti, pihónehiko ikéneke Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ya kali tumûneke, tokononé koéponemaka po'i pi'âti kopo'ínukokoti, Teâku yoko Xuâum, xé'ahiko Nzebêdeu. Vatékenake óvoheixo ixómoti koyúseopo númikuxope. ");
INSERT INTO terNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ítaikoane Jesus neko pi'âti hókea. Yane kurí kixónehiko há'a koane ahínoe vatékenake. Pihónehiko ikéneke Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Úkeane pího pitivóko koéhati Kafanâum ne Jesus yoko íhikauhiko. Yaneko sâputu, pihónehiko ya sinâgoga, enepone íhikaxovoku hó'e jûdeuhiko, ina ihíkaxo ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Enepohikoneko xâne kamokénoati, yupihovó koéhiko iháyu'ikea kixoku íhikaxea, vo'oku koati iyúseoti itúkeovo úkeakune xokóyoke ne hána'iti exóneti íhikaxone, kene haina kuteâti ne éskiribahiko, enepone ihíkaxoti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Énomone yanê'e, apé koéne hóyeno ûroevo ndémoniu kohonókoti emó'u yaneko íhikaxovoku hó'e jûdeuhiko. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesus, íhae Nazâre, na koeti yího'ixopoinovi? Simínetine yuké'exoponivi? Énjoa itíkivoa ne sasá'iti páhoe Itukó'oviti —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ina saya'íkoa Jesus neko ndémoniu. Hara kíxoa: —Hákone keyûho. Ipíhikapi ra hóyeno! —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ina vaûko ne ndémoniu. Koati xúnati koyúyu'okea ne hóyeno óvoheixoku, yane ipúhikopeane. ");
INSERT INTO terNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yupíhova iyúpaxeova uhá koeti xâne noixoâti koane kíxeokoko: —Kutimea kixó'eko? Koatímea inámati ihíkauvoti íhikaxo. Koati apêti hána'iti xunáko pahúkea ipúhikopea ndémoniu urúkovoti xoko xâne. Koáne koati ipuhíkopoti ne ndémoniu enepo pahukópa ipúhikopea —kixókokone. ");
INSERT INTO terNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Énomonemaka ákoino oríko ákoyea malíka yónoku iha Jesus iháyu'ikeokono ya uhá koeti Ngalíleya vo'ókuke neko ítuke. ");
INSERT INTO terNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ipuhíkopeanehiko sinâgoga, enepone íhikaxovoku hó'e jûdeuhiko, xanépoane Jesus ne Símaum yoko Ándere. Ponokó koépeane óvokuke. Ápemaka Teâku koane Xuâum po'i xanépone. ");
INSERT INTO terNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yoko kótuti mûyo ne imose Pêturu. Ípeke óvoheixo. Ehá'axo sîmo Jesus, koyúhoinokonoa yuvâti ne imose Pêturu. ");
INSERT INTO terNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ina pího Jesus xokóyoke, namú kíxeane vô'u. Yane uké'epone neko otuko mûyo, exépukopone, yane kátarakopo evo Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kahá'atine onómekeovo káxe yanekôyo, omókononehiko xoko Jesus heú koêti neko ka'aríneti, koánehikomaka ne xâne ûroevo ndémoniu. ");
INSERT INTO terNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ho'uxo-ho'uxó koénehiko heú koêti neko xâne íhaenehiko neko pitivóko páhapeteake óvoheixoku Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Koati ênoti ka'aríneti koítovone Jesus. Yoko ako tôpi kó'iyeovoku arínehiko. Kópuhikopamaka Jesus ne ndémoniu xoko xâne ûroevo. Ákomaka síka Jesus ne ndémoniuhiko koyúhoyea vo'oku éxeahiko itukóvotiye ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yanekôyoke hahá'itiko, exépukone ne Jesus ina pího ákoyeakuke apêti. Ôvane itûko orásaum. ");
INSERT INTO terNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kene Simaum Pêturu yoko ha'ínehiko, ako tôpi yónoku oposí'ixopotihiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Inixóponoane, ina etó'okoa enó'iyea xâne oposíkoati. ");
INSERT INTO terNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yane hara kíxovokoxoa Jesus: —Hingá, piháne ûti po'íke ipuxóvokuti ákoti ahikâ ra vóvoheixoku maka ongóyuhoinoanemaka emo'u Itukó'oviti. Koáhati énomone nzimíno —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yane úkeane ukopóno ya uhá koeti ípuxovoku xâne ya Ngalíleya koyuhoâti ya íhikaxovokuke hó'e jûdeuhiko ne inámati ihíkauvoti íhikaxone, koánemaka kópuhikopea ndémoniu xoko xâne ûroevo. ");
INSERT INTO terNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ina ahi'ókovo Jesus ne hóyeno yúvone koati váhere arinéti iháxoneti lépara. Ipuyuké koéne nonékuke Jesus koane kíxea: —Yakahá'a, motóva keítivonu yara arínem —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Noixoâne Jesus, yupíhova kóseanayea ina sipo'ókoa koane kíxea: —Ngahá'a, itévone —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ehá'axo koyúhoa Jesus, má koépone neko aríne, unátipone. ");
INSERT INTO terNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ina pahukôa pihópea koane í'ixiko'o kíxoixea: ");
INSERT INTO terNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Hako keyuhó'inoa koêkuti xâne ra índukeinopi, itea ponó yákoe yéxokoponivoa ne sasedóti inuxínoti xâne hó'eke. Yamína iké'iparaxoke Itukó'oviti kuteâti páhoenovi yútoe Muîse, yéxokovope itúkeovo yunatípotine —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Itea koeku pihópea neko hóyeno koane koyúhopea ne kixókonoku xapa xâne. Koati yupihóvoti kotóhineyea neko koekúti. Énomone ákoino omótova símea ne Jesus ya koêkuti pitivóko mani yónoku, vo'oku mani yupíheovo êno xâne ho'uxínovati. Hukinóvoti itúkeovo mêum ákoti apêti óvoheixo itea kóyeane ákoyea yumáxapu xâne pihinoâti ukeâti pitivóko yoko ipuxóvokutihiko ákoti ahikâ. ");
INSERT INTO terNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kali ye'á koe káxe ikénepo, ina aukópovo ne Jesus ya Kafanâum. Ákomaka oríko eyékoxeokono seópeane óvokuke. ");
INSERT INTO terNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yupihovó koéponemaka êno xâne simoâti. Simóya meúkeke xe'ókuke páhapetea neko óvoku, ákone okokútiya vo'ókuke neko êno xâne, koane koyúhoinoa Jesus emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ápehikomaka xâne ominoâti hóyeno isayú'ixovoti ákoti ehevákapu mûyo. Yoko koaturu kôe neko hóyeno koinoâti. ");
INSERT INTO terNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ako omótova ahí'okoponeovohiko Jesus vo'ókuke neko êno xâne. Yane kohínokoahiko ne ramápu'i péti koati oúkeke ne ókoheixoku Jesus. Énomone évekoahiko neko isayú'ixovoti, ixané kixínoa poúke. ");
INSERT INTO terNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Noixoâne Jesus itúkeovohiko koati kuvovâti, ina kixôa neko isayú'ixovoti: —Nje'exá, itúyoponehiko pehúnevo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yoko ápe éskiribahiko, enepone ihíkaxoti yútoe Muîse vataká koyêtiya. Hara koe isóneunoa kamôa: ");
INSERT INTO terNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Na koeti kó'inoneye yuhó'inoa ne hóyeno? Koati itûkovoti Itukó'oviti vo'oku ako kotuyôpoti pahunévoti ákoti itukapu Itukó'oviti, poéhane motovâ kíxeaneye xâne” koene isóneuhiko. ");
INSERT INTO terNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Exó kíxeane Jesus isóneuhiko ina kixovókoxoa: —Na koeti kó'inoneye iséneu? ");
INSERT INTO terNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kuti itukóvoxo ákoti hé'onoke'e ngíxea ra isayú'ixovoti: “Itúyopone pehúnevo?” áko'o “Yexépukapa, viyapa peúke, yenápa” ngíxea. ");
INSERT INTO terNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Itea kó'oyene enjókopitinoe ápeyea njunáko yâye yara poké'e ngotúyopea pahunévoti, undi íhae vanúke ikútipasikoponovoti xâne. Ina kixôa Jesus ne isayú'ixovoti ákoti ehevákapu mûyo: ");
INSERT INTO terNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Mbahúkopi yexépukopi, viyápa ne peúke, pihépane yóvokuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yane xépu koépone neko hóyeno ákoti ehevákapu mûyo. Omoo kixópone poúke nonékuke neko uhá koeti xâne. Úkeane pihôpo. Êno xâne iyupáxovati koane iháyu'ikea Itukó'oviti vo'ókuke. Hara koéhiko: —Ako noíxeaku ûti kuteâti —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yane aúkopovonemaka ne Jesus xe'ókuke ne Mar-na Ngalíleya, koane êno xâne pihinoâti. Íhikaxoamaka Jesus uhá koêti neko xâne. ");
INSERT INTO terNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Koeku yónea ne Jesus, noíxone Lévi, xé'a Áfeu, enepone koperáxinoti nâti, vaata koyêti xoko kóperaxoku, ina kixôa Jesus: —Kiná'aka ingéneke —kíxoane. Yane xepú koéne ne Lévi, pihóne hókea Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ikénepoke, ixómoti níko ne Jesus yoko íhikauhiko óvokuke Lévi. Yoko êno po'ínuhiko koperáxinoti nâti kaha'íneati, enepone yómoti ánu'ukea kóperau, koane enómaka po'ínuhiko xâne pahukóvoti. Koáhati ênoti xâne kuteâti nekôyohiko hokó'ixoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Enepohikone éskiriba hokoâti ne isóneu farîzeu, noixónehiko Jesus ínikea neko xanéhiko pahukóvoti koáne ne koperáxinotihiko nâti, hara kíxo íhikauhiko Jesus: —Na koeti ínikinoa ihíkaxopiti ne váhere xâne, enepone koperáxinoti nâti koáne ne po'ínuhiko xâne pahukóvoti? ");
INSERT INTO terNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kameáne Jesus neko yûho, hara kíxovokoxoa: —Enepohikone ákoti yuvâti, ako okónoko ipixáxoati. Poéhane ka'aríneti konokôa. Haina nzimínoti xâne ponóvoti kixoku itúkeovo, itea nzimínoti xâne pahukóvoti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Po'íke káxe jejuá kôe ne íhikauhiko Xuaum Mbátita, yuixóvoti ikóseanaxeovo Itukó'oviti. Kúteanemaka kixoku itúkeovo farîzeuhiko, enepone yuixóvoti hókea yútoe Muîse. Yane ápe xâne kixopónoti Jesus: —Jejuá kôe ne íhikauhiko Xuaum Mbátita koáne ne íhikau farîzeu. Kene ne íhikeuhiko, na koeti ákoino jejuá ákoe? ");
INSERT INTO terNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ina yumopâ Jesus: —Yusíkoikopo jejuá kó'iyea ne hupiúti áyuike kasâtuxoti koêkuiko ápeyea ne koyénoti xapákuke? Ako kalíhuina kó'iyeaneye. ");
INSERT INTO terNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Itea simóvotimo káxe veyópeokonokumo ne koyénoti xapákuke. Yane ínamo jejuá akôe yaneko káxe —kíxovokoxoane Jesus kixopóvoti yane éxetina. ");
INSERT INTO terNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ina kixovókoxopamaka Jesus: —Ako veyoti inámati ipovóti itukoâti ihápa'akope yékoteno ipovóti, vo'oku mani koukóponoati ívarereoku ne yékoteno ipovóti —kíxovokoxoanemaka, ihókoati inámati ipovóti ne ihíkauvoti íhikaxone ákoti akutêa ne kúxoti hó'e xâne. ");
INSERT INTO terNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ina koe'íkomaka: —Ákomaka yusíka unákeovo inámati víyum ya yékoteno íhaku, itukéti ya vakamóto, mará'inamo ívarerea ne yékoteno íhaku enepo ihiyáka ne inámati víyum. Yane mani evókovoti ne víyum koánemaka ne íhaku. Itea konókoti ímeokono inámatike íhaku ne inámati víyum. Yane ako évakapu ne íhaku koáne ne ovâti —kíxovokoxoane, itúkoti po'i íhokoake ne ihíkauvoti íhikaxone. ");
INSERT INTO terNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Vekoâti evo Jesus ne kali xêne vekoti kavâne ya xapa itóvope ha'i nonéti. Yoko sâputu nekôyo, káxe sasá'itino jûdeuhiko. Koeku vékeahiko koane véyea ne ha'i nonéti. ");
INSERT INTO terNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ina kixoáhiko farîzeu ne Jesus: —Yokómoma kixóvoku ne íhikeu itúkoti ákoti parexá'avea hó'e ûti vitúkea ya sâputu. ");
INSERT INTO terNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ina yumopâ Jesus: —Ákoikopo yíhoikiku ya emó'uke Itukó'oviti koeku ítuke ne Ndávi yaneko epékoa hímakati mekúke yoko ha'ínehiko akô'o véyeakuhiko nîka? ");
INSERT INTO terNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ûrukova Ndávi neko óvoku Itukó'oviti ya kaxénake Abiáta, enepone koati payásoti ya uhá koeti sasedóti inuxínoti xâne hó'eke yanekôyo, ina nikôa neko pâum ikó'iparaxokonoke Itukó'oviti, upánini ako paréxa yútoe Muîse níkeokono. Poéhane sasedótihiko motovâ níkea. Yoko poréxoamaka Ndávi ne ha'ínehiko. ");
INSERT INTO terNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ina koe'íkomaka Jesus: —Itúkinoake Itukó'oviti ne sâputu, haina itúkoti téyone xâne, itea kaha'aînoati ne xâne unako koeku motovâti ómomikea. ");
INSERT INTO terNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Koeku kó'iyeaneye, koati ûndi exêa koêku ne sâputu, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ina urúkopovamaka Jesus ne sinâgoga, enepone íhikaxovoku hó'e jûdeuhiko. Yoko ápe hóyenoya timovó'uti. ");
INSERT INTO terNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ápehikomaka ixómoti ivokó'oko Jesus koíteovamo neko hóyeno, vo'oku itúkeovo sâputu yanekôyo. Koati oposí'ixoatihiko évekinoaku yuhóhiko itúkeovo pahukóvoti ne Jesus enepo kaitápa ya sâputu. ");
INSERT INTO terNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yane hara kíxoa Jesus ne hóyeno timovó'uti: —Yókone yâkeneye —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ina kixovókoxopamaka Jesus neko xanéhiko: —Kutí'ikopo pahúkinovi Ponóvoti Kixovókuti yútoe Muîse vitúkea ya sâputu? vitúkea únati? áko'o vitúkea váhere, koíteovo uti ka'aríneti? áko'o sikó kíxea ûti ivókeovo —kíxovokoxoane. Itea ako ápahuina yumopâti. ");
INSERT INTO terNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ina komomókexoa Jesus xaneâti ímaikinova, koane kotíveyea isóneuke vo'oku tiú'ikohiko omíxone. Ina kixôa neko hóyeno: —Kepáya'akapa ne veô'u —kíxoane. Koane kapáya'akopane, yane unátipone. ");
INSERT INTO terNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Úkeane pihohíko neko farîzeu xoko xanénahiko Êrodi, enepone nâti. Ho'úxovohiko opósikea kixókumo koépekea Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Úkeane pihôpo ne Jesus yoko íhikauhiko xe'ókuke neko Mar-na Ngalíleya. Kali êno xâne íhae Ngalíleya hokopâti. Koane ápemaka íhae Njúdeya, ");
INSERT INTO terNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","koane íhae Njeruzálem, yoko íhae Idúmeya noixóponoati, koánemaka íhae poixô'oke húveona Njôrdaum, yoko íhaehikomaka poké'e xe'o pítivokona Tîru yoko Sîdom. Koati ênoti xâne pihinoâti, vo'oku eyékoxeahiko koêku ne hána'iti iyupánevoti ítuke. ");
INSERT INTO terNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ina kixôa Jesus ne íhikauhiko kónokea usó kíxoixinoa kali vatéke okonókovo, puvâti Jesus yupíheovo hitití kíxeokono vo'ókuke neko êno xâne hokó'ixoati. ");
INSERT INTO terNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Koáhati yupihóvoti êno xâne koítovone Jesus, amátitikinokokoke uhá koêti neko êno ka'aríneti kaha'âti sipókoponea. ");
INSERT INTO terNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Koánehikomaka ne xanéhiko ûroevo ndémoniu, noîxo Jesus, ipúyukexeamaka nonékuke koane kóhonokea emó'u kó'iyeahiko: —Koati iti Xe'exa Itukó'oviti —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Itea koati í'ixiko'o kixoíxoati Jesus ákoyea okóyuhoa xapa xâne itúkeovo Xe'exa Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ina pího ne Jesus oúkeke kali mopôi koane iháxihikoa neko koati âha itúkea íhikau. Yane pihónehiko ne iháxiu xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ndusé kôe neko hóyeno, noívokoe xáneheixea koane itúkeovo páhoe xapa xâne koyúhoponea emó'u. ");
INSERT INTO terNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yane pôrekexoanemaka xunakóti kópuhikopea ndémoniu xoko xâne ûroevo. ");
INSERT INTO terNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Harâ'ahiko îha neko nduse koeti noívokoe: Símaum, enepone íhaxonemaka Pêturu; ");
INSERT INTO terNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","koáne ne kopo'ínukokoti, Teâku yoko Xuâum, xé'a Nzebêdeu. Enepora pi'âti kopo'ínukokoti, Mboáneje íhaxea Jesus. Yoko “húketi ímainevo kuteâti koeku húkeko puxârara” koêti ne Mboáneje koêti. ");
INSERT INTO terNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ina keno'ókomaka: Ándere; Filípi; Mbatulúmeu; Máteu; Túme; Teâku, enepone xé'a Áfeu; Tádeu; koánemaka Simaum Nzelóti; ");
INSERT INTO terNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yoko Njuda Iskarióti, enepone itûkoheovoti koeku hókea Jesus kurikoâtimaka xoko xanéhiko puvâti. ");
INSERT INTO terNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ina pihôpo ne Jesus óvokuke, itea kóyeane ho'úxopeovomaka êno xâne xokóyoke. Muhíkova níkea, ákone omótova vo'ókuke neko êno xâne xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eyekóxoane iyénoxapa Jesus kó'iyeaneye, yane pihínoanehiko kaha'âti omópea, vo'oku koyúhoyeokono itúkeovo pepokéxovotine. ");
INSERT INTO terNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yoko ápemaka éskiribahiko, enepone ihíkaxoti yútoe Muîse ukeâti Njeruzálem. Hara koémaka vo'ókuke: —Eneporâ'a, koati urúkovatine Mbezêbu, enepone pahúkoti uhá koeti ndémoniu. Énomone porexôa xunáko kópuhikopea ndémoniu urúkovoti xoko xâne —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yane ina ihaxíkoa Jesus ne xanéhiko ahí'okeovaxo, yane itúkinoa xêti apêti íhokoake ne âha íhikaxea. Hara kíxovokoxoa: —Yusíkoikopo itúkeovo Satánae kopúhikopovo xoko xâne ûroevo? ");
INSERT INTO terNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Itukovo apêti natixókuti óvoku xâne ixómoti okopókoko, uké'etinemo. ");
INSERT INTO terNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Koane itukóvomaka apêti ko'óvokuti ya póhutike ovokúti ixómoti okopókoko, uké'etinemo itúkeovo póhutine óvohikoku. ");
INSERT INTO terNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Eneponimaka itukapu Satánae okopópovo, koáne eneponi akapákakamaka ne ovóxehiko, mani uke'éxopokokotihiko. ");
INSERT INTO terNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Maní'ikopo motovâti ápeyea urúkeovati óvokuke koati xúnati hóyeno, koane omópea ítukevo ákoti ika'áka inúxotike? Konokoâti iká'akea inúxotike, ínamo itâ omópea uhá koeti apeínoati óvokuke —kíxovokoxoane Jesus, ihókoati xúnati hóyeno ne Satánae, koane ihókopovoti itúkeovo xunané'e ya Satánae. ");
INSERT INTO terNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ina kixovókoxopamaka Jesus: —Koati emo'úti ra yunzó'inopinoe: Motóva itúyopea ne heú koeti kó'iyeovoku váhere ítuke ne xanéhiko yara kúveu mêum, muhíkovamo ne koémoke'eyeahiko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Itea enepone koyúhoti itúkeovo ítuke Satánae ne ítuke Sasá'iti Omíxone Itukó'oviti, ákonemo itúyopeaku ne pahúnevo. Apê pahunévoti kuteâti, xané kixopâtimo xâne ivakápune —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kó'inokeneye yûho ne Jesus vo'oku koyúhoyeokono itúkeovo ûroevo ndémoniu. ");
INSERT INTO terNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Énomone yanê'e, símoane êno ne Jesus yoko ámeno. Meúkeke óvoheixohiko. Yane ápe páhoe ihaxíkoponoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yoko koati êno xâne vataká koyêti yakuku-yakukú kixoti Jesus. Ina kixokóno ne Jesus: —Anêko mémaina yoko pe'ínuhiko meúkeke oposíkoponopiti. ");
INSERT INTO terNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ina kôe ne Jesus: —Enepone ênom yoko mbo'ínuhiko, harâ'ahiko —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yane ina komomâ Jesus ne êno xâne ivatáhikoti yakuku-yakukú kixoâti, ina kôe: —Enepohikorâ'a, énomonemaka indúko ênom yoko mbo'ínuhiko. ");
INSERT INTO terNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Vo'oku koêkuti xâne itúkoti ahá'inoa Itukó'oviti, énomonemaka indúko koati mbo'ínu, mongéxa yoko ênom —koéne ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Káyukopovomaka Jesus íhikaxea xe'ókuke Mar-na Ngalíleya. Yupihovó koéne êno xâne pihinoâti. Vo'ókuke neko êno xâne, ûrukovo kúveuke vatéke ne Jesus ina ivatáko. Koane kali ahîkuxovo yâtike oévoke úne. Kene ne xanéhiko, ôvane yane poké'e xe'ókuke úne. ");
INSERT INTO terNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yane êno ihíkauvoti íhikaxone Jesus ya xêti apêti íhokoake ne âha íhikaxea. Hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Yakámokenonoe. Ápe hóyeno nopónoti ake nonéti. ");
INSERT INTO terNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Koeku kásahikea, ápe irihíkovoti xe'ókuke xêne. Yane kenó'okone hó'openo ôti nikohíkopati. ");
INSERT INTO terNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kene po'ínuhiko, îrihikovo xapákuke mopôi xoko ákoyeaku axú'ina móte. Koati ákotihiko oríko íhonopea, vo'oku ákoyea axú'ina móte xoko iríkovoku. ");
INSERT INTO terNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Itea ákomaka oríkoa oró'okea káxe vo'oku ákoyea yónoku poéheve. Yane movohí koéne. ");
INSERT INTO terNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","—Koane ápemaka irihíkovoti xapa tôpe. Yane inuxó koéne payákeyea ne xuve tôpe. Ákone oxéne payákeyea ne nonéti, vo'oku huruvokó kó'iyea tôpe. Yane ako há'i pôreupo vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","—Ina apémaka irihíkovoti únatike poké'e. Koati únati íhonopea nê'e. Payakéne, yupihovó koe êno há'i pôreupo. Ápe porexópoti tirinta koeti há'i ya póhuti áke úkeaku. Ina apémaka porexópoti sesenta koêti yoko póhuti séndu ya póhuti úkeaku —koéne íhikaxea. ");
INSERT INTO terNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ina koe'íkomaka: —Koêkuti kamoâti ra yûnzo, ivávaka —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pihopónehiko neko êno xâne, ápe po'ínuhiko xâne irikóvoti anavókoxopovati neko nduse koeti íhikau Jesus. Yane épemo'ikopohiko Jesus koêku ne éxetinameku apêti íhokovoke. ");
INSERT INTO terNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ina kixovókoxoa Jesus: —Koati itínoe porexókono éxea koêku ne natíxea Itukó'oviti xapa xâne ákoti po'i exoâti koêku neko koekútihiko. Itea xapákuke ra xâne ákoti itukapu xanéna, konókoti itúkeovo exetínati apêti íhokovoke veínoam ínzikaxeahiko. ");
INSERT INTO terNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yane upánini noíxoahiko, itea kutí koe ákoti inixâ. Koane upánini kámoa, itea ákomo éxina isóneu koêku. Yane ákomo aúkapapu njokóyoke, koane ákomo ngatúyapea pahúnevo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yane hara koé'ikomaka: —Enepo hákotinoe yexôa kixó'ekone ra énjetina kó'oyene, ná'ikopomo kíxeaye yéxi ra po'ínuhiko? ");
INSERT INTO terNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Enepone hóyeno nôti, kixo'êkoti xâne koyúhoti emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yoko enepone ake nonéti irihíkovoti xe'ókuke xêne, kixo'êkoti xâne kamokénoati ne emo'u Itukó'oviti, ina keno'óko Satánae veyopeâti isóneuke ne kámone. ");
INSERT INTO terNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kúteanemaka koêku ne irihíkovoti xapákuke mopôi xoko ákoyeaku axú'ina móte. Énomone ne xâne ákoti ika'ákarixapu namúkea ne emo'u Itukó'oviti koeku kámea, xaneâtimaka hána'iti elókeko okóvo ");
INSERT INTO terNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","itea ako áxu'ikene, itávokeane. Koati kutí koeti nonéti ákoti poéheve, vo'oku enepo simôa kotíveti koekúti, itukovo apêti ikoítoponoati kotíveti vo'oku kutípea ne emo'u Itukó'oviti, yane itavókeatine. ");
INSERT INTO terNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kene ne po'ínuhiko ake nonéti irihíkovoti xapa tôpe, énomone kuteâti ne xâne kamoâti ne emo'u Itukó'oviti, ");
INSERT INTO terNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","itea pepoké kixoti isóneu vo'oku nókone yara kúveu mêum, koane iyókovoti enó'iyea apeínoati, koane iyókovoti po'ínuhiko koekúti, yane ákone ukápana ítukeke Itukó'oviti, koane ákomaka únati ítukeino Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kene ne irihíkovoti únatike poké'e, énomone kuteâti ne xâne kamoâti ne emo'u Itukó'oviti koane namukoâti. Yane koati apêti únati ítukeino Itukó'oviti, kuteâti koêku ne ake nonéti porexópoti tirinta koeti há'i ya póhuti úkeaku áke, itukovo sesenta koêti, áko'o itukovo póhuti séndu ya póhuti úkeaku. ");
INSERT INTO terNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Hara kíxovokoxoamaka Jesus: —Neíxonenoekopomea ihúxoti yúku xovopu'í kixoâti itukovo imoâti opékuke ípe? Ako kalíhuina, itea koati ihúxinokonoti ímeokono xoko koati ókoku ne yúku motovâti koúhapu'ikea. ");
INSERT INTO terNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Koêkuti koekúti he'onóvoti, kóyeanemo koúhapu'ikeokono. Koêkuti he'onóvoti kó'oyene, exókonotimo káxehiko keno'ókoti. ");
INSERT INTO terNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Koêkuti kamoâti ra yûnzo, ivávaka. ");
INSERT INTO terNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ina koe'íkomaka: —Itíkina iséneu ne yûnzo kémone, vo'oku kuteâti kixeku itíkivo, énomonemo kixékononeye, epó'oxo kuri'úxovotimo aukópinovopiti. ");
INSERT INTO terNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Enepone apêti námoe yara yûnzo, kuri'úxovotineoxomo námoe. Kene ne ákoti koati ivávakea, muhíkova ne kali éxoneya, uke'épotinemo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ina kixovókoxopamaka Jesus: —Hara koéneye natíxea ne Itukó'oviti xapa xâne, kuteâti koeku hóyeno nôti ake nonéti ya isáneke. ");
INSERT INTO terNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Itukovo yóti, imókoti ne hóyeno. Yúponiyeane, exepúkotine. Koatine kóye. Yoko anéko íhonopea koane payákeyea ne nóne itea ako éxa neko hóyeno kixoku koeku íhonea koane payá'iyea. ");
INSERT INTO terNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Koati pohúxovoti íhonopea ne ake nonéti. Inúxotike íhonopo, ina keno'óko há'i. Yane ínamaka itôvo ne há'i. ");
INSERT INTO terNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Itovóne, tetukóvotine vo'oku símeovone kaxena veyóvope. Kúteanemakamo koêku ne natíxea Itukó'oviti xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ina kixovókoxopaikomaka Jesus: —Kutimea koéneye natíxea ne Itukó'oviti xapa xâne koeku ukóponea? Kutimea itukóvo exetínati motovâti ínzokea? ");
INSERT INTO terNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hara koéneye ake nonéti iháxoneti mostarda. Enepo nokóno, koati kalîhuti ya uhá koeti ake nonéti yara kúveu mêum, ");
INSERT INTO terNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","itea ike nó'iyeokono koane íhonopea, paya'íne, anu'ú kíxoahiko ne po'ínuhiko nonéti ya kavâne, koane kali hána'itinoe káva'o kutí'inoke motovâti ímea môko ne ôti hó'openo xapa káva'o opékuke epêvokopetina tûti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Koati ênoti po'ínuhiko exetínati kuteâti râ'a, veínoake Jesus íhokea ne ihíkauvoti íhikaxone. Kuteâti ítone éxea xanéhiko kamokénoati, ene íhikaxo. ");
INSERT INTO terNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Poéhane exetínati apêti íhokovoke veínoa íhikaxea. Itea xapákuke neko nduse koeti íhikau, koúhapu'ikopinoa kixó'ekone ne éxetina enepo ainópovonehiko. ");
INSERT INTO terNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yaneko kiyoné'e káxe, hara kíxovokoxoa Jesus ne íhikau: —Pihá'avo ûti poixô'oke ra mar —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ina ikopóvahiko íhikau Jesus neko êno xâne, yane omó kixónehiko Jesus yane vatéke ivátaheixoku íhikaxea ákotine evesékapea ne vatéke. Yoko ápemaka po'ínuhiko xâne po'íkehiko vatéke hokoâti. ");
INSERT INTO terNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yane kenó'okone êno xúnati ihunóvoti koane ovóxokeovo ne úne, koane ûrukeovamaka êno úne ne vatékena kutí'inoke mani yupurîrihikovoti. ");
INSERT INTO terNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yoko imókoti ne Jesus terékuke neko vatéke ayátokoke. Ina koyúkoa íhikauhiko koane kíxea: —Ihikaxotí, ako yónoku iséneu? Inípono kahá'ayeane yúpuririkeovo ûti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iyukóvone ne Jesus, pahúkoa ókea ne ihunóvoti. Hara koéne: —Akáne ra ihunóvoti. Hákone ovoxókovo ra úne —koéne. Yane okóne ne ihunóvoti, huvemoo koépone ikéne. ");
INSERT INTO terNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ina kixovókoxoa Jesus ne íhikau: —Na koeti itíkinovonoe îreti? Na koeti ákoino kivápunu? —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yoko yupihovó koe píkeahiko ina kixokóko: —Kutimea itukóvoye ra hóyeno? Muhíkinova úne yoko ihunóvoti itúkea yûho. ");
INSERT INTO terNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Taru'úxoane evo Jesus ne Mar-na Ngalíleya, símoane ne poké'exa xanéhiko koéhati njerâzenu. ");
INSERT INTO terNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ehá'axo evésekea vatéke ne Jesus, okótumonexoa hóyeno ukeâti pe'áxatike. Yoko ûroevo ndémoniu nê'e. ");
INSERT INTO terNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Koati óvoheixokune neko hóyeno yane pe'áxatike. Akó'otine ika'ákopeti itoâti enepo ika'ákokono, muhíkova itukovo korénde iká'akeokono. ");
INSERT INTO terNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yoko enóne ikáhevexeokono koane ikávo'uxeokono ya koati tiú'iti korénde, itea kóyeane kétokexea ne iká'akeokonoke. Ákone itoâti neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Káxe, yóti véyo vá'uixea ya pe'áxatike, koane xapa kali mopôi, koánemaka óko'okopeovo ya mopôi. ");
INSERT INTO terNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Noixóne Jesus, ehákinovane. Yoko avo malíka Jesus. Tokopâne hóyeno, ipuyuké kó'iyeane nonékuke. ");
INSERT INTO terNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ina kohonóko emó'u kó'iyea: —Jesus, iti Xe'exa Itukó'oviti, iti xe'exa Koati Payásoti ya uhá koêti, na koeti yího'ixopoinonu? Émbemopi ya iháke Itukó'oviti ákoyea ipíhepananu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yoko kó'inokeneye yûho, hara kixoátimeku Jesus: —Iti ndemoniú, ipíhikapi ra hóyeno. ");
INSERT INTO terNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ina kixopá'ikomaka Jesus: —Kuti kéha? —Ákoti Yumaxápu ngoéha vo'oku ákoyea yumáxapu ûti —koéne yumópope. ");
INSERT INTO terNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yane koâti ikoseânaxovoti Jesus ne ndémoniuhiko, epemoâti ákoyea kápuhikapa yaneko poké'e óvoheixoku. ");
INSERT INTO terNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yoko ápe ênoti kûre ixómotihiko níko oúkeke neko kali mopôi xêrerekuke ne óvoheixokuhiko. ");
INSERT INTO terNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yane hara kixo Jesus neko ndémoniuhiko. —Koati vepemópiti pehúkopivi xapákuke ne kûrehiko, maka vitúkapane vóvoheixoku —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yane síkoane Jesus kuteâti épemoake. Ipuhíkopeane neko hóyeno, ponokó koépone xapákuke neko êno kûre. Yoko koati ákoti yumaxápu neko kûre kuteâtimea pi'âti míli. Yane heú koéne éhahikeovo, koane íkorono'ekeovo úneke ukeâti oúke mopôi. Heú koéne yúpuririhikeovo. ");
INSERT INTO terNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Enepone koyonoâtihiko neko êno kûre, kohó'ikene koane koyúhopea koêku ne koekúti yane pitivóko, koane xapákuke neko ko'óvokuti yane mêum vekópoku. Yane noíxoponoa xanéhiko neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Simoné'ehiko xoko Jesus, noíxoanehiko neko hóyeno ipúhikopeakumeku ndémoniu vatá koyépotine, ko'ipóvopotine, koane unatípotine isóneu. Yane pikóne ne xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Enepohikoneko noixoâti ne koekúti, koyúhopa ne noíxone koêku ne hóyeno koane koêku ne êno kûre. ");
INSERT INTO terNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yane koyúhoinoa xanéhiko ne Jesus kahá'ainoa ipúhikopea poké'exake. ");
INSERT INTO terNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Itea enepone hóyeno ipúhikopeaku neko ndémoniuhiko, noixóne Jesus ûrukopeovo vatékenake, épemova xanépea. ");
INSERT INTO terNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Itea ako akáha'apoa Jesus. Pohu hara kíxoa: —Pihépavo yóvokuke xapa iyínoxapa. Yokóyuhopinoa uhá koêti ne kixópiku Itukó'oviti, koane koêku ne hána'iti seánakopi —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yane pihópone neko hóyeno. Koyúhopa uhá koeti koêku ne ítukeinoa Jesus yane úkeaku iháxoneti Yehí Koeti Pitivóko, koáne iyúpaxeova heú koeti xâne kamoâti. ");
INSERT INTO terNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yane ivú'ixopomaka vatéke ne Jesus taru'úxopati neko mar. Seopóne poixô'oke, êno xâne pihinoâti. ");
INSERT INTO terNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yane apé koéne hóyeno simôti xoko Jesus koéhati Njaîru. Enepone hóyeno, teyonéti xapa po'íhiko teyonéti íhikaxovokuke hó'e jûdeuhiko. Ina ipuyúkexo nonékuke Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yoko koati koyó'iti ne hóyeno koeku kíxea: —Kahá'atine ivókeovo inzíne. Yaxénapanu, ípihepainana veô'u tutíkuke maka aúnatipone. Yane ákomo ivákapu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yane xanépoane Jesus ne Njaîru. Koati ênoti xâne ikéneke koane inúmeokokohiko. ");
INSERT INTO terNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yoko ápe sêno nduse koetíne xoénae ká'arine. Akó'oti áka evésekea aríne. ");
INSERT INTO terNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yoko enóne ixómoyea koítoponovo kotíveti xoko ipixáxoati. Uke'éxotinemaka apeínoati vo'ókuke itea akó'oti koitóvati. Tumúne yóno yupíheovo koéku. ");
INSERT INTO terNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Eyekóxoane sêno ítuke ne Jesus, pihóne xapákuke neko êno xâne ikéneke Jesus. Koati akéneke Jesus véko sipóheoponeati ípovo. ");
INSERT INTO terNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Vo'oku hara koeti isóneu ne sêno: “Enepomo pohu nzipáheyea ípovo, indóvotimo” koêti. ");
INSERT INTO terNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ehá'axo sípoheyea, etétukone aríne. Eópova ya muyókuke itúkeovo koati iteôvatine ne aríne. ");
INSERT INTO terNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ehá'axo sípoheokono ípovo ne Jesus, eópamaka ipúhikea xunáko xokóyoke. Yane ná'akene koéne xaneâti noíheyea xapákuke neko êno xâne, ina kôe: —Kuti sipohêa ra ímbovo? ");
INSERT INTO terNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ina yumopâ íhikauhiko: —Ákoikopo neíxa ra êno xâne isú'okovopiti koane inúmeopi yépemovikomaka sipo'ókopiti? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Itea kóyeane noíheyea Jesus híyeuke neko êno xâne kaha'âti éxea neko sipóheyeati ípovo. ");
INSERT INTO terNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yoko koati yupihóvoti honónokea mûyo neko sêno vo'ókuke neko yuho Jesus, koane hána'iti píkea eopâti ya xokóyoke unátipeane. Yane ina ipuyúkexo nonékuke Jesus, koyuhó'inoati uhá koêti neko koêku. ");
INSERT INTO terNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ina kixôa Jesus: —Nje'exá, itévone vo'oku kívivonu. Pihépane, aúhepepone iséneu, ítivoane ne yaríne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Koeku yúho'ixeako Jesus neko sêno, simó koene xâne ukeâti óvokuke Njaîru, enepone inuxínoti itukéti íhikaxovokuke hó'e jûdeuhiko. Hara kixóponoa: —Ivókovone ihine îti. Hákone perexôa itukéti ne ihíkaxoti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Itea ako itúkoake Jesus neko emo'úti. Hara kixo Njaîru: —Hako píke. Pohu yakútiponu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yane ako akáha'a Jesus ápeyea po'i pihôti ikéneke. Poéhane Pêturu yóko'o ne pi'âti kopo'ínukokoti Teâku yoko Xuâum, ene xáne. ");
INSERT INTO terNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Simoné'e óvokuke Njaîru, noíxoane Jesus ákoyea tôpi kixóvoku yaíkexea koane íyokexea neko xanéhikoya. ");
INSERT INTO terNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yane ûrukovo ne Jesus koane kó'iyea: —Na koeti ákoino tôpi kixévoku koane ínayea íyeokexonoe? Haina ivokóvoti ra kalivôno, pohu imókoti —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yane koémoke'eyeahiko neko yûho. Ina pahukôa Jesus ipúhikopea uhá koêti ne po'ínuhiko xâne. Poéhane há'a yoko êno ne kalivôno yóko'omaka neko mopo'âti íhikau xáne xoko imókoku ne kalivôno. ");
INSERT INTO terNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ina namukêa Jesus vô'u ne kalivôno koane kíxea ya emó'uke: —“Talitá kumi.” (Yoko “Tenó, mbahúkopi yexépukopi” koêti ne emo'úti.) ");
INSERT INTO terNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ehá'axo koyúhoa Jesus, exépukopone ne seno kalivôno koane yonópone. Yoko nduse koetíne xoénaena. Koati êno hána'iti iyúpaxeova heú koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yane koati í'ixiko'o kixoíxoati Jesus neko xâne ákoyea okóyuhoa neko koekúti. Ínamaka pahukôa Jesus poréxopeokono nîka neko seno kalivôno. ");
INSERT INTO terNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ipuhíkopeane Jesus neko pitivóko, pihópone Nazâre, pítivokonake. Xanépoamaka neko íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Simovóne sâputu, turíxovone íhikaxea ne Jesus ya íhikaxovoku hó'e jûdeuhiko. Êno xâne kamokénoati koane iyúpaxeovahiko. Hara koéhiko vo'ókuke: —Námea úkea ne ihíkauvoti íhikaxone koáne ne exóneti éxone? Námaka kixoâtiye éxea itúkea ne iyupánevoti ítuke? ");
INSERT INTO terNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hainá'ikopo ne karapínteru, enepone xé'a Mâriya râ'a? Hainá'ikopo po'inu Teâku, Yûse, Njûda yoko Símaum? Koáne ne mokéxahiko, hainá'ikopomaka yâye xapákuke ûti óvo? —koéhiko. Koane yupíheovohiko poé'ainoa isóneu. ");
INSERT INTO terNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ina kixovókoxoa Jesus: —Koati teyonéti ne xâne koyúhoti emo'u Itukó'oviti. Poéhane poké'exake, ya xapákuke iyénoxapa yoko óvokuke ako teyoâti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yoko ako omótova itúkea iyupánevoti ne Jesus ya xapákuke vo'oku isóneunoahiko, ákoti itukapu koíteovo ákoti axu'ína ka'aríneti enepo ipího vô'u tutíkuke. ");
INSERT INTO terNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iyúpaxova Jesus tiú'iko omíxone neko xanéhiko vo'oku ákoyea akútipoa. Itea kóyeane ukóponea ne Jesus po'íke kálihunoe pitivóko xêrenekuke Nazâre íhikaxea po'ínuhiko xâne. ");
INSERT INTO terNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yane iháxihikoa Jesus neko nduse koeti íhikau, ina pahukôa xapa xâne pi'á pi'a koêti. Poréxoahikomaka xunakóti kópuhikopea ndémoniu xoko xâne ûroevo. ");
INSERT INTO terNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yoko ako síka Jesus ápeyeahiko ómone koeku píhea. Poéhane puló'ina ómo. Kene kuteâti imóvo, íhaku ípovo, koánemaka itûketi, ako síka ómea. ");
INSERT INTO terNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pahúkoamaka itúkea perékatana itea ako síka ómea esá'ikovope. ");
INSERT INTO terNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ina kixovókoxoa Jesus: —Enepo áva ko'óvokuti porexópiti yóki óvokuke, yâvaneya imókonemo ipihíkapi ne pitivóko. ");
INSERT INTO terNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Itea enepo áva símeku ákoti akahá'api, ákotimaka akahá'a kámokenoyeopi, ipihíkapihiko, ikétatahevexapapu kirikópoti ipú'ine poké'e ukeâti xoko piríkatana, yexókoatihiko ákoyeane omótokea íkameokono emo'u Itukó'oviti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Úkeane pihohíko ne íhikau Jesus koyúhoponea xapa xâne kónokea ikótivexea isóneuke ne pahúnevo koane kuríkopea. ");
INSERT INTO terNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kópuhikopomaka ndémoniu urúkovoti xoko xâne. Enómaka ka'aríneti ípihinoke óliu tutíkuke koane koíteovahiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yane eyékoxoane Êrodi, enepone nâti, koeku ítuke ne Jesus vo'oku ákoyeane malíka yónoku ne eyekoûti vo'ókuke. Yoko hara koeti yûho po'ínuhiko xâne vo'ókuke: —Exépukopone ne Xuaum Mbátita ukópea xapa ivokóvoti. Énomone ápeino xunáko nê'e itúkea ne iyupánevoti ítuke —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kene po'ínuhiko, haramaka kôe: —Koati porofeta Îliya nê'e, iyukópovotine. Ina keno'óko po'ínuhiko koêti: —Koati porófeta nê'e kuteâti koêku neko koyúhotihiko emo'u Itukó'oviti mekúke —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Itea kamoáne Êrodi, hara kôe: —Koati Xuaum Mbátita ne exepúkopone ukópea xapa ivokóvoti, enepone mbáhoe tetúnoyeovo —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kó'inokeneye isóneu, koati énomone pahukôa namukóponoati ne Xuâum yanekôyoke koane kurikoâti ika'ákovokutike, vo'oku saya'íkoati Xuâum yaneko hu'ûxo yeno Filípi, énomea Êrodi iháxoneti Erôdiya. Yoko koati kopo'ínukokoti ne Êrodi yoko Filípi. ");
INSERT INTO terNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Vo'oku hara kíxoa Xuâum yanekôyoke: “Yane Ponóvoti Kixovókuti yútoe Muîse, ako omótova kéyenopi yeno pe'ínu” kixoâti. ");
INSERT INTO terNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Koati yupihóvoti itúkeovo puvone Erôdiya ne Xuaum Mbátita vo'ókuke, koane kahá'ayea Erôdiya koépekea itea akó'oti itâ. ");
INSERT INTO terNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Vo'oku koati teyoâti Êrodi ne Xuâum. Éxoa itúkeovo koati ponóvoti hóyeno koane sasá'iti, ákoinoke síka koépekeokono. Epó'oxo enepo kamokénoa Êrodi koyûho ne Xuâum, ako exa mani âha itúkea itea usó kóye kámokenoyea. ");
INSERT INTO terNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Po'íke káxe ínixoa Erôdiya unátiyeaku itúkea ne yúmo'ixovone. Koati ikoyuîxoti ipúhikope ne Êrodi, kutí'inoke itúkoti êno nikokónoti. Énomonemaka hupíxinoa ne payásotihiko hóyeno pahúkoti natíxokuke, yoko tuti húndaruhiko, yoko po'ínuhiko tutíye ya Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yane ûrukovone ihíne ne Erôdiya hiyokéxoti nonékukehiko. Yupihovó koe ínixea úhe'ekea Êrodi yóko'ohiko neko húpiu. Yane hara kíxoa nâti ne ihínexaka: —Yépemanu koêkuti yâha kó'oyene vo'oku mborexópeatimo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Koyúhoamaka iháke Itukó'oviti exókoati itúkeovo koati kaná'uti ne yûho. Hara kíxoa: —Muhíkovamo itapána meyá koeti apeínonuti yara nandíxoku, kóyeanemo mboréxeopea ne yépemonuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Úkeane pího ne ârunoe xoko êno. Hara kixóponoa: —Kutimea émbemapana? Ina kixôa êno: —Yépema tuti Xuaum Mbátita —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Énomone yaneko ókoku ôra, kayú koépone éhakopeovo xokóyoke ne nâti há'axaka, ina kixôa: —Ngaha'âti ne tuti Xuaum Mbátita kó'oyenene utókuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yupihovó koéne ikáxu'iyea okóvo ne nâti. Itea vo'oku koyúhoyeane poréxeamo koêkuti épemone, ihákeikomaka Itukó'oviti koyúhoyea, yoko vo'ókukehikomaka ne húpiu kamoâti, ene ákoino akáha'a káyukopea neko yûho. ");
INSERT INTO terNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yane ako iká'akarixapu, pahúkone koepékoati ne Xuâum. Pahúkoanemaka ómeokono xoko ihínexaka ne tuti Xuâum. Úkeane pího ne húndaru ika'ákovokutike. Yane tetúnoane, ");
INSERT INTO terNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ina omopêa tûti utókuke, ina porexóponoa neko ârunoe. Yane kuríkoponoane xoko êno. ");
INSERT INTO terNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ehá'axo eyékoxoa íhikauhiko Xuâum, pihóne veyóponea ne mûyo ina ekoxóponoahiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yaneko kayukópovohiko xoko Jesus neko páhoe koyúhoyea emó'u xapa xâne, heú kixópahiko koyúhopinoa koêku neko ítuke koánemaka kíxoaku íhikaxea. ");
INSERT INTO terNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ina kixôa Jesus: —Yókonenoe, vámamikapanavo xoko ákoyeaku xâne —kíxoane. Yoko koati yupihóvati êno xâne xokóyoke. Koeku pihópea po'ínuhiko, koane símea po'ínuhiko. Koatine kóye. Muhíkova níkea ne evo Jesus, ako omótova vo'ókuke neko êno xâne. ");
INSERT INTO terNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yane ivú'ixone vatéke ne evo Jesus yonoti xoko ákoyeaku xâne. Yoko aînovonehiko koeku píhea. ");
INSERT INTO terNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Itea êno xâne noiké'exopati pihoné'ehiko. Exó kíxoahiko itúkeovo evo Jesus. Hukinóvoti éhahikeovohiko huse'ó kixoâti xê'o neko mar, ukeâti uhá koêti neko pitivókohiko. Yane inuxó koéne símohikea tumúneke símea evo Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Evesékeane vatéke ne Jesus, noíxoane neko êno xâne. Yane yupihovó koéne kóseanayea, vo'oku kutí kó'iyeahiko su'ûso ákoti koyonoâti. Yane turíxovone íhikaxea. Ako tôpi íhikaxoake. ");
INSERT INTO terNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kiyoné'e káxe, ahí'okovone Jesus ne íhikauhiko. Hara kíxoa: —Ako apêti yara vóvoheixoku epó'oxo kiyóne káxe. ");
INSERT INTO terNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mani únati pehukápavo pihópea ra xanéhiko motovâti vanéxopea kali nîka yâtikeneye, koêkuti vekópoku xapa ko'óvokuti koane xapa kali ipuxóvokuti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Itea hara kíxovokoxoa Jesus: —Itínenoe parexâ nîka. Ina kixôa íhikauhiko: —Mani konókoti uti êno tiûketi, ovâti pi'âti séndu káxe ko'ítuke xâne, ínani omotóva vanéxinoa uti pâum níkaxeake ûti. ");
INSERT INTO terNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ina kixovókoxopamaka Jesus: —Ná'ikopo yé'aye pâum yâyeke? Neíxapana —kíxoane. Exoânehiko yé'akeye, ina etó'okopo Jesus ápeyea singu koeti pâum yoko pi'âti hôe. ");
INSERT INTO terNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yane pahúkoane Jesus ho'uxó ho'uxo kó'iyea ivátahikea ne xanéhiko xapa uhé'ekoti kálihunoe ngaráma. ");
INSERT INTO terNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yane heú koéne ivátahikea ho'uxó ho'uxo koêti. Êno ho'úxovoku póhuti séndu, koane enómaka ho'úxovoku sinkoenta koêti. ");
INSERT INTO terNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ina veyôa Jesus neko singu koeti pâum yóko'o ne pi'âti hôe, ina komômo vanúke ikoró'ixinovoti Itukó'oviti vo'ókuke ne nikokónoti. Yane ina hono'ékexoa ne pâum koane pôrekexea ne íhikauhiko. Koane íhikauhiko, pôrekexoamaka ne xanéhiko. Yane ínamaka hono'ékexoa Jesus ne pi'âti hôe xapákuke heú koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Uhá koéhiko níkea koane imátaxeovohiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ina itixópa íhikauhiko Jesus neko itátanehiko pâum yoko hôe haxâti, kopúhikopoikomaka nduse koeti sésta. ");
INSERT INTO terNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yoko singu koe mili hóyeno nikoâti neko pâum. ");
INSERT INTO terNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Koati ikénepoke nekôyo, pahúkopa Jesus ne íhikauhiko ivú'ixopea vatéke, koane inúxopinoa yonópotihiko Mbetâsaida poixô'oke neko mar, koêkuiko pahúkopea Jesus pihópea neko êno xâne. ");
INSERT INTO terNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pihopónehiko, ina pího ne Jesus oúke neko kali mopôi itukóponoti orásaum. ");
INSERT INTO terNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yaneko yotixóne, kukúkeke mar óvoheixoiko ne vatéke ivú'e neko íhikauhiko. Kene Jesus, óvaikone póhuxeovo xoko óvoheixoku. ");
INSERT INTO terNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Noixoâne Jesus ne íhikauhiko kóxuna'ixeovo ívirikea vatékena, koane ákoyea pîha tumúne vo'oku ihunóvoti, pihínoane. Yoko mâturukatane. Yonó koéne inúkuke úne ne Jesus kaha'âti anú'ukeahiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Noixoâne íhikauhiko neko yonoti inúkuke úne, íkutixanehiko ipíkoti. Yane yaíkexonehiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Koati konóko'iti noixoânehiko. Itea hara kíxovokoxoa Jesus: —Aúhepeponenoe iséneu, undíneye, hákonoe píke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ina evesé'uxopa Jesus kúveuke ne vatékena, yane xanepoâtinehiko. Má koépone neko xúnati ihunóvoti. Yupíhova iyúpaxeova íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Koáhati akó'otihiko imihé'akina isóneu ne po'i iyupánevoti ítuke Jesus kohiyákoa neko singu koeti pâum, vo'oku títiu kóyeyeahiko omíxone. ");
INSERT INTO terNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Taru'úxoane neko mar, enepo simoné'ehiko poké'exa Njenezâre, ikâ'akoane ne vatéke xe'ókuke ne úne. ");
INSERT INTO terNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Koeku evésekeahiko, exó kixópononehiko Jesus ne xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yane éhahikovo ya heú koeti ipuxóvokutihiko yaneko poké'e veyopónoati ne ka'aríneti, ixané kixoâti poúke ómeahiko xoko Jesus, koêkuti eyékoxeakuhiko óvea ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Koane koêkuti vékoku ne Jesus ya kálihunoe ipuxóvokuti, koáne ya pitivókohiko, yoko xapa ko'óvokuti ya mêum, omínokono ka'aríneti ya none ovokúti, koane épemeokono Jesus yusíkea pohu sipohí kíxeokono heve ípovo. Yoko heú koeti sipóheati, unátipo. ");
INSERT INTO terNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ápe farîzeu yoko éskiriba, enepohikone teyonéti hó'eke jûdeu ukeâti Njeruzálem pihôti xoko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yoko noíxoanehiko ápeyea íhikau Jesus nikôti ákoti haka kíxoku kipóvo'uxeovo po'ínuhiko jûdeu, kuteâti íhikaxoake hó'e. ");
INSERT INTO terNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Vo'oku enepohikone farîzeu yoko uhá koeti po'ínuhiko jûdeu, koati yuixóvoti íhikaxoake oxúnoekene, ákoinokehiko nîka ákotike kókoyuse íxa kipóvo'uxeovo inúxotike. ");
INSERT INTO terNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Koánemaka enepo ukopêa mérkaduke, ákomaka nîka ákotike itukâ ne nókone itúkea hó'eke motovâti kasása'ikopeovo. Êno po'ínuhiko koekúti kuteâti kókoyuse kíxea kipó'ikea énovope koane kóhokope êka yoko ihakúti ítuke havâva, muhíkova ipéna. ");
INSERT INTO terNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yane hara épemo'iko Jesus ne evo farîzeu yoko éskiriba: —Na koeti ákoino itúka íhikeuhiko ne ihíkauvoti kûreinovike voxúnoekene? Vo'oku nikó koéhiko ákoti hakâ ne kixoku kipóvo'uxeovo ûti ya hó'e ûti. ");
INSERT INTO terNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ina yumopâ Jesus: —Koati tokopóvoti neko yuho porofeta Izâiya mekúke ve'ókukenoe, itínoe ikútixapovoti sasá'iti ya po'ínuhiko xâne. Énomone neko yutoéti koêti: “Enepora xanéhiko, pohu koyuhó kíxoa téyeonu, itea ako malíkanu isóneuhiko. ");
INSERT INTO terNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Koati hokohí kixónuti, ihíkaxotihiko ihíkauvoti ainóvoti isoneú kíxone xâne” kôe. ");
INSERT INTO terNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ako itíkoake ne páhoenopi Itukó'oviti. Ainovó koe kixoku itúkeovo xâne yara kúveu mêum hekónoe —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ina kixovókoxopamaka Jesus neko evo farîzeu yoko éskiriba: —Koati yahúkotinoe ya kiríki ne ihíkauvoti ukeâti xoko Itukó'oviti motovâti hekópi isoneú kixíneake ne ihíkauvoti. ");
INSERT INTO terNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Vo'oku hara koêti yútoe Muîse, nókone xâne itúkea: “Tiyánoe yá'a yoko yêno” kôe. Ina koe'íkomaka: “Konókoti koépekeokono ne vaheréxoti yuhó'ino há'a itukovo êno” koémaka. ");
INSERT INTO terNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Itea hara koe íhikexinoe: Enepone tiûketi mani huvó'oxope há'a itukovo êno, motóva xâne koyúhoino há'a yoko êno itúkeovo Korôbaum, tiûketi poréxoke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yane ákoneikopo okónokoa kátarakea há'a, áko'o itukovo êno. ");
INSERT INTO terNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yane ákonemaka itúkokonoke ne emo'u Itukó'oviti vo'oku isoneú kixíneake ne ihíkauvoti, enepone íhikexoke xanéhiko. Enómaka po'ínuhiko koekúti ítikenoe kuteâti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ina ihaxíhikopamaka Jesus neko êno xâne. Hara kíxovokoxoa: —Yakámokenonu uhá ketínoe maka yéxanenoe iséneunoa ra yûnzo: ");
INSERT INTO terNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ako ápahuina koekúti urúkovoti xoko xâne motovâti ikópiti'ikea, itea enepone koekúti ipuhíkeati xokóyoke hainápo, énomone ikopíti'ikoa. ");
INSERT INTO terNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Koêkuti kamoâti ra yûnzo, ivávaka —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pihopeâne Jesus ne xanéhiko, ûrukopovo ovokútike. Yane épemo'ikoane íhikauhiko koeku íhokoake ne yuhómeku. ");
INSERT INTO terNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ina kixovókoxoa Jesus: —Ákonoekopomaka yéxa kixó'ekone? Ákoikopo yéxanoe ákoyea ápahuina koekúti urúkovoti xoko xâne motovâti ikópiti'ikea? ");
INSERT INTO terNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Vo'oku ako ûrukapu isóneuke, itea okóvoike yónea ina ipuhíkopomaka —kíxovokoxoane. Ya kuteâti koêku neko yuho Jesus, iyúseo isóneunoa ne uhá koeti kó'iyeovoku nikokónoti motó'iyeova níkeokono. ");
INSERT INTO terNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ina kixovókoxopaikomaka: —Itea enepone ukeâti xoko xâne hainápo, énomoneoxo ikopíti'ikoa. ");
INSERT INTO terNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vo'oku isóneuke xâne úkea ne váherehiko âha itúkea, kuteâti ikópiti'ikopeovo ya kapinehí kíxea xâne ákoti itukapu koati múxone yoko oméxea koane koépekea. Kúteanemaka ne aúpu'ikea yêno áko'o itukovo îma, kapíneti ákoti itukapu koati múxone. ");
INSERT INTO terNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ina keno'ókomaka ne ixómoyea ipúpakinoa isóneu kahá'ayea îrikuxea, koane kahá'ayea váherexea ítukeino po'i xâne, koane semékekexea. Kúteanemaka koêku ne ákoyea sayá'ikapeapa ne váhere úhepune mûyo vo'oku kahá'ayea sêno, koánemaka ne poé'aino isóneu po'ínuhiko xâne vo'oku íyokeova ítukevo, yoko ikópiti'ikea iha po'ínuhiko xâne, koane kapáyasokopeovo, yoko po'inuhiko kixoku koésayu'ixea itúkeovo, kuteâti kixoku itúkeovo xâne ákoti isóneu. ");
INSERT INTO terNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Heú koêti ra váhere itukeôvoti, aínovo ukeâti isóneuke xâne, yoko énomoneoxo ikopíti'ikoa —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ipuhíkopeane Jesus neko óvoheixoku, pihóne ya poké'e xe'ókuke ne pitivókohiko koéhati Tîru yoko Sîdom. Simoáne, ápe ovokútiya ûrukovoku. Ako akáha'a ápeyea exoâti símea, itea ako oxéne ákoyea éxakana. ");
INSERT INTO terNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yoko ápe sêno apêti ihíne ûroevo ndémoniu. Eyekóxoane sêno símeane Jesus, pihóne xokóyoke. Yane ipuyuké kó'iyeane nonékuke. ");
INSERT INTO terNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yoko haina jûdeu ne sêno, koati seno sirufinísea. ");
INSERT INTO terNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ina epêmo Jesus kópuhikopinoa ndémoniu urúkeovati ihíne. Itea hara kíxoa Jesus: —Konókoti imátaxeovo inúxotike xe'éxaxapa ne koati ko'óvokuti. Vo'oku ako yusíka véyeokono itátane pâum, nika xe'éxaxapa ne koati ko'óvokuti, ina parexákana ne kálihunoe tamúku. ");
INSERT INTO terNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ina yumopâ neko sêno: —Kaná'uteoxo Unaém. Itea enepone kálihunoe tamúku opékuke mêsa, níkoamaka ne íhone nika kalivónohiko. ");
INSERT INTO terNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ina kixopâmaka Jesus: —Vo'ókuke ra yiûho, ipúhikopeane ndémoniu ne ihine îti. Motóvane pihépi yóvokuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yane pihópone neko sêno. Seopóne óvokuke, inú'ikopane ne ihíne tunukúxovoti ípeke. Yoko ipúhikopeane ndémoniu. ");
INSERT INTO terNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yane ipúhikopeane Jesus ne xe'o Tîru. Vekó koépo ya Sîdom. Tarú'uxopamaka ne poké'e iháxoneti Yehí Koeti Pitivóko koeku yonópea ya Mar-na Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yane ápe xâne omotíhiko hóyeno mókere ákotimaka panâpu koyúhoyea xoko Jesus. Épemohiko Jesus ípihea vô'u tutíkuke ne hóyeno. ");
INSERT INTO terNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yane ahikú kíxoa Jesus xoko ákoyeaku koati xâne, ina ipího vô'u kenókuke neko hóyeno. Yane kaláka'ikomaka vô'u ya hô'o ina ipíhoa nenékuke ne hóyeno, ");
INSERT INTO terNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ínamaka komômo vanúke xaneâti ínayea ómixekovo koane “Efáta” kíxea. (Yoko “imíhe'akapane” koêti neko emo'úti.) ");
INSERT INTO terNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Énomone yanê'e, kamópone neko hóyeno. Ákone itopeâti nêne. Ponópovone koyúhoyea. ");
INSERT INTO terNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ina ixikó'okoa Jesus ne xanéhiko ákoyea okóyuhoa ne koekúti. Itea koeku í'ixiko'o kíxoixea ákoyea okóyuhoahiko, inamá'axone koyuhoâhiko. ");
INSERT INTO terNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Enepohikone xâne eyekóxoati, yupíhova iyúpaxeova koane kó'iyeahiko: —Imáko yupíhinovo unako ítuke! Ituko kamópea mókere, koane ítoa ponópea koyúhopea ne ákoti okoyúho —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yaneko káxehiko ho'úxopinovomaka Jesus ne êne xâne. Yoko ako nikokónoti nikáhiko. Yane ina ihaxíhikoa Jesus ne íhikau, hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ngóseanane ra xanéhiko vo'oku ákone nikáhiko. Yoko mopó'apene káxe óvoheixohiko njokóyoke kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Enepo mbahukápahiko pihópea óvokuke ákoti níka, ikoróhikoatimo hímakati xenékuke. Yoko anéye xapákuke koati ákoti malîka úkeaku. ");
INSERT INTO terNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ina kixôa íhikauhiko: —Ná'ikopomo vínixoponea nikokónoti motovâti koímataxeahiko yara mêum ákoti apêti? ");
INSERT INTO terNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ina kixovókoxopamaka Jesus: —Ná'ikopo yé'aye pâum apêti yâyeke? —Seti kôe —kíxoane íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yane pahúkoane Jesus ivátahikea poké'eke ne xanéhiko, ina veyôa ne seti koeti pâum, ina ikoró'ixovo xoko Itukó'oviti. Yane honó'ekexoane, ina porekéxoa ne íhikauhiko. Koane íhikauhiko, pôrekexoamaka neko xâne. ");
INSERT INTO terNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ápemaka kali ye'á koeti kálihunoe hôe. Yane íkoro'ixinovamaka Jesus xoko Itukó'oviti ina pahukôa neko íhikauhiko pôrekexea ne xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Heú kôe neko xanéhiko níkea koane imátaxeovohiko. Ina itixópa íhikauhiko Jesus neko itátanehiko nikokónoti haxâti, kopúhikopoikomaka seti koeti sésta. ");
INSERT INTO terNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yoko itóponomea koaturu koeti mili hóyeno yanekôyo. Yane ina pahukópa Jesus pihópea neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kene Jesus yoko íhikauhiko, ivu'íxopo vatéke yonópoti poké'e koéhati Ndaumanúta. ");
INSERT INTO terNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ápehiko farîzeu, enepone teyonéti hó'eke jûdeu, yuhó'ixoponoti Jesus, oposí'okovati. Koati kaha'aînoatihiko pahúkeovo ya yumópope, épeminoake itúkea iyupánevoti hoénaxovope itúkeovo xoko Itukó'oviti úkea ne xunáko. ");
INSERT INTO terNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yupíhova ikótivexea Jesus isóneuke, xaneâti ínayea ómixekovo ina kôe: —Na koeti épemino kahá'ayea noíxea iyupánevoti ra xanéhiko apêti yara káxehiko símokune ûti kó'oyene? Koati emo'úti ra yunzó'inopinoe: Ákomo ápahuina iyupánevoti noíxone índukeinoa —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yane kurí kíxoanehiko Jesus. Ivú'ixopo vatéke, pihópoti poixô'oke neko mar. ");
INSERT INTO terNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yoko notú koene okóvo ómea po'i pâum ne íhikauhiko Jesus. Pohu poéha koxe'u pâum vatékenake, koékune, ako po'ínu. ");
INSERT INTO terNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ina ihíkaxoa Jesus ne íhikau, hara kíxovokoxoa: —Neíxapunoe, yokóhiyanavoa ne kutí koeti kohiyákopeti pâum, ánahixope farîzeuhiko yoko Êrodi —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yane turíxovone yúho'ixeokoko ne íhikau Jesus vo'ókuke ne yûho. Hara kixókoko: —Koatímea vo'oku ákoyea pâum vómone kó'inoneye yûho —kixókokohiko. ");
INSERT INTO terNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yoko exó kíxea Jesus koêku ne isóneuhiko. Hukinóvoti kíxovokoxea: —Na koeti ixómoino yího'ixokoko vo'oku ákoyea pâum yómonenoe? Âvonoe yéxina iséneu? Koane âvomaka yéxanoe koêku ne yûnzo? Imáko tiú'ino iséneunoe! ");
INSERT INTO terNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ápe yûke itea ako koati ínixi. Ápemaka kîno itea ako koati kémi. Ákonenoe puyákapanapa yokóvo ");
INSERT INTO terNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yé'akeye sésta puhí koeti itátane haxa nikokónoti ítixeponenoe, enepo nzono'ékexoa neko singu koeti pâum xapa singu koeti mili xâne? Ina kixoáhiko: —Nduse kôe. ");
INSERT INTO terNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ina kixovókoxopamaka Jesus: —Kúteanemaka koêku nzono'ékexoa neko seti koeti pâum xapákuke neko koaturu koeti mili xâne, námaka yé'aye sésta kepúhiupo yane itátane haxa nikokónoti? Ina yumopâhiko: —Seti kôe ");
INSERT INTO terNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ina kixovókoxopamaka Jesus: —Kóyeanemea âvoyea yéxinanoe iséneu? —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yane simónehiko ya Mbetâsaida, kali ipuxóvokuti. Ina apê xâne omoti hóyeno komítiti xoko Jesus, epemoâtihiko ípihea vô'u tutíkuke neko komítiti. ");
INSERT INTO terNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yane namú kíxeane Jesus vô'u ne hóyeno hirikôa meúkeke yane ipuxóvokuti, ina ipiho hô'o ukékuke ne hóyeno koane ípiheamaka vô'u tutíkuke. Yane hara kíxoa: —Ápe koêkuti ínixene? ");
INSERT INTO terNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ina komomâ hóyeno koane turíxeovone ínixopea. Hara kôe: —Íninjo xanéhiko yonôti, itea kutí kó'inonu xuve tikóti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ina ipíhopamaka Jesus ne vô'u ukékuke neko hóyeno. Yane turíxovone unátipea ínixopea. Koati unatípotine, koane ínixopea uhá koêti. ");
INSERT INTO terNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ina pahukôa Jesus ponó koépea óvokuke ákoti vekapâ ne ipuxóvokuti. ");
INSERT INTO terNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yane pihóne Jesus yoko íhikauhiko xapa kálihunoe ipuxóvokuti ovoti xe'o Sezâreya, enepone pitivóko óvoku Filípi pahúkea. Ya xenékuke, hara kíxovokoxoa Jesus ne íhikauhiko: —Kutimea íkutixanu ra xanéhiko? ");
INSERT INTO terNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ina yumopâ íhikauhiko: —Ápe koyúhoti itíkivo Xuaum Mbátita iyukópovone. Kene po'ínuhiko, koyúhoa itíkivo Îliya iyukópovone. Kane po'ínuhiko koyúhoa itíkivo porófeta koyúhoti emo'u Itukó'oviti mekúke iyukópovone —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Kene itínoe, kuti keyúho indúkeova? Ina kixôa Pêturu: —Iti Mésiya, enepone páhoe Itukó'oviti koíteovo xâne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ina ixikó'okoahiko Jesus ákoyea xâne koyúhoinoake nê'e. ");
INSERT INTO terNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ina turixóvo íhikaxea Jesus ne íhikauhiko. Hara kíxovokoxoa: —Konókotimo yupíheovo ngoítoponeovo kotíveti, undi íhae vanúke ikútipasikoponovoti xâne. Ákomo akútiponu ne tutíhiko viyéno jûdeu, koánemaka ne payásotihiko sasedóti inuxínoti xanena ûti hó'eke, yóko'o ne ihíkaxotihiko yútoe Muîse, enepohikone éskiriba. Koepékonutihikomo itea ya mopó'apeke káxe ikéne, enjepúkopotinemo ungópea xapa ivokóvoti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Koati kouhápu'ikinoati Jesus kixókonokumo. Yane ahikú kíxoane Pêturu, ina kixôa ákoyea yusíka kó'iyeaneye kuteâti koêku ne yûho. ");
INSERT INTO terNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ina inonéxinova Jesus ne íhikauhiko koane sayá'ikea Pêturu. Hara kíxoa: —Yahíkuxipunu Satanaé! Vo'oku haina ukeâti xoko Itukó'oviti ne iséneu, itea koati kuteâti kixoku ko'ísoneuyea xâne yara kúveu mêum —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yane ítaikoane Jesus neko êno xâne koánemaka ne íhikauhiko ahí'okeovaxo ina kixovókoxoa: —Enepone kahá'ati hókeonu, ako yusíka yuíxeovo koúhepekea kóyeku yara kúveu mêum. Konókoti hókeonu ya usó koyêti ínonexinovo tiú'iti koekúti, kuteâti koeku xâne koinópoti kurúhuna iyonókonone xoko kurúhuxokonoku. Yane kená'akane ingéneke. ");
INSERT INTO terNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vo'oku enepone xâne yuixóvoti koúhepekea kóyeku yara kúveu mêum, evókoatimo ne mani unako koépoku xoko Itukó'oviti. Itea enepone xâne usó koyêti évokea úhepeko kóyeku yara kúveu mêum vo'ónguke epó'oxo vo'ókuke ne inámati ihíkauvoti yûnzo, énomonemo unatî koépoku xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kutí'ikopo itópoino xâne usó kó'iyea apeínoati yara kúveu mêum itea evókoti mani unako koépoku xoko Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ápeikopomea koekúti yara kúveu mêum motovâti ko'ésa'iyea mani unako koépoku xoko Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yoko koêkuti teinónuti koane teinoâti ra emó'um nonékuke xâne kûrivokoevo ákoti opoéha isóneu ikéneke Itukó'oviti, enepohikone vaheréxotimaka kióxku itúkeovo, simóvotimo káxe ndeínoakumo, undi íhae vanúke ikútipasikoponovoti xâne. Koati énomonemakamo ngíxoaneyehiko yaneko káxe ngayukápapu enepo naixápakananemaka indúkeovo hána'iti ihayú'iuti kuteâti koeku Itukó'oviti Nzá'a, koêkumaka xanépeonuhiko sasá'iti ánju, enepone ovóxehiko Itukó'oviti ukeâti vanúke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ina kixovókoxopaikomaka Jesus: —Koati emo'úti ra yunzó'inopinoe: Anéye xepákukenoe âvotimo ivakápu koeku âvoyea naixa xunákomo natíxea Itukó'oviti xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sei koe káxe ikénepo, xánea Jesus ne Pêturu, Teâku yoko Xuâum oúke koati hána'iti mopôi. Aínovonehiko, ako po'i xâne kapákuke, ina ipokóvo koêku ne Jesus nonékukehiko. ");
INSERT INTO terNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Enepone ípovo Jesus ú'uhahi kóyene koane hóhopu-hóhopu kóyene. Ako kipóheoti yara kúveu mêum iotâti kohópu'ikea ne kipóhiu kuteâti hopú'iyea neko ípovo. ");
INSERT INTO terNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yane apé kó'inoane Îliya yoko Muîse, enepohikone koyúhoti emo'u Itukó'oviti mekúke yuhó'ixotihiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ina kôe ne Pêturu: —Ihikaxotí, koati únati vápeyea yâye. Poéhane vitúkinopinoe hú koêti mopo'âti kálihunoe péti. Poéhamo ítike, koane poéhamo ítuke Muîse koane poéhamo ítuke Îliya. ");
INSERT INTO terNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Itea mayane koyuhohí koêti ne Pêturu. Akó'oti koati éxea mani yûho vo'oku yupíheovohiko píkea. ");
INSERT INTO terNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yane apé koene kapási rama'úxoatihiko koane emo'úti inu'íxoati xapákuke ne kapási. Hara kôe: —Énomone Nje'éxa râ'a ákoti omotóva ongóvo. Yakámokenoyinoe yûho —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ina noiméxo ne íhikau Jesus xêrerekuke itea áko'oponehiko ne po'i noíxonemeku. Poéhapoane Jesus noíxo. ");
INSERT INTO terNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Koeku ukópea oúkeke ne hána'iti mopôi, hara kíxoa Jesus ixíko'okeahiko ne íhikauhiko: —Hákoxovo keyuhoânoe ne neíxone njokóyoke, imókonemo simapúne káxe enjépukopeakumo ungópea xapa ivokóvoti, undi íhae vanúke ikútipasikoponovoti xâne —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Koáne, itúkoahiko neko yuhó'inoa Jesus. Ako okóyuhoahiko, itea yúho'ixopokoko kaha'âti éxea kixó'ekone ne yuho Jesus, enepone “enjépukopeakumo ungópea xapa ivokóvoti” koêti. ");
INSERT INTO terNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ina kixohíko Jesus neko íhikau: —Ná'ikopo koeti koyúhoinoa ihíkaxoti yútoe Muîse, enepohikone éskiriba, kónokea itúkeovo Îliya inuxómo símea? ");
INSERT INTO terNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ina yumopâ Jesus: —Kaná'uteoxo símea ne Îliya inúxotike kóyuseyea uhá koêti. Itea na kó'inoaye iséneu ne emo'u Itukó'oviti koyúhoinoake kónokea enó'iyeamo koítoponeovo kotíveti ne íhae vanúke ikútipasikoponovoti xâne koane yupíheovomo púveovokono? ");
INSERT INTO terNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Koati ngixópitinoe símeane ne Îliya, epó'oxo itúkoa xanéhiko uhá koêti ne âha kíxea kuteâtimaka koeku yutóxeovo emó'uke Itukó'oviti mekúke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ya koeku káyukopeovohiko evo Jesus xapákuke neko po'ínuhiko íhikau, noíxonehiko koâti ákoti yumaxápu xâne yakuku-yakukú kixeâti ne íhikauhiko ixómoti yumopókoko, koánemaka ne éskiribahiko, enepone ihíkaxoti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Noixóne Jesus neko êno xâne, iyúpaxovohiko ina ehahíkinova yúhoikoponea. ");
INSERT INTO terNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yane hara kíxoa Jesus ne éskiribahiko: —Na koeti ixómoino yimópokokonoe? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yane apé koéne kixoti Jesus xapákuke neko êno xâne: —Ihikaxotí, omândi ne nje'éxa xikóyoke. Ako okóyuho vo'oku urúkovati ndémoniu. ");
INSERT INTO terNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Koêkuti óvoku enepo komohêa ndémoniu, íkorokoa poké'eke. Yane puvahíxotine pâho koane ínayea ngarútutukexo ôe koane muyá'iyea koxé'u. Émbemoane ne íhikeuhiko kópuhikopea itea ako íta. ");
INSERT INTO terNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ina kôe ne Jesus: —Imáko itúkinovo tiú'iti kutípea ra xanéhiko yara káxehiko kó'oyene! Ná'ikopomeamo nzunóko óvonzeixea xepákukenoe? Ná'ikopomeamo nzuhóko índea ákoyeanoe yakútiponu? Yámane yâkeneye ne homoêhou —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ina omâhiko xoko Jesus. Ehá'axo noixo Jesus neko homoêhou, ako íyuhixa ndémoniu koyúyu'okea. Yane íkorokovone neko homoêhou poké'eke koane kohókororokexoevo poké'eke koane puváhixea páho. ");
INSERT INTO terNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ina kixôa Jesus há'a ne homoêhou: —Na yé'aneye xoénae koéneye ra xi'íxa? Ina yumopâ neko hóyeno: —Ukeátine kalihâ'iko. ");
INSERT INTO terNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Enóne kûriukeyea yúku koane kûrino'ekea úne kaha'âti koépekea. Itea enepo itêa keítivoa, yokóseanavi, hivá'axavi —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ina kixôa Jesus: —Yépemonuikomaka índea ngoíteova? Enepone xâne kuvovónuti, uhauhá kôe koúsokinokonoa —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yane kóhonokone emó'u ne ha'a homoêhou. Hara kíxoa: —Nguvóvopi, itea kirí'uxinanu ngúveovopeoxo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Noixoâne Jesus éhahikeovo ne xanéhiko xokóyoke, sayá'ikoa ne ndémoniu. Hara kíxoa: —Iti ndémoniu mokeréxoti xâne konae ákoti ikayúhaxa, mbahúkopi ipíhikopi ra homoêhou, koane hákone keyukópinova —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ina vaûko ne ndémoniu xaneâti koati xúnati koyúyu'okea ne homoêhou koeku ipúhikopea. Yane kutí koéne ivokóvotine ne homoêhou ipuhíkopeane ne ndémoniu. Énomone enó'ino xâne “ivókovone nê'e” kixoâti. ");
INSERT INTO terNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Itea namú kíxeane vô'u Jesus huvo'óxoa exépukopea. Yane exépukopone ne homoêhou. ");
INSERT INTO terNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ikénepoke, enepo urúkopovone ovokútike ne evo Jesus, yoko ainóvotinehiko, hara kíxoa íhikauhiko: —Námea koeti ákoino víta kópuhikopea ûti ne ndémoniu? ");
INSERT INTO terNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ina yumopâ Jesus: —Enepora kó'iyeovoku ndémoniu, ako kopúhikopati ákoti itukapu ya orásaum yoko jejuá kó'iyea —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ina ukopóno ne evo Jesus. Ngalíleyake vekópo, itea akó'oti akahá'a Jesus éxeokono óvoheixoku ");
INSERT INTO terNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","vo'oku kahá'ayea íhikaxeako íhikauhiko. Yane hara kíxovokoxoane: —Nguri'ókokonotinemo xunako xanéhiko, undi íhae vanúke ikútipasikoponovoti xâne, yane ínamo kaepékanuhiko, itea mopó'apeke káxe ikénepo, enjepúkopotinemo ungópea xapa ivokóvoti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Itea ako éxina isóneu íhikauhiko Jesus neko yûho koane píkoahiko épemo'ikea. ");
INSERT INTO terNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ina seopâmaka evo Jesus ne pítivokona Kafanâum. Koeku seópea óvokuke ina kixovókoxoa Jesus ne íhikauhiko: —Na koeti yimópinokokonoe xenékuke? ");
INSERT INTO terNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Itea ako yumápahiko, yunukú koénehiko vo'oku kahá'ayea éxea itukóvotiye ne koati payásoti xapákuke yumópinokokoke xenékuke. ");
INSERT INTO terNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yane ivátakone Jesus koane iháxihikea ne nduse koeti íhikau ahí'okeovaxo, ina kixovókoxoa: —Enepone kahá'ati itúkeovo koati payásoti ya uhá koêti, konókoti ikálihuxopeovo yoko itúkeovo ovoxe uhá koêti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yane ina hiriko kalivôno ne Jesus nonékukehiko koáne nú'uxea koeku kó'iyea: ");
INSERT INTO terNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Itukovo apêti kalivôno kuteâti ra kalivôno yâye njokóyoke, koêkuti itukínoati únati vo'ónguke, undímaka kixóneye. Yoko koêkuti ikxónutineye, haina ûndi kixóneye itea enepone Pahukónuti yara kúevu mêum kixóneye —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ina kixôa Xuâum: —Ihikaxotí, ápe hóyeno noíxone ûti kopúhikopoti ndémoniu ya ihéke, itea sayá'ikoa ûti vo'oku ákoyea itúkapu xáneheixone ûti. ");
INSERT INTO terNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ina kixôa Jesus: —Hákonoeni seya'íkoa, vo'oku ako xâne itúkoti iyupánevoti ya inzáke koyúhotimo ákoyea aúnandi ikénepoke. ");
INSERT INTO terNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Enepone xâne ákoti akapá'avi, koati huvo'óxoviti nê'e. ");
INSERT INTO terNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Koati emo'úti ra yunzó'inopinoe: Enepone xâne porexópitinoe enovópeti puhí koeti úne ya inzáke vo'oku itíkivo hokónuti, ákomo kalíhuina évokea námoepo xoko Itukó'oviti vo'ókuke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ina kixovókoxopamaka Jesus: —Enepo áva xâne vaheréxoti ítuke, itávokinoke hókeonu ne póhuti xapákuke ra kálihunoe kutipónuti, yusikóneni iká'akeokono êno pú'iti mopôi anúkuke tumúneke koésayu'ixea isóneu po'i xâne, ínani kuriná'ekakana úneke ya mar maka hákone koesáyu'ixea isóneu. ");
INSERT INTO terNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Enepo itukapu veô'u váherexino ítike, yusikóneni titúki motovâti ákoyea váherexa ítike. Mani unatíne ákoyea poixo'o veô'u yenópi vanúke, yaneko usokó kó'iyea veô'u itea yenópoti ipihóponovokutike xapa yúku ákotinemo ípukeovoku,  ");
INSERT INTO terNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","óvokumaka kanêti ixómoti níko muyôti yoko yúku ákotinemo ípukeovoku. ");
INSERT INTO terNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Koáne, enepo itukapu hîvi váherexino ítike yusikóneni titúki motovâti ákoyea váherexa ítike. Unatíne ákoyea poixo'o hîvi yenópi vanúke yaneko usokó kó'iyea hîvi itea kirikópokonoti ipihóponovokutike,  ");
INSERT INTO terNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","óvoku kanêti ixómoti níko muyôti yoko yúku ákotinemo ípukeovoku. ");
INSERT INTO terNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Enepomaka itukapu yûke váherexino ítike, yusikóneni meréki, motovâti ákoyea váherexa ítike. Unatíne yenópi natíxokuke Itukó'oviti ya vanúke ákoti poixo'o yûke, yaneko usokó kó'iyea yûke itea kirikópokonoti ipihóponovokutike, ");
INSERT INTO terNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","óvoku kanêti ixómoti níko muyôti yoko yúku ákotinemo ípukeovoku —kíxovokoane Jesus exókoatihiko kónokea ákoyea íyuhixapapu sayá'ikopeovahiko ne váhere ítuke. ");
INSERT INTO terNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ina kixovókoxopaikomaka Jesus: —Vo'oku uhá ketínoe, konókoti víki tiú'itike koekúti kuteâti koeku tiveko yúku, maka itíkapune kuteâti únati ánahi nikokónoti kuteâti koeku yúki. ");
INSERT INTO terNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Koati únati koekúti ne yúki itea enepo auké'e taú'iko, ákone oxéne aúkopinokono taú'iko. Hane yákoeneye kuteâti koeku koâti únati yúki kouhékoti xánena, koane aúhepeinokokomaka iséneu ákoti yakapákaka —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Úkeane pího ne Jesus ya Njúdeya poixô'oke húveona Njôrdaum. Ho'úxopinovamaka êne xâne. Yane íhikaxoanemaka Jesus kuteâti kixoku itúkeovo ho'uxínova êno xâne. ");
INSERT INTO terNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ina ahi'ókovomaka Jesus ne farîzeuhiko, enepone yuixóvoti hókea yútoe Muîse, koane épemo'ikeahiko, kaha'aînoati pahúkeovo ya yumópope. Hara kíxoahiko: —Motóva kuríkea yêno ne hóyeno? ");
INSERT INTO terNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ina yumopâ Jesus: —Ná'ikopo kó'eye páhoe Muîse itúkeokono ya yútoeke? ");
INSERT INTO terNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ina yumopâhiko: —Poréxoa Muîse ápeyea koyuhópeti kotuyôpoti îha itúkeovo koyenókokotihiko motovâti kuríkea yêno ne hóyeno —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ina kixovókoxopamaka Jesus: —Yutóxinoake Muîse nê'e vo'oku tiú'ikonoe yomíxone. ");
INSERT INTO terNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Itea inâ apê ra mêum, itúkoa Itukó'oviti ne pi'âti, hóyeno yoko sêno. ");
INSERT INTO terNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Énomone kuríkino há'a yoko êno ne koyénoti motovâti komúxoneyea yêno. ");
INSERT INTO terNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yane koati póhupotine ne pi'âti. Ákonemo apí'a. Koati póhupotine. ");
INSERT INTO terNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Koeku koyúhoyea Itukó'oviti poéhapeane ne pi'âti, ako yusíka ápeyea xâne haxakópati —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Koeku seópeahiko óvokuke, épemo'ikopo Jesus ne íhikauhiko koêku ne yuhómeku. ");
INSERT INTO terNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ina kixovókoxoa Jesus: —Enepone kuríkoti yêno ina okoyénopomaka po'i sêno, ya xoko Itukó'oviti koati aupú'ikoati ne inúxoti yêno. ");
INSERT INTO terNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kúteanemaka xoko sêno kuríkoti îma, enepo oko'ímapo po'i hóyeno, ya xoko Itukó'oviti koati aupú'ikoati ne inúxoti îma —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yane ápe xâne omotíhiko kalivôno xoko Jesus motovâti ípihea vô'u tutíkuke, itea sayá'ikoa íhikauhiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Noixoâne Jesus, yupíhova ákoyea aúhepe isóneunoa. Hara kíxovokoxo íhikau: —Síkeane kenó'okea ne kálihunoe kalivôno njokóyoke. Hako seya'íkoa, vo'oku kuteâti koeku usó kóyeyea kenó'okinonu râ'a, énomonemaka kónoko kó'iyeaneye ne xâne yonópoti natíxokuke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Koati emo'úti ra yunzó'inopinoe: Enepone ákoti akahá'a íkutipasikeovo kalivôno ya usó kóyeyea kenó'okinonu, ákomo kalíhuina yonópea natíxokuke Itukó'oviti vanúkeke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ina namukoâhiko Jesus neko kalivónohiko, koane ípihea vô'u tutíkuke epemínoati unako koêku xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Koeku ukóponea ne evo Jesus apé koene hóyeno ehakínovati. Ipuyuké koéne nonékuke Jesus ina kixôa: —Ihikaxotí, iti koati únati. Kutimea ngónoko indúkea motovâti ómbea xoko Itukó'oviti ákotinemo hunókoku? ");
INSERT INTO terNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ina kixôa Jesus: —Yéxoakopomea kixó'ekone yiûho keyuhónumeku indúkeovo únati? Vo'oku ako po'i únati ákoti itukapu Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yéxoa ne páhoenokono xâne itúkea yútoeke Muîse, enepone koêti: “Hako kepéko. Hako yaupú'iko po'i xâne kepiné'iyiti yêno. Hako yomêxo. Hákomaka itikóheo koeku po'i xâne. Hako simikíkixino po'i xâne, yoko tiya yá'a koane yêno” koêti —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ina kôe ne hóyeno: —Ihikaxotí, heú ngíxoa indúkea nê'e ukeátine ngalivónoxoiko —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yane pono-ponó kixínoane ûke Jesus xaneâti ákoyea omótovoa okóvo, ina kixôa: —Poéhaiko koekúti nékone itíki. Yakávaneponoa uhá koêti ne apeínopiti, ina perekéxa xâne ákoti apeínoati ne ésa'i. Yane apêtimo apeínopiti vanúkeke, ina kina'áka ingéneke hékinu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Itea ako aúhepea isóneunoa neko yuhó'inokono. Yupihovó kôe isóne'ekeovo koeku pihópea kama'âti neko êno apeínoati. ");
INSERT INTO terNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ina komomâhiko Jesus ne íhikauhiko koane kíxovokoxea: —Imáko itúkinovo tiú'iti yonópea natíxokuke Itukó'oviti vanúkeke ne xâne iríku —kíxovokoxoane ");
INSERT INTO terNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iyúpaxeova íhikauhiko neko yûho. Yane káyukopinoamaka Jesus kíxovokoxea: —Itínoe kutí ngíxone nje'éxaxapa, koati tiú'itimo yonópea natíxokuke Itukó'oviti vanúkeke ne xâne kuvóvoti ênoti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ako'óneni oríko vékea kámelu xoko kali ihínone tôpe uhe'ókopeti, yane yonópea natíxokuke Itukó'oviti vanúkeke ne xâne iríku —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yupihovó koéneoxo iyúpaxeova íhikauhiko ne yuho Jesus koane kíxeokoko: —Kutí'ikopomeamo motovâ itúkeovo koítovone Itukó'oviti koane yonópea xokóyoke? —kixókokone. ");
INSERT INTO terNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yane pono-ponó kixínoane ûke Jesus koane kíxovokoxea: —Enepone ínixone xâne itúkeovo yupihóvoti tiú'iko, ako átiu'i xoko Itukó'oviti, vo'oku ako ápahuina koekúti ákoti itâ itúkea ne Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ina kixôa Pêteru: —Kurí kíxoa ûti ne uhá koeti koekúti koeku hókeopi ûti. ");
INSERT INTO terNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ina yumopâ Jesus: —Koati emo'úti ra yunzó'inopinoe: Ako ápahuina xâne ákoti okotíxo ítukevo vo'ónguke koane vo'ókuke ra inámati ihíkauvoti ínzikaxone ákotimo námoepo vo'ókuke. Enepone ákoti okotíxo óvoku, po'ínuhiko, êno, há'a, xe'éxaxapa, áko'o itukovo poké'exa, ");
INSERT INTO terNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yupihóvatimo kurí'uxeovo yara koeku kó'oyene kuteâti ne koekúti ákoti okotíxoa vo'ónguke. Énomone kuteâti óvoku, po'ínuhiko, êno, xe'éxaxapa, koane poké'exa. Poéhapoamo séndu anú'ukeamo námoepo yane póhutihiko koekúti ákoti okotíxoa, koane apêtimakamo kotíveti koekúti vékoku. Yoko káxehiko keno'ókoti, yonópotimo xoko Itukó'oviti ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Itea enómo xâne teyonéti koeku kó'oyene, okópotimo ikenétike. Kene ne ákoti apayáso ovoti ikenétike kó'oyene, énomonemo itukóvoxo koati teyonéti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Koeku yóneahiko Njeruzálem, inuxó kôe ne Jesus tumúneke ne íhikauhiko. Koati iyupáxovati íhikauhiko. Kene ne po'ínuhiko xâne hokotímaka Jesus, pikóhiko. Ina ahikúxoa Jesus ne íhikauhiko yane po'ínuhiko xâne. Yane turíxovone kaúhapu'ikinoa ne kixókonokumo. Hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Kó'oyene Njeruzálem vonóne, yoko nguri'ókokonoatinemo ne tutíhiko sasedóti inuxínoti viyénoxapa hó'eke, koáne ne éskiriba, enepohikone ihíkaxoti yútoe Muîse. Koati ngixókonokunemo, undi íhae vanúke ikútipasikoponovoti xâne, ínamo pahukáhiko ngoépekeokono, ínamakamo kuri'ákanu xâne ákotihiko itukapu viyénoxapa jûdeu éxoti koeku poké'exa ûti. ");
INSERT INTO terNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yane koemóke'enutihikomo, apurú'okonutihikomo, koane yehepóke'exonutihikomakamo, ínamo kaepékanu itea mopó'apeke káxe, enjepúkopotimo ungópea xapa ivokóvoti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yane ahí'okovone Jesus ne Teâku yoko Xuâum, enepone xé'ahiko Nzebêdeu. Hara kixóhiko Jesus: —Ihikaxotí, mani kaha'âti ûti peréxivi ne vépemopike kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ina kixôa Jesus: —Kuti kehá'a indúkinopi? ");
INSERT INTO terNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ina yumopâhiko: —Enepomo itikápapune hána'iti ihayú'iuti nâti xoko netíxoku, peréxavimo vivátakea xîririkuke payásoyea ûti, póhuti yéxopeke, koane po'ínu lepékuke. ");
INSERT INTO terNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ina kixôa Jesus: —Ákonoe yéxa koêku ne yépemonuke. Iteâtikopomo víki ne êno kotíveti koekúti véngokuikomo? Iteâtikopomakamo ne êno kotíveti koekúti enepo yána yoúkeke kuteâti ngixókonokumo? ");
INSERT INTO terNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Êm, vitoâtimo —koénehiko. Yane hara kíxoa Jesus: —Vikoâteoxomo kuteâti ne véngokumo, koane yoúkekemakamo yóno ne êno kotíveti koekúti kuteâti ngixókonokumo. ");
INSERT INTO terNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Itea enepone ivétaki énjopeke yoko lombékuke, haina ûndi noivókoxoa ivatákoatimo, itea hanemo ivátakopa xâne, koúsokinovokene —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yane ímaikinovo Teâku yoko Xuâum neko po'ínuhiko yehí koeti íhikau Jesus kameánehiko ne épemone. ");
INSERT INTO terNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ina ihaxíhikoa Jesus ne íhikauhiko ahí'okeovaxo. Hara kíxovokoxoa: —Yéxoanenoe itúkeovo xâne inixókonoti itúkeovo payásoti pahukô xapa xâne. Koati natínahiko exêa koêku. ");
INSERT INTO terNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Itea xepákukenoe, ako ákoeneye, koati pó'iti koêku. Koêkuti kahá'ati itúkeovo payásoti xepákuke, konókoti usó kóyeyea itúkeovo yovóxenoe. ");
INSERT INTO terNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Koane koêkuti kahá'ati itúkeovo koati teyonéti ya uhá koeti xepákuke, konókoti itúkeovo ovóxe ne uhá koeti po'ínuhiko. ");
INSERT INTO terNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Vo'oku hainámaka nzimínoti enó'iyea ovónje kouhépekoti ngóyeku, itea nzimínoti indúkeovo ovoxéti yoko ivóngeovo motovâti enó'iyea xâne ngoítovone, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ina pího ne Jesus yoko íhikauhiko ya pitivóko koéhati Njeríko. Ipuhíkopeanehiko ne pitivóko, koánemaka êno xâne hokó'ixoati, ápe komítiti koéhati Mbatímeu, xé'a Tímeu, vatá koyêti xe'ókuke xêne ixómoti epêmo. ");
INSERT INTO terNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kamoáne nê'e itúkeovo Jesus íhae Nazâre hunonêa, turíxovone vaúkea. Hara koe yûho vaúkea: —Jesus, ámoripono Ndávi, yokóseananu! —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Êno xâne saya'íkoati, pahukoâti kóyunukeovo, itea inamá'axone kohonóko emó'u kó'iyea: —Iti ámoripono Ndávi, yokóseananu! —kóyene. ");
INSERT INTO terNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yane xe'ó kó'inoane Jesus, ina pahukôa iháxikeovo. Ina pího ihaxíkoponoati neko komítiti. Hara kixóponoa: —Aúhepepone iséneu. Yexépuka vo'oku iháxikopine —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yane xépu koéne neko komítiti, koane kurí kíxea kápana koeku píhea xoko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ina kixôa Jesus: —Kuti kehá'a indúkinopea? —Ihikaxotí, ngahá'ati íninjopea. ");
INSERT INTO terNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ina kixôa Jesus: —Motóvane pihépi. Itévone vo'oku kívivonu —kíxoane. Énomone yaneko ôra, ínixopone, yane pihóne ikéneke Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ye'éxoane evo Jesus ne Njeruzálem, koáne ne ipuxóvokuti koéhati Mbetefâje yoko Mbétanea xêrerekuke kali mopôi iháxoneti Olívera, pahúkoane Jesus ne pi'âti íhikau inúxea tumúneke ");
INSERT INTO terNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","koane kíxeahiko: —Pihénenoe yane kali ipuxóvokuti timúneke. Ehá'axomo símeaya, inixéponotinoemo xe'exa njuméntu ika'ó koyêti, âvoti ivú'ixeokonoku. Yane kíxeanoemo ne iká'o, ínamo yamapâ yâkeneye. ");
INSERT INTO terNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Enepomo áva xâne epemó'ikopiti itíkoake, haramo íxea: “Konokoâtiko Vúnae râ'a, itea kó'oyenemo pahukópinopeatimo” íxeamo —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Úkeane pihohíko. Yane ínixoponoane ne xe'exa njuméntu ika'ó koyêti xêrerekuke pahapéti nonékuke ovokúti. Yane kúxeoponoane. ");
INSERT INTO terNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yoko xapákuke ne xâne noixoâti, ápe kixoâtihiko: —Kuti itíkoanoe ne xe'exa juméntu kíxeinoake? ");
INSERT INTO terNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ina yumopâhiko kuteâti páhoenoa Jesus koyúhoyea. Yane síkoanehiko omópea. ");
INSERT INTO terNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Omopânehiko neko xe'exa njuméntu, ina ramaké'exoa ya kápana, yane ivú'ixoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Êno xâne ikapákinoati kápana xenékuke, koane enómaka ipíhinoati tuti exáte oxéneke, tétoehiko ya mêum, kouhé'ekinoati vékoku. ");
INSERT INTO terNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eneponeko êno xâne tumúneke koane ikéneke, aínovo kohonókoti yûho vaúkexea: —Koati hána'iti ihayú'iuti rakéne. Viháyu'ika ra páhoenovi Vúnae Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Koati hána'iti seánakovi Itukó'oviti rakéne, enepone natixínovitimo kuteâtimaka natíxea voxú'ikene Ndávi. Koati hána'iti ihayú'iuti ne Itukó'oviti yâkonoye vanúkeke —kóyehiko. ");
INSERT INTO terNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Simoáne Jesus ne Njeruzálem, pihóne ya témpulu, enepone hána'iti imokóvokuti. Uhá kíxoa Jesus komómoyea, yane káyukopovo ya Mbétanea koánemaka íhikauhiko ikéneke vo'oku hahámeyeane yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yaneko po'i káxe ipuhíkopeahiko Mbétanea épekoa hímakati ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Avo malíka, noíxone xuve fîgu ênoti tûti. Ina pihoyâ noíxoponea ápeyea há'i. Simoáne, ako ápahuina há'i noíxone. Poéhane êno tûti apê, vo'oku âvoti simâpu kaxena kahá'ipe. ");
INSERT INTO terNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ina kôe ne Jesus: —Ukeátine kó'oyene, ákonemo véyeokonoku há'i râ'a —koéne. Yoko kámea íhikauhiko neko yûho. ");
INSERT INTO terNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yane pihónehiko ne evo Jesus ya Njeruzálem. Yâkoxonoye, ûrukova Jesus ne témpulu xoko kíndana, yane kópuhihikopo xanéhiko kaváneti yoko vanéxotiya. Ina kasa'îrikea mesána neko koperáxoti xanéhiko esa'íkoti tiûketi koánemaka ivátakokuhiko neko kaváneti kurûte. ");
INSERT INTO terNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yane ákonemaka síka Jesus ne xanéhiko apêti ínone vekó kíxea kíndana ne hána'iti imokóvokuti. ");
INSERT INTO terNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ínamaka ihíkaxoahiko Jesus. Hara kíxovokoxoa: —Koati apêti yutoéti emó'uke Itukó'oviti koêti: “Enepora imokóvokuti óvongu, iháxeokonotimo óvoku itúkea orásaum ne uhá koeti xâne, koêkuti óvohikoku yara kúveu mêum” kôe, itea itíkoanenoe óvoku ómevotihiko —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yoko kámeane yûho ne tutíhiko sasedóti inuxínoti jûdeu hó'eke koánemaka ne éskiribahiko, enepone ihíkaxoti yútoe Muîse. Yane opósikonehiko kixoku koépekea Jesus, itea píkoahiko vo'oku heú kó'iyea xâne iháyu'ikea ne ihíkauvoti íhikaxone Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hahaméne, ipúhikopeane Jesus yoko íhikauhiko ne pitivóko. ");
INSERT INTO terNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yuponíne koeku vekópea evo Jesus neko xêne, noíxoanehiko movó'oyeane ne xuve fîgu. ");
INSERT INTO terNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yane puyákoponova okóvo Pêturu ne yuho Jesus vo'ókuke, ina kôe: —Ihikaxotí, enepone xuve fîgu keyúhone ákoyeanemo akáha'i, movó'one. ");
INSERT INTO terNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ina kixovókoxoa Jesus: —Konókoti kívivo Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Koati emo'úti ra yunzó'inopinoe: Enepo áva pahukoâti ra koati hána'iti mopôi áhikuxeova ne ókoku koane kuríno'ekopeova ne mar, koeku itúkeovo koati kaná'uti kutípea kó'iyeanemoye kuteâti yûho, ákoti amuyá'i isóneu kutípea, itukínokonoatimo. ");
INSERT INTO terNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hukinóvoti ngíxeopinoe: Uhá koeti koêkuti yépemone ya orásaum, konókoti kitípi itíkinokonoamo, yane itikínokonoatimo. ");
INSERT INTO terNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Enepo itikánoe orásaum, itukovo apêti xâne poé'ainoke iseneú, hákonoe yunakôa iséneuke ne koekúti, itea kutí íxepane ákoti kixópiku, maka katúyapinapeane Ha'a ûti íhae vanúke ne pehúnevo. ");
INSERT INTO terNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Itea enepomo yunakânoe iséneuke, hákoti kutí kixêa ákoti kixópiku, ákomakamo katúyapinapea Ha'a ûti íhae vanúke ne pehúnevo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Úkeane kayukópovo ya Njeruzálem ne evo Jesus. Koeku vékea hána'itike imokóvokuti ne Jesus, pihínoa tutíhiko sasedóti inuxínoti jûdeuhiko hó'eke, yóko'omaka ne éskiriba, enepohikone ihíkaxoti yútoe Muîse, koánemaka po'ínuhiko teyonéti xapákuke tutíhiko jûdeu. ");
INSERT INTO terNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hara kixóhiko Jesus: —Na úkea ne xunakóti itíkike ra koekútihiko? Kuti porexópi kíxineye ne ítike? ");
INSERT INTO terNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ina kixovókoxoa Jesus: —Anéyemaka émbemopikenoe. Yimápanu, yane enjókopeatinoemo porexónoati indúkea ra koekútihiko índuke. Hara émbemopinoe: ");
INSERT INTO terNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kuti porexôa ne Xuaum Mbátita áhikea? Íhae Vanúke? áko'o xâne yara poké'e. Yimápanunoe. ");
INSERT INTO terNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ina kixokókohiko: —Enepomo vokoyúhoa itúkeovo Íhae Vanúke pahukôa, “Ná'ikopo koeti ákoino yakútipoanoe ne Xuâum?” kixo'óvitimo. ");
INSERT INTO terNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kene enepomo vokoyúhoa itúkeovo xâne yara poké'e pahukôa, ákomaka aúnatiya —koénehiko. Koati pikotíhiko kíxoakumo xanéhiko vo'oku heú koe xâne ínixea itúkeovo koati páhoe Itukó'oviti koyúhoyea emó'u ne Xuâum. ");
INSERT INTO terNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Énomone kixínohiko Jesus: —Ako véxa. Ina kixovókoxopamaka Jesus: —Ákoikopomaka ongóyuhoinopeanoe porexónoati indúkea ra koekútihiko índuke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yane turíxovone Jesus koyúhoinoahiko íhokoake ne âha íhikaxea. Hara kôe: —Ápe hóyeno nôti êno xuve úva. Itúkinoa îpi neko nóne ina itûko tángi, kótikovoku ho'o úva itûko víyum, ínamaka koexépuko óvoku koyonó'inoati ne nóne, éyevoti vanúkuke motovâti ákoyea malíka ínixoku. Yane kurí'okoane katarákinoati ne nóne motovâti haxákopea avané'e êho. Yane pihóne po'i poké'e. ");
INSERT INTO terNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Simovóne kaxena veyóvope ha'i nonéti, pahúkone ahínoe xokôyoke ne katarákinoati ne nóne motovâti veyópoinoa námoepo ukeâti ne nóne úva. ");
INSERT INTO terNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Itea enepohikoneko katarákinoati nóne, namú kíxoane neko pahoéti. Yane yehépoke'exoane, ina pahukópa káyukopeovo ákoti omópone. ");
INSERT INTO terNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yane káyuko pahúkea po'i ahínoe neko únae kavâne, itea ákoneoxo téya katarákinoatihiko nóne, koane óko'okea tûti koane komóhiyea. ");
INSERT INTO terNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pahúkopoikomaka po'i ahínoe ne únae kavâne, itea koépekoahiko katarákinoati nóne. Enómaka po'i ahínoe páhoenoa, itea yehépoke'exoahiko katarákinoati nóne, kene po'ínuhiko, koépekoahiko. ");
INSERT INTO terNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yane ápe póhutiko xâne âvoti pahukínahiko. Énomone ne koati xe'éxa ákoti omotóva okóvo. Koati ikenétike ixíkoa pahúkea vo'oku hara koeti isóneu: “Teyoâtihikomo ra nje'éxa” koêti isóneu. ");
INSERT INTO terNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Itea hara kixókokohiko ne katarákinoati nóne: “Eneporâ'a, koati ítukenemo ra poké'e ivakápune há'a. Hingá, kaépeka ûti maka vitúkapeane ne mani ítuke, íkuinoake há'a ivakápu” kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","—Yane namú kíxoanehiko ina koepékoa. Yane kuríkeane mûyo meúkeke yane kavâne —koéne éxetina. ");
INSERT INTO terNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ina kixovókoxopamaka Jesus neko kamokénoatihiko: —Ná'ikopomo kíxoaneye únae nonéti neko katarákinoatihiko ne nóne? Pihinoâtimo, ínamo kaepékexa, yane porexópotimo po'ínuhiko xâne kátarakinoa ne nóne. ");
INSERT INTO terNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ákoikopo yíhoikikunoe ne yutoéti emó'uke Itukó'oviti? Énomone ne koêti: “Enepone mopôi noívokoxine itúkoti péti, ainovó kôe itukóvo koati turíxeovoku uhá koeti kuteâti koeku koati inúxoti mopôi turíxeokonoke péti. ");
INSERT INTO terNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Koati Vúnae Itukó'oviti kixoáneye. Yoko vínixoa itúkeovo koati êno ihayú'iuti koekúti ne ítuke” koêti —kíxovokoxoane Jesus ihókopovati ne mopôi noivókoxineti. ");
INSERT INTO terNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yane opósi'ixoanehiko tuti jûdeu kixókumo iká'akea Jesus, itea koati pikoti xanéhiko. Yoko exó kíxoanehiko neko tutíye itúkeovo énomonehiko kíxo Jesus yane exetínati. Yane ákone po'i épemo'ikoke Jesus, píhohikopone. ");
INSERT INTO terNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yane ápe páhoe tuti jûdeu xoko Jesus. Enepohikone páhoe, aínovo farîzeuhiko yoko xanénahiko Êrodi, eneponeko nâti. Yoko kahá'atihiko iyupaxó kíxea épemo'ikea Jesus, kaha'aînoati pahúkeovo ya yumópope. ");
INSERT INTO terNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Simoné'ehiko xoko Jesus, hara kixóponoa: —Ihikaxotí, véxoa itíkovo koati ponóvoti vo'oku ako neívakaxa xâne, itea kutíkokone uhá koeti xâne xikóyoke. Ako yokómomoyi payásoko, ítea koati yixóvati ne kaná'uti kixovókuti koane íhikexi ne páhoenovi Itukó'oviti. Ná'ikopo kó'inoaye iséneu ne kóperaxovike Sêza, enepone payásoti nâti ya Róma éxoti koeku ûti? Pahúkovi Ponóvoti Kixovókuti hó'e ûti poréxea ûti? áko'o ákomea okónokoa poréxeokono —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Itea exó kíxea Jesus isóneuhiko itúkeovo itûkoheovoti. Yane hara kíxovokoxoa: —Na koeti yopósi'okinovonunoe, keha'aînonuti mbahúkeovo ya yumómbope? Yamínanunoe póhuti pe'u tiûketi, ngaha'âti ngomómoyea —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yane omínoanehiko ne tiûketi. Ina kixovókoxopa Jesus: —Kutí'ikopo itukôa nône yoko îha ovâ ra tiûketike? Ina yumopâhiko: —Sêza. ");
INSERT INTO terNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ina kixovókoxopaikomaka Jesus: —Enepone ítuke nâti, peréxapa. Koáhati ítukene. Kúteanemaka koêku xoko Itukó'oviti, koêkuti páhoenopi konokoâtimaka itíki —kíxovokoxoane. Yane yupíhova iyúpaxeovahiko unáko ne yumópope Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yane ahí'okovomaka Jesus ne sadúseuhiko, enepone koyúhoti ákoyeamo exépuhikapa ne ivokóvoti. Hara kíxoahiko: ");
INSERT INTO terNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Ihikaxotí, ya yútoe Muîse kûreinovi, hara kôe: “Enepo ivakápu hóyeno ákoti apáhuina xe'éxaino yêno, konokoâti itúkeovo po'ínu ne ivokóvoti koyenópea yêno ne po'ínuikene, maka avané'e xe'éxainoa, kutí ákoepone xe'éxa ne ivokóvotine” koe yútoe. ");
INSERT INTO terNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yoko ápe nóvo seti koeti hóyeno kopo'ínukokoti. Kóyenone neko xuvé'eti. Ivokóvone, ako ápahuina xe'éxa. ");
INSERT INTO terNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Enepone sêno ivokóvoti îma, hane koyenópa atípo neko imá'ikene. Ivokóvone nê'e, ákomaka xe'éxainoa neko sêno. Kúteanemaka koêku ne mopó'ape, ivókovone ákotimaka xe'éxainoa neko sêno. ");
INSERT INTO terNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Eneponeko seti koeti hóyeno kopo'ínukokoti, heú koéhiko kóyenoyea neko sêno, itea ako ápahuina ikoxé'exaxoati xapákuke. Heú koené'e ívohikeovo, ina ivokóvomaka ne sêno. ");
INSERT INTO terNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eneponi akaná'u exépuhikopea ne ivokóvoti, kutí'ikoponi itukópaxo koati yêno ne sêno xapákukehiko exepúhikapa nekôyo? vo'oku heú kó'iyeahiko kóyenoyea ne sêno —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ina yumopâhiko Jesus: —Pahúkinovoke iséneunoa ra koekúti, vo'oku ákoyea yéxa koêku ne yutoéti emó'uke Itukó'oviti koánemaka ne xunako Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vo'oku enepo exepúhikapane ne ivokóvoti, ákonemo koyénoti koane ko'ímati. Kutí koépotinehikomo ánju íhae vanúke, ovóxehiko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ákoikopo yíhoikiku yútoeke Muîse koêku ne exépuhikopeamo ne ivokóvoti? Énomone yane koyúhoyeaku koêku ne kali xuve tikóti ixómoti iruméko ákoti ara'ákapu, xoko yuhó'inoa Itukó'oviti ne Muîse, enepone koêti: “Undi Itukó'oviti, kuvóvone Âbraum, kuvóvonemaka Izáki yoko Njáko” koêti. ");
INSERT INTO terNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yane hainá'ikopo kuvóvone ivokóvotine ne Itukó'oviti, ínapo “Âbraum-kene” akôe, itea koati kuvóvone xâne iyukóvoti. Koati hána'iti pahúkeovo iséneunoa —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yoko ápe éskiribaya, enepone ihíkaxoti yútoe Muîse ixómoti kamokénoyea kixoku yúho'ixeokoko. Noixoâne unako yumópope ne Jesus, hara épemoa: —Kuti itukóvoxo koati nókone xâne itúkea yane uhá koeti páhoenovi Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ina yumopâ Jesus: —Enepone koâti nokonéti ya uhá koêti, énomone ne koêti: “Itínoe íhae Izarâe, yakámokeno. Poéhane Vúnae Itukó'oviti itukóvo ne koati kaná'uti Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Heru'ó íxea yomíxone koane iséneu koane xináko ákoyea omótova yokóvo ne Itukó'oviti Yúnae” koêti. ");
INSERT INTO terNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kene ne pí'ape, harâ'amaka: “Hako motovâ yokóvo ne po'ínuhiko xâne. Kuteâti kixépovoku ákoyea kemáxatikapapu, énomonemaka íxeaneye ne po'ínuhiko xâne” kôe. Ákone po'ínu páhoenoa Itukó'oviti ne xâne itúkea hána'iti nokonéti itúkeokono yara pi'âti. ");
INSERT INTO terNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ina kixoá'ikomaka éskiriba ne Jesus: —Ihikaxotí, koati únati yimópope, epó'oxo koati kaná'uti poéhayea ne Itukó'oviti. Ako po'ínu kuteâti, poéhane. ");
INSERT INTO terNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Koane koati kaná'uti kónokea heru'ó kíxea uti vomíxone ákoyea omótova vokóvo, koane heru'ó kíxea uti visóneu koane xunako ûti, epó'oxo kaná'utimaka kónokea ákoyea omótova vokóvo ne po'ínuhiko xâne, kuteâti kixoku ákoyea kamáxatikapapu ûti. Énomoneoxo konokóvo yaneko vikó'iparaxea Itukó'oviti kuteâti hó'openohiko átake yoko po'ínuhiko vomínoake kuteâti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Noixeâne Jesus unáko ne yumópope, hara kíxoa: —Ákone ahíkapu itíkopivokumo xanena Itukó'oviti —kíxoane. Yane ákone mapikóvati épemo'ikea Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Koeku íhikaxea Jesus ya témpulu, hara koe épemo'ikoke xanéhiko: —Na kó'inoaye iséneu ne éskiribahiko, íhikaxinoke itúkeovo ámoripono Ndávi ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne? ");
INSERT INTO terNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Vo'oku koati teyonéti voxú'ikene Ndávi koyuhó'iyea koêku mekúke ya xunákoke Sasá'iti Omíxone Itukó'oviti xoko kó'iyeaku: “Hara kíxoa Itukó'oviti ne Únaem: ‘Ivétakapa énjopeke xoko ivátakoku koati ngapáyasokone imókonemo ipuyúkexa nenékuke ne uhá koeti koêkuti okopópiti’ ” kôe. ");
INSERT INTO terNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Koati “Unaém” kixoâti Ndávi. Ápeikopo oxéne itúkeovo ámoripono Ndávi ne Mésiya? —kíxovokoxoane Jesus. Yoko koati úhepetinoa xanéhiko kámokenoyea. ");
INSERT INTO terNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ina koemáka ne Jesus koeku íhikaxea: —Yokóhiyanavoa ne éskiribahiko, enepone ihíkaxoti yútoe Muîse, yómoti hamá kíxea ípovo kahá'ati ínixeokono itúkeovo teyonéti. Koane enepo yuhoíkokono koeku vékea ya none ovokúti, ahá'axomaka. ");
INSERT INTO terNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Koáne ya íhikaxovoku hó'e yoko ya xapa ayuíti, yómotimaka ivátakea xoko ivatákokuti ya nonekútike xoko ivátakoku koati payásotihiko. ");
INSERT INTO terNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Itea inípono kixoku senóhiko ivokóvoti îma, kutí koe hu'uxeâti óvoku. Yane vo'oku kó'umokeahiko itúkea orásaum, kutí koéhiko koati ponóvoti. Itea yupihóvotimo tiveko ipíhoponeokonoke ya po'ínuhiko xâne vo'oku kixoku itúkeovo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Koeku vatá kóyeyea ne Jesus yane hána'iti imokóvokuti, inonexó kóyenoa ne kuríkokonoku tiûketi poreúti. Yoko ixómoti komomâ Jesus ne xanéhiko koeku kuríkea tiûketinaya. Êno xâne iríku kuríkoti ênoti tiûketiya. ");
INSERT INTO terNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ina keno'óko sêno ivokóvoti îma, ákotimaka apeínoati, kurikóponoti kali pi'âti pe'u tiûketi ákoti axu'ína ovâti. ");
INSERT INTO terNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ina ihaxíhiko íhikau ne Jesus. Hara kíxovokoxoa: —Koati emo'úti ra yunzó'inopinoe: Enepora sêno ivokóvoti îma, ákotimaka apeínoati, énomone xu'inâ pôreu yara uhá koeti po'ínuhiko poréxoti. ");
INSERT INTO terNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Vo'oku enepone po'ínuhiko poréxoti, xoko haxa tiûketina véyo enepo porêxo. Kene ra sêno, heú kíxoa poréxea ne kali apeínoati, enepone mani kuvóvoneiko ya nókoneke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ipuhíkopeane Jesus ne témpulu, ápe íhikau kixoâti: —Ihikaxotí, yokómoma êno úhe'ene ra hána'iti péti koane oveâti xe'ókuke ipixoâti, koane itóvokuhiko ra mópoina pâredena. ");
INSERT INTO terNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ina kixôa Jesus: —Neíxoa koeku uhá koêti ra hána'itinoe koexépoetihiko ítuke ra péti koane oveâti xe'ókuke ipixoâti? Ákomo ápahuina mópoina pâredena ákoti katahínekexakana. Heu-heú koetimo kotóhinekexeokono —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Koeku ivátaheixea ne Jesus oúke kali mopôi iháxoneti Olívera, inonexó koépinoa neko hána'iti imokóvokuti. Yane ápe épemo'ikoake evo Pêturu, Xuâum, Teâku yoko Ándere. Yoko ainóvotinehiko, ako po'i xâne xokóyoke. Hara kixóhiko Jesus: ");
INSERT INTO terNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Yokóyuhoinovea ápepemo ra koekútihiko kixínevikemeku, yoko itukóvotimoye hoénaxovope enepo kausákapune ra uhá koeti koekútihiko kíxene. ");
INSERT INTO terNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yane turíxoane Jesus koyúhoyea koêkumo. Hara kôe: —Yokóhiyanavonoe, maka hákone aupú'ikopiti. ");
INSERT INTO terNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vo'oku enómo xâne simôti xepákukenoe iko'ítukexoti înza. “Undi páhoe Itukó'oviti koíteovo xâne” koetímo. Koane enómo ítone aúpu'ikea. ");
INSERT INTO terNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Enepo yeyekáxanoe ápeyeane ákoti tôpi óvoku isukókoti koane kemané'emaka po'ínuhiko eyekoûti ápeyea kahá'ati isúkeokoko, hákonoemo kenóko'i, vo'oku konókoti kó'iyeanemoye itea yanê'e, âvomo simápu hunókoku ra mêum. ");
INSERT INTO terNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vo'oku inúxotike apêtimo íhae po'i poké'e isukóponoti xanéhiko íhae po'i poké'e. Koane apêtihikomakamo nâti isukókoti. Ákomakamo tôpi óvoku iyuyôti poké'e koáne hímakati. Enepora koekútihiko, koati turí'ikonemo hána'iti tiveko koekúti. ");
INSERT INTO terNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Itea usó yákoyenoe vo'oku yomokónotinoemo yuhoíkovokutike, koane nonékuke pahúkotihiko ya íhikaxovoku hó'e xanéhiko. Yihipóke'exokonotinoemo, epó'oxo yomokónotinoemo nonékuke ngovenâdohiko, koane nonékuke nâti yepemó'ikokonotimo vo'óngu. Kixínekonokenemoye motovâti keyúhoyi emó'um nonékukehiko. ");
INSERT INTO terNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Itea inúxotike, enepora inámati ihíkauvoti ómonem, konokoâtimo koyúhoyeovo xapa xanéhiko ya uhá koeti poké'e, koêkuti óvohikoku yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Enepo yamakánanoene, koane kirikákanane xoko pahúkotihiko, hákomo pipokéxinoa iséneu ne kixékumo yiûho yimópike, itea koêkuti éxokopike Itukó'oviti keyúhoyi yaneko ôra, énomonemo yokóyuho vo'oku hainamo ukeâti xikóyoke ne yiuhómo, itea Sasá'iti Omíxone Itukó'oviti ne ikoyúhoxopimo. ");
INSERT INTO terNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Apêtimakamo xâne kuríkoti koati po'ínuhiko xoko payásotihiko xâne motovâti koépekeahiko. Kúteanemakamo kíxoaku há'a ne xé'a. Apêtimakamo isukópoti koati há'a yoko êno. Koati koepékopatimo. ");
INSERT INTO terNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yupihóvatimo púveopi uhá koeti xâne vo'oku itíkivonoe hokónuti. Itea enepone koxuná'ixovoti ingéneke ákoti aukápapu ikéne tukú koeti hunókokuke, énomonemo pihopô vanúkeke xoko Itukó'oviti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ina koe'íkomaka Jesus: —Enepo neixânenoe ne êno váhere koekúti xoko ákoyeaku omótova óvea koesáyu'ixoati koane kotohínekexopati ne koati sasá'iti kixovókuti, hara ngôe vo'ókuke: (Yoko koêkuti yuhoíkoati râ'a, apásika éxea koêku kixó'ekone.) Enepohikone xâne ovotíya Njúdeya, okóho'inehiko xapa hána'itinoe mopôi. ");
INSERT INTO terNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kene koêkuti xâne ovoti ómomikokuke oúke pêno, hákone urúkopovo kúveu óvoku veyóponea koêkuti apeínoati itea aká'ikaneye okóho'iyea. ");
INSERT INTO terNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kúteanemaka koêku ne ovóheixoti ya mêum, hákone aukópovo veyóponea po'i ípovo óvokuke. ");
INSERT INTO terNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Hanemo kixovóhiko yaneko káxe, senóhiko ihaíkoti yoko ohíkotiko xe'éxa. ");
INSERT INTO terNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yépemaikoponoe Itukó'oviti ákoyeamo itúkapu ya xapa kásati ápeyeamo ra koekútihiko. ");
INSERT INTO terNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vo'oku yaneko káxehiko, koati yupihóvatimo tivéko ne koekútihiko ákoti ápeyeaku ukeâti inâ itukôa Itukó'oviti ra kúveu mêum tukú koeti kó'oyene, epó'oxo ákonemo ápeyeaku kuteâti tivéko ra koekúti. ");
INSERT INTO terNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yoko eneponi kaxu'íkenexa Itukó'oviti neko káxehiko, ákoni iteóvati. Itea vo'ókukehiko ne noívokoe Itukó'oviti, enepohikone iháxiu itúkeovo xe'éxapone, ákomo káxu'ikenexa Itukó'oviti neko káxehiko. ");
INSERT INTO terNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Yane enepomo áva kixópitinoe: “Harâ'a ne Mésiya, páhoe Itukó'oviti koíteovo xâne” ixekána, áko'o “Anêko yâko” ixekána, hákonoemo kitipôa, ");
INSERT INTO terNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","vo'oku enómo koyúhoti itúkeovo Mésiya, páhoe Itukó'oviti koíteovo xâne, itea ákomo akána'u. Yoko enómakamo mahi porófeta koyúhoti emo'u Itukó'oviti, itea aínovomo ákoti akaná'u. Itúkotihikomo iyupánevoti yoko koekútihiko ákoti noíxeokonoku kuteâti. Muhíkovamo ne koati noívokoe Itukó'oviti, enepohikone koati xanéna, kalíhanimo íteokonohiko vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yokóhiyanavoikoponoe, vo'oku heú ngíxoane ngoyúhoinopeanoe tumúneke símeovo neko káxe —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ina koe'íkomaka Jesus: —Yaneko káxehiko ikénepokemo ne kotíveti koekúti ngixínopikenoe, ákonemo parexa uhápu'ine ne káxe, hahakú koetínemo. Koánemaka ne kohê, ákonemo aúhapu'i. ");
INSERT INTO terNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Irihíkovotimakamo ne hékere. Koánemaka ne po'ínuhiko apêti ya vanúkeke, itohínekexotimo. ");
INSERT INTO terNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yane noixóponutinemo xanéhiko ngena'ákapa xapákuke kapási, undi íhae vanúke ikútipasikoponovoti xâne. Xané ngixópotinemo êno hána'iti njunáko koane únje'ene koeku indúkeovo hána'iti ihayú'iuti. ");
INSERT INTO terNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yane ínamo mbahuhíka ovónje, enepohikone ánju íhae vanúke ho'úxopea ne noívongoe, enepohikone koati njanéna, koêkutimo óvohikoku yara uhá koeti kúveu mêum —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ina koe'íkomaka ne Jesus: —Ivévakaikopo koêku ra xuve fîgu koáne ne ihíkauvoti ínzokoake. Enepo inamápone ne káva'o koane tûti, yéxoanenoe yé'exopeovone kaxena kevópope úko. ");
INSERT INTO terNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kúteanemaka koêku enepo neixânenoe ra koekútihiko ngixínopikemeku, yexoâtinoemo yé'exeovone kaxéna. ");
INSERT INTO terNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Koati emo'úti ra yunzó'inopinoe: Enepone xanéhiko apêtimo yaneko káxehiko, ákomo ivákapu koeku âvoyea kaúsakapu uhá koêti ra koekúti ngixínopike ápeyeamo. ");
INSERT INTO terNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Uké'etimo ra poké'e koánemaka ra vanúke, itea enepora emó'um, ákomo uké'eyeaku. ");
INSERT INTO terNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","—Enepone kaxéna yoko orána ápepemo ne koekútihiko, ako exoâti itukóvotimoye, muhíkova ne ánju íhae vanúke, enepohikone ovoxe Itukó'oviti, muhíkovamaka ûndi, undi Xe'exa Itukó'oviti. Poéhane Nzá'a exôa. ");
INSERT INTO terNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Usokó yákoyeponoe. Itíkapumaka iyukóvoti isóneu, (koane itíkamaka orásaum) vo'oku ákoyea yéxanoe ápepemo. ");
INSERT INTO terNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hara koéneye, kuteâti koeku hóyeno yonoti po'i poké'e. Tumúneke ipúhikea óvoku, poréxoa ne ahínoe éxea koêku ne ítukevo, koane itúkinoa hó'exeake ne póhutihiko ahínoe. Ínamaka pahukôa ne koyónoti pahapéti ixómoyea noímexopa. ");
INSERT INTO terNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hukinóvoti ngíxeopinoe: Usokó yákoyeponoe. Itíkapumaka iyukóvoti isóneu, vo'oku ako yéxa itukóvotimoye káxe nzeópope, undi kuteâti únae ovokúti seópotine, itúkeovomo ya kiyakáxe, áko'o ya kuku yóti, áko'o itúkeovomo ené'ixapune tapî'i, áko'o itúkeovomo yuponii koêti nzeópeamo. ");
INSERT INTO terNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Énomone yákoeneye maka enepo seopó angôe, hákone inu'íngopopi kuteâti koeku xâne imókoti. ");
INSERT INTO terNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Enepora yunzó'inopinoe, kúteanemaka yunzó'ino uhá koeti xâne: Hako kutí kê imokoo koyêti, itea itíkapu iyukóvoti isóneu —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yoko pí'aiko káxe âvoti ya kaxena áyui jûdeu hó'eke iháxoneti Páskoa, níkeakuhikomaka pâum ákoti kohiyákoati. Yoko enepohikone tuti sasedóti inuxínoti jûdeu hó'eke, yóko'omaka ne éskiribahiko ihíkaxoti yútoe Muîse, ixómotine oposí'ixo kixoku omé kíxea Jesus iká'akea koane koépekea. ");
INSERT INTO terNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hara kixókokonehiko: —Itea ako yusíka itúkeovo xapa ayuíti mará'inamo ímaikexapu xanéhiko —kixókokone. ");
INSERT INTO terNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yoko Mbétanea óvoheixo ne Jesus óvokuke Símaum, eneponeko unatípeati koati váhere arinéti iháxoneti lépara. Koeku ixómoyea nîko ne Jesus, simóne sêno omoti íhaku xêru itukéti ya hopú'iti mopôi iháxoneti alabásturu. Yoko enepone ómone, puhí koa xêru iháxoneti nârdu, ákoti ánahi, yupihóvotimaka hepíko. Katatákoane sêno neko íhaku xêru, ina ovopú'iko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Xapákuke neko xanéhikoya, ápe poe'aînoati isóneu. Hara kixókoko: —Na koeti évokinoa ne êno kohépiti xêru? ");
INSERT INTO terNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yusikóneni kaváneyeovo, ínani parekéxakana xanéhiko ákoti apeínoati ne ésa'i, vo'oku mani anu'úkoti námoe xâne ko'ítuketi ovâti yehí koeti kohê neko ésa'i —kixókokone. ");
INSERT INTO terNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ina kôe ne Jesus: —Síkeane ra sêno. Na koeti ikétivexinoanoe koêku? Koati únati koekúti ítukeinonu, ");
INSERT INTO terNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","vo'oku kóyekunemo xepákukenoe ne xâne ákoti apeínoati, yoko koêkuti kehá'ayiku hivó'oxinoe, motóva. Kene ûndi, ákomo ángoyeneye xepákukenoe. ");
INSERT INTO terNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Enepora sêno, koati itukínonuti kali itóponone itúkea. Kixínonukeneye ra sêno, koati inúxinonoatine ne kixókonokumo mûyom engaxápune. ");
INSERT INTO terNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Koati emo'úti ra yunzó'inopinoe: Ya uhá koeti kúveu mêum, koêkutimo koyúhovoku ra inámati ihíkauvoti ínzikaxone, koyuhókonotimakamo ítukeinonu ra sêno, puyákoponeovakemo okóvo xâne ra sêno —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yoko enepone Njuda Iskarióti, póhuti yane nduse koeti íhikau Jesus, pihóne yúho'ixoponea neko tutíhiko sasedóti inuxínoti jûdeu hó'eke, kahá'ati kuríkea Jesus xokóyokehiko. ");
INSERT INTO terNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yupihovó koéne elókeyea okóvo neko tutíhiko jûdeu kamoánehiko neko yuhó'inoa Njûda, koane koyúhoinoanehiko poréxeamo tiûketi. Yane kúxoixoane Njûda unátiyeaku káxe motovâti kuríkea Jesus xokóyokehiko. ");
INSERT INTO terNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Koati inúxoti káxe xapa áyui jûdeu yanekôyoke yaneko níkeakuhiko pâum ákoti kohiyákoati, kaxena isúkeakuhikomaka kali xe'exa su'ûso, ikó'iparaxoke Itukó'oviti ya Páskoa. Yaneko káxe, hara kixo Jesus ne íhikauhiko: —Na kehá'a vónea kóyuseoponea ûti ne vóvokumo níkea ûti xapa ayuíti? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yane ina pahukôa Jesus ne pi'âti íhikau. Hara kíxoa: —Pîhe pitivókoke. Tekópotimo hóyeno koinoti póte puhí koati úne. ");
INSERT INTO terNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hekápamo, ínamo ixêa ne únae ovokúti xoko ûrukopovoku: “Na óvo ne kúveu ovokúti óvongumo níngea xapa áyui Páskoa, ûndi yoko ínzikauhiko? kixópi Ihíkaxoti” íxeamo. ");
INSERT INTO terNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yane exókopitinoemo koati hána'iti kúveu ovokúti vanúkeke apêti mêsa yoko pánguhiko. Usó koyêtine uhá koetíya. Énomonemo keúsakinavi nikamo utíya —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Úkeane pího neko pi'âti íhikau Jesus ya pitivóko. Yoko uhá koêti neko yuhó'inoa Jesus, aínovo tokopóvoti. Yane koúsokoanehiko neko nikámo xapa áyui Páskoa. ");
INSERT INTO terNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hahaméne, ina pího Jesus koáne ne nduse koeti íhikau. ");
INSERT INTO terNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Koeku óvea xe'ókuke mêsa nikotíhiko, hara kíxovokoxoa Jesus neko íhikau: —Koati emo'úti ra yunzó'inopinoe: Anéye póhuti xepákukenoe iníkonuti itûkoheovoti koeku hókeonu, enepone kurikónutimo xoko xanéhiko puvónuti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yane ikáxu'inehiko okóvo ne íhikau kameáne yûho. Yane pohú pohu koénehiko kíxea Jesus: —Undíperameamo? —koénehiko ");
INSERT INTO terNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ina kixovókoxoa Jesus: —Koati anéyeti xepákuke, itínoe nduse koeti ínzikau. Énomonemo ne xané kixónuti yendémekea pâum utókuke. ");
INSERT INTO terNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Koati kaná'uti ngoépekeokonomo kuteâti koeku yutóxeovo ya emó'uke Itukó'oviti vo'ónguke, undi íhae vanúke ikútipasikoponovoti xâne, itea koati kotívetimo koêku ne kurikónutimo xoko xanéhiko puvónuti. Yusikóneni ákoyea ipúhika yara kúveu mêum —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Koeku níkeahiko, veyo pâum ne Jesus, ina ikoró'ixovo xoko Itukó'oviti. Yane honó'ekexoane ne pâum, ina porekéxoamaka íhikau koane kíxovokoxea: —Víyanoe. Enepora pâum, mûyom kixó'eko. ");
INSERT INTO terNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yane ina namukôa ne enovópeti koane íkoro'ixeovo xoko Itukó'oviti. Yane pôrekexoamaka íhikau. Heú koéhiko énoyeova. ");
INSERT INTO terNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ina kixovókoxopamaka: —Enepora víyum, hane kixó'eko indína ovokínovotimo êno xâne, ésa'i (inámati) kixovókuti ítukeino xâne ne Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Koati emo'úti ra yunzó'inopinoe: Ákonemo énoyeovangu hô'o ra ha'i úva tukú koetímo yaneko káxe enambápunemaka inámati ho'o úva natíxokuke Itukó'oviti vanúkeke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ina imokóvohiko akenéti. Ikénepoke, pihónehiko oúke kali mopôi iháxoneti Olívera. ");
INSERT INTO terNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ina kixovókoxoamaka Jesus ne íhikau: —Hána'itimo poé'ayeanoe iséneunonu, koane uhá ketínoemo kiríkinu, kuteâti koêku ne yuho Itukó'oviti emó'uke, enepone koêti: “Ngoepékoatimo ne koyónoti su'ûso, yane uhá koetímo itóhineheyea ne óyonone” koêti —kíxovokoxoane Jesus, ihókovati ne koyónoti su'ûso. ");
INSERT INTO terNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ina kixovókoxopamaka: —Itea enjepúkapane ungópea xapa ivokóvoti, inuxó ngoépotimo timúneke ya Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yane ina kixôa Pêturu: —Yusíkotimo poé'ayea isóneunopi ne uhá koeti po'ínuhiko xâne koane kuríkeopihiko, itea ûndi, ákomo kalíhuina nguríkea nzókeopi. ");
INSERT INTO terNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ina kixôa Jesus ne Pêturu: —Koati emo'úti ra yunzó'inopi: Kó'oyene yara yóti tumúnekemo pí'ayea éneo tapî'i, mopo'âtinemo keyuho ákoyea yéxanu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Itea inamá'axo koyuhôa Pêturu itúkeovo koâti kaná'uti ákoyeamo kuríka. Hara kôe: —Ákomo kalíhuina ngoyúhoyea ákoyea énjapi, muhíkova okonókovo xané ngíxeopi képekikono —kíxoane. Kúteanemaka koeku yûho ne po'ínuhiko íhikau Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yane pihóne evo Jesus ya xoko omómikokuti iháxoneti Njetisémani. Simoánehiko, ina kixovókoxo íhikau: —Ivétakavonoe yâyeke koeku indúkoponea orásaum —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Poéhane Pêturu, Teâku yoko Xuâum ómo. Yane turíxovone yupíheovo ikáxu'iyea okóvo ne Jesus koane eópeamaka hána'iti tiveko isóneu. ");
INSERT INTO terNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ina kixohíko xánena: —Yupihovó koéne êno hána'iti ikáxu'iyea ongóvo, kutí koe tiveko pevóti. Yavânenoeye, hákonoe imêko —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kali ahikú koéne ne Jesus, yane ipúyukexo xaneâti ísu'okea nône poké'eke epêmo Itukó'oviti áhikuxopinoa ne êno tiveko koêkumo enepo akahá'a. ");
INSERT INTO terNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hara koe yûho: —Pai, ako tiú'iti koekúti ya xikóyoke. Yáhikuxapinana ra êno hána'iti tiveko ngoêkumo, itea haináya anjáke, itea itúkapu yahá'inonu kousókovo ya njokóyoke —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ina kayukópovomaka xokóyoke neko mopo'âti. Inu'í kixópane imókeahiko. Ina kíxo Pêturu: —Imékoti Simaúm? Ako ite ákoyea iméka ya kúveu póhuti kali ôra? ");
INSERT INTO terNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hákonoe imêko, koane itika orásaum maka hákone ikerókovo enepo simâpi tiú'iti koekúti hixépikonoke. Vo'oku ya iséneuke, usó kéyenoe, itea ya oránake mani kénokiku kétiu'ikivoxo, ú'uso koyéneoxo muyá'iyea iséneu —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yane káyukopovonemaka itúkoponea orásaum. Kuteâti koeku yûho inúxotike, énomone koéponemakaye yûho. ");
INSERT INTO terNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yane káyukopovonemaka xoko íhikauhiko. Inu'í kixópanemaka ímohikea. Koáhati yupihóvatinehiko êno uheko ixépa. Yane ákonehiko exa kixoku yûho. ");
INSERT INTO terNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ina kayukópinovahikomaka Jesus. Yoko mopó'apene káyukopinova. Hara kíxoahiko: —Yanéyeikonoe iméki koane yómomiki? Yápenenoe iméki! Simóvone ne ôra, nguri'ókokonoatinemo ne xanéhiko váhere kixoku itúkeovo, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yexépukanoe! Hingá, kenó'okone ne itûkoheovoti ingéneke, enepone kurikónutimo xoko xanéhiko puvónuti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ixómoiko koyûho ne Jesus, simóne Njûda, póhuti yane nduse koeti íhikau. Yoko koati ênoti xánena omotíhiko hána'itinoe pirítau yoko pulô'i, isukópeti. Aínovo páhoe tutíhiko sasedóti inuxínoti jûdeu hó'eke, koane éskiribahiko ihíkaxoti yútoe Muîse, yoko po'ínuhiko payásoti xapa tuti jûdeu. ");
INSERT INTO terNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yoko enepone itûkoheovoti ikéneke Jesus, enepone kuríkoti Jesus xoko xanéhiko puvâti, ápe emó'uinoa ne xánenahiko tumúneke píheahiko. Hara kíxoa: “Enepone hóyeno nziúnoneumo, énomonemo nê'e. Iké'akanenoemo. Usó íxeixane ahúkoti koyonoâti koeku omópea” koéne. ");
INSERT INTO terNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ehá'axo sîmo ne Njûda, ahí'okovone Jesus. “Ihikaxotí” kíxoane. Yane siunoné kixone Jesus yúhoikea. ");
INSERT INTO terNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yane namúkonehiko Jesus, ínamaka ika'ákoa. ");
INSERT INTO terNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yane apé koene póhuti ya xapákuke íhikau Jesus hekoti hána'iti pirítauna. Maturukenó kixone ahínoe koati payásoti ya uhá koeti sasedóti inuxínotihiko jûdeu hó'eke. ");
INSERT INTO terNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ina kixôa Jesus neko xanéhiko: —Undí'ikopo koati koyuvôrixovoti ísukenati omó kixínekenoe hána'iti pirítau yoko pulô'i, isukópeti nemúkoponinunoe? ");
INSERT INTO terNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Uhá koeti káxe, koati óvonzeixokunepepo xepákukenoe ya hána'itike imokóvokuti inzíkaxoti, yoko ákonoe iké'akanu. Itea kó'inokeneye, koati konokoâti koúsokeovo kuteâti ne yutoéti emó'uke Itukó'oviti mekúke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yane kurí kixone Jesus ne íhikauhiko, kohó'ikene. ");
INSERT INTO terNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yoko ápe homoêhou hokoâti ne Jesus. Poéhane lénso aú'okovo, ako po'inu ípovo. Apé koéne namukoâti kaha'âti iká'akea. ");
INSERT INTO terNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yane kurí kíxoane neko aú'o, mahupí koéne kohó'iyea. ");
INSERT INTO terNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ina omohíko Jesus xokóyoke ne koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke. Yane ho'úxovone uhá koêti ne tutíhiko sasedóti yoko po'ínuhiko pahúkoti xapákuke tuti jûdeu, koánemaka ne éskiribahiko, enepone ihíkaxoti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kene Pêturu, ákone malíka kixoku hókea Jesus. Tukú kíxoa kíndanake óvoku koati payásoti ya uhá koeti sasedóti. Vatá kóyene xapákuke ahinoêtihiko xe'ókuke yúku, onokóvoti. ");
INSERT INTO terNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Enepohikone tuti sasedóti koane uhá koêti neko pahúkotihiko xoko koati payásoti yúhoikovoku jûdeu, opósikohiko xâne koyúhoti ápeyea pahúnevo ne Jesus, motovâti koyúhoyea tutíhiko motókeyea koépekeokono ne Jesus, itea ako ínixahiko kuteâti ne âha. ");
INSERT INTO terNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Koati êno itukóheyeati koêku ne Jesus, itea iyúseo ákoyea akána'u vo'oku ákoyea akútikoko ne yûho. ");
INSERT INTO terNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ina exepúhiko po'ínu itukóheotimaka koeku Jesus. Hara kôe yuhóhiko: ");
INSERT INTO terNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Kámoa ûti ra hóyeno kó'iyea: “Ngotohíneatimo ra sasá'iti óvoku Itukó'oviti, koéxepoe xâne, ínamakamo ngaexépukapa pô'i ya kúveu mopo'âti káxe ákoti itukapu xâne koexépukopa” kôe —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Itea muhíkova nekôyohiko, ako akútikoko yûho. ");
INSERT INTO terNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ina exepúko nonékuke xanéhiko ne koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke, ina kíxo Jesus: —Ákomo se'íkipa yûho ra xanéhiko koyúhoti ápeyea váhere ítike? ");
INSERT INTO terNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Itea yunu-yunú koéne ne Jesus. Ako ápahuina emó'u. Yane ina kayukópamaka koati payásoti sasedóti épemo'ikea Jesus. Hara kíxoa: —Énomone îti ne Mésiya, páhoe Itukó'oviti koíteovo xâne? Koatí'ikopo iti Xe'éxa ne êno hána'iti ihayú'iuti Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ina kixôa Jesus: —Ûndi. Epó'oxo neixónutimo, undi íhae vanúke ikútipasikoponovoti xâne, vatá ngoyépotimo éxopeke Itukó'oviti, enepone apêti xunáko pahúkea uhá koêti. Neixónutimo ungapeâne vanúke koeku evénzekopea xapa kapásihiko —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Énomone yanê'e kávarerekexopone ípovo muyókuke ne koati payásoti ya uhá koeti sasedóti, éxokovope yupíheovo ímaikeovo vo'oku yuho Jesus, ina kôe: —Ákone vokónoko po'i koyuhó'inoveati pahúnevo râ'a. ");
INSERT INTO terNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kéminenoe yûho. Koati itûkovoti Itukó'oviti. Na kó'inoaye iséneunoe kó'oyene? —kíxovokoxoane. Heú koéhiko neko tuti jûdeu ínixea kónokea koépekeokono ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yane ápenehiko apurú'okoti Jesus, koane ikanóneati koeku isúkeahiko xaneâti kíxeahiko: —Mahí'ipepo iti koati porófeta, íhexaikopo itukóvotiye ra isukópiti —kíxoanehiko. Koánemaka neko koyónotihiko, isúkoamaka. ");
INSERT INTO terNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yoko ako alú'aka Pêturu kúveuke ne ovokúti vanúkeke xoko iyónokonoku Jesus. Ôvoheixoane kíndanake ne ovokúti. Yane ina pihinôa sêno, ahínoe neko koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke. ");
INSERT INTO terNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Noixoâne sêno ne Pêturu ixómoti onokóvo, pono-ponó kixínoane ûke ina kixôa: —Koati itímaka xáneheixone ne Jesus íhae Nazâre. ");
INSERT INTO terNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Itea hara kíxoa Pêturu: —Ako énja ne kíxene. Koati ákoti enjâ ne yiûho —kíxoane. Ina ipuhíkopea Pêturu ne óvoheixoku. Hara yonópo xoko vekokúti xe'o pahapéti. Énomone yanê'e, éneone tapî'i. ");
INSERT INTO terNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Noixópomaka Pêturu neko sêno, hara koépomaka yûho nonékuke neko xanéhikoya: —Enepora hóyeno, po'ínunemaka íhikau nê'e —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Itea káyukopomaka koyúhoyea Pêturu ákoyea éxa. Avo áxu'ikene ina kixopómaka Pêturu neko xanéhikoya: —Koati kaná'uti itíkivo po'i xáneheixone ne hóyeno, vo'oku itímaka íhae Ngalíleya —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Itea ikána'uxoane Pêturu koyúhoyea ákoyea éxa. Hara kixópamaka: —Ako énja ne hóyeno kíxenenoe. Ngayumákapunemo ipihápananu Itukó'oviti enepo nzemekékexinapinoe —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ehá'axo koyúhoa Pêturu nê'e, éneoponemaka ne tapî'i. Yoko pí'apene éneo. Yane puyákoponovane okóvo Pêturu neko yuhó'inoa Jesus, enepone koêti: “Tumúneke pí'ayea éneo tapî'i, mopo'âtinemo keyuho ákoyea yéxanu” koêti. Itukópinovo isóneu ne Pêturu, ákone íta ne êno tiveko isóneu, yane íyone. ");
INSERT INTO terNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yuponíne, ho'úxovone neko tutíhiko sasedóti inuxínoti jûdeu hó'eke, koáne ne po'ínuhiko payásoti xapa tutíhiko jûdeu, koánemaka ne éskiribahiko ihíkaxoti yútoe Muîse, yoko uhá koeti ha'ínehiko yane koati payásoti yúhoikovoku jûdeu. Yane iká'akonehiko Jesus, ina omâhiko xoko Pilátu, kurikoâtihiko xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ina kixôa Pilátu ne Jesus: —Ití'oxo natina jûdeu? Ina yumopâ Jesus: —Enepone yépemonuke, koúhapu'ikoa indúkeova —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yane koyúhoane tutíhiko sasedóti inuxínoti jûdeu hó'eke enó'iyea ítuke Jesus ákoti aunáti. ");
INSERT INTO terNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ina kixopâmaka Pilátu ne Jesus: —Ako yiûho? Ako kéma yuhóhiko ra koyúhoti enó'iyea váhere ítike? ");
INSERT INTO terNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Itea yunu-yunú koéne ne Jesus, ako yumápa, kutí'inoke yupihóvati iyúpaxeova Pilátu. ");
INSERT INTO terNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ya kaxénake neko áyui jûdeuhiko, kóyekune kuríkopea póhuti iká'aeti ne Pilátu, koêkuti épemone xanéhiko kuríkopeokono. ");
INSERT INTO terNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yoko ápe hóyeno koéhati Mbarâba híyeuke neko ika'áhikovoti yanekôyo, vo'oku ápeyea koépeu yaneko koturíhiko xâne okopóhiko nâti yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ina pího neko êno xâne xoko Pilátu epemóponoati kuríkopea póhuti iká'aeti kuteâti kixoku itúkeovo ya kaxena ayuíti. ");
INSERT INTO terNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ina kixovókoxoa Pilátu: —Kehá'anoe nguríkopea ra netína, itínoe jûdeu? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yoko éxoa Pilátu itúkeovo imaíkinovoti Jesus ne tutíhiko sasedóti vo'oku iyókeovati xunáko, kutí'inoke kurikoâti xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yoko enepone tutíhiko sasedóti, ítokuxea okóvo neko xanéhiko kahá'ayea itúkeovo Mbarâba épemohiko kuríkopeokono. ");
INSERT INTO terNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ina kixovókoxopamaka Pilátu neko xanéhiko: —Kene ra iháxoneti netína, itínoe jûdeu, namo ínjaye? ");
INSERT INTO terNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Kirúhuxa! —koénehiko yûho vaúkexea. ");
INSERT INTO terNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ina kixovókoxopamaka Pilátu: —Kutí'ikopo itúko pahúnevo râ'a? —koéne. Itea inamá'axone koxunáko yûho vaúkexea kónokea kurúhuxeokono ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Vo'oku kahá'ayea iyúni'ikea xanéhiko ne Pilátu, kuríkopinoanehiko ne Mbarâba, ina pahûko yehépoke'exeokono Jesus. Yane kurí'okoanemaka neko xanéhiko kurúhuxoponea. ");
INSERT INTO terNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ina ómo Jesus ne húndaruhiko kúveuke neko óvoku Pilátu, enepone óvokumaka natíxea. Yane heú kíxoane ho'úxea ne po'ínuhiko húndaru ");
INSERT INTO terNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ina itukínohiko Jesus harará'iti ipovóti hamá koeti poké'eke, kuteâti ípovo nâti, ínamaka itukínoahiko kôroa, itea ainóvoti ka'áveti káva'o tikóti veínoa úhekexea, ina ipíheahiko tutíkuke ");
INSERT INTO terNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","itûkovotihiko teyoâti. Yane hara koéhiko: —Iháyu'ikakana ra natina jûdeuhiko! —koénehiko koémoke'eyea, ");
INSERT INTO terNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","koane ipúsopu'ikeahiko ya pulô'i, koane ápuru'okeahiko, ina ipuyúkexeahikomaka nonékuke itûkovotihiko ihayú'ikoati. ");
INSERT INTO terNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Uke'éxoanehiko komóhiyea, ina veyopeâhiko ne harará'iti ípovoxeakemeku, ina itukópinoamaka ne koati ípovo. Úkeane omáhiko meúkeke kurúhuxoponea. ");
INSERT INTO terNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yoko ápe hóyeno koéhati Símaum íhae Sîreni ukopeâti mêum, vekopâtimaka neko xêne. Yoko ha'a Alíxandere yoko Rúfu neko hóyeno. Énomone íkoinoxohiko kurúhuna Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yane ísimonehiko Jesus ya xoko iháxoneti Ngoûgota. Yoko “Óvoku Opepú'iti” koêti ne Ngoûgota. ");
INSERT INTO terNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ina porexóhiko Jesus víyum apêti ánahi iháxoneti mîra, enepone iyuhii kixoti ohonéti, itea ako énapa Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yane kurúhuxoanehiko, ínamaka haxakéxokokoahiko ne ípovo Jesus. Yoko kuríkohiko inúxotike komomâti itukóvotimoye ípovo Jesus námoe póhutihiko. ");
INSERT INTO terNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yoko nóvene ôra kuruhúxoahiko. ");
INSERT INTO terNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tutíkuke kurúhuna Jesus ápe yutoéti koyuhoâti kurúhuxinokonoke. Hara kôe neko yutoéti: “Natina jûdeuhiko râ'a” kôe. ");
INSERT INTO terNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ápemaka pi'âti ómevoti, ha'ine Jesus kurúhuxeokono, poéha éxopeke, poéhamaka lopékuke. ( ");
INSERT INTO terNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yane koati tokopóvoti neko kúxoti yutoéti emó'uke Itukó'oviti, eneponeko koêti: “Kutí kixókono váhere xâne ákoti aunáti ítuke” koêti.) ");
INSERT INTO terNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Enepohikoneko xâne hunoneâti, koémoke'e Jesus koane kayákakinoa tûti. Hara koéhiko: —Mahi ketohíneatimo ne hána'iti imokóvokuti koane mahi kexépukopatimakamo ya kúveu mopo'âti káxe! ");
INSERT INTO terNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Keítapapuikopo, koane yevésekapi ne kurûhu —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kúteanemaka kíxoaku tutíhiko sasedóti koémoke'eyea, koánemaka ne éskiribahiko, enepone ihíkaxoti yútoe Muîse. Hara kixókokohiko: —Eneporâ'a, koítovopepo po'íhiko xâne itea ákone xunáko koítopeovo. ");
INSERT INTO terNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mahi koati Mésiya, páhoe Itukó'oviti koíteovo xâne, natínamaka Izarâe! Evésekapeakopo ne kurûhu motovâti noíxea ûti, ínamo vakutípoa —koénehiko. Koánemaka neko ha'íne kurúhuxeokono, koémoke'eamaka. ");
INSERT INTO terNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Itumúkone káxe, hahámone uhá koeti kúveu mêum tukú koeti mopo'âti ôra ya kiyakáxe. ");
INSERT INTO terNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Itopónone mopo'âti ôra, koati kohonókoti emó'u ne Jesus. Hara koe hónoti yûho vaúkea ya emó'uke: —Eloí, Eloí, lama sabakitáni? —koéne. Yoko hara koêti neko yûho: “Unaém, Unaém, na koeti kurí kixínenu?” koêti. ");
INSERT INTO terNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Xapákuke neko xanéhiko kamoâti, ápe koêti: —Yokómomapihi koêku, Îliya iháxiko —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ina apê póhuti xapákuke neko xâne ehakóvoti, kalaká'ikoponoti esponja xoko viyum-hí koêti, ina ipíhoa kirípuhike étakati ipíhoati pahákuke Jesus, iyúkoati. Ina kôe: —Vokómomavo veyópeaxomo Îliya —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ina apépomaka koati êno hónoti emo'u Jesus. Yane îhunokoane ne omíxone, ivókovone. ");
INSERT INTO terNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yoko énomone yaneko ókoku ôra, ívarereo neko êno kopópoti váhere haxakoâti kúveu neko hána'iti imokóvokuti. Koati kukúkeke ívarereo ukeâti vanúkeke yonoti poké'eke. ");
INSERT INTO terNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Enepone tuti húndaru xe'ó koyêti nonékuke kurúhuna Jesus, noixoâne kixoku ivókeovo ne Jesus, hara kôe: —Koati kaná'uteoxo itúkeovo Xe'exa Itukó'oviti ra hóyeno —koéne. ");
INSERT INTO terNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ápemaka senóhikoya ákoti malîka okínoaku ixómoyea komóma. Xapákuke neko senóhiko, ápe Mariya Mandâlena; yoko po'ímaka koéhati Mâriya, enepone eno Yûse yoko Teâku. Yoko énomone ne Teâku nihí'iti yane po'i koéhati Teâku. Ina apémaka Salúme. ");
INSERT INTO terNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Enepohikora sêno, aínovo xanéheixoti Jesus ovo'íko ya Ngalíleya koane huvo'óxoatine ya nókone. Enómaka po'ínuhiko sêno xaneâti ne Jesus koeku yónea Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kiyoné'e káxe, koeku itúkeovo kóyuseovopene jûdeuhiko vo'oku áyui, koáne ye'ékotinemaka ûrukeovo ne sâputu, ");
INSERT INTO terNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ápe hóyeno koéhati Yûse íhae Arimáteya, hóyeno koati teyonéti ya xapákuke tutíyehiko koatíke payásoti yúhoikovoku jûdeu. Yoko koati kuxoíxoati nê'e símeovo ne kaxena natíxea Itukó'oviti xapa xâne. Yane kóxunakovo píhea xoko Pilátu, epemóponoati yusíkea veyópea muyo Jesus kuruhúke. ");
INSERT INTO terNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Iyúpaxova Pilátu neko eyékou ivókeovone Jesus, ina ihaxíkoa neko tuti húndaru epemó'ikoati itúkeovo koati kaná'uti ivókeovone. ");
INSERT INTO terNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Exoâne xoko tuti húndaru kaná'uyea ivókeovone ne Jesus, yane síkoane neko Yûse veyópea muyo Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Úkeane pího veyóponea kuruhúke. Ina aupíxoa ya kalísoti ipovóti vaneu, enepone iháxoneti líyum, iyonoâti xoko uhôro kehoéti mopoíke. Yane ínamaka kohokôroroko mopôi exéxeake ne uhôro. ");
INSERT INTO terNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Yoko noíke'eheixoa Mariya Mandâlena iyónokonoku neko muyo Jesus, koánemaka Mâriya, eno Yûse. ");
INSERT INTO terNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Evesékone sâputu, pihóne Mariya Mandâlena; yóko'omaka ne po'i koéhati Mâriya, enepone eno Teâku; koánemaka po'i sêno iháxoneti Salúme vanéxoponea kohépiti xêru óvo'okopemo Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Koati yuponii koêti lûmingu ínati ipuhíko káxe, pihónehiko xoko ekóxokonoku Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ina kixokókohiko: —Kutimo veyinó'ovea ne mopôi exexoâti ne uhôro? —kixókokohiko. ");
INSERT INTO terNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Simoánehiko, noíxoane ahíkuxeokonone neko mopôi. Yoko koati yupihóvati pu'íko. ");
INSERT INTO terNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Urúkovanehiko neko ekóxokonoku Jesus, tokononé koene kutí koeti homoêhou hóhopu koyêti ípovo, vatá koyêti ya éxopeke. Yupihovó koéne kónoko'iyeahiko ne sêno xaneâti hána'iti píkea. ");
INSERT INTO terNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ina kôe neko yuhó'ixoati: —Hákonoe kenóko'i. Koati Jesus íhae Nazâre yopósikopononoe, eneponeko kuruhúxokonoti, itea exépukopone nê'e, áko'one yâyeke. Yokómomapihi ra ekóxokonoku. ");
INSERT INTO terNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kó'oyene yéta'akapana ne íhikauhiko yoko Pêturu inuxó koépeamo ne Jesus timúnekenoe ya Ngalíleya. Yâkonoye neixópatinoemo kuteâti koeku yuhó'inopi yanekôyo —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yane ipúhikopeane senóhiko neko ekóxokonoku Jesus. Koati ehakópovotihiko pihópea vo'oku yupíheovo píkea koane koyó'ikeyea. Ako éto'oepo koêku neko noíxone vo'oku píkeahiko. ");
INSERT INTO terNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Koati yuponii koêti ya lûmingu, exépukopo ne Jesus ukópea xapa ivokóvoti. Mariya Mandâlena itukóvo inúxoti éxokopovoke inâ exepúkopo. Énomone neko Mâriya koítovone Jesus, enepone kopúhikopeaku seti koeti ndémoniu. ");
INSERT INTO terNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yane pihóne Mâriya éto'okoponeahiko neko ha'íneheixone Jesus ixómoti isoné'ekovo koane íyoyea. ");
INSERT INTO terNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Itea ako akútipoahiko kameáne yûho exépukopeane koane noíxopea. ");
INSERT INTO terNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ikénepoke, kópoe'akopovo ne Jesus, koane éxokopovo po'i pi'âti kutipoâti yonotíhiko ya mêum. ");
INSERT INTO terNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yane pihóne neko pi'âti éto'okoponea neko po'ínuhiko íhikau Jesus, itea ákomaka akútipokonohiko yûho. ");
INSERT INTO terNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ikénepoke ina exókopovamaka Jesus neko unze koeti íhikau koeku ixómoyea nikóhiko xe'ókuke mêsa. Sayá'ikoa Jesus vo'oku ákoyea akútipoahiko koane vo'oku tiú'iyea omíxone yaneko ákoyeakuhiko akútipoa yûho neko noixópati exepúkopone. ");
INSERT INTO terNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ina kixovókoxoamaka Jesus: —Pihénoe yara uhá koeti kúveu mêum. Yokóyuhoinoa uhá koeti xâne ra inámati ihíkauvoti omínombike. ");
INSERT INTO terNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uhá koeti xâne kutipoâti, koane ahíkovoti ya inzáke, énomonemo pihopô vanúkeke xoko Itukó'oviti. Itea enepone xâne ákoti akutípoa, yonópotimo ipihóponovokutike. ");
INSERT INTO terNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Enepone kutipoâti, harâ'a ra iyupánevoti ítukemo, hoénaxovope njunáko xokóyoke. Ya inzáke, kopúhikopotimo ndémoniu urúkovoti xoko xâne, koane koyúhotimo inámatihiko yuhôti ákoti itukapu yûho. ");
INSERT INTO terNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Motovâtimo namúkea koéxoe koane énoyeovo ekâti koépekoti, kuteâti vénenu, itea ákomo yuvâti. Koane ipíhahiko vô'u tutíkuke ka'aríneti, itóvotihikomo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Uke'éxoane Vúnae Jesus yúho'ixea neko íhikauhiko, pihópone vanúkeke. Ivátakopone éxopeke Itukó'oviti xoko ivátakoku kapáyasokone Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yane pihónehiko neko íhikau koyúhoponea koeku Jesus ya uhá koeti yónokuhiko. Yoko huvó'oxoamaka Vúnae, kouhápu'ikeati kaná'uko ne yûho yane iyupánevoti poréxoake itúkea. Hunókokune.");
INSERT INTO terNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Enóne xâne itúkoti xunáko kókoyuse kíxea yutóxea koêku ra koekútihiko kousókovotine xapákuke ûti yaneko káxehiko pihotíne. ");
INSERT INTO terNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Enepone yútoehiko, hane koyúhoinovi, noíxone ne xanéhiko noixoâti ra koekútihiko ukeâti inâ turixóvo, enepohikone koyuhoâtimaka ra emo'u Vúnae. ");
INSERT INTO terNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ngoánemaka, íninjoa unáko yundóxinopea ra koekúti Teofilú, iti hána'iti teyonéti xapákuke ûti. Yoko enóne ngóxuna'ixeovo ombósikea uha-uhá ngíxea énjea koêku ra koekútihiko ukeátine inâ turixóvo, koane kókoyuse ngíxoa yundóxinopea ukeâti tûri tukú koeti hunókoku, ");
INSERT INTO terNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","maka yéxaneoxo itúkeovo koati kaná'uti ne ihíkauvoti íhikexokonoke. ");
INSERT INTO terNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yaneko káxehiko itukóvoiko nâti ne Êrodi ya poké'exa Njúdeya, ápe hóyeno koéhati Nzakâriya. Enepone hóyeno, sasedóti inuxínoti jûdeu hó'eke itukóvoye. Yoko ápe iháxakokuhiko ne sasedóti, vo'oku ahe'ó ahe'o kíxeokoko ítukeke. Enepone iháxakoku Nzakâriya, xoko ítuke Âmbiya óvo. Izâbe koéha yêno neko Nzakâriya. Yoko iyénoxapamaka sasedóti neko yêno. ");
INSERT INTO terNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Koati ponóvoti kixoku itúkeovohiko nonékuke Itukó'oviti neko pi'âti. Koati itukoâtihiko heú koêti ne yutoxóvoti Ponóvotike Kixovókuti yútoe Muîse, koane heú koêti ne páhoenovi Itukó'oviti vitúkea, ");
INSERT INTO terNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","itea ako ápahuina xe'éxa. Akó'oti okoxé'exa neko Izâbe. Yoko koati yekotíxotinehikomaka neko pi'âti. ");
INSERT INTO terNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Po'íke káxe, ixómoti ko'itúke sasá'iti ítuke Itukó'oviti ne Nzakâriya, vo'oku símeovone kaxena ko'ítukepe. Yoko kuríkohiko ne sasedóti inúxotike, ");
INSERT INTO terNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","kuteâti kíxoakuhiko itúkea motovâti éxea itukóvotiye xapákuke urúkovatimo ne sasá'iti iháxakoku kúveu ne hána'iti imokóvokuti, enepone témpulu, itúkoponea ne itukétiya. Yoko xoko Nzakâriya iríkovo ne kûrehiko kutí'inoke urúkovati oró'okoponea ne ísensu kixonéti, ikó'iparaxoke Itukó'oviti, enepone êno úheti ihópune oro'ókokono. ");
INSERT INTO terNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kene ne xanéhiko, ôvane meúkeke itúkotihiko orásaum koêku oró'okea ísensu ne Nzakâriya. ");
INSERT INTO terNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Yane apé kó'inoane ánju, ovoxe Itukó'oviti ukeâti vanúke. Xe'ó kó'iyeane éxopeke oró'okovoku ikó'iparaxokonoke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Noixoâne Nzakâriya, kónoko'i. Yupihovó koe píkea. ");
INSERT INTO terNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yane hara kíxoa ánju: —Hako píke Nzakariyá, vo'oku kámoane Itukó'oviti ne yorásauna. Apêtimo xi'íxa, hóyeno kalivôno, xoko yîno Izâbe. Xuâum íheximo. ");
INSERT INTO terNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hána'itimo elókeko yokóvo, koane hána'itimo úhepeko iséneu vo'ókuke. Enómakamo xâne elokeâti okóvo ipuhíkane. ");
INSERT INTO terNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Koati hána'itimo teyonéti ítukeke Vúnae. Ákomo énapu víyum koane koêkuti kó'iyeovoku ekâti, epó'oxo ukeátinemo okóvoike êno, xúnatimo ne Sasá'iti Omíxone Itukó'oviti xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Koane enómo xâne xapákuke íhae Izarâe ponopóvoti hókea Itukó'oviti, Únae, vo'ókuke nê'e. ");
INSERT INTO terNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Énomonemo inuxíno Vúnae, koane xúnatimo ne Sasá'iti Omíxone Itukó'oviti xokóyoke kuteâti koêku xoko Îliya, eneponeko koyúhoti emo'u Itukó'oviti mekúke. Énomone kutí'inomo ponopóvoti kixoku hókea Itukó'oviti ne xanéhiko kó'oyene, kuteâti koêku póneovo hókea oxúnoekene mekúke. Énomonemakamo kutí'ino koyúseopoti kixoku itúkeovo ne xâne ákotihiko itukâ ne páhoenovi Itukó'oviti vitúkea, koane hokopâtimo ne xêne hókone xanéhiko ponóvoti isóneu. Yanê'e, usó koyêtimo ne xanéhiko kutípea emo'u Vúnae simané'e xapákuke —kíxoane ánju. ");
INSERT INTO terNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ina kixôa Nzakâriya: —Namo ngíxoaye énjea itúkeovo kaná'uti? Vo'oku yéngotixone, koane yupíhovonemaka hóvenoxea ne múnjone —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ina kixôa ánju: —Undi Ngabiríye, undi ovóheixoti xoko Itukó'oviti nguxó'ixeati koêkuti kovóxenuku. Énomone pahukónu yúnzo'ixoponeopi koane ngoyúhopoinopea ra únati eyekoûti. ");
INSERT INTO terNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Itea vo'oku ákoyea yakútipoa ra yûnzo, ukeátine kó'oyene, ákonemo ite keyúhoyi. Ákonemo ipúhika yemó'u tukú koetímo yaneko káxe kausákapune ra koekúti ngixínopike. Yoko kousókovotimo simapúne koati kaxéna —kíxoane ánju neko Nzakâriya. ");
INSERT INTO terNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yoko kohíxopovane xanéhiko ne Nzakâriya koane iyúpaxeovahiko yupíheovo xu'íkeneyea kúveuke ne sasá'iti óvoku Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ipuhíkopone, ákone ita koyúhoyea. Yane exó kíxoane xanéhiko ápeyea noíxone ukeâti xoko Itukó'oviti kúveuke neko sasá'iti iháxakoku témpulu. Vô'u veínoane Nzakâriya éxokea ne xanéhiko âha koyúhoyea koêku ákoyea ita koyúhoyea. ");
INSERT INTO terNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Evesékone kaxéna ne Nzakâriya itúkea ítuke nonékuke Itukó'oviti, pihópone óvokuke. ");
INSERT INTO terNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ehane íhaiko ne Izâbe, yêno. Kúveu singu koeti kohê, ôvoheixoane Izâbe óvokuke, ákone ipúhika. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Koati hána'iti seánakonu Vúnae. Kó'oyene, ákonemo noixó ínjakana —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sei koené'e kóhea ne Izâbe íhaikea, pahúkopamaka Itukó'oviti ne ovóxe íhae vanúke, enepone Ngabiríye. Pahúkoa ya pitivóko koéhati Nazâre ya poké'exa Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xoko inámatiko ârunoe âvoti oko'íma pahúkokono. Yoko hoénaxoane hóyeno koéhati Yûse itúkeovomo yêno neko ârunoe. Enepone Yûse, koati ámoripono Ndávi, enepone hána'iti nâti mekúke. Mâriya koéha neko ârunoe yenómo. ");
INSERT INTO terNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Urúkovane ánju neko ovokúti xoko óvoheixoku ne Mâriya, hara kíxoa: —Aéloke yokóvo. Koati únati kêku. Anéye ne Vúnae xikóyoke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Itea koyó'i ne Mâriya kameáne yûho. Akó'oti exína isóneu kixínoakeneye ánju emó'uinoa. Yane opósikoane ya isóneuke kixó'ekone neko yûho. ");
INSERT INTO terNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ina kixôa ánju: —Hako píke Mariyá. Koati únati isóneunopi Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iheíkotimo, koane kexe'éxatimo hóyeno kalivôno. Jesus íheximo. ");
INSERT INTO terNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Koati hána'itimo teyonéti nê'e. Iháxeokonotimo Xe'éxa ne koati Payásoti ya uhá koêti. Porexoâtimo Vúnae Itukó'oviti itúkeovo koati hána'iti nâti kuteâti koêku Ndávi, enepone oxú'ikene. ");
INSERT INTO terNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ákomo hunókoku itúkeovo natina amósenopono Njáko. Koati ákotimo hunókoku natíxea —kíxoane ánju ne Mâriya. ");
INSERT INTO terNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ina kixôa Mâriya: —Namo kixó'oye ngoêku? Undí'iko ârunoe, avo yúho'ixeonuku hóyeno —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ina kixôa ánju: —Evesékotimo ne Sasá'iti Omíxone Itukó'oviti xikóyoke. Koati xúnatimo xikóyoke xunáko ne Vúnae, enepone koati Payásoti ya uhá koêti. Énomonemo porexópi kexé'exayi, kutí'inokemo iháxokonoti Xe'exa Itukó'oviti ne sasá'iti kalivôno ipuhíkotimo. ");
INSERT INTO terNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kene enepone iyíno, Izâbe, apêtimakamo xe'éxa koêku hóvenoxeane, hóyenomo kalivôno. Sei koene kóhea yoko koyúhokono ákoyea okóxe'exa. ");
INSERT INTO terNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kó'inokeneye, vo'oku ako koekúti ákoti itâ itúkea ne Itukó'oviti yane uhá koeti yûho itúkeamo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ina kixôa Mâriya: —Usó ngóye, koêkuti isóneunonu Itukó'oviti. Kaúsakapunemo njokóyoke kuteâti ra yihó'inonu —kíxoane. Yane pihópeane neko ánju. ");
INSERT INTO terNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yaneko káxehiko, koúsokovo ne Mâriya. Éhakovo píhea ya pitivóko ovoti xapa mopôi poké'exake Njúdeya. ");
INSERT INTO terNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Simoné'eya, ûrukovone óvokuke Nzakâriya koane yúhoikea Izâbe. ");
INSERT INTO terNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ehá'axo kámoa Izâbe ne emo'u Mâriya yuhoíkoane, ehévokovo ne kalivôno okóvoike Izâbe. Koati xúnati ne Sasá'iti Omíxone Itukó'oviti xoko Izâbe ");
INSERT INTO terNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ina kohonóko emó'u koyúhoyea. Hara kôe: —Koati yupihóvoti unako kêku ya uhá koeti po'ínuhiko sêno. Koánemakamo ne xi'íxa, koati únatimo koêku ya uhá koeti po'ínuhiko kalivôno. ");
INSERT INTO terNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ako omóndokea síminu, iti eno Únaem. ");
INSERT INTO terNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Vo'oku ehá'axo ngámoa ne yemó'u yihoíkonumeku, ehévokovo ne kalivôno ongóvoike, yupihóvoti elókeyea okóvo. ");
INSERT INTO terNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Koati únati kêku, iti kutipoâti ne yuhó'inopi Vúnae vo'oku kousókovotinemo ne yuhó'inopi —kíxoane Izâbe. ");
INSERT INTO terNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ina kôe ne Mâriya: —Koati yupihóvoti ngahána'ikea ra Itukó'oviti, Únaem. ");
INSERT INTO terNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Koâti hána'iti elókeko ongóvo vo'oku Itukó'oviti, enepone Koitóvonuti, ");
INSERT INTO terNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","vo'oku puyákeovonu okóvo, undi kixeóvovoti ovóxe. Ukeátine kó'oyene, inixoâtinemo uhá koeti xâne itúkeovo koati únati ngoêku, ");
INSERT INTO terNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","vo'oku koati hána'iti ítukeinonu Itukó'oviti, enepone Xúnati ya uhá koêti. Koati sasá'iti ne îha. ");
INSERT INTO terNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ako hunókoku seánakoa ne uhá koeti teyoâti. Enepone seánako, anêkomaka oúkeke xe'éxaxapa yoko ámoripono xâne kutipoâti. ");
INSERT INTO terNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Koútata'ixoa Itukó'oviti ne hána'iti xunáko. Íkorokoa ne inixópovoti itúkeovo payásoti, ixané kixópa ne âha itúkea. ");
INSERT INTO terNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Íkorokoamaka ne payásotihiko yane itúkeovo hána'iti pahúkoti. Hane kapáyasokopo xâne ákoti xunáko koane ákoti apayáso. ");
INSERT INTO terNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Poréxopamaka êno únatinoe koekúti ne xâne kutí koeti épeu hímakati. Kene ne iríku, veyópea apeínoati. ");
INSERT INTO terNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Huvó'oxovi, uti íhae Izarâe, uti ovóxe, kuteâtimaka yuhó'ino voxúnoekene itúkeamo ya seánakovike. ");
INSERT INTO terNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Énomone neko yuhôti ákotinemo uké'eyeaku, yuhó'ino Âbraum koánemaka ne uhá koeti ámoripono. Énomone itúko ne Itukó'oviti kuteâti yuhó'ino voxúnoekene mekúke —koéne ne Mâriya. ");
INSERT INTO terNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Yoko mopó'a kohê ovóponoa Mâriya xoko Izâbe. Yane pihópone óvokuke. ");
INSERT INTO terNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Simovóne kaxena ipúhikope xe'éxa ne Izâbe, hóyeno kalivôno koxé'exa. ");
INSERT INTO terNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Enepone múxonehiko evo Izâbe oveâti xêrerekuke óvoku, koánemaka ne iyénoxapa, eyékoxoane koêku ne hána'iti seánakoa Vúnae, koane huvó'oxoponeahiko ya hána'iti elókeko okóvo. ");
INSERT INTO terNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Oitú koené'e kaxéna ne kalivôno, sirkunsidá kíxoanehiko. Yoko kahá'ane xanéhiko íhaxopea iha há'a, ");
INSERT INTO terNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","itea hara kíxoahiko êno ne kalivôno: —Ákomo kalíhuina koéhapea iha há'a râ'a. Xuâum koéhamo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ina kixokóno: —Itea ako ápahuina iyíno koehâti ne ihâe —kixókonone. ");
INSERT INTO terNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ina epemó'ikeahiko há'a ahá'inoa koéhayea ne kalivôno. Vô'u veínoahiko épemo'ikea. ");
INSERT INTO terNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yane épemone kali tâpoa ne Nzakâriya, yutóxoku. Hara koe yútoe: “Xuâum koéha râ'a” koéne. Yoko heú koe xâne iyúpaxeova neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ehá'axo yutóxoa Nzakâriya, koyúhopone, ákone itopeâti nêne. Koyúhopone koane iháyu'ikopea Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yupihovó koéhiko píkea heú koêti neko xâne ko'óvokutihiko xêrerekuke óvoku. Koane tumúne yóno itóhineyea neko koekúti xapákuke ne ko'óvokuti ovâti neko poké'e xapa mopôi ya Njúdeya. ");
INSERT INTO terNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Êno itúkinoa isóneu uhá koeti xâne kamoâti, koane kó'iyeahiko: —Kutímeamo itúkovo ra kalivôno apayá'inane? —koéhiko. Yoko koati apêti xunako Vúnae xokóyoke ne kalivôno. ");
INSERT INTO terNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Enepone Nzakâriya, há'a ne kalivôno, koati xúnati Sasá'iti Omíxone Itukó'oviti xokóyoke. Yane turíxovone koyúhoyea koekúti âvoti simâpu kaxéna. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Viháyu'ika ne Vúnae Itukó'oviti, kuvóvone íhae Izarâe, vo'oku simóne huvó'oxoponeovi, uti xanéna, koane veyópeovi ya vóvoheixea opékuke xunako vanáne. ");
INSERT INTO terNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pahúkinovine koati xúnati Koitóvoviti ukeâti xapa amósenopono Ndávi, enepone ovoxe Itukó'oviti mekúke, ");
INSERT INTO terNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kuteâtimaka neko koati yuhôti, yuho Itukó'oviti mekúke pahúkeamo, enepo evékinovea xoko sasá'itihiko ovóxe koyuhópoinoati emó'u xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kó'inokeneye motovâti koíteovovi ya vanánehiko, yoko ya xunáko ne uhá koeti puvo'óviti. ");
INSERT INTO terNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Koati koseánati ne voxúnoekene, koane puyákoponovamaka okóvo koúsokea neko sasá'iti yuhó'inoa mekúke. ");
INSERT INTO terNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Énomone neko koati yuhôti, yuhó'ino voxú'ikene Âbraum ");
INSERT INTO terNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","víteovamo ne vanáne, koane hókeamo uti Itukó'oviti ákoti píkone ûti, ");
INSERT INTO terNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","koêkumaka sasá'iyea yoko póneovo kixoku vitúkeovo nonékuke ya uhá koeti kaxena ûti yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kene îti kalivonó, ihéxikonotimo páhoe Itukó'oviti, enepone koati Payásoti ya uhá koêti, koyúhoinoa emó'u. Vo'oku itínemo inuxínoa ne Vúnae, mihi'ókinoatimo oxéne itúkea ítuke xapákuke xâne. ");
INSERT INTO terNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yexókoatimo ne xanena ûti koíteovamo Itukó'oviti koane kotúyopinoa pahúnevo, ");
INSERT INTO terNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","vo'oku koati yupihóvoti itúkeovo seánati ne Itukó'oviti. Énomone kutí'inoke isíminovitinemo hána'iti kouhápu'ikoviti íhae vanúke, ");
INSERT INTO terNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","maka kaúhapu'ikanemo ne ovoti hahákutike, enepohikone kutí koeti ákau pevóti hoenáxovotine yonópeamo ipihóponovokutike, koane évekavinemaka xoko xêne óvoku unako koeku ûti ya ikéneke Itukó'oviti —koéne Nzakâriya. ");
INSERT INTO terNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yoko tumúne yóno payá'iyea neko kalivôno koane ukóponea éxea Itukó'oviti. Ehane óvoheixo mêum ákoti apêti tukú koeti simovóne kaxena éxokeovo xanéhiko íhae Izarâe. ");
INSERT INTO terNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yaneko káxehiko, ápe yûho neko koati payásoti nâti, enepone Seza Augústu, koyúhoti kónokea yutóxoponea îha ne uhá koeti xâne natíxokuke, motovâti kayúmakexeokono yé'akeye xâne apêti yaneko uhá koeti poké'e óvoku natíxea. ");
INSERT INTO terNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yaneko inúxoti yutóxopono îha ne xanéhiko, Sîreniu itukóvo ngovenâdo ya poké'exa Sîrea. ");
INSERT INTO terNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Uhá koêti neko xanéhiko, kónoko yutóxoponea îha xoko pitivóko koati úkeaku oxúnoekene. ");
INSERT INTO terNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yane pihónemaka Yûse ukeâti Nazâre, pitivóko ya poké'exa Ngalíleya. Hane yóno Mbélem, pitivóko ya Njúdeya, enepone pítivokona Ndávi, nâti mekúke. Yonínoake Yûse vo'oku itúkeovo ámoripono Ndávi. ");
INSERT INTO terNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pîho yutóxoponea îha koánemaka iha Mâriya, yêno. Yoko ihaíkotine ne Mâriya. ");
INSERT INTO terNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Koêku óveahiko ya Mbélem, simóvone kaxena koxé'exayea. ");
INSERT INTO terNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hóyeno kalivôno koxé'exa, koati inúxoti xe'éxa. Ina aupíxoa ya ipovóti, yane tunukú kíxoane kúveuke kúxu, vo'oku itúkeovo xoko níkaxokonoku hó'openo okóhiko. Akó'oti inîxa imókoku xoko ókoku yonôti vo'ókuke neko êno xâne yonôti yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yaneko mêum xe'ókuke neko pitivóko, ápe koyónotihiko su'ûso herú kixoti yóti kóyonoyea su'úsona. ");
INSERT INTO terNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yaneko yóti, apé kó'inoanehiko ánju íhae vanúke, ovoxe Itukó'oviti. Koati êno uhé'ekoti uhapú'iti íhae xoko Itukó'oviti kouhápu'ikoatihiko neko koyónoti su'ûso. Êno píkeahiko vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ina kixôa ánju: —Hákonoe píke. Nzimínopike omínombinoe koati únati eyekoûti kutí'inoke apêtimo êno hána'iti elókeko okóvo ne uhá koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kó'oyene ya pítivokonake Ndávi ipúhikinopinenoe ne Koítovoti. Énomone ne Mésiya, Yúnae. ");
INSERT INTO terNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hanemo yéxi: Tokononé ketínoemo kalivôno aupí koyêti ipovóti, tunukú koyêti kúveuke kúxu —kíxoanehiko ánju. ");
INSERT INTO terNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yane apé koéne xokóyoke neko ánju ákoti yumaxápu po'ínuhiko ánju íhae vanúke ihayú'ikoti Itukó'oviti. Hara koéhiko: ");
INSERT INTO terNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Iháyu'ikakana ne Itukó'oviti yâkonoye vanúkeke. Kene yâye yara poké'e, itúkapu kásati omixóneti yoko úhepeti isoneûti apê xapákuke xâne kahá'ainoakehiko Itukó'oviti únati —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Úkeane pihopóhiko neko ánju vanúkeke. Ina kixokóko ne koyónotihiko su'ûso: —Hingá, pîha ûti ya Mbélem. Naíxapanavo ûti ne koekúti yuhó'inovi Vúnae. ");
INSERT INTO terNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yane ehakovó koénehiko píhea. Ehane ínixopono Mâriya yoko Yûse, koánemaka ne kalivôno tunukú koyêti kúxuke. ");
INSERT INTO terNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yane ina turixóvo koyúhopea kuteâti koêku yuhó'inoahiko ánju vo'ókuke ne kalivôno. ");
INSERT INTO terNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Uhá koeti eyekóxoati neko koekúti, iyúpaxeova yûho neko koyónoti su'ûso. ");
INSERT INTO terNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kene Mâriya, uha-uhá kíxoa unákea isóneuke neko emo'úti, koane êno itúkinoa isóneu. ");
INSERT INTO terNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ina pihôpo neko koyónotihiko su'ûso, ihayú'ikoti Itukó'oviti koane imokó'ikoati vo'oku uhá koêti neko noíxone yoko kámone. Yoko koati tokopóvoti uhá koêti neko yuhó'inoa ánju. ");
INSERT INTO terNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Itopónone oitu koeti káxe ike ipúhikine ne kalivôno, simóvone kaxena sirkunsidá kíxeokono. Yane itúkinokonomaka îha. Jesus íhaxeokono kuteâti íhaxeake ánju yanekôyoke tumúneke íhaikea Mâriya. ");
INSERT INTO terNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yoko yanekôyoke, itóponone yé'akeye káxe nókone kúxea ne Mâriya yoko Yûse motovâti kasása'ikopeovo nonékuke Itukó'oviti ike ipúhikine xe'éxa, kuteâti páhoenoa yútoe Muîse itúkea. Yane ómahiko ne xe'éxa ya Njeruzálem, kuri'ókopati Vúnae ");
INSERT INTO terNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kuteâti koêku nókone itúkea vo'ókuke ne yutoéti ya Ponóvoti Kixovókuti emó'uke Vúnae, enepone koêti: “Uhá koeti xuvé'eti xe'exa xâne, konókoti kurí'okopeokono Vúnae” koêti. ");
INSERT INTO terNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Énomone pihínohiko ómea ikó'iparaxoke Itukó'oviti, kuteâti koêku páhoenoa Ponóvoti Kixovókuti emó'uke Itukó'oviti, enepone koyúhoti kónokea ómea pi'âti kirîu, áko'o itukovo pi'âti kálihunoe xe'exa kurûte. ");
INSERT INTO terNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yoko ápe hóyeno ya Njeruzálem koéhati Simêum. Koati ponóvoti neko hóyeno yoko teyotímaka Itukó'oviti, koane kuxoíxotimaka símea ne koitóvoti xâne íhae Izarâe. Koati apêtimaka xunako Sasá'iti Omíxone Itukó'oviti xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yoko éxokoane Sasá'iti Omíxone Itukó'oviti âvoyeamo ivákapu koêku âvoyea naíxa ne Mésiya, enepone páhoe Vúnae Itukó'oviti koíteovo xâne. ");
INSERT INTO terNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Énomone yanekôyo, éxokoa Sasá'iti Omíxone Itukó'oviti ne Simêum kónokea píhea yane hána'iti imokóvokuti. Koane pihóneya. Yoko koati yónokumaka ne há'a yoko eno Jesus omâti ne xe'éxa, itukóponoati kuteâti neko páhoenoa Ponóvoti Kixovókuti ya emó'uke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yaneko simoánehiko há'a yoko eno Jesus, simónemaka ne Simêum, ina namukôa neko kalivôno. Koeku nú'uxea, koane iháyu'ikea Itukó'oviti. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Kó'oyene Unaém, úhepetinemo inzóneu ivóngeovo vo'oku yéxokonoane ra kixínenuke yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Vo'oku noínjoane ya ungéku ra péhoe yara kúveu mêum koíteovo xâne. ");
INSERT INTO terNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Keúsokoane ne koekúti nonékuke uhá koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Enepora kalivôno, kouhápu'ikinotimo po'ínuhiko xâne ákoti itukapu jûdeu, kutí'inokemo imihé'okoti isóneu. Kene ûti, uti xenéna, enómo ihayú'ikoviti vo'ókuke —koéne neko Simêum. ");
INSERT INTO terNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Enepone há'a yoko êno ne Jesus, yupíhova iyúpaxeova neko yuho Simêum vo'ókuke ne xe'éxa. ");
INSERT INTO terNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ina epemínoahiko Simêum unako koêku xoko Itukó'oviti. Yane hara kixómaka Mâriya, êno ne kalivôno: —Enepora kalivôno, koati pahoéti xapákuke ûti íkorokea koane koéxepukopea ênoti xâne ya Izarâe. Koati hoénaxovopemaka ko'ítukeyeane Itukó'oviti xapákuke ûti, itea enómo xâne okopâti. ");
INSERT INTO terNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yoko enómo hána'iti tiveko iséneu vo'ókuke. Kutí koetimo tiveko tetúkine heú'iti pirítau yomíxoneke. Yoko enómo xâne kouhápu'ikeokonoti oveâti isóneuke vo'ókuke ra kalivôno —kíxoane Simêum. ");
INSERT INTO terNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yoko ápemaka sêno koéhati Ána koyúhoti koekúti éxokoake Itukó'oviti âvoti simâpu kaxéna. Eneponeko sêno, ihine hóyeno koéhati Fanûe, ámoriponomaka Âze, po'inu iháxakoku xanena Izarâe. Hóvenoenone neko sêno. Pohu seti koe xoénae ko'íma, yane ivókovone îma. ");
INSERT INTO terNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Enepora sêno ivokóvoti îma, oitentai koaturu koéne xoénaena. Yoko kóyekune ya témpuluke. Yóti, káxe véyo ixómoyea ituko orásaum koane jejuá kó'iyea, yuixóvoti ikóseanaxeovo Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Énomone yaneko ókoku ôra omokónone Jesus hána'itike imokóvokuti, simómaka ne Ána ikoró'ixoponovoti xoko Itukó'oviti, koane koyúhoyeamaka koêku ne kalivôno xoko uhá koeti xâne kuxoíxoati ne páhoe Itukó'oviti koíteovo xanéhiko ya Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Itukoâne evo Yûse yoko Mâriya uhá koêti ne nókone itúkea yane yutoéti Ponóvotike Kixovókuti emó'uke Vúnae, ina aukópovo Ngalíleyake yonópoti Nazâre, enepone pítivokona. ");
INSERT INTO terNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yoko tumúne yóno payá'iyea ne kalivôno koane xuná'iyea mûyo, koane itúkeovomaka ko'isóneuti. Yoko koati êno itípanevo vo'oku seánako Itukó'oviti oúkeke. ");
INSERT INTO terNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Heú koeti xoénae píhea há'a yoko êno ne Jesus ya Njeruzálem xapa áyui jûdeu hó'eke iháxoneti Páskoa. ");
INSERT INTO terNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Itopónone nduse koeti xoénaena ne Jesus, xáneane há'a yoko êno ya Njeruzálem xapa ayuíti, kuteâti itúkeovo kixóvokuhiko yónea. ");
INSERT INTO terNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Uke'éne ne ayuíti, pihóponehiko óvokuke, itea ôvane Jesus ya Njeruzálem ákoti exâ há'a yoko êno. ");
INSERT INTO terNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ikútixatihiko apépoti xapákuke xanépone koeku pihópeahiko. Poehâne káxe yóneahiko, ina oposíkoa há'a yoko êno xapákuke ne iyénoxapa yoko éxonehiko. ");
INSERT INTO terNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ako'óne inixápana, aúkopovo ya Njeruzálem oposíkoponoati. ");
INSERT INTO terNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mopó'apeke káxe ikéne, ina inixóponoa hána'itike imokóvokuti, vatá koyêti xapákuke ne ihíkaxoti xanéhiko hó'eke. Ixomo kamokénoahiko Jesus koane épemo'ikeahiko. ");
INSERT INTO terNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Heú koêti neko xanéhiko kamokénoati, yupíhova iyúpaxeova kó'exoneyea ne Jesus koane itúkeovo koati tokopóvoti ne yumópope. ");
INSERT INTO terNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iyúpaxovamaka há'a yoko êno noixoâne. Hara kíxoa êno: —Nje'exá, na koeti kixínevineye? Yupíhovane koyó'iyea ûti, ûndi yoko yá'a koeku ixómoyea vopósi'ixopopi. ");
INSERT INTO terNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ina kixôa Jesus: —Na koeti pipókexino iséneu yopósi'ixopinonu? Ákoikopo yéxa itúkeovo óvokuke Nzá'a óvonzeixo? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Itea ako éxina isóneu há'a yoko êno neko yumópeake. ");
INSERT INTO terNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yane xanépoanehiko Jesus ya Nazâre. Koati kutípoti há'a yoko êno, koêkuti yuhó'inoa. Enepone eno Jesus, heú kíxoa unákea isóneuke neko koekútihiko. ");
INSERT INTO terNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yoko tumúne yóno kurí'uxeovo éxone Jesus koane payá'iyea yoko enó'iyea itípanevo nonékuke Itukó'oviti koane xapa xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yanekôyoke, itóponone kinze koeti xoénae natíxea ne Tiberiu Sêza, enepone koati payásoti nâti ya Róma. Kene Ponsiu Pilátu itukóvo ngovenâdo ya Njúdeya. Kene ya Ngalíleya, Êrodi pahukóya. Kene ya Itûreya yoko Tarakoníti, Filípi, po'inu Êrodi pahukô. Kene ya Ambíleni, Lîsanea itukóvo pahúkotiya. ");
INSERT INTO terNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kene Ána yoko Kaífa itukóvo koati payásoti sasedóti inuxínoti jûdeu hó'eke yanekôyoke. Koati énomone yaneko káxehiko, ápe yuhó'inoa Itukó'oviti ne Xuaum Mbátita, xé'a Nzakâriya, koeku óvoheixea ya mêum ákoti apêti. ");
INSERT INTO terNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yane heú kíxoa Xuâum yónea ne poké'e xe'ókuke ne huvêo, enepone Njôrdaum, koyuhó'inoati ne xanéhiko kónokea ikótivexea isóneuke ne pahúnevo koánemaka kuríkopea, motovâti kotúyopea Itukó'oviti ne pahúnevo, ina yusîka áhikeovo xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Énomone kuteâtimaka koeku yutóxeovo emó'uke Itukó'oviti yútoeke porofeta Izâiya mekúke, xoko kó'iyeaku: “Énomonemo ne kohonókoti emó'u ya mêum ákoti apêti xapa xâne kamokénoponoati. Haramo koe yûho: ‘Míhi'akinanoe oxéne ne Vúnae itúkea ítuke xepákukenoe. Kéyuseapa ne kixeku itíkivo nonékuke’ koêti. ");
INSERT INTO terNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hanemo koéneye kuteâti koeku xêne kounákopokono enepo pura'úxopokono ne uhoróxotiya. Koati kuteâtimaka koêku ikútipu'ikopokono ne vanuké'exoti koane ponopókono ne xêne ínati ikáyukexo, enepo pura'úxokono koane ikútipu'ikopokonomaka ne uhoróxotiya. ");
INSERT INTO terNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yoko noixoâtimo uhá koeti xâne kíxoaku Itukó'oviti koíteovo xâne” kôe yútoe Izâiya. ");
INSERT INTO terNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hara kíxovokoxoa Xuâum neko êno xâne pihinoâtihiko, enepohikone epemóponoati áhikea: —Itínoe ámoripono xâne kutí koeti koâti ipúhokovoti koéxoe, ikítixati itívoatimo ne ipíhoponopemo Itukó'oviti pohúneti vo'oku yáhikivo njokóyoke? Ako kalíhuina. ");
INSERT INTO terNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Konókoti itíkinoe únati motovâti iyúseyea itíkivonoe ikotívexoati isóneuke ne pahúnevo koane kurikópatimaka. “Uti ámoripono Âbraum,” hákonoe koe iséneupinovo, pe'okoâti itíkivo aha Itukó'oviti vo'ókuke. Vo'oku eneponi itukápu énomone kahá'a ne Itukó'oviti, mani pahukoâti itúkopeovo ámoripono Âbraum ra itátanehiko mopôi. ");
INSERT INTO terNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kuteâti koêku ne povôti usó koyêtine tetúkea tikótihiko ukeâti poéheveke, enepohikone uhá koeti ákoti parêxa únati há'i, ina kurikókono yúkuke, énomonemakamo kíxoaneye Itukó'oviti ne uhá koeti xâne váhere kixoku itúkeovo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ina kixôa xanéhiko ne Xuâum: —Kutí'ikopo kónoko vitúkea? ");
INSERT INTO terNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ina yumopâ Xuâum: —Koêkuti apêti pi'âti kápana, paréxa póhuti ne xâne ákoti ítuke. Kúteanemaka koêku ne apêti nîka, paréxamaka xâne épeu hímakati —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ápemaka koperáxinotihiko nâti simôti xoko Xuâum, enepohikone yómoti ánu'ukea kóperau. Hara kixóponoamaka: —Ihikaxotí, kuti kónoko vitúkea? ");
INSERT INTO terNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ina kixoáhiko Xuâum: —Ópoehane yé'akeye péhoenokono képeraxi, ene képeraxa. Hákone yanú'ukoa —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ápemaka húndaruhiko kixoâti: —Kene ûti, kuti kónoko vitúkea? Ina yumopâmaka Xuâum: —Hako vaheréxo ítikeinoa ne xanéhiko. Hákomaka itikóheyi koêku ne koêkuti xâne. Aúhepeinoamaka iséneu ne yé'akeye tiûketi némoenoe —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yoko enepohikoneko xâne, koati ainóvoti kuxoíxoatine símea ne páhoe Itukó'oviti koíteovo xâne. Ká'aye koéhiko isóneuno Xuâum: “Énomonemea ne Mésiya, páhoe Itukó'oviti koíteovovi? áko'o pó'itimea” koe isóneunoahiko. ");
INSERT INTO terNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ina kixoáhiko Xuâum: —Kaná'uti ánjikeopinoe ya úne iháke Itukó'oviti, itea keno'ókotinemo koati hána'iti teyonéti ya undíke. Muhíkova anjí'okeova ngúxeinoa imo perékatana, ako omóndokea. Énomonemo ahíko xanéhiko haînati ya úne itea ya xunákoke Sasá'iti Omíxone Itukó'oviti. Yoko kutí koetimo otuko yúku ne xunáko kasása'ikea. ");
INSERT INTO terNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hanemo koéneye, xâne omó'ixoti kasasá'ikopeti kuteâti ápa vo'ókuke. Kuteâti kixókonoku nonéti, enepone tirîku kasasá'ikovo, énomonemakamo kixóneye xanéhiko nê'e. Kuteâtimaka koeku ípihopeokono há'i íhakuke, énomonemakamo kixóneye xâne únati kixoku itúkeovo nê'e. Kene ne xâne ákoti aunáti, enepohikone kutí koeti ike kasása'ikine tirîku, kurikoâtimo yúkuke ákotinemo ípukeovoku —kíxovokoxoane Xuâum. ");
INSERT INTO terNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Énomone koéneye yuho Xuaum Mbátita. Koane ákomaka tôpi po'ínuhiko enékope xanéhiko koêku koyúhoinoa ne inámati ihíkauvoti íhae xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ina saya'íkoamaka Xuâum ne Êrodi, enepone hána'iti pahúkoti ya Ngalíleya, vo'oku kóyenopea yeno koati po'ínu, sêno koéhati Erôdiya. Haina póhutine, itea vo'ókumaka po'ínuhiko váhere ítuke. ");
INSERT INTO terNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yane inamá'axo kuri'úxovo váhere ítuke ne Êrodi vo'oku kuríkeane Xuâum ika'ákovokutike. ");
INSERT INTO terNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Uke'éxoane Xuâum áhikea uhá koêti neko xâne, ina ahíkomaka Jesus. Koeku itúkea orásaum ne Jesus, mihe'ó koéne ne vanúke ");
INSERT INTO terNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","koane evésekea ne Sasá'iti Omíxone Itukó'oviti xokóyoke kutí koeti kurûte. Yane apé koéne emo'úti inu'íxoti vanúkeke koêti: —Iti Nje'éxa koati ákoti omotóva ongóvo, porexónuti hána'iti elókeko ongóvo —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Enepone Jesus, itopónone kuteâti tirinta koetine xoénaena, ina turixôa itúkea ne ítukexeake Itukó'oviti. Yoko ya isóneunoake xanéhiko, koati xé'a Yûse nê'e. Harâ'ahiko iha oxúnoekene. ");
INSERT INTO terNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Kene Éli, xé'a Matâti. ");
INSERT INTO terNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Enepone Yûse, xé'a Matátiya. ");
INSERT INTO terNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Kene Nâgai, Mâte itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Kene Njôda, Njoánam itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Kene Nêri, Meúki itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Kene Ér, Njozûe itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Kene Lévi, Simêum, xé'a Njúda, itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Kene Eliyáki, Melêa itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Kene Njése, Ôbedi, xé'a Mbôa, itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Enepone Nâsom, Aminâdabi itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Kene Njúda, Njáko, xé'a Izáki, itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Kene Náko, Serûki, xé'a Rágau, itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kene Sála, Káinam, xé'a Arafáxadi itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Kene Laméki, Metuzálem, xé'a Enóki, itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enepone Káinam, Ênu itukôa xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yupihovó koéne êno xunako Sasá'iti Omíxone Itukó'oviti xoko Jesus ukopeâne húveona Njôrdaum. Yane ómane Sasá'iti Omíxone Itukó'oviti ya mêum ákoti apêti. ");
INSERT INTO terNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Koarenta koe káxe óva koane hixópea Ndeâpu íkorokea pahunévotike. Ákomaka nîka ne Jesus koeku óvoheixeaya. Ikénepoke koarenta koeti káxe ákoyea nîka, yane épekoane hímakati. ");
INSERT INTO terNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yane hara kíxoa Ndeâpu: —Enepo itikápuxo koati kaná'uti Xe'exa Itukó'oviti, pehúka sá'iri'okopeovo pâum ra mopôi. ");
INSERT INTO terNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ina yumopâ Jesus: —Hara kôe ne yutoéti emó'uke Itukó'oviti: “Haina póhutine nikokónoti koxunáko xâne” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ínamaka ómo Jesus ne Ndeâpu vanúke'exeakuke ne mopôi. Yane hú kíxoane éxokea uhá koeti pahúkoku payásotihiko yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ina kixôa Ndeâpu: —Mborexópeatimo itúkeovo îti exêa koêku uhá koêti ra natixókutihiko, koane ítikenemo uhá koêti ne úhe'ene. Yane itimo hána'iti ihayú'iuti vo'ókuke. Vo'oku mboréxokonoane uhá koêti râ'a, yoko koêkutimo ânja mboréxea, mborexoâtimo. ");
INSERT INTO terNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Poéhane ipíyikexi nonénguke kutí kixénuti Itukó'oviti, yane ítikenemo uhá koêti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ina kixôa Jesus: —Hara kôe ne yutoéti emó'uke Itukó'oviti: “Ópoehane Yúnae Itukó'oviti ipíyikexina. Poéhane motovâ kíxeokononeye” kôe —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yane omone Jesus ne Ndeâpu ya Njeruzálem xoko koati kirípuhike ne hána'iti imokóvokuti, ina kixôa: —Enepo itikápuxo Xe'exa Itukó'oviti, kepúhakapapu poké'eke, ");
INSERT INTO terNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","vo'oku hara kôe ne yutoéti ya emó'uke Itukó'oviti: “Pahukoâtimo Itukó'oviti ne ánjuhiko, enepone ovóxe íhae vanúke, kátarakeopi. ");
INSERT INTO terNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Énomonemo namukópopi ya vô'u maka hákone okó'okovo hîvi ya mopôi” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ina kixôa Jesus: —Haramaka kôe po'i yutoéti emó'uke Itukó'oviti: “Hako yoposí'okova ne Yúnae Itukó'oviti” koémaka. ");
INSERT INTO terNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Uke'éxoane Ndeâpu hixópea ne Jesus ya uhá koeti kó'iyeovoku hixópeake, yane kali ahíkuxopeovaiko kuxotí'iko káxe unátiyeakumo kíxoaku ítea íkorokea pahunévotike. ");
INSERT INTO terNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ikénepoke, ina aukópovo ne Jesus Ngalíleyake. Koati xúnati ne Sasá'iti Omíxone Itukó'oviti xokóyoke. Yoko hi'imé koéne xâne eyekóxeati unako ítuke yaneko poké'e. ");
INSERT INTO terNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Íhikaxomaka ne Jesus ya sinâgogahiko, enepone íhikaxovoku hó'e jûdeuhiko, koane uhá kó'iyea xâne iháyu'ikea. ");
INSERT INTO terNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Úkeane pího ne Jesus ya Nazâre, pitivóko éxokexeaku. Ya sâputu, pihóne ya íhikaxovoku hó'e jûdeuhiko kuteâti kixóvoku. Yane ina exepúko yúhoikea emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yoko ápe porexoâti ne koyuhópeti, óvoku yútoe porofeta Izâiya, enepone koyúhoti emo'u Itukó'oviti mekúke. Mihe'ókoane Jesus, ina inixóponoa xoko kó'iyeaku ne yutoéti: ");
INSERT INTO terNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anéye njokóyoke ne Sasá'iti Omíxone Vúnae, enepone haxakónuti ngoyúhoinoa xâne ákoti apeínoati ra inámati ihíkauvoti ítuke Itukó'oviti. Pahúkonumaka ngoyúhoyea símeovone kaxena íteovo xunako vaherévokoti ne xanéhiko kutí koeti ákau váhere kixovókuti. Pahúkonumaka mboréxea ínixopea ne xâne komítiti, koane ngayápahikopea koêku ne xâne kutí koeti koínoti êno ínati koekúti vo'oku tiú'iko kóyeku. ");
INSERT INTO terNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pahúkonumaka ngoyúhoyea símeovone kaxena koúhapu'ikeovo hána'iti seánakoa Vúnae ne xanéhiko” koêti. ");
INSERT INTO terNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Uke'éxoa yúhoikea, yane exéxopane Jesus ne koyuhópeti, koane poréxopea ne xâne unakópati, ina ivatákopomaka ne Jesus. Yoko uhá koêti neko xanéhikoya, komomo-komomó kíxoixoane. ");
INSERT INTO terNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ina kixovókoxoa Jesus: —Enepora emo'u Itukó'oviti yuké'eu kémokenoyi, simóvone kíxone kó'oyene —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yoko uhá koêti neko kamokénoti, ínixeahiko úhe'ekea neko yuho Jesus. Koati iyupáxovatihiko éxea koyúhoyea emo'útihiko yupihóvoti unáko kuteâti neko yûho. Hara kixókoko: —Hainá'ikopo xé'a Yûse râ'a? ");
INSERT INTO terNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ina kixovókoxoa Jesus: —Koati kaná'uti keyúhoinonoamo ra kixonéti koêti: “Iti ipixáxoti, keítapapu” koêti. Koane: “Itíkinaveamaka yara pitivóko peyá'iyiku uhá koêti ne ítike veyékoune itíki ya Kafanâum” kixénutimo. ");
INSERT INTO terNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Koati endó'okopitinoe koêku: Ako ápahuina porófeta koyúhoti emo'u Itukó'oviti ivavákokonoti xapa xâne úkeakuke. ");
INSERT INTO terNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Koati emo'úti ra yunzó'inopinoe: Êno sêno ivokóvoti îma ya Izarâe yanekôyoke ya kaxénake Îliya. Énomone yaneko ákoyeaku kêva úko ya kúveu mopo'âti xoénae sei koeti kohê. Yoko enómaka hímakati ya uhá koêti neko poké'e yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Itea haina xoko ivokóvoti îma ya poké'exake Izarâe pahúkokono ne Îliya. Hane pahúkokono xoko sêno ákoti itukapu jûdeu, sêno ivokóvoti îma ya Sarépita poké'exake Sîdom. ");
INSERT INTO terNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Enómaka xâne ya poké'exa Izarâe ya kaxénake porofeta Ilîzeu yúvone koati koímaiti arinéti, enepone lépara kixonéti, itea ako ápahuina xapákuke koítovone ne porófeta. Poéhane Námam, hóyeno ákotimaka itukapu jûdeu íhae poké'exa Sîrea koítovo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yane yupihovó koene ímaikinovo Jesus ne uhá koêti neko jûdeu kameâti yûho yane íhikaxovokuke hó'e. ");
INSERT INTO terNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xépuku koéponehiko, ina kopúhikopohiko Jesus meúkeke yane pitivóko xoko koati vanúke'exeakuke yane kali mopôi, óvoku ne pitivóko. Ina kaha'âhiko amátitikea poké'eke koukeâti koati vanúke'exeakuke ne mopôi, ");
INSERT INTO terNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","itea huvokó kixópa Jesus neko xanéhiko. Yane pihópeane. ");
INSERT INTO terNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ina pího ne Jesus ya Kafanâum, po'i pitivóko ya Ngalíleya. Ya sâputu, ihíkaxotine xanéhiko íhikaxovokuke hó'e. ");
INSERT INTO terNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yupíhova iháyu'ikea xanéhiko ne kixoku íhikaxea. Koâti iyúseoti itúkeovo úkeakune xokóyoke ne hána'iti exóneti íhikaxone. ");
INSERT INTO terNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yoko ápe hóyeno ûroevo ndémoniu yane íhikaxovokuke hó'e jûdeuhiko. Ina kohonóko emó'u kó'iyea: ");
INSERT INTO terNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesus, íhae Nazâre, na koeti yího'ixopoinovi? Simínetine yuké'exoponivi? Énjoa itíkivoa ne Sasá'iti Páhoe Itukó'oviti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ina saya'íkoa Jesus neko ndémoniu. Hara kíxoa: —Hákone keyûho, ipíhikapi ra hóyeno —kíxoane. Yane íkorokoane ndémoniu neko hóyeno poké'eke xapákuke uhá koêti neko xâne, ina ipuhíkopea ákoti aka'áka. ");
INSERT INTO terNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yupíhova iyúpaxeova uhá koeti xâne noixoâti koane kíxeokoko: —Namea kixotí'iye koêku enepo koyûho râ'a? Koati apêti hána'iti xunáko pahúkea ndémoniu ipúhikopea xoko xâne ûroevo, koane kutípeahiko emó'u —kixókokone. ");
INSERT INTO terNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yane xapákuke neko pitivókohiko ákoti ahikápu, hi'imé koene xâne eyékoxea unáko ítuke ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ipuhíkopeane Jesus ne íhikaxovoku hó'e jûdeuhiko, hane yonópo óvokuke Simaum Pêturu. Yoko ka'aríneti imóse ne Símaum, yupihóvoti xunako otuko mûyo. Ina epemóhiko Jesus huvó'oxea. ");
INSERT INTO terNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Simeáne xêrerekuke ipéna, pahúkoane uké'epea ne otuko mûyo. Koá'axo, uké'epone neko êno otuko mûyo. Yane exépukopone neko sêno koane kátarakopea evo Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Koêku kahá'ayeane onómekeovo káxe yanekôyoke, heú koetíhiko neko xâne apêti ka'aríneti óvokuke, koêkuti kó'iyeovoku ne aríne, ómahiko xoko Jesus, koane koíteova Jesus koeku ípihea vô'u tutíkuke. ");
INSERT INTO terNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Enómaka xâne ûroevo ndémoniu koítovone. Koêku ipúhikopeahiko ne ndémoniu, koane koyúhoyea ya koati hónotike emo'úti: —Iti koati Xe'exa Itukó'oviti —koéhiko. Itea sayá'ikoa Jesus, pahukoâtihiko ákoyea okóyuho vo'oku éxeahiko itúkeovo Mésiya, enepone Páhoe Itukó'oviti koíteovo xâne. ");
INSERT INTO terNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yuponíne ipuhíkopeane Jesus neko pitivóko, hane yóno xoko ákoyeaku apêti. Yane opósi'ixoane xanéhiko. Inixóponoane, ákone síkahiko pihópea. ");
INSERT INTO terNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Itea hara kíxovokoxoa Jesus: —Ngónokoamaka ngoyúhoponea xoko po'ínuhiko pitivóko ra inámati ihíkauvoti koyúhoti kixoku koêku natíxea ne Itukó'oviti xapa xâne. Koati énomone mbahúkinokono yara kúveu mêum —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Énomone kíxoaneye koyúhoyea emo'u Itukó'oviti ne Jesus ya íhikaxovokuke hó'e jûdeuhiko ya poké'exa Njúdeya. ");
INSERT INTO terNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Po'i káxe, hane óvo ne Jesus xe'ókuke Mar-na Njenezâre. Yoko ákone yónoku ahíkuxeovo ne Jesus vo'ókuke neko êno xâne xokóyoke kahá'atihiko kámea emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ina noîxo pi'âti vatéke ne Jesus xe'ókuke ne úne. Áko'ohiko vatékenake ne numíkuxoti, únae neko vatéke. Koati evesékopotine, kipo'íkopotine númikuxope. ");
INSERT INTO terNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yane vesenekú koane Jesus neko po'i vatéke, ítuke Símaum, ina epemôa kali ahíkuxea upénoyeakuke úne. Vatá kóyene ne Jesus vatékeke íhikaxea neko êno xâne. ");
INSERT INTO terNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Uke'éxone koyúhoyea ne Jesus, ina kíxo Símaum: —Yahíkuxa upénoyeakuke ra vatéke, ínamo kiriná'eka ne nímikuxope —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ina yumopâ Símaum: —Ihikaxotí, herú kixo ûti yóti ko'ítukeyea ûti, itea ako ápahuina vêho. Itea vo'oku pehúkinu, ngurinó'ekoati ra núminguxope, indukoâti ra péhoenonu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ina kurinó'ekoa Pêturu yoko ha'ínehiko ne númikuxope. Yane yupihovó koene êno hôe êho. Kalíhanini ekétokexea ne númikuxope. ");
INSERT INTO terNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ina oenékoa ne ha'ínehiko ovoti po'íke vatéke epemoâti huvó'oxoponea. Yane pihínoanehiko. Puhi-puhí kíxoa neko pi'âti vatékenahiko. Kalíhanini yúpuririkeovohiko vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Noixoâne Simaum Pêturu neko koekúti, ipuyuké koéne nonékuke Jesus koane kíxea: —Unaém, yahíkuxipunu vo'oku undi xâne pahukóvoti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Koati iyupáxovati Símaum yoko uhá koeti ha'íne neko koekúti, noixoânehiko ne êno hôe itóponehiko. ");
INSERT INTO terNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Koane Teâku yoko Xuâum, xé'a Nzebêdeu, ha'ine Símaum yane itúkovoke, iyúpaxovamaka. Ina kixôa Jesus ne Símaum: —Hako píke. Hainá'ikomo hôe yíxovonoe, itea indukópopitinenoemo ihíkaxoti xâne hókeonu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mikukópanehiko ne vatékena movó'iyeakuke, kurí kixone uhá koeti ítukevo, yane pihónehiko ikéneke Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ápe pitivóko símoku ne Jesus yanekôyo, tokópeaku hóyeno yúvone lépara herú kixeâti koxé'u. Simoné'e neko hóyeno xoko Jesus, ipúyukexea nonékuke koane îsu'okea nône poké'eke, ikoseânaxovati. Hara kixo Jesus: —Unaém, enepo yakahá'a keítivonu, motóva —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ina sipo'ókoa Jesus koane kíxea: —Ngahá'a, sesá'ipine ra yaríne —kíxoane. Ehá'axo koyúhoa Jesus, má koépone ne aríne. ");
INSERT INTO terNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ina ixikó'okoa Jesus ákoyea éto'oe. Hara kíxoa: —Yéxakapanapa ne sasedóti inuxínoti xanena ûti hó'eke. Yamína iké'iparaxoke Itukó'oviti kuteâti páhoe Muîse yútoeke, yéxokovope itúkeovo yunatípotine —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Itea inamá'axone itohíneo xapa xâne koêku neko ítuke Jesus, kutí'inoke pihinoâti ênoti xâne kámokenoponea koane íteovahiko ne aríne. ");
INSERT INTO terNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Itea ápe ahíkuxeovaku Jesus ne xanéhiko motovâti itúkoponea orásaum ya mêum ákoti apêti. ");
INSERT INTO terNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Po'íke káxe ixómoti ihíkaxo ne Jesus. Yoko ápe farîzeuhiko, enepone yuixóvoti hókea yútoe Muîse, koánemaka ne ihíkaxotihiko yútoe Muîse vataká koyêtiya. Ako tôpi pitivóko úkohikeaku ya uhá koeti ipuxóvokuti ya Ngalíleya, koáne ya Njúdeya, koánemaka ya pítivokona Njeruzálem. Koati hána'iti ne xunako Vúnae Itukó'oviti xoko Jesus kutí'inoke koitóvati ne ka'arínetihiko. ");
INSERT INTO terNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yane kenó'okone hóyenohiko omoti po'i hóyeno isayú'ixovoti ákoti ehevákapu mûyo. Ixané kíxeahiko poúke ómea, koane opósikeahiko kíxoaku ómea ne isayú'ixovoti nonékuke Jesus, ");
INSERT INTO terNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","itea akó'oti évekoaku vo'ókuke neko êno xâne. Hukinóvoti alú'okeahiko oúke péti, ina kohinókinoahiko évekoaku koévesekea. Ixané kíxeane ne poúke koévesekea xoko kohínokinoakuhiko téya ne péti nonékuke Jesus xapákuke neko êno xâne. ");
INSERT INTO terNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Noixoâne Jesus itúkeovo koati kuvovâtihiko, ina kixôa ne isayú'ixovoti: —Hoyenó, itúyopone pehúnevo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ina kixokókohiko ne éskiriba ihíkaxoti yútoe Muîse koáne ne farîzeuhiko: —Kuti íkutixapovo ra hóyeno? Koati itûkovoti Itukó'oviti nê'e, vo'oku poéhane Itukó'oviti motovâ kotúyopea pahunévoti —kixókokohiko. ");
INSERT INTO terNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Itea éxea Jesus isóneuhiko, hukinóvoti kíxovokoxea: —Na koeti kixíneanenoeye ne iséneu? ");
INSERT INTO terNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kuti itukóvoxo ákoti hé'onoke'e, ngíxea ra isayú'ixovoti: “Itúyopone pehúnevo?” áko'o, “Yexépukapa, yenápa” ngíxea. ");
INSERT INTO terNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Itea kó'oyene, yexoâtinenoemo ápeyea njunáko yâye yara poké'e ngotúyopea pahunévoti, undi íhae vanúke ikútipasikoponovoti xâne —koéne. Ina kixôa Jesus ne isayú'ixovoti: —Mbahúkopi yexépukopi, viyápa ne peúke, pihépa yóvokuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Koati énomone yaneko ókoku ôra, xépu koépone neko hóyeno nonékuke neko xanéhiko, ina veyopâ ne poúke tunúkuheixovokumeku, yane pihópone óvokuke koane iháyu'ikopea Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yupíhovahiko iyúpaxeova uhá koeti xâne noixoâti, koane iháyu'ikeahiko Itukó'oviti vo'ókuke. Êno hána'iti píkeahiko koane kó'iyea: —Imáko koêku ra hána'iti iyupánevoti noíxone ûti kó'oyene —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yanê'e, koêku ukóponea ne Jesus, ápe hóyeno noíxone, koperáxinoti nâti, vaata koyêti xoko kóperaxoku. Lévi koéha. Ina kixôa Jesus: —Kiná'aka ingéneke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yane xepú koéne Lévi. Kurí kíxoane uhá koêti neko itúkovoke, yane pihóne hókea Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ina itûko êno hána'iti nikaxóvoti ne Lévi óvokuke. Êno po'ínuhiko koperáxinoti nâti kaha'íneati mesáke, koánemaka po'ínuhiko xâne húpiu. ");
INSERT INTO terNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yane enepohikone farîzeu koánemaka ne éskiribahiko hokotímaka isóneu evo farîzeu, kapáhakinova ne íhikauhiko Jesus. Hara kíxovokoxoahiko: —Na koeti ínikineanoe ne koperáxinoti nâti yoko xâne pahukóvoti? ");
INSERT INTO terNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ina kixovókoxoa Jesus: —Enepohikone xâne ákoti yuvâti, ako okónoko ipixáxoati. Poéhane ka'aríneti konokôa. ");
INSERT INTO terNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Haina nzimínoti xâne ponóvoti kixoku itúkeovo, itea hane nzimíno xâne pahukóvoti maka ikátivexane isóneuke ne pahúnevo koane kuríkopea —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ínamaka apê xanéhiko kixoti Jesus: —Enepohikone íhikau Xuaum Mbátita koánemaka ne íhikauhiko farîzeu, kóyekune jejuá kó'iyea koane itúkea orásaum. Kene íhikeuhiko, anéko níkeahiko —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ina kixoáhiko Jesus: —Yusíkoikopomea pehúki jejuá kó'iyea ne húpiu kasâtuxoti koêkuiko ápeyea ne koyénoti xapákuke? ");
INSERT INTO terNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Itea simóvotimo káxe veyópeokonokumo ne koyénoti xapákukehiko. Hainápo, jejuá koetímo yaneko káxe —kíxoanehiko Jesus, kixopóvoti yane éxetina. ");
INSERT INTO terNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ina kixovókoxopamaka Jesus: —Ako xâne veyoti inámati ipovóti itukoâti ihápa'akope xoko kúxoti ipovóti, vo'oku mani koukóponoati ívarereoku ne kúxotine ipovóti —kíxovokoxoanemaka, ihókoati inámati ipovóti ne ihíkauvoti íhikaxone ákoti akutêa ne kúxoti hó'e xâne. ");
INSERT INTO terNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ina kixovókoxopaikomaka Jesus: —Ákomaka yusíka unákeovo inámati víyum ya yékoteno íhaku, itukéti ya vakamóto, mará'inamo ívarerea ne yékoteno íhaku enepo ihiyáka ne inámati víyum. Yane mani evókovoti ne víyum koánemaka ne íhaku. ");
INSERT INTO terNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Itea konókoti ímeokono inámatike íhaku ne inámati víyum, (yane ako évakapu ne íhaku koáne ne ovâti). ");
INSERT INTO terNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Itea ako ápahuina xâne kaha'âti ne inámatiko víyum uke'éxoane énoyeova ne kúxoti víyum, vo'oku hara koe isóneunoa: “Koati únateoxo ne kúxoti víyum” koéne isóneu —kíxovokoxoanemaka Jesus, exókoatihiko itúkeovo koati pó'iti koêku ne inámati ihíkauvoti ítuke yane kúxoti ihíkauvoti. ");
INSERT INTO terNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Koati sâputu yanekôyoke vékeahiko evo Jesus kali xêne vekoti kavâne ya kaxena itóvope ha'i nonéti. Koêku vékeahiko koane marékea ha'i tirîku ne íhikauhiko, koane xokéxea, nikoâtihiko. ");
INSERT INTO terNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yane ápe farîzeuhiko, enepone yuixóvoti hókea yútoe Muîse kixoâti: —Na koeti itíkinonoe koekúti ákoti parexá'avea hó'e ûti yútoeke Muîse vitúkea ya sâputu? ");
INSERT INTO terNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ina yumopâ Jesus: —Ákoikopo yíhoikiku ya emó'uke Itukó'oviti koêku ítuke Ndávi mekúke yaneko epékoa hímakati koánemaka ha'ínehiko? ");
INSERT INTO terNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Énomone yaneko ûrukeovaku Ndávi neko óvoku Itukó'oviti enepo veyôa neko pâum ikó'iparaxokonoke Itukó'oviti. Yane níkoa, koane poréxeamaka ne ha'ínehiko upánini ákoyea paréxa yútoe Muîse níkeokono, vo'oku poéhane sasedótihiko inuxínoti xanéhiko hó'eke motovâ níkea. ");
INSERT INTO terNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ina kixoáhikomaka Jesus: —Koati undíne exêa koêku ne sâputu, undi íhae vanúke ikútipasikoponovoti xâne —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Po'íke sâputu, ûrukova Jesus ne sinâgoga, enepone íhikaxovoku hó'e jûdeuhiko, yane íhikaxone. Yoko ápe hóyenoya timó'iti poixo'o vô'u éxopeke. ");
INSERT INTO terNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ápemaka éskiribahiko yoko farîzeuhiko ixómoti ivokó'oko Jesus koíteovamo neko hóyeno ya sâputu, oposí'ixoti évekinoaku yûho itúkeovo pahukóvoti ne Jesus enepo kaitápa. ");
INSERT INTO terNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Itea exó kíxea Jesus isóneunoahiko. Yane hara kíxoa ne hóyeno timó'iti poixo'o vô'u: —Yexépuka, xe'ó yákoe nonekútike —kíxoane. Yane exépukone ne hóyeno. Xe'ó koéne nonekútike. ");
INSERT INTO terNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ina kixovókoxoa Jesus neko êskiriba yoko farîzeu: —Na kó'inoaye iséneu? Pahúkovi Ponóvoti Kixovókuti yútoe Muîse vitúkea únati ya sâputu? áko'o vitúkea váhere, koíteovo uti ka'aríneti? áko'o sikó kíxea ûti ivókeovo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yane pono-ponó kixínoane ûke Jesus uhá koêti neko xâne apêtiya. Ina kixôa ne hóyeno: —Kepáya'akapa ne veô'u —kíxoane. Koáne, kapáya'akopane ne vô'u. Yane unátipone. ");
INSERT INTO terNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yupihovó koénehiko ímaikexeovo neko êskiribahiko koane yúho'ixeokoko, oposíkoti kixókumo ítea íkorokea Jesus ya yumópope. ");
INSERT INTO terNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yaneko káxehiko, pîho Jesus oúkeke kali mopôi itukóponoti orásaum. Herú kixo yóti yúho'ixea Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yuponíne, iháxikoanehiko neko xâne hokoâti. Yane noívokoxone nduse koêti xapákuke. Yoko ápostulu íhaxeamaka Jesus neko nduse koeti noívokoe. ");
INSERT INTO terNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Harâ'ahiko îha: Símaum, eneponeko íhaxopone Pêturu; yoko Ándere, po'inu Símaum; koane Teâku; Xuâum; Filípi yoko Mbatulúmeu. ");
INSERT INTO terNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ina apémaka Máteu; Túme; Teâku, enepone xé'a Áfeu; yoko Simaum Nzelóti; ");
INSERT INTO terNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","koane Njûda, enepone xé'a Teâku; yoko Njuda Iskarióti, eneponeko itûkoheovoti koeku hókea Jesus kurikoâti xapa xanéhiko puvâti. ");
INSERT INTO terNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Evesékopeane kali mopôi ne Jesus, xané kixópa íhikauhiko. Hane óko xoko kutípu'iyeokokoku ne poké'e xoko óvoheixoku êno po'ínuhiko xâne hokó'ixoati. Koati êno xâne ukeâti uhá koeti Njúdeya yoko Njeruzálem, koánemaka Tîru yoko Sîdom, enepone pitivókohiko ovoti xe'o mar. ");
INSERT INTO terNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Simínotihiko kámokenoponea Jesus yoko épemea koíteova ya arínehiko. Ápe xâne ûroevo ndémoniu koítovonemaka Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Uhá koêti neko êno xâne, aínovo kaha'âti sipó'okoponeahiko Jesus vo'oku ápeyea xunáko ipuhíkeati xokóyoke koitóvati uhá koêti neko ka'arínetihiko. ");
INSERT INTO terNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ina komomâ Jesus ne íhikauhiko. Hara kíxovokoxoa: —Koati únati kêku, itínoe hokónuti ákoti apeínoati, vo'oku yenópotimo xoko natíxoku Itukó'oviti vanúkeke. ");
INSERT INTO terNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—Koati únati kêku, itínoe hokónuti épeu hímakati yara koêku kó'oyene, vo'oku ákomo konokínovopiti káxehiko keno'ókoti. —Koati únati kêku, itínoe hokónuti iyôti koêku kó'oyene, vo'oku eloképotimo yokóvo káxehiko keno'ókoti. ");
INSERT INTO terNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—Koati únatinoe kêku pivakána, koane kepúhikapakana xapákuke xâne kîrivokoevo, koane itukáheakana kêku, koane yokoyúhokonomaka itíkivo ákoti aunáti vo'ónguke, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aélokenoe yokóvo simapúne káxe kíxikononeye. Yupihovó ákoe elókeyea yokóvo, vo'oku koati hána'itimo némoepo vanúkeke xoko Itukó'oviti. Yoko koati kíxoakunehikomaka yoxúnoekene púveahiko neko porófeta koyúhoti emo'u Itukó'oviti mekúke. ");
INSERT INTO terNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—Itea koati kotívetimo kêku, itínoe iríku yuixóvoti koúhepekea kóyeku yara kúveu mêum, vo'oku koékuikonemo ne úhepeko kéyeku yâye yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Koati kotívetimo kêku, itínoe kutí koeti xâne imatáxovotine ákoti nókone, vo'oku keno'ókoti káxe, kutí ketímo épeu hímakati. Koati hána'itimo ikénoko'ixivo. —Koati kotívetimo kêku, itínoe ekóvoti, yuixóvoti koúhepekea kóyeku yâye yara kúveu mêum, vo'oku keno'ókoti káxe iyeínotinoemo hána'iti tiveko kêkumo. ");
INSERT INTO terNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—Koati kotívetimo kêku, itínoe ínixone uhá koeti po'ínuhiko xâne yánavokoevo itíkivo únati, vo'oku énomone kíxoaneye yoxúnoekene iháyu'ikea ne porófetahiko ákoti itukapu koati kaná'uti ovoxe Itukó'oviti mekúke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ina kixovókoxopaikomaka Jesus: —Hara ngixópinoe, itínoe kamokénonuti: Hákonoe motovâ yokóvo ne xâne itukínopiti váhere. Itíkina únati ne xâne puvópiti. ");
INSERT INTO terNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yépemina Itukó'oviti unako koêku ne hupará'ikopiti. Itíkinamaka orásaum ne itukóheoti kêku. ");
INSERT INTO terNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Áva ipusóhovoxopiti, síkeanemaka ipúsokea poixô'oke. Koane áva hu'uxópiti keápana, síkeane omópeamaka ripíno. ");
INSERT INTO terNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Heú koeti epemópiti ítikevo, peréxa. Koane áva veyoti ítikevo, hako hi'ixópa. ");
INSERT INTO terNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kuteâti kehá'ayi unáko kixópiku ne xanéhiko, énomonemaka íxeaneye ne po'ínuhiko xâne kîrivokoevo. ");
INSERT INTO terNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Enepo itukapu póhutine xâne ákoti omotóvopi okóvo ako omótovo yokóvo, apêtikopomo némoepo xoko Itukó'oviti vo'ókuke? Muhíkova xâne váhere kixoku itúkeovo, ákomaka omótova okóvo ne po'ínuhiko xâne ákotimaka omotóva okóvo. ");
INSERT INTO terNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Itukapu póhutine xâne itukínopiti únati itíkopino únati, apêtikopomo némoepo xoko Itukó'oviti vo'ókuke? Muhíkova xâne pahukóvoti ítoa kíxeaneye. ");
INSERT INTO terNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Koane itukapu póhutine ívexo ne xâne yéxone poréxopeopimo ívexoake, apêtikopomo némoepo xoko Itukó'oviti vo'ókuke? Muhíkova xâne pahukóvoti, ívaxomaka po'ínuhiko xâne pahukóvoti koêku éxea poréxopeamo ívaxoake. ");
INSERT INTO terNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Itea hara ngixópinoe, hako motovâ yokóvo ne xâne puvópiti, koane itíkina únati. Ívexamaka ákoti kixâ poréxopeopeamo ne ívexoake, yane koati hána'itimo ne íperapomo xoko Itukó'oviti, koane itínoemo koati xe'éxaxapa Itukó'oviti, enepone koati payásoti ya uhá koêti. Vo'oku muhíkova ne xâne ákoti ikará'ixapu xokóyoke, koánemaka ne koati váhere xâne, kóseana Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Itíkapuikopo seánati kuteâti koêku ne Yá'a íhae vanúke. ");
INSERT INTO terNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Hákonoe itikovo xâne húketi isóneuno po'ínuhiko xâne, inixeâti itúkeovo pahukóvoti enepo hákoti yexôa koêku, vo'oku kúteanemakamo kixékonoku. Hákomaka keyuhôa kónokea ipíhoponeokono ne xâne ákoti koati yéxi koêku, vo'oku kúteanemakamo kixékonoku. Koane hákomaka yunakôa iséneuke ne váhere ítukeinopi po'ínuhiko xâne, itea kutí íxea ákoti váherexeaku ítukeinopi. Yane kúteanemakamo kixékonoku. ");
INSERT INTO terNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","—Ú'uso yákoye peréxi nókone po'ínuhiko xâne, vo'oku kúteanemakamo kixékonoku. Hanemo koéneye némoepo, kuteâti koêku ísahikea ovâti ne xáku vo'oku ákoyeane yónokuya, enepo yupihóvone yutútukeokono kopuhíkokono, vo'oku kuteâti kíxeaku ne po'íhiko xâne, kúteanemakamo kixékonoku —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ina itukínoahikomaka íhokoake ne âha íhikaxea. Hara kíxovokoxoa: —Ako yusíka hiríkea komítiti ne po'i komítiti vo'oku enepo hirikâ, uhá koetímo ne pi'âti íkorono'ekeovo uhorókuke. ");
INSERT INTO terNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Enepone ihíkaxovoti, haina énomone payasô ya ihíkaxoati. Itea uhá koeti ihíkaxovoti, itukovo koati únati íhikaxeokono, kutipasí koetímo ihíkaxoati. ");
INSERT INTO terNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—Na koeti yíxinova kemómoyi ne kutí koeti kalîhuti koekúti yonoti ukékuke po'ínu xâne koêku ákoyea ínixepa ne kutí koeti koati hána'iti itátane tikóti yonoti yukékuke? ");
INSERT INTO terNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","—Na kíxeaye yéxoki po'i xâne pahúnevo koêku ákoyea ínixepa ne pehúnevo? Mani kutí keti xâne ákoti eapâ ne hána'iti itátane tikóti yoneâti ukéku, itea kóyeane kíxea ne po'ínu: “Mbo'inú, veyámbinapeavo ne kali koekúti yonoti yukékuke” kixoâti. Itínoe ikútixapovoti sasá'iti yane po'ínuhiko xâne, viyápavo inúxotike ne kutí koeti hána'iti itátane tikóti yonoti yukékuke maka sásasa ákoyepone ínixi, ínamo omotóva viyópi ne kutí koeti kali koekúti yonoti ukékuke ne pe'ínu —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ina kixovókoxopaikomaka Jesus: —Ako únati xuve tikóti poréxoti váhere há'i. Kúteanemaka koêku ne xuve tikóti ákoti aunáti, ákomaka parexa únati há'i. ");
INSERT INTO terNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Uhá koeti xuve tikóti, hane éxeokono há'i pôreu. Vo'oku ako veyákana fîgu xuvékuke topekóxe. Koane ákomaka veyákana úva ya xuvékuke ka'áveti nonéti xapa úhiti. ");
INSERT INTO terNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Enepone únati xâne, aínovo únatinoe koyúho vo'ókuke ne únatinoe koekúti unakóvoti isóneuke. Kene ne váhere xâne, aínovo ákoti aunáti koyúho vo'ókuke ne váhere koekúti unakóvoti isóneuke. ");
INSERT INTO terNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Na koeti “Unaém, Unaém” kixínenunoe koêku ákoyea itíka ne mbáhoenopinoe itíki? ");
INSERT INTO terNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Uhá koetíhiko ne xâne simónuti koane kamokénoati ra emó'um yoko itukoâti, ");
INSERT INTO terNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","hane koéneye hóyeno itúkoti péti, upénoti kehókea inúxotike imókone itopóno mopôi, ímoaku poéheve ne péti. Uséxoane ne péti, keno'ókone êno koiníkoti. Yane kayákakoane ne péti, itea ako íkaraka vo'oku kókoyuse kíxeokono itúkeokono. ");
INSERT INTO terNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Itea enepone xâne kamokénoati ra emó'um ákoti itukâ, hane koéneye xâne itúkoti péti ákoti itukína poéheve inúxotike. Pohu oúke poké'e ímoa. Keno'óko êno koiníkoti huvêo kayakákoati ne péti, ako oríko íkorokea. Yane heu-heú kôe itáhineyea ne péti —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Uke'éxoane Jesus koyúhoinoa xanéhiko neko uhá koeti íhikaxeake, ina aukópovo ya Kafanâum. ");
INSERT INTO terNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yoko ápe tuti húndaru íhae Róma yane pitivóko apêti ahínoe ka'aríneti. Koati énotine koêku ne ahínoe, kahá'atine ivókeovo. Yoko yupíhova ákoyea omótova okóvo tuti húndaru neko ahínoe. ");
INSERT INTO terNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Eyekóxoane tuti húndaru koeku ítuke Jesus, pahúkone tutíhiko jûdeu xoko Jesus épemopoinoa xanépea óvokuke koíteova ne ahínoe. ");
INSERT INTO terNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Simohíko neko pahoéti xoko Jesus, hopeno-hopenó kíxoa éhakeovo píhea. Hara kíxoa: —Enepone hóyeno pahukó'oviti, koati motokeâti hivó'oxoponi, ");
INSERT INTO terNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","vo'oku koati ínikone viyénoxapa jûdeu, koane itúkinovi víhikaxovoku hó'e ûti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yane xanépoanehiko Jesus. Ye'éxeane óvoku, pahúkoa tuti húndaru ne ínikonehiko kixópoinoa Jesus: —Unaém, mbuvâti mboréxeopi itukéti. Ako yomótokea yûrukivo kalíke óvongu. ");
INSERT INTO terNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Énomonemaka ákoino mbîha xikóyoke ininjoâti ákoyea omóndokea yúnzo'ixoponeopi, iti hána'iti teyonéti. Pohu pahú íxea unátipea ne anzínoe yákokene xoko yóvoheixoku, yane unatípotinemo. ");
INSERT INTO terNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Vo'oku undímaka hóyeno konókoti itúkea páhoenonu payásoti ya undíke. Koane ápe húndaru konókoti itúkea mbáhoenoa. Poéhane kónoko “Pîhe” ngíxea, yane pihotíne. Kene po'ínu “Kiná'aka” ngixôa, keno'ókotine. Koane “Hara itíka” ngixôa ne anzínoe, itúkoa ne mbáhoenoa itúkea —koéne emó'u neko tuti húndaru páhoe xoko Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kamoáne Jesus neko emó'uinoa, yupíhova iháyu'ikea neko hóyeno. Ina sa'irí'okinova ne xanéhiko hokoâti koáne kíxovokoxea: —Ako noínjeaku xâne koati kuvovónuti kuteâti ra hóyeno, muhíkova xapákuke viyénoxapa íhae Izarâe —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yane káyukopovonehiko neko pahoéti óvokuke tuti húndaru, yoko inú'ikopane unátipeane neko ahinoêti. ");
INSERT INTO terNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ikénepoke, pihóne Jesus ya kali pitivóko koéhati Nâim, koane íhikauhiko xánea. Enómaka po'i xâne hokó'ixoati. ");
INSERT INTO terNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ye'éxeane páhapetea ne pitivóko, apé koéne xanéhiko ipuhíkeati, ekoxóponoti xé'a sêno ivokóvotine îma. Yoko ako po'inu xe'éxa neko sêno, poéhane nekôyo. Êno xâne íhae ne pitivóko xaneâti neko sêno. ");
INSERT INTO terNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Noixoâne Vúnae êno ne ivokóvoti, yupihovó koéne kóseanayea. —Hako iyêo —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ina ahi'ókovaxo Jesus ne koínoyeokonoke, koane ípihea vô'uya. Yane xe'okó koénehiko neko koinoâti. Ina kixôa Jesus neko ivokóvoti: —Hemenó, mbahúkopi yexépukopi —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yane vatá koépone neko ivokóvoti, koane turíxopeovone koyúhoyea. Ina kixôa Jesus neko sêno: —Anéyepo ra xí'a —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yupihovó koene píkea uhá koêti neko xâne koane iháyu'ikeahiko Itukó'oviti. Hara koéhiko: —Anéye koati teyonéti porófeta xapákuke ûti. Koati simotíne ne Itukó'oviti xapákuke ûti kóseanayeovi, uti xanéna —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Enepora koekúti, ítuke Jesus, ako malíka yónoku eyékoxeokono ya uhá koeti poké'exa Njúdeya, koánemaka ya ipuxóvokutihiko ákoti ahikâ. ");
INSERT INTO terNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ápehiko íhikau Xuaum Mbátita koyuhópinoti Xuâum uhá koêti neko ítukevo Jesus. Yane iháxikoane Xuâum pi'âti íhikau, ");
INSERT INTO terNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ina pahukoâmaka xoko Vúnae épemoponea itúkeova ne Mésiya, kúxone xâne símeamo, áko'o kónokeako kúxea po'ínu. ");
INSERT INTO terNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Simoné'ehiko neko pi'âti xoko Jesus, hara kíxoa: —Xuaum Mbátita pahukó'ovi vépemoponeopi itúkeovo îti ne kúxone ûti símeamo, áko'o kónokea kúxeako uti po'ínu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Énomone yaneko ókoku ôra, êno ka'aríneti koítovone Jesus koane xâne yúvone koati kotíveti arinéti yoko xâne ûroevo ndémoniu. Enómaka komítiti koítovone. ");
INSERT INTO terNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ina kixôa Jesus ne páhoe Xuâum: —Yaúkapapu xoko Xuâum. Yéta'akapa koêku ra neíxone koáne ra kémone, ínixopeanehiko ne komítiti, yonópeanehiko ne mohéveu, koane unátipeanehikomaka ne xâne yúvone lépara. Yéta'akapamaka kamópeane ne mókere, yoko iyúkopeovone ne ivokóvoti, koane koyúhoyeovone ne inámati ihíkauvoti ítuke Itukó'oviti xapa xâne ákoti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yoko koati únati koêku ne xâne ákoti opoé'ainonu isóneu —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pihopónehiko neko páhoe Xuâum xoko Jesus, turíxovone Jesus koyúhoino xanéhiko koeku Xuâum. Hara kíxovokoxoa: —Enepo pihenôe neíxoponi Xuâum ya mêum ákoti apêti, kutí'ikopo kixónoe neíxi? Xâne muyá'iti kuteâti koêku hí'e kayákae ihunóvoti? Ako kalíhuina. ");
INSERT INTO terNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kutí'ikopoya ne neíxopono? Hóyeno yupihóvoti úhe'ekea ípovo? Ako kalíhuina kó'iyeaneye ko'ípovoyea nê'e. Vo'oku xâne únatinoe ko'ípovoyea, enepone apêtimaka uhá koeti kó'iyeovoku únatinoe koekúti ya xokóyoke, poéhane óvokuke nâti óvo. ");
INSERT INTO terNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kutí'ikopoya ne neíxopono? Porófeta koyúhoti emo'u Itukó'oviti? Êm, koati porófeta nê'e, yoko koati ngixópitinoe yupíheovo anú'ukea itúkeovo teyonéti ya po'ínuhiko porófeta. ");
INSERT INTO terNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Vo'oku hara koe yuho Itukó'oviti emó'uke vo'ókuke neko neíxoponone: “Mbahukoâtimo timúneke ne koyuhó'inonuti emó'um, maka míhe'akinapine yoxéne itíki índukexeopike xapákuke xâne” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Koati ngixópitinoe: Xapákuke xâne yara kúveu mêum, ako teyonéti ya Xuâum. Itea upánini itúkeovo koati hána'iti teyonéti ne Xuâum yâye yara kúveu mêum, koati yupihóvotimo anú'ukea itúkeovo teyonéti ya Xuâum ne xanéhiko ya natíxokuke Itukó'oviti, muhíkova ne koati ákoti apayáso xapákuke —kíxovokoxoane Jesus neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Uhá koêti neko kameâti yûho, muhíkinova ne koperáxinotihiko nâti, éxokopovo ínixea itúkeovo koati ponóvoti ne yuho Itukó'oviti vo'oku ikótivexea isóneuke ne pahúnevo, koane áhikeovo xoko Xuâum. ");
INSERT INTO terNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Itea enepohikoneko farîzeu, yuixóvoti hókea yútoe Muîse, yóko'o ne ihíkaxoti jûdeuhiko ya hó'eke, ako áhikapu xoko Xuâum vo'oku ákoyea akáha'a ne mani ahá'inoa Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ina kixovókoxopaikomaka Jesus: —Kutimea motóvo ínzokea ra xanéhiko apêti yara káxehiko kó'oyene? Kutimea koéneye? ");
INSERT INTO terNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hara ínzokoa kalivónohiko vataká koyêti ya none ovokúti ákoti ínixone unáko apê po'ínuhiko kalivôno kaha'âti ikómohixea. Yane hara kixókonohiko: “Voxone oxokénati, móhikena elóketi okóvo, itea ákonoe yakáha'a kemóhiyi. Yane vimókovonemaka akene imokó'ikoti ivokóvoti, itea ákomaka yakáha'a” —kixókonone. ");
INSERT INTO terNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ina kixovókoxopaikomaka Jesus neko xâne: Énomonemaka kénenoeye, vo'oku simóne Xuaum Mbátita yuixóvoti jejuá kó'iyea yoko ákoyea énapu víyum, itea ako ínixeanoe unáko. “Ûroevo ndémoniu nê'e” kíxeanoe. ");
INSERT INTO terNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ina nzímo xepákukenoe iníngoti xâne, undi íhae vanúke ikútipasikoponovoti xâne, itea ákomaka ínixeanoe unáko. Hara kôe iséneunonu: “Koati nípati yoko énovokenati víyum ne hóyeno, koane yómoti aínavokoxeovo koperáxinoti nâti yoko po'ínuhiko xâne pahukóvoti” kixénunoe. ");
INSERT INTO terNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Itea enepone koati kaná'uti exóneti, kóyeanemo iyúseyea kó'iyeaneye vo'oku kixoku itúkeovo ne xâne hokoâti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ápe farîzeu itaíkoti Jesus njántaxoponea óvokuke. Simoné'e Jesus óvokuke, ivátakone xe'o mêsa. ");
INSERT INTO terNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yane apé koene sêno íhae neko pitivóko yupihóvati éxeokono ákoyea aúnati kixoku itúkeovo. Eyekóxone nikóponea Jesus óvokuke farîzeu, omó kixone íhaku xêru, itukéti ya hopú'iti mopôi iháxoneti alabásturu, puhí koatí'iko ovâti. ");
INSERT INTO terNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Simoné'e neko sêno, akéneke Jesus véko ahí'okeova ixómoyea íyo koeku kaláka'ikea heve Jesus, koane kíhuhevexopea ya híyeu tûti, yoko siúnoneyea hêve, koánemaka óvohevexea xêru ómone. ");
INSERT INTO terNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Noixoâne farîzeu, enepone itaíkoti Jesus, hara koe isóneunoa: “Eneponi itukápuxo porófeta, páhoe Itukó'oviti koyúhoyea emó'u ra hóyeno, mani exoâti itukóvotiye ra sêno isú'okovati itúkeovo ákoti aunáti kixoku itúkeovo” kôe isóneu. ");
INSERT INTO terNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ina kixôa Jesus neko farîzeu: —Simaúm, anéye ânja ngoyúhoinopea. —Yokóyuhoakopo ihikaxotí —kíxoane Símaum. ");
INSERT INTO terNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ina kixôa Jesus: —Ápe pi'âti hóyeno orevéxoti po'i hóyeno, poéha orevéxoati singu koeti séndu pe'u tiûketi, kene ne po'ínu, sinkoénta koe pe'u tiûketi orévexoake. ");
INSERT INTO terNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Itea ákone tiûketina ne orevéxoatihiko mani poréxopeake. Yane koyúhoinoane hóyeno iváxoati ne tiûketi ákoyeane okónokoa poréxopea neko orévexoake. Yane pi'âti orevéxoti, kutimo itukóvo yupihóvati ákoyea omótova okóvo ne hóyeno iváxoati tiûketi? —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ina kixôa Símaum: —Ya inzóneuke, hanemea ako omotóvaxo okóvo xu'ínati oréveu —kíxoane. —Koati únati yimópope —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ina inonéxinova Jesus ne sêno. Yane hara kixo Símaum, kaha'âti koúhapu'ikinoa kixó'ekone ne xêti ítukeinoake: —Neíxoane ra sêno? Kó'oyene koêku ûrungeova ra kúveu yóvoku, ako kali peréxanu úne ngipóhevexovope, kuteâti kixóvoku xâne xo'opeînokoko. Kene ra sêno, ho'oûke veínoa kipóhevexeonu yoko kíhuhevexopeonu ya híyeu tûti. ");
INSERT INTO terNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Koeku nzímea yâyeke, ákomaka sínaneanu. Kene ra sêno, ukeátine inâ urúngovo kúveu yóvoku, ako âka siúnoneyea njêve. ");
INSERT INTO terNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ákomaka yáhipu'ikanu óliu inâ nzímo yóvokuke. Kene ra sêno, xêru veínoa óvohevexeonu. ");
INSERT INTO terNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Énomone ngixínopi: Enepora sêno, sasá'ipeane ne êno pahúnevo. Koati yupihóvati ákoyea omótovonu okóvo. Itea koseánakono xâne ákoti koati pahúnevo, kúteanemaka kalíhuyea ne ákoyea omótova okóvo ne xâne koseánati —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ina kixoá'ikomaka Jesus neko sêno: —Sesá'ipine ne pehúnevo, ngotúyopinopeane. ");
INSERT INTO terNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yane hara kixókoko neko ha'ínehiko ya xe'o mêsa: —Kutimea itukóvoye râ'a? Muhíkova pahunévoti koyúhoa kasása'ikopea. ");
INSERT INTO terNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ina kixopâmaka Jesus ne sêno: —Itévone vo'oku kívivonu. Aúhepepone iséneu koêku pihépi —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yane pihóne Jesus xapa uhá koeti pitivókohiko koane ipuxóvokutihiko koyuhoâti ne inámati ihíkauvoti, enepone kixoku natíxea ne Itukó'oviti xapa xâne. Koane xáneheixoane ne nduse koeti íhikau. ");
INSERT INTO terNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ápemaka senóhiko ûroevo ndémoniu, koítovone Jesus, xanéheixopatine, yoko po'ínuhiko sêno koítovone ya aríne. Xapákuke neko senóhiko, ápe Mâriya koéhatimaka Mandâlena, eneponeko kópuhikopeake Jesus seti koeti ndémoniu. ");
INSERT INTO terNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ápemaka Xuâna, yeno Kûza, hóyeno ko'itúkeinoti Êrodi, enepone nâti. Ápemaka Sûzana, koane enómaka po'ínuhiko sêno iko'ítukexoti apeínoati, huvó'oxope evo Jesus ya nókone. ");
INSERT INTO terNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yupíhovo êno xâne pihinoâti ne Jesus. Ho'uxo-ho'uxó kó'inoahiko ukeâti po'íkehiko pitivóko. Ina itukínoahiko Jesus xêti apêti íhokoake ne âha íhikaxea. Hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ápe hóyeno nopónoti ake nonéti. Koeku kásahikea, ápe irihíkovoti xe'ókuke xêne. Yane kapásikexokono, ínamaka keno'óko hó'openo ôti nikopâti. ");
INSERT INTO terNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kene po'ínuhiko, îrihikovo xoko enó'iyeaku mopôi. Ihonópone, movohí koéne vo'oku ákoyea alákahi ne móte îrihikovoku. ");
INSERT INTO terNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Koane ápemaka irihíkovoti xapa tôpe. Xané kíxoane tôpe payákeyea ne nonéti. Yane ákone oxéne payákeyea ne nonéti vo'oku huruvokó kó'iyea tôpe. ");
INSERT INTO terNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ina apémaka irihíkovoti únatike poké'e. Koati únati íhonopea nê'e. Poréxopo póhuti séndu há'i ne póhuti áke —kíxovokoxoane. Ina kohonókoxo emó'u ne Jesus kó'iyea: —Koêkuti kamoâti ra yûnzo, ivávaka —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ina kíxo Jesus ne íhikauhiko: —Kuti kixó'eko ne yéxetina? ");
INSERT INTO terNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ina yumopâ Jesus: —Koati itínoe porexókono éxea koêku ne koekúti ákoti po'i exoâti, koêku ne natíxea Itukó'oviti xapa xâne, itea ya xapákuke po'ínuhiko xâne, konókoti itúkeovo exetínati apêti íhokovoke veínokono íhikaxeokono. Yane enepo naixâ, kutí koetimo ákoti inixâ, koane enepo kamâ, ákomo éxina isóneu kixó'ekone. ");
INSERT INTO terNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Hara koe kixó'ekone ra énjetina: Enepone ake nonéti, emo'u Itukó'oviti kixó'eko. ");
INSERT INTO terNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Enepone irihíkovoti xe'ókuke xêne, kixo'êkoti xâne kamokénoati ne emo'u Itukó'oviti, ina keno'óko ne Ndeâpu veyopeâti ne emo'u Itukó'oviti isóneuke, puinoâti koíteova Itukó'oviti eneponi akutípoaxo. ");
INSERT INTO terNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kene enepone irihíkovoti xapákuke mopôi, énomone kuteâti xâne ivavákoati ne emo'u Itukó'oviti koeku kámea, xaneâtimaka hána'iti elókeko okóvo. Itea vo'oku kutí kó'iyea nonéti ákoti poéheve, ako áxu'ikene hókea, yane itavókeatine enepo simôa tiú'iti koekúti hixópeokonoke. ");
INSERT INTO terNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kene enepone irihíkovoti xapa tôpe, hane kixó'eko xâne kamokénoati ne emo'u Itukó'oviti, itea koêku xu'íkeneyea, turíxovone pepókexea isóneu vo'oku nókone yara kúveu mêum, koane íyokeovomaka po'ínuhiko koekúti, yane ako únati ítukeino Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kene enepone irihíkovoti únatike poké'e, énomone kuteâti xâne itípakovoti isóneu, kutipoâti ne emo'u Itukó'oviti enepo kamôa, koane unakoâtimaka isóneuke. Yane êno únatinoe ítukeino Itukó'oviti vo'oku ákoyea kamúya'ikapu ikéneke —kíxovokoxoane. Ina kixovókoxopaikomaka: ");
INSERT INTO terNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Ako ihúxoti yúku xovopu'í kixoâti, itukovo imoâti opékuke ípe, itea hane ímoa xoko koati ókoku motovâti noíxea uhápu'ine uhá koeti urúkovati ne ovokúti. ");
INSERT INTO terNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Uhá koeti koekúti puvonéti éxeokono, kourápu'ikokonotimo. Koane uhá koeti kixovókuti he'onó'oeti kó'oyene, exókonotimo koane kouhápu'ikokonotimo. ");
INSERT INTO terNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","—Yokóhiyanavonoe, kéyusea kémokenoyi ra yûnzo, vo'oku enepone apêti námoeya, kuri'úxovotineoxomo námoe. Kene ne ákoti koati ivávakea, muhíkova ne íkutixane apêti xokóyoke, evókoatimo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ina símo xoko Jesus ne êno yoko ámeno, itea ako omótova ahí'okoponeovahiko vo'ókuke neko êno xâne kamokénoati. ");
INSERT INTO terNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ina apê kixopónoti Jesus: —Anêko ne mémaina koane yámeno meúkeke oposíkopiti. ");
INSERT INTO terNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ina kôe ne Jesus: —Enepone xâne kamokénoati ne emo'u Itukó'oviti yoko itukoâti, énomone indúkomaka ênom yoko mbo'ínuhiko —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Po'i káxe, úsa'ixovo vatékeke ne Jesus koane íhikauhiko. Hara kíxovokoxoa Jesus: —Piháne ûti poixô'oke ra mar —kíxovokoxoane. Yane pihónehiko. ");
INSERT INTO terNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Koeku yóneahiko, imókone ne Jesus. Yane kenó'okone êno xúnati ihunóvoti yane mar, koane ûrukeova úne kúveuke ne vatékena. Koati koímaiti koêkuhiko. ");
INSERT INTO terNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ina ahi'ókovo Jesus ne íhikauhiko koyúkoati. —Ihikaxotí, vivohíkovotinemo —kíxoanehiko. Iyukóvone ne Jesus, pahúkoa ókea ne xúnati ihunóvoti koáne ne êno xúnati ovósokeovo úne. Yane okóne ne ihunóvoti koáne ne úne, huvemoo koépone ikéne. ");
INSERT INTO terNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ina kixovókoxoa Jesus ne íhikauhiko: —Imáko ákoyeanoe kivápunu —koéne. Yoko yupihóvatihiko iyúpaxeovo koane píkea. Hara kixókoko: —Kutimea itukóvoye ra hóyeno? Muhíkova ihunóvoti yoko úne, ôko apê yuhó'inoa —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ina ukopóno ne evo Jesus ya poké'e iháxoneti Njêraza, xoko hunókoku poké'exa Ngalíleya poixô'oke ne mar. ");
INSERT INTO terNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ehá'axo evésekea Jesus ne vatéke, apé koéne hóyeno okotúmonexoati íhae neko pitivóko. Yoko koati ûroevo ndémoniu nê'e. Mekutíne ako ituka ípovo, koane ákone ava ovokúti itea pe'áxatike óvoheixone. ");
INSERT INTO terNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Noixóne Jesus neko hóyeno, vaúkone. Yane íkorokovone poké'eke nonékuke Jesus, koane kóhonokea emó'u kíxea: —Jesus, iti Xe'exa Itukó'oviti, iti xe'exa Koati Payásoti ya uhá koêti, na koeti yího'ixinonu? Émbemopi ákoyea ipíhepananu —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kó'inokeneye yûho, koáhati pahukoâtimeku Jesus ne ndémoniu ipúhikopea xoko hóyeno. Yoko enóne kíxoaku ndémoniu. Enepo ikahévexokono ne hóyeno koane ikavó'uxokono ya koati tiú'iti korénde, kóyeane kétokexea ne korénde, yane ehakoâtine ndémoniu ya mêum ákoti apêti. ");
INSERT INTO terNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ina kixôa Jesus: —Kuti kéha? Ina yumopâ: —Ákoti yumaxápu ngoéha —koéne. Kó'inokeneye îha vo'oku ákoyea yumáxapu ndémoniu urúkovati. ");
INSERT INTO terNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yane épemonehiko Jesus neko ndémoniuhiko ákoyea pahúkapa yane êno upénoti uhôro ínati haháku. ");
INSERT INTO terNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yoko oúke neko mopôi, xêrerekuke ne óvoheixokuhiko, ápe ênoti kûre ixómotihiko níko. Énomone épemo ne ndémoniuhiko yonópea xapákuke maka itúkapane óvoheixopoku. Yane síkoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ipuhíhikopeane ndémoniuhiko neko hóyeno, ponokó koépone xapákuke neko êno kûre. Yane heú koéne neko kûre éhahikeovo koane íkorono'ekeovohiko ya mar. Heú koéne yúpuririhikeovo ukeâti oúke ne mopôi. ");
INSERT INTO terNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Noixoâne koyónotihiko kûre neko koekúti, heú koe kohó'iyea koane koyúhopea ne koekúti yaneko pitivóko yoko xapákuke neko ko'óvokuti yane mêum vekópoku. ");
INSERT INTO terNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yane noíxoponoamaka xanéhiko neko koekúti. Simoné'ehiko xoko Jesus, noíxoane neko hóyeno ipúhikopeakumeku ndémoniuhiko. Yoko ko'ipóvopotine koane unatípotine isóneu, vatá koyépotinemaka nonékuke Jesus. Yane yupihovó koéne píkeahiko vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Enepohikoneko xâne noixoâti ne koekúti, koyúhoinoa ne po'i xâne simôti kixoku koêku unátipinoke neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yane enepohikone uhá koeti ko'óvokuti ya Njêraza koane xe'ókuke, épemohiko Jesus ipúhikopea xapákuke. Koáhati yupihóvatihiko píkea. Yane ûrukopovane evo Jesus ne vatéke, ukópeane pihôpo. ");
INSERT INTO terNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kene ne hóyeno ipúhikopeaku ne ndémoniuhiko, épemovo xanépea Jesus. Itea pohu hara kíxoa Jesus: ");
INSERT INTO terNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Yaúkapapu yóvokuke. Yokóyuhopinoa iyínoxapa ne uhá koeti ítukeinopi Itukó'oviti —kíxoane. Yane pihópone ne hóyeno. Heú kíxoa yónea neko pitivóko koyuhó'inoati uhá koeti xâne neko ítukeinoa Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aukópovone Jesus poixô'oke neko mar, yupihovó koéne elókepea okóvo uhá koêti neko xanéhiko kuxoíxopati seópea. ");
INSERT INTO terNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yane apé koéne hóyeno koéhati Njaîru simôti xoko Jesus. Enepone hóyeno, koati exoti koêku ne koekúti ya íhikaxovokuke hó'e jûdeuhiko. Ipúyukexo nonékuke Jesus, epemoâti xanépea óvokuke ");
INSERT INTO terNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","vo'oku ápeyea ihíne nduse koetine xoénaena ka'aríneti, kahá'atine ivókeovo. Yoko ako po'i xe'éxa, poéhane neko kali ihíne. Koêku yónea ne Jesus koane enó'iyea xâne hokoâti, xaneâtimaka inúmeokoko. ");
INSERT INTO terNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yoko ápe sêno nduse koetíne xoénae ká'arine ákoti âka evésekea aríne. Enepone sêno, koati uke'éxotine apeínoati xoko ipixáxotihiko, itea akó'oti koitóvati. ");
INSERT INTO terNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Akéneke Jesus véko neko sêno sipóheoponeati heve ípovo. Ehá'axo sípoheyea, etétukone aríne. ");
INSERT INTO terNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ina kôe ne Jesus: —Kuti sipohêo ímbovo? —koéne. Itea ako ápahuina “Ûndi” kixoâti. Ina kixôa Pêturu (yoko po'ínuhiko íhikau): —Ihikaxotí, koati ênoti xâne isú'okovopiti koane inumópiti, (yépemovikomaka ápeyea sipóheoti ípevo) —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Itea kóyeane neko isóneu Jesus. Hara koépomaka: —Ako yusíka ákoyea sipóheoponoti ímbovo, vo'oku eómba ipúhikea njunáko njokóyoke —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Noixoâne sêno ákoyea íta hé'ono'uxea ne koêku, ina ahi'ókovoxo Jesus xaneâti ínayea honóno'oko. Ipuyuké koéne poké'eke nonékuke Jesus, koane koyúhoyea nonékuke uhá koêti neko xâne kutí'inoke sipóheoponoti híyeu ípovo Jesus, koane koyúhoyea íteovane ne aríne ya oráke. ");
INSERT INTO terNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ina kixôa Jesus: —Nje'exá, itévone vo'oku kívivonu. Pihépane, aúhepepone iséneu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ixómoiko koyûho ne Jesus, simóne xâne ukeâti óvokuke Njaîru, enepone éxoti koeku íhikaxovoku hó'e jûdeu. Hara kixo Njaîru: —Ivókovone ihine îti. Hákone perexôa itukéti ne ihíkaxoti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kameáne Jesus yûho, hara kixo Njaîru: —Hako píke, kivápunu, itóvotimo ne ihine îti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Simoné'e óvokuke Njaîru, ako síka Jesus ápeyea urúkovati ákoti itukapu Pêturu, Xuâum, Teâku, koánemaka há'a yoko êno ne kalivôno ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yoko yupíhovahiko íyokexea uhá koêti neko xâne, koane ipúsokeahiko xâ'a. Ina kixovókoxoa Jesus: —Hákonoe iyêo, vo'oku haina ivokóvoti ra kalivôno, pohu imókoti —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Itea koémoke'ea xanéhiko kameáne neko yûho, exoâti itúkeovo ivokóvotine ne kalivôno. ");
INSERT INTO terNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yane namú kíxeane Jesus vô'u ina kohonóko emó'u kíxea: —Tenó, yexépukapa —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yane aúkopovone omíxone, exépukopone. Ina pahukôa Jesus poréxopeokono nîka. ");
INSERT INTO terNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yupíhova iyúpaxeova há'a yoko êno ne kalivôno. Ina ixikó'okoa Jesus ákoyea okóyuhoinoa po'ínuhiko xâne neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ina ihaxíhikoa Jesus neko nduse koeti íhikau. Yane pôrekexoanehiko xunakóti pahúkea uhá koeti ndémoniu ipúhikopea xoko xâne ûroevo, koane koíteovo xâne ka'aríneti. ");
INSERT INTO terNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ínamaka pahukôa koyúhoyea kixoku natíxea ne Itukó'oviti xapa xâne, koane koíteovo ka'arínetihiko. ");
INSERT INTO terNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hara kíxovokoxoa: —Hákonoe itîko yómone koeku píhi. Hako yómo piló'ina yoko íhaku ípevo. Hákomaka yómo imévo itukovo tiûketi. Muhíkova yesá'ikovope, hako yomâ. ");
INSERT INTO terNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Itukovo apêti ko'óvokuti porexópiti yóki óvokuke, yâvanemoya tukú koetímo neko káxe ipihíkapine ne pitivóko. ");
INSERT INTO terNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Áva pitivóko símeku hákoti kaha'ápi xanéhikoya, enepo ipihíkapine ne pitivóko, ikétatahevexapapumo, kirikópoti ipú'ine poké'e ukeâti xoko piríkatana, yexókoati ákoyeanemo omótokea íkameokonohiko emo'u Itukó'oviti —kíxovokoxoane Jesus neko íhikau. ");
INSERT INTO terNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Úkeane pihohíko. Heú kíxoa vékea ne ipuxóvokutihiko koane koyúhoyea ne inámati ihíkauvoti omínovike Jesus, koánemaka koíteovo xanéhiko ka'aríneti ya uhá koeti vékoku. ");
INSERT INTO terNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yoko eyékoxoane Êrodi, enepone nâti, uhá koêti neko koekúti, itea ako éxina isóneu vo'oku ápeyea koyuhoâti itúkeovo Xuaum Mbátita exepúkopone ukópea xapa ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kene po'ínuhiko xâne, koyúhoa itúkeovo Îliya ne exepúkopone, enepone porófeta mekúke. Ina apémaka po'ínuhiko xâne koyuhoâti itúkeovo kúxoti porófeta koyúhoti emo'u Itukó'oviti mekúke exepúkopone. ");
INSERT INTO terNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Itea hara kôe neko Êrodi: —Haina Xuaum Mbátita nê'e, vo'oku mbahúkoanepepo tetúnoyeokono nekôyo. Kutí'ikopomea itukóvoye ra hóyeno ngámoheixeake koeku ítuke? —koéne. Yoko yupíhova yúmo'ixeova Êrodi noíxea Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aukópovonehiko neko páhoe Jesus koyúhoyea emó'u xapa xâne, heú kíxoa koyúhopinohiko Jesus koêku neko ítuke. Ina xanêa Jesus neko íhikauhiko ya kali pitivóko koéhati Mbetâsaida. Yoko ainôvotinehiko, ako po'i xánena. ");
INSERT INTO terNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Itea exoâne xanéhiko yónoku ne Jesus, hókoanehikoya, yoko ivávakoahiko Jesus. Koyúhoinoahikomaka kixoku natíxea ne Itukó'oviti xapa xâne, koane koíteovahiko ne ka'aríneti xapákuke. ");
INSERT INTO terNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kiyoné'e káxe, ahí'okovone Jesus neko nduse koeti íhikau koane kíxeahiko: —Mani únati pehukápavo pihópea ra xanéhiko, motovâti ínixea imókoku koane nîka ya xapa kali ipuxóvokuti, vekópokuhiko, koane xapa ko'óvokuti ya mêum xêrerekuke ipuxóvokutihiko, vo'oku ako apêti yara vóvoheixoku —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Itea hara kíxovokoxoa Jesus: —Itínenoe parexâ nîka. Ina kixopâmaka íhikauhiko: —Ako apeínoviti ákoti itukapu singu koeti pâum yoko pi'âti hôe. Má'aina itukapu ûti vanexópoinoa nikokónoti ra êno xâne, hainápo —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yoko itópono kuteâti singu koeti míli neko hóyeno apêtiya. Ina kixovókoxoa Jesus ne íhikauhiko: —Pehúka ivátahikea ne xâne. Ho'uxó ho'uxo íxeanoe, sinkoentá sinkoenta koeti ho'úxovoku —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ina pahukoâhiko íhikau Jesus ivátahikea neko xâne. ");
INSERT INTO terNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ina veyôa Jesus neko singu koeti pâum yoko pi'âti hôe, ina komômo vanúke ikoró'ixovoti xoko Itukó'oviti vo'ókuke ne nikokónoti. Yane honó'ekexoane ne pâum, ina porexôa ne íhikauhiko pôrekexea neko xâne. ");
INSERT INTO terNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Uhá koéhiko níkea koane imátaxeovohiko. Ina itixópa íhikauhiko Jesus neko haxâti, kopúhikopoikomaka nduse koeti sésta neko itátanehiko haxa nikokónoti. ");
INSERT INTO terNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yoko pohúxovoti ne Jesus itúkea orásaum yanekôyoke. Áko'ohiko neko êno xâne xokóyoke. Poéhane íhikauhiko kahá'ine. Yane ina kixovókoxoa Jesus neko íhikau: —Kutimea íkutixanu ra xanéhiko? ");
INSERT INTO terNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ina yumopâ íhikauhiko: —Ápe koyúhoti itíkivo Xuaum Mbátita iyukópovone. Kene po'ínuhiko, koyúhoa itíkivo Îliya iyukópovotine. Ina apémaka po'ínuhiko koyuhoâti itíkivo porófeta koyúhoti emo'u Itukó'oviti mekúke iyukópovotine —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Kene itínoe, kuti keyúhonoe indúkeova? Ina kixôa Pêturu: —Iti Mésiya, páhoe Itukó'oviti koíteovo xâne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ina ixikó'okoahiko Jesus ne íhikau ákoyea ápahuina xâne koyúhoinoake nê'e. ");
INSERT INTO terNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ina kixovókoxopaikomaka: —Konókoti yupíheovo ngoítoponeovo kotíveti, undi íhae vanúke ikútipasikoponovoti xâne. Ákomo akútiponu ne tutíhiko viyéno jûdeu, koáne ne payásotihiko sasedóti inuxínoti xanena ûti hó'eke, yóko'o ne ihíkaxotihiko yútoe Muîse, enepohikone éskiriba. Koepékonutihikomo, itea ya mopó'apeke káxe, enjepúkopotinemo ungópea xapa ivokóvoti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ina kixovókoxopaikomaka Jesus uhá koêti neko xâne hokoâti: —Enepone kahá'ati hókeonu, ako yusíka itúkeovo koúhepekea kóyeku yara kúveu mêum yuíxovo. Konókoti hókeonu ya usó koyêti ínonexinovo tiú'iti koekúti itukovo káxe, kuteâti koêku xâne koinópoti kurúhuna iyonókonone xoko kurúhuxokonoku, yane kená'akane ingéneke. ");
INSERT INTO terNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Vo'oku enepone xâne yuixóvoti koúhepekea kóyeku yara kúveu mêum, evókoatimo ne mani unako koépoku xoko Itukó'oviti. Itea enepone xâne usó koyêti évokea úhepeko kóyeku yara kúveu mêum vo'ónguke, énomonemo unatî koépoku xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kutí'ikopo itópoino xâne usó kó'iyea apeínoati yara kúveu mêum itea evókoti mani unako koépoku xoko Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yoko koêkuti xâne teinónuti, koane teinoâti ra emó'um, simóvotimo káxe ndeínoakumakamo, undi íhae vanúke ikútipasikoponovoti xâne. Koati énomonemakamo ngíxoaneyehiko yaneko káxe ngayukápapu, enepo naixápakananemaka indúkeovo hána'iti ihayú'iuti, anjenáponemaka êno njunáko, koane xunako Nzá'a, yoko xunako sasá'itihiko ánju, enepone ovoxe Itukó'oviti ukeâti vanúke. ");
INSERT INTO terNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Koati emo'úti ra yunzó'inopinoe: Anéye xepákukenoe âvotimo ivakápu tumúneke noíxea natíxea ne Itukó'oviti xapa xâne —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kuteâti póhuti sêmana ikénepoke neko yuho Jesus, xánea Jesus ne Pêturu, Xuâum, yoko Teâku oúke hána'iti mopôi itukóponoti orásaum. ");
INSERT INTO terNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Koeku itúkea orásaum ne Jesus, koane ípokeovo koêku ne nône. Hóhopu-hóhopu kóyenemaka ne ípovo, koane ínayeamaka uháhi híyeu. ");
INSERT INTO terNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yane apé koéne pi'âti hóyeno yuhó'ixoati. Énomone neko Muîse yoko Îliya, enepohikone koyúhoti emo'u Itukó'oviti mekúke. ");
INSERT INTO terNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yoko ainovó koéne uhápu'ine íhae vanúke apê xokóyoke neko pi'âti. Hane koyúhoinokoko kixókumo ivókeovo ne Jesus kausáka ne ahá'inoa Itukó'oviti ya Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kene Pêturu koánemaka ne pi'âti ha'íne, yupihovó koénehiko uheko ixépa. Koêku kahá'ayea káharoyea ixépa, iyukovó koéponehiko. Yane noíxone êno uhápu'ine Jesus, koánemaka neko pi'âti hóyeno yuhó'ixoati. ");
INSERT INTO terNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yane ahíkuxopeovone Jesus neko pi'âti hóyeno yuhó'ixoati. Ina kixôa Pêturu ne Jesus: —Ihikaxotí, koati únati vápeyea yâye. Poéhane vitúkinopinoe hú koêti mopo'âti kálihunoe péti. Poéhamo ítike, koane poéhamo ítuke Muîse, koane poéhamo ítuke Îliya —kíxoane. Itea mayane koyuhohí koêti ne Pêturu. Akó'oti koati éxea mani yûho. ");
INSERT INTO terNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ixómoiko koyûho ne Pêturu, apé koéne kapási rama'úxoatihiko. Yane yupihovó koéne píkea ne íhikauhiko Jesus rama'úxoanehiko kapási. ");
INSERT INTO terNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yane apé koéne emo'úti inu'íxoti xapa kapási. Hara kôe: —Énomone nje'éxa râ'a, noívongoe itúkeovo mbáhoe xapa xâne. Yakámokenoyi yûho —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Okoné'e neko emo'úti, pohú kóyepone ne Jesus. Áko'oponehiko neko yuhó'ixoati. Itea ako éto'oe ne evo Pêturu yanekôyoke. Ako ápahuina xâne koyúhoinoake neko noíxonehiko. ");
INSERT INTO terNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Poéha káxe ikénepoke, enepo evesékopeane evo Jesus neko hána'iti mopôi, yupíhova êno xâne okotúmonexopati. ");
INSERT INTO terNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Xapákuke neko êno xâne, apé koéne hóyeno vaúkoti Jesus. Hara kíxoa: —Ihikaxotí, yokóseananu, neíxapainanu njé'a, vo'oku poéhane nê'e, ako po'ínu. ");
INSERT INTO terNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yoko kóyekutine ûrukeova ndémoniu. Enepo urúkova, apé koetíne yaíkea, yane ikorókoatine poké'eke xaneâti êno xunáko koyúyu'okea, koane puváhixeamaka pâho. Koati okó'okoati, koane ôriti kuríkopea enepo kixoáneye. ");
INSERT INTO terNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Émbemoane ne íhikeuhiko kópuhikopea, itea ako íta kíxeaneye —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ina kôe ne Jesus: —Imáko itúkinovo tiú'iti kutípea ra xanéhiko yara káxehiko kó'oyene, koane váherehiko. Ná'ikopomeamo hunóko óvonzeixea xepáku? Ná'ikopomeamo nzunóko índea ákoyeanoe yakútiponu? Yáma yâkeneye ne xi'íxa —kíxoane Jesus neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Koêku píhea ne homoêhou, íkorokoane ndémoniu poké'eke koane koyúyu'okea. Ina pahukôa Jesus ipúhikopea ne ndémoniu, koane koíteova neko homoêhou. Ina kixêa há'a: —Anéyepo ra xi'íxa —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yane yupíhovo iháyu'ikea hána'iti xunako Itukó'oviti uhá koêti neko xâne. Ya koêku yupíheovo iyúpaxeova xanéhiko, koane iháyu'ikeahiko uhá koêti neko ítuke Jesus, hara kíxovokoxoa Jesus ne íhikau: ");
INSERT INTO terNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Yunákanoe iséneuke ra yunzó'inopi kó'oyene: Yé'exovone ngurí'okeokonokumo xunákoke xanéhiko yara kúveu mêum, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Itea ako éxina isóneu íhikauhiko kíxone neko yuho Jesus. Koati he'onínovati ne koekúti ákoinoke éxa koêku. Yoko pikotíhikomaka épemo'ikea Jesus koêku neko yûho. ");
INSERT INTO terNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yane turíxovone okópeokoko ne íhikauhiko Jesus koêku kahá'ayea éxea itukóvotiye ne koati payásoti xapákuke. ");
INSERT INTO terNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yoko exó kíxeane Jesus koêku ne isóneuhiko, yane namú kixone kalivôno ina imôa xêrerekuke. ");
INSERT INTO terNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Yane hara kíxovokoxo íhikau: —Koêkuti itukínoati únati ra kalivôno vo'ónguke, undímaka kixóneye. Yoko koêkuti kixónutineye, koati kixoâtinemakaye ne Pahukónuti yara kúveu mêum. Kó'inokeneye yunzó'inopinoe, vo'oku enepone ákoti kapayásakapu, enepone koati ikalîhuxopovoti xepákukenoe, énomone itukóvoxo ne koati payásoti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ina kixôa Xuâum: —Ihikaxotí, ápe hóyeno noíxone ûti kopúhikopoti ndémoniu ya ihéke, itea sayá'ikoa ûti vo'oku ákoyea itúkapu xáneheixone ûti. ");
INSERT INTO terNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ina kixôa Jesus: —Hákonoe seya'íkoa, vo'oku enepone ákoti akapápinoe, koati huvo'óxopiti nê'e —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Koeku yé'exeovone kaxena pihópea Jesus ya vanúke, koúsokone isóneu nê'e píhea Njeruzálem. Yoko ako itoâti kátavokopea isóneu ákoyea pîha. ");
INSERT INTO terNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ina pahûko inuxínoatihiko. Pihónehiko neko páhoe xoko kali ipuxóvokuti ya Samâriya oposíkopoinoati ókokumoya. ");
INSERT INTO terNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Itea simoné'e evo Jesus, ákone akáha'ainoa ko'óvokuti ókeaya, vo'oku iyúseyea koúsokeane isóneu yónea Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Enepone pi'âti íhikau Jesus, Teâku yoko Xuâum, noixoâne, hara koe yûho: —Unaém, kehá'a viháxikea yúku íhae vanúke uke'éxoati ra xanéhiko? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ina sa'irí'okinova Jesus saya'íkoatihiko. (Hara kíxoa: —Hako kixené'eye yiûho. Ákonoe yéxa úkeaku ne iséneu. ");
INSERT INTO terNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Vo'oku haina nzimínoti ungé'exoponea xâne, itea nzimínoti ngoíteova, undi íhae vanúke ikútipasikoponovoti xâne —kíxoanehiko.) Yane pihónehiko po'íke ipuxóvokuti. ");
INSERT INTO terNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ya xenékuke koêku yóneahiko, ápe hóyeno kixoti Jesus: —Nzokópiti koêkutimo yénoku. ");
INSERT INTO terNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ina kixôa Jesus: —Enepone úkoe, ápe úhorona, koáne ne hó'openohiko ôti, ápe môko. Kene ûndi, undi íhae vanúke ikútipasikoponovoti xâne, ako óvongu yonómboku ómomingea yara kúveu mêum —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ina kixoámaka Jesus ne po'i hóyeno: —Kiná'aka ingéneke. Ina kixopâ hóyeno: —Unaém, sikénuvo engóxeakomo nzá'a inúxotike ivakápune, ínamo nzakâpi. ");
INSERT INTO terNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Itea hara kíxoa Jesus: —Síkeane ne kutí koeti ivokóvotinehiko ákoti yuixápu ítuke Itukó'oviti ekóxopeamo ne ivokóvoti. Kene îti, yokóyuhoponoa kixoku natíxea ne Itukó'oviti xapa xâne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ina kixôa po'i hóyeno: —Nzokópitimo Unaém, itea sikénuvo aúngopeovo óvonguke íngoponeovo iyénonjapa inúxotike. ");
INSERT INTO terNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ina kixôa Jesus: —Enepone xâne apêti itukéti tûriu, ina itavókea isóneu ne ítuke, hane koéneye xâne varereôti poké'e enepo na'akénexovo. Yane ákone aúnati koêku. Xâne kuteâti, ako omótokea itúkeovo ko'itúkeinoti Itukó'oviti koukóponoati ne natíxea Itukó'oviti xapa xâne —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yane ápe po'i setenta koeti noívokoe Jesus. Pi'á pi'a kíxoa pahúkea inúxinoa ya uhá koeti pitivóko vékokuikomo, koáne ya uhá koeti po'i yónoku. ");
INSERT INTO terNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yoko hara kíxovokoxoa pahukoâne: —Koati hána'iti ra itukéti kuteâti koêku kavâne ainóvoti itóvotine ha'i nonéti ovâti, itea ako axú'inahiko ra ko'ítuketi. Yépemanoekopo Itukó'oviti, Únae ra itukéti, pahúkea po'ínuhiko ko'itúkeati. ");
INSERT INTO terNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pihénenoe. Kutí koe mbahúkoti kálihunoe xe'exa su'ûso ya xapa yovîre koeku mbahúkeopinoe. ");
INSERT INTO terNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hákonoe yómo íhaku tiûketi. Hákomaka yómo sékolana, íhaku ípevo, koane piríkatana. Hákonoe ke'umókovo xenékuke yího'ixi xâne. ");
INSERT INTO terNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Enepone inúxoti ovokúti símeku, koêkuti yukóponoku, hara íxeanoe ne ko'óvokutiya: “Embemínopitinoe Itukó'oviti unako kêku” íxeanoe. ");
INSERT INTO terNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Enepo áva xâne yane ovokúti usó koyêti kíxeokononeye kuteâti yépeminoake Itukó'oviti, itukínoatimo Itukó'oviti ne yépeminoake. Kene hakô'o, aukópinovopitimo kuteâti yépeminoake neko xâne. ");
INSERT INTO terNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yávane yane ovokúti peréxokonoku yóki. Koêkuti nikokónoti koane ekâti pónepike ne ko'óvokuti, nemúka vo'oku koati motokeâti ápeyea námoe ne xâne ko'ítuketi. Hako ixomo ipé'ixovo ya po'íkehiko ovokúti. ");
INSERT INTO terNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Koêkuti pitivóko símeku, koeku poréxeopi xanéhikoya yóki xapákuke, níkea koêkuti nikokónoti pónepike. ");
INSERT INTO terNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Enepo áva ka'arínetiya, keítapanoe. Ínamaka ixêa ne xanéhikoya: “Simóvone kaxena natíxea ne Itukó'oviti xepákukenoe” íxea. ");
INSERT INTO terNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kene ya koêkuti pitivóko símeku, enepo hákoti kaha'ápinoe xanéhikoya, hara íxepanoemo koeku vikópi none ovokúti ipihíkapi xapákuke: ");
INSERT INTO terNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Muhíkova ipú'ine poké'e yara pitivóko ovoti perékatanake ûti, vikátata'ikopane, véxokeopikenoe ákoyeane yomótokea íkemikonoa ne emo'u Itukó'oviti. Itea ivévakanoe râ'a: Yé'exovone kaxena natíxeakumo ne Itukó'oviti xapa xâne yara kúveu mêum” íxeamo. ");
INSERT INTO terNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ina kixovókoxopaikomaka Jesus neko páhoe: —Koati enjókopitinoe kixókonokumo ne ákoti akahá'apinoe. Simapúne kaxena ipíhoponope ne Itukó'oviti, muhíkova ne koati váhere xâne mekúke íhae Sódoma, ákomo itápanea tiveko ipíhoponeokonoke ne xanéhiko puvópiti íhae neko pitivóko —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ina koe'íkomaka ne Jesus: —Koati kotívetimo kêku, itínoe íhae Korâzim, keánemaka itínoe íhae Mbetâsaida. Enepone Tîru yoko Sîdom, koati pítivokona xâne ákoti êxa Itukó'oviti, itea eneponi itukapu xapákuke indúkoa ne iyupánevoti índuke xepákuke, mani mekutíne kuríkopohiko váherevoko. Mani ko'ipóvotihiko ko'ixéhiti xáku, koane mani purapú'ikopovotihiko pôu, koáneni ivátahikea xapa pôu, éxokovope yupíheovo ikótivexea isóneuke ne êno pahúnevohiko. ");
INSERT INTO terNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Simapúne kaxena ipíhoponope Itukó'oviti, iyuhí kixokónotimo tiveko ipíhoponeokono ne íhae Tîru yoko íhae Sîdom ya itíke. ");
INSERT INTO terNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kene itínoe íhae Kafanâum, itínoe po'okoâti yupíheovomo kahána'ikeokono ya po'ínuhiko xâne, kirikókonotinoemo ipihóponovokutike —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ina kixovókoxo íhikauhiko: —Enepone xâne usó koyêti kámokenoyea yiûho, undímaka kámokeno. Kene enepone puvópiti, undímaka púvo. Koáne enepone puvónuti, hane púvo ne Pahukónuti yara kúveu mêum —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ukopeânehiko xoko pahúkonoku neko setenta koeti páhoe Jesus, yupihovó koénehiko elókepea okóvo. Hara kixópohiko Jesus: —Unaém, muhíkova ndémoniuhiko itúkea yuho ûti pahukôa ûti ya ihéke ipúhikopea xoko xâne ûroevo —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ina kixovókoxoa Jesus: —Noínjoa ne Satánae kutí koeti ipixéneneoti irikóvoti ukeâti vanúkeke. ");
INSERT INTO terNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mboréxopinenoe yókonuki koéxoe yoko pitánae, koane ákomo kixópiku. Mboréxopinenoemaka xunakóti anu'úkoti uhá koeti xunako Satánae, vanáne. Ákomo ápahuina koekúti itoti váherexea ítukeinopi. ");
INSERT INTO terNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Itea hako itukovo vo'oku itúkea yiûho ne ndémoniuhiko elókeinoke yokóvo, itea hane itíka elókeinoke yokóvo yutóxeovone îhe xoko Itukó'oviti vanúkeke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Énomone yaneko ókoku ôra, yupihovó koéne elókeyea okóvo ne Jesus vo'ókuke ne Sasá'iti Omíxone Itukó'oviti xokóyoke. Hara kôe: —Aínapo yákoe Pai, iti Únae vanúke koane poké'e, vo'oku ákoyea itúkapu hána'itinoe ko'éxoneti yoko hána'itinoe ihíkaxovoti yara kúveu mêum yéxokoa ra koekúti, itea itúkeovo xâne ákotihiko apayáso nonékuke po'ínuhiko keúhapu'ikinoa ra koekútihiko. Koati énomone kíxea Pai, vo'oku ínixi unáko kó'iyeaneye —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ina koe'íkomaka ne Jesus: —Kurí'okoponoane Nzá'a ne uhá koeti koekúti. Ako exónuti, undi Xe'exa Itukó'oviti, ákoti itukapu Nzá'a, poéhane exónu. Koane ákomaka exoâti ne Nzá'a ákoti itukapu ûndi, undi Xe'éxa, yoko koêkuti xâne ânja énjokea —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ina inonéxinova Jesus ne íhikauhiko. Hara kíxovokoxoa, motovâti ákoyea káma po'i xâne: —Koati únati kêku, itínoe noixoâti ne koekúti neíxonenoe kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Koati ngixópitinoe enó'iyea porófeta koyúhoti emo'u Itukó'oviti mekúke, koánemaka nâtihiko mani kaha'âti noíxea kuteâti ne neíxonenoe, itea ako naíxa. Mani kaha'âtimaka kámea kuteâti ne kémonenoe, itea ako káma —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Apé koene hóyeno ihíkaxoti yútoe Muîse exepúkoti, oposí'okovoti Jesus, kaha'aînoati pahúkeovo ya yumópope. Hara kíxoa: —Ihikaxotí, kuti ngónoko indúkea motovâti ápeinonu inámati apéyeati ákotinemo hunókoku xoko Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ina yumopâ Jesus: —Ná'ikopo kó'eye ne Ponóvoti Kixovókuti yútoe Muîse? Na kíxeaye keûrapu'iki enepo ihíkexo? ");
INSERT INTO terNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ina yumopâ hóyeno: —“Heru'ó íxea yomíxone koane xináko koane iséneu ákoyea omótova yokóvo ne Yúnae Itukó'oviti.” Hara po'ínu: “Hako motovâ yokóvo ne po'ínuhiko xâne. Kuteâti kixépovoku ákoyea kemáxatikapapu, énomonemaka íxeaneye ne po'ínuhiko xâne” —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ina kixôa Jesus: —Koati tokopóvoti ne yimópope. Énomone itíka motovâti itéponi ne inámati apéyeati ákotinemo hunókoku xoko Itukó'oviti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yane vo'oku kahá'ayea ápeyea pó'onexeovoke neko hóyeno, hara kixópomaka Jesus: —Kutí'ikopo itukóvoxo xâne nóngone ákoyea omótova ongóvo? ");
INSERT INTO terNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ina yumopâ Jesus itukínoati íhokoake: —Ápe hóyeno ukeâti Njeruzálem yonoti Njeríko. Ya xenékuke namúkoane ómevotihiko. Véyeane uhá koeti apeínoati, ina yehepóke'exoa, êno óko'okea. Kalíhanini koépekeahiko kurikoâne. ");
INSERT INTO terNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yane apé koene sasedóti inuxínoti xanéhiko hó'eke vekoâtimaka neko xêne. Tavó kó'iyeane noixôa neko okó'okovoti. ");
INSERT INTO terNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yane apé koénemaka po'i hóyeno vekoâtimaka neko xêne. Énomone levíta itúkoti ítuke Itukó'oviti ya hána'iti imokóvokuti. Kúteanemaka kíxoaku, tavó kó'iyeanemaka noixoâne. ");
INSERT INTO terNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yane kenó'okone hóyeno ákoti itukapu jûdeu íhae Samâriya, vekoâtimaka neko xêne. Tokononé koáne neko hóyeno okó'okovoti. Yane yupihovó koéne kóseanayea. ");
INSERT INTO terNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pihínoane koane ipíxaxeane óko'onevo ipíhinoati óliu yoko víyum. Ina ivú'ixopamaka péyo, iyonoâti xoko pénsaum koane katarákoati. ");
INSERT INTO terNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yaneko po'ípone káxe, ina porêxo únae pénsaum pi'âti pe'u tiûketi, ina kixôa: “Kétaraka ra hóyeno. Enepomo anu'úka ésa'i ra mbónepike kétarakike, kóyeanemo mboréxopeopi aungápapu” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ina kixoá'ikomaka Jesus neko hóyeno ihíkaxoti yútoe Muîse: —Ya xapákuke ra mopo'âti, kuti ínixe itúkeovoxo ákoti omotóva okóvo neko hóyeno isoéti? ");
INSERT INTO terNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ina yumopâ hóyeno: —Énomone neko koseánati. Ina kixôa Jesus: —Pihé'evo, énomonemaka íxeaneye kuteâti ítuke neko hóyeno —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Koêku yónea ne Jesus yoko íhikauhiko, sîmo xoko kali ipuxóvokuti. Ápe senóya koéhati Márta, itaíkoti Jesus ókea óvokuke. ");
INSERT INTO terNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Enepone sêno, ápe po'ínu koéhati Mâriya. Yane vata-vatá kixóvone Mâriya poké'eke nonékuke Jesus ivavákoati ne ihíkauvoti íhikau. ");
INSERT INTO terNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kene Márta, koati pepokéxoti isóneu vo'oku enó'iyea ítuke ya kúveu óvoku. Ina ahi'ókovo Jesus, hara kíxoa: —Unaém, ako kó'inopiku kurí kíxeonu ne mbo'ínu mbóhuxeovo indúkea heú koêti ra itukéti? Pehúka huvó'oxeonu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ina yumopâ Vúnae: —Martá, imáko ké'iyivoku. Koati pepoké kixeti iséneu, koane êno yónoku iséneu, ");
INSERT INTO terNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","itea poéhaxo ne koekúti koâti nokonéti. Noívokoxoa Mâriya ne koâti únati ya uhá koêti, yoko ákomo veyopeâti —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Po'íke káxe, ápe óvoheixoku oráxea ne Jesus. Uke'éxone itúkea orásaum ápe íhikau kixoâti: —Unaém, íhikexavimaka vitúkea orásaum kuteâti kíxoaku Xuaum Mbátita íhikaxea ne íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ina ihíkaxoahiko Jesus. Hara kíxovokoxoa: —Enepo itikánoe orásaum, hara yákoe: “Pai, émbemopi téyeamo sasá'iti îhe ne uhá koeti xâne, koane ukóponeamo ne netíxi yara poké'e xapákuke xâne. ");
INSERT INTO terNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Peréxavi nika ûti itukovo káxe. ");
INSERT INTO terNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ketúyapa pahúnevo ûti koêkumaka kóseanayea ûti ne po'ínuhiko xâne vaheréxinoviti ítuke, kutí kixoâti uti ákoti pahukápu. Hako sike'évi víkorokeovo pahunévotike” yákoenoe —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ina itukínoamaka Jesus íhokoake ne ihíkauvoti íhikaxone. Hara kôe: —Ínani áva xepákuke pihôti óvokuke ínikone ya kuku yóti kixopónoati: “Iningoné, yokóseananu, ívexanu mopo'âti koxe'u pâum, ");
INSERT INTO terNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","vo'oku ínati simônu íningone xo'opeînonuti, yoko akó'oti níngaxeake” kixóponea. ");
INSERT INTO terNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","—Ínani akôe kúveuke óvoku: “Hákone tiri'ókoponovonu. Enjéxopane páhapetea ra óvongu. Ndunúkuxopovone, koánemaka uhá koeti nje'éxaxapa. Ákone omótova enjépukinopi” ínani akôe. ");
INSERT INTO terNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—Koati ngixópitinoe, enepo hákoti exepúkinoa poréxoponea ne uhá koeti nókone vo'oku itúkeovo ínikone, itea vo'oku ákoyea káyunuka nekôyo épemo'ixea, kóyeanemo exépukinoa poréxoponea. ");
INSERT INTO terNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hukinóvoti ngíxeopinoe: Yépema ne Itukó'oviti, vo'oku porexópeatimo. Yapásika nékone xokóyoke, vo'oku itepónoatimo. Hane yákoenemakaye xâne ipusókoti pahapéti, yane imihé'okinopitimo. ");
INSERT INTO terNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vo'oku uhá koeti epémoti, poréxokonoa ne épemone. Koáne ne xâne oposíkoti itóponea konokínovati, itóponoa. Koáne ne xâne kutí koeti ipusókoti pahapéti, mihe'ókinokonoatimo. ");
INSERT INTO terNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Itínoe apêti xe'éxa, (maní'ikopomea perexoâti mopôi ne xi'íxa epemápi pâum?) Manímea koéxoe peréxoa epemápi hôe? ");
INSERT INTO terNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Koáneni epemápi kopútoe tapî'i, manímea perexoâti pitánae kotíveti yutôko? Ako kalíhuina. ");
INSERT INTO terNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Muhíkova itínoe mapini xâne pahukóvoti nonékuke Itukó'oviti, itea kóyeane peréxi únatinoe koekúti ne xi'íxa. Ínapoxo ne Ha'a ûti íhae vanúke, koati porexoâtimo Sasá'iti Omíxone ne epemoâti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Po'i káxe, kópuhikopo ndémoniu ne Jesus xoko hóyeno ûroevo. Yoko akó'otine okoyúho neko hóyeno vo'ókuke ne ndémoniu. Ipuhíkopeane ndémoniu, koyúhopone neko hóyeno. Enepohikoneko êno xâne noixoâti, yupihovó koe iyúpaxeova. ");
INSERT INTO terNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Itea ápe xâne xapákuke koêti: —Koati Mbezêbu, enepone pahúkoti uhá koeti ndémoniu, porexôa ra hóyeno kópuhikopea ndémoniu —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kene po'ínuhiko xâne, épemohiko Jesus itúkea iyupánevoti, hoénaxovope itúkeovo xoko Itukó'oviti úkea xunáko, oposí'okovatihiko, kaha'aînoati pahúkeovo ya yumópope. ");
INSERT INTO terNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Exó kíxea Jesus isóneuhiko, énomone kixínoahiko: —Uhá koeti natixókuti, óvoku xâne ixómoti okopókoko, itohíneotimo xanéhikoya, ákonemo ovâti. Kúteanemakamo koêku ne ko'óvokutihiko ovoti póhutike ovokúti. Itukovo ixómoti okopókoko, uké'etimo itúkeovo póhutine óvohikoku. ");
INSERT INTO terNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kúteanemaka koêku xoko Satánae yoko ovóxehiko, vo'oku eneponi ixomo akapákaka, mani uke'éxopokokotihiko. Kó'inokeneye ra yunzó'inopinoe, koáhati keyuhoâtinoe itúkeovo xunákoke Mbezêbu ngópuhikopea ndémoniuhiko. ");
INSERT INTO terNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eneponi itukapu xunákoke Mbezêbu ngópuhikopea ndémoniuhiko kuteâti iséneunonu, ná'ikopo kó'inoaye iséneu ne he'ínehiko ya hé'eke kopúhikopotimaka ndémoniu? Ako kalíhuina kó'inoaneye yiûho kuteâti ra yihó'inonu. Koati énomonehikomo kouhápu'iko itúkeovo pahukóvoti ne iséneunonu. ");
INSERT INTO terNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Koêku itúkeovo ya xunákoke Itukó'oviti ngópuhikopea ndémoniuhiko, koati iyúseoti símeovone kaxena natíxea Itukó'oviti xepákukenoe. ");
INSERT INTO terNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Noixó íxeanoe ne koati xúnati hóyeno usó kixoíxoti sa'íkovope, kohiyánati óvoku yoko uhá koeti apeínoati. Ako itoâti véyea ítukevo. ");
INSERT INTO terNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Itea enepo símo koati xúnatiya, ítoa omópea sa'íkovope, enepone íhuinovoke. Yane omópea uhá koeti apeínoati koane háxakexea xapa ha'íne —kíxovokoxoane Jesus, ihókoati xúnati hóyeno ne Satánae, koane kixopóvoti itúkeovo xunané'e ya Satánae. ");
INSERT INTO terNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ina kixovókoxopaikomaka Jesus: —Enepone ákoti huva'áxanu, koati okopónuti. Koane enepone ákoti itukapu nza'íne índukeke, itopó kíxoa ukóponea ne itukéti índuke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ina koe'íkomaka ne Jesus: —Enepo ipuhíkopea xâne ûroevo ne ndémoniu, píhoheo ya mêum ákoti apêti oposíkoti ókoku, itea ako ínixapana. Yane hara kôe: “Aungópovotiko xoko imbúhikopeaku” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yane aúkopovane, yoko inú'ikopane sásasa koyépotine koane êno úhe'ene vo'oku ákoyea inú'epoya. ");
INSERT INTO terNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ina itaíkopono po'i seti koeti ndémoniu itúkoti xanépone. Yoko aínovo koati váhere yane inúxoti. Ina urúhikopovo xokóyoke neko hóyeno. Yane yupihovó koéne váherexea koépoku neko hóyeno yane inúxoti koêku —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Koêku ixómoyea koyúho ne Jesus, apé koéne sêno xapákuke neko êno xâne kohonókoti emó'u kó'iyea: —Koâti únati koêku ne sêno koxe'éxapiti koane ohíkopiti ya xêne —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ina kôe ne Jesus: —Hane itukóvoxo koati motokeâti “únati koêku” kíxeokono, xâne kamokénoati ne emo'u Itukó'oviti koane itukoâti ne páhoenoa —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hara koe Jesus koêku ho'uxo-ho'uxó kó'iyea ne êno xâne xokóyoke: —Koati váhere ra xanéhiko apêti yara káxehiko símokune ûti, épemoikomaka iyupánevoti, hoénaxovope itúkeovo xoko Itukó'oviti úkea njunáko. Itea ákomo ápahuina iyupánevoti noíxonemo, ákoti itukapu kuteâti koêku xoko Njóna mekúke. ");
INSERT INTO terNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Vo'oku kuteâti koêku Njóna itúkeovo hoénaxovope xunako Itukó'oviti xapákuke neko íhae Nínivi mekúke, énomonemakamo ngoéneye, undi íhae vanúke ikútipasikoponovoti xâne. Undímakamo hoénaxovope xunako Itukó'oviti xapákuke ra xanéhiko apêti yara káxehiko símokune ûti. ");
INSERT INTO terNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Simapúne kaxena yúhoikopeakumo Itukó'oviti ne xanéhiko, enepone seno nâti mekúke íhae poké'e koéhati Sâba, hanekóxonomo xapákuke ne xanéhiko apêti kó'oyene. Exepúkotimo neko sêno, exókoatimo pahúnevo ra xanéhiko apêti kó'oyene, vo'oku yupíheovo ákoyea malíka úkeaku neko sêno kámokenoponea ne êno hána'iti kó'exoneyea ne Salúmaum. Yoko anéyene koati payásoti ya Salúmaum, enepora yuhó'ixopitinoe, itea ako itúkokonoke yûho. ");
INSERT INTO terNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Koánemaka ne íhaehiko Nínivi, hanekóxonomo xapákuke ne xanéhiko apêti kó'oyene yaneko káxe yuhaíkapa Itukó'oviti ne xanéhiko. Exepúkotimo neko íhaehiko Nínivi exókoatimo pahúnevo ra xanéhiko apêti kó'oyene, vo'oku enepone íhae Nínivi, kamoné'e yuho Njóna koyúhoti emo'u Itukó'oviti mekúke, ikótivexoa isóneuke ne váherevoko koane kuríkopahiko. Yoko anéyene kó'oyene koati payásoti ya Njóna, enepora yuhó'ixopitinoe, itea ako itúkokonoke yûho. ");
INSERT INTO terNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ina koe'íkomaka ne Jesus: —Ako ihúxoti yúku koúhapu'ikope he'onó kixoâti xoko ákoyeaku iyúsea. Ákomaka xovopu'í íxa ya sésta, itea hane ímoa xoko koati imókonoku kouhápu'ikopeti motovâti ínixea koêkuti urúkovati ne ovokúti. ");
INSERT INTO terNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kuteâti koêku yúku kouhápu'ikopeti, énomone koéneye ne yûke kexé'uke. Itukovo únati ne yûke, uhapú'itike yóvoheixo. Kene hákoti unâti ne yûke, hahákutikemo yóvoheixo. ");
INSERT INTO terNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yokómoma koêku ne mani uhapú'iti xikóyoke, enepone mani kouhápu'ikoti iséneu, mará'inamo itúkapu hahákutike imópi. ");
INSERT INTO terNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Enepo itukapu ainóvoti uhapú'iti apê xikóyoke, ákoti óvaku kali hahakú koyêtiya, ainóvotimo uhapú'itike yóvoheixo kuteâti koêku kouhápu'ikopeti koati xúnati uhápu'iyea kouhápu'ikopiti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Uke'éxone koyúhoyea ne Jesus, ápe farîzeu itaíkoati nikóponea óvokuke. Urúkovane Jesus óvokuke ne farîzeu, ivátakone xe'o mêsa. ");
INSERT INTO terNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yoko iyúpaxova farîzeu noixôa ákoyea háka Jesus ne kixoku kipóvo'uxeovo farîzeuhiko tumúneke níkea. ");
INSERT INTO terNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ina kixôa Vúnae Jesus neko farîzeu: —Itínoe farîzeu, kutí kénoe xâne kókoyuse kixoíxoti kipó'ikea enovópeti yoko ûto meúkeke, itea kúveuke koati ênoti ihómuyo. Énomone kénenoeye koêku itúkeovo ainóvoti váhere koekúti ovâ ne iséneu, koane usó kéyeyi yaúpu'iki po'ínuhiko xâne, kutí koeti hi'ixîti ítukevo motovâti kirí'uxi apeínopiti. ");
INSERT INTO terNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Itínoe xâne ákoti isóneu. Haina póhutine koekútihiko noíxone po'ínuhiko xâne ivávako ne Itukó'oviti, itea koati ivavákotimaka ovoti isóneuke xâne. ");
INSERT INTO terNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Itúkapuikopo ovoti iséneuke iké'iparaxo Itukó'oviti, yane sasá'itimo uhá koeti kixeku itíkivo. ");
INSERT INTO terNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Koati kotívetimo kêku, itínoe farîzeu. Kaná'uti ápeyea íperaxoke Itukó'oviti, hexakínoati póhuti yane uhá koeti yehí koeti ítikevo perêxo ndîzimu. Muhíkinova ne kálihunoe neóne xe'o yóvoku kuteâti otélam yoko âruta koane po'ínuhiko neóne kuteâti, peréxomaka ndîzimu ya koêkuti yé'akeye yêho. Itea enepone itíki ponóvoti koekúti koane ákoyea omótovo yokovo Itukó'oviti, ákonoe itíka. Yoko énomone itukóvoxo koâti nékone itíki, ákotimaka kurí ixêa itíki ne po'ínuhiko koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Koati kotívetimo kêku, itínoe farîzeu, vo'oku iti yómoti ivátakea xoko ivatákokuti ya nonekútike xoko ivátakoku koati payásotihiko ya íhikexovokuke hé'e. Epó'oxo enepo yihoíkokono koêku víki ya none ovokúti, koati yáhatimaka yéxikono itíkivo teyonéti. ");
INSERT INTO terNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Koati kotívetimo kêku, itínoe kutí koeti poké'e ekóxokonoku ivokóvoti, ákoti iyusêa ápeyea ekoxóvatiya. Vekôa xâne oúkeke, ako éxa ápeyea imuyúkoti opékuke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ina kíxo Jesus ne po'i ihíkaxoati ne Ponóvoti Kixovókuti yútoe Muîse: —Ihikaxotí, koêku kíxineye yihó'inoa ne farîzeuhiko, kotívetinovimaka, uti ihíkaxoti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yane hara kíxoa Jesus: —Keáne itínoe ihíkaxoti yútoe Muîse, kotívetimakamo kêku. Vo'oku yane ênoti ihíkauvoti íhikexone, kutí koe ikeínoxoti po'ínuhiko xâne êno ínati koekúti ákoti itâ koínoyea. Ákomaka kalíhuina yónea iséneu keínoyi póhuti kali koekúti yane íkeinoxike po'ínuhiko xâne. ");
INSERT INTO terNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Koati kotívetimo kêku, vo'oku kéxepuki katátumbana porófeta, enepohikone koyúhoti emo'u Itukó'oviti mekúke, koépeu yoxúnoekene. ");
INSERT INTO terNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yane kixeku itíkivo, koati keyuhópovoti kutipasí kó'iyea iséneu ne isóneu yoxúnoekene vo'oku kíxoaku ne porófetahiko. Koati énomonehiko koepékoa, ina kino'ókonoe kexépukinoati katátumbana ne koépeuhiko, kutipasí keâti ne váhere ítuke yoxúnoekene. ");
INSERT INTO terNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Énomone kó'ino ne Itukó'oviti yane hána'iti kó'exoneyea xoko kó'iyeaku: “Mbahukínoatihikomo porófeta koyúhoti emó'um xapákuke, koánemakamo ápostulu, po'i mbáhoenoa, itea koepékotihikomo po'ínuhiko mbáhoe, koane ikoítoponoatimo kotíveti ne po'ínuhiko” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Énomone kutí'inoke yoneâtimo oúkeke ra xanéhiko apêti kó'oyene ne itina heú koeti porófetahiko koépeuti ukeátine inâ turixóvo ra mêum, ");
INSERT INTO terNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ukeâti kaxénake koépekeokonoku Âmbeu tukú koeti kaxena koépekeokonoku Nzakâriya, enepone koépeuti ukeâti ne hána'iti imokóvokuti yonoti xoko áta yane kíndanake hána'iti imokóvokuti. Aungópatimaka ngíxeopinoe: Oúke ra xanéhiko apêti kó'oyene yóneamo itína uhá koetíhiko neko koépeuti. ");
INSERT INTO terNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Koati kotívetimo kêku, itínoe ihíkaxoati ne Ponóvoti Kixovókuti yútoe Muîse, vo'oku itínoe kutí koeti omó'ixoati ne xáve poréxoti xâne éxea ne kaná'uti exóneti íhae xoko Itukó'oviti, itea ako iké'itukexa, epó'oxo itopó kíxea ne po'ínuhiko xâne kaha'âti éxea —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ipuhíkopeane Jesus, koati imaíkinovati éskiribahiko yoko farîzeuhiko, koane opósi'okeovahiko ya épemo'ikeake. Ako tôpi kíxoaku yuhó'inoahiko, kaha'aînoti Jesus pahúkeovo ya yumópope. ");
INSERT INTO terNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Koati kuxoâtihiko ápeyeamo koêkuti yuho Jesus kutí'inoke motovâti koyúhoyeahiko itúkeovo pahukóvoti. ");
INSERT INTO terNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yoko koati yupihóvotine êno xâne ho'uxo-ho'uxó koetíne koane ókonuhevekexeokoko. Yane turíxovone íhikaxea ne Jesus. Íhikauhiko ínuxo íhikaxea. Hara kíxovokoxoa: —Neíxipa ne kutí koeti kohiyákopeti pâum, ánahixope farîzeuhiko, ákoti oríko ukóponea xapa po'ínuhiko xâne, enepone kutí kó'iyea koati sasá'iti ya po'ínuhiko xâne koeku enó'iyea ítuke ákoti aunáti. ");
INSERT INTO terNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","—Ako kixovókuti pikonéti éxeokono kó'oyene ákotimo kaurápu'ikakana. Koánemaka ne he'onó'oeti kó'oyene, kóyeanemo urápu'iyea. ");
INSERT INTO terNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Vo'oku uhá koeti he'ono'ú kíxene keyúhoyi, kóyeanemo koûrapu'ikeokono xapa xâne. Koánemaka ne koekúti hahaa kíxene keyúhoyi kúveuke yóvoku, kohonókokonotimo koyúhoyeokono, kutí'inokemo exoâti uhá koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Itínoe íningone, hara ngixópinoe kó'oyene: Hákonoe píke xâne motovâti koépekeopi, vo'oku poéhane kexé'u íto koépekea, yane ákone xunáko itúkea po'i koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Itea énjakapivo nékone tíyi, énomone ne Itukó'oviti apêti xunáko koépekeopi koane iyónopeopi ipihóponovokutike. Ngáyukoa ngíxeopinoe: Itúkapu énomone tíyo. ");
INSERT INTO terNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Ákoikopo akávanevo singu koeti kálihunoe hó'openo ôti ya kali pi'âti pe'u tiûketi ákoti axu'ína ovâti? Itea ako kalíhuina ápeyea xapákuke nê'e ákoti exêa koêku Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Muhíkova híyeu tiûti, éxoa Itukó'oviti yé'akeye. Hákoikopo píke, vo'oku itínenoe yupihóvo itóponone nonékuke Itukó'oviti yane ênoti hó'openo ôti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ina kixovókoxopaikomaka Jesus: —Koati ngixópitinoe: Uhá koeti xâne koyuhoâti nonékuke po'ínuhiko xâne itúkeovo hokónuti, kúteanemakamo ngíxoaku nê'e nonékuke ánjuhiko ya vanúkeke. Ngoyuhoâtimakamo itúkeovo hokónuti, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Itea enepone koyuhoâti nonékuke xanéhiko ákoyea itúkapu hokónuti, ngoyuhópatimakamo nonékuke ánjuhiko vanúkeke ákoyea itúkapu hokónuti. ");
INSERT INTO terNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Áva xâne vaheréxinonuti emó'u, apêtikomo oxéne itúyopea pahúnevo. Itea enepone xâne koyuhoâti itúkeovo váhere ne ítuke Sasá'iti Omíxone Itukó'oviti, ákonemo itúyopeaku ne pahúnevo. ");
INSERT INTO terNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Enepo yamakánanoe yíhoikikono ya íhikaxovoku hó'e xanéhiko, koane nonékuke pahúkotihiko yoko po'ínuhiko payásoti tuti xanéhiko, hako pipokéxinoa iséneu ne kixékumo yimópike koane koêkumo ne yiûho, ");
INSERT INTO terNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","vo'oku yaneko ôra, ihíkaxopitinoemo Sasá'iti Omíxone Itukó'oviti nékonemo keyúhoyi nonékukehiko —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yane apé koéne hóyeno xapákuke neko êno xâne kixoti Jesus: —Ihikaxotí, pehúka ne mbo'ínu haxákeana ne apeínoati kûreinovike haíkene ûti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ina kixôa Jesus: —Hoyenó, undí'ikopo yúhoikovoku xâne? Haina indúkovoke nzaxákeokokoa ne xâne kûreinoa haíkene —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ina kixovókoxopaikomaka Jesus neko êno xâne kamokénoati: —Yokóhiyanavoa ne uhá koeti kó'iyeovoku koekúti íyekovoke, enepohikone mani ixómoinoke ipúpakinoa iséneu keha'âti kurí'uxeovo apeínopiti, vo'oku haina énomone ápeino ne xâne yara kúveu mêum —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ina itukínoahiko Jesus íhokoake ne âha íhikaxea. Hara kíxovokoxoa: —Ápe hóyeno iríku, ênoti pôreu ha'i nóne isáneke. ");
INSERT INTO terNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ina koe isóneupinovo: “Námeamo ngíxoaneye ra êno ha'i nónem? Vo'oku ákone iyónoangu”. ");
INSERT INTO terNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ina koepómaka isóneupinovo: “Énjoa ngíxoakumo. Ngatahíneatimo ra unákovoku ha'i nónem, ínamo indukápa koati hána'itiya. Énomonemo unángoa ra ha'i nónem, koáne ra uhá koeti apeínonuti. ");
INSERT INTO terNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yane ínamo angôe: Êno apeínonuti ngoúnae. Ákomo malíka yónoku. Kó'oyene, poéhane ómomingea, níngea, énoyeovom yoko elókeyea ongóvo, ngoetímo.” ");
INSERT INTO terNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Itea hara kíxoa Itukó'oviti: “Iti koati ákoti isóneu. Kó'oyene yara yóti, ivekóvotinemo. Kutí'ikopomo itópoinopi uhá koêti ne apeínopiti yúnahiu?” kíxoane Itukó'oviti —kôe éxetina Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ina koe'íkomaka ne Jesus: —Koati énomone koéneye ne xâne yuixóvoteoxo kurí'uxea apeínoati yara kúveu mêum, itea ako apeínoati xoko Itukó'oviti —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ina kixovókoxoamaka Jesus ne íhikauhiko: —Énomone ngixínopinoe ákoyea ixomo ipúpakina iséneu kixékumo kêku itukovo káxe, ukínopikumo nîke, koane nókone kexé'u, yoko kixékumo iké'ipovoxopivo. ");
INSERT INTO terNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vo'oku enepone kéyeku itukovo káxe, haina pohúneti níki, koane hainámaka pohúneti iké'ipovoxopivo yápeino. ");
INSERT INTO terNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ivévakapihi ne hó'openohiko ôti. Ako nâ, koane ako ítixeaku ha'i nóne. Ákomaka unákoku nîka, koane ákomaka óvoku ítixoku êno nikokónoti, itea kóyeane poréxea Itukó'oviti nîka. Ákoikopo yéxa itúkeovo itínoe yupihóvo itóponone yane hó'openohiko ôti? ");
INSERT INTO terNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ako ápahuina ya xepákukenoe itotimo koúkoponea kaxena âvoyeani ivákapu, yusíkoti yupíheovo kahá'ayea koúkoponea. ");
INSERT INTO terNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Neíxoaneikopo, koêku ákoyea ite itíki kalîhuti koekúti, ná'ikopo koeti ixómoino yónoheixoa iséneu ne po'ínuhiko koekúti? ");
INSERT INTO terNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ivévakapihimaka koêku payá'iyea ne koati uhé'ekoti hîu ne itunoêvoti ya mêum, enepone iháxoneti humanévoti. Ako hûka kuteâti xâne, koane ákomaka ixúxuka, itea koati ngixópitinoe: Muhíkova neko uhá koeti úhe'ene nâti Salúmaum, enepone hána'iti iríku mekúke, ako itápana úhe'ene hîu ne itunoêvotihiko íhae mêum. ");
INSERT INTO terNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Katarákoapo Itukó'oviti ne itunoêvoti íhae mêum, mapini póhutine kó'oyene ápeyea, ihârotike oro'ókokonotinemo yúkuke, ínapomo hako katarákopi Itukó'oviti, itínoe xâne ôriti kúveova. ");
INSERT INTO terNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hákonoekopo ixomo yonóheixoa iséneu úkeakumo ne nîke koane yêka. Hákomaka kenóko'inoe vo'ókuke ra koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vo'oku koati énomone yónoheixo isóneu xâne ákoti êxa Itukó'oviti ya uhá koeti óvohikoku yara kúveu mêum. Yoko éxoa Yá'a íhae vanúke kénokinoe uhá koêti ra koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Inúxotike ya uhá koêti, hane itíka yónoheixoku iséneu ítuke Itukó'oviti, yane kousókinopeatimo Itukó'oviti ne po'ínuhiko nékone —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ina kixovókoxopaikomaka Jesus neko íhikauhiko: —Itínoe hokónuti, itínoe kutí ngíxone kálihunoe su'ûso ákoti axu'ína ikéneke koyonoâti, hákonoe píke, vo'oku koati ahá'inopinoe Yá'a íhae vanúke itíkivo xanéna koane yenópi vanúke natíxokuke. ");
INSERT INTO terNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Enepone apeínopiti, yakávanea, koane pêrekexamaka xâne ákoti apeínoati ne ésa'i. Yane apêtimo íhaku tîketina ákotinemo ipúpa'ixeaku, koane enómakamo apeínopiti ákoti uké'eyeaku vanúkeke xoko ákoyeaku itápana ómevoti, koane xoko ákoyeakumaka kálihunoe hó'openo nikóheati. ");
INSERT INTO terNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vo'oku koêkuti yunákoaku ne apeínopiti, itukapu vanúkeke, áko'o itukapu poké'eke, énomonemakamo yónoheixo iséneu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ina koe'íkomaka Jesus: —Itíkapu xâne usó koyêti kuteâti koêku xâne iyukovó koyêti, ko'ipovó kixoíxotimaka ípovo, koane ihuvé koyêtimaka yukúna aukápapu kúxoixopone. ");
INSERT INTO terNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kutí yákoyenoe ahinoêti ixómoti noimé'exopo seópope pátarauxa ukopeâti áyuike kasâtuxoti. Seopóne pátarauxa, enepo ipusókopo pahapéti, usó kóyepone ahínoe míhe'okopinoa. ");
INSERT INTO terNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Koati únatimo koêku ne ahinoêtihiko inú'epo pátarauxa ixómoti noimé'exopa. Koati emo'úti ra yunzó'inopinoe: Itukovó koetimo koati pátarauxa silo'íxopomo ípovo ko'ítukeyea. Yane kavátahikoatimakamo neko ahínoe xe'o mêsa ominoâti nîka. ");
INSERT INTO terNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yusíkoti itúkeovo ya kuku yóti, áko'o ya mâturukata seópea ne pátarauxa, koati únatimo koêku neko ahínoe inú'epo ixómoti noimé'exopa. ");
INSERT INTO terNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Koati endó'okopitinoe koêkumo: Eneponi exâ únae ovokúti orana símope ne ómevoti, mani koyonoâti ne óvoku, ákoni síka ûrukeova ne óvoku. ");
INSERT INTO terNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Keánenoemaka, neímexa ne aúngopovopemo, undi íhae vanúke ikútipasikoponovoti xâne, vo'oku ya koati ákoyeakumo kixápanu, énomonemo aúngopeovo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ina kixôa Pêturu ne Jesus: —Unaém, enepora yéxetina apêti íhokovoke, koati utíne itíkinoa? áko'o uhá koetímaka xâne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ina kixôa Jesus itukínoati po'i íhokoake: —Kutí'ikopomea itukóvo kuteâti ne ahinoêti koati yuixóvoti ítukexeokonoke, koane ponóvoti isóneu ítukeke? Énomone neko poréxoakemaka pátarauxa éxea koêku ne po'ínuhiko ahínoe, motovâti koúsokinoa nókone koatíke kaxénaxeokonoke. ");
INSERT INTO terNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Koati únatimo koêku ne ahinoêti inú'epomo pátarauxa kíxeaneye ko'ítukeyea aukápapu. ");
INSERT INTO terNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Koati endó'okopitinoe koêkumo: Kuri'ó kixoâtimo pátarauxa kóyoninoa uhá koeti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Itea enepo akôe isóneu ne ahinoêti: “Yupíhovane xu'íkeneyea ne mbátarauxa” akôe, ina turixápu yehépoke'exea ne po'ínuhiko ahinoêti, ha'íne, koane yuíxeovo níkea, énoyeovo yoko kohíhiyea, naíxapu nê'e. ");
INSERT INTO terNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Vo'oku seopó koetímo pátarauxa ya káxe koati ákoyeaku kuxápa, koáne ya ôra ákoyeakumaka éxa káyukopeovomo. Yanê'e, koati kotívetimo kíxoaku pátarauxa ipihápana. Iyonópatimo xoko iyónopoku xâne ákoti akutípo. ");
INSERT INTO terNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Enepone ahinoêti exoâti ne ahá'inoa pátarauxa, itea ákoti usó akóye koúsokea, ákotimaka itukêa ne âha, koatimo xúnati yehépoke'exeokono ipihápanakana. ");
INSERT INTO terNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Itea enepone ákoti exâ ne ahá'inoa pátarauxa, yusíkoti váherexea ítuke koane motókeyea xu'ínayea ipíhoponeokono, itea ákomo áxuna kíxoakumo pátarauxa yehépoke'exea ipihápana. Vo'oku enepone xâne ênoti pónekonoke, konokoâti enó'iyeamaka únatinoe koekúti ítuke, pôreupo vo'oku enó'iyea pónekonoke. Kúteanemaka koêku ne xâne xu'ínati ípara, koati konokoâti enó'iyea pôreupo anu'úkopati ne yé'akeye pónekonoke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ina koe'íkomaka ne Jesus: —Enepone nzímea yara kúveu mêum, ínzokoa yúku oro'ókoti, yoko ehá'ani turíxeovone kó'iyeaneye. ");
INSERT INTO terNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Itea anéyeiko kotíveti koekúti véngokuikomo. Koati konokoâti itúkeovo oúngekemo yóno ne êno tiveko koekúti, epó'oxo koati hána'itine tiveko inzóneu koêku âvoyea ndarú'uxa. ");
INSERT INTO terNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ikítixatinoe nzimínoti motó'iyeova úhepeyea isóneunokoko ne xâne yara kúveu mêum? Ákomo ákoeneye. Koati endó'okopitinoe koêku: Apêtimo okopókokoti vo'ónguke. ");
INSERT INTO terNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ukeátine kó'oyene, itukovo apêti singu koeti ko'óvokuti ya póhutike ovokúti, mopó'amo okopâti ne po'i pi'âti, itukovo pi'âti okopâtimo ne po'i mopo'âti vo'ónguke. ");
INSERT INTO terNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kúteanemakamo koeku hóyeno yoko xé'a. Okopâtimo hóyeno ne xé'a, áko'o itukovo xé'a okopâmo ne há'a vo'ónguke. Kúteanemakamo koeku sêno yoko ihíne. Okopâtimo sêno ne ihíne, áko'o itukovo ihíne okopómo êno vo'ónguke. Kúteanemaka koeku sêno yoko sinéna vo'ónguke, okopâtimo sêno ne sinéna, áko'o itukovo sinéna okopâ ne imóse vo'ónguke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ina kixovókoxopaikomaka Jesus neko êno xâne: —Enepo neixónoe kapási ukeâti kíyo'i káxe, “Úko rakéne” kénoe. Koáne, kevó'oxo. ");
INSERT INTO terNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Koáne enepo sa'irí'okovo ne ihunóvoti, neixoâtinoe ne úkeaku, “Kotúpotinemo” kénoemaka. Koá'axo, kotúpo. ");
INSERT INTO terNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Itínoe ikútixapovoti koati ko'éxoneti, é'exo kíxeanoe koêku ra mêum koáne ra vanúke, koêku kahá'ayea kévea koane kotú'iyea, itea inípono ákoyea yéxa itukóvotiye ra káxehiko símokune ûti. ");
INSERT INTO terNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Manímaka konókoti yéxinoe péni iséneunoa ra koekútihiko! —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ina koe'íkomaka: —Itukovo apêti évotikopike po'i xâne, ina omôpi yuhoíkovokutike, ya koêkuiko yéni, tumúneke sími yuhoíkovokutike, yapásika kíxeaku unátipinokoko iséneu, maka hákone iyonópi nonékuke ne pahúkoti yuhoíkovokutike, vo'oku mani kurikópiti nê'e xoko pulísea. Kene ne pulísea, mani kurikópiti ika'ákovokutike. ");
INSERT INTO terNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Enepo akoéneye, koati ngixópiti ákoyeamo ipíhikapi koêku ákoyea peréxapa uhá koêti ne yoréveu —kíxovokoxoane Jesus, exókoatihiko kónokea épemea Itukó'oviti kotúyopinoa pahúnevo tumúneke seópea nonékuke. ");
INSERT INTO terNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Koati énomone yaneko koyúhoyeaku Jesus, apé koéne xanéhiko simoâti, koyuhó'inoati koêku ne íhaehiko Ngalíleya, koépeu Pilátu, itúkeovo isúkotihiko hó'openo, ikó'iparaxoke Itukó'oviti, yaneko koepékokonone. ");
INSERT INTO terNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ina kixoáhiko Jesus: —Ikítixatinoemea koati yupihóvoti váherevoko ya po'ínuhiko xâne íhae Ngalíleya nekôyohiko vo'oku kixókonokuhiko koépekeokono? ");
INSERT INTO terNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ako kalíhuina kó'iyeaneye. Koati ngixópitinoe: Enepomo hákoti iketívexoa iséneuke ne pehúnevo, koane hákotimaka kirikópa, koati kotívetimakamo kixékonoku ya hunókokuke. ");
INSERT INTO terNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kene neko dizoitu koeti ivokóvoti ya Silôe íkoro'uxovone neko éyevoti péti vanúkeke koexépoeti, pe'okoâtinoemea itúkeovo koati yupihóvati váherevoko ya uhá koeti po'ínuhiko xâne íhae Njeruzálem? ");
INSERT INTO terNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Koati ngoyuhó'inopitinoe: Enepomo hákoti iketívexoa iséneuke ne pehúnevo, koane hákoti kirikópa, koati kotívetimakamo kixékonoku ya hunókokuke —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ina itukínoahiko Jesus íhokoake ne âha íhikaxea. Hara kíxovokoxoa: —Ápe hóyeno apêti xuve fîgu xapákuke xuve úva nóne. Po'i káxe opósikoponea há'i yane xúve itea ako êho. ");
INSERT INTO terNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yane ina kixôa neko koyonínoati ne nóne: “Mopó'ane xoénae ixomo ombósi'ixoponea há'i râ'a, itea anéyeiko âvoyea ênjo. Titúkane kó'oyene, vo'oku ovohí koâti ra poké'e koêku ákoyea pôreu” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ina yumopâ ahínoe: “Síkeavone yara xoénae. Imbanó'ekoatikomo, ínamo imbíhina katamú'ikoati. ");
INSERT INTO terNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yane enepo parêxa há'i, únatimo. Kene hákotimo, pehúkanemo tetúkeovo” kíxoane —koéne éxetina. ");
INSERT INTO terNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ya sâputu, káxe koati sasá'iti xoko evo jûdeu, ixómoti ihíkaxo ne Jesus ya íhikaxovoku hó'e jûdeuhiko. ");
INSERT INTO terNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yane simóne sêno ka'aríneti. Dizoitu koetíne xoénae ixomo iká'arinexoa ndémoniu. Yupíhovone itipu'í kó'iyea vo'ókuke, ákone ita ponópeovo. ");
INSERT INTO terNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Noixoâne Jesus, iháxikoane ina kixôa: —Senó, ítivoane ra yaríne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yane ípiho vô'u Jesus muyókuke. Ehá'axo kíxoaneye, ponópovone koxé'u neko sêno. Yane yupihovó koéne iháyu'ikea Itukó'oviti neko sêno. ");
INSERT INTO terNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Itea ímaikovo ne inuxínoti itukéti yane íhikaxovoku hó'e jûdeu, vo'oku koíteova Jesus ne sêno ya sâputu. Hara kôe: —Anéye sei koeti káxe motovâti ko'ítukeyea ne xâne. Énomone síminoe ítivoa ne yaríne, kene ako yusíka itúkeovo ya sâputu, káxe koati sasá'iti hó'eke ûti —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ina kôe ne Vúnae: —Itínoe ikútixapovoti koati sasá'iti ya po'ínuhiko xâne, ákonikopo kíxeapananoe ne píyo vûi, itukovo píyo juméntu xoko ómomikoku íyikoponi úne ya sâputu? ");
INSERT INTO terNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ina keno'óko ra sêno, koati ámoripono Âbraum iká'arinexone Satánae dizoitu koetíne xoénae. Ná'ikopo koeti ákoino omótova íteova ya aríne ya sâputu? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Uke'éxone koyúhoyea Jesus, teyó koénehiko neko uhá koeti okopâti, itea yupíhova elókeyea okóvo ne po'ínuhiko jûdeu vo'ókuke uhá koêti neko ihayú'iuti ítuke Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Háramaka koe íhikaxea ne Jesus: —Kutimea koéneye ukóponea ne natíxea Itukó'oviti xapa xâne? Kutimea ínzokoa? ");
INSERT INTO terNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hara koéneye kalîhuti ake nonéti, enepone iháxoneti mostarda enepo nôa hóyeno ya isáneke. Ihonópone, paya'ínemaka, itúkovone xuve tikóti. Yane itúkotine môko ne hó'openo ôti káva'oke —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ina koe'íkomaka ne Jesus: —Kutimea ínzokoa kixoku ukóponea ne natíxea Itukó'oviti xapa xâne? ");
INSERT INTO terNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hane koéneye kohiyákopeti pâum veínoake sêno ánahixea mopo'âti ihíxopeti tirîku. Ehane heú kíxoa kohíyakea ne tirîku —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Koêku yónea ya Njeruzálem ne Jesus, koane íhikaxea emo'u Itukó'oviti yane pitivókohiko yoko ipuxóvokutihiko vékoku. ");
INSERT INTO terNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yane ápe xâne kixoti Jesus: —Unaém, ákomeamo axú'ina ne xâne koítovone Itukó'oviti yonopâti xokóyoke? ");
INSERT INTO terNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ina yumopâ Jesus, itukínoati íhokoake. —Kéxuna'ixapunoe víki ne kutí koeti kalíkuti pahapéti. Koati ngixópitinoe: Enómo kaha'âti vékea itea ákomo íta —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ina itukínoamaka po'i xêti, íhokopovoke, koane íhokoake ne xâne ákotimo urúkapapa ne natíxoku Itukó'oviti vanúkeke. Hara kôe: —Exepúka ne únae ovokúti, exexápane ne pahapéti, itukapu meúkeke yovó'ikonoe ixómoyea ipísoko pahapéti ké'iyi: “Unaém, míhi'akinavea ne pahapéti” ké'iyi, yane haramo kixópi: “Hainánoe iti ovónje” kixópitinoemo. ");
INSERT INTO terNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ínamo ixeánoe: “Kahá'inepipepo ûti xe'o mêsa óvoku nikokónoti yoko ekâti yanekôyoke, koane koati vípuxovokuke íhikexopepo” kixeâtimo. ");
INSERT INTO terNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Itea haramo koépomaka yuhó'inopinoe únae ne ovokúti: “Ako énjapinoe. Yahíkuxipunu, itínoe itúkoti váhere” kixópitinoemo. ");
INSERT INTO terNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yane neixoâtinemo ne Âbraum, Izáki koane Njáko ya natíxokuke Itukó'oviti, koánemaka uhá koetíhiko ne páhoe Itukó'oviti koyúhoyea emó'u mekúke, itea kirikókonotinemo meúkeke yane natíxokuke Itukó'oviti. Yoko enómo iyókexoti yoko ngarutútukexoti ôe vo'oku hána'iti tiveko koeku xâne xoko yenópoku. ");
INSERT INTO terNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Enómo xâne ivatákopotimo xe'ókuke mêsa ya natíxoku Itukó'oviti ukeâti ya uhá koêti ra kúveu mêum, xoko úkeaku ihâroti, yoko xoko íyeu kíyo'i káxe, koane xoko úkeaku kásati, yoko xoko úkeaku ihunóvoti. ");
INSERT INTO terNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Apêtimo xâne ákoti apayáso ovoti ikenétike koêku kó'oyene itukóvotimo koâti teyonéti ya po'ínuhiko xâne yaneko káxe. Kene xapákuke ne teyonéti koêku kó'oyene, apêtimo okópoti koati ikenétike —koene Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Koêkuiko koyúhoyea ne Jesus, ápe farîzeuhiko kixopónoati: —Hákone yovóheixo yâye. Ipíhikapi râ'a, vo'oku kahá'ati koépekeopi ne Êrodi —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Itea hara kíxoa Jesus yumópeahiko: —Yéta'akapana ne Êrodi, enepone kutí koeti éxeako úkoe, ngópuhikopeakomo ndémoniu xoko xâne ûroevo, yoko ngoíteovoikomo ka'aríneti kó'oyene yoko ihârotike. Yane mopó'apeke káxe, unzéxotinemo índuke. ");
INSERT INTO terNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ngonókotiko ungóponea ya po'íkehiko pitivóko kó'oyene, koane ihârotike, yoko po'íke ihâroti, motovâti nzímea Njeruzálem, vo'oku ákomo po'i koépekokonoku porófeta koyúhoti emo'u Itukó'oviti, ákoti itukapu ya Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ina koe'íkomaka ne Jesus: —Imáko ké'iyivoku, itínoe íhae Njeruzálem. Aínovonoe iti xâne yómoti koépekea porófeta koyúhoti emo'u Itukó'oviti. Aínovonoemaka iti koépekenati ovoxe Itukó'oviti páhoe xepákukenoe, hipokoâti ya mopôi. Kuteâti kíxoaku tapî'i ho'úxea ne xe'éxaxapa opékuke kêvi, mani ngaha'âtimaka ngíxeopineye kuteâti, itea ákonoe yakáha'a. ");
INSERT INTO terNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yara kuteâti kêkunoe, ákonemo ovâti ra yóvokunoe. Koati emo'úti ra yunzó'inopinoe: Ukeátine kó'oyene, ákonenoemo neíxapanu tukú koeti yaneko káxe ké'iyikunoemo: “Viháyu'ika ne páhoenovi Vúnae Itukó'oviti, enepone keno'ókoti ya iháke Itukó'oviti” yakoénoe —koéne ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Po'íke sâputu, pîho Jesus nikóponea óvokuke farîzeu. Yoko koati teyonéti neko hóyeno xapákuke po'ínuhiko farîzeu. Enepone xanéhikoya, koati komómoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ápemaka hóyenoya momo'ópixoti. Koati nonékuke Jesus óvoheixo. ");
INSERT INTO terNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ina kixovókoxoa Jesus ne jûdeuhiko ihíkaxoti yútoe Muîse, yóko'o ne farîzeuhiko: —Yane Ponóvoti Kixovókuti hó'e ûti, poréxovi koíteovo uti xâne ya sâputu? áko'o ako paréxavea —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Itea yunuku-yunukú koénehiko. Ina namu'ókoa Jesus neko hóyeno, yane koítovane, ina porexôa pihópea. ");
INSERT INTO terNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ina kixovókoxopamaka Jesus neko xâne: —Ínani áva xi'íxa, áko'o vuina îti ikoróno'ekovoti ikokúti. Yusíkotini itúkeovo ya sâputu, ákonikopo yéhaka viyópi? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Itea ákohiko éxa kíxoaku yumópea. ");
INSERT INTO terNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Koêku ixómoyea komóma Jesus ne hupiútihiko koane kixoku noívokoxea haxaéti ivatákokuti xe'ókuke mêsa xapákuke xâne koati payásoti, yane turíxovone itúkinoa íhokoake ne âha íhikaxea. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Enepo iteíkakana niképoni xoko áyui kasâtuxoti, hako neivókoxo ivétakoku ovoti xêrerekuke kasâtuxoti, vo'oku enepo síma koati payásoti ya itíke, ");
INSERT INTO terNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","yane simópitimo ne itaíkopiti, enepone itaíkoatimaka ne po'i simôti, epemópitimo ípekivo motovâti ivátakea ne po'i simôti. Yane hána'itimo tíyapana koêku vatahí képi po'íke. ");
INSERT INTO terNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","—Itea enepo áva itaíkopiti, hane yéna ivétakoponi xoko ivatákokutihiko ákoti itukapu ivátakoku payásoti. Yane enepo pihinápi ne itaíkopiti, haramo kixópi: “Iningoné, hara ivétakapana nonekútike xêrerekuke ne kasâtuxoti” kixópitimo. Yane kuteâti kixópiku, koati kapayásokopitimo nonékuke uhá koeti po'ínuhiko itá'iuti. ");
INSERT INTO terNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—Vo'oku koteyókokonotimo ne uhá koeti kapayásokopovoti. Kene ne ákoti kapayásakapapu, kahaná'ikokonotimo —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ina kixoá'ikomaka Jesus ne itaíkoati: —Enepo áva íte'iu yóvokuke arámusakoponea, áko'o jántaxoponea, hako itukovo ínikenehiko íteiko, itukovo pe'ínuhiko, áko'o itukovo iyínoxapa. Hákomaka iteíko míxone xêrerekuke yóvoku áva iríkuhiko xapákuke. Vo'oku ixeáneye, itaíkopopitimakamo niképoni óvokuke. Yane koati nemukópatinemo ésa'i ne itíkinoa únati ne po'i xâne. ");
INSERT INTO terNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Itea enepo yokoyûi, hanemo íteika xâne ákoti apeínoati, koáne ne apêti isáyunevo poixo'o mûyo, koáne ne mohéveu yoko komítitihiko. ");
INSERT INTO terNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yane koati únatimo kêku, vo'oku ákoyea oxéne ne íte'iu poréxopeopi ésa'i únati ítikeinoa. Itea koati apêtimo némoepo yaneko káxe exépukopeakumo ukópea xapa ivokóvoti ne kasása'iupo Itukó'oviti, enepohikone ponóvoti kixoku itúkeovo —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yoko ápe ha'ine Jesus xe'ókuke mêsa kameâti neko yûho. Yane hara kixo Jesus: —Koati únatimo koêku ne xâne apêti xapa nikaxóvoti ya natíxokuke Itukó'oviti vanúkeke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ina itûko xêti ne Jesus. Hara kôe: —Ápe hóyeno itúkoti hána'iti nikaxóvoti, ênoti húpiu. ");
INSERT INTO terNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Simovóne orána neko nikaxóvoti, pahúkone ahínoe kixóponea neko húpiuhiko yusíkea píheanehiko vo'oku usó'iyeane uhá koêti. ");
INSERT INTO terNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—Itea póhutihiko neko hupiúti, aínovo apêti pó'onexeovoke. Hara kíxoa inúxoti yumopâti: “Apêti poké'e inámati váneum. Koati ngonokoâtiko noínjoponea. Yokóseananu, yéta'akapinanamo ne pétarauxa ákoyeanemo omótova mbíhea” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—Ina kixôa po'ínu: “Apêti singu koeti vûi ka'apénekokoti, váneum, yoko ngonokoâtiko nzixópea. Yokóseananu, yéta'akapinanamo ne pétarauxa ákoyeanemo omótova mbíhea” kíxoanemaka. ");
INSERT INTO terNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—Ina koemáka ne po'ínu: “Ínati ngoyêno. Ako omótova mbíhea” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Aukópovo ne ahinoêti xoko pátarauxa, heú kíxoa koyúhopinoa uhá koêti neko koekúti. Yane yupíhova ímaikinovo xanéhiko húpiu neko únae ovokúti. Ina kíxo ahínoe: “Yéhakapu, pihéne ya uhá koeti none ovokúti ya pítivokona ûti, ya koêkuti xe'o ovokúti vékoku xâne. Víyahikapana ne xâne ákoti apeínoati koáne ne isayú'ixovoti poixo'o mûyo, yóko'o ne komítiti, koáne ne mohéveu” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","—Koane pihóne. Ikénepoke, hara kíxoa ahínoe: “Unaém, indúkoane ne péhoenonu, itea anéyeiko ivatákokuti” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—Ina kixôa pátarauxa: “Yéhaka víki ya none ovokúti koáne ya kálihunoe xêne. Koêkuti tekópone, pehúka yâkeneye maka ipúhikane ra óvongu. ");
INSERT INTO terNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Koati ngixópitinoe: Ákomo ápahuina xâne xapákuke neko inúxotihiko nzúpiu mboréxeakemo níkea ra nikokónoti ngoúseune” koéne —koe éxetina Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yoko yupíhova êno xâne hokó'ixoti Jesus koêku yónea. Ina inonéxinova Jesus, hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Uhá koêti xâne kahá'ati hókeonu, konókoti itúkeovo ûndi ako omótovoxo okóvo ya uhá koêti, ínati yusîko itúkeovo ínzikau. Ako yusíka itúkeovo há'a, êno, yêno, xe'éxaxapa, itukovo po'ínuhiko ako omótovoxo okóvo ya undíke, muhíkovamaka unako koêku yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Koáne enepone xâne ákoti usó akóye koítoponeovo kotíveti koêku hókeonu, ákotimaka akahá'a kutí kíxeovo xâne koínoti kurúhuna iyonókono xoko kurúhuxokonokumo, ako yusíka itúkeovo hokónuti. ");
INSERT INTO terNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Konókoti itúkinoa isóneu xâne inúxotike íteamo hókeonu, áko'o ákoyea, kuteâti koêku áva xepákukenoe kahá'ati koéxepukea éyevoti péti vanúkeke. Ako yusíka itukó kíxea, ákoti itukína isóneu yé'akemoye ésa'i ovâti inúxotike. Konókoti ivátakinoa okóvoxea yé'akemoye ésa'i inúxotike, noixoâti motó'iyeovamo ne tiûketina. ");
INSERT INTO terNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vo'oku eneponi uke'é akôe tiûketina, póhutikone poéheve úsexo, ákotineni omotóva úsexea hâxa, yane mani koemóke'eati uhá koeti xâne noixoâti ");
INSERT INTO terNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","koáneni kíxeokono: “Enepone hóyeno, pohu turí kixo ítuke, ako úsexa” mani kixokónoti. ");
INSERT INTO terNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Kúteanemaka koêku xoko nâti. Ákoni pihó ákoe okótumonexea po'i nâti, anáne, kaha'âti okópea ákoti ivatáka inúxotike, itukínoati isóneu íteamo ya yehí koeti mili húndaruna ne keno'ókinoati okópea omoti vinti koeti mili húndaruna. ");
INSERT INTO terNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Vo'oku eneponi inixâ ákoyeamo íta, ya koêku âvoyea malíka ne anáne, mani apêtimo páhoe xokóyoke epemóponoati nókone itúkea motovâti ákoyea isukókoti. ");
INSERT INTO terNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Keánenoemaka, uhá koeti xepákukenoe kahá'ati hókeonu ákoti usó akóye kuríkea uhá koeti ítukevo, ákomo omótova hókeonu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Koati únati koekúti ne yúki, itea enepo auké'e taú'iko, ákonemo oxéne aúkopinokonoa. ");
INSERT INTO terNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yane ákone itúkovoke. Muhíkova eneponi kurikákana poké'eke xoko nonéti, koaneni anahíxakana isiko hó'openo, ákoni itúkovoke. Poéhane kuríkeokono. Koêkuti kamoâti ra yûnzo, ivávaka —kíxovokoxoane Jesus neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yoko êno koperáxinoti nâti, enepone ánu'ukenati kóperau, koane enómaka xâne pahukóvoti pihôti xoko Jesus, kamokénoponoati. ");
INSERT INTO terNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yane kapáhakinovohiko koeku Jesus ne farîzeu, enepohikone yuixóvoti hókea yútoe Muîse, koáne ne ihíkaxoti yútoe Muîse, enepone éskiribahiko. Hara kixókoko: —Imáko ra hóyeno anahíxovoti xâne pahukóvoti koane iníkoatihikomaka —kixókokone. ");
INSERT INTO terNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ina itukínoahiko Jesus íhokoake ne âha íhikaxea. Hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Ínani áva hóyeno xepákukenoe apêti póhuti séndu su'úsona. Kavu'íxa póhutiya, ákonikopomea kurí íxahiko ne noventai nove koêti ya xoko óvoku kóyonoyea ya mêum, koeku opósikoponea neko moyóniti tukú koeti inixápana? ");
INSERT INTO terNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yane inixápanane, mani yupihovó koeti elókepea okóvo. Mani imó kixopâti povókuke omópea. ");
INSERT INTO terNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yane seapáne óvokuke, mani ho'úxoti ínikonehiko yoko ko'óvokutihiko xêrerekuke óvoku ínani ixâ: “Hivá'axapananu ya elókeko ongóvo, vo'oku íninjopane ne nzu'úsona ivu'íxoti” ákoni íxa? ");
INSERT INTO terNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","—Koati ngixópitinoe kó'iyeanemakaye ne êno elokékoti okovóti ya vanúkeke enepo apê póhuti pahukóvoti ikotívexoati isóneuke ne váhere kixoku itúkeovo, koane epémoti Itukó'oviti kotúyopinoa. Enoné'e elokékoti okovóti vo'ókuke neko póhuti koxe'u xâne yane noventai nove koeti ponóvoti kixoku itúkeovo ákoti okonóko épemea Itukó'oviti kotúyopinoa pahúnevo —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ina koe'íkomaka ne Jesus: —Ínani áva sêno apêti yehí koeti pe'u tiûketina. Kavu'íxa póhuti yane yehí koêti, ákonikopomea íhuxa yukúna, ina kókoyuse ixâ kaúha'ixea uhá koêti ne kúveu óvoku oposíkopati tukú koeti ínixoponea? ");
INSERT INTO terNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Inixápanane, mani ho'úxoti ínikonehiko yoko ko'óvokutihiko oveâti xêrerekuke óvoku, ínani ixâhiko: “Hivá'axapananu ya elókeko ongóvo vo'oku íninjopane ne po'i pe'u ndiûketina ngovú'emeku” ákonikopomea ákoe? ");
INSERT INTO terNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—Koati ngixópitinoe: Énomonemaka koéneye elókeko okóvo ne ánju, enepohikone ovoxe Itukó'oviti ya vanúke enepo apê póhuti pahukóvoti ikotívexoati isóneuke ne váhere kixoku itúkeovo koane epémotimaka Itukó'oviti kotúyopinoa —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ina koe'íkomaka íhikaxea Jesus: —Ápe hóyeno pi'âti xé'a. ");
INSERT INTO terNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Po'íke káxe, hara kixo há'a ne nihí'iti xé'a: “Pai, mani ngaha'âtine peréxinoa ne íkinonuke yane apeínopiti” kíxoane. —Yane haxákoane há'a apeínoati neko pi'âti xe'éxa. ");
INSERT INTO terNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Avo áxu'ikene, kaúnakovo neko homoêhou. Yane ómane uhá koêti ne apeínoati. Úkeane pího po'íke poké'e ákoti malîka. Heu-heú kíxoa komóhiyea neko tiûketina. Koêkuti âha kíxeova, itúkoa. Koati vaheréxoti kixoku itúkeovo. ");
INSERT INTO terNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","—Uke'éxoane heú koêti neko tiûketina, kenó'okone êno hímakati yaneko poké'e. Yane turíxovone ikónoko'ixeovo neko homoêhou. Épekoanemaka hímakati. ");
INSERT INTO terNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Úkeane pího xoko hóyeno íhae neko poké'e oposíkoponoti itukétiya. Yane pahúkoane hóyeno óyonokuke kátarakinoa kuréna. ");
INSERT INTO terNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yâkoxonoye, íyokovane níkea neko nika kûre. Koáhati ákoti porexoâti nîka. ");
INSERT INTO terNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ina itukópinovo isóneu neko homoêhou. Hara koe isóneupinovo: “Enepohikone ko'itúkeinoti nzá'a, aínovo koati únatihiko nîka. Inímbono yâye ngoitóponovoti kotíveti ya hímakati. ");
INSERT INTO terNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngaúnakapapuvo, mbihópotine xoko nzá'a kó'oyene. Ká'aye ngixopâtimo: ‘Pai, koati undi ákoti aunáti kixoku itúkeovo nonékuke Íhae Vanúke koane nenékuke. ");
INSERT INTO terNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ákone omóndokea indúkeovo xi'íxa. Kutí íxepanune yahínoe’ ngixopâtimo” koéne isóneupinovo. ");
INSERT INTO terNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yane koúnakopovone neko homoêhou ina pihôpo xoko há'a. —Avo malíkapa, ínixopane há'a yâkeneye koane yupíheovo kóseanayea. Ina ehakóvo okótumonexopea koáne opóno'ekopea. ");
INSERT INTO terNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ina kíxo há'a neko homoêhou: “Pai, koati undi ákoti aunáti kixoku itúkeovo nonékuke Íhae Vanúke koane nenékuke. Ákone omóndokea indúkeovo xi'íxa” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—Yane hara kixo ahínoehiko neko há'a: “Yéhakapunoe, yámane ne koati únati ipovóti, itíkapina ra nje'éxa. Itíkapinamaka horóxona yoko hapátuna. ");
INSERT INTO terNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Viyápananoemaka ne koati kínati xe'exa váka koane isíkanoe. Vokóyui, aélokenemaka vokóvo ");
INSERT INTO terNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","vo'oku kutí koetine ivokóvoti ra nje'éxa, itea iyúkopovone. Kutí koe ivu'íxoti, itea íninjopane” kíxoane. —Yane turíxovonehiko kóyuiyea. ");
INSERT INTO terNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Yoko mêum óvoheixo ne xuvé'eti xe'éxa neko hóyeno. Ye'éxopone óvoku há'a, kamone êno emo'u oxokénati yoko hiyokéxotihiko. ");
INSERT INTO terNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ina ihaxíko ahinoe há'a epemoâti kó'inokeneye ne koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","—Yane hara kíxoane ahinoêti yumopâ: “Seópotine yâti. Yoko kóyuiti ne yá'a. Pahúkomaka isúkeovo ne koati kínati xe'exa váka vo'oku ákoyea yuvâti ne yâti koeku seópea xokóyoke” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Yane yupihovó koene ímaikeovo xuvé'eti xe'éxa neko hóyeno kamôa. Ako akáha'a ûrukopeovo ovokútike xoko ayuíti. Ina ipuhíkinoa há'a oposíkoati koúhepekopea isóneu. ");
INSERT INTO terNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Itea hara kixo há'a neko hóyeno: “Pai, enóne xoénae ngo'ítukeinopi. Ako anú'ungeaku yemó'u koane koêkuti péhoenonu, indúkoa. Itea muhíkova kali xe'exa váxikita, ako peréxinoaku motovâti ngóyuiyea xapa íningone. ");
INSERT INTO terNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Itea koeku seópea ne xi'íxa, enepone heú kixoti uké'exea apeínopiti yâtikeneye xapa mohîti sêno, ainovó koe énomone itíkino ayuíti. Pehúkoakomaka isúkeovo ne koati kínati xe'exa vakana ûti!” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","—Ina kixôa há'a: “Nje'exá, koati yóvokune yâye njokóyoke. Heú koeti apeínonuti, ítikenemaka. ");
INSERT INTO terNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yoko koati konokoâti kóyuiyea ûti koane elókeyea vokóvo vo'oku enepora yâti, kutí koe ivokóvotine, itea iyúkopovone. Kutí koémaka ivu'íxoti, itea íninjopane” kíxoane há'a —kôe éxetina Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ina kixovókoxoa Jesus ne íhikau: —Ápe hóyeno iríku apêti ahínoe exeâti koêku ne uhá koeti ítukevo. Ina apê koyuhópoinoati yupíheovo évokeovo ya apeínoati vo'oku itúkeovo aúpu'ikenati ne exeâti koêku ne ítuke. ");
INSERT INTO terNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yane pahúkoane iríku iháxikeovo neko ahínoe ina kixôa: “Kaná'uti ra eyéngou ve'óku? Konókoti yéxokinu kixoku koêku ne ítikeinonu, vo'oku ákone omótova yóvi ra itukéti” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Ina koe isóneu neko hóyeno: “Namo ángoeneye kó'oyene? Pahúkoponune ra mbátarauxa. Ako inda indúkea ínati itukéti kuteâti ngo'ítukeyea kavâne. Koane ndêyo indúkeovo épemokenati. ");
INSERT INTO terNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Énjoane ngíxoaku kó'oyene, maka mbahukápakanane aváne íningone usó koyêti óngea óvokuke, ínzuinovokemo káxehiko keno'ókoti” koéne isóneu. ");
INSERT INTO terNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—Yane heú kíxoa iháxihikea neko orevéxeati pátarauxa. Ina kixôa neko inúxoti simoâti: “Na yé'aye yorévexoake ne mbátarauxa?” ");
INSERT INTO terNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","—Ina yumopâ: “Poéha séndu korótina azeite” kíxoane. —“Harâ'a ne koyuhópeti yutóxovoku yé'akeye ne yoréveu. Ivétaka hú koêti, yitaxa sinkoenta koêti” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","—Ina kixoámaka ne po'i orevéxoti: “Kene îti, na yé'aye yoréveu?” —“Poéha mili xákuna tirîku” —kíxoane. —“Harâ'a ne koyuhópeti óvoku yoréveu. Yitáxapa oitu koeti séndu” —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Upánini ákoyea opónovo ítuke neko hóyeno, itea kóyeane iháyu'ikea pátarauxa vo'oku éxea kixoku itúkea isóneu. Ina koe'íkomaka ne Jesus: —Enepohikone xâne yara kúveu mêum ákoti êxa Itukó'oviti, ya xapákuke ne xâne kuteâtihiko, yupihóvone éxea kixoku itúkea isóneu yane hokotíhiko Itukó'oviti ya ítukeke. ");
INSERT INTO terNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Koati ngixópitinoe: Enepone tiûketi, koati kixovókuti íhaene yâye yara kúveu mêum, itea konókoti yéxi iké'itukexi ya únatike, maka enepo simapúne hunókoku kaxena yápeyi yara kúveu mêum, usokó ákoepone íhinovokemo káxehiko keno'ókoti. Énomone neko únatinoe koekúti kuxópitimo ya xoko yenópoku ákotinemo uké'eyeaku. ");
INSERT INTO terNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Enepone xâne motovâti kúveovokono pónea ítuke ya ákotike axu'ína, koati motovâtimaka kúveovokono ya xu'ínatike. Kene enepone ákoti oponóvo ítuke ya ákotike axu'ína, ákomakamo opónovo ítuke ya xu'ínatike. ");
INSERT INTO terNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Enepo hákoti motôvo kívivokono unátiyea kixeku iké'itukexi tiûketi, kixovókuti íhae yâye yara kúveu mêum, namo kíxoaye peréxikonoa ne koati kaná'uti apeínoviti íhae xoko Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kene hákoti motôvo kívivokono péni ítike koeku iké'itukexi ítukevo po'i xâne, namo kíxoaye peréxikonoa koati ítikevomo? ");
INSERT INTO terNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Ako ahinoêti motovâti pi'á kíxea pátarauxa. Vo'oku koêkumo ivávakea ne po'ínu, yane ákomo itúkoake ne po'ínu, áko'o itukovo yuíxovoxo ítukexeake ne po'ínu, yane ákomo itúkoake ne po'ínu. Kúteanemaka koeku ákoyea yusíka yíxivo ítuke Itukó'oviti koeku yíxivo kirí'uxi tîketina —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yoko vo'oku ixómoyea ipúpakino isóneu kahá'ayea enó'iyea tiûketina ne farîzeuhiko, yupíhova koémoke'eyea neko yuho Jesus kamoánehiko. ");
INSERT INTO terNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ina kixovókoxoa Jesus: —Kutí kénoe koati ponóvoti ya nonékuke po'ínuhiko xâne, itea éxoa Itukó'oviti koêku ne iséneu. Enepone ínixone xâne itúkeovo yupihóvoti unáko, kótirina Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Tukú koeti kaxena Xuaum Mbátita, hane apê Ponóvoti Kixovókuti yútoe Muîse, koánemaka ne yútoe porófetahiko koyúhoti emo'u Itukó'oviti mekúke. Ukeátine kaxena Xuâum, turíxovone koyúhoyeovo ne inámati ihíkauvoti, enepone kixoku natíxea Itukó'oviti xapa xâne, yoko êno xâne koati xúnati yúmo'ixeovo itúkopeovo xanena Itukó'oviti koane yonópea natíxokuke. ");
INSERT INTO terNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ako'óneni oríko uké'eyea ra vanúke yoko poké'e yane veyópeovo póhuti kali telépu'i xapákuke ne létarana emo'úti yane Ponóvoti Kixovókuti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Enepone kuríkoti yêno ina okoyénopomaka po'i sêno, ya xoko Itukó'oviti koati aupú'ikoati ne inúxoti yêno. Kúteanemaka koêku ne koyenópati ne sêno kûre îma, ya xoko Itukó'oviti koati aupú'ikeatimaka inúxoti îma ne sêno —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ina koe'íkomaka Jesus koeku íhikaxea: —Ápe hóyeno iríku ainóvoti koati kohépiti ipovóti kalísoti híyeu itúko ípovo. Yupíhovo úhepeko kóyeku koane unako níkea itukovo káxe. ");
INSERT INTO terNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ina apémaka hóyeno koéhati Lâsaru ákoti apeínoati. Enepone hóyeno, épemokenati. Êno ulaláketi muyókuke. Hane óvoheixo, páhapeteake óvoku neko iríku ");
INSERT INTO terNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","kuxoíxoti irihíkovoti íhone nikokónoti ukeâti mesánake neko iríku. Koane ápe tamúkuhiko ixómoti timarúkexea ne ulaláketi muyókuke. ");
INSERT INTO terNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Po'i káxe, ivókovone neko épemokenati, yane omópane ánjuhiko, enepone ovoxe Itukó'oviti vanúkeke, omopâti xoko Âbraum, yonópoku kasása'iupo Itukó'oviti. Yane ivókovonemaka ne iríku, ina ekoxókono. ");
INSERT INTO terNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ipihóponovokutike yonópo neko iríku, koane yupíheovo koítoponeovo kotívetiya. Ina noiméxo ákotike malîka, yane noíxone Âbraum yoko Lâsaru ya xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ina vaûko Âbraum neko iríku. Hara kíxoa: “Pai, yokóseananu. Pehúkinana ne Lâsaru kaláka'ikea kirípuhi vô'u ina pehukâ njokóyoke motovâti íkasaxea nênem, vo'oku yupíhovone ngoítoponeovo kotíveti yara óvonzeixoku xapákuke ra yúku” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—Ina yumopâ Âbraum: “Nje'exá, puyákapanapa yokóvo enó'iyea apeínopiti koane unako kêku yovo'íko ya kúveu mêum. Kene Lâsaru, kotíveti kóyeku yanekôyo, itea kó'oyene uhepépotine koépoku koeku itúkeovoiko îti koitóponovo kotíveti. ");
INSERT INTO terNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Haina póhutine nê'e, itea anéyemaka êno koímaiti uhôro ínati haháku haxakoâti ra óvonzeixoku yane yóvoheixoku. Enepone ovoti njokóyoke kahá'ati yonópea xikóyoke, ako omótova. Kúteanemaka koêku ne ovoti xoko yóvoku, ákomaka omótova kenó'okopea yâkeneye” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—Ina kôe ne iríku: “Pai, yokóseananu, pehúkinana ne Lâsaru óvokuke nzá'a, ");
INSERT INTO terNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","vo'oku harakóxonoiko singu koeti mbo'ínu. Pehúka koyúhopoinoa koêku yâye mará'inamo yanápamaka yâye xokóyoke ra êno kotíveti koekúti enepo ivakápuhiko” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Ina yumopâ Âbraum: “Anêko yútoe Muîse koánemaka yútoe porófetahiko koyúhoti emo'u Itukó'oviti mekúke. Ene akámokenohiko” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Itea hara kixópoikomaka Âbraum ne iríku: “Pai, ákomaka akámokenoyea yûho nekôyo, itea eneponi áva exepúkopoti ukópea xapa ivokóvoti pihinoâti, mani ikotívexoati isóneuke ne pahúnevo koane kuríkopea” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—Ina yumopâ Âbraum: “Enepo hákoti kamokéno yuho Muîse yútoeke koane yuho porófetahiko, ákonimaka akútipo muhíkovani áva exepúkopoti ukópea xapa ivokóvoti” kíxoane Âbraum —kôe éxetina Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ina kixovókoxoa Jesus ne íhikau: —Koati kóyekutinemo ápeyea koekúti kopoé'akoti isóneu xâne kutí'inoke itavókeati hókeonu, itea koati kotívetimo koêku ne xâne kixotíneye po'ínu. ");
INSERT INTO terNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tumúneke kíxeaneye, yusikóneni iká'akeokono koati pú'iti mopôi anúkuke ínani kuriná'ekakana úneke ya mar yaneko kópoe'akea isóneu póhuti xapákuke ra kálihunoe kutipónuti koane kátavokopeahiko hókeonu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Yokóhiyanavonoe. Enepo vaheréxa ítukeinopi ne pe'ínu xoko Itukó'oviti, yéxaka pahúnevo. Enepo ikatívexapa isóneuke ne váhere ítukeinopi, hákone yunakôa iséneuke. Kutí íxepane ákoti váherexeaku ítuke. ");
INSERT INTO terNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yusíkoti seti kó'iyea váherexo ítukeinopi ya kúveu póhuti káxe, koane enepo seti akoémaka kixóponeopi: “Kotíveti inzóneuke ngíxeopineye, hako kixênu” ixapánapi, hákone yunakôa iséneuke ne váhere ítukeinopi. Kutí íxepane ákoti váherexeaku ítuke —koéne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ina kíxo Vúnae neko íhikau, enepohikone ápostulu, páhoe koyúhoyea emó'u xapa xâne: —Unaém, kirí'uxinavi kúveovopeoxo ûti. ");
INSERT INTO terNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ina kixovókoxoa Vúnae: —Eneponi akutêa kali itóvoku ake ha'i mostarda ne kívivonu, mani motovâti pehúki ne xuve fîgu póhuxeovo marékopeovo koane nópeovo ya kuku mar, yane mani itukoâti kuteâti ne yemó'uinoa. ");
INSERT INTO terNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Eneponi áva xepákukenoe apêti ahínoe ko'itúkeinoati isáneke, áko'o itukovo koyonínoati vakána, ina seôpo ne ahínoe ukopeâti mêum, námeamo kíxoaye yuhó'inoa pátarauxa? “Yahí'akapa ra mêsa, niké'evo” kixoâtimeamo? ");
INSERT INTO terNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ako kalíhuina, itea haramo kíxoa pátarauxa: “Keúnakinanu nikokónoti mesáke, silé'ixa taki ripíno, yíxapu nóngone mesákuke, nikokónoti koane ênga koeku níngea. Unge'éxane níngea, ínamo yahe'ákanu” kixoâtimo. ");
INSERT INTO terNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Konókotikopomeamo íkoro'ixinova pátarauxa enepo uséxa ahínoe itúkea uhá koeti páhoenoa itúkea? Ako kalíhuina. ");
INSERT INTO terNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kúteanemaka kêku, itínoe ínzikau. Enepo itikâ ne uhá koeti péhoenokono itíki, yusikóne ké'iyi: “Ako omóndokea inzáyu'ikeokono, vo'oku pohúneti indúkoti mbáhoenokono indúkea” ké'iyi iséneuke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Koeku píhea ya Njeruzálem ne Jesus, hane véko xêne hunoneâti ne hunókoku émeuxa Samâriya yoko hunókoku émeuxa Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Koeku símea xoko kali ipuxóvokuti, ápe yehí koeti hóyeno itôkopovati. Aínovone yúvone koati koímaiti arinéti, enepone lépara kixonéti. ");
INSERT INTO terNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ako koati malíkea okínoakuhiko vaúkea koane kó'iyea: —Jesus, ihíkaxoti, yokóseanavi —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Noixoâne Jesus, hara kíxovokoxoa: —Pihénoe, yéxakapanapa ne sasedótihiko inuxínoti xâne hó'eke —koéne. Úkeane pihohíko. Koeku píheahiko, koane uké'epea aríne. ");
INSERT INTO terNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Xapákuke neko yehí koêti, ápe póhuti kayú koépoti noixóne unátipea. Koati hónoti emó'u iháyu'ikea Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ipuyuké koéne poké'eke nonékuke Jesus koane íkoro'ixinova. Yoko íhae Samâriya nekôyo. ");
INSERT INTO terNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ina kixôa Jesus: —Ákoikopo yehí ákoe ne hóyeno itóvoti? Náhiko ne nové koêti? ");
INSERT INTO terNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ako ápahuina xapákukehiko kayukóvoti iháyu'ikopea Itukó'oviti ákoti itukápa ra hóyeno ákoti itukapu xanena ûti, uti jûdeu? —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ina kixôa Jesus neko hóyeno: —Yexépukapa, pihépane, itévone vo'oku kívivonu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yoko ápehiko farîzeu epémoti Jesus símeovokumo kaxena natíxea Itukó'oviti xapa xâne. Ina kixoáhiko Jesus: —Enepone natíxea Itukó'oviti xapa xâne, haina koekúti motovâti ínixeokono. ");
INSERT INTO terNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ákomo koêti vo'ókuke: “Anéyene,” áko'o “Harakónone” ákomo koêti. Vo'oku enepone natíxea Itukó'oviti xapa xâne, koati isóneuke xâne óvo —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ina koe'íkomaka: —Simóvotimo káxe yupíheovoku kehá'ayi neíxinunoe xoko nandíxoku, muhíkova itukápu ya kúveu póhuti káxe, vo'oku tivékomo ne koekútihiko, itea ákomo omótova neíxinunoe, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yane apêtimo kixópitinoe: “Anéyene,” áko'o “Harakónone” kixópitinoemo, itea hákonoemo píhe ikéneke. Hákonoemo hekôa. ");
INSERT INTO terNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vo'oku kuteâti koeku ipixéneneoti uhapu'i-uhapu'í kíxea vanúke ukeâtine po'i poixô'o vanúke tukú koêti ya xoko po'i poixô'o, énomonemakamo koéneye aúngopovope, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Itea inúxotike, konókotikomo ngoítoponeovo kotíveti koane púveonu ra xanéhiko apêti yara koeku kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kuteâti koeku kaxénake Nôe, énomonemakamo koéneye simapúne kaxena aúngopovope. ");
INSERT INTO terNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Poéhane níkea, énoyeovo, koane kâsatuxea, ene yuíxovo ne xanéhiko tukú koêti yaneko káxe urúkovane Nôe neko hána'iti vatéke. Yane kenó'okone neko êno koiníkoti, koane heú kíxea koúpa'ixea neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kúteanemaka koeku yaneko kaxénake Lô, vo'oku hara yuíxovo neko xanéhiko, níkea yoko énoyeovo, vanéxea yoko kaváneyea, koane nó'iyea yoko koéxepukea óvoku. ");
INSERT INTO terNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Itea yaneko káxe ipuhíkeane Lô ne Sódoma, kenó'okone irúmene yúku ukeâti vanúke xaneti énxofere koxunákeati otúko. Yane heú kíxoa koúpa'ixea neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Énomonemakamo koéneye aúngopovope, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yaneko káxe, koêkuti ovoti omómikokutike oúke pêno, hákone urúkopovo kúveu óvoku veyóponea ítukevo. Kúteanemaka koêku ne ovoti mêum, aká'ikaneye okóho'i. Hákone aukópovo veyóponea ítukevo óvokuke. ");
INSERT INTO terNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Puyákapanapa yokóvo koêku ne yeno Lô. ");
INSERT INTO terNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Koêkuti xâne yuixóvoti koúhepekea kóyeku yara kúveu mêum, evókoatimo ne mani unako koépoku xoko Itukó'oviti. Itea enepone xâne ákoti yuixápu koúhepekea kóyeku yara kúveu mêum, énomonemo unatî koépoku xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Koati ngixópitinoe ápeyeamo pi'âti imókoti ya póhutike ípe yaneko yóti. Poéhamo veyopókonoti kene po'ínu, iríkovokunemo. ");
INSERT INTO terNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Koane apêtimo pi'âti sêno kaha'ínekokoti itútukea. Poéhamakamo veyopókonoti kene po'ínu, iríkovokunemo. ");
INSERT INTO terNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Koáne, apêtimakamo pi'âti xâne ya mêum. Veyopókonotimo póhuti kene ne po'ínu, iríkovokunemo) —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ina kíxo Jesus ne íhikauhiko: —Unaém, ná'ikopomo óvo ne koekúti kíxene? —koénehiko. Ina kixovókoxopamaka Jesus: —Koêkutimo óvoku ne ivokóvoti, énomonemakamo ho'úxovo ne varutútuhiko —kíxovokoxoane, itukínoati íhokoake ne aúkopovopemo. ");
INSERT INTO terNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ina itûko xêti ne Jesus apêti íhokoake ne âha íhikaxea kouhápu'ikoti kónokea itúkea orásaum ne xâne, koane ákoyea kamúya'ika isóneu. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Ápe pitivóko óvoku hóyeno yúhoikovoku xâne. Enepone hóyeno, ako teya Itukó'oviti koane ákomaka xâne téyone. ");
INSERT INTO terNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ápemaka sêno ivokóvoti îma yaneko pitivóko. Yoko kóyekune neko sêno kíxoixoponea neko hóyeno: “Yokótixonu vo'oku vaheréxoti ítukeinonu” kíxoixoponoa. ");
INSERT INTO terNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","—Itea kali êno ákoyea itúkoake hóyeno neko sêno. Ehane kôe isóneupinovo neko hóyeno: “Kaná'uti ákoyea ndeya Itukó'oviti, koane ákoyeamaka ndeya xâne, ");
INSERT INTO terNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","itea vo'oku ákoyea káyunukanu ra sêno, indukínoatimo ra épemo'ixonuke, mará'inamo hako óko turí'okeovonu” koe isóneupinovo. ");
INSERT INTO terNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ina koe'íkomaka Vúnae: —Itíkina iséneu yûho ne hóyeno, yúhoikovoku xâne. Haina hóyeno itípakovoti, itea kóyeane koyúhoyea huvó'oxeamo ne sêno. ");
INSERT INTO terNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kene Itukó'oviti, ákoikopomo huvá'axa ne xanéna, enepone noívokoe epemó'ixoati kotíxea káxe, yóti upánini kutí kó'iyeamo koati ko'okôriti yumópea? ");
INSERT INTO terNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Koati ngixópitinoe: Ákomo iká'akarixa Itukó'oviti huvó'oxeahiko. Itea apêtiperameamo xâne inú'embo kuvovónuti, undi íhae vanúke ikútipasikoponovoti xâne, enepomo aungápapu yara kúveu mêum? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ina itukópinoamaka Jesus po'i xêti apêti íhokoake ne âha íhikaxea vo'ókuke ne xâne kuvovópovoti, enepohikone inixópovoti itúkeovo koati sasá'iti ya po'ínuhiko xâne. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ápe pi'âti hóyeno itukóponoti orásaum ya témpulu. Poéha farîzeu, enepone yuixóvoti hókea yútoe Muîse, kene po'ínu, koperáxinoti nâti. ");
INSERT INTO terNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Eneponeko farîzeu, xe'ó koéne itúkea orásaum itea ako itápana Itukó'oviti ne orásauna. Ainovó kôe énomone yuhó'ixopovo. Hara kôe orásauna: “Hána'iti íngoro'ixeovo, iti Itukó'oviti vo'oku ákoyea angútea po'ínuhiko xâne, enepohikone ómevoti, koane ákoti oponóvo ítuke, koánemaka xâne aupú'ikoti yêno kapíneti po'i sêno. Hainámaka undi váhere xâne kuteâti ne koperáxinoti nâti, enepone ánu'ukenati kóperau. ");
INSERT INTO terNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pí'a jejuá ngôe ya sêmana, koane mboréxomaka ndîzimu, póhuti ya uhá koeti yehí koeti námoem” koéne. ");
INSERT INTO terNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Itea enepone koperáxinoti nâti, xe'ó kôe ákotike malîka. Ako mapíkapu komómoyea vanúke. Pohu ipúsokone xâ'a koane kó'iyea: “Iti Itukó'oviti, yokóseananu, undi xâne pahukóvoti” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ina kixovókoxoamaka Jesus neko xâne kamokénoati: —Koati ngixópitinoe: Enepora hóyeno, énomone sasa'ípo nonékuke Itukó'oviti koeku pihópea, kene haina neko po'ínu. Yoko uhá koeti kapayásokopovoti, koteyókokonotimo, itea enepone ákoti kapayásakapu, énomonemo kahaná'ikokono —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ina apê xâne ominoâtihikomaka kalivôno ne Jesus motovâti ípihea vô'u tutíkuke. Itea noixoâne íhikauhiko, sayá'ikoa. ");
INSERT INTO terNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ina ihaxíkoa Jesus neko kalivôno ahí'okeovaxo, ina kíxo íhikauhiko: —Síkeane kenó'okea ne kalivónohiko njokóyoke. Hako seya'íkoa, vo'oku kuteâti koeku usó kóyeyea kenó'okinonu râ'a, énomonemaka kónoko kó'iyeaneye ne xâne yonópoti natíxokuke Itukó'oviti vanúkeke. ");
INSERT INTO terNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Koati emo'úti ra yunzó'inopinoe: Enepone ákoti akahá'a íkutipasikeovo kalivôno ya usó kóyeyea kenó'okinonu, ákomo kalíhuina yonópea natíxokuke Itukó'oviti vanúkeke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ápe koati payásoti hóyeno yuhó'ixoponoti Jesus. Hara kíxoa: —Ihikaxotí, iti koati únati. Kutimea ngónoko indúkea motovâti ómbea xoko Itukó'oviti ákotinemo hunókoku? ");
INSERT INTO terNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ina kixôa Jesus: —Yéxoakopomea kixó'ekone ne yiûho keyuhónumeku indúkeovo únati? Vo'oku ako po'inu únati ákoti itukapu Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yéxoa ne páhoenokono xâne itúkea yútoeke Muîse, enepone koêti: “Hako yaupú'iko po'i xâne kepiné'iyiti yêno. Hako kepéko. Hako yomêxo. Hako itikóheo koêku po'ínuhiko xâne, koane tiya yá'a yoko yêno” koêti. ");
INSERT INTO terNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ina kôe ne hóyeno: —Ukeátine ngalivónoxoiko, heú ngíxoa indúkea nê'e —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kameáne Jesus yûho, ina kixopâmaka: —Poéhaiko koekúti nékone itíki. Yakávanea uhá koêti ne apeínopiti, ina perekéxa xâne ákoti apeínoati ne ésa'i. Yane apêtimo apeínopiti vanúkeke, ina kina'áka ingéneke hékinu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kamoáne hóyeno neko yuho Jesus, yupihovó koéne isóne'ekeovo. Koati kama'âti neko êno apeínoati. ");
INSERT INTO terNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Noixoâne Jesus isóne'ekeovo, hara kôe: —Imáko itúkinovo tiú'iti yonópea natíxokuke Itukó'oviti vanúkeke ne xâne iríku. ");
INSERT INTO terNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ako'óneni oríko vékea kámelu xoko kali ihínone tôpe uhe'ókopeti, yane yonópea natíxokuke Itukó'oviti vanúkeke ne xâne iríku —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ina koehíko neko kamoâti: —Yane kuteâti koeku yûho, kutí'ikopomeamo motovâ itúkeovo koítovone Itukó'oviti koane yonópea xokóyoke? —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ina kixovókoxopamaka Jesus: —Enepone ínixone xâne itúkeovo yupihóvoti tiú'iko, ako átiu'i xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yane hara kixo Jesus ne Pêturu: —Kurí kixo uti vóvoku koeku hókeopi ûti. ");
INSERT INTO terNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ina kixôa Jesus: —Koati emo'úti ra yunzó'inopinoe: Ako ápahuina xâne ákotimo námoepo yane ákoyea okótixo ítukevo vo'oku kahá'ayea koúkoponea natíxea Itukó'oviti xapa xâne. Vo'oku enepone ákoti okotíxo kuteâti óvoku, yêno, po'ínuhiko, há'a, êno, áko'o itukovo xe'éxaxapa, ");
INSERT INTO terNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","koati yupihovó koetímo námoepo yara koeku kó'oyene, koane keno'ókoti káxe yonópotimo xoko Itukó'oviti ákotine hunókoku —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yane ahikú kíxoa Jesus ne nduse koeti íhikau koane kíxovokoxea: —Kó'oyene Njeruzálem vonóne. Simané'e utíya, kousókovotinemo uhá koêti ne yutoxóvoti yútoeke porófetahiko vo'ónguke, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nguri'ókokonotinemo xanéhiko ákoti itukapu viyénoxapa jûdeu, enepohikone éxoti koeku poké'exa ûti. Koemóke'enutihikomo, komohínutihikomo, koane apurú'okonutihikomo. ");
INSERT INTO terNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ike yehépoke'exinenuhikomo, ínamo kaepékanu itea mopó'apeke káxe ikénepo, enjepúkopotimo ungópea xapa ivokóvoti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Itea ako éxina isóneu íhikauhiko Jesus neko yûho. Koati ákoti itapána isóneu éxea koêku, ákoinoke iyúseina kixó'ekone ne yûho. ");
INSERT INTO terNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ye'éxoane Jesus ne pítivokona Njeríko, ápe hóyeno komítiti vaata koyêti xe'ókuke xêne ixómoti epêmo. ");
INSERT INTO terNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kameáne emó'u ne êno xâne hunoneâti, ina epemó'iko xanéhiko itukóvotiye neko ínati vélakai. ");
INSERT INTO terNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ina kixokóno itúkeovo Jesus íhae Nazâre ne hunonêa. ");
INSERT INTO terNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yane vaúkone ne komítiti. Hara koe yûho vaúkea: —Jesus, ámoripono Ndávi, yokóseananu! —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Itea sayá'ikoa xanéhiko inuxó koeti tumúneke Jesus, pahukoâti kóyunukeovo, itea inamá'axone vaûko. Hara koe yûho vaúkea: —Jesus, ámoripono Ndávi, yokóseananu! —kóye. ");
INSERT INTO terNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yane xe'ó kó'inoane Jesus, ina pahûko omínokonoa ne komítiti xokóyoke. Simoné'e xokóyoke, hara kíxoa Jesus: ");
INSERT INTO terNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Kuti kehá'a indúkinopea? —Unaém, ngahá'ati íninjopea —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ina kixoá'ikomaka Jesus: —Ínixepane, itévone vo'oku kívivonu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Koati énomone yaneko ókoku ôra, ínixopone. Yane pihóne ikéneke Jesus, koane iháyu'ikea Itukó'oviti. Koane uhá koêti neko xâne noixoâti, iháyu'ikonehikomaka Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Simoné'e ne Jesus ya Njeríko, ûrukova neko pitivóko. ");
INSERT INTO terNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yoko ápe hóyenoya ênoti apeínoati koéhati Nzákeu, tutímaka koperáxinotihiko nâti. ");
INSERT INTO terNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Eneponeko hóyeno, koati oposí'ixoti kixoku noíxea Jesus, itea akó'oti itâ noíxea. Koáhati ênoti xâne ikéneke Jesus, ínamaka itukovo kali karápe ne Nzákeu. ");
INSERT INTO terNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yane ehákovone tumûneke, ina alu'óko tikótike koéhati síkomoro, motovâti noíxea vo'oku koati vékokunemo ne Jesus opékuke neko tikóti. ");
INSERT INTO terNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ehá'axo sîmo ne Jesus opékuke, komomo vanúke ina kôe: —Nzakeú, yéhaka yevésekopi, vo'oku ngonókoti óngea yóvokuke kó'oyene —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yane hú koéne evésekopea ne Nzákeu, koane hána'iti elókeyea okóvo vo'oku xanépeamo Jesus óvokuke. ");
INSERT INTO terNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Itea uhá koêti neko xâne noixoâti, turíxovone poé'ainoa isóneu koane koyúhoyea itúkeovo xoko hóyeno ákoti aunáti ítuke, ánu'ukenati kóperau, okómo ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Koeku xe'ó kóyeyea nonékuke Vúnae ne Nzákeu, hara kôe: —Unaém, usó ngóyene mbôrekexea meyá koeti apeínonuti ne xâne ákotihiko apeínoati. Epó'oxo koêkuti omé'oem, mborexópatimo koaturu koêti yane póhutihiko oménjeake —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ina kôe ne Jesus: —Kó'oyene sasá'ipone ya pahúnevo ra ko'óvokuti. Koáhati ámoriponomaka Âbraum râ'a. ");
INSERT INTO terNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yoko koati énomone nzimíno ombósikoponea yoko ngoíteova ne xâne pahukóvoti, undi íhae vanúke ikútipasikoponovoti xâne —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Koeku kámokenoyea xanéhiko, itúkinoa Jesus xêti apêti íhokoake ne âha íhikaxea, vo'oku yé'exeanehiko Njeruzálem yoko ikútixane xanéhiko itúkeovo simóvotine kaxena natíxea ne Jesus yane pitivóko. ");
INSERT INTO terNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hara kôe éxetina: —Ápe hóyeno koati teyonéti yonoti poké'e ákoti malîka. Pihínoti poréxeokonomo itúkeovo natína neko xanéhikoya xoko úkeaku, ínani aukápapu natíxea. ");
INSERT INTO terNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tumúneke píhea, iháxihiko yehí koeti ahínoe, ina porekéxoa póhuti pe'u tiûketi ôro ne póhutihiko ahínoe. Ina kixoáhiko: “Kehíyakinana ra tiûketi maka kurí'uxapune nzeâpa” kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","—Itea enepohikoneko xâne xoko úkeaku neko hóyeno, yupíhova púvea. Pihoné'e yâtikeneye neko hóyeno, ápe páhoe neko xanéhiko xoko yónoku ne hóyeno koyúhoponea ákoyea akáha'ainoahiko itúkeovo natína. ");
INSERT INTO terNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Porexókonone neko hóyeno itúkeovo natínahiko, ike seópine xapákuke, pahúkoane iháxihikeovo neko ahínoe, enepohikoneko pôrekeu tiûketi tumúneke píhea. Kahá'a éxea kíxeaku tiûketina ne póhutihiko. ");
INSERT INTO terNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yane símeane nonékuke ne inúxoti ahínoe. Hara kíxoa: “Unaém, enepone póhuti pe'u tiûketi pénenu, anéyepo po'i yehí koeti kuteâti” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","—Ina kixôa pátarauxa: “Mbiú koe ítike. Iti koati únati ahinoêti. Koeku yíxivoaxo ne ítike yane kali mbónepike, itínemo exea koêku ne yehí koeti pitivóko yara nandíxoku” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Ina ahi'ókova po'i ahínoe. Hara kíxoa: “Unaém, enepone póhuti pe'u tiûketi pénenu, anéyepo po'i singu koeti kuteâti” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—Ina kixôa pátarauxa: “Mborexópitimo yéxi koeku singu koeti pitivóko ya nandíxokuke” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Ina ahi'ókovamaka po'i ahínoe. Hara kíxoa: “Unaém, harâ'apo ra póhuti pe'u tîketina pénenuke. Ú'una ngíxoixinopea koane á'aupu'i ngíxoa ya léhu, ");
INSERT INTO terNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","vo'oku koati mbikópiti. Koáhati iti hóyeno ákoti omotóva ikómohixeokono. Upánini ákoyea neóku, itea kóyeane ápeyea yêho. Koane iti itíxoti upánini ákoyea neóne” koéne. ");
INSERT INTO terNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—Ina kixôa pátarauxa: “Koati iti váhere ahinoêti. Ya kixeku keyúhoyi, koati yexókovoti itíkivo motokeâti imbíhoponeopi. Yéxoa indúkeovo xâne ákoti omotóva ikómohixeokono. Yéxoamaka ápeyea ênjo upánini ákoyea nóngu, koánemaka índixea upánini ákoyea nónem. ");
INSERT INTO terNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ná'ikopo koeti ákoino ípihea ne ndiûketina bánkuke? Yane koeku nzeópea, mani ihiyákotine ne ndiûketina” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—Ina kixoá'ikomaka únae tiûketi ne po'ínuhiko huvo'óxoati: “Viyápi ne póhuti pe'u tiûketi xokóyoke. Peréxapa ne apêti yehí koêti” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—Ina kixoáhiko huvo'óxoati: “Itea anêkone yehí koeti ítuke nê'e.” ");
INSERT INTO terNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—Ina kixoáhiko pátarauxa: “Koati ngixópitinoe: Uhá koeti xâne xu'ínati êho, kuri'úxinokonoatimo. Itea enepone ákoti axu'ína êho, muhíkova ne kali apêti xokóyoke, veyopeôkonoatimo. ");
INSERT INTO terNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kene ne xâne puvónuti, enepohikone ákoti akahá'a indúkeovo natína, yáma yâkeneye. Képekexa yâye nonénguke kó'oyene” koéne neko nâti —kíxovokoxoane Jesus, ihókopovati ne nâti púvone xanéhiko natíxea xapákuke. ");
INSERT INTO terNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Uke'éxone koyúhoyea ne Jesus, inuxó koéne tumúneke íhikauhiko yonotíya Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Koeku yé'exeane ipuxóvokutihiko koéhati Mbetefâje yoko Mbétanea, xêrerekuke kali mopôi iháxoneti Olívera, pahúkoa Jesus ne pi'âti íhikau ");
INSERT INTO terNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","koane kíxeamaka: —Pihénenoe yane ipuxóvokuti tumúneke ûti. Ehá'axomo símea, inixéponotinoemo xe'exa njuméntu ika'ó koyêti âvoti ivú'ixeokonoku. Kíxeanoemo, ínamo yamapâ yâkeneye. ");
INSERT INTO terNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Enepomo áva epemó'ikopiti itíkoake kíxeinoakenoe, haramo íxea: “Konokoâtiko Vúnae râ'a” íxeamo —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Úkeane pihohíko neko páhoe. Yane ínixoponoane kuteâti koeku yuhó'inoa Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Koeku kúxeyeahiko ne xe'exa njuméntu, hara kíxoane únaehiko: —Kuti itíkoa kíxeinoakenoe? Ina yumopâhiko: ");
INSERT INTO terNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Konokoâtiko Vúnae —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yane omópanehiko neko xe'exa njuméntu. Ina ramaké'exoahiko ya kápana, yane ina huvo'óxohiko Jesus ivú'ixea. ");
INSERT INTO terNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Koêkuti vékoku ne Jesus koane ikápakinoa xanéhiko kápana kouhé'ekinoati vékoku. ");
INSERT INTO terNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ye'éxone Njeruzálem, koeku evésekeahiko yane poke'éxoti ya kali mópoina Olívera, elókehiko okóvo uhá koêti neko êno xâne hokó'ixoati koane kóhonokea emó'u iháyu'ikea Itukó'oviti vo'ókuke ne êno iyupánevoti ítuke Jesus noíxonehiko. ");
INSERT INTO terNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Hara kóyehiko vaúkexea: —Viháyu'ika rakene nâti páhoenovi Vúnae Itukó'oviti koúsokinokonoke xanéhiko úhepeko kóyeku ya vanúkeke. Koati hána'iti ihayú'iuti ne Itukó'oviti yâkonoye vanúkeke —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yoko xapákuke neko êno xâne, ápe farîzeuhiko kixoti Jesus: —Ihikaxotí, pehúka kóyunuhikeovo ne xanéhiko hokópiti. ");
INSERT INTO terNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Itea hara kíxovokoxoa Jesus: —Koati ngixópitinoe vaúkexeahikomo ne mopôi enepomo kayunúhikapu ra xanéhiko —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Koeku yé'exeane Jesus ne Njeruzálem, koane turíxeovone íyoyea noixoâne ne pitivóko. ");
INSERT INTO terNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hara koe yûho vo'ókuke ne xanéhiko ovâti ne pitivóko: —Ehá'ani yéxinoe kó'oyene ne mani nékone, motovâti ápeyea koati únati kêku ikéneke Itukó'oviti. Itea ako imíhe'aka iséneu motovâti yéxi. ");
INSERT INTO terNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Koati simóvotimo káxehiko enó'iyeakumo kixópiku yanáne. Yakukú kixópitinenoemo uhôro, kéhoe xe'ókuke ne pitivóko, hé'oninovopiku koeku okópeopinoe. Ákomo itévokunoe. ");
INSERT INTO terNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ákomo ikénexeake ne pitivóko, koánemaka ne uhá koeti ko'óvokutihikoya. Heú kixokónotimo kotóhinekexeokono mópoina ra pétihiko, vo'oku ákoyeanoe yéxa símeovone kaxéna mani koíteovopiku Itukó'oviti —koéne ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ikénepoke, ina urúkova Jesus ne hána'iti imokóvokuti xoko kíndana, yane kópuhihikopo xâne kavánetiya. ");
INSERT INTO terNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ina kixovókoxoa: —Hara kôe emó'uke Itukó'oviti: “Enepora imokóvokuti óvongu, iháxeokonotimo óvoku itúkoti orásaum” kôe. Itea itíkoanenoe ho'úxovoku ómevotihiko —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yoko uhá koeti káxe íhikaxo ne Jesus yane hána'iti imokóvokuti. Enepohikone tuti sasedóti, inuxínoti jûdeu hó'eke, yóko'o ne ihíkaxoti yútoe Muîse, enepone éskiribahiko, koánemaka ne po'ínuhiko pahúkoti xapákuke jûdeuhiko, opósi'ixonehiko kixoku koépekea Jesus, ");
INSERT INTO terNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","itea akó'oti inixínahiko kíxoaku koépekea, vo'oku enepone uhá koeti xanéhiko, yupíhovo kámokenoyea Jesus. Koati hána'iti ivávakea. ");
INSERT INTO terNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Po'íke káxe ya koeku íhikaxea ne Jesus témpuluke koane koyúhoyea ne inámati ihíkauvoti, íhikaxone xapa xanéhiko, símoamaka tutíhiko sasedóti inuxínoti jûdeuhiko hó'eke, koáne ne éskiribahiko ihíkaxoti yútoe Muîse, yóko'omaka ne po'ínuhiko teyonéti xapákuke tutíhiko jûdeu. ");
INSERT INTO terNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hara kixóhiko Jesus: —Na úkea ne xunakóti itíkike ra koekútihiko? Kuti porexópea kíxineye ne ítike? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ina yumopâ Jesus: —Anéyemaka émbemopikenoe inúxotike, yimápanumo. ");
INSERT INTO terNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kuti porexôa ne Xuaum Mbátita áhikea? Íhae Vanúke? áko'o xâne yara poké'e —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ina kixokókohiko: —Enepomo vokoyúhoa itúkeovo Íhae Vanúke pahukôa, “Ná'ikopo koeti ákoino yakútipoanoe ne Xuâum?” kixo'óvitimo. ");
INSERT INTO terNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Koáne enepo vokoyúhoa itúkeovo xâne yara poké'e pahukôa, koepékovitimo ra xanéhiko hepókeovi ya mopôi, vo'oku heú koe xâne kutípea itúkeovo páhoe Itukó'oviti koyúhoyea emó'u ne Xuâum —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Énomone kixínohiko Jesus ákoyea éxa. ");
INSERT INTO terNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ina kixovókoxopamaka Jesus: —Ákoikopomaka ongóyuhoinopeanoe porexónoati indúkea ra koekútihiko índuke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yane turíxovone Jesus itúkea íhokoake ne âha íhikaxea. Hara kôe: —Ápe hóyeno nôti êno xuve úva. Yane kurí'okoane ko'ítuketihiko kavâne kátarakinoa ne nóne, motovâti haxákopea avané'e êho. Yane pihóne po'íke poké'e neko únae, koane kó'umokeovo óveaya. ");
INSERT INTO terNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Simovóne kaxena veyóvope ha'i nonéti, ina pahûko ahínoe xokóyoke ne katarákinoati ne nóne, motovâti veyópoinoa námoepo, pôreu ne nóne úva. Itea enepohikoneko katarákinoati nóne, yehépoke'exoa neko pahoéti xapákuke, ina pahukópa káyukopeovo ákoti omópone. ");
INSERT INTO terNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yane pahúkopomaka po'i ahínoe neko únae kavâne, itea yehépoke'exoahikomaka katarákinoati ne nóne. Êno komóhiyea, ina pahukópamaka káyukopeovo ákoti omópone. ");
INSERT INTO terNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ina pahukópoikomaka po'i ahínoe neko únae kavâne. Mopó'apene páhoe, itea óko'okoamaka katarákinoati nóne, ina kopúhikopamaka. ");
INSERT INTO terNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yane ina kôe neko únae nonéti: “Namea ínjaneye kó'oyene? Yusikóne mbahúkea ra njé'a ákoti omotóva ongóvo. Ávaina téyahiko” koéne. ");
INSERT INTO terNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","—Itea noixeânehiko xe'éxa, hara kixókokonehiko ne katarákoti nonéti: “Eneporâ'a, koati ítukenemo ra poké'e ivakápune há'a. Hingá, kaépeka ûti maka vitúkapeane ne mani ítuke, íkuinoake há'a ivakápu” kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yane kópuhikopeanehiko meúkeke yane kavâne, ínahiko koepékoa —koe éxetina. Ina kixovókoxopamaka Jesus neko kamokénoati: —Ná'ikopomo kíxoaneye únae nonéti neko katarákinoatihiko nóne? ");
INSERT INTO terNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pihinoâtimo, ínamo kaepékexa. Yane kurikópatimo xoko po'ínuhiko xâne ne nóne motovâti kátarakinoa —kíxovokoxoane. Kamoáne xanéhiko neko éxetina Jesus, hara koéhiko: —Ákomo paréxa Itukó'oviti kó'iyeaneye kuteâti ne yiûho —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yane pono-ponó kixínoane ûke Jesus, ina kixovókoxopamaka: —Kutí'ikopo kixó'eko ne yutoéti emó'uke Itukó'oviti, enepone koêti? “Enepone mopôi, noívokoxine itúkotihiko péti, ainovó koe itukóvo koati turíxeovoku uhá koêti, kuteâti koêku koati inúxoti mopôi turíxeokonoke péti” kôe ne yutoéti —kíxoane Jesus, ihókopovati ne mopôi noivókoxineti. ");
INSERT INTO terNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ina kixovókoxopamaka Jesus neko xanéhiko: —Enepora mopôi ngixínopike, uhá koeti xâne ikoró'uxovati, kutí koetímo póte enepo itatáko. Kene ne xâne irípu'ikovoke, ákonemo ipíxa, kutí koetimo póte muvake-muvaké kixonéti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Koati énomone yaneko ôra, enepohikone éskiriba ihíkaxoti yútoe Muîse, yóko'o ne tutíhiko sasedóti inuxínoti jûdeu hó'eke, kahá'ane iká'akea Jesus vo'oku exó kíxeanehiko itúkeovo énomonehiko kíxo Jesus yane exetínati, itea koati pikoti xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yane turíxovonehiko ivóko'oixea Jesus ya uhá koeti ítuke. Ina apémaka hóyenohiko poréxoke tiûketi koêkumo épemo'ikoponea Jesus, koane îtukoheovohikomaka xâne itípakovoti. Hane opósikohiko iyupaxó kíxea Jesus, kaha'aînoatihiko pahúkeovo ya yumópope motovâti ápeyea évotikoake namúkea koane kurí'okeamo ngovenâdo, maka iká'akanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ina kíxo Jesus neko pahoéti: —Ihikaxotí, véxoa itúkeovo koati ponóvoti ne yiûho koane kixeku íhikexi. Ya xikóyoke, kutíkokone uhá koeti xâne. Ako yokómomoyi payásoko koêkuti xâne, itea kutíkokone uhá koeti xâne xikóyoke, koane koati ihíkexoati ne kaná'uti ihíkauvoti ukeâti xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ná'ikopo kó'inoaye iséneu ne kóperaxovike Sêza, enepone payásoti nâti ya Róma éxoti koeku ûti? Pahúkovi Ponóvoti Kixovókuti hó'e ûti poréxea ûti? áko'o ákomea okónokoa —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Itea exó kíxoane Jesus itúkeovohiko oposí'okovati, kaha'aînoatihikomaka pahúkeovo ya yumópope, yane hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Yamínanunoe póhuti pe'u tiûketi. Kutí'ikopo itukôa nône yoko îha ovâ ra tiûketike? —koéne ne Jesus. Ina yumopâhiko: —Sêza. ");
INSERT INTO terNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ina kixovókoxopamaka Jesus: —Enepone ítuke nâti, peréxapa, koáhati ítukene. Kúteanemaka koêku xoko Itukó'oviti, koêkuti páhoenopi, konokoâtimaka itíki —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ako itáhiko kóteyokea Jesus ya koêkuti yumópope nonékuke ne xanéhiko, koane yupíhova iyúpaxeovahiko unáko neko yumópope Jesus. Yane yunukú koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yane ina ahi'ókovomaka Jesus ne sadúseuhiko, enepone koyúhoti ákoyeamo exépuhikapa ne ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Hara kixóhiko Jesus: —Ihikaxotí, hara kôe yútoe Muîse kûreinovi: “Enepo ivakápu hóyeno ákoti apáhuina xe'éxainoa ne yêno, konokoâti itúkeovo po'ínu ne ivokóvoti koyenópea yêno ne po'ínuikene, maka enepo avané'e xe'éxainoa, kutí ákoepone xe'éxa ne ivokóvotine” koe yútoe. ");
INSERT INTO terNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yoko ápe nóvo seti koeti hóyeno kopo'ínukokoti. Kóyenone neko xuvé'eti. Ivokóvone, ako ápahuina xe'éxa. ");
INSERT INTO terNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Enepone yêno, hane koyenópa atipo imá'ikene. Ivokóvone neko hóyeno, ákomaka xe'éxainoa neko sêno. Kúteanemaka koêku ne mopó'ape, ivókovone ákotimaka xe'éxainoa neko sêno. ");
INSERT INTO terNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Eneponeko seti koeti hóyeno kopo'ínukokoti, heú koéhiko kóyenoyea neko sêno, koane heú koéhiko ívohikeovo, itea ako ápahuina ikoxé'exaxoati xapákuke. ");
INSERT INTO terNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ina ivokóvomaka ne sêno. ");
INSERT INTO terNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eneponi akaná'u exépuhikopea ne ivokóvoti, kutí'ikoponi itukópaxo koati yêno ne sêno xapákukehiko neko seti koeti ivokóvoti? Vo'oku heú kó'iyea kóyenoyeahiko neko sêno —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ina kixovókoxoa Jesus: —Kóyenohiko ra hóyeno yara kúveu mêum. Koáne ne senóhiko, ko'ímahikomaka, ");
INSERT INTO terNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","itea enepohikone xâne ínixone Itukó'oviti motókeyea ópea xokóyoke káxehiko keno'ókoti xapa exépuhikopope ne ivokóvoti, ákonemo okóyeno, koane ákonemo okó'imahiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yane ákonemo ívahikapu, vo'oku kutí koépotinemo ánjuhiko ya vanúke, enepone ovóxehiko Itukó'oviti. Koatíponehikomo xe'éxaxapa Itukó'oviti, koane aínopovonehikomo xâne exepúkopoti ukópea xapa ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yoko enepone exépuhikopeamo ne ivokóvoti, koyúhoa Muîse koêku nê'e ya yútoeke xoko koyúhoyeaku koêku ne kali xuve tikóti ixómoti iruméko ákoti ara'ákapu, enepo koyûho itúkeovo kutípone Âbraum, koane kutíponemaka Izáki yoko Njáko ne Vúnae Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yane hainá'ikopo kuvóvone ivokóvotihiko ne Itukó'oviti, ínapo “Âbraum-kene” akôe, itea koati kuvóvone xâne iyukóvoti, vo'oku ya xoko Itukó'oviti, ákone aúke'e ne xâne —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ina apê éskiribahiko ihíkaxoti yútoe Muîse kixoti Jesus: —Ihikaxotí, koati únati yimópope —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yanê'e, ákone mapikóvati épemo'ikea ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ina kixovókoxoa Jesus: —Ná'ikopo koeti koyúhoinokono itúkeovo ámoripono Ndávi ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne? ");
INSERT INTO terNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Vo'oku koati teyonéti voxú'ikene Ndávi koyuhó'iyea koêku ya koyúhopeke Sâramu xoko kó'iyeaku: “Hara kíxoa Itukó'oviti ne Únaem: ‘Ivétakapa énjopeke xoko ivátakoku koati ngapáyasokone ");
INSERT INTO terNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","imókonemo ipuyúkexa nenékuke ne uhá koeti koêkuti okopópiti’ ” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Koati “Unaém” kixoâti Ndávi. Ápeikopo oxéne itúkeovo ámoripono Ndávi ne Mésiya? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Koeku uhá kó'iyea xâne kámokenoyea, hara kíxovokoxoa Jesus ne íhikau: ");
INSERT INTO terNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Yokóhiyanavoa ne éskiribahiko, enepone ihíkaxoti yútoe Muîse. Aínovo yómoti hamá kíxea ípovo kahá'ati ínixeokono itúkeovo koati teyonéti. Koane enepo yuhoíkokono koeku vékea ya none ovokúti, koati ahá'axomaka. Aínovomaka yómotihiko ivátakea xoko ivatákokuti ya nonekútike xoko ivátakoku koati payásotihiko ya íhikaxovokuke hó'e, koánemaka ya xapa ayuíti. ");
INSERT INTO terNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Itea inípono kixoku senóhiko ivokóvoti îma, kutí koe hu'uxeâti óvoku. Yane vo'oku kó'umokea itúkea orásaum, kutí koe koati ponóvoti. Itea vo'oku kixoku itúkeovo yupihóvotimo tivéko ipíhoponeokono ya po'ínuhiko xâne —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ixómoti komomâ Jesus ne xanéhiko, yane noíxone iríkuhiko kuríkoti tiûketina íhakuke poreúti yane hána'iti imokóvokuti. ");
INSERT INTO terNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ínamaka noîxo sêno ivokóvoti îma, ákotimaka apeínoati kurikóponoti kali pi'âti pe'u tiûketi ákoti axu'ína ovâti. ");
INSERT INTO terNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ina kôe ne Jesus: —Koati emo'úti ra yunzó'inopinoe: Enepora sêno ivokóvoti îma, ákotimaka apeínoati, énomone xu'inâ pôreu ya uhá koêti. ");
INSERT INTO terNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vo'oku enepone po'ínuhiko poréxoti, xoko haxa tiûketina véyo enepo porêxo. Kene ra sêno, heú kíxoa poréxea ne kali apeínoati, enepone mani kuvóvoneiko ya nókoneke —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ápehiko koyuhó'iyeati koêku ne témpulu, ihayú'ikeati úhe'ene pâredena, enepone ainóvoti uhé'ekotinoe mopôi yoko po'ínuhiko koúhe'ekovope, pôreu xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ina kixoáhiko Jesus: —Neíxoanoe koêku râ'a? Simóvotimo káxe ákoyeakunemo ápahuina mópoina pâredena râ'a ákoti katahínekexakana. Heu-heú koetímo kotóhinekexeokono —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yanê'e, hara kíxoa íhikauhiko: —Ihikaxotí, namo ápeyea ra koekútihiko kixínevike? Kutimo itukóvo hoénaxovope enepomo kausákapune ra koekútihiko? ");
INSERT INTO terNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ina kixovókoxoa Jesus: —Yokóhiyanavonoe, maka hákone aupú'ikopiti. Vo'oku enómo xâne simôti xepákuke iko'ítukexoti înza. “Undi páhoe Itukó'oviti koíteovo xâne. Simóvone kaxéna” koetímo. Hákonoemo hekôa. ");
INSERT INTO terNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Enepo yeyekáxanoe ápeyeane ákoti tôpi óvoku isukókoti yoko okopókokoti, hákonoemo kenóko'i, vo'oku konókoti kó'iyeanemoye inúxotike, itea âvomo simápu hunókoku ra mêum. ");
INSERT INTO terNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ina kixovókoxopaikomaka: —Apêtimo íhae po'i poké'e isukóponoti xanéhiko íhae po'íke poké'e. Koane apêtihikomakamo nâti isukókoti. ");
INSERT INTO terNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ákomakamo tôpi óvoku xúnatinoe iyuyôti poké'e, koane hímakati, koane váherehiko arinéti omótokenati. Apêtimo koímaitinoe koekúti koane êno hána'itinoe iyupánevoti ya vanúke. ");
INSERT INTO terNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Tumúneke ápeyeahiko uhá koêti ra koekútihiko, ikeítoponokonotinoemo kotíveti, koane ike'ákokonotinoemo. Yomokónotinoemakamo íhikaxovokuke hó'e xanena ûti yíhoikikono nonékuke teyonétiya, koane kirikókonotinoemo ika'ákovokutike. Yane yomokónotimakamo nonékuke nâti yoko ngovenâdohiko vo'oku itíkivonoe hokónuti. ");
INSERT INTO terNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kixínekonokenemoye motovâti keyúhoinonu nonékukehiko, keyuhó'inoati koêku ra kitípone. ");
INSERT INTO terNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ukeátine kó'oyene, keúsakapunenoe maka hákone pipokéxinoa iséneu ne kixékumo yimópi simapúne neko káxe. ");
INSERT INTO terNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Vo'oku undínemo porexópi yimópikemo, koane mborexópitinoemo exóneti ukeâti njokóyoke ákoinokemo ápahuina itópiti xapákukehiko, koane ákoinokemakamo ita okópea yiûho. ");
INSERT INTO terNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Muhíkova koati yá'a yoko yêno, kurikópopitinoemo ika'ákovokutike. Kúteanemakamo kixópiku pe'ínuhiko, yoko po'ímaka iyínoxapa koane ínikenehiko. Apêtimakamo koépeuti xepákukenoe vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yupihovó koetímo púveopi uhá koeti xâne vo'oku itíkivo hokónuti. ");
INSERT INTO terNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Itea muhíkova kali póhuti híyeu tiûti, ákomo síka Itukó'oviti évokeovo. ");
INSERT INTO terNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Epó'oxo yane ákoyea yaúkapapu ikíni, yixóvoti kéxuna'ixivo ingéne, itévotinenoemo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ina koe'íkomaka ne Jesus: —Enepomo neixánenoe êno húndaru yakukú kixoti Njeruzálem, yexoâtinemo itúkeovo simóvotine kaxena katáhineyeokono. ");
INSERT INTO terNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yane enepohikone ovotíya Njúdeya, okóho'inehiko xapa hána'itinoe mopôi. Kene enepohikone ovâti ne kúveu pitivóko, ipúhikapeahiko. Kene ne ovotíhiko ya mêum, hákone aukópovo pitivókoke. ");
INSERT INTO terNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vo'oku yaneko káxehiko, koatimo kaxena ipíhoponeokonoku ovâti ne pitivóko, koúsokeovokumakamo uhá koeti kíxone ne yutoéti emó'uke Itukó'oviti vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Hanemo kixovóhiko yaneko káxe, sêno ihaíkoti yoko ohíkotiko xe'éxa, vo'oku koati hána'itimo tivéko ne koekútihiko yara poké'exa ûti, koane kotívetimo ipíhoponeokonoke ra xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Enómo koépeuti ya hána'iti pirítau xapákukehiko. Kene po'ínuhiko, ika'ákokonotimo, iyonópokonotimo ya uhá koeti po'íkehiko poké'e yara kúveu mêum. Yoko íhaehiko po'i poké'e payasómo ya Njeruzálem tukú koetímo simapúne kaxena hunókoku payásoyea ne xanéhikoya ákoti itukapu jûdeu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ina koe'íkomaka ne Jesus: —Apêtihikomo iyupánevoti noixóneti xoko káxe, koane xoko kohê, yoko xapa hékerehiko. Epó'oxo yara kúveu mêum, pepoké koetínemo isóneu xanéhiko ya póhutihiko poké'e óvohikoku. Ákomo éxinahiko isóneu enó'inoke hónoti emo'u úne ya mar yoko xúnati ovóxokeovo ne úne. ");
INSERT INTO terNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Apêtimo xâne ikorókovoti poké'eke vo'oku hána'iti píkea, yupihóvati yónea isóneu koêkuikomo ra kúveu mêum. Vo'oku itohínekexotimo ne heú koeti apêti ya vanúke. ");
INSERT INTO terNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yane noixóponutinemo xanéhiko ngena'ákapane híyeu kapási, undi íhae vanúke ikútipasikoponovoti xâne. Xané ngixópotinemo njunáko koane êno únje'ene koeku indúkeovo hána'iti ihayú'iuti. ");
INSERT INTO terNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Enepo turixápune ápeyeahiko ra koekúti, aélokenoene yokóvo koane kéxepuka tiûti, vo'oku ye'ekóvotinemo kaxena yovópikumo xoko Itukó'oviti, enepone Koitóvopiti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ina itukínoahikomaka Jesus xêti apêti íhokoake ne âha íhikaxea. Hara kôe: —Yokómomapihi koêku ne xuve fîgu koane uhá koeti xuve tikóti. ");
INSERT INTO terNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Neixánenoe turíxeovo íhonopea inámati tûti, yanê'e yexoâtinemo yé'exopeovone kaxena kevópope úko. ");
INSERT INTO terNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kúteanemaka koêku enepo neixânenoe ra koekútihiko ngixínopike, yanê'e yexoâtinenoemo yé'exeovone kaxena pihópea natíxokuke Itukó'oviti vanúkeke ne xanéna. ");
INSERT INTO terNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Koati emo'úti ra yunzó'inopinoe: Enepone xanéhiko apêtimo yaneko káxehiko, ákomo ivákapu koeku âvoyea kaúsakapapu uhá koêti ra koekúti ngixínopike ápeyeamo. ");
INSERT INTO terNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Uké'etimo ra vanúke koáne ra poké'e, itea ákomo uké'eyeaku ra emó'um. ");
INSERT INTO terNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yokóhiyanavo mará'inamo isáyu'ixapu iséneu enepo itukápu ayuíti yíxovo, koane xúnati ekâti, koánemaka koekúti kuteâti nékone yara kúveu mêum. Yokóhiyanavo mará'inamo iyupaxó íxapinoe rakene káxe, yakúteamo hó'openo namukókonoti ya noko'óti. ");
INSERT INTO terNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vo'oku itopónotimo uhá koeti xâne yara kúveu mêum ra káxe ngixínopikenoe. ");
INSERT INTO terNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Usokó yákoyenoe ya uhá koeti ôra. Itíkanoemaka orásaum maka ítipane uhá koêti ra váhere koekúti keno'ókotikomo, koane motovâtimaka sípi nonénguke, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Heú koeti káxe íhikaxo ne Jesus yane hána'iti imokóvokuti. Kene ya yóti pihópotine ya oúke kali mopôi, enepone iháxoneti Olívera. ");
INSERT INTO terNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Itukovo mâturukata, pihotíne xanéhiko hána'itike imokóvokuti kamokénoponoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yoko yanekôyoke, ákone ahíkapu kaxena áyui jûdeu hó'eke, enepone iháxoneti Páskoa níkeakuhiko pâum ákoti kohiyákoati. ");
INSERT INTO terNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Enepohikone tuti sasedóti inuxínoti jûdeu hó'eke, koáne ne éskiribahiko ihíkaxoti yútoe Muîse, ixómotine itukínoa isóneu ne kixókumo koépekea Jesus he'ono'ú koetíke vo'oku píkeahiko isóneunoa xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yoko ûrukovane Satánae ne Njûda, enepone iháxonetimaka Iskarióti, póhuti xapákuke ne nduse koeti íhikau Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yane pihóne ne Njûda xoko tutíhiko sasedóti yoko xoko tutíhiko koyónoti hána'iti imokóvokuti, yuhó'ixoponoati, kaha'âti ápeyea oxéne kuríkea ne Jesus xokóyokehiko. ");
INSERT INTO terNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yane yupihovó koéne elókeyea okóvo neko tutíyehiko, koane itúkinoa yûho, koati yuhôti poréxeamo tiûketi vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ínixoa Njûda unáko nê'e. Yane kúxoixone káxe ákoyeakumo koati xâne xoko Jesus motovâti kuríkea xokóyokehiko. ");
INSERT INTO terNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yoko simóvotine kaxena áyui ne jûdeuhiko hó'eke, enepone níkeaku pâum ákoti kohiyákoati, kaxena isúkeakumaka kali xe'exa su'ûso, nîka ya Páskoa. ");
INSERT INTO terNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ina pahukôa Jesus ne Pêturu yoko Xuâum koane kíxeahiko: —Pîhe, keúsakapainavea ne nikamo ûti xapa áyui Páskoa. ");
INSERT INTO terNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ina kixohíko Jesus neko pi'âti: —Na kehá'aikopo kóyuseoponea ûti? ");
INSERT INTO terNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ina kixôa Jesus: —Ehá'axomo siménoe pitivókoke, tekópotimo hóyeno koínoti póte puhí koati úne. Hekápamo ne hóyeno xokóyoke ne ovokúti ûrukopovokumo ");
INSERT INTO terNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ínamo ixêa ne únae ovokúti: “Na óvo ne kúveu ovokúti óvongumo níngea xapa áyui Páskoa, ûndi yoko ínzikauhiko? kixópi Ihíkaxoti” íxeamo. ");
INSERT INTO terNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yane exókopitinoemo koati hána'iti kúveu ovokúti vanúkeke apêti mêsa yoko pánguhiko. Usó koyêtine uhá koetíya. Énomonemo keúsakinavi nikamo utíya —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Úkeane pihohíko ya pitivóko. Yoko uhá koêti neko yuhó'inoa Jesus, aínovo tokopóvoti. Yane koúsokoanehiko neko nikámo xapa áyui Páskoa. ");
INSERT INTO terNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Simovóne orána, ahí'okovane Jesus ne mêsa, koánemaka ne íhikauhiko, enepohikone ápostulu páhoe koyúhoyea emó'u xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ina kixovókoxoa Jesus: —Koati yupihóvati ngahá'ayea ngahá'ineyeopinoe níngea yara Páskoa tumúneke ngoítoponeovomo kotíveti. ");
INSERT INTO terNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yoko endó'okopitinoe ákoyeanemo íningeopiku xapa Páskoa imókonemo kausákapu koati kixó'ekone ya natíxokuke Itukó'oviti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yane ina namukôa Jesus ne enovópeti apêti ekâtiya koane íkoro'ixeovo xoko Itukó'oviti. Ina kôe: —Nemúkanoe. Kalihú kalihu íxenoe yénoyivoa, uhá ketínoe. ");
INSERT INTO terNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Koati ngixópitinoe ákoyeanemo énoyeovangu hô'o ra ha'i úva ukeátine kó'oyene tukú koeti seapánehiko heú koêti ne xanena Itukó'oviti vanúkeke xoko natíxoku —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yane veyone pâum ne Jesus, ina ikoró'ixovo xoko Itukó'oviti. Yane honó'ekexoanemaka, ina porekéxoa íhikau koane kíxovokoxea: —Enepora pâum, mûyom kixó'eko, ésa'imo ngoíteovopinoe. Yákoyenenoeye níki, puyákoponeovakemo yokóvo ne índukeinopi —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Uke'éxone njántaxeahiko, ina namukôa Jesus ne enovópeti kuteâtimaka kíxoaku ne pâum, koánemaka kíxovokoxea: —Enepora ekâti yara enovópetike, hane kixó'eko inámati kixovókuti ítukeino xâne ne Itukó'oviti vo'oku óvokinovopinoemo indína. ");
INSERT INTO terNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Itea anéye xapákuke ûti xe'ókuke ra mêsa ne itûkoheovoti koeku hókeonu, enepone kurikónutimo xoko xanéhiko puvónuti. ");
INSERT INTO terNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Koati kaná'uti ngoépekeokonomo, kuteâti koeku isóneunonu Itukó'oviti, itea koati kotívetimo koêku ne kurikónutimo xoko xanéhiko puvónuti, undi íhae vanúke ikútipasikoponovoti xâne —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yane turíxovone ne íhikau Jesus épemo'ikeokoko, kaha'âtihiko éxea itukóvotiye xapákuke ne itûkoheovoti koeku hókea Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yane turíxovone kali enó'iyea yumópeokoko ne íhikauhiko Jesus, kaha'âti éxeahiko itukóvotiye ne koati payásoti xapákuke. ");
INSERT INTO terNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ina kixovókoxoa Jesus: —Koatíhiko nâti pahukô xapa xâne yara kúveu mêum. Koane enepohikone pahúkoti, uhé'ekinoati kíxeokono itúkeovo apêti xunáko koúsokino nókone xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Itea ako ákoeneye xepákukenoe, koati pó'iti koêku. Vo'oku enepone koâti payásoti xepákukenoe, konókoti kutí kixópeovo xâne yupihóvoti ákoyea apáyaso. Kene ne inuxínopiti, konókoti kutí kixópeovo ovoxe po'ínuhiko xâne. ");
INSERT INTO terNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kutí'ikopo payasó'inopi, enepone ivatákoti xe'ókuke mêsa? áko'o enepone ominoâti nîka. Hainá'ikopo ne ivatákoti xe'ókuke mêsa? Itea hara ngoéneye xepákukenoe, ovoxéti. ");
INSERT INTO terNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Itínoe itukóvo koati kaha'ínenuti ya uhá koeti kotíveti koekúti véngoku ákoti kurikánu. ");
INSERT INTO terNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kuteâti poréxeonu Nzá'a nandíxeamo, mborexópitinoemakamo netíxi ");
INSERT INTO terNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","motovâtimo kehá'ineyinu ya xe'o mêsa, óvoku nikokónoti yoko ekâti ya nandíxokuke, koane ivetákotimo xoko ivátakokuhiko pahúkoti nandíxokuke, yihoíkopati ne nduse koeti iháxakexoku xanena Izarâe, neixoâti unátiyea, áko'o ákoyea aúnati ne ítuke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ina kixo'íkomaka Pêturu ne Jesus: —Simaúm, imáko ké'iyivoku. Ítoane Satánae ne yúmo'ixovone hixópeopinoe. Yoko ákomo íyuhixapinoe. Hanemo koéneye kixópiku kuteâti koeku ákoyea íyuhixakana koyúyukexeokono ne vekoti komukéxopetike enepo komukéxokono. ");
INSERT INTO terNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Itea émbeminopine Itukó'oviti ákoyea kirika kívivonu Simaúm. Koane enepo yaukápapune njokóyoke, kéxunakapimo isóneu ne pe'ínuhiko ingéneke —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ina kixôa Pêturu: —Unaém, usó ngóye xané ngíxeopi iké'akivo koánemaka ngoépekeokono okonókovo. ");
INSERT INTO terNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Itea hara kíxoa Jesus: —Koâti endó'okopiti kêkumo Peturú. Kó'oyene, tumúnekemo éneyea tapî'i, mopo'âtinemo keyúho ákoyea yéxanu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ina kixovókoxoamaka Jesus ne íhikau: —Ápeikopo konokínovopitinoe yaneko mbahukópi keyúhoyi emó'um yâtikeneye, yaneko ákoyeaku yama íhaku tîketina koane íhaku ípevo yoko piríkatana? Ina yumopâhiko: —Ako nókone ûti. ");
INSERT INTO terNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ina kixovókoxopakomaka Jesus: —Kó'oyene, enepone apêti íhaku tiûketina yoko íhaku ípovo, áma xokóyoke. Yoko enepone ákoti hána'iti pirítauna, yusikóne kaváneyea kápana itûka ésa'i vanéxeake ne hána'iti pirítauna. ");
INSERT INTO terNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Vo'oku koati endó'okopitinoe kónokea koúsokeovo njokóyoke neko yutoéti emó'uke Itukó'oviti, enepone koêti: “Kutí kixókono váhere kixoku itúkeovo” koêti. Vo'oku oránane koúsokeovo ne emo'úti koyúhoti ngixókonokumo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ina kixôa íhikauhiko: —Unaém, anéyene pi'âti hána'iti pirítau. Ina kixoáhikomaka Jesus: —Motóvane —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yane pihóne ne Jesus xoko kali mopôi iháxoneti Olívera, koane íhikau xáneahiko. Yoko kóyekune Jesus yóneaya. ");
INSERT INTO terNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Simoné'ehiko xoko âha óvea, hara kíxoa Jesus ne íhikauhiko: —Itíkanoe orásaum, maka hákone ikerókovo enepo simâpi tiú'iti koekúti hixépikonoke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yane kali ahikuu koéne ne Jesus, kuteâtimea tirinta koeti méturu kíxoaku ne íhikau, ina ipuyúkexo epémoti Itukó'oviti. Hara koéne: ");
INSERT INTO terNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Pai, enepo itukapu yahá'inonu, yáhikuxapinana ra êno hána'iti tiveko ngoêkumo, itea haináya anjáke, itea itúkapu yahá'inonu kousókovomo ya njokóyoke —koéne. ( ");
INSERT INTO terNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yane apé kó'inoane ánju íhae vanúke, ovoxe Itukó'oviti, koxunákoponeati isóneu. ");
INSERT INTO terNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Koeku yupíheovo êno tiveko isóneu ne Jesus, inamá'axoneoxo itûko xunáko ya orásaunake. Yoko eneponeko yonúko, kutí koéne pú'itinoe itomíkexoti íti irihíkovoti poké'eke.) ");
INSERT INTO terNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Uke'éxone itúkea orásaum, exépukopone, ina aukópovo xoko íhikauhiko. Inu'í kixópanehiko imókea vo'oku yupíheovo ikáxu'iyeahiko okóvo. ");
INSERT INTO terNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ina kixoáhiko Jesus: —Na koeti imékinonoe? Yexépuka, itíkanoe orásaum maka hákone ikerókovo simâpi tiú'iti koekúti hixépikonoke —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ixómoiko koyûho ne Jesus, símohikoane êno xâne. Yoko hane inuxínoahiko Njûda, póhuti yane nduse koeti íhikau Jesus. Énomone ahi'ókovo Jesus kaha'âti siunoné kíxea yúhoikea. ");
INSERT INTO terNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yane hara kíxoa Jesus: —Njudá, imáko itúkinovo ya ítikoheyivo sínoneyinu kirí'okinu xanéhiko puvónuti, undi íhae vanúke ikútipasikoponovoti xâne! ");
INSERT INTO terNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ina kíxo Jesus neko íhikauhiko oveâti xêrerekuke noixoâne neko koekúti: —Unaém, visúkanehiko ya hána'iti pirítau? —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yoko apé koéne póhuti xapákuke ne íhikau Jesus, hú kixoti tetúkenoxea ahínoe koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke. Maturú kíxea kêno éxopeke. ");
INSERT INTO terNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Itea sayá'ikoa Jesus. Hara kíxoa: —Ápene. Hákone kixeáneye —kíxoane. Ina itukópinoa kêno, yane unátipone. ");
INSERT INTO terNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ina kixôa Jesus ne tutíhiko inuxínoti jûdeu hó'eke, koáne ne tuti xanéhiko koyónoti hána'iti imokóvokuti, yóko'omaka ne po'ínuhiko payásoti xapa tuti jûdeu ika'ákoponoatihiko: —Undí'ikopo koati koyuvôrixovoti ísukenati omó kixínekenoe hána'iti pirítau yoko pulô'i, isukópeti nemúkoponinu? ");
INSERT INTO terNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Uhá koeti káxe, óvonzeixokunepepo xepákukenoe ya hána'itike imokóvokuti inzíkaxoti, itea ákonoe iké'akanu. Kó'oyene simóvotine orana iké'akinu yoko oránanemaka xuná'iyea váhere ítukeinonu Satánae —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ina ika'ákohiko Jesus, omâtihiko óvokuke koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke, ina usá'ixoahiko ovokútike. Kene Pêturu, ákone malíka kíxoaku hókea. ");
INSERT INTO terNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ina oxokúxohiko yúku kukúkeke kíndana ne ovokúti. Yane ivátahikone onokóvotihiko. Koane Pêturu, ivátakoponomaka xapákuke. ");
INSERT INTO terNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yane apé koene seno ahinoêti, noixoti Pêturu vaata koyêti xe'ókuke yúku onokóvoti. Pono-ponó kixínoane ûke sêno, ina kôe: —Koati xáneheixonemaka Jesus ra hóyeno —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Itea hara kíxoa Pêturu: —Senó, ako énja ne hóyeno kíxene —koéne yûho yumopâ. ");
INSERT INTO terNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Avo áxu'ikene, apé koéponemaka po'i noixoâti. Hara kíxoa: —Koati itímaka po'inu xanéheixone ne hóyeno —kíxoane. Ina yumopâ Pêturu: —Hoyenó, haina undi xáneheixone nê'e —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Poéhamea ôra ikénepoke, apé koéponemaka po'i koêti: —Eneporâ'a, koati kaná'uti itúkeovo xáneheixone ne hóyeno, vo'oku koati íhaemaka Ngalíleya râ'a —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ina kixôa Pêturu: —Hoyenó, ako énja ne kíxene —koéne. Avo uké'exa koyúhoyea ne Pêturu, éneone tapî'i. ");
INSERT INTO terNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ina na'akénexova Vúnae ne Pêturu, komomo-komomó kíxoane. Énomone yanê'e, puyákoponovane okóvo Pêturu neko yuhó'inoa Vúnae yaneko kixôa: “Kó'oyene tumúnekemo éneyea tapî'i, mopo'âtinemo keyuho ákoyea yéxanu” kixôa. ");
INSERT INTO terNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yane ipúhikopeane Pêturu ne óvoheixoku. Koati iyôti vo'oku yupíheovo kotíveyea isóneu. ");
INSERT INTO terNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Enepohikoneko hóyeno koyónoti Jesus, ixómonehiko koemóke'ea koane isúkeahiko ");
INSERT INTO terNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","yoko ikauké kíxoanehiko, ínamaka kixôa: —Mahí'ipepo iti porófeta. Íhexaikopo itukóvotiye ra isukópiti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yoko enómaka po'i yuhó'inoahiko koemóke'eati. ");
INSERT INTO terNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ehá'axo yúponi, ho'úxovonehiko uhá koeti payásoti hóyeno xapákuke tuti jûdeu, enepone tutíhiko sasedóti inuxínoti jûdeu hó'eke koánemaka ne éskiribahiko ihíkaxoti yútoe Muîse. Ina omokóno ne Jesus xoko ho'úxovokuhiko, enepone koati payásoti yúhoikovoku jûdeu. Ina kixohíko Jesus: ");
INSERT INTO terNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Itukápuxo îti ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne, yokóyuhoinovea itíkivoaxo —kíxoanehiko. Ina yumopâ Jesus: —Enepo ongoyúhoa indúkeova, ákonoemo yakútiponu. ");
INSERT INTO terNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Koane embemápinoe iséneunoa, ákonoemo yimápanu. ");
INSERT INTO terNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ukeátine kó'oyene, hanemo ivándakopone, undi íhae vanúke ikútipasikoponovoti xâne, éxopeke Itukó'oviti, enepone apêti xunáko pahúkea uhá koêti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ina kixoáhiko uhá koêti neko tutíyehiko: —Ití'ikopo Xe'exa Itukó'oviti? Ina yumopâ Jesus: —Enepone yépemonuke, koúhapu'ikoa indúkeova —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ina koehíko: —Ákone vokónoko po'i koyuhó'inoveati pahúnevo râ'a. Koati kameâtine uti yûho koyuhómeku itúkeovo Xe'exa Itukó'oviti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yane heú koéne exépuhikea neko ho'uxóvotihiko, ina omohíko Jesus xoko Pilátu. ");
INSERT INTO terNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yane turíxovone koyúhoyeahiko ákoyea aúnati ítuke Jesus. Hara koéhiko: —Enepora hóyeno, vinú'ikoa koésayu'ixea isóneu xanena ûti, koane íhikaxea xanéhiko ákoyea parexa kóperau koati payásoti natina ûti, enepone Sêza. Koyúhomaka itúkeovo Mésiya, páhoe Itukó'oviti koíteovo xâne, koane itúkeovomaka nâti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ina kixôa Pilátu ne Jesus: —Ití'oxo natina jûdeuhiko? Ina yumopâ Jesus: —Enepone yépemonuke, koúhapu'ikoa indúkeova —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ina kixovókoxoa Pilátu ne tutíhiko sasedóti inuxínoti jûdeu hó'eke, yóko'o neko êno xâne ho'uxóvotiya: —Ako ápahuina íninjone váhere ítuke ra hóyeno —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Itea inamá'axone koyuhôa tutíhiko jûdeu ápeyea váhere ítuke. Hara koéhiko: —Koati koturíkexoti xanéhiko râ'a. Ihíkaxoti ya uhá koeti Njúdeya, ukeâti turíxeovoku poké'exa Ngalíleya tukú kíxoane yâye —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kameáne Pilátu ne yuhóhiko, ina epêmo itúkeovo íhae Ngalíleya ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Exoâne itúkeovo ukeâti xoko iháxakoku poké'e natíxoku Êrodi, pahúkone Jesus xokóyoke. Yoko koati Njeruzálem óvo ne Êrodi yaneko káxehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yupíhova elókeyea okóvo ne Êrodi noîxo Jesus. Koáhati mekutíne kahá'a noíxea vo'oku enó'iyeane kámea koyuhó'iyeati koêku ne ítuke, koane kúxoamaka noíxea itúkea iyupánevoti. ");
INSERT INTO terNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yupíhovo êno épemo'ikoake Êrodi, itea ako ápahuina yumópeake Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Enepone tutíhiko sasedóti inuxínoti jûdeu hó'eke, yóko'o ne éskiribahikoya ihíkaxoti yútoe Muîse, inamá'axo kohonóko emó'u koyúhoyea ápeyea váhere ítuke ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yane komohí kixo Jesus ne Êrodi yoko uhá koeti húndarunahiko, koane koémoke'eyeahikomaka, itukínoati kuteâti ípovo nâti koati kalísoti híyeu, hamá koêti poké'eke. Yane ina pahukópa Êrodi xoko Pilátu. ");
INSERT INTO terNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Énomone yaneko káxe, unátipinokokone isóneu ne Êrodi yoko Pilátu. Yoko koati ka'anánekokoti neko pi'âti yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ina ho'uxôa Pilátu ne tutíhiko sasedóti, yóko'o ne po'ínuhiko payásoti xapa tuti jûdeu, koánemaka ne xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ina kixovókoxoa Pilátu: —Enepora hóyeno yómone njokóyoke, keyúhoanoe itúkeovo kopoé'akexoti isóneu xanéhiko. Émbemo'ikoane nenékukenoe, itea ako íninja ápeyea pahúnevo ra hóyeno kuteâti ne yévotikoake. ");
INSERT INTO terNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kúteanemaka Êrodi, ákomaka ínixea pahúnevo. Hukinóvoti pahúkopeamaka yâyeke xoko ûti. Koati iyúseoti ákoyea pahúnevo ra hóyeno mani évotikinokonoke koépekeokono. ");
INSERT INTO terNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mbahukoâtikopo yehépoke'exeokono, ínamo ngurikápa —kíxovokoxoane Pilátu. ( ");
INSERT INTO terNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yoko koati konokoâti Pilátu kuríkopea póhuti iká'aeti kaxénake neko áyui jûdeuhiko.) ");
INSERT INTO terNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Itea vaúkexone uhá koêti neko xâne. Hara koe yûho vaúkexea: —Enepora hóyeno, konókoti koépekeokono. Hane kiríkapinavi Mbarâba —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yoko ika'ákovokutike óvo ne Mbarâba vo'oku kóturihikea xanéhiko yane pitivóko yaneko okopókono nâti, koane vo'oku ápeyea koépeu. ");
INSERT INTO terNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yoko koati kahá'ati kuríkopea Jesus neko Pilátu. Énomone káyukopinoahikomaka ne yûho ");
INSERT INTO terNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","itea inamá'axone kohonóko yûho neko xanéhiko vaúkexea: —Kirúhuxa! Kirúhuxa! —kóyehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ina kixovókoxopamaka Pilátu. Yoko mopó'apene káyukinoa neko yûho: —Kutí'ikopo itúko pahúnevo ra hóyeno? Koati ákoti ininjêa váhere ítuke mani évotikinokonoke koépekeokono. Mbahukoâtimo yehépoke'exeokono ínamo ngurikápa —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Itea inamá'axohiko kohonóko vaúkexea épemea kurúhuxeokonomo Jesus. Ehane ítoahiko ne âha vo'ókuke neko êno hónoti vaúkexea. ");
INSERT INTO terNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yane itúkinoane Pilátu ne épemonehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kuríkopinoa ne épemone kuríkopeokono, enepone ovoti ika'ákovokutike vo'oku kóturihikea xanéhiko, koane vo'oku ápeyea koépeu. Kene Jesus, kuríkoane xokóyokehiko, motovâti itúkea ne âha kíxeahiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yaneko omonéhiko Jesus, ápe hóyeno koéhati Símaum ukopeâti mêum. Enepone hóyeno, íhae pitivóko iháxoneti Sîreni. Yanê'e, ípihonehiko kurûhu povókuke Símaum ne húndaru koane pahúkea oko'ikené kíxea Jesus koínoinoa. ");
INSERT INTO terNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Koati yupihovó koeti êno xâne hokoâti. Ápemaka senóhiko xapákuke ixómoti iyókexo koane ipúsokopea xâ'a, kotiveâti neko kixókonoku Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ina komomâ Jesus neko senóhiko, hara kíxovokoxoa: —Itínoe sêno íhae Njeruzálem, hákonoe iyeínonu itea itínenoe iyápinapu yoko xi'íxaxapa. ");
INSERT INTO terNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Vo'oku simóvotimo káxe kó'iyeakuneye xanéhiko: “Koati únati koêku ne senóhiko ákoti koxé'exayeaku, ákotimaka xe'éxa óhiu” koetímo. ");
INSERT INTO terNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Vo'ókuke ne hána'itimo tiveko koekúti yaneko káxehiko, ká'aye koetimo xanéhiko: “Ehá'ani íkoro'uxeovovi ne hána'iti mopôi. Ehá'ani koépekexeovi” koetímo. ");
INSERT INTO terNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ako kuxákana oró'okeovo ne tikóti tonó'otiko, poéhane movó'oti oro'ókovo. Koeku ngíxeokononeye kó'oyene, undi ákoti évotikokonoke, kutí koe koeku kurikókono ne tonó'oti tikóti yúkuke. Ná'ikopomeamo kó'eye tiveko kixókonoku ne koati motokeâti ipíhoponeokono, enepohikone kutí koeti movó'oti tikóti kurêti yúkuke? —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yoko ápemaka po'i pi'âti hóyeno koati ákoti aunáti ítuke, ixánexokonoke Jesus kurúhuxeokono. ");
INSERT INTO terNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Simonéhiko ya xoko iháxoneti “Opepú'iti”, kurúhuxonehiko Jesus, koánemaka neko pi'âti hóyeno ákoti aunáti ítuke. Poéha éxopeke Jesus, poéhamaka lopékuke. ");
INSERT INTO terNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ina kôe ne Jesus: —Pai, hako ipihéponoa ra xanéhiko vo'oku ako éxa ne ítukeinonuhiko —kixone há'a. Yane haxákokoahiko húndaru neko ípovo Jesus. Ina kurikóhiko, komomâti itukóvotimoye ípovo Jesus námoe póhutihiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yoko ixomo komomâ xanéhiko heú koêti neko koekútihiko, koane ixomo koemóke'e Jesus ne tutíyehiko. Hara koéhiko: —Koítovopepo po'i xâne râ'a. Kaítapapuikopo itukápuxo koati Mésiya, enepone páhoe Itukó'oviti koíteovo xâne —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Koémoke'eamaka húndaruhiko. Ina ahi'ókovahikomaka ominoâti víyum ákoti koati unátiyea ");
INSERT INTO terNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","koane kíxeahiko: —Itikápuxo natina jûdeuhiko, keítapapu —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yoko ápe yutoéti tutíkuke kurúhuna Jesus (yutoxóvoti ya emó'uke ngerêku, koane emó'uke rómanu, yoko emó'uke jûdeu). Hara kôe: “Natina jûdeuhiko râ'a” kôe. ");
INSERT INTO terNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ápe póhuti koemóke'etimaka Jesus yane pi'âti ákoti aunáti ítuke kuruhúxokonoti xêrerekuke Jesus. Hara kíxoa: —Mahi iti Mésiya, páhoe Itukó'oviti koíteovo xâne. Keítapapuikopo, ínamo keitápuvimaka —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Itea hara kíxoa po'i kuruhúxokonoti saya'íkoati: —Muhíkova koeku kirúhuxikono, ako tiya Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Koati ponóvoti kíxeokononeye ûti, vo'oku koati motokeâti namúkopea ûti ésa'i ne váhere vítuke. Kene ako váhere ítuke râ'a —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ina kixo'íkomaka Jesus nekôyo: —Enepo yurúkapapu netíxokuke, puyákapunumo yokóvo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ina yumopâ Jesus: —Koati emo'úti ra yunzó'inopi: Keha'íneponutinemo kó'oyene ya xoko uhé'ekoti yonópoku ómomikopea ne kasása'iupo Itukó'oviti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yoko ye'ékotine itúmukea káxe yanekôyo. Énomone yanê'e ípukovone káxe, hahámone uhá koeti kúveu mêum tukú koeti mopo'âti ôra ya kiyakáxe. ");
INSERT INTO terNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yoko ívarereone kukúkeke neko êno kopópoti váhere haxakeâti kúveu ne hána'iti imokóvokuti. ");
INSERT INTO terNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yane ápene koati êno hónoti emo'u Jesus koêti: —Pai, nguríkopa ra omínjone xikóyoke —koéne. Uke'éxoane koyúhoyea nê'e, îhunokoane ne omíxone, ivókovone. ");
INSERT INTO terNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Noixoâne tuti húndaru neko koekútihiko, iháyu'iko Itukó'oviti koane kó'iyea: —Koati kaná'uteoxo itúkeovo ponóvoti ra hóyeno —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Enepone êno opoíkovoti xâne ho'uxóvotiya komomóponoati neko koekúti, noixoânehiko nê'e, píhohikopone. Hána'iti ikáxu'iyeahiko okóvo koane ipúsokopea xâ'a. ");
INSERT INTO terNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yoko heú koetíhiko neko ínikone Jesus, koánemaka ne senóhiko hokoâti ukeâtihiko Ngalíleya, kali ako malíka okínoakuhiko komómoyea neko koekútihiko. ");
INSERT INTO terNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yoko ápe hóyeno koéhati Yûse, koati teyonéti xapákuke neko po'ínuhiko pahúkoti yane koati payásoti yúhoikovoku jûdeu. Enepone hóyeno, koati itípakovoti koane koati ponóvoti kixoku itúkeovo. ");
INSERT INTO terNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hane úkea pitivóko iháxoneti Arimáteya, po'i pítivokona jûdeuhiko. Yoko ako ínixa Yûse póneovo isóneu yoko ítuke ha'ínehiko yaneko yuhoíkokonone Jesus. Koati kuxoíxotinemaka símeovo kaxena natíxea Itukó'oviti xapa xâne neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yane pihóne Yûse xoko Pilátu epemóponoati yusíkea veyópea ne muyo Jesus kuruhúke. ");
INSERT INTO terNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Porexókonoane, yane veyóponoane xoko kurúhuxokonoku, ina aupíxoa ya hána'iti ipovóti líyum. Yane iyónoane xoko uhôro kehoéti mopoíke, âvoti ekoxóvati. ");
INSERT INTO terNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yoko koati ûrukovope sâputu, koúsokovopene jûdeuhiko vo'oku áyui. ");
INSERT INTO terNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Enepohikoneko sêno xánena Jesus ukeâti Ngalíleya, hokó kixo Yûse ivokó'okoponoti ekóxokonoku Jesus koane kixókonoku ne mûyo ipíhokonone uhorókuke. ");
INSERT INTO terNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yane pihópone kóyuseopeahiko xêru yoko óliu, óvo'okopemo muyo Jesus. Yaneko sâputu, ómomikoponehiko kuteâti páhoenoa yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hahá'itiko yaneko lûmingu, pihóne ne senóhiko xoko ekóxokonoku Jesus, ominoâtihiko neko xêru koúsokinoake. ");
INSERT INTO terNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Simoánehiko, inú'ikoane neko mopôi exexoâti ne uhôro ahíkuxeokonone. ");
INSERT INTO terNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Urúkovanehiko neko ekóxokonoku, ákone inú'ikaya ne muyo Vúnae Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ákohiko éxina isóneu neko koekúti kó'inokeneye. Yane apé kó'inoane pi'âti kutí koeti hóyeno hóhopu koyêti ípovo. ");
INSERT INTO terNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yupihovó koéne píkea neko senóhiko vo'ókuke, koane puniniké kó'iyeahiko. Ina koehíko neko pi'âti noíxone: —Na koeti yopósikinoa xapa ivokóvoti ne iyukópovotine? ");
INSERT INTO terNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Áko'one yâye nê'e, exépukopone. Puyákapanapanoe yokóvo neko yuhó'inopi yovo'íko ya Ngalíleya ");
INSERT INTO terNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","yaneko kíxeopikunoe: “Ngonókotimo ngurí'okeokono xâne váhere kíxoku itúkeovo, koane ngurúhuxeokono, yoko enjépukopeamo ya mopó'apeke káxe ikénepo, undi íhae vanúke ikútipasikoponovoti xâne” kixópinoepepo —koénehiko neko pi'âti. ");
INSERT INTO terNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yanê'e, puyákoponovane okóvo senóhiko neko yuho Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ukopeânehiko xoko ekóxokonoku Jesus, koyúhopinoane neko unze koeti íhikau Jesus, koánemaka ne po'íhiko xâne ovâti xapákuke, uhá koêti neko koekútihiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yoko hara îha neko senóhiko koyuhópati ne koekútihiko: Mariya Mandâlena; Njuâna; yoko po'i koéhatimaka Mâriya, enepone eno Teâku. Ápemaka po'ínuhiko sêno xánena, koyuhópatimaka xapákuke neko unze koeti ápostulu kaná'uyea neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Itea ako akútipeahiko ápostulu neko yûho. Kutí kó'inoa koyuhóheoti. ");
INSERT INTO terNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yane xepú koene Pêturu ehakóvo xoko ekóxokonoku Jesus. Simoáne, ina yupunínikovo, yane ákone noíxoneya ákoti itukápa neko ipovóti líyum, aúpi. Yane pihópone óvokuke koane iyúpaxeova neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Énomoikone yaneko káxe, ápe pi'âti kutípoti Jesus yonoti kali ipuxóvokuti iháxoneti Emâu. Hanêkomea kuteâti yehí koeti kílomituru kixoku Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Koeku yóneahiko, koane itúkea xêti uhá koêti neko koekútihiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ya koeku ixómoyea yúho'ixokoko koane koyúhoinokoko isóneunoa, apé koene Jesus ahi'ókovatihiko koane xanee kíxeahiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Itea kutí koe apêti itopeâtihiko ûke neko pi'âti, ákoinoke éxapana. ");
INSERT INTO terNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ina kixôa Jesus: —Kutí'oxoya ne itíkonoe yónoku iséneu ixómoinoke yího'ixokoko koeku yéni? —kíxoane. Xe'okó koénehiko neko pi'âti, koati ikaxú'itihiko okóvo. ");
INSERT INTO terNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ina kixôa póhuti yane pi'âti koéhati Keleópa: —Poéhaneikopomea îti itukóvo ovâti ne Njeruzálem ákoti exâ koêku ne koekútihiko apêti yara káxehiko pihotíne? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—Kuti itukóvo koekúti? —koéne. Ina yumopâhiko: —Enepone uhá koeti kixókonoku ne Jesus íhae Nazâre, hóyeno páhoe Itukó'oviti koyúhoyea emó'u xapa xâne, koati hána'itimaka xunáko iyúseoti ya ítuke, koáne ya koyúhoyeake nonékuke Itukó'oviti, koane nonékuke uhá koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Itea enepone tutíhiko sasedóti inuxínoviti hó'eke ûti, yóko'o ne po'íhiko pahúkoti xapákuke ûti, pahúkoa koépekeokono nekôyo koane kurúhuxeokono. ");
INSERT INTO terNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yoko énomone kúxo ûti itúkeovo mani koitóvoviti, uti íhae Izarâe. Haina póhutine nê'e itea kó'oyene, koati mopo'âpoatine káxe ikéne neko koekútihiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ápemaka senóhiko ha'íneheixone ûti, viyúpaxeovake ne yuhópinovi ukopêa xoko ekóxokonoku Jesus ya yuponii koêti. ");
INSERT INTO terNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ákonehi inú'ika ne muyo Jesus ya. Yane káyuhikopovone, koyuhópati ápeyeahiko ovoxe Itukó'oviti noíxone, enepone ánjuhiko íhae vanúke, etó'okoati exépukopeane ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yane pihómaka po'ínuhiko ha'ine ûti xoko ekóxokonoku Jesus. Noíxoanehiko itúkeovo koati kaná'uti yûho ne senóhiko itea ako naíxahiko Jesus —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ina kixôa Jesus neko pi'âti: —Imáko itíkinovonoe xâne ákoti isóneu koane ôriti kutípea uhá koêti ne yuho porófetahiko emó'uke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Koati konókotipepo koítoponeovo kotíveti ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne, motovâtimaka yupíheovo kahána'ikopeokono. —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yanê'e, xoko yútoe Muîse koúkea koúhapu'ikinoa uhá koêti ne yutoéti emó'uke Itukó'oviti koyuhó'iyeati koêku, koáne xoko heú koeti yútoe porófetahiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ye'éxoanehiko ne kali ipuxóvokuti yonópokuhiko, îtukovo ukopónotiko ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Itea ako akáha'ainoa pi'âti xánena itávokea. Hara kíxoahiko: —Yavá'avoneye xoko ûti vo'oku kiyóne káxe, kahá'ane yotíxea —kíxoanehiko. Yane xanépoane Jesus motovâti ókea xokóyokehiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ya koeku ivátakeahiko xe'ókuke mêsa nikotíhiko, veyo pâum ne Jesus, ina ikoró'ixovo xoko Itukó'oviti. Yane honó'ekexoane ne pâum, ina porexôa neko pi'âti. ");
INSERT INTO terNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yane imíhe'okonehiko isóneu koane éxoponoane, itea má koépeane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ina kixokókohiko neko pi'âti: —Énomoneikopo yupíhinovo úhepeyea kámokenoyea ûti koane elókeyea vokóvo yâkeneye xenékuke, koeku yúho'ixeovi koane koûrapu'ikinovea ne yutoéti emó'uke Itukó'oviti —kixókoko. ");
INSERT INTO terNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Énomone yaneko ókoku ôra, exépukoponehiko neko pi'âti, kayuké koéponehiko ya Njeruzálem. Inú'ikoako ho'úxeovo neko unze koeti íhikau Jesus koánemaka neko po'ínuhiko xâne xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ina kixokóno neko pi'âti simôti: —Exépukopone Vúnae. Koútata'ixopinovone Símaum —kixókonone. ");
INSERT INTO terNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yanê'e, koyúhoamaka neko pi'âti ne kixoku koêku ya xenékuke, koane kôeku exóponoanehiko ne Vúnae yaneko hono'ékexone pâum. ");
INSERT INTO terNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Avo uké'exa koyúhoyeahiko neko koekúti, apé koéne Jesus xapákuke. Hara kíxoa: —Aúhepeponoe iséneu. ");
INSERT INTO terNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Itea kónoko'i neko íhikauhiko koane yupihovó koéhiko píkea. Ikútixati koipíhapati. ");
INSERT INTO terNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ina kixovókoxoa Jesus: —Na koeti pepókexinovonoe iséneu? Na koeti ákoinonoe yakútipoa iséneuke itúkeovo ûndi? ");
INSERT INTO terNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yokómoma ra vô'um koáne ra njêve itúkeovo koati ûndi. Sipé'akanu motovâti yéxixo kaná'uyea. Vo'oku eneponi itukapu undi koipíhapati, ákoni mûyom koane ômbe kuteâti koêku neíxinu kó'oyene —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Koyuhoâne nê'e, ina exókoa ne vô'u koane hêve. ");
INSERT INTO terNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Koati yupihóvoti elókekohiko okóvo neko íhikau, itea vo'oku kóyeyeane âvoyea koâti kutípeahiko, koane vo'oku iyúpaxeovahiko neko koekúti, hara kíxovokoxopamaka Jesus: —Ápe nikokónoti yâye? —koéne. ");
INSERT INTO terNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ina porexoâhiko itátane orópeuti hôe (yoko itátane íhaku ho'o mópo). ");
INSERT INTO terNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yane níkoane nonékukehiko. ");
INSERT INTO terNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ina kixovókoxopamaka Jesus: —Enepora koekúti, énomone ne yunzó'inopinoe ovónzeixoiko xepákuke kónokea koúsokeovo uhá koeti ngixókonokumo yutoxóvoti Ponóvotike Kixovókuti yútoe Muîse, koánemaka yútoeke porófetahiko, yoko ya Sâramu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yane míhe'okinoa Jesus isóneuhiko éxea kixó'ekone neko yutoéti emó'uke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hara kíxovokoxopamaka: —Énomone kôe emó'uke Itukó'oviti kónokea koítoponeovo kotíveti ne Mésiya, páhoe Itukó'oviti koíteovo xâne, koane exépukopeamo ukópea xapa ivokóvoti ya mopó'apeke káxe ikénepo. ");
INSERT INTO terNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Koyúhoamaka kónokea koyúhoyeovomo xapa xanéhiko itúyopeamo pahunévoti ya iháke nê'e. Énomone ne xanéhiko ikotívexoati isóneuke ne váherevoko, koane kurikópati. Koyúhoamaka itúkeovo turixeôvoti ya Njeruzálem koyúhoyeovomo ne ihíkauvoti yonoti xapa uhá koeti xâne, koêkuti poké'e óvohikoku yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Itínenoe itukóvo koyuhoâti ra kaná'uti koekúti neíxonenoe. ");
INSERT INTO terNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Koane mbahukínopeatinenoemo ne kixínopike Nzá'a yanekôyoke poréxeopeanoemo. Yavá'avonenoeye yara pitivóko tukú koeti símeopikumo ne xunakóti ukeâti vanúke xoko Itukó'oviti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ina omâ Jesus ne íhikauhiko ya Mbétanea, koane koéxepukea vô'u koeku épeminoahiko unako koêku ikéneke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Koêkuiko épeminoahiko, turíxovone ahíkuxopeova, pihópotine ya vanúke. ");
INSERT INTO terNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ina ihayú'ikopa íhikauhiko koane káyuhikopeovo ya Njeruzálem. Koati hána'iti elókekohiko okóvo. ");
INSERT INTO terNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yoko kóyekunehiko yane hána'iti imokóvokuti iháyu'ikeahiko Itukó'oviti. Hunókokune.");
INSERT INTO terNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tumúneke ápeyea ra mêum, ápene ne Évekoaku Itukó'oviti Koúhapu'ikinovovi, enepone Xe'éxa. Ukeátinekene ápeyea xoko Itukó'oviti neko Xe'éxa, epó'oxo koati póhutinehiko nê'e. ");
INSERT INTO terNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Koati óvoheixokune xoko Itukó'oviti nê'e, ukeátinekene tumúneke ápeyea ra mêum. ");
INSERT INTO terNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Epó'oxo xoko Xe'éxa évekoa Itukó'oviti itúkea ne uhá koeti ítuke inâ itukôa. Ako ápahuina apêti ákoti itukapu énomone kousókoa. ");
INSERT INTO terNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Énomonemaka itukóvo úkeaku ne inámapoti apéyeati ákotinemo hunókoku. Yoko vo'oku itúkeova, énomone kouhápu'iko xâne yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Anéyeiko koúhapu'ikea ovoti hahákutike nê'e, koane ako íta hahákuti ípukea. ");
INSERT INTO terNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ápe hóyeno páhoe Itukó'oviti koyúhoyea emó'u xapa xâne. Xuaum Mbátita koéha. ");
INSERT INTO terNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pahúkinokonoke nê'e motovâti koyúhoyea koêku neko Kouhápu'ikoti xâne ukeâti xoko Itukó'oviti, maka akútipoane uhá koeti xâne nê'e vo'oku yuho Xuâum. ");
INSERT INTO terNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Haina Xuâum itukóva ne Kouhápu'ikoti xâne, itea simínoke koyuhóponeati koêku nekôyo. ");
INSERT INTO terNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Koati kaná'uti Kouhápu'ikoti xâne ne ngíxone, enepone simôti yara kúveu mêum koúhapu'ikea uhá koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sîmo yara kúveu mêum nê'e, yoko énomone kousókoa ne uhá koeti apêti, itea ako éxa xanéhiko itukóvotiye. ");
INSERT INTO terNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Koati xanéna simíno, itea ako itúkeake xanéna emó'u. ");
INSERT INTO terNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Itea uhá koeti koêkuti namukeâti emó'u, énomone poréxo itúkopeovo xe'éxapone Itukó'oviti. Énomone neko xâne koati kutipoâti. ");
INSERT INTO terNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yoko enepone itúkopeovohiko xe'éxapone Itukó'oviti ne kutipoâti, haina kuteâti koeku ipúhikea xe'exa xâne yara kúveu mêum. Ákomaka akútea koêku kahâ'a koxé'exayea ne xâne. Hainámaka vo'oku ahá'inoa koyénoti itea koati ahá'inoa Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Enepone Évekoaku Itukó'oviti Koúhapu'ikinovovi, uti xâne, íkutipasikoponovovi. Koati opónoti xapákuke ûti. Yoko aínovo kaná'uti kixovókuti íhae xoko Itukó'oviti yoko seánako Itukó'oviti apê xokóyoke. Noíxoane ûti itúkeovo koati êno hána'iti ihayú'iuti, poéhane motovâ itúkeova neko koati kaná'uti Xe'exa Itukó'oviti, ákoti po'ínu. ");
INSERT INTO terNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hara koe yûho ne Xuaum Mbátita xapa xâne yanekôyoke koyuhó'iyeati koeku nekôyo: —Énomone ngíxone râ'a enepo ngoyûho yanekôyo ápeyeamo hóyeno keno'ókoti ingénepoke koati teyonéti ya undíke, epó'oxo inuxóne ápe ya undíke, vo'oku tumúneke ámbeyea, ápene nê'e —kôe. ");
INSERT INTO terNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ukeâti neko êno únatinoe koekúti apêti xokóyoke yoko itípanevo ákoti hunókoku, ápene íparaxeovike, uhá koeti ûti. Iko'ipará iko'ipara kíxoixovi. ");
INSERT INTO terNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Vo'oku xoko Muîse évekinovea Itukó'oviti ne páhoenovi vitúkea yane Ponóvoti Kixovókuti yútoe, itea xoko Jesus Kristu évekinovea ne hána'iti seánakovi koáne ne uhá koeti kaná'uti kixovókuti ukeâti xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ako ápahuina xâne noíxoti Itukó'oviti, itea enepone Xe'éxa, ákoti po'ínu, enepone koati kuteátine Itukó'oviti, Há'a, énomone kouhápu'ikinovi koeku Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yoko ápe páhoe payásotihiko jûdeu ya Njeruzálem xoko Xuaum Mbátita. Enepone pahoétihiko, aínovo sasedóti, inuxínoti jûdeu hó'eke, yoko levíta, enepohikone huvo'óxoti sasedótihiko ítukeke. Hara kixóponohiko Xuâum: —Kuti îti? ");
INSERT INTO terNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ina exókova Xuâum. Ako hé'ana'uxinapa. Hara kíxoahiko: —Haina ûndi ne Mésiya, páhoe Itukó'oviti koíteovo xâne —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ina kixopâmaka pahoétihiko: —Kutí'ikopo îti? Itímea Îliya, enepone koyúhoti emo'u Itukó'oviti mekúke? —Áko'o —kíxoanehiko Xuâum. Ina koepóhikomaka: —Ití'ikopomea neko porófeta koyúhoti emo'u Itukó'oviti, kúxone ûti símeamo? Yane hara kixópahikomaka Xuâum: —Haina ûndi nê'e. ");
INSERT INTO terNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ina kixopâmaka pahoétihiko: —Yokóyuhoinoveakopo itukóvotiye îti motovâti ápeyea yuhópinoa ûti ne pahukó'oviti. Kutí'ikopo keyúhoinovi itukóvotiye îti? ");
INSERT INTO terNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ina yumopâ Xuâum: —“Énomone ûndi ne kohonókoti emó'u ya mêum ákoti apêti xapa xâne kamokénoponoati, enepone koêti: Kéyuseapa ne kixeku itíkivo, perexoâti oxéne ne Vúnae itúkea ítuke xepákukenoe” koêti —kíxoanehiko Xuâum, kuteâti koeku yútoeke porofeta Izâiya mekúke. ");
INSERT INTO terNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yóko'o neko pahoétihiko epemó'ikoponoti Xuâum, aínovo farîzeu, enepohikone yuixóvoti hókea yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ina kixo'íkohikomaka Xuâum: —Ná'ikopo koeti yáhikino xâne iháke Itukó'oviti enepo hákoti itukovo iti Mésiya, simóya Îliya, simóyamaka neko porófeta koyúhoti emo'u Itukó'oviti, enepone kúxone ûti símeamo? ");
INSERT INTO terNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ina yumopâhiko Xuâum: —Kaná'uti ánjikea ya úne, itea anêkone xapa xâne kîrivokoevo âvoti yexâ. ");
INSERT INTO terNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Harakénemo ingénepoke. Muhíkova anjí'okeova ngúxeinoa imo perékatana, ako omóndokea —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yoko yaneko ápeyeaku neko koekútihiko, hane óvoheixo ne Xuâum poixô'oke húveona Njôrdaum ya Mbétanea xoko áhikoku. ");
INSERT INTO terNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Poéha káxe ikénepo, noíxoane Xuâum ne Jesus keno'ókinoati, ina kôe: —Yokómomanoe rakene páhoenovi Itukó'oviti kotúyopea pahúnevo xâne yara kúveu mêum, kuteâtimaka koeku xe'exa su'ûso isoéti, ikó'iparaxokonoke Itukó'oviti, ésa'i itúyopea pahunévoti. ");
INSERT INTO terNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Énomone ngíxone râ'a yaneko ngoyuhó'inopeanoe ápeyeamo keno'ókoti ingénepoke koati teyonéti ya undíke, vo'oku tumúneke ámbeyea, ápene nê'e. ");
INSERT INTO terNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Muhíkova ûndi, ako énja itukóvotiye yanekôyoke, itea nzimínoti ánjikea ya úne maka éxane íhae Izarâe itukóvotiye —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ina koyuhoâ'ikomaka Xuâum koêku ne noíxone yanekôyoke. Hara kôe: —Noínjoane ne Sasá'iti Omíxone Itukó'oviti ukeâti vanúke kutí koeti kurûte evesékoati xokóyoke rakene hóyeno. Yoko ovo'ó koáne, ákone ipúhikapea. ");
INSERT INTO terNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Avo énja itukóvotiye yanekôyoke, itea hara kixónu Itukó'oviti, enepone pahukónuti ánjikea ya úne: “Neixoâtimo ne Sasá'iti Omínjone evésekea xoko hóyeno, epó'oxo ákonemo ipúhikapea. Énomonemo ahíko xâne haînati ya úne, itea ya xunákoke Sasá'iti Omínjone kuteâti yunzó'inopi” kixónu Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yoko koati noinjoâti yanekôyoke. Hukinóvoti ngoyúhoyea itúkeovo koati Xe'exa Itukó'oviti rakene hóyeno —kíxoanehiko Xuâum. ");
INSERT INTO terNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Poéhapoa káxe ikéne, kahá'inepoane Xuâum ne pi'âti íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yane noíke'exonehiko Jesus yâtike, ina kôe ne Xuâum: —Yokómomanoe ratike páhoenovi Itukó'oviti. Koati kuteâti xe'exa su'ûso isoéti nê'e, ikó'iparaxokonoke Itukó'oviti motovâti itúyopea pahunévoti —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Úkeanehiko hokôpo Jesus neko pi'âti íhikau Xuâum kameáne neko yûho. ");
INSERT INTO terNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ina na'akénexovo ne Jesus koane noíxea neko pi'âti keno'ókoti ikéneke. Yane hara kíxoa: —Kuti kehá'anoe? Ina kixoáhiko: —Na yóvo Rabí? —kíxoanehiko. (Yoko ihíkaxoti koêti ne Râbi koêti.) ");
INSERT INTO terNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ina yumopâ Jesus: —Kiná'aka ingéneke, neíxapana óvongu —kíxoanehiko. Yane xanépoane komomóponeati óvoku. Ôvanehiko óvokuke yaneko káxe vo'oku yé'exeovone koáturu ôra ya kiyakáxe. ");
INSERT INTO terNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yoko Ándere, po'inu Simaum Pêturu itukóvo póhuti yane pi'âti hokópoti Jesus yaneko kámeaku Xuâum koyuhó'iyeati koêku. ");
INSERT INTO terNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Inúxotike, opósikoponoa Ándere ne Símaum, enepone koati po'ínu. Inixóponoane, hara kíxoa: —Vínixoponoane ne Mésiya —kíxoane. (Yoko enepone Mésiya koêti, kuteátine Kristu koêti, enepone páhoe Itukó'oviti koíteovo xâne koêti.) ");
INSERT INTO terNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Úkeane omâ Ándere neko koati po'ínu xoko Jesus. Noixoâne Jesus ne Símaum, hara kíxoa: —Iti Símaum, xé'a Xuâum. Séfa kéhaponemo —kíxoane Jesus. (Yoko enepone Séfa yoko Pêturu koêti, póhutine kixó'ekone. Aínovo kixo'êkoti mopôi.) ");
INSERT INTO terNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Poéhapoa káxe ikéne, koúsokovone Jesus yóneamo ya Ngalíleya. Yane tokópone Filípi, ina kixôa Jesus: —Kiná'aka ingéneke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Yoko pitivóko koéhati Mbetâsaida úkea ne Filípi, úkeakumaka Ándere yoko Pêturu. ");
INSERT INTO terNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ina oposíkoa Filípi ne Natanâe. Inixóponoane, hara kíxoa: —Tokópane ûti ne hóyeno kíxone Muîse ya Ponóvotike Kixovókuti yútoeke, enepone kíxonemaka ne po'ínuhiko koyúhoti emo'u Itukó'oviti mekúke. Énomone ne Jesus íhae Nazâre, xé'a Yûse. ");
INSERT INTO terNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ina kixôa Natanâe: —Na kixoâtiye ápeyea únati koekúti ukeâti Nazâre? Itea hara kíxoane Filípi: —Hingá, naíxapana ûti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Noixoâne Jesus yé'exeane ne Natanâe, hara kôe vo'ókuke: —Yokómoma rakene hóyeno. Koati itípakovoti izaraelíta nê'e. Ákomaka ítukaheapu. Koati ponóvoti ne uhá koeti kixoku itúkeovo —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ina kixôa Natanâe: —Na yéxinu? —Tumúneke iháxikoponeopi Filípi, noínjopine xoko yóvoheixoku opékuke ne xuve fîgu —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ina kixôa Natanâe: —Ihikaxotí, iti Xe'exa Itukó'oviti. Iti natina ûti, uti íhae Izarâe —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ina kixôa Jesus: —Vo'oku ngoyúhoinopi noínjeopi opékuke ne xuve fîgu, ene kutí'inoke kitipónuti? Koati neíxotikomo koekúti hána'iti yarâ'a —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ina kixoá'ikomaka: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Neixoâtimo ne vanúke imíhe'okea, koánemaka ne ánjuhiko íhae vanúke, enepohikone ovoxe Itukó'oviti koeku ahíkuxeovonumo yána vanúke koane evésekinonumo, undi íhae vanúke ikútipasikoponovoti xâne —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pí'apoane káxe ikéne, ápe áyui kasâtuxoti ya Kána, kali ipuxóvokuti ya Ngalíleya. Yoko ápe eno Jesus yane ayuítike. ");
INSERT INTO terNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Hupíxokonomaka ne Jesus yoko íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ehane uké'e ne ekâti. Yane hara kixo Jesus ne êno: —Yokómoma, ákone víyum. ");
INSERT INTO terNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ina kixôa Jesus: —Ako apásika keyúhoinonu índukemo. Avo simápu kaxena énjokeakumo njunáko xapa xâne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ina kixôa eno Jesus neko ovoxétiya: —Itíka uhá koêti ne páhoenopinoe itíki —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yoko ápe sei koeti íhaku úneya, itukéti ya mopôi, ímoaku jûdeuhiko ne úne kasása'ikovope ya hó'eke. Enepone íhaku úne, aínovo motovâti óvea kuteâti oitenta koeti líturu, áko'o póhuti séndu líturu úne. ");
INSERT INTO terNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ina kixoáhiko Jesus neko ovoxéti: —Kepúhikexanoe ra íhaku úne —kíxoanehiko. Koáne, puhi-puhí kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ina kixopâhikomaka Jesus: —Kó'oyene, heúkanoe, yámane xoko exeâti koêku ra ayuíti —kíxoanehiko. Koáne, itúkeanehiko yûho. ");
INSERT INTO terNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yane énovane éxoti koeku ayuíti neko víyum sa'irí'oepoti. Yoko ako éxea úkeaku. Poéhane neko ovoxéti haukóponoati ne úne exôa. Enepo hixopâne ne víyum ina ihaxíkoa neko hóyeno kasâtuxoti. ");
INSERT INTO terNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Hara kíxoa: —Koati kixóvoku uhá koeti xâne kópuhikea ne koati únati víyum ya inúxotike enepo koyûi. Má'aina enoné'e énoyeovo ne xâne, ínati kopúhikokono ne víyum ákoti koati unátiyea. Kene îti, koati pé'itinovo, vo'oku ínati kepúhikoa ne koati únati víyum —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Énomone kôe inâ turixóvo ne Jesus itúkea iyupánevoti koeku óvea ya Kána, ya Ngalíleyake, exókovoti itúkeovo koati hána'iti ihayú'iuti. Yane kutípoane íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ikénepoke, ukóponone ne Jesus ya pitivóko koéhati Kafanâum. Hane xáne ámeno yoko êno koánemaka íhikauhiko. Kali ye'á koe káxe óveaya. ");
INSERT INTO terNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yanekôyoke yé'exovone áyui evo jûdeu ya hó'eke, enepone íhaxonehiko Páskoa. Yane pihónemaka ne Jesus ya Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Simoné'e témpuluke, enepone hána'iti imokóvokuti, meúkeke xoko kíndana péti inú'iko xâne kaváneti tûru, su'ûso yoko kurûte, koánemaka xâne vatá koyêti koperáxoti xanéhiko esa'íkoti tiûketina. ");
INSERT INTO terNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ina véyo mâreso ne Jesus itúkoti ikátakoke. Yane uhá kíxoa kópuhihikopea neko xâne kaváneti yaneko óvoheixoku, koánemaka ne su'usóhiko yoko tûru. Kásahikoamaka poké'eke neko tiûketina ne esa'íkoti tiûketi, koane kasá'irikeamaka mesána. ");
INSERT INTO terNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ina kixôa Jesus neko xanéhiko kaváneti kurûte: —Heú íxepa képuhihikopi yarâ'a. Hako itikôa kavanékuti ra imokóvokuti, óvoku Nzá'a —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yane puyákovane okóvo íhikau Jesus neko kúxoti yutoéti ya emó'uke Itukó'oviti, enepone koêti: “Kuteâti koeku xunako yúku xoko oró'oe, énomonemaka koéneye njokóyoke ne ngotíxea ra yóvoku” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ina kíxo Jesus ne tutíhiko jûdeu: —Kutimo itukóvo iyupánevoti itíkinovike motovâti véxea tokópeovo kíxineye kuteâti ne ítikemeku? ");
INSERT INTO terNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ina kixovókoxoa Jesus: —Enepora sasá'iti óvoku Itukó'oviti, yusíkotimo ketáhineyi, itea kóyeanemo ngoéxepukopea ya kúveu mopo'âti káxe. ");
INSERT INTO terNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ina kixopâmaka jûdeuhiko: —Koaréntai sei koe xoénae ómone ra sasá'iti óvoku Itukó'oviti ina úso. Inípono yemó'u kéxepukopimo ya kúveu mopo'âti káxe —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Itea enepone sasá'iti óvoku Itukó'oviti kíxone Jesus yara yûho, koati mûyo kixópo, kene haina péti kíxo. ");
INSERT INTO terNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Exepúkopone ne Jesus ukópea xapa ivokóvoti, puyákoponeova okóvo íhikauhiko neko yûho vo'ókuke. Yoko kutípoanehiko ne yutoéti ya emó'uke Itukó'oviti yóko'o neko emo'u Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Koeku óvoheixeako Jesus ya Njeruzálem ya kaxénake áyui Páskoa, êno xâne kutipoâti vo'oku noíxeahiko ne iyupánevoti ítuke. ");
INSERT INTO terNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Itea ako akútipoa Jesus ikána'uxeahiko kutípea, vo'oku heú kíxea Jesus éxea isóneu neko xâne. ");
INSERT INTO terNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ako apásika ápeyea xâne etó'okoati koêku ne xanéhiko yara kúveu mêum, vo'oku heú kíxea Jesus éxea isóneuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ápe hóyeno koéhati Nikôdemu, koati teyonéti xapákuke tuti jûdeu. Yoko farîzeumaka nekôyo. Énomone ne koati yuixóvoti hókea yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Eneponeko hóyeno, pîho ya yóti noíxoponea Jesus. Hara kixóponoa: —Ihikaxotí, véxoa itúkeovo iti hána'iti ihíkaxoti páhoenovi Itukó'oviti, vo'oku enepone iyupánevoti ítike, ako íta xâne itúkea ákoti Itukó'oviti xokóyoke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ina kixôa Jesus: —Koati emo'úti ra yunzó'inopi, ivévaka: Enepomo hákoti inamápo ne xâne, ákomo omótova noíxopea natíxoku Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ina kixôa Nikôdemu: —Na kíxoaye inámapeako ne yékoteno xâne? Ápeikopo oxéne aúkopeovo okóvoike êno motovâti inámapeakomaka? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ina yumopâ Jesus: —Koati emo'úti ra yunzó'inopi, ivévaka: Koêkuti ákoti asasá'ipo ya xunákoke Sasá'iti Omíxone Itukó'oviti, ákomo omótova yonópea natíxokuke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Koati pó'iti koêku ne kalivôno ipuhíkea xoko êno, koane pó'itimaka koêku ne xâne iko'ínamakopa Sasá'iti Omíxone Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hákoikopo iyipáxova ra emó'uinombinoe kónokea inémapi, itínoe xâne yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Noixó íxea ne ihunóvoti. Koêkuti kahá'ayeaku ihúneovo, ihúnovo. Kémi emó'u, itea ako yéxa koati úkeaku, koánemaka yonópoku. Énomonemaka koéneye xoko uhá koeti xâne iko'ínamakopa Sasá'iti Omíxone Itukó'oviti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ina kixopâmaka Nikôdemu: —Na kixoâtiye koêku? ");
INSERT INTO terNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yane hara kíxoa Jesus: —Inípono itíkivo ihíkaxoti xanena ûti, uti íhae Izarâe! Yusíkoikopo ákoyea yéxa koêku ra kixovókuti? ");
INSERT INTO terNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Koati emo'úti ra yunzó'inopi, ivévaka: Enepone véxone, énomone koyúho ûti. Koane enepone noíxone ûti, énomonemaka koyúho ûti itúkeovo koati kaná'uti noíxone vûke, itea ako kali yakútipoanoe. ");
INSERT INTO terNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Koeku ákoyea yakútiponunoe enepo ngoyuhôa koêku ra kixovókuti yara kúveu mêum, ná'ikopomo kíxeaye kitípinu ongoyúhoinopea koêku ra kixovókuti vanúkeke? ");
INSERT INTO terNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ako noixóponoati rakoxo vanúke ákoti itukápa ne ukeâtiya. Yoko enepone íhae vanúke ikútipasikoponovoti xâne, énomone ra yuhó'ixopiti. ");
INSERT INTO terNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kuteâti koeku mekúke enepo koexépukoa Muîse neko okovo koéxoe ya tikótike yaneko mêum ákoti ovâti, motovâti íteovo neko xanéhiko ohónoe koéxoe, énomonemaka ngónoko ngíxeokononeye ya tikótike, undi íhae vanúke ikútipasikoponovoti xâne, ");
INSERT INTO terNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","motovâti ápeinoa inámapoti apéyeati ákotinemo hunókoku xoko Itukó'oviti ne uhá koeti koêkuti xâne kutipónuti —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Vo'oku yupíheovo ákoyea omótova okóvo Itukó'oviti ne xâne yara kúveu mêum, énomone pahúkinoa ne Xe'éxa, ákoti po'ínu, ivókinovahiko, maka hákone yonôpo ipihóponovokutike ne uhá koeti xâne kutipoâti, itea itúkapune xoko Itukó'oviti yonópohiko ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pahúkinoake Itukó'oviti ne Xe'éxa yara kúveu mêum, haina ipíhoponope xâne nê'e, itea énomone kutí'inoke itóvotihiko. ");
INSERT INTO terNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Enepone kutipoâti ne Xe'exa Itukó'oviti, ákomo ipíhapanakana. Itea enepone ákoti akutípoa, koati hoenáxovotine yonópeamo ipihóponovokutike, vo'oku ákoyea akútipoa ne Xe'exa Itukó'oviti, poéhane itukóvo xe'éxa ákoti po'ínu. ");
INSERT INTO terNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hara kutí'inoke ipihóponokonotimo. Simóne yara kúveu mêum ne Kouhápu'ikoti xâne, itea unatí'inoane xanéhiko óvoheixea hahákutike yaneko koúhapu'ikeokonohiko. Koáhati ainóvoti váhere ne ítuke. ");
INSERT INTO terNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yoko uhá koeti itúkoti váhere, koati puvâti ne uhapú'iti, ako ahí'akapa, puvâti éxeokono ne váhere ítuke. ");
INSERT INTO terNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Itea enepone xâne hokoâti ne kaná'uti kixovókuti, hane kahá'a óvoheixea uhapú'itike, motovâti iyúseyea kixoku ítuke itúkeovo hokoti Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Úkeane pího ne Jesus yoko íhikauhiko ya poké'exa Njúdeya. Óvanehikoya, koane áhikexea xanéhiko ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ahíkotimaka ne Xuaum Mbátita ya Énom xe'ókuke Sâlim. Koáhati óvoku êno úne, koane êno xâne pihinoâti áhikeovo. ");
INSERT INTO terNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yoko âvoti ika'ákapu ne Xuâum yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Po'íke káxe ápe íhikauhiko Xuâum yoko hóyeno jûdeu yumopókokoti vo'oku kixoku kasása'ikeovo xâne ya hó'eke. ");
INSERT INTO terNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ina kixopónohiko Xuâum: —Ihikaxotí, eneponeko hóyeno simópiti yovo'íko poixô'oke húveona Njôrdaum, enepone kíxene itúkeovo kúxone ûti símeamo, áhikexonemaka nê'e. Yoko yupihovó koe êno xâne pihinoâti. ");
INSERT INTO terNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ina yumopâhiko Xuâum: —Enepone ítone itúkea ne hóyeno, ákoni ákoeneye eneponi hákoti porexôa Itukó'oviti kíxeaneye ne ítuke. ");
INSERT INTO terNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kemónupepo yanekôyo enepo ngoyuhôa ákoyea itúkapu ûndi ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne. “Undi pohúneti inuxínoati koane koyuhó'inoati” ngoé'epepo. ");
INSERT INTO terNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Xapa kasâtuxoti, enepone hóyeno kaha'íneati ne noívana, énomone ne koyénoti. Kene ínikone ne koyénoti, anêko ayuítike, koati hána'iti elókeyea okóvo kamokénoyeati yûho ne koyénoti. Ngúteanemaka yara ngóyeku, elóketi ongóvo koeku itúkeovo énomone pihíno xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Inamá'axone motokêa mboké'exeokono koeku itúkeovo énomone ukopónoxo itúkeovo hána'iti teyonéti —kíxoanehiko Xuâum. ");
INSERT INTO terNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Enepone ukeâti vanúke, koati teyonéti ya uhá koêti. Kene ne ipuhíkeati yâye yara kúveu mêum, koati íhaene yâye, koane kixovókuti yara kúveu mêum koyúho, vo'oku hana'íneoxo ne ukeâti vanúke. ");
INSERT INTO terNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Enepone noíxoneya yoko kámoneya, énomone koyúho, itea ako koati kutipeâti emó'u. ");
INSERT INTO terNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Itea enepone xâne kutipeâti yûho, koati exókovoti kutípeamaka itúkeovo kaná'uti ne Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Vo'oku koati emo'u Itukó'oviti koyúho neko páhoe, koane ako íyuhixa Itukó'oviti poréxea ne Sasá'iti Omíxone ovo'ó kó'iyea. ");
INSERT INTO terNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ako omótova okóvo Itukó'oviti ne Xe'éxa. Énomone poréxo éxea koêku ne uhá koeti koekúti. ");
INSERT INTO terNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hukinóvoti ngó'iyea: Koêkuti kutipoâti ne Xe'exa Itukó'oviti, anêko xokóyoke ne inámati apéyeati ákotinemo hunókoku. Itea koêkuti kotiú'ikovoti ákoyea akáha'a kutípea, ákomo naíxa ne inámati apéyeati ákotinemo hunókoku xoko Itukó'oviti. Koati hoenáxovotine itúkeovo ipíhopononemo Itukó'oviti nê'e. ");
INSERT INTO terNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yoko éxoane Jesus eyékoxeane evo farîzeu koêku ne ítuke itúkeovo énomone yupihóvone íhikau koane áhiu ya Xuaum Mbátita. ");
INSERT INTO terNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Itea haina Jesus ne ahíkexo xanéhiko. Koati íhikauhiko ne ahíkexo.) ");
INSERT INTO terNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Énomone yaneko exoâne Jesus nê'e, ipúhikopeane Njúdeya, ina aukópovo ya Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Koeku káyukopeovo ya Ngalíleya, kónoko vekópeamaka poké'exake evo samarítanu. ");
INSERT INTO terNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Koeku vékea Jesus neko poké'e, simóne ya Síka, pítivokona evo samarítanu. Yoko ako ahíka ne poké'e póneake Njáko ne xé'a, enepone Yûse, yaneko mekúke. ");
INSERT INTO terNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Énomonemaka óvo íkoku Njáko. Momíne ne Jesus vo'oku yónea, ina ivatáko xe'ókuke ne ikokúti. Yoko ye'éxotine itúmukea káxe yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yanê'e, kenó'okone sêno íhae ne pitivóko ikopónoti úne. Ina kixôa Jesus: —Yokóseananu, peréxanu úne —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yoko áko'o neko íhikauhiko, pihó'iko pitivóko vanexóponoti nikokónoti. ");
INSERT INTO terNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ina kíxo Jesus neko seno samarítana: —Iti jûdeu, na koeti yépeminonu úne, undi sêno íhae Samâriya? —kíxoane. (Kó'inokeneye yûho, iyupáxovati neko yuhó'ixoati vo'oku púvea jûdeuhiko ne íhae Samâriya.) ");
INSERT INTO terNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ina kixôa Jesus: —Eneponi yexâ ne mani pónepike Itukó'oviti, epó'oxo itukóvotiye ra epemópiti úne, mani itíne epemónu, koane mani mborexópeati ne úne porexópitimo inémapi. ");
INSERT INTO terNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ina kixôa sêno: —Ako mbêritina heúkike ra úne, yoko koati upénoti ra ikokúti. Ná'ikopomo kíxeaye peréxinoa ne úne kíxene, enepone poréxoti xâne inámapea? ");
INSERT INTO terNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Koati teyonéti neko voxú'ikene Njáko porexó'oveati ra ikokúti. Énovane ra úne koánemaka xe'éxaxapa yoko peyóxapa. Ití'ikopo koati teyonéti yaneko voxú'ikene motó'inovake peréxinu koati únati úne yarâ'a? ");
INSERT INTO terNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ina yumopâ Jesus: —Koêkuti enovâti ra úne ukeâti ra ikokúti, kóyeanemo épekopeako úne. ");
INSERT INTO terNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Itea enepone enovâti ra úne mbôreu, koati eopâtimo kuteâti koeku xâne ákotinemo épekeaku úne, vo'oku enepone mbóneake, porexoâti inámati apéyeati ákotinemo hunókoku. Kutí koetimo uke úne vo'eroo vo'ero koyêti ákoti ítikeovoku ya xokóyoke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ina kôe neko sêno: —Peréxanaikopo ne úne kíxene maka hákone epékonu úne epó'oxo maka hákone ngayuíxovo íngea úne. ");
INSERT INTO terNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ina kixôa Jesus: —Ihéxikapanaikopo îme, ínamakamo yaukápapu yâye. ");
INSERT INTO terNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Ako îmam —koéne ne sêno yumopâ. Ina kixopâmaka Jesus: —Koati kaná'uteoxo ne yiûho ákoyea îme, ");
INSERT INTO terNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","vo'oku singu koéne îme, ina keno'óko ne hóyeno ovoti xikóyoke kó'oyene, hainámaka îme. Koati kaná'uteoxo ne yiûho. ");
INSERT INTO terNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ina kôe neko sêno: —Kutí'inonu iti porófeta, páhoe Itukó'oviti koyúhoyea emó'u. ");
INSERT INTO terNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yâye ya Samâriya oúke ra kali mopôi yóno voxúnoekene iháyu'ikoponea Itukó'oviti, uti samarítanu. Kene itínoe jûdeu, keyúhoanoe poéhayeane ya Njeruzálem yusíkea iháyu'ikoponea Itukó'oviti ne xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ina kixôa Jesus: —Senó, koati motovâti kitípi yunzó'inopi símeovone kaxéna ákoyeakunemo itúkapu yâye oúkeke ra mopôi, simóya yâkonoye ya Njeruzálem yóno xanéhiko iháyu'ikoponea Itukó'oviti, Ha'a ûti. ");
INSERT INTO terNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Itínoe samarítanu, ákonoe yexa ihéyu'iu. Kene ûti, uti jûdeu, koati vexoâti vo'oku xapákuke ûti, uti jûdeu úkea ne Koitóvoti xâne. ");
INSERT INTO terNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yé'exovone káxe ápeyeakumo koati kaná'uti iháyu'ikeokono Ha'a ûti íhae vanúke, epó'oxo turíxovone koeku kó'oyene. Enepone koati kaná'uti iháyu'ikeokono Itukó'oviti, konókoti ikána'uxeokono koeku itúkeovo ya inámapotike isóneu xâne vekínoa. Yoko énomonemaka kahá'ainoa Ha'a ûti íhae vanúke kíxeaneye ne xâne. ");
INSERT INTO terNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Enepone Itukó'oviti, ako mûyo, koane ako inixoâti. Hukinóvoti kónokea itúkeovo ya inámapotike isóneu xâne iháyu'ikea, ikaná'uxoati iháyu'ikea. ");
INSERT INTO terNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ina kixôa sêno: —Énjoa kenó'okeamo ne Mésiya koéhatimaka Kristu, páhoe Itukó'oviti koíteovo xâne. Enepo simané'e, kouhápu'ikinoveatimo uhá koêti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Undíne ne kíxene, undi yuhó'ixopiti —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Énomone yanê'e, apeké koépone neko íhikau Jesus. Iyúpaxovahiko vo'oku yúho'ixea Jesus neko sêno. Itea ako épemea âha xokóyoke kutí'inoke yuhó'ixoati. ");
INSERT INTO terNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kene ne sêno, kamoáne neko yuhó'inoa Jesus, kurí kixone pótena, ina kayukópovo ya pitivóko. Urúkopovane ne pitivóko, ká'aye kíxovokoxoa ne ko'óvokutiya: ");
INSERT INTO terNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Hingá, neíxapananoe ne hóyeno heu-heú kixoti koyúhoinonu ngoêku. Haináperamea ne Mésiya? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Úkeane ipuhíkea pitivóko neko êno xâne noixóponoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yoko koeku káyukopeovoiko pitivókoke ne sêno, hara kixo Jesus ne íhikauhiko: —Unaém, niké'evo. ");
INSERT INTO terNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Itea hara kíxovokoxoa Jesus: —Anéye nikokónoti nînga ákoti yexâ itukóvotiye —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kameáne íhikauhiko ne yûho, hara kixókoko: —Ápenemea ominoâti nîka? —kixókokone. ");
INSERT INTO terNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ina kixôa Jesus: —Hara indúko nînga, indúkea âha ne Pahukónuti yara kúveu mêum, yoko ngoúsexea ne itukéti pónenu indúkea. ");
INSERT INTO terNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ká'aye kéyenoe yara símoku ûti kó'oyene, “Koaturu koé'iko kohê âvoti, ínamo simâpu kaxena ítixovope ha'i nonéti” kéyenoe. Itea koati ngixópitinoe: Neímexa ratíke. Enepone xanéhiko, aínovo kutí koeti kavâne óvoku ha'i nonéti usó koyêtine ítixopinokono Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Enepone itixoâti, ápene êho ko'ítukeyea koeku kó'oyene, koane ákomo évakapu ne ítixone vo'oku hanekónomo xoko Itukó'oviti. Yoko ákomo hunókoku óvea xokóyoke. Hukinóvoti xané kíxeokoko elókeyea okóvo ne noâti koánemaka ne itixoâti. ");
INSERT INTO terNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Koati kaná'uti ne kixonéti koêti: “Ápe noâti ina keno'óko po'ínuhiko itixoâti” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mbahúkopinoe ítixi upánini ako itúkapu itínoe nôa. Ápe koati turixoâti ne itukéti, kene itínoe ihuínova ne ko'ítukeine —kíxovokoxoane Jesus neko íhikau. ");
INSERT INTO terNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Êno samarítanu íhae neko pitivóko kutípoti Jesus vo'oku yûho neko sêno, enepo etó'okoahiko heu-heú kíxea Jesus koyúhoinoa koêku. ");
INSERT INTO terNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yaneko noíxoponeaku Jesus ne samarítanuhiko, ítaikoa óveako xapákuke. Yane pí'a káxe ókoa Jesus xapákuke. ");
INSERT INTO terNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Enómaka po'ínuhiko xâne kutípoti Jesus kameáne yûho. ");
INSERT INTO terNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hara koe yuhó'inoahiko neko sêno: —Haina vo'oku yemó'u kutípinoa ûti, itea koati vo'ókuke ne emo'u Jesus, kámonene ûti xokóyoke, epó'oxo véxoaneoxo itúkeovo koati énomone ne Koitóvoti xanéhiko yara kúveu mêum —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Evesékone neko pi'âti káxe ókea xapákuke, úkeane aukópovo ne Jesus ya Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kó'inokeneye, koati kuteâti neko yuho Jesus, vo'oku énomone koyuhôa koêku ne porófeta koyúhoti emo'u Itukó'oviti, ákoyea teyoâti koatíke poké'exa. ");
INSERT INTO terNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Énomone yaneko káyukopeovoku ne Jesus ya Ngalíleya, ivávakopa xanéhiko, vo'oku noíxeahiko uhá koeti kixoku ítuke ya Njeruzálem ya kaxénake ayuíti, yónokumaka neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Úkeane kayukópovomaka ne Jesus yane kali pitivóko koéhati Kána ya Ngalíleya, xoko óvoku sá'iri'okopea úne ya víyum yanekôyoke. Yoko ápe hóyenoya ko'itúkeinoti nâti. Enepone hóyeno, ápe xé'a ka'aríneti ya Kafanâum. ");
INSERT INTO terNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Eyekóxoane neko hóyeno seópeane Jesus ya Ngalíleya ukópea Njúdeya, pihóne opósikoponea. Inixóponoane, ina epemôa xanépea motovâti koúnatikopinoa ne xé'a, vo'oku kahá'atine ivókeovo. ");
INSERT INTO terNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ina kixôa Jesus: —Enepo hákoti neixónoe hána'iti iyupánevoti índuke, hoénaxovope njunáko, ákomo kalíhuina kitípinu —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ina koe'íkomaka neko hóyeno: —Yokóseananu, yaxénaponu kó'oyene tumúneke ivókeovo ne njé'a —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ina kixôa Jesus: —Yaúkapapu yóvokuke. Unátipone ne xi'íxa, ákomo ivákapu —kíxoane. Koáne, pihópone neko hóyeno. Koati kutipoâti neko emó'uinoa Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Koeku pihópea koane kenó'okea ahínoehiko yâkeneye okótumonexoponea. Tokopânehiko xenékuke, éto'okoane unátipeane ne xé'a. ");
INSERT INTO terNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ina epemôa ókokune ôra yusíkopo neko xé'a. Yane hara kíxoane ahínoehiko: —Kiyakáxeke ya póhuti ôra etétukea ne otuko mûyo —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Puyaa kixóponovane okóvo neko hóyeno itúkeovo énomone ne ôra koyúhoinoaku Jesus unátipeane xé'a. Yane kutíponehiko Jesus ne hóyeno, koánemaka yêno, yoko uhá koeti oveâti óvokuke. ");
INSERT INTO terNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yoko enepora iyupánevoti ítuke Jesus, hoénaxovope xunáko, pí'apene koeku seópea ya Ngalíleya ukopeâti Njúdeya. ");
INSERT INTO terNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ikénepoke neko koekúti, simóvone kaxena áyui jûdeu ya hó'eke. Úkeane pího ne Jesus ya Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yoko ápe kali tángiya iháxoneti Mbétesda ya emó'uke jûdeu. Xe'ókuke pahapéti iháxoneti Vekoku Su'ûso óvo neko tángi. Yoko ápe singu koeti kálihunoe ngárpaum xe'ókuke neko tángi. ");
INSERT INTO terNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Énomone óvoheixo êno xâne ka'aríneti. Ápe komítitiya, koane mohéveu, koane isayú'ixovoti ákoti ehevákapu mûyo. ( ");
INSERT INTO terNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aínovo kuxoíxoti ovóxokeovo neko úne. Vo'oku ápe evésekeaku ánju, ovoxe Itukó'oviti ukeâti vanúke, ovoxókoati neko úne. Yoko koêkuti inuxó koeti kûrino'ekeova ne tángi koeku ovóxokeovo ne úne, énomone itovô ya aríne, koêkuti kó'iyeovoku arinéti yuvâti.) ");
INSERT INTO terNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Xapákuke neko ka'aríneti, ápe hóyeno tiríntai oitu koetíne xoénae ká'arine. ");
INSERT INTO terNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Noixoâne Jesus ya xoko tunúkuheixovoku, hara kíxoa: —Kehá'a ítivoa ne yaríne? —kíxoane. Yoko éxoane mekú'iyeane ká'arine. ");
INSERT INTO terNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ina yumopâ ne ka'aríneti: —Unaém, akó'oti ipíhonuti úneke enepo ovoxókovo ne úne. Koeku ngahá'ayea ûrungeova, ápe inuxó koeti ûrukeovo ya undíke. ");
INSERT INTO terNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ina kixôa Jesus: —Yexépukapa, viyápa ne peúke, yenápa —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Koati énomone yanê'e, itóvone neko hóyeno. Yane veyópone poúke, yonópone. Yoko sâputu yanekôyo, káxe koati sasá'itino jûdeuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hukinóvoti ápeyea tutíhiko jûdeu kixoâti neko hóyeno unatípotine: —Sâputu rakéne. Mani ákoti yusîka keínopi ra peúke kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ina yumopâ neko hóyeno: —Itea pahukónu enjépukopea ne koitóvonuti koane veyómbea mboúke yoko yonómbea. ");
INSERT INTO terNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ina kixopâmaka tutíhiko jûdeu: —Kutí'ikopo itukóvoye neko pahukópiti kíxineye? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Itea eneponeko hóyeno unatípotine, ako éxa itukóvotiye neko koitóvati vo'ókuke neko êno xanéya, yoko kûrivokoxopovane Jesus neko xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Avo áxu'ikene, tokópopanemaka Jesus neko hóyeno yane hána'iti imokóvokuti, ina kixôa: —Koati itévotine. Hákone pehukóvo mará'inamo yuvápapi arinéti yupihóvoti váherexea yane inúxoti yuvópiti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Úkeane aukópovo neko hóyeno xoko tutíhiko jûdeu, etó'okoponoati itúkeovo Jesus koitóva. ");
INSERT INTO terNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yane turíxovone okópea Jesus neko tutíyehiko, vo'oku ápeyea po'ínuhiko ítuke Jesus kuteâti, koúseumaka ya sâputu. ");
INSERT INTO terNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ina kixôa Jesus neko tutíhiko jûdeu: —Anéye ko'ítukeyea ne Nzá'a tukú koeti kó'oyene, ngoánemaka —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Vo'ókuke neko yuho Jesus, inamá'axo oposíkoa tutíhiko jûdeu koépekea. Vo'oku haina pohúneti itúkoti itukéti, kuteâti koíteovo xâne ya sâputu, itea vo'ókukemaka koyúhoyea itúkeovo Itukó'oviti itúko há'a. Yoko koati “Itûkovoti kuteátine Itukó'oviti nê'e” koêti isóneunoa tutíhiko jûdeu. ");
INSERT INTO terNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ina kixovókoxoa Jesus neko xanéhiko: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Ako ápahuina koekúti índone indúkea ya njunákoke. Poéhane noínjone itúkea Nzá'a, ene indúko. Kuteâti kixoku itúkeovo ne Nzá'a, énomonemaka indúko. ");
INSERT INTO terNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Éxokonoa Nzá'a uhá koeti koêku ne ítuke vo'oku ákoyea omótovonu okóvo, undi Xe'éxa. Epó'oxo exókonutimo po'ínuhiko koekúti índukeikomo koâti hána'iti yane pihotíne índuke, kutí'inoke hána'itimo iyípaxivoa. ");
INSERT INTO terNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kuteâti kíxoaku Nzá'a kóyukopea ivokóvoti porexoâti inámapea, kúteanemakamo ngíxoaku ingó'inamakopea koêkuti xâne ânja ngíxeaneye. ");
INSERT INTO terNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Hainamo Nzá'a exókopa yonópokumo ne xanéhiko, itea undímo exókopa yonópokumo, ");
INSERT INTO terNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","maka teyánune uhá koeti xâne kuteâti kixoku téyeahiko Nzá'a. Enepone ákoti teyânu, ákomaka teya Nzá'a, enepone Pahukónuti yâyeke. ");
INSERT INTO terNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Koati emo'úti ra yunzó'inopinoe, ivévaka: Koêkuti kamoâti ra emó'um epó'oxo kutipoâti ne Pahukónuti yara kúveu mêum, ápene xokóyoke ne apéyeati ákotinemo hunókoku. Ákomo ipíhapanakana. Ipúhikopeane xêne yonópoti ipihóponovokutike. Koati vekopâti ne xêne yonópoti xoko inámapoti apéyeati ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","—Koati emo'úti ra yunzó'inopinoe, ivévaka: Yé'exovone ne káxe kámeakumo emó'um ne xanéhiko kutí koeti ivokóvoti, enepohikone evókovoti ya váherevoko, yoko turíxovone yara koeku kó'oyene. Koêkuti mihe'ókinoati kêno ne emó'um, undi Xe'exa Itukó'oviti, apêtimo inámati apéyeati xokóyoke ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kuteâti itúkeovo xoko Nzá'a úkea inámapoti apéyeati ákotinemo hunókoku, poréxonoa Nzá'a itúkeovo njokóyokemaka úkea nê'e, undi Xe'éxa. ");
INSERT INTO terNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Poréxonumaka énjokopeamo yonópoku ne xanéhiko hunókokuke ra mêum, vo'oku undíne ne íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","—Hákonoe iyipáxova râ'a, vo'oku harakénemo káxe kámeakumo emó'um ne uhá koeti ivokóvotine xoko ekóxopokonoku, yoko exepúhikopotinemo kamáne. ");
INSERT INTO terNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Enepohikone únati kixoku itúkeovo, exepúhikopinotimo yonópea xoko Itukó'oviti. Kene ne váherehiko kixoku itúkeovo, exepúhikopinotimo yonópea ipihóponovokutike. ");
INSERT INTO terNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ina koe'íkomaka ne Jesus: —Ako ápahuina koekúti índone indúkea ya njunákoke. Enepo enjákapane yonópokumo ne xanéhiko, hane nzóko kuteâti ngámone xoko Nzá'a. Énomone kutí'ino koati ponóvoti ne ngíxoakumo enepo enjákapane yonópokumo ne xanéhiko, vo'oku ako ambásika indúkea ânja, itea ahá'inonu Itukó'oviti, enepone Pahukónuti yara kúveu mêum, ene indúko. ");
INSERT INTO terNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Eneponi itukápuxo póhutine ûndi ixomo koyuhópovo itúkeovoxo ne kaná'uti Xe'exa Itukó'oviti, ákoni okónoko kutípeokono ne yûnzo. ");
INSERT INTO terNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Itea ápe po'i koyuhónuti indúkeova, yoko énjoa itúkeovo koati kaná'uti ne yûho vo'ónguke. ");
INSERT INTO terNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pehúkonoe epemó'ikoponoti Xuaum Mbátita, yoko koati koyuhó'inopeati ngoêku kaná'uyeoxo indúkeova. ");
INSERT INTO terNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ako ongónoko xâne koyúhoti indúkeovo kaná'uti itea ngoyúhoinopeakenoe ra koekúti, ngaha'aînopiti itíkivonoe ngoítovone. ");
INSERT INTO terNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Kuteâti koeku ihúveti lámpada koúhapu'ikea, énomone koéneye ne Xuaum Mbátita. Epó'oxo ápe ye'aa koeti káxe usó kéyeyiku keúhepekivo yane uhapú'iti omínoke xâne. ");
INSERT INTO terNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Itea anéye koekúti koyuhónuti, hána'iti yane koyúhoyeonuke Xuâum. Énomone ra itukéti pónenu Nzá'a indúkea. Enepora koekútihiko índuke, énomonemaka koyuhónu pahúkeonu yâyeke ne Itukó'oviti Nzá'a. ");
INSERT INTO terNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Koati Nzá'a koyuhónu indúkeovo kaná'uti páhoe, itea ako kémiku emó'u nê'e. Ákomaka neíxiku, ");
INSERT INTO terNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","epó'oxo áko'omaka ne emó'u xikóyokenoe vo'oku ákoyea yakútiponu, undi páhoe. ");
INSERT INTO terNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Koati ihíkexovatinoe ne yutoéti emó'uke Itukó'oviti pe'okoâti itéponimo ne apéyeati ákotinemo hunókoku xoko Itukó'oviti vo'ókuke. Yoko ainovó koe ûndi koyúho neko yutoéti. ");
INSERT INTO terNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Itea kóyeane ákoyea yakáha'a kitípinu, undi mani kutí'inoke apêti xikóyokenoe ne inámapoti apéyeati ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—Haina ngahá'ati ihayú'ikonuti xapa xâne yara kúveu mêum ngixínopikeneye. ");
INSERT INTO terNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kene pó'iti iséneu, vo'oku énjoa áko'oyea xikóyokenoe ne hána'iti ákoyea omótovovi okóvo Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iháke Nzá'a nzímea, itea ákonoe yakútiponu. Enepo kena'áka po'i xâne ákoti itukapu páhoe Nzá'a, itukapu isóneupinovo hóko, énomoneoxomo kitípo. ");
INSERT INTO terNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Na kixoâtiye kitípinu? Koáhati itínoe oposíkoti itúkeovo kapáyasokone xanéhiko yara poké'e ya koêkuni yopósi'ixi itíkivo kapáyasokone ne kaná'uti Itukó'oviti ákoti po'i kuteâti. ");
INSERT INTO terNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Hako kalihú'ina ápeyea iséneuke ngoyúhoyeamo nonékuke Nzá'a ákoyea aúnati ne ítike. Koati Muîse koyuhópinoemo nonékuke, enepone kivóvone. ");
INSERT INTO terNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Vo'oku eneponi akaná'uxo kitípinoe Muîse, manímaka kitipónuti. Koáhati ûndi koyúho nê'e. ");
INSERT INTO terNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Itea koeku ákoyea yakútipoa yútoe nekôyo, ná'ikopomo kíxeaye kitípi yûnzo? —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ikénepoke, ina taru'úxopamaka evo Jesus neko mar-na Ngalíleya, iháxonetimaka mar-na Tibêriyade. ");
INSERT INTO terNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yupíhova êno xâne hokó'ixoati, vo'oku noíxea ne hána'itihiko iyupánevoti ítuke koitóvo ka'arínetihiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ina pího ne Jesus oúke kali mopôi, ivâtakoane. Íhikauhiko xáne. ");
INSERT INTO terNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yoko yé'exovone kaxena Páskoa, áyui jûdeuhiko hó'eke. ");
INSERT INTO terNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ina noiméxo ne Jesus, yane noíxone êno xâne keno'ókinoati. Ina kíxo Filípi: —Námeamo vanéxea uti pâum, mani nîka ra êno xâne? ");
INSERT INTO terNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Itea hixópoti Filípi kó'inokeneye yûho, vo'oku éxoane Jesus kíxoakumo. ");
INSERT INTO terNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ina yumopâ Filípi: —Mani konókoti uti ênoti tiûketi kuteâti pi'âti séndu pe'u tiûketi, itea kóyeaneni ákoyea víta'uxa —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Apé koene yuho po'i íhikau Jesus koéhati Ándere, po'inu Símaum Pêturu. Hara kôe: ");
INSERT INTO terNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Anêko hóyeno kalivôno apêti singu koeti paúna, ítuke sévada, yoko pi'âti kálihunoe hôe. Itea kutimo itópono nonékuke ra êno xâne? ");
INSERT INTO terNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ina kixoáhiko Jesus: —Pehúkaikopo ivátahikea ne xâne. Yoko ápe uhé'ekoti kálihunoe ngaráma yane ivátahikoku. Kalíhanini itóponea singu koeti mili hóyeno neko êno xâne. ");
INSERT INTO terNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yane véyoane Jesus ne pâum. Uke'éxone íkoro'ixeovo xoko Itukó'oviti vo'ókuke, ina pahukôa pôrekexeovo ne xanéhiko. Kúteanemaka kíxoaku ne hôe. Yane ítoponovohiko neko xâne, koêkuti yé'akeye âha níkea. ");
INSERT INTO terNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Imatáxovonehiko, ina kixôa Jesus ne íhikauhiko: —Ítixepa ne itátanehiko, hâxa ra nikokónoti, mará'inamo évakapu —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ina itixópahiko neko itátane, kopúhikopoikomaka nduse koeti sésta, hâxa neko nikotíhiko ukeâti neko singu koeti kali pâum ítuke sévada. ");
INSERT INTO terNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Enepohikoneko noixoâti ne hána'iti iyupánevoti ítuke Jesus, hara koéhiko: —Koati énomone porófeta kúxone ûti símeamo yara kúveu mêum râ'a —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yoko éxeane Jesus isóneuhiko, kahá'ayea matitipenó kixópeahiko omópea, kaha'âtihiko itúkea natína. Itea Jesus, ako akahá'a. Yane pohú koéne káyukopeovo oúke neko mopôi. ");
INSERT INTO terNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yaneko hahaméne, píhohikopo neko íhikau Jesus xe'ókuke ne mar. ");
INSERT INTO terNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ivú'ixopohiko vatéke yonópotihiko poixô'oke, íyeukepo pítivokona Kafanâum. Yoko yotíxone, avo seápa Jesus xapákuke. ");
INSERT INTO terNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yane turíxovone ovóxokeovo ne úne vo'oku xúnati ihunóvoti. ");
INSERT INTO terNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Itoné'e vatékexeahiko kuteâti singu koetímea, áko'o sei koetímea kílomituru, apé koéne noíxonehiko inúkuke úne yoneâti íyeuke vatékena. Yane yupihovó koene píkeahiko. Yoko koati Jesus noíxohiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ina kixovókoxoa Jesus: —Hákonoe píke, undíneye —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yane úhepepone isóneuhiko koeku ûrukeova Jesus kúveuke vatéke. Énomone yanê'e, hú koéne símea xoko yónokuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yaneko po'ípone káxe, enepohikoneko xâne irikóvoti poixô'oke mar, ivávakoa ákoyea axénapoa Jesus neko íhikauhiko yaneko ivú'e. Ivávakoamaka ákoyea po'inu ivú'eti ivú'epo Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yanê'e, sîmo po'ínuhiko vatéke ukeâti pítivokona Tibêriyade. Enepone símoku, ako ahíka neko óvoheixoku níkeahiko pâum ike íkoro'ixinevo Jesus xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Noixôa xanéhiko áko'oyea Jesus-ya koane íhikauhiko, yane ivu'í kíxoanehiko neko vatéke simôti, pihotínehiko ya Kafanâum oposíkoponoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Itopónoane ya poixô'oke mar, hara kíxoahiko: —Ihikaxotí, ná'aye sími yâyeke? ");
INSERT INTO terNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ina kixovókoxoa Jesus: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Haina vo'ókuke ne iyupánevoti neíxonenoe indúkea yopósikinonu, itea koati vo'ókuke ne nikokónoti nîke koimátaxopitinoe. ");
INSERT INTO terNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Hako itukovo nikokónoti ákoti oríko uké'eyea kéxuna'ixinovo, itea hane kéxuna'ixinapu nikokónoti ákoti auké'e, enepone omínoti xâne inámati apéyeati ákotinemo hunókoku. Yoko énomone ne nikokónoti mbónepikenoe, undi íhae vanúke ikútipasikoponovoti xâne. Anéye ítukeinonuke Itukó'oviti Nzá'a, exókoti xâne indúkeova ne ngixínopike —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ina kixôa xanéhiko: —Kutí'ikopo kónoko vitúkea motovâti vitúkea ahá'inovi Itukó'oviti? ");
INSERT INTO terNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ina yumopâ Jesus: —Hara ahá'inopi Itukó'oviti kitípinu, undi páhoe. ");
INSERT INTO terNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ina kixopâmaka xanéhiko: —Namo kó'eye iyupánevoti ítike, hoénaxovope xináko, motovâti noíxea ûti koane kutípeopi ûti? Kutí'ikopomo itíkoiko? ");
INSERT INTO terNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yanekôyo, níkoa voxúnoekene neko mána yaneko mêum ákoti apêti, kuteâti koêku ne yutoéti ya emó'uke Itukó'oviti, enepone koêti: “Porexo xanéhiko nikokónoti ukeâti vanúke” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ina yumopâ Jesus: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Haina Muîse porexópeanoe ne nikokónoti íhae vanúke, itea enepone koati kaná'uti nikokónoti ukeâti vanúke, Nzá'a porexópeanoe. ");
INSERT INTO terNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Vo'oku enepone nikokónoti poréxopike Itukó'oviti, énomone ra ukeâti vanúke iko'ínamakopoti xâne yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ina kixôa xanéhiko: —Unaém, peréxaveakopo uhá koeti káxe ne nikokónoti kíxene. ");
INSERT INTO terNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ina kixovókoxopamaka Jesus: —Undíne itukóvo ne nikokónoti poréxoti xâne yara kúveu mêum inámapea. Enepone simôti njokóyoke, kutí ngixoâtimo kuteâti xâne itopónovoti níkea ákotinemo épekeaku hímakati. Koane kutí koetimo xâne itopónovoti énoyeovo úne ákotinemo épekeaku úne. ");
INSERT INTO terNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Itea ngoyúhoinopeanenoe ákoyea yakútiponu upánini neíxonu. ");
INSERT INTO terNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Uhá koeti koêkuti xâne pónenu Nzá'a kutípeonu, énomonemo simonû. Yoko enepone xâne simónuti, ákomo kalíhuina nguríkea. ");
INSERT INTO terNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Vanúke úngea. Haina nzimínoti indúkea ânja, itea nzimínoti indúkea ahá'inonu ne Pahukónuti yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yoko hara ahá'inonu ne Pahukónuti yâyeke ákoyea ápahuina évoem xapákuke ne uhá koeti xâne poréxonuke kutípeonu. Yoko ngoexépukopatihikomo enepo simapúne hunókoku ra mêum. ");
INSERT INTO terNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Vo'oku koati ahá'inoahiko Nzá'a ápeinoa inámati apéyeati ákotinemo hunókoku ne uhá koeti noixónuti koane kutipónuti, undi Xe'éxa. Yoko ngoexépukopatihikomo simapúne hunókoku ra mêum —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yane kapáhakinova jûdeuhiko ne Jesus vo'ókuke neko yûho itúkeovo nikokónoti ukeâti vanúke. ");
INSERT INTO terNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hara kixókokohiko vo'ókuke: —Eneporâ'a, hainá'ikopo Jesus xé'a Yûse? Hainá'ikopomaka véxone ne há'a yoko êno? Ná'ikopo koeti koyúhoino kó'oyene itúkeovo ukeâti vanúke? —kixókokohiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ina kixovókoxoa Jesus: —Hákonoe kepahákinova ra yûnzo. ");
INSERT INTO terNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ako ápahuina xâne motovâti símeonu enepo hákotimo itukovo ísimonuke Nzá'a, enepone Pahukónuti yâye, epó'oxo ngoexépukopatihikomo simapúne hunókoku ra mêum. ");
INSERT INTO terNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hara kôe ne yútoe porófeta koyúhoti emo'u Itukó'oviti mekúke: “Ihíkaxotimo heú koeti xâne ne Itukó'oviti” kôe. Hukinóvoti itúkeovo simónuti ne uhá koeti xâne poréxonuke Nzá'a kámea koane éxea koêku ne ihíkauvoti íhae xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ako xâne noixoâti ne Nzá'a. Poéhane ûndi noixôa, undi íhae xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Koati emo'úti ra yunzó'inopinoe, ivévaka: Enepone kutipónuti, ápeinoane ne inámati apéyeati ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Undíne itukóvo ne nikokónoti poréxoti xâne yara kúveu mêum inámapea. ");
INSERT INTO terNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Enepone yoxúnoekene, níkoa neko mána yane mêum ákoti apêti, itea kóyeane ívohikeovo. ");
INSERT INTO terNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kene ne nikokónoti ngixínopikenoe, énomone ne evesékeati vanúke porexoâti ne uhá koeti xâne nikoâti ákoyea uké'exa pevóti. ");
INSERT INTO terNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Undíne itukóvo ne nikokónoti evesékeati vanúke poréxoti xâne inámapea. Koêkuti nikoâti, apêtimo inámati apéyeati xokóyoke ákotinemo hunókoku. Yoko enepora nikokónoti mboréxoake ne xanéhiko yara kúveu mêum motovâti ingó'inamakopea, énomone ra mûyom —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Koati okopókokoti isóneunoa jûdeuhikoya. Hara kixókoko: —Namo kíxoaye níkaxeovi nau mûyo ra hóyeno? ");
INSERT INTO terNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ina kixovókoxoa Jesus: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Enepomo hákoti kutí kixêa nikokónoti ra mûyom, koane hákoti kutí kixêa ekâti ra indína, undi íhae vanúke ikútipasikoponovoti xâne, áko'omo xikóyokenoe ne inámati apéyeati ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Itea koêkuti kutí kixoâti nikokónoti ra nau mûyom, koane koêkuti kutí kixoâti ekâti ra indína, énomonemo apê ya xokóyoke ne inámati apéyeati ákotinemo hunókoku, koane ngoexépukopatimo enepo simapúne hunókoku ra mêum. ");
INSERT INTO terNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Vo'oku kuteâti koeku koati únati nikokónoti yoko ekâti, énomonemaka koéneye ra mûyom yoko indína. ");
INSERT INTO terNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Koêkuti xâne kutí kixoâti nikokónoti ra mûyom, koane koêkuti kutí kixoâti ekâti ra indína, inámapotike apéyeati ukeâti ya njokóyoke óvoheixo, yoko anêngomaka xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kuteâti koeku itúkeovo úkeaku uhá koeti apéyeati ne Nzá'a, enepone Pahukónuti yâyeke, epó'oxo kuteâtimaka ínzuinovo xunako Nzá'a ya uhá koeti ngixoku indúkeovo, énomonemakamo ngoéneye indúkeovomo ukínoaku ne inámati apéyeati ákotinemo hunókoku ítuke ne xâne kutí kixónuti nikokónoti. ");
INSERT INTO terNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Anéye ra nikokónoti evesékeati vanúke. Yoko yupíhova ákoyea malíke'eka neko nikokónoti, nika yoxúnoekene. Vo'oku enepohikonê'e, níkoa yanekôyoke, itea kóyeane ívohikeovo. Itea koêkuti xâne nikoâti ra nikokónoti ngixínopikenoe, apeínoatimo apéyeati ákotinemo hunókoku xoko Itukó'oviti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yoko sinâgogake, enepone íhikaxovoku hó'e jûdeu, óvoheixo ne Jesus ya Kafanâum ixómoti ihíkaxo enepo koyuhôa ra koekútihiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kamoánehiko neko yûho Jesus, êno xâne xapákuke neko hokoâti koêti: —Tiú'iti emo'úti yûho râ'a. Kutí'ikopomo itôa kámokenoyea? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yoko exó kíxeane Jesus isóneuhiko ákoti koyuhó'inoati. Éxoa kapáhakinova neko yuhómeku. Hukinóvoti kíxeahiko: —Koati poe'aînoati iséneu ne yunzómeku, haîna? ");
INSERT INTO terNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ná'ikopomeamo kó'eye iséneunonu, undi íhae vanúke ikútipasikoponovoti xâne, enepo neixánu aúngopeovo xoko úngeaku, enepone óvonzeixoku inúxotike? ");
INSERT INTO terNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Koati isoneûtike véko inámapea ne xâne, kene haina nautíke ngíxo. Enepora yunzó'inopinoe, énomone iko'ínamakopo xâne, porexoâtimaka inámapoti apéyeati ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Itea kóyeane ápeyea ákoti akutíponu xepákukenoe —kíxovokoxoane Jesus. Yoko éxoane Jesus ukeâti inâ apê hokoâti, itukóvotiye ne ákoti akutípoa xapákuke neko xâne, koane itukóvotiye ne itûkoheovoti koeku hókea, enepone kurikoâtikomo xoko xanéhiko puvâti. ");
INSERT INTO terNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ina kixovókoxopamaka Jesus: —Énomone ngixínopikenoemeku ákoyea ápahuina simónuti, enepo hákoti itukovo Nzá'a porexôa símeonu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Vo'ókuke neko yuho Jesus, êno xâne xapákuke neko hokoâti kurikópati hókea. Ákone axénaheixahiko. ");
INSERT INTO terNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ina kixovókoxoa Jesus neko nduse koeti íhikau: —Kene itínoe, kehá'amaka kiríki hékinu? ");
INSERT INTO terNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ina yumopâ Simaum Pêturu: —Unaém, kutí'ikoponi hakápa ûti? Poéhane xikóyoke kámea uti emo'úti poréxoti xâne inámati apéyeati ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kutípopi ûti, epó'oxo véxoa itúkeovo îti ne Sasá'iti Páhoenovi Itukó'oviti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ina kixovókoxoa Jesus: —Koáhati ûndi noivókoxopinoe, itínoe nduse koêti, itea kóyeane ápeyea póhuti xepákukenoe koati ovoxe Ndeâpu —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yoko Njûda kíxo, enepone xé'a Simaum Iskarióti, vo'oku énomone itukóvo neko kuríkotimo Jesus xoko xanéhiko puvâti. Yoko koatímaka po'ínu íhikau Jesus nê'e xapákuke neko nduse koêti. ");
INSERT INTO terNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ikénepoke ra koekútihiko, ehákoa Jesus ne pitivókohiko ya Ngalíleya. Opósikoa ákoyeane píhaheixa ya Njúdeya, vo'oku ápeyea tutíhiko jûdeu oposí'ixoati kíxoaku koépekea. ");
INSERT INTO terNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yoko ákone ahíkapu kaxena áyui jûdeu ya hó'eke iháxoneti áyui Tabenákulu. ");
INSERT INTO terNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ina kíxo Jesus ne ámeno: —Hákone yovóheixo yâyeke. Pîhe ya Njúdeya motovâti noíxeamaka ítikevo ne hokópitiya. ");
INSERT INTO terNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vo'oku enepone kahá'ati ipúhikea îha xapákuke xâne, ako yusíka he'onó kíxea ko'ítukeyea. Koeku itíki itukéti kuteâti ne ítike, yéxakapu uhá koeti xanéhiko —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Muhíkinova neko ámeno Jesus, ako akútipoa itúkeovo ukeâti xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ina kixoáhiko Jesus: —Avo simápu kaxena mbíhea. Kene itínoe, koêkuti kehá'ayiku píhi, motóva píhi. ");
INSERT INTO terNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ako omótova púveopinoe ne xanéhiko yara kúveu mêum. Kene ûndi, puvónuhiko vo'oku ngaúhapu'ikinoa váherevoko. ");
INSERT INTO terNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pihénenoe ayuítike, itea avo mbîha vo'oku avo simápu kaxena mbíhea —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Koyuhoâne Jesus nê'e, ôvaikone ya Ngalíleya. ");
INSERT INTO terNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ikénepoke píhine ne ámeno Jesus ayuítike, pihónemaka ne Jesus. Mayane he'onó koeti píhea puvâti noíxeokono. ");
INSERT INTO terNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yoko oposí'ixotine Jesus ne tutíhiko jûdeu apêti ayuítike. —Námea nê'e? —kixókokohiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ako tôpi koeku yûho neko êno xâne vo'ókuke. Hara kôe po'ínuhiko: —Itípakovoti ne hóyeno. Itea hara kôe po'ínuhiko: —Áko'o, koati aupú'ikoti xanéhiko nê'e —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Itea he'ono'ú koeti koyúhoyeahiko vo'oku píkea tutíhiko jûdeu. ");
INSERT INTO terNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yoko simotíne kûku ne ayuíti, enepone póhuti sêmana yónoku. Yane pihóne ne Jesus íhikaxea ya témpulu, enepone hána'iti imokóvokuti. ");
INSERT INTO terNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iyúpaxova tutíhiko jûdeu. Hara koe yûho vo'ókuke: —Enepora hóyeno, ako íhikauvo. Ná'ikopo kíxoaye éxea uhá koêti ra koekúti? ");
INSERT INTO terNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ina kixovókoxoa Jesus: —Enepora ihíkauvoti ínzikaxone, haina ukeâti ya njokóyoke. Koati ukeâti xokóyoke ne Pahukónuti ngoyúhoyea emó'u. ");
INSERT INTO terNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Enepone kahá'ati itúkea aha Itukó'oviti, exoâtimo koêku ra ihíkauvoti itúkeovo koati ukeâti ya xokóyoke, áko'o itúkeovo njokóyoke úkea. ");
INSERT INTO terNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","—Enepone xâne koyúhoti isoneú kíxone, koati oposí'ixoti iháyu'ikeokono, itea enepone oposíkoti iháyu'ikea ne pahukoâti, énomone kana'û yûho, koane ako semékekexa yûho nê'e. ");
INSERT INTO terNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Koati Muîse porexópeanoe ra Ponóvoti Kixovókuti, haîna? Itea ako ápahuina xâne xepákuke itukoâti. Na koeti yopósikino képekinu? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ina yumopâ xanéhiko: —Koatímea urúkovopiti ndémoniu koesáyu'ixoti iséneu, ikítixinake apêti kahá'ati koépekeopi —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ina kixovókoxoa Jesus: —Poéha iyupánevoti índuke, yane heú kénoe iyípaxivoa. ");
INSERT INTO terNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Koeku itúkeovo páhoenopinoe yútoe Muîse sirkunsidá kíxi hóyeno kalivôno, muhíkova itukovo ya sâputu iríkeovo kónokea sirkunsidá kíxi, kóyeane itíkinoe. Yoko haina ukeâti xoko Muîse nê'e, itea koati ukeâti xoko voxúnoekene, enepone turi viyénoxapa. ");
INSERT INTO terNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Koeku sirkunsidá kíxi kalivôno ya sâputu motovâti koúsokeovo neko páhoenopi Muîse itíki, ná'ikopo koeti ímeikinovonu koeku ngoíteovo hóyeno ya sâputu, mborexoâti heú kó'iyea unátipea ákotine yuvâti? ");
INSERT INTO terNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Hako keyuhôa itúkeovo pahukóvoti ne ínixene itúkeovo ákoti aunáti, hákoti yexôa koêku. Konókoti yopósiki póneovoxo iséneunoa inúxotike tumúneke keyúhoyi —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yane ápe íhaehiko Njeruzálem koêti: —Haina énomone opósiuti koépekeokono râ'a? ");
INSERT INTO terNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yokómoma, koati anéyetine xapákuke xanéhiko yoko ákone saya'íkoati. Hainámea kutipoâtine inuxínovitihiko itúkeova ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne? ");
INSERT INTO terNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Itea koati vexoâti úkeaku râ'a. Enepomo síma ne Mésiya, ákomo exeâti úkeaku —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Koeku íhikaxea Jesus yane témpulu, kóhonoko emó'u kó'iyea: —Ikítixatinoe yexónuti koane yexoâtimaka ne úngeaku? Haina nzimínoti indúkoponea ânja, itea enepone Pahukónuti nzímea, koati kaná'uti nê'e yoko ákonoe yéxa. ");
INSERT INTO terNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Poéhane ûndi exôa, vo'oku itúkeovo úngeakune xokóyoke, yoko énomonemaka pahukónu nzímea —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yanê'e, mani ika'ákoti Jesus ne tutíhiko jûdeu, itea ako kíxoakuhiko vo'oku âvoyea simápu kaxena namúkeokono ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Itea kóyeane enó'iyea kutípoti Jesus xapákuke neko êno opoíkovoti xâne kamokénoati. Hara koe yuhóhiko vo'ókuke: —Enepo simané'e ne Mésiya, enepone iyupánevoti ítukemo, anu'úkoatiperameamo xunáko ítuke ra hóyeno? Koati énomone nê'e —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kameáne farîzeuhiko kixoku koeku yûho ne xanéhiko vo'oku Jesus, ina pahukôa neko koyónotihiko hána'iti imokóvokuti iká'akoponea Jesus. Yoko kaha'iné kixómaka farîzeu ne tutíhiko sasedóti inuxínoti jûdeu hó'eke pahúkea neko ika'ákoponoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ina kôe ne Jesus: —Ákonemo ánju'ikene xepákukenoe, yane mbihópotinemo xokóyoke ne Pahukónuti yâye yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yoposíkonutinoemo, itea ákonemo ínixepananu. Koáne, ako omótova yéni xoko yonómboku. ");
INSERT INTO terNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ina kixokóko ne tutíhiko jûdeu: —Ná'ikopomeamo yonópo râ'a ákoinokenemo vínixapana? Yonópotiperameamo xapákuke viyénoxapa kurivókoxopovoti xâne po'íkehiko poké'e motovâti íhikaxeamaka xâne ákoti itukapu viyéno jûdeu? ");
INSERT INTO terNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kutí'oxomea kíxo enepo koyuhómeku: “Yoposíkonutinoemo, itea ákomo ínixepananu” koáne “Ako omótova yéni xoko yonómboku” koeméku? —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yaneko káxe hunókoku ne ayuíti, enepone koati teyonéti káxe, xe'ó koéne ne Jesus kóhonokea emó'u koyúhoyea xapa xâne. Hara kíxovokoxoa: —Enepone xâne eopâti kuteâti eópone ne épeu úne, kená'akapane njokóyoke maka ítapanapune yane mbóneakemo, kuteâti koeku xâne itopónovoti ya úne. ");
INSERT INTO terNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Koêkuti kutipónuti, haramo koéneye xokóyoke ne mbóneake porexoâti inámapea, koati êno hunôti úne ákoti áka, kuteâtimaka koyúhoyeovo emó'uke Itukó'oviti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yoko koati koyuhó'iyeati Jesus koêku ne Sasá'iti Omíxone Itukó'oviti, námoemo ne kutípotihiko Jesus. Vo'oku avo pahúkakana nê'e ya koeku âvoyea pihápa vanúke ne Jesus, koeku âvoyea itúkapumaka hána'iti ihayú'iutiya. ");
INSERT INTO terNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Xapákuke neko êno xâne kamokénoyeati emó'u, ápehiko koêti: —Koati énomone porófeta kúxone ûti símeamo râ'a. ");
INSERT INTO terNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ina koehíkomaka po'ínu: —Koati énomone Mésiya râ'a, enepone páhoe Itukó'oviti koíteovo xâne. Ina apémaka po'ínuhiko koêti: —Yusíkoikopo itúkeovo ukeâti Ngalíleya ne Mésiya? ");
INSERT INTO terNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ákoikopo okóyuhoa emo'u Itukó'oviti koêku ne Mésiya itúkeovomo ámoripono Ndávi, enepone teyonéti natina viyénoxapa mekúke? Ákoikopomaka okóyuhoa itúkeovo Mbélem, úkeakumaka Ndávi, ipúhikomo? —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yane koati haxakeôvokokoti ne xanéhiko vo'oku Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yoko xapákuke neko xâne, ápe kaha'âti iká'akea, itea akó'oti kíxoakuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yane kayuké koépone ne koyónoti hána'iti imokóvokuti xokóyoke ne tutíhiko sasedóti inuxínoti jûdeu hó'eke koáne xoko farîzeuhiko. Ina kixôa pahukoâtihiko: —Na koeti ákoino yamápanoe? ");
INSERT INTO terNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ina yumopâhiko: —Ako po'i xâne itopónoati unako koyúhoyea ne hóyeno. ");
INSERT INTO terNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ina kixôa farîzeuhiko: —Hainámaka aupú'ikopitinenoe ne hóyeno? ");
INSERT INTO terNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ako kutipoâti nê'e xapákuke ûti, uti pahúkotihiko yoko uti farîzeu. ");
INSERT INTO terNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kene ne xanehí koêti hokoâtine, enepohikone ákoti exâ ne Ponóvoti Kixovókuti hó'e ûti, kayumákapunehiko. Poéhane ipíhoponeokonohikomo nê'e —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yoko eneponeko Nikôdemu noixóponoti Jesus yanekôyo, koati póhuti xapákuke neko farîzeuhiko. Hara kíxovokoxo po'ínuhiko: ");
INSERT INTO terNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Yane Ponóvoti Kixovókuti hó'e ûti, yusíkoikopo tumuné kó'iyea koyúhoyeovo kónokea ipíhoponeokono ne xâne koeku âvoyea paréxakana koyúhoyea? koeku ákoyeamaka vakámokenoyea koêku ne ítuke? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ina yumopâ po'ínuhiko farîzeu: —Ití'ikopomaka íhae Ngalíleya, ketíxinoake? Íhikexapa ne yutoéti emó'uke Itukó'oviti, yane neixoâtimo ákoyea ápahuina porófeta koyúhoti emo'u Itukó'oviti ukeâti Ngalíleya —kíxoanehiko. ( ");
INSERT INTO terNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yane píhohikopone óvokuke póhutihiko neko xâne. ");
INSERT INTO terNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kene Jesus, hane yonópo xoko kali mopôi iháxoneti Olívera. ");
INSERT INTO terNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yuponíne ina kayukópovo hána'itike imokóvokuti ya Njeruzálem, koane pihínoa uhá koeti xâne. Yane ivátakone Jesus koane íhikaxea xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yoko ápe sêno ómonehiko éskiriba yoko farîzeu xoko Jesus. Inu'íkokonoti kapíneyea hóyeno ákoti itukapu îma neko sêno. Enepohikone omâti, pahúkoa xe'ó kó'iyea nonékuke uhá koêti neko xâne. ");
INSERT INTO terNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ina kixohíko Jesus: —Ihikaxotí, enepora sêno, koati inu'íkokonoti kapíneyea hóyeno ákoti itukapu îma. ");
INSERT INTO terNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Yutóxovo Ponóvotike Kixovókuti yútoe Muîse kónokea hepókeokono ya mopôi, kuteâti ra sêno, imókone ivakápu. Kene îti, na kó'eye yiûho vo'ókuke? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Itea kó'inokeneye yuhóhiko, koati oposí'okovoti Jesus, kaha'aînoatihiko pahúkeovo ya yumópope motovâti koyúhoyeahiko itúkeovo pahukóvoti. Yane ina yupunínikovo ne Jesus yutóxea poké'eke ya vô'u. ");
INSERT INTO terNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Vo'oku ákoyea káyunuka farîzeuhiko kaha'aînoati yumópea, yane exépukopone ne Jesus. Ká'aye kíxovokoxoa: —Enepone ákoti pahúnevo xepákukenoe, énomone inuxâ hepókea ra sêno —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yane yupúninikopovonemaka yutóxea poké'eke. ");
INSERT INTO terNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kameánehiko neko yûho, pohú pohu koépone píhohikopea, inixópovotihiko itúkeovo pahukóvoti. Enepone yékotenohiko xapákuke inuxópo. Ehane póhuxovo ne sêno xoko óvoheixoku nonékuke Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yane xe'oo koépone ne Jesus. Noixoâne áko'oyeane neko po'íhiko xâne koane póhuxeovo ne sêno nonékuke, hara kíxoane: —Senó, náhiko ne isímopiti yâye koyúhoti ápeyea váhere ítike? Ákone inixoâti kónokea hipókikono? ");
INSERT INTO terNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Áko'one Unaém —koéne. Ina kixôa Jesus: —Ngúteanemaka. Ákomaka njepákapi. Pihépane, itea hákone yaukôa itíki ne váhere ítike —kíxoane.) ");
INSERT INTO terNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ina kixovókoxoakomaka Jesus neko xanéhiko: —Undíne itukóvo kouhápu'ikoti xâne yara kúveu mêum. Enepone hokónuti, ákomo ávaheixa hahákutike itea kouhápu'ikokonotimo uhá koeti kóyeku, vo'oku ápeyeane ne inámati apéyeati xokóyoke ákotinemo hunókoku —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ina poe'aînoa isóneu farîzeu koane kíxeahiko: —Koati itíne koyuhópovo itíkivo kouhápu'ikoti xâne yara kúveu mêum. Ako omótova kutípeokono ne yiûho —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ina kixopâhiko Jesus: —Yusíkoti itúkeovo ûndi koyuhópovo itúkeova kuteâti ra yûnzo, itea kóyeane itúkeovo koati kaná'uti ra yûnzo vo'oku énjoa ne úngeaku koáne ne yonómboku. Kene itínoe, ako yéxa ne úngeaku simóya ne yonómboku. ");
INSERT INTO terNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Enepone iséneunoa ne koekúti, pohu isoneú kíxenenoe, ako takápapu. Kene ûndi, ako ínjaneye xâne kuteâti ne iséneunonu. ");
INSERT INTO terNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Itea enepo ngoyûho koêkuti íninjone vo'ókuke ra xâne, koati kaná'uti ra yûnzo, vo'oku haina mbohúxinovati koeku kó'inoaneye inzóneu, itea énomonemaka koéneye isóneunoa ne Pahukónuti nzímea yâye. ");
INSERT INTO terNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yoko yane Ponóvoti Kixovókuti yútoe Muîse hé'e, yutóxovomaka kónokea kutípeokono yuhôti koeku pí'ayea noixoâti koane koyuhó'iyeati koêku. ");
INSERT INTO terNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngoyúhoane ne ngoêku. Koane Nzá'a, enepone Pahukónuti nzímea yâyeke, koyúhonumaka —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ina kixoáhiko jûdeu: —Na óvo ne yá'a? Ina yumopâ Jesus: —Ákonoe yéxanu. Simóya ne Nzá'a, ákomaka yéxa. Eneponi yexánu, manímaka yexoâti ne Nzá'a —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Enepo koyuhoâne Jesus ra koekútihiko, hána'itike imokóvokuti ya Njeruzálem óvo, ya xoko kuríkokonoku tiûketi íparaxokonoke Itukó'oviti. Yoko ako ika'ákoti Jesus vo'oku âvoyea simápu kaxena namúkeokono. ");
INSERT INTO terNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ya po'íkemaka, hara kíxovokoxoa Jesus ne jûdeuhiko: —Mbihopeôpitinenoemo. Yoposíkopononutimo, itea yevókovotimo ya pehúnevo. Koati xané kixepoâtimo ivékivo vo'oku ako omótova yenópi xoko yonómboku. ");
INSERT INTO terNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ina kixokóko ne jûdeuhiko: —Kahá'atiperamea koépekopeovo kutí'inoke koyuhoâti ákoyeamo omótova vonópea xoko yonópokumo? ");
INSERT INTO terNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ina kixoá'ikomaka Jesus: —Koati itínoe íhae yâye yara poké'e. Kene undi, vanúke úngea. Itínoe íhae ra kúveu mêum, kene haina undi íhae yâye. ");
INSERT INTO terNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hukinóvoti ngíxeopinoe yévokivomo ya pehúnevo. Koati xané kixepoâtinoemo ivekápu, vo'oku enepo hákoti kitipónu indúkeovo énomone ne ngixínopike, yevókovotimo ya pehúnevo. Koati xané kixepoâtimo ivékivo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ina kixoáhiko jûdeu: —Kutí'ikopo îti? Ina yumopâhiko Jesus: —Énomone kuteâti ngixínopike ukeâti inâ ndurixóvo ínzikaxea. ");
INSERT INTO terNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mani êno yûnzo ve'ókuke, mani enjókopitinoe pehúnevo. Itea enepone Pahukónuti nzímea yâyeke, koati kaná'uti nê'e, kutí'inoke ngoyuhoâti xapákuke xâne yara kúveu mêum ne ngámone xokóyoke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Itea enepohikoneko xâne, ako éxa itúkeovo Há'a íhae vanúke kixínoahiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hukinóvoti kíxovokoxeamaka Jesus: —Enepo kexépukanune tikótike, undi íhae vanúke ikútipasikoponovoti xâne, ínamo yexâ indúkeovo énomone ne ngixínopike, koane yexoâtinenoemo yanê'e ákoyea itúkapu isoneú ngíxone nzóko, itea itúkeovo póhutine íhikaxeonuke Nzá'a ne ngoyúho. ");
INSERT INTO terNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yoko enepone Pahukónuti nzímea yâyeke, anéye njokóyoke. Ako kurí íxanu mbóhuxeovo, vo'oku kóyekune indúkea koekútihiko iko'élokexeati okóvo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Uke'éxoane Jesus koyúhoyea ra koekútihiko, êno xâne kutipoâti. ");
INSERT INTO terNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ina kixovókoxoa Jesus neko jûdeuhiko kutipoâti: —Enepomo hákoti itevóki ra ihíkauvoti yunzó'inopinoe, itimo koati kaná'uti hokónuti ");
INSERT INTO terNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","epó'oxo yexoâtimo ne kaná'uti kixovókuti íhae xoko Itukó'oviti, yane itívoatimo ne kotíveti kéyeku. ");
INSERT INTO terNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ina kixôa jûdeuhiko: —Uti ámoriponoiko Âbraum. Ako vitúkeovoku akaúti. Ná'ikopo koeti “Itívoatinemo ne kotíveti kéyeku” kixínevi? ");
INSERT INTO terNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ina yumopâ Jesus: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Uhá koeti xâne ovóheixoti pahunévotike, koati ákau váhere kixovókuti. ");
INSERT INTO terNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yoko enepone akaúti, ápe hunókoku óvoheixea óvokuke únae. Haina kóyekutine xokóyoke. Itea enepone xé'a ne únae, koati ákoti hunókoku óvoheixeaya. ");
INSERT INTO terNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Koeku itúkeovo ûndi koitóvopinoe, undi Xe'exa Itukó'oviti, koati itévotine. ");
INSERT INTO terNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Énjoa itíkivonoe koati ámoriponoiko Âbraum, itea kóyeane kehá'ayi képekinu vo'oku ákoyea yakáha'a ne ínzikaxeopike. ");
INSERT INTO terNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Enepohikone kixovókuti noínjone itúkea Nzá'a, énomone ngoyúho. Kene itínoe, hane itíko, neíxone itúkea yá'a. ");
INSERT INTO terNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ina kixopâmaka jûdeuhiko: —Âbraum vitúko ha'a ûti. Itea hara kíxovokoxoa Jesus: —Itukápuxo Âbraum itíkonoe yá'a, hékaikopo kixoku itúkeovo ne Âbraum. ");
INSERT INTO terNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Itea koati yoposíkoti képekinu, undi koyuhó'inopeati ne kaná'uti kixovókuti ngámone xoko Itukó'oviti. Ako ákoeneye kixoku itúkeovo Âbraum. ");
INSERT INTO terNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Koati kixoku itúkeovo ne yá'a hekóponoe. Ina kixopâhikomaka jûdeu: —Haina uti apehí koêti ákoti há'a. Poéhaxo ne Ha'a ûti, énomone ne Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ina kixovókoxopamaka Jesus: —Eneponi itukápuxo yá'a nê'e, mani koati ákoti omotóvonu yokóvo, vo'oku koati úngeakune xokóyoke koeku nzímea yâyeke. Yoko hainámaka isoneú ngíxone nzímea itea énomone pahukónu yâyeke. ");
INSERT INTO terNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Énjakapivo ákoinoke yexa yûnzo? Vo'oku koati mokerexó keyîtinoe. ");
INSERT INTO terNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Itínoe koati hokoti Ndeâpu. Énomone itíko yá'a. Yoko ukeátinekene, koati koépekenati nê'e. Ako káxuhevekapu nê'e kaná'utike kixovókuti vo'oku akó'oti ne kaná'uti kixovókuti xokóyoke. Enepo semekékexo, motókea kíxeaneye vo'oku koati kixóvokune. Koati semékenovo'iti nê'e. Koatímaka poéheve ne uhá koeti semekénovo'iti. ");
INSERT INTO terNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Vo'oku ngoyúhoyea ne kaná'uti kixovókuti íhae xoko Itukó'oviti, énomone ákoino yakútiponu. ");
INSERT INTO terNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ápeikopo xepákukenoe motovâti koyúhoyea ápeyea mbahúnevo? Koeku itúkeovo kaná'uti ra yûnzo, ná'ikopo koeti ákoino yakútiponu? ");
INSERT INTO terNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Enepone xâne hokoti Itukó'oviti, usó kóye kámokenoyea emó'u. Kene ákoinokenoe yakámokenonu, koati vo'oku ákoyea itíkapunoe hokoti Itukó'oviti —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ina kixoá'ikomaka jûdeuhiko: —Koati tokopóvoti visóneunopi itíkivo samarítanu, ûroevo ndémoniu, isáyu'ixinovoke iséneu. ");
INSERT INTO terNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yane hara kíxovokoxopamaka Jesus: —Haina undi ûroevo ndémoniu. Koati ngahaná'ikoti iha Nzá'a, kene yíxovonoe kémoke'eyinu. ");
INSERT INTO terNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Haina ombosíkoti inzáyu'ikeokono, itea ápe kaha'aînonoati yoko énomone ponovô isóneunoa ra koekúti. ");
INSERT INTO terNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Koati emo'úti ra yunzó'inopinoe, ivévaka: Enepone xâne hokoâti ra yûnzo, ákomo uké'exa pevóti. ");
INSERT INTO terNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ina kixopâmaka jûdeuhiko: —Kó'oyene véxoaneoxo itíkivo isayú'ixovoti isóneu, ûroevo ndémoniu. Ivókovone Âbraum, koánemaka ne porófetahiko koyúhoti emo'u Itukó'oviti mekúke, keyúhoikomaka ákoyeamo uké'exa pevóti ne xâne itukoâti ne yiûho. ");
INSERT INTO terNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ití'ikopo teyonéti ya voxú'ikene Âbraum? Ivókovo nê'e, koánemaka ne porófetahiko. Kutí'ikopo íkitixapovo? ");
INSERT INTO terNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ina kixovókoxopamaka Jesus: —Eneponi itukapu ûndi ihayú'ikopovo, ákoni itúkovoke ne inzáyu'ikeokono, itea koati Nzá'a porexónu indúkeovo ihayú'iuti, enepone keyúhonenoe itúkeovo Itukó'oviti Yúnae. ");
INSERT INTO terNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Itea ákonoe yéxa nê'e. Undíne exôa. Eneponi ongoyúhoa ákoyea énja, mani kutipasí ngoépitinoe indúkeovo semékenovo'iti. Itea énjoa nê'e, epó'oxo koati indukeâti yûho. ");
INSERT INTO terNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Elókea okóvo yoxú'ikene Âbraum noíxeamo ngaxéna. Yoko noíxoane, koane hána'iti elókeyea okóvo vo'ókuke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ina kixopâmaka jûdeuhiko: —Avo itépana sinkoenta koeti xénaena, keyúhoikomaka neíxi Âbraum? ");
INSERT INTO terNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ina yumopâhiko Jesus: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Tumúneke ápeyea Âbraum, ámbene —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Énomone yanê'e, namú kixone mopôi ne jûdeuhiko kahá'ati koépekea Jesus, itea ipúhikopea Jesus neko hána'iti imokóvokuti ya Njeruzálem ákoti noiké'exopati. ");
INSERT INTO terNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Koeku yónea ne Jesus, noíxone hóyeno komití'iyeatinekene. ");
INSERT INTO terNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ina kixôa íhikauhiko: —Ihikaxotí, itúkinovoke komití'iyeatinekene râ'a vo'ókumea pahúnevo? áko'o vo'ókumea pahúnevo há'a yoko êno. ");
INSERT INTO terNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ina yumopâ Jesus: —Haina vo'oku pahúnevo, koane hainámaka vo'oku pahúnevo há'a yoko êno komítino ra hóyeno, itea maka iyúseane ne xunako Itukó'oviti ya xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Konókoti vitúkea ítuke ne Pahukónuti yâyeke koêkuiko ápeyea kaxena ûti, vo'oku simóvotimo hunókoku ne ko'ítukeyea ûti, kuteâti koêku enepo yotixóne. ");
INSERT INTO terNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Koêkuiko óveam ra kúveu mêum, ûndi kouhápu'iko xâne yara kúveu mêum —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Uke'éxone koyúhoyea, ina apurúko poké'eke, kalaká'ikoti móte ya hô'o. Ina veyôa ne móte kaláka'iu, kihu'íkoa ukékuke neko komítiti ");
INSERT INTO terNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ina kixôa: —Kípeukeapanapu tánginake Silôe —kíxoane. (Yoko “pahoéti” koêti ne Silôe koêti.) Ina pího neko komítiti kípoukeoponeovo. Yane ínixopone aukópovo. ");
INSERT INTO terNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Enepohikoneko múxone oveâti xêrerekuke óvoku, koánemaka ne po'ínuhiko xâne noixóheixoati ixómoyea épemo, hara kixókoko: —Haîna râ'a ne komítiti ixómoti ivatá'ixo yómoti épemea? —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ina apê xâne xapákukehiko koêti: —Énomone nê'e —kixoâti. Itea hara kôe po'ínuhiko: —Pó'iti, pohu akó'oti pahuíxa nê'e —koéhiko. Ina kôe neko unatípeatine komítiyea: —Énomoneoxo ûndi. ");
INSERT INTO terNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ina kixôa xanéhiko: —Ná'ikopo kixévotiye ínixepinoke? ");
INSERT INTO terNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ina yumopâ: —Ápe hóyeno koéhati Jesus kalaká'ikoti móte ipíhoati ungékuke. Yane pahúkonune ngípoukeoponeovo xoko tángi, enepone víhaxone Silôe. Úngeane mbího ngípoukeoponeovo, yane íninjopone —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ina kixopâ'ikomaka xanéhiko: —Ná'ikopo ne hóyeno? —Ako énja —koéne yumopâhiko. ");
INSERT INTO terNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yane ina omokóno neko hóyeno unatípeatine komítiyea xoko farîzeuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yoko sâputu nekôyo, káxe koati sasá'itino evo jûdeu kalaká'iko móte ne Jesus ya hô'o, enepo koitóva neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ina epemó'ikoa farîzeuhiko neko hóyeno kixóvoku ínixopinoke. Hara kíxovokoxoa hóyeno: —Áhiukeonu móte ne hóyeno ina ngipoúkeoponovo. Kó'oyene íninjopone —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Énomone ápeino po'ínuhiko farîzeu koêti: —Hainá'ikopo páhoe Itukó'oviti neko hóyeno vo'oku ako teya sâputu —koénehiko. Itea ápe po'ínuhiko koêti: —Na kíxoaye itúkeovo hóyeno pahukóvoti itukô haná'iti iyupánevoti kuteâti râ'a? —koénehiko. Énomone kutí'ino okopókokoti neko farîzeuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ina kayukópahikomaka épemo'ikea ne hóyeno unatípotine. Hara kixópahikomaka: —Kene îti, na kó'inoaye iséneu koeku koíteovopi? Ina yumopâ hóyeno: —Kutí'inonu páhoe Itukó'oviti koyuhó'iyeati emó'u —koéne yumópope. ");
INSERT INTO terNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yoko ako akútipoa tutíhiko jûdeu itúkeovoxo komití'iyeatinekene inixópotine. Énomone iháxikinoahiko há'a yoko êno. ");
INSERT INTO terNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Yane ina epemó'ikoahiko tuti jûdeu. Hara kíxoahiko: —Énomone xí'a râ'a keyúhonenoe itúkeovo komití'iyeatinekene? Na kixóvotiye ínixopinoke? ");
INSERT INTO terNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ina yumopâ há'a yoko êno neko hóyeno: —Véxoa itúkeovo xe'exa ûti râ'a, koane itúkeovo komití'iyeatinekene ");
INSERT INTO terNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","itea ako véxa ínixopinokene, koane ako véxa koitóvati. Yépema'ika, vo'oku úsotine. Énomonemo koyuhó'inopea koêku —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yoko kó'inokeneye yûho neko há'a yoko êno, koati pikoti isóneunoa tutíhiko jûdeuya. Vo'oku koyuhoâtine tutíyehiko yanekôyoke kópuhikopeokonomo ya íhikaxovoku hó'e ne koêkuti koyuhoâti itúkeova Jesus ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne. ");
INSERT INTO terNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Énomone koyúhoinoa há'a yoko êno neko hóyeno itúkeovo úsotine ne xé'a, koane kónokea itúkeovo énomone épemo'ikohiko koêku. ");
INSERT INTO terNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ina ihaxíkopamaka farîzeuhiko neko hóyeno unatípeatine komítiyea. Yoko pí'apene iháxikoahiko. Hara kíxoa: —Yokóyuhoa iháke Itukó'oviti itúkeovo koati kaná'utimo ne yihó'inovi. Véxoa itúkeovo koati pahukóvoti neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ina kixôa hóyeno: —Itúkeovo pahukóvoti, ako énja. Poéhane énjo ngomítiyea nóvo, itea kó'oyene íninjopone —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ina aukópamaka farîzeuhiko kíxea: —Na kixó'oye koíteovopi? Na kíxoaye poréxeopi ínixepi? ");
INSERT INTO terNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ina yumopâ hóyeno: —Ngoyúhoinopeanenoemeku, itea ákonoe yakútiponu. Na koeti kehá'ainonoe ngáyukopeakomaka? Keha'âtinoemea itíkivomaka íhikau ne hóyeno? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yane oríxoane farîzeuhiko. Hara kíxoahiko: —Itíne itukóvo íhikau nê'e. Kene uti íhikau Muîse. ");
INSERT INTO terNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Véxone yúho'ixea Itukó'oviti, poéhane Muîse. Kene ne hóyeno kíxene, muhíkova úkeaku ako véxa —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ina yumopâ neko hóyeno: —Kouhé'exovoti ákoyea yéxanoe úkeaku, itea íninjopone vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Véxoa ákoyea yumapa xâne pahukóvoti ne Itukó'oviti, itea hane yumópo, teyoâti yoko itukeâti âha. ");
INSERT INTO terNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ukeátine inâ apê ra kúveu mêum, ako kámeaku xâne ápeyea koitóvoti komití'iyeatinekene. ");
INSERT INTO terNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eneponi hákoti itukovo páhoe Itukó'oviti neko hóyeno, ákoni ítone itúkea —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ina kixopâmaka farîzeuhiko: —Inípono itúkeovo iti xâne pahukóvoti ukeátinekene inâ yapê xoko mémaina, kehá'aikomaka íhikexivi? —kíxoanehiko. Yane kópuhikeanehiko ho'úxinovoku hó'e. ");
INSERT INTO terNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yoko eyékoxoane Jesus kixókonoku ne hóyeno koítovone. Itopónoane, hara kíxoa: —Kitípoa ne íhae vanúke ikútipasikoponovoti xâne? ");
INSERT INTO terNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ina yumopâ hóyeno: —Kutí'ikopo nê'e motovâti ngutípea Unaém? —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Énomone ra neíxone kó'oyene, enepora yuhó'ixopiti —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Ngutípopi Unaém —koéne neko hóyeno, xaneâti ipúyukexea nonékuke ihayú'ikoati. ");
INSERT INTO terNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ina kixoá'ikomaka Jesus: —Nzimínoke yara kúveu mêum maka ínixapane ne komítiti, koane itúkapuneoxomaka komítiti ne po'okoâti itúkeovo iníxoti. Énomone ngoúhapu'iko, nzimínoke yara kúveu mêum —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yoko ápe farîzeuhikoya kamokénoyeati yûho. Ina kixohíko Jesus: —Hainámea keyuhoâti vitúkeovomaka komítiti? ");
INSERT INTO terNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ina yumopâhiko Jesus: —Eneponi itikápuxonoe komítiti, ákoni pehúnevo. Itea koeku íkitixapivonoe koati iníxoti koane exoâtimaka koêku ne kixovókutihiko, énomone kutí'ino anéyetiko pehúnevo —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ina kixovókoxoa Jesus: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Enepone kovesé'uxeovati ipi kûrapena ne su'ûso ákoti vekêa páhapeteake, koati ómevoti koane hú'uxokenati nê'e. ");
INSERT INTO terNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Itea enepone vekeâti páhapeteake, énomone koati koyonoâti ne su'ûso. ");
INSERT INTO terNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yane enepone koyónoti pahapéti, míhe'okinoa porexoâti ûrukeovo. Yoko éxoa su'ûso emó'u ne únae. Koati îha veínoa únae íhaxea póhutihiko su'úsona, ina kopúhikoa meúkeke. ");
INSERT INTO terNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Enepo kopúhikoane uhá koêti ne su'úsona, inúxinoahiko. Yane pihotínehiko ikéneke. Koáhati exeâtihiko emó'u. ");
INSERT INTO terNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ako hokohí ixa xâne ákoti itukapu únae. Kohó'iyeahiko vo'oku ákoyea éxea emó'u —koéne Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Itúkinoa Jesus xanéhiko ra xêti apêti íhokoake ne âha íhikaxeahiko, itea ako éxinahiko isóneu kixó'ekone. ");
INSERT INTO terNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ina kixovókoxopamaka Jesus: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Enepone páhapetea kûrapena su'ûso, undíne itukóva. ");
INSERT INTO terNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Uhá koeti simôti tumúneke nzímea, hane koéneye ómevoti yoko hú'uxokenati. Itea enepohikone kutí koeti su'ûso, ako itúkeake ne yûho. ");
INSERT INTO terNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Undíne itukóvo ne koati kaná'uti pahapéti. Enepone vekónuti, ngoitóvatimo. Epó'oxo kuteâti koeku su'ûso únati kátarakeovo, ipuhíkeati kûrapena níkaxoponeovo yoko urúkopovatimaka, énomonemakamo koéneye ne kutipónuti. ");
INSERT INTO terNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Koati simínoti oméxea ne ómevoti, koane koépekea yoko kotóhineyea. Kene ûndi, nzimínoti motovâti yupíheovo unáko koêku, ominoândimaka inámati apéyeati ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","—Hara ngoéneye koati únati koyónoti su'ûso usó koyêti ivókinova ne su'úsona. ");
INSERT INTO terNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Enepone ahinoêti koyónoti su'ûso, póhutine tiûketi itúkinoa ne itukéti, haina únae nê'e, koane hainámaka ítuke ne su'ûso. Enepo noîxo yovîre keno'ókinoati, kohó'iyea, kurí kixôati ne óyonone. Yane ísukexoa yovîre neko su'ûso kotohíneatine. ");
INSERT INTO terNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kohó'inoke nê'e, vo'oku itúkeovo tiûketi kahá'a kóyoninoake ne su'ûso, kene haina kaha'aînoati unako koêku ne óyonone. ");
INSERT INTO terNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Kene ûndi, hara ngoéneye koati únati koyónoti su'ûso. Énjoa ne óyononem koane éxonuhikomaka, ");
INSERT INTO terNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kuteâti koeku véxeokoko, ûndi yoko Nzá'a. Yoko usó ngóye ivónginova ne óyononem. ");
INSERT INTO terNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Apêtimo po'ínuhiko óyononem ákoti itukapu íhae yâye. Ngonokoâtimakamo nzo'úxopea xapákuke râ'a. Ivavákoatihikomo ra yûnzo. Yane póhutiponemo ne uhá koeti óyononem, epó'oxo mboéhanemo xapákuke ngoyonoâti. ");
INSERT INTO terNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","—Hara ákoinoke omótovonu okóvo Nzá'a, vo'oku ivónginovamo ne óyononem, ínamakamo enjepúkapa. ");
INSERT INTO terNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hainamo apêti uke'éxoati ra omínjone. Undínemo ihúnokoa kurikópati xoko Itukó'oviti. Ápe njunáko ínzunokea koane inzáxikopea. Yoko Nzá'a porexónu ngíxeaneye —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Vo'ókuke neko yuho Jesus, aúkopovomaka okópeokoko ne jûdeuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Êno xâne xapákuke koêti: —Ûroevo ndémoniu nê'e. Koati pepokéxovoti. Na koeti kémokenoinoa? ");
INSERT INTO terNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Itea ápe po'ínuhiko koêti: —Ako ákoeneye yuho ûroevo ndémoniu râ'a. Koítovoikopo komítiti ne ndémoniu? —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ya Njeruzálem yanekôyoke, koati kaxena kóyuipe jûdeuhiko hó'eke. Énomone ne áyui íhaxonehiko Dedikásaum. Yoko kaxena kásati yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Hane véko ne Jesus varándanake ne hána'iti imokóvokuti ya Njeruzálem, enepone iháxoneti Varándana Salúmaum. ");
INSERT INTO terNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yane ayákukoane jûdeuhiko. Hara kixóhiko Jesus: —Námoye keyúhoyi itukóvotiye îti? Itukápuxo îti ne Mésiya, páhoe Itukó'oviti koíteovovi, hákone hi'onó'uxivovi —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ina kixovókoxoa Jesus: —Ngoyúhoinopeanenoe, itea ákonoe yakutíponu. Enepora itukéti índuke ya iháke Nzá'a, énomone exókopinoe indúkeovo koati páhoe. ");
INSERT INTO terNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Itea ákonoe yakútiponu vo'oku hainánoe iti óyononem. ");
INSERT INTO terNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Enepone óyononem, ivávako yûnzo. Énjoanehiko, koane hokóponuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mboréxoahiko inámapoti apéyeati ákotinemo hunókoku. Ákomo yanapa ipihóponovokutike, epó'oxo ákomo hu'uxóponoati. ");
INSERT INTO terNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Enepone Nzá'a porexónoati, xunané'e ya uhá koêti. Ako itoâti hú'uxopea xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Koati póhutine ûti, ûndi yoko Nzá'a —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yane veyó kixone mopôi ne jûdeuhiko, mani hepókoti Jesus, kaha'âtihiko koépekea kuteâti mani kíxoaku yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ina kixovókoxoa Jesus: —Êno únatinoe itukéti índuke xepákukenoe, páhoenonu Nzá'a indúkea. Énomoneikopo kehá'aino hipókinu vo'ókuke? ");
INSERT INTO terNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ina yumopâ jûdeuhiko: —Haina únati itukéti hepókinopike ûti, itea koati vo'oku ákoyea tiya Itukó'oviti, iti xâne kuteâti ûti itîkovoti Itukó'oviti —kíxoanehiko jûdeu. ");
INSERT INTO terNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ina kixovókoxopamaka Jesus: —Hainá'ikopo yutoxóvoti yane yutoéti hé'e, enepone Ponóvoti Kixovókuti yútoe Muîse ne koêti: “Ngoé'epepo, itínoemaka kuteâti ûndi, undi Itukó'oviti” koêti? ");
INSERT INTO terNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Itukovo “Itínoe kuteâti ûndi, undi Itukó'oviti” kixoâti Itukó'oviti neko xâne iyónoku yûho mekúke, yoko ako omótova pahúkeovo ne emo'u Itukó'oviti, ");
INSERT INTO terNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ná'ikopo koeti “Itîkovoti Itukó'oviti” kixínenunoe, vo'oku ngoyúhoyea indúkeovo Xe'exa Itukó'oviti? Koáhati undi noívokoe itúkea sasá'iti ítuke, koane undímaka páhoe yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eneponi hákoti indukôa itukéti kuteâti ítuke ne Nzá'a, ákoni okónokoa kitípinunoe. ");
INSERT INTO terNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Itea koeku indúkea kuteâti ítuke Nzá'a, yusíkoti ákoyea yakútiponu itea vo'ókuke ra itukéti índuke, mani konokoâti kitípinu. Yane mani yexínoati iséneu itúkeovo póhutine ûti, ûndi yoko Nzá'a, koeku ápeyea ne Nzá'a njokóyoke, koêkumaka ámbeyea xokóyoke —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yane kahá'apoanemaka jûdeuhiko iká'akea, itea itópeovamaka Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ina kayukópovomaka yónea ne Jesus poixô'oke huvêo, enepone Njôrdaum, xoko óvoheixoku Xuaum Mbátita áhikexea xâne yanekôyoke inâ turixóvo áhikea. Yane ôvane Jesus-ya. ");
INSERT INTO terNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yoko koati êno xâne pihinoâti. Hara koe yuhóhiko vo'ókuke: —Ako iyupánevoti ítuke ne Xuaum Mbátita kuteâti ítuke râ'a, itea uhá koeti yuho Xuâum vo'ókuke ra hóyeno, aínovo koati kaná'uti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yoko ako yumáxapu kutípoti Jesus xapákuke neko xâne. ");
INSERT INTO terNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ápe hóyeno ka'aríneti koéhati Lâsaru, íhae kali ipuxóvokuti iháxoneti Mbétanea, óvokumaka Mâriya yoko Márta, mokéxahiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Enepone Mâriya, mokéxa ne ka'aríneti, énomone neko ovohévexoti Jesus xêru koane kihuhévexopati ya híyeu tûti. ");
INSERT INTO terNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Enepone mokéxahiko Lâsaru, ápe páhoe xoko Jesus. Hara kixóponoa: —Unaém, ka'aríneti ne ínikene, enepone ákoti omotóva yokóvo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Eyekóxoane Jesus, hara koéne: —Enepone arinéti, hainamo koepékoati itea iháyu'ikeokonokemo xunako Itukó'oviti vo'ókuke, epó'oxo inzáyu'ikeokonokemakamo, undi Xe'exa Itukó'oviti —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yoko koati ákoti omotóva okóvo Jesus ne Mâriya yoko po'ínu, enepone Márta, koánemaka Lâsaru, âyo. ");
INSERT INTO terNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ikénepoke eyékoxinea Jesus ká'arineyea ne Lâsaru, pí'apoakomaka káxe óvoheixoa ne óvoheixoku. ");
INSERT INTO terNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yane hara kíxovokoxoa Jesus neko íhikauhiko: —Hingá, vaúkapapu ya Njúdeya. ");
INSERT INTO terNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ina kixôa íhikauhiko: —Ihikaxotí, koati âvoti axu'íkenepo ike kahá'ayea koépekeopi ya mopôi ne evo jûdeuya, keyúhoikomaka yaúkopivoya? ");
INSERT INTO terNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ina yumopâ Jesus, itukínoati íhixovoke: —Nduse ákoikopo ákoe ne ôra ya káxe? Itukovo yoneâti káxe ne xâne, ako ikaxáhevexoati. Koáhati iníxoti vo'oku uhápu'ine ne kauhápu'ikoati ra kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Itea itukovo yoneâti yóti ne xâne, ikáxahevexovo vo'oku ákoyeane kouhápu'ikoti xokóyoke —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ina kixovókoxopaikomaka: —Imókone neko vínikone Lâsaru itea mbihinoâti, ngoyúkoponoati. ");
INSERT INTO terNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ina kixoáhiko íhikau: —Unaém, enepo itukapu imókoti, ákoneikopomea yuvâti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yoko “ivókovone” koêti neko yuho Jesus. Itea ikútixati íhikauhiko koati imókoti. ");
INSERT INTO terNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ina kauhápu'ikinoa Jesus koêku. Hara kíxovokoxoa: —Ivókovone Lâsaru. ");
INSERT INTO terNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Epó'oxo elóke ongóvo ángo'oyea xokóyoke maka yakútiponunenoe. Hingayá, naíxapana ûti. ");
INSERT INTO terNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ina kixovókoxo ha'ínehiko ne Túme, enepone íhautimaka Hapáparu: —Hingá, maka xané víxane koépekeokono —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Koeku símea ne Jesus ya Mbétanea, itone koaturu koeti káxe ike ekóxinevo ne Lâsaru. ");
INSERT INTO terNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yoko mopó'amea kílomituru kíxoaku Mbétanea ne Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Koati ênoti jûdeu óvokuke Mâriya yoko Márta kouhépekoponeati isóneu ike ivókinevo âyo. ");
INSERT INTO terNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eyekóxoane Márta kenó'okea ne Jesus, pihóne okótumonexea. Kene Mâriya, ôvane óvokuke. ");
INSERT INTO terNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tokopóne Jesus ne Márta, hara kíxoa: —Unaém, eneponi yáva yâye, ákoni ivákapu ne âyom. ");
INSERT INTO terNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Itea enepo yepêma Itukó'oviti kó'oyene, énjoa poréxeopeamo ne yépemoake. ");
INSERT INTO terNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ina kixôa Jesus: —Iyukópovotimo ne yâyo. ");
INSERT INTO terNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Yane hara kixópamaka Márta: —Énjoa iyúkopeovomo simapúne exépukopope xanéhiko yaneko auké'ene ra kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ina kixôa Jesus: —Undíne itukóvo koexépukopoti ivokóvoti, mborexópatimaka inámati apéyeati ákotinemo hunókoku. Enepone kutipónuti, yusíkoti ivókeovone itea kóyeanemo iyúkopeovo. ");
INSERT INTO terNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Heú koeti kutipónuti inamápoti ya njokóyoke, ákomo uké'exa pevóti. Kitípoa ra yûnzo? ");
INSERT INTO terNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Êm Unaém, ngutípoa —kíxoane Márta. —Ngutípoane itúkeovo îti ne Mésiya, enepone páhoe Itukó'oviti koíteovovi. Iti Xe'exa Itukó'oviti kúxone ûti símeamo yara kúveu mêum —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Uke'éxone koyúhoyea ne Márta, ina ihaxíkopono Mâriya, enepone po'ínu, motovâti ákoyea po'i kamoâti. Hara kíxoa: —Simóne ne Ihíkaxoti. Îti iháxiko —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kamoáne Mâriya, xepú koéne, pihóne xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yoko avo ûrukapa Jesus ne kali ipuxóvokuti, óvoheixoakone xoko tokópeaku Márta. ");
INSERT INTO terNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Enepohikoneko jûdeu ovóheixeati óvokuke ne evo Mâriya kouhépekoponeati isóneu, noixoâne exépukea, hokó kíxoane, ikutíxatihiko, iyóponoti xoko ekóxokonoku âyo. ");
INSERT INTO terNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Simoáne Mâriya ne Jesus ya xoko óvoheixoku, ipuyuké kó'iyeane nonékuke koane kíxea: —Unaém, eneponi yáva yâyeke, ákoni ivákapu ne âyom —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Noixoâne Jesus íyoyea koánehikomaka neko jûdeu hokoâti, yupihovó koéne kotíveyea isóneuke xaneâti hána'iti kóseanayea. ");
INSERT INTO terNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ina kôe ne Jesus: —Ná'ikopo yekóxoanoe? Ina yumopâhiko: —Yókone Unaém, neíxapana —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yane íyone ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ina kôe ne jûdeuhiko: —Neíxoa koêku? Koati yupihóvati ákoyea omótova okóvo nê'e —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Itea ápe po'ínuhiko koêti: —Koítovopepo komítiti râ'a. Manímea apêti kíxoaku motovâti ákoyeani ivákapu neko Lâsaru —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yupihovó koéneoxomaka kotíveyea isóneuke Jesus. Úkeane pího xoko ekóxokonoku Lâsaru, kali hána'iti uhôro kehoéti mopoíke. Yoko ápe pú'iti mopôi exéxeokonoke. ");
INSERT INTO terNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ina pahukôa Jesus veyópeokono ne mopôi. Itea hara kíxoa Márta, mokéxa neko ivokóvoti: —Unaém, xúnatine ihópune, vo'oku koáturuxopene káxe kó'oyene ike ekóxinevo. ");
INSERT INTO terNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ina kixôa Jesus: —Ákoikopo ínjapimeku neíximo xunako Itukó'oviti enepo yakutípo yûnzo? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ina veyopókono neko mopôi. Yane hara kôe ne Jesus koeku komómoyea vanúke: —Pai, aínapo yákoe vo'oku kéminu. ");
INSERT INTO terNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Énjoa kéyeyikune kéminu, itea kó'inokeneye yûnzo kó'oyene vo'ókuke ra êno xâne yâyeke, maka akútiponune itúkeovo îti pahukónu nzímea yara kúveu mêum —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Uke'éxone koyúhoyea nê'e, kóhonokoxo emó'u kó'iyea: —Lâsaru, ipíhikapa meúkeke! —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yane iyúkopovo ne ivokóvoti, ipúhikopone meúkeke koane ínayea aú'okexovo hêve yoko vô'u, koane aunoné kó'iyea ya léhu. Ina pahukôa Jesus kúxe'okopeokono motovâti yonópea. ");
INSERT INTO terNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Xapákuke neko jûdeu noixóponoti Mâriya óvokuke, êno kutípoti Jesus noixeâne ítuke. ");
INSERT INTO terNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Itea pihóne po'ínuhiko jûdeu xoko farîzeuhiko éto'okoponea koêku ne ítuke Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yane ho'úxohiko koati payásoti yúhoikovoku jûdeuhiko ne tuti sasedóti inuxínoti jûdeu hó'eke, yóko'o ne farîzeuhiko. Ina koehíko: —Namo víxaneye? Koati ênoti iyupánevoti ítuke ne hóyeno! ");
INSERT INTO terNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Enepomo sikáne ûti, kutipoâtimo heú koeti xâne. Yane keno'ókotimo ne payásoti ya utíke íhae Róma uke'éxoatimo ra sasá'iti péti vimókovoku, koánemakamo ra poké'exa ûti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yoko ápe Kaífa xapákukehiko. Énomone neko koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke yaneko xoénae. Hara koe yûho xapákuke: —Ako yéxonenoe! ");
INSERT INTO terNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ako kali iséneunoa ra koekúti! Unatíneoxo ápeyea póhuti hóyeno ivokínovati ra xanéhiko ya koêkuni itúkeovo poké'exa ûti uke'éxokono koane uhá koeti xanéhiko yara poké'exake ûti ivokóvo —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yoko enepone yûho, haina ukeâti xokóyokene, itea vo'oku itúkeovo koati payásoti ya uhá koeti sasedóti yaneko xoénae, poréxoa Itukó'oviti koyúhoinoa koêku ne âvoti simâpu kaxéna, koyuhoâti ivókinovamo Jesus ne xâne yane poké'exa jûdeu. ");
INSERT INTO terNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yoko haina pohúneti xanéhiko poké'exake jûdeuhiko ivókinovomo, itea ivokínovotimaka ho'úxopea uhá koeti xe'éxaxapamo Itukó'oviti, koêkuti óvohikoku, itukópatihiko póhutipone ikéneke. ");
INSERT INTO terNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ukeátine neko káxe, koúsokone isóneuno Jesus ne tutíhiko jûdeu koépekeamo. ");
INSERT INTO terNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hukinóvotipo ákoyeane íhikaxa ne Jesus xapa jûdeuhiko. Pihópone kalíke pitivóko koéhati Efarâim xe'o mêum ákoti apêti. Énomone óvoheixo koánemaka íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yoko yé'exovone Páskoa yanekôyoke, áyui jûdeu ya hó'eke. Hukinóvoti enó'iyea xâne ukeâti neko óvoheixoku Jesus yonotihiko Njeruzálem tumúneke kaxena áyui, motovâti kasása'ikeovo kuteâti koeku páhoenoa hó'e itúkea. ");
INSERT INTO terNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Enepohikone xâne ya Njeruzálem, opósi'ixohiko Jesus. Koeku óveahiko yane hána'iti imokóvokuti, hara kixókoko vo'ókuke: —Na kó'inoaye iséneu, keno'ókotiperameamo? áko'o ákoperameamo kená'aka ayuítike —kixókokohiko. ");
INSERT INTO terNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yoko pahúkoane farîzeuhiko yoko tutíhiko sasedóti inuxínoti jûdeu hó'eke, kónokea koyúhoyea óvoheixoku Jesus áva xâne noixoâti, motovâti iká'akoponeahiko. ");
INSERT INTO terNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sei koé'iko káxe âvoti tumúneke neko áyui jûdeu hó'eke koéhati Páskoa, pîho Jesus ya Mbétanea, óvokuke Lâsaru, enepone ivokóvoti koéxepoepo. ");
INSERT INTO terNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Itúkohiko êno nikokónoti vo'oku símea Jesus. Márta itukóvo kaunákoti mêsa. Kene Lâsaru, kahá'ine Jesus yoko po'ínuhiko xâne xe'o mêsa. ");
INSERT INTO terNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yane ápe xêru yupihóvoti hepíko, ainóvoti nârdu ákoti ánahi véyone Mâriya. Yoko puhí koeti íhakuke neko xêru. Ina ovohévexo Jesus koane kíhuhevexopea ya híyeu tûti. Yupihovó koéne uheko ihópune ne xêru ya uhá koeti kúveu neko ovokúti. ");
INSERT INTO terNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ina kôe ne Juda Iskarióti, po'inu íhikau Jesus, enepone itûkoheovoti koeku hókea Jesus, enepone kurikoâtimakamo xoko xanéhiko puvâti: ");
INSERT INTO terNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Mani êno tiûketi ovâti ra xêru akavánevo, kuteâti námoe xâne ko'ítuketi ovâti yehí koeti kohê. Na koeti ákoino akávanevo, ínani parekéxakana xanéhiko ákoti apeínoati ne ésa'i? —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kó'inokeneye yûho, haina vo'oku yónea okóvo ne xâne ákoti apeínoati, itea vo'oku itúkeovo koyónoti tiûketina evo Jesus, yoko kóyekune véyea apê tiûketi urúkovoti íhakuke. ");
INSERT INTO terNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ina yumopâ Jesus: —Síkeane ra sêno. Unákinoake ne xêru motovâti kíxeonuneye, inúxoatine ne kixókonokumo ngoxé'u engaxápune. ");
INSERT INTO terNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kóyekunemo xepákukenoe ne xâne ákoti apeínoati, itea ákomo ángoyeneye xepákukenoe —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yupihovó koe êno xâne xapákuke jûdeu eyekóxoati símeane ne Jesus ya Mbétanea. Úkeane noixóponoahiko. Haina pohúneti vo'oku Jesus pihínohiko, itea noixóponotimaka Lâsaru, eneponeko ivokóvoti koéxepoepo Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yoko koúsokonehiko isóneu ne tutíhiko sasedóti inuxínoti jûdeu hó'eke koépekeamaka Lâsaru ");
INSERT INTO terNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","vo'oku koati ênoti jûdeu hokópoti Jesus vo'oku Lâsaru. ");
INSERT INTO terNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Poéha káxe ikénepoke, eyékoxonehiko kenó'okea Jesus ya Njeruzálem neko êno xâne komomóponoti áyui Páskoa. ");
INSERT INTO terNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ina veyohíko tuti exáte, yane pihónehiko okótumonexea Jesus xaneâti vaúkexeahiko. Hara koéhiko yûho vaúkexea: —Koati hána'iti ihayú'iuti rakéne. Viháyu'ika ra páhoenovi Vúnae Itukó'oviti. Énomone ra natina ûti, uti izaraelíta —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yoko ísimokono xe'exa njuméntu xoko Jesus, ina ivu'íxoa kuteâti koêku ne kúxoti yutoéti ya emó'uke Itukó'oviti, enepone koêti: ");
INSERT INTO terNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Hákonoe píke, itínoe íhae Njeruzálem, vo'oku harakéne netínanoe ivu'íxoti xe'exa juméntu” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yoko avo éxa íhikauhiko Jesus kixó'ekone neko yutoéti yaneko káxe, itea itukópovone hána'iti ihayú'iuti ne Jesus ya xoko Itukó'oviti ike exépukopine ukópea xapa ivokóvoti, yane puyákovanehiko okóvo íhikau neko kúxotihiko yutoéti ya emó'uke Itukó'oviti koyuhó'iyeati koêku, koane exó kixóponea tokópeovoxo. ");
INSERT INTO terNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Enepohikoneko êno xâne noíxoti Jesus koéxepukopea Lâsaru ukópea xapa ivokóvoti, koyúhopane neko noíxone xapákuke xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Énomonemaka okótumonexino Jesus neko êno xâne vo'oku eyékoxea koêku neko hána'iti iyupánevoti ítuke. ");
INSERT INTO terNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ina kixokókohiko ne farîzeu: —Yokómomapihinoe, ákomo víta vo'oku heu-heú koéne xâne xokóyoke —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Xapákuke neko xanéhiko ihayú'ikoponoti Itukó'oviti xapa ayuíti hó'eke, ápemaka xâne ákoti itukapu jûdeu, enepone ngerêkuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Énomone yuhó'ixopono Filípi íhae pitivóko iháxoneti Mbetâsaida ya Ngalíleya, koyuhó'inoatihiko kahá'ayea noíxea Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pihóne ne Filípi éto'okoponea Ándere. Yane pihóne neko pi'âti éto'okoponeamaka Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ina kixoáhiko Jesus: —Simóvone kaxena indúkeovo hána'iti ihayú'iuti, undi íhae vanúke ikútipasikoponovoti xâne. ");
INSERT INTO terNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Koati emo'úti ra yunzó'inopinoe, ivévaka: Enepone ake nonéti, kuteâti ake tirîku, enepo hákoti irikópovo poké'eke, hákotimaka ekoxópokono, kôyeanemo kóyeku. Itea enepo ekaxápakana, enópomo há'i pôreu. ");
INSERT INTO terNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Koêkuti xâne ákoti omotóvo okovo koúhepekea kóyeku yara kúveu mêum, evókotimo mani unako koépoku xoko Itukó'oviti. Itea enepone xâne ákoti yuixápu ne mani unako kóyeku yara kúveu mêum, énomonemo unatî koépoku xoko Itukó'oviti ákotinemo hunókoku. ");
INSERT INTO terNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Enepo áva xâne kahá'ati itúkea índukexeake, konókoti hókeonu. Yoko koêkutimo véngoku, énomonemakamo véko. Epó'oxo áva xâne itúkoti índukexeake, kahaná'ikoatimo Nzá'a —kíxoanehiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ina koe'íkomaka: —Koati hána'iti tiveko inzóneu. Námeamo ángoeneye? “Keítapunu yara ôra nzímokune” ínjamea ne Nzá'a? Itea ako omótova vo'oku koati énomone nzimíno yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pai, kehána'ika ra îhe —koéne. Énomone yanê'e, apé koéne emo'úti inu'íxoti vanúke. Hara kôe: —Ngahána'ikoane, epó'oxo ngahaná'ikopatikomakamo kó'oyene —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Yoko enepohikoneko êno xâne ho'uxóvotiya, kamoánehiko neko emo'úti, koyúhoahiko itúkeovo xururúkoti. Kene po'ínuhiko, hara kôe: —Koati ánju íhae vanúke, ovoxe Itukó'oviti yuhó'ixoa —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ina kourápu'ikinoahiko Jesus koêku. Hara kôe: —Haina vo'ónguke itea ve'ókukenoe ápeino ne emo'úti. ");
INSERT INTO terNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Simóvone kaxena koúhapu'ikeokonoku ipíhoponeokonomo ne xâne yara kúveu mêum vo'oku váhere kixoku itúkeovo, koane veyopókonotinemo ne Satánae itúkeovo pahúkoti yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kene ûndi, enepo ngaexépukakanane ungeâti poké'e, inzímotimo uhá koeti kó'iyeovoku xâne njokóyoke —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kó'inokeneye ne yûho, exókoati kixókumo koêku ivakápu. ");
INSERT INTO terNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ina kixôa xanéhiko: —Enepone véxone ya yútoeke porófetahiko koyúhoti emo'u Itukó'oviti mekúke, ákomo ivákapu ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne. Ná'ikopo koeti keyúhoino kónokea koéxepukeokono ukeâti poké'eke ne íhae vanúke ikútipasikoponovoviti, uti xâne? Kutíyaikopomea nê'e? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ina yumopâhiko Jesus: —Ákonemo áxu'ikene yâye xepákukenoe ne kouhápu'ikoti xâne. Víkaikopo uhapú'itike koêkuiko ápeyea xepákuke maka hákone simôpi hahákuti. Vo'oku koêkuti yonôti xapa hahákuti, ako exa yónoku. ");
INSERT INTO terNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Koeku ápeyeako xepákukenoe ne kouhápu'ikoti, yakútipoanoe motovâti itíkopivo kouhápu'ikotimaka po'ínuhiko xâne —kíxovokoxoane Jesus. Uke'éxone koyúhoyea ne Jesus, ipúhikopeane xapákuke. Yane ákone kûrivakaxapa. ");
INSERT INTO terNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Upánini enó'iyea iyupánevoti ítuke Jesus, hoénaxovope xunáko xapákuke neko xâne, kóyeane ákoyeahiko akútipoa. ");
INSERT INTO terNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kó'inokeneye, koati tokopóvoti neko yútoe porofeta Izâiya mekúke, enepone koêti: “Unaém, ako kutipoâti ra yemó'u koyúhone ûti. Ako iyukínovati isóneu ne hána'iti xináko képuhiu xapákuke” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ene ákoino omótova kutípeahiko, kuteâtimaka koeku kó'iyea po'íke yútoe Izâiya, enepone koêti: ");
INSERT INTO terNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Poréxoa Itukó'oviti ákoyea itópoinoake komómoyea ya ûke. Poréxoamaka kótiu'ikea omíxone ákoinoke itópoinoake noíxea ya ûke. Énomonemaka ákoino éxina isóneu koêku, koane énomonemaka ákoino aúkapapu xoko Itukó'oviti. Koati ákoinokemakamo kaítapa Itukó'oviti” kôe. ");
INSERT INTO terNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kó'inokeneye yuho Izâiya, vo'oku noíxeane yanekôyoke itúkeovo koati hána'iti ihayú'iuti ne Jesus, koane koyúhoyea koêku. ");
INSERT INTO terNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kóyeane enó'iyea kutípoti Jesus xapákuke neko tutíhiko jûdeu, itea he'ono'ú kixóvohiko hókea vo'oku píkea éxea farîzeuhiko. Koati pikotíhiko kópuhikeokono íhikaxovokuke hó'e eneponi exâ farîzeuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Koáhati ainóvoti oposí'ixoti úhepeyea isóneunoa xanéhiko ya koêkuni itúkeovo Itukó'oviti kahá'ahiko úhepeyea isóneunoa. ");
INSERT INTO terNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ina kohonóko emó'u ne Jesus. Hara kôe: —Koêkuti xâne kutipónuti, haina póhutine ûndi kutípo, itea hane kutípoxo enepone Pahukónuti nzímea yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Koane koêkuti noixónuti, koati noixoâtimaka neko Pahukónuti nzímea yâyeke. ");
INSERT INTO terNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nzimínoti ngoúhapu'ikea xâne yara kúveu mêum, maka hákone ovóheixo hahákutike ne póhutihiko kutipónuti. ");
INSERT INTO terNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Enepo áva kamoâti ra yûnzo ákotimaka itukâ, haina ûndi pahukoâmo ipíhoponeokono, vo'oku haina nzimínoti mbahúkopea xâne ipihóponovokutike, itea nzimínoti ngoíteova. ");
INSERT INTO terNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Enepone ákoti akahá'anu, ákotimaka akutipo yûnzo, anêko exókoati yonópeamo ipihóponovokutike. Enepone ihíkauvoti yûnzo, énomonemo exókoa yonópeamo ipihóponovokutike simapúne hunókoku ra mêum. ");
INSERT INTO terNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","—Haina ukeâti njokóyoke ra yûnzo, itea koati Nzá'a, enepone Pahukónuti nzímea yara kúveu mêum, exókonu nóngone ngoyúhoyea koane nóngone ngoúhapu'ikea xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Enepone páhoenonu ngoyúhoyea, énjoa itúkeovo énomone porexô xâne inámati apéyeati ákotinemo hunókoku. Yoko enepora yûnzo, koati kuteâti páhoenonu Nzá'a ngoyúhoyea. ");
INSERT INTO terNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yanekôyoke, koati tumúneke Páskoa, enepone áyui jûdeuhiko hó'eke. Éxoane Jesus símeovone kaxena ipúhikopea yara kúveu mêum koane káyukopeovo xoko Há'a. Yoko enepone ákoyea omótova okóvo Jesus neko hokoâtihiko yara kúveu mêum, tukú kíxoa yaneko pihopóne. ");
INSERT INTO terNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Énomone yanekôyo, nikotíhiko evo Jesus xapa Páskoa. Yoko tumúneke nê'e, ípihoane Ndeâpu isóneuke Juda Iskarióti, xé'a Símaum, kuríkeamo Jesus xoko xanéhiko puvâti. ");
INSERT INTO terNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Éxoamaka Jesus ápeyea xunáko, póneake Há'a, oúkeke uhá koeti koekúti, koane éxoamaka itúkeovo úkeakune xoko Itukó'oviti yoko káyukopeovonemo xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ya koeku níkeakohiko, exépukone ne Jesus, ina kurikôa ne hamá koeti ípovo oveâti oúkeke ne po'i ípovo. Yane ina véyo váhere ika'ákoa no'ékuke, ");
INSERT INTO terNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ínamaka véyo úne koane kóhokeane mbásiyake. Yane turíxovone kipóhevekexea íhikau koane kíhuhevekexopea yane váhere iká'ae no'ékuke. ");
INSERT INTO terNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ina kixôa Simaum Pêturu ahi'ókovane Jesus: —Unaém, itínemo kipohévexonu? ");
INSERT INTO terNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ina yumopâ Jesus: —Avo yéxina iséneu ra índuke kó'oyene, itea yexoâtimo tumúneke. ");
INSERT INTO terNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ina kixoá'ikomaka Pêturu: —Ákomo kalíhuina kipéhevexinu. Itea hara kixópa Jesus: —Enepomo hákoti ngipohévexopi, ákonemo omótova hékinu. ");
INSERT INTO terNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yane hara kixópanemaka Pêturu: —Unaém, hákoikopo poehâne njêve itea kipé'ikamaka ra vô'um koane ndûti. ");
INSERT INTO terNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yane hara kixópamaka Jesus: —Enepone xâne ahíkovotine, sasá'ipone. Poéhane hêve kopití'ipo koêkuiko ixómoyea yónokexo, kónokinoke kipóhevexeovo. Kene hâxa, uhá koene sasá'ipea. Énomonemaka kénenoeye koeku itíkivo ngasása'iupone. Itea ako heú yákoenoe itúkeovo sasa'ípotine —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Vo'oku éxoane Jesus itukóvotiye ne itûkoheovoti xapákuke ne hokoâti, enepone kurikoâtimo xoko xanéhiko puvâti. Énomone kó'ino: “Ako heú yákoenoe itúkeovo sasa'ípotine” kó'ino. ");
INSERT INTO terNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Uke'éxoane Jesus kipóhevekexea ne íhikau, yane itúkopane ne hamá koeti ípovo ina aukópovo xe'oku mêsa. Hara kíxovokoxo íhikau: —Yéxoanenoe koêku ne índukeinopi? ");
INSERT INTO terNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Íhexinunoe Ihíkaxoti koane Yúnae. Yoko koati tokopóvoti ne yiûho vo'oku kaná'uteoxo indúkeova. ");
INSERT INTO terNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Koeku íngutipasikeovo ovoxéti ngipóhevexeopinoe, undi Yúnae yoko Ihíkaxopiti, yusikónemaka kíxikokoneye. ");
INSERT INTO terNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Vo'oku koati indukínopitinoe hékone motovâti itíkimaka kuteâti ra índukeinopinoe. ");
INSERT INTO terNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Koati emo'úti ra yunzó'inopi, ivévakanoe: Haina ahinoêti payasô yane pátarauxa. Koane hainámaka pahoéti payasô yane pahukoâti. ");
INSERT INTO terNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Koeku yéxinoe ra koekúti, koati únatimo kêku enepo itikâ. ");
INSERT INTO terNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Enepora yunzómeku, haina uhá ketínoe ngíxo, vo'oku é'exo ngíxoixoane ne noívongoeponehiko. Kó'inokeneye, koati tokopóvoti kíxone ne yutoéti emó'uke Itukó'oviti mekúke xoko kó'iyeaku: “Enepone ixómoti iníkonu, ainovó koe énomone vaheréxinonu ítuke” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Éndo'okinopikenoe kó'oyene maka enepo avané'e ne koekúti, yakútipoanenoe indúkeova ne ngixínopike. ");
INSERT INTO terNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Koati emo'úti ra yunzó'inopinoe, ivévaka: Koêkutimo ivavákoati ne mbáhoe, undímakamo ivávako. Epó'oxo koêkutimo ivavákonuti, koati ivavákoati ne Pahukónuti nzímea yara kúveu mêum —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Uke'éxoane Jesus koyúhoyea, yupihovó koéne kotíveyea isóneu ina kixovókoxo íhikau: —Koati emo'úti ra yunzó'inopinoe, ivévaka: Anéye póhuti xepákuke itûkoheovoti koeku hókeonu, enepone kurikónutimo xoko xanéhiko puvónuti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yane noinoneké kixókokone ne íhikauhiko, akó'oti hapiké'eka itukóvotimoye xapákukehiko. ");
INSERT INTO terNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yoko ápe póhuti íhikau Jesus xêrerekuke, enepone ákoti omotóva okóvo Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Vô'u veínoa Simaum Pêturu éxokea nê'e kahá'ainoa épemo'ikea Jesus itukóvotiye ne kíxone. ");
INSERT INTO terNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yane hara kixo Jesus neko íhikau isu'oo koyeâti xa'ákuke: —Unaém, kutíyane ne kíxe? ");
INSERT INTO terNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ina yumopâ Jesus: —Énomonemo ne mbôreu itátane pâum ngaláka'iu utókuke —kíxoane. Yane veyone itátane pâum ne Jesus, ina kalaká'ikoa utókuke, ina porêxo Njûda, xé'a Simaum Iskarióti. ");
INSERT INTO terNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ehá'axo namúkoa Njûda neko itátane pâum, ûrukovane Satánae. Yane hara kíxoa Jesus: —Yéhaka itíki ne ítikemo —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yoko ako ápahuina xapákuke neko ovoti xe'o mêsa exínoati isóneu kó'inokeneye neko yuho Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Vo'oku itúkeovo Njûda koyonínoa tiûketinahiko, ápehiko ikutíxati pahukoâti Jesus ne Njûda vanéxoponea nókone vo'oku ayuíti, áko'o itúkeovomea pahukoâti pôrekexoponea tiûketi xoko xâne ákoti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ehá'axo namúkoa Njûda neko itátane pâum, ipúhikopeane xapákuke. Yoko yótine yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ipuhíkopeane Njûda xapákuke, ina kixovókoxoa Jesus ne íhikau: —Oránane éxeokono indúkeovo hána'iti ihayú'iuti, undi íhae vanúke ikútipasikoponovoti xâne. Epó'oxo vo'ónguke, iyúseotinemakamo itúkeovo hána'iti ihayú'iuti ne Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Koeku ngoúhapu'ikea itúkeovo koati hána'iti ihayú'iuti ne Itukó'oviti, koati Itukó'ovitimo kouhápu'iko indúkeovomaka hána'iti ihayú'iuti. Yoko kouhápu'ikoatimo kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Itínoe kutí ngíxone kálihunoe nje'éxaxapa, ákonemo ánju'ikene xepákukenoe. Yoposíkonutinoemo itea kuteâti yunzó'inoa ne jûdeuhiko yanekôyo vo'oku yonómboku, kúteanemaka ne yunzó'inopinoe kó'oyene: Enepora yonómboku, avo omótova yenópi kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Anéye inámati mbáhoenopinoe itíki: Hako motovókoko yokóvo. Kuteâti ngixópiku ákoyea omótovopinoe ongóvo, énomonemaka íxekakaneye. ");
INSERT INTO terNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yane heú koetímo xâne éxea itíkivo ínzikau, enepo hákoti motovókoko yokóvo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ina kíxo Jesus ne Simaum Pêturu: —Ná'ikopo yenópo Unaém? Ina yumopâ Jesus: —Avo omótova yéni xoko yonómboku yara koeku kó'oyene, itea áxu'ikenevo ínamo omotóva hékinuya. ");
INSERT INTO terNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ina kixopâmaka Pêturu: —Unaém, na koeti ákoino omótova nzókeopi yara koeku kó'oyene? Okonókovo, usó ngóye ngoépekeokono ve'ókuke. ");
INSERT INTO terNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ina kixopâmaka Jesus: —Usó kéyeoxo képekikono vo'óngu? Koati emo'úti ra yunzó'inopi, ivévaka: Tumúnekemo éneyea ne tapî'i, mopo'âtinemo keyuho ákoyea yéxanu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ina kixopâmaka Jesus ne íhikauhiko: —Hákonoe aina kixe iséneu. Koeku kívivo Itukó'oviti, kivápunumaka. ");
INSERT INTO terNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ako yumáxapu iháxakoku kúveu ne óvoku Nzá'a. Eneponi hákoti koené'eye, ákoni ínjapineye. Koati ngounákopinopitinoemo yóvokuya. ");
INSERT INTO terNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mbihapáne, enepo ngausákapinapinenoe yóvoku, ínamo ngayukápapu veyómboneopinoe, maka enepone ómboku, itúkapunemaka yópoku. ");
INSERT INTO terNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yoko yéxoanenoe ne xêne yonopâti. ");
INSERT INTO terNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ina kixôa Túme: —Unaém, ako véxa ne yenópoku. Ná'ikopo kixoâtiye véxea ne xêne yonopâti? ");
INSERT INTO terNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ina yumopâ Jesus: —Undíne itukóvo xêne yonópoti xoko Itukó'oviti. Undínemaka itukóvo poéheve ne kaná'uti kixovókuti íhae xokóyoke. Undínemaka itukóvo úkeaku ne inámapoti apéyeati ákotinemo hunókoku. Ákomo simoâti ne Nzá'a enepomo hákoti itukovo njokóyoke véko. ");
INSERT INTO terNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Eneponi yexánuxo, manímaka yexoâti ne Nzá'a. Itea ukeátine kó'oyene, yexoâtinemo koane neíxoanenoe —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ina kixôa Filípi: —Unaém, yéxakavea ne Yá'a, yane úhepetinemo visóneu. ");
INSERT INTO terNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ina kixopâmaka Jesus: —Filipí, enóne óveam xepákukenoe, itea kóyeakone âvoyea yéxanu? Enepone noixónuti, noíxoanemaka ne Nzá'a. Na koeti: “Yéxakavea ne Yá'a” ké'ino? ");
INSERT INTO terNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ako yakútipoa anéyeyea Nzá'a njokóyoke koánemaka undi xokóyoke? Enepora yunzó'inopinoe, haina ukeâti njokóyoke itea xoko Nzá'a úkea, enepone anéyeti njokóyoke. Énomone itukôa ne itukéti índuke. ");
INSERT INTO terNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yakútipoa anéyeyea Nzá'a njokóyoke, koánemaka undi xokóyoke. Enepo hákotinoe kitipôa ra yûnzo, konokoâtiko kitípinu vo'ókuke ne iyupánevoti índuke, neíxonenoe. ");
INSERT INTO terNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Koati emo'úti ra yunzó'inopinoe, ivévaka: Enepone kutipónuti, itúkotimo itukéti kuteâti ne índuke, epó'oxo anu'úkotimo hána'iko índuke ne ítuke vo'oku aúngopeovonemo xoko Nzá'a. ");
INSERT INTO terNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Uhá koeti koêkuti yépemone ya inzáke, indukínopeatinoemo, maka iháyu'ikakanane Nzá'a vo'oku índukeinopimo. ");
INSERT INTO terNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Enepo áva yépemone ya inzáke, indukínopeatimo —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ina kixovókoxopamaka Jesus: —Enepo hákotinoe motovónu yokóvo, itikoâtinoemo ne mbáhoenopi. ");
INSERT INTO terNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Embemínopitinoemo Nzá'a pahúkinopi po'i Koxunákopiti ingéneke ukeâti ya xokóyoke, ákotinemo ahíkuxeovopiku. ");
INSERT INTO terNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Énomone ne Sasá'iti Omíxone Itukó'oviti, enepone kauhápu'ikoatimo ne kaná'uti kixovókuti íhae xoko Itukó'oviti. Enepone xâne yara kúveu mêum ákoti êxa Itukó'oviti, ako omótova namúkea vo'oku ákoyea naíxa, koane ákoyeahikomaka éxa. Itea yéxoanoe, vo'oku ápeyea xikóyoke koane ovo'ó koépitinoemo. ");
INSERT INTO terNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","—Ákomo kurí ínjapinoe kuteâti koeku moyénoti. Kóyeanemo ngáyukopinovopinoe. ");
INSERT INTO terNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ákone ahíkapu ákoyeakunemo naíxanu ra xanéhiko yara kúveu mêum, itea neixóponutikomo. Epó'oxo vo'oku ámbepeakomo, keánenoemakamo. ");
INSERT INTO terNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yaneko káxe, yexoâtinenoemo ápeyea ne Nzá'a njokóyoke, koane yápeyinoe njokóyoke, ngoánemaka xikóyokenoe. ");
INSERT INTO terNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","—Enepone xâne exoâti ne mbáhoenoa itúkea koane itukoâti, koati énomone ako omotóvonu okóvo. Yoko enepone xâne ákoti omotóvonu okóvo, ákomakamo omótova okóvo Nzá'a. Ngoánemaka, ákomakamo omótova ongóvo, koane ngoutáta'ixinovatimo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ina kixôa Njûda, itea haîna neko Njuda Iskarióti: —Namo kixoâtiye itúkeovo póhutine ûti keútata'ixinovo, ákotimaka keutáta'ixinapa ne xanéhiko yara kúveu mêum? ");
INSERT INTO terNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ina yumopâ Jesus: —Enepone xâne ákoti omotóvonu okóvo, itukoâtimo ne mbáhoenoa itúkea, yane ákomo omótova okóvo Nzá'a. Vitukoâtimo vóvoheixoku xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Enepone xâne puvónuti, ako ituka yûnzo nê'e. Yoko enepora emó'um kémone kó'oyene, haina ukeâti njokóyoke itea xoko Nzá'a úkea, enepone Pahukónuti nzímea yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","—Ngoyúhoinopeanenoe ra koekúti kó'oyene koêkuiko ámbeyea xepákukenoe, ");
INSERT INTO terNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","itea enepone Koxunákopitinoe ingéneke, enepone Sasá'iti Omíxone Itukó'oviti, páhoemo Nzá'a itúkea índuke xepákukenoe, énomonemo ihíkaxopinoe uhá koeti koekúti, yoko huvo'óxopitinoemakamo puyákoponeova yokóvo ne uhá koeti yunzó'inopi. ");
INSERT INTO terNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","—Mboréxopinoe hána'iti úhepeko asako yomíxone ákoti pepakéxapu iséneu, kuteâti koeku úhepeko asako omínjone ákoti pepakéxapu inzóneu. Enepone mbónepike, haina kuteâti pónepike ra kúveu mêum. Hákonoe aina kixe iséneu, koane hákonoe píke. ");
INSERT INTO terNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kémoanenoe ne yunzó'inopimeku mbihópeanemo, koane ngáyukopeovoikomo ngahá'inepeopi. Enepo itikápuxonoe ákoti omotóvonu okóvo, mani elokeâti yokóvo koeku aúngopeovomo xoko Nzá'a, vo'oku énomone payasô ya undíke. ");
INSERT INTO terNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Éndo'okinopikenoe kó'oyene koeku âvoyea simápu kaxéna, maka simapúne, yakútipoane. ");
INSERT INTO terNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ákonemo áxu'ikene yúnzo'ixeopinoe vo'oku oránane ko'ítukeyea ne Satánae, enepone pahúkoti yara kúveu mêum. Yoko ako xunáko oúngeke nê'e, ");
INSERT INTO terNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","itea kó'inokenemoye ne véngoku, motovâti éxea xanéhiko yara kúveu mêum ákoyea omótova ongóvo ne Nzá'a yoko indúkea ne páhoenonu. Hingá, pihápane ûti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ina kixovókoxoakomaka Jesus ne íhikau: —Hara ngoéneye koati únati xuve úva, kene Nzá'a itukóvo katarákoati. ");
INSERT INTO terNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Uhá koeti káva'oya ákoti parêxa há'i, tetúkoa Nzá'a. Kene uhá koeti káva'o poréxoti há'i, kasása'ikoa motovâti xu'ínayeaxo há'i pôreu. ");
INSERT INTO terNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Koati sesa'ípotine vo'oku emó'um ngoyúhoinopikenenoe. ");
INSERT INTO terNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kuteâti koeku káva'o xoko xúve, énomonemaka kónoko ké'iyineye njokóyoke. Yane ngoánemakamoye ya xikóyoke. Kuteâti ákoyea parexa há'i ne káva'o haxá koyeâti xúve, keánenoemaka enepo ihexákinu. ");
INSERT INTO terNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Undíne itukóvo ne xuve úva, kene itínoe ne káva'ohiko. Enepone xâne koetíneye njokóyoke kuteâti koeku kávo'o xoko xúve, epó'oxo ngoánemakaye xokóyoke, enómo há'i pôreu. Vo'oku hákoti ûndi xikóyoke, ákomo ítene itíki. ");
INSERT INTO terNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Enepone xâne haxá koyeônuti, hanemo kixókononeye kuteâti kixókonoku káva'o ne tikóti tetoéti. Enepo movo'íne, ítixokonohiko ina kurikókono yúkuke oro'ókokonoti. ");
INSERT INTO terNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Itea enepo yakoéneye njokóyoke kuteâti koeku káva'o xoko xúve, epó'oxo enepo aváheixa iséneuke ne emó'um, motovâtimo yépemi koêkuti yâha yépemi, yane kousókinovopitinoemo. ");
INSERT INTO terNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yoko hane kutí'inoke ihayú'ikokonotimo ne Nzá'a enó'iyeamo únatinoe ítike, epó'oxo koati itínenoemo ínzikau. ");
INSERT INTO terNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kuteâti koeku ákoyea omótovonu okóvo Nzá'a, énomonemaka koéneye ákoyea omótovopinoe ongóvo. Hako yahikúxivoa ne ákoyea omótovopinoe ongóvo. ");
INSERT INTO terNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Enepo itikânoe ne mbáhoenopi itíki, yovóheixotimo ya ákoyea omótovopinoe ongóvo, kuteâtimaka ngíxoaku indúkea ne páhoenonu Nzá'a koane óvonzeixea ya ákoyea omótovonu okóvo. ");
INSERT INTO terNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","—Ngoyúhoinopeakenoe râ'a, ngaha'âti ápeyea xikóyokenoe kuteâti ne eómbone, enepone úhepeko inzóneu, epó'oxo ngaha'âtimaka yupihovó kó'iyea nê'e xikóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hara mbáhoenopinoe itíki: Hákonoe motovókoko yokóvo kuteâtimaka ngixópikunoe ákoyea omótovopi ongóvo. ");
INSERT INTO terNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Enepone ivokínovoti ínikonehiko, ako po'i seanákoti anu'úkoati. ");
INSERT INTO terNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Itínoemo koati íningone enepomo itikâ ne mbáhoenopi itíki. ");
INSERT INTO terNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ákonemo ínzaxeapinoe ovoxéti, vo'oku ako éxa ovoxéti ítukemo ne únae. Itea “íningone” ngixópinenoe vo'oku énjokeopea ne uhá koeti ngámone xoko Nzá'a. ");
INSERT INTO terNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Hainánoe îti noivókoxonu, itea undíne noivókoxopinoe koane mbahúkopinoe itíki índuke xapa xâne, ngaha'aînopitinoe enó'iyea únati ítike ákotinemo hunókoku. Yane uhá koeti koêkutimo yépemone xoko Nzá'a ya inzáke, porexópeatimo. ");
INSERT INTO terNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hara mbáhoenopinoe, ákoyea omótovokoko yokóvo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ina kixovókoxopaikomaka Jesus neko íhikau: —Enepo puvapínoe ne xâne yara kúveu mêum ákoti êxa Itukó'oviti, puyákapanapa yokóvo itúkeovo ûndi púvo inúxoti ya itíke. ");
INSERT INTO terNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eneponi yakutípaseahiko neko xâne, ákonihiko omótovopinoe okóvo. Itea vo'oku ákoyea yakútipasea, koane vo'oku itíkivonoe noívongoepone xapákukehiko, énomone puvínopinoe. ");
INSERT INTO terNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Puyákapanapa yokóvo neko emó'uinombinoe yanekôyoke ngoyuhó'inopi ákoyea apáyaso ne ovoxéti yane únae. Koeku íngoitoponeokono kotíveti, kúteanemakamo kixékonoku. Koêkumaka kutípeokono emó'um, kutipókonotimakamo ne yemó'u. ");
INSERT INTO terNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Itukínopeatinoemo uhá koêti ra koekúti vo'oku itíkivonoe ínzikau, epó'oxo vo'oku ákoyea éxahiko ne Pahukónuti yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Eneponi hákoti nzímo xapákuke, koane hákoti ngoyuhó'inoa emó'um, mani apêti pó'onexeovoke yara koekúti, koane ákoni pahúnevo. Itea kó'oyene, ákone pó'onevohiko. ");
INSERT INTO terNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Koêkuti xâne puvónuti, koati puvotímaka Nzá'a. ");
INSERT INTO terNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eneponi hákoti indûko koekútihiko xapákuke kuteâti ne itukéti índuke, ákoni pahúnevo yara koekúti. Itea kó'oyene, haina pohúneti noixoâti neko koekútihiko índuke, itea koati puvónuti koane puvómaka Nzá'a. ");
INSERT INTO terNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kó'inokeneye, koati kousókovoti neko kúxoti yutoéti yane Ponóvoti Kixovókuti hó'e, enepone koêti: “Puvónuhiko ákoti évotikonuke” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","—Itea simané'e ne mbáhoenopimo ukeâti xoko Nzá'a, enepone Koxunákoati ne kutipónuti ingéneke, ngixínopikenoe, énomonemo koyuhónu. Énomone ne Sasá'iti Omíxone Itukó'oviti, enepone kouhápu'ikoati ne kaná'uti kixovókuti íhae xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Keánenoemaka, keyuhónutimakamo, vo'oku ukeátinekene inâ ndurixóvo ínzikaxea, xéneheixonune. ");
INSERT INTO terNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ina kixovókoxopamaka Jesus neko íhikau: —Enepo kó'inokeneye yunzó'inopi maka hákone kopoé'ako iséneu ne tiú'iti koekúti keno'ókotimo. ");
INSERT INTO terNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Vo'oku kepúhikikonotinoemo íhikaxovoku hó'e xanéhiko, koane simóvotimo káxe pó'okeakumo itúkeovo koati itúkoti ítuke Itukó'oviti ne uhá koeti xâne koepékopiti, itínoe hokónuti. ");
INSERT INTO terNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Itea kixínoakenemoye vo'oku ákoyea exa Nzá'a, koane vo'oku ákoyeamaka éxanu. ");
INSERT INTO terNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Éndo'okopinenoe kó'oyene koêkumo ne koekúti maka simapúne kaxéna, puyákapanapanenoe yokóvo éndo'okeopine. Âvoinoke énda'akapi yanekôyoke inâ hekonúnoe, vo'oku ámbeyeako xepákuke. ");
INSERT INTO terNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Itea kó'oyene, mbihópotinemo xokóyoke ne Pahukónuti yara kúveu mêum. Yoko ako ápahuina xepákuke epemónuti yonómboku. ");
INSERT INTO terNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Itea vo'ókuke ra yunzó'inopinoe, yupíhovo ikáxu'iyea yokóvo. ");
INSERT INTO terNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","—Koati emo'úti ra yunzó'inopinoe: Unatínemo xikóyoke mbihópeane, vo'oku enepo hákotimo mbihôpo, ákomo simápinoe ne Koxunákopitinoe ingéneke íhae xoko Itukó'oviti. Itea enepo mbihâpa, mbahukínopeatinemo. ");
INSERT INTO terNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Enepo simané'e, isukeâtimo isóneu ne xanéhiko yara kúveu mêum. Exókoatimo itúkeovo pahukóvoti, koane kónokea sasá'ipea nonékuke Itukó'oviti, koane ápeyeamakamo kaxena ipihóponopeti. ");
INSERT INTO terNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Exókoatihikomo itúkeovo pahukóvoti vo'oku ákoyea akútiponuhiko. ");
INSERT INTO terNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Exókoatihikomo kónokea sasá'ipea vo'oku mbihópeane xoko Nzá'a. Yane ákonemo neíxanunoe. ");
INSERT INTO terNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Exókoatihikomo ápeyeamo kaxena ipihóponopeti vo'oku koúsokovone ipíhoponeokonokemo ne Satánae, enepone pahúkoti xanéhiko yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","—Enó'iko ânja ngoyúhoinopeanoe, itea ákoni ítea kémi ongoyúhoinopeanoe kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Enepo simané'e ne Sasá'iti Omíxone Itukó'oviti, enepone kouhápu'ikoati ra kaná'uti kixovókuti íhae xoko Itukó'oviti, énomonemo mihe'óko iséneu yéxi koeku uhá koêti ne kaná'uti kixovókuti íhae xoko Itukó'oviti. Vo'oku ákomo itúkapu isoneú kíxone koyúho, itea enepone uhá koeti kámone xoko Itukó'oviti, énomonemo koyúho, epó'oxo koyuhó'inopeatinoemakamo koêku ne koekútihiko keno'ókotikomo. ");
INSERT INTO terNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kahaná'ikonutimo nê'e vo'oku veyoâtimo ne apêti njokóyoke ínamo okoyúhopinopeanoe. ");
INSERT INTO terNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Uhá koeti ítuke Nzá'a, koatímaka índuke. Énomone ngixínopinoemeku véyeamo Sasá'iti Omíxone Itukó'oviti ne ihíkauvoti apêti njokóyoke, ínamo okoyúhopinopeanoe. ");
INSERT INTO terNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Yé'exovone ákoyeakunemo neíxanunoe, itea ákomo áxu'ikene neixóponutikomakamo —kíxovokoxoane Jesus neko íhikau. ");
INSERT INTO terNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yane ápe xapákuke neko íhikauhiko kixokókoti: —Kutimea kixó'eko ne yuhó'inovimeku, enepone koêti: “Yé'exovone ákoyeakunemo neíxanunoe, itea ákomo áxu'ikene neixóponutikomakamo” koêti? yóko'o ne “Mbihópotinemo xoko Nzá'a” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kutimea kíxo ne yuhómeku “Yé'exovone” koêti? Ako véxina visóneu —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yoko éxoane Jesus kahá'ayeahiko épemo'ikea vo'ókuke ne yûho. Hukinóvoti kíxea: —Enepone yunzómeku: “Yé'exovone ákoyeakunemo neíxanunoe, itea ákomo áxu'ikene, neixóponutikomakamo” ngoémeku, haina yepemó'ikokotinoe vo'ókuke? ");
INSERT INTO terNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Koati emo'úti ra yunzó'inopinoe, ivévaka: Iyeôtinoemo, koati kotívetimo iséneu itea elóketimo okóvo ne xâne yara kúveu mêum ákoti êxa Itukó'oviti. Ikaxú'itinoemo yokóvo, itea enepone ikáxu'ine yokóvo, sa'irí'okopovotimo ya hána'iti elókeko yokóvo. ");
INSERT INTO terNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Noixó íxea ne sêno ye'éxovotine ipúhikope xe'éxa. Ikáxu'i okóvo vo'oku símeovone koítoponovope kotíveti. Itea ipuhíkone ne xe'éxa, ákone puyákapanapa okóvo ne êno tiveko koêku. Poéhane êno hána'iti elókeko okóvo apê vo'oku ipúhikeane xe'éxa yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Énomonemakamo koéneye ikáxu'iyea yokóvo kó'oyene, itea kóyeanemo noínjopeopikonoe. Yane yupihovó koetínemo elókeko yokóvo. Yoko ákonemo itoâti veyópea. ");
INSERT INTO terNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","—Simapúne neko káxe, ákonemo yépemonuke. Koati emo'úti ra yunzó'inopinoe, ivévaka: Áva yépemone xoko Nzá'a ya inzáke, porexópeatimo. ");
INSERT INTO terNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tukú koeti kó'oyene, avo yépemone ya inzáke. Yépemanoe, vo'oku perexókonoatimo, maka yupihovó ákoene elókeko yokóvo —kíxovokoxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ina kixovókoxopamaka Jesus ne íhikau: —Enepora yunzó'inopinoemeku, ako ponó ínjinapea. Koati apêti ínzokinopeake. Itea harakénemo káxe ákoyeakunemo ingá'itukexa kuteâti ínzokinopeakemeku vo'oku ponó ngixoâtimo ngoyúhoinopeanoe koêku ne Nzá'a. ");
INSERT INTO terNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yaneko káxe, yepémotimo Nzá'a ya inzáke. Ákonemo itúkapu undíne epemínopinoe. ");
INSERT INTO terNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kó'inokenemoye vo'oku ákoyea omótovopinoe okóvo ne Nzá'a koeku ákoyea omótovonu yokóvo, koane vo'oku kitípi itúkeovo úngeakune xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xoko Nzá'a úngea koeku nzímea yara kúveu mêum. Kó'oyene imbuhíkopeatinemo ra kúveu mêum, koane mbihópotinemo xoko Nzá'a —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ina kixôa íhikauhiko: —Kó'oyene, ínateoxo uhapú'inovi ne yiûho. Ákone itúkapu apêtike íhekoake. ");
INSERT INTO terNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kó'oyene, iyúseone yéxi uhá koeti koekúti. Ákone apásika epemó'ikopiti koêku. Énomone kutípinopi ûti itíkivo koati ukeâti xoko Itukó'oviti —kíxoanehiko íhikau. ");
INSERT INTO terNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ina kixovókoxopamaka Jesus: —Kitípoaneoxo kó'oyene? ");
INSERT INTO terNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Harakéne ôra, yoko koati simóvotine kó'oyene itéhineyimo, péhutinoe yenópotimo yóvokuke. Kurí kixénutinoemo mbóhuxeovo. Itea haina mbohúxovoti vo'oku anéye Nzá'a njokóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kó'inokeneye ra yunzó'inopi, ngaha'aînopitinoe úhepeyea iséneu ingéneke. Kene yara kúveu mêum, vikotínoemo kotíveti koekúti, itea hákonoe píke vo'oku undíne itôa uhá koeti koekúti yara kúveu mêum —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Uke'éxoane Jesus koyúhoyea ra koekútihiko, ina komômo vanúke. Hara kôe: —Pai, simóvone ôra. Keúhapu'ika indúkeovo hána'iti ihayú'iuti, undi Xi'íxa, motovâtimaka ihéyu'ikikonomo vo'ónguke. ");
INSERT INTO terNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Koáhati ûndi peréxo éxea koeku uhá koeti xâne motovâti mboréxea apéyeati ákotinemo hunókoku xoko uhá koeti xâne pénenu kutípeonu. ");
INSERT INTO terNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yoko enepone apéyeati ákotinemo hunókoku, énomone ne éxeopihiko itúkeovo póhutine îti itukóvo koati kaná'uti Itukó'oviti, ákoti po'ínu, koane éxeonumaka, undi Jesus Kristu, péhoe yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ngahána'ikopine koeku óveam yara kúveu mêum, ngousókoati ne itukéti péhoenonu indúkea. ");
INSERT INTO terNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kó'oyene Pai, kuteâti koeku indúkeovo hána'iti ihayú'iuti yanekôyoke ovo'íngo xikóyoke, tumúneke ápeyea ra mêum, peréxapanumaka ngó'iyeaneye koeku nzeópea xikóyoke. ");
INSERT INTO terNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","—Éxopine ra hóyenohiko pénenu kutípeonu yara kúveu mêum, vo'oku ngoyúhoyeopi xapákuke. Aínovone ítike. Itíne porexónoa yoko kutípoanehiko ne yemó'u. ");
INSERT INTO terNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kó'oyene, éxoanehiko kaná'uyeoxo itúkeovo ukeâti ya xikóyoke ne uhá koeti peréxonuke kutípeonu, ");
INSERT INTO terNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","vo'oku ngoyúhoinoahiko yemó'u, námoem xikóyoke, yoko kutípoanehiko. Koati exoâtihiko itúkeovo xikóyoke úngea, epó'oxo kutípoahiko itúkeovo îti pahukónu yâyeke. ");
INSERT INTO terNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","—Koati énomonehiko émbeminopi. Kene haîna ne xâne ákoti exápi yara kúveu mêum émbemino, itea koati embemínoati ra xanéhiko pénenu kutípeonu vo'oku itúkeovo ítikenehiko. ");
INSERT INTO terNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Uhá koeti índuke, ítikenemaka. Yoko uhá koeti ítike, índukenemaka, epó'oxo koati ngahaná'ikokonoti vo'ókukehiko râ'a. ");
INSERT INTO terNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kó'oyene imbuhíkopeatinemo ra kúveu mêum, itea enepohikorâ'a, óvokuikonemo yâye yara kúveu mêum koeku mbihópeane xikóyoke. Iti sasá'iti Nzá'a, itíne okoyóninonoahiko ya xinákoke ne hóyenohiko pénenu kutípeonu, motovâti poéhapea vikéneke kuteâtimaka koeku poéhayeane ûti. ");
INSERT INTO terNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Koeku ámbeyea xapákuke ne pénenu kutípeonu, undíne koyonôa ya xinákoke. Ngóyonoa maka hákone ikorókovo váhereke. Énomone ákoino ápahuina yonópoti ipihóponovokutike xapákuke, ákoti itukápa neko póhuti itûkoheovoti koeku hókeonu, enepone motovâti pahúkopeokonoya. Kó'inokeneye, koati kousókovoti neko kúxoti yutoéti ya yemó'uke. ");
INSERT INTO terNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kó'oyene, mbihópotinemo xikóyoke, itea kó'inokeneye ra yûnzo kó'oyene koêkuiko ámbeyea yara kúveu mêum, motovâti yupíheovo hána'iko úhepeko isóneu ne ínzikauhiko, kuteâtimaka koêku ne úhepeko inzóneu. ");
INSERT INTO terNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ngoyúhoinoanehiko yemó'u, yoko itúkovone púvonehiko xâne ákoti exápi yara kúveu mêum vo'oku ákoyea akútipaseahiko, kuteâtimaka ákoyea angútipaseahiko neko xâne. ");
INSERT INTO terNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Pai, haina embemópiti viyópi yara kúveu mêum ne kutipónutihiko, itea embemópiti kéyonoyihiko motovâti ákoyea íkarakapu váhereke, ");
INSERT INTO terNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","vo'oku ako akútipaseahiko ne xâne yara kúveu mêum ákoti exápi, kuteâtimaka ákoyea angútipaseahiko. ");
INSERT INTO terNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Peréxahiko ne kutipónuti itúkeovo haxakínovoti ítike ya koeku hókeahiko ne kaná'uti kixovókuti íhae xikóyoke. Yoko yemó'u itukóvo ne kaná'uti kixovókuti. ");
INSERT INTO terNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kuteâti pehúkinu yara kúveu mêum, mbahúkoamaka ra ínzikauhiko yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Koati vo'ókukehiko, nzaxákinovo indúkea yahá'inonu motovâtimakamo itúkeovo haxakínovatihiko itúkea ne yahá'inoa. ");
INSERT INTO terNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Haina póhutinehiko râ'a émbemino, itea émbeminoamaka ne kutipónutikomo, ehóponomo yuhóhiko râ'a, ");
INSERT INTO terNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","motovâti poéhapeanehiko vikéneke. Kuteâti koeku itíkivo póhutine njokóyoke Pai, koánemaka ûndi xikóyoke, émbeminoamaka ne kutipónutihiko poéhapeamo xoko ûti, motovâtimo kutípea xanéhiko ákoti exápi yara kúveu mêum itúkeovo îti pahukónu yâyeke. ");
INSERT INTO terNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kuteâti peréxinu indúkeovo hána'iti ihayú'iuti, mboréxoanemaka ne ínzikauhiko kó'iyeaneye, motovâti poéhapeanehiko vikéneke kuteâti koeku poéhayeane ûti Pai, ");
INSERT INTO terNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","koeku ámbeyea xokóyokehiko, keánemaka njokóyoke. Yane ákomo iháxakexeakaka, itea uha-uhá koetímo poéhapeanehiko vikéneke, kutí'inokemo exoâti xanéhiko ákoti exápi yara kúveu mêum itúkeovo îti pahukónu yâyeke, koane exoâtimakamo ákoyea omótovahiko yokóvo kuteâti ákoyea omótovonu yokóvo. ");
INSERT INTO terNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","—Pai, ngahá'ainoahiko ne pénenu kutípeonu óveahikomo njokóyoke, maka naíxanehiko peréxinu indúkeovo hána'iti ihayú'iuti. Koáhati ákoti omotóvonu yokóvo ukeâtinekene tumúneke ápeyea ra kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pai, koati ponóvoti ne kixeku itíkivo. Ako éxapi ne xanéhiko yuixóvati ra kixovókuti yara kúveu mêum. Undíne exópi, koáne éxoamaka ra kutipónutihiko itúkeovo îti pahukónu yâyeke. ");
INSERT INTO terNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Énjokoanehiko itukóvotiye ne îti, epó'oxo káxehiko keno'ókoti, kóyeakonemo énjokeahiko, maka aváne xokóyokehiko ne hána'iti ákoyea omótovo yokovo xâne, kuteâti ákoyea omótovonu yokóvo, epó'oxo maka ovo'ó ángoanehiko —koe orásauna Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Uke'éxoane Jesus koyúhoyea neko koekútihiko, pihóne poixô'oke ne kali nótuvaka koéhati Sêdorom. Íhikauhiko xáne. Yoko ápe kali njârdim-ya. Énomone yóno ne Jesus yoko íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kene Njûda, enepone itûkoheovoti koeku hókea Jesus, enepone kuríkotimo Jesus xoko xanéhiko puvâti, éxoa óvoku neko njârdim, vo'oku kóyekune yónea Jesus-ya koane íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Úkeane pího ne Njûda yane njârdim porexókonoane ne húndaruhiko xané'eyea, koánemaka ne koyónotihiko hána'iti imokóvokuti. Yoko enepone xánenahiko, aínovo páhoe tutíhiko sasedóti inuxínoti jûdeu hó'eke, yoko farîzeuhiko, enepone koati yuixóvoti hókea yútoe Muîse. Ako tôpihiko kaúhapu'ikope oxéne ómonehiko, yoko isukópeti. ");
INSERT INTO terNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yoko koati exoâti Jesus uhá koêti ne kixókonokumo, yane inuxó koene épemea itúkovokehiko. Hara kíxovokoxoa: —Kuti yopósikonoe? ");
INSERT INTO terNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ina yumopâhiko: —Jesus vopósiko, enepone íhae Nazâre. —Undíneye —koéne ne Jesus. Yoko ápe Njûda xapákuke, enepone kuríkoti Jesus xoko xanéhiko puvâti. ");
INSERT INTO terNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ehá'axo “undíneye” kó'iyea ne Jesus, aúkopovohiko ikéne neko xanéhiko, xaneâtimaka íkorohikeovo poké'eke. ");
INSERT INTO terNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ina kayukópaikomaka Jesus kíxovokoxea: —Kutí'oxonoe yopósiko? Ina yumopâhiko: —Jesus íhae Nazâre. ");
INSERT INTO terNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ina kixovókoxopamaka Jesus: —Ngixópinepepomeku itúkeovo ûndi ne yopósiunoe. Ya koeku itúkeovo ûndi yopósikonoe, síkeaneikopo ra nza'ínehiko pihópea —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kó'inokeneye emó'u, motovâti koúsokea neko yûho yanekôyoke, enepone koêti: “Pai, ako ápahuina évoem yane pénenu kutípeonu” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Énomone yanê'e, hé kíxoane Simaum Pêturu ne hána'iti pirítauna. Maturukenó kixone ahínoe koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke. Koati éxopeke kêno neko ahinoêti koéhati Maúku etetúko. ");
INSERT INTO terNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Itea hara kíxoa Jesus ne Pêturu: —Hako kixeáneye. Keúnakapa mótokike ne hána'iti piríteuna. Ikítixati ákotimo vengâ ne kotíveti koekúti évekonukumo Nzá'a? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yane namúkone Jesus ne húndaruhiko, koánemaka neko koati pahúkoti xapa húndaruhiko, koáne ne jûdeuhiko koyónoti hána'iti imokóvokuti, ina ika'ákohiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ponó kíxoanehiko xoko Ána inúxotike, enepone imóxuko Kaífa. Yoko Kaífa, énomone neko koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke yaneko xoénae. ");
INSERT INTO terNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yoko énomone ne Kaífa kixovókoxoa ne pahúkotihiko xapa jûdeu yanekôyoke motókeyea ápeyea póhuti hóyeno ivokínovati ne xanéhiko. ");
INSERT INTO terNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yane pihóne ikéneke Jesus ne Simaum Pêturu, koánemaka ne po'i íhikau Jesus. Vo'oku itúkeovo éxone ne koati payásoti sasedóti neko po'i íhikau Jesus, xánena Simaum Pêturu, énomone ûrukinova kíndanake óvoku neko koati payásoti sasedóti ikéneke Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kene Pêturu, ôvane meúkeke xe'ókuke pahapéti. Ina ipuhíkopomaka neko po'i íhikau Jesus, éxone ne koati payásoti sasedóti, ina epêmo ârunoe koyonoâti ne pahapéti yusíkea ûrukeovomaka ne Pêturu. Yanê'e, ûrukovone Pêturu ikéneke. ");
INSERT INTO terNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yane hara kixo Pêturu neko seno ahinoêti koyónoti pahapéti: —Haina îti po'ímaka íhikau ne hóyeno? —Haina ûndi —kíxoane Pêturu. ");
INSERT INTO terNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yoko óxokuxonehiko yúku neko ahinoêti, koánehiko ne koyónoti hána'iti imokóvokuti, itúkotihiko onókovoku, vo'oku itúkeovo kásati yanekôyo. Yane onókoponovonemaka Pêturu xapákuke. ");
INSERT INTO terNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yane épemo'iko Jesus ne koati payásoti sasedóti koêku neko íhikauhiko yoko koêku ne ihíkauvoti íhikaxone. ");
INSERT INTO terNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ina yumopâ Jesus: —Uhá koeti inzíkaxo, xapákuke xâne óvom. Koati hána'itike imokóvokuti indúko ínzikaxoku, áko'o itukovo íhikaxovokuke hó'e xanéhiko, ho'úxovoku heú koeti jûdeu. Ako ihíkauvoti njé'ono'oe. ");
INSERT INTO terNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na koeti yépemo'ikinonu? Hane yépema'ikahiko kamokénonuti, vo'oku é'exo kíxoahiko neko yûnzo ínzikaxoake —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Koyuhoâne Jesus nê'e, ápe póhuti xapákuke neko koyónotihiko hána'iti imokóvokuti ipusókoti Jesus. Hara kíxoa: —Énomone kixókono yumópeokono ne koati payásoti sasedóti? ");
INSERT INTO terNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ina kixôa Jesus: —Áva mbahúnevo, yéxakanaikopo. Kene hakô'o, ná'ikopo koeti isíkinonu? —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ina pahukópamaka Ána xoko Kaífa, enepone koati payásoti sasedóti. Yoko ina ikávo'uxovo ne Jesus píhea. ");
INSERT INTO terNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Yoko ixómoiko onokóvo ne Simaum Pêturu, apé kôe po'i kixopâti: —Haina îti po'ímaka íhikau ne hóyeno? —Haina ûndi —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yane apé koénemaka ahínoe koati payásoti sasedóti, iyéno neko mótorukeake kêno Pêturu. Hara kôe: —Hainámeku îti noínjo njârdim-ke kehá'ineyi ne hóyeno? ");
INSERT INTO terNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—Haina ûndi —kixópanemaka Pêturu. Ehá'axo koyúhoa Pêturu nê'e, éneone tapî'i. ");
INSERT INTO terNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yane ukopeâne óvokuke Kaífa, omópohiko Jesus xoko óvoku nâti, enepone óvokumaka natíxea. Yoko yuponii koetíne. Ako ûrukapahiko tuti jûdeu pikoti ákoyea paréxakanahiko níkea xapa áyui Páskoa eneponi ikapíti'ikapu, anahíxapani neko xâne ákoti itukapu jûdeu. ");
INSERT INTO terNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yane ipúhikinoa Pilátu yúho'ixoponeahiko. Hara kíxovokoxoa: —Kuti itukóvo váhere ítuke ra hóyeno yomínoakenoe yâye? ");
INSERT INTO terNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ina yumopâ tutíhiko jûdeu: —Ikítixatini vomâti yâyeke ra hóyeno eneponi hákoti vévotikoake? ");
INSERT INTO terNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ina kixovókoxopamaka Pilátu: —Yamápaikoponoe. Itínenoe exâ kíxoaku, koêkuti ínixene kuteâti páhoenopi hé'e. Ina yumopâ jûdeuhiko: —Itea haina ûti motovâ koépekea xâne kuteâti mani nókone kíxea ûti, páhoenovi ho'e ûti kuteâti nókone kíxeokono ra hóyeno —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yoko kó'inokeneye, motovâti koúsokeovo neko yuho Jesus koyûho yanekôyo kixoku ivókeovomo. ");
INSERT INTO terNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ina urúkopovomaka ovokútike ne Pilátu. Yane iháxikone Jesus, ina kixôa: —Ití'oxo natina jûdeuhiko? ");
INSERT INTO terNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ina yumopâ Jesus: —Koati ukeâti iséneuke kehá'ayi yéxi? áko'o kémone xapákuke xanéhiko koyuhoâti indúkeova, kutí'inoke yepemó'ikonuti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ina yumopâ Pilátu: —Haina undi jûdeu. Ako kalíhuina yuínjeovo koekúti kuteâti. Koati iyínoxapa jûdeu yoko tutíhiko sasedóti kurikóponopi njokóyoke. Kutí'ikopo itíko pehúnevo? ");
INSERT INTO terNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ina yumopâ Jesus: —Enepone nandíxea, haina kuteâti koeku natíxea xâne yara kúveu mêum. Eneponi akoéneye, mani kotixónuti ne ovoti njêrerekuke huvo'óxonuti nandíxea, maka hákoneni kixonúneye jûdeuhiko kuteâti ra kixónuku. Itea enepone nandíxea, haina kuteâti natíxea xâne yâye yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ina kixôa Pilátu: —Ití'ikopo nâti? Ina yumopâ Jesus: —Enepone yépemonuke, kaúhapu'ikoa indúkeova. Énomone imbúhikino yara kúveu mêum. Énomonemaka nzimíno yâyeke, motovâti ngoyúhoyea koêku ne kaná'uti kixovókuti. Yoko uhá koeti xâne kutipoâti ra kaná'uti kixovókuti, énomone kutipôa ra emó'um —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ina kixôa Pilátu: —Kutí'ikopo itukóvoye ne kaná'uti kixovókuti? —kíxoane. Koyuhoâne Pilátu nê'e, ina aukópovomaka xoko jûdeuhiko meúkeke. Hara kíxovokoxoa: —Ako ápahuina íninjone váhere ítuke ra hóyeno. ");
INSERT INTO terNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Itea heú koeti xoénae ya kaxena yáyuinoe, kóyekune yépeminu nguríkopea póhuti iká'aeti. Kehá'aikopo nguríkopea ra netínanoe, itínoe jûdeu? —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Itea heú koénehiko vaúkexopeamaka. Hara koe yûho vaúkexea: —Ako vakáha'a kuríkopeokono nê'e. Hane kiríkapa, Mbarâba —koénehiko yûho. Yoko enepone Mbarâba, koati apêti váhere ítuke iká'akinokonoke. ");
INSERT INTO terNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yane pahúkoane Pilátu yehépoke'exeokono ne Jesus, ");
INSERT INTO terNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ínamaka uhekéxinoa húndaruhiko ka'áveti káva'o tikóti itukínoati kôroana ne Jesus, ina ipíhea tutíkuke. Itúkinoamaka harará'iti ípovo hamá koeti, kuteâti ípovo nâti, ");
INSERT INTO terNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","koane ahí'okeovahiko koémoke'eyea. Hara koéhiko: —Iháyu'ikakana ra natina jûdeu! —koéhiko, koánemaka ipúsononeyeahiko. ");
INSERT INTO terNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yane ipúhikopinoamaka Pilátu neko jûdeuhiko meúkeke, ina kixovókoxoa: —Ngopúhikinopeati ra hóyeno maka yéxanenoe ákoyea ápahuina íninjone váhere ítuke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yane ipúhikopinoamaka Jesus. Yoko ápe ne uhékeuti káva'o ka'áveti tikóti tutíkuke, kôroana, koáne ne harará'iti ípovo. Ina kixovókoxoa Pilátu neko jûdeuhiko: —Harâ'apo ra hóyeno —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Itea ehá'axo noixo Jesus ne tutíhiko sasedóti inuxínoti jûdeu hó'eke yóko'o ne koyónotihiko hána'iti imokóvokuti, vaúkexonehiko. Hara koe yûho vaúkexea: —Kirúhuxa! Kirúhuxa! —kóyehiko. Ina kixovókoxoa Pilátu: —Itínenoe kuruhúxa vo'oku ako ápahuina íninjone váhere ítuke ra hóyeno. ");
INSERT INTO terNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ina kixôa jûdeuhiko: —Ápe Ponóvoti Kixovókuti hó'e ûti. Kuteâti íhikaxeovike hó'e ûti, konókoti koépekeokono ra hóyeno, vo'oku koati itûkovoti Xe'exa Itukó'oviti —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kameáne Pilátu neko yuhóhiko, yupihovó koéneoxo píkea. ");
INSERT INTO terNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ina urúkopovomaka ovokútike, enepone óvokumaka natíxea, ina epemó'iko Jesus úkeaku, itea ako yumápa Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ina kixôa Pilátu: —Ako yimápanu? Ako yéxa ápeyea njunáko mbahúkea kiríkopikono, áko'o kirúhuxikono? ");
INSERT INTO terNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ina yumopâ Jesus: —Ákoni xináko kíxinuneye eneponi hákoti itukovo Itukó'oviti porexópea. Énomone itúkinovo koati hána'iti pahúnevo ne xâne kurikónuti xikóyoke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ukeâti neko ókoku ôra, opósikoa Pilátu kíxoaku kuríkopea ne Jesus, itea koati vaukéxotine ne jûdeuhiko. Hara koe yûho vaúkexea: —Enepo kirikápa ra hóyeno, hainá'ikopo iti ínikone koati payásoti natina ûti, enepone Sêza, vo'oku uhá koeti xâne koyúhoti itúkeovo nâti, koati okópoti Sêza nê'e —koénehiko vaúkexea. ");
INSERT INTO terNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kameáne Pilátu neko yuhóhiko, ina ómo Jesus meúkeke, ínamaka ivatáko yuhoíkovokutike xoko iháxoneti “Pavímentu”. Kene ya ebaraíku, emó'u jûdeuhiko, Ngâbata koéha. ");
INSERT INTO terNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yoko poéhaiko káxe âvoti tumúneke Páskoa, enepone áyui jûdeu ya hó'eke. Ye'éxovotinemaka itumúkoti káxe yanekôyoke. Ina kixôa Pilátu neko jûdeuhiko: —Harâ'a ra netínanoe —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Itea hara koe yuhóhiko vaúkexea: —Képeka! Képeka! Kirúhuxa! —kóyehiko. Ina kixovókoxoa Pilátu: —Keha'aînonutinoe mbahúkea kurúhuxeokono netínanoe? Ina yumopâ tutíhiko sasedóti: —Ako po'i natina ûti ákoti itukapu Sêza —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yane kurí'okoane Pilátu neko xâne motovâti kurúhuxeahiko. ");
INSERT INTO terNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Úkeane omohíko Jesus, koinó kixoti kurúhuna yonoti xokóyoke ne iháxoneti “Opepú'iti”. Kene ya yuho jûdeu, Ngoûgota koéha. ");
INSERT INTO terNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Énomone kurúhuxokono Jesus yoko po'i pi'âti hóyeno xêrerekuke. Enepone kurúhuna Jesus, kukúkeke óvo. ");
INSERT INTO terNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Yoko ápe yútoe Pilátu ixupáxovoti tutíkuke ne kurúhuna Jesus. Hara kôe ne yutoétiya: “Jesus íhae Nazâre, natina jûdeuhiko” kôe. ");
INSERT INTO terNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Êno jûdeu yuhoíkoati neko yutoéti, vo'oku ákoyea ahika pitivóko neko kurúhuxokonoku Jesus. Yuhóke jûdeuhiko yutóxeovo, koáne ya yuhóke rómanu, yoko ya yuhókemaka ngerêku. ");
INSERT INTO terNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ina kixohíko Pilátu ne tutíhiko sasedóti inuxínoti jûdeu hó'eke: —Hako “natina jûdeu” kixêa ne yítoe, itea hara ákoe, “Koyuhoâne râ'a itúkeovo natina jûdeu” ákoe. ");
INSERT INTO terNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ina yumopâ Pilátu: —Enepone yúndoe, usóne. Ákonemo ípakapu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kuruhúxone Jesus neko húndaruhiko, haxákokoahiko ípovo ya koaturu koêti. Póhutihiko húndaru, poéha íparaya. Ina apémaka po'inu ípovo Jesus hamá koêti, ikó'itukeu opékuke po'i ípovo. Yoko ako úhe'o nê'e, herupí kôa. ");
INSERT INTO terNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yane hara kixókoko ne húndaruhiko: —Yusikóne ákoyea kávarerea ûti râ'a, itea kuríkavo ûti komomâti ûti itukoâtimo —kixókokone. Kó'inokeneye, koati tokopóvoti neko kúxoti yutoéti ya emó'uke Itukó'oviti, enepone koêti: “Haxákokoa ne ímbovo, ina kurikóhiko, komomâti itukoâtimo ne po'i ímbovo” koêti. Yoko koati énomone kixínoaneye húndaruhiko. ");
INSERT INTO terNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Hevékuke ne kurûhu, ápe eno Jesus; yoko po'i êno; koánemaka Mâriya, enepone yeno Kolópa; yókomaka Mariya Mandâlena. ");
INSERT INTO terNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Noixoâne Jesus neko êno, yóko'omaka ne po'i íhikau ákoti omotóva okóvo xêrerekuke, hara kixo êno: —Kutí íxepane xi'íxa râ'a —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kúteanemaka yuhó'inoa Jesus neko íhikau: —Kutí íxepane mémaina —kíxoane. Ukeátine yaneko káxe, omópone Mâriya neko íhikau Jesus óvokuke katarákopati. ");
INSERT INTO terNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Exoâne Jesus koúsokeovone uhá koêti ne nókone koúsokeovo xokóyoke, hara koéne: —Epékonuti úne —koéne. Yane koati tokopóvoti neko kúxoti yutoéti ya emó'uke Itukó'oviti koyuhoâti kó'iyeanemoye. ");
INSERT INTO terNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yoko ápe íhaku ekâtiya puhí koati viyum-hí koêti. Ina apê kalaká'ikoponoti esponja yane víyum, ika'ákoa kirípuhike mayane étakati iháxoneti isôpo, ina ipíhoa pahákuke Jesus, iyúkoati. ");
INSERT INTO terNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Enovâne Jesus neko víyum, hara kôe: —Únzexone uhá koeti nóngone indúkea —koéne. Yane nonoo koéne, îhunokoane ne omíxone, ivókovone. ");
INSERT INTO terNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yoko puvâti jûdeuhiko óvoheixeamo kuruhúke ya sâputu ne kurúhuxonehiko vo'oku itúkeovo kóyuseovopene áyui, koáne vo'oku itúkeovo koati téyonehiko neko sâputu ye'ékotine ûrukeovo. Ene épeminohiko Pilátu pahúkea kehokeâti pukúna neko kuruhúxovotihiko, hopenóxoati ivókeovohiko motovâti veyópeovo kuruhúke tumúneke ne ayuíti. ");
INSERT INTO terNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yane pihónehiko ne húndaru kéhokexoponea pukúna ha'ínehiko Jesus kurúhuxeokono, enepone inúxoti koánemaka ne po'ínu. ");
INSERT INTO terNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Itea koeku símea xoko Jesus, noixoâne ivókeovone, ákone kíxoaku. ");
INSERT INTO terNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Itea ápe póhuti húndaru yuvorókeati xêrere ya suîke. Yane ipúhikone íti yoko úne. ");
INSERT INTO terNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Enepone noixoâti ra koekúti, énomonemaka koyuhópa yarâ'a. Yoko koati kaná'uti ne yûho. Éxoa yutoxínoati râ'a itúkeovo koati kaná'uti yûho, kutí'inoke motovâtimaka kitípinoe. ");
INSERT INTO terNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Enepo kixínokonokeneye Jesus, koati kousókovoti neko kúxoti yutoéti ya emó'uke Itukó'oviti, enepone koêti: “Ákomo ápahuina ôpe ekehókoti” koêti. ");
INSERT INTO terNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Koane hara koémaka po'íke: “Noixoâtimo ne yúvoroe” koémaka. ");
INSERT INTO terNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ikénepoke neko koekútihiko, pihóne xoko Pilátu ne Yûse, enepone íhae pitivóko koéhati Arimáteya epemóponoati yusíkea veyópea muyo Jesus kuruhúke. Yoko koati íhikaumaka Jesus neko Yûse, itea he'ono'ú koêti itúkeova vo'oku píkea po'ínuhiko jûdeu. Poréxoa Pilátu itúkea kuteâti épemone. Yane pihóne ne Yûse veyóponea muyo Jesus kuruhúke. ");
INSERT INTO terNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yoko Nikôdemu xáne, enepone yuhó'ixoponoti Jesus ya yóti yanekôyoke. Ápe êno xêru, alôe anahíxovoti mîra, ómone ne Nikôdemu, óvo'okope Jesus. Yoko ináko neko xêru, anêko kuteâti tirintai sinku koeti kîlu ovâti. ");
INSERT INTO terNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yane veyóponehiko muyo Jesus kuruhúke, ina aupíxoahiko ya ipovóti ovóheovoti xêru, kuteâti kíxoaku jûdeuhiko enepo apê ivokóvoti xapákuke. ");
INSERT INTO terNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yoko yaneko óvoku Jesus kurúhuxeokono, ápe njârdim. Ápemaka uhôro kehoéti mopoíke, inámatiko ekóxokonoku ivokóvoti âvoti ekoxóvati. ");
INSERT INTO terNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Énomone iyónopahiko neko muyo Jesus vo'oku ákoyea ahíka, koane iyóvotinehiko okóvo vo'oku itúkeovo kóyuseovopene jûdeuhiko vo'oku áyui. ");
INSERT INTO terNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yaneko yúponipe lûmingu hahá'iko, pihóne ne Mariya Mandâlena xoko ekóxokonoku Jesus. Simonéya, noíxoane ahíkuxeokonone neko mopôi exexoâti ne uhôro yane ekóxokonoku Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yane ehákopovo xoko Simaum Pêturu, koánemaka xokóyoke neko po'i íhikau Jesus, enepone ákoti omotóva okóvo Jesus. Hara kixóponoa: —Veyópokonone muyo Vúnae yane ekóxokonoku. Ako véxa iyónopokonoku —kíxoane Mâriya. ");
INSERT INTO terNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Úkeane pího ne Pêturu koánemaka neko po'i íhikau Jesus xoko ekóxokonoku. ");
INSERT INTO terNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Xané kixókokohiko ehákeovo neko pi'âti, itea xuxapáneoxo ya Pêturu neko po'i íhikau Jesus. Inuxó koéne nê'e símeaya. ");
INSERT INTO terNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ina yupunínikovo komomâ kúveuke. Tokononé koane ûke ne ipovóti líyum, itea ako ûrukapu uhorókuke. ");
INSERT INTO terNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Oko'ikené kíxoane Simaum Pêturu símea, yane urukú koáne. Noíxoane ne ipovótiya, ");
INSERT INTO terNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","koánemaka neko léhu aúnone Jesus, itea haxá kóye óvoku, ako ánahixapa neko po'ínuhiko ipovóti aúpi. ");
INSERT INTO terNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yane ûrukovanemaka po'i íhikau Jesus, enepone inuxó koeti símeaya. Noixoâne, kutípoane exépukopeane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yoko tukú koêti neko ókoku ôra, avo éxinahiko isóneu neko yutoéti ya emó'uke Itukó'oviti koyúhoti kónokea exépukopea ne Jesus ukópea xapa ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yane káyuhikopovone neko pi'âti íhikau Jesus óvokuke. ");
INSERT INTO terNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Koeku pihópea neko pi'âti, óvaikone ne Mâriya ixómoyea íyo xe'ókuke ne uhôro ekóxokonoku Jesus. Koeku íyoyea koane yupúninikeovo komómoyea kúveuke. ");
INSERT INTO terNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Yane tokononé koane ûke ne pi'âti ánju íhae vanúke, ovoxe Itukó'oviti, ainóvoti hopú'iti ípovo. Vataká kóye xoko óvine muyo Jesus, poéha tutíkuke, poéhamaka hevékuke. ");
INSERT INTO terNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ina kixohíko Mâriya: —Senó, na koeti íyeino? Ina yumopâ Mâriya: —Omopókonotine mûyo ne Únaem. Akó'oti enjâ iyónopokonoku —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Uke'éxoane Mâriya koyúhoyea nê'e, ina na'akénexovo. Yane noíxone Jesus xe'ó koyêti itea ako éxapana. ");
INSERT INTO terNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ina kixôa Jesus: —Senó, na koeti íyeino? Kuti yopósiko? Yoko ikútixati Mâriya koyonoâti ne njârdim. Hukinóvoti kíxea: —Unaém, itukapu îti veyopêa mûyo, yokóyuhoinonoa iméponoaku maka veyámbanane —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yane ina iháxoa Jesus: —Mariyá —kíxoane. Ná'akene koéne ne Mâriya, ina kíxo Jesus ya emó'uke jûdeu: —Raboní! —kíxoane. (Yoko “ihíkaxoti” koêti ne rabôni koêti.) ");
INSERT INTO terNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ina kixôa Jesus: —Hako nemu'ókonu, vo'oku âvoyea mbihápa xoko Nzá'a, itea pîhe xoko ínzikauhiko, enepone kutí ngíxone mbo'ínuhiko. Yéta'akapanahiko mbihópeanemo xoko Itukó'oviti Nzá'a yoko Yá'anoemaka, enepone Únaem yoko Yúnaemaka —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yane ponó koépone ne Mariya Mandâlena xoko íhikauhiko Jesus. —Noínjopane ne Vúnae —kíxovokoxoane. Ina koyuhópinoahikomaka neko yuho Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Énomone yaneko lûmingu ya kíyo'i káxe, exexo'ikené koyépoti neko íhikauhiko Jesus yane ovokúti óvoheixoku, vo'oku píkea tutíhiko jûdeu. Yane apé koene Jesus xapákuke. —Aúhepeponoe iséneu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yuhoíkoane, ina exókoa ne vô'u koáne ne xêrere. Yupihovó koépone elókepea okóvo ne íhikauhiko noixópane ne Vúnae. ");
INSERT INTO terNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ina kixovókoxopamaka Jesus: —Aúhepeponoe iséneu. Kuteâti kixónuku Nzá'a pahúkeonu yara kúveu mêum, énomonemaka ngixópineye —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Uke'éxoane koyúhoyea nê'e, ina api'ókexoahiko koane kíxovokoxopeamaka: —Nemúkanoe ra Sasá'iti Omíxone Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Enepone xâne yéxokoake itúyopea pahúnevo koeku kutípeonu, koati ituyôpotinemo pahúnevo. Kene ne xâne yéxokoake ákoyea itúyapa pahúnevo vo'oku ákoyea akútiponu, koati ákotimo veyapápu pahúnevo nê'e —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yoko póhuti yane nduse koeti íhikau Jesus, enepone Túme íhauti Hapáparu, áko'o yaneko apé koepóne Jesus xapákukehiko. ");
INSERT INTO terNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ina kíxo Túme ne po'ínuhiko íhikau Jesus: —Noíxopane ûti ne Vúnae! Yane hara koe Túme: —Enepomo hákoti noinjêa ne ike perêku vo'ókuke, koane hákotimo mbirukôa, koane hákotimakamo imbiho vô'um xêrerekuke, ákomo kalíhuina ngutípea —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Poéhapoane lûmingu ikénepoke, ho'uxoké koyépotihikomaka ne íhikau Jesus, koánemaka ne Túme xapákuke, exexo'ikené koyêtihiko. Yane apé koéponemaka Jesus xapákuke. —Aúhepeponenoe iséneu —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yane tumuné koéne kixo Túme: —Piríka ra vô'um maka neíxane koêku, koane ípiheamaka ra veô'u njêrereke. Hákone itikovo xâne ákoti akutípo, itea itíkapu kutípoti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ina kixôa Túme: —Iti Únaem, îti ne koati kaná'uti Itukó'oviti —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ina kixopâmaka Jesus: —Koati kitipónuti vo'oku neíxinu, itea enepone xâne kutipónuti ákoti naixánu, koati únatimo koêku nê'e —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Koati kaná'uti enó'iyea po'ínuhiko iyupánevoti ítuke Jesus, noíxone íhikauhiko ákoti yutaxápu yara koyuhópetike. ");
INSERT INTO terNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Itea kutí'inoke yutoxóvoti râ'a, koati kaha'aînopiti kitípinoe Jesus itúkeovaxo ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne, enepone koati kaná'uti Xe'exa Itukó'oviti. Epó'oxo vo'oku kitípi, ike'íparaxokonotimo inámapoti apéyeati ákotinemo hunókoku xoko Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ikénepoke neko koekúti, kaútata'ixopinovamaka Jesus neko íhikauhiko xe'ókuke ne mar, enepone koéhati Tibêriyade. Hara kôe kixoku koêku. ");
INSERT INTO terNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kaha'iné kíxoixokoko ne Simaum Pêturu; Túme, enepone íhauti Hapáparu; Natanâe ukeâti Kána, pitivóko ya Ngalíleya; koánemaka neko xé'ahiko Nzebêdeu; yoko po'i pi'âti íhikau Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ina kíxo ha'ínehiko ne Simaum Pêturu: —Numínguxotiko. Ina kixohíko Simaum Pêturu ne ha'ínehiko: —Pihotímaka ûti ikínike —koénehiko. Úkeane pihohíko. Ivu'í kixone kali hána'iti vatékena numíkuxoponoti, itea ako ápahuina êho yaneko yóti. ");
INSERT INTO terNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yuponíne, ápene Jesus xe'ókuke neko úne, itea ako éxapana íhikauhiko. ");
INSERT INTO terNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ina kixovókoxoa Jesus: —Ápenoe yêho? —Áko'o —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ina kixovókoxopamaka Jesus: —Kiríka éxopeke vetékena ne nímikuxope. Apêtimo yehóya —kíxovokoxoane. Yane itúkeanehiko ne yuhó'inoa. Yane ákone íta mikúkopea ne númikuxope vo'oku yupíheovo êno hoéya. ");
INSERT INTO terNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ina kíxo Simaum Pêturu ne po'inu íhikau Jesus, enepone ákoti omotóva okóvo Jesus: —Vúnae nê'e! —kíxoane. Kamoáne Simaum Pêturu itúkeovo Vúnae, itúkopone ípovo. Koáhati veyoâti koeku númikuxea, yane kurino'é koene úne araúkotine. ");
INSERT INTO terNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Itea ivu'í kixopo vatékena ne po'ínuhiko íhikau koáne mikúkopea ne númikuxope puhí koeti hôe, koáhati ákoti ahikâ ne poké'e xe'ókuke neko úne, kuteâtimea póhuti séndu méturu kíxoaku. ");
INSERT INTO terNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Evesékopeanehiko vatékena xe'ókuke neko úne, noíxonehiko uhahá'ixoti xorómonikeya koane hôe oúkeke. Yoko ápemaka pâum. ");
INSERT INTO terNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ina kôe ne Jesus: —Yamínanane kalihú koêti ne hôe némoenoemeku —koéne. ");
INSERT INTO terNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Yane ûrukopova Simaum Pêturu ne vatéke ina mikukópa movó'itike ne númikuxope puhi-puhí koati hána'itinoe hôe. Ápe póhuti séndu sinkoentai terei koeti hôe ovâti ne númikuxope, itea kóyeane ákoyea ekétakexa upánini ákoyea yumáxapu. ");
INSERT INTO terNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ina kixovókoxoa Jesus: —Yókone, niké'evonoe —kíxovokoxoane. Yoko ako ápahuina xapákuke neko íhikauhiko mapikóvati épemo'ikea itukóvotiye, vo'oku éxeanehiko itúkeovo Vúnae. ");
INSERT INTO terNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yane veyóponoa Jesus ne pâum ina porekéxoahiko. Kúteanemaka kíxoaku ne hôe. ");
INSERT INTO terNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yoko mopó'apene kaútata'ixopinova Jesus ne íhikauhiko ike exépukopine ukópea xapa ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Uke'éxonehiko níkea, ina kixôa Jesus ne Simaum Pêturu: —Simaúm, xe'a Xuâum, itíne yupihóvo ákoyea omótovonu okóvo yara po'ínuhiko? Ina yumopâ Pêturu: —Êm Unaém, yéxoa ákoyea omótovopi ongóvo. Ina kixopâmaka Jesus: —Yokóyonoakopo ne ngátarae, enepone kutí ngíxone inámatiko su'ûso konókoti katarákoati —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yane káyukoa Jesus yuhó'inoa, yoko pí'apene. Hara kíxoa: —Simaúm, xe'a Xuâum, ako omótovonu yokóvo? Ina yumopâ Pêturu: —Êm Unaém, yéxoa ákoyea omótovopi ongóvo —kíxoane. —Kétarakaikopo ne ngátarae, enepohikone hokónuti, enepone kutí ngíxone su'ûso konókoti inuxínoati —kíxoane Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ina kixopâ'ikomaka Jesus: —Simaúm, xe'a Xuâum, ako omótovonu yokóvo? —kixópanemaka, yoko mopó'apene épemo'ikoa. Yane isone'ekovó koéne ne Pêturu vo'oku mopó'ayeane épemo'ikoa Jesus ákoyea omótova okóvo. Ina yumopâ Pêturu: —Unaém, yéxoa uhá koeti koekúti. Yéxoa ákoyea omótovopi ongóvo. Ina kixopâmaka Jesus: —Yokóyonoakopo ne ngátarae, enepohikone hokónuti. ");
INSERT INTO terNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Koati emo'úti ra yunzó'inopi, ivévaka: Itikóvoiko homoêhou, itíne exópo koêku. Keunákovo nóvo, itíkone heô'e, yane pihetíne ya koêkuti yâha yéni. Itea yikatíxane, yeherúkotimo veô'u, itea po'imo xâne itukínopi ikéno'e iyonópiti xokóyoke ne ákoti yakahá'a —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yoko kó'inokeneye yûho ne Jesus, exókoti Pêturu kixókumo ivókeovo, kutí'inokemo kahaná'ikokonoti Itukó'oviti. Ikénepoke neko yûho, “Hekánu” kixóponemaka Pêturu ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ina na'akénexovo ne Pêturu, yane noíxone po'i íhikau Jesus hokoâti, ákoti omotóva okóvo Jesus. Énomonemaka neko isú'okovoti xa'a Jesus nikohíko, yaneko epemó'ikoamaka itukóvotiye neko itûkoheovoti, enepone kuríkotimo Jesus xoko xanéhiko puvâti. ");
INSERT INTO terNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Noixoâne Pêturu nekôyo, hara kixo Jesus: —Kene râ'a, namo kó'eye? ");
INSERT INTO terNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ina yumopâ Jesus: —Enepo angahá'a ákoyeamo ivákapu râ'a tukú koeti ngáyukopovope, undíne exôa koêku. Kene îti, hara yíxapu hékinu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hukinóvoti itáhineheyeane neko yuhôti xapákuke neko kutípotihiko Jesus ákoyeamo ivákapu neko íhikau. Itea ako okóyuhoa Jesus ákoyeamo ivákapu. Pohu “Angahá'a ákoyeamo ivákapu râ'a tukú koeti ngáyukopovope, undíne exôa koêku” pohu koêti. ");
INSERT INTO terNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yoko koati undíne ra íhikau Jesus noixoâti, koyuhoâti, koane yutoxoâti uhá koêti ra koekútihiko. Epó'oxo véxoa itúkeovo kaná'uti emo'úti râ'a. ");
INSERT INTO terNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Enó'iko po'ínuhiko koekúti ítuke Jesus. Eneponi uha-uhá akôe yutóxeovo pohú pohu koêti, kutí'inonu ákoni omótova êno koyuhópeti ya uhá koêti ra kúveu mêum. Hunókokune.");
INSERT INTO terNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Xoko inúxoti koyuhópeti yúndoenopi Teofilú, uhá ngíxoane ngayúmakinopea koêku ne turi ítuke Jesus, koánemaka ne ihíkauvoti íhikaxoke xanéhiko ");
INSERT INTO terNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tukú koêti yaneko káxe aukópovone ne Jesus ya vanúkeke. Yoko tumúneke pihópea, koyúhoinoane ya xunákoke Sasá'iti Omíxone Itukó'oviti ítukexeakemo ne hóyenohiko noívokoe, enepohikone ápostulu, páhoe koyúhoyea emó'u. ");
INSERT INTO terNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Énomonehikomaka koútata'ixopinovo exepúkopone ukópea xapa ivokóvoti ikénepoke koítoponeovo kotíveti ya kuruhúke. Ako tôpi kíxoaku koútata'ixopinova, exókoati kaná'uko ne exépukopeane, ákoinoke ápahuina xâne motovâti koyúhoyea ákoyea akána'u. Vo'oku kúveu koarenta koeti káxe, koútata'ixopinova Jesus neko íhikauhiko, koane koyúhoinoa koêku ne kixoku natíxea Itukó'oviti xapa xâne. ");
INSERT INTO terNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yaneko kaha'íneakohiko Jesus ne íhikau, ixíko'okoahiko ákoyea ipúhikeahiko Njeruzálem koane kúxoixea ne páhoenoamo Ha'a ûti íhae vanúke, kuteâti yuho Itukó'oviti, enepone koati emo'úti nóvo ápeyeamo. ");
INSERT INTO terNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ina kixovókoxopamaka Jesus: Énomonemaka kuteâti yunzó'inopinoe yanekôyoke. Vo'oku koati kaná'uti itúkeovo úne áhikea xâne ne Xuâum, itea harakene káxe epó'oxo yé'exovone, yahíkokonotinoemo haînati ya úne, itea ya xunákoke Sasá'iti Omíxone Itukó'oviti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Koeku ho'úxeovohiko neko íhikau, hara kixóhiko Jesus: —Unaém, énomonemeamo yara koeku kó'oyene peréximo itúkeovo ûti, uti íhae Izarâe, pahukópo yara poké'exa ûti? —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ina yumopâ Jesus: —Ako okónokoa yéxinoe ápeyeakumo ne koekúti kuteâti, koane kaxénaxeakemo Yá'a íhae vanúke, vo'oku poéhane exôa koéku ápepemo. ");
INSERT INTO terNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Itea nemukoâtimo xunakóti enepo evesékane xikóyokenoe ne Sasá'iti Omíxone Itukó'oviti. Yane keyuhoâtinoemo xapa xâne kaná'uko ra koekúti neíxonenoe njokóyoke. Keyuhoâtinoemo yâye ya Njeruzálem, koáne ya uhá koeti Njúdeya yoko Samâriya, koánemaka ya uhá koêti ra kúveu mêum —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Uke'éxoane Jesus koyúhoyea nê'e, yane pihópone vanúkeke koeku ixómoyea komóma íhikauhiko. Yane koomomo kíxoixoahiko tukú koeti onómekopeovo xapa kapási. Ehane ako ínixahiko. ");
INSERT INTO terNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Koeku pono-ponó kíxoixea ûke ne íhikauhiko vanúke koeku pihópea Jesus, apé koene pi'âti kutí koeti hóyeno, hóhopu koyêtihiko ípovo xêrerekuke neko íhikauhiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hara kíxovokoxoa: —Itínoe hóyeno íhae Ngalíleya, na koeti ixómoino kemomo vanúke? Enepone Jesus, neíke'euponoe kó'oyene pihópea vanúkeke, aukópovotimo kuteâti kíxeaku neíke'exopi —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Énomone yanê'e, aúhikopovone ya Njeruzálem ne íhikau Jesus ukopeâti xoko kali mopôi iháxoneti Olívera. Enepone mopôi, ako ahika Njeruzálem, kuteâti póhuti kílomituru kíxoaku. ");
INSERT INTO terNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Seopóne pitivókoke, ina alu'ókopo sôparatuke yane ovokúti óvoku. Harâ'a iháhiko neko ho'uxóvoti: Pêturu; Xuâum; Teâku; Ándere; Filípi; Túme; Mbatulúmeu; Máteu; Teâku, enepone xé'a Áfeu; Símaum iháxoneti Nzelóti; yoko Njûda, enepone xé'a Teâku. ");
INSERT INTO terNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yoko póhutine yónoku isóneuhiko yuíxeovo itúkea orásaum ho'uxoké koêti, koánemaka ne senóhikoya. Yoko ápe Mâriya, eno Jesus xapákuke neko senóhiko, koane ápemaka ne ameno Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yaneko káxehiko exépuko ne Pêturu koyúhoyea nonékuke ne po'ínuhiko kutípoti Jesus. Yoko itópono kuteâti séntui vínti koeti xâne neko ho'uxóvotihiko. Ina kixovókoxoa Pêturu: ");
INSERT INTO terNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Itínoe mbo'ínu xoko Vúnae, koati konokoâti tokópeovo ne yutoéti emó'uke Itukó'oviti koeku Njûda, enepone inuxínoti ika'ákotihiko Jesus. Énomone neko yuho Ndávi mekúke, koúhapu'ikinoake Sasá'iti Omíxone Itukó'oviti tumúneke símeovo kaxéna. ");
INSERT INTO terNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Vo'oku enepone Njûda, koati ha'ine ûti ikéneke Jesus yanekôyoke. Itúkoamaka kuteâti ne vítuke —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yoko ápe poké'e vaneúti yane tiûketi námoe Njûda, ésa'i kuríkea Jesus xoko xanéhiko puvâti. Énomone óvo koépekopeovo ne Njûda kopuhókopovo. Pixeké koe hûra ikorókovo. Homuxó koe ásurupi poké'eke. ");
INSERT INTO terNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Eyékoxoahiko uhá koeti ko'óvokuti ya Njeruzálem neko koekúti. Énomone kutí'inoke iháxokonoti Asêudama neko poké'e ya emó'ukehiko. Yoko “Poké'e óvokovoku íti” koêti neko emo'úti.) ");
INSERT INTO terNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ina koe'íkomaka ne Pêturu: —Koati kuteâti ne yutoéti ya emó'uke Itukó'oviti ya Sâramu, enepone koêti: “Itúkapu ovokú'ikeneti neko óvoku, epó'oxo hákonemo ko'óvokutiya” kôe. Ina koemáka: “Enepone itukéti ítuke, paréxakana po'i xâne ahe'ókopati” koêti. ");
INSERT INTO terNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","—Konókoti ápeyea po'i ha'ine ûti ahe'ókopati. Yusikóne noívokoxea ûti xapákuke ra xanéheixoviti apé'iko Vúnae Jesus xapákuke ûti, ");
INSERT INTO terNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ukeátine yaneko kaxena áhikea Xuaum Mbátita, tukú koêti neko káxe noíke'exopeaku ûti pihópea vanúkeke. Énomonemo kaha'ínevi koyúhoyea ûti xapa xâne exépukopea ne Jesus ukópea xapa ivokóvoti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ina noivókoxokono pi'âti hóyeno. Enepone inúxoti, Yûse koéha. Mbarasâpa íhaxeokonomaka. Yoko Njústu itukóvo po'i íhaxeokonokemaka. Ina keno'óko koéhati Mátiya. ");
INSERT INTO terNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yane itúkohiko orásaum uhá koêti neko kutípoti Jesus. Hara koe épemone xoko Itukó'oviti: —Unaém, iti éxoti isóneu uhá koeti xâne, yéxakavea ne neívokoe yara pi'âti hóyeno, ");
INSERT INTO terNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","motovâtimo áhe'okopea Njûda koane kahá'ineyeovi yara itukéti pénevi vitúkea, uti péhoe koyúhoyea yemó'u. Vo'oku kuríkopane Njûda ra itukéti. Kó'oyene pihópone xoko ímetokenaxoake yonópea —koe orásauna. ");
INSERT INTO terNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ina kurikóhiko, noixoâti iríkovoku ne noívokoxope. Xoko Mátiya iríkovo. Yane itúkopovone ha'ínehiko ne unze koeti ápostulu. ");
INSERT INTO terNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Simoné'e ne kaxena áyui jûdeuhiko ya hó'eke, enepone iháxoneti Pentekósti, poéhane ho'úxovokuhiko uhá koêti neko hokoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yane apé koéne kutí koeti emo'u xúnati ihunóvoti ukeâti vanúke. Uha-uhá kíxoa kúveu neko ovokúti óvoheixoku. ");
INSERT INTO terNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Yane apé koénemaka kutí koeti kálihunoe irúmene yúku kuteâti koeku nenêti, yoneâti tutíkuke póhutihiko koxé'u neko xâne. Koati ovo'ó koatíne. ");
INSERT INTO terNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yane koâti xúnati ne Sasá'iti Omíxone Itukó'oviti xoko póhutihiko neko xâne, koane turíxeovone koyúhoyeahiko inámati yuhôti ákoti itukapu éxone, kuteâti kíxoaku Sasá'iti Omíxone Itukó'oviti ikó'iparaxea póhutihiko koyúhoyea. ");
INSERT INTO terNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yoko ápe ya Njeruzálem jûdeuhiko teyoti Itukó'oviti ukeâti uhá koeti po'íkehiko poké'e yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ho'úxinova êno xâne neko emo'úti kamoánehiko, itea akó'oti exínahiko isóneu, vo'oku kamotíhiko koyúhoti ya emó'uke póhutihiko neko xâne. ");
INSERT INTO terNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yupíhova ákoyea éxina isóneu xanéhiko koane iyúpaxeova neko koekúti, ina kixokóko: —Hainá'ikopo ainóvoti íhae Ngalíleya ra koyuhókexo? ");
INSERT INTO terNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ná'ikopo koeti kamínoa ûti koyúhoyea ya vemó'uke, enepone yuho póhutihiko ûti xoko vúkeaku? ");
INSERT INTO terNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Koati anéyeti íhae Pátea, yoko Mêdea, koane íhaemaka Élaum, yoko Mezopotámiya koane Njúdeya. Ina apémaka ukeâti Kapadósea, Póntu, yoko Âzea, ");
INSERT INTO terNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ápemaka íhae Firîjea, Páfilea, Ejítu, Lîpea yoko poké'e oveâti xe'ókuke ne Sîreni, yoko íhaemaka Róma. Aínovone ko'óvokuti yâye. ");
INSERT INTO terNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Vanéye, uti jûdeu, koane anéyemaka po'ínuhiko xâne ikútipasikovoviti hokopâti ne hó'e ûti. Anéyemaka íhae Keréta yoko íhae Ârabea. Ná'ikopo kixóvotiye kamínoake póhutihiko ûti ya vemó'uke koyuhoâti koêku ne hána'itinoe ítuke Itukó'oviti? —kixókokone. ");
INSERT INTO terNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Koati yupihóvati iyúpaxeovahiko. Akó'oti exína isóneu kó'inokeneye. Hara kixókokohiko: —Kutimea kixó'eko râ'a? —koéhiko. ");
INSERT INTO terNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Itea ápemaka po'ínuhiko xâne koemóke'eati, koyuhoâti itúkeovo kohihíketi, kó'inokeneye neko yûho. ");
INSERT INTO terNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ina exepúko ne Pêturu yóko'omaka ne unzé koeti ápostulu. Ina kohonóko emó'u koyúhoyea ne Pêturu. Hara kôe: —Itínoe iyénonjapa jûdeu, keánemaka uhá ketínoe íhae Njeruzálem, konókoti yéxi koeku râ'a. Ivévaka ra yûnzo: ");
INSERT INTO terNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Haina kohihíketi ûti kuteâti iséneunovinoe, vo'oku nóveiko ôra ya yupóniti rakéne. ");
INSERT INTO terNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Itea enepora koekúti, énomone ne kíxone yuho porofeta Njôe koyûho emo'u Itukó'oviti xapa xâne mekúke, enepone koêti: ");
INSERT INTO terNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Yaneko káxehiko tumúnekemo uké'eyea ra mêum, mbahúkotimo Sasá'iti Omínjone ovo'ó kó'iyea ne uhá koeti xâne” koe Itukó'oviti. Ina koe'íkomaka: “Koyuhoâtimo xi'íxaxapa, hóyeno yoko sêno, koekúti ngoúhapu'ikinoake. Enepone inámatiko xâne xepákukenoe, apêtimo noíxone ukeâti njokóyoke. Kene ne yékotenohiko, yunzoíkoatimo ya hopúneke. ");
INSERT INTO terNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Koánemaka xapákuke ovónje, hóyeno yoko sêno, mbahúkotimo Sasá'iti Omínjone ovo'ó kó'iyea yaneko káxehiko, ínamo okoyúhohiko emó'um. ");
INSERT INTO terNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Apêtimakamo iyupánevoti índuke ya vanúke koánemaka yara poké'e, hoénaxovope njunáko, íti, irúmene yúku yoko ênoti kuríhoe. ");
INSERT INTO terNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ipukóvotimo ne káxe. Kene ne kohê, kutí koetimo harâra'iyea íti koati tumúneke símeovo neko hána'iti teyonéti káxe yúhoikopeakumo Itukó'oviti ra xanéhiko yara kúveu mêum vo'oku kixoku itúkeovo. ");
INSERT INTO terNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Itea itóvotimo ne uhá koeti xâne ikoseânaxovoti Itukó'oviti” koe yútoe. ");
INSERT INTO terNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","—Itínoe hóyeno íhae Izarâe, yakámokenonu. Enepone Jesus íhae Nazâre, koati hóyeno éxokopikenoe Itukó'oviti itúkeovo ukeâti ya xokóyoke vo'ókuke ne iyupánevoti ítuke, koane vo'ókumaka ne koekúti ákoti po'i itoâti itúkea xepákukenoe, hoénaxovope xunako Itukó'oviti xokóyoke. Koati Itukó'oviti ko'itúke xokóyoke, itúkinoake Jesus neko hána'iti iyupánevoti xepákuke. Yoko koati yexoâtinoe kaná'uyea ra koekúti. ");
INSERT INTO terNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Itea kóyeane képekinoe nekôyo. Koati xâne ákoti panâpu ítuke kuruhúxinopeanoe. Itea yaneko kiri'ókokonoanoe, koati kousókovoti isóneunoa Itukó'oviti ukeátinekeneye, enepone heú kixoâti éxea ne koekúti tumúneke ápeyea. ");
INSERT INTO terNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Enepone képeunoe, koéxepukopa Itukó'oviti yaneko uke'éxinoa xunako pevóti. Koáhati akó'oti omotóva óvoheixea pevótike ne Jesus, ");
INSERT INTO terNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","kuteâtimaka koêku ya yútoeke Ndávi enepo koyuhó'iyea koêku mekúke. Énomone ne koêti: “Kóyekune ne Únaem njokóyoke. Anéye njêrerekuke koxunákonuti, ákoinoke íngarakapu. ");
INSERT INTO terNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Énomone elókeino ongóvo. Énomonemaka ipúhikino mbahákuke ne hána'iti elókeko ongóvo. Koane énomonemaka ngúxoixino enjépukopeamo ungópea xapa ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Vo'oku ákomo kurí íxenu xapa ivokóvoti, iti Únaem, koane ákomo síkea uké'eyea ra mûyom xoko engóxovoku, undi Sasá'iti Yovóxe. ");
INSERT INTO terNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Hara yévekonu xêne yonópoti xoko apéyeati ákotinemo hunókoku xikóyoke. Koati ákotinemo hunókoku ne elókeko ongóvo enepo angahá'inepopine” kôe yútoeke Ndávi. ");
INSERT INTO terNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ina kixoá'ikomaka Pêturu: —Itínoe iyénonjapa, ngaúhapu'ikinapeavo koêku ne Ndávi, eneponeko teyonéti voxú'ikene ivokóvoti koane ekoxóvoti mekúke. Yoko anéyeiko ne ekóxovoku tukú koeti kó'oyene yara poké'exa ûti. ");
INSERT INTO terNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Koati porófeta ne Ndávi koyúhoti koekúti noíxone xoko Itukó'oviti âvoti simâpu kaxéna. Epó'oxo éxoamaka yanekôyoke ápeyeamo póhuti ámoripono natíxotimo xapa xanena ûti, kuteâti koeku yuhó'inoa Itukó'oviti kó'iyeanemoye. Yoko itúkinoa Itukó'oviti koati yuhôti, exókoati ákoyeamo aúkapa ikéne neko emó'uinoa. ");
INSERT INTO terNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Koati vo'oku ínixea Ndávi koekúti yanekôyoke âvoti simâpu kaxéna, énomone koyúhoinoa ya yútoeke exépukopeamo ne Mésiya ukópea xapa ivokóvoti enepo koyûho ákoyeamo kurí íxa Itukó'oviti ne ovóxe ya xapa ivokóvoti, koane ákoyeamo aúke'e ne mûyo. ");
INSERT INTO terNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yoko enepora Jesus, énomone ne koéxepoepo Itukó'oviti. Noínjopa, koane noíxopamaka uhá koeti nza'ínehiko. ");
INSERT INTO terNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kó'oyene hanekóxopone éxopeke Itukó'oviti xoko ivátakoku kapáyasokopone Itukó'oviti. Yoko koúsokinokonoane Jesus neko yuho Há'a yanekôyoke, enepo itûko koati emo'úti pahúkinoveamo ne Sasá'iti Omíxone. Énomone ra neíxonenoe, koane kémonenoe kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Énomone kíxo yútoe Ndávi. Vo'oku haina Ndávi okopóno vanúkeke yanekôyoke, itea énomone yutoxínovea ra emo'úti koêti: “Hara kíxoa Itukó'oviti ne Únaem: ‘Ivétakapa énjopeke ");
INSERT INTO terNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tukú koeti simapúne kaxena mboréxeopikumo itíkivo koati payásoti nâti ya uhá koêti, ínamo ipuyúkexa nenékuke ne uhá koeti koêkuti okopópiti’ ” kôe. ");
INSERT INTO terNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ngahá'a ú'uhapu'i ngixínopeanoe, uhá ketínoe íhae Izarâe, motovâti ákoyea oxéne ákoyea yakútipoa ne yunzó'inopi itúkeovo Jesus, enepone képeu, poréxovike Itukó'oviti itúkeovo Vúnae koane Mésiya, enepone páhoe koíteovovi —kíxovokoxoane Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Koeku kámea yuho Pêturu neko xanéhiko, yupíhova ikótivexea isóneuke. Ina kixohíko Pêturu yoko po'ínuhiko ápostulu: —Itínoe viyénoxapa, na vákoeneye? ");
INSERT INTO terNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ina yumopâ Pêturu: —Konokoâti ikétivexinoe iséneuke ne pehúnevo koane kiríkopi. Konókotimaka yáhikivo ya iháke Jesus Kristu, motovâti kotúyopinopea ne pehúnevo, péhutinoe. Yane ínamo nemukâ ne Sasá'iti Omíxone Itukó'oviti ovo'ó kó'iyeopinoe. ");
INSERT INTO terNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Koáhati itínoe kíxo ne Itukó'oviti koyuhôa yanekôyo ápeyeamo koúsokinoake ne yûho. Koane koati xi'íxaxapa kixómaka, koánemaka uhá koeti po'ínuhiko ákoti maliká'avi, koêkuti iháxiupomo Vúnae Itukó'oviti xapákuke —kíxovokoxoane Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Enómaka po'i yûho kuteâti, koyuhó'inoati emo'u Itukó'oviti, koane enekoâtihiko. Ina kixovókoxopamaka: —Hako kitipásea ne xanéhiko apêti koeku kó'oyene, enepohikone váhere kixoku itúkeovo yonópotimo ipihóponovokutike —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Enepohikone xâne kutipeâti yûho, áhikovohiko ya iháke Jesus. Yaneko káxe koati kuri'úxovoti ne xâne kutípoti Jesus. Kalíhanini itóponea mopo'âti mili xâne neko inámati ahiúti yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Enepohikone kutípoti Jesus, koati yuixóvati ne ihíkauvoti íhikaxoake ápostuluhiko, koane aínovo póhutine yónoku isóneuhiko ikéneke Vúnae ákoti ihaxákexeakaka. Kóyekunemaka ho'úxinovohiko níkea pâum, puyákoponeovoke okovo ivókinovovi Jesus, koane itúkeamaka orásaum. ");
INSERT INTO terNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Koati hána'iti téyea Itukó'oviti póhutihiko neko xâne. Enómaka iyupánevoti ítuke ápostuluhiko, koane po'ínuhiko ítone itúkea kuteâti, hoénaxovope xunako Itukó'oviti xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kaha'iné kixókokohiko neko kutípoti Jesus. Ákomaka kamáxatikaka. Póhutihiko, kutí kíxoa ítukemaka po'ínuhiko neko apeínoati. ");
INSERT INTO terNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kaváneahikomaka ne poké'exa yoko po'i apeínoati, ina porekéxoa ésa'i ne apêti nókone xapákuke. ");
INSERT INTO terNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Uhá koeti káxe, kutikokó koe yónoku isóneu ikéneke Vúnae koeku ho'úxeovo témpuluke, enepone hána'iti imokóvokuti. Kene ya óvokukehiko, ho'úxinovo níkea pâum, puyákoponeovoke okovo ivókinovovi Vúnae. Koane enepo nikohíko, koati elóketi okóvo, koane póhutine yu'óxoku isóneuhiko ítukeke Vúnae ");
INSERT INTO terNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","xaneâti iháyu'ikeamaka Itukó'oviti. Ínixoa uhá koeti xâne unako koêku neko kutípoti Jesus. Yoko uhá koeti káxe, kurí'uxinoa Vúnae po'ínuhiko xâne, enepohikone koítovone ya pahúnevo koeku kutípea. ");
INSERT INTO terNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yane pihóne ne Pêturu yoko Xuâum hána'itike imokóvokuti ya mopo'âti ôra ya kiyakáxe, orana itúkopehiko orásaum ne jûdeuhiko. ");
INSERT INTO terNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yoko ápe hóyeno omeátinekene itúkeovo mohéveu. Heú koeti káxe ómeokono neko hóyeno xêrerekuke pahapéti iháxoneti “Uhé'ekoti”, enepone páhapetea kíndana ne hána'iti imokóvokuti, motovâti épemea tiûketi xanéhiko urúkovotiya. ");
INSERT INTO terNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Noixoâne hóyeno ûrukeovomo ne Pêturu yoko Xuâum, épemoane tiûketi. ");
INSERT INTO terNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yane pono-ponó kixínoane ûke Pêturu yoko Xuâum, ina kixôa Pêturu: —Yokómomovi. ");
INSERT INTO terNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ina komomâ hóyeno. Koati kuxoâti ápeyea póneake evo Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ina kixôa Pêturu: —Ako ndiûketina, itea enepone apêti njokóyoke, énomone mboréxopi: Ya iháke Jesus Kristu íhae Nazâre, yexépukapa yenápa —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ina namukêa vô'u éxopeke neko hóyeno huvo'óxoa exépukopea. Énomone yaneko ókoku ôra, xunápone anu hêve, koane hêve. ");
INSERT INTO terNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Xépu koépone ne hóyeno, yane turíxovone yonópea. Xané kixone evo Pêturu ûrukeova ne hána'iti imokóvokuti. Koati talakíxovoti koane iháyu'ikea Itukó'oviti neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Noíxoa uhá koeti xanéhiko koeku yonópea koane iháyu'ikea Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Exó kixóponoanehiko itúkeova neko épemokenati ivatáheixoti xoko pahapéti iháxoneti “Uhé'ekoti” nonékuke ne hána'iti imokóvokuti. Koati hána'iti iyúpaxeovahiko, koane ako éxinahiko isóneu kó'inokeneye. ");
INSERT INTO terNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ako kurika Pêturu yoko Xuâum neko hóyeno. Noixoâne xanéhiko neko koekúti, uhá kôe éhahikinovo evo Pêturu xoko óvoheixoku yane varánda iháxoneti varándana Salúmaum. Koati ákoti exínahiko isóneu neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Noixoâne Pêturu ne êno xâne keno'ókinoatihiko, ina kôe: —Itínoe iyénonjapa íhae Izarâe, na koeti iyípaxinova ra koekúti? Na koeti ínainonoe kemómovi kutí'iyea koati xunako ûti, áko'o sasá'iko ûti veínokono yonópinoke ra hóyeno? ");
INSERT INTO terNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Koati Itukó'oviti, enepone Unae voxúnoekene Âbraum, Izáki yoko Njáko, kahaná'iko Jesus, enepone sasá'iti ovóxe, kirí'oenoemaka payásotihiko pahúkoti, yaneko keyuhôa nonékuke Pilátu ákoyea yakáha'a itúkeovo netínanoe. Yoko mani úsotine isóneu Pilátu kuríkopea. ");
INSERT INTO terNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Itea itínenoe ako akahá'a neko Sasá'iti koane Ponóvoti páhoenovi Itukó'oviti. Ya koêkuni itúkeovo énomone yépemo kuríkopeokono, itukovó koe koépekenati yépemonoe. ");
INSERT INTO terNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Itínenoe koepékoa ne Porexó'oviti vápeyea. Itea koéxepukopa Itukó'oviti ukópea xapa ivokóvoti. Yoko noíxopa ûti yaneko exepúkopone, epó'oxo koati koyuhoâti ûti xapa xâne kaná'uko ne noíxone ûti. ");
INSERT INTO terNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Koati vo'oku iha Jesus, epó'oxo vo'oku kúveova hóyeno, ene kutí'ino unatípoti râ'a, kuteâti koeku neíxi kó'oyene koane yéxi. Ngoé'epepo, koati vo'oku kúveovo Jesus unátipinoke nenékuke, uhá ketínoe. ");
INSERT INTO terNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","—Itínoe mbo'ínuhiko, énjoa kíxineye Jesus vo'oku ákoyea koati yéxi koêku ne ítike. Kúteanemaka koêku ne natina ûti. ");
INSERT INTO terNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Itea kó'inokeneye, koati kousókoati Itukó'oviti ne yûho, enepone ipuhíkeati pahákuke uhá koeti porófetahiko koyúhoti emo'u Itukó'oviti xapa xâne mekúke. Koyúhoa nekôyohiko kónokea koítoponeovo kotíveti ne Mésiya, enepone páhoe Itukó'oviti koíteovo xâne. ");
INSERT INTO terNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Énomone ngixínopinoe kónokea ínixepivo itíkivo pahukóvoti koane ípeki iséneu koane kixeku itíkivo motovâti sasá'ipea pehúnevo ");
INSERT INTO terNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ínamo parexápi Vúnae Itukó'oviti úhepepea iséneu ikéneke, epó'oxo pahukínopeatinoemo ne Mésiya, enepone Jesus, noívokoenopinoe Itukó'oviti itúkeovo koitóvoviti, uti xâne. ");
INSERT INTO terNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Eneponê'e, koati konókoti pihópea vanúkeke imókonemo simâpu kaxena ikó'inamakopeovo uhá koeti koekúti, kuteâtimaka koêku neko yuho Itukó'oviti ya xokóyoke ne porófetahiko, enepone sasá'iti ovóxe koyuhó'iyeati emó'u xapa xâne mekúke. ");
INSERT INTO terNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yoko enepone Muîse, koati koyuhó'iyeati koêku mekúke ya yútoeke. Énomone ne koêti: “Xapákuke viyénoxapa, apêtimo po'i hóyeno kuteâti ûndi, noívokoemo Itukó'oviti itúkeovo porófeta koyuhó'iyeati emó'u xapa xâne. Uhá koeti kémone xokóyoke, konokoâtimo itíki. ");
INSERT INTO terNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kene uhá koêti xâne ákoti akutípoa, koepékokonotimo. Yane áko'onemo xapákuke xanena ûti” koe yûho. ");
INSERT INTO terNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Haina póhutine Muîse koyuhôa koêku ra káxehiko símokune ûti, itea koyúhoamaka uhá koeti po'ínuhiko porófeta ukeâti kaxénake Samûe. ");
INSERT INTO terNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Itínoe iyénonjapa, yaínovone namukópati kíxone neko yútoe porófetahiko. Enepone yuho Itukó'oviti xoko voxúnoekene, itínoemaka kíxo. Énomone neko yuhó'ino Âbraum enepo kixôa Itukó'oviti itúkeovomo vo'ókuke ne ámoriponomo ápeyeamo unako koêku ne uhá koeti koêkuti kó'iyeovoku xâne yara kúveu mêum. ");
INSERT INTO terNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yaneko koéxepukopeaku Itukó'oviti neko Sasá'iti Ovóxe, pahúkinopeanoe inúxotike, kaha'aînopiti unátiyea kêku ya koeku kiríkopinoe váhere kixeku itíkivo —kíxovokoxoane Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ixómoiko koyuhó'inoa evo Pêturu neko xanéhiko, simóne inuxínotihiko jûdeu hó'eke, koáne ne tuti húndaruhiko koyonoâti neko hána'iti imokóvokuti, yóko'omaka ne evo sadúseu, enepohikone jûdeu ákoti akutípo exépuhikopea ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yoko koati yupihóvatihiko ákoyea aúhepe isóneuno evo Pêturu vo'oku íhikaxea xanéhiko koêku ne exepúkopeati ukópea xapa ivokóvoti koeku koyúhoinoahiko exépukopea Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yane iká'akonehiko evo Pêturu koane kuríkoanehikomaka ika'ákovokutike tukú koêti yuponíne, vo'oku koati kiyotíne káxe yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Itea êno kutípoti yuho Pêturu xapákuke neko xâne kamokénoati. Kalíhanini itóponea singu koeti mili hóyeno uhá koêti neko kutipoâti. ");
INSERT INTO terNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yuponíne, ho'úxovone ya Njeruzálem ne payásotihiko jûdeu, yóko'o ne po'ínuhiko teyonéti xapákuke tuti jûdeu, koáne ne éskiriba, enepohikone ihíkaxoti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ápemaka Ána, enepone koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke, koane Kaífa, yoko Xuâum, Alíxandere, koane uhá koeti iyénoxapa neko koati payásoti sasedóti. ");
INSERT INTO terNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ina omokóno ne Pêturu yoko Xuâum nonékuke uhá koêti neko payásotihiko, motovâti épemo'ikeokono. Hara kixókono: —Na úkea xináko itíki ra ítike? áko'o kuti pahukópi itíki? ");
INSERT INTO terNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yoko koati xúnati ne Sasá'iti Omíxone Itukó'oviti xoko Pêturu. Hara kíxovokoxoa: —Itínoe payásoti xapákuke ûti, koane itínoe po'íhiko pahúkoti xapákuke ûti, ");
INSERT INTO terNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","koati vo'oku koíteovokono hóyeno ka'aríneti, kutí'inoke yomónutinoe yâye yuhoíkovokutike, yepemó'ikonuti, ûndi yóko'o ra nza'íne, keha'âti yéxi kixókonoku koíteovokono. ");
INSERT INTO terNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ngahá'a yéxi koêku, uhá ketínoe yâye, koánemaka uhá koêti ne íhae Izarâe, íteovone ra hóyeno nenékukenoe vo'oku xunako Jesus Kristu íhae Nazâre, eneponeko képeunoe, enepone koéxepoepomaka Itukó'oviti ukópea xapa ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Enepora Jesus, koati pivoâtinoe, kuteâti koeku mopôi noívokoxine itúkoti péti. Itea enepone pívonenoe, ainovó koe énomone itukóvoxo koati turíxeovoku uhá koeti, kuteâti koeku koati inúxoti mopôi turíxeokonoke péti. ");
INSERT INTO terNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Epó'oxo ako ápahuina motovâti koíteovovi ákoti itukapu Jesus. Vo'oku ako po'i ihâe pónevike Itukó'oviti xapákuke iha xâne ya uhá koeti kúveu mêum, porexó'oviti víteovo ya pahúnevo ûti, ákoti itukapu iha Jesus —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Noixoâne pahúkotihiko ákoyea píkone koyúhoyea ne Pêturu yoko Xuâum, koane ákoyea itúkapu xâne payásoti koane hainá'iyeamaka hóyeno ênoti íhikauvo, yupíhova iyúpaxeovahiko koane ivávakea itúkeovo ha'íneheixone Jesus yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Noixoâne tutíhiko jûdeu neko hóyeno itóvotine xêrerekuke evo Pêturu, ako vekínoaku emó'u okópea. ");
INSERT INTO terNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ina pahukópohiko evo Pêturu ipúhikopea yuhoíkovokuti, ina kixokókohiko: ");
INSERT INTO terNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—Na víxaye ra hóyenohiko? Vo'oku éxoane uhá koeti ko'óvokuti yara Njeruzálem koêku ne hána'iti iyupánevoti ítuke. Ako oxéne koyúhoyea ûti ákoyea akána'u. ");
INSERT INTO terNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Poéhaneikopo vípikea maka hákone yupihóvo itáhineyea ra koekúti xapákuke xanéhiko, koane maka hákone koyuhó'iyea koêku ne Jesus xapa xanéhiko —kixókokonehiko. ");
INSERT INTO terNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ina ihaxíkopohiko Pêturu yoko Xuâum koane kíxea: —Hákonenoe keyuhôa koane hákone ihíkexo koeku Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ina yumopâ Pêturu yoko Xuâum: —Itíkina iséneu póneovoku ra koekúti nonékuke Itukó'oviti itúkeovo itínoe kónoko kutípea ûti, áko'o itúkeovo Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Na kíxoaye ákoyea vokóyuhoa ne noíxone ûti koáne ne kámone ûti? Koati konokoâti koyúhoyea ûti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ápemaka po'i yuhó'ino evo Pêturu ne pahúkotihiko kahá'ati ípikea. Yane koyúhoinoamaka kíxoakuhikomo okoyúhopomaka koeku Jesus. Yane kuríkopanehiko. Akó'oti inixâhiko oxéne ipíhoponea vo'ókuke ne xanéhiko. Koáhati ainóvoti ihayú'ikoti Itukó'oviti vo'oku ítuke evo Pêturu koitóva neko hóyeno. ");
INSERT INTO terNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yoko anú'ukone koarenta koeti xoénaena ne hóyeno iyupaxó kó'inoke xanéhiko vo'oku kixókonoku koíteovokono. ");
INSERT INTO terNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kurikópokonone evo Pêturu yoko Xuâum, hane yonópo xapa po'ínuhiko kutípoti Jesus. Éto'okopahiko uhá koeti yuhó'inoa tutíhiko sasedóti inuxínoti xanéhiko hó'eke, yóko'omaka ne po'ínuhiko teyonéti xapákuke jûdeu. ");
INSERT INTO terNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kamoné'ehiko yuho evo Pêturu, kutikokó kôe isóneu uhá koetíhiko yúho'ixea Itukó'oviti ya orásaum. Hara koe yûho: —Iti Vúnae éxoti koeku uhá koeti koekúti, itíne pahukôa apé kó'iyea ne vanúke, koáne ra poké'e, koane uhá koeti ovâti. Itínemaka pahukôa ápeyea úne ya mar koane uhá koeti ovâti. ");
INSERT INTO terNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Itímaka itukôa yûho ipuhíkeati pahákuke ne yovóxe mekúke, enepone voxú'ikene Ndávi, yaneko ikoyúhoxoa Sasá'iti Yomíxone. Énomone ne koêti: “Na koeti ímaikexinovo ne xanéhiko ákoti êxa Itukó'oviti? Na koeti kenó'okino isóneuke kahá'ayea okópea ne ákoti itâ okópea? ");
INSERT INTO terNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ho'úxovonehiko ne nâti yara kúveu mêum koánemaka ne po'ínuhiko pahúkoti, ho'uxínovotihiko okópea Vúnae Itukó'oviti yoko Noívokoe, enepone Páhoe koíteovo xâne yara kúveu mêum” kôe. ");
INSERT INTO terNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","—Yoko koati kaná'uti kó'iyeaneye, vo'oku yara pítivokona ûti, ho'úxovonepepo xâne okópea Sasá'iti Yovóxe, Jesus, enepone Neívokoe koane Péhoe koíteovo xâne yara kúveu mêum. Énomone neko Êrodi yoko Ponsiu Pilátu xaneâti ne xanena ûti, uti íhae Izarâe, yóko'omaka ne po'ínuhiko xâne ákoti itukapu íhae Izarâe. ");
INSERT INTO terNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ho'úxinova ípihea tumúne ne isóneu, itea enepone uhá koeti ítuke, ainovó koeti koati kousókoati ne ovoti iséneuke ukeátinekene, iti Itukó'oviti. Koati koekúti kousókovoti ya xinákoke. ");
INSERT INTO terNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kó'oyene Unaém, yokómoma kixoku ípikeovihiko. Peréxavi vitúkeovo koati ákoti píkone koyúhoyea uti yemó'u, uti yovóxe. ");
INSERT INTO terNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iké'itukexa xináko keítivoa ne ka'aríneti, koáne ya iháke sasá'iti Yovóxe Jesus, itika iyupánevoti koane po'ínuhiko koekúti ákoti itoâti itúkea, hoénaxovope ne hána'iti xináko —koénehiko ya orásaum. ");
INSERT INTO terNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Uke'éxone itúkea orásaum, iyúyo neko ho'úxovoku. Koáhati xúnati ne Sasá'iti Omíxone Itukó'oviti xoko póhutihiko koxé'u. Koane ákohiko pîka koyúhoyea emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Uhá koêti neko êno xâne kutípoti Jesus, poéhane yónoku isóneu, koane kutikokó koe âha itóponea ikéneke Vúnae. Ako ápahuina kamá'ati ítukevo xapákuke, koane kutí kíxeahiko ítukenemaka po'ínuhiko. ");
INSERT INTO terNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Koati ênoti xunako Itukó'oviti xokóyoke ne ápostuluhiko koyúhoyea xapa xâne koêku exépukopea ne Vúnae Jesus ukópea xapa ivokóvoti. Koane koati hána'itimaka itipánevoti ukeâti xoko Itukó'oviti oúkeke póhutihiko koxé'u neko xâne. ");
INSERT INTO terNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ako ápahuina ikonóko'ikovoti xapákuke vo'oku enepohikone apêti poké'exa, itukovo po'i óvokuhiko, kavane ítukevo. ");
INSERT INTO terNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kene ne tiûketi ésa'i vâne, kuríkoponoa xoko ápostuluhiko. Ina porekéxoahiko ne ikonóko'ixovoti xapákuke. Yoko nókone póhutihiko koxé'u exôa námoe. ");
INSERT INTO terNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Xapákuke neko xâne, ápe hóyeno koéhati Yûse. Itúkinoa ápostuluhiko yonópoku îha. Mbaranâbe íhaxopeahiko. Yoko “kotiú'ikoti okovo po'ínuhiko” koêti neko yonópoku îha. Enepone hóyeno, hane itukóvo levíta íhae Xípere. ");
INSERT INTO terNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ápe poké'exa vâne, ina kurikóponoa ne tiûketi, ésa'i ne vâne, xoko ápostuluhiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ápe hóyeno koéhati Anániya kavánetimaka poké'exa. Sáfira koéha yêno, ha'íne yaneko kavaneâne ne poké'exa. ");
INSERT INTO terNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Itea véyoa Anániya poixo'o ésa'i neko poké'exa, itúkoti koúnae. Kutikokó koéhiko isóneu neko hóyeno koane yêno véyea poixô'o neko tiûketi. Kene hâxa, kuríkoponoa xoko ápostuluhiko itûkoati heú kixoâti kuríkopea ésa'i neko vâne. ");
INSERT INTO terNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ina kixôa Pêturu: —Ananiyá, na koeti sikovó ké'ino Satánae ípihea semekénovo'iti iséneuke? Koati itîkoheinovoti Sasá'iti Omíxone Itukó'oviti koeku he'ono'ú kíxi víyi poixo'o ésa'i ne peké'exa! ");
INSERT INTO terNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Avô'o yakavánea ne peké'exa, koati ítikene. Koane koeku keváneyi, ítikeikone ne tiûketi ésa'i. Ákoni okónoko îtikivo herú kixepoâti kiríkopi. Na koeti ápeino iséneuke kíxineye? Koati Itukó'oviti váherexino ítike koeku simíkikixi, kene haina xâne kixéneye —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kamoáne Anániya neko emo'u Pêturu, íkorokovone poké'eke, yane ivókovone. Yupihovó koe píkeahiko uhá koeti kamoâti neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yane kenó'okone homoêhouhiko ramápu'ikea ina ekoxóponoahiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kalíhanini itóponea mopo'âti ôra ikénepo, simónemaka yêno ne Anániya. Yoko ako éxea koêku neko îma. ");
INSERT INTO terNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ina kixôa Pêturu neko sêno: —Koati yé'akeneoxoye ésa'i keváneyi ne peké'exa, îti yoko îme? Ina yumopâ sêno: —Énomone koati yé'akeneye. ");
INSERT INTO terNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ina kixoá'ikomaka Pêturu: —Na koeti kutipasí ké'inoa ne îme kehá'ayi yopósi'okivo Sasá'iti Omíxone Vúnae? Harakénepo ra homoêhouhiko ekoxóponoati ne îme. Kó'oyene ití'ikomo kixónehikoye —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Koati énomone yaneko ôra, íkorokovone poké'eke neko sêno nonékuke Pêturu, ivókovone. Ina urúkopovomaka neko homoêhouhiko, inú'ikopanemaka neko sêno ivokóvotine. Yane ekóxoponoanemaka xêrerekuke îma. ");
INSERT INTO terNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yupihovó koe píkea heú koêti neko kutípoti Jesus koánehikomaka uhá koeti eyekóxoati neko koekúti. ");
INSERT INTO terNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Êno iyupánevoti ítuke ne ápostuluhiko xapákuke neko xanéhiko, ákoti po'i itukoâti kuteâti, éxokovope xunako Itukó'oviti xapákukehiko. Yoko ixómotihiko ho'uxóvo yane hána'iti imokóvokuti xoko varánda iháxoneti varándana Salúmaum. Yoko kutikokó koe isóneu ikéneke Jesus neko uhá koeti kutipoâti. ");
INSERT INTO terNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kene po'ínuhiko xâne ákoti itukápa ne ha'ínehiko, píkoa ánavokoxeova neko kutípotihiko Jesus. Itea kóyeane téyeahiko koane ínixea itúkeovo itípakovotihiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yoko inamá'axo kuri'úxovo neko êno xâne hokópoti Vúnae Jesus. Koati êno xâne, hóyeno koánemaka sêno, ho'uxínovati ne ítuke Vúnae. ");
INSERT INTO terNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ápemaka xâne ka'aríneti omonétihiko ya none ovokúti, ixané kixókonomaka ipéna, áko'o itukovo poúke, kuxoâti itóponeameamo yúkurea Pêturu koeku vékea motovâti koíteovokonohiko ya aríne. ");
INSERT INTO terNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Enómaka xâne ukeâti po'ínuhiko pitivóko ákoti ahîka Njeruzálem, omotíhiko ka'aríneti yoko xâne ûroevo ndémoniu. Heú koéhiko koíteovokono. ");
INSERT INTO terNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yanê'e, eneponeko koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke, koane uhá koeti ha'ínehiko, ímaikinovo ápostuluhiko vo'oku íyokeovahiko ne ítone itúkea. Yoko aínovohiko sadúseu neko imaíkinovati. ");
INSERT INTO terNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yane namúkohiko evo ápostulu, ina kurikôa ika'ákovokutike. ");
INSERT INTO terNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Itea yaneko yóti, símoa ánjuna Vúnae, mihe'ókopoinoati páhapetea ika'ákovokuti, ina omopâ meúkeke koane kíxeahiko: ");
INSERT INTO terNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Pihépanoe. Hane yenápa hána'itike imokóvokuti. Yokóyuhopoinoa xanéhiko uhá koeti koêku ra inámapoti apéyeati ukeâti xoko Jesus —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kameánehiko neko emó'u, pihóponehiko. Ehá'axo yúponi, ûrukopovanehiko neko hána'iti imokóvokuti. Yane ôvane íhikaxopeamaka. Yoko simoné'e yuhoíkovokutike ne koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke, koáne ne ha'ínehiko, yane ho'úxoane uhá koêti neko tutíyehiko ovâti ne koati payásoti yúhoikovoku jûdeu, ina pahukóhiko veyopónoati ne ápostulu ika'ákovokutike. ");
INSERT INTO terNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Itea simoné'e ika'ákovokutike ne húndaruhiko, páhoehiko veyóponea ne evo Pêturu, áko'onehikoya ne opósiu. Yane kayú koéponehiko xoko pahukoâtihiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Hara kíxovokoxopa: —Símo ûti ya ika'ákovokuti, títiu kóye exéxeovo páhapetea. Koáne ne koyónoti, ápehiko pahapétike, itea mihe'ókoane ûti, ákone apêtiya —kíxovokoxopane. ");
INSERT INTO terNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Enepone tuti húndaru koyónoti hána'iti imokóvoti, yóko'omaka ne tutíhiko sasedóti inuxínoti jûdeuhiko hó'eke, kameánehiko yuhópo, ákone éxina isóneu koêku ne ápostuluhiko áko'oinokenehikoya. ");
INSERT INTO terNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Yane apé koéne eyékoxoponoati. Hara koe yûho: —Enepohikone hóyeno iké'aenoe, harakóxoponehikomaka hána'itike imokóvokuti ihíkaxopotinemaka xanéhikoya —koéne. ");
INSERT INTO terNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yane pihónehiko ne húndaru koyonoâti ne hána'iti imokóvokuti, koánemaka ne payásoti húndaru inuxínoati, ina veyopónoa ne ápostuluhiko, itea itupa'ii kíxoahiko. Koáhati pikotíhiko hepókeokono, eneponi vaheréxina ítuke, vo'oku itúkeovo kotíxone xanéhiko ne evo ápostulu. ");
INSERT INTO terNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ina omáhiko húndaru nonékuke uhá koêti neko pahúkotihiko ovâti ne koati payásoti yúhoikovoku jûdeu. Ina kixohíko ápostulu ne koati payásoti ya uhá koeti sasedóti inuxínoti xanéhiko hó'eke: ");
INSERT INTO terNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Pahúkopinepepo ûti ákoyeane íhikexa koeku Jesus, itea inamá'axoneoxo ketahíneanoe ra ihíkauvoti xapa ko'óvokuti yâye yara Njeruzálem. Haina póhutine, itea ípe'okoveamaka itúkeovo ûti koepékoa ne hóyeno —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ina yumopâ Pêturu koáne ne po'ínuhiko ápostulu: —Yusikóne vitúkea páhoenovi Itukó'oviti yaneko vitúkea páhoenovi xâne. ");
INSERT INTO terNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Enepone Itukó'oviti, kutípone voxúnoekene, koéxepukopo Jesus, enepone képeunoe ya kuruhúke. ");
INSERT INTO terNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kapáyasokopamaka Itukó'oviti ya xunákoke, itukópati natina ûti yoko koitóvoviti, maka enepone viyéno íhae Izarâe, ikátivexane isóneuke ne pahúnevo, koane kuríkanemaka, koane katúyapinanemaka Itukó'oviti ne pahúnevo. ");
INSERT INTO terNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Koati koyuhoâti ûti xapa xâne kaná'uko ne koekúti noíxone ûti, koane koati kouhápu'ikoatimaka Sasá'iti Omíxone Itukó'oviti, enepone poréxoake Itukó'oviti ne xâne itukeâti emó'u —kíxovokoxoane evo Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kamoáne pahúkotihiko xapa jûdeu yûho ne ápostuluhiko, yupihovó koéne ímaikinova koane kahá'ayeamaka koépekeahiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Itea ápe hóyeno koéhati Ngamalíye exepúkoti xapákuke neko pahúkotihiko. Yoko farîzeu neko hóyeno, ihíkaxotimaka yútoe Muîse, epó'oxo koati téyone uhá koeti xâne. Ina pahûko kopúhikoati ne ápostuluhiko meúkeke koeku koyúhoyea. ");
INSERT INTO terNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ina kôe: —Itínoe iyénonjapa íhae Izarâe, neíxipa ne yâha itíkinoanoe ra hóyenohiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Vo'oku ya káxehiko pihotíne, ápe hóyeno koéhati Teûda, itûkovoti payásoti, ho'úxoti koaturu séntu koeti xâne. Itea koépekokono neko hóyeno. Yane heú koéne itáhineyea ne hokoâti. Ákone koyuhoâti, ukê'eyeane. ");
INSERT INTO terNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ikénepoke, ápemaka po'i hóyeno koéhati Njûda, íhae Ngalíleya, ya kaxénake kayúmakexovope xanéhiko. Enómaka xâne hokoâti, itea koépekokonomaka, koane heú koémaka itáhineheyea neko hokoâti. ");
INSERT INTO terNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Énomone ngixínopinoe kó'oyene: Kiríki veô'u ra hóyenohiko. Síkeanehiko, vo'oku enepo itukapu isóneuke xâne úkea ne yûho koane ítuke, uke'é koetímakamo. ");
INSERT INTO terNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Itea enepo itukapu ukeâti xoko Itukó'oviti, ákonoemo ítea yuké'exi. Neíxapunoe, mará'inamo itúkapu Itukó'oviti yokópo —kíxovokoxoane. Yane heú koe ínixea unátiyea neko yuho Ngamalíye. ");
INSERT INTO terNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ina ihaxíkopamaka ne ápostuluhiko. Yane yehépoke'exoahiko, ina ixikó'okoa ákoyeane okóyuho koeku Jesus, yane kuríkopanehiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ipuhíkopeane ápostuluhiko ne yuhoíkovokuti, yupihovó koe elókeyea okóvo vo'oku ínixea Itukó'oviti itúkeovo itoâtihiko koítoponeovo kotíveti vo'oku iha Jesus kutí'inoke porexoâti vékeahiko. ");
INSERT INTO terNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Uhá koeti káxe yane hána'iti imokóvokuti, koánemaka ya ovokúti ya ovokúti, ákone âka íhikaxeahiko koane koyúhoyea koeku Jesus, enepone Mésiya, páhoe Itukó'oviti koíteovo xâne. ");
INSERT INTO terNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Énomone yaneko káxehiko, tumúne yóno kurí'uxeovo xâne hokópoti Jesus. Itea enepohikone koyúhoti emo'u ngerêku kutípoti Jesus, kapáhakovo koane poé'ainoa isóneu ne kutípotihiko Jesus koyúhoti emo'u jûdeu, vo'oku uhá koeti káxe koeku pôrekexeokono nókone ne po'ínuhiko ivokóvoti îma xapákuke neko kutípotihiko Jesus, ákone puyakóvati okóvo nókone ne senóhiko koyúhoti emo'u ngerêku ivokóvoti îma. ");
INSERT INTO terNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yane ho'úxoane ndusé koeti íhikau Jesus uhá koêti ne po'ínuhiko kutípoti Jesus vo'ókuke ne koekúti, ina kixovókoxoa: —Ako yusíka kurí kíxea koyúhoyea ûti ra emo'u Itukó'oviti xapa xâne motovâti yuíxeova ûti koêku ne huvó'oxeokonoke xâne apêti nókone. ");
INSERT INTO terNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Neívakaxaikopo seti koeti hóyeno xepákukenoe, itínoe po'inu ûti xoko Vúnae. Konókoti itúkeovo hóyeno teyonéti, koati xúnatimaka ne Sasá'iti Omíxone Itukó'oviti xokóyoke, koane éxotimaka itúkea isóneu, motovâti poré'okea ûti ra itukéti. ");
INSERT INTO terNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kene ûti, uti ápostulu, hara yuíxovomo ûti vitúkea orásaum koane koyúhoyea uti emo'u Itukó'oviti xapa xanéhiko —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ínixoa uhá koeti kutípoti Jesus unáko neko isóneu ápostuluhiko. Ina noivókoxo Etévaum, hóyeno koati kuvóvoti Itukó'oviti koane koati xúnatimaka ne Sasá'iti Omíxone Itukó'oviti xokóyoke. Noívokoxohikomaka Filípi; Porókoru; Nikáno; Tímaum; Pármena; yoko Mikúlau, eneponeko íhae Antiokíya hokópoti hó'e jûdeu yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ina omâhiko nonékuke ápostuluhiko itukínoa orásaum koane ípihea vô'u tutíkuke haxakínoati ítuke Itukó'oviti yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tumúne yóno ukóponea ne emo'u Itukó'oviti. Kene ya Njeruzálem, koati kuri'úxovoti yé'akeneye ne xâne hokópoti Jesus. Ákomaka yumáxapu sasedóti, enepone inuxínoti jûdeu hó'eke, kutipoâti ne ihíkauvoti koyúhoti koeku Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Eneponeko Etévaum, koati iyúseoti ne hána'iti seánako yoko xunako Itukó'oviti xokóyoke koeku itúkea iyupánevoti xapákuke ne xanéhiko koánemaka po'ínuhiko koekúti, hoénaxovope ne hána'iti xunako Itukó'oviti xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Itea ápe íhikaxovoku hó'e jûdeuhiko iháxoneti “Íhikaxovoku xâne iteóvoti itúkeovo akaúti”. Ako tôpi úkohikeaku neko xanéhiko yonóheixoati. Ápe ukeâti Sîreni yoko Alíxandiriya, Silísea yoko Âzea. Koati okópoti Etévaum nekôyohiko. ");
INSERT INTO terNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Itea enepone hána'iti exóneti, poréxoake Sasá'iti Omíxone Itukó'oviti ne Etévaum, yupihovó kôe anú'ukea éxone ne xanéhiko okopâti. ");
INSERT INTO terNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yane noixoânehiko ákoyea íta, poréxonehiko tiûketi hóyenohiko usó koyêti itúkoheyea koeku Etévaum. Hara koe yuhóhiko itúkoheyea koêku: —Kámoa ûti ra hóyeno váherexino yuho Muîse koánemaka Itukó'oviti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Vo'ókuke neko yuhóhiko, ímaikexovo ne xanéhikoya, koánemaka ne po'ínuhiko teyonéti xapákuke tuti jûdeu yóko'o ne éskiriba, enepohikone ihíkaxoti yútoe Muîse. Ina namukóponohiko Etévaum, iyonoâti xoko koati payásoti yúhoikovoku jûdeu. ");
INSERT INTO terNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Simonéhikoya, ina pahukôa neko hóyenohiko itúkoheyea koeku Etévaum nonekútike. Hara koe yuhóhiko itúkoheyea koêku: —Eneporâ'a, ako âka váherexinoa emó'u ne hána'iti imokóvokuti, enepone sasá'iti óvoku Itukó'oviti, koánemaka ne Ponóvoti Kixovókuti yútoe Muîse. ");
INSERT INTO terNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Vo'oku kámoa ûti koyúhoyea kotóhinekexopeamo óvoku Itukó'oviti ne hóyeno koéhati Jesus íhae Nazâre, koane ípokeamo kixoku vitúkeovo, enepone páhoenovi Muîse vitúkea ya Ponóvoti Kixovókuti yútoe —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yoko uhá koêti neko ivatáhikoti kúveuke neko yuhoíkovokuti, pono-ponó kixínonehiko ûke Etévaum noixeâtihiko ne nône kutí kó'iyeane none ánju. ");
INSERT INTO terNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ina kíxo Etévaum ne koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke: —Kaná'utimea ne yuhóhiko koêku ne ítike? ");
INSERT INTO terNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ina yumopâ Etévaum: —Itínoe mbo'ínu, keáne itínoe teyonéti xapákuke ûti, yakámokenonu. Enepone hána'iti ihayú'iuti Itukó'oviti, kaútata'ixinovo voxú'ikene Âbraum yaneko ovo'íko Mezopotámiya tumúneke ípokopeovo ya Âram. ");
INSERT INTO terNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Hara kíxoa Itukó'oviti: “Ipíhiki peké'exa koáne ya xapa iyínoxapa. Hara yenápa poké'e énjokopikemo” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yane ipúhikopeane Âbraum ne poké'exa kaúdeu yonópoti Âram. Ivokóvone há'a, ina iseópa Itukó'oviti yara poké'e vóvoku kó'oyene. ");
INSERT INTO terNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Itea avo poké'exa Âbraum yara poké'e, muhíkova kalihú koeti itátane. Yane koyúhoinoa Itukó'oviti poréxeamo uhá koêti neko poké'e, koane itúkeovomakamo ítuke amósenopono ikénepoke, upánini âvoyea xe'éxa yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ina koyuhó'inoakomaka Itukó'oviti koêkumo ne amósenopono ovó kó'iyeamo poké'e ákoti itukapu ítuke, koane itúkeovomo kaútiya, yoko komóhiyeokonomo kúveu koaturu séntu koeti xoénae. ");
INSERT INTO terNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","—Ina kixoá'ikomaka Itukó'oviti: “Imbihóponoatimo ne xanéhiko itukoâtimo ákau ne yamósenopono. Ikénepoke, ínamo ipuhíkapea neko poké'e. Yane itukoâtimo ne mbáhoenoa itúkea yâye yara poké'e” kíxoane Itukó'oviti ne Âbraum. ");
INSERT INTO terNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yane pahúkoane Itukó'oviti sirkunsidá kó'iyea ne Âbraum, koánemaka xe'éxa, yoko uhá koeti hóyeno xapákuke amósenoponomo, hoénaxovope itúkeovohiko xanena Itukó'oviti. Ehane ápe Izáki, xé'a Âbraum. Oitú koené'e káxe ike ipúhikine, sirkunsidá kíxoane Âbraum. Paya'íne Izáki, ápe xe'éxa koéhati Njáko. Kene xe'éxaxapa Njáko, énomone neko ndusé koeti hóyeno, turi viyénoxapa. ");
INSERT INTO terNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","—Enepohikonekôyo, kavánehiko Yûse, enepone âti, xoko íhae Ejítu. Kixínoakeneye, ahuxúkinovati okóvo neko âti vo'oku íyokeova kíxoaku há'a kátarakea. Itea ako kurí íxa Itukó'oviti ne Yûse. ");
INSERT INTO terNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Koítova ya uhá koeti kotíveti kixókonoku. Poréxoamaka hána'iti itipánevoti koane exóneti nonékuke Farâo, natina Ejítu, eneponeko poréxoti Yûse itúkeovo pahúkoti ya poké'exa Ejítu. Poréxoamaka éxea koêku ne uhá koeti apêti óvokuke. ");
INSERT INTO terNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ehane ápe êno hímakati ya uhá koeti poké'exa Ejítu. Enómaka kotíveti koekúti ya poké'exa Kanâm. Ákone nîka neko voxúnoekeneya. ");
INSERT INTO terNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Eyekóxoane Njáko ápeyea êno nikokónoti ya Ejítu, pahúkoane neko xe'éxaxapa, enepohikoneko voxúnoekene, píheaya. Yoko inúxotikone pahúkoaya. ");
INSERT INTO terNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ya pí'apeke pihóhiko, ina etó'okoa Yûse itúkeovo koati po'ínu. Yane éxoane Farâo neko iyénoxapa Yûse. ");
INSERT INTO terNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pahúkoa Yûse neko po'ínuhiko veyóponea ne há'a, eneponeko Njáko, koane uhá koeti iyénoxapa. Yoko seténtai sinku koe uhá koêti neko iyénoxapa. ");
INSERT INTO terNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yane ípokopovone Njáko ya Ejítu. Énomone ivókopovo, koánemaka neko voxúnoekene. ");
INSERT INTO terNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Itea omópokonohiko mûyo ya Síkem ekóxoponeokono xoko uhôro kehoéti mopoíke, enepone váneu Âbraum xoko xe'éxaxapa Ému mekúke —kíxovokoxoane Etévaum. ");
INSERT INTO terNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ina koe'íkomaka: —Ye'éxovone kaxena koúsokea Itukó'oviti neko koati emo'úti ákoti aukápapu, yuhó'ino Âbraum nóvo, yupihovó koéne ukóponea neko viyénoxapa ya poké'exa Ejítu. ");
INSERT INTO terNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Enoné'e xoénae ike ivókinevo Yûse, ehane ûrukovo po'i pahúkoti. Yoko ako exa Yûse nekôyo. ");
INSERT INTO terNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Eneponeko nâti, koati ahúkoti ya aupú'ikeati. Komohí kixo voxúnoekene, koane íkoitoponoahiko kotíveti. Pahúkomaka voxúnoekene kûrihikea neko inámatiko xe'éxa, kaha'aînoati ívohikeovo. ");
INSERT INTO terNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Énomone yaneko káxehiko, ipúhikone Muîse. Yoko yupíhova itúkeovo koati exóketi kalivôno. Kúveu mopo'âti kohê, ítoa êno yoko há'a hé'onea óvokuke. ");
INSERT INTO terNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ikénepoke enepo iyonôa huveóke, ipokôa hé'onoaku, ínixopa ihine Farâo. Yane omópane óvokuke koexókexopati. Kutí kixópane koati xe'éxa. ");
INSERT INTO terNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yoko aínovo exóneti ya Ejítu íhikaxokono neko Muîse. Koati hána'iti teyonéti nê'e, ênoti xunáko ya koyúhoyeake koáne ya uhá koeti ítuke. ");
INSERT INTO terNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","—Koarénta koené'e xoénaena neko Muîse, kenó'okone isóneuke kahá'ayea noíxoponea iyénoxapa, enepohikone izaraelíta. ");
INSERT INTO terNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yaneko noíxoponeaku, ápe hóyeno íhae Ejítu isúkoti izaraelíta ákoti évotikoake. Noixoâne Muîse, ina kotixôa neko izaraelíta vaheréxinokonoti ítuke. Itúkopinoa ésa'i, koépekoa neko íhae Ejítu. ");
INSERT INTO terNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Yoko ikútixati Muîse exoâtimo iyénoxapa itúkeovo páhoe Itukó'oviti koíteovahiko. Manîrapo ako éxahiko kó'iyeaneye. ");
INSERT INTO terNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yaneko po'ípone káxe, noíxoanemaka Muîse ne iyénoxapa isukókoti. Ina kaha'â haxákea. Hara kíxoahiko: “Itínoe hóyeno, koati kepo'ínukokoti. Na koeti isíkinokoko?” kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","—Itea enepone hóyeno isúkoti po'ínu, okopo Muîse. Hara kíxoa: “Inípono îti kehá'ati kepáyasokinovovi, kehá'atimaka itíkivo yúhoikovoku ûti. ");
INSERT INTO terNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Hainá'ikopomea kehá'ati képekinu kuteâti kíxeaku ne íhae Ejítu kiyakáxeke?” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kameáne Muîse neko yûho, oméxovone. Kohó'ine ya poké'e koéhati Midíyam. Koeku óveaya, ápene pi'âti xe'éxa, hóyeno kalivôno. ");
INSERT INTO terNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","—Ikénepoke óvea koarénta koeti xoénae yaneko poké'e, koútata'ixinova ánju íhae vanúke xapákuke irúmene yúku, xoko kali xuve tikóti irumékoti. Yoko hane óvo poké'e ákoti ovâti, xêrerekuke neko hána'iti mopôi koéhati Sinâi. ");
INSERT INTO terNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Koati hána'iti iyúpaxeova Muîse noixoâne neko koekúti, ina ahi'ókovaxo ivóko'okoponea. Yane apé koéne emo'u Vúnae kixoâti: ");
INSERT INTO terNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Undi Itukó'oviti, kutípone yoxúnoekene Âbraum, Izáki yoko Njáko” kíxoane. Yoko hána'iti píkea Muîse, koane honónokea mûyo. Ako íta komómoyea. ");
INSERT INTO terNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ina kixoá'ikomaka Vúnae Itukó'oviti: “Víya ne piríkatana, vo'oku koati sasá'iti ra poké'e yókonukoku. ");
INSERT INTO terNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Koati noinjoâti koítoponeovo kotíveti ne njanéna ya poké'exa Ejítu, koane ngameâtihiko varú'inevo koeku koítoponeovohiko kotíveti. Énomone evénzekino ngoítoponeovahiko. Kó'oyene, keúsakapu, vo'oku mbahukópiti ya Ejítu” kíxoane Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","—Yoko énomone ne Muîse, púvone iyénoxapa itúkeovo yúhoikovoku. Harapepo kixókono: “Inípono îti kehá'ati kepáyasokinovovi, kehá'atimaka itíkivo yúhoikovoku ûti” kixókono. Énomonemaka ne Muîse, páhoe Itukó'oviti itúkeovo tûti yoko koitóvati yaneko koutáta'ixinova ánju xoko xuve tikóti. ");
INSERT INTO terNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Koati Muîse inuxópino viyénoxapa ipuhíkopea Ejítu. Kúveu koarénta koeti xoénae, êno iyupánevoti ítuke yoko po'ínuhiko koekúti, hoénaxovope xunako Itukó'oviti xokóyoke. Aínovone ítone itúkea ya koeku óvea poké'exa Ejítu, koáne yane mar iháxoneti Hararáno'evoti, koánemaka yaneko mêum ákoti apêtiya. ");
INSERT INTO terNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Koati Muîse itukoa yûho râ'a, yuhó'ino xanena ûti, uti íhae Izarâe. Hara kôe: “Xapákuke viyénoxapa, apêtimo po'i hóyeno kuteâti ûndi, noívokoemo Itukó'oviti itúkeovo porófeta koyuhó'iyeati emó'u xapa xâne” kôe. ");
INSERT INTO terNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Koatímaka Muîse opónoa neko mêum ákoti apêti xapákuke neko êno xâne ho'uxóvoti, koane xokóyoke ne ánju yuhó'ixoati oúkeke neko hána'iti mopôi, enepone Sinâi, koane xapa voxúnoekene. Koatímaka Muîse namukôa neko yuhôti apêti xunáko ikó'inamakopeovi, enepone yuho Itukó'oviti, koane énomonemaka koyuhópinovea. ");
INSERT INTO terNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","—Itea ako akáha'a itúkea yuho Muîse neko voxúnoekene. Koati puvâtihiko, koáne ya isóneuke aúkopovohiko ya poké'exa Ejítu. ");
INSERT INTO terNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Hara kixóhiko Âraum yanekôyo: “Itíkinavi okovo hokonéti, kuvóvonemo ûti, motovâti inúxinovi. Vo'oku enepone inuxópinoviti vipuhíkopea poké'exa Ejítu, ákone véxea koêku” kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Énomone yaneko káxehiko, itúkone okovo xe'exa váka ne xanéhiko, ina isukínoahiko hó'openo itukínoati ikó'iparaxoake. Ínamaka koyuíhiko, elóketihiko okóvo vo'ókuke neko kixovókuti ítuke vô'u. ");
INSERT INTO terNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Vo'ókuke ne kixóvokuhiko, ahíkuxopeova Itukó'oviti. Sikó kíxoane píhoheyea ikéneke po'i ho'éti, enepone heú koeti hékerehiko ya vanúke, kuteâti koêku ne yútoe porófeta emó'uke Itukó'oviti. Énomone ne koêti: “Itínoe íhae Izarâe, koeku yóvoheixi neko mêum ákoti apêti kúveu koarenta koeti xoénae, undí'ikopomea képekino hó'openo itíkoti iké'iparaxonuke? Ako kalíhuina. ");
INSERT INTO terNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kéxepukonoemaka kali péti, ipó ipo kixonéti, óvoku ihéyu'iki hékone koéhati Molóki, yoko okovo hékere koéhati Réfam, ainóvoti ítikenoe ya veô'u. Vo'oku kurí kixépinu, hekópoti koekúti kuteâti, mbahukópopitinoemo ya poké'e ákoti malîka yâtikeneye ya Mbabílonea” kôe ne yútoe porófeta —kíxovokoxoane Etévaum. ");
INSERT INTO terNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ina koe'íkomaka: —Koati apêti óvoku Itukó'oviti xapákuke voxúnoekene. Énomone neko tabenákulu, ipó ipo kixonéti koeku yónoheyea xanéhiko yaneko mêum ákoti apêti. Enepone tabenákulu, itúkoa Muîse kuteâti páhoenoa Itukó'oviti itúkea, kuteâti neko éxokoake Itukó'oviti inúxotike, kaha'aînoti Muîse íkutipasikea neko íkomumuxoake. ");
INSERT INTO terNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Enepone óvoku Itukó'oviti, ápenemaka ya kaxénake Njozûe. Ípohikoane voxúnoekene, koinoâti enepo itukópane poké'exa neko émeuxa xanéhiko kópuhiu Itukó'oviti. Yoko ápeikomaka neko péti xapákuke viyénoxapaikene tukú koeti kaxena Ndávi. ");
INSERT INTO terNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Enepone Ndávi, koati hóyeno kóseanane Itukó'oviti. Épemo Itukó'oviti, enepone kuvóvonemaka voxú'ikene Njáko, yusíkea itúkinoa óvoku. ");
INSERT INTO terNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Itea Salúmaum, xé'a Ndávi, itukóvo koexépukoati neko hána'iti imokóvokuti, óvoku Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","—Itea ako ava ovokúti, koéxepoe xâne, ne Itukó'oviti, enepone koati payásoti ya uhá koêti, kuteâtimaka koêku ne yútoe porófeta mekúke, enepora koêti: ");
INSERT INTO terNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ ‘Vanúke indúko óvongu nandíxea. Kene ra poké'e, kutí ngíxoa ómomikoku njêve’ koe Vúnae Itukó'oviti. ‘Kutí'ikopomo itukóvo ovokúti mani ítikeinonunoe? Manímea apêti ómomingoku ítikeinonu? ");
INSERT INTO terNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hainá'ikopo ûndi itukôa uhá koêti ra koekúti apêti?’ ” kôe yútoe porófeta —kíxovokoxoane Etévaum. ");
INSERT INTO terNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ina kixovókoxopaikomaka Etévaum neko tutíhiko jûdeu: —Itínoe xâne koati tiú'iti omíxone koane ákoti akutípo. Iti xâne exexeâti isóneu yoko kêno ne emo'u Itukó'oviti! Kéyekune kétiu'ikinoe yomíxone yokopâti ne Sasá'iti Omíxone Itukó'oviti, kuteâti kixoku itúkeovo neko yoxúnoekene. ");
INSERT INTO terNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ako ápahuina porófeta ákoti itukapu íkoitoponone kotíveti yoxúnoekene. Enepohikonê'e, koépekexomaka ovoxe Itukó'oviti koyuhoâti nóvo kenó'okeamo neko koati Ponóvoti Páhoe Itukó'oviti, enepone váherexinokemaka ítike koane képekeunoemaka, ");
INSERT INTO terNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","itínoe namukoâti ne Ponóvoti Kixovókuti yútoe Muîse, omínopike ánjuhiko, enepone ovóxe Itukó'oviti ukeâti vanúke, itea ako itíka —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kamoné'e yuho Etévaum neko tutíhiko jûdeu, yupihovó koéneoxo ímaikinovahiko koane ngarútutukexea ôe. ");
INSERT INTO terNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Itea koati xúnati ne Sasá'iti Omíxone Itukó'oviti xoko Etévaum. Yane pono-ponó kixone ûke vanúkeke neko Etévaum koane noíxea êno uhé'ekoti uhapú'iti ukeâti xoko Itukó'oviti, koánemaka Jesus éxopeke Itukó'oviti, ");
INSERT INTO terNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ina kôe: —Koati imihé'okinonuti ra vanúke. Noínjopane ne Íhae Vanúke ikútipasikoponovoti xâne, xe'ó koyêti éxopeke Itukó'oviti xoko óvoku kapáyasokone Itukó'oviti —koéne. ");
INSERT INTO terNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yane vaúkexo neko okópoti Etévaum. Exexó kixónehiko kêno ya vô'u koane uhá kó'iyea éhahikeovo namúkoponea Etévaum. ");
INSERT INTO terNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Yane káhakoane meúkeke yane pitivóko, ina hepokoâhiko ya mopôi. Enepohikone koyúhoti ákoyea aúnati ítuke Etévaum, veyópohiko kápana muyókuke, ina kurikoâhiko xoko homoêhou koéhati Saûlu ");
INSERT INTO terNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","koeku hepókea Etévaum. Kene Etévaum, Jesus vaúko ya orásaum-ke. Ha koe yûho vaúkea: —Unaém, nemúkapa ra omínjone —koéne. ");
INSERT INTO terNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yane ipuyuké koéne, koane kóhonokea emó'u kó'iyea: —Unaém, hako ipihéponoahiko vo'ókuke ra váhere ítukeinonu —koéne. Yane ivókovone. ");
INSERT INTO terNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Yoko ínixoamaka Saûlu unáko koépekeokono ne Etévaum. Yaneko káxe, turíxovone ápeyea ikoítoponoati kotíveti ne kutípotihiko Jesus ya Njeruzálem. Yane itóhineone uhá koêti neko kutípoti Jesus ya po'íke ipuxóvokutihiko ya Njúdeya koánemaka ya Samâriya. Poéhane ápostuluhiko ako itahínehea. ");
INSERT INTO terNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Yoko ápe hóyenohiko teyoti Itukó'oviti ekoxóponoati neko Etévaum, ikotívexoatihiko isóneuke ne koekúti. Yupihovó kôe íyokexeahiko vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kene neko Saûlu, koati vaheréxinoati ítuke ne kutípotihiko Jesus, kaha'âti uké'exea. Koêkuti ovokúti ûrukovoku nê'e, koeku inú'ikea hokoti Jesus-ya, káhakoa meúkeke, hóyeno koánemaka sêno, omopâtihiko ika'ákovokutike. ");
INSERT INTO terNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kene neko kutípoti Jesus itohíneheoti, koyúhohiko emo'u Itukó'oviti koêkuti vékokuhiko. ");
INSERT INTO terNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Yoko Filípi, Samâriya yóno koane koyúhoyea koeku Kristu. ");
INSERT INTO terNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Koyuhóne Filípi xapa xâne, yupíhova ivávakeokono neko yûho. Koáhati noixeâti xanéhiko neko ítuke, hoénaxovope xunako Itukó'oviti xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Êno xâne ûroevo ndémoniu koítovone Filípi. Koati kohonókoti emó'u vaúkea ne ndémoniuhiko koeku ipúhikopea. Enómaka xâne isayú'ixovoti ákoti ehevákapu mûyo, koane mohéveu, koítovone Filípi. ");
INSERT INTO terNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Koati hána'iti elókeyea okóvo ne xanéhiko yane pitivóko vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Yoko yaneko pitivóko, ápe hóyeno koixómoneti koéhati Símaum. Ítoa íkutipea xanéhiko ya Samâriya itúkeovo hána'iti ko'éxoneti, aupú'ikoati yane ítuke. ");
INSERT INTO terNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Heú koe xâne ivavákea yûho, kúteane xâne payásoti yoko ákoti apayáso. Hara koéhiko vo'ókuke: —Enepora hóyeno, koati ovâti hána'iti xunako Itukó'oviti, íhaxinokonoke “Hána'iti Xunakóti” —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ivávakinokonoke neko Símaum vo'oku mekú'iyeane itúkovo koixómoneti itúkoti iyupánevoti, aupú'ikoati ne xanéhiko yane ítuke. ");
INSERT INTO terNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Itea kutipoâne xanéhiko ne yuho Filípi koyuhó'inoane koêku ne natíxea Itukó'oviti xapa xâne koánemaka koeku Jesus Kristu, áhikovonehiko ya iháke Jesus, hóyeno koánemaka sêno. ");
INSERT INTO terNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Muhíkova neko Símaum, kutípoanemaka. Yane áhikokonone. Koêkuti yónoku Filípi, pihómaka ne Símaum ikéneke. Ako iríka. Koati hána'iti iyúpaxeovo ítuke Filípi, enepone êno hána'iti iyupánevoti ítuke, hoénaxovope ne xunako Itukó'oviti xokóyoke. ");
INSERT INTO terNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eyékoxoanemaka ápostuluhiko ya Njeruzálem namúkeane emo'u Itukó'oviti ne íhae Samâriya. Yane pahúkinoahiko Pêturu yoko Xuâum. ");
INSERT INTO terNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Simoné'e evo Pêturu xapákuke, itúkinoa orásaum maka namúkanehiko ne Sasá'iti Omíxone Itukó'oviti, ");
INSERT INTO terNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","vo'oku âvoyea evésekapa xokóyokehiko. Pohúneti ahíkovotinehiko ya iháke Vúnae Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yane ípihone vô'u evo Pêturu tutíkuke neko xâne, yane namúkoanehiko ne Sasá'iti Omíxone Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Noixoâne Símaum namúkeanehiko ne Sasá'iti Omíxone Itukó'oviti koeku ípihea vô'u evo ápostulu tutíkuke neko xâne, yane kahá'ane poréxea tiûketi evo Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Hara kíxoa: —Peréxanu xunakóti kuteâti xináko, motovâti namúkea Sasá'iti Omíxone Itukó'oviti ne koêkuti ímbihone vô'um tutíkuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ina kixôa Pêturu: —Koati metokeâti yenópi ipihóponovokutike xané kixepoâti ne tîketina. Inípono îti, ikítixati vanêti ne íparaxeovike Itukó'oviti, enepone Sasá'iti Omíxone! ");
INSERT INTO terNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ákomo kalíhuina itíkivo ha'ine ûti yara itukéti, vo'oku ako panápu iséneu nonékuke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Konókotiko ikétivexi iséneuke ne pehúnevo koane kiríkopi. Yépema Vúnae kóseanayeopi. Ávaina avá'avo oxéne itúyopea ne váhere iséneu. ");
INSERT INTO terNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Koati ininjoâti yupíheovo kotíveyea iséneuke ne ákoyea ítea itíki kuteâti ra índuke. Ika'ó kixópi ne váhere iséneu koeku yupíheovo íyekivoa itíki kuteâti ne índuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ina kíxo Pêturu ne Símaum: —Yépeminanuikopo Vúnae Itukó'oviti maka hákone yóno oúngeke kuteâti ne yihó'inonumeku —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Uke'éxoane evo Pêturu koyúhoyea emo'u Vúnae xapákuke neko xâne, aúkopovohiko Njeruzálem xoko vekópoku. Êno kálihunoe ípuxovoku samarítanu koyúhoakumaka ne inámati ihíkauvoti koyúhoti koeku Jesus koeku pihópeahiko. ");
INSERT INTO terNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kene Filípi ápe ánjuna Vúnae kixoâti: —Keúsakapu, pîhe ya íyeu úkeaku kásati. Hane víka xêne taru'úxoti mêum ákoti apêti, enepone ukeâti Njeruzálem yonoti Ngâza —kíxoane. Úkeane pího ne Filípi. ");
INSERT INTO terNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Yoko ápe hóyeno íhae po'i poké'e koéhati Etiópea vekoâti neko xêne. Eunúku itukóvoye neko hóyeno, koane koati payásoti ko'itúkeinoti sêno koéhati Kandáse, natina Etiópea. Énomonemaka exôa koêku ne tiûketi ya natíxokuke Kandáse. Yoko ukopeâti Njeruzálem neko hóyeno, yónoku iháyu'ikoponea Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Vataa koépo karósanake ixómoti yuhoíkopo emo'u Itukó'oviti yútoeke porofeta Izâiya. ");
INSERT INTO terNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ina kíxo Filípi ne Sasá'iti Omíxone Itukó'oviti: —Yahí'akapa rakene karósa, yaxénapoa —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ina ehakínova Filípi. Koeku ahí'okeova, koane kámea ne hóyeno yúhoikea emo'u Itukó'oviti yútoeke porofeta Izâiya, ina kixôa Filípi: —Yéxoa kixó'ekone ne yího'iu? ");
INSERT INTO terNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ina yumopâ neko hóyeno: —Namo ngíxoaye énjea hákotimo kourápu'ikinonoati? —kíxoane. Yane ítaikone Filípi evésenekuyea ne ivú'e ivátakea xêrerekuke. ");
INSERT INTO terNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yoko eneponeko yúho'iu emó'uke Itukó'oviti, énomone ne koêti: “Kutí kixókono su'ûso omonéti xoko koépekokonoku. Kuteâti koeku ákoyea yaíka ne kali xe'exa su'ûso enepo vate'íkokono, énomonemaka koéneye ákoyea yûho râ'a. ");
INSERT INTO terNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Yaneko yupíheovoku kixókonoku, ako ápahuina xâne ponoâti ne ítukeinoa. Ápeikopo itoâti kayúmakea váherevoko ne xanéhiko kûrivokoevo? Vo'oku koépekeokono, áko'one yara poké'e” koêti. ");
INSERT INTO terNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ina kíxo Filípi neko hóyeno: —Émbemopi keûrapu'ikinonoa kíxone ra porófeta. Kixopóvotimea? áko'o po'inu xâne kixómea —koéne. ");
INSERT INTO terNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ina kouhápu'ikinoa Filípi kíxone. Koati koukeâti yútoeke porófeta koyúhoinoa koeku Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ehánehiko itópono óvoku úne koeku yónea. Ina kôe neko hóyeno: —Anéye úne. Motóvanemea ánjikeovo ya iháke Jesus? áko'o ápemea itopónuti. ( ");
INSERT INTO terNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ina kixôa Filípi: —Enepo heru'ó ixêa yomíxone kitípi ne Vúnae, motóva yáhikivo ya iháke kó'oyene. Ina kixôa neko hóyeno: —Ngutípoa itúkeovo Xe'exa Itukó'oviti ne Jesus Kristu —koéne.) ");
INSERT INTO terNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ina pahukôa ixíkeovo ne ivú'e. Pihóne úneke neko pi'âti. Yane áhikoane Filípi. ");
INSERT INTO terNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ipuhíkopeanehiko úne, má kixópane Sasá'iti Omíxone Itukó'oviti ne Filípi. Ákone naíke'exapa áhiu. Yane ukópononemaka neko hóyeno. Yoko koati hána'iti elókeyea okóvo koeku vekópea neko xêne. ");
INSERT INTO terNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kene Filípi, apé koépone ya pitivóko koéhati Azôtu. Koêkuti vekópoku yâtikeneye, koyúhopinoa emo'u Itukó'oviti ne xanéhikoya. Koatine kóye; tukú kixópa seôpo ya Sezâreya. ");
INSERT INTO terNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Yoko koati ixómotiko oposí'ixoa Saûlu kíxoaku koépekexea ne kutípotihiko Vúnae Jesus. Koati kaha'âti uké'exea. Énomone pihíno xoko koati payásoti ya uhá koeti sasedóti inuxínoti jûdeu hó'eke ");
INSERT INTO terNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","epemóponoati koyuhópeti yonoti xoko inuxínotihiko itukéti íhikaxovokuke hó'e jûdeu ya pitivóko iháxoneti Ndamásku. Enepone koyuhópeti veyóponone, poréxoa iká'akea koêkuti kó'iyeovoku ínixoponone, hóyeno koánemaka sêno, hokoâti ne ihíkauvoti íhauti Kaná'uti Xêne yonópoti xoko Itukó'oviti, koane omópea ika'ákovokutike ya Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Úkeane pího ne Saûlu. Koeku yé'exeane Ndamásku, apé koéne koati xúnati uhapú'iti ukeâti vanúke kouhápu'ikoati. ");
INSERT INTO terNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yane íkorokovone Saûlu poké'eke. Ápemaka emo'úti kámone kixoâti: —Saulú, imáko ké'iyivoku. Na koeti váherexino ítikeinonu? ");
INSERT INTO terNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ina yumopâ Saûlu: —Kuti îti Unaém? —Undi Jesus, enepone váherexinoke ítike. ");
INSERT INTO terNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yexépukapa, yûrukapa ne pitivóko, ínamo yexákakana ne nékone itíki —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kene xánena Saûlu, xe'okó koéne, yunukú koéne. Kámoahiko neko emo'úti itea akó'oti inixâ neko koyúhoti. ");
INSERT INTO terNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ina exepúkopea poké'e neko Saûlu. Kahâ'a míhe'okopea ûke, ákone ínixa. Yane ápene namukeâti vô'u hirikoâti tukú koeti Ndamásku. ");
INSERT INTO terNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mopó'a káxe ako ínixa. Ákomaka nîka, koane ákomaka énapu úne. ");
INSERT INTO terNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yoko ápe hóyeno ya Ndamásku kutípoti Jesus, koéhati Anániya. Yúho'ixoa Vúnae ya kutí koeti hopúne. —Ananiyá —kíxoane. Ina yumopâ Anániya: —Usó ngóye koêkuti kevóxenuku Unaém. Ina kixopâmaka Vúnae: ");
INSERT INTO terNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","—Keúsakapuikopo, pîhe ya xoko rúva iháxoneti Ponóvoti, óvokuke hóyeno koéhati Njûda. Yapásikamo hóyeno koéhati Saûlu íhae Társu. Yara koeku kó'oyene, ixómoti itûko orásaum. ");
INSERT INTO terNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mboréxoane ya kutí koeti hopúne ínixeopi yurúkovoti óvokuke, ipíheti veô'u tutíkuke motovâti ínixopea —kíxoane Vúnae. ");
INSERT INTO terNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ina yumopâ Anániya: —Unaém, enóne xâne koyuhó'inonoati koêku ne hóyeno. Koati vaheréxinoati ítuke ne xanéhiko kesása'iupone ya Njeruzálem. ");
INSERT INTO terNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Epó'oxo koeku símea yâyeke, ápe koyuhópeti ómone, ukeâti xoko tutíhiko sasedóti inuxínoti xanéhiko hó'eke, porexoâti iká'akea uhá koeti kutipópiti. ");
INSERT INTO terNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ina kixôa Vúnae: —Pîhe, vo'oku koati noívongoe itúkeovo ko'itúkeinonuti ne hóyeno. Koyúhotimo emó'um ya xapa xâne ákoti itukapu jûdeu, koáne ya nonékukehiko nâti, koánemaka xapa íhae Izarâe. ");
INSERT INTO terNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Epó'oxo enjókoatimo kónokea yupíheovo koítoponeovo kotíveti índukeke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yane pihóne Anániya óvokuke Njûda. Urúkovone ovokútike, ípihone vô'u tutíkuke Saûlu xaneâti kíxea: —Saulú, iti mbo'ínu xoko Vúnae. Koati Vúnae pahúkonu yâyeke, enepone Jesus kautáta'ixinovopiti xenékuke xoko víkoku kino'óko yâkeneye. Pahúkinonuke yâye maka ínixepane, koane áxunaneoxomaka ne Sasá'iti Omíxone xikóyoke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Énomone yaneko ókoku ôra, apé koéne koekúti irihíkopovoti ukopeâti ukékuke ne Saûlu kutí koeti xo'orópiti. Yane ínixopone, ina exepúkopo, yane áhikovone ya iháke Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ike nikópea, xunápone koxé'u. Ápe kali ye'á koetí'iye káxe óveako ne Saûlu ya Ndamásku kaha'íneatihiko ne kutípoti Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Énomone yanê'e, turíxovone ne Saûlu koyúhoyea koeku Jesus ya Ndamásku ya íhikaxovokuke hó'e jûdeuhiko, koyuhoâti itúkeovo koati Xe'exa Itukó'oviti ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yupíhova iyúpaxeova uhá koeti kamoâti. Hara koéhiko vo'ókuke: —Hainá'ikopo énomone ne koepékexoti kutípoti Jesus ya Njeruzálem? Hainá'ikopomaka mani simínoke yâye iká'akoponea yoko omópea iká'ae xoko tutíhiko sasedóti inuxínoti xâne hó'eke ûti ya Njeruzálem? —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Itea inamá'axo ukopóno itúkeovo éxoti koyúhoyea koeku Jesus ne Saûlu. Enepohikoneko jûdeu ko'óvokuti ya Ndamásku, ákone éxina isóneu kixoku yumópea Saûlu. Koáhati kouhápu'ikoati Saûlu itúkeovo Mésiya, páhoe Itukó'oviti koíteovo xâne, ne Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Xu'ikénene, ina ho'uxóvo ne jûdeuhiko oposíkinoati isóneu ne Saûlu kixokumo koépekea. ");
INSERT INTO terNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Itea eyékoxoa Saûlu neko isóneunokono. Yoko káxe, yóti veyónehiko neko okopâti kóyonoyea páhapetea ne pitivóko kaha'âtihiko koépekea. ");
INSERT INTO terNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Itea ya yóti, íkoho'ixo Saûlu neko íhikauhiko, kopúhikopatihiko meúkeke yane pitivóko, evékopati oúkeke ne îpi ya hána'iti sésta. ");
INSERT INTO terNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Yane hane yonópo ne Saûlu Njeruzálem. Seopóneya, kahá'a ánavokoxopeova ne kutípotihiko Jesus, itea uhá kôe píkeahiko. Akó'oti akutípoahiko itúkeovo hokópotine Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Itea óma Mbaranâbe ne Saûlu xapákuke neko íhikau Jesus. Ina koyuhó'inoahiko koêku ne Saûlu xenékuke noíxea Vúnae, koane ápeyeamaka yuhó'inoa Vúnae. Koyúhoinoahikomaka ákoyea píkone ne Saûlu enepo koyûho koeku Jesus ya Ndamásku. ");
INSERT INTO terNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yane kahá'inepoane Saûlu ne kutípotihiko Jesus koêkuti yónokuhiko ya Njeruzálem, koane ako píka Saûlu koyúhoyea koêku ne Vúnae. ");
INSERT INTO terNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Koyúhomaka koeku Jesus xapákuke ne jûdeuhiko koyúhoti emo'u ngerêku. Koati yumopâtihiko Saûlu. Yane opósikonehiko kixókumo koépekea Saûlu. ");
INSERT INTO terNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Eyekóxoane po'ínuhiko kutípoti Jesus ápeyea kaha'âti koépekea ne Saûlu, ómanehiko ya Sezâreya. Ikénepoke ina iyonópamaka ya Társu. ");
INSERT INTO terNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yoko ú'uhepe kóyehiko neko kutípoti Jesus ya uhá koeti Njúdeya, yoko Ngalíleya koánemaka ya Samâriya. Ákone okopâti. Tumúne yóno kóxuna'ixeovohiko ikéneke Vúnae koane ukóponea itúkeovohiko teyoti Itukó'oviti, vo'oku huvó'oxea Sasá'iti Omíxone Itukó'oviti, koane kurí'uxeovomaka yé'akeye ne kutípoti Jesus xapákuke. ");
INSERT INTO terNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kene Pêturu, ako tôpi pitivóko vékoku. Po'íke káxe, vekóponoamaka xapákuke ne kasása'iupo Jesus ya pitivóko koéhati Lîda. ");
INSERT INTO terNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Énomone tokópea hóyeno koéhati Éneya. Enepone hóyeno, oitu koene xoénae óvoheixo ípeke, vo'oku itúkeovo isayú'ixovoti mûyo ákoti ehevákapu. ");
INSERT INTO terNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ina kixôa Pêturu: —Eneyá, yexépukapa; koítovopine Jesus Kristu. Keúnakapa ne peúke —kíxoane. Énomone yaneko ókoku ôra, xépu koépone Éneya. ");
INSERT INTO terNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Noíxoa uhá koeti ko'óvokuti ya Lîda yoko Sârona neko koítovone Pêturu, koane enó'iyea hokópoti Vúnae Jesus vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ya pítivokona Njópi, ápe sêno kutípoti Jesus. Tabíta koéha. Enepora ihâe, enepo sa'irí'okopovo ya emó'uke ngerêku, Ndórka koêti. Enepone sêno, é'exo kíxoixokono vo'oku únati kixoku itúkeovo, koane vo'oku ixómoyea huvó'oxo xâne ákoti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yaneko káxehiko, ká'arinene neko sêno. Ehane ivókovo. Ahíkopokonone ne mûyo, ina omopókono ya kúveu ovokúti sôparatuke. ");
INSERT INTO terNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yoko enepone pi'âti pitivóko, Lîda yoko Njópi, ako ahíkaka. Eyekóxoane kutípotihiko Jesus ápeyea ne Pêturu ya Lîda, pahúkohiko pi'âti hóyeno xokóyoke épemoponea xanépea ya Njópi hú koêti. ");
INSERT INTO terNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Koáne, xanépoanehiko Pêturu. Simoné'e, ina omâhiko sôparatuke xoko imópokonoku muyo Ndórka. Heú koéhiko neko sêno ivokóvoti îma ayákukuyea Pêturu koane íyokexea, exókoatihiko ne hîxo yoko po'i ípovo úhe'oenoahiko Ndórka koeku ápeyeako. ");
INSERT INTO terNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ina pahukôa Pêturu ipúhihikopea meúkeke heú koêti neko xanéhiko. Yane ipuyuké koéne épemea Itukó'oviti xaneâti inonéxinova ne ivokóvoti koane kó'iyea: —Tabitá, yexépukapa! —koéne. Ina mihe'óko ûke neko sêno. Yane noíxone Pêturu, ina ivatákopo ípeke. ");
INSERT INTO terNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yane namúkea vô'u Pêturu huvo'óxoati exépukopea, ina ihaxíhikoa Pêturu ne senóhiko ivokóvoti îma koánemaka ne po'ínuhiko kasása'iupo Jesus. “Harâ'apo” kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yoko eyékoxokono neko koekúti ya uhá koeti Njópi. Êno kutípoti Vúnae vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Êno káxe óvoheixea Pêturu ya Njópi óvokuke eyoti vakamóto, hóyeno koéhati Símaum. ");
INSERT INTO terNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ápe hóyeno ko'óvokuti ya Sezâreya koéhati Kôrneliu. Itáleanu itukóvoye neko hóyeno. Yoko pahúkoti póhuti séndu húndaru itúkovo, ainóvoti ítuke iháxakoku húndaru iháxoneti “Itáleanu”. ");
INSERT INTO terNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Koati teyoti Itukó'oviti neko hóyeno, koane yuixóvoti itúkea ponóvoti nonékuke. Kúteanemaka koêku ne uhá koêti ya óvokuke. Enómaka huvó'oxea ne ákoti apeínoati, koane kóyekunemaka itúkea orásaum. ");
INSERT INTO terNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Po'i káxe ya kuteâti mopo'âti ôra ya kiyakáxe, ápe éxokoake Itukó'oviti ne Kôrneliu ya kutí koeti hopúne, itea ako imáka, iyukovó koyêti. Noixo ánju, ovoxe Itukó'oviti ukeâti vanúke, ahi'ókovati. ");
INSERT INTO terNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","—Korneliú —kíxoane ánju. Pono-ponó kixínoane ûke Kôrneliu koane yupíheovo píkea. —Kutíya unaém? —kíxoane. Ina kixôa ánju: —Ako inátapa okóvo Itukó'oviti ne kixeku itíki orásaum, koánemaka ne kixeku ixómoyea huvó'oxo xâne ákoti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kó'oyene, pehuka yovóxe ya Njópi iháxikoponea hóyeno koéhati Símaum, yonópoti îha Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hane óko óvokuke po'ímaka koéhati Símaum, hóyeno eyoti vakamóto. Xe'ókuke mar óvo neko óvoku —kíxoane ánju. ");
INSERT INTO terNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ehá'axo pihópo ne ánju, iháxikone pi'âti ahínoe ne Kôrneliu. Ina apémaka po'i húndaru iháxiu. Eneponê'e, koati huvo'óxoati ya óvokuke koane teyotímaka Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ina koyuhó'inoahiko Kôrneliu uhá koêti neko yuhó'inoa ánju. Yane pahúkoanehiko ya Njópi. ");
INSERT INTO terNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yaneko po'ípone káxe ya koeku vékea xêne yonoti Njópi neko páhoehiko Kôrneliu, koane yé'exea neko pitivóko, énomone yaneko ôra, pihóne ne Pêturu omómikokutike oúke péti itukóponoti orásaum. Yoko itumúkotine káxe yanekôyo. ");
INSERT INTO terNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Koati epékoatine hímakati ne Pêturu, itea koêkuiko ixómoyea koúsokinokonoa ne nîka, apé koéne éxokoake Itukó'oviti ya kutí koeti hopúne itea ako imáka, iyukovó koyêti. ");
INSERT INTO terNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Hara noíxo vanúke imihé'okinoati. Yane ápene kutí koeti hána'iti ramápu'i ípe ika'oké kíxeokono koaturu koeti kêno koévesekeokono ukeâti vanúke. ");
INSERT INTO terNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kúveuke, ápe hó'openo, heú koeti kó'iyeovoku apêti koaturu koeti hêve, koánemaka ne há koeti poké'eke yoneâti hûra, yókomaka hó'openo ôti. ");
INSERT INTO terNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ina apê emo'úti kámone Pêturu. Hara kôe: —Yexépuka Peturú. Képeka koêkuti yarâ'a ínamo nikêa —koéne. ");
INSERT INTO terNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Itea hara kixópa Pêturu: —Ako kalíhuina Unaém, vo'oku ako níngeaku kuteâtihiko râ'a ákoti asasá'i nenékuke, ákotimaka parexâ hó'e ûti níkeokono —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ina apépomaka emo'úti kixoti Pêturu: —Enepora kasása'iupo Itukó'oviti, hako keyuhôa itúkeovo ákoti asasá'i —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mopó'a koéneye, ina omopókono vanúkeke neko kutí koeti ramápu'i ípe. ");
INSERT INTO terNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kene ne hóyenohiko páhoe Kôrneliu, épemonehiko óvoku Símaum. Koeku ixómoyea itúkinoa isóneu Pêturu kixó'ekone neko koekúti éxokoake Itukó'oviti, xe'okó kóyene neko pahoéti pahapétike. ");
INSERT INTO terNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ina ihaxíkohiko ko'óvokuti, epemoâtihiko ápeyea hóyeno koéhati Símaum, yonópoti îha Pêturu okoâtiya. ");
INSERT INTO terNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Yoko ya koêkuiko ixómoyea itúkinoa isóneu Pêturu kixó'ekone neko noíxone éxokoake Itukó'oviti, hara kíxoa Sasá'iti Omíxone Itukó'oviti: —Simóne pi'âti hóyeno oposíkopiti. ");
INSERT INTO terNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yexépuka, yevésekina ínamo yaxenápoa. Hako poe'aînoa iséneu vo'oku undíne pahukoâhiko yâkeneye —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yane evésekinoanehiko Pêturu koane kíxeahiko: —Undíne ne yopósiupono. Na koeti simínenoe? ");
INSERT INTO terNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ina yumopâhiko: —Uti páhoe hóyeno koéhati Kôrneliu, kali payásoti húndaru. Enepone hóyeno, koati ponóvoti ítuke koane teyotímaka Itukó'oviti. Ínixoa heú koeti jûdeu itúkeovo itípakovoti. Ápe ánju íhae vanúke, sasá'iti ovoxe Itukó'oviti pahukoâti iháxikeopi óvokuke motovâti kámokenoyea yemó'u —kíxoanehiko páhoe Kôrneliu. ");
INSERT INTO terNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yane ítaikoane Pêturu neko hóyenohiko ûrukeovo ovokútike koane imókeakone yaneko yóti. Yuponíne, koúnakovone ne Pêturu ina xanepoâhiko. Ápemaka po'ínuhiko kutípoti Jesus íhae Njópi xaneâti. ");
INSERT INTO terNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yaneko po'ípone káxe, simónehiko ya Sezâreya. Yoko ho'úxoanehiko Kôrneliu ne iyénoxapa yoko po'i húpiu, enepohikone koati ínikone, kuxotínehiko Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ehá'axo mani ûrukovo ne Pêturu, îtokopovane Kôrneliu koane ipuyuké kó'iyeane nonékuke kutí kixoâti Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Itea pahúkoa Pêturu exépukopea. Hara kíxoa: —Undímaka xâne kuteátine îti. Yexépukapa! —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Koeku yúho'ixea Pêturu, koánemaka ûrukeovo ovokútike. Tokononé koene êno xanéya ho'uxoké koyêti kuxoíxoati. ");
INSERT INTO terNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ina kixovókoxoa Pêturu: —Yéxoanoe indúkeovo jûdeu koane ákoyea sikákana jûdeu ánavokoxeovo xâne ákoti itukapu jûdeu. Muhíkova vahí'okeova, ako paréxakana ûti. Itea éxokonoa Itukó'oviti ákoyea omótova ngíxeaneye koêkuti xâne. Ako yusíka kutí ngíxea ákoti asasá'i koane ákoyea aínavangaxapa. ");
INSERT INTO terNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Énomone ákoino mitatahí ángoe enepo pehûko ihaxíkopononuti. Kó'oyene yéta'akanu ihéxikinonuke —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ina kixôa Kôrneliu: —Mopó'apoane káxe ikéne, yunzó'ixoti Itukó'oviti óvonguke koené'ekene ya mopo'âti ôra ya kiyakáxe, orana vitúkope orásaum. Yane apé kó'inonune kutí koeti hóyeno koati ú'uha koyêti ípovo. ");
INSERT INTO terNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ina kixônu: “Korneliú, kámoa Itukó'oviti ne yorásauna. Ako inátapa okóvo ne kíxeaku hivó'oxi ne xâne ákoti apeínoati. ");
INSERT INTO terNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kó'oyene pehuka yonoti Njópi iháxikoponea hóyeno koéhati Símaum yonópoti îha Pêturu. Xoko po'ímaka hóyeno koéhati Símaum óko, hóyeno eyoti vakamóto. Xe'o mar óvo neko óvoku” kixónune. ");
INSERT INTO terNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yane ákone ingá'akarixa mbahúkea ihaxíkoponopiti. Aínapo yákoe kino'óko. Kó'oyene ho'uxoké kóye ûti ya nonékuke Itukó'oviti. Usokó kóye kámokenoyea ûti uhá koêti ne páhoenopi Vúnae keyúhoinovea —kíxoane Kôrneliu. ");
INSERT INTO terNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ina kixovókoxoa Pêturu: —Kó'oyene énjoaneoxo ákoyea naívakaxa xâne ne Itukó'oviti. Kutíkokone uhá koeti xâne nonékuke. ");
INSERT INTO terNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Epó'oxo ya koêkuti poké'e óvohikoku xâne yara kúveu mêum, úhepeti isóneunoa Itukó'oviti ne xâne teyoâti koane ponoâtimaka ne kixoku itúkeovo. ");
INSERT INTO terNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yéxoanoe koêku ne ihíkauvoti páhoe Itukó'oviti xapa íhae Izarâe, enepone inámati ihíkauvoti omínoti xâne unako koêku ikéneke Itukó'oviti ya xoko Jesus Kristu, Únae uhá koeti xâne. ");
INSERT INTO terNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yéxoanoe herumó kó'iyeane Njúdeya ra ihíkauvoti turixeôvoti ya Ngalíleya, ikénepoke kaxena Xuaum Mbátita koyúhoyea xapa xâne koane áhikexea iháke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Énomone ne ihíkauvoti koyúhoti koeku Jesus íhae Nazâre, enepone poréxoake Itukó'oviti hána'iti xunáko koáne yupíheovo xuná'iyea ne Sasá'iti Omíxone xokóyoke. Ako tôpi vékoku ne Jesus itúkoti únati vo'oku ápeyea Itukó'oviti xokóyoke. Koítovomaka kixeóvovoti xâne íkoitoponone kotíveti Ndeâpu. ");
INSERT INTO terNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Noínjoa ungékuke, koane noíxoamaka nza'ínehiko uhá koêti neko ítuke Jesus ya Njeruzálem, koánemaka ya uhá koeti poké'exa ûti, uti jûdeu. Énomonemaka koepékokono, ikokókonoti kuruhúke. ");
INSERT INTO terNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Itea koéxepukopa Itukó'oviti koukópeati xapa ivokóvoti ya mopó'apeke káxe ike ivókinevo. Poréxoamaka Itukó'oviti noíxopeokono ikéneke exépukopine. ");
INSERT INTO terNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Haina uhá koeti xâne noixópati, vo'oku tumúneke ápepe ne koekúti, ápe xâne noívokoe Itukó'oviti noíxopeamo. Énomone ûndi yoko nza'ínehiko, uti kaha'íneati ne Jesus xe'o mêsa óvoku nikokónoti yoko ekâti ikénepoke exépukopine ukópea xapa ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ina pahukó'ovimaka koyúhoyea uti emó'u xapa xâne, koane véxokea xanéhiko itúkeovo énomone noívokoxo ne Itukó'oviti éxokopeamo yonópoku uhá koeti xâne, kúteane xâne iyukóvotiko koánemaka ne ivokóvotine. ");
INSERT INTO terNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Énomonemaka koyúho ne heú koeti porófeta, enepohikone koyúhoti emo'u Itukó'oviti mekúke, exókoviti itúkeovo ya iháke Jesus kotúyopeovomo pahúnevo ne póhutihiko koxé'u xâne kutipoâti —kíxovokoxoane Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ixómoiko koyûho ne Pêturu, evésekone ne Sasá'iti Omíxone Itukó'oviti xokóyoke uhá koêti neko kamokénoti emo'u Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Enepohikoneko jûdeu kutípoti Jesus xánena Pêturu, yupíhova iyúpaxeovo vo'oku ikó'iparaxeokonoanemaka xâne ákoti itukapu jûdeu ne Sasá'iti Omíxone Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kámea evo jûdeu ne yûho enepo koyûho po'ínuhiko yuhôti ákoti itukapu éxone koane iháyu'ikea Itukó'oviti. Ina kôe ne Pêturu: ");
INSERT INTO terNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Ápeikopo motovâti itópea áhikeovo râ'a ya iháke Jesus? Vo'oku aínovonehiko namúkotine Sasá'iti Omíxone Itukó'oviti kuteâti koêku yanekôyoke inâ namukôa ûti, uti jûdeu. ");
INSERT INTO terNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yane pahúkoane Pêturu áhikeovohiko ya iháke Jesus Kristu. Ina itaíko Pêturu neko xanéhiko âvoyea pihápa, kaha'aînoatihiko óveako xapákuke kali ye'á koetí'iye káxe. ");
INSERT INTO terNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ehane eyékoxoa ápostuluhiko yoko po'ínuhiko kutípoti Jesus ya uhá koeti Njúdeya kutípeanemaka emo'u Itukó'oviti ne po'ínuhiko xâne ákoti itukapu jûdeu. ");
INSERT INTO terNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Itea seopóne Pêturu ya Njeruzálem, poé'ainoa isóneu po'ínuhiko jûdeu hokoti Jesus, inixoâti ákoyea yusíka aínavokoxeovo xâne ákoti sirkunsidá akôe. Hara kixóhiko Pêturu: ");
INSERT INTO terNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—Imáko kêku yûrukoponivo óvokuke xanéhiko ákoti sirkunsidá akôe, keha'íneatimaka níki! —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yane heú kíxoa kayúmakopinoa Pêturu kixoku koêku. Hara kíxovokoxoa: ");
INSERT INTO terNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ixómoti indûko orásaum yanekôyoke ya pítivokona Njópi, apé kôe éxokonuke Itukó'oviti ya kutí koeti njopúne, itea iyukovó ngoyêti. Noinjo koekúti kutí koeti hána'iti ramápu'i ípe ika'oké kixeókonoti koaturu koeti kêno evesékinonuti ukeâti vanúke. Ako ahíkapananu ókoku. ");
INSERT INTO terNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ina ngomomâ'axo kúveuke. Yane noínjone hó'openoya. Ápe apêti koaturu koeti hêve, yoko ipúhokovoti, yoko há koeti poké'eke yoneâti hûra, koánemaka hó'openo ôti. ");
INSERT INTO terNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yane ngamone emo'úti kixónuti: “Yexépuka Peturú. Képeka koêkuti yarâ'a, ínamo nikêa” kixónune. ");
INSERT INTO terNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ina ngixôa: “Ako kalíhuina Unaém, vo'oku ako níngeaku kuteâtihiko râ'a, koekúti ákoti asasá'i nenékuke, ákotimaka parexâ hó'e ûti níkeokono” ngíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ina apépomaka ne emo'úti inu'íxoti vanúkeke kixónuti: “Enepora kasása'iupo Itukó'oviti, hako keyuhôa itúkeovo ákoti asasá'i” kixónune. Yoko pí'apene yanê'e. ");
INSERT INTO terNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mopó'a koéneye ina omopókono uhá koêti vanúkeke. ");
INSERT INTO terNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","—Énomone yaneko ókoku ôra, simóne mopo'âti hóyeno pahoéti ukeâti Sezâreya oposíkopononuti yaneko ovokúti óngoku. ");
INSERT INTO terNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ina exókonoa Sasá'iti Omíxone Itukó'oviti ngónokea njanépeahiko ákoti opoé'ainoa inzóneu. Enepora sei koeti po'inu ûti xoko Jesus apêti njokóyoke kó'oyene, aínovone njánenamaka. Heú koe ûti vûrukeova óvokuke ne Kôrneliu. ");
INSERT INTO terNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yane koyúhoinovine noíxea ánju, ovoxe Itukó'oviti ukeâti vanúke, xe'ó koyêti nonékuke ya óvokuke. Hara kíxoa ánju: “Itika péhoe ya Njópi ihaxíkoponoti hóyeno koéhati Símaum, yonópoti îha Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Énomonemo koyuhó'inopi kixeku ítivoamo ne pehúnevo, koánemaka uhá koêti ne íhae yóvokuke” kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ndurixóvone ngoyúhoinoahiko, evésekone ne Sasá'iti Omíxone Itukó'oviti oúkekehiko kuteâti koeku inúxotike xoko ûti, uti jûdeu. ");
INSERT INTO terNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yane puyákoponovane ongóvo neko yuho Vúnae yaneko kixo'óvi: “Kaná'uti itúkeovo úne áhikea xanéhiko ne Xuâum, itea yahíkokonotinoemo, haînati ya úne, itea ya xunákoke Sasá'iti Omíxone Itukó'oviti” kixó'ovi. ");
INSERT INTO terNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Koeku kíxeaneye Itukó'oviti ne ákoti itukapu jûdeu, iko'íparaxoatimaka kuteâti poréxovike koeku kutípea ûti ne Vúnae Jesus, yusíkoikopo poé'ainoa inzóneu? Eneponi angoéneye, mani ongópoti Itukó'oviti —kíxovokoxoane. ");
INSERT INTO terNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kamoánehiko neko yuho Pêturu, úhepeponehiko isóneu koane iháyu'ikeahiko Itukó'oviti. Hara koéhiko: —Poréxoamaka Itukó'oviti ne ákoti itukapu jûdeu ikótivexea isóneuke ne pahúnevo koane kuríkopea, kutí'inoke apeínoatihiko ne inámapoti apéyeati ákotinemo hunókoku xoko Itukó'oviti —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ako tôpi itóhineheoku neko kutípotihiko Jesus vo'oku ápeyea ikoítoponoati kotíveti ikénepoke koépekeokono ne Etévaum. Ápe yonoti tukú koeti Fenísea, Xípere yoko Antiokíya. Koêkuti vékokuhiko, koane koyúhoyea emo'u Itukó'oviti. Itea poéhane jûdeuhiko koyúhoinoa. ");
INSERT INTO terNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kene po'ínuhiko íhae Xípere yoko Sîreni, hane yóno Antiokíya, koyuhoâtimaka xapákuke xâne ákoti itukapu jûdeu ne inámati ihíkauvoti omínovike Vúnae Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yoko êno xunako Vúnae xokóyokehiko kutí'inoke ênoti xâne kutipoâti ne ihíkauvoti koane hokópoti Vúnae. ");
INSERT INTO terNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Enepohikone hokópoti Jesus ho'uxínovoti ítuke Vúnae ya Njeruzálem, eyékoxoane neko koekúti. Yane pahúkohiko Mbaranâbe ya Antiokíya. ");
INSERT INTO terNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Simoné'e ne Mbaranâbeya, yupihovó koe elókeyea okóvo, noixoâti ne seánako Itukó'oviti oúkekehiko neko xâne, koane enékeahikomaka uhá koêti neko xâne kónokea kóxuna'ixeovo ikéneke Vúnae koane ákoyea aúkapapu ikéne. ");
INSERT INTO terNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Yoko koati únati xâne ne Mbaranâbe, koane xúnati ne Sasá'iti Omíxone Itukó'oviti xokóyoke, yoko hána'itimaka kúveovo Itukó'oviti. Koati ênoti xâne hokópoti Vúnae yanekôyoke. ");
INSERT INTO terNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yane pihóne Mbaranâbe ya pitivóko iháxoneti Társu oposíkoponoti Saûlu. ");
INSERT INTO terNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Inixóponoane, ina omâ ya Antiokíya. Kúveu póhuti xoénae, kóyekune ho'úxeovohiko yane imokóvokuti, koane yupíhova êno xâne íhikau. Koati ya Antiokíya turíxeovo íhaxeokono hokoti Kristu neko kutípotihiko Jesus. ");
INSERT INTO terNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Yaneko káxehiko, ápehiko porófeta íhae Njeruzálem yonoti Antiokíya. ");
INSERT INTO terNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ápe koéhati Âgabu xapákuke exepúkoti koyúhoyea ya xunákoke Sasá'iti Omíxone Itukó'oviti ápeyeamo êno hímakati ya uhá koeti kúveu mêum. Yoko kaxénake Kalaûtiu, enepone koati payásoti nâti, ápeyea nê'e. ");
INSERT INTO terNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Enepohikoneko kutípoti Jesus ya Antiokíya, koúsokonehiko isóneu pahúkeamo kali huvó'oxeakehiko neko kutípoti Jesus ya Njúdeya. Yé'akeye apeínoati exôa pôreu póhutihiko. ");
INSERT INTO terNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Yane pahúkoane ne huvó'oxopehiko xoko Mbaranâbe yoko Saûlu omínoahiko xapákuke neko inuxínotihiko ítuke Itukó'oviti ya po'íke imokóvokutihiko. ");
INSERT INTO terNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Yaneko káxehiko pahúkoa Êrodi, enepone nâti, iká'akeokono ne po'ínuhiko kutípoti Jesus. Koati kaha'âti íkoitoponeahiko kotíveti. ");
INSERT INTO terNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pahúkonemaka koépekeokono Teâku, po'inu Xuâum, ya hána'iti pirítau. ");
INSERT INTO terNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Noixoâne Êrodi ínixea jûdeuhiko unátiyea ne ítuke, pahúkonemaka ika'ákoti Pêturu ya xapa kaxena áyui jûdeuhiko hó'eke, enepo nikohíko pâum ákoti kohiyákoati. ");
INSERT INTO terNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Namukónehiko Pêturu, ina kurikôa ika'ákovokutike xoko dizései koeti húndaru koyonoâti. Koaturú koaturu kôe koyonoâti, koane ahe'ó ahe'o kixókoko. Yoko isóneu ne Êrodi ómeani Pêturu nonékuke xanéhiko ikénepoke ne ayuíti, enepone iháxoneti Páskoa, motovâti koépekea. ");
INSERT INTO terNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Koeku óvoheixea ika'ákovokutike ne Pêturu, ákonehiko âka itúkinoa orásaum po'ínuhiko kutípoti Jesus ixómoti ho'uxínovo ítuke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yaneko yóti, koâti tumúneke ne káxe mani iháxikeaku Êrodi ne Pêturu nonékuke xanéhiko koépekeokono, ú'uhepe kóye imókea ne Pêturu upánini ika'ó kóye ya pi'âti korénde kukúkeke pi'âti húndaru. Ina apé'ikomaka po'i koyonoâti páhapeteake ne ika'ákovokuti. ");
INSERT INTO terNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Yane apé koéne ánju íhae vanúke, ovoxe Vúnae, simoâti ne Pêturu. Uhapu'í kíxoane neko ika'ákovokuti. Ina yurôko xêrere Pêturu koyúkoati. Hara kíxoa: —Yéhakapu yexépuki —kíxoane. Énomone yanê'e, ikúxeopone neko korénde ikávo'u. ");
INSERT INTO terNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ina kixoá'ikomaka ánju: —Keúnakapapu, itíkapa ne piríkatana —kíxoane. Koáne, itúkopane Pêturu. Ina kixopâmaka ánju: —Itíkapamaka keápana ínamo hekapánu —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Yane ipúhikopeane ika'ákovokuti ne Pêturu. Hokó kixópone ánju, itea ako koati éxea itúkeovoxo kaná'uti neko koêku, áko'o áko'oyea. Kutí kó'inoa hopúne. ");
INSERT INTO terNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Anu'úkopanehiko neko inúxoti ókoku koyónoti, koáne ne pí'ape, ina itopónoa ne pahapéti havâva urúkopovoti kúveu pitivóko. Seopâne, imíhe'okone ne pahapéti ákoti mihe'ókoati. Ipuhíkopeanehiko, vekópone ya none ovokúti. Kali tumûneke, pohú koépone ne Pêturu, pihópone ne ánju. ");
INSERT INTO terNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ina kôe isóneu ne Pêturu noixoâne itúkeovo kaná'uti neko koêku: “Énjoane itúkeovo kaná'uti pahúkinonu Vúnae ánjuna koíteovonu ya mani kixónuku Êrodi yoko ya mani uhá koeti kúxone jûdeuhiko kíxeonu” koéne isóneu. ");
INSERT INTO terNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ina itûko isóneu ne Pêturu kixóvokumo, yane pihóne óvokuke Mâriya, eno Xuâum. Énomone neko Xuâum yonópoti îha Márku. Énomone ho'úxovo êno xâne itukínoati orásaum. ");
INSERT INTO terNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Simoné'e ne Pêturu pahapétike nonékuke ovokúti, ina ihapápako vô'u. Yane ipúhiko ovoxéti koéhati Rôdi noixóponoati itukóvotiye. ");
INSERT INTO terNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Exó kixóponoa ârunoe itúkeovo emo'u Pêturu, itea ya koêkuni míhe'okinoa pahapéti motovâti ûrukeovo, kayú koépone ehákopeovo éto'okoponea po'ínuhiko itúkeovo Pêturu. Koati yupihóvotine elókeyea okóvo neko ârunoe. ");
INSERT INTO terNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ina kixoáhiko éto'oe: —Koati iti pepokéxovoti! —kíxoanehiko. Itea inamá'axo koyuhôa ârunoe itúkeovo kaná'uti. Ina kixopâhikomaka: —Ávaina koípihapatina Pêturu nê'e —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kene Pêturu, óvaikone meúkeke ixómoyea ihápapako vô'u. Ehane míhe'okinoahiko. Noixoânehiko itúkeovo koati Pêturu, hána'iti iyúpaxeovahiko. ");
INSERT INTO terNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ina koexépuko vô'u ne Pêturu pahukoâti kóyunuhikeovo. Yane kayúmakopinoanehiko kíxoaku Vúnae veyópea ya ika'ákovokutike. Ina koemáka hunókokuke: —Yokóyuhopinoamaka Teâku yoko po'ínuhiko ûti xoko Jesus —koéne. Yane pihópone po'íke ovokúti. ");
INSERT INTO terNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yuponíne, koyó'ikene neko húndaruhiko. Akó'oti exêa koêku ne Pêturu. ");
INSERT INTO terNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pahukoâne Êrodi oposíkoponoati, ákone ínixapanahiko. Yane épemo'ikoane Êrodi ne húndaruhiko koyonoâti kixoku koêku, ina pahukôa Êrodi koépekeokonohiko. Ikénepoke neko koekúti, pîho ne Êrodi Sezâreyake ukeâti Njúdeya. Kali ye'á koe káxe óveaya. ");
INSERT INTO terNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Yanekôyoke koati imaíkinovati Êrodi ne xanéhiko íhae Tîru yoko íhae Sîdom. Enepohikone xâne íhae neko pitivókohiko, kutikokó koéne isóneu noíxoponea Êrodi, iyuní'ikoponoati, kaha'aînoati unátipea isóneunoahiko, vo'oku itúkeovo poké'exa Êrodi úkea nikáhiko ne íhae Tîru yoko Sîdom. Inúxotike, yúho'ixoponohiko koati payásoti ko'itúkeinoti nâti koéhati Mbalástu, enepone éxoti uhá koeti koekúti óvokuke Êrodi. Énomone porexôa ûrukeovohiko xoko nâti yúho'ixoponeahiko. ");
INSERT INTO terNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Yane ápe káxe ixíkoaku Êrodi símeahiko nonékuke. Yaneko káxe, itúkone koati uhé'ekoti ípovo ne Êrodi, iyóyonevo koeku itúkeovo nâti. Yane ivátakone xoko ivátakoku natíxea, ina koyûho. ");
INSERT INTO terNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ina kohonóko emó'u neko xanéhiko ihayú'ikoati. Hara kôe yûho iyúni'ikeakehiko: —Koati kuteâti yuho íhae vanúke râ'a. Hainá'ikopo yuho xâne! —koénehiko. ");
INSERT INTO terNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Énomone yaneko ókoku ôra, ápe ánjuna Vúnae ipihóponoti Êrodi vo'oku ínixea unáko neko iháyu'ikeokonoke. Yoko poéhane Itukó'oviti motokêa kíxeokononeye iháyu'ikeokono. Ápe kanêti nikeâti mûyo, ivókovane Êrodi vo'ókuke. ");
INSERT INTO terNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kene ne emo'u Itukó'oviti, inamá'axone ukopóno. ");
INSERT INTO terNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Enepone Mbaranâbe yoko Poûlu, uséxonehiko ítuke ya Njeruzálem, káyukopovohiko ya Antiokíya. Xuâum xanépo, enepone iháxonetimaka Márku. ");
INSERT INTO terNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ápehiko porófeta yoko ihíkaxoti ya xapákuke kutípoti Jesus yane imokóvokuti ya Antiokíya. Ká'aye koéhahiko: Mbaranâbe, Simeum Nîje, Lúsiu íhae Sîreni, Saûlu, yoko Manâem, enepone koéxokeu ha'a Êrodi, ha'ínemaka Êrodi itukóvoikohiko kalivôno. ");
INSERT INTO terNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Po'íke káxe koeku ho'úxinovohiko ítuke Vúnae, koane jejuá kó'iyeahiko oposíkoti xunako Itukó'oviti, hara kíxoahiko Sasá'iti Omíxone Itukó'oviti: —Hexákinana ne Mbaranâbe yoko Saûlu itúkeahiko ne itukéti inzáxikinoake —kíxoane. ");
INSERT INTO terNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Koêkuiko jejuá kó'iyeahiko yoko itúkea orásaum, ípihonehiko vô'u tutíkuke Mbaranâbe yoko Saûlu, koane pahúkeahiko itúkea ne páhoenoa Vúnae itúkea. ");
INSERT INTO terNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yaneko pahukoâne Sasá'iti Omíxone Itukó'oviti ne Mbaranâbe yoko Saûlu, pihónehiko ya pitivóko koéhati Seleúsiya. Énomone namúkea hána'iti vatéke yonoti kali poké'e koéhati Xípere kukúke úne. ");
INSERT INTO terNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Simoné'e ya pitivóko koéhati Salámina, koyúhonehiko emo'u Itukó'oviti ya sinâgoga, enepone íhikaxovoku hó'e jûdeuhiko. Yoko Xuaum Márku huvo'óxoahiko. ");
INSERT INTO terNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Taru'úxoanehiko heú koêti neko kali poké'e, yane simóne pitivóko koéhati Páfu. Énomone tokópeahiko jûdeu koixómoneti, itoti itúkea iyupánevoti, itea haináya xunákoke Itukó'oviti. Mbarjézu koéha. ");
INSERT INTO terNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hane óvo xoko hóyeno koéhati Sesiu Poûlu, ngovenâdo yaneko kali poké'e. Yoko koati hóyeno ko'isóneuti neko ngovenâdo. Iháxiko Mbaranâbe yoko Saûlu nê'e, vo'oku kahá'ayea kámokenoyea emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Itea okópa koixómoneti ne Mbaranâbe yoko Saûlu. Yoko Élima koéhamaka neko koixómoneti sa'irí'okopovo îha ya emó'uke ngerêku. Ako akáha'aino ngovenâdo kutípea emo'u Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yane pono-ponó kixínoane ûke Saûlu, enepone iháxonetimaka Poûlu. Yoko koati xúnati Sasá'iti Omíxone Itukó'oviti xokóyoke koeku sayá'ikea. Hara kíxoa: ");
INSERT INTO terNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—Koati iti xe'exa Ndeâpu. Ainovó koe semekénovo'iti yoko váhere koekúti ovô xikóyoke. Iti ka'anáneti uhá koeti únati koekúti. Namo hunóko képoe'aki ne ponóvoti ihíkauvoti íhikaxovike Vúnae? ");
INSERT INTO terNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kó'oyene ipihóponopitinemo Vúnae, kemítitinemo. Ákonemo ínixea ra uhápu'ine káxe yara ye'á koeti káxe —kíxoane Poûlu. Énomone yaneko ókoku ôra, apé koéne kopúvahiyea ûke neko hóyeno. Ehane ako ínixa. Yakukuhii kóyene oposíkoti hirikoâti. ");
INSERT INTO terNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Noixoâne ngovenâdo neko koekúti, kutípoaneoxo. Yupihovó koe iháyu'ikea ne ihíkauvoti ítuke Vúnae. ");
INSERT INTO terNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ukeâti Páfu, namúkone hána'iti vatéke ne Poûlu yoko xánenahiko. Hane yonóhiko pitivóko koéhati Pêrji ya Páfilea. Kene Xuaum Márku, káyukopovone ya Njeruzálem, kurí kixone evo Poûlu. ");
INSERT INTO terNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ukeánehiko Pêrji, pihónehiko ya Antiokíya, pitivóko ovoti Pîsiteake. Ya sâputu pihónehiko ya íhikaxovokuke hó'e jûdeuhiko. Urúkovanehiko, ina ivatáhiko. ");
INSERT INTO terNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Usoné'e yúhoikeokono ne emo'u Itukó'oviti yútoeke Muîse yoko yútoeke porófeta, ina epemôa tutíyehikoya ápeyea emó'u ne evo Poûlu. Hara kíxoa ítaikea: —Itínoe viyénoxapa íhae Izarâe, enepo áva yemó'u yenékike ra xanéhiko, yokóyuhoa kó'oyene —kíxoanehiko. ");
INSERT INTO terNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Yane exépukone Poûlu, ina koexépukinoa vô'u pahukoâti yunukú kó'iyea. Hara kíxovokoxoa: —Itínoe iyénonjapa íhae Izarâe, koane itínoe ákoti itukapu jûdeu teyotímaka Itukó'oviti, yakámokenonu. ");
INSERT INTO terNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Koati Itukó'oviti, Únae xanena ûti, uti íhae Izarâe, noivókoxo voxúnoekene. Énomonemaka porexôa yupíheovo ukóponeahiko yaneko óveaku poké'exake Ejítu, ina veyohíkopamaka ya hána'iti xunáko. ");
INSERT INTO terNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ako ímaxapahiko Itukó'oviti upánini ako aúnati ne kixoku itúkeovo kúveu koarenta koeti xoénae koeku óvea yaneko poké'e ákoti apêti. ");
INSERT INTO terNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Yoko uké'exinoa Itukó'oviti seti koeti kó'iyeovoku xâne ya poké'exa Kanâm, ina iko'íparaxea poké'exa ne voxúnoekene. ");
INSERT INTO terNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yoko uhá koêti neko vékokuhiko tukú koeti iko'íparaxoa neko poké'e, koaturu sentu sinkoenta koeti xoénae ómo. Ikénepoke, ina itukínoa Itukó'oviti neko voxúnoekene inuxínoatihiko, yúhoikovoku tukú koeti kaxénake porofeta Samûe, enepone koyúhoti emo'u Itukó'oviti mekúke. ");
INSERT INTO terNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Yane épemonehiko Itukó'oviti itúkinoa natína. Koáne, itúkinoa Itukó'oviti kuteâti âha. Poréxoa Sâu, xé'a Kî, ámoripono Mbejámi, itúkeovo natína kúveu koarenta koeti xoénae. ");
INSERT INTO terNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Veyopâne Itukó'oviti ne Sâu itúkeovo nâti, ípihone Ndávi. Yoko hara koe Itukó'oviti vo'ókuke: “Enepone Ndávi, xé'a Njése, íninjoa itúkeovo hóyeno hokoâti ne ngixoku ngo'ísoneuyea, itukoâtimo uhá koêti ne anjá'inoa” kôe. ");
INSERT INTO terNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Koati xapa amósenopono Ndávi úkea ne Jesus, enepone koitóvoviti, páhoe Itukó'oviti Izarâeke, kuteâti koeku yuho Itukó'oviti mekúke kó'iyeanemoye. ");
INSERT INTO terNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Itea inúxotike, tumúneke símea ne Jesus, sîmo Xuaum Mbátita koyuhó'inoati emo'u Itukó'oviti ne heú koeti xâne íhae Izarâe, koyúhoti kónokea ikótivexea isóneuke ne pahúnevo yoko kuríkopea, koane áhikeovo. ");
INSERT INTO terNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yoko yaneko koúsokeaku ítuke neko Xuâum, ha kôe: “Haina ûndi ne íkitixanuke. Keno'ókotimo ingénepoke ne koati teyonéti ya uhá koêti. Muhíkova anjí'okeova ngúxeinoa imo perékatana, ako omóndokea” kôe. ");
INSERT INTO terNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Itínoe iyénonjapa, ámoripono voxú'ikene Âbraum, yoko itínoe ákoti itukapu jûdeu teyotímaka Itukó'oviti, koati utíne koyúhoinokono ra ihíkauvoti koyúhoti koeku víteova ne pahúnevo ûti. ");
INSERT INTO terNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Itea enepohikoneko ko'óvokuti ya Njeruzálem yóko'o neko tutíhiko, ako éxa itukóvotiye ne Jesus. Ákomaka éxa nekôyohiko kixó'ekone ne íhikaxovike porófetahiko yuhoíkovoti heú koeti sâputu íhikaxovokuke hó'e. Yoko enepo koepékohiko Jesus, koati kousókoatihiko ne kúxoti yutoéti emó'uke Itukó'oviti. ");
INSERT INTO terNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Upánini ákoyea ápahuina pahúnevo ne Jesus mani évotikokonoke koépekeokono, kóyeane épemeahiko Pilátu pahúkea koepékoati. ");
INSERT INTO terNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Usoné'e ítukeinoahiko, yoko énomone neko uhá koeti yutoxóvotine emó'uke Itukó'oviti mekúke kixókonokumo Jesus, ina veyopókono ne muyo Jesus kuruhúke, ina ekoxókono. ");
INSERT INTO terNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Itea koéxepukopa Itukó'oviti koukópeati xapa ivokóvoti. ");
INSERT INTO terNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ápemaka xáneheixone Jesus yaneko ukêa Ngalíleya yóno Njeruzálem, ixómoti noixópa ike exépukopine kúveu ênoti káxe. Énomonemaka koyuhópo koeku noíxone xokóyoke xapa xanéhiko yara koeku kó'oyene —kíxovokoxoane Poûlu. ");
INSERT INTO terNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ina koepómaka: —Hara koyúhoinopinoe ûti inámati ihíkauvoti koeku Jesus, enepone kixínoake Itukó'oviti neko voxúnoekene mekúke ápeyeamo. ");
INSERT INTO terNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Koúsokinoveane Itukó'oviti ne emó'uinoa, uti ámoripono. Koéxepukopo Jesus koukópeati xapa ivokóvoti, kuteâtimaka koêku ne yutoéti yane pí'ape Sâramu, enepone koêti: “Iti koati nje'éxa. Kó'oyene indúkopovone yá'a” koêti. ");
INSERT INTO terNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","—Koéxepukopinoake Itukó'oviti koukópeati xapa ivokóvoti, koati porexoâti ákoyeanemo ivákapu, kuteâtimaka koeku po'i yuho Itukó'oviti ya emó'uke, enepone koêti: “Ngousókinopeatinoemo ra yunzó'ino Ndávi, enepone sasá'iti emó'um ákoti aukápapu ikéne” kôe. ");
INSERT INTO terNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Énomone kó'inomaka po'i yuhôti ya Sâramu koêti: “Ákomo síkea uké'eyeane mûyo ne Sasá'iti Yovóxe xoko ekóxokonoku” kôe. ");
INSERT INTO terNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36",