﻿USE sofia;
DROP TABLE IF EXISTS sofia.telotsa_vpl;
CREATE TABLE telotsa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES telotsa_vpl WRITE;
INSERT INTO telotsa_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ఆదిలో దేవుడు భూమిని ఆకాశాన్ని సృజించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","భూమి ఆకారం లేనిదిగా శూన్యంగా ఉంది; అగాధజలాల మీద చీకటి ఆవరించి ఉంది, దేవుని ఆత్మ నీళ్ల మీద అల్లాడుతూ ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","అప్పుడు దేవుడు, “వెలుగు కలుగును గాక” అని అనగా వెలుగు కలిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","దేవుడు ఆ వెలుగు బాగుందని చూసి, వెలుగును చీకటిని వేరుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","దేవుడు వెలుగుకు “పగలు” అని, చీకటికి “రాత్రి” అని పేరు పెట్టారు. సాయంకాలం గడిచి ఉదయం వచ్చింది. అది మొదటి రోజు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","దేవుడు, “ఆకాశ జలాలను భూ జలాలను వేరు చేయడానికి జలాల మధ్య విశాలం కలుగును గాక” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","అలాగే జరిగింది. దేవుడు విశాలాన్ని చేసి ఆ విశాలం క్రింది జలాలను విశాలం మీది జలాలను వేరుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","దేవుడు ఆ విశాలానికి “ఆకాశం” అని పేరు పెట్టారు. సాయంకాలం గడిచి ఉదయం వచ్చింది. అది రెండవ రోజు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","దేవుడు, “ఆకాశం క్రింద ఉన్న జలాలు ఒకే చోట సమకూడి ఆరిన నేల కనబడును గాక” అని అనగా అలాగే జరిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","దేవుడు ఆరిన నేలకు “భూమి” అని, ఒకే చోట సమకూడిన జలాలకు “సముద్రం” అని పేరు పెట్టారు. అది మంచిదని దేవుడు చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","అప్పుడు దేవుడు, “భూమి వృక్ష సంపదను అనగా విత్తనాలు ఉత్పత్తి చేసే మొక్కలు, వాటి వాటి జాతుల ప్రకారం విత్తనాలతో ఉన్న ఫలమిచ్చే చెట్లను భూమి మొలిపించును గాక” అని అన్నారు. అలాగే జరిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","భూమి వృక్ష సంపదను ఉత్పత్తి చేసింది అంటే, వాటి వాటి జాతుల ప్రకారం విత్తనాలు గల మొక్కలు, వాటి వాటి జాతుల ప్రకారం విత్తనాలతో ఉన్న ఫలమిచ్చే చెట్లు మొలిపించింది. అది మంచిదని దేవుడు చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","సాయంకాలం గడిచి ఉదయం రాగా అది మూడవ రోజు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","దేవుడు, “పగలు రాత్రులను వేరు చేయడానికి ఆకాశ విశాలంలో జ్యోతులుండాలి, అవి రుతువులను రోజులను సంవత్సరాలను సూచించే అసాధారణ గుర్తులుగా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ఆకాశ విశాలంలో భూమికి వెలుగునిచ్చే జ్యోతులుండును గాక” అని అన్నారు, అలాగే జరిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","దేవుడు పగటిని ఏలడానికి పెద్ద జ్యోతిని రాత్రిని ఏలడానికి చిన్న జ్యోతిని అలా రెండు గొప్ప జ్యోతులను అలాగే నక్షత్రాలను కూడా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","భూమికి వెలుగునివ్వడానికి, పగటిని రాత్రిని పాలించడానికి, చీకటిని వెలుగును వేరు చేయడానికి, దేవుడు వాటిని ఆకాశ విశాలంలో అమర్చారు. అది మంచిదని దేవుడు చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","సాయంకాలం గడిచి ఉదయం రాగా అది నాలుగవ రోజు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","దేవుడు, “నీటిలో జలజీవులు విస్తరించాలి, భూమిపై నుండి పక్షులు ఆకాశ విశాలంలో ఎగురును గాక” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","కాబట్టి దేవుడు సముద్రపు గొప్ప జీవులను, వాటి వాటి జాతుల ప్రకారం నీటిలో ఉండి నీటిలో తిరిగే ప్రతి జీవిని, వాటి వాటి జాతి ప్రకారం రెక్కలు గల పక్షులను సృష్టించారు. అది మంచిదని దేవుడు చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","దేవుడు, “ఫలించి, వృద్ధి చెంది, సముద్ర జలాల్లో నిండిపోవాలి, అలాగే భూమి మీద పక్షులు విస్తరించును గాక” అని వాటిని ఆశీర్వదించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","అలా సాయంకాలం గడిచి ఉదయం రాగా అది అయిదవ రోజు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","దేవుడు, “భూమి వాటి వాటి జాతి ప్రకారం జీవులను పుట్టించాలి అంటే, పశువులను, నేల మీద ప్రాకే జీవులను, అడవి మృగాలను, వాటి వాటి జాతుల ప్రకారం పుట్టించును గాక” అని అన్నారు, అలాగే జరిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","దేవుడు వాటి వాటి జాతుల ప్రకారం అడవి మృగాలను, వాటి వాటి జాతుల ప్రకారం పశువులను, వాటి వాటి జాతుల ప్రకారం నేల మీద ప్రాకే జీవులను చేశారు. అది మంచిదని దేవుడు చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","అప్పుడు దేవుడు, “మనం మన స్వరూపంలో, మన పోలికలో నరులను చేద్దాము. వారు సముద్రంలోని చేపలను, ఆకాశంలో ఎగిరే పక్షులను, పశువులను, అడవి మృగాలను భూమిపై ప్రాకే జీవులన్నిటిని ఏలుతారు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","కాబట్టి దేవుడు తన స్వరూపంలో నరులను సృజించారు, దేవుని స్వరూపంలో వారిని సృజించారు; వారిని పురుషునిగాను స్త్రీగాను సృజించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","దేవుడు వారితో, “మీరు ఫలించి, వృద్ధి చెంది, భూలోకమంతా విస్తరించి, దానిని లోబరుచుకోండి. సముద్రపు చేపలను, ఆకాశ పక్షులను, నేలపై ప్రాకే ప్రతి జీవిని ఏలండి” అని చెప్పి ఆశీర్వదించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","అప్పుడు దేవుడు, “భూమిపై విత్తనాలు ఇచ్చే ప్రతి మొక్కను, విత్తనాలు గల ఫలమిచ్చే ప్రతి చెట్టును మీకు ఆహారంగా ఇస్తున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","భూమిపై ఉన్న మృగాలన్నిటికి, ఆకాశ పక్షులన్నిటికి, నేలపై ప్రాకే జీవులన్నిటికి, జీవం ఉన్న ప్రతీ దానికి ప్రతి పచ్చని మొక్కను ఆహారంగా ఇస్తున్నాను” అని అన్నారు. అలాగే జరిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","దేవుడు తాను చేసిందంతా చూశారు. అది చాలా బాగుంది. సాయంకాలం గడిచి ఉదయం రాగా అది ఆరవరోజు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ఆ విధంగా ఆకాశం భూమి వాటిలో సమస్తం సంపూర్తి చేయబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ఏడవ రోజు నాటికి దేవుడు తాను చేస్తున్న పనంతా ముగించారు; కాబట్టి ఏడవ రోజున తన పని అంతటి నుండి విశ్రాంతి తీసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ఆ రోజున సృష్టి క్రియ అంతటి నుండి దేవుడు విశ్రాంతి తీసుకున్నారు కాబట్టి ఆయన ఆ రోజును దీవించి పరిశుద్ధపరిచారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","యెహోవా దేవుడు భూమిని సృజించినప్పుడు, భూమ్యాకాశాల సృష్టి జరిగిన విధానం ఇదే. ");
INSERT INTO telotsa_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","భూమి మీద ఏ పొద కనిపించలేదు, మొక్క మొలవలేదు, ఎందుకంటే యెహోవా దేవుడు భూమి మీద వాన కురిపించలేదు, భూమిని సేద్యం చేయడానికి నరులు లేరు, ");
INSERT INTO telotsa_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","అయితే భూమిలో నుండి నీటిబుగ్గలు వచ్చి అంతా పారుతూ నేలను తడిపేవి. ");
INSERT INTO telotsa_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","యెహోవా దేవుడు నేల మట్టితో మనుష్యుని చేసి, అతని నాసికారంధ్రాలలో జీవవాయువును ఊదగా నరుడు జీవి అయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","యెహోవా దేవుడు తూర్పు దిక్కున ఏదెనులో తోట నాటి, అందులో తాను రూపించిన నరుని ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","యెహోవా దేవుడు నేల నుండి కంటికి అందంగా కనిపించే ఆహారానికి సరియైన అన్ని రకాల చెట్లను మొలిపించారు. అలాగే ఆ తోట మధ్యలో జీవవృక్షం, మంచి చెడ్డల తెలివినిచ్చే జ్ఞాన వృక్షం ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ఏదెను నుండి ఒక నది పారుతూ తోటను తడిపేది; అది అక్కడినుండి నాలుగు పాయలుగా చీలిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ఈ నదులలో మొదటి దాని పేరు పీషోను; ఇది బంగారం ఉన్న హవీలా దేశం చుట్టూ పారుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ఆ దేశ బంగారం ఉండేది; సువాసనగల గుగ్గిలం లేతపచ్చ రాళ్లు కూడా అక్కడ ఉండేవి. ");
INSERT INTO telotsa_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","రెండవ నది పేరు గిహోను, అది కూషు దేశమంతటా పారుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","మూడవ నది పేరు టైగ్రీసు, అది అష్షూరు ప్రాంతానికి తూర్పున ప్రవహిస్తుంది. నాలుగవ నది యూఫ్రటీసు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ఏదెను తోటను సాగుచేయడానికి దానిని, జాగ్రత్తగా చూసుకోడానికి యెహోవా దేవుడు నరుని దానిలో ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","యెహోవా దేవుడు ఆ నరునితో, “ఈ తోటలోని చెట్ల పండ్లన్నీ నీవు తినవచ్చు; ");
INSERT INTO telotsa_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","కానీ మంచి చెడుల తెలివినిచ్చే వృక్ష ఫలం మాత్రం తినకూడదు. అది తిన్న రోజున నీవు తప్పక చస్తావు” అని ఆజ్ఞాపించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","యెహోవా దేవుడు, “నరుడు ఒంటరిగా ఉండడం మంచిది కాదు, అతనికి తగిన తోడును చేస్తాను” అని అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","యెహోవా దేవుడు నేల మట్టితో ప్రతి విధమైన అడవి జంతువులను, ఆకాశ పక్షులను చేసి, ఆ మనుష్యుని దగ్గరకు తెచ్చి వాటికి అతడు ఏ పేర్లు పెడతాడో అని చూశారు; అతడు ఒక్కొక్క జీవికి ఏ పేరైతే పెట్టాడో అదే ఆ జీవికి పేరు అయ్యింది. ");
INSERT INTO telotsa_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ఆ మనుష్యుడు పశువులన్నిటికి, ఆకాశపక్షులకు, అడవి జంతువులన్నిటికి పేర్లు పెట్టాడు. అయితే మనుష్యునికి తగిన తోడు దొరకలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","కాబట్టి యెహోవా దేవుడు ఆదాముకు గాఢనిద్ర కలిగించి, అతని ప్రక్కటెముకల్లో ఒకటి తీసి, ఆ స్థలాన్ని మాంసంతో పూడ్చి వేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","అప్పుడు యెహోవా దేవుడు మనుష్యుని నుండి తీసిన ప్రక్కటెముకతో స్త్రీని చేసి అతని దగ్గరకు తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","అప్పుడు ఆ మనుష్యుడు ఇలా అన్నాడు: “ఈమె నా ఎముకల్లో ఎముక, నా మాంసంలో మాంసం; ఈమె నరుని నుండి వచ్చింది కాబట్టి ఈమె ‘నారీ’ అని పిలువబడుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","అందుకే పురుషుడు తన తల్లిదండ్రులను విడిచిపెట్టి తన భార్యను హత్తుకుంటాడు, వారిద్దరు ఏకశరీరం అవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ఆదాము, అతని భార్య, ఇద్దరు నగ్నంగా ఉన్నారు, కానీ వారికి సిగ్గు అనిపించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","యెహోవా దేవుడు చేసిన అడవి జంతువులన్నిటిలో సర్పం చాలా యుక్తి కలది. సర్పం స్త్రీతో, “దేవుడు, ‘తోటలో ఉన్న ఏ చెట్టు పండ్లు తినకూడదు’ అని నిజంగా చెప్పారా?” అని అడిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","అందుకు స్త్రీ, “తోటలోని చెట్ల పండ్లు మేము తినవచ్చు ");
INSERT INTO telotsa_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","కాని, ‘తోట మధ్యలో చెట్టు పండు మాత్రం తినకూడదు, దానిని ముట్టుకోవద్దు, లేదంటే మీరు చస్తారు’ అని దేవుడు చెప్పారు” అని జవాబిచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","అప్పుడు సర్పం, “మీరు ఖచ్చితంగా చావరు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","మీరు అది తింటే మీ కళ్లు తెరవబడతాయని, మీరు దేవునిలా అవుతారని, మంచిచెడులు తెలుసుకుంటారని దేవునికి తెలుసు” అని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","స్త్రీ ఆ చెట్టు పండు తినడానికి మంచిది, చూడటానికి బాగుంది, తింటే జ్ఞానం వస్తుందని తలంచి, దానిలో కొంచెం తిని, తన భర్తకు కూడా ఇచ్చింది, అతడు కూడా తిన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","అప్పుడు వారి ఇద్దరి కళ్లు తెరవబడి తాము నగ్నంగా ఉన్నారని గ్రహించి, తమ శరీరాలను కప్పుకోడానికి అంజూర ఆకులు అల్లుకొన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","అప్పుడు ఆ రోజు చల్లని సమయంలో యెహోవా దేవుడు తోటలో నడుస్తున్న శబ్దం విని, ఆదాము అతని భార్య యెహోవా దేవునికి కనబడకూడదని తోట చెట్ల మధ్య దాక్కున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","అప్పుడు యెహోవా దేవుడు ఆదామును పిలిచి, “నీవెక్కడున్నావు?” అని అడిగారు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","అతడు, “తోటలో మీ శబ్దం విని, నేను దిగంబరిగా ఉన్నానని భయపడ్డాను; అందుకే నేను దాక్కున్నాను” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","అప్పుడు దేవుడు, “నీవు నగ్నంగా ఉన్నావని నీకెవరు చెప్పారు? తినకూడదని నేను మీకు ఆజ్ఞాపించిన ఆ చెట్టు నుండి పండు తిన్నావా?” అని అడిగారు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","అందుకు ఆదాము, “మీరు నాకిచ్చిన ఈ స్త్రీ ఆ చెట్టు పండును కొంచెం నాకిచ్చింది, నేను తిన్నాను” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","అప్పుడు యెహోవా దేవుడు స్త్రీని, “నీవు చేసిన ఈ పనేంటి?” అని అడిగారు. అందుకు ఆ స్త్రీ జవాబిస్తూ, “సర్పం మాటలకు మోసపోయి నేను తిన్నాను” అని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","అందుకు యెహోవా దేవుడు సర్పంతో, “నీవు ఇలా చేశావు కాబట్టి, “అన్ని రకాల పశువుల్లోను, అడవి జంతువులన్నిటిలోనూ నీవు శపించబడ్డావు! నీవు బ్రతుకు దినాలన్ని నీ పొట్టతో ప్రాకుతావు, మన్ను తింటావు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","నేను నీకు స్త్రీకి మధ్య, నీ సంతానానికి స్త్రీ సంతానానికి మధ్య శత్రుత్వం కలుగజేస్తాను; అతడు నీ తలను చితకగొడతాడు, నీవు అతని మడిమె మీద కాటేస్తావు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","తర్వాత దేవుడు స్త్రీతో ఇలా అన్నారు, “నీకు ప్రసవ వేదన అధికం చేస్తాను; తీవ్రమైన ప్రసవ వేదనతో పిల్లలను కంటావు. నీ వాంఛ నీ భర్త కోసం కలుగుతుంది, అతడు నిన్ను ఏలుతాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ఆదాముతో ఆయన ఇలా అన్నారు, “నీవు నీ భార్య మాట విని, ‘తినవద్దు’ అని నేను నీకు చెప్పిన ఆ చెట్టు పండును నీవు తిన్నావు కాబట్టి, “నిన్ను బట్టి ఈ నేల శపించబడింది; నీ జీవితకాలమంతా దాని పంట నుండి, కష్టపడి పని చేసి తింటావు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","భూమి నీకోసం ముళ్ళ కంపలను గచ్చపొదలను మొలిపిస్తుంది, నీవు పొలం లోని పంటను తింటావు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","నీవు మట్టి నుండి తీయబడ్డావు కాబట్టి నీవు మట్టికి చేరేవరకు, నీ నుదిటి మీద చెమట కార్చి నీ ఆహారాన్ని తింటావు నీవు మట్టివి కాబట్టి తిరిగి మన్నై పోతావు.” ");
INSERT INTO telotsa_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ఆదాము తన భార్యకు హవ్వ అని పేరు పెట్టాడు, ఎందుకంటే ఆమె జీవంగల వారందరికి తల్లి. ");
INSERT INTO telotsa_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","యెహోవా దేవుడు ఆదాముకు అతని భార్యకు జంతు చర్మంతో చేసిన వస్త్రాలను తొడిగించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","అప్పుడు యెహోవా దేవుడు, “మనుష్యుడు ఇప్పుడు మంచి చెడ్డలు తెలుసుకోగలిగి మనలాంటి వాడయ్యాడు, కాబట్టి అతడు తన చేయి చాపి జీవవృక్ష ఫలం కూడా తెంపుకొని తిని ఎప్పటికీ బ్రతికే ఉంటాడేమో, అలా జరగనివ్వకూడదు” అని అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","కాబట్టి యెహోవా దేవుడు అతన్ని ఏదెను తోట నుండి బయటకు వెళ్లగొట్టి అతడు ఏ మట్టి నుండి తీయబడ్డాడో, ఆ మట్టినే సాగు చేసుకునేలా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","దేవుడు ఆదామును బయటకు పంపివేసి జీవవృక్షం దగ్గరకు వెళ్లే మార్గాన్ని కాపాడడానికి ఏదెను తోటకు తూర్పున కెరూబును ఇటు అటు తిరుగుతున్న మండుతున్న ఖడ్గాన్ని కాపలా ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","అటు తర్వాత ఆదాము హవ్వను లైంగికంగా కలుసుకున్నప్పుడు ఆమె గర్భవతియై కయీనుకు జన్మనిచ్చింది. “యెహోవా సహాయంతో నేను కుమారున్ని సంపాదించుకున్నాను” అని ఆమె అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","తర్వాత అతని సహోదరుడైన హేబెలుకు జన్మనిచ్చింది. హేబెలు గొర్రెల కాపరి, కయీను వ్యవసాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","కోత సమయం వచ్చినప్పుడు కయీను పంటలో కొంత యెహోవాకు అర్పణగా తెచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","హేబెలు కూడా తన గొర్రెలలో మొదటి సంతానంగా పుట్టిన వాటిలో క్రొవ్విన వాటిని అర్పణగా తెచ్చాడు. యెహోవా హేబెలును అతని అర్పణను అంగీకరించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","కానీ కయీనును అతని అర్పణను ఆయన అంగీకరించలేదు. అందుకు కయీనుకు చాలా కోపం వచ్చి ముఖం మాడ్చుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","అప్పుడు యెహోవా కయీనుతో ఇలా అన్నారు, “నీవెందుకు కోపంతో ఉన్నావు? నీ ముఖం ఎందుకు చిన్నబుచ్చుకొన్నావు? ");
INSERT INTO telotsa_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","నీవు చేసేది మంచిదైతే నీవు అంగీకరించబడవా? నీవు సరియైనది చేయకపోతే, పాపం నీ వాకిట్లో పొంచుకొని ఉంది; అది నిన్ను పొందుకోవాలని వాంఛతో ఉంది, కానీ నీవు దానిని జయించాలి.” ");
INSERT INTO telotsa_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ఒక రోజు కయీను తన తమ్మున్ని పిలిచి, “మనం పొలానికి వెళ్దాం” అని అన్నాడు. వారు పొలంలో ఉన్నప్పుడు కయీను హేబెలు మీద దాడి చేసి అతన్ని చంపేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","అప్పుడు యెహోవా కయీనును, “నీ తమ్ముడు హేబెలు ఎక్కడున్నాడు?” అని అడిగారు. అందుకు అతడు, “ఏమో నాకు తెలియదు, నేనేమైన నా తమ్మునికి కావలివాడినా?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","అందుకు యెహోవా, “నీవేం చేశావు? విను, నీ తమ్ముని రక్తం నేల నుండి నాకు మొరపెడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ఇప్పుడు నీవు శపించబడ్డావు, నీ చేతి నుండి వచ్చిన నీ తమ్ముని రక్తాన్ని పీల్చుకున్న నేల నుండి నీవు తరిమివేయబడ్డావు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","నీవు భూమిలో ఎంత కృషి చేసినా, అది ఇకమీదట నీకు మంచి పంటను ఇవ్వదు. నీవు భూమిపై విశ్రాంతి లేని దేశదిమ్మరిగా ఉంటావు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","కయీను యెహోవాతో, “ఈ శిక్ష నేను భరించలేనంత కఠినమైనది. ");
INSERT INTO telotsa_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ఈ రోజు నన్ను ఈ ప్రాంతం నుండి వెళ్లగొట్టారు, మీ సన్నిధిలో నుండి దూరం చేశారు; నేను విశ్రాంతి లేని దేశదిమ్మరిని అవుతాను, నేను కంటపడితే నన్ను చంపేస్తారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","అయితే యెహోవా అతనితో, “అలా జరగదు; ఎవరైనా కయీనును చంపితే, వారు ఏడు రెట్లు ఎక్కువ శిక్ష అనుభవిస్తారు” అని అన్నారు. అప్పుడు యెహోవా కయీనును ఎవరూ చంపకుండ ఉండేలా కయీను మీద ఒక గుర్తు వేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","కయీను యెహోవా సన్నిధి నుండి వెళ్లి ఏదెనుకు తూర్పున ఉన్న నోదు దేశంలో నివసించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","కయీను తన భార్యను లైంగికంగా కలుసుకున్నప్పుడు ఆమె గర్భవతియై హనోకుకు జన్మనిచ్చింది. అప్పుడు కయీను ఒక పట్టణాన్ని నిర్మిస్తూ ఉన్నాడు, దానికి హనోకు అని తన కుమారుని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","హనోకుకు ఈరాదు పుట్టాడు, ఈరాదు మెహూయాయేలు తండ్రి, మెహూయాయేలు మెతూషాయేలుకు తండ్రి, మెతూషాయేలు లెమెకుకు తండ్రి. ");
INSERT INTO telotsa_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","లెమెకు ఇద్దరిని భార్యలుగా చేసుకున్నాడు, ఒకరు ఆదా ఇంకొకరు సిల్లా. ");
INSERT INTO telotsa_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ఆదా యాబాలుకు జన్మనిచ్చింది; అతడు గుడారాల్లో నివసిస్తూ పశువులను పెంచేవారికి మూలపురుషుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","అతని తమ్ముని పేరు యూబాలు, అతడు తంతి వాయిద్యాలు వాయించే వారికి మూలపురుషుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","సిల్లా కూడా ఒక కుమారునికి జన్మనిచ్చింది, అతని పేరు తూబల్-కయీను, అతడు అన్ని రకాల ఇత్తడి ఇనుప పనిముట్లు తయారుచేయడంలో నిపుణుడు. తూబల్-కయీను యొక్క సోదరి నయమా. ");
INSERT INTO telotsa_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ఒక రోజు లెమెకు తన భార్యలతో, “ఆదా, సిల్లా నా మాట ఆలకించండి; లెమెకు భార్యలారా, నా పలుకులు వినండి. నాకు గాయం చేసినందుకు ఒక మనుష్యుని, నన్ను గాయపరిచినందుకు ఒక యువకుడిని చంపాను. ");
INSERT INTO telotsa_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","కయీనును చంపితే ఏడు రెట్లు శిక్ష పడితే, లెమెకును చంపితే డెబ్బై ఏడు రెట్లు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ఆదాము తన భార్యను మరోసారి లైంగికంగా కలుసుకున్నప్పుడు, ఆమె ఒక కుమారునికి జన్మనిచ్చి, “దేవుడు, కయీను చంపిన నా కుమారుడు హేబెలుకు బదులుగా మరొక శిశువునిచ్చారు” అని అతనికి షేతు అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","షేతుకు కూడా ఒక కుమారుడు పుట్టాడు, అతనికి ఎనోషు అని పేరు పెట్టాడు. అప్పటినుండి ప్రజలు యెహోవా నామంలో ప్రార్థించడం మొదలుపెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ఆదాము వంశావళి యొక్క జాబితా ఇదే. దేవుడు మనుష్యజాతిని సృష్టించినప్పుడు వారిని దేవుని పోలికలో చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ఆయన వారిని పురుషునిగాను స్త్రీగాను సృజించారు. ఆయన వారిని ఆశీర్వదించి వారికి “మనుష్యజాతి” అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ఆదాము 130 సంవత్సరాలు జీవించి తన పోలికలో తన స్వరూపంలో ఒక కుమారుని కని అతనికి షేతు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","షేతు పుట్టిన తర్వాత ఆదాము 800 సంవత్సరాలు బ్రతికాడు; ఇతర కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ఆదాము మొత్తం 930 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","షేతు 105 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి ఎనోషు పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ఎనోషు పుట్టిన తర్వాత షేతు 807 సంవత్సరాలు బ్రతికాడు; అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","షేతు మొత్తం 912 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ఎనోషు 90 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి కేయినాను పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","కేయినాను పుట్టిన తర్వాత ఎనోషు 815 సంవత్సరాలు బ్రతికాడు; అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ఎనోషు మొత్తం 905 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","కేయినాను 70 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి మహలలేలు పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","మహలలేలు పుట్టిన తర్వాత కేయినాను 840 సంవత్సరాలు బ్రతికాడు; ఇతర కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","కేయినాను మొత్తం 910 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","మహలలేలు 65 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి యెరెదు పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","యెరెదు పుట్టిన తర్వాత మహలలేలు 830 సంవత్సరాలు బ్రతికాడు; ఇతర కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","మహలలేలు మొత్తం 895 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","యెరెదు 162 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి హనోకు పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","హనోకు పుట్టిన తర్వాత యెరెదు 800 సంవత్సరాలు బ్రతికాడు; ఇతర కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","యెరెదు మొత్తం 962 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","హనోకు 65 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి మెతూషెల పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","మెతూషెల పుట్టిన తర్వాత హనోకు 300 సంవత్సరాలు బ్రతికి దేవునితో నమ్మకంగా నడిచాడు; ఈ సమయంలో ఇతర కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","హనోకు మొత్తం 365 సంవత్సరాలు జీవించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","హనోకు దేవునితో నమ్మకంగా నడిచాడు; తర్వాత ఒక రోజు దేవుడు అతన్ని తీసుకెళ్లారు కాబట్టి అతడు కనబడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","మెతూషెల 187 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి లెమెకు పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","లెమెకు పుట్టిన తర్వాత మెతూషెల 782 సంవత్సరాలు బ్రతికాడు; ఇతర కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","మెతూషెల మొత్తం 969 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","లెమెకు 182 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి ఒక కుమారుడు పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","అతనికి నోవహు అని పేరు పెట్టి, “యెహోవా శపించిన ఈ భూమిని సాగుచేయడానికి మనం పడే ప్రయాసలో, మన చేతుల బాధాకరమైన శ్రమలలో ఆయన మనలను ఆదరిస్తారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","నోవహు పుట్టిన తర్వాత లెమెకు 595 సంవత్సరాలు బ్రతికాడు; ఇతర కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","లెమెకు మొత్తం 777 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","నోవహు 500 సంవత్సరాల వయస్సులో ఉన్నప్పుడు అతనికి షేము, హాము యాపెతులు పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","నరులు భూమిపై వృద్ధి చెంది విస్తరిస్తూ ఉన్న సమయంలో వారికి కుమార్తెలు పుట్టినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","దేవుని కుమారులు నరుల కుమార్తెలు అందంగా ఉండడం చూసి, వారిలో నచ్చిన వారిని పెళ్ళి చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","అప్పుడు యెహోవా, “నా ఆత్మ నరులతో నిరంతరం వాదించదు, ఎందుకంటే వారు శరీరులు; వారి బ్రతుకు దినాలు 120 సంవత్సరాలు అవుతాయి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ఆ దినాల్లో భూమిపై నెఫిలీములు ఉండేవారు, వీరు తర్వాత కూడా ఉన్నారు. వీరు దేవుని కుమారులు నరుల కుమార్తెలతో లైంగిక సంబంధం పెట్టుకున్నప్పుడు పుట్టిన పిల్లలు. వీరు ప్రాచీన కాలంలో పేరు పొందిన యోధులు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","యెహోవా భూమిపై నరుల దుష్టత్వం చాలా విస్తరించిందని, నరుల హృదయంలోని ప్రతీ ఊహ కేవలం చెడు అని చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","యెహోవా భూమిపై నరులను చేసినందుకు చింతించి, హృదయంలో చాలా బాధపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","అప్పుడు యెహోవా, “నేను సృజించిన నరులను, వారితో పాటు జంతువులను, పక్షులను, నేలపై ప్రాకే జీవులను భూమి మీద నుండి తుడిచివేస్తాను, వాటిని చేసినందుకు నేను బాధపడుతున్నాను” అని అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","అయితే నోవహు యెహోవా దృష్టిలో దయ పొందుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","నోవహు అతని కుటుంబం యొక్క వివరాలు: నోవహు నీతిమంతుడు, అతని సమకాలికులలో అతడు నిందారహితుడు, దేవునితో నమ్మకంగా జీవించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","నోవహుకు ముగ్గురు కుమారులు: షేము, హాము, యాపెతు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","దేవుని దృష్టిలో భూమి అవినీతితో హింసతో నిండిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","దేవుడు ఈ భూమి ఎంతో అవినీతితో ఉందని చూశారు, ఎందుకంటే భూమిపై ఉన్న ప్రజలంతా తమ జీవిత విధానాలను పాడుచేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","కాబట్టి దేవుడు నోవహుతో ఇలా అన్నారు, “నేను ప్రజలందరినీ నాశనం చేయబోతున్నాను, ఎందుకంటే వారిని బట్టి భూమి హింసతో నిండిపోయింది. నేను ఖచ్చితంగా వారిని, భూమిని నాశనం చేయబోతున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","కాబట్టి నీకోసం తమాల వృక్ష చెక్కతో ఒక ఓడను నిర్మించుకో; దానిలో గదులు చేసి, దానికి లోపల బయట కీలు పూయాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","దానిని నిర్మించవలసిన విధానం: ఆ ఓడ పొడవు 300 మూరలు, వెడల్పు 50 మూరలు, ఎత్తు 30 మూరలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","దానికి పైకప్పు వేసి, మూర కొలత క్రింద అన్ని మూలలు గల ఒక కిటికీ పెట్టాలి. ఓడకు ఒక ప్రక్క తలుపు పెట్టాలి, క్రింద, మధ్య, పై అంతస్తులు నిర్మించాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ఆకాశం క్రింద ఉన్న సమస్త జీవులను, జీవవాయువు గల ప్రతి ప్రాణిని నాశనం చేయడానికి నేను భూమి మీదికి జలప్రళయం తీసుకురాబోతున్నాను. భూమిపై ఉన్న ప్రతిదీ నశిస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","అయితే నీతో నా నిబంధనను స్థిరపరుస్తాను, ఓడలో నీతో పాటు నీ కుమారులు, నీ భార్య, నీ కోడళ్ళు ప్రవేశించాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","మీతో పాటు బ్రతికి ఉండేలా జీవులన్నిటిలో మగ, ఆడవాటిని మీరు ఓడలోకి తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ప్రతి జాతిలో రెండేసి పక్షులు, ప్రతి జాతిలో రెండేసి జంతువులు, ప్రతి జాతిలో నేలపై ప్రాకే ప్రాణులు బ్రతికి ఉండడానికి నీ దగ్గరకు వస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","నీకు, వాటికి తినడానికి ఆహారాన్ని అన్ని రకాల భోజనపదార్థాలు సమకూర్చుకోవాలి.” ");
INSERT INTO telotsa_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","దేవుడు తనకు ఆజ్ఞాపించినట్టే నోవహు అంతా చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","అప్పుడు యెహోవా నోవహుతో, “నీవు, నీ కుటుంబం ఓడలో ప్రవేశించండి, ఎందుకంటే ఈ తరంలో నీవు మాత్రమే నాకు నీతిమంతునిగా కనిపించావు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","నీతో పాటు పవిత్రమైన జంతువుల్లో జంటల చొప్పున ఏడు మగవాటిని, ఏడు ఆడవాటిని, అపవిత్రమైన వాటిలో ఒక మగదానిని, ");
INSERT INTO telotsa_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","అలాగే పక్షిజాతులన్నిటిలో నుండి ఏడు మగవాటిని ఏడు ఆడవాటిని భూమిపై వాటి జాతులు సజీవంగా ఉంచడానికి ఓడలోకి తీసుకెళ్లు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ఇంకా ఏడు రోజుల్లో భూమి మీద నలభై రాత్రింబగళ్ళు నేను వర్షం కురిపిస్తాను, నేను చేసిన ప్రతి ప్రాణిని భూమి మీద నుండి తుడిచివేస్తాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారమే నోవహు అంతా చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","భూమి మీదికి జలప్రళయం వచ్చినప్పుడు నోవహుకు 600 సంవత్సరాలు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","జలప్రళయం నుండి తప్పించుకోడానికి నోవహు, అతని భార్య, కుమారులు, వారి భార్యలు ఓడలోనికి ప్రవేశించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","పవిత్రమైన, అపవిత్రమైన జంతువుల్లో, పక్షుల్లో, నేలపై ప్రాకే జీవులన్నిటిలో, ");
INSERT INTO telotsa_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","దేవుడు నోవహుకు ఆజ్ఞాపించిన ప్రకారమే మగవి ఆడవి, జతలుగా నోవహు దగ్గరకు వచ్చి ఓడలో ప్రవేశించాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ఏడు రోజుల తర్వాత భూమి మీదికి జలప్రళయం వచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","నోవహుకు 600 సంవత్సరాల రెండు నెలల పదిహేడవ రోజున గొప్ప అగాధంలోని ఊటలన్నీ ఉప్పొంగాయి, ఆకాశ తూములు ద్వారాలు తెరుచుకున్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","నలభై రాత్రింబగళ్ళు భూమిపై వర్షం కురిసింది. ");
INSERT INTO telotsa_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ఆ రోజే నోవహు, అతని కుమారులు షేము, హాము, యాపెతు, నోవహు భార్య, అతని ముగ్గురు కుమారుల భార్యలు ఓడలోనికి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ప్రతి జాతి ప్రకారం అడవి జంతువులు, వాటి వాటి జాతుల ప్రకారం అన్ని రకాల పశువులు, ఆయా జాతుల ప్రకారం నేలపై ప్రాకే జీవులు, వాటి వాటి జాతుల ప్రకారం పక్షులు, రెక్కలు గల ప్రతిదీ వారితో ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","జీవపు ఊపిరి ఉన్న అన్ని జీవుల జతలు నోవహు దగ్గరకు వచ్చి ఓడలోకి ప్రవేశించాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","దేవుడు నోవహుకు ఆజ్ఞాపించిన ప్రకారమే అన్ని జీవులలో ఆడవి మగవి జతలుగా ఓడలోకి వెళ్లాయి. అప్పుడు యెహోవా ఓడ తలుపు మూసివేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","నలభై రోజులు భూమిపై జలప్రళయం ముంచెత్తింది, నీళ్లు నిండిన కొలది ఓడ నీటిపై తేలుతూ ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","భూమిపై జలాలు అధికంగా విస్తరించాయి, ఆ ఓడ నీటిపై తేలింది. ");
INSERT INTO telotsa_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","నీరు ఎక్కువై భూమిని కప్పివేశాయి, ఆకాశాల క్రింద ఉన్న అన్ని ఎత్తైన పర్వతాలు నీటిలో మునిగిపోయాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","నీరు పర్వతాల కన్నా పదిహేను మూరల ఎత్తు లేచి వాటిని కప్పివేశాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","భూమి మీద ఉన్న జీవరాశులన్నీ అంటే పక్షులు, పశువులు, అడవి జంతువులు, భూమి మీద సంచరించే సమస్త ప్రాణులు చనిపోయాయి, మనుష్యులు కూడా అందరు చనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","పొడి నేలపై నాసికారంధ్రాలలో జీవం కలిగి ఉన్న ప్రతి ప్రాణి చనిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","నేల మీద ఉన్న జీవరాశులన్నీ తుడిచివేయబడ్డాయి; మనుష్యులు, పశువులు, నేల మీద తిరిగే జీవులు, పక్షులు తుడిచివేయబడ్డాయి. కేవలం నోవహు, అతనితో ఓడలో ఉన్నవారు మిగిలారు. ");
INSERT INTO telotsa_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","వరదనీరు భూమిని నూట యాభై రోజులు ముంచెత్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","అయితే దేవుడు నోవహును, అతనితో ఓడలో ఉన్న సమస్త అడవి జంతువులను పశువులను జ్ఞాపకం చేసుకుని, భూమి మీదికి గాలిని పంపినప్పుడు నీరు వెనుకకు తగ్గింది. ");
INSERT INTO telotsa_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","అగాధజలాల ఊటలు ఆకాశపు తూములు మూయబడ్డాయి, ఆకాశం నుండి కురుస్తున్న వర్షం ఆగిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","భూమి నుండి క్రమంగా నీరు తగ్గింది, నూట యాభై రోజుల తర్వాత నీరు తగ్గి, ");
INSERT INTO telotsa_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ఏడవ నెల పదిహేడవ రోజున ఓడ అరారతు పర్వతాలమీద ఆగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","పదవనెల వరకు నీరు తగ్గుతూ ఉంది, పదవనెల మొదటి రోజున పర్వత శిఖరాలు కనిపించాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","నలభైౖ రోజుల తర్వాత నోవహు తాను తయారుచేసిన ఓడ కిటికీ తెరిచి, ");
INSERT INTO telotsa_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ఒక కాకిని బయటకు పంపాడు, అది భూమిపై నీళ్లు ఆరిపోయే వరకు ఇటు అటు ఎగురుతూ ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","అప్పుడు భూమి మీద నీరు తగ్గిందో లేదో చూడటానికి నోవహు ఒక పావురాన్ని బయటకు పంపాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","అయితే భూమి మీద అంతటా నీరు ఉన్నందుకు ఆ పావురానికి వాలడానికి చోటు దొరకలేదు; కాబట్టి అది ఓడలో ఉన్న నోవహు దగ్గరకు తిరిగి వచ్చింది. అతడు చేయి చాపి, పావురాన్ని పట్టుకుని ఓడలోకి తీసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","మరో ఏడు రోజులు వేచియున్న తర్వాత అతడు ఆ పావురాన్ని మళ్ళీ బయటకు పంపాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","సాయంకాలం ఆ పావురం అతని దగ్గరకు వచ్చినప్పుడు, దాని ముక్కుకు పచ్చని ఒలీవ ఆకు ఉంది. అప్పుడు భూమి మీద నీరు తగ్గిందని నోవహు గ్రహించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","మరో ఏడు రోజులు ఆగి, ఆ పావురాన్ని మళ్ళీ బయటకు పంపాడు, అయితే ఈసారి అది అతని దగ్గరకు తిరిగి రాలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","నోవహు యొక్క 601 వ సంవత్సరం మొదటి నెల మొదటి దినాన భూమి మీద నీళ్లు ఎండిపోయాయి. అప్పుడు నోవహు ఓడ కప్పు తెరిచి చూస్తే నేల ఆరిపోయి కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","రెండవ నెల ఇరవై ఏడవ రోజు నాటికి భూమి పూర్తిగా ఆరిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","అప్పుడు దేవుడు నోవహుతో, ");
INSERT INTO telotsa_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“నీవూ, నీ భార్య, నీ కుమారులు, వారి భార్యలు, ఓడలో నుండి బయటకు రండి. ");
INSERT INTO telotsa_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","నీతో ఉన్న ప్రతి జీవిని అంటే పక్షులు, జంతువులు, నేల మీద ప్రాకే ప్రాణులన్నిటిని బయటకు తీసుకురా, అప్పుడు అవి భూమి మీద ఫలించి, వృద్ధి చెంది, విస్తరిస్తాయి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","నోవహు, తన భార్య, కుమారులు, కుమారుల భార్యలతో పాటు బయటకు వచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","జంతువులు, నేల మీద ప్రాకే జీవులు, పక్షులు, భూమి మీద తిరిగే జీవులన్నీ ఒక జాతి వెంబడి మరో జాతి, వాటి వాటి జంటల ప్రకారం ఓడలో నుండి బయటకు వచ్చాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","అప్పుడు నోవహు యెహోవాకు ఒక బలిపీఠం కట్టి, జంతువుల్లో పక్షుల్లో పవిత్రమైనవాటిలో కొన్ని తీసి ఆ బలిపీఠంపై దహనబలి అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","యెహోవా ఆ బలి అర్పణ యొక్క ఇష్టమైన సువాసన పీల్చుకుని తన హృదయంలో ఇలా అనుకున్నారు: “మనుష్యుల హృదయాలోచన బాల్యం నుండే చెడ్డది అయినప్పటికీ, ఇక ఎన్నడు మనుష్యుల కారణంగా భూమిని శపించను. నేను ఇప్పుడు చేసినట్టు ఇంకెప్పుడు సమస్త జీవులను నాశనం చేయను. ");
INSERT INTO telotsa_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“ఈ భూమి ఉన్నంత కాలం, నాటే కాలం కోతకాలం, చలి వేడి, ఎండకాలం చలికాలం, పగలు రాత్రి, ఎప్పుడూ నిలిచిపోవు.” ");
INSERT INTO telotsa_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","అప్పుడు దేవుడు నోవహును అతని కుమారులను ఆశీర్వదిస్తూ, “మీరు ఫలించి అభివృద్ధి పొంది భూలోకాన్ని నింపండి. ");
INSERT INTO telotsa_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","భూలోకంలో ఉన్న అన్ని రకాల జంతువులు, ఆకాశంలోని అన్ని రకాల పక్షులు, నేల మీద తిరిగే ప్రతీ జీవి, సముద్రంలో ఉన్న అన్ని చేపలు మీకు భయపడతాయి భీతి చెందుతాయి; అవి మీ చేతికి అప్పగించబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","జీవిస్తూ తిరిగే ప్రతిదీ మీకు ఆహారం అవుతుంది. పచ్చని మొక్కలను నేను మీకు ఇచ్చినట్టుగా ఇప్పుడు అన్నిటిని మీకు ఇస్తున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“అయితే మాంసంలో ప్రాణాధారమైన రక్తం ఉంటే మీరు తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ఎవరైనా ఇంకొకరి ప్రాణం తీస్తే నేను వారి రక్తం గురించి లెక్క అడుగుతాను. అడవి జంతువు ఒక మనుష్యుని చంపితే, అది చంపబడాలి. ఎవరైనా తోటి మనుష్యుల ప్రాణం తీస్తే దాని గురించి నేను లెక్క అడుగుతాను. ");
INSERT INTO telotsa_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“ఎవరైనా మనుష్యుని రక్తం చిందిస్తే, మనుష్యులచే వారి రక్తం చిందించబడాలి; ఎందుకంటే దేవుడు తన స్వరూపంలో మనుష్యుని సృజించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","మీరైతే, ఫలించి, అభివృద్ధిచెంది; భూమిపై విస్తరించండి” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","దేవుడు నోవహుతో అతని కుమారులతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“నేను మీతో మీ రాబోయే తరం వారితో నా నిబంధన స్థిరపరస్తున్నాను, ");
INSERT INTO telotsa_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","మీతో పాటు ఉన్న ప్రతి జీవితో అనగా పక్షులతో, పశువులతో, సమస్త అడవి జంతువులతో, ఓడలో నుండి మీతో పాటు బయటకు వచ్చిన జీవులన్నిటితో, భూమిపై ఉన్న ప్రతి జీవితోను నా నిబంధన స్థిరపరస్తున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","నేను నీతో చేసిన నిబంధనను ధృవీకరిస్తున్నాను: ఇక ఎన్నడు వరద నీటితో సమస్త ప్రాణులు నాశనం కావు; భూమిని నాశనం చేసే జలప్రళయం ఇక ఎన్నడు రాదు.” ");
INSERT INTO telotsa_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","దేవుడు ఇలా అన్నారు, “నాకును మీకును, మీతో ఉన్న ప్రతి ప్రాణికిని మధ్య తరాలన్నిటి కోసం నేను చేస్తున్న నిబంధనకు గుర్తు ఇదే: ");
INSERT INTO telotsa_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","నేను మేఘాలలో నా ధనుస్సును పెట్టాను, అది నాకూ భూమికి మధ్య నిబంధన గుర్తుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","నేను భూమిపై మేఘాలను తీసుకువచ్చినప్పుడు ఈ ధనుస్సు మేఘాలలో కనిపిస్తుంది, ");
INSERT INTO telotsa_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","అప్పుడు నేను నాకును మీకును, ప్రతి రకమైన ప్రాణులకు మధ్య ఉన్న నా నిబంధనను జ్ఞాపకం చేసుకుంటాను. ఇక ఎన్నడు కూడా సమస్త జీవులన్నిటిని నాశనం చేయడానికి నీరు వరదలా మారదు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","మేఘాలలో ధనస్సు కనిపించినప్పుడు, నేను దానిని చూసి దేవునికి, భూమిపై ఉన్న సమస్త ప్రాణులకు మధ్య నేను చేసిన నిత్యనిబంధనను జ్ఞాపకం చేసుకుంటాను.” ");
INSERT INTO telotsa_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ఇంకా దేవుడు నోవహుతో, “ఇది నాకూ భూమిపై ఉన్న సమస్త జీవులకు మధ్య ఉన్న నిబంధనకు గుర్తు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ఓడలో నుండి వచ్చిన నోవహు కుమారులు షేము, హాము, యాపెతు. (హాము కనానీయులకు తండ్రి.) ");
INSERT INTO telotsa_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ఈ ముగ్గురు నోవహు కుమారులు, వీరి నుంచే భూలోకమంతా ప్రజలు విస్తరించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","వ్యవసాయకుడైన నోవహు ద్రాక్షతోట నాటడం ఆరంభించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","అతడు కొంత మద్యం త్రాగి మత్తులో తన గుడారంలో బట్టలు లేకుండా పడి ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","కనాను తండ్రియైన హాము తన తండ్రి దిగంబరిగా ఉండడం చూసి బయట ఉన్న తన ఇద్దరు అన్నలకు చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","అయితే షేము, యాపెతు ఒక వస్త్రం తీసుకుని తమ భుజాల మీద వేసుకుని వెనుకకు నడిచి వెళ్లి తమ తండ్రి నగ్న శరీరాన్ని కప్పారు. తండ్రి నగ్న శరీరం వైపు చూడకుండ వారు తమ ముఖాలను మరోవైపుకు తిప్పుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","నోవహుకు మత్తు వదిలిన తర్వాత చిన్నకుమారుడు తనకు చేసింది తెలుసుకుని, ");
INSERT INTO telotsa_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ఇలా అన్నాడు, “కనాను శపించబడాలి! అతడు తన సహోదరులకు దాసులలో అత్యల్పునిగా ఉంటాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ఇంకా అతడు, “షేము దేవుడైన యెహోవాకు స్తుతి! కనాను అతనికి దాసుడవాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","దేవుడు యాపెతు సరిహద్దును విస్తరింపజేయాలి; యాపెతు షేము గుడారాల్లో నివసించాలి, కనాను యాపెతుకు దాసుడవాలి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","జలప్రళయం తర్వాత నోవహు ఇంకా 350 సంవత్సరాలు జీవించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","నోవహు మొత్తం 950 సంవత్సరాలు జీవించి, ఆ తర్వాత మరణించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","నోవహు కుమారులైన షేము, హాము, యాపెతు అనబడే వారి వంశావళి వివరణ: జలప్రళయం తర్వాత వారికి కుమారులు పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","యాపెతు కుమారులు: గోమెరు, మాగోగు, మాదయి, యవాను, తుబాలు, మెషెకు, తీరసు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","గోమెరు కుమారులు: అష్కెనజు, రీఫతు, తోగర్మా. ");
INSERT INTO telotsa_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","యవాను కుమారులు: ఎలీషా, తర్షీషు, కిత్తీము, దోదానీము. ");
INSERT INTO telotsa_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(వీరినుండి సముద్ర తీర ప్రజలు, వారి వారి వంశం ప్రకారం, తమ తమ భాషలతో సరిహద్దులలో విస్తరించారు.) ");
INSERT INTO telotsa_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","హాము కుమారులు: కూషు, ఈజిప్టు, పూతు, కనాను. ");
INSERT INTO telotsa_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","కూషు కుమారులు: సెబా, హవీలా, సబ్తా, రాయమా, సబ్తెకా. రాయమా కుమారులు: షేబ, దేదాను. ");
INSERT INTO telotsa_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","కూషు నిమ్రోదుకు తండ్రి, ఇతడు భూమిపై మొదటి బలమైన యోధుడు అయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","అతడు యెహోవా దృష్టిలో బలమైన వేటగాడు. అందుకే, “యెహోవా ఎదుట గొప్ప వేటగాడైన నిమ్రోదు వలె” అని సామెత ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","షీనారులో అతని రాజ్యంలో మొదటి ప్రాంతాలు బబులోను, ఎరెకు, అక్కదు, కల్నే అనేవి ప్రధాన పట్టణాలు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","అక్కడినుండి అతడు అష్షూరుకు వెళ్లి అక్కడ నీనెవె, రెహోబోత్-ఇర్, కలహు, ");
INSERT INTO telotsa_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","నీనెవెకు కలహుకు మధ్యలో ఉన్న రెసెను అనే గొప్ప పట్టణం కట్టి తన సరిహద్దును విస్తరింపజేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ఈజిప్టు కుమారులు: లూదీయులు, అనామీయులు, లెహాబీయులు, నఫ్తుహీయులు, ");
INSERT INTO telotsa_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","పత్రూసీయులు, కస్లూహీయులు (వీరినుండి ఫిలిష్తీయులు వచ్చారు) కఫ్తోరీయులు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","కనాను కుమారులు: మొదటి కుమారుడగు సీదోను, హిత్తీయులు, ");
INSERT INTO telotsa_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","యెబూసీయులు, అమోరీయులు, గిర్గాషీయులు, ");
INSERT INTO telotsa_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","హివ్వీయులు, అర్కీయులు, సీనీయులు, ");
INSERT INTO telotsa_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","అర్వాదీయులు, సెమారీయులు, హమాతీయులు. (తర్వాత కనాను వంశస్థులు చెదిరిపోయారు ");
INSERT INTO telotsa_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","కనాను సరిహద్దులు సీదోను నుండి గెరారు వైపు గాజా వరకు అలాగే సొదొమ, గొమొర్రా, అద్మా, సెబోయిము, లాషా పట్టణాల వరకు విస్తరించాయి.) ");
INSERT INTO telotsa_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","వీరు వంశాల ప్రకారం, వివిధ భాషల ప్రకారం విభిన్న ప్రాంతాలకు, దేశాలకు వ్యాపించిన హాము కుమారులు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","షేముకు కూడా కుమారులు పుట్టారు, ఇతని పెద్ద సహోదరుడు యాపెతు; షేము ఏబెరు కుమారులందరికి పూర్వికుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","షేము కుమారులు: ఏలాము, అష్షూరు, అర్పక్షదు, లూదు, అరాము. ");
INSERT INTO telotsa_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","అరాము కుమారులు: ఊజు, హూలు, గెతెరు, మెషెకు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","అర్పక్షదు షేలహుకు తండ్రి: షేలహు ఏబెరుకు తండ్రి. ");
INSERT INTO telotsa_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ఏబెరుకు ఇద్దరు కుమారులు పుట్టారు: ఒకనికి పెలెగు అని పేరు పెట్టారు ఎందుకంటే అతని కాలంలోనే భూమి విభజింపబడింది; అతని సోదరునికి యొక్తాను అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","యొక్తాను కుమారులు: అల్మోదాదు, షెలపు, హసర్మావెతు, యెరహు, ");
INSERT INTO telotsa_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","హదోరము, ఊజాలు, దిక్లా, ");
INSERT INTO telotsa_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ఓబాలు, అబీమాయేలు, షేబ, ");
INSERT INTO telotsa_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ఓఫీరు, హవీలా, యోబాబు. వీరందరు యొక్తాను కుమారులు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(వీరు నివసించే ప్రాంతం మేషా నుండి తూర్పు కొండసీమ ఉన్న సెఫారా వరకు ఉంది.) ");
INSERT INTO telotsa_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","వీరు తమ వంశాల ప్రకారం వారి భాషల ప్రకారం విభిన్న ప్రాంతాలకు, దేశాలకు వ్యాపించిన షేము కుమారులు. ");
INSERT INTO telotsa_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","తమ వంశాల ప్రకారం తమ దేశాల్లో ఉంటున్న నోవహు కుమారుల వంశావళి ఇదే. జలప్రళయం తర్వాత వీరి ద్వారా ప్రజలు విస్తరించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","భూలోకమంతా ఒకే భాష ఒకే యాస ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ప్రజలు తూర్పు వైపునకు ప్రయాణమై వెళ్తుండగా, షీనారు దేశంలో ఒక మైదానాన్ని కనుగొని అక్కడే స్థిరపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","వారు ఒకరితో ఒకరు, “రండి ఇటుకలు చేసి వాటిని బాగా కాలుద్దాం” అని చెప్పుకున్నారు. వారు రాళ్లకు బదులు ఇటుకలు, అడుసుకు బదులుగా కీలుమట్టి వాడారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","అప్పుడు వారు, “రండి, మన కోసం ఆకాశాన్ని అంటే గోపురం గల ఒక పట్టణాన్ని కట్టుకుని మనకు మనం పేరు తెచ్చుకుందాం; లేదా మనం భూమంతా చెదిరిపోతాం” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","అయితే యెహోవా మనుష్యులు కట్టుకుంటున్న పట్టణాన్ని, గోపురాన్ని చూడటానికి క్రిందికి దిగి వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","యెహోవా, “ఒకవేళ ప్రజలు ఒకే భాష మాట్లాడుతూ ఇది చేయడం ప్రారంభిస్తే, అప్పుడు వారు చేద్దామనుకుంది ఏదైనా వారికి అసాధ్యం కాదు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","రండి, మనం క్రిందికి వెళ్లి వారి భాషను తారుమారు చేద్దాం, అప్పుడు ఒకరి సంభాషణ ఒకరు అర్థం చేసుకోలేరు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","కాబట్టి యెహోవా వారిని భూమి అంతట చెదరగొట్టారు, వారు పట్టణ నిర్మాణం ఆపివేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","యెహోవా భూప్రజలందరి భాషను తారుమారు చేశారు కాబట్టి అది బాబెలు అని పిలువబడింది. యెహోవా వారిని అక్కడినుండి భూలోకమంతా చెదరగొట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ఇది షేము కుటుంబ వంశావళి. జలప్రళయం గతించిన రెండు సంవత్సరాల తర్వాత, షేముకు 100 సంవత్సరాల వయస్సు ఉన్నప్పుడు అతనికి అర్పక్షదు పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","అర్పక్షదు పుట్టిన తర్వాత షేము 500 సంవత్సరాలు బ్రతికాడు, ఇంకా కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","అర్పక్షదు 35 సంవత్సరాల వయసువాడై షేలహుకు తండ్రి అయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","షేలహు పుట్టిన తర్వాత అర్పక్షదు 403 సంవత్సరాలు బ్రతికాడు, ఇంకా అతనికి కుమారులు కుమార్తెలు పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","షేలహు 30 సంవత్సరాల వయసువాడై ఏబెరుకు తండ్రి అయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ఏబెరు పుట్టిన తర్వాత షేలహు 403 సంవత్సరాలు బ్రతికాడు, అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ఏబెరు 34 సంవత్సరాల వయసువాడై పెలెగును కన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","పెలెగు పుట్టిన తర్వాత ఏబెరు 430 సంవత్సరాలు బ్రతికాడు, ఇంకా కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","పెలెగు 30 సంవత్సరాల వయసువాడై రయూను కన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","రయూ పుట్టిన తర్వాత పెలెగు 209 సంవత్సరాలు బ్రతికాడు, ఇంకా కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","రయూ 32 సంవత్సరాల వయసువాడై సెరూగును కన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","సెరూగు పుట్టిన తర్వాత రయూ 207 సంవత్సరాలు బ్రతికాడు, ఇంకా కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","సెరూగు 30 సంవత్సరాల వయసువాడై నాహోరును కన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","నాహోరు పుట్టిన తర్వాత సెరూగు 200 సంవత్సరాలు బ్రతికాడు, ఇంకా కుమారులు కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","నాహోరు 29 సంవత్సరాల వయసువాడై తెరహును కన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","తెరహు పుట్టిన తర్వాత నాహోరు 119 సంవత్సరాలు బ్రతికాడు, ఇంకా కుమారులు, కుమార్తెలు అతనికి పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","తెరహు 70 సంవత్సరాల వయసులో ఉండగా అతనికి అబ్రాము, నాహోరు, హారాను పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ఇది తెరహు కుటుంబ వంశావళి. తెరహుకు అబ్రాము, నాహోరు, హారాను పుట్టారు. హారానుకు లోతు పుట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","హారాను, తన తండ్రి తెరహు బ్రతికి ఉన్నప్పుడే, కల్దీయుల ఊరు అనే పట్టణంలో, తన జన్మస్థలంలో చనిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","అబ్రాము, నాహోరు ఇద్దరు కూడా పెళ్ళిళ్ళు చేసుకున్నారు. అబ్రాము భార్యపేరు శారాయి, నాహోరు భార్యపేరు మిల్కా; ఈమె మిల్కాకును ఇస్కాకును తండ్రియైన హారాను కుమార్తె. ");
INSERT INTO telotsa_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","శారాయి గొడ్రాలు, ఆమెకు పిల్లలు కలుగలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","తెరహు తన కుమారుడైన అబ్రామును, తన మనవడు, హారాను కుమారుడైన లోతును, తన కోడలైన అబ్రాము భార్య శారాయిని తీసుకుని కల్దీయుల ఊరు నుండి కనానుకు ప్రయాణమయ్యాడు. కాని దారిలో వారు హారానుకు వచ్చి అక్కడే స్థిరపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","తెరహు 205 సంవత్సరాలు జీవించి హారానులో చనిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","యెహోవా అబ్రాముతో ఇలా అన్నారు, “నీ దేశాన్ని, నీ ప్రజలను, నీ తండ్రి కుటుంబాన్ని విడిచి బయలుదేరి, నేను నీకు చూపించబోయే దేశానికి వెళ్లు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“నేను నిన్ను గొప్ప జనంగా చేస్తాను, నిన్ను ఆశీర్వదిస్తాను; నీ పేరును గొప్పగా చేస్తాను, నీవు దీవెనగా ఉంటావు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","నిన్ను దీవించే వారిని దీవిస్తాను, శపించే వారిని శపిస్తాను; నిన్ను బట్టి భూమి మీద ఉన్న సర్వ జనాంగాలు దీవించబడతారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","యెహోవా చెప్పినట్టే అబ్రాము బయలుదేరాడు; లోతు అతనితో వెళ్లాడు. హారాను నుండి ప్రయాణమైనప్పుడు అబ్రాము వయస్సు డెబ్బై అయిదు సంవత్సరాలు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","అబ్రాము తన భార్య శారాయిని, తమ్ముని కుమారుడైన లోతును, హారానులో వారు కూడబెట్టుకున్న మొత్తం ఆస్తిని, సంపాదించుకున్న ప్రజలను తీసుకుని కనాను దేశం చేరుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","అబ్రాము ఆ దేశం గుండా ప్రయాణమై షెకెములో మోరె యొక్క సింధూర వృక్షం దగ్గరకు వచ్చాడు. ఆ సమయంలో ఆ దేశంలో కనానీయులు నివసిస్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","యెహోవా అబ్రాముకు ప్రత్యక్షమై, “నీ సంతానానికి నేను ఈ దేశాన్ని ఇస్తాను” అని అన్నారు. కాబట్టి తనకు ప్రత్యక్షమైన చోట యెహోవాకు బలిపీఠం కట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","అక్కడినుండి బేతేలుకు తూర్పున ఉన్న కొండల వైపు వెళ్లి అక్కడ గుడారం వేసుకున్నాడు. దానికి పడమర బేతేలు, తూర్పున హాయి ఉన్నాయి. అక్కడ అతడు యెహోవాకు బలిపీఠం నిర్మించి యెహోవాను ఆరాధించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","తర్వాత అబ్రాము ప్రయాణిస్తూ దక్షిణంగా వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","అప్పుడు దేశంలో కరువు వచ్చింది, అది తీవ్రంగా ఉన్నందుకు అబ్రాము కొంతకాలం ఉందామని ఈజిప్టుకు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","అతడు ఈజిప్టు ప్రవేశిస్తుండగా తన భార్య శారాయితో, “నీవు చాలా అందంగా ఉంటావని నాకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ఈజిప్టువారు నిన్ను చూసినప్పుడు, ‘ఈమె అతని భార్య’ అని అంటారు. తర్వాత వారు నన్ను చంపి నిన్ను బ్రతకనిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","నీవు నా చెల్లివని చెప్పు, అప్పుడు నీకోసం నన్ను మంచిగా చూసుకుంటారు, అప్పుడు నిన్ను బట్టి నా ప్రాణం సురక్షితంగా ఉంటుంది” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","అబ్రాము ఈజిప్టుకు వచ్చినప్పుడు ఈజిప్టువారు శారాయి అందంగా ఉందని చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ఫరో అధికారులు ఆమెను చూసి, ఆమె అందాన్ని ఫరో ఎదుట పొగిడారు, ఆమెను రాజభవనం లోనికి తీసుకెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ఆమెను బట్టి అతడు అబ్రామును మంచిగా చూసుకున్నాడు, అబ్రాము గొర్రెలు, మందలు, ఆడ మగ గాడిదలు, ఆడ మగ దాసులు, ఒంటెలను ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","కాని యెహోవా అబ్రాము భార్య శారాయిని బట్టి ఫరోను అతని ఇంటివారిని ఘోరమైన వ్యాధులతో శిక్షించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","కాబట్టి ఫరో అబ్రామును పిలిపించి, “నాకెందుకిలా చేశావు?” అని అన్నాడు. “ఈమె నీ భార్య అని నాకెందుకు చెప్పలేదు? ");
INSERT INTO telotsa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","నేను ఆమెను నా భార్యగా చేసుకునేలా, ‘ఈమె నా చెల్లెలు’ అని నీవెందుకు నాతో చెప్పావు? ఇదిగో నీ భార్య, నీవు ఆమెను తీసుకుని వెళ్లిపో!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","అప్పుడు ఫరో తన మనుష్యులకు ఆజ్ఞ ఇచ్చాడు, వారు అతన్ని, అతని భార్యను, అతనితో ఉన్న ప్రతి దానితో పాటు పంపివేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","అబ్రాము తన భార్యను తనకున్న అంతటిని తీసుకుని ఈజిప్టు నుండి దక్షిణ దేశానికి వెళ్లాడు, లోతు అతనితో పాటు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","అబ్రాము పశువులు, వెండి బంగారాలతో ఎంతో ధనవంతుడయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","దక్షిణం నుండి బయలుదేరి బేతేలుకు వచ్చేవరకు, అంటే బేతేలుకు హాయికి మధ్యలో తాను మొదట గుడారం వేసుకున్న చోటికి వెళ్లి, ");
INSERT INTO telotsa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","తాను మొదట బలిపీఠం కట్టిన చోటుకు చేరుకున్నాడు. అక్కడ అబ్రాము యెహోవాకు ప్రార్థన చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","అబ్రాముతో కలిసి ప్రయాణిస్తున్న లోతుకు కూడా గొర్రెలు, మందలు, గుడారాలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","వీరిద్దరి ఆస్తులు ఎంతో అధికంగా ఉండడం వల్ల వీరు కలిసి ఉండడానికి ఆ స్థలం సహకరించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","అబ్రాము కాపరులకు లోతు కాపరులకు మధ్య వివాదం మొదలైంది. ఆ సమయంలో కనానీయులు, పెరిజ్జీయులు కూడా ఆ దేశంలో నివసిస్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","కాబట్టి అబ్రాము లోతుతో, “మనం సమీప బంధువులం కాబట్టి నీ కాపరులకు నా కాపరులకు మధ్య వైరం కలిగి ఉండడం మంచిది కాదు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ఈ దేశమంతా నీ ముందు లేదా? మనం విడిపోదాము. నీవు ఈ భూభాగంలో ఎడమ వైపుకు వెళ్తే నేను కుడి వైపుకు వెళ్తాను; నీవు కుడి వైపుకు వెళ్తే నేను ఎడమ వైపుకు వెళ్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","లోతు కళ్ళెత్తి సోయరు వైపు యొర్దాను మైదాన ప్రాంతమంతా యెహోవా తోటలా, ఈజిప్టులా, సస్యశ్యామలమై ఉన్నట్లు చూశాడు. (ఇది యెహోవా సొదొమ గొమొర్రాలను నాశనం చేయక ముందు అలా ఉంది.) ");
INSERT INTO telotsa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","కాబట్టి లోతు యొర్దాను మైదాన ప్రాంతమంతా తన కోసం ఎంచుకుని తూర్పు వైపు వెళ్లిపోయాడు. వారు ఒకరి నుండి ఒకరు విడిపోయారు: ");
INSERT INTO telotsa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","అబ్రాము కనాను దేశంలో నివసించాడు, లోతు మైదాన పట్టణాల మధ్య నివసిస్తూ, సొదొమ దగ్గర గుడారాలు వేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","అయితే, సొదొమ ప్రజలు దుర్మార్గులు, యెహోవాకు విరోధంగా ఘోరంగా పాపం చేస్తూ ఉండేవారు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","లోతు అబ్రాము నుండి విడిపోయిన తర్వాత యెహోవా అబ్రాముతో, “నీవున్న చోట నుండి ఉత్తర దక్షిణ తూర్పు పడమర దిశలు చూడు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","నీవు చూస్తున్న భూమంతా నీకు, నీ సంతానానికి శాశ్వతంగా ఇస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","నీ సంతానాన్ని భూమి మీద ఉన్న ఇసుక రేణువుల్లా అంటే ఒకవేళ ఎవరైనా లెక్కించాలనుకున్నా లెక్కించలేనంత విస్తారంగా చేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","నీవు లేచి దేశం యొక్క అన్ని దిక్కులకు వెళ్లు, అదంతా నేను నీకు ఇస్తున్నాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","కాబట్టి అబ్రాము హెబ్రోనులో మమ్రే అనే చోట సింధూర వృక్షాల దగ్గర నివసించడానికి వెళ్లాడు. అక్కడ తన గుడారాలు వేసుకున్నాడు. అక్కడ యెహోవాకు బలిపీఠం కట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","అమ్రాపేలు షీనారు యొక్క రాజుగా ఉన్న కాలంలో, ఎల్లాసరు రాజైన అర్యోకు, ఏలాము రాజైన కదొర్లాయోమెరు, గోయీము రాజైన తిదాలు, ");
INSERT INTO telotsa_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ఈ రాజులు సొదొమ రాజైన బెరాతోను, గొమొర్రా రాజైన బిర్షాతోను, అద్మా రాజైన షినాబుతోను, సెబోయిము రాజైన షెమేబెరుతోను బేల (సోయరు) రాజుతోను యుద్ధం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ఈ రెండవ గుంపు రాజులందరూ సిద్దీము లోయలో (మృత సముద్ర లోయలో) కూడుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","వారంతా పన్నెండు సంవత్సరాలు కదొర్లాయోమెరుకు సేవ చేశారు, కానీ పదమూడవ సంవత్సరంలో తిరుగుబాటు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","పద్నాలుగవ సంవత్సరంలో కదొర్లాయోమెరు, అతనితో పొత్తు పెట్టుకున్న రాజులు కలిసి అష్తారోతు కర్నాయింలో రెఫాయీయులను, హాములో జూజీయులను, షావే కిర్యతాయిములో ఎమీయులను ");
INSERT INTO telotsa_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","హోరీయులను, శేయీరు కొండ సీమలో ఎడారి దగ్గర ఉన్న ఎల్ పారాను వరకు తరిమి ఓడించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","తర్వాత అక్కడినుండి వెనుకకు తిరిగి ఎన్ మిష్పాతు అనబడిన కాదేషుకు వెళ్లి, అమాలేకీయుల భూభాగమంతా, హససోన్ తామారులో నివసిస్తున్న అమోరీయుల భూభాగమంతా జయించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","అప్పుడు సిద్దీం లోయలో సొదొమ రాజు, గొమొర్రా రాజు, అద్మా రాజు, సెబోయిము రాజు, బేల (సోయరు) రాజు తమ సైన్యాలతో, ");
INSERT INTO telotsa_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ఏలాము రాజైన కదొర్లాయోమెరు, గోయీము రాజైన తిదాలు, షీనారు రాజైన అమ్రాపేలు, ఎల్లాసరు రాజైన అర్యోకు, అంటే నలుగురు రాజులు అయిదుగురు రాజులతో యుద్ధం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","సిద్దీము లోయ అంతా కీలుమట్టి గుంటలు ఉన్నాయి. సొదొమ గొమొర్రాల రాజులు పారిపోతూ ఉన్నప్పుడు, కొంతమంది వాటిలో పడిపోయారు మిగిలినవారు కొండల్లోకి పారిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ఆ నలుగురు రాజులు సొదొమ గొమొర్రాల ఆస్తిపాస్తులను, భోజన పదార్థాలను అన్నిటిని దోచుకున్నారు; తర్వాత వారు వెళ్లిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","అబ్రాము సోదరుని కుమారుడైన లోతు సొదొమలో నివసిస్తున్నాడు కాబట్టి, అతన్ని కూడా అతని ఆస్తితో పాటు తీసుకెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","అయితే ఒక వ్యక్తి తప్పించుకు వచ్చి, హెబ్రీయుడైన అబ్రాముకు ఈ సంగతి తెలిపాడు. అబ్రాము ఎష్కోలు ఆనేరుల సోదరుడైన మమ్రే అనే అమోరీయుని సింధూర వృక్షాలు దగ్గర నివసిస్తున్నాడు. వీరు అబ్రాముతో ఒప్పందం చేసుకున్న వారు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","అబ్రాము తన బంధువు బందీగా కొనిపోబడ్డాడు అని విన్నప్పుడు, తన ఇంట్లో పుట్టి శిక్షణ పొందిన 318 మందిని తీసుకుని వారిని దాను వరకు తరిమాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","రాత్రివేళ అబ్రాము తన మనుష్యులను గుంపులుగా విభజించి దాడి చేస్తూ, శత్రువులను ముట్టడించి, దమస్కుకు ఉత్తరాన ఉన్న హోబా వరకు వారిని తరిమాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","అబ్రాము తన బంధువైన లోతును, అతని ఆస్తిని, అతని స్త్రీలను, ఇతర ప్రజలను విడిపించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","కదొర్లాయోమెరు, అతనితో పొత్తు ఉన్న రాజులను ఓడించిన తర్వాత, రాజు లోయ అనబడే షావే లోయలో సొదొమ రాజు అబ్రామును కలిశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","అప్పుడు షాలేము రాజైన మెల్కీసెదెకు రొట్టె ద్రాక్షరసం తెచ్చాడు. అతడు సర్వోన్నతుడైన దేవుని యాజకుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","అతడు అబ్రామును, “భూమ్యాకాశాల సృష్టికర్త, సర్వోన్నతుడైన దేవుడు అబ్రామును దీవించును గాక, ");
INSERT INTO telotsa_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","నీ శత్రువులను నీ చేతికి అప్పగించిన సర్వోన్నతుడైన దేవునికి స్తుతి కలుగును గాక” అంటూ ఆశీర్వదించాడు. అప్పుడు అబ్రాము అన్నిటిలో పదవ భాగాన్ని అతనికి ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","సొదొమ రాజు, “చెరగా తెచ్చిన ప్రజలను నాకు ఇవ్వండి, వస్తువులను మీ కోసం పెట్టుకోండి” అని అబ్రాముతో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","అయితే అబ్రాము సొదొమ రాజుతో, “చేతులెత్తి సర్వోన్నతుడైన దేవుడు, భూమ్యాకాశాల సృష్టికర్తయైన యెహోవాకు ఇలా ప్రమాణం చేశాను, ");
INSERT INTO telotsa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ఒక దారం పోగైననూ, చెప్పులవారైననూ నేను ఆశించను, తద్వార నీవు, ‘నేనే అబ్రామును ధనికుడయ్యేలా చేశాను’ అని చెప్పకుండ ఉంటావు. ");
INSERT INTO telotsa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","నేను దేన్ని అంగీకరించను కాని నా మనుష్యులు తిన్నది, నాతోపాటు వచ్చిన ఆనేరు, ఎష్కోలు, మమ్రే వారికి వారి వాటాను తీసుకోనివ్వు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ఈ సంఘటనల తర్వాత దర్శనంలో యెహోవా వాక్కు అబ్రాము వద్దకు వచ్చి: “అబ్రామూ, భయపడకు, నేను నీకు డాలును, నీ గొప్ప బహుమానాన్ని.” ");
INSERT INTO telotsa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","అయితే అబ్రాము, “ప్రభువైన యెహోవా, నాకు సంతానం లేదు కదా మీరు నాకేమిచ్చినా ఏం లాభం? నా ఆస్తికి వారసుడు దమస్కువాడైన ఎలీయెజెరే కదా” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ఇంకా అబ్రాము దేవునితో, “మీరు నాకు సంతానం ఇవ్వలేదు, కాబట్టి నా ఇంటి పనివారిలో ఒకడు నా వారసుడవుతాడు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","అప్పుడు యెహోవా వాక్కు అతని వద్దకు వచ్చింది: “ఈ మనుష్యుడు నీకు వారసుడు కాడు, కాని నీ రక్తమాంసాలను పంచుకుని పుట్టేవాడే నీకు వారసుడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","దేవుడు అబ్రామును బయటకు తీసుకువచ్చి, “పైన ఆకాశాన్ని చూసి నీకు చేతనైతే నక్షత్రాలను లెక్కబెట్టు. నీ సంతానం అలా ఉంటుంది” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","అబ్రాము యెహోవాను నమ్మాడు, ఆయన దాన్ని అతనికి నీతిగా ఎంచారు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","అంతేకాక దేవుడు అతనితో, “ఈ దేశాన్ని నీకు స్వాస్థ్యంగా ఇవ్వడానికి నిన్ను కల్దీయుల ఊరు నుండి బయటకు తీసుకువచ్చిన యెహోవాను నేనే” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","అయితే అబ్రాము, “ప్రభువైన యెహోవా, దీనిని నేను స్వాస్థ్యంగా పొందుతానని నాకెలా తెలుస్తుంది?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","అందుకు యెహోవా అతనితో, “ఒక దూడను, ఒక మేకను, ఒక పొట్టేలును, అన్నీ మూడు సంవత్సరాలవై ఉండాలి, వాటితో పాటు ఒక గువ్వను, ఒక పావురాన్ని నా దగ్గరకు తీసుకురా” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","అబ్రాము వాటన్నిటిని తెచ్చి, వాటిని సగానికి రెండు ముక్కలుగా కోసి, దేనికది ఎదురెదురుగా పేర్చాడు; అయితే అతడు పక్షులను మాత్రం సగం చేయలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ఆ కళేబరాలపై వాలడానికి రాబందులు వచ్చాయి అయితే అబ్రాము వాటిని వెళ్లగొట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","సూర్యాస్తమయం అవుతుండగా అబ్రాముకు గాఢనిద్ర పట్టింది, భయంకరమైన కారుచీకటి అతని మీదుగా కమ్ముకుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","అప్పుడు యెహోవా అబ్రాముతో ఇలా చెప్పారు, “నీవు ఈ విషయం ఖచ్చితంగా తెలుసుకోవాలి; నీ వారసులు తమది కాని దేశంలో నాలుగు వందల సంవత్సరాలు పరాయివారిగా ఉంటారు, అక్కడ వారు బానిసలుగా ఉంటూ వేధించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","అయితే వారిని బానిసలుగా చేసిన దేశాన్ని నేను శిక్షిస్తాను, ఆ తర్వాత గొప్ప ఆస్తులతో వారు బయటకు వస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","నీవైతే సమాధానంగా నీ పూర్వికుల దగ్గరకు చేరతావు, మంచి వృద్ధాప్యంలో పాతిపెట్టబడతావు. ");
INSERT INTO telotsa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","నీ సంతానంలో నాలుగవ తరం వారు ఇక్కడకు తిరిగి వచ్చేస్తారు, ఎందుకంటే ఇంకా అమోరీయుల పాపం పండలేదు.” ");
INSERT INTO telotsa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","సూర్యుడు అస్తమించి చీకటి కమ్మినప్పుడు పొగలేస్తున్న కుంపటి, మండుతున్న దివిటీ కనిపించి, ఆ ముక్కల మధ్యలో నుండి దాటి వెళ్లాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ఆ రోజు యెహోవా అబ్రాముతో నిబంధన చేసి, “నేను నీ సంతానానికి ఈజిప్టు వాగు నుండి యూఫ్రటీసు మహా నది వరకు అంటే, ");
INSERT INTO telotsa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","కెనీయులు, కెనిజ్జీయులు, కద్మోనీయులు, ");
INSERT INTO telotsa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","హిత్తీయులు, పెరిజ్జీయులు, రెఫాయీయులు, ");
INSERT INTO telotsa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","అమోరీయులు, కనానీయులు, గిర్గాషీయులు, యెబూసీయులు ఉన్న దేశమంతటిని ఇస్తున్నాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","అబ్రాము భార్యయైన శారాయి వలన అతనికి పిల్లలు పుట్టలేదు. అయితే ఆమెకు ఈజిప్టు నుండి వచ్చిన దాసి ఉంది, ఆమె పేరు హాగరు; ");
INSERT INTO telotsa_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","కాబట్టి శారాయి అబ్రాముతో, “యెహోవా నాకు పిల్లలు లేకుండా చేశారు. నీవు వెళ్లి నా దాసితో లైంగికంగా కలువు; బహుశ ఆమె ద్వార నాకు సంతానం కలుగుతుందేమో” అని అన్నది. శారాయి చెప్పిన దానికి అబ్రాము అంగీకరించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","అబ్రాము కనానులో పది సంవత్సరాలు నివసించిన తర్వాత, శారాయి ఈజిప్టు నుండి దాసిగా తెచ్చుకున్న హాగరును తన భర్తకు భార్యగా ఇచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","అతడు హాగరును లైంగికంగా కలిశాడు, ఆమె గర్భవతి అయ్యింది. తాను గర్భవతినని ఆమె తెలుసుకున్నప్పుడు తన యజమానురాలైన శారాయిని చిన్న చూపు చూసింది. ");
INSERT INTO telotsa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","అప్పుడు శారాయి అబ్రాముతో, “నేను అనుభవించే బాధకు నీవే బాధ్యుడవు. నా దాసిని నీ చేతిలో పెట్టాను, ఇప్పుడు తాను గర్భవతి కాబట్టి నన్ను చిన్న చూపు చూస్తుంది. యెహోవా నీకు నాకు మధ్య తీర్పు తీర్చును గాక” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","అబ్రాము శారాయితో, “నీ దాసి నీ చేతిలో ఉంది, నీకు ఏది మంచిదనిపిస్తే అది తనకు చేయి” అన్నాడు. శారాయి హాగరును వేధించింది కాబట్టి ఆమె శారాయి దగ్గర నుండి పారిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","యెహోవా దూత హాగరు ఎడారిలో నీటిబుగ్గ దగ్గర ఉండడం చూశాడు; అది షూరు మార్గం ప్రక్కన ఉండే నీటిబుగ్గ. ");
INSERT INTO telotsa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ఆ దూత, “శారాయి దాసియైన హాగరూ, ఎక్కడి నుండి వచ్చావు, ఎక్కడికి వెళ్తున్నావు?” అని అడిగాడు. ఆమె, “నా యజమానురాలైన శారాయి దగ్గర నుండి వెళ్లిపోతున్నాను” అని జవాబిచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","అప్పుడు యెహోవా దూత ఆమెతో, “నీ యజమానురాలి దగ్గరకు తిరిగివెళ్లి ఆమెకు లోబడి ఉండు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","యెహోవా దూత ఇంకా మాట్లాడుతూ, “నీ సంతానాన్ని లెక్కించలేనంత అధికం చేస్తాను” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","యెహోవా దూత ఆమెతో ఇలా కూడా చెప్పాడు: “ఇప్పుడు నీవు గర్భవతివి నీవు ఒక కుమారునికి జన్మనిస్తావు, యెహోవా నీ బాధ విన్నారు కాబట్టి అతనికి ఇష్మాయేలు అని నీవు పేరు పెడతావు. ");
INSERT INTO telotsa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","అతడు ఒక అడవి గాడిదలాంటి మనుష్యుడు; అందరితో అతడు విరోధం పెట్టుకుంటాడు, అందరి చేతులు అతనికి విరోధంగా ఉంటాయి, అతడు తన సోదరులందరితో శత్రుత్వం కలిగి జీవిస్తాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ఆమె తనతో మాట్లాడిన యెహోవాకు ఈ పేరు పెట్టింది: “నన్ను చూస్తున్న దేవుడు మీరే.” ఆమె, “నన్ను చూస్తున్న దేవుని నేను వెనుక నుండి చూశాను” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","అందుకే ఆ బావికి బెయేర్-లహాయి-రోయి అని పేరు వచ్చింది; అది కాదేషు బెరెదు మధ్యలో ఇప్పటికి ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","హాగరు అబ్రాముకు కుమారుని కన్నది, అబ్రాము అతనికి ఇష్మాయేలు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","హాగరు ఇష్మాయేలుకు జన్మనిచ్చినప్పుడు అబ్రాము వయస్సు ఎనభై ఆరేళ్ళు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","అబ్రాముకు తొంభై తొమ్మిది సంవత్సరాలు వచ్చినప్పుడు యెహోవా అతనికి ప్రత్యక్షమై, “నేను సర్వశక్తిగల దేవుడను, నా ఎదుట నీవు నమ్మకంగా నిందారహితునిగా జీవించాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","అప్పుడు నేను నీకు నాకు మధ్య నిబంధన చేస్తాను, నీ సంతతిని అత్యధికంగా వర్ధిల్లజేస్తాను” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","అబ్రాము సాష్టాంగపడ్డాడు, అప్పుడు దేవుడు అతనితో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“నేను నీతో చేస్తున్న నిబంధన ఇదే: నీవు అనేక జనాంగాలకు తండ్రివవుతావు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ఇకమీదట నీ పేరు అబ్రాము కాదు; నీకు అబ్రాహాము అని పేరు పెడుతున్నాను ఎందుకంటే నేను నిన్ను అనేక జనాలకు తండ్రిగా చేశాను. ");
INSERT INTO telotsa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","నిన్ను ఎంతో ఫలభరితంగా చేస్తాను; నిన్ను అనేక జనాంగాలుగా చేస్తాను, రాజులు నీ నుండి వస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","నా నిబంధనను నాకు నీకు మరి నీ తర్వాత వచ్చు నీ వారసులకు మధ్య నిత్య నిబంధనగా స్థిరపరుస్తాను, నీకు దేవునిగా, నీ తర్వాత నీ వారసులకు దేవునిగా ఉంటాను. ");
INSERT INTO telotsa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","నీవు పరదేశిగా ఉంటున్న కనాను దేశమంతా నీకు, నీ తర్వాత నీ వారసులకు నిత్య స్వాస్థ్యంగా ఇస్తాను; వారికి నేను దేవునిగా ఉంటాను.” ");
INSERT INTO telotsa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","అప్పుడు దేవుడు అబ్రాహాముతో ఇలా అన్నారు, “నీవైతే, నీవు, నీ తర్వాత నీ సంతానం తరతరాల వరకు నా నిబంధనను నిలుపుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","నీకు నీ తర్వాత నీ సంతతివారికి నేను చేసే నా నిబంధన, మీరు నిలుపుకోవలసిన నిబంధన ఇదే: మీలో ప్రతి మగవాడు సున్నతి చేసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","మీకు నాకు మధ్య నిబంధన గుర్తుగా మీ గోప్య చర్మాన్ని సున్నతి చేసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","రాబోయే తరాలలో ఎనిమిది రోజుల వయస్సున్న ప్రతి మగబిడ్డకు అంటే మీ ఇంట్లో పుట్టినవారైనా మీ సంతతి కాక విదేశీయుల నుండి కొనబడినవారైనా సున్నతి చేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","మీ డబ్బుతో కొనబడినవారైనా, వారికి సున్నతి చేయబడాలి. మీ శరీరంలో నా నిబంధన నిత్య నిబంధనగా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","సున్నతి చేయబడని మగవారు అంటే తన గోప్య చర్మానికి సున్నతి చేయబడనివారు తమ జనులలో నుండి బహిష్కరించబడాలి; ఎందుకంటే వారు నా నిబంధనను మీరారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","దేవుడు అబ్రాహాముతో ఇలా కూడా చెప్పారు, “నీ భార్యయైన శారాయిని ఇకపై శారాయి అని పిలువకూడదు; ఇప్పటినుండి తన పేరు శారా. ");
INSERT INTO telotsa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","నేను ఖచ్చితంగా ఆమెను ఆశీర్వదిస్తాను, ఆమె ద్వార నీకు కుమారున్ని ఇస్తాను. ఆమె జనాంగాలకు తల్లిగా ఉండేలా తనను ఆశీర్వదిస్తాను; అనేక జనాంగాల రాజులు ఆమె నుండి వస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","అప్పుడు అబ్రాహాము సాష్టాంగపడ్డాడు; అతడు తన హృదయంలో నవ్వుకుంటూ, “నూరు సంవత్సరాలు నిండిన మనుష్యునికి కుమారుడు పుడతాడా? తొంభై సంవత్సరాలు నిండిన శారా బిడ్డను కంటుందా?” అని అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","అబ్రాహాము దేవునితో, “మీ ఆశీర్వాదం క్రింద ఇష్మాయేలు జీవిస్తే చాలు!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","అప్పుడు దేవుడు, “అవును, అయితే నీ భార్య శారా ఒక కుమారునికి జన్మనిస్తుంది, అతనికి ఇస్సాకు అని పేరు పెడతావు. అతనితో నా నిబంధనను చేస్తాను, తన తర్వాత తన సంతానంతో ఉండేలా నిత్య నిబంధనగా దానిని స్థిరపరుస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ఇష్మాయేలు గురించి, నీవు అడిగింది విన్నాను: నేను అతన్ని ఖచ్చితంగా ఆశీర్వదిస్తాను; అతడు ఫలించి విస్తరించేలా చేస్తాను, సంఖ్యాపరంగా గొప్పగా విస్తరింపజేస్తాను. అతడు పన్నెండుమంది పాలకులకు తండ్రిగా ఉంటాడు; అతన్ని గొప్ప జనంగా చేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","అయితే వచ్చే యేడాది ఈ సమయానికి శారా నీకోసం కనే ఇస్సాకుతో నా నిబంధన స్థిరపరుస్తాను” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","దేవుడు అబ్రాహాముతో మాట్లాడిన తర్వాత, పైకి వెళ్లిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ఆ రోజే అబ్రాహాము తన కుమారుడైన ఇష్మాయేలును, ఇంట్లో పుట్టిన లేదా డబ్బుతో కొనబడిన మగవారికందరికి దేవుడు చెప్పినట్టు సున్నతి చేయించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","అబ్రాహాము సున్నతి పొందినప్పుడు అతని వయస్సు తొంభై తొమ్మిది సంవత్సరాలు, ");
INSERT INTO telotsa_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","తన కుమారుడైన ఇష్మాయేలు వయస్సు పదమూడు సంవత్సరాలు; ");
INSERT INTO telotsa_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","అబ్రాహాము తన కుమారుడైన ఇష్మాయేలు, ఇద్దరు అదే రోజు సున్నతి పొందారు. ");
INSERT INTO telotsa_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","అబ్రాహాము ఇంటివారిలో మగవారందరు, అతని ఇంట్లో పుట్టిన వారు లేదా విదేశీయుల నుండి కొనబడిన అతనితో పాటు సున్నతి చేయించుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","అబ్రాహాము మమ్రేలో ఉన్న సింధూర వృక్షాల దగ్గర తన గుడార ద్వారం దగ్గర ఎండలో కూర్చుని ఉన్నప్పుడు యెహోవా అతనికి ప్రత్యక్షమయ్యారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","అబ్రాహాము కళ్ళెత్తి చూసినప్పుడు అతని ఎదుట ముగ్గురు మనుష్యులు నిలిచి ఉన్నారు. వారిని చూసిన వెంటనే తన గుడార ద్వారం నుండి వారిని కలవడానికి త్వరపడి వెళ్లి సాష్టాంగపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","అబ్రాహాము వారితో, “నా ప్రభువా, మీ దృష్టిలో నేను దయ పొందినట్లైతే, మీ దాసున్ని విడిచి వెళ్లకండి. ");
INSERT INTO telotsa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","నీళ్లు తెప్పిస్తాను, కాళ్లు కడుక్కుని ఈ చెట్టు క్రింద విశ్రాంతి తీసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","మీరు మీ సేవకుని దగ్గరకు వచ్చారు కాబట్టి మీరు తినడానికి ఆహారం తీసుకువస్తాను, మీ ఆకలి తీరిన తర్వాత వెళ్లవచ్చు” అని అన్నాడు. “మంచిది, అలాగే చేయి” అని వారు జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","కాబట్టి అబ్రాహాము శారా గుడారంలోకి త్వరపడి వెళ్లి, “త్వరగా మూడు మానికెలు నాణ్యమైన పిండి తెచ్చి, బాగా పిసికి రొట్టెలు చేయి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","తర్వాత అబ్రాహాము పశువుల మంద దగ్గరకు పరుగెత్తి వెళ్లి, లేగదూడను తెచ్చి తన పనివానికి ఇచ్చాడు, ఆ పనివాడు త్వరగా దానిని వండి పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","తర్వాత అతడు కొంచెం వెన్న, పాలు, వండిన దూడ మాంసాన్ని వారి ముందు ఉంచాడు. వారు భోజనం చేస్తుండగా, వారి దగ్గర చెట్టు క్రింద అతడు నిలబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“నీ భార్య శారా ఎక్కడ?” అని వారు అడిగారు. “అదిగో ఆ గుడారంలో ఉంది” అని అబ్రాహాము జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","అప్పుడు వారిలో ఒకరు, “వచ్చే సంవత్సరం ఈ సమయానికి తప్పకుండా నేను నీ దగ్గరకు తిరిగి వస్తాను, అప్పటికి నీ భార్య శారా ఒక కుమారున్ని కలిగి ఉంటుంది” అని అన్నారు. శారా అతని వెనుక ఉన్న గుడార ద్వారం దగ్గర నిలబడి వింటుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","అబ్రాహాము శారా అప్పటికే చాలా వృద్ధులు, శారా పిల్లలు కనే వయస్సు దాటిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","శారా తనలో తాను నవ్వుకుని, “నేను బలం ఉడిగిన దానిని, నా భర్త కూడా వృద్ధుడు కదా ఇప్పుడు నాకు ఈ భాగ్యం ఉంటుందా?” అని అనుకుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","అప్పుడు యెహోవా అబ్రాహాముతో, “శారా ఎందుకలా నవ్వుకుంది, ‘ముసలిదాన్ని నేను కనగలనా అని ఎందుకు అనుకుంది?’ ");
INSERT INTO telotsa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","యెహోవాకు అసాధ్యమైనది ఏమైనా ఉందా? వచ్చే సంవత్సరం నియమించబడిన సమయానికి నేను నీ దగ్గరకు తిరిగి వస్తాను, అప్పటికి శారా ఒక కుమారున్ని కంటుంది” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","శారా భయపడి, “నేను నవ్వలేదు” అని అబద్ధమాడింది. “లేదు, నీవు నవ్వావు” అని ఆయన అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ఆ మనుష్యులు వెళ్లడానికి లేచి సొదొమ, గొమొర్రాల వైపు చూశారు, అబ్రాహాము వారిని పంపించడానికి వారితో పాటు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","అప్పుడు యెహోవా ఇలా అన్నారు, “నేను చేయబోతున్న దానిని అబ్రాహాముకు చెప్పకుండ ఎలా దాచగలను? ");
INSERT INTO telotsa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","అబ్రాహాము ఖచ్చితంగా గొప్ప శక్తిగల దేశం అవుతాడు, అతని ద్వారా భూమి మీద ఉన్న సర్వ దేశాలు దీవించబడతాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ఎందుకంటే నేను అతన్ని ఎంచుకున్నాను, అతడు తన పిల్లలను తన తర్వాత తన ఇంటివారిని యెహోవా మార్గంలో నీతి న్యాయాలు జరిగిస్తూ జీవించేలా నడిపిస్తాడు, తద్వారా యెహోవా అబ్రాహాముకు చేసిన వాగ్దానాన్ని జరిగిస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","అప్పుడు యెహోవా, “సొదొమ, గొమొర్రాల గురించిన మొర చాలా గొప్పది, వారి పాపం ఘోరమైనది. ");
INSERT INTO telotsa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","నేను అక్కడికి వెళ్లి నాకు చేరిన ఫిర్యాదు వలె వారి క్రియలు ఎంత చెడ్డగా ఉన్నాయో చూసి తెలుసుకుంటాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ఆ మనుష్యులు అక్కడినుండి సొదొమ వైపు వెళ్లారు, అయితే అబ్రాహాము యెహోవా సన్నిధిలో నిలిచి ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","అప్పుడు అబ్రాహాము ఆయనను సమీపించి, “దుష్టులతో పాటు నీతిమంతులను నిర్మూలం చేస్తారా? ");
INSERT INTO telotsa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ఒకవేళ ఆ పట్టణంలో యాభైమంది నీతిమంతులుంటే ఎలా? ఆ యాభైమంది కోసమన్నా ఆ పట్టణాన్ని కాపాడకుండా నిజంగా దానిని నాశనం చేస్తారా? ");
INSERT INTO telotsa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","అలా నాశనం చేయడం మీకు దూరమవును గాక! దుష్టులతో పాటు నీతిమంతులను చంపడం, దుష్టులను నీతిమంతులను ఒకేలా చూడడము. మీ నుండి ఆ తలంపు దూరమవును గాక! సర్వలోక న్యాయాధిపతి న్యాయం చేయరా?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","యెహోవా జవాబిస్తూ, “సొదొమలో యాభైమంది నీతిమంతులను నేను కనుగొంటే, వారిని బట్టి ఆ స్థలం అంతటిని కాపాడతాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","అబ్రాహాము మరలా మాట్లాడాడు: “నేను ధూళిని బూడిదను, అయినాసరే నేను ప్రారంభించాను కాబట్టి నేను ప్రభువుతో ఇంకా మాట్లాడతాను. ");
INSERT INTO telotsa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ఒకవేళ యాభైమందిలో నీతిమంతులు అయిదుగురు తక్కువైతే అప్పుడు పట్టణం అంతటిని అయిదుగురు తక్కువ ఉన్నందుకు నాశనం చేస్తారా?” ఆయన, “నేను అక్కడ నలభై అయిదుగురు చూస్తే అప్పుడు దానిని నాశనం చేయను” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","అబ్రాహాము, “ఒకవేళ నలభైమంది నీతిమంతులు ఉంటే?” అని మరలా అడిగాడు. “ఆ నలభైమంది కోసం దానిని నాశనం చేయను” అని దేవుడు అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","అప్పుడు అతడు, “ప్రభువు కోప్పడకండి, నన్ను మాట్లాడనివ్వండి. ఒకవేళ అక్కడ ముప్పైమంది నీతిమంతులు మాత్రమే ఉంటే?” అని అడిగాడు. ఆయన, “ముప్పైమందిని నేను కనుగొంటే నేను నాశనం చేయను” అని జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","అబ్రాహాము, “నేను ప్రభువుతో మాట్లాడడానికి తెగించాను; ఒకవేళ అక్కడ ఇరవైమందే మాత్రమే ఉంటే?” అని అన్నాడు. ఆయన, “ఆ ఇరవైమంది కోసం దానిని నాశనం చేయను” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","అప్పుడతడు, “ప్రభువా, కోప్పడకండి, నేను ఇంకొక్కసారి మాట్లాడతాను. ఒకవేళ అక్కడ పదిమందే ఉంటే?” అని అడిగాడు. ఆయన, “ఆ పదిమంది కోసం దానిని నాశనం చేయను” అని జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","యెహోవా అబ్రాహాముతో సంభాషణ ముగించిన తర్వాత, ఆయన వెళ్లిపోయారు, అబ్రాహాము తన ఇంటికి తిరిగి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ఆ సాయంత్రం ఇద్దరు దేవదూతలు సొదొమ చేరుకున్నారు, లోతు సొదొమ పట్టణ ద్వారం దగ్గర కూర్చుని ఉన్నాడు. అతడు వారిని చూడగానే, వారిని కలవడానికి లేచి వారి ఎదుట సాష్టాంగపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“నా ప్రభువులారా! దయచేసి మీ దాసుని ఇంటికి రండి, మీ కాళ్లు కడుక్కుని ఈ రాత్రికి మా ఇంట్లో ఉండి, వేకువజామున లేచి వెళ్లవచ్చు” అని వారితో అన్నాడు. అప్పుడు వారు, “లేదు, ఈ రాత్రి నడి వీధిలోనే ఉంటాం” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","అయితే అతడు వారిని బలవంతం చేశాడు, కాబట్టి వారు అతని ఇంటికి వెళ్లారు. అతడు వారికి పులియని పిండితో రొట్టెలు చేశాడు, వారు తిన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","వారు పడుకోకముందు, సొదొమ పట్టణపు వారంతా నలుదిక్కుల నుండి పురుషులు యువకులు, ముసలివారు లోతు ఇంటిని చుట్టుముట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","వారు లోతును పిలిచి, “రాత్రి నీ దగ్గరకు వచ్చిన ఆ మనుష్యులు ఎక్కడ? వారితో మేము లైంగికంగా కలుసుకునేలా బయటకు తీసుకురా” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","లోతు వారిని కలవడానికి బయటకు వెళ్లి తన వెనుక తలుపు మూసివేసి ");
INSERT INTO telotsa_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","వారితో, “సోదరులారా వద్దు, ఈ దుర్మార్గపు పని చేయవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ఇదిగో! నాకు పురుషులతో లైంగిక సంబంధం పెట్టుకొనని ఇద్దరు కుమార్తెలు ఉన్నారు. వారిని మీ దగ్గరకు తెస్తాను వారితో మీ ఇష్టం వచ్చినట్లు చేసుకోండి. కానీ ఈ మనుష్యులు అతిథులుగా నా ఇంటికి వచ్చారు, వీరిని మీరేమి చేయవద్దు” అని బ్రతిమాలుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","వారు, “మాకు అడ్డు పడకుండా వెళ్లిపో” అని బదులిచ్చారు. “వీడు పరదేశిగా ఇక్కడకు వచ్చి మనకే తీర్పు చెప్తున్నాడు! మేము నిన్ను వారిపైన కంటే నీమీద ఎక్కువ దౌర్జన్యం చేస్తాం” అని అంటూ లోతు మీద పడి తలుపు బద్దలు కొట్టడానికి ముందుకు వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","అయితే లోపల ఉన్న మనుష్యులు లోతును ఇంట్లోకి లాగి తలుపు వేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","తర్వాత వారు ఇంటి తలుపు దగ్గర ఉన్న యువకులను వృద్ధులను గ్రుడ్డితనంతో మొత్తగా వారు ద్వారం కనుగొనలేకపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ఆ ఇద్దరు మనుష్యులు లోతుతో, “నీకు నీ అల్లుళ్ళు, కుమారులు, కుమార్తెలు, లేదా నీకు సంబంధించిన వారెవరైనా ఈ పట్టణంలో ఉన్నారా? వారిని బయటకు తీసుకురా, ");
INSERT INTO telotsa_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ఎందుకంటే మేము ఈ పట్టణాన్ని నాశనం చేయబోతున్నాము. ఈ స్థలం యొక్క ప్రజల గురించి యెహోవాకు చేరిన మొర ఎంతో గొప్పది కాబట్టి దీనిని నాశనం చేయడానికి ఆయన మమ్మల్ని పంపారు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","లోతు బయటకు వెళ్లి తన కుమార్తెలను పెళ్ళి చేసుకోబోయే తన అల్లుళ్ళతో మాట్లాడి, “త్వరపడండి, ఈ స్థలాన్ని విడిచిపెట్టి రండి, యెహోవా దీనిని నాశనం చేయబోతున్నారు” అని అన్నాడు. అయితే వారికి తన మాటలు హేళనగా అనిపించాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","తెల్లవారుజామున ఆ దూతలు లోతుతో, “త్వరగా, ఇక్కడున్న నీ భార్యను, నీ ఇద్దరు కుమార్తెలను తీసుకుని బయలుదేరు లేదా ఈ పట్టణం శిక్షించబడినప్పుడు మీరు కూడా నాశనమవుతారు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","లోతు సంశయిస్తుండగా ఆ మనుష్యులు లోతును, అతని భార్యను, ఇద్దరు కుమార్తెలను చేయి పట్టుకుని పట్టణం బయటకు తీసుకువచ్చారు, ఎందుకంటే యెహోవా వారిపై కనికరం చూపారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","వారిని బయటకు తీసుకువచ్చిన వెంటనే, వారిలో ఒకరు, “మీ ప్రాణాల కోసం పారిపోండి! వెనుకకు చూడకండి, మైదానంలో ఎక్కడ ఆగకండి! పర్వతాల వైపు పారిపోండి లేదా మీరు తుడిచివేయబడతారు!” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","కానీ లోతు వారితో, “నా ప్రభువులారా! దయచేసి అలా కాదు, ");
INSERT INTO telotsa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","మీ సేవకుడు మీ దృష్టిలో దయ పొందాడు, మీ దయ వలన మీరు నా ప్రాణం కాపాడారు. అయితే నేను పర్వతాలకు వెళ్లను; ఈ విపత్తు నా మీదికి వచ్చి నేను చస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","చూడండి, నేను తప్పించుకోడానికి ఇక్కడ ఒక చిన్న పట్టణం ఉంది. దానిలోకి వెళ్లనివ్వండి అది చిన్నగా ఉంది కదా, అప్పుడు నా ప్రాణం రక్షింపబడుతుంది” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ఆ దూత, “మంచిది, ఈ మనవి కూడా అంగీకరిస్తున్నాను; నీవు చెప్పే ఈ పట్టణాన్ని నాశనం చేయను. ");
INSERT INTO telotsa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","కాని అక్కడికి త్వరగా పారిపోండి, ఎందుకంటే మీరు అక్కడికి చేరేవరకు నేను ఏమి చేయలేను” అని అన్నాడు. అందుకే ఆ పట్టణానికి సోయరు అని పేరు పెట్టబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","లోతు సోయరు చేరే లోపు ఆ ప్రాంతంలో సూర్యుడు ఉదయించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","అప్పుడు యెహోవా సొదొమ గొమొర్రాల మీద అగ్ని గంధకాలు కురిపించారు; యెహోవా దగ్గర నుండి ఆకాశం నుండి అవి కురిపించబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","అలా ఆయన ఆ పట్టణాలను, ఆ మైదానమంతటిని ఆ పట్టణాల్లో నివసించే వారినందరిని ఆ ప్రాంతంలో ఉన్న నేల మొలకలతో సహా నాశనం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","అయితే లోతు భార్య వెనుకకు తిరిగింది, ఆమె ఉప్పు స్తంభంగా మారిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","మర్నాడు వేకువజామున అబ్రాహాము లేచి అంతకుముందు యెహోవా ఎదుట తాను నిలిచిన స్థలానికి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","సొదొమ గొమొర్రాల వైపు, ఆ మైదానమంతటిని చూశాడు, ఆ స్థలం నుండి కొలిమిలో నుండి వచ్చే పొగలా పొగ రావడం చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","దేవుడు మైదానంలోని పట్టణాలను నాశనం చేసినప్పుడు, ఆయన అబ్రాహామును జ్ఞాపకం చేసుకున్నారు, లోతును, తాను నివసించిన ఆ పట్టణాలను పడగొట్టిన విపత్తు నుండి అతన్ని తప్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","లోతు, అతని ఇద్దరు కుమార్తెలు సోయరును విడిచి పర్వతాల్లో స్థిరపడ్డారు ఎందుకంటే సోయరులో ఉండడానికి అతడు భయపడ్డాడు. అతడు, అతని కుమార్తెలిద్దరు ఒక గుహలో నివసించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ఒక రోజు అతని పెద్దకుమార్తె తన చెల్లెలితో, “మన తండ్రి వృద్ధుడు, ఈ లోకమర్యాద ప్రకారం మనకు పిల్లలను ఇవ్వడానికి ఈ చుట్టుప్రక్కల పురుషులెవ్వరు లేరు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","మన తండ్రికి ద్రాక్షరసం త్రాగించి, అతనితో పడుకుని మన తండ్రి ద్వార కుటుంబ వంశావళిని కాపాడదాం” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ఆ రాత్రి వారు తమ తండ్రికి ద్రాక్షరసం త్రాగించారు, పెద్దకుమార్తె అతనితో పడుకుంది. ఆమె ఎప్పుడు పడుకుందో ఎప్పుడు లేచి వెళ్లిందో అతనికి తెలియలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","మర్నాడు పెద్దకుమార్తె తన చెల్లెలితో, “నిన్న రాత్రి తండ్రితో పడుకున్నాను. ఈ రోజు మరలా అతడు ద్రాక్షరసం త్రాగేలా చేద్దాం, నీవు వెళ్లి అతనితో పడుకో, అలా మన తండ్రి ద్వారా మన కుటుంబ వంశావళిని కాపాడదాం” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ఆ రాత్రి కూడా తమ తండ్రి ద్రాక్షరసం త్రాగేలా చేశారు, చిన్న కుమార్తె అతనితో పడుకుంది. ఈసారి కూడా ఆమె ఎప్పుడు పడుకుందో ఎప్పుడు లేచి వెళ్లిందో అతనికి తెలియలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","అలా లోతు ఇద్దరు కుమార్తెలు తమ తండ్రి వలన గర్భవతులయ్యారు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","పెద్దకుమార్తెకు కుమారుడు పుట్టాడు, ఆమె అతనికి మోయాబు అని పేరు పెట్టింది; నేడు ఇతడు మోయాబీయులకు మూలపురుషుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","చిన్నకుమార్తెకు కూడా కుమారుడు పుట్టాడు, ఆమె అతనికి బెన్-అమ్మి అని పేరు పెట్టింది; నేడు ఇతడు అమ్మోనీయులకు మూలపురుషుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","అబ్రాహాము అక్కడినుండి దక్షిణాదికి ప్రయాణం చేసి కాదేషుకు, షూరుకు మధ్య నివాసం ఉన్నాడు. కొంతకాలం గెరారులో ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","అక్కడ అబ్రాహాము తన భార్య శారాను గురించి, “ఈమె నా చెల్లెలు” అని చెప్పాడు. అప్పుడు గెరారు రాజైన అబీమెలెకు శారాను తన రాజభవనం లోనికి రప్పించుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","అయితే ఆ రాత్రి కలలో దేవుడు అబీమెలెకుకు కనిపించి, “నీవు తీసుకున్న స్త్రీ కారణంగా నీవు చచ్చినట్టే ఎందుకంటే ఆమె ఇంకొకని భార్య” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","అబీమెలెకు ఆమెను సమీపించలేదు. కాబట్టి అతడు, “ప్రభువా, మీరు ఒక నిర్దోషులైన జనాన్ని నాశనం చేస్తారా? ");
INSERT INTO telotsa_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‘ఆమె నా సోదరి’ అని అతడు చెప్పలేదా? ‘ఇతడు నా అన్న’ అని ఆమె కూడా చెప్పలేదా? నేను నిర్మలమైన మనస్సాక్షితో నిర్దోషిగా ఉండి దీన్ని చేశాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","అప్పుడు దేవుడు అతనితో కలలో ఇలా అన్నారు, “అవును, నీవు నిర్మలమైన మనస్సాక్షితో చేశావని నాకు తెలుసు, అందుకే నీవు పాపం చేయకుండా ఆపాను. అందుకే నీవామెను ముట్టుకోకుండా చేశాను. ");
INSERT INTO telotsa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ఇప్పుడు ఆ మనుష్యుని భార్యను తనకు ఇవ్వు, అతడు ప్రవక్త కాబట్టి నీకోసం ప్రార్థన చేస్తాడు, నీవు బ్రతుకుతావు. ఒకవేళ ఆమెను తిరిగి ఇవ్వకపోతే, నీవు, నీకు సంబంధించిన వారందరు చస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","మర్నాడు వేకువజామున అబీమెలెకు తన అధికారులను పిలిపించి, వారితో ఏమి జరిగిందో చెప్పాడు, వారు ఎంతో భయపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","అప్పుడు అబీమెలెకు అబ్రాహామును పిలిపించి, “నీవు మాకు చేసింది ఏంటి? నీ పట్ల నేను ఏ తప్పు చేశానని ఇంత గొప్ప అపరాధం నాపైన, నా రాజ్యం పైన తెచ్చావు? నీవు నా పట్ల చేసినవి ఎవరు చేయకూడనివి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","అబీమెలెకు, “నీవు ఇలా చేయడానికి కారణమేంటి?” అని అబ్రాహామును అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","అందుకు అబ్రాహాము అన్నాడు, “ఈ స్థలంలో దేవుని భయం లేదు, ‘నా భార్యను బట్టి వారు నన్ను చంపేస్తారు’ అని నాలో నేను అనుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","అంతేకాదు, ఆమె నిజంగా నా సోదరి, నా తండ్రికి కుమార్తె కాని నా తల్లికి కాదు; ఆమె నా భార్య అయ్యింది. ");
INSERT INTO telotsa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","దేవుడు నన్ను నా తండ్రి ఇంటి నుండి తిరిగేలా చేసినప్పుడు, నేను ఆమెతో ఇలా చెప్పాను, ‘మనం వెళ్లే ప్రతిచోటా నా గురించి, “ఈయన నా సోదరుడు” అని చెప్పు, ఇది నా పట్ల నీ ప్రేమ.’ ” ");
INSERT INTO telotsa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","అప్పుడు అబీమెలెకు గొర్రెలను, పశువులను, దాసదాసీలను అబ్రాహాముకు ఇచ్చాడు. అబ్రాహాము భార్యయైన శారాను కూడా తిరిగి అప్పగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","అబీమెలెకు, “నా దేశం నీ ఎదుట ఉన్నది; నీకు ఇష్టమైన చోట నీవు నివసించవచ్చు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","అతడు శారాతో, “నీ అన్నకు వెయ్యి షెకెళ్ళ వెండి ఇస్తున్నాను, ఇది నీతో ఉన్న వారందరి ఎదుట నీకు విరోధంగా చేసిన దానికి నష్టపరిహారం; నీవు పూర్తిగా నిర్దోషివి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","అప్పుడు అబ్రాహాము దేవునికి ప్రార్థన చేశాడు, దేవుడు అబీమెలెకును, అతని భార్య, అతని ఆడ దాసీలను స్వస్థపరచగా వారు తిరిగి పిల్లలు కన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ఎందుకంటే యెహోవా అబ్రాహాము భార్య శారాను బట్టి అబీమెలెకు ఇంట్లోని స్త్రీలందరిని పిల్లలు కనలేకుండా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","యెహోవా తాను చెప్పినట్టే శారా పట్ల కృప చూపించారు, శారాకు వాగ్దానం చేసినట్టే యెహోవా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","సరిగ్గా దేవుడు వాగ్దానం చేసిన నిర్ణీత కాలంలో శారా గర్భవతియై, వృద్ధాప్యంలో ఉన్న అబ్రాహాముకు కుమారున్ని కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","అబ్రాహాము, శారా తన కోసం కన్న కుమారునికి ఇస్సాకు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","దేవుని ఆజ్ఞమేరకు తన కుమారుడైన ఇస్సాకుకు ఎనిమిదో రోజున అబ్రాహాము సున్నతి చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ఇస్సాకు పుట్టినప్పుడు అబ్రాహాము నూరు సంవత్సరాల వృద్ధుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","శారా, “నాకు దేవుడు నవ్వు తెప్పించారు, ఇది వినే ప్రతివారు నాతో నవ్వుతారు, ");
INSERT INTO telotsa_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","శారా పిల్లలకు పాలిస్తుందని అబ్రాహాముతో ఎవరు అంటారు? అయినా నా భర్తకు వృద్ధాప్యంలో కుమారున్ని కన్నాను” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ఇస్సాకు పాలు విడిచిన రోజు అబ్రాహాము పెద్ద విందు చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","అయితే ఈజిప్టు దాసి హాగరు ద్వార అబ్రాహాముకు పుట్టిన కుమారుడు శారాను హేళన చేయడం చూసి, ");
INSERT INTO telotsa_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ఆమె అబ్రాహాముతో, “ఆ దాసిని దాని కుమారున్ని పంపివేయండి, దాని కుమారుడు ఎప్పటికీ నా కుమారునితో వారసత్వం పంచుకోలేడు” అని శారా చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","తన కుమారునికి సంబంధించిన విషయం కాబట్టి అబ్రాహాము చాలా బాధపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","అయితే దేవుడు అబ్రాహాముతో, “ఈ బాలుని గురించి, నీ దాసి గురించి నీవు బాధపడకు. శారా చెప్పినట్టు నీవు చేయి, ఎందుకంటే ఇస్సాకు మూలంగానే నీ సంతానం లెక్కించబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","అయితే దాసి కుమారుడు కూడా నీ సంతానమే కాబట్టి అతన్ని కూడా గొప్ప జనంగా చేస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","మర్నాడు వేకువజామున అబ్రాహాము లేచి కొంత ఆహారం, నీళ్ల తిత్తి హాగరుకు ఇచ్చాడు. వాటిని ఆమె భుజం మీద పెట్టి, ఆమెను తన కుమారునితో పంపివేశాడు. ఆమె వెళ్లి బెయేర్షేబ ఎడారిలో తిరుగుతూ ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","తిత్తిలో నీళ్లు అయిపోయినప్పుడు ఆమె ఆ పిల్లవాన్ని ఒక పొద క్రింద ఉంచింది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","తర్వాత ఆమె కొంత దూరం వెళ్లి కూర్చుంది, ఎందుకంటే, “బాలుడు చావడం నేను చూడలేను” అని అనుకుంది. అక్కడ కూర్చుని అదుపు లేకుండ ఏడవసాగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","దేవుడు చిన్నవాని మొర విన్నారు, దేవదూత పరలోకం నుండి హాగరును పిలిచి, “హాగరూ! ఏమైంది? భయపడకు; బాలుడు అక్కడ పడి ఏడ్వడం దేవుడు విన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ఆ పిల్లవాన్ని లేపి నీ చేతితో పట్టుకో, నేను అతన్ని గొప్ప జనంగా చేస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","అప్పుడు దేవుడు ఆమె కళ్లు తెరిచారు, ఆమె నీళ్ల ఊటను చూసింది. ఆమె వెళ్లి తిత్తిని నీళ్లతో నింపి బాలునికి త్రాగడానికి ఇచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ఆ పిల్లవాడు ఎదుగుతుండగా దేవుడు అతనితో ఉన్నారు. అతడు ఎడారిలో నివసిస్తూ విలుకాడయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","అతడు పారాను ఎడారిలో నివసిస్తున్నప్పుడు అతని తల్లి ఈజిప్టు నుండి అతనికి భార్యను తీసుకువచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ఆ సమయంలో అబీమెలెకు, అతని సేనాధిపతి ఫీకోలు వచ్చి, అబ్రాహాముతో ఇలా అన్నారు, “నీవు చేసే పనులన్నిటిలో దేవుడు నీతో ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","కాబట్టి నీవు నాతో గాని నా పిల్లలతో గాని నా వారసులతో గాని మోసపూరితంగా వ్యవహరించవని దేవుని ఎదుట నాతో ప్రమాణం చేయి. నీవు పరదేశిగా ఉంటున్న ఈ దేశంలో నేను చూపించిన దయ నాకు, ఈ దేశానికి చూపించు.” ");
INSERT INTO telotsa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","అబ్రాహాము, “నేను ప్రమాణం చేస్తున్నా” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","అప్పుడు అబీమెలెకు దాసులు అంతకుముందు ఒక బావిని ఆక్రమించుకున్న విషయాన్ని అబ్రాహాము అబీమెలెకుకు చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","అయితే అబీమెలెకు, “ఇది ఎవరు చేశారో నాకు తెలియదు. నీవు నాకు చెప్పలేదు, ఈ రోజే ఈ సంగతి వింటున్నాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","అబ్రాహాము గొర్రెలు పశువులు తీసుకువచ్చి అబీమెలెకుకు ఇచ్చాడు, ఆ ఇద్దరు ఒక ఒప్పందం చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","అబ్రాహాము తన మంద నుండి ఏడు ఆడ గొర్రెపిల్లలను వేరు చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","అబీమెలెకు, “నీవు స్వయంగా వేరు చేసిన ఈ ఏడు ఆడ గొర్రెపిల్లలకు అర్థం ఏంటి?” అని అబ్రాహామును అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","అందుకు అతడు, “నేను ఈ బావిని త్రవ్వించాను అనడానికి సాక్ష్యంగా ఈ ఏడు ఆడ గొర్రెపిల్లలను నా చేతి నుండి అంగీకరించు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","అక్కడ వారిద్దరు ఒప్పందం చేసుకున్నారు. కాబట్టి ఆ స్థలానికి బెయేర్షేబ అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","బెయేర్షేబ దగ్గర ఒప్పందం చేసుకున్న తర్వాత అబీమెలెకు, సేనాధిపతియైన ఫీకోలు ఫిలిష్తీయుల దేశానికి తిరిగి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","అబ్రాహాము బెయేర్షేబలో ఒక పిచుల వృక్షం నాటాడు, అక్కడ నిత్య దేవుడైన యెహోవా నామాన్ని ఆరాధించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","అబ్రాహాము ఫిలిష్తీయుల దేశంలో చాలా కాలం పరదేశిగా ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","కొంతకాలం తర్వాత దేవుడు అబ్రాహామును పరీక్షించారు. ఆయన, “అబ్రాహామూ!” అని పిలిచారు. “చిత్తం! ప్రభువా” అని అతడు జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","అప్పుడు దేవుడు ఇలా అన్నారు, “నీ ఏకైక కుమారున్ని, అంటే నీవు ప్రేమించే ఇస్సాకును మోరీయా ప్రదేశానికి తీసుకెళ్లు. నేను నీకు చూపబోయే పర్వతం మీద అతన్ని దహనబలిగా అర్పించు.” ");
INSERT INTO telotsa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","మర్నాడు వేకువజామున అబ్రాహాము లేచి గాడిదకు గంతలు కట్టి ఇద్దరు పనివారిని, తన కుమారుడైన ఇస్సాకును తీసుకుని బయలుదేరాడు. దహనబలి కోసం కట్టెలు కొట్టుకుని దేవుడు చూపిన స్థలం వైపు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","మూడవ రోజు అబ్రాహాము కళ్ళెత్తి దూరం నుండి ఆ స్థలాన్ని చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","అబ్రాహాము తన పనివారితో, “మీరు గాడిదతో ఇక్కడ ఉండండి, నేను, ఈ చిన్నవాడు అక్కడికి వెళ్లి, ఆరాధించి తిరిగి వస్తాం” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","అబ్రాహాము దహనబలి కోసం కట్టెలు తీసుకుని తన కుమారుడైన ఇస్సాకు మీద పెట్టాడు, అతడు నిప్పును కత్తిని పట్టుకుని వెళ్లాడు. వారిద్దరు కలసి నడిచి వెళ్తున్నప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ఇస్సాకు తన తండ్రియైన అబ్రాహాముతో, “తండ్రీ” అని పిలిచాడు. “నా కుమారుడా, ఏంటి?” అని అబ్రాహాము జవాబిచ్చాడు. ఇస్సాకు, “నిప్పు కట్టెలు ఉన్నాయి. కాని దహనబలి కోసం కావలసిన గొర్రెపిల్ల ఎక్కడ?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","“నా కుమారుడా, దేవుడే స్వయంగా దహనబలి కోసం గొర్రెపిల్లను ఇస్తారు” అని అబ్రాహాము జవాబిచ్చాడు. వారిద్దరు కలిసి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","దేవుడు నిర్దేశించిన స్థలం వారు చేరుకున్నాక, అబ్రాహాము అక్కడ ఒక బలిపీఠం కట్టాడు, దాని మీద కట్టెలు పేర్చాడు. తన కుమారుడైన ఇస్సాకును బంధించి, కట్టెల మీద పడుకోబెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","తర్వాత అబ్రాహాము తన కుమారున్ని బలి ఇవ్వడానికి చేయి చాపి కత్తి పట్టుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","అయితే యెహోవా దూత ఆకాశం నుండి, “అబ్రాహామూ! అబ్రాహామూ!” అని పిలిచాడు. “చిత్తం ప్రభువా” అని అతడు జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“ఆ బాలుని మీద చేయివేయకు అతన్ని ఏమీ చేయకు. నీవు దేవునికి భయపడతావని ఇప్పుడు నాకు తెలుసు, ఎందుకంటే నీ ఏకైక కుమారున్ని నాకు ఇవ్వడానికి వెనుదీయలేదు!” అని దేవుని దూత మాట్లాడాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","అబ్రాహాము కళ్ళెత్తి చూశాడు, ఆ పొదలో కొమ్ములు చిక్కుకుని ఉన్న పొట్టేలు కనిపించింది. అక్కడికి వెళ్లి ఆ పొట్టేలును తెచ్చి తన కుమారునికి బదులు దహనబలి అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","అబ్రాహాము ఆ స్థలానికి, యెహోవా యీరే అని పేరు పెట్టాడు. ఇప్పటికీ, “యెహోవా పర్వతం మీద సమకూర్చబడుతుంది” అని చెప్పబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","యెహోవా దూత రెండవసారి అబ్రాహాముతో ఇలా అన్నాడు, ");
INSERT INTO telotsa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“యెహోవా ప్రకటిస్తున్నారు, నా మీద నేను ప్రమాణం చేసి చెప్తున్నాను, నీవిలా నీ ఏకైక కుమారున్ని ఇవ్వడానికి వెనుకాడలేదు కాబట్టి, ");
INSERT INTO telotsa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","నిశ్చయంగా నేను నిన్ను దీవిస్తాను, నీ సంతానాన్ని లెక్కించలేని ఆకాశ నక్షత్రాల్లా సముద్ర ఒడ్డు మీద ఇసుక రేణువుల్లా విస్తరింపజేస్తాను. నీ సంతతివారు వారి శత్రువుల పట్టణాలను స్వాధీనం చేసుకుంటారు, ");
INSERT INTO telotsa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","నీ సంతానం ద్వారా భూమి మీద ఉన్న సర్వ దేశాలు దీవించబడతాయి, ఎందుకంటే నీవు నాకు లోబడ్డావు.” ");
INSERT INTO telotsa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","తర్వాత అబ్రాహాము తన పనివారి దగ్గరకు తిరిగి వెళ్లాడు, వారు కలిసి బెయేర్షేబకు వెళ్లారు. అబ్రాహాము బెయేర్షేబలో నివసించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","కొంతకాలం తర్వాత, అబ్రాహాముకు ఇలా చెప్పబడింది, “మిల్కా కూడా తల్లి అయ్యింది; నీ సోదరుడు నాహోరుకు ఆమె జన్మనిచ్చిన కుమారులు: ");
INSERT INTO telotsa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","మొదటి కుమారుడు ఊజు, అతని తమ్ముడు బూజు, కెమూయేలు (అరాము ఇతని కుమారుడు), ");
INSERT INTO telotsa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","కెసెదు, హజో, పిల్దాషు, యిద్లాపు, బెతూయేలు.” ");
INSERT INTO telotsa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","బెతూయేలు రిబ్కాకు తండ్రి అయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","రయూమా అనే అతని ఉంపుడుగత్తె కూడా కుమారులు కన్నది: తెబహు, గహము, తహషు, మయకా. ");
INSERT INTO telotsa_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","శారా నూట ఇరవై ఏడు సంవత్సరాలు జీవించింది. ");
INSERT INTO telotsa_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ఆమె కనాను దేశంలోని కిర్యత్-అర్బా అనగా హెబ్రోనులో చనిపోయింది, అబ్రాహాము శారా కోసం దుఃఖపడడానికి, ఏడ్వడానికి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","తర్వాత అబ్రాహాము చనిపోయిన తన భార్య మృతదేహం దగ్గర నుండి లేచి హిత్తీయులతో మాట్లాడుతూ, ");
INSERT INTO telotsa_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“నేను మీ మధ్య విదేశీయునిగా, అపరిచితునిగా ఉన్నాను. చనిపోయిన నా భార్యను పాతిపెట్టడానికి నాకు కొంత భూమి అమ్మండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","హిత్తీయులు అబ్రాహాముకు జవాబిస్తూ, ");
INSERT INTO telotsa_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“అయ్యా, మేము చెప్పేది వినండి, మీరు మా మధ్య దేవుని రాజకుమారునిలా ఉన్నారు. సమాధి స్థలాల్లో మీకు నచ్చిన దానిలో మీరు పాతిపెట్టండి. మాలో ఎవ్వరూ మిమ్మల్ని ఆపరు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","అప్పుడు అబ్రాహాము లేచి ఆ దేశ ప్రజలైన హిత్తీయుల ఎదుట తలవంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","వారితో ఇలా అన్నాడు, “మీరు నా భార్య మృతదేహాన్ని పాతిపెట్టడానికి సమ్మతిస్తే, సోహరు కుమారుడైన ఎఫ్రోనుకు చెందిన పొలం చివర మక్పేలా గుహ ఉంది, నా తరపున అతనితో మాట్లాడి, ఆ స్థలం నాకు మీ మధ్యలో ఉండే సమాధి స్థలంగా పూర్తి వెలకు అమ్ముమని అడగండి.” ");
INSERT INTO telotsa_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","హిత్తీయుడైన ఎఫ్రోను అక్కడే తన ప్రజలమధ్య కూర్చుని, పట్టణ గవినికి వచ్చిన హిత్తీయులందరి సమక్షంలో అబ్రాహాముకు ఇలా జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“నా ప్రభువా, అలా కాదు, నా మాట వినండి; ప్రజలందరి సమక్షంలో నేను పొలాన్ని ఇస్తాను, అందులోని గుహను ఇస్తాను. మీరు పాతి పెట్టుకోండి.” ");
INSERT INTO telotsa_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","మళ్ళీ అబ్రాహాము ఆ దేశ ప్రజలందరి ఎదుట తలవంచాడు, ");
INSERT INTO telotsa_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","అతడు ఆ దేశ ప్రజలందరూ వినేలా ఎఫ్రోనుతో, “నా మాట విను, పొలం యొక్క వెల నేను చెల్లిస్తాను. నా భార్య మృతదేహాన్ని అక్కడ నేను పాతిపెట్టేలా నా నుండి అది అంగీకరించు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","ఎఫ్రోను అబ్రాహాముకు జవాబిస్తూ, “నా ప్రభువా, మా మాట వినండి; దాని ఖరీదు నాలుగు వందల షెకెళ్ళ వెండి, అయితే నాకు మీకు మధ్య అదెంత? మీ భార్య మృతదేహాన్ని పాతిపెట్టండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","అబ్రాహాము ఎఫ్రోను చెప్పినట్టే ఒప్పుకుని, హిత్తీయుల వినికిడిలో వ్యాపారుల కొలత ప్రకారం నాలుగు వందల షెకెళ్ళ వెండి తూచి అతనికి ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","మమ్రే దగ్గర మక్పేలాలో ఉన్న ఎఫ్రోను పొలం అందులో ఉన్న గుహ ఆ పొలం సరిహద్దులో ఉన్న అన్ని చెట్లు ");
INSERT INTO telotsa_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","పట్టణ గవిని దగ్గర ఉన్న హిత్తీయుల సమక్షంలో అబ్రాహాము పేర దస్తావేజు చేయబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","అప్పుడు అబ్రాహాము కనాను దేశంలో, హెబ్రోనులో ఉన్న మమ్రే దగ్గర ఉన్న మక్పేలా పొలం లోని గుహలో తన భార్య శారా మృతదేహాన్ని పాతిపెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","కాబట్టి ఆ పొలం, అందులోని గుహ, హిత్తీయుల వలన స్మశాన వాటికగా అబ్రాహాము పేరు మీద వ్రాయబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","అబ్రాహాము చాలా వృద్ధుడయ్యాడు, యెహోవా అతన్ని అన్ని విధాలుగా ఆశీర్వదించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","అబ్రాహాము తన ఇంట్లో గృహనిర్వాహకుడైన ముఖ్య సేవకునితో, “నీ చేయి నా తొడ క్రింద పెట్టు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","4","నేను ఎవరి మధ్య నివసిస్తున్నానో ఆ కనానీయుల కుమార్తెలలో నుండి నా కుమారునికి భార్యను తీసుకురావని, నా దేశం, నా బంధువుల దగ్గరకు వెళ్లి వారిలో నుండి నా కుమారుడైన ఇస్సాకుకు భార్యను తీసుకువస్తావని భూమ్యాకాశాలకు దేవుడైన యెహోవా పేరిట ప్రమాణం చేయి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","అందుకు ఆ సేవకుడు, “ఒకవేళ ఆ స్త్రీ ఈ దేశానికి రావడానికి ఇష్టపడకపోతే ఏం చేయాలి? నీవు వచ్చిన ఆ దేశానికి నీ కుమారున్ని తీసుకెళ్లాలా?” అని అతన్ని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","అబ్రాహాము, “ఖచ్చితంగా నా కుమారున్ని అక్కడికి తీసుకెళ్లకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","నా తండ్రి ఇంటి నుండి, నా స్వదేశం నుండి బయటకు తీసుకువచ్చి, ‘నీ సంతానానికి ఈ దేశాన్ని ఇస్తాను’ అని వాగ్దానం చేసిన పరలోక దేవుడైన యెహోవాయే నా కుమారునికి భార్యను అక్కడినుండి తీసుకువచ్చేలా తన దూతను నీకు ముందుగా పంపుతారు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ఒకవేళ ఆ స్త్రీ నీ వెంట రావడానికి ఇష్టపడకపోతే ఈ ప్రమాణం నుండి నీవు నిర్దోషివి, కాని నా కుమారున్ని మాత్రం అక్కడికి తీసుకెళ్లకూడదు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ఆ సేవకుడు ఈ విషయమై తన యజమానియైన అబ్రాహాము తొడ క్రింద చేయి పెట్టి ప్రమాణం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","అప్పుడు ఆ సేవకుడు యజమాని ఒంటెల్లో పది ఒంటెలను, యజమాని యొక్క అన్ని రకాల శ్రేష్ఠమైన వస్తు సముదాయాన్ని తీసుకుని బయలుదేరాడు. అతడు అరాము నహరయీముకు బయలుదేరి, నాహోరు పట్టణం చేరాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","పట్టణం బయట ఉన్న బావి దగ్గర ఒంటెలను మోకరింపజేశాడు; అది సాయంకాలం, స్త్రీలు నీళ్లు చేదుకోడానికి వచ్చే సమయము. ");
INSERT INTO telotsa_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","అప్పుడు అతడు ఇలా ప్రార్థన చేశాడు, “యెహోవా! నా యజమానియైన అబ్రాహాము దేవా, నేను వచ్చిన పని ఈ రోజు సఫలం చేయండి, నా యజమాని అబ్రాహాముపై దయ చూపండి. ");
INSERT INTO telotsa_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","నేను ఈ నీటి ఊట దగ్గర నిలబడి ఉన్నాను, ఈ పట్టణవాసుల కుమార్తెలు నీళ్లు తోడుకోడానికి వస్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","నేను వారిలో ఒక యవ్వన స్త్రీతో, ‘నీ కడవ క్రిందికి వంచు, నేను నీళ్లు త్రాగుతాను’ అని అడిగినప్పుడు, ఏ స్త్రీ అయితే, ‘ఇదిగో త్రాగండి, మీ ఒంటెలకు కూడా నీళ్లు తోడి పోస్తాను’ అని అంటుందో, ఆమె నీ సేవకుడైన ఇస్సాకుకు మీరు ఎంచుకున్న స్త్రీ అయి ఉండాలి. దీనిని బట్టి నా యజమాని పట్ల మీరు దయ చూపారు అని గ్రహిస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","అతడు ప్రార్థన ముగించకముందే రిబ్కా కడవ భుజంపై పెట్టుకుని వచ్చింది. ఆమె అబ్రాహాము సోదరుడు నాహోరు యొక్క భార్యయైన మిల్కా దంపతులకు పుట్టిన బెతూయేలు కుమార్తె. ");
INSERT INTO telotsa_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","రిబ్కా చాలా అందమైన కన్యక; ఏ మనుష్యుడు ఆమెతో శయనించలేదు. ఆమె బావిలోనికి దిగివెళ్లి తన కుండలో నీళ్లు నింపుకుని పైకి వచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ఆ సేవకుడు పరుగెత్తుకుంటూ ఆమె దగ్గరకు వెళ్లి, “నీ కుండలోని నీళ్లు కొన్ని నాకు త్రాగడానికి ఇవ్వు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“అయ్యా త్రాగండి” అని అంటూ రిబ్కా వెంటనే కుండను చేతి మీదికి దించుకుని, అతనికి నీళ్లు ఇచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","అతనికి నీళ్లు ఇచ్చిన తర్వాత, “మీ ఒంటెలకు కూడా, వాటికి సరిపడే నీళ్లు చేది పోస్తాను” అని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","కాబట్టి ఆమె త్వరపడి తన కుండలో నీళ్లు తొట్టిలో పోసి, పరుగెత్తుకుంటూ మళ్ళీ బావి దగ్గరకు వెళ్లి, ఒంటెలన్నిటికి సరిపడే నీళ్లు చేది పోసింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ఆ సేవకుడు ఒక్క మాట మాట్లాడకుండా, యెహోవా తన ప్రయాణం సఫలం చేశారా లేదా అని ఆమెను గమనిస్తూ ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ఒంటెలు నీళ్లు త్రాగిన తర్వాత, అతడు ఒక బెకా బరువుగల బంగారం ముక్కుపుడక, పది షెకెళ్ళ బరువుగల రెండు బంగారు కడియాలు చేతిలో పట్టుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","అప్పుడతడు, “నీవెవరి కుమార్తెవు? దయచేసి చెప్పు, ఈ రాత్రి నీ తండ్రి ఇంట్లో మేము గడపడానికి స్థలం ఉందా?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","అందుకు ఆమె, “నేను మిల్కా నాహోరులకు పుట్టిన బెతూయేలు కుమార్తెను” అని జవాబిచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","“మీరు బసచేయడానికి కావలసిన స్థలం, మీ ఒంటెలకు మేత కూడా మా ఇంట్లో ఉంది” అని కూడా చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","అప్పుడు ఆ మనుష్యుడు తలవంచి యెహోవాను ఆరాధిస్తూ, ");
INSERT INTO telotsa_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“నా యజమానియైన అబ్రాహాము దేవుడైన యెహోవాకు స్తుతి, ఆయన నా యజమానికి తన దయను, తన నమ్మకత్వాన్ని చూపడం మానలేదు. నా మట్టుకైతే, యెహోవా నా ప్రయాణాన్ని సఫలపరచి నా యజమాని బంధువుల ఇంటికి నన్ను నడిపించారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ఆ యవ్వన స్త్రీ పరుగెత్తుకుంటూ వెళ్లి తన తల్లి ఇంటివారికి ఈ సంగతులన్ని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","రిబ్కాకు లాబాను అనే సోదరుడు ఉన్నాడు, అతడు వెంటనే నీటిబుగ్గ దగ్గర ఉన్న ఆ వ్యక్తిని కలవడానికి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","లాబాను రిబ్కా ధరించిన ముక్కుపుడక, చేతి కడియాలు చూసి, ఆ వ్యక్తి రిబ్కాతో మాట్లాడినదంతా ఆమె తన వారితో చెప్పినప్పుడు, వెంటనే ఆ వ్యక్తిని కలవడానికి వెళ్లి, ఆ బావి దగ్గర తన ఒంటెలతో నిలబడి ఉండడం చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“యెహోవా వలన ఆశీర్వదించబడినవాడా, లోపలికి రా, నీవు బయటే ఎందుకు నిలబడ్డావు? నీవు బసచేయడానికి ఇల్లును, ఒంటెలకు స్థలాన్ని సిద్ధం చేశాను” అని అతడు అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","కాబట్టి ఆ వ్యక్తి ఆ ఇంటికి వెళ్లి, ఒంటెల మీది నుండి బరువును దించారు. వాటికి మేత వేశారు, అతనికి, అతనితో ఉన్న మనుష్యులందరికి కాళ్లు కడుక్కోడానికి నీళ్లు ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","అతనికి భోజనం వడ్డించారు కాని అతడు, “నేను వచ్చిన పని ఏంటో మీకు చెప్పకుండా నేను తినను” అని అన్నాడు. అందుకు లాబాను, “అయితే చెప్పు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","అప్పుడు అతడు, “నేను అబ్రాహాము సేవకుడను. ");
INSERT INTO telotsa_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","యెహోవా నా యజమానిని ఎంతో దీవించారు కాబట్టి అతడు చాలా ధనికుడయ్యాడు. అతనికి గొర్రెలను, మందలను, వెండి బంగారాలను, దాసదాసీలను, ఒంటెలను, గాడిదలను ఆయన ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","నా యజమాని భార్య శారా తన వృద్ధాప్యంలో కుమారున్ని కన్నది, తన ఆస్తినంతటిని అతనికి ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","నా యజమాని నాతో ప్రమాణం చేయించి, ‘నీవు నా కుమారునికి నేను నివసించే కనానీయుల కుమార్తెలలో నుండి భార్యను తీసుకురాకూడదు, ");
INSERT INTO telotsa_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","అయితే నా తండ్రి ఇంటికి, నా బంధువుల దగ్గరకు వెళ్లి, నా కుమారునికి భార్యను తీసుకురా’ అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“అందుకు నేను, ‘ఒకవేళ ఆమె నాతో రాకపోతే ఎలా?’ అని నా యజమానిని అడిగాను. ");
INSERT INTO telotsa_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“అందుకతడు జవాబిస్తూ, ‘నేను ఇంతవరకు ఎవరి ఎదుట నమ్మకంగా జీవించానో, ఆ యెహోవా తన దూతను నీకు ముందుగా పంపి నీ ప్రయాణం విజయవంతం చేస్తారు, కాబట్టి నీవు నా సొంత వంశస్థులలో నుండి నా తండ్రి ఇంటి నుండి నా కుమారుని కోసం భార్యను తీసుకువస్తావు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","నీవు మా వంశస్థుల దగ్గరకు వెళ్లినప్పుడు ఒకవేళ వారు ఆమెను ఇవ్వడానికి ఒప్పుకోకపోతే, నీకు ఈ ప్రమాణం నుండి విముక్తి’ అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“ఈ రోజు నేను నీటిబుగ్గ దగ్గరకు వచ్చినప్పుడు, ‘యెహోవా, నా యజమానియైన అబ్రాహాము దేవా! మీకు ఇష్టమైతే, నా ప్రయాణం సఫలం చేయండి. ");
INSERT INTO telotsa_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ఇదిగో, నేను ఈ నీటిబుగ్గ దగ్గర నిలబడి ఉన్నప్పుడు ఒకవేళ ఒక యువతి నీళ్ల చేదుకోడానికి వస్తే, నేను, “దయచేసి త్రాగడానికి నీ కుండ నుండి కొన్ని నీళ్లు ఇవ్వు” అని నేను అడిగితే, ");
INSERT INTO telotsa_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ఏ యువతైతే, “త్రాగండి, మీ ఒంటెలకు కూడా నీళ్లు తోడి పోస్తాను” అని అంటుందో, ఆ యువతే యెహోవా నా యజమాని కుమారునికి భార్య కావాలి’ అని నేను ప్రార్థన చేశాను. ");
INSERT INTO telotsa_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“నేను నా హృదయంలో ఇంకా ప్రార్థన ముగించకముందే, రిబ్కా తన కుండను భుజంపై పెట్టుకుని రావడం నేను చూశాను. ఆమె బావిలోనికి దిగివెళ్లి నీళ్లు తోడుకున్న తర్వాత, ఆమెతో, ‘దయచేసి త్రాగడానికి నాకు నీళ్లు ఇవ్వు’ అని అడిగాను. ");
INSERT INTO telotsa_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“త్వరగా ఆమె కడవ భుజం మీది నుండి దింపుకుని, ‘త్రాగండి, మీ ఒంటెలకు కూడా నీళ్లు ఇస్తాను’ అని అన్నది. కాబట్టి నేను త్రాగాను ఒంటెలకు కూడా ఆమె నీళ్లు పోసింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“అప్పుడు నేను, ‘నీవు ఎవరి కుమార్తెవు?’ అని అడిగాను. “అందుకు ఆమె, ‘మిల్కా నాహోరులకు పుట్టిన బెతూయేలు కుమార్తెను’ అని చెప్పింది. “అప్పుడు నేను ఆమెకు ముక్కు పుడకను, చేతులకు కడియాలు ఇచ్చి, ");
INSERT INTO telotsa_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","తలవంచి నేను యెహోవాను ఆరాధించాను; నా యజమాని సోదరుని మనవరాలిని తన కుమారునికి భార్యగా తీసుకురావడానికి నన్ను సరియైన మార్గంలో నడిపించిన నా యజమాని అబ్రాహాముకు దేవుడైన యెహోవాను స్తుతించాను. ");
INSERT INTO telotsa_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ఇప్పుడు మీరు నా యజమాని పట్ల దయను, నమ్మకత్వాన్ని చూపాలనుకున్నా, ఒకవేళ లేదు అనుకున్నా చెప్పండి. అప్పుడు నేను ఏ మార్గంలో వెళ్లాలో తెలుసుకుంటాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","అప్పుడు లాబాను, బెతూయేలు ఇలా జవాబిచ్చారు, “ఇది యెహోవా చేసిన కార్యం; ఈ విషయంలో మేము చెప్పేది ఏమి లేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ఇదిగో రిబ్కా, ఆమెను తీసుకెళ్లండి. యెహోవా సూచించినట్లే ఆమె నీ యజమాని కుమారునికి భార్య అవును గాక.” ");
INSERT INTO telotsa_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","అబ్రాహాము సేవకుడు ఈ మాటలు విని, యెహోవా ఎదుట నేల మీద సాష్టాంగపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","తర్వాత ఆ వ్యక్తి వెండి, బంగారు నగలు, వస్త్రాలు రిబ్కాకు ఇచ్చాడు; అతడు ఆమె సోదరునికి, ఆమె తల్లికి కూడా విలువైన కానుకలిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","అప్పుడు అతడు, అతని మనుష్యులు భోజనం చేసి ఆ రాత్రి అక్కడే గడిపారు. మర్నాడు ఉదయం వారు లేచినప్పుడు, అతడు, “నా దారిన నన్ను నా యజమాని దగ్గరకు పంపివేయండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","అయితే ఆమె తల్లి సోదరుడు, “యువతిని కనీసం పదిరోజులైనా మా దగ్గర ఉండనివ్వండి, ఆ తర్వాత ఆమె వెళ్లిపోవచ్చు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","కాని అతడు, “యెహోవా నా ప్రయాణం సఫలం చేశారు, కాబట్టి ఆలస్యం చేయకుండా నన్ను పంపివేయండి, నా యజమాని దగ్గరకు నేను వెళ్తాను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","అప్పుడు వారు, “యువతిని పిలిచి ఆమె ఏమంటుందో అడుగుదాం” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","కాబట్టి వారు రిబ్కాను పిలిచి, “ఇతనితో నీవు వెళ్తావా?” అని అడిగారు. అందుకు ఆమె, “నేను వెళ్తాను” అని జవాబిచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","కాబట్టి వారు తమ సోదరి రిబ్కాను, ఆమెకు తోడుగా దాదిని, అబ్రాహాము సేవకుని, అతనితో వచ్చిన మనుష్యులను పంపివేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","వారు రిబ్కాను దీవించి ఆమెతో ఇలా అన్నారు, “మా సోదరీ, నీవు వర్ధిల్లాలి, వేవేల మందికి తల్లివి కావాలి; నీ సంతానపు వారు తమ శత్రువుల పట్టణాలను స్వాధీనం చేసుకోవాలి.” ");
INSERT INTO telotsa_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","అప్పుడు రిబ్కా, ఆమె పరిచారకులు సిద్ధపడి, ఒంటెలు ఎక్కి ఆ మనుష్యునితో పాటు వెళ్లారు. అలా ఆ సేవకుడు రిబ్కాను తీసుకుని వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ఇప్పుడు ఇస్సాకు బెయేర్-లహాయి-రోయి నుండి వచ్చాడు, ఎందుకంటే అతడు దక్షిణాదిలో నివాసముంటున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ఒక రోజు సాయంకాలం అతడు ధ్యానం చేసుకోవడానికి పొలానికి వెళ్లాడు; ఆ సమయంలో ఇస్సాకు తేరిచూడగా, అతనికి ఒంటెలు వస్తున్నట్లు కనిపించాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","రిబ్కా తలెత్తి ఇస్సాకును చూసి, ఒంటె మీది నుండి క్రిందికి దిగి, ");
INSERT INTO telotsa_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“మనలను కలవడానికి పొలంలో నుండి వస్తున్న అతడు ఎవరు?” అని ఆ సేవకుని అడిగింది. అందుకతడు, “అతడే నా యజమాని” అని అన్నాడు. ఆమె తన తలమీద ముసుగు వేసుకుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ఆ సేవకుడు జరిగినదంతా ఇస్సాకుకు చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ఇస్సాకు తన తల్లియైన శారా గుడారం లోనికి ఆమెను తీసుకెళ్లి, ఆమెను పెళ్ళి చేసుకున్నాడు. ఇలా రిబ్కా అతని భార్య అయ్యింది. అతడు ఆమెను ప్రేమించాడు; ఇలా తల్లి మరణం చేత బాధతో ఉన్న ఇస్సాకుకు రిబ్కా ద్వార ఓదార్పు కలిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","అబ్రాహాము కెతూరా అనే మరొక స్త్రీని పెళ్ళి చేసుకున్నాడు, ");
INSERT INTO telotsa_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ఆమె అతనికి కన్న కుమారులు జిమ్రాను, యొక్షాను, మెదాను, మిద్యాను, ఇష్బాకు, షూవహు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","యొక్షాను కుమారులు షేబ, దేదాను; అష్షూరీయులు, లెతూషీయులు, లెయుమీయులు దేదాను వారసులు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ఏఫా, ఏఫెరు, హనోకు, అబీదా, ఎల్దాయా మిద్యాను కుమారులు. వీరంతా కెతూరా సంతానము. ");
INSERT INTO telotsa_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","అబ్రాహాము తనకున్నదంతా ఇస్సాకుకు ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","అయితే అబ్రాహాము ఇంకా బ్రతికి ఉండగానే తన ఉపపత్నులకు పుట్టిన కుమారులకు బహుమానాలిచ్చి, వారినందరిని తన కుమారుడైన ఇస్సాకు దగ్గర నుండి తూర్పు ప్రాంతాలకు పంపివేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","అబ్రాహాము నూట డెబ్బై సంవత్సరాలు జీవించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","అబ్రాహాము తన వృద్ధాప్యంలో, సంవత్సరాలు నిండిన వృద్ధునిగా తుది శ్వాస విడిచి చనిపోయాడు; తన పూర్వికుల దగ్గరకు చేర్చబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","అతని కుమారులు ఇస్సాకు, ఇష్మాయేలులు కలిసి తమ తండ్రిని మమ్రే దగ్గర ఉన్న మక్పేలా గుహలో సమాధి చేశారు. అది హిత్తీయుడైన సోహరు కుమారుడైన ఎఫ్రోను పొలము. ");
INSERT INTO telotsa_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","అబ్రాహాము ఆ పొలాన్ని హిత్తీయుల దగ్గర కొన్నాడు. అందులో అబ్రాహాము తన భార్యయైన శారాతో పాటు పాతిపెట్టబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","అబ్రాహాము మృతి చెందిన తర్వాత, దేవుడు అతని కుమారుడైన ఇస్సాకును ఆశీర్వదించారు, అప్పుడు అతడు బెయేర్-లహాయి-రోయి దగ్గర నివసించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","శారా దాసి, ఈజిప్టుకు చెందిన హాగరు, అబ్రాహాముకు కన్న ఇష్మాయేలు కుటుంబ వంశావళి: ");
INSERT INTO telotsa_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ఇష్మాయేలు కుమారులు, వారు పుట్టిన క్రమం ప్రకారం వారి పేర్లు: ఇష్మాయేలు యొక్క మొదటి కుమారుడు నెబాయోతు, కేదారు, అద్బీయేలు, మిబ్శాము, ");
INSERT INTO telotsa_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","మిష్మా, దూమా, మశ్శా, ");
INSERT INTO telotsa_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","హదదు, తేమా, యెతూరు, నాపీషు, కెదెమా. ");
INSERT INTO telotsa_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","వీరు ఇష్మాయేలు కుమారులు, వారి వారి స్థావరాలలో, శిబిరాలలో, తమ తమ జనాంగాలకు పన్నెండుగురు గోత్ర పాలకుల పేర్లు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ఇష్మాయేలు నూట ముప్పై ఏడు సంవత్సరాలు జీవించాడు. తన తుది శ్వాస విడిచి చనిపోయాడు, తన పూర్వికుల దగ్గరకు చేర్చబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","అతని వారసులు అష్షూరు వైపు వెళ్లే మార్గంలో హవీలా నుండి ఈజిప్టు సరిహద్దు దగ్గర ఉన్న షూరు వరకు ఉన్న ప్రాంతంలో స్థిరపడ్డారు. వారు తమ సోదరులందరికి విరోధంగా నివసించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","అబ్రాహాము కుమారుడైన ఇస్సాకు వంశావళి. అబ్రాహాము కుమారుడు ఇస్సాకు, ");
INSERT INTO telotsa_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ఇస్సాకు పద్దనరాములోని సిరియావాడైన బెతూయేలు కుమార్తె, లాబాను సోదరియైన రిబ్కాను పెళ్ళి చేసుకున్నప్పుడు అతని వయస్సు నలభై సంవత్సరాలు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","రిబ్కాకు సంతానం కలుగలేదు కాబట్టి ఇస్సాకు ఆమె గురించి యెహోవాకు ప్రార్థన చేశాడు, యెహోవా అతని ప్రార్థనకు జవాబిచ్చారు, అతని భార్య రిబ్కా గర్భవతి అయ్యింది. ");
INSERT INTO telotsa_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ఆమె గర్భంలో పిల్లలు ఒకరితో ఒకరు పెనుగులాడారు, అందుకు ఆమె, “నాకెందుకు ఇలా జరుగుతుంది?” అని అంటూ యెహోవాను అడగడానికి వెళ్లింది. ");
INSERT INTO telotsa_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","యెహోవా ఆమెతో ఇలా చెప్పారు, “నీ గర్భంలో రెండు జనాంగాలు ఉన్నాయి, ఈ రెండు జనాంగాలు నీ గర్భం నుండే వేరుగా ఉంటాయి; ఒక జనం మరొక జనం కంటే బలంగా ఉంటారు. పెద్దవాడు చిన్నవానికి సేవ చేస్తాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ఆమె ప్రసవ కాలం సమీపించినప్పుడు, ఆమె గర్భంలో కవలపిల్లలు ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","మొదట పుట్టినవాడు ఎర్రగా ఉన్నాడు, అతని శరీరమంతా రోమాల వస్త్రంలా ఉంది; కాబట్టి అతనికి ఏశావు అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","తర్వాత అతని సోదరుడు, అతని మడిమెను పట్టుకుని బయటకు వచ్చాడు, అతనికి యాకోబు అని పేరు పెట్టారు. రిబ్కా వారికి జన్మనిచ్చినప్పుడు ఇస్సాకు వయస్సు అరవై సంవత్సరాలు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","అబ్బాయిలు పెరిగారు, ఏశావు అరణ్యంలో తిరుగుతూ నేర్పుగల వేటగాడయ్యాడు. యాకోబు నెమ్మదస్థుడై గుడారాల్లో నివసించేవాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ఇస్సాకు వేటాడిన మాంసం కోరుకునేవాడు, అతడు ఏశావును ప్రేమించేవాడు, కానీ రిబ్కా యాకోబును ప్రేమించేది. ");
INSERT INTO telotsa_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ఒక రోజు యాకోబు వంటకం చేస్తున్నపుడు, ఏశావు పొలం నుండి బాగా ఆకలితో వచ్చి, ");
INSERT INTO telotsa_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","“నేను చాలా ఆకలితో ఉన్నాను, నీవు వండుచున్న ఆ ఎర్రని కూర కొంచెం నాకు పెట్టు!” అని అడిగాడు, (అందుకే అతనికి ఎదోము అని పేరు వచ్చింది.) ");
INSERT INTO telotsa_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","యాకోబు, “అలా అయితే మొదట నీ జ్యేష్ఠత్వపు హక్కు నాకు అమ్ము” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","అప్పుడు ఏశావు, “నేను ఆకలితో చస్తూ ఉంటే నాకు జ్యేష్ఠత్వం దేనికి ఉపయోగం?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","అయితే యాకోబు, “ముందు నాకు ప్రమాణం చేయి” అన్నాడు. కాబట్టి ఏశావు తన జ్యేష్ఠత్వపు హక్కును యాకోబుకు అమ్మివేస్తున్నట్టుగా ప్రమాణం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","అప్పుడు యాకోబు కొంత రొట్టె, కొంత కాయధాన్యం వంటకం ఏశావుకు ఇచ్చాడు. అతడు తిని త్రాగి లేచి వెళ్లిపోయాడు. ఈ విధంగా ఏశావు తన జ్యేష్ఠత్వాన్ని తృణీకరించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ఆ దేశంలో అబ్రాహాము కాలంలో వచ్చిన కరువు కాక మరో కరువు వచ్చింది. అప్పుడు ఇస్సాకు గెరారులోని ఫిలిష్తీయుల రాజైన అబీమెలెకు దగ్గరకు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","యెహోవా ఇస్సాకుకు ప్రత్యక్షమై ఇలా అన్నారు, “నీవు ఈజిప్టుకు వెళ్లకు; నేను చెప్పిన దేశంలోనే నివసించు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","కొంతకాలం ఈ దేశంలోనే ఉండు, నేను నీకు తోడుగా ఉండి, నిన్ను ఆశీర్వదిస్తాను. నీకు నీ వారసులకు ఈ దేశాలన్నీ ఇస్తాను, నీ తండ్రియైన అబ్రాహాముతో నేను చేసిన ప్రమాణం నెరవేరుస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","నీ వారసులను ఆకాశంలోని అనేక నక్షత్రాల్లా విస్తరింపజేసి ఈ దేశాలన్నీ వారికిస్తాను, నీ సంతానం ద్వారా సమస్త భూప్రజలు ఆశీర్వదించబడతారు, ");
INSERT INTO telotsa_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ఎందుకంటే అబ్రాహాము నా మాట విని, నేను చెప్పింది చేశాడు, నా ఆజ్ఞలను, కట్టడలను, సూచనలను పాటించాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","కాబట్టి ఇస్సాకు గెరారులో నివసించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","అక్కడి మనుష్యులు అతని భార్యను చూసి ఆమె ఎవరు అని అతన్ని అడిగితే, “ఆమె నా సోదరి” అని చెప్పాడు, ఎందుకంటే, “ఆమె నా భార్య” అని చెప్పడానికి భయపడ్డాడు. “రిబ్కా అందంగా ఉంది కాబట్టి తనను బట్టి ఈ స్థలం యొక్క మనుష్యులు నన్ను చంపేస్తారు” అని అతడు అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ఇస్సాకు అక్కడ చాలా కాలం ఉన్నాడు, ఒక రోజు ఫిలిష్తీయుల రాజు అబీమెలెకు కిటికీలో నుండి ఇస్సాకు తన భార్య రిబ్కాతో సరసాలాడడం చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","కాబట్టి అబీమెలెకు ఇస్సాకును పిలిపించి, “నిజంగా ఈమె నీ భార్య కదా! ‘ఆమె నా సోదరి’ అని ఎందుకు చెప్పావు?” అని అడిగాడు. ఇస్సాకు, “ఆమె కారణంగా నా ప్రాణం పోతుందేమో అని అనుకున్నాను” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","అప్పుడు అబీమెలెకు, “నీవు మా పట్ల చేసినదేంటి? ఈ మనుష్యుల్లో ఎవరైనా ఆమెతో శయనించి ఉండేవారు. అప్పుడు నీవు మాపైన అపరాధం తెచ్చిపెట్టేవాడివి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","అప్పుడు అబీమెలెకు ప్రజలందరికి ఆదేశించాడు: “ఎవరైనా ఈ మనుష్యునికి లేదా అతని భార్యకు హాని చేస్తే, వారికి మరణశిక్ష విధించబడును.” ");
INSERT INTO telotsa_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ఇస్సాకు ఆ దేశంలో విత్తనాలు విత్తాడు, యెహోవా అతన్ని దీవించారు కాబట్టి, అదే సంవత్సరం అతనికి నూరంతల పంట వచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","అతడు ధనికుడయ్యాడు, అతడు ఎంతో గొప్పవాడయ్యే వరకు అతని ఆస్తి వృద్ధిచెందుతూ ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","అతనికి మందలు, పశువులు, దాసులు ఎక్కువగా ఉన్నందుకు ఫిలిష్తీయులు అసూయపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","అతని తండ్రియైన అబ్రాహాము కాలంలో అతని దాసులు త్రవ్విన బావులన్ని ఫిలిష్తీయులు మట్టితో నింపి పూడ్చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","అబీమెలెకు ఇస్సాకుతో, “నీవు ఇక్కడినుండి వెళ్లిపో; మాకంటే చాలా బలవంతుడవు అయ్యావు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","కాబట్టి ఇస్సాకు అక్కడినుండి గెరారు లోయకు వెళ్లి, గుడారం వేసుకుని అక్కడ స్థిరపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","తన తండ్రి అబ్రాహాము కాలంలో త్రవ్వించిన బావులను అతడు చనిపోయాక ఫిలిష్తీయులు పూడ్చేసిన వాటిని ఇస్సాకు తిరిగి త్రవ్వించాడు, వాటికి తన తండ్రి పెట్టిన అవే పేర్లు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ఇస్సాకు సేవకులు గెరారు లోయలో కూడా త్రవ్వినప్పుడు మంచి నీళ్ల బావి కనుగొన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","అయితే గెరారు కాపరులు ఇస్సాకు కాపరులతో గొడవపడి, “ఈ నీళ్లు మావి!” అని అన్నారు. వారు జగడమాడారు కాబట్టి ఇస్సాకు ఆ బావికి ఏశెకు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","తర్వాత వారు మరో బావి త్రవ్వారు, కానీ దాని కోసం కూడా గొడవపడ్డారు; కాబట్టి ఆ బావికి శిత్నా అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","అతడు అక్కడినుండి వెళ్లి మరో బావి త్రవ్వించాడు, దాని కోసం ఎలాంటి గొడవ జరగలేదు. అతడు, “ఇప్పుడు యెహోవా మాకు స్థలం ఇచ్చారు, మేము ఈ దేశంలో వర్ధిల్లుతాము” అని ఆ బావికి రహెబోతు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","అక్కడినుండి అతడు బెయేర్షేబకు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ఆ రాత్రి యెహోవా ఇస్సాకుకు ప్రత్యక్షమై, “నేను నీ తండ్రి అబ్రాహాము దేవుడను. భయపడకు, నేను నీతో ఉన్నాను; నా సేవకుడైన అబ్రాహామును బట్టి నేను నిన్ను ఆశీర్వదిస్తాను, సంఖ్యాపరంగా నీ వారసులను విస్తరింపజేస్తాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ఇస్సాకు అక్కడ బలిపీఠం కట్టి యెహోవాను ఆరాధించాడు. అక్కడ తన గుడారం వేసుకున్నాడు, అక్కడే తన సేవకులు బావి త్రవ్వారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ఇంతలో అబీమెలెకు, అతని స్నేహితుడు అహుజతు, సేనాధిపతి ఫీకోలు, గెరారు నుండి ఇస్సాకు దగ్గరకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ఇస్సాకు వారిని, “మీరెందుకు నా దగ్గరకు వచ్చారు, నాకు వ్యతిరేకంగా ఉంటూ నన్ను పంపివేశారు కదా?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","వారు జవాబిస్తూ ఇలా అన్నారు, “యెహోవా నీతో ఉండడం మేము స్పష్టంగా చూశాం; కాబట్టి, ‘మాకు నీకు మధ్య ప్రామాణిక ఒప్పందం ఉండాలి’ అని మేము అనుకున్నాము. కాబట్టి మనం ఒప్పందం చేసుకుందాము. ");
INSERT INTO telotsa_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","మేము నీకు ఏ హాని చేయలేదు కాని మిమ్మల్ని మంచిగా చూసుకుని సమాధానంతో పంపించాం, కాబట్టి నీవు మాకు ఏ హాని చేయకూడదు. ఇప్పుడు నీవు యెహోవాచేత ఆశీర్వదించబడ్డావు.” ");
INSERT INTO telotsa_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","అప్పుడు ఇస్సాకు వారికి విందు చేశాడు, వారు తిని త్రాగారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","మర్నాడు వేకువజామున వారు లేచి, ఒకరితో ఒకరు ప్రమాణం చేసుకున్నారు. తర్వాత ఇస్సాకు వారిని సాగనంపాడు, వారు అక్కడినుండి సమాధానంతో వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ఆ రోజు ఇస్సాకు సేవకులు వచ్చి అతనితో వారు త్రవ్విన మరో బావి గురించి ఇలా చెప్పారు. వారు, “మాకు నీళ్లు కనిపించాయి!” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","అతడు ఆ బావికి షేబ అని పేరు పెట్టాడు, అందుకే ఇప్పటివరకు ఆ పట్టణం పేరు బెయేర్షేబ. ");
INSERT INTO telotsa_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ఏశావు నలభై సంవత్సరాల వయస్సులో, హిత్తీయుడైన బెయేరి కుమార్తె యహూదీతును, హిత్తీయుడైన ఎలోను కుమార్తె బాశెమతును పెళ్ళి చేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ఈ ఇద్దరు ఇస్సాకు రిబ్కాల దుఃఖానికి కారకులయ్యారు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ఇస్సాకు వృద్ధుడైనప్పుడు, అతడు ఇక చూడలేనంతగా తన కళ్ళు మసకబారినప్పుడు, తన పెద్దకుమారుడైన ఏశావును, “నా కుమారుడా” అని పిలిచాడు. అతడు, “చిత్తం, నేను ఉన్నాను” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ఇస్సాకు ఇలా అన్నాడు, “నేను వృద్ధున్ని అని నాకు తెలుసు, నేను ఎప్పుడు చనిపోతానో నాకు తెలియదు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","కాబట్టి నీవు నీ ఆయుధాలను అంటే నీ అంబులపొదిని విల్లును తీసుకుని అడవికి వెళ్లి జంతువును వేటాడి నాకు మాంసం తెచ్చిపెట్టు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","నాకు ఇష్టమైన భోజనం రుచిగా సిద్ధం చేసి తీసుకురా, నేను చనిపోకముందు తిని నిన్ను దీవిస్తాను” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","అయితే ఇస్సాకు తన కుమారుడైన ఏశావుతో మాట్లాడుతున్నప్పుడు రిబ్కా విన్నది. ఏశావు వేటాడేందుకు బహిరంగ పొలానికి వెళ్లిపోయాక, ");
INSERT INTO telotsa_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","రిబ్కా తన కుమారుడైన యాకోబుతో, “ఇదిగో, నీ తండ్రి నీ అన్న ఏశావుతో చెప్పడం నేను విన్నాను, ");
INSERT INTO telotsa_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘నేను చనిపోకముందు దానిని తిని యెహోవా సన్నిధిలో నిన్ను దీవిస్తాను’ అందుకు నీవు నా కోసం వేటాడి మాంసం తెచ్చి రుచికరమైన భోజనం సిద్ధం చేసి తీసుకురా అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","కాబట్టి నా కుమారుడా! నా మాట జాగ్రతగా విని, నేను చెప్పినట్టు చేయి: ");
INSERT INTO telotsa_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","మన మందలో నుండి రెండు మంచి మేక పిల్లలను తీసుకురా, నేను నీ తండ్రికి ఇష్టమైన భోజనం వండి పెడతాను. ");
INSERT INTO telotsa_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","అప్పుడు నీ తండ్రి తినడానికి దానిని తీసుకెళ్లు, అప్పుడు అతడు చనిపోకముందు నిన్ను దీవిస్తాడు” అని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","యాకోబు తన తల్లి రిబ్కాతో, “నా అన్న ఏశావు వెంట్రుకలు గలవాడు, నాకు నునుపైన చర్మం ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ఒకవేళ నా తండ్రి నన్ను తాకిచూస్తే ఎలా? అతన్ని మోసం చేసినవాడనై, నా మీదికి ఆశీర్వాదానికి బదులు శాపం తెచ్చుకున్నవాన్ని అవుతాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","అతని తల్లి అతనితో, “నా కుమారుడా, ఆ శాపం నా మీదికే రానివ్వు. కేవలం నేను చెప్పింది చేయి; వెళ్లి వాటిని నా కోసం తీసుకురా” అని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","కాబట్టి అతడు వెళ్లి వాటిని తన తల్లి దగ్గరకు తెచ్చాడు, ఆమె అతని తండ్రికి ఇష్టమైన భోజనం వండింది. ");
INSERT INTO telotsa_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","తర్వాత రిబ్కా ఇంట్లో ఉన్న తన పెద్దకుమారుడైన ఏశావు యొక్క శ్రేష్ఠమైన బట్టలు తీసుకుని తన చిన్న కుమారుడైన యాకోబుకు తొడిగించింది. ");
INSERT INTO telotsa_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ఆమె అతని చేతులను, మెడ దగ్గర ఉండే నునుపైన భాగాలను మేక చర్మంతో కప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","తర్వాత తాను చేసిన రుచిగల భోజనాన్ని, రొట్టెలను యాకోబు చేతికి ఇచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","యాకోబు తన తండ్రి దగ్గరకు వెళ్లి, “నా తండ్రి” అని పిలిచాడు. “నా కుమారుడా, నీవెవరివి?” అని అతడు అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","యాకోబు తన తండ్రితో, “నేను నీ మొదటి కుమారుడనైన ఏశావును, నీవు చెప్పిన ప్రకారం నేను చేశాను. నన్ను ఆశీర్వదించడానికి లేచి, నేను చేసింది తిను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ఇస్సాకు తన కుమారున్ని, “నా కుమారుడా, ఇంత త్వరగా నీకు ఎలా దొరికింది?” అని అడిగాడు. యాకోబు, “నీ దేవుడైన యెహోవా నా దగ్గరకు దానిని తీసుకువచ్చారు” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","అప్పుడు ఇస్సాకు యాకోబుతో, “నా కుమారుడా, నా దగ్గరకు రా, నేను నిన్ను ముట్టుకొని, నీవు నిజంగా ఏశావువో కాదో తెలుసుకుంటాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","యాకోబు తండ్రి దగ్గరకు వెళ్లగా, ఇస్సాకు అతన్ని తాకిచూసి, “స్వరం యాకోబు స్వరంలా ఉంది, కాని చేతులు ఏశావులా ఉన్నాయి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","యాకోబు చేతులు తన అన్న ఏశావులా రోమాలు కలిగి ఉన్నాయి కాబట్టి అతడు గుర్తు పట్టలేదు; కాబట్టి అతన్ని దీవించడం ప్రారంభించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“నీవు నిజంగా నా కుమారుడైన ఏశావువేనా?” అని అతడు అడిగాడు. “అవును నేనే” అని అతడు జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","అప్పుడు అతడు, “నా కుమారుడా, నీవు వండింది కొంత తీసుకురా, నేను తిని నిన్ను దీవిస్తాను” అని అన్నాడు. యాకోబు తెచ్చాడు, అతడు తిన్నాడు; ద్రాక్షరసం తెచ్చాడు, అతడు త్రాగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","అప్పుడు అతని తండ్రి ఇస్సాకు యాకోబుతో, “నా కుమారుడా, దగ్గరకు వచ్చి నాకు ముద్దుపెట్టు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","కాబట్టి అతడు దగ్గరకు వెళ్లి అతనికి ముద్దుపెట్టాడు. ఇస్సాకు కుమారుని వస్త్రాల వాసనను పసిగట్టి, అతన్ని ఇలా దీవించాడు, “ఆహా, నా కుమారుని వాసన యెహోవా దీవించిన పొలం యొక్క సువాసన ");
INSERT INTO telotsa_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","దేవుడు నీకు ఆకాశపు మంచును, భూమి యొక్క సారాన్ని, సమృద్ధికరమైన ధాన్యాన్ని, నూతన ద్రాక్షరసాన్ని ఇచ్చును గాక. ");
INSERT INTO telotsa_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","జనాంగాలు నీకు సేవ చేయాలి, జనాలు నీకు తలవంచాలి. నీ సోదరులకు నీవు ప్రభువుగా ఉంటావు, నీ తల్లి యొక్క కుమారులు నీకు తలవంచాలి. నిన్ను శపించేవారు శపించబడతారు నిన్ను దీవించే వారు దీవించబడతారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ఇస్సాకు అతన్ని దీవించడం ముగించిన తర్వాత, యాకోబు తండ్రి దగ్గర నుండి వెళ్లీ వెళ్లకముందే, తన సోదరుడు ఏశావు వేటనుండి వచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","అతడు కూడా రుచిగల భోజనం వండుకొని తన తండ్రి దగ్గరకు తీసుకువచ్చాడు. అప్పుడతడు, “నా తండ్రి, నన్ను దీవించడానికి నేను వేటాడి తెచ్చిన మాంసంతో సిద్ధం చేసిన భోజనం తిను” అని అతనితో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","అప్పుడు తన తండ్రి ఇస్సాకు, “నీవెవరివి?” అని అడిగాడు. అందుకతడు, “నేను నీ కుమారున్ని, నీ మొదటి సంతానమైన ఏశావును” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ఇస్సాకు గజగజ వణకుతూ ఇలా అన్నాడు, “మరీ ఇంతకుముందు వేట మాంసం తెచ్చి పెట్టింది ఎవరు? నీవు రాకముందే నేను తిని అతన్ని దీవించాను; నిజంగా అతడు దీవించబడతాడు!” ");
INSERT INTO telotsa_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","తన తండ్రి మాట విన్న వెంటనే ఏశావు దుఃఖంతో బిగ్గరగా ఏడ్చి, “నన్ను కూడా దీవించు, నా తండ్రి!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","అయితే అతడు, “నీ తమ్ముడు మోసపూరితంగా వచ్చి నీ దీవెనను తీసుకున్నాడు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ఏశావు, “అతనికి యాకోబు అని సరిగ్గానే పేరు పెట్టారు కదా? నన్ను అతడు మోసగించడం ఇది రెండవసారి: నా జ్యేష్ఠత్వం తీసుకున్నాడు, ఇప్పుడు నా దీవెనను దొంగిలించాడు! నా కోసం ఒక్క దీవెన కూడా మిగలలేదా?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ఇస్సాకు జవాబిస్తూ, “నేను అతన్ని నీపై ప్రభువుగా నియమించాను, అతని బంధువులందరినీ అతనికి దాసులుగా చేశాను, సమృద్ధిగా ధాన్యం, ద్రాక్షరసం అతనికి సమకూర్చాను. కాబట్టి నా కుమారుడా! ఇప్పుడు నీకోసం నేను ఏమి చేయగలను?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","అందుకు ఏశావు తన తండ్రితో, “నా తండ్రి, ఒక్క దీవెననే ఉన్నదా? నా తండ్రి, నన్ను కూడా దీవించు!” అని అంటూ గట్టిగా ఏడ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","అప్పుడు ఇస్సాకు అతనికి జవాబిస్తూ ఇలా అన్నాడు, “నీ నివాసం సారవంతమైన భూమికి దూరంగా, పైనున్న ఆకాశం యొక్క మంచుకు దూరంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","నీవు నీ ఖడ్గం చేత జీవిస్తావు నీ సోదరునికి సేవ చేస్తావు, అయితే నీవు విశ్రాంతి లేక ఉన్నప్పుడు, నీ మెడ మీద నుండి అతని కాడి విరిచి పడవేస్తావు.” ");
INSERT INTO telotsa_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","తన తండ్రి యాకోబుకిచ్చిన దీవెనను బట్టి ఏశావు తన సోదరుని మీద పగబెట్టుకున్నాడు, “నా తండ్రిని గురించి దుఃఖించే రోజులు సమీపంగా ఉన్నాయి; తర్వాత నా సోదరుడైన యాకోబును చంపేస్తా” అని తనకు తాను అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","రిబ్కా తన పెద్దకుమారుడైన ఏశావు ఏమన్నాడో తెలుసుకుని, తన చిన్న కుమారుడైన యాకోబును పిలిపించి అతనితో ఇలా అన్నది, “నీ అన్న ఏశావు నిన్ను చంపి ప్రతీకారం తీర్చుకోవాలని ఆలోచిస్తున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","కాబట్టి నా కుమారుడా! నేను చెప్పేది విను: హారానులో ఉన్న నా సోదరుడైన లాబాను దగ్గరకు పారిపో. ");
INSERT INTO telotsa_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","మీ అన్న కోపం తగ్గే వరకు అక్కడ కొంతకాలం అతని దగ్గరే ఉండు. ");
INSERT INTO telotsa_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","అతని కోపం చల్లారి, నీవు అతనికి చేసింది అతడు మరచిపోయిన తర్వాత, నేను నీకు కబురు పెడతాను. ఒక్క రోజే మీ ఇద్దరిని ఎందుకు పోగొట్టుకోవాలి?” ");
INSERT INTO telotsa_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","తర్వాత రిబ్కా ఇస్సాకుతో, “ఈ హిత్తీయుల స్త్రీల వలన నేను విసిగిపోయాను. యాకోబు కూడా ఇలాంటి హిత్తీయుల స్త్రీలలా ఈ దేశ స్త్రీని భార్యగా చేసుకుంటే, ఇక నేను బ్రతికి లాభం లేదు” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ఇస్సాకు యాకోబును పిలిపించి అతన్ని ఆశీర్వదించాడు. అప్పుడు తనకు ఇలా ఆజ్ఞాపించాడు: “కనాను స్త్రీని పెళ్ళి చేసుకోవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","వెంటనే పద్దనరాములో నీ తల్లికి తండ్రియైన బెతూయేలు ఇంటికి వెళ్లు. అక్కడ నీ తల్లి సోదరుడైన లాబాను కుమార్తెలలో ఒకరిని భార్యగా చేసుకో. ");
INSERT INTO telotsa_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","సర్వశక్తిగల దేవుడు నిన్ను దీవించి, నిన్ను ఫలభరితంగా చేసి, జనాంగాల సమాజంగా విస్తరించేలా సంఖ్యాపరంగా వృద్ధి చేయును గాక. ");
INSERT INTO telotsa_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ఆయన నీకును, నీ వారసులకు అబ్రాహాముకు ఇచ్చిన ఆశీర్వాదం ఇచ్చును గాక, తద్వార నీవు పరదేశిగా ఉన్న ఈ దేశాన్ని, దేవుడు అబ్రాహాముకు ఇచ్చిన దేశాన్ని నీవు స్వాధీనం చేసుకుంటావు.” ");
INSERT INTO telotsa_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","తర్వాత ఇస్సాకు యాకోబును పంపివేశాడు. అతడు పద్దనరాముకు, యాకోబు ఏశావుల తల్లియైన రిబ్కా సోదరుడైన లాబాను దగ్గరకు వెళ్లాడు. లాబాను సిరియావాడైన బెతూయేలు కుమారుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","ఇస్సాకు యాకోబును దీవించి పద్దనరాముకు పంపి అక్కడే అతడు భార్యను చూసుకోవాలని, “కనాను స్త్రీని పెళ్ళి చేసుకోవద్దు” అని చెప్పాడని, యాకోబు తన తల్లిదండ్రులకు లోబడి పద్దనరాముకు వెళ్లాడని ఏశావు తెలుసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","అప్పుడు ఏశావు కనాను స్త్రీలంటే తన తండ్రి ఇస్సాకుకు ఇష్టం లేదని గ్రహించాడు; ");
INSERT INTO telotsa_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","కాబట్టి అతడు తనకున్న భార్యలు కాక ఇష్మాయేలు దగ్గరకు వెళ్లి, అబ్రాహాము కుమారుడైన ఇష్మాయేలు కుమార్తె నెబాయోతు సోదరియైన మహలతును భార్యగా చేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","యాకోబు బెయేర్షేబను విడిచి హారాను వైపు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ఒక స్థలం చేరిన తర్వాత సూర్యాస్తమయం అయినందున రాత్రికి అక్కడే ఉండిపోయాడు. అక్కడే ఉన్న రాళ్లలో ఒకటి తీసుకుని, తలగడగా పెట్టుకుని పడుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","అతడు ఒక కల కన్నాడు, అందులో ఒక నిచ్చెన భూమి మీద నుండి ఆకాశాన్ని అంటి ఉంది. ఆ నిచ్చెన పైన దేవదూతలు ఎక్కుతూ దిగుతూ ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","దాని మీద యెహోవా నిలబడి ఇలా అన్నారు: “యెహోవాను నేనే, నీ తాత అబ్రాహాముకు దేవుడను, నీ తండ్రి ఇస్సాకుకు దేవుడను. నీవు పడుకుని ఉన్న ఈ భూమిని నీకు, నీ వారసులకు ఇస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","నీ సంతానం భూమిపై ఇసుక రేణువుల్లా అవుతారు, నీవు పడమర, తూర్పు, ఉత్తర, దక్షిణాలకు వ్యాపిస్తావు. భూమిపై ఉన్న సర్వ జనాంగాలు నీ ద్వార, నీ సంతానం ద్వార దీవించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","నేను నీతో ఉంటాను, నీవు వెళ్లే ప్రతీ చోట నిన్ను సంరక్షిస్తాను, ఈ దేశానికి మళ్ళీ రప్పిస్తాను. నేను నీకు వాగ్దానం చేసింది నెరవేర్చే వరకు నిన్ను విడువను.” ");
INSERT INTO telotsa_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","యాకోబు నిద్రలేచి, “ఖచ్చితంగా ఈ స్థలంలో యెహోవా ఉన్నారు, నేను అది గ్రహించలేకపోయాను” అని అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","అతడు భయపడి ఇలా అన్నాడు, “ఈ స్థలం ఎంత అద్భుతమైనది! ఇది దేవుని మందిరమే కాని ఇంకొకటి కాదు; ఇది పరలోక ద్వారము.” ");
INSERT INTO telotsa_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","మర్నాడు తెల్లవారినప్పుడు యాకోబు తన తలగడగా పెట్టుకున్న రాయిని తీసుకుని, దానిని స్తంభంగా నిలిపి, దాని మీదుగా నూనె పోశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ఆ స్థలానికి బేతేలు అని పేరు పెట్టాడు, ముందు ఆ పట్టణం లూజు అని పిలువబడేది. ");
INSERT INTO telotsa_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","22","తర్వాత యాకోబు మ్రొక్కుబడి చేస్తూ ఇలా అన్నాడు, “దేవుడు నాకు తోడుగా ఉండి నన్ను ఈ ప్రయాణంలో కాపాడి నాకు తినడానికి ఆహారం ఇచ్చి వేసుకోడానికి వస్త్రాలు ఇచ్చి నన్ను నా తండ్రి ఇంటికి క్షేమంగా చేరిస్తే, యెహోవాయే నా దేవుడుగా ఉంటారు, స్తంభంగా నేను నిలబెట్టిన ఈ రాయి దేవుని మందిరంగా ఉంటుంది. అంతేకాక, నీవు నాకు ఇచ్చే అంతటిలో నుండి నేను నీకు పదవ భాగం ఇస్తాను” అని ఆయనకు మ్రొక్కుబడి చేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","యాకోబు తన ప్రయాణం కొనసాగించి తూర్పు ప్రజల దేశానికి వచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","అక్కడ ఒక బహిరంగ పొలంలో అతనికి ఒక బావి కనిపించింది. అక్కడ మూడు గొర్రె మందలు దాని దగ్గర పడుకుని ఉన్నాయి, కాపరులు ఆ బావి నీళ్లు వాటికి పెడతారు. ఆ బావి మీద పెద్ద రాయి మూత పెట్టి ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","మందలన్నీ కూడి రాగానే కాపరులు ఆ బావి మీద నుండి రాయిని దొర్లించి, గొర్రెలకు నీళ్లుపెట్టి, రాయి మూతను తిరిగి బావి మీద పెడతారు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","యాకోబు కాపరులను చూసి, “సోదరులారా, మీరు ఎక్కడి వారు?” అని అడిగాడు. వారు, “మేము హారాను వారం” అని జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","అతడు, “నాహోరు మనవడు, లాబాను మీకు తెలుసా?” అని వారిని అడిగాడు. వారు, “అవును, తెలుసు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","అప్పుడు యాకోబు, “లాబాను క్షేమమేనా?” అని అడిగాడు. “అవును, అతడు క్షేమమే, అదిగో, అతని కుమార్తె రాహేలు గొర్రెల మందతో వస్తుంది” అని వారు చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","యాకోబు, “ఇంకా ప్రొద్దుగుంకలేదు; మందలను తీసుకెళ్లే సమయం కాలేదు. గొర్రెలకు నీళ్లు పెట్టుకోండి, వాటిని మేపుకోండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“మందలన్నీ పోగయ్యేవరకు వాటికి నీళ్లు పెట్టలేము. బావి మీది నుండి రాయి దొర్లిస్తారు, అప్పుడు మేము గొర్రెలకు నీళ్లు పెడతాం” అని వారు జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","యాకోబు వారితో ఇంకా మాట్లాడుతుండగా, రాహేలు తన తండ్రి గొర్రెలతో వచ్చింది, ఆమె కూడా కాపరి. ");
INSERT INTO telotsa_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","యాకోబు తన మామ లాబాను కుమార్తెయైన రాహేలును, తన మామ మందను చూడగానే, అతడు వెళ్లి బావి మీద ఉన్న రాయిని దొర్లించి తన మామ మందకు నీళ్లు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","తర్వాత యాకోబు రాహేలును ముద్దు పెట్టుకుని బిగ్గరగా ఏడ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","అతడు తన తండ్రి బంధువని, రిబ్కా కుమారుడని రాహేలుతో చెప్పాడు. కాబట్టి ఆమె పరుగెత్తుకుంటూ వెళ్లి తన తండ్రికి చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","తన సోదరి కుమారుడైన యాకోబును గురించిన సమాచారం విన్న వెంటనే, లాబాను అతన్ని కలవడానికి త్వరపడ్డాడు. అతన్ని హత్తుకుని, ముద్దుపెట్టి, తన ఇంటికి తీసుకెళ్లాడు, అక్కడ యాకోబు అన్ని విషయాలు అతనికి చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","లాబాను అతనితో, “నీవు నా సొంత శరీరం, రక్తం” అన్నాడు. ఒక పూర్తి నెల యాకోబు అతనితో ఉన్న తర్వాత, ");
INSERT INTO telotsa_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","లాబాను అతనితో, “నీవు నా బంధువైనంత మాత్రాన ఏమి తీసుకోకుండ నా కోసం పని చేస్తావా? నీకు జీతంగా ఏమి కావాలో చెప్పు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","లాబానుకు ఇద్దరు కుమార్తెలు ఉన్నారు; పెద్దకుమార్తె పేరు లేయా, చిన్న కుమార్తె పేరు రాహేలు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","లేయాకు బలహీనమైన కళ్లు ఉన్నాయి, కాని రాహేలు రూపవతి, అందగత్తె. ");
INSERT INTO telotsa_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","యాకోబు రాహేలుతో ప్రేమలో ఉండి, “నీ చిన్న కుమార్తె రాహేలు కోసం నేను నీ దగ్గర ఏడు సంవత్సరాలు సేవ చేస్తాను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","లాబాను, “ఆమెను పరాయి మనుష్యునికి ఇవ్వడం కంటే నీకివ్వడం మంచిది. నా దగ్గరే పని చేస్తూ ఉండు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","యాకోబు రాహేలు కోసం ఏడు సంవత్సరాలు పని చేశాడు, అయితే తనకు రాహేలు పట్ల ఉన్న ప్రేమను బట్టి అతనికి ఆ ఏడు సంవత్సరాలు కొద్దిరోజులే అనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","తర్వాత యాకోబు లాబానుతో, “నా భార్యను నాకు ఇవ్వు, నా గడువు తీరింది. నేను ఆమెతో పడుకుంటాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","కాబట్టి లాబాను ఆ ప్రాంత ప్రజలందరినీ సమావేశపరిచి విందు చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","అయితే అతడు రాత్రివేళలో తన కుమార్తె లేయాను యాకోబుకు ఇచ్చాడు, యాకోబు తనతో పడుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","లాబాను తన దాసి జిల్పాను తన కుమార్తెయైన లేయాకు దాసిగా ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","తెల్లవారినప్పుడు యాకోబు లేచి చూస్తే, అతనితో ఉన్నది లేయా! కాబట్టి యాకోబు లాబానును, “నీవు చేసింది ఏంటి? నేను రాహేలు కోసం నీకు పని చేశాను కదా; నీవు నన్నెందుకు మోసం చేశావు?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","లాబాను జవాబిస్తూ, “పెద్దకుమార్తెకు ముందు చిన్న కుమార్తెను ఇవ్వడం మా ఆచారం కాదు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","లేయాతో వైవాహిక వారం గడువు ముగించు. తర్వాత మరో ఏడు సంవత్సరాలు నా దగ్గర పని చేస్తే రాహేలును కూడా నీకిస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","యాకోబు అలాగే చేశాడు. లేయాతో తన వారం ముగించుకున్న తర్వాత లాబాను తన కుమార్తె రాహేలును అతనికి భార్యగా ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","లాబాను తన దాసి బిల్హాను తన కుమార్తెయైన రాహేలుకు దాసిగా ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","యాకోబు రాహేలుతో కూడా పడుకున్నాడు, అతడు లేయాకంటే రాహేలును ఎక్కువ ప్రేమించాడు కాబట్టి అతడు లాబాను కోసం ఇంకా ఏడు సంవత్సరాలు పని చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","లేయా ప్రేమించబడడం లేదని యెహోవా చూసి, ఆమె గర్భవతి అయ్యేలా ఆయన కరుణించారు, కాని రాహేలు గొడ్రాలిగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","లేయా గర్భవతియై ఒక కుమారునికి జన్మనిచ్చింది. “యెహోవా నా బాధను చూశారు. ఇప్పుడు తప్పకుండ నా భర్త నన్ను ప్రేమిస్తాడు” అని చెప్పి, అతనికి రూబేను అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ఆమె మళ్ళీ గర్భవతియై కుమారుని కని, “నేను ప్రేమించబడడం లేదని యెహోవా విన్నారు కాబట్టి, ఇతన్ని కూడా నాకు ఇచ్చారు” అని చెప్పి, అతనికి షిమ్యోను అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","లేయా మళ్ళీ గర్భవతియై కుమారుని కని, “నా భర్తకు నేను ముగ్గురు కుమారులను కన్నాను కాబట్టి ఇప్పుడు నన్ను అంటిపెట్టుకుని ఉంటాడు” అని ఆమె అతనికి లేవీ అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ఆమె మళ్ళీ గర్భవతియై కుమారుని కని, “ఈసారి నేను యెహోవాను స్తుతిస్తాను” అని ఆమె అతనికి యూదా అని పెట్టింది. తర్వాత ఆమె పిల్లలు కనడం ఆగిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","రాహేలు తనకు పిల్లలు కలగడం లేదు అని గ్రహించి, తన అక్క మీద అసూయ పడింది. కాబట్టి యాకోబుతో, “నాకు పిల్లలను ఇవ్వు లేదా నేను చస్తాను!” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","యాకోబు ఆమెపై కోప్పడి, “నేనేమైన నీకు పిల్లలు పుట్టకుండా ఆపిన దేవుని స్థానంలో ఉన్నానా?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","అప్పుడు ఆమె, “ఇదిగో, నా దాసి బిల్హా. ఈమెతో వెళ్లు, తద్వార ఆమె నా కోసం పిల్లలను కంటుంది, ఆమె ద్వార నేను కూడా కుటుంబం కట్టుకుంటాను” అని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","కాబట్టి తన దాసి బిల్హాను అతనికి భార్యగా ఇచ్చింది. యాకోబు ఆమెతో పడుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","బిల్హా గర్భవతియై అతనికి కుమారుని కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","అప్పుడు రాహేలు, “దేవుడు నాకు శిక్షావిముక్తి చేశారు; నా మొర విని నాకు కుమారుని ఇచ్చారు” అని అన్నది. కాబట్టి అతనికి దాను అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","రాహేలు దాసి బిల్హా మళ్ళీ గర్భవతియై యాకోబుకు మరో కుమారున్ని కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","అప్పుడు రాహేలు, “నేను అక్కతో గొప్ప పోరాటం చేశాను, నేను గెలిచాను” అని అన్నది. కాబట్టి అతనికి నఫ్తాలి అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","లేయా పిల్లలు కనడం ఆగిపోయింది అని గ్రహించినప్పుడు, తన దాసి జిల్పాను యాకోబుకు భార్యగా ఇచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","లేయా దాసి జిల్పా యాకోబుకు కుమారున్ని కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","అప్పుడు లేయా, “ఎంత భాగ్యం!” అని అన్నది. కాబట్టి అతనికి గాదు అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","లేయా దాసి జిల్పా యాకోబుకు మరో కుమారున్ని కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","అప్పుడు లేయా అన్నది, “నాకు ఎంత సంతోషం! స్త్రీలు నన్ను సంతోషం అని పిలుస్తారు.” కాబట్టి అతనికి ఆషేరు అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","గోధుమ కోతకాలంలో రూబేను పొలాలకు వెళ్లాడు, అక్కడ ఉన్న పుత్రదాత వృక్షం పండ్లు కొన్ని తెచ్చి, తల్లి లేయాకు ఇచ్చాడు. రాహేలు లేయాతో, “నీ కుమారుడు తెచ్చిన పండ్లలో కొన్ని నాకు దయచేసి ఇవ్వు” అని అడిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","అయితే లేయా ఆమెతో, “నా భర్తను నీవు తీసుకున్నావు, అది చాలదా? ఇప్పుడు నా కుమారుడు తెచ్చిన పండ్లు కూడా కావాలా?” అని అన్నది. రాహేలు, “సరే, నీ కుమారుడు తెచ్చిన పండ్ల కోసం ఈ రోజు నీతో అతడు పడుకోవచ్చు” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","సాయంత్రం యాకోబు పొలం నుండి వచ్చినప్పుడు, లేయా అతన్ని కలవడానికి వెళ్లింది. “నీవు నాతో పడుకోవాలి, నీకోసం నా కుమారుని పండ్లను ఇచ్చాను” అని అతనితో అన్నది. కాబట్టి ఆ రాత్రి అతడు ఆమెతో పడుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","దేవుడు లేయా మనవి విన్నారు, ఆమె గర్భవతియై అయిదవ కుమారున్ని కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","అప్పుడు లేయా, “నా భర్తకు నా దాసిని ఇచ్చినందుకు దేవుడు నాకు ప్రతిఫలం ఇచ్చారు” అని అన్నది. కాబట్టి అతనికి ఇశ్శాఖారు అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ఆమె మరోసారి గర్భవతియై ఆరవ కుమారున్ని కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","అప్పుడు లేయా, “దేవుడు నాకు ప్రశస్తమైన బహుమానం ఇచ్చారు. ఆరుగురు కుమారులను కన్నాను కాబట్టి నా భర్త నన్ను ఘనపరుస్తాడు” అని అన్నది. కాబట్టి అతనికి జెబూలూను అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","కొంతకాలం తర్వాత ఒక కుమార్తెకు జన్మనిచ్చింది. ఆమెకు దీనా అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","తర్వాత దేవుడు రాహేలును జ్ఞాపకం చేసుకున్నారు; ఆయన ఆమె మనవి విన్నారు, ఆమెకు పిల్లలు పుట్టేలా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ఆమె గర్భవతియై ఒక కుమారునికి జన్మనిచ్చింది. “దేవుడు నా నిందను తొలగించారు” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ఆమె అతనికి యోసేపు అని పేరు పెట్టి, “యెహోవా నాకు ఇంకొక కుమారుని కూడా ఇచ్చును గాక” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","రాహేలు యోసేపుకు జన్మనిచ్చిన తర్వాత, యాకోబు లాబానుతో, “నేను నా స్వదేశానికి వెళ్తాను, నన్ను పంపించు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","నా భార్యలను, పిల్లలను నాతో పంపించు. వారి కోసమే నేను నీకు సేవ చేశాను, ఇక నేను వెళ్తాను. నేను ఎంతగా నీకోసం పని చేశానో నీకు తెలుసు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","అయితే లాబాను, “నీకు నాపై దయ ఉంటే, దయచేసి ఉండు. నిన్ను బట్టి యెహోవా నన్ను దీవించారని నేను భవిష్యవాణి ద్వార తెలుసుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","నీకెంత జీతం కావాలో అడుగు, ఇస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","యాకోబు అతనితో, “నీకోసం ఎంత పని చేశానో, నా ఆధీనంలో నీ మంద ఎంత ఎదిగిందో నీకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","నేను రాకముందు నీకున్న కొంచెం ఇప్పుడు చాలా అభివృద్ధి చెందినది, నేను ఏ చోట ఉన్నా యెహోవా నిన్ను దీవించారు. అయితే, నా సొంత ఇంటివారి కోసం నేను ఎప్పుడు సంపాదించుకోవాలి?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","లాబాను, “నీకు ఏమివ్వాలి?” అని అడిగాడు. అందుకు యాకోబు, “నాకు ఈ ఒక్కటి చేస్తే చాలు వేరే ఏమి అక్కర్లేదు. నేను నీ మందను కాపాడుతూ మేపుతాను: ");
INSERT INTO telotsa_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ఈ రోజు నేను నీ మందలన్నిటి మధ్య గుండా వెళ్లి పొడలు, మచ్చలు ఉన్న ప్రతి గొర్రెను, గొర్రెపిల్లలలో నల్లవాటిని, మేకలలో మచ్చలు, పొడలు గలవాటిని వేరు చేస్తాను. వాటిని నాకు జీతంగా ఇవ్వు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","నీవు నాకు జీతంగా ఇచ్చిన వాటిని పరిశీలించడానికి వచ్చినప్పుడు నేను యథార్థంగా ఉన్నట్లు నీవు చూస్తావు. మచ్చలు, పొడలు లేని మేకలు లేదా నల్ల గొర్రెపిల్లలు నా దగ్గర ఉంటే, అవి నేను దొంగిలించాను అని గ్రహించ వచ్చు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","లాబాను, “సరే, నీ మాట ప్రకారమే కానివ్వు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ఆ రోజే లాబాను చారలు, మచ్చలు ఉన్న మేకపోతులన్నిటిని పొడలు, మచ్చలు ఉన్న ఆడ మేకలను (తెల్ల మచ్చలు ఉన్నవాటిని), గొర్రెపిల్లలలో నల్లవాటిని వేరుచేసి వాటిని తన కుమారులకు అప్పగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","అప్పుడు అతడు, తనకు యాకోబుకు మధ్య మూడు రోజుల ప్రయాణమంత దూరం పెట్టాడు. లాబాను యొక్క మిగిలిన మందను యాకోబు మేపడం కొనసాగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","అయితే యాకోబు చినారు, బాదం, సాలు అనే చెట్ల కొమ్మలను తీసుకుని ఆ కొమ్మల్లో తెల్లచారలు కనబడేలా అక్కడక్కడ వాటి తొక్కలను ఒలిచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","తర్వాత అతడు మందలు నీళ్లు త్రాగడానికి వచ్చినప్పుడు అవి చూలు కట్టాలని ఒలిచిన కొమ్మలను వాటి ఎదురుగా ఉండేలా నీళ్లగాళ్లలో పెట్టాడు. మందలు వేడి మీద ఉన్నప్పుడు నీళ్లు త్రాగడానికి వచ్చాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","అక్కడ అవి ఆ కొమ్మల ముందు చూలు కట్టి చారలు, మచ్చలు, పొడలు ఉన్న పిల్లలను ఈనాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","యాకోబు మందలో చిన్నవాటిని వేరు చేశాడు, కానీ మిగితా వాటిని లాబాను మందలోని చారలు ఉన్నవాటి వైపు, నల్లనివాటివైపు వాటి ముఖాలు త్రిప్పి ఉంచాడు. ఇలా తన కోసం వేరే మందను చేసుకున్నాడు, వాటిని లాబాను మందలతో కలపలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","మందలలో బలమైన ఆడవి వేడి మీద ఉన్నప్పుడు, అవి కొమ్మల దగ్గర చూలు కట్టేలా యాకోబు ఆ కొమ్మలను వాటికి ఎదురుగా నీటి తొట్టిలో పెట్టేవాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ఒకవేళ పశువులు బలహీనంగా ఉంటే, వాటిని అక్కడ పెట్టేవాడు కాదు. కాబట్టి బలహీనమైనవి లాబానుకు వెళ్లాయి, బలమైనవి యాకోబుకు వచ్చాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ఈ విధంగా యాకోబు ఎంతో అభివృద్ధి చెందాడు, గొప్ప మందలను, దాసదాసీలను, ఒంటెలను, గాడిదలను సొంతం చేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","లాబాను కుమారులు, “యాకోబు మన తండ్రికి ఉన్న ఆస్తి అంతా తీసుకున్నాడు; అతడు సంపాదించుకున్న ఆస్తి అంతా మన తండ్రికి సంబంధించినదే” అని చెప్పుకోవడం యాకోబు విన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","లాబాను వైఖరి తన పట్ల ముందు ఉన్నట్లు లేదు అని యాకోబు గ్రహించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","అప్పుడు యెహోవా యాకోబుతో, “నీ పూర్వికుల దేశానికి నీ బంధువుల ఇంటికి తిరిగి వెళ్లు, నేను నీతో ఉంటాను” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","యాకోబు తన మందలు ఉన్న పొలం దగ్గరకు రమ్మని రాహేలుకు, లేయాకు కబురు పంపాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","వారితో అన్నాడు, “మీ తండ్రి వైఖరి నా పట్ల ముందులా లేదని నేను గమనించాను, కానీ నా తండ్రి యొక్క దేవుడు నాతో ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","నేను నా బలమంతటితో మీ తండ్రికి సేవ చేశానని మీకు తెలుసు, ");
INSERT INTO telotsa_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","అయినాసరే మీ తండ్రి నా జీతం పదిసార్లు మార్చి నన్ను మోసగించాడు. కానీ అతడు నాకు హాని చేయడాన్ని దేవుడు అనుమతించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ఒకవేళ అతడు, ‘పొడలు ఉన్నవి నీ జీతం’ అని అంటే, మందలన్నీ పొడలు గల పిల్లలనే ఈనాయి; ‘చారలు ఉన్నవి నీ జీతం’ అని అంటే, అప్పుడు మందలన్నీ చారలు గల పిల్లలనే ఈనాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ఇలా దేవుడు మీ తండ్రి పశువులను తీసుకుని నాకిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“మందలు చూలు కట్టే కాలంలో నాకొక కల వచ్చింది, అందులో మందతో వెళ్లిన మేకపోతులు చారలు, పొడలు లేదా మచ్చలతో ఉండడం నేను చూశాను. ");
INSERT INTO telotsa_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","కలలో దేవదూత నాతో, ‘యాకోబు’ అని పిలిచాడు. ‘చిత్తం, నేను ఉన్నాను’ అని జవాబిచ్చాను. ");
INSERT INTO telotsa_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","అతడు నాతో, ‘కళ్ళెత్తి చూడు, మందతో కూడుకుంటున్న మేకపోతులు పొడలు, మచ్చలు లేదా చారలతో ఉన్నాయి, ఎందుకంటే లాబాను నీకు చేసిందంతా నేను చూశాను. ");
INSERT INTO telotsa_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","నీవు ఎక్కడైతే ఒక స్తంభాన్ని అభిషేకించి నాకు మ్రొక్కుబడి చేసుకున్నావో ఆ బేతేలు యొక్క దేవున్ని నేనే. ఇప్పుడు లేచి ఈ దేశాన్ని విడిచి నీ స్వదేశానికి వెళ్లు’ అని అన్నారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","అప్పుడు రాహేలు, లేయా జవాబిస్తూ, “మా తండ్రి స్వాస్థ్యంలో మాకు ఇంకా ఏమైనా పాలుపంపులు ఉన్నాయా? ");
INSERT INTO telotsa_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","అతడు మమ్మల్ని విదేశీయులుగా చూడట్లేదా? మమ్మల్ని అమ్మివేయడమే కాక, మాకు రావలసింది అతనే వాడుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","దేవుడు మా తండ్రి దగ్గర తీసివేసిన ఆస్తి ఖచ్చితంగా మనకు మన పిల్లలకు చెందినది. కాబట్టి దేవుడు నీకేమి చెప్తే అది చేయి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","కాబట్టి యాకోబు తన పిల్లలను భార్యలను ఒంటెలపై ఎక్కించి, ");
INSERT INTO telotsa_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","తన ముందు పశువులను పంపుతూ, తాను పద్దనరాములో సంపాదించుకున్న అన్నిటితో కలిసి, కనాను దేశంలో ఉన్న తన తండ్రి ఇస్సాకు దగ్గరకు బయలుదేరాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","లాబాను తన గొర్రెల బొచ్చు కత్తిరించే పనిమీద వెళ్లినప్పుడు, రాహేలు తన తండ్రి యొక్క గృహదేవతలను దొంగిలించింది. ");
INSERT INTO telotsa_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","అంతేకాక తాను పారిపోతున్నాడని సిరియావాడైన లాబానుకు చెప్పకుండా యాకోబు మోసం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","తన యావదాస్తితో పారిపోయాడు, యూఫ్రటీసు నది దాటి గిలాదు కొండసీమ వైపు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","మూడవ రోజు యాకోబు పారిపోయాడని లాబానుకు తెలియజేయబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","లాబాను తన బంధువులను తీసుకుని, యాకోబును ఏడు రోజులు వెంటాడి గిలాదు కొండ సీమలో అతన్ని ఎదుర్కొన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","రాత్రి దేవుడు కలలో సిరియావాడైన లాబానుకు ప్రత్యక్షమై, “నీవు యాకోబుతో మంచి కానీ చెడు కానీ ఏమి అనవద్దు, జాగ్రత్త” అని హెచ్చరించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","లాబాను యాకోబును ఎదుర్కొన్నప్పుడు యాకోబు గిలాదు కొండ సీమలో తన గుడారం వేసుకున్నాడు, లాబాను అతని బంధువులు కూడా అక్కడే మకాం వేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","అప్పుడు లాబాను యాకోబుతో అన్నాడు, “నీవు చేసింది ఏంటి? నన్ను మోసం చేసి, నా కుమార్తెలను యుద్ధంలో చెరగా తీసుకెళ్లావు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","నీవెందుకు రహస్యంగా పారిపోయి, నన్ను మోసం చేశావు? మృదంగ సితారాల సంగీతంతో నిన్ను ఆనందంగా పంపేవాన్ని కదా, నాకెందుకు చెప్పలేదు? ");
INSERT INTO telotsa_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","నేను నా మనవళ్లకు ముద్దుపెట్టనివ్వలేదు, నా కుమార్తెలను సాగనంపనివ్వలేదు. నీవు బుద్ధిలేని పని చేశావు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","నీకు హాని చేసే సత్తా నాకు ఉంది; కానీ గత రాత్రి నీ తండ్రి యొక్క దేవుడు, ‘నీవు యాకోబుతో మంచి కానీ చెడు కానీ ఏమి అనవద్దు, జాగ్రత్త’ అని నన్ను హెచ్చరించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","సరే, నీ తండ్రి ఇంటికి తిరిగి వెళ్లాలన్న ఆశతో నీవు బయలుదేరావు. కానీ నా దేవతలను ఎందుకు దొంగిలించావు?” ");
INSERT INTO telotsa_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","యాకోబు లాబానుకు జవాబిస్తూ, “నేను భయపడ్డాను, ఎందుకంటే నీవు నీ కుమార్తెలను బలవంతంగా నా నుండి తీసుకెళ్తావని అనుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","అయితే ఒకవేళ ఎవరి దగ్గర నీ దేవతల విగ్రహాలు దొరికితే, వారు బ్రతకరు. నీదేదైనా నా దగ్గర ఉన్నదేమో నీ బంధువుల సమక్షంలో వెదుక్కో; ఒకవేళ ఉంటే, తీసుకెళ్లు” అని అన్నాడు. అయితే రాహేలు ఆ దేవతల విగ్రహాలను దొంగిలించిందని యాకోబుకు తెలియదు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","లాబాను వెదకడానికి యాకోబు గుడారంలోకి, లేయా గుడారంలోకి, ఇద్దరు దాసీల గుడారాల్లోకి వెళ్లి చూశాడు కానీ అతనికి ఏమీ దొరకలేదు. లేయా గుడారం నుండి బయటకు వచ్చి రాహేలు గుడారంలోకి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","రాహేలు ఆ గృహదేవతల విగ్రహాలను ఒంటె సామాగ్రిలో దాచిపెట్టి వాటి మీద కూర్చుంది. లాబాను ఆ గుడారమంతా వెదికాడు కానీ అతనికి ఏమి దొరకలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","రాహేలు తన తండ్రితో, “నా ప్రభువా! నాపై కోప్పడకండి, నేను మీ ఎదుట లేవలేను, నేను నెలసరిలో ఉన్నాను” అని చెప్పింది. కాబట్టి లాబాను వెదకినా అతనికి తన గృహదేవతల విగ్రహాలు దొరకలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","యాకోబు కోపంతో లాబానుతో వాదన పెట్టుకున్నాడు. “నా నేరమేంటి? నేను ఏం పాపం చేశానని నన్నిలా తరుముతున్నావు? ");
INSERT INTO telotsa_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","నా సామానంతా వెదికావు కదా, నీ ఇంటికి సంబంధించింది నీకు ఏమి దొరికింది? నీ బంధువుల ఎదుట, మా వారి ఎదుట ఉంచు, వారు మన మధ్యలో తీర్పు తీర్చనివ్వు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“ఇరవై సంవత్సరాలు నీ దగ్గర ఉన్నాను. నీ గొర్రెలకు, మేకలకు గర్భస్రావం కలుగలేదు లేదా నీ మందలోని పొట్టేళ్లను నేనేమి తినలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","అడవి మృగాలు ద్వార చీల్చబడిన జంతువులను నీ దగ్గరకు తేలేదు; ఆ నష్టం నేనే భరించాను. పగలైనా, రాత్రైనా దొంగిలించబడిన దానికి నీవు నన్ను నష్టపరిహారం అడిగావు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","నా పరిస్థితి ఇది: పగలు ఎండ రాత్రి చలి నన్ను క్షీణింపజేశాయి, నిద్ర నా కళ్ళకు దూరమైంది. ");
INSERT INTO telotsa_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","నీ ఇంట్లో ఇరవై సంవత్సరాలు ఉన్నప్పుడు ఇలా ఉండేది. నీ ఇద్దరు కుమార్తెల కోసం పద్నాలుగు సంవత్సరాలు, నీ మంద కోసం ఆరు సంవత్సరాలు పని చేశాను, అయితే నీవు పదిసార్లు నా జీతం మార్చావు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ఒకవేళ నా తండ్రి యొక్క దేవుడు, అబ్రాహాము దేవుడు, ఇస్సాకు భయపడే దేవుడు నాకు తోడుగా లేకపోతే, నీవు నన్ను ఖచ్చితంగా ఖాళీ చేతులతో పంపియుండేవాడివి. కానీ దేవుడు నా ప్రయాసను, నా చేతి కష్టాన్ని చూశారు, గత రాత్రి నిన్ను గద్దించారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","లాబాను యాకోబుతో, “ఈ స్త్రీలు నా కుమార్తెలు, పిల్లలు నా పిల్లలు, మందలు నా మందలు. అయినా ఇప్పుడు ఈ నా కుమార్తెల గురించి, లేదా వారు కన్న పిల్లల గురించి నేనేమి చేయగలను? ");
INSERT INTO telotsa_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ఇప్పుడు రా, మనం నిబంధన చేసుకుందాము. అది మనిద్దరి మధ్య సాక్ష్యంగా ఉంటుంది” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","కాబట్టి యాకోబు ఒక రాయిని తీసుకుని దానిని స్తంభంగా నిలబెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","అతడు తన బంధువులతో, “కొన్ని రాళ్లు పోగు చేయండి” అని అన్నాడు. వారు రాళ్లు తెచ్చి కుప్పగా పోశారు, ఆ రాళ్లకుప్ప దగ్గర వారు భోజనం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","లాబాను దానికి యెగర్ శాహదూతా అని పేరు పెట్టాడు, యాకోబు దానికి గలీదు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","లాబాను, “ఈ రోజున ఈ రాళ్ల గుట్ట నీకు, నాకు మధ్య సాక్షి” అన్నాడు. అందుకే అది గలీదు అని పిలువబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ఈ స్థలం మిస్పా అని కూడా పిలువబడేది, ఎందుకంటే అతడు అన్నాడు, “మనం ఒకరికి ఒకరం దూరంగా ఉన్నప్పుడు యెహోవా నాకు నీకు మధ్య జరిగేది గమనించును గాక. ");
INSERT INTO telotsa_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","నీవు నా కుమార్తెలను బాధ పెడితే లేదా నా కుమార్తెలు ఉన్నా వేరే స్త్రీలను భార్యలుగా చేసుకుంటే, మనతో ఎవరు లేకపోయినా, మన మధ్యలో సాక్షిగా దేవుడు ఉన్నారని గుర్తుంచుకో.” ");
INSERT INTO telotsa_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","లాబాను ఇంకా యాకోబుతో, “ఇదిగో రాళ్లకుప్ప, ఇదిగో నీకు నాకు మధ్య నిలబెట్టబడి ఉన్న ఈ రాతి స్తంభము. ");
INSERT INTO telotsa_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ఈ రాళ్లకుప్ప సాక్షి, ఈ స్తంభం సాక్షి, నీకు హాని చేయడానికి ఈ రాళ్లకుప్ప, స్తంభం దాటి నేను రాను, నాకు హాని చేయడానికి ఈ రాళ్లకుప్ప, స్తంభం దాటి నీవు రావద్దు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","అబ్రాహాము దేవుడు, నాహోరు దేవుడు, వారి తండ్రి దేవుడు మన మధ్య న్యాయం తీర్చును గాక” అని అన్నాడు. కాబట్టి యాకోబు తన తండ్రి ఇస్సాకు భయపడే దేవుని నామంలో ప్రమాణం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","అతడు ఆ కొండమీద బలి అర్పించి, బంధువులను భోజనానికి పిలిచాడు. వారు భోజనం చేసిన తర్వాత ఆ రాత్రి అక్కడే గడిపారు. ");
INSERT INTO telotsa_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","మర్నాడు వేకువజామున లాబాను మనవళ్లను, అతని కుమార్తెలను ముద్దు పెట్టుకుని దీవించాడు. తర్వాత తన ఇంటికి తిరిగి వెళ్లిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","యాకోబు కూడా బయలుదేరి వెళ్తుండగా దేవదూతలు అతన్ని కలిశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","యాకోబు వారిని చూసి, “ఇది దేవుని సేన!” అని ఆ స్థలానికి మహనయీము అని పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","యాకోబు ఎదోము దేశంలోని శేయీరు ప్రాంతంలో ఉన్న తన సోదరుడైన ఏశావు దగ్గరకు తనకంటే ముందు దూతలను పంపాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ఆయన వారికి ఇలా సూచించాడు: “నా ప్రభువైన ఏశావుతో మీరు ఇలా చెప్పాలి: ‘మీ సేవకుడైన యాకోబు చెప్తున్నాడు, ఇంతవరకు నేను లాబాను దగ్గరే ఉన్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","నాకు మందలు గాడిదలు గొర్రెలు మేకలు, దాసదాసీలు ఉన్నారు. నీ దృష్టిలో దయ పొందడానికి ఇప్పుడు నా ప్రభువుకు ఈ వర్తమానం పంపుతున్నాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ఆ దూతలు యాకోబు దగ్గరకు తిరిగివచ్చి, “నీ సోదరుడు ఏశావు దగ్గరకు వెళ్లాం, ఇప్పుడు అతడు నిన్ను కలవడానికి వస్తున్నాడు, అతనితో నాలుగువందలమంది మనుష్యులు ఉన్నారు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ఎంతో భయంతో, బాధతో యాకోబు తనతో ఉన్న ప్రజలను, తన మందలను పశువులను ఒంటెలను రెండు గుంపులుగా విభజించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“ఒకవేళ ఏశావు ఒక గుంపు మీద దాడి చేస్తే, ఇంకొక గుంపు తప్పించుకోవచ్చు” అని అతడు అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","తర్వాత యాకోబు ప్రార్థిస్తూ, “నా తండ్రియైన అబ్రాహాము దేవా, నా తండ్రియైన ఇస్సాకు దేవా, ‘నీ దేశానికి, నీ బంధువుల దగ్గరకు వెళ్లు, నేను నిన్ను అభివృద్ధి చేస్తాను’ అని నాతో చెప్పిన యెహోవా, ");
INSERT INTO telotsa_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","మీరు మీ సేవకునికి చూపిన దయ నమ్మకత్వానికి నేను యోగ్యుడను కాను. నేను యొర్దాను దాటినప్పుడు, నా దగ్గర చేతికర్ర మాత్రమే ఉంది, కానీ ఇప్పుడు నేను రెండు గుంపులుగా అయ్యాను. ");
INSERT INTO telotsa_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","దేవా, నా సోదరుడు ఏశావు చేతిలో పడకుండ నన్ను తప్పించు, ఎందుకంటే అతడు వచ్చి నన్ను, నా పిల్లలను వారి తల్లులతో పాటు చంపేస్తాడని నాకు భయమేస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","కానీ మీరు, ‘నేను ఖచ్చితంగా నిన్ను వృద్ధి చేసి నీ సంతానాన్ని లెక్కించబడలేని సముద్రపు ఇసుక రేణువుల్లా చేస్తాను’ అని అన్నారు” అని ప్రార్థన చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ఆ రాత్రి యాకోబు అక్కడే గడిపి తన దగ్గర ఉన్న దాంట్లో నుండి తన అన్నయైన ఏశావుకు కానుక ఇవ్వడానికి పెట్టినవి: ");
INSERT INTO telotsa_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","రెండువందల మేకలు, ఇరవై మేకపోతులు, రెండువందల గొర్రెలు, ఇరవై పొట్టేళ్లు, ");
INSERT INTO telotsa_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ముప్పై పాడి ఒంటెలు వాటి పిల్లలు, నలభై ఆవులు, పది ఎద్దులు, ఇరవై ఆడగాడిదలు, పది మగ గాడిదలు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","వాటిని మందలు మందలుగా విభజించి, తన సేవకులకు అప్పగించి, తన సేవకులతో, “మంద మందకు నడుమ ఖాళీ ఉంచి, నాకంటే ముందుగా వెళ్లండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","వారిలో మొదట నిలబడి ఉన్నవాన్ని ఇలా హెచ్చరించాడు: “నా సోదరుడు ఏశావు మీకు ఎదురై, ‘నీవు ఎవరి సంబంధివి, నీవు ఎక్కడికి వెళ్తున్నావు, నీ ముందు ఉన్న ఈ జంతువులన్నీ ఎవరివి?’ అని అడిగితే, ");
INSERT INTO telotsa_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","అప్పుడు నీవు ఇలా చెప్పాలి, ‘ఇవి నీ సేవకుడైన యాకోబువి, నా ప్రభువైన ఏశావుకు కానుకగా పంపబడ్డాయి, అతడు వెనుక వస్తున్నాడు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","అతడు మందల వెంట వెళ్తున్న రెండవ వానికి, మూడవ వానికి, మిగతా అందరికి అలాగే సూచించాడు: “మీరు ఏశావును కలిసినప్పుడు అతనితో ఇలాగే చెప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","నీవు తప్పకుండ ఈ మాట చెప్పాలి, ‘నీ సేవకుడైన యాకోబు మా వెనుక వస్తున్నాడు.’ ” ఎందుకంటే అతడు, “నేను ముందుగా పంపుతున్న ఈ బహుమతులతో నేను అతన్ని శాంతింపజేస్తాను; తర్వాత, నేను అతన్ని చూసినప్పుడు, బహుశ అతడు నన్ను చేర్చుకుంటాడు” అని అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","కాబట్టి యాకోబు బహుమతులు తనకు ముందుగా వెళ్లాయి, అయితే తాను మాత్రం ఆ రాత్రి శిబిరంలోనే ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ఆ రాత్రి యాకోబు లేచి తన ఇద్దరు భార్యలను ఇద్దరు దాసీలను పదకొండుగురు పిల్లలను తీసుకుని యబ్బోకు రేవు దాటి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","వారిని ఏరు దాటించి, తనకున్న ఆస్తినంతా వారితో పంపించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","యాకోబు ఒక్కడే మిగిలిపోయాడు. తెల్లవారే వరకు ఒక మనుష్యుడు అతనితో పెనుగులాడాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","అతన్ని గెలవలేనని ఆ మనుష్యుడు గ్రహించి, యాకోబు తొడగూటి మీద కొట్టాడు. ఆ మనుష్యునితో పోరాడినందున యాకోబు తొడగూడు సడలింది. ");
INSERT INTO telotsa_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","అప్పుడు అతడు, “నన్ను వెళ్లనివ్వు, తెల్లవారింది” అన్నాడు. కానీ యాకోబు, “నన్ను దీవిస్తేనే గాని, నిన్ను వెళ్లనివ్వను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","అప్పుడు ఆ మనుష్యుడు, “నీ పేరేంటి?” అని అడిగాడు. అందుకతడు, “యాకోబు” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","అప్పుడు ఆ మనుష్యుడు, “ఇకమీదట నీ పేరు యాకోబు కాదు ఇశ్రాయేలు, ఎందుకంటే నీవు దేవునితో, మనుష్యులతో పోరాడి గెలిచావు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","యాకోబు అన్నాడు, “దయచేసి నీ పేరు నాకు చెప్పు.” కానీ అతడు అన్నాడు, “నా పేరు ఎందుకు అడుగుతున్నావు?” తర్వాత అతడు అక్కడ యాకోబును ఆశీర్వదించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","యాకోబు ఆ స్థలానికి పెనీయేలు అని పేరు పెట్టి, “నేను దేవున్ని ముఖాముఖిగా చూశాను, అయినా నా ప్రాణం దక్కింది” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","యాకోబు పెనీయేలు నుండి వెళ్లే సమయంలో సూర్యోదయం అయ్యింది, అతడు తొడకుంటుతూ నడిచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","కాబట్టి యాకోబు తొడగూటి మీది తుంటినరం మీద దెబ్బ తిన్నాడు కాబట్టి, ఇశ్రాయేలీయులు నేటి వరకు తొడగూటి మీద ఉన్న తుంటినరం తినరు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","యాకోబు కళ్ళెత్తి చూసినప్పుడు, ఏశావు తన నాలుగువందలమంది మనుష్యులతో వస్తూ కనిపించాడు; కాబట్టి అతడు పిల్లలను లేయాకు రాహేలుకు ఇద్దరు దాసీలకు పంచి అప్పగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","అతడు దాసీలు, వారి పిల్లలను ముందు ఉంచి, తర్వాత లేయా తన పిల్లలను, చివరిగా రాహేలును, యోసేపును ఉంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","అతడు అందరికంటే ముందు వెళ్తూ, తన సోదరున్ని సమీపించే వరకు ఏడుసార్లు సాష్టాంగపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","అయితే ఏశావు యాకోబును కలవడానికి పరుగెత్తి వెళ్లి అతన్ని హత్తుకున్నాడు; తన చేతులు అతని మెడ మీద వేసి ముద్దు పెట్టుకున్నాడు. వారు ఏడ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ఏశావు కళ్ళెత్తి స్త్రీలను, పిల్లలను చూశాడు. “నీతో ఉన్న వీరెవరు?” అని అడిగాడు. యాకోబు, “వీరు నీ సేవకునికి దేవుడు దయతో ఇచ్చిన పిల్లలు” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","అప్పుడు ఆ దాసీలు, వారి పిల్లలు వచ్చి అతనికి నమస్కారం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","తర్వాత లేయా, ఆమె పిల్లలు వచ్చి నమస్కరించారు. చివరికి యోసేపు, రాహేలు కూడా వచ్చి నమస్కరించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ఏశావు, “ఈ మందలు, పశువులన్నీ నాకు ఎందుకు?” అని అడిగాడు. “నా ప్రభువా, నీ దృష్టిలో దయ పొందడానికి” అని యాకోబు అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","అయితే ఏశావు, “నా తమ్ముడా, నాకిప్పటికే సమృద్ధిగా ఉంది. నీది నీవే ఉంచుకో” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","యాకోబు ఇలా అన్నాడు, “దయచేసి, వద్దు! నీ దృష్టిలో నేను దయ పొందితే, ఈ బహుమానం అంగీకరించాలి. నిన్ను చూస్తే దేవుని ముఖం చూసినట్టే ఉంది, దయతో నీవు నన్ను చేర్చుకున్నావు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","దయచేసి నేను తెచ్చిన ఈ కానుకను స్వీకరించు, ఎందుకంటే దేవుడు నన్ను కనికరించారు, నాకు అవసరమైనది నా దగ్గర ఉన్నది.” యాకోబు పట్టుబట్టడంతో ఏశావు దానిని స్వీకరించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","అప్పుడు ఏశావు, “మనం వెళ్తూ ఉందాము; నేను మీతో వస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","కానీ యాకోబు అతనితో, “నా దగ్గర ఉన్నవి పసిపిల్లలు, గొర్రెలు, మేకలు వాటికి పాలిచ్చేవి అని నా ప్రభువుకు తెలుసు. ఒక్క రోజే వీటిని త్వరపెట్టి తోలితే, పశువులన్నీ చస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","కాబట్టి నా ప్రభువు తన సేవకునికి ముందుగా వెళ్లాలి. నేను శేయీరులో ఉన్న నా ప్రభువు దగ్గరకు వచ్చేవరకు, నా ముందున్న గొర్రెల మందలు పశువుల మందలు, అలాగే ఈ పసిపిల్లలు నడువగలిగిన దానిని బట్టి వాటిని నెమ్మదిగా నడిపిస్తూ తీసుకువస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","అందుకు ఏశావు, “అలాగైతే నా మనుష్యుల్లో కొందరిని మీతో ఉంచుతాను” అని అన్నాడు. “అలా ఎందుకు? నా ప్రభువు దృష్టిలో దయ ఉంటే చాలు” అని యాకోబు అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","కాబట్టి ఆ రోజు ఏశావు శేయీరుకు తిరుగు ప్రయాణం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","అయితే యాకోబు మాత్రం సుక్కోతుకు వెళ్లాడు, అక్కడ తన కోసం ఒక ఇల్లు కట్టించుకుని, పశువులకు పాకలు వేశాడు. అందుకే ఆ స్థలం సుక్కోతు అని పిలువబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","యాకోబు పద్దనరాము నుండి వచ్చి, క్షేమంగా కనానులో ఉన్న షెకెము పట్టణానికి చేరాడు, ఆ పట్టణం ఎదురుగా గుడారం వేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","తాను గుడారం వేసుకున్న స్థలాన్ని షెకెము తండ్రియైన హమోరు కుమారుల దగ్గర వంద వెండి నాణేలకు కొన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","అక్కడ అతడు బలిపీఠం కట్టాడు, ఆ స్థలానికి ఎల్ ఎలోహి ఇశ్రాయేలు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","యాకోబు లేయాలకు పుట్టిన కుమార్తెయైన దీనా ఆ దేశంలోని యువతులను దర్శించడానికి వెళ్లింది. ");
INSERT INTO telotsa_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ఆ ప్రాంత పాలకుడు, హివ్వీయుడైన హమోరు కుమారుడైన షెకెము ఆమెను చూశాడు, ఆమెను బలవంతంగా తీసుకెళ్లి అత్యాచారం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","అతడు యాకోబు కుమార్తె దీనాపై మనస్సు పడ్డాడు; ఆ యువతిని అతడు ప్రేమించాడు, ఆమెతో ప్రేమగా మాట్లాడాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","షెకెము తన తండ్రి హమోరుతో, “ఈ అమ్మాయిని నాకు భార్యగా చేయండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","యాకోబు తన కుమార్తెయైన దీనా మానభంగం చేయబడి అపవిత్రమైనది అని విన్నప్పుడు, అతని కుమారులు తన మందతో పొలంలో ఉన్నారు; కాబట్టి వారు ఇంటికి వచ్చేవరకు అతడు ఏమి చేయలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","అప్పుడు షెకెము తండ్రి హమోరు యాకోబుతో మాట్లాడడానికి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ఇంతలో యాకోబు కుమారులు జరిగిన సంగతి విన్న వెంటనే పొలాల నుండి వచ్చేశారు. ఇశ్రాయేలులో జరగకూడని దారుణమైన సంఘటన, యాకోబు కుమార్తెను షెకెము బలత్కారం చేశాడని వారు ఆశ్చర్యానికి గురై ఆగ్రహంతో ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","కానీ హమోరు వారితో, “నా కుమారుడు షెకెము మీ కుమార్తె మీద మనస్సు పడ్డాడు. దయచేసి ఆమెను అతనికి భార్యగా ఇవ్వండి. ");
INSERT INTO telotsa_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","మనం వియ్యమందుకుందాం; మీ కుమార్తెలను మాకు, మా కుమార్తెలను మీకు ఇచ్చి పుచ్చుకుందాము. ");
INSERT INTO telotsa_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","మీరు మాతో నివసించవచ్చు, ఈ దేశం మీ ఎదుట ఉంది. ఇక్కడ ఉండండి, వ్యాపారం చేయండి, ఆస్తి సంపాదించండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","తర్వాత షెకెము దీనా తండ్రితో, సోదరులతో, “మీ దృష్టిలో నేను దయ పొందితే మీరు ఏది అడిగినా నేను ఇస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","వధువు కట్నం, నేను తెచ్చే బహుమానం ఎంతైనా సరే, మీరు అడిగింది నేను ఇస్తాను. యువతిని మాత్రం నాకు భార్యగా ఇవ్వండి” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","వారి సోదరియైన దీనా మానభంగం చేయబడి అపవిత్రమైనది కాబట్టి యాకోబు కుమారులు షెకెముతో అతని తండ్రి హమోరుతో మోసపూరితంగా జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","వారు అన్నారు, “అలా మేము చేయలేము; సున్నతిలేని మనుష్యునికి మా సోదరిని ఇవ్వలేము. మాకది అవమానము. ");
INSERT INTO telotsa_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ఒక షరతుతో మాత్రమే మీతో ఒప్పందం లోనికి వస్తాం; మీ మగవారందరు సున్నతి చేసుకుని మాలాగా మారాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","అప్పుడు మా కుమార్తెలను మీకు ఇస్తాము, మీ కుమార్తెలను మేము తీసుకుని మీతో నివసిస్తాం, మీతో ఒకే ప్రజలుగా అవుతాము. ");
INSERT INTO telotsa_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","మీరు సున్నతి చేసుకోవడానికి ఒప్పుకోకపోతే, మా సోదరిని తీసుకుని వెళ్లిపోతాము.” ");
INSERT INTO telotsa_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","వారి ప్రతిపాదన హమోరుకు అతని కుమారుడైన షెకెముకు నచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ఆ యువకుడు, తన తండ్రి ఇంటి అంతటిలో ఘనత పొందినవాడు, యాకోబు కుమార్తె దీనాను ఎంతో కోరుకున్నాడు కాబట్టి వారు చెప్పింది చేయడానికి ఆలస్యం చేయలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","కాబట్టి హమోరు అతని కుమారుడు షెకెము వారి పట్టణ నాయకులతో మాట్లాడడానికి పట్టణ ద్వారం దగ్గరకు వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ఈ మనుష్యులు మనతో స్నేహంగా ఉంటున్నారు” అని వారు అన్నారు. “వారిని మన దేశంలో నివసిస్తూ, వ్యాపారం చేయనిద్దాం; దేశంలో వారి కోసం చాల స్థలం ఉంది. మనం వారి కుమార్తెలను పెళ్ళి చేసుకుందాం, వారు మన వారిని చేసుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","అయితే వారు మనతో నివసిస్తూ, మనతో ఒకే ప్రజలుగా ఉండాలంటే మన మగవారందరు వారిలా సున్నతి చేసుకోవాలని ఒక షరతు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","వారి పశువులు, వారి ఆస్తులు, వారి జంతువులన్నీ మనవి అవుతాయి కదా! కాబట్టి వారి షరతులు ఒప్పుకుందాము, వారు మన మధ్య స్థిరపడతారు.” ");
INSERT INTO telotsa_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","పట్టణ ద్వారం దగ్గరకు వెళ్లిన మనుష్యులందరు హమోరు, అతని కుమారుడైన షెకెముతో ఏకీభవించారు, పట్టణంలో ప్రతి మగవాడు సున్నతి పొందాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","మూడు రోజుల తర్వాత, వారు ఇంకా నొప్పితో ఉండగా, యాకోబు కుమారులలో ఇద్దరు, దీనా సోదరులు షిమ్యోను, లేవీ వారి ఖడ్గాలు తీసుకుని, క్షేమంగా ఉన్నాం అని దాడిని కూడా ఊహించని పట్టణం మీద దాడి చేసి, ప్రతి పురుషుని చంపేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","వారు హమోరును, అతని కుమారుడైన షెకెమును ఖడ్గంతో చంపి, షెకెము ఇంటి నుండి దీనాను తీసుకెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","యాకోబు కుమారులు వారిని చంపి, తమ సోదరి అపవిత్రం చేయబడిన పట్టణాన్ని దోచుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","వారి మందలను, పశువులను, గాడిదలను, వారి పట్టణంలో, పొలాల్లో ఉన్న సమస్తాన్ని దోచుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","వారి ధనమంతటిని, వారి స్త్రీలనందరిని, పిల్లలందరిని తీసుకెళ్లి, వారి ఇండ్లలో ఉన్నదంతటిని దోచుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","అప్పుడు యాకోబు షిమ్యోను, లేవీతో అన్నాడు, “ఈ దేశంలో నివసించే కనానీయులు, పెరిజ్జీయులు నన్ను చెడ్డవానిగా చూసేలా ఈ కష్టం నా మీదికి తెచ్చారు. మేము కొద్ది మందిమి, ఒకవేళ వారు ఏకమై నా మీద దాడి చేస్తే, నేను నా ఇంటివారు నాశనమవుతాము.” ");
INSERT INTO telotsa_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","అయితే వారు, “మా సోదరి వేశ్యగా పరిగణించబడాలా?” అని జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","దేవుడు యాకోబుతో, “నీవు లేచి, బేతేలుకు వెళ్లి, అక్కడ స్థిరపడు, నీవు నీ సోదరుడైన ఏశావు నుండి పారిపోతున్నప్పుడు నీకు ప్రత్యక్షమైన దేవునికి అక్కడ బలిపీఠం కట్టు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","కాబట్టి యాకోబు తన ఇంటివారితో, తనతో ఉన్నవారందరితో అన్నాడు, “మీ దగ్గర ఉన్న ఇతర దేవతలను తీసివేయండి, మిమ్మల్ని మీరు శుద్ధి చేసుకుని శుభ్రమైన బట్టలు వేసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","తర్వాత నాతో బేతేలుకు రండి, అక్కడ నా శ్రమ దినాన నాకు జవాబిచ్చిన దేవునికి బలిపీఠం కడతాను.” ");
INSERT INTO telotsa_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","కాబట్టి వారు తమ దగ్గర ఉన్న ఇతర దేవతలను, చెవి పోగులను యాకోబుకు ఇచ్చారు, యాకోబు వాటిని షెకెము ప్రాంతంలో ఒక సింధూర వృక్షం క్రింద పాతిపెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","తర్వాత వారు బయలుదేరారు. వారి చుట్టూ ఉన్న పట్టణాలకు దేవుని భయం పట్టుకుంది, కాబట్టి వారిని ఎవ్వరూ వెంటాడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","యాకోబు, అతనితో ఉన్న ప్రజలందరు కనాను దేశంలో ఉన్న లూజుకు (అంటే బేతేలుకు) వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","అక్కడా అతడు బలిపీఠం కట్టి ఆ స్థలానికి ఎల్ బేతేలు అని పేరు పెట్టాడు. యాకోబు తన సోదరుని నుండి పారిపోతున్నప్పుడు ఇక్కడే దేవుడు అతనికి ప్రత్యక్షమయ్యారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ఆ తర్వాత రిబ్కా దాది, దెబోరా చనిపోయింది, బేతేలుకు దిగవ ఉన్న సింధూర వృక్షం క్రింద పాతిపెట్టబడింది. కాబట్టి ఆ వృక్షానికి అల్లోన్ బాకూత్ అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","యాకోబు పద్దనరాము నుండి తిరిగి వచ్చాక, దేవుడు అతనికి మరలా ప్రత్యక్షమై అతన్ని ఆశీర్వదించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","దేవుడు అతనితో, “నీ పేరు యాకోబు, కానీ ఇక ఎన్నడు యాకోబుగా పిలువబడవు; నీ పేరు ఇశ్రాయేలు” అని అన్నారు. కాబట్టి ఆయన అతనికి ఇశ్రాయేలు అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","దేవుడు అతనితో అన్నారు, “నేను సర్వశక్తుడగు దేవుడను; నీవు ఫలించి, సంఖ్యాపరంగా అభివృద్ధి పొందు. ఒక జనం, జనాంగాల సమాజం నీ నుండి వస్తాయి, నీ వారసులలో నుండి రాజులు వస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","అబ్రాహాముకు, ఇస్సాకుకు నేనిచ్చిన దేశాన్ని, నీకు కూడా ఇస్తాను. నీ తర్వాత నీ వారసులకు కూడా ఈ దేశాన్ని ఇస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","తర్వాత దేవుడు అతనితో మాట్లాడిన ఆ స్థలం నుండి ఆరోహణమయ్యారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","దేవుడు అతనితో మాట్లాడిన స్థలంలో, యాకోబు ఒక రాతి స్తంభాన్ని నిలబెట్టి, దాని మీద పానార్పణం కుమ్మరించాడు; నూనె కూడా దాని మీద పోశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","యాకోబు, దేవుడు తనతో మాట్లాడిన ఆ స్థలాన్ని బేతేలు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","తర్వాత బేతేలు నుండి వారు బయలుదేరి వెళ్లారు. ఎఫ్రాతాకు కొద్ది దూరంలో ఉన్నప్పుడు రాహేలుకు కాన్పు నొప్పులు మొదలయ్యాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","బిడ్డకు జన్మనివ్వడంలో చాల శ్రమపడింది. మంత్రసాని, “భయపడకమ్మా, నీవు ఇంకొక మగపిల్లవాన్ని కన్నావు” అని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","రాహేలు చనిపోతూ తన కుమారునికి బెన్-ఓని అని పేరు పెట్టింది. కానీ అతని తండ్రి అతనికి బెన్యామీను అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","కాబట్టి రాహేలు చనిపోయి, ఎఫ్రాతా (అనగా బేత్లెహేము) మార్గంలో పాతిపెట్టబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","యాకోబు ఆమె సమాధి మీద ఒక స్తంభాన్ని నిలబెట్టాడు, అది ఈ రోజు వరకు రాహేలు సమాధిని సూచిస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ఇశ్రాయేలు మరలా ప్రయాణించి మిగ్దల్ ఏదెరు అవతల తన గుడారం వేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ఇశ్రాయేలు ఆ ప్రాంతంలో ఉన్నప్పుడు, రూబేను తన తండ్రి ఉంపుడుగత్తెయైన బిల్హాతో శయనించాడు, ఈ సంగతి ఇశ్రాయేలు విన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","లేయా కుమారులు: యాకోబు మొదటి కుమారుడు రూబేను, షిమ్యోను, లేవీ, యూదా, ఇశ్శాఖారు, జెబూలూను. ");
INSERT INTO telotsa_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","రాహేలు కుమారులు: యోసేపు, బెన్యామీను. ");
INSERT INTO telotsa_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","రాహేలు దాసి బిల్హా కుమారులు: దాను, నఫ్తాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","లేయా దాసి జిల్పా కుమారులు: గాదు, ఆషేరు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","యాకోబు కిర్యత్-అర్బా (అంటే, హెబ్రోను) దగ్గర ఉన్న మమ్రేలో తన తండ్రి దగ్గరకు వచ్చాడు, అబ్రాహాము, ఇస్సాకు అక్కడే నివసించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ఇస్సాకు నూట ఎనభై సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","అతడు తన తుది శ్వాస విడిచి, చనిపోయి మంచి వృద్ధాప్యంలో తన పూర్వికుల దగ్గరకు చేర్చబడ్డాడు. అతని కుమారులు, ఏశావు, యాకోబు అతన్ని పాతిపెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ఇది ఏశావు అనగా ఎదోము కుటుంబ వంశావళి: ");
INSERT INTO telotsa_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","కనాను స్త్రీలలో నుండి ఏశావు తన భార్యలుగా చేసుకున్న వారు: హిత్తీయుడైన ఎలోను కుమార్తెయైన ఆదా, హివ్వీయుడైన సిబ్యోను మనవరాలు, అనా కుమార్తెయైన ఒహోలీబామా, ");
INSERT INTO telotsa_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","అలాగే నెబాయోతు సోదరి, ఇష్మాయేలు కుమార్తెయైన బాశెమతు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ఆదా ఏశావుకు ఎలీఫజును కన్నది, బాశెమతు రెయూయేలును కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ఒహోలీబామా యూషు, యాలాము, కోరహులను కన్నది. వీరంత కనాను దేశంలో ఏశావుకు పుట్టిన కుమారులు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ఏశావు తన భార్యలను, కుమారులను, కుమార్తెలను, తన ఇంటి వారందరిని, పశువులను, అన్ని జంతువులను, కనానులో సంపాదించుకున్న వస్తువులన్నిటిని తీసుకుని తన తమ్ముడికి దూరంగా ఉన్న దేశానికి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","వారి ఆస్తులు వారు కలిసి ఉండలేనంత గొప్పగా ఉన్నాయి; వారికున్న పశువులను బట్టి వారున్న స్థలం వారికి సరిపోలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","కాబట్టి ఏశావు అనగా ఎదోము శేయీరు కొండ సీమలో స్థిరపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","శేయీరు కొండ సీమలో స్థిరపడిన ఎదోమీయుల తండ్రియైన ఏశావు వంశావళి: ");
INSERT INTO telotsa_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ఏశావు కుమారులు: ఏశావు భార్య ఆదా కుమారుడైన ఎలీఫజు, ఏశావు భార్య బాశెమతు కుమారుడైన రెయూయేలు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ఎలీఫజు కుమారులు: తేమాను, ఓమారు, సెఫో, గాతాము, కనజు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ఏశావు కుమారుడైన ఎలీఫజుకు తిమ్నా అనే ఉంపుడుగత్తె కూడా ఉంది. ఆమె అమాలేకును కన్నది. వీరు ఏశావు భార్య ఆదా యొక్క మనవళ్లు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","రెయూయేలు కుమారులు: నహతు, జెరహు, షమ్మా, మిజ్జ. వీరు ఏశావు భార్య బాశెమతు యొక్క మనవళ్లు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ఏశావు భార్య అనా కుమార్తెయైన సిబ్యోను మనవరాలైన ఒహోలీబామా ద్వారా కలిగిన ఏశావు కుమారులు: యూషు, యాలాము, కోరహు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ఏశావు వారసులలో నాయకులైన వారు వీరు: ఏశావు మొదటి కుమారుడైన ఎలీఫజు కుమారులు: నాయకులైన తేమాను, సెఫో, కనజు, ఓమారు, ");
INSERT INTO telotsa_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","కోరహు, గాతాము, అమాలేకు. వీరు ఎదోములో ఎలీఫజు నుండి వచ్చిన నాయకులు; వీరు ఏశావు భార్య ఆదా యొక్క మనవళ్లు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ఏశావు కుమారుడైన రగూయేలు కుమారులు: నాయకులైన నహతు, జెరహు, షమ్మా, మిజ్జ. వీరు ఎదోములో రెయూయేలు నుండి వచ్చిన నాయకులు; వీరు ఏశావు భార్య బాశెమతు యొక్క మనవళ్లు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ఏశావు భార్య ఒహోలీబామా యొక్క కుమారులు: నాయకులైన యూషు, యాలాము, కోరహు. వీరు అనా కుమార్తె, ఏశావు భార్య అహోలీబామా నుండి వచ్చిన నాయకులు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","వీరు ఏశావు అనగా ఎదోము కుమారులు, వీరు వారి నాయకులుగా ఉన్నవారు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ఆ ప్రాంతంలో నివసిస్తున్న హోరీయుడైన శేయీరు కుమారులు: లోతాను, శోబాలు, సిబ్యోను, అనా, ");
INSERT INTO telotsa_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","దిషోను, ఏసెరు, దిషాను. ఎదోములో ఉన్న శేయీరు కుమారులైన వీరు హోరీయుల నాయకులు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","లోతాను కుమారులు: హోరీ, హోమాము. లోతాను సోదరి తిమ్నా. ");
INSERT INTO telotsa_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","శోబాలు కుమారులు: అల్వాను, మనహతు, ఏబాలు, షెఫో, ఓనాము. ");
INSERT INTO telotsa_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","సిబ్యోను కుమారులు: అయ్యా, అనా. ఈ అనా తన తండ్రి గాడిదలను మేపుతూ ఉన్నప్పుడు అరణ్యంలో నీటి ఊటలను కనుగొన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","అనా సంతానం: కుమారుడైన దిషోను, కుమార్తెయైన ఒహోలీబామా. ");
INSERT INTO telotsa_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","దిషోను కుమారులు: హెమ్దాను, ఎష్బాను, ఇత్రాను, కెరాను. ");
INSERT INTO telotsa_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ఏసెరు కుమారులు: బిల్హాను, జవాను, ఆకాను. ");
INSERT INTO telotsa_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","దిషాను కుమారులు: ఊజు, అరాను. ");
INSERT INTO telotsa_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","వీరు హోరీయుల నాయకులు: లోతాను, శోబాలు, సిబ్యోను, అనా, ");
INSERT INTO telotsa_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","దిషోను ఏసెరు దిషాను. ");
INSERT INTO telotsa_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ఇశ్రాయేలు రాజులెవరు పరిపాలించక ముందు ఎదోమును పరిపాలించిన రాజులు వీరు: ");
INSERT INTO telotsa_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","బెయోరు కుమారుడైన బేల ఎదోముకు రాజయ్యాడు. అతని పట్టణానికి దిన్హాబా అని పేరు పెట్టబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","బేల చనిపోయిన తర్వాత, జెరహు కుమారుడు, బొస్రావాడైన యోబాబు అతని స్థానంలో రాజయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","యోబాబు చనిపోయిన తర్వాత, తేమానీయుల దేశస్థుడైన హుషాము అతని స్థానంలో రాజయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","హుషాము చనిపోయిన తర్వాత, మోయాబు దేశంలో మిద్యానీయులను ఓడించిన బెదెదు కుమారుడైన హదదు అతని స్థానంలో రాజయ్యాడు. అతని పట్టణానికి అవీతు అని పేరు పెట్టబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","హదదు చనిపోయిన తర్వాత, మశ్రేకావాడైన శమ్లా అతని స్థానంలో రాజయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","శమ్లా చనిపోయిన తర్వాత, నది తీరాన ఉన్న రహెబోతువాడైన షావూలు అతని స్థానంలో రాజయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","షావూలు చనిపోయిన తర్వాత, అక్బోరు కుమారుడైన బయల్-హనాను అతని స్థానంలో రాజయ్యాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","అక్బోరు కుమారుడైన బయల్-హనాను చనిపోయిన తర్వాత, హదదు అతని స్థానంలో రాజయ్యాడు. అతని పట్టణం పేరు పాయు, అతని భార్యపేరు మెహెతబేలు, ఈమె మే-జాహబ్ కుమార్తెయైన మత్రేదు కుమార్తె. ");
INSERT INTO telotsa_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","వారి వారి వంశాల ప్రకారం వారి వారి ప్రాంతాల ప్రకారం ఇవి ఏశావు వారసుల నాయకులు పేర్లు: తిమ్నా, అల్వా, యతేతు, ");
INSERT INTO telotsa_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ఒహోలీబామా, ఏలహు, పీనోను, ");
INSERT INTO telotsa_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","కనజు, తేమాను, మిబ్సారు, ");
INSERT INTO telotsa_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","మగ్దీయేలు, ఈరాము. ");
INSERT INTO telotsa_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","యాకోబు తన తండ్రి ప్రవాసమున్న కనాను దేశంలో నివసించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","యాకోబు వంశావళి వివరాలు ఇవి. యోసేపు పదిహేడు సంవత్సరాల యువకుడు, తన అన్నలతో, తన తండ్రి భార్యలైన బిల్హా జిల్పాల కుమారులతో కలిసి మందలను మేపుతూ ఉండేవాడు. వారు చేసే చెడు పనుల గురించి తండ్రికి చెప్పేవాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ఇశ్రాయేలు తన ఇతర కుమారుల కంటే యోసేపును ఎక్కువ ప్రేమించాడు, ఎందుకంటే అతడు తన వృద్ధాప్యంలో పుట్టినవాడు; అతని కోసం ఒక ప్రత్యేకమైన బాగా అలంకరించబడిన అంగీని కుట్టించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","తమ తండ్రి అతన్ని తమకంటే ఎక్కువగా ప్రేమిస్తున్నాడని చూసి వారు యోసేపును ద్వేషించారు, అతని క్షేమసమాచారం కూడా అడగలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ఒక రోజు యోసేపుకు ఒక కల వచ్చింది, అది తన అన్నలకు చెప్పినప్పుడు వారతన్ని మరీ ఎక్కువగా ద్వేషించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","అతడు వారితో, “నాకు వచ్చిన కలను వినండి: ");
INSERT INTO telotsa_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","మనం పొలంలో వరి పనలు కడుతున్నాము, అప్పుడు అకస్మాత్తుగా నా పన లేచి నిలబడింది, నా పన చుట్టూ మీ పనలు చేరి సాష్టాంగపడ్డాయి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","అతని అన్నలు అతనితో, “నీవు మమ్మల్ని ఏలాలి అనుకుంటున్నావా? నిజంగా మమ్మల్ని ఏలుతావా?” అని అన్నారు. అతని కలను బట్టి వారు అతన్ని ఇంకా ద్వేషించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","అతనికి మరో కల వచ్చింది, “వినండి. నాకు ఇంకొక కల వచ్చింది, ఈసారి సూర్యుడు చంద్రుడు పదకొండు నక్షత్రాలు నాకు సాష్టాంగపడ్డాయి” అని తన అన్నలకు చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","తన తండ్రికి తన అన్నలకు ఈ కలను గురించి చెప్పినప్పుడు, తన తండ్రి అతని గద్దిస్తూ, “నీకు వచ్చిన ఈ కల ఏంటి? నీ తల్లి, నేను, నీ అన్నలు నీ ఎదుట నిజంగా సాష్టాంగపడాలా?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","యోసేపు అన్నలు అతనిపై అసూయపడ్డారు కానీ అతని తండ్రి ఆ విషయాన్ని మనస్సులో పెట్టుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","యోసేపు అన్నలు తమ తండ్రి మందలను మేపడానికి షెకెముకు వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ఒక రోజు ఇశ్రాయేలు యోసేపుతో, “నీ అన్నలు షెకెము దగ్గర మందలను మేపుతున్నారని నీకు తెలుసు కదా. రా, నేను నిన్ను వారి దగ్గరకు పంపుతాను” అని అన్నాడు. “సరే, మంచిది” అని అతడు జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","కాబట్టి యాకోబు, “వెళ్లు, నీ అన్నలు, అలాగే మందల యోగక్షేమాలు తెలుసుకుని, వచ్చి నాకు చెప్పు” అని యోసేపుతో అన్నాడు. తర్వాత అతడు హెబ్రోను లోయ నుండి అతన్ని పంపించాడు. యోసేపు షెకెముకు చేరుకున్నప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","అతడు పొలాల్లో అటూ ఇటూ తిరుగుతూ ఉండడం ఒక మనుష్యుడు చూసి, “నీవు ఏం వెదకుతున్నావు?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","యోసేపు జవాబిస్తూ, “నేను మా అన్నల కోసం వెదకుతున్నాను. వారు తమ మందలను ఎక్కడ మేపుతున్నారో మీరు చెప్పగలరా?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“వారు ఇక్కడినుండి వెళ్లిపోయారు. ‘మనం దోతానుకు వెళ్దాం’ అని వారు అనుకోవడం నేను విన్నాను” అని ఆ వ్యక్తి అన్నాడు. కాబట్టి యోసేపు తన అన్నలను వెదుకుతూ వెళ్లి దోతానులో వారిని కనుగొన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","అయితే వారు అతన్ని దూరం నుండి చూడగానే, అతడు వారిని చేరకముందే, వారు అతన్ని చంపడానికి కుట్రపన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“కలలు కనేవాడు వస్తున్నాడు!” అని వారు ఒకరితో ఒకరు అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“రండి, వాన్ని చంపి ఈ బావులలో ఒక దాంట్లో పడవేద్దాం, క్రూరమృగం చంపేసిందని చెప్పుదాము. అప్పుడు వీని కలలు ఏమైపోతాయో చూద్దాం” అని అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","రూబేను ఇది విని, అతన్ని వారి నుండి రక్షించాలని ప్రయత్నించాడు. “మనం అతన్ని చంపొద్దు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","రక్తం చిందించవద్దు. అరణ్యంలో ఈ బావిలో వాన్ని పడద్రోయండి కానీ వానికి హానిచెయ్యవద్దు” అని అన్నాడు. యోసేపును వారి నుండి కాపాడి తన తండ్రి దగ్గరకు తిరిగి తీసుకెళ్లడానికి రూబేను ఇలా అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","కాబట్టి యోసేపు తన అన్నల దగ్గరకు రాగానే, అతడు వేసుకున్న రంగుల అంగీని చింపేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","అతన్ని తీసుకెళ్లి బావిలో పడద్రోసారు. ఆ బావి ఖాళీగా ఉంది; అందులో నీళ్లు లేవు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","వారు భోజనం చేయడానికి కూర్చున్నప్పుడు, కళ్ళెత్తి చూశారు, గిలాదు నుండి ఇష్మాయేలీయుల వర్తక బాటసారుల గుంపు ఒకటి రావడం కనిపించింది. వారి ఒంటెలు గుగ్గిలం, మస్తకి, బోళం మోస్తూ ఉన్నాయి, వారు వాటిని ఈజిప్టుకు తీసుకెళ్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","యూదా తన అన్నలతో, “మన తమ్మున్ని చంపి, అతని రక్తం దాచిపెట్టడం ద్వారా మనకు ఉపయోగం ఏంటి? ");
INSERT INTO telotsa_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","రండి, వీడిని మనం ఏమి హాని చేయకుండా, ఇష్మాయేలీయులకు అమ్మివేద్దాం; ఎంతైనా మన తమ్ముడు మన సొంత శరీరం కదా” అని అన్నాడు. అతని అన్నలు అందుకు ఒప్పుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","కాబట్టి మిద్యాను వర్తకులు అటు వచ్చినప్పుడు, యోసేపును తన అన్నలు బావిలో నుండి బయటకు లాగి ఇరవై షెకెళ్ళ వెండికి ఆ ఇష్మాయేలీయులకు అమ్మివేశారు, వారు అతన్ని ఈజిప్టుకు తీసుకెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","రూబేను ఆ బావి దగ్గరకు తిరిగివచ్చి, అక్కడ యోసేపు లేడని చూసి, తన బట్టలు చింపుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","అతడు తన తమ్ముళ్ల దగ్గరకు తిరిగివెళ్లి, “ఆ బాలుడు అక్కడ లేడు! నేనిప్పుడు ఎక్కడికి వెళ్లాలి?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","అప్పుడు వారు యోసేపు అంగీని తీసుకుని, ఒక మేకను చంపి దాని రక్తంలో ముంచారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","వారు ఆ రంగుల అంగీని తమ తండ్రి దగ్గరకు తీసుకెళ్లి, “మాకు ఇది దొరికింది. ఇది నీ కుమారుని చొక్కాయో కాదో చూడండి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","అతడు దానిని గుర్తుపట్టి, “ఈ చొక్కా నా కుమారునిదే! ఒక క్రూరమృగం అతన్ని మ్రింగివేసింది. ఖచ్చితంగా యోసేపును ముక్కలు చేసి ఉంటుంది” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","అప్పుడు యాకోబు తన బట్టలు చింపుకుని, గోనెపట్ట కట్టుకుని చాలా రోజులు తన కుమారుని కోసం ఏడ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","అతని కుమారులు, కుమార్తెలు అందరు అతని ఓదార్చడానికి ప్రయత్నించారు, కానీ అతడు ఓదార్పు పొందలేదు. అతడు వారితో, “లేదు, నేను సమాధిలో నా కుమారుని కలిసే వరకు నేను దుఃఖిస్తాను” అని అన్నాడు. అలా అతడు తన కుమారుని కోసం ఏడ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ఇంతలో మిద్యానీయులు యోసేపును, ఈజిప్టులో ఫరో అధికారులలో ఒకడు, రాజ సంరక్షక సేనాధిపతియైన పోతీఫరుకు అమ్మివేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ఆ సమయంలో, యూదా తన సోదరులను విడిచి, హీరా అనే ఒక అదుల్లామీయుని దగ్గర ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","అక్కడ ఒక కనానీయుడైన షూయ కుమార్తెను కలిశాడు. ఆమెను పెళ్ళి చేసుకుని ఆమెతో లైంగికంగా కలుసుకున్నాడు; ");
INSERT INTO telotsa_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ఆమె గర్భవతియై కుమారున్ని కన్నది. అతనికి ఏరు అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ఆమె మరలా గర్భవతియై కుమారుని కన్నది, అతనికి ఓనాను అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ఆమె మరొక కుమారుని కన్నది, అతనికి షేలా అని పేరు పెట్టింది. ఆమె కజీబులో ఇతనికి జన్మనిచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","యూదా అతని మొదటి కుమారుడైన ఏరుకు తామారుతో పెళ్ళి చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","కానీ యూదా మొదటి కుమారుడైన ఏరు, యెహోవా దృష్టికి చెడ్డవాడు కాబట్టి యెహోవా అతన్ని మరణానికి గురి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","అప్పుడు యూదా ఓనానుతో, “నీ అన్న భార్యతో పడుకోని మరిది ధర్మం నిర్వర్తించి నీ అన్నకు సంతానం కలిగేలా చేయి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","అయితే పుట్టే బిడ్డ అతని బిడ్డగా ఉండదని ఓనానుకు తెలుసు; కాబట్టి తన అన్న భార్యతో పడుకున్న ప్రతిసారి, తన అన్నకు సంతానం కలుగకూడదని తన వీర్యాన్ని నేలపై విడిచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","అతడు చేసిన పని యెహోవా దృష్టికి చెడ్డదైనందుకు యెహోవా అతన్ని కూడా మరణానికి గురి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","అప్పుడు యూదా తన కోడలు తామారుతో, “నా కుమారుడు షేలా ఎదిగే వరకు నీ తండ్రి ఇంట్లో విధవరాలుగా ఉండు” అని అన్నాడు. ఎందుకంటే అతడు, “తన అన్నల్లా ఇతడు కూడా చనిపోతాడేమో” అని అనుకున్నాడు. కాబట్టి తామారు తన తండ్రి ఇంట్లో ఉండడానికి వెళ్లింది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","చాలా కాలం తర్వాత యూదా భార్య, షూయ కుమార్తె చనిపోయింది. యూదా దుఃఖ కాలం తీరిపోయాక, తన గొర్రెబొచ్చు కత్తిరించే వారున్న తిమ్నాకు వెళ్లాడు, అతని స్నేహితుడైన హీరా అనే అదుల్లామీయుడు అతనితో వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","“నీ మామ తన గొర్రెల బొచ్చు కత్తిరించడానికి తిమ్నాకు వెళ్తున్నాడు” అని తామారుకు తెలిసినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","తన విధవరాలి బట్టలు తీసివేసి తలమీద ముసుగు వేసుకుని, తిమ్నా మార్గంలో ఉన్న ఎనయీము అనే గ్రామ ప్రవేశం దగ్గర కూర్చుంది. షేలా పెద్దవాడైనా కూడా ఆమె అతనికి భార్యగా ఇవ్వబడలేదు కాబట్టి ఆమె అలా చేసింది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","యూదా ఆమెను చూసి, ఆమె ముఖం కప్పుకున్నందుకు వేశ్య అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ఆమె తన కోడలని తెలియక, దారిలో ఉన్న ఆమె వైపు వెళ్లి, “రా, నేను నీతో పడుకుంటాను” అని అన్నాడు. “నాతో పడుకోడానికి నాకు ఏమి ఇస్తావు?” అని ఆమె అడిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","అతడు, “నా మంద నుండి మేకపిల్లను ఇస్తాను” అని చెప్పాడు. అప్పుడు ఆమె, “అది పంపే వరకు నా దగ్గర ఏదైనా తాకట్టు పెడతావా?” అని అడిగింది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","అతడు, “ఏం తాకట్టు పెట్టాలి?” అని అడిగాడు. ఆమె, “నీ ముద్ర, దాని దారం, నీ చేతిలో ఉన్న కర్ర” అని అన్నది. కాబట్టి అతడు అవి ఆమెకు ఇచ్చి ఆమెతో పడుకున్నాడు, అతని ద్వారా ఆమె గర్భవతి అయ్యింది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ఆమె వెళ్లి తన ముసుగు తీసివేసి తిరిగి తన విధవరాలి బట్టలు వేసుకుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","అంతలో యూదా ఆ స్త్రీ దగ్గర తాకట్టు పెట్టినవి విడిపించుకోడానికి తన స్నేహితుడైన అదుల్లామీయుని ద్వారా మేకపిల్లను పంపాడు కానీ ఆమె అతనికి కనబడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","అక్కడున్న మనుష్యులను, “ఎనయీము దారి ప్రక్కన ఉండే పుణ్యక్షేత్ర వేశ్య ఎక్కడుంది?” అని అడిగాడు. “ఇక్కడ పుణ్యక్షేత్ర వేశ్య ఎవరు లేరు” అని వారన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","కాబట్టి అతడు యూదా దగ్గరకు తిరిగివెళ్లి, “నేను ఆమెను కనుగొనలేదు. అంతేకాక, అక్కడ ఉండే మనుష్యులు, ‘ఇక్కడ పుణ్యక్షేత్ర వేశ్య లేదు’ అని అన్నారు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","అప్పుడు యూదా, “ఆమె తన దగ్గర ఉన్నవాటిని ఉంచుకోనివ్వండి, లేకపోతే మనం నవ్వుల పాలవుతాము. ఎంతైనా నేను ఆమెకు ఈ మేకపిల్లను పంపాను, కానీ నీకు ఆమె కనబడలేదు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","దాదాపు మూడు నెలలు తర్వాత, “నీ కోడలు తామారు వ్యభిచారిగా అపరాధం చేసింది, ఫలితంగా ఇప్పుడు ఆమె గర్భవతి” అని యూదాకు తెలియజేయబడింది. యూదా అన్నాడు, “ఆమెను బయటకు తీసుకువచ్చి ఆమెను కాల్చి చంపండి!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ఆమెను బయటకు తీసుకువచ్చినప్పుడు, ఆమె తన మామకు వార్త పంపి, “ఇవి ఎవరికి చెందినవో ఆ యజమాని ద్వార నేను గర్భవతినయ్యాను” అని అన్నది. ఇంకా ఆమె, “ఈ ముద్ర, దారం, కర్ర ఎవరివో గుర్తుపడ్తారేమో చూడండి” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","యూదా అవి తనవేనని గుర్తుపట్టి ఇలా అన్నాడు, “ఆమె నాకంటే నీతిమంతురాలు, ఎందుకంటే నేను ఆమెను నా కుమారుడైన షేలాకు ఇచ్చి పెళ్ళి చేయలేదు.” ఆ తర్వాత అతడు ఆమెతో మరలా ఎప్పుడూ పడుకోలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ఆమె బిడ్డను కనే సమయం వచ్చినప్పుడు ఆమె గర్భంలో కవలలు ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","కాన్పు సమయంలో ఒక శిశువు బయటకు వస్తూ చేయి చాచాడు; మంత్రసాని ఎర్రటి నూలుదారం ఆ శిశువు చేతికి కట్టి, “ఇతడు మొదట బయటకు వచ్చినవాడు” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","అయితే ఆ శిశువు చేయి వెనుకకు తీసుకున్నప్పుడు, అతని సోదరుడు బయటకు వచ్చాడు, అప్పుడు ఆమె, “ఇలా నీవు దూసుకుని వచ్చావు!” అన్నది. అతనికి పెరెసు అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","తర్వాత చేతికి ఎర్రటి దారం ఉన్నవాడు బయటకు వచ్చాడు. అతనికి జెరహు అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","యోసేపు ఈజిప్టుకు కొనిపోబడ్డాడు. ఫరో అధికారులలో ఒకడు, రాజ సంరక్షక సేనాధిపతియైన పోతీఫరు అనే ఈజిప్టువాడు యోసేపును తీసుకెళ్లిన ఇష్మాయేలీయుల దగ్గర అతన్ని కొన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","యెహోవా యోసేపుతో ఉన్నారు కాబట్టి అతడు వర్ధిల్లాడు, తన ఈజిప్టు యజమాని ఇంట్లో ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","యెహోవా అతనితో ఉన్నారని, అతడు చేసే ప్రతి పనిలో యెహోవా విజయం ఇచ్చారని అతని యజమాని చూసినప్పుడు ");
INSERT INTO telotsa_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","యోసేపు అతని దృష్టిలో దయ పొందాడు, అతనికి వ్యక్తిగత పరిచారకుడయ్యాడు. పోతీఫరు యోసేపును అతని ఇంటికి అధికారిగా నియమించి తనకున్న సమస్తాన్ని అతని పర్యవేక్షణలో పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","తన ఇంటికి, తన సమస్తానికి యోసేపును అధికారిగా నియమించినప్పటి నుండి, యెహోవా ఈజిప్టు యజమాని ఇంటిని ఆశీర్వదించారు. ఇంట్లోనూ, పొలంలోనూ పోతీఫరుకు ఉన్న సమస్తం మీద యెహోవా ఆశీర్వాదం ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","కాబట్టి పోతీఫరు సమస్తాన్ని యోసేపు పర్యవేక్షణలో పెట్టాడు; యోసేపు అధికారిగా ఉన్నందుకు తన భోజనం తప్ప మరి దేని గురించి అతడు పట్టించుకోలేదు. యోసేపు మంచి రూపం కలిగినవాడు, అందగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","కొంతకాలం తర్వాత తన యజమాని భార్య అతని మీద కన్నేసి, “నాతో పడుకో!” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","కానీ అతడు తిరస్కరించాడు. “నా యజమాని నన్ను అధికారిగా నియమించి ఇంట్లో నేనున్నాననే నమ్మకంతో తాను నిశ్చింతగా ఉన్నారు. తన సమస్తాన్ని నా పర్యవేక్షణలో ఉంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ఈ ఇంట్లో నాకన్నా పైవాడు లేడు. మీరు తన భార్య కాబట్టి నా యజమాని మిమ్మల్ని తప్ప మిగతాదంతా నాకు అప్పగించాడు. కాబట్టి దేవునికి విరుద్ధంగా అలాంటి చెడ్డపని నేను ఎలా చేయగలను?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ప్రతిరోజు ఆమె యోసేపుతో మాట్లాడుతూ ఉన్నప్పటికీ, ఆమెతో పడుకోడానికి లేదా ఆమెతో ఉండడానికి కూడా అతడు తిరస్కరించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ఒక రోజు అతడు ఇంట్లో తన పనులు చేసుకోవడానికి వెళ్లాడు, అప్పుడు ఇంట్లో పనివారు ఎవరు లేరు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ఆమె అతని అంగీ పట్టుకుని లాగి, “నాతో పడుకో!” అని అన్నది. అయితే అతడు తన అంగీ ఆమె చేతిలో వదిలేసి ఇంట్లోనుండి తప్పించుకుపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","అతడు తన అంగీని ఆమె చేతిలో వదిలేసి ఇంట్లోనుండి తప్పించుకుపోయాడని చూసి, ");
INSERT INTO telotsa_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","తన ఇంటి పనివారిని పిలిచి, “చూడండి, నా భర్త మనలను అవమానించాలని ఈ హెబ్రీయున్ని తెచ్చాడు. అతడు నాతో శయనించాలని లోనికి వచ్చాడు కానీ నేను కేకలు పెట్టాను. ");
INSERT INTO telotsa_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","సహాయం కోసం నేను పెట్టిన కేకలు విని, తన అంగీని నా ప్రక్కన వదిలేసి పారిపోయాడు” అని చెప్పింది. ");
INSERT INTO telotsa_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","తన యజమాని ఇంటికి వచ్చేవరకు అతని అంగీని ఆమె ప్రక్కనే పెట్టుకుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","తర్వాత అతనికి ఈ కథ చెప్పింది: “నీవు తీసుకువచ్చిన ఆ హెబ్రీ బానిస నా దగ్గరకు వచ్చి నన్ను లోబరచుకోవాలని చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","నేను సహాయం కోసం కేకలు పెట్టిన వెంటనే, తన అంగీని నా ప్రక్కన వదిలేసి ఇంట్లోనుండి పారిపోయాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","అతని యజమాని, “నీ దాసుడు ఇలా ప్రవర్తించాడు” అని తన భార్య చెప్పిన కథ విని కోపంతో రగిలిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","యోసేపు యజమాని అతన్ని రాజద్రోహులనుంచే చెరసాలలో పడవేశాడు. అయితే యోసేపు అక్కడే చెరసాలలో ఉన్నప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","యెహోవా అతనితో ఉన్నారు; ఆయన అతనిపై దయ చూపించారు, చెరసాల అధికారి దృష్టిలో అతనిపై దయ కలిగించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","కాబట్టి చెరసాల అధికారి చెరసాలలో ఉన్నవారందరిపై యోసేపుకు అధికారం ఇచ్చాడు, అక్కడ జరిగే అంతటి మీద అతనికి బాధ్యత అప్పగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","చెరసాల అధికారి యోసేపు ఆధీనంలో ఉన్నవాటి గురించి చింతించలేదు, ఎందుకంటే యెహోవా యోసేపుతో ఉన్నారు, అతడు చేసే అన్నిటిలో విజయాన్ని ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","కొంతకాలం తర్వాత ఈజిప్టు రాజుకు గిన్నె అందించేవాడు రొట్టెలు చేసేవాడు తమ యజమాని పట్ల తప్పు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","కాబట్టి ఫరో తన ఇద్దరి అధికారులపై అనగా గిన్నె అందించేవారి నాయకునిపై, రొట్టెలు కాల్చేవారి నాయకునిపై కోప్పడి, ");
INSERT INTO telotsa_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","వారిని అంగరక్షకుల అధికారి ఆధీనంలో, అతని ఇంట్లో ఉంచాడు, అదే చెరసాలలో యోసేపు బంధించబడి ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","అంగరక్షకుల అధికారి వీరిద్దరిని యోసేపుకు అప్పగించాడు, అతడు వారిని చూసుకున్నాడు. వారు కొంతకాలం వరకు చెరసాలలో ఉన్నప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ఈజిప్టు రాజుకు గిన్నె అందించేవాడు, రొట్టెలు చేసేవాడు చెరలో ఉన్నప్పుడు ఇద్దరూ ఒకే రాత్రి కలగన్నారు. ఇద్దరి కలలకు దేని భావం దానికే ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","మరుసటిరోజు ప్రొద్దున్నే యోసేపు వారి దగ్గరకు వచ్చినప్పుడు, వారు దిగులుగా ఉన్నట్లు గమనించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","కాబట్టి అతడు తన యజమాని ఇంట్లో నిర్బంధంలో ఉన్న అధికారులను, “మీరు ఎందుకు ఈ రోజు విచారంగా ఉన్నారు?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“మా ఇద్దరికి కలలు వచ్చాయి కానీ వాటి భావం చెప్పడానికి ఎవరు లేరు” అని వారు జవాబిచ్చారు. అప్పుడు యోసేపు వారితో, “భావాలు చెప్పడం దేవుని వశం కాదా? మీ కలలు నాకు చెప్పండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","కాబట్టి గిన్నె అందించేవారి నాయకుడు యోసేపుకు తన కలను చెప్పాడు. అతడు, “నా కలలో నా ఎదుట ఒక ద్రాక్షచెట్టు ఉంది, ");
INSERT INTO telotsa_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ఆ ద్రాక్షచెట్టుకు మూడు తీగెలున్నాయి. అది చిగురించి, పూలు పూసింది, దాని గెలలు ద్రాక్షపండ్లతో ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ఫరో గిన్నె నా చేతిలో ఉంది, నేను ద్రాక్షపండ్లు తీసుకుని ఫరో గిన్నెలో వాటిని పిండి అతని చేతికి ఆ గిన్నెను ఇచ్చాను” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","యోసేపు అతనితో, “దాని అర్థం ఇది. మూడు తీగెలు మూడు రోజులు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","మూడు రోజుల్లో ఫరో నీ తల పైకెత్తి నీ స్థానం నీకు మరలా ఇస్తాడు, గతంలో నీవు గిన్నె అందించే వానిగా ఉన్నప్పుడు చేసినట్టు, ఫరో గిన్నెను అతనికి చేతికి అందిస్తావు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","నీకు అంతా మంచి జరిగినప్పుడు నన్ను జ్ఞాపకం చేసుకుని నాకు దయ చూపించు; ఫరోతో నా గురించి మాట్లాడి నన్ను ఈ చెరసాల నుండి బయటకు రప్పించు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","హెబ్రీ దేశం నుండి బలవంతంగా నన్ను దొంగిలించి తీసుకువచ్చారు, నేను చెరసాలలో ఉండడానికి చేసిన నేరం ఏమి లేదు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","యోసేపు అనుకూలంగా భావం చెప్పాడు అని గమనించిన రొట్టెలు కాల్చేవాడు యోసేపుతో, “నాకు కూడా కల వచ్చింది: నా తలమీద రొట్టెలు ఉన్న మూడు గంపలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","పై గంపలో ఫరో కోసం అన్ని రకాల మంచి వంటకాలున్నాయి, కానీ పక్షులు వచ్చి, నా తలమీద ఉన్న గంపలో నుండి తింటున్నాయి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","యోసేపు అన్నాడు, “దాని అర్థం ఇది. మూడు గంపలు మూడు రోజులు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","మూడు రోజుల్లో ఫరో నీ తలను తీసివేసి, నీ శరీరాన్ని స్తంభానికి వ్రేలాడదీస్తాడు. పక్షులు నీ మాంసం తినివేస్తాయి.” ");
INSERT INTO telotsa_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","మూడవ రోజు ఫరో పుట్టిన రోజు, అతడు తన అధికారులందరికి విందు ఏర్పాటు చేశాడు. అధికారులందరి ఎదుట గిన్నె అందించేవారి నాయకుడి, రొట్టెలు కాల్చేవాని నాయకుడి తలలను పైకెత్తాడు: ");
INSERT INTO telotsa_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","గిన్నె అందించేవారి నాయకున్ని అతని స్థానం తిరిగి ఇచ్చాడు కాబట్టి మరలా అతడు ఫరో చేతికి గిన్నె అందించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","కానీ యోసేపు కల భావం చెప్పినట్టే, అతడు రొట్టెలు కాల్చేవారి నాయకున్ని వ్రేలాడదీశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","అయితే గిన్నె అందించేవారి నాయకుడు యోసేపును జ్ఞాపకం చేసుకోలేదు; అతన్ని మరచిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","రెండు సంవత్సరాల ముగిసిన తర్వాత ఫరో కలగన్నాడు: అతడు నైలు నది దగ్గర నిలబడి ఉన్నాడు, ");
INSERT INTO telotsa_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","నదిలో నుండి పుష్టిగా అందంగా ఉన్న ఏడు ఆవులు పైకి వచ్చి జమ్ము మధ్య మేస్తున్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","వాటి తర్వాత, చిక్కిపోయి వికారంగా ఉన్న మరో ఏడు ఆవులు వాటి ప్రక్కన నైలు నది ఒడ్డున నిలబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","చిక్కిపోయి వికారంగా ఉన్న ఆవులు అందంగా పుష్టిగా ఉన్న ఏడు ఆవులను తినివేశాయి. అప్పుడు ఫరో నిద్రలేచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","మళ్ళీ అతడు పడుకున్నాడు, రెండవ కలగన్నాడు: పుష్టిగా, మంచిగా ఉన్న ఏడు వెన్నులు ఒకే కొమ్మకు పెరుగుతున్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","వాటి తర్వాత పీలగా, తూర్పుగాలికి ఎండిపోయిన మరో ఏడు వెన్నులు పెరిగాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","పీలవెన్నులు పుష్టిగా ఉన్న ఏడు వెన్నులను మ్రింగివేశాయి. అప్పుడు ఫరో నిద్రలేచాడు; అది కల అని గ్రహించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ఉదయం అతని మనస్సు కలవరపడింది, కాబట్టి ఈజిప్టులోని మాంత్రికులను, జ్ఞానులను అందరిని పిలిపించాడు. ఫరో తన కలలు వారికి చెప్పాడు, కానీ వాటి భావం ఎవరు చెప్పలేకపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","అప్పుడు గిన్నె అందించేవారి నాయకుడు ఫరోతో అన్నాడు, “ఈ రోజు నా తప్పులు నాకు జ్ఞాపకం చేయబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ఫరో ఒకసారి తన సేవకులపై కోప్పడి, నన్ను రొట్టెలు కాల్చేవారి నాయకున్ని అంగరక్షకుల అధిపతి ఇంట్లో నిర్బంధంలో ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","మా ఇద్దరికి ఒకే రాత్రి కలలు వచ్చాయి, ఒక్కొక్క కలకు ఒక్కొక్క అర్థం ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","అక్కడ మాతో పాటు ఒక హెబ్రీ యువకుడు ఉన్నాడు. అతడు అంగరక్షకుల అధికారికి దాసుడు. మా కలలు అతనికి చెప్పాం, అతడు ఎవరి కల భావాన్ని వారికి చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","అతడు వాటిని వివరించినట్టే మాకు జరిగింది: నా స్థానం నాకు తిరిగి వచ్చింది, మరో వ్యక్తి వ్రేలాడదీయబడ్డాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","అప్పుడు ఫరో యోసేపును పిలిపించాడు, వారు అతన్ని చెరసాల నుండి త్వరగా తీసుకువచ్చారు. యోసేపు శుభ్రంగా క్షౌరం చేసుకుని బట్టలు మార్చుకుని ఫరో సమక్షంలో నిలబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ఫరో యోసేపుతో, “నేనొక కలగన్నాను, దాని భావం ఎవరూ చెప్పలేకపోయారు. కానీ నీవు ఒక కల వింటే దాని భావం చెప్తావని నీ గురించి విన్నాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","అందుకు యోసేపు, “నేను చేయలేను, అయితే ఫరోకు క్షేమకరమైన జవాబు దేవుడు ఇస్తారు” అని ఫరోతో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","అప్పుడు ఫరో యోసేపుతో అన్నాడు, “నా కలలో నేను నైలు నది తీరాన నిలబడ్డాను, ");
INSERT INTO telotsa_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","నదిలో నుండి పుష్టిగా అందంగా ఉన్న ఏడు ఆవులు పైకి వచ్చి జమ్ము మధ్య మేస్తున్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","వాటి తర్వాత చిక్కిపోయి వికారంగా ఉన్న మరో ఏడు ఆవులు పైకి వచ్చాయి. అంత వికారమైన ఆవులను ఈజిప్టులో నేనెప్పుడు చూడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","బక్కగా వికారంగా ఉన్న ఆవులు ముందు వచ్చిన పుష్టిగా ఉన్న ఏడు ఆవులను తినివేశాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","కానీ అవి తిన్నా కూడా అవి తిన్నాయని ఎవరు చెప్పలేరు; అవి ముందు ఉన్నట్లే వికారంగా ఉన్నాయి. అప్పుడు నేను నిద్రలేచాను. ");
INSERT INTO telotsa_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“నా కలలో పుష్టిగా మంచిగా ఉన్న ఏడు వెన్నులు ఒకే కాడకు పెరుగుతున్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","వాటి తర్వాత పీలగా తూర్పుగాలికి ఎండిపోయిన మరో పీలవెన్నులు వాటి తర్వాత మొలిచాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","పీలవెన్నులు పుష్టిగా ఉన్న ఏడు వెన్నులను మ్రింగివేశాయి. ఇది మాంత్రికులకు చెప్పాను, కానీ దాని అర్థాన్ని చెప్పేవారు ఎవరూ లేరు.” ");
INSERT INTO telotsa_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","అప్పుడు యోసేపు ఫరోకు చెప్పాడు, “ఫరో కలల భావం ఒక్కటే. దేవుడు ఏమి చేయబోతున్నారో ఫరోకు తెలియజేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ఆ ఏడు మంచి ఆవులు ఏడు సంవత్సరాలు, అలాగే ఏడు మంచి వెన్నులు ఏడు సంవత్సరాలు; రెండు కలల భావం ఒకటే. ");
INSERT INTO telotsa_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","వాటి తర్వాత వచ్చిన చిక్కిపోయి వికారంగా ఉన్న ఏడు ఆవులు ఏడు సంవత్సరాలు, పీలగా తూర్పుగాలికి ఎండిపోయిన ఏడు వెన్నులు కూడా అవే ఏడు సంవత్సరాలు; అవి ఏడు సంవత్సరాలు కరువు కాలము. ");
INSERT INTO telotsa_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“నేను ఫరోకు చెప్పినట్టే జరుగుతుంది. దేవుడు తాను ఏమి చేయబోతున్నారో ఫరోకు చూపించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ఈజిప్టు దేశమంతటా గొప్ప సమృద్ధిగల ఏడు సంవత్సరాలు రాబోతున్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","కానీ వాటి తర్వాత ఏడు సంవత్సరాలు కరువు వస్తుంది. ఆ సమయంలో ఈజిప్టులో ఉండే సమృద్ధి అందరు మరిచిపోతారు, కరువు దేశాన్ని నాశనం చేస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","తర్వాత వచ్చే కరువు ఇంకా తీవ్రంగా ఉంటుంది కాబట్టి దేశంలో ఉండిన సమృద్ధి ఎవరికీ జ్ఞాపకం ఉండదు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","కల రెండు విధాలుగా ఫరోకు ఇవ్వబడిన కారణం ఏంటంటే ఇది దేవునిచే దృఢంగా నిర్ణయించబడింది, దేవుడు త్వరలో దానిని చేస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ఇప్పుడు ఫరో జ్ఞాన వివేచనలు కలిగిన ఒక వ్యక్తిని ఈజిప్టు అంతటి మీద అధికారిగా నియమించాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","సమృద్ధిగా పండే ఏడు సంవత్సరాల్లో పంటలో అయిదవ భాగాన్ని సేకరించడానికి ఫరో దేశమంతా పర్యవేక్షకులను నియమించాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","వారు ఈ మంచి సంవత్సరాల్లో పండే ధాన్యం సేకరించి ఫరో ఆధీనంలో పట్టణాల్లో ఆహారం ఉండేలా నిలువచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ఈ ఆహారం దేశం కోసం నిలువచేయబడి ఈజిప్టు మీదికి వచ్చే ఏడు సంవత్సరాల కరువు కాలంలో ఉపయోగించబడుతుంది, అప్పుడు కరువు ద్వారా దేశం నాశనం కాదు.” ");
INSERT INTO telotsa_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ఈ మాట ఫరోకు అతని అధికారులకు నచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","కాబట్టి ఫరో వారిని, “ఇతనిలా దేవుని ఆత్మ కలిగిన వారెవరినైనా కనుగొనగలమా?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","అప్పుడు ఫరో యోసేపుతో, “దేవుడు నీకు ఇదంతా తెలియజేశారు కాబట్టి, నీలా వివేచన జ్ఞానం కలిగిన వారెవరూ లేరు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","నా రాజభవన అధికారిగా నీవు ఉంటావు, నా ప్రజలంతా నీ ఆదేశాలకు లోబడతారు. సింహాసనం విషయంలో మాత్రమే నేను నీ పైవాడిగా ఉంటాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","కాబట్టి ఫరో యోసేపుతో, “నేను నిన్ను ఈజిప్టు దేశమంతటికి అధికారిగా ప్రకటిస్తున్నాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ఫరో తన రాజముద్ర ఉంగరం తీసి యోసేపు వ్రేలికి పెట్టాడు. సన్నని నారబట్టలు అతనికి తొడిగించాడు, అతని మెడలో బంగారు గొలుసు వేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","తన రెండవ రథంలో అతన్ని కూర్చోబెట్టాడు, అప్పుడు ప్రజలు, “నమస్కారం చేయండి!” అని అంటూ అతని ముందు కేకలు వేశారు. ఈ విధంగా అతడు యోసేపును దేశమంతటిమీద అధికారిగా చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","అప్పుడు ఫరో యోసేపుతో, “నేను ఫరోను, కానీ నీ అనుమతి లేకుండా ఈజిప్టు అంతటిలో ఎవరు కూడా తన చేయి కానీ కాలు కానీ ఎత్తరు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ఫరో యోసేపుకు జఫెనత్-ఫనేహు అనే పేరు పెట్టాడు, ఓనులో యాజకుడైన పోతీఫెర కుమార్తె, ఆసెనతును అతనికి భార్యగా ఇచ్చాడు. యోసేపు ఈజిప్టు దేశమంతటా పర్యటించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","యోసేపు ఈజిప్టు రాజైన ఫరో సేవ మొదలుపెట్టినప్పుడు అతని వయస్సు ముప్పై సంవత్సరాలు. యోసేపు ఫరో ఎదుట నుండి వెళ్లి, ఈజిప్టు దేశమంతా సంచరించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ఏడు సమృద్ధిగల సంవత్సరాల్లో భూమిపై విస్తారమైన పంట పండింది. ");
INSERT INTO telotsa_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","యోసేపు ఈజిప్టులో ఆ ఏడు సంవత్సరాల పంటనంతా సేకరించి పట్టణాల్లో నిల్వచేశాడు. ప్రతి పట్టణం చుట్టూ ఉన్న పొలాల్లో సేకరించిన ధాన్యాన్ని ఆ పట్టణాల్లోనే నిల్వచేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","యోసేపు సముద్రతీరాన ఇసుకంత విస్తారంగా ధాన్యాన్ని నిలువచేశాడు; అది విస్తారంగా ఉంది కాబట్టి దాన్ని కొలవడం ఆపేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","కరువు సంవత్సరాలకు ముందు యోసేపుకు ఓనులో యాజకుడైన పోతీఫెర కుమార్తె, ఆసెనతు ద్వారా ఇద్దరు కుమారులు పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","తన మొదటి కుమారునికి యోసేపు మనష్షే అని పేరు పెట్టి, “దేవుడు నా కష్టాలన్నీ, నా తండ్రి ఇంటివారందరినీ మరచిపోయేలా చేశారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","రెండవ కుమారునికి ఎఫ్రాయిం అని పేరు పెట్టి, “నాకు శ్రమలు కలిగిన దేశంలో దేవుడు నన్ను అభివృద్ధి చేశారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ఈజిప్టులో సమృద్ధి కలిగిన ఏడు సంవత్సరాలు ముగిశాయి, ");
INSERT INTO telotsa_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","యోసేపు చెప్పినట్టే ఏడు సంవత్సరాల కరువు ప్రారంభమయ్యింది. ఇతర దేశాల్లో కరువు ఉన్నది కానీ ఈజిప్టు దేశమంతా ఆహారం ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ఈజిప్టు అంతా కరువు అనుభవించడం ప్రారంభమైనప్పుడు, ఆహారం కోసం ప్రజలు ఫరోకు మొరపెట్టారు. అప్పుడు ఫరో ఈజిప్టు వారందరితో, “యోసేపు దగ్గరకు వెళ్లి అతడు చెప్పినట్టు చేయండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","దేశమంతటా కరువు వ్యాపించినప్పుడు, యోసేపు ధాన్య కొట్లన్నీ తెరిచి, ఈజిప్టువారికి ధాన్యం అమ్మాడు, ఎందుకంటే ఈజిప్టు దేశంలో కరువు చాలా తీవ్రంగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","లోకమంతా ఈజిప్టుకు వచ్చి యోసేపు దగ్గర ధాన్యం కొనుగోలు చేశారు, ఎందుకంటే కరువు అంతటా తీవ్రంగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","యాకోబు ఈజిప్టులో ధాన్యం ఉందని తెలుసుకుని, తన కుమారులతో, “ఎందుకు ఒకరి ముఖం ఒకరు చూసుకుంటూ ఉన్నారు? ");
INSERT INTO telotsa_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ఈజిప్టులో ధాన్యం ఉందని నేను విన్నాను. అక్కడికి వెళ్లి మన కోసం కొంత ధాన్యం కొనుక్కురండి, అప్పుడు మనం చావకుండ బ్రతుకుతాం” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","అప్పుడు యోసేపు సోదరులు పదిమంది ధాన్యం కొనడానికి ఈజిప్టుకు వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","అయితే యాకోబు యోసేపు తమ్ముడైన బెన్యామీనును పంపలేదు ఎందుకంటే అతనికి ఏదైన హాని కలుగుతుందని భయపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","కాబట్టి ఇశ్రాయేలు కుమారులు కూడా ధాన్యం కొనుగోలు చేయడానికి వచ్చారు ఎందుకంటే, కనాను దేశంలో కూడా కరువు వచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","అప్పుడు యోసేపు ఆ దేశమంతటిమీద అధికారిగా ఉంటూ, ఆ దేశ ప్రజలందరికి ధాన్యం అమ్మేవాడు. యోసేపు అన్నలు వచ్చి అతనికి సాష్టాంగపడి నమస్కారం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","యోసేపు వారిని చూసిన వెంటనే, వారిని గుర్తుపట్టాడు కాని తెలియనట్లుగా నటిస్తూ వారితో కఠినంగా మాట్లాడాడు. “మీరెక్కడ నుండి వచ్చారు?” అని అతడు అడిగాడు. వారు, “కనాను దేశం నుండి ఆహారం కొనడానికి వచ్చాం” అని జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","యోసేపు తన అన్నలను గుర్తుపట్టాడు కాని వారతన్ని గుర్తు పట్టలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","వారి గురించి తాను కన్న కలలు యోసేపు జ్ఞాపకం చేసుకుని, “మీరు వేగులవారు. మా దేశానికి చెందిన భద్రత రహస్యాలు తెలుసుకోడానికి వచ్చారు” అని వారితో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","వారు, “లేదు ప్రభువా, మీ దాసులమైన మేము ఆహారం కొనడానికి వచ్చాము. ");
INSERT INTO telotsa_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","మేమంతా ఒక్క మనుష్యుని కుమారులము. నీ దాసులమైన మేము యథార్థవంతులం, వేగులవారం కాము” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“లేదు! మా దేశ భద్రత రహస్యాలు తెలుసుకోవడానికి వచ్చారు” అని యోసేపు వారితో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","అందుకు వారు, “నీ దాసులమైన మేము పన్నెండుమంది అన్నదమ్ములం, ఒక్క మనుష్యుని కుమారులం, కనాను దేశంలో నివసిస్తాము. మాలో చిన్నవాడు మా తండ్రి దగ్గరే ఉన్నాడు, ఇంకొకడు చనిపోయాడు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","అప్పుడు యోసేపు వారితో, “నేను మీతో చెప్పిందే నిజం: మీరు వేగులవారే! ");
INSERT INTO telotsa_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ఫరో జీవం తోడు, మీ తమ్ముడు ఇక్కడకు వస్తేనే తప్ప మీరు ఈ స్థలం విడిచి వెళ్లడానికి వీల్లేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","మీ తమ్మున్ని తీసుకురావడానికి మీలో ఒకర్ని పంపి మిగిలినవారు జైల్లో ఉండాలి, అప్పుడు మీ మాటల్లో సత్యం ఉందో లేదో తెలుస్తుంది. ఒకవేళ లేకపోతే ఫరో జీవం తోడు, మీరు వేగులవారే!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","అతడు వారిని మూడు రోజుల వరకు జైల్లో ఉంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","మూడవ రోజున యోసేపు వారితో, “మీరు ఒక పని చేస్తే బ్రతికి ఉంటారు, ఎందుకంటే నేను దేవునికి భయపడేవాన్ని: ");
INSERT INTO telotsa_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","మీరు నిజంగా యథార్థవంతులైతే, మీ సోదరులలో ఒకరిని ఇక్కడ చెరసాలలో ఉండనివ్వండి, మిగితా వారు ఆకలితో ఉన్న మీ ఇంటివారికి ధాన్యం తీసుకెళ్లండి. ");
INSERT INTO telotsa_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","అయితే మీ చిన్న తమ్మున్ని నా దగ్గరకు తీసుకురావాలి, అప్పుడు మీ మాటలు స్థిరపరచబడతాయి, మీరు చావరు” అని అన్నాడు. వారు అలానే చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","అప్పుడు వారు ఒకరితో ఒకరు, “మన తమ్మున్ని బట్టి మనం ఇలా శిక్షించబడుతున్నాము. తనను చంపవద్దని అతడు మనలను ఎంత వేడుకున్నా మనం వినలేదు అప్పుడు అతడు ఎంత బాధపడ్డాడో చూశాం; మనం చేసిన ఆ దోషం వల్లే ఇప్పుడు మనకు ఈ దుస్థితి వచ్చింది” అని మాట్లాడుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","రూబేను జవాబిస్తూ, “ఈ చిన్నవాని పట్ల పాపం చేయవద్దని నేను చెప్పలేదా? అయినా మీరు వినిపించుకోలేదు! ఇప్పుడు తన రక్తం కోసం మనం లెక్క అప్పగించాలి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","యోసేపు దగ్గర భాషను తర్జుమా చేసేవాడు ఉన్నాడని అతడు వారి మాటలు అర్థం చేసుకోగలడని వారు గ్రహించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","యోసేపు వారి దగ్గర నుండి వెళ్లి ఏడ్చి తిరిగివచ్చి వారితో మళ్ళీ మాట్లాడాడు. వారిలో నుండి షిమ్యోనును పట్టుకుని వారి కళ్లముందే బంధించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","యోసేపు వారి సంచుల్లో ధాన్యం నింపి, ఎవరి బస్తాలో వారి వెండిని తిరిగి పెట్టి, ప్రయాణంలో వారికి అవసరమైన భోజనపదార్థాలు ఇవ్వుమని ఆదేశించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","వారు తమ ధాన్యాన్ని తమ గాడిదల మీద పెట్టుకుని వెళ్లిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","రాత్రి గడపడానికి ఒక స్థలంలో ఆగినప్పుడు, వారిలో ఒకడు గాడిదకు మేతపెడదామని సంచి విప్పాడు, గోనెసంచి విప్పగానే అందులో తన వెండి ఉండడం చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“నా వెండి నాకు తిరిగి ఇవ్వబడింది, నా గోనెసంచిలోనే అది ఉంది” అని సోదరులకు చెప్పాడు. వారి హృదయాలు కలవరపడ్డాయి. వారు వణకుతూ, ఒకరి వైపు ఒకరు తిరిగి, “దేవుడు మనకిలా చేశారేంటి?” అని చెప్పుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","వారు కనాను దేశంలో తమ తండ్రి యాకోబు దగ్గరకు వచ్చినప్పుడు, తమకు జరిగిందంతా అతనికి చెప్పారు. వారు అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ఆ దేశాధిపతి మాతో కఠినంగా మాట్లాడాడు, మేము ఆ దేశానికి వేగుచూడటానికి వచ్చామని అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","అతనికి, ‘మేము యథార్థవంతులం; వేగులవారం కాము. ");
INSERT INTO telotsa_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","మేము పన్నెండుమంది సోదరులం, ఒక తండ్రి కుమారులము. ఒకడు చనిపోయాడు, కనిష్ఠుడు కనానులో తండ్రి దగ్గర ఉన్నాడు’ అని చెప్పాము. ");
INSERT INTO telotsa_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“ఆ దేశాధిపతి మాతో, ‘ఇలా మీరు యథార్థవంతులని నాకు తెలుస్తుంది: మీ సోదరులలో ఒకరిని ఇక్కడ నా దగ్గర వదిలేసి, ఆకలితో ఉన్న మీ ఇంటివారికి ఆహారం తీసుకెళ్లండి. ");
INSERT INTO telotsa_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","కాని మీ తమ్మున్ని నా దగ్గరకు తీసుకురండి, తద్వారా మీరు యథార్థవంతులని తెలుసుకుంటాను. అప్పుడు మీ సోదరుని తిరిగి ఇచ్చేస్తాను, ఈ దేశంలో మీరు వ్యాపారం చేసుకోవచ్చు’ అన్నాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","వారు తమ గోనెసంచులను ఖాళీ చేస్తుండగా, ఎవరి గోనెసంచిలో వారి వెండి మూట ఉంది. వారు, వారి తండ్రి, వారి డబ్బు మూటలు చూసి భయపడిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","వారి తండ్రి యాకోబు వారితో, “మీరు నన్ను పిల్లలు కోల్పోయేలా చేశారు. యోసేపు లేడు, షిమ్యోను లేడు, ఇప్పుడు బెన్యామీనును కూడా తీసుకెళ్లాలని చూస్తున్నారు. ప్రతిదీ నాకు వ్యతిరేకంగా ఉంది!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","అప్పుడు రూబేను తన తండ్రితో, “నేను బెన్యామీనును తిరిగి నీ దగ్గరకు తీసుకురాకపోతే, నా ఇద్దరు కుమారులను నీవు చంపవచ్చు. అతన్ని నాకు అప్పగించు, నేను తిరిగి అతన్ని నీ దగ్గరకు తీసుకువస్తాను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","అయితే యాకోబు, “నా కుమారుడు నీతో అక్కడికి రాడు; అతని అన్న చనిపోయాడు, మిగిలింది ఒక్కడే. మీరు వెళ్లే ప్రయాణంలో ఏదైన హాని జరిగితే, మీరు నెరిసిన వెంట్రుకలతో ఉన్న నన్ను దుఃఖంలో సమాధికి తీసుకెళ్తారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","దేశంలో కరువు ఇంకా తీవ్రంగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ఈజిప్టు నుండి తెచ్చుకున్న ధాన్యమంతా వారు తిన్న తర్వాత, వారి తండ్రి వారితో, “మీరు తిరిగివెళ్లి మన కోసం ఇంకా కొంచెం ఆహారం కొనండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","కానీ యూదా అతనితో, “ఆ మనుష్యుడు, ‘మీ తమ్ముడు మీతో ఉండే వరకు నన్ను మీరు మళ్ళీ చూడరు’ అని గట్టిగా హెచ్చరించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ఒకవేళ మా తమ్మున్ని మాతో పంపితే, మేము వెళ్లి నీకు ఆహారం కొంటాము. ");
INSERT INTO telotsa_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","కానీ ఒకవేళ అతన్ని పంపకపోతే, మేము వెళ్లం ఎందుకంటే, ‘మీ తమ్ముడు మీతో ఉండకపోతే మీరు నన్ను మళ్ళీ చూడరు’ అని ఆ మనుష్యుడు అన్నాడు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","“మీకు ఇంకొక సోదరుడున్నాడని చెప్పి ఎందుకు ఈ శ్రమ నాకు తెచ్చి పెట్టారు?” అని ఇశ్రాయేలు అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","వారు, “ఆయన మమ్మల్ని ఖండితంగా ప్రశ్నించాడు. ‘మీ తండ్రి ఇంకా బ్రతికి ఉన్నాడా? మీకు ఇంకొక సోదరుడు ఉన్నాడా?’ అని అడిగాడు. మేము అతని ప్రశ్నలకు జవాబిచ్చాం అంతే. ‘మీ తమ్మున్ని ఇక్కడకు తీసుకురండి’ అని అంటాడని మాకు ఎలా తెలుస్తుంది?” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","అప్పుడు యూదా తన తండ్రి ఇశ్రాయేలుతో, “బాలున్ని నాతో పంపించు, మేము వెంటనే వెళ్తాము. అప్పుడు మేము నీవు మా పిల్లలు చావకుండ బ్రతుకుతాము. ");
INSERT INTO telotsa_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","నేను అతని భద్రతకు హామీ ఇస్తున్నాను; అతని కోసం నన్ను బాధ్యున్ని చేయవచ్చు. నేను అతన్ని నీ దగ్గరకు తిరిగి తీసుకువచ్చి నీ ఎదుట ఉంచకపోతే, నా జీవితం అంతా ఆ నిందను భరిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ఇలా ఆలస్యం కాకపోయి ఉంటే, రెండవసారి కూడా వెళ్లి వచ్చియుండేవారం” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","అప్పుడు వారి తండ్రి ఇశ్రాయేలు అన్నాడు, “ఒకవేళ అలాగైతే, ఇలా చేయండి: దేశంలో ఉన్న శ్రేష్ఠమైన వాటిని అంటే ఔషధతైలం, కొంచెం తేనె, కొన్ని సుగంధద్రవ్యాలు, బోళం, పిస్తా గింజలు, బాదం పప్పులు మీ సంచుల్లో పెట్టుకుని ఆ వ్యక్తికి కానుకగా తీసుకెళ్లండి. ");
INSERT INTO telotsa_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","మీ దగ్గర ఉన్న వెండికి రెట్టింపు తీసుకెళ్లండి, ఎందుకంటే మీ గోనెసంచులలో పెట్టబడిన వెండిని మీరు తిరిగి ఇచ్చేయాలి. బహుశ అది పొరపాటు కావచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","మీ సోదరున్ని కూడా తీసుకుని వెంటనే ఆ మనుష్యుని దగ్గరకు తిరిగి వెళ్లండి. ");
INSERT INTO telotsa_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","సర్వశక్తిగల దేవుడు ఆ మనుష్యుని ఎదుట కరుణ చూపును గాక తద్వారా మీ ఇంకొక సోదరుడు బెన్యామీను మీతో తిరిగి వచ్చేలా అనుమతిస్తాడు. నా మట్టుకైతే, ఒకవేళ నేను కోల్పోవలసి వస్తే కోల్పోతాను.” ");
INSERT INTO telotsa_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","కాబట్టి ఆ మనుష్యులు కానుకలను, రెట్టింపు డబ్బును, బెన్యామీనును కూడా తీసుకుని త్వరగా ఈజిప్టుకు వెళ్లి యోసేపు ఎదుట హాజరయ్యారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","యోసేపు వారితో బెన్యామీనును చూసి తన గృహనిర్వాహకునితో, “ఈ మనుష్యులను నా ఇంటికి తీసుకెళ్లి, ఒక జంతువును వధించి, భోజనం సిద్ధం చేయి; వారు మధ్యాహ్నం నాతో భోజనం చేస్తారు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ఆ మనుష్యుడు యోసేపు చెప్పినట్టు చేశాడు, వారిని యోసేపు ఇంటికి తీసుకెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","యోసేపు వారిని తన ఇంటికి తీసుకెళ్లినందుకు ఆ మనుష్యులు భయపడ్డారు. “మొదటిసారి మన గోనెసంచులలో పెట్టబడిన వెండి గురించి మనం ఇక్కడకు రావలసివచ్చింది. అతడు మనపై దాడి చేసి, మనలను బానిసలుగా బంధించి మన గాడిదలను తీసుకుంటాడు” అని అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","కాబట్టి వారు యోసేపు యొక్క గృహనిర్వాహకుని దగ్గరకు వెళ్లి ద్వారం దగ్గర అతనితో మాట్లాడారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“అయ్యా, మా మనవి వినండి. మేము మొదటిసారి ఆహారం కొనడానికే వచ్చాము. ");
INSERT INTO telotsa_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","కానీ మేము రాత్రి గడిపిన స్థలంలో మా గోనెసంచులను విప్పి చూస్తే, ఎవరు ఎంత వెండి తెచ్చారో సరిగ్గా అంతే వెండి వారి గోనెసంచిలో ఉంది. కాబట్టి మేము తిరిగి దానిని తెచ్చాము. ");
INSERT INTO telotsa_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ఆహారం కొనడానికి మరికొంత వెండిని కూడా తీసుకుని వచ్చాము. మా గోనెసంచులలో వెండిని ఎవరు పెట్టారో మాకు తెలియదు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","అప్పుడు అతడు, “మీకు క్షేమం కలుగును గాక మీరు భయపడకండి, మీ దేవుడు, మీ తండ్రి యొక్క దేవుడు, ఈ ధనాన్ని మీ గోనెసంచులలో పెట్టారు; మీ వెండి నాకు ముట్టింది” అని అన్నాడు. తర్వాత షిమ్యోనును వారి దగ్గరకు తీసుకువచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","గృహనిర్వాహకుడు ఆ మనుష్యులను యోసేపు ఇంట్లోకి తీసుకెళ్లాడు, కాళ్లు కడుక్కోడానికి వారికి నీళ్లిచ్చాడు, వారి గాడిదలకు మేత పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","తాము భోజనం చేయాల్సింది అక్కడే అని విన్నందుకు మధ్యాహ్నం యోసేపు రాక కోసం తమ కానుకలను సిద్ధపరచుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","యోసేపు ఇంటికి రాగానే, వారు ఇంట్లోకి తెచ్చిన కానుకలను అతనికి ఇచ్చి, అతని ఎదుట సాష్టాంగపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","వారు ఎలా ఉన్నారని వారిని అడిగి, “వృద్ధుడైన మీ తండ్రి గురించి మీరు నాకు చెప్పారు కదా, ఆయన ఎలా ఉన్నారు? ఇంకా బ్రతికే ఉన్నారా?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","వారు జవాబిస్తూ, “తమ దాసుడు, మా తండ్రి బ్రతికే ఉన్నాడు, క్షేమంగా ఉన్నాడు” అన్నారు, అప్పుడు వారు తలవంచి, సాష్టాంగపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","యోసేపు కళ్ళెత్తి తన తమ్ముడు అనగా తన సొంత తల్లి కుమారుడైన బెన్యామీనును చూసి, “మీరు నాకు చెప్పిన మీ చిన్న తమ్ముడు ఇతడేనా?” అని అడిగి, “నా కుమారుడా, దేవుడు నిన్ను కరుణించును గాక!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","తమ్మున్ని చూడగానే యోసేపుకు అతని మీద ప్రేమ పొర్లుకు వచ్చింది, అందుకు అతడు వెంటనే లోపలి గదిలోకి వెళ్లి ఏడ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","తన ముఖం కడుక్కున్న తర్వాత, తనను తాను అదుపుచేసుకుని, “భోజనం వడ్డించండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","సేవకులు యోసేపుకు తన బల్ల దగ్గర, అతని సోదరులకు వేరే బల్ల దగ్గర, అతనితో భోజనంచేస్తున్న ఈజిప్టువారికి వరుసగా భోజనం వడ్డించారు, ఎందుకంటే హెబ్రీయులతో కలసి భోజనం చేయడం ఈజిప్టువారికి అసహ్యము. ");
INSERT INTO telotsa_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","వారి వయస్సు ప్రకారం మొదటివాడు మొదలుకొని చివరివాని వరకు అతని ఎదుట కూర్చున్నారు; వారు ఆశ్చర్యంతో ఒకరినొకరు చూసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","యోసేపు బల్ల నుండి వారికి భోజనం వడ్డించబడినప్పుడు, ఇతరులకంటే అయిదు రెట్లు ఎక్కువగా బెన్యామీనుకు వడ్డించారు. కాబట్టి వారు అతనితో స్వేచ్ఛగా విందు చేసుకున్నారు, త్రాగారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","యోసేపు తన ఇంటి గృహనిర్వాహకుని పిలిచి, “ఈ మనుష్యులు మోసికొని వెళ్లగలిగినంత ఆహారంతో వారి సంచులు నింపి ఎవరి గోనెసంచిలో వారు రూకలుగా తెచ్చిన వెండిని కూడా పెట్టు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","తర్వాత కనిష్ఠుని గోనెసంచిలో మాత్రం ధాన్యం, రూకలుగా తెచ్చిన వెండితో పాటు నా వెండి గిన్నెను పెట్టు” అని సూచించాడు. అతడు యోసేపు చెప్పినట్టు చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","తెల్లవారినప్పుడు ఆ మనుష్యులు వారి గాడిదలతో పాటు పంపబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","పట్టణం నుండి వారింకా దూరం వెళ్లకముందే, యోసేపు గృహనిర్వాహకునితో, “వెంటనే ఆ మనుష్యుల వెంట వెళ్లు, వారిని పట్టుకున్నప్పుడు, ‘మేలుకు ప్రతిగా కీడును ఎందుకు చేశారు? ");
INSERT INTO telotsa_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ఇది మా యజమాని త్రాగడానికి, భవిష్యవాణి కోసం ఉపయోగించే గిన్నె కాదా? మీరు చేసింది చెడ్డ పని’ అని వారితో చెప్పు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","గృహనిర్వాహకుడు వారిని కలిసినప్పుడు, అవే మాటలు చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","అయితే వారు, “మా ప్రభువు ఎందుకు అలా అంటున్నాడు? మీ దాసులకు అలాంటి పని దూరమవును గాక! ");
INSERT INTO telotsa_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","మా గోనెసంచులలో దొరికిన వెండి తిరిగి కనాను దేశం నుండి తెచ్చాము. కాబట్టి వెండి లేదా బంగారం ఎందుకు నీ యజమాని ఇంటి నుండి దొంగిలిస్తాము? ");
INSERT INTO telotsa_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ఒకవేళ మీ దాసులలో ఎవరి దగ్గరైనా దొరికితే, వాడు చస్తాడు; మిగిలినవారం మా ప్రభువా బానిసలమవుతాం” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","అప్పుడు అతడు, “సరే మీరన్నట్టే కానివ్వండి; ఎవరి దగ్గర ఆ గిన్నె దొరుకుతుందో అతడు నాకు బానిస అవుతాడు, మిగితా వారు నిర్దోషులవుతారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","వారంతా త్వరత్వరగా గోనెసంచులను క్రిందికి దించి వాటిని తెరిచారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","అప్పుడు గృహనిర్వాహకుడు పెద్దవాడి నుండి ప్రారంభించి చిన్నవాడి వరకు సోదా చేశాడు. ఆ గిన్నె బెన్యామీను గోనెసంచిలో దొరికింది. ");
INSERT INTO telotsa_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ఇది చూసి వారు తమ బట్టలు చింపుకున్నారు. వారందరు తమ గాడిదల మీద తన గోనెసంచులు ఎత్తుకుని, తిరిగి పట్టణానికి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","యూదా అతని సోదరులు వచ్చినప్పుడు యోసేపు ఇంట్లోనే ఉన్నాడు, వారు అతని ఎదుట సాష్టాంగపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","యోసేపు వారితో, “మీరు చేసిన ఈ పని ఏంటి? నా లాంటి మనుష్యుని భవిష్యవాణి ద్వారా విషయాలు తెలుసుకుంటాడని మీకు తెలియదా?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","యూదా జవాబిస్తూ, “మా ప్రభువా, మేమేమి చెప్పగలం? మా నిర్దోషత్వాన్ని ఎలా నిరూపించుకోగలం? మీ దాసుల అపరాధాన్ని దేవుడు బయటపెట్టారు. మేమిప్పుడు మా ప్రభువు బానిసలం; మాలో ఎవరి సంచిలో గిన్నె దొరుకుతుందో వాడు కూడా మా ప్రభువుకు దాసుడవుతాడు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","అయితే యోసేపు, “అలా చేయడం నాకు దూరం అవును గాక! ఎవరి దగ్గర గిన్నె దొరికిందో అతడు మాత్రమే నా బానిస. మిగిలిన మీరు మీ తండ్రి దగ్గరకు సమాధానంగా వెళ్లండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","అప్పుడు యూదా అతని దగ్గరకు వెళ్లి అన్నాడు: “నా ప్రభువా, మీ దాసుని క్షమించి నా ప్రభువుతో ఒక్క మాట మాట్లాడనివ్వండి. మీరు ఫరోతో సమానులైనను మీ దాసునిపై కోప్పడకండి. ");
INSERT INTO telotsa_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","నా ప్రభువు తమ దాసులను, ‘మీకు తండ్రి గాని సోదరుడు గాని ఉన్నాడా?’ అని అడిగారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","దానికి మేము, ‘నా ప్రభువా, మాకు వృద్ధుడైన తండ్రి, వృద్ధాప్యంలో తనకు పుట్టిన చిన్నకుమారుడు ఉన్నాడు. అతని అన్న చనిపోయాడు, అతని తల్లి కుమారులలో ఆ ఒక్కడే మిగిలాడు, అతని తండ్రికి ఆ చిన్నవాడంటే చాలా ప్రేమ’ అని చెప్పాము. ");
INSERT INTO telotsa_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“అప్పుడు మీరు మీ దాసులతో, ‘అతన్ని నేను చూడాలి, నా దగ్గరకు తీసుకురండి’ అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","అందుకు మేము నా ప్రభువుతో, ‘అతడు తండ్రిని విడిచి ఉండలేడు; ఒకవేళ అతడు విడిచిపెట్టి వస్తే, అతని తండ్రి చనిపోతాడు’ అని చెప్పాము. ");
INSERT INTO telotsa_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","కాని మీరు మీ దాసులతో, ‘మీ చిన్న తమ్ముడు మీతో వస్తేనే తప్ప మీరు నాకు కనబడవద్దు’ అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","మేము మా తండ్రి దగ్గరకు వెళ్లి మా ప్రభువు చెప్పిందంతా చెప్పాము. ");
INSERT INTO telotsa_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“మా తండ్రి, ‘ఇంకొంచెం ఆహారం కొనడానికి మళ్ళీ వెళ్లండి’ అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","అందుకు మేము అతనితో, ‘మేము వెళ్లలేము. మా చిన్న తమ్ముడు మాతో వెళ్తేనే మేము వెళ్తాము. మా చిన్న తమ్ముడు మాతో ఉంటేనే తప్ప మేము వెళ్లి ఆయన ముఖం చూడలేం’ అని చెప్పాము. ");
INSERT INTO telotsa_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“మీ దాసుడైన మా తండ్రి మాతో, ‘నా భార్య నాకు ఇద్దరు కుమారులను కన్నదని మీకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","వారిలో ఒకడు వెళ్లి తిరిగి రాలేదు. నిస్సందేహంగా అతన్ని ఏదో అడవి జంతువు చంపి ముక్కలు చేసి ఉంటుంది. అప్పటినుండి అతన్ని నేను చూడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","మీరు నా దగ్గర నుండి వీన్ని కూడా తీసుకెళ్తే, వీనికి ఏదైన హాని సంభవిస్తే, దుఃఖిస్తూ ఉన్న, తల నెరసిన ఈ వ్యక్తిని సమాధికి పంపిన వారవుతారు’ అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“కాబట్టి ఇప్పుడు మా తమ్ముడు మాతో లేకుండ, మీ దాసుడైన మా తండ్రి దగ్గరకు మేము తిరిగి వెళ్తే, ఈ చిన్నవానితో ముడిపడి ఉన్న మా తండ్రి, ");
INSERT INTO telotsa_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","మాతో చిన్నవాడు లేకపోవడం చూసి, అతడు చనిపోతాడు. మీ దాసులమైన మేము తల నెరిసిన మా తండ్రిని దుఃఖంలోనే సమాధికి తీసుకెళ్లిన వారమవుతాము. ");
INSERT INTO telotsa_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","మీ దాసుడనైన నేను బాలుని భద్రతకు నా తండ్రికి హామీ ఇచ్చాను. ‘నేను అతన్ని తీసుకురాకపోతే, నా జీవితాంతం ఆ నిందను నేను భరిస్తాను’ అని చెప్పాను. ");
INSERT INTO telotsa_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“కాబట్టి ఇప్పుడు, ఈ చిన్నవానికి బదులు నా ప్రభువు యొక్క దాసుని మీ దగ్గర బానిసగా ఉండనివ్వండి, ఈ చిన్నవాన్ని మాత్రం తన సోదరులతో తిరిగి వెళ్లనివ్వండి. ");
INSERT INTO telotsa_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","చిన్నవాడు నాతో లేకుండ నా తండ్రి దగ్గరకు ఎలా తిరిగి వెళ్లగలను? లేదు! నా తండ్రికి కలిగే బాధను నేను చూడలేను.” ");
INSERT INTO telotsa_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","అప్పుడు యోసేపు తన సేవకులందరి ఎదుట తనను తాను అదుపు చేసుకోలేక, “అందరిని నా ఎదుట నుండి పంపివేయండి!” అని బిగ్గరగా చెప్పాడు. తన సోదరులకు తనను తాను తెలియపరచుకున్నప్పుడు యోసేపుతో ఎవరు లేరు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","అతడు ఈజిప్టువారు వినేటంతగా బిగ్గరగా ఏడ్చాడు, ఫరో ఇంటివారు దాని గురించి విన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","యోసేపు తన సోదరులతో, “నేను యోసేపును! నా తండ్రి ఇంకా బ్రతికే ఉన్నాడా?” అని అన్నాడు. అతన్ని చూసి అతని సోదరులు కంగారుపడి అతనికి జవాబు ఇవ్వలేకపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","యోసేపు తన సోదరులతో, “నా దగ్గరకు రండి” అన్నాడు. వారు అతని దగ్గరకు వచ్చాక, “నేను మీ సోదరుడైన యోసేపును, మీరు ఈజిప్టుకు అమ్మివేసినవాన్ని! ");
INSERT INTO telotsa_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ఇప్పుడు నన్ను ఇక్కడకు అమ్మివేసినందుకు బాధపడకండి, మీపై మీరు కోప్పడకండి, ఎందుకంటే జీవితాలను రక్షించడానికి మీకంటే ముందే దేవుడు నన్ను పంపించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ఇప్పటికి దేశంలో కరువు వచ్చి రెండు సంవత్సరాలు అయ్యింది, ఇంకా వచ్చే అయిదు సంవత్సరాలు దున్నడం, కోత కోయడం ఉండదు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","అయితే దేవుడు భూమిపై మిమ్మల్ని సంరక్షించి, మీ జీవితాలను కాపాడడానికి మీకంటే ముందు నన్ను ఇక్కడకు పంపించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“కాబట్టి ఇప్పుడు, నన్ను ఇక్కడకు పంపింది మీరు కాదు, దేవుడే. ఆయన నన్ను ఫరోకు తండ్రిగా, అతని ఇంటికి ప్రభువుగా, ఈజిప్టు అంతటికి పాలకునిగా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ఇప్పుడు నా తండ్రి దగ్గరకు వెంటనే వెళ్లి అతనితో, ‘నీ కుమారుడైన యోసేపు ఇలా అన్నాడు: దేవుడు నన్ను ఈజిప్టు అంతటి మీద ప్రభువుగా చేశారు. నా దగ్గరకు వచ్చేయండి; ఆలస్యం చేయకండి! ");
INSERT INTO telotsa_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","మీరు, మీ పిల్లలు, మీ మనవళ్లు, మీ మందలు, మీ పశువులు, మీతో ఉన్న సమస్తం గోషేను ప్రాంతంలో నాకు సమీపంగా ఉండవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ఇంకా రాబోయే అయిదు సంవత్సరాలు కరువు ఉంటుంది అయితే అక్కడ మిమ్మల్ని నేను పోషిస్తాను. లేకపోతే మీకు మీ ఇంటివారికి పేదరికం ఏర్పడుతుంది.’ ");
INSERT INTO telotsa_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“మాట్లాడుతుంది నిజంగా నేనే అని స్వయంగా మీరు, నా తమ్ముడైన బెన్యామీను చూడవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ఈజిప్టులో నాకు ఇవ్వబడిన ఘనత గురించి, మీరు చూసిన ప్రతి దాని గురించి నా తండ్రికి చెప్పండి. నా తండ్రిని ఇక్కడకు త్వరగా తీసుకురండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","తర్వాత తన సోదరుడైన బెన్యామీనుపై మెడ మీద చేతులు వేసి, ఏడ్చాడు, బెన్యామీను అతన్ని హత్తుకుని ఏడ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","తన సోదరులందరిని ముద్దు పెట్టుకుని ఏడ్చాడు. తర్వాత అతని సోదరులు అతనితో మాట్లాడారు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ఫరో ఇంటివారికి యోసేపు సోదరులు వచ్చారని సమాచారం చేరినప్పుడు, ఫరో, అతని అధికారులందరు సంతోషించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ఫరో యోసేపుతో, “మీ సోదరులతో, ‘మీరు ఇలా చేయండి: మీ జంతువులను ఎక్కించి, కనాను దేశానికి తిరిగివెళ్లి, ");
INSERT INTO telotsa_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","మీ తండ్రిని మీ కుటుంబాలను తీసుకురండి. ఈజిప్టు దేశంలో శ్రేష్ఠమైన నేలను మీకిస్తాను. మీరు శ్రేష్ఠమైన ఆహారం తినవచ్చు’ అని చెప్పు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“ఇలా కూడ చెప్పమని ఆదేశిస్తున్నాను, ‘మీరు ఇలా చేయండి: మీ పిల్లలు, మీ భార్యల కోసం ఈజిప్టు నుండి కొన్ని బండ్లను తీసుకెళ్లండి, మీ తండ్రిని తీసుకురండి. ");
INSERT INTO telotsa_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","అక్కడ మీ సామాన్ల గురించి చింతించకండి ఎందుకంటే ఈజిప్టులో శ్రేష్ఠమైనవన్నీ మీవి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","కాబట్టి ఇశ్రాయేలు కుమారులు అలాగే చేశారు. యోసేపు ఫరో ఆజ్ఞమేరకు వారికి బండ్లను ఇచ్చాడు, ప్రయాణం కోసం అన్ని ఏర్పాట్లు చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","అతడు వారందరికి క్రొత్త బట్టలు ఇచ్చాడు, కాని బెన్యామీనుకు మూడువందల షెకెళ్ళ వెండి, అయిదు జతల బట్టలు ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","తన తండ్రికి పంపించింది ఇది: పది గాడిదల మీద ఈజిప్టులో నుండి శ్రేష్ఠమైన వస్తువులు, పది ఆడగాడిదలు మీద ధాన్యం, ఆహారం, తన ప్రయాణానికి కావలసిన ఇతర సామాగ్రి. ");
INSERT INTO telotsa_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","తర్వాత తన సోదరులను పంపిస్తూ, వారు వెళ్లేటప్పుడు, “మీలో మీరు గొడవపడకండి!” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","కాబట్టి వారు ఈజిప్టు నుండి వెళ్లారు, కనాను దేశంలో ఉన్న తమ తండ్రి యాకోబు దగ్గరకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","వారు అతనితో, “యోసేపు ఇంకా బ్రతికి ఉన్నాడు! నిజానికి, అతడు ఈజిప్టు అంతటికి పాలకుడు” అని చెప్పారు. అది విని యాకోబు ఆశ్చర్యపోయాడు; అతడు వారి మాటను నమ్మలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","అయితే యోసేపు తమతో చెప్పిందంతా వారు అతనికి చెప్పి, యోసేపు తనను తీసుకెళ్లడానికి పంపిన బండ్లను చూసినప్పుడు, తమ తండ్రియైన యాకోబు ప్రాణం తెప్పరిల్లింది. ");
INSERT INTO telotsa_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","అప్పుడు ఇశ్రాయేలు, “నాకిది చాలు, నా కుమారుడు యోసేపు ఇంకా బ్రతికే ఉన్నాడు. నేను చనిపోకముందు వెళ్లి అతన్ని చూస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","కాబట్టి ఇశ్రాయేలు తనకున్నదంతటితో బయలుదేరాడు, బెయేర్షేబకు వచ్చాక, తన తండ్రియైన ఇస్సాకు దేవునికి బలులు అర్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","రాత్రి దర్శనం ద్వారా ఇశ్రాయేలుతో దేవుడు మాట్లాడారు. ఆయన, “యాకోబూ! యాకోబూ!” అని పిలిచారు. అతడు, “చిత్తం, నేను ఉన్నాను” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ఆయన, “నేను దేవున్ని, నీ తండ్రి యొక్క దేవున్ని. ఈజిప్టుకు వెళ్లడానికి భయపడకు, అక్కడ నిన్ను గొప్ప జనంగా చేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","నేను నీతో ఈజిప్టుకు వస్తాను, ఖచ్చితంగా నిన్ను తిరిగి తీసుకువస్తాను. యోసేపు స్వహస్తాలే నీ కళ్లు మూస్తాయి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","అప్పుడు యాకోబు బెయేర్షేబ నుండి బయలుదేరాడు, ఇశ్రాయేలు కుమారులు తమ తండ్రియైన యాకోబును, వారి పిల్లలను, వారి భార్యలను ఫరో పంపిన బండ్లలో తీసుకెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","కాబట్టి యాకోబు, అతని సంతానమంతా వారి పశువులతో, కనానులో వారు సంపాదించిన సమస్త సంపదతో ఈజిప్టుకు వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","యాకోబు తనతో తన కుమారులను, మనవళ్లను, కుమార్తెలను, మనవరాళ్లను, తన సంతానమంతటిని ఈజిప్టుకు తీసుకువచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ఈజిప్టుకు వెళ్లిన ఇశ్రాయేలు కుమారుల (యాకోబు అతని సంతానం) పేర్లు: రూబేను, యాకోబు యొక్క మొదటి కుమారుడు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","రూబేను కుమారులు: హనోకు, పల్లు, హెస్రోను, కర్మీ. ");
INSERT INTO telotsa_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","షిమ్యోను కుమారులు: యెమూయేలు, యామీను, ఓహదు, యాకీను, సోహరు, కనాను స్త్రీ యొక్క కుమారుడైన షావూలు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","లేవీ కుమారులు: గెర్షోను, కహాతు, మెరారి. ");
INSERT INTO telotsa_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","యూదా కుమారులు: ఏరు, ఓనాను, షేలా, పెరెసు, జెరహు. (కాని ఏరు, ఓనాను కనాను దేశంలో చనిపోయారు). పెరెసు కుమారులు: హెస్రోను, హామూలు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ఇశ్శాఖారు కుమారులు: తోలా, పువా, యోబు, షిమ్రోను. ");
INSERT INTO telotsa_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","జెబూలూను కుమారులు: సెరెదు, ఏలోను, యహలేలు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","వీరు పద్దనరాములో లేయాకు యాకోబుకు పుట్టిన కుమారులు, దీనా వారి కుమార్తె. కుమారులు, కుమార్తెలు కలిసి వీరంతా ముప్పై ముగ్గురు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","గాదు కుమారులు: సిప్యోను, హగ్గీ, షూనీ, ఎస్బోను, ఏరీ, అరోది, అరేలీ. ");
INSERT INTO telotsa_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ఆషేరు కుమారులు: ఇమ్నా, ఇష్వా, ఇష్వీ, బెరీయా. శెరహు వారి సోదరి. బెరీయా కుమారులు: హెబెరు, మల్కీయేలు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","వీరు లాబాను తన కుమార్తె లేయాకు ఇచ్చిన జిల్పా ద్వారా యాకోబుకు కలిగిన సంతానం మొత్తం పదహారు మంది. ");
INSERT INTO telotsa_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","యాకోబు భార్య రాహేలు యొక్క కుమారులు: యోసేపు, బెన్యామీను. ");
INSERT INTO telotsa_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ఈజిప్టులో యోసేపుకు ఓను పట్టణానికి యాజకుడైన పోతీఫెర కుమార్తె ఆసెనతు ద్వారా మనష్షే, ఎఫ్రాయిం పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","బెన్యామీను కుమారులు: బేల, బెకెరు, అష్బేలు, గెరా, నయమాను, ఏహీ, రోషు, ముప్పీము, హుప్పీము, అర్దు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","వీరు యాకోబుకు కలిగిన రాహేలు సంతానం మొత్తం పద్నాలుగు మంది. ");
INSERT INTO telotsa_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","దాను కుమారుడు: హూషీము. ");
INSERT INTO telotsa_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","నఫ్తాలి కుమారులు: యహజీయేలు, గూనీ, యేజెరు, షిల్లేము. ");
INSERT INTO telotsa_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","వీరు లాబాను తన కుమార్తె రాహేలుకు ఇచ్చిన బిల్హా ద్వారా యాకోబుకు కలిగిన సంతానం మొత్తం ఏడుగురు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","యాకోబుతో ఈజిప్టుకు అతని కుమారుల భార్యలు కాక, యాకోబు సంతతివారు మొత్తం అరవై ఆరు మంది వ్యక్తులు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ఈజిప్టులో యోసేపుకు పుట్టిన కుమారులు ఇద్దరితో కలిపి, ఈజిప్టుకు వెళ్లిన యాకోబు కుటుంబీకులంతా డెబ్బైమంది. ");
INSERT INTO telotsa_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","గోషేనుకు త్రోవ చూపడానికి యాకోబు యూదాను తనకన్నా ముందు యోసేపు దగ్గరకు పంపాడు. వారు గోషేను ప్రాంతం చేరుకున్నప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","యోసేపు తన రథం సిద్ధం చేయించుకుని తన తండ్రి ఇశ్రాయేలును కలవడానికి గోషేనుకు వెళ్లాడు. యోసేపు కనుపరచుకున్న వెంటనే, తన తండ్రిని కౌగిలించుకుని చాలాసేపు ఏడ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ఇశ్రాయేలు యోసేపుతో, “నీవు ఇంకా బ్రతికే ఉన్నావని నేను కళ్లారా చూశాను కాబట్టి, ఇప్పుడు హాయిగా చనిపోగలను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","అప్పుడు యోసేపు తన సోదరులతో తన తండ్రి ఇంటివారితో, “నేను వెళ్లి ఫరోతో మాట్లాడి అతనికి, ‘కనాను దేశంలో నివసించే నా సోదరులు, నా తండ్రి ఇంటివారు నా దగ్గరకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ఈ మనుష్యులు కాపరులు; వారు పశువులను మేపుతారు, వారు తమ మందలను, పశువులను, వారికి ఉన్నదంతా తెచ్చారు’ అని చెప్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ఫరో మిమ్మల్ని పిలిపించి, ‘మీ వృత్తి ఏంటి?’ అని అడిగితే, ");
INSERT INTO telotsa_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‘మీ సేవకులు మా పితరులు చేసినట్టే బాల్యం నుండి పశువులను మేపేవారము’ అని జవాబివ్వాలి. అప్పుడు గోషేనులో స్థిరపడడానికి మీకు అనుమతి వస్తుంది, ఎందుకంటే గొర్రెల కాపరులంటే ఈజిప్టువారికి అసహ్యం” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","యోసేపు వెళ్లి ఫరోతో, “నా తండ్రి, నా సోదరులు కనాను దేశం నుండి వారి గొర్రెల మందలు, పశువులు, వారి సమస్తంతో వచ్చారు, ఇప్పుడు గోషేనులో ఉన్నారు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","అతడు తన సోదరులలో అయిదుగురిని ఫరోకు ఎదుట కనుపరిచాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ఫరో ఆ సోదరులతో, “మీ వృత్తి ఏంటి?” అని అడిగాడు. “మీ దాసులు మా పూర్వికుల్లా గొర్రెల కాపరులు” అని వారు ఫరోకు జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","వారు అతనితో, “మేము కొంతకాలం ఇక్కడ నివసించడానికి వచ్చాం ఎందుకంటే కనానులో కరువు తీవ్రంగా ఉంది, మీ దాసుల గొర్రెల మందలకు మేత లేదు. కాబట్టి ఇప్పుడు మీ దాసులను గోషేనులో నివసించనివ్వండి” అని కూడా అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ఫరో యోసేపుతో, “నీ తండ్రి, సోదరులు నీ దగ్గరకు వచ్చారు, ");
INSERT INTO telotsa_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ఈజిప్టు దేశమంతా నీ ముందుంది; శ్రేష్ఠమైన ప్రాంతంలో నీ తండ్రిని, నీ సోదరులను ఉంచు. గోషేనులో వారు నివసించవచ్చు. వీరిలో ప్రత్యేక సామర్థ్యం కలిగినవారు ఎవరైనా ఉంటే, నా సొంత పశువులకు ముఖ్య కాపరులుగా నియమించు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","తర్వాత యోసేపు తన తండ్రి యాకోబును తీసుకువచ్చి ఫరో ఎదుట కనుపరిచాడు. యాకోబు ఫరోను దీవించిన తర్వాత, ");
INSERT INTO telotsa_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ఫరో, “నీ వయసెంత?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","యాకోబు ఫరోతో, “నేను యాత్రచేసిన సంవత్సరాలు నూట ముప్పై. నేను బ్రతికిన సంవత్సరాలు తక్కువ, అవి కూడా శ్రమతో నిండి ఉన్నాయి, అవి నా పూర్వికుల యాత్ర సంవత్సరాలతో సమానం కాదు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","తర్వాత యాకోబు ఫరోను దీవించి, అతని ఎదుట నుండి వెళ్లిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","కాబట్టి యోసేపు తన తండ్రిని, తన సోదరులను ఈజిప్టులో స్థిరపరచి, దేశంలో శ్రేష్ఠమైన భాగంలో, ఫరో చెప్పినట్టు రామెసేసు జిల్లాను వారికి స్వాస్థ్యంగా ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","యోసేపు తన తండ్రికి, తన సోదరులకు, తన తండ్రి ఇంటివారికందరికి వారి పిల్లల లెక్క ప్రకారం ఆహారాన్ని కూడా అందించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","అయితే దేశమంతటిలో ఆహారం లేదు ఎందుకంటే కరువు తీవ్రంగా ఉంది; ఈజిప్టు కనాను దేశాలు కరువును బట్టి ఆకలితో అలమటించాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","యోసేపు ఈజిప్టు కనాను దేశాలకు, ధాన్యం కొనుగోలుకు వచ్చిన డబ్బు మొత్తం సేకరించి ఫరో రాజభవనానికి తెచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ఈజిప్టు కనాను ప్రజల డబ్బు అయిపోయినప్పుడు, ఈజిప్టు వారంతా యోసేపు దగ్గరకు వచ్చి, “మాకు ఆహారం ఇవ్వండి. మీ కళ్లముందే మేము ఎందుకు చావాలి? మా డబ్బంతా అయిపోయింది” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","అందుకు యోసేపు, “అలాగైతే మీ పశువులను తీసుకురండి, మీ డబ్బు అయిపోయింది కాబట్టి మీ పశువులకు బదులుగా నేను ఆహారం సరఫరా చేస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","కాబట్టి వారు యోసేపు దగ్గరకు తమ పశువులను తెచ్చారు. వారి గుర్రాలు, గొర్రెలు, మేకలు, పశువులు, గాడిదలకు బదులుగా వారికి ఆహారం ఇచ్చాడు. ఆ సంవత్సరమంతా వారి పశువులకు బదులుగా ఆహారం అందించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","సంవత్సరం ముగిసిన తర్వాత, మరుసటి సంవత్సరం వారు అతని దగ్గరకు వచ్చి, “మేము మా ప్రభువు నుండి నిజాన్ని దాచలేము, మా డబ్బు అయిపోయింది, మా పశువులు మీకే ఇచ్చాం, ఇక మా శరీరాలు, మా భూమి తప్ప మా ప్రభువుకు ఇవ్వడానికి ఏమీ మిగల్లేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","మేము, మా భూమి మీ కళ్లముందే నశించడం బాగుంటుందా? ఆహారం కోసం మమ్మల్ని, మా భూములను కొనండి. మేము మా భూములతో సహా ఫరోకు బానిసలమవుతాము. మేము చావకుండ బ్రతికేలా పొలాలు పాడైపోకుండ మాకు విత్తనాలు ఇవ్వండి” అని మనవి చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","కాబట్టి యోసేపు ఫరో కోసం ఈజిప్టు భూమి అంతా కొన్నాడు. ఈజిప్టు వారంతా కరువు చాలా తీవ్రంగా ఉండడం వల్ల తమ భూములన్నీ అమ్మివేశారు. భూమి ఫరో ఆధీనంలోనికి వచ్చింది, ");
INSERT INTO telotsa_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","యోసేపు ఈజిప్టు యొక్క సరిహద్దు నుండి ఇంకొక సరిహద్దు వరకు ఉన్న ప్రజలందరినీ బానిసలుగా చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","అయితే, యాజకులకు చెందిన భూమిని మాత్రం అతడు కొనలేదు. ఎందుకంటే వారు క్రమంగా ఫరో నుండి బత్తెం పొందుకునే వారు, ఆ బత్తెంతో వారికి సరిపడే ఆహారం ఉంది. కాబట్టి వారు తమ భూమిని అమ్మలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","యోసేపు ప్రజలతో, “నేను మీ భూములను మిమ్మల్ని ఈ రోజు ఫరో కోసం కొన్నాను. ఇదిగో మీరు భూమిలో నాటడానికి విత్తనాలు తీసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","అయితే పంట వచ్చినప్పుడు అయిదవ వంతు ఫరోకు ఇవ్వండి. మిగితా నాలుగు వంతులు మీ పొలాల్లో విత్తనం కోసం, మీకూ మీ ఇంటివారికి మీ పిల్లలకు ఆహారం కోసం ఉంచుకోండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","అప్పుడు వారు, “మీరు మా జీవితాలను కాపాడారు. ప్రభువా, మామీద మీ దయ ఉంచండి; మేము ఫరోకు బానిసలుగా ఉంటాం” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","కాబట్టి యోసేపు ఈజిప్టు దేశాన్ని ఉద్దేశించి శాసనం నియమించాడు. అది నేటి వరకు ఉంది. పంటంతటిలో అయిదవ వంతు ఫరోకు చెందుతుంది. అయితే యాజకుల స్థలం మాత్రం ఫరోకు చెందలేదు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ఇశ్రాయేలీయులు ఈజిప్టులో గోషేను ప్రదేశంలో స్థిరపడ్డారు. అక్కడ స్వాస్థ్యం సంపాదించుకుని ఫలించి, సంతానాభివృద్ధి చెందుతూ వేగంగా విస్తరించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","యాకోబు ఈజిప్టులో పదిహేడు సంవత్సరాలు జీవించాడు, అతడు జీవించిన సంవత్సరాలు నూట నలభై ఏడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ఇశ్రాయేలు చనిపోయే సమయం సమీపించినప్పుడు, తన కుమారుడైన యోసేపును పిలిపించి, “నీ దృష్టిలో నేను దయ పొందినవాడనైతే, నా తొడ క్రింద చేయి పెట్టి, నా పట్ల మంచితనాన్ని, నమ్మకత్వాన్ని చూపుతావని ప్రమాణం చేయి. ఈజిప్టులో నన్ను పాతిపెట్టకు, ");
INSERT INTO telotsa_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","నా పితరులతో నేను నిద్రించినప్పుడు, ఈజిప్టు నుండి నన్ను తీసుకెళ్లి వారు పాతిపెట్టబడిన దగ్గరే నన్ను పాతిపెట్టు” అని చెప్పాడు. “నీవు చెప్పినట్టే చేస్తాను” అని యోసేపు జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","అయితే యాకోబు, “నాతో ప్రమాణం చేయి” అని అన్నాడు. అప్పుడు యోసేపు అతనితో ప్రమాణం చేశాడు, ఇశ్రాయేలు తన చేతికర్ర మీద ఆనుకుని ఆరాధించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","కొంతకాలం తర్వాత, “నీ తండ్రి అస్వస్థతతో ఉన్నాడు” అని యోసేపుకు చెప్పబడింది. కాబట్టి తన ఇద్దరు కుమారులు, మనష్షేను ఎఫ్రాయిమును తీసుకెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","“నీ కుమారుడు, యోసేపు నీ దగ్గరకు వచ్చాడు” అని యాకోబుకు చెప్పబడినప్పుడు, ఇశ్రాయేలు బలం తెచ్చుకుని పడక మీద కూర్చున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","యాకోబు యోసేపుతో ఇలా అన్నాడు, “సర్వశక్తిగల దేవుడు కనాను దేశంలో లూజు దగ్గర నాకు ప్రత్యక్షమై నన్ను దీవించి, ");
INSERT INTO telotsa_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘నేను నిన్ను ఫలవంతం చేస్తాను, నీ సంఖ్యను పెంచుతాను. నేను నిన్ను ప్రజల సమాజంగా చేస్తాను, నీ తర్వాత నీ వారసులకు ఈ భూమిని నిత్య స్వాస్థ్యంగా ఇస్తాను’ అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“కాబట్టి ఇప్పుడు, నేను నీ దగ్గరకు రాకముందు ఈజిప్టులో నీకు పుట్టిన నీ ఇద్దరు కుమారులు నా వారిగా లెక్కించబడతారు; రూబేను షిమ్యోనుల్లా, ఎఫ్రాయిం మనష్షే కూడా నా వారిగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","వారి తర్వాత నీకు పిల్లలు పుడితే వారు నీ సంతానమవుతారు; వారు వారసత్వంగా పొందిన భూభాగంలో వారు తమ సోదరుల పేర్లతో లెక్కించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","నేను పద్దన నుండి తిరిగి వస్తున్నప్పుడు, మేము ఇంకా దారిలో ఉండగానే, కనాను దేశంలో, ఎఫ్రాతాకు కొద్ది దూరంలో రాహేలు చనిపోయింది. కాబట్టి నేను ఆమెను ఎఫ్రాతా (అనగా బేత్లెహేము) దారి ప్రక్కన సమాధి చేశాను.” ");
INSERT INTO telotsa_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ఇశ్రాయేలు యోసేపు కుమారులను చూసినప్పుడు, “వీరు ఎవరు?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","“వారు దేవుడు నాకు ఇక్కడ అనుగ్రహించిన కుమారులు” అని యోసేపు తన తండ్రికి చెప్పాడు. అప్పుడు ఇశ్రాయేలు, “నేను వారిని దీవించేలా వారిని నా దగ్గరకు తీసుకురా” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ఇశ్రాయేలు వృద్ధాప్యంలో ఉన్నందుకు దృష్టి మందగించింది కాబట్టి అతడు చూడలేకపోయాడు. కాబట్టి యోసేపు తన కుమారులను అతనికి సమీపంగా తెచ్చాడు, తన తండ్రి వారిని ముద్దు పెట్టుకుని కౌగిలించుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ఇశ్రాయేలు యోసేపుతో, “నేను నిన్ను మళ్ళీ చూస్తానని అనుకోలేదు, కాని ఇప్పుడు నాకు దేవుడు నీ పిల్లలను కూడా చూసే భాగ్యం ఇచ్చారు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","అప్పుడు యోసేపు వారిని ఇశ్రాయేలు మోకాళ్లమీద నుండి తీసివేసి అతనికి తలవంచి నమస్కరించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","యోసేపు వారిద్దరిని తీసుకుని, ఎఫ్రాయిమును తన కుడివైపు ఇశ్రాయేలుకు ఎడమవైపు మనష్షేను తన ఎడమవైపు ఇశ్రాయేలుకు కుడివైపు ఉంచి అతని దగ్గరకు తీసుకువచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","అయితే ఇశ్రాయేలు తన చేతులను యుక్తిగా త్రిప్పి చిన్నవాడైన ఎఫ్రాయిం తలపై తన కుడిచేతిని మొదటి కుమారుడైన మనష్షే తలపై తన ఎడమ చేతిని పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","అప్పుడు అతడు యోసేపును దీవిస్తూ అన్నాడు, “నా పితరులైన అబ్రాహాము ఇస్సాకులు ఎవరి ఎదుట నమ్మకంగా నడిచారో ఆ దేవుడు, నేటి వరకు నా జీవితమంతా నాకు కాపరిగా ఉన్న దేవుడు, ");
INSERT INTO telotsa_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","నన్ను ప్రతి హాని నుండి విడిపించిన దూత ఈ బాలురను దీవించును గాక. వారు నా నామాన నా పితరులైన అబ్రాహాము ఇస్సాకుల నామాన పిలువబడుదురు గాక, భూమిపై వారు గొప్పగా విస్తరించుదురు గాక.” ");
INSERT INTO telotsa_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","తన తండ్రి ఎఫ్రాయిం తలపై కుడిచేయి పెట్టడం చూసి యోసేపు అసంతృప్తి చెందాడు; ఎఫ్రాయిం తలపై నుండి మనష్షే తలపైకి చేయి మార్చడానికి తన తండ్రి చేతిని పట్టుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","యోసేపు అతనితో, “లేదు, నా తండ్రి, ఇతడు మొదటి కుమారుడు; ఇతని తలపై నీ కుడిచేయిని పెట్టు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","కాని అతని తండ్రి ఒప్పుకోకుండా, “నాకు తెలుసు, నా కుమారుడా, నాకు తెలుసు, అతడు కూడా జనాల సమూహమై గొప్పవాడవుతాడు. అయినా, అతని తమ్ముడు అతనికంటే గొప్పవాడవుతాడు, అతని వారసులు జనాల సమూహం అవుతారు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","అతడు వారిని ఆ రోజు దీవిస్తూ అన్నాడు, “నీ నామంలో ఇశ్రాయేలు ఈ ఆశీర్వాదం ప్రకటిస్తున్నాడు: ‘దేవుడు మిమ్మల్ని ఎఫ్రాయిములా మనష్షేలా చేయును గాక.’ ” కాబట్టి ఎఫ్రాయిమును మనష్షేకు ముందుగా పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","తర్వాత ఇశ్రాయేలు యోసేపుతో, “నేను చనిపోబోతున్నాను, అయితే దేవుడు మీతో ఉంటారు. మిమ్మల్ని తిరిగి మీ పూర్వికుల స్థలమైన కనానుకు తిరిగి తీసుకెళ్తారు. ");
INSERT INTO telotsa_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","నీ సోదరులకంటే ఎక్కువగా ఒక కొండ ప్రాంతం, నా ఖడ్గం, నా విల్లుతో అమోరీయుల దగ్గర నుండి తీసుకున్న కొండ ప్రాంతాన్ని నీకు ఇస్తున్నాను” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","యాకోబు తన కుమారులను పిలిపించి ఇలా అన్నాడు: “చుట్టూ కూడి రండి, రాబోయే రోజుల్లో మీకు ఏమి జరగబోతుందో నేను మీకు చెప్తాను. ");
INSERT INTO telotsa_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“యాకోబు కుమారులారా, సమావేశమై వినండి మీ తండ్రియైన ఇశ్రాయేలు చెప్పేది వినండి. ");
INSERT INTO telotsa_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“రూబేనూ, నీవు నా పెద్ద కుమారుడవు, నా శక్తి నా బలం యొక్క మొదటి గుర్తు, ఘనతలోను శక్తిలోను ఆధిక్యత గలవాడవు ");
INSERT INTO telotsa_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","కానీ నీళ్లలా అస్థిరంగా ఉండే నీవు ఇకపై రాణించవు, ఎందుకంటే నీవు నీ తండ్రి మంచం ఎక్కావు, నా పడకను అపవిత్రం చేశావు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“షిమ్యోను లేవీ సోదరులు వారి ఖడ్గాలు హింసాయుధాలు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","వారి సమావేశాల్లో నేను ప్రవేశించకుందును గాక, నా ఘనతను వారి కూడికలో చేర్చకుందును గాక, ఎందుకంటే వారి కోపంలో వారు మనుష్యులను చంపేశారు సరదా కోసం ఎడ్ల కాలి నరాలు తెగగొట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","వారి కోపం శపించబడాలి, అది భయంకరమైనది, వారి ఆగ్రహం ఎంతో క్రూరమైనది! వారిని యాకోబులో చెల్లాచెదురు చేస్తాను, ఇశ్రాయేలులో వారిని చెదరగొడతాను. ");
INSERT INTO telotsa_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“యూదా, నీ సోదరులు నిన్ను ప్రశంసిస్తారు; నీ చేయి నీ శత్రువుల మెడ మీద ఉంటుంది; నీ తండ్రి కుమారులు నీకు తలవంచుతారు ");
INSERT INTO telotsa_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","యూదా, నీవు ఒక కొదమసింహం; నా కుమారుడా, నీవు వేటాడి తిరిగి వచ్చావు. అతడు సింహంలా కాళ్లు ముడుచుకుని, ఆడ సింహంలా పడుకుంటాడు, అతన్ని లేపడానికి ఎవరు తెగిస్తారు? ");
INSERT INTO telotsa_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","రాజదండం యూదా దగ్గర నుండి తొలగదు, అతని కాళ్ల మధ్య నుండి రాజదండం తొలగదు, అది ఎవరికి చెందుతుందో అతడు వచ్చేవరకు తొలగదు, దేశాలు అతనికి విధేయులై ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","అతడు ద్రాక్షచెట్టుకు తన గాడిదను, మంచి ద్రాక్షచెట్టుకు గాడిద పిల్లను కడతాడు; అతడు ద్రాక్షరసంలో తన బట్టలను, ద్రాక్షరసంలో తన వస్త్రాలను ఉతుకుతాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","అతని కళ్లు ద్రాక్షరసం కంటే ఎర్రగా, అతని పళ్లు పాలకంటే తెల్లగా ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“జెబూలూను సముద్రతీరాన నివసిస్తాడు ఓడలకు రేవు అవుతాడు; అతని సరిహద్దు సీదోను వరకు వ్యాపిస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ఇశ్శాఖారు రెండు గొర్రెల దొడ్ల మధ్య పడుకుని ఉన్న బలమైన గాడిద వంటివాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","అతడు తన విశ్రాంతి స్థలం ఎంత మంచిదో, అతని నేల ఎంత ఆహ్లాదకరమో చూసినప్పుడు, అతడు భుజం వంచి శ్రమించి, వెట్టిచాకిరికి సమర్పించుకుంటాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“దాను ఇశ్రాయేలు గోత్రాల్లో ఒక గోత్రంలా తన ప్రజలకు న్యాయం చేస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","దాను దారిన ఉండే పాములా, మార్గంలో ఉండే విషసర్పంలా, గుర్రాల మడిమెలు కాటు వేస్తాడు. అప్పుడు స్వారీ చేస్తున్నవాడు వెనుకకు పడతాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“యెహోవా! మీ రక్షణ కోసం వేచియున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“గాదు దోపిడి మూక ద్వారా దాడి చేయబడతాడు, కానీ అతడు వారి మడిమెలను కొడతాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“ఆషేరుకు ఆహారం సమృద్ధిగా ఉంటుంది; రాజులకు తగిన భోజనం అతడు సమకూరుస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“నఫ్తాలి స్వేచ్ఛ ఇవ్వబడిన లేడి అతడు అందమైన లేడిపిల్లలను కంటాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“యోసేపు ఫలించే కొమ్మ, నీటిబుగ్గ దగ్గర ఫలించే కొమ్మ దాని తీగెలు గోడ మీదికి ఎక్కి ప్రాకుతాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","అసూయతో విలుకాండ్రు అతనిపై దాడి చేశారు; అతనిపై బాణాలు విసిరారు. ");
INSERT INTO telotsa_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","కానీ అతని విల్లు స్థిరంగా నిలిచింది, అతని చేతులు బలంగా ఉన్నాయి, ఎందుకంటే యాకోబు యొక్క బలవంతుని హస్తాన్ని బట్టి, కాపరి, ఇశ్రాయేలు యొక్క బండను బట్టి, ");
INSERT INTO telotsa_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","నీకు సహాయం చేసే నీ తండ్రి యొక్క దేవున్ని బట్టి, పైనున్న ఆకాశాల దీవెనలతో, క్రింది అగాధజలాల దీవెనలతో, స్తనాల దీవెనలతో గర్భం యొక్క దీవెనలతో, నిన్ను ఆశీర్వదించే సర్వశక్తిమంతున్ని బట్టి బలపరచబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","నీ తండ్రి ఆశీర్వాదాలు పురాతన పర్వత ఆశీర్వాదాల కంటే, ప్రాచీన కొండల యొక్క కోరదగిన వాటికంటే గొప్పవి. ఇవన్నీ యోసేపు తలమీద, తన సోదరులలో అధికారిగా ఉన్న వాడిపై ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“బెన్యామీను ఆకలితో ఉన్న తోడేలు వంటివాడు; ఉదయం అతడు ఎరను మ్రింగుతాడు, సాయంత్రం దోచుకున్నది పంచుతాడు.” ");
INSERT INTO telotsa_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ఇవన్నీ ఇశ్రాయేలు యొక్క పన్నెండు గోత్రాలు. వారి తండ్రి ఎవరి దీవెన ప్రకారం వారిని దీవిస్తూ వారికి చెప్పింది అదే. ");
INSERT INTO telotsa_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","తర్వాత అతడు వారికి ఈ సూచనలు ఇచ్చాడు: “నేను నా జనుల దగ్గరకు చేరబోతున్నాను. మీరు నన్ను నా పూర్వికుల దగ్గర, హిత్తీయుడైన ఎఫ్రోను గుహలో, కనానులో మమ్రే దగ్గర ఉన్న మక్పేలా మైదానంలో, అంటే అబ్రాహాము సమాధి స్థలంగా హిత్తీయుడైన ఎఫ్రోను దగ్గర పొలంతో పాటు కొన్న గుహలో పాతిపెట్టండి. ");
INSERT INTO telotsa_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","అక్కడే అబ్రాహాము అతని భార్య శారా సమాధి చేయబడ్డారు, అక్కడే ఇస్సాకు అతని భార్య రిబ్కా సమాధి చేయబడ్డారు, అక్కడే నేను లేయాను సమాధి చేశాను. ");
INSERT INTO telotsa_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ఆ పొలం, అందులోని గుహ హిత్తీయుల దగ్గర కొనబడ్డాయి.” ");
INSERT INTO telotsa_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","యాకోబు తన కుమారులకు సూచనలు ఇచ్చిన తర్వాత, మంచంపై తన కాళ్లు ముడుచుకుని తుది శ్వాస విడిచాడు, తన ప్రజల దగ్గరకు చేర్చబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","యోసేపు తన తండ్రి మీద పడి ఏడ్చి ముద్దు పెట్టుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","తర్వాత తన తండ్రి ఇశ్రాయేలు శవాన్ని సుగంధ ద్రవ్యాలతో భద్రపరచమని వైద్యులకు ఆదేశించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","కాబట్టి వైద్యులు పూర్తి నలభై రోజులు తీసుకుని భద్రపరిచారు, ఎందుకంటే భద్రపరచడానికి అవసరమయ్యే సమయం అది. ఈజిప్టువారు అతని కోసం డెబ్బై రోజులు దుఃఖించారు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","సంతాప దినాలు గడిచాక, యోసేపు ఫరో ఇంటివారితో, “నేను మీ దృష్టిలో దయ పొందితే, నా పక్షాన ఫరోతో మాట్లాడండి. అతనితో, ");
INSERT INTO telotsa_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘నా తండ్రి నా చేత ప్రమాణం చేయించుకుని, “నేను చనిపోబోతున్నాను; కనాను దేశంలో నా కోసం నేను త్రవ్వించుకున్న సమాధిలో నన్ను పాతిపెట్టండి” అని చెప్పాడు. కాబట్టి నాకు సెలవిస్తే నేను వెళ్లి నా తండ్రిని పాతిపెట్టి తిరిగి వస్తాను’ అని చెప్పండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","అప్పుడు ఫరో, “నీవు వెళ్లి, అతడు నీతో ప్రమాణం చేయించినట్టు నీ తండ్రిని పాతిపెట్టు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","కాబట్టి యోసేపు తన తండ్రిని పాతిపెట్టడానికి వెళ్లినప్పుడు అతనితో ఫరో అధికారులందరు, అతని ఇంటి పెద్దలు, ఈజిప్టు ఉన్నతాధికారులందరు, ");
INSERT INTO telotsa_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","యోసేపు ఇంటివారందరు, అతని సోదరులు, అతని తండ్రి ఇంటివారితో వెళ్లారు. కేవలం వారి పిల్లలను, వారి మందలను, పశువులను గోషేనులో విడిచిపెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","రథాలు, రథసారధులు కూడా అతనితో వెళ్లారు. అది చాలా పెద్ద గుంపు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","వారు యొర్దాను దగ్గర ఉన్న ఆటదు నూర్పిడి కళ్లం దగ్గర చేరినప్పుడు, వారు బిగ్గరగా, ఘోరంగా ఏడ్చారు; అక్కడ తన తండ్రి కోసం యోసేపు ఏడు రోజుల సంతాప కాలం పాటించాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","అక్కడ నివసించే కనానీయులు ఆటదు నూర్పిడి కళ్లం దగ్గర ఏడ్వడం చూసి, “ఈజిప్టువారు శోకంతో సంతాప వేడుకను జరుపుకుంటున్నారు” అని అన్నారు. అందుకే యొర్దాను దగ్గర ఉన్న ఆ స్థలం ఆబేల్-మిస్రాయిము అని పిలువబడింది. ");
INSERT INTO telotsa_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","కాబట్టి యాకోబు ఆజ్ఞాపించినట్టు అతని కుమారులు చేశారు: ");
INSERT INTO telotsa_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","అతన్ని కనాను దేశానికి మోసుకెళ్లి, అబ్రాహాము సమాధి స్థలంగా హిత్తీయుడైన ఎఫ్రోను దగ్గర పొలంతో పాటు కొన్న మమ్రే దగ్గర ఉన్న మక్పేలా పొలంలో ఉన్న గుహలో సమాధి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","తన తండ్రిని పాతిపెట్టిన తర్వాత యోసేపు తన సోదరులతో, సమాధి కార్యక్రమానికి వచ్చిన వారందరితో ఈజిప్టుకు తిరిగి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","తమ తండ్రి చనిపోయాడని యోసేపు సోదరులు చూసి, “ఒకవేళ యోసేపు మనపై కక్ష పెట్టుకుని మనం చేసిన తప్పులకు ప్రతి కీడు చేస్తే ఎలా?” అని అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","కాబట్టి వారు యోసేపుకు ఇలా కబురు పంపారు, “నీ తండ్రి చనిపోకముందు ఇలా ఈ సూచనలు ఇచ్చాడు: ");
INSERT INTO telotsa_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘యోసేపుతో ఇలా మీరు చెప్పాలి: నీ సోదరులు నిన్ను హీనంగా చూస్తూ నీ పట్ల చేసిన పాపాలను తప్పులను క్షమించమని చెప్తున్నాను.’ కాబట్టి దయచేసి నీ తండ్రి యొక్క దేవుని సేవకుల పాపాలను క్షమించు.” వారి కబురు అందిన తర్వాత యోసేపు ఏడ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","అప్పుడు తన సోదరులు అతని దగ్గరకు వచ్చి సాష్టాంగపడి, “మేము నీ బానిసలం” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","అయితే యోసేపు వారితో, “భయపడకండి, నేనేమైన దేవుని స్థానంలో ఉన్నానా? ");
INSERT INTO telotsa_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","మీరు నాకు హాని చేయాలనుకున్నారు కానీ ఎంతోమంది జీవితాలను కాపాడడానికి, ఇప్పుడు ఏదైతే జరుగుతుందో దానిని సాధించడానికి దేవుడు దానిని మేలుకే మార్చారు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","కాబట్టి ఇప్పుడు భయపడకండి. నేను మీకు, మీ పిల్లలకు సమకూరుస్తాను” అని అన్నాడు. అతడు వారికి మళ్ళీ అభయమిచ్చి దయతో మాట్లాడాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","యోసేపు తన తండ్రి కుటుంబంతో కలిసి ఈజిప్టులో నివసించాడు. అతడు నూటపది సంవత్సరాలు జీవించాడు, ");
INSERT INTO telotsa_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ఎఫ్రాయిం పిల్లల మూడవ తరాన్ని చూశాడు. మనష్షే కుమారుడైన మాకీరుకు పుట్టిన పిల్లలు కూడా యోసేపు సొంతవారిగా పెరిగారు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","యోసేపు తన సోదరులతో, “నేను చనిపోబోతున్నాను. అయితే దేవుడు తప్పకుండా మిమ్మల్ని దర్శించి, ఈ దేశం నుండి ఆయన అబ్రాహాముకు, ఇస్సాకుకు, యాకోబుకు ప్రమాణం చేసిన దేశానికి మిమ్మల్ని తీసుకెళ్తారు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","యోసేపు ఇశ్రాయేలు కుమారులతో ప్రమాణం చేయించుకుని, “దేవుడు ఖచ్చితంగా మిమ్మల్ని దర్శిస్తారు, అప్పుడు మీరు ఈ స్థలం నుండి నా ఎముకలను తీసుకెళ్లండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","యోసేపు నూటపది సంవత్సరాల వయస్సులో చనిపోయాడు. అతని శవాన్ని సుగంధ ద్రవ్యాలతో భద్రపరిచాక, ఈజిప్టులో అతని శరీరాన్ని ఒక శవపేటికలో ఉంచారు.");
INSERT INTO telotsa_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","తమ కుటుంబాలతో యాకోబు వెంట ఈజిప్టుకు వెళ్లిన ఇశ్రాయేలు కుమారుల పేర్లు: ");
INSERT INTO telotsa_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","రూబేను, షిమ్యోను, లేవీ, యూదా; ");
INSERT INTO telotsa_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ఇశ్శాఖారు, జెబూలూను, బెన్యామీను; ");
INSERT INTO telotsa_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","దాను, నఫ్తాలి; గాదు, ఆషేరు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","యాకోబు సంతతివారందరు డెబ్బైమంది; అప్పటికే యోసేపు ఈజిప్టులో ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","కొన్ని సంవత్సరాల తర్వాత యోసేపు, అతని అన్నదమ్ములు ఆ తరం వారందరు చనిపోయారు, ");
INSERT INTO telotsa_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","అయితే ఇశ్రాయేలీయులు అత్యధికంగా ఫలించారు; వారు గొప్పగా విస్తరించారు, అభివృద్ధి చెందారు, వారి సంఖ్య అంతకంతకు అభివృద్ధి పొంది వారున్న ప్రదేశం వారితోనే నిండిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","కొంతకాలం తర్వాత, యోసేపు గురించి తెలియని ఒక క్రొత్త రాజు ఈజిప్టులో అధికారంలోకి వచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","అతడు తన ప్రజలతో, “చూడండి, ఈ ఇశ్రాయేలీయులు సంఖ్యలో, బలంలో మనలను అధిగమించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","మనం వారితో యుక్తిగా నడుచుకోవాలి, లేకపోతే వారి సంఖ్య ఇంకా అధికమవుతుంది. ఒకవేళ యుద్ధం వస్తే వారు మన శత్రువులతో చేరి మనకు వ్యతిరేకంగా యుద్ధం చేసి ఈ దేశం నుండి వెళ్లిపోతారేమో” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","కాబట్టి వారిని అణచివేయాలని వారితో వెట్టిచాకిరి చేయించడానికి వారిపై బానిస యజమానులను నియమించారు, ఫరో కోసం పీతోము రామెసేసు అనే రెండు పట్టణాలను గిడ్డంగులుగా కట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","అయితే వారు ఎంతగా అణచివేయబడ్డారో, అంతకన్నా ఎక్కువ విస్తరించి వారు వ్యాపించారు; కాబట్టి ఈజిప్టు ప్రజలు ఇశ్రాయేలీయులను బట్టి భయపడి, ");
INSERT INTO telotsa_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","వారి చేత వెట్టిచాకిరి చేయించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","మట్టి పనిలో, ఇటుకల పనిలో, పొలంలో చేసే ప్రతి పనిలో వారిచేత కఠిన సేవ చేయిస్తూ వారి జీవితాలను దుర్భరంగా మార్చారు. ఈజిప్టు ప్రజలు వారితో కఠినంగా పని చేయించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ఈజిప్టు రాజు, షిఫ్రా పూయా అనే హెబ్రీ మంత్రసానులతో మాట్లాడుతూ, ");
INSERT INTO telotsa_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“హెబ్రీ స్త్రీలకు ప్రసవ సమయంలో కాన్పుపీట దగ్గర మీరు వారికి సహాయం చేస్తున్నప్పుడు పుట్టింది మగపిల్లవాడైతే వానిని చంపెయ్యండి, ఆడపిల్ల పుడితే బ్రతకనివ్వండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","అయితే ఆ మంత్రసానులు దేవునికి భయపడి ఈజిప్టు రాజు తమతో చెప్పింది చేయకుండా మగపిల్లలను బ్రతకనిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ఈజిప్టు రాజు ఆ స్త్రీలను పిలిపించి, “మీరెందుకు ఇలా చేశారు? మగపిల్లలను ఎందుకు బ్రతకనిచ్చారు?” అని వారిని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","అందుకు ఆ మంత్రసానులు, “హెబ్రీ స్త్రీలు ఈజిప్టు స్త్రీల వంటివారు కారు; వారు బలం గలవారు, మంత్రసానులు వారి దగ్గరకు రావడానికి ముందే ప్రసవిస్తున్నారు” అని ఫరోతో చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","కాబట్టి దేవుడు ఆ మంత్రసానుల పట్ల దయ చూపించారు, ప్రజలు మరింత ఎక్కువగా విస్తరించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ఆ మంత్రసానులు దేవునికి భయపడ్డారు, కాబట్టి ఆయన వారి సొంత కుటుంబాలను వృద్ధిచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","అప్పుడు ఫరో, “హెబ్రీయులకు పుట్టిన ప్రతి మగపిల్లవాన్ని నైలు నదిలో పడవేసి, ఒకవేళ ఆడపిల్లను అయితే బ్రతకనివ్వాలి” అని ఆజ్ఞాపించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ఆ రోజుల్లో లేవీ గోత్రపు పురుషుడు లేవీ స్త్రీని పెళ్ళి చేసుకున్నాడు, ");
INSERT INTO telotsa_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ఆమె గర్భవతియై ఒక కుమారుడిని కన్నది. అతడు చక్కగా ఉండడం చూసి, ఆమె వానిని మూడు నెలలు దాచిపెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","కాని ఆమె వానిని ఇక దాచలేకపోయినప్పుడు, వాని కోసం ఒక జమ్ము బుట్ట తీసుకుని దానికి జిగటమన్ను తారు పూసింది. ఆ పిల్లవాన్ని అందులో పడుకోబెట్టి దానిని నైలు నది ఒడ్డున ఉన్న జమ్ములో ఉంచింది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","అతనికి ఏమి జరుగుతుందో చూడడానికి ఆ పిల్లవాని అక్క దూరంలో నిలబడి ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ఫరో కుమార్తె స్నానం చేయడానికి నైలు నదికి రాగా ఆమె పనికత్తెలు నది ఒడ్డున నడుస్తున్నారు. ఆమె జమ్ము మధ్యలో ఉన్న పెట్టెను చూసి దానిని తీసుకురావడానికి తన దాసిని పంపించింది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","దానిని తెరిచి ఆ పిల్లవాన్ని చూసింది. ఆ పిల్లవాడు ఏడ్వడం చూసిన ఆమె అతనిపై కనికరపడి, “వీడు హెబ్రీయుల పిల్లల్లో ఒకడు” అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","అప్పుడు ఆ పిల్లవాని అక్క ఫరో కుమార్తెతో, “ఈ పిల్లవాన్ని నీకోసం పెంచడానికి నేను వెళ్లి హెబ్రీ స్త్రీలలో ఒకరిని పిలుచుకొని రమ్మంటారా?” అని అడిగింది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","అందుకు ఆమె, “సరే, వెళ్లు” అన్నది. కాబట్టి ఆ అమ్మాయి వెళ్లి ఆ బిడ్డ తల్లిని తీసుకువచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ఫరో కుమార్తె ఆమెతో, “నీవు ఈ బిడ్డను తీసుకెళ్లి నా కోసం పాలిచ్చి పెంచు, నేను నీకు జీతమిస్తాను” అని చెప్పింది. ఆమె ఆ బిడ్డను తీసుకెళ్లి పెంచింది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","పిల్లవాడు పెద్దయ్యాక, ఆమె అతన్ని ఫరో కుమార్తె దగ్గరకు తీసుకెళ్లింది, అతడు ఆమె కుమారుడయ్యాడు. “నేను అతన్ని నీటి నుండి బయటకు తీశాను” అని ఆమె అతనికి మోషే అని పేరు పెట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","కొన్ని సంవత్సరాల తర్వాత, మోషే పెద్దవాడైన తర్వాత ఒక రోజు అతడు తన సొంత ప్రజలు ఉన్న చోటికి వెళ్లి వారి దుస్థితిని చూశాడు. అప్పుడు అతడు తన సొంత ప్రజల్లో ఒకడైన ఒక హెబ్రీయున్ని ఒక ఈజిప్టువాడు కొట్టడం చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","మోషే అటు ఇటు తిరిగి ఎవరూ లేకపోవడం చూసి ఆ ఈజిప్టువాన్ని చంపి ఇసుకలో దాచిపెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","మరునాడు అతడు బయటకు వెళ్లినప్పుడు ఇద్దరు హెబ్రీయులు పోట్లాడుకోవడం చూశాడు. అతడు వారిలో తప్పు చేసినవానితో, “నీ తోటి హెబ్రీయున్ని ఎందుకు కొడుతున్నావు?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","అందుకు అతడు, “మామీద అధికారిగా న్యాయాధిపతిగా నిన్ను ఎవరు నియమించారు? ఆ ఈజిప్టువాన్ని చంపినట్లు నన్ను కూడా చంపాలని అనుకుంటున్నావా?” అన్నాడు. అప్పుడు మోషే, “నేను చేసిన పని అందరికి తెలిసిపోయింది” అని అనుకుని భయపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ఫరో ఈ సంగతి విన్నప్పుడు, అతడు మోషేను చంపడానికి ప్రయత్నించాడు, కాని మోషే ఫరో దగ్గరనుండి పారిపోయి మిద్యానులో జీవించడానికి వెళ్లాడు, అక్కడ ఒక బావి దగ్గర కూర్చున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","మిద్యాను యాజకునికి ఏడుగురు కుమార్తెలు ఉన్నారు, వారు వచ్చి తమ తండ్రి మందకు నీళ్లు పెట్టడానికి నీళ్లు తోడి తొట్టెలు నింపడం మొదలుపెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","కొంతమంది గొర్రెల కాపరులు వచ్చి వారిని తరిమివేశారు, అయితే మోషే లేచి వారిని రక్షించి వారి మందకు నీళ్లు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","వారు తమ తండ్రియైన రెయూయేలు దగ్గరకు తిరిగి వచ్చినప్పుడు అతడు, “ఈ రోజు మీరు ఇంత త్వరగా ఎందుకు వచ్చారు?” అని వారిని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","అందుకు వారు, “ఒక ఈజిప్టువాడు మమ్మల్ని గొర్రెల కాపరుల బారి నుండి కాపాడాడు. అంతేకాక మాకు, మందకు నీళ్లు తోడి పెట్టాడు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","అందుకు రగూయేలు, “అయితే, అతడు ఎక్కడున్నాడు? అతన్ని ఎందుకు విడిచిపెట్టి వచ్చారు? అతన్ని భోజనానికి పిలుచుకొని రండి” అని తన కుమార్తెలతో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","మోషే ఆ వ్యక్తితో ఉండడానికి అంగీకరించాడు. అతడు తన కుమార్తెయైన సిప్పోరాను మోషేకిచ్చి పెళ్ళి చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","సిప్పోరా ఒక కుమారుని కన్నది, మోషే, “నేను పరాయి దేశంలో పరదేశినయ్యాను” అని అతనికి గెర్షోము అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","కొన్ని సంవత్సరాలు గడచిన తర్వాత, ఈజిప్టు రాజు చనిపోయాడు. ఇశ్రాయేలీయులు తమ బానిసత్వంలో మూల్గుతూ మొరపెట్టారు, తమ బానిస చాకిరీని బట్టి వారు పెట్టిన మొర దేవుని దగ్గరకు చేరింది. ");
INSERT INTO telotsa_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","దేవుడు వారి మూల్గును విని, అబ్రాహాము ఇస్సాకు యాకోబులతో తాను చేసిన తన ఒడంబడికను జ్ఞాపకం చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","దేవుడు ఇశ్రాయేలీయులను చూసి వారి పట్ల దయ చూపించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ఈ సమయంలో, మోషే మిద్యానులో యాజకుడైన యెత్రో అనే తన మామ మందను మేపుతూ, మందను అరణ్యానికి చాలా దూరంగా నడిపించి దేవుని పర్వతమైన, హోరేబు దగ్గరకు వచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","అక్కడ ఒక పొదలో మండుతున్న అగ్నిజ్వాలల్లో యెహోవా దూత అతనికి ప్రత్యక్షమయ్యాడు. ఆ పొద అగ్నితో మండుతూ ఉన్నప్పటికీ అది కాలిపోకపోవడం మోషే చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","అప్పుడు మోషే, “నేను అక్కడికి వెళ్లి ఆ పొద ఎందుకు కాలిపోవడం లేదనే ఆ గొప్ప అద్భుతాన్ని చూస్తాను” అని అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","దానిని చూడడానికి అతడు అక్కడికి రావడం యెహోవా చూసినప్పుడు, ఆ పొద మధ్యలో నుండి దేవుడు, “మోషే! మోషే!” అని అతన్ని పిలిచారు. అందుకు మోషే, “నేను ఇక్కడ ఉన్నాను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","అందుకు దేవుడు, “దగ్గరకు రావద్దు, నీవు నిలబడిన స్థలం పరిశుద్ధస్థలం కాబట్టి నీ చెప్పులు విప్పు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ఇంకా ఆయన, “నేను నీ తండ్రి దేవుడను, అనగా అబ్రాహాము దేవుడను ఇస్సాకు దేవుడను యాకోబు దేవుడను” అన్నారు. అప్పుడు మోషే దేవుని వైపు చూడడానికి భయపడి, తన ముఖాన్ని దాచుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","అప్పుడు యెహోవా, “నేను ఈజిప్టులో ఉన్న నా ప్రజల బాధను చూశాను. వారిచేత వెట్టిచాకిరి చేయిస్తున్న అధికారులను గురించి వారు నాకు చేసిన మొరను నేను విన్నాను, వారి శ్రమల గురించి నాకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","కాబట్టి ఈజిప్టువారి చేతిలో నుండి వారిని విడిపించడానికి ఆ దేశంలో నుండి విశాలమైన మంచి దేశంలోనికి, అనగా కనానీయుల, హిత్తీయుల, అమోరీయుల, పెరిజ్జీయుల, హివ్వీయుల, యెబూసీయుల దేశమైన పాలు తేనెలు ప్రవహించే దేశంలోనికి వారిని తీసుకెళ్లడానికి నేను దిగి వచ్చాను. ");
INSERT INTO telotsa_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ఇశ్రాయేలీయుల మొర నాకు చేరింది, ఈజిప్టువారు వారినెలా అణచివేస్తున్నారో నేను చూశాను. ");
INSERT INTO telotsa_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","కాబట్టి ఇప్పుడు, వెళ్లు. నా ప్రజలైన ఇశ్రాయేలీయులను ఈజిప్టు బయటకు తీసుకురావడానికి నేను నిన్ను ఫరో దగ్గరకు పంపుతున్నాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","అయితే మోషే, “ఫరో దగ్గరకు వెళ్లడానికి ఇశ్రాయేలీయులను ఈజిప్టులో నుండి బయటకు తీసుకురావడానికి నేను ఎంతటివాన్ని?” అని దేవునితో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","అప్పుడు దేవుడు, “ఖచ్చితంగా నేను నీకు తోడై ఉంటాను. నేను నిన్ను పంపాను అనడానికి ఇది ఒక అసాధారణ గుర్తుగా ఉంటుంది: మీరు ఈజిప్టు నుండి ప్రజలను బయటకు తీసుకువచ్చినప్పుడు, మీరూ ఈ పర్వతం మీద దేవుని ఆరాధిస్తారు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","అప్పుడు మోషే, “నేను ఇశ్రాయేలీయుల దగ్గరకు వెళ్లి వారితో, ‘మీ పితరుల దేవుడు నన్ను మీ దగ్గరకు పంపారు’ అని చెప్పినప్పుడు వారు, ‘ఆయన పేరు ఏమిటి?’ అని నన్ను అడుగుతారు, అప్పుడు నేను వారికి ఏమి చెప్పాలి?” అని దేవుని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","అందుకు దేవుడు మోషేతో, “నేను నేనైయున్నాను. నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పాలి: ‘నేనైయున్నాను అనేవాడు నన్ను మీ దగ్గరకు పంపాడు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","దేవుడు మోషేతో, “నీవు ఇశ్రాయేలీయులతో, ‘మీ పితరుల దేవుడైన యెహోవా అనగా అబ్రాహాము దేవుడు, ఇస్సాకు దేవుడు, యాకోబు దేవుడు నన్ను మీ దగ్గరకు పంపారు’ అని చెప్పాలి. “ఇదే నా నిత్యమైన పేరు, తరతరాల వరకు మీరు జ్ఞాపకముంచుకోవలసిన పేరు ఇదే. ");
INSERT INTO telotsa_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“వెళ్లు, ఇశ్రాయేలీయుల పెద్దలను పోగు చేసి వారితో, ‘మీ పితరుల దేవుడైన యెహోవా అనగా అబ్రాహాము ఇస్సాకు యాకోబుల దేవుడు నాకు ప్రత్యక్షమై ఇలా అన్నారు: నేను మిమ్మల్ని చూశాను; ఈజిప్టులో మీకు జరిగిన దానిని చూశాను. ");
INSERT INTO telotsa_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ఈజిప్టు కష్టాల నుండి విడిపించి, కనానీయుల, హిత్తీయుల, అమోరీయుల, పెరిజ్జీయుల, హివ్వీయుల, యెబూసీయుల దేశం అనగా పాలు తేనెలు ప్రవహించే దేశానికి మిమ్మల్ని తీసుకెళ్తానని ప్రమాణం చేశాను’ అని వారితో చెప్పు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ఇశ్రాయేలీయుల పెద్దలు నీ మాట వింటారు. అప్పుడు నీవు వారితో కలిసి ఈజిప్టు రాజు దగ్గరకు వెళ్లి అతనితో, ‘హెబ్రీయుల దేవుడైన యెహోవా మాకు ప్రత్యక్షమయ్యారు. మేము అరణ్యంలో మూడు రోజుల ప్రయాణమంత దూరం వెళ్లి అక్కడ మా దేవుడైన యెహోవాకు బలులు అర్పించేలా మమ్మల్ని వెళ్లనివ్వండి’ అని చెప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","అయితే ఈజిప్టు రాజు ఒక బలమైన హస్తం అతన్ని ఒత్తిడి చేస్తేనే తప్ప మిమ్మల్ని పోనివ్వడని నాకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","కాబట్టి నేను నా చేతిని చాచి ఈజిప్టువారి మధ్య నేను చేయదలచిన అద్భుత కార్యాలను చేసి వారిని మొత్తుతాను. దాని తర్వాత అతడు మిమ్మల్ని వెళ్లనిస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“ఈ ప్రజల పట్ల ఈజిప్టువారిలో దయను పుట్టిస్తాను కాబట్టి మీరు వెళ్లినప్పుడు వట్టి చేతులతో వెళ్లరు. ");
INSERT INTO telotsa_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ప్రతి స్త్రీ తన పొరుగువారిని వారి ఇంట్లో ఉండే స్త్రీని వెండి బంగారు ఆభరణాలను, బట్టలను అడిగి తీసుకుని వాటిని మీ కుమారులకు కుమార్తెలకు ధరింపచేయాలి. ఈ విధంగా మీరు ఈజిప్టువారిని కొల్లగొడతారు.” ");
INSERT INTO telotsa_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","అందుకు మోషే, “ఒకవేళ వారు నన్ను నమ్మకుండ లేదా నేను చెప్పేది వినకుండ, ‘యెహోవా నీకు ప్రత్యక్షం కాలేదు’ అని అంటే ఎలా?” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","అప్పుడు యెహోవా అతనితో, “నీ చేతిలో ఉన్నది ఏమిటి?” అని అన్నారు. “ఒక కర్ర” అని అతడు జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","అందుకు యెహోవా, “దానిని నేలపై పడవేయి” అన్నారు. మోషే దానిని నేల మీద పడవేయగానే అది పాముగా మారింది, అతడు దాని నుండి పారిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","అప్పుడు యెహోవా, “నీ చేయి చాచి దాని తోక పట్టుకుని పైకెత్తు” అని అతనితో అన్నారు. మోషే తన చేతిని చాచి ఆ పాము తోక పట్టుకుని పైకెత్తగానే అది తిరిగి అతని చేతిలో కర్రగా మారింది. ");
INSERT INTO telotsa_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","అప్పుడు యెహోవా, “దీనిని బట్టి వారు, తమ పితరుల దేవుడైన యెహోవా అనగా అబ్రాహాము దేవుడు, ఇస్సాకు దేవుడు, యాకోబు దేవుడు నీకు ప్రత్యక్షమయ్యారని నమ్ముతారు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","యెహోవా, “నీ చేతిని నీ ఛాతీ మీద పెట్టు” అన్నారు. మోషే తన చేతిని తన ఛాతీ మీద పెట్టాడు, అతడు దానిని బయటకు తీయగా, అది కుష్ఠురోగంతో మంచులా తెల్లగా మారిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“ఇప్పుడు నీ చేయి మరలా నీ ఛాతీ మీద పెట్టు” అని ఆయన అన్నారు. మోషే తన చేతిని మరలా తన ఛాతీ మీద పెట్టాడు, అతడు దానిని బయటకు తీసినప్పుడు, అది తిరిగి మంచిదిగా, మిగితా దేహంలా అది మారింది. ");
INSERT INTO telotsa_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","అప్పుడు యెహోవా, “వారు నిన్ను నమ్మకపోయినా మొదటి అసాధారణ గుర్తును లక్ష్యపెట్టకపోయినా, రెండవదానిని బట్టి నమ్మవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","అయితే వారు ఈ రెండు అసాధారణ గుర్తులను కూడా నమ్మకపోయినా లేదా నీ మాట వినకపోయినా, నీవు నైలు నది నుండి కొంచెం నీరు తీసుకుని పొడినేల మీద పోయి. నీవు నది నుండి తీసుకున్న నీరు నేలమీద రక్తంగా మారుతుంది” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","అప్పుడు మోషే యెహోవాతో, “ప్రభువా, నీ సేవకుని క్షమించు. గతంలో కాని నీవు నీ సేవకునితో మాట్లాడినప్పటినుండి కాని నేను ఎప్పుడూ మాటకారిని కాదు. నేను నత్తివాన్ని నా నాలుక సరిగా తిరగదు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","యెహోవా అతనితో అన్నారు, “మానవులకు నోరు ఇచ్చింది ఎవరు? వారిని చెవిటివారిగా మూగవారిగా చేసింది ఎవరు? వారికి చూపును ఇచ్చింది, గ్రుడ్డివారిగా చేసింది ఎవరు? యెహోవానైన, నేను కాదా? ");
INSERT INTO telotsa_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","కాబట్టి వెళ్లు; నేను సహాయం చేస్తాను, ఏమి మాట్లాడాలో నేను నీకు బోధిస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","కాని మోషే, “ప్రభువా, నీ సేవకుని క్షమించండి. దయచేసి మరొకరిని పంపించండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","అప్పుడు యెహోవా కోపం మోషేపై కోపం రగులుకుంది, ఆయన అన్నారు, “లేవీయుడైన నీ అన్న అహరోను లేడా? అతడు బాగా మాట్లాడగలడని నాకు తెలుసు. అతడు నిన్ను కలుసుకోడానికి వస్తున్నాడు. నిన్ను చూసి అతడు సంతోషిస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","నీవు అతనితో మాట్లాడి అతని నోటికి మాటలు అందించాలి. నేను నీ నోటికి అతని నోటికి తోడుగా ఉంటాను. మీరు మాట్లాడడానికి సహాయం చేస్తాను, అలాగే మీరేమి చేయాలో నేను మీకు బోధిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","అతడే నీ బదులు ప్రజలతో మాట్లాడతాడు. అతడు నీకోసం మాట్లాడే వాడిగా ఉంటాడు, నీవు అతనికి దేవునిలా ఉంటావు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ఈ కర్రను నీ చేతితో పట్టుకో, దీనితో నీవు అసాధారణ గుర్తులు చేయగలవు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ఆ తర్వాత మోషే తన మామయైన యెత్రో దగ్గరకు తిరిగివెళ్లి అతనితో, “నేను ఈజిప్టులో ఉన్న నా బంధువుల దగ్గరకు తిరిగివెళ్లి వారిలో ఎవరైనా ఇంకా బ్రతికి ఉన్నారో లేదో చూడడానికి నన్ను వెళ్లనివ్వు” అన్నాడు. అందుకు యెత్రో, “సమాధానం కలిగి, వెళ్లు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","తర్వాత యెహోవా మిద్యానులో మోషేతో, “నిన్ను చంపడానికి చూసినవారందరు చనిపోయారు కాబట్టి నీవు ఈజిప్టుకు తిరిగి వెళ్లు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","కాబట్టి మోషే తన భార్య పిల్లలను తీసుకుని గాడిద మీద ఎక్కించి ఈజిప్టుకు తిరిగి ప్రయాణమయ్యాడు. అతడు దేవుని కర్రను తన చేతిలో పట్టుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","అప్పుడు యెహోవా మోషేతో అన్నారు, “నీవు ఈజిప్టుకు తిరిగి వెళ్లిన తర్వాత, నేను నీకు చేయడానికి శక్తినిచ్చిన ఇచ్చిన అద్భుతాలన్నిటిని ఫరో ఎదుట నీవు చేయాలి. అయితే నేను అతని హృదయాన్ని కఠినపరుస్తాను కాబట్టి అతడు ప్రజలను వెళ్లనివ్వడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","అప్పుడు నీవు ఫరోతో, ‘యెహోవా నాతో ఇలా చెప్పారు: ఇశ్రాయేలు నా మొదటి సంతానమైన కుమారుడు, ");
INSERT INTO telotsa_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","“నన్ను సేవించేలా నా కుమారుని వెళ్లనివ్వు” అని నీకు చెప్పాను. కాని నీవు వారిని పంపడానికి నిరాకరించావు; కాబట్టి నేను నీ మొదటి సంతానమైన నీ కుమారున్ని చంపుతాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ప్రయాణ మార్గంలో వారు బసచేసిన చోటు దగ్గర యెహోవా మోషేను ఎదుర్కొని అతన్ని చంపబోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","అయితే సిప్పోరా ఒక చెకుముకి కత్తిని తీసుకుని, తన కుమారుని యొక్క మర్మాంగ చర్మం యొక్క కొనను కత్తిరించుట ద్వార సున్నతిచేసి, దానితో మోషే పాదాలను తాకించి, “నీవు నాకు రక్తసంబంధమైన భర్తవు” అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","అప్పుడు యెహోవా అతన్ని విడిచిపెట్టారు. అప్పుడు ఆమె, ఈ సున్నతిని బట్టి నీవు నాకు “రక్తసంబంధమైన భర్తవయ్యావు” అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","యెహోవా అహరోనుతో, “మోషేను కలవడానికి అరణ్యంలోనికి వెళ్లు” అని అన్నారు. కాబట్టి అతడు వెళ్లి దేవుని పర్వతం దగ్గర మోషేను కలుసుకొని అతన్ని ముద్దు పెట్టుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","అప్పుడు మోషే తనను పంపించిన యెహోవా చెప్పమన్న వాటన్నిటిని, ఆయన తనను చేయమని ఆజ్ఞాపించిన సూచనలన్నింటిని గురించి అహరోనుకు చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","అప్పుడు మోషే అహరోనులు వెళ్లి ఇశ్రాయేలీయుల పెద్దలందరినీ పోగు చేసి, ");
INSERT INTO telotsa_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","యెహోవా మోషేకు చెప్పిన వాటన్నిటిని అహరోను పెద్దలందరికి తెలియజేశాడు. మోషే వారి ఎదుట ఆ అసాధారణమైన సూచకక్రియలను చేశాడు, ");
INSERT INTO telotsa_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","అప్పుడు వారు నమ్మారు. యెహోవా ఇశ్రాయేలీయులను పట్టించుకున్నాడని తమ బాధలను చూశాడని విని వారు తమ తలలు వంచి ఆరాధించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ఆ తర్వాత మోషే అహరోనులు ఫరో దగ్గరకు వెళ్లి, “ఇశ్రాయేలీయుల దేవుడైన యెహోవా చెప్పిన మాట ఇదే: ‘అరణ్యంలో నాకు ఉత్సవం చేయడానికి నా ప్రజలను వెళ్లనివ్వు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","అందుకు ఫరో, “నేను ఆయన మాట విని ఇశ్రాయేలీయులను వెళ్లనివ్వడానికి యెహోవా ఎవరు? ఆ యెహోవా నాకు తెలియదు, ఇశ్రాయేలీయులను నేను పంపను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","అందుకు వారు, “హెబ్రీయుల దేవుడు మాకు ప్రత్యక్షమయ్యారు. కాబట్టి మేము అరణ్యంలో మూడు రోజుల ప్రయాణమంత దూరం వెళ్లి అక్కడ మా దేవుడైన యెహోవాకు బలి అర్పించాలి. లేకపోతే ఆయన మమ్మల్ని తెగులుతోగాని ఖడ్గంతోగాని బాధిస్తారు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","అందుకు ఈజిప్టు రాజు, “మోషే అహరోనూ, ఈ ప్రజలు తమ పనులను చేయకుండా మీరెందుకు ఆటంకపరుస్తున్నారు? మీ పనికి తిరిగి వెళ్లండి!” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ఫరో, “చూడండి, ఈ దేశ ప్రజలు చాలామంది ఉన్నారు, మీరు వారిని పని చేయకుండా ఆటంకపరుస్తున్నారు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","అదే రోజు ఫరో బానిసల నాయకులకు, వారిపై అధికారులుగా ఉన్నవారికి ఇలా ఆజ్ఞాపించాడు: ");
INSERT INTO telotsa_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ఇటుకలు చేయడానికి వారికి కావలసిన గడ్డిని ఇకపై మీరు ఇవ్వకండి; వారే వెళ్లి తమకు కావలసిన గడ్డిని తెచ్చుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","అయినప్పటికీ వారు ఇంతకుముందు చేసినన్ని ఇటుకలనే ఇప్పుడు కూడా చేయాలి; కోటా తగ్గించకండి. వారు సోమరివారు కాబట్టి, ‘మేము వెళ్లి మా దేవునికి బలి అర్పించడానికి మమ్మల్ని పంపించండి’ అని మొరపెడుతున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ఆ ప్రజలచేత మరింత కఠినంగా పని చేయించండి అప్పుడు వారు పని చేస్తూ ఉండి అబద్ధపు మాటలను పట్టించుకోరు.” ");
INSERT INTO telotsa_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","కాబట్టి బానిసల నాయకులు వారి అధికారులు వెళ్లి ప్రజలతో, “ఫరో ఇలా అంటున్నారు: ‘నేను ఇకపై మీకు గడ్డి ఇవ్వను. ");
INSERT INTO telotsa_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","మీరు వెళ్లి గడ్డి ఎక్కడ దొరికితే అక్కడినుండి తెచ్చుకోండి, అయినాసరే మీ పని ఏమాత్రం తగ్గించబడదు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","కాబట్టి ప్రజలు గడ్డికి బదులు ఎండిన దుబ్బులను సేకరించడానికి ఈజిప్టు దేశమంతా చెదిరిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","బానిసల నాయకులు వారితో, “మీకు గడ్డి ఉన్నప్పుడు చేసినట్లే ఏ రోజు పనిని ఆ రోజే పూర్తి చేయండి” అని వారిని తీవ్రంగా హెచ్చరించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ఫరో యొక్క బానిస నాయకులు వారు నియమించిన ఇశ్రాయేలీయుల పర్యవేక్షకులను కొట్టి, “నిన్న లేదా ఈ రోజు మీ ఇటుకల కోటా మునుపటిలా ఎందుకు చేరుకోలేదు?” అని అడిగారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","అప్పుడు ఇశ్రాయేలీయుల పర్యవేక్షకులు ఫరో దగ్గరకు వెళ్లి, “మీ సేవకుల పట్ల ఎందుకు ఇలా ప్రవర్తిస్తున్నారు? ");
INSERT INTO telotsa_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","మీ సేవకులకు గడ్డి ఇవ్వడం లేదు గాని ఇటుకలు చేయండి అని మాతో అంటున్నారు. మీ సేవకులు దెబ్బలు తింటున్నారు కాని తప్పు మీ సొంత ప్రజలలోనే ఉంది” అని మనవి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","అందుకు ఫరో, “మీరు సోమరులు, మీరు సోమరులు! అందుకే, ‘మేము వెళ్లి యెహోవాకు బలి అర్పిస్తాము మమ్మల్ని వెళ్లనివ్వండి’ అని అడుగుతున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","వెళ్లండి, వెళ్లి పని చేయండి. మీకు గడ్డి ఇవ్వరు అయినా మీరు చేయాల్సిన ఇటుకల పూర్తి కోట చేయాల్సిందే” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“మీరు ప్రతిరోజు చేయాల్సిన ఇటుకల సంఖ్య ఏమాత్రం తగ్గించబడదు” అని తమతో చెప్పినప్పుడు తాము కష్టాల్లో చిక్కుకున్నామని ఇశ్రాయేలీయుల పర్యవేక్షకులు గ్రహించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","వారు ఫరో దగ్గర నుండి వస్తున్నప్పుడు తమను కలవాలని ఎదురు చూస్తున్న మోషే అహరోనులను కలుసుకొని, ");
INSERT INTO telotsa_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","వారు, “యెహోవా మిమ్మల్ని చూసి మిమ్మల్ని తీర్పు తీర్చును గాక! మీరు ఫరో ఎదుట అతని అధికారుల ఎదుట మమ్మల్ని చెడ్డవారిగా చేశారు, మమ్మల్ని చంపడానికి వారి చేతిలో కత్తి పెట్టారు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","మోషే యెహోవా దగ్గరకు తిరిగివెళ్లి, “ప్రభువా, ఈ ప్రజలమీదికి ఎందుకు ఇబ్బంది రప్పించారు? నన్ను ఇందుకే పంపించారా? ");
INSERT INTO telotsa_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","నేను మీ నామాన్ని బట్టి ఫరోతో మాట్లాడడానికి వెళ్లినప్పటి నుండి అతడు ఈ ప్రజలను కష్టపెడుతున్నాడు. మీరు మీ ప్రజలను ఏమాత్రం విడిపించడంలేదు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","అప్పుడు యెహోవా మోషేతో, “ఇప్పుడు నేను ఫరోకు ఏం చేయబోతున్నానో నీవు చూస్తావు: నా బలమైన హస్తాన్ని బట్టి అతడు వారిని వెళ్లనిస్తాడు; నా బలమైన హస్తాన్ని బట్టి అతడు వారిని తన దేశం నుండి తరిమివేస్తాడు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","దేవుడు మోషేతో అన్నారు, “నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","నేను సర్వశక్తిగల దేవునిగా అబ్రాహాము, ఇస్సాకు, యాకోబులకు ప్రత్యక్షమయ్యాను, కాని యెహోవా అనే నా పేరుతో నన్ను నేను వారికి తెలియపరచుకోలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","వారు విదేశీయులుగా ఉండిన కనాను దేశాన్ని వారికి ఇస్తాననే నా నిబంధనతో నేను వారిని స్థిరపరిచాను. ");
INSERT INTO telotsa_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","అంతేకాక, ఈజిప్టు వారిచేత బానిసలుగా చేయబడిన ఇశ్రాయేలీయుల మూలుగును నేను విన్నాను, నా నిబంధనను జ్ఞాపకం చేసుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“కాబట్టి, ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘నేను యెహోవాను, ఈజిప్టువారి వెట్టిచాకిరి నుండి నేను మిమ్మల్ని బయటకు తీసుకువస్తాను. మీరు వారికి బానిసలుగా ఉండకుండ నేను మిమ్మల్ని స్వతంత్రులను చేస్తాను, చాపబడిన బాహువుతో, గొప్ప తీర్పు చర్యలతో నేను మిమ్మల్ని విమోచిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","నేను మిమ్మల్ని నా సొంత ప్రజలుగా చేసుకుని, మీకు దేవుడనై ఉంటాను. అప్పుడు ఈజిప్టువారి కాడి క్రిందనుండి మిమ్మల్ని బయటకు తీసుకువచ్చిన మీ దేవుడైన యెహోవాను నేనే అని మీరు తెలుసుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","నేను అబ్రాహాము, ఇస్సాకు, యాకోబులకు చేయెత్తి ప్రమాణం చేసిన దేశానికి మిమ్మల్ని తీసుకెళ్తాను. దానిని మీకు స్వాస్థ్యంగా ఇస్తాను. నేను యెహోవాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","మోషే ఇశ్రాయేలీయులకు ఈ విషయాన్ని తెలియజేశాడు, కాని వారి కఠినమైన శ్రమను బట్టి, నిరుత్సాహాన్ని బట్టి వారు అతని మాట వినలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","అప్పుడు యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“వెళ్లు, ఇశ్రాయేలీయులను తన దేశం నుండి బయటకు వెళ్లనివ్వమని ఈజిప్టు రాజైన ఫరోకు చెప్పు.” ");
INSERT INTO telotsa_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","అయితే మోషే యెహోవాతో, “ఇశ్రాయేలీయులే నా మాట వినకపోతే స్పష్టంగా మాట్లాడలేని నా మాట ఫరో ఎందుకు వింటాడు?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","అప్పుడు యెహోవా మోషే అహరోనులతో ఇశ్రాయేలీయులను గురించి ఈజిప్టు రాజైన ఫరోను గురించి మాట్లాడి, ఇశ్రాయేలీయులను ఈజిప్టులో నుండి బయటకు తీసుకురమ్మని వారిని ఆదేశించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","వారి కుటుంబాలకు మూలపురుషులు వీరే: ఇశ్రాయేలు మొదటి కుమారుడైన రూబేను కుమారులు: హనోకు, పల్లు, హెస్రోను, కర్మీ; ");
INSERT INTO telotsa_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","షిమ్యోను కుమారులు: యెమూయేలు, యామీను, ఓహదు, యాకీను, సోహరు, కనాను స్త్రీకి పుట్టిన షావూలు; ");
INSERT INTO telotsa_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","కుటుంబ వివరాల ప్రకారం లేవీ కుమారుల పేర్లు: గెర్షోను, కహాతు, మెరారి. ");
INSERT INTO telotsa_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","వంశాల ప్రకారం గెర్షోను కుమారులు: లిబ్నీ, షిమీ. ");
INSERT INTO telotsa_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","కహాతు కుమారులు: అమ్రాము, ఇస్హారు, హెబ్రోను, ఉజ్జీయేలు. (కహాతు 133 సంవత్సరాలు బ్రతికాడు.) ");
INSERT INTO telotsa_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","మెరారి కుమారులు: మహలి, మూషి. ");
INSERT INTO telotsa_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","అమ్రాము తన మేనత్తయైన యోకెబెదును పెళ్ళి చేసుకున్నాడు. వారికి అహరోను మోషేలు పుట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ఇస్హారు కుమారులు: కోరహు, నెఫెగు, జిఖ్రీ. ");
INSERT INTO telotsa_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ఉజ్జీయేలు కుమారులు: మిషాయేలు, ఎల్సాఫాను, సిత్రీ. ");
INSERT INTO telotsa_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","అహరోను అమ్మీనాదాబు కుమార్తె నయస్సోను సహోదరియైన ఎలీషేబను పెళ్ళి చేసుకున్నాడు. ఆమె అతనికి నాదాబు, అబీహు, ఎలియాజరు, ఈతామారులను కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","కోరహు కుమారులు: అస్సీరు, ఎల్కానా, అబీయాసాపు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","అహరోను కుమారుడైన ఎలియాజరు పుతీయేలు కుమార్తెలలో ఒకరిని పెళ్ళి చేసుకున్నాడు, ఆమె అతనికి ఫీనెహాసును కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","“ఇశ్రాయేలీయులను వారి విభజనల ప్రకారం ఈజిప్టులో నుండి బయటకు తీసుకురండి” అని యెహోవా ఆజ్ఞాపించిన అహరోను మోషేలు వీరే. ");
INSERT INTO telotsa_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ఇశ్రాయేలీయులను ఈజిప్టులో నుండి బయటకు తీసుకురావడం గురించి ఈజిప్టు రాజైన ఫరోతో మాట్లాడిన అహరోను మోషేలు వీరే. ");
INSERT INTO telotsa_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ఇక ఈజిప్టు దేశంలో యెహోవా మోషేతో మాట్లాడినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ఆయన మోషేతో, “నేను యెహోవానై ఉన్నాను. నేను నీకు ఆజ్ఞాపించిన వాటన్నిటిని ఈజిప్టు రాజైన ఫరోతో చెప్పు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","కాని మోషే యెహోవాతో, “తడబడే పెదవులతో మాట్లాడే నా మాటను ఫరో ఎందుకు వింటాడు?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","అప్పుడు యెహోవా మోషేతో అన్నారు, “చూడు, నేను నిన్ను ఫరోకు దేవునిలా చేస్తాను, నీ అన్న అహరోను నీకు ప్రవక్తగా ఉంటాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","నేను నీకు ఆజ్ఞాపించిన ప్రతిదీ నీవు చెప్పాలి, ఫరో తన దేశంలో నుండి ఇశ్రాయేలీయులను వెళ్లనివ్వాలని నీ అన్నయైన అహరోను అతనితో చెప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","కాని నేను ఫరో హృదయాన్ని కఠినపరుస్తాను, కాబట్టి ఈజిప్టు దేశంలో నా సూచనలను, అద్భుతాలను అధికంగా చేసినప్పటికీ, ");
INSERT INTO telotsa_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ఫరో మీ మాట వినడు. అప్పుడు నేను ఈజిప్టుపై నా చేతిని ఉంచి గొప్ప తీర్పు చర్యలతో, నా ప్రజలైన ఇశ్రాయేలీయులను వారి విభజనల ప్రకారం బయటకు తీసుకువస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","నేను ఈజిప్టుకు వ్యతిరేకంగా చేయి చాచి ఇశ్రాయేలీయులను దాని నుండి బయటకు తీసుకువచ్చినప్పుడు నేను యెహోవానని ఈజిప్టువారు తెలుసుకుంటారు.” ");
INSERT INTO telotsa_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","మోషే అహరోనులు యెహోవా తమకు ఆజ్ఞాపించిన ప్రకారం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","వారు ఫరోతో మాట్లాడినప్పుడు మోషేకు 80 సంవత్సరాలు అహరోనుకు 83 సంవత్సరాలు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","యెహోవా మోషే అహరోనులతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ ‘ఒక అద్భుతకార్యం చేయండి’ అని ఫరో మీతో చెప్పినప్పుడు, నీవు అహరోనుతో, ‘నీ చేతికర్రను తీసుకుని ఫరో ఎదుట పడవేయి’ అని చెప్పు. అది పాముగా మారుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","మోషే అహరోనులు ఫరో దగ్గరకు వెళ్లి యెహోవా ఆజ్ఞాపించిన ప్రకారమే చేశారు. అహరోను ఫరో ఎదుట అతని సేవకుల ఎదుట తన కర్రను పడవేయగానే అది పాముగా మారింది. ");
INSERT INTO telotsa_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ఫరో జ్ఞానులను మంత్రగాళ్ళను పిలిపించాడు. ఈజిప్టువారి మంత్రగాళ్ళు కూడా తమ మంత్రవిద్యతో అలాగే చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ప్రతి ఒక్కరు తమ కర్రను క్రింద పడవేయగా అది పాముగా మారింది. అయితే అహరోను కర్ర వారి కర్రలను మ్రింగివేసింది. ");
INSERT INTO telotsa_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","కాని యెహోవా వారితో చెప్పిన ప్రకారమే ఫరో హృదయం కఠినంగా మారి అతడు వారి మాటను వినలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","తర్వాత యెహోవా మోషేతో ఇలా అన్నారు, “ఫరో హృదయం కఠినమైనది కాబట్టి అతడు ప్రజలను పంపించడానికి నిరాకరిస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ఫరో నదికి వెళ్లేటప్పుడు ఉదయాన్నే నీవు అతని దగ్గరకు వెళ్లు. నైలు నది తీరాన నీవు అతనికి ఎదురు వెళ్లు. పాముగా మారిన కర్రను నీ చేతితో పట్టుకో. ");
INSERT INTO telotsa_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","అతనితో, ‘అరణ్యంలో నన్ను సేవించడానికి నా ప్రజలను వెళ్లనివ్వమని నీతో చెప్పడానికి హెబ్రీయుల దేవుడైన యెహోవా నన్ను నీ దగ్గరకు పంపాడు. ఇప్పటివరకు నీవు మాట వినలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","యెహోవా చెప్పిన మాట ఇదే: దీని ద్వారా నేనే యెహోవానని నీవు తెలుసుకుంటావు. నా చేతిలో ఉన్న కర్రతో నేను నైలు నది నీటిని కొడతాను. అది రక్తంగా మారుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","నైలు నదిలోని చేపలన్నీ చస్తాయి, నది కంపు కొడుతుంది; ఈజిప్టువారు దాని నీటిని త్రాగలేరు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","యెహోవా మోషేతో ఇంకా ఇలా అన్నారు, “నీవు అహరోనుతో ఇలా చెప్పు, ‘నీ కర్రను తీసుకుని ఈజిప్టు జలాల మీద అనగా వారి నదులు కాలువలు చెరువులు, అన్ని జలాశయాల మీద చాపు, అప్పుడు అవన్నీ రక్తంగా మారుతాయి.’ ఈజిప్టులో ఎటు చూసినా రక్తమే ఉంటుంది. చివరికి చెక్క, రాతి పాత్రల్లో కూడా.” ");
INSERT INTO telotsa_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","మోషే అహరోనులు యెహోవా ఆజ్ఞాపించిన ప్రకారమే చేశారు. అతడు ఫరో ఎదుట అతని సేవకుల ఎదుట తన కర్రను పైకి లేపి నైలు నది నీటిని కొట్టగా, దాని నీరంతా రక్తంగా మారాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","నైలు నదిలోని చేపలు చనిపోయి, నది కంపు కొట్టడంతో ఈజిప్టువారు ఆ నీటిని త్రాగలేకపోయారు. ఈజిప్టులో ఎటు చూసినా రక్తమే కనబడింది. ");
INSERT INTO telotsa_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","అయితే ఈజిప్టు మంత్రగాళ్ళు కూడా తమ మంత్రవిద్యతో వాటిని చేశారు, అయితే యెహోవా వారితో చెప్పిన ప్రకారమే ఫరో హృదయం కఠినంగా మారి అతడు వారి మాటలను వినిపించుకోలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","దానికి బదులు, ఫరో తన రాజభవనానికి తిరిగి వెళ్లిపోయాడు, కనీసం జరిగిన వాటి గురించి ఆలోచించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ఈజిప్టు వారంతా నైలు నది నీటిని త్రాగలేక త్రాగునీటి కోసం నది ప్రక్కన త్రవ్వారు. ");
INSERT INTO telotsa_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","యెహోవా నైలు నదిని కొట్టి ఏడు రోజులు గడిచాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","అప్పుడు యెహోవా మోషేతో, “నీవు ఫరో దగ్గరకు వెళ్లి అతనితో, ‘యెహోవా చెప్పిన మాట ఇదే: నన్ను ఆరాధించడానికి నా ప్రజలను వెళ్లనివ్వు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","నీవు వారిని వెళ్లనివ్వకపోతే నేను నీ దేశమంతట కప్పలు పంపించి బాధిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","నైలు నది కప్పలతో నిండిపోతుంది. అవి నీ రాజభవనం లోనికి నీ పడకగదిలోనికి, నీ పడక మీదికి, నీ అధికారుల ఇళ్ళలోనికి, నీ ప్రజలమీదికి, మీ పొయ్యిల్లోనికి, పిండి పిసికే తొట్టెల్లోనికి వస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ఆ కప్పలు నీ మీదికి నీ ప్రజలమీదికి నీ అధికారుల మీదికి వస్తాయి అని చెప్పు’ అని అన్నారు.” ");
INSERT INTO telotsa_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","అప్పుడు యెహోవా మోషేతో ఇలా అన్నారు, “నీవు అహరోనుతో, ‘ప్రవాహాలు, కాలువలు, చెరువులపై నీ కర్రతో నీ చేయిని చాచి, ఈజిప్టు భూమిపై కప్పలు పైకి వచ్చేలా చేయి’ అని చెప్పు.” ");
INSERT INTO telotsa_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","అహరోను ఈజిప్టు జలాల మీద తన చేతిని చాపినప్పుడు కప్పలు వచ్చి ఆ దేశాన్ని కప్పివేశాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","అయితే మంత్రగాళ్ళు కూడా తమ మంత్రవిద్యతో అవే చేసి ఈజిప్టు దేశం మీదికి కప్పలు వచ్చేలా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ఫరో మోషే అహరోనులను పిలిపించి, “నా నుండి నా ప్రజల నుండి ఈ కప్పలను తొలగించమని యెహోవాకు ప్రార్థించండి, అప్పుడు యెహోవాకు బలి అర్పించడానికి నీ ప్రజలను వెళ్లనిస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","అందుకు మోషే ఫరోతో, “నైలు నదిలో మిగిలి ఉన్న కప్పలు తప్ప, మిమ్మల్ని, మీ ఇళ్ళను కప్పలు వదిలి వెళ్లేలా, మీ కోసం మీ ప్రజల కోసం, మీ అధికారుల కోసం ప్రార్థించడానికి సమయం నిర్ణయించే గౌరవాన్ని నేను మీకే ఇస్తున్నాను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","అందుకు ఫరో, “రేపే” అన్నాడు. అందుకు మోషే అన్నాడు, “మా దేవుడైన యెహోవా వంటి వారెవరు లేరని నీవు తెలుసుకునేలా నీవన్నట్టే జరుగుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","కప్పలు మిమ్మల్ని, మీ ఇళ్ళను, మీ అధికారులను, మీ ప్రజలను వదిలివేస్తాయి; అవి నైలు నదిలో మాత్రమే ఉంటాయి.” ");
INSERT INTO telotsa_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","మోషే అహరోనులు ఫరో దగ్గరనుండి వెళ్లిన తర్వాత, యెహోవా ఫరో మీదికి రప్పించిన కప్పల గురించి మోషే ఆయనకు మొరపెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","మోషే అడిగినట్టే యెహోవా చేశారు. ఇళ్ళలో ఆవరణాల్లో పొలాల్లో ఉన్న కప్పలు చనిపోయాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ఈజిప్టు ప్రజలు వాటిని కుప్పలుగా వేసినప్పుడు నేల కంపుకొట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","కప్పల నుండి ఉపశమనం కలిగిందని చూసిన ఫరో యెహోవా చెప్పిన ప్రకారమే తన హృదయాన్ని కఠినం చేసుకుని మోషే అహరోనుల మాట వినలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","అప్పుడు యెహోవా మోషేతో, “నీవు అహరోనుతో, ‘నీ కర్రను చాపి నేలమీది ధూళిని కొట్టు’ అని చెప్పు, అప్పుడు ఈజిప్టు దేశమంతటా ఆ ధూళి చిన్న దోమలుగా మారుతుంది” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","వారు అలాగే చేశారు, అహరోను కర్ర పట్టుకుని తన చేతిని చాచి నేలమీది ధూళిని కొట్టినప్పుడు మనుష్యుల మీదికి జంతువుల మీదికి చిన్న దోమలు వచ్చాయి. ఈజిప్టు దేశంలోని ధూళి అంతా చిన్న దోమలుగా మారింది. ");
INSERT INTO telotsa_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","అయితే మంత్రగాళ్ళు తమ మంత్రవిద్యతో చిన్న దోమలను పుట్టించడానికి ప్రయత్నించారు, కాని వారు చేయలేకపోయారు. చిన్న దోమలు మనుష్యుల మీద జంతువుల మీద వాలాయి, ");
INSERT INTO telotsa_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","మంత్రగాళ్ళు ఫరోతో, “ఇది దేవుని వ్రేలు చేసిన పనే” అని చెప్పారు. అయినా యెహోవా చెప్పిన ప్రకారమే ఫరో తన హృదయాన్ని కఠినం చేసుకుని వారి మాట వినలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","అప్పుడు యెహోవా మోషేతో ఇలా అన్నారు, “నీవు ప్రొద్దుటే లేచి ఫరో నదికి వెళ్తున్నప్పుడు అతనికి ఎదురై అతనితో ఇలా చెప్పు, ‘యెహోవా చెప్పిన మాట ఇదే: నన్ను ఆరాధించడానికి నా ప్రజలను వెళ్లనివ్వు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","నీవు నా ప్రజలను వెళ్లనివ్వకపోతే నేను నీ మీదికి నీ అధికారుల మీదికి నీ ప్రజలమీదికి నీ ఇళ్ళలోనికి ఈగల గుంపులను పంపిస్తాను, అప్పుడు ఈజిప్టువారి ఇల్లు ఈగలతో నిండిపోతాయి; చివరికి నేల కూడా వాటితో నిండిపోతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘అయితే ఆ దినాన నా ప్రజలు నివసించే గోషేను దేశంలో మాత్రం ఏ ఈగల గుంపు ఉండదు; అప్పుడు యెహోవానైన నేను ఈ దేశంలో ఉన్నానని నీవు తెలుసుకుంటావు; ");
INSERT INTO telotsa_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","నీ ప్రజలకు నా ప్రజలకు మధ్య భేదాన్ని చూపిస్తాను. ఈ సూచన రేపే కనబడుతుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ఇది యెహోవా చేశారు. బాధించే ఈగల గుంపులు ఫరో రాజభవనం లోనికి అతని సేవకుల ఇళ్ళలోనికి వచ్చి పడ్డాయి; ఈగల గుంపుల వలన ఈజిప్టు దేశమంతటా నేల నాశనమైంది. ");
INSERT INTO telotsa_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","అప్పుడు ఫరో మోషే అహరోనులను పిలిపించి, “మీరు వెళ్లి ఈ దేశంలోనే మీ దేవునికి బలి అర్పించుకోండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","అందుకు మోషే, “అది సరికాదు. మా దేవుడైన యెహోవాకు మేము బలి అర్పించడం ఈజిప్టువారికి అసహ్యం కలిగించవచ్చు. వారి కళ్ళకు అసహ్యమైన బలిని మేము అర్పించినప్పుడు వారు మమ్మల్ని రాళ్లతో కొట్టరా? ");
INSERT INTO telotsa_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","మేము అరణ్యంలో మూడు రోజులు ప్రయాణం చేసి మా దేవుడైన యెహోవా మాకు ఆజ్ఞాపించిన ప్రకారం మేము అక్కడే బలి అర్పించాలి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","అందుకు ఫరో, “మీ దేవుడైన యెహోవాకు అరణ్యంలో బలులు అర్పించడానికి నేను మిమ్మల్ని పంపిస్తాను కాని మీరు ఎక్కువ దూరం వెళ్లకూడదు. ఇప్పుడు నా కోసం ప్రార్థించండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","అందుకు మోషే, “నేను నీ దగ్గర నుండి వెళ్లిన వెంటనే యెహోవాకు మొరపెడతాను, రేపు ఫరో దగ్గర నుండి అతని అధికారుల దగ్గర నుండి అతని ప్రజల దగ్గర నుండి ఈగల గుంపులు వెళ్లిపోతాయి. అయితే యెహోవాకు బలి అర్పించడానికి ప్రజలను వెళ్లనివ్వకుండ ఫరో మరలా మోసపూరితంగా ప్రవర్తించకుండ చూసుకోవాలి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","మోషే ఫరో దగ్గరనుండి వెళ్లి యెహోవాకు మొరపెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","మోషే అడిగినట్టే యెహోవా చేశారు. ఈగలు ఫరోను అతని సేవకులను అతని ప్రజలను విడిచిపోయాయి. ఒక్క ఈగ కూడా మిగల్లేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","అయితే ఫరో మరలా తన హృదయం కఠినం చేసుకుని ప్రజలను వెళ్లనివ్వలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ఆ తర్వాత యెహోవా మోషేతో, “నీవు ఫరో దగ్గరకు వెళ్లి అతనితో, ‘హెబ్రీయుల దేవుడైన యెహోవా ఇలా చెప్తున్నారు: “నా ప్రజలు నన్ను సేవించేలా, వారిని వెళ్లనివ్వు.” ");
INSERT INTO telotsa_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","నీవు వారిని వెళ్లనివ్వకుండా వారిని ఇంకా నిర్బంధించి ఉంచితే, ");
INSERT INTO telotsa_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","యెహోవా హస్తం పొలంలో ఉన్న నీ పశువుల మీదికి అంటే గుర్రాలు, గాడిదలు, ఒంటెలు, పశువులు, గొర్రెలు మేకల మీదకు భయానకమైన వ్యాధిని తెస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","అయితే యెహోవా ఇశ్రాయేలీయుల పశువులకు ఈజిప్టువారి పశువులకు మధ్య భేదాన్ని చూపిస్తారు. ఇశ్రాయేలీయుల పశువుల్లో ఏ ఒక్కటి చనిపోదు’ అని చెప్పు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","యెహోవా సమయాన్ని నిర్ణయించి, “రేపు యెహోవా దీనిని ఈ దేశంలో జరిగిస్తారు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","మరునాడు యెహోవా దానిని జరిగించారు: ఈజిప్టువారి పశువులన్నీ చనిపోయాయి కాని, ఇశ్రాయేలీయులకు చెందిన పశువుల్లో ఒకటి కూడా చావలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ఫరో దాని గురించి విచారణకు పంపగా ఇశ్రాయేలీయులకు చెందిన పశువుల్లో ఒకటి కూడా చావలేదని తెలిసింది. అయినప్పటికీ ఫరో హృదయం కఠినంగా ఉంది కాబట్టి అతడు ప్రజలను వెళ్లనివ్వలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","అయితే యెహోవా మోషే అహరోనులతో, “కొలిమి నుండి చేతి పిడికిలి నిండ బూడిద తీసుకుని, ఫరో ఎదుట మోషే దానిని గాలిలో చల్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","అది సన్నని ధూళిగా మారి ఈజిప్టు దేశమంతా వ్యాపించి, దేశంలోని మనుష్యుల మీద జంతువుల మీద చీముపట్టిన కురుపులు పుడతాయి” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","కాబట్టి వారు కొలిమిలోని బూడిద తీసుకుని ఫరో ఎదుట నిలబడ్డారు. మోషే దానిని గాలిలో చల్లినప్పుడు మనుష్యుల మీద జంతువుల మీద చీముపట్టిన కురుపులు పుట్టాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ఈజిప్టు వారందరి మీద, తమ మీద ఆ కురుపులు ఉండడం వల్ల మంత్రగాళ్ళు మోషే ఎదుట నిలబడలేకపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","అయితే యెహోవా మోషేకు చెప్పినట్లే, మోషే అహరోనుల మాట వినకుండ యెహోవా ఫరో హృదయాన్ని కఠినపరిచారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","అప్పుడు యెహోవా మోషేతో, “నీవు ప్రొద్దున లేచి ఫరో ఎదుటకు వెళ్లి అతనితో, ‘హెబ్రీయుల దేవుడైన యెహోవా చెప్పే మాట ఇదే: నన్ను సేవించడానికి నా ప్రజలను వెళ్లనివ్వు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","లేకపోతే భూమి అంతటి మీద నా వంటి వారెవరు లేరని నీవు తెలుసుకునేలా ఈసారి నేను నీ అధికారుల పైకి నీ ప్రజలమీదికి నా తెగుళ్ళ యొక్క పూర్తి శక్తిని పంపుతాను. ");
INSERT INTO telotsa_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ఈపాటికి నేను నా చేయిని చాచి, నిన్ను నీ ప్రజలను తెగులుతో మొత్తగలిగేవాన్ని, అది మిమ్మల్ని భూమి నుండి తుడిచిపెట్టేది. ");
INSERT INTO telotsa_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","కాని నేను నా బలాన్ని నీకు చూపించాలని భూలోకమంతా నా నామం ప్రకటించబడాలనే ఉద్దేశంతో నేను నిన్ను లేవనెత్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","నీవింకా నా ప్రజలకు వ్యతిరేకంగా ఉంటూ వారిని వెళ్లనివ్వడం లేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","కాబట్టి రేపు ఈ సమయానికి నేను ఈజిప్టు ఏర్పడిన రోజు నుండి ఇప్పటివరకు ఎన్నడు పడని భయంకరమైన వడగండ్ల తుఫాను పంపుతాను. ");
INSERT INTO telotsa_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","కాబట్టి ఇప్పుడే నీ పశువులను నీ పొలంలో ఉన్న సమస్తాన్ని సురక్షితమైన చోటుకు తీసుకురమ్మని ఆజ్ఞాపించు, ఎందుకంటే ఇంటికి రప్పింపబడక పొలంలోనే ఉన్న ప్రతి మనిషి మీద జంతువుల మీద వడగండ్లు పడతాయి, అప్పుడు మనుష్యులు చనిపోతారు, జంతువులు చనిపోతాయి’ అని చెప్పు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ఫరో సేవకులలో యెహోవా మాట విని భయపడినవారు తమ బానిసలను తమ పశువులను తమ ఇళ్ళకు త్వరపడి రప్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","అయితే యెహోవా మాటను లక్ష్యపెట్టనివారు తమ బానిసలను తమ పశువులను పొలంలోనే విడిచిపెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","అప్పుడు యెహోవా మోషేతో, “నీ చేయి ఆకాశం వైపు చాపు అప్పుడు ఈజిప్టు అంతా మనుష్యుల మీద జంతువుల మీద ఈజిప్టు పొలాల్లో పెరిగే ప్రతి దాని మీద వడగండ్లు పడతాయి” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","మోషే తన కర్రను ఆకాశం వైపు చాచినప్పుడు, యెహోవా ఉరుములను వడగండ్లను పంపినప్పుడు మెరుపులు వేగంగా నేలను తాకాయి. ఈజిప్టు దేశమంతటా యెహోవా వడగండ్లు కురిపించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","వడగండ్లు పడ్డాయి, మెరుపులు ఇటు అటు మెరిసాయి. ఈజిప్టు దేశమంతా ఒక దేశంగా ఏర్పడిన తర్వాత ఇది అత్యంత భయంకరమైన తుఫాను. ");
INSERT INTO telotsa_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ఆ వడగండ్లు ఈజిప్టు దేశమంతటా, పొలాల్లో ఉన్న మనుష్యులను జంతువులను నాశనం చేశాయి; పొలాల్లో పెరుగుతున్నవన్నీ పాడయ్యాయి, ప్రతి చెట్టు విరిగిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","అయితే ఇశ్రాయేలీయులు ఉన్న గోషేను దేశంలో మాత్రమే వడగండ్లు పడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","అప్పుడు ఫరో మోషే అహరోనులను పిలిపించి, “ఈసారి నేను పాపం చేశాను, యెహోవా న్యాయవంతుడు, నేను నా ప్రజలు దోషులము. ");
INSERT INTO telotsa_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","యెహోవాకు ప్రార్థించండి, ఎందుకంటే ఇంతవరకు పడిన ఉరుములు వడగండ్లు చాలు. నేను మిమ్మల్ని వెళ్లనిస్తాను; మీరు ఇక ఇక్కడ ఉండనవసరం లేదు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","అందుకు మోషే, “నేను పట్టణంలో నుండి బయటకు వెళ్లగానే, నా చేతులు చాపి యెహోవాకు ప్రార్థిస్తాను. అప్పుడు ఉరుములు ఆగిపోతాయి, ఇక వడగండ్లు ఉండవు, కాబట్టి భూమి యెహోవాదే అని నీవు తెలుసుకుంటావు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","అయినప్పటికీ నీవు నీ అధికారులు ఇంకా యెహోవాకు భయపడడంలేదని నాకు తెలుసు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","అప్పుడు యవలు వెన్నులు వేశాయి అవిసె పూలు పూసాయి కాబట్టి అవి నాశనం చేయబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","గోధుమలు, మరో రకం గోధుమలు ఇంకా ఎదగలేదు, అవి తర్వాత ఎదుగుతాయి కాబట్టి అవి నాశనం చేయబడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","అప్పుడు మోషే ఫరో దగ్గరనుండి బయలుదేరి పట్టణం నుండి బయటకు వెళ్లి యెహోవా వైపు చేతులు చాపినప్పుడు ఉరుములు వడగండ్లు ఆగిపోయాయి. నేలపై వర్షం కురవడం ఆగిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","వర్షం వడగండ్లు ఉరుములు ఆగిపోవడం ఫరో చూసినప్పుడు, అతడు మరలా పాపం చేశాడు: అతడు అతని అధికారులు తమ హృదయాలను కఠినం చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","యెహోవా మోషే ద్వారా చెప్పినట్లే ఫరో హృదయం కఠినపరచబడింది; అతడు ఇశ్రాయేలీయులను వెళ్లనివ్వలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","తర్వాత యెహోవా మోషేతో, “ఫరో దగ్గరకు వెళ్లు, ఎందుకంటే నేను అతని హృదయాన్ని అతని అధికారుల హృదయాలను కఠినం చేశాను తద్వార నేను ఈ నా సూచనలను వారి మధ్య ప్రదర్శించవచ్చు, ");
INSERT INTO telotsa_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","అప్పుడు మీరు మీ పిల్లలకు మనవళ్ళకు నేను ఈజిప్టు వారితో ఎలా కఠినంగా వ్యవహరించానో, వారి మధ్య నా సూచనలను ఎలా కనుపరిచానో చెప్పగలరు, నేను యెహోవానై ఉన్నాను అని మీరు తెలుసుకుంటారు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","కాబట్టి మోషే అహరోనులు ఫరో దగ్గరకు వెళ్లి అతనితో అన్నారు, “నేను యెహోవాను, హెబ్రీయుల దేవుడు ఇలా చెప్పారు: ‘ఎంతకాలం నిన్ను నీవు నా ఎదుట తగ్గించుకోకుండ ఉంటావు? నన్ను సేవించడానికి నా ప్రజలను వెళ్లనివ్వు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","నీవు వారిని వెళ్లనివ్వకపోతే రేపు నేను నీ దేశం మీదికి మిడతలను రప్పిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ఎవరు నేలను చూడలేనంతగా అవి నేలను కప్పివేస్తాయి. వడగండ్ల దెబ్బ నుండి తప్పించుకుని మీకు మిగిలిన కొద్ది దాన్ని కూడా అవి తినివేస్తాయి. మీ పొలంలో పెరుగుతున్న ప్రతి చెట్టును అవి తింటాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","నీ ఇల్లు నీ అధికారులందరి ఇల్లు ఈజిప్టు వారందరి ఇల్లు వాటితో నిండిపోతాయి. మీ తల్లిదండ్రులు గాని మీ పూర్వికులు గాని వారు ఈ దేశంలో స్థిరపడినప్పటి నుండి ఇప్పటివరకు అటువంటి వాటిని ఎన్నడూ చూడలేదు.’ ” తర్వాత మోషే ఫరో దగ్గర నుండి తిరిగి వచ్చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ఫరో అధికారులు అతనితో, “ఈ మనిషి ఎంతకాలం మనకి ఉరిగా ఉంటాడు? ఈ ప్రజలు తమ దేవుడైన యెహోవాను సేవించడానికి వారిని వెళ్లనివ్వు. ఈజిప్టు నాశనం చేయబడుతుందని నీవు గ్రహించవా?” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","అప్పుడు మోషే అహరోనులను తిరిగి ఫరో దగ్గరకు తీసుకువచ్చినప్పుడు అతడు, “వెళ్లండి, మీ దేవుడైన యెహోవాను సేవించండి, కాని ఎవరు వెళ్తారో నాకు చెప్పండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","అందుకు మోషే, “మేము యెహోవాకు పండుగ జరుపుకోవాలి కాబట్టి మేము మాలో చిన్నవారిని పెద్దవారిని మా కుమారులను కుమార్తెలను మా గొర్రెలను పశువులను తీసుకెళ్తాము” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","అందుకు ఫరో, “యెహోవా మీతో ఉండును గాక! ఒకవేళ నేను మిమ్మల్ని మీ స్త్రీలు, పిల్లలతో సహా వెళ్లనిస్తే! మీ చెడు ఆలోచన నాకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","కాబట్టి కేవలం పురుషులు మాత్రమే వెళ్లి యెహోవాను సేవించండి; మీరు అడుగుతుంది ఇదే కదా” అని వారితో అన్నాడు. అప్పుడు వారు ఫరో ఎదుట నుండి తరిమివేయబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","అప్పుడు యెహోవా మోషేతో, “ఈజిప్టు దేశమంతటిమీదికి మిడతల దండు వచ్చి పొలంలో పెరుగుతున్న ప్రతి మొక్కను, వడగండ్ల వలన పాడవని ప్రతిదాన్ని తినివేసేలా నీ చేతిని ఈజిప్టు మీద చాపు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","మోషే తన కర్రను ఈజిప్టు మీద చాపినప్పుడు యెహోవా పగలంతా రాత్రంతా ఆ దేశం మీద తూర్పు గాలి వీచేలా చేశారు. ఉదయానికి ఆ తూర్పుగాలికి మిడతలు వచ్చాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ఆ మిడతలు ఈజిప్టు దేశమంతటిని ఆక్రమించుకుని దేశంలోని ప్రతిచోట వాలాయి. అవి అసంఖ్యాకమైనవి. అటువంటి మిడతలు గతంలో ఎన్నడూ లేవు ఇకముందు ఉండవు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","నల్లగా ఉండే వరకు అవి భూమి అంతా కప్పాయి. వడగళ్ళకు పాడవకుండ పొలాల్లో ఉన్నవాటిని చెట్లకున్న పండ్లను అవి తినివేశాయి. ఈజిప్టు దేశమంతా చెట్టు మీద గాని మొక్క మీద గాని పచ్చదనం మిగల్లేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ఫరో వెంటనే మోషే అహరోనులను పిలిపించి వారితో, “మీ దేవుడైన యెహోవాకు మీకు వ్యతిరేకంగా నేను పాపం చేశాను. ");
INSERT INTO telotsa_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","దయచేసి మరొకసారి నా పాపాన్ని క్షమించి మరణం కలిగించే ఈ తెగులును నా నుండి తొలగించమని మీ దేవుడైన యెహోవాకు ప్రార్థించండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","మోషే ఫరో దగ్గర నుండి వెళ్లి యెహోవాకు ప్రార్థన చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","అప్పుడు యెహోవా గాలిని త్రిప్పి బలమైన పడమటి గాలి వీచేలా చేసినప్పుడు ఆ గాలికి మిడతలు ఎర్ర సముద్రంలోకి కొట్టుకుపోయాయి. ఈజిప్టులో ఎక్కడ కూడా ఒక్క మిడత కూడా మిగల్లేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","అయితే యెహోవా ఫరో హృదయాన్ని కఠినం చేశారు కాబట్టి అతడు ఇశ్రాయేలీయులను వెళ్లనివ్వలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","అప్పుడు యెహోవా మోషేతో, “ప్రతి ఒక్కరూ తడుముకునేంత కటిక చీకటి ఈజిప్టు దేశం మీద కమ్ముకునేలా నీ చేతిని ఆకాశం వైపు చాపు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","మోషే తన చేతిని ఆకాశం వైపు చాపినప్పుడు మూడు రోజులపాటు ఈజిప్టు దేశమంతా కటిక చీకటి కమ్ముకుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ఆ మూడు రోజులు ఎవరూ ఎవరిని చూడలేకపోయారు తామున్న చోట నుండి లేవలేకపోయారు. అయినప్పటికీ ఇశ్రాయేలీయులు నివసిస్తున్న ప్రాంతాల్లో వెలుగు ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","అప్పుడు ఫరో మోషేను పిలిపించి, “వెళ్లి యెహోవాను సేవించండి. మీ స్త్రీలు పిల్లలను కూడా మీతో వెళ్లవచ్చు; కాని మీ గొర్రెలు పశువులను ఇక్కడే వదిలేయండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","అందుకు మోషే, “మేము మా దేవుడైన యెహోవాకు బలులు, దహనబలులు అర్పించడానికి కావలసిన పశువులను నీవు మాకు ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","మా పశువులు కూడా మాతో రావాలి; ఒక్క డెక్క కూడా వదిలిపెట్టము. మా దేవుడైన యెహోవాను సేవించడానికి వాటిలో నుండే మేము తీసుకోవాలి, మేము అక్కడికి వెళ్లి మేము వేటితో యెహోవాను సేవించాలో మాకు తెలియదు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","అయితే యెహోవా ఫరో హృదయాన్ని కఠినం చేశారు కాబట్టి అతడు వారు వెళ్లడానికి ఒప్పుకోలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","అప్పుడు ఫరో మోషేతో, “నా ఎదుట నుండి వెళ్లిపో! మరలా నీవు నాకు కనపడకుండా చూసుకో! నీవు నా ముఖాన్ని చూసిన రోజునే నీవు మరణిస్తావు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","అందుకు మోషే, “నీవన్నట్లే చేస్తాను, మళ్ళీ ఇంకెప్పుడు నీ ముందు కనబడను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","అప్పుడు యెహోవా మోషేతో ఇలా అన్నారు, “ఫరో మీదికి ఈజిప్టు మీదికి నేను మరొక తెగులును తీసుకువస్తాను. దాని తర్వాత అతడు మిమ్మల్ని వెళ్లనిస్తాడు. అతడు మిమ్మల్ని వెళ్లనిచ్చినప్పుడు అతడు ఇక్కడినుండి మిమ్మల్ని పూర్తిగా వెళ్లగొడతాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","పురుషులు స్త్రీలు తమ పొరుగువారి నుండి వెండి బంగారు వస్తువులను అడిగి తీసుకోవాలని ప్రజలకు చెప్పు.” ");
INSERT INTO telotsa_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","యెహోవా ఇశ్రాయేలు ప్రజల పట్ల ఈజిప్టువారికి కనికరం కలిగేలా చేశారు, అంతేకాక మోషే ఈజిప్టు దేశంలో ఫరో అధికారులచేత ప్రజలచేత గొప్పగా గౌరవించబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","మోషే ఫరోతో, “యెహోవా చెప్పిన మాట ఇదే: ‘మధ్యరాత్రి నేను ఈజిప్టు దేశం గుండా వెళ్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","అప్పుడు ఈజిప్టులోని ప్రతి మొదటి సంతానం చస్తారు, సింహాసనం మీద కూర్చునే ఫరో మొదటి సంతానం మొదలుకొని తిరగలి విసిరే దాసి మొదటి సంతానం వరకు, పశువుల్లో కూడా మొదట పుట్టినవి చస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","అప్పుడు ఈజిప్టు దేశమంతటా పెద్ద రోదన ఉంటుంది. అటువంటి రోదన గతంలో ఎప్పుడూ లేదు ఇకముందు ఉండదు. ");
INSERT INTO telotsa_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","అయితే ఇశ్రాయేలీయులలో ఏ వ్యక్తిని చూసి కానీ లేదా జంతువును చూసి గాని ఒక కుక్క కూడా మొరుగదు.’ అప్పుడు యెహోవా ఈజిప్టు, ఇశ్రాయేలు మధ్య భేదం చూపించారని మీకు తెలుస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","అప్పుడు మీ అధికారులైన వీరందరు నా దగ్గరకు వచ్చి నా ఎదుట తలవంచి, ‘నీవు, నిన్ను అనుసరించే ప్రజలందరు వెళ్లండి’ అని చెప్తారు. అప్పుడు నేను వెళ్తాను” అని చెప్పి మోషే తీవ్రమైన కోపంతో ఫరో దగ్గర నుండి వెళ్లిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","అప్పుడు యెహోవా మోషేతో, “ఈజిప్టు దేశంలో నా అద్భుతాలు అధికమయ్యేలా ఫరో నీ మాట వినడం తృణీకరిస్తాడు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","మోషే అహరోనులు ఫరో ఎదుట ఈ అద్భుతాలన్నిటిని చేశారు, కాని యెహోవా ఫరో హృదయాన్ని కఠినపరిచారు కాబట్టి అతడు ఇశ్రాయేలు ప్రజలను తన దేశం నుండి బయటకు వెళ్లనివ్వలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","యెహోవా మోషే అహరోనులతో ఈజిప్టులో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ఈ నెల మీకు మొదటి నెల, ఇది మీ సంవత్సరానికి మొదటి నెల. ");
INSERT INTO telotsa_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ఇశ్రాయేలీయుల సమాజమంతటికి చెప్పండి, ఈ నెల పదవ రోజున ప్రతి మనిషి తన కుటుంబానికి ఒక గొర్రెను తీసుకోవాలి, ప్రతి ఇంటికి ఒకటి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ఆ గొర్రెపిల్ల మొత్తాన్ని తినడానికి ఒకవేళ కుటుంబం మరీ చిన్నగా ఉంటే, దానిని తమకు అతి దగ్గరగా ఉన్న పొరుగువారితో, అక్కడ ఎంతమంది ఉన్నారో ఆ లెక్కను పరిగణలోకి దానిని పంచుకోవాలి. ప్రతి ఒక్కరు తినే పరిమాణం బట్టి మీరు గొర్రెపిల్లను ఎంచుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","మీరు ఎంచుకున్న జంతువులు తప్పనిసరిగా ఏ లోపం లేని సంవత్సరపు మగవై ఉండాలి; వాటిని గొర్రెలలో నుండి కాని మేకలలో నుండి కాని తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ఇశ్రాయేలు సమాజంలోని సభ్యులందరు సంధ్య సమయంలో వాటిని వధించవలసిన నెల పద్నాలుగవ రోజు వరకు వాటిని జాగ్రత్తగా చూసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","అప్పుడు వారు దాని రక్తంలో కొంచెం తీసుకుని తాము గొర్రెపిల్లలను తినే వారి ఇళ్ళ ద్వారబంధాలకు రెండు పలకల మీద పూయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ఆ రాత్రే వారు అగ్నిలో కాల్చబడిన ఆ మాంసాన్ని చేదు మూలికలతో, పులియని రొట్టెలతో తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ఆ మాంసాన్ని పచ్చిగా గాని లేదా నీళ్లలో ఉడకబెట్టి గాని తినకూడదు, అయితే దాని తల, కాళ్లు, లోపలి భాగాలను అగ్నిలో కాల్చి తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","దానిలో దేన్ని కూడా ఉదయం వరకు మిగిలించకూడదు; ఉదయం వరకు దానిలో ఏమైనా మిగిలితే, దానిని మీరు కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","దానిని మీరు ఇలా తినాలి: మీ నడుము కట్టుకుని, మీ పాదాలకు చెప్పులు వేసుకుని మీ చేతిలో కర్ర పట్టుకోవాలి. త్వరగా దానిని తినాలి; ఇది యెహోవా పస్కాబలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“అదే రాత్రి నేను ఈజిప్టు దేశమంతా తిరుగుతూ ఆ దేశంలోని మనుష్యుల్లో జంతువుల్లో ప్రతి మొదటి సంతానాన్ని చంపి ఈజిప్టు దేవుళ్ళందరికి తీర్పు తీరుస్తాను. నేను యెహోవానై యున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","మీరున్న ఇళ్ళ మీద ఉన్న రక్తం మీకు గుర్తుగా ఉంటుంది, నేను ఆ రక్తాన్ని చూసినప్పుడు, మిమ్మల్ని దాటి వెళ్తాను. నేను ఈజిప్టును మొత్తినప్పుడు ఏ నాశనకరమైన తెగులు మిమ్మల్ని తాకదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ఈ రోజును మీరు స్మారకోత్సవం జరుపుకోవాలి; ఎందుకంటే రాబోయే తరాలకు దీనిని ఒక నిత్య కట్టుబాటుగా మీరు యెహోవాకు పండుగగా జరుపుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ఏడు రోజులు మీరు పులియని రొట్టెలు తినాలి. మొదటి రోజు మీ ఇండ్ల నుండి పులిసిన దాన్ని తీసివేయాలి, ఎందుకంటే మొదటి రోజు నుండి ఏడవ రోజు వరకు పులిసిన దానితో చేసిన రొట్టెలు ఎవరు తిన్నా, వారు ఇశ్రాయేలీయులలో నుండి కొట్టివేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","మొదటి రోజు పరిశుద్ధ సభను నిర్వహించాలి, ఏడవ రోజు మరొకటి నిర్వహించాలి. ఈ రోజుల్లో ప్రతిఒక్కరు తినడానికి ఆహారం సిద్ధం చేయడం తప్ప పనులేవీ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“పులియని రొట్టెల పండుగ మీరు జరుపుకోవాలి, ఎందుకంటే ఈ రోజునే నేను మీ విభాగాలను ఈజిప్టులో నుండి బయటకు తీసుకువచ్చాను. ఈ రోజును మీరు రాబోయే తరాలకు ఒక నిత్య కట్టుబాటుగా జరుపుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","మొదటి నెల పద్నాలుగవ రోజు సాయంత్రం నుండి ఇరవై ఒకటవ రోజు సాయంత్రం వరకు మీరు పులియని రొట్టెలు తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ఎందుకంటే ఏడు రోజులు మీ ఇళ్ళలో పులిసినదేది ఉండకూడదు. విదేశీయులు గాని స్వదేశీయులు గాని పులిసినదేదైనా తింటే వారిని ఇశ్రాయేలు సమాజం నుండి కొట్టివేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","పులిసినదేది మీరు తినకూడదు. మీరుండే అన్ని చోట్లలో పులియని రొట్టెలు మాత్రమే మీరు తినాలి.” ");
INSERT INTO telotsa_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","అప్పుడు మోషే ఇశ్రాయేలు పెద్దలందరినీ పిలిపించి వారితో ఇలా చెప్పాడు, “మీరు వెంటనే వెళ్లి మీ కుటుంబాల కోసం మందలో నుండి గొర్రెపిల్లను ఎంచుకుని పస్కా గొర్రెపిల్లను వధించండి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","హిస్సోపు కొమ్మను తీసుకుని, పళ్ళెంలో ఉన్న రక్తంలో దానిని ముంచి ద్వారబంధపు పైకమ్మికి, రెండు నిలువు కమ్మీలకు పూయాలి. ఉదయం వరకు మీలో ఎవరూ మీ ఇంటి ద్వారం నుండి బయటకు రాకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","యెహోవా ఈజిప్టువారిని హతం చేయడానికి దేశమంతా సంచరిస్తూ, ద్వారబంధపు పైకమ్మికి రెండు నిలువు కమ్మీలకు పూయబడిన రక్తాన్ని చూసి ఆయన ఆ ద్వారాన్ని దాటి వెళ్తారు. సంహారకుడు మీ ఇంట్లోకి వచ్చి మిమ్మల్ని చంపడానికి ఆయన అనుమతించడు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“మీకు మీ వారసులకు ఒక నిత్య కట్టుబాటుగా నా ఈ ఆదేశాలను పాటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","యెహోవా వాగ్దానం చేసినట్లుగా ఆయన మీకు ఇస్తానన్న దేశంలోనికి మీరు ప్రవేశించిన తర్వాత మీరు దీనిని ఆచరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","‘ఈ వేడుకకు అర్థమేంటి?’ అని మీ పిల్లలు మిమ్మల్ని అడిగినప్పుడు ");
INSERT INTO telotsa_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","మీరు వారితో, ‘ఇది యెహోవాకు పస్కాబలి; ఆయన ఈజిప్టువారిని చంపుతున్నప్పుడు ఈజిప్టులో ఉన్న ఇశ్రాయేలీయుల ఇళ్ళను ఆయన ఏమీ చేయకుండా దాటి వెళ్లారు’ అని చెప్పాలి.” అప్పుడు ప్రజలు తలలు వంచి ఆరాధించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","యెహోవా మోషే అహరోనులకు ఆజ్ఞాపించిన విధంగానే ఇశ్రాయేలీయులు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","అర్థరాత్రి సమయంలో సింహాసనం మీద కూర్చున్న ఫరో మొదటి సంతానం మొదలుకొని చెరసాలలోని ఖైదీ యొక్క మొదటి సంతానం వరకు ఈజిప్టులోని మొదటి సంతానమంతటిని పశువుల మొదటి సంతానాన్ని యెహోవా హతం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ఆ రాత్రి సమయంలో ఫరో అతని అధికారులందరు, ఈజిప్టువారందరు లేచారు, ఈజిప్టులో గొప్ప రోదన వినబడింది, ఎందుకంటే మరణం సంభవించని ఇల్లు ఒకటి కూడా లేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ఆ రాత్రివేళ ఫరో మోషే అహరోనులను పిలిపించి వారితో, “లేవండి! మీరు ఇశ్రాయేలు ప్రజలు వెంటనే బయలుదేరి నా ప్రజలను వదిలి వెళ్లిపొండి! మీరు కోరినట్లే వెళ్లి యెహోవాను ఆరాధించండి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","మీరు చెప్పినట్లే మీ పశువులను గొర్రెలను తీసుకుని వెళ్లండి. అలాగే నన్ను దీవించండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ఈజిప్టువారు ప్రజలను తొందరపెట్టి దేశం విడిచి వెళ్లాలని కోరారు. వారు, “లేకపోతే, మనమందరం చనిపోతాము!” అని అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","కాబట్టి ఇశ్రాయేలీయులు తమ పిండిముద్దను తీసుకుని అది పులియకముందే దానిని పిండి పిసికే తొట్లలో వేసి బట్టలో మూట కట్టుకుని తమ భుజాలమీద మోసుకొనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ఇశ్రాయేలీయులు మోషే సూచించిన ప్రకారమే చేసి ఈజిప్టువారి దగ్గర నుండి వెండి బంగారు వస్తువులను వస్త్రాలను అడిగి తీసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","యెహోవా ఈజిప్టువారికి ఇశ్రాయేలీయుల పట్ల దయ పుట్టించారు కాబట్టి వారు తమను అడిగి వాటన్నిటిని వారికి ఇచ్చారు. ఆ విధంగా వారు ఈజిప్టువారిని దోచుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","అప్పుడు ఇశ్రాయేలీయులు రామసేసునుండి సుక్కోతుకు ప్రయాణమై వెళ్లారు. వారిలో స్త్రీలు పిల్లలు కాకుండా కాలినడకన ఉన్నవారు ఆరు లక్షలమంది పురుషులు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","వారితో పాటు అనేకమంది ఇతర ప్రజలు ఉన్నారు అంతేకాక గొర్రెలు పశువుల పెద్ద మందలు కూడా ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ఇశ్రాయేలీయులు ఈజిప్టు నుండి తెచ్చిన పిండితో పులియని రొట్టెలు చేసి కాల్చారు. వారు ఈజిప్టు నుండి వెళ్లగొట్టబడినప్పుడు తమ కోసం ఆహారం సిద్ధపరచుకోవడానికి సమయం లేదు కాబట్టి ఆ పిండి పులియలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ఇశ్రాయేలు ప్రజలు ఈజిప్టులో నివసించిన కాలం 430 సంవత్సరాలు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","సరిగ్గా 430 సంవత్సరాలు గడిచిన రోజునే యెహోవా సేనలన్ని ఈజిప్టు దేశం నుండి బయలుదేరి వెళ్లిపోయాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ఈజిప్టు నుండి బయటకు తీసుకురావడానికి ఆ రాత్రి యెహోవా మెళకువగా ఉన్నందున, ప్రతి సంవత్సరం ఈ రాత్రి ఇశ్రాయేలీయులందరు రాబోయే తరాల కోసం ప్రభువును గౌరవించడానికి మెలకువగా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","యెహోవా మోషే అహరోనులతో ఇలా అన్నారు, “పస్కాను ఆచరించడానికి పాటించవలసిన నియమాలు ఇవే: “విదేశీయులెవరు దీనిని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","మీరు వెండి పెట్టి కొన్న బానిసకు మీరు సున్నతి చేసిన తర్వాత అతడు దీనిని తినవచ్చు, ");
INSERT INTO telotsa_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","తాత్కాలిక నివాసులు కాని కూలికి వచ్చినవారు కాని దీనిని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“దీనిని ఒక ఇంటి లోపలే తినాలి; దాని మాంసంలో దేన్ని ఇంటి బయటకు తీసుకెళ్లకూడదు. దాని ఎముకల్లో ఒక్కటి కూడా విరువకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ఇశ్రాయేలీయుల సమాజమంతా దీనిని ఆచరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“మీ మధ్య నివసించే విదేశీయులు యెహోవా పస్కాను ఆచరించాలనుకుంటే అతని ఇంట్లోని మగవారందరు సున్నతి పొందాలి. అప్పుడు వారు దేశంలో పుట్టినవారిలా దానిలో పాల్గొనవచ్చు. సున్నతి పొందని మగవారు దీనిని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","దీని గురించి స్వదేశీయులకు మీ మధ్య నివసిస్తున్న విదేశీయులకు ఒకే నియమం వర్తిస్తుంది.” ");
INSERT INTO telotsa_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","యెహోవా మోషే అహరోనులకు ఆజ్ఞాపించిన ప్రకారమే ఇశ్రాయేలీయులందరు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","అదే రోజు యెహోవా ఇశ్రాయేలీయులను వారి వారి విభజనల ప్రకారం ఈజిప్టు నుండి బయటకు రప్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","యెహోవా మోషేతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ప్రతీ మొదటి మగ సంతానాన్ని నాకు ప్రతిష్ఠించండి. ఇశ్రాయేలీయుల మనుష్యుల్లోనైనా పశువుల్లోనైనా ప్రతి గర్భం యొక్క మొదటి సంతానం నాదే.” ");
INSERT INTO telotsa_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","అప్పుడు మోషే ప్రజలతో ఇలా అన్నాడు, “మీరు బానిసలుగా ఉన్న ఈజిప్టు నుండి మీరు బయటకు వచ్చిన ఈ రోజును మీరు స్మారకోత్సవంగా జరుపుకోండి, ఎందుకంటే యెహోవా తన బలమైన హస్తంతో దాని నుండి మిమ్మల్ని బయటకు రప్పించారు. పులిసిన దేన్ని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","అబీబు అనే ఈ నెలలో ఈ రోజున మీరు బయలుదేరారు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","యెహోవా కనానీయుల హిత్తీయుల అమోరీయుల హివ్వీయుల యెబూసీయుల దేశం మీకు ఇస్తానని మీ పూర్వికులకు ప్రమాణం చేసిన పాలు తేనెలు ప్రవహించే దేశానికి మిమ్మల్ని రప్పించినప్పుడు ఈ నెలలో మీరు ఈ సేవలు జరిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ఏడు రోజులు మీరు పులియని రొట్టెలు తినాలి, ఏడవ రోజున యెహోవాకు పండుగ చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ఈ ఏడు రోజులు పులియని రొట్టెలు తినాలి; పులిసినదేది మీ మధ్య కనపడకూడదు. మీ సరిహద్దుల లోపల ఎక్కడా పులిసినది కనపడకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ఆ రోజున, ‘నేను ఈజిప్టు నుండి బయటకు వచ్చినప్పుడు యెహోవా నాకు చేసిన దానిని బట్టి నేను ఇది చేస్తున్నాను’ అని నీ కుమారునితో చెప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","యెహోవా తన బలమైన హస్తంతో మిమ్మల్ని ఈజిప్టులో నుండి బయటకు రప్పించారు కాబట్టి యెహోవా ధర్మశాస్త్రం మీ నోటిలో ఉండేలా ఈ సంస్కారం మీ చేతి మీద ఒక గుర్తుగా మీ నుదుటి మీద ఒక జ్ఞాపకంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ప్రతి సంవత్సరం నిర్ణయ కాలంలో మీరు ఈ సంస్కారాన్ని ఆచరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“యెహోవా మీకు మీ పూర్వికులకు ప్రమాణంతో వాగ్దానం చేసిన ప్రకారం కనాను దేశంలోనికి మిమ్మల్ని తీసుకువచ్చి దానిని మీకు ఇచ్చిన తర్వాత, ");
INSERT INTO telotsa_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ప్రతి గర్భం యొక్క మొదటి సంతానాన్ని మీరు యెహోవాకు వేరుగా ఉంచాలి. మీ పశువుల మొదటి మగపిల్లలు యెహోవాకు చెందుతాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ప్రతి మొదటి సంతానమైన గాడిదను గొర్రెపిల్లతో విడిపించాలి, కాని ఒకవేళ దానిని విడిపించకపోతే, దాని మెడ విరిచివేయాలి. మీ కుమారులలో మనుష్యుల ప్రతి మొదటి మగ సంతానాన్ని విడిపించుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“భవిష్యత్తులో మీ కుమారుడు, ‘దీని అర్థమేంటి?’ అని మిమ్మల్ని అడిగినప్పుడు, మీరు వానితో ఇలా చెప్పాలి, ‘బలమైన హస్తంతో యెహోవా బానిస దేశమైన ఈజిప్టు నుండి మమ్మల్ని బయటకు రప్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ఫరో మమ్మల్ని వెళ్లనివ్వకుండా తన మనస్సు కఠినం చేసుకుని నిరాకరించినప్పుడు, యెహోవా ఈజిప్టులో ఉన్న మనుష్యుల, పశువుల మొదటి సంతానమంతటిని చంపేశారు. ఆ కారణంగానే ప్రతి గర్భం యొక్క మొదటి మగ పిల్లను యెహోవాకు బలి ఇచ్చి, నా కుమారులలో ప్రతి మొదటి సంతానాన్ని విడిపించుకుంటాను.’ ");
INSERT INTO telotsa_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","యెహోవా తన బలమైన హస్తంతో మమ్మల్ని ఈజిప్టులో నుండి బయటకు రప్పించారు అనడానికి ఇది మీ చేతి మీద ఒక గుర్తుగా మీ నుదుటి మీద ఒక ముద్రగా ఉంటుంది.” ");
INSERT INTO telotsa_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ఫరో ప్రజలను వెళ్లనిచ్చినప్పుడు, ఫిలిష్తీయుల దేశం గుండా దగ్గర మార్గం ఉన్నప్పటికీ దేవుడు వారిని ఆ మార్గంలో నడిపించలేదు. ఎందుకంటే, “ఒకవేళ ఈ ప్రజలు యుద్ధాన్ని చూసి, వారు మనస్సు మార్చుకొని తిరిగి ఈజిప్టుకు వెళ్తారేమో” అని దేవుడు అనుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","కాబట్టి దేవుడు వారిని చుట్టూ త్రిప్పి అరణ్యమార్గంలో ఎర్ర సముద్రం వైపు నడిపించారు. ఇశ్రాయేలీయులు యుద్ధానికి సిద్ధపడి ఈజిప్టు నుండి బయటకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","యోసేపు ఇశ్రాయేలీయులతో, “దేవుడు ఖచ్చితంగా మిమ్మల్ని దర్శించడానికి వస్తారు, అప్పుడు మీరు నా ఎముకలను ఈ ప్రదేశం నుండి మీతో తీసుకెళ్లాలి” అని ప్రమాణం చేయించుకున్నాడు. కాబట్టి మోషే యోసేపు ఎముకలను తనతో తీసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","వారు సుక్కోతు నుండి బయలుదేరి ఏతాము ఎడారి అంచున గుడారాలు వేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","వారు పగలు రాత్రి ప్రయాణం చేయగలిగేలా యెహోవా పగటివేళ మేఘస్తంభంలో రాత్రివేళ వారికి వెలుగివ్వడానికి అగ్నిస్తంభంలో ఉండి వారికి ముందుగా నడిచారు. ");
INSERT INTO telotsa_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","పగటివేళ మేఘస్తంభం గాని, రాత్రివేళ అగ్నిస్తంభం గాని ప్రజల ఎదుట నుండి వాటి స్థలం వదిలిపోలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","తర్వాత యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ఇశ్రాయేలీయులను వెనుకకు తిరిగి పీ హహీరోతుకు సమీపంలో మిగ్దోలుకు సముద్రానికి మధ్యలో బయల్-సెఫోనుకు సరిగ్గా ఎదురుగా సముద్రతీరాన బసచేయమని వారితో చెప్పు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ఫరో ఇశ్రాయేలీయుల గురించి, ‘వారు ఈ దేశంలో కలవరంతో దారితప్పి తిరుగుతున్నారని, ఎడారిలో చిక్కుకున్నారని’ అనుకుంటాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","నేను ఫరో హృదయాన్ని కఠినం చేస్తాను కాబట్టి అతడు వారిని వెంటాడుతాడు. కాని ఫరో, అతని సైన్యం వలన నాకు మహిమ కలుగుతుంది. నేను యెహోవానై యున్నానని ఈజిప్టువారందరు తెలుసుకుంటారు.” కాబట్టి ఇశ్రాయేలీయులు అలాగే చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ప్రజలు పారిపోయారని ఈజిప్టు రాజుకు తెలియజేసినప్పుడు, వారి గురించి ఫరో అతని సేవకులు తమ మనస్సులు మార్చుకొని, “మనమెందుకు ఇలా చేశాము? మనకు సేవలు చేయకుండా మనం ఇశ్రాయేలీయులను వెళ్లనిచ్చాము!” అని చెప్పుకొన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","కాబట్టి అతడు తన రథాన్ని సిద్ధం చేసుకుని తనతో పాటు తన సైన్యాన్ని తీసుకెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","అతడు ప్రత్యేకమైన ఆరువందల రథాలను వాటితో పాటు ఈజిప్టులో ఉన్న ఇతర రథాలన్నిటిని ప్రతి దాని మీద అధిపతులతో తీసుకెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","యెహోవా ఈజిప్టు రాజైన ఫరో హృదయాన్ని కఠినం చేసినప్పుడు అతడు నిర్భయంగా వెళ్తున్న ఇశ్రాయేలీయులను వెంటాడాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ఈజిప్టువారు అంటే ఫరో యొక్క అన్ని గుర్రాలు, రథాలు, గుర్రపురౌతులు, దళాలు ఇశ్రాయేలీయులను వెంటాడి, వారిని దాటి బయల్-సెఫోను ఎదురుగా ఉన్న పీ హహీరోతుకు సమీపంలో సముద్రతీరాన బసచేసి వారిని పట్టుకోడానికి వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ఫరో దగ్గరగా వస్తుండగా, ఇశ్రాయేలీయులు పైకి చూసినప్పుడు ఈజిప్టువారు తమ వెనుక రావడం చూశారు. వారు భయపడి యెహోవాకు మొరపెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","వారు మోషేతో, “ఈజిప్టులో సమాధులు లేవని ఈ అరణ్యంలో చావడానికి మమ్మల్ని తీసుకువచ్చావా? ఈజిప్టులో నుండి మమ్మల్ని బయటకు తీసుకువచ్చి మాకు నీవు చేసిందేంటి? ");
INSERT INTO telotsa_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","మమ్మల్ని వదిలిపెట్టు, మేము ఈజిప్టువారికి సేవచేసుకుంటామని ఈజిప్టులో మేము నీతో చెప్పలేక? ఈ ఎడారిలో చావడం కంటే ఈజిప్టువారికి సేవచేసుకోవడం మాకు మేలు కదా!” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","అందుకు మోషే ప్రజలతో అన్నాడు, “భయపడకండి. స్థిరంగా నిలబడి యెహోవా ఈ రోజు మీకు కలుగజేసే విడుదలను చూడండి. ఈ రోజు మీరు చూస్తున్న ఈజిప్టువారు మరలా మీరెప్పుడూ చూడరు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","యెహోవా మీ కోసం యుద్ధం చేస్తారు; మీరు మౌనంగా ఉంటే చాలు.” ");
INSERT INTO telotsa_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","అప్పుడు యెహోవా మోషేతో అన్నారు, “నీవెందుకు నాకు మొరపెడుతున్నావు? ముందుకు సాగిపొమ్మని ఇశ్రాయేలీయులకు చెప్పు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","నీ కర్ర ఎత్తి ఆ సముద్రం వైపు నీ చేతిని చాపి దానిని పాయలుగా చేయి అప్పుడు ఇశ్రాయేలీయులు సముద్రం గుండా ఆరిన నేలమీద నడిచివెళ్తారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","నేను ఈజిప్టువారి హృదయాలను కఠినం చేస్తాను కాబట్టి వారు వీరి వెనుక వస్తారు. ఫరోను బట్టి అతని సైన్యమంతటిని బట్టి అతని రథాలు గుర్రపురౌతులను బట్టి నాకు మహిమ కలుగుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ఫరోను బట్టి అతని రథాలు గుర్రపురౌతులను బట్టి నాకు మహిమ కలిగినప్పుడు నేనే యెహోవానై యున్నానని ఈజిప్టువారు తెలుసుకుంటారు.” ");
INSERT INTO telotsa_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","అప్పుడు ఇశ్రాయేలీయుల సైన్యానికి ముందు నడుస్తున్న దేవదూత వారి వెనుకకు వెళ్లాడు. మేఘస్తంభం కూడా వారి ఎదుట నుండి కదిలి వారి వెనుకకు వెళ్లి, ");
INSERT INTO telotsa_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ఈజిప్టువారి సైన్యానికి ఇశ్రాయేలీయుల సైన్యానికి మధ్య నిలబడింది. ఆ రాత్రంతా ఆ మేఘం ఈజిప్టువారికి చీకటి కలిగించింది కాని ఇశ్రాయేలీయులకు వెలుగునిచ్చింది కాబట్టి ఈజిప్టువారు వీరిని సమీపించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","మోషే సముద్రం వైపు తన చేతిని చాపగా యెహోవా ఆ రాత్రంతా బలమైన తూర్పు గాలిచేత సముద్రాన్ని పాయలుగా చేసి దానిని ఆరిన నేలగా చేశారు. నీళ్లు రెండుగా విడిపోయాయి, ");
INSERT INTO telotsa_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ఇశ్రాయేలీయులు సముద్రం గుండా ఆరిన నేల మీద నడిచివెళ్లారు. వారి కుడి ఎడమల వైపు నీళ్లు గోడల వలె నిలబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ఈజిప్టువారు వారిని వెంటపడ్డారు; ఫరో గుర్రాలు రథాలు, గుర్రపురౌతులు అన్ని సముద్రం మధ్యలో వారిని వెంటాడాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","తెల్లవారుజామున యెహోవా అగ్ని మేఘస్తంభం నుండి ఈజిప్టువారి సైన్యాన్ని చూసి ఆయన వారిని కలవరానికి గురి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ఆయన వారి రథచక్రాలను ఇరక్కుపోయేలా చేయడంతో వాటిని నడపడం వారికి కష్టంగా ఉంది. అప్పుడు ఈజిప్టువారు, “ఇశ్రాయేలీయుల దగ్గర నుండి పారిపోదాం రండి! వారి పక్షంగా యెహోవా ఈజిప్టువారికి వ్యతిరేకంగా యుద్ధం చేస్తున్నారు” అని చెప్పుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","అప్పుడు యెహోవా మోషేతో, “ఈజిప్టువారి మీదికి వారి రథాల మీదికి వారి గుర్రపురౌతుల మీదికి నీళ్లు వచ్చేలా నీ చేయి సముద్రం మీద చాపు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","మోషే సముద్రం మీద తన చేయి చాపగా సూర్యోదయ సమయంలో సముద్రం తన స్థానంలోనికి తిరిగి వచ్చేసింది. ఈజిప్టువారు దాని నుండి పారిపోతున్నారు కాని యెహోవా వారిని సముద్రంలో ముంచివేసారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","నీళ్లు వెనుకకు ప్రవహించి సముద్రంలో ఇశ్రాయేలీయులను తరుముతున్న ఫరో సైన్యమంతటిని అంటే రథాలను గుర్రపురౌతులను కప్పివేశాయి. వారిలో ఒక్కరు కూడా బ్రతికి బయటపడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","అయితే ఇశ్రాయేలీయులు సముద్రం మధ్యలో ఆరిన నేలమీద వెళ్తున్నప్పుడు ఆ నీళ్లు వారి కుడి ఎడమ ప్రక్కల గోడల వలె నిలబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ఆ రోజు యెహోవా ఈజిప్టువారి చేతిలో నుండి ఇశ్రాయేలీయులను రక్షించారు. ఇశ్రాయేలీయులు సముద్రతీరాన చచ్చిపడివున్న ఈజిప్టువారిని చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ఈజిప్టువారికి వ్యతిరేకంగా పని చేసిన యెహోవా బలమైన హస్తాన్ని ఇశ్రాయేలీయులు చూచారు కాబట్టి ఆ ప్రజలు యెహోవాకు భయపడి యెహోవా మీద ఆయన సేవకుడైన మోషే మీద నమ్మకముంచారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","దాని తర్వాత మోషే ఇశ్రాయేలీయులు యెహోవాకు ఈ పాట పాడారు: “నేను యెహోవాకు పాడతాను, ఆయన ఉన్నతంగా హెచ్చింపబడ్డారు. గుర్రాన్ని దాని రౌతును ఆయన సముద్రంలో పడవేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“యెహోవాయే నా బలము నా పాట; ఆయన నాకు రక్షణ అయ్యారు. ఆయన నా దేవుడు నేను ఆయనను స్తుతిస్తాను, ఆయన నా తండ్రికి దేవుడు నేనాయనను మహిమపరుస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","యెహోవా యుద్ధవీరుడు; యెహోవా అని ఆయనకు పేరు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ఆయన ఫరో రథాలను అతని సైన్యాన్ని సముద్రంలో ముంచివేసారు. అతని అధిపతులలో ప్రముఖులు ఎర్ర సముద్రంలో మునిగిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","అగాధజలాలు వారిని కప్పివేశాయి. రాయిలా వారు అడుగున మునిగిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","యెహోవా, మీ కుడిచేయి, బలంలో మహిమగలది. యెహోవా, మీ కుడిచేయి, శత్రువును పడగొట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“మీకు వ్యతిరేకంగా లేచినవారిని మీ మహిమాతిశయంతో అణచివేశారు. మీరు మీ కోపాగ్నిని రగిలించారు అది వారిని చెత్తలా దహించింది. ");
INSERT INTO telotsa_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","మీ ముక్కు నుండి వచ్చిన ఊపిరివలన నీళ్లు కుప్పగా నిలిచాయి. ప్రవాహజలాలు గోడలా నిలబడ్డాయి; అగాధజలాలు సముద్రం మధ్యలో గడ్డకట్టాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","‘నేను వారిని తరుముతాను, వారిని పట్టుకుంటాను. దోపుడుసొమ్మును పంచుకుంటాను; వాటివలన నా ఆశ తీర్చుకుంటాను. నేను నా ఖడ్గాన్ని దూస్తాను నా చేయి వారిని నాశనం చేస్తుంది’ అని శత్రువు అనుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","అయితే మీరు మీ శ్వాసను ఊదగా సముద్రం వారిని కప్పేసింది. వారు బలమైన జలాల క్రింద సీసంలా మునిగిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","యెహోవా, దేవుళ్ళ మధ్యలో మీవంటి వారెవరు? పరిశుద్ధతలో ఘనమైనవారు మహిమలో భీకరమైనవారు, అద్భుతాలు చేసే మీవంటి వారెవరు? ");
INSERT INTO telotsa_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“మీరు మీ కుడిచేయి చాపగా భూమి మీ శత్రువులను మ్రింగివేసింది. ");
INSERT INTO telotsa_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","మీరు విమోచించిన ప్రజలను మారని మీ ప్రేమతో నడిపిస్తారు. మీ బలంతో మీరు వారిని మీ పరిశుద్ధాలయానికి నడిపిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","దేశాలు విని వణుకుతాయి; ఫిలిష్తియా ప్రజలకు వేదన కలుగుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ఎదోము పెద్దలు భయపడతారు, మోయాబు నాయకులకు వణుకు పుడుతుంది. కనాను ప్రజలు భయంతో నీరైపోతారు; ");
INSERT INTO telotsa_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","భయం దిగులు వారి మీద పడతాయి. యెహోవా, మీ ప్రజలు దాటి వెళ్లేవరకు, మీరు కొనిన మీ ప్రజలు దాటి వెళ్లేవరకు మీ బాహుబలము చేత వారు రాతిలా కదలకుండా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","మీరు వారిని లోపలికి తెచ్చి మీ స్వాస్థ్యమైన పర్వతం మీద యెహోవా, మీరు నివసించడానికి నిర్మించుకున్న స్థలంలో, ప్రభువా, మీ చేతులు స్థాపించిన పరిశుద్ధాలయంలో నాటుతారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“యెహోవా నిరంతరం పరిపాలిస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ఫరో గుర్రాలు, రథాలు, గుర్రపురౌతులు సముద్రంలోకి వచ్చినప్పుడు, యెహోవా వారి మీదికి సముద్రపు నీటిని రప్పించారు. అయితే ఇశ్రాయేలీయులు సముద్రం గుండా ఆరిన నేల మీద నడిచారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","అప్పుడు అహరోను సోదరి ప్రవక్త్రియైన మిర్యాము తంబుర తన చేతిలోనికి తీసుకున్నది. అప్పుడు స్త్రీలందరు తంబురలతో నాట్యంతో ఆమెను అనుసరించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","మిర్యాము వారితో ఇలా పాడింది: “యెహోవాకు పాడండి, ఎందుకంటే ఉన్నతంగా హెచ్చింపబడ్డారు. గుర్రాన్ని దాని రౌతును ఆయన సముద్రంలో విసిరిపడవేశారు.” ");
INSERT INTO telotsa_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","తర్వాత మోషే ఎర్ర సముద్రం నుండి ఇశ్రాయేలీయులను నడిపించగా వారు షూరు ఎడారిలోనికి వెళ్లి మూడు రోజులు దానిలో ప్రయాణం చేశారు. అక్కడ వారికి నీరు దొరకలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","అప్పుడు వారు మారాకు వచ్చారు. అయితే మారా నీళ్లు చేదుగా ఉండడంతో వారు ఆ నీటిని త్రాగలేకపోయారు. (అందువల్ల ఆ చోటికి మారా అనే పేరు వచ్చింది.) ");
INSERT INTO telotsa_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","కాబట్టి ప్రజలు, “మేమేమి త్రాగాలి?” అని మోషే మీద సణిగారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","అప్పుడు మోషే యెహోవాకు మొరపెట్టగా యెహోవా అతనికి ఒక చెట్టు కొమ్మను చూపించారు. అతడు దానిని నీటిలో వేయగా ఆ నీరు తియ్యగా మారాయి. అక్కడే యెహోవా వారికి ఒక శాసనాన్ని నియమించి వారిని పరీక్షించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ఆయన వారితో, “మీ దేవుడైన యెహోవా స్వరాన్ని మీరు సరిగ్గా విని, ఆయన దృష్టికి న్యాయమైన వాటిని చేసి, మీరు ఆయన ఆజ్ఞలకు జాగ్రత్తగా లోబడి ఆయన శాసనాలన్నిటిని అనుసరిస్తే, నేను ఈజిప్టువారి మీదికి రప్పించిన తెగుళ్ళలో ఏదీ మీ మీదికి రాదు, మిమ్మల్ని స్వస్థపరచే యెహోవాను నేనే” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","తర్వాత వారు ఎలీముకు వచ్చారు. అక్కడ పన్నెండు నీటి ఊటలు డెబ్బై తాటి చెట్లు ఉన్నాయి. వారు ఆ నీటి దగ్గరే బస చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ఇశ్రాయేలీయుల సమాజమంతా ఎలీము నుండి ప్రయాణమై, వారు ఈజిప్టు నుండి బయటకు వచ్చిన రెండవ నెల పదిహేనవ రోజున ఎలీముకు సీనాయికి మధ్య ఉన్న సీను అరణ్యం చేరారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ఆ అరణ్యంలో ఇశ్రాయేలీయుల సమాజమంతా మోషే అహరోనుల మీద సణిగింది. ");
INSERT INTO telotsa_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ఇశ్రాయేలీయులు వారితో, “మేము ఈజిప్టు దేశంలో మాంసం వండుకున్న కుండల చుట్టూ కూర్చుని మేము కోరుకున్న ఆహారమంతా తృప్తిగా తిన్నప్పుడే యెహోవా చేతిలో చనిపోయినా బాగుండేది. అయితే ఈ సమాజమంతా ఆకలితో చనిపోవాలని మీరు మమ్మల్ని ఈ అరణ్యంలోకి తీసుకువచ్చారు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","అప్పుడు యెహోవా మోషేతో, “నేను మీ కోసం ఆకాశం నుండి ఆహారాన్ని కురిపిస్తాను. ప్రజలు ప్రతిరోజు వెళ్లి ఆ రోజుకు సరిపడే ఆహారం పోగుచేసుకోవాలి. ఆ విధంగా వారిని పరీక్షించి వారు నా ఉపదేశాలను పాటిస్తున్నారో లేదో చూస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ఆరవ రోజున వారు తెచ్చుకున్న దానిని సిద్ధపరచుకోవాలి, అది మిగిలిన రోజుల్లో వారు సమకూర్చుకొనే దానికన్నా రెండింతలు ఉండాలి” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","కాబట్టి మోషే అహరోనులు ఇశ్రాయేలీయులందరితో, “మిమ్మల్ని ఈజిప్టులో నుండి బయటకు రప్పించింది యెహోవాయే అని సాయంకాలాన మీరు తెలుసుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ఉదయకాలం మీరు యెహోవా మహిమను చూస్తారు, ఎందుకంటే మీరు ఆయనకు వ్యతిరేకంగా సణగడం ఆయన విన్నారు. మీరు మామీద సణగడానికి మేము ఏపాటివారం?” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ఇంకా మోషే మాట్లాడుతూ, “మీరు తినడానికి సాయంకాలం మాంసాన్ని, ఉదయకాలం మీకు సరిపడే ఆహారాన్ని యెహోవా మీకు ఇచ్చినప్పుడు, ఆయన యెహోవా అని మీరు తెలుసుకుంటారు, ఎందుకంటే మీరు ఆయనకు వ్యతిరేకంగా సణగడం ఆయన విన్నారు. మేము ఏపాటివారం? మీరు మామీద సణగడం లేదు, కాని యెహోవా మీదనే సణుగుతున్నారు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","తర్వాత మోషే అహరోనుతో ఇలా చెప్పాడు, “ఇశ్రాయేలీయుల సమాజమంతటికి ఇలా చెప్పు, ‘యెహోవా మీ సణుగుడు విన్నారు కాబట్టి ఆయన ఎదుటకు రండి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","అహరోను ఇశ్రాయేలీయుల సమాజమంతటితో మాట్లాడుతున్నప్పుడు వారు అరణ్యం వైపు చూసినప్పుడు అక్కడ వారికి యెహోవా మహిమ మేఘంలో కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","అప్పుడు యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“నేను ఇశ్రాయేలీయుల సణుగులు విన్నాను. వారితో ఇలా చెప్పు, ‘సాయంకాలం మీరు మాంసాన్ని తింటారు, ఉదయకాలం ఆహారం తిని తృప్తిపొందుతారు. అప్పుడు మీ దేవుడనైన యెహోవాను నేనే అని మీరు తెలుసుకుంటారు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ఆ సాయంకాలం పూరేళ్ళు వచ్చి శిబిరం స్థలాన్ని కప్పివేశాయి, ఉదయకాలం ఆ శిబిరం చుట్టూ మంచు పొర ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ఆ మంచు కరిగిపోయిన తర్వాత, ఆ ఎడారి నేలమీద మంచుకణాల వంటి సన్నని కణాలు కనిపించాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ఇశ్రాయేలీయులు వాటిని చూసి, అది ఏమిటో వారికి తెలియక, “ఇదేమిటి?” అని ఒకరితో ఒకరు చెప్పుకున్నారు. మోషే వారితో, “ఇది మీరు తినడానికి యెహోవా ఇచ్చిన ఆహారము. ");
INSERT INTO telotsa_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","యెహోవా ఇచ్చిన ఆజ్ఞ ఇదే: ‘ప్రతి ఒక్కరూ తమకు అవసరమైనంత పోగుచేసుకోవాలి. మీ గుడారంలో ఉన్న ఒక్కొక్కరికి ఒక్కొక్క ఓమెరు చొప్పున పోగుచేసుకోవాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ఇశ్రాయేలీయులు తమకు చెప్పబడినట్లుగానే చేశారు; కొందరు ఎక్కువ, కొందరు తక్కువ కూర్చుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","వారు దానిని ఓమెరుతో కొలిచినప్పుడు ఎక్కువ పోగుచేసుకున్న వారికి ఎక్కువ మిగల్లేదు తక్కువ పోగుచేసుకున్న వారికి తక్కువ కాలేదు. ప్రతిఒక్కరు తమకు ఎంత అవసరమో అంతే పోగుచేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","అప్పుడు మోషే వారితో, “దీనిలో ఏది ఉదయం వరకు ఎవరూ మిగుల్చుకోకూడదు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","అయితే వారిలో కొందరు మోషే మాట వినిపించుకోకుండా దానిలో కొంచెం ఉదయం వరకు మిగుల్చుకొనగా అది పురుగుపట్టి కంపుకొట్టింది. కాబట్టి మోషే వారిమీద కోపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ప్రతి ఉదయం ప్రతి ఒక్కరు తమకు కావలసినంత పోగుచేసుకునేవారు, ఎండ తీవ్రత పెరిగినప్పుడు అది కరిగిపోయేది. ");
INSERT INTO telotsa_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ఆరవరోజు, ఒక్కొక్కరికి రెండేసి ఓమెర్ల చొప్పున రెట్టింపు పోగుచేసుకున్నారు, సమాజ నాయకులు వచ్చి మోషేకు దానిని తెలిపారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","అతడు వారితో, “యెహోవా ఆజ్ఞ ఇదే, రేపు సబ్బాతు దినము. అది యెహోవాకు పరిశుద్ధమైన సబ్బాతు విశ్రాంతి దినము. కాబట్టి మీరు కాల్చుకోవాలనుకున్నది కాల్చుకోండి, వండుకోవాలనుకున్నది వండుకోండి. మిగిలింది ఉదయం వరకు ఉంచుకోండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","మోషే ఆజ్ఞాపించిన ప్రకారమే వారు ఉదయం వరకు దానిని ఉంచారు కాని అది కంపుకొట్టలేదు పురుగులు పట్టలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","అప్పుడు మోషే, “ఈ రోజు దానిని తినండి. ఈ రోజు యెహోవాకు సబ్బాతు దినము. ఈ రోజు నేల మీద ఏమి దొరకదు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ఆరు రోజులు మీరు దానిని పోగుచేసుకోవాలి కాని ఏడవ రోజున, అనగా సబ్బాతు దినాన్న అది దొరకదు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","అయితే కొందరు ఏడవ రోజున దానిని పోగుచేసుకుందామని బయటకు వెళ్లారు కాని వారికేమి దొరకలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","కాబట్టి యెహోవా మోషేతో, “ఎంతకాలం మీరు నా ఆజ్ఞలను సూచనలను పాటించకుండా ఉంటారు? ");
INSERT INTO telotsa_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","యెహోవా ఈ సబ్బాతును మీకు ఇచ్చారని మనస్సులో గుర్తించుకోండి; అందుకే ఆరవరోజు ఆయన మీకు రెండు రోజులకు సరిపడా ఆహారమిస్తున్నారు. ఏడవ రోజున ప్రతిఒక్కరు తామున్న చోటనే ఉండాలి. ఏడవ రోజున ఎవరు తామున్న చోటినుండి బయటకు వెళ్లకూడదు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","కాబట్టి ప్రజలు ఏడవ రోజున విశ్రాంతి తీసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ఇశ్రాయేలీయులు ఈ ఆహారానికి మన్నా అని పేరు పెట్టారు. అది తెల్లగా కొత్తిమెర గింజల్లా ఉండి దాని రుచి తేనెతో చేసిన పల్చనిరొట్టెల వలె ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","మోషే వారితో, “యెహోవా ఇచ్చిన ఆజ్ఞ ఇదే: ‘నేను మిమ్మల్ని ఈజిప్టు నుండి రప్పించినప్పుడు అరణ్యంలో తినడానికి నేను మీకిచ్చిన ఆహారాన్ని రాబోయే తరాలవారు చూసేలా ఒక ఓమెరు మన్నాను తీసుకుని తమ దగ్గర ఉంచాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","కాబట్టి మోషే అహరోనుతో, “ఒక జాడీ తీసుకుని అందులో ఒక ఓమెరు మన్నాను నింపి, రాబోయే తరాలవారు తమ దగ్గర ఉంచుకునేలా దానిని యెహోవా ఎదుట ఉంచాలి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం, అహరోను మన్నాను నిబంధన పలకలను మందసం దగ్గర ఉంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ఇశ్రాయేలీయులు తాము నివసించవలసిన దేశానికి వచ్చేవరకు 40 సంవత్సరాలు మన్నాను తిన్నారు; వారు కనాను సరిహద్దులు చేరేవరకు మన్నాను తిన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(ఓమెరు అనగా ఏఫాలో పదవ వంతు.) ");
INSERT INTO telotsa_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ఇశ్రాయేలీయుల సమాజమంతా సీను అరణ్యం నుండి బయలుదేరి యెహోవా ఆజ్ఞాపించిన ప్రకారం ఒక ప్రదేశం నుండి మరొక ప్రదేశానికి ప్రయాణించారు. వారు రెఫీదీములో బస చేశారు, కాని అక్కడ ప్రజలకు త్రాగడానికి నీళ్లు లేవు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","కాబట్టి వారు మోషేతో గొడవపడుతూ, “మాకు త్రాగడానికి నీళ్లు ఇవ్వు” అని అడిగారు. అందుకు మోషే, “నాతో ఎందుకు గొడవపడుతున్నారు? యెహోవాను ఎందుకు పరీక్షిస్తున్నారు?” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","కాని అక్కడ ప్రజలు దాహం తట్టుకోలేక మోషే మీద సణుగుతూ, “మీరు మమ్మల్ని ఈజిప్టు నుండి ఎందుకు తీసుకువచ్చారు? దాహంతో మేము మా పిల్లలు మా పశువులు చావాలనా?” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","అప్పుడు మోషే యెహోవాకు మొరపెట్టి, “ఈ ప్రజలతో నేనేం చేయాలి? వీరు దాదాపు నన్ను రాళ్లతో కొట్టడానికి సిద్ధంగా ఉన్నారు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","యెహోవా మోషేతో, “ప్రజలకు ముందుగా వెళ్లు. నీతో ఇశ్రాయేలీయుల పెద్దలలో కొందరిని తీసుకుని నైలు నదిని కొట్టిన చేతికర్రను పట్టుకుని వెళ్లు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","అక్కడ హోరేబులో బండ దగ్గర నేను నీకు ఎదురుగా నిలబడి ఉంటాను. నీవు ఆ బండను కొట్టు, ప్రజలు త్రాగడానికి ఆ బండ నుండి నీళ్లు వస్తాయి” అని చెప్పారు. కాబట్టి మోషే ఇశ్రాయేలీయుల పెద్దలు చూస్తుండగా యెహోవా చెప్పినట్టు చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ఇశ్రాయేలీయులు, “యెహోవా మన మధ్య ఉన్నాడా లేడా?” అని అంటూ మోషేతో జగడమాడి, యెహోవాను పరీక్షించారు కాబట్టి మోషే ఆ చోటికి మస్సా అని మెరీబా అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","రెఫీదీములో అమాలేకీయులు వచ్చి ఇశ్రాయేలీయులపై దాడి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","అప్పుడు మోషే యెహోషువతో, “మన పురుషులలో కొందరిని ఎంపిక చేసుకుని అమాలేకీయులతో యుద్ధం చేయడానికి బయలుదేరి వెళ్లు. రేపు దేవుని కర్ర నా చేతులతో పట్టుకుని కొండ శిఖరం మీద నిలబడతాను” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","మోషే ఆజ్ఞాపించిన ప్రకారం యెహోషువ అమాలేకీయులతో యుద్ధం చేశాడు. మోషే అహరోను హూరు అనేవారు కొండశిఖరానికి ఎక్కి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","మోషే తన చేతులు పైకి ఎత్తినంతసేపు ఇశ్రాయేలీయులు గెలిచారు. మోషే తన చేతులు క్రిందికి దించినప్పుడు అమాలేకీయులు గెలిచారు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","మోషే చేతులు అలసిపోయినప్పుడు వారు ఒక రాయిని తెచ్చి అతని దగ్గర వేయగా అతడు దాని మీద కూర్చున్నాడు. అహరోను హూరులు అతనికి ఆ ప్రక్కన ఒకరు ఈ ప్రక్కన ఒకరు నిలబడి సూర్యుడు అస్తమించే వరకు మోషే చేతులు స్థిరంగా ఉండేలా పైకి ఎత్తి పట్టుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","దాని ఫలితంగా యెహోషువ ఖడ్గంతో అమాలేకీయుల సైన్యాన్ని జయించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","తర్వాత యెహోవా మోషేతో, “అమాలేకు పేరును ఆకాశం క్రింద ఉండకుండ పూర్తిగా కొట్టివేస్తాను, కాబట్టి జ్ఞాపకం చేసుకునేలా దీనిని ఒక గ్రంథంలో వ్రాసి యెహోషువకు వినిపించు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","మోషే ఒక బలిపీఠం కట్టి దానికి యెహోవా నిస్సీ అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","అతడు, “యెహోవా సింహాసనానికి వ్యతిరేకంగా తమ చేతిని పైకి ఎత్తారు, కాబట్టి యెహోవా అమాలేకీయులతో తరతరాల వరకు యుద్ధం చేస్తూనే ఉంటారు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","కొంతకాలం గడిచిన తర్వాత మిద్యాను యాజకుడు, మోషేకు మామయైన యెత్రో, దేవుడు మోషేకు అతని ప్రజలైన ఇశ్రాయేలీయులకు చేసినదంతటిని గురించి, యెహోవా ఇశ్రాయేలీయులను ఈజిప్టు నుండి బయటకు రప్పించిన సంగతి విన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","మోషే తన భార్య సిప్పోరాను పంపిన తర్వాత, అతని మామ యెత్రో ఆమెను చేర్చుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","మోషే, “నేను పరాయి దేశంలో విదేశీయునిగా ఉన్నాను” అని చెప్పి ఒక కుమారునికి గెర్షోము అని పేరు పెట్టాడు; ");
INSERT INTO telotsa_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","మరొకనికి, “నా తండ్రి దేవుడు నాకు సహాయకుడు; ఫరో ఖడ్గం నుండి ఆయన నన్ను రక్షించారు” అని చెప్పి ఎలీయెజెరు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","మోషే మామయైన యెత్రో మోషే కుమారులను అతని భార్యను తీసుకుని అరణ్యంలో దేవుని పర్వతం దగ్గర బస చేస్తున్న మోషే దగ్గరకు వచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","“నీ మామనైన యెత్రో అనే నేను, నీ భార్యను నీ ఇద్దరు కుమారులను తీసుకుని నీ దగ్గరకు వస్తున్నాను” అని యెత్రో మోషేకు కబురు పంపాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","కాబట్టి మోషే తన మామను ఎదుర్కోడానికి వెళ్లి నమస్కరించి అతన్ని ముద్దు పెట్టుకున్నాడు. వారు ఒకరి క్షేమాన్ని ఒకరు తెలుసుకొని గుడారంలోకి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","అప్పుడు యెహోవా ఇశ్రాయేలీయుల కోసం ఫరోకు ఈజిప్టువారికి చేసిన దాని గురించి, దారిలో తమకు ఎదురైన కష్టాల గురించి, యెహోవా తమను కాపాడిన విధానం గురించి మోషే తన మామకు వివరించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ఈజిప్టువారి చేతిలో నుండి ఇశ్రాయేలీయులను విడిపించడానికి యెహోవా చేసిన మేలులన్నిటిని విని యెత్రో ఎంతో సంతోషించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","అప్పుడు యెత్రో, “ఈజిప్టువారి చేతిలో నుండి ఫరో చేతిలో నుండి మిమ్మల్ని విడిపించి ఈజిప్టువారి చేతి క్రిందనుండి ఈ ప్రజలను విడిపించిన యెహోవా స్తుతించబడును గాక. ");
INSERT INTO telotsa_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ఇశ్రాయేలీయుల పట్ల అహంకారంగా ప్రవర్తించిన వారికి ఆయన చేసిన దానిని బట్టి ఇతర దేవుళ్ళందరికంటే యెహోవాయే గొప్పవాడని నేనిప్పుడు తెలుసుకున్నాను” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","అప్పుడు మోషే మామయైన యెత్రో, ఒక దహనబలిని ఇతర బలులను దేవునికి అర్పించగా, దేవుని సన్నిధిలో మోషే మామతో కలిసి భోజనం తినడానికి అహరోను, ఇశ్రాయేలీయుల పెద్దలందరితో కలిసి వచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","మర్నాడు మోషే ప్రజలకు న్యాయం తీర్చడానికి తన స్థానంలో కూర్చున్నాడు, వారు ఉదయం నుండి సాయంత్రం వరకు అతని చుట్టూ నిలబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","మోషే ప్రజలకు చేస్తున్న వాటన్నిటిని అతని మామ చూసినప్పుడు, అతడు, “నీవు ఈ ప్రజలకు చేస్తున్నది ఏమిటి? ఉదయం నుండి సాయంత్రం వరకు ఈ ప్రజలందరు నీ చుట్టూ నిలబడి ఉండగా, న్యాయాధిపతిగా నీవు ఒక్కడివే ఎందుకు కూర్చున్నావు?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","అందుకు మోషే అతనితో, “ఎందుకంటే దేవుని చిత్తాన్ని తెలుసుకోవడానికి ప్రజలు నా దగ్గరకు వస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","వారికెప్పుడు ఏ వివాదం ఉన్నా, అది నా దగ్గరకు తేబడుతుంది, నేను వారి మధ్య నిర్ణయించిన దేవుని శాసనాలను, సూచనలను వారికి తెలియజేస్తాను” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","అందుకు మోషే మామ, “నీవు చేస్తున్నది సరియైనది కాదు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","నీవు, నీ దగ్గరకు వస్తున్న ఈ ప్రజలు అలసిపోతారు. ఈ పని నీకు చాలా భారంగా ఉంది; నీవు ఒక్కడివే దీనిని చేయలేవు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ఇప్పుడు నా మాట విను, నేను నీకొక సలహా ఇస్తాను, దేవుడు నీకు తోడుగా ఉండును గాక. నీవు దేవుని ఎదుట ప్రజల ప్రతినిధిగా ఉండి, వారి వివాదాలను ఆయన దగ్గరకు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ఆయన శాసనాలను సూచనలను నీవు వారికి బోధించి, వారు జీవించాల్సిన మార్గాన్ని వారికి చూపించు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","దేవునికి భయపడే, అన్యాయపు లాభాన్ని అసహ్యించుకునే, నమ్మదగిన సామర్థ్యం కలిగిన పురుషులను ప్రజలందరిలో నుండి ఎంపికచేయాలి. తర్వాత వారిని వేయిమందికి, వందమందికి, యాభైమందికి, పదిమందికి ఒక అధికారి ప్రకారం అధికారులుగా నియమించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","వారు అన్ని వేళలా ప్రజలకు న్యాయాధిపతులుగా ఉండాలి, కాని ప్రతీ కఠిన సమస్యను నీ దగ్గరకు తీసుకువచ్చేలా చూడు, మామూలు సమస్యల విషయంలో వారే నిర్ణయించవచ్చు. ఈ విధంగా చేస్తే వారు నీతో పాటు నీ భారాన్ని పంచుకుంటారు, కాబట్టి నీకు భారం తగ్గుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ఒకవేళ నీవు ఇలా చేస్తే, దేవుడు అలాగే ఆజ్ఞాపిస్తే, నీవు ఈ ఒత్తిడిని తట్టుకోగలుగుతావు, అలాగే ఈ ప్రజలందరు కూడా సమాధానంగా తమ ఇళ్ళకు వెళ్తారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","మోషే తన మామ చెప్పిన సలహా విని అతడు చెప్పినట్లే చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","అతడు ఇశ్రాయేలీయులందరిలో సమర్థవంతులైన వారిని ఎంపికచేసి వారిని ప్రజల మీద అధికారులుగా, వేయిమందికి, వందమందికి, యాభైమందికి, పదిమందికి ఒక అధికారి ప్రకారం అధికారులుగా నియమించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","వారు అన్ని వేళలా ప్రజలకు న్యాయాధిపతులుగా సేవ చేశారు. కఠిన సమస్యలను వారు మోషే దగ్గరకు తీసుకువచ్చేవారు, కాని మామూలు వాటి విషయంలో వారే నిర్ణయించేవారు. ");
INSERT INTO telotsa_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","తర్వాత మోషే తన మామను అతని మార్గంలో పంపించాడు, యెత్రో తిరిగి తన స్వదేశానికి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ఇశ్రాయేలీయులు ఈజిప్టు నుండి బయటకు వచ్చిన మూడవ నెల మొదటి రోజున వారు సీనాయి అరణ్యానికి వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","వారు రెఫీదీము నుండి బయలుదేరిన తర్వాత, వారు సీనాయి ఎడారిలో ప్రవేశించారు, అక్కడ పర్వతం ఎదురుగా ఇశ్రాయేలీయులు బసచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","తర్వాత మోషే దేవుని దగ్గరకు ఎక్కి వెళ్లగా, ఆ పర్వతం నుండి యెహోవా అతన్ని పిలిచి, “యాకోబు వంశస్థులకు నీవు చెప్పాల్సింది, ఇశ్రాయేలు ప్రజలకు నీవు చెప్పాల్సింది ఇదే: ");
INSERT INTO telotsa_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘నేను ఈజిప్టుకు ఏమి చేశానో, గ్రద్ద రెక్కల మీద మోసినట్లు నేను మిమ్మల్ని నా దగ్గరకు తెచ్చుకున్నది మీరే స్వయంగా చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","మీరిప్పుడు నాకు పూర్తిగా లోబడి నా ఒడంబడికను పాటిస్తే, అన్ని దేశాల్లో మీరు నా విలువైన ఆస్తి అవుతారు. ఈ భూమి అంతా నాదే అయినా, ");
INSERT INTO telotsa_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","మీరు నాకు ఒక యాజకుల రాజ్యంగా పరిశుద్ధ జనంగా ఉంటారు.’ నీవు ఇశ్రాయేలీయులతో చెప్పాల్సిన మాటలు ఇవే” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","మోషే తిరిగివెళ్లి ప్రజల పెద్దలను పిలిపించి యెహోవా తనకు ఆజ్ఞాపించి చెప్పమన్న మాటలన్నీ వారికి తెలియచేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ప్రజలంతా కలిసి స్పందించి, “యెహోవా చెప్పిందంతా మేము చేస్తాము” అని అన్నారు. అప్పుడు మోషే వారి సమాధానాన్ని యెహోవా దగ్గరకు తీసుకెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","అప్పుడు యెహోవా మోషేతో, “నేను నీతో మాట్లాడడం ప్రజలు విని నీ మీద ఎప్పటికీ వారు నమ్మకం ఉంచేలా, నేను దట్టమైన మేఘంలో నీ దగ్గరకు వస్తాను” అని అన్నారు. అప్పుడు మోషే ప్రజలు చెప్పిన మాటలు యెహోవాకు చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","యెహోవా మోషేతో, “నీవు ప్రజల దగ్గరకు వెళ్లి ఈ రోజు రేపు వారిని ప్రతిష్ఠించు. వారు తమ వస్త్రాలను ఉతుక్కుని, ");
INSERT INTO telotsa_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","మూడవరోజున సిద్ధంగా ఉండాలి, ఎందుకంటే ఆ రోజు ప్రజలందరి కళ్ళెదుట యెహోవా సీనాయి పర్వతం మీదికి దిగివస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","నీవు పర్వతం చుట్టూ ప్రజలకు సరిహద్దు ఏర్పాటు చేసి ప్రజలతో, ‘మీరు ఎవరు పర్వతం దగ్గరకు రాకూడదు దాని అంచును తాకకూడదు. ఎవరైనా ఆ పర్వతాన్ని తాకితే వారు చంపబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ఎవరైనా తమ చేతులతో ముట్టుకుంటే వారు బాణాలతో గుచ్చబడి లేదా రాళ్లతో కొట్టబడి చంపబడాలి; తాకింది మనిషైనా ఒక జంతువైనా చంపబడాలి’ అని చెప్పాలి. పొట్టేలు కొమ్ము బూర శబ్దం సుదీర్ఘంగా విన్నప్పుడు వారు పర్వతం దగ్గరకు రావాలి” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","మోషే పర్వతం నుండి దిగి ప్రజల దగ్గరకు వెళ్లి వారిని పవిత్రపరిచాడు. వారు తమ వస్త్రాలను ఉతుక్కున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","అప్పుడు మోషే ప్రజలతో, “మూడవరోజుకు మిమ్మల్ని మీరు సిద్ధపరచుకోండి. లైంగిక సంబంధాలు పెట్టుకోకూడదు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","మూడవ రోజు ఉదయం ఆ పర్వతం మీద దట్టమైన మేఘంతో ఉరుములు మెరుపులు పెద్ద శబ్దంతో బూరధ్వని వినిపించింది. అప్పుడు ఆ శిబిరంలో ఉన్న ప్రజలంతా వణికిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","అప్పుడు దేవుని కలుసుకోడానికి మోషే ప్రజలను శిబిరం బయటకు నడిపించగా, వారు పర్వతం అంచున నిలబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","యెహోవా అగ్నితో సీనాయి పర్వతం మీదికి దిగి వచ్చారు కాబట్టి ఆ పర్వతమంతా పొగతో నిండిపోయింది. కొలిమి నుండి పొగ వచ్చినట్లుగా ఆ పొగ పైకి లేచింది. ఆ పర్వతమంతా భయంకరంగా కంపించింది. ");
INSERT INTO telotsa_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","బూరధ్వని అంతకంతకు అధికమయ్యింది, మోషే మాట్లాడుతుండగా దేవుని స్వరం అతనికి జవాబిస్తున్నది. ");
INSERT INTO telotsa_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","సీనాయి పర్వత శిఖరం మీదికి యెహోవా దిగివచ్చి ఆ పర్వత శిఖరం మీదికి రమ్మని మోషేను పిలువగా మోషే పర్వతం పైకి ఎక్కి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","అప్పుడు యెహోవా మోషేతో, “నీవు క్రిందకు దిగివెళ్లి, ప్రజలు యెహోవాను చూడాలని హద్దులు దాటివచ్చి వారిలో అనేకమంది నశించిపోకుండా వారిని హెచ్చరించు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","యెహోవాను సమీపించే యాజకులు సహితం, తమను తాము ప్రతిష్ఠించుకోవాలి లేకపోతే యెహోవా వారిపై విరుచుకుపడతారు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","అప్పుడు మోషే యెహోవాతో, “ప్రజలు సీనాయి పర్వతం ఎక్కి రాలేరు, ఎందుకంటే ‘పర్వతం చుట్టూ సరిహద్దులు ఏర్పరచి దానిని పరిశుద్ధంగా ఉంచాలి’ అని మీరే మాకు ఆజ్ఞాపించారు” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","అందుకు యెహోవా, “నీవు క్రిందకు దిగివెళ్లి నీతో పాటు అహరోనును పైకి తీసుకురా. అయితే యాజకులు గాని ప్రజలు గాని యెహోవా దగ్గరకు రావడానికి హద్దులు దాటకూడదు, లేకపోతే ఆయన వారికి వ్యతిరేకంగా విరుచుకుపడతారు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","కాబట్టి మోషే ప్రజల దగ్గరకు దిగివెళ్లి ఆ మాటలు వారితో చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","తర్వాత దేవుడు ఈ మాటలన్నీ మాట్లాడారు: ");
INSERT INTO telotsa_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“బానిస దేశమైన ఈజిప్టు నుండి మిమ్మల్ని బయటకు రప్పించిన మీ దేవుడనైన యెహోవాను నేనే. ");
INSERT INTO telotsa_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“నేను తప్ప వేరొక దేవుడు మీకు ఉండకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","పైన ఆకాశంలో గాని, క్రింద భూమిమీద గాని భూమి క్రింద నీళ్లలో గాని ఉన్న దేని రూపంలో మీరు మీకోసం ప్రతిమను చేసుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","మీరు వాటికి నమస్కరించకూడదు పూజింపకూడదు; ఎందుకంటే నేను, మీ దేవుడనైన యెహోవాను, రోషం గల దేవుడను, నన్ను ద్వేషించినవారి విషయంలో మూడు నాలుగు తరాల వరకు తండ్రుల పాపం యొక్క శిక్షను వారి పిల్లల మీదికి రప్పిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","అయితే నన్ను ప్రేమించి నా ఆజ్ఞలను పాటించే వారికి వెయ్యి తరాల వరకు కరుణను చూపిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","మీ దేవుడైన యెహోవా నామాన్ని అనవసరంగా ఉపయోగించకూడదు, ఎందుకంటే తన నామాన్ని అనవసరంగా ఉపయోగించే వారిని యెహోవా నిర్దోషులుగా వదిలేయరు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","సబ్బాతు దినాన్ని పరిశుద్ధంగా పాటించడం జ్ఞాపకముంచుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ఆరు రోజులు మీరు కష్టపడి మీ పని అంతటిని చేసుకోవాలి, ");
INSERT INTO telotsa_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","కాని ఏడవ రోజు మీ దేవుడైన యెహోవాకు సబ్బాతు దినము. ఆ రోజు మీరు ఏ పని చేయకూడదు, మీరు గాని, మీ కుమారుడు లేదా కుమార్తె గాని, మీ దాసదాసీలు గాని, మీ పశువులు గాని, మీ పట్టణాల్లో ఉంటున్న విదేశీయులు గాని ఏ పని చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ఎందుకంటే ఆరు రోజుల్లో యెహోవా ఆకాశాలను, భూమిని, సముద్రాన్ని, వాటిలో ఉన్న సమస్తాన్ని సృజించి, ఏడవ రోజు ఆయన విశ్రాంతి తీసుకున్నారు. కాబట్టి యెహోవా సబ్బాతు దినాన్ని ఆశీర్వదించి దానిని పరిశుద్ధం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","మీ దేవుడైన యెహోవా మీకు ఇచ్చే దేశంలో మీరు ఎక్కువకాలం జీవించేలా మీ తండ్రిని తల్లిని గౌరవించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","మీరు హత్య చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","మీరు వ్యభిచారం చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","మీరు దొంగతనం చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","మీ పొరుగువారికి వ్యతిరేకంగా అబద్ధసాక్ష్యం చెప్పకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","మీ పొరుగువాని ఇంటిని మీరు ఆశించకూడదు. మీ పొరుగువాని భార్యను గాని, అతని దాసుని గాని దాసిని గాని, అతని ఎద్దును గాని గాడిదను గాని, మీ పొరుగువానికి చెందిన దేన్ని మీరు ఆశించకూడదు.” ");
INSERT INTO telotsa_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ప్రజలు ఆ ఉరుములు మెరుపులు చూసి బూరధ్వని విని పర్వతం నుండి వస్తున్న పొగను చూసి, వారు భయంతో వణికారు. వారు దూరంగా నిలబడి ");
INSERT INTO telotsa_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","మోషేతో, “నీవు మాతో మాట్లాడు మేము వింటాము. మాతో దేవుడు నేరుగా మాట్లాడవద్దు లేదా మేము చనిపోతాం” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","అందుకు మోషే ప్రజలతో, “భయపడకండి. మిమ్మల్ని పరీక్షించడానికి దేవుడు వచ్చారు, తద్వార మీరు పాపం చేయకుండా దేవుని భయం మీలో ఉంటుంది” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","దేవుడున్న ఆ కటికచీకటిని మోషే సమీపిస్తూ ఉండగా ప్రజలు దూరంగా ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","తర్వాత యెహోవా మోషేతో, “ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘నేను పరలోకం నుండి మీతో మాట్లాడడం మీరే చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","మీరు నాతో పాటు దేన్ని దేవుళ్ళుగా చేసుకోకూడదు; మీ కోసం వెండి దేవుళ్ళను గాని బంగారు దేవుళ్ళను గాని మీరు చేసుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘నా కోసం మట్టితో బలిపీఠం తయారుచేసి దానిపై మీ దహనబలులను, సమాధానబలులను, మీ గొర్రెలను పశువులను అర్పించాలి. నేను ఎక్కడ నా పేరును ఘనపరచబడేలా చేసిన, నేను మీ దగ్గరకు వచ్చి మిమ్మల్ని ఆశీర్వదిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ఒకవేళ మీరు నా కోసం రాళ్లతో బలిపీఠం కడితే, దానిని చెక్కిన రాళ్లతో కట్టవద్దు, ఎందుకంటే వాటిపైన మీరు పనిముట్టు ఉపయోగిస్తే అది అపవిత్రం అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","నా బలిపీఠం దగ్గరకు మెట్లు ఎక్కి వెళ్లవద్దు, ఎందుకంటే మీ లోపలి అవయవాలు కనబడతాయి.’ ");
INSERT INTO telotsa_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“నీవు వారి ఎదుట ఉంచవలసిన చట్టాలు ఇవే: ");
INSERT INTO telotsa_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“ఒకవేళ నీవు హెబ్రీ దాసులను కొంటే, వారు ఆరు సంవత్సరాలు నీకు సేవ చేయాలి. ఏడవ సంవత్సరంలో, ఏమి చెల్లించనవసరం లేకుండానే, వారు స్వేచ్ఛగా వెళ్లిపోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","అతడు వచ్చినప్పుడు ఒంటరిగా వచ్చియుంటే ఒంటరిగానే వెళ్లిపోవాలి; ఒకవేళ అతడు వచ్చినప్పుడు అతని భార్యతో వచ్చియుంటే, ఆమె తన భర్తతో వెళ్లిపోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ఒకవేళ వాని యజమాని వానికి భార్యను ఇస్తే ఆమె వానికి కుమారులను లేదా కుమార్తెలను కంటే, వాడు మాత్రమే స్వతంత్రునిగా వెళ్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“కాని ఒకవేళ దాసుడు, ‘నాకు నా యజమాని మీద, నా భార్య మీద నా పిల్లల మీద ప్రేమ ఉంది కాబట్టి నేను స్వతంత్రునిగా వెళ్లను’ అని అంటే, ");
INSERT INTO telotsa_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","వాని యజమాని వానిని దేవుని ఎదుటకు తీసుకురావాలి. వాని యజమాని వానిని తలుపు దగ్గరకు గాని ద్వారబంధం దగ్గరకు గాని తీసుకెళ్లి వాని చెవిని కదురుతో గుచ్చాలి. అప్పుడు వాడు వాని యజమానికి జీవితకాల దాసునిగా ఉంటాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ఒకవేళ ఒకడు తన కుమార్తెను దాసిగా అమ్మివేస్తే, ఆమె ఒక దాసుడు వెళ్లినట్లుగా స్వతంత్రంగా వెళ్లకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","కావాలని ఆమెను ఎన్నుకున్న యజమానిని ఆమె సంతోషపెట్టలేకపోతే, అతడు ఆమెను విడిపించబడనివ్వాలి. అతడు ఆమెను విదేశీయులకు అమ్మడానికి అతనికి అధికారం లేదు, ఎందుకంటే అతడు ఆమె నమ్మకాన్ని వమ్ముచేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ఒకవేళ అతడు ఆమెను తన కుమారుని కోసం ఎంపికచేస్తే, ఆమెకు ఒక కుమార్తెకు ఇచ్చే హక్కు ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","అతడు మరొక స్త్రీని పెళ్ళి చేసుకుంటే, మొదటి భార్యకు ఆహారం, బట్టలు, దాంపత్య హక్కులు లేకుండ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","అతడు ఈ మూడింటిని ఆమెకు సమకూర్చకపోతే, ఆమె డబ్బు ఏమి చెల్లించకుండ, స్వతంత్రురాలిగా వెళ్లిపోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ఎవరైనా చావు దెబ్బతో ఒక వ్యక్తిని కొడితే వారికి మరణశిక్ష విధించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","అయినప్పటికీ, ఒకవేళ అది ఉద్దేశపూర్వకంగా కాక, దేవుడు దానిని జరగనిస్తే, వారు నేను నియమించే స్థలానికి పారిపోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","అయితే ఒకవేళ ఎవరైనా ఎవరినైన కావాలని కుట్రచేసి చంపితే, ఆ వ్యక్తిని నా బలిపీఠం దగ్గర నుండి ఈడ్చుకు వెళ్లి చంపివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ఎవరైనా తన తండ్రి మీద గాని తల్లి మీద గాని దాడి చేస్తే వారికి మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ఎవరైనా ఎవరినైనా ఎత్తుకెళ్లిన తర్వాత ఒకవేళ అమ్మివేయబడినా లేదా వారి దగ్గరే ఉన్నా, ఎత్తుకెళ్లిన వారికి మరణశిక్ష విధించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ఎవరైనా తన తండ్రిని గాని తల్లిని గాని శపిస్తే వారికి తప్పక మరణశిక్ష విధించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ఒకవేళ ప్రజలు జగడమాడుతూ ఒక వ్యక్తి ఇంకొకరిని రాయితో గాని పిడికిలితో గాని కొడితే బాధితుడు చావకపోవచ్చు కాని మంచానికి పరిమితమై, ");
INSERT INTO telotsa_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","తర్వాత అతడు లేచి చేతికర్ర సహాయంతో బయట తిరుగుతూ ఉంటే కొట్టినవానికి శిక్ష విధించబడదు; కాని ఆ కొట్టినవాడు గాయపడిన వ్యక్తికి ఆ సమయంలో కలిగిన నష్టానికి నష్టపరిహారం చెల్లించి ఆ బాధితుడు పూర్తిగా బాగుపడేలా చూడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ఎవరైనా తమ దాసుని గాని దాసిని గాని కర్రతో కొట్టినప్పుడు ఒకవేళ వారు చనిపోతే కొట్టినవారు శిక్షించబడాలి, ");
INSERT INTO telotsa_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","కాని ఒకవేళ వారు ఒకటి లేదా రెండు రోజుల్లో కోలుకుంటే, ఆ దాసులు వారి ఆస్తియే కాబట్టి వారు శిక్షించబడనక్కర్లేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ఒకవేళ ప్రజలు పోట్లాడుకుంటూ గర్భవతియైన స్త్రీని కొట్టినప్పుడు ఆమె అకాల జన్మనిస్తే ఆమెకు గర్భస్రావమై మరి ఏ ఇతర గాయాలు కాకపోతే, దానికి కారణమైనవాడు ఆమె భర్త అడిగిన నష్టపరిహారాన్ని న్యాయాధిపతులు నిర్ణయించిన ప్రకారం చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","తీవ్రమైన గాయాలు అయినప్పుడు మీరు విధించవలసిన శిక్షలు: ప్రాణానికి ప్రాణం ");
INSERT INTO telotsa_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","కంటికి కన్ను, పంటికి పన్ను, చేతికి చేయి, కాలికి కాలు, ");
INSERT INTO telotsa_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","వాతకు వాత, గాయానికి గాయం, నలిపివేతకు నలిపివేత. ");
INSERT INTO telotsa_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ఒక యజమాని కొట్టడం వలన అతని దాసునికి గాని దాసికి గాని కన్ను పోతే కంటికి కలిగిన నష్టాన్ని బట్టి ఆ యజమాని వారిని స్వతంత్రంగా పోనివ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","యజమాని తన దాసునిది గాని దాసిది గాని పన్ను ఊడగొడితే ఆ పంటికి బదులుగా వారిని స్వతంత్రంగా పోనివ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ఒక ఎద్దు పురుషుని గాని స్త్రీని గాని చనిపోయేంతగా పొడిస్తే ఆ ఎద్దును రాళ్లతో కొట్టి చంపాలి. దాని మాంసం ఎవరూ తినకూడదు. కాని ఆ ఎద్దు యజమాని నిర్దోషి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","అయితే ఎద్దుకు అంతకుముందే స్త్రీని గాని పురుషుని గాని పొడిచే అలవాటు ఉండి, దాని యజమానిని ఈ విషయంలో హెచ్చరించినా అతడు దానిని కట్టి అదుపులో పెట్టకపోవడం చేత ఆ ఎద్దు ఎవరినైనా చంపితే ఆ ఎద్దును రాళ్లతో కొట్టి చంపాలి. దాని యజమానికి మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ఒకవేళ నష్టపరిహారం అడిగితే ఆ యజమాని ఆ నష్టపరిహారాన్ని చెల్లించి తన ప్రాణాన్ని విడిపించుకోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ఆ ఎద్దు కుమారుని గాని కుమార్తెను గాని పొడిచినా ఇదే నియమం వర్తించబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ఎద్దు దాసుని గాని దాసిని గాని పొడిస్తే, దాని యజమాని ముప్పై షెకెళ్ళ వెండిని వారి యజమానికి చెల్లించాలి. ఆ ఎద్దును రాళ్లతో కొట్టి చంపాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ఒకరు గొయ్యిని తెరచి ఉంచడం వలన లేదా గొయ్యి త్రవ్వి దానిని మూయకపోవడం వలన ఎద్దు గాని గాడిద గాని దానిలో పడిపోతే ");
INSERT INTO telotsa_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ఆ గోతి యజమాని వాటి యజమానికి నష్టపరిహారం చెల్లించాలి; చచ్చిన జంతువు గొయ్యి యజమానిదవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ఒకరి ఎద్దు మరొకరి ఎద్దును గాయపరచగా అది చనిపోతే ఆ ఇద్దరు బ్రతికి ఉన్న ఎద్దును అమ్మగా వచ్చిన డబ్బును చచ్చిన ఎద్దును చెరిసగం పంచుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ఆ ఎద్దుకు అంతకుముందే పొడిచే అలవాటు ఉంటే దాని యజమాని దానిని కట్టి అదుపులో పెట్టలేదు కాబట్టి అతడు ఖచ్చితంగా ఎద్దుకు బదులు ఎద్దు ఇవ్వాలి; చచ్చిన ఎద్దు అతనిది అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ఎవరైనా ఎద్దునైన గొర్రెనైన దొంగతనం చేసి దానిని చంపినా లేదా అమ్మినా ఆ ఎద్దుకు బదులు అయిదు ఎద్దులను, ఆ గొర్రెకు బదులు నాలుగు గొర్రెలను నష్టపరిహారంగా ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“రాత్రివేళ దొంగ ఇంట్లోకి చొచ్చుకొని వచ్చి ఒకవేళ దొరికిపోయి చావుదెబ్బలు తింటే కొట్టినవాడు రక్తం కారిన దాన్ని బట్టి అపరాధి కాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","కాని ఒకవేళ సూర్యోదయం తర్వాత ఇది జరిగితే, కొట్టినవాడు రక్తం కారిన దాన్ని బట్టి అపరాధి అవుతాడు. “ఎవరైనా దొంగతనం చేస్తే తప్పక నష్టపరిహారం చెల్లించాలి, కాని వాని దగ్గర ఏమిలేకపోతే, వారి దొంగతనానికి చెల్లించడానికి వారు అమ్మివేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ఒకవేళ దొంగతనానికి గురియైన జంతువు ప్రాణంతో వారి స్వాధీనంలో కనబడితే, అది ఎద్దు గాని గాడిద గాని గొర్రెగాని దానికి రెండింతలు చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ఒకడు తన పశువులను మేపడానికి ఒక పొలంలోగాని ద్రాక్షతోటలో గాని వదిలిపెట్టినప్పుడు ఆ పశువులు వేరొకని పొలంలో మేస్తే అతడు తన పొలంలో నుండి గాని ద్రాక్షతోటలో నుండి గాని మంచివాటిని నష్టపరిహారంగా చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“అగ్ని రాజుకొని ముళ్ళకంపలకు అంటుకున్నందు వల్ల పంట కుప్పలు గాని పొలంలో పైరుగాని లేదా పొలమంతా కాలిపోతే ఆ అగ్నిని అంటించినవాడు నష్టపరిహారం చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ఒకరు తమ డబ్బును గాని వస్తువులను గాని దాచమని తన పొరుగువారికి ఇచ్చినప్పుడు, ఆ వ్యక్తి ఇంట్లోనుండి అవి దొంగతనం చేయబడి ఆ దొంగ దొరికితే వాటికి రెండింతలు వాడు చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ఒకవేళ దొంగ దొరక్కపోతే ఆ ఇంటి యజమాని దేవుని ఎదుటకు హాజరు కావాలి, అప్పుడు వారు అతడు తన పొరుగువాని వస్తువులను తీశాడో లేదో తెలుసుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","అన్యాయంగా సంపాదించిన ఎద్దు, గాడిద, గొర్రె, బట్ట వంటి వాటన్నిటి విషయంలో పోగొట్టుకున్నవాడు వాటిని చూసి, ‘ఇది నాది’ అని చెప్తే వారిద్దరు దేవుని సమక్షానికి తమ సమస్యను తీసుకురావాలి. న్యాయాధికారులు నేరస్థునిగా నిర్ధారించినవాడు ఎదుటివానికి రెట్టింపు పరిహారం చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ఒకరు తన గాడిదనైన ఎద్దునైన గొర్రెనైన కాపాడమని తన పొరుగువానికి ఇచ్చినప్పుడు అది చనిపోయినా లేదా గాయపడినా లేదా ఎవరూ చూడనప్పుడు దాన్ని ఎవరైనా తీసుకెళ్లినా, ");
INSERT INTO telotsa_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","పొరుగువాడు ఆ వ్యక్తి ఆస్తి మీద చేతులు వేయలేదని యెహోవా ఎదుట ప్రమాణం చేయడం ద్వారా వారిద్దరి మధ్య సమస్య పరిష్కరించబడుతుంది. యజమాని దానికి అంగీకరించాలి; నష్టపరిహారం అవసరం లేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","అతని దగ్గర నుండి ఆ జంతువు దొంగతనం చేయబడితే అతడు దాని యజమానికి నష్టపరిహారం చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","దానిని ఏ మృగమేదైనా చీల్చివేస్తే, సాక్ష్యంగా దాని మిగిలిన భాగాలను తీసుకురావాలి, చీల్చబడినదానికి నష్టపరిహారం అవసరం లేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ఎవరైనా తమ పొరుగువాని దగ్గర నుండి ఒక జంతువును బదులు తీసుకున్నప్పుడు దాని యజమాని దాని దగ్గర లేనప్పుడు, అది గాయపడినా లేదా చచ్చినా, బదులు తీసుకున్నవాడు నష్టపరిహారం చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","దాని యజమాని దాని దగ్గరే ఉంటే, బదులు తీసుకున్నవాడు నష్టపరిహారం చెల్లించనవసరం లేదు. ఒకవేళ ఆ జంతువు అద్దెకు తెచ్చినదైతే, దాని అద్దె లోనే నష్టం సరిపెట్టబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“ఒకడు పెళ్ళి నిశ్చయించబడని కన్యను లోబరచుకొని ఆమెతో పడుకుంటే అతడు ఆమెకు కట్నం చెల్లించి ఆమెను తన భార్యగా చేసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ఆమె తండ్రి ఆమెను అతనికి ఇవ్వడానికి అస్సలు ఒప్పుకోకపోతే అతడు కన్యకల కట్నం ప్రకారం డబ్బు చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“మంత్రగత్తెలను బ్రతకనివ్వకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“జంతు సంపర్కం చేసినవారికి మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“యెహోవాకు మాత్రమే కాకుండా మరొక దేవునికి బలి అర్పించేవారు పూర్తిగా నాశనం చేయబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“మీరు ఈజిప్టు దేశంలో విదేశీయులుగా ఉన్నారు; కాబట్టి విదేశీయులను బాధించకూడదు, అణగద్రొక్కకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“విధవరాలిని గాని తండ్రిలేనివారిని గాని బాధపెట్టకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","మీరు వారిని వేధించడం వలన వారు నాకు మొరపెడితే, నేను ఖచ్చితంగా వారి మొర వింటాను. ");
INSERT INTO telotsa_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","నా కోపం రగులుకొని నేను మిమ్మల్ని కత్తితో చంపుతాను; అప్పుడు మీ భార్యలు విధవరాళ్లు అవుతారు మీ పిల్లలు తండ్రిలేనివారవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“మీ మధ్య ఉన్న నా ప్రజల్లో ఎవరైనా అవసరంలో ఉంటే, మీరు వారికి డబ్బు అప్పు ఇస్తే, అప్పులు ఇచ్చేవారిలా ప్రవర్తించకూడదు; వడ్డీ తీసుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","నీ పొరుగువారి పైవస్త్రాన్ని తాకట్టుగా తీసుకుంటే, సూర్యాస్తమయానికి తిరిగి ఇచ్చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ఎందుకంటే రాత్రివేళ కప్పుకోడానికి మీ పొరుగువారికి ఉన్నది అదొక్కటే. అది లేకుండా వారు ఎలా నిద్రపోగలరు? నేను కనికరం గలవాన్ని, కాబట్టి వారు నాకు మొరపెడితే నేను వింటాను. ");
INSERT INTO telotsa_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“మీరు దేవుని దూషించకూడదు; మీ ప్రజల అధికారిని శపించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“మీ ధాన్యాగారాల నుండి, తొట్టెల నుండి అర్పణలు చెల్లించడం ఆలస్యం చేయకూడదు. “ఖచ్చితంగా మీ కుమారులలో మొదటి సంతానాన్ని నాకు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","మీ పశువులు గొర్రెల విషయంలో కూడా అలాగే చేయాలి. వాటిని తల్లి దగ్గర ఏడు రోజుల వరకు ఉంచాలి. ఎనిమిదవ రోజున వాటిని నాకు ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“మీరు నా పరిశుద్ధ ప్రజలుగా ఉండాలి కాబట్టి అడవి మృగాలు చీల్చిన జంతు మాంసాన్ని తినకూడదు; దానిని కుక్కలకు పారవేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“పుకార్లు ప్రచారం చేయకూడదు. అన్యాయపు సాక్షిగా ఉండి దుర్మార్గులకు సహాయం చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“తప్పు చేయడంలో జనాన్ని అనుసరించవద్దు. మీరు ఒక దావాలో సాక్ష్యం ఇచ్చినప్పుడు, జనంతో కలిసి న్యాయాన్ని వక్రీకరించవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","న్యాయం చేసేటప్పుడు పేదవారైనా సరే వారిపట్ల పక్షపాతం చూపకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ఒకవేళ నీ శత్రువు యొక్క ఎద్దు గాని గాడిద గాని తప్పిపోయి తిరుగుతూ నీకు కనబడితే, దానిని తప్పక తిరిగి అప్పగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","నిన్ను ద్వేషించేవారి గాడిద ఒకవేళ అది మోస్తున్న బరువు క్రింద పడివుండడం చూస్తే దానిని అలాగే వదిలేయవద్దు; దానిని లేపడానికి వానికి ఖచ్చితంగా సహాయం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“న్యాయవిషయంలో పేదవారికి అన్యాయంగా తీర్పు తీర్చకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","తప్పుడు ఆరోపణలకు దూరంగా ఉండాలి, అమాయక లేదా నిజాయితీగల వ్యక్తిని చంపవద్దు, ఎందుకంటే నేను దోషులను నిర్దోషిగా ప్రకటించను. ");
INSERT INTO telotsa_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“లంచం తీసుకోకూడదు, ఎందుకంటే లంచం చూసేవారికి గ్రుడ్డితనాన్ని కలిగిస్తుంది, నిర్దోషుల మాటలను వక్రీకరిస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“పరదేశిని అణగద్రొక్కకూడదు; మీరు ఈజిప్టులో విదేశీయులుగా ఉన్నారు కాబట్టి విదేశీయుల జీవితం ఎలా ఉంటుందో మీకే తెలుసు కదా! ");
INSERT INTO telotsa_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ఆరు సంవత్సరాలు మీరు పొలంలో విత్తనాలు విత్తి పంట కోయాలి, ");
INSERT INTO telotsa_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ఏడవ సంవత్సరం ఆ భూమిని దున్నకుండా ఉపయోగించకుండా వదిలేయాలి. అప్పుడు మీ ప్రజల్లో పేదవారు దాని నుండి ఆహారం తీసుకోగా మిగిలింది అడవి జంతువులు తినవచ్చు. మీ ద్రాక్షతోటకు ఒలీవతోటకు ఇలాగే చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ఆరు రోజులు మీ పని చేసుకోండి, కానీ ఏడవ రోజు పని చేయకండి, తద్వారా మీ ఎద్దు, మీ గాడిద విశ్రాంతి తీసుకోవచ్చు, మీ ఇంట్లో జన్మించిన దాసి కుమారుడు, మీ మధ్య నివసించే విదేశీయుడు సేదదీరుతారు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“నేను మీతో చెప్పినవన్నీ జాగ్రత్తగా పాటించండి. మరొక దేవుళ్ళ పేరును ఉచ్చరించకూడదు. అవి మీ నోటి నుండి వినిపించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“సంవత్సరానికి మూడుసార్లు మీరు నాకు పండుగ జరపాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“పులియని రొట్టెల పండుగ జరుపుకోండి; నేను మీకు ఆజ్ఞాపించినట్లు ఏడు రోజులు పులియని రొట్టెలు తినాలి. అబీబు నెలలో నిర్ణీత సమయంలో ఇలా తినండి, ఎందుకంటే ఆ నెలలో మీరు ఈజిప్టు నుండి వచ్చారు. “నా సన్నిధిలో ఎవరూ వట్టి చేతులతో కనిపించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“మీరు మీ పొలంలో విత్తి పండించిన ప్రథమ ఫలాలతో కోత కాల పండుగ చేయాలి. “పొలం నుండి మీ పంటలన్నిటిని కూర్చుకున్న తర్వాత సంవత్సరం చివరిలో పంటకూర్పు పండుగ చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“సంవత్సరానికి మూడుసార్లు మీ పురుషులందరు ప్రభువైన యెహోవా సన్నిధిలో కనబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“పులిసిన దానితో కలిపి నాకు బలి యొక్క రక్తాన్ని అర్పించకూడదు. “నా పండుగ అర్పణల క్రొవ్వును ఉదయం వరకు ఉంచవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“మీ పొలంలో పండిన ప్రథమ ఫలాల్లో శ్రేష్ఠమైన వాటిని మీ దేవుడైన యెహోవా మందిరానికి తీసుకురావాలి. “మేకపిల్లను దాని తల్లిపాలతో వండకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ఇదిగో, మార్గమంతటిలో మిమ్మల్ని కాపాడి నేను సిద్ధం చేసి ఉంచిన చోటికి మిమ్మల్ని తీసుకురావడానికి ఒక దేవదూతను మీకు ముందుగా పంపుతున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ఆయన పట్ల శ్రద్ధ వహించండి, ఆయన చెప్పేది వినండి. ఆయనకు ఎదురు తిరుగవద్దు; నా నామం ఆయనలో ఉంది, కాబట్టి ఆయన మీ తిరుగుబాటును క్షమించరు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","మీరు ఆయన చెప్పేది జాగ్రత్తగా విని నేను చెప్పేవాటన్నిటిని చేస్తే, నేను మీ శత్రువులకు శత్రువుగా ఉంటాను, మిమ్మల్ని వ్యతిరేకించే వారిని వ్యతిరేకిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","నా దూత మీకు ముందుగా వెళ్తూ, అమోరీయుల హిత్తీయుల పెరిజ్జీయుల కనానీయుల హివ్వీయుల యెబూసీయుల దేశానికి మిమ్మల్ని తీసుకువస్తాడు, నేను వారిని నిర్మూలం చేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","మీరు వారి దేవుళ్ళ ముందు సాష్టాంగపడకూడదు వాటిని పూజించకూడదు, వారి ఆచారాలను పాటించకూడదు. మీరు వాటిని కూల్చివేసి వారి పవిత్ర రాళ్లను ముక్కలు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","మీ దేవుడైన యెహోవాను ఆరాధించండి, ఆయన ఆశీర్వాదం మీ ఆహారం మీద నీటి మీద ఉంటుంది. నేను మీ మధ్య నుండి రోగాన్ని తీసివేస్తాను, ");
INSERT INTO telotsa_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","మీ దేశంలో ఏ స్త్రీకి గర్భస్రావం కలుగదు లేదా గొడ్రాలిగా ఉండదు. నేను మీకు సంపూర్ణ జీవితకాలాన్ని ఇస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“మీకు ఎదురయ్యే ప్రతి దేశానికి మీకు ముందుగా నా భయాన్ని పంపించి వారిని గందరగోళంలో పడవేస్తాను. నేను మీ శత్రువులందరిని వెనుతిరిగి పారిపోయేలా చేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","మీ మార్గంలో నుండి హివ్వీయులను కనానీయులను హిత్తీయులను వెళ్లగొట్టడానికి మీకు ముందుగా కందిరీగలను పంపిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","కానీ నేను ఒకే సంవత్సరంలో వారిని తరిమికొట్టను, ఎందుకంటే భూమి నిర్జనమైపోతుంది, అడవి జంతువులు మీకు చాలా ఎక్కువై మీకు హాని కలిగిస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","మీరు అభివృద్ధిచెంది ఆ దేశాన్ని స్వాధీనం చేసుకునేవరకు, కొద్దికొద్దిగా వారిని మీ ఎదుట నుండి వెళ్లగొడతాను. ");
INSERT INTO telotsa_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“ఎర్ర సముద్రం నుండి మధ్యధరా సముద్రం వరకు, అరణ్యం నుండి యూఫ్రటీసు నది వరకు నేను మీకు సరిహద్దులును ఏర్పరుస్తాను. ఆ దేశంలో నివసించే ప్రజలను మీ చేతికి అప్పగిస్తాను, మీరు వారిని మీ ఎదుట నుండి వెళ్లగొడతారు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","వారితో గాని వారి దేవుళ్ళతో గాని ఎలాంటి ఒడంబడిక చేసుకోవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","వారిని మీ దేశంలో నివసింపనివ్వకండి లేదా మీరు నాకు వ్యతిరేకంగా పాపం చేయడానికి వారు కారణమవుతారు, ఎందుకంటే మీరు వారి దేవుళ్ళను సేవించడం ఖచ్చితంగా మీకు ఉరి అవుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","అప్పుడు యెహోవా మోషేతో ఇలా అన్నారు, “నీవు, అహరోను, నాదాబు, అబీహు, ఇశ్రాయేలీయుల పెద్దలలో డెబ్బైమంది యెహోవా దగ్గరకు ఎక్కి వచ్చి దూరం నుండి ఆరాధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","అయితే మోషే ఒక్కడే యెహోవాను సమీపించాలి; ఇతరులు దగ్గరగా రాకూడదు. ప్రజలు అతనితో పైకి ఎక్కి రాకూడదు.” ");
INSERT INTO telotsa_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","మోషే వచ్చి యెహోవా ఆజ్ఞాపించిన వాటన్నిటిని, చట్టాలను ప్రజలకు చెప్పినప్పుడు వారందరు ఏకకంఠంతో, “యెహోవా ఆజ్ఞాపించిన వాటన్నిటిని మేము చేస్తాం” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","అప్పుడు మోషే యెహోవా చెప్పిన వాటన్నిటిని వ్రాశాడు. మరుసటిరోజు ఉదయానే లేచి పర్వతం క్రింద ఒక బలిపీఠాన్ని కట్టి ఇశ్రాయేలీయుల పన్నెండు గోత్రాలను బట్టి పన్నెండు స్తంభాలను నిలబెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","అతడు ఇశ్రాయేలీయులలో యువకులను పంపగా వారు దహనబలులు అర్పించి, యెహోవాకు సమాధానబలులుగా ఎద్దులను వధించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","మోషే వాటి రక్తంలో సగం తీసుకుని గిన్నెల్లో పోసి మిగతా సగం బలిపీఠం మీద చల్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","తర్వాత అతడు ఒడంబడిక గ్రంథాన్ని తీసుకుని ప్రజలకు చదివి వినిపించాడు. అప్పుడు వారు, “యెహోవా ఆజ్ఞాపించినవన్నీ మేము చేస్తాము; వాటికి లోబడి ఉంటాం” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","అప్పుడు మోషే రక్తాన్ని తీసుకుని ప్రజలపై చిలకరించి, “ఈ మాటలన్నిటి ప్రకారం యెహోవా మీతో చేసిన నిబంధన రక్తం ఇదే” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","అప్పుడు మోషే అహరోను, నాదాబు అబీహు, ఇశ్రాయేలీయుల పెద్దలలో డెబ్బైమంది పైకి ఎక్కి వెళ్లి, ");
INSERT INTO telotsa_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ఇశ్రాయేలీయుల దేవుని చూశారు. ఆయన పాదాల క్రింద నిగనిగలాడే నీలమణులతో తయారుచేసిన దారివంటిది ఉంది; అది ఆకాశమంత నిర్మలంగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ఇశ్రాయేలీయుల ఈ నాయకులపై దేవుడు చేయి ఎత్తలేదు; వారు దేవున్ని చూశారు, వారు తిని త్రాగారు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","అప్పుడు యెహోవా మోషేతో, “నీవు పర్వతం ఎక్కి, నా దగ్గరకు వచ్చి ఇక్కడ ఉండు, నీవు వారికి బోధించడానికి నేను రాతిపలకలపై నియమాలను ఆజ్ఞలను వ్రాసి ఇస్తాను” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","మోషే తన సహాయకుడైన యెహోషువతో కలిసి లేచి, మోషే దేవుని పర్వతం పైకి ఎక్కి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","అతడు పెద్దలతో, “మేము మీ దగ్గరకు తిరిగి వచ్చేవరకు మీరు ఇక్కడే ఉండండి. అహరోను హూరులు మీతో ఉన్నారు; ఎవరికైనా సమస్య ఉంటే వారి దగ్గరకు వెళ్లండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","మోషే దేవుని పర్వతం పైకి ఎక్కి వెళ్లినప్పుడు మేఘం దానిని కమ్ముకుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","దేవుని మహిమ సీనాయి పర్వతంమీద నిలిచింది. ఆరు రోజులు మేఘం దానిని కమ్ముకుని ఉంది. ఏడవ రోజు యెహోవా ఆ మేఘంలోనుండి మోషేను పిలిచారు. ");
INSERT INTO telotsa_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ఇశ్రాయేలీయులకు యెహోవా మహిమ ఆ పర్వతం మీద దహించే అగ్నిలా కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","మోషే పర్వతం పైకి ఎక్కి వెళ్లి ఆ మేఘంలోకి ప్రవేశించాడు. అతడు ఆ పర్వతం మీద నలభై పగళ్లు నలభై రాత్రులు ఉన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","యెహోవా మోషేతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“నాకు ఒక అర్పణ తీసుకురావాలి అని ఇశ్రాయేలీయులతో చెప్పు. మనసారా అర్పించే ప్రతిఒక్కరి నుండి నీవు నా కోసం కానుక తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“నీవు వారి దగ్గర నుండి తీసుకోవలసిన కానుకలు ఇవే: “బంగారం, వెండి, ఇత్తడి; ");
INSERT INTO telotsa_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","నీలం ఊదా ఎరుపు రంగుల నూలు, సన్నని నారబట్ట; మేక వెంట్రుకలు; ");
INSERT INTO telotsa_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ఎరుపురంగు వేసిన పొట్టేళ్ల చర్మాలు, మన్నికైన తోలు; తుమ్మకర్ర; ");
INSERT INTO telotsa_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","దీపాలకు ఒలీవనూనె; అభిషేక తైలానికి, సువాసనగల ధూపానికి సుగంధద్రవ్యాలు; ");
INSERT INTO telotsa_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ఏఫోదు మీద, రొమ్ము పతకం మీద పొదగడానికి లేతపచ్చ రాళ్లు, ఇతర రత్నాలు. ");
INSERT INTO telotsa_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“నేను వారి మధ్య నివసించేలా వారు నా కోసం పరిశుద్ధాలయాన్ని నిర్మించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ఈ సమావేశ గుడారాన్ని, దాని అన్ని అలంకరణలను నేను మీకు చూపించే నమూనా వలె చేయండి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“వారు తుమ్మకర్రతో మందసం తయారుచేయాలి. దాని పొడవు రెండున్నర మూరలు, వెడల్పు ఒకటిన్నర మూర, ఎత్తు ఒకటిన్నర మూర ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","లోపల, బయట స్వచ్ఛమైన బంగారంతో పొదిగించి దాని చుట్టూ బంగారు అంచును తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","నాలుగు బంగారు ఉంగరాలు పోతపోయించి ఒకవైపు రెండు మరోవైపు రెండు ఉండేలా దాని నాలుగు కాళ్లకు వాటిని తగిలించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","తర్వాత తుమ్మకర్రతో మోతకర్రలు చేసి వాటిని బంగారంతో పొదిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","మందసాన్ని మోయడానికి ఆ మోతకర్రలను మందసానికి ఇరుప్రక్కల ఉన్న ఉంగరాల్లో దూర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ఈ మందసపు ఉంగరాల్లో మోతకర్రలు అలాగే ఉండాలి; వాటిని తీసివేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","అప్పుడు నేను మీకు ఇచ్చే ఒడంబడిక పలకలను మందసంలో ఉంచండి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“స్వచ్ఛమైన బంగారంతో ప్రాయశ్చిత్త మూతను తయారుచేయాలి; దాని పొడవు రెండున్నర మూరలు, వెడల్పు ఒకటిన్నర మూర ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","తర్వాత సాగగొట్టిన బంగారంతో మూత చివర్లలో రెండు కెరూబులను తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ఒక చివర ఒక కెరూబును మరోచివర రెండవ కెరూబును చేయాలి; మూత మీద దాని రెండు చివర్లలో కెరూబులతో పాటు దానంతటిని ఒకే ముక్కలా చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ఆ కెరూబులు తమ రెక్కలను పైకి చాపి వాటితో ప్రాయశ్చిత్త మూతను కప్పుతూ ఉండాలి. కెరూబుల ముఖాలు ఒకదానికొకటి ఎదురెదురుగా ఉండి ఆ కెరూబుల ముఖాలు ప్రాయశ్చిత్త మూతను చూస్తున్నట్లుగా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ప్రాయశ్చిత్త మూతను పైకెత్తి మందసం మీద ఉంచి మందసంలో నేను మీకిచ్చే ఒడంబడిక పలకలను పెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","అక్కడ, నిబంధన మందసం పైన ఉన్న ఆ ప్రాయశ్చిత్త మూత మీదుగా రెండు కెరూబుల మధ్యలో నుండి, నేను నిన్ను కలుసుకొని ఇశ్రాయేలీయుల కోసం నా ఆజ్ఞలన్నిటిని నీకు ఇస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“తుమ్మకర్రతో ఒక బల్లను చేయాలి. దాని పొడవు రెండు మూరలు, వెడల్పు ఒక మూర, ఎత్తు ఒకటిన్నర మూర ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","దాన్ని స్వచ్ఛమైన బంగారంతో పొదిగించి దాని చుట్టూ బంగారు అంచును చేయించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","అలాగే దాని చుట్టూ బెత్తెడు వెడల్పున చట్రం కూడా చేసి దానిపై బంగారంతో పోతపోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ఆ బల్లకు నాలుగు ఉంగరాలు చేసి వాటిని నాలుగు కాళ్లు ఉన్న నాలుగు మూలల్లో తగిలించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","బల్ల మోయడానికి ఉపయోగించే మోతకర్రలు ఉంచే ఉంగరాలు చట్రానికి దగ్గరగా పెట్టబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","తుమ్మకర్రతో మోతకర్రలు చేసి, వాటికి బంగారు పోతపోసి వాటితో ఆ బల్లను మోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","దాని పళ్లెములు పాత్రలు, పానార్పణలు పోయడానికి ఉపయోగించే బానలు గిన్నెలను స్వచ్ఛమైన బంగారంతో తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","అన్ని వేళలా నా ఎదుట సన్నిధి రొట్టెలను ఈ బల్లమీద ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“స్వచ్ఛమైన బంగారంతో దీపస్తంభం చేయాలి. దాని అడుగు పీఠాన్ని నడిమి భాగాన్ని సుత్తెతో సాగగొట్టాలి, దాని కలశాలు దాని మొగ్గలు దాని పువ్వులు తయారుచేసి వాటితో ఒకే ఖండంలా చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","దీపస్తంభానికి రెండు వైపుల నుండి ఆరు కొమ్మలు; ఒక ప్రక్క మూడు మరొక ప్రక్క మూడు కొమ్మలు విస్తరించి ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ఒక కొమ్మకు మొగ్గలు పువ్వులు ఉన్న బాదం పువ్వును పోలిన మూడు కలశాలు, తర్వాతి కొమ్మకు కూడా అలాగే మూడు కలశాల చొప్పున దీపస్తంభం నుండి విస్తరించివున్న ఆరు కొమ్మలకు అదే విధంగా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","దీపస్తంభం మీద మొగ్గలు పువ్వులు ఉన్న బాదం పువ్వును పోలిన నాలుగు కలశాలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","దీపస్తంభం నుండి విస్తరించి ఉన్న మొదటి జత కొమ్మల క్రింద మొదటి మొగ్గ, రెండవ జత కొమ్మల క్రింద రెండవ మొగ్గ, మూడవ జత కొమ్మల క్రింద మూడవ మొగ్గ చొప్పున ఆరు కొమ్మలకు అమర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","సాగగొట్టబడిన స్వచ్ఛమైన బంగారంతో మొగ్గలు కొమ్మలు దీపస్తంభంతో ఒకే ఖండంగా చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“తర్వాత దాని ఏడు దీపాలు తయారుచేసి దాని ఎదుట భాగం ప్రకాశించేలా వాటిని వెలిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","దాని వత్తులు కత్తిరించే కత్తెరలు, పళ్ళాలను స్వచ్ఛమైన బంగారంతో చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","దీపస్తంభాన్ని దాని ఉపకరణాలను తయారుచేయడానికి ఒక తలాంతు స్వచ్ఛమైన బంగారం ఉపయోగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","పర్వతం మీద నేను నీకు చూపించిన నమూనా ప్రకారమే నీవు వాటిని చేసేలా చూడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“పది తెరలతో సమావేశ గుడారాన్ని తయారుచేయాలి. వాటిని నీలం ఊదా ఎరుపు రంగులతో పేనిన సన్నని నారతో చేసి, వాటిపై చేయితిరిగిన పనివానితో కెరూబులను అల్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","తెరలన్నీ ఇరవై ఎనిమిది మూరల పొడవు నాలుగు మూరల వెడల్పు కలిగి ఒకే కొలతతో ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","అయిదు తెరలను ఒక దానితో ఒకటి కలిపి ఒక్కటిగా చేయాలి; మిగిలిన అయిదింటిని కూడా అలాగే చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ఒక కూర్పులోని తెరల చివర మొదటి తెర అంచుకు నీలి నూలుతో ఉచ్చులు చేయాలి. రెండవ కూర్పులోని బయటి తెర చివర కూడా అలాగే చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ఒక తెరకు యాభై ఉచ్చులు చేసి, ఉచ్చులు ఒకదానికొకటి ఎదురెదురుగా ఉండేలా మరొకదాని తెర అంచుకు యాభై ఉచ్చులు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","తర్వాత యాభై బంగారు గుండీలు తయారుచేసి ఆ గుండీలతో ఆ తెరలను ఒక దానితో ఒకటి కలిపినప్పుడు అది ఒకే సమావేశ గుడారంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“సమావేశ గుడారం పైకప్పుగా ఉండే గుడారం కోసం మేక వెంట్రుకలతో మొత్తం పదకొండు తెరలు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","పదకొండు తెరలన్నీ పొడవు ముప్పై మూరలు, వెడల్పు నాలుగు మూరలు కలిగి ఒకే కొలతతో ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","అయిదు తెరలను ఒకటిగా మిగతా ఆరు తెరలను ఒకటిగా కలపాలి. ఆరవ తెరను గుడారం ముందు భాగంలో మడతపెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","మొదటి కూర్పులోని చివరి తెర అంచున, అలాగే రెండవ కూర్పులోని చివరి తెర అంచున యాభై ఉచ్చులు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","యాభై ఇత్తడి గుండీలు తయారుచేసి ఒకటే గుడారమయ్యేలా ఆ గుండీలను ఆ ఉచ్చులకు తగిలించి కూర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","గుడారపు తెరల అధనపు పొడవు విషయానికొస్తే, మిగిలిన సగం తెర సమావేశ గుడారం వెనుక భాగం దగ్గర క్రిందకు వ్రేలాడి ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","గుడారపు తెరలు ఒక ప్రక్క ఒక మూర మరో ప్రక్క ఒక మూర పొడవు ఉండి, మిగిలిన భాగం సమావేశ గుడారాన్ని కప్పి ఉంచేలా దాని ప్రక్కల మీద వ్రేలాడదీయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","గుడారం కోసం ఎరుపురంగు వేసిన పొట్టేళ్ల చర్మంతో పైకప్పును, దానిపైన మన్నికైన తోళ్లతో పైకప్పు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“సమావేశ గుడారానికి తుమ్మకర్రతో నిలువు పలకలు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ప్రతి చట్రం పొడవు పది మూరలు, వెడల్పు ఒకటిన్నర మూర ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","రెండు కొయ్యమేకులు ఒకదానికొకటి సమాంతరంగా అమర్చాలి. సమావేశ గుడారపు చట్రాలన్నిటిని ఈ విధంగా తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","సమావేశ గుడారపు దక్షిణ వైపుకు ఇరవై చట్రాలు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ప్రతి చట్రానికి క్రింద రెండు కొయ్య మేకులకు రెండు దిమ్మల చొప్పున ఇరవై చట్రాలకు నలభై వెండి దిమ్మలు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","మరోవైపుకు, అంటే సమావేశ గుడారానికి ఉత్తర వైపుకు, ప్రతి చట్రం క్రింద రెండు చొప్పున, ఇరవై చట్రాలు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","నలభై వెండి దిమ్మలు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","పడమర వైపు అంటే సమావేశ గుడారం యొక్క వెనుక వైపు ఆరు చట్రాలు తయారుచేయాలి, ");
INSERT INTO telotsa_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","మూలల కోసం రెండు చట్రాలు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ఈ రెండు మూలల వద్ద అవి క్రింది నుండి పై వరకు రెండింతలు ఉండి ఒకే ఉంగరంలోకి అమర్చబడాలి; రెండూ ఒకేలా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","అక్కడ ఎనిమిది చట్రాలు, ప్రతి చట్రం క్రింద రెండేసి చొప్పున పదహారు వెండి దిమ్మలు ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“అలాగే తుమ్మకర్రతో అడ్డకర్రలు తయారుచేయాలి: సమావేశ గుడారానికి ఒక ప్రక్కన ఉన్న చట్రాలకు అయిదు అడ్డకర్రలు, ");
INSERT INTO telotsa_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","రెండవ వైపున ఉన్నవాటికి అయిదు, సమావేశ గుడారానికి వెనుక వైపున పడమర వైపున ఉన్న చట్రాలకు అయిదు అడ్డకర్రలు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","మధ్య అడ్డకర్ర, చట్రాల మధ్యలో ఈ చివరి నుండి ఆ చివరి వరకు విస్తరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ఆ చట్రాలను బంగారంతో పొదిగించి, అడ్డకర్రలు ఉంచడానికి బంగారు ఉంగరాలు చేయాలి. అలాగే అడ్డకర్రలను కూడా బంగారంతో పొదిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“కొండమీద నీకు చూపించిన నమూనా ప్రకారమే సమావేశ గుడారాన్ని నిలబెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“నీలం ఊదా ఎరుపు రంగుల్లో పేనిన సన్నని నారతో ఒక తెరను చేయించి, నిపుణుడైన పనివానితో దానిమీద కెరూబులను అల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","తుమ్మ చెక్కతో నాలుగు స్తంభాలు చేసి బంగారంతో పొదిగించి నాలుగు వెండి దిమ్మలపై నిలబెట్టిన నాలుగు స్తంభాలకు బంగారు కొక్కేలతో దానిని వ్రేలాడదీయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ఆ తెరను కొలుకుల క్రింద తగిలించి నిబంధన మందసాన్ని ఆ తెర వెనుక ఉంచాలి. ఈ తెర పరిశుద్ధ స్థలాన్ని, అతి పరిశుద్ధ స్థలాన్ని వేరు చేస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","అతి పరిశుద్ధ స్థలంలో నిబంధన మందసం మీద ప్రాయశ్చిత్త మూతను ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","తెర బయట సమావేశ గుడారానికి ఉత్తరం వైపు బల్ల ఉంచి దానికి ఎదురుగా దక్షిణం వైపు దీపస్తంభాన్ని ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“గుడారపు ప్రవేశ ద్వారానికి నీలం, ఊదా ఎరుపు రంగులతో పేనిన సన్నని నారతో బుటా పనితో ఒక తెర తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ఈ తెర కోసం తుమ్మ చెక్కతో అయిదు స్తంభాలు చేసి వాటిని బంగారంతో పొదిగించాలి, అలాగే బంగారు కొక్కేలు చేయాలి. తర్వాత వాటికి అయిదు ఇత్తడి దిమ్మలు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“తుమ్మకర్రతో మూడు మూరల ఎత్తుగల బలిపీఠం కట్టాలి; అది అయిదు మూరల పొడవు అయిదు మూరల వెడల్పుతో చతురస్రంగా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","కొమ్ములు, బలిపీఠం ఒకే భాగంలా ఉండేలా దాని నాలుగు మూలల్లో ప్రతి మూలకు ఒక కొమ్మును చేయాలి. బలిపీఠాన్ని ఇత్తడితో పొదిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","దాని పాత్రలన్నిటిని అంటే బూడిద తొలగించడానికి కుండలు, పారలు, చల్లే గిన్నెలు, ముళ్ళ గరిటెలు, నిప్పు పెనాలను ఇత్తడితో చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","దానికి వలలాంటి ఇత్తడి జాలి తయారుచేసి, ఆ జాలి నాలుగు మూలల్లో ప్రతి మూలకు ఒక ఇత్తడి ఉంగరాన్ని తయారుచేసి, ");
INSERT INTO telotsa_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ఆ జాలి బలిపీఠం మధ్యకు చేరేలా బలిపీఠం గట్టు క్రింది భాగంలో దానిని ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","బలిపీఠం కోసం తుమ్మకర్రతో మోతకర్రలు తయారుచేసి, వాటిని ఇత్తడితో పొదిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","బలిపీఠాన్ని మోసినప్పుడు దాన్ని మోయడానికి ఉపయోగించే మోతకర్రలు దాని రెండు ప్రక్కలా ఉన్న ఉంగరాల్లో దూర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","పలకలను ఉపయోగించి బలిపీఠాన్ని గుల్లగా చేయాలి. కొండమీద నీకు చూపించిన నమూనా ప్రకారమే దాన్ని చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“నీవు సమావేశ గుడారానికి ఆవరణం నిర్మించాలి. దక్షిణం వైపు వంద మూరల పొడవు గల పేనిన సన్నని నార తెరలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","దానికి ఇరవై స్తంభాలు వాటికి ఇరవై ఇత్తడి దిమ్మలు, అలాగే ఆ స్తంభాలకు వెండి కొక్కేలు, బద్దలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ఉత్తరం వైపు కూడా వంద మూరల పొడవు ఉండాలి, ఇరవై స్తంభాలు, ఇరవై ఇత్తడి దిమ్మలు, స్తంభాల మీద వెండి కొక్కేలు, దిమ్మలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“పడమటి వైపున ఆవరణం వెడల్పులో యాభై మూరల తెరలు ఉండాలి, వాటికి పది స్తంభాలు, పది దిమ్మలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","తూర్పు వైపు అనగా సూర్యోదయం వైపు కూడా, ఆవరణం యాభై మూరల వెడల్పు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ప్రవేశ ద్వారానికి ఒక ప్రక్క పదిహేను మూరల పొడవు గల తెరలు, వాటికి మూడు స్తంభాలు వాటికి మూడు దిమ్మలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","అటు ప్రక్కన మూడు స్తంభాలు, మూడు దిమ్మలతో పదిహేను మూరల పొడవు గల తెరలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“ఆవరణం యొక్క ద్వారానికి నీలం ఊదా ఎరుపు రంగుల పేనిన సన్నని నారతో బుటా పనితో చేసిన ఇరవై మూరల పొడవు గల తెర ఉండాలి. దానికి నాలుగు స్తంభాలు వాటికి నాలుగు దిమ్మలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ఆవరణం చుట్టూ ఉన్న స్తంభాలన్నిటికి వెండి బద్దలు కొక్కేలు ఇత్తడి దిమ్మలు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ఆవరణం పొడవు వంద మూరలు వెడల్పు యాభై మూరలు, ఎత్తు అయిదు మూరలు; అవి పేనిన నారతో చేసిన తెరలు వాటికి దిమ్మలు ఇత్తడివి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","సమావేశ గుడారం యొక్క సేవలో వాడబడే ఉపకరణాలన్నీ, వాటి పనులేవైనా, దాని కొరకైన గుడారపు మేకులన్నీ, ఆవరణం కొరకైన వాటితో సహా అన్నీ ఇత్తడివై ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“వెలుగు కోసం దీపాలు వెలుగుతూ ఉండేలా దంచి తీసిన ఒలీవ నూనెను మీ దగ్గరకు తీసుకురావాలని ఇశ్రాయేలీయులకు ఆజ్ఞాపించు. ");
INSERT INTO telotsa_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","సమావేశ గుడారంలో, నిబంధన మందసాన్ని కప్పి ఉంచే తెర బయట, అహరోను, అతని కుమారులు సాయంత్రం నుండి ఉదయం వరకు యెహోవా ఎదుట దీపాలను వెలిగించాలి. ఇది ఇశ్రాయేలీయుల రాబోయే తరాలకు మధ్య నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“నాకు యాజకులుగా సేవ చేయడానికి నీ సోదరుడైన అహరోనును అతని కుమారులైన నాదాబు, అబీహు, ఎలియాజరు, ఈతామారులను ఇశ్రాయేలీయులలో నుండి నీ దగ్గరకు రమ్మని పిలిపించు. ");
INSERT INTO telotsa_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","నీ సోదరుడైన అహరోనుకు గౌరవం, ఘనత కలిగేలా అతని కోసం పవిత్ర వస్త్రాలను కుట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","అహరోను నాకు యాజకునిగా సేవ చేయడానికి, అతడు ప్రతిష్ఠించబడాలి కాబట్టి అతనికి వస్త్రాలను తయారుచేయమని అలాంటి వాటి విషయాల్లో నేను జ్ఞానాన్ని ఇచ్చిన నైపుణ్యంగల పనివారందరికి చెప్పు. ");
INSERT INTO telotsa_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","వారు తయారుచేయవలసిన వస్త్రాలు ఇవే: రొమ్ము పతకం, ఏఫోదు, నిలువుటంగీ, అల్లిన చొక్కా, తలపాగా, నడికట్టు. నాకు యాజకులుగా సేవ చేయడానికి నీ సోదరుడైన అహరోనుకు అతని కుమారులకు ఈ పవిత్ర వస్త్రాలను తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","వారికి బంగారంతో నీలం ఊదా ఎరుపు రంగుల నూలు పేనిన సన్నని నారబట్టను ఉపయోగించమని చెప్పండి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“బంగారం నీలం ఊదా ఎరుపు రంగుల నూలు పేనిన సన్నని నారతో ఏఫోదును తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","అది కదలకుండా ఉండేలా దాని రెండు భుజాల ముక్కలు రెండు మూలల్లో కూర్చబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","నైపుణ్యంగా అల్లబడిన దాని నడికట్టు ఏఫోదుతో ఒకే ముక్కగా బంగారం నీలం ఊదా ఎరుపు రంగుల నూలు పేనిన సన్నని నారతో చేయబడినదై ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","10","“రెండు లేతపచ్చ రాళ్లు తీసుకుని వాటిపై ఇశ్రాయేలు కుమారుల పేర్లు, వారు పుట్టిన క్రమం ప్రకారం ఒక రాయి మీద ఆరు పేర్లు మరొకదాని మీద మిగిలిన ఆరు పేర్లు చెక్కాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ముత్యాలు చెక్కేవారు ముద్రను చెక్కినట్లు ఆ రెండు లేతపచ్చ రాళ్లమీద ఇశ్రాయేలు కుమారుల పేర్లు చెక్కాలి. తర్వాత ఆ రాళ్లను బంగారు జరీ చట్రంలోకి ఎక్కించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","తర్వాత వాటిని ఇశ్రాయేలు కుమారుల జ్ఞాపకార్థ రాళ్లుగా ఏఫోదు భుజాలపై బిగించాలి. యెహోవా ఎదుట జ్ఞాపకంగా అహరోను తన భుజాలమీద ఆ పేర్లను మోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","బంగారు జవలను తయారుచేయాలి ");
INSERT INTO telotsa_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","స్వచ్ఛమైన బంగారంతో ఒక తాడులా రెండు అల్లిన గొలుసులు చేసి, ఆ గొలుసులను జవలకు తగిలించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“నిర్ణయాలు తీసుకోవటానికి హస్త నైపుణ్యంతో కూడిన రొమ్ము పతకం చేయాలి. ఏఫోదును చేసినట్లు దీనిని బంగారం నీలం ఊదా ఎరుపురంగు నూలు పేనిన సన్నని నారతో తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","అది చతురస్రంగా జానెడు పొడవు జానెడు వెడల్పుతో రెండుగా మడత పెట్టబడి ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","దానిపై నాలుగు వరుసల ప్రశస్తమైన రాళ్లు పొదగాలి. మొదటి వరుసలో మాణిక్యం, గోమేధికం, మరకతం; ");
INSERT INTO telotsa_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","రెండవ వరుసలో పద్మరాగం, నీలమణి, సూర్యకాంతం; ");
INSERT INTO telotsa_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","మూడవ వరుసలో గారుత్మతం, యష్మురాయి, ఇంద్రనీలం; ");
INSERT INTO telotsa_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","నాలుగవ వరుసలో పుష్యరాగం, లేతపచ్చ రాళ్లు, సూర్యకాంతమణి ఉండాలి. వాటిని బంగారు చట్రంలో అమర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ఇశ్రాయేలు కుమారుల పేర్లకు ఒక్కొక్కటి చొప్పున పన్నెండు రాళ్లు ఉండాలి, ప్రతిదీ వారిలో ఒక్కొక్క పేరు చొప్పున పన్నెండు గోత్రాల పేర్లు ముద్రలా చెక్కబడి ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“రొమ్ము పతకానికి స్వచ్ఛమైన బంగారంతో ఒక తాడులా అల్లికపనితో గొలుసులు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","రెండు బంగారు ఉంగరాలను చేసి వాటిని రొమ్ము పతకానికి రెండు చివర్లకు తగిలించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","రొమ్ము పతకం చివరిలో ఉన్న ఉంగరాలకు రెండు బంగారు గొలుసులు బిగించి, ");
INSERT INTO telotsa_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","గొలుసుల యొక్క ఇతర చివరలను రెండు జవలకు, ముందు భాగంలో ఉన్న ఏఫోదు యొక్క భుజాలకు జోడించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","రెండు బంగారు ఉంగరాలను తయారుచేసి, వాటిని ఏఫోదు ముందు భాగంలో రొమ్ము పతకానికి లోపలి అంచున ఉన్న రెండు చివర్లకు జోడించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","మరో రెండు బంగారు ఉంగరాలను తయారుచేసి వాటిని ఏఫోదు నడికట్టుకు కొంచెం పైన దాని అతుకు దగ్గరగా ఏఫోదు ముందు భాగంలో రెండు భుజభాగాలకు క్రింది వైపున జోడించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","అప్పుడు రొమ్ము పతకం ఏఫోదు నుండి బయటకు వ్రేలాడకుండా నడికట్టును అంటిపెట్టుకుని ఉండేలా రొమ్ము పతకం యొక్క ఉంగరాలను ఏఫోదు ఉంగరాలకు నీలిరంగు దారంతో కట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“అహరోను పరిశుద్ధ స్థలంలోకి వెళ్లినప్పుడు అతడు తన హృదయం మీద న్యాయవిధాన పతకంలోని ఇశ్రాయేలు కుమారుల పేర్లను నిత్యం యెహోవా సన్నిధిలో జ్ఞాపకంగా మోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","రొమ్ము పతకంలో ఊరీము తుమ్మీము అనే వాటిని ఉంచాలి. అప్పుడు అహరోను యెహోవా సన్నిధికి వెళ్లినప్పుడు అవి అతని రొమ్ము మీద ఉంటాయి. అహరోను యెహోవా సన్నిధిలో తన హృదయం మీద ఇశ్రాయేలీయుల న్యాయవిధానాలను నిత్యం మోస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ఏఫోదు నిలువుటంగీని పూర్తిగా నీలి బట్టతో తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","దాని మధ్యలో తల దూర్చడానికి రంధ్రం ఉండాలి. అది చిరిగిపోకుండా మెడపట్టీలా దాని అంచుల చుట్టూ అల్లికపని చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ఆ వస్త్రం అంచు చుట్టూ నీలం ఊదా ఎరుపు రంగుల నూలుతో దానిమ్మపండ్లు తయారుచేసి, వాటి మధ్య బంగారంతో తయారుచేసిన గంటలను తగిలించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","బంగారు గంటలు దానిమ్మపండ్లు ఒకదాని ప్రక్కన ఒకటిగా వస్త్రం అంచు చుట్టూ ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","అహరోను సేవ చేస్తున్నప్పుడు అతడు దీనిని ఖచ్చితంగా ధరించాలి. అతడు యెహోవా సన్నిధికి పరిశుద్ధాలయంలోకి వెళ్లినప్పుడు బయటకు వచ్చినప్పుడు అతడు చనిపోలేదు అని గ్రహించేలా ఆ గంటల శబ్దం తెలియజేస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“స్వచ్ఛమైన బంగారంతో ఒక కిరీటం తయారుచేసి దాని మీద ముద్రలా ఈ మాటలు చెక్కాలి: పరిశుద్ధత యెహోవాకే. ");
INSERT INTO telotsa_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","దాన్ని తలపాగాకు అతకడానికి దానిని నీలి దారంతో కట్టాలి. అది తలపాగా ముందు భాగంలో ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","అది అహరోను నుదిటిపై ఉంటుంది, ఇశ్రాయేలీయులు ప్రతిష్ఠించే పవిత్ర బహుమతులలో, ఆ బహుమతులు ఏవైనా సరే, వాటిలో ఉన్న అపరాధాన్ని అతడు భరిస్తాడు, అది అహరోను నుదుటిపై నిరంతరం ఉంటుంది, తద్వారా వారు యెహోవాకు అంగీకారంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“సన్నని నారబట్టతో చొక్కా నేయాలి. సన్నని నారబట్టతో తలపాగా తయారుచేయాలి. బుటా పనిగా నడికట్టు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","అహరోను కుమారులకు గౌరవం ఘనతా కలిగేలా చొక్కా నడికట్టు టోపీలను తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","నీవు నీ సోదరుడైన అహరోనుకు అతని కుమారులకు ఈ వస్త్రాలను తొడిగించిన తర్వాత వారిని అభిషేకించి ప్రతిష్ఠించాలి. వారు నాకు యాజకులుగా సేవ చేయడానికి వారిని పవిత్రపరచాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“వారి నగ్నత్వాన్ని కప్పుకోడానికి నడుము నుండి తొడల వరకు నారతో లోదుస్తులు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","అహరోను అతని కుమారులు సమావేశ గుడారంలోకి ఎప్పుడు వెళ్లినా లేదా పరిశుద్ధ స్థలంలో సేవ చేయడానికి ఎప్పుడు బలిపీఠాన్ని సమీపించినా వారు దోషశిక్షను భరించి చావకూడదంటే వారు ఖచ్చితంగా ఆ దుస్తులు ధరించాలి. “ఇది అహరోనుకు అతని కుమారులకు ఇవ్వబడిన నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“వారు నాకు యాజకులుగా సేవ చేసేలా వారిని ప్రతిష్ఠించడానికి నీవు చేయవలసినది ఏంటంటే, ఏ లోపం లేని ఒక కోడెను రెండు పొట్టేళ్లను తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","మెత్తని గోధుమపిండితో పులియని గుండ్రని రొట్టెలు, నూనెతో కలిపిన పులియని పిండితో మందమైన రొట్టెలు, నూనె పూసిన పులియని రొట్టెలు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","వాటిని గంపలో పెట్టి ఆ కోడెను రెండు పొట్టేళ్లతో పాటు సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","తర్వాత అహరోనును అతని కుమారులను సమావేశ గుడారపు ద్వారం దగ్గరకు తీసుకువచ్చి నీటితో వారిని కడగాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ఆ వస్త్రాలను తీసుకుని అహరోను మీద పైవస్త్రం వేసి, ఏఫోదు వస్త్రాన్ని, ఏఫోదును, రొమ్ము పతకాన్ని ధరింపచేయాలి. ఏఫోదును నైపుణ్యంగా అల్లబడిన నడికట్టుతో అతనికి కట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","అతని తలమీద తలపాగాను పెట్టి పవిత్ర చిహ్నాన్ని తలపాగాకు తగిలించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","అభిషేక తైలాన్ని తీసుకుని అతని తలపై పోసి అతన్ని అభిషేకించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","అతని కుమారులను తీసుకువచ్చి చొక్కాలు తొడిగించి ");
INSERT INTO telotsa_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","వారిపై టోపీలు పెట్టాలి. తర్వాత అహరోనుకు, అతని కుమారులకు నడికట్టు కట్టాలి. నిత్య కట్టుబాటు ద్వారా యాజకత్వం వారిదవుతుంది. “ఈ విధంగా అహరోనును అతని కుమారులను ప్రతిష్ఠించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“నీవు సమావేశ గుడారం ఎదుటకు ఎద్దును తీసుకురావాలి, దాని తలపై అహరోను అతని కుమారులు తమ చేతులుంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","సమావేశ గుడారపు ద్వారం దగ్గర యెహోవా సన్నిధిలో ఆ ఎద్దును వధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ఆ ఎద్దు రక్తంలో కొంత తీసుకుని నీ వ్రేలితో బలిపీఠపు కొమ్ముల మీద పూసి మిగిలిన రక్తాన్ని బలిపీఠం అడుగున పోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","కోడె లోపలి అవయవాల మీద ఉన్న క్రొవ్వునంతటిని, కాలేయం మీది క్రొవ్వు, రెండు మూత్రపిండాలు వాటి క్రొవ్వును తీసుకుని బలిపీఠం మీద కాల్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","అయితే కోడెను, దాని చర్మాన్ని దాని మాంసాన్ని, దాని పేడను శిబిరం బయట కాల్చివేయాలి. అది పాపపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“నీవు పొట్టేళ్లలో ఒకదాని తీసుకురావాలి, దాని తలపై అహరోను అతని కుమారులు తమ చేతులుంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","నీవు పొట్టేలును వధించి దాని రక్తాన్ని బలిపీఠం చుట్టూ చల్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","పొట్టేలును ముక్కలు చేసి, దాని లోపలి అవయవాలను కాళ్లను కడిగి, వాటిని తల ఇతర ముక్కలతో ఉంచి, ");
INSERT INTO telotsa_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ఆ పొట్టేలంతటిని బలిపీఠం మీద కాల్చాలి. అది యెహోవాకు దహనబలి, యెహోవాకు సమర్పించబడిన ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“మరొక పొట్టేలును తీసుకురావాలి, దాని తలమీద అహరోను అతని కుమారులు వారి చేతులుంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","నీవు ఆ పొట్టేలును వధించి, దాని రక్తం కొంత తీసుకుని అహరోను అతని కుమారుల కుడిచెవి అంచుకు, వారి కుడిచేతి బొటన వ్రేలి మీద, కుడికాలు బొటన వ్రేలి మీద పూసి మిగిలిన రక్తాన్ని బలిపీఠం చుట్టూ చల్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","బలిపీఠం మీద నుండి కొంచెం రక్తాన్ని కొంచెం అభిషేక తైలాన్ని తీసుకుని అహరోను మీద అతని వస్త్రాల మీద, అతని కుమారుల మీద వారి వస్త్రాల మీద చిలకరించాలి. అప్పుడు అతడు అతని కుమారులు వారి వస్త్రాలు కూడా పవిత్రం చేయబడతాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“ఆ పొట్టేలు ప్రతిష్ఠితమైనది కాబట్టి దాని క్రొవ్వును క్రొవ్విన దాని తోకను, లోపలి అవయవాలను కాలేయాన్ని క్రొవ్వుతో ఉన్న రెండు మూత్రపిండాలను, కుడి తొడను తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","యెహోవా ఎదుట ఉన్న పులియని రొట్టెల గంపలో నుండి ఒక గుండ్రని రొట్టెను, ఒలీవనూనె కలిపి చేసిన ఒక మందమైన రొట్టెను, పల్చని రొట్టెను తీసుకుని, ");
INSERT INTO telotsa_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","వాటిని అహరోను అతని కుమారుల చేతుల్లో ఉంచాలి. వారు యెహోవా ఎదుట వాటిని పైకెత్తి ప్రత్యేక అర్పణగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","తర్వాత నీవు వారి చేతుల్లో నుండి వాటిని తీసుకుని బలిపీఠం మీద దహనబలితో కలిపి యెహోవాకు ఇష్టమైన సువాసనగల హోమంగా దహించాలి, ఇది యెహోవాకు సమర్పించబడిన హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","అహరోనును ప్రతిష్ఠించడానికి పొట్టేలు రొమ్ము తీసుకుని యెహోవా ఎదుట పైకెత్తి దానిని ప్రత్యేక అర్పణగా అర్పించాలి. అది నీ వాటా అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“అహరోనుకు అతని కుమారులకు చెందిన ప్రతిష్ఠార్పణకు చెందిన పొట్టేలులోని ఆ భాగాలను ప్రతిష్ఠించాలి: ఆడించిన రొమ్ము, సమర్పించబడిన తొడ. ");
INSERT INTO telotsa_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ఇది ఇశ్రాయేలీయుల నుండి అహరోనుకు అతని కుమారులకు చెందవలసిన శాశ్వత వాటా. ఇది ఇశ్రాయేలీయులు అర్పించే సమాధానబలులలో నుండి వారు యెహోవాకు అర్పించే ప్రత్యేక కానుక. ");
INSERT INTO telotsa_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“అహరోను పవిత్ర వస్త్రాలు అతని తర్వాత అతని కుమారులకు చెందుతాయి; వారు అభిషేకించబడడానికి, ప్రతిష్ఠించబడడానికి వాటిని ధరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","అతని తర్వాత యాజకుడయ్యే అతని కుమారుడు పరిశుద్ధ స్థలంలో సేవ చేయడానికి సమావేశ గుడారంలోకి వెళ్లేటప్పుడు ఏడు రోజులు వాటిని ధరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“ప్రతిష్ఠితమైన పొట్టేలును తీసుకుని పవిత్ర స్థలంలో దాని మాంసాన్ని వండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","సమావేశ గుడారపు ద్వారం దగ్గర అహరోను, అతని కుమారులు ఆ పొట్టేలు మాంసాన్ని గంపలోని రొట్టెలతో తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","వారిని ప్రతిష్ఠించడానికి, పరిశుద్ధపరచడానికి ప్రాయశ్చిత్తంగా వేటిని అర్పించారో వాటిని వారు తినాలి. అవి పవిత్రమైనవి కాబట్టి వారు తప్ప ఇతరులెవరు వాటిని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ఒకవేళ ప్రతిష్ఠితమైన పొట్టేలు మాంసం గాని రొట్టెలు గాని ఉదయం వరకు మిగిలి ఉంటే వాటిని కాల్చివేయాలి. అవి పవిత్రమైనవి కాబట్టి వాటిని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“నేను నీకు ఆజ్ఞాపించిన వాటన్నిటిని అహరోను అతని కుమారుల పట్ల జరిగించాలి; ఏడు రోజులు నీవు వారిని ప్రతిష్ఠించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ప్రాయశ్చిత్తం చేయడానికి ప్రతిరోజు ఒక ఎద్దును పాపపరిహారబలిగా అర్పించాలి. బలిపీఠం కోసం ప్రాయశ్చిత్తం జరిగించి బలిపీఠాన్ని శుద్ధి చేయాలి, అలాగే దాన్ని ప్రతిష్ఠించడానికి అభిషేకం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ఏడు రోజులు బలిపీఠం కోసం ప్రాయశ్చిత్తం చేసి దానిని ప్రతిష్ఠించండి. అప్పుడు బలిపీఠం అత్యంత పరిశుద్ధమవుతుంది; దానికి తగిలినవన్ని పరిశుద్ధమవుతాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“నీవు క్రమం తప్పకుండా ప్రతిరోజు బలిపీఠం మీద ఏడాది గొర్రెపిల్లలు రెండు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ఒక గొర్రెపిల్లను ఉదయాన, మరొకదాన్ని సూర్యాస్తమయ వేళ అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","దంచి తీసిన ఒక పావు హిన్ ఒలీవనూనెతో కలిపిన ఒక ఓమెరు నాణ్యమైన పిండిని, ఒక పావు హిన్ ద్రాక్షారసాన్ని పానార్పణగా మొదటి గొర్రెపిల్లతో పాటు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","సాయంకాలం మరొక గొర్రెపిల్లతో కలిపి ఉదయకాలం అర్పించినట్లే భోజనార్పణ, పానార్పణ అర్పించాలి. ఇది యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“యెహోవా ఎదుట సమావేశ గుడారపు ద్వారం దగ్గర రాబోయే తరాలన్ని క్రమంగా నిత్యం ఈ దహనబలిని అర్పించాలి. అక్కడే నేను మిమ్మల్ని కలుసుకొని మీతో మాట్లాడతాను. ");
INSERT INTO telotsa_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","అక్కడే నేను ఇశ్రాయేలీయులను కలుసుకుంటాను; ఆ స్థలం నా మహిమచేత పవిత్రం చేయబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“కాబట్టి నేను సన్నిధి గుడారాన్ని, బలిపీఠాన్ని ప్రతిష్ఠ చేస్తాను, నాకు యాజకులుగా సేవ చేసేందుకు అహరోనును అతని కుమారులను ప్రతిష్ఠ చేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","అప్పుడు నేను ఇశ్రాయేలీయుల మధ్య నివసించి వారికి దేవునిగా ఉంటాను. ");
INSERT INTO telotsa_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","నేను వారి మధ్య నివసించేలా, వారిని ఈజిప్టు నుండి బయటకు తీసుకువచ్చిన వారి దేవుడనైన యెహోవాను నేనేనని వారు తెలుసుకుంటారు. నేను వారి దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“ధూపం వేయడానికి నీవు తుమ్మకర్రతో ఒక వేదిక తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","అది చతురస్రంగా, ఒక మూర పొడవు ఒక మూర వెడల్పు రెండు మూరల ఎత్తు ఉండాలి. దాని కొమ్ములను దానితో ఒకే ఖండంగా ఉండేలా చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","దాని పైభాగానికి, అన్ని ప్రక్కలకు, కొమ్ములకు స్వచ్ఛమైన బంగారు రేకుతో పొదిగించి దాని చుట్టూ బంగారు కడ్డీ చేయించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ఆ కడ్డీ క్రింద ఉన్న బలిపీఠాన్ని మోయడానికి ఉపయోగించే మోతకర్రలను పెట్టడానికి, ఒకదానికొకటి ఎదురుగా ఉండేలా రెండు బంగారు ఉంగరాలు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","తుమ్మకర్రతో మోతకర్రలు చేసి వాటిని బంగారంతో పొదిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ధూపవేదికను నిబంధన మందసాన్ని కాపాడే తెర ముందు పెట్టాలి, ఒడంబడిక పలకల మీద ఉన్న ప్రాయశ్చిత్త మూత ఎదుట దాన్ని ఉంచాలి. అక్కడే నేను నిన్ను కలుసుకుంటాను. ");
INSERT INTO telotsa_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“అహరోను ప్రతిరోజు ఉదయం దీపాలు పెట్టినప్పుడు బలిపీఠం మీద పరిమళ వాసనతో కూడిన ధూపం వేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","సాయంకాలం అహరోను దీపాలను వెలిగించేటప్పుడు దాని మీద మరలా ధూపం వేయాలి. రాబోయే తరాల వరకు యెహోవా ఎదుట నిత్యం ధూపం వేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","నీవు దాని మీద ఇతర ధూపాలను గాని దహనబలిని గాని భోజనార్పణ గాని అర్పించకూడదు, దాని మీద పానార్పణ పోయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","సంవత్సరానికి ఒకసారి అహరోను దాని కొమ్ముల మీద ప్రాయశ్చిత్తం చేయాలి. ఈ వార్షిక ప్రాయశ్చిత్తం రాబోయే తరాల కోసం ప్రాయశ్చిత్త పాపపరిహారబలి రక్తంతో చేయాలి. అది యెహోవాకు అతిపరిశుద్ధమైనది.” ");
INSERT INTO telotsa_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","తర్వాత యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“నీవు ఇశ్రాయేలీయుల జనాభా లెక్కించేటప్పుడు, వారు లెక్కించబడుతున్న సమయంలో ప్రతి ఒక్కరు యెహోవాకు తమ జీవితానికి విమోచన క్రయధనం చెల్లించాలి. అలా చేస్తే నీవు వారిని లెక్కించినప్పుడు ఏ తెగులు వారి మీదికి రాదు. ");
INSERT INTO telotsa_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","లెక్కించబడినవారిలో చేరే ప్రతి ఒక్కరు పరిశుద్ధాలయం యొక్క షెకెల్ ప్రకారం అర షెకెల్ ఇవ్వాలి, దాని బరువు ఇరవై గెరాలు ఉంటుంది. ఈ అర షెకెల్ యెహోవాకు కానుక. ");
INSERT INTO telotsa_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ఇరవై సంవత్సరాలు లేదా అంతకన్నా ఎక్కువ వయస్సు కలిగి లెక్కించబడేవారిలో చేరే వారు యెహోవాకు కానుక ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","మీ ప్రాణాలకు ప్రాయశ్చిత్తం కలగడానికి మీరు యెహోవాకు అర్పణ ఇచ్చినప్పుడు ధనవంతులు అర షెకెల్ కన్నా ఎక్కువ ఇవ్వకూడదు, పేదవారు అర షెకెల్ కన్నా తక్కువ ఇవ్వకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","నీవు ఇశ్రాయేలీయుల దగ్గర నుండి ప్రాయశ్చిత్త డబ్బును తీసుకుని సమావేశ గుడారపు సేవ కోసం ఉపయోగించాలి. మీ ప్రాణాలకు ప్రాయశ్చిత్తం చేయడానికి యెహోవా ఎదుట ఇది ఇశ్రాయేలీయులకు జ్ఞాపకంగా ఉంటుంది.” ");
INSERT INTO telotsa_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“కడుక్కోడానికి నీవు ఒక ఇత్తడి గంగాళాన్ని, దానికి ఇత్తడి పీటని చేసి సమావేశ గుడారానికి బలిపీఠానికి మధ్యలో పెట్టి దానిలో నీళ్లు పోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","దానిలో ఉన్న నీళ్లతో అహరోను అతని కుమారులు తమ చేతులు పాదాలు కడుక్కోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","వారు సమావేశ గుడారంలోకి వెళ్లినప్పుడెల్లా, వారు నీళ్లతో కడుక్కోవాలి, తద్వారా వారు చావరు. అలాగే, వారు యెహోవాకు హోమబలి అర్పించి సేవ చేయడానికి బలిపీఠాన్ని సమీపించినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","తాము చనిపోకుండా ఉండడానికి వారు తమ చేతులు పాదాలు కడుక్కోవాలి. ఇది అహరోనుకు అతని కుమారులకు తర్వాతి తరాలకు నిత్య కట్టుబాటుగా ఉంటుంది.” ");
INSERT INTO telotsa_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","తర్వాత యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“నీవు ఈ శ్రేష్ఠమైన సుగంధద్రవ్యాలు తీసుకోవాలి: పరిశుద్ధాలయం యొక్క షెకెల్ ప్రకారం గోపరసం 500 షెకెళ్ళు, వాసనగల దాల్చిన చెక్క సగం అనగా 250 షెకెళ్ళు, పరిమళ వాసనగల నిమ్మగడ్డి నూనె 250 షెకెళ్ళు ");
INSERT INTO telotsa_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","లవంగపట్ట 500 షెకెళ్ళు, అయిదు శేర్ల ఒలీవనూనె; అన్నీ పరిశుద్ధాలయం యొక్క షెకెల్ ప్రకారం తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","వాటిని పవిత్ర అభిషేక తైలంగా, పరిమళద్రవ్యాలు చేసేవాని పనిలా పరిమళ మిశ్రమం చేయాలి. అది పవిత్ర అభిషేక తైలం అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ఆ అభిషేక తైలంతో సమావేశ గుడారాన్ని, నిబంధన మందసాన్ని, ");
INSERT INTO telotsa_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","బల్లను, దానిమీది ఉపకరణాలను, దీపస్తంభాన్ని, దాని ఉపకరణాలను, ధూపవేదికను, ");
INSERT INTO telotsa_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","దహనబలిపీఠాన్ని, దాని పాత్రలన్నిటిని, గంగాళాన్ని, దాని పీటని అభిషేకించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","మీరు వాటిని పవిత్రం చేయాలి అప్పుడు అవి అత్యంత పరిశుద్ధమవుతాయి; వాటిని తాకిన ప్రతిదీ పరిశుద్ధమవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“నాకు యాజకులుగా సేవ చేయడానికి అహరోనును అతని కుమారులను అభిషేకించి ప్రతిష్ఠించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","నీవు ఇశ్రాయేలీయులతో, ‘ఇది రాబోయే తరాలకు పవిత్రమైన అభిషేక తైలం అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","దానిని సాధారణ మనుష్యుల శరీరంపై పోయకూడదు, ఆ సూత్రాన్ని ఉపయోగించి మరే ఇతర నూనెను తయారుచేయవద్దు. ఇది పవిత్రమైనది, మీరు దానిని పవిత్రంగా పరిగణించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","దాన్ని పోలిన పరిమళద్రవ్యాన్ని తయారుచేసినవారు, యాజకుల మీద కాకుండా ఇతరుల మీద దానిని పోసిన వారు తమ ప్రజల్లో నుండి కొట్టివేయబడాలి’ అని చెప్పు.” ");
INSERT INTO telotsa_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","యెహోవా మోషేతో ఇలా అన్నారు, “నీవు జటామాంసి, గోపిచందనం, గంధం అనే పరిమళద్రవ్యాలను, స్వచ్ఛమైన సాంబ్రాణిని సమభాగాలలో తీసుకుని ");
INSERT INTO telotsa_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","పరిమళద్రవ్యాలను తయారుచేసేవాని పనియైన ధూపం యొక్క సువాసన మిశ్రమాన్ని తయారుచేయాలి. అది ఉప్పుగా, స్వచ్ఛముగా, పవిత్రంగా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","దానిలో కొంచెం పొడిచేసి, సమావేశ గుడారంలో నిబంధన మందసం ముందు ఉంచండి, అక్కడ నేను మిమ్మల్ని కలుస్తాను. అది మీకు అతి పరిశుద్ధమైనదిగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","అదే సూత్రంతో మీ కోసం మరొక ధూపద్రవ్యాలను తయారుచేసుకోవద్దు; అది యెహోవాకు పరిశుద్ధమైనదని పరిగణించండి. ");
INSERT INTO telotsa_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","దాని పరిమళాన్ని ఆస్వాదించడానికి దానిని పోలిన ధూపాన్ని తయారుచేసినవారు వారు తమ ప్రజల్లో నుండి కొట్టివేయబడాలి.” ");
INSERT INTO telotsa_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“చూడు, నేను యూదా గోత్రానికి చెందిన ఊరి కుమారుడును హూరు మనుమడునైన బెసలేలును ఏర్పరచుకొని, ");
INSERT INTO telotsa_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","నేను అతన్ని దేవుని ఆత్మతో జ్ఞానంతో సామర్థ్యంతో అన్ని రకాల నైపుణ్యతలతో నింపాను. ");
INSERT INTO telotsa_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","అతడు బంగారం వెండి ఇత్తడితో కళాత్మక నమూనాలను తయారుచేస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ఇంకా అతడు రాళ్లను చెక్కి అమర్చడం, చెక్క పని చేయడం, అలా అన్ని రకాల చేతిపనులు చేస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","అంతేకాక అతనికి సహాయం చేయడానికి దాను గోత్రానికి చెందిన అహీసామాకు కుమారుడైన ఒహోలీయాబును నేను నియమించాను. ");
INSERT INTO telotsa_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“ప్రత్యక్ష గుడారం, నిబంధన మందసం, దాని మీద ఉండే ప్రాయశ్చిత్త మూత, గుడారంలోని ఇతర ఉపకరణాలు ");
INSERT INTO telotsa_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","బల్ల, దానిమీది ఉపకరణాలు, స్వచ్ఛమైన బంగారపు దీపస్తంభం, దాని ఉపకరణాలు, ధూపవేదిక, ");
INSERT INTO telotsa_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","దహనబలిపీఠం దాని పాత్రలు, ఇత్తడి గంగాళం దాని ఇత్తడి పీట; ");
INSERT INTO telotsa_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","అంతేకాక యాజక సేవ చేసేటప్పుడు ధరించడానికి నేసిన వస్త్రాలు, యాజకుడైన అహరోనుకు పవిత్ర వస్త్రాలు, అలాగే అతని కుమారులకు వస్త్రాలు వారు యాజకులుగా పరిచర్య చేస్తున్నప్పుడు వేసుకోడానికి, ");
INSERT INTO telotsa_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","పరిశుద్ధస్థలం కోసం అభిషేక తైలం, పరిమళ వాసనగల ధూపము. ");
INSERT INTO telotsa_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ఇంకా యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు, ‘మీరు నా సబ్బాతులు ఖచ్చితంగా ఆచరించాలి. నేను మిమ్మల్ని పరిశుద్ధపరచే యెహోవానై యున్నాను అని మీరు తెలుసుకునేలా అది రాబోయే తరాలకు నాకు మీకు మధ్య ఒక గుర్తుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘మీరు సబ్బాతును ఆచరించాలి, ఎందుకంటే అది మీకు పరిశుద్ధమైనది. దానిని అపవిత్రం చేసినవారికి ఖచ్చితంగా మరణశిక్ష విధించాలి; ఆ రోజు ఏ పనైనా చేస్తే చేసినవారు తమ ప్రజల్లో నుండి కొట్టివేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ఆరు రోజులు పని చేయాలి, కాని ఏడవ రోజు యెహోవాకు సబ్బాతు విశ్రాంతి దినం, యెహోవాకు పరిశుద్ధమైనది. సబ్బాతు దినాన ఎవరైనా ఏ పనైనా చేస్తే చేసినవారికి ఖచ్చితంగా మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","రాబోయే తరాలకు నిత్యమైన ఒడంబడికగా ఇశ్రాయేలీయులు సబ్బాతును ఆచరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ఇది నాకు, ఇశ్రాయేలీయులకు మధ్య ఎప్పటికీ ఒక గుర్తులా ఉంటుంది, ఎందుకంటే ఆరు రోజుల్లో యెహోవా ఆకాశాలను భూమిని చేశారు, ఏడవ రోజున ఆయన విశ్రాంతి తీసుకుని సేదదీరారు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","యెహోవా సీనాయి పర్వతం మీద మోషేతో మాట్లాడడం పూర్తి చేసిన తర్వాత, ఆయన ఒడంబడిక పలకలను అనగా దేవుని వ్రేలితో వ్రాయబడిన రాతిపలకలను అతనికి ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","మోషే పర్వతం దిగిరావడానికి ఆలస్యం చేయడం చూసిన ప్రజలు అహరోను చుట్టూ గుమికూడి, అతనితో, “ఈజిప్టులో నుండి మమ్మల్ని బయటకు తీసుకువచ్చిన ఈ మోషే అనే వానికి ఏమి జరిగిందో మాకు తెలియదు కాబట్టి నీవు వచ్చి మాకు ముందు నడవడానికి మాకు దేవుళ్ళను తయారుచేయి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","అందుకు అహరోను, “అయితే మీ భార్యలు మీ కుమారులు మీ కుమార్తెలు ధరించిన బంగారు చెవికమ్మలు తీసి నా దగ్గరకు తీసుకురండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","కాబట్టి ప్రజలందరు తమ చెవికమ్మలు తీసి అహరోను దగ్గరకు తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","అతడు వారు తనకు ఇచ్చిన వాటిని తీసుకుని ఒక సాధనంతో దూడ రూపంలో పోతపోసి ఒక విగ్రహం తయారుచేశాడు. అప్పుడు వారు, “ఓ ఇశ్రాయేలూ, ఈజిప్టులో నుండి మిమ్మల్ని బయటకు రప్పించిన మీ దేవుళ్ళు వీరే” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","అహరోను ఇది చూసి ఆ దూడ ఎదుట ఒక బలిపీఠం కట్టించి, “రేపు యెహోవాకు పండుగ జరుగుతుంది” అని ప్రకటించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","కాబట్టి మరునాడు ప్రజలు ఉదయాన్నే లేచి దహనబలులు సమాధానబలులు అర్పించారు. ఆ తర్వాత ప్రజలు తినడానికి త్రాగడానికి కూర్చుని ఆడడానికి లేచారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","అప్పుడు యెహోవా మోషేతో ఇలా అన్నారు, “నీవు క్రిందికి వెళ్లు, ఈజిప్టులో నుండి నీవు తీసుకువచ్చిన నీ ప్రజలు చెడిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","నేను వారికి ఆజ్ఞాపించిన మార్గం నుండి చాలా త్వరగా తప్పిపోయి ఒక దూడ రూపంలో పోతపోసిన విగ్రహాన్ని తమ కోసం తయారుచేసుకుని దానికి సాష్టాంగపడి బలి అర్పించి, ‘ఇశ్రాయేలూ, ఈజిప్టులో నుండి నిన్ను రప్పించిన నీ దేవుళ్ళు వీరే’ అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“నేను ఈ ప్రజలను చూశాను” అని అంటూ యెహోవా మోషేతో ఇలా అన్నారు, “వారు మొండి ప్రజలు, ");
INSERT INTO telotsa_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","నా కోపం వారి మీద రగులుకొని, నేను వారిని నాశనం చేస్తాను, నీవు నన్ను వదిలేయి. తర్వాత నేను నిన్ను గొప్ప జనంగా చేస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","అయితే మోషే తన దేవుడైన యెహోవా దయ కోసం మొరపెడుతూ, “యెహోవా, మీరు గొప్ప బలముతో బలమైన చేతితో ఈజిప్టులో నుండి రప్పించిన మీ ప్రజల మీద ఎందుకంత కోపం? ");
INSERT INTO telotsa_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","‘వారిని పర్వతాల మధ్య చంపాలని భూమి మీద ఉండకుండా వారిని నాశనం అయ్యేలా కీడు చేయడానికే ఆయన వారిని బయటకు రప్పించారని ఈజిప్టువారు ఎందుకు చెప్పుకోవాలి?’ రగులుతున్న నీ కోపాన్ని విడిచిపెట్టండి; మనస్సు మార్చుకోండి, మీ ప్రజలపై విపత్తును తీసుకురావద్దు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","మీ సేవకులైన అబ్రాహాము ఇస్సాకు ఇశ్రాయేలును జ్ఞాపకం చేసుకోండి, వారికి మీరే స్వయంగా ఇలా ప్రమాణం చేశారు: ‘నేను మీ సంతానాన్ని ఆకాశ నక్షత్రాల్లా అసంఖ్యాకంగా చేసి వారికి ఇస్తానని నేను వాగ్దానం చేసిన ఈ దేశాన్నంతా మీ సంతానానికి ఇస్తాను, అది వారి వారసత్వంగా నిరంతరం ఉంటుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","అప్పుడు యెహోవా మనస్సు మార్చుకొని తన ప్రజలకు తాను తెస్తానని చెప్పిన విపత్తును వారి మీదికి తేలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","మోషే తన చేతులతో రెండు నిబంధన పలకలు పట్టుకుని పర్వతం దిగి వెళ్లాడు. ఆ పలకలకు రెండు వైపులా ముందు వెనుక వ్రాసి ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ఆ పలకలు దేవుని పని; ఆ పలకల మీద చెక్కబడిన వ్రాత దేవుని చేతివ్రాత. ");
INSERT INTO telotsa_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ప్రజలు కేకలు వేస్తున్న శబ్దం యెహోషువ విని మోషేతో, “శిబిరంలో యుద్ధధ్వని వినబడుతుంది” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","మోషే ఇలా జవాబిచ్చాడు: “అది విజయధ్వని కాదు, అపజయధ్వని కాదు; నేను వింటుంది పాడుతున్న ధ్వని.” ");
INSERT INTO telotsa_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","మోషే శిబిరాన్ని సమీపించి ఆ దూడ విగ్రహాన్ని, వారు నాట్యం చేయడాన్ని చూసినప్పుడు అతనికి చాలా కోపం వచ్చి, అతడు తన చేతుల్లో ఉన్న రెండు పలకలను విసిరి, పర్వత అడుగు భాగాన వాటిని ముక్కలు చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","అతడు ఆ ప్రజలు చేసిన దూడ విగ్రహాన్ని తీసుకుని అగ్నిలో కాల్చివేశాడు; తర్వాత అతడు దానిని పొడిచేసి, నీళ్ల మీద చల్లి, ఆ నీళ్లను ఇశ్రాయేలీయులతో త్రాగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","అప్పుడు మోషే అహరోనును, “నీవు వారిని ఇలాంటి ఘోరమైన పాపం చేసేలా నడిపించడానికి ఈ ప్రజలు నిన్ను ఎలా ప్రేరేపించారు?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","అందుకు అహరోను, “నా ప్రభువా, కోప్పడకు, ఈ ప్రజలు చెడుకు ఎంతగా అలవాటుపడ్డారో నీకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","వీరు నన్ను, ‘ఈజిప్టులో నుండి మమ్మల్ని బయటకు తీసుకువచ్చిన ఈ మోషే అనే వానికి ఏమి జరిగిందో మాకు తెలియదు కాబట్టి నీవు వచ్చి మాకు ముందు నడవడానికి మాకు దేవుళ్ళను తయారుచేయి’ అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","అందుకు నేను, ‘ఎవరి దగ్గర బంగారు ఆభరణాలు ఉంటే వారు తీసుకురండి’ అని చెప్పాను. అప్పుడు వారు నాకు బంగారం ఇచ్చారు, నేను దాన్ని అగ్నిలో పడేస్తే, ఈ దూడ అయ్యింది!” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ప్రజలు విచ్చలవిడిగా తిరగడం మోషే చూశాడు. వారి శత్రువుల ముందు నవ్వులపాలయ్యేలా అహరోను వారిని వదిలేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","కాబట్టి మోషే శిబిరం ద్వారం దగ్గర నిలబడి, “యెహోవా పక్షం ఉన్నవారందరు నా దగ్గరకు రండి” అని అన్నాడు. అప్పుడు లేవీయులందరు అతని దగ్గరకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","అతడు వారితో ఇలా చెప్పాడు, “ఇశ్రాయేలీయుల దేవుడైన యెహోవా చెప్పే మాట ఇదే: ‘ప్రతి ఒక్కరు తన కత్తిని తన నడుముకు కట్టుకుని, శిబిరం ఒక ద్వారం నుండి ఇంకొక ద్వారం వరకు వెళ్తూ ప్రతివారు తన సోదరులను స్నేహితులను పొరుగువారిని చంపాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","లేవీయులు మోషే ఆజ్ఞాపించిన ప్రకారం చేశారు; ఆ రోజు సుమారు మూడువేలమంది చనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","అప్పుడు మోషే, “ఈ రోజు, మీరు మీ సొంత కుమారులకు సోదరులకు వ్యతిరేకంగా మిమ్మల్ని మీరు యెహోవా కోసం ప్రత్యేకించుకున్నారు, కాబట్టి ఆయన మిమ్మల్ని ఆశీర్వదించారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ఆ మరునాడు మోషే ప్రజలతో, “మీరు ఘోరమైన పాపం చేశారు. కాని నేను యెహోవా దగ్గరకు ఎక్కి వెళ్తాను; బహుశ మీ పాపాల కోసం నేనేమైనా ప్రాయశ్చిత్తం చేయగలనేమో” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","అప్పుడు మోషే యెహోవా దగ్గరకు తిరిగివెళ్లి, “అయ్యో, ఈ ప్రజలు ఎంతో ఘోరమైన పాపం చేశారు! తమ కోసం బంగారంతో దేవుళ్ళను తయారుచేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","కాని ఇప్పుడు, దయచేసి వారి పాపాలను క్షమించండి, వారిని మీరు క్షమించకపోతే మీరు వ్రాసిన గ్రంథంలో నుండి నా పేరు తుడిచివేయండి” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","అందుకు యెహోవా మోషేకు, “నాకు వ్యతిరేకంగా ఎవరు పాపం చేశారో వారి పేరును నా గ్రంథంలో నుండి కొట్టివేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","నీవు వెళ్లి, నేను నీకు చెప్పిన చోటికి ప్రజలను నడిపించు, నా దూత మీకు ముందుగా వెళ్తాడు. అయితే నేను శిక్ష విధించవలసిన సమయం వచ్చినప్పుడు వారి పాపాలకు వారికి శిక్ష విధిస్తాను” అని సమాధానం ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","అహరోను చేసిన దూడ విగ్రహంతో వారు చేసిన దానిని బట్టి యెహోవా ప్రజలను తెగులుతో మొత్తారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","అప్పుడు యెహోవా మోషేతో, “ఈ స్థలాన్ని విడిచి, నీవు, నీవు ఈజిప్టు నుండి తీసుకువచ్చిన ప్రజలు, నేను అబ్రాహాము, ఇస్సాకు, యాకోబులకు, ‘నేను దాన్ని మీ వారసులకు ఇస్తాను’ అని ప్రమాణం చేసిన దేశానికి వెళ్లండి. ");
INSERT INTO telotsa_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","నేను నా దూతను మీకు ముందుగా పంపి కనానీయులను, అమోరీయులను, హిత్తీయులను, పెరిజ్జీయులను, హివ్వీయులను, యెబూసీయులను వెళ్లగొడతాను. ");
INSERT INTO telotsa_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","పాలు తేనెలు ప్రవహించే దేశానికి వెళ్లండి. అయితే మీరు లోబడని ప్రజలు కాబట్టి నేను మీతో రాను, ఎందుకంటే మార్గం మధ్యలో నేను మిమ్మల్ని అంతం చేస్తానేమో” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ప్రజలు ఈ బాధ కలిగించే మాటలు విన్నప్పుడు, వారు దుఃఖించడం మొదలుపెట్టారు, ఎవరూ ఆభరణాలు ధరించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","యెహోవా మోషేతో ఇలా అన్నారు, “ఇశ్రాయేలీయులతో ఇలా చెప్పు, ‘మీరు లోబడని ప్రజలు. ఒకవేళ నేను ఒక్క క్షణం మీతో కలిసి వెళ్లినా, మిమ్మల్ని అంతం చేయవచ్చు. కాబట్టి మీ ఆభరణాలను తీసివేయండి మిమ్మల్ని ఏం చేయాలో నేను నిర్ణయిస్తాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","కాబట్టి ఇశ్రాయేలీయులు హోరేబు పర్వతం దగ్గర నుండి తమ ఆభరణాలను ధరించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","మోషే గుడారం తీసుకుని శిబిరం బయట కొంత దూరంలో దానిని వేసి, దానికి “సమావేశ గుడారం” అని పేరు పెట్టాడు. యెహోవా దగ్గర విచారణ చేసే ప్రతి ఒక్కరు శిబిరం బయట ఉన్న సమావేశ గుడారానికి వెళ్లేవారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","మోషే గుడారంలోకి వెళ్లినప్పుడెల్లా, ప్రజలంతా వారి గుడారపు ద్వారాల దగ్గర నిలబడి, మోషే ఆ గుడారం లోపలికి వెళ్లేవరకు కనిపెట్టుకుని ఉండేవారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","మోషే ఆ గుడారం లోపలికి వెళ్లగానే, మేఘస్తంభం దిగివచ్చి దాని ద్వారం దగ్గర నిలబడేది, అప్పుడు యెహోవా మోషేతో మాట్లాడేవారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ఆ గుడారపు ద్వారం దగ్గర మేఘస్తంభం నిలబడడం ప్రజలు చూసినప్పుడెల్లా, వారంతా లేచి నిలబడి, ప్రతిఒక్కరు తమ గుడారపు ద్వారం దగ్గర యెహోవాను ఆరాధించేవారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ఒకరు తన స్నేహితునితో మాట్లాడినట్లు యెహోవా మోషేతో ముఖాముఖిగా మాట్లాడేవారు. తర్వాత మోషే శిబిరానికి తిరిగి వచ్చేవాడు, కాని అతని సేవకుడు నూను కుమారుడైన యెహోషువ అనే యువకుడు ఆ గుడారాన్ని విడిచిపెట్టేవాడు కాదు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","మోషే యెహోవాతో, “ ‘ఈ ప్రజలను నడిపించు’ అని మీరు నాకు చెప్తున్నారు, కాని నాతో ఎవరిని పంపుతారో నాకు చెప్పలేదు. ‘నీ పేరుతో సహా నీవు నాకు తెలుసు, నీవు నా దయను పొందావు’ అని మీరు అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ఒకవేళ మీకు నా మీద దయ ఉంటే, నేను మిమ్మల్ని తెలుసుకొని మీ దయ పొందుతూ ఉండేలా మీ మార్గాలను నాకు బోధించండి. ఈ జనులు మీ ప్రజలేనని జ్ఞాపకముంచుకోండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","అందుకు యెహోవా, “నా సన్నిధి నీకు తోడుగా వస్తుంది, నేను నీకు విశ్రాంతి ఇస్తాను” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","అప్పుడు మోషే ఆయనతో, “మీ సన్నిధి మాతో పాటు రాకపోతే మమ్మల్ని ఇక్కడినుండి పంపవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","మీరు మాతో రాకపోతే నా పట్ల మీ ప్రజల పట్ల మీరు కనికరం చూపించారని ఎవరికైనా ఎలా తెలుస్తుంది? ఈ భూమి మీద ఉన్న ఇతర ప్రజల నుండి నన్ను, మీ ప్రజలను ఏది ప్రత్యేకపరుస్తుంది?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","అందుకు యెహోవా మోషేతో, “నీవడిగినట్టే నేను చేస్తాను, ఎందుకంటే నీ మీద నాకు దయ కలిగింది, నీ పేరుతో సహా నీవు నాకు తెలుసు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","అప్పుడు మోషే, “ఇప్పుడు నీ మహిమ నాకు చూపించు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","అందుకు యెహోవా, “నా మంచితనమంతా నీ ఎదుట నుండి దాటిపోయేలా చేస్తాను. యెహోవా అనే నా పేరును నీ ఎదుట ప్రకటిస్తాను. నాకు ఎవరి మీద కనికరం కలుగుతుందో వారిని కనికరిస్తాను, నాకు ఎవరి మీద దయ కలుగుతుందో వారికి నేను దయ చూపిస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","అయితే ఆయన, “నీవు నా ముఖాన్ని చూడలేవు; ఎందుకంటే నన్ను చూసిన మనుష్యులు బ్రతుకరు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","యెహోవా, “నాకు దగ్గరగా ఒక స్థలముంది అక్కడ నీవు బండ మీద నిలబడు. ");
INSERT INTO telotsa_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","నా మహిమ నిన్ను దాటి వెళ్తున్నప్పుడు ఆ బండ సందులో నిన్ను ఉంచి నేను వెళ్లిపోయేవరకు నా చేతితో నిన్ను కప్పుతాను. ");
INSERT INTO telotsa_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","నేను చేయి తీసిన తర్వాత నీవు నా వెనుక భాగం చూస్తావు; కాని నా ముఖం నీకు కనబడదు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","యెహోవా మోషేతో, “మొదటి పలకలవంటి మరో రెండు రాతిపలకలను చెక్కు, నీవు పగులగొట్టిన మొదటి పలకల మీద ఉన్న మాటలనే నేను వాటిపై వ్రాస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","నీవు ఉదయమే సిద్ధపడి, సీనాయి పర్వతం మీదికి రా. ఆ పర్వత శిఖరం మీద నీవు నా ఎదుట నిలబడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","నీతో మరెవరూ రాకూడదు, ఈ పర్వతం మీద ఎవరూ కనపడకూడదు; ఈ పర్వతం దగ్గర పశువులు గాని గొర్రెలు గాని మేయకూడదు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","కాబట్టి మోషే యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం మొదటి వాటిలా రెండు రాతిపలకలను చెక్కి తన చేతులతో ఆ రెండు రాతిపలకలు పట్టుకుని తెల్లవారుజామునే సీనాయి పర్వతం పైకి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","అప్పుడు యెహోవా మేఘంలో దిగివచ్చి అతనితో అక్కడ నిలబడి యెహోవా అనే తన పేరును ప్రకటించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","మోషే ఎదుట నుండి ఆయన దాటి వెళ్తూ, “యెహోవా, దేవుడైన యెహోవా కనికరం దయ కలిగినవారు, త్వరగా కోప్పడరు, ప్రేమ నమ్మకత్వాలతో నిండియున్నవారు, ");
INSERT INTO telotsa_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","వేలాదిమందికి ప్రేమను చూపిస్తూ, దుర్మార్గాన్ని, తిరుగుబాటును, పాపాన్ని క్షమిస్తారు గాని ఆయన దోషులను నిర్దోషులుగా విడిచిపెట్టక, మూడు నాలుగు తరాల వరకు తల్లిదండ్రుల పాపానికి పిల్లలను వారి పిల్లలను శిక్షిస్తారు” అని ప్రకటించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","వెంటనే మోషే నేలవరకు తలవంచి ఆరాధిస్తూ, ");
INSERT INTO telotsa_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“ప్రభువా, నా మీద మీకు దయ కలిగితే, ప్రభువు మాతో పాటు రావాలి. వీరు లోబడని ప్రజలే అయినప్పటికీ, మా దుర్మార్గాన్ని మా పాపాన్ని క్షమించి, మమ్మల్ని మీ స్వాస్థ్యంగా తీసుకోండి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","అందుకు యెహోవా: “నీతో నేను ఒక ఒడంబడిక చేస్తున్నాను. ఈ భూమి మీద ఏ దేశంలో ఎప్పుడూ జరుగని అద్భుతాలు నేను నీ ప్రజలందరి ఎదుట చేస్తాను. నీవు ఏ ప్రజలమధ్య నివసిస్తున్నావో వారందరు యెహోవానైన నేను మీ కోసం చేసే భయంకరమైన కార్యాన్ని చూస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","నేడు నేను మీకు ఆజ్ఞాపించే దానికి లోబడాలి. నేను అమోరీయులు, కనానీయులు, హిత్తీయులు, పెరిజ్జీయులు, హివ్వీయులు, యెబూసీయులను నీ ఎదుట నుండి వెళ్లగొడతాను. ");
INSERT INTO telotsa_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","మీరు వెళ్లబోతున్న దేశంలో నివసిస్తున్న వారితో సంధి చేసుకోకుండ జాగ్రత్తపడండి, లేకపోతే వారు మీ మధ్య ఉరిగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","మీరు వారి బలిపీఠాలను పడగొట్టండి, వారి పవిత్ర రాళ్లను పగులగొట్టండి, వారి అషేరా స్తంభాలను ముక్కలు చేయండి. ");
INSERT INTO telotsa_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","మీరు ఇతర దేవుళ్ళను ఆరాధించకూడదు, ఎందుకంటే రోషం గలవాడని పేరుగల యెహోవా, రోషం గల దేవుడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ఆ దేశంలో నివసిస్తున్న వారితో సంధి చేసుకోకుండ జాగ్రత్తపడండి; ఎందుకంటే వారు తమ దేవుళ్ళతో వ్యభిచరించి వాటికి బలులు అర్పించినప్పుడు, వారు మిమ్మల్ని ఆహ్వానిస్తారు, మీరు ఆ బలులను తింటారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","మీరు మీ కుమారులకు వారి కుమార్తెలను భార్యలుగా చేసుకున్నప్పుడు ఆ కుమార్తెలు తమ దేవుళ్ళతో వ్యభిచరించి మీ కుమారులచేత అదే విధంగా చేయిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ఏ దేవుళ్ళ విగ్రహాలు చేసుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“పులియని రొట్టెల పండుగ జరుపుకోవాలి. ఎందుకంటే నేను మీకు ఆజ్ఞాపించిన ప్రకారం, ఏడు రోజులు మీరు పులియని పిండితో చేసిన రొట్టెలే తినాలి. అబీబు నెలలో నిర్ణీత సమయంలో మీరిలా చేయాలి, ఎందుకంటే ఆ నెలలో మీరు ఈజిప్టు నుండి బయటకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ప్రతి గర్భం యొక్క మొదటి సంతానం నాదే, మీ పశువుల్లో మొదటి సంతానమైన ప్రతి మగపిల్ల అది దూడ గాని, గొర్రెపిల్ల గాని, అది నాకు చెందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","గొర్రెపిల్లను ఇచ్చి మొదటి సంతానమైన గాడిదను విడిపించుకోవాలి, అలా మీరు దాన్ని విడిపించుకోకపోతే, దాని మెడ విరగ్గొట్టాలి. మీ ప్రతి మొదటి మగపిల్లవాన్ని విడిపించుకోవాలి. “నా సన్నిధిలో ఎవరూ వట్టి చేతులతో కనిపించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ఆరు రోజులు మీరు పని చేయాలి, కాని ఏడవ రోజు మీరు విశ్రాంతి తీసుకోవాలి; అది దున్నే కాలమైనా పంట కోసే కాలమైనా సరే మీరు విశ్రాంతి తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“గోధుమపంటలోని ప్రథమ ఫలాలతో వారాల పండుగ ఆచరించాలి, సంవత్సరం చివరిలో పంటకూర్పు పండుగ ఆచరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","సంవత్సరానికి మూడుసార్లు మీ పురుషులందరు ఇశ్రాయేలీయుల దేవుడు ప్రభువైన యెహోవా సన్నిధిలో కనబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","నేను మీ ఎదుట నుండి దేశాలను తరిమివేసి, మీ భూభాగాన్ని విస్తరింపజేస్తాను, మీరు మీ దేవుడైన యెహోవా సన్నిధిలో కనబడడానికి మీరు సంవత్సరానికి మూడుసార్లు పైకి వెళ్లినప్పుడు మీ భూమిని ఎవరూ ఆశించరు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“పులిసిన దానితో కలిపి నాకు బలి యొక్క రక్తాన్ని అర్పించకూడదు, పస్కా పండుగ నుండి ఏ బలికి చెందినది ఏదీ ఉదయం వరకు మిగలకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“మీ పొలంలో పండిన ప్రథమ ఫలాల్లో శ్రేష్ఠమైన వాటిని మీ దేవుడైన యెహోవా మందిరానికి తీసుకురావాలి. “మేకపిల్లను దాని తల్లిపాలతో వండకూడదు.” ");
INSERT INTO telotsa_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","తర్వాత యెహోవా మోషేతో, “ఈ మాటలను వ్రాయి; ఎందుకంటే ఈ మాటలను అనుసరించి నేను నీతో, అలాగే ఇశ్రాయేలీయులతో నిబంధన చేశాను” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","మోషే నలభై రాత్రింబవళ్ళు యెహోవాతో పాటు అక్కడే, ఆహారం తినకుండ నీళ్లు త్రాగకుండ ఉన్నాడు. అతడు నిబంధన మాటలు అనగా పది ఆజ్ఞలు ఆ పలకల మీద వ్రాశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","మోషే తన చేతుల్లో ఆ రెండు నిబంధన పలకలను మోస్తూ సీనాయి పర్వతం దిగివస్తున్నప్పుడు, అతడు యెహోవాతో మాట్లాడాడు కాబట్టి అతని ముఖం ప్రకాశమానంగా ఉందని అతనికి తెలియదు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","అహరోను, ఇశ్రాయేలీయులందరు మోషేను చూసినప్పుడు అతని ముఖం ప్రకాశవంతంగా ఉంది కాబట్టి అతని దగ్గరకు వెళ్లడానికి వారు భయపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","అయితే మోషే వారిని పిలిచాడు; కాబట్టి అహరోను, సమాజ నాయకులు అతని దగ్గరకు తిరిగి వచ్చారు, అతడు వారితో మాట్లాడాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ఆ తర్వాత ఇశ్రాయేలీయులందరు అతని దగ్గరకు రాగా సీనాయి పర్వతం మీద యెహోవా తనకు ఇచ్చిన ఆజ్ఞలన్నిటిని అతడు వారికిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","మోషే వారితో మాట్లాడడం ముగించినప్పుడు తన ముఖం మీద ముసుగు వేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","అయితే మోషే యెహోవాతో మాట్లాడడానికి ఆయన సన్నిధిలోనికి వెళ్లినప్పుడెల్లా బయటకు వచ్చేవరకు అతడు ముసుగు తీసివేసేవాడు. అతడు బయటకు వచ్చి తనకు ఆజ్ఞాపించిన వాటిని ఇశ్రాయేలీయులకు చెప్పేవాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","అప్పుడు అతని ముఖం ప్రకాశించడం ఇశ్రాయేలీయులు చూశారు; మోషే తిరిగి యెహోవాతో మాట్లాడడానికి వెళ్లేవరకు తన ముఖం మీద ముసుగు వేసుకునేవాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","మోషే ఇశ్రాయేలీయుల సమాజమంతటిని సమావేశపరచి వారితో, “మీరు పాటించడానికి యెహోవా ఇచ్చిన ఆజ్ఞలు ఇవే: ");
INSERT INTO telotsa_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ఆరు రోజులు పని చేయాలి, కాని ఏడవ రోజు మీ పరిశుద్ధ దినం, అది యెహోవాకు సబ్బాతు విశ్రాంతి దినము. ఆ రోజు ఎవరు ఏ పని చేసినా వారికి మరణశిక్ష విధించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","సబ్బాతు దినాన మీరు మీ నివాసాల్లో మంట వెలిగించకూడదు.” ");
INSERT INTO telotsa_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","మోషే ఇశ్రాయేలీయుల సమాజమంతటితో, “యెహోవా ఆజ్ఞాపించింది ఇదే: ");
INSERT INTO telotsa_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","మీ దగ్గర ఉన్నదానిలో నుండి యెహోవా కోసం అర్పణ తీసుకురావాలి. ఇష్టపూర్వకంగా యెహోవాకు కానుక తెచ్చే ప్రతి ఒక్కరు ఇవి తీసుకురావలసినవి: “బంగారం, వెండి, ఇత్తడి; ");
INSERT INTO telotsa_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","నీలం ఊదా ఎరుపు రంగుల నూలు సన్నని నారబట్ట; మేక వెంట్రుకలు; ");
INSERT INTO telotsa_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ఎరుపురంగు వేసిన పొట్టేళ్ల చర్మాలు మన్నికైన తోలు; తుమ్మకర్ర; ");
INSERT INTO telotsa_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","దీపాలకు ఒలీవనూనె; అభిషేక తైలానికి సువాసనగల ధూపానికి సుగంధద్రవ్యాలు; ");
INSERT INTO telotsa_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ఏఫోదు మీద, రొమ్ము పతకం మీద పొదగడానికి లేతపచ్చ రాళ్లు, ఇతర రత్నాలు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“మీలో నైపుణ్యం ఉన్నవారు వచ్చి యెహోవా ఆజ్ఞాపించిన ప్రతిదీ తయారుచేయాలి: ");
INSERT INTO telotsa_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“అవేమంటే, సమావేశ గుడారం, దాని గుడారం, దాని పైకప్పు, దాని కొలుకులు, పలకలు, అడ్డకర్రలు, స్తంభాలు, దిమ్మలు; ");
INSERT INTO telotsa_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","మందసం, దాని మోతకర్రలు, ప్రాయశ్చిత్త మూత దానిని కప్పివుంచే తెర; ");
INSERT INTO telotsa_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","బల్ల, దాని మోతకర్రలు, దాని ఉపకరణాలన్నీ, సన్నిధి రొట్టెలు; ");
INSERT INTO telotsa_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","వెలుగు కోసం దీపస్తంభం, దాని ఉపకరణాలు, దీపాలు, వెలిగించడానికి ఒలీవనూనె; ");
INSERT INTO telotsa_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ధూపవేదిక, దాని మోతకర్రలు, అభిషేక తైలం, పరిమళ వాసనగల ధూపం; సమావేశ గుడారపు ద్వారానికి తెర; ");
INSERT INTO telotsa_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","దహనబలిపీఠం దాని ఇత్తడి జల్లెడ, దాని మోతకర్రలు, దాని పాత్రలన్నీ; ఇత్తడి గంగాళం, దాని పీట; ");
INSERT INTO telotsa_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ఆవరణపు తెరలు, దాని స్తంభాలు, దిమ్మలు, ఆవరణ ద్వారానికి తెర; ");
INSERT INTO telotsa_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","సమావేశ గుడారానికి, ఆవరణానికి మేకులు, వాటి త్రాళ్లు; ");
INSERT INTO telotsa_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","పరిశుద్ధాలయంలో పరిచర్య చేయడానికి ధరించే నేసిన వస్త్రాలు; యాజకుడైన అహరోనుకు పవిత్ర వస్త్రాలు, యాజకులుగా సేవ చేస్తున్నప్పుడు అతని కుమారులకు వస్త్రాలు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","అప్పుడు ఇశ్రాయేలీయుల సమాజమంతా మోషే దగ్గరి నుండి వెళ్లి, ");
INSERT INTO telotsa_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ఇష్టపూర్వకంగా ఇవ్వాలనుకున్న ప్రతిఒక్కరు, హృదయాల్లో ప్రేరేపించబడిన ప్రతి ఒక్కరు వచ్చి, సమావేశ గుడారం యొక్క పనుల కోసం, దాని సేవలన్నిటి కోసం, పవిత్ర వస్త్రాల కోసం యెహోవాకు అర్పణలు తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ఇష్టపూర్వకంగా ఇవ్వాలనుకున్న స్త్రీలు పురుషులు వచ్చి, చెవికమ్మలు, వ్రేలి ఉంగరాలు, నగలు, వివిధ రకాల బంగారు ఆభరణాలు తెచ్చి ఆ బంగారాన్ని పైకెత్తి ఆడించి యెహోవాకు ప్రత్యేక అర్పణగా సమర్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","తమ దగ్గర నీలం ఊదా ఎరుపు రంగుల నూలు సన్నని నార మేక వెంట్రుకలు ఎరుపురంగు వేసిన పొట్టేళ్ల చర్మాలు, మన్నికైన తోళ్లు ఉన్నవారు వాటిని తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","వెండిని ఇత్తడిని అర్పించాలనుకున్నవారు వాటిని యెహోవాకు అర్పణగా తెచ్చారు, ఆ పనిలో దేనికైనా ఉపయోగపడే తుమ్మకర్రలు ఉన్న ప్రతిఒక్కరు వాటిని తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","నైపుణ్యం కలిగిన ప్రతి స్త్రీ తమ చేతులతో వడికి తాము వడికిన నీలం ఊదా ఎరుపు రంగుల నూలు లేదా సన్నని నార తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","నైపుణ్యం కలిగి ప్రేరేపించబడిన స్త్రీలందరు మేక వెంట్రుకలను వడికారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","నాయకులు ఏఫోదులో, రొమ్ము పతకంలో పొదగడానికి లేతపచ్చ రాళ్లు, ఇతర రత్నాలు తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","అలాగే దీపాలు వెలిగించడానికి ఒలీవనూనె, అభిషేక తైలానికి, పరిమళ వాసనగల ధూపానికి సుగంధద్రవ్యాలు తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","మోషే ద్వారా యెహోవా వారికి చేయమని ఆజ్ఞాపించిన పనులన్నిటి కోసం ఇశ్రాయేలీయుల స్త్రీలు పురుషులలో ప్రేరేపించబడిన వారందరు ఇష్టపూర్వకంగా యెహోవాకు కానుకలు తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","తర్వాత మోషే ఇశ్రాయేలీయులతో, “చూడండి, యెహోవా యూదా గోత్రానికి చెందిన ఊరి కుమారుడును హూరు మనుమడునైన బెసలేలును ఏర్పరచుకొని, ");
INSERT INTO telotsa_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","33","బంగారం వెండి ఇత్తడితో కళాత్మక నమూనాలను రూపొందించడానికి, రాళ్లను చెక్కి అమర్చడం, చెక్క పని చేయడం వంటి అన్ని రకాల కళాత్మక నైపుణ్యాలతో పని చేయడానికి అతన్ని దేవుని ఆత్మతో జ్ఞానంతో సామర్థ్యంతో తెలివితో అన్ని రకాల నైపుణ్యతలతో నింపారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ఆయన బెసలేలుకు, అలాగే దాను గోత్రానికి చెందిన అహీసామాకు కుమారుడైన ఒహోలీయాబుకు ఇతరులకు నేర్పగల సామర్థ్యాన్ని ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","చెక్కేవారి పని, కళాకారుల పని, నీలం ఊదా ఎరుపు రంగుల నూలు సన్నని నారతో కుట్టుపని, నేతగాని పని, చిత్రకారులు చేయగల అన్ని రకాల పనులను చేయడానికి కావలసిన నైపుణ్యంతో యెహోవా వారిని నింపారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","పరిశుద్ధాలయం యొక్క సేవ కోసం చేయవలసిన అన్ని రకాల పనులు ఎలా చేయాలో తెలుసుకోవడానికి యెహోవా నైపుణ్యాన్ని, సామర్థ్యాన్ని ఇచ్చిన బెసలేలు ఒహోలీయాబు వలె నైపుణ్యం కలిగిన ప్రతి ఒక్కరు యెహోవా ఆజ్ఞాపించిన ప్రకారం పని చేయాలి” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","తర్వాత బెసలేలును ఒహోలీయాబును, యెహోవా సామర్థ్యం ఇచ్చిన వారిని, పని చేయడానికి ప్రేరేపించబడిన వారందరిని మోషే పిలిపించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","పరిశుద్ధాలయ నిర్మాణానికి ఇశ్రాయేలీయులు తెచ్చిన కానుకలన్నిటిని మోషే దగ్గర నుండి వారు తీసుకున్నారు. అయితే ఇశ్రాయేలీయులు ప్రతి ఉదయం స్వేచ్ఛార్పణగా అతని దగ్గరకు కానుకలు తెస్తూనే ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","కాబట్టి పరిశుద్ధాలయం యొక్క పనులన్నిటిని చేస్తున్న నైపుణ్యంగల పనివారంతా తాము చేస్తున్న పని విడిచి వచ్చి, ");
INSERT INTO telotsa_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","మోషేతో, “యెహోవా చేయమని ఆజ్ఞాపించిన పనికి కావలసిన దానికన్నా ఎక్కువగా ప్రజలు తెస్తున్నారు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","అప్పుడు మోషే: “పరిశుద్ధాలయం కోసం ఏ పురుషుడు గాని స్త్రీ గాని ఇకమీదట ఏ అర్పణ తీసుకురాకూడదు” అని ఒక ఆజ్ఞ ఇవ్వగా వారు దాన్ని శిబిరమంతటికి తెలియజేశారు. అప్పుడు ప్రజలు కానుకలు తీసుకురావడం మానుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ఎందుకంటే, వారు తెచ్చిన కానుకలు ఆ పని అంతా పూర్తి చేయడానికి కావలసిన దానికన్నా ఎక్కువ. ");
INSERT INTO telotsa_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ఆ పనివారిలో నిపుణులైన వారందరు పది తెరలతో సమావేశ గుడారాన్ని తయారుచేశారు; వాటిని నీలం ఊదా ఎరుపు రంగులతో పేనిన సన్నని నారతో చేసి వాటిపై చేయితిరిగిన పనివానితో కెరూబులను అల్లించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","తెరలన్నీ ఇరవై ఎనిమిది మూరల పొడవు నాలుగు మూరల వెడల్పు కలిగి ఒకే కొలతతో ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","వారు అయిదు తెరలను ఒక దానితో ఒకటి కలిపి ఒక్కటిగా చేశారు; మిగిలిన అయిదింటిని కూడా అలాగే చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","తర్వాత వారు ఒక కూర్పులోని తెరల చివర మొదటి తెర అంచుకు నీలి నూలుతో ఉచ్చులు చేశారు, రెండవ కూర్పులోని బయటి తెర చివర కూడా అలాగే చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","అంతేకాక వారు ఒక తెరకు యాభై ఉచ్చులు చేసి, ఉచ్చులు ఒకదానికొకటి ఎదురెదురుగా ఉండేలా మరొకదాని తెర అంచుకు యాభై ఉచ్చులు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","తర్వాత వారు యాభై బంగారు గుండీలు తయారుచేసి ఆ గుండీలతో ఆ రెండు తెరలను ఒక దానితో ఒకటి కలిపినప్పుడు అది ఒకే సమావేశ గుడారంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","వారు సమావేశ గుడారం పైకప్పుగా ఉండే గుడారం కోసం మేక వెంట్రుకలతో మొత్తం పదకొండు తెరలు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","పదకొండు తెరలన్నీ పొడవు ముప్పై మూరలు, వెడల్పు నాలుగు మూరలు కలిగి ఒకే కొలతతో ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","వారు అయిదు తెరలను ఒకటిగా మిగతా ఆరు తెరలను ఒకటిగా కలిపారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","అప్పుడు వారు మొదటి కూర్పులోని చివరి తెర అంచున, అలాగే రెండవ కూర్పులోని చివరి తెర అంచున యాభై ఉచ్చులు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","దాన్ని ఒకటే గుడారమయ్యేలా వారు యాభై ఇత్తడి గుండీలు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ఎరుపురంగు వేసిన పొట్టేళ్ల చర్మంతో గుడారం కోసం పైకప్పును దానిపైన మన్నికైన తోళ్లతో పైకప్పు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","వారు సమావేశ గుడారానికి తుమ్మకర్రతో నిలువు పలకలు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ప్రతి చట్రం పొడవు పది మూరలు, వెడల్పు ఒకటిన్నర మూర ఉన్నాయి, ");
INSERT INTO telotsa_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","రెండు కొయ్యమేకులు ఒకదానికొకటి సమాంతరంగా అమర్చారు. వారు సమావేశ గుడారపు చట్రాలన్నిటిని ఈ విధంగా తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","సమావేశ గుడారపు దక్షిణ వైపుకు వారు ఇరవై చట్రాలు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ప్రతి చట్రానికి క్రింద రెండు కొయ్య మేకులకు రెండు దిమ్మల చొప్పున ఇరవై చట్రాలకు నలభై వెండి దిమ్మలు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","మరోవైపుకు, అంటే సమావేశ గుడారానికి ఉత్తర వైపుకు, ప్రతి చట్రం క్రింద రెండు చొప్పున, వారు ఇరవై చట్రాలు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","వాటి క్రిందకు నలభై వెండి దిమ్మలు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","పడమర వైపుకు అంటే సమావేశ గుడారపు వెనుక వైపుకు వారు ఆరు చట్రాలు తయారుచేశారు, ");
INSERT INTO telotsa_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","సమావేశ గుడారం యొక్క మూలల కోసం రెండు చట్రాలు తయారుచేయబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ఈ రెండు మూలల వద్ద చట్రాలు క్రింది నుండి పై వరకు రెండింతలు ఉండి ఒకే ఉంగరంలోకి అమర్చబడ్డాయి; రెండూ ఒకేలా ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","అక్కడ ఎనిమిది చట్రాలు, ప్రతి చట్రం క్రింద రెండేసి చొప్పున పదహారు వెండి దిమ్మలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","అలాగే వారు తుమ్మకర్రతో అడ్డకర్రలు తయారుచేశారు: సమావేశ గుడారానికి ఒక ప్రక్కన ఉన్న చట్రాలకు అయిదు అడ్డకర్రలు, ");
INSERT INTO telotsa_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","రెండవ వైపున ఉన్నవాటికి అయిదు, సమావేశ గుడారానికి వెనుక వైపున పడమర వైపున ఉన్న చట్రాలకు అయిదు అడ్డకర్రలు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","చట్రాల మధ్యలో ఉండే అడ్డకర్రను ఈ చివరి నుండి ఆ చివరి వరకు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","వారు చట్రాలను బంగారంతో పొదిగించి, అడ్డకర్రలు ఉంచడానికి బంగారు ఉంగరాలు చేశారు. అలాగే అడ్డకర్రలను కూడా బంగారంతో పొదిగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","వారు నీలం ఊదా ఎరుపు రంగుల్లో ఒక తెరను పేనిన సన్నని నారతో చేయించి, నిపుణుడైన పనివానితో దానిమీద కెరూబులను అల్లించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","వారు దాని కోసం తుమ్మ చెక్కతో నాలుగు స్తంభాలు చేసి బంగారంతో పొదిగించారు. వాటికి బంగారు కొక్కేలు చేసి, వాటికి నాలుగు వెండి దిమ్మలు వేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","గుడారపు ప్రవేశ ద్వారానికి వారు నీలం ఊదా ఎరుపు రంగులతో పేనిన సన్నని నారతో బుటా పని చేసిన తెర తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","వారు వాటికోసం అయిదు స్తంభాలు అలాగే కొక్కేలు చేశారు. వారు స్తంభాల పైభాగాలను, వాటి పట్టీలను బంగారంతో పొదిగించారు, అలాగే వాటికోసం అయిదు ఇత్తడి దిమ్మలు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","బెసలేలు తుమ్మకర్రతో మందసం తయారుచేశాడు. దాని పొడవు రెండున్నర మూరలు, వెడల్పు ఒకటిన్నర మూర, ఎత్తు ఒకటిన్నర మూర. ");
INSERT INTO telotsa_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","అతడు దాని లోపల, బయట స్వచ్ఛమైన బంగారంతో పొదిగించి దాని చుట్టూ బంగారు అంచును తయారుచేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","నాలుగు బంగారు ఉంగరాలు పోతపోయించి ఒకవైపు రెండు మరోవైపు రెండు ఉండేలా దాని నాలుగు కాళ్లకు వాటిని తగిలించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","తర్వాత తుమ్మకర్రతో మోతకర్రలు చేసి వాటిని బంగారంతో పొదిగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","వాటిని మందసాన్ని మోయడానికి ఆ మోతకర్రలను మందసానికి ఇరుప్రక్కల ఉన్న ఉంగరాల్లో దూర్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","అతడు స్వచ్ఛమైన బంగారంతో ప్రాయశ్చిత్త మూతను తయారుచేశాడు; దాని పొడవు రెండున్నర మూరలు, వెడల్పు ఒకటిన్నర మూర ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","తర్వాత అతడు సాగగొట్టిన బంగారంతో మూత చివర్లలో రెండు కెరూబులను తయారుచేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","అతడు ఒక చివర ఒక కెరూబును మరోచివర రెండవ కెరూబును చేశాడు; మూత మీద దాని రెండు చివర్లలో కెరూబులతో పాటు దానంతటిని ఒకే ముక్కలా చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ఆ కెరూబులు తమ రెక్కలను పైకి చాపి వాటితో ప్రాయశ్చిత్త మూతను కప్పుతూ ఉన్నాయి. కెరూబుల ముఖాలు ఒకదానికొకటి ఎదురెదురుగా ఉండి, ప్రాయశ్చిత్త మూతను చూస్తున్నట్లుగా ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","వారు తుమ్మకర్రతో ఒక బల్లను చేశారు. దాని పొడవు రెండు మూరలు, వెడల్పు ఒక మూర, ఎత్తు ఒకటిన్నర మూర. ");
INSERT INTO telotsa_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","తర్వాత వారు దాన్ని స్వచ్ఛమైన బంగారంతో పొదిగించి దాని చుట్టూ బంగారు అంచును చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","అలాగే దాని చుట్టూ బెత్తెడు వెడల్పున చట్రం కూడా చేసి దానిపై బంగారంతో పొదిగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ఆ బల్లకు నాలుగు ఉంగరాలు చేసి వాటిని నాలుగు కాళ్లు ఉన్న నాలుగు మూలల్లో తగిలించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","బల్ల మోయడానికి ఉపయోగించే మోతకర్రలు ఉంచే ఉంగరాలు చట్రానికి దగ్గరగా పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ఆ బల్లను మోయడానికి తుమ్మకర్రతో మోతకర్రలు చేసి వాటికి బంగారంతో పొదిగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","బల్ల యొక్క ఉపకరణాలు అనగా దాని పళ్లెములు, పాత్రలు, పానార్పణలు పోయడానికి ఉపయోగించే బానలు గిన్నెలను స్వచ్ఛమైన బంగారంతో తయారుచేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","వారు స్వచ్ఛమైన బంగారంతో దీపస్తంభం చేశారు. దాని అడుగు పీఠాన్ని నడిమి భాగాన్ని సుత్తెతో సాగగొట్టారు, దాని కలశాలు, దాని మొగ్గలు దాని పువ్వులు తయారుచేసి వాటితో ఒకే ఖండంలా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","దీపస్తంభానికి రెండు వైపుల నుండి ఆరు కొమ్మలు; ఒక ప్రక్క మూడు మరొక ప్రక్క మూడు కొమ్మలు విస్తరించి ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ఒక కొమ్మకు మొగ్గలు పువ్వులు ఉన్న బాదం పువ్వును పోలిన మూడు కలశాలు, తర్వాతి కొమ్మకు కూడా అలాగే మూడు కలశాల చొప్పున దీపస్తంభం నుండి విస్తరించివున్న ఆరు కొమ్మలకు అదే విధంగా ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","దీపస్తంభం మీద మొగ్గలు పువ్వులు ఉన్న బాదం పువ్వును పోలిన నాలుగు కలశాలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","దీపస్తంభం నుండి విస్తరించి ఉన్న మొదటి జత కొమ్మల క్రింద మొదటి మొగ్గ, రెండవ జత కొమ్మల క్రింద రెండవ మొగ్గ, మూడవ జత కొమ్మల క్రింద మూడవ మొగ్గ చొప్పున ఆరు కొమ్మలకు అమర్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","సాగగొట్టబడిన స్వచ్ఛమైన బంగారంతో మొగ్గలు కొమ్మలు దీపస్తంభంతో ఒకే ఖండంగా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","వారు ఏడు దీపాలు దాని వత్తులు కత్తిరించే కత్తెరలు, పళ్ళాలను స్వచ్ఛమైన బంగారంతో చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","దీపస్తంభాన్ని దాని ఉపకరణాలను తయారుచేయడానికి ఒక తలాంతు స్వచ్ఛమైన బంగారం ఉపయోగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","వారు తుమ్మకర్రతో ఒక ధూపవేదిక తయారుచేశారు. అది చతురస్రంగా ఒక మూర పొడవు ఒక మూర వెడల్పు రెండు మూరల ఎత్తు ఉంది. దాని కొమ్ములను దానితో ఒకే ఖండంగా ఉండేలా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","దాని పైభాగానికి, అన్ని ప్రక్కలకు, కొమ్ములకు స్వచ్ఛమైన బంగారు రేకుతో పొదిగించి దాని చుట్టూ బంగారు కడ్డీ చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","మోయడానికి ఉపయోగించే మోతకర్రలను పెట్టడానికి, కడ్డీ క్రింద రెండు బంగారు ఉంగరాలు, ఒకదానికొకటి ఎదురుగా ఉండేలా తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","వారు తుమ్మకర్రతో మోతకర్రలు చేసి వాటిని బంగారంతో పొదిగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","అంతేకాక వారు పవిత్ర అభిషేక తైలాన్ని, స్వచ్ఛమైన, పరిమళద్రవ్యాలు చేసేవాని పనిలా పరిమళ వాసనగల ధూపాన్ని తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","వారు తుమ్మకర్రతో మూడు మూరల ఎత్తుగల బలిపీఠం దహనబలి కోసం కట్టారు; అది అయిదు మూరల పొడవు అయిదు మూరల వెడల్పుతో చతురస్రంగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","వారు కొమ్ములు, బలిపీఠం ఒకే భాగంలా ఉండేలా దాని నాలుగు మూలల్లో ప్రతి మూలకు ఒక కొమ్మును చేశారు. వారు బలిపీఠాన్ని ఇత్తడితో పొదిగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","దాని పాత్రలన్నిటిని అంటే బూడిద తొలగించడానికి కుండలు, పారలు, చల్లే గిన్నెలు, ముళ్ళ గరిటెలు, నిప్పు పెనాలను ఇత్తడితో తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","దానికి వలలాంటి ఇత్తడి జాలి తయారుచేసి, ఆ జాలి బలిపీఠం మధ్యకు చేరేలా బలిపీఠం గట్టు క్రింది భాగంలో దానిని ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ఆ జాలి నాలుగు మూలల్లో మోతకర్రలు ఉంచేందుకు ఆ జాలి నాలుగు మూలలకు నాలుగు ఇత్తడి ఉంగరాలు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","వారు తుమ్మకర్రతో మోతకర్రలు తయారుచేసి, వాటిని ఇత్తడితో పొదిగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","బలిపీఠాన్ని మోయడానికి దాన్ని మోయడానికి ఉపయోగించే మోతకర్రలు దాని రెండు ప్రక్కలా ఉన్న ఉంగరాల్లో దూర్చారు; వారు పలకలను ఉపయోగించి బలిపీఠాన్ని గుల్లగా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","వారు సమావేశ గుడారం యొక్క ద్వారం దగ్గర సేవించడానికి వచ్చిన స్త్రీల అద్దాలతో ఒక ఇత్తడి గంగాళం దానికి ఇత్తడి పీట చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","తర్వాత వారు ఆవరణం నిర్మించారు. దక్షిణం వైపు వంద మూరల పొడవు గల పేనిన సన్నని నార తెరలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","దానికి ఇరవై స్తంభాలు వాటికి ఇరవై ఇత్తడి దిమ్మలు, అలాగే ఆ స్తంభాలకు వెండి కొక్కేలు, బద్దలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ఉత్తరం వైపు కూడా వంద మూరల పొడవు ఉంది, ఇరవై స్తంభాలు, ఇరవై ఇత్తడి దిమ్మలు, స్తంభాల మీద వెండి కొక్కేలు, దిమ్మలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","పడమర చివర యాభై మూరల వెడల్పు ఉండి, పది స్తంభాలు, పది దిమ్మలతో తెరలు ఉన్నాయి. ఆ స్తంభాలకు వెండి కొక్కేలు, బద్దలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","తూర్పు వైపు, అనగా సూర్యోదయం వైపు కూడా, యాభై మూరల వెడల్పు ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ప్రవేశ ద్వారానికి ఒక ప్రక్క పదిహేను మూరల పొడవు గల తెరలు, వాటికి మూడు స్తంభాలు, మూడు దిమ్మలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ఆవరణం యొక్క ద్వారానికి అటు ప్రక్కన మూడు స్తంభాలు, మూడు దిమ్మలతో పదిహేను మూరల పొడవు గల తెరలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ఆవరణం చుట్టూ ఉన్న తెరలన్నీ పేనిన సన్నని నారతో చేసినవి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ఆ స్తంభాల దిమ్మలు ఇత్తడివి. ఆ స్తంభాల మీదున్న బద్దలు, కొక్కేలు వెండివి. వాటి పైభాగాలు వెండితో పొదిగించబడ్డాయి; అలా ఆవరణం యొక్క స్తంభాలన్నిటికి వెండి బద్దలు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ఆవరణం యొక్క ద్వారానికి నీలం ఊదా ఎరుపు రంగుల పేనిన సన్నని నారతో బుటా పనితో తెర తయారుచేయబడింది. అది ఇరవై మూరల పొడవు గల తెర, ఆవరణం యొక్క తెరల్లా అయిదు మూరల ఎత్తు ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","దానికి నాలుగు స్తంభాలు వాటిని నాలుగు దిమ్మలు ఇత్తడివి. దాని బద్దలు కొక్కేలు వెండివి. వాటి పైభాగం వెండితో పొదిగించబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","సమావేశ గుడారం, దాని చుట్టూ ఉన్న ఆవరణం యొక్క గుడారపు మేకులన్నీ ఇత్తడివి. ");
INSERT INTO telotsa_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","సమావేశ గుడారం అనగా సాక్షి గుడారానికి ఉపయోగించిన వస్తువుల వివరాలు ఇవే, యాజకుడైన అహరోను కుమారుడు ఈతామారు పర్యవేక్షణలో మోషే ఆజ్ఞ ప్రకారం లేవీయులు నమోదు చేశారు: ");
INSERT INTO telotsa_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","యూదా గోత్రానికి చెందిన ఊరి కుమారుడు హూరు మనుమడైన బెసలేలు యెహోవా మోషేకు ఆజ్ఞాపించిన వాటన్నిటిని చేశాడు; ");
INSERT INTO telotsa_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","దాను గోత్రానికి చెందిన అహీసామాకు కుమారుడైన ఒహోలీయాబు అతనికి సహాయకుడు. ఇతడు చెక్కేవాడు, కళాకారుడు, నీలం ఊదా ఎరుపు రంగుల నూలు సన్నని నారతో బుటా పని చేయగలడు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ప్రత్యేక అర్పణల నుండి పరిశుద్ధాలయం యొక్క పనులన్నిటికి ఉపయోగించిన మొత్తం బంగారం పరిశుద్ధాలయం యొక్క షెకెల్ ప్రకారం 29 తలాంతుల 730 షెకెళ్ళు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","జనాభా లెక్కలలో నమోదైన వారు ఇచ్చిన వెండి పరిశుద్ధాలయం యొక్క షెకెల్ ప్రకారం 100 తలాంతుల 1,775 షెకెళ్ళు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ఇరవై సంవత్సరాలు, ఆపై వయస్సు కలిగి నమోదు చేసుకున్న వారు అనగా 6,03,550 మంది పురుషులు తలా ఒక బెకా అంటే, అర షెకెల్, పరిశుద్ధాలయ షెకెల్ చొప్పున చెల్లించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","100 తలాంతుల వెండిని పరిశుద్ధాలయ దిమ్మలకు ఉపయోగించారు. అవి తెరలకు దిమ్మలు; ఒక దిమ్మకు ఒక తలాంతు చొప్పున 100 దిమ్మలకు 100 తలాంతులు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","స్తంభాలకు కొక్కేలను, స్తంభం పై భాగంలో పోతపోయడానికి, వాటికి బద్దెలు చేయడానికి 1,775 షెకెళ్ళు ఉపయోగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ప్రత్యేక అర్పణల నుండి లభించిన ఇత్తడి 70 తలాంతుల 2,400 షెకెళ్ళు. ");
INSERT INTO telotsa_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ఆ ఇత్తడిని సమావేశ గుడారపు ద్వారం యొక్క దిమ్మల కోసం, ఇత్తడి బలిపీఠానికి, ఇత్తడి జల్లెడ, దాని పాత్రలన్నిటికి, ");
INSERT INTO telotsa_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","చుట్టూ ఉన్న ఆవరణానికి, దాని ద్వారానికి దిమ్మలు చేయడానికి, సమావేశ గుడారం, చుట్టూ ఉన్న ఆవరణపు అన్ని మేకులు చేయడానికి ఉపయోగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","పరిశుద్ధాలయంలో సేవ చేయడానికి నీలం ఊదా ఎరుపు రంగుల నూలు ఉపయోగించి వారు నేసిన వస్త్రాలను తయారుచేశారు. యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం అహరోనుకు పవిత్ర వస్త్రాలను కూడా తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","బంగారంతో నీలం ఊదా ఎరుపు రంగుల నూలు పేనిన సన్నని నారతో ఏఫోదును తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","నీలం ఊదా ఎరుపు రంగుల నూలు పేనిన సన్నని నారతో నైపుణ్యమైన పనిగా నేయడానికి బంగారాన్ని రేకులుగా సాగగొట్టి దానిని తీగెలుగా కత్తిరించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ఏఫోదుకు భుజాల ముక్కలు తయారుచేసి అది కదలకుండా ఉండేలా దాని రెండు మూలల్లో కూర్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","నైపుణ్యంగా అల్లబడిన దాని నడికట్టు ఏఫోదుతో ఒకే ముక్కగా, బంగారం నీలం ఊదా ఎరుపు రంగుల నూలు పేనిన సన్నని నారతో చేశారు. యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం ఇవన్నీ చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","వారు లేతపచ్చ రాళ్లు తీసుకుని చెక్కేవారు ముద్రను చెక్కినట్లు వాటిపై ఇశ్రాయేలు కుమారుల పేర్లు చెక్కి బంగారు జరీ చట్రంలోకి ఎక్కించి, ");
INSERT INTO telotsa_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","తర్వాత వాటిని ఇశ్రాయేలు కుమారుల జ్ఞాపకార్థ రాళ్లుగా ఏఫోదు భుజాలపై బిగించారు. యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం ఇవన్నీ చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","నైపుణ్యం ఉట్టిపడేలా ఏఫోదును చేసినట్లు బంగారం నీలం ఊదా ఎరుపు రంగుల నూలు పేనిన సన్నని నారతో పతకాన్ని తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","అది చతురస్రంగా జానెడు పొడవు జానెడు వెడల్పుతో రెండుగా మడత పెట్టబడి ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","దానిపై నాలుగు వరుసల ప్రశస్తమైన రాళ్లు పొదిగారు. మొదటి వరుసలో మాణిక్యం, గోమేధికం, మరకతం; ");
INSERT INTO telotsa_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","రెండవ వరుసలో పద్మరాగం, నీలమణి, పచ్చ; ");
INSERT INTO telotsa_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","మూడవ వరుసలో గారుత్మతం, యష్మురాయి, ఇంద్రనీలం; ");
INSERT INTO telotsa_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","నాలుగవ వరుసలో పుష్యరాగం, లేతపచ్చ రాళ్లు, సూర్యకాంతమణి ఉన్నాయి. వాటిని బంగారు చట్రంలో అమర్చారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ఇశ్రాయేలు కుమారుల పేర్లకు ఒక్కొక్కటి చొప్పున పన్నెండు రాళ్లు ఉన్నాయి, ప్రతిదీ వారిలో ఒక్కొక్క పేరు చొప్పున పన్నెండు గోత్రాల పేర్లు ముద్రలా చెక్కబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","వారు రొమ్ము పతకానికి స్వచ్ఛమైన బంగారంతో ఒక తాడులా అల్లికపనితో గొలుసులు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","రెండు బంగారు జరీ పలకలు రెండు బంగారు ఉంగరాలను చేసి, వాటిని పతకానికి రెండు చివర్లకు తగిలించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","వారు రొమ్ము పతకం చివరిలో ఉన్న ఉంగరాలకు రెండు బంగారు గొలుసులు బిగించి, ");
INSERT INTO telotsa_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","గొలుసుల యొక్క ఇతర చివరలను రెండు జవలకు, ముందు భాగంలో ఉన్న ఏఫోదు యొక్క భుజాలకు జోడించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","వారు రెండు బంగారు ఉంగరాలను తయారుచేసి, వాటిని ఏఫోదు ముందు భాగంలో రొమ్ము పతకానికి లోపలి అంచున ఉన్న రెండు చివర్లకు జోడించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","వారు మరో రెండు బంగారు ఉంగరాలను తయారుచేసి వాటిని ఏఫోదు నడికట్టుకు కొంచెం పైన దాని అతుకు దగ్గరగా ఏఫోదు ముందు భాగంలో రెండు భుజభాగాలకు క్రింది వైపున జోడించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం వారు, రొమ్ము పతకం ఏఫోదు నుండి బయటకు వ్రేలాడకుండా నడికట్టును అంటిపెట్టుకుని ఉండేలా రొమ్ము పతకం యొక్క ఉంగరాలను ఏఫోదు ఉంగరాలకు నీలిరంగు దారంతో కట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","వారు ఏఫోదు నిలువుటంగీని ఒక నేత పనిలా పూర్తిగా నీలి బట్టతో తయారుచేసి, ");
INSERT INTO telotsa_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","దాని మధ్యలో తల దూర్చడానికి రంధ్రం చేసి అది చిరిగిపోకుండా మెడపట్టీలా దాని అంచుల చుట్టూ అల్లికపని చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","వారు ఆ వస్త్రం అంచు చుట్టూ నీలం ఊదా ఎరుపు రంగుల నూలుతో పాటు, పేనిన సన్నని నారతో దానిమ్మపండ్లు తయారుచేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","స్వచ్ఛమైన బంగారంతో తయారుచేసిన గంటలను వస్త్రం అంచు చుట్టూ ఉన్న దానిమ్మపండ్ల మధ్య తగిలించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","సేవ చేస్తున్నప్పుడు వేసుకోడానికి బంగారు గంటలు దానిమ్మపండ్లు ఒకదాని ప్రక్కన ఒకటిగా వస్త్రం అంచు చుట్టూ ఉంచారు; యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం ఇవి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","వారు అహరోనుకు అతని కుమారులకు సన్నని నారబట్టతో చొక్కా నేసారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","సన్నని నారతో తలపాగా, నార టోపీలు, పేనిన సన్నని నారతో లోదుస్తులు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","పేనిన సన్నని నారతో నీలం ఊదా ఎరుపు రంగుల నూలుతో బుటా పనిగా నడికట్టు తయారుచేశారు. యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం ఇవి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","వారు పవిత్ర చిహ్నంగా స్వచ్ఛమైన బంగారంతో ఒక కిరీటం తయారుచేసి, దాని మీద ముద్రలా ఈ మాటలు చెక్కారు: పరిశుద్ధత యెహోవాకే. ");
INSERT INTO telotsa_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","దాన్ని తలపాగాకు అతకడానికి దానిని నీలి దారంతో కట్టారు. యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం ఇవి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","సమావేశ గుడారపు పనంతా పూర్తి అయింది. యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం ఇశ్రాయేలీయులు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","అప్పుడు వారు సమావేశ గుడారం మోషే దగ్గరకు తెచ్చారు: గుడారం దాని అలంకరణలు, దాని కొలుకులు, పలకలు, అడ్డకర్రలు, స్తంభాలు, దిమ్మలు; ");
INSERT INTO telotsa_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ఎరుపురంగు వేసిన పొట్టేళ్ల చర్మాల పైకప్పు, మన్నికైన తోళ్ల పైకప్పు, కప్పివుంచే తెర; ");
INSERT INTO telotsa_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","నిబంధన మందసం దాని మోతకర్రలు, ప్రాయశ్చిత్త మూత; ");
INSERT INTO telotsa_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","బల్ల, దాని ఉపకరణాలన్నీ, సన్నిధి రొట్టెలు; ");
INSERT INTO telotsa_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","మేలిమి బంగారు దీపస్తంభం, దాని దీపాల వరుస, దాని ఉపకరణాలన్నీ, వెలిగించడానికి ఒలీవనూనె; ");
INSERT INTO telotsa_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","బంగారు బలిపీఠం, అభిషేక తైలం, పరిమళ వాసనగల ధూపం, గుడారపు ద్వారానికి తెర; ");
INSERT INTO telotsa_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ఇత్తడి బలిపీఠం, దాని ఇత్తడి జల్లెడ, దాని మోతకర్రలు దాని పాత్రలన్నీ; ఇత్తడి గంగాళం, దాని పీట; ");
INSERT INTO telotsa_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ఆవరణపు తెరలు, దాని స్తంభాలు, దిమ్మలు, ఆవరణ ద్వారానికి తెర; ఆవరణానికి మేకులు, వాటి త్రాళ్లు; సమావేశ గుడారంలో సేవకు ఉపయోగించే అన్ని ఉపకరణాలు; ");
INSERT INTO telotsa_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","పరిశుద్ధాలయంలో పరిచర్య చేయడానికి ధరించే నేసిన వస్త్రాలు; యాజకుడైన అహరోనుకు పవిత్ర వస్త్రాలు, యాజకులుగా సేవ చేస్తున్నప్పుడు అతని కుమారులకు వస్త్రాలు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం ఇశ్రాయేలీయులు ఆ పని అంతా పూర్తి చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","మోషే వారు చేసిన పనిని పరిశీలించి, యెహోవా ఆజ్ఞాపించిన ప్రకారం వారు దానిని చేశారని చూశాడు. కాబట్టి మోషే వారిని దీవించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“మొదటి నెల మొదటి రోజున సమావేశ గుడారాన్ని నిలబెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","దానిలో నిబంధన మందసాన్ని ఉంచి ఆ మందసాన్ని తెరతో కప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","బల్లను లోపలికి తెచ్చి దానికి చెందినవి దాని మీద క్రమంగా ఉంచాలి. దీపస్తంభాన్ని తెచ్చి దీపాలు వెలిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","నిబంధన మందసం ఎదుట బంగారు ధూపవేదికను ఉంచి సమావేశ గుడారపు ద్వారానికి తెర తగిలించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“నీవు ప్రత్యక్ష గుడారపు ద్వారం ఎదుట దహనబలిపీఠాన్ని ఉంచాలి; ");
INSERT INTO telotsa_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","సమావేశ గుడారానికి బలిపీఠానికి మధ్యలో గంగాళం ఉంచి దానిలో నీళ్లు నింపాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","దాని చుట్టూ ఆవరణాన్ని నిలబెట్టి ఆవరణ ద్వారానికి తెర తగిలించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“అభిషేక తైలాన్ని తీసుకుని సమావేశ గుడారాన్ని, దానిలో ఉన్నవాటన్నిటిని అభిషేకించాలి; దానిని, దాని సామాగ్రి అన్నిటిని ప్రతిష్ఠించాలి, అప్పుడు అది పరిశుద్ధం అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","తర్వాత దహనబలిపీఠాన్ని, దాని పాత్రలన్నిటిని అభిషేకించాలి; బలిపీఠాన్ని ప్రతిష్ఠించాలి, అది అత్యంత పరిశుద్ధమవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","గంగాళాన్ని దాని పీటను అభిషేకించి వాటిని పవిత్రం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“తర్వాత నీవు అహరోనును అతని కుమారులను సమావేశ గుడారపు ద్వారం దగ్గరకు తీసుకువచ్చి వారిని నీటితో కడగాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","అహరోను నాకు యాజక సేవ చేయటానికి అతనికి పవిత్ర వస్త్రాలను ధరింపజేసి, అతన్ని అభిషేకించి ప్రతిష్ఠించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","అతని కుమారులను తీసుకువచ్చి వారికి చొక్కాలు తొడిగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","నాకు యాజక సేవ చేయటానికి వారి తండ్రిని అభిషేకించినట్లే వారిని కూడా అభిషేకించాలి. వారి అభిషేకం యాజకత్వానికి గుర్తుగా తరతరాలకు కొనసాగుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","యెహోవా అతనికి ఆజ్ఞాపించిన ప్రకారం మోషే అన్నిటిని చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","రెండవ సంవత్సరం మొదటి నెలలో మొదటి రోజున సమావేశ గుడారాన్ని నిలబెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","మోషే మందిరాన్ని నిలబెడుతున్నప్పుడు, అతడు దాని దిమ్మలు సరియైన చోట పెట్టి, పలకలను నిలబెట్టి అడ్డకర్రలు దూర్చి దాని స్తంభాలు నిలబెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","తర్వాత మోషే యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం సమావేశ గుడారం మీద గుడారాన్ని పరచి దానిపైన గుడారపు కప్పు వేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","అతడు నిబంధన పలకలను తీసుకుని మందసంలో పెట్టి, మందసానికి మోతకర్రలు దూర్చి దాని మీద ప్రాయశ్చిత్త మూతను ఉంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం మోషే మందసాన్ని సమావేశ గుడారంలోకి తీసుకువచ్చి కప్పివుంచే తెర తగిలించి నిబంధన మందసాన్ని కప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","మోషే సమావేశ గుడారంలో ఉత్తరం వైపున తెర బయట బల్లను ఉంచి, ");
INSERT INTO telotsa_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం, యెహోవా ఎదుట దానిపైన రొట్టెను పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","అతడు సమావేశ గుడారంలో బల్లకు ఎదురుగా సమావేశ గుడారానికి దక్షిణ వైపు దీపస్తంభాన్ని ఉంచి, ");
INSERT INTO telotsa_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం, యెహోవా ఎదుట దీపాలు వెలిగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","మోషే సమావేశ గుడారంలో తెర ఎదుట బంగారు ధూపవేదిక ఉంచి, ");
INSERT INTO telotsa_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం, పరిమళ వాసనగల ధూపాన్ని దాని మీద కాల్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","తర్వాత అతడు సమావేశ గుడారపు ప్రవేశ ద్వారానికి తెర వేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","సమావేశ గుడారపు ద్వారానికి సమీపంగా దహనబలిపీఠాన్ని ఉంచి దాని మీద దహనబలి అర్పించి భోజనార్పణను సమర్పించాడు. యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం మోషే ఇది చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","సమావేశ గుడారానికి బలిపీఠానికి మధ్యలో గంగాళాన్ని ఉంచి, కడుక్కోడానికి దానిలో నీళ్లు పోశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","మోషే అహరోను అతని కుమారులు తమ చేతులు కాళ్లు కడుక్కోడానికి దీనిని ఉపయోగించారు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","వారు సమావేశ గుడారం లోనికి వెళ్లినప్పుడు బలిపీఠాన్ని సమీపించినప్పుడు కడుక్కునేవారు; యెహోవా మోషే ఆజ్ఞాపించిన ప్రకారం మోషే ఇది చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","తర్వాత మోషే సమావేశ గుడారానికి బలిపీఠానికి చుట్టూ ఆవరణాన్ని ఏర్పాటు చేసి ఆవరణ ద్వారానికి తెర వేశాడు. ఇలా మోషే పని ముగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","అప్పుడు సమావేశ గుడారాన్ని మేఘం కమ్మింది, యెహోవా మహిమతో సమావేశ గుడారం నిండింది. ");
INSERT INTO telotsa_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ఆ మేఘం దాని మీద నిలిచి ఉండడం వల్ల, యెహోవా మహిమ సమావేశ గుడారాన్ని నింపివేసేది, కాబట్టి మోషే సమావేశ గుడారం లోనికి ప్రవేశించలేకపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ఇశ్రాయేలీయుల ప్రయాణాలన్నిటిలో, సమావేశ గుడారం మీద నుండి మేఘం పైకి వెళ్లినప్పుడు వారు బయలుదేరేవారు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ఒకవేళ మేఘం పైకి వెళ్లకపోతే, అది పైకి వెళ్లేవరకు బయలుదేరేవారు కారు. ");
INSERT INTO telotsa_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ఇశ్రాయేలీయుల ప్రయాణాలన్నిటిలో ఇశ్రాయేలీయులంతా చూస్తూ ఉండగా పగటివేళ యెహోవా మేఘం సమావేశ గుడారం మీద ఉండేది, రాత్రివేళ ఆ మేఘంలో అగ్ని ఉండేది.");
INSERT INTO telotsa_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","యెహోవా మోషేను పిలిచి సమావేశ గుడారం నుండి అతనితో మాట్లాడారు. ఆయన అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ఇశ్రాయేలీయులతో మాట్లాడి వారితో ఇలా చెప్పు: ‘మీలో ఏ మనుష్యుడైనా యెహోవాకు అర్పణ తెచ్చినప్పుడు, మీ అర్పణగా పశువుల మంద నుండి గాని లేదా గొర్రెల మంద నుండి ఒక జంతువును తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘ఒకవేళ అర్పణ, మంద నుండి దహనబలి అయితే, మీరు లోపం లేని మగదానిని అర్పించాలి. అది యెహోవాకు అంగీకారంగా ఉండేలా మీరు దానిని సమావేశ గుడారం యొక్క ద్వారం దగ్గర సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","దహనబలి పశువు యొక్క తలపై మీరు చేయి ఉంచాలి, అప్పుడు అది మీ కోసం ప్రాయశ్చిత్తం చేయడానికి మీ తరపున అంగీకరించబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","మీరు కోడెను యెహోవా ఎదుట వధించాలి, అప్పుడు యాజకులైన అహరోను కుమారులు దాని రక్తాన్ని తెచ్చి సమావేశ గుడారపు ద్వారం దగ్గర ఉన్న బలిపీఠం చుట్టూ చల్లుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","తర్వాత అతడు దహనబలి పశువు చర్మం తీసి, దానిని ముక్కలుగా చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","యాజకుడైన అహరోను కుమారులు బలిపీఠం మీద నిప్పు పెట్టి ఆ నిప్పుమీద కట్టెలు పేర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","అప్పుడు యాజకులైన అహరోను కుమారులు దాని తల, క్రొవ్వుతో పాటు, ముక్కలను బలిపీఠం మీద కాలుతున్న కట్టెల మీద పేర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","అతడు లోపలి అవయవాలను కాళ్లను నీటితో కడగాలి, యాజకుడు వాటన్నిటిని బలిపీఠం మీద కాల్చాలి. అది దహనబలి, యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘ఒకవేళ అర్పణ మంద నుండి తెచ్చిన దహనబలి అర్పణ అయితే, గొర్రెల నుండి గాని లేదా మేకల నుండి గాని, మీరు లోపం లేని మగవాటినే అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","మీరు దానిని బలిపీఠానికి ఉత్తర దిక్కున యెహోవా ఎదుట వధించాలి, యాజకులైన అహరోను కుమారులు దాని రక్తాన్ని బలిపీఠం చుట్టూరా చల్లుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","మీరు దానిని ముక్కలుగా చేయాలి, యాజకుడు దాని తల, క్రొవ్వుతో పాటు, వాటిని బలిపీఠం మీద కాలుతున్న కట్టెల మీద పేర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","మీరు దాని లోపలి అవయవాలను కాళ్లను నీటితో కడగాలి, యాజకుడు వాటినన్నిటిని తెచ్చి బలిపీఠం మీద దహించాలి. అది దహనబలి, యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘ఒకవేళ యెహోవాకు అర్పించే అర్పణ పక్షుల దహనబలి అయితే, మీరు పావురం లేదా గువ్వను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","యాజకుడు దానిని బలిపీఠం దగ్గరకు తెచ్చి, దాని తలను విరిచి బలిపీఠం మీద దానిని కాల్చాలి; దాని రక్తం బలిపీఠం ప్రక్కనే పిండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","యాజకుడు ఆ పక్షి ప్రేగులను ఈకలను తీసివేసి అదంతా బలిపీఠానికి తూర్పుగా బూడిద ఉండే స్థలంలో పారవేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","పక్షిని పూర్తిగా విడదీయక, అతడు రెక్కల సందులో దానిని చీల్చాలి, అప్పుడు యాజకుడు బలిపీఠం మీద కాలుతున్న కట్టెల మీద దానిని కాల్చాలి. అది దహనబలి, యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘ఎవరైనా యెహోవాకు భోజనార్పణ తెచ్చినప్పుడు, అది నాణ్యమైన పిండితో చేసినదై ఉండాలి. వారు దాని మీద ఒలీవనూనె పోసి, దానిపై ధూపం వేసి, ");
INSERT INTO telotsa_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","దానిని యాజకులైన అహరోను కుమారుల దగ్గరకు తీసుకురావాలి. యాజకుడు ఒక పిడికెడు పిండి, నూనె, ధూపమంతటితో పాటు తీసుకుని బలిపీఠం మీద దానిని ఒక జ్ఞాపకార్థ భాగంగా, యెహోవాకు ఇష్టమైన సువాసనగల హోమబలిగా దహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","భోజనార్పణలో మిగిలింది అహరోనుకు అతని కుమారులకు చెందుతుంది; యెహోవాకు అర్పించే హోమబలులలో ఇది అతిపరిశుద్ధమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘ఒకవేళ మీరు పొయ్యిలో కాల్చిన భోజనార్పణ తెస్తే, అది నాణ్యమైన పిండితో చేసినదై ఉండాలి: నూనె కలిపి చేసిన పులియని మందమైన రొట్టెలు లేదా నూనె రాసి చేసిన పులియని రొట్టెలు. ");
INSERT INTO telotsa_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ఒకవేళ మీ భోజనార్పణ పెనం మీద కాల్చినదైతే, అది నాణ్యమైన పిండిలో నూనె కలిపి, పులుపు లేకుండ చేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","దానిని ముక్కలుగా చేసి, నూనె పోయాలి; అది భోజనార్పణ. ");
INSERT INTO telotsa_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ఒకవేళ మీ భోజనార్పణ వంటపాత్రలో వండినదైతే, దానిని నాణ్యమైన పిండిలో కొంచెం నూనె కలిపి చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","వీటితో చేయబడిన భోజనార్పణను యెహోవా దగ్గరకు తీసుకురావాలి; దానిని బలిపీఠం దగ్గరకు తీసుకెళ్లేలా యాజకునికి అప్పగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","యాజకుడు ఆ భోజనార్పణలో నుండి జ్ఞాపకార్థ భాగాన్ని తీసి బలిపీఠం మీద దానిని యెహోవాకు ఇష్టమైన సువాసనగల హోమబలిగా కాల్చుతాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","భోజనార్పణలో మిగిలింది అహరోనుకు అతని కుమారులకు చెందుతుంది; యెహోవాకు అర్పించే హోమబలులలో ఇది అతిపరిశుద్ధమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘యెహోవాకు అర్పించే ప్రతి భోజనార్పణ పులిసిన పదార్థం లేకుండా ఉండాలి, ఎందుకంటే యెహోవాకు అర్పించే హోమబలిలో మీరు పులిసిన దానిని లేదా తేనెను దహించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","వాటిని ప్రథమ ఫలంగా యెహోవాకు అర్పించవచ్చు కాని, బలిపీఠం మీద ఇష్టమైన సువాసనగల దానిగా వాటిని అర్పించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","మీ భోజనార్పణలను అన్నిటికి ఉప్పు కలపండి. మీ దేవుని నిబంధన ఉప్పు లేకుండా మీ భోజనార్పణలు ఉండకూడదు; మీ అర్పణలన్నిటికీ ఉప్పు కలపండి. ");
INSERT INTO telotsa_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘మీరు ప్రథమ ఫలాల భోజనార్పణ యెహోవా దగ్గరకు తీసుకువస్తే, క్రొత్త ధాన్యాన్ని దంచి అగ్నిలో వేయించి అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","దాని మీద నూనె పోయాలి, ధూపం వేయాలి; అది భోజనార్పణ. ");
INSERT INTO telotsa_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","యాజకుడు జ్ఞాపకార్థ భాగమైన నలుగగొట్టిన ధాన్యాన్ని, నూనెను, ధూపంతో కలిపి యెహోవాకు హోమబలిగా దహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘ఒకవేళ మీ అర్పణ సమాధానబలి అయితే, పశువుల్లో మగదానిని గాని, ఆడదానిని గాని, ఏ లోపం లేని దానిని యెహోవా సన్నిధికి తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","మీరు అర్పించిన పశువు మీద చేయి ఉంచి, సమావేశ గుడారపు ద్వారం దగ్గర దానిని వధించాలి. యాజకులైన అహరోను కుమారులు దాని రక్తాన్ని బలిపీఠం చుట్టూరా చిలకరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","సమాధానబలి అర్పణ నుండి మీరు యెహోవాకు హోమబలిని తీసుకురావాలి: లోపలి అవయవాలు, వాటికి ఉన్న సమస్త క్రొవ్వు, ");
INSERT INTO telotsa_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","రెండు మూత్రపిండాలు, నడుము దగ్గర వాటి మీద ఉన్న క్రొవ్వు, మీరు మూత్రపిండాలతో పాటు తొలగించే కాలేయం మీది క్రొవ్వు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","అహరోను కుమారులు బలిపీఠం మీద నిప్పుపై పేర్చిన కట్టెల మీద ఉన్న దహనబలితో పాటు వీటిని దహించాలి; అది యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘ఒకవేళ మీరు మంద నుండి ఒక పశువును సమాధానబలిగా యెహోవాకు అర్పిస్తే, మగదైనా ఆడదైనా మీరు లోపం లేనిదే అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ఒకవేళ మీరు గొర్రెపిల్లను అర్పిస్తే, దానిని యెహోవా సన్నిధికి తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","మీరు దాని తలపై చేయి ఉంచి సమావేశ గుడారం ముందు దానిని వధించాలి. అప్పుడు అహరోను కుమారులు బలిపీఠం చుట్టూరా దాని రక్తం చల్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","సమాధానబలి నుండి మీరు యెహోవాకు హోమబలిని తీసుకురావాలి: ఆ బలి పశువు క్రొవ్వునూ, వెన్నెముక చివర వరకు ఉండే క్రొవ్వు పట్టిన తోకంతటిని, దాని అంతర్భాగాలకు పట్టి ఉన్న క్రొవ్వునూ, వాటి దగ్గరలో కనిపించే క్రొవ్వునూ పూర్తిగా తీసుకురావాలి, ");
INSERT INTO telotsa_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","రెండు మూత్రపిండాలు, నడుము దగ్గర వాటి మీద ఉన్న క్రొవ్వు, మూత్రపిండాలతో పాటు తొలగించే కాలేయం మీది క్రొవ్వు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","యాజకుడు వాటిని బలిపీఠం మీద యెహోవాకు హోమబలిగా దహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘ఒకవేళ మీరు మేకను అర్పించాలంటే, దానిని యెహోవా సన్నిధికి తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","మీరు దాని తలమీద చేయి పెట్టి సమావేశ గుడారం ముందు దానిని వధించాలి. అప్పుడు అహరోను కుమారులు బలిపీఠం చుట్టూరా దాని రక్తం చల్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","మీరు అర్పించే దాని నుండి హోమబలి యెహోవా ఎదుట సమర్పించాలి: లోపలి అవయవాలు వాటి మీద ఉన్న కొవ్వంతా. ");
INSERT INTO telotsa_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","రెండు మూత్రపిండాలు నడుము దగ్గర వాటి మీద ఉన్న క్రొవ్వు, మూత్రపిండాలతో పాటు తొలగించే కాలేయం మీది క్రొవ్వు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","యాజకుడు వాటిని హోమబలిగా యెహోవాకు ఇష్టమైన సువాసనగల అర్పణగా బలిపీఠం మీద కాల్చివేయాలి. కొవ్వంతా యెహోవాదే. ");
INSERT INTO telotsa_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘మీరెక్కడ ఉన్నాసరే క్రొవ్వును గాని రక్తాన్ని గాని అసలు తినకూడదు. ఇది మీ రాబోయే తరాలకు నిత్య కట్టుబాటుగా ఉంటుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘ఎవరైనా అనుకోకుండ పాపం చేసి, యెహోవా ఆజ్ఞలలో నిషేధించబడిన దేనినైన చేసినప్పుడు ఇలా చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘అభిషేకించబడిన యాజకుడు పాపం చేసి ప్రజలపై అపరాధాన్ని తెస్తే, అతడు చేసిన పాపానికి పాపపరిహారబలిగా లోపం లేని ఒక కోడెను యెహోవా దగ్గరకు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ఆ కోడెను యెహోవా ఎదుట సమావేశ గుడారపు ద్వారం దగ్గరకు తీసుకురావాలి. దాని తలపై చేయి పెట్టి యెహోవా ఎదుట దానిని వధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","అప్పుడు అభిషేకించబడిన యాజకుడు ఆ కోడె రక్తాన్ని కొంత సమావేశ గుడారం లోనికి తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","అతడు ఆ రక్తంలో తన వ్రేలు ముంచి పరిశుద్ధాలయం యొక్క తెర ముందు యెహోవా ఎదుట ఏడుసార్లు ఆ రక్తాన్ని చిలకరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","యాజకుడు అప్పుడు కొంచెం రక్తాన్ని సమావేశ గుడారంలో యెహోవా ఎదుట ఉన్న పరిమళ వాసనగల ధూపవేదిక కొమ్ములపై పూయాలి. మిగిలిన ఎద్దు రక్తం అతడు సమావేశ గుడార ద్వారం దగ్గర దహనబలి యొక్క బలిపీఠం అడుగున పోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","పాపపరిహారబలి కోసం తెచ్చిన కోడె యొక్క క్రొవ్వంతా అంటే లోపలి అవయవాలకు ఉన్న క్రొవ్వు, ");
INSERT INTO telotsa_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","రెండు మూత్రపిండాలు, నడుము దగ్గర వాటి మీద ఉన్న క్రొవ్వు, మూత్రపిండాలతో పాటు తొలగించే కాలేయం మీది క్రొవ్వు ");
INSERT INTO telotsa_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","సమాధానబలిగా అర్పించబడే ఎద్దు క్రొవ్వును తీసేసినట్లే తీయాలి. అప్పుడు యాజకుడు వాటిని దహనబలి యొక్క బలిపీఠం మీద కాల్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","అయితే కోడెలో ఇంకా మిగిలి ఉన్నవి అంటే చర్మం, దాని పూర్తి మాంసం, తల, కాళ్లు, లోపలి అవయవాలు, పేడ ");
INSERT INTO telotsa_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","అంటే కోడె శేషమంతటిని శిబిరం బయట ఆచార ప్రకారం శుభ్రమైన ప్రదేశానికి, బూడిద పడవేయబడే స్థలానికి తీసుకెళ్లి, బూడిద కుప్ప మీద కట్టెల మంటలో దానిని కాల్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘ఒకవేళ ఇశ్రాయేలీయుల సమాజమంతా పొరపాటున యెహోవా చేయకూడదని ఆజ్ఞాపించిన విషయాల్లో దేనినైనా చేసి అపరాధులై తాము చేసిన తప్పును గ్రహించినప్పుడు, సమాజానికి ఈ విషయం తెలియకపోయినా, వారు అపరాధులు, ");
INSERT INTO telotsa_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","వారు చేసిన పాపం బయటపడినప్పుడు, సమాజం పాపపరిహారబలిగా ఒక కోడెను తెచ్చి సమావేశ గుడారం ఎదుట సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","సమాజపెద్దలు యెహోవా ఎదుట కోడె తలమీద చేతులు ఉంచి యెహోవా ఎదుట కోడెను వధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","అప్పుడు అభిషేకించబడిన యాజకుడు కోడె రక్తంలో కొంత భాగాన్ని సమావేశ గుడారంలోకి తీసుకెళ్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","అతడు ఆ రక్తంలో వ్రేలు ముంచి యెహోవా ఎదుట ఏడుసార్లు తెర ఎదుట చిలకరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","అతడు సమావేశ గుడారంలో యెహోవా ఎదుట ఉన్న బలిపీఠం కొమ్ములపై కొంత రక్తాన్ని పూసి మిగిలిన రక్తం సమావేశ గుడార ద్వారం దగ్గర దహనబలి యొక్క బలిపీఠం అడుగున పోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","అతడు దాని కొవ్వంతా తీసి బలిపీఠం మీద దహించాలి, ");
INSERT INTO telotsa_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","పాపపరిహారబలి కోసం కోడెను చేసినట్లే దీనికి కూడా చేయాలి. ఈ విధంగా యాజకుడు సమాజానికి ప్రాయశ్చిత్తం చేస్తాడు, అప్పుడు వారు క్షమించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","తర్వాత అతడు ఎద్దును శిబిరం బయటకు తీసుకెళ్లి మొదటి ఎద్దును కాల్చినట్లుగా దానిని కాల్చాలి. ఇది సమాజం కోసం చేసిన పాపపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘ఒక నాయకుడు అనుకోకుండ పాపం చేసి, తన దేవుడైన యెహోవా ఆజ్ఞలలో నిషేధించబడిన దేనినైనా చేసినప్పుడు, అతడు అపరాధి, ");
INSERT INTO telotsa_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","తాను దేన్ని బట్టి పాపం చేశాడో తెలుకున్నప్పుడు అతడు లోపం లేని మేకపోతును అర్పణగా తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","అతడు మేక తలపై చేయి ఉంచి, యెహోవా ఎదుట దహనబలిని వధించిన స్థలంలో దానిని వధించాలి. ఇది పాపపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","అప్పుడు యాజకుడు పాపపరిహారబలి రక్తం నుండి కొంత రక్తాన్ని తన వ్రేలితో తీసుకుని దహనబలి యొక్క బలిపీఠం కొమ్ములపై పూసి మిగిలిన రక్తాన్ని బలిపీఠం అడుగున పోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","అతడు సమాధాన బలిపశువు క్రొవ్వును కాల్చినట్టే దీని క్రొవ్వంతా తీసి బలిపీఠం మీద కాల్చాలి. ఈ విధంగా యాజకుడు ఆ నాయకుడు చేసిన పాపానికి ప్రాయశ్చిత్తం చేస్తాడు, అప్పుడు అతడు క్షమించబడతాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘సమాజంలోని ఏ సభ్యుడైనా అనుకోకుండ పాపం చేసి, యెహోవా ఆజ్ఞలలో నిషేధించబడిన దేనినైన చేస్తే, వారు అపరాధులు, ");
INSERT INTO telotsa_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","వారు చేసిన పాపం తెలియ వచ్చినప్పుడు, వారు చేసిన పాపం కోసం తమ అర్పణగా లోపం లేని ఆడ మేకను తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","వారు పాపపరిహారబలి యొక్క తలపై చేయి ఉంచి, దహనబలి చేసిన స్థలంలో దానిని వధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","అప్పుడు యాజకుడు తన వ్రేలితో కొంత రక్తాన్ని తీసుకుని దహనబలి యొక్క బలిపీఠం కొమ్ములపై పూసి మిగిలిన రక్తాన్ని బలిపీఠం అడుగున పోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","సమాధానబలి నుండి క్రొవ్వును తీసినట్లే వారు కొవ్వంతా తీస్తారు, యాజకుడు దానిని బలిపీఠం మీద యెహోవాకు ఇష్టమైన సువాసనగా కాల్చాలి. ఈ విధంగా యాజకుడు వారికి ప్రాయశ్చిత్తం చేస్తాడు, వారు క్షమించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘ఎవరైనా తమ పాపపరిహారబలిగా గొర్రెపిల్లను తెస్తే, వారు లోపం లేని ఆడదానిని తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","వారు దాని తలపై చేయి వేసి దహనబలిని వధించిన స్థలంలో దానిని పాపపరిహారబలిగా వధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","అప్పుడు యాజకుడు పాపపరిహారబలిలో కొంత రక్తాన్ని తన వ్రేలితో తీసుకుని దహనబలి యొక్క బలిపీఠం కొమ్ములపై పూసి మిగిలిన రక్తాన్ని బలిపీఠం అడుగున పోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","సమాధానబలి యొక్క గొర్రెపిల్ల నుండి క్రొవ్వును తీసినట్లే వారు సమస్త క్రొవ్వును తీస్తారు, యాజకుడు దానిని యెహోవాకు సమర్పించిన హోమబలుల పైన బలిపీఠం మీద కాల్చాలి. ఈ విధంగా యాజకుడు వారు చేసిన పాపానికి ప్రాయశ్చిత్తం చేస్తాడు, వారు క్షమించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘ఒకవేళ ఎవరైనా ఒట్టు పెట్టుకోవడం వల్ల తాము చూసిన దాని గురించి గాని తమకు తెలిసిన దాని గురించి గాని నిజం చెప్పాల్సి ఉండి దాని గురించి వారు మాట్లాడకుండా పాపం చేస్తే, దానికి వారే శిక్షను భరిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘ఒకవేళ ఎవరైనా తాము అపరాధులని తెలుసుకుంటే పొరపాటున ఆచారరీత్య అపవిత్రమైన దానిని తాకితే (అపవిత్రమైన జంతువు కళేబరం, అది అడవిదైనా పెంపుడుదైనా, లేదా భూమి మీద ప్రాకే జీవియైనా కావచ్చు), వారు అపవిత్రులయ్యారు అని వారికి అవగాహన లేకపోతే, తర్వాత తాము గ్రహిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","లేదా ఒకవేళ వారు పొరపాటున మనుష్యులను అపవిత్రం చేసే దేనినైనా తాకితే, దాని గురించి తెలుసుకున్నా తర్వాత వారు అపరాధులు అవుతారు, ");
INSERT INTO telotsa_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","లేదా మనుష్యులెవరైనా అనాలోచితంగా మంచి గాని చెడు గాని చేస్తానని పొరపాటున ప్రమాణం చేసి, దాని గురించి తెలిసిన తర్వాత వారు అపరాధులు అని గ్రహిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ఎవరైనా ఈ విషయాల్లో అపరాధులని గ్రహిస్తే, వారు ఏ విధంగా పాపం చేశారో అది ఒప్పుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","వారు చేసిన పాపానికి జరిమానాగా, వారు మంద నుండి ఆడ గొర్రెపిల్ల లేదా మేకను పాపపరిహారబలిగా యెహోవా దగ్గరకు తీసుకురావాలి; యాజకుడు వారి పాపానికి ప్రాయశ్చిత్తం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘గొర్రెపిల్లను కొనలేని వారెవరైనా వారి పాపానికి జరిమానాగా రెండు పావురాలు లేదా రెండు చిన్న గువ్వలను యెహోవా దగ్గరకు తీసుకురావాలి, వాటిలో ఒకటి పాపపరిహారబలి కోసం మరొకటి దహనబలి కోసము. ");
INSERT INTO telotsa_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","అతడు వాటిని యాజకుడి దగ్గరకు తీసుకురావాలి, యాజకుడు మొదట పాపపరిహారబలి అర్పిస్తాడు. అతడు దాని తలను దాని మెడ నుండి పూర్తిగా వేరు చేయకుండ, మెలిపెట్టాలి, తల విరిచేయకూడదు, ");
INSERT INTO telotsa_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","పాపపరిహారబలి యొక్క రక్తంలో కొంత భాగాన్ని బలిపీఠం వైపు చల్లాలి; మిగిలిన రక్తం బలిపీఠం యొక్క అడుగు నుండి బయటకు పంపాలి. ఇది పాపపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","యాజకుడు మరొకదాన్ని నిర్ణీత విధానంలో దహనబలిగా అర్పించి, వారు చేసిన పాపానికి ప్రాయశ్చిత్తం చేయాలి, వారు క్షమించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘అయితే, ఒకవేళ వారు రెండు పావురాలు లేదా రెండు గువ్వలను కొనలేకపోతే, వారు తమ పాపానికి బలిగా పాపపరిహారబలి కోసం ఒక ఓమెరు నాణ్యమైన పిండి తీసుకురావాలి. వారు దానిపై ఒలీవనూనె గాని ధూపం గాని పెట్టకూడదు, ఎందుకంటే అది పాపపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","వారు దానిని యాజకుని దగ్గరకు తీసుకురావాలి, అతడు దానిలో ఒక చేతినిండ భాగాన్ని జ్ఞాపక భాగంగా తీసుకుని యెహోవాకు సమర్పించిన హోమబలుల పైన బలిపీఠం మీద కాల్చాలి. ఇది పాపపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ఈ విధంగా యాజకుడు వారు చేసిన ఈ పాపాల్లో దేనికోసమైనా ప్రాయశ్చిత్తం చేస్తాడు, వారు క్షమించబడతారు. మిగిలిన అర్పణ, భోజనార్పణ మాదిరిగానే యాజకునికి చెందుతుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“యెహోవాకు చెందిన పరిశుద్ధమైన వాటిలో దేని విషయంలోనైనా, ఎవరైనా అనుకోకుండ పాపం చేసి ఎవరైనా యెహోవా పట్ల నమ్మకద్రోహులైతే, వారు మంద నుండి లోపం లేని, పరిశుద్ధాలయం యొక్క షెకెల్ ప్రకారం, వెండిలో సరియైన విలువగల ఒక పొట్టేలును ప్రాయశ్చిత్తంగా తీసుకురావాలి. ఇది అపరాధపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ఆ వ్యక్తి పవిత్ర పదార్థం విషయంలో తప్పిదం చేసినందుకు, అధనంగా దాని విలువలో అయిదవ వంతు నష్టపరిహారం చెల్లించి అదంతా యాజకునికి ఇవ్వాలి. యాజకుడు పొట్టేలును అపరాధపరిహారబలిగా వారికి ప్రాయశ్చిత్తం చేస్తాడు, వారు క్షమించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ఎవరైనా పాపం చేసి, యెహోవా ఆజ్ఞలలో నిషేధించబడిన దేనినైన చేసినప్పుడు, అది వారికి తెలియకపోయినా సరే, వారు అపరాధులు, కాబట్టి వారు శిక్ష భరిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","వారు మంద నుండి అపరాధపరిహారబలిగా, ఒక లోపం లేని, సరియైన విలువగల పొట్టేలును యాజకుని దగ్గరకు తీసుకురావాలి. ఈ విధంగా యాజకుడు వారు అనుకోకుండ చేసిన తప్పుకు ప్రాయశ్చిత్తం చేస్తాడు, వారు క్షమించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ఇది అపరాధ పరిహారార్థబలి; అతడు యెహోవాకు విరోధంగా తప్పు చేసినందుకు అపరాధి అయ్యాడు.” ");
INSERT INTO telotsa_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","3","“ఒకవేళ మనుష్యులెవరైనా తన పొరుగువాడు తనకు అప్పగించిన దాని విషయంలో ఆ వ్యక్తిని మోసం చేసినా, వంచించినా, దోచుకున్నా, లేక ఒత్తిడిచేసినా, లేక పొరుగువాడు పోగొట్టుకున్న వస్తువు దొరికినా సరే దాని విషయం అబద్ధం చెప్పినా, ఒట్టు పెట్టి మరీ అబద్ధం చెప్పినా, ఇంకా ఇలాంటి వాటి విషయాల్లో పాపం చేస్తే అది యెహోవాకు వ్యతిరేకంగా ఆయన ఆజ్ఞలను ఉల్లంఘించి చేసిన పాపమే అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","వారు వీటిలోని దేని విషయంలోనైనా పాపం చేసి తమ అపరాధాన్ని గ్రహిస్తే, వారు దొంగిలించిన లేదా దోపిడి ద్వారా తీసుకున్నా, లేదా వారికి అప్పగించబడినదైనా, లేదా పోయిన ఆస్తి తిరిగి దొరికినదైనా, ");
INSERT INTO telotsa_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","లేదా వారు అబద్ధ ప్రమాణం చేసినదైనా, వారు తప్పక పూర్తి నష్టపరిహారం చెల్లించాలి, దానికి దాని వెలలో అయిదవ వంతు కలిపి వారు తమ అపరాధపరిహారబలి సమర్పించే రోజున దానినంతటిని యజమానికి ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","నిర్ణయించిన విలువ ప్రకారం వారు మందలో నుండి యెహోవాకు అపరాధపరిహారబలిగా ఒక లోపం లేని పొట్టేలును జరిమానాగా యాజకుని దగ్గరకు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ఈ విధంగా యాజకుడు యెహోవా ఎదుట వారి కోసం ప్రాయశ్చిత్తం చేస్తాడు, వారు అపరాధులవడానికి కారణమైన కృత్యాల నుండి వారు క్షమించబడతారు.” ");
INSERT INTO telotsa_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“అహరోనుకు అతని కుమారులకు ఈ ఆజ్ఞ ఇవ్వు: ‘ఇది దహనబలికి సంబంధించిన నియమం: దహనబలి రాత్రి నుండి ఉదయం వరకు బలిపీఠం పొయ్యిపై ఉండాలి, బలిపీఠం మీద అగ్ని మండుతూ ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","యాజకుడు తన నారబట్టలు నారలోదుస్తులు వేసుకుని, బలిపీఠం మీద అగ్నికి కాలిపోయిన దహనబలి అర్పణ బూడిదను తీసి బలిపీఠం ప్రక్కన ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","తర్వాత అతడు ఈ బట్టలు విడిచి వేరే దుస్తులు ధరించి శిబిరం బయట ఆచార ప్రకారంగా శుభ్రంగా ఉన్న స్థలానికి ఆ బూడిద తీసుకెళ్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","బలిపీఠం మీద అగ్ని మండుతూ ఉండాలి; అది ఆరిపోకూడదు. ప్రతి ఉదయం యాజకుడు దాని మీద కట్టెలు పేర్చి, మంట మీద దహనబలి ఉంచి సమాధానబలుల క్రొవ్వును దహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","బలిపీఠం మీద అగ్ని నిత్యం మండుతూ ఉండాలి; అది ఆరిపోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘ఇవి భోజనార్పణకు సంబంధించిన నియమాలు: అహరోను కుమారులు యెహోవా ఎదుట బలిపీఠం ఎదురుగా దానిని అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","యాజకుడు భోజనార్పణలో నుండి పిడికెడు నాణ్యమైన పిండిని కొంచెం ఒలీవ నూనెను సాంబ్రాణి మొత్తాన్ని తీసుకుని వాటిని జ్ఞాపక భాగంగా బలిపీఠం మీద యెహోవాకు ఇష్టమైన సువాసనగా దహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","అందులో మిగిలింది అహరోను అతని కుమారులు తినాలి, అయితే పరిశుద్ధాలయ ప్రాంతంలో పులియకుండా దానిని తినాలి; సమావేశ గుడారం యొక్క ఆవరణంలో వారు దానిని తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","దానిని పులిసిన దానితో కలిపి కాల్చకూడదు; నాకు సమర్పించిన హోమబలులలో నేను దానిని వారి వాటాగా ఇచ్చాను. పాపపరిహారబలిలా అపరాధపరిహారబలిలా, ఇది అతిపరిశుద్ధము. ");
INSERT INTO telotsa_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","అహరోను వంశస్థుడు ఎవరైనా దానిని తినవచ్చు. అన్ని తరాలకు ఇది యెహోవాకు సమర్పించబడే హోమబలులలో అతని శాశ్వత వాటా. వాటిని ఏది తాకినా అది పవిత్రమవుతుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","యెహోవా మోషేకు ఇలా కూడా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“అహరోను అభిషేకించబడిన రోజున అతడు, అతని కుమారులు యెహోవా దగ్గరకు తీసుకురావలసిన అర్పణ ఇది: భోజనార్పణగా ఒక ఓమెరు నాణ్యమైన పిండి ఉదయం సగం, సాయంత్రం సగం అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","దానిని పెనం మీద నూనెతో కాల్చాలి; బాగా కాల్చి ముక్కలుగా చేసిన భోజనార్పణను యెహోవాకు ఇష్టమైన సువాసనగా సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ప్రధాన యాజకునిగా అతని తర్వాత వచ్చే కుమారుడు దానిని సిద్ధం చేయాలి. ఇది యెహోవాకు శాశ్వత వాటా, ఇది పూర్తిగా దహించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","యాజకుడు అర్పించే ప్రతి భోజనార్పణను పూర్తిగా దహించబడాలి; దానిని తినకూడదు.” ");
INSERT INTO telotsa_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“అహరోను, అతని కుమారులకు ఇలా చెప్పు: ‘పాపపరిహారబలికి సంబంధించిన నియమాలు ఇవే: దహనబలిని వధించే స్థలంలోనే పాపపరిహారబలి పశువులను కూడా యెహోవా ఎదుట వధించాలి. అది అతిపరిశుద్ధము. ");
INSERT INTO telotsa_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","పాపపరిహారం కోసం దానిని అర్పించే యాజకుడు దానిని తినాలి; పరిశుద్ధాలయ ప్రాంతంలో, సమావేశ గుడారం యొక్క ఆవరణంలో దానిని తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","బలి మాంసానికి తగిలే ప్రతిదీ పవిత్రమవుతుంది, దాని రక్తంలో కొంచెమైనా సరే వస్త్రం మీద పడితే ఆ వస్త్రాన్ని మీరు పరిశుద్ధాలయ ప్రాంతంలో ఉతకాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ఆ మాంసం వండిన మట్టికుండను పగులగొట్టాలి. ఒకవేళ ఇత్తడి పాత్రలో వండితే, దానిని తోమి నీళ్లతో కడగాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","యాజకుడి కుటుంబంలో ప్రతి పురుషుడు దానిని తినాలి. అది అతిపరిశుద్ధము. ");
INSERT INTO telotsa_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","కాని పరిశుద్ధ స్థలంలో ప్రాయశ్చిత్తం చేయటానికి సమావేశ గుడారంలోకి తేబడిన రక్తం ఏ పాపపరిహారబలిదైనాసరే తినకూడదు; దానిని కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘అతిపరిశుద్ధమైన, అపరాధపరిహారబలికి సంబంధించిన నియమాలు ఇవి: ");
INSERT INTO telotsa_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","దహనబలి వధించబడిన స్థలంలోనే అపరాధపరిహారబలిని వధించాలి, దాని రక్తాన్ని బలిపీఠం చుట్టూ చల్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","దాని కొవ్వంతా అనగా క్రొవ్విన తోక, లోపలి అవయవాలపై ఉన్న క్రొవ్వు, ");
INSERT INTO telotsa_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","రెండు మూత్రపిండాలు, నడుము దగ్గర వాటి మీద ఉన్న క్రొవ్వు, మూత్రపిండాలతో పాటు తొలగించే కాలేయం మీది క్రొవ్వు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","యెహోవాకు అర్పించిన హోమబలిగా యాజకుడు వాటిని బలిపీఠం మీద కాల్చివేయాలి. ఇది అపరాధపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","యాజకుల కుటుంబాలలో ప్రతి పురుషుడు దాన్ని పరిశుద్ధాలయ ప్రాంగణంలో తినవచ్చు; అది అతిపరిశుద్ధము. ");
INSERT INTO telotsa_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘అదే నియమం పాపపరిహారబలి, అపరాధపరిహారబలి, రెండింటికీ వర్తిస్తుంది: వాటితో ప్రాయశ్చిత్తం చేసే యాజకునికి అవి చెందుతాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","దహనబలి తెచ్చినప్పుడు దాన్ని అర్పించే యాజకునికి ఆ బలి పశువు చర్మం చెందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ప్రతి భోజనార్పణ, పొయ్యిమీద వండిందైనా కుండలో లేదా పెనం మీద చేయబడినదైనా గాని, అర్పించే యాజకునికి చెందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ప్రతి భోజనార్పణ, ఒలీవనూనెతో కలిపినదైనా లేదా పొడిగా ఉన్నదైనా, అహరోను కుమారులందరికి సమానంగా చెందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘ఎవరైనా యెహోవాకు సమాధానబలి సమర్పించాలంటే నియమాలు ఇవి: ");
INSERT INTO telotsa_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘ఒకవేళ వారు దానిని కృతజ్ఞత అర్పణగా అర్పిస్తే, కృతజ్ఞతార్పణతో పాటు వారు ఒలీవనూనె కలిపి చేసిన పులియని మందమైన రొట్టెలు, నూనె రాసి తయారుచేసిన పులియని సన్నని రొట్టెలు, నూనె కలిపి మెత్తగా పిసికిన నాణ్యమైన పిండితో తయారుచేసిన మందమైన రొట్టెలు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","కృతజ్ఞతతో కూడిన సమాధానబలితో పాటు వారు పులిసిన మందమైన రొట్టెలను సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","వారు ప్రతి దానిలో నుండి ఒకదాన్ని అర్పణగా, యెహోవాకు ప్రత్యేక నైవేద్యంగా తీసుకురావాలి; అది బలిపీఠం వైపు సమాధానబలి రక్తాన్ని ప్రోక్షించిన యాజకునికి చెందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","కృతజ్ఞతతో అర్పించిన సమాధానబలి మాంసం అది అర్పించిన రోజే వారు తినాలి; ఉదయం వరకు అందులో దేన్ని మిగిలించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘ఒకవేళ వారి అర్పణ మ్రొక్కుబడి కోసం గాని, స్వేచ్ఛార్పణ గాని అయితే, దానిని అర్పించిన రోజే తినాలి, అయితే మిగిలింది మరుసటిరోజు తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","మూడవ రోజు ఆ బలి మాంసంలో ఏమైనా మిగిలితే దానిని కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","సమాధానబలి మాంసం మూడవ రోజు కాబట్టి తింటే దానిని అర్పించిన వారు అంగీకరించబడరు. తెచ్చిన వానికి గుర్తింపు ఉండదు, ఎందుకంటే అది అపవిత్రమైంది; కాబట్టి దానిలో ఏదైన తింటే వారు దోషశిక్షను భరిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘మాంసానికి ఏదైనా ఆచారరీత్య అపవిత్ర పదార్థం తగిలితే అది తినకూడదు. అది కాల్చివేయాలి. ఇతర మాంసం అయితే ఆచార ప్రకారం శుభ్రంగా ఉన్నవారు తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","కాని అపవిత్రంగా ఉన్న ఎవరైనా యెహోవాకు చెందిన సమాధానబలి మాంసం తింటే, వారు తమ ప్రజల్లో నుండి తొలగించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ఎవరైనా అపవిత్రమైన దాన్ని అది మానవ అపవిత్రత గాని అపవిత్రమైన జంతువునే గాని నేలపై ప్రాకే జీవులనే గాని తాకి, యెహోవాకు చెందిన సమాధానబలి మాంసం తింటే, వారు తమ ప్రజల్లో నుండి తొలగించబడాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“నీవు ఇశ్రాయేలీయులకు ఇలా చెప్పు: ‘పశువులదే గాని గొర్రెలదే గాని లేదా మేకలదే గాని క్రొవ్వును మీరు తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","చచ్చిన జంతువు క్రొవ్వును లేదా అడవి మృగాలు చీల్చిన జంతువు క్రొవ్వును దేనికైనా ఉపయోగించవచ్చు కాని దానిని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ఎవరైనా యెహోవాకు హోమబలిగా అర్పించే జంతువు యొక్క క్రొవ్వును తింటే వారు తమ ప్రజల్లో నుండి తొలగించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","మీరు నివసించే చోట పక్షి రక్తం గాని, జంతు రక్తం గాని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ఎవరైనా రక్తాన్ని తింటే వారు తమ ప్రజల్లో నుండి తొలగించబడాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘ఎవరైనా యెహోవాకు సమాధానబలిని తెస్తే, దానిలో ఒక భాగాన్ని ప్రత్యేకంగా యెహోవాకు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","వారు తమ స్వహస్తాలతో హోమబలిని యెహోవాకు అర్పించాలి; వారు రొమ్ము భాగాన్ని దాని మీద ఉన్న క్రొవ్వుతో పాటు తెచ్చి, ఆ రొమ్ము భాగాన్ని యెహోవా ఎదుట పైకెత్తి ప్రత్యేక అర్పణగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","యాజకుడు ఆ క్రొవ్వును బలిపీఠం మీద దహించాలి, కాని రొమ్ము భాగం అహరోను, అతని కుమారులకు చెందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","సమాధానబలులలో నుండి తీసిన కుడి తొడను యాజకునికి కానుకగా ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","అహరోను కుమారులలో ఎవరైతే సమాధానబలి రక్తాన్ని, క్రొవ్వును అర్పిస్తాడో అతడు ఆ కుడి తొడను తన వాటాగా తీసుకోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ఇశ్రాయేలీయుల సమాధానబలులలో నుండి నేను పైకెత్తిన రొమ్ము భాగాన్ని, అర్పించిన తొడను తీసుకుని యాజకుడైన అహరోనుకు అతని కుమారులకు ఇశ్రాయేలీయుల నుండి శాశ్వత వాటాగా ఇచ్చాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ఇది యెహోవాకు అర్పించిన హోమబలులలో అహరోను, అతని కుమారులు యెహోవాకు యాజకులుగా సేవ చేయడానికి సమర్పించబడిన రోజున వారికి కేటాయించబడిన వాటా. ");
INSERT INTO telotsa_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","వారు అభిషేకించబడిన రోజున, ఇశ్రాయేలీయులు రాబోయే తరాలకు తమ శాశ్వత వాటాగా ఇవ్వాలని యెహోవా ఆజ్ఞాపించారు. ");
INSERT INTO telotsa_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","దహనబలికి, భోజనార్పణకు, పాపపరిహారబలికి, అపరాధపరిహారబలికి, ప్రతిష్ఠార్పణకు, సమాధానబలికి ఇవి నియమాలు, ");
INSERT INTO telotsa_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","వీటిని ఇశ్రాయేలీయులు తమ అర్పణలను యెహోవా దగ్గరకు తీసుకురావాలని ఆజ్ఞాపించిన రోజున యెహోవా సీనాయి అరణ్యంలోని సీనాయి పర్వతం దగ్గర మోషేకు ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","యెహోవా మోషేతో చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“నీవు అహరోనును అతని కుమారులను, వారి వస్త్రాలను, అభిషేక తైలాన్ని, పాపపరిహారబలికి ఒక కోడెను, రెండు పొట్టేళ్లను గంపెడు పులియని రొట్టెలు తీసుకువచ్చి, ");
INSERT INTO telotsa_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","సమాజమంతటిని సమావేశ గుడారం యొక్క ద్వారం దగ్గర సమకూర్చాలి.” ");
INSERT INTO telotsa_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","యెహోవా ఆజ్ఞాపించినట్లు మోషే చేశాడు, అలాగే సమాజం సమావేశ గుడారం యొక్క ద్వారం దగ్గర సమావేశమయ్యింది. ");
INSERT INTO telotsa_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","“యెహోవా ఇలా చేయాలని ఆజ్ఞాపించారు” అని మోషే సమాజానికి చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","అప్పుడు మోషే, అహరోనును, అతని కుమారులను ముందుకు తెచ్చి నీటితో వారిని కడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","అతడు అహరోను మీద పైవస్త్రం వేసి, నడికట్టు కట్టి, ఏఫోదు వస్త్రాన్ని, అలాగే ఏఫోదును అతనికి ధరింపజేశాడు. అతడు ఏఫోదును అల్లబడిన నడికట్టుతో అతనికి చుట్టూ కట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","అతడు రొమ్ము పతకాన్ని అతనిపై ఉంచాడు, రొమ్ము పతకం లోపల ఊరీము తుమ్మీములను అమర్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు, అతడు అహరోను తలమీద తలపాగాను పెట్టి, దానికి బంగారు పలకను అమర్చి దానికి పవిత్ర చిహ్నాన్ని తగిలించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","తర్వాత మోషే అభిషేక తైలాన్ని తీసుకుని సమావేశ గుడారాన్ని, దానిలోని ప్రతిదాన్ని అభిషేకించి, వాటిని పవిత్రం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","అతడు బలిపీఠాన్ని, దాని పాత్రలన్నిటిని, దాని గంగాళాన్ని దాని పీటను ప్రతిష్ఠించడానికి, బలిపీఠం మీద ఏడుసార్లు కొంచెం నూనె చిలకరించి వాటిని అభిషేకించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","అహరోనును ప్రతిష్ఠించడానికి అభిషేక తైలంలో కొంచెం అతని తలమీద పోశాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","తర్వాత యెహోవా మోషేకు ఆజ్ఞాపించినట్లుగా అతడు అహరోను కుమారులను ముందుకు తీసుకువచ్చి, వారికి చొక్కాలు తొడిగించి నడికట్టు కట్టి, వారి తలల మీద టోపీలను పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","తర్వాత అతడు పాపపరిహారబలి కోసం ఎద్దును సమర్పించాడు, దాని తలపై అహరోను అతని కుమారులు తమ చేతులు ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","మోషే ఎద్దును వధించి, కొంత రక్తాన్ని తీసుకుని, బలిపీఠం శుద్ధి చేయడానికి, తన వ్రేలితో బలిపీఠపు కొమ్ముల మీద దానిని పూసాడు. మిగిలిన రక్తాన్ని అతడు బలిపీఠం అడుగున పోశాడు. కాబట్టి మోషే దానికి ప్రాయశ్చిత్తం చేసి దానిని ప్రతిష్ఠించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","మోషే లోపలి అవయవాల చుట్టూ ఉన్న క్రొవ్వునంతటిని, కాలేయం మీది క్రొవ్వు, రెండు మూత్రపిండాలు వాటి క్రొవ్వును తీసుకుని బలిపీఠం మీద కాల్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు, కోడెను, దాని చర్మాన్ని దాని మాంసాన్ని, దాని పేడను శిబిరం బయట కాల్చివేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","తర్వాత అతడు దహనబలికి పొట్టేలును తీసుకువచ్చినప్పుడు, దాని తలపై అహరోను అతని కుమారులు చేతులుంచారు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","అప్పుడు మోషే పొట్టేలును వధించి దాని రక్తాన్ని బలిపీఠం చుట్టూ చల్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","అతడు పొట్టేలును ముక్కలు చేసి తలను, ముక్కలను, క్రొవ్వును కాల్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు అతడు దాని లోపలి అవయవాలను కాళ్లను నీళ్లతో కడిగి పొట్టేలంతటిని బలిపీఠం మీద కాల్చాడు. అది దహనబలి, యెహోవాకు సమర్పించబడిన ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","తర్వాత మోషే మరొక పొట్టేలును అనగా యాజకుని నియామకం కోసం కావలసిన పొట్టేలును తీసుకువచ్చినప్పుడు, అహరోను అతని కుమారులు దాని తలమీద వారి చేతులుంచారు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","మోషే పొట్టేలును వధించి, దాని రక్తం కొంత తీసుకుని అహరోను కుడిచెవి అంచుకు, కుడిచేతి బొటన వ్రేలి మీద, కుడికాలి బొటన వ్రేలి మీద పూసాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","మోషే అహరోను కుమారులను కూడా ముందుకు పిలిచి వారి కుడిచెవి అంచుకు, కుడిచేతి బొటన వ్రేలి మీద, కుడికాలు బొటన వ్రేలి మీద పూసి మిగిలిన రక్తాన్ని బలిపీఠం చుట్టూ చల్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","తర్వాత దాని క్రొవ్వును, తోకకు ఉన్న క్రొవ్వును, లోపలి అవయవాలపై ఉన్న క్రొవ్వునంతటిని, కాలేయం మీది క్రొవ్వును, రెండు మూత్రపిండాలను వాటి క్రొవ్వును, వాటి కుడి తొడను తీసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","యెహోవా ఎదుట ఉన్న పులియని రొట్టెల గంపలో నుండి ఒక మందమైన రొట్టెను, ఒలీవనూనె కలిపి చేసిన ఒక మందమైన రొట్టెను, ఒక పల్చని రొట్టెను తీసుకుని, ఆ క్రొవ్వు మీద, కుడి తొడ మీద ఉంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","అవన్నీ అహరోను, అతని కుమారుల చేతుల్లో పెట్టగా, వారు యెహోవా ఎదుట వాటిని పైకెత్తి ప్రత్యేక అర్పణగా అర్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","తర్వాత మోషే వారి చేతుల్లో నుండి వాటిని తీసుకుని బలిపీఠం మీద ఉన్న దహనబలి మీదుగా ప్రతిష్ఠార్పణగా వాటిని కాల్చి, యెహోవాకు ఇష్టమైన సువాసనగల హోమబలిగా అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు, ప్రతిష్ఠార్పణకు చెందిన పొట్టేలులో మోషే వాటాయైన రొమ్ము భాగాన్ని కూడా తీసి పైకెత్తి దానిని యెహోవా ఎదుట ప్రత్యేక అర్పణగా అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","అప్పుడు మోషే కొంత అభిషేక తైలాన్ని, బలిపీఠం మీద నుండి కొంచెం రక్తాన్ని తీసుకుని అహరోను మీద అతని వస్త్రాల మీద, అతని కుమారుల మీద వారి వస్త్రాల మీద చిలకరించాడు. ఇలా అతడు అహరోనును అతని వస్త్రాలను, అతని కుమారులను వారి వస్త్రాలను ప్రతిష్ఠించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","అప్పుడు మోషే అహరోనుతో, అతని కుమారులతో, “సమావేశ గుడారపు ద్వారం దగ్గర మాంసాన్ని వండి ప్రతిష్ఠార్పణల గంపలోని రొట్టెలతో తినాలి, నాకు ఆజ్ఞాపించబడిన ప్రకారం, ‘అహరోను అతని కుమారులు దానిని తినాలి.’ ");
INSERT INTO telotsa_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","తర్వాత మిగిలిన మాంసాన్ని, రొట్టెను కాల్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","మీ నియామక రోజులు పూర్తయ్యే వరకు ఏడు రోజులు సమావేశ గుడారపు ద్వారాన్ని విడిచివెళ్లవద్దు, ఎందుకంటే మీ నియామకం ఏడు రోజులు ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ఈ రోజు జరిగింది యెహోవా ఆజ్ఞాపించిన ప్రకారం మీ కోసం ప్రాయశ్చిత్తం చేయడానికి జరిగింది. ");
INSERT INTO telotsa_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","మీరు సమావేశ గుడారం యొక్క ద్వారం దగ్గర ఏడు రోజులు రాత్రింబగళ్ళు ఉండి యెహోవా ఏం చేయమంటారో అది చేయాలి, అప్పుడు మీరు చావరు; ఎందుకంటే నాకివ్వబడిన ఆజ్ఞ ఇదే” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","కాబట్టి అహరోను అతని కుమారులు యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం ప్రతిదీ చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ఎనిమిదవ రోజు మోషే అహరోనును అతని కుమారులను, ఇశ్రాయేలు గోత్ర పెద్దలను పిలిపించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","అతడు అహరోనుతో ఇలా అన్నాడు, “మీ పాపపరిహారబలి కోసం ఏ లోపం లేని ఒక మగ దూడను, మీ దహనబలికి ఒక లోపం లేని పొట్టేలును తీసుకువచ్చి వాటిని యెహోవా ఎదుట సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","అప్పుడు నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘పాపపరిహారబలి కోసం లోపం లేని ఒక మేకపోతును దహనబలి కోసం లోపం లేని ఒక దూడను, ఒక గొర్రెపిల్లను తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","యెహోవా ఎదుట బలి అర్పించడానికి సమాధానబలికి ఎద్దును, పొట్టేలును, ఒలీవనూనె కలిపిన భోజనార్పణతో పాటు తీసుకురండి. ఎందుకంటే యెహోవా ఈ రోజు మీకు ప్రత్యక్షమవుతారు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","వారు మోషే ఆజ్ఞాపించినట్లుగా సమావేశ గుడారం ఎదుటికి వాటన్నిటిని తీసుకువచ్చారు, అప్పుడు సమాజమంతా దగ్గరకు వచ్చి యెహోవా సన్నిధిలో నిలబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","అప్పుడు మోషే ఇలా అన్నాడు, “మీరు ఇలా చేయాలని యెహోవా ఆజ్ఞాపించారు, తద్వార యెహోవా మహిమ మీకు ప్రత్యక్షం అవుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","మోషే అహరోనుతో ఇలా అన్నాడు, “యెహోవా ఆజ్ఞాపించినట్లు బలిపీఠం దగ్గరకు వచ్చి, నీ పాపపరిహారబలిని, దహనబలిని అర్పించి, నీకోసం, ప్రజల కోసం ప్రాయశ్చిత్తం చేయాలి; ప్రజల కోసం అర్పణను అర్పించి వారి కోసం ప్రాయశ్చిత్తం చేయాలి.” ");
INSERT INTO telotsa_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","కాబట్టి అహరోను బలిపీఠం దగ్గరికి సమీపించి తన పాపపరిహారబలిగా కోడెను వధించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","అహరోను కుమారులు దాని రక్తాన్ని అతనికి అందించారు, ఆ రక్తంలో తన వ్రేలు ముంచి బలిపీఠం కొమ్ములకు రాశాడు. మిగిలిన రక్తాన్ని బలిపీఠం అడుగున పోశాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు బలిపీఠం మీద పాపపరిహారబలిగా దాని క్రొవ్వును, మూత్రపిండాలను, కాలేయం దగ్గర ఉన్న క్రొవ్వును దహించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","దాని మాంసాన్ని, చర్మాన్ని, శిబిరం బయట పూర్తిగా కాల్చివేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","తర్వాత అతడు దహనబలిని వధించాడు. అహరోను కుమారులు రక్తాన్ని అతనికి అందించగా, అతడు దానిని బలిపీఠం చుట్టూరా చల్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","వారు అతనికి దహనబలి తలను దాని ముక్కలను ఇవ్వగా, అతడు వాటిని బలిపీఠం మీద కాల్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","లోపలి అవయవాలను, కాళ్లను కడిగి బలిపీఠం మీద ఉన్న దహనబలిపైన వాటిని కాల్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","అప్పుడు అహరోను ప్రజల అర్పణను తీసుకువచ్చాడు. అతడు ప్రజల పాపపరిహారబలి కోసం మేకను తీసుకుని దానిని వధించి మొదటి దానిని చేసినట్లుగానే దీన్ని కూడా పాపపరిహారబలిగా అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","అతడు దహనబలిని తెచ్చి సూచించబడినట్టే అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","అతడు భోజనార్పణ కూడా తీసుకువచ్చి, దానిలో నుండి పిడికెడు తీసి బలిపీఠంపై దానిని ఉదయం చెల్లించాల్సిన దహనబలితో పాటు దహించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ప్రజల నిమిత్తం అహరోను సమాధానబలిగా ఎద్దును, పొట్టేలును వధించాడు. అతని కుమారులు అతనికి రక్తాన్ని అందించగా, అతడు బలిపీఠం చుట్టూరా దానిని చల్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ఎద్దు క్రొవ్వును, పొట్టేలు క్రొవ్వును, క్రొవ్విన తోకను, లోపల అవయవాల మీద ఉన్న క్రొవ్వును, మూత్రపిండాలను, కాలేయం మీది క్రొవ్వును ");
INSERT INTO telotsa_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","బోరల మీద వేశారు, అహరోను ఆ క్రొవ్వును బలిపీఠం మీద కాల్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","మోషే ఆజ్ఞాపించినట్టు అహరోను రొమ్ము భాగాన్ని, కుడి తొడను పైకెత్తి ఊపి యెహోవా ఎదుట ప్రత్యేక అర్పణగా అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","తర్వాత అహరోను ప్రజల వైపు చేతులెత్తి వారిని దీవించాడు. పాపపరిహారబలి, దహనబలి, సమాధానబలి అర్పించిన తర్వాత బలిపీఠం నుండి దిగివచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","అప్పుడు మోషే అహరోనులు కలిసి సమావేశ గుడారం లోనికి వెళ్లారు. వారు బయటకు వచ్చినప్పుడు ప్రజలను దీవించారు; యెహోవా మహిమ ప్రజలందరికి కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","యెహోవా సన్నిధి నుండి అగ్ని వచ్చి బలపీఠం మీద ఉన్న దహనబలిని క్రొవ్వు భాగాలను కాల్చివేసింది. అది చూసి ప్రజలంతా ఆనందంతో కేకలువేస్తూ సాగిలపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","అహరోను కుమారులు నాదాబు, అబీహు తమ ధూపార్తులను తీసుకుని, వాటిలో నిప్పు ఉంచి దానిపై ధూపం వేశారు; వారు యెహోవా ఎదుట ఆయన ఆజ్ఞకు విరుద్ధంగా అనధికార అగ్నిని సమర్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","కాబట్టి యెహోవా సన్నిధి నుండి అగ్ని వచ్చి వారిని దహించివేయగా, వారు యెహోవా ఎదుట చనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","అప్పుడు మోషే అప్పుడు అహరోనుతో ఇలా అన్నాడు, “యెహోవా ఇలా చెప్పారు: “ ‘నన్ను సమీపించేవారి ద్వారా నేను నా పరిశుద్ధతను కనుపరచుకుంటాను; ప్రజలందరి దృష్టిలో నేను ఘనపరచబడతాను.’ ” అహరోను మౌనంగా ఉండిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","మోషే అహరోను పినతండ్రియైన ఉజ్జీయేలు కుమారులైన మిషాయేలు, ఎల్సాఫానులను పిలిపించి వారితో, “ఇక్కడకు రండి; మీ బంధువులను పరిశుద్ధాలయం ఎదుట నుండి, బయటకు తీసుకెళ్లండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","కాబట్టి వారు వచ్చి, మోషే ఆజ్ఞాపించినట్లుగా, శిబిరం బయట ఇప్పటికీ తమ వస్త్రాలతో వాటిని తీసుకెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","మోషే అహరోనుతో అతని కుమారులైన ఎలియాజరు, ఈతామారులతో, “మీరు చావకూడదన్నా, యెహోవా ఆగ్రహం ఈ సమాజం మీదికి రావద్దన్నా మీరు మీ జుట్టు విరబోసుకోవద్దు, మీ బట్టలు చింపుకోవద్దు, అయితే యెహోవా అగ్నితో వారిని నాశనం చేసినందుకు మీ బంధువులైన ఇశ్రాయేలీయులందరు దుఃఖించవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","యెహోవా యొక్క అభిషేక తైలం మీమీద ఉంది కాబట్టి సమావేశ గుడారం యొక్క ప్రవేశం వదిలి వెళ్లొద్దు, వెళ్తే మీరు చస్తారు” అని అన్నాడు. కాబట్టి వారు మోషే చెప్పినట్లు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","తర్వాత యెహోవా అహరోనుతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“నీవూ, నీ కుమారులు సమావేశ గుడారంలోకి ఎప్పుడు వెళ్లినా మద్యం త్రాగకూడదు ఇతర పులిసిన పానీయం త్రాగకూడదు, ఒకవేళ అలా చేస్తే మీరు చస్తారు. మీ రాబోయే తరాలకు ఇది నిత్య సంస్కారంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","పరిశుద్ధమైన దానికి సాధారణమైన దానికి, అపవిత్రమైన దానికి పవిత్రమైన దానికి మధ్య ఉన్న వ్యత్యాసాన్ని గుర్తించగలిగేలా, ");
INSERT INTO telotsa_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","యెహోవా మోషే ద్వార ఇశ్రాయేలీయులకు ఇచ్చిన శాసనాలన్నిటిని మీరు వారికి బోధించాలి.” ");
INSERT INTO telotsa_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","మోషే అహరోనుతో అతని కుమారులలో మిగతా వారైన ఎలియాజరు, ఈతామారులతో ఇలా అన్నాడు, “యెహోవాకు సమర్పించిన హోమబలిలో మిగిలిన భోజనార్పణ పులుపు లేకుండ తీసుకుని బలిపీఠం ప్రక్కన తినండి, ఎందుకంటే అది అతిపరిశుద్ధమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","యెహోవాకు సమర్పించిన హోమబలులలో ఇది మీకు, మీ కుమారులకు ఇచ్చిన వాటా; దీనిని పరిశుద్ధాలయ ప్రాంతంలో తినండి; ఎందుకంటే నాకు అలాగే ఆజ్ఞ ఇవ్వబడింది. ");
INSERT INTO telotsa_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","కానీ నీవూ, నీ కుమారులు, మీ కుమార్తెలు పైకెత్తిన రొమ్ము భాగాన్ని, ప్రత్యేక అర్పణగా అర్పించిన తొడను తినవచ్చు. ఆచారరీత్య శుభ్రంగా ఉన్న స్థలంలో వాటిని తినండి; అవి నీకు, నీ పిల్లలకు ఇశ్రాయేలీయుల సమాధానబలులలో మీ వాటాగా ఇవ్వబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ప్రత్యేక అర్పణ యైన తొడను పైకెత్తిన రొమ్ము భాగాన్ని హోమబలుల క్రొవ్వుతో పాటు తీసుకువచ్చి, యెహోవా ఎదుట పైకెత్తి ప్రత్యేక అర్పణగా అర్పించాలి. యెహోవా ఆజ్ఞాపించినట్లు ఇది నీకు, నీ పిల్లలకు శాశ్వత వాటాగా ఉంటుంది.” ");
INSERT INTO telotsa_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","పాపపరిహారబలి కొరకైన మేక గురించి మోషే ఆరా తీయగా, అది కాలిపోయిందని తెలుసుకుని, అతడు అహరోను కుమారులలో మిగిలిన ఎలియాజరు, ఈతామారులపై కోప్పడి, ");
INSERT INTO telotsa_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“మీరు పాపపరిహారబలిని పరిశుద్ధాలయ ప్రాంగణంలో ఎందుకు తినలేదు? అది అతిపరిశుద్ధమైనది; సమాజం యొక్క అపరాధం యొక్క శిక్షను భరించి యెహోవా ఎదుట వారి కోసం ప్రాయశ్చిత్తం చేయడానికి ఆయన ఇది మీకు ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","దాని రక్తం పరిశుద్ధ స్థలంలోకి తేబడలేదు కాబట్టి నేను ఆజ్ఞాపించినట్లు, మీరు పరిశుద్ధాలయ ప్రాంతంలో మేకను తప్పక తిని ఉండాల్సింది” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","అందుకు అహరోను మోషేతో, “ఈ రోజు వారు యెహోవా ఎదుట వారి పాపపరిహారబలి, దహనబలి అర్పించారు, అయినా నా పట్ల ఇలాంటి విషాదం జరిగింది. ఈ రోజు ఒకవేళ నేను పాపపరిహారబలి తినివుంటే యెహోవా ఆనందించి ఉండేవారా?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ఆ మాటలు మోషే విని సంతృప్తి చెందాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","యెహోవా మోషే అహరోనులతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ఇశ్రాయేలీయులకు ఇలా చెప్పండి: ‘భూమి మీద జీవించే జంతువులన్నిటిలో మీరు తినదగిన జంతువులు: ");
INSERT INTO telotsa_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","చీలిన డెక్కలు కలిగి నెమరువేసే ఏ జంతువునైనా మీరు తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘కొన్ని కేవలం నెమరువేస్తాయి కొన్ని చీలిన డెక్కలు మాత్రమే కలిగి ఉంటాయి, వాటిని మీరు తినకూడదు. ఒంటెలు నెమరువేస్తాయి కానీ వాటికి చీలిన డెక్కలు లేవు; ఇవి మీకు ఆచారరీత్య అపవిత్రమైనవి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","అలాగే పొట్టి కుందేలు కూడా నెమరువేస్తుంది కాని దానికి చీలిన డెక్కలు లేవు; ఇది మీకు అపవిత్రమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","అలాగే కుందేలు నెమరువేస్తుంది గాని దానికి చీలిన డెక్కలు లేవు; ఇది మీకు అపవిత్రమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","పందికి చీలిన డెక్కలు ఉంటాయి కాని అది నెమరువేయదు; ఇది మీకు అపవిత్రమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","వాటి మాంసం తినవద్దు వాటి కళేబరాలు ముట్టుకోవద్దు; అవి మీకు అపవిత్రమైనవి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘సముద్రాల్లో నదులలో నివసించే జీవులన్నిటిలో రెక్కలు పొలుసులు గలవాటిని మీరు తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","సముద్రంలో గాని, నదిలో గాని నీటిలో కదిలే అన్ని రకాల జీవుల్లోను, నీటి ప్రాణుల్లోను రెక్కలు, పొలుసులు లేనివాటిని మీరు అపవిత్రమైనవిగా చూడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","అవి అపవిత్రమైనవి కాబట్టి వాటి మాంసం మీరు తినకూడదు; వాటి కళేబరాలను మీరు అసహ్యించుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","రెక్కలు, పొలుసులు లేని జలచరాలేవైనా అపవిత్రమైనవిగా చూడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘మీకు అపవిత్రమైనవిగా భావించి మీరు తినకూడని పక్షులు ఇవే: గ్రద్ద, రాబందు, నల్ల రాబందు, ");
INSERT INTO telotsa_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ఎర్ర గ్రద్ద, ప్రతి రకమైన నల్ల గ్రద్ద, ");
INSERT INTO telotsa_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ప్రతి రకమైన కాకి, ");
INSERT INTO telotsa_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","కొమ్ముల గుడ్లగూబ, జీరగపిట్ట, కోకిల, ప్రతి రకమైన డేగ, ");
INSERT INTO telotsa_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","పైడికంటే, చెరువు కాకి, గుడ్లగూబ, ");
INSERT INTO telotsa_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","హంస, గూడబాతు, నల్లబోరువ, ");
INSERT INTO telotsa_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","సంకు బుడ్డి కొంగ, ప్రతి రకమైన కొంగ, కూకుడు గువ్వ, గబ్బిలము. ");
INSERT INTO telotsa_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘నాలుగు కాళ్లతో నడిచే ఎగిరే పురుగులన్నీ మీకు అపవిత్రమైనవిగా మీరు భావించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","అయితే, నాలుగు కాళ్లతో నడుస్తూ నేలమీద గెంతడానికి కాళ్లకు కీళ్ళున్న ఎగిరే కీటకాలను మీరు తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","వీటిలో నేత మిడత గాని చిన్న మిడత గాని ఆకు మిడత గాని ప్రతి రకమైన మిడతను తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","కాని నాలుగు కాళ్లు ఉండి ఎగిరే ఇతర పురుగులన్నీ మీకు అపవిత్రమైనవి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘వీటి ద్వార మీరు అపవిత్రులవుతారు; వాటి కళేబరాలను ఎవరైనా తాకితే వారు సాయంత్రం వరకు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","వీటి కళేబరాలలో దేనినైన ఎవరైనా మోస్తే వారు తమ బట్టలు ఉతుక్కోవాలి, సాయంత్రం వరకు వారు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘చీలిన డెక్కలు లేని నెమరువేయని ప్రతి జంతువు మీకు అపవిత్రం; వాటిలో దేని కళేబరాన్నైనా ఎవరైనా తాకితే వారు అపవిత్రులవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","నాలుగు కాళ్ల జంతువులన్నిటిలో తమ పంజాలతో నడిచేవన్నీ అపవిత్రమైనవి; వాటిలో దేని కళేబరాన్నైనా ఎవరైనా తాకితే వారు సాయంత్రం వరకు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","వీటి కళేబరాలలో దేనినైన ఎవరైనా మోస్తే, వారు తమ బట్టలు ఉతుక్కోవాలి, సాయంత్రం వరకు వారు అపవిత్రంగా ఉంటారు. ఈ జంతువులు మీకు అపవిత్రమైనవి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘నేల మీద ప్రాకే జంతువుల్లో, మీకు అపవిత్రమైనవి ఇవే: ముంగీస, ఎలుక, ప్రతి రకమైన పెద్ద బల్లి, ");
INSERT INTO telotsa_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","తొండ, మచ్చల బల్లి, గోడ తొండ, ఉడుము, ఊసరవెల్లి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","భూమి మీద కదిలే వాటన్నిటిలో, ఇవి మీకు నిషేధమైనవి. అవి చనిపోయిన తర్వాత వాటి కళేబరాన్ని తాకినవారు సాయంత్రం వరకు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","అవి చనిపోయిన తర్వాత వాటి కళేబరం దేని పైననైన పడితే, అది చెక్క గాని, వస్త్రం గాని, చర్మం గాని గోనెసంచి గాని దేనితో చేసినదైనా, దాని ఉపయోగం ఏదైనా దానిని నీటిలో పెట్టండి; అది సాయంత్రం వరకు అపవిత్రం, తర్వాత అది పవిత్రమవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","వాటిలో ఏదైనా మట్టికుండలో పడితే, దానిలో ఉన్నదంతా అపవిత్రమవుతుంది, మీరు తప్పనిసరిగా ఆ కుండను పగులగొట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","మీరు తినదగిన ఏ ఆహారమైనా అలాంటి కుండలోని నీరు తగిలితే అది అపవిత్రమవుతుంది, ఎటువంటి పానీయమైనా సరే అలాంటి కుండలో నుండి త్రాగితే అది అపవిత్రము. ");
INSERT INTO telotsa_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","వాటి కళేబరాలలో కొంచెమైనా ఒకటి దేనిపైనైనా పడితే అది అపవిత్రమవుతుంది; అది పొయ్యి గాని లేదా వంటచేసే కుండ గాని తప్పకుండ పగులగొట్టబడాలి. అవి అపవిత్రమైనవి, మీరు వాటిని అపవిత్రమైనవిగా భావించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ఏదేమైనా, ఒక ఊటలో గాని లేదా నీటి తొట్టిలో గాని పవిత్రంగా ఉంటుంది, కానీ వీటిలో ఏదైన ఒకటి ఈ కళేబరాన్ని తాకితే వారు అపవిత్రమవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ఒకవేళ నాటబడవలసిన విత్తనాలపై కళేబరం పడితే, అవి పవిత్రంగా ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","కానీ ఒకవేళ విత్తనాలకు నీరు పెట్టిన తర్వాత, వాటిపై పడితే, అది మీకు అపవిత్రమవుతాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘ఒకవేళ మీరు తినదగిన జంతువుల్లో ఏదైనా చనిపోతే, దాని కళేబరాన్ని తాకిన ఎవరైనా సాయంత్రం వరకు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","దాని కళేబరంలో ఎవరైనా ఏదైనా తింటే వారు తమ బట్టలు ఉతుక్కోవాలి, వారు సాయంత్రం వరకు అపవిత్రంగా ఉంటారు. కళేబరాన్ని ఎవరైనా మోస్తే వారు బట్టలు ఉతుక్కోవాలి, వారు సాయంత్రం వరకు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘నేలపై ప్రాకే జీవులన్నీ అపవిత్రమైనవి; దానిని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","నేలమీద ప్రాకే జీవులలో పొట్ట మీద ప్రాకేవైనా లేదా నాలుగు కాళ్లతో లేదా అంతకన్నా ఎక్కువ కాళ్లతో నడిచేవైనా అవి మీకు అపవిత్రమైనవి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ప్రాకే జీవులను తిని మిమ్మల్ని మీరు అపవిత్రం చేసుకోకూడదు. వాటిని బట్టి గాని వాటి ద్వారా గాని మీరు అపవిత్రం కాకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","నేను మీ దేవుడనైన యెహోవాను; నేను పరిశుద్ధుడను కాబట్టి, మిమ్మల్ని మీరు ప్రతిష్ఠించుకుని పరిశుద్ధంగా ఉండండి. నేలపై ప్రాకే ఏ జీవిని బట్టి మిమ్మల్ని మీరు అపవిత్రం చేసుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","మీకు దేవునిగా ఉండాలని ఈజిప్టు నుండి మిమ్మల్ని బయటకు తెచ్చిన యెహోవాను నేనే; నేను పరిశుద్ధుడను కాబట్టి మీరు కూడా పరిశుద్ధంగా ఉండండి. ");
INSERT INTO telotsa_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘జంతువులు, పక్షులు, నీటిలో నివసించే ప్రతి జీవి, నేలపైన ప్రాకే జీవులకు సంబంధించిన నియమాలు ఇవే. ");
INSERT INTO telotsa_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","అపవిత్రమైన వాటికి పవిత్రమైన వాటికి మధ్య తేడాను, తినదగిన జీవులకు తినకూడని జీవులకు మధ్య తేడాను మీరు గుర్తించాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ఇశ్రాయేలీయులకు ఇలా చెప్పు: ‘ఒక స్త్రీ గర్భవతియై ఒక మగశిశువుకు జన్మనిస్తే నెలసరి సమయంలో ఉన్నట్లే ఆచారరీత్య ఆమె ఏడు రోజులు అపవిత్రురాలిగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ఆ మగశిశువుకు ఎనిమిదవ రోజున సున్నతి చేయించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","అప్పుడు స్త్రీ తన రక్తస్రావం నుండి శుద్ధి కావడానికి ముప్పై మూడు రోజులు వేచి ఉండాలి. శుద్ధీకరణ రోజులు పూర్తయే వరకు ఆమె పవిత్రమైన దేన్ని తాకకూడదు, పరిశుద్ధాలయానికి వెళ్లకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ఒకవేళ ఆమె ఆడపిల్లకు జన్మనిస్తే, ఆమె రెండు వారాలు అపవిత్రురాలిగా ఉంటుంది. అప్పుడు ఆమె రక్తస్రావం నుండి శుద్ధి కావడానికి అరవై ఆరు రోజులు వేచి ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘కుమారుని కోసం గాని కుమార్తె కోసం గాని ఆమె శుద్ధీకరణ రోజులు ముగిసిన తర్వాత ఆమె దహనబలి కోసం ఒక సంవత్సరపు గొర్రెపిల్లను, పాపపరిహారబలి కోసం ఒక చిన్న గువ్వను గాని పావురాన్ని గాని సమావేశ గుడార ద్వారం దగ్గర ఉన్న యాజకుని దగ్గరకు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ఆమె కోసం ప్రాయశ్చిత్తం చేయటానికి అతడు వాటిని యెహోవా ఎదుట అర్పించినప్పుడు ఆమె తన రక్తస్రావం నుండి ఆచారరీత్య శుద్ధి అవుతుంది. “ ‘మగశిశువుకు గాని ఆడపిల్లకు గాని జన్మనిచ్చే స్త్రీకి నియమాలు ఇవే. ");
INSERT INTO telotsa_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ఆమె ఒకవేళ గొర్రెపిల్లను కొనలేకపోతే, ఆమె గువ్వల జతను లేదా రెండు చిన్న పావురాలను తీసుకురావాలి. వాటిలో ఒకటి దహనబలి కోసం మరొకటి పాపపరిహారబలి కోసము. ఈ విధంగా యాజకుడు ఆమెకు ప్రాయశ్చిత్తం చేసినప్పుడు, ఆమె శుద్ధి అవుతుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","యెహోవా మోషే అహరోనులతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“మనుష్యులెవరికైనా వారి చర్మంపై వాపు లేదా దద్దుర్లు లేదా మెరిసే మచ్చ ఉన్నట్లయితే, అది అపవిత్రమైన కుష్ఠువ్యాధి కావచ్చు, వారు యాజకుడైన అహరోను దగ్గరకు లేదా యాజకుడుగా ఉన్న అతని కుమారులలో ఒకరి దగ్గరకు తీసుకురాబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","యాజకుడు వారి చర్మం మీద ఉన్న పుండును పరీక్షించాలి. ఆ పుండులో వెంట్రుకలు తెల్లబారి ఆ పుండు చర్మంలో లోతుగా ఉంటే అది కుష్ఠువ్యాధి యొక్క లక్షణము. యాజకుడు ఆ వారిని పరీక్షించి వారు ఆచారరీత్య అపవిత్రులని ప్రకటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","చర్మంలో మచ్చ మెరుస్తూ తెల్లగా ఉండి, చర్మం లోతుకంటే ఎక్కువ లేకపోతే అందులోని వెంట్రుకలు తెల్లగా మారకపోతే యాజకుడు వారిని ఏడు రోజులు వేరుగా ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ఏడవ రోజు యాజకుడు వారిని పరీక్షించాలి. చర్మం పుండు అలాగే ఉండి వ్యాపించకుండ ఉంటే యాజకుడు మరో ఏడు రోజులు వారిని వేరుగా ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ఏడవ రోజు యాజకుడు వారిని మళ్ళీ పరీక్షించాలి, పుండు క్షీణించి, చర్మంలో వ్యాపించకపోతే, యాజకుడు వారిని శుభ్రంగా ప్రకటించాలి; ఇది దద్దుర్లు మాత్రమే. వారు బట్టలు ఉతుక్కోవాలి, వారు శుభ్రంగా అవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","కాని వారు శుద్ధులని ప్రకటించబడడానికి యాజకునికి కనుపరచుకున్న తర్వాత దద్దుర్లు చర్మంలో వ్యాపిస్తే వారిని తిరిగి యాజకుని దగ్గరకు రావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","యాజకుడు ఆ వ్యక్తిని పరీక్షించాలి, ఒకవేళ దద్దుర్లు చర్మంలో వ్యాపించి ఉంటే, అతన్ని అపవిత్రునిగా ప్రకటించాలి; అది కుష్ఠువ్యాధి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“మనుష్యులెవరికైనా తీవ్రమైన కుష్ఠువ్యాధి ఉంటే, వారిని యాజకుని దగ్గరకు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","యాజకుడు వారిని పరీక్షించాలి, ఒకవేళ చర్మంలో తెల్లని వాపు ఉండి వెంట్రుకలు తెల్లగా మార్చి ఆ వాపులో ఒకవేళ పచ్చి మాంసం ఉంటే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ఇది దీర్ఘకాలిక కుష్ఠువ్యాధి, యాజకుడు వారిని అపవిత్రులని ప్రకటించాలి. అతడు వారిని ఒంటరి చేయకూడదు, ఎందుకంటే వారు అప్పటికే అపవిత్రమైనవారు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“యాజకుడు చూడగలిగినంతవరకు ఆ వ్యాధి వారి చర్మం అంతా వ్యాపించి ఉంటే, అది తల నుండి పాదం వరకు బాధిత వ్యక్తి యొక్క చర్మమంతా వ్యాపించి ఉంటే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","యాజకుడు వారిని పరీక్షించాలి, ఒకవేళ వ్యాధి వారి శరీరమంతా వ్యాపించి ఉంటే, అతడు వారిని పవిత్రులని ప్రకటించాలి. అదంతా తెల్లగా మారినందుకు, వారు పవిత్రులు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","కాని శరీరంలో పచ్చిపుండు కనిపిస్తే, వారు అపవిత్రులు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","యాజకుడు పచ్చిపుండును చూసినప్పుడు, అతడు వారిని అపవిత్రులని ప్రకటించాలి. పచ్చిపుండు అపవిత్రం; వారు తీవ్రమైన కుష్ఠువ్యాధి కలవారు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","పచ్చిపుండు మారి తెల్లబారితే వారు యాజకుని దగ్గరకు వెళ్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","యాజకుడు వారిని పరీక్షించి, ఒకవేళ పుండ్లు తెల్లబారి ఉంటే, యాజకుడు వారిని పవిత్రులని ప్రకటించాలి; అప్పుడు వారు పవిత్రులవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ఎవరికైనా వారి చర్మం మీద బొబ్బ వచ్చి మానిపోతే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","అది ఉండిన చోట, తెల్లని వాపు గాని లేదా గులాబి రంగు మచ్చ గాని కనిపిస్తే, వారు దానిని యాజకునికి చూపించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","యాజకుడు దానిని పరీక్షించాలి, ఒకవేళ అది చర్మంపై లోతుగా ఉండి దానిలోని వెంట్రుకలు తెల్లబారినట్లు కనిపిస్తే, యాజకుడు వారిని అపవిత్రులని ప్రకటించాలి. అది బొబ్బ ఉన్నచోట బయటపడిన తీవ్రమైన కుష్ఠువ్యాధి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","యాజకుడు పరీక్షించినప్పుడు, అందులో తెల్లని వెంట్రుకలు లేకపోతే, చర్మంపై లోతుగా లేకుండ కొంచెం మాని ఉంటే, యాజకుడు పరీక్షించి వారిని ఏడు రోజులు వేరుగా ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ఒకవేళ అది చర్మంపై వ్యాపిస్తూ ఉంటే, యాజకుడు వారిని అపవిత్రులని ప్రకటించాలి; అది తీవ్రమైన కుష్ఠువ్యాధి లక్షణము. ");
INSERT INTO telotsa_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","అయితే ఒకవేళ ఆ మచ్చ వ్యాపించకుండ అలాగే ఉంటే, అది కేవలం ఒక బొబ్బను బట్టి ఏర్పడిన మచ్చ, యాజకుడు వారిని పవిత్రులని ప్రకటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ఎవరికైనా వారి చర్మంపై కాలి గాయమై, కాలిన చోట ఎర్రగా గాని తెల్లగా గాని మచ్చ కనబడితే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","యాజకుడు ఆ చోటును పరీక్షించాలి, ఒకవేళ అక్కడ వెంట్రుకలు తెల్లగా మారి చర్మం కొంచెం లోపలికి ఉంటే, అది కాలిన చోట బయటపడిన తీవ్రమైన కుష్ఠువ్యాధి; యాజకుడు వారిని అపవిత్రులని ప్రకటించాలి; అది తీవ్రమైన కుష్ఠువ్యాధి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","అయితే ఒకవేళ యాజకుడు దానిని పరీక్షిస్తే అక్కడ తెల్లని వెంట్రుకలు లేకుండ ఒకవేళ అది చర్మంపై లోతుగా లేకుండా కొంచెం మానినట్లు కనబడితే, యాజకుడు వారిని ఏడు రోజులు వేరుగా ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ఏడవ రోజున యాజకుడు వారిని పరీక్షించినప్పుడు, ఒకవేళ అది చర్మంపై వ్యాపిస్తున్నట్లయితే, యాజకుడు వారిని అపవిత్రులని ప్రకటించాలి; అది తీవ్రమైన కుష్ఠువ్యాధి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","అయితే అది వ్యాపించకుండ అలాగే ఉండి మానుతున్నట్లు కనిపిస్తే, అది కేవలం కాలడం వలన ఏర్పడిన వాపు, యాజకుడు వారిని పవిత్రులని ప్రకటించాలి; ఎందుకంటే అది కేవలం కాలిన గాయం వలన ఏర్పడిన మచ్చ. ");
INSERT INTO telotsa_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“స్త్రీకైనా పురుషునికైనా తలమీద గాని గడ్డం మీద గాని పుండు ఏర్పడితే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","యాజకుడు ఆ పుండును పరీక్షించాలి, ఒకవేళ అది చర్మంపై లోతుగా ఉండి అందులో పసుపు రంగులో సన్నని వెంట్రుకలుంటే, యాజకుడు వారిని అపవిత్రులని ప్రకటించాలి; అది తలమీద గాని గడ్డం మీద గాని ఏర్పడిన గజ్జిపుండు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","కాని యాజకుడు ఆ పుండును పరీక్షించినప్పుడు, అది చర్మంపై లోతుగా లేకపోతే, యాజకుడు వారిని ఏడు రోజులు వేరుగా ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ఏడవ రోజు యాజకుడు ఆ గజ్జిపుండును పరీక్షించాలి, ఒకవేళ అది వ్యాపించకపోతే, అందులో పసుపురంగు వెంట్రుకలు లేకపోతే, చర్మంపై లోతుగా లేకపోతే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ఆ పురుషుడు గాని ఆ స్త్రీ గాని పుండు ఉన్న చోటు వదిలి క్షవరం చేసుకోవాలి క్షౌరం చేసుకోవచ్చు, యాజకుడు వారిని మరో ఏడు రోజులు వేరుగా ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ఏడవ రోజు యాజకుడు ఆ గజ్జిపుండును పరీక్షించాలి, అది చర్మంపై వ్యాపించకుండ చర్మంపై లోతుగా లేకపోతే, యాజకుడు వారిని పవిత్రులని ప్రకటించాలి. వారు తమ బట్టలు ఉతుక్కోవాలి, అప్పుడు వారు ఆచారరీత్య పవిత్రులవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","కానీ వారు పవిత్రులని ప్రకటించిన తర్వాత ఒకవేళ గజ్జిపుండు వ్యాపిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","యాజకుడు వారిని పరీక్షించి ఒకవేళ ఆ గజ్జిపుండు చర్మంపై వ్యాపించినట్లు కనబడితే, అతడు పసుపురంగు వెంట్రుకల కోసం చూడాల్సిన అవసరం లేదు; వారు అపవిత్రులు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ఒకవేళ, యాజకుడు చూసే వరకు ఆ పుండు అలాగే ఉండి, ఒకవేళ దానిపై నల్ల జుట్టు పెరిగితే, వారు బాగయ్యారని అర్థము. వారు శుభ్రంగా ఉన్నారు, యాజకుడు వారిని పవిత్రులని ప్రకటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“పురుషునికి గాని స్త్రీకి గాని చర్మంపై తెల్ల మచ్చలు ఉంటే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","యాజకుడు వాటిని పరీక్షించాలి, ఒకవేళ ఆ మచ్చలు స్పష్టంగా కనబడక మామూలుగా ఉంటే, అవి చర్మం మీద వచ్చిన సాధారణ పొక్కులు, అవి హానికరం కావు; వారు ఆచారరీత్య పవిత్రులు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“తలవెంట్రుకలు రాలిపోయి బట్టతల ఉన్న పురుషుడు పవిత్రుడు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ఒకవేళ తల ముందు భాగంలో వెంట్రుకలు రాలిపోయి, నుదురు బోడిగా ఉంటే, అతడు పవిత్రుడు. ");
INSERT INTO telotsa_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","అయితే అతని బట్టతలపై గాని లేదా నుదిటిపై గాని గులాబి రంగు పుండు ఉంటే, అది అతని తలమీద గాని నుదుటి మీద గాని ఏర్పడుతున్న తీవ్రమైన కుష్ఠువ్యాధి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","యాజకుడు అతన్ని పరీక్షించాలి, ఒకవేళ అతని తలపై గాని నుదిటిపై వాచిన పుండు గులాబి రంగులో తీవ్రమైన కుష్ఠువ్యాధిలా ఉంటే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ఆ పురుషుడు వ్యాధిగ్రస్తుడు, అపవిత్రుడు. యాజకుడు అతని తలపై ఉన్న కుష్ఠువ్యాధిని బట్టి అతన్ని అపవిత్రునిగా ప్రకటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“అలాంటి కుష్ఠువ్యాధి ఉన్నవారెవరైనా తప్పనిసరిగా చిరిగిన బట్టలు ధరించాలి, చింపిరి జుట్టుతో ఉండాలి, వారు తమ నోటిని కప్పుకుని, ‘అపవిత్రులం! అపవిత్రులం!’ అని బిగ్గరగా అరవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","వారికి వ్యాధి ఉన్నంత వరకు వారు అపవిత్రులే. వారు ఒంటరిగా జీవించాలి; వారు శిబిరం బయట నివసించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“అపవిత్రమైన మరకతో పాడైన వస్త్రానికి సంబంధించి, అవి ఉన్నివైనా లేదా నార వస్త్రాలైనా, ");
INSERT INTO telotsa_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","నారతో నేసిన వస్త్రాలైనా లేదా ఉన్నితో అల్లిన వస్త్రాలైనా, చర్మమైనా, చర్మంతో చేసినవైనా, ");
INSERT INTO telotsa_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ఒకవేళ వస్త్రాల్లో గాని, చర్మంలో గాని, నేసిన దుస్తుల్లో గాని లేదా అల్లిన దుస్తుల్లో గాని, లేదా ఏదైనా చర్మంతో చేయబడిన వస్తువు మీద గాని పాడైన చోట పచ్చగా లేదా ఎరుపుగా ఉంటే, అది కుష్ఠు మరక యొక్క లక్షణం కాబట్టి తప్పక యాజకునికి చూపించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","యాజకుడు ఆ పాడైన చోటును పరీక్షించి ఏడు రోజులు ఆ వస్తువును వేరుగా ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ఏడవ రోజు అతడు దానిని పరీక్షించాలి, ఒకవేళ వస్త్రంలో గాని, నేసిన దానిలో గాని లేదా అల్లిన దానిలో గాని, లేదా చర్మంలో గాని, చర్మంతో చేసినవైనా దానిలో గాని వ్యాపిస్తే, దాని ఉపయోగం ఏదైనా, అది తీవ్రమైన కుష్ఠు మరక; ఆ వస్తువు అపవిత్రము. ");
INSERT INTO telotsa_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","పాడైన వస్త్రమైనా, నారతో గాని ఉన్నితో గాని నేసిన లేదా అల్లిన వస్త్రాలైనా, లేదా చర్మంలో గాని, చర్మంతో చేసిన వస్తువైనా అతడు తప్పక కాల్చివేయాలి, ఎందుకంటే అది తీవ్రమైన మరక, ఆ వస్తువు తప్పనిసరిగా కాల్చివేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“కానీ ఒకవేళ యాజకుడు దానిని పరీక్షించినప్పుడు, మరక వస్త్రంపై గాని, నేసిన దుస్తులపై గాని లేదా అల్లిన దుస్తులపై గాని, చర్మంపై గాని లేదా చర్మంతో చేసిన వస్తువుపై గాని వ్యాపించి ఉండకపోతే, ");
INSERT INTO telotsa_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","దానిని ఉతకమని అతడు ఆదేశించి దానిని మరో ఏడు రోజులు వేరుగా ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","దానిని ఉతికిన తర్వాత, యాజకుడు దానిని మళ్ళీ పరీక్షించాలి, ఒకవేళ ఆ మరక మారకుండా వ్యాపించకుండ అలాగే ఉంటే, అది అపవిత్రమే. వస్త్రం ఎటువైపు పాడైనా, దానిని కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ఒకవేళ యాజకుడు దానిని పరీక్షించినప్పుడు, ఆ వస్త్రం ఉతికిన తర్వాత మరక పోయినట్లైతే, అతడు ఆ పాడైన భాగాన్ని వస్త్రమైనా, చర్మమైనా నేసిన వస్త్రమైనా అల్లిన వస్త్రమైనా సరే కత్తిరించివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","అయితే ఒకవేళ అది దుస్తుల్లో గాని నేసిన, అల్లిన వస్త్రాల్లో గాని లేదా చర్మంతో చేసిన వాటిలో గాని మళ్ళీ కనిపిస్తే, అది వ్యాపించే మరక అని గుర్తించి అది ఎలాంటి మరకైనా సరే దానిని కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","వస్త్రమైనా, నేసినదైనా అల్లినదైనా, చర్మంతో చేసిన వస్తువైనా సరే ఉతికిన తర్వాత మరక తొలగిపోతే దానిని మళ్ళీ ఉతకాలి. అప్పుడు అది పవిత్రమవుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ఉన్ని లేదా నార దుస్తుల్లో గాని నేసిన లేదా అల్లిన వస్త్రాల్లో గాని చర్మంతో చేసిన వస్తువులలో గాని కుష్ఠు మరకలు ఉంటే, వాటిని పవిత్రమైనవిగా గాని అపవిత్రమైనవిగా గాని ప్రకటించడానికి ఈ నియమాలు వర్తిస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ఎవరైనా అనారోగ్య వ్యక్తిని వారి ఆచారరీత్య శుద్ధీకరణ పాటిస్తున్న సమయంలో, యాజకుని దగ్గరకు తీసుకువచ్చినప్పుడు పాటించవలసిన నియమాలు ఇవి: ");
INSERT INTO telotsa_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","యాజకుడు శిబిరం బయటకు వెళ్లి వారిని పరీక్షించాలి. ఒకవేళ వారు వారి అపవిత్ర చర్మ వ్యాధి నుండి స్వస్థత పొందివుంటే, ");
INSERT INTO telotsa_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","వారిని శుద్ధీకరించడానికి రెండు బ్రతికి ఉన్న పవిత్రమైన పక్షులు, కొంత దేవదారు కలప, ఎరుపురంగు నూలు, హిస్సోపును తీసుకురావాలని యాజకుడు ఆదేశించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","తర్వాత ఆ పక్షుల్లో ఒకదాన్ని మట్టికుండలో ఉన్న మంచినీటిపై చంపుమని యాజకుడు ఆదేశించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","అప్పుడు యాజకుడు బ్రతికి ఉన్న పక్షిని పట్టుకుని, దేవదారు కర్రను, ఎర్రని నూలును, హిస్సోపును తీసుకుని మంచినీటిపై చంపబడిన పక్షి రక్తంలో ముంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","కుష్ఠువ్యాధి నుండి శుద్ధీకరణ పొందే వారిపై ఆ నీటిని ఏడుసార్లు చల్లి, అతడు ఏడుసార్లు చల్లి, వారిని పవిత్రులుగా ప్రకటించాలి. ఆ తర్వాత, యాజకుడు బ్రతికి ఉన్న మరొక పక్షిని బయట పొలాల్లోకి వదిలేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“శుద్ధి చేయబడిన వ్యక్తులు తమ బట్టలు ఉతుక్కోవాలి, వారు తమ వెంట్రుకలన్నీ క్షవరం చేయించుకుని నీటితో స్నానం చేయాలి; అప్పుడు వారు ఆచారరీత్య పవిత్రులవుతారు. దీని తర్వాత వారు శిబిరంలోకి రావచ్చు, కాని వారు తమ గుడారం బయట ఏడు రోజులు ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ఏడవ రోజున వారు తమ వెంట్రుకలంతా క్షవరం చేయించుకోవాలి; గడ్డం, కనుబొమ్మలు ఇంకా మిగతా వెంట్రుకలు పూర్తిగా క్షవరం చేసుకోవాలి. అలాగే వారు తమ బట్టలు ఉతుక్కుని స్నానం చేయాలి. అప్పుడు వారు ఆచారరీత్య పవిత్రులవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ఎనిమిదవ రోజు ఏ లోపం లేని రెండు మగ గొర్రెపిల్లలను, ఏ లోపం లేని ఏడాది ఆడ గొర్రెపిల్లను, రెండు కూడా ఏ లోపం లేనివాటిని తీసుకురావాలి. భోజనార్పణ కోసం నూనె కలిపిన మూడు ఓమెర్ల నాణ్యమైన పిండి, ఒక సేరు నూనె యాజకుని దగ్గరకు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","వారిని శుద్ధులుగా ప్రకటించే యాజకుడు శుద్ధీకరించబడిన వారిని, వారి అర్పణలతో పాటు సమావేశ గుడారం యొక్క ద్వారం దగ్గర యెహోవా ఎదుట కనుపరచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“అప్పుడు యాజకుడు మగ గొర్రెపిల్లలలో ఒకదాన్ని తీసుకుని, అపరాధపరిహారబలిగా, కొంచెం నూనెతో పాటు అర్పించాలి; అతడు వాటిని పైకెత్తి యెహోవా ఎదుట ప్రత్యేక అర్పణగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","అతడు పాపపరిహారబలిని, దహనబలిని వధించే పరిశుద్ధాలయ ప్రాంతంలో గొర్రెపిల్లను వధించాలి. పాపపరిహారబలిలా, అపరాధపరిహారబలి కూడా యాజకునికే చెందుతుంది; అది అతిపరిశుద్ధము. ");
INSERT INTO telotsa_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","యాజకుడు అపరాధపరిహారబలి పశువు రక్తాన్ని కొంచెం తీసుకుని శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి యొక్క కుడిచెవి కొన మీద, వారి కుడిచేతి బొటనవ్రేలుపై, వారి కుడికాలి బొటనవ్రేలుపై పూయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","అప్పుడు యాజకుడు కొంచెం నూనె తీసుకుని, తన ఎడమచేతి అరచేతిలో పోసి, ");
INSERT INTO telotsa_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","తన కుడి చూపుడు వ్రేలు తన అరచేతిలో ఉన్న నూనెలో ముంచి, తన వ్రేలితో దానిలో కొంచెం యెహోవా ఎదుట ఏడుసార్లు చిలకరిస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","యాజకుడు తన అరచేతిలో మిగిలి ఉన్న నూనెలో కొంచెం శుద్ధి చేయబడవలసిన వ్యక్తి యొక్క కుడిచెవి యొక్క లోలాకుల మీద, వారి కుడిచేతి బొటనవ్రేలుపై, వారి కుడి పాదం యొక్క పెద్ద బొటనవ్రేలుపై, అపరాధపరిహారబలి పశువు రక్తం పైన ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","యాజకుడు తన అరచేతిలో మిగిలి ఉన్న నూనెను శుద్ధీకరణ కోసం వచ్చిన వారి తలమీద పూసి యెహోవా ఎదుట ప్రాయశ్చిత్తం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“అప్పుడు యాజకుడు అపవిత్రత పోగొట్టుకోవాలని వచ్చిన వారి కోసం పాపపరిహారబలి అర్పించి ప్రాయశ్చిత్తం చేసిన తర్వాత దహనబలి పశువును వధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","దానిని భోజనార్పణతో కలిపి బలిపీఠం మీద అర్పించి, వారి కోసం ప్రాయశ్చిత్తం చేయాలి, అప్పుడు వారు శుద్ధులవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“అయినప్పటికీ, ఒకవేళ వారు పేదవారైయుండి వీటిని చేసే స్తోమత లేనివారైతే, వారి ప్రాయశ్చిత్తం కోసం అపరాధపరిహారబలిగా ప్రత్యేకంగా అర్పించడానికి వారు ఒక మగ గొర్రెపిల్లను, దానితో పాటు భోజనార్పణ కోసం ఒక సేరు నూనెలో కలిపిన ఒక ఓమెరు నాణ్యమైన పిండిని, ");
INSERT INTO telotsa_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","రెండు పావురాలు లేదా రెండు చిన్న గువ్వలను, వారి స్థోమతను బట్టి ఒకటి పాపపరిహారబలి కోసం మరొకటి దహనబలి కోసం తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“ఎనిమిదవ రోజున వారు తమ శుద్ధీకరణ కోసం యెహోవా ఎదుటికి సమావేశ గుడారపు ద్వారం దగ్గర యాజకుని దగ్గరకి వాటిని తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","యాజకుడు అపరాధపరిహారబలిగా అర్పించేందుకు గొర్రెపిల్లతో పాటు కొంచెం నూనె కూడా తీసుకుని పైకెత్తి ప్రత్యేక అర్పణగా యెహోవా ఎదుట అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","అతడు అపరాధపరిహారబలిగా గొర్రెపిల్లను వధించి, దాని రక్తంలో కొంచెం తీసుకుని శుద్ధీకరణ కోసం వచ్చిన వారి కుడిచెవి కొన మీద, వారి కుడిచేతి బొటనవ్రేలుపై, వారి కుడికాలి బొటనవ్రేలుపై పూయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","యాజకుడు కొంచెం నూనె తన ఎడమ అరచేతిలో వేసుకుని, ");
INSERT INTO telotsa_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","తన కుడి చూపుడు వ్రేలును దానిలో ముంచి యెహోవా ఎదుట ఏడుసార్లు చిలకరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","తన అరచేతిలో మిగిలిన నూనెలో కొంచెం తీసుకుని శుద్ధీకరణ కోసం వచ్చిన వారి కుడిచెవి కొన మీద, వారి కుడిచేతి బొటనవ్రేలుపై, వారి కుడికాలి బొటనవ్రేలుపై ఉన్న అపరాధ బలి పశువు రక్తం మీద ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","యాజకుడు తన అరచేతిలో మిగిలిన నూనెను యెహోవా ఎదుట శుద్ధీకరణ కోసం వచ్చిన వారి తలకు పూసి వారి కోసం ప్రాయశ్చిత్తం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","అప్పుడు వారు తమ స్థోమతను బట్టి తీసుకువచ్చిన గువ్వలను పావురం పిల్లలను యాజకుడు తీసుకుని, ");
INSERT INTO telotsa_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","పాపపరిహారబలిగా ఒకదాన్ని, దహనబలిగా ఒకదాన్ని సమర్పించాలి. వాటిని భోజనార్పణతో పాటు అర్పించాలి. ఈ విధంగా యాజకుడు యెహోవా ఎదుట శుద్ధీకరణ కోసం వచ్చిన వారి కోసం ప్రాయశ్చిత్తం చేయాలి.” ");
INSERT INTO telotsa_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","తీవ్రమైన కుష్ఠువ్యాధి ఉండి తమ శుద్ధీకరణకు తీసుకురావలసిన అర్పణలను తీసుకురావడానికి స్థోమతలేని వారికి సంబంధించిన నియమాలు ఇవి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","యెహోవా మోషే అహరోనులతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“మీ స్వాస్థ్యంగా నేను మీకు ఇస్తున్న కనాను దేశానికి మీరు వచ్చిన తర్వాత, ఆ దేశంలోని ఒక ఇంట్లో నేను కుష్ఠు మచ్చను ఉంచితే, ");
INSERT INTO telotsa_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","వెంటనే ఆ ఇంటి యజమాని యాజకుడి దగ్గరకు వెళ్లి, ‘నేను నా ఇంట్లో అపవిత్రమైన మచ్చ చూశాను’ అని చెప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ఆ ఇంట్లో ఉన్నదంతా అపవిత్రంగా కాకుండ ఉండడానికి యాజకుడు ఆ మచ్చను పరీక్షించడానికి రాకముందే ఆ ఇళ్ళంతా ఖాళీ చేయించాలి. ఆ తర్వాత యాజకుడు లోపలికి వెళ్లి ఇంటిని పరీక్షించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","అతడు గోడలపై ఉన్న మచ్చను పరీక్షించినప్పుడు ఆ గోడల మీద పచ్చని గీతలు గాని ఎర్రని గీతలు గోడ పగుళ్లలో ఉంటే, ");
INSERT INTO telotsa_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","యాజకుడు ఆ ఇంటి ద్వారం నుండి బయటకు వెళ్లి ఏడు రోజులు దానిని మూసివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ఏడవ రోజున యాజకుడు ఆ ఇంటిని పరిశీలించడానికి మరలా రావాలి. ఒకవేళ గోడలపై మరక వ్యాపించి ఉంటే, ");
INSERT INTO telotsa_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","మచ్చలు ఉన్న ఆ రాళ్లను ఊడదీసి పట్టణానికి బయట ఉన్న అపవిత్రమైన ప్రదేశంలో పడవేయమని యాజకుడు ఆదేశించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","అతడు ఇంటి లోపలి గోడలన్నింటిని గీయించి ఆ చెత్తను పట్టణం బయట ఉన్న అపవిత్రమైన ప్రదేశంలో పడవేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","తీసివేసిన వాటి స్థానంలో వేరే రాళ్లు పెట్టి క్రొత్త బంకమట్టిని తీసుకుని ఇంటికి అడుసు పూయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“రాళ్లు ఊడదీసి ఇంటి గోడలను గీయించి కొత్త అడుసు పూసిన తర్వాత ఇంట్లో అపవిత్రమైన మరక తిరిగి కనిపిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","యాజకుడు వెళ్లి దానిని పరీక్షించాలి, ఒకవేళ ఇంట్లో మరక వ్యాపించి ఉంటే అది అపవిత్రపరచే మరక; ఆ ఇల్లు అపవిత్రమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ఆ ఇంటిని దాని రాళ్లను కలపను అడుసును కూలగొట్టి వాటిని పట్టణం బయట ఉన్న అపవిత్రమైన ప్రదేశంలో పడవేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“ఒకవేళ ఇల్లు మూసివేసి ఉన్నప్పుడు ఎవరైనా ఇంట్లోకి వెళ్తే సాయంత్రం వరకు వారు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ఆ ఇంట్లో పడుకునేవారు తినేవారు ఎవరైనా సరే తమ బట్టలు ఉతుక్కోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“యాజకుడు వచ్చి దానిని పరీక్షించినప్పుడు ఆ ఇంటికి అడుసు పూసిన తర్వాత మరక వ్యాపించకపోతే, అపవిత్రం చేసే మరక పోయింది కాబట్టి ఆ ఇల్లు పవిత్రమని అతడు ప్రకటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ఇంటిని శుద్ధి చేయడానికి అతడు రెండు పక్షులను కొంచెం దేవదారు కర్రను, ఎర్రని నూలును, హిస్సోపును తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","అతడు ఆ పక్షుల్లో ఒకదాన్ని మట్టికుండలో ఉన్న మంచినీటిపై చంపాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","అప్పుడు అతడు దేవదారు కర్రను హిస్సోపును ఎర్రని నూలును బ్రతికి ఉన్న పక్షిని తీసుకుని చనిపోయిన పక్షి రక్తంలోను మంచినీటిలోను ముంచి ఆ ఇంట్లో ఏడుసార్లు చల్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","అతడు ఇంటిని పక్షి రక్తంతోను మంచినీటితోను బ్రతికి ఉన్న పక్షితో దేవదారు కర్రతో హిస్సోపుతో ఎర్రని నూలుతో శుద్ధి చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","అప్పుడు అతడు బ్రతికి ఉన్న పక్షిని పట్టణం బయట ఉన్న పొలాల్లో వదలివేయాలి. ఈ విధంగా అతడు ఆ ఇంటికి ప్రాయశ్చిత్తం చేయాలి, అది శుద్ధి అవుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ఏదైనా కుష్ఠువ్యాధికైనా గజ్జిపుండ్లకైనా నియమాలు ఇవి, ");
INSERT INTO telotsa_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","వస్త్రాల్లో గాని ఇంట్లో గాని ఏర్పడే అపవిత్రపరచే మరకలకు, ");
INSERT INTO telotsa_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","వాపుకైనా దద్దుర్లకైనా లేదా మెరిసే మచ్చలకైనా, ");
INSERT INTO telotsa_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","అవి పవిత్రమైనవా అపవిత్రమైనవా అని ఈ నిబంధనలు తెలియజేస్తాయి. కుష్ఠువ్యాధులు, అపవిత్రపరచే మరకలకు సంబంధించిన నియమాలు ఇవే. ");
INSERT INTO telotsa_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","యెహోవా మోషే అహరోనులతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“మీరు ఇశ్రాయేలీయులతో మాట్లాడి వారితో ఇలా చెప్పండి: ‘ఎప్పుడైనా ఏ పురుషునికైనా శరీరంలో నుండి ఏదైనా ద్రవం కారుతుంటే అది అపవిత్రమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","అది అతని శరీరం నుండి కారుతూ ఉన్నా లేక ఆగిపోయినా అది అతన్ని అపవిత్రం చేస్తుంది. ఈ విధంగా కారడం వలన అతడు అపవిత్రుడు అవుతాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘స్రవిస్తున్న వ్యక్తి ఏ పడక మీద పడుకున్నా అది అపవిత్రమవుతుంది, అతడు దేనిపైనా కూర్చున్న అది అపవిత్రమవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","అతని పడకను తాకినవారు తమ బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, వారు సాయంత్రం వరకు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","స్రవిస్తున్న వ్యక్తి కూర్చున్న దానిపైన ఎవరు కూర్చున్నా వారు తమ బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, వారు సాయంత్రం వరకు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘స్రవిస్తున్న వ్యక్తిని ఎవరు తాకినవారు బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, సాయంత్రం వరకు వారు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘స్రవిస్తున్న వ్యక్తి శుభ్రంగా ఉన్నవారిపై ఉమ్మివేస్తే, వారు బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, సాయంత్రం వరకు వారు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘స్వారీ చేసేటప్పుడు ఆ వ్యక్తి కూర్చున్నది అపవిత్రమవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","అతని క్రింద ఉన్న ఏ వస్తువునైనా తాకినవారు సాయంత్రం వరకు అపవిత్రులుగా ఉంటారు; ఆ వస్తువులను పైకెత్తినవారు తమ బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, వారు సాయంత్రం వరకు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘స్రవిస్తున్న వ్యక్తి నీటితో చేతులు కడుక్కోకుండా ఎవరినైన తాకితే వారు తమ బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, సాయంత్రం వరకు వారు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘ఆ వ్యక్తి తాకిన మట్టికుండను ఖచ్చితంగా పగులగొట్టాలి, అది చెక్క వస్తువైతే దానిని నీటితో కడగాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘స్రవిస్తున్న వ్యక్తి తన స్రావం నుండి శుద్ధి చేయబడినప్పుడు, అతడు తన శుద్ధీకరణ కోసం ఏడు రోజులు లెక్కించి తన బట్టలు ఉతుక్కోవాలి, మంచి నీటితో స్నానం చేయాలి, అప్పుడు అతడు పవిత్రంగా అవుతాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ఎనిమిదవ రోజున అతడు రెండు పావురాలను లేదా రెండు చిన్న గువ్వలను తీసుకుని యెహోవా ఎదుట సమావేశ గుడార ద్వారం దగ్గర యాజకునికి ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","యాజకుడు వాటిలో ఒకదాన్ని పాపపరిహారబలిగా ఒకదాన్ని దహనబలిగా అర్పించాలి. ఈ విధంగా యాజకుడు స్రవిస్తున్న వ్యక్తికి యెహోవా ఎదుట ప్రాయశ్చిత్తం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘ఒక వ్యక్తికి వీర్యస్కలనం జరిగితే అతడు నీటితో పూర్తిగా స్నానం చేయాలి, అతడు సాయంత్రం వరకు అపవిత్రునిగా ఉంటాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","బట్టలమీద గాని లేదా చర్మం మీద గాని వీర్యం పడివుంటే నీటితో వాటిని కడగాలి, అవి సాయంత్రం వరకు అపవిత్రంగా ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ఒక పురుషుడు స్త్రీ తో లైంగికంగా కలిసినప్పుడు వీర్యస్కలనం జరిగితే ఇద్దరూ నీటితో స్నానం చేయాలి, వారు సాయంత్రం వరకు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘ఒక స్త్రీకి నెలసరి సమయంలో రక్తస్రావం జరిగినప్పుడు ఆమె నెలసరి అపవిత్రత ఏడు రోజులు ఉంటుంది, ఆమెను తాకిన వారెవరైనా సాయంత్రం వరకు అపవిత్రంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘నెలసరి సమయంలో ఆమె దేనిపై పడుకుంటుందో అది అపవిత్రం అవుతుంది, ఆమె దేనిపై కూర్చుంటుందో అది అపవిత్రం అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ఆమె పడకను తాకినవారు అపవిత్రులవుతారు; వారు తమ బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, వారు సాయంత్రం వరకు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ఆమె కూర్చున్న దాన్ని తాకినవారు అపవిత్రులవుతారు; వారు తమ బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, వారు సాయంత్రం వరకు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ఆమె పడకను గాని ఆమె కూర్చున్న దానిని గాని తాకినవారు సాయంత్రం వరకు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘ఒక వ్యక్తి ఆమెతో లైంగికంగా కలిసినప్పుడు ఆమె నెలసరి అతన్ని తాకితే, అతడు ఏడు రోజులు అపవిత్రునిగా ఉంటాడు; అతడు పడుకున్న ఏ పడకయైనా అపవిత్రమవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘ఒక స్త్రీకి తన నెలసరి సమయం కాకుండా చాలా రోజులు రక్తస్రావం జరిగినా లేదా ఆమె నెలసరి వ్యవధి మించి రక్తస్రావం కొనసాగితే, రక్తస్రావం ఉన్నంత వరకు నెలసరి రోజుల్లా ఆమె అపవిత్రంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ఆమెకు రక్తస్రావం కొనసాగుతున్నప్పుడు ఆమె పడుకున్న ఏ పడకైనా ఆమె నెలసరి సమయంలో ఉన్నప్పటిలాగే ఆ పడక అపవిత్రం, అలాగే ఆమె దేనిపై కూర్చున్న అది అపవిత్రం అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","వాటిని తాకినవారు అపవిత్రులు; వారు తమ బట్టలు ఉతుక్కోవాలి, నీటితో స్నానం చేయాలి, వారు సాయంత్రం వరకు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘ఆమె స్రావం నుండి శుద్ధి చేయబడినప్పుడు, ఆమె ఏడు రోజులు లెక్కించి అవి ముగిసిన తర్వాత ఆమె పవిత్రమవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ఎనిమిదవ రోజున ఆమె రెండు గువ్వలను గాని, రెండు పావురం పిల్లలను గాని తీసుకువచ్చి సమావేశ గుడారపు ప్రవేశ ద్వారం దగ్గర యాజకునికి ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","యాజకుడు వాటిలో ఒకదాన్ని పాపపరిహారబలిగా ఒకదాన్ని దహనబలిగా అర్పించాలి. ఈ విధంగా యాజకుడు స్త్రీకి స్రావం ద్వార కలిగిన అపవిత్రతకు యెహోవా ఎదుట ప్రాయశ్చిత్తం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘తమను అపవిత్రం చేసే వాటినుండి మీరు ఇశ్రాయేలీయులను దూరంగా ఉంచాలి, తద్వార వారి మధ్య ఉన్న నా నివాస స్థలాన్ని వారు అపవిత్రం చేసినందుకు వారి అపవిత్రతలో వారు చావరు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ఈ నియమాలు స్రవిస్తున్న వ్యక్తికి వీర్యస్కలనం వలన అపవిత్రమైన వారికి ఈ నియమాలు వర్తిస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","తన నెలసరి సమయంలో ఉన్న ఒక స్త్రీకి, స్రవిస్తున్న పురుషునికి గాని స్త్రీకి గాని, అపవిత్రురాలైన స్త్రీతో లైంగికంగా కలిసిన పురుషునికి వర్తిస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","అహరోను ఇద్దరు కుమారులు అనధికార నిప్పుతో యెహోవాను సమీపించినప్పుడు వారు చనిపోయిన తర్వాత యెహోవా మోషేతో మాట్లాడారు. ");
INSERT INTO telotsa_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","యెహోవా మోషేతో అన్నారు: “నీ సహోదరుడైన అహరోను మందసం మీద ఉన్న ప్రాయశ్చిత్త మూతకు ఎదురుగా ఉన్న తెర వెనుక ఉన్న అతి పరిశుద్ధ స్థలంలోకి ఎప్పుడంటే అప్పుడు రావద్దు అని చెప్పు, అలా వస్తే అతడు చస్తాడు. ఎందుకంటే నేను మేఘంలో ఆ ప్రాయశ్చిత్త మూత మీదే మీకు ప్రత్యక్షమవుతాను. ");
INSERT INTO telotsa_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“అహరోను అతి పరిశుద్ధ స్థలంలోకి వెళ్లే విధానం ఇది: మొదట అతడు పాపపరిహారబలిగా ఒక కోడెను, దహనబలి కోసం ఒక పొట్టేలును తేవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","అతడు సన్నని నార చొక్కా, సన్నని నారలోదుస్తులు వేసుకోవాలి; సన్నని నార నడికట్టు కట్టుకుని, సన్నని నార పాగా పెట్టుకోవాలి. ఇవి పవిత్ర దుస్తులు; అవి వేసుకోక ముందు అతడు నీటితో స్నానం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","అతడు ఇశ్రాయేలు సమాజం నుండి పాపపరిహారబలి కోసం రెండు మేకపోతులను, దహనబలి కోసం ఒక పొట్టేలును తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“అహరోను తనకు, తన ఇంటివారికి ప్రాయశ్చిత్తం చేయడానికి ఎద్దును తన పాపపరిహారబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","తర్వాత అతడు రెండు మేకపోతులు తీసుకుని సమావేశ గుడార ద్వారం దగ్గర యెహోవా ఎదుట వాటిని సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","అహరోను ఆ రెండు మేకపోతుల మధ్య చీట్లు వేయాలి ఎందుకంటే వాటిలో ఒకటి యెహోవా భాగం, మరొకటి విడిచిపెట్టబడే మేక. ");
INSERT INTO telotsa_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","అప్పుడు అహరోను యెహోవా పేరిట చీటి వచ్చిన మేకను తీసుకుని పాపపరిహారబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","విడిచిపెట్టాలి అనే చీటి వచ్చిన మేకను దాని వలన ప్రాయశ్చిత్తం కలిగేలా దాన్ని అడవిలో విడిచిపెట్టడానికి యెహోవా ఎదుట సజీవంగా నిలబెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“అహరోను పాపపరిహారబలిగా ఒక కోడెదూడను తన కోసం తన ఇంటివారి ప్రాయశ్చిత్తం కోసం తీసుకురావాలి, దానిని తన పాపపరిహారబలిగా వధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","అతడు యెహోవా ఎదుట ఉన్న బలిపీఠం మీద ఉన్న నిప్పులతో నింపిన ధూపార్తిని, రెండు పిడికెళ్ళ పరిమళ ధూపం పొడిని తీసుకుని వాటిని తెర వెనుకకు తీసుకెళ్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","అతడు ధూపాన్ని యెహోవా ముందు అగ్ని మీద ఉంచాలి, ధూపం యొక్క పొగ ఒడంబడిక పలకలను కప్పి ఉంచిన ప్రాయశ్చిత్త మూతను కప్పివేస్తుంది, తద్వారా అతడు చనిపోడు. ");
INSERT INTO telotsa_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ఆ కోడె రక్తంలో కొంత తన వ్రేలితో తీసుకుని ప్రాయశ్చిత్త మూత ముందు చల్లాలి; తర్వాత దానిలో కొంత రక్తం వ్రేలితో ఏడుసార్లు ప్రాయశ్చిత్త మూత ఎదుట ప్రోక్షించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“తర్వాత అతడు ప్రజల పాపపరిహారబలి కోసం మేకపోతును వధించాలి, దాని రక్తాన్ని అడ్డతెర లోపలికి తెచ్చి కోడె రక్తాన్ని చేసినట్టు ప్రాయశ్చిత్త మూత మీద, దాని ముందు చిలకరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ఇశ్రాయేలీయుల అపవిత్రత కోసం, తిరుగుబాటు కోసం, వారి పాపాలన్నిటి కోసం అతడు అతి పరిశుద్ధ స్థలానికి ప్రాయశ్చిత్తం చేయాలి. ఇశ్రాయేలీయుల అపవిత్రత మధ్య వారి మధ్యలో ఉన్న సమావేశ గుడారం కోసం కూడా ఇదే రీతిలో ప్రాయశ్చిత్తం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","అతి పరిశుద్ధస్థలంలో ప్రాయశ్చిత్తం చేయడానికి అహరోను లోపలికి వెళ్లినప్పుడు, తన కోసం తన ఇంటివారి కోసం ఇశ్రాయేలు సమాజమంతటి కోసం ప్రాయశ్చిత్తం జరిగించి బయటకు వచ్చేవరకు ఏ మనుష్యుడు సమావేశ గుడారంలో ఉండకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“తర్వాత అతడు యెహోవా ఎదుట ఉన్న బలిపీఠం దగ్గరకు వచ్చి దానికి ప్రాయశ్చిత్తం చేయాలి. అతడు కోడె రక్తం కొంచెం, మేకపోతు రక్తం కొంచెం తీసుకుని బలిపీఠం కొమ్ములన్నిటికి పూయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","దానిని శుద్ధీకరించడానికి అతడు తన వ్రేలితో ఆ రక్తాన్ని దానిపై ఏడుసార్లు చల్లి ఇశ్రాయేలీయుల అపవిత్రత నుండి దానిని పవిత్రపరచాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“అహరోను అతి పరిశుద్ధ స్థలానికి సమావేశ గుడారానికి బలిపీఠానికి ప్రాయశ్చిత్తం చేసిన తర్వాత, అతడు సజీవ మేకపోతును తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ఆ మేకపోతు తలమీద అహరోను తన రెండు చేతులు ఉంచి ఇశ్రాయేలీయుల దుష్టత్వమంతటిని, తిరుగుబాటును, పాపాలన్నిటిని దానిపై ఒప్పుకుని వాటిని మేకపోతు తలపై మోపాలి. ఈ పనికి నియమించబడిన వ్యక్తి ఆ మేకపోతును తీసుకెళ్లి అరణ్యంలో వదిలిపెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ఆ మేకపోతు ఈ విధంగా వారి పాపాలన్నిటిని భరిస్తూ నిర్జన ప్రదేశాలకు వెళ్తుంది; ఆ వ్యక్తి దానిని అరణ్యంలో వదిలేస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“అప్పుడు అహరోను సమావేశ గుడారంలోకి వెళ్లి అతి పరిశుద్ధస్థలంలోకి వెళ్లేముందు తాను వేసుకున్న సన్నని నార వస్త్రాలను విప్పివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","అతడు పరిశుద్ధాలయ ప్రాంగణంలో నీటితో స్నానం చేసి తన సాధారణ బట్టలు వేసుకోవాలి. బయటకు వచ్చి తన కోసం దహనబలిని, ప్రజల పక్షాన మరో దహనబలిని అర్పించి తన కోసం, ప్రజల కోసం ప్రాయశ్చిత్తం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","అతడు పాపపరిహారబలి యొక్క క్రొవ్వును బలిపీఠం మీద కాల్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“బలిపశువైన మేకను విడిచిపెట్టి వచ్చిన వ్యక్తి తన బట్టలు ఉతుక్కుని స్నానం చేసిన తర్వాత అతడు శిబిరంలోకి రావచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ప్రాయశ్చిత్తం కోసం అతి పరిశుద్ధస్థలంలోకి వేటి రక్తాన్నైతే తీసుకువచ్చారో ఆ పాపపరిహార బలులైన కోడెదూడను, మేకపోతును శిబిరం బయటకు తీసుకెళ్ళాలి; వాటి చర్మాలను, మాంసాన్ని, పేడను కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","వాటిని కాల్చే వ్యక్తి తన బట్టలు ఉతుక్కుని స్నానం చేసి ఆ తర్వాత శిబిరంలోకి రావచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“నెల పదవ రోజున మీరంతా ఉపవాసముండాలి. స్వదేశీయులు గాని, మీ ఇంట్లో ఉన్నా విదేశీయులు గాని ఎవరైనా సరే ఈ నియమం అందరికి వర్తిస్తుంది. ఆ రోజున ఎవరూ ఏ పని చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ఎందుకంటే ఆ రోజున మిమ్మల్ని పవిత్రపరచడానికి ప్రాయశ్చిత్తం చేయబడుతుంది. అప్పుడు యెహోవా ఎదుట, మీ పాపాలన్నిటి నుండి మీరు శుద్ధి చేయబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ఆ రోజు మీకు సబ్బాతు విశ్రాంతి దినము. అప్పుడు మీరు ఉపవాసముండాలి; ఇది నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ఎవరైతే తన తండ్రి స్థానంలో అభిషేకం పొంది ప్రధాన యాజకుడుగా ప్రతిష్ఠించబడతారో ఆ యాజకుడు ప్రాయశ్చిత్తం జరిగించాలి. అతడు పవిత్రమైన నార వస్త్రాలు ధరించి, ");
INSERT INTO telotsa_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","అతి పరిశుద్ధ స్థలానికి, సమావేశ గుడారానికి బలిపీఠానికి, యాజకులకు, సమాజంలోని సభ్యులందరికి ప్రాయశ్చిత్తం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“ఇది మీ కోసం నిత్య కట్టుబాటుగా ఉంటుంది: ఇశ్రాయేలీయుల పాపాలన్నిటికీ సంవత్సరానికి ఒకసారి ప్రాయశ్చిత్తం చేయాలి.” యెహోవా మోషేకు ఆజ్ఞాపించినట్లే, అంతా జరిగింది. ");
INSERT INTO telotsa_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“అహరోను, అతని కుమారులు, ఇశ్రాయేలీయులందరితో మాట్లాడి వారితో ఇలా చెప్పు: ‘యెహోవా ఆజ్ఞాపించింది ఇది: ");
INSERT INTO telotsa_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","ఏ ఇశ్రాయేలీయుడైనా ఒక ఎద్దును, గొర్రెపిల్లను లేదా మేకను యెహోవా ఎదుట సమావేశ గుడార ప్రవేశం ముందు కాక శిబిరంలో గాని శిబిరం బయట గాని బలి ఇస్తే, వారు రక్తపాతం కలిగించిన అపరాధులుగా పరిగణించబడతారు; వారు రక్తం చిందించినవారు కాబట్టి వారు వారి ప్రజల నుండి కొట్టివేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","కాబట్టి ఇశ్రాయేలీయులు బయట పొలాల్లో అర్పిస్తున్న బలులను ఇకపై యెహోవా ఎదుట సమర్పించాలి. వారు సమావేశ గుడారపు ద్వారం దగ్గర యెహోవాకు సమాధానబలులుగా అర్పించడానికి యాజకుని దగ్గరకు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","సమావేశ గుడార ప్రవేశ ద్వారం దగ్గర యెహోవా బలిపీఠం మీద యాజకుడు రక్తాన్ని చల్లి, క్రొవ్వును యెహోవాకు ఇష్టమైన సువాసనగా దహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","వారు వ్యభిచారం చేస్తూ వచ్చిన మేక విగ్రహాలకు ఇకపై తమ బలులను అర్పించకూడదు. ఇది వారికి, రాబోయే తరాలకు ఇది నిత్య కట్టుబాటుగా ఉంటుంది.’ ");
INSERT INTO telotsa_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“వారితో ఇలా చెప్పు: ‘ఇశ్రాయేలీయులలో గాని వారి మధ్యలో నివసించే విదేశీయులలో గాని ఎవరైనా దహనబలిని గాని మరేదైనా బలిని గాని అర్పించాలనుకుని ");
INSERT INTO telotsa_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","యెహోవాకు బలి ఇవ్వడానికి సమావేశ గుడార ద్వారం దగ్గరకు దాన్ని తీసుకురాకపోతే వారు ఇశ్రాయేలు ప్రజల నుండి తొలగించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘ఇశ్రాయేలీయులలో గాని వారి మధ్యలో నివసించే విదేశీయులలో గాని ఎవరైనా రక్తాన్ని తింటే వారికి నేను విరోధంగా ఉంటాను, వారిని తమ ప్రజల నుండి తొలగిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ఎందుకంటే, ఒక జీవికి ప్రాణం రక్తంలో ఉంది, బలిపీఠం మీద మీ కోసం ప్రాయశ్చిత్తం చేయడానికి నేను దానిని మీకిచ్చాను. ఇది ఒకరి జీవితానికి ప్రాయశ్చిత్తం చేసే రక్తము. ");
INSERT INTO telotsa_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","అందుకే, “మీలో గాని, మీ మధ్య ఉన్న విదేశీయులలో గాని ఎవరూ రక్తాన్ని తినకూడదు” అని నేను ఇశ్రాయేలీయులకు ఆదేశించాను. ");
INSERT INTO telotsa_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘ఇశ్రాయేలీయులలో వారి మధ్య నివసించే విదేశీయులలో ఎవరైనా వేటాడుతూ జంతువును గాని పక్షిని గాని పట్టుకుంటే అతడు దాని రక్తాన్ని పూర్తిగా పారబోసి మట్టితో కప్పెయ్యాలి, ");
INSERT INTO telotsa_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ఎందుకంటే ప్రతి జీవికి ప్రాణం దాని రక్తము. అందుకే, “ప్రతి జీవికి ప్రాణం దాని రక్తం కాబట్టి మీరు ఏ ప్రాణి రక్తాన్నీ తినకూడదు. ఎవరైన దానిని తింటే వారు తొలిగించబడతారు” అని నేను ఇశ్రాయేలీయులకు ఆదేశించాను. ");
INSERT INTO telotsa_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘ఎవరైన, స్వదేశీయులు గాని విదేశీయులు గాని చచ్చిన జంతువును గాని మృగాలు చీల్చిన పశువులను గాని తింటే, వారు తమ బట్టలు ఉతుక్కుని స్నానం చేయాలి. సాయంత్రం వరకు వారు ఆచారరీత్య అపవిత్రులుగా ఉంటారు; తర్వాత శుద్ధులవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","వారు తమ బట్టలు ఉతుక్కోకుండా స్నానం చేయకుండ ఉంటే వారి దోషశిక్షకు వారే బాధ్యులవుతారు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“నీవు ఇశ్రాయేలీయులతో మాట్లాడి, ‘నేను మీ దేవుడనైన యెహోవాను అని చెప్పు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","మీరు నివసించిన ఈజిప్టులోని వారు చేసినట్లు మీరు చేయకూడదు, నేను మిమ్మల్ని తీసుకెళ్లే కనాను దేశంలోని వారు చేసినట్టు మీరు చేయకూడదు. వారి ఆచారాలను పాటించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","మీరు నా చట్టాలకు లోబడాలి, నా శాసనాలను జాగ్రతగా పాటించాలి. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","నా శాసనాలను చట్టాలను మీరు పాటించండి. ఎవరైతే వాటికి లోబడేవారు వాటి వల్లనే జీవిస్తారు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘ఎవరూ తమ రక్తసంబంధులతో లైంగిక సంబంధం పెట్టుకోకూడదు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘నీ తల్లితో లైంగిక సంబంధం పెట్టుకుని నీ తండ్రిని అగౌరపరచవద్దు. ఆమె నీ తల్లి; ఆమెతో లైంగిక సంబంధం ఉండకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘నీ తండ్రి భార్యతో లైంగిక సంబంధం పెట్టుకోవద్దు; అది నీ తండ్రిని అగౌరపరుస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘నీ సోదరితో అనగా అదే ఇంట్లో పుట్టిన లేదా వేరొక చోట పుట్టిన నీ తండ్రి కుమార్తెతో గాని నీ తల్లి కుమార్తెతో గాని లైంగిక సంబంధం పెట్టుకోవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘నీ కుమారుని కుమార్తెతో గాని నీ కుమార్తె కుమార్తెతో గాని లైంగిక సంబంధం పెట్టుకోవద్దు; అది నిన్ను అగౌరపరుస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘నీ తండ్రి భార్యకు పుట్టిన కుమార్తెతో లైంగిక సంబంధం పెట్టుకోవద్దు; ఆమె నీ సోదరి. ");
INSERT INTO telotsa_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘నీ తండ్రి సోదరితో లైంగిక సంబంధం పెట్టుకోవద్దు; ఆమె నీ తండ్రి రక్తసంబంధి. ");
INSERT INTO telotsa_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘నీ తల్లి సోదరితో లైంగిక సంబంధం పెట్టుకోవద్దు; ఆమె నీ తల్లి రక్తసంబంధి. ");
INSERT INTO telotsa_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘నీ తండ్రి సోదరుని భార్యతో లైంగిక సంబంధం పెట్టుకొని అతన్ని అగౌరపరచవద్దు; ఆమె నీ పినతల్లి. ");
INSERT INTO telotsa_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘నీ కోడలితో లైంగిక సంబంధం పెట్టుకోవద్దు. ఆమె మీ కుమారుని భార్య; ఆమెతో సంబంధం పెట్టుకోవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘నీ సోదరుని భార్యతో లైంగిక సంబంధం పెట్టుకోవద్దు; అది నీ సోదరుని అగౌరపరుస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘ఒక స్త్రీతో, ఆమె కుమార్తెతో కూడా లైంగిక సంబంధం పెట్టుకోవద్దు. ఆమె కుమారుని కుమార్తెతో గాని కుమార్తె యొక్క కుమార్తెతో గాని లైంగిక సంబంధం పెట్టుకోవద్దు; వారు ఆమె సమీప బంధువులు. అది దుష్టత్వము. ");
INSERT INTO telotsa_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘నీ భార్య బ్రతికి ఉండగా నీ భార్యను బాధపెట్టడానికి ఆమె సోదరిని భార్యగా చేసుకుని ఆమెతో లైంగిక సంబంధం పెట్టుకోవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘స్త్రీ నెలసరి ద్వార అపవిత్రంగా ఉన్నప్పుడు ఆమెతో లైంగిక సంబంధం పెట్టుకోడానికి ఆమె దగ్గరకు వెళ్లవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘పొరుగువాని భార్యతో లైంగిక సంబంధం పెట్టుకొని ఆమెతో నిన్ను నీవు అపవిత్రం చేసుకోవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘మీ పిల్లల్లో ఎవరినీ మోలెకుకు బలి ఇవ్వవద్దు, ఎందుకంటే మీరు మీ దేవుని పేరును అపవిత్రపరచకూడదు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘స్త్రీతో ఉన్నట్లు పురుషునితో లైంగిక సంబంధం పెట్టుకోవద్దు; అది అసహ్యకరమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘జంతువుతో లైంగిక సంబంధం పెట్టుకుని మిమ్మల్ని మీరు దానితో అపవిత్రం చేసుకోవద్దు. జంతువు స్త్రీతో లైంగిక సంబంధం పెట్టుకునేలా ఆమె దాని ముందు నిలబడకూడదు; అది విపరీతము. ");
INSERT INTO telotsa_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘వీటిలో దేని ద్వారానైన మిమ్మల్ని మీరు అపవిత్రం చేసుకోవద్దు, ఎందుకంటే మీ ముందు నుండి నేను వెళ్లగొట్టే దేశాల ప్రజలు ఇలాంటి వాటి వల్లనే అపవిత్రమయ్యారు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ఆ దేశం కూడ అపవిత్రమైంది; కాబట్టి దాని పాపాన్ని బట్టి దాన్ని శిక్షించాను, ఆ దేశం తనలో నివసించేవారిని బయటికి వెళ్లగ్రక్కుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","కానీ మీరు నా శాసనాలను నా చట్టాలను పాటించాలి. మీలో నివసించే స్వదేశీయులు గాని విదేశీయులు గాని ఈ హేయమైన పనులేవి చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ఎందుకంటే ఆ దేశంలో మీకంటే ముందు అక్కడ నివసించిన ప్రజలు ఇవన్నీ చేయడం వలన ఆ దేశం అపవిత్రమైంది. ");
INSERT INTO telotsa_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","మీరు దేశాన్ని అపవిత్రం చేస్తే, అది ముందున్న జనాలను బయటికి వెళ్లగ్రక్కినట్లు మిమ్మల్ని కూడ వెళ్లగ్రక్కుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘ఎవరైనా ఇలాంటి హేయమైన కార్యాలు చేస్తే వారు ప్రజల్లో నుండి తొలగించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","నేను మీకు చెప్పినవి పాటించి, అక్కడ మీకన్నా ముందు నివసించినవారు పాటించిన హేయమైన ఆచారాల్లో దేనినైనా పాటించి వాటివలన మిమ్మల్ని మీరు అపవిత్రపరచుకోకండి. నేను మీ దేవుడనైన యెహోవాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“నీవు ఇశ్రాయేలు సమాజమంతటితో మాట్లాడి వారితో ఇలా చెప్పు: ‘మీరు పరిశుద్ధంగా ఉండాలి ఎందుకంటే, నేను మీ దేవుడనైన యెహోవాను, నేను పరిశుద్ధుడను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘మీలో ప్రతి ఒక్కరు మీ తల్లిదండ్రులను గౌరవించాలి, నా సబ్బాతులను ఆచరించాలి. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘విగ్రహాలవైపు తిరగకండి లేదా మీ కోసం అచ్చు వేసిన విగ్రహ దేవుళ్ళను చేసుకోకండి. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘మీరు యెహోవాకు సమాధానబలి అర్పించినప్పుడు, అది మీ తరపున అంగీకరించబడే విధంగా దానిని అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","మీరు దానిని బలి అర్పించిన రోజున లేదా మరుసటిరోజున తినాలి; మూడవ రోజు వరకు ఏదైనా మిగిలి ఉంటే దానిని కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ఒకవేళ దానిలో నుండి ఏదైనా మూడవ రోజున తిన్నట్లైతే, అది అపవిత్రమైనది, అది అంగీకరించబడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ఎవరైనా దానిని తింటే, యెహోవాకు పరిశుద్ధమైన దానిని అపవిత్రం చేసినందుకు వారు దోషశిక్షను భరిస్తారు; వారు తమ ప్రజల నుండి తొలగించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘మీరు మీ భూమి యొక్క పంటను కోసినప్పుడు, మీ పొలం యొక్క అంచులకు కోయవద్దు లేదా మీ పంట కోతల యొక్క పరిగెలను సేకరించవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","మీ ద్రాక్షతోటపై రెండవసారి వెళ్లవద్దు లేదా పడిపోయిన ద్రాక్షను తీయవద్దు. పేదలు, విదేశీయుల కోసం వాటిని వదిలేయండి. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘దొంగతనం చేయకూడదు. “ ‘అబద్ధాలాడకూడదు. “ ‘ఒకరిని ఒకరు మోసపుచ్చుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘నా పేరిట అబద్ధ ప్రమాణాలు చేసి మీ దేవుని పేరు అపవిత్రపరచకూడదు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘పొరుగువారిని పీడించకండి లేదా దోచుకోకండి. “ ‘కూలివాళ్ళకు ఇవ్వాల్సిన కూలి మరుసటిరోజు ఉదయం వరకు మీ దగ్గర నిల్వ ఉంచుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘చెవిటివారిని శపించవద్దు లేదా గ్రుడ్డివారి ముందు అడ్డు బండలు పెట్టవద్దు, కానీ మీ దేవునికి భయపడండి. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘తీర్పును వక్రీకరించకండి; బీదవారికి పక్షపాతం చూపకూడదు లేదా గొప్పవారిని అభిమానం చూపకూడదు, కాని మీ పొరుగువారికి న్యాయమైన తీర్పు తీర్చండి. ");
INSERT INTO telotsa_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘మీ ప్రజల్లో కొండేలు వ్యాపింపచేస్తూ తిరగకూడదు. “ ‘మీ పొరుగువారి ప్రాణానికి అపాయం కలిగించేది ఏది చేయకూడదు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘మీ తోటి ఇశ్రాయేలీయున్ని మీ హృదయంలో ద్వేషించకూడదు. మీ పొరుగువారి దోషం మీరు భరించకూడదు అంటే మీరు మీ పొరుగువారిని ఉన్నది ఉన్నట్లుగా గద్దించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘ప్రతీకారం ప్రయత్నించవద్దు లేదా మీ ప్రజల్లో ఎవరి మీదా పగ పెట్టుకోవద్దు, కానీ మీకులా మీ పొరుగువారిని ప్రేమించాలి. నేను యెహోవానై ఉన్నాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘నా శాసనాలు పాటించాలి. “ ‘రకరకాల జంతువులతో సంపర్కం కానివ్వకూడదు. “ ‘పొలంలో రెండు జాతుల విత్తనాలు కలిపి చల్లకూడదు. “ ‘రెండు రకాల దారంతో నేసిన బట్టలు ధరించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘ఒక దాసికి మరొక పురుషునితో నిశ్చితార్థం జరిగి, ఆమె కోసం విమోచన క్రయధనం చెల్లించబడక, ఆమెకు విడుదల కలుగక ముందే ఎవడైనా ఆమెతో పడుకున్నట్లైతే సరియైన శిక్ష ఉండాలి. అయితే ఆమె స్వతంత్రురాలు కాదు, కాబట్టి వారు చంపబడాల్సిన అవసరం లేదు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","అయినాసరే, ఆ పురుషుడు సమావేశ గుడార ద్వారం దగ్గరకు ఒక పొట్టేలును తెచ్చి యెహోవాకు అపరాధపరిహారబలి అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","యాజకుడు ఆ పొట్టేలును అపరాధపరిహారబలిగా సమర్పించి యెహోవా ఎదుట అతడు చేసిన పాపానికి ప్రాయశ్చిత్తం జరిగిస్తాడు; అతని పాపం క్షమించబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘మీరు దేశంలోకి ప్రవేశించి, ఎలాంటి పండ్ల చెట్టునైన నాటితే, దాని పండును నిషేధించబడినదానిగా పరిగణించండి. మూడు సంవత్సరాల వరకు మీరు దానిని నిషేధించబడినదానిగా పరిగణించండి; అది తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","నాలుగవ సంవత్సరం దాని పండు పరిశుద్ధంగా, యెహోవాకు స్తుతి యాగంగా ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","అయితే అయిదవ సంవత్సరంలో మీరు దాని పండు తినవచ్చు. ఈ విధంగా మీ పంట అధికమవుతుంది. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘ఏ మాంసమైన ఇంకా రక్తంతో ఉన్నప్పుడు తినకూడదు. “ ‘భవిష్యవాణి పాటించవద్దు లేదా శకునాలు చూడవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘మీ తల ప్రక్క వెంట్రుకలు కత్తిరించవద్దు లేదా మీ గడ్డం చివరలు చిన్నవిగా చేయవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘చనిపోయినవారి కోసం మీ శరీరాలు గాయపరచుకోకూడదు లేదా మీ దేహం మీద పచ్చబొట్లు పొడిపించుకోకూడదు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘మీ కుమార్తెను వేశ్యగా మార్చి ఆమెను దిగజార్చవద్దు, లేదా దేశం వ్యభిచారం వైపు తిరుగుతుంది, దుష్టత్వంతో నిండి ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘నా సబ్బాతులను ఆచరించాలి, నా పరిశుద్ధాలయాన్ని గౌరవించండి. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘మృతుల ఆత్మలతో మాట్లాడేవారి వైపు తిరగకండి లేదా ఆత్మలతో మాట్లాడేవారిని అనుసరించకండి, ఎందుకంటే మీరు వారి ద్వార అపవిత్రం అవుతారు. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘వృద్ధులు ఉన్నప్పుడు వారి ముందు నిలబడండి, వృద్ధులను గౌరవించండి, మీ దేవుని పట్ల భయభక్తులు కలిగి ఉండండి. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘విదేశీయులు మీ దేశంలో మీ మధ్య నివసించినప్పుడు, వారిని చులకనగా చూడవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","మీ మధ్య నివసించే పరదేశిని మీ స్థానికంగా జన్మించిన వానిగా పరిగణించాలి. మీలాగే వారిని ప్రేమించండి, ఎందుకంటే మీరు ఈజిప్టులో విదేశీయులుగా ఉండేవారు. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘పొడవు, బరువు లేదా పరిమాణాన్ని కొలిచేటప్పుడు నిజాయితీ లేని ప్రమాణాలను ఉపయోగించవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","న్యాయమైన త్రాసులు, న్యాయమైన తూనిక రాళ్లు, న్యాయమైన ఏఫా, న్యాయమైన హిన్ ఉపయోగించండి. నేను మిమ్మల్ని ఈజిప్టు నుండి బయటకు తీసుకువచ్చిన మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘నా శాసనాలు, నా చట్టాలన్నిటిని జ్ఞాపకముంచుకొని వాటిని పాటించండి. నేను యెహోవాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ఇశ్రాయేలీయులకు ఇలా చెప్పు: ‘ఇశ్రాయేలులో స్వదేశీయులు గాని విదేశీయులు గాని తమ పిల్లలను మోలెకు దేవతకు అర్పిస్తే అలాంటి వారికి మరణశిక్ష విధించాలి. సమాజం వారిని రాళ్లతో కొట్టి చంపాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","వారు తమ పిల్లలను మోలెకుకు బలి ఇచ్చి నా పరిశుద్ధాలయాన్ని అపవిత్రం చేశారు, నా పవిత్ర నామాన్ని అపవిత్రం చేశారు కాబట్టి నేను వారికి విరోధిగా మారి ప్రజల్లో నుండి వారిని తొలగిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ఎవరైన తమ పిల్లలను మోలెకుకు అర్పించినప్పుడు మీ దేశ ప్రజలు చూసి చూడనట్లు తమ కళ్లు మూసుకుని వారిని చంపకుండా వదిలేస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","స్వయంగా నేనే వారికి వారి కుటుంబానికి వ్యతిరేకంగా మారి వారిని వారితో పాటు కలిసి మోలెకుతో వ్యభిచరించే వారినందరిని ప్రజల్లో నుండి తొలగిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘మృతుల ఆత్మలతో మాట్లాడేవారితో సోదె చెప్పేవారితో వ్యభిచారం చేయడానికి వారిని అనుసరించేవారికి నేను విరోధిగా మారి వారిని ప్రజల్లో నుండి తొలగిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘నేనే మీ దేవుడైన యెహోవాను కాబట్టి మిమ్మల్ని మీరు ప్రతిష్ఠించుకొని పవిత్రంగా ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","నా శాసనాలను పాటించి వాటి ప్రకారం నడుచుకోండి. మిమ్మల్ని పరిశుద్ధపరచే యెహోవాను నేనే. ");
INSERT INTO telotsa_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘తన తండ్రిని గాని తల్లిని గాని దూషించే వారికి మరణశిక్ష విధించాలి. వారు తన తండ్రిని తల్లిని శపించారు కాబట్టి వారి మరణానికి వారే బాధ్యులు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘మరొకని భార్యతో అనగా తన పొరుగువాని భార్యతో వ్యభిచరించిన వారికి ఆ వ్యభిచారిణికి ఇద్దరికి మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘తన తండ్రి భార్యతో లైంగిక సంబంధం ఉన్నవాడు తన తండ్రిని అగౌరపరిచాడు. ఆ స్త్రీ పురుషులిద్దరినీ చంపేయాలి; వారి మరణానికి వారే బాధ్యులు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘ఒకడు తన కోడలితో లైంగిక సంబంధం కలిగియుంటే, వారిద్దరినీ చంపేయాలి; వారు వక్రబుద్ధికి పాల్పడ్డారు; వారి మరణానికి వారే బాధ్యులు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘ఒకడు స్త్రీతో ఉన్నట్టు మరో పురుషునితో లైంగిక సంబంధం కలిగివుంటే వారిద్దరు హేయమైనది చేశారు కాబట్టి వారికి మరణశిక్ష విధించాలి. వారి మరణానికి వారే బాధ్యులు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘ఒకడు స్త్రీని, ఆమె తల్లిని కూడా పెళ్ళి చేసుకోవడం దుర్మార్గము. అతడిని వారిద్దరు అగ్నిలో కాల్చివేయాలి. అప్పుడు మీ మధ్యలో దుర్మార్గం ఉండదు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘జంతువుతో లైంగిక సంబంధం పెట్టుకున్న వానికి మరణశిక్ష విధించాలి, ఆ జంతువును చంపాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘ఒక స్త్రీ లైంగిక సంబంధం కోసం జంతువు దగ్గరకు వెళ్లితే, ఆ స్త్రీని ఆ జంతువు చంపాలి; వారి మరణానికి వారే బాధ్యులు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘ఒకడు తన సోదరిని అనగా తన తండ్రి కుమార్తెను గాని తల్లి కుమార్తెను గాని పెళ్ళి చేసుకుని వారికి లైంగిక సంబంధం ఉంటే, అది అపకీర్తి. వారిని బహిరంగంగా వారి ప్రజల ఎదుట శిక్షించాలి. అతడు తన సోదరిని అగౌరపరిచాడు కాబట్టి అతడే బాధ్యత వహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘ఒకడు నెలసరిలో ఉన్న స్త్రీతో లైంగిక సంబంధం పెట్టుకుంటే అతడు ఆమె రక్తస్రావాన్ని బహిర్గతం చేశాడు, ఆమె కూడ దానిని బయటపెట్టింది. కాబట్టి వారిద్దరిని ప్రజల్లో నుండి తొలగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘మీ తల్లి సోదరితో గాని మీ తండ్రి సోదరితో గాని లైంగిక సంబంధం పెట్టుకోకండి, ఎందుకంటే అది రక్తసంబంధాన్ని అగౌరపరచడమే; వారి శిక్షకు వారే బాధ్యులు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘ఒకడు తన అత్తతో లైంగిక సంబంధం పెట్టుకుంటే, అతడు మామను అగౌరపరచినట్టు. వారి పాపశిక్షకు వారే బాధ్యులు; వారు సంతానం లేకుండా చస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘ఒకడు తన సోదరుని భార్యను పెళ్ళి చేసుకోవడం అపవిత్రమైన పని; అతడు తన సోదరున్ని అగౌరపరచినట్టే వారికి సంతానం కలుగదు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘నా శాసనాలను చట్టాలన్నిటిని పాటించండి, వాటిని అనుసరించండి, తద్వారా మీరు నివసించడానికి నేను మిమ్మల్ని తీసుకెళ్తున్న దేశం మిమ్మల్ని వెళ్లగ్రక్కదు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","నేను మీ ఎదుట నుండి వెళ్లగొట్టబోయే జనాల ఆచారాల ప్రకారం మీరు జీవించకూడదు. వారు అలాంటివి చేశారు కాబట్టి నేను వారిని అసహ్యించుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","కానీ నేను మీతో, “మీరు వారి భూమిని స్వాధీనం చేసుకుంటారు; పాలు తేనెలు ప్రవహించే భూమిని నేను మీకు వారసత్వంగా ఇస్తాను” అని చెప్పాను. దేశాల్లో నుండి మిమ్మల్ని ప్రత్యేకపరచిన మీ దేవుడనైన యెహోవాను నేనే. ");
INSERT INTO telotsa_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘అందువల్ల మీరు పవిత్రమైన జంతువులకు అపవిత్రమైన జంతువులకు, పవిత్రమైన పక్షులకు అపవిత్రమైన పక్షులకు మధ్య వ్యత్యాసాన్ని గుర్తించాలి. అపవిత్రమైనవని మీకు వేరుచేసి చెప్పిన ఏ జంతువు వలన గాని పక్షి వలన గాని నేల మీద ప్రాకే దేనివలన గాని మిమ్మల్ని మీరు అపవిత్రం చేసుకోవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","మీరు నాకు పరిశుద్ధులై ఉండాలి, ఎందుకంటే, నేను యెహోవాను, నేను పరిశుద్ధుడను, జనాల్లో నుండి నేను మిమ్మల్ని నా సొంతవారిగా ప్రత్యేకించుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘మీ మధ్య స్త్రీలలో గాని పురుషులలో గాని మృతుల ఆత్మలతో మాట్లాడేవారు లేదా సోదె చెప్పేవారు వారికి మరణశిక్ష విధించాలి. వారిని రాళ్ళతో కొట్టాలి; వారి మరణానికి వారే బాధ్యులు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","యెహోవా మోషేతో ఇలా అన్నారు, “నీవు యాజకులతో అనగా అహరోను కుమారులతో మాట్లాడి ఇలా చెప్పు: ‘యాజకుడు తన ప్రజల్లో ఎవరు చనిపోయినా వారిని తాకి తనను తాను అపవిత్రపరచుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","తన రక్తసంబంధులైన తన తల్లి, తండ్రి, కుమారుడు, కుమార్తె, సోదరుడు, ");
INSERT INTO telotsa_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","తన ఇంట్లో ఉంటున్న పెళ్ళికాని కన్య అయిన సోదరి చనిపోతే వారిని తాకి తన తాను అపవిత్రం చేసుకోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","యాజకుడు తన భార్య తరుపు బంధువుల కోసం తనను అపవిత్రపరచుకుని అప్రతిష్ఠపాలు కాకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘యాజకులు తమ తల గుండు చేసుకోకూడదు, గడ్డం అంచులు కత్తిరించవద్దు; శరీరాన్ని గాయపరచవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","వారు తమ దేవునికి పరిశుద్ధులై ఉండాలి. వారు తమ దేవుని పేరును అపవిత్రపరచకూడదు. వారు దేవుని ఆహారమైన హోమబలులను యెహోవాకు సమర్పిస్తారు కాబట్టి వారు పరిశుద్ధులై ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘వారు వేశ్యను గాని చెడిపోయిన దాన్ని గాని పెళ్ళి చేసుకోవద్దు. భర్త విడాకులు ఇచ్చిన స్త్రీని పెళ్ళి చేసుకోవద్దు, ఎందుకంటే యాజకులు తమ దేవునికి పవిత్రులు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","మీ దేవునికి ఆహారం వారే అర్పిస్తారు కాబట్టి వారు పరిశుద్ధులు అని మీరు పరిగణించాలి. మిమ్మల్ని పరిశుద్ధులుగా చేసే నేను పరిశుద్ధుడైన యెహోవాను కాబట్టి వారిని పరిశుద్ధులుగా భావించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘యాజకుని కుమార్తె వేశ్యగా మారడం వల్ల తాను అపవిత్రమై తన తండ్రికి అపకీర్తి తెచ్చింది; కాబట్టి ఆమెను అగ్నితో కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘ప్రధాన యాజకునిగా ఉండడానికి తన సహోదరులలో ఎవరి తలపై అభిషేకతైలం పోయబడి, యాజక వస్త్రాలను ధరించడానికి ఎవరు నియమించబడ్డారో వారు తన జుట్టును విరబోసుకోవద్దు, బట్టలు చింపుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","అతడు శవాల దగ్గరకి వెళ్లకూడదు. అతడు తన తండ్రి శవం వలన గాని తల్లి శవం వలన గాని తనను తాను అపవిత్రంగా చేసుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","అతడు తన దేవుని అభిషేక తైలంతో ప్రతిష్ఠించబడ్డాడు కాబట్టి అతడు తన దేవుని పరిశుద్ధాలయాన్ని విడిచిపెట్టకూడదు, దానిని అపవిత్రం చేయకూడదు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘అతడు కన్యను పెళ్ళి చేసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","విధవరాలిని గాని, భర్త విడిచిపెట్టిన దాన్ని గాని, వేశ్యను గాని పెళ్ళి చేసుకోకూడదు, తన సొంత ప్రజల్లో నుండి కన్యను అతడు పెళ్ళి చేసుకోవాలి, ");
INSERT INTO telotsa_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","అతడు తన ప్రజల్లో తన సంతానాన్ని అపవిత్రం చేయకూడదు. అతన్ని పరిశుద్ధపరచే యెహోవాను నేను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“నీవు అహరోనుతో చెప్పు: ‘రాబోయే తరాలలో మీ వారసులలో లోపం ఉన్నవారెవరైనా తన దేవుని ఆహారాన్ని అర్పించడానికి దగ్గరకు రాకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","లోపం ఉన్నవారు అనగా గ్రుడ్డివారు గాని కుంటివారు గాని వికృతంగా ఉన్నవారు గాని లేదా అంగవైకల్యం గలవారు గాని; ");
INSERT INTO telotsa_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","కాలు లేక చేయి విరిగినవారు గాని ");
INSERT INTO telotsa_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","గూనివారు గాని మరుగుజ్జులు గాని కంటి లోపం ఉన్నవారు గాని గజ్జి ఉన్నవారు గాని చీము కారుతున్న పుండ్లతో ఉన్నవారు గాని వరిబీజములు పాడైనవారు గాని సమీపంగా రాకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","యాజకుడైన అహరోను వారసులలో లోపం ఉన్న ఏ ఒక్కరు యెహోవాకు హోమబలులు అర్పించడానికి దగ్గరకు రాకూడదు. అతనికి లోపం ఉంది; అతడు తన దేవుని ఆహారాన్ని అర్పించడానికి దగ్గరకు రాకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","అతడు తన దేవునికి అర్పించే అతి పవిత్రమైన ఆహారాన్ని గాని పవిత్రమైన ఆహారాన్ని తినవచ్చు; ");
INSERT INTO telotsa_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","అయినాసరే అతనికున్న లోపం కారణంగా అతడు తెర దగ్గరకు వెళ్లకూడదు, బలిపీఠం దగ్గరకు వెళ్లకూడదు, నా పరిశుద్ధాలయాన్ని అపవిత్రం చేయకూడదు. వారిని పరిశుద్ధులుగా చేసే యెహోవాను నేనే.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","మోషే అహరోనుకు అతని కుమారులకు ఇశ్రాయేలీయులందరికి ఈ విషయాలు చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ఇశ్రాయేలీయులు నాకు ప్రతిష్ఠించే పవిత్రమైన అర్పణలను గౌరవించుమని అహరోనుతో అతని కుమారులతో చెప్పు, తద్వార వారు నా పవిత్ర నామాన్ని అపవిత్రం చేయకుండ ఉంటారు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“వారితో ఇలా చెప్పు: ‘రాబోయే తరాలలో మీ వారసులలో ఎవరైనా ఆచారరీత్య అపవిత్రులై ఉండి ఇశ్రాయేలీయులు యెహోవాకు ప్రతిష్ఠించే పవిత్ర అర్పణల దగ్గరకు వస్తే, వారు నా సన్నిధిలో నుండి తొలగించబడాలి. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘అహరోను సంతతిలో ఎవరికైనా కుష్ఠువ్యాధి గాని, స్రావ రోగం గాని ఉంటే వారు పవిత్రమయ్యేవరకు పవిత్ర పదార్థాలను తినకూడదు. వారు శవాన్ని గాని అపవిత్రమైన దేనినైనా గాని తాకినా లేదా వీర్యం విసర్జనతో ఉన్న ఎవరినైన తాకినా, వారు అపవిత్రం అవుతారు, ");
INSERT INTO telotsa_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","అపవిత్రమైన ప్రాకే పురుగును తాకినా, లేదా ఆచారరీత్య అపవిత్రంగా ఉన్న మనుష్యుని తాకినవారు అపవిత్రం అవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","అలాంటి వాటిలో దేనినైన తాకితే, వారు సాయంత్రం వరకు అపవిత్రంగానే ఉంటారు. వారు నీటితో స్నానం చేసే వరకు పవిత్రమైన అర్పణల నుండి దేన్ని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","సూర్యుడు అస్తమించినప్పుడు వారు పవిత్రం అవుతారు, తర్వాత వారు పవిత్ర అర్పణలు తినవచ్చు, ఎందుకంటే అది వారి ఆహారము. ");
INSERT INTO telotsa_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","వారు చచ్చినదానిని గాని అడవి జంతువులు చీల్చిన దానిని గాని తిని అపవిత్రం కాకూడదు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘యాజకులు నాకు పరిచర్య చేసినప్పుడు వారికి ఇవ్వబడిన ఆదేశాలను ఉల్లంఘించి దానిని అపవిత్రపరిస్తే దాని పాపదోషం తమ మీదకు చావు తెచ్చుకుంటే దానికి వారే బాధ్యులు. వారిని పరిశుద్ధపరచే యెహోవాను నేనే. ");
INSERT INTO telotsa_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘పరిశుద్ధ అర్పణను యాజక కుటుంబ సభ్యులు తప్ప బయటి వారెవరూ అంటే యాజకుని అతిథి గాని అతని ఇంట్లో జీతగాడు గాని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","అయితే ఒకవేళ యాజకుడు డబ్బుతో బానిసను కొనుగోలు చేస్తే, లేదా బానిసలు అతని కుటుంబంలో జన్మించి ఉంటే, వారు అతని ఆహారాన్ని తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ఒక యాజకుని కుమార్తె యాజకుని కాకుండ వేరేవాన్ని పెళ్ళి చేసుకుంటే, ఆమె పవిత్రమైన దానాలు దేన్ని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ఒక యాజకుని కుమార్తె విధవరాలు అయితే లేదా విడాకులు తీసుకుంటే, ఇంకా పిల్లలు లేకుండా ఆమె యవ్వనురాలై తన తండ్రి ఇంట్లో నివసించడానికి తిరిగి వస్తే, ఆమె తన తండ్రి ఆహారాన్ని తినవచ్చు గాని ఏ అనధికార వ్యక్తి దానిని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘ఎవరైనా పొరపాటున పరిశుద్ధ ఆహారం తింటే దానికి వెలకట్టి దాని వెలలో అయిదవ వంతు కలిపి యాజకునికి ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","యాజకులు ఇశ్రాయేలీయులు యెహోవాకు సమర్పించే పవిత్రమైన అర్పణలను యాజకులు అపవిత్రం చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","వారి మీదికి అపరాధపరిహార రుసుము చెల్లించుకునేలా చేయకూడదు. వారిని పరిశుద్ధపరచే యెహోవాను నేనే.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“అహరోనుతో అతని కుమారులతో, ఇశ్రాయేలీయులందరితో మాట్లాడి వారితో ఇలా చెప్పు: ‘మీలో ఇశ్రాయేలీయుడైనా, ఇశ్రాయేలులో నివసించే పరదేశియైనా యెహోవాకు దహనబలిగా మ్రొక్కుబడిని గాని స్వేచ్ఛార్పణ గాని అర్పిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ఆ అర్పణ అంగీకరించబడేలా పశువుల మందలో నుండి గాని గొర్రె మేకల మందలో నుండి గాని లోపం లేని మగదాన్ని అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","లోపం ఉన్నదానిని తీసుకురాకండి ఎందుకంటే అది మీ పక్షాన అంగీకరించబడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ప్రత్యేక మ్రొక్కుబడి లేదా స్వేచ్ఛార్పణ కోసం ఎవరైనా పశువుల మందలో నుండి గాని లేదా గొర్రెల మందలో నుండి గాని యెహోవాకు సమాధానబలి తెస్తే, అది అంగీకరించబడేలా ఏ లోపం లేనిదై ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","యెహోవాకు గ్రుడ్డి దానిని గాని, గాయపడిన దానిని గాని లేదా అంగవైకల్యం ఉన్నదానిని గాని, చీముపట్టిన పుండ్లతో ఉన్నదానిని గాని అర్పించకూడదు. యెహోవాకు హోమబలిగా వీటిలో దేన్ని బలిపీఠం మీద ఉంచవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","అయితే మీరు ఒక అంగవైకల్యంతో ఉన్న ఎద్దును గాని లేదా గొర్రెలను గాని స్వేచ్ఛార్పణగా సమర్పించవచ్చు, కాని ఒక మ్రొక్కుబడి చెల్లించడానికైతే ఇది అంగీకరించబడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","వృషణాలు నలిపివేయబడిన, గాయపడిన, చీల్చివేయబడిన లేదా కత్తిరించబడిన జంతువును మీరు యెహోవాకు అర్పించకూడదు. మీరు మీ స్వదేశంలో ఇలా చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","మీరు అలాంటి జంతువులను విదేశీయుని చేతిలో నుండి స్వీకరించి, వాటిని మీ దేవునికి ఆహారంగా అర్పించకూడదు. అవి అంగవైకల్యం, లోపాలు కలిగి ఉన్నాయి కాబట్టి మీ పక్షాన అవి అంగీకరించబడవు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ఒక దూడ గాని గొర్రెపిల్ల గాని లేదా మేకపిల్ల పుట్టినప్పుడు, అది ఏడు రోజులు తన తల్లితో ఉండాలి. ఎనిమిదవ రోజు నుండి, అది యెహోవాకు సమర్పించబడిన హోమబలిగా అంగీకరించబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ఒకే రోజు ఒక ఆవు లేదా గొర్రెలను, వాటి పిల్లలను మీరు వధించవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“మీరు యెహోవాకు కృతజ్ఞతార్పణ అర్పించినప్పుడు, అది మీ పక్షంగా అంగీకరించబడే విధంగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","అదే రోజు తప్పక దానిని తినాలి; ఉదయం వరకు ఏదీ మిగుల్చవద్దు. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“నా ఆజ్ఞలు పాటించి వాటిని అనుసరించాలి. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","నా పరిశుద్ధ నామాన్ని అపవిత్రం చేయవద్దు, ఎందుకంటే నేను ఇశ్రాయేలీయుల ద్వార పరిశుద్ధునిగా గుర్తించబడాలి. నేను మిమ్మల్ని పరిశుద్ధపరచిన యెహోవాను, ");
INSERT INTO telotsa_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","మీకు దేవునిగా ఉండడానికి నేను మిమ్మల్ని ఈజిప్టు నుండి బయటకు తీసుకువచ్చిన వాడను. నేను యెహోవాను.” ");
INSERT INTO telotsa_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ఇశ్రాయేలీయులతో మాట్లాడి ఇలా చెప్పు: ‘నేను నియమించిన పండుగలు, యెహోవాకు నియమించబడిన పండుగలు, మీరు పరిశుద్ధ సమాజంగా చాటాల్సిన పండుగలు ఇవి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘వారంలో ఆరు రోజులు పని చేయాలి, కాని ఏడవ రోజు సబ్బాతు విశ్రాంతి దినం, పరిశుద్ధ సమాజపు రోజు. అప్పుడు మీరు ఏ పని చేయకూడదు; మీరు ఎక్కడ నివసించినా, అది యెహోవాకు సబ్బాతు దినము. ");
INSERT INTO telotsa_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘ఇవి యెహోవాకు నియమించబడిన పండుగలు, వీటిని మీరు పరిశుద్ధ సమాజానికి వాటి నియామక సమయాల్లో ప్రకటించాలి: ");
INSERT INTO telotsa_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","మొదటి నెల పద్నాలుగవ రోజు సాయంత్రం యెహోవా యొక్క పస్కా పండుగ ప్రారంభము. ");
INSERT INTO telotsa_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ఆ నెల పదిహేనవ రోజు యెహోవా యొక్క పులియని రొట్టెల పండుగ మొదలవుతుంది; ఏడు రోజులు మీరు పులియని రొట్టెలు తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","మొదటి రోజు పరిశుద్ధ సభను నిర్వహించాలి, పనులేవీ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ఏడు రోజులు యెహోవాకు హోమబలులు అర్పించాలి. ఏడవ రోజు పరిశుద్ధ సభను నిర్వహించాలి, జీవనోపాధి కోసమైన పనులేవీ చేయకూడదు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ఇశ్రాయేలీయులతో మాట్లాడి వారితో ఇలా చెప్పు: ‘నేను మీకు ఇవ్వబోతున్న దేశంలోకి మీరు ప్రవేశించినప్పుడు మీరు దాని పంటను కోయండి, మీరు పండించిన మొదటి ధాన్యం యొక్క పనను యాజకుని దగ్గరకు తీసుకుని రండి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","అతడు యెహోవా ఎదుట ఆ పనను పైకెత్తి దానిని అర్పించాలి తద్వార అది మీ పక్షంగా అంగీకరించబడుతుంది; దానిని యాజకుడు సబ్బాతు తర్వాత రోజున పైకెత్తి ఆడించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","పనను పైకెత్తి అర్పించిన రోజు, లోపం లేని ఒక ఏడాది గొర్రెపిల్లను యెహోవాకు దహనబలిగా అర్పించాలి, ");
INSERT INTO telotsa_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","దాని భోజనార్పణతో పాటు రెండు ఓమెర్ల నాణ్యమైన పిండిని నూనెతో కలిపి యెహోవాకు ఇష్టమైన సువాసనగల హోమబలిగా ఒక పావు హిన్ ద్రాక్షరసాన్ని పానార్పణగా సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","మీరు ఈ అర్పణను మీ దేవునికి తీసుకువచ్చే రోజు వరకు ఏ రొట్టె గాని, కాల్చిన ధాన్యం గాని లేదా క్రొత్త ధాన్యం గాని తినకూడదు. మీరు ఎక్కడ నివసించినా, రాబోయే తరాలకు ఇది నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘సబ్బాతు దినం మరుసటి నుండి, మీరు ప్రత్యేక అర్పణ యొక్క పనను తెచ్చిన దినం నుండి, ఏడు వారాలు పూర్తిగా లెక్కించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ఏడవ సబ్బాతు దినానికి సరిగ్గా యాభై రోజులు లెక్కించాలి, అప్పుడు యెహోవాకు క్రొత్త ధాన్య అర్పణ అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","మీరు ఎక్కడ నివసిస్తున్నారో అక్కడినుండి, రెండు ఓమెర్ల నాణ్యమైన పిండితో రెండు రొట్టెలను పులిసిన దానితో కాల్చి, యెహోవాకు అర్పించే ప్రథమ ఫలాల ప్రత్యేక అర్పణగా తీసుకురండి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ఈ రొట్టెతో పాటు లోపం లేని ఏడు ఏడాది మగ గొర్రెపిల్లలను, ఒక చిన్న ఎద్దును, రెండు పొట్టేళ్లను సమర్పించాలి. భోజనార్పణలు, పానార్పణలతో పాటు అవి యెహోవాకు దహనబలిగా ఉంటాయి, అది యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","పాపపరిహారబలి కోసం మేకపోతును, సమాధానబలిగా రెండు ఏడాది మగ గొర్రెపిల్లను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","యాజకుడు రెండు గొర్రెపిల్లలను ప్రథమ ఫలాల రొట్టెలతో పాటు యెహోవా ఎదుట పైకెత్తి ప్రత్యేక అర్పణగా అర్పించాలి. అవి యాజకుని కోసం యెహోవాకు అర్పించే పరిశుద్ధ అర్పణలు. ");
INSERT INTO telotsa_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","అదే రోజు పరిశుద్ధ సభను ప్రకటించాలి, జీవనోపాధి కోసమైన పనులేవీ చేయకూడదు. మీరెక్కడున్నా ఇది రాబోయే తరాలకు నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘మీరు మీ భూమి యొక్క పంటను కోసినప్పుడు, మీ పొలం అంచుల మట్టుకు కోయకండి లేదా మీ పంట కోతలను సేకరించకండి. పేదల కోసం, మీ మధ్య నివసించే విదేశీయుల కోసం వాటిని వదిలేయండి. నేను మీ దేవుడనైన యెహోవాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘ఏడవ నెల మొదటి రోజున మీరు సబ్బాతు విశ్రాంతి దినం, బూర ధ్వనితో స్మరించుకుంటూ పరిశుద్ధ సభ నిర్వహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","సాధారణ పని చేయకూడదు కాని యెహోవాకు హోమబలి అర్పించాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ఈ ఏడవ నెల పదవ రోజు ప్రాయశ్చిత్త దినము. పరిశుద్ధ సభ నిర్వహించి, మీరు ఉపవాసముండాలి, యెహోవాకు హోమబలి సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ఆ రోజు ఎలాంటి పని చేయకూడదు, ఎందుకంటే అది ప్రాయశ్చిత్త దినం, మీ దేవుడైన యెహోవా ఎదుట మీ కోసం ప్రాయశ్చిత్తం చేయబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ఆ రోజున తమను తాము ఉపేక్షించుకొనని వారు తమ ప్రజల నుండి తొలగించబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ఆ రోజు ఎవరైనా పని చేస్తే, వారని తమ ప్రజల నుండి నిర్మూలం చేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","మీరు ఏ పని చేయకూడదు. మీరు ఎక్కడున్నా, రాబోయే తరాలకు ఇది నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","అది మీకు సబ్బాతు విశ్రాంతి దినం, మీరు ఉపవాసముండాలి. ఆ నెల తొమ్మిదవ రోజు సాయంత్రం నుండి మర్నాడు సాయంత్రం వరకు సబ్బాతును ఆచరించాలి.” ");
INSERT INTO telotsa_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘ఏడవ నెల పదిహేనవ రోజున యెహోవా యొక్క గుడారాల పండుగ ప్రారంభమవుతుంది, అది ఏడు రోజులు ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","మొదటి రోజు పరిశుద్ధ సభ నిర్వహించాలి; ఆ రోజు జీవనోపాధి కోసమైన పనులేవీ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ఏడు రోజులు యెహోవాకు హోమబలులు అర్పించాలి, ఎనిమిదవ రోజు పరిశుద్ధ సభ నిర్వహించి యెహోవాకు హోమబలి అర్పించాలి. అది ప్రత్యేక సభ ముగింపు; అప్పుడు జీవనోపాధి కోసమైన పనులేవీ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘ఇవి యెహోవా నియమించబడిన పండుగలు, వీటిని యెహోవాకు హోమబలులు, దహనబలులు, భోజనార్పణలు, బలులు, పానార్పణలు తీసుకురావడానికి పరిశుద్ధ సభలుగా మీరు ప్రకటించాలి. ఏ రోజు అర్పణ ఆ రోజు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ఇవి యెహోవా సబ్బాతులకు, మీ బహుమానాలకు, మ్రొక్కుబడులకు, యెహోవాకు అర్పించే స్వేచ్ఛార్పణలన్నిటికి అధనంగా అర్పించవలసిన అర్పణలు. ");
INSERT INTO telotsa_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘ఏడవ నెల పదిహేనవ రోజు నుండి మీరు పొలం పంట కూర్చుకున్న తర్వాత యెహోవాకు ఏడు రోజుల పండుగ ఆచరించాలి; మొదటి రోజు సబ్బాతు విశ్రాంతి దినం, ఎనిమిదవ రోజు కూడా సబ్బాతు విశ్రాంతి దినము. ");
INSERT INTO telotsa_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","మొదటి రోజున మీరు మనోహరమైన చెట్ల కొమ్మలు, తాటి మట్టలు, కాలువల ప్రక్కన ఉండే నిరవంజి చెట్ల కొమ్మలు, ఇతర నిరవంజి చెట్ల కొమ్మలను పట్టుకుని మీ దేవుడైన యెహోవా ఎదుట ఏడు రోజులు ఆనందించండి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ప్రతి సంవత్సరం ఈ పండుగ యెహోవా కోసం ఏడు రోజులు మీరు ఆచరించాలి. ఇది రాబోయే తరాలకు నిత్య కట్టుబాటుగా ఉంటుంది; దీనిని ఏడవ నెలలో ఆచరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ఏడు రోజులు తాత్కాలిక ఆశ్రయాలలో నివసించండి: స్థానికంగా జన్మించిన ఇశ్రాయేలీయులందరు అలాంటి ఆశ్రయాలలో నివసించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","తద్వార ఇశ్రాయేలీయులను నేను ఈజిప్టు నుండి బయటకు తెచ్చిన తర్వాత వారిని తాత్కాలిక ఆశ్రయాలలో నివసింపజేశానని మీ సంతతివారు తెలుసుకుంటారు. నేను మీ దేవుడనైన యెహోవాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","కాబట్టి మోషే ఇశ్రాయేలీయులకు యెహోవా నియమించబడిన పండుగలను ప్రకటించాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“వెలుగు కోసం దీపాలు నిరంతరం వెలుగుతూ ఉండేలా దంచి తీసిన స్వచ్ఛమైన ఒలీవ నూనెను మీ దగ్గరకు తీసుకురావాలని ఇశ్రాయేలీయులకు ఆజ్ఞాపించు. ");
INSERT INTO telotsa_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","సమావేశ గుడారంలో నిబంధన మందసాన్ని కప్పి ఉంచే తెర బయట అహరోను సాయంత్రం నుండి ఉదయం వరకు నిత్యం యెహోవా ఎదుట దీపాలను వెలిగించాలి. ఇది రాబోయే తరాలకు నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","యెహోవా ఎదుట మేలిమి బంగారు దీపస్తంభంపై ఉన్న దీపాలు ఎప్పుడూ వెలుగుతూ ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“నాణ్యమైన పిండి తీసుకుని ఒక్కొక్క రొట్టెకు రెండు ఓమెర్ల చొప్పున పన్నెండు రొట్టెలు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","యెహోవా ఎదుట మేలిమి బంగారు బల్లపై, వాటిని ఒక వరుసకు ఆరు చొప్పున రెండు వరుసల్లో అమర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","రొట్టెను సూచించడానికి యెహోవాకు అర్పించే హోమబలిగా ఉండడానికి ప్రతి వరుస దగ్గర జ్ఞాపక భాగంగా కొంత స్వచ్ఛమైన ధూపం ఏర్పాటు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","నిత్య నిబంధనగా, ఇశ్రాయేలు పక్షాన ప్రతి సబ్బాతు దినాన యెహోవా ఎదుట ఆ రొట్టెలను బల్లపై పెడుతూ ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","అది అహరోను అతని కుమారులకు చెందినది, వారు దీనిని పరిశుద్ధాలయ ప్రాంతంలో తినాలి, ఎందుకంటే ఇది యెహోవాకు సమర్పించిన హోమబలులలో వారి శాశ్వత వాటాలో అతిపరిశుద్ధమైన భాగము.” ");
INSERT INTO telotsa_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ఒక రోజు ఇశ్రాయేలు తల్లికి ఈజిప్టు తండ్రికి పుట్టిన కుమారుడు ఇశ్రాయేలీయుల మధ్యకు వెళ్లాడు, అక్కడ శిబిరంలో అతనికి, ఒక ఇశ్రాయేలీయునికి మధ్య గొడవ జరిగింది. ");
INSERT INTO telotsa_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ఇశ్రాయేలు స్త్రీ కుమారుడు యెహోవా నామాన్ని దూషిస్తూ శపించాడు; కాబట్టి వారు అతన్ని మోషే దగ్గరకు తీసుకువచ్చారు. (అతని తల్లి పేరు షెలోమీతు, దాను గోత్రానికి చెందిన దిబ్రీ కుమార్తె.) ");
INSERT INTO telotsa_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","యెహోవా చిత్తం వారికి తెలిసే వరకు వారు అతన్ని అదుపులో ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","అప్పుడు యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ఆ దైవదూషకున్ని శిబిరం బయటకు తీసుకెళ్లు. అతని మాటలు విన్న వారంతా అతని తలపై చేతులుంచగానే సమాజమంతా రాళ్లతో అతన్ని కొట్టి చంపాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘ఎవరైనా తమ దేవున్ని శపిస్తే, తమ పాపశిక్షను భరించాలి; ");
INSERT INTO telotsa_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","యెహోవా నామాన్ని ఎవరైనా దూషిస్తే, వారు మరణశిక్షకు గురి అవుతారు. సమాజమంత వారిని రాళ్లతో కొట్టి చంపాలి. విదేశీయులైనా, స్వదేశీయులైనా, యెహోవా నామాన్ని దూషిస్తే, వారికి మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘ఎవరైనా మనుష్యుని చంపితే వారికి మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ఎవరైనా జంతువును చంపితే ప్రాణానికి బదులుగా ప్రాణమిచ్చి నష్టపరిహారం చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","పొరుగువారిని ఎవరైనా గాయపరిస్తే, వారిని కూడా అలాగే గాయపరచాలి: ");
INSERT INTO telotsa_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ఎముక విరగ్గొడితే ఎముక విరగ్గొట్టాలి, కంటికి కన్ను, పంటికి పన్ను. గాయం చేసిన మనుష్యునికి గాయం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ఎవరైనా జంతువును చంపితే నష్టపరిహారం చెల్లించాలి కాని ఎవరైనా మనిషిని చంపితే, వారికి మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","విదేశీయులకు స్వదేశీయులకు ఒకే చట్టం ఉండాలి. నేను మీ దేవుడనైన యెహోవాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","అప్పుడు మోషే ఇశ్రాయేలీయులతో మాట్లాడిన తర్వాత వారు దైవదూషకున్ని శిబిరం బయటకు తీసుకెళ్లి రాళ్లతో కొట్టి చంపారు. యెహోవా మోషేకు ఆజ్ఞాపించినట్లు ఇశ్రాయేలీయులు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","సీనాయి పర్వతం మీద యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ఇశ్రాయేలీయులతో మాట్లాడి ఇలా చెప్పు: ‘నేను మీకు ఇవ్వబోయే దేశంలో మీరు ప్రవేశించినప్పుడు, స్వయాన ఆ భూమి కూడా యెహోవాకు సబ్బాతు పాటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ఆరు సంవత్సరాలు పొలంలో విత్తనాలు చల్లాలి విత్తనాలు చల్లవచ్చు, ద్రాక్షతోటలు సాగుచేసుకుని వాటి ఫలాలు సమకూర్చుకోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","కానీ ఏడవ సంవత్సరం భూమికి సబ్బాతు విశ్రాంతి సంవత్సరం, అది యెహోవాకు సబ్బాతు. మీ పొలాల్లో విత్తనాలు వేయకూడదు. ద్రాక్షతోటలు సాగుచేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","దానికదిగా పెరిగే పంటను కోయవద్దు, సాగుచేయని మీ ద్రాక్షతోటల నుండి ద్రాక్షపండ్లను కోయవద్దు. భూమికి ఒక సంవత్సరం విశ్రాంతి ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","సబ్బాతు సంవత్సరంలో భూమి దానికదిగా ఏ పంట మీకు, మీ దాసులకు, దాసీలకు, మీ మధ్య నివసించే కూలి పనివారికి, అలాగే మీ మధ్య నివసించే విదేశీయులకు ఆహారమవుతుంది, ");
INSERT INTO telotsa_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","అలాగే మీ పశువులకు, మీ దేశంలోని అడవి జంతువులకు ఆహారం అవుతుంది. భూమి దేన్ని ఉత్పత్తి చేసినా తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘ఏడు సబ్బాతు విశ్రాంతి సంవత్సరాలు లెక్కించాలి అంటే ఏడు సంవత్సరాలు ఏడు మార్లు గుణిస్తే ఏడు సబ్బాతు విశ్రాంతి సంవత్సరాల కాలం మొత్తం నలభై తొమ్మిది సంవత్సరాలు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ఏడవ నెల పదవ రోజు అంతటా బూరధ్వని చేయాలి. ప్రాయశ్చిత్త దినాన మీ దేశమంతటా ఈ బూరధ్వని చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","యాభైయవ సంవత్సరాన్ని ప్రతిష్ఠితం చేసి, దేశమంతటా దాని నివాసులందరికి స్వేచ్ఛను ప్రకటించండి. ఇది మీకు యాభైయవ వార్షికోత్సవం అవుతుంది; మీలో ప్రతి ఒక్కరూ మీ కుటుంబ స్వాస్థ్యానికి, మీ సొంత కుటుంబానికి తిరిగి వెళ్లాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","యాభైయవ సంవత్సరం మీకు వార్షికోత్సవంగా ఉండాలి. ఆ ఏట మీరు విత్తనాలు వేయకూడదు, దానంతట అది పెరిగిన పంట కోయగూడదు. తీర్చిదిద్దని ద్రాక్ష తీగె నుండి పండ్లు కోయగూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","అది యాభైయవ వార్షికోత్సవం, మీకు పరిశుద్ధంగా ఉండాలి; నేరుగా పొలాల నుండి తీసుకున్న దానిని మాత్రమే తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘ఈ యాభైయవ వార్షికోత్సవంలో అందరు తమ స్వాస్థ్యానికి తిరిగి వెళ్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘మీ సొంత ప్రజలకు స్థలమేదైన అమ్మినా లేదా వారి నుండి కొన్నా, ఒకరిపట్ల ఒకరు స్వప్రయోజనం ఆశించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","గత యాభైయవ వార్షికోత్సవం తర్వాత ఎన్ని సంవత్సరాలు గడిచాయో లెక్క చూసి ఆ ప్రకారం మీ సొంత ప్రజల దగ్గర పొలం కొనాలి. పంట పండించడానికి మిగతా సంవత్సరాల లెక్క ప్రకారమే అతడు అమ్మాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","సంవత్సరాలు చాలా ఉన్నప్పుడు, మీరు ధరను పెంచాలి, సంవత్సరాలు తక్కువగా ఉన్నప్పుడు, మీరు ధరను తగ్గించాలి, ఎందుకంటే మీకు నిజంగా అమ్మబడుతుంది పంటల సంఖ్య. ");
INSERT INTO telotsa_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ఒకరిపట్ల ఒకరు స్వప్రయోజనం చూసుకోకూడదు కాని మీ దేవునికి భయపడాలి. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘నా శాసనాలు పాటించండి, నా చట్టాలకు లోబడుటలో జాగ్రత్త వహించండి, తద్వార మీరు దేశంలో క్షేమంగా జీవిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","అప్పుడు భూమి దాని ఫలాలను ఇస్తుంది, మీరు మీ సమృద్ధి నుండి తిని అక్కడ క్షేమంగా జీవిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“మేము మా పంటలను నాటడం లేదా పండించకపోతే ఏడవ సంవత్సరంలో మేము ఏమి తింటాము?” అని మీరు అడగవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ఆరవ సంవత్సరంలో మీకు మూడేళ్లకు తగినంత దిగుబడిని భూమి ఇచ్చేటువంటి ఆశీర్వాదం నేను పంపుతాను. ");
INSERT INTO telotsa_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ఎనిమిదవ సంవత్సరంలో మళ్ళీ విత్తనాలు వేయండి. ఆ సంవత్సరంలో మళ్ళీ తొమ్మిదవ సంవత్సరంలో పంట కూర్చునే వరకు మీరు ఆ పంటే తింటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘భూమి శాశ్వతంగా అమ్మకూడదు, ఎందుకంటే భూమి నాది, మీరు నా భూమిలో విదేశీయులు, అపరిచితులుగా నివసిస్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","మీరు స్వాధీనంగా కలిగి ఉన్న భూమి అంతటా, మీరు భూమిని విడిపించడానికి తప్పక ఏర్పాటు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘ఒకవేళ మీ తోటి ఇశ్రాయేలీయులలో ఒకరు పేదవారిగా మారి వారి ఆస్తిలో కొంత భాగాన్ని అమ్మితే, వారి అతి సమీపబంధువు వచ్చి వారు అమ్మిన వాటిని తిరిగి విడిపించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ఒకవేళ, వారి కోసం దానిని విడిపించడానికి సమీపబంధువు ఎవరు లేకపోతే, కాని తర్వాత వారు వృద్ధి చెంది దానిని విడిపించుకోడానికి తగినంత సంపాదిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","వారు దాన్ని కొన్నప్పటి నుండి వారు విలువను నిర్ణయించి, బకాయిలను వారు ఎవరికి అమ్మారో వారికి తిరిగి చెల్లించాలి; వారు తిరిగి వారి సొంత ఆస్తికి వెళ్లవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ఆస్తి మళ్ళీ కొనుక్కోవడానికి కావలసినంత డబ్బు వారికి దొరక్కపోతే, వారు అమ్మిన ఆస్తి యాభైయవ వార్షికోత్సవం వరకు కొన్న వారి స్వాధీనమవుతుంది. యాభైయవ వార్షికోత్సవంలో అది వారికి తిరిగి ఇవ్వబడుతుంది, వారు తమ స్వాస్థ్యానికి తిరిగి వెళ్లవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘ప్రాకారాలు గల పట్టణంలో ఎవరైనా ఇంటిని అమ్మితే, దాని అమ్మకం తర్వాత పూర్తి సంవత్సరం విముక్తి హక్కును కలిగి ఉంటారు. ఆ సమయంలో అమ్మేవారు దానిని విడిపించవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ఒకవేళ సంవత్సరం పూర్తిగా గడిచే లోపు దానిని విడిపించకపోతే, ప్రాకారం కలిగిన పట్టణంలోని ఇల్లు శాశ్వతంగా కొనుగోలుదారునికి, అతని వారసులకు చెందుతుంది. ఇది యాభైయవ వార్షికోత్సవంలో తిరిగి ఇవ్వబడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","కానీ వారి చుట్టూ ఉన్న ప్రాకారాలు లేని గ్రామాల్లోని ఇల్లు బహిరంగ దేశానికి చెందినవిగా పరిగణించాలి. అవి విడిపించబడవచ్చు, అవి యాభైయవ వార్షికోత్సవంలో తిరిగి ఇవ్వబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘లేవీయులకు శాశ్వతంగా తమ దగ్గర ఉన్న లేవీయ పట్టణాల్లో తమ ఇళ్ళను విడిపించుకునే హక్కు ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","కాబట్టి లేవీయుల ఆస్తి విడిపించదగినది అంటే, వారి ఇల్లు ఏ పట్టణంలో అమ్మబడినా యాభైయవ వార్షికోత్సవంలో, తిరిగి ఇవ్వబడాలి, ఎందుకంటే లేవీయుల పట్టణాలలోని ఇల్లు ఇశ్రాయేలీయుల మధ్యలో వారి ఆస్తి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","కానీ వారి పట్టణాలకు చెందిన పచ్చికబయళ్లు అమ్మకూడదు; అది వారి శాశ్వత స్వాస్థ్యము. ");
INSERT INTO telotsa_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘మీ తోటి ఇశ్రాయేలీయులలో ఎవరైనా పేదలుగా మారి, మీలో తమను తాము ఆదరించుకోలేకపోతే, మీరు ఒక విదేశీయునికి, అపరిచితునికి చేసినట్టుగానే వారికి సహాయం చేయండి, కాబట్టి వారు మీ మధ్య జీవించడం కొనసాగించవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","వారి నుండి వడ్డీ లేదా లాభం తీసుకోకండి, అయితే మీ దేవునికి భయపడండి, తద్వారా వారు మీ మధ్యనే జీవించడం కొనసాగించవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","మీరు వారికి వడ్డీకి డబ్బు ఇవ్వకూడదు లేదా లాభం కోసం ఆహారాన్ని అమ్మకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","మీకు కనాను దేశాన్ని ఇచ్చి, నేను మీకు దేవుడనై ఉండాలని మిమ్మల్ని ఈజిప్టు నుండి బయటకు తీసుకువచ్చిన మీ దేవుడనైన యెహోవాను నేనే. ");
INSERT INTO telotsa_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘మీ తోటి ఇశ్రాయేలీయులలో ఎవరైనా పేదలుగా మారి తమను తాము మీకు అమ్ముకున్నట్లయితే, వారితో బానిసలుగా పని చేయించవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","వారిని మీ మధ్య జీతగాలుగా లేదా తాత్కాలిక నివాసితులుగా పరిగణించాలి; యాభైయవ వార్షికోత్సవం వరకు, వారు మీ కోసం పని చేస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","అప్పుడు వారు, వారి పిల్లలు విడవబడాలి, వారు తమ కుటుంబాల దగ్గరకు, వారి పూర్వికుల స్వాస్థ్యానికి వెళ్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ఎందుకంటే ఇశ్రాయేలీయులు నా సేవకులు, నేనే ఈజిప్టు నుండి వారిని బయటకు తీసుకువచ్చాను, బానిసలుగా వారు అమ్మబడకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","వారిని కఠినంగా పాలించవద్దు, మీ దేవునికి భయపడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘మీ చుట్టూ ఉన్న జనాంగాలలో నుండి దాసులు, దాసీలు రావాలి; వారి నుండి బానిసలను కొనవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","మీ మధ్యనున్న తాత్కాలిక నివాసులు, మీ దేశంలో పుట్టిన వారి కుటుంబాల సభ్యులను మీరు కొనవచ్చు. వారు మీ సొత్తవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","మీరు వారిని మీ పిల్లలకు వారసత్వపు ఆస్తిగా ఇవ్వవచ్చు, వారిని జీవితకాల బానిసలుగా చేయవచ్చు, కానీ మీరు మీ తోటి ఇశ్రాయేలీయులను కఠినంగా పాలించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘మీ మధ్య నివాసమున్న పరదేశి ధనవంతుడైతే, అతని దగ్గర ఉన్న మీ స్వదేశీయుడు బీదవాడై ధనవంతుని లేదా అతని కుటుంబ సభ్యునికి అమ్ముడు పోతే, ");
INSERT INTO telotsa_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","వారు తమను తాము అమ్మిన తర్వాత విడుదల హక్కును కలిగి ఉంటారు. వారి బంధువుల్లో ఒకరు వారిని విడిపించవచ్చు: ");
INSERT INTO telotsa_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","మామ లేదా ఒక బంధువు లేదా వారి కుటుంబంలోని రక్తసంబంధి ఎవరైనా వారిని విడిపించవచ్చు. లేదా వారు అభివృద్ధి చెందితే, వారు తమను తాము విడిపించుకోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","వారు, వారిని కొనుక్కున్న వ్యక్తి కలిసి అమ్ముడు పోయిన సంవత్సరం నుండి యాభైయవ వార్షికోత్సవం వరకు మిగతా కాలమెంతో లెక్కించాలి. వారి విడుదల యొక్క వెల ఆ సంవత్సరాల లెక్కను బట్టి, జీతగాని వెల ప్రకారం ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ఇంకా చాలా సంవత్సరాలు మిగిలి ఉంటే, వాటి ప్రకారం తమను అమ్ముకున్న వెలలో ఎక్కువ వంతు తమ విడుదలకు మళ్ళీ చెల్లించాల్సి ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","యాభైయవ వార్షికోత్సవం వరకు మిగతా సంవత్సరాలు కొన్ని మాత్రమే ఉంటే తమ లెక్క చూసుకొని వారి విడుదల వెల చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","వారిని జీతగాల్లలా ప్రతి సంవత్సరం పరిగణించాలి; వారు ఎవరికైతే సేవ చేస్తారో వారు, కఠినంగా వ్యవహరించకుండా మీరు చూసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘ఒకవేళ ఈ విధానాల్లో ఎవరైనా విడిపించబడకపోయినా, వారు, వారి పిల్లలు యాభైయవ వార్షికోత్సవంలో విడిపించబడాలి, ");
INSERT INTO telotsa_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ఎందుకంటే ఇశ్రాయేలీయులు నా దాసులుగా ఉన్నారు, నేను ఈజిప్టు దేశం నుండి వారిని తీసుకువచ్చిన నా దాసులు. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘మీ కోసం విగ్రహాలను తయారుచేసుకోవద్దు లేదా ఒక బొమ్మను గాని పవిత్రమైన రాయిని గాని నిలుపకూడదు, దాని ముందు తలవంచడానికి చెక్కిన రాయిని మీ భూమిలో పెట్టకూడదు. నేను మీ దేవుడనైన యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘మీరు నా సబ్బాతులను ఆచరించాలి, నా పరిశుద్ధాలయాన్ని గౌరవించండి. నేను యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘ఒకవేళ మీరు నా శాసనాలు పాటిస్తూ, నా ఆజ్ఞలకు లోబడడానికి జాగ్రత్త వహిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","వాన కాలంలో వాన పంపుతాను, భూమి తన పంటను, చెట్లు వాటి ఫలాలను ఇస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ద్రాక్ష కోత వరకు మీ నూర్పిడి కాలం కొనసాగుతుంది, నాటడం వరకు ద్రాక్ష కోత కొనసాగుతుంది, మీరు కోరుకునే ఆహారాన్ని మీరు తిని, మీ దేశంలో క్షేమంగా జీవిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘నేను దేశంలో సమాధానాన్ని అనుగ్రహిస్తాను, మీరు పడుకుంటారు, ఎవరూ మిమ్మల్ని భయపెట్టరు. నేను దేశం నుండి అడవి జంతువులను తొలగిస్తాను, ఖడ్గం మీ దేశం గుండా వెళ్లదు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","శత్రువులను మీరు వెంటాడుతారు. వారు మీ ఎదుట ఖడ్గం ద్వార కూలుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","మీలో అయిదుగురు వందమందిని, వందమంది పదివేలమందిని తరుముతారు, మీ శత్రువులు మీ ఎదుట ఖడ్గం ద్వార కూలుతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘నేను మిమ్మల్ని దయతో చూస్తాను, మిమ్మల్ని ఫలవంతం చేస్తాను, మీ సంఖ్యను పెంచుతాను, నేను మీతో నా నిబంధనను ఉంచుతాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","క్రొత్త దానికి స్థలం ఇవ్వడానికి పాత పంటను ఖాళీ చేయునట్లు మీరు ఇంకా గత సంవత్సర పంటను తింటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","మీ మధ్యనే నా నివాసస్థలం ఉంచుతాను. మిమ్మల్ని త్రోసివేయను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","నేను మీ మధ్య నడుస్తూ మీ దేవునిగా ఉంటాను, మీరు నా ప్రజలై ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ఈజిప్టువారికి ఇక మీరు బానిసలుగా ఉండకూడదని మిమ్మల్ని ఈజిప్టు నుండి బయటకు తెచ్చిన మీ దేవుడనైన యెహోవాను నేనే; నేను మీ బానిసత్వ కాడి యొక్క పట్టీలను విరగ్గొట్టాను, మిమ్మల్ని తలలు పైకెత్తి నడిచేలా చేశాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘కానీ మీరు నా మాట వినకపోతే, ఈ ఆజ్ఞలన్నిటిని పాటించకపోతే, ");
INSERT INTO telotsa_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","మీరు నా శాసనాలను తిరస్కరించి, నా చట్టాలను అసహ్యించుకుని నా ఆజ్ఞలన్నిటిని పాటించడంలో విఫలమై, నా నిబంధనను ఉల్లంఘిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","అప్పుడు నేను మీకు ఇలా చేస్తాను: మీ దృష్టిని నాశనం చేసే, మీ బలాన్ని తగ్గించే ఆకస్మిక భీభత్సం, చెడు వ్యాధులు జ్వరాలు తెస్తాను. మీరు వృధాగా విత్తనాన్ని చల్లుతారు, ఎందుకంటే మీ శత్రువులు దానిని తింటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","నేను మీకు విరోధంగా నా ముఖం పెడతాను, తద్వార మీ శత్రువులతో ఓడిపోతారు; మిమ్మల్ని ద్వేషించేవారే మిమ్మల్ని పరిపాలిస్తారు, ఎవరూ తరమకుండానే మీరు పారిపోతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘ఇదంతటి తర్వాత మీరు నా మాట వినకపోతే, నేను మీ పాపాల కోసం మిమ్మల్ని ఏడు రెట్లు ఎక్కువగా శిక్షిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","నేను మీ మొండి అహంకారాన్ని విచ్ఛిన్నం చేసి, మీ పైన ఉన్న ఆకాశాన్ని ఇనుములా, మీ క్రింద ఉన్న భూమిని ఇత్తడిలా చేస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","మీ బలము వ్యర్థమైపోతుంది ఎందుకంటే మీ నేల తన పంటలను ఇవ్వదు, పండదు. మీ భూమిలో ఉన్న చెట్లు ఫలం ఇవ్వవు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘మీరు నా పట్ల శత్రుత్వం కలిగి ఉంటే, నా మాట వినడానికి నిరాకరిస్తే, మీ పాపాలకు తగినంతగా నేను మీ బాధలను ఏడు రెట్లు పెంచుతాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","మీకు విరుద్ధంగా అడవి జంతువులు పంపుతాను, అవి మీ నుండి మీ పిల్లలను దోచుకుంటాయి, మీ పశువులను నాశనం చేస్తాయి, మీ మార్గాలన్నీ నిర్మానుష్యమయేలా మీ సంఖ్య తగ్గేలా చేస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘ఇవన్నీ జరిగినా కూడా నా దిద్దుబాటును అంగీకరించకుండా నాకు విరుద్ధంగా ఉండడం కొనసాగిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","నేనే మీ పట్ల శత్రువుగా ఉంటాను, మీ పాపాలకు ఇంకా ఏడు రెట్లు బాధిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","నిబంధన ఉల్లంఘనకు ప్రతీకారం తీర్చుకోవడానికి నేను మీపై ఖడ్గం తెస్తాను. మీరు మీ పట్టణాల్లోకి వెళ్లినప్పుడు, నేను మీ మధ్యకు తెగులును పంపుతాను, మీరు శత్రువు చేతుల్లోకి ఇవ్వబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","నేను మీ రొట్టె సరఫరాను నిలిపివేసినప్పుడు, పదిమంది స్త్రీలు మీ రొట్టెను ఒక పొయ్యిలో కాల్చగలుగుతారు, వారు తూనికె చొప్పున రొట్టెను కొలిచి ఇస్తారు. మీరు తింటారు, కానీ మీరు సంతృప్తి చెందరు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘ఇవన్నీ జరిగినా కూడా మీరు నా మాట వినకుండా ఇంకా నాకు విరుద్ధంగా ఉంటే, ");
INSERT INTO telotsa_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","అప్పుడు నా కోపంలో నేను మీ పట్ల శత్రుత్వం కలిగి ఉంటాను, నేనే మిమ్మల్ని మీ పాపాల కోసం ఇంకా ఏడు రెట్లు శిక్షిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","మీరు మీ కుమారుల మాంసాన్ని, మీ కుమార్తెల మాంసాన్ని తింటారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","నేను మీ క్షేత్రాలను నిర్మూలం చేస్తాను, మీ ధూప బలిపీఠాలను పడగొట్టి, మీ మృతదేహాలను ప్రాణం లేని మీ విగ్రహాల రూపాలపై పోగుచేస్తాను, నేను మిమ్మల్ని అసహ్యించుకుంటాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","నేను మీ పట్టణాలను శిథిలాలుగా మారుస్తాను, మీ పరిశుద్ధాలయాలను వృథా చేస్తాను, మీ అర్పణల సువాసన యందు నేను ఆనందించను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","నేను భూమిని వృధా చేస్తాను, తద్వార అక్కడ నివసించే మీ శత్రువులు ఆశ్చర్యపడతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","నేను మిమ్మల్ని దేశాల మధ్యకు చెదరగొట్టి, నా ఖడ్గాన్ని తీసి మిమ్మల్ని వెంటాడుతాను. మీ భూమి వృథా అవుతుంది, మీ పట్టణాలు శిథిలావస్థలో ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","మీరు మీ శత్రువుల దేశంలో ఉన్నప్పుడు భూమి తన సబ్బాతు సంవత్సరాలను ఆనందిస్తుంది తద్వార ఎప్పటికీ అది నిర్జనమై ఉంటుంది; అప్పుడు భూమి విశ్రాంతి తీసుకుని దాని సబ్బాతు దినాలను ఆనందిస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","అన్ని సమయాల్లో అది నిర్జనమై ఉంటుంది, మీరు అందులో నివసించినప్పుడు సబ్బాతు దినాల్లో అది పొందని విశ్రాంతిని పొందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘మీలో మిగిలిన వారికైతే, వారి శత్రువుల దేశాల్లో గాలికి ఆకులు అల్లాడితే పారిపోవునంతగా వారి హృదయాలు ఎంతో భయపడేలా చేస్తాను. ఖడ్గం నుండి వారు పారిపోతున్నట్టు వారు పరుగెత్తుతారు, ఎవరు తరమకుండానే వారు పడిపోతారు, ");
INSERT INTO telotsa_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ఎవరూ వారిని తరమనప్పట్టికి ఖడ్గం నుండి పారిపోతున్నట్లు వారు ఒకరిపై ఒకరు దొర్లుతారు. కాబట్టి మీరు మీ శత్రువుల ఎదుట నిలువలేరు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","మీరు దేశాల మధ్య నశిస్తారు; మీ శత్రువుల భూమి మిమ్మల్ని మ్రింగివేస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","శత్రు దేశంలో మీలో మిగిలిన వారు తమ పాపాలను బట్టి కుళ్ళిపోతారు; తమ పూర్వికుల పాపాలను బట్టి కూడా కుళ్ళిపోతారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","“ ‘కాని వారు తమ పాపాలను, వారి పూర్వికుల పాపాలను ఒప్పుకుని అంటే వారు నాకు చేసిన ద్రోహం, తద్వార నేను వారికి విరుద్ధంగా నడిచి, వారిని శత్రువుల దేశానికి పంపానని ఒప్పుకుని, అంటే సున్నతిలేనివారి హృదయాలు తగ్గించుకొని వారి పాపాలకు వారు మూల్యం చెల్లిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","నేను యాకోబుతో నా నిబంధనను, ఇస్సాకుతో నా నిబంధనను, అబ్రాహాముతో నా నిబంధనను జ్ఞాపకం చేసుకుంటాను, దేశాన్ని జ్ఞాపకం చేసుకుంటాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","భూమి వారిచే విడిచిపెట్టబడుతుంది, నిర్జనమవుతుంది, వారు లేకుండా, నిర్జన స్థితిలో ఉండగా, అది సబ్బాతు దినాలను ఆనందిస్తుంది. వారు నా చట్టాలను తిరస్కరించారు, నా శాసనాలను అసహ్యించుకున్నారు కాబట్టి వారు వారి పాపాలకు మూల్యం చెల్లిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","అయినప్పటికీ, వారు తమ శత్రువుల దేశంలో ఉన్నప్పుడు, వారితో నా నిబంధనను విచ్ఛిన్నం చేస్తూ, వారిని పూర్తిగా నాశనం చేసే విధంగా నేను వారిని తిరస్కరించను, అసహ్యించుకోను. నేను వారి దేవుడనైన యెహోవానై ఉన్నాను. ");
INSERT INTO telotsa_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","అయితే వారి కోసం నేను జనముల దృష్టిలో వారి దేవునిగా ఉండాలని ఈజిప్టు నుండి బయటకు తెచ్చిన వారి పూర్వికులతో నేను చేసిన నిబంధనను జ్ఞాపకం చేసుకుంటాను. నేను యెహోవాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","మోషే ద్వారా తనకు, ఇశ్రాయేలీయులకు మధ్య సీనాయి పర్వతం దగ్గర యెహోవా ఏర్పాటుచేసిన శాసనాలు, చట్టాలు, నియమాలు ఇవి. ");
INSERT INTO telotsa_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ఇశ్రాయేలీయులతో మాట్లాడి వారితో చెప్పు: ‘ఒకవేళ సమాన విలువను ఇవ్వడం ద్వారా ఒక వ్యక్తిని యెహోవాకు అంకితం చేయడానికి ఎవరైనా ప్రత్యేక మ్రొక్కుబడి చేస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","పురుషులకైతే ఇరవై సంవత్సరాల వయస్సు మొదలుకొని అరవై సంవత్సరాల వయస్సు వరకు పరిశుద్ధాలయ షెకెల్ ప్రకారం యాభై షెకెళ్ళ వెండి, వెల నిర్ణయించాలి; ");
INSERT INTO telotsa_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","స్త్రీలకు వెల ముప్పై షెకెళ్ళ వెండి నిర్ణయించాలి; ");
INSERT INTO telotsa_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","అయిదు సంవత్సరాల నుండి ఇరవై సంవత్సరాల లోపు వయస్సుగల వారైతే మగపిల్లవాడికి వెల ఇరవై షెకెళ్ళ వెండి, ఆడపిల్లకు వెల పది షెకెళ్ళ వెండిగా నిర్ణయించాలి; ");
INSERT INTO telotsa_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","నెల మొదలుకొని అయిదు సంవత్సరాల వయస్సుగల మగపిల్లవాడికి వెల అయిదు షెకెళ్ళ వెండి, ఆడపిల్లకు మూడు షెకెళ్ళ వెండిగా నిర్ణయించాలి; ");
INSERT INTO telotsa_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","అరవై సంవత్సరాలు మొదలుకొని ఆపై వయస్సుగల పురుషునికి వెల పదిహేను షెకెళ్ళ వెండిగా, స్త్రీకి వెల పది షెకెళ్ళ వెండిగా నిర్ణయించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","మ్రొక్కుబడి చేసిన ఎవరైనా నిర్దిష్టమైన మొత్తాన్ని చెల్లించలేనంత పేదవారైతే, ప్రతిష్ఠించబడిన వ్యక్తి యాజకునికి సమర్పించబడాలి, అతడు మ్రొక్కుబడి చేసిన వ్యక్తి స్తోమత ప్రకారం విలువను నిర్ణయిస్తాడు. ");
INSERT INTO telotsa_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘ఒకవేళ వారు ప్రమాణం చేసినది ఒక జంతువై అది యెహోవాకు అంగీకారమైన అర్పణ అయితే, అలాంటి జంతువు యెహోవాకు ఇచ్చినప్పుడు పరిశుద్ధమవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","వారు దానిని మార్చుకోవడం లేదా ప్రతిమార్పిడి చేయకూడదు లేదా చెడ్డ దానికి బదులుగా మంచిది, లేదా మంచి దాని బదులు చెడ్డ దానిని ప్రతిమార్పిడి చేయకూడదు; ఒకవేళ వారు ఒక జంతువుకు బదులుగా మరొకదానిని ప్రతిమార్పిడి చేయాలనుకుంటే, అప్పుడు ఇది, ప్రతిమార్పిడి చేసినది రెండూ పరిశుద్ధమవుతాయి. ");
INSERT INTO telotsa_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ఒకవేళ వారు ప్రమాణం చేసిన జంతువు ఆచారరీత్య అపవిత్రమైనదై ఒక అర్పణగా యెహోవాకు అంగీకారమైంది కానట్లైతే, ఆ జంతువును యాజకునికి సమర్పించాలి, ");
INSERT INTO telotsa_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","అతడు దాని నాణ్యత మంచిదా లేదా చెడ్డదా అని నిర్ణయిస్తాడు. యాజకుడు ఏ విలువను నిర్ణయిస్తే, అదే అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ఒకవేళ యజమాని జంతువును విడిపించాలనుకుంటే, దాని విలువకు అయిదవ భాగాన్ని కలపాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘ఒకవేళ ఎవరైనా తమ ఇంటిని పరిశుద్ధమైనదిగా యెహోవాకు ప్రతిష్ఠిస్తే, దాని నాణ్యత మంచిదా లేదా చెడ్డదా అని యాజకుడు నిర్ణయిస్తాడు. యాజకుడు అప్పుడు ఏ వెలను నిర్ణయిస్తే అదే ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ఒకవేళ తమ ఇంటిని ప్రతిష్ఠించినవారు దానిని విడిపించాలనుకుంటే, వారు దాని వెలకు అయిదవ వంతు కలపాలి, ఆ ఇల్లు మళ్ళీ వారిది అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘ఒకవేళ ఎవరైనా తమ కుటుంబ భూమిలో కొంత భాగాన్ని యెహోవాకు ప్రతిష్ఠిస్తే, దానికి అవసరమయ్యే విత్తన మొత్తాన్ని బట్టి దాని వెల నిర్ణయించబడుతుంది. ఒక హోమెరు యవలు విత్తనాల వెల యాభై షెకెళ్ళ వెండి. ");
INSERT INTO telotsa_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","యాభైయవ వార్షికోత్సవంలో వారు భూమిని ప్రతిష్ఠిస్తే, నిర్ణయించబడిన వెల కొనసాగుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","కాని ఒకవేళ యాభైయవ వార్షికోత్సవం తర్వాత భూమిని ప్రతిష్ఠిస్తే, మరుసటి వార్షికోత్సవం వరకు మిగిలి ఉన్న సంవత్సరాల ప్రకారం యాజకుడు వెల నిర్ణయిస్తాడు, దాని నిర్ణయించబడిన వెల తగ్గుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ఒకవేళ భూమిని ప్రతిష్ఠించినవాడు దానిని విడిపించాలనుకుంటే, వారు దాని వెలకు అయిదవ వంతు కలపాలి, అప్పుడు పొలం మళ్ళీ వారిది అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ఒకవేళ, వారు పొలాన్ని విడిపించకపోతే, లేదా వారు దానిని వేరొకరికి అమ్మినట్లయితే, అది ఎప్పటికీ విడిపించబడదు. ");
INSERT INTO telotsa_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","యాభైయవ వార్షికోత్సవంలో పొలం విడిపించబడినప్పుడు, యెహోవాకు ప్రతిష్ఠించబడిన పొలంలా, అది పరిశుద్ధమవుతుంది; అది యాజకత్వపు ఆస్తి అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘ఎవరైనా తాము కొనిన తమ కుటుంబ భూమిలో భాగం కానిది, యెహోవాకు అంకితం చేస్తే, ");
INSERT INTO telotsa_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","యాభైయవ వార్షికోత్సవం వరకు యాజకుడు దాని వెలను నిర్ణయిస్తాడు, యజమాని అది యెహోవాకు చెందిన పరిశుద్ధమైనదిగా దాని వెల ఆ రోజున చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","యాభైయవ వార్షికోత్సవంలో ఆ పొలం ఎవరినుండి కొనుగోలు చేయబడిందో, అది తిరిగి ఆ వ్యక్తికే అనగా ఆ పొలం ఎవరిదో వారిదే అవుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ప్రతి వెల పరిశుద్ధాలయ షెకెల్ ప్రకారం నిర్ణయించబడాలి, షెకెల్ ఒకటికి ఇరవై గెరాలు. ");
INSERT INTO telotsa_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘అయినప్పటికీ, జంతువు యొక్క మొదట పుట్టిన సంతానాన్ని ఎవరూ ప్రతిష్ఠించకూడదు, ఎందుకంటే మొదట సంతానం అప్పటికే యెహోవాకు చెందినది; ఒక ఎద్దు అయినా లేదా గొర్రె అయినా, అది యెహోవాదే. ");
INSERT INTO telotsa_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ఒకవేళ అది అపవిత్రమైన జంతువుల్లో ఒకటి అయితే, దానికి నిర్ణయించబడిన వెలకు, అయిదవ వంతు కలిపి తిరిగి దానిని కొనవచ్చు. ఒకవేళ అది విడిపించబడకపోతే, దానికి నిర్ణయించబడిన వెలకు అమ్మబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘కానీ ఒక వ్యక్తి తనకు చెందిన మనిషైనా జంతువైనా కుటుంబ భూమియైనా యెహోవాకు ప్రతిష్ఠిస్తే దాన్ని అమ్మకూడదు, విడిపించకూడదు; యెహోవాకు ప్రతిష్ఠితమైన ప్రతిదీ అతిపరిశుద్ధము. ");
INSERT INTO telotsa_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘మనుష్యులు నాశనం చేయబడడానికి ప్రతిష్ఠించిన వాటిని విమోచన క్రయధనం చెల్లించి విడిపించకూడదు; వాటిని చంపాల్సిందే. ");
INSERT INTO telotsa_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘భూమి నుండి వచ్చే ప్రతి దానిలో నుండి దశమభాగం, అది భూమి నుండి వచ్చే ధాన్యమైనా లేదా చెట్ల నుండి వచ్చే ఫలాలైనా, యెహోవాకు చెందినది; అది యెహోవాకు పరిశుద్ధమైనది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ఎవరైనా తమ దశమభాగంలో దేనినైన విడిపించుకోవాలంటే దాని వెలకు అయిదవ వంతు కలపాలి. ");
INSERT INTO telotsa_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","మంద, గొర్రెల మంద నుండి ప్రతీ దశమభాగం అనగా గొర్రెల కాపరి కర్ర క్రిందనుండి వెళ్లే ప్రతి పదవ జంతువు యెహోవాకు పరిశుద్ధంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","చెడు నుండి మంచిని తీసుకోకూడదు లేదా ప్రతిమార్పిడి చేయకూడదు. ఒకవేళ ఎవరైనా ప్రతిమార్పిడి చేస్తే జంతువు, దాని ప్రతిమార్పిడి రెండూ పవిత్రమవుతాయి, అవి విడిపించబడలేవు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ఇవి సీనాయి పర్వతం దగ్గర యెహోవా ఇశ్రాయేలీయుల కోసం మోషేకు ఇచ్చిన ఆజ్ఞలు.");
INSERT INTO telotsa_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ఇశ్రాయేలీయులు ఈజిప్టు నుండి బయటకు వచ్చిన రెండవ సంవత్సరం రెండవ నెల మొదటి రోజు సీనాయి ఎడారిలో ఉన్న సమావేశ గుడారంలో యెహోవా మోషేతో మాట్లాడారు. ఆయన ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","మొత్తం సమాజంలోని ఇశ్రాయేలీయుల వంశాలు కుటుంబాల ప్రకారం వారి జనాభా లెక్కలు నమోదు చేయి. ");
INSERT INTO telotsa_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","నీవూ అహరోను కలిసి ఇశ్రాయేలీయులలో ఇరవై సంవత్సరాలు అంతకు పైబడి వయస్సు గలవారు, సైన్యంలో సేవ చేయగలవారిని వారి వారి సేనల ప్రకారం లెక్కించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ప్రతీ గోత్రం నుండి ఒకడు తన కుటుంబానికి పెద్దగా ఉన్న ప్రతీ ఒకడు మీకు సహాయం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“మీకు సహాయం చేయాల్సిన పురుషుల పేర్లు ఇవి: “రూబేను గోత్రం నుండి షెదేయూరు కుమారుడైన ఎలీసూరు; ");
INSERT INTO telotsa_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","షిమ్యోను గోత్రం నుండి సూరీషద్దాయి కుమారుడైన షెలుమీయేలు; ");
INSERT INTO telotsa_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","యూదా గోత్రం నుండి అమ్మీనాదాబు కుమారుడైన నయస్సోను; ");
INSERT INTO telotsa_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ఇశ్శాఖారు గోత్రం నుండి సూయరు కుమారుడైన నెతనేలు; ");
INSERT INTO telotsa_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","జెబూలూను గోత్రం నుండి హేలోను కుమారుడైన ఏలీయాబు; ");
INSERT INTO telotsa_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","యోసేపు కుమారుల నుండి: ఎఫ్రాయిం గోత్రం నుండి అమీహూదు కుమారుడైన ఎలీషామా; మనష్షే గోత్రం నుండి పెదాసూరు కుమారుడైన గమలీయేలు; ");
INSERT INTO telotsa_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","బెన్యామీను గోత్రం నుండి గిద్యోనీ కుమారుడైన అబీదాను; ");
INSERT INTO telotsa_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","దాను గోత్రం నుండి అమీషద్దాయి కుమారుడైన అహీయెజెరు; ");
INSERT INTO telotsa_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ఆషేరు గోత్రం నుండి ఒక్రాను కుమారుడైన పగీయేలు; ");
INSERT INTO telotsa_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","గాదు గోత్రం నుండి దెయూవేలు కుమారుడైన ఎలీయాసాపు; ");
INSERT INTO telotsa_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","నఫ్తాలి గోత్రం నుండి ఏనాను కుమారుడైన అహీర.” ");
INSERT INTO telotsa_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","వీరు సమాజంలో వారి పితరుల గోత్రాల నుండి నాయకులుగా ఏర్పాటు చేయబడినవారు. వీరు ఇశ్రాయేలీయుల వంశాల పెద్దలు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు, మోషే అహరోనులు పేర్లు పేర్కొనబడిన వారిని తీసుకుని, ");
INSERT INTO telotsa_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","రెండవ నెల మొదటి రోజున సమాజమంతటిని సమావేశ పరిచారు. ప్రజలు వారి వారి గోత్రాలు, వారి వారి కుటుంబాల ప్రకారం తమ వంశాన్ని నమోదు చేసుకున్నారు. యిరవై సంవత్సరాలు అంతకు పైబడి వయస్సున్న వారు ఒకరి తర్వాత ఒకరి పేరు నమోదు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం మోషే సీనాయి ఎడారిలో వారిని లెక్కించాడు: ");
INSERT INTO telotsa_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ఇశ్రాయేలు మొదటి సంతానమైన రూబేను సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి, సైన్యంలో పని చేయగలిగే పురుషులందరు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","రూబేను గోత్రం నుండి లెక్కించబడినవారు 46,500. ");
INSERT INTO telotsa_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","షిమ్యోను సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి సైన్యంలో పని చేయగలిగే పురుషులందరు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","షిమ్యోను గోత్రం నుండి లెక్కించబడినవారు 59,300. ");
INSERT INTO telotsa_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","గాదు సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి సైన్యంలో పని చేయగలిగే పురుషులందరు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","గాదు గోత్రం నుండి లెక్కించబడినవారు 45,650. ");
INSERT INTO telotsa_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","యూదా సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకు పైబడి ఉండి సైన్యంలో పని చేయగలిగే పురుషులందరు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","యూదా గోత్రం నుండి లెక్కించబడినవారు 74,600. ");
INSERT INTO telotsa_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ఇశ్శాఖారు సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకు పైబడి ఉండి సైన్యంలో పని చేయగలిగే పురుషులందరు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ఇశ్శాఖారు గోత్రం నుండి లెక్కించబడినవారు 54,400. ");
INSERT INTO telotsa_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","జెబూలూను సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకు పైబడి ఉండి సైన్యంలో పని చేయగలిగే పురుషులందరు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","జెబూలూను గోత్రం నుండి లెక్కించబడినవారు 57,400. ");
INSERT INTO telotsa_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","యోసేపు కుమారులు: ఎఫ్రాయిం సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి సైన్యంలో పని చేయగలిగే పురుషులందరు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ఎఫ్రాయిం గోత్రం నుండి లెక్కించబడినవారు 40,500. ");
INSERT INTO telotsa_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","మనష్షే సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి సైన్యంలో పని చేయగలిగే పురుషులందరు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","మనష్షే గోత్రం నుండి లెక్కించబడినవారు 32,200. ");
INSERT INTO telotsa_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","బెన్యామీను సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి సైన్యంలో పని చేయగలిగే వారు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","బెన్యామీను గోత్రం నుండి లెక్కించబడినవారు 35,400. ");
INSERT INTO telotsa_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","దాను సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి సైన్యంలో పని చేయగలిగే వారు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","దాను గోత్రం నుండి లెక్కించబడినవారు 62,700. ");
INSERT INTO telotsa_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ఆషేరు సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి సైన్యంలో పని చేయగలిగే వారు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ఆషేరు గోత్రం నుండి లెక్కించబడినవారు 41,500. ");
INSERT INTO telotsa_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","నఫ్తాలి సంతతివారి నుండి: యిరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సు ఉండి సైన్యంలో పని చేయగలిగే వారు వారి వంశాలు, వారి కుటుంబాల వంశాల ప్రకారం పేరుపేరున లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","నఫ్తాలి గోత్రం నుండి లెక్కించబడినవారు 53,400. ");
INSERT INTO telotsa_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","వీరంతా ఇశ్రాయేలు పన్నెండు గోత్రాల నాయకులతో కలిసి మోషే అహరోనులచేత లెక్కించబడినవారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ఇశ్రాయేలీయులందరిలో ఇరవై సంవత్సరాలు అంతకన్నా ఎక్కువ వయస్సుండి ఇశ్రాయేలు సైన్యంలో పని చేయగలిగే వారు వారి వంశాలు, వారి కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","వీరి మొత్తం సంఖ్య 6,03,550. ");
INSERT INTO telotsa_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","అయితే లేవీయుల పూర్వికుల గోత్రం ప్రకారం వీరితో పాటు లెక్కించబడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“లేవీయుల గోత్రాన్ని నీవు లెక్క పెట్టకూడదు, ఇశ్రాయేలీయుల జనాభా లెక్కలో చేర్చకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","దానికి బదులుగా సాక్షి గుడారం లేదా సాక్షి గుడారం మీద, దాని ఉపకరణాల మీద, దానికి సంబంధించిన అన్నిటి మీద లేవీయులను నియమించు. వారు సమావేశ గుడారాన్ని, దాని ఉపకరణాలన్నిటిని మోయాలి; వారు దాని చుట్టూ ఉంటూ దానిని చూసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","సమావేశ గుడారాన్ని తరలించాల్సి వచ్చినప్పుడెల్లా, లేవీయులే దానిని క్రిందికి దించాలి, అలాగే సమావేశ గుడారాన్ని వేయాల్సి వచ్చినప్పుడెల్లా, లేవీయులే దాన్ని వేయాలి. ఇతరులు దానిని సమీపిస్తే వారికి మరణశిక్ష విధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ఇశ్రాయేలీయులు తమ తమ గోత్ర విభజన ప్రకారం సొంత జెండాలతో తమ డేరాలు వేసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","అయితే నా కోపం ఇశ్రాయేలీయుల సమాజం మీదికి రాకుండా లేవీయులు సాక్షి గుడారం చుట్టూ డేరాలు వేసుకోవాలి. సాక్షి గుడారాన్ని కాపాడే బాధ్యత లేవీయులదే.” ");
INSERT INTO telotsa_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","యెహోవా మోషేకు ఆజ్ఞాపించినట్లే ఇశ్రాయేలీయులు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","యెహోవా మోషే అహరోనులతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ఇశ్రాయేలీయులు సమావేశ గుడారం చుట్టూ దానికి కొంత దూరంలో, వారిలో ప్రతి ఒక్కరు తమ తమ స్థలంలో తమ గోత్రపు జెండాలను పట్టుకుని శిబిరాలను ఏర్పాటు చేసుకోవాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","తూర్పున, సూర్యుడు ఉదయించే వైపు: యూదా శిబిరానికి చెందిన దళాలవారు తమ జెండాల దగ్గర దిగాలి. అమ్మీనాదాబు కుమారుడైన నయస్సోను యూదా ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","అతని దళంలో ఉన్నవారు 74,600. ");
INSERT INTO telotsa_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","వారి ప్రక్కన ఇశ్శాఖారు గోత్రం వారు దిగాలి. సూయరు కుమారుడైన నెతనేలు ఇశ్శాఖారు ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","అతని దళంలో ఉన్నవారు 54,400. ");
INSERT INTO telotsa_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","వారి ప్రక్కన జెబూలూను గోత్రము. హేలోను కుమారుడైన ఏలీయాబు జెబూలూను ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","అతని విభజనలో ఉన్నవారు 57,400. ");
INSERT INTO telotsa_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","యూదా శిబిరానికి వారి వారి దళాల ప్రకారం కేటాయించబడిన పురుషులందరు, 1,86,400. వారు ముందుగా వెళ్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","దక్షిణం వైపు: రూబేను గోత్రం వారు వారి జెండా క్రింద ఉండాలి. షెదేయూరు కుమారుడైన ఎలీసూరు రూబేను ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","అతని దళంలో ఉన్నవారు 46,500. ");
INSERT INTO telotsa_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","వారి ప్రక్కన షిమ్యోను గోత్రం వారు దిగాలి. సూరీషద్దాయి కుమారుడైన షెలుమీయేలు షిమ్యోను ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","అతని దళంలో ఉన్నవారు 59,300. ");
INSERT INTO telotsa_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","వారి ప్రక్కన గాదు గోత్రం వారు దిగాలి. రగూయేలు కుమారుడైన ఎలీయాసాపు గాదు ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","అతని దళంలో ఉన్నవారు 45,650. ");
INSERT INTO telotsa_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","రూబేను శిబిరానికి వారి వారి దళాల ప్రకారం కేటాయించబడిన వారందరు, 1,51,450. వీళ్ళు రెండవ గుంపుగా వెళ్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","తర్వాత సమావేశ గుడారం, శిబిరాల మధ్యలో లేవీయుల శిబిరం ఉంటుంది. వారు ఉన్న ఈ క్రమంలోనే, ప్రతి ఒక్కరూ తమ జెండా క్రింద తమ స్థలంలో ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","పడమర వైపు: ఎఫ్రాయిం గోత్రం వారి జెండా ప్రకారం ఉండాలి. అమీహూదు కుమారుడైన ఎలీషామా ఎఫ్రాయిం ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","అతని దళంలో ఉన్నవారు 40,500. ");
INSERT INTO telotsa_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","మనష్షే గోత్రం వారు వారి ప్రక్కన దిగాలి. పెదాసూరు కుమారుడైన గమలీయేలు మనష్షే ప్రజల నాయకుడు ");
INSERT INTO telotsa_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","అతని దళంలో ఉన్నవారు 32,200. ");
INSERT INTO telotsa_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","వారి ప్రక్కన బెన్యామీను గోత్రం వారు దిగాలి. గిద్యోనీ కుమారుడైన అబీదాను బెన్యామీను ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","అతని దళంలో ఉన్నవారు 35,400. ");
INSERT INTO telotsa_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ఎఫ్రాయిం శిబిరానికి వారి వారి దళాల ప్రకారం కేటాయించబడిన వారందరు, 1,08,100. వీరు మూడవ గుంపుగా వెళ్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ఉత్తరం వైపున: దాను గోత్రం వారు వారి జెండా దగ్గర ఉండాలి. అమీషద్దాయి కుమారుడైన అహీయెజెరు దాను ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","అతని దళంలో ఉన్న వారి సంఖ్య 62,700. ");
INSERT INTO telotsa_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ఆషేరు గోత్రం వారు వారి ప్రక్కన దిగాలి. ఒక్రాను కుమారుడైన పగీయేలు ఆషేరు ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","అతని దళంలో ఉన్నవారు 41,500. ");
INSERT INTO telotsa_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","వారి ప్రక్కన నఫ్తాలి గోత్రం వారు దిగాలి. ఏనాను కుమారుడైన అహీర నఫ్తాలి ప్రజల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","అతని దళంలో ఉన్నవారు 53,400. ");
INSERT INTO telotsa_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","దాను శిబిరానికి వారి వారి దళాల ప్రకారం కేటాయించబడిన వారందరు, 1,57,600. వీళ్ళు తమ ధ్వజాల ప్రకారం చివరి గుంపుగా జెండాల క్రింద వెళ్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","వారి వారి కుటుంబాల పరంగా లెక్కించబడినవారు ఇశ్రాయేలీయులు వీరు. విభజనల ప్రకారం శిబిరాలలో ఉన్న పురుషులు 6,03,550. ");
INSERT INTO telotsa_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు లేవీయులను ఇతర ఇశ్రాయేలీయులతో లెక్కించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","కాబట్టి యెహోవా మోషేకు ఆజ్ఞాపించినదంతా ఇశ్రాయేలీయులు చేశారు; ఆ ప్రకారం వారు గుడారాలు వేసుకున్నారు, ఆ విధంగా వారి వారి వంశం, కుటుంబంతో ప్రయాణిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","యెహోవా మోషేతో సీనాయి కొండమీద మాట్లాడిన సమయంలో ఉన్న అహరోను మోషేల వంశావళి ఇదే. ");
INSERT INTO telotsa_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","అహరోను కుమారుల పేర్లు: మొదటి సంతానమైన నాదాబు, అబీహు, ఎలియాజరు ఈతామారు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","అవి అహరోను కుమారుల పేర్లు; వీరు అభిషేకించబడిన యాజకులు; వీరు యాజకులుగా సేవ చేయడానికి ప్రతిష్ఠించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","నాదాబు అబీహులు సీనాయి అరణ్యంలో యెహోవా ఎదుట అనధికార అగ్నితో అర్పణ అర్పించినందుకు ఆయన ఎదుటే చనిపోయారు. వారికి కుమారులు లేరు కాబట్టి అహరోను జీవితకాలమంతా, తన కుమారులైన ఎలియాజరు, ఈతామారు యాజకులుగా సేవ చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","యెహోవా మోషేతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“లేవీ గోత్రం వారిని తీసుకువచ్చి యాజకుడైన అహరోనుకు సహాయం చేయడానికి అతని ఎదుట నిలబెట్టు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","వారు సమావేశ గుడారపు సేవ చేస్తూ సమావేశ గుడారం దగ్గర అతని తరపున సమాజమంతటి తరపున విధులు నిర్వర్తిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ప్రత్యక్ష గుడారపు పని చేయడం ద్వారా ఇశ్రాయేలీయుల బాధ్యతలను నెరవేరుస్తూ, వారు సమావేశ గుడారపు సామాగ్రి అంతా చూసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","లేవీయులను అహరోనుకు అతని కుమారులకు అప్పగించు; వారు సంపూర్ణంగా అతని స్వాధీనం చేయబడిన ఇశ్రాయేలీయులు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","యాజకులుగా సేవ చేయడానికి అహరోనును, అతని కుమారులను నియమించు; ఎవరైనా పరిశుద్ధాలయం దగ్గరకు వస్తే వారికి మరణశిక్ష విధించబడుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","యెహోవా మోషేతో ఇలా కూడా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ఇశ్రాయేలు ప్రజల్లో తొలి మగ సంతానం స్థానంలో నేను లేవీయులను తీసుకున్నాను. లేవీయులు నావారు, ");
INSERT INTO telotsa_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ఎందుకంటే తొలిసంతానమంతా నావారు. ఈజిప్టు తొలిసంతానాన్ని నేను మొత్తినప్పుడు, ఇశ్రాయేలీయులలో మనుష్యుల్లో, పశువుల్లో ప్రతి తొలిసంతానాన్ని, నా కోసం ప్రత్యేకపరచుకున్నాను. వారు నా వారిగా ఉండాలి. నేనే యెహోవాను.” ");
INSERT INTO telotsa_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","సీనాయి ఎడారిలో యెహోవా మోషేతో ఇలా అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“లేవీయులను వారి కుటుంబాలు వంశాల ప్రకారం లెక్కించు. ఒక నెల మొదలుకొని ఆపై వయస్సున్న మగవారినందరిని లెక్కించు.” ");
INSERT INTO telotsa_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","కాబట్టి యెహోవా ఆజ్ఞాపించిన ప్రకారం మోషే వారిని లెక్కించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","లేవీ కుమారుల పేర్లు ఇవి: గెర్షోను, కహాతు, మెరారి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","గెర్షోను వంశస్థుల పేర్లు ఇవి: లిబ్నీ, షిమీ. ");
INSERT INTO telotsa_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","కహాతు వంశస్థుల పేర్లు ఇవి: అమ్రాము, ఇస్హారు, హెబ్రోను, ఉజ్జీయేలు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","మెరారి వంశస్థులు: మహలి, మూషి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","లిబ్నీయులు, షిమీయులు వంశస్థులు గెర్షోనుకు చెందినవారు; వీరు గెర్షోను వంశస్థులు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","వీరిలో ఒక నెల మొదలుకొని ఆపై వయస్సున్న మగవారందరి సంఖ్య 7,500. ");
INSERT INTO telotsa_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","గెర్షోను వంశస్థులు సమావేశ గుడారం వెనుక పశ్చిమ వైపు దిగాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","లాయేలు కుమారుడైన ఎలీయాసాపు గెర్షోను కుటుంబాల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","గెర్షోనీయులు కాపాడవలసినవి: సమావేశ గుడారం, గుడారం, దాని పైకప్పు, సమావేశ గుడార ద్వారం యొక్క తెర, ");
INSERT INTO telotsa_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ఆవరణం యొక్క తెరలు, గుడారం బలిపీఠం చుట్టూ ఉన్న ద్వారపు తెర, దాని త్రాళ్లు, వాటికి ఉపయోగించబడే ప్రతి వస్తువు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","అమ్రామీయులు, ఇస్హారీయులు, హెబ్రోనీయులు, ఉజ్జీయేలీయులు కహాతుకు చెందినవారు; వీరు కహాతు వంశస్థులు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ఒక నెల ఆపై వయస్సున్న మగవారందరు 8,600 మంది. పరిశుద్ధాలయాన్ని కాపాడే బాధ్యత కహాతీయులది. ");
INSERT INTO telotsa_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","కహాతు వంశస్థులు సమావేశ గుడారం యొక్క దక్షిణ వైపు దిగాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ఉజ్జీయేలు కుమారుడైన ఎలీషాపాను కహాతు వంశస్థుల కుటుంబాల నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","వారు మందసం, బల్ల, దీపస్తంభం, బలిపీఠాలు, పరిచర్య కోసం పరిశుద్ధాలయం లోని వస్తువులు, తెర వాటికి ఉపయోగించబడే ప్రతి వస్తువు విషయం బాధ్యత వహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","యాజకుడును అహరోను కుమారుడునైన ఎలియాజరు లేవీయుల ప్రధాన నాయకుడు. పరిశుద్ధాలయాన్ని కాపాడే వారి మీద ఇతడు ముఖ్య నాయకునిగా నియమించబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","మహలీయులు, మూషీయుల వంశస్థులు మెరారికి చెందినవారు. వీరు మెరారి వంశస్థులు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ఒక నెల ఆపై వయస్సున్న మగవారందరి సంఖ్య 6,200. ");
INSERT INTO telotsa_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","అబీహయిలు కుమారుడైన సూరీయేలు మెరారి వంశస్థుల కుటుంబాల నాయకుడు. వీరు సమావేశ గుడారం యొక్క ఉత్తర వైపున దిగాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","మెరారీయులు సమావేశ గుడారం యొక్క పలకలు, దాని అడ్డకర్రలు, స్తంభాలు, దిమ్మలు, దాని ప్రతి ఉపకరణాలు వాటికి సంబంధించినవన్నీ, ");
INSERT INTO telotsa_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","అలాగే ఆవరణం చుట్టూ ఉన్న ప్రాకార స్తంభాలు, వాటి దిమ్మలు, వాటి మేకులు త్రాళ్లను కాపాడడానికి నియమింపబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","మోషే, అహరోను, అతని కుమారులు సమావేశ గుడారానికి తూర్పున, అనగా సూర్యుడు ఉదయించే వైపున సమావేశ గుడారానికి ఎదురుగా ఉండాలి. ఇశ్రాయేలీయుల పక్షంగా పరిశుద్ధాలయాన్ని కాపాడే బాధ్యత వీరిది. ఇతరులెవరైనా పరిశుద్ధాలయాన్ని సమీపిస్తే వారికి మరణశిక్ష. ");
INSERT INTO telotsa_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","యెహోవా ఆజ్ఞాపించిన ప్రకారం మోషే అహరోనుల ద్వారా లెక్కించబడిన లేవీయులు, వారి వారి వంశాల ప్రకారం ఒక నెల ఆపై వయస్సున్న మగవారందరి సంఖ్య 22,000. ");
INSERT INTO telotsa_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","యెహోవా మోషేతో, “ఒక నెల లేదా ఆపై వయస్సున్న ఇశ్రాయేలీయుల తొలిసంతానమైన మగవారిని లెక్కించండి, వారి పేర్ల జాబితాను తయారుచేయండి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ఇశ్రాయేలీయుల్లోని తొలిసంతానానికి బదులు లేవీయులను, ఇశ్రాయేలీయుల పశువుల్లో తొలిసంతానానికి బదులు లేవీయుల పశువులను నా కోసం తీసుకోవాలి. నేను యెహోవానై యున్నాను.” ");
INSERT INTO telotsa_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","కాబట్టి మోషే యెహోవా ఆజ్ఞ ప్రకారం ఇశ్రాయేలీయులలో తొలిసంతానాన్ని లెక్కించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ఒక నెల లేదా ఆ పైబడి వయస్సుగల మొదటి సంతానమైన మగవారందరు 22,273 మంది. ");
INSERT INTO telotsa_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","యెహోవా మోషేకు ఇలా కూడా చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ఇశ్రాయేలీయుల తొలి సంతానమంతటికి బదులు లేవీయులను, వారి పశువుల్లో తొలిసంతానానికి బదులు లేవీయుల పశువులను నా కోసం తీసుకో. లేవీయులు నా వారిగా ఉండాలి. నేనే యెహోవాను. ");
INSERT INTO telotsa_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","లేవీయుల కంటే ఇశ్రాయేలీయులు 273 మంది ఎక్కువ ఉన్నారు. వీరిని విడిపించడానికి, ");
INSERT INTO telotsa_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","పరిశుద్ధాలయం యొక్క షెకెల్ చొప్పున, ఒక్క షెకెల్ అంటే ఇరవై గెరాలు, ఒక్కొక్కరికి అయిదు షెకెళ్ళ వెండి తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ఆ మిగిలిన ఇశ్రాయేలీయుల విమోచన కోసం అహరోనుకు అతని కుమారులకు ఆ డబ్బు ఇవ్వాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","కాబట్టి మోషే లేవీయుల ద్వారా విడిపించబడిన వారికంటే ఎక్కువగా ఉన్న వారి నుండి విమోచన డబ్బు తీసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ఇశ్రాయేలీయులలో తొలిసంతానం నుండి పరిశుద్ధాలయ షెకెల్ ప్రకారం మోషే 1,365 షెకెళ్ళ వెండి తీసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","యెహోవా తనకు ఇచ్చిన ఆజ్ఞ ప్రకారం మోషే విమోచన డబ్బును అహరోను అతని కుమారులకు ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","యెహోవా మోషే అహరోనులకు ఇలా చెప్పారు: ");
INSERT INTO telotsa_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“లేవీ గోత్రంలో కహాతు వంశాల, కుటుంబాల ప్రకారం జనాభా లెక్కలు తీసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","సమావేశ గుడారంలో సేవ చేయడానికి వచ్చే ముప్పై నుండి యాభై సంవత్సరాల లోపు వయస్సున్న పురుషులందరినీ లెక్కించు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“కహాతీయులు సమావేశ గుడారంలో చేయాల్సిన పని: అతిపరిశుద్ధమైనవాటిని జాగ్రత్తగా చూసుకోవడము. ");
INSERT INTO telotsa_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ప్రజలు ప్రయాణించాల్సి వచ్చినప్పుడు అహరోను అతని కుమారులు లోపలికి వెళ్లి అడ్డతెర దించి నిబంధన మందసం మీద కప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","తర్వాత వారు ఆ తెరను మన్నికైన తోలుతో కప్పి, దానిపై నీలిరంగు బట్ట పరిచి మోతకర్రలను వాటి ఉంగరాల్లో దూర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“వారు సన్నిధి బల్లమీద నీలిరంగు బట్టను పరిచి దాని మీద పళ్లాలను, పాత్రలు, గిన్నెలు, పానార్పణ కోసం జాడీలను ఉంచాలి; రొట్టె ఎప్పుడూ దాని మీద ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","వారు వాటి మీద ఎర్రబట్ట పరిచి, మన్నికైన తోలుతో దాన్ని కప్పి, మోతకర్రలను ఉంగరాల్లో దూర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“వారు నీలిరంగు బట్ట తీసుకుని దీపస్తంభాన్ని, దాని దీపాలను, వత్తులు కత్తిరించే కత్తెరలను, వాటి పళ్లాలను, దీపాల్లో పోసే ఒలీవనూనె జాడీలన్నిటిని కప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","తర్వాత వారు దానిని, దాని ఉపకరణాలన్నిటిని మన్నికైన తోలుతో చుట్టి మోసుకెళ్లే పలక మీద ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“బంగారు బలిపీఠం మీద వారు నీలిరంగు బట్ట పరిచి, దాన్ని మన్నికైన తోలుతో కప్పి, మోతకర్రలను వాటి ఉంగరాల్లో దూర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“వారు పరిశుద్ధాలయంలో పరిచర్య కోసం వాడే వస్తువులన్నిటిని తీసుకుని వాటిని నీలి బట్టలో చుట్టి, మన్నికైన తోలుతో కప్పి మోసుకెళ్లే పలక మీద ఉంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“వారు ఇత్తడి బలిపీఠం మీది నుండి బూడిదను తీసివేసి, దాని మీద ఊదా బట్ట కప్పాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","తర్వాత వారు బలిపీఠం దగ్గర పరిచర్యకు వాడే అన్ని పాత్రలను, నిప్పు పెనాలు, ముళ్ళ గరిటెలు, పారలు, ప్రోక్షణ గిన్నెలతో సహా దాని మీద పెట్టాలి. దాని మీద మన్నికైన తోలు కప్పి, మోతకర్రలను వాటి స్థలంలో దూర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“అహరోను అతని కుమారులు పరిశుద్ధ సామాగ్రి, పరిశుద్ధ ఉపకరణాలన్నిటిని కప్పడం పూర్తి చేసిన తర్వాత, ప్రజలు ప్రయాణించడానికి సిద్ధంగా ఉన్నప్పుడు మాత్రమే కహాతీయులు వచ్చి దానిని మోయాలి. అయితే వారు పరిశుద్ధమైన వాటిని ముట్టకూడదు, ముట్టుకుంటే వారు చస్తారు. కహాతీయులు సమావేశ గుడారంలో ఉన్నవాటిని మోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“అహరోను కుమారుడును యాజకుడునైన ఎలియాజరు, దీపానికి నూనె, పరిమళ వాసనగల ధూపద్రవ్యం, నిత్యం అర్పించే భోజనార్పణ, అభిషేక తైలం మొదలగువాటిని పర్యవేక్షిస్తాడు. అతడు సమావేశ గుడారమంతటిని, అందులో ఉన్న సామాగ్రిని, పరిశుద్ధ ఉపకరణాలతో పాటు ప్రతిదీ పర్యవేక్షిస్తాడు.” ");
INSERT INTO telotsa_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","యెహోవా మోషే అహరోనులతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“లేవీయుల మధ్య నుండి కహాతీయుల వంశం నాశనమై పోకుండా చూడండి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","వారు అతిపరిశుద్ధమైన వాటి దగ్గరకు వచ్చినప్పుడు చావకుండ బ్రతికి ఉండేలా మీరు వారి కోసం ఇలా చేయండి: అహరోను అతని కుమారులు పరిశుద్ధాలయంలోకి వెళ్లి, వారందరికి వారు చేయాల్సిన పనిని, వారు మోయాల్సిన వాటిని వారికి అప్పగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","అయితే కహాతీయులు పరిశుద్ధమైన వాటిని చూడాలని, కనీసం ఒక్క క్షణమైనా లోనికి వెళ్లకూడదు, వెళ్తే వారు చస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“గెర్షోనీయులను కూడా వారి కుటుంబాలు, వంశాల ప్రకారం జనాభా లెక్కలు తీసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","సమావేశ గుడారంలో సేవ చేయడానికి వచ్చే ముప్పై నుండి యాభై సంవత్సరాల లోపు వయస్సుగల పురుషులందరినీ లెక్కించండి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“మోయడంలో, అలాగే వారి ఇతర పనులలో గెర్షోను వంశస్థుల సేవ ఇదే: ");
INSERT INTO telotsa_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ప్రత్యక్ష గుడారం యొక్క తెరలు అంటే సమావేశ గుడారం దాని కప్పు అలాగే మన్నికైన తోలుతో చేయబడిన వెలుపటి కప్పు ఇంకా సమావేశ గుడార ద్వారం యొక్క తెరలు, ");
INSERT INTO telotsa_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","సమావేశ గుడారం, బలిపీఠం చుట్టూ ఉన్న ఆవరణ తెరలు, ఆవరణ ప్రవేశ ద్వారపు తెరలు, వాటి త్రాళ్లు గుడారంలో సేవకు ఉపయోగించే వస్తువులన్నిటిని మోయాలి. వీటితో చేయాల్సిన పనులన్నీ గెర్షోనీయులు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","గెర్షోనీయులు మోసుకెళ్లే పనైనా లేదా వేరే పనైనా వారి సేవ అంతా అహరోను అతని కుమారుల ఆధ్వర్యంలోనే జరగాలి. వారు మోయాల్సిన బాధ్యతను మీరు వారికి అప్పగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","సమావేశ గుడారం దగ్గర గెర్షోను వంశస్థులు చేయాల్సిన సేవ ఇదే. వారి విధులను అహరోను కుమారుడును యాజకుడునైన ఈతామారు పర్యవేక్షణలో జరగాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“మెరారీయుల కుటుంబాలను వారి వంశాల ప్రకారం జనాభా లెక్క తీసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","సమావేశ గుడారంలో పని చేయడానికి వచ్చే ముప్పై నుండి యాభై సంవత్సరాల వయస్సుగల పురుషులందరినీ లెక్కించండి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","గుడారంలో వారి సేవలో భాగంగా వారు గుడారపు పలకలు, అడ్డకర్రలు, స్తంభాలు, దిమ్మలు, ");
INSERT INTO telotsa_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","అంతేకాక, ఆవరణం చుట్టూ ఉండే స్తంభాలు వాటి దిమ్మలు, మేకులు, త్రాళ్లు వాటికి సంబంధించినవన్నీ వారే మోయాలి. ప్రతి ఒక్కరు మోయడానికి నిర్దిష్టమైన వాటిని అప్పగించండి. ");
INSERT INTO telotsa_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","సమావేశ గుడారం దగ్గర అహరోను కుమారుడు, యాజకుడైన ఈతామారు పర్యవేక్షణలో మెరారి వంశస్థులు చేసే సేవ ఇది.” ");
INSERT INTO telotsa_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","మోషే, అహరోనులు సమాజ నాయకులతో కలిసి కహాతీయులను వారి వంశాలు, వారి కుటుంబాల ప్రకారం లెక్కించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","36","వంశాల ప్రకారం, ముప్పై నుండి యాభై సంవత్సరాల లోపు వయస్సు కలిగి సమావేశ గుడారంలో సేవ చేయడానికి వచ్చిన పురుషులంతా 2,750 మంది. ");
INSERT INTO telotsa_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","సమావేశ గుడారం దగ్గర సేవచేసే కహాతు వంశాల మొత్తం లెక్క ఇది. యెహోవా మోషే ద్వారా ఇచ్చిన ఆజ్ఞ ప్రకారం మోషే అహరోనులు వారిని లెక్కించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","గెర్షోనీయులు వారి వంశాలు, కుటుంబాల ప్రకారం లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","40","వంశాల ప్రకారం, ముప్పై నుండి యాభై సంవత్సరాల లోపు వయస్సు కలిగి, సమావేశ గుడారంలో సేవ చేయడానికి వచ్చిన పురుషులందరు 2,630 మంది. ");
INSERT INTO telotsa_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","సమావేశ గుడారం దగ్గర సేవ చేసిన గెర్షోను వంశాల మొత్తం లెక్క ఇది. యెహోవా ఆజ్ఞ ప్రకారం మోషే అహరోనులు వారిని లెక్కించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","మెరారీయులు వారి వంశాలు కుటుంబాల ప్రకారం లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","44","వంశాల ప్రకారం, ముప్పై నుండి యాభై సంవత్సరాల లోపు వయస్సు కలిగి సమావేశ గుడారంలో సేవ చేయడానికి వచ్చిన పురుషులందరు 3,200 మంది. ");
INSERT INTO telotsa_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","మెరారి వంశాల మొత్తం లెక్క ఇది. మోషే ద్వారా వచ్చిన యెహోవా ఆజ్ఞమేరకు మోషే అహరోనులు వారిని లెక్కించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","మోషే, అహరోను ఇశ్రాయేలు నాయకులు కలిసి లేవీయులందరిని వంశాల, కుటుంబాల ప్రకారం లెక్కించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","వంశాల ప్రకారం, ముప్పై నుండి యాభై సంవత్సరాల వయస్సు కలిగి సమావేశ గుడారంలో సేవ చేయడానికి దాన్ని మోయడానికి వచ్చిన వారి ");
INSERT INTO telotsa_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","సంఖ్య 8,580. ");
INSERT INTO telotsa_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","మోషే ద్వార వచ్చిన యెహోవా ఆజ్ఞ ప్రకారం, వారందరికి వారి వారి పనులు, వారు మోయాల్సినవి అప్పగించబడ్డాయి. యెహోవా మోషేకు ఇచ్చిన ఆజ్ఞ ప్రకారం, వారు లెక్కించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ఎవరికైనా అపవిత్రమైన కుష్ఠువ్యాధి ఉన్నా లేదా ఏదైనా స్రావము కలిగి ఉన్నా లేదా శవాన్ని ముట్టుకొని ఆచారరీత్య అపవిత్రమై ఉన్నా, అలాంటి వారిని శిబిరంలో నుండి పంపివేయాలని ఇశ్రాయేలుకు ఆజ్ఞాపించు. ");
INSERT INTO telotsa_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","పురుషులనైనా స్త్రీలనైనా పంపివేయాలి; నేను ప్రజలమధ్య నివసిస్తాను కాబట్టి వారు శిబిరాన్ని అపవిత్రం చేయకుండేలా వారిని పంపివేయాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ఇశ్రాయేలీయులు అలాగే చేశారు; వారిని శిబిరం బయటకు పంపివేశారు. యెహోవా మోషేకు సూచించిన ప్రకారం వారు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","యెహోవా మోషేతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ఇశ్రాయేలీయులతో ఇలా చెప్పు: ‘ఏ స్త్రీ గాని, పురుషుడు గాని యెహోవా పట్ల ద్రోహులై మనుష్యులు చేసే పాపాల్లో దేనినైనా చేసి అపరాధులైతే, ");
INSERT INTO telotsa_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","వారు వారి పాపాన్ని ఒప్పుకుని వారు చేసిన అపరాధానికి పూర్ణ ప్రాయశ్చిత్తం చేయాలి, చేసిన తప్పుకు అయిదవ వంతు చేర్చి ఎవరికి విరుద్ధంగా తప్పు చేశారో వారికి ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","అయితే ఆ వ్యక్తికి నష్టపరిహారం చెల్లించడానికి సమీపబంధువు లేకపోతే, ఆ నష్టపరిహారం యెహోవాది, అది ప్రాయశ్చిత్త బలిగా ఇవ్వబడే పొట్టేలుతో పాటు యాజకునికి ఇవ్వబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ఇశ్రాయేలీయులు ఒక యాజకునికి తీసుకొనివచ్చే పవిత్రమైన విరాళాలన్నీ అతనికే చెందుతాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","పవిత్రమైనవి వాటి యజమానులకు చెందుతాయి, కానీ వారు యాజకునికి ఇచ్చేది యాజకునికే చెందుతుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ఇశ్రాయేలీయులతో మాట్లాడి వారికి ఇలా చెప్పు: ‘ఒకవేళ ఒక వ్యక్తి భార్య దారితప్పి అతనికి నమ్మకద్రోహం చేసి, ");
INSERT INTO telotsa_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","మరొక వ్యక్తి ఆమెతో లైంగిక సంబంధాలు పెట్టుకొని, ఆ విషయం తన భర్తకు తెలియకుండ దాచబడి ఆమె అపవిత్రపరచబడింది అనడానికి సాక్ష్యం లేకపోయినా, ఆమె పట్టుబడకపోయినా, ");
INSERT INTO telotsa_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ఒకవేళ అతడు తన భార్య మీద అసూయపడి ఆమెను అనుమానించినప్పుడు, ఆమె నిజంగానే అపవిత్రమైతే, ఒకవేళ ఆమె అపవిత్రం కాకపోయినా అతడు ఆమెను అనుమానిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","అతడు తన భార్యను యాజకుని దగ్గరకు తీసుకెళ్లాలి. అతడు ఆమె పక్షంగా ఒక ఓమెరు యవల పిండి తీసుకురావాలి. దాని మీద ఒలీవనూనె పోయకూడదు ధూపం వేయకూడదు ఎందుకంటే అది అసూయ కోసం అర్పించే భోజనార్పణ, చేసిన తప్పును జ్ఞాపకం చేసే జ్ఞాపక అర్పణ. ");
INSERT INTO telotsa_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘యాజకుడు ఆమెను తీసుకువచ్చి యెహోవా ఎదుట నిలబెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","తర్వాత యాజకుడు ఓ మట్టి కూజలో పవిత్ర జలం తీసుకుని సమావేశ గుడారంలోని నేల మట్టిని ఆ నీటిలో వేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","యాజకుడు యెహోవా ఎదుట ఆమెను నిలబెట్టిన తర్వాత, ఆమె జుట్టును విప్పి, శాపాన్ని తెచ్చే చేదు నీటిని యాజకుడు పట్టుకుని, జ్ఞాపక అర్పణను అంటే అనుమానం కొరకైన జ్ఞాపక అర్పణను ఆమె చేతుల్లో పెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","తర్వాత యాజకుడు ఆ స్త్రీతో ప్రమాణం చేయించి, “ఏ మనుష్యుడు నీతో లైంగిక సంబంధం లేకపోతే, నీ భర్తతో దాంపత్య సంబంధం కలిగి ఉన్నప్పుడు నీవు త్రోవ తప్పకుండ, అపవిత్రం కాకుండ ఉంటే, శాపం తెచ్చే ఈ చేదు నీళ్ల నుండి నీవు నిర్దోషివి అవుతావు. ");
INSERT INTO telotsa_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","అయితే నీ భర్తతో పెళ్ళి చేసుకున్న తర్వాత నీవు త్రోవ తప్పి, నీ భర్త కాకుండా వేరొక వ్యక్తితో లైంగిక సంబంధాలు పెట్టుకోవడం ద్వారా నిన్ను నీవు అపవిత్రపరచుకుని ఉంటే,” ");
INSERT INTO telotsa_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","యాజకుడు ఆమె మీదికి, “యెహోవా నిన్ను నీ ప్రజలమధ్య ఒక శాపంగా చేసి, నీ గర్భం పోవునట్లు, నీ ఉదరం ఉబ్బిపోయేలా చేయును గాక. ");
INSERT INTO telotsa_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","శాపం తెచ్చే ఈ నీరు నీ శరీరంలోనికి ప్రవేశించి నీ ఉదరం ఉబ్బిపోయేలా లేదా నీ గర్భం పోవునట్లు చేయును గాక” అని శాపం పలుకుతాడు. “ ‘అప్పుడు ఆ స్త్రీ, “ఆమేన్, అలాగే జరుగును గాక” అని అనాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘యాజకుడు ఈ శాపాలను ఒక గ్రంథపుచుట్ట మీద వ్రాసి దానిని చేదు నీటితో కడగాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","శాపం తెచ్చే ఆ చేదు నీటిని ఆమెతో త్రాగించాలి, అప్పుడు శాపం తెచ్చే ఆ నీరు ఆమెలో చేదు పుట్టిస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","యాజకుడు ఆమె చేతి నుండి అసూయ కొరకైన భోజనార్పణను తీసుకుని, యెహోవా ఎదుట పైకెత్తి దానిని బలిపీఠం దగ్గరకు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","యాజకుడు ఆ భోజనార్పణలో నుండి పిడికెడు తీసుకుని దాన్ని బలిపీఠం మీద జ్ఞాపకార్థ అర్పణగా దహించాలి; తర్వాత అతడు ఆ స్త్రీతో ఆ నీరు త్రాగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ఆమె తనను తాను అపవిత్రపరచుకుని ఉంటే, తన భర్తకు నమ్మకద్రోహం చేసి ఉంటే, ఫలితం ఇలా ఉంటుంది: శాపం తెచ్చే ఆ నీళ్లను ఆమె త్రాగినప్పుడు, ఆ నీళ్లు ఆమెలో ప్రవేశించి, ఆమె కడుపు ఉబ్బుతుంది, ఆమె గర్భం పోతుంది ఆమె శాపంగా మారుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","అయితే ఆమె తనను తాను అపవిత్రం చేసుకోకుండ పవిత్రంగా ఉంటే, తాను నిర్దోషిగా ఉండి పిల్లలను కనగలుగుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘ఇది అసూయకు సంబంధించిన నియమము. ఒక స్త్రీ తన భర్తతో దాంపత్య సంబంధం కలిగి ఉన్నప్పుడు త్రోవ తప్పి తనను తాను అపవిత్రపరచుకుంటే, ");
INSERT INTO telotsa_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","లేదా ఒక వ్యక్తి తన భార్య మీద అసూయ పడినప్పుడు వర్తించే న్యాయవిధి. యాజకుడు ఆమెను యెహోవా ఎదుట నిలబెట్టి ఈ నియమాన్ని ఆ స్త్రీకి అన్వయింపచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","అప్పుడు ఆ భర్త ఏ తప్పు చేసినా నిర్దోషిగా ఉంటాడు. కానీ స్త్రీ తన పాపపు పరిణామాలను భరిస్తుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","యెహోవా మోషేతో, ");
INSERT INTO telotsa_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ఇశ్రాయేలీయులతో మాట్లాడుతూ ఇలా చెప్పు: ‘పురుషుడు గాని స్త్రీ గాని ఒక ప్రత్యేకమైన మ్రొక్కుబడి చేయాలనుకుంటే అనగా, యెహోవాకు నాజీరుగా ప్రతిష్ఠించుకునే మ్రొక్కుబడి చేయాలనుకుంటే, ");
INSERT INTO telotsa_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","వారు ద్రాక్షరసం, మద్యానికి వేరుగా ఉండాలి, ద్రాక్షరసం నుండి గాని మద్యం నుండి గాని తయారుచేసిన చిరక త్రాగవద్దు. వారు ఏ ద్రాక్షరసం త్రాగకూడదు, పండు ద్రాక్షలు గాని ఎండు ద్రాక్షలు గాని తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","వారు నాజీరుగా ఉన్నంత కాలం ద్రాక్షరసం నుండి వచ్చే ఏవైన, విత్తనాలైనా లేదా వాటి ఎండిన తినకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘నాజీరుగా మ్రొక్కుబడి చేసుకున్న కాలమంతా, వారి వెంట్రుకలు కత్తిరించకూడదు. తమను తాము యెహోవాకు ప్రత్యేకించుకున్న కాలమంతా వారు ముగిసేవరకు పవిత్రులుగా ఉండాలి; వారి వెంట్రుకలు పెరిగేలా వదిలేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘వారు యెహోవాకు తాము ప్రత్యేకించుకున్న కాలమంతా శవం దగ్గరకు వెళ్లకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","వారి సొంత తండ్రి లేదా తల్లి లేదా సోదరుడు లేదా సోదరి మరణించినా కూడా, వారు తమను తాము ఆచారబద్ధంగా అపవిత్రం చేసుకోవద్దు, ఎందుకంటే దేవునికి వారు అంకితం చేసుకున్న చిహ్నం వారి తలపై ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","వారి సమర్పణ కాలం అంతా, వారు యెహోవాకు ప్రతిష్ఠించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘నాజీరు చేయబడినవారు ఉన్నచోట ఎవరైనా చనిపోయి, తాము ప్రతిష్ఠించుకున్న దానికి సూచనగా ఉన్న వారి వెంట్రుకలు అపవిత్రం అయితే, వారు ఏడవ రోజున, శుభ్ర పరచుకునే రోజున తమ తల గొరిగించుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","తర్వాత ఎనిమిదవ రోజు రెండు తెల్ల గువ్వలను, రెండు పావురపు పిల్లలను సమావేశ గుడారం ద్వారం దగ్గర యాజకుడి దగ్గరకు తేవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","నాజీరు శవం దగ్గర ఉండడం పాపమవుతుంది, కాబట్టి ఆ పాపానికి ప్రాయశ్చిత్తంగా యాజకుడు వాటిలో ఒకదాన్ని పాపపరిహారబలిగా, ఇంకొక దానిని దహనబలిగా అర్పించాలి. అదే రోజు తమ తలను మరలా పవిత్రం చేసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","వారు ప్రత్యేకించుకున్న కాలాన్ని నియమించుకొని తిరిగి తమను తాము యెహోవాకు ప్రత్యేకించుకుని ఒక ఏడాది గొర్రెపిల్లను అపరాధపరిహారబలి కోసం తేవాలి. ప్రత్యేకించుకున్న కాలంలో అపవిత్రులయ్యారు కాబట్టి మునుపటి రోజులు లెక్కకు రావు. ");
INSERT INTO telotsa_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘ప్రత్యేకించుకున్న కాలం ముగిసినప్పుడు నాజీరు పాటించవలసిన నియమమేదంటే వారు సమావేశ గుడారం ద్వారం దగ్గరకు రావాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","అక్కడ వారు యెహోవాకు తమ అర్పణలు అర్పించాలి: దహనబలి కోసం లోపం లేని ఏడాది మగ గొర్రెపిల్ల, పాపపరిహారబలి కోసం లోపం లేని ఆడ గొర్రెపిల్ల, సమాధానబలి కోసం లోపం లేని పొట్టేలు, ");
INSERT INTO telotsa_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","వీటితో పాటు భోజనార్పణలు, పానార్పణలు, ఒక గంపెడు నూనె కలిపిన పులుపు కలపకుండ చేసిన నాణ్యమైన పిండి వంటలు ఒలీవనూనె కలిపిన మందమైన రొట్టెలు, ఒలీవనూనె పూసిన అప్పడాలు తీసుకురావాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘ఇవన్నీ యాజకుడు యెహోవా ఎదుట ఉంచి పాపపరిహారబలి, దహనబలి అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","అతడు గంపెడు పులియని రొట్టెలతో పాటు పొట్టేలును భోజనార్పణ పానార్పణంతో పాటు యెహోవాకు సమాధానబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘అప్పుడు సమావేశ గుడారం ద్వారం దగ్గర, నాజీరు తాను ప్రత్యేకించుకున్న దానికి చిహ్నంగా ఉన్న తల వెంట్రుకలను గొరిగించుకోవాలి. ఆ వెంట్రుకలు సమాధానబలి అగ్నిలో వేసేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘నాజీరు తాను ప్రత్యేకించుకున్న దానికి చిహ్నంగా ఉన్న తల వెంట్రుకలను గొరిగించుకున్న తర్వాత వండిన పొట్టేలు జబ్బను, గంపలోని ఒక పులుపు కలపకుండ చేసిన మందమైన రొట్టెను, ఒక అప్పడాన్ని యాజకుడు నాజీరు చేయబడిన వాని చేతిలో పెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","యాజకుడు అప్పుడు వాటిని యెహోవా ఎదుట పైకెత్తి ప్రత్యేక అర్పణగా అర్పించాలి; పైకెత్తబడి అర్పించబడిన రొమ్ము, ప్రత్యేక అర్పణగా సమర్పించబడిన తొడ పరిశుద్ధమైనవి, అవి యాజకునికి చెందినవి. ఆ తర్వాత, నాజీరు చేయబడిన వాడు ద్రాక్షరసం త్రాగవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘తాము ప్రత్యేకించుకున్న దాని ప్రకారం యెహోవాకు అర్పణలను తెస్తామని మ్రొక్కుబడి చేసే నాజీరుల నియమము. వారు తేగలిగితే అధనపు అర్పణలను కూడా తీసుకురావచ్చు. నాజీరు నియమం ప్రకారం వారు చేసిన మ్రొక్కుబడులను వారు తప్పక నెరవేర్చాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","యెహోవా మోషేతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“అహరోను, అతని కుమారులతో చెప్పు, ‘ఈ విధంగా ఇశ్రాయేలీయులను దీవించాలి: ");
INSERT INTO telotsa_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “యెహోవా నిన్ను ఆశీర్వదించి కాపాడును గాక; ");
INSERT INTO telotsa_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","యెహోవా నీ మీద తన ముఖాన్ని ప్రకాశింప జేసి నిన్ను కరుణించును గాక; ");
INSERT INTO telotsa_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","యెహోవా నీవైపు తన ముఖాన్ని త్రిప్పును గాక సమాధానం ఇచ్చును గాక.” ’ ");
INSERT INTO telotsa_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“ఇలా అహరోను అతని కుమారులను ఇశ్రాయేలీయులను నా నామమున దీవించినప్పుడు, నేనే స్వయంగా ఆశీర్వదిస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","మోషే సమావేశ గుడారాన్ని సిద్ధం చేసినప్పుడు దాన్ని అభిషేకించి, దాన్ని, దాని సామాగ్రినంతటిని ప్రతిష్ఠించాడు. అతడు బలిపీఠాన్ని, దాని వస్తువులను కూడా ప్రతిష్ఠించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","తర్వాత ఇశ్రాయేలు నాయకులు, లెక్కించబడిన వారిపట్ల బాధ్యత వహించిన గోత్ర నాయకులు యైన కుటుంబ పెద్దలు అర్పణలు అర్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","వారు యెహోవా ఎదుటకు ప్రతి నాయకుడి నుండి ఒక ఎద్దు, ప్రతి ఇద్దరి నుండి ఒక బండి చొప్పున ఆరు పైకప్పు ఉన్న బండ్లు, పన్నెండు ఎద్దులను తమ బహుమతులుగా తెచ్చారు. వీటిని వారు సమావేశం గుడారం ముందు సమర్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","యెహోవా మోషేతో, ");
INSERT INTO telotsa_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“సమావేశ గుడారం సేవలో వాడబడేలా వారి నుండి వీటిని స్వీకరించు. ప్రతీ వ్యక్తి యొక్క పనికి అవసరం ఉన్న ప్రకారం, వాటిని లేవీయులకు ఇవ్వు.” ");
INSERT INTO telotsa_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","కాబట్టి మోషే ఆ బండ్లను, ఎద్దులను తీసుకుని లేవీయులకు ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","అతడు రెండు బండ్లు, నాలుగు ఎద్దులను గెర్షోనీయులకు, వారి పనికి అవసరం ఉన్న ప్రకారం ఇచ్చాడు, ");
INSERT INTO telotsa_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","అలాగే నాలుగు బండ్లు, ఎనిమిది ఎద్దులను మెరారీయులకు ఇచ్చాడు. వారందరు యాజకుడైన అహరోను కుమారుడు ఈతామారు పర్యవేక్షణలో ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","కానీ మోషే కహాతీయులకు ఏమి ఇవ్వలేదు, ఎందుకంటే వారు వారి బాధ్యత ప్రకారం, పరిశుద్ధ వస్తువులను వారి భుజాలపై మోసేవారు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","బలిపీఠాన్ని అభిషేకించినప్పుడు, నాయకులు ప్రతిష్ఠార్పణలు తెచ్చి, బలిపీఠం ముందుంచారు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","యెహోవా మోషేతో, “బలిపీఠం ప్రతిష్ఠించడం కోసం ప్రతిరోజు ఒక్కొక్క నాయకుడు తమ అర్పణను తీసుకురావాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","మొదటి రోజు తన అర్పణను తెచ్చిన వారు యూదా గోత్రానికి చెందిన అమ్మీనాదాబు కుమారుడైన నయస్సోను. ");
INSERT INTO telotsa_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","రెండవ రోజు అర్పణను తెచ్చిన వారు ఇశ్శాఖారు గోత్ర నాయకుడు, నెతనేలు కుమారుడైన సూయరు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, ఒక సంవత్సరపు అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","మూడవ రోజు అర్పణను తెచ్చిన వారు జెబూలూను గోత్ర నాయకుడు, హేలోను కుమారుడైన ఏలీయాబు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","నాలుగవ రోజు అర్పణను తెచ్చిన వారు రూబేను గోత్ర నాయకుడు, షెదేయూరు కుమారుడైన ఎలీసూరు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","అయిదవ రోజు అర్పణను తెచ్చిన వారు షిమ్యోను గోత్ర నాయకుడు, సూరీషద్దాయి కుమారుడైన షెలుమీయేలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ఆరవరోజు అర్పణను తెచ్చిన వారు గాదు గోత్ర నాయకుడు, దెయూవేలు కుమారుడైన ఎలీయాసాపు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ఏడవ రోజు అర్పణను తెచ్చిన వారు ఎఫ్రాయిం గోత్ర నాయకుడు, అమీహూదు కుమారుడైన ఎలీషామా. ");
INSERT INTO telotsa_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ఎనిమిదవ రోజు అర్పణను తెచ్చిన వారు మనష్షే గోత్ర నాయకుడు, పెదాసూరు కుమారుడైన గమలీయేలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","తొమ్మిదవ రోజు అర్పణను తెచ్చిన వారు బెన్యామీను గోత్ర నాయకుడు, గిద్యోనీ కుమారుడైన అబీదాను. ");
INSERT INTO telotsa_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","పదవ రోజు అర్పణను తెచ్చిన వారు దాను గోత్ర నాయకుడు, అమీషద్దాయి కుమారుడైన అహీయెజెరు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","పదకొండవ రోజు అర్పణను తెచ్చిన వారు ఆషేరు గోత్ర నాయకుడు, ఒక్రాను కుమారుడైన పగీయేలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","పన్నెండవ రోజు అర్పణను తెచ్చిన వారు నఫ్తాలి గోత్ర నాయకుడు, ఏనాను కుమారుడైన అహీర. ");
INSERT INTO telotsa_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","అతని అర్పణ: పరిశుద్ధాలయ షెకెల్ ప్రకారం నూట ముప్పై షెకెళ్ళ బరువు ఉన్న వెండి పళ్ళెం, డెబ్బై షెకెళ్ళ బరువు ఉన్న వెండి చిలకరింపు పాత్ర, భోజనార్పణ కోసం ఈ రెండింటి నిండా ఒలీవనూనె కలిపిన నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ధూపద్రవ్యంతో నిండిన పది షెకెళ్ళ బరువు ఉన్న బంగారు పళ్ళెం; ");
INSERT INTO telotsa_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","దహనబలి కోసం ఒక కోడె, ఒక పొట్టేలు, ఏడాది మగ గొర్రెపిల్ల; ");
INSERT INTO telotsa_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","పాపపరిహారబలి కోసం మేకపోతు; ");
INSERT INTO telotsa_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","సమాధానబలి కోసం రెండు ఎద్దులు, అయిదు పొట్టేళ్లు, అయిదు మేకపోతులు, అయిదు ఏడాది మగ గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","బలిపీఠం అభిషేకించబడినప్పుడు దాని ప్రతిష్ఠించడానికి ఇశ్రాయేలీయుల నాయకులు సమర్పించిన అర్పణలు ఇవి: పన్నెండు వెండి పళ్ళాలు, పన్నెండు వెండి పాత్రలు పన్నెండు బంగారు పాత్రలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","వెండి పళ్ళెం ఒక్కొక్కటి నూట ముప్పై షెకెళ్ళు, వెండి పాత్ర ఒక్కొక్కటి డెబ్బై షెకెళ్ళు. అంతా కలిపితే వెండి పాత్రల బరువు పరిశుద్ధాలయ షెకెల్ ప్రకారం రెండువేల నాలుగు వందల షెకెళ్ళు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ధూపద్రవ్యాలతో నిండియున్న బంగారు పళ్ళాలు, పరిశుద్ధాలయ షెకెల్ ప్రకారం పది షెకెళ్ళ బరువు గలవి పన్నెండు. అంతా కలిపితే, బంగారు పాత్రల బరువు నూట యిరవై షెకెళ్ళు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","దహనబలి కోసం వాటి భోజనార్పణతో పాటు ఇవ్వబడిన పశువులు మొత్తం పన్నెండు కోడెలు, పన్నెండు పొట్టేళ్లు. పన్నెండు ఏడాది గొర్రెపిల్లలు. పన్నెండు మేకపోతులు పాపపరిహారబలి కోసం వాడబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","సమాధానబలి కోసం ఇవ్వబడిన పశువులు మొత్తం యిరవై నాలుగు ఎడ్లు, అరవై పొట్టేళ్లు, అరవై మేకపోతులు అరవై ఏడాది గొర్రెపిల్లలు. ");
INSERT INTO telotsa_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","యెహోవాతో మాట్లాడటానికి మోషే సమావేశ గుడారంలో ప్రవేశించినప్పుడు, నిబంధన మందసం పైనున్న ప్రాయశ్చిత్త మూత మీదుగా ఉన్న రెండు కెరూబుల మధ్య నుండి అతనితో మాట్లాడటం అతనికి వినిపించింది. ఇలా యెహోవా అతనితో మాట్లాడారు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","యెహోవా మోషేతో ఇలా చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“అహరోనుతో మాట్లాడి ఇలా చెప్పు, ‘దీపాలను వెలిగించినప్పుడు, దీపస్తంభం ముందు ఉన్న స్థలమంతా ప్రకాశించేలా మొత్తం ఏడు దీపాలు వెలిగేలా చూడాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","అహరోను అలాగే చేశాడు; యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం అతడు దీపస్తంభం మీద దీపాలు వెలుగు ఇచ్చేలా అమర్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","దీపస్తంభం ఇలా చేయబడింది: అది దాని స్తంభం నుండి దాని పుష్పాల వరకు సుత్తెతో సాగగొట్టబడిన బంగారంతో చేయబడింది. యెహోవా మోషేకు చూపిన నమూన ప్రకారం అది తయారుచేయబడింది. ");
INSERT INTO telotsa_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","యెహోవా మోషేతో ఇలా చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ఇశ్రాయేలీయుల నుండి లేవీయులను ప్రత్యేకపరచి వారిని ఆచార ప్రకారం పవిత్రపరచు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","వారిని పవిత్రపరచడానికి ఇలా చేయాలి: వారి మీద శుద్ధి జలం ప్రోక్షించాలి; తర్వాత వారు తమ శరీరాలంతా క్షవరం చేయించుకొని తమ బట్టలు ఉతుక్కోవాలి. అలా తమను తాము పవిత్రపరచుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","వారు ఒక కోడెతో పాటు ఒలీవనూనె కలిపిన నాణ్యమైన పిండిని భోజనార్పణగా తేవాలి; తర్వాత వారి నుండి రెండవ కోడెను పాపపరిహారబలి కోసం తీసుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","లేవీయులను సమావేశ గుడారం ముందుకు తీసుకువచ్చి మొత్తం ఇశ్రాయేలీయుల సమాజాన్ని సమావేశపరచు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","యెహోవా ముందుకు లేవీయులను నీవు తీసుకురావాలి, ఇశ్రాయేలీయులు వారి మీద చేతులుంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","అహరోను తన చేతులు పైకెత్తి, ఇశ్రాయేలు ప్రజల నుండి ప్రత్యేక అర్పణగా లేవీయులను యెహోవాకు సమర్పించాలి, తద్వారా వారు యెహోవా సేవ చేయడానికి సిద్ధంగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“అప్పుడు లేవీయులు కోడెల తలలపై వారి చేతులుంచి, ఒకటి పాపపరిహారబలిగా ఇంకొకటి లేవీయుల ప్రాయశ్చిత్తం కోసం దహనబలిగా యెహోవాకు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","లేవీయులను అహరోను, అతని కుమారుల ఎదుట నిలబెట్టి, చేతులు పైకెత్తి యెహోవాకు వారిని ప్రత్యేక అర్పణగా సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ఈ విధంగా ఇశ్రాయేలీయులలో నుండి లేవీయులను ప్రత్యేకించాలి, లేవీయులంతా నా వారుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“లేవీయులను పవిత్రపరచిన తర్వాత, చేతులు పైకెత్తి వారిని ప్రత్యేక అర్పణగా సమర్పించిన తర్వాత, వారు సమావేశ గుడారంలో సేవ చేయడానికి రావాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","వీరు ఇశ్రాయేలీయులలో నుండి సంపూర్ణంగా ఇవ్వబడాల్సిన లేవీయులు. ప్రతి ఇశ్రాయేలు స్త్రీ యొక్క మొదటి మగ సంతానానికి బదులు వీరిని నా సొంతవారిగా తీసుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ఇశ్రాయేలులో మనుష్యుల్లోను పశువుల్లోను ప్రతి తొలిచూలు మగ సంతతి నాదే. ఈజిప్టులో జ్యేష్ఠ సంతతిని మొత్తాను కాబట్టి వీరిని నాకు నేను ప్రత్యేకపరచుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ఇశ్రాయేలులో జ్యేష్ఠులైన మగవారికి ప్రత్యామ్నాయంగా నేను లేవీయులను ఏర్పరచుకున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ఇశ్రాయేలీయులందరిలో లేవీయులను అహరోనుకు, అతని కుమారులకు కానుకగా ఇచ్చాను. వీరు సమావేశ గుడారంలో సేవ చేస్తారు, ఇశ్రాయేలీయులు పరిశుద్ధాలయాన్ని సమీపించినప్పుడు వారికి తెగులు రాకుండ వారి పక్షాన ప్రాయశ్చిత్తం చేస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు, మోషే, అహరోను ఇశ్రాయేలీయుల సర్వసమాజం లేవీయుల పట్ల చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","లేవీయులు తమను తాము పవిత్రపరచుకుని వారి బట్టలు ఉతుక్కున్నారు. తర్వాత అహరోను తన చేతులు పైకెత్తి ప్రత్యేక అర్పణగా వారిని యెహోవా ఎదుట సమర్పించి వారిని శుద్ధీకరించడానికి ప్రాయశ్చిత్తం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ఆ తర్వాత, లేవీయులు అహరోను అతని కుమారుల క్రింద సమావేశ గుడారంలో సేవ చేయడానికి వచ్చారు. యెహోవా మోషేకు ఆజ్ఞాపించినట్టే వారు లేవీయులకు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","యెహోవా మోషేకు ఇలా ఆదేశించారు, ");
INSERT INTO telotsa_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“లేవీయులు ఈ నియమాలు పాటించాలి: యిరవై సంవత్సరాలు ఆ పైబడి వయస్సు గలవారు సమావేశ గుడారంలో సేవలో భాగంగా ఉండడానికి రాగలరు, ");
INSERT INTO telotsa_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","అయితే, యాభై సంవత్సరాల వయస్సు వచ్చినప్పుడు వారు ఇంకా పని నుండి విరమించుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","విరమణ తర్వాత సమావేశ గుడారంలో వారి సహోదరులకు సహకారంగా ఉండవచ్చు కానీ వారంతట వారు పని చేయకూడదు. ఇలా నీవు లేవీయులకు వారి బాధ్యతలను అప్పగించాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ఇశ్రాయేలీయులు ఈజిప్టు నుండి వచ్చిన తర్వాత రెండవ సంవత్సరం మొదటి నెలలో సీనాయి అరణ్యంలో యెహోవా మోషేతో మాట్లాడారు. ఆయన ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ఇశ్రాయేలీయులు నిర్ణీత సమయంలో పస్కా పండుగ జరుపుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","దాని నిర్ణీత సమయంలో అనగా, ఈ నెల పద్నాలుగవ రోజు సాయంకాల సమయంలో, నియమ నిబంధనలతో ఈ పండుగ జరుపుకోవాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","కాబట్టి మోషే పస్కాను జరుపుకోమని ఇశ్రాయేలీయులకు చెప్పాడు, ");
INSERT INTO telotsa_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","వారంతా అదే విధంగా మొదటి నెల పద్నాలుగవ రోజు సాయంకాలం సీనాయి అరణ్యంలో పస్కాను జరుపుకుంటారు. ఇశ్రాయేలీయులు యెహోవా మోషేకు ఆజ్ఞాపించినదంతా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","అయితే కొందరు మనుష్యులు మృతదేహాన్ని బట్టి ఆచారరీత్య అపవిత్రులైనందుకు ఆ రోజున పస్కాను జరుపుకోలేకపోయారు. కాబట్టి అదే రోజు వారు మోషే అహరోనుల దగ్గరకు వచ్చి, ");
INSERT INTO telotsa_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","వారు మోషేతో, “ఒక మనుష్యుని మృతదేహాన్ని బట్టి మేము అపవిత్రులం అయ్యాము, అయితే యెహోవా అర్పణను ఇతర ఇశ్రాయేలీయులతో పాటు నిర్ణీత సమయంలో మేము ఎందుకు సమర్పించకూడదు?” అని అడిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","అందుకు మోషే వారితో, “మీ గురించి యెహోవా ఏమి ఆజ్ఞాపిస్తారో తెలుసుకునే వరకు ఆగండి” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","అప్పుడు యెహోవా మోషేతో, ");
INSERT INTO telotsa_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ఇశ్రాయేలీయులతో చెప్పు: ‘ఇప్పుడున్న మీలో ఎవరైనా లేదా రాబోయే తరాల వారైనా మృతదేహాన్ని బట్టి గాని దూర ప్రయాణాన్ని బట్టి గాని అపవిత్రులైతే, వారు యెహోవా పస్కాను జరుపుకోవచ్చు, ");
INSERT INTO telotsa_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","అయితే వారు రెండవ నెల పద్నాలుగవ రోజు సాయంకాలం జరుపుకోవాలి. వారు పులియని రొట్టెలతో, చేదు కూరలతో పాటు గొర్రెపిల్లను తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","తెల్లవారేటప్పడికి దానిలో ఏది మిగులకూడదు లేదా దాని ఎముకల్లో ఒక్కటి కూడా విరువకూడదు. పస్కాను జరుపుకున్నప్పుడు వారు నియమాలన్నీ పాటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","అయితే ఎవరైనా ఆచార ప్రకారం పవిత్రంగా ఉంటూ ప్రయాణంలో లేదా ఉన్న చోటే ఉంటూ, పస్కాను జరుపుకోకుండా ఉంటే, నిర్ణీత సమయంలో యెహోవాకు అర్పణను అర్పించనందుకు వారిని ప్రజల నుండి తొలగించాలి. వారి పాపానికి వారే పాపశిక్షను భరిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘మీ మధ్యలో ఉంటున్న విదేశీయులు కూడా యెహోవా పస్కాను నియమ నిబంధనలతో జరుపుకోవాలి. విదేశీయులకు స్వదేశీయులకు ఒకే నియమాలు ఉండాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","నిబంధన గుడారమైన సమావేశ గుడారం సిద్ధపరచబడిన రోజున దాన్ని మేఘం కమ్మింది. సాయంత్రం నుండి ఉదయం వరకు సమావేశ గుడారం మీద మేఘం అగ్నిలా కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","అది నిత్యం అలాగే ఉంది; మేఘం దాన్ని కమ్మింది, రాత్రివేళ ఆ మేఘం అగ్నిలా కనిపించేది. ");
INSERT INTO telotsa_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","గుడారం మీద నుండి మేఘం పైకి వెళ్లినప్పుడు, ఇశ్రాయేలీయులు బయలుదేరేవారు; ఎక్కడ మేఘం ఆగితే వారు అక్కడ గుడారాలు వేసుకునేవారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","యెహోవా ఆజ్ఞ ప్రకారం ఇశ్రాయేలీయులు ప్రయాణం చేసేవారు, ఆయన ఆజ్ఞ ప్రకారం అక్కడ ఉండేవారు. మేఘం సమావేశ గుడారం మీద నిలిచి ఉన్నంత వరకు వారు శిబిరంలో ఉండేవారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","మేఘం ఎక్కువకాలం సమావేశ గుడారం మీద ఆగితే యెహోవా ఆజ్ఞ ప్రకారం ఇశ్రాయేలీయులు బయలుదేరేవారు కారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","కొన్నిసార్లు మేఘం సమావేశ గుడారానికి కొన్ని రోజులు మాత్రమే ఉంటుంది; యెహోవా ఆజ్ఞ ప్రకారం వారు శిబిరం చేస్తారు, ఆయన ఆజ్ఞ ప్రకారం వారు ప్రయాణం చేస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","కొన్నిసార్లు మేఘం సాయంత్రం నుండి ఉదయం వరకు మాత్రమే ఉండేది, ఉదయం ఎత్తినప్పుడు, వారు ప్రయాణించేవారు. పగలైన, రాత్రైనా, మేఘం ఎత్తినప్పుడల్లా వారు ప్రయాణించేవారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","మేఘం సమావేశ గుడారంలో రెండు రోజులు లేదా ఒక నెల లేదా ఒక సంవత్సరం పాటు ఉండిపోతే, ఇశ్రాయేలీయులు శిబిరంలోనే ఉండేవారు; కానీ అది ఎత్తినప్పుడు, వారు బయలుదేరేవారు. ");
INSERT INTO telotsa_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","యెహోవా ఆజ్ఞ ప్రకారం వారు గుడారాలు వేసుకునేవారు, యెహోవా ఆజ్ఞ ప్రకారం వారు బయలుదేరేవారు. మోషే ద్వారా ఇవ్వబడిన యెహోవా ఆజ్ఞ ప్రకారం వారు లోబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","యెహోవా మోషేతో ఇలా చెప్పారు: ");
INSERT INTO telotsa_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“సుత్తెతో సాగగొట్టబడిన వెండితో రెండు బూరలు తయారుచేసి, సమాజం కూడుకోడానికి, శిబిరాలు బయలుదేరడాన్ని సూచించడానికి వాటిని వాడాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","రెండు బూరలు ఒకేసారి మ్రోగితే ఆ శబ్దానికి సమాజమంతా నీ ఎదుట సమావేశ గుడార ద్వారం దగ్గర కూడుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ఒక బూర మాత్రమే మ్రోగితే, నాయకులు అంటే ఇశ్రాయేలు గోత్రాల అధిపతులు నీ ముందు సమకూడాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","బూరధ్వని వినబడినప్పుడు, తూర్పున ఉన్న గోత్రాలు బయలుదేరాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","రెండవ ధ్వని వినబడినప్పుడు, దక్షిణాన ఉన్న దండ్లు బయలుదేరాలి. బయలుదేరడానికి ధ్వని ఒక సూచన. ");
INSERT INTO telotsa_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","సమాజం కూడుకోడానికి, బూరలు ఊదండి, అయితే బయలుదేరడానికి ఊదే విధంగా కాదు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“యాజకులైన అహరోను కుమారులు, బూరలు ఊదాలి. ఇది మీకు రాబోయే తరాలకు నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","మీ భూమిలో మిమ్మల్ని బాధపరిచే మీ శత్రువులపై యుద్ధం చేయబోతున్నప్పుడు బూరధ్వని చేయాలి. అప్పుడు మీ దేవుడైన యెహోవా మిమ్మల్ని జ్ఞాపకం చేసుకుని మీ శత్రువుల నుండి మిమ్మల్ని విడిపిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","అంతేకాక మీ సంతోష సమయాల్లో అంటే నియమించబడిన పండుగలు, అమావాస్య వేడుకలప్పుడు మీ దహనబలులు, మీ సమాధాన బలులపై బూరధ్వని చేయండి. అవి మీ దేవుని ఎదుట జ్ఞాపకార్థంగా ఉంటాయి. నేను మీ దేవుడనైన యెహోవానై ఉన్నాను.” ");
INSERT INTO telotsa_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","రెండవ సంవత్సరం రెండవ నెల ఇరవయ్యవ రోజున, మేఘం సాక్షి గుడారం మీది నుండి కదిలింది. ");
INSERT INTO telotsa_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ఇశ్రాయేలీయులు సీనాయి అరణ్యం నుండి బయలుదేరి మేఘం పారాను అరణ్యంలో ఆగేవరకు స్థలం నుండి స్థలానికి ప్రయాణించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","యెహోవా మోషేకు ఇచ్చిన ఆజ్ఞ ప్రకారం మొదటిసారిగా, వారు బయలుదేరారు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","యూదా శిబిరం యొక్క విభజనలు వారి పతాకాన్ని పట్టుకుని ముందుగా వెళ్లాయి. అమ్మీనాదాబు కుమారుడైన నయస్సోను యూదా గోత్రం వారిని నడిపించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","అదే విధంగా సూయరు కుమారుడైన నెతనేలు ఇశ్శాఖారు గోత్రం, ");
INSERT INTO telotsa_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ఏలీయాబు కుమారుడైన హేలోను జెబూలూను గోత్రానికి నియమించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","తర్వాత గుడారాన్ని తీసివేశారు, గెర్షోను, మెరారి వంశస్థులు దానిని మోస్తూ బయలుదేరారు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","వారి తర్వాత రూబేను శిబిరం వారు వారి సేనల ప్రకారం వెళ్లారు. షెదేయూరు కుమారుడైన ఎలీసూరు రూబేను గోత్ర నాయకుడు సైన్యాధిపతి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","సూరీషద్దాయి కుమారుడైన షెలుమీయేలు షిమ్యోను గోత్రం మీద, ");
INSERT INTO telotsa_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","దెయూవేలు కుమారుడైన ఎలీయాసాపు గాదు గోత్రం మీద నియమించబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","తర్వాత కహాతు వంశస్థులు పవిత్ర వస్తువులను మోస్తూ బయలుదేరారు. వీరు తర్వాతి శిబిరాన్ని చేరకముందే సమావేశ గుడారం సిద్ధం చేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","వారి తర్వాత ఎఫ్రాయిం శిబిరం వారు వారి సేనల ప్రకారం బయలుదేరారు. అమీహూదు కుమారుడైన ఎలీషామా ఎఫ్రాయిం గోత్ర సైన్యాధిపతి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","తర్వాత మనష్షే గోత్రం వారు వెళ్లారు. వారి నాయకుడు పెదాసూరు కుమారుడైన గమలీయేలు, ");
INSERT INTO telotsa_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","తర్వాత బెన్యామీను గోత్రం వారు వెళ్లారు. వారి నాయకుడు గిద్యోనీ కుమారుడైన అబీదాను సైన్యాధిపతి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","చివరకు, అన్ని శిబిరాల వెనుక దాను శిబిరం వారు వారి సేనల ప్రకారం బయలుదేరారు. అమీషద్దాయి కుమారుడైన అహీయెజెరు న్యాయాధిపతి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","తర్వాత ఆషేరు గోత్రం వారు వెళ్లారు. వారు నాయకుడు ఒక్రాను కుమారుడైన పగీయేలు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","తర్వాత నఫ్తాలి గోత్రం వారు వెళ్లారు. వారి నాయకుడు ఏనాను కుమారుడైన అహీర సైన్యాధిపతి. ");
INSERT INTO telotsa_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ఈ క్రమంలో తమ తమ సేనలతో ఇశ్రాయేలు ప్రజలు ప్రయాణం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ఒక రోజు మోషే తన మామ మిద్యానీయుడైన రెయూయేలు కుమారుడైన హోబాబుతో, “యెహోవా, ‘నేను మీకు ఇస్తాను’ అని చెప్పిన స్థలానికి వెళ్తున్నాము. నీవు మాతో వచ్చెయ్యి, మేము నిన్ను మంచిగా చూసుకుంటాం, ఎందుకంటే యెహోవా ఇశ్రాయేలుకు మంచి వాటిని వాగ్దానం చేశారు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","అతడు, “నేను రాను, నా స్వదేశానికి, నా బంధువుల దగ్గరకు తిరిగి వెళ్తున్నాను” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","అయితే మోషే, “దయచేసి మమ్మల్ని వదిలి వెళ్లకు. ఈ అరణ్యంలో ఎక్కడ దిగాలో నీకు దారి బాగా తెలుసు, నీవు మాకు దారి చూపించగలవు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","నీవు కాబట్టి మాతో వస్తే యెహోవా మాకు ఇచ్చే మేలులు నీతో పంచుకుంటాం” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","కాబట్టి వారు యెహోవా పర్వతం నుండి బయలుదేరి మూడు రోజులు ప్రయాణించారు. వారి విశ్రాంతి స్థలం కోసం ఈ మూడు రోజులు యెహోవా నిబంధన మందసం వారికి ముందుగా వెళ్లింది. ");
INSERT INTO telotsa_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","వారు ప్రయాణం మొదలుపెట్టినప్పుడు యెహోవా మేఘము పగలు వారి మీద ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","మందసం ఎప్పుడు బయలుదేరుతుందో అప్పుడు మోషే బిగ్గరగా, “యెహోవా, లేవండి! మీ శత్రువులు చెదిరిపోవుదురు గాక; మీ ఎదుట నుండి మీ శత్రువులు పారిపోవుదురు గాక” అని అనేవాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","మందసం ఆగినప్పుడు, అతడు, “యెహోవా, లెక్కలేనంతగా ఉన్న వేలాది ఇశ్రాయేలు ప్రజల దగ్గరకు తిరిగి రండి” అని అనేవాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","దాని తర్వాత యెహోవా వినేలా ప్రజలు తమ కష్టాల గురించి ఫిర్యాదు చేసినప్పుడు, ఆయన అవి వినగానే ఆయన కోపం రగులుకుంది. అప్పుడు యెహోవా నుండి అగ్ని వారి మధ్యకు వచ్చి శిబిరం శివార్లలో కొంత భాగాన్ని దహించివేసింది. ");
INSERT INTO telotsa_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ప్రజలు మోషేకు మొరపెట్టగా, అతడు యెహోవాకు ప్రార్థించాడు, ఆ అగ్ని ఆరిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","అందుకు ఆ స్థలానికి తబేరా అని పేరు పెట్టారు, ఎందుకంటే యెహోవా నుండి వచ్చిన అగ్ని వారి మధ్యలో వచ్చింది కాబట్టి. ");
INSERT INTO telotsa_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","వారితో ఉన్న అల్లరి గుంపు వేరే ఆహారం ఆశించడం ప్రారంభించారు, అప్పుడు మళ్ళీ ఇశ్రాయేలీయులు ఏడ్వడం మొదలుపెట్టి, “మనకు తినడానికి మాంసం మాత్రం ఉంటే ఎంత బాగుండేది! ");
INSERT INTO telotsa_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ఈజిప్టులో చేపలు, దోసకాయలు, పుచ్చకాయలు, ఒక రకమైన ఉల్లిపాయలు, ఉల్లిగడ్డలు, వెల్లుల్లిపాయలు ఉచితంగా తిన్నాము. ");
INSERT INTO telotsa_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","కానీ ఇప్పుడు మాకు తిండి మీద ఇష్టం లేకుండ పోయింది; ఈ మన్నా తప్ప మాకేమి కనిపించడం లేదు!” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","మన్నా కొత్తిమెర గింజల్లా ఉండి గుగ్గిలంలా కనబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ప్రజలు బయటకు వెళ్లి, తిరుగుతూ దానిని సేకరించుకొని, దానిని తిరగలితో విసరేవారు లేదా రోటిలో దంచేవారు. కుండలో దానిని ఉడకబెట్టి దానితో రొట్టెలు చేసుకునేవారు. దాని రుచి నూనెతో చేసిన అప్పడంలా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","రాత్రివేళ శిబిరంలో మంచు కురిసినప్పుడు మన్నా దాని వెంటనే పడేది. ");
INSERT INTO telotsa_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","మోషే ప్రతి కుటుంబంలోని ప్రజలు వారి డేరాల దగ్గర ఏడుస్తూ ఉండడం విన్నాడు. యెహోవా చాలా కోప్పడ్డారు మోషే బాధపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","మోషే యెహోవాతో, “మీ సేవకునిపై ఈ కష్టం ఎందుకు తెచ్చారు? వీరందరి భారం నా మీద వేయకుండ మీ దృష్టిలో నేనెందుకు దయను పొందలేకపోయాను? ");
INSERT INTO telotsa_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","వీరందరిని నేను గర్భందాల్చానా? నేను వీరిని కన్నానా? దాది శిశువును ఎత్తుకున్నట్లు, మీ పూర్వికులకు మీరు ప్రమాణం వాగ్దానం చేసిన స్థలానికి నడిపించడానికి వీరిని నా చేతిలో ఎందుకు మోయమన్నారు? ");
INSERT INTO telotsa_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","వీరందరి కోసం మాంసం ఎక్కడ నుండి తేవాలి? నన్ను చూసి, ‘మాకు తినడానికి మాంసం ఇవ్వు!’ అంటూ ఏడుస్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","నా అంతట నేను ఈ ప్రజలందరినీ మోయలేను; భారం నాకు చాల భారీగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ఒకవేళ నాతో మీరు ఇలా వ్యవహరించ తలిస్తే దయచేసి నన్ను చంపేయండి; నా మీద మీకు దయ కలిగితే నా దురవస్థను నేను చూడకుండ నన్ను చంపేయండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","యెహోవా మోషేతో: “ఇశ్రాయేలు గోత్ర పెద్దలను డెబ్బై మందిని నాయకులుగా, ఎవరైతే పెద్దలుగా ఉన్నవారు నీకు తెలిసినవారిని తీసుకురా. నీతో వారు నిలబడేలా వారు సమావేశ గుడారం దగ్గరకు రావాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","నేను దిగివచ్చి నీతో మాట్లాడతాను. నీ మీద ఉన్న ఆత్మ యొక్క శక్తిలో కొద్ది భాగం వారి మీద పెడతాను. వారు నీతో కలిసి ప్రజల భారం పంచుకుంటారు అప్పుడు నీవు ఒంటరిగా మోయనవసరం ఉండదు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“నీవు ప్రజలకు ఇలా చెప్పు: ‘రేపటి కోసం మిమ్మల్ని మీరు పవిత్రం చేసుకోండి, రేపు మీరు మాంసం తినబోతున్నారు. మీరు, “మాకు మాంసం మాత్రం ఉంటే బాగుండేది! ఈజిప్టులో మాకు బాగుండేది!” అని ఏడ్వడం యెహోవా విన్నారు కాబట్టి యెహోవా మీకు మాంసం ఇస్తారు, మీరు తింటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","దానిని మీరు తినడం ఒక రోజు కాదు, రెండు రోజులు, అయిదు రోజులు, పది రోజులు, యిరవై రోజులు కాదు, ");
INSERT INTO telotsa_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ఒక నెలంతా మీ నాసికా రంధ్రాల నుండి బయటకు వచ్చి మీరు అసహ్యించుకునే వరకు తింటారు; ఎందుకంటే మీరు మీ మధ్య ఉన్న యెహోవాను నిరాకరించి, “మేము అసలు ఈజిప్టును ఎందుకు విడిచిపెట్టామో?” అంటూ ఆయన ఎదుట ఏడ్చారు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","అయితే మోషే, “నేను ఆరు లక్షలమంది పాదాచారుల మధ్య ఉన్నాను, మీరేమో, ‘నేను వారికి నెలరోజులు తినడానికి సరిపడే మాంసం ఇస్తాను!’ అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ఉన్న పశువులు, మందలు అన్నిటిని వధించినా వీరికి సరిపోతుందా? సముద్రంలో చేపలన్నీ పట్టినా వీరికి సరిపోతాయా?” ");
INSERT INTO telotsa_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","యెహోవా మోషేకు జవాబిస్తూ, “యెహోవా బాహుబలం తక్కువయ్యిందా? నేను చెప్పింది జరుగుతుందో లేదో నీవు చూస్తావు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","మోషే బయటకు వెళ్లి యెహోవా చెప్పిందంతా ప్రజలకు తెలియజేశాడు. డెబ్బైమంది గోత్ర పెద్దలను తెచ్చి మందిరం చుట్టూ నిలబెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","అప్పుడు యెహోవా మేఘంలో దిగివచ్చి అతనితో మాట్లాడారు. అతనిపై ఉన్న ఆత్మ శక్తిలో కొంత ఆ డెబ్బై గోత్ర పెద్దలపై ఉంచినప్పుడు ఆత్మ వారిమీద నిలిచి వారు ప్రవచించారు అయితే, తర్వాత ఎన్నడు ప్రవచించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","అయితే, ఇద్దరు, శిబిరంలోనే ఉండిపోయారు. వారి పేర్లు ఎల్దాదు, మేదాదు. వారు గోత్ర పెద్దలలో ఉన్నవారే, కానీ గుడారం బయటకు వెళ్లలేదు. అయినప్పటికీ ఆత్మ వారి మీద ఉంది, వారు శిబిరంలో ప్రవచించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ఒక యువకుడు మోషే దగ్గరకు పరిగెత్తుకుంటూ వచ్చి, “ఎల్దాదు, మేదాదు శిబిరంలో ప్రవచిస్తున్నారు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","నూను కుమారుడైన యెహోషువ, యవ్వనకాలం నుండి మోషే దగ్గరే ఉన్నవాడు, అతడు మాట్లాడుతూ, “మోషే, నా ప్రభువా, వారిని ఆపండి!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","కానీ మోషే అతనితో, “నా పక్షంగా నీవు అసూయపడుతున్నావా? నేనైతే యెహోవా ప్రజలంతా ప్రవక్తలు కావాలని, యెహోవా తన ఆత్మ వారందరి మీద ఉంచాలని కోరతాను!” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","తర్వాత మోషే, ఇశ్రాయేలు గోత్ర పెద్దలు, శిబిరానికి తిరిగి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","తర్వాత యెహోవా దగ్గరి నుండి గాలి వెళ్లి సముద్రం దిక్కునుండి పూరేళ్ళను తీసుకువచ్చింది. అది వాటిని రెండు మూరల ఎత్తుగా, ఏ దిశలోనైనా ఒక రోజు నడకంత దూరంగా శిబిరం చుట్టూరా చెదరగొట్టింది. ");
INSERT INTO telotsa_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ఆ దినమంతా, రాత్రంతా, మరుసటి రోజంతా, ప్రజలు బయటకు వెళ్లి పూరేళ్ళను సమకూర్చుకున్నారు. ఏ ఒక్కరు కూడా పది హోమెర్ల కంటే తక్కువ పోగు చేసుకోలేదు. వాటిని శిబిరం చుట్టూ పరిచారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","అయితే, మాంసం పళ్ళ సందుల్లో ఉండగానే దానిని నమిలి మ్రింగకముందే, యెహోవా కోపం వారిపై రగులుకుంది, ఆయన వారిని భయంకరమైన తెగులుతో మొత్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ఆ స్థలంలో ఇతర ఆహారం కోసం ఆశపడిన వారిని పాతిపెట్టినందుకు ఆ స్థలానికి కిబ్రోతు హత్తావా అనే పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ప్రజలు కిబ్రోతు హత్తావా నుండి హజేరోతుకు ప్రయాణం చేసి అక్కడే ఉండిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","మోషే కూషీయురాలిని పెళ్ళి చేసుకున్నందుకు, అతనికి వ్యతిరేకంగా మిర్యాము, అహరోనులు మాట్లాడడం ప్రారంభించారు, ");
INSERT INTO telotsa_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“యెహోవా కేవలం మోషే ద్వారానే మాట్లాడారా?” అని, “ఆయన మా ద్వారా కూడా మాట్లాడలేక?” అని అన్నారు. యెహోవా వారి మాటలు విన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","మోషే చాలా దీనుడు, భూమి మీద ఉన్న మనుష్యులందరి కన్నా దీనుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","వెంటనే యెహోవా మోషే, అహరోను మిర్యాములతో, “మీ ముగ్గురు, సమావేశ గుడారం దగ్గరకు రండి” అని చెప్పారు. కాబట్టి ముగ్గురు వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","అప్పుడు యెహోవా మేఘస్తంభంలో దిగి వచ్చారు; ఆయన గుడార ద్వారం దగ్గర నిలబడి అహరోను, మిర్యాములను పిలిచారు. ఆ ఇద్దరు ముందుకు వచ్చినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ఆయన, “నా మాటలు వినండి: “ఒకవేళ మీ మధ్య ప్రవక్త ఉంటే, యెహోవానైన నేను దర్శనాలలో వారికి ప్రత్యక్షమవుతాను, కలలలో నేను వారితో మాట్లాడతాను. ");
INSERT INTO telotsa_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","అయితే నా సేవకుడైన మోషే విషయంలో ఇలా కాదు; అతడు నా ఇల్లంతటిలో నమ్మకస్థుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","అతనితో నేను ముఖాముఖిగా మాట్లాడతాను, పొడుపుకథల్లా కాక స్పష్టంగా మాట్లాడతాను. అతడు యెహోవా రూపాన్ని చూస్తాడు. అలాంటప్పుడు మీరెందుకు భయపడకుండా నా సేవకుడైన మోషేకు వ్యతిరేకంగా మాట్లాడారు?” ");
INSERT INTO telotsa_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","యెహోవా కోపం వారిపై రగులుకుంది, ఆయన వారిని విడిచి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","మేఘం గుడారం నుండి పైకి వెళ్లిపోయాక, మిర్యాముకు కుష్ఠువ్యాధి వచ్చి చర్మం మంచులా తెల్లగా మారింది. అహరోను ఆమె వైపు చూసి, ఆమెకు కుష్ఠువ్యాధి వచ్చిందని గ్రహించి, ");
INSERT INTO telotsa_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","అహరోను మోషేతో, “నా ప్రభువా, మేము తెలివితక్కువగా చేసిన పాపాన్ని మా మీదకు తేవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","తల్లి గర్భంలో సగం మాంసం కుళ్ళిన శిశువులా ఆమెను కానివ్వకండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","కాబట్టి మోషే యెహోవాకు, “దేవా, దయచేసి ఈమెను స్వస్థపరచు!” అని మొరపెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","అందుకు యెహోవా మోషేతో, “ఆమె తండ్రి ఆమె ముఖం మీద ఉమ్మివేస్తే, ఆమె ఏడు రోజులు అవమానంలో ఉండదా? ఆమెను శిబిరం బయట ఏడు రోజులు ఉంచు; ఆ తర్వాత ఆమెను వెనుకకు తీసుకురావచ్చు” అని జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","కాబట్టి మిర్యాము శిబిరం బయట ఏడు రోజులు ఉన్నది, ఆమెను తిరిగి తీసుకువచ్చే వరకు ప్రజలు ముందుకు వెళ్లలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ఆ పిమ్మట ప్రజలు హజేరోతు నుండి బయలుదేరి పారాను ఎడారిలో గుడారాలు వేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“కనాను దేశాన్ని పరిశీలించడానికి కొంతమంది పురుషులను పంపు, ఈ దేశం ఇశ్రాయేలీయులకు ఇవ్వబోతున్నాను. ప్రతి పితరుల గోత్ర నాయకుల్లో ఒకరిని పంపు.” ");
INSERT INTO telotsa_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","యెహోవా ఆజ్ఞ ప్రకారం మోషే వారిని పారాను ఎడారి నుండి పంపాడు. వారందరు ఇశ్రాయేలీయుల నాయకులు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","వారి పేర్లు ఇవి: రూబేను గోత్రం నుండి, జక్కూరు కుమారుడైన షమ్మూయ; ");
INSERT INTO telotsa_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","షిమ్యోను గోత్రం నుండి, హోరీ కుమారుడైన షాపాతు; ");
INSERT INTO telotsa_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","యూదా గోత్రం నుండి యెఫున్నె కుమారుడైన కాలేబు; ");
INSERT INTO telotsa_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ఇశ్శాఖారు గోత్రం నుండి, యోసేపు కుమారుడైన ఇగాలు; ");
INSERT INTO telotsa_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ఎఫ్రాయిం గోత్రం నుండి, నూను కుమారుడైన హోషేయ; ");
INSERT INTO telotsa_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","బెన్యామీను గోత్రం నుండి, రాఫు కుమారుడైన పల్తీ; ");
INSERT INTO telotsa_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","జెబూలూను గోత్రం నుండి, సోది కుమారుడైన గదీయేలు; ");
INSERT INTO telotsa_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","మనష్షే (యోసేపు గోత్రం) గోత్రం నుండి, సూసీ కుమారుడైన గద్దీ; ");
INSERT INTO telotsa_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","దాను గోత్రం నుండి, గెమలి కుమారుడైన అమ్మీయేలు; ");
INSERT INTO telotsa_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ఆషేరు గోత్రం నుండి, మిఖాయేలు కుమారుడైన సెతూరు; ");
INSERT INTO telotsa_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","నఫ్తాలి గోత్రం నుండి, వోఫ్సీ కుమారుడైన నహబీ; ");
INSERT INTO telotsa_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","గాదు గోత్రం నుండి, మాకీ కుమారుడైన గెయుయేలు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ఇవి వాగ్దాన దేశాన్ని చూడడానికి మోషే పంపిన వారి పేర్లు. (నూను కుమారుడైన హోషేయకు మోషే యెహోషువ అని పేరు పెట్టాడు.) ");
INSERT INTO telotsa_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","మోషే వారిని కనాను దేశాన్ని పరిశీలించమని పంపినప్పుడు, అతడు ఇలా చెప్పాడు, “మీరు దక్షిణ మార్గం గుండా వెళ్లి, కొండసీమ వైపు వెళ్లండి. ");
INSERT INTO telotsa_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ఆ దేశం ఎలా ఉందో, అందులోని ప్రజలు బలవంతులా, బలహీనులా, తక్కువగా ఉన్నారా, ఎక్కువగా ఉన్నారా అని చూడండి. ");
INSERT INTO telotsa_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","వారు ఎలాంటి భూమిలో నివసిస్తున్నారు? అది మంచిదా చెడ్డదా? వారు ఎలాంటి పట్టణాల్లో నివసిస్తున్నారు? అవి కోటగోడలు లేనివా? లేదా కోటగోడలు కలవా? ");
INSERT INTO telotsa_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ఆ దేశపు మట్టి ఎలా ఉంది? అది సారవంతమైనదా కాదా? అక్కడ చెట్లున్నాయా లేవా? అక్కడి పండ్లలో కొన్ని తీసుకురావడానికి సాధ్యమైనంత వరకు ప్రయత్నించండి.” (అది ప్రథమ ద్రాక్షపండ్ల కాలము.) ");
INSERT INTO telotsa_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","కాబట్టి వారు వెళ్లి సీను ఎడారి నుండి లెబో హమాతు వైపున, రెహోబు వరకు ఆ దేశాన్ని పరిశీలించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","దక్షిణ దిక్కునుండి వెళ్లి, హెబ్రోనుకు వచ్చారు, అక్కడ అహీమాను, షేషయి, తల్మయి అనే అనాకు వంశస్థులు నివసించారు. (హెబ్రోను, ఈజిప్టులోని సోయను కంటే ఏడు సంవత్సరాల ముందే కట్టబడిన పురాతన పట్టణము.) ");
INSERT INTO telotsa_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","వారు ఎష్కోలు లోయకు చేరుకున్నప్పుడు ఒకే గెల ఉన్న ద్రాక్షచెట్టు కొమ్మను నరికారు. దానిని ఇద్దరు వారి మధ్య కర్ర మీద మోసారు, దానితో పాటు కొన్ని దానిమ్మలు, అంజూరాలు కూడా తీసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","అక్కడ ఇశ్రాయేలీయులు ద్రాక్ష గెలను కోసినందుకు ఆ స్థలం ఎష్కోలు లోయ అని పిలువబడింది. ");
INSERT INTO telotsa_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ఆ దేశాన్ని పరిశీలించిన నలభైరోజల తర్వాత వారు తిరిగి వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","వారు పారాను ఎడారిలో కాదేషులో ఉన్న మోషే అహరోనులు, ఇశ్రాయేలు సర్వసమాజం దగ్గరకు వచ్చారు. అక్కడ వారికి, సర్వ సమాజానికి విశేషాలు చెప్పి, ఆ దేశ పండ్లను వారికి చూపించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","వారు మోషేకు ఇచ్చిన నివేదిక ఇది: “మీరు పంపిన దేశానికి మేము వెళ్లాము. నిజంగా పాలు తేనెలు అక్కడ పారుతున్నాయి. ఇవి ఆ దేశంలోని పండ్లు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","అయితే అక్కడి నివాసులు బలిష్ఠులు, వారి పట్టణాలు కోటగోడలు కలిగి ఉన్నాయి, చాలా పెద్దవి. అక్కడ అనాకీయులను కూడా చూశాము. ");
INSERT INTO telotsa_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","అమాలేకీయులు దక్షిణాదిలో నివసిస్తారు. హిత్తీయులు, యెబూసీయులు, అమోరీయులు కొండ సీమలో ఉంటారు. కనానీయులు సముద్రతీరాన యొర్దాను నది ఒడ్డున నివసిస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","అప్పుడు కాలేబు మోషే ఎదుట ప్రజలను శాంత పరుస్తూ, “తప్పకుండా మనం వెళ్లి ఆ దేశాన్ని స్వాధీనం చేసుకోవాలి, ఖచ్చితంగా చేయగలం” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","కానీ అతనితో కలసి వెళ్లినవారు, “మనం వారిపై దాడి చేయలేము; అక్కడి ప్రజలు మనకన్నా బలమైన వారు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","వారు పరిశీలించిన దేశం గురించి ఇశ్రాయేలీయుల మధ్య చెడ్డ నివేదికను వ్యాప్తి చేశారు. వారు, “మేము వేగు చూసిన భూమి దానిలో నివసించేవారిని మ్రింగివేస్తుంది. అక్కడ మేము చూసిన ప్రజలందరూ చాలా పెద్దగా ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","మేము అక్కడ ఆజానుబాహులను (అనాకు వంశస్థులు నెఫిలీము నుండి వచ్చినవారు) చూశాము. మా దృష్టిలో మేము మిడతల్లా కనిపించాం, వారికి కూడా అలాగే కనిపించాం” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ఆ రాత్రి సమాజంలో ఉన్న అందరు స్వరాలెత్తి బిగ్గరగా ఏడ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ఇశ్రాయేలీయులందరు మోషే అహరోనుల మీద సణిగి, సమాజమంతా, “మేము ఈజిప్టులో గాని ఎడారిలో గాని చనిపోయుంటే బాగుండేది! ");
INSERT INTO telotsa_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","మేము ఖడ్గం చేత చావడానికి మమ్మల్ని యెహోవా ఈ దేశానికి ఎందుకు తెస్తున్నారు? మా భార్య పిల్లలు చెరగా కొనిపోబడతారు. ఈజిప్టుకు తిరిగి వెళ్లడం మాకు మంచిది కాదా?” అని వారితో అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","వారు ఒకరితో ఒకరు, “మనం ఒక నాయకుని ఎన్నుకుని ఈజిప్టుకు తిరిగి వెళ్దాం” అని మాట్లాడుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","అప్పుడు మోషే అహరోనులు ఇశ్రాయేలు సమాజమందరి ఎదుట సాష్టాంగపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ఆ దేశాన్ని వేగు చూడడానికి వెళ్లిన వారిలో ఉన్న నూను కుమారుడైన యెహోషువ, యెఫున్నె కుమారుడైన కాలేబు తమ బట్టలు చింపుకొని, ");
INSERT INTO telotsa_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ఇశ్రాయేలు సమాజమంతటితో ఇలా అన్నారు: “మేము వెళ్లి పరిశీలించిన దేశం చాలా మంచిగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","యెహోవా మనయందు ఆనందిస్తే, ఆ దేశంలోనికి, పాలు తేనెలు ప్రవహించే దేశంలోనికి మనలను నడిపిస్తారు, దానిని మనకు ఇస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","మీరు మాత్రం యెహోవా మీద తిరగబడకండి. అక్కడి ప్రజలకు భయపడకండి ఎందుకంటే వారిని మనం చంపుతాము. వారికి కాపుదల లేదు, కానీ యెహోవా మనతో ఉన్నారు. వారికి భయపడకండి” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","అయితే సమాజమంతా వారిని రాళ్లతో కొట్టాలని మాట్లాడుకున్నారు. అప్పుడు యెహోవా మహిమా ప్రకాశం సమావేశ గుడారం దగ్గర ఇశ్రాయేలీయులందరికి కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","యెహోవా మోషేతో, “ఎంతకాలం ఈ ప్రజలు నన్ను ధిక్కరిస్తారు? నేను వారి మధ్య అన్ని సూచనలు చేసినప్పటికీ, వారు నన్ను నమ్మడానికి ఎంతకాలం నిరాకరిస్తారు? ");
INSERT INTO telotsa_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","తెగులుతో వారిని మొత్తి నాశనం చేస్తాను, అయితే వీరిని మించిన బలమైన గొప్ప ప్రజలుగా నిన్ను చేస్తాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","మోషే యెహోవాతో, “ఈజిప్టువారు దాని గురించి విన్నప్పుడు వారు ఏమనుకుంటారు? మీ ప్రభావం చేత వారి మధ్య నుండి వీరిని తెచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ఈ దేశ నివాసులకు దానిని గురించి వారు చెప్తారు. ఇప్పటికే మీరు యెహోవా, ఈ ప్రజలతో ఉన్నారని, మీరు ముఖాముఖిగా వీరికి కనిపిస్తారని, మీ మేఘము వీరితో ఉంటుందని, మీరు పగలు మేఘస్తంభంలో, రాతి అగ్నిస్తంభంలో ఉంటూ వారిని నడిపిస్తారని వారు విన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ఒకవేళ ఎవరిని విడిచిపెట్టకుండా ఈ ప్రజలందరినీ చంపేస్తే, మీ గురించి ఈ విషయాలు విన్న దేశాలు, ");
INSERT INTO telotsa_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘యెహోవా ఈ ప్రజలకు మ్రొక్కుబడిగా వాగ్దానం చేసిన స్థలానికి తీసుకెళ్లలేక, వీరిని అరణ్యంలో చంపేశారు’ అని అంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“కాబట్టి మీరు ప్రకటించినట్లే, ఇప్పుడు ప్రభువు యొక్క బలం కనుపరచబడును గాక: ");
INSERT INTO telotsa_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘యెహోవా త్వరగా కోప్పడరు, ప్రేమ క్షమాగుణాలతో నిండియున్నవారు, ఆయన తిరుగుబాటును పాపాన్ని క్షమిస్తారు గాని ఆయన దోషులను నిర్దోషులుగా విడిచిపెట్టక, మూడు నాలుగు తరాల వరకు తల్లిదండ్రుల పాపానికి వారి పిల్లలను శిక్షిస్తారు.’ ");
INSERT INTO telotsa_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","మీ గొప్ప ప్రేమను బట్టి, ఈ ప్రజల పాపాన్ని, ఈజిప్టు వదిలినప్పటి నుండి ఇప్పటివరకు వీరిని క్షమించిన ప్రకారం క్షమించండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","యెహోవా జవాబిస్తూ, “నీవడిగినట్టే, నేను వారిని క్షమించాను. ");
INSERT INTO telotsa_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","అయినా, నా జీవం తోడు, యెహోవా మహిమ భూమంతటిని నింపునట్లు, ");
INSERT INTO telotsa_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","నా మహిమను, ఈజిప్టులోను, అరణ్యంలోను నేను చూపిన సూచనలను చూసి నాకు లోబడక, నన్ను పదిసార్లు పరీక్షించిన ఏ ఒకరు, ");
INSERT INTO telotsa_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","వారి పూర్వికులకు నేను వాగ్దానంగా ప్రమాణం చేసిన దేశాన్ని వారిలో ఏ ఒక్కరు ఎప్పటికిని చూడరు. నా పట్ల ధిక్కారంగా ప్రవర్తించిన వారెవ్వరూ ఎప్పటికీ చూడరు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","అయితే నా సేవకుడు కాలేబు భిన్నమైన ఆత్మ కలిగి ఉండి నన్ను హృదయమంతటితో వెంబడిస్తున్నందుకు, అతడు వెళ్లిన దేశంలోకి నేను అతన్ని తీసుకువస్తాను, అతని వారసులు దానిని స్వతంత్రించుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","అమాలేకీయులు, కనానీయులు ఆ లోయల్లో నివసిస్తున్నారు కాబట్టి, రేపు వెనుకకు తిరగండి, ఎడారి వైపు ఎర్ర సముద్రం మార్గం గుండా రండి” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","యెహోవా మోషే అహరోనులతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ఎంతకాలం ఈ చెడు సమాజం నా మీద సణుగుతారు? ఈ సణిగే ఇశ్రాయేలీయుల ఫిర్యాదులు నేను విన్నాను. ");
INSERT INTO telotsa_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","కాబట్టి వారికి చెప్పండి, ‘నా జీవం తోడు, మీరు సణుగులను నేను విన్న ప్రకారం నేను మీకు చేస్తాను అని యెహోవా ప్రకటిస్తున్నారు: ");
INSERT INTO telotsa_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ఈ అరణ్యంలో మీ శవాలు రాలిపోతాయి అనగా ఇరవై సంవత్సరాలకు పైబడి జనాభా లెక్కలో నమోదై యుండి, నాకు వ్యతిరేకంగా సణిగిన ప్రతి ఒక్కరు రాలిపోతారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","నేను చేయెత్తి వాగ్దానం చేసిన భూమిలో యెఫున్నె కుమారుడైన కాలేబు, నూను కుమారుడైన యెహోషువ తప్ప మీలో ఏ ఒక్కరు ప్రవేశించరు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","దోచుకోబడతారని నీవు చెప్పిన నీ పిల్లల విషయానికొస్తే, నీవు తిరస్కరించిన భూమిని అనుభవించడానికి నేను వారిని తీసుకువస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","మీ విషయానికొస్తే, మీ శవాలు ఈ అరణ్యంలో రాలిపోతాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","మీ పిల్లలు ఇక్కడ నలభై సంవత్సరాలు కాపరులుగా ఉంటారు, మీలో చివరి శవం ఈ అరణ్యంలో రాలిపోయే వరకు, మీ నమ్మకద్రోహాన్ని బట్టి మీ వ్యభిచారశిక్షను భరిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","నలభై సంవత్సరాల వరకు మీరు దేశాన్ని వేగు చూసిన ప్రతి నలభై రోజులకు ఒక సంవత్సరం, మీ దోషశిక్షను మీరు భరించి నేను మీకు వ్యతిరేకంగా ఉంటే ఎలా ఉంటుందో మీరు తెలుసుకుంటారు.’ ");
INSERT INTO telotsa_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","యెహోవానగు నేనే స్వయంగా చెప్తున్నాను, నాకు వ్యతిరేకంగా పోగయిన ఈ దుష్ట సమాజం మొత్తానికి, నేను ఖచ్చితంగా ఇవి చేస్తాను. ఈ అరణ్యంలో వారు అంతరిస్తారు; ఇక్కడ వారు చస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","మోషే, ఆ దేశాన్ని పరిశీలించండి, అని పంపిన మనుష్యులు, వెళ్లి తిరిగివచ్చి దాని గురించి తప్పుడు నివేదిక తెచ్చి సమర్పించి, సర్వసమాజం సణుగునట్లు చేశారు ");
INSERT INTO telotsa_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","తప్పుడు సమాచారం వ్యాప్తి చెందడానికి బాధ్యులైన వీరు మొత్తబడి, యెహోవా ఎదుట తెగులు ద్వార చనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ఆ దేశాన్ని పరిశీలించిన వారిలో నూను కుమారుడైన యెహోషువ, యెఫున్నె కుమారుడైన కాలేబు మాత్రమే బ్రతికారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","మోషే ఇశ్రాయేలీయులందరికి ఈ విషయం చెప్పినప్పుడు, వారు చాలా ఏడ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","మరుసటిరోజు ఉదయాన్నే వారు, “నిజంగా మేము పాపం చేశాము. ఇప్పుడు మేము యెహోవా వాగ్దానం చేసిన దేశానికి వెళ్లడానికి సిద్ధంగా ఉన్నాం!” అని అంటూ, కొండసీమ మీదున్న ఎత్తైన ప్రదేశానికి బయలుదేరారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","కానీ మోషే, “ఎందుకు మీరు యెహోవా ఆజ్ఞను మీరుతున్నారు? ఇదిలా కొనసాగదు! ");
INSERT INTO telotsa_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","యెహోవా మీతో లేడు కాబట్టి మీరు వెళ్లకండి. మీరు శత్రువుల చేతిలో ఓడిపోతారు, ");
INSERT INTO telotsa_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ఎందుకంటే అమాలేకీయులు, కనానీయులు అక్కడ మీ మీదికి వస్తారు, మీరు వారి ఖడ్గం చేత చస్తారు. ఎందుకంటే మీరు యెహోవా మీద తిరుగుబాటు చేశారు కాబట్టి ఆయన మీతో ఉండరు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","అయినాసరే, వారు అహంకారంతో మోషే గాని, యెహోవా నిబంధన మందసం గాని శిబిరం నుండి కదలక పోయినా, కొండసీమ ప్రాంతానికి ఎక్కి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","అప్పుడు కొండ సీమలో నివసిస్తున్న అమాలేకీయులు కనానీయులు దిగి వచ్చి, ఇశ్రాయేలీయులపై దాడి చేసి, హోర్మా వరకు తరిమికొట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ఇశ్రాయేలీయులతో మాట్లాడుతూ ఇలా చెప్పు: మీకు నివాస స్థలంగా ఇస్తున్న దేశంలో ప్రవేశించిన తర్వాత మీరు ");
INSERT INTO telotsa_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","యెహోవాకు ఇష్టమైన సువాసన కలుగునట్లు మీ మందల నుండి లేదా పశువుల నుండి అర్పణలు అంటే దహనబలులు గాని బలులు గాని, ప్రత్యేకమైన మ్రొక్కుబడులు గాని స్వేచ్ఛార్పణలు గాని, లేదా పండుగ అర్పణలు గాని అర్పించవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","అప్పుడు అర్పణ తెచ్చే వ్యక్తి ఒక పావు హిన్ నూనెలో ఒక ఓమెరు నాణ్యమైన పిండి కలిపి యెహోవాకు భోజనార్పణ సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","దహనబలి లేదా బలి కోసం తెచ్చే ప్రతి గొర్రెపిల్లతో పాటు ఒక పావు హిన్ ద్రాక్షరసం పానార్పణంగా తేవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘భోజనార్పణ కోసం పొట్టేళ్ళతో పాటు రెండు ఓమెర్ల నాణ్యమైన పిండి ఒక హిన్‌లో మూడవ వంతు నూనెతో కలిపి తేవాలి, ");
INSERT INTO telotsa_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","దానితో పాటు ఒక హిన్‌లో మూడవ వంతు ద్రాక్షరసం పానార్పణం కోసం తేవాలి. యెహోవాకు ఇష్టమైన సువాసన గలదిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘యెహోవాకు ప్రత్యేకమైన మ్రొక్కుబడి లేదా సమాధానబలి కోసం దహనబలిగా లేదా బలిగా అర్పించడానికి కోడెను సిద్ధపరిచేటప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","కోడెతో పాటు అయితే భోజనార్పణగా మూడు ఓమెర్ల నూనె కలిపిన అర హిన్ లో నాణ్యమైన పిండి, ");
INSERT INTO telotsa_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","దానితో పాటు అర హిన్ ద్రాక్షరసం పానార్పణం కోసం తేవాలి. అది యెహోవాకు ఇష్టమైన సువాసన గలదిగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ప్రతి కోడె లేదా పొట్టేలు, ప్రతి గొర్రెపిల్ల లేదా మగ మేకపిల్ల ఈ విధంగా సిద్ధపరచబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ఇలా ప్రతి దానిలోకి, మీరు ఎన్ని సిద్ధం చేస్తారో, అన్నిటికి చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘స్వదేశీయులుగా ఉన్న ప్రతి ఒక్కరు యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి అర్పించినప్పుడు ఇలాగే చేయాలి. వారు ఇలాగే విధులను పాటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","వచ్చే తరాలకు కూడా ఇదే నియమం వర్తిస్తుంది. విదేశీయులు లేదా మీ మధ్య నివసించే ఎవరైనా సరే, యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి అర్పించాలనుకుంటే, మీలాగే వారు కూడా చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","సమాజంలో ఉండే మీరైనా, విదేశీయులైనా ఒకే చట్టం పాటించాలి; ఇది రాబోయే తరాలకు నిత్య కట్టుబాటుగా ఉంటుంది. యెహోవా దృష్టిలో మీరూ విదేశీయులు ఒక్కటే: ");
INSERT INTO telotsa_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","మీకూ, మీ మధ్య ఉన్న విదేశీయులకు అవే నియమాలు, అవే నిబంధనలు వర్తిస్తాయి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ఇశ్రాయేలీయులతో మాట్లాడుతూ ఇలా చెప్పు: ‘నేను మిమ్మల్ని తీసుకెళ్తున్న దేశంలో ప్రవేశించినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ఆ దేశం ఆహారాన్ని మీరు తినేటప్పుడు, ఒక భాగం యెహోవాకు అర్పణగా సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","మీరు రుబ్బిన పిండితో చేసిన మొదటి రొట్టెను నూర్పిడి కళ్ళపు అర్పణగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","రాబోయే తరాలకు ఇలా మీ మొదటి పిండి ముద్ద నుండి యెహోవాకు అర్పణను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘సమాజంగా మీరు అనుకోకుండ యెహోవా మోషేకు ఇచ్చిన ఈ ఆజ్ఞలలో దేనినైనా పాటించడంలో ఒకవేళ విఫలమైతే, ");
INSERT INTO telotsa_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","యెహోవా మోషే ద్వార మీకు ఇచ్చిన ఆజ్ఞలు, యెహోవా వాటిని ఇచ్చిన రోజు నుండి రాబోయే తరాల వరకు కొనసాగిస్తూ, ");
INSERT INTO telotsa_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ఒకవేళ తెలియక పొరపాటున మీరితే, అప్పుడు సమాజమంతా యెహోవాకు ఇష్టమైన సువాసనగల దహనబలిగా కోడెను, దానితో పాటు నిర్దేశించిన భోజనార్పణ, పానార్పణలతో, పాపపరిహారబలి కోసం మేకపోతుతో కలిపి అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","యాజకుడు ఇశ్రాయేలు సమాజమంతటి కోసం ప్రాయశ్చిత్తం చేయాలి అప్పుడు వారు క్షమించబడతారు ఎందుకంటే ఆ పాపం ఉద్దేశపూర్వకమైనది కాదు, పైగా వారు పొరపాటున చేసిన తప్పును బట్టి యెహోవాకు వారు హోమబలి పాపపరిహారబలిని అర్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ప్రజలు అనుకోకుండ తప్పు చేశారు కాబట్టి ఇశ్రాయేలు సర్వసమాజం, వారితో నివసిస్తున్న విదేశీయులు క్షమించబడతారు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘అయితే ఒక్క వ్యక్తి అనుకోకుండ చేసిన పాపాలకు, ఆ వ్యక్తి పాపపరిహారబలిగా ఏడాది ఆడ మేకను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","పొరపాటున పాపం చేసిన వారి కోసం యాజకుడు యెహోవా ఎదుట ప్రాయశ్చిత్తం జరిగిస్తాడు, అది జరిగినప్పుడు ఆ వ్యక్తి క్షమించబడతాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","స్వదేశీయులైన ఇశ్రాయేలీయులైనా వారి మధ్యలో నివసించే విదేశీయులైనా పొరపాటున పాపం చేసినవారందరికి ఒకే చట్టం వర్తిస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘అయితే ఎవరైనా కావాలని పాపం చేస్తే, స్వదేశీయులైనా విదేశీయులైనా వారు యెహోవాను దూషించిన వారు కాబట్టి ఖచ్చితంగా ఇశ్రాయేలీయుల నుండి వారిని తొలగించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","వారు యెహోవా మాటను తృణీకరించి, ఆయన ఆజ్ఞలను అతిక్రమించారు, కాబట్టి వారు తప్పక తొలగించబడాలి; వారి అపరాధం వారి మీదే ఉంటుంది.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ఇశ్రాయేలీయులు అరణ్యంలో ఉన్నప్పుడు, ఒక మనుష్యుడు సబ్బాతు దినాన్న కట్టెలు ఏరుకుంటున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","అది చూసినవారు అతన్ని పట్టుకుని, మోషే అహరోనుల ఎదుట సమాజమందరి ఎదుట నిలబెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","అతనికి ఏం చేయాలో స్పష్టత లేనందున అతన్ని కావలిలో ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","అప్పుడు యెహోవా మోషేతో, “ఆ మనుష్యుడు చావాలి. సమాజమంతా అతన్ని శిబిరం బయటకు తీసుకెళ్లి రాళ్లతో కొట్టాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","కాబట్టి యెహోవా మోషేకిచ్చిన ఆజ్ఞ ప్రకారం వారు అతన్ని శిబిరం బయటకు తీసుకెళ్లి రాళ్లతో కొట్టి చంపారు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ఇశ్రాయేలీయులతో మాట్లాడుతూ ఇలా చెప్పు: ‘రాబోయే తరాలన్నిటిలో మీరు మీ వస్త్రాల మూలల్లో నీలం రంగు దారంతో కుచ్చులు తయారుచేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ఆ కుచ్చులను చూసినప్పుడు యెహోవా ఆజ్ఞలన్నీ మీరు జ్ఞాపకం చేసుకుంటారు, వాటికి లోబడాలని మీ హృదయాభిలాషలు మీ నేత్రాశల వెంటపడుతూ వ్యభిచరించకూడదని జ్ఞాపకం చేసుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","అప్పుడు నా ఆజ్ఞలన్నిటికి లోబడాలని జ్ఞాపకం చేసుకుని మీ దేవునికి మీరు ప్రతిష్ఠించుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","నేను మీ దేవుడైన యెహోవానై ఉన్నాను, మీకు దేవునిగా ఉండడానికి నేను మిమ్మల్ని ఈజిప్టు నుండి బయటకు తెచ్చాను. నేను మీ దేవుడైన యెహోవాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","లేవీ మునిమనమడు, కహాతు మనుమడు, ఇస్హారు కుమారుడగు కోరహు, కొంతమంది రూబేనీయులలో ఏలీయాబు కుమారులైన దాతాను, అబీరాములు, పేలెతు కుమారుడైన ఓనులు కొంతమందిని పోగు చేసి, ");
INSERT INTO telotsa_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","మోషేకు ఎదురు తిరిగారు. వారితో 250 మంది ఇశ్రాయేలు నాయకులు, సమాజ నాయకులుగా ఏర్పరచబడిన ప్రముఖులు చేరారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","వారంతా మోషే, అహరోనులకు విరోధంగా పోగై, “మీరు హద్దులు దాటి ప్రవర్తిస్తున్నారు! సర్వసమాజంలో ప్రతిఒక్కరు పరిశుద్ధంగానే ఉన్నారు, యెహోవా వారితో ఉన్నారు. అలాంటప్పుడు యెహోవా సమాజం మీద మిమ్మల్ని మీరు ఎందుకు హెచ్చించుకుంటున్నారు?” అని అడిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","మోషే ఇది విని సాగిలపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","తర్వాత కోరహుతో, అతని సహచరులందరితో ఇలా అన్నాడు: “రేపు ప్రొద్దున యెహోవా తన వారు ఎవరో పవిత్రులెవరో బయలుపరచి తన దగ్గరకు రానిస్తారు. తాను ఎన్నుకున్న మనిషిని ఆయన తన దగ్గరకు రానిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","కోరహూ! నీవూ, నీ వెంట ఉన్న సమస్త సమూహం ఇలా చేయండి: ధూపార్తులు తీసుకోండి ");
INSERT INTO telotsa_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","రేపు యెహోవా ఎదుట వాటిలో నిప్పు తెచ్చి ధూపం వేయండి. యెహోవా ఎవరిని ఎన్నుకుంటారో అతడు పవిత్రుడు. లేవీయులారా! మీరు హద్దులు దాటి ప్రవర్తిస్తున్నారు!” ");
INSERT INTO telotsa_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","మోషే కోరహుతో మాట్లాడుతూ, “ఇప్పుడు వినండి లేవీయులారా! ");
INSERT INTO telotsa_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ఇశ్రాయేలు దేవుడు మిమ్మల్ని మిగిలిన ఇశ్రాయేలీయుల సమాజం నుండి వేరుచేసి, యెహోవా గుడారంలో పని చేయడానికి, సమాజం ముందు నిలబడి వారికి సేవ చేయడానికి మిమ్మల్ని దగ్గరకు తీసుకువచ్చినందుకు ఇది మీకు సరిపోదా? ");
INSERT INTO telotsa_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","నిన్ను, నీ తోటి లేవీయులను ఆయన చేర్చుకున్నారు, కానీ ఇప్పుడు యాజకత్వం కూడా కావాలని మీరు ప్రయత్నిస్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","యెహోవాకు విరోధంగా నీవు నీ పక్షంవారు గుమికూడారు. మీరు అహరోను మీద సణగడానికి అతనెవరు?” ");
INSERT INTO telotsa_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","అప్పుడు మోషే ఏలీయాబు కుమారులైన దాతాను, అబీరాములను పిలిపించాడు. కానీ వారు, “మేము రాము! ");
INSERT INTO telotsa_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","మమ్మల్ని పాలు తేనెలు ప్రవహించే భూమి నుండి ఈ అరణ్యంలో మమ్మల్ని చంపడానికి తీసుకువచ్చారు, అది చాలదా? ఇప్పుడు నీవు మాపై ప్రభువుగా కూడా ఉండాలనుకుంటున్నావు! ");
INSERT INTO telotsa_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","అంతేకాక, మీరు మమ్మల్ని పాలు తేనెలు ప్రవహించే దేశానికి తీసుకురాలేదు లేదా పొలాలు ద్రాక్షతోటల వారసత్వాన్ని మాకు ఇవ్వలేదు. మీరు ఈ మనుష్యులను బానిసలుగా చూడాలనుకుంటున్నారా? మేము రాము!” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","మోషేకు చాలా కోపం వచ్చి యెహోవాతో, “వారి అర్పణలు స్వీకరించకండి. వారి దగ్గర నుండి కనీసం ఒక గాడిదను కూడా నేను తీసుకోలేదు, వారిలో ఎవరి పట్ల ఏ తప్పు చేయలేదు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","మోషే కోరహుతో అన్నాడు, “రేపు నీవూ నీ అనుచరులు అనగా నీవు, వారు, అహరోను యెహోవా ఎదుట నిలబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","మీలో ప్రతి ఒక్కరు తమ ధూపార్తి చేతపట్టుకుని ధూపం వేయాలి. అన్నీ కలిపి 250 ధూపార్తులు యెహోవా ఎదుట దానిని సమర్పించాలి. నీవు అహరోను కూడా మీ ధూపార్తులు సమర్పించాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","కాబట్టి ప్రతి ఒక్కరు తమ ధూపార్తిలో నిప్పువేసి దాని మీద ధూపం వేసి సమావేశ గుడార ద్వారం దగ్గర, మోషే అహరోనులతో నిలిచారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","కోరహు మోషే, అహరోనులకు వ్యతిరేకంగా తన పక్షం వారినందరిని సమావేశ గుడార ప్రవేశం దగ్గర పోగు చేశాడు. అప్పుడు యెహోవా మహిమ సమాజమంతటికి కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","యెహోవా మోషే అహరోనులతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ఒక్కసారిగా నేను వారిని నాశనం చేయడానికి అనుకూలంగా ఉండేలా మీరు ఈ సమాజం నుండి వేరుగా నిలబడండి.” ");
INSERT INTO telotsa_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","కానీ మోషే అహరోనులు సాగిలపడి, “ఓ దేవా! సర్వ ప్రాణులకు ఊపిరి ఇచ్చే దేవా, ఒక్క మనిషి పాపం చేస్తే సమాజమంతటి మీద కోప్పడతారా?” అని వేడుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","అప్పుడు యెహోవా మోషేతో ఇలా చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“సమాజంతో చెప్పు, ‘కోరహు, దాతాను, అబీరాముల డేరాల నుండి దూరంగా వెళ్లండి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","మోషే లేచి దాతాను, అబీరాముల దగ్గరకు వెళ్లాడు. ఇశ్రాయేలు పెద్దలు అతని వెంట వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","అతడు సమాజాన్ని హెచ్చరించాడు, “ఈ దుష్టుల డేరాల నుండి దూరంగా వెళ్లండి! వారికి చెందిన దేన్ని తాకకండి, లేదా వారి పాపాలన్నిటిని బట్టి మీరు తుడిచివేయబడతారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","కాబట్టి కోరహు, దాతాను, అబీరాములు డేరాల దగ్గర నుండి వారు కదిలి దూరంగా వెళ్లారు. దాతాను, అబీరాములు వారి భార్యాపిల్లలు చిన్న పిల్లలు తమ డేరాల ద్వారాలలో నిలబడి ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","అప్పుడు మోషే అన్నాడు, “యెహోవా ఇవన్నీ చేయడానికి నన్ను పంపించారని, నా అంతట నేనే ఏమీ చేయలేదని ఇలా మీరు తెలుసుకుంటారు: ");
INSERT INTO telotsa_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ఈ మనుష్యులు, సహజ మరణం పొందితే, మనుష్యులు అనుభవించు విధిని వీరు అనుభవిస్తే, అప్పుడు యెహోవా నన్ను పంపలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","కానీ ఒకవేళ యెహోవా పూర్తిగా క్రొత్తదాన్ని తెస్తే, భూమి తన నోరు తెరిచి, వారికి సంబంధించిన ప్రతి దానితో పాటు వారిని మ్రింగివేసి, వారు సజీవంగా పాతాళంలోకి వెళ్తే, వీరు యెహోవాతో ధిక్కారంతో వ్యవహరించారని మీకు తెలుస్తుంది.” ");
INSERT INTO telotsa_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","మోషే ఈ మాటలు చెప్పి ముగించిన వెంటనే వారి పాదాల క్రింద నేల చీలిపోయింది, ");
INSERT INTO telotsa_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","భూమి నోరు తెరిచి, ఆ మనుష్యులను వారి ఇంటివారిని, కోరహు పక్షంగా ఉన్నవారందరిని, వారి ఆస్తితో సహా మ్రింగివేసింది. ");
INSERT INTO telotsa_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","వారంతా వారికి చెందిన సమస్తంతో పాటు ప్రాణంతోనే పాతాళంలోకి వెళ్లారు; భూమి వారిని కప్పేసింది. వారంతా సమాజంలో లేకుండా నాశనమయ్యారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","వారి కేకలు విని చుట్టూరా ఉన్న ఇశ్రాయేలీయులు, “మనలను కూడా భూమి మ్రింగివేస్తుంది!” అని అంటూ అరుస్తూ పారిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","యెహోవా దగ్గర నుండి మంటలు లేచి ధూపారాధన చేసే 250 మందిని కాల్చివేసింది. ");
INSERT INTO telotsa_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“యాజకుడైన అహరోను కుమారుడు ఎలియాజరుకు, బూడిదలో నుండి ఆ ధూపార్తులను తీసివేసి నిప్పు కణాలను దూరంగా చెదరగొట్టమని చెప్పు, ఎందుకంటే అవి పవిత్రమైన ధూపార్తులు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","పాపం చేసి ప్రాణాలకు ముప్పు తెచ్చుకున్న వారి ధూపార్తులు. వాటిని చెడగొట్టి, రేకులుగా చేసి, వాటిని బలిపీఠం కప్పుగా వాడాలి, అవి యెహోవా ఎదుట సమర్పించబడినవి కాబట్టి పవిత్రమైనవి. అవి ఇశ్రాయేలీయులకు గుర్తులుగా ఉండును గాక.” ");
INSERT INTO telotsa_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","కాబట్టి యాజకుడైన ఎలియాజరు కాల్చి చంపబడినవారు తీసుకువచ్చిన ఇత్తడి ధూపార్తులను సేకరించి, బలిపీఠం మీద కప్పి ఉండేలా వాటిని సుత్తెతో కొట్టించాడు, ");
INSERT INTO telotsa_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","యెహోవా మోషే ద్వారా అతనికి సూచించిన ప్రకారం చేశాడు. అలా ఎందుకు చేయించారంటే, అహరోను వంశస్థుడు తప్ప ఇతరులెవ్వరు యెహోవా ఎదుట ధూపం వేయడానికి రాకూడదని, వస్తే కోరహు అతని అనుచరుల్లా అవుతారని ఇశ్రాయేలీయులకు జ్ఞాపకం చేయడానికి. ");
INSERT INTO telotsa_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","మరుసటిరోజు ఇశ్రాయేలు సమాజమంతా మోషే అహరోనుల మీద సణిగారు. “మీరు యెహోవా యొక్క ప్రజలను చంపేశారు” అని వారన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","మోషే అహరోనులకు వ్యతిరేకంగా సమాజం గుమికూడి, సమావేశ గుడారం వైపు చూశారు, అకస్మాత్తుగా మేఘం దానిని కప్పింది, యెహోవా మహిమ కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","అప్పుడు మోషే, అహరోనులు సమావేశ గుడారం ముందుకు వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","యెహోవా మోషేతో, ");
INSERT INTO telotsa_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“మీరు సమాజం మధ్య నుండి తొలగిపోండి, వెంటనే వారిని చంపేస్తాను” అన్నారు. అప్పుడు వారు సాష్టాంగపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","అప్పుడు మోషే అహరోనుతో, “నీ ధూపార్తిని తీసుకుని దానిలో ధూపం వేసి, బలిపీఠం నుండి మండుతున్న బొగ్గును తీసుకుని వారికి ప్రాయశ్చిత్తం చేయడానికి సమాజం దగ్గరకు త్వరగా వెళ్లు. యెహోవా నుండి కోపం రగులుతూ వస్తుంది; తెగులు ప్రారంభమైంది” అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","మోషే చెప్పినట్లే అహరోను చేశాడు. ధూపార్తులతో సమాజం మధ్యకు పరుగెత్తుకుంటూ వెళ్లాడు. అప్పటికే ప్రజల్లో తెగులు మొదలయ్యింది కానీ అహరోను ధూపం వేసి వారి కోసం ప్రాయశ్చిత్తం చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","మృతులకు, జీవులకు మధ్య అతడు నిలిచాడు, తెగులు ఆగిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","అయితే, కోరహు తిరుగుబాటు వల్ల చనిపోయినవారు కాక తెగులు ద్వారా 14,700 మంది చనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","తర్వాత తెగులు ఆగిపోయినందుకు అహరోను, సమావేశ గుడార ద్వారం దగ్గర ఉన్న మోషే దగ్గరకు తిరిగి వచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ఇశ్రాయేలీయులతో మాట్లాడి వారి పూర్వికుల గోత్రాల ఒక్కొక్క నాయకుడి నుండి ఒకటి చొప్పున కర్రలను తెప్పించు. ప్రతి వ్యక్తి పేరు అతని కర్రపై వ్రాయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","లేవీ కర్రపై అహరోను పేరు వ్రాయాలి, ఎందుకంటే ప్రతి పూర్వికుల గోత్ర నాయకునికి ఒక కర్ర ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","సమావేశ గుడారంలో నేను మీతో కలిసే నిబంధన మందసం ఎదుట ఈ కర్రలను పెట్టు. ");
INSERT INTO telotsa_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","నేను ఎన్నుకున్న నాయకుడి కర్ర చిగురిస్తుంది, నీకు విరోధంగా ఇశ్రాయేలీయుల నుండి ఎప్పుడు వచ్చే సణుగుళ్లను ముగిస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","కాబట్టి మోషే ఇశ్రాయేలీయులతో మాట్లాడాడు, పూర్వికుల వంశాల క్రమం ప్రకారం ఒక్కొక్క నాయకుడు వారి వారి కర్రను, మొత్తం పన్నెండు కర్రలు ఇచ్చారు. వాటిలో అహరోను కర్ర ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","మోషే ఆ కర్రలను నిబంధన గుడారంలో యెహోవా ఎదుట ఉంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","మర్నాడు మోషే నిబంధన గుడారంలోకి వెళ్లి చూడగా, వాటిలో లేవీ వంశ ప్రతినిధి యైన అహరోను కర్ర చిగురించి మొగ్గలు తొడిగి, పూలు పూసి, బాదం పండ్లు వచ్చాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","మోషే యెహోవా సన్నిధి నుండి ఆ కర్రలన్నీ ఇశ్రాయేలీయులందరి దగ్గరకు తెచ్చాడు. వారు వాటిని చూశారు, ప్రతీ నాయకుడు తన కర్రలను తీసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","యెహోవా మోషేతో, “అహరోను కర్రను తెచ్చి మళ్ళీ నిబంధన మందసం ఎదుట పెట్టు. తిరుగుబాటు చేసినవారికి అది ఒక గుర్తుగా ఉండాలి. నాకు విరోధంగా వారు చేసే సణుగుడుకు ఇది ముగింపు కలిగిస్తుంది, తద్వార వారు చావరు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","యెహోవా తనకు ఆజ్ఞాపించినట్లే మోషే చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ఇశ్రాయేలీయులు మోషేతో, “మేము చస్తాము! మేము నశించాము, మేమంతా నశించాము! ");
INSERT INTO telotsa_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ఎవరైనా కనీసం యెహోవా యొక్క సమావేశ గుడారం దగ్గరకు వచ్చినా చస్తారు. మేమంతా చస్తామా?” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","యెహోవా అహరోనుతో, “పరిశుద్ధాలయానికి సంబంధించిన అపరాధాలకు నీవూ నీ కుమారులు నీ కుటుంబం బాధ్యులు, యాజక ధర్మానికి సంబంధించిన అపరాధాలకు నీవూ నీ కుమారులు బాధ్యులు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","మీతో చేరి నీవు, మీ కుమారులు నిబంధన గుడారం ముందు పరిచర్య చేస్తున్నప్పుడు మీకు సహాయపడడానికి మీ పూర్వికుల గోత్రానికి చెందిన మీ తోటి లేవీయులను తీసుకురండి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","వారు నీకు బాధ్యత వహించాలి, గుడారం యొక్క అన్ని విధులను నిర్వర్తించాలి, అయితే వారు పరిశుద్ధాలయం యొక్క సామాగ్రి దగ్గరకు గాని బలిపీఠం దగ్గరకు గాని వెళ్లకూడదు. లేదంటే వారు మీరు చస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","వారు మీతో కలిసి సమావేశ గుడారంలోని అన్ని పనులు జరిగేలా బాధ్యత వహించాలి; మీకు సహాయం చేయడానికి ఇతరులెవ్వరు రాకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“పరిశుద్ధాలయం, బలిపీఠం పట్ల శ్రద్ధ వహించే విషయంలో మీరు బాధ్యత వహించాలి. తద్వారా ఇశ్రాయేలీయుల మీదికి యెహోవా కోపం రాదు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","నేను నేనే ఇశ్రాయేలీయుల నుండి మీ తోటి లేవీయులను మీకు బహుమానంగా, సమావేశ గుడారంలో సేవ చేయడానికి యెహోవాకు ప్రతిష్ఠించాను. ");
INSERT INTO telotsa_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","అయితే నీవు, నీ కుమారులు మాత్రమే బలిపీఠం దగ్గర, తెర వెనుక ఉన్న ప్రతిదానికీ సంబంధించి యాజకులుగా పని చేయవచ్చు. యాజక ధర్మాన్ని మీకు ప్రత్యేకమైన వరంగా ఇస్తున్నాను. వేరే ఎవరైనా పరిశుద్ధాలయాన్ని సమీపిస్తే, వారికి మరణశిక్ష విధించబడుతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","అప్పుడు యెహోవా అహరోనుతో ఇలా అన్నాడు: “నాకు అర్పించిన అర్పణలకు నేనే నీకు బాధ్యత అప్పగించాను; ఇశ్రాయేలీయులు నాకు ఇచ్చే పరిశుద్ధ అర్పణలన్నీ నేను నీకు, నీ కుమారులకు మీ భాగంగా, మీ శాశ్వత వాటాగా నిర్ణయిస్తున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","బలిపీఠం మీది నిప్పులో కాల్చివేయబడని అతి పవిత్ర అర్పణలలో కొంత భాగం మీరు తీసుకోవాలి. నాకు వారు తెచ్చే అతి పవిత్రమైన భోజనార్పణలు పాపపరిహారబలులు అపరాధబలులు నీకు, నీ కుమారులకు చెందినవి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","అవి అతి పవిత్రంగా ఎంచి తినాలి. ప్రతి మగవాడు అది తినాలి. వాటిని పవిత్రమైనవిగా పరిగణించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ఇది కూడా మీదే: ఇశ్రాయేలీయులు అర్పించే అర్పణలన్నిటిలో నుండి ప్రక్కన పెట్టబడినది. నేను నీకు, నీ కుమారులు కుమార్తెలకు మీ శాశ్వత వాటాగా నిర్ణయిస్తున్నాను. మీ ఇంట్లో ఆచార ప్రకారంగా శుభ్రంగా ఉన్న ప్రతి ఒక్కరూ దానిని తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“యెహోవాకు ఇశ్రాయేలీయులు వారి కోతలో నుండి ప్రథమ ఫలంగా అర్పించే ధాన్యము, ద్రాక్షరసము, నూనె అంతటిని మీకు ఇస్తున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","దేశం పంటలన్నిటిలో యెహోవాకు అర్పించే ప్రథమ ఫలాలు మీకు చెందుతాయి. నీ కుటుంబంలో ఆచార ప్రకారం పవిత్రులందరు వాటిని తినవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ఇశ్రాయేలీయులు యెహోవా కోసం ప్రతిష్ఠించిన ప్రతిదీ నీకు చెందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ప్రతి గర్భం నుండి వచ్చిన యెహోవాకు అర్పించబడ్డ జ్యేష్ఠ సంతానం, మనుష్యులైన, జంతువులైన, మీకు చెందుతాయి. కానీ మీరు ప్రతి పెద్ద కుమారున్ని, అపవిత్ర జంతువుల తొలిచూలును విడిపించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ఒక నెల వయస్సున్నప్పుడు పరిశుద్ధాలయ షెకెల్ ప్రకారం అయిదు షెకెళ్ళ వెండితో విడిపించాలి, అంటే ఇరవై గెరాలు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“ఆవులలో, గొర్రెలలో, మేకలలో తొలిచూలును విడిపించకూడదు. అవి పవిత్రమైనవి. వాటి రక్తం బలిపీఠం చుట్టూ ప్రోక్షించి యెహోవాకు సువాసనగా ఉండే హోమంగా వాటి క్రొవ్వును కాల్చివేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ప్రత్యేక అర్పణలోని బోర, కుడి తొడ ఎలాగో, వాటి మాంసం కూడా మీకు చెందుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ఇశ్రాయేలీయులు యెహోవాకు తెచ్చే పవిత్రార్పణలను ప్రక్కకు పెట్టినవి నీకు, నీ కుమారులకు, కుమార్తెలకు శాశ్వత వాటాగా ఇస్తున్నాను. ఇది యెహోవా ఎదుట నీతో పాటు నీ సంతానానికి నిత్య ఉప్పు ఒడంబడికగా ఉంటుంది.” ");
INSERT INTO telotsa_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","యెహోవా అహరోనుతో ఇలా చెప్పారు, “వారి దేశంలో నీకు స్వాస్థ్యం కానీ వాటా కానీ ఉండదు; ఇశ్రాయేలీయుల మధ్య నేనే నీ వాటాను నేనే నీ స్వాస్థ్యాన్ని. ");
INSERT INTO telotsa_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“సమావేశ గుడారం దగ్గర సేవ చేస్తున్న లేవీయులకు పారితోషికంగా ఇశ్రాయేలీయులు ఇచ్చే దశమ భాగాలను స్వాస్థ్యంగా ఇస్తున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ఇప్పటినుండి యాజకులు, లేవీయులు తప్ప ఇశ్రాయేలీయులు సమావేశ గుడారం దగ్గరకు రాకూడదు లేదా వారి పాపానికి ప్రతిఫలం భరించి చస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","లేవీయులు మాత్రమే సమావేశ గుడారంలో సేవ చేస్తారు వారు చేసే అపరాధాలకు వారే బాధ్యులు. ఇది రాబోయే తరాలకు నిత్య కట్టుబాటుగా ఉంటుంది. ఇశ్రాయేలీయుల మధ్య వారికి వారసత్వం ఉండదు. ");
INSERT INTO telotsa_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","దానికి బదులు, ఇశ్రాయేలీయులు యెహోవాకు అర్పణగా ప్రతిష్ఠించే దశమ భాగాలను నేను లేవీ వంశస్థులకు వారసత్వంగా ఇస్తున్నాను. అందుకే, వారిని ఉద్దేశించి ఇలా చెప్పాను: ‘ఇశ్రాయేలీయుల మధ్య వారికి వారసత్వం ఉండదు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","యెహోవా మోషేతో ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“లేవీయులతో మాట్లాడుతూ ఇలా చెప్పు: ‘మీరు ఇశ్రాయేలీయుల నుండి వారసత్వంగా దశమభాగం తీసుకున్నప్పుడు, ఆ దశమభాగంలో పదవ వంతు మీరు యెహోవాకు అర్పణగా సమర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","అలా ప్రత్యేకించిన అర్పణలు నూర్పిడి కళ్ళంలోని ధాన్యంలా, గానుగ నుండి వచ్చిన ద్రాక్షరసంలా లెక్కకు వస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ఇశ్రాయేలీయుల నుండి పుచ్చుకొనే దశమ భాగాలన్నిటి నుండి యెహోవాకు మీరు కూడా అర్పణలు ఇస్తారు. ఈ దశమ భాగాల నుండి యెహోవా భాగమును యాజకుడైన అహరోనుకు ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","మీకు ఇవ్వబడిన ప్రతి దానిలో ఉత్తమమైన పవిత్రమైన భాగాన్ని మీరు యెహోవా యొక్క భాగంగా సమర్పించాలి.’ ");
INSERT INTO telotsa_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“లేవీయులకు చెప్పు: ‘శ్రేష్ఠమైనవి అర్పించినప్పుడు, అవి మీ నూర్పిడి కళ్ళంలా, ద్రాక్ష గానుగలా లెక్కకు వస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","మిగితా వాటిని మీరు, మీ ఇంటివారు ఎక్కడైనా తినవచ్చు అది సమావేశ గుడారంలో మీరు చేస్తున్న సేవకు మీ జీతము. ");
INSERT INTO telotsa_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","మీరు దానిలో ఉత్తమమైన వాటిని అర్పించినప్పుడు మీరు దాని గురించి ఎటువంటి పాపశిక్షను భరించరు; అయితే ఇశ్రాయేలీయుల పరిశుద్ధ అర్పణలను అపవిత్రపరచవద్దు. అప్పుడు మీరు చావరు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","యెహోవా మోషే అహరోనులతో ఇలా చెప్పారు: ");
INSERT INTO telotsa_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","యెహోవా ఆజ్ఞాపించిన నియమానికి ఇది అవసరం: ఇశ్రాయేలీయులు లోపం లేని లేదా మచ్చలేని కాడి మోయని ఎర్రని పెయ్యను మీ దగ్గరకు తేవాలని చెప్పండి. ");
INSERT INTO telotsa_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","దానిని యాజకుడైన ఎలియాజరుకు ఇవ్వాలి; అతని ఎదుట శిబిరం బయట దానిని వధించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","అప్పుడు యాజకుడైన ఎలియాజరు దాని రక్తంలో కొంత వ్రేలితో తీసుకుని సమావేశ గుడారం ముందు భాగం వైపు ఆ రక్తాన్ని ఏడుసార్లు చిలకరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","అతడు చూస్తుండగా ఆ పెయ్య కాల్చివేయబడాలి. దాని చర్మం, మాంసం, రక్తం, పేడ అంతా కాల్చివేయబడాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","అప్పుడు యాజకుడు కొంత దేవదారు కర్రను, హిస్సోపు చెట్టురెమ్మను ఎర్ర దారాన్ని తీసుకుని పెయ్యను కాల్చి నిప్పులో వెయ్యాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","తర్వాత యాజకుడు తన బట్టలు ఉతుక్కుని నీటితో స్నానం చేయాలి. తర్వాత అతడు శిబిరంలో ప్రవేశించవచ్చు గాని సాయంత్రం వరకు ఆచారరీత్య అపవిత్రుడే. ");
INSERT INTO telotsa_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ఆ పెయ్యను దహించు వ్యక్తి తన బట్టలు ఉతుక్కుని నీటితో స్నానం చేయాలి, సాయంత్రం వరకు అతడు అపవిత్రుడే. ");
INSERT INTO telotsa_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","పవిత్రుడైనవాడు ఆవు పెయ్య బూడిదను పోగు చేసి శిబిరం బయట ఆచార ప్రకారం శుభ్రమైన చోట ఉంచాలి. అది శుద్ధి జలంలో వాడబడడానికి ఇశ్రాయేలు సమాజం ద్వారా పెట్టబడాలి; అది పాపపరిహారబలి. ");
INSERT INTO telotsa_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","పెయ్య బూడిదను పోగుచేసిన వ్యక్తి కూడా తన బట్టలు ఉతుక్కోవాలి, అతడు సాయంత్రం వరకు అపవిత్రునిగా ఉంటాడు. ఇది ఇశ్రాయేలీయులకు, వారి మధ్య నివసిస్తున్న విదేశీయులకు నిత్య కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“మానవ శవాన్ని ఎవరైనా తాకితే వారు ఏడు రోజులు అపవిత్రులై ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","వారు మూడవ రోజు, ఏడవ రోజు తమను తాము శుద్ధి చేసుకోవాలి; అప్పుడు వారు శుద్ధులవుతారు. అయితే వారు మూడవ రోజు, ఏడవ రోజు శుద్ధి చేసుకోకపోతే అపవిత్రంగానే ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ఒక మనుష్యుని మృతదేహాన్ని తాకిన తర్వాత తమను తాము శుద్ధి చేసుకోకపోతే, యెహోవా సమావేశ గుడారాన్ని అపవిత్రం చేసినవారవుతారు. అలాంటి వారిని ఇశ్రాయేలు నుండి బహిష్కరించాలి. ఎందుకంటే, శుద్ధి జలం వారి మీద చిలకరింపబడలేదు, వారు అపవిత్రులుగా ఉన్నారు. వారి అపవిత్రత వారి మీద ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ఇదీ గుడారంలో మనుష్యులెవరైనా చనిపోతే దానికి సంబంధించిన నియమం: ఎవరైనా డేరాలో ప్రవేశిస్తే, దానిలో ఉంటే, వారు ఏడు రోజులపాటు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","మూత పెట్టి ఉంచని ప్రతి పాత్ర అపవిత్రమే. ");
INSERT INTO telotsa_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“ఎవరైనా బయట ఉన్నప్పుడు ఖడ్గం చేత చంపబడిన వారిని లేదా సహజ మరణం పొందినవారిని, లేదా మానవుల ఎముకలు కానీ, సమాధి కానీ ముట్టుకుంటే, వారు ఏడు రోజులు అపవిత్రులుగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ఎందుకంటే అపవిత్రమైన వ్యక్తి కోసం, కాల్చబడిన పాపపరిహారబలి యొక్క బూడిద కొంత పాత్రలో వేసి, వాటి మీద పారే తాజా నీరు పొయ్యాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","అప్పుడు ఆచార ప్రకారం పవిత్రంగా ఉన్న వ్యక్తి కొంత హిస్సోపు తీసుకుని, నీటిలో ముంచి గుడారం అన్ని అలంకరణలు అక్కడ ఉన్న ప్రజలను చిలకరించాలి. అతడు మానవ ఎముక లేదా సమాధిని తాకిన వారి మీద లేదా చంపబడిన ఎవరైనా లేదా సహజ మరణం పొందినవారి మీద కూడా చిలకరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","పవిత్రుడైన పురుషుడు అపవిత్రుల మీద మూడవ రోజు, ఏడవ రోజు చిలకరించాలి, ఏడవ రోజు వారిని పవిత్రపరచాలి. పవిత్రపరచబడే వారు వారి బట్టలు ఉతుక్కుని నీటితో స్నానం చేయాలి, ఆ సాయంత్రం వారు శుద్ధులవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","కానీ అపవిత్రులైనవారు తమను తాము శుద్ధి చేసుకోకపోతే, వారు సమాజం నుండి బహిష్కరించబడాలి, వారు యెహోవా పరిశుద్ధాలయాన్ని అపవిత్ర పరిచిన వారు. శుద్ధి జలం వారి మీద చిలకరింపబడలేదు కాబట్టి వారు అపవిత్రులు. ");
INSERT INTO telotsa_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ఇది వారికి నిత్య కట్టుబాటుగా ఉంటుంది. “శుద్ధి జలం చిలకరించు పురుషుడు కూడా తన బట్టలు ఉతుక్కోవాలి. ఎవరైనా శుద్ధి జలం తాకితే సాయంత్రం వరకు వారు అపవిత్రులు. ");
INSERT INTO telotsa_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","అపవిత్రమైనవారు ఏది ముట్టిన అది అపవిత్రమే, ఎవరైనా దానిని ముట్టుకుంటే సాయంత్రం వరకు వారు అపవిత్రులుగా ఉంటారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","సంవత్సరం మొదటి నెలలో ఇశ్రాయేలు సమాజమంతా సీను ఎడారికి చేరి కాదేషులో దిగారు. అక్కడ మిర్యాము చనిపోయి పాతిపెట్టబడింది. ");
INSERT INTO telotsa_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","అయితే సమాజానికి నీళ్లు లేవు కాబట్టి ప్రజలు మోషే, అహరోనులకు వ్యతిరేకంగా గుమికూడారు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","వారు మోషేతో గొడవపడుతూ, “మా సహోదరులు యెహోవా ఎదుట చనిపోయినప్పుడు మేము కూడా చనిపోయి ఉంటే బాగుండేది! ");
INSERT INTO telotsa_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","యెహోవా సమాజాన్ని ఈ అరణ్యంలోనికి ఎందుకు తెచ్చావు? మేము, మా పశువులు చావాలనా? ");
INSERT INTO telotsa_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","మీరు మమ్మల్ని ఈజిప్టు నుండి ఈ భయంకరమైన చోటికి ఎందుకు తీసుకువచ్చారు? దీనిలో ధాన్యాలు లేదా అంజూరాలు, ద్రాక్షలు లేదా దానిమ్మలు లేవు. త్రాగడానికి నీరు దొరకలేదు!” ");
INSERT INTO telotsa_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","మోషే అహరోనులు సమాజం నుండి సమావేశ గుడారం దగ్గరకు వెళ్లి సాష్టాంగపడ్డారు. అప్పుడు యెహోవా మహిమా ప్రకాశం వారికి కనిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","యెహోవా మోషేతో, ");
INSERT INTO telotsa_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“చేతికర్రను పట్టుకుని, నీవు నీ అన్న అహరోను కలిసి సమాజాన్ని సమకూర్చి, వారు చూస్తుండగా ఆ బండను ఆజ్ఞాపించు, ఆ బండ నుండి నీళ్లు వస్తాయి. వారు వారి పశువులు త్రాగడానికి సమాజం కోసం నీవు ఆ బండ నుండి నీళ్లను రప్పిస్తావు.” ");
INSERT INTO telotsa_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","కాబట్టి మోషే ఆయన ఆజ్ఞ ప్రకారం యెహోవా సన్నిధి నుండి తన చేతికర్రను తీసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","అతడు, అహరోను సమాజాన్ని బండ ఎదుట సమకూర్చారు మోషే, “ద్రోహులారా! వినండి. ఈ బండలో నుండి మీ కోసం నీళ్లు రప్పించాలా?” ");
INSERT INTO telotsa_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","అప్పుడు మోషే చేయి ఎత్తి రెండు సార్లు కర్రతో బండను కొట్టాడు. వెంటనే నీళ్లు ఉబుకుతూ వచ్చాయి, సమాజ ప్రజలు, వారి పశువులతో సహా త్రాగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","అయితే యెహోవా మోషే అహరోనులతో, “మీరు ఇశ్రాయేలీయుల దృష్టిలో నా పరిశుద్ధతను ఘనపరచడానికి నన్ను నమ్మలేదు కాబట్టి మీరు ఈ సమాజాన్ని వాగ్దాన దేశానికి తీసుకెళ్లరు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ఇవి మెరీబా జలాలు. ఇక్కడ ఇశ్రాయేలీయులు యెహోవాతో గొడవపడ్డారు, యెహోవా తన పరిశుద్ధతను నిరూపించుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","మోషే కాదేషు నుండి ఎదోము రాజు దగ్గరకు ఈ వర్తమానంతో దూతలను పంపాడు: “నీ సహోదరుడైన ఇశ్రాయేలు ఇలా చెప్తున్నాడు: మా మీదికి వచ్చిన కష్టాలన్నిటి గురించి నీకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","మా పూర్వికులు ఈజిప్టుకు వెళ్లారు. చాలా కాలం మేమక్కడ ఉన్నాము. ఈజిప్టువారు మా పట్ల, మా పూర్వికుల పట్ల దారుణంగా ప్రవర్తించారు, ");
INSERT INTO telotsa_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","అయితే మేము యెహోవాకు మొరపెట్టినప్పుడు, ఆయన మా మొర ఆలకించాడు దేవదూతను పంపి, ఈజిప్టు నుండి మమ్మల్ని బయటకు తీసుకువచ్చాడు. “ఇప్పుడు మేము కాదేషులో ఉన్నాము, ఈ పట్టణం మీ సరిహద్దుల చివర ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","దయచేసి మమ్మల్ని మీ దేశం మార్గం ద్వారా వెళ్లనివ్వండి. మేము మీ పొలాలు, ద్రాక్షతోటల్లో నుండి వెళ్లము, మీ బావులలోని నీళ్లు త్రాగము. రాజమార్గంలోనే సాగిపోతాము. ఈ దేశం పొలిమేర దాటే వరకు కుడికి గాని, ఎడమకు గాని తిరగకుండా వెళ్తాము.” ");
INSERT INTO telotsa_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","కానీ ఎదోము రాజు ఇలా ఆజ్ఞాపించారు: “మీరు ఇక్కడినుండి వెళ్లకూడదు. వెళ్లడానికి ప్రయత్నిస్తే ఖడ్గంతో మీపై దాడి చేస్తాము.” ");
INSERT INTO telotsa_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ఇశ్రాయేలు ప్రజలు తిరిగి కబురు పంపారు: “మేము రాజమార్గంలోనే సాగిపోతాము. మేము మా పశువులు నీళ్లు త్రాగితే దానికి వెల చెల్లిస్తాము. మేము కేవలం కాలినడకతో దాటి వెళ్తాం అంతే ఇంకేమి లేదు.” ");
INSERT INTO telotsa_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","వారు తిరిగి జవాబిచ్చారు: “మీరు దాటి వెళ్లకూడదు.” ఎదోము వారు వారిని ఎదుర్కోడానికి, శక్తిగల పెద్దబలగంతో వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ఎదోము వారు ఇశ్రాయేలీయులను తమ సరిహద్దులు దాటనివ్వలేదు కాబట్టి ఇశ్రాయేలీయులు అక్కడినుండి తిరిగిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ఇశ్రాయేలు సమాజమంత కాదేషు నుండి ప్రయాణమై హోరు పర్వతానికి చేరారు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ఎదోము సరిహద్దు దగ్గర ఉన్న హోరు పర్వతం దగ్గర, యెహోవా మోషే అహరోనులతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“అహరోను తన పూర్వికుల దగ్గర చేర్చబడతాడు. మీరిద్దరు మెరీబా నీళ్ల దగ్గర నా మీద తిరుగుబాటు చేశారు కాబట్టి అతడు ఇశ్రాయేలీయులకు వాగ్దానం చేసిన దేశంలో ప్రవేశించడు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","నీవు అహరోనును, అతని కుమారుడైన ఎలియాజరును హోరు పర్వతం పైకి తీసుకెళ్లు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","అహరోను వస్త్రాలు తీసి, అతని కుమారుడైనా ఎలియాజరుకు తొడిగించు. అక్కడే అహరోను చనిపోయి తన పూర్వికుల దగ్గర చేర్చబడతాడు.” ");
INSERT INTO telotsa_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","యెహోవా ఆజ్ఞ ప్రకారం మోషే చేశాడు. సమాజమంతా చూస్తూ ఉండగా వారు హోరు పర్వతం ఎక్కారు. ");
INSERT INTO telotsa_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","మోషే అహరోను వస్త్రాలు తీసి అతని కుమారుడైన ఎలియాజరుకు తొడిగించాడు. అహరోను ఆ పర్వత శిఖరం మీదనే చనిపోయాడు. మోషే ఎలియాజరు పర్వతం దిగి వచ్చారు, ");
INSERT INTO telotsa_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","సమాజమంతా అహరోను చనిపోయాడని ఎప్పుడైతే తెలుసుకుందో, ఇశ్రాయేలీయులంతా ముప్పై రోజులు అహరోను కోసం సంతాపం పాటించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ఇశ్రాయేలీయులు అతారీముకు వెళ్లే మార్గాన వస్తున్నారని దక్షిణ ప్రాంతంలో ఉన్న అరాదులో ఉన్న కనానీయ రాజు విని, ఇశ్రాయేలీయులపై దాడి చేసి, కొంతమందిని చెరగా తీసుకెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","అప్పుడు ఇశ్రాయేలీయులు యెహోవాకు ఈ మ్రొక్కుబడి చేసుకున్నారు: “మీరు ఈ ప్రజలను మా చేతులకు అప్పగిస్తే, వారి పట్టణాలను పూర్తిగా నాశనం చేస్తాము.” ");
INSERT INTO telotsa_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","యెహోవా ఇశ్రాయేలు మనవి విని కనానీయులను వారికి అప్పగించారు. వారు వారిని, వారి పట్టణాలను సర్వనాశనం చేశారు; కాబట్టి ఆ స్థలానికి హోర్మా అనే పేరు వచ్చింది. ");
INSERT INTO telotsa_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ఎదోము చుట్టూ తిరిగి రావాలని వారు హోరు పర్వతం నుండి ఎర్ర సముద్రం మార్గాన ప్రయాణం చేశారు. అయితే ప్రజలు ఈ ప్రయాణంలో ఓపిక కోల్పోయారు; ");
INSERT INTO telotsa_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","దేవునికి మోషేకు విరోధంగా మాట్లాడుతూ, “ఈ అరణ్యంలో మేము చావాలని ఈజిప్టు నుండి మమ్మల్ని ఎందుకు తెచ్చారు? ఇక్కడ తినడానికి తిండి లేదు! త్రాగడానికి నీళ్లు లేవు! ఈ పిచ్చి ఆహారమంటే మాకు అసహ్యం!” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","అప్పుడు యెహోవా వారి మధ్యకు విషసర్పాలను పంపారు; అవి ప్రజలను కాటు వేశాయి, చాలామంది ఇశ్రాయేలీయులు చనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ప్రజలు మోషే దగ్గరకు వచ్చి, “మేము యెహోవాకు, నీకు విరోధంగా మాట్లాడి పాపం చేశాము. యెహోవా మా మధ్య నుండి సర్పాలను తీసివేసేలా ప్రార్థన చేయండి” అన్నారు. కాబట్టి మోషే ప్రజల కోసం ప్రార్థన చేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","యెహోవా మోషేతో, “ఒక సర్పం చేసి స్తంభం మీద పెట్టు; పాము కాటేసినప్పుడు ఎవరైనా దానిని చూస్తే, వారు బ్రతుకుతారు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","కాబట్టి మోషే ఇత్తడి సర్పాన్ని చేసి, దాన్ని ఒక స్తంభం మీద పెట్టాడు. అప్పుడు ఎవరైనా పాము కాటేసినప్పుడు, ఇత్తడి సర్పాన్ని చూస్తే, వారు చావలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ఇశ్రాయేలీయులు ప్రయాణం చేసి, ఓబోతులో దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","తర్వాత ఓబోతు నుండి ప్రయాణం చేసి, ఈయ్యె-అబారీములో దిగారు. అది మోయాబుకు ఎదురుగా, సూర్యోదయ దిక్కున ఉన్న అరణ్యము. ");
INSERT INTO telotsa_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","అక్కడినుండి ప్రయాణం చేసి జెరెదు లోయలో దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","వారు అక్కడినుండి బయలుదేరి, అమోరీయుల భూభాగంలో విస్తరించి ఉన్న అరణ్యంలో ఉన్న అర్నోను ప్రక్కన విడిది చేశారు. అర్నోను మోయాబు అమోరీయుల మధ్య మోయాబు సరిహద్దు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","15","అందుకే యెహోవా యుద్ధాల గ్రంథంలో: “సుఫాలోని వాహేబు, అర్నోను లోయలు ఆరు పట్టణం వరకు ఉన్న పల్లపు లోయలు మోయాబు సరిహద్దులో ఉన్నాయి” అని వ్రాయబడి ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","అక్కడినుండి వారు బెయేర్‌కు వెళ్లారు, ఈ బావి గురించి యెహోవా మోషేతో, “ప్రజలను సమకూర్చు, నేను వారికి నీళ్లిస్తాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","అప్పుడు ఇశ్రాయేలు ప్రజలు ఈ పాట పాడారు: “ఓ బావి ఉప్పొంగు! దాని గురించి పాడండి. ");
INSERT INTO telotsa_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","రాకుమారులు ఆ బావిని త్రవ్వించారు, ప్రజల సంస్థానాధిపతులు తమ రాజదండాలతో కర్రలతో త్రవ్వారు.” తర్వాత వారు అరణ్యం నుండి మత్తానకు వెళ్లారు, ");
INSERT INTO telotsa_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","మత్తాన నుండి నహలీయేలుకు, నహలీయేలు నుండి బామోతుకు, ");
INSERT INTO telotsa_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","బామోతు నుండి మోయాబు లోయకు వెళ్లారు. అక్కడే పిస్గా పర్వతం ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ఇశ్రాయేలీయులు అమోరీయుల రాజైన సీహోను దగ్గరకు దూతలను పంపారు: ");
INSERT INTO telotsa_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“మీ దేశం మీదుగా మమ్మల్ని వెళ్లనివ్వండి. మీ పొలాల వైపు, ద్రాక్షతోటల పొలాల వైపు తిరగము, మీ బావులలోని నీళ్లు త్రాగము. మీ దేశం పొలిమేర దాటే వరకు రాజమార్గంలోనే వెళ్తాము.” ");
INSERT INTO telotsa_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","అయితే సీహోను ఇశ్రాయేలీయులను తన దేశం గుండా వెళ్లడానికి అనుమతించలేదు. అతడు తన సైన్యమంతటిని పోగు చేసి, ఇశ్రాయేలుపై దాడి చేయడానికి అరణ్యంలోకి వెళ్లాడు. అతడు యాహాజుకు చేరినప్పుడు, ఇశ్రాయేలుతో పోరాడాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","అయితే ఇశ్రాయేలు అతన్ని ఖడ్గంతో చంపి అతని దేశాన్ని అర్నోను నది నుండి యబ్బోకు వరకు ఆక్రమించారు, కానీ అమ్మోనీయుల సరిహద్దు వరకు మాత్రమే ఎందుకంటే వారి సరిహద్దు పటిష్టమైనది. ");
INSERT INTO telotsa_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ఇశ్రాయేలీయులు అమోరీయుల పట్టణాలన్నిటిని, హెష్బోను దాని చుట్టూరా ఉన్న గ్రామాలతో సహా స్వాధీనం చేసుకుని ఆక్రమించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","హెష్బోను అమోరీయుల రాజైన సీహోను పట్టణము. సీహోను అంతకుముందు మోయాబు రాజుతో యుద్ధం చేసి, అర్నోను నది వరకు ఉన్న ప్రదేశమంతా వశం చేసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","అందుకే సామెతలు చెప్పేవారు ఇలా అంటారు: హెష్బోనుకు రండి అది తిరిగి కట్టబడనివ్వండి; సీహోను పట్టణం పూర్వస్థితికి వచ్చును గాక. ");
INSERT INTO telotsa_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","హెష్బోను నుండి అగ్ని బయలుదేరింది, సీహోను పట్టణం నుండి మంటలు వచ్చాయి. అది మోయాబులోని ఆరు పట్టణాన్ని కాల్చివేసింది. అర్నోను యొక్క ఎత్తైన స్థలాల యజమానులను దహించివేసింది. ");
INSERT INTO telotsa_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","మోయాబూ, నీకు శ్రమ! కెమోషు ప్రజలారా! మీరు నాశనమయ్యారు. అతడు తన కుమారులను పారిపోయేవారిగా, అతని కుమార్తెలను అమోరీయుల రాజైన సీహోను దగ్గర చెరగా అప్పగించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“అయితే మేము వారిని కూల్చివేసాము; హెష్బోను అధికారం దీబోను వరకు నాశనమైంది. నోఫహు వరకు వారిని పడగొట్టాము, మెదెబా వరకు అది వ్యాపించింది.” ");
INSERT INTO telotsa_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","కాబట్టి ఇశ్రాయేలీయులు అమోరీయుల స్థలంలో స్థిరపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","యాజెరు ప్రాంతాన్ని చూసి రమ్మని మోషే వేగులవారిని పంపిన తర్వాత, ఇశ్రాయేలీయులు ఆ పట్టణాన్ని, దాని చుట్టూరా ఉన్న గ్రామాలను స్వాధీనపరచుకుని అక్కడ ఉన్న అమోరీయులను తరిమేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","తర్వాత వారు తిరిగి బాషానుకు వెళ్లే మార్గంలో వెళ్లాము, అప్పుడు బాషాను రాజైన ఓగు తన సైన్యమంతటితో ఎద్రెయీ దగ్గర యుద్ధంలో వారిని ఎదుర్కోడానికి బయలుదేరాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","యెహోవా మోషేతో, “అతనికి భయపడకండి, ఎందుకంటే అతన్ని, అతని సైన్యమంతటిని, అతని దేశాన్ని మీ చేతికి అప్పగించాను. హెష్బోనులో పరిపాలించిన అమోరీయుల రాజైన సీహోనుకు చేసినట్లు అతనికి చేయండి” అని ఆజ్ఞాపించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","కాబట్టి వారు ఓగును, అతని కుమారులను, అతని సైన్యమంతటిని, ఏ ఒక్కరు మిగలకుండా హతం చేశారు. అతని దేశాన్ని స్వాధీనం చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","తర్వాత ఇశ్రాయేలీయులు మోయాబు సమతల మైదానాల వైపు ప్రయాణం చేసి యొర్దాను నది తూర్పుగా, యెరికో వైపు దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ఇశ్రాయేలు అమోరీయులకు చేసినదంతా సిప్పోరు కుమారుడైన బాలాకు చూశాడు, ");
INSERT INTO telotsa_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","చాలామంది ఉన్నందున మోయాబు భయపడింది. నిజానికి, ఇశ్రాయేలీయుల వల్ల మోయాబు భయంతో నిండిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","మోయాబీయులు మిద్యాను పెద్దలతో, “ఈ దండు, ఒక ఎద్దు పొలం లోని గడ్డిని లాక్కున్నట్లు, మన చుట్టూ ఉన్న సమస్తాన్ని లాక్కుంటుంది” అని అన్నారు. కాబట్టి ఆ సమయంలో మోయాబు రాజైన సిప్పోరు కుమారుడైన బాలాకు, ");
INSERT INTO telotsa_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","యూఫ్రటీసు నదికి సమీపంలో ఉన్న పెతోరు దగ్గర ఉన్న బెయోరు కుమారుడైన బిలామును తన స్వదేశంలో పిలువడానికి దూతలను పంపాడు. బాలాకు అన్నాడు: “ఈజిప్టు నుండి ప్రజలు వచ్చారు; వారు భూ ముఖాన్ని కప్పి, నా ప్రక్కన స్థిరపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","నీవు వచ్చి వీరిని శపించాలి, ఎందుకంటే వారు నా శక్తికి మించి ఉన్నారు. బహుశా అప్పుడు నేను వీరిని ఓడించి ఈ స్థలం నుండి తరిమివేయగలుగుతాను. నీవు ఎవరిని దీవిస్తే వారు దీవించబడతారని, నీవు ఎవరిని శపిస్తే వారు శపించబడతారని నాకు తెలుసు.” ");
INSERT INTO telotsa_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","మోయాబు మిద్యాను పెద్దలు, భవిష్యవాణికి రుసుము తీసుకెళ్లారు. వారు బిలాము దగ్గరకు వచ్చి, బాలాకు చెప్పింది అతనికి చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","బిలాము వారితో, “ఈ రాత్రికి ఇక్కడ ఉండండి, యెహోవా నాకు చెప్పేది నేను మీకు తెలియజేస్తాను” అని అన్నాడు. కాబట్టి మోయాబు అధికారులు ఆ రాత్రి అతనితో ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ఆ రాత్రి దేవుడు వచ్చి బిలామును, “నీతో ఉన్న వీళ్ళు ఎవరు?” అని ప్రశ్నించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","బిలాము దేవునితో, “సిప్పోరు కుమారుడు, మోయాబు రాజైన బాలాకు, నాకు ఈ సందేశం పంపాడు: ");
INSERT INTO telotsa_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ఈజిప్టు నుండి వచ్చిన ఒక ప్రజల గుంపు భూమినంతా కప్పుతుంది. నా కోసం వారిని శపించు. బహుశ అప్పుడు నేను వారితో యుద్ధం చేసి తరిమివేస్తాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","అయితే దేవుడు బిలాముతో, “నీవు వారితో వెళ్లొద్దు. వారు దీవించబడినవారు కాబట్టి నీవు వారిని శపించకూడదు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","మర్నాడు ఉదయం బిలాము బాలాకు అధికారులతో, “మీ సొంత దేశానికి వెళ్లిపొండి, నేను మీతో వెళ్లడానికి యెహోవా నిరాకరించారు” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","కాబట్టి మోయాబు అధికారులు బాలాకు దగ్గరకు తిరిగివెళ్లి, “బిలాము మాతో రావడానికి ఒప్పుకోలేదు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","అప్పుడు బాలాకు ఇతర అధికారులను, మొదటిసారి కన్నా ఇంకా ఎక్కువ మంది ప్రముఖులను, పంపాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","వారు బిలాము దగ్గరకు వచ్చి అన్నారు: “సిప్పోరు కుమారుడైన బాలాకు ఇలా చెప్తున్నాడు: నా దగ్గరకు రాకుండ ఏది కూడా మిమ్మల్ని ఆపనివ్వకండి, ");
INSERT INTO telotsa_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ఎందుకంటే నేను నిన్ను గొప్పగా గౌరవిస్తాను, నీవు నాకు ఏది చెబితే అది చేస్తాను. వచ్చి నా కోసం ఈ ప్రజలపై శాపం పెట్టండి.” ");
INSERT INTO telotsa_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","అయితే బిలాము వారితో, “బాలాకు తన రాజభవనంలో ఉన్న వెండి బంగారమంతా ఇచ్చినా సరే, నా దేవుడైన యెహోవా ఆజ్ఞకు మించి ఎక్కువ గాని తక్కువ గాని చేయలేను. ");
INSERT INTO telotsa_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","మీరు రాత్రి ఇక్కడ గడపండి, యెహోవా నాకేమి చెప్తారు తెలుసుకుంటాను” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ఆ రాత్రి దేవుడు బిలాముతో, “ఈ మనుష్యులు నిన్ను పిలువడానికి వచ్చారు కాబట్టి నీవు వారితో వెళ్లు కానీ నేను చెప్పేది మాత్రమే చేయు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","మర్నాడు ఉదయం బిలాము తన గాడిదకు సీను కట్టుకుని మోయాబు అధికారులతో వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","కాని బిలాము వెళ్తునప్పుడు దేవుని కోపం రగులుకుంది. యెహోవా దూత మార్గంలో బిలామును అడ్డుకోడానికి నిలబడ్డాడు. బిలాము గాడిద మీద వెళ్తున్నాడు, అతనితో తన ఇద్దరు సేవకులు ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","యెహోవా దూత కత్తి దూసి చేతపట్టుకుని త్రోవలో నిలిచి ఉండడం చూసి గాడిద దారి విడిచి పొలంలోకి వెళ్లింది. అది మార్గంలోకి రావాలని బిలాము దాన్ని కొట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","అప్పుడు యెహోవా దూత రెండు ద్రాక్షతోటల మధ్య రెండు వైపుల గోడలు ఉన్నచోట నిలబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","యెహోవా దూతను చూసి ఆ గాడిద గోడ మీద పడి బిలాము కాలును గోడకు అదిమింది కాబట్టి అతడు గాడిదను మళ్ళీ కొట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","తర్వాత యెహోవా దూత కొంచెం ముందుకు వెళ్లి, గాడిద కుడివైపు కానీ, ఎడమవైపు కానీ తిరుగకుండునట్లు ఇరుకు స్థలంలో నిలబడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","యెహోవా దూతను చూసి గాడిద బిలాము క్రింద నేల మీద పడి ఉన్నది. బిలాము కోపంతో తన చేతికర్రతో గాడిదను కొట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","అప్పుడు యెహోవా ఆ గాడిద నోరు తెరిచారు, అది బిలాముతో మాట్లాడుతూ, “నేను నీకు ఏమి చేశానని నన్ను మూడుసార్లు కొట్టావు?” అని అన్నది. ");
INSERT INTO telotsa_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","బిలాము గాడిదకు, “నీవు నన్ను మూర్ఖునిగా ఎంచావు. నా చేతిలో ఖడ్గం ఉండి ఉంటే నిన్ను ఇప్పుడే చంపేసే వాన్ని” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","గాడిద బిలాముతో, “ఈ రోజు వరకు ప్రతిసారి స్వారీ చేసిన మీ సొంత గాడిదను నేను కాదా? ఇలా ఎప్పుడైనా చేశానా?” అని అడిగింది. “లేదు” అని అతడు అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","అప్పుడు యెహోవా బిలాము కళ్లు తెరిచారు, దూసిన ఖడ్గం చేతితో పట్టుకుని దారికి అడ్డుగా ఉన్న యెహోవా దూతను అతడు చూశాడు. బిలాము తలవంచి సాష్టాంగపడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","యెహోవా దూత, “నీవెందుకు నీ గాడిదను ఈ మూడుసార్లు కొట్టావు? నీ మార్గం నాశనకరమైనది కాబట్టి నిన్ను అడ్డుకోడానికి వచ్చాను. ");
INSERT INTO telotsa_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","మూడుసార్లు గాడిద నన్ను చూసి తొలగిపోయింది. ఒకవేళ అది తిరగకపోయి ఉంటే, ఈపాటికి నేను తప్పకుండా నిన్ను చంపేసి గాడిదను వదిలేసేవాన్ని” అని అతనితో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","బిలాము యెహోవా దూతతో, “నేను పాపం చేశాను. నన్ను ఎదుర్కోడానికి నీవు దారికి అడ్డుగా నిలబడ్డావని నేను గ్రహించలేదు. ఇప్పుడు నీకు ఇష్టం లేకపోతే నేను తిరిగి ఇంటికి వెళ్లిపోతాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","యెహోవా దూత బిలాముతో, “వారితో వెళ్లు కానీ నేను చెప్పేదే నీవు పలకాలి” అని అన్నాడు. కాబట్టి బిలాము బాలాకు అధికారులతో వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","బిలాము వస్తున్నాడని విని బాలాకు అర్నోను నది సరిహద్దులో ఉన్న మోయాబు పట్టణం పొలిమేరలో అతన్ని కలసుకోడానికి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","బాలాకు బిలాముతో, “నిన్ను త్వరగా రమ్మని చెప్పలేదా? నా దగ్గరకు ఎందుకు రాలేదు? నేను నీకు ఘనత ఇవ్వలేనా?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","“ఇప్పుడు నీ దగ్గరకు వచ్చాను కదా” అని బిలాము జవాబిచ్చాడు. “కానీ నాకిష్టమైనది నేను చెప్పలేను. దేవుడు నా నోట్లో పెట్టిందే నేను చెప్పాలి” అని బాలాకుతో అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","తర్వాత బిలాము బాలాకు వెంట కిర్యత్-హుచ్చోతుకు వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","అక్కడ బాలాకు ఎద్దులను గొర్రెలను బలి ఇచ్చాడు, బిలాముకు, అతనితో ఉన్న అధికారులకు కొంత ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","మర్నాడు ఉదయం బాలాకు బిలామును బామోత్ బయలుకు తీసుకెళ్లాడు, అక్కడినుండి ఇశ్రాయేలు శిబిరం యొక్క చివరలను చూడగలిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","బిలాము బాలాకుతో అన్నాడు, “నాకు ఇక్కడ ఏడు బలిపీఠాలు కట్టాలి, ఏడు కోడెలను, ఏడు పొట్టేళ్లను నా కోసం సిద్ధం చేయాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","బాలాకు బిలాము చెప్పినట్లు చేశాడు, వారిద్దరు ఒక కోడెను, ఇద్దరు ఒక్కో బలిపీఠం మీద ఒక కోడెను, ఒక పొట్టేలును అర్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","అప్పుడు బిలాము బాలాకుతో, “నీవు నీ దహనబలి దగ్గర ఉండు. బహుశ యెహోవా నన్ను కలుసుకోడానికి రావొచ్చు. ఆయన నాకు ఏమి బయలుపరుస్తారో అది నీకు చెప్తాను” అని అన్నాడు. తర్వాత అతడు ఖాళీ కొండపైకి వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","దేవుడు అతన్ని కలుసుకున్నారు, బిలాము, “నేను ఏడు బలిపీఠాలు సిద్ధపరచి ఒక్కొక్క బలిపీఠం మీద ఒక కోడెను, ఒక పొట్టేలును అర్పించాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","యెహోవా బిలాము నోటిలో ఒక సందేశం పెట్టి, “బాలాకు దగ్గరకు వెళ్లి ఈ మాటలు చెప్పు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","కాబట్టి బిలాము తిరిగివెళ్లి రాజు, తన మోయాబు అధికారులతో దహనబలి దగ్గర నిలిచియుండడం చూశాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","అప్పుడు బిలాము తన సందేశాన్ని ఇచ్చాడు: “బాలాకు నన్ను అరాము నుండి తీసుకువచ్చాడు, మోయాబు రాజు తూర్పు పర్వతాల నుండి తెచ్చాడు. ‘రా, నా కోసం యాకోబును శపించు’ అని అన్నాడు; ‘రా, ఇశ్రాయేలును శపించు.’ ");
INSERT INTO telotsa_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","దేవుడు శపించని వారిని నేనెలా శపించగలను? యెహోవా శపించని వారిని నేనెలా శపించగలను? ");
INSERT INTO telotsa_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ఎత్తైన కొండ శిఖరాల నుండి నేను వారిని చూడగలను, ఎత్తైన స్థలాల నుండి నేను వారిని వీక్షించగలను. విడివిడిగా నివసించే ప్రజలను నేను చూస్తున్నాను తమను తాము దేశాల్లో ఒకటిగా పరిగణించని వారు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","యాకోబు ధూళిని ఎవరు లెక్కించగలరు? ఇశ్రాయేలు ప్రజల్లో కనీసం నాలుగవ వంతు ఎవరు లెక్కించగలరు? నేను యథార్థవంతుల మరణం పొందుదును గాక, నా అంతం వారి అంతంలా ఉండును గాక!” ");
INSERT INTO telotsa_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","బాలాకు బిలాముతో, “నీవు నాకు ఏమి చేశావు? నా శత్రువులను శపిస్తావని నిన్ను తీసుకువచ్చాను, కానీ నీవు వారిని ఆశీర్వదించడం తప్ప ఏమి చేయలేదు!” ");
INSERT INTO telotsa_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","బిలాము, “యెహోవా నా నోట పెట్టిన మాటను నేను మాట్లాడకూడదా?” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","అప్పుడు బాలాకు అతనితో, “వారు కనిపించే మరో చోటికి నాతో రా; వారందరిని చూడవు కానీ, వారి శిబిరం సరిహద్దులు చూస్తావు. అక్కడినుండి నా కోసం వారిని శపించు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","బాలాకు బిలామును సోఫీము పొలములో ఉన్న పిస్గా శిఖరం మీదికి తీసుకెళ్లాడు. అక్కడ ఏడు బలిపీఠాలు కట్టి, ఒక్కో దాని మీద ఒక కోడెను, ఒక పొట్టేలును అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","బిలాము బాలాకుతో, “నీవు ఇక్కడ నీ బలిపీఠం దగ్గర ఉండు, నేను అక్కడ దేవున్ని కలుస్తాను” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","యెహోవా బిలామును కలుసుకొని, అతని నోటిలో మాట ఉంచి, “బాలాకు దగ్గరకు వెళ్లి ఈ మాటను చెప్పు” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","బిలాము తిరిగివెళ్లి రాజు, తన మోయాబు అధికారులతో దహనబలి దగ్గర నిలిచియుండడం చూశాడు. బాలాకు అతన్ని, “యెహోవా ఏమి చెప్పారు?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","అప్పుడు బిలాము తన సందేశాన్ని ఇచ్చాడు: “బాలాకు! లేచి, విను; సిప్పోరు కుమారుడా! నా మాట విను. ");
INSERT INTO telotsa_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","అబద్ధమాడడానికి దేవుడు మనుష్యుడు కాదు, మనస్సు మార్చుకోవడానికి ఆయన నరపుత్రుడు కాదు. ఆయన మాట్లాడి క్రియ చేయరా? ఆయన వాగ్దానం చేసి నెరవేర్చరా? ");
INSERT INTO telotsa_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ఆశీర్వదించమని నేను ఆజ్ఞ పొందుకున్నాను; ఆయన వారిని ఆశీర్వదించారు, దాన్ని నేను మార్చలేను. ");
INSERT INTO telotsa_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“యాకోబులో ఎటువంటి దోషం కనిపించలేదు, ఇశ్రాయేలులో ఏ చెడు కనిపించలేదు. వారి దేవుడైన యెహోవా వారికి తోడుగా ఉన్నారు; రాజు యొక్క కేక వారి మధ్య ఉన్నది. ");
INSERT INTO telotsa_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","దేవుడు వారిని ఈజిప్టు నుండి బయటకు తెచ్చారు; వారికి అడవి ఎద్దుకు ఉన్న బలం ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","యాకోబుకు వ్యతిరేకంగా ఏ భవిష్యవాణి లేదు, ఇశ్రాయేలుకు వ్యతిరేకంగా ఏ శకునాలు లేవు. ఇప్పుడు యాకోబు గురించి, ఇశ్రాయేలు గురించి, ‘దేవుడు ఏమి చేశారో చూడండి!’ ");
INSERT INTO telotsa_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ప్రజలు ఆడ సింహంలా లేస్తారు; వారు తమకు తాము సింహంలా లేస్తారు అది తన వేట మాంసాన్ని మ్రింగివేసే వరకు దాని బాధితుల రక్తం త్రాగే వరకు విశ్రాంతి తీసుకోదు” అని చెప్పబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","బాలాకు బిలాముతో, “వారిని అసలు శపించకు వారిని దీవించకు!” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","బిలాము బాలాకుతో, “యెహోవా ఏది చెప్తే నేను అదే చేయాలని నేను చెప్పలేదా?” అని జవాబిచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","అప్పుడు బాలాకు బిలాముతో, “అయితే నిన్ను మరో స్థలానికి తీసుకెళ్తాను. బహుశ అక్కడినుండి నీవు నా కోసం వారిని శపించడం దేవునికి ఇష్టం కావచ్చు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","బాలాకు, బిలామును నిర్మానుష్య స్థలానికి ఎదురుగా ఉన్న పెయోరు కొండ శిఖరం పైకి తీసుకెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","బిలాము బాలాకుతో, “నా కోసం ఇక్కడ ఏడు బలిపీఠాలు కట్టించు, ఏడు కోడెలను, ఏడు పొట్టేళ్ళను సిద్ధం చేయించు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","బాలాకు బిలాము చెప్పినట్టు చేశాడు, ప్రతి బలిపీఠం మీద కోడెను, పొట్టేలును అర్పించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ఇశ్రాయేలును ఆశీర్వదించడం యెహోవాకు ఇష్టమని బిలాము గ్రహించినప్పుడు, అతడు ఇతర సమయాల్లో చేసినట్టు భవిష్యవాణి ఆశ్రయించలేదు, కానీ తన ముఖాన్ని అరణ్యం వైపు త్రిప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ఇశ్రాయేలు వారు గోత్రాల ప్రకారం గుడారాలు వేసుకుని ఉండడం బిలాము చూసినప్పుడు, దేవుని ఆత్మ అతని మీదికి వచ్చింది, ");
INSERT INTO telotsa_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","అతడు ఈ సందేశం ఇచ్చాడు: “బెయోరు కుమారుడైన బిలాము యొక్క ప్రవచనం, స్పష్టంగా చూడగలిగే కన్ను గలవాని ప్రవచనం, ");
INSERT INTO telotsa_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","దేవుని మాటలు వినే వాని ప్రవచనం, సర్వశక్తిగల దేవుని నుండి దర్శనం చూసేవాడు, సాష్టాంగపడేవాడు, కళ్లు తెరవబడినవాడు: ");
INSERT INTO telotsa_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“ఓ యాకోబు, నీ గుడారాలు ఎంత అందంగా ఉన్నాయి, ఓ ఇశ్రాయేలు, నీ నివాస భవనాలు ఎంత రమ్యంగా ఉన్నాయి! ");
INSERT INTO telotsa_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“అవి లోయల్లా వ్యాపించాయి, నది ప్రక్కన తోటల్లా ఉన్నాయి, యెహోవా నాటిన అగరు వంటివి, జలాల ప్రక్కన దేవదారు చెట్లలా ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","వాటి బొక్కెనల నుండి నీళ్లు పారుతున్నాయి; వాటి విత్తనాలకు సమృద్ధిగా నీళ్లుంటాయి. “వారి రాజు అగగు కంటే గొప్పవాడు; వారి రాజ్యం హెచ్చింపబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“దేవుడు ఈజిప్టు నుండి వారిని బయటకు తెచ్చారు; వారు అడవి ఎద్దు బలం కలిగి ఉన్నారు. వారు శత్రు దేశాలను మ్రింగివేస్తారు వారి ఎముకలను తునాతునకలు చేస్తారు; వారి బాణాలతో వారు వారిని గుచ్చుతారు. ");
INSERT INTO telotsa_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","సింహంలా ఆడు సింహంలా వారు ముడుచుకుని పడుకుంటారు, వారిని ధైర్యంగా ఎవరు లేపగలరు? “ఓ ఇశ్రాయేలు, నిన్ను దీవించే వారు దీవించబడుదురు గాక నిన్ను శపించేవారు శపించబడుదురు గాక!” ");
INSERT INTO telotsa_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","బిలాము మీద బాలాకుకు కోపం రగులుకుంది. చేతులు చరుస్తూ అతనితో, “నా శత్రువులను శపించమని నిన్ను పిలిపిస్తే, వారిని మూడుసార్లు దీవించావు. ");
INSERT INTO telotsa_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ఇప్పుడు ఇక్కడినుండి మీ ఇంటికి పో! నిన్ను ఘనంగా సన్మానిస్తానని నేను అన్నాను కానీ యెహోవా నీకు ఆ సన్మానం లేకుండా చేశారు” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","బిలాము బాలాకుతో, “నీవు పంపిన దూతలకు నేను చెప్పలేదా, ");
INSERT INTO telotsa_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘బాలాకు తన రాజభవనంలో ఉన్న వెండి బంగారం అంతా నాకు ఇచ్చినా సరే, నా సొంతగా నేనేమి చెప్పలేను, మంచిదైనా, చెడ్డదైనా యెహోవా ఆజ్ఞ దాటి ఏమి చెప్పలేను యెహోవా చెప్పిందే నేను చెప్పాలి.’ ");
INSERT INTO telotsa_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","నేనిప్పుడు నా ప్రజల దగ్గరకు తిరిగి వెళ్తున్నాను. కానీ ముందు ఈ ప్రజలు రాబోయే రోజుల్లో మీ ప్రజలకు ఏమి చేస్తారో చెప్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","అప్పుడు బిలాము ఈ సందేశాన్ని ఇచ్చాడు: “బెయోరు కుమారుడైన బిలాము యొక్క ప్రవచనం, స్పష్టంగా చూడగలిగే కన్ను గలవాని ప్రవచనం, ");
INSERT INTO telotsa_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","దేవుని మాటలు వినే వాని ప్రవచనం, మహోన్నతుని దగ్గర నుండి తెలివి సంపాదించుకున్నవాడు, సర్వశక్తిగల వాడి నుండి దర్శనం చూసేవాడు, సాష్టాంగపడేవాడు, కళ్లు తెరవబడినవాడు: ");
INSERT INTO telotsa_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“అతన్ని చూస్తాను, కానీ ఇప్పుడు కాదు; అతన్ని కనిపెడతాను, కానీ సమీపంగా కాదు. యాకోబు నుండి నక్షత్రం వస్తుంది; ఇశ్రాయేలు నుండి రాజదండం లేస్తుంది. అతడు మోయాబు కణతలను నలగ్గొడతాడు, షేతు ప్రజల కపాలాలను చితకగొడతాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ఎదోము జయించబడుతుంది; అతని శత్రువైన శేయీరు జయించబడుతుంది. కానీ ఇశ్రాయేలు బలంగా ఎదుగుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","యాకోబు నుండి రాజ్యమేలేవాడు వస్తాడు. అతడు పట్టణంలో మిగిలిన వారిని నాశనం చేస్తాడు.” ");
INSERT INTO telotsa_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","అప్పుడు బిలాము, అమాలేకును చూసి ఈ సందేశాన్ని ఇచ్చాడు: “అమాలేకు దేశాల్లో మొదటిది, కానీ దాని అంతం పూర్తి నాశనమే!” ");
INSERT INTO telotsa_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","అతడు కెనీయులను చూసి తన సందేశాన్ని ఇచ్చాడు: “మీ నివాసస్థలం భద్రంగా ఉంది, నీ గూడు బండలో ఉంది; ");
INSERT INTO telotsa_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","అయినా కెనీయులైన మీరు నాశనమవుతారు అష్షూరు మిమ్మల్ని బందీగా పట్టుకెళ్తుంది.” ");
INSERT INTO telotsa_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","తర్వాత అతడు తన సందేశాన్ని ఇచ్చాడు: “అయ్యో, దేవుడు ఇలా చేస్తే, ఎవరు జీవించగలరు? ");
INSERT INTO telotsa_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","కుప్ర తీరం నుండి ఓడలు వస్తాయి; అవి అష్షూరును, ఏబెరును అణచివేస్తాయి, అయితే మీరు కూడా పతనమవుతారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","తర్వాత బిలాము లేచి తన ఇంటికి వెళ్లాడు, బాలాకు తన దారిన వెళ్లాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ఇశ్రాయేలు ప్రజలు షిత్తీములో ఉన్నప్పుడు వారు మోయాబు స్త్రీలతో అక్రమ లైంగిక సంబంధాలు పెట్టుకున్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","వారు తమ దేవుళ్ళకు బలి ఇవ్వడానికి వారిని ఆహ్వానించారు. ప్రజలు వాటికి అర్పించినవి తినడమే కాక, వారి దేవుళ్ళకు మొక్కారు. ");
INSERT INTO telotsa_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","కాబట్టి ఇశ్రాయేలు బయల్-పెయోరును పూజించడంలో వారితో కలిసిపోయారు యెహోవా కోపం వారిపై రగులుకుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","యెహోవా మోషేతో అన్నారు, “ఈ ప్రజల నాయకులందరిని తీసుకువచ్చి, యెహోవా ఎదుట వారిని చంపి, పట్టపగలే వారిని ప్రదర్శించు, తద్వారా యెహోవా కోపం ఇశ్రాయేలు మీద నుండి వెళ్లిపోతుంది.” ");
INSERT INTO telotsa_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","కాబట్టి మోషే ఇశ్రాయేలు న్యాయాధిపతులతో, “మీలో ప్రతి ఒక్కరు బయల్-పెయోరును పూజించిన వారితో కలిసిన ప్రతి పురుషుని చంపేయండి” అని అన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","అప్పుడే ఇశ్రాయేలీయులలో ఒకడు మిద్యాను స్త్రీని మోషే సమాజమందరి ఎదుట, ఆ శిక్షను బట్టి వారు సమావేశ గుడార ద్వారం దగ్గర ఏడుస్తున్న సమయంలో తీసుకువచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","యాజకుడైన అహరోను మనవడు, ఎలియాజరు కుమారుడైన ఫీనెహాసు ఇది చూసినప్పుడు, సమాజాన్ని వదిలి, ఒక ఈటెను పట్టుకుని, ");
INSERT INTO telotsa_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ఆ ఇశ్రాయేలీయుని వెంట అతని గుడారంలోకి వెళ్లాడు. అతన్ని ఆ స్త్రీని కలిపి ఈటెతో పొడిచాడు, ఆ ఈటె అతని శరీరంలో నుండి ఆమె కడుపులోనికి దూసుకుపోయింది. అప్పుడు ఇశ్రాయేలు మీదికి వచ్చిన తెగులు అంతరించింది; ");
INSERT INTO telotsa_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","అయితే తెగులు ద్వారా 24,000 మంది చనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“యాజకుడైన అహరోను మనవడు, ఎలియాజరు కుమారుడైన ఫీనెహాసు ఇశ్రాయేలీయుల మీద ఉన్న నా కోపాన్ని తిప్పాడు. నాలాగే అతడు నా ఘనత కోసం వారి మధ్యలో రోషం కలిగి ఉన్నాడు కాబట్టి, నా రోషాన్ని బట్టి వారిని శిక్షించకుండ ఆపివేశాను. ");
INSERT INTO telotsa_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","కాబట్టి నేను అతనితో సమాధాన ఒడంబడిక చేస్తున్నానని అతనితో చెప్పు. ");
INSERT INTO telotsa_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","అతడు అతని సంతానం నిత్య యాజకత్వ నిబంధన కలిగి ఉంటారు ఎందుకంటే తన దేవుని ఘనత కోసం రోషం కలిగి, ఇశ్రాయేలీయుల నిమిత్తం ప్రాయశ్చిత్తం చేశాడు.” ");
INSERT INTO telotsa_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","మిద్యాను స్త్రీతో పాటు చంపబడిన ఇశ్రాయేలీయుని పేరు సలూ కుమారుడైన జిమ్రీ. ఇతడు షిమ్యోను కుటుంబంలో నాయకుడు. ");
INSERT INTO telotsa_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","చంపబడిన ఆ మిద్యానీయ స్త్రీ పేరు కొజ్బీ, ఈమె మిద్యానీయ కుటుంబాలలో ఒక గోత్ర నాయకుడైన సూరు కుమార్తె. ");
INSERT INTO telotsa_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","యెహోవా మోషేతో అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“మిద్యానీయులను శత్రువులుగా భావించి వారిని చంపండి. ");
INSERT INTO telotsa_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","వారు మిమ్మల్ని శత్రువులుగా భావించి మిమ్మల్ని మోసం చేయడానికి ఉపయోగించిన వారి సహోదరి, కొజ్బీ, మిద్యానీయుల నాయకుని కుమార్తె, పెయోరులో జరిగిన సంఘటన ఫలితంగా తెగులు వచ్చినప్పుడు చంపబడింది.” ");
INSERT INTO telotsa_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","తెగులు అంతరించిన తర్వాత, యెహోవా మోషేతో యాజకుడైన అహరోను కుమారుడైన ఎలియాజరుతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ఇశ్రాయేలు సమాజమంతటిని ఇరవై సంవత్సరాలు అంతకు పైబడి వయస్సు ఉండి ఇశ్రాయేలు సైన్యంలో సేవ చేయగలవారిని కుటుంబాల ప్రకారం లెక్కించాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","కాబట్టి మోషే, యాజకుడైన ఎలియాజరు, యెరికో నుండి యొర్దాను వైపు ఉన్న మోయాబు సమతల మైదానాల్లో ఇశ్రాయేలీయుల నాయకులతో మాట్లాడుతూ, ");
INSERT INTO telotsa_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“యెహోవా మోషేకు ఆజ్ఞాపించినట్లు, ఇరవై సంవత్సరాలు అంతకు పైబడి ఉన్న పురుషులను లెక్కించండి” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ఇశ్రాయేలు జ్యేష్ఠ కుమారుడైన, రూబేను వారసులు: హనోకు ద్వార, హనోకీయుల వంశం; పల్లు ద్వార, పల్లువీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","హెస్రోను ద్వార, హెస్రోనీయుల వంశం; కర్మీ ద్వార, కర్మీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ఇవి రూబేను వంశాలు; లెక్కించబడినవారి సంఖ్య 43,730. ");
INSERT INTO telotsa_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","పల్లు కుమారుడు ఏలీయాబు, ");
INSERT INTO telotsa_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ఏలీయాబు కుమారులు నెమూయేలు, దాతాను, అబీరాము. ఈ దాతాను, అబీరాములే మోషే అహరోనులకు ఎదురు తిరిగినవారు, కోరహు అనుచరులు యెహోవాకు వ్యతిరేకంగా తిరుగుబాటు చేసినప్పుడు వారి మధ్య ఉన్న అధికారులు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","భూమి నోరు తెరచుకొని కోరహుతో పాటు వారిని మ్రింగివేసింది, అతని అనుచరులు 250 మంది మంటలో హతమయ్యారు. వారు హెచ్చరిక గుర్తుగా ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","అయితే, ఆ రోజున కోరహు కుమారులు చనిపోలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","షిమ్యోను వారసులు వారి వంశాల ప్రకారం: నెమూయేలు ద్వార, నెమూయేలీయుల వంశం; యామీను ద్వార, యామీనీయుల వంశం; యాకీను ద్వార, యాకీనీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","జెరహు ద్వార, జెరహీయుల వంశం; షావూలు ద్వార, షావూలీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ఇవి షిమ్యోను వంశాలు; లెక్కించబడినవారి సంఖ్య 22,200. ");
INSERT INTO telotsa_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","గాదు యొక్క వారసులు వారి వంశాల ప్రకారం: సెఫోను ద్వార, సెఫోనీయుల వంశం; హగ్గీ ద్వార, హగ్గీయుల వంశం; షూనీ ద్వార, షూనీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ఓజ్ని ద్వార, ఓజ్నీయుల వంశం; ఏరీ ద్వార, ఏరీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","అరోదు ద్వార, అరోదీయుల వంశం; అరేలీ ద్వార, అరేలీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ఇవి గాదు వంశాలు; లెక్కించబడినవారి సంఖ్య 40,500. ");
INSERT INTO telotsa_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","యూదా కుమారులు ఏరు ఓనాను, కానీ వారు కనాను దేశంలో చనిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","యూదా వారసులు వారి వంశాల ప్రకారం: షేలా ద్వార, షేలాహీయుల వంశం; పెరెసు ద్వార, పెరెజీయుల వంశం; జెరహు ద్వార, జెరహీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","పెరెసు యొక్క వారసులు: హెస్రోను ద్వార, హెస్రోనీయుల వంశం; హామూలు ద్వార, హామూలీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ఇవి యూదా వంశాలు; లెక్కించబడినవారి సంఖ్య 76,500. ");
INSERT INTO telotsa_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ఇశ్శాఖారు వారసులు వారి వంశాల ప్రకారం: తోలా ద్వార, తోలాహీయుల వంశం; పువా ద్వార, పువీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","యాషూబు ద్వార, యాషూబీయుల వంశం; షిమ్రోను ద్వార, షిమ్రోనీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ఇవి ఇశ్శాఖారు వంశాలు; లెక్కించబడినవారి సంఖ్య 64,300. ");
INSERT INTO telotsa_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","జెబూలూను వారసులు వారి వంశాల ప్రకారం: సెరెదు ద్వార, సెరెదీయుల వంశం; ఏలోను ద్వార, ఏలోనీయుల వంశం; యహలేలు ద్వార, యహలేలీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ఇవి జెబూలూను వంశాలు; లెక్కించబడినవారి సంఖ్య 60,500. ");
INSERT INTO telotsa_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","మనష్షే ఎఫ్రాయిం వంశాల ప్రకారం యోసేపు వారసులు: ");
INSERT INTO telotsa_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","మనష్షే వారసులు: మాకీరు ద్వార, మాకీరీయుల వంశం (మాకీరు గిలాదు యొక్క తండ్రి); గిలాదు ద్వార, గిలాదీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","గిలాదు వారుసులు: ఈజరు ద్వార, ఈజరీయుల వంశం; హెలెకు ద్వార, హెలెకీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","అశ్రీయేలు ద్వార, అశ్రీయేలీయుల వంశం; షెకెము ద్వార, షెకెమీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","షెమీదా ద్వార, షెమీదయీయుల వంశం; హెఫెరు ద్వార, హెఫెరీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(హెఫెరు కుమారుడైన సెలోఫెహాదుకు కుమారులు లేరు; అతనికి కుమార్తెలు మాత్రమే ఉన్నారు, వారి పేర్లు, మహ్లా, నోవా, హొగ్లా, మిల్కా, తిర్సా.) ");
INSERT INTO telotsa_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ఇవి మనష్షే వంశాలు; లెక్కించబడినవారి సంఖ్య 52,700. ");
INSERT INTO telotsa_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ఎఫ్రాయిం వారసులు వారి వంశాల ప్రకారం: షూతలహు ద్వార, షూతలహీయుల వంశం; బేకరు ద్వార, బేకరీయల వంశం; తహను ద్వార, తహనీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","వీరు షూతలహు వారసులు: ఏరాను ద్వార, ఏరానీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ఇవి ఎఫ్రాయిం వంశాలు; లెక్కించబడినవారి సంఖ్య 32,500. ");
INSERT INTO telotsa_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","బెన్యామీను వారసులు వారి వంశాల ప్రకారం: బేల ద్వార, బేలీయుల వంశం; అష్బేలు ద్వార, అష్బేలీయుల వంశం; అహీరాము ద్వార, అహీరామీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","షూఫాము ద్వార, షూఫామీయుల వంశం; హుఫాము ద్వార, హుఫామీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","అర్దు, నయమానుల ద్వార కలిగిన బేల వారసులు: అర్దు ద్వార, అర్దీయుల వంశం; నయమాను ద్వార, నయమానీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ఇవి బెన్యామీను వంశాలు; లెక్కించబడినవారి సంఖ్య 45,600. ");
INSERT INTO telotsa_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","దాను వారుసులు వారి వంశాల ప్రకారం: షూహాము ద్వార, షూహామీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","వారంతా షూహామీయుల వంశాలు; లెక్కించబడినవారి సంఖ్య 64,400. ");
INSERT INTO telotsa_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ఆషేరు వారసులు వారి వంశాల ప్రకారం: ఇమ్నా ద్వార, ఇమ్నీయుల వంశం; ఇష్వీ ద్వార, ఇష్వీయుల వంశం; బెరీయా ద్వార, బెరీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","బెరీయా వారసుల ద్వార వచ్చినవారు: హెబెరు ద్వార, హెబెరీయుల వంశం; మల్కీయేలు ద్వార, మల్కీయేలీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ఆషేరుకు ఒక కుమార్తె ఉంది, ఆమె పేరు శెరహు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ఇవి ఆషేరు వంశాలు; లెక్కించబడినవారి సంఖ్య 53,400. ");
INSERT INTO telotsa_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","నఫ్తాలి వారసులు వారి వంశాల ప్రకారం: యహజీయేలు ద్వార, యహజీయేలీయుల వంశం; గూనీ ద్వార, గూనీయుల వంశం; ");
INSERT INTO telotsa_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","యేజెరు ద్వార, యెజెరీయుల వంశం; షిల్లేము ద్వార, షిల్లేమీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ఇవి నఫ్తాలి వంశాలు; లెక్కించబడినవారి సంఖ్య 45,400. ");
INSERT INTO telotsa_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","లెక్కించబడిన ఇశ్రాయేలు పురుషుల మొత్తం సంఖ్య 6,01,730. ");
INSERT INTO telotsa_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“పేర్ల లెక్క సంఖ్య ప్రకారం భూమిని వారసత్వంగా కేటాయించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","పెద్ద గుంపుకు పెద్ద భూభాగం, చిన్న గుంపుకు చిన్న భూభాగం వారసత్వంగా ఇవ్వాలి; ప్రతి గుంపు దానిలో లెక్కించబడినవారి సంఖ్య ప్రకారం పొందుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","చీట్లు వేసి భూమిని పంచడం ఖచ్చితంగా చేయాలి. ప్రతి గుంపు వారి పూర్వికుల గోత్రాల పేర్ల ప్రకారం పొందుకుంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ప్రతి వారసత్వం చీట్లు వేయడం ద్వార పెద్ద, చిన్న గుంపుల మధ్య పంచాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","వంశాల ప్రకారం లెక్కించబడిన లేవీయులు: గెర్షోను ద్వార, గెర్షోనీయుల వంశం; కహాతు ద్వార, కహాతీయుల వంశం; మెరారి ద్వార మెరారీయుల వంశము. ");
INSERT INTO telotsa_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ఇవి కూడా లేవీ వంశాలు: లిబ్నీయుల వంశం, హెబ్రోనీయుల వంశం, మహలీయుల వంశం, మూషీయుల వంశం, కోరహీయుల వంశము. (కహాతు కుమారుడు అమ్రాము; ");
INSERT INTO telotsa_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","అమ్రాము భార్యపేరు యోకెబెదు, ఈమె లేవీ సంతానం, లేవీయులకు ఈజిప్టులో ఉన్నప్పుడు జన్మించింది. అమ్రాము వల్ల అహరోనును, మోషేను, వారి సహోదరి మిర్యామును కన్నది. ");
INSERT INTO telotsa_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","అహరోను నాదాబు, అబీహు, ఎలియాజరు, ఈతామారుల తండ్రి. ");
INSERT INTO telotsa_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","అయితే నాదాబు, అబీహులు, యెహోవాకు అన్యాగ్నిని అర్పించినందుకు చనిపోయారు.) ");
INSERT INTO telotsa_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","లేవీయులలో పురుషులు ఒక నెల ఆపైన వయస్సు ఉన్న వారి సంఖ్య 23,000. ఇశ్రాయేలీయులతో వారు లెక్కించబడలేదు ఎందుకంటే వారి మధ్యలో వారికి వారసత్వం ఇవ్వబడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","యెరికో దగ్గర యొర్దాను అవతలి వైపు ఉన్న మోయాబు మైదానంలో మోషే, యాజకుడైన ఎలియాజరు ద్వార లెక్కించబడిన ఇశ్రాయేలీయులు వీరు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","వీరిలో ఏ ఒక్కరైన మోషే, యాజకుడైన అహరోను సీనాయి ఎడారిలో ఇశ్రాయేలీయుల జనాభా లెక్క తీసుకున్నప్పుడు ఉన్నవారు కారు. ");
INSERT INTO telotsa_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ఎందుకంటే యెహోవా ఆ ఇశ్రాయేలీయులు అరణ్యంలో తప్పక చస్తారని చెప్పారు, యెఫున్నె కుమారుడైన కాలేబు నూను కుమారుడైన యెహోషువ తప్ప వారిలో ఏ ఒక్కరు మిగల్లేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","యోసేపు కుమారుడైన మనష్షే వంశానికి చెందిన మనష్షే కుమారుడైన మాకీరు, అతని కుమారుడు గిలాదు, అతని కుమారుడు హెఫెరు, అతని కుమారుడైన సెలోఫెహాదు కుమార్తెలు. ఆ కుమార్తెల పేర్లు మహ్లా, నోవా, హొగ్లా, మిల్కా, తిర్సా. వీరు ముందుకు వచ్చి ");
INSERT INTO telotsa_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","సమావేశ గుడార ద్వారం దగ్గర మోషే, యాజకుడైన ఎలియాజరు, నాయకులు సమాజమంతటి ఎదుట నిలబడి, ");
INSERT INTO telotsa_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“మా తండ్రి అరణ్యంలో చనిపోయాడు. అతడు యెహోవాకు విరుద్ధంగా తిరుగుబాటు చేసిన కోరహు సమూహంలో లేడు, కానీ తన సొంత పాపాన్ని బట్టి చనిపోయాడు, అతనికి కుమారులు లేరు. ");
INSERT INTO telotsa_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","కుమారులు లేనందుకు మా తండ్రి పేరు అతని వంశం నుండి తీసివేయబడాలి? మా తండ్రి బంధువుల్లో మాకు స్వాస్థ్యం ఇవ్వండి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","మోషే ఈ విషయాన్ని యెహోవా దగ్గరకు తెచ్చాడు, ");
INSERT INTO telotsa_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","సెలోఫెహాదు కుమార్తెలు చెప్పేది న్యాయమైనదే. నీవు వారికి తమ తండ్రి బంధువుల్లో వారసత్వంగా స్వాస్థ్యం ఖచ్చితంగా ఇచ్చి వారి తండ్రి వారసత్వాన్ని వారికి ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“ఇశ్రాయేలీయులతో చెప్పు, ‘ఒక మనిషి చనిపోతే, అతనికి కుమారులు లేకపోతే, అతని వారసత్వం అతని కుమార్తెకు ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ఒకవేళ అతనికి కుమార్తెలు లేకపోతే, అతని వారసత్వం అతని సహోదరులకు ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ఒకవేళ సహోదరులు లేకపోతే, వారసత్వం అతని తండ్రి సహోదరులకు ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","అతని తండ్రికి సహోదరులు లేకపోతే, తన వారసత్వం సమీప బంధువుకు ఇవ్వాలి, అతడు స్వాస్థ్యంగా పొందుకుంటాడు. ఇది ఇశ్రాయేలీయుల కోసం యెహోవా మోషేకు ఆజ్ఞాపించిన న్యాయ నియమము.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","యెహోవా మోషేతో అన్నారు, “నీవు అబారీము పర్వతం ఎక్కి నేను ఇశ్రాయేలీయులకు ఇచ్చిన దేశాన్ని చూడు. ");
INSERT INTO telotsa_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","చూసిన తర్వాత, నీవును నీ అన్న అహరోను లాగే చనిపోయి స్వజనుల దగ్గరకు చేరతావు. ");
INSERT INTO telotsa_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ఎందుకంటే, సీను ఎడారిలో సమాజం నీళ్ల దగ్గర తిరుగుబాటు చేసినప్పుడు, మీరిద్దరు వారి దృష్టిలో నన్ను పరిశుద్ధునిగా గౌరవించకుండా అవిధేయత చూపారు.” (ఈ నీళ్లు సీను అరణ్యంలో మెరీబా కాదేషు నీళ్లు.) ");
INSERT INTO telotsa_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","మోషే యెహోవాతో అన్నాడు, ");
INSERT INTO telotsa_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“సమస్త జీవులకు శ్వాసనిచ్చే దేవుడైన యెహోవా, ఈ సమాజం మీద ఒక నాయకుని నియమించాలి, ");
INSERT INTO telotsa_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","అతడు ఈ సమాజం ముందు వెళ్తూ, వస్తూ, వారిని బయటకు లోనికి నడిపిస్తూ ఉండాలి, అప్పుడు యెహోవా ప్రజలైన వీరు కాపరి లేని గొర్రెల్లా ఉండరు.” ");
INSERT INTO telotsa_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","కాబట్టి యెహోవా మోషేతో అన్నారు, “నూను కుమారుడైన యెహోషువను తీసుకో, అతనిలో నాయకత్వపు ఆత్మ ఉంది, అతని మీద నీ చేయి పెట్టు. ");
INSERT INTO telotsa_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","యాజకుడైన ఎలియాజరు సమాజమందరి సముఖంలో అతన్ని నిలబెట్టి, అధికార పూర్వకంగా నియమించు. ");
INSERT INTO telotsa_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","నీ ప్రభావంలో కొంత అతనికి ఇవ్వు, అప్పుడు ఇశ్రాయేలు సమాజమంతా అతనికి లోబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","అతన్ని యాజకుడైన ఎలియాజరు ఎదుట నిలబెట్టు, ఎలియాజరు యెహోవా సన్నిధిలో ఊరీముతో సంప్రదించి అతని కోసం చట్టాలు పొందుకోవాలి. అతని ఆజ్ఞమేరకు అతడు, ఇశ్రాయేలు సమాజమంతా బయటకు వెళ్తుంది, అతని ఆజ్ఞమేరకు వారు లోనికి వస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","యెహోవా ఆజ్ఞమేరకు మోషే చేశాడు. యెహోషువను యాజకుడైన ఎలియాజరు ముందు, సర్వసమాజం ముందు నిలబెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","తర్వాత యెహోవా మోషేకు సూచించిన ప్రకారం అతనిపై చేతులుంచి అధికార పూర్వకంగా అతన్ని నియమించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","యెహోవా మోషేతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“నీవు ఇశ్రాయేలీయులకు ఈ ఆజ్ఞలిస్తూ వారితో ఇలా చెప్పు: ‘నియమింపబడిన సమయంలో నాకు ఇష్టమైన సువాసనగా ఉండే హోమబలులు అర్పించేలా చూసుకోండి.’ ");
INSERT INTO telotsa_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","నీవు వారికి ఇలా చెప్పు: ‘ఇది మీరు యెహోవాకు సమర్పించాల్సిన హోమబలి: ప్రతిరోజు లోపం లేని ఏడాది గొర్రెపిల్లలు రెండు దహనబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ఒక గొర్రెపిల్లను ఉదయాన, మరొకదాన్ని సూర్యాస్తమయ వేళ అర్పించాలి, ");
INSERT INTO telotsa_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","దానితో పాటు ఒక ఓమెరు నాణ్యమైన పిండిని, ఒక పావు హిన్ ఒలీవనూనెతో కలిపి భోజనార్పణగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ఇది సీనాయి కొండపై నియమించబడిన క్రమం తప్పకుండ అర్పించే దహనబలి, యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","దానితో పాటు ఒక పావు హిన్ పులియబెట్టిన పానీయాన్ని పానార్పణగా ప్రతి గొర్రెపిల్లతో పాటు అర్పించాలి. పరిశుద్ధాలయం దగ్గర యెహోవాకు పానార్పణ పోయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","సాయంకాలం రెండవ గొర్రెపిల్లతో కలిపి ఉదయకాలం అర్పించినట్లే భోజనార్పణను పానార్పణను అర్పించాలి. ఇది యెహోవాకు ఇష్టమైన సువాసనగల హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘సబ్బాతు దినాన, లోపం లేని ఒక ఏడాది వయస్సు ఉన్న రెండు గొర్రెపిల్లలను, వాటితో పాటు పానార్పణం, భోజనార్పణగా ఒలీవనూనెతో కలిపిన రెండు ఓమెర్ల నాణ్యమైన పిండి అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ప్రతి సబ్బాతుకు క్రమం తప్పకుండ అర్పించే దహనబలి, పానార్పణంతో పాటు ఈ దహనబలి కూడా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘ప్రతి నెల మొదటి రోజు యెహోవాకు లోపం లేని రెండు కోడెలు, ఒక పొట్టేలు, యేడు ఏడాది మగ గొర్రెపిల్లలు దహనబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ప్రతి కోడెతో పాటు ఒలీవనూనె కలిపిన మూడు ఓమెర్ల నాణ్యమైన పిండితో భోజనార్పణ ఉండాలి; పొట్టేలుతో పాటు, నూనె కలిపిన రెండు ఓమెర్ల నాణ్యమైన పిండి భోజనార్పణగా ఉండాలి; ");
INSERT INTO telotsa_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","అలాగే ప్రతి గొర్రెపిల్లతో పాటు, నూనె కలిపిన ఒక ఓమెరు నాణ్యమైన పిండిని భోజనార్పణగా సమర్పించాలి. ఇది దహనబలి, యెహోవాకు ఇష్టమైన సువాసన కలిగించే హోమబలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ప్రతి కోడెతో పాటు పానార్పణగా అర హిన్ ద్రాక్షరసం ఉండాలి; పొట్టేలుతో పాటు, హిన్‌లో మూడవ వంతు ద్రాక్షరసం; ప్రతి గొర్రెపిల్లతో పాటు ఒక పావు హిన్ ద్రాక్షరసం అర్పించాలి. సంవత్సరంలో ప్రతి అమావాస్యకు అర్పించాల్సిన దహనబలి ఇది. ");
INSERT INTO telotsa_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","క్రమం తప్పకుండ అర్పించే దహనబలి, దాని పానార్పణంతో పాటు, యెహోవాకు పాపపరిహారబలిగా ఒక మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘మొదటి నెల పద్నాలుగవ రోజు యెహోవా యొక్క పస్కా పండుగ ఆచరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ఆ నెల పదిహేనవ రోజు ఒక పండుగ జరగాలి; ఏడు రోజులు పులియని రొట్టెలు తినాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","మొదటి రోజు పరిశుద్ధ సభను నిర్వహించాలి, పనులేవీ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","యెహోవాకు హోమబలిగా లోపం లేని రెండు కోడెలు, ఒక పొట్టేలు, ఏడాది వయస్సున్న ఏడు మగ గొర్రెపిల్లలు దహనబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ప్రతి కోడెతో పాటు ఒలీవనూనెతో కలిపిన మూడు ఓమెర్ల నాణ్యమైన పిండిని భోజనార్పణగా అర్పించాలి; పొట్టేలుతో, రెండు ఓమెర్లు; ");
INSERT INTO telotsa_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ఏడు గొర్రెపిల్లలలో ఒక్కో దానితో ఒక్కో ఓమెరు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","మీ ప్రాయశ్చిత్తం కోసం ఒక మేకపోతును పాపపరిహారబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ఇవన్నీ ప్రతి ఉదయం దహన బలులతో పాటు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ఈ విధంగా ఏడు రోజులపాటు యెహోవాకు ఇష్టమైన సువాసనగా ఉండే ఆహార అర్పణను అర్పించాలి; ప్రతిరోజు అర్పించే దహనబలి దాని పానార్పణంతో పాటు దీనిని అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ఏడవ రోజు పరిశుద్ధ సభను నిర్వహించాలి, జీవనోపాధి కోసమైన పనులేవీ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘ప్రథమ ఫలాల రోజున, వారాల పండుగలో యెహోవాకు క్రొత్త ధాన్యంతో భోజనార్పణ అర్పించినప్పుడు పరిశుద్ధ సభ ఏర్పాటు చేయాలి, జీవనోపాధి కోసమైన పనులేవీ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","రెండు కోడెలు, ఒక పొట్టేలు, ఏడు ఏడాది మగ గొర్రెపిల్లలను యెహోవాకు ఇష్టమైన సువాసన కలిగించే దహనబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ప్రతి కోడెతో పాటు భోజనార్పణగా ఒలీవనూనె కలిపిన మూడు ఓమెర్ల నాణ్యమైన పిండి; పొట్టేలుతో రెండు ఓమెర్లు; ");
INSERT INTO telotsa_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ఏడు గొర్రెపిల్లలలో ఒక్కో దానితో ఒక్కో ఓమెరు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","దానితో పాటు ప్రాయశ్చిత్తం కోసం ఒక మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","దహనబలులు, ఆహార అర్పణలతో పాటు, వీటిని వీటి పానార్పణాలతో కలిపి అర్పించాలి. అర్పణ కోసం తెచ్చే ప్రతి జంతువు లోపం లేనిదై ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘ఏడవ నెల మొదటి రోజు పరిశుద్ధ సభను ఏర్పాటు చేయాలి, జీవనోపాధి కోసమైన పనులేవీ చేయకూడదు. ఆ రోజు మీరు బూరల ధ్వని చేసే రోజు. ");
INSERT INTO telotsa_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","యెహోవాకు ఇష్టమైన సువాసనగా లోపం లేని ఒక కోడెను, ఒక పొట్టేలును, ఏడాది వయస్సున్న ఏడు మగ గొర్రెపిల్లలను దహనబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","కోడెతో పాటు భోజనార్పణగా ఒలీవనూనెతో కలిపిన మూడు ఓమెర్ల నాణ్యమైన పిండి తేవాలి; పొట్టేలుతో రెండు ఓమెర్లు; ");
INSERT INTO telotsa_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ఏడు గొర్రెపిల్లలలో ప్రతి దానితో ఒక ఓమెరు నాణ్యమైన పిండి అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","అంతేకాక మీకు ప్రాయశ్చిత్తం చేయడానికి పాపపరిహారబలిగా మేకపోతును కూడా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ఇవి నిర్దేశించబడిన ప్రతి నెలనెలా అనుదినం దహనబలులకు అధనంగా వాటి భోజనార్పణలు, పానార్పణలు. ఇవి యెహోవాకు ఇష్టమైన సువాసన కలిగించే హోమబలులుగా తేవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘ఏడవ నెల పదవ రోజున పరిశుద్ధ సభగా కూడుకోవాలి. మీరు ఉపవాసముండాలి ఏ పని చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","యెహోవాకు ఇష్టమైన సువాసన కలిగించే దహనబలిగా లోపం లేని ఒక కోడెను, ఒక పొట్టేలును, ఏడాది వయస్సున్న ఏడు గొర్రెపిల్లలను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","కోడెతో పాటు భోజనార్పణగా నూనెతో కలిపిన మూడు ఓమెర్ల నాణ్యమైన పిండి తేవాలి; పొట్టేలుతో రెండు ఓమెర్లు; ");
INSERT INTO telotsa_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ఏడు గొర్రెపిల్లలలో ప్రతి దానితో ఒక ఓమెరు నాణ్యమైన పిండి అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","అంతేకాక ప్రాయశ్చిత్తం కొరకైన పాపపరిహారబలి, క్రమంగా అర్పించే దహనబలి, భోజనార్పణ, వారి పానార్పణలతో పాటు పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘ఏడవ నెల పదిహేనవ రోజున పరిశుద్ధ సభగా కూడుకోవాలి, జీవనోపాధి కోసమైన పనులేవీ చేయకూడదు. యెహోవా కోసం ఏడు రోజులు పండుగ ఆచరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","యెహోవాకు ఇష్టమైన సువాసన కలిగించే దహనబలిగా లోపం లేని పదమూడు కోడెలను, రెండు పొట్టేళ్లను, ఏడాది వయస్సున్న పద్నాలుగు మగ గొర్రెపిల్లలను హోమబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","పదమూడు కోడెల్లో ప్రతి దానితో పాటు భోజనార్పణగా నూనెతో కలిపిన మూడు ఓమెర్ల పిండి తేవాలి; రెండు పొట్టేళ్లలో ఒక్కో దానితో రెండు ఓమెర్ల నాణ్యమైన పిండి; ");
INSERT INTO telotsa_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","పద్నాలుగు గొర్రెపిల్లలలో ప్రతి దానితో ఒక ఓమెరు నాణ్యమైన పిండి అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","అంతేకాక, నిత్య దహనబలి, భోజనార్పణ, పానార్పణలతో పాటు పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘రెండవ రోజున లోపం లేని పన్నెండు కోడెలను, రెండు పొట్టేళ్లను, ఏడాది వయస్సున్న పద్నాలుగు మగ గొర్రెపిల్లలను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","కోడెలు, పొట్టేళ్లు, గొర్రెపిల్లలతో పాటు సూచించబడిన సంఖ్య ప్రకారం భోజనార్పణలు, పానార్పణలు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","అంతేకాక, ప్రతిరోజు దహనబలి, భోజనార్పణ, పానార్పణలతో పాటు, పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘మూడవ రోజు లోపం లేని పదకొండు కోడెలను, రెండు పొట్టేళ్లను, ఏడాది వయస్సున్న పద్నాలుగు మగ గొర్రెపిల్లలను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","కోడెలు, పొట్టేళ్లు, గొర్రెపిల్లలతో పాటు సూచించబడిన సంఖ్య ప్రకారం భోజనార్పణలు, పానార్పణలు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","అంతేకాక, ప్రతిరోజు దహనబలి, భోజనార్పణ, పానార్పణలతో పాటు, పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘నాలుగవ రోజున లోపం లేని పది కోడెలను, రెండు పొట్టేళ్లను, ఏడాది వయస్సున్న పద్నాలుగు మగ గొర్రెపిల్లలను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","కోడెలు, పొట్టేళ్లు, గొర్రెపిల్లలతో పాటు సూచించబడిన సంఖ్య ప్రకారం భోజనార్పణలు, పానార్పణలు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","అంతేకాక, నిత్య దహనబలి, భోజనార్పణ, పానార్పణలతో పాటు, పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘అయిదవ రోజు లోపం లేని తొమ్మిది కోడెలను, రెండు పొట్టేళ్లను, ఏడాది వయస్సున్న పద్నాలుగు మగ గొర్రెపిల్లలను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","కోడెలు, పొట్టేళ్లు, గొర్రెపిల్లలతో పాటు సూచించబడిన సంఖ్య ప్రకారం భోజనార్పణలు, పానార్పణలు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","అంతేకాక, నిత్య దహనబలి, భోజనార్పణ, పానార్పణలతో పాటు, పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘ఆరవరోజు లోపం లేని ఎనిమిది కోడెలను, రెండు పొట్టేళ్లను, ఏడాది వయస్సున్న పద్నాలుగు మగ గొర్రెపిల్లలను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","కోడెలు, పొట్టేళ్లు, గొర్రెపిల్లలతో పాటు సూచించబడిన సంఖ్య ప్రకారం భోజనార్పణలు, పానార్పణలు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","అంతేకాక, నిత్య దహనబలి, భోజనార్పణ, పానార్పణలతో పాటు, పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘ఏడవ రోజున లోపం లేని ఏడు కోడెలను, రెండు పొట్టేళ్లను, ఏడాది వయస్సున్న పద్నాలుగు మగ గొర్రెపిల్లలను అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","కోడెలు, పొట్టేళ్లు, గొర్రెపిల్లలతో పాటు సూచించబడిన సంఖ్య ప్రకారం భోజనార్పణలు, పానార్పణలు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","అంతేకాక, నిత్య దహనబలి, భోజనార్పణ, పానార్పణలతో పాటు, పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘ఎనిమిదవ రోజున ప్రత్యేక సభగా కూడుకోవాలి, పని ఏదీ చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","యెహోవాకు ఇష్టమైన సువాసన కలిగించే దహనబలిగా లోపం లేని ఒక కోడెను, ఒక పొట్టేలును, ఏడాది వయస్సున్న ఏడు మగ గొర్రెపిల్లలను హోమబలిగా అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","కోడె, పొట్టేలు గొర్రెపిల్లలతో పాటు సూచించబడిన సంఖ్య ప్రకారం భోజనార్పణలు, పానార్పణలు అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","అంతేకాక, నిత్య దహనబలి, భోజనార్పణ, పానార్పణలతో పాటు, పాపపరిహారబలిగా మేకపోతును అర్పించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘మీ మ్రొక్కుబళ్ళు, స్వేచ్ఛార్పణలతో పాటు వీటిని నియమించబడిన పండుగల్లో యెహోవాకు అర్పించాలి: మీ దహనబలులు, భోజనార్పణలు, పానార్పణలు, సమాధానబలులు.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","యెహోవా తనకు ఆజ్ఞాపించినదంతా మోషే ఇశ్రాయేలీయులకు తెలియజేశాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","మోషే ఇశ్రాయేలు గోత్ర పెద్దలతో ఇలా చెప్పాడు: “యెహోవా ఆజ్ఞాపించింది ఇదే: ");
INSERT INTO telotsa_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ఒక వ్యక్తి యెహోవాకు మ్రొక్కుబడి చేస్తే లేదా ప్రతిజ్ఞ ద్వారా ప్రమాణం చేస్తే, ఆ వ్యక్తి మాట తప్పకుండా, తాను చెప్పినదంతా చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ఒక యువతి తండ్రి ఇంట ఉన్నప్పుడు యెహోవాకు మ్రొక్కుబడి చేస్తే లేదా ప్రతిజ్ఞ చేస్తే, ");
INSERT INTO telotsa_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","తన తండ్రి దాన్ని గురించి వినిన తర్వాత తనను ఏమి అనకపోతే అప్పుడు ఆ యువతి మ్రొక్కుబళ్ళు లేదా తాను చేసిన ప్రతి ప్రతిజ్ఞ నిలుస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","అయితే, తన తండ్రి దాని గురించి విని ఒప్పుకోకపోతే, అప్పుడు ఆ యువతి చేసిన మ్రొక్కుబళ్ళు లేదా ప్రతిజ్ఞలు ఏవి కూడా నిలువవు; తన తండ్రి ఒప్పుకోలేదు కాబట్టి యెహోవా ఆమెను క్షమిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ఆమె మ్రొక్కుబడి చేసుకున్న తర్వాత లేదా అవివేకంగా ప్రమాణం చేసిన తర్వాత ఆమె పెళ్ళి చేసుకుంటే, ");
INSERT INTO telotsa_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ఆమె భర్తకు ఈ సంగతి తెలుసుకుని అతడు మౌనంగా ఉంటే ఆమె మ్రొక్కుబళ్ళు లేదా ప్రతిజ్ఞలు నిలుస్తాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","కానీ ఆమె భర్త ఈ సంగతి తెలుసుకుని, అతడు ఆ మ్రొక్కుబడిని లేదా ఆమె అవివేకంగా చేసిన ప్రమాణాన్ని కానీ ఒప్పుకోక రద్దు చేస్తే యెహోవా ఆమెను క్షమిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“విధవరాలు లేదా విడాకులు తీసుకున్న స్త్రీ చేసే మ్రొక్కుబడి కానీ ప్రమాణం తప్పనిసరిగా చెల్లించాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ఒక స్త్రీ తన భర్తతో నివసిస్తూ మ్రొక్కుబడి చేస్తే లేదా ప్రతిజ్ఞ చేస్తే, ");
INSERT INTO telotsa_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","తన భర్త దాన్ని గురించి వినిన తర్వాత తనను ఏమి అనకపోతే అప్పుడు ఆ యువతి మ్రొక్కుబళ్ళు లేదా తాను చేసిన ప్రతి ప్రతిజ్ఞ నిలుస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","కానీ ఆమె భర్త వాటి గురించి విన్నప్పుడు వాటిని రద్దు చేస్తే, అప్పుడు ఆమె చేసిన మ్రొక్కుబళ్ళు లేదా తన పెదవులతో చేసిన ప్రమాణాలు ఏవి కూడా నిలువవు, యెహోవా ఆమెను క్షమిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","స్త్రీ తాను ఉపవాసం ఉంటానని చేసుకున్న మ్రొక్కుబడి లేదా ప్రతిజ్ఞను ఆమె భర్త ఒప్పుకోవచ్చు లేదా రద్దు చేయవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","కానీ ఆమె భర్త కొన్ని రోజుల వరకు కూడా ఏమి అనకుండా ఉంటే, అప్పుడు ఆమె చేసిన మ్రొక్కుబళ్ళు లేదా ప్రతిజ్ఞలు ఒప్పుకుంటున్నాడు. వాటి గురించి విన్నప్పుడు మౌనంగా ఉండడం ద్వారా అతడు వాటిని అంగీకరించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","అయితే అతడు వినిన కొద్ది కాలం తర్వాత వాటిని రద్దు చేస్తే అతడు చేసిన తప్పుకు ప్రతిఫలం భరించాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ఇవి భార్యా భర్తల సంబంధం, యవ్వన కుమార్తె తన తండ్రి ఇంట్లో ఉన్నప్పుడు తండ్రికి తనకు మధ్య ఉండవలసిన సంబంధం గురించి యెహోవా మోషేకు ఇచ్చిన నియమాలు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","యెహోవా మోషేతో మాట్లాడుతూ, ");
INSERT INTO telotsa_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ఇశ్రాయేలీయుల కోసం మిద్యానీయుల మీద నీవు ప్రతీకారం తీర్చుకో. ఆ తర్వాత నీవు నీ స్వజనుల దగ్గరకు చేరతావు.” ");
INSERT INTO telotsa_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","కాబట్టి మోషే ప్రజలతో, “మీలో కొందరు యుద్ధానికి సిద్ధపడి మిద్యానీయుల మీదికి వెళ్లి యెహోవా వారి మీద తీర్చుకోవాలనుకున్న ప్రతీకారాన్ని తీర్చుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ఇశ్రాయేలు యొక్క ప్రతి గోత్రం నుండి వేయిమంది పురుషులను యుద్ధానికి పంపండి” అని చెప్పాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","కాబట్టి ఇశ్రాయేలు వంశాల నుండి పన్నెండువేలమంది పురుషులు ఆయుధాలతో యుద్ధం కోసం సిద్ధపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","మోషే వారిని యుద్ధానికి పంపాడు, ప్రతి గోత్రం నుండి వేయిమందిని పంపాడు. యాజకుడైన ఎలియాజరు కుమారుడైన ఫీనెహాసు, తనతో పాటు పరిశుద్ధాలయం నుండి పరికరాలు సంకేతం ఇవ్వడానికి బూరలు తీసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం మిద్యానుతో వారు పోరాడారు, ప్రతి మగవాన్ని హతం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","చచ్చినవారిలో అయిదుగురు మిద్యాను రాజులైన ఎవీ, రేకెము, సూరు, హూరు, రేబ. వారు బెయోరు కుమారుడైన బిలామును కూడా ఖడ్గంతో చంపేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ఇశ్రాయేలీయులు మిద్యానీయుల స్త్రీలను, పిల్లలను బందీగా తీసుకుని వారి పశువులను, మందలను, వారి ఆస్తిని దోచుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","వారు మిద్యానీయులు నివసించే పట్టణాలన్ని, వారి శిబిరాలతో, తగలబెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","వారు తీసుకున్న దోపుడుసొమ్మును, కొల్లగొట్టిన వాటిని, మనుష్యులు, పశువులతో సహా, ");
INSERT INTO telotsa_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","బందీలను, కొల్లగొట్టిన వాటిని, దోపుడుసొమ్మును తీసుకువచ్చారు యెరికో దగ్గర యొర్దాను అవతలి వైపు ఉన్న మోయాబు సమతల మైదానంలో ఉన్న మోషే, యాజకుడైన ఎలియాజరు ఇశ్రాయేలు సమాజం దగ్గరకు తీసుకువచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","మోషే, యాజకుడైన ఎలియాజరు సమాజ నాయకులు వారిని కలుసుకోడానికి శిబిరం బయటకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","మోషే సైన్య అధికారులు అనగా, యుద్ధం నుండి తిరిగివచ్చిన సహస్రాధిపతులు శతాధిపతులపై కోప్పడ్డాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","“స్త్రీలందరిని మీరు బ్రతకనిచ్చారా?” అని మోషే వారిని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","“వీరు బిలాము సలహా ప్రకారం పెయోరు సంఘటనలో ఇశ్రాయేలీయులు యెహోవా పట్ల నమ్మకద్రోహులుగా ఉండడానికి పురికొల్పినవారు, వీరి మూలంగా యెహోవా ప్రజలు తెగులు ద్వారా మొత్తబడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ఇప్పుడు అబ్బాయిలందరిని చంపండి. స్త్రీలలో పురుషులతో లైంగిక సంబంధం కలిగినవారిని చంపండి, ");
INSERT INTO telotsa_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","కానీ కన్యగా ఉన్న ప్రతి అమ్మాయిని మీ కోసం బ్రతకనివ్వండి. ");
INSERT INTO telotsa_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“ఎవరైనా ఎవరినైన చంపినా, లేదా చంపబడిన వారిని తాకినా, తాకినవారు ఏడు రోజులు శిబిరం బయట ఉండాలి. మూడవ రోజున ఏడవ రోజున మిమ్మల్ని మీరు శుద్ధి చేసుకోవాలి, మీ బందీలను కూడా శుద్ధి చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","మీ బట్టలను తోలుతో, మేక వెంట్రుకలతో, చెక్కతో చేయబడిన ప్రతీ వస్తువును శుద్ధి చేసుకోవాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","అప్పుడు యాజకుడైన ఎలియాజరు యుద్ధానికి వెళ్లిన సైనికులతో, “యెహోవా మోషేకు ఇచ్చిన నియమం ఇది: ");
INSERT INTO telotsa_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","బంగారం, వెండి, ఇత్తడి, ఇనుము, తగరం, సీసం, ");
INSERT INTO telotsa_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","అగ్నిని తట్టుకోగలిగిన దేనినైనా అగ్నిలో వేయాలి, ఆపై అది శుద్ధి అవుతుంది. కానీ అది కూడా శుద్ధి జలంతో శుద్ధి చేయబడాలి. అలాగే అగ్నిని తట్టుకోలేని దానిని ఆ నీటిలో వేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ఏడవ రోజు మీరు బట్టలు ఉతుక్కోండి, మీరు శుద్ధులవుతారు. ఆ తర్వాత శిబిరంలోకి రావచ్చు.” ");
INSERT INTO telotsa_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","యెహోవా మోషేతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“నీవూ, యాజకుడైన ఎలియాజరు, సమాజం యొక్క కుటంబ యజమానులు, చెరపట్టబడిన మనుష్యులందరిని, జంతువులన్నిటిని లెక్కబెట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ఆ కొల్లగొట్టిన వాటిని యుద్ధంలో పాల్గొన్న సైనికులకు మిగితా సమాజానికి సమానంగా పంచాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","యుద్ధంలో పోరాడిన సైనికుల భాగం నుండి, ప్రతి అయిదువందల నుండి అనగా మనుష్యులైనా, పశువులైనా, గాడిదలైనా లేదా గొర్రెలైనా సరే ఒకరిని, ఒకదాన్ని యెహోవాకు పన్నుగా వేరు చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ఈ పన్ను వారి భాగం నుండి తీసుకుని యాజకుడైన ఎలియాజరుకు యెహోవా భాగంగా ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ఇశ్రాయేలీయుల మిగతా సగం వాటా నుండి, మనుష్యులైనా, పశువులైనా, గాడిదలైనా, గొర్రెలైనా, వీటిలో ఏవైనా సరే, ప్రతి 50 నుండి ఒకటి తీసుకుని, యెహోవా సమావేశ గుడారాన్ని చూసుకునే బాధ్యత కలిగిన లేవీయులకు ఇవ్వాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","కాబట్టి మోషే యాజకుడైన ఎలియాజరు యెహోవాకు మోషేకు ఆజ్ఞాపించిన ప్రకారం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","సైనికులు తీసుకున్న కొల్లగొట్టిన వాటిలో మిగిలి ఉన్న దోపుడుసొమ్ము 6,75,000 గొర్రెలు, 72,000 పశువులు, 61,000 గాడిదలు, 32,000 మంది పురుషులతో పడుకొనని కన్యలు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ఇది యుద్ధంలో పోరాడిన వారి సగం వాటా: 3,37,500 గొర్రెలు ");
INSERT INTO telotsa_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","వీటిలో యెహోవాకు ఇచ్చినవి 675; ");
INSERT INTO telotsa_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 పశువులు, వీటిలో యెహోవాకు ఇచ్చినవి 72; ");
INSERT INTO telotsa_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 గాడిదలు, వీటిలో యెహోవాకు ఇచ్చినవి 61; ");
INSERT INTO telotsa_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 మంది మనుష్యులు, వీరిలో యెహోవాకు ప్రత్యేకింపబడినవారు 32. ");
INSERT INTO telotsa_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం, మోషే యాజకుడైన ఎలియాజరుకు యెహోవా భాగంగా ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","సైనికుల భాగం నుండి ఇశ్రాయేలు సమాజం కోసం మోషే వేరుగా ఉంచిన సగభాగం ఇది: 3,37,500 గొర్రెలు, 36,000 పశువులు, 30,500 గాడిదలు, 16,000 మంది మనుష్యులు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం మోషే, ఇశ్రాయేలీయుల సగభాగంలో నుండి, ప్రతి యాభైమంది మనుష్యుల్లో నుండి ఒకరిని, జంతువుల్లో నుండి ఒకదాన్ని ఎంచుకుని, యెహోవా సమావేశ గుడారాన్ని చూసుకునే బాధ్యత కలిగిన లేవీయులకు ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","తర్వాత సైన్యానికి అధికారులుగా ఉన్న సహస్రాధిపతులు, శతాధిపతులు మోషే దగ్గరకు వచ్చి, ");
INSERT INTO telotsa_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","మోషేతో, “మేము సైనికుల లెక్క చూశాము. మాలో ఏ ఒక్కరు కూడా తప్పిపోలేదు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","కాబట్టి యెహోవా సన్నిధిలో మాకు ప్రాయశ్చిత్తం కలగాలని మేము భుజ కడియాలు, కడియాలు, ఉంగరాలు, చెవిపోగులు, మెడ హారాలు యెహోవాకు అర్పణగా తెచ్చాము” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","మోషే, యాజకుడైన ఎలియాజరు వారి నుండి బంగారు ఆభరణాలు తీసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","సహస్రాధిపతుల నుండి, శతాధిపతుల నుండి వారు తీసుకుని, యెహోవాకు అర్పణగా అర్పించిన బంగారం మొత్తం 16,750 షెకెళ్ళు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ప్రతి సైనికుడు తన కోసం తాను దోపుడుసొమ్మును తీసుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","సహస్రాధిపతుల శతాధిపతుల దగ్గర నుండి మోషే, యాజకుడైన ఎలియాజరు ఆ బంగారం తీసుకుని ఇశ్రాయేలీయులకు యెహోవా ఎదుట జ్ఞాపకార్థంగా సమావేశ గుడారంలో ఉంచారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","చాలా ఎక్కువ పశువుల మందలు కలిగిన రూబేనీయులు, గాదీయులు తమ పశువులకు యాజెరు, గిలాదు ప్రాంతాలు తగిన స్థలాలని చూశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","కాబట్టి వారు మోషే, యాజకుడైన ఎలియాజరు, సమాజ నాయకుల దగ్గరకు వచ్చి, ");
INSERT INTO telotsa_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“అతారోతు, దీబోను, యాజెరు, నిమ్రా, హెష్బోను, ఎల్యాలెహు, షెబాము, నెబో, బెయోను ప్రాంతాలు, ");
INSERT INTO telotsa_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ఇశ్రాయేలీయుల సమాజం ఎదుట యెహోవా జయించిన స్థలం పశువులకు తగిన స్థలాలు, మీ సేవకులమైన మాకు పశువులు ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","మీరు మా పట్ల దయ చూపిస్తే ఈ స్థలం మీ సేవకులమైన మాకు స్వాస్థ్యంగా ఇవ్వండి. మమ్మల్ని యొర్దాను అవతలికి దాటించకండి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","మోషే రూబేనీయులతో, గాదీయులతో, “మీరు ఇక్కడ కూర్చుని ఉండగా మీ తోటి ఇశ్రాయేలీయులు యుద్ధానికి వెళ్లాలా?” అని అడిగాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","“యెహోవా ఇచ్చిన దేశానికి ప్రయాణమై వెళ్తున్న ఇశ్రాయేలీయులను ఎందుకు నిరాశపరుస్తారు? ");
INSERT INTO telotsa_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","మీ తండ్రులను కాదేషు బర్నియాకు స్థలాన్ని చూసి రమ్మని పంపితే వారు ఇలాగే చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","వారు ఎష్కోలు లోయలోకి వెళ్లి తిరిగివచ్చి, యెహోవా వారికిచ్చిన వాగ్దాన భూమికి ప్రవేశించకుండా ఇశ్రాయేలీయులను నిరాశ పరిచారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ఆ రోజు యెహోవా కోపం వారిపై రగులుకొని, ఆయన ఇలా ప్రమాణం చేశారు: ");
INSERT INTO telotsa_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘వారు హృదయమంతటితో నన్ను వెంబడించలేదు కాబట్టి, ఈజిప్టు నుండి వచ్చిన వారిలో ఇరవై సంవత్సరాలు ఆ పైబడి వయస్సు ఉన్నవారు ఎవ్వరూ అబ్రాహాము, ఇస్సాకు, యాకోబులకు వాగ్దానం చేసిన ఈ దేశాన్ని చూడరు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","కెనిజ్జీయుడైన యెఫున్నె కుమారుడైన కాలేబు నూను కుమారుడైన యెహోషువ మాత్రమే వెళ్తారు, ఎందుకంటే వీరు యెహోవాను హృదయమంతటితో వెంబడించారు.’ ");
INSERT INTO telotsa_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","యెహోవా కోపం ఇశ్రాయేలు మీద రగులుకుంది. ఆయన వారు అరణ్యంలో నలభై సంవత్సరాలు తిరిగేలా చేశారు, ఆయన దృష్టి నుండి చెడు చేసిన వారందరు చనిపోయే వరకు అలా చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“ఇక్కడ మీరు, పాపుల సంతానం, మీ తండ్రుల స్థానంలో నిలబడి, యెహోవాకు ఇశ్రాయేలుపై మరింత కోపం తెప్పిస్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","మీరు ఆయనను వెంబడించకుండా తప్పుకుంటే, ఆయన మరలా ప్రజలందరినీ అరణ్యంలో వదిలేస్తారు వారి నాశనానికి మీరే కారణం అవుతారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","వారు అతని దగ్గరకు వచ్చి, “మేము ఇక్కడ మందలకు కావలసిన దొడ్లు మా స్త్రీలు, పిల్లలకు పట్టణాలు కట్టుకుంటాము. ");
INSERT INTO telotsa_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","కానీ మేము యుద్ధానికి మమ్మల్ని మేము సిద్ధంగా ఉంచుకుని ఇశ్రాయేలీయులకు ముందుగా వెళ్తూ వారు వారి స్థలాలకు చేరేవరకు ఉంటాము. ఆ సమయంలో మా స్త్రీలు, పిల్లలు కోటగోడలు గల పట్టణాల్లో ఉంటూ, ప్రాంత నివాసులకు కాపుదలగా ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ఇశ్రాయేలీయులలో ప్రతి ఒక్కరు తమ వారసత్వం స్వాధీనం చేసుకునేవరకు మా గృహాలకు వెళ్లము. ");
INSERT INTO telotsa_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","యొర్దానుకు అవతల వారసత్వం పొందుకోము ఎందుకంటే మా వారసత్వం యొర్దాను తూర్పు ప్రదేశంలో ఉంది.” ");
INSERT INTO telotsa_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","అప్పుడు మోషే వారితో, “మీరు ఇలా చేస్తే అంటే మీరు యుద్ధం కోసం యెహోవా ఎదుట సిద్ధంగా ఉంటే, ");
INSERT INTO telotsa_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ఆయుధాలు ధరించిన మీరందరూ యొర్దాను దాటి యెహోవా తన శత్రువులను తన ఎదుట నుండి తరిమికొట్టే వరకు యొర్దానును దాటితే, ");
INSERT INTO telotsa_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","దేశం యెహోవా ఎదుట వశపరచబడినప్పుడు, మీరు తిరిగివచ్చి యెహోవాకు, ఇశ్రాయేలుకు మీ బాధ్యత నుండి విముక్తి పొందవచ్చు. ఈ దేశం యెహోవా ఎదుట మీకు స్వాస్థ్యంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“కానీ మీరు ఇలా చేయకపోతే, యెహోవాకు విరోధంగా పాపం చేసినవారవుతారు; మీ పాపం మిమ్మల్ని వెంటాడుతుందని ఖచ్చితంగా నమ్మవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ఇప్పుడు మీ స్త్రీల కోసం, పిల్లల కోసం పట్టణాలు, మీ మందల దొడ్లు నిర్మించుకోండి, కానీ మీరు చెప్పినదంతా చేయండి.” ");
INSERT INTO telotsa_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","గాదీయులు, రూబేనీయులు మోషేతో ఇలా అన్నారు, “మీ సేవకులైన మేము మా ప్రభువా ఆజ్ఞాపించినట్లే చేస్తాము. ");
INSERT INTO telotsa_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","మా పిల్లలు, మా భార్యలు, మా మందలు, పశువులు ఇక్కడే గిలాదు పట్టణాల్లో ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","అయితే, యుద్ధానికి సిద్ధపడిన మీ సేవకుల మందరం మా ప్రభువా చెప్పినట్లు, యెహోవా ఎదుట యుద్ధానికి యొర్దానును దాటుతాము.” ");
INSERT INTO telotsa_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","అప్పుడు మోషే వారి గురించి యాజకుడైన ఎలియాజరు, నూను కుమారుడైన యెహోషువ, ఇశ్రాయేలీయుల గోత్రాల కుటుంబ పెద్దలకు ఆదేశించాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","మోషే వారితో అన్నాడు, “గాదీయులు, రూబేనీయులు, వీరిలో యుద్ధానికి సిద్ధంగా ఉన్నవారు యెహోవా ఎదుట మీతో యొర్దానును దాటుతారు, అప్పుడు ఆ స్థలాన్ని జయించినప్పుడు, మీరు గిలాదు భూమిని వారికి స్వాస్థ్యంగా ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","కానీ వారు ఒకవేళ ఆయుధాలు ధరించి మీతో దాటకపోతే, వారు కనానులో మీ దగ్గర తమ స్వాస్థ్యాన్ని అంగీకరించాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","గాదీయులు, రూబేనీయులు జవాబిస్తూ ఇలా అన్నారు, “యెహోవా చెప్పినది మీ సేవకులమైన మేము చేస్తాము. ");
INSERT INTO telotsa_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ఆయుధాలు ధరించి యెహోవా ఎదుట కనాను లోనికి వెళ్తాము, కానీ మేము వారసత్వంగా సంపాదించుకునే స్వాస్థ్యం యొర్దానుకు ఇటువైపు ఉంటుంది.” ");
INSERT INTO telotsa_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","అప్పుడు మోషే గాదీయులకు, రూబేనీయులకు, యోసేపు కుమారుడైన మనష్షే అర్థగోత్రానికి అమోరీయుల రాజైన సీహోను రాజ్యాన్ని, బాషాను రాజైన ఓగు రాజ్యాన్ని దాని పట్టణాలు, వాటి సరిహద్దులతో సహా ఆ స్థలాన్నంతటిని ఇచ్చాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","గాదీయులు దీబోను, అతారోతు, అరోయేరు, ");
INSERT INTO telotsa_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","అత్రోత్-షోఫాను, యాజెరు, యొగ్బెహ, ");
INSERT INTO telotsa_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","బేత్-నిమ్రా, బేత్-హారాను, అనే పట్టణాలను కోటగోడలతో నిర్మించారు, మందలకు దొడ్లు కూడా కట్టుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","రూబేనీయులు నిర్మించిన పట్టణాలు హెష్బోను, ఎల్యాలెహు, కిర్యతాయిము, ");
INSERT INTO telotsa_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","అలాగే నెబో, బయల్-మెయోను (ఈ పేర్లు మార్చబడ్డాయి) షిబ్మా అనే పట్టణాలను నిర్మించుకున్నారు. వారు తిరిగి కట్టుకున్న పట్టణాలకు వారు పేర్లు పెట్టుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","మనష్షే కుమారుడైన మాకీరు వంశస్థులు గిలాదుకు వెళ్లి, దాన్ని జయించి, అక్కడ ఉన్న అమోరీయులను తరిమేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","కాబట్టి మోషే మనష్షే కుమారుడైన మాకీరు వంశస్థులకు గిలాదును ఇచ్చాడు. వారు అక్కడే కాపురమున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","మనష్షే వంశస్థుడైన యాయీరు వారి స్థావరాలను స్వాధీనం చేసుకుని వాటికి హవ్వోత్ యాయీరు అని పేరు పెట్టాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","నోబహు అనేవాడు వెళ్లి కెనాతు దాని స్థావరాలను జయించి ఆ ప్రాంతానికి నోబహు అని తన పేరు పెట్టుకున్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ఇశ్రాయేలీయులు మోషే అహరోనుల నాయకత్వంలో సేనలుగా ఏర్పడి ఈజిప్టు నుండి బయలుదేరి చేసిన ప్రయాణాలు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","యెహోవా ఆజ్ఞ ప్రకారం మోషే వారి ప్రయాణాల దశలను నమోదు చేశాడు. ఇవి వారి ప్రయాణాల దశలు: ");
INSERT INTO telotsa_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","4","ఇశ్రాయేలీయులు మొదటి నెల పదిహేనవ రోజు అంటే పస్కా తర్వాత రోజున, రామెసేసు నుండి ప్రయాణమయ్యారు. యెహోవా హతం చేసిన తమ జ్యేష్ఠులందరిని ఈజిప్టువారు సమాధి చేస్తూ ఉన్నప్పుడు, వారు చూస్తూ ఉండగా జయోత్సాహంతో బయలుదేరారు; ఎందుకంటే యెహోవా వారి దేవుళ్ళ మీద తీర్పు తీర్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ఇశ్రాయేలీయులు రామెసేసును వదిలి సుక్కోతు దగ్గర దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","వారు సుక్కోతును నుండి బయలుదేరి ఎడారి అంచున ఉన్న ఏతాముకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","వారు ఏతాము నుండి వెనుకకు తిరిగి బయల్-సెఫోను ఎదురుగా పీ హహీరోతు వైపుకు వెళ్లి మిగ్దోలు ఎదుట దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","పీ హహీరోతు నుండి బయలుదేరి సముద్రం గుండా దాటుతూ ఎడారిలోకి చేరారు, వారు మూడు రోజులు ఏతాము ఎడారిలో ప్రయాణం చేసి మారాలో దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","మారా నుండి బయలుదేరి ఎలీముకు వెళ్లారు, ఎలీములో పన్నెండు నీటి ఊటలు, డెబ్బయి ఈతచెట్లు ఉన్నాయి, వారక్కడ ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ఎలీము నుండి బయలుదేరి ఎర్ర సముద్రం దగ్గర దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ఎర్ర సముద్రం నుండి బయలుదేరి సీను ఎడారికి వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","సీను ఎడారి నుండి బయలుదేరి దోపకాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","దోపకా నుండి బయలుదేరి ఆలూషుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ఆలూషు నుండి బయలుదేరి రెఫీదీముకు వచ్చారు. అక్కడ ప్రజలకు త్రాగడానికి నీళ్లు లేవు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","రెఫీదీము నుండి బయలుదేరి సీనాయి ఎడారికి వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","సీనాయి ఎడారి నుండి బయలుదేరి కిబ్రోతు హత్తావాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","కిబ్రోతు హత్తావా నుండి బయలుదేరి హజేరోతుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","హజేరోతు నుండి బయలుదేరి రిత్మాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","రిత్మా నుండి బయలుదేరి రిమ్మోను పెరెజుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","రిమ్మోను పెరెజు నుండి బయలుదేరి లిబ్నాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","లిబ్నా నుండి బయలుదేరి రీసాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","రీసా నుండి బయలుదేరి కేహేలాతాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","కేహేలాతా నుండి బయలుదేరి షాపెరు పర్వతముకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","షాపెరు పర్వతము నుండి బయలుదేరి హరాదాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","హరాదా నుండి బయలుదేరి మకెలోతుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","మకెలోతు నుండి బయలుదేరి తాహతుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","తాహతు నుండి బయలుదేరి తారహుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","తారహు నుండి బయలుదేరి మిత్కాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","మిత్కా నుండి బయలుదేరి హష్మోనాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","హష్మోనా నుండి బయలుదేరి మొసేరోతుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","మొసేరోతు నుండి బయలుదేరి బెనె యహకానుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","బెనె యహకాను నుండి బయలుదేరి హోర్-హగ్గిద్గాదుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","హోర్-హగ్గిద్గాదు నుండి బయలుదేరి యొత్బాతాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","యొత్బాతా నుండి బయలుదేరి ఎబ్రోనాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ఎబ్రోనా నుండి బయలుదేరి ఎసోన్-గెబెరుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ఎసోన్-గెబెరు నుండి బయలుదేరి సీను ఎడారిలో ఉన్న కాదేషుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","కాదేషు నుండి బయలుదేరి ఎదోము సరిహద్దులో ఉన్న హోరు పర్వతం దగ్గర దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","యెహోవా ఆజ్ఞ ప్రకారం యాజకుడైన అహరోను హోరు పర్వతం మీద చనిపోయాడు, ఇశ్రాయేలీయులు ఈజిప్టు నుండి వచ్చిన నలభైయవ సంవత్సరం, అయిదవ నెల, మొదటి రోజున అతడు చనిపోయాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","హోరు పర్వతం మీద అహరోను చనిపోయినప్పుడు అతని వయస్సు నూట యిరవై మూడు సంవత్సరాలు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","కనాను దక్షిణ దిక్కున కనానీయుడైన అరాదు పట్టణ రాజు ఇశ్రాయేలీయులు వస్తున్నారని విన్నాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","వారు హోరు పర్వతం నుండి బయలుదేరి సల్మానాకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","సల్మానా నుండి బయలుదేరి పూనొనుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","పూనొను నుండి బయలుదేరి ఓబోతుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ఓబోతు నుండి బయలుదేరి మోయాబు సరిహద్దులో ఉన్న ఈయ్యె-అబారీముకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ఈయ్యె-అబారీము నుండి బయలుదేరి దీబోనుగాదుకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","దీబోనుగాదు నుండి బయలుదేరి అల్మోన్-దిబ్లాతయీముకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","అల్మోన్-దిబ్లాతయీము నుండి బయలుదేరి నెబో ఎదుట ఉన్న అబారీము పర్వతాల దగ్గర దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","అబారీము పర్వతాల నుండి బయలుదేరి యెరికోకు దగ్గర యొర్దాను అవతలి వైపున మోయాబు సమతల మైదానాల్లో దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","మోయాబు సమతల మైదానంలో బేత్-యెషిమోతు మొదలుకొని ఆబేల్-షిత్తీము వరకు యొర్దాను దగ్గర దిగారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","యెరికో దగ్గర యొర్దాను అవతలి వైపు ఉన్న మోయాబు సమతల మైదానంలో యెహోవా మోషేతో ఇలా మాట్లాడారు, ");
INSERT INTO telotsa_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ఇశ్రాయేలు ప్రజలతో మాట్లాడుతూ ఇలా చెప్పు: ‘మీరు యొర్దాను దాటి కనానుకు వెళ్లినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ఆ దేశవాసులందర్నీ తరిమేయాలి. వారి రాతి విగ్రహాలను, కోట విగ్రహాలను నాశనం చేయాలి వారి క్షేత్రాలను పడగొట్టాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ఆ దేశాన్ని స్వాధీనం చేసుకుని అందులో నివసించండి ఎందుకంటే మీరు స్వాధీనపరచుకోడానికి ఆ దేశాన్ని మీకు ఇచ్చాను. ");
INSERT INTO telotsa_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","చీట్లు వేసి మీ వంశాల ప్రకారం ఆ దేశాన్ని పంచుకోండి. పెద్ద గోత్రాలకు ఎక్కువ వారసత్వం చిన్న గోత్రాలకు తక్కువ వారసత్వంగా పంచుకోండి. చీట్లలో ఏది వస్తే, అది వారికి చెందుతుంది. మీ పూర్వికుల గోత్రాల ప్రకారం దానిని పంచుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘అయితే ఆ దేశవాసులను మీరు తరిమివేయకపోతే, అక్కడ ఉండడానికి అనుమతించిన వారు మీ కళ్లలో ముళ్ళుగా, మీ ప్రక్కలలో శూలాలుగా చేసినవారవుతారు. మీరు నివసించే భూమిలో వారు మిమ్మల్ని కష్ట పెడతారు. ");
INSERT INTO telotsa_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","అప్పుడు నేను వారికేమి చేయాలని అనుకున్నానో, అది మీకు చేస్తాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","యెహోవా మోషేతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“నీవు ఇశ్రాయేలీయులకు ఆజ్ఞాపిస్తూ వారికి ఇలా చెప్పు: ‘మీరు కనానులో ప్రవేశించిన తర్వాత, మీకు వారసత్వంగా కేటాయించబడే భూములకు చెందిన సరిహద్దులు: ");
INSERT INTO telotsa_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘మీ దక్షిణం వైపు ఎదోము సరిహద్దు ప్రక్కన సీను ఎడారిలో కొద్ది భాగం ఉంటుంది. మీ దక్షిణ సరిహద్దు మృత సముద్రం యొక్క దక్షిణ చివర తూర్పు దిక్కున ప్రారంభమై, ");
INSERT INTO telotsa_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","దక్షిణం వైపు అక్రబ్బీం కనుమ నుండి తిరిగి సీను వరకు వ్యాపించి కాదేషు బర్నియాకు దక్షిణంగా ఉంటుంది. అక్కడినుండి హజర్ అద్దారుకు, అక్కడినుండి అజ్మోను వరకు, ");
INSERT INTO telotsa_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","అజ్మోను నుండి తిరిగి ఈజిప్టు వాగు వైపు తిరిగి మధ్యధరా సముద్రం దగ్గర ముగుస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","మీ పడమటి సరిహద్దు మధ్యధరా సముద్ర తీరము. ఇదే మీ పడమటి వైపు సరిహద్దుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","మీ ఉత్తర సరిహద్దు మధ్యధరా సముద్రం నుండి హోరు పర్వతం వరకు ");
INSERT INTO telotsa_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","హోరు పర్వతం నుండి లెబో హమాతు వరకు అక్కడినుండి సరిహద్దు సెదాదు వరకు వెళ్తూ, ");
INSERT INTO telotsa_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","అక్కడినుండి జిఫ్రోను వరకు కొనసాగుతూ హజర్-ఎనాను వరకు వ్యాపిస్తుంది. ఇది మీకు ఉత్తర సరిహద్దుగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","మీ తూర్పు సరిహద్దు హజర్-ఎనాను నుండి షెఫాము వరకు ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","సరిహద్దు షెఫాము నుండి ఆయినుకు తూర్పు వైపు రిబ్లా వరకు వెళ్లి కిన్నెరెతు సరస్సు తూర్పున ఉన్న వాలుల వెంట కొనసాగుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","తర్వాత ఆ సరిహద్దు యొర్దాను గుండా వెళ్తూ మృత సముద్రం వరకు వ్యాపిస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","మోషే ఇశ్రాయేలీయులకు ఇలా ఆజ్ఞాపించాడు: “మీరు చీట్లు వేసి ఈ దేశాన్ని ఒక వారసత్వంగా కేటాయించాలి. తొమ్మిదిన్నర గోత్రాలకు ఇవ్వమని యెహోవా ఆదేశించారు, ");
INSERT INTO telotsa_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ఎందుకంటే రూబేను గోత్రికులు, గాదు గోత్రికులు, మనష్షే అర్థగోత్రం, తమ తమ కుటుంబాలు వారసత్వం పొందారు. ");
INSERT INTO telotsa_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ఈ రెండున్నర గోత్రాల వారు యెరికోకు తూర్పున యొర్దానుకు అవతలి వైపు, సూర్యోదయం వైపున ఉన్న భూభాగాన్ని స్వాస్థ్యంగా పొందుకున్నారు.” ");
INSERT INTO telotsa_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“మీకు భూమిని స్వాస్థ్యంగా కేటాయించే పురుషుల పేర్లు ఇవి: యాజకుడైన ఎలియాజరు నూను కుమారుడైన యెహోషువ. ");
INSERT INTO telotsa_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","భూకేటాయింపు కోసం సహాయపడడానికి ప్రతి గోత్రం నుండి ఒక నాయకున్ని నియమించు. ");
INSERT INTO telotsa_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“వారి పేర్లు ఇవి: “యూదా గోత్రం నుండి, యెఫున్నె కుమారుడైన కాలేబు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","షిమ్యోను గోత్రం నుండి అమీహూదు కుమారుడైన షెమూయేలు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","బెన్యామీను గోత్రం నుండి కిస్లోను కుమారుడైన ఎలీదాదు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","దాను గోత్రం నుండి యొగ్లీ కుమారుడైన బుక్కీ నాయకుడు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","యోసేపు కుమారుడైన మనష్షే గోత్రం నుండి ఏఫోదు కుమారుడైన హన్నీయేలు నాయకుడు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ఎఫ్రాయిం గోత్రం నుండి షిఫ్తాను కుమారుడైన కెమూయేలు నాయకుడు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","జెబూలూను గోత్రం నుండి పర్నాకు కుమారుడైన ఎలీషాపాను నాయకుడు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ఇశ్శాఖారు గోత్రం నుండి అజ్జాను కుమారుడైన పల్తీయేలు నాయకుడు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ఆషేరు గోత్రం నుండి షెలోమి కుమారుడైన అహీహూదు నాయకుడు; ");
INSERT INTO telotsa_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","నఫ్తాలి గోత్రం నుండి అమీహూదు కుమారుడైన పెదహేలు నాయకుడు.” ");
INSERT INTO telotsa_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","కనాను దేశంలో ఇశ్రాయేలీయులకు వారసత్వ భూమిని కేటాయించడానికి యెహోవా ఈ పురుషులను నియమించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","మోయాబు సమతల మైదానాల్లో, యెరికోకు ఎదురుగా యొర్దాను అవతలి వైపు ఉన్న ప్రాంతంలో యెహోవా మోషేతో అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ఇశ్రాయేలీయులు స్వాధీనం చేసుకునే స్వాస్థ్యం నుండి పట్టణాలను లేవీయులు నివసించడానికి ఇమ్మని ఆజ్ఞాపించు. పట్టణాల చుట్టూ ఉన్న పచ్చికబయళ్లు వారికి ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","అప్పుడు వారు నివసించడానికి పట్టణాలు కలిగి ఉంటారు వారి సొంత పశువుల కోసం, ఇతర జంతువుల కోసం పచ్చికబయళ్లు ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“లేవీయులకు ఇచ్చే పట్టణాల చుట్టూ ఉండే పచ్చికబయళ్లు పట్టణ ప్రాకారానికి 1,000 క్యూబిట్‌ల దూరంలో ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","పట్టణం బయట తూర్పు దిక్కున 2,000 క్యూబిట్‌ల దక్షిణ దిక్కున 2,000 క్యూబిట్‌ల, పడమటి దిక్కున 2,000 క్యూబిట్‌ల, ఉత్తర దిక్కున 2,000 క్యూబిట్‌లు కొలవాలి, దాని కేంద్రంగా పట్టణం ఉంటుంది. వారు ఈ భూభాగాన్ని పట్టణాలకు పచ్చికబయళ్లుగా కలిగి ఉంటారు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“లేవీయులకు ఇచ్చే వాటిలో ఆరు పట్టణాలు ఆశ్రయపురాలుగా ఉండాలి. ప్రమాదవశాత్తు ఎవరినైనా చంపితే ఆ వ్యక్తి ఇక్కడకు పారిపోవచ్చు. వీటితో సహా 42 పట్టణాలు వారికి ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","మొత్తం 48 పట్టణాలు, వాటి చుట్టూ ఉన్న పచ్చికబయళ్లతో సహా లేవీయులకు ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ఇశ్రాయేలీయులు స్వాధీనం చేసుకునే వాటిలో లేవీయులకు ఇచ్చే పట్టణాలు ప్రతి గోత్రం వారి వారసత్వం నుండి ఇవ్వాలి. ఎక్కువ పట్టణాలు గల గోత్రం నుండి ఎక్కువ పట్టణాలు, తక్కువ ఉన్న వారి నుండి తక్కువ తీసుకోవాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","తర్వాత యెహోవా మోషేతో ఇలా మాట్లాడారు: ");
INSERT INTO telotsa_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ఇశ్రాయేలీయులతో మాట్లాడుతూ ఇలా చెప్పు: ‘మీరు యొర్దాను దాటి కనానుకు వెళ్లినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","కొన్ని పట్టణాలను ఆశ్రయపురాలుగా ఎన్నుకోండి. ప్రమాదవశాత్తు ఒకరు ఎవరినైన చంపితే, వాటికి పారిపోయి ఆశ్రయం పొందవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ఆ పట్టణాలు ప్రతీకారం తీర్చుకునే వారి నుండి కాపాడుకోడానికి ఆశ్రయంగా ఉంటాయి, తద్వారా హత్యకు పాల్పడిన ఎవరైనా సమాజం ముందు విచారణకు రాకముందు చంపబడరు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ఈ ఆరు పట్టణాలు మీ ఆశ్రయ పట్టణాలుగా ఉంటాయి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","మూడు యొర్దానుకు ఇటువైపు, మూడు కనాను దేశంలో ఆశ్రయపురాలుగా ఇవ్వాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ఈ ఆరు పట్టణాలు ఇశ్రాయేలీయులు వారి మధ్య నివసించే విదేశీయులకు ఆశ్రయపురాలుగా ఉంటాయి, తద్వార, ప్రమాదవశాత్తు ఒకరు ఎవరినైన చంపితే, వాటికి పారిపోయి ఆశ్రయం పొందవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘ఎవరైనా ఇనుప వస్తువుతో ఎవరినైన చచ్చేటట్టు కొడితే, ఆ వ్యక్తి హంతకుడు; హంతకుడు మరణశిక్ష పొందాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","లేదా ఒకవేళ ఎవరైనా ఒక రాయితో ఎవరినైన చచ్చేటట్టు కొడితే, ఆ వ్యక్తి హంతకుడు; హంతకుడు మరణశిక్ష పొందాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","లేదా ఒకవేళ ఎవరైనా ఒక చెక్క వస్తువుతో ఎవరినైన చచ్చేటట్టు కొడితే, ఆ వ్యక్తి హంతకుడు; హంతకుడు మరణశిక్ష పొందాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","పగ తీర్చుకునేవాడు ఆ హంతకునికి మరణశిక్ష వేయాలి; పగ తీర్చుకునేవాడు హంతకున్ని పట్టుకున్నప్పుడు అతన్ని చంపుతాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ఎవరైనా పగతో నెట్టినా లేదా వారివైపు ఉద్దేశపూర్వకంగా చేతిలో ఉన్నదానిని వారి మీదికి విసిరివేసినా, వారు చనిపోతే ");
INSERT INTO telotsa_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","లేదా శత్రుత్వం బట్టి ఒకరిని పిడికిలితో కొడితే ఆ వ్యక్తి చస్తే, వాడు మరణశిక్ష పొందాలి; ఆ వ్యక్తి హంతకుడు. పగ తీర్చుకునేవాడు అతన్ని కలిసినప్పుడు అతన్ని చంపుతాడు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘అయితే ఎవరైనా శత్రుత్వం లేకుండ ఎవరినైన అకస్మాత్తుగా నెట్టినా, లేదా వారివైపు అనుకోకుండ ఏదైనా విసిరినా, ");
INSERT INTO telotsa_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","లేదా చూడకుండ బరువైన రాయి వేసినా, వారు చనిపోతే, వేసినవానికి వారు శత్రువు కాదు హాని చేయాలనే ఉద్దేశం లేదు కాబట్టి, ");
INSERT INTO telotsa_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","సమాజం నిందితునికి, పగతీర్చుకునే వానికి మధ్య ఉండి ఈ చట్టాల ప్రకారం తీర్పు తీర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","సమాజం ఆ నిందితుడిని పగతీర్చుకునే వాని నుండి కాపాడి తిరిగి అతడు పారిపోయిన ఆశ్రయపురానికి పంపించాలి. నిందితుడు పరిశుద్ధ నూనెతో అభిషేకించబడిన ప్రధాన యాజకుడు చనిపోయే వరకు అక్కడే ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘ఒకవేళ నిందితుడు తాను వెళ్లిన ఆశ్రయపురం నుండి బయటకు వెళ్తే, ");
INSERT INTO telotsa_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","పగ తీర్చుకునేవాడు అతన్ని ఆశ్రయపురం బయట చూస్తే, అతన్ని చంపవచ్చు, అది హత్యగా లెక్కించబడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ప్రధాన యాజకుడు చనిపోయే వరకు నిందితుడు ఆశ్రయపురం లోనే ఉండాలి. ఆ తర్వాత అతడు తన స్వస్థలానికి వెళ్లిపోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘ఇది మీరు ఎక్కడ నివసించినా, రాబోయే తరాలలో మీ కోసం చట్టబద్ధమైన నియమంగా ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘సాక్షుల నోటి మాటను బట్టి హంతకులు మరణశిక్ష పొందుతారు. అయితే ఒక్క సాక్షి సాక్ష్యాన్ని బట్టి ఏ ఒక్కరికీ మరణశిక్ష విధించబడకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘శిక్ష పొందాల్సిన హంతకుల జీవితం కోసం విమోచన క్రయధనం స్వీకరించకూడదు. వారు మరణశిక్ష పొందాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘ఆశ్రయపురానికి పారిపోయినవారి నుండి విమోచన క్రయధనం స్వీకరించకూడదు, ప్రధాన యాజకుడు చనిపోకముందు వారిని తమ స్వస్థలానికి పంపించవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘మీరున్న భూమిని కలుషితం చేయకండి. రక్తపాతం దేశాన్ని కలుషితం చేస్తుంది రక్తపాతం చేసిన ఆ వ్యక్తి రక్తం ద్వారానే తప్ప ఆ భూమికి ప్రాయశ్చిత్తం చేయలేము. ");
INSERT INTO telotsa_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","మీరు నివసించే, నేను నివసించే భూమిని అపవిత్రం చేయవద్దు, ఎందుకంటే, యెహోవానైన నేను, ఇశ్రాయేలీయుల మధ్య నివసిస్తాను.’ ” ");
INSERT INTO telotsa_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","యోసేపు వంశం నుండి వచ్చిన మనష్షే కుమారుడు మాకీరు, గిలాదు వంశ పెద్దలు వచ్చి నాయకులు, ఇశ్రాయేలీయుల కుటుంబాల పెద్దలు ఎదుట మోషేతో మాట్లాడారు. ");
INSERT INTO telotsa_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“చీట్లు వేసి ఇశ్రాయేలీయులకు భూమిని వారసత్వంగా ఇవ్వమని యెహోవా మా ప్రభువుకు ఆజ్ఞాపించినప్పుడు మా సహోదరుడు సెలోఫెహాదు భూ వారసత్వాన్ని అతని కుమార్తెలకు ఇమ్మని ఆజ్ఞాపించారు. ");
INSERT INTO telotsa_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ఒకవేళ వారు ఇతర ఇశ్రాయేలు గోత్రం వారిని పెళ్ళి చేసుకుంటే, అప్పుడు వారి వారసత్వం పూర్వికుల గోత్రం నుండి మారి వేరే వారు పెళ్ళి చేసుకున్న వారి గోత్రంలో కలిసిపోతుంది. కాబట్టి వారి వారసత్వం లోని భాగం తీసివేయబడుతుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ఇశ్రాయేలు యొక్క మహోత్సవ సంవత్సరం వచ్చినప్పుడు, వారి వారసత్వం వారు పెళ్ళి చేసుకున్న వారి గోత్రంలో కలిసిపోతుంది, మా పూర్వికుల వంశ వారసత్వం నుండి స్వాస్థ్యం పోతుంది” అని అంటూ చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","అప్పుడు యెహోవా ఆజ్ఞమేరకు మోషే ఇశ్రాయేలీయులను ఆదేశించాడు: “యోసేపు సంతతివారి గోత్రం వారు తెచ్చిన ఫిర్యాదు సరియైనదే. ");
INSERT INTO telotsa_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","సెలోఫెహాదు కుమార్తెల గురించి యెహోవా ఇలా ఆజ్ఞాపించారు: వారు తమకు ఇష్టం వచ్చిన వారిని పెళ్ళి చేసుకోవచ్చు, కానీ అది వారి తండ్రి గోత్ర వంశం వారై ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ఇశ్రాయేలు ప్రజల వారసత్వం ఒక గోత్రం నుండి ఇంకొక గోత్రం లోకి పోకూడదు. ఇశ్రాయేలీయులలో ప్రతి ఒక్కరూ తమ పూర్వికుల గోత్ర వారసత్వాన్ని తమ వంశం లోనే ఉంచుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ఇశ్రాయేలు ప్రజల గోత్రాల్లో వారసత్వం ఉన్న ప్రతి కుమార్తె తన తండ్రి గోత్రం వారినే పెళ్ళి చేసుకోవాలి. ఈ విధంగా వారి వారి పూర్వికులు వారసత్వం వారి స్వాధీనంలోనే ఉంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","వారసత్వం ఒక వంశం నుండి ఇంకొక వంశానికి వెళ్లకూడదు. ప్రతి ఇశ్రాయేలు గోత్రం వారు వారసత్వ భూమిని కాపాడుకోవాలి.” ");
INSERT INTO telotsa_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","కాబట్టి యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం సెలోఫెహాదు కుమార్తెలు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","సెలోఫెహాదు కుమార్తెలైన మహ్లా, తిర్సా, హొగ్లా, మిల్కా, నోవా తమ తండ్రి సహోదరుల కుమారులను పెళ్ళి చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","వీరు యోసేపు కుమారుడైన మనష్షే సంతతివారిని పెళ్ళి చేసుకున్నారు వారి వారసత్వం వారి తండ్రి గోత్రం లోనే, వంశం లోనే నిలిచింది. ");
INSERT INTO telotsa_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ఇవి మోయాబు సమతల మైదానంలో, యెరికోకు ఎదురుగా యొర్దాను అవతలి వైపు ప్రాంతంలో యెహోవా మోషే ద్వారా ఇశ్రాయేలీయులకు ఇచ్చిన ఆజ్ఞలు, నియమాలు ఇచ్చారు.");
INSERT INTO telotsa_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","యొర్దానుకు తూర్పున ఉన్న అరణ్యంలో అనగా పారానుకు తోపెలు, లాబాను, హజేరోతు, దీజాహబ్ అనే స్థలాలకు మధ్య సూఫుకు ఎదురుగా ఉన్న అరాబాలో మోషే ఇశ్రాయేలీయులందరితో చెప్పిన మాటలు ఇవి. ");
INSERT INTO telotsa_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(సాధారణంగా శేయీరు పర్వత దారి గుండా హోరేబు నుండి కాదేషు బర్నియాకు ప్రయాణించడానికి పదకొండు రోజులు పడుతుంది.) ");
INSERT INTO telotsa_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","నలభైయవ సంవత్సరం, పదకొండవ నెల మొదటి రోజున మోషే ఇశ్రాయేలీయులను ఉద్దేశించి యెహోవా ఆజ్ఞాపించినదంతా వారికి ప్రకటించాడు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ఇది తాను హెష్బోనులో పరిపాలించిన అమోరీయుల రాజైన సీహోనును ఓడించిన తర్వాత, ఎద్రెయీ దగ్గర అష్తారోతులో పరిపాలించిన బాషాను రాజైన ఓగును ఓడించిన తర్వాత వారికి ప్రకటించాడు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","యొర్దాను తూర్పున మోయాబు దేశంలో మోషే ఈ ధర్మశాస్త్రాన్ని వివరించడం మొదలుపెట్టి ఇలా అన్నాడు: ");
INSERT INTO telotsa_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","దేవుడైన యెహోవా హోరేబు దగ్గర మనతో ఇలా మాట్లాడారు, “మీరు ఈ పర్వతం దగ్గర చాలా కాలం నుండి ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","మీరు తిరిగి ప్రయాణమై అమోరీయుల కొండ ప్రాంతం వైపు వెళ్లండి; అరాబాలో, పర్వతాల్లో, పశ్చిమ కొండ ప్రాంతంలో, దక్షిణం వైపున సముద్రతీరంలో ఉన్న అన్ని స్థలాలకు, కనాను దేశానికి, లెబానోనుకు మహానదియైన యూఫ్రటీసు వరకు ఉన్న పొరుగు దేశాలకు వెళ్లండి. ");
INSERT INTO telotsa_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","చూడండి, ఈ దేశాన్ని నేను మీకిచ్చాను. కాబట్టి మీరు వెళ్లి యెహోవా మీ పితరులైన అబ్రాహాము ఇస్సాకు యాకోబులకు, వారి తర్వాత వారి సంతానానికి ఇస్తానని ప్రమాణం చేసిన దేశాన్ని స్వాధీనం చేసుకోండి.” ");
INSERT INTO telotsa_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ఆ సమయంలో నేను మీతో, “నేను ఒంటరిగా మోయలేనంత భారంగా మీరున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","మీ దేవుడైన యెహోవా మిమ్మల్ని విస్తరింపజేశారు కాబట్టి ఇప్పుడు మీరు ఆకాశ నక్షత్రాల్లా లెక్కించలేనంతగా ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","మీ పూర్వికుల దేవుడైన యెహోవా మిమ్మల్ని వెయ్యిరెట్లు ఎక్కువ చేసి ఆయన వాగ్దానం చేసినట్లుగా మిమ్మల్ని ఆశీర్వదించును గాక! ");
INSERT INTO telotsa_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","అయితే నేనొక్కడినే మీ సమస్యలను మీ భారాలను మీ వివాదాలను ఎలా తీర్చగలను? ");
INSERT INTO telotsa_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ప్రతి గోత్రంలో నుండి జ్ఞాన వివేకాలు కలిగిన పురుషులను ఎంపిక చేయండి, నేను వారిని మీకు నాయకులుగా నియమిస్తాను” అని చెప్పాను. ");
INSERT INTO telotsa_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","అందుకు మీరు, “నీవు చెప్పింది బాగుంది” అని జవాబిచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","కాబట్టి మీ గోత్రాల్లో నుండి జ్ఞానం కలిగి ప్రసిద్ధులైన వారిని పిలిపించి, వారిని మీ గోత్రాలకు అధికారులుగా, వేయిమందికి, వందమందికి, యాభైమందికి, పదిమందికి ఒక అధికారి ప్రకారం అధికారులుగా నియమించాను. ");
INSERT INTO telotsa_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","అప్పుడు నేను మీ న్యాయాధిపతులతో, “మీ ప్రజలమధ్య ఉన్న వివాదాలు విని, ఇద్దరు ఇశ్రాయేలీయుల మధ్య అయినా లేదా ఒక ఇశ్రాయేలీయునికి ఒక విదేశీయునికి మధ్య అయినాసరే, న్యాయంగానే తీర్పు తీర్చాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","తీర్పు తీర్చడంలో పక్షపాతం చూపించవద్దు; పేదవారైనా గొప్పవారైనా సరే ఒకే రీతిగా వినాలి, తీర్పు దేవునికి సంబంధించింది కాబట్టి ఎవరికి భయపడవద్దు. మీకు పరిష్కరించడానికి కష్టంగా ఉన్న సమస్యను నా దగ్గరకు తీసుకురండి, నేను దానిని వింటాను” అని చెప్పాను. ");
INSERT INTO telotsa_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","మీరు చేయవలసిందంతా ఆ సమయంలో నేను మీకు చెప్పాను. ");
INSERT INTO telotsa_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","తర్వాత మన దేవుడైన యెహోవా మనకు ఆజ్ఞాపించిన ప్రకారం, హోరేబు నుండి బయలుదేరి మీరు చూసిన భయంకరమైన మహారణ్యం గుండా వచ్చి, అమోరీయుల కొండ ప్రాంతం ద్వారా ప్రయాణించి కాదేషు బర్నియాకు చేరుకున్నాము. ");
INSERT INTO telotsa_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","అప్పుడు నేను మీతో, “మన దేవుడైన యెహోవా మనకు ఇస్తున్న అమోరీయుల కొండ ప్రాంతానికి మీరు చేరుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","చూడండి, మీ దేవుడైన యెహోవా మీకు ఈ దేశాన్ని ఇచ్చారు. మీ పూర్వికుల దేవుడైన యెహోవా మీతో చెప్పినట్లుగా, వెళ్లి దానిని స్వాధీనపరచుకోండి. భయపడకండి; అధైర్యపడకండి” అని చెప్పాను. ");
INSERT INTO telotsa_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","అప్పుడు మీరందరు నా దగ్గరకు వచ్చి, “ఆ దేశంలో గూఢచర్యం చేసి మనం వెళ్లవలసిన దారి, మనం వెళ్లే పట్టణాల గురించి సమాచారం తెలుసుకోవడానికి ముందుగానే కొంతమందిని పంపుదాం” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ఈ ఆలోచన నాకు నచ్చింది కాబట్టి మీలో ప్రతి గోత్రం నుండి ఒకరు చొప్పున పన్నెండుమందిని పంపాను. ");
INSERT INTO telotsa_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","వారు అక్కడినుండి కొండ ప్రాంతానికి ఎక్కి వెళ్లి ఎష్కోలు లోయకు వచ్చి దాన్ని పరిశీలించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","వారు ఆ దేశపు పండ్లు కొన్ని మన దగ్గరకు తెచ్చి, “మన దేవుడైన యెహోవా మనకిస్తున్న దేశం మంచిది” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","కాని మీరు వెళ్లడానికి ఇష్టపడలేదు; మీ దేవుడైన యెహోవా ఆజ్ఞకు తిరుగుబాటు చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","మీ గుడారాల్లో సణుగుతూ, “యెహోవా మనలను ద్వేషించి మనలను నాశనం చేయడానికి అమోరీయుల చేతికి మనలను అప్పగించడానికి ఈజిప్టు నుండి మనలను బయటకు తీసుకువచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","మనం ఎక్కడికి వెళ్లగలం? మన సహోదరులు, ‘అక్కడి ప్రజలు మనకన్నా బలవంతులు, పొడవైనవారు; ఆ పట్టణాలు ఎంతో పెద్దవిగా ఆకాశమంత ఎత్తైన గోడలతో ఉన్నాయి; అక్కడ అనాకీయులను కూడా చూశాం’ అని చెప్పి మా గుండెలు భయంతో చెదిరిపోయేలా చేశారు” అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","అప్పుడు నేను మీతో, “దిగులుపడకండి, వారికి భయపడకండి. ");
INSERT INTO telotsa_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","మీకు ముందుగా నడుస్తున్న మీ దేవుడైన యెహోవా మీ కళ్ళెదుట ఈజిప్టులోను అరణ్యంలోను మీ కోసం చేసినట్లు ఆయన మీ కోసం యుద్ధం చేస్తారు, ");
INSERT INTO telotsa_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","మీరు ఈ స్థలానికి చేరుకునేవరకు తండ్రి తన కుమారుని ఎత్తుకున్నట్లు మీ దేవుడైన యెహోవా మీ మార్గమంతటిలో మిమ్మల్ని ఎలా ఎత్తుకుని వచ్చారో మీరు చూశారు” అని అన్నాను. ");
INSERT INTO telotsa_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","ఇంత చెప్పినా, మీ ప్రయాణమంతటిలో మీరు బస కోసం చోటు వెదకడానికి, మీరు వెళ్లవలసిన మార్గాన్ని మీకు చూపించడానికి రాత్రివేళ అగ్నిలో, పగటివేళ మేఘంలో మీకు ముందుగా నడిచిన మీ దేవుడైన యెహోవాయందు మీరు నమ్మకం ఉంచలేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","మీరు చెప్పిన మాటలు యెహోవా విన్నప్పుడు ఆయన కోపంతో, కాబట్టి ఆయన ప్రమాణ చేస్తూ, ");
INSERT INTO telotsa_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“నేను మీ పూర్వికులకు ఇస్తానని వాగ్దానం చేసిన ఈ మంచి దేశాన్ని ఈ చెడ్డతరంలో ");
INSERT INTO telotsa_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","యెఫున్నె కుమారుడైన కాలేబు తప్ప మరి ఎవరు చూడరు. అతడు హృదయమంతటితో యెహోవాను అనుసరించాడు కాబట్టి దానిని చూస్తాడు. అతడు అడుగుపెట్టిన దేశాన్ని అతనికి, అతని సంతానానికి నేను ఇస్తాను” అని ప్రమాణం చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","మీ కారణంగా యెహోవా నా మీద కూడా కోప్పడి, “నీవు కూడా ఆ దేశంలో అడుగుపెట్టవు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","కాని, నీ సహాయకుడు నూను కుమారుడైన యెహోషువ దానిలో అడుగుపెడతాడు. దానిని స్వాధీనపరచుకునేలా అతడు ఇశ్రాయేలీయులను నడిపిస్తాడు కాబట్టి అతన్ని ప్రోత్సహించు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","బందీలుగా వెళ్తారని మీరు చెప్పిన మంచి చెడు తెలియని మీ పిల్లలు ఆ దేశంలో అడుగుపెడతారు. నేను దానిని వారికి ఇస్తాను, వారు దానిని స్వాధీనం చేసుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","మీరైతే వెనుకకు తిరిగి ఎర్ర సముద్ర మార్గంలో అరణ్యంలోనికి ప్రయాణించండి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","అప్పుడు మీరు, “మేము యెహోవాకు వ్యతిరేకంగా పాపం చేశాము. మా దేవుడైన యెహోవా మాకు ఆజ్ఞాపించిన ప్రకారం మేము వెళ్లి పోరాడతాం” అని నాతో చెప్పి మీ ఆయుధాలను ధరించి కొండసీమ మీదికి వెళ్లడం సులభమనుకుని మీలో ప్రతి ఒక్కరు సిద్ధపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","అయితే యెహోవా నాతో, “యుద్ధానికి మీరు వెళ్లకండి. ఎందుకంటే నేను మీతో ఉండను. మీరు మీ శత్రువుల చేతిలో ఓడిపోతారు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","నేను మీతో ఆ సంగతి చెప్పాను కాని మీరు వినలేదు. యెహోవా ఆజ్ఞకు వ్యతిరేకంగా మీరు తిరుగుబాటు చేసి మీ అహంకారాన్ని బట్టి కొండసీమ ప్రాంతానికి ఎక్కి వెళ్లారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ఆ కొండల్లో నివసిస్తున్న అమోరీయులు మీ మీదికి వచ్చి కందిరీగల్లా మిమ్మల్ని శేయీరు నుండి హోర్మా వరకు తరిమికొట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","అప్పుడు మీరు తిరిగివచ్చి యెహోవా ఎదుట ఏడ్చారు కాని ఆయన మిమ్మల్ని లక్ష్యపెట్టలేదు మీ మొర వినలేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","కాబట్టి మీరు కాదేషులో చాలా రోజులు ఉండిపోయారు. అక్కడ ఎన్ని రోజులు నివసించారో మీకు తెలుసు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","యెహోవా నాతో చెప్పిన ప్రకారం మనం వెనుకకు తిరిగి ఎర్ర సముద్ర మార్గంలో అరణ్యంలోనికి ప్రయాణమై వెళ్లి చాలా రోజులు శేయీరు కొండ ప్రాంతం చుట్టూ తిరిగాము. ");
INSERT INTO telotsa_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","అప్పుడు యెహోవా నాతో ఇలా అన్నారు, ");
INSERT INTO telotsa_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“మీరు ఈ కొండ ప్రాంతం చుట్టూ తిరిగింది చాలు; ఉత్తరం వైపు తిరగండి. ");
INSERT INTO telotsa_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ప్రజలకు ఈ ఆదేశాలు ఇవ్వు: ‘శేయీరులో నివసిస్తున్న ఏశావు సంతానమైన మీ బంధువుల భూభాగం గుండా వెళ్లబోతున్నారు. వారు మీకు భయపడతారు, కానీ చాలా జాగ్రత్తగా ఉండండి. ");
INSERT INTO telotsa_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","వారితో ఘర్షణ పడకండి, ఎందుకంటే నేను వారి భూమిలో ఒక్క అడుగు కూడా మీకు ఇవ్వను. నేను ఏశావుకు స్వాస్థ్యంగా శేయీరు కొండ ప్రాంతాన్ని ఇచ్చాను. ");
INSERT INTO telotsa_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","మీరు వారికి వెండి ఇచ్చి తినడానికి ఆహారం, త్రాగడానికి నీరు కొనుక్కోవాలి.’ ” ");
INSERT INTO telotsa_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","మీ దేవుడైన యెహోవా మీ చేతి పనులన్నిటిని ఆశీర్వదించారు, ఈ గొప్ప అరణ్యం గుండా మీ ప్రయాణాన్ని ఆయన చూసుకున్నారు. ఈ నలభై సంవత్సరాలు మీ దేవుడైన యెహోవా మీకు తోడుగా ఉన్నారు, మీకు ఏది తక్కువ కాలేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","శేయీరులో నివసిస్తున్న మన బంధువులైన ఏశావు సంతతివారిని విడిచిపెట్టి ముందుకు సాగాము. ఏలతు, ఎసోన్-గెబెరు నుండి వచ్చే అరాబా మార్గం నుండి మనం బయలుదేరి మోయాబు ఎడారి మార్గంలో ప్రయాణించాము. ");
INSERT INTO telotsa_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","అప్పుడు యెహోవా నాతో అన్నారు, “మోయాబీయులను బాధపెట్టకండి లేదా వారితో ఘర్షణ పడకండి, ఎందుకంటే వారి భూమిలో మీకు ఏమి ఇవ్వను. నేను లోతు సంతానానికి ఆరు దేశాన్ని స్వాస్థ్యంగా ఇచ్చాను.” ");
INSERT INTO telotsa_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","గతంలో ఎమీయులు ఆ దేశంలో నివసించేవారు, వారు బలవంతులు అనేకమంది, వారు అనాకీయుల్లా పొడవైనవారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","అనాకీయుల్లా వారిని కూడా రెఫాయీయులుగా పరిగణించేవారు కాని మోయాబీయులు వారికి ఎమీయులు అని పేరు పెట్టారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","గతంలో హోరీయులు శేయీరులో నివసించేవారు, అయితే ఏశావు సంతతివారు, ఇశ్రాయేలీయులు యెహోవా తమకు స్వాస్థ్యంగా ఇచ్చిన దేశంలో చేసినట్లుగా, వారిని తరిమివేశారు. వారు హోరీయులను తమ ఎదుట నుండి నాశనం చేసి వారి దేశంలో స్థిరపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","యెహోవా అన్నారు, “ఇప్పుడు మీరు లేచి జెరెదు వాగు దాటండి.” కాబట్టి మనం వాగు దాటాము. ");
INSERT INTO telotsa_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","మనం కాదేషు బర్నియాలో నుండి బయలుదేరి జెరెదు వాగు దాటే వరకు ముప్పై ఎనిమిది సంవత్సరాలు గడిచాయి. యెహోవా వారికి ప్రమాణం చేసిన రీతిగా, సైనికులుగా ఉన్న వారి తరమంతా అప్పటి శిబిరం నుండి నశించిపోయింది. ");
INSERT INTO telotsa_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ఆయన వారిని శిబిరంలో నుండి పూర్తిగా తొలగించే వరకు యెహోవా చేయి వారికి వ్యతిరేకంగా ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ప్రజల మధ్యలో నుండి ఈ సైనికులు అందరు చనిపోయిన తర్వాత, ");
INSERT INTO telotsa_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","యెహోవా నాతో ఇలా చెప్పారు, ");
INSERT INTO telotsa_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“ఈ రోజు మీరు మోయాబుకు సరిహద్దుగా ఉన్న ఆరు దేశాన్ని దాటబోతున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","మీరు అమ్మోనీయుల దగ్గరకు వచ్చినప్పుడు, మీరు వారిని బాధించవద్దు వారిని యుద్ధానికి రెచ్చగొట్టవద్దు. ఎందుకంటే అమ్మోనీయులకు చెందిన దేశంలో ఏది మీకు ఇవ్వను. ఆ దేశాన్ని నేను లోతు సంతతికి స్వాస్థ్యంగా ఇచ్చాను.” ");
INSERT INTO telotsa_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","అది కూడా రెఫాయీయుల దేశం అని పరిగణించబడింది; గతంలో రెఫాయీయులు అక్కడ నివసించేవారు. అయితే అమ్మోనీయులు వారికి జంజుమ్మీయులు అని పిలిచేవారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","వారు బలవంతులు, అనేకమంది, అనాకీయుల్లా పొడువైనవారు. యెహోవా అమ్మోనీయుల ఎదుట నుండి వారిని వెళ్లగొట్టారు, కాబట్టి అమ్మోనీయులు వారి దేశాన్ని స్వాధీనం చేసుకుని వారి దేశంలో స్థిరపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","శేయీరులో నివసిస్తున్న ఏశావు సంతానం కోసం కూడా యెహోవా ఇలాగే చేశారు. ఆయన వారి ఎదుట నుండి హోరీయులను నాశనం చేశారు, కాబట్టి వారు వారిని తరిమి ఇప్పటివరకు వారి దేశంలో నివసిస్తున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","గాజా వరకు గ్రామాల్లో నివసించిన ఆవీయులను కఫ్తోరులో నుండి వచ్చిన కఫ్తోరీయులు నాశనం చేసి వారి దేశంలో స్థిరపడ్డారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“మీరు లేచి బయలుదేరి అర్నోను వాగు దాటండి. చూడండి, అమోరీయుడైన హెష్బోను రాజైన సీహోనును అతని దేశాన్ని మీ చేతికి అప్పగించాను. దానిని స్వాధీనం చేసుకోవడం మొదలుపెట్టి అతనితో యుద్ధం చేయండి. ");
INSERT INTO telotsa_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ఈ రోజే నేను ఆకాశం క్రింద ఉన్న అన్ని దేశాలకు మీరంటే భయాన్ని, వణుకుని కలిగించడం మొదలుపెడతాను. వారు మీ గురించి సమాచారాన్ని విని వణుకుతారు; మీ కారణంగా వారు కలవరపడతారు.” ");
INSERT INTO telotsa_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","కెదేమోతు ఎడారి నుండి నేను హెష్బోను రాజైన సీహోను దగ్గరకు దూతలను పంపి సమాధానాన్ని తెలియజేశాను, ");
INSERT INTO telotsa_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“మీ దేశం మీదుగా మమ్మల్ని వెళ్లనివ్వండి. మేము కుడి ఎడమల వైపు తిరగము, రహదారి మీదనే వెళ్తాము. ");
INSERT INTO telotsa_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","మా దగ్గర నుండి వెండి తీసుకుని తినడానికి ఆహారం త్రాగడానికి నీళ్లు ఇవ్వండి. మమ్మల్ని కాలినడకన వెళ్లనివ్వండి. ");
INSERT INTO telotsa_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","శేయీరులో నివసించే ఏశావు సంతతివారు ఆరులో మోయాబీయులు మాకు చేసినట్టే మా దేవుడైన యెహోవా మాకు ఇస్తున్న దేశానికి వెళ్లడానికి కాలినడకన యొర్దాను దాటి వెళ్లనివ్వండి” అని తెలియజేశాను. ");
INSERT INTO telotsa_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","అయితే హెష్బోను రాజైన సీహోను మనం అతని దేశం గుండా వెళ్లడానికి అనుమతించలేదు. ఎందుకంటే ఇప్పుడు జరిగినట్లుగా అతన్ని మీ చేతికి అప్పగించడానికి మీ దేవుడైన యెహోవా అతని మనస్సు కఠినపరచి అతని హృదయాన్ని మొండిగా మార్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","అప్పుడు యెహోవా నాతో అన్నారు, “చూడండి, నేను సీహోనును, అతని దేశాన్ని మీకు అప్పగించడం మొదలుపెట్టాను. అతని దేశాన్ని జయించి స్వాధీనం చేసుకోవడం మొదలుపెట్టండి.” ");
INSERT INTO telotsa_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","సీహోను అతని సైన్యమంతా యాహాజులో మనతో యుద్ధం చేయడానికి వచ్చినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","మన దేవుడైన యెహోవా అతన్ని మనకు అప్పగించారు కాబట్టి అతన్ని, అతని కుమారులను, అతని సైన్యమంతటిని మనం హతం చేశాము. ");
INSERT INTO telotsa_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ఆ సమయంలో అతని పట్టణాలన్నిటిని, వాటిలో ఉన్న పురుషులు, స్త్రీలు, పిల్లలు ఎవరు మిగులకుండా పూర్తిగా నాశనం చేశాము. ");
INSERT INTO telotsa_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","అయితే మన కోసం పశువులను, ఆ పట్టణాల సొమ్మును దోచుకున్నాము. ");
INSERT INTO telotsa_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","అర్నోను వాగు ఒడ్డున ఉన్న అరోయేరు నుండి, ఆ వాగు దగ్గర ఉన్న పట్టణం మొదలుపెట్టి గిలాదు వరకు మనలను మించి బలం కలిగిన పట్టణం ఒకటి కూడా లేదు. మన దేవుడైన యెహోవా వాటన్నిటిని మనకు అప్పగించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","అయితే మన దేవుడైన యెహోవా ఆజ్ఞ ప్రకారం అమ్మోనీయుల దేశాన్ని కాని యబ్బోకు వాగు లోయలోని ఏ ప్రాంతాన్ని కాని కొండల్లో ఉన్న పట్టణాలను కాని మీరు ఆక్రమించలేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","తర్వాత మనం తిరిగి బాషానుకు వెళ్లే మార్గంలో వెళ్లాము. అప్పుడు బాషాను రాజైన ఓగు తన సైన్యమంతటితో ఎద్రెయీ దగ్గర యుద్ధంలో మనలను ఎదుర్కోడానికి బయలుదేరాడు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","యెహోవా నాతో, “అతనికి భయపడకండి, ఎందుకంటే అతన్ని, అతని సైన్యమంతటిని, అతని దేశాన్ని మీ చేతికి అప్పగించాను. హెష్బోనును పరిపాలించిన అమోరీయుల రాజైన సీహోనుకు చేసినట్లు అతనికి చేయండి” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","కాబట్టి మన దేవుడైన యెహోవా బాషాను రాజైన ఓగును, అతని సైన్యమంతటిని మన చేతికి అప్పగించారు. వారిలో ఎవరిని మిగల్చకుండా అందరిని హతం చేశాము. ");
INSERT INTO telotsa_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ఆ సమయంలో అతని పట్టణాలన్నిటిని మనం స్వాధీనం చేసుకున్నాము. బాషానులో ఓగు రాజ్యమైన అర్గోబు ప్రాంతమంతటిలో ఉన్న అరవై పట్టణాల్లో స్వాధీనం చేసుకోనిది ఒక్కటి కూడా లేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ఈ పట్టణాలన్ని ఎత్తైన గోడలు, ద్వారాలు గడియలతో పటిష్టంగా ఉన్నాయి, వీటితో పాటు గోడలులేని అనేక గ్రామాలు కూడా ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","హెష్బోను రాజైన సీహోనుకు చేసినట్లే ప్రతి పట్టణంలోని స్త్రీ పురుషులు, పిల్లలను పూర్తిగా నాశనం చేశాము. ");
INSERT INTO telotsa_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","అయితే మన కోసం పశువులన్నిటిని, వారి పట్టణాల నుండి సొమ్మును దోచుకున్నాము. ");
INSERT INTO telotsa_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ఆ సమయంలో ఈ ఇద్దరు అమోరీయుల రాజుల నుండి అర్నోను వాగు మొదలుకొని హెర్మోను పర్వతం వరకు యొర్దానుకు తూర్పున ఉన్న ప్రాంతాన్ని స్వాధీనం చేసుకున్నాము. ");
INSERT INTO telotsa_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","హెర్మోనును సీదోనీయులు షిర్యోను అంటారు; అమోరీయులు శెనీరు అని పిలుస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","పీఠభూమిలో ఉన్న పట్టణాలన్నిటిని, బాషానులో ఓగు రాజ్యంలోని పట్టణాలైన సలేకా ఎద్రెయీల వరకు గిలాదు అంతటిని, బాషానును అంతటిని స్వాధీనం చేసుకున్నాము. ");
INSERT INTO telotsa_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","రెఫాయీయులలో బాషాను రాజైన ఓగు చివరివాడు. అతని సమాధి ఇనుముతో చేయబడి తొమ్మిది మూరల పొడవు నాలుగు మూరల వెడల్పు కలది. అది ఇంకా అమ్మోనీయులకు చెందిన రబ్బాలో ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ఆ సమయంలో మనం స్వాధీనం చేసుకున్న దేశాన్ని అనగా అర్నోను వాగు లోయలో ఉన్న అరోయేరు నుండి గిలాదు కొండ ప్రాంతంలోని సగభాగాన్ని దానిలో ఉన్న పట్టణాలతో కలిపి రూబేనీయులకు గాదీయులకు ఇచ్చాను. ");
INSERT INTO telotsa_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","గిలాదులో మిగతా ప్రాంతాన్ని, ఓగు రాజ్యమైన బాషాను అంతటిని మనష్షే అర్ధగోత్రానికి ఇచ్చాను. బాషానులోని అర్గోబు ప్రాంతమంతా రెఫాయీయుల దేశమని పిలువబడేది. ");
INSERT INTO telotsa_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","మనష్షే సంతానమైన యాయీరు అర్గోబు ప్రాంతమంతా గెషూరీయుల మయకాతీయుల సరిహద్దుల వరకు స్వాధీనపరచుకున్నాడు. దానికి అతని పేరు పెట్టబడింది కాబట్టి నేటికీ బాషాను హవ్వోత్ యాయీరు అని పిలుస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","గిలాదును మాకీరుకు ఇచ్చాను. ");
INSERT INTO telotsa_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","అయితే రూబేనీయులకు, గాదీయులకు గిలాదు నుండి అర్నోను వాగు లోయ మధ్య వరకు, యబ్బోకు నది వరకు, అమ్మోనీయుల సరిహద్దు వరకు నేను ఇచ్చాను. ");
INSERT INTO telotsa_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","దాని పశ్చిమ సరిహద్దు కిన్నెరెతు నుండి పిస్గా కొండచరియల తూర్పున, మృత సముద్రమనే అరాబా సముద్రం వరకు వ్యాపించి ఉన్న అరాబాలోని యొర్దాను నది. ");
INSERT INTO telotsa_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ఆ సమయంలో నేను యొర్దాను తూర్పున నివసిస్తున్న గోత్రాలకు మీకు ఇలా ఆజ్ఞాపించాను: “మీ దేవుడైన యెహోవా మీరు స్వాధీనం చేసుకోవడానికి మీకు ఈ దేశాన్ని ఇచ్చారు. అయితే మీలో ధృడమైనవారు, యుద్ధానికి సిద్ధపడినవారు ఇతర ఇశ్రాయేలీయులకు ముందుగా నది దాటాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","20","అయితే యెహోవా మీకు విశ్రాంతి ఇచ్చినట్టు మీ సోదరులకును విశ్రాంతి ఇచ్చేవరకు, అంటే యొర్దాను అవతల మీ దేవుడైన యెహోవా వారికి ఇస్తున్న దేశాన్ని వారు స్వాధీనం చేసుకునేవరకు మీ భార్యలు, మీ పిల్లలు మీ పశువులు నేను మీకిచ్చిన పట్టణాల్లోనే ఉండాలి. ఆ తర్వాత నేను మీకు ఇచ్చిన స్వాస్థ్యాలకు ప్రతి ఒక్కరు తిరిగి వెళ్లవచ్చు.” ");
INSERT INTO telotsa_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ఆ సమయంలో నేను యెహోషువకు ఆజ్ఞాపించాను: “నీవు నీ కళ్లారా దేవుడైన యెహోవా ఈ ఇద్దరు రాజులకు చేసిందంతా చూశావు. నీవు వెళ్లబోయే చోటులో ఉన్న అన్ని రాజ్యాలకు యెహోవా అలాగే చేస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","వారికి నీవు భయపడకు; నీ దేవుడైన యెహోవా మీ పక్షంగా యుద్ధం చేస్తారు.” ");
INSERT INTO telotsa_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ఆ సమయంలో నేను యెహోవాను బ్రతిమాలుకున్నాను: ");
INSERT INTO telotsa_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“ప్రభువైన యెహోవా, మీ గొప్పతనాన్ని, మీ బలమైన చేతిని మీ సేవకునికి చూపించడం మొదలుపెట్టారు. ఆకాశంలో గాని భూమిమీదగాని మీరు చేసే పనులు, అద్భుతకార్యాలు చేయగల దేవుడెవరున్నారు? ");
INSERT INTO telotsa_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","నేను వెళ్లి యొర్దాను అవతల ఉన్న మంచి దేశాన్ని, మంచి కొండ ప్రాంతాన్ని, లెబానోనును చూడనివ్వండి.” ");
INSERT INTO telotsa_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","అయితే మీ కారణంగా యెహోవా నా మీద కోప్పడి, నా మొర వినలేదు. యెహోవా నాతో అన్నారు, “ఇక చాలు, ఈ విషయమై నాతో ఇక మాట్లాడవద్దు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","నీవు పిస్గా కొండ శిఖరం పైకెక్కి అక్కడినుండి పడమర, ఉత్తరం, దక్షిణం, తూర్పు వైపులకు చూడు. నీవు యొర్దాను నది దాటవు కాబట్టి నీ కళ్లారా ఆ దేశాన్ని చూడు. ");
INSERT INTO telotsa_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","అయితే యెహోషువను నియమించి, అతన్ని ప్రోత్సాహించి బలపరచు, ఎందుకంటే అతడు ఈ ప్రజలను నది దాటిస్తాడు, నీవు చూడబోయే దేశాన్ని వారు స్వాధీనపరచుకునేలా చేస్తాడు.” ");
INSERT INTO telotsa_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","కాబట్టి మనం బేత్-పెయోరు దగ్గర ఉన్న లోయలో ఉన్నాము. ");
INSERT INTO telotsa_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ఇప్పుడు, ఇశ్రాయేలూ, నేను మీకు బోధించే శాసనాలు చట్టాలను వినండి. మీరు జీవించి, మీ పూర్వికుల దేవుడైన యెహోవా మీకు ఇస్తున్న దేశంలోకి వెళ్లి స్వాధీనం చేసుకోవడానికి వాటిని అనుసరించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","నేను మీకు ఆజ్ఞాపించిన మాటతో దేన్ని కలుపకూడదు, దాని నుండి దేన్ని తీసివేయకూడదు, కాని నేను మీకు ఇస్తున్న మీ దేవుడైన యెహోవా ఆజ్ఞలను పాటించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","బయల్-పెయోరు విషయంలో యెహోవా చేసిన దానిని మీరు కళ్లారా చూశారు. బయల్-పెయోరును వెంబడించిన వారందరిని మీ దేవుడైన యెహోవా మీ మధ్యలో ఉండకుండా నాశనం చేశారు, ");
INSERT INTO telotsa_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","కాని మీ దేవుడైన యెహోవాను నమ్మకంగా పట్టుకుని ఉన్న మీరందరు ఈ రోజు వరకు బ్రతికి ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","చూడండి, నా దేవుడైన యెహోవా నాకు ఆజ్ఞాపించిన ప్రకారం మీరు స్వాధీనం చేసుకోబోయే దేశంలో మీరు పాటించవలసిన శాసనాలను చట్టాలను నేను మీకు బోధించాను. ");
INSERT INTO telotsa_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","వాటిని జాగ్రతగా పాటించండి. ఈ శాసనాలన్నిటి గురించి వినే దేశాలకు అవే మీ జ్ఞానాన్ని మీ వివేకాన్ని తెలియజేస్తాయి; వారు, “ఈ గొప్ప దేశం ఖచ్చితంగా జ్ఞానం వివేకం కలిగిన ప్రజలు” అని చెప్పుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","మనం ఆయనకు ప్రార్థన చేసినప్పుడు మన దేవుడైన యెహోవా మనకు సమీపంగా ఉన్నట్లు మరి ఏ గొప్పప్రజలకు వారి దేవుళ్ళు సమీపంగా ఉంటారు? ");
INSERT INTO telotsa_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ఈ రోజు నేను మీ ఎదుట పెట్టిన ఈ ధర్మశాస్త్రమంతటిలో నీతిగల శాసనాలు, చట్టాలు ఏ గొప్ప దేశం కలిగి ఉంది? ");
INSERT INTO telotsa_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","అయితే జాగ్రత్తగా ఉండండి, మీరు మీ కళ్లారా చూసినవాటిని మరచిపోకుండా, మీరు జీవితాంతం మీ హృదయంలోనుండి చెరిగిపోకుండా జాగ్రత్త వహించండి. మీ పిల్లలకు వారి తర్వాత వారి పిల్లలకు వాటిని బోధించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","హోరేబు దగ్గర మీ దేవుడైన యెహోవా ఎదుట మీరు నిలబడినప్పుడు ఆయన నాతో, “వారు ఆ దేశంలో జీవించినంత వరకు నాకు భయపడడం నేర్చుకొని, వాటిని తమ పిల్లలకు నేర్పేలా వారు నా మాటలు వినడానికి ప్రజలందర్ని సమకూర్చు” అని చెప్పిన రోజును జ్ఞాపకం ఉంచుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","మీరంతా దగ్గరకు వచ్చి ఆ పర్వతం క్రింద నిలబడ్డారు, అది దట్టమైన మేఘాలు, కటిక చీకటి కమ్మి, ఆకాశం వరకు అగ్నితో మండుతూ ఉంది, ");
INSERT INTO telotsa_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","యెహోవా ఆ అగ్నిలో నుండి మీతో మాట్లాడారు. మీరు మాటల శబ్దం విన్నారు కాని ఏ రూపాన్ని మీరు చూడలేదు; స్వరం మాత్రమే వినిపించింది. ");
INSERT INTO telotsa_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ఆయన మీకు తన నిబంధనను ప్రకటించారు, అనగా మీరు పాటించాలని పది ఆజ్ఞలు మీకు ఆజ్ఞాపించి, వాటిని రెండు రాతి పలకలమీద వ్రాశారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","మీరు యొర్దాను దాటి స్వాధీనం చేసుకోబోయే దేశంలో మీరు అనుసరించాల్సిన శాసనాలను చట్టాలను మీకు నేర్పించమని యెహోవా నాకు ఆదేశించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","అయితే చాలా జాగ్రతగా ఉండండి! హోరేబులో యెహోవా అగ్ని మధ్యలో నుండి మీతో మాట్లాడిన రోజున మీరు ఏ రూపాన్ని చూడలేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","మీ కోసం ఎలాంటి విగ్రహాన్ని, ఎలాంటి రూపంలో ఉన్న దానినైన, స్త్రీ లేదా పురుషుని రూపంలో కాని, ");
INSERT INTO telotsa_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","లేదా భూమి మీద ఉండే ఏ జంతువులా కాని, ఆకాశంలో ఎగిరే పక్షిలా కాని, ");
INSERT INTO telotsa_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","లేదా నేల మీద ప్రాకే ఏ ప్రాణిలా కాని, నీటి క్రింద ఉండే ఏ చేపలా కాని విగ్రహం తయారుచేసుకోకండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","మీరు ఆకాశం వైపు కళ్ళెత్తి ఆకాశ సైన్యాలైన సూర్యచంద్ర నక్షత్రాలను చూసిన వాటిచే ఆకర్షించబడి, మీ దేవుడైన యెహోవా ఆకాశం క్రింద సమస్త దేశాల కోసం పంచి ఇచ్చిన వాటికి నమస్కరించి వాటికి సేవచేయకుండ మీరు జాగ్రత్తపడండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","మీరైతే, యెహోవా మిమ్మల్ని పట్టుకుని నేడు మీరున్నట్లుగా ఆయన వారసత్వ ప్రజలుగా ఉండడానికి ఇనుప కొలిమిలో నుండి, ఈజిప్టు నుండి, మిమ్మల్ని బయటకు తీసుకువచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","మీ కారణంగా యెహోవా నా మీద కోప్పడి నేను ఈ యొర్దాను దాటకూడదని, మీ దేవుడైన యెహోవా మీకు స్వాస్థ్యంగా ఇస్తున్న మంచి దేశంలో ప్రవేశించకూడదని ఆయన ప్రమాణము చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","నేను ఈ దేశంలో చనిపోతాను; నేను యొర్దానును దాటను; కాని మీరు నది దాటి వెళ్లి ఆ మంచి దేశాన్ని స్వాధీనం చేసుకోబోతున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","మీ దేవుడైన యెహోవా మీతో చేసిన నిబంధనను మరచిపోకుండా జాగ్రత్తపడండి; మీ దేవుడైన యెహోవా నిషేధించిన వాటి యొక్క ఎలాంటి రూపంలోను మీ కోసం విగ్రహాన్ని చేసుకోకండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ఎందుకంటే మీ దేవుడైన యెహోవా దహించు అగ్ని, ఆయన రోషం గల దేవుడు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","మీకు పిల్లలు మనవళ్లు కలిగి, ఆ దేశంలో చాలా కాలం నివసించిన తర్వాత, మీరు అప్పుడు చెడిపోయి ఏ రూపంలోనైనా విగ్రహాన్ని చేసుకుని మీ దేవుడైన యెహోవా కళ్ళెదుట చెడు చేసి ఆయనకు కోపం పుట్టిస్తే, ");
INSERT INTO telotsa_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","మీరు ఈ యొర్దాను దాటి స్వాధీనం చేసుకోబోయే ఆ దేశంలో ఎక్కువకాలం నివసించకుండా వెంటనే నశిస్తారని ఈ రోజు ఆకాశాలను భూమిని మీమీద సాక్షులుగా ఉంచుతున్నాను. ఆ దేశంలో ఎక్కువకాలం నివసించరు ఖచ్చితంగా నశించిపోతారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","యెహోవా జనాంగాల మధ్యలో మిమ్మల్ని చెదరగొడతారు, యెహోవా మిమ్మల్ని తోలివేసే దేశాల మధ్యలో మీలో కొద్దిమంది మాత్రమే మిగులుతారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","అక్కడ మీరు మనుష్యులు తయారుచేసిన కర్ర, రాతి దేవుళ్ళను సేవిస్తారు. అవి చూడలేవు, వినలేవు, తినలేవు, వాసన చూడలేవు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","అయితే అక్కడినుండి మీరు మీ దేవుడైన యెహోవాను వెదికితే, మీ పూర్ణహృదయంతో మీ పూర్ణాత్మతో వెదికినప్పుడు ఆయన మీకు దొరుకుతారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","మీరు దుఃఖంలో ఉన్నప్పుడు, ఈ సంగతులన్ని మీకు జరిగిన తర్వాత, అప్పుడు చివరి రోజుల్లో మీరు మీ దేవుడైన యెహోవా వైపు తిరిగి ఆయన మాట వింటారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","మీ దేవుడైన యెహోవా జాలిగల దేవుడు; కాబట్టి ఆయన మిమ్మల్ని విడిచిపెట్టడు, మిమ్మల్ని నాశనం చేయడు, ఆయన మీ పూర్వికులతో ప్రమాణం ద్వార నిశ్చయం చేసిన నిబంధనను మరచిపోరు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","దేవుడు భూమి మీద నరుని సృజించిన రోజు నుండి, మీకంటే ముందు ఉన్న గత కాలం గురించి అడగండి; ఆకాశం యొక్క ఒక చివరి నుండి మరో చివరి వరకు అడగండి. ఇలాంటి గొప్ప కార్యం ఎప్పుడైనా జరిగిందా? లేదా అటువంటి దాని గురించి ఎప్పుడైనా విన్నారా? ");
INSERT INTO telotsa_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","అగ్ని మధ్యలో నుండి మాట్లాడిన దేవుని స్వరాన్ని మీరు విన్నట్లు మరి ఏ ప్రజలైనా విని బ్రతికారా? ");
INSERT INTO telotsa_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","మీ దేవుడైన యెహోవా ఈజిప్టులో మీ కళ్ళెదుట మీ కోసం శోధనలతో, సూచకక్రియలతో, అద్భుతాలతో, యుద్ధంతో, బలమైన హస్తంతో, చాచిన చేతితో మహా భయంకరమైన కార్యాలతో సమస్త కార్యాలను చేసినట్లు ఏ దేవుడైన తన కోసం ఒక దేశం నుండి మరొక దేశాన్ని బయటకు తీసుకువచ్చే ప్రయత్నం చేశాడా? ");
INSERT INTO telotsa_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","యెహోవాయే దేవుడని ఆయన తప్ప మరి ఎవరు లేరని మీరు తెలుసుకునేలా ఇవన్నీ మీకు చూపబడ్డాయి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","మిమ్మల్ని క్రమపరచడానికి ఆకాశం నుండి తన స్వరాన్ని మీకు వినిపించారు. భూమి మీద మీకు తన గొప్ప అగ్నిని చూపించారు, ఆ అగ్ని మధ్యలో నుండి ఆయన మాటలు మీరు విన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","38","ఆయన మీ పూర్వికులను ప్రేమించి వారి సంతతిని ఎంపిక చేసుకున్నారు కాబట్టి, మీకంటే బలమైన గొప్ప దేశాలను మీ ఎదుట నుండి వెళ్లగొట్టి, వారి దేశంలోనికి మిమ్మల్ని తీసుకువచ్చి, ఈ రోజు ఇస్తున్నట్లుగా వారి దేశాన్ని మీకు స్వాస్థ్యంగా ఇవ్వడానికి ఆయన తన సన్నిధితో, తన మహాబలంతో మిమ్మల్ని ఈజిప్టు నుండి బయటకు రప్పించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","కాబట్టి పైనున్న పరలోకంలో గాని, క్రిందున్న భూమిమీద గాని, యెహోవాయే దేవుడని, మరొక దేవుడు లేడని ఈ రోజే మీరు గుర్తించి, మీ హృదయాల్లో జ్ఞాపకం ఉంచుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","మీకు, మీ తర్వాత మీ సంతతివారికి క్షేమం కలగడానికి యెహోవా శాశ్వతంగా మీకు ఇస్తున్న దేశంలో మీరు అధిక కాలం జీవించేలా ఈ రోజు నేను మీకు ఇస్తున్న శాసనాలను ఆజ్ఞలను పాటించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","తర్వాత మోషే యొర్దానుకు తూర్పు వైపు ఉన్న మూడు పట్టణాలను ప్రత్యేకంగా ఉంచాడు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ఒక వ్యక్తిని చంపిన ఎవరైనా ఏ దురుద్దేశం లేకుండా పొరుగువారిని చంపినట్లయితే పారిపోవచ్చు. వారు ఈ పట్టణాల్లో ఒక దానికి పారిపోయి తమ ప్రాణాలను కాపాడుకోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ఆ పట్టణాలు ఇవి: రూబేనీయులకు అరణ్య పీఠభూమిలో ఉన్న బేసెరు; గాదీయులకు గిలాదులో ఉన్న రామోతు; మనష్షీయులకు బాషానులో ఉన్న గోలాను. ");
INSERT INTO telotsa_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","మోషే ఇశ్రాయేలీయులకు ఇచ్చిన ధర్మశాస్త్రం ఇది. ");
INSERT INTO telotsa_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","46","ఈ నిబంధనలు శాసనాలు చట్టాలు, ఇశ్రాయేలీయులు ఈజిప్టులో నుండి బయటకు వచ్చినప్పుడు యొర్దాను తూర్పున బేత్-పెయోరుకు ఎదురుగా ఉన్న లోయలో హెష్బోనులో పరిపాలించి, మోషే, ఇశ్రాయేలీయుల చేతిలో ఓడిపోయిన అమోరీయుల రాజైన సీహోను దేశంలో వారికి ఇవ్వబడినవి. ");
INSERT INTO telotsa_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","యొర్దానుకు తూర్పున ఉన్న అతని దేశాన్ని, బాషాను రాజైన ఓగు దేశాన్ని, ఈ ఇద్దరు అమోరీయుల రాజుల దేశాలను వారు స్వాధీనం చేసుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ఆ దేశం అర్నోను వాగు లోయ ఒడ్డున ఉన్న అరోయేరు నుండి హెర్మోను అనే సీయోను కొండ వరకు, ");
INSERT INTO telotsa_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","యొర్దాను తూర్పున ఉన్న అరాబా ప్రాంతమంతా, పిస్గా కొండచరియల దిగువగా ఉప్పు సముద్రం వరకు ఉంది. ");
INSERT INTO telotsa_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","మోషే ఇశ్రాయేలీయులందరిని పిలిపించి వారితో ఇలా చెప్పాడు: ఇశ్రాయేలూ, మీ వినికిడిలో నేను ప్రకటించే శాసనాలను, చట్టాలను వినండి. వాటిని నేర్చుకొని ఖచ్చితంగా పాటించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","మన దేవుడైన యెహోవా హోరేబులో మనతో నిబంధన చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","యెహోవా ఈ నిబంధన చేసింది మన పూర్వికులతో కాదు, మనతో, ఈ రోజు సజీవంగా ఉన్న మనందరితో చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ఆ పర్వతం మీద అగ్నిలో నుండి యెహోవా మీతో ముఖాముఖిగా మాట్లాడారు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","అయితే మీరు ఆ అగ్నికి భయపడి పర్వతం ఎక్కలేదు కాబట్టి యెహోవా మాట మీకు తెలియజేయడానికి నేను యెహోవాకు మీకు మధ్యలో నిలబడ్డాను. ఆయన ఇలా అన్నారు: ");
INSERT INTO telotsa_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“బానిస దేశమైన ఈజిప్టు నుండి మిమ్మల్ని బయటకు రప్పించిన మీ దేవుడనైన యెహోవాను నేనే. ");
INSERT INTO telotsa_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“నేను తప్ప వేరొక దేవుడు మీకు ఉండకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","పైన ఆకాశంలో గాని, క్రింద భూమిమీద గాని భూమి క్రింద నీళ్లలో గాని ఉన్న దేని రూపంలో మీరు మీకోసం ప్రతిమను చేసుకోకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","మీరు వాటికి నమస్కరించకూడదు పూజింపకూడదు; ఎందుకంటే నేను, మీ దేవుడనైన యెహోవాను, రోషం గల దేవుడను, నన్ను ద్వేషించినవారి విషయంలో మూడు నాలుగు తరాల వరకు తండ్రుల పాపం యొక్క శిక్షను వారి పిల్లల మీదికి రప్పిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","అయితే నన్ను ప్రేమించి నా ఆజ్ఞలను పాటించే వారికి వెయ్యి తరాల వరకు కరుణను చూపిస్తాను. ");
INSERT INTO telotsa_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","మీ దేవుడైన యెహోవా నామాన్ని అనవసరంగా ఉపయోగించకూడదు, ఎందుకంటే తన నామాన్ని అనవసరంగా ఉపయోగించే వారిని యెహోవా నిర్దోషులుగా వదిలేయరు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","యెహోవా మీకు ఆజ్ఞాపించినట్లు సబ్బాతు దినాన్ని పరిశుద్ధంగా పాటించడం జ్ఞాపకముంచుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ఆరు రోజులు మీరు కష్టపడి మీ పని అంతటిని చేసుకోవాలి, ");
INSERT INTO telotsa_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","కాని ఏడవ రోజు మీ దేవుడైన యెహోవాకు సబ్బాతు దినము. ఆ రోజు మీరు ఏ పని చేయకూడదు, మీరు గాని, మీ కుమారుడు లేదా కుమార్తె గాని, మీ దాసదాసీలు గాని, మీ ఎద్దు గాని, మీ గాడిద గాని, మీ పశువులు గాని, మీ పట్టణాల్లో ఉంటున్న విదేశీయులు గాని ఏ పని చేయకూడదు తద్వార మీలా మీ దాసదాసీలు విశ్రాంతి తీసుకుంటారు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","మీరు ఈజిప్టులో బానిసత్వంలో ఉన్నప్పుడు, మీ దేవుడైన యెహోవా బలమైన హస్తంతో, చాచిన చేతితో మిమ్మల్ని అక్కడినుండి బయటకు తీసుకువచ్చారని జ్ఞాపకం ఉంచుకోండి. కాబట్టి సబ్బాతు దినాన్ని పాటించమని మీ దేవుడైన యెహోవా మీకు ఆజ్ఞాపించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","మీ దేవుడైన యెహోవా మీకు ఇచ్చే దేశంలో మీరు దీర్ఘాయుష్మంతులై మీకు క్షేమం కలిగేలా మీ దేవుడైన యెహోవా మీకు ఆజ్ఞాపించిన ప్రకారం, మీ తండ్రిని తల్లిని గౌరవించాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","మీరు హత్య చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","మీరు వ్యభిచారం చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","మీరు దొంగతనం చేయకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","మీ పొరుగువారికి వ్యతిరేకంగా అబద్ధసాక్ష్యం చెప్పకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","మీ పొరుగువాని భార్యను మీరు ఆశించకూడదు. మీ పొరుగువాని ఇంటిని గాని స్థలాన్ని గాని అతని దాసుని గాని, దాసిని గాని, అతని ఎద్దును గాని గాడిదను గాని, మీ పొరుగువానికి చెందిన దేన్ని మీరు ఆశించకూడదు.” ");
INSERT INTO telotsa_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","ఈ ఆజ్ఞలు యెహోవా ఆ పర్వతం మీద అగ్ని, మేఘం, కటిక చీకటిలో నుండి గొప్ప స్వరంతో మీ సమాజమంతటికి ప్రకటించారు; ఆయన ఇంకా ఏది కలుపలేదు. ఆ తర్వాత ఆయన రెండు రాతి పలకల మీద వాటిని వ్రాసి నాకు ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ఆ పర్వతం అగ్నితో మండుతున్నప్పుడు, ఆ చీకటిలో నుండి స్వరాన్ని మీరు విన్నప్పుడు, మీ గోత్రాల నాయకులందరు, మీ పెద్దలు నా దగ్గరకు వచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","మీరు నాతో అన్నారు, “మన దేవుడైన యెహోవా తన మహిమను తన ఘనతను మాకు చూపించారు, అగ్నిలో నుండి ఆయన స్వరాన్ని మేము విన్నాము. దేవుడు మనుష్యులతో మాట్లాడినా వారు బ్రతికే ఉంటారని ఈ రోజు మేము చూశాము. ");
INSERT INTO telotsa_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","అయితే ఇప్పుడు మేమెందుకు చావాలి? ఈ గొప్ప అగ్ని మమ్మల్ని కాల్చివేస్తుంది, మేము మన దేవుడైన యెహోవా స్వరాన్ని ఇంకా వింటే చనిపోతాము. ");
INSERT INTO telotsa_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","మేము విన్నట్లు మానవులలో ఎవరైనా సజీవుడైన దేవుని స్వరం అగ్నిలో నుండి మాట్లాడడం విని బ్రతికి ఉన్నారా? ");
INSERT INTO telotsa_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","నీవే దగ్గరకు వెళ్లి మన దేవుడైన యెహోవా చెప్పినదంతా విను. తర్వాత మన దేవుడైన యెహోవా నీకు చెప్పినదంతా నీవు మాకు చెప్పు, మేము వింటాము, లోబడతాము.” ");
INSERT INTO telotsa_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","మీరు నాతో మాట్లాడినప్పుడు యెహోవా మీ మాటలు విన్నారు, యెహోవా నాతో ఇలా అన్నారు, “ఈ ప్రజలు నీతో చెప్పిన మాటలు నేను విన్నాను. వారు చెప్పిందంతా మంచిదే. ");
INSERT INTO telotsa_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","వారికి వారి సంతతికి నిరంతరం క్షేమం కలిగేలా వారు నా పట్ల భయం కలిగి, నా ఆజ్ఞలన్నిటిని అనుసరించే హృదయం వారికుంటే ఎంతో మంచిది. ");
INSERT INTO telotsa_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“నీవు వెళ్లి, వారి గుడారలకు వారిని తిరిగి వెళ్లమని చెప్పు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","అయితే నీవు ఇక్కడ నాతో ఉండు, ఎందుకంటే వారు స్వాధీనం చేసుకోవడానికి నేను వారికి ఇస్తున్న దేశంలో పాటించేలా నీవు బోధించాల్సిన ఆజ్ఞలు, శాసనాలు చట్టాలు నీకు ఇస్తాను.” ");
INSERT INTO telotsa_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","కాబట్టి మీ దేవుడైన యెహోవా ఆజ్ఞాపించిన వాటిని చేయడంలో జాగ్రత్త వహించండి; కుడికి గాని ఎడమకు గాని తిరగకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","మీరు స్వాధీనం చేసుకోబోయే దేశంలో మీరు జీవిస్తూ, అభివృద్ధి పొందుతూ, ఎక్కువకాలం జీవించేలా, మీ దేవుడైన యెహోవా మీకు ఆజ్ఞాపించిన మార్గంలో నడవండి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","మీరు యొర్దాను దాటి స్వాధీనపరుచుకోబోయే దేశంలో మీరు పాటించాలని మీకు బోధించమని మీ దేవుడైన యెహోవా నాకు నిర్దేశించిన ఆజ్ఞలు, శాసనాలు చట్టాలు ఇవే. ");
INSERT INTO telotsa_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","మీరు, మీ పిల్లలు, వారి పిల్లలు జీవితకాలమంతా మీ దేవుడైన యెహోవాకు భయపడి, నేను మీకు ఇచ్చే ఆయన శాసనాలు, ఆజ్ఞలు పాటించడం ద్వారా మీరు దీర్ఘాయువును అనుభవిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ఇశ్రాయేలూ విను, మీ పూర్వికుల దేవుడైన యెహోవా మీకు వాగ్దానం చేసిన రీతిగా పాలు తేనెలు ప్రవహించే దేశంలో మీకు శ్రేయస్సు కలిగి అధికంగా అభివృద్ధి కలిగేలా మీరు వాటికి లోబడి ఉండేలా జాగ్రత్త వహించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","ఓ ఇశ్రాయేలీయులారా, వినండి: మన దేవుడైన యెహోవా, యెహోవా ఒక్కరే. ");
INSERT INTO telotsa_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","మీ పూర్ణహృదయంతో, మీ పూర్ణాత్మతో, మీ పూర్ణబలంతో మీ దేవుడైన యెహోవాను ప్రేమించాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ఈ రోజు నేను మీకు ఇస్తున్న ఈ ఆజ్ఞలు మీ హృదయాల్లో నిలిచి ఉండాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","వాటిని మీ పిల్లలకు నేర్పించాలి. మీరు ఇంటి దగ్గర కూర్చున్నప్పుడు, దారిలో నడుస్తున్నప్పుడు, మీరు పడుకున్నప్పుడు, లేచినప్పుడు, వాటి గురించి మాట్లాడాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","వాటిని సూచనలుగా మీ చేతికి కట్టుకోండి, మీ నుదిటి మీద బాసికాలుగా కట్టుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","మీ ఇళ్ళ ద్వారబంధాల మీద, ద్వారాల మీద వాటిని వ్రాయండి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","మీ దేవుడైన యెహోవా మీ పితరులైన అబ్రాహాము, ఇస్సాకు, యాకోబులతో ప్రమాణం చేసిన రీతిగా మిమ్మల్ని ఆ దేశంలోనికి తీసుకువచ్చి మీరు కట్టని విశాలమైన మంచి పట్టణాలను, ");
INSERT INTO telotsa_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","మీరు సమకూర్చని అన్ని రకాల మంచి వస్తువులతో నిండిన ఇళ్ళను, మీరు తవ్వని బావులను, మీరు నాటని ద్రాక్షతోటలు, ఒలీవల తోటలను మీకు ఇస్తారు; మీరు తిని తృప్తిపొందిన తర్వాత, ");
INSERT INTO telotsa_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","బానిస దేశమైన ఈజిప్టులో నుండి మిమ్మల్ని బయటకు తీసుకువచ్చిన యెహోవాను మరచిపోకుండా జాగ్రత్తగా ఉండండి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","మీ దేవుడైన యెహోవాకు భయపడి, ఆయనను మాత్రమే సేవించి, ఆయన పేరిట మాత్రమే మీరు ప్రమాణం చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","ఇతర దేవుళ్ళను అనగా మీ చుట్టూ ఉన్న ప్రజల దేవుళ్ళను అనుసరించకూడదు; ");
INSERT INTO telotsa_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","మీ మధ్యనున్న మీ దేవుడైన యెహోవా రోషం గల దేవుడు, ఆయన కోపం మీమీద రగులుకొని దేశంలో ఉండకుండా ఆయన మిమ్మల్ని నాశనం చేస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","మీరు మస్సాలో మీ దేవుడైన యెహోవాను పరీక్షించినట్లు ఆయనను పరీక్షించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","మీ దేవుడైన యెహోవా ఆజ్ఞలను, అనగా ఆయన మీకు ఇచ్చిన నిబంధనలను, శాసనాలను జాగ్రత్తగా పాటించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","19","మీకు మేలు కలిగేలా యెహోవా చెప్పినట్లు మీ శత్రువులందరిని మీ ఎదుట నుండి తరిమివేసి యెహోవా మీ పూర్వికులతో ప్రమాణం చేసిన ఆ మంచి దేశంలో మీరు ప్రవేశించి దానిని స్వాధీనం చేసుకోవాలంటే మీరు యెహోవా దృష్టికి యథార్థమైనది ఉత్తమమైనది చేయాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","భవిష్యత్తులో, “మన దేవుడైన యెహోవా మనకు ఆజ్ఞాపించిన నిబంధనలు, శాసనాలు, చట్టాలకు అర్థం ఏంటి?” అని మీ పిల్లలు మిమ్మల్ని అడిగినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","మీరు వారితో, “మనం ఈజిప్టులో ఫరోకు బానిసలుగా ఉన్నప్పుడు, యెహోవా బలమైన హస్తంతో మనలను ఈజిప్టులో నుండి బయటకు తీసుకువచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","మన కళ్లముందు యెహోవా ఈజిప్టు మీద, ఫరో మీద, అతని ఇంటివారందరి మీద గొప్ప, భయంకరమైన అసాధారణ గుర్తులను, అద్భుతాలను చేశారు. ");
INSERT INTO telotsa_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ఆయన మన పూర్వికులతో ప్రమాణం చేసిన దేశంలోనికి మనలను తీసుకువచ్చి దానిని మనకు ఇవ్వడానికి అక్కడినుండి మనలను బయటకు తీసుకువచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","మనం ఎల్లప్పుడు వర్ధిల్లుతూ, నేడు ఉన్నట్లుగా మనం బ్రతికి ఉండడానికి ఈ శాసనాలన్నిటికి లోబడి మన దేవుడైన యెహోవాకు భయపడమని యెహోవా మనకు ఆజ్ఞాపించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","మన దేవుడైన యెహోవా మనకు ఆజ్ఞాపించినట్లు ఆయన ఎదుట మనం ఈ ఆజ్ఞలన్నిటిని జాగ్రత్తగా అనుసరిస్తే అది మనకు నీతిగా పరిగణించబడుతుంది” అని చెప్పండి. ");
INSERT INTO telotsa_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","మీరు స్వాధీనం చేసుకోబోయే దేశంలోనికి మీ దేవుడైన యెహోవా మిమ్మల్ని తీసుకువచ్చి, మీ ఎదుట నుండి అనేక జనాంగాలను అనగా మీకన్నా విస్తారమైన, బలమైన ఏడు జనాంగాలను హిత్తీయులు, గిర్గాషీయులు, అమోరీయులు, కనానీయులు, పెరిజ్జీయులు, హివ్వీయులు, యెబూసీయులను వెళ్లగొట్టి, ");
INSERT INTO telotsa_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","మీ దేవుడైన యెహోవా వారిని మీకు అప్పగించగా, మీరు వారిని ఓడించినప్పుడు, వారిని పూర్తిగా నాశనం చేయాలి. వారితో సంధి చేసుకోకూడదు వారిని కరుణించకూడదు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","వారితో పెళ్ళి సంబంధాలు పెట్టుకోవద్దు. వారి కుమారులకు మీ కుమార్తెలను ఇవ్వకూడదు, మీ కుమారులకు వారి కుమార్తెలను పుచ్చుకోకూడదు, ");
INSERT INTO telotsa_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ఎందుకంటే వారు నన్ను అనుసరించకుండా ఇతర దేవుళ్ళను సేవించేలా మీ పిల్లలను త్రిప్పివేస్తారు, అప్పుడు యెహోవా కోపం మీమీద రగులుకొని మిమ్మల్ని త్వరగా నాశనం చేస్తుంది. ");
INSERT INTO telotsa_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","మీరు వారికి ఇలా చేయాలి: వారి బలిపీఠాలను పడగొట్టండి, వారి పవిత్ర రాళ్లను పగులగొట్టండి, వారి అషేరా స్తంభాలను ముక్కలు చేయండి, వారి విగ్రహాలను అగ్నితో కాల్చివేయండి. ");
INSERT INTO telotsa_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","ఎందుకంటే, మీరు మీ దేవుడైన యెహోవాకు పరిశుద్ధ ప్రజలు. ఈ భూమి మీద ప్రజలందరిలో నుండి మీ దేవుడైన యెహోవా మిమ్మల్ని తన సొంత ప్రజలుగా, విలువైన ఆస్తిగా ఎన్నుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","మీరు ఇతర జనాంగాల కంటే ఎక్కువగా ఉన్నారని కాదు జనాంగాలన్నిటిలో మీరే తక్కువగా ఉన్నారని యెహోవా మిమ్మల్ని ప్రేమించి ఏర్పరచుకున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","అయితే యెహోవా మిమ్మల్ని ప్రేమించారు కాబట్టి, మీ పూర్వికులతో చేసిన ప్రమాణం నెరవేర్చారు కాబట్టి, తన బలమైన హస్తంతో మిమ్మల్ని బయటకు తీసుకువచ్చి బానిస దేశం నుండి, ఈజిప్టు రాజైన ఫరో శక్తి నుండి మిమ్మల్ని విడిపించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","కాబట్టి మీ దేవుడైన యెహోవాయే దేవుడని తెలుసుకోండి; ఆయన నమ్మదగిన దేవుడు, తనను ప్రేమిస్తూ, తన ఆజ్ఞలను పాటించే వారికి, ఆయన వెయ్యి తరాల వరకు తన నిబంధన స్థిరపరిచేవారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","అయితే, తనను ద్వేషించేవారిని నేరుగా నాశనం చేస్తారు; ఆలస్యం చేయకుండా నేరుగా వారికి ప్రతిఫలం చెల్లిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","కాబట్టి ఈ రోజు నేను మీకు ఆజ్ఞాపిస్తున్న ఆజ్ఞలు, శాసనాలు, చట్టాలను జాగ్రత్తగా అనుసరించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","మీరు ఈ చట్టాలను శ్రద్ధగా విని వాటిని జాగ్రత్తగా అనుసరిస్తే, మీ దేవుడైన యెహోవా మీ పూర్వికులకు ప్రమాణం చేసినట్లుగా, మీతో తన ప్రేమ నిబంధనను కొనసాగిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ఆయన మిమ్మల్ని ప్రేమించి దీవించి అభివృద్ధి కలుగజేస్తారు. మీకు ఇస్తానని మీ పూర్వికులకు ప్రమాణం చేసిన దేశంలో, మీ గర్భఫలాన్ని, మీ భూఫలమైన మీ ధాన్యం, క్రొత్త ద్రాక్షరసం, ఒలీవనూనె, పశువుల దూడలను, మందల గొర్రెపిల్లలను దీవిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ఇతర ప్రజలకన్నా అధికంగా మీరు ఆశీర్వదించబడతారు; మీలో పురుషులలో కాని స్త్రీలలో కాని సంతానలేమి ఉండదు, మీ పశువుల్లో కూడా ఉండదు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","యెహోవా మిమ్మల్ని ప్రతీ వ్యాధి నుండి కాపాడతారు. ఈజిప్టులో మీకు తెలిసిన భయంకరమైన రోగాల మీ మీదికి రాకుండా చేస్తారు, కాని మిమ్మల్ని ద్వేషించే వారందరి మీదికి వాటిని రప్పిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","మీ దేవుడైన యెహోవా మీకు అప్పగించే ప్రజలందరినీ పూర్తిగా నాశనం చేయాలి. వారి మీద దయ చూపించకూడదు, వారి దేవుళ్ళను సేవించకూడదు, ఎందుకంటే అది మీకు ఉరిగా బిగుసుకుంటుంది. ");
INSERT INTO telotsa_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“ఈ జనాంగాలు మా కన్నా బలవంతులు. మేము వారినెలా వెళ్లగొట్టగలము?” అని మీలో మీరు అనుకోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","అయితే వారికి భయపడకండి; మీ దేవుడైన యెహోవా ఫరోకు, ఈజిప్టు దేశమంతటికి చేసింది జాగ్రతగా జ్ఞాపకం చేసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","గొప్ప శోధనలు, సూచకక్రియలు, అద్భుతాలు, బలమైన హస్తం చాచిన చేతితో మీ దేవుడైన యెహోవా మిమ్మల్ని బయటకు తీసుకురావడం మీ కళ్లతో మీరే చూశారు. మీరు భయపడుతున్న ప్రజలందరికి మీ దేవుడైన యెహోవా అలాగే చేస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","అంతేకాక, మీకు కనబడకుండా దాక్కున్న మిగిలినవారంతా నశించే వరకు, మీ దేవుడైన యెహోవా వారి మీదికి పెద్ద కందిరీగలను పంపుతారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","మీరు వారికి భయపడకండి, ఎందుకంటే మీ మధ్య ఉన్న మీ దేవుడైన యెహోవా గొప్పవాడు, అద్భుత దేవుడు ");
INSERT INTO telotsa_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","మీ దేవుడైన యెహోవా ఆ జనాంగాలను మీ ఎదుట నుండి కొద్దికొద్దిగా తొలగిస్తారు. అడవి జంతువులు ఎక్కువయ్యే ప్రమాదం ఉంది కాబట్టి మీరు ఒకేసారి వారందరిని నాశనం చేయడానికి అనుమతి లేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","అయితే మీ దేవుడైన యెహోవా వారిని మీ చేతికి అప్పగించి, వారు నాశనం చేయబడేవరకు, వారికి గొప్ప కలవరాన్ని పుట్టిస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ఆయన వారి రాజులను మీ చేతికి అప్పగిస్తారు. మీరు వారి పేర్లను ఆకాశం క్రిందనుండి తుడిచివేస్తారు. మీకు విరోధంగా ఎవరు నిలువలేరు; మీరు వారిని నాశనం చేస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","మీరు వారి దేవుళ్ళ విగ్రహాలను అగ్నిలో కాల్చివేయాలి. వాటి మీది వెండి బంగారాలను ఆశించి, మీ కోసం తీసుకోకూడదు, లేకపోతే దాని వలన మీరు చిక్కులో పడతారు. మీ దేవుడైన యెహోవాకు అది అసహ్యము. ");
INSERT INTO telotsa_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","అసహ్యమైన వాటిని మీరు ఇంటికి తీసుకురాకూడదు, లేదా మీరు, దానివలె నాశనానికి మీరు వేరు చేయబడతారు. అది నాశనం కోసం వేరు చేయబడుతుంది కాబట్టి దానిని నీచమైనదిగా చూసి పూర్తిగా అసహ్యించుకోవాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","మీరు జీవించి అభివృద్ధిచెంది, యెహోవా మీ పూర్వికులకు ప్రమాణం చేసిన దేశానికి వెళ్లి దానిని స్వాధీనం చేసుకునేలా, ఈ రోజు నేను మీకిచ్చే ప్రతి ఆజ్ఞను జాగ్రత్తగా అనుసరించాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","మీరు ఆయన ఆజ్ఞలను పాటిస్తారో లేదో అని మిమ్మల్ని పరీక్షించి మీ హృదయంలో ఏమున్నదో తెలుసుకోవడానికి మిమ్మల్ని దీనులుగా చేయడానికి మీ దేవుడైన యెహోవా మిమ్మల్ని అరణ్యంలో ఈ నలభై సంవత్సరాలు ఎలా నడిపించారో జ్ఞాపకం చేసుకోండి. ");
INSERT INTO telotsa_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","మనుష్యులు కేవలం ఆహారం వల్లనే జీవించరు కాని యెహోవా నోటి నుండి వచ్చే ప్రతి మాట వలన జీవిస్తారు అని మీకు నేర్పించడానికి ఆయన మిమ్మల్ని అణచి మీకు ఆకలి కలిగించి మీకు గాని మీ పూర్వికులకు గాని ఇంతకుముందు తెలియని మన్నాతో మిమ్మల్ని పోషించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ఈ నలభై సంవత్సరాలు మీరు వేసుకున్న బట్టలు పాతబడలేదు, మీ కాళ్లు వాయలేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","ఒకరు తన కుమారుని ఎలా క్రమశిక్షణలో పెడతారో, అలాగే మీ దేవుడైన యెహోవా మిమ్మల్ని క్రమశిక్షణలో పెడతారని మీ హృదయంలో మీరు గ్రహించాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","మీరు మీ దేవుడైన యెహోవాయందు భయం కలిగి, ఆయన మార్గంలో నడుస్తూ, ఆయన ఆజ్ఞలను పాటించాలి. ");
INSERT INTO telotsa_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","మీ దేవుడైన యెహోవా మిమ్మల్ని మంచి దేశంలోకి తీసుకెళ్తారు; అది నదులు నీటిప్రవాహాలు లోయల నుండి కొండల నుండి ఉబికే లోతైన నీటి ఊటలు ఉండే దేశం; ");
INSERT INTO telotsa_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","అంతేకాదు గోధుమలు యవలు ద్రాక్షచెట్లు అంజూర చెట్లు దానిమ్మపండ్లు ఒలీవనూనె తేనె దొరికే దేశం; ");
INSERT INTO telotsa_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ఆ దేశంలో రొట్టెలకు కొరత ఉండదు మీకు ఏది తక్కువకాదు; ఇనుప రాళ్లు గల దేశం, దాని కొండల్లో మీరు రాగి త్రవ్వితీయవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","మీరు తిని తృప్తి చెందిన తర్వాత, మీ దేవుడైన యెహోవా మీకు ఇచ్చిన మంచి దేశాన్ని బట్టి ఆయనను స్తుతించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","ఈ రోజు నేను మీకు ఇచ్చే ఆయన ఆజ్ఞలను, చట్టాలను శాసనాలను పాటించడంలో విఫలమై మీ దేవుడనైన యెహోవాను మరచిపోకుండ జాగ్రత్తపడండి. ");
INSERT INTO telotsa_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","లేకపోతే మీరు తిని తృప్తి చెందినప్పుడు, మీరు మంచి ఇళ్ళు కట్టుకుని వాటిలో స్థిరపడినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","మీ పశువుల మందలు విస్తరించి, వెండి బంగారాలు విస్తరించి, మీకు ఉన్నదంతా వృద్ధి చెందినప్పుడు, ");
INSERT INTO telotsa_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","మీ హృదయం గర్వించి, బానిస దేశమైన ఈజిప్టులో నుండి మిమ్మల్ని బయటకు తీసుకువచ్చిన మీ దేవుడైన యెహోవాను మరచిపోతారు. ");
INSERT INTO telotsa_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","ఆయన మిమ్మల్ని విషసర్పాలు, తేళ్లు ఉన్న నీళ్లు లేని భయంకరమైన పెద్ద అరణ్యంలో నుండి నడిపించారు. రాతి బండ నుండి మీకు నీళ్లు ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ఆయన అరణ్యంలో మీ పూర్వికులకు ఎన్నడూ తెలియని మన్నాను మీకు తినడానికి ఇచ్చారు, మిమ్మల్ని తగ్గించడానికి మిమ్మల్ని పరీక్షించడానికి మీ మంచి కోసం ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","“నా శక్తి, నా చేతుల బలం ఈ సంపదను నాకు సంపాదించాయి” అని మీలో మీరు అనుకోవచ్చు. ");
INSERT INTO telotsa_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","కాని, మీ దేవుడైన యెహోవాను జ్ఞాపకం చేసుకోండి, ఆయన మీ పూర్వికులకు ప్రమాణం చేసినట్లు, తన నిబంధన ఈ రోజు ఉన్నట్లుగా స్థిరపరచడానికి మీరు సంపదను సంపాదించే సామర్థ్యం ఇచ్చేవారు ఆయనే. ");
INSERT INTO telotsa_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","మీరు మీ దేవుడనైన యెహోవాను మరచిపోయి, ఇతర దేవుళ్ళను వెంబడించి పూజించి వాటిని సేవిస్తే, మీరు ఖచ్చితంగా నశించిపోతారని మీకు వ్యతిరేకంగా సాక్ష్యమిస్తున్నాను. ");
INSERT INTO telotsa_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","మీ దేవుడైన యెహోవాకు లోబడకపోతే, మీ ఎదుట ఉండకుండా యెహోవా నాశనం చేసిన దేశాల్లా మీరు నాశనమవుతారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","ఇశ్రాయేలూ, విను: ఇప్పుడు మీరు ఆకాశాన్నంటే ఎత్తైన గోడలున్న పెద్ద పట్టణాలు గల మీకన్నా గొప్ప బలమైన దేశాలను, స్వాధీనం చేసుకోవడానికి మీరు యొర్దాను దాటబోతున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","అక్కడి ప్రజలు బలవంతులు పొడవైనవారు, వారు మీకు తెలిసిన అనాకీయుల వంశస్థులు. వారి గురించి, “అనాకీయుల ఎదుట ఎవరు నిలబడగలరు?” అని చెప్పడం మీరు విన్నారు కదా. ");
INSERT INTO telotsa_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","అయితే దహించే అగ్నిలా మీ దేవుడైన యెహోవా మీకు ముందుగా దాటి వెళ్తారని మీరు నమ్మండి. ఆయన వారిని నాశనం చేస్తారు; మీ ఎదుట వారిని అణచివేస్తారు. యెహోవా మీకు ప్రమాణం చేసిన ప్రకారం, మీరు వారిని వెళ్లగొట్టి త్వరగా వారిని నిర్మూలం చేస్తారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","మీ దేవుడైన యెహోవా మీ ఎదుట నుండి వారిని వెళ్లగొట్టిన తర్వాత, “మా నీతిని బట్టే ఈ దేశాన్ని స్వాధీనం చేసుకోవడానికి యెహోవా మమ్మల్ని ఇక్కడకు తీసుకువచ్చారు” అని మీ హృదయంలో అనుకోవద్దు. ఈ జనాంగాల దుర్మార్గాన్ని బట్టే యెహోవా మీ ఎదుట నుండి వారిని వెళ్లగొట్టబోతున్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","మీ నీతి, నిష్కపటమైన మీ హృదయం కారణంగా మీరు వారి దేశాన్ని స్వాధీనం చేసుకోవడంలేదు కాని ఈ జనాంగాల దుర్మార్గాన్ని బట్టే యెహోవా మీ పితరులైన అబ్రాహాము, ఇస్సాకు, యాకోబులతో చేసిన ప్రమాణాన్ని నెరవేర్చడానికి మీ దేవుడైన యెహోవా మీ ఎదుట నుండి వారిని వెళ్లగొడతారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","మీరు మొండి ప్రజలు కాబట్టి, మీ దేవుడైన యెహోవా స్వాధీనం చేసుకోవడానికి ఈ మంచి దేశాన్ని మీకు ఇవ్వడానికి మీ నీతి కారణం కాదని మీరు గ్రహించండి. ");
INSERT INTO telotsa_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","అరణ్యంలో మీరు మీ దేవుడైన యెహోవాకు ఎలా కోపం పుట్టించారో జ్ఞాపకం చేసుకోండి. మీరు ఈజిప్టు విడిచిన రోజు నుండి ఇక్కడకు వచ్చిన కాలం వరకు యెహోవా మీద తిరుగుబాటు చేస్తూనే ఉన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","హోరేబులో యెహోవా మిమ్మల్ని నాశనం చేసేంతగా ఆయనకు కోపం పుట్టించారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","రాతిపలకలు అనగా, యెహోవా మీతో చేసిన నిబంధనకు సంబంధించి పలకలను తీసుకోవడానికి నేను పర్వతం మీదికి ఎక్కి వెళ్లినప్పుడు, ఆ పర్వతం మీద నేను నలభై పగళ్లు, నలభై రాత్రులు ఉన్నాను; నేను ఆహారం తినలేదు, నీళ్లు త్రాగలేదు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","దేవుని వ్రేలితో వ్రాయబడిన రెండు రాతిపలకలను యెహోవా నాకు ఇచ్చారు. మీరందరు సమావేశమైన రోజున పర్వతం మీద అగ్ని మధ్యలో నుండి యెహోవా మీకు ప్రకటించిన ఆజ్ఞలు ఆ పలకల మీద ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","నలభై పగళ్లు, నలభై రాత్రులు గడిచినప్పుడు, యెహోవా రెండు రాతిపలకలు అనగా, నిబంధనకు సంబంధించిన పలకలు నాకు ఇచ్చారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","అప్పుడు యెహోవా నాతో, “నీవు వెంటనే ఇక్కడినుండి క్రిందికి వెళ్లు, నీవు ఈజిప్టు నుండి తీసుకువచ్చిన నీ ప్రజలు చెడిపోయారు. నేను వారికి ఆజ్ఞాపించిన మార్గం నుండి త్వరగా తొలగిపోయి తమ కోసం ఒక విగ్రహాన్ని తయారుచేసుకున్నారు” అని చెప్పారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","ఇంకా యెహోవా నాతో, “నేను ఈ ప్రజలను చూశాను, వారు నిజంగా మొండి ప్రజలు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","నన్ను విడిచిపెట్టు, నేను వారిని నాశనం చేసి, ఆకాశం క్రింద వారి పేరు ఉండకుండా తుడిచివేస్తాను. నిన్ను వారికంటే బలమైన దేశంగా, సంఖ్యలో వారికంటే ఎక్కువ ఉండేలా చేస్తాను” అని అన్నారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","కాబట్టి నేను పర్వతం అగ్నితో మండుతున్నప్పుడు తిరిగి పర్వతం దిగి వచ్చాను. రెండు నిబంధన పలకలు నా చేతిలో ఉన్నాయి. ");
INSERT INTO telotsa_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","నేను చూసినప్పుడు, మీ దేవుడైన యెహోవాకు వ్యతిరేకంగా మీరు పాపం చేశారని నేను చూశాను; దూడ రూపంలో తయారుచేసిన విగ్రహాన్ని మీ కోసం తయారుచేసుకున్నారు. యెహోవా మీకు ఆజ్ఞాపించిన మార్గంలో నుండి త్వరగా తొలగిపోయారు. ");
INSERT INTO telotsa_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","కాబట్టి నా చేతుల్లో ఉన్న రెండు పలకలను విసిరి, మీ కళ్లముందే వాటిని ముక్కలు చేశాను. ");
INSERT INTO telotsa_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","యెహోవా దృష్టిలో చెడుగా ప్రవర్తించి చేసిన పాపాలన్నిటిని బట్టి మీరు ఆయనకు కోపం పుట్టించిన కారణంగా మళ్ళీ నేను నలభై పగళ్లు నలభై రాత్రులు ఆహారం తినకుండా నీళ్లు త్రాగకుండా యెహోవా ఎదుట సాష్టాంగపడ్డాను. ");
INSERT INTO telotsa_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","మిమ్మల్ని నాశనం చేయాలన్నంతగా కోప్పడిన యెహోవా కోపాన్ని ఉగ్రతను చూసి నేను భయపడ్డాను. కాని యెహోవా మరలా నా మనవి ఆలకించారు. ");
INSERT INTO telotsa_vpl VALU