﻿USE sofia;
DROP TABLE IF EXISTS sofia.tel2017_vpl;
CREATE TABLE tel2017_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tel2017_vpl WRITE;
INSERT INTO tel2017_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ఆరంభంలో దేవుడు ఆకాశాలనూ భూమినీ సృష్టించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","భూమి నిరాకారంగా, శూన్యంగా ఉంది. జలాగాధం మీద చీకటి కమ్ముకుని ఉంది. దేవుని ఆత్మ ఆ మహా జలరాశిపై కదలాడుతూ ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","దేవుడు “వెలుగు కలుగు గాక” అన్నాడు. వెలుగు కలిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ఆ వెలుగు దేవునికి మంచిదిగా అనిపించింది. దేవుడు వెలుగునూ చీకటినీ వేరు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","దేవుడు వెలుగుకు పగలు అనీ చీకటికి రాత్రి అని పేర్లు పెట్టాడు. సాయంత్రం అయింది, ఉదయం వచ్చింది, మొదటి రోజు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","దేవుడు “మహా జలరాశి మధ్యలో ఒక విశాల ప్రదేశం కలుగు గాక. అది నీళ్ళనుండి నీళ్ళను వేరు చేయు గాక” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","దేవుడు ఆ విశాలమైన ప్రదేశాన్ని చేసి, దాని పైన ఉన్న జలాలను, కింద ఉన్న జలాలను వేరు చేసాడు. అది అలాగే జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","దేవుడు ఆ విశాల ప్రదేశానికి “ఆకాశం” అని పేరు పెట్టాడు. రాత్రి అయింది, ఉదయం వచ్చింది, రెండవ రోజు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","దేవుడు “ఆకాశం కింద ఉన్న జలాలు ఒకే చోట సమకూడి ఆరిన నేల కనబడాలి” అన్నాడు. అలాగే జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","దేవుడు ఆరిన నేలకు “భూమి” అని పేరు పెట్టాడు. కూర్చి ఉన్న జలాలకు “సముద్రాలు” అని పేరు పెట్టాడు. అది ఆయనకు మంచిదిగా అనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","దేవుడు “వృక్ష జాలాన్ని, విత్తనాలుండే చెట్లను, భూమిపై తమ తమ జాతి ప్రకారం విత్తనాలు ఉండి ఫలం ఇచ్చే పండ్ల చెట్లను భూమి మొలిపించాలి” అన్నాడు. అలాగే జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","వృక్ష జాతిని, విత్తనాలుండే చెట్లను, భూమిమీద తమ తమ జాతుల ప్రకారం తమలో విత్తనాలు ఉండి ఫలం ఇచ్చే పండ్ల చెట్లను భూమి మొలిపించింది. అది ఆయనకు మంచిదిగా కనబడింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","రాత్రి అయింది, ఉదయం వచ్చింది-మూడవ రోజు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","దేవుడు “రాత్రి నుంచి పగలును వేరు చెయ్యడానికి ఆకాశ విశాలంలో జ్యోతులు ఉండాలి. కాలాలకు, రోజులకు, సంవత్సరాలకు అవి సూచనలుగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","భూమికి వెలుగు ఇవ్వడానికి ఆకాశ విశాలంలో జ్యోతులుగా అవి ఉండాలి” అన్నాడు. అలాగే జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","దేవుడు రెండు గొప్ప జ్యోతులు చేశాడు. పగటిని ఏలడానికి పెద్ద జ్యోతిని, రాత్రిని పాలించడానికి చిన్న జ్యోతిని చేశాడు. ఆయన నక్షత్రాలను కూడా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","భూమికి వెలుగు ఇవ్వడానికీ, ");
INSERT INTO tel2017_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","పగటినీ రాత్రినీ పాలించడానికీ, వెలుగునూ చీకటినీ వేరు చెయ్యడానికీ, దేవుడు ఆకాశ విశాలంలో వాటిని అమర్చాడు. అది ఆయనకు మంచిదిగా కనబడింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","రాత్రి అయింది. ఉదయం వచ్చింది-నాలుగో రోజు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","దేవుడు “చలించే ప్రాణులు జలాల్లో కుప్పలు తెప్పలుగా నిండిపోవాలి. భూమిపై ఉన్న ఆకాశవిశాలంలో పక్షులు ఎగరాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","దేవుడు బ్రహ్మాండమైన జలచరాలనూ, చలించే ప్రాణులన్నిటినీ వాటి వాటి జాతుల ప్రకారం పుష్కలంగా జలాలను నింపి వేసేలా సృష్టించాడు. ఇంకా వాటి వాటి జాతి ప్రకారం రెక్కలున్న ప్రతి పక్షినీ సృష్టించాడు. అది ఆయనకు మంచిదిగా కనబడింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","దేవుడు “మీరు ఫలించి వృద్ధి పొందండి. సముద్ర జలాలను నింపండి. పక్షులు భూమి మీద విస్తరించాలి” అని వాటిని దీవించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","రాత్రి అయింది. ఉదయం వచ్చింది-ఐదో రోజు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","దేవుడు “వాటి వాటి జాతుల ప్రకారం ప్రాణం గలవాటిని, అంటే వాటి వాటి జాతి ప్రకారం పశువులను, పురుగులను, అడవి జంతువులను భూమి పుట్టించాలి” అన్నాడు. అలాగే జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","దేవుడు, వాటి వాటి జాతుల ప్రకారం అడవి జంతువులనూ వాటి వాటి జాతుల ప్రకారం పశువులనూ, వాటి వాటి జాతుల ప్రకారం నేలమీద పాకే ప్రతి పురుగునూ చేశాడు. అది ఆయనకు మంచిదిగా కనబడింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","దేవుడు ఇలా అన్నాడు. “మన స్వరూపంలో మన పోలికలో మనిషిని చేద్దాం. సముద్రంలో చేపల మీదా ఆకాశంలో పక్షుల మీదా పశువుల మీదా భూమి మీద పాకే ప్రతి జంతువు మీదా భూమి అంతటి మీదా వారికి ఆధిపత్యం ఉండాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","దేవుడు తన స్వరూపంలో మనిషిని సృష్టించాడు. దేవుని స్వరూపంలో అతణ్ణి సృష్టించాడు. పురుషుడిగా స్త్రీగా వాళ్ళను సృష్టించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","దేవుడు వాళ్ళను దీవించి “మీరు ఫలించి, సంఖ్యలో వృద్ధి చెందండి. భూమి అంతటా విస్తరించి, భూమిని నింపి దాన్ని స్వాధీనం చేసుకోండి. సముద్రంలో చేపలనూ ఆకాశంలో పక్షులనూ మీదా భూమి మీద పాకే ప్రతి ప్రాణినీ పరిపాలించండి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","దేవుడు ఇంకా ఇలా అన్నాడు. “చూడండి, భూమిమీద ఉన్న విత్తనాలిచ్చే ప్రతి చెట్టును, విత్తనాలున్న ఫలాలు ఇచ్చే ప్రతి చెట్టును మీకు ఇచ్చాను. అవి మీకు ఆహారం అవుతాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","భూమిమీద ఉండే జంతువులన్నిటికీ ఆకాశ పక్షులన్నిటికీ భూమి మీద పాకే జీవాలన్నిటికీ పచ్చని చెట్లన్నీ ఆహారం అవుతాయి” అన్నాడు. అలాగే జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","దేవుడు తాను చేసిందంతా చూసినప్పుడు అది ఆయనకు ఎంతో మంచిదిగా కనబడింది. రాత్రి అయింది. ఉదయం వచ్చింది-ఆరవ రోజు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ఆకాశాలు, భూమి, వాటిలో ఉన్నవన్నీపూర్తి అయ్యాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ఏడవ రోజు దేవుడు తాను చేసిన పని ముగించాడు. కాబట్టి తాను చేసిన పని అంతటి నుంచీ ఏడవ రోజున విశ్రాంతి తీసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","దేవుడు ఆ ఏడవ రోజును ఆశీర్వదించి పవిత్రం చేశాడు. ఆయన తాను చేసిన సృష్టి కార్యం అంతటినుంచీ విశ్రాంతి తీసుకున్న కారణంగా ఆ రోజును పవిత్రపరిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","దేవుడైన యెహోవా భూమిని ఆకాశాలను చేసినప్పుడు, ఆకాశాల సంగతి, భూమి సంగతి ఈ విధంగా ఉన్నాయి, ");
INSERT INTO tel2017_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","భూమి మీద అంతకుముందు ఆరుబయట ఏ పొదలూ లేవు, ఏ చెట్లూ మొలవలేదు. ఎందుకంటే దేవుడైన యెహోవా భూమి మీద వర్షం కురిపించ లేదు. నేలను సేద్యం చెయ్యడానికి ఏ మనిషీ లేడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","కాని, భూమిలోనుంచి నీటి ప్రవాహాలు పొంగి నేలంతా తడిపేది గనక భూతలం అంతటా నీళ్ళు ఉండేవి. ");
INSERT INTO tel2017_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","దేవుడైన యెహోవా నేలలో నుంచి మట్టి తీసుకుని మనిషిని చేసి అతని ముక్కుపుటాల్లో ఊపిరి ఊదాడు. మనిషికి ప్రాణం వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","దేవుడైన యెహోవా తూర్పువైపున ఏదెనులో ఒక తోట వేసి తాను చేసిన మనిషిని అందులో ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","దేవుడైన యెహోవా కళ్ళకు అందమైన, ఆహారానికి మంచిదైన ప్రతి చెట్టునూ అక్కడ నేలలోనుంచి మొలిపించాడు. ఇంకా ఆ తోట మధ్యలో జీవవృక్షాన్నీ, ఏది మంచో, ఏది చెడో తెలిపే వృక్షాన్నీ కూడా నేలలోనుంచి మొలిపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ఆ తోటను తడపడానికి ఏదెనులో నుంచి ఒక నది బయలుదేరి అక్కడ నుంచి చీలిపోయి నాలుగు పాయలు అయ్యింది. ");
INSERT INTO tel2017_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","మొదటిదాని పేరు పీషోను. అది బంగారం ఉన్న హవీలా దేశమంతటా ప్రవహిస్తున్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ఆ దేశంలో దొరికే బంగారం ప్రశస్తమైనది. అక్కడ ముత్యాలు, గోమేధిక మణులు కూడా దొరుకుతాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","రెండో నది పేరు గీహోను. అది ఇతియోపియా దేశమంతటా ప్రవహిస్తున్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","మూడో నది పేరు హిద్దెకెలు. అది అష్షూరుకు తూర్పు వైపు ప్రవహిస్తున్నది. నాలుగో నది యూఫ్రటీసు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","దేవుడైన యెహోవా ఏదెను తోట సాగు చెయ్యడానికీ దాన్ని చూసుకోడానికీ మనిషిని అక్కడ పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","దేవుడైన యెహోవా “ఈ తోటలో ఉన్న ప్రతి చెట్టు ఫలాన్నీ నువ్వు అభ్యంతరం లేకుండా తినొచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","కాని, మంచి చెడ్డల తెలివిని ఇచ్చే చెట్టు ఫలాలు మాత్రం నువ్వు తినకూడదు. నువ్వు వాటిని తిన్నరోజున కచ్చితంగా చచ్చిపోతావు” అని మనిషికి ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","దేవుడైన యెహోవా “మనిషి ఒంటరిగా ఉండడం మంచిది కాదు. అతనికి సరిపడిన తోడును అతని కోసం చేస్తాను” అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","దేవుడైన యెహోవా, ప్రతి భూజంతువునూ ప్రతి పక్షినీ నేలలోనుంచి చేసి, ఆదాము వాటికి ఏ పేర్లు పెడతాడో చూడడానికి అతని దగ్గరికి వాటిని రప్పించాడు. జీవం ఉన్న ప్రతిదానికీ ఆదాము ఏ పేరు పెట్టాడో, ఆ పేరు దానికి ఖాయం అయ్యింది. ");
INSERT INTO tel2017_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","అప్పుడు ఆదాము పశువులన్నిటికీ, ఆకాశపక్షులన్నిటికీ, భూజంతువులన్నిటికీ పేర్లు పెట్టాడు. కాని ఆదాముకు మాత్రం సరిజోడు లేకపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","అప్పుడు దేవుడైన యెహోవా ఆదాముకు గాఢ నిద్ర కలిగించాడు. అతడు నిద్రలో ఉండగా అతని పక్కటెముకల్లో నుంచి ఒకదాన్ని తీసి ఆ ఖాళీని మాంసంతో పూడ్చివేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ఆ తరువాత దేవుడైన యెహోవా ఆదాము నుంచి తీసిన పక్కటెముకతో స్త్రీని తయారుచేసి ఆదాము దగ్గరికి తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ఆదాము “ఇప్పుడు ఇది నా ఎముకల్లో ఎముక, నా మాంసంలో మాంసం. మనిషిలోనుంచి బయటకు తీసినది గనుక ఈమె పేరు మానుషి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ఆ కారణంగా పురుషుడు తన తండ్రిని, తన తల్లిని విడిచి తన భార్యతో ఏకం అవుతాడు. వాళ్ళు ఒకే శరీరం అవుతారు. ");
INSERT INTO tel2017_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","అప్పుడు ఆదాము, అతని భార్య ఇద్దరూ నగ్నంగా ఉన్నారు. వాళ్ళకు సిగ్గు తెలియదు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","దేవుడైన యెహోవా చేసిన జంతువులన్నిటిలో పాము జిత్తులమారి. వాడు ఆ స్త్రీతో “నిజమేనా? ‘ఈ తోటలో ఉన్న చెట్లకు కాసే ఏ పండు ఏదీ మీరు తినకూడదు’ అని దేవుడు చెప్పాడా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","స్త్రీ ఆ సర్పంతో “ఈ తోటలో ఉన్న చెట్ల పండ్లు మేము తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","కానీ తోట మధ్యలో ఉన్న చెట్టు పండ్ల విషయంలో ‘మీరు వాటిని తినకూడదు. వాటిని ముట్టుకోకూడదు. అలా చేస్తే మీరు చనిపోతారు’ అని దేవుడు చెప్పాడు” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","పాము స్త్రీతో “మీరు చావనే చావరు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ఎందుకంటే, మీరు దాన్ని తిన్న రోజున మీ కళ్ళు తెరుచుకుంటాయి. మీరు మంచి చెడ్డలు తెలిసి, దేవుళ్ళ వలె ఉంటారని దేవుడికి తెలుసు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","స్త్రీ, ఆ చెట్టు తినడానికి మంచిదిగా, కంటికి ఇంపుగా, వివేకం కలగడం కోసం కోరదగినదిగా ఉండడం చూసి, దాని పండ్లలో కొన్నిటిని కోసి తిని, తనతోపాటు తన భర్తకు కూడా ఇచ్చింది. అతడు కూడా తిన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","అప్పుడు వాళ్ళిద్దరికీ కళ్ళు తెరుచుకున్నాయి. తాము నగ్నంగా ఉన్నాం అని గ్రహించి అంజూరపు ఆకులు కలిపి కుట్టి ఒళ్ళు కప్పుకునేవి తయారు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","సాయంత్రం చల్లబడిన తరువాత ఆ తోటలో దేవుడైన యెహోవా నడుస్తున్న శబ్ధం వాళ్ళు విన్నారు. ఆదాము, అతని భార్య దేవుడైన యెహోవాకు ఎదురు పడకుండా తోటలో చెట్ల మధ్య దాక్కున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","దేవుడైన యెహోవా ఆదామును పిలుస్తూ “నువ్వెక్కడ ఉన్నావు?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","అతడు “నేను తోటలో నీ స్వరం విన్నప్పుడు నగ్నంగా ఉన్నాను గనక భయపడి దాక్కున్నాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","దేవుడు “నువ్వు నగ్నంగా ఉన్నావని నీకెవరు చెప్పారు? తినొద్దని నీకు ఆజ్ఞ ఇచ్చిన ఆ చెట్టు పండు తిన్నావా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ఆదాము “నాతో ఉండడానికి నువ్వు నాకిచ్చిన స్త్రీ నాకు ఆ చెట్టు పండు ఇచ్చింది. అప్పుడు నేను దాన్ని తిన్నాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","దేవుడైన యెహోవా స్త్రీతో “నువ్వు చేసిందేమిటి?” అన్నాడు. స్త్రీ “సర్పం నన్ను మోసం చేసిన కారణంగా నేను తిన్నాను” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","అందుకు దేవుడైన యెహోవా పాముతో “నువ్వు ఇలా చేసినందుకు పశువులన్నిటిలో, జంతువులన్నిటిలో నిన్ను మాత్రమే శపిస్తున్నాను. నువ్వు నీ కడుపుతో పాకుతూ వెళ్తావు. బ్రతికినంత కాలం మట్టి తింటావు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","నీకూ స్త్రీకీ నీ సంతానానికీ ఆమె సంతానానికీ మధ్య శత్రుత్వం ఉండేలా చేస్తాను. అతడు నిన్ను తలమీద కొడతాడు. నువ్వు అతన్ని మడిమె మీద కొడతావు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ఆయన స్త్రీతో “పిల్లలను కనేటప్పుడు నీకు కలిగే బాధ అనేక రెట్లు పెంచుతున్నాను. నీ భర్తపై నువ్వు వాంఛ కలిగి ఉంటావు. అతడు నిన్ను ఏలుతాడు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ఆయన ఆదాముతో “నువ్వు నీ భార్య మాట విని ‘తినొద్దు’ అని నేను నీకు ఆజ్ఞ ఇచ్చిన ఆ చెట్టు పండు తిన్నావు గనుక నిన్నుబట్టి నేల శాపానికి గురయ్యింది. జీవితకాలమంతా కష్టం చేసి నువ్వు దాని పంట తింటావు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","నువ్వు ఎంత కష్టం చేసినా నేల ముళ్ళ తుప్పలను, ముళ్ళ పొదలనే మొలిపిస్తుంది. నువ్వు పొలంలో పండించిన పంట తింటావు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","నువ్వు మట్టికి తిరిగి చేరే వరకూ చెమటోడ్చి ఆహారం తింటావు. ఎందుకంటే నిన్ను తీసింది మట్టిలోనుంచే. నువ్వు మట్టే గనుక మళ్ళీ మట్టి అయిపోతావు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ఆదాము తన భార్యకు హవ్వ అని పేరు పెట్టాడు. ఎందుకంటే జీవులందరికీ ఆమే అమ్మ. ");
INSERT INTO tel2017_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","దేవుడైన యెహోవా ఆదాముకు అతని భార్యకు జంతు చర్మంతో బట్టలు చేసి తొడిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","దేవుడైన యెహోవా “ఇప్పుడు మనిషి మంచి చెడ్డలు తెలిసిన మనలాంటివాడయ్యాడు. కాబట్టి ఒకవేళ అతడు తన చెయ్యి చాపి ఆ జీవ వృక్షఫలం కూడా తీసుకుని తిని శాశ్వతంగా జీవిస్తాడేమో. అది మంచిది కాదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","దేవుడైన యెహోవా అతణ్ణి ఏ నేలనుంచి తీశాడో ఆ నేలను సాగు చెయ్యడానికి ఏదెను తోటలోనుంచి అతణ్ణి పంపివేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","కాబట్టి దేవుడు ఏదెను తోటలోనుంచి ఆదామును వెళ్ళగొట్టి, ఏదెను తోటకు తూర్పు వైపు కెరూబులు, జీవవృక్షానికి వెళ్ళే దారిని కాపలా కాయడానికి ఇటు అటు తిరిగే అగ్నిఖడ్గం నిలబెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ఆదాము తన భార్య హవ్వను కలిసినప్పుడు ఆమె గర్భం దాల్చి కయీనుకు జన్మనిచ్చింది. ఆమె “యెహోవా సహాయంతో నేనొక మగ బిడ్డకు జన్మనిచ్చాను” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","తరువాత ఆమె అతని తమ్ముడు హేబెలుకు జన్మనిచ్చింది. హేబెలు గొర్రెల కాపరి. కయీను వ్యవసాయం చేసేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","కొంతకాలం తరువాత కయీను వ్యవసాయంలో వచ్చిన పంటలో కొంత యెహోవాకు అర్పణ ఇవ్వడానికి తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","హేబెలు కూడా తన మందలో తొలుచూలు పిల్లల్లో కొవ్వు పట్టిన వాటిని తెచ్చాడు. యెహోవా హేబెలును, అతని అర్పణను అంగీకరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","కయీనును, అతని అర్పణను ఆయన అంగీకరించ లేదు. కాబట్టి కయీనుకు చాలా కోపం వచ్చి అసూయతో రగిలిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","యెహోవా కయీనుతో “ఎందుకు కోపగించుకున్నావు? ఎందుకు రుసరుసలాడుతున్నావు? ");
INSERT INTO tel2017_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","నువ్వు సరైనది చేస్తే నీకు ఆమోదం లభిస్తుంది కదా. సరైనది చెయ్యకపోతే గుమ్మంలో పాపం పొంచి ఉంటుంది. అది నిన్ను స్వాధీపర్చుకోవాలని చూస్తుంది. అయితే, నువ్వు దాన్ని అదుపులో ఉంచుకోవాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","కయీను తన తమ్ముడు హేబెలుతో మాట్లాడాడు. వాళ్ళు పొలంలో ఉన్నప్పుడు కయీను తన తమ్ముడు హేబెలు మీద దాడి చేసి అతణ్ణి చంపివేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","అప్పుడు యెహోవా కయీనుతో “నీ తమ్ముడు హేబెలు ఎక్కడున్నాడు?” అన్నాడు. అతడు “నాకు తెలియదు. నేను నా తమ్ముడికి కాపలా వాడినా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","దేవుడు “నువ్వు చేసిందేమిటి? నీ తమ్ముడి రక్తం నేలలో నుంచి నాకు మొరపెడుతూ ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ఇప్పుడు నీ మూలంగా ఒలికిన నీ తమ్ముడి రక్తాన్ని మింగడానికి నోరు తెరిచిన ఈ నేల మీద ఉండకుండాా నువ్వు శాపానికి గురయ్యావు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","నువ్వు నేలను సాగు చేసినప్పుడు అది తన సారాన్ని ఇకపై నీకు ఇవ్వదు. నువ్వు భూమి మీద నుంచి అస్తమానం పారిపోతూ, దేశదిమ్మరిగా ఉంటావు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","కయీను “నా శిక్ష నేను భరించలేనిది. ");
INSERT INTO tel2017_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ఈ రోజు ఈ ప్రదేశం నుంచి నువ్వు నన్ను వెళ్ళగొట్టావు. నీ సన్నిధిలోకి నేనిక రావడం కుదరదు. ఈ భూమి మీద పలాయనం అవుతూ, దేశదిమ్మరిగా ఉంటాను. నన్ను ఎవరు చూస్తే వాళ్ళు నన్ను చంపుతారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","యెహోవా అతనితో “అలా జరగదు. నిన్ను చూసిన వాడు ఎవడైనా నిన్ను చంపితే అతణ్ణి తీవ్రంగా శిక్షిస్తానని తెలియజేసేందుకు నీ మీద ఒక గుర్తు వేస్తాను. నిన్ను నేను శిక్షించిన దానికి ఏడు రెట్లు అలాటి వాణ్ణి శిక్షిస్తాను” అన్నాడు. అప్పుడు యెహోవా కయీను మీద ఒక గుర్తు వేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","కాబట్టి కయీను యెహోవా సన్నిధిలోనుంచి బయలుదేరి వెళ్ళి ఏదెనుకు తూర్పువైపు ఉన్న నోదు ప్రాంతంలో నివాసం ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","కయీను తన భార్యను కలిసినప్పుడు ఆమె గర్భం ధరించి హనోకుకు జన్మనిచ్చింది. అతడు ఒక ఊరు కట్టించి దానికి తన కొడుకు పేర హనోకు అని పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","హనోకు ఈరాదుకు తండ్రి. ఈరాదు మహూయాయేలుకు తండ్రి. మహూయాయేలు మతూషాయేలుకు తండ్రి. మతూషాయేలు లెమెకుకు తండ్రి. ");
INSERT INTO tel2017_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","లెమెకు ఇద్దరిని పెళ్ళి చేసుకున్నాడు. వారిలో ఒకామె పేరు ఆదా, రెండవ ఆమె సిల్లా. ");
INSERT INTO tel2017_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ఆదా యాబాలుకు జన్మనిచ్చింది. అతడు పశువులు పెంపకం చేస్తూ గుడారాల్లో నివాసం ఉండేవాళ్లకు మూలపురుషుడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","అతని తమ్ముడు యూబాలు. ఇతను తీగె వాయుద్యాలు, వేణువు వాయించే వాళ్ళందరికీ మూలపురుషుడు. ");
INSERT INTO tel2017_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","సిల్లా తూబల్కయీనుకు జన్మనిచ్చింది. అతడు రాగి, ఇనప పరికరాలు చేసేవాడు. తూబల్కయీను చెల్లి పేరు నయమా. ");
INSERT INTO tel2017_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","లెమెకు తన భార్యలతో ఇలా అన్నాడు. “ఆదా, సిల్లా, నా మాట వినండి. లెమెకు భార్యలారా, నా మాట ఆలకించండి. నన్ను గాయపరచినందుకు నేను ఒక మనిషిని చంపాను. కమిలిపోయేలా కొట్టినందుకు ఒక యువకుణ్ణి చంపాను. ");
INSERT INTO tel2017_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ఏడంతలు ప్రతీకారం కయీను కోసం వస్తే లెమెకు కోసం డెబ్భై ఏడు రెట్లు వస్తుంది.” ");
INSERT INTO tel2017_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ఆదాము మళ్ళీ తన భార్యను కలిసినప్పుడు ఆమె ఒక కొడుకును కన్నది. అతనికి షేతు అని పేరు పెట్టి “కయీను చంపిన హేబెలుకు బదులుగా దేవుడు నాకు మరొక కొడుకును ఇచ్చాడు” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","షేతుకు ఒక కొడుకు పుట్టాడు. అతని పేరు ఎనోషు. అప్పటినుండి మనుషులు యెహోవాను ఆరాధించడం ఆరంభించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ఆదాము వంశక్రమం ఇది. దేవుడు మనిషిని సృష్టించిన రోజున వాళ్ళను తన సొంత పోలికలో చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","వారిని పురుషులుగా, స్త్రీలుగా సృష్టించాడు. వాళ్ళను సృష్టించిన రోజున ఆయన వాళ్ళను ఆశీర్వదించి వాళ్లకు మనుషులు అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ఆదాముకు నూట ముప్ఫై సంవత్సరాల వయస్సులో అతని పోలికగా అతని స్వరూపంలో కొడుకు పుట్టాడు. ఆదాము అతనికి షేతు అని పేరుపెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","షేతు పుట్టిన తరువాత ఆదాము ఎనిమిది వందల సంవత్సరాలు బ్రతికాడు. అతనికి ఇంకా కొడుకులు, కూతుళ్ళు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ఆదాము తొమ్మిది వందల ముప్ఫై సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","షేతుకు నూట ఐదు సంవత్సరాల వయస్సులో ఎనోషు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ఎనోషు పుట్టిన తరువాత షేతు ఎనిమిది వందల ఏడు సంవత్సరాలు బ్రతికి కొడుకులను, కూతుళ్ళను కన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","షేతు తొమ్మిది వందల పన్నెండు సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ఎనోషుకు తొంభై సంవత్సరాల వయస్సులో కేయినాను పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","కేయినాను పుట్టిన తరువాత ఎనోషు ఎనిమిది వందల పదిహేను సంవత్సరాలు బ్రతికి కొడుకులను, కూతుళ్ళను కన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ఎనోషు తొమ్మిది వందల ఐదు సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","కేయినానుకు డెబ్భై సంవత్సరాల వయస్సులో మహలలేలు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","మహలలేలు పుట్టిన తరువాత కేయినాను ఎనిమిది వందల నలభై సంవత్సరాలు బ్రతికి కొడుకులను, కూతుళ్ళను కన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","కేయినాను తొమ్మిది వందల పది సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","మహలలేలుకు అరవై ఐదు సంవత్సరాల వయస్సులో యెరెదు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","యెరెదు పుట్టిన తరువాత మహలలేలు ఎనిమిది వందల ముప్ఫైసంవత్సరాలు బ్రతికి కొడుకులను, కూతుళ్ళను కన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","మహలలేలు ఎనిమిదివందల తొంభై ఐదు సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","యెరెదుకు నూట అరవై రెండు సంవత్సరాల వయస్సులో హనోకు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","హనోకు పుట్టిన తరువాత యెరెదు ఎనిమిది వందల సంవత్సరాలు బ్రతికి కొడుకులను, కూతుళ్ళను కన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","యెరెదు తొమ్మిది వందల అరవై రెండు సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","హనోకుకు అరవై ఐదు సంవత్సరాల వయస్సులో మెతూషెల పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","మెతూషెల పుట్టిన తరువాత హనోకు మూడు వందల సంవత్సరాలు దేవునితో సహవాసం చేస్తూ కొడుకులను, కూతుళ్ళను కన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","హనోకు మూడువందల అరవై ఐదు సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","హనోకు దేవునితో కలసి నడిచాడు. దేవుడు అతణ్ణి తీసుకువెళ్ళాడు గనుక అతడు కనబడలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","మెతూషెలకు నూట ఎనభై ఏడు సంవత్సరాల వయస్సులో లెమెకు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","మెతూషెలకు లెమెకు పుట్టిన తరువాత ఏడు వందల ఎనభై రెండు సంవత్సరాలు బ్రతికి కొడుకులను, కూతుళ్ళను కన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","మెతూషెల తొమ్మిది వందల అరవై తొమ్మిది సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","లెమెకుకు నూట ఎనభై రెండు సంవత్సరాల వయస్సులో ఒక కొడుకు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","“భూమిని యెహోవా శపించినందువల్ల కలిగిన మన చేతుల కష్టం విషయంలో, మన పని విషయంలో ఇతడు మనకు విశ్రాంతి ఇస్తాడు” అని, అతనికి నోవహు అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","లెమెకుకు నోవహు పుట్టిన తరువాత ఐదు వందల తొంభై ఐదు సంవత్సరాలు బ్రతికి కొడుకులను, కూతుళ్ళను కన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","లెమెకు ఏడువందల డెబ్భై ఏడు సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ఐదు వందల సంవత్సరాలు బ్రతికిన నోవహుకు షేము, హాము, యాపెతు అనే ముగ్గురు కొడుకులు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","మనుషులు భూమి మీద విస్తరించడం మొదలుపెట్టారు. వాళ్లకు కూతుళ్ళు పుట్టినప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","దైవ కుమారులు మనుషుల కూతుళ్ళు అందంగా ఉండడం చూసి, వాళ్ళల్లో తమకు నచ్చిన స్త్రీలను పెళ్ళి చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","యెహోవా “జీవమిచ్చే నా ఊపిరి మనుషుల్లో ఎల్లకాలం ఉండదు. ఎందుకంటే వారు బలహీనమైన రక్తమాంసాలు గలవారు. వారు నూట ఇరవై సంవత్సరాల కంటే ఎక్కువ కాలం బతకరు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","దైవ కుమారులు మనుషుల కూతుళ్ళను పెళ్ళి చేసుకున్నప్పుడు వాళ్లకు పిల్లలు పుట్టారు. వీరు ఆ రోజుల్లో, ఆ తరువాత కూడా భూమి మీద ఉన్న దీర్ఘదేహులు. ఈ మహా కాయులు గొప్ప శూరులు. పూర్వకాలంలో పేరుప్రఖ్యాతులు గల వారు వీరే. ");
INSERT INTO tel2017_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","మనుషుల దుర్మార్గం భూమిమీద మితిమీరి పోయిందని, వాళ్ళ హృదయ ఆలోచనా విధానం ఎప్పుడూ దుష్టత్వమే అని యెహోవా చూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","తాను భూమిమీద మనుషులను చేసినందుకు బాధపడి, హృదయంలో విచారించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","కాబట్టి యెహోవా “నేను సృష్టించిన మనుషులను ఈ భూమిమీద లేకుండా చేస్తాను. మనుషులతో పాటు జంతువులను, పాకే జీవులను, ఆకాశపక్షులను భూమిమీద లేకుండా తుడిచి వేస్తాను. ఎందుకంటే నేను వాళ్ళను సృష్టించినందుకు బాధపడుతున్నాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","అయితే నోవహు యెహోవా దృష్టిలో అనుగ్రహం పొందాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","నోవహు గురించిన సంగతులు ఇవే. నోవహు నీతిపరుడు. అతని తరం వాళ్ళల్లో నింద లేనివాడు. నోవహు దేవునితో కలసి నడిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","షేము, హాము, యాపెతు అనే ముగ్గురు కొడుకులకు నోవహు తండ్రి అయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","దేవుని దృష్టిలో లోకం చెడిపోయింది. అది హింసతో నిండిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","దేవుడు లోకాన్ని చూడగా అది చెడిపోయి ఉంది. భూమిమీద మనుషులందరూ తమ మార్గాల్లో చెడిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","దేవుడు నోవహుతో “మనుషుల మూలంగా భూమి హింసతో నిండిపోయింది గనుక వాళ్ళను అంతం చేసే సమయం వచ్చినట్టు తేటతెల్లం అయింది. కచ్చితంగా ఈ భూమితోపాటు వాళ్ళందరినీ నాశనం చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","కోనిఫర్ కలపతో నీ కోసం ఒక ఓడ సిద్ధం చేసుకో. గదులతో ఉన్న ఓడను తయారుచేసి, దానికి లోపలా బయటా తారు పూయాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","నువ్వు దాన్ని చెయ్యాల్సిన విధానం ఇదే. ఆ ఓడ మూడు వందల మూరల పొడవు, ఏభై మూరల వెడల్పు, ముప్ఫై మూరల ఎత్తు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ఆ ఓడకు కిటికీ చేసి పైనుంచి కిందికి ఒక మూర దూరంలో దాన్ని బిగించాలి. ఓడకు ఒక పక్క తలుపు ఉంచాలి. మూడు అంతస్థులు ఉండేలా దాన్ని చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","విను, నేను ఊపిరి ఉన్నవాటన్నిటినీ ఆకాశం కింద లేకుండా నాశనం చెయ్యడానికి భూమి మీదికి జలప్రవాహం రప్పించబోతున్నాను. లోకంలో ఉన్నవన్నీ చనిపోతాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","కానీ, నీతో నా నిబంధన నెరవేరుస్తాను. నువ్వు, నీతోపాటు నీ కొడుకులు, నీ భార్య, నీ కోడళ్ళు ఆ ఓడలో ప్రవేశిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","నీతోపాటు వాటిని కూడా సజీవంగా ఉంచడం కోసం జీవులన్నిటిలో, అంటే, శరీరం ఉన్న ప్రతి జాతిలోనుంచి రెండేసి చొప్పున నువ్వు ఓడలోకి తేవాలి. వాటిలో ఒకటి మగది ఒకటి ఆడది ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","అవి చనిపోకుండా ఉండడానికి వాటి వాటి జాతుల ప్రకారం పక్షుల్లో, వాటి వాటి జాతుల ప్రకారం జంతువుల్లో, వాటి వాటి జాతుల ప్రకారం నేల మీద పాకే వాటన్నిట్లో, ప్రతి జాతిలో రెండేసి చొప్పున నీ దగ్గరికి అవే వస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","తినడానికి కావలసిన అన్నిరకాల ఆహార పదార్ధాలు సమకూర్చుకుని నీ దగ్గర ఉంచుకోవాలి. అవి నీకు, వాటికి ఆహారం అవుతాయి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","దేవుడు నోవహుకు ఆజ్ఞాపించిన ప్రకారం అతడు అంతా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","యెహోవా “ఈ తరంలో నా దృష్టిలో నువ్వే నీతిమంతుడివిగా ఉండడం చూశాను కాబట్టి నువ్వు, నీ కుటుంబం ఓడలో ప్రవేశించండి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","శుద్ధమైన జంతువుల్లో ప్రతి జాతిలో మగవి ఏడు, ఆడవి ఏడు, శుద్ధంకాని జంతువుల్లో ప్రతి జాతిలో మగ ఆడ రెండు, ");
INSERT INTO tel2017_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ఆకాశపక్షుల్లో ప్రతి జాతిలో మగవి ఏడు, ఆడవి ఏడు తీసుకురావాలి. నువ్వు భూమి అంతటిమీద వాటి సంతానాన్ని ప్రాణంతో ఉంచి భద్రం చేసేలా అలా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ఎందుకంటే, ఇంకా ఏడు రోజుల్లో నేను, నలభై పగళ్ళు, నలభై రాత్రులు భూమిమీద వర్షం కురిపించి, నేను చేసిన జీవం ఉన్న ప్రతి దాన్ని నాశనం చేస్తాను” అని నోవహుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","తనకు యెహోవా ఆజ్ఞ ఇచ్చిన ప్రకారం నోవహు అంతా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ఆ జలప్రళయం భూమిమీదికి వచ్చినప్పుడు నోవహుకు వయస్సు ఆరు వందల సంవత్సరాలు. ");
INSERT INTO tel2017_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","నోవహు, అతనితోపాటు అతని కొడుకులు, అతని భార్య, అతని కోడళ్ళు ఆ జలప్రళయం తప్పించుకోడానికి ఆ ఓడలో ప్రవేశించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","దేవుడు నోవహుకు ఆజ్ఞాపించిన ప్రకారం శుద్ధ జంతువుల్లో, అపవిత్ర జంతువుల్లో, పక్షుల్లో నేలమీద పాకే వాటన్నిటిలో, ");
INSERT INTO tel2017_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","మగ, ఆడ, జతలుగా ఓడలో ఉన్న నోవహు దగ్గరికి చేరాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ఏడు రోజుల తరువాత ఆ ప్రళయజలాలు భూమిమీదికి వచ్చాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","నోవహు వయస్సు ఆరువందల సంవత్సరాల రెండు నెలల పదిహేడవ రోజున, మహా అగాధజలాల ఊటలన్నీ తెరుచుకున్నాయి. ఆకాశపు కిటికీలు తెరుచుకున్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","నలభై పగళ్ళు, నలభై రాత్రులు భూమి మీద వర్షం కురిసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ఆ రోజే నోవహు, నోవహు కొడుకులు షేము, హాము, యాపెతు, నోవహు భార్య, వాళ్ళతో పాటు అతని ముగ్గురు కోడళ్ళు ఆ ఓడలో ప్రవేశించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","వాళ్ళతోపాటు, వాటి వాటి జాతుల ప్రకారం ప్రతి మృగం, వాటి వాటి జాతుల ప్రకారం ప్రతి పశువు, వాటి వాటి జాతుల ప్రకారం నేలమీద పాకే ప్రతి పురుగు, వాటి వాటి జాతుల ప్రకారం ప్రతి పక్షి, నానావిధాల రెక్కల పక్షులు ప్రవేశించాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","శ్వాస తీసుకోగలిగి, శరీరం గల జీవులన్నీరెండేసి చొప్పున నోవహు దగ్గరికి వచ్చి, ఓడలో ప్రవేశించాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ప్రవేశించినవన్నీ దేవుడు అతనికి ఆజ్ఞాపించిన ప్రకారం శరీరం కలిగిన ఆ జీవులన్నీ, మగవిగా, ఆడవిగా, ప్రవేశించాయి. అప్పుడు యెహోవా, వాళ్ళను ఓడలో ఉంచి, ఓడ తలుపు మూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ఆ జలప్రళయం నలభై రోజులు భూమి మీదికి వచ్చినప్పుడు, నీళ్ళు విస్తరించి ఓడను నీళ్ళ మీద తేలేలా చేశాయి. ఓడ భూమి మీద నుంచి పైకి లేచింది. ");
INSERT INTO tel2017_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","నీళ్ళు భూమి మీద భీకరంగా ప్రవహించి అధికంగా విస్తరించినప్పుడు, ఆ ఓడ నీళ్ళ మీద తేలింది. ");
INSERT INTO tel2017_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ఆ భీకర జలాలు భూమి మీద పైపైకి లేచినప్పుడు, ఆకాశం కింద ఉన్న ఉన్నత పర్వతాలన్నీ మునిగిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ఉన్నత పర్వత శిఖరాలకన్నా పదిహేను మూరలు ఎత్తుగా నీళ్ళు విస్తరించాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","పక్షులు, పశువులు, మృగాలు భూమిమీద పాకే పురుగులు, శరీరం ఉండి భూమిమీద తిరిగేవన్నీ చనిపోయాయి. మనుషులందరూ చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","పొడి నేలమీద ఉన్న వాటన్నిటిలో, నాసికారంధ్రాల్లో ఊపిరి ఉన్నవన్నీ చనిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","మనుషులతో పాటు పశువులు, పురుగులు, ఆకాశపక్షులు, నేలమీద ఉన్న జీవాలన్నీ అంతం అయిపోయాయి. అవన్నీ భూమిమీద ఉండకుండాా నాశనం అయ్యాయి. నోవహు, అతనితో పాటు ఆ ఓడలో ఉన్నవి మాత్రం మిగిలాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","నూట ఏభై రోజుల వరకూ భూమి మీద నీళ్ళు ప్రబలాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","దేవుడు నోవహును, అతనితోపాటు ఓడలో ఉన్న ప్రతి జంతువునూ, పశువునూ జ్ఞాపకం చేసుకున్నాడు. దేవుడు భూమి మీద గాలి విసిరేలా చేయడంవల్ల నీళ్ళు తగ్గుముఖం పట్టాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","అగాధజలాల ఊటలు, ఆకాశపు కిటికీలు మూసుకొన్నాయి. ఆకాశం నుంచి కురుస్తున్న భీకర వర్షం ఆగిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","అప్పుడు నీళ్ళు భూమి మీద నుంచి క్రమక్రమంగా తగ్గిపోతూ వచ్చాయి. నూట ఏభై రోజుల తరువాత నీళ్ళు తగ్గిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ఏడవ నెల పదిహేడవ రోజున అరారాతు కొండలమీద ఓడ నిలిచింది. ");
INSERT INTO tel2017_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","పదో నెల వరకూ నీళ్ళు క్రమంగా తగ్గుతూ వచ్చాయి. పదోనెల మొదటి రోజున కొండల శిఖరాలు కనిపించాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","నలభై రోజులు గడిచిన తరువాత నోవహు ఓడ కిటికీ తీసి ");
INSERT INTO tel2017_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ఒక బొంతకాకిని బయటకు పోనిచ్చాడు. అది బయటకు వెళ్ళి భూమిమీద నుంచి నీళ్ళు ఇంకిపోయేవరకూ ఇటూ అటూ తిరుగుతూ ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","నీళ్ళు నేలమీదనుంచి తగ్గాయో లేదో చూడడానికి అతడు తన దగ్గరనుంచి ఒక పావురాన్ని బయటకు వదిలాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","భూమి అంతటా నీళ్ళు నిలిచి ఉన్నందువల్ల దానికి అరికాలు మోపడానికి స్థలం దొరకలేదు గనుక ఓడలో ఉన్న అతని దగ్గరికి తిరిగి వచ్చింది. అతడు చెయ్యి చాపి దాన్ని పట్టుకుని ఓడలోకి తీసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","అతడు మరో ఏడు రోజులు ఆగి ఆ పావురాన్ని ఓడలోనుంచి బయటకు పంపాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","సాయంకాలానికి అది అతని దగ్గరికి తిరిగి వచ్చింది. దాని నోట్లో అప్పుడే తుంచిన ఒలీవ ఆకు ఉంది. దీన్ని బట్టి నీళ్ళు నేల మీద ఇంకి పోయాయని నోవహు గ్రహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","అతడు మరో ఏడు రోజులు ఆగి ఆ పావురాన్ని బయటకు పంపాడు. అది అతని దగ్గరికి తిరిగి రాలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ఆరువందల ఒకటో సంవత్సరం మొదటి నెల మొదటి రోజున నీళ్ళు భూమి మీద నుంచి ఇంకిపోయాయి. నోవహు ఓడ కప్పు తీసి చూడగా ఆరిన నేల కనబడింది. ");
INSERT INTO tel2017_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","రెండో నెల ఇరవై ఏడో రోజున భూమి పొడిగా అయిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","అప్పుడు దేవుడు నోవహుతో, ");
INSERT INTO tel2017_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“నువ్వు, నీతోపాటు నీ భార్య, నీ కొడుకులు, కోడళ్ళు ఓడలోనుంచి బయటకు రండి. ");
INSERT INTO tel2017_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","పక్షులను, పశువులను భూమి మీద పాకే ప్రతి జాతి పురుగులను, శరీరం ఉన్న ప్రతి జీవినీ నీతోపాటు ఉన్న ప్రతి జంతువును నువ్వు వెంటబెట్టుకుని బయటకు రావాలి. అవి భూమిమీద అధికంగా విస్తరించి భూమి మీద ఫలించి అభివృద్ధి పొందాలి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","కాబట్టి నోవహు, అతనితోపాటు అతని కొడుకులు అతని భార్య, అతని కోడళ్ళు బయటకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ప్రతి జంతువు, పాకే ప్రతి పురుగు, ప్రతి పక్షి, భూమి మీద తిరిగేవన్నీ వాటి వాటి జాతుల ప్రకారం ఆ ఓడలోనుంచి బయటకు వచ్చాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","అప్పుడు నోవహు యెహోవాకు పవిత్రమైన పశువులు, పక్షులన్నిట్లో నుంచి కొన్నిటిని తీసి హోమబలి అర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","యెహోవా ఆ ఇంపైన వాసన ఆస్వాదించి “వారి హృదయాలు బాల్యం నుంచే దుష్టత్వం వైపు మొగ్గుచూపాయి. ఇక ఎప్పుడూ మనుషులను బట్టి భూమిని కీడుకు గురిచేయను. నేనిప్పుడు చేసినట్టు ప్రాణం ఉన్నవాటిని ఇకపై ఎన్నడూ నాశనం చెయ్యను. ");
INSERT INTO tel2017_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","భూమి ఉన్నంత వరకూ విత్తనాలు నాటేకాలం, కోతకాలం, వేసవి, శీతాకాలాలు, పగలూ రాత్రీ ఉండక మానవు” అని తన హృదయంలో అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","దేవుడు నోవహునూ అతని కొడుకులనూ ఆశీర్వదించాడు. “మీరు ఫలించి అభివృద్ధి పొంది భూమిని నింపండి. ");
INSERT INTO tel2017_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","అడవి జంతువులన్నిటికీ ఆకాశ పక్షులన్నిటికీ నేల మీద పాకే ప్రతి పురుగుకూ సముద్రపు చేపలన్నిటికీ మీరంటే భయం ఉంటుంది, అవి మిమ్మల్ని చూసి బెదురుతాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ప్రాణంతో కదలాడే ప్రతి జీవీ మీకు ఆహారం అవుతుంది. పచ్చని మొక్కలను ఇచ్చినట్టు ఇప్పుడు నేను ఇవన్నీ మీకు ఇచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","కాని ప్రాణమే రక్తం గనుక మీరు మాంసాన్ని దాని రక్తంతో పాటు తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","మీకు ప్రాణం అయిన మీ రక్తం గురించి లెక్క అడుగుతాను. దాని గురించి ప్రతి జంతువునీ ప్రతి మనిషినీ లెక్క అడుగుతాను. ప్రతి మనిషిని, అంటే తన సోదరుణ్ణి హత్యచేసిన ప్రతి మనిషినీ ఆ మనిషి ప్రాణం లెక్క అడుగుతాను. ");
INSERT INTO tel2017_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","దేవుడు తన స్వరూపంలో మనిషిని చేశాడు గనుక మనిషి రక్తాన్ని ఎవరు చిందిస్తారో, అతని రక్తాన్ని కూడా మనిషే చిందించాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","మీరు ఫలించి అభివృద్ధి పొందండి. మీరు భూమి మీద అధికంగా సంతానం కని విస్తరించండి” అని వాళ్ళతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","దేవుడు నోవహు, అతని కొడుకులతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“వినండి, నేను మీతోను, మీ తరువాత వచ్చే మీ సంతానంతోను, ");
INSERT INTO tel2017_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","మీతో పాటు ఉన్న ప్రతి జీవితోను, అవి పక్షులే గాని పశువులే గాని, మీతోపాటు ఉన్న ప్రతి జంతువే గాని, ఓడలోనుంచి బయటకు వచ్చిన ప్రతి భూజంతువుతో నా నిబంధన స్థిరం చేస్తున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","నేను మీతో నా నిబంధన స్థిరపరుస్తున్నాను. సర్వ శరీరులు ప్రవహించే జలాల వల్ల ఇంకెప్పుడూ నాశనం కారు. భూమిని నాశనం చెయ్యడానికి ఇంకెప్పుడూ జలప్రళయం రాదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","దేవుడు “నాకు, మీకు, మీతోపాటు ఉన్న జీవరాసులన్నిటికీ మధ్య నేను తరతరాలకు చేస్తున్న నిబంధనకు గుర్తు ఇదే, ");
INSERT INTO tel2017_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","మేఘంలో నా ధనుస్సు ఉంచాను. అది నాకు, భూమికి, మధ్య నిబంధనకు గుర్తుగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","భూమిమీదికి నేను మేఘాన్ని తీసుకొచ్చినప్పుడు మేఘంలో ఆ ధనుస్సు కనబడుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","అప్పుడు నాకు, మీకు, జీవరాసులన్నిటికీ మధ్య ఉన్న నా నిబంధన జ్ఞాపకం చేసుకొంటాను గనుక సర్వశరీరులను నాశనం చెయ్యడానికి ఇక ఎన్నడూ నీళ్ళు జలప్రళయంగా రావు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ఆ ధనుస్సు మేఘంలో ఉంటుంది. నేను దాన్ని చూసి దేవునికీ, భూమి మీద ఉన్న సర్వశరీరుల్లో ప్రాణం ఉన్న ప్రతి దానికీ మధ్య ఉన్న శాశ్వత నిబంధనను జ్ఞాపకం చేసుకొంటాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","దేవుడు “నాకు, భూమిమీద ఉన్న సర్వశరీరులకు మధ్య నేను స్థిరం చేసిన నిబంధనకు గుర్తు ఇదే” అని నోవహుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ఓడలోనుంచి వచ్చిన నోవహు ముగ్గురు కొడుకులు షేము, హాము, యాపెతు. హాము కనానుకు తండ్రి. ");
INSERT INTO tel2017_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","వీళ్ళ సంతానం, భూమి అంతటా వ్యాపించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","నోవహు భూమిని సాగుచేయడం ప్రారంభించి, ద్రాక్షతోట వేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ఆ ద్రాక్షారసం తాగి మత్తెక్కి తన గుడారంలో బట్టలు లేకుండా పడి ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","అప్పుడు కనాను తండ్రి అయిన హాము, తన తండ్రి బట్టలు లేకుండా పడి ఉండడం చూసి, బయట ఉన్న తన ఇద్దరు సోదరులకు ఆ విషయం చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","అప్పుడు షేము, యాపెతు, ఒక బట్ట తీసుకుని తమ ఇద్దరి భుజాల మీద వేసుకుని వెనుకగా నడిచివెళ్ళి తమ తండ్రి నగ్న శరీరానికి కప్పారు. వాళ్ళ ముఖాలు మరొక వైపు తిరిగి ఉన్నాయి గనుక వాళ్ళు తమ తండ్రి నగ్న శరీరం చూడలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","అప్పుడు నోవహు మత్తులోనుంచి మేల్కొని తన చిన్నకొడుకు చేసిన దాన్ని తెలుసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“కనాను శపితుడు. అతడు తన సోదరులకు దాసుడుగా ఉంటాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","అతడు “షేము దేవుడైన యెహోవా స్తుతి పొందుతాడు గాక. కనాను అతనికి సేవకుడవుతాడు గాక. ");
INSERT INTO tel2017_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","దేవుడు యాపెతును అభివృద్ధి చేస్తాడు గాక. అతడు షేము గుడారాల్లో నివాసం ఉంటాడు. అతనికి కనాను సేవకుడవుతాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ఆ జలప్రళయం తరువాత నోవహు మూడు వందల ఏభై సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","నోవహు మొత్తం తొమ్మిదివందల ఏభై సంవత్సరాలు జీవించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","నోవహు కొడుకులు షేము, హాము, యాపెతుల వంశావళి ఇది. జలప్రళయం తరువాత వాళ్లకు కొడుకులు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","యాపెతు సంతానం గోమెరు, మాగోగు, మాదయి, యావాను, తుబాలు, మెషెకు, తీరసు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","గోమెరు కొడుకులు అష్కనజు, రీఫతు, తోగర్మా. ");
INSERT INTO tel2017_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","యావాను సంతానం ఏలీషా, తర్షీషు, కిత్తీము, దాదోనీము. ");
INSERT INTO tel2017_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","వీళ్ళనుంచి సముద్రం వెంబడి మనుషులు వేరుపడి తమ ప్రాంతాలకు వెళ్ళారు. తమ తమ జాతుల ప్రకారం, తమ తమ భాషల ప్రకారం, తమ తమ వంశాల ప్రకారం, ఆ దేశాల్లో ఉన్నవాళ్ళు వేరైపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","హాము సంతానం కూషు, మిస్రాయిము, పూతు, కనాను. ");
INSERT INTO tel2017_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","కూషు కొడుకులు సెబా, హవీలా, సబ్తా, రాయమా, సబ్తకా. రాయమా కొడుకులు షేబ, దదాను. ");
INSERT INTO tel2017_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","కూషుకు నిమ్రోదు పుట్టాడు. అతడు భూమి మీద పరాక్రమం కలిగిన శూరుల్లో మొదటివాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","అతడు యెహోవా దృష్టిలో పరాక్రమం గల వేటగాడు. కాబట్టి “యెహోవా దృష్టిలో పరాక్రమం కలిగిన వేటగాడైన నిమ్రోదు వలే” అనే నానుడి ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","షీనారు ప్రాంతంలో ఉన్న బాబెలు, ఎరెకు, అక్కదు, కల్నే అనే పట్టణాలు అతని రాజ్యంలో ముఖ్య పట్టాణాలు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ఆ ప్రాంతంలో నుంచి అతడు అష్షూరుకు బయలుదేరి వెళ్ళి నీనెవె, రహోబోతీరు, కాలహు పట్టణాలను, ");
INSERT INTO tel2017_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","నీనెవె కాలహుల మధ్య రెసెను అనే ఒక పెద్ద పట్టాణాన్నీ కట్టించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","మిస్రాయిముకు లూదీ, అనామీ, లెహాబీ, నప్తుహీ, ");
INSERT INTO tel2017_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","పత్రుసీ, కస్లూహీ, కఫ్తోరీలు పుట్టారు. ఫిలిష్తీయులు కస్లూహీయుల సంతతి. ");
INSERT INTO tel2017_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","కనాను మొదటి కొడుకు సీదోనుకు హేతు, యెబూసీ, అమోరీయ, గిర్గాషీ, ");
INSERT INTO tel2017_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","హివ్వీ, అర్కీయు, సినీయ, ");
INSERT INTO tel2017_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","అర్వాదీయ, సెమారీయ, హమాతీలు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ఆ తరువాత కనానీయుల వంశాలు వ్యాప్తి చెందాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","కనానీయుల సరిహద్దు సీదోను నుంచి గెరారుకు వెళ్ళే దారిలో గాజా వరకూ, సొదొమ గొమొర్రా, అద్మా సెబోయిములకు వెళ్ళే దారిలో లాషా వరకూ ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","వీళ్ళు, తమ తమ వంశాల ప్రకారం, తమ తమ భాషల ప్రకారం, తమ తమ జాతులను బట్టి హాము సంతానం. ");
INSERT INTO tel2017_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","యాపెతు అన్న షేముకు కూడా సంతానం కలిగింది. ఏబెరు వంశానికి మూలపురుషుడు షేము. ");
INSERT INTO tel2017_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","షేము కొడుకులు ఏలాము, అష్షూరు, అర్పక్షదు, లూదు, అరాము. ");
INSERT INTO tel2017_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","అరాము కొడుకులు ఊజు, హూలు, గెతెరు, మాష. ");
INSERT INTO tel2017_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","అర్పక్షదుకు షేలహు పుట్టాడు. షేలహుకు ఏబెరు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ఏబెరుకు ఇద్దరు కొడుకులు పుట్టారు. వాళ్ళల్లో ఒకడు పెలెగు. ఎందుకంటే అతని రోజుల్లో భూమి విభజన జరిగింది. రెండవవాడు యొక్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","యొక్తానుకు అల్మోదాదు, షెలపు, హసర్మావెతు, యెరహు, ");
INSERT INTO tel2017_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","హదోరము, ఊజాలు, దిక్లా, ");
INSERT INTO tel2017_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ఓబాలు, అబీమాయెలు, షేబ, ");
INSERT INTO tel2017_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ఓఫీరు, హవీలా, యోబాబులు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","వాళ్ళు నివాసం ఉండే స్థలాలు మేషా నుంచి సపారాకు వెళ్ళే దారిలో తూర్పు కొండలు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","వీళ్ళు, తమ తమ వంశాల ప్రకారం, తమ తమ భాషల ప్రకారం, తమ తమ ప్రాంతాలను బట్టి, తమ తమ జాతులను బట్టి షేము కొడుకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","తమ తమ జనాల్లో తమ తమ సంతానాల ప్రకారం నోవహు కొడుకుల వంశాలు ఇవే. జలప్రళయం జరిగిన తరువాత వీళ్ళల్లోనుంచి జనాలు భూమి మీద వ్యాప్తి చెందారు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","అప్పుడు భూమిపై అందరూ ఒకే భాష మాట్లాడేవారు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","వాళ్ళు తూర్పుకు ప్రయాణం చేస్తున్నప్పుడు షీనారు ప్రాంతంలో వాళ్లకు ఒక మైదానం కనబడింది. వాళ్ళు అక్కడ స్థిరపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","వాళ్ళు ఒకరితో ఒకరు “మనం ఇటుకలు తయారు చేసి, చక్కగా కాల్చుదాం రండి” అని మాట్లాడుకున్నారు. రాళ్ళకు బదులు ఇటుకలు, అతకడానికి తారు కీలు వాళ్లకు అందుబాటులో ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","వాళ్ళు “మనం భూమి అంతటా చెదిరిపోకుండా ఉండేలా ఒక పట్టణాన్ని, ఆకాశాన్ని అంటే శిఖరం ఉన్న ఒక గోపురం కట్టుకుని పేరు సంపాదించుకుందాం రండి” అని మాట్లాడుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","యెహోవా ఆదాము సంతానం కట్టిన పట్టణాన్ని, గోపురాన్ని, చూడడానికి దిగి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","యెహోవా “ఇదిగో, ఒకే భాష ఉన్న ఈ మనుషులు పని చేయడం ప్రారంభించారు! ఇకముందు వాళ్ళు చెయ్యాలనుకున్న ఏ పనైనా వాళ్లకు అసాధ్యం కాదు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","కాబట్టి మనం కిందికి వెళ్లి, వాళ్ళల్లో ఒకరి మాట ఒకరికి తెలియకుండా అక్కడ వాళ్ళ భాషను తారుమారు చేద్దాం రండి” అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ఆ విధంగా యెహోవా వారు అక్కడ నుంచి భూమి అంతటా చెదిరిపోయేలా చేశాడు. ఆ పట్టణ నిర్మాణం ఆగిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","అందువల్ల దానికి బాబెలు అనే పేరు పెట్టారు. ఎందుకంటే, అక్కడ యెహోవా భూమి మీద ఉన్న ప్రజలందరి భాషను తారుమారు చేశాడు. అక్కడ నుంచి యెహోవా వాళ్ళను భూమి మీద అనేక ప్రదేశాలకు చెదరగొట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","షేము వంశావళి ఇది. షేముకు వంద సంవత్సరాల వయస్సులో, జలప్రళయం తరువాత రెండు సంవత్సరాలకు అర్పక్షదు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","షేముకు అర్పక్షదు పుట్టిన తరువాత ఇంకా అతనికి కొడుకులు, కూతుళ్ళు పుట్టారు. అతడు ఐదు వందల సంవత్సరాలు బ్రతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","అర్పక్షదుకు ముప్ఫై ఐదు సంవత్సరాల వయస్సులో షేలహు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","అర్పక్షదుకు షేలహు పుట్టిన తరువాత ఇంకా అతనికి కొడుకులు, కూతుళ్ళు పుట్టారు. అతడు నాలుగు వందల మూడు సంవత్సరాలు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","షేలహుకు ముప్ఫై సంవత్సరాల వయస్సులో ఏబెరు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","షేలహుకు ఏబెరు పుట్టిన తరువాత ఇంకా అతనికి కొడుకులు, కూతుళ్ళు పుట్టారు. అతడు నాలుగు వందల మూడు సంవత్సరాలు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ఏబెరుకు ముప్ఫై నాలుగు సంవత్సరాల వయస్సులో పెలెగు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ఏబెరుకు పెలెగు పుట్టిన తరువాత ఇంకా అతనికి కొడుకులు, కూతుళ్ళు పుట్టారు. అతడు నాలుగు వందల ముప్ఫైసంవత్సరాలు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","పెలెగుకు ముప్ఫై సంవత్సరాల వయస్సులో రయూ పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","పెలెగుకు రయూ పుట్టిన తరువాత ఇంకా అతనికి కొడుకులు, కూతుళ్ళు పుట్టారు. అతడు రెండువందల తొమ్మిది సంవత్సరాలు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","రయూకు ముప్ఫై రెండు సంవత్సరాల వయస్సులో సెరూగు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","రయూకు సెరూగు పుట్టిన తరువాత ఇంకా అతనికి కొడుకులు, కూతుళ్ళు పుట్టారు. అతడు రెండు వందల ఏడు సంవత్సరాలు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","సెరూగుకు ముప్ఫై సంవత్సరాల వయస్సులో నాహోరు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","సెరూగుకు నాహోరు పుట్టిన తరువాత ఇంకా అతనికి కొడుకులు, కూతుళ్ళు పుట్టారు, అతడు రెండువందల సంవత్సరాలు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","నాహోరుకు ఇరవై తొమ్మిది సంవత్సరాల వయస్సులో తెరహు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","నాహోరుకు తెరహు పుట్టిన తరువాత ఇంకా అతనికి కొడుకులు, కూతుళ్ళు పుట్టారు. అతడు నూట పంతొమ్మిది సంవత్సరాలు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","తెరహుకు డెబ్భై సంవత్సరాల వయస్సులో అబ్రాము, నాహోరు, హారానులు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","తెరహు వంశావళి ఇది: తెరహుకు అబ్రాము, నాహోరు, హారానులు పుట్టారు. హారానుకు లోతు పుట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","హారాను, తాను పుట్టిన ప్రదేశంలో ఊరు అనే కల్దీయుల పట్టణంలో తన తండ్రి తెరహు కంటే ముందే చనిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","అబ్రాము, నాహోరు పెళ్ళిళ్ళు చేసుకున్నారు. అబ్రాము భార్య శారయి. నాహోరు భార్య పేరు మిల్కా. ఆమె మిల్కా, ఇస్కాలకు తండ్రి అయిన హారాను కూతురు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","శారయి గొడ్రాలు. ఆమెకు పిల్లలు లేరు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","తెరహు తన కొడుకు అబ్రామును, తన మనుమడు, హారాను కొడుకు లోతును, తన కోడలు శారయిని తీసుకు కనానుకు బయలుదేరాడు. ఊరు అనే కల్దీయుల పట్టణంలో నుంచి వాళ్ళతోపాటు బయలుదేరి హారాను వరకూ వచ్చి అక్కడ నివాసం ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","తెరహు రెండు వందల ఐదు సంవత్సరాలు బతికి, హారానులో చనిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","యెహోవా అబ్రాముతో ఇలా చెప్పాడు. “నీ దేశం నుంచి, నీ బంధువుల దగ్గర నుంచి, నీ తండ్రి ఇంటి నుంచి బయలుదేరి, నేను నీకు చూపించే ప్రదేశానికి వెళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","నిన్ను ఒక గొప్ప జాతిగా చేసి, నిన్ను ఆశీర్వదించి, నీ పేరును గొప్పచేస్తాను. నువ్వు దీవెనగా ఉంటావు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","నిన్ను ఆశీర్వదించే వాళ్ళను నేను ఆశీర్వదిస్తాను. నిన్ను దూషించేవాళ్ళను శపిస్తాను. భూమి మీద ఉన్న వంశాలన్నిటికీ నీ ద్వారా ఆశీర్వాదం కలుగుతుంది.” ");
INSERT INTO tel2017_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","యెహోవా అతనికి చెప్పినట్టు అబ్రాము చేశాడు. అతనితోపాటు లోతు కూడా బయలుదేరాడు. హారాను నుంచి బయలుదేరినప్పుడు అబ్రాము వయసు డెబ్భై ఐదు సంవత్సరాలు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","అబ్రాము తన భార్య శారయిని, తన సోదరుడి కొడుకు లోతును, హారానులో తాను, తనవాళ్ళు, సేకరించిన ఆస్తి అంతటినీ, వాళ్ళ సంపాదన మొత్తాన్నీ తీసుకుని కనాను అనే ప్రదేశానికి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","అబ్రాము ఆ ప్రదేశంలో షెకెములో ఉన్న ఒక ప్రాంతానికి వచ్చి మోరే ప్రాంతంలో సింధూర వృక్షం దగ్గరికి చేరుకున్నాడు. అప్పటికి ఆ ప్రదేశంలో కనానీయులు నివాసం ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","యెహోవా అబ్రాముతో “నీ వారసులకు ఈ దేశాన్ని ఇస్తాను” అని చెప్పాడు. అక్కడ అతడు యెహోవాకు హోమ బలి అర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","అతడు అక్కడనుంచి బయలుదేరి బేతేలుకు తూర్పువైపు ఉన్న కొండ దగ్గరికి వచ్చాడు. పడమర వైపు ఉన్న బేతేలుకు, తూర్పున ఉన్న హాయికి మధ్య గుడారం వేసి అక్కడ యెహోవాకు హోమబలి అర్పించి, యెహోవా పేరట ప్రార్థన చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","అబ్రాము ఇంకా ప్రయాణం చేస్తూ దక్షిణం వైపు వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","అప్పుడు ఆ ప్రదేశంలో కరువు వచ్చింది. కరువు తీవ్రంగా ఉన్న కారణంగా అబ్రాము ఐగుప్తులో నివసించడానికి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","అతడు ఐగుప్తులో ప్రవేశించడానికి ముందు తన భార్య శారయితో “చూడు, నువ్వు చాలా అందగత్తెవని నాకు తెలుసు, ");
INSERT INTO tel2017_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ఐగుప్తీయులు నిన్ను చూసి, ‘ఈమె అతని భార్య’ అని నీ మూలంగా నన్ను చంపుతారు. కాని నిన్ను బ్రతకనిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","నీ వల్ల నాకు మేలు కలిగేలా, నీ కారణంగా నేను చావకుండేలా నువ్వు నా సోదరివి అని దయచేసి చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","అబ్రాము ఐగుప్తులో ప్రవేశించినప్పుడు ఐగుప్తీయులు శారయి చాలా అందంగా ఉండడం గమనించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ఫరో అధిపతులు ఆమెను చూసి ఫరో దగ్గర ఆమె అందాన్ని పొగిడారు. ఆమెను ఫరో ఇంటికి తీసుకెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ఆమె మూలంగా అతడు అబ్రామును చాలా బాగా చూసుకున్నాడు. అతనికి గొర్రెలు, ఎడ్లు, మగ గాడిదలు, సేవకులు, పనికత్తెలు, ఆడగాడిదలు, ఒంటెలు ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","అప్పుడు యెహోవా అబ్రాము భార్య శారయిని బట్టి ఫరోను, అతని ఇంటివాళ్ళను తీవ్రమైన రోగాలతో బాధపరిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","అప్పుడు ఫరో అబ్రామును పిలిపించి “నువ్వు నాకు చేసిందేమిటి? ఈమె నీ భార్య అని నాకెందుకు చెప్పలేదు? ");
INSERT INTO tel2017_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ఈమె నా సోదరి అని ఎందుకు చెప్పావు? ఒకవేళ నేను ఆమెను నా భార్యగా చేసుకుని ఉంటే ఏమి జరిగేది? ఇదిగో నీ భార్య. ఈమెను తీసుకువెళ్ళు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","తరువాత ఫరో అతని గూర్చి ప్రజలకు ఆజ్ఞాపించాడు. వాళ్ళు అబ్రామును అతని భార్యతో అతని ఆస్తిపాస్తులన్నిటితో సహా పంపివేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","అబ్రాము తనకు కలిగిన వాటినన్నిటినీ, తన భార్యనూ, తనతో ఉన్న లోతును వెంటబెట్టుకుని ఐగుప్తు నుంచి నెగెబుకు వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","అబ్రాము చాలా ధనవంతుడు. అతనికి వెండి, బంగారం, పశువులు ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","అతడు ప్రయాణం చేసి దక్షిణం నుంచి బేతేలు వరకూ అంటే బేతేలుకు, హాయికి మధ్య మొదట తన గుడారం ఉన్న స్థలానికి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","అతడు మొదట బలిపీఠం కట్టిన చోటుకు వచ్చాడు. అక్కడ అబ్రాము యెహోవా పేరట ప్రార్థన చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","అబ్రాముతో పాటు కలసి వెళ్ళిన లోతుకు కూడా గొర్రెలు, పశువులు, పరివారం ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","వాళ్ళు కలిసి నివాసం చెయ్యడానికి ఆ ప్రదేశం చాల లేదు. ఎందుకంటే వాళ్ళు కలిసి ఉండలేనంత విస్తారమైన సంపద వారికి ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ఆ సమయంలో అబ్రాము పశువుల కాపరులకు, లోతు పశువుల కాపరులకు వివాదం ఏర్పడింది. ఆ కాలంలో కనానీయులు, పెరిజ్జీయులు ఆ ప్రదేశంలో కాపురం ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","కాబట్టి అబ్రాము “మనం బంధువులం కాబట్టి నాకూ నీకూ నా పశువుల కాపరులకూ నీ పశువుల కాపరులకూ ఘర్షణ ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ఈ ప్రదేశం అంతా నీ ముందు కనిపిస్తూ ఉంది కదా. దయచేసి నన్ను విడిచిపెట్టి వేరుగా ఉండు. నువ్వు ఎడమవైపు వెళ్తే నేను కుడివైపుకు, నువ్వు కుడివైపుకు వెళ్తే నేను ఎడమవైపుకు వెళ్తాను” అని లోతుకు చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","లోతు యొర్దాను మైదాన ప్రాంతం అంతా గమనించి చూశాడు. యెహోవా సొదొమ గొమొర్రా అనే పట్టణాలు నాశనం చెయ్యక ముందు సోయరుకు వచ్చే వరకూ ఆ ప్రాంతం అంతా యెహోవా తోట వలే ఐగుప్తు దేశంలో నీళ్ళు పారే ప్రాంతంలాగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","కాబట్టి లోతు యొర్దాను ప్రాంతాన్ని తన కోసం ఎంపిక చేసుకుని, తూర్పు వైపు ప్రయాణం చేశాడు. ఆ విధంగా వాళ్ళు ఒకరినుంచి ఒకరు వేరైపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","అబ్రాము కనానులో నివాసం ఉన్నాడు. లోతు ఆ మైదానంలో ఉన్న పట్టణాల్లో కాపురం ఉండి, సొదొమ దగ్గర తన గుడారం వేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","సొదొమ మనుషులు యెహోవా దృష్టిలో ఘోర పాపులుగా ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","లోతు అబ్రామును విడిచి వెళ్ళిన తరువాత యెహోవా “నువ్వు ఉన్నచోటనుంచి నాలుగు దిక్కులకూ చూడు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","నువ్వు చూస్తున్న ఈ ప్రదేశం అంతా నీకు, నీ వారసులకు శాశ్వతంగా ఇస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","నీ వారసులను భూమి మీద ఉండే ఇసుక రేణువుల్లాగా విస్తరింపజేస్తాను. ఇది ఎలాగంటే, ఎవడైనా భూమి మీద ఉండే ఇసుక రేణువులను లెక్కించగలిగితే, నీ వారసులనుకూడా లెక్కపెట్టవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","నువ్వు లేచి ఈ ప్రదేశంలో ఆ చివరినుండి ఈ చివరి వరకూ సంచరించు. అదంతా నీకు ఇస్తాను” అని అబ్రాముతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","అప్పుడు అబ్రాము తన గుడారం తీసి, హెబ్రోనులో ఉన్న మమ్రే దగ్గర ఉన్న సింధూర వృక్షాల దగ్గర వేసుకుని అక్కడ నివసించాడు. అక్కడ యెహోవాకు బలిపీఠం కట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","షీనారు రాజు అమ్రాపేలు, ఎల్లాసరు రాజు అర్యోకు, ఏలాము రాజు కదొర్లాయోమెరు, గోయీయుల రాజు తిదాలు అనేవారు పాలిస్తున్న రోజుల్లో ");
INSERT INTO tel2017_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ఆ రాజులు సొదొమ రాజు బెరాతో, గొమొర్రా రాజు బిర్షాతో, అద్మా రాజు షినాబుతో, సెబోయీయుల రాజు షెమేబెరుతో, బెల (దీన్ని సోయరు అని కూడా పిలుస్తారు) రాజుతో యుద్ధం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","వీళ్ళందరూ కలిసి సిద్దీము (ఉప్పు సముద్రం) లోయలో ఏకంగా సమకూడారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ఈ రాజులు పన్నెండు సంవత్సరాలు కదొర్లాయోమెరుకు లొంగి ఉన్నారు. పదమూడో సంవత్సరంలో తిరుగుబాటు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","పద్నాలుగో సంవత్సరంలో కదొర్లాయోమెరు, అతనితోపాటు ఉన్న రాజులు వచ్చి అష్తారోత్‌ కర్నాయిములో రెఫాయీయులపై, హాములో జూజీయులపై, షావే కిర్యతాయిము మైదానంలో ఏమీయులపై, ");
INSERT INTO tel2017_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","శేయీరు పర్వత ప్రదేశంలో అరణ్యం వైపుగా ఉన్న ఏల్ పారాను వరకూ ఉన్న హోరీయులపై దాడి చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","తరువాత మళ్ళీ ఏన్మిష్పతుకు (దీన్ని కాదేషు అనికూడా పిలుస్తారు) వచ్చి అమాలేకీయుల దేశమంతటినీ హససోను తామారులో కాపురం ఉన్న అమోరీయులను కూడా ఓడించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","అప్పుడు సొదొమ, గొమొర్రా, అద్మా, సెబోయీము, బెల (సోయరు) రాజులు బయలుదేరి సిద్దీము లోయలో ");
INSERT INTO tel2017_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ఏలాము రాజు కదొర్లాయోమెరు, గోయీయుల రాజు తిదాలు, షీనారు రాజు అమ్రాపేలు, ఎల్లాసరు రాజు అర్యోకు అనే నలుగురితో ఈ ఐదుగురు రాజులు యుద్ధం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ఆ సిద్దీము లోయలో తారు బంక గుంటలు ఎక్కువగా ఉన్నాయి. సొదొమ గొమొర్రాల రాజులు పారిపోయి వాటిలో పడ్డారు. మిగిలిన వాళ్ళు కొండలకు పారిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","అప్పుడు వాళ్ళు సొదొమ గొమొర్రాల ఆస్తి అంతటినీ వాళ్ళ భోజన పదార్ధాలన్నిటినీ దోచుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ఇంకా అబ్రాము సోదరుడి కొడుకు లోతు సొదొమలో కాపురం ఉన్నాడు గనుక అతణ్ణి, అతని ఆస్తిని కూడా దోచుకుని తీసుకుపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ఒకడు తప్పించుకుని వచ్చి హెబ్రీయుడైన అబ్రాముకు ఆ సంగతి తెలియజేశాడు. ఆ సమయంలో అతడు ఎష్కోలు, ఆనేరుల సోదరుడు మమ్రే అనే అమోరీయునికి చెందిన సింధూర వృక్షాల దగ్గర కాపురం ఉన్నాడు. వీళ్ళు అబ్రాముతో పరస్పర సహాయం కోసం ఒప్పందం చేసుకున్నవాళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","తన బంధువు శత్రువుల స్వాధీనంలో ఉన్నాడని అబ్రాము విని, తన ఇంట్లో పుట్టి, సుశిక్షితులైన మూడువందల పద్దెనిమిది మందిని వెంటబెట్టుకుని వెళ్లి దాను వరకూ ఆ రాజులను తరిమాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","రాత్రి సమయంలో అతడు తన సేవకులను గుంపులుగా చేశాక వాళ్ళంతా అ రాజులపై దాడి చేసి, దమస్కుకు ఎడమవైపు ఉన్న హోబా వరకూ తరిమాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","అతడు ఆస్తి మొత్తాన్ని, అతని బంధువు లోతును, అతని ఆస్తిని, స్త్రీలను, ప్రజలను వెనక్కి తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","అతడు కదొర్లాయోమెరును, అతనితో ఉన్న రాజులను ఓడించి తిరిగి వస్తున్నప్పుడు, సొదొమ రాజు అతన్ని ఎదుర్కోడానికి రాజు లోయ అనే షావే లోయ వరకూ బయలుదేరి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","అంతేగాక షాలేము రాజు మెల్కీసెదెకు రొట్టె, ద్రాక్షారసం తీసుకువచ్చాడు. అతడు సర్వోన్నతుడైన దేవునికి యాజకుడు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","అతడు అబ్రామును ఆశీర్వదించి “ఆకాశానికి భూమికి సృష్టికర్త, సర్వోన్నతుడు అయిన దేవుని వలన అబ్రాముకు ఆశీర్వాదం కలుగు గాక. ");
INSERT INTO tel2017_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","నీ శత్రువులను నీ చేతికి అప్పగించిన సర్వోన్నతుడైన దేవునికి స్తుతి కలుగు గాక” అని చెప్పాడు. అప్పుడు అబ్రాము అతనికి తనకున్న దానిలో పదవ వంతు ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","సొదొమ రాజు “మనుషులను నాకు ఇచ్చి ఆస్తిని నువ్వే తీసుకో” అని అబ్రాముతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","అబ్రాము “దేవుడైన యెహోవా అబ్రామును ధనవంతుణ్ణి చేశాను, అని నువ్వు చెప్పకుండా ఉండేలా, ఒక్క నూలు పోగైనా, చెప్పుల పట్టీ అయినా నీ వాటిలోనుండి తీసుకోను. ");
INSERT INTO tel2017_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ఆకాశానికి భూమికి సృష్టికర్త, సర్వోన్నతుడైన దేవుడైన యెహోవా దగ్గర నా చెయ్యి ఎత్తి ఒట్టు పెట్టుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ఈ యువకులు తిన్నది గాక, నాతోపాటు వచ్చిన ఆనేరు, ఎష్కోలు, మమ్రే అనే వాళ్లకు ఏ వాటా రావాలో ఆ వాటాలు మాత్రం వాళ్ళను తీసుకోనివ్వు” అని సొదొమ రాజుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ఈ సంగతులు జరిగిన తరువాత యెహోవా దూత అబ్రాముకు దర్శనమిచ్చాడు. “అబ్రామూ, భయపడకు! నేనే నీకు డాలును, గొప్ప బహుమానాన్ని” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","అబ్రాము “ప్రభూ యెహోవా, నాకేం ఇస్తావు? నేను సంతానం లేనివాడిగా ఉండిపోతున్నాను కదా. దమస్కు వాడైన ఎలీయెజెరే నా ఆస్తికి వారసుడు అవుతాడు కదా! ");
INSERT INTO tel2017_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","నువ్వు నాకు సంతానం ఇవ్వలేదు గనుక, చూడు, నా సేవకుల్లో ఒకడు నాకు వారసుడు అవుతాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","యెహోవా వాక్కు అతని దగ్గరికి వచ్చి “ఇతడు నీ వారసుడు కాడు. నీ ద్వారా నీకు పుట్టబోయేవాడే నీ వారసుడు అవుతాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ఆయన అతణ్ణి బయటకు తీసుకువచ్చి “నువ్వు ఆకాశం వైపు చూసి, ఆ నక్షత్రాలు లెక్కపెట్టడం నీకు చేతనైతే లెక్కపెట్టు” అని చెప్పి “నీ సంతానం కూడా అలా అవుతుంది” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","అతడు యెహోవాను నమ్మాడు. ఆ నమ్మకాన్నే ఆయన అతనికి నీతిగా పరిగణించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","యెహోవా “నీకు ఈ ప్రదేశాన్ని వారసత్వంగా ఇవ్వడానికి కల్దీయుల ఊర్ అనే పట్టణంలో నుంచి నిన్ను ఇవతలకు తీసుకువచ్చిన యెహోవాను నేనే” అని చెప్పినప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","అతడు “ప్రభూ యెహోవా, ఇది నాకు సొంతం అవుతుందని నాకు ఎలా తెలుస్తుంది?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ఆయన “మూడేళ్ళ వయసు ఉన్న ఒక దూడ, ఒక మేక, ఒక పొట్టేలు, ఒక తెల్ల గువ్వ, ఒక పావురం పిల్లను నా దగ్గరికి తీసుకురా” అని అతనితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","అతడు వాటిని తీసుకుని వాటిని సగానికి రెండు ముక్కలుగా నరికి, రెండు సగాలను ఎదురెదురుగా పెట్టాడు. పక్షులను మాత్రం ఖండించలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ఆ మృతదేహాల మీద గద్దలు వాలగా అబ్రాము వాటిని తోలివేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","చీకటి పడుతున్నప్పుడు అబ్రాముకు గాఢ నిద్ర పట్టింది. భయం కలిగించే చిమ్మచీకటి అతణ్ణి ఆవరించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ఆయన “దీన్ని కచ్చితంగా తెలుసుకో. నీ వారసులు తమది కాని దేశంలో పరదేశులుగా నివాసం ఉంటారు. ఆ దేశవాసులకు బానిసలుగా నాలుగు వందల సంవత్సరాలు అణచివేతకు గురి అవుతారు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","వీళ్ళు దాసులుగా ఉన్న ఆ దేశానికి నేను తీర్పు తీరుస్తాను. ఆ తరువాత వాళ్ళు అపారమైన సంపదతో బయటకు వస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","కాని, నువ్వు నీ తండ్రుల దగ్గరికి ప్రశాంతంగా చేరుకుంటావు. పండు ముసలితనంలో నువ్వు మరణించగా నిన్ను పాతిపెడతారు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","అమోరీయుల అక్రమం ఇంకా హద్డు మీరలేదు గనుక, నీ నాలుగవ తరం మనుషులు ఇక్కడికి తిరిగి వస్తారని కచ్చితంగా తెలుసుకో” అని అబ్రాముతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","సూర్యుడు అస్తమించి చీకటి పడినప్పుడు, పొగ లేస్తున్న కొలిమి, మండుతున్న కాగడా దిగివచ్చి పేర్చిన మాంస ఖండాల మధ్యగా దాటుకుంటూ వెళ్ళాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ఆ రోజున యెహోవా “ఐగుప్తు నది నుంచి, పేరుగాంచిన యూఫ్రటీసు నది వరకూ ఉన్న ఈ ప్రదేశాన్ని నీ వారసులకు ఇస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","కేనీయులను, కనిజ్జీయులను, కద్మోనీయులను, ");
INSERT INTO tel2017_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","హిత్తీయులను, పెరిజ్జీయులను, రెఫాయీయులను, ");
INSERT INTO tel2017_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","అమోరీయులను, కనానీయులను, గిర్గాషీయులను, యెబూసీయులను నీ వారసులకు దాసులుగా చేస్తాను” అని అబ్రాముతో నిబంధన చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","అబ్రాముకు భార్య శారయి వల్ల పిల్లలు పుట్టలేదు. ఆమె దగ్గర ఈజిప్ట్ దేశానికి చెందిన ఒక దాసి ఉంది. ఆమె పేరు హాగరు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","శారయి అబ్రాముతో “ఇదుగో, యెహోవా నాకు పిల్లలు లేకుండా చేశాడు. నువ్వు నా దాసి దగ్గరికి వెళ్ళు. ఒకవేళ ఆమె ద్వారా నాకు పిల్లలు పుట్టవచ్చేమో” అంది. అబ్రాము శారయి మాట విన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","అబ్రాము అప్పటికి కనాను దేశంలో పదేళ్ల నుండి నివాసముంటున్నాడు. అబ్రాము భార్య శారయి ఈజిప్టుకు చెందిన తన దాసి హాగరును తన భర్తకు భార్యగా ఉండటానికి ఇచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","అతడు హాగరుతో సంబంధం పెట్టుకున్నాడు. దాంతో ఆమె గర్భం ధరించింది. తాను గర్భం ధరించానని తెలుసుకున్న హాగరు తన యజమానురాలిని చులకనగా చూడటం ప్రారంభించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","అప్పుడు శారయి అబ్రాముతో “నా ఉసురు నీకు తగులుతుంది. ఇదంతా నీ వల్లే జరిగింది. నా దాసిని నేనే నీ చేతుల్లో పెట్టాను. ఆమె గర్భవతి అయింది. అది తెలిసిన దగ్గరనుండీ అది కన్నూమిన్నూ గానక నన్ను చులకనగా చూడటం మొదలు పెట్టింది. నీకూ నాకూ మధ్యన యెహోవా న్యాయం తీరుస్తాడు” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","అందుకు అబ్రాము “ఇలా చూడు, నీ దాసి నీ చెప్పుచేతల్లోనే ఉంది గదా. ఆమె విషయంలో నీ ఇష్టం వచ్చినట్టు చేసుకో” అన్నాడు. శారయి తన దాసిని రాచి రంపాన పెట్టింది. దాంతో ఆమె శారయి దగ్గర నుండి పారిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","షూరుకు వెళ్ళే దారిలో అడవిలో నీటి ఊట దగ్గర యెహోవా దూత ఆమెను చూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ఆమెతో “శారయి దాసివైన హాగరూ, ఎక్కడ నుండి వస్తున్నావ్? ఎక్కడికి వెళ్తున్నావ్?” అని అడిగాడు. అందుకామె “నా యజమానురాలైన శారయి దగ్గరనుండి పారిపోతున్నాను” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","అప్పుడు యెహోవా దూత “నువ్వు మళ్ళీ నీ యజమానురాలి దగ్గరికి తిరిగి వెళ్ళు. ఆమెకు పూర్తిగా అణిగి మణిగి ఉండు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","యెహోవా దూత ఇంకా ఇలా చెప్పాడు. “నీ సంతానానికి తప్పకుండా ఆధిక్యత కలిగిస్తాను. అది లెక్క పెట్టడానికి వీలు లేనంతగా అయ్యేలా చేస్తాను” అని ఆమెకు చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","తరువాత యెహోవా దూత “ఇలా చూడు, యెహోవా నీ మొర విన్నాడు. ఇప్పుడు నువ్వు గర్భవతిగా ఉన్నావు. నీకు కొడుకు పుడతాడు. అతనికి ఇష్మాయేలు అనే పేరు పెడతావు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","అతడు అడవి గాడిదలా స్వేచ్ఛాజీవిగా ఉంటాడు. అందరూ అతనికి విరోధంగా ఉంటారు. అతడు ప్రతి ఒక్కరికీ తూర్పు దిక్కున నివసిస్తాడు. అతడు తన సోదరులకు వేరుగా నివసిస్తాడు” అని ఆమెకు చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","అప్పుడు ఆమె “నన్ను చూసినవాడు నాకు నిజంగా కనిపించాడు కదా!” అంది. అందుకనే తనతో మాట్లాడిన యెహోవాకు “నన్ను చూస్తున్న దేవుడివి నువ్వే” అనే పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","దీన్ని బట్టి ఆ నీటి ఊటకి “బెయేర్‌ లహాయి రోయి” అనే పేరు వచ్చింది. అది కాదేషుకీ బెరెదుకీ మధ్యలో ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","తరువాత హాగరు అబ్రాము కొడుక్కి జన్మనిచ్చింది. హాగరు ద్వారా పుట్టిన తన కుమారుడికి అబ్రాము ఇష్మాయేలు అనే పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","అబ్రాము కొడుకు ఇష్మాయేలుకు హాగరు జన్మనిచ్చినప్పుడు అబ్రాము వయస్సు ఎనభై ఆరేళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","అబ్రాముకు తొంభై తొమ్మిది ఏళ్ల వయసులో యెహోవా అతనికి ప్రత్యక్షమై “నేను సర్వశక్తి గల దేవుణ్ణి. నా సముఖంలో మెలగుతూ నిందారహితుడిగా ఉండు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","అప్పుడు నాకూ నీకూ మధ్య ఉన్న నిబంధనను నేను స్థిరం చేస్తాను. నీ సంతానాన్ని అత్యధికంగా విస్తరింపజేస్తాను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","అబ్రాము సాష్టాంగపడి తన ముఖాన్ని నేలకు వంచుకుని ఉన్నాడు. దేవుడు ఇంకా ఇలా అన్నాడు. “చూడు, నేను నీతో నిబంధన చేశాను. ");
INSERT INTO tel2017_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","నువ్వు అనేక జాతులకు మూల పురుషుడివి అవుతావు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ఇకపైన నీ పేరు అబ్రాము కాదు. నిన్ను అనేక జాతులకు తండ్రిగా నియమిస్తున్నాను కనుక ఇకనుండి నీ పేరు అబ్రాహాము అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","నిన్ను అత్యధికంగా ఫలింపజేస్తాను. నీ సంతానం అనేక జాతులుఅయ్యేలా చేస్తాను. నీ సంతానంలో రాజులు జన్మిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","నేను నీకూ నీ తరువాత నీ సంతానానికీ దేవుడిగా ఉండే విధంగా నాకూ నీకూ మధ్యన, నీ తరువాత నాకూ నీ సంతానానికీ మధ్యన నా నిబంధనను స్థిరం చేస్తాను. అది శాశ్వతమైన నిబంధనగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","నీకూ నీ తరువాత నీ సంతానానికీ ప్రస్తుతం నువ్వు పరదేశిగా ఉన్న భూమిని, అంటే కనాను దేశాన్నంతా ఇస్తాను. దాన్ని శాశ్వత సంపదగా ఇచ్చి వారికి దేవుడిగా ఉంటాను.” ");
INSERT INTO tel2017_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","దేవుడు మళ్ళీ అబ్రాహాముతో ఇలా చెప్పాడు. “నీ వరకూ నువ్వు నా నిబంధన పాటించాలి. నువ్వు మాత్రమే గాక, నీ తరువాత నీ సంతానం తమ తరతరాల్లో నా నిబంధన పాటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","నాకూ నీకూ మధ్యన, నీ తరువాత నీ సంతానానికీ మధ్య ఉన్న నిబంధన ఇదే. మీలో ప్రతి మగవాడూ సున్నతి పాటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","అంటే మీరు మీ మర్మాంగం పైచర్మపు కొన కత్తిరించాలి. అది నాకూ నీకూ మధ్య ఉన్న నిబంధనకు సూచనగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","నీ ప్రజల తరాలన్నిటిలో ప్రతి మగవాడికీ ఎనిమిది రోజున సున్నతి జరగాలి. ఇది నీ ఇంట్లో పుట్టిన వాడికీ, నీ సంతానం కాకుండా మీరు వెల ఇచ్చి ఏ విదేశీయుడి దగ్గరైనా కొనుక్కున్న వాడికీ వర్తిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","నీ ఇంట్లో పుట్టిన వారికీ, మీరు వెల పెట్టి కొనుక్కున్న వారికీ తప్పకుండా సున్నతి జరగాలి. ఆ విధంగా నా నిబంధన మీ శరీరంలో శాశ్వత నిబంధన గా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","సున్నతి పొందని మగవాడు, అంటే ఎవరి మర్మాంగం పై చర్మం సున్నతి కాలేదో అలాంటివాడిని అతని జాతిలోనుండి బహిష్కరించాలి. అతడు నా నిబంధనను భంగం చేశాడు.” ");
INSERT INTO tel2017_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","దేవుడు అబ్రాహాముతో ఇంకా ఇలా అన్నాడు. “నీ భార్య అయిన శారయిని ఇకనుండి శారయి అని పిలువవద్దు. ఇకనుండి ఆమె పేరు శారా ");
INSERT INTO tel2017_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","నేను ఆమెను ఆశీర్వదించి, ఆమె ద్వారా నీకు కొడుకుని ఇస్తాను. ఆమె అనేక జాతులకు తల్లి అవుతుంది. ఆమె నుండి అనేక జాతుల రాజులు వస్తారు.” ");
INSERT INTO tel2017_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","అప్పుడు అబ్రాహాము తన ముఖాన్ని నేలకు వంచి తన హృదయంలో నవ్వుకుని “ఒక మనిషికి నూరేళ్ళ వయస్సులో పిల్లలు పుడతారా? తొంభై ఏళ్ల శారా పిల్ల వాణ్ని కంటుందా?” అని మనస్సులో అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","అబ్రాహాము “నీవు ఇష్మాయేలును చల్లగా చూస్తే నాకదే పదివేలు” అని దేవునితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","అప్పుడు దేవుడు ఇలా అన్నాడు. “అలా కాదు. నీ భార్య అయిన శారా కచ్చితంగా నీకు కొడుకుని కంటుంది. అతనికి నువ్వు ఇస్సాకు అనే పేరు పెడతావు. అతనితో నా నిబంధనను స్థిరం చేస్తాను. అతని తరువాత అతని వారసులందరికీ అది శాశ్వతమైన నిబంధనగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ఇష్మాయేలును గూర్చి నువ్వు చేసిన ప్రార్థన నేను విన్నాను. చూడు, నేను అతణ్ణి ఆశీర్వదిస్తాను. అతని సంతానాన్ని అత్యధికం చేస్తాను. అతడు అత్యధికంగా విస్తరిచేలా చేస్తాను. అతడు పన్నెండు జాతుల రాజులకు మూలపురుషుడు అవుతాడు. అతణ్ణి ఒక గొప్ప జాతిగా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","కాని వచ్చే సంవత్సరం ఈ సమయానికి శారా ద్వారా నీకు పుట్టబోయే ఇస్సాకుతో నా నిబంధననను స్థిరపరుస్తాను.” ");
INSERT INTO tel2017_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","అబ్రాహాముతో మాట్లాడటం ముగిసిన తరువాత దేవుడు అతని దగ్గరనుండి పైకి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","అప్పుడు అబ్రాహాము అదే రోజు తన కుమారుడు ఇష్మాయేలునూ, తన ఇంట్లో పుట్టిన వారినందర్నీ, అలాగే తాను వెల ఇచ్చి కొన్న వారందరినీ తన ఇంట్లోని ప్రతి మగవాణ్ణీ తీసుకుని వారందరికీ వారి మర్మాంగం పైచర్మాన్ని సున్నతి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","అబ్రాహాము మర్మాంగం పైచర్మానికి సున్నతి జరిగినప్పుడు అతని వయస్సు తొంభై తొమ్మిది ఏళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","అతని కుమారుడు ఇష్మాయేలుకు సున్నతి జరిగినప్పుడు అతనికి పదమూడేళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","అబ్రాహామూ అతని కుమారుడు ఇష్మాయేలూ ఒక్కరోజే సున్నతి పొందారు. ");
INSERT INTO tel2017_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","అతని ఇంట్లో పుట్టినవారూ, విదేశీయుల దగ్గర వెల ఇచ్చి కొన్నవారూ, ఇంకా అతని ఇంట్లో మగవాళ్ళంతా సున్నతి పొందారు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","మమ్రే అనే ప్రాంతంలో సింధూర చెట్ల దగ్గర ఒక మధ్యాహ్నం వేళ అబ్రాహాము తన గుడారం వాకిట్లో కూర్చుని ఉన్నాడు. అప్పుడు యెహోవా అతనికి ప్రత్యక్షమయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","అతడు తలెత్తి చూసినప్పుడు ముగ్గురు మనుషులు అతని ముందు నిలబడి ఉన్నారు. అతడు వారిని చూసి తన గుడారం వదిలి వారిని కలుసుకోవడానికి పరుగెత్తుకుంటూ వెళ్ళాడు. వారి ఎదుట నేల వరకూ వంగి ఇలా అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“ప్రభూ, నీ దాసుడనైన నాపై దయ చూపి నన్ను దాటి వెళ్ళకండి. నాతో రండి. ");
INSERT INTO tel2017_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","నేను నీళ్ళు తెప్పిస్తాను. వాటితో మీ కాళ్ళు కడుక్కోండి. చెట్టు కింద విశ్రాంతి తీసుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","మీ దాసుడినైన నా దగ్గరికి వచ్చారు కదా, కొంచెం ఆహారం తీసుకు వస్తాను. దాన్ని తిని సేద దీర్చుకోండి. ఆ తరువాత మీ దారిన మీరు వెళ్ళవచ్చు.” అందుకు వారు “నువ్వు చెప్పినట్టే చెయ్యి” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","అప్పుడు అబ్రాహాము వెంటనే గుడారంలో ఉన్న శారా దగ్గరికి వెళ్ళి “నువ్వు త్వరగా 21 కిలోల మెత్తటి పిండి తెచ్చి కలిపి రొట్టెలు చెయ్యి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","తరువాత అబ్రాహాము పశువుల మంద దగ్గరికి పరుగెత్తి ఒక మంచి లేగ దూడను పట్టుకు వచ్చి ఒక పనివాడికి ఇచ్చాడు. వాడు త్వరత్వరగా దాన్నివధించి వండి సిద్ధం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","తరువాత అతడు పెరుగూ, పాలూ వాటితోపాటు తాను వండించి సిద్ధం చేయించిన దూడ మాంసాన్ని తెచ్చి వాళ్ళ ముందు పెట్టాడు. వాళ్ళు భోజనం చేస్తుంటే అక్కడే ఆ చెట్టు కిందే నిలబడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","వారు అతణ్ణి “నీ భార్య ఎక్కడ?” అని అడిగారు. అతడు “అదిగో, గుడారంలో ఉంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","అప్పుడు ఆయన “తిరిగి వసంతకాలంలో నేను మళ్ళీ నీ దగ్గరికి తప్పకుండా వస్తాను. విను, అప్పటికి నీ భార్య శారాకు ఒక కొడుకు ఉంటాడు” అన్నాడు. శారా ఆయన వెనుక ఉన్న గుడారం ద్వారం దగ్గర ఉండి ఈ మాటలు వింటూ ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","అప్పటికి అబ్రాహాము శారాలు వయసు ఉడిగిపోయి ముసలివాళ్ళయ్యారు. శారాకు పిల్లలను కనే వయసు దాటిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","శారా “నా బలమంతా పోయింది. ఈ సుఖం నాకెలా కలుగుతుంది? నా యజమాని అయిన నా భర్త కూడా ముసలివాడయ్యాడు కదా” అనుకుని తనలో తాను నవ్వుకుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","అప్పుడు యెహోవా అబ్రాహాముతో “శారా ‘ముసలిదాన్ని అయిన నేను నిజంగా బిడ్డను కనగలనా’ అనుకుని ఎందుకు నవ్వింది? ");
INSERT INTO tel2017_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","యెహోవాకు సాధ్యం కానిది ఏమైనా ఉందా? నేను నిర్ణయించిన కాలంలో మళ్ళీ నీ దగ్గరికి వస్తాను. వచ్చే సంవత్సరం ఇదే సమయానికి శారాకు ఒక కొడుకు ఉంటాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","అప్పుడు శారా భయపడి “నేను నవ్వలేదండీ” అంది. దానికి ఆయన “అలా అనకు, నువ్వు నవ్వావు” అని జవాబిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","అప్పుడు ఆ మనుషులు అక్కడనుండి వెళ్ళడానికి లేచారు. లేచి సొదొమ పట్టణం వైపు చూసారు. వారిని సాగనంపడానికి అబ్రాహాము వారితో కలిసి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","కానీ యెహోవా ఇలా అనుకున్నాడు. “అబ్రాహాము కచ్చితంగా ఒక బలమైన గొప్ప జాతి అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","అతని మూలంగా భూమిపై అన్ని జాతులూ ఆశీర్వాదం పొందుతాయి. నేను చేయబోతున్న పనులను అబ్రాహాముకు తెలియకుండా ఎలా దాచగలను? ");
INSERT INTO tel2017_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","అతని తరువాత అతని వారసులు నీతి న్యాయాలను జరిగించేలా వారికి యెహోవా మార్గాన్ని బోధించడానికీ తద్వారా అబ్రాహాముకు ఆయన చెప్పిన విషయాలన్నీ జరిగించడానికీ నేను అబ్రాహామును ఎన్నుకున్నాను.” ");
INSERT INTO tel2017_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","అప్పుడు యెహోవా ఇలా అన్నాడు. “సొదొమ గొమొర్రాలను గూర్చిన విన్నపాలు కుప్పలు తెప్పలుగా ఉన్నాయి. అలాగే వాటి పాపం కూడా చాలా ఘోరం. కనుక ");
INSERT INTO tel2017_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","నేను దిగి వెళ్ళి నాకు చేరిన ఆ విన్నపం ప్రకారం వాళ్ళు అంత దుర్మార్గులా కాదా అన్నది చూస్తాను. లేకపోతే నాకు తెలుస్తుంది.” ");
INSERT INTO tel2017_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ఆ మనుషులు అక్కడనుండి వెళ్ళడానికి తిరిగి సొదొమ వైపుగా వెళ్ళారు. కానీ అబ్రాహాము ఇంకా యెహోవా సముఖంలోనే నిలబడి ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","అప్పడు అబ్రాహాము వారిని సమీపించి ఇలా అడిగాడు. “దుర్మార్గులతో పాటు నీతిమంతులను కూడా నాశనం చేస్తావా? ");
INSERT INTO tel2017_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ఆ పట్టణంలో ఒకవేళ యాభైమంది నీతిమంతులు ఉంటే ఆ యాభైమంది నీతిమంతుల కోసం పట్టణాన్ని నాశనం చేయకుండా రక్షించలేవా? ");
INSERT INTO tel2017_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","నీతిమంతులకూ దుర్మార్గులకూ ఒకే రకంగా తీర్పు తీర్చడం నీకు దూరమౌతుంది గాక. అలాగే దుర్మార్గులతో పాటుగా నీతిమంతులను నాశనం చేయడం నీకు దూరమౌతుంది గాక! సర్వలోకానికీ తీర్పు తీర్చేవాడు న్యాయం చెయ్యడా?” ");
INSERT INTO tel2017_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","దానికి యెహోవా “సొదొమ పట్టణంలో యాభైమంది నీతిమంతులు నాకు కనిపిస్తే వాళ్ళ కోసం ఆ ప్రదేశాన్నంతా కాపాడతాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","అందుకు అబ్రాహాము “అయ్యా చూడు, నేను దుమ్ముతో, బూడిదతో సమానం. అయినా నేను ప్రభువుతో మాట్లాడే సాహసం చేస్తున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","యాభై మంది నీతిమంతుల్లో ఒకవేళ ఐదుగురు తక్కువయ్యారనుకోండి. ఐదుగురు తక్కువయ్యారని ఆ పట్టణమంతటినీ నాశనం చేస్తావా?” అని మళ్ళీ అడిగాడు. అందుకాయన “అక్కడ నలభై ఐదుగురు కనిపిస్తే నాశనం చేయను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","అతడు మళ్ళీ ఆయనతో మాట్లాడుతూ “ఒకవేళ అక్కడ నలభై మందే కనిపిస్తారేమో” అన్నాడు. దానికి ఆయన “ఆ నలభై మంది కోసం నాశనం చేయను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","అతడు మళ్ళీ “ప్రభూ, నాపై కోప్పడనంటే నేను మాట్లాడతాను. ఒకవేళ ముప్ఫై మందే అక్కడ కనిపిస్తారేమో” అన్నాడు. అప్పుడాయన “ముప్ఫై మంది కనిపించినా నేను పట్టణాన్ని నాశనం చేయను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","అందుకు అతడు “నా ప్రభువుతో మాట్లాడే సాహసం చేస్తున్నాను. ఒకవేళ ఇరవైమందే ఉంటారేమో” అన్నాడు. అప్పుడు ప్రభువు “ఆ ఇరవైమంది కోసం నాశనం చేయను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","చివరిగా అతడు “ప్రభూ, నాపై కోపగించకు. నేనింకా ఒక్కసారే మాట్లాడతాను. ఒకవేళ పదిమందే అక్కడ ఉన్నారేమో” అన్నాడు. అప్పుడు ప్రభువు “పదిమంది కోసం నేను ఆ పట్టణాన్ని నాశనం చేయను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","అబ్రాహాముతో మాటలు ముగిసిన వెంటనే యెహోవా వెళ్ళిపోయాడు. అబ్రాహాము తన ఇంటికి తిరిగి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ఆ సాయంత్రం ఆ ఇద్దరు దేవదూతలు సొదొమ చేరుకున్నారు. ఆ సమయంలో లోతు సొదొమ పట్టణ ప్రధాన ద్వారం దగ్గర కూర్చుని ఉన్నాడు. లోతు దేవదూతలను చూడగానే వారిని కలుసుకోవడానికి వారికి ఎదురు వెళ్ళి సాష్టాంగపడి నమస్కారం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","వారితో ఇలా అన్నాడు “నా ప్రభువులారా, దయచేసి మీ దాసుడైన నా ఇంటికి రండి. వచ్చి కాళ్ళు కడుక్కోవాలనీ, ఈ రాత్రి గడపాలనీ వేడుకుంటున్నాను. తిరిగి తెల్లవారే లేచి మీ ప్రయాణం కొనసాగించవచ్చు.” అన్నాడు. అందుకు వాళ్ళు “అలా కాదు. మేము వీధిలోనే ఈ రాత్రి గడుపుతాం.” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","కానీ అతడు వాళ్ళను చాలా బలవంతపెట్టాడు. వారు అతనితో కలసి అతని ఇంటికి వెళ్ళారు. అతడు వారికి విందు చేశాడు. అతడు వారి కోసం పొంగని రొట్టెలు కాల్చి ఇచ్చాడు. వారు భోజనం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","అయితే వాళ్ళు నిద్రపోయే ముందే ఆ పట్టణ మనుషులు అంటే సోదొమలోని యువకులూ, వృద్ధులూ పట్టణం నలుమూలల నుండీ వచ్చిన మనుషులు ఆ ఇంటిని చుట్టుముట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","వాళ్ళు లోతును పిలిచారు. “ఈ రాత్రి నీ దగ్గరికి వచ్చిన మనుషులు ఏరీ? మేము వారితో లైంగిక సంబంధం పెట్టుకోవాలి. వాళ్ళను బయటకు తీసుకు రా” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","దాంతో లోతు బయటి ద్వారం దగ్గర ఉన్నవాళ్ళ దగ్గరికి వెళ్ళాడు. తన వెనకే తలుపు మూసివేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“సోదరులారా, ఇంత దుర్మార్గమైన పని చేయవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","చూడండి. పురుష సంబంధం లేని ఇద్దరు కూతుళ్ళు నాకు ఉన్నారు. మీరు ఒప్పుకుంటే వారిని మీ దగ్గరికి తీసుకుని వస్తాను. వారిని మీ ఇష్టం వచ్చినట్టు చేసుకోండి. కానీ ఈ వ్యక్తులను మాత్రం ఏమీ చేయవద్దు. వాళ్ళు నా ఇంటికి వచ్చిన అతిధులు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","కానీ వాళ్ళు “నువ్వు అవతలికి పో” అన్నారు. ఇంకా వాళ్ళు “వీడు మన మధ్యలో పరదేశిగా నివసించాడు. ఇప్పుడు మనకు తీర్పరి అయ్యాడు చూడండి! ఇప్పుడు వాళ్ళపైన కంటే నీపై ఎక్కువ దౌర్జన్యం చేస్తాం” అన్నారు. అలా అని వాళ్ళంతా లోతుపై దొమ్మీగా పడి తలుపు పగలగొట్టడానికి పూనుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","అయితే ఆ దూతలు తమ చేతులు చాపి లోతును ఇంటి లోపలికి లాగేశారు. ఆ వెనుకే తలుపు మూసేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","అప్పుడు లోతు అతిథులు పిల్లల నుండి పెద్దల వరకూ ఆ తలుపు దగ్గర ఉన్న వాళ్ళందరికీ గుడ్డితనం కలుగజేశారు. దాంతో వాళ్ళు తలుపు ఎక్కడ ఉందో వెదికీ వెదికీ విసిగిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","అప్పుడు ఆ దూతలు లోతుతో “ఇక్కడ నీ వారు ఇంకా ఎవరన్నా ఉన్నారా? నీ అల్లుళ్ళూ, కొడుకులూ, కూతుళ్ళూ ఈ ఊరిలో నీకు కలిగినవారందర్నీ బయటకు తీసుకురా. ");
INSERT INTO tel2017_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","మేము ఈ ప్రాంతాన్నంతా ధ్వంసం చేయడానికి వచ్చాం. ఈ ప్రజలకు వ్యతిరేకంగా గొప్ప మొర యెహోవా సముఖానికి చేరింది. అందుకని వాళ్ళను నాశనం చేయడానికి యెహోవా మమ్మల్ని పంపించాడు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","అప్పుడు లోతు బయటకు వెళ్ళి తన కూతుళ్ళను పెళ్లి చేసుకోబోతున్న తన అల్లుళ్ళతో మాట్లాడాడు. “త్వరగా రండి. ఇక్కడినుండి బయట పడాలి. యెహోవా ఈ పట్టణాన్ని నాశనం చేయబోతున్నాడు” అని చెప్పాడు. అయితే అతడు తన అల్లుళ్ళ దృష్టికి హాస్యమాడుతున్నవాడిలా కనిపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ఉదయం అయినప్పుడు ఆ దూతలు లోతును త్వరపెట్టారు. “రా, రా, బయల్దేరు. ఈ ఊరికి కలుగబోయే శిక్షలో తుడిచి పెట్టుకుపోకుండా నీ భార్యనూ ఇక్కడే ఉన్న నీ ఇద్దరు కూతుళ్లనూ తీసుకుని బయల్దేరు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","అయితే అతడు ఆలస్యం చేసాడు. యెహోవా అతని పట్ల కనికరం చూపడం వల్ల ఆ మనుషులు అతని చేతినీ, అతని భార్య చేతినీ అతని ఇద్దరు కూతుళ్ళ చేతులనూ పట్టుకున్నారు. వాళ్ళని బయటకు తీసుకువచ్చారు. అలానే పట్టణం బయటకు తీసుకువచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ఆ దూతలు వారిని పట్టణం బయటకు తీసుకు వచ్చిన తరువాత వాళ్ళలో ఒకడు “మీ ప్రాణాలు దక్కించుకోవడం కోసం పారిపొండి. వెనక్కు తిరిగి చూడవద్దు. మైదాన ప్రాంతాల్లో ఎక్కడా ఆగవద్దు. మీరు తుడిచి పెట్టుకుపోకుండేలా పర్వతాల్లోకి పారిపోయి తప్పించుకోండి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","అప్పుడు లోతు “ప్రభువులారా, అలా కాదు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","మీ సేవకుడినైన నన్ను దయ చూశారు. నా ప్రాణాన్ని రక్షించి నా పట్ల మీ మహా కనికరాన్ని ప్రదర్శించారు. కానీ నేను ఆ పర్వతాలకు పారిపోయి తప్పించుకోలేను. ఆ పర్వతాలను చేరుకునే లోపుగానే ఏదైనా కీడు నాపైకి వస్తుందేమో. అలా జరిగి నేను ఇక్కడే చనిపోతానేమో. ");
INSERT INTO tel2017_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","చూడండి, నేను పారిపోవడానికి ఆ కనిపించే ఊరు దగ్గర్లో ఉంది. నన్ను అక్కడికి వెళ్ళనివ్వండి. అది చిన్నది గదా, నేను బతుకుతాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","అప్పుడు ఆయన “అలాగే, ఈ మనవి కూడా అంగీకరిస్తున్నాను. నువ్వు చెప్పిన ఈ ఊరిని నేను నాశనం చేయను. ");
INSERT INTO tel2017_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","నువ్వు త్వరపడి, అక్కడికి వెళ్లి తప్పించుకో. నువ్వు అక్కడకు చేరుకునే వరకూ నేను ఏమీ చేయలేను” అన్నాడు. కాబట్టి ఆ ఊరికి సోయరు అనే పేరు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","లోతు సోయరు చేరేటప్పటికి ఆ దేశంపై సూర్యుడు ఉదయించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","అప్పుడు సొదొమ గొమొర్రాల పైన ఆకాశం నుండి యెహోవా గంధకాన్నీ అగ్నినీ కురిపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ఆయన ఆ పట్టణాలనూ, ఆ మైదానమంతటినీ, ఆ పట్టణాల్లో నివసించేవారందరినీ, నేలపై మొక్కలనూ నాశనం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","కానీ లోతు వెనుకే వస్తున్న అతని భార్య వెనక్కి తిరిగి చూసింది. వెంటనే ఆమె ఉప్పు స్తంభంగా మారిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ఉదయమైంది. అబ్రాహాము లేచి తాను అంతకుముందు యెహోవా సముఖంలో నిలబడిన చోటుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","అక్కడి నుండి సొదొమ, గొమొర్రాల వైపు, ఆ మైదాన ప్రాంతం మొత్తాన్నీ చూశాడు. కొలిమిలోనుండి లేచే పొగ లాగా ఆ ప్రాంతం అంతా పొగలు వస్తూ కనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ఆ విధంగా దేవుడు ఆ మైదానపు పట్టణాలను నాశనం చేసినప్పుడు దేవుడు అబ్రాహామును జ్ఞాపకం చేసుకున్నాడు. లోతు కాపురమున్న పట్టణాలను ధ్వంసం చేసినప్పుడు ఆ విధ్వంసంలో లోతు నాశనం కాకుండా తప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","అయితే లోతు సోయరులో ఉండటానికి భయపడ్డాడు. తన ఇద్దరు కూతుళ్ళనూ తీసుకుని పర్వత ప్రాంతానికి వెళ్లిపోయాడు. అక్కడ తన ఇద్దరు కూతుళ్ళతో కలసి ఒక గుహలో నివసించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ఇలా ఉండగా అతని పెద్ద కూతురు తన చెల్లితో “నాన్న ముసలివాడయ్యాడు. ఈ లోకరీతిగా మనతో శారీరిక సంబంధం పెట్టుకోడానికి ఏ పురుషుడూ లేడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","నాన్నకు ద్రాక్షారసం తాగిద్దాం. తరువాత అతనితో శారీరిక సంబంధం పెట్టుకుందాం. ఆ విధంగా నాన్న ద్వారా మనకు సంతానం కలిగేలా చేసుకుందాం, పద” అని చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ఆ రాత్రి వాళ్ళు తమ తండ్రికి ద్రాక్షారసం తాగించారు. ఆ తరువాత అతని పెద్ద కూతురు లోపలికి వెళ్ళి తన తండ్రితో శారీరక సంబంధం పెట్టుకుంది. కాని ఆమె ఎప్పుడు తన పక్కన పడుకుందో, ఎప్పుడు లేచి వెళ్లిందో అతనికి తెలియలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","మరునాడు అక్క తన చెల్లిని చూసి ఇలా అంది. “నిన్న రాత్రి నేను నాన్నతో పడుకున్నాను. ఈ రాత్రి కూడా అతనికి ద్రాక్షారసం తాగిద్దాం. ఆ తరువాత నువ్వు లోపలి వెళ్లి అతనితో కలిసి పండుకో. అలా మనం నాన్న ద్వారా సంతానం పొందుదాం” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ఆ రాత్రి కూడా వాళ్ళు తమ తండ్రికి ద్రాక్షారసం తాగించారు. అప్పుడు అతని చిన్న కూతురు వెళ్ళి తన తండ్రితో పడుకుంది. ఆమె ఎప్పుడు తన పక్కన పడుకుందో, ఎప్పుడు లేచి వెళ్ళిందో అతనికి తెలియలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ఆ విధంగా లోతు ఇద్దరు కూతుళ్ళూ తమ తండ్రి మూలంగా గర్భం ధరించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","అతని పెద్ద కూతురు ఒక కొడుక్కి జన్మనిచ్చింది. వాడికి మోయాబు అనే పేరు పెట్టింది. అతడే నేటి మోయాబీయులకు మూల పురుషుడు. ");
INSERT INTO tel2017_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","లోతు రెండో కూతురు కూడా ఒక కొడుకుని కని వాడికి “బెన్ అమ్మి” అనే పేరు పెట్టింది. నేటి అమ్మోనీయులకు అతడే మూలపురుషుడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","అబ్రాహాము అక్కడ నుండి బయలుదేరి దక్షిణదేశానికి తరలి వెళ్ళాడు. అలా కాదేషుకూ, షూరుకూ మధ్య ఉన్న ప్రాంతంలో నివసించాడు. కొంతకాలం గెరారులో పరదేశిగా ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","అక్కడ అబ్రాహాము తన భార్య శారాను గూర్చి “ఈమె నా చెల్లి” అని చెప్పాడు. కాబట్టి గెరారు రాజైన అబీమెలెకు శారా కోసం తన మనుషులను పంపించాడు. వాళ్ళు శారాను అబీమెలెకు ఇంట్లో చేర్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","కాని దేవుడు రాత్రి కలలో అబీమెలెకు దగ్గరికికు కనబడి అతనితో “చూడు, నువ్వు చచ్చినట్టే! ఎందుకంటే నువ్వు నీ ఇంట్లో పెట్టుకున్న స్తీ ఒక వ్యక్తికి భార్య” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","అయితే అబీమెలెకు ఆమె దగ్గరికి వెళ్ళలేదు. కాబట్టి అతడు “ప్రభూ, ఇలాంటి నీతిగల జాతిని చంపివేస్తావా? ");
INSERT INTO tel2017_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‘ఈమె నా చెల్లి’ అని నాతో అతడే చెప్పాడు కదా! ఆమె కూడా ‘అతడు నా అన్న’ అన్నది కదా. నేను నా చేతులతో ఏ దోషమూ చేయలేదు. నిజాయితీగానే ఈ పని చేశాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","అందుకు దేవుడు అతనికి కలలో కనబడి “అవును, నువ్వు యథార్థ హృదయంతోనే దీన్ని చేశావని నాకు తెలుసు. నువ్వు నాకు విరోధంగా పాపం చేయకుండా నిన్ను అడ్డుకున్నాను. అందుకే నేను నిన్ను ఆమెను తాకడానికి అనుమతించ లేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","కాబట్టి ఆ వ్యక్తి భార్యను తిరిగి అతనికప్పగించు. ఎందుకంటే అతడు ప్రవక్త. నువ్వు బతికేలా అతడు నీ కోసం ప్రార్థిస్తాడు. ఒకవేళ నువ్వు ఆమెను తిరిగి అతనికి అప్పగించకపోతే నువ్వూ, నీకు చెందినవారూ తప్పక చనిపోతారు. ఈ సంగతి నువ్వు బాగా తెలుసుకో” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","తెల్లవారకముందే అబీమెలెకు లేచి తన సేవకులందరినీ పిలిపించాడు. వారికి ఈ విషయాలన్నీ తెలియజేశాడు. వారంతా అది విని ఎంతో భయపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","అబీమెలెకు అబ్రాహాముకు కబురు పెట్టి రప్పించాడు. అతనితో ఇలా అన్నాడు “నువ్వు మాకు చేసినదేమిటి? నాపైనా నా రాజ్యం పైనా ఇంత పెద్ద దోషం వచ్చేలా చేశావు. నేను నీకు చేసిన అపకారం ఏమిటి? నా పట్ల చేయకూడని పని చేశావు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","అబీమెలెకు అబ్రాహామును చూసి “నువ్వు ఇలా చేయడానికి గల కారణాలేమిటి?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","అబ్రాహాము “ఇక్కడ దేవుని భయం బొత్తిగా లేదు కాబట్టి నా భార్య కోసం నన్ను చంపుతారేమో అన్న భయంతోనే నేనిలా చేసాను ");
INSERT INTO tel2017_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","అదీకాకుండా ఆమె నాకు చెల్లి అనే మాట కూడా నిజమే. ఆమె నా తండ్రి కూతురు. తల్లి కూతురు కాదు. అలా నాకు భార్య అయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","దేవుడు నేను నా తండ్రి ఇంటిని వదిలి వివిధ ప్రదేశాలు ప్రయాణాలు చేసేలా పిలిచినప్పుడు నేను ఆమెతో ‘మనం వెళ్ళే ప్రతి స్థలం లోనూ నన్ను గూర్చి అతడు నా అన్న అని చెప్పు. నా కోసం నువ్వు చేయగలిగిన ఉపకారం ఇదే’ అని చెప్పాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","అబీమెలెకు గొర్రెలనూ ఎద్దులనూ దాసులనూ దాసీలనూ రప్పించి అబ్రాహాముకు ఇచ్చాడు. తరువాత అతని భార్య అయిన శారాను అతనికి అప్పగించేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","తరువాత అబీమెలెకు “చూడు, నా దేశం అంతా నీ ఎదుట ఉంది. నీకు ఎక్కడ ఇష్టమైతే అక్కడ స్థిర నివాసం ఏర్పరుచుకో” అని అబ్రాహాముతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","తరువాత అతడు శారాతో “చూడు, నీ అన్నకు నేను వెయ్యి వెండి నాణాలు ఇచ్చాను. నీవు నిర్దోషివని నీతో ఉన్నవారందరి ఎదుట ఈడబ్బు రుజువుగా ఉంటుంది. అందరి ఎదుటా నీకు న్యాయం జరిగింది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","అప్పుడు అబ్రాహాము దేవుణ్ణి ప్రార్థించాడు. దేవుడు అబీమెలెకునూ, అతని భార్యనూ అతని దాసీలనూ స్వస్థపరిచాడు. వారు పిల్లలను కనగలిగారు. ");
INSERT INTO tel2017_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ఎందుకంటే దేవుడైన యెహోవా అబ్రాహాము భార్య అయిన శారాను బట్టి అబీమెలెకు ఇంట్లో స్త్రీలందరినీ పూర్తిగా గొడ్రాళ్ళనుగా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","యెహోవా తాను చెప్పినట్టే శారా పై కనికరం చూపించాడు. తాను చేసిన వాగ్దానాన్ని శారా పట్ల దేవుడైన యెహోవా నెరవేర్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","అబ్రాహాము వృద్ధాప్యంలో శారా గర్భం ధరించి అతనికి ఒక కొడుకును కన్నది. అబ్రాహాముతో దేవుడైన యెహోవా చెప్పిన సమయంలోనే ఇది జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","అబ్రాహాము తన భార్య శారా ద్వారా తనకు పుట్టిన తన కొడుక్కి ఇస్సాకు అనే పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","దేవుడు అబ్రాహాముకు ఇచ్చిన ఆదేశాల ప్రకారం తన కొడుకు ఇస్సాకుకు ఎనిమిదవ రోజున సున్నతి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ఇస్సాకు పుట్టినప్పుడు అబ్రాహాము వయస్సు నూరేళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","అప్పుడు శారా “దేవుడు నాకు నవ్వు పుట్టించాడు. నా సంగతి తెలిసినవారంతా నాతో కలసి సంతోషిస్తారు” అన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ఆమె ఇంకా “శారా తన పిల్లలకు పాలు ఇస్తుందని అబ్రాహాముతో ఎవరు చెప్పగలిగే వారు? అయినా ముసలివాడయ్యాక నేను అతనికి ఒక కొడుకుని కని ఇచ్చాను గదా” అన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ఆ పిల్లవాడు పెరిగి పాలు విడిచిపెట్టాడు. ఇస్సాకు పాలు మానిన రోజున అబ్రాహాము గొప్ప విందు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","అప్పుడు అబ్రాహాముకు ఐగుప్తు జాతిదైన హాగరు ద్వారా పుట్టిన కొడుకు ఇస్సాకును ఎగతాళి చేయడం శారా చూసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ఆమె అబ్రాహాముతో ఇలా అంది. “ఈ దాసీనీ ఈమె కొడుకునీ వెళ్ళగొట్టు. ఎందుకంటే ఈ దాసీ కొడుకు నా కొడుకు ఇస్సాకుతో కలసి వారసుడిగా ఉండటానికి వీలులేదు.” ");
INSERT INTO tel2017_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ఈ మాట విన్న అబ్రాహాము తన కొడుకు ఇష్మాయేలుని బట్టి చాలా వేదన చెందాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","అయితే దేవుడు “ఈ అబ్బాయి కోసం, నీ దాసీ కోసం నువ్వు బాధ పడవద్దు. ఈ విషయంలో శారా నీకు చెప్పినట్టు చెయ్యి. ఎందుకంటే ఇస్సాకు వలన కలిగే సంతానమే నీకు వారసులౌతారు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","అయినప్పటికీ ఈ దాసీ కొడుకు కూడా నీ సంతానం గనక నేను అతణ్ణి కూడా ఒక జాతిగా చేస్తాను” అని అబ్రాహాముతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","కనుక అబ్రాహాము తెల్లవారకముందే లేచి రొట్టె, నీళ్ళు పోసిన తోలు తిత్తి సిద్ధం చేసి వాటిని హాగరు భుజంపై పెట్టాడు. ఆ బాలుణ్ణి ఆమెకు అప్పగించి పంపివేశాడు. ఆమె వెళ్ళి బెయేర్షెబా అడవికి చేరి అక్కడ తిరుగుతూ ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ఆ తోలు తిత్తిలోని నీళ్ళు అయిపోయాక ఆమె బాలుణ్ణి ఒక పొద కింద విడిచిపెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","“ఈ పిల్లవాడి చావు చూడటం నా వల్ల కాదు” అనుకుని కొంత దూరం వెళ్లి వాడికి ఎదురుగా కూర్చుంది. అక్కడ ఎలుగెత్తి బిగ్గరగా ఏడ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","దేవుడు ఆ బాలుడి మొర విన్నాడు. అప్పుడు దేవుని దూత ఆకాశం నుండి హాగరును పిలిచాడు. “హాగరూ, నీకు వచ్చిన కష్టం ఏమిటి? భయపడవద్దు. ఆ బాలుడు ఉన్నచోటనే దేవుడు అతని మొర విన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","నువ్వు లేచి ఆ బాలుణ్ణి పైకి లేపు. అతనికి ధైర్యం చెప్పు. ఎందుకంటే నేను అతణ్ణి ఒక గొప్ప జాతిగా వృద్ది చేయబోతున్నాను” అని ఆమెకు చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","అప్పుడు దేవుడు ఆమె కళ్ళు తెరుచుకోనేలా చేశాడు. ఆమె ఎదురుగా ఉన్న ఒక నీళ్ళ ఊటను చూసింది. ఆమె వెళ్ళి తోలు తిత్తిని నీళ్ళతో నింపి ఆ బాలుడికి తాగించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","దేవుడు ఆ అబ్బాయికి తోడుగా ఉన్నాడు. అతడు పెరిగి పెద్దవాడయ్యాడు. ఆ అడవిలోనే నివసించి విలువిద్యలో ప్రవీణుడయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","అతడు పారాను అటవీ ప్రాంతంలో ఉన్నప్పుడు అతని తల్లి ఐగుప్తు దేశం నుండి ఒక అమ్మాయిని తెచ్చి అతనికి పెళ్ళి చేసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ఆ రోజుల్లో అబీమెలెకూ, అతని సైన్యాధిపతి ఫీకోలూ కలసి వచ్చి అబ్రాహాముతో మాట్లాడారు. “నువ్వు చేసే పనులన్నిటిలో దేవుడు నీకు తోడుగా ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","నువ్వు నన్ను, నా కొడుకుని, నా మనుమళ్ళను మోసం చేయనని దేవుని పేరిట నాకు వాగ్దానం చెయ్యి. నేను నీకు చూపిన అదే నిబంధన విశ్వసనీయతను నా పట్లా, నువ్వు పరదేశిగా ఉన్న ఈ దేశం పట్లా చూపించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","అందుకు అబ్రాహాము “నేను వాగ్దానం చేస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","అబీమెలెకు దాసులు దౌర్జన్యంగా స్వాధీనం చేసుకున్న అబ్రాహాముకు చెందిన నీటి బావిని గూర్చి అబ్రాహాము తన అసంతృప్తిని వ్యక్తం చేశాడు. దానికి అబీమెలెకు “ఈ పని ఎవరు చేశారో నాకు తెలియదు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","నువ్వు కూడా దీని విషయం నాకేమీ చెప్పలేదు. నాకీ సంగతి ఈ రోజే తెలిసింది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","అబ్రాహాము గొర్రెలనూ ఎడ్లనూ తెప్పించి అబీమెలెకుకు ఇచ్చాడు. వాళ్ళిద్దరూ ఈ విధంగా ఒక నిబంధన చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","తరువాత అబ్రాహాము తన గొర్రెల మందలో నుంచి ఏడు ఆడ గొర్రెలను తీసి వేరుగా ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","అది చూసి అబీమెలెకు అబ్రాహాముతో “నువ్వు ఏడు ఆడ గొర్రెలను వేరుగా తీసి ఉంచావు. దాని అంతరార్ధం ఏమిటి?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","దానికి అబ్రాహాము “ఈ బావిని నేనే తవ్వించాననడానికి సాక్ష్యంగా ఈ ఏడు ఆడ గొర్రెలను నువ్వు తీసుకోవాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","అలా వాళ్ళిద్దరూ అక్కడ ఒక నిబంధన చేసుకున్నారు కాబట్టి ఆ స్థలానికి “బెయేర్షెబా” అనే పేరు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","బెయేర్షెబాలో వాళ్ళు అలా ఒక నిబంధన చేసుకున్న తరువాత అబీమెలెకు లేచి తన సైన్యాధిపతి ఫీకోలుతో కలసి ఫిలిష్తీయుల దేశానికి తిరిగి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","అబ్రాహాము బెయేర్షెబాలో ఒక తమరిస్క చెట్టు నాటాడు. అక్కడ శాశ్వత దేవుడైన యెహోవా పేరట ప్రార్థన చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","అబ్రాహాము ఫిలిష్తీయుల దేశంలో చాలా రోజులు పరదేశిగా ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ఈ సంగతులన్నీ జరిగిన తరువాత దేవుడు అబ్రాహామును పరీక్షించాడు. ఆయన “అబ్రాహామూ” అని పిలిచినప్పుడు అతడు “చిత్తం ప్రభూ” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","అప్పుడు ఆయన అబ్రాహాముతో “నువ్వు ప్రేమించే నీ ఒక్కగానొక్క కొడుకు ఇస్సాకును తీసుకుని మోరియా దేశానికి వెళ్ళు. అక్కడ నేను చెప్పబోయే ఒక పర్వతం మీద అతణ్ణి దహనబలిగా అర్పించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","కనుక అబ్రాహాము తెల్లవారగానే లేచి తన గాడిదకు జీను కట్టి సిద్ధం చేసి, దహనబలి కోసం కట్టెలు కొట్టి, తన కొడుకు ఇస్సాకుతో పాటు ఇద్దరు పనివాళ్ళనూ వెంటబెట్టుకుని దేవుడు తనకు చెప్పిన ప్రాంతానికి ప్రయాణమయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","మూడవ రోజు అబ్రాహాము తలెత్తి దూరంగా ఉన్న ఆ స్థలాన్ని చూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","తన పనివాళ్ళతో “మీరు గాడిదతో ఇక్కడే ఉండండి. నేనూ అబ్బాయీ అక్కడికి వెళ్లి దేవుణ్ణి ఆరాధించి తిరిగి మీ దగ్గరికి వస్తాం” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","అప్పుడు అబ్రాహాము దహనబలి కోసం తెచ్చిన కట్టెలు తీసుకుని తన కొడుకు ఇస్సాకు తలపై పెట్టాడు. తన చేతిలో నిప్పు, కత్తి పట్టుకున్నాడు. ఇక వాళ్ళిద్దరూ కలసి కొండపైకి ఎక్కుతున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ఇస్సాకు తన తండ్రి అబ్రాహామును “నాన్నా” అని పిలిచాడు. దానికి అబ్రాహాము “ఏం నాయనా” అన్నాడు. అప్పుడతడు “చూడండి, మన దగ్గర నిప్పూ కట్టెలూ ఉన్నాయి గానీ దహనబలికి గొర్రె పిల్ల ఏది?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","దానికి అబ్రాహాము “కొడుకా, దహనబలికి గొర్రెపిల్లను దేవుడే దయచేస్తాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","దేవుడు అబ్రాహాముకు చెప్పిన స్థలానికి వారు చేరుకున్నారు. అక్కడ అబ్రాహాము ఒక బలిపీఠం నిర్మించి దానిపై కట్టెలు పేర్చాడు. ఇస్సాకును తాళ్ళతో బంధించాడు. ఆ బలిపీఠంపై పేర్చిన కట్టెలపై అతణ్ణి పడుకోబెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","తరువాత అబ్రాహాము తన కుమారుణ్ణి వధించడానికి చెయ్యి చాపి కత్తి పట్టుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","అప్పుడు ఆకాశం నుండి యెహోవా దూత “అబ్రాహామూ, అబ్రాహామూ” అని పిలిచాడు. దానికతడు “చిత్తం ప్రభూ” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","అప్పుడు ఆయన “ఆ బాలునిపై చెయ్యి వేయకు. అతనికి ఏ హానీ తలపెట్టవద్దు. నీకున్న ఒక్కగానొక్క కొడుకుని నాకివ్వడానికి వెనుకంజ వేయలేదు. అది చూశాక నీకు దేవునిపట్ల భయభక్తులు ఉన్నాయని నాకు తెలిసింది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","అప్పుడు అబ్రాహాము తలెత్తి చూశాడు. ఆశ్చర్యం కలిగించేలా అక్కడ ఉన్న ఒక పొదలో కొమ్ములు చిక్కుకుని ఉన్న ఒక పొట్టేలు అతనికి కనిపించింది. అబ్రాహాము వెళ్ళి ఆ పోట్టేలుని పట్టుకుని తన కొడుక్కి బదులుగా దాన్ని దహనబలిగా అర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","అబ్రాహాము ఆ చోటును “యెహోవా యీరే” అని పిలిచాడు. కాబట్టి “యెహోవా తన పర్వతం పైన దయచేస్తాడు” అనే మాట ఈ నాటి వరకూ నిలిచి వాడుకలో ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","యెహోవా దూత రెండవసారి ఆకాశం నుండి అబ్రాహామును పిలిచి ఇలా అన్నాడు ");
INSERT INTO tel2017_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“నువ్వు నీ ఒక్కగానొక్క కొడుకుని ఇవ్వడానికి వెనుకంజ వేయకుండా ఇదంతా చేశావు. అందుకే ప్రమాణం చేస్తున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","నేను నిన్ను ఆశీర్వదిస్తాను. నీ వారసులను ఆకాశంలో ఉండే నక్షత్రాల వలే, సముద్ర తీరంలో ఉండే ఇసుక రేణువులవలే అత్యధికంగా విస్తరించేలా చేస్తాను. నీ వారసులు తమ శత్రువుల భూములను స్వాధీనం చేసుకుంటారు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","నువ్వు నా మాట విన్నావు కనుక నీ సంతానం వల్ల భూమి పైన ఉన్న జాతులన్నిటినీ ఆశీర్వదిస్తాను.” ");
INSERT INTO tel2017_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","తరువాత అబ్రాహాము తన పనివాళ్ళ దగ్గరికి వచ్చాడు. వాళ్ళంతా కలసి బెయేర్షెబాకు వెళ్ళారు. అబ్రాహాము బెయేర్షెబాలో నివసించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ఆ సంగతులన్నీ జరిగిన తరువాత తన సోదరుడైన నాహోరుకు మిల్కా ద్వారా పిల్లలు కలిగారు అనే వార్త అబ్రాహాముకు చేరింది. ");
INSERT INTO tel2017_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ఆ పిల్లలు ఎవరంటే, పెద్ద కొడుకు ఊజు, అతడి తమ్ముడు బూజు, అరాము తండ్రి కెమూయేలు, ");
INSERT INTO tel2017_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","కెసెదు, హజో, పిల్దాషు, జిద్లాపు, బెతూయేలు. ఈ బెతూయేలు రిబ్కాకు తండ్రి. ");
INSERT INTO tel2017_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","అబ్రాహాము సోదరుడైన నాహోరుకు ఆ ఎనిమిదిమందీ మిల్కా ద్వారా కలిగారు. ");
INSERT INTO tel2017_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","అతని ఉంపుడుకత్తె రెయూమా ద్వారా అతనికి తెబహు, గహము, తహషు, మయకా పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","శారా నూట ఇరవై ఏడు సంవత్సరాలు జీవించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","కనాను దేశంలో హెబ్రోను అని పిలిచే కిరియత్ ఆర్బా అనే ప్రాంతంలో ఆమె మరణించింది. అప్పుడు అబ్రాహాము శారా కోసం దుఃఖించడానికి, విలపించడానికీ వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","తరువాత అబ్రాహాము చనిపోయిన తన భార్య దగ్గరనుండి లేచి హేతు వారసులతో ఇలా మాట్లాడాడు, ");
INSERT INTO tel2017_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“నేను మీ మధ్య ఒక పరదేశిగానూ పరాయి వాడిగానూ ఉన్నాను. చనిపోయిన నా భార్య నా కళ్ళెదుట ఉంది. చనిపోయిన నా వాళ్ళను పాతిపెట్టడానికి నాకు ఒక స్మశాన భూమిని సొంతానికి ఇవ్వండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","దానికి హేతు వారసులు ఇలా అన్నారు “అయ్యా, మేము చెప్పేది వినండి. నువ్వు మా మధ్య ఒక మహారాజులా ఉన్నావు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","మా శ్మశాన భూముల్లో అతి శ్రేష్ఠమైన దాంట్లో చనిపోయిన నీ వాళ్ళను పాతి పెట్టు. చనిపోయిన నీ భార్యను పాతి పెట్టడానికి మాలో ఎవరూ తమ భూమిని నీకివ్వడానికి నిరాకరించరు.” ");
INSERT INTO tel2017_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","అప్పుడు అబ్రాహాము లేచి ఆ దేశ ప్రజలైన హేతు వారసుల ముందు సాగిల పడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“చనిపోయిన నా భార్యను పాతిపెట్టే విషయంలో మీరు నాతో ఏకీభవిస్తే నా మాట వినండి. సోహరు కొడుకైన ఎఫ్రోనుతో నా తరపున మాట్లాడండి. ");
INSERT INTO tel2017_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","అతని పొలం చివరన ఉన్న మక్పేలా గుహను నాకు ఇమ్మని అతనితో మనవి చేయండి. అది నా సొంత స్మశానంగా ఉండటానికి దాన్ని పూర్తి వెలకు నాకు అమ్మమని చెప్పండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ఆ ఎఫ్రోను హేతు సంతతివారి మధ్యలోనే కూర్చుని ఉన్నాడు. హిత్తీయుడైన ఎఫ్రోను ఆ పట్టణ ద్వారం లో ప్రవేశించే వారందరి ముందు హేతు సంతతివారు వింటుండగా అబ్రాహాముకు ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“అయ్యా, అలా కాదు. నేను చెప్పేది వినండి. ఆ పొలాన్నీ దానిలో ఉన్న గుహను కూడా మీకిస్తున్నాను. నా ప్రజలందరి సమక్షంలోనే దాన్ని మీకిస్తున్నాను. చనిపోయిన మీ భార్యను పాతిపెట్టడానికి మీకిస్తున్నాను.” ");
INSERT INTO tel2017_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","అప్పుడు అబ్రాహాము ఆ దేశపు ప్రజల ముందు సాగిల పడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","“నీ కిష్టమైతే నా మనవి విను. ఆ పొలానికి వెల చెల్లిస్తాను. నా దగ్గర వెల పుచ్చుకో. అప్పుడు నా భార్యను అక్కడ పాతిపెడతాను” అని అందరికీ వినపడేలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","దానికి ఎఫ్రోను ఇలా జవాబిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“అయ్యా, విను. ఆ భూమి వెలగా నాలుగు వందల షెకెల్ల వెండి చెల్లిస్తే చాలు. ఆ మాత్రం మొత్తం నీకూ నాకూ ఎంత? చనిపోయిన నీ భార్యను పాతిపెట్టుకో” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","అబ్రాహాము ఎఫ్రోను చెప్పిన మాట విన్నాడు. హేతు కుమారులకు వినబడేలా ఎఫ్రోను చెప్పిన వెలను అంటే వర్తకుల తూకం ప్రకారం నాలుగు వందల షెకెల్ల వెండిని అబ్రాహాము తూచి అతనికి ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ఆ విధంగా మమ్రే పక్కనే ఉన్న మక్పేలా లోని ఎఫ్రోను పొలం, దాంట్లో ఉన్న గుహ, ఆ పొలంలోనూ దాని సరిహద్దుల్లోనూ ఉన్న చెట్లతో సహా ");
INSERT INTO tel2017_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ఆ ఊరి ద్వారంలో ప్రవేశించే వారందరి ముందు హేతు వారసుల సమక్షంలో అబ్రాహాముకు స్వాధీనం అయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ఆ తరువాత అబ్రాహాము కనాను దేశంలో హెబ్రోను అని పిలిచే మమ్రే పక్కనే ఉన్న మక్పేలా పొలం లోని గుహలో తన భార్య శారాను పాతిపెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ఆ విధంగా ఆ పొలాన్నీ, దాంట్లో ఉన్న గుహనీ శ్మశానం కోసం అబ్రాహాముకు హేతు సంతతి వారు ఇవ్వడం వల్ల అవి అతని సొంతం అయ్యాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","అబ్రాహాము బాగా వయస్సు మళ్ళి వృద్దుడయ్యాడు. యెహోవా అన్ని విషయాల్లో అబ్రాహామును ఆశీర్వదించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","అప్పుడు అబ్రాహాము తన ఆస్తి వ్యవహారాలనూ ఇంటి విషయాలనూ నిర్వహించే పెద్ద దాసుడిని పిలిచాడు. “నీ చెయ్యి నా తొడ కింద ఉంచు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","నేను నివాసముంటున్న ఈ కనాను వాసుల కూతుళ్ళలో ఒక అమ్మాయిని ఇచ్చి నా కొడుక్కి పెళ్ళి చేయకుండా ");
INSERT INTO tel2017_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","నా స్వదేశంలో ఉన్న నా బంధువుల దగ్గరికి వెళ్ళు. అక్కడనుండి నా కొడుకు ఇస్సాకుకు భార్యను తీసుకురావాలి. ఇలా చేస్తానని నీతో ‘భూమీ ఆకాశాలకు దేవుడైన యెహోవా తోడు’ అని ప్రమాణం చేయిస్తాను” అని అతనితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","దానికి ఆ దాసుడు “ఒకవేళ ఆమె నాతో కలసి ఈ దేశం రావడానికి ఇష్టపడక పొతే నీ కొడుకునే నీ స్వదేశానికి తీసుకుని వెళ్ళాలా?” అని ప్రశ్నించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","అప్పుడు అబ్రాహాము “ఎట్టి పరిస్థితిలోనూ నా కొడుకుని నువ్వు అక్కడికి తీసుకు వెళ్ళకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","నా తండ్రి ఇంటి నుండీ, నా బంధువుల దేశం నుండీ నన్ను తీసుకు వచ్చి ‘నీ సంతానానికి ఈ దేశాన్ని ఇస్తాను’ అని పరలోకపు దేవుడైన యెహోవా నాకు ప్రమాణం చేశాడు. ఆ దేవుడే తన దూతను నీకు ముందుగా పంపుతాడు. అక్కడనుండి నువ్వు నా కొడుక్కి భార్యను తీసుకుని వస్తావు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","అయితే ఒకవేళ నీ వెంట రావడానికి ఆమె ఇష్టపడక పొతే నాకు చేసిన ప్రమాణం నుండి విడుదల పొందుతావు. అంతేకానీ నా కొడుకుని మాత్రం నువ్వు అక్కడికి తీసుకు వెళ్ళకూడదు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","కాబట్టి ఆ దాసుడు తన యజమాని అయిన అబ్రాహాము తొడ కింద తన చెయ్యి పెట్టి ఈ విషయం ప్రమాణం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ఆ దాసుడు తన యజమానికి చెందిన పది ఒంటెలను తీసుకుని ప్రయాణమయ్యాడు. అలాగే తన యజమాని దగ్గర నుండి అనేక రకాలైన వస్తువులను బహుమానాలుగా తీసుకు వెళ్ళాడు. అతడు ప్రయాణమై వెళ్ళి ఆరాం నహరాయిము ప్రాంతంలో ఉన్న నాహోరు పట్టణం చేరాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","అతడు ఆ పట్టణం బయటే ఉన్న ఒక నీటి బావి దగ్గర తన ఒంటెలను మోకరింప చేశాడు. అప్పటికి సాయంత్రం అయింది. ఊరి స్త్రీలు నీళ్ళు తోడుకోడానికి వచ్చే సమయమది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","అప్పుడు అతడు ఇలా ప్రార్థించాడు. “నా యజమాని అయిన అబ్రాహాము దేవుడివైన యెహోవా, నా యజమాని అయిన అబ్రాహాముపట్ల నీ నిబంధన విశ్వాస్యత చూపి ఈ రోజు నాకు కార్యం సఫలం చెయ్యి. ");
INSERT INTO tel2017_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ఇదిగో చూడు, నేను ఈ నీళ్ళ బావి దగ్గర నిలబడ్డాను. ఈ ఊళ్ళో వాళ్ళ పిల్లలు నీళ్ళు తోడుకోవడం కోసం వస్తున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ఇది ఈ విధంగా జరగనియ్యి. ‘నీ కుండ కొంచెం వంచి నేను తాగడానికి కాసిన్ని నీళ్ళు పొయ్యి’ అని నేను అంటే ‘తాగండి, మీ ఒంటెలకు కూడా నీళ్ళు పెడతాను’ అని ఏ అమ్మాయి అంటుందో ఆ అమ్మాయే నీ సేవకుడు ఇస్సాకు కోసం నువ్వు ఏర్పాటు చేసిన అమ్మాయి అయి ఉండాలి. ఈ విధంగా నువ్వు నా యజమాని పట్ల నిబంధన విశ్వాస్యత చూపించావని తెలుసుకుంటాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","అతడు ఈ మాటలు ముగించక ముందే రిబ్కా కుండ భుజంపై పెట్టుకుని అక్కడికి వచ్చింది. ఆమె బెతూయేలు కూతురు. ఈ బెతూయేలు అబ్రాహాము సోదరుడైన నాహోరుకూ అతని భార్య అయిన మిల్కాకూ పుట్టిన కుమారుడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ఆ అమ్మాయి చాలా అందకత్తె, కన్య. పురుష స్పర్శ ఎరగనిది. ఆమె ఆ బావిలోకి దిగి కుండతో నీళ్ళు నింపుకుని పైకి వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","అప్పుడు ఆ సేవకుడు ఆమెను కలుసుకోడానికి పరుగెత్తుకుంటూ వెళ్ళాడు. “దయచేసి నీ కుండలో నీళ్ళు తాగడానికి నాకు పోస్తావా?” అని ఆమెను అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","దానికామె “అయ్యా, తాగండి” అంటూ చప్పున కుండ చేతిమీదికి దించుకుని అతడు తాగడానికి నీళ్ళు ఇచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ఆమె అతనికి తాగడానికి నీళ్ళు ఇచ్చిన తరవాత “మీ ఒంటెలు తాగేందుకు కూడా నీళ్ళు తోడి పోస్తాను” అని చెప్పి ");
INSERT INTO tel2017_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","త్వరగా అక్కడి తొట్టిలో కుండెడు నీళ్ళు కుమ్మరించి తిరిగి నీళ్ళు తోడటానికి బావి దగ్గరికి పరుగు తీసింది. అతని ఒంటెలన్నిటికీ నీళ్ళు తోడి పోసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ఆ వ్యక్తి తన ప్రయాణాన్ని యెహోవా సఫలం చేశాడో లేదో తెలుసుకోడానికి ఆమెను మౌనంగా గమనిస్తూనే ఉన్నాడు ");
INSERT INTO tel2017_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ఒంటెలు నీళ్ళు తాగడం అయ్యాక అతడు అరతులం బరువున్న ఒక బంగారపు ముక్కుపుడకను, ఆమె చేతులకు పది తులాల బరువున్న రెండు బంగారు కడియాలను బయటకు తీశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ఆమెను “నువ్వు ఎవరి అమ్మాయివి? మీ నాన్న గారింట్లో మేము ఈ రాత్రి ఉండటానికి స్థలం దొరుకుతుందా? దయచేసి నాకు చెప్పు” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","దానికి ఆమె “నేను నాహోరుకూ మిల్కాకూ కొడుకైన బెతూయేలు కూతుర్ని” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ఇంకా ఆమె “మా దగ్గర చాలా గడ్డీ, మేతా ఉన్నాయి. రాత్రి ఉండటానికి స్థలం కూడా ఉంది” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ఆ వ్యక్తి తల వంచి యెహోవాను ఇలా ఆరాధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“అబ్రాహాము అనే నా యజమాని దేవుడైన యెహోవాకు స్తుతి కలుగు గాక! ఆయన నా యజమానికి తన నిబంధన విశ్వాస్యతనూ, తన విశ్వసనీయతనూ చూపడం మానలేదు. నన్నయితే ఆయన సరిగ్గా నా యజమాని బంధువుల ఇంటికే నడిపించాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","అప్పుడు ఆ అమ్మాయి ఇంటికి పరుగెత్తుకుంటూ వెళ్ళి అక్కడ అందరికీ జరిగిన విషయమంతా చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ఈ రిబ్కాకు ఒక సోదరుడున్నాడు. అతని పేరు లాబాను. అతడు తన సోదరి చేతులకున్న కడియాలూ ముక్కుకు ఉన్న పుడకనూ చూశాడు. అలాగే “ఆ వ్యక్తి నాతొ ఇలా చెప్పాడు” అంటూ తన సోదరి చెప్పిన మాటలూ విన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","అప్పుడు లాబాను బయట ఆ బావి దగ్గరే ఉన్న ఆ వ్యక్తి దగ్గరికి పరుగెత్తుకుంటూ వచ్చాడు. అప్పుడతను తన ఒంటెల పక్కనే నిలబడి ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","అతణ్ణి చూసి లాబాను ఇలా అన్నాడు. “యెహోవా ఆశీర్వదించిన వాడా. లోపలికి రండి. మీరు బయటే ఎందుకున్నారు? నేను ఇంటినీ, మీ ఒంటెలకు స్థలాన్నీ సిద్ధం చేశాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ఆ వ్యక్తి తన ఇంటికి వచ్చినప్పుడు లాబాను ఆ ఒంటెల జీను ఊడదీసి వాటికి గడ్డీ మేతా పెట్టాడు. అబ్రాహాము సేవకునికీ అతనితో కూడా వచ్చిన వారికీ కాళ్ళు కడుక్కోడానికి నీళ్ళు ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","భోజనం చేయమని అతని ముందు ఆహారం పెట్టారు. కానీ అతడు “నేను చెప్పాల్సిన విషయం ఒకటుంది. అది చెప్పే వరకూ నేను భోజనం చేయను” అన్నాడు. అందుకు “చెప్పండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","అప్పుడు అతడు ఇలా చెప్పాడు. “నేను అబ్రాహాము దాసుణ్ణి. ");
INSERT INTO tel2017_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","యెహోవా నా యజమానిని ఎంతో ఆశీర్వదించాడు. అతడు చాలా గొప్పవాడయ్యాడు. ఆయన అతనికి ఎన్నో గొర్రెలనూ, పశువులనూ, వెండీ బంగారాలనూ, దాసులనీ, దాసీలనూ అనుగ్రహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","నా యజమాని భార్య శారా. ఆమె వృద్ధురాలు అయ్యాక నా యజమానికి ఒక కొడుకుని కని ఇచ్చింది. నా యజమాని తనకున్న ఆస్తినంతా తన కొడుక్కే ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","నా యజమాని నాతో ఇలా చెప్పాడు, ‘నేను ప్రస్తుతం నివసిస్తున్న ఈ కనాను దేశపు అమ్మాయిల్లో ఎవర్నీ నా కొడుక్కి ఇచ్చి పెళ్ళి చేయవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","నువ్వు నా తండ్రి ఇంటికీ, నా రక్త సంబధికుల దగ్గరకూ వెళ్ళి అక్కడ నుండి నా కొడుకు కోసం ఒక అమ్మాయిని భార్యగా తీసుకు రావాలి’ అంటూ నాతో ప్రమాణం చేయించుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","దానికి నేను ‘ఒకవేళ ఆ అమ్మాయి నాతో రాకపోతే?’ అని నా యజమానిని అడిగాను. ");
INSERT INTO tel2017_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","అతడు ‘నేను యెహోవా సన్నిధిలో నివసిస్తున్నాను. ఆయనే నీతో తన దూతను పంపి నీ ప్రయాణాన్ని సఫలం చేస్తాడు. కాబట్టి నువ్వు నా కొడుక్కి నా బంధువుల నుండి నా తండ్రి వారసులనుండి భార్యగా ఉండేందుకు ఒక అమ్మాయిని తీసుకు వస్తావు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","అయితే నువ్వు నా రక్త సంబధికుల దగ్గరికి వెళ్ళాక వాళ్ళ అమ్మాయిని నీతో పంపడానికి వాళ్ళు ఇష్టపడక పోతే ఈ ప్రమాణం నుండి నువ్వు విముక్తుడివి అవుతావు’ అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","నేను ఈ రోజు ఆ బావి దగ్గరికి వచ్చినప్పుడు ఇలా ప్రార్థించాను. ‘నా యజమాని అబ్రాహాము దేవుడవైన యెహోవా, నా ఈ ప్రయాణాన్ని విజయవంతం చేస్తే ");
INSERT INTO tel2017_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","నేను ఈ నీళ్ళ బావి దగ్గర ఉన్నప్పుడు నీళ్ళు తోడుకోడానికి వచ్చిన అమ్మాయితో నేను, “దయచేసి నీ కుండలో నీళ్ళు కాసిన్ని నాకు తాగడానికి ఇవ్వు” అని అడిగితే ");
INSERT INTO tel2017_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","“మీరు తాగండి, మీ ఒంటెలకు కూడా నీళ్ళు తోడి పోస్తాను” అని ఏ అమ్మాయి చెప్తుందో ఆ అమ్మాయే నా యజమాని కొడుక్కి నువ్వు నియమించిన భార్య అయి ఉంటుంది అని నేను యెహోవా దగ్గర మనవి చేసుకున్నాను.’ ");
INSERT INTO tel2017_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","నేను నా హృదయంలో అలా అనుకున్నానో లేదో రిబ్కా తన భుజం మీద కుండ పెట్టుకుని బావి దగ్గరికి వచ్చి ఆ బావి లోకి దిగి నీళ్ళు తోడుకుని వచ్చింది. అప్పుడు నేను నాకు తాగడానికి నీళ్ళు ఇమ్మని ఆమెను అడిగాను. ");
INSERT INTO tel2017_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ఆమె వెంటనే కుండ దించి ‘తాగండి, మీ ఒంటెలకు కూడా నీళ్ళు పెడతాను’ అంది. నేను ఆ నీళ్ళు తాగాను. ఆమె ఒంటెలకు కూడా నీళ్ళు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","అప్పుడు నేను ‘నువ్వు ఎవరి అమ్మాయివి?’ అని అడిగాను. ఆమె ‘నేను మిల్కా నాహోరుల కొడుకు బెతూయేలు కూతురుని’ అని చెప్పినప్పుడు నేను ఆమెకు ముక్కుకు పుడకా చేతులకు కడియాలూ పెట్టాను. ");
INSERT INTO tel2017_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","నా యజమాని బంధువు కూతుర్నే అతని కొడుక్కి భార్యగా తీసుకు వెళ్ళడానికి నన్ను సరైన మార్గంలో నడిపించిన యెహోవాను నా తలవంచి ఆరాధించాను. నా యజమాని దేవుడైన యెహోవాకు స్తుతులు చెల్లించాను. ");
INSERT INTO tel2017_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","కాబట్టి ఇప్పుడు నా యజమాని పట్ల మీరు దయనూ నమ్మకాన్నీ చూపించ దల్చుకుంటే ఆ విషయం నాకు చెప్పండి. మీకిష్టం లేకపోతే అదైనా చెప్పండి. అప్పుడు నేనెటు వెళ్ళాలో అటు వెళ్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","అప్పుడు లాబానూ, బెతూయేలూ ఇలా జవాబిచ్చారు. “ఈ విషయం యెహోవా నుండి కలిగింది. ఇది మంచో, చెడో మేమేమి చెప్పగలం? ");
INSERT INTO tel2017_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","చూడు, రిబ్కా ఇక్కడే నీ ఎదుటే ఉంది. ఆమెను తీసుకు వెళ్ళు. యెహోవా మాట ప్రకారం ఆమె నీ యజమాని కొడుక్కి భార్య అవుతుంది గాక!” ");
INSERT INTO tel2017_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","అబ్రాహాము సేవకుడు వారి మాటలు విని యెహోవాకు సాష్టాంగ నమస్కారం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","తరువాత ఆ సేవకుడు వెండీ బంగారు నగలనూ, వస్త్రాలనూ బయటికి తీసి రిబ్కాకు ఇచ్చాడు. అలాగే అతడు ఆమె తల్లికీ, సోదరుడికీ విలువైన కానుకలిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","అప్పుడు అతడూ అతనితో వచ్చిన వాళ్ళూ భోజన పానాదులు చేశారు. ఆ రాత్రి అక్కడే గడిపారు. ఉదయాన్నే లేచి అతడు “నా యజమాని దగ్గరికి నన్ను పంపించండి” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ఆమె సోదరుడూ, ఆమె తల్లీ “మా అమ్మాయిని కనీసం పది రోజులన్నా మా దగ్గర ఉండనీయి. తరువాత ఆమెను తీసుకు వెళ్ళవచ్చు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","కానీ అతడు “యెహోవా నా ప్రయాణాన్ని సఫలం చేసాడు. కాబట్టి దయచేసి నన్ను ఆపవద్దు. నా యజమాని దగ్గరికి నన్ను పంపించండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","అప్పుడు వాళ్ళు అమ్మాయిని పిలిచి తను ఏమంటుందో తెలుసుకుందాం ");
INSERT INTO tel2017_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","అని రిబ్కాను పిలిచారు. “ఈ వ్యక్తి తో నువ్వు వెళ్తావా?” అని అడిగారు. దానికామె “వెళ్తాను” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","కాబట్టి వాళ్ళు తమ సోదరి అయిన రిబ్కాను మరో దాసీని తోడుగా ఇచ్చి అబ్రాహాము సేవకుడూ, అతనితో వచ్చిన మనుషులతో పంపించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","అప్పుడు వాళ్ళు రిబ్కాతో “మా సోదరీ, నువ్వు లక్షలాది మందికి తల్లివి కావాలి. నీ సంతానం తమను ద్వేషించే వారి గుమ్మాలను ఆక్రమించుకుంటారు గాక!” అంటూ ఆమెను దీవించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","రిబ్కా, ఆమె సేవకురాళ్ళూ ఒంటెలెక్కి ఆ వ్యక్తి వెంట వెళ్లారు. ఆ విధంగా అబ్రాహాము సేవకుడు రిబ్కాను తీసుకుని తన దారిన వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ఇస్సాకు కనాను దక్షిణ దేశంలో నివాసమున్నాడు. ఆ సమయంలో అతడు బెయేర్‌ లహాయి రోయి నుండి వస్తూ ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ఆ సాయంత్రం ఇస్సాకు ధ్యానం చేయడానికి మైదానంలోకి వెళ్ళాడు. అక్కడ అతడు తలెత్తి చూసినప్పుడు ఒంటెలు వస్తూ ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","రిబ్కా కూడా ఇస్సాకును చూసింది. వెంటనే ఒంటె పైనుండి దిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“మనలను కలుసుకోడానికి మైదానం నుండి వస్తున్నఆ వ్యక్తి ఎవరు?” అని అబ్రాహాము సేవకుణ్ణి అడిగింది. దానికతడు “ఆయన నా యజమాని” అన్నాడు. వెంటనే ఆమె ముసుగు వేసుకుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","అప్పుడు ఆ దాసుడు జరిగినదంతా ఇస్సాకుకు వివరించి చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","అప్పుడు ఇస్సాకు తన తల్లి అయిన శారా గుడారం లోకి ఆమెను తీసుకు వెళ్ళాడు. అలా అతడు రిబ్కాను తన భార్యగా స్వీకరించాడు. అతడు ఆమెను ప్రేమించాడు. అప్పుడు ఇస్సాకు తన తల్లి మరణం విషయమై ఆదరణ పొందాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","అబ్రాహాము మళ్ళీ ఇంకో స్త్రీని పెళ్ళి చేసుకున్నాడు. ఆమె పేరు కెతూరా. ");
INSERT INTO tel2017_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ఆమె ద్వారా అతనికి జిమ్రాను, యొక్షాను, మెదాను, మిద్యాను, ఇష్బాకు, షూవహు అనేవాళ్ళు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","యొక్షాను షేబ, దెదానులకు జన్మనిచ్చాడు. అష్షూరీయులు, లెతూషీయులు, లెయుమీయులు అనే జాతులు ఈ దెదాను సంతానమే. ");
INSERT INTO tel2017_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","మిద్యాను కొడుకులు ఎవరంటే ఏయిఫా, ఏఫెరు, హనోకు, అబీదా, ఎల్దాయా అనేవాళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","వీళ్ళందరూ కెతురా సంతానం. అబ్రాహాము తన సంపదనంతా ఇస్సాకుకు ఇచ్చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","అబ్రాహాము తాను బ్రతికి ఉండగానే తన ఉంపుడుగత్తెల కొడుకులకు కానుకలిచ్చి తన కొడుకు ఇస్సాకు దగ్గర నుండి వారిని తూర్పు ప్రాంతాలకు పంపి వేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","అబ్రాహాము మొత్తం నూట డెబ్భై ఐదు సంవత్సరాలు జీవించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","అబ్రాహాము సుదీర్ఘకాలం జీవించి నిండు వృద్ధాప్యంలో సంపూర్ణ జీవితం గడిపి చనిపోయి తన పితరులను చేరుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","అతని కొడుకులు ఇస్సాకూ, ఇష్మాయేలూ కలసి మమ్రే ఎదురుగా ఉన్న మక్పేలా గుహలో అతణ్ణి పాతి పెట్టారు. అది హిత్తీయుడైన సోహరు కుమారుడు ఎఫ్రోనుకు చెందిన పొలంలో ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","అబ్రాహాము హేతు వారసుల దగ్గర కొన్న ఈ పొలంలోనే అబ్రాహామునూ అతని భార్య శారానూ పాతిపెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","అబ్రాహాము చనిపోయిన తరువాత దేవుడు అతని కొడుకు ఇస్సాకును ఆశీర్వదించాడు. ఆ సమయంలో ఇస్సాకు బెయేర్‌ లహాయి రోయి దగ్గర నివాసమున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ఐగుప్తీయురాలూ శారా దాసీ అయిన హాగరు ద్వారా అబ్రాహాముకు పుట్టిన ఇష్మాయేలు వంశావళి ఇది. ");
INSERT INTO tel2017_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ఇష్మాయేలు పెద్ద కొడుకు అయిన నేబాయోతూ, కేదారు, అద్బయేలూ, మిబ్శామూ, ");
INSERT INTO tel2017_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","మిష్మా, దూమానమశ్శా, ");
INSERT INTO tel2017_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","హదరూ, తేమా, యెతూరూ, నాపీషూ, కెదెమా. ");
INSERT INTO tel2017_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ఇష్మాయేలు కొడుకులు వీరే. వారి వారి గ్రామాల ప్రకారమూ, కోటల ప్రకారమూ వంశావళుల ప్రకారమూ వాళ్ళ పేర్లు ఇవి. వీళ్ళు తమ తమ వంశాల ప్రకారం పన్నెండు మంది రాజులు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ఇష్మాయేలు నూట ముప్ఫై ఏడు సంవత్సరాలు జీవించాడు. ఆ తరువాత అతడు ప్రాణం విడిచాడు. తన పితరులను చేరుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","వీళ్ళు అష్షూరుకు వెళ్ళే దారిలో హవీలా నుండి ఐగుప్తుకు సమీపంగా ఉన్న షూరు వరకూ నివసిస్తుండే వాళ్ళు. వీళ్ళు ఒకరి పట్ల మరొకరు విరోధంగా జీవించేవారు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","అబ్రాహాము కొడుకు ఇస్సాకును గూర్చిన సంగతులు ఇవి. అబ్రాహాము ఇస్సాకుకు తండ్రి. ");
INSERT INTO tel2017_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ఇస్సాకు పద్దనరాములో నివసించే సిరియా వాడైన బెతూయేలు కూతురూ సిరియావాడైన లాబాను సోదరీ అయిన రిబ్కాను పెళ్ళి చేసుకున్నాడు. అప్పటికి అతని వయస్సు నలభై సంవత్సరాలు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ఇస్సాకు భార్యకి పిల్లలు కలుగలేదు. అందుకని ఇస్సాకు ఆమె విషయం యెహోవాను వేడుకున్నాడు. యెహోవా అతని ప్రార్థన విన్నాడు. ఆ ప్రార్థనకు జవాబిచ్చాడు. ఫలితంగా అతని భార్య రిబ్కా గర్భవతి అయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ఆమె గర్భంలో ఇద్దరు పసికందులు ఉన్నారు. వాళ్ళిద్దరూ గర్భంలోనే పోరాడుకుంటున్నారు. కాబట్టి ఆమె “నాకెందుకిలా జరుగుతోంది. ఇలా అయితే నేను బతకడం ఎందుకు?” అనుకుని ఈ విషయమై యెహోవాను ప్రశ్నించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","అప్పుడు యెహోవా ఆమెతో ఇలా చెప్పాడు. “రెండు జాతులు నీ గర్భంలో ఉన్నాయి. రెండు గోత్రాలు నీ గర్భంలో నుండే వేరుగా వస్తాయి. ఒక జాతి కంటే ఒక జాతి బలంగా ఉంటుంది. పెద్దవాడు చిన్నవాడికి దాసుడవుతాడు.” ");
INSERT INTO tel2017_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ఆమెకు నెలలు నిండి ప్రసవించే సమయం వచ్చినప్పుడు ఆమె గర్భంలో కవలలు ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","మొదటివాడు ఎర్రగా పుట్టాడు. ఎర్రటి వస్త్రంలా ఒళ్ళంతా జుట్టు ఉంది. కాబట్టి అతనికి ఏశావు అనే పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","తరువాత అతని తమ్ముడు బయటకు వచ్చాడు. ఇతడు ఏశావు మడిమను చేత్తో పట్టుకుని వచ్చాడు. అతనికి యాకోబు అనే పేరు పెట్టారు. వాళ్ళిద్దరూ పుట్టినప్పుడు ఇస్సాకుకు అరవై ఏళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ఆ పిల్లలిద్దరూ పెద్దవాళ్ళయ్యారు. వారిలో ఏశావు జంతువులను వేటాడడంలో నైపుణ్యం సాధించాడు. అరణ్యవాసిగా తిరిగేవాడు. కానీ యాకోబు నెమ్మదస్తుడు. గుడారంలోనే ఉండేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ఇస్సాకు ఏశావును ప్రేమించాడు. ఎందుకంటే ఏశావు వేటాడి తెచ్చిన జంతు మాంసాన్ని అతడు ఇష్టపడి తింటూ ఉండేవాడు. రిబ్కాకు అయితే యాకోబు అంటే ఇష్టం. ");
INSERT INTO tel2017_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","యాకోబు కూరలతో వంట చేస్తూ ఉన్న సమయంలో ఏశావు చాలా అలసిపోయి పొలం నుండి ఇంటికి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ఏశావు యాకోబును “దయచేసి ఎర్రగా ఉన్న ఆ వంటకాన్ని నాకు తినడానికివ్వు. నేను చాలా అలసి పోయాను” అని అడిగాడు. అందుకే అతనికి ఏదోము అనే పేరు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","అందుకు యాకోబు “ముందు పెద్దవాడుగా నీ జన్మ హక్కుని నాకు ఇచ్చెయ్యి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","అప్పుడు ఏశావు “చూడు, నేను ఆకలితో చావబోతున్నాను. ఈ జన్మహక్కు నాకెందుకు?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","యాకోబు “ముందు ప్రమాణం చెయ్యి” అన్నాడు. ఏశావు యాకోబుతో ప్రమాణం చేసి తన జన్మ హక్కుని అతనికి ఆ విధంగా అమ్మి వేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","యాకోబు తన దగ్గర ఉన్న రొట్టె, చిక్కుడు కాయల కూర ఏశావుకు ఇచ్చాడు. ఏశావు రొట్టే, కూరా తిని, తాగి అక్కడ నుండి తన దారిన వెళ్లి పోయాడు. ఆ విధంగా ఏశావు తన జ్యేష్ఠత్వపు జన్మ హక్కుని తిరస్కారంగా ఎంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","అబ్రాహాము రోజుల్లో వచ్చిన మొదటి కరువు కాకుండా ఆ దేశంలో మరో కరువు వచ్చింది. అప్పుడు ఇస్సాకు గెరారులో ఉన్న ఫిలిష్తీయుల రాజు అబీమెలెకు దగ్గరికి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","అక్కడ యెహోవా అతనికి ప్రత్యక్షమయ్యాడు. “నువ్వు ఐగుప్తుకి వెళ్ళవద్దు. నేను నీతో చెప్పే దేశంలోనే నివసించు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ప్రస్తుతం నువ్వున్న ఈ దేశంలోనే పరదేశిగా ఉండిపో. నేను నీతో ఉంటాను. నిన్ను ఆశీర్వదిస్తాను. నీ తండ్రి అయిన అబ్రాహాముతో చేసిన నిబంధనను నెరవేరుస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","నీ వంశస్థులను ఆకాశంలో నక్షత్రాల్లా విస్తరింపజేస్తాను. నీ వంశస్థులకు ఈ భూములన్నీ ఇస్తాను. నీ వంశస్థుల ద్వారా భూమిపైని జాతులన్నిటినీ ఆశీర్వదిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ఎందుకంటే నీ తండ్రి అబ్రాహాము నా మాటకు లోబడి నా ఆజ్ఞలనూ, శాసనాలనూ, నా చట్టాలనూ, నా నియమాలనూ పాటించాడు” అని అతనికి చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","కాబట్టి ఇస్సాకు గెరారులో నివసించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","అక్కడి మనుషులు అతని భార్యను చూసి ఆమె సంగతి ఇస్సాకును అడిగారు. దానికతడు “ఆమె నా చెల్లి” అని చెప్పాడు. ఆమె తన భార్య అని చెప్పడానికి భయపడ్డాడు. ఎందుకంటే రిబ్కా అందకత్తె కాబట్టి అక్కడి మనుషులు ఆమె కోసం తనని చంపుతారేమో అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","అతడు చాలా రోజులు అక్కడ గడిపాడు. తరువాత ఒక రోజు ఫిలిష్తీయుల రాజు అబీమెలెకు కిటికీలో నుండి చూస్తుంటే సరిగ్గా అదే సమయంలో ఇస్సాకు తన భార్య రిబ్కాతో సరస సల్లాపాలు ఆడటం అతనికి కనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","అప్పుడు అబీమెలెకు ఇస్సాకును పిలిపించి “చూడు, ఆమె కచ్చితంగా నీ భార్యే, ఆమె నా చెల్లి అని ఎందుకు చెప్పావు?” అని అడిగాడు. దానికి ఇస్సాకు “ఆమెను పొందటం కోసం ఎవరైనా నన్ను చంపుతారేమోనని అనుకున్నాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","అందుకు అబీమెలెకు “నువ్వు మాకు చేసిన ఈ పని ఏమిటి? ఈ ప్రజల్లో ఎవడైనా భయం లేకుండా తేలిగ్గా ఆమెతో శారీరిక సంబంధం పెట్టుకునే వాడే కదా! మాకు ఆ పాతకం చుట్టుకునేదే కదా!” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","కాబట్టి అబీమెలెకు తన ప్రజలందరికీ “ఈ వ్యక్తిని గానీ ఇతని భార్యను గానీ ముట్టుకునే వాడు కచ్చితంగా మరణశిక్ష పొందుతాడు” అంటూ ఒక హెచ్చరిక జారీ చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ఇస్సాకు ఆ దేశంలో నివసించి వ్యవసాయం చేసాడు. ఆ సంవత్సరం యెహోవా ఆశీర్వదించడం వల్ల నూరంతలు అధిక పంటను కోయగలిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","కాబట్టి ఇస్సాకు ఆస్తిపరుడయ్యాడు. క్రమక్రమంగా అభివృద్ధి చెందుతూ చాలా గొప్పవాడయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","అతనికి అనేక గొర్రెలూ పశువులూ సమకూడాయి. అనేకమంది దాసులు అతనికి ఉన్నారు. అతని సంపద చూసి ఫిలిష్తీయులు అతనిపై అసూయపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","అతని తండ్రి అయిన అబ్రాహాము రోజుల్లో అతని తండ్రి దాసులు తవ్విన బావులన్నిటినీ ఫిలిష్తీయులు మట్టి వేసి పూడ్చివేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","అప్పుడు అబీమెలెకు ఇస్సాకుతో “నువ్వు మాకంటే బలవంతుడివి. కాబట్టి ఈ ప్రాంతం విడిచి మాకు దూరంగా వెళ్లి పో” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","కాబట్టి ఇస్సాకు అక్కడనుండి తరలి వెళ్ళి గెరారు లోయలో గుడారం వేసుకుని అక్కడ నివసించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","అక్కడ ఇస్సాకు తన తండ్రి అయిన అబ్రాహాము ఆ రోజుల్లో తవ్వించిన నీళ్ళ బావులను తిరిగి తవ్వించాడు. ఎందుకంటే అబ్రాహాము మరణం తరువాత ఫిలిష్తీయులు వాటిని పూడ్చివేశారు. అబ్రాహాము పెట్టిన పేర్లనే ఇస్సాకు వాటికి పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ఇస్సాకు దాసులు ఆ లోయలో తవ్వినప్పుడు ఊటలు గల నీళ్ళ బావి లభ్యమైంది. ");
INSERT INTO tel2017_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","అప్పుడు గెరారులోని పశువుల కాపరులు ఇస్సాకు కాపరులతో “ఈ నీళ్ళు మావే” అంటూ పోట్లాడారు. ఈ విధంగా వాళ్ళు తనతో పోట్లాడారు కనుక ఇస్సాకు ఆ బావికి “ఏశెకు” అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","తరువాత వాళ్ళు మరో బావి తవ్వారు. దాని కోసం కూడా అక్కడి వాళ్ళు పోట్లాడారు. కాబట్టి ఇస్సాకు దానికి “శిత్నా” అనే పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","అతడు అక్కడ్నించి వెళ్ళిపోయి మరో బావి తవ్వించాడు. దానికోసం ఎలాంటి గొడవా జరగలేదు. కాబట్టి ఇస్సాకు “యెహోవా మనకు ఒక తావు అనుగ్రహించాడు. కాబట్టి ఇక ఈ దేశంలో మనం అభివృద్ధి చెందుతాం” అంటూ ఆ స్థలానికి రహబోతు అనే పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","అప్పుడు అక్కడనుండి ఇస్సాకు బెయేర్షెబాకు వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ఆ రాత్రే యెహోవా అతనికి ప్రత్యక్షమై ఇలా అన్నాడు. “నేను నీ తండ్రి అయిన అబ్రాహాము దేవుణ్ణి. నేను నీకు తోడుగా ఉన్నాను. కాబట్టి భయపడవద్దు. నా దాసుడైన అబ్రాహామును బట్టి నిన్ను ఆశీర్వదిస్తాను. నీ సంతానాన్ని అత్యధికం చేస్తాను.” ");
INSERT INTO tel2017_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ఇస్సాకు అక్కడ ఒక బలిపీఠం కట్టాడు. అక్కడ యెహోవా పేరుమీద ప్రార్థన చేసి అక్కడే తన గుడారం వేసుకున్నాడు. ఇస్సాకు దాసులు అక్కడ ఒక బావి తవ్వారు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ఆ సమయంలో గెరారు నుండి అబీమెలెకు తన స్నేహితుడైన ఆహుజ్జతునూ తన సైన్యాధిపతి అయిన ఫీకోలునూ వెంటబెట్టుకుని ఇస్సాకు దగ్గరికి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","వారితో ఇస్సాకు “మీరు నామీద కక్ష కట్టి మీ దగ్గరనుండి పంపివేశారు. ఇప్పుడు దేనికోసం నా దగ్గరికి వచ్చారు?” అని వారిని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","అప్పుడు వారు ఇలా జవాబిచ్చారు. “యెహోవా కచ్చితంగా నీకు తోడుగా ఉండటం మేము స్పష్టంగా చూశాం. కాబట్టి మన మధ్య ఒక నిబంధన ఉండాలని అంటే నీకూ మాకూ మధ్య నిబంధన ఉండాలని కోరుతున్నాం. ");
INSERT INTO tel2017_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","మేము నీకు ఎలాంటి హానీ చేయలేదు. నీకెలాంటి అపకారం చేయకుండా నిన్ను గౌరవంగా మా మధ్యనుండి పంపించాం. కాబట్టి ఇప్పుడు నువ్వు కూడా మాకు ఎలాంటి అపకారం చేయకుండా నీతో ఒక శాంతి ఒప్పందం చేసుకోవాలని అనుకున్నాం. నువ్వు నిజంగానే యెహోవా ఆశీర్వాదం పొందావు.” ");
INSERT INTO tel2017_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","కాబట్టి ఇస్సాకు వాళ్ళకు విందు చేశాడు. వాళ్ళు చక్కగా తిని తాగారు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","పెందలకడనే వాళ్ళు లేచి ఒకరితో మరొకరు నిబంధన చేసుకున్నారు. తరువాత ఇస్సాకు వాళ్ళను శాంతియుతంగా సాగనంపాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","అదే రోజు ఇస్సాకు దాసులు వచ్చి తాము తవ్విన ఒక బావిని గూర్చి అతనికి తెలియజేశారు. తాము తవ్విన బావిలో నీళ్ళు పడ్డాయని చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ఆ బావికి ఇస్సాకు “షీబా” అనే పేరు పెట్టాడు. కాబట్టి ఇప్పటి వరకూ ఆ ఊరి పేరు బెయేర్షెబాయే. ");
INSERT INTO tel2017_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ఏశావు నలభై సంవత్సరాల వయస్సులో హిత్తీయుడైన బేయేరీ కూతురు యహూదీతునూ, హిత్తీయుడైన ఏలోను కూతురు బాశెమతునూ పెళ్ళి చేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","వీరు ఇస్సాకు రిబ్కాలకు ఎంతో మనోవేదన కలిగించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ఇస్సాకు బాగా ముసలి వాడయ్యాడు. అతని కళ్ళు పూర్తిగా మసకబారాయి. ఆ పరిస్థితిలో అతడు తన పెద్ద కుమారుడు ఏశావుతో “నా కొడుకా” అని పిలిచాడు. అతడు “చిత్తం నాన్నగారూ” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","అప్పుడు ఇస్సాకు “చూడు, నేను ముసలివాణ్ణి. ఎప్పుడు చనిపోతానో తెలియదు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","కాబట్టి నువ్వు నీ ఆయుధాలు అమ్ముల పొదినీ, విల్లునీ తీసుకుని అడవికి వెళ్ళి అక్కడ నాకోసం వేటాడి మాంసం తీసుకురా. ");
INSERT INTO tel2017_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","దాన్ని నాకోసం రుచికరంగా వండి తీసుకురా. నాకిష్టమైన వంటకాలు సిద్ధం చేసి పట్టుకు వస్తే నేను చనిపోక ముందు వాటిని తిని నిన్ను ఆశీర్వదిస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ఇస్సాకు తన కొడుకు ఏశావుతో ఇలా చెప్తుంటే రిబ్కా వీరికి తెలియకుండా చాటు నుండి వింటూ ఉంది. ఏశావు వేటాడి మాంసం తీసుకు రావడానికి అడవికి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","అప్పుడు రిబ్కా తన కొడుకు యాకోబుతో “జాగ్రత్తగా విను. మీ నాన్న నీ అన్నతో మాట్లాడటం నేను విన్నాను. ఆయన నీ అన్నతో ");
INSERT INTO tel2017_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘నేను చనిపోక ముందు భోజనం చేసి యెహోవా సముఖంలో నిన్ను ఆశీర్వదిస్తాను. కాబట్టి నువ్వు వేటాడి మాంసం తెచ్చి నాకోసం రుచిగా వండి తీసుకురా’ అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","కొడుకా, కాబట్టి ఇప్పుడు నా మాట విను. నేను నీకు చెప్పింది చెయ్యి. ");
INSERT INTO tel2017_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","నువ్వు మంద దగ్గరికి వెళ్ళి రెండు మంచి మేక పిల్లలను పట్టుకుని రా. నేను వాటితో మీ నాన్నఇష్టపడే విధంగా రుచిగా భోజనం తయారు చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","నీ నాన్న చనిపోకముందు వాటిని తిని నిన్ను ఆశీర్వదించేలా దాన్ని నువ్వు ఆయన దగ్గరికి తీసుకు వెళ్ళు” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","దానికి యాకోబు తన తల్లితో “నా అన్న ఏశావుకు ఒళ్ళంతా జుట్టు ఉంది. నేను నున్నగా ఉంటాను. ");
INSERT INTO tel2017_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ఒకవేళ మా నాన్న నన్ను తడిమి చూశాడనుకో. అప్పుడు నేను అతని దృష్టికి ఒక మోసగాడిలా ఉంటాను. అప్పుడిక నా మీదికి ఆశీర్వాదం స్థానంలో శాపం వస్తుంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","కానీ అతని తల్లి “కొడుకా, ఆ శాపం నాపైకి వస్తుంది గాక! నువ్వు మాత్రం నా మాట విను. వెళ్ళి నేను చెప్పినట్టు వాటిని నా దగ్గరికి తీసుకుని రా” అని చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","కాబట్టి యాకోబు రెండు మేక పిల్లలను పట్టుకుని వాటిని తన తల్లి దగ్గరికి తీసుకుని వచ్చాడు. ఆమె వాటితో అతని తండ్రి ఇష్టపడే విధంగా రుచికరంగా వండి భోజనం సిద్ధం చేసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","రిబ్కా ఇంట్లో ఆమె పెద్ద కొడుకు ఏశావుకు చెందిన మంచి బట్టలు ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ఆమె వాటిని యాకోబుకు తొడిగింది. మేక పిల్లల చర్మాన్ని అతని మెడ పైని నున్నని భాగంలో కప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","తాను వండి సిద్ధం చేసిన రుచికరమైన వంటకాలనూ రొట్టెనూ తన కొడుకైన యాకోబు చేతికిచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","అతడు తన తండ్రి దగ్గరికి వచ్చాడు. నాన్నగారూ, అని పిలిచాడు. ఇస్సాకు “కొడుకా ఏమిటి? నువ్వు ఎవరివి?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","దానికి యాకోబు “నేను ఏశావుని. నీ పెద్ద కొడుకుని. నువ్వు నాకు చెప్పినట్టే చేశాను. లేచి నేను వేటాడి తెచ్చిన దాన్ని తిని నన్ను ఆశీర్వదించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","అప్పుడు ఇస్సాకు తన కొడుకుతో “నా కొడుకా అది ఇంత త్వరగా నీకు ఎలా దొరికింది?” అన్నాడు. దానికి యాకోబు “నీ దేవుడైన యెహోవా దాన్ని నా ఎదుటికి రప్పించాడు. అందుకే ఇంత త్వరగా దొరికింది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","అప్పుడు ఇస్సాకు “నా కొడుకా, నువ్వు ఏశావువి అవునో కాదో తడిమి చూస్తా. దగ్గరికి రా” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","యాకోబు తన తండ్రి అయిన ఇస్సాకు దగ్గరికి వచ్చాడు. అతడు యాకోబును తడిమి చూసి ఇలా అన్నాడు. “స్వరం యాకోబుది కానీ చేతులు ఏశావు చేతులే” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","యాకోబు చేతులు అతని అన్న అయిన ఏశావు చేతుల్లా జుట్టు కలిగి ఉండటంతో ఇస్సాకు యాకోబును గుర్తు పట్టలేకపోయాడు. కాబట్టి ఇస్సాకు అతణ్ణి ఆశీర్వదించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“నువ్వు నిజంగా నా కొడుకు ఏశావువేనా?” అని అడిగాడు. యాకోబు “అవును నేనే” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","అప్పుడు ఇస్సాకు “ఆ ఆహారం తీసుకురా. నువ్వు వేటాడి తెచ్చిన దాన్ని నేను తిని నిన్ను ఆశీర్వదిస్తాను” అన్నాడు. యాకోబు ఆహారం తీసుకు వచ్చాడు. దాన్ని అతడు తిన్నాడు. ద్రాక్షారసం తీసుకు వస్తే తాగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","అప్పుడు అతని తండ్రి అయిన ఇస్సాకు “నా కొడుకా, దగ్గరికి వచ్చి నాకు ముద్దు పెట్టు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","యాకోబు దగ్గరికి వచ్చి అతణ్ణి ముద్దు పెట్టుకున్నాడు. అప్పుడు ఇస్సాకు అతని బట్టలు వాసన చూసి అతణ్ణి ఆశీర్వదిస్తూ ఇలా అన్నాడు. “చూడు, నా కొడుకు సువాసన, యెహోవా ఆశీర్వదించిన చేని సువాసనలాగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ఆకాశం నుండి కురిసే మంచులో ఒక భాగాన్నీ, భూమి సమృద్దిలో ఒక భాగాన్నీ, విస్తారమైన ధాన్యాన్నీ, ద్రాక్షారసాన్నీ, దేవుడైన యెహోవా నీకు అనుగ్రహిస్తాడు గాక! ");
INSERT INTO tel2017_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","మనుషులు నీకు సేవలు చేస్తారు గాక! జాతులు నీ ముందు సాగిలపడతారు గాక! నీ బంధువులందరికీ నువ్వు రాజువి అవుతావు. నీ తల్లి పుత్రులు నీకు సాగిలపడతారు గాక! నిన్ను శపించేవారు శాపానికి గురి అవుతారు గాక! నిన్ను ఆశీర్వదించే వారికి ఆశీర్వాదం కలుగు గాక.” ");
INSERT INTO tel2017_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ఇలా ఇస్సాకు యాకోబును ఆశీర్వదించిన తరువాత యాకోబు తన తండ్రి ఇస్సాకు దగ్గర్నుంచి వెళ్ళిపోయాడు. వెంటనే అతని అన్న వేట నుండి తిరిగి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","అతడు కూడా రుచికరమైన ఆహారం సిద్ధం చేసి తన తండ్రి దగ్గరికి తెచ్చాడు. “నాన్నా, నీ కొడుకు వేటాడి తెచ్చిన దాన్ని తిని నన్ను ఆశీర్వదించు” అని తండ్రితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","అతని తండ్రి అయిన ఇస్సాకు “నువ్వు ఎవరివి?” అని అడిగాడు. అతడు “నేను నీ కొడుకుని. ఏశావు అనే నీ పెద్ద కొడుకుని” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","దాంతో ఇస్సాకు గడగడ వణికిపోయాడు. “అలా అయితే వేటాడిన మాంసం నా దగ్గరికి పట్టుకు వచ్చినదెవరు? నువ్వు రాకముందు నేను వాటన్నిటినీ తిని అతణ్ణి ఆశీర్వదించాను. తప్పనిసరిగా అతడే దీవెన పొందినవాడు.” ");
INSERT INTO tel2017_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ఏశావు తన తండ్రి మాటలు విని ఎంతో వేదనతో పెద్ద కేక పెట్టాడు. ఏడ్చాడు. తన తండ్రితో “నాన్నా, నన్ను కూడా ఆశీర్వదించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ఇస్సాకు “నీ తమ్ముడు మోసంతో వేషం వేసుకుని వచ్చి నీ ఆశీర్వాదాన్ని తీసుకువెళ్ళాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ఏశావు ఇలా అన్నాడు. “యాకోబు అనే పేరు వాడికి చక్కగా సరిపోయింది. వాడు నన్ను రెండు సార్లు మోసం చేశాడు. నా జ్యేష్ఠత్వపు జన్మహక్కు తీసుకున్నాడు. ఇప్పుడు నాకు రావలసిన ఆశీర్వాదం తీసుకు పోయాడు.” ఇలా చెప్పి ఏశావు తన తండ్రిని “నాకోసం ఇక ఏ ఆశీర్వాదమూ మిగల్చలేదా?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","అందుకు ఇస్సాకు “చూడు, అతణ్ణి నీకు యజమానిగా నియమించాను. అతని బంధువులందరినీ అతనికి సేవకులుగా ఇచ్చాను. ధాన్యాన్నీ కొత్త ద్రాక్షారసాన్నీ అతనకి ఇచ్చాను? ఇవి కాక నీకు ఇంకా ఏ ఆశీర్వాదాలు మిగిలి ఉన్నాయి?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ఏశావు తన తండ్రితో “నాన్నా, నీ దగ్గర ఒక్క ఆశీర్వాదమూ లేదా? నాన్నా, నన్ను కూడా ఆశీర్వదించు” అంటూ గట్టిగా ఏడ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","అతని తండ్రి ఇస్సాకు అతనికిలా జవాబిచ్చాడు. “చూడు, నీ నివాసం భూసారానికి దూరంగా ఉంటుంది. పైనుండి ఆకాశపు మంచు దాని మీద కురవదు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","నువ్వు నీ కత్తి మీద ఆధారపడి జీవిస్తావు. నీ తమ్ముడికి దాసుడివి అవుతావు. కానీ నువ్వు తిరగబడితే అతని కాడిని నీ మెడపైనుండి విరిచి వేస్తావు.” ");
INSERT INTO tel2017_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","యకోబుకు తన తండ్రి ఇచ్చిన ఆశీర్వాదం విషయమై ఏశావు అతణ్ణి ద్వేషించాడు. ఏశావు ఇలా అనుకున్నాడు. “నా తండ్రి చనిపోయే రోజు ఎంతో దూరం లేదు. అది అయ్యాక నా తమ్ముడు యాకోబును చంపుతాను.” ");
INSERT INTO tel2017_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","తన పెద్దకొడుకు ఏశావు పలికిన ఈ మాటలను గూర్చి రిబ్కా వింది. ఆమె తన చిన్నకొడుకు యాకోబును పిలిపించింది. అతనితో “చూడు, నీ అన్న ఏశావు నిన్ను చంపుతాను అనుకుంటూ తనను తాను ఓదార్చుకుంటున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","కాబట్టి కొడుకా, నా మాట విను. హారానులో ఉన్న నా సోదరుడు లాబాను దగ్గరికి పారిపో. ");
INSERT INTO tel2017_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","నీ అన్న కోపం చల్లారే వరకూ కొద్ది రోజులు అక్కడే అతనితోనే ఉండు. ");
INSERT INTO tel2017_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","నీ అన్న కోపం పూర్తిగా చల్లారిపోయి, నువ్వు అతనికి చేసిన దాన్ని అతడు మర్చిపోయే వరకూ అక్కడ ఉండు. అప్పుడు నేను అక్కడనుండి నిన్ను పిలిపిస్తాను. ఒక్క రోజులోనే నేను మీ ఇద్దరినీ పోగొట్టుకోవడం ఎందుకు?” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","రిబ్కా ఇస్సాకుతో “ఏశావు పెళ్ళాడిన హేతు జాతి స్త్రీల వల్ల నా ప్రాణం విసిగిపోయింది. ఈ దేశపు అమ్మాయిలైన హేతు కుమార్తెల్లో వీళ్ళలాంటి మరో అమ్మాయిని యాకోబు కూడా పెళ్ళి చేసుకుంటే ఇక నేను బతికి ఏం ప్రయోజనం?” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ఇస్సాకు యాకోబును పిలిపించి “నువ్వు కనాను అమ్మాయిల్లో ఎవరినీ పెళ్ళి చేసుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","నువ్వు పద్దనరాములో ఉన్న నీ తల్లికి తండ్రి అయిన బెతూయేలు ఇంటికి వెళ్ళి అక్కడ నీ మేనమామ లాబాను కుమార్తెల్లో ఒకామెను వివాహం చేసుకో ");
INSERT INTO tel2017_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","సర్వశక్తిగల దేవుడు నిన్ను ఆశీర్వదించి, నువ్వు అనేక జాతులయ్యేలా నీకు సంతానాభివృద్ధి కలిగించి, నిన్ను విస్తరింపజేసి నువ్వు పరవాసిగా ఉన్న దేశాన్ని, అంటే దేవుడు అబ్రాహాముకు ఇచ్చిన దేశాన్ని నువ్వు వారసత్వంగా పొందేలా ");
INSERT INTO tel2017_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ఆయన నీకూ నీ సంతానానికీ అబ్రాహాముకు అనుగ్రహించిన ఆశీర్వాదాన్ని దయచేస్తాడు గాక” అని దీవించి పంపివేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","అతడు పద్దనరాములో ఉన్న లాబాను దగ్గరకి ప్రయాణమయ్యాడు. లాబాను సిరియావాడు బెతూయేలు కుమారుడూ యాకోబు, ఏశావుల తల్లి అయిన రిబ్కా సోదరుడూ. ");
INSERT INTO tel2017_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ఇస్సాకు యాకోబును దీవించి, పద్దనరాములో పెళ్ళి చేసుకుని రావడానికి అతణ్ణి అక్కడికి పంపాడనీ అతనిని దీవించినప్పుడు “నువ్వు కనాను దేశపు అమ్మాయిల్లో ఎవరినీ పెళ్ళి చేసుకోవద్దు” అని అతనికి ఆజ్ఞాపించాడనీ ఏశావుకు తెలిసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","యాకోబు తన తల్లిదండ్రుల మాట విని పద్దనరాముకు వెళ్ళిపోయాడనీ, ");
INSERT INTO tel2017_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ఇదిగాక కనాను స్త్రీలు తన తండ్రి ఇస్సాకుకు ఇష్టం లేదనీ ఏశావు తెలుసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","అతడు ఇష్మాయేలు దగ్గరికి వెళ్ళి, తనకున్న భార్యలు గాక అబ్రాహాము కుమారుడు ఇష్మాయేలు కూతురు, నెబాయోతు సోదరి అయిన మహలతును కూడా పెళ్ళి చేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","యాకోబు బెయేర్షెబా నుండి బయలుదేరి హారాను వైపు వెళ్తూ ");
INSERT INTO tel2017_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ఒకచోట పొద్దుగుంకడంతో అక్కడ ఆ రాత్రి ఆగిపోయి, అక్కడి రాళ్ళలో ఒక దాన్ని తనకు తలగడగా చేసుకుని, పడుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","అప్పుడతనికి ఒక కల వచ్చింది. అందులో ఒక నిచ్చెన భూమి మీద నిలిపి ఉంది. దాని కొన ఆకాశాన్ని అంటింది. దానిమీద దేవుని దూతలు ఎక్కుతూ దిగుతూ ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","యెహోవా దానికి పైగా నిలబడి “నేను నీ తండ్రి అయిన అబ్రాహాము దేవుడు, ఇస్సాకు దేవుడు అయిన యెహోవాని. నువ్వు పండుకున్న ఈ భూమిని నీకూ నీ సంతానానికీ ఇస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","నీ సంతానం భూమి మీద లెక్కకు ఇసుక రేణువుల్లాగా అసంఖ్యాకంగా పెరిగిపోతుంది. నువ్వు పడమర, తూర్పు, ఉత్తరం, దక్షిణం దిక్కులకు వ్యాపిస్తావు. భూమి మీద వంశాలన్నీ నీ మూలంగా, నీ సంతానం మూలంగా ఆశీర్వాదం పొందుతాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ఇదిగో నేను నీకు తోడై ఉండి, నువ్వు వెళ్ళే ప్రతి చోటా నిన్ను కాపాడి ఈ దేశానికి నిన్ను మళ్ళీ రప్పిస్తాను. నేను నీతో చెప్పింది నెరవేర్చే వరకూ నిన్ను విడిచిపెట్టను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","యాకోబు నిద్ర మేలుకుని “నిశ్చయంగా యెహోవా ఈ స్థలం లో ఉన్నాడు. అది నాకు తెలియలేదు” అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","అతడు భయపడి “ఈ స్థలం ఎంతో భయం గొలిపేది. ఇది దేవుని మందిరమే గాని వేరొకటి కాదు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","పరలోకద్వారం ఇదే” అనుకున్నాడు. తెల్లవారినప్పుడు యాకోబు లేచి తాను తలగడగా చేసుకున్న రాయి తీసి దాన్ని స్తంభంగా నిలబెట్టి, దాని కొనమీద నూనె పోశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","అతడు ఆ స్థలానికి బేతేలు అనే పేరు పెట్టాడు. మొదట ఆ ఊరి పేరు లూజు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","అప్పుడు యాకోబు “నేను తిరిగి నా తండ్రి ఇంటికి క్షేమంగా వచ్చేలా దేవుడు నాకు తోడై ఉండి, నేను వెళ్తున్న ఈ మార్గంలో నన్ను కాపాడి, ");
INSERT INTO tel2017_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","తినడానికి ఆహారమూ ధరించడానికి వస్త్రాలూ నాకు దయ చేసినట్లైతే యెహోవా నాకు దేవుడై ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","అంతేకాదు, స్తంభంగా నేను నిలిపిన ఈ రాయి దేవుని మందిరం అవుతుంది. నువ్వు నాకిచ్చే సమస్తంలో పదవ వంతు నీకు తప్పక చెల్లిస్తాను” అని మొక్కుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","యాకోబు బయలుదేరి తూర్పు ప్రజల దేశానికి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","అక్కడ అతనికి పొలంలో ఒక బావి కనబడింది. దాని దగ్గర మూడు గొర్రెల మందలు పండుకుని ఉన్నాయి. కాపరులు తమ మందలకు ఆ బావి నీళ్ళు పెడతారు. ఒక పెద్ద రాయి ఆ బావి మీద మూత వేసి ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","అక్కడికి మందలన్నీ వచ్చి చేరినప్పుడు ఆ బావి మీద నుండి ఆ రాయిని తొలగించి, గొర్రెలకు నీళ్ళు పెట్టి తిరిగి బావి మీద రాయిని పెట్టేస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","యాకోబు వారిని చూసి “సోదరులారా, మీరెక్కడి వాళ్ళు?” అని అడగ్గా వారు “మేము హారాను వాళ్ళం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","అతడు “నాహోరు కుమారుడు లాబాను మీకు తెలుసా?” అని వారిని అడిగితే వారు “అవును, మాకు తెలుసు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“అతడు క్షేమంగా ఉన్నాడా?” అని అడిగినప్పుడు వారు “క్షేమంగానే ఉన్నాడు, అదిగో, అతని కూతురు రాహేలు గొర్రెల వెనకాలే వస్తున్నది” అని చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","అతడు “ఇదిగో, ఇంకా చాలా పొద్దు ఉంది, పశువులను సమకూర్చే వేళ కాలేదు, గొర్రెలకు నీళ్ళు పెట్టి, పోయి వాటిని మేపండి” అని చెప్పినప్పుడు, ");
INSERT INTO tel2017_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","వారు “మందలన్నిటినీ మళ్ళించే దాకా అది మా వల్ల కాదు. బావి మీద నుండి రాయిని దొర్లిస్తారు. అప్పుడే మేము గొర్రెలకు నీళ్ళు పెడతాం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","అతడు వారితో ఇంకా మాట్లాడుతూ ఉండగా రాహేలు తన తండ్రి గొర్రెల మందను తోలుకువచ్చింది. ఆమె వాటిని మేపుతున్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","యాకోబు తన మేనమామ అయిన లాబాను కూతురు రాహేలును, అతని గొర్రెలను చూసినప్పుడు, అతడు దగ్గరికి వెళ్ళి బావి మీద నుండి రాతిని దొర్లించి తన మేనమామ లాబాను గొర్రెలకు నీళ్ళు పెట్టాడు. యాకోబు రాహేలును ముద్దు పెట్టుకుని పెద్దగా ఏడ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","యాకోబు తాను ఆమె తండ్రి బంధువుననీ, ");
INSERT INTO tel2017_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","రిబ్కా కుమారుణ్ణి అని రాహేలుతో చెప్పినప్పుడు ఆమె పరుగెత్తి వెళ్లి తన తండ్రితో చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","లాబాను తన సోదరి కుమారుడు యాకోబు సమాచారం విన్నప్పుడు అతణ్ణి ఎదుర్కోడానికి పరుగెత్తుకుని వచ్చి అతని కౌగలించి ముద్దు పెట్టుకుని తన ఇంటికి తీసుకు వెళ్ళాడు. యాకోబు ఈ సంగతులన్నీ లాబానుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","అప్పుడు లాబాను “నిజంగా నువ్వు నా ఎముకవీ నా మాంసానివీ” అన్నాడు. యాకోబు నెల రోజులు అతని దగ్గర నివసించిన తరువాత, ");
INSERT INTO tel2017_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","లాబాను “నువ్వు నా బంధువ్వి కాబట్టి ఉచితంగా నాకు కొలువు చేస్తావా? నీకేం జీతం కావాలో చెప్పు” అని యాకోబును అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","లాబానుకు ఇద్దరు కుమార్తెలు ఉన్నారు. పెద్దదాని పేరు లేయా, చిన్నదాని పేరు రాహేలు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","లేయా కళ్ళలో కళాకాంతులు లేవు. రాహేలు ఆకర్షణీయంగా అందంగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","యాకోబు రాహేలును ప్రేమించి “నీ చిన్న కూతురు రాహేలు కోసం నీకు ఏడు సంవత్సరాలు సేవ చేస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","అందుకు లాబాను “ఆమెని పరాయివాడికి ఇవ్వడం కంటే నీకివ్వడం మేలు కదా, నా దగ్గర ఉండు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","యాకోబు రాహేలు కోసం ఏడు సంవత్సరాలు పని చేశాడు. అయినా అతడు ఆమెను ప్రేమించడం వలన అవి అతనికి చాలా తక్కువ రోజులుగా అనిపించాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","తరువాత యాకోబు “నా రోజులు పూర్తి అయ్యాయి కాబట్టి నేను నా భార్య దగ్గరికి పోతాను, ఆమెను నాకివ్వు” అని లాబానును అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","లాబాను ఆ స్థలంలో ఉన్న మనుషులందరినీ పోగుచేసి విందు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","రాత్రి వేళ తన పెద్ద కూతురు లేయాని అతని దగ్గరికి తీసుకు వెళ్ళాడు. యాకోబు ఆమెతో ఆ రాత్రి గడిపాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","లాబాను తన దాసి అయిన జిల్పాను తన కూతురు లేయాకు దాసిగా ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","తెల్లవారిన తరువాత యాకోబు ఆమె లేయా అని తెలుసుకుని లాబానుతో “నువ్వు నాకు చేసిందేమిటి? రాహేలు కోసమే గదా నేను నీకు సేవ చేసింది? ఎందుకు నన్ను మోసపుచ్చావు?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","అందుకు లాబాను “పెద్దదాని కంటే ముందుగా చిన్నదానికి పెళ్ళి చేయడం మా దేశమర్యాద కాదు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ముందు ఈమె ఏడు నిద్రలు పూర్తి చెయ్యి. నువ్వు ఇంకా ఏడు సంవత్సరాలు నాకు సేవ చేస్తానంటే, అందుకు ప్రతిఫలంగా రెండో ఆమెను కూడా నీకిస్తాం” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","యాకోబు ఆ విధంగా లేయా వారం సంపూర్తి చేసిన తరువాత లాబాను తన కూతురు రాహేలును కూడా అతనికి భార్యగా ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","లాబాను తన దాసి అయిన బిల్హాను తన కూతురు రాహేలుకు దాసిగా ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","యాకోబు రాహేలుతో రాత్రి గడిపాడు. అతడు లేయా కంటే రాహేలును ఎక్కువగా ప్రేమించి లాబానుకు మరి ఏడు సంవత్సరాలు సేవ చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","అతడు లేయాను ప్రేమించక పోవడం చూసి యెహోవా ఆమె గర్భం తెరిచాడు. రాహేలు గొడ్రాలుగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","లేయా గర్భవతి అయ్యి, కొడుకును కని “యెహోవా నా కష్టాన్నిచూశాడు కాబట్టి నా భర్త నన్ను ప్రేమిస్తాడు” అనుకుని అతనికి “రూబేను” అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ఆమె మళ్ళీ గర్భవతి అయ్యి, కొడుకును కని “నేను ప్రేమకు నోచుకోలేదనే సంగతి యెహోవా విన్నాడు కాబట్టి వీడిని కూడా నాకు దయచేశాడు” అనుకుని అతనికి “షిమ్యోను” అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ఆమె మళ్ళీ గర్భవతి అయ్యి, కొడుకుని కని “చివరికి నా పెనిమిటి నాతో హత్తుకుని ఉంటాడు. ఎందుకంటే అతనికి ముగ్గురు కొడుకులను కన్నాను” అనుకుని అతనికి “లేవి” అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ఆమె మళ్ళీ గర్భవతి అయ్యి కొడుకుని కని “ఈసారి యెహోవాను స్తుతిస్తాను” అనుకుని అతనికి “యూదా” అని పేరు పెట్టింది. తరువాత ఆమె కానుపులు ఆగిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","రాహేలు యాకోబు ద్వారా తనకు పిల్లలు కలగక పోవడం చూసి తన అక్క మీద అసూయపడింది. ఆమె యాకోబుతో “నాకు గర్భఫలమియ్యి. లేకపోతే నేను చచ్చిపోతాను” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","యాకోబు కోపం రాహేలు మీద రగులుకుంది. అతడు “నీకు గర్భఫలం ఇవ్వకుండా ఉన్న దేవుని స్థానంలో నేను ఉన్నానా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","అందుకు ఆమె “నా దాసి బిల్హా ఉంది గదా, ఆమెతో రాత్రి గడుపు. ఆమె నా కోసం పిల్లలను కంటుంది. ఆ విధంగా ఆమె వలన నాకు కూడా పిల్లలు కలుగుతారు” అని చెప్పి ");
INSERT INTO tel2017_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","తన దాసి బిల్హాను అతనికి భార్యగా ఇచ్చింది. యాకోబు ఆమెతో లైంగికంగా కలిశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","అప్పుడు బిల్హా గర్భవతి అయ్యి యాకోబుకు ఒక కొడుకుని కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","అప్పుడు రాహేలు “దేవుడు నాకు తీర్పు తీర్చాడు. ఆయన నా మొర విని నాకు కుమారుణ్ణి దయచేశాడు” అనుకుని అతనికి “దాను” అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","రాహేలు దాసి బిల్హా మళ్ళీ గర్భవతి అయ్యి యాకోబుకు రెండవ కొడుకుని కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","అప్పుడు రాహేలు “దేవుని కృప విషయంలో నా అక్కతో పోరాడి గెలిచాను” అనుకుని అతనికి నఫ్తాలి అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","లేయా తనకు కానుపు ఉడిగిపోవడం చూసి తన దాసి జిల్పాను యాకోబుకు భార్యగా ఇచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","జిల్పా యాకోబుకు కొడుకుని కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","అప్పుడు లేయా “ఇది అదృష్టమే గదా” అనుకుని అతనికి గాదు అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","లేయా దాసి జిల్పా యాకోబుకు రెండవ కొడుకుని కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","లేయా “నేను భాగ్యవంతురాలిని. స్త్రీలు నన్ను భాగ్యవతి అంటారు కదా” అని అతనికి ఆషేరు అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","గోదుమల కోతకాలంలో రూబేను వెళ్ళి పొలంలో మంత్రమూలిక వేర్లు చూసి తన తల్లి లేయాకు తెచ్చి ఇచ్చాడు. అప్పుడు రాహేలు “నీ కొడుకు తెచ్చిన మంత్రమూలికల్లో కొన్ని నాకు ఇవ్వు” అని లేయాతో అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","అందుకామె “నా భర్తను తీసుకున్నావు కదా, అది చాలదా? ఇప్పుడు నా కొడుకు తెచ్చిన మూలికలు కూడా తీసుకుంటావా” అంది. అందుకు రాహేలు “అలాగైతే నీ కొడుకు తెచ్చిన మూలికల నిమిత్తం నీ భర్త ఈ రాత్రి నీతో గడుపుతాడు” అని చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ఆ సాయంకాలం యాకోబు పొలం నుండి వచ్చేటప్పుడు లేయా అతనికి ఎదురు వెళ్లి “నువ్వు నా దగ్గరికి రావాలి. నా కొడుకు తెచ్చిన మంత్రమూలికలతో నిన్ను కొన్నాను” అని చెప్పింది. కాబట్టి అతడు ఆ రాత్రి ఆమెతో ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","దేవుడు లేయా మనవి విన్నాడు, ఆమె గర్భవతి అయ్యి యాకోబుకు అయిదవ కొడుకుని కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","లేయా “నా భర్తకు నా దాసిని ఇవ్వడం వలన దేవుడు నాకు ప్రతిఫలం దయచేశాడు” అనుకుని అతనికి “ఇశ్శాఖారు” అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","లేయా మళ్ళీ గర్భవతి అయ్యి యాకోబుకు ఆరవ కొడుకుని కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","అప్పుడు లేయా “దేవుడు నాకు మంచి బహుమతి దయచేశాడు. నా భర్తకు ఆరుగురు కొడుకులను కన్నాను. కాబట్టి అతడు ఇకపై నాతో కాపురం చేస్తాడు” అనుకుని అతనికి “జెబూలూను” అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ఆ తరువాత ఆమె ఒక కూతురిని కని ఆమెకు దీనా అనే పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","దేవుడు రాహేలును జ్ఞాపకం చేసుకుని, ఆమె మనవి విని ఆమె గర్భం తెరిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","అప్పుడామె గర్భవతి అయ్యి కొడుకును కని “దేవుడు నా నింద తొలగించాడు” అనుకుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ఇంకా ఆమె “యెహోవా నాకు ఇంకొక కొడుకుని ఇస్తాడు గాక” అనుకుని అతనికి “యోసేపు” అనే పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","రాహేలు యోసేపును కన్న తరువాత యాకోబు లాబానుతో “నన్ను పంపివెయ్యి. నా స్థలానికి, నా దేశానికి తిరిగి వెళ్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","నా భార్యలను, నా పిల్లలను నా కప్పగించు. నేను వెళ్ళిపోతాను, వారి కోసం నీకు సేవ చేశాను. నేను సేవ చేసిన విధానం నీకు తెలుసు కదా” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","అందుకు లాబాను అతనితో “నీ దయ నా మీద ఉంటే నా మాట విను. నిన్ను బట్టి యెహోవా నన్ను ఆశీర్వదించాడని నేను శకునం చూసి తెలుసుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","నీ జీతం ఇంత అని నాతో స్పష్టంగా చెప్పు, అది నీకు ఇస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","యాకోబు అతణ్ణి చూసి “నేను నీకేవిధంగా సేవ చేశానో, నీ మందలు నా దగ్గర ఎలా ఉండేవో అది నీకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","నేను రాకముందు నీకున్నది కొంచెమే, అయితే అది బాగా అభివృద్ధి పొందింది. నేను అడుగు పెట్టిన చోటెల్లా యెహోవా నిన్ను ఆశీర్వదించాడు. అయితే నేను నా స్వంత ఇంటివారి కోసం ఎప్పుడు సంపాదించుకుంటాను?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","అప్పుడు లాబాను “నేను నీకేమివ్వాలి?” అని అడిగాడు. అందుకు యాకోబు “నువ్వు నాకేమీ ఇయ్యవద్దు, నువ్వు నాకోసం నేను చెప్పిన విధంగా చేస్తే, నేను తిరిగి నీ మందను మేపుతూ వాటి బాగోగులు చూస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ఈ రోజు నేను నీ మంద అంతటిలో నడచి చూసి పొడలైనా మచ్చలైనా గల ప్రతి గొర్రెను గొర్రెపిల్లల్లో నల్లని ప్రతిదానినీ, మేకల్లో మచ్చలైనా, పొడలైనా గలవాటినీ వేరు చేస్తున్నాను. అలాటివన్నీ నాకు జీతమౌతాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ఇక ముందు నాకు రావలసిన జీతం గూర్చి నువ్వు చూడడానికి వచ్చినప్పుడు నా న్యాయ ప్రవర్తనే నాకు సాక్ష్యం అవుతుంది. మేకల్లో పొడలూ మచ్చలూ లేనివీ, గొర్రెపిల్లల్లో నల్లగా లేనివీ నా దగ్గర ఉంటే నేను దొంగిలించానని చెప్పవచ్చు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","అందుకు లాబాను “మంచిది, నీ మాట ప్రకారమే కానివ్వు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ఆ రోజు లాబాను చారలూ, మచ్చలూ ఉన్న మేకపోతులనూ, పొడలూ మచ్చలూ గల ఆడ మేకలనూ కొంచెం తెలుపు గల ప్రతిదానినీ గొర్రెపిల్లల్లో నల్లవాటినీ అన్నిటినీ వేరుచేసి తన కొడుకులకు అప్పగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","తనకూ యాకోబుకూ మధ్య మూడు రోజుల ప్రయాణమంత దూరం పెట్టాడు. లాబానుకు చెందిన మిగిలిన మందను యాకోబు మేపుతూ ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","యాకోబు గంగ రావి, బాదం, సాల చెట్ల చువ్వలు తీసుకు ఆ చువ్వల్లో తెల్లచారలు కనబడేలా అక్కడక్కడ వాటి తొక్కలు ఒలిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","మందలు నీళ్ళు తాగడానికి వచ్చినప్పుడు అవి చూలు కట్టడం కోసం అతడు తాను ఒలిచిన చువ్వలను మందలు తాగడానికి వచ్చే కాలవల్లో, నీటి గాళ్ళలో, వాటి ముందు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","అప్పుడు ఆ మందలు ఆ చువ్వల ముందు చూలు కట్టి చారలు, పొడలు, మచ్చలు గల పిల్లలను ఈనాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","యాకోబు ఆ గొర్రెపిల్లలను వేరుచేసి, చారలుగల వాటి వైపుకు, లాబాను మందల్లో నల్లని వాటి వైపుకు మందల ముఖాలు తిప్పి తన మందలను లాబాను మందలతో ఉంచకుండా వాటిని వేరుగా ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","మందలో బలమైనవి చూలు కట్టినప్పుడెల్లా అవి ఆ చువ్వల ముందు చూలు కట్టే విధంగా యాకోబు మందకు ఎదురుగా కాలవల్లో ఆ చువ్వలు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","మంద బలహీనమైనప్పుడు పెట్టలేదు. ఆ విధంగా బలహీనమైనవి లాబానుకూ బలమైనవి యాకోబుకూ వచ్చాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ఆ విధంగా ఆ మనిషి అత్యధికంగా అభివృద్ధి పొంది విస్తారమైన మందలు, దాసదాసీలు, ఒంటెలు, గాడిదలు గలవాడయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","లాబాను కొడుకులు “యాకోబు మన తండ్రికి ఉన్నదంతా తీసుకుని, దాని వలన ఈ ఆస్తి అంతా సంపాదించుకున్నాడు” అని చెప్పుకోవడం యాకోబు విన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","అంతే గాక అతడు లాబాను ముఖం చూసినప్పుడు అది తన విషయంలో ఇంతకు ముందులాగా ప్రసన్నంగా లేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","అప్పుడు యెహోవా “నీ పూర్వీకుల దేశానికి, నీ బంధువుల దగ్గరికి తిరిగి వెళ్ళు. నేను నీకు తోడై ఉంటాను” అని యాకోబుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","యాకోబు పొలంలో తన మంద దగ్గరికి రాహేలునీ లేయానీ పిలిపించి వారితో, ");
INSERT INTO tel2017_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“ఇంతకు ముందులాగా మీ నాన్న నేనంటే ఇష్టం చూపడం లేదని నాకు కనిపిస్తున్నది. అయితే నా తండ్రి దేవుడు నాకు తోడుగా ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","నేను మీ నాన్నకు నా శాయశక్తులా సేవ చేశానని మీకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","మీ నాన్న నన్ను మోసం చేసి పది సార్లు నా జీతం మార్చాడు. అయినా దేవుడు అతని మూలంగా నాకు నష్టం రానియ్యలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","అతడు, ‘పొడలు గలవి నీ జీతమవుతాయి’ అని చెప్పినప్పుడు మందలన్నీ పొడలు గల పిల్లలను ఈనాయి. ‘చారలు గలవి నీ జీతమవుతాయి’ అని చెప్పినప్పుడు అవి చారలు గల పిల్లలను ఈనాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ఆ విధంగా దేవుడు మీ నాన్న మందలను తీసి నాకిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","మందలు చూలు కట్టే కాలంలో నేను కలలో చూసినపుడు గొర్రెలతో జత కట్టే పొట్టేళ్ళు చారలు గానీ పొడలు గానీ మచ్చలు గానీ కలిగి ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ఆ కలలో దేవుని దూత ‘యాకోబూ’ అని నన్ను పిలిచినప్పుడు నేను ‘చిత్తం, ప్రభూ’ అన్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","అప్పుడు ఆయన ‘నీ కళ్ళు పైకెత్తి చూడు. గొర్రెలతో జంటకట్టే పొట్టేళ్ళన్నీ చారలు, పొడలు, మచ్చలు కలిగి ఉన్నాయి. ఎందుకంటే లాబాను నీకు చేస్తున్న దానంతటినీ నేను చూశాను. ");
INSERT INTO tel2017_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","నీవెక్కడ స్తంభం మీద నూనె పోశావో, ఎక్కడ నాకు మొక్కుబడి చేశావో, ఆ బేతేలు దేవుణ్ణి నేనే. ఇప్పుడు నువ్వు ఈ దేశం విడిచిపెట్టి నువ్వు పుట్టిన దేశానికి తిరిగి వెళ్ళు’ అని నాతో చెప్పాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","అందుకు రాహేలు, లేయాలు “ఇంకా మా నాన్న ఇంట్లో మాకు వంతు, వారసత్వం ఉన్నాయా? అతడు మమ్మల్ని పరాయివాళ్ళుగా చూడడం లేదా? ");
INSERT INTO tel2017_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","అతడు మమ్మల్ని అమ్మివేసి, మాకు రావలసిన సొమ్మంతటినీ పూర్తిగా తినేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","దేవుడు మా నాన్న దగ్గరనుండి తీసేసిన ధనమంతా మాదీ మా పిల్లలదీ కాదా? కాబట్టి దేవుడు నీతో ఏది చెబితే అది చెయ్యి” అని అతనికి జవాబు చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","యాకోబు తన కొడుకులనూ తన భార్యలనూ ఒంటెల మీద ఎక్కించి ");
INSERT INTO tel2017_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","తన తండ్రి ఇస్సాకు దగ్గరికి వెళ్ళడానికి తన పశువులన్నిటినీ, పద్దనరాములో తాను సంపాదించిన సంపద అంతటినీ తీసుకు కనాను దేశానికి బయలుదేరాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","లాబాను తన గొర్రెల బొచ్చు కత్తిరించడానికి వెళ్ళిన సమయంలో రాహేలు తన తండ్రి ఇంట్లో ఉన్న గృహ దేవుళ్ళను దొంగిలించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","యాకోబు తాను వెళ్ళిపోతున్నట్టు సిరియావాడైన లాబానుకు తెలియ పరచకపోవడం చేత అతణ్ణి మోసపుచ్చినట్టు అయ్యింది. ");
INSERT INTO tel2017_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","అతడు తనకు కలిగినదంతా తీసుకు పారిపోయాడు. అతడు నది దాటి గిలాదు కొండ ప్రాంతాల వైపు వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","యాకోబు పారిపోయాడని మూడో రోజుకి లాబానుకు తెలిసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","అతడు తన బంధువులను వెంటబెట్టుకుని, ఏడు రోజుల ప్రయాణమంత దూరం యాకోబును తరుముకుని వెళ్లి, గిలాదు కొండ మీద అతణ్ణి కలుసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ఆ రాత్రి కలలో దేవుడు లాబాను దగ్గరికి వచ్చి “నువ్వు యాకోబుతో మంచి గానీ చెడు గానీ పలకవద్దు. జాగ్రత్త సుమా” అని అతనితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","చివరికి లాబాను యాకోబును కలుసుకున్నాడు. యాకోబు తన గుడారాన్ని ఆ కొండ మీద వేసుకుని ఉన్నాడు. లాబాను కూడా తన బంధువులతో గిలాదు కొండమీద గుడారం వేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","అప్పుడు లాబాను యాకోబుతో “ఏంటి, ఇలా చేశావు? నన్ను మోసపుచ్చి, కత్తితో చెరపట్టిన వారిలాగా నా కూతుళ్ళను తీసుకుపోవడం ఎందుకు? ");
INSERT INTO tel2017_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","నాకు చెప్పకుండా రహస్యంగా పారిపోయి నన్ను మోసపుచ్చావేంటి? సంబరంగా, పాటలతో, కంజరిలతో, సితారాలతో నిన్ను సాగనంపి ఉండేవాడినే. ");
INSERT INTO tel2017_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","నేను నా మనవళ్ళనూ, కూతుళ్ళనూ ముద్దు పెట్టుకోనియ్యకుండా బుద్ధిహీనంగా ఇలా చేశావు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","నేను మీకు హాని చేయగలను. అయితే రాత్రి మీ తండ్రి దేవుడు, ‘జాగ్రత్త సుమా! నువ్వు యాకోబుతో మంచి గానీ చెడు గానీ పలకవద్దు’ అని నాతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","నీ తండ్రి ఇంటి మీద బెంగ కలిగి వెళ్ళిపోవాలనిపిస్తే వెళ్ళు, నా దేవుళ్ళను దొంగిలించావేంటి?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","అందుకు యాకోబు “నువ్వు బలవంతంగా నా నుండి నీ కుమార్తెలను తీసుకుంటావేమో అని భయపడ్డాను. ");
INSERT INTO tel2017_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ఎవరి దగ్గర నీ దేవుళ్ళు కనబడతాయో వారు బతకకూడదు. నువ్వు మన బంధువుల ముందు వెదికి చూసి నీది నా దగ్గర ఏదైనా ఉంటే దాన్ని తీసుకో” అని లాబానుతో చెప్పాడు. రాహేలు వాటిని దొంగిలించిందని యాకోబుకు తెలియలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","లాబాను యాకోబు గుడారంలోకీ లేయా గుడారంలోకీ ఇద్దరు దాసీల గుడారాల్లోకీ వెళ్ళాడు గాని అతనికేమీ దొరకలేదు. తరువాత అతడు లేయా గుడారంలో నుండి రాహేలు గుడారంలోకి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","రాహేలు ఆ విగ్రహాలను తీసి ఒంటె సామగ్రిలో పెట్టి వాటి మీద కూర్చుంది. లాబాను ఆ గుడారమంతా వెదికి చూసినా అవి దొరకలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ఆమె తన తండ్రితో “తమ ఎదుట నేను లేఛి నిలబడనందుకు తమరు కోపపడవద్దు. నేను నా నెలసరి కాలంలో ఉన్నాను” అని చెప్పింది. అతడెంత వెతికినా ఆ విగ్రహాలు దొరకలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","యాకోబు కోపంగా లాబానుతో వాదిస్తూ “నేనేం ద్రోహం చేశాను? నీవిలా మండిపడి నన్ను తరమడానికి నేను చేసిన పాపమేంటి? ");
INSERT INTO tel2017_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","నువ్వు నా సామానంతా తడివి చూశాక నీ ఇంటి వస్తువుల్లో ఏమైనా దొరికిందా? నావారి ముందూ, నీవారి ముందూ దాన్ని తెచ్చి పెట్టు. వారు మన ఇద్దరి మధ్య తీర్పు తీరుస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ఈ ఇరవై సంవత్సరాలూ నేను నీ దగ్గర ఉన్నాను. నీ గొర్రెలైనా మేకలైనా ఏవీ పిల్లలు కనకుండా పోలేదు, నీ మంద పొట్టేళ్ళను దేనినీ నేను తినలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","క్రూర జంతువులు చంపివేసిన దాన్ని నీ దగ్గరికి తీసుకురాకుండా ఆ నష్టం నేనే పెట్టుకున్నాను. పగలైనా, రాత్రైనా, ఇతరులు దొంగిలించిన వాటి విలువను నా దగ్గరే వసూలు చేశావు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","నేనెలా ఉన్నానో చూడు, పగలు ఎండకీ రాత్రి మంచుకూ క్షీణించిపోయాను. నా కళ్ళకి నిద్ర అనేదే లేకుండా పోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","నీ ఇద్దరు కూతుళ్ళకోసం పద్నాలుగు సంవత్సరాలూ నీ మంద కోసం ఆరు సంవత్సరాలూ మొత్తం ఇరవై సంవత్సరాలు నీకు సేవ చేస్తూ నీ ఇంట్లో ఉన్నాను. అయినా నువ్వు నా జీతం పదిసార్లు మార్చావు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","నా తండ్రి దేవుడు, అబ్రాహాము దేవుడు, ఇస్సాకు భయపడిన దేవుడు నాకు తోడై ఉండకపోతే నువ్వు నన్ను తప్పకుండా ఖాళీ చేతులతోనే వెళ్ళగొట్టి ఉండేవాడివి. దేవుడు నా ప్రయాసనీ నా చేతుల కష్టాన్నీ చూశాడు. అందుకే గత రాత్రి నిన్ను గద్దించాడు” అని అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","అందుకు లాబాను “ఈ కుమార్తెలు నా కుమార్తెలు, ఈ కుమారులు నా కుమారులు, ఈ మంద నా మంద, నీకు కనబడేదంతా నాదే. ఈ నా కుమార్తెలనైనా, వీరికి పుట్టిన కొడుకులనైనా నేనేం చేయగలను? ");
INSERT INTO tel2017_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","కాబట్టి నువ్వూ నేనూ ఒక నిబంధన చేసుకుందాం రా. అది నాకూ, నీకూ మధ్య సాక్షిగా ఉంటుంది” అని యాకోబుతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","అప్పుడు యాకోబు ఒక రాయి తీసి దాన్ని ఒక స్తంభంగా నిలబెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","“రాళ్ళు పోగుచేయండి” అని తన బంధువులతో చెప్పగానే వారు రాళ్ళు తెచ్చి కుప్పగా వేశారు. వారు ఆ కుప్ప దగ్గర భోజనం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","లాబాను దానికి “యగర్‌ శహదూతా” అని పేరు పెట్టాడు. కానీ యాకోబు దానికి “గలేదు” అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","లాబాను “ఈ రోజు ఈ కుప్ప నాకూ నీకూ మధ్య సాక్షిగా ఉంటుంది” అని చెప్పాడు. అందుకే దానికి గలేదు అనే పేరు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ఇంక “మనం ఒకరి కొకరం దూరంగా ఉన్నప్పటికీ యెహోవా నాకూ నీకూ మధ్య జరిగేది కనిపెడతాడు” అని చెప్పాడు కాబట్టి దానికి “మిస్పా” అని కూడా పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","తరువాత లాబాను “నువ్వు నా కుమార్తెలను బాధ పెట్టినా, నా కుమార్తెలను కాక ఇతర స్త్రీలను పెళ్ళి చేసుకున్నా, చూడు, మన దగ్గర ఎవరూ లేకపోయినా, నాకూ నీకూ మధ్య దేవుడే సాక్షి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","అదీ గాక లాబాను “నాకూ నీకూ మధ్య నేను నిలబెట్టిన ఈ స్తంభాన్నీ, ఈ రాళ్ళ కుప్పనీ చూడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","నీకు హాని చేయడానికి నేను ఈ కుప్పనీ, ఈ స్తంభాన్నీ దాటి నీ దగ్గరికి రాకుండా, నువ్వు నాకు హాని చేయడానికి ఈ కుప్పనీ, ఈ స్తంభాన్నీ దాటి నా దగ్గరికి రాకుండా ఉండడానికి ఈ కుప్ప, ఈ స్తంభమూ సాక్షి. ");
INSERT INTO tel2017_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","అబ్రాహాము దేవుడు, నాహోరు దేవుడు, వారి తండ్రి దేవుడు, మన మధ్య న్యాయం తీరుస్తాడు” అని చెప్పాడు. అప్పుడు యాకోబు తన తండ్రి ఇస్సాకు భయపడిన దేవుని తోడు అని ప్రమాణం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","యాకోబు ఆ కొండ మీద బలి అర్పించి భోజనం చేయడానికి తన బంధువులను పిలిచినప్పుడు వారు భోజనం చేసి కొండ మీద ఆ రాత్రి గడిపారు. ");
INSERT INTO tel2017_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","తెల్లవారినప్పుడు లాబాను తన మనుమలనూ తన కుమార్తెలనూ ముద్దు పెట్టుకుని వారిని దీవించి బయలుదేరి తన ఊరికి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","యాకోబు తన దారిలో వెళ్తూ ఉండగా దేవదూతలు అతనికి ఎదురయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","యాకోబు వారిని చూసి “ఇది దేవుని సేన” అని చెప్పి ఆ చోటికి మహనయీము అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","యాకోబు ఎదోము ప్రాంతంలో, అంటే శేయీరు దేశంలో ఉన్న తన సోదరుడు ఏశావు దగ్గరికి తనకు ముందుగా దూతలను పంపి, ");
INSERT INTO tel2017_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","“మీరు నా ప్రభువైన ఏశావుతో, ‘ఇంతవరకూ నేను లాబాను దగ్గర నివసించాను. ");
INSERT INTO tel2017_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","నాకు పశువులూ గాడిదలూ మందలూ దాసదాసీజనమూ ఉన్నారు. నీ అనుగ్రహం నాపైనఉండాలని నా ప్రభువుకు తెలపడానికి పంపాను అని నీ సేవకుడైన యాకోబు అన్నాడు’ అని చెప్పండి” అని వారికి ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ఆ దూతలు యాకోబు దగ్గరికి తిరిగివచ్చి “మేము నీ సోదరుడైన ఏశావు దగ్గరికి వెళ్ళాం, అతడు నాలుగు వందల మందితో నీకు ఎదురు వస్తున్నాడు” అని చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","అప్పుడు యాకోబు చాలా భయపడి, హతాశుడై, ");
INSERT INTO tel2017_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“ఏశావు ఒక గుంపు మీదికి వచ్చి దాన్ని హతం చేస్తే మిగిలిన గుంపు తప్పించుకుని పోవచ్చు” అనుకుని, తనతో ఉన్న ప్రజలనూ మందలనూ పశువులనూ ఒంటెలనూ రెండు గుంపులు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","అప్పుడు యాకోబు “నా తండ్రి అబ్రాహాము దేవా, నా తండ్రి ఇస్సాకు దేవా, ‘నీ దేశానికీ, నీ బంధువుల దగ్గరికీ తిరిగి వెళ్ళు, నీకు మేలు చేస్తాను’ అని నాతో చెప్పిన యెహోవా, ");
INSERT INTO tel2017_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","నువ్వు నీ సేవకుడికి చేసిన ఉపకారాలన్నిటికీ నమ్మకత్వమంతటికీ నేను పాత్రుణ్ణి కాను. ఎందుకంటే, కేవలం ఈ నా చేతి కర్రతో ఈ యొర్దాను దాటాను. ఇప్పుడు నేను రెండు గుంపులయ్యాను. ");
INSERT INTO tel2017_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","నా సోదరుడు ఏశావు చేతి నుండి దయచేసి నన్ను తప్పించు. అతడు వచ్చి పిల్లలనీ వారి తల్లులనూ నన్నూ చంపుతాడేమో అని భయపడుతున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","నాతో, ‘నేను నీకు తోడై తప్పకుండా మేలు చేస్తూ వారి సంఖ్యను బట్టి లెక్కించలేని సముద్రపు ఇసకలాగా నీ సంతానాన్ని విస్తరింపజేస్తాను’ అని నువ్వు సెలవిచ్చావు కదా” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","అతడు అక్కడ ఆ రాత్రి గడిపి తాను సంపాదించిన దానిలో తన అన్న ఏశావు కోసం ఒక కానుకను సిద్ధం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","అతడు రెండువందల మేకలూ ఇరవై మేక పోతులూ రెండువందల గొర్రెలూ ఇరవై పొట్టేళ్ళూ ");
INSERT INTO tel2017_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ముప్ఫై పాడి ఒంటెలూ వాటి పిల్లలూ నలభై ఆవులూ పది ఆబోతులూ ఇరవై ఆడ గాడిదలూ పది గాడిద పిల్లలూ తీసుకు మందమందను వేరు వేరుగా ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","వాటిని అతడు తన దాసులకు అప్పగించి “మీరు మంద మందకు మధ్య ఖాళీ ఉంచి నాకంటే ముందుగా నడవండి” అని వారితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","వారిలో మొదటివాడితో “నా సోదరుడు ఏశావు నీకు ఎదురుగా వచ్చి, ‘నీవెవరి వాడివి? ఎక్కడికి వెళ్తున్నావు? నీ ముందు ఉన్నవి ఎవరివి?’ అని నిన్ను అడిగితే ");
INSERT INTO tel2017_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","నువ్వు, ‘ఇవి నీ సేవకుడైన యాకోబువి, ఇది నా ప్రభువైన ఏశావు కోసం అతడు పంపిన కానుక. అదిగో అతడు మా వెనక వస్తున్నాడు’ అని చెప్పు” అని ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","“నేను ముందుగా పంపుతున్న కానుకల వలన అతనిని శాంతింపజేసిన తరువాత నేను అతనికి కనబడతాను. అప్పుడతడు ఒకవేళ నా పైన దయ చూపుతాడేమో. ");
INSERT INTO tel2017_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","కాబట్టి మీరు ఏశావును చూసి, ‘ఇదిగో నీ సేవకుడైన యాకోబు మా వెనకాలే వస్తున్నాడు’ అని చెప్పాలి” అని వారికి చెప్పాడు. రెండవ గుంపుకు, మూడవ గుంపుకు, మందల వెంబడి వెళ్ళిన వారికందరికీ అతడు ఇదే విధంగా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","అతడు ఆ కానుకను తనకు ముందుగా పంపి తాను గుంపులో ఆ రాత్రి నిలిచిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ఆ రాత్రి అతడు లేచి తన ఇద్దరు భార్యలనూ తన ఇద్దరు దాసీలనీ తన పదకొండు మంది పిల్లలనూ తీసుకు యబ్బోకు రేవు దాటిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","యాకోబు వారిని ఆ యేరు దాటించి తనకు కలిగిందంతా వారితో పంపేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","యాకోబు ఒక్కడు మిగిలి పోయాడు. ఒక మనిషి తెల్లవారేదాకా అతనితో పెనుగులాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","తాను గెలవకపోవడం చూసి అతడు యాకోబు తొడ గూటి మీద కొట్టాడు. అప్పుడు ఆయనతో పెనుగులాడ్డం వలన యాకోబు తొడ గూడు జారిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ఆయన “తెల్లవారుతున్నది, నన్ను పోనియ్యి” అన్నప్పుడు, యాకోబు “నువ్వు నన్ను ఆశీర్వదిస్తేనే గాని నిన్ను పోనియ్యను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ఆయన “నీ పేరేమిటి?” అని అడిగాడు. అతడు “యాకోబు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","అప్పుడాయన “నువ్వు దేవునితో, మనుషులతో పోరాడి గెలిచావు. కాబట్టి ఇక ముందు నీ పేరు ఇశ్రాయేలు, యాకోబు కాదు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","అప్పుడు యాకోబు “దయచేసి నీ పేరు చెప్పు” అన్నాడు. అందుకాయన “నా పేరు ఎందుకు అడుగుతావు?” అని చెప్పి అక్కడ అతణ్ణి ఆశీర్వదించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","యాకోబు “నేను ముఖాముఖిగా దేవుణ్ణి చూశాను. అయినా నా ప్రాణం నిలిచింది” అని ఆ స్థలానికి “పెనూయేలు” అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","అతడు పెనూయేలు నుండి బయలుదేరి నప్పుడు సూర్యోదయం అయ్యింది. అతడు తొడ కుంటుతూ నడిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ఆయన యాకోబు తొడగూటి మీది తుంటినరంపై కొట్టి గూడు వసిలేలా చేసాడు కాబట్టి ఈనాటి వరకూ ఇశ్రాయేలీయులు తొడ గూటి మీద ఉన్న తుంటినరాన్ని తినరు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","యాకోబు కళ్ళెత్తి చూసినప్పుడు ఏశావు, అతనితో నాలుగువందల మంది మనుషులు వస్తూ ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","అప్పుడు అతడు తన పిల్లలను లేయా, రాహేలులకు, ఇద్దరు దాసీలకు అప్పగించాడు. అతడు ముందు దాసీలనూ వారి పిల్లలనూ, వారి వెనక లేయానూ ఆమె పిల్లలనూ, ఆ వెనక రాహేలునూ యోసేపునూ ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","తాను వారి ముందు వెళ్తూ తన సోదరుణ్ణి సమీపించే వరకూ ఏడు సార్లు నేలపై సాగిలపడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","అప్పుడు ఏశావు అతనిని ఎదుర్కోడానికి పరుగెత్తి అతనిని కౌగలించుకుని అతని మెడను కౌగలించుకుని ముద్దు పెట్టుకున్నాడు. వారిద్దరూ కన్నీళ్ళు పెట్టుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ఏశావు ఆ స్త్రీలనూ పిల్లలనూ చూసి “వీరు నీకేమౌతారు?” అని అడిగాడు. అతడు “వీరు దేవుడు నీ సేవకునికి దయచేసిన పిల్లలే” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","అప్పుడు ఆ దాసీలూ వారి పిల్లలూ దగ్గరికి వచ్చి ఏశావు ఎదుట సాగిలపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","లేయా ఆమె పిల్లలూ దగ్గరికి వచ్చి సాగిలపడ్డారు. ఆ తరువాత యోసేపూ రాహేలు దగ్గరికి వచ్చి సాష్టాంగ నమస్కారం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ఏశావు “నాకు ఎదురుగా వచ్చిన ఆ గుంపంతా ఎందుకు?” అని అడిగాడు. అతడు “నా ప్రభువు దయ నా మీద కలగడానికే” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","అప్పుడు ఏశావు “తమ్ముడూ, నాకు కావలసినంత ఉంది, నీది నీవే ఉంచుకో” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","అప్పుడు యాకోబు “అలా కాదు, నీ అనుగ్రహం నా మీద ఉంటే దయచేసి ఈ కానుకను అంగీకరించు. దేవుని ముఖం చూసినట్టుగా నీ ముఖం చూశాను. నీ దయ నా మీద ఉంది కదా. ");
INSERT INTO tel2017_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","నేను నీ కోసం తెచ్చిన కానుకను దయచేసి అంగీకరించు. దేవుడు నన్ను కనికరించాడు. పైగా, నాకు కావలసినంత ఉంది” అని చెప్పి అతన్ని బలవంతం చేశాడు కాబట్టి అతడు దాన్ని పుచ్చుకుని ");
INSERT INTO tel2017_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“మనం వెళదాం, నేను నీకు ముందుగా సాగిపోతాను” అని చెప్పగా ");
INSERT INTO tel2017_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","అతడు “నాదగ్గర ఉన్న పిల్లలు పసిపిల్లలనీ, గొర్రెలు, మేకలు, పశువులు పాలిచ్చేవి అని నా ప్రభువుకు తెలుసు. ఒక్క రోజే వాటిని వేగంగా తోలితే ఈ మంద అంతా చస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","నా ప్రభువు దయచేసి తన దాసునికి ముందుగా వెళ్ళాలి. నేను నా ప్రభువు దగ్గరికి శేయీరుకు వచ్చేవరకూ, ముందున్న మందలూ, ఈ పిల్లలూ నడవగలిగిన కొలదీ వాటిని మెల్లగా నడిపించుకుంటూ వస్తాను” అని అతనితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","అప్పుడు ఏశావు “నీ కిష్టమైతే నా దగ్గర ఉన్న ఈ మనుషుల్లో కొందరిని నీ దగ్గర విడిచిపెడతాను” అనగా అతడు “అదెందుకు? నా ప్రభువు కటాక్షం నా మీద ఉంది. అది చాలు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ఆ రోజునే ఏశావు తన దారిలో శేయీరుకు తిరిగి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","అప్పుడు యాకోబు సుక్కోతుకు ప్రయాణమై వెళ్లి తమకొక ఇల్లు కట్టించుకుని తన పశువులకు పాకలు వేయించాడు. అందుకు ఆ చోటికి “సుక్కోతు” అనే పేరు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ఆ విధంగా యాకోబు పద్దనరాములో నుండి వచ్చిన తరువాత కనాను దేశంలో ఉన్న షెకెము అనే ఊరికి సురక్షితంగా వచ్చి ఆ ఊరి ముందు తన గుడారాలు వేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","అతడు గుడారాలు వేసిన పొలంలోని భాగాన్ని షెకెము తండ్రి అయిన హమోరు కుమారుల దగ్గర నూరు వెండి నాణాలకు కొన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","అక్కడ ఒక బలిపీఠం కట్టించి దానికి “ఏల్‌ ఎలోహేయి ఇశ్రాయేలు” అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","యాకోబుకు లేయా ద్వారా పుట్టిన కూతురు దీనా. ఆమె ఆ దేశపు యువతులను చూడడానికి బయటికి వెళ్ళింది. ");
INSERT INTO tel2017_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ఆ దేశపు రాజు, హివ్వీయుడైన హమోరు కుమారుడు షెకెము ఆమెను చూసి ఆమెను పట్టుకుని, బలాత్కారం చేసి చెరిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","అయితే అతడు ఆమెపై మనసు పడ్డాడు. ఆమెని ప్రేమించి ఆమెతో ఇష్టంగా మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","షెకెము తన తండ్రి హమోరును “ఈ అమ్మాయిని నాకిచ్చి పెళ్ళి చెయ్యి” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","అతడు తన కూతురిని చెరిచిన సంగతి యాకోబు విన్నాడు. తన కుమారులు పశువులతో పొలంలో ఉండడం వలన వారు వచ్చే వరకూ నెమ్మదిగా ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","షెకెము తండ్రి హమోరు యాకోబుతో మాట్లాడడానికి అతని దగ్గరికి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","యాకోబు కుమారులు ఆ సంగతి విని పొలం నుండి తిరిగి వచ్చారు. అతడు యాకోబు కూతురును మానభంగం చేసి ఇశ్రాయేలు ప్రజలను కించపరిచాడు. అది చేయకూడని పని కాబట్టి అది వారికి చాలా అవమానకరంగా ఉంది. వారికి చాలా కోపం వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","అప్పుడు హమోరు వారితో “షెకెము అనే నా కొడుకు మీ కూతురిపై మనసు పడ్డాడు. దయచేసి ఆమెను అతనికిచ్చి పెళ్ళి చేయండి. ");
INSERT INTO tel2017_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","మీ పిల్లలను మాకిచ్చి మా పిల్లలను మీరు పుచ్చుకుని మాతో వియ్యం కలుపుకుని మా మధ్య నివసించండి. ");
INSERT INTO tel2017_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ఈ దేశం మీ ఎదుట ఉంది. మీరు ఇందులో నివసించి వ్యాపారాలు చేసి ఆస్తి సంపాదించుకోండి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","అతడింకా “నామీద దయ చూపండి. మీరేమి అడుగుతారో దాన్ని నేనిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ఓలి గానీ, కట్నం గానీ ఎంతైనా అడగండి. మీరు అడిగినంతా ఇస్తాను. ఆ యువతిని మాత్రం నాకు ఇవ్వండి” అని ఆమె తండ్రితో, సోదరులతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","అయితే తమ సోదరి అయిన దీనాను అతడు చెరిచినందుకు యాకోబు కుమారులు షెకెముతో, అతని తండ్రి హమోరుతో కపటంగా జవాబిచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","వారు “మేము ఈ పనికి అంగీకరించలేం. సున్నతి చేయించుకోని వాడికి మా సోదరిని ఇయ్యలేము. ఎందుకంటే అది మాకు అవమానకరం. ");
INSERT INTO tel2017_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","అయితే మీలో ప్రతి పురుషుడు సున్నతి పొంది మాలాగా ఉండే పక్షంలో మాత్రమే మేము దీనికి అంగీకరించగలం. ");
INSERT INTO tel2017_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ఆ ఒక్క షరతుతో మీ మాటకు ఒప్పుకుని, మా పిల్లలను మీ కిచ్చి మీ పిల్లలను మేము చేసుకుని, మీ మధ్య నివసిస్తాం. అప్పుడు మనమంతా ఒకే జనంగా ఉంటాం. ");
INSERT INTO tel2017_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","మీరు మా మాట విని సున్నతి పొందకపోతే మా అమ్మాయిని తీసుకు వెళ్ళిపోతాం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","వారి మాటలు హమోరుకూ అతని కుమారుడు షెకెముకూ ఇష్టంగా ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ఆ యువకుడికి యాకోబు కూతురు అంటే ప్రేమ కాబట్టి అతడు ఆ పని చేయడానికి ఆలస్యం చేయలేదు. అతడు తన వంశం వారందరిలో పేరు పొందినవాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","హమోరూ అతని కుమారుడు షెకెమూ ఆ ఊరి ద్వారం దగ్గరికి వచ్చి తమ ఊరి ప్రజలతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ఈ మనుషులు మనతో సమాధానంగా ఉన్నారు కాబట్టి వారిని మన దేశంలో ఉండనిచ్చి దీనిలో వ్యాపారం చేసుకోనిద్దాం. ఈ భూమి వారికి కూడా చాలినంత విశాలంగా ఉంది కదా, మనం వారి పిల్లలను చేసుకుని మన పిల్లలను వారికి ఇద్దాం. ");
INSERT INTO tel2017_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","అయితే ఒక విషయం, ఆ మనుషులు సున్నతి పొందినట్టుగానే మనలో ప్రతి పురుషుడు సున్నతి పొందితేనే వారు మన మాటకు ఒప్పుకుని మనలో నివసించి ఒకే జనంగా కలిసి ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","వారి మందలూ వారి ఆస్తీ వారి పశువులూ అన్నీ మనవవుతాయి కదా. ఎలాగైనా మనం వారి షరతుకు ఒప్పుకుందాం. అప్పుడు వారు మనలో నివసిస్తారు.” ");
INSERT INTO tel2017_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","హమోరు, అతని కుమారుడు షెకెము చెప్పిన మాటలు ఆ ఊరి ద్వారం గుండా వెళ్ళేవారంతా విన్నారు. అప్పుడు ఆ ద్వారం గుండా వెళ్ళే వారిలో ప్రతి పురుషుడు సున్నతి పొందాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","మూడో రోజు వారంతా బాధపడుతూ ఉన్నప్పుడు యాకోబు కుమారుల్లో ఇద్దరు, అంటే దీనా సోదరులైన షిమ్యోను, లేవి, వారి కత్తులు తీసుకు అకస్మాత్తుగా ఆ ఊరిమీద పడి ప్రతి మగ వాణ్నీ చంపేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","వారు హమోరునీ అతని కొడుకు షెకెమునీ కత్తితో చంపి షెకెము ఇంట్లో నుండి దీనాను తీసుకెళ్ళిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","తక్కిన యాకోబు కొడుకులు తమ సోదరిని చెరిపినందుకు చనిపోయిన వారు పడి ఉన్నచోటికి వచ్చి ఆ ఊరిపై పడి దోచుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","వారి గొర్రెలనూ పశువులనూ గాడిదలనూ ఊరిలో గానీ పొలంలో గానీ ");
INSERT INTO tel2017_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","వారి ఆస్తి అంతా తీసుకు, వారి పిల్లలనూ స్త్రీలనూ చెరపట్టి, వారి ఇళ్ళలో ఉన్న వస్తువులు సైతం దోచుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","అప్పుడు యాకోబు షిమ్యోనునూ లేవినీ పిలిచి “మీరు ఈ దేశంలో నివసించే కనానీయులూ పెరిజ్జీయులూ నన్ను అసహ్యించుకొనేలా చేశారు. నా ప్రజల సంఖ్య తక్కువే. వారు నా మీదికి గుంపుగా వచ్చి నన్ను చంపుతారు. నేను, నా ఇంటివారు నాశనమవుతాం” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","అందుకు వారు “మరి వేశ్య పట్ల చేసినట్టు మా చెల్లి పట్ల చేయవచ్చా?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","దేవుడు యాకోబుతో “నువ్వు లేచి బేతేలుకు వెళ్ళి అక్కడ నివసించు. నీ సోదరుడైన ఏశావు నుండి నువ్వు పారిపోయినప్పుడు నీకు కనబడిన దేవునికి అక్కడ ఒక బలిపీఠం కట్టు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","యాకోబు తన ఇంటివారితో, తన దగ్గర ఉన్న వారందరితో “మీ దగ్గర ఉన్న అన్యదేవుళ్ళను పారవేసి, మిమ్మల్ని మీరు పవిత్ర పరచుకుని, మీ వస్త్రాలు మార్చుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","మనం బేతేలుకు బయలుదేరి వెళ్దాం. నా కష్ట సమయంలో నాకు సహాయం చేసి, నేను వెళ్ళిన అన్ని చోట్లా నాకు తోడై ఉన్న దేవునికి అక్కడ ఒక బలిపీఠం కడతాను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","వారు తమ దగ్గర ఉన్న అన్యదేవుళ్ళన్నిటినీ తమ చెవి పోగులనూ యాకోబుకు అప్పగించారు. యాకోబు వాటిని షెకెము దగ్గర ఉన్న సింధూర వృక్షం కింద పాతిపెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","వారు ప్రయాణమై వెళ్తూ ఉన్నప్పుడు, వారి చుట్టూ ఉన్న పట్టణాల వారికి దేవుడు భయం పుట్టించాడు కాబట్టి వారు యాకోబు కుటుంబాన్ని తరమ లేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","యాకోబు, అతడితో ఉన్నవారంతా కనానులో లూజుకు, అంటే బేతేలుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","అతడు తన అన్న దగ్గర నుండి పారిపోయినప్పుడు దేవుడక్కడ అతడికి ప్రత్యక్షమయ్యాడు కాబట్టి వారు అక్కడ ఒక బలిపీఠం కట్టి ఆ ప్రదేశానికి ఏల్‌ బేతేలు అని పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","రిబ్కా దాది దెబోరా చనిపోయినప్పుడు ఆమెను బేతేలుకు దిగువన ఉన్న సింధూర వృక్షం కింద పాతిపెట్టి, దానికి అల్లోన్ బాకూత్‌ అనే పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","యాకోబు పద్దనరాము నుండి వస్తూ ఉండగా దేవుడు అతడికి మళ్ళీ ప్రత్యక్షమై అతణ్ణి ఆశీర్వదించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","అప్పుడు దేవుడు అతనితో “నీ పేరు యాకోబు. కానీ ఇప్పటినుండి అది యాకోబు కాదు, నీ పేరు ఇశ్రాయేలు” అని చెప్పి అతనికి ఇశ్రాయేలు అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","దేవుడు “నేను సర్వశక్తిగల దేవుణ్ణి. నువ్వు ఫలించి అభివృద్ధి పొందు. ఒక జనాంగం, జాతుల గుంపు నీనుండి కలుగుతాయి. రాజులు నీ సంతానంలో నుండి వస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","నేను అబ్రాహాముకు, ఇస్సాకుకు ఇచ్చిన దేశాన్ని నీకిస్తాను. నీ తరువాత నీ సంతానానికి కూడా ఈ దేశాన్ని ఇస్తాను” అని అతనితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","దేవుడు అతనితో మాట్లాడిన ఆ స్థలం నుండి పరలోకానికి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","దేవుడు తనతో మాట్లాడిన చోట యాకోబు ఒక స్తంభం, అంటే ఒక రాతి స్తంభం నిలబెట్టి దాని మీద పానార్పణం చేసి దాని మీద నూనె పోశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","తనతో దేవుడు మాట్లాడిన చోటికి యాకోబు బేతేలు అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","వారు బేతేలు నుండి ప్రయాణమై వెళ్ళారు. దారిలో ఎఫ్రాతాకు ఇంకా కొంత దూరం ఉన్నప్పుడు రాహేలుకు కానుపు నొప్పులు మొదలయ్యాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ఆమె ప్రసవం వలన తీవ్రంగా ప్రయాసపడుతూ ఉండగా మంత్రసాని ఆమెతో “భయపడ వద్దు, ఈ సారి కూడా నీకు కొడుకే పుడతాడు” అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","రాహేలు కొడుకును ప్రసవించి చనిపోయింది. ప్రాణం పోతూ ఉన్న సమయంలో ఆమె “వీడి పేరు బెనోని” అంది. కాని అతని తండ్రి అతనికి బెన్యామీను అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ఆ విధంగా రాహేలు చనిపోయినప్పుడు ఆమెను బేత్లెహేము అని పిలిచే ఎఫ్రాతా మార్గంలో సమాధి చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","యాకోబు ఆమె సమాధి మీద ఒక స్తంభాన్ని నిలిపాడు. అది ఈ రోజు వరకూ రాహేలు సమాధి స్తంభంగా నిలిచి ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ఇశ్రాయేలు ప్రయాణం కొనసాగించి మిగ్దల్‌ ఏదెరుకు అవతల తన గుడారం వేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ఇశ్రాయేలు ఆ దేశంలో నివసిస్తున్నప్పుడు రూబేను తన తండ్రి ఉపపత్ని అయిన బిల్హాతో లైంగిక సంబంధం పెట్టుకున్నాడు. ఆ సంగతి ఇశ్రాయేలుకు తెలిసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","యాకోబు కొడుకులు పన్నెండు మంది. యాకోబు జ్యేష్ఠకుమారుడు రూబేను, షిమ్యోను, లేవి, యూదా, ఇశ్శాఖారు, జెబూలూను. వీరు లేయా కొడుకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","యోసేపు, బెన్యామీను. వీరు రాహేలు కొడుకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","రాహేలు దాసి అయిన బిల్హా కొడుకులు దాను, నఫ్తాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","లేయా దాసి అయిన జిల్పా కొడుకులు గాదు, ఆషేరు. వీరంతా పద్దనరాములో యాకోబుకు పుట్టిన కొడుకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","అబ్రాహాము, ఇస్సాకులు నివసించిన మమ్రేలోని కిర్యతర్బాలో తన తండ్రి ఇస్సాకు దగ్గరికి యాకోబు వచ్చాడు. అదే హెబ్రోను. ");
INSERT INTO tel2017_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ఇస్సాకు నూట ఎనభై సంవత్సరాలు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ఇస్సాకు కాలం నిండిన వృద్ధుడై చనిపోయి తన పూర్వికుల దగ్గరికి చేరిపోయాడు. అతని కొడుకులు ఏశావు, యాకోబు అతణ్ణి సమాధి చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ఎదోము అనే మారు పేరు గల ఏశావు వంశావళి ఇది. ");
INSERT INTO tel2017_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ఏశావు హిత్తీయుడైన ఏలోను కూతురు ఆదా, హివ్వీయుడైన సిబ్యోను కూతురైన అనా కూతురు అహోలీబామా, ");
INSERT INTO tel2017_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ఇష్మాయేలు కూతురు, నెబాయోతు సోదరి అయిన బాశెమతు అనే కనాను యువతులను పెళ్ళి చేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ఏశావుకు ఆదా ఎలీఫజును, బాశెమతు రగూయేలును కన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","అహోలీబామా యూషును, యాలామును, కోరహును కన్నది. వీరు కనాను దేశంలో ఏశావుకు పుట్టిన కొడుకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ఏశావు తన భార్యలనూ కుమారులనూ కూతుళ్ళనూ తన ఇంటివారందరినీ తన మందలనూ పశువులనూ తాను కనాను దేశంలో సంపాదించిన ఆస్తి అంతటినీ తీసుకుని తన తమ్ముడైన యాకోబు నుండి దూరంగా మరొక దేశానికి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","వారు విస్తారమైన సంపద గలవారు కాబట్టి వారు కలిసి నివసించలేక పోయారు. వారి పశువులు అధికంగా ఉండడం వలన వారు నివసించే స్థలం వారిద్దరికీ సరిపోలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","కాబట్టి ఏశావు శేయీరు కొండ ప్రాంతంలో నివసించాడు. ఏశావుకు మరొక పేరు ఎదోము. ");
INSERT INTO tel2017_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","శేయీరు కొండ ప్రాంతంలో నివసించిన ఎదోమీయుల మూల పురుషుడైన ఏశావు వంశావళి ఇది. ");
INSERT INTO tel2017_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ఏశావు కొడుకుల పేర్లు, ఏశావు భార్య ఆదా కొడుకు ఎలీఫజు, మరొక భార్య బాశెమతు కొడుకు రగూయేలు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ఎలీఫజు కొడుకులు తేమాను, ఓమారు, సెపో, గాతాము, కనజు. ఎలీఫజు ఉపపత్ని తిమ్నా. ");
INSERT INTO tel2017_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ఆమె కొడుకు అమాలేకు. వీరంతా ఏశావు భార్య అయిన ఆదాకు మనుమలు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","రగూయేలు కొడుకులు నహతు, జెరహు, షమ్మా, మిజ్జా. వీరు ఏశావు భార్య అయిన బాశెమతుకు మనుమలు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ఏశావుకున్న మరొక భార్య సిబ్యోను కూతురు అయిన అనా కూతురు అహొలీబామా. ఈమె ఏశావుకు కన్న కొడుకులు యూషు, యాలాము, కోరహు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ఏశావు కొడుకుల్లో తెగల నాయకులు ఎవరంటే, ఏశావు మొదటి సంతానమైన ఎలీఫజు కొడుకులు తేమాను, ఓమారు, సెపో, కనజు, ");
INSERT INTO tel2017_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","కోరహు, గాతాము, అమాలేకు. వీరు ఎదోము దేశంలో ఎలీఫజు నుండి వచ్చిన నాయకులు. వీరు ఏశావు భార్య ఆదాకు మనుమలు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ఏశావు కొడుకైన రగూయేలు కొడుకులు నహతు, జెరహు, షమ్మా, మిజ్జా. వీరు ఎదోము దేశంలో రగూయేలు నుండి వచ్చిన నాయకులు. వీరు ఏశావు భార్య బాశెమతు మనుమలు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ఇక ఏశావు భార్య, అనా కూతురు అయిన అహొలీబామా కొడుకులు యూషు, యగ్లాము, కోరహు. వీరు అహొలీబామా పుత్రసంతానపు నాయకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","వీరంతా ఎదోము అనే ఏశావు కొడుకులు, వారి వారి సంతానపు తెగల నాయకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ఎదోము దేశంలో ఆదినుండీ నివసించిన హోరీయుడైన శేయీరు కొడుకులు లోతాను, శోబాలు, సిబ్యోను, అనా, ");
INSERT INTO tel2017_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","దిషోను, ఏసెరు, దీషాను. వీరు ఎదోము దేశంలోని శేయీరు కొడుకులైన హోరీయుల నాయకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","లోతాను కొడుకులు హోరీ, హేమాను. లోతాను సోదరి తిమ్నా. ");
INSERT INTO tel2017_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","శోబాలు కొడుకులు అల్వాను, మానహదు, ఏబాలు, షపో, ఓనాము. ");
INSERT INTO tel2017_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","సిబ్యోను కొడుకులు అయ్యా, అనా అనేవారు. ఈ అనా తన తండ్రి సిబ్యోనుకు చెందిన గాడిదలను మేపుతూ ఉండగా మొదటి సారిగా అరణ్యంలో ఉష్ణధారలు కనుగొన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","అనా కొడుకు దిషోను, కూతురు అహొలీబామా. ");
INSERT INTO tel2017_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","దిషోను కొడుకులు హెమ్దాను, ఎష్బాను, ఇత్రాను, కెరాను, ");
INSERT INTO tel2017_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ఏసెరు కొడుకులు బిల్హాను, జవాను, అకాను. ");
INSERT INTO tel2017_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","దీషాను కొడుకులు ఊజు, అరాను. ");
INSERT INTO tel2017_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","హోరీయుల నాయకులు ఎవరంటే, లోతాను, శోబాలు, సిబ్యోను, అనా, ");
INSERT INTO tel2017_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","దిషోను, ఏసెరు, దీషాను. శేయీరు దేశంలోని వారి నాయకుల జాబితా ప్రకారం వీరు హోరీయుల నాయకులు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ఇశ్రాయేలీయుల మీద ఏ రాజూ పరిపాలన చేయక ముందే, ఎదోమును పరిపాలించిన రాజులు ఎవరంటే, ");
INSERT INTO tel2017_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","బెయోరు కొడుకు బెల ఎదోములో పాలించాడు. అతని ఊరు దిన్హాబా. ");
INSERT INTO tel2017_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","బెల చనిపోయిన తరువాత బొస్రావాడైన జెరహు కొడుకు యోబాబు రాజయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","యోబాబు చనిపోయిన తరువాత తేమానీయుల దేశస్థుడు హుషాము రాజయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","హుషాము చనిపోయిన తరువాత మోయాబు దేశంలో మిద్యానీయులను ఓడించిన బదదు కొడుకు హదదు రాజయ్యాడు. అతని ఊరు అవీతు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","హదదు చనిపోయిన తరువాత మశ్రేకా వాడైన శమ్లా రాజయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","శమ్లా చనిపోయిన తరువాత నదీతీర ప్రాంతమైన రహెబోతుకు చెందిన షావూలు రాజయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","షావూలు చనిపోయిన తరువాత అక్బోరు కొడుకు బయల్‌ హానాను రాజయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","అక్బోరు కొడుకు బయల్‌ హానాను చనిపోయిన తరువాత హదరు రాజయ్యాడు. అతని ఊరు పాయు. అతని భార్య పేరు మహేతబేలు. ఆమె మేజాహాబు మనుమరాలు అయిన మత్రేదు కూతురు. ");
INSERT INTO tel2017_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","వారివారి తెగల ప్రకారం వారివారి ప్రాంతాల్లో వారివారి పేర్ల చొప్పున ఏశావు సంతానపు నాయకుల పేర్లు ఏవంటే, తిమ్నా, అల్వా, యతేతు, ");
INSERT INTO tel2017_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","అహొలీబామా, ఏలా, పీనోను, ");
INSERT INTO tel2017_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","కనజు, తేమాను, మిబ్సారు, ");
INSERT INTO tel2017_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","మగ్దీయేలు, ఈరాము. వీరంతా తమ తమ స్వాధీనంలో ఉన్న దేశంలో తమతమ నివాస స్థలాల ప్రకారం ఎదోము నాయకులు. ఎదోమీయులకు మూల పురుషుడు ఏశావు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","యాకోబు తన తండ్రి పరదేశీయుడుగా ఉండిన కనాను దేశంలో నివసించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","యాకోబు జీవిత వృత్తాంతం ఇది. యోసేపు పదిహేనేళ్ళ వాడుగా ఉన్నప్పుడు తన సోదరులతో కూడ మందను మేపుతూ ఉన్నాడు. అతడు చిన్నవాడుగా తన తండ్రి భార్యలైన బిల్హా కొడుకుల దగ్గరా జిల్పా కొడుకుల దగ్గరా ఉండేవాడు. అప్పుడు యోసేపు వారి చెడ్డ పనులను గూర్చిన సమాచారం వారి తండ్రికి చేరవేసేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","యోసేపు ఇశ్రాయేలు వృద్ధాప్యంలో పుట్టిన కొడుకు కాబట్టి తన కొడుకులందరికంటే అతణ్ణి ఎక్కువగా ప్రేమించి అతని కోసం ఒక అందమైన నిలువుటంగీ కుట్టించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","అతని సోదరులు తమ తండ్రి అతణ్ణి తమందరికంటే ఎక్కువగా ప్రేమించడం వలన అతని మీద పగపట్టి, అతనితో ఎప్పుడూ ప్రేమగా మాట్లాడేవారు కాదు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","యోసేపు ఒక కల కని తన సోదరులతో దాన్ని గూర్చి చెప్పినప్పుడు వారు అతని మీద మరింత పగపట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","అతడు వారితో ఇలా చెప్పాడు. “నేను కన్న ఈ కల మీరూ వినండి. ");
INSERT INTO tel2017_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","అదేమిటంటే మనం పొలంలో ధాన్యం కట్టలు కడుతూ ఉన్నాం. నా కట్ట లేచి నిలబడగానే మీ కట్టలు దాని చుట్టూ చేరి నా కట్టకి సాష్టాంగపడ్డాయి.” ");
INSERT INTO tel2017_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","అందుకు అతని సోదరులు “నువ్వు నిజంగానే మమ్మల్ని ఏలుతావా? మామీద నువ్వు అధికారివి అవుతావా” అని అతనితో చెప్పి, అతని కలలను బట్టీ అతని మాటలను బట్టీ అతని మీద మరింత పగ పెంచుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","అతడింకొక కల కని తన సోదరులతో “ఇదిగో నేను మరొక కల గన్నాను. అందులో సూర్య చంద్రులూ, పదకొండు నక్షత్రాలూ నాకు సాష్టాంగ పడ్డాయి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","అతడు తన తండ్రితో, తన అన్నలతో అది చెప్పాడు. అతని తండ్రి అతనితో “నువ్వు కన్న ఈ కల ఏమిటి? నేనూ నీ తల్లీ నీ అన్నలూ నిజంగా నీకు సాష్టాంగపడాలా?” అని అతణ్ణి గద్దించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","అతని సోదరులు అతనిపై కక్ష పెంచుకున్నారు. అయితే అతని తండ్రి ఆ మాటలు జ్ఞాపకం ఉంచుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","యోసేపు సోదరులు షెకెములో తమ తండ్రి మందను మేపడానికి వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","అప్పుడు ఇశ్రాయేలు యోసేపుతో “నీ సోదరులు షెకెములో మందను మేపుతున్నారు. నిన్ను వారి దగ్గరికి పంపుతాను, రా” అన్నప్పుడు అతడు “అలాగే” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","అప్పుడు యాకోబు “నువ్వు వెళ్ళి నీ సోదరుల క్షేమాన్ని, మంద క్షేమాన్ని తెలుసుకుని నాకు కబురు తీసుకురా” అని అతనితో చెప్పి హెబ్రోను లోయ నుండి అతణ్ణి పంపించాడు. అతడు షెకెముకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","యోసేపు పొలంలో ఇటు అటు తిరుగుతూ ఉండగా ఒక మనిషి అతణ్ణి చూసి “దేని గురించి వెదుకుతున్నావు?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","అందుకతడు “నేను నా సోదరులను వెదుకుతున్నాను. వారు మందను ఎక్కడ మేపుతున్నారో దయచేసి నాకు చెప్పు” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","అందుకు ఆ మనిషి “వారు ఇక్కడి నుండి వెళ్ళిపోయారు. వారు ‘దోతానుకు వెళ్దాం పదండి’ అని చెప్పుకోవడం నేను విన్నాను” అని చెప్పాడు. అప్పుడు యోసేపు తన సోదరుల కోసం వెదుకుతూ వెళ్ళి దోతానులో వారిని కనుగొన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","అతడు దగ్గరికి రాక ముందే వారు అతణ్ణి దూరం నుండి చూసి అతణ్ణి చంపడానికి దురాలోచన చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","వారు “అడుగో, కలలు కనేవాడు వస్తున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","వీణ్ణి చంపి ఒక గుంటలో పారేసి, ‘ఏదో క్రూర జంతువు వీణ్ణి చంపి తినేసింది’ అని చెబుదాం. అప్పుడు వీడి కలలేమౌతాయో చూద్దాం” అని ఒకరి కొకరు చెప్పుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","రూబేను ఆ మాట విని “మనం వాణ్ణి చంపకూడదు” అని చెప్పి వారి చేతుల్లో చావకుండా యోసేపును తప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ఎలాగంటే రూబేను అతణ్ణి తమ తండ్రికి అప్పగించాలని, వారు అతణ్ణి చంపకుండా విడిపించాలని ఉద్దేశించి “రక్తం చిందించ వద్దు. అతణ్ణి చంపకుండా అడవిలో ఉన్న ఈ గుంటలో తోసేయండి” అని వారితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","యోసేపు తన సోదరుల దగ్గరికి వచ్చినప్పుడు వారు యోసేపు తొడుక్కొన్న ఆ అందమైన నిలువుటంగీని తీసేసి, ");
INSERT INTO tel2017_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","అతణ్ణి పట్టుకుని ఆ గుంటలో పడదోశారు. అది నీళ్ళు లేని వట్టి గుంట. ");
INSERT INTO tel2017_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","వారు భోజనానికి కూర్చున్నపుడు, ఐగుప్తుకు సుగంధ ద్రవ్యాలు, మస్తకి, బోళం మోసుకుపోతున్న ఒంటెలతో ఇష్మాయేలీ యాత్రికులు గిలాదు నుండి రావడం చూశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","అప్పుడు యూదా “మనం మన తమ్ముణ్ణి చంపి వాడి చావుని దాచిపెట్టడం వలన ఏం ప్రయోజనం? ");
INSERT INTO tel2017_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ఈ ఇష్మాయేలీయులకు వాణ్ణి అమ్మేద్దాం రండి. ఎలాగైనా వాడు మన తమ్ముడు, మన రక్త సంబంధి గదా? వాడిని చంపకూడదు” అని తన సోదరులతో చెప్పాడు. అందుకు అతని సోదరులు అంగీకరించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ఆ మిద్యాను వర్తకులు దగ్గరికి వచ్చినపుడు వారు ఆ గుంటలో నుండి యోసేపును పైకి తీసి ఆ ఇష్మాయేలీయులకు ఇరవై షెకెల్ ల వెండికి అతణ్ణి అమ్మేశారు. వారు యోసేపును ఐగుప్తుకు తీసుకుపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","రూబేను ఆ గుంట దగ్గరికి తిరిగి వచ్చినప్పుడు యోసేపు అందులో లేకపోవడంతో అతడు తన బట్టలు చింపుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","అతడు తన సోదరుల దగ్గరికి వెళ్ళి “చిన్నవాడు లేడే, అయ్యో, నేనెక్కడికి వెళతాను?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","వారు ఒక మేకపిల్లను చంపి, యోసేపు అంగీని దాని రక్తంలో తడిపారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","వారు దాన్ని తమ తండ్రి దగ్గరికి తీసుకెళ్ళి “ఇది మాకు దొరికింది. ఇది నీ కొడుకు అంగీనో కాదో చూడు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","అతడు దాన్ని గుర్తుపట్టి “ఈ అంగీ నా కొడుకుదే, ఏదో ఒక క్రూర జంతువు వాణ్ణి చంపి తినేసింది. తప్పనిసరిగా అది యోసేపును చీల్చేసి ఉంటుంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","యాకోబు తన బట్టలు చింపుకుని తన నడుముకు గోనెపట్ట కట్టుకుని చాలా రోజులు తన కొడుకు కోసం దుఃఖించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","అతని కొడుకులు, కూతుర్లు అందరూ అతణ్ణి ఓదార్చడానికి ప్రయత్నం చేశారు గానీ అతడు ఓదార్పు పొందలేదు. “నేను ఏడుస్తూ చనిపోయిన వారుండే స్థలానికి నా కొడుకు దగ్గరికి వెళ్తాను” అని అతడు యోసేపు కోసం ఏడ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","మిద్యానీయులు యోసేపును ఐగుప్తుకు తీసుకువెళ్లి, ఫరో రాజు అంగ రక్షకుల సేనానిగా పని చేస్తున్న పోతీఫరుకు అతణ్ణి అమ్మేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ఆ కాలంలో యూదా తన సోదరులను విడిచిపెట్టి హీరా అనే ఒక అదుల్లాము వాడితో నివసించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","అక్కడ షూయ అనే ఒక కనానీ యువతిని చూసి ఆమెను వివాహమాడి ఆమెతో కాపురం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ఆమె గర్భవతి అయ్యి ఒక కొడుకును కన్నప్పుడు వాడికి ఏరు అని పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ఆమె మళ్ళీ గర్భం ధరించి మరొక కొడుకును కని వాడికి ఓనాను అని పేరు పెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ఆమె మళ్ళీ గర్భం ధరించి మూడవ కొడుకును కని వాడికి షేలా అని పేరు పెట్టింది. వారు కజీబులో ఉన్నప్పుడు ఆమె వాణ్ణి కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","యూదా తన పెద్ద కొడుకు ఏరుకి తామారు అనే యువతిని పెళ్ళి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","యూదా జ్యేష్ఠ కుమారుడు ఏరు యెహోవా దృష్టికి దుష్టుడు కాబట్టి యెహోవా అతణ్ణి చంపాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","అప్పుడు యూదా ఓనానుతో “నీ అన్నభార్య దగ్గరికి వెళ్ళి మరిది ధర్మం జరిగించి నీ అన్నకి సంతానం కలిగించు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ఓనాను ఆ సంతానం తనది కాబోదని తెలిసి ఆమెతో పండుకున్నప్పుడు తన అన్నకి సంతానం కలగకూడదని తన వీర్యాన్ని నేలపై విడిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","అతడు చేసింది యెహోవా దృష్టికి చెడ్డది కాబట్టి ఆయన అతణ్ణి కూడా చంపాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","అప్పుడు యూదా ఇతడు కూడా ఇతని అన్నల్లాగా చనిపోతాడేమో అని భయపడి “నా కుమారుడు షేలా పెద్దవాడయ్యే వరకూ నీ తండ్రి ఇంట్లో విధవరాలుగా ఉండు” అని తామారుతో చెప్పాడు. కాబట్టి తామారు వెళ్ళి తన తండ్రి ఇంట్లో నివసించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","చాలా రోజుల తరువాత యూదా భార్య అయిన షూయ కూతురు చనిపోయింది. తరువాత యూదా దుఃఖనివారణ పొంది, అదుల్లామీయుడైన హీరా అనే తన స్నేహితుడితో కలిసి తిమ్నాతులో తన గొర్రెల బొచ్చు కత్తిరించే వారి దగ్గరికి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","తన మామ తన గొర్రెల బొచ్చు కత్తిరించడానికి తిమ్నాతుకు వెళ్తున్నాడని తామారుకు తెలిసింది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","షేలా పెద్దవాడైనప్పటికీ తనను అతనికి భార్యగా తీసుకోకుండా ఉండడం చూసి తామారు తన విధవరాలి బట్టలు తీసివేసి, ముసుగు వేసుకుని, శరీరమంతా కప్పుకుని, తిమ్నాతుకు వెళ్ళే మార్గంలో ఏనాయిము అనే ద్వారం దగ్గర కూర్చుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","యూదా ఆమెను చూసి, ఆమె ముఖం కప్పుకుని ఉండడం వలన ఆమె వేశ్య అనుకుని, ");
INSERT INTO tel2017_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ఆమె దగ్గరికి వెళ్ళి, ఆమె తన కోడలని తెలియక “నీతో సుఖిస్తాను, రా” అని పిలిచాడు. అందుకు ఆమె “నువ్వు నాతో సుఖించినందుకు నాకేమిస్తావు?” అని అడిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","అందుకు అతడు “నా మందలో నుండి ఒక మేక పిల్లను పంపుతాను” అన్నాడు. ఆమె “అది పంపే వరకూ ఏమైనా తాకట్టు పెడితే సరే” అని అంది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","అతడు “ఏమి తాకట్టు పెట్టమంటావ్?” అని ఆమెను అడిగాడు. ఆమె “నీ ముద్ర, దాని దారం, నీ చేతికర్ర” అని చెప్పింది. అతడు వాటిని ఆమెకిచ్చి ఆమెతో వెళ్ళాడు. ఆమె అతని వలన గర్భవతి అయ్యింది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","అప్పుడామె లేచి వెళ్లిపోయి ముసుగు తీసేసి తన విధవరాలి వస్త్రాలు ధరించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","తరవాత యూదా ఆ స్త్రీ దగ్గర నుండి ఆ తాకట్టు వస్తువులను తీసుకోడానికి తన స్నేహితుడయిన అదుల్లామీయుడి ద్వారా మేకపిల్లను పంపినప్పుడు ఆమె అతనికి కనబడలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","కాబట్టి అతడు “ఆ మార్గంలో ఏనాయిము దగ్గర కనిపించిన ఆ వేశ్య ఎక్కడ ఉంది?” అని అక్కడి మనుషులను అడిగాడు. అయితే వారు “ఇక్కడ వేశ్య ఎవరూ లేదు” అని అతనికి చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","కాబట్టి అతడు యూదా దగ్గరికి తిరిగి వెళ్ళి “ఆమె నాకు కనబడలేదు. అంతేగాక, అక్కడి మనుషులు ఇక్కడికి వేశ్య ఎవరూ రాలేదని చెప్పారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","యూదా “మనలను అపహాస్యం చేస్తారేమో, ఆమె వాటిని ఉంచుకోనీ. నేను నీతో ఈ మేక పిల్లను పంపాను, ఆమె నీకు కనబడలేదు” అని అతనితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","సుమారు మూడు నెలలైన తరువాత “నీ కోడలు తామారు జారత్వం జరిగించింది. అంతేకాక ఆమె జారత్వం వలన గర్భవతి అయ్యింది” అని యూదాకు కబురొచ్చింది. అప్పుడు యూదా “ఆమెను తీసుకు రండి, ఆమెను సజీవ దహనం చెయ్యాలి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ఆమెను బయటికి తీసుకు వచ్చినప్పుడు, ఆమె తన మామ దగ్గరికి అతని వస్తువులను పంపి “ఇవి ఎవరివో ఆ మనిషి వలన నేను గర్భవతినయ్యాను. ఈ ముద్ర, ఈ దారం, ఈ కర్ర ఎవరివో దయచేసి గుర్తు పట్టండి” అని చెప్పించింది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","యూదా వాటిని గుర్తు పట్టి “నేను నా కుమారుడు షేలాను ఆమెకు ఇయ్యలేదు కాబట్టి ఆమె నాకంటే నీతి గలది” అని చెప్పి ఇంకెప్పుడూ ఆమెతో పండుకోలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","నెలలు నిండినప్పుడు ఆమె గర్భంలో కవలలు ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ఆమె ప్రసవిస్తున్నప్పుడు ఒకడు తన చెయ్యి బయటికి చాపాడు. మంత్రసాని ఒక ఎర్ర దారం వాడి చేతికి కట్టి “వీడు మొదట బయటికి వచ్చాడు” అని చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","వాడు తన చెయ్యి వెనక్కి తీయగానే అతని సోదరుడు బయటికి వచ్చాడు. అప్పుడామె “నువ్వెందుకురా చొచ్చుకు వచ్చావు?” అంది. అందుచేత వాడికి “పెరెసు” అని పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ఆ తరువాత చేతికి దారం కట్టి ఉన్న అతని సోదరుడు బయటికి వచ్చాడు. అతనికి “జెరహు” అని పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","యోసేపును ఐగుప్తుకు తీసుకొచ్చారు. ఫరో దగ్గర ఉద్యోగి, రాజు అంగరక్షకుల అధిపతి అయిన పోతీఫరు అనే ఐగుప్తీయుడు, అతన్ని అక్కడికి తీసుకొచ్చిన ఇష్మాయేలీయుల దగ్గర యోసేపును కొన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","యెహోవా యోసేపుతో ఉన్నాడు. అతడు వర్ధిల్లుతూ తన యజమాని అయిన ఐగుప్తీయుని ఇంట్లో ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","యెహోవా అతనికి తోడై ఉన్నాడనీ, అతడు చేసేదంతా యెహోవా సఫలం చేస్తున్నాడనీ అతని యజమాని గమనించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","యోసేపు అతని దృష్టిలో దయ పొందాడు. అతడు పొతీఫరుకు సేవ చేశాడు. పొతీఫరు తన ఇంటి మీద యోసేపును కార్యనిర్వాహకునిగా నియమించి తనకు కలిగినదంతా అతని అధీనంలో ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","అతడు తన ఇంటి మీదా తనకు ఉన్న దానంతటి మీదా అతన్ని కార్యనిర్వహకునిగా నియమించిన దగ్గరనుండి యెహోవా యోసేపును బట్టి ఆ ఐగుప్తీయుని ఇంటిని ఆశీర్వదించాడు. యెహోవా దీవెన అతని ఇంట్లో, పొలంలో, అతనికి ఉన్న దానంతటి మీదా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","అతడు తనకు కలిగినదంతా యోసేపుకు అప్పగించి, తాను భోజనం చేయడం తప్ప తనకేమి ఉందో ఏమి లేదో చూసుకొనేవాడు కాడు. యోసేపు అందగాడు, చూడడానికి బావుంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ఆ తరువాత అతని యజమాని భార్య యోసేపును మోహించింది. “నాతో సుఖపడు” అని అతనిని అడిగింది. ");
INSERT INTO tel2017_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","అయితే అతడు తిరస్కరించి “నా యజమాని తనకు కలిగినదంతా నా వశంలో ఉంచాడు. నేను ఇక్కడ ఉండడం వలన ఇంట్లో ఏ విషయాన్నీ అతడు చూసుకోవడం లేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ఈ ఇంట్లో నాకంటే పైవాడు ఎవడూ లేడు. నువ్వు అతని భార్యవు కాబట్టి నిన్ను మినహాయించి మిగతా అంతటినీ అతడు నా అధీనంలో ఉంచాడు. కాబట్టి నేనెలా ఇంత ఘోరమైన దుష్కార్యం చేసి దేవునికి విరోధంగా పాపం చేస్తాను?” అని తన యజమాని భార్యతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ప్రతిరోజూ ఆమె యోసేపుతో మాట్లాడుతూ ఉంది గానీ అతడు ఆమెతో ఉండడానికి గానీ పాపం చేయడానికి గానీ ఒప్పుకోలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","అలా ఉండగా ఒక రోజు అతడు పని మీద ఇంటి లోపలికి వెళ్ళాడు. ఇంట్లో పనిచేసే వాళ్ళెవరూ అక్కడ లేరు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","అప్పుడామె అతని పై వస్త్రాన్ని పట్టుకుని “నాతో పండుకో” అని అడిగింది. అతడు తన బట్టను ఆమె చేతిలో విడిచిపెట్టి తప్పించుకుని బయటికి పారిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","అతడు తన పై వస్త్రాన్ని ఆమె చేతిలో విడిచి తప్పించుకుని పోవడం ఆమె చూసి, ");
INSERT INTO tel2017_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","తన ఇంట్లో పనిచేసే వారిని పిలిచి “చూడండి, పోతీఫరు మనలను ఎగతాళి చేయడానికి ఒక హెబ్రీయుణ్ణి మన దగ్గరికి తెచ్చాడు. నాతో లైంగిక సంబంధం పెట్టుకోవాలని వీడు నా దగ్గరికి వస్తే నేను పెద్ద కేక వేశాను. ");
INSERT INTO tel2017_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","నేను పెద్దగా కేకవేయడం వాడు విని నా దగ్గర తన పై వస్త్రాన్ని విడిచిపెట్టి తప్పించుకుని బయటికి పారిపోయాడు” అని వారితో చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","అతని యజమాని ఇంటికి వచ్చే వరకూ ఆమె అతని వస్త్రాన్ని తన దగ్గర ఉంచుకుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ఆమె తన భర్తతో ఇలా వివరించింది. “నువ్వు మన దగ్గరికి తెచ్చిన ఆ హెబ్రీ దాసుడు నన్ను ఎగతాళి చేయడానికి నా దగ్గరికి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","నేను బిగ్గరగా కేక వేస్తే వాడు తన పై వస్త్రాన్ని నా దగ్గర విడిచిపెట్టి తప్పించుకుని బయటికి పారిపోయాడు.” ");
INSERT INTO tel2017_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“నీ దాసుడు నాకిలా చేశాడు” అని తన భార్య తనతో చెప్పిన మాటలు విని పొతీఫరు, కోపంతో మండిపడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","యోసేపు యజమాని అతన్ని రాజు ఖైదీలను బంధించే చెరసాలలో వేయించాడు. అతడు చెరసాలలో ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","అయితే యెహోవా యోసేపుకు తోడై ఉండి, అతని మీద నిబంధన సంబంధమైన విశ్వాస్యతను చూపించాడు. చెరసాల అధిపతి అతన్ని అభిమానంగా చూసుకోనేలా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","చెరసాల అధిపతి ఆ చెరసాలలో ఉన్న ఖైదీలందరినీ యోసేపుకు అప్పగించాడు. వారక్కడ చేసే పనులన్నీ యోసేపే చేయించేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","యెహోవా అతనికి తోడై ఉన్నాడు కాబట్టి ఆ చెరసాల అధిపతి యోసేపుకు తాను అప్పగించిన దేనినీ ఇక పట్టించుకునేవాడు కాదు. అతడు చేసేదంతా యెహోవా సఫలం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ఆ తరువాత ఐగుప్తు రాజుకు గిన్నె అందించేవాడూ, రొట్టెలు చేసేవాడూ తమ యజమాని పట్ల నేరం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","తన ఇద్దరు ఉద్యోగస్థులు, అంటే గిన్నె అందించే వాడి మీదా రొట్టెలు చేసే వాడి మీదా ఫరో కోపగించుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","వారిని చెరసాలలో ఉంచడానికి రాజు అంగరక్షకుల అధిపతికి అప్పగించాడు. ఆ చెరసాలలోనే యోసేపును కూడా బంధించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ఆ అధిపతి వారందరినీ యోసేపు ఆధీనంలో ఉంచాడు. అతడు వారి బాగోగులు చూసేవాడు. వారు కొన్నిరోజులు బందీలుగా ఉన్న తరువాత ");
INSERT INTO tel2017_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","వారిద్దరూ, అంటే ఐగుప్తు రాజుకు గిన్నె అందించేవాడు, రొట్టెలు చేసేవాడు ఒకే రాత్రి కలలు కన్నారు. ఒక్కొక్కడు వేరు వేరు భావాలతో కల కన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ఉదయాన యోసేపు వారి దగ్గరికి వచ్చి చూసినపుడు వారు విచారంగా ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","అతడు “మీరెందుకు విచారంగా ఉన్నారు?” అని వారిని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","అందుకు వారు “మా ఇద్దరికీ ఒక్కో కల వచ్చింది. వాటి అర్థం చెప్పేవాళ్ళు ఎవరూ లేరు” అన్నారు. యోసేపు వారితో “అర్థాలు తెలియచేయడం దేవుని అధీనమే గదా! దయచేసి నాకు చెప్పండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","అప్పుడు గిన్నె అందించేవారి నాయకుడు యోసేపుతో “నా కలలో ఒక ద్రాక్షతీగ నా ఎదుట ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ఆ ద్రాక్షతీగకు మూడు కొమ్మలున్నాయి. దానికి మొగ్గలొచ్చి పూలు పూసి గెలలు పండి ద్రాక్షపళ్ళు వచ్చాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ఫరో గిన్నె నా చేతిలో ఉంది. నేను ద్రాక్షపళ్ళు తీసుకుని ఫరో గిన్నెలో వాటిని పిండి ఆ గిన్నె ఫరో చేతికి ఇచ్చాను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","అప్పుడు యోసేపు “దాని అర్థం ఇదే. ఆ మూడు కొమ్మలు, మూడు రోజులు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ఇంక మూడు రోజుల్లో ఫరో నిన్ను హెచ్చించి, నువ్వు అతనికి గిన్నె అందించే నీ ఉద్యోగం నీకు మళ్ళీ ఇప్పిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","అయితే నీకంతా సరి అయినప్పుడు నన్ను గుర్తు చేసుకుని నామీద దయ చూపించు. ఫరో దగ్గర నా గురించి మాట్లాడి ఈ చెరసాల నుండి నేను బయటికి వచ్చేలా చూడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ఎందుకంటే నన్ను హెబ్రీయుల దేశం నుండి దొంగిలించి తీసుకొచ్చారు. ఈ చెరసాలలో నన్ను వేయడానికి ఇక్కడ కూడా నేనేమీ నేరం చేయలేదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","రొట్టెలు చేసే వాడు యోసేపు మంచి అర్థం చెప్పడం చూసి అతనితో “నాకూ ఒక కల వచ్చింది. మూడు రొట్టెల బుట్టలు నా తల మీద ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","పై బుట్టలో ఫరో కోసం అన్ని రకాల పిండివంటలు ఉన్నాయి. పక్షులు వచ్చి నా తల మీద ఉన్న ఆ బుట్టలో నుండి వాటిని తిన్నాయి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","యోసేపు “దాని అర్థం ఇదే. ఆ మూడు బుట్టలు మూడు రోజులు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ఇంక మూడు రోజుల్లో ఫరో నీ తల తీసి చెట్టుకు వేలాడదీస్తాడు. పక్షులు నీ మాంసం తింటాయి” అని జవాబిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","మూడవ రోజు ఫరో పుట్టినరోజు. అతడు తన సేవకులందరికీ విందు చేయించాడు. వారందరిలో గిన్నె అందించేవారి నాయకుడిపైనా రొట్టెలు చేసే వారి నాయకుడిపైనా మిగతా సేవకులందరికంటే ధ్యాస పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","గిన్నె అందించేవారి నాయకుని ఉద్యోగం అతనికి తిరిగి ఇచ్చాడు, కాబట్టి అతడు ఫరో చేతికి మళ్ళీ గిన్నె అందించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","యోసేపు చెప్పినట్టుగా రొట్టెలు చేసేవారి నాయకుణ్ణి ఉరి తీయించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","అయితే గిన్నె అందించేవారి నాయకుడు యోసేపుకు చేస్తానన్న సాయం గురించి పట్టించుకోలేదు. అసలు అతని గురించి మరచిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","రెండు సంవత్సరాల తరువాత ఫరోకు ఒక కల వచ్చింది. అందులో అతడు నైలు నది దగ్గర నిలబడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","పుష్టిగా ఉన్న అందమైన ఏడు ఆవులు నైలు నదిలో నుండి పైకి వచ్చి జమ్ముగడ్డిలో మేస్తున్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","వాటి తరువాత వికారంగా, బక్కచిక్కిన ఏడు ఆవులు నైలు నదిలో నుండి పైకి వచ్చి ఆ ఆవుల దగ్గర నది ఒడ్డున నిలబడ్డాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","అప్పుడు అందవిహీనమైనవీ చిక్కిపోయినవీ అయిన ఆవులు అందమైన బలిసిన ఆవులను తినేశాయి. దాంతో ఫరో నిద్రలేచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","అతడు నిద్రపోయి రెండవసారి కల కన్నాడు. అందులో మంచి పుష్టిగల ఏడు కంకులతో ఉన్న కాడ పైకి వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","తూర్పుగాలి వల్ల పాడైపోయిన ఏడు తాలు కంకులు వాటి తరువాత మొలిచాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","అప్పుడు నిండైన పుష్టిగల ఆ ఏడు కంకులను ఆ తాలుకంకులు మింగివేశాయి. అంతలో ఫరో మేలుకుని అది కల అని గ్రహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ఉదయాన్నే అతని మనస్సు కలవరపడింది కాబట్టి అతడు ఐగుప్తు శకునగాళ్ళందరినీ అక్కడి పండితులందరిని పిలిపించి తన కలలను వివరించి వారితో చెప్పాడు గాని ఫరోకు వాటి అర్థం చెప్పే వాడెవడూ లేడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","అప్పుడు గిన్నె అందించేవారి నాయకుడు “ఈ రోజు నా తప్పు గుర్తుకు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ఫరో తన సేవకుల మీద కోపపడి నన్నూ రొట్టెలు చేసేవారి నాయకుడినీ రాజు అంగరక్షకుల అధిపతి ఇంట్లో కావలిలో ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ఒకే రాత్రి నేనూ అతడు కలలు కన్నాము. ఒక్కొక్కడు వేర్వేరు అర్థాలతో కలలు కన్నాము. ");
INSERT INTO tel2017_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","అక్కడ రాజ అంగ రక్షకుల అధిపతికి సేవకుడిగా ఉన్న ఒక హెబ్రీ యువకుడు మాతో కూడ ఉన్నాడు. అతనితో మా కలలను మేము వివరించి చెబితే అతడు వాటి అర్థాన్ని మాకు తెలియచేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","అతడు మాకు ఏమి చెప్పాడో దాని ప్రకారమే జరిగింది. నా ఉద్యోగం నాకు మళ్ళీ ఇప్పించి వేరేవాడిని ఉరి తీయించారు” అని ఫరోతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ఫరో యోసేపును పిలిపించాడు. చెరసాలలో నుండి అతన్ని త్వరగా రప్పించారు. అతడు క్షవరం చేసుకుని బట్టలు మార్చుకుని ఫరో దగ్గరికి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ఫరో యోసేపుతో “నేనొక కల కన్నాను. దాని అర్థం చెప్పేవారు ఎవరూ లేరు. నువ్వు కలను వింటే దాని అర్థాన్ని తెలియచేయగలవని నిన్నుగూర్చి విన్నాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","యోసేపు “అది నావలన కాదు, దేవుడే ఫరోకు అనుకూలమైన సమాధానం ఇస్తాడు” అని ఫరోతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","అందుకు ఫరో “నా కలలో నేను ఏటి ఒడ్డున నిలబడ్డాను. ");
INSERT INTO tel2017_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","బలిసిన, అందమైన ఏడు ఆవులు ఏటిలోనుండి పైకివచ్చి జమ్ముగడ్డిలో మేస్తున్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","నీరసంగా చాలా వికారంగా చిక్కిపోయిన మరి ఏడు ఆవులు వాటి తరువాత పైకి వచ్చాయి. వీటి అంత వికారమైనవి ఐగుప్తు దేశంలో ఎక్కడా నాకు కనబడలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","చిక్కిపోయి వికారంగా ఉన్న ఆవులు బలిసిన మొదటి ఏడు ఆవులను తినేశాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","అవి వాటి కడుపులో పడ్డాయి గాని అవి కడుపులో పడినట్టు కనబడలేదు, మొదట ఉన్నట్లే అవి చూడ్డానికి వికారంగా ఉన్నాయి. అంతలో నేను మేలుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","నా కలలో నేను చూస్తే, పుష్టిగల ఏడు మంచి వెన్నులు ఒక్క కంకికి పుట్టాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","తూర్పు గాలిచేత చెడిపోయి, ఎండిన ఏడు పీలవెన్నులు వాటి తరువాత మొలిచాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ఈ పీలవెన్నులు ఆ మంచి వెన్నులను మింగివేశాయి. ఈ కలను పండితులకు తెలియచేశాను గాని దాని అర్థాన్ని తెలియచేసే వారెవరూ లేరు” అని అతనితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","అందుకు యోసేపు “ఫరో కనిన కల ఒక్కటే. దేవుడు తాను చేయబోయేది ఫరోకు తెలియచేశాడు. ఆ ఏడు మంచి ఆవులు, ఏడేళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ఆ ఏడు మంచికంకులు ఏడేళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","కల ఒక్కటే. వాటి తరువాత చిక్కిపోయి వికారంగా పైకి వచ్చిన ఏడు ఆవులూ ఏడేళ్ళు. తూర్పు గాలి చేత చెడిపోయిన ఏడు తాలువెన్నులు, ఏడేళ్ళ కరువు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","నేను ఫరోతో చెప్పే మాట ఇదే. దేవుడు తాను చేయబోయేది ఫరోకు చూపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ఇదిగో ఐగుప్తు దేశమంతటా చాలా సమృద్ధిగా పంట పండే ఏడేళ్ళు రాబోతున్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","వాటి తరువాత ఏడేళ్ళ కరువు వస్తుంది. అప్పుడు ఆ పంట సమృద్ధినంతా ఐగుప్తు దేశం మరచిపోతుంది. ఆ కరువు దేశాన్ని నాశనం చేస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","దాని తరువాత వచ్చే కరువుచేత దేశంలో ఆ పంట సమృద్ధి జ్ఞాపకంలో లేకుండా పోతుంది. ఆ కరువు చాలా భారంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ఈ పని దేవుడే నిర్ణయించాడు. దీన్ని దేవుడు చాలా త్వరగా జరిగిస్తాడు. అందుకే ఆ కల ఫరోకు రెండుసార్లు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","కాబట్టి ఫరో వివేకమూ జ్ఞానమూ ఉన్నమనిషిని వెతికి ఐగుప్తు దేశం మీద అతన్ని నియమించాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ఫరో అలా చేసి ఈ దేశం మీద పర్యవేక్షకులను నియమించి, సమృద్ధిగా పంట పండే ఏడేళ్ళలో ఐగుప్తు దేశమంతటా అయిదో భాగం తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","వారు రాబోయే ఈ మంచి సంవత్సరాల్లో దొరికే ఆహారమంతా సమకూర్చాలి. ఆ ధాన్యాన్ని ఫరో ఆధీనంలో ఉంచి, పట్టణాల్లో భద్రం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","కరువు వలన ఈ దేశం నశించి పోకుండా ఆ ధాన్యం ఐగుప్తు దేశంలో రాబోయే ఏడేళ్ళ కరువు కాలంలో సిద్ధంగా ఉంటుంది” అని ఫరోతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ఈ సలహా ఫరోకూ అతని పరివారమందరి దృష్టికీ నచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ఫరో తన పరివారంతో “ఇతనిలాగా దేవుని ఆత్మ ఉన్నవాడు మనకు దొరుకుతాడా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ఫరో, యోసేపుతో “దేవుడు ఇదంతా నీకు తెలియచేశాడు కాబట్టి నీలాగా వివేకమూ జ్ఞానమూ ఉన్న వారెవరూ లేరు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","నువ్వు నా భవనంలో అధికారిగా ఉండాలి. నా ప్రజలంతా నీకు లోబడతారు. సింహాసనం విషయంలోనే నేను నీకంటే పైవాడిగా ఉంటాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ఫరో “చూడు, ఐగుప్తు దేశమంతటి మీద నేను నిన్ను నియమించాను” అని యోసేపుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ఫరో తన చేతికి ఉన్న తన రాజముద్ర ఉంగరాన్ని తీసి యోసేపు చేతికి పెట్టాడు. శ్రేష్ఠమైన బట్టలు అతనికి తొడిగించి, అతని మెడలో బంగారు గొలుసు వేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","తన రెండవ రథంలో అతన్ని ఎక్కించాడు. కొందరు అతని ముందు నడుస్తూ “నమస్కారం చేయండి” అని కేకలు వేశారు. ఐగుప్తు దేశమంతటి మీదా ఫరో అతన్ని నియమించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ఫరో యోసేపుతో “నేను ఫరోని. నీ సెలవు లేకుండా ఐగుప్తు దేశమంతటా ఎవరూ తన చేతిని కానీ కాలిని కానీ ఎత్తకూడదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ఫరో, యోసేపుకు “జఫనత్ పనేహు” అని పేరు పెట్టాడు. అతనికి ఓను అనే పట్టణ యాజకుడైన పోతీఫెర కూతురు ఆసెనతుతో పెళ్ళిచేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","యోసేపు ఐగుప్తు రాజైన ఫరో ఎదుటికి వచ్చినప్పుడు ముప్ఫై ఏళ్లవాడు. యోసేపు ఫరో దగ్గరనుండి బయలుదేరి ఐగుప్తు దేశమంతటా తిరిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","సమృద్ధిగల ఏడేళ్ళలో భూమి చాలా విరివిగా పండింది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ఐగుప్తు దేశంలోని ఏడేళ్ళ ధాన్యమంతా అతడు సమకూర్చి, పట్టణాల్లో దాన్ని నిల్వ చేశాడు. ఏ పట్టణం చుట్టూ ఉన్న పొలాల ధాన్యం ఆ పట్టణంలోనే నిల్వచేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","యోసేపు సముద్రపు ఇసుకంత విస్తారంగా ధాన్యాన్ని నిలవ చేశాడు. అది కొలతకు మించిపోయింది కాబట్టి దాన్నిక కొలవడం మానుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","కరువు కాలం ముందే యోసేపుకు ఇద్దరు కొడుకులు పుట్టారు. ఓను పట్టణ యాజకుడైన పోతీఫెర కూతురు ఆసెనతు వారికి తల్లి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","అప్పుడు యోసేపు “దేవుడు నా కష్టాన్నంతా మా నాన్న ఇంట్లో వారందరినీ నేను మరచిపోయేలా చేశాడు” అని తన పెద్దకొడుక్కి “మనష్షే” అనే పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","“నేను బాధ అనుభవించిన దేశంలో దేవుడు నన్ను ఫలవంతం చేశాడు” అని రెండో కొడుక్కి “ఎఫ్రాయిము” అనే పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ఐగుప్తు దేశంలో సమృద్ధిగా పంట పండిన ఏడేళ్ళు గడిచిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","యోసేపు చెప్పిన ప్రకారం ఏడేళ్ళ కరువు మొదలయింది గాని ఐగుప్తు దేశమంతటా ఆహారముంది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ఐగుప్తు దేశమంతటా కరువు వచ్చినప్పుడు ఆ దేశప్రజలు ఆహారం కోసం ఫరోకు మొరపెట్టుకున్నారు. అప్పుడు ఫరో “మీరు యోసేపు దగ్గరికి వెళ్ళి అతడు మీతో చెప్పినట్లు చేయండి” అని ఐగుప్తీయులందరితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ఆ ప్రదేశమంతా కరువు వ్యాపించింది. యోసేపు గిడ్డంగులన్నీ విప్పించి ఐగుప్తీయులకు ధాన్యం అమ్మాడు. ఐగుప్తు దేశంలో ఆ కరువు తీవ్రంగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ఆ కరువు లోకమంతా తీవ్రంగా ఉండడం వల్ల లోకమంతా యోసేపు దగ్గర ధాన్యం కొనడానికి ఐగుప్తుకు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ఐగుప్తులో ధాన్యం ఉందని యాకోబు తెలుసుకుని “మీరు ఒకరి ముఖం ఒకరు చూసుకుంటున్నారేంటి?” అని తన కొడుకులతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“చూడండి, ఐగుప్తులో ధాన్యం ఉందని విన్నాను. మనం చావకుండా బతికేలా మీరు అక్కడికి వెళ్ళి మన కోసం అక్కడనుంచి ధాన్యం కొనుక్కురండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","యోసేపు పదిమంది అన్నలు ఐగుప్తులో ధాన్యం కొనడానికి వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","అయితే యాకోబు “అతనికి ఏదైనా హాని సంభవిస్తుందేమో” అని యోసేపు తమ్ముడైన బెన్యామీనును అతని అన్నలతో పంపలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","కరువు కనాను దేశంలో ఉంది కాబట్టి ధాన్యం కొనడానికి వచ్చిన వారితో ఇశ్రాయేలు కొడుకులు కూడా వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","అప్పుడు యోసేపు ఆ దేశానికి అధికారిగా ఉన్నాడు. అతడే ఆ దేశ ప్రజలందరికీ ధాన్యాన్ని అమ్మేవాడు కాబట్టి యోసేపు అన్నలు వచ్చి ముఖాలు వంచి నేలకు వంగి యోసేపుకు నమస్కారం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","యోసేపు తన అన్నలను చూసి వారిని గుర్తు పట్టి వారికి తెలియని మనిషిలా వారితో కఠినంగా మాట్లాడి “మీరెక్కడనుండి వచ్చారు?” అని అడిగాడు. అందుకు వారు “ఆహారం కొనడానికి కనాను దేశం నుండి వచ్చాము” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","యోసేపు తన అన్నలను గుర్తు పట్టాడు గాని వారు అతణ్ణి గుర్తు పట్టలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","యోసేపు వారిని గూర్చి తనకు వచ్చిన కలలను గుర్తుకు తెచ్చుకుని “మీరు గూఢచారులు. ఈ దేశపు గుట్టు తెలుసుకోడానికి వచ్చారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","వారు “లేదు ప్రభూ, మీ దాసులైన మేము ఆహారం కొనడానికే వచ్చాము. ");
INSERT INTO tel2017_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","మేమంతా ఒక తండ్రి కొడుకులం. మేము నిజాయితీగల వాళ్ళం. నీ దాసులమైన మేము గూఢచారులం కాదు” అని బదులిచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","అయితే అతడు వారితో “కాదు, ఈ దేశం గుట్టు తెలుసుకోడానికి మీరు వచ్చారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","అందుకు వారు “నీ దాసులమైన మేము పన్నెండుగురు అన్నదమ్ములం. కనాను దేశంలో ఉన్న ఒక తండ్రి కొడుకులం. ఇదిగో, అందరిలో చిన్నవాడు ఈ రోజు మా నాన్న దగ్గర ఉన్నాడు. ఒకడు లేడు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","అయితే యోసేపు “కాదు, నేను చెప్పినట్టు మీరు గూఢచారులే. ");
INSERT INTO tel2017_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","మీ అసలు సంగతి ఇలా తెలుస్తుంది. ఫరో జీవం తోడు, మీ తమ్ముడు ఇక్కడికి వస్తేనే తప్ప మీరిక్కడనుంచి వెళ్ళరు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","మీ తమ్ముణ్ణి తీసుకురావడానికి మీలో ఒకణ్ణి పంపండి. అప్పటి వరకూ మీరు ఇక్కడ బందీలుగా ఉంటారు. మీలో నిజముందో లేదో మీ మాటల్లో తెలుస్తుంది. లేకపోతే ఫరో జీవం తోడు, మీరు గూఢచారులే” అని చెప్పి ");
INSERT INTO tel2017_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","వారిని మూడు రోజులు చెరసాలలో వేయించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","మూడవ రోజు యోసేపు వారిని చూసి “నేను దేవునికి భయపడే వాణ్ణి. మీరు బతకాలంటే ఇలా చేయండి. ");
INSERT INTO tel2017_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","మీరు నిజాయితీగల వారైతే మీ సోదరుల్లో ఒకడు ఈ చెరసాలలో ఉండాలి. మిగతావారు మీ ఇంటి వారి కరువు తీరడానికి ధాన్యం తీసుకు వెళ్ళండి. ");
INSERT INTO tel2017_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","మీ తమ్ముణ్ణి నా దగ్గరికి తీసుకురండి. అప్పుడు మీ మాటలు నిజమే అని తెలుస్తుంది, మీరు చావరు” అని చెప్పాడు. కాబట్టి వారు అలా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","అప్పుడు వారు ఒకడితో ఒకడు “మన తమ్ముని విషయంలో మనం నిజంగా అపరాధులమే. అతడు మనలను బతిమాలినప్పుడు మనం అతని వేదన చూసి కూడా వినలేదు.” ");
INSERT INTO tel2017_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","రూబేను “ఈ చిన్నవాడి పట్ల పాపం చేయవద్దని నేను మీతో చెప్పినా మీరు వినలేదు, కాబట్టి అతని చావును బట్టి మనకు తగిన శాస్తి జరుగుతున్నది” అని వారితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","వారి మాటలు యోసేపుకు అర్థమయ్యాయని వారికి తెలియదు, ఎందుకంటే వారి మధ్య తర్జుమా చేసేవాడు ఒకడున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","యోసేపు వారి దగ్గరనుండి అవతలకు పోయి ఏడ్చాడు. వారి దగ్గరికి తిరిగి వచ్చి వారితో మాట్లాడాడు. వారిలో షిమ్యోనును పట్టుకుని వారి కళ్ళెదుటే అతన్ని బంధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","తన అన్నల సంచుల్లో ధాన్యం నింపమనీ, ఎవరి డబ్బులు వారి సంచుల్లోనే తిరిగి ఉంచమనీ, ప్రయాణం కోసం భోజనపదార్ధాలు వారికివ్వాలనీ తన పనివారికి ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","వారు, తాము కొనిన ధాన్యాన్ని గాడిదల మీద ఎక్కించుకుని అక్కడనుంచి వెళ్ళిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","అయితే వారు దిగిన చోట ఒకడు తన గాడిదకు మేతపెట్టడానికి తన సంచి విప్పితే అతని ధనం కనబడింది. అవి అతని సంచి మూతిలో ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","అప్పుడతడు “నా డబ్బు నాకే ఉంది. చూడండి, నా సంచిలోనే ఉంది” అని తన సోదరులతో అన్నాడు. వారి గుండెలు అదిరిపోయాయి. వారు వణికిపోతూ ఒకరితో ఒకరు “ఇదేంటి దేవుడు మనకిలా చేశాడు?” అనుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","వారు కనాను దేశంలో ఉన్న తమ తండ్రి యాకోబు దగ్గరికి వచ్చి తమకు జరిగినదంతా అతనికి తెలియచేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ఆ దేశానికి అధిపతి, మాతో కఠినంగా మాట్లాడి, మేము ఆ దేశాన్ని వేగు చూడడానికి వచ్చామనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","అప్పుడు మేము, ‘అయ్యా, మేము నిజాయితీపరులం, గూఢచారులం కాదు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","పన్నెండు మంది సోదరులం, ఒక్క తండ్రి కొడుకులం, ఒకడు లేడు, చిన్నవాడు ఇప్పుడు కనాను దేశంలో మా నాన్న దగ్గర ఉన్నాడు’ అని అతనితో చెప్పాము. ");
INSERT INTO tel2017_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","అందుకు ఆ దేశాధిపతి, మాతో ‘మీరు నిజాయితీపరులని ఇలా తెలుసుకుంటాను. మీ సోదరుల్లో ఒకణ్ణి నా దగ్గర విడిచిపెట్టి, మీ ఇంట్లోవారికి కరువు తీరేలా ధాన్యం తీసుకు వెళ్ళండి. ");
INSERT INTO tel2017_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","నా దగ్గరికి ఆ చిన్నవాణ్ని తీసుకు రండి. అప్పుడు మీరు నిజాయితీపరులనీ గూఢచారులు కారనీ నేను తెలుసుకుని మీ సోదరుణ్ణి మీకప్పగిస్తాను. అప్పుడు మీరు ఈ దేశంలో వ్యాపారం చేసుకోవచ్చు’ అని చెప్పాడు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","వారు తమ సంచులు కుమ్మరిస్తే ఎవరి డబ్బుల మూట వారి సంచుల్లో ఉంది. వారూ వారి తండ్రీ ఆ డబ్బుల మూటలు చూసి భయపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","అప్పుడు వారి తండ్రి యాకోబు “మీరు నా పిల్లల విషయంలో నన్ను దుఃఖానికి గురిచేశారు. యోసేపు లేడు, షిమ్యోను లేడు, మీరు బెన్యామీనును కూడా తీసుకుపోతారు. ఇవన్నీ నా మీదికే వచ్చాయి” అని వారితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","అందుకు రూబేను “నేనతన్ని నీ దగ్గరికి తీసుకు రాకపోతే, నా ఇద్దరు కొడుకులను నువ్వు చంపెయ్యవచ్చు. అతన్ని నా చేతికి అప్పగిస్తే, అతన్ని తిరిగి మీ దగ్గరికి తీసుకు వస్తాను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","అయితే అతడు “నా కొడుకును మీతో వెళ్ళనివ్వను. అతని అన్న చనిపోయాడు, ఇతడు మాత్రమే మిగిలాడు. మీరు వెళ్ళే దారిలో ఇతనికి హాని కలిగితే తల నెరిసిన నన్ను దుఃఖంతో మృత్యులోకంలోకి దిగిపోయేలా చేస్తారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","కనాను దేశంలో కరువు తీవ్రంగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","వారు ఐగుప్తునుండి తెచ్చిన ధాన్యం తినివేసిన తరువాత వారి తండ్రి “మీరు మళ్ళీ వెళ్ళి మన కోసం కొంచెం ఆహారం కొనండి” అని వారితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","యూదా “అతడు మీ తమ్ముడు మీతో ఉంటేనే గాని మీరు నా ముఖం చూడకూడదు, అని మాతో గట్టిగా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","కాబట్టి నువ్వు మా తమ్ముణ్ణి మాతో పంపితే మేము వెళ్ళి నీ కోసం ఆహారం కొంటాము. ");
INSERT INTO tel2017_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","నువ్వు వాణ్ణి పంపకపోతే మేము వెళ్ళం. మీ తమ్ముడు మీతో లేకపోతే మీరు నా ముఖం చూడకూడదని అతడు మాతో చెప్పాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","అందుకు ఇశ్రాయేలు “మీకు ఇంకొక తమ్ముడు ఉన్నాడని మీరు అతనితో చెప్పి నాకు ఇంత కీడు ఎందుకు తెచ్చిపెట్టారు?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","వారు “అతడు ‘మీ తండ్రి ఇంకా బతికే ఉన్నాడా? మీకు ఇంకో తమ్ముడు ఉన్నాడా?’ అని మా గురించి, మన కుటుంబం గురించిన వివరాలు అడిగాడు. మేము ఆ ప్రశ్నలకు తగినట్టు జవాబిచ్చాము. ‘మీ తమ్ముణ్ణి తీసుకు రండి’ అని అతడు అడుగుతాడని మాకెలా తెలుస్తుంది?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","యూదా తన తండ్రి ఇశ్రాయేలుతో “ఆ చిన్నవాణ్ని నాతో పంపు. మేము వెళతాము. అప్పుడు మేమే కాదు, నువ్వూ మా పిల్లలూ చావకుండా బతుకుతాం. ");
INSERT INTO tel2017_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","నేను అతనికి జామీను ఉంటాను. నువ్వు నన్ను బాధ్యుడుగా ఎంచవచ్చు. నేను అతణ్ణి తిరిగి నీ దగ్గరికి తీసుకువచ్చి నీముందు నిలబెట్టకపోతే నా జీవితమంతా ఆ నింద భరిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","మాకు ఆలస్యం కాకపోతే ఈపాటికి రెండవ సారి వెళ్లి మళ్ళీ వచ్చి ఉండేవాళ్ళమే” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","వారి తండ్రి ఇశ్రాయేలు, వారితో “అలాగైతే మీరిలా చేయండి. ఈ దేశంలోని మేలైన వస్తువులను మీ సంచుల్లో వేసుకుని తీసుకెళ్ళండి. కొంచెం సుగంధ ద్రవ్యాలు, కొంచెం తేనె, మసాలా దినుసులు, బోళం, పిస్తా కాయలు, బాదం కాయలు మీ సంచుల్లో వేసుకుని అతనికి కానుకగా తీసుకెళ్లండి. ");
INSERT INTO tel2017_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","రెండింతల డబ్బు తీసుకు వెళ్ళండి. మీ సంచుల మూతిలో వాళ్ళు ఉంచిన డబ్బు కూడా మళ్ళీ చేత పట్టుకుని వెళ్ళండి. బహుశా అది పొరబాటు కావచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","మీ తమ్ముణ్ణి వెంటబెట్టుకుని అతని దగ్గరికి తిరిగి వెళ్ళండి. ");
INSERT INTO tel2017_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","అతడు మీ అన్ననూ బెన్యామీనును మీకు అప్పగించేలా సర్వశక్తుడైన దేవుడు, అతని ముందు మిమ్మల్ని కరుణించు గాక. నేను సంతానాన్ని పోగొట్టుకోవలసి ఉంటే పోగొట్టుకుంటాను” అని వారితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","వాళ్ళు ఆ కానుక తీసికుని, చేతుల్లో రెండింతల డబ్బు, తమవెంట బెన్యామీనును తీసుకు ఐగుప్తుకు వెళ్ళి యోసేపు ముందు నిలబడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","యోసేపు వారితో ఉన్న బెన్యామీనును చూసి తన గృహనిర్వాహకునితో “వీరిని ఇంట్లోకి తీసికెళ్ళి ఒక జంతువును కోసి వంట సిద్ధం చేయించు. మధ్యాహ్నం వీరు నాతో భోజనం చేస్తారు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","యోసేపు చెప్పినట్లు అతడు చేసి వారిని యోసేపు ఇంటికి తీసికెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","తమను యోసేపు ఇంటికి తీసుకువెళ్ళినందుకు వారు భయపడి “మొదట మన సంచుల్లో తిరిగి ఇచ్చేసిన డబ్బు కోసం అతడు మన మీద దాడి చేసే అవకాశం ఉంది. మనలను బంధించి, దాసులుగా చెరపట్టి, మన గాడిదలను తీసుకోవచ్చు” అనుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","వారు యోసేపు గృహనిర్వాహకుని దగ్గరికి వచ్చి, ఇంటి గుమ్మం ముందు అతనితో మాట్లాడి, ");
INSERT INTO tel2017_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“అయ్యగారూ, మొదట మేము ఆహారం కొనడానికి మొదటిసారి వచ్చాము. ");
INSERT INTO tel2017_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","అయితే, మేము దిగిన చోటికి చేరి మా సంచులు విప్పితే, చూడండి, మా అందరి డబ్బు మొత్తం, ఎవరి డబ్బు వారి సంచి మూతిలో ఉంది. అదంతా పట్టుకొచ్చాము. ");
INSERT INTO tel2017_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ఆహారం కొనడానికి వేరే డబ్బు కూడా తెచ్చాము. మా డబ్బు మా సంచుల్లో ఎవరు వేశారో మాకు తెలియదు” అని చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","అందుకతడు “మీకు అంతా క్షేమమే. భయపడవద్దు. మీ తండ్రి దేవుడూ, మీ దేవుడు, మీ సంచుల్లో మీ డబ్బు పెట్టి ఉంటాడు. మీ డబ్బు నాకు అందింది” అని చెప్పి షిమ్యోనును వారి దగ్గరికి తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","గృహనిర్వాహకుడు వారిని యోసేపు ఇంట్లోకి తీసికు వచ్చి, వారికి నీళ్ళిస్తే, వారు కాళ్ళు కడుక్కున్నారు. అతడు వారి గాడిదలకు మేత వేయించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","అక్కడ తాము భోజనం చేయాలని వారు విన్నారు కాబట్టి మధ్యాహ్నం, యోసేపు వచ్చే సమయానికి తమ కానుక సిద్ధంగా ఉంచారు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","యోసేపు ఇంటికి వచ్చినప్పుడు వారు తమ చేతుల్లో ఉన్న కానుకను ఇంట్లోకి తెచ్చి, అతనికి నేలను వంగి, నమస్కారం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","అప్పుడు “మీరు చెప్పిన ముసలివాడైన మీ నాన్న క్షేమంగా ఉన్నాడా? అతడు ఇంకా బతికే ఉన్నాడా?” అని వారి క్షేమ సమాచారం అడిగినప్పుడు వారు, ");
INSERT INTO tel2017_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“నీ దాసుడైన మా తండ్రి ఇంకా బతికే ఉన్నాడు, క్షేమంగా ఉన్నాడు” అని చెప్పి వంగి సాగిలపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","అప్పుడతడు కన్నులెత్తి తన తల్లి కుమారుడూ తన తమ్ముడు అయిన బెన్యామీనును చూసి “మీరు నాతో చెప్పిన మీ తమ్ముడు ఇతడేనా?” అని అడిగి “బాబూ, దేవుడు నీకు దయ చూపుతాడు గాక” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","అప్పుడు తన తమ్ముని మీద యోసేపుకు ప్రేమ పొర్లుకుని వచ్చింది కాబట్టి అతడు త్వరగా ఏడవడానికి చోటు వెతికి, లోపలి గదిలోకి వెళ్ళి, అక్కడ ఏడ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","అతడు తన ముఖం కడుక్కుని బయటికి వచ్చాడు. అతడు తన్ను తాను సముదాయించుకుని “భోజనం వడ్డించండి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","అతనికీ వారికీ అతనితో భోజనం చేస్తున్న ఐగుప్తీయులకు వేర్వేరుగా వడ్డించారు. ఐగుప్తీయులు హెబ్రీయులతో కలిసి భోజనం చేయరు. అది ఐగుప్తీయులకు అసహ్యం. ");
INSERT INTO tel2017_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","పెద్దవాడు మొదలుకుని చిన్నవాడి వరకూ వారు అతని ముందు తమ తమ వయసు ప్రకారం కూర్చున్నారు. వారంతా ఆశ్చర్యపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","అతడు తన దగ్గర నుంచి వారికి పళ్ళేల్లో భోజనం వంతులెత్తి పంపాడు. బెన్యామీను వంతు వారందరి వంతులకంటే అయిదంతలు ఎక్కువగా ఉంది. వారంతా తాగి, యోసేపుతో విందారగించి ఉల్లాసంగా గడిపారు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","యోసేపు “వారు మోసికెళ్ళినంత ఆహారాన్ని వారి సంచుల్లో నింపి ఎవరి డబ్బు వారి సంచి మూతిలో పెట్టు, ");
INSERT INTO tel2017_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","చివరివాడి సంచి మూతిలో నా వెండి గిన్నె, అతని ధాన్యపు డబ్బు పెట్టు” అని తన గృహ నిర్వాహకునికి ఆజ్ఞాపించగా, యోసేపు చెప్పినట్టు అతడు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","తెల్లవారినప్పుడు ఆ మనుషులను తమ గాడిదలతో పాటు పంపి వేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","వారు ఆ పట్టణం నుండి బయలుదేరి ఎంతో దూరం వెళ్ళక ముందే, యోసేపు తన గృహనిర్వాహకునితో “నువ్వు లేచి ఆ మనుష్యుల వెంబడించి వెళ్ళి వారిని కలుసుకుని, ‘మీరు మేలుకు ప్రతిగా కీడు చేశారేమిటి? ");
INSERT INTO tel2017_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","నా యజమాని తాగే గిన్నె, శకునాలు చూసే గిన్నె యిదే కదా? మీరు చేసిన ఈ పని చాలా దుర్మార్గం’ అని వారితో చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","అతడు వారిని కలుసుకుని ఆ మాటలు వారితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","వారు “మా ప్రభువు ఇలాంటి మాటలు చెప్పడం ఎందుకు? మీ దాసులైన మేము ఇలాంటి పని చేయము. ");
INSERT INTO tel2017_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","చూడండి, మా సంచుల మూతుల్లో మాకు దొరికిన డబ్బును కనాను దేశంలో నుండి తిరిగి తీసుకు వచ్చాము. నీ ప్రభువు ఇంట్లో నుంచి మేము వెండి గానీ బంగారం గానీ ఎలా దొంగిలిస్తాము? ");
INSERT INTO tel2017_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","నీ దాసుల్లో ఎవరి దగ్గర అది దొరుకుతుందో వాడు చస్తాడు గాక. మేము మా ప్రభువుకు దాసులమవుతాం” అని అతనితో అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","గృహ నిర్వాహకుడు “మంచిది, మీరు చెప్పినట్టే చేయండి. ఎవరి దగ్గర ఆ గిన్నె దొరుకుతుందో అతడే నాకు బానిస ఆవుతాడు. మిగతా వారు నిర్దోషులు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","అప్పుడు ప్రతివాడూ గబగబా తన సంచిని దించి దాన్ని విప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ఆ గృహ నిర్వాహకుడు పెద్దవాడి సంచితో మొదలు పెట్టి చిన్నవాడి సంచి వరకూ వెతికాడు. ఆ గిన్నె బెన్యామీను సంచిలో దొరికింది. ");
INSERT INTO tel2017_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","వారు తమ బట్టలు చింపుకున్నారు. అందరూ గాడిదల మీద సంచులు ఎక్కించుకుని పట్టణానికి తిరిగి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","అప్పుడు యూదా, అతని సోదరులు యోసేపు ఇంటికి వచ్చారు. అతడింకా అక్కడే ఉన్నాడు, వారు అతని ముందు నేలమీద సాగిలపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","అప్పుడు యోసేపు “మీరు చేసిన ఈ పని ఏమిటి? నాలాటి మనిషి శకునం చూసి తెలుసుకుంటాడని మీకు తెలియదా” అని వారితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","యూదా “మా యజమానులైన మీతో ఏమి చెప్పగలం? ఏమనగలం? మేము నిర్దోషులమని ఎలా రుజువు చేయగలం? దేవుడే నీ దాసుల అపరాధం కనుగొన్నాడు. ఇదిగో, మేమూ ఎవని దగ్గర ఆ గిన్నె దొరికిందో వాడూ మా యజమానులైన మీకు దాసులమవుతాం” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","యోసేపు “అలా చేయడం నాకు దూరమౌతుంది గాక. ఎవరి దగ్గర ఆ గిన్నె దొరికిందో వాడే నాకు దాసుడుగా ఉంటాడు. మీరు మీ తండ్రి దగ్గరికి సమాధానంగా వెళ్ళండి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","యూదా అతని సమీపించి “ప్రభూ, ఒక మనవి. ఒక మాట రహస్యంగా నా యజమానులైన మీతో మీ దాసుడైన నన్ను చెప్పుకోనివ్వండి. తమ కోపం తమ దాసుని మీద రగులుకోనివ్వకండి. తమరు ఫరో అంతవారు గదా. ");
INSERT INTO tel2017_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","నా యజమానులైన మీరు, ‘మీకు తండ్రి అయినా తమ్ముడైనా ఉన్నాడా?’ అని తమ దాసులను అడిగారు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","అందుకు మేము, ‘మాకు ముసలి వాడైన తండ్రి, అతని ముసలితనంలో పుట్టిన ఒక చిన్నవాడు ఉన్నారు. వాని అన్న చనిపోయాడు. వాడి తల్లికి వాడొక్కడే మిగిలాడు. అతని తండ్రి అతన్ని ఎంతో ప్రేమిస్తాడు’ అన్నాము. ");
INSERT INTO tel2017_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","అప్పుడు తమరు, ‘నేనతన్ని చూడడానికి అతన్ని నా దగ్గరికి తీసుకు రండి’ అని తమ దాసులతో చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","అందుకు మేము, ‘ఆ చిన్నవాడు తన తండ్రిని వదిలి ఉండలేడు. వాడు తన తండ్రిని విడిచి పోతే వాడి తండ్రి చనిపోతాడు’ అని నా యజమానులైన మీతో చెప్పాము. ");
INSERT INTO tel2017_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","అందుకు తమరు, ‘మీ తమ్ముడు మీతో రాకపోతే మీరు మళ్లీ నా ముఖం చూడకూడదు’ అని తమ దాసులతో చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","కాబట్టి నా తండ్రి అయిన తమ దాసుని దగ్గరికి మేము వెళ్ళి, నా యజమానులైన మీ మాటలను అతనికి తెలియచేశాము. ");
INSERT INTO tel2017_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","మా తండ్రి, ‘మీరు తిరిగి వెళ్ళి మన కోసం కొంచెం ఆహారం కొనుక్కుని రండి’ అని చెబితే ");
INSERT INTO tel2017_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","‘మేము అక్కడికి వెళ్ళలేము, మా తమ్ముడు మాతో కూడా ఉంటేనే వెళ్తాము. మా తమ్ముడు మాతో ఉంటేనే గాని ఆయన ముఖం చూడలేము’ అని చెప్పాము. ");
INSERT INTO tel2017_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","అందుకు తమ దాసుడైన నా తండ్రి, ‘నా భార్య నాకిద్దరిని కన్నదని మీకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","వారిలో ఒకడు నాకు దూరమైపోయాడు. అతడు తప్పకుండా క్రూర మృగాల బారిన పడి ఉంటాడు. అప్పటినుంచి అతడు నాకు కనబడలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","మీరు నా దగ్గరనుంచి ఇతన్ని కూడా తీసుకుపోతే, ఇతనికి ఏదైనా హాని జరిగితే, తల నెరిసిన నన్ను మృతుల లోకంలోకి దుఃఖంతో దిగిపోయేలా చేస్తారు’ అని మాతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","కాబట్టి, తమ దాసుడైన నా తండ్రి దగ్గరికి నేను తిరిగి వెళ్ళినప్పుడు ఈ చిన్నవాడు మాతో బాటు లేకపోతే ");
INSERT INTO tel2017_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","మా తండ్రి ప్రాణం ఇతని ప్రాణంతో పెనవేసుకుంది కాబట్టి ఈ చిన్నవాడు మాతో లేకపోవడం చూడగానే అతడు చచ్చిపోతాడు. అలా తమ దాసులమైన మేము తల నెరిసిన తమ సేవకుడైన మా తండ్రిని మృతుల లోకంలోకి దుఃఖంతో దిగిపోయేలా చేస్తాము. ");
INSERT INTO tel2017_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","తమ సేవకుడినైన నేను, ‘ఈ బాలునికి జామీనుగా ఉండి, నీ దగ్గరికి నేనతని తీసుకు రాకపోతే మా నాన్న దృష్టిలో ఆ నింద నా మీద ఎప్పుడూ ఉంటుంది’ అని చెప్పాను. ");
INSERT INTO tel2017_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","కాబట్టి తమ దాసుడైన నన్ను ఈ అబ్బాయికి ప్రతిగా ఏలినవారికి దాసునిగా ఉండనిచ్చి ఈ చిన్నవాణ్ణి తన సోదరులతో వెళ్ళనివ్వండి. ");
INSERT INTO tel2017_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ఈ చిన్నవాడు నాతో కూడ లేకపోతే మా నాన్న దగ్గరికి నేనెలా వెళ్ళగలను? ఒకవేళ వెళితే, మా నాన్నకు వచ్చే అపాయం చూడవలసి వస్తుంది” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","అప్పుడు యోసేపు తన దగ్గర నిలబడ్డ పరివారం ఎదుట తమాయించుకోలేక “అందరినీ నా దగ్గరనుంచి బయటికి పంపేయండి” అని బిగ్గరగా చెప్పాడు. యోసేపు తన అన్నలకు తనను తాను తెలియజేసుకున్నప్పుడు అతని దగ్గర ఎవరూ లేరు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","అతడు పెద్దగా ఏడవగా ఐగుప్తీయులు విన్నారు. ఫరో ఇంటివారు ఆ ఏడుపు విన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","అప్పుడు యోసేపు “నేను యోసేపును. నా తండ్రి ఇంకా బతికే ఉన్నాడా?” అని అడిగినప్పుడు, అతని సోదరులు అతని సమక్షంలో కంగారుపడి అతనికి జవాబు ఇవ్వలేకపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","అప్పుడు యోసేపు “నా దగ్గరికి రండి” అని తన సోదరులతో చెబితే, వారు అతని దగ్గరికి వచ్చారు. అప్పుడతడు “ఐగుప్తుకు వెళ్లిపోయేలా మీరు అమ్మేసిన మీ తమ్ముడు యోసేపును నేనే. ");
INSERT INTO tel2017_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","అయినా, నన్నిక్కడకు మీరు అమ్మేసినందుకు దుఃఖపడవద్దు. మిమ్మల్ని మీరు నిందించుకోవద్దు. ప్రాణరక్షణ కోసం దేవుడు మీకు ముందుగా నన్ను పంపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","రెండేళ్ళ నుంచి దేశంలో కరువు ఉంది. ఇంకా ఐదేళ్ళు దున్నడం గానీ పంటకోత గానీ ఉండదు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","మిమ్మల్ని రక్షించి, భూమి మీద మిమ్మల్ని శేషంగా నిలపడానికీ ప్రాణాలతో కాపాడడానికీ దేవుడు మీకు ముందుగా నన్ను పంపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","కాబట్టి నన్ను దేవుడే పంపాడు. మీరు కాదు. ఆయన నన్ను ఫరోకు తండ్రిగా అతని ఇంటివారందరికి ప్రభువుగా ఐగుప్తు దేశమంతటి మీదా అధికారిగా నియమించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","మీరు త్వరగా నా తండ్రి దగ్గరికి వెళ్ళి అతనితో ‘నీ కొడుకు యోసేపు ఇలా చెబుతున్నాడు-దేవుడు నన్ను ఐగుప్తు దేశమంతటి మీదా అధిపతిగా నియమించాడు, నా దగ్గరికి రండి. ఆలస్యం చేయవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","నువ్వు గోషెను ప్రాంతంలో నివసిస్తావు. అప్పుడు నువ్వూ నీ పిల్లలూ నీ పిల్లల పిల్లలూ నీ గొర్రెల మందలూ నీ పశువులూ నీకు కలిగిన సమస్తమూ నాకు దగ్గరగా ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ఇంకా ఐదేళ్ళు కరువు ఉంటుంది, కాబట్టి నీకూ నీ ఇంటి వారికీ నీకు కలిగినదానంతటికీ పేదరికం రాకుండా అక్కడ నిన్ను పోషిస్తాను’ అన్నాడని చెప్పండి. ");
INSERT INTO tel2017_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ఇదిగో మీతో మాట్లాడేది నా నోరే అని మీ కళ్ళూ నా తమ్ముడు బెన్యామీను కళ్ళూ చూస్తున్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ఐగుప్తులో నాకున్న వైభవాన్నీ మీరు చూసిన సమస్తాన్నీ మా నాన్నకు తెలియచేసి త్వరగా మా నాన్నను ఇక్కడికి తీసుకు రండి” అని తన సోదరులతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","తన తమ్ముడు బెన్యామీను మెడను కౌగలించుకుని ఏడ్చాడు. బెన్యామీను అతణ్ణి కౌగలించుకుని ఏడ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","అతడు తన సోదరులందరిని ముద్దు పెట్టుకుని వారిని హత్తుకుని ఏడ్చిన తరువాత అతని సోదరులు అతనితో మాట్లాడారు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","“యోసేపు సోదరులు వచ్చారు” అనే సంగతి ఫరో ఇంట్లో వినబడింది. అది ఫరోకు, అతని సేవకులకు చాలా ఇష్టమయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","అప్పుడు ఫరో యోసేపుతో ఇలా అన్నాడు “నీ సోదరులతో ఇలా చెప్పు, ‘మీరిలా చేయండి. మీ పశువుల మీద బరువులు కట్టి కనాను దేశానికి వెళ్ళి ");
INSERT INTO tel2017_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","మీ తండ్రినీ మీ ఇంటివారిని వెంట బెట్టుకుని నా దగ్గరికి రండి, ఐగుప్తు దేశంలోని మంచి వస్తువులను మీకిస్తాను. ఈ దేశపు సారాన్ని మీరు అనుభవిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","మీకు ఆజ్ఞ ఇస్తున్నాను, ఇలా చేయండి. మీ పిల్లల కోసం, మీ భార్యల కోసం ఐగుప్తులో నుండి బండ్లను తీసుకుపోయి మీ తండ్రిని వెంటబెట్టుకుని రండి. ");
INSERT INTO tel2017_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ఐగుప్తు దేశమంతటిలో ఉన్న మంచి వస్తువులు మీవే అవుతాయి కాబట్టి మీ సామగ్రిని లక్ష్యపెట్టవద్దు’” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ఇశ్రాయేలు కుమారులు అలాగే చేశారు. యోసేపు ఫరో మాట ప్రకారం వారికి బండ్లు ఇప్పించాడు. ప్రయాణానికి భోజన పదార్ధాలు ఇప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","అతడు వారికి రెండేసి జతల బట్టలు ఇచ్చాడు, బెన్యామీనుకు 300 షెకెల్ ల వెండి, ఐదు జతల బట్టలు ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","అతడు తన తండ్రి కోసం వీటిని పంపించాడు, ఐగుప్తులోని శ్రేష్ఠమైన వాటిని మోస్తున్న పది గాడిదలనూ ప్రయాణానికి తన తండ్రి కోసం ఆహారం, ఇతర ధాన్యం, వేర్వేరు తినే సరుకులు మోస్తున్న పది ఆడ గాడిదలనూ పంపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","అప్పుడతడు తన సోదరులను సాగనంపి వారు బయలుదేరుతుంటే “దారిలో పోట్లాడుకోవద్దు” అని వారితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","వారు ఐగుప్తునుండి బయలు దేరి కనాను దేశానికి తమ తండ్రి అయిన యాకోబు దగ్గరికి వచ్చి ");
INSERT INTO tel2017_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“యోసేపు ఇంకా బతికే ఉన్నాడు. ఐగుప్తు దేశమంతటి మీదా అధిపతిగా ఉన్నాడు” అని అతనికి తెలియచేశారు. అయితే అతడు వారి మాట నమ్మలేక పోయాడు. అతని హృదయం విస్మయం చెందింది. ");
INSERT INTO tel2017_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","అప్పుడు వారు యోసేపు తమతో చెప్పిన మాటలన్నీ అతనితో చెప్పారు. తనను తీసుకు వెళ్ళడానికి యోసేపు పంపిన బండ్లు చూసి, వారి తండ్రి యాకోబు ప్రాణం తెప్పరిల్లింది. ");
INSERT INTO tel2017_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","అప్పుడు ఇశ్రాయేలు “ఇంతే చాలు. నా కొడుకు యోసేపు బతికే ఉన్నాడు, నేను చావక ముందు వెళ్ళి అతన్ని చూస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ఇశ్రాయేలు తనకున్నదంతా తీసుకు ప్రయాణమై బెయేర్షెబా వచ్చి తన తండ్రి అయిన ఇస్సాకు దేవునికి బలులర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","అప్పుడు రాత్రి దర్శనంలో దేవుడు “యాకోబూ, యాకోబూ” అని ఇశ్రాయేలును పిలిచాడు. అందుకతడు “చిత్తం ప్రభూ” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ఆయన “నేనే దేవుణ్ణి, మీ తండ్రి దేవుణ్ణి. ఐగుప్తు వెళ్ళడానికి భయపడవద్దు. అక్కడ నిన్ను గొప్ప జనంగా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","నేను నీతో కూడా ఐగుప్తు వస్తాను. నేను నిన్ను తప్పకుండా ఇక్కడికి తిరిగి తీసుకువస్తాను. నువ్వు చనిపోయేటప్పుడు యోసేపు తన సొంత చేతులతో నీ కళ్ళు మూస్తాడు.” ");
INSERT INTO tel2017_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","యాకోబు లేచి బెయేర్షెబా నుండి తరలి వెళ్ళాడు. ఫరో అతనినెక్కించి తీసుకు రావడానికి పంపిన బండ్ల మీద ఇశ్రాయేలు కొడుకులు తమ తండ్రి యాకోబునూ తమ పిల్లలనూ తమ భార్యలనూ ఎక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","యాకోబు అతనితో పాటు అతని సంతానమంతా ఐగుప్తు వచ్చారు. వారు తమ పశువులనూ తాము కనానులో సంపాదించిన సంపదనంతా తీసికెళ్లారు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","అతడు తన కొడుకులనూ మనుమలనూ తన కూతుర్లనూ తన కొడుకుల కూతుర్లనూ తన సంతానాన్నంతా తనతో ఐగుప్తు తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ఐగుప్తుకు వచ్చిన ఇశ్రాయేలు కొడుకుల పేర్లు ఇవే. ");
INSERT INTO tel2017_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","యాకోబు పెద్ద కొడుకు, రూబేను. రూబేను కొడుకులు, హనోకు, పల్లు, హెస్రోను, కర్మీ. ");
INSERT INTO tel2017_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","షిమ్యోను కొడుకులు, యెమూయేలు, యామీను, ఓహదు, యాకీను, సోహరు, కనానీయురాలి కొడుకు షావూలు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","లేవి కొడుకులు, గెర్షోను, కహాతు, మెరారి. ");
INSERT INTO tel2017_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","యూదా కొడుకులు ఏరు, ఓనాను, షేలా, పెరెసు, జెరహు. (ఏరు, ఓనాను, కనాను దేశంలో చనిపోయారు). పెరెసు కొడుకులు హెస్రోను, హామూలు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ఇశ్శాఖారు కొడుకులు తోలా, పువ్వా, యోబు, షిమ్రోను. ");
INSERT INTO tel2017_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","జెబూలూను కొడుకులు సెరెదు, ఏలోను, యహలేలు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","వీరు లేయా కొడుకులు. ఆమె పద్దనరాములో యాకోబుకు వారిని అతని కూతురు దీనానూ కన్నది. అతని కొడుకులూ అతని కుమార్తెలూ మొత్తం ముప్ఫై ముగ్గురు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","గాదు కొడుకులు సిప్యోను, హగ్గీ, షూనీ, ఎస్బోను, ఏరీ, ఆరోదీ, అరేలీ. ");
INSERT INTO tel2017_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ఆషేరు కొడుకులు ఇమ్నా, ఇష్వా, ఇష్వీ, బెరీయా. వారి సోదరి శెరహు. బెరీయా కొడుకులు హెబెరు, మల్కీయేలు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","లాబాను తన కూతురు లేయా కిచ్చిన జిల్పా కొడుకులు వీరే. ఆమె ఈ పదహారు మందిని యాకోబుకు కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","యాకోబు భార్య అయిన రాహేలు కొడుకులు యోసేపు, బెన్యామీను. ");
INSERT INTO tel2017_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","యోసేపుకు మనష్షే, ఎఫ్రాయిములు పుట్టారు. వారిని ఐగుప్తుదేశంలో ఓనుకు యాజకుడైన పోతీఫెర కూతురు ఆసెనతు అతనికి కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","బెన్యామీను కొడుకులు బెల, బేకెరు, అష్బేలు, గెరా, నయమాను, ఏహీరోషు, ముప్పీము, హుప్పీము, ఆర్దు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","యాకోబుకు రాహేలు కనిన కొడుకులైన వీరంతా పద్నాలుగురు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","దాను కొడుకు హుషీము. ");
INSERT INTO tel2017_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","నఫ్తాలి కొడుకులు యహనేలు, గూనీ, యేసెరు, షిల్లేము. ");
INSERT INTO tel2017_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","లాబాను తన కూతురు రాహేలుకు ఇచ్చిన బిల్హా కొడుకులు వీరే. ఆమె వారిని యాకోబుకు కన్నది. వారంతా ఏడుగురు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","యాకోబు కోడళ్ళను మినహాయించి అతని వారసులు యాకోబుతో ఐగుప్తుకు వచ్చిన వారంతా అరవై ఆరుగురు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ఐగుప్తులో యోసేపుకు పుట్టిన కొడుకులు ఇద్దరు. ఐగుప్తుకు వచ్చిన యాకోబు కుటుంబీకులు మొత్తం డెభ్భై మంది. ");
INSERT INTO tel2017_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","యాకోబు గోషెనుకు దారి చూపడానికి యోసేపు దగ్గరికి యూదాను తనకు ముందుగా పంపాడు. వారు గోషెను ప్రాంతానికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","యోసేపు తన రథాన్ని సిద్ధం చేయించి తన తండ్రి ఇశ్రాయేలును కలుసుకోడానికి గోషెనుకు వచ్చాడు. యోసేపు అతన్ని చూసి, అతని మెడను కౌగలించుకుని చాలా సేపు ఏడ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","అప్పుడు ఇశ్రాయేలు యోసేపుతో “నీవింకా బతికే ఉన్నావు. నీ ముఖం చూశాను. కాబట్టి నేనిక చనిపోగలను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","యోసేపు తన సోదరులతో తన తండ్రి కుటుంబం వారితో “నేను వెళ్ళి ఇది ఫరోకు తెలియచేసి, ‘కనాను దేశంలో ఉన్న నా సోదరులూ నా తండ్రి కుటుంబం వారూ నా దగ్గరికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","వారు గొర్రెల కాపరులు. పశువులను మేపేవారు. వారు తమకు కలిగినదంతా తీసుకు వచ్చారు’ అని అతనితో చెబుతాను. ");
INSERT INTO tel2017_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","కాబట్టి ఫరో మిమ్మల్ని పిలిపించి, ‘మీ వృత్తి ఏంటి?’ అని అడిగితే ");
INSERT INTO tel2017_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‘మా చిన్నప్పటి నుంచి ఇప్పటి వరకూ మేమూ మా పూర్వీకులంతా కాపరులం.’ మీరు గోషెను ప్రాంతంలో నివసించేలా ఇలా చెప్పండి. ఎందుకంటే, గొర్రెల కాపరి వృత్తిలో ఉన్నవారంటే ఐగుప్తీయులకు అసహ్యం.” ");
INSERT INTO tel2017_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","యోసేపు వెళ్ళి ఫరోతో “మా నాన్న, నా అన్నలు వారి గొర్రెల మందలతో వారి పశువులతో వారికి కలిగినదంతటితో కనాను దేశం నుండి వచ్చి గోషెనులో ఉన్నారు” అని తెలియచేసి, ");
INSERT INTO tel2017_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","తన సోదరుల్లో ఐదు గురిని వెంటబెట్టుకుని వెళ్లి వారిని ఫరో ముందు నిలబెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ఫరో, అతని సోదరులను చూసి “మీ వృత్తి ఏంటి?” అని అడిగితే వారు “నీ దాసులమైన మేమూ మా పూర్వికులు, గొర్రెల కాపరులం” అని ఫరోతో చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","వారు “కనాను దేశంలో కరువు తీవ్రంగా ఉంది. నీ దాసుల మందలకు మేత లేదు కాబట్టి ఈ దేశంలో కొంత కాలముండడానికి వచ్చాము. గోషెను ప్రాంతంలో నీ దాసులు నివసించడానికి సెలవు ఇప్పించండి” అని ఫరోతో అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ఫరో యోసేపును చూసి “మీ నాన్న, నీ సోదరులు నీ దగ్గరికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ఐగుప్తు దేశం నీ ఎదుట ఉంది. ఈ దేశంలోని మంచి ప్రాంతంలో మీ నాన్న, నీ సోదరులూ నివసించేలా చెయ్యి. గోషెను ప్రాంతంలో వారు నివసించవచ్చు. వారిలో ఎవరైనా సమర్ధులని నీకు అనిపిస్తే నా మందల మీద వారిని అధిపతులుగా నియమించు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","యోసేపు తన తండ్రి యాకోబును లోపలికి తీసుకు వచ్చి ఫరో ముందు నిలబెట్టినప్పుడు, యాకోబు ఫరోను దీవించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ఫరో “నీ వయసెంత?” అని యాకోబును అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","యాకోబు “నేను ప్రయాణాలు చేసినవి 130 ఏళ్ళు. నా జీవించిన దినాలు కొద్డిగానూ బాధాకరమైనవిగానూ ఉన్నాయి. అవి నా పూర్వీకులు యాత్ర చేసిన సంవత్సరాలన్ని కాలేదు” అని ఫరోతో చెప్పి, ");
INSERT INTO tel2017_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ఫరోను దీవించి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ఫరో ఆజ్ఞ ఇచ్చినట్లే, యోసేపు తన తండ్రికీ తన సోదరులకూ ఐగుప్తు దేశంలో రామెసేసు అనే మంచి ప్రదేశంలో స్వాస్థ్యం ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","యోసేపు తన తండ్రినీ తన సోదరులనూ తన తండ్రి కుటుంబం వారినందరినీ పోషిస్తూ వారి పిల్లల లెక్క ప్రకారం ఆహారమిచ్చి సంరక్షించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","కరువు చాలా తీవ్రంగా ఉంది కాబట్టి ఆ దేశమంతటా ఆహారం లేదు. కరువుతో ఐగుప్తు దేశం, కనాను దేశం దుర్బలమైన స్థితికి వచ్చాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","యోసేపు ప్రజలకు ధాన్యం అమ్ముతూ ఐగుప్తు దేశంలోనూ కనాను దేశంలోనూ ఉన్న డబ్బంతా పోగుచేశాడు. ఆ డబ్బంతా, ఫరో భవనంలోకి యోసేపు తెప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ఐగుప్తు దేశంలో కనాను దేశంలో డబ్బు అయిపోయిన తరువాత ఐగుప్తీయులంతా యోసేపు దగ్గరికి వచ్చి “మాకు ఆహారం ఇప్పించు. నీ ముందు మేమెందుకు చావాలి? మా డబ్బంతా అయిపోయింది” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","అందుకు యోసేపు “మీ పశువులు ఇవ్వండి, మీ డబ్బులు అయిపోతే మీ పశువులకు బదులు నేను మీకు ధాన్యమిస్తాను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","కాబట్టి వారు తమ పశువులను యోసేపు దగ్గరికి తెచ్చారు. ఆ సంవత్సరం, వారి మందలన్నిటికి బదులుగా అతడు వారికి ఆహారమిచ్చి వారిని పోషించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ఆ సంవత్సరం గడిచాక, తరువాత సంవత్సరం వారు అతని దగ్గరికి వచ్చి “మా డబ్బంతా అయిపోయింది. ఆ సంగతి మా యజమానులైన మీ దగ్గర దాచలేము. మా పశువుల మందలన్నీ మా యజమానులైన మీ వశమయ్యాయి. మా శరీరాలూ మా భూములూ తప్ప ఇంకేమీ మాకు మిగలలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","మీ కళ్ళముందు మేమూ మా పొలాలు ఎందుకు నశించాలి? ఆహారమిచ్చి మమ్మల్నీ మా పొలాలనూ కొనండి. మా పొలాలతో పాటు మేము ఫరోకు దాసులమవుతాం. మేము చావకుండా బతికేలా, పొలాలు పాడైపోకుండా మాకు విత్తనాలివ్వండి” అని అడిగారు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ఆవిధంగా, యోసేపు ఐగుప్తు భూములన్నిటినీ ఫరో కోసం కొన్నాడు. కరువు ఇగుప్తు వారిపాలిట తీవ్రంగా ఉండడం వలన వారంతా తమ పొలాలను అమ్మేశారు కాబట్టి, భూమి ఫరోది అయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","అతడు ఐగుప్తు పొలిమేరల ఈ చివరనుండి ఆ చివర వరకూ ప్రజలను దాసులుగా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","యాజకుల భూమి మాత్రమే అతడు కొనలేదు, యాజకులకు ఫరో భత్యం నియమించాడు. వారు ఫరో ఇచ్చిన ఆహారం తినే వారు కాబట్టి వారు తమ భూములను అమ్మలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","యోసేపు “ఇదిగో నేడు మిమ్మల్ని, మీ భూములను ఫరో కోసం కొన్నాను. మీకు విత్తనాలు ఇవిగో. పొలాల్లో చల్లండి. ");
INSERT INTO tel2017_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","నాలుగు భాగాలు మీవి. పంటలో అయిదవ భాగం మీరు ఫరోకు ఇవ్వాలి. అది పొలాల్లో విత్తడానికీ మీ పిల్లలకూ మీ ఇంట్లోవారి ఆహారానికి” అని ప్రజలతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","వారు “నువ్వు మా ప్రాణాలు నిలబెట్టావు. మాపై నీ దయ ఉండుగాక. మేము ఫరోకు బానిసలమవుతాం” అని చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","అప్పుడు ఐదవ భాగం ఫరోది అని యోసేపు ఐగుప్తు వారికి చట్టం నియమించాడు. అది ఇప్పటివరకూ నిలిచి వుంది. యాజకుల భూములు మాత్రమే ఫరోవి కాలేదు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ఇశ్రాయేలీయులు ఐగుప్తు దేశంలోని గోషెను ప్రాంతంలో నివసించారు. అందులో వారు ఆస్తి సంపాదించుకుని సంతానాభివృద్ధి పొంది చాలా విస్తరించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","యాకోబు ఐగుప్తుదేశంలో 17 ఏళ్ళు జీవించాడు. యాకోబు మొత్తం 147 ఏళ్ళు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ఇశ్రాయేలు అవసాన కాలం దగ్గర పడినప్పుడు అతడు తన కొడుకు యోసేపును పిలిపించి “నాపట్ల నీకు అభిమానం ఉంటే, నీ చెయ్యి నా తొడ కింద ఉంచి నాకు నమ్మకాన్నీ విశ్వాసాన్నీ కలిగించు. దయచేసి నన్ను ఐగుప్తులో పాతిపెట్టవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","నేను నా పితరులతో నిద్రించినప్పుడు ఐగుప్తులో నుంచి నన్ను తీసుకెళ్ళి, వారి సమాధిలో నన్ను పాతిపెట్టు” అని అతనితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","అందుకు యోసేపు “నేను నీ మాట చొప్పున చేస్తాను” అన్నాడు. ఇశ్రాయేలు “నాతో ప్రమాణం చెయ్యి” అంటే, యోసేపు అతనితో ప్రమాణం చేశాడు. అప్పుడు ఇశ్రాయేలు తన పడక తలగడ దగ్గర వంగి నమస్కరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ఈ సంగతులైన తరువాత “ఇదిగో, మీ నాన్నకు ఒంట్లో బాగాలేదు” అని ఒకడు యోసేపుతో చెప్పాడు. అప్పుడతడు మనష్షే, ఎఫ్రాయిము అనే తన ఇద్దరు కొడుకులను వెంటబెట్టుకుని వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","“ఇదిగో నీ కొడుకు యోసేపు నీ దగ్గరికి వస్తున్నాడు” అని యాకోబుకు తెలిసింది. అప్పుడు ఇశ్రాయేలు బలం తెచ్చుకుని తన మంచం మీద కూర్చున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","అతడు యోసేపుతో “కనాను దేశంలో ఉన్న లూజులో సర్వశక్తిగల దేవుడు నాకు కనబడి నన్ను ఆశీర్వదించి ");
INSERT INTO tel2017_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘ఇదిగో నిన్ను ఫలవంతంగా చేసి, విస్తరింపజేస్తాను. నువ్వు జన సమూహమయ్యేలా చేస్తాను. నీ వారసులకు ఈ దేశాన్ని నిత్య స్వాస్థ్యంగా ఇస్తాను’ అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","నేను ఐగుప్తుకు నీ దగ్గరికి రాకముందు ఐగుప్తు దేశంలో నీకు పుట్టిన నీ ఇద్దరు కొడుకులు నా బిడ్డలే. రూబేను షిమ్యోనుల్లాగే ఎఫ్రాయిము, మనష్షే నా కొడుకులే. ");
INSERT INTO tel2017_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","వారి తరువాత నీకు పుట్టిన సంతానం నీదే. వారి పేర్లు వారి సోదరుల స్వాస్థ్యం జాబితాల ప్రకారం నమోదు అవుతాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","పద్దనరాము నుండి నేను వస్తున్నపుడు, ఎఫ్రాతాకు ఇంకా కొంత దూరాన ఉన్నపుడు ప్రయాణంలో రాహేలు కనాను దేశంలో చనిపోయింది. అక్కడ బేత్లెహేము అనే ఎఫ్రాతా దారిలో నేను ఆమెను పాతిపెట్టాను” అని యాకోబు చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ఇశ్రాయేలు, యోసేపు కొడుకులను చూసి “వీరెవరు?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","యోసేపు “వీళ్ళు నా కొడుకులు. వీరిని ఈ దేశంలో దేవుడు నాకిచ్చాడు” అని తన తండ్రితో చెప్పాడు. అందుకతడు “నేను వారిని దీవించడానికి నా దగ్గరికి వారిని తీసుకు రా” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ఇశ్రాయేలు కళ్ళు వృద్ధాప్యం వలన మసకబారి చూడలేక పోయాడు. కాబట్టి, యోసేపు వారిని అతని దగ్గరికి తీసుకు వచ్చాడు. అతడు వారిని ముద్దు పెట్టుకుని కౌగిలించుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ఇశ్రాయేలు యోసేపుతో “నీ ముఖాన్ని మళ్ళీ చూస్తానని నేను అనుకోలేదు. అయితే, నీ సంతానాన్ని కూడా దేవుడు నన్ను చూడనిచ్చాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","యోసేపు అతని మోకాళ్ళ మధ్య నుండి వారిని తీసుకు అతనికి సాగిలపడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","తరువాత యోసేపు ఇశ్రాయేలు ఎడమచేతి వైపు తన కుడిచేత ఎఫ్రాయిమును, ఇశ్రాయేలు కుడిచేతి వైపు తన ఎడమ చేత మనష్షేను పట్టుకుని, వారిద్దరిని అతని సమీపంగా తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ఇశ్రాయేలు, చిన్నవాడైన ఎఫ్రాయిము తల మీద తన కుడిచేతిని, మనష్షే తలమీద తన ఎడమచేతిని ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ఇశ్రాయేలు యోసేపును దీవించి “నా పూర్వీకులు అబ్రాహాము ఇస్సాకులు ఎవరి సమక్షంలో నడుచుకున్నారో ఆ దేవుడు, ఇప్పటి వరకూ నన్ను పోషించిన ఆ దేవుడు, ");
INSERT INTO tel2017_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","సమస్త కీడుల నుంచి నన్ను కాపాడిన దూత, ఈ పిల్లలను దీవించు గాక. నా పేరు, అబ్రాహాము ఇస్సాకులనే నా పితరుల పేరు వారికి కలుగు గాక. లోకంలో వారు విస్తార జనసమూహంగా అవుతారు గాక” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","యోసేపు ఎఫ్రాయిము తల మీద తన తండ్రి కుడిచెయ్యి పెట్టడం చూశాడు. అది అతనికి నచ్చలేదు. అతడు మనష్షే తల మీద పెట్టించాలని తన తండ్రి చెయ్యి, ఎఫ్రాయిము తలమీద నుండి ఎత్తి, ");
INSERT INTO tel2017_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“నాన్నా, అలా కాదు. ఇతడే పెద్దవాడు. నీ కుడి చెయ్యి ఇతని తలమీద పెట్టు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","అతని తండ్రి ఒప్పుకోక “నాకు తెలుసు. కచ్చితంగా తెలుసు. ఇతడు కూడా ఒక జన సమూహమై గొప్పవాడవుతాడు. అయితే, ఇతని తమ్ముడు ఇతని కంటే గొప్పవాడవుతాడు. అతని సంతానం జన సమూహాలు అవుతారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ఆ రోజు అతడు వారిని ఇలా దీవించాడు. “ఇశ్రాయేలీయులు ఎవరినైనా దీవించేటపుడు, ‘ఎఫ్రాయిములాగా మనష్షేలాగా దేవుడు మిమ్మల్ని చేస్తాడు గాక’ అని మీ పేరెత్తి దీవిస్తారు” అని చెప్పి మనష్షే కంటే ఎఫ్రాయిమును ముందుగా ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ఇశ్రాయేలు “ఇదిగో నేను చనిపోతున్నాను, అయినా దేవుడు మీకు తోడై ఉండి మీ పూర్వీకుల దేశానికి మిమ్మల్ని తిరిగి రప్పిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","నేను నీ సోదరులకంటే నీకు ఒక భాగం ఎక్కువ ఇచ్చాను. దాన్ని, నా కత్తితో నా వింటితో, అమోరీయుల చేతిలో నుండి తీసుకున్నాను” అని యోసేపుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","యాకోబు తన కొడుకులను పిలిపించి ఇలా అన్నాడు. “మీరు కలిసి రండి, రాబోయే రోజుల్లో మీకు ఏం జరుగుతుందో నేను చెబుతాను. ");
INSERT INTO tel2017_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","యాకోబు కొడుకుల్లారా, కలిసి వచ్చి వినండి. మీ తండ్రి ఇశ్రాయేలు మాట వినండి. ");
INSERT INTO tel2017_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","రూబేనూ, నువ్వు నా పెద్ద కొడుకువి. నా బలానివి, నా శక్తి ప్రథమ ఫలానివి. ఘనతలోనూ బలంలోనూ ఆధిక్యం గలవాడివి. ");
INSERT INTO tel2017_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","పారే నీళ్ళలా చంచలుడివి. నీది ఉన్నత స్థాయి కాదు. ఎందుకంటే నువ్వు, నీ తండ్రి మంచం ఎక్కి దాన్ని అపవిత్రం చేశావు. నువ్వు నా మంచం మీదికి ఎక్కావు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","షిమ్యోను, లేవి అన్నదమ్ములే. వారి కత్తులు దౌర్జన్యం చేసే ఆయుధాలు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","నా ప్రాణమా, వారి ఆలోచనలో చేరవద్దు, వారి సభలో చేరవద్దు. నా హృదయం వారితో కలవలేనంత ఉదాత్తమైనది. కోపంలో వారు మనుషులను చంపారు. సరదా కోసం ఎద్దుల కాళ్ళ నరాలు తెగ్గొట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","వారి కోపం చాలా తీవ్రమైనది. వారి ఆగ్రహం క్రూరమైంది. అవి శాపగ్రస్తమైనవి. నేను వారిని యాకోబు ప్రజల్లో విభాగిస్తాను. ఇశ్రాయేలులో వారిని చెదరగొడతాను. ");
INSERT INTO tel2017_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","యూదా, నీ సోదరులు నిన్ను స్తుతిస్తారు. నీ చెయ్యి నీ శత్రువుల మెడ మీద ఉంటుంది. నీ తండ్రి కుమారులు నీ ఎదుట సాగిలపడతారు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","యూదా సింహం పిల్ల. నా కుమారుడా, నువ్వు చీల్చిన దాని దగ్గరనుంచి వచ్చావు. అతడు కాళ్ళు ముడుచుకుని పడుకున్నాడు. సింహం లాగా, ఆడ సింహం లాగా గర్జించాడు. అతన్ని లేపడానికి తెగించేవాడెవడు? ");
INSERT INTO tel2017_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","షిలోహు వచ్చే వరకూ యూదా దగ్గరనుంచి రాజదండం తొలగదు. అతని కాళ్ళ మధ్య నుంచి అధికార రాజదండం తొలగదు. రాజ్యాలు అతనికి లోబడతాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ద్రాక్షావల్లికి తన గాడిదనూ, మేలైన ద్రాక్ష తీగెకు తన గాడిద పిల్లనూ కట్టి, ద్రాక్షారసంలో తన బట్టలనూ, ద్రాక్షల రక్తంలో తన అంగీనీ ఉతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","అతని కళ్ళు ద్రాక్షారసమంత ఎర్రగా, అతని పళ్ళు పాలవలే తెల్లగా ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","జెబూలూను సముద్రపు ఒడ్డున నివసిస్తాడు. అతడు ఓడలకు రేవుగా ఉంటాడు. అతని పొలిమేర సీదోను వరకూ ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ఇశ్శాఖారు రెండు దొడ్ల మధ్య పడుకున్న బలమైన గాడిద. ");
INSERT INTO tel2017_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","అతడు మంచి విశ్రాంతి స్థలాన్నీ రమ్యమైన భూమినీ చూశాడు. బరువులు మోయడానికి భుజం వంచి చాకిరీ చేసే దాసుడయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","దాను ఇశ్రాయేలు గోత్రాల్లో ఒక గోత్రంగా తన ప్రజలకు న్యాయం తీరుస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","దాను, దారిలో పాము లాగా, గుర్రం మడిమె కరచి, రౌతు వెనక్కి పడిపోయేలా చేసే కట్లపాముగా దారిలో ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","యెహోవా, నీ రక్షణ కోసం కనిపెడుతున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","దోపిడీ గాళ్ళు గాదును కొడతారు. అయితే, అతడు వాళ్ళ మడిమెను కొడతాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ఆషేరు ఆహారం శ్రేష్ఠమైనది. రాజులకు తగిన మధుర పదార్దాలు అతడు అందిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","నఫ్తాలి వదిలిపెట్టిన లేడి. అతనికి అందమైన పిల్లలుంటారు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","యోసేపు ఫలించే కొమ్మ. ఊట దగ్గర పండ్లు కాసే పెద్ద కొమ్మ. దాని కొమ్మలు గోడ మీదికి ఎక్కి వ్యాపిస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","విలుకాళ్ళు అతనీపై దాడి చేస్తారు. అతని మీద బాణాలు వేసి అతన్ని హింసిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","అయితే, అతని విల్లు స్థిరంగా ఉంటుంది. అతని చేతులు నైపుణ్యంతో ఉంటాయి. ఎందుకంటే, ఇది యాకోబు పరాక్రమశాలి చేతుల వలన, ఇశ్రాయేలు ఆధార శిల, కాపరి పేరున అయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","నీకు సహాయం చేసే నీ తండ్రి దేవుని వలన, నిన్ను దీవించే సర్వశక్తుని వలన, నీకు పైనుండి వచ్చే దీవెనలు, కింది అగాధపు దీవెనలు, స్తనాల, గర్భాల దీవెనలు వస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","నీ తండ్రి దీవెనలు, పురాతన పర్వతాలంత ఘనంగా, నిత్య గిరులంత ఉన్నతంగా ఉంటాయి. అవి యోసేపు తల మీద ఉంటాయి. తన సోదరుల్లో ఘనుడైన వాని నడినెత్తి మీద ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","బెన్యామీను ఆకలిగొన్న తోడేలు. అతడు ఉదయాన ఎరను మింగి, దోచుకున్న దాన్ని, సాయంత్రం వేళ పంచుకుంటాడు.” ");
INSERT INTO tel2017_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ఇవన్నీ ఇశ్రాయేలు పన్నెండు గోత్రాలు. వారి తండ్రి వారిని దీవిస్తూ వారితో చెప్పింది యిదే. ఎవరి దీవెన వారికి తగినదే. ");
INSERT INTO tel2017_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","తరువాత అతడు వారికి ఆజ్ఞాపిస్తూ ఇలా అన్నాడు. “నేను నా పూర్వీకుల దగ్గరికి వెళ్ళబోతున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","హిత్తీయుడైన ఎఫ్రోను పొలంలోని గుహలో నా పూర్వీకుల దగ్గర నన్ను పాతిపెట్టండి. ఆ గుహ కనాను దేశంలోని మమ్రే దగ్గర ఉన్న మక్పేలా మైదానంలో ఉంది. అబ్రాహాము దానినీ ఆ పొలాన్నీ హిత్తీయుడైన ఎఫ్రోను దగ్గర శ్మశాన భూమి కోసం స్వాస్థ్యంగా కొన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","అక్కడే వారు అబ్రాహామునూ అతని భార్య శారాను పాతిపెట్టారు. అక్కడే ఇస్సాకును అతని భార్య రిబ్కాను పాతి పెట్టారు. అక్కడే నేను లేయాను పాతిపెట్టాను. ");
INSERT INTO tel2017_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ఆ పొలాన్నీ అందులోని గుహనూ హేతు కొడుకుల దగ్గర కొన్నారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","యాకోబు తన కొడుకులకు ఆజ్ఞాపించడం ముగించి మంచం మీద తన కాళ్ళు ముడుచుకుని ప్రాణం విడిచి తన వారి దగ్గరికి చేరాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","యోసేపు తన తండ్రి మీద వాలి ముఖాన్ని ముద్దు పెట్టుకుని ఏడ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","యోసేపు సుగంధ ద్రవ్యాలతో తన తండ్రి శవాన్ని సిద్ధపరచాలని తన దాసులైన వైద్యులకు ఆజ్ఞాపించాడు. కాబట్టి ఆ వైద్యులు ఇశ్రాయేలు శవాన్ని సిద్ధపరచారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","అందుకు వారికి 40 రోజులు పట్టింది. సుగంధ ద్రవ్యాలతో సిద్ధపరచడానికి అంత సమయం పడుతుంది. ఐగుప్తీయులు అతని గురించి 70 రోజులు దుఖించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","అతని గురించి దుఃఖించే రోజులు అయిపోయిన తరువాత, యోసేపు ఫరో ఇంటి వారితో మాటలాడి “మీ దయ నా మీద ఉంటే నా పక్షంగా ఫరోతో ");
INSERT INTO tel2017_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘మా నాన్న నాతో ప్రమాణం చేయించి “ఇదిగో, నేను చనిపోతున్నాను, కనానులో నా కోసం తవ్వించిన సమాధిలో నన్ను పాతిపెట్టాలి అని చెప్పాడు కాబట్టి అనుమతిస్తే నేనక్కడికి వెళ్ళి నా తండ్రిని పాతిపెట్టి మళ్ళీ వస్తాను అని యోసేపు అన్నాడు” అని చెప్పండి’” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","అందుకు ఫరో “అతడు నీ చేత చేయించిన ప్రమాణం ప్రకారం వెళ్ళి మీ నాన్నను పాతిపెట్టు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","కాబట్టి యోసేపు తన తండ్రిని పాతిపెట్టడానికి వెళ్ళాడు. అతనితో ఫరో ఇంటి పెద్దలైన అతని సేవకులంతా ఐగుప్తు దేశపు పెద్దలంతా ");
INSERT INTO tel2017_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","యోసేపు ఇంటివారంతా అతని సోదరులు, అతని తండ్రి ఇంటివారు వెళ్ళారు. వారు తమ పిల్లలనూ తమ గొర్రెల మందలనూ తమ పశువులనూ మాత్రం గోషెను దేశంలో విడిచిపెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","రథాలు, రౌతులు అతనితో వెళ్ళాయి. అది చాలా పెద్ద గుంపు అయింది. ");
INSERT INTO tel2017_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","వారు యొర్దానుకు అవతల ఉన్న ఆటదు కళ్ళం వచ్చినపుడు చాలా పెద్దగా ఏడ్చారు. యోసేపు తన తండ్రిని గురించి ఏడు రోజులు విలపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ఆ దేశంలో నివసించిన కనానీయులు ఆటదు కళ్ళం దగ్గర ఏడవడం చూసి “ఐగుప్తీయులకు ఇది చాలా సంతాప సమయం” అని చెప్పుకున్నారు. అందుకే దానికి “ఆబేల్‌ మిస్రాయిము” అనే పేరుంది. అది యొర్దానుకు అవతల ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","యాకోబు విషయంలో అతడు వారికి చెప్పినట్లు అతని కొడుకులు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","అతని కొడుకులు కనాను దేశానికి అతని శవాన్ని తీసుకుపోయి మమ్రే దగ్గరున్న మక్పేలా పొలంలోని గుహలో పాతిపెట్టారు. అబ్రాహాము పొలంతో పాటు గుహను శ్మశానం కోసం కొన్నాడు. అతడు దాన్ని హిత్తీయుడైన ఎఫ్రోను దగ్గర కొన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","యోసేపు తన తండ్రిని పాతిపెట్టిన తరువాత అతడు, అతని సోదరులు, అతని తండ్రిని పాతిపెట్టడానికి వెళ్ళిన వారంతా తిరిగి ఐగుప్తుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","యోసేపు సోదరులు తమ తండ్రి చనిపోవడం చూసి “ఒకవేళ యోసేపు మన మీద పగబట్టి, మనం అతనికి చేసిన కీడుకు ప్రతీకారం చేస్తాడేమో” అనుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","కాబట్టి వారు యోసేపుకు ఈ కబురు పంపించారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“మన తండ్రి తన మరణానికి ముందు మీరు యోసేపుతో, ‘నీ సోదరులు నీకు కీడు చేశారు. వారిని, వారి అపరాధాన్నీ దయచేసి క్షమించు’ అని చెప్పమన్నాడు” అని అతనితో చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","అతని సోదరులు పోయి అతని ముందు సాగిలపడి “ఇదిగో మేము నీకు దాసులం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","యోసేపు “భయపడవద్దు. నేను దేవుని స్థానంలో ఉన్నానా? ");
INSERT INTO tel2017_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","మీరు నాకు కీడు చేయాలని చూశారు గానీ మీరిప్పుడు చూస్తున్నట్టు, అనేకమందిని బతికించేలా అది మేలుకే దేవుడు ఉద్దేశించాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","కాబట్టి భయపడవద్దు. నేను మిమ్మల్ని, మీ పిల్లలను పోషిస్తాను” అని చెప్పి వారిని ఆదరించి వారితో ఇష్టంగా మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","యోసేపు, అతని తండ్రి కుటుంబం వారూ ఐగుప్తులో నివసించారు. యోసేపు 110 ఏళ్ళు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","యోసేపు ఎఫ్రాయిము యొక్క మూడవ తరం పిల్లలను చూశాడు. మనష్షే కొడుకయిన మాకీరు పిల్లలను కూడా చూశాడు. వారిని యోసేపు ఒడిలో ఉంచారు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","యోసేపు తన సోదరులను చూసి “నేను చనిపోబోతున్నాను. దేవుడు కచ్చితంగా మిమ్మల్ని చూడవచ్చి, ఈ దేశంలోనుండి తాను అబ్రాహాము, ఇస్సాకు, యాకోబులతో ప్రమాణం చేసి ఇచ్చిన దేశానికి మిమ్మల్ని తీసుకువెళ్తాడు” అని చెప్పాడు ");
INSERT INTO tel2017_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","అంతే గాక యోసేపు “దేవుడు కచ్చితంగా మిమ్మల్ని చూడవస్తాడు. అప్పుడు మీరు నా ఎముకలను ఇక్కడనుంచి తీసుకుపోవాలి” అని చెప్పి ఇశ్రాయేలు కొడుకులతో ప్రమాణం చేయించుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","యోసేపు 110 ఏళ్ల వయసువాడై చనిపోయాడు. వారు సుగంధ ద్రవ్యాలతో అతని శవాన్ని సిద్ధపరచి ఐగుప్తు దేశంలో ఒక శవపేటికలో ఉంచారు.");
INSERT INTO tel2017_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","యాకోబుతోబాటు ఐగుప్తుకు వెళ్ళిన అతని కొడుకులు రూబేను, షిమ్యోను, లేవి, యూదా, ఇశ్శాఖారు, జెబూలూను, బెన్యామీను, ");
INSERT INTO tel2017_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","దాను, నఫ్తాలి, గాదు, ఆషేరు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","యాకోబుకు పుట్టిన సంతానం మొత్తం 70 మంది. ");
INSERT INTO tel2017_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","యోసేపు ఐగుప్తులో ఉన్న ఆ సమయంలో ");
INSERT INTO tel2017_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","వీళ్ళంతా తమ తమ కుటుంబాలతో సహా ఐగుప్తులో నివసించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","యోసేపు, అతని అన్నదమ్ములు, వాళ్ళ తరం వారు అంతా చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ఇశ్రాయేలు ప్రజలు వారు నివసిస్తున్న ప్రాంతమంతటా తమ సంతానంతో బాగా విస్తరించి అభివృద్ధి పొందారు. ఆ ప్రాంతమంతా ఇశ్రాయేలు ప్రజలతో నిండిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","కొంతకాలానికి యోసేపు ఎవరో తెలియని కొత్త రాజు ఐగుప్తును పరిపాలించడం మొదలు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","అతడు తన ప్రజలతో ఇలా అన్నాడు “ఇశ్రాయేలు ప్రజలను చూడండి. వీళ్ళు మనకంటే సంఖ్యలో ఎక్కువగా, శక్తిమంతులుగా ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","వాళ్ళ విషయంలో మనం తెలివిగా ఏదన్నా చేద్దాం. లేకపోతే వాళ్ళ జనాభా పెరిగిపోతుంది. ఒకవేళ యుద్ధం గనక వస్తే వాళ్ళు మన శత్రువులతో చేతులు కలిపి మనకి వ్యతిరేకంగా యుద్ధం చేసి ఈ దేశం నుండి వెళ్లిపోతారేమో” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","అందుచేత వారు ఇశ్రాయేలు ప్రజలచే కఠిన బాధ చేయించి కఠినులైన అధికారులను వారి మీద నియమించాడు. ఆ అధికారులు ఫరో రాజు కోసం పీతోము, రామెసేసు అనే గిడ్డంగుల పట్టణాలను కట్టించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ఐగుప్తీయులు ఇశ్రాయేలు ప్రజలను అణగదొక్కేకొద్దీ వారు అంతకంతకూ విస్తరిస్తూ పోవడంతో వారు ఇశ్రాయేలు ప్రజల విషయం భయాందోళనలు పెంచుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ఐగుప్తీయులు ఇశ్రాయేలు ప్రజలతో మరింత కష్టమైన పనులు చేయించుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","బంకమట్టి పని, ఇటుకల పని, పొలంలో చేసే ప్రతి పనీ కఠినంగా చేయించుకుని వారి ప్రాణాలు విసిగిపోయేలా చేశారు. వారు ఇశ్రాయేలు ప్రజలతో చేయించుకొనే అన్ని పనులూ కఠిన బాధతో కూడి ఉండేవి. ");
INSERT INTO tel2017_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ఐగుప్తు రాజు హీబ్రూ మంత్రసానులతో మాట్లాడాడు. వారి పేర్లు షిఫ్రా, పూయా. ");
INSERT INTO tel2017_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“మీరు హెబ్రీ స్త్రీలకు పురుడు పోస్తున్నప్పుడు జాగ్రత్తగా కనిపెట్టి చూడండి. మగ పిల్లవాడు పుడితే ఆ బిడ్డను చంపివేయండి, ఆడ పిల్ల అయితే బతకనియ్యండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","అయితే ఆ మంత్రసానులు దేవునికి భయపడి ఐగుప్తురాజు తమకు ఆజ్ఞాపించినట్టు చేయలేదు. మగపిల్లలను చంపకుండా బతకనిచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ఐగుప్తు రాజు ఆ మంత్రసానులను పిలిపించి “మీరు ఇలా ఎందుకు చేశారు? మగపిల్లలను చంపకుండా ఎందుకు బతకనిచ్చారు?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","అప్పుడు ఆ మంత్రసానులు “హెబ్రీ స్త్రీలు ఐగుప్తు స్త్రీలలాంటి వాళ్ళు కాదు. తెలివైనవాళ్ళు. మంత్రసాని వాళ్ళ దగ్గరికి వెళ్లకముందే ప్రసవిస్తున్నారు” అని ఫరోతో చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","మంత్రసానులు దేవునికి భయపడినందువల్ల దేవుడు వారిని దీవించాడు. ఇశ్రాయేలు ప్రజల్లో వారి సంతానం విస్తరించింది. ");
INSERT INTO tel2017_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ఆయన వారి వంశాన్ని వృద్ధి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","అప్పుడు ఫరో “వారికి పుట్టిన ప్రతి మగపిల్లవాణ్ణి నైలు నదిలో పడవేయండి. ఆడపిల్లను బతకనియ్యండి” అని తన ఐగుప్తు ప్రజలకు ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","లేవి వంశానికి చెందిన ఒక వ్యక్తి వెళ్లి లేవి స్త్రీలలో ఒకామెను పెళ్లి చేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ఆమె గర్భం ధరించి ఒక కొడుకును కన్నది. వాడు ఎంతో అందంగా ఉండడం వల్ల అతణ్ణి మూడు నెలల పాటు దాచిపెట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ఇక అతణ్ణి దాచి ఉంచలేక జమ్ముతో ఒక పెట్టె చేయించి, దానికి జిగురు, కీలు పూసి, అందులో ఆ పిల్లవాణ్ణి పెట్టి, నది ఒడ్డున జమ్ము గడ్డిలో ఉంచింది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","పిల్లవాడికి ఏమైనా జరుగుతుందేమోనని వాడి అక్క దూరంగా నిలబడి చూస్తూ ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ఫరో చక్రవర్తి కూతురు స్నానం చేయడానికి నది దగ్గరికి వచ్చింది. ఆమె దాసీలు నది ఒడ్డున విహరిస్తూ ఉన్నారు. ఆమె రెల్లు గడ్డిలో ఉన్న ఆ పెట్టెను చూసి, తన దాసిని పంపి దాన్ని తెప్పించింది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","పెట్టె తెరిచినప్పుడు ఏడుస్తూ ఉన్న పిల్లవాడు కనిపించాడు. ఆమె వాడిపై జాలిపడింది. “వీడు హెబ్రీయుల పిల్లవాడు” అంది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","అప్పుడు దూరంగా నిలబడి ఉన్న పిల్లవాడి అక్క వచ్చి ఫరో కూతురితో “నీ కోసం ఈ పిల్లవాణ్ణి పెంచడానికి నేను వెళ్లి హెబ్రీ స్త్రీలలో ఒక ఆయాని తీసుకు రమ్మంటారా?” అని అడిగింది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ఫరో కూతురు “వెళ్లి తీసుకు రా” అంది. ఆ బాలిక వెళ్లి ఆ బిడ్డ తల్లిని తీసుకు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ఫరో కూతురు ఆమెతో “ఈ పిల్లవాణ్ణి తీసుకు పోయి నా కోసం పాలిచ్చి పెంచు. నేను నీకు జీతం ఇస్తాను” అని చెప్పింది. ఆమె పిల్లవాణ్ణి తీసుకు పోయి పాలిచ్చి పెంచింది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ఆ పిల్లవాడు పెద్దవాడైన తరువాత ఆమె అతణ్ణి ఫరో కూతురి దగ్గరికి తీసుకు వచ్చింది. అతడు ఆమెకు కొడుకు అయ్యాడు. ఆమె “నీళ్ళలో నుండి నేను ఇతన్ని బయటకు తీశాను, కాబట్టి ఇతని పేరు మోషే” అని చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","మోషే పెద్దవాడైన తరువాత తన ప్రజల దగ్గరికి వెళ్ళాడు. వారు పడుతున్న కష్టాలు, ఇబ్బందులు చూశాడు. ఆ సమయంలో తన సొంత జాతి వాడైన హెబ్రీయుల్లో ఒకణ్ణి ఒక ఐగుప్తీయుడు కొట్టడం చూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","అటూ ఇటూ చూసి అక్కడ ఎవ్వరూ లేకపోవడంతో ఆ ఐగుప్తీయుణ్ణి కొట్టి చంపి ఇసుకలో పాతిపెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","తరువాతి రోజు మోషే అటుగా వెళ్తుంటే అక్కడ ఇద్దరు హెబ్రీయులు గొడవ పడుతున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","అప్పుడు మోషే తప్పు చేసిన వ్యక్తితో “నువ్వెందుకు నీ సోదరుణ్ణి కొడుతున్నావు?” అని అడిగాడు. అందుకు అతడు “మా మీద నిన్ను అధికారిగా, తీర్పు తీర్చేవాడిగా ఎవరు నియమించారు? నువ్వు ఆ ఐగుప్తీయుణ్ణి చంపినట్టు నన్ను కూడా చంపుదామనుకుంటున్నావా?” అన్నాడు. ఈ విషయం అందరికీ తెలిసిపోయిందని మోషే భయపడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ఆ సంగతి విన్న ఫరో మోషేను చంపించాలని చూశాడు. మోషే ఫరో దగ్గరనుండి నుండి మిద్యాను దేశానికి పారిపోయాడు. అక్కడ ఒక బావి దగ్గర కూర్చున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","మిద్యాను దేశంలో ఉన్న యాజకునికి ఏడుగురు కూతుళ్ళు. వాళ్ళు తమ తండ్రి మందలకు నీళ్లు తోడి నీళ్ళ తొట్టెలు నింపుతున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","అప్పుడు వేరే మంద కాపరులు వచ్చి వాళ్ళను అక్కడి నుండి తోలివేశారు. మోషే లేచి ఆ అమ్మాయిలకు సహాయం చేసి, వాళ్ళ మందకు నీళ్లు తోడిపెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","వాళ్ళు తిరిగి తమ ఇంటికి తిరిగి వచ్చాక వారి తండ్రి రగూయేలు “మీరు ఇంత త్వరగా ఎలా వచ్చారు?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","అందుకు వాళ్ళు “ఒక ఐగుప్తీయుడు మంద కాపరుల చేతిలో నుండి మమ్మల్ని కాపాడి, నీళ్లు తోడి మన మందకు పోశాడు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","అతడు తన కూతుళ్ళతో “అతడు ఏడీ? ఎందుకు విడిచిపెట్టి వచ్చారు? అతణ్ణి భోజనానికి పిలుచుకు రండి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","మోషే ఆ కుటుంబంతో కలిసి నివసించడానికి అంగీకరించాడు. రగూయేలు తన కూతురు సిప్పోరాను మోషేకిచ్చి పెళ్లి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","వాళ్లకు ఒక కొడుకు పుట్టాడు. అప్పుడు మోషే “నేను పరాయి దేశంలో పరాయి వ్యక్తిగా ఉన్నాను” అనుకుని తన కొడుక్కి “గెర్షోము” అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ఈ విధంగా చాలా రోజులు గడచిపోయిన తరువాత ఐగుప్తు రాజు చనిపోయాడు. ఇశ్రాయేలు ప్రజలు ఇంకా బానిసత్వంలోనే ఉండి, నిట్టూర్పులు విడుస్తూ మొర పెడుతూ ఉన్నారు. తమ వెట్టిచాకిరీ మూలంగా వారు పెట్టిన మొరలు దేవుని సన్నిధికి చేరాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","దేవుడు వారి నిట్టూర్పులు, మూలుగులు విన్నాడు. అబ్రాహాము, ఇస్సాకు, యాకోబులతో తాను చేసిన నిబంధన జ్ఞాపకం చేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","దేవుడు ఇశ్రాయేలు ప్రజలను చూశాడు, వారిని పట్టించుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","మోషే మిద్యానులో యాజకుడైన తన మామ యిత్రో మందను మేపుతున్నాడు. ఆ మందను అరణ్యం అవతలి వైపుకు తోలుకుంటూ దేవుని పర్వతం హోరేబుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","అక్కడ ఒక పొద మధ్య నుండి అగ్నిజ్వాలల్లో యెహోవా దూత అతనికి ప్రత్యక్షమయ్యాడు. మోషే చూస్తూ ఉండగా అగ్నిలో ఆ పొద మండుతూ ఉంది గానీ పొద కాలిపోవడం లేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","అప్పుడు మోషే ఆ పొద ఎందుకు కాలిపోవడం లేదో, ఆ వింత ఏమిటో ఆ వైపుకు వెళ్లి చూద్దాం అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","దాన్ని చూద్దామని అతడు ఆ వైపుకు రావడం యెహోవా చూశాడు. ఆ పొద మధ్య నుండి దేవుడు “మోషే, మోషే” అని అతణ్ణి పిలిచాడు. అప్పుడు అతడు “చిత్తం ప్రభూ” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","అందుకు ఆయన “దగ్గరికి రావద్దు. నీ కాళ్ళకున్న చెప్పులు తీసెయ్యి. నువ్వు నిలబడి ఉన్న ప్రదేశం పవిత్రమైనది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ఆయన ఇంకా “నేను నీ పూర్వికులు అబ్రాహాము ఇస్సాకు యాకోబుల దేవుణ్ణి” అని చెప్పగా మోషే తన ముఖం కప్పుకుని దేవుని వైపు చూసేందుకు భయపడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","యెహోవా ఇలా చెప్పాడు. “ఐగుప్తులో ఉంటున్న నా ప్రజలు పడుతున్న బాధలు నాకు తెలుసు. కఠినమైన పనులు చేయిస్తూ వారిని బాధపెడుతున్న వారిని బట్టి వారు పెడుతున్న మొర నేను విన్నాను. వారి దుఃఖం నాకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","కనుక ఐగుప్తీయుల చేతిలో నుండి నా ప్రజలను విడిపించి, ఆ దేశం నుండి కనానీయులు, హిత్తీయులు, అమోరీయులు, పెరిజ్జీయులు, హివ్వీయులు యెబూసీయులు నివసిస్తున్న చాలా సారవంతమైన, విశాలమైన మంచి దేశానికి వారిని నడిపించడానికి నేను దిగి వచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","నిజంగా ఇశ్రాయేలు ప్రజల మొర నేను విన్నాను. ఐగుప్తీయులు వారి పట్ల జరిగిస్తున్న హింసాకాండను చూశాను. ");
INSERT INTO tel2017_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","నువ్వు సిద్ధపడు. నిన్ను ఫరో దగ్గరికి పంపిస్తాను. నువ్వు నా ప్రజలైన ఇశ్రాయేలీయులను ఐగుప్తు నుండి బయటకు నడిపించాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","అప్పుడు మోషే దేవునితో “ఫరో దగ్గరికి వెళ్ళి, ఇశ్రాయేలీయులను ఐగుప్తు నుండి బయటకు నడిపించడానికి నేను ఏపాటి వాణ్ణి?” అని అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","దేవుడు “నువ్వు ఆ ప్రజలను ఐగుప్తు నుండి తీసుకు వచ్చిన తరువాత మీరు ఈ కొండపై దేవుణ్ణి ఆరాధిస్తారు. కచ్చితంగా నేను నీకు తోడుగా ఉంటాను. నేను నిన్ను పంపించాను అని చెప్పడానికి ఇదే సూచన” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","మోషే “నేను ఇశ్రాయేలు ప్రజల దగ్గరికి వెళ్లి వారితో మీ పూర్వీకుల దేవుడు మీ దగ్గరికి నన్ను పంపించాడని చెప్పినప్పుడు వారు ‘ఆయన పేరేమిటి?’ అని అడిగితే వారితో నేనేం చెప్పాలి?” అని దేవుణ్ణి అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","అందుకు దేవుడు “నేను శాశ్వతంగా ఉన్నవాణ్ణి, అనే పేరు గల వాణ్ణి. ఉన్నవాడు అనే ఆయన నన్ను మీ దగ్గరికి పంపించాడు, అని ఇశ్రాయేలు ప్రజలతో చెప్పు” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","దేవుడు మోషేతో ఇంకా “మీ పూర్వీకుల దేవుడు యెహోవా, అంటే అబ్రాహాము, ఇస్సాకు, యాకోబుల దేవుడు యెహోవా మీ దగ్గరికి నన్ను పంపించాడు అని నువ్వు ఇశ్రాయేలు ప్రజలతో చెప్పాలి. చిరకాలం నిలిచి ఉండే, తరతరాలకు జ్ఞాపకముండే నా పేరు ఇదే. ");
INSERT INTO tel2017_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","నువ్వు వెళ్లి ఇశ్రాయేలు పెద్దలను సమకూర్చి ‘మీ పూర్వీకుల దేవుడు యెహోవా, అంటే అబ్రాహాము ఇస్సాకు యాకోబుల దేవుడు నాకు కనబడి ఇలా చెప్పాడు, నేను ఐగుప్తులో మీకు జరుగుతున్నదంతా చూశాను. ");
INSERT INTO tel2017_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ఐగుప్తులో మీరు పడుతున్న బాధల నుండి విడిపించి కనానీయులు, హిత్తీయులు, అమోరీయులు, పెరిజ్జీయులు, హివ్వీయులు, యెబూసీయులు నివసిస్తున్న పాలు తేనెలు ప్రవహించే దేశానికి మిమ్మల్ని తీసుకువస్తాను’ అని చెప్పాడని వారితో చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","వాళ్ళు నీ మాట వింటారు గనక నువ్వూ, ఇశ్రాయేలు ప్రజల పెద్దలూ ఐగుప్తు రాజు దగ్గరికి వెళ్లి, అతనితో, హెబ్రీయుల దేవుడు యెహోవా మాకు ప్రత్యక్షమయ్యాడు, మేము అడవిలోకి మూడు రోజుల ప్రయాణమంత దూరం ప్రయాణించి మా దేవుడు యెహోవాకు బలులు అర్పిస్తాం, మాకు అనుమతి ఇవ్వు, అని అతనితో చెప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ఐగుప్తు రాజు తన గొప్ప సైన్యంతో మిమ్మల్ని అడ్డగించి వెళ్ళనీయకుండా చేస్తాడని నాకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","అయితే నేను నా చెయ్యి చాపి ఐగుప్తు దేశంలో నేను చేయాలనుకున్న నా అద్భుత కార్యాలను చూపించి అతడి ప్రయత్నాలను భంగపరుస్తాను. ఆ తరువాత అతడు మిమ్మల్ని వెళ్ళనిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","మీరు ఐగుప్తును విడిచి వెళ్ళే సమయంలో ఖాళీ చేతులతో వెళ్ళరు. ఎందుకంటే ప్రజల పట్ల ఐగుప్తు వారికి మంచి మనస్సు కలిగేలా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ప్రతి స్త్రీ తన దగ్గర ఉన్న స్త్రీని, తన యజమానురాలిని వెండి, బంగారు నగలు, దుస్తులు ఇమ్మని అడగాలి. వాటిని తీసుకుని మీ కొడుకులకు, కూతుళ్ళకు ధరింపజేయాలి. ఈ విధంగా మీరు ఐగుప్తు దేశ ప్రజలను కొల్లగొడతారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","అప్పుడు మోషే “వాళ్ళు నన్ను నమ్మరు. నా మాట వినరు. ‘యెహోవా నీకు ప్రత్యక్షం కాలేదు’ అంటారేమో” అని జవాబిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","యెహోవా “నీ చేతిలో ఉన్నది ఏమిటి?” అని మోషేను అడిగాడు. అతడు “కర్ర” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","అప్పుడు దేవుడు “ఆ కర్రను నేల మీద పడవెయ్యి” అన్నాడు. అతడు దాన్ని నేల మీద పడవెయ్యగానే అది పాముగా మారిపోయింది. మోషే భయపడి దూరంగా పరిగెత్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","అప్పుడు యెహోవా “నీ చేత్తో దాని తోక పట్టుకో” అని చెప్పాడు. అతడు తన చెయ్యి చాపి దాన్ని పట్టుకోగానే అది అతని చేతిలో కర్రగా మారిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ఆయన “దీన్ని బట్టి వాళ్ళు తమ పూర్వీకుల దేవుడు యెహోవా, అంటే అబ్రాహాము, ఇస్సాకు, యాకోబుల దేవుడు నీకు ప్రత్యక్షమయ్యాడని నమ్ముతారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","తరువాత యెహోవా “నీ చెయ్యి నీ అంగీలో పెట్టుకో” అన్నాడు. అతడు తన చెయ్యి అంగీలో ఉంచి బయటికి తీసినప్పుడు ఆ చెయ్యి కుష్టురోగం సోకినట్టు మంచులాగా తెల్లగా మారిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","తరువాత ఆయన “నీ చెయ్యి మళ్ళీ నీ అంగీలో ఉంచుకో” అన్నాడు. అతడు తన చెయ్యి తన అంగీలో ఉంచుకుని బయటికి తీసినప్పుడు అది అతని మిగతా శరీరంలాగా మామూలుగా అయిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","అప్పుడు దేవుడు “వాళ్ళు నా శక్తిని కనపరిచే మొదటి అద్భుతాన్ని పట్టించుకోకుండా నమ్మకుండా ఉంటే రెండవ దాన్ని బట్టి నమ్ముతారు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ఈ రెండు అద్భుతాలను చూసి కూడా నిన్ను నమ్మకుండా నీ మాట వినకుండా ఉంటే, నువ్వు నదిలోని కొంచెం నీళ్ళు తీసుకుని ఎండిన నేల మీద కుమ్మరించు. నువ్వు నదిలో నుండి తీసి పొడి నేలపై పోసిన నీళ్లు రక్తంలాగా మారిపోతాయి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","మోషే “ప్రభూ, నీవు నీ దాసుడినైన నాతో మాట్లాడడానికి ముందుగానీ తరవాతగానీ ఏనాడూ నేను మాటకారిని కాను. నా నోరు, నా నాలుక మందమైనవి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","అప్పుడు యెహోవా “మనుషులకు నోరు ఇచ్చిన వాడు ఎవరు? మూగ వారిని, చెవిటి వారిని, చూపు గలవారిని, గుడ్డి వారిని అందరినీ పుట్టించినది ఎవరు? యెహోవానైన నేనే గదా. ");
INSERT INTO tel2017_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","కాబట్టి వెళ్లు, నేను నీ నోటికి తోడుగా ఉండి, నువ్వు ఏం మాట్లాడాలో నీకు చెబుతాను” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","మోషే “ప్రభూ, నువ్వు వేరెవరినైనా ఎన్నుకుని అతణ్ణి పంపించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","అందుకు యెహోవా మోషే మీద కోపపడి “లేవీయుడైన నీ అన్న అహరోను ఉన్నాడు గదా? అతడు చక్కగా మాట్లాడగలడని నాకు తెలుసు. అంతేగాక ఇప్పుడు అతడు నిన్ను కలుసుకోవడానికి నీకు ఎదురు వస్తున్నాడు. అతడు నిన్ను బట్టి తన మనసులో సంతోషిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","నువ్వు చెప్పవలసిన మాటలు అతనితో చెప్పు. నేను నీ నోటికీ, అతని నోటికీ తోడుగా ఉంటాను. మీరిద్దరూ ఏమి చేయాలో నేను చెబుతాను. ");
INSERT INTO tel2017_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","అతడే నీ నోరుగా ఉండి నీకు బదులు ప్రజలతో మాట్లాడతాడు. అతనికి నువ్వు దేవుని స్థానంలో ఉన్నట్టు లెక్క. ");
INSERT INTO tel2017_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ఆ చేతికర్రను పట్టుకుని దానితో ఆ అద్భుతాలన్నీ చేయాలి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ఇది జరిగిన తరువాత మోషే తన మామ యిత్రో దగ్గరికి బయలుదేరి వెళ్ళాడు. “నువ్వు అనుమతి ఇస్తే నేను ఐగుప్తులో ఉన్న నా జనుల దగ్గరికి వెళ్తాను, వాళ్ళింకా బతికి ఉన్నారో లేదో చూసి వస్తాను” అన్నాడు. యిత్రో క్షేమంగా వెళ్ళి రమ్మని పంపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","అప్పుడు యెహోవా మిద్యానులో ఉన్న మోషేతో “నిన్ను చంపాలని చూసిన వాళ్ళంతా చనిపోయారు. కాబట్టి ఐగుప్తుకు తిరిగి వెళ్లు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","మోషే తన భార్యబిడ్డలను వెంటబెట్టుకుని గాడిదపై కూర్చోబెట్టి ఐగుప్తుకు ప్రయాణమయ్యాడు. తనతోబాటు దేవుని కర్రను చేతబట్టుకుని వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","అప్పుడు యెహోవా మోషేతో ఇలా చెప్పాడు “నీవు ఐగుప్తుకు చేరిన తరువాత చేయడానికి నేను నీకిచ్చిన అద్భుత కార్యాలు ఫరో సమక్షంలో చెయ్యాలి, అయితే నేను అతని హృదయం కఠినం చేస్తాను. అతడు ఇశ్రాయేలు ప్రజలను వెళ్ళనివ్వడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","అప్పుడు నువ్వు ఫరోతో ఇలా చెప్పు, ‘ఇశ్రాయేలు యెహోవా సంతానం. యెహోవాపెద్ద కొడుకు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","నన్ను సేవించడానికి నా కుమారుణ్ణి వెళ్ళనిమ్మని నీకు ఆజ్ఞాపిస్తున్నాను. నువ్వు గనక వారిని వెళ్ళనియ్యకపోతే నేను నీ కొడుకును, నీ పెద్ద కొడుకును చంపేస్తాను అని యెహోవా చెబుతున్నాడు’ అని అతనితో చెప్పాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ప్రయాణం మధ్యలో వారు బస చేసినప్పుడు యెహోవా వారిని ఎదుర్కొని మోషేను చంపడానికి చూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","మోషే భార్య సిప్పోరా ఒక పదునైన రాయి తీసుకుని తన కొడుక్కి సున్నతి చేసి మర్మాంగ చర్మం కొన మోషే పాదాల దగ్గర పడేసింది. “నువ్వు నిజంగా నా రక్తసంబంధమైన భర్తవి” అని చెప్పింది. ");
INSERT INTO tel2017_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","అప్పుడు యెహోవా అతణ్ణి విడిచిపెట్టాడు. అప్పుడు ఆమె “ఈ సున్నతిని బట్టి నువ్వు నాకు రక్తసంబంధమైన భర్తవయ్యావు” అంది. ");
INSERT INTO tel2017_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","మోషేను కలుసుకోవడానికి ఎడారికి వెళ్ళమని యెహోవా అహరోనుతో చెప్పాడు. అతడు వెళ్లి దేవుని పర్వతం దగ్గర మోషేను కలుసుకుని అతణ్ణి ముద్దు పెట్టుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","అప్పుడు మోషే యెహోవా తనను పంపిన సంగతిని చెప్పమన్న మాటలన్నిటినీ, ఆయన చేయమని ఆజ్ఞాపించిన అద్భుత క్రియలన్నిటినీ గూర్చి అహరోనుకు తెలియజేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","తరువాత మోషే అహరోనులు వెళ్లి ఇశ్రాయేలు ప్రజల పెద్దలందరినీ సమావేశ పరిచారు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","మోషేతో యెహోవా చెప్పిన మాటలన్నిటినీ వారికి అహరోను వివరించాడు. ప్రజలందరి ఎదుటా అద్భుత క్రియలను జరిగించినప్పుడు అందరూ వారి మాటలు నమ్మారు. ");
INSERT INTO tel2017_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","యెహోవా తమ బాధలను కనిపెట్టి తమను దర్శించాడని విన్న ఇశ్రాయేలు ప్రజలు తలలు వంచుకుని ఆయనను ఆరాధించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ఈ విషయాలు జరిగిన తరువాత మోషే అహరోనులు ఫరో దగ్గరికి వెళ్లి “ఇశ్రాయేలు ప్రజల దేవుడు యెహోవా ఆజ్ఞాపిస్తున్నాడు: ఎడారిలో నా కోసం ఉత్సవం చేయడానికి నా ప్రజలను వెళ్ళనివ్వు” అని చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","అందుకు ఫరో “యెహోవా ఎవరు? నేను అతని మాట విని ఇశ్రాయేలీయులను ఎందుకు వెళ్ళనివ్వాలి? నాకు యెహోవా అంటే ఎవరో తెలియదు. ఇశ్రాయేలీయులను వెళ్ళనివ్వను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","అప్పుడు ఆ ఇద్దరూ “హెబ్రీయుల దేవుడు మాతో మాట్లాడాడు. మాకు అనుమతి ఇస్తే మేము ఎడారిలోకి మూడు రోజుల ప్రయాణమంత దూరం వెళ్లి మా దేవుడు యెహోవాకు బలి అర్పిస్తాం, లేని పక్షంలో ఆయన మమ్మల్ని ఏదైనా తెగులుకు, ఖడ్గానికి గురి చేస్తాడేమో” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ఐగుప్తు రాజు “మోషే, అహరోనూ, ఈ ప్రజలు తమ పనులు చేసుకోకుండా మీరు అడ్డు పడుతున్నారేమిటి? పోయి మీ పనులు చూసుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","మా దేశంలో హెబ్రీయుల జనాభా ఇప్పుడు బాగా పెరిగిపోయింది. వాళ్ళంతా తమ పనులు మానుకునేలా మీరు చేస్తున్నారు” అని వాళ్ళతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ఆ రోజున ఫరో ప్రజల గుంపుల నాయకులకు, వారి పైఅధికారులకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ఇటుకలు చేయడానికి ఉపయోగించే గడ్డి ఇకనుండి మీరు ఇవ్వకండి. వాళ్ళే వెళ్లి కావలసిన గడ్డి తెచ్చుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","అయినప్పటికీ వాళ్ళు లెక్క ప్రకారం ఇంతకు ముందు చేసినట్టుగానే ఇటుకల పని చెయ్యాలి. వాళ్ళు సోమరిపోతులు కనుక లెక్క ఏమాత్రం తగ్గించవద్దు. అందుకే వారు ‘మేము వెళ్లి మా దేవునికి బలులు అర్పించడానికి అనుమతి ఇవ్వండి’ అని కేకలు వేస్తున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","అలాంటి వాళ్లకు మరింత కష్టమైన పనులు అప్పగించండి. అప్పుడు వాళ్ళు ఆ అబద్ధపు మాటలు నమ్మకుండా కష్టపడి పని చేసుకుంటారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","కాబట్టి పర్యవేక్షకులు, పై అధికారులు వెళ్లి ప్రజలతో “మేము మీకు గడ్డి ఇయ్యము. ");
INSERT INTO tel2017_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","మీరే వెళ్లి గడ్డి ఎక్కడ దొరుకుతుందో వెతికి సంపాదించుకోండి. అయితే మీ పని ఏమాత్రం తగ్గించము అని ఫరో సెలవిచ్చాడు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","అప్పుడు ప్రజలు గడ్డికి బదులు కొయ్యకాడ పుల్లలు సమకూర్చుకోవడానికి ఐగుప్తు దేశమంతటా చెదిరిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","అంతేకాదు, ఆ పర్యవేక్షకులు వాళ్ళను ఒత్తిడి చేస్తూ “గడ్డి ఇస్తున్నప్పటి లాగానే ఏ రోజు పని ఆ రోజు లెక్క ప్రకారం పూర్తి చేయాలి” అని బలవంతపెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ఫరో ఆస్థాన అధికారులు తాము ఇశ్రాయేలు ప్రజల గుంపులపై నియమించిన ఇశ్రాయేల్ నాయకులను కొట్టారు. “ఇది వరకూ లాగా మీ లెక్క ప్రకారం ఇటుకలు నిన్న, ఈ రోజు ఎందుకు చేయించ లేదు?” అని అడిగారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ఇశ్రాయేలు ప్రజల గుంపులపై నియమించిన తనిఖీదారులు ఫరో దగ్గరికి వచ్చారు. “తమ దాసులమైన మా పట్ల మీరు ఇలా ఎందుకు చేస్తున్నారు? ");
INSERT INTO tel2017_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","తమ దాసులకు గడ్డి ఇవ్వకుండా రోజువారీ లెక్క ప్రకారం ఇటుకలు తయారు చేయమని ఆజ్ఞాపిస్తున్నారు. అధికారులు తమ దాసులైన మా నాయకులను హింసిస్తున్నారు. అసలు తప్పు తమ ఆస్థాన అధికారులదే” అని మొర పెట్టుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","అప్పుడు ఫరో “మీరు సోమరిపోతులు, వట్టి సోమరిపోతులు. అందుకే ‘మేము వెళ్లి యెహోవాకు బలులు అర్పించాలి’ అని అనుమతి అడుగుతున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","మీరు వెళ్లి పని చెయ్యండి. మీకు గడ్డి ఇవ్వడం జరగదు. మీరు మాత్రం లెక్క ప్రకారం ఇటుకలు అప్పగించక తప్పదు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","మీ ఇటుకలు లెక్కలో ఏమాత్రం తగ్గకూడదు, ఏ రోజు పని ఆ రోజే ముగించాలి” అని చెప్పాడు. ఇశ్రాయేలు ప్రజల నాయకులు తాము దుర్భరమైన స్థితిలో కూరుకు పోయామని గ్రహించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","వాళ్ళు ఫరో దగ్గర నుండి తిరిగి వస్తూ, వారిని కలుసుకోవడానికి దారిలో ఎదురు చూస్తున్న మోషే, అహరోనులను కలుసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","వాళ్ళు “యెహోవా మీకు తగిన విధంగా న్యాయం చేస్తాడు గాక. ఫరో ఎదుట, అతని సేవకుల ఎదుట మీరే మమ్మల్ని నీచులుగా చేసి, మమ్మల్ని చంపించడానికి వాళ్ళ చేతులకు కత్తులు ఇచ్చిన వాళ్ళయ్యారు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","మరోసారి మోషే యెహోవా దగ్గరికి వెళ్లి “ప్రభూ, ఈ ప్రజలకు ఎందుకు హాని కలిగించావు? నన్ను ఎందుకు పంపించావు? ");
INSERT INTO tel2017_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","నేను నీ ప్రతినిధిగా మాట్లాడడానికి ఫరో దగ్గరికి వచ్చినప్పటి నుంచి అతడు ఈ ప్రజలకు మరింత హాని కలిగిస్తున్నాడు. నువ్వు నీ ప్రజలను విడిపించడానికి నీవు ఏమీ చేయలేదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","అందుకు యెహోవా “ఫరోకు నేను చేయబోతున్నదంతా నువ్వు తప్పకుండా చూస్తావు. నా బలిష్ఠమైన హస్తం వల్ల అతడు వారిని బయటకు పంపించేలా చేస్తాను. నా హస్త బలం వల్లనే అతడు తన దేశం నుండి ప్రజలను వెళ్ళగొడతాడు.” ");
INSERT INTO tel2017_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ఆయన ఇంకా మోషేతో ఇలా అన్నాడు “నేనే యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","నేను ‘సర్వశక్తి గల దేవుడు’ అనే పేరుతో అబ్రాహాము ఇస్సాకు యాకోబులకు ప్రత్యక్షమయ్యాను. కాని, యెహోవా అనే నా పేరు నేను వారికి తెలియబరచలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","వాళ్ళు పరాయి వారుగా నివాసం చేసిన కనాను దేశాన్ని వారికి ఇస్తానని నేను ఒప్పందం చేశాను. ");
INSERT INTO tel2017_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ఐగుప్తీయులకు బానిసలుగా మారిన ఇశ్రాయేలు ప్రజల నిట్టూర్పులు విని నా నిబంధనను గుర్తు చేసుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","కాబట్టి నువ్వు ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పు. నేనే యెహోవాను. ఐగుప్తీయుల బానిసత్వం కింద ఉన్న మీ కష్టాల నుండి మిమ్మల్ని విడిపిస్తాను. మిమ్మల్ని ఆ దేశం నుండి బయటకు రప్పిస్తాను. వాళ్లకు గొప్ప తీర్పు క్రియలు చూపి, నా చేతులు చాపి వారి బానిసత్వం కింద ఉన్న మిమ్మల్ని విడిపిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","మిమ్మల్ని నా సొంత ప్రజగా నా చెంత చేర్చుకుని మీకు దేవుడైన యెహోవాగా ఉంటాను. అప్పుడు ఐగుప్తీయుల బానిసత్వం కింద నుండి మిమ్మల్ని విడిపించి బయటకు రప్పించిన మీ దేవుడనైన యెహోవాను నేనే అని మీరు తెలుసుకుంటారు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","అబ్రాహాము ఇస్సాకు యాకోబులకు ఇస్తానని నేను చెయ్యి ఎత్తి శపథం చేసిన దేశానికి మిమ్మల్ని రప్పిస్తాను. ఆ దేశాన్ని మీకు సొంతం చేస్తాను. నేను యెహోవాను.” ");
INSERT INTO tel2017_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","మోషే ఇశ్రాయేలు ప్రజలతో దేవుడు చెప్పినదంతా చెప్పాడు. అయితే వాళ్ళు తమ నిరాశ నిస్పృహల వల్ల, కఠినమైన బానిసత్వంలో కూరుకు పోయి ఉండడం వల్ల మోషే మాటలు లక్ష్యపెట్ట లేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","యెహోవా మోషేతో “నువ్వు రాజు ఆస్థానం లోకి వెళ్లి, ");
INSERT INTO tel2017_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","ఐగుప్తు రాజు ఫరోతో ఇశ్రాయేలు ప్రజలను అతని దేశం నుండి బయటకు పంపించమని చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","అప్పుడు మోషే “ఇశ్రాయేలీయులు నా మాట వినకపోతే ఫరో ఎందుకు వింటాడు? నాకు వాక్చాతుర్యం లేదు” అని యెహోవా సముఖంలో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","అప్పుడు యెహోవా మోషే అహరోనులతో “ఇశ్రాయేలు ప్రజలను ఐగుప్తు దేశం నుండి బయటికి తీసుకురావడానికి ఇశ్రాయేలు ప్రజల దగ్గరికి, ఫరో దగ్గరికి మీరు బయలుదేరి వెళ్ళాలి” అని ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","వారి వంశాల మూలపురుషులు వీరు: ఇశ్రాయేలు మొదటి కొడుకైన రూబేను కొడుకులు, హనోకు, పల్లు, హెస్రోను, కర్మీ. వీళ్ళు రూబేను కుటుంబాలు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","షిమ్యోను కొడుకులు యెమూయేలు, యామీను, ఓహదు, యాకీను, సోహరు, కనాను స్త్రీకి పుట్టిన షావూలు. వీళ్ళు షిమ్యోను కుటుంబాలు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","లేవి కొడుకులు వారి వారి వంశావళుల ప్రకారం గెర్షోను, కహాతు, మెరారి. లేవి 137 సంవత్సరాలు జీవించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","గెర్షోను కొడుకులు వారి వారి వంశాల ప్రకారం లిబ్నీ, షిమీ. ");
INSERT INTO tel2017_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","కహాతు కొడుకులు అమ్రాము, ఇస్హారు, హెబ్రోను, ఉజ్జీయేలు. కహాతు 133 సంవత్సరాలు జీవించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","మెరారి కొడుకులు మహలి, మూషి. వీళ్ళు తమ తమ వంశాల ప్రకారం లేవి కుటుంబాలు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","అమ్రాము తన తండ్రి సోదరి యోకెబెదును పెళ్లి చేసుకున్నాడు. వారికి అహరోను, మోషే పుట్టారు. అమ్రాము 137 సంవత్సరాలు జీవించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ఇస్హారు కొడుకులు కోరహు, నెపెగు, జిఖ్రీ. ");
INSERT INTO tel2017_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ఉజ్జీయేలు కొడుకులు మిషాయేలు, ఎల్సాఫాను, సిత్రీ. ");
INSERT INTO tel2017_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","అహరోను అమ్మీనాదాబు కూతురు, నయస్సోను సహోదరి అయిన ఎలీషెబను పెళ్లి చేసుకున్నాడు. వారికి నాదాబు, అబీహు, ఎలియాజరు, ఈతామారు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","కోరహు కొడుకులు అస్సీరు, ఎల్కానా, అబీయాసాపు. వీళ్ళు కోరహీయుల కుటుంబాలు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","అహరోను కొడుకు ఎలియాజరు పూతీయేలు కూతుళ్ళలో ఒకామెను పెళ్లి చేసుకున్నాడు. వారికి ఫీనెహాసు పుట్టాడు. వీళ్ళు తమ తమ కుటుంబాల ప్రకారం లేవీ వంశ నాయకులు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ఇశ్రాయేలు ప్రజలను తమ వంశాల క్రమం ప్రకారం ఐగుప్తు దేశం నుండి బయటకు తీసుకురావాలని యెహోవా ఆజ్ఞాపించింది ఈ అహరోను మోషేలనే. ");
INSERT INTO tel2017_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ఇశ్రాయేలు ప్రజలను ఐగుప్తు నుండి బయటికి పంపించాలని ఐగుప్తు రాజు ఫరోతో మాట్లాడిన మోషే, అహరోనులు వీరే. ");
INSERT INTO tel2017_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ఐగుప్తు దేశంలో యెహోవా మోషేతో మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“నేను యెహోవాను. యెహోవా నీతో చెప్పినది మొత్తం నువ్వు ఐగుప్తు రాజు ఫరోతో చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","అందుకు మోషే “నాకు వాక్చాతుర్యం లేదు. నా మాట ఫరో ఎలా వింటాడు?” అని యెహోవా సముఖంలో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","యెహోవా మోషేతో ఇలా అన్నాడు. “ఇదిగో నిన్ను ఫరోకు దేవుడిగా నియమించాను. నీ అన్న అహరోను నీ మాటలు వినిపించే ప్రవక్తగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","నేను నీకు ఆజ్ఞాపించేదంతా నువ్వు మాట్లాడాలి. ఇశ్రాయేలు ప్రజలను తన దేశం నుండి వెళ్ళనివ్వాలని నీ అన్న అహరోను ఫరోతో చెబుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","అయితే నేను ఫరో హృదయాన్ని కఠినం చేస్తాను. ఆ దేశంలో అనేకమైన అద్భుతాలు, సూచక క్రియలు జరిగిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","అప్పుడు కూడా ఫరో మీ మాట వినడు. కాబట్టి నా చెయ్యి ఐగుప్తు మీద మోపి గొప్ప తీర్పు క్రియలతో నా సేనలు అంటే ఇశ్రాయేలీయులైన నా ప్రజలను ఐగుప్తు దేశం నుండి బయటకు రప్పిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","నేను ఐగుప్తు మీద నా చెయ్యి చాపి వాళ్ళ మధ్య నుండి ఇశ్రాయేలు ప్రజలను బయటకు రప్పించినప్పుడు నేను యెహోవానని ఐగుప్తీయులు తెలుసుకుంటారు.” ");
INSERT INTO tel2017_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","మోషే అహరోనులు యెహోవా తమకు ఆజ్ఞాపించినట్టు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","వారు ఫరోతో మాట్లాడినప్పుడు మోషే వయసు 80 సంవత్సరాలు, అహరోను వయసు 83 సంవత్సరాలు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","యెహోవా మోషే అహరోనులతో ఇలా చెప్పాడు. “మీ దేవుని శక్తి రుజువు చేయడానికి ఏదైనా ఒక అద్భుతం చూపించండి అని మిమ్మల్ని అడిగితే ");
INSERT INTO tel2017_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","నువ్వు అహరోనుకు నీ చేతికర్రను ఇచ్చి దాన్ని ఫరో ముందు పడవెయ్యమని చెప్పు. అది పాముగా మారిపోతుంది.” ");
INSERT INTO tel2017_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","మోషే, అహరోనులు ఫరో దగ్గరికి వెళ్ళారు. యెహోవా వారికి చెప్పినట్టు అహరోను ఫరో ఎదుటా అతని పరివారం ఎదుటా తన కర్రను పడవేసినప్పుడు అది పాముగా మారింది. ");
INSERT INTO tel2017_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","అప్పుడు ఫరో తన దేశంలోని జ్ఞానులను, మాంత్రికులను పిలిపించాడు. ఐగుప్తు దేశపు మాంత్రికులు కూడా తమ మంత్ర శక్తితో అదే విధంగా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","వాళ్ళలో ప్రతి మాంత్రికుడూ తమ కర్రలను పడవేసినప్పుడు అవి పాములుగా మారాయి గాని అహరోను వేసిన కర్ర వాళ్ళు వేసిన కర్రలను మింగివేసింది. ");
INSERT INTO tel2017_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","అయితే యెహోవా చెప్పినట్టు ఫరో హృదయం కఠివంగా మారిపోయింది, అతడు వారి మాట పెడచెవిన పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","తరువాత యెహోవా మోషేతో ఇలా అన్నాడు. “ఫరో హృదయం కఠినంగా మారింది. అతడు ఈ ప్రజలను పంపడానికి ఒప్పుకోవడం లేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ఉదయాన్నే ఫరో నది ఒడ్డుకు వెళ్తాడు. అప్పుడు నువ్వు నది దగ్గర నిలబడి పాముగా అయిన కర్రను పట్టుకుని ఫరోకు ఎదురు వెళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","అతనితో, ‘ఎడారిలో ఆయన్ని సేవించడానికి ఆయన ప్రజలను వెళ్ళనివ్వమని ఆజ్ఞాపించడానికి హెబ్రీయుల దేవుడు యెహోవా నన్ను నీ దగ్గరికి పంపించాడు. ఇంతకు ముందు నువ్వు మా మాట వినలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ఇప్పుడు యెహోవా చెబుతున్నది ఏమిటంటే, ఇదిగో నా చేతిలో ఉన్న ఈ కర్రతో నేను నదిలో ఉన్న నీళ్ళను కొడుతున్నాను. నీళ్లన్నీ రక్తంగా మారిపోతాయి. దీన్ని బట్టి ఆయన యెహోవా అని నీవు తెలుసుకుంటావు ");
INSERT INTO tel2017_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","నదిలోని చేపలన్నీ చనిపోతాయి. నది దుర్వాసన కొడుతుంది. ఐగుప్తీయులు ఆ నీళ్ళు తాగలేకపోతారు’ అని యెహోవా చెబుతున్నాడు.” ");
INSERT INTO tel2017_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","యెహోవా మోషేతో ఇలా అన్నాడు. “నువ్వు అహరోనుతో ఇలా చెప్పు. నీ కర్ర పట్టుకుని ఐగుప్తు నీళ్ళ మీద అంటే, వారి నదుల మీద, కాలువల మీద, చెరువుల మీద, నీటి గుంటలన్నిటి మీదా నీ చెయ్యి చాపు. ఆ నీళ్ళన్నీ రక్తంగా మారిపోతాయి. ఐగుప్తు దేశమంతా చెక్క తొట్లలో, రాతి పాత్రల్లో సహా రక్తం ఉంటుంది.” ");
INSERT INTO tel2017_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","యెహోవా ఆజ్ఞాపించినట్టు మోషే అహరోనులు చేశారు. ఫరో, అతని సేవకులు చూస్తూ ఉండగా అహరోను తన కర్ర పైకెత్తి నది నీళ్లను కొట్టినప్పుడు నది నీళ్లన్నీ రక్తంగా మారిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","నదిలోని చేపలన్నీ చచ్చిపోయాయి, నది నుండి దుర్వాసన కొట్టింది. ఐగుప్తీయులు నది నీళ్లు తాగలేక పోయారు. ఐగుప్తు దేశమంతా రక్తమయం అయింది. ");
INSERT INTO tel2017_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ఐగుప్తు మాంత్రికులు కూడా ఆ విధంగానే చేయగలిగారు. యెహోవా చెప్పినట్టు ఫరో మళ్ళీ తన హృదయం కఠినం చేసుకుని మోషే అహరోనుల మాట వినలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","జరిగిన దాన్ని లక్ష్యపెట్టకుండా ఫరో తన భవనానికి తిరిగి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","అయితే ఐగుప్తీయులందరూ నది నీళ్లు తాగలేకపోయారు. మంచినీళ్ళ కోసం నది ఒడ్డున గుంటలు తవ్వుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","యెహోవా నదిని కొట్టిన తరువాత ఏడు రోజులు గడిచాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","యెహోవా మోషేతో “నువ్వు ఫరో దగ్గరికి వెళ్లి అతనితో ఇలా చెప్పు, ‘నన్ను ఆరాధించి సేవించడానికి నా ప్రజలను పంపించు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","నువ్వు వాళ్ళను వెళ్ళనీయకపోతే నేను నీ సరిహద్దులన్నిటినీ కప్పలతో బాధ పెడతాను. ");
INSERT INTO tel2017_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","నదిలో కప్పలు విపరీతంగా పుట్టుకొస్తాయి. అవి నీ ఇంట్లోకి, నీ పడక గదిలోకి, నీ మంచం పైకి, నీ సేవకుల పైకి, నీ ప్రజల పైకి, నీ పొయ్యిల్లో నీ పిండి పిసికే పాత్రల్లోకి ఎక్కివస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ఆ కప్పలు నీపై, నీ ప్రజలపై, నీ సేవకులందరి పై దాడి చేస్తాయి’ అని యెహోవా చెబుతున్నాడు.” ");
INSERT INTO tel2017_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","యెహోవా మోషేతో ఇంకా ఇలా చెప్పాడు. “నువ్వు అహరోనుతో ‘నీ కర్ర పట్టుకుని నది పాయల మీద, కాలవల మీద, చెరువుల మీద నీ చెయ్యి చాపి ఐగుప్తు దేశం పైకి కప్పలను రప్పించు’ అని చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","అహరోను ఐగుప్తు దేశం లోని నీళ్ళ మీద తన చెయ్యి చాపాడు. అప్పుడు కప్పలు పుట్టుకొచ్చి ఐగుప్తు దేశాన్ని కప్పివేశాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ఐగుప్తు దేశపు మాంత్రికులు కూడా తమ మంత్ర శక్తులు ఉపయోగించి ఐగుప్తు దేశం అంతటా కప్పలను రప్పించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","అప్పుడు ఫరో మోషే అహరోనులను పిలిపించాడు. “నా దగ్గర నుండి, నా ప్రజల దగ్గర నుండి ఈ కప్పలు తొలగిపోయేలా చేయమని యెహోవాను ప్రాధేయపడండి. కప్పలు తొలగిపోతే యెహోవాకు బలులు అర్పించడానికి ఈ ప్రజలను పంపిస్తాను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","అందుకు మోషే “ఈ కప్పలు మీ మీద, మీ ఇళ్ళలో ఉండకుండాా చచ్చి మిగిలినవన్నీ నదిలోనే ఉండిపోయేలా నీ కోసం, నీ సేవకుల కోసం నేను దేవుణ్ణి ఎప్పుడు ప్రాధేయపడాలో నన్ను అడిగే అవకాశం నీదే” అన్నాడు. అప్పుడు ఫరో “రేపే ఆ పని చెయ్యి” అని బదులిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","అందుకు మోషే “మా దేవుడు యెహోవా లాంటి వాడు ఎవ్వరూ లేడు అని నువ్వు గ్రహించేలా నువ్వు కోరుకున్నట్టు జరుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","కప్పలు మీ నుండి, మీ ఇళ్ళ నుండి, నీ సేవకుల, నీ ప్రజల ఇళ్ళనుండి తొలగిపోయి నదిలోకి చేరుకుంటాయి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","మోషే అహరోనులు ఫరో దగ్గర నుండి బయలుదేరి వెళ్ళారు. యెహోవా ఫరో మీదికి రప్పించిన కప్పల విషయం మోషే ఆయనకు మొరపెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","యెహోవా మోషే మాట ఆలకించాడు. ఇళ్ళలో, బయటా, పొలాల్లో ఎక్కడా కప్పలు మిగలకుండా చనిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ప్రజలు వాటిని కుప్పలుగా పడవేసినప్పుడు నేలంతా దుర్వాసన వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ఇబ్బంది నుండి ఉపశమనం కలిగింది. యెహోవా చెప్పినట్టు ఫరో మళ్ళీ తన హృదయం కఠినం చేసుకుని వారి మాట లక్ష్యపెట్టలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","అప్పుడు యెహోవా మోషేతో “నువ్వు నీ కర్రను చాపి ఈ దేశంలో ఉన్న దుమ్మును కొట్టు. ఆ దుమ్ము ఐగుప్తు దేశమంతా చిన్న దోమల్లాగా అలుముకుంటుంది అని అహరోనుతో చెప్పు” అన్నాడు. అప్పుడు వారిద్దరూ ఆ విధంగా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","అహరోను తన కర్రను చాపి ఆ దేశపు దుమ్మును కొట్టినప్పుడు మనుష్యుల మీద, జంతువుల మీద చిన్న దోమలు వచ్చాయి. ఐగుప్తు దేశంలోని దుమ్ము అంతా రేగి దోమల్లాగా వ్యాపించాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","మాంత్రికులు కూడా చిన్నదోమలు పుట్టించాలని తమ మంత్రాలు ప్రయోగించారు గానీ వారి వల్ల కాలేదు. మనుష్యుల మీదా, జంతువుల మీదా చిన్న దోమలు నిలిచి ఉన్నప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","మాంత్రికులు “ఇది దేవుడైన యెహోవా వేలు” అని ఫరోతో చెప్పారు. అయినప్పటికీ యెహోవా చెప్పినట్టు ఫరో హృదయం కఠినం కావడం వల్ల అతడు వారి మాట వినలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","కాబట్టి యెహోవా మోషేతో “నువ్వు ఉదయాన్నే లేచి నది దగ్గర ఉన్న ఫరో ఎదుట నిలిచి అతనితో, నన్ను ఆరాధించడానికి నా ప్రజలను వెళ్లనివ్వు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","నువ్వు నా ప్రజలను వెళ్ళనివ్వని పక్షంలో నేను నీ మీదికీ, నీ సేవకుల మీదికీ, నీ ప్రజలందరి మీదికీ మీ ఇళ్ళలోకీ ఈగల గుంపులను పంపుతాను. ఐగుప్తీయుల ఇళ్ళూ వారు ఉండే ప్రదేశాలూ ఈగల గుంపులతో నిండిపోతాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","భూమిపై నేనే యెహోవాను అని నువ్వు తెలుసుకొనేలా ఆ రోజు నేను నా ప్రజలు నివసిస్తున్న గోషెను దేశాన్ని దీని నుండి మినహాయిస్తాను. అక్కడ ఈగల గుంపులు ఉండవు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","నా ప్రజలను నీ ప్రజల నుండి ప్రత్యేకపరుస్తాను. రేపే ఈ అద్భుత కార్యం జరుగుతుంది అని యెహోవా సెలవిచ్చాడు అని చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","యెహోవా ఆ విధంగా జరిగించాడు. బాధ కలిగించే ఈగల గుంపులు ఫరో ఇంట్లోకి, అతని సేవకుల ఇళ్ళలోకి, ఐగుప్తు దేశమంతా వ్యాపించాయి. ఈగల గుంపులమయమై ఆ దేశమంతా పాడై పోయింది. ");
INSERT INTO tel2017_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","అప్పుడు ఫరో మోషే అహరోనులను పిలిపించాడు. “మీరు వెళ్లి మన దేశంలోనే మీ దేవునికి బలి అర్పించుకోండి” అని వాళ్ళతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","అందుకు మోషే “అలా చేయడం వీలు కాదు. మా దేవుడు యెహోవాకు మేము అర్పించే బలులు ఐగుప్తీయులకు అసహ్యమైనవి. వాళ్లకు అసహ్యమైన బలులు వాళ్ళ కళ్ళ ఎదుటే అర్పిస్తే వాళ్ళు మమ్మల్ని రాళ్లతో కొట్టి చంపరా. ");
INSERT INTO tel2017_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","అందుకేమా దేవుడు యెహోవా మాకు సెలవిచ్చినట్టు మేము ఎడారిలోకి మూడు రోజుల ప్రయాణమంత దూరం వెళ్లి అక్కడ బలులు అర్పిస్తాం” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ఫరో “మీరు ఎడారిలో మీ దేవుడు యెహోవాకు బలులు అర్పించడానికి మిమ్మల్ని వెళ్ళనిస్తాను. అయితే దూరం వెళ్ళవద్దు. ఇంకా నా కోసం కూడా మీ దేవుణ్ణి వేడుకోండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","అందుకు మోషే “నేను నీ దగ్గర నుండి వెళ్లి రేపటి రోజున ఈ ఈగల గుంపులు మీ దగ్గర నుండి, మీ సేవకుల దగ్గర నుండి, నీ ప్రజల దగ్గర నుండి తొలగిపోయేలా యెహోవాను వేడుకొంటాను. అయితే యెహోవాకు బలి అర్పించడానికి ప్రజలను వెళ్ళనీయకుండా ఇకపై మోసం చేయవద్దు” అని చెప్పి ");
INSERT INTO tel2017_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ఫరో దగ్గర నుండి బయలుదేరి వెళ్లి యెహోవాను ప్రార్థించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","యెహోవా మోషే కోరినట్టు జరిగించాడు. ఈగల గుంపులు ఫరో దగ్గర నుండి, అతని సేవకుల దగ్గర నుండి, ప్రజల దగ్గర నుండి ఒక్కటి కూడా మిగలకుండా తొలగిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","అయితే అప్పుడు కూడా ఫరో తన హృదయాన్ని కఠినం చేసుకుని ఇశ్రాయేలు ప్రజలను వెళ్ళనియ్యలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","అప్పుడు యెహోవా మోషేతో ఇలా చెప్పాడు. “నువ్వు ఫరో దగ్గరికి వెళ్లి ఇలా చెప్పు, దేవుడు యెహోవా ఇలా చెప్పమన్నాడు. ‘నన్ను ఆరాధించడానికి నా ప్రజలను వెళ్లనివ్వు.’ ");
INSERT INTO tel2017_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","నువ్వు గనక వాళ్ళను వెళ్ళనివ్వకుండా ఇంకా నిర్బంధంలో ఉంచినట్టయితే, ");
INSERT INTO tel2017_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","యెహోవా చెయ్యి చాపి ఎంతో బాధ కలిగించే తెగులు పంపిస్తాడు. ఆ తెగులు నీ పశువులకు, గుర్రాలకు, గాడిదలకు, ఒంటెలకు, ఎద్దులకు, గొర్రెలకు పాకుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","అయితే యెహోవా ఇశ్రాయేలు ప్రజల పశువులను ఐగుప్తు పశువులను వేరు చేస్తాడు. ఇశ్రాయేలీయులకు చెందిన వాటిలో ఒక్కటి కూడా చనిపోదని హెబ్రీయుల దేవుడు యెహోవా చెబుతున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","దేశంలో రేపు నిర్ణీత సమయానికి యెహోవా ఈ కార్యం జరిగిస్తాడు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","తరువాతి రోజున యెహోవా తెగులు పంపించినప్పుడు ఐగుప్తీయుల పశువులన్నీ చనిపోయాయి. అయితే ఇశ్రాయేలు ప్రజల పశువుల్లో ఒక్కటి కూడా చావలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ఇశ్రాయేలు ప్రజల పశువుల్లో ఒక్కటి కూడా చనిపోలేదనే విషయం ఫరో నిర్ధారణ చేసుకున్నాడు. అయినప్పటికీ ఫరో హృదయం కఠినంగా మారిపోవడం వల్ల ప్రజలను పంపడానికి అంగీకరించలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","అప్పుడు యెహోవా “మీరు మీ పిడికిళ్ల నిండా బూడిద తీసుకోండి. మోషే ఫరో చూస్తూ ఉండగా దాన్ని ఆకాశం వైపు చల్లండి. ");
INSERT INTO tel2017_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","అప్పుడు అది ఐగుప్తు దేశమంతా సన్నని దుమ్ములాగా మారి దేశంలోని మనుష్యుల మీదా, జంతువుల మీదా చీము పట్టే కురుపులు కలగజేస్తుంది” అని మోషే అహరోనులతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","మోషే అహరోనులు బూడిద తీసుకుని ఫరో దగ్గర నిలబడ్డారు. మోషే ఆకాశం వైపు దాన్ని చల్లాడు. దానివల్ల మనుష్యులకు, జంతువులకు చీము కురుపులు పుట్టాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ఆ కురుపుల దురదల వల్ల మాంత్రికులు మోషే ఎదుట నిలబడలేకపోయారు. ఆ కురుపులు మాంత్రికులకు, ఐగుప్తీయులందరికీ పుట్టాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","అయినప్పటికీ యెహోవా మోషేతో చెప్పినట్టు యెహోవా ఫరో హృదయాన్ని కఠినం చేయడం వల్ల అతడు వాళ్ళ మాట వినలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","తరువాత యెహోవా మోషేతో ఇలా చెప్పాడు. “నువ్వు ఉదయం కాగానే లేచి ఫరో ఎదుటికి వెళ్లి అతనితో ఇలా చెప్పు, యెహోవా ఆరాధించడానికి నా ప్రజలను వెళ్లనివ్వు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","భూమి అంతటిలో నాలాంటివాడు ఎవరూ లేరని నీవు తెలుసుకోవాలని నీ హృదయం తీవ్రంగా కలత చెందేలా ఈసారి నేను నా తెగుళ్ళన్నీ నీ సేవకుల పైకి, నీ దేశ ప్రజల పైకి పంపుతాను. ");
INSERT INTO tel2017_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ఇంతకు ముందే నేను నా చెయ్యి చాపి నిన్నూ నీ ప్రజలనూ విపత్తుతో కొట్టి భూమి మీద లేకుండా నాశనం చేసి ఉండేవాణ్ణి. ");
INSERT INTO tel2017_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","నిన్ను బతికి ఉంచిన కారణం నా సామర్ధ్యం నీకు చూపడానికే. తద్వారా భూలోకమంతటా నా పేరు ప్రఖ్యాతి పొందాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","నువ్వు ఇంకా నా ప్రజలను వెళ్ళనీయకుండా వాళ్ళపై మిడిసిపడుతున్నావు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ఇదిగో విను, రేపు ఈ పాటికి నేను తీవ్రమైన బాధ కలిగించే వడగళ్ళు కురిపిస్తాను. ఐగుప్తు సామ్రాజ్యం ఏర్పడినది మొదలు ఇప్పటి వరకూ అలాంటి వడగళ్ళు కురియలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","అందువల్ల నువ్వు నీ పశువులను, పొలాల్లో ఉన్న నీ పంటలనూ త్వరగా భద్రం చేయించుకో. ఇంటికి చేరకుండా పొలంలో ఉన్న ప్రతి వ్యక్తీ ప్రతి జంతువూ వడగళ్ళ బారిన పడి చనిపోతారు.” ");
INSERT INTO tel2017_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","యెహోవా మోషే చేత పలికించిన మాటలు విన్న ఫరో సేవకుల్లో కొందరు తమ పశువులను ఇళ్లలోకి తెప్పించుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","యెహోవా మాట లక్ష్యపెట్టనివారు తమ పనివాళ్ళను, పశువులను పొలంలోనే ఉండనిచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","యెహోవా “నీ చెయ్యి ఆకాశం వైపు చాపు. ఐగుప్తు దేశంలో ఉన్న మనుషుల మీదా, జంతువుల మీదా పంటలన్నిటి మీదా వడగళ్లు కురుస్తాయి” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","మోషే తన కర్రను ఆకాశం వైపు ఎత్తినప్పుడు యెహోవా ఉరుములు వడగండ్లు కురిపించాడు. భూమి మీద పిడుగులు పడుతున్నాయి. ఐగుప్తు దేశం అంతటా యెహోవా వడగళ్ళు కురిపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ఆ విధంగా వడగళ్ళు, వడగళ్ళతో కూడిన పిడుగులు ఎంతో బాధ కలిగించాయి. ఐగుప్తు దేశం ఏర్పడినది మొదలు ఇలాంటిది సంభవించ లేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ఐగుప్తు దేశమంతటా కురిసిన ఆ వడగళ్ళు మనుష్యులను, జంతువులను, బయట ఉండిపోయిన సమస్తాన్నీ నాశనం చేశాయి. పొలంలో ఉన్న పంట అంతా నాశనం అయ్యింది. చెట్లన్నీ విరిగిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","అయితే ఇశ్రాయేలు ప్రజలు నివసించే గోషెను దేశంలో మాత్రం వడగళ్ళు పడలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ఇది చూసిన ఫరో మోషే అహరోనులను పిలిపించాడు. “ఈసారి నేను తప్పు చేశాను. యెహోవా న్యాయవంతుడు, నేనూ నా ప్రజలూ దుర్మార్గులం. ");
INSERT INTO tel2017_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ఇంతవరకూ జరిగింది చాలు. ఈ భయంకరమైన ఉరుములు, వడగళ్ళు ఇంకా రాకుండా యెహోవాను వేడుకోండి. ఇక నేను మిమ్మల్ని ఆపను, మీరు కోరిన చోటికి వెళ్ళనిస్తాను” అని వాళ్ళతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","మోషే అతనితో “నేను ఈ పట్టణం నుండి బయటకు వెళ్ళి నా చేతులు యెహోవా వైపు ఎత్తుతాను. ఈ ఉరుములు ఆగిపోతాయి, వడగళ్ళు ఇకపై కురియవు. దీన్నిబట్టి ఈ లోకమంతా యెహోవాదేనని నువ్వు తెలుసుకొంటావు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","అయినప్పటికీ నీకూ, నీ సేవకులకూ దేవుడు యెహోవా పట్ల భయభక్తులు ఏర్పడలేదని నాకు తెలుసు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ఆ రోజుల్లో జనపనార చెట్లు మొగ్గ తొడిగాయి. బార్లీ చేలు వెన్నులు వేశాయి కనుక అవన్నీ నాశనం అయ్యాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","గోదుమలు, మిరప మొక్కలు మొలకలు వేయనందువల్ల అవి పాడవలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","మోషే ఫరోతో మాట్లాడి ఆ పట్టణం నుండి బయటకు వెళ్లి యెహోవా వైపు తన చేతులు ఎత్తి ప్రార్థించినప్పుడు వాన ఆగిపోయింది. ఉరుములు, వడగళ్ళు నిలిచిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","అయితే వర్షం, వడగళ్ళు, ఉరుములు ఆగిపోవడం చూసిన ఫరో, అతని సేవకులు ఇంకా పాపం చేస్తూ తమ హృదయాలను కఠినం చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","యెహోవా మోషేకు చెప్పినట్టు ఫరో హృదయం కఠినంగా మారింది, అతడు ఇశ్రాయేలు ప్రజలను వెళ్ళనియ్యలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","యెహోవా మోషేతో “ఫరో దగ్గరికి తిరిగి వెళ్ళు. నేను చేసిన అద్భుత కార్యాలను వాళ్ళ మధ్య కనపరచాలని నేను అతడి గుండె, అతని సేవకుల గుండెలు బండబారిపోయేలా చేశాను. ");
INSERT INTO tel2017_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","నేను ఐగుప్తీయుల పట్ల వ్యవహరించిన విధానాన్ని, యెహోవాను నేనేనని మీరు తెలుసుకొనేలా నేను చేస్తున్న అద్భుత కార్యాలను నువ్వు నీ కొడుకులకూ, మనవలకూ తెలియజేయాలి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","మోషే అహరోనులు ఫరో దగ్గరికి వెళ్లి అతనితో ఇలా చెప్పారు. “హెబ్రీయుల దేవుడు యెహోవా చెబుతున్నది ఏమిటంటే, ఎంతకాలం వరకూ నా మాట వినకుండా ఉంటావు? నన్ను ఆరాధించడానికి నా ప్రజలను వెళ్లనివ్వు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","నువ్వు నా ప్రజలను వెళ్ళనివ్వని పక్షంలో రేపు నేను నీ దేశం మీదికి మిడతలను రప్పిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","నేల కనపడనంతగా అవి భూమిని కప్పివేస్తాయి. మీ దేశంలో మిగిలిన దాన్ని అంటే వడగండ్ల దెబ్బ నుండి తప్పించుకున్నదాన్ని, అంటే పొలాల్లో మొలకెత్తిన ప్రతి మొక్కనూ అవి తినేస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","మీ గృహాలూ మీ సేవకుల గృహాలూ ఐగుప్తీయుల ఇళ్ళన్నీ వాటితో నిండిపోతాయి. మీ తండ్రులు, పూర్వికులు ఈ దేశంలో ఉన్నప్పటి నుండి ఈనాటి వరకూ ఇలాంటి వాటిని చూసి ఉండలేదు” అని చెప్పి ఫరో దగ్గర నుండి వెళ్ళిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","అప్పుడు ఫరో సేవకులు ఫరోతో “ఎంతకాలం వరకూ ఈ మనిషి మనలను ఇబ్బందులకు గురిచేస్తాడు? వాళ్ళ దేవుడు యెహోవాను ఆరాధించడానికి ఇశ్రాయేలీయులను వెళ్లనివ్వు. మన ఐగుప్తు దేశం పాడైపోతున్నదని నీకింకా తెలియడం లేదా?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","కాబట్టి మోషే అహరోనులను ఫరో దగ్గరికి తీసుకు వచ్చారు. ఫరో “మీరు వెళ్లి మీ దేవుడు యెహోవాను ఆరాధించుకోండి. ఈ పని కోసం ఎవరెవరు వెళ్తారు?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","అందుకు మోషే “మేము యెహోవాకు మహోత్సవం జరిపించాలి. కాబట్టి మా కొడుకులను, కూతుళ్ళను, మందలను, పశువులను వెంటబెట్టుకుని మా పిల్లలతో, పెద్దలతో కలసి వెళ్తాం” అని బదులిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","అందుకు ఫరో “యెహోవా మీకు కావలిగా ఉంటాడా? నేను మిమ్మల్ని మీ పిల్లలతో సహా వెళ్ళనిస్తానా? చూడండి, మీలో దురుద్దేశం ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","కాబట్టి పురుషులైన మీరు మాత్రమే వెళ్ళి యెహోవాకు ఉత్సవం జరుపుకోండి. మీరు కోరుకున్నది అదే గదా” అన్నాడు. తరువాత వాళ్ళను ఫరో ఎదుట నుండి వెళ్ళగొట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","అప్పుడు యెహోవా మోషేతో “మిడతల దండు వచ్చేలా ఐగుప్తు దేశం మీద నీ చెయ్యి చాపు. అవి ఐగుప్తు మీదకి వచ్చి ఈ దేశంలో ఉన్న పంటలన్నిటినీ అంటే వడగళ్ళ ద్వారా పాడవని పంటలన్నిటినీ తినివేస్తాయి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","మోషే ఐగుప్తు దేశం మీద తన కర్రను చాపాడు. యెహోవా ఆ పగలూ, రాత్రీ ఆ దేశం మీద తూర్పు గాలి వీచేలా చేశాడు. తెల్లవారేసరికి తూర్పు గాలికి ఎగిరే మిడతలు దండుగా వచ్చిపడ్డాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","తీవ్రంగా హాని కలిగించే ఆ మిడతలు ఐగుప్తు దేశమంతటి మీదికీ వచ్చి ఐగుప్తు దేశంలోని అన్ని సరిహద్దుల్లో నిలిచి భూమి మొత్తాన్నీ కప్పివేశాయి. అంతకు ముందెప్పుడూ ఇలాంటి మిడతలు లేవు, ఇకముందు కూడా ఉండబోవు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ఆ దేశమంతా చీకటి కమ్మింది. ఆ దేశంలో కూరగాయలన్నిటినీ వడగళ్ళు పాడు చేయని పంటలన్నిటినీ చెట్లనూ ఫలాలనూ అవి తినివేశాయి. ఐగుప్తు దేశమంతా చెట్లు గానీ పొలాల పంటలు గానీ పచ్చగా ఉండేది ఏదీ మిగలలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","కాబట్టి ఫరో మోషే అహరోనులను వెంటనే పిలిపించాడు. “నేను మీ పట్లా మీ దేవుడు యెహోవా పట్లా తప్పిదం చేశాను. ");
INSERT INTO tel2017_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","దయచేసి ఈ ఒక్కసారి మాత్రం నా తప్పు క్షమించండి. ఈ చావును తెచ్చే విపత్తును మాత్రం నా మీద నుండి తప్పించమని మీ దేవుడైన యెహోవాను వేడుకోండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","మోషే ఫరో దగ్గర నుండి బయలుదేరి వెళ్ళి యెహోవాకు ప్రార్ధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","అప్పుడు యెహోవా, గాలిని తిప్పి శక్తివంతమైన పడమటి గాలి విసిరేలా చేశాడు. ఆ గాలి తీవ్రతకు మిడతలు కొట్టుకుపోయి ఎర్ర సముద్రంలో పడిపోయాయి. ఐగుప్తు దేశమంతటిలో ఒక్క మిడత కూడా మిగలలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","అయితే యెహోవా ఫరో హృదయాన్ని కఠినం చేయడం వల్ల అతడు ఇశ్రాయేలు ప్రజలను వెళ్ళనియ్యలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","అప్పుడు యెహోవా మోషేతో “ఆకాశం వైపు నీ చెయ్యి చాపు. ఐగుప్తు దేశమంతా కటిక చీకటి కమ్ముకుంటుంది” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","మోషే ఆకాశం వైపు తన చెయ్యి ఎత్తినప్పుడు ఐగుప్తు దేశమంతా మూడు రోజులపాటు గాఢాంధకారం కమ్ముకుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ఆ మూడు రోజులు ఒకరికి ఒకరు కనబడలేదు. తామున్న చోటు నుండి ఎవ్వరూ లేచి కదలలేకపోయారు. అయితే ఇశ్రాయేలు ప్రజలందరి ఇళ్ళలో వెలుగు ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ఫరో మోషేను పిలిపించాడు. “మీరు వెళ్లి యెహోవాను ఆరాధించండి. అయితే మీ మందలూ, పశువులూ మాత్రం ఇక్కడే ఉండాలి. మీ బిడ్డలు మాత్రం మీతో వెళ్ళవచ్చు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","అందుకు మోషే “మేము మా దేవుడైన యెహోవాకు అర్పించవలసిన హోమ బలి అర్పణల కోసం నువ్వు మా పశువుల మందలను ఇవ్వ వలసి ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","మా పశువులు, మందలు మాతో కూడా రావాలి. మా పశువుల కాలి గిట్ట కూడా విడిచిపెట్టం. మేము వేటిని యెహోవాకు బలి అర్పించాలో అక్కడికి చేరే వరకూ మాకు తెలియదు. మా దేవుడైన యెహోవాను ఆరాధించే సమయంలో మా మందల్లోనుంచే వాటిని తీసుకోవాలి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","అయితే యెహోవా ఫరో హృదయాన్ని కఠినం చేయడం వల్ల అతడు వారిని వెళ్ళనియ్యలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","అప్పుడు ఫరో “బయటకు వెళ్ళు, జాగ్రత్త సుమా. ఇకపై నాకు కనిపించకు. నువ్వు నాకు ఎదురు పడిన రోజున తప్పకుండా చస్తావు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","అందుకు మోషే “సరే నువ్వే అన్నావు గదా, ఇకపై నీ ముఖం చూడను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. “ఫరో మీదికీ ఐగుప్తు మీదికీ మరొక తెగులు రప్పించబోతున్నాను. దాని తరువాత అతడు ఇక్కడ నుండి మిమ్మల్ని వెళ్ళనిస్తాడు. ఎవ్వరూ మిగలకుండా శాశ్వతంగా అతడు మిమ్మల్ని దేశం నుండి పంపించి వేస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","కాబట్టి ప్రతి పురుషుడు, ప్రతి స్త్రీ ఐగుప్తు జాతి వాళ్ళైన తమ పొరుగువాళ్ళ దగ్గర నుండి వెండి, బంగారు నగలు అడిగి తీసుకోవాలని ఇశ్రాయేలు ప్రజలతో చెప్పాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","యెహోవా ఇశ్రాయేలు ప్రజల పట్ల ఐగుప్తీయులకు కనికరం కలిగేలా చేశాడు. అంతేకాక ఐగుప్తు దేశవాసులు, ఫరో సేవకులు మోషేను చాలా గొప్పగా ఎంచారు. ");
INSERT INTO tel2017_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","మోషే ఫరోతో ఇలా అన్నాడు “యెహోవా చెప్పింది ఏమిటంటే, అర్థరాత్రి నేను బయలుదేరి ఐగుప్తు దేశంలోకి వెళ్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ఐగుప్తు దేశంలో మొదట పుట్టిన సంతానమంతా చనిపోతారు. సింహాసనంపై ఉన్న ఫరో మొదటి సంతానం మొదలుకుని తిరగలి విసిరే పనిమనిషి మొదట పుట్టిన సంతానం దాకా, పశువుల్లో కూడా మొదట పుట్టినవన్నీ చనిపోతాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","అప్పుడు ఐగుప్తు దేశంలో ప్రతి చోటా గొప్ప విలాపం ఉంటుంది. అలాంటి ఏడుపు ఇంతవరకూ ఎన్నడూ పుట్టలేదు, ఇకపై ఎన్నడూ పుట్టదు. ");
INSERT INTO tel2017_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","యెహోవా ఐగుప్తీయుల నుండి ఇశ్రాయేలు ప్రజలను ప్రత్యేకపరుస్తాడని మీరు తెలుసుకొనేలా ఇశ్రాయేలు ప్రజలపై గానీ జంతువులపై గానీ ఇశ్రాయేలు ప్రజల్లో ఏ ఒక్కరి మీదా కుక్క అయినా నాలుక ఆడించదు. ");
INSERT INTO tel2017_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","అప్పుడు నీ సేవకులైన వీరంతా నా దగ్గరికి వస్తారు. నా ఎదుట సాష్టాంగపడి, ‘నువ్వు, నిన్ను అనుసరించే వాళ్ళంతా ఈ దేశం విడిచి బయలుదేరండి’ అని చెబుతారు. అప్పుడు నేను నా ప్రజలతో వెళ్ళిపోతాను” అని చెప్పి మోషే మండిపడుతూ ఫరో దగ్గరనుండి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","అప్పుడు యెహోవా “ఐగుప్తు దేశంలో నేను చేసే అద్భుత క్రియలు అధికం అయ్యేలా ఫరో మీ మాట వినడు” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","మోషే అహరోనులు ఫరో సమక్షంలో ఈ అద్భుతాలు చేశారు. అయినప్పటికీ యెహోవా ఫరో హృదయాన్ని కఠినం చేశాడు. అతడు ఇశ్రాయేలు ప్రజలను తన దేశం నుండి వెళ్ళనియ్యలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","మోషే అహరోనులతో ఐగుప్తు దేశంలో యెహోవా ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“నెలల్లో ఈ నెల మీకు మొదటిది. ఇది మీ సంవత్సరానికి మొదటి నెలన్న మాట. ");
INSERT INTO tel2017_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ఇశ్రాయేలు సమాజంతో ఇలా చెప్పు. మీరు ఇశ్రాయేలు ప్రజల సమాజమంతటితో కలసి ఈ నెల పదవ రోజున తమ కుటుంబాల ప్రకారం ప్రతి ఒక్కడూ, అంటే ప్రతి ఇంటి లెక్క చొప్పున ఒక గొర్రెపిల్లను గానీ, మేకపిల్లను గానీ తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ఒక కుటుంబం ఆ గొర్రెపిల్లను తినడానికి చిన్నదైతే ఆ కుటుంబ పెద్ద ఒక గొర్రె పిల్ల, లేక మేక పిల్ల సరిగ్గా సరిపోయే విధంగా తన పొరుగింటి కుటుంబ సభ్యులను కలుపుకుని ఆ ప్రకారం వారిని లెక్కగట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","మీరు ఎన్నుకొనే గొర్రె లేదా మేక పిల్ల ఒక సంవత్సరం వయసు గల మగదై ఉండాలి. అది ఎలాంటి లోపం లేకుండా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ఈ నెల 14 వ రోజు వరకూ దాన్ని ఉంచాలి. తరువాత ఇశ్రాయేలు ప్రజలంతా సాయంకాల సమయంలో దాన్ని చంపాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","కొంచెం రక్తం తీసుకుని ఆ మాంసం ఏ ఇంట్లో తింటారో ఈ ఇంటి గుమ్మం రెండు నిలువు కమ్ముల మీద, పై కమ్మీ మీద చల్లాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ఆ రాత్రివేళ నిప్పులతో మాంసాన్ని కాల్చి తినాలి. పొంగకుండా చేసిన రొట్టెలతో, చేదు కూరలతో కలిపి దాన్ని తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","దాన్ని పచ్చిగా గానీ ఉడికించిగానీ తినకూడదు. దాని తల, కాళ్ళు, లోపలి భాగాలను నిప్పుతో కాల్చి తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","తెల్లవారే పాటికి దానిలో ఏమీ మిగల్చకూడదు. ఒకవేళ ఏమైనా మిగిలితే దాన్ని పూర్తిగా కాల్చివెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","మీరు దాన్ని తినవలసిన విధానం ఇది. మీ నడుముకు నడికట్టు కట్టుకుని, కాళ్ళకు చెప్పులు వేసుకుని, మీ కర్రలు చేతబట్టుకుని త్వరత్వరగా తినాలి. ఎందుకంటే అది యెహోవాకు పస్కా బలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","నేను ఆ రాత్రి వేళ ఐగుప్తు దేశమంతా తిరుగుతూ ఆ దేశంలోని మనుషుల్లో, జంతువుల్లో మొదటి సంతానం మొత్తాన్ని చంపివేస్తాను. ఐగుప్తు దేవుళ్ళ విషయంలో తీర్పు తీరుస్తాను. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","మీరు నివసించే ఇళ్ళపై ఉన్న ఆ రక్తం యెహోవా రాక విషయంలో మీకు ఆనవాలుగా ఉంటుంది. నేను ఐగుప్తు జాతి మొదటి సంతానాన్ని నాశనం చేస్తూ ఉన్న సమయంలో ఆ రక్తాన్ని చూసి మిమ్మల్ని చంపకుండా దాటి వెళ్ళిపోతాను. ఈ విపత్తు మీ మీదికి వచ్చి మిమ్మల్ని నాశనం చేయదు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","కాబట్టి ఈ రోజు మీకు స్మారక దినంగా ఉంటుంది. ఈ రోజును యెహోవా పండగ దినంగా తరతరాలుగా మీరు ఆచరించాలి. ఎందుకంటే ఇది యెహోవా నియమించిన శాశ్వతమైన కట్టుబాటు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ఏడు రోజులపాటు మీరు పొంగకుండా కాల్చిన రొట్టెలు తినాలి. మొదటి రోజున మీ ఇళ్ళలో పొంగ జేసే పదార్ధమంటూ ఏదీ లేకుండా చెయ్యాలి. మొదటి రోజు నుంచి ఏడవ రోజు వరకూ పొంగ జేసే పిండితో చేసిన రొట్టెలు తింటే ఆ వ్యక్తిని ఇశ్రాయేలు ప్రజల్లో లేకుండా చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ఆ మొదటి రోజు మీరు నా కోసం పరిశుద్ధ సమాజంగా సమకూడాలి. ఏడవ రోజున అలాటి సమావేశమే జరగాలి. ఆ రెండు రోజుల్లో అందరూ తినడానికి భోజనం సిద్ధం చేసుకోవడం తప్ప ఏ పనీ చేయకూడదు. మీరు చేయగలిగిన పని అదొక్కటే. ");
INSERT INTO tel2017_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ఈ పొంగని రొట్టెల పండగను మీరు ఆచరించాలి. ఎందుకంటే నేను మిమ్మల్నందరినీ ఐగుప్తు దేశం నుండి బయటకు తీసుకు వచ్చే రోజు అదే. కాబట్టి మీరు, మీ రాబోయే తరాలన్నీ ఈ రోజును ఆచరించాలి. ఇది మీకు శాశ్వతమైన కట్టుబాటుగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","మొదటి నెల 14 వ రోజు సాయంత్రం మొదలు అదే నెల 21 వ రోజు సాయంత్రం దాకా మీరు పొంగని పిండితో చేసిన రొట్టెలు తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ఏడు రోజులపాటు మీ ఇళ్ళలో పొంగజేసే పదార్ధమేదీ కనబడ కూడదు. పొంగజేసే పదార్ధంతో చేసిన దాన్ని మీలో ఎవరైనా తింటే అతడు విదేశీయుడైనా దేశంలో పుట్టిన వాడైనా ఇశ్రాయేలు ప్రజల సమాజంలో లేకుండా చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","మీరు పొంగజేసే పదార్థంతో చేసిన దేనినీ తినకూడదు. మీకు చెందిన అన్ని ఇళ్ళలో పొంగకుండా కాల్చిన రొట్టెలు మాత్రమే తినాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","అప్పుడు మోషే ఇశ్రాయేలు ప్రజల పెద్దలను పిలిపించాడు. వాళ్ళతో ఇలా చెప్పాడు. “మీరు మీ కుటుంబాల కోసం మందలోనుండి మేకపిల్లను గానీ గొర్రెపిల్లను గానీ తీసుకుని పస్కా బలి అర్పించండి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","తరువాత హిస్సోపు కుంచె తీసుకుని పళ్ళెంలో ఉన్న రక్తంలో దాన్ని ముంచి, గుమ్మాల పైకమ్మికీ రెండు నిలువు కమ్ములకూ పూయాలి. మీలో ఎవ్వరూ తెల్లవారే వరకూ మీ ఇళ్ళ గుమ్మాల గుండా బయటకు వెళ్ళకండి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","యెహోవా ఐగుప్తీయులను హతమార్చడానికి తిరుగుతూ ఇంటి గుమ్మం పైకమ్మి మీదా రెండు నిలువు కమ్ముల మీదా ఉన్న రక్తాన్ని చూసి ఆ ఇంటిని దాటిపోతాడు. సంహారం చేసే దూతను మీ ఇళ్ళలోకి ప్రవేశించడానికి మిమ్మల్ని సంహరించడానికి ఆయన అనుమతి ఇయ్యడు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","అందుచేత మీరు దీన్ని ఆచరించాలి. ఇది మీకు, మీ సంతతికి శాశ్వతమైన చట్టంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","యెహోవా వాగ్దానం చేసినట్టు ఆయన మీకు ఇస్తున్న దేశంలో ప్రవేశించిన తరువాత మీరు దీన్ని ఒక ఆచార క్రియగా పాటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","మీ కొడుకులు ‘మీరు జరిగిస్తున్న ఈ ఆచారం ఎందుకోసం?’ అని మిమ్మల్ని అడిగితే, ");
INSERT INTO tel2017_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","‘ఇది యెహోవాకు పస్కా బలి. ఆయన ఐగుప్తీయులను సంహరించే సమయంలో వారి మధ్య నుండి ఇశ్రాయేలు ప్రజల ఇళ్ళను దాటి ఐగుప్తులో మనల్ని కాపాడాడు’ అని చెప్పాలి” అన్నాడు. అప్పుడు సమకూడిన ప్రజలంతా అది విని తమ తలలు వంచి దేవుణ్ణి ఆరాధించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","అప్పుడు ఇశ్రాయేలు ప్రజలు విధేయులై యెహోవా మోషే అహరోనులకు ఆజ్ఞాపించినట్టు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ఆ అర్థరాత్రి సమయంలో ఏం జరిగిందంటే, ఐగుప్తు దేశంలో ఉన్న మొదటి సంతానమంతటినీ యెహోవా హతమార్చాడు. సింహాసనం మీద కూర్చున్న రాజు మొదలుకుని, చెరసాలలోని ఖైదీల వరకూ వాళ్ళకు పుట్టిన మొదటి పిల్లలు మరణించారు. పశువుల తొలిచూలు పిల్లలు చనిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ఆ రాత్రి గడిచిన తరువాత మరణం సంభవించని ఇల్లు ఒక్కటి కూడా లేదు. ఐగుప్తు దేశంలో తీవ్రమైన మరణ రోదన చెలరేగింది. ");
INSERT INTO tel2017_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ఫరో మోషే అహరోనులను పిలిపించాడు. వాళ్ళతో “మీరూ ఇశ్రాయేలు ప్రజలూ త్వరగా నా దేశం నుండి, నా ప్రజల మధ్యనుండి వెళ్ళిపొండి. మీరు కోరుకున్నట్టు వెళ్లి యెహోవాను ఆరాధించండి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","మీ ఇష్టప్రకారం మీ మందలనూ పశువులనూ తోలుకు వెళ్ళండి. నన్ను దీవించండి కూడా” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ఐగుప్తీయులు మేము కూడా చనిపోతాం అనుకుని ఆత్రంగా ఇశ్రాయేల్ ప్రజను తమ దేశం నుండి వెళ్ళిపొమ్మని తొందర పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ఇశ్రాయేలు ప్రజలు పొంగజేసే పదార్థం కలపని తమ పిండి ముద్దలు, పిండి పిసికే గిన్నెలు మూటగట్టుకుని భుజాలపై మోసుకు పోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","అంతకుముందు ఇశ్రాయేలు ప్రజలు మోషే చెప్పిన మాట ప్రకారం ఐగుప్తీయుల దగ్గర నుండి వెండి, బంగారం నగలు, దుస్తులు అడిగి తీసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ఐగుప్తీయులకు ఇశ్రాయేలు ప్రజల పట్ల యెహోవా జాలి గుణం కలిగించడం వల్ల వారు ఇశ్రాయేలు ప్రజలు అడిగినవన్నీ ఇచ్చారు. ఆ విధంగా వారు ఐగుప్తీయులను దోచుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","తరువాత ఇశ్రాయేలు ప్రజలు రామెసేసు నుండి సుక్కోతు వరకూ ప్రయాణం సాగించారు. వారిలో పిల్లలు కాక, కాలి నడకన బయలుదేరిన పురుషులు ఆరు లక్షల మంది. ");
INSERT INTO tel2017_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","అంతేకాక వేరువేరు జాతుల మనుషులు చాలా మంది వారితో వచ్చారు. గొర్రెలు, ఎద్దులు మొదలైన పశువులతో కూడిన గొప్ప మందలు కూడా వాళ్ళతో కలసి బయలుదేరాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","తరువాత వాళ్ళు ఐగుప్తు నుండి తెచ్చిన పిండి ముద్దలతో పొంగని రొట్టెలు కాల్చారు. ఆ పిండి ముద్ద పులియలేదు. వాళ్ళు ఐగుప్తునుండి బయలు దేరే ముందు సమయం లేకపోవడం వల్ల తమ కోసం వేరే ఆహారం సిద్ధం చేసుకోలేక పోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ఇశ్రాయేలీయులు ఐగుప్తులో నివసించిన కాలం 430 సంవత్సరాలు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ఆ 430 సంవత్సరాలు ముగిసిన రోజునే యెహోవా సేనలన్నీ ఐగుప్తు దేశం నుండి తరలి వెళ్లాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ఆయన ఐగుప్తు దేశం నుండి వారిని బయటికి రప్పించిన ఆ రాత్రి యెహోవా కోసం కేటాయించి ఇశ్రాయేలు ప్రజలంతా తరతరాలకూ ఆ రాత్రి యెహోవా కోసం జాగారం చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","తరువాత యెహోవా మోషే అహరోనులతో ఇలా అన్నాడు. “ఇది పస్కా పండగను గూర్చిన నియమం. వేరే జాతికి చెందిన వాడెవడూ దాన్ని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","మీలో ఎవరైనా డబ్బిచ్చి కొనుక్కున్న దాసుడు సున్నతి పొందితే అలాంటి వాడు దాన్ని తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","వేరే దేశాలకు చెందిన వాళ్ళు, కూలి పనికి వచ్చిన సేవకులు దాన్ని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ఏ ఇంట్లో వారు ఆ ఇంట్లో మాత్రమే దాన్ని తినాలి. దాని మాంసంలో కొంచెం కూడా ఇంట్లో నుండి బయటికి తీసుకు వెళ్ళకూడదు. వధించిన జంతువులోని ఒక్క ఎముకను కూడా మీరు విరగ్గొట్టకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ఇశ్రాయేలు ప్రజల సమాజం అంతా పండగ ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","మీ దగ్గర నివసించే ఎవరైనా విదేశీయులు యెహోవా పస్కాను ఆచరించాలని కోరుకుంటే వాళ్ళ కుటుంబంలోని ప్రతి మగవాడూ సున్నతి పొందాలి. అప్పుడు వాళ్ళు సమాజంతో కలసి పస్కా ఆచరింపవచ్చు. వాళ్ళు మీ దేశంలో పుట్టిన వాళ్ళతో సమానం అవుతారు. సున్నతి పొందనివాడు దాన్ని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","స్వదేశీయుడికీ మీతో కలసి నివసించే విదేశీయుడికీ ఈ విషయంలో ఒకే నియమం ఉండాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","యెహోవా మోషే అహరోనులకు ఇచ్చిన ఆజ్ఞల ప్రకారం ఇశ్రాయేలు ప్రజలందరూ చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ఆ రోజే యెహోవా ఇశ్రాయేలు ప్రజలను వారి వారి సేనల క్రమం ప్రకారం ఐగుప్తు దేశం నుండి బయటకు నడిపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ఇశ్రాయేలు ప్రజల్లో మొదట పుట్టిన సంతానాన్ని నాకు ప్రతిష్టించాలి. మనుషుల, పశువుల ప్రతి తొలిచూలు నాది.” ");
INSERT INTO tel2017_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","అప్పుడు మోషే ప్రజలను సమకూర్చి ఇలా చెప్పాడు. “మీరు ఐగుప్తులో బానిసత్వం నుండి విడుదల పొంది బయటకు వచ్చిన ఈ రోజును జ్ఞాపకం చేసుకోండి. యెహోవా తన బలమైన చేతులు చాపి ఆ దాస్యం నుండి మిమ్మల్ని విడిపించాడు. మీరు పొంగ జేసే పిండితో చేసిన రొట్టెలు తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","అబీబు అనే ఈ నెలలో ఈ రోజునే మీరు బయలుదేరి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","కనానీయులు, హిత్తీయులు, అమోరీయులు, హివ్వీయులు, యెబూసీయులు నివసించే పాలు తేనెలు ప్రవహించే దేశానికి నడిపిస్తానని మన పూర్వీకులతో యెహోవా ఒప్పందం చేశాడు. ఆయన వాగ్దానం చేసినట్టు ఆ దేశానికి మీరు చేరుకున్న తరువాత ఈ ఆచారాన్ని ఈ నెలలోనే జరుపుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","మీరు ఏడు రోజులపాటు పొంగని పదార్థం కలపని పిండితో చేసిన రొట్టెలు తినాలి. ఏడవ రోజు యెహోవా పండగ ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ఏడు రోజులూ పొంగకుండా చేసిన రొట్టెలనే తినాలి. మీ దేశంలో ఈ హద్దు నుంచి ఆ హద్దు వరకూ పొంగే పదార్థం కలిపిన పిండి మీ దగ్గర ఉండకూడదు. పొంగేలా చేసేదేదీ మీ దగ్గర కనబడకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ఆ రోజు మీ పిల్లలకు ‘నేను ఐగుప్తు నుండి వచ్చినప్పుడు యెహోవా నాకు చేసిన దాన్ని బట్టి పొంగకుండా కాల్చిన ఈ రొట్టెలు తింటున్నాను’ అని చెప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","యెహోవా తన బలిష్టమైన చేతితో మిమ్మల్ని ఐగుప్తు నుండి రప్పించాడు. ఆయన ఉపదేశం మీ నోట ఉండేలా, ఈ ఆచారం మీ చేతులపై గుర్తుగా మీ నుదుటిపై జ్ఞాపక చిహ్నంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","అందువల్ల మీరు ప్రతి ఏటా ఈ నియమాన్ని దాని నిర్ణయకాలంలో ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","యెహోవా మీతో మీ పూర్వికులతో వాగ్దానం చేసినట్టు కనాను దేశంలోకి నిన్ను రప్పించిన తరువాత ");
INSERT INTO tel2017_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","మీకు పుట్టే ప్రతి మొదటి సంతానాన్ని, మీ పశువులకు పుట్టే ప్రతి తొలి పిల్లను యెహోవాకు ప్రతిష్ఠించాలి. పశువులకు, మందలకు కలిగే తొలి మగ సంతానం యెహోవాదే. ");
INSERT INTO tel2017_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ప్రతిష్ఠించినది గాడిద పిల్ల అయితే దాని ఖరీదు చెల్లించి విడిపించి దానికి బదులు గొర్రెపిల్లను ప్రతిష్ఠించాలి. అలా విడిపించలేకపోతే దాని మెడ విరగదీయాలి. మీ కొడుకుల్లో మొదట పుట్టిన వారి నిమిత్తం ఖరీదు చెల్లించి వారిని విడిపించుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ఇకముందు మీ కొడుకులు ‘ఇలా ఎందుకు చెయ్యాలి?’ అని అడిగితే, వాళ్ళతో, ‘ఐగుప్తు బానిసత్వంలో ఉన్న మనలను తన బలమైన హస్తం కింద యెహోవా బయటికి రప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ఫరో మనలను వెళ్ళనివ్వకుండా తన మనస్సును కఠినం చేసుకున్నప్పుడు యెహోవా ఐగుప్తు దేశంలో ఉన్న మనుషుల, పశువుల మొదటి సంతానం అంతటినీ సంహరించాడు. అందుకే నేను ప్రతి తొలిచూలు మగ పిల్లలన్నిటినీ యెహోవాకు బలిగా అర్పిస్తాను. మొదట పుట్టిన నా కొడుకుల కోసం ఖరీదు చెల్లించి విడిపించుకుంటాను’ అని చెప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","యెహోవా తన బలమైన హస్తం చేత మనలను ఐగుప్తు నుండి బయటికి రప్పించాడు గనుక నీ చెయ్యి మీదా నొసటి మీదా ఆ సంఘటన జ్ఞాపక సూచనగా ఉండాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ఫరో ఆ ప్రజలను వెళ్ళనిచ్చినప్పుడు దేవుడు వాళ్ళను ఫిలిష్తీయ దేశం నుండి దగ్గర దారి అయినప్పటికీ ఆ దారిన వాళ్ళను వెళ్లనీయలేదు. “ఈ ప్రజలు ఫిలిష్తీయులతో జరిగే యుద్ధం చూసి మనసు మార్చుకుని తిరిగి ఐగుప్తుకు వెళ్లిపోతారేమో” అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","అందువల్ల ప్రజలను చుట్టూ తిప్పి ఎడారి మీదుగా ఎర్ర సముద్రం వైపుకు ప్రయాణం చేయించాడు. ఇశ్రాయేలు ప్రజలు తమ గోత్రాల వారీగా ఐగుప్తు నుండి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","మోషే యోసేపు ఆస్తికలను వెంట తీసుకు వచ్చాడు. ఎందుకంటే యోసేపు “దేవుడు మిమ్మల్ని తప్పకుండా జ్ఞాపకం చేసుకుంటాడు, అప్పుడు మీరు నా ఆస్తికలను ఇక్కడి నుంచి తీసుకు వెళ్ళండి” అని ఇశ్రాయేలు ప్రజలతో కచ్చితంగా ఒట్టు పెట్టించుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","వాళ్ళు సుక్కోతు నుండి ప్రయాణం చేసి ఎడారి దగ్గర ఉన్న ఏతాములో బస చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","పగలు, రాత్రి ప్రయాణాల్లో యెహోవా వారికి తోడుగా ఉన్నాడు. పగటి వేళ స్తంభాకార మేఘంలో రాత్రి వేళ వెలుగు ఇవ్వడానికి స్తంభాకార మంటల్లో ఉండి ఆయన వారికి ముందుగా నడిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","దేవుడు ప్రజల కోసం ఉంచిన పగటి మేఘస్తంభాన్ని, రాత్రి వేళ వెలుగిచ్చే అగ్నిస్తంభాన్ని తొలగించకుండా ప్రయాణం కొనసాగేలా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు, ");
INSERT INTO tel2017_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ఇశ్రాయేలు ప్రజలు వెనక్కి తిరిగి పీహహీరోతు ఎదుట, అంటే మిగ్దోలుకూ, సముద్రానికీ మధ్యలో ఉన్న బయల్సెఫోను దగ్గర విడిది చేయమని వారితో చెప్పు. వాళ్ళు అక్కడ ఉన్నప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ఫరో, ‘ఆ ప్రజలు ఈ దేశంలో ఎడారి మధ్యలో చిక్కుబడిపోయారు’ అనుకుంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","నేను ఫరో హృదయాన్ని కఠినపరుస్తున్నాను. అతడు వాళ్ళను తరుముతాడు. నేను ఫరో ద్వారా, మిగిలిన అతని సేన ద్వారా మహిమ పొందుతాను. నేను యెహోవాను అని ఐగుప్తీయులు తెలుసుకుంటారు.” ");
INSERT INTO tel2017_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ఇశ్రాయేలు ప్రజలు దేశం విడిచి వెళ్ళిపోయిన విషయం ఐగుప్తు రాజుకు చెప్పినప్పుడు ఫరో హృదయం, అతని సేవకుల హృదయాలు ఇశ్రాయేలు ప్రజపై కక్షతో నిండి పోయాయి. “మనం చేసిందేమిటి? మన కోసం పనులు చేయకుండా వాళ్ళను ఎందుకు వెళ్ళనిచ్చాం?” అని చెప్పుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","అప్పుడు ఫరో తన రథాలు సిద్ధం చేయించి తన సైన్యాన్ని వెంట బెట్టుకుని బయలుదేరాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","అతడు తన ఐగుప్తులోని శ్రేష్ఠమైన 600 రథాలను, ప్రతి రథంలోనూ సైన్యాధిపతులను తీసుకు పోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","యెహోవా ఐగుప్తు రాజు ఫరో హృదయాన్ని కఠినం చేసినందువల్ల అతడు ఇశ్రాయేలు ప్రజలను తరిమాడు. ఇశ్రాయేలు ప్రజలు తమ బలగం అంతటితో తరలి వెళ్తున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","బయల్సెఫోను ఎదురుగా ఉన్న పీహహీరోతుకు దగ్గరలో సముద్రం దగ్గర వాళ్ళు విడిది చేసి ఉన్న సమయంలో ఫరో రథాలు, గుర్రాలు, గుర్రాల రౌతులు, ఐగుప్తు సైన్యం ఇశ్రాయేలు ప్రజలను తరుముతూ వాళ్ళను సమీపించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ఫరో, అతని సైన్యం తమను తరుముతూ రావడం చూసిన ఇశ్రాయేలు ప్రజలు హడలిపోయారు. కేకలు వేస్తూ యెహోవాకు మొరపెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","అప్పుడు వాళ్ళు మోషేతో “ఐగుప్తులో సమాధులు లేవని మమ్మల్ని ఈ ఎడారిలో చనిపోవడానికి తీసుకొచ్చావా? మమ్మల్ని ఐగుప్తు నుండి బయటికి తీసుకువచ్చి ఈ విధంగా చేస్తావా? ");
INSERT INTO tel2017_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","మేము ఐగుప్తీయులకు బానిసలుగానే ఉంటాం, మా జోలికి రావద్దు అని ఐగుప్తులో ఉన్నప్పుడే చెప్పింది ఇందుకే గదా. మేము ఈ ఎడారిలో చనిపోవడం కంటే ఐగుప్తులో బానిసలుగా బతకడమే మంచిది” అని నిష్టూరంగా మాట్లాడారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","అందుకు మోషే “భయపడకండి, ఈ రోజు యెహోవా మీకు కలిగించే రక్షణను అలా నిలబడి చూడండి. మీరు ఈ రోజు చూసిన ఐగుప్తీయులను ఇకపై ఎన్నడూ చూడరు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","మీరు ఊరికే నిలబడి ఉండండి. మీ పక్షంగా యెహోవా యుద్ధం చేస్తాడు” అని ప్రజలతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","యెహోవా మోషేతో “నువ్వెందుకు నాకు మొర పెడుతున్నావు? ‘ముందుకు కొనసాగండి’ అని ప్రజలతో చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","నీ కర్ర ఎత్తి ఆ సముద్రం వైపు నీ చెయ్యి చాపి దాన్ని రెండు పాయలుగా చెయ్యి. అప్పుడు ఇశ్రాయేలు ప్రజలు సముద్రం మధ్యలో ఆరిన పొడి నేల మీద నడిచి వెళ్తారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","చూడు, నేను ఐగుప్తీయుల హృదయాలను కఠినం చేస్తాను. వాళ్ళు మీ వెంటబడి తరుముతారు. నేను ఫరో ద్వారా, అతని సైన్యం అంతటి ద్వారా, అతని రథాల, గుర్రపు రౌతుల ద్వారా ఘనత తెచ్చుకొంటాను. ");
INSERT INTO tel2017_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","నేను ఫరో ద్వారా, సైన్యం ద్వారా, అతని రథాల, గుర్రపు రౌతుల ద్వారా ఘనత పొందడం వల్ల నేను యెహోవానని ఐగుప్తీయులు తెలుసుకుంటారు.” ");
INSERT INTO tel2017_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","అప్పటి వరకూ ఇశ్రాయేలు ప్రజల ముందు నడిచిన దేవదూత వాళ్ళ వెనక్కి వెళ్ళాడు. మేఘస్తంభం కూడా వాళ్ళ వెనక్కి వచ్చి నిలిచింది. ");
INSERT INTO tel2017_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","అది ఐగుప్తు సేనలకూ ఇశ్రాయేలు ప్రజల సమూహనికీ మధ్య నిలిచింది. ఆ మేఘం ఆ రాత్రంతా ఐగుప్తు సైన్యానికి చీకటి కమ్మేలా, అదే సమయంలో ఇశ్రాయేలు ప్రజలకు వెలుగు ఉండేలా చేసింది. ");
INSERT INTO tel2017_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","మోషే సముద్రంపై తన చెయ్యి చాపాడు. యెహోవా ఆ రాత్రి అంతా బలమైన తూర్పు గాలి వీచేలా చేసి, సముద్రం పాయలుగా చీలి మధ్యలో ఆరిపోయి పొడి నేల ఏర్పడేలా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","సముద్రం నీళ్లు రెండుగా విడిపోగా ఇశ్రాయేలు ప్రజలు సముద్రం మధ్యలో ఆరిన నేలపై నడిచి వెళ్ళారు. ఆ నీళ్లు వారి కుడి పక్కన, ఎడమ పక్కన గోడల్లాగా నిలబడ్డాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ఫరో సైన్యం, గుర్రాలు, రథాలు, రౌతులు వారిని తరుముకుంటూ సముద్రం మధ్యకు చేరుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","తెల్లవారుతుండగా యెహోవా ఆ అగ్ని స్తంభం నుండీ మేఘ స్తంభం నుండీ ఐగుప్తు సైన్యాన్ని చూసి వాళ్ళను కలవరానికి గురి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ఆయన వాళ్ళ రథచక్రాలు ఊడిపోయేలా చేసినప్పుడు వాళ్ళు అతి కష్టంగా రథాలు తోలవలసి వచ్చింది. అప్పుడు ఐగుప్తువాళ్ళు “రండి, మనం ఇశ్రాయేలు ప్రజల ఎదుట నుండి పారిపోదాం. యెహోవా వారికి తోడుగా ఉండి వాళ్ళ పక్షంగా యుద్ధం చేస్తున్నాడు” అని చెప్పుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","యెహోవా మోషేతో “ఐగుప్తు సైన్యం మీదికి, వాళ్ళ రథాల, రౌతుల మీదికి నీళ్లు తిరిగి వచ్చేలా సముద్రం పైకి నీ చెయ్యి చాపు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","మోషే సముద్రం పైకి తన చెయ్యి చాపాడు. సాయంత్రం అయ్యేటప్పటికి సముద్రం వడిగా మళ్ళీ కలిసిపోయింది. అది చూసిన ఐగుప్తు సైన్యం వెనక్కి పారిపోవాలని చూశారు. అప్పుడు యెహోవా సముద్రం మధ్యలో ఐగుప్తు సైన్యం నాశనమయ్యేలా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","నీళ్లు వేగంగా ప్రవహించి ఆ రథాలను, రౌతులను, వారి వెనుక సముద్రంలోకి వచ్చిన ఫరో సైన్యం మొత్తాన్నీ ముంచివేశాయి. వాళ్ళలో ఒక్కడు కూడా మిగలకుండా అంతా తుడిచిపెట్టుకు పోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","అయితే ఇశ్రాయేలు ప్రజలు సముద్రం మధ్యలో ఆరిన నేలపై నడిచినప్పుడు ఆ నీళ్లు వారికి కుడి, ఎడమ పక్కల గోడల్లాగా నిలబడ్డాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ఆ రోజున యెహోవా ఐగుప్తు సైన్యం నుండి ఇశ్రాయేలు ప్రజలను రక్షించాడు. చనిపోయి ఒడ్డుకు కొట్టుకు వచ్చిన ఐగుప్తు వాళ్ళను ఇశ్రాయేలు ప్రజలు చూశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","తమ కోసం యెహోవా ఐగుప్తు వాళ్ల పట్ల చేసిన ఈ గొప్ప కార్యం చూసిన ఇశ్రాయేలు ప్రజలకు యెహోవా అంటే భయభక్తులు కలిగాయి. ఆ ప్రజలు యెహోవా మీదా, ఆయన సేవకుడు మోషే మీదా నమ్మకముంచారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","అప్పుడు మోషే, ఇశ్రాయేలు ప్రజలు యెహోవాను ఇలా కీర్తించారు. “యెహోవాను గురించి పాడతాను. ఆయన శత్రువు గుర్రాన్నీ, రౌతునూ, సముద్రంలో ముంచి వేశాడు. గొప్ప విజయం సాధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","యెహోవాయే నా బలం, నా గానం, నా రక్షణకర్త. ఆయన నా దేవుడు, ఆయనను స్తుతిస్తాను. ఆయన నా పూర్వీకుల దేవుడు, ఆయనను ఘనపరుస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","యెహోవా యుద్ధశూరుడు, ఆయన పేరు యెహోవా. ");
INSERT INTO tel2017_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ఆయన ఫరో రథాలను, సైన్యాన్ని సముద్రంలో ముంచివేశాడు. సైన్యాధిపతుల్లో ప్రముఖులు ఎర్ర సముద్రంలో మునిగిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","రాళ్లవలె వాళ్ళు నడి సముద్రం అడుక్కి చేరుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","యెహోవా, నీ కుడి చెయ్యి బలిష్ఠమైనది. యెహోవా, నీ కుడిచెయ్యి శత్రువుని అణిచి వేస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","నీకు విరోధంగా నీపై లేచేవాళ్లను నీ మహిమా ప్రకాశంతో అణచి వేస్తావు. నీ కోపాగ్ని రగిలినప్పుడు వాళ్ళు చెత్తలాగా కాలిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","నీ ముక్కుపుటాల నుండి వెలువడిన పెనుగాలికి నీళ్లు కుప్పగా నిలబడిపోయాయి. ప్రవాహాలు గోడలాగా నిలబడి పోయాయి. సముద్రం లోతుల్లో నీళ్ళు గడ్డకట్టిపోయాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","‘వాళ్ళను తరిమి నా కత్తి దూసి నాశనం చేసి దోచుకున్న సొమ్ముతో నా కోరిక తీర్చుకుంటాను’ అని శత్రువు అనుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","నువ్వు నీ గాలి విసిరి లోతైన నీళ్ళలో సీసం లాగా వాళ్ళను మునిగి పోయేలా చేశావు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","పూజింపదగ్గ వాళ్ళలో యెహోవాలాంటివాడు ఎవడు? పవిత్రత వైభవంలో నీ వంటి వాడెవడు? స్తుతికీర్తనలతో ఘనపరచదగిన వాడు, అద్భుతాలు చేసే నీవంటి వాడెవడు? ");
INSERT INTO tel2017_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","నీ కుడి చెయ్యి చాపినప్పుడు వాళ్ళను భూమి మింగివేసింది. ");
INSERT INTO tel2017_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","నీ కనికరం వల్ల ఈ ప్రజలను విడిపించి నీ శక్తి ద్వారా నీ సన్నిధికి తీసుకువచ్చావు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ఈ సంగతి ఇతర ప్రజలకు తెలుస్తుంది. వాళ్ళు భయపడతారు. అది ఫిలిష్తీయులకు భయం కలిగిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ఎదోము అధిపతులు భయపడతారు. మోయాబులో బలిష్ఠులు వణికిపోతారు. కనానులో నివసించే వారు భయంతో నీరసించి పోతారు, ");
INSERT INTO tel2017_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","భయ భీతులు వారిని ఆవరిస్తాయి. యెహోవా, నీ ప్రజలు అవతలి తీరం చేరే వరకూ నీ హస్తబలం చేత శత్రువులు రాళ్ళ వలే కదలకుండా నిలిచిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","నువ్వు నీ ప్రజలకు స్థిర నివాసంగా ఏర్పాటు చేసిన వారసత్వ పర్వతానికి తెస్తావు. అక్కడ వారిని నాటుతావు. యెహోవా, నీ చేతులు నిర్మించిన మందిరానికి వారిని తెస్తావు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","యెహోవా, శాశ్వతంగా రాజ్యం చేస్తాడు.” ");
INSERT INTO tel2017_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ఫరో గుర్రాలు, రథాలు, రౌతులు సముద్రంలోకి అడుగుపెట్టగానే యెహోవా వాళ్ళ మీదికి సముద్రపు నీళ్ళు పొంగిపొరలేలా చేశాడు. అయితే ఇశ్రాయేలు ప్రజలు సముద్రం మధ్యలో ఆరిన నేల మీద నడిచారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","అహరోను సోదరి, ప్రవక్త్రి మిర్యాము తంబుర వాయిస్తూ బయలుదేరింది. స్త్రీలంతా తంబురలు వాయిస్తూ, నాట్యం చేస్తూ ఆమెను వెంబడించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","మిర్యాము వాళ్ళతో కలిసి ఈ విధంగా పాడింది. ");
INSERT INTO tel2017_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","మోషే నాయకత్వంలో ప్రజలు ఎర్ర సముద్రం దాటిన తరువాత మూడు రోజులు ప్రయాణించి షూరు ఎడారి ప్రాంతానికి చేరుకున్నారు. అక్కడ వాళ్ళకు తాగడానికి నీళ్లు దొరకలేదు. తరువాత మారాకు చేరుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","మారాలో ఉన్న నీళ్ళు చేదుగా ఉన్నాయి కనుక ఆ నీళ్లు తాగలేకపోయారు. అందువల్ల దానికి మారా అనే పేరు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ప్రజలు మోషే మీద సణుగుతూ “మేమేమీ తాగాలి?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","మోషే యెహోవాను వేడుకున్నాడు. అప్పుడు యెహోవా మోషేకు ఒక చెట్టును చూపించాడు. దాన్ని ఆ నీళ్లలో వేసిన తరువాత నీళ్లు తియ్యగా మారిపోయాయి. అక్కడ ఆయన వాళ్లకు ఒక కట్టుబాటును, శాసనాన్ని విధించాడు, ");
INSERT INTO tel2017_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“మీరు మీ దేవుడైన యెహోవా మాటలు శ్రద్ధగా విని ఆయన దృష్టిలో న్యాయం జరిగించి, ఆయన ఆజ్ఞలకు విధేయత కనపరచి వాటి ప్రకారం నడుచుకుంటే ఐగుప్తు వాళ్ళకు కలిగించిన ఎలాంటి జబ్బూ మీకు రానియ్యను. యెహోవా అనే నేనే మిమ్మల్ని బాగుచేసేవాణ్ణి.” ");
INSERT INTO tel2017_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","తరువాత వాళ్ళు ఏలీముకు చేరుకున్నారు. అక్కడ పన్నెండు నీటి ఊటలు, డెబ్భై ఈత చెట్లు ఉన్నాయి. నీళ్ళు ఉన్న ఆ ప్రాంతంలో వాళ్ళు విడిది చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","తరువాత ఇశ్రాయేలు ప్రజలంతా ఏలీము నుండి బయలుదేరి వారు ఐగుప్తు నుండి బయటకు వచ్చిన రెండవ నెల పదిహేనోరోజున ఏలీముకు సీనాయికి మధ్య ఉన్న సీను ఎడారి ప్రాంతానికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","అక్కడ ఇశ్రాయేలు ప్రజలందరూ మోషే, అహరోనుల మీద సణుగుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ప్రజలు వారితో “మేము ఐగుప్తులో ఉన్నప్పుడు మాంసం వండుకుని కుండల దగ్గర కూర్చుని తృప్తిగా భోజనం చేసేవాళ్ళం. ఆ సమయంలోనే యెహోవా చేతిలో మేము చనిపోయి ఉన్నట్టయితే బాగుండేది. మేమంతా ఆకలితో చనిపోవడం కోసం ఇక్కడికి తీసుకు వచ్చారు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","యెహోవా మోషేతో ఇలా చెప్పాడు. “నేను ఆకాశం నుండి మీ కోసం ఆహారం కురిపిస్తాను. ప్రతిరోజూ ప్రజలు వెళ్లి ఆనాటికి సరిపడేటంత ఆహారం సమకూర్చుకోవాలి. వాళ్ళు నా ఉపదేశం ప్రకారం నడుచుకుంటున్నారో లేదో నేను పరిశీలిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ఆరవ రోజున వాళ్ళు మిగతా అన్ని రోజుల కంటే రెండింతలు సేకరించుకుని తెచ్చుకున్నది వండుకోవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","మోషే, అహరోనులు ఇశ్రాయేలు ప్రజలతో ఇలా అన్నారు. “మీరు మా మీద ఎందుకు సణుక్కుంటారు? మేము ఎంతటి వాళ్ళం? యెహోవా మీద మీరు సణిగిన సణుగులను ఆయన విన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ఐగుప్తు దేశం నుండి యెహోవాయే మిమ్మల్ని బయటికి రప్పించాడని సాయంత్రం నాటికి మీరు తెలుసుకుంటారు. రేపు ఉదయానికి మీరు యెహోవా మహిమా ప్రభావం చూస్తారు.” ");
INSERT INTO tel2017_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","మోషే వాళ్ళతో “మీరు సాయంత్రం తినడానికి మాంసం, ఉదయాన సరిపడినంత ఆహారం యెహోవా మీకు ఇస్తున్నప్పుడు మీరు ఇది తెలుసుకుంటారు. మీరు ఆయన మీద సణుక్కోవడం ఆయన విన్నాడు. మీరు సణుక్కోవడం యెహోవా మీదే, మా మీద కాదు. మాపై సణుక్కోవడానికి మేమెంతటివాళ్ళం?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","మోషే అహరోనులతో యెహోవా “ప్రజల సర్వ సమాజంతో ఇలా చెప్పు, ఆయన మీ సణుగులు విన్నాడు. సర్వ సమాజం అంతా యెహోవా సన్నిధికి రండి.” ");
INSERT INTO tel2017_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","అహరోను ఇశ్రాయేలు సమాజమంతటితో మాట్లాడుతున్న సమయంలోనే ప్రజలు ఎడారి వైపు చూశారు. అప్పుడు మేఘంలో యెహోవా మహిమ వాళ్లకు కనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","అప్పుడు యెహోవా మోషేతో ఇలా అన్నాడు. “నేను ఇశ్రాయేలు ప్రజల సణుగులు విన్నాను. ");
INSERT INTO tel2017_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","వాళ్ళతో ఇలా చెప్పు. సాయంత్రం పూట మీరు మాంసం తింటారు, ఉదయం పూట తృప్తిగా ఆహారం తింటారు. అప్పుడు నేను మీ దేవుడైన యెహోవాను అని మీరు తెలుసుకుంటారు.” ");
INSERT INTO tel2017_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","అలాగే జరిగింది. సాయంకాలం అయినప్పుడు పూరేడు పిట్టలు వచ్చి శిబిరం అంతా కమ్ముకున్నాయి. ఉదయమయ్యాక శిబిరం అంతా మంచు పడి ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","నేలపై మంచు ఇంకిపోయాక నేలమీద సన్నని కణాలు పొరలుగా ఎడారి భూమి మీద కనబడ్డాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ఇశ్రాయేలీయులు దాన్ని చూసి, అది ఏమిటో తెలియక “ఇదేంటి?” అని ఒకరితో ఒకరు చెప్పుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","మోషే వాళ్ళతో “ఇది తినడానికి యెహోవా మీకిచ్చిన ఆహారం. యెహోవా ఏమి చెబుతున్నాడంటే, ప్రతి ఒక్కరూ తమకు అవసరమైనంత మేరకు సేకరించుకోవాలి. తమ గుడారంలో ఉన్న వాళ్ళ కోసం ప్రతి ఒక్కరికీ ఒక ఓమెరు చొప్పున తీసుకోవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ఇశ్రాయేలు ప్రజలు ఆ విధంగా చేశారు. అయితే కొందరు ఎక్కువగా, కొందరు తక్కువగా కూర్చుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","వాళ్ళు కొలత ప్రకారం చూసినప్పుడు ఎక్కువగా తీసుకొన్న వారికి ఏమీ మిగల్లేదు, తక్కువ తీసుకొన్నవారికి ఏమీ తక్కువ కాలేదు. ప్రతి ఒక్కరూ తమ అవసరం మేరకు తమ ఇంటి వాళ్ళ భోజనానికి సరిపడినంత సమకూర్చుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","అప్పుడు మోషే “ఉదయమయ్యే దాకా ఎవ్వరూ దీన్లో ఏమీ మిగుల్చుకోకూడదు” అని వాళ్ళతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","అయితే కొందరు మోషే మాట వినకుండా తెల్లవారే దాకా దానిలో కొంచెం మిగుల్చుకున్నారు. మోషే వారిపై కోపగించుకున్నాడు. అది పురుగు పట్టి దుర్వాసన కొట్టింది. ");
INSERT INTO tel2017_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","కాబట్టి ప్రతి ఒక్కరూ ప్రతి ఉదయమూ తమ ఇంటివారి కోసం ఏ రోజుకు సరిపడినది ఆ రోజు సేకరించుకున్నారు. ఎండ ఎక్కువైనప్పుడు అది కరిగిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ఆరవ రోజున వాళ్ళు ఒక్కొక్కరు రెండు లీటర్లకు రెట్టింపు లెక్క చొప్పున నాలుగు లీటర్లు సేకరించారు. ప్రజల అధికారులు వచ్చి ఆ విషయం మోషేకు చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","అందుకు మోషే “యెహోవా చెప్పిన మాట ఇదే. రేపు వివేచనాపూర్వక విశ్రాంతి దినం. అది యెహోవాకు గౌరవార్థం ఆచరించ వలసిన పవిత్ర విశ్రాంతి దినం. మీరు వండుకోవలసింది వండుకోండి, ఉడికించుకోవలసింది ఉడికించుకోండి. తినగా మిగిలినది రేపటికి ఉంచుకోండి.” ");
INSERT INTO tel2017_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","మోషే ఆజ్ఞాపించిన ప్రకారం వాళ్ళు తెల్లవారే వరకూ దాన్ని ఉంచుకున్నారు. అది దుర్వాసన వేయలేదు, దానికి పురుగు పట్టలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","అప్పడు మోషే “ఈ రోజు దాన్ని తినండి, ఈ రోజు యెహోవాకు విశ్రాంతి దినం, నేడు అది బయట మైదానంలో దొరకదు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","మీరు ఆరు రోజులే దాన్ని సమకూర్చుకోవాలి. విశ్రాంతి దినమైన ఏడవ రోజున అది దొరకదు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ఆ విధంగానే జరిగింది. ప్రజల్లో కొందరు ఏడవ రోజున దాన్ని ఏరుకోవడానికి వెళ్ళారు గానీ వాళ్లకు ఏమీ దొరకలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","అందుచేత యెహోవా మోషేతో ఇలా అన్నాడు “మీరు ఎంతకాలం నా ఆజ్ఞలను, ఉపదేశాన్ని అనుసరించి నడుచుకోకుండా ఉంటారు? ");
INSERT INTO tel2017_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","వినండి, యెహోవా ఈ విశ్రాంతి దినాన్ని తప్పకుండా ఆచరించాలని సెలవిచ్చాడు. కనుక ఆరవ రోజున రెండు రోజులకు సరిపడే ఆహారం మీకు ఇస్తున్నాడు. ఏడవ రోజున ప్రతి ఒక్కరూ తమ స్థలాల్లోనే ఉండిపోవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","అందువలన ఏడవ రోజున ప్రజలు విశ్రాంతి తీసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ఇశ్రాయేలీయులు ఆ పదార్థానికి “మన్నా” అని పేరు పెట్టారు. అది తెల్లగా ధనియాల వలే ఉంది. దాని రుచి తేనెతో కలిపిన పిండి వంటకం లాగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","మోషే ఇలా చెప్పాడు “యెహోవా ఏమి చెబుతున్నాడంటే, ఈ మన్నాను ఒక ఓమెరు పట్టే పాత్రలో నింపండి. నేను ఐగుప్తు దేశం నుండి మిమ్మల్ని బయటికి రప్పించి ఎడారిలో తినడానికి మీకిచ్చిన ఈ ఆహారాన్ని మీ తరతరాల కోసం మీ వంశాల కోసం వాళ్ళు దగ్గర ఉంచుకోవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","అప్పుడు మోషే అహరోనుతో “నువ్వు ఒక గిన్నె తీసుకుని, దాన్ని ఒక ఓమెరు మన్నాతో నింపి, మీ తరతరాల సంతతి కోసం యెహోవా సన్నిధిలో ఉంచు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","యెహోవా మోషేకు ఇచ్చిన ఆజ్ఞ ప్రకారం చేశాడు. ఆది భద్రంగా ఉండేలా శాసనాలు ఉంచే స్థలం ఎదుట ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","తాము చేరుకోవలసిన కనాను దేశపు సరిహద్దుల వరకూ నలభై సంవత్సరాల వాళ్ళ ప్రయాణంలో మన్నా తింటూ వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ఓమెరు అంటే ఏఫాలో పదవ వంతు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","యెహోవా మాట ప్రకారం ఇశ్రాయేలు ప్రజల సమూహమంతా సీను ఎడారి ప్రాంతం నుండి ప్రయాణం చేసి రెఫీదీములో దిగారు. అక్కడ ప్రజలు తాగడానికి నీళ్ళు లేవు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","దానికి వాళ్ళు మోషే పై నింద మోపుతూ “మాకు తాగడానికి నీళ్లియ్యి” అన్నారు. అప్పుడు మోషే “మీరు నాతో ఎందుకు పోట్లాడుతున్నారు? యెహోవాను ఎందుకు శోధిస్తున్నారు?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ప్రజలు దాహంతో మోషే మీద సణుగుతూ “ఇదేంటి? మమ్మల్ని, మా పిల్లలను, మా పశువులను దాహంతో చంపడానికి ఐగుప్తు నుండి ఇక్కడికి తీసుకువచ్చావా?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","అప్పుడు మోషే యెహోవాకు మొరపెట్టాడు. “ఈ ప్రజలను నేనేం చెయ్యాలి? కొంచెం సేపట్లో వీళ్ళు నన్ను రాళ్లతో కొట్టి చంపుతారేమో” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","అప్పుడు యెహోవా “ప్రజల పెద్దల్లో కొందరిని వెంటబెట్టుకుని నువ్వు నదిని కొట్టిన నీ కర్రను చేతబట్టుకుని ప్రజలకు ఎదురుగా వెళ్లి నిలబడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","నేను అక్కడ హోరేబులోని బండ మీద నీకు ఎదురుగా నిలబడతాను. నువ్వు ఆ బండను కర్రతో కొట్టు. అప్పుడు ప్రజలు తాగడానికి ఆ బండలో నుంచి నీళ్లు బయటకు వస్తాయి” అని మోషేతో చెప్పాడు. మోషే ఇశ్రాయేలు ప్రజల పెద్దల కళ్ళెదుట ఆ విధంగా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","అప్పుడు మోషే ఇశ్రాయేలు ప్రజలు చేసిన గొడవనుబట్టి, వారు “యెహోవా మన మధ్య ఉన్నాడా, లేడా?” అని యెహోవాను శోధించడాన్నిబట్టి ఆ స్థలానికి “మస్సా” అనీ “మెరీబా” అనీ పేర్లు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","తరువాత అమాలేకీయులు వచ్చి రెఫీదీములో ఇశ్రాయేలు ప్రజలతో యుద్ధానికి సిద్ధమయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","మోషే యెహోషువతో “మన కోసం కొంతమందిని సిద్ధం చేసి బయలుదేరి అమాలేకీయులతో యుద్ధం చెయ్యి. నేను రేపు దేవుని కర్ర చేత్తో పట్టుకుని ఆ కొండ శిఖరంపై నిలబడతాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","యెహోషువ మోషే తనతో చెప్పినట్టు అమాలేకీయులతో యుద్ధానికి వెళ్ళాడు. మోషే, అహరోను, హూరు ఆ కొండ శిఖరం ఎక్కారు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","మోషే తన చెయ్యి పైకెత్తి ఉంచినప్పుడు ఇశ్రాయేలు ప్రజలు గెలుస్తున్నారు, మోషే తన చెయ్యి దించినప్పుడు అమాలేకీయులు గెలవ సాగారు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","మోషే చేతులు బరువెక్కినప్పుడు అహరోను, హూరు ఒక రాయి తెచ్చి మోషేను దానిపై కూర్చోబెట్టారు. అహరోను, హూరు ఇద్దరూ మోషేకు అటు ఇటు ఆనుకుని నిలబడి సూర్యుడు అస్తమించేదాకా అతని చేతులు ఎత్తి పట్టుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ఆ విధంగా యెహోషువ కత్తి బలంతో అమాలేకు రాజును, అతని సైన్యాన్ని ఓడించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","అప్పుడు యెహోవా మోషేతో “చిరకాలం జ్ఞాపకం ఉండేలా పుస్తకంలో ఈ విషయం రాసి అది యెహోషువకు వినిపించు. నేను అమాలేకీయులను ఆకాశం కింద నామరూపాలు లేకుండా పూర్తిగా తుడిచి పెట్టేస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","తరువాత మోషే ఒక బలిపీఠం కట్టి దానికి “యెహోవా నిస్సీ” అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","అమాలేకీయులు యెహోవా సింహాసనానికి వ్యతిరేకంగా చెయ్యి ఎత్తారు గనక “యెహోవాకు అమాలేకీయులతో తరతరాలకు వైరం ఉంటుంది అని యెహోవా శపథం చేశాడు” అన్నాడు కాబట్టి అతడు ఇలా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","యెహోవా ఇశ్రాయేలు ప్రజలను ఐగుప్తు నుండి బయటకు రప్పించిన సంగతి, మోషేకు, అతని ప్రజలైన ఇశ్రాయేలీయులకు జరిగించినదంతా మిద్యానులో యాజకుడైన మోషే మామ యిత్రో విన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","మోషే మామ యిత్రో మోషే తన దగ్గరికి పంపిన మోషే భార్య సిప్పోరాను, ");
INSERT INTO tel2017_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ఆమె ఇద్దరు కొడుకులను వెంటబెట్టుకుని మోషే దగ్గరికి బయలుదేరాడు. వారిలో ఒకడి పేరు గెర్షోము. ఎందుకంటే మోషే “నేను అన్య దేశంలో పరాయివాణ్ణి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","రెండో వాడి పేరు ఎలియాజరు. ఎందుకంటే “నా పూర్వీకులు దేవుడే నాకు సహాయం. ఆయన ఫరో ఖడ్గం నుండి నన్ను రక్షించాడు” అని అతడు అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","మోషే మామ యిత్రో అతని కుమారులనిద్దరినీ అతని భార్యనూ వెంటబెట్టుకుని ఎడారిలో దేవుని పర్వతం దగ్గర బస చేసిన మోషే దగ్గరికి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","“నీ మామ యిత్రో అనే నేనూ నీ భార్య, ఆమెతో కలసి ఆమె ఇద్దరు కొడుకులు నీ దగ్గరికి వస్తున్నాము” అని మోషేకు కబురు పంపాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","మోషే తన మామకు ఎదురు వెళ్ళాడు. అతనికి వందనం చేసి ముద్దు పెట్టుకున్నాడు. ఒకరినొకరు యోగక్షేమాలు తెలుసుకుని గుడారంలోకి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","తరువాత యెహోవా ఇశ్రాయేలు ప్రజల పక్షంగా ఫరోకు, ఐగుప్తీయులకు చేసినదీ మార్గంలో తమకు సంభవించిన కష్టాలూ వాటి నుండి యెహోవా తమను విడిపించిన విషయం మోషే తన మామకు వివరంగా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","యెహోవా ఐగుప్తీయుల చేతిలో నుండి విడిపించడంలో ఇశ్రాయేలు ప్రజలకు చేసిన మేళ్ళు విని యిత్రో సంతోషించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","యిత్రో “ఐగుప్తీయుల చేతిలో నుండి, ఫరో చేతిలో నుండి మిమ్మల్ని విడిపించి, ఐగుప్తీయుల కింద బానిసత్వం నుండి ఈ ప్రజలను విడిపించిన యెహోవాకు స్తుతి కలుగు గాక. ");
INSERT INTO tel2017_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","యెహోవాయే మిగిలిన దేవుళ్ళ కంటే గొప్పవాడని ఇప్పుడు నాకు తెలిసింది. ఎందుకంటే ఇశ్రాయేలీయుల పట్ల అహంకారంతో మెలిగిన ఐగుప్టు వారి వశంనుండి ఆయన తన ప్రజలను రక్షించాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","మోషే మామ యిత్రో హోమబలి, ఇతర బలులు దేవునికి అర్పించాడు. అహరోను, ఇశ్రాయేలు ప్రజల పెద్దలు మోషే మామతో కలిసి దేవుని సన్నిధిలో భోజనం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","మోషే మరుసటి రోజు ప్రజలకు న్యాయం తీర్చడానికి కూర్చున్నాడు. పొద్దుటి నుంచి సాయంత్రం వరకూ ప్రజలు మోషే దగ్గర బారులు తీరి నిలబడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ప్రజల విషయంలో మోషే చేస్తున్నదంతా యిత్రో చూశాడు. అతడు మోషేతో “నువ్వు ఈ ప్రజలకు చేస్తున్నదేమిటి? ఉదయం నుండి సాయంత్రం దాకా నువ్వొక్కడివే తీర్పరిగా కూర్చుని ఉంటే మిగిలిన వాళ్ళంతా నీ చుట్టూ నిలబడి ఉండడం ఏమిటి?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","మోషే “దేవుని నిర్ణయం ఏమిటో తెలుసుకోవడం కోసం వాళ్ళు నా దగ్గరికి వస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","వాళ్ళ మధ్య ఏవైనా గొడవలు వస్తే వాటి పరిష్కారం కోసం నా దగ్గరికి వస్తారు. నేను వారికి తీర్పు తీర్చి, దేవుని చట్టాలను, ఆయన ధర్మశాస్త్ర నియమాలను వారికి తెలియజేస్తాను” అని తన మామతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","అందుకు మోషే మామ అతనితో “నీవు చేస్తున్న పని మంచిది కాదు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ఇలా చేస్తే నువ్వూ నీతో ఉన్న ఈ ప్రజలూ నలిగిపోయి నీరసించి పోతారు. నువ్వొక్కడివే ఈ పని చెయ్యలేవు. ఇది నీకు చాలా కష్టంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","నా మాట విను. నేను నీకొక ఆలోచన చెబుతాను. దేవుడు నీకు తోడై ఉంటాడు. నువ్వు దేవుని ఎదుట ఈ ప్రజల ప్రతినిధిగా నిలబడి వారి వ్యవహారాలు దేవుని సముఖానికి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ప్రజలకు దేవుని చట్టాలూ ధర్మశాస్త్ర నియమాలూ బోధించాలి. వాళ్ళు నడుచుకోవలసిన మార్గాలను, చేయవలసిన పనులనూ వాళ్ళకు తెలియజెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","నువ్వు ప్రజలందరిలో దేవుని పట్ల భయభక్తులు, సత్యం పట్ల ఆసక్తి ఉండి లంచగొండులుకాని సమర్ధులైన వ్యక్తులను ఏర్పాటు చేసుకోవాలి. వారిని న్యాయాధిపతులుగా నియమించు. వెయ్యి మందికి ఒకడు, వంద మందికి ఒకడు, యాభై మందికి ఒకడు, పది మందికి ఒకడు చొప్పున వాళ్ళను నియమించు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","వాళ్ళు అన్ని సమయాల్లో ప్రజలకు న్యాయం తీరుస్తారు. పరిష్కారం కాని సమస్యలు మాత్రం నీ దగ్గరికి తీసుకు వస్తారు. చిన్న చిన్న తగాదాలు మాత్రం వాళ్ళే పరిష్కరిస్తారు. ఆ విధంగా వాళ్ళు నీ భారం పంచుకుంటే నీకు తేలికగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ఇలా చేయడానికి దేవుడు అనుమతి ఇస్తే, నీ పని తేలిక అవుతుంది. ఈ ప్రజలంతా తమ ఇళ్ళకు సంతృప్తిగా వెళ్తారు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","మోషే తన మామ మాట విని అతడు చెప్పినట్టు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","మోషే ఇశ్రాయేలు ప్రజలందరిలో సామర్థ్యం ఉన్న వ్యక్తులను గుర్తించి వెయ్యి మందికి ఒకడు, వంద మందికి ఒకడు, యాభై మందికి ఒకడు, పది మందికి ఒకడు చొప్పున అధికారులుగా నియమించి వాళ్లకు న్యాయం తీర్చే అధికారం ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","వాళ్ళు అన్ని సమయాల్లో ప్రజలకు న్యాయాధికారులుగా ఉన్నారు. చిన్న చిన్న తగాదాలు తమకు తాము పరిష్కరించేవాళ్ళు. కఠినమైన తగాదాలు మోషే దగ్గరికి తెచ్చేవారు. ");
INSERT INTO tel2017_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","తరువాత మోషే తన మామను సాగనంపాడు, అతడు తన స్వదేశానికి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ఇశ్రాయేలు ప్రజలు ఐగుప్తు దేశం నుండి బయలుదేరిన మూడవ నెల మొదటి రోజున సీనాయి ఎడారి ప్రాంతానికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","వాళ్ళు రెఫీదీము నుండి బయలుదేరి సీనాయి ఎడారికి వచ్చి అక్కడ పర్వతం ఎదుట ఎడారిలో విడిది చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","మోషే యెహోవా సన్నిధి ఉన్న కొండపైకి ఎక్కి వెళ్ళాడు. యెహోవా ఆ కొండపై నుండి అతణ్ణి పిలిచాడు. యెహోవా మోషేతో “నువ్వు యాకోబు సంతతితో మాట్లాడి ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘నేను ఐగుప్తీయులకు ఏమి జరిగించానో, గరుడ పక్షి రెక్కల మీద మోసినట్టు మిమ్మల్ని నా దగ్గరికి ఎలా చేర్చుకొన్నానో మీరు చూశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ఇప్పుడు మీరు నా మాట శ్రద్ధగా విని, నా ఒడంబడిక ప్రకారం నడుచుకుంటే అన్ని దేశ ప్రజల్లో నాకు విశేషమైన ఆస్తిగా ఉంటారు. భూమి అంతా నాదే గదా. ");
INSERT INTO tel2017_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","మీరు యాజక రాజ్యంగా పవిత్రప్రజగా ఉంటారు.’ నువ్వు ఇశ్రాయేలు ప్రజలతో చెప్పాల్సిన మాటలు ఇవే” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","మోషే కొండ దిగి వచ్చి ప్రజల పెద్దలను పిలిపించాడు. యెహోవా తనకు ఆజ్ఞాపించిన ఆ మాటలన్నీ వారికి తెలియజేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","అందుకు ప్రజలంతా “యెహోవా చెప్పినదంతా మేము చేస్తాం” అని ముక్తకంఠంతో జవాబిచ్చారు. అప్పుడు మోషే తిరిగి వెళ్లి ప్రజలు చెప్పిన మాటలను యెహోవాకు తెలియజేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","యెహోవా మోషేతో “ఇదిగో నేను కారుమబ్బులో నీ దగ్గరికి వస్తున్నాను. నేను నీతో మాట్లాడుతూ ఉండగా ప్రజలు విని ఎప్పటికీ నీ మీద నమ్మకం ఉంచుతారు” అన్నాడు. మోషే ప్రజల మాటలను యెహోవాతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","అప్పుడు యెహోవా మోషేతో “నీవు ప్రజల దగ్గరికి వెళ్లి ఈ రోజూ రేపూ వాళ్ళను పవిత్రపరచు. నా రాక కోసం వాళ్ళు సిద్ధం చెయ్యి. వాళ్ళు తమ బట్టలు ఉతుక్కుని ");
INSERT INTO tel2017_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","మూడవ రోజుకల్లా సిద్ధంగా ఉండాలి. మూడవ రోజు యెహోవా అనే నేను ప్రజలందరి కళ్ళెదుట సీనాయి కొండ పైకి దిగివస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","నువ్వు కొండ చుట్టూ హద్దు ఏర్పాటు చెయ్యి. ప్రజలతో, ‘మీరు ఈ కొండ ఎక్కకూడదు. దాని అంచును కూడా ముట్టుకోకూడదు. జాగ్రత్త. ఈ కొండను ముట్టుకున్న ప్రతివాడూ మరణశిక్షకు లోనవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ఎవ్వరూ తమ చేతులతో ముట్టుకున్న వాణ్ణి తాకకూడదు. రాళ్ళతో గానీ బాణాలతో గానీ కచ్చితంగా అతణ్ణి చంపెయ్యాలి. మనిషైనా జంతువైనా మరణ శిక్ష విధించాల్సిందే. సుదీర్ఘమైన బూర శబ్దం వినినప్పుడు వాళ్ళు కొండ పాదానికి చేరుకోవాలి’ అని చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","అప్పుడు మోషే కొండ దిగి ప్రజల దగ్గరికి వచ్చి ప్రజలను పవిత్ర పరిచాడు. ప్రజలు తమ బట్టలు ఉతుక్కున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","అప్పుడు మోషే “మూడవ రోజుకల్లా సిద్ధంగా ఉండండి. మీ భార్యల దగ్గరికి వెళ్లొద్దు.” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","మూడవ రోజు తెల్లవారగానే ఆ కొండ మీద దట్టమైన మేఘాలు కమ్మి ఉరుములు, మెరుపులు వచ్చాయి. భీకరమైన బూర శబ్దం వినిపించినప్పుడు శిబిరంలోని ప్రజలంతా భయంతో వణకిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","దేవుణ్ణి ఎదుర్కొనడానికి మోషే శిబిరంలో నుండి ప్రజలను బయటకు రప్పించాడు. ప్రజలంతా కొండ పాదం దగ్గర నిలబడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","మండుతున్న మంటలతో యెహోవా సీనాయి కొండపైకి దిగి వచ్చాడు. ఆ కొండ అంతా పొగ కమ్మింది. అది కొలిమి పొగలాగా పైకి లేస్తూ ఉంది. ఆ కొండంతా తీవ్రంగా కంపించింది. ");
INSERT INTO tel2017_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ఆ బూర శబ్దం మరింత పెరుగుతూ ఉండగా మోషే మాట్లాడుతూ ఉన్నాడు. దేవుడు ఉరుములాంటి కంఠ స్వరంతో అతనికి జవాబిస్తున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","యెహోవా సీనాయి కొండ శిఖరం మీదికి దిగి వచ్చాడు. కొండ శిఖరం మీదికి రమ్మని మోషేను పిలిచినప్పుడు మోషే ఎక్కి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","అప్పుడు యెహోవా మోషేతో “ఈ ప్రజలు యెహోవాను చూద్దామని హద్దు మీరి వచ్చి వారిలో చాలా మంది నశించిపోకుండేలా నువ్వు కొండ దిగి వెళ్లి వాళ్లను కచ్చితంగా హెచ్చరించు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ఇంకా నన్ను సమీపించే యాజకులు సిద్ధపడి నేను వారిని చంపకుండేలా తమను తాము పవిత్ర పరుచుకోవాలని చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","అందుకు మోషే యెహోవాతో “ప్రజలు సీనాయి కొండ ఎక్కలేరు. నువ్వు కొండకు హద్దులు ఏర్పాటు చేసి దాన్ని పవిత్రంగా ఉంచాలని మాకు కచ్చితంగా ఆజ్ఞాపించావు గదా” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","అప్పుడు యెహోవా “నువ్వు కిందకు దిగి వెళ్లు. నువ్వు అహరోనును వెంటబెట్టుకుని తిరిగి రావాలి. అయితే యెహోవా వారి మీద పడకుండా ఉండేలా యాజకులు, ప్రజలు హద్దు మీరి ఆయన దగ్గరికి ఎక్కి రాకూడదు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","మోషే ప్రజల దగ్గరికి వెళ్లి ఆ మాట వాళ్ళతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","దేవుడు ఈ ఆజ్ఞలన్నిటినీ వివరించి చెప్పాడు, ");
INSERT INTO tel2017_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","నేను యెహోవాను, మీ దేవుణ్ణి. ఐగుప్తు దేశంలో బానిసలుగా ఉన్న మిమ్మల్ని బయటకు తీసుకు వచ్చిన దేవుణ్ణి నేనే. ");
INSERT INTO tel2017_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","నేను కాక వేరే దేవుడు మీకు ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","పైన ఆకాశంలో గానీ, కింద భూమి మీద గానీ, భూమి కింద ఉండే నీళ్లలో గానీ ఎలాంటి ఆకారాన్నీ, ప్రతిమను తయారు చేసుకోకూడదు, వాటి ముందు సాష్టాంగపడ కూడదు, వాటిని పూజించ కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ఎందుకంటే నీ దేవుడనైన నేను రోషం గలవాణ్ణి. నన్ను లక్ష్యపెట్టని వారి విషయంలో వాళ్ళ మూడు నాలుగు తరాల దాకా వాళ్ళ పూర్వికుల దుష్టత్వం వారి సంతతి పైకి రప్పిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","నన్ను ప్రేమించి నా ఆజ్ఞలు పాటించే వారిపై వెయ్యి తరాల వరకూ నా కరుణ చూపిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","నీ దేవుడైన యెహోవా నామాన్ని వ్యర్థంగా పలకకూడదు. తన నామాన్ని వ్యర్థంగా పలికే వాణ్ణి యెహోవా దోషిగా పరిగణిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","విశ్రాంతి దినాన్ని పవిత్రంగా ఆచరించాలని జ్ఞాపకం ఉంచుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","నువ్వు కష్టపడి ఆరు రోజుల్లో నీ పని అంతా ముగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ఏడవ రోజు నీ దేవుడైన యెహోవాకు విశ్రాంతి దినం. ఆ రోజున నువ్వు, నీ కొడుకు, కూతురు, సేవకుడు, దాసీ, నీ ఇంట్లో ఉన్న విదేశీయుడు, నీ పశువులు ఎవ్వరూ ఏ పనీ చెయ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ఆరు రోజుల్లో యెహోవా ఆకాశాన్ని, భూమిని, సముద్రాన్ని, సముద్రంలో ఉన్న సమస్తాన్నీ సృష్టించాడు. ఏడవ రోజున విశ్రాంతి తీసుకున్నాడు. అందువల్ల యెహోవా విశ్రాంతి దినాన్ని దీవించి తనకోసం పవిత్ర పరిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","నీ దేవుడైన యెహోవా మీకివ్వబోయే దేశంలో నువ్వు దీర్ఘకాలం జీవించేలా నీ తండ్రిని, తల్లిని గౌరవించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","హత్య చెయ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","వ్యభిచారం చెయ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","దొంగతనం చెయ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","నీ పొరుగువాడిపై తప్పుడు సాక్ష్యం చెప్పకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","నీ పొరుగువాడి ఇల్లు గానీ, అతని భార్యను గానీ, దాస దాసీలను గానీ, అతని ఎద్దును గానీ, గాడిదను గానీ, నీ పొరుగు వాడికి చెందిన దేనినీ ఆశించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ప్రజలంతా ఆ ఉరుములు, మెరుపులు, భీకరమైన బూర శబ్దం, ఆ కొండ నుండి రగులుతున్న పొగ చూసి భయపడ్డారు. భయంతో దూరంగా తొలగిపోయి మోషేతో, ");
INSERT INTO tel2017_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","“దేవుడే గనక మాతో మాట్లాడితే మేమంతా చచ్చిపోతాం. నువ్వే మాతో మాట్లాడు, మేము వింటాం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","అందుకు మోషే “భయపడకండి. మిమ్మల్ని పరీక్షించడానికి, ఇక నుంచి మీరు పాపం చేయకుండా ఆయన భయం మీకు ఉండేలా దేవుడు వచ్చాడు” అని ప్రజలతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ప్రజలు దూరంగా నిలబడ్డారు. మోషే దేవుడు ఉన్న కారుమబ్బుల దగ్గరికి చేరుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","యెహోవా మోషేతో ఇలా చెప్పాడు. “ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పు. నేను ఆకాశంలో నుండి దిగి వచ్చి మీతో మాట్లాడాను అనడానికి మీరే సాక్షులు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","మీరు నన్ను ఆరాధించడానికి వెండి, లేదా బంగారపు ప్రతిమలను తయారు చేసుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","మట్టితో నా కోసం బలిపీఠం నిర్మించి దాని మీద మీ హోమబలులూ, శాంతిబలులూ, మీ గొర్రెలూ, ఎద్దులూ అర్పించాలి. నా పేరు గుర్తుంచుకొనేలా నేను దాన్ని ఉంచే ప్రతి స్థలం లో మీ దగ్గరికి వచ్చి మిమ్మల్ని ఆశీర్వదిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ఒకవేళ మీరు నాకు రాళ్లతో బలిపీఠం నిర్మించే పక్షంలో చెక్కిన రాళ్లతో దాన్ని కట్టకూడదు, దానికి నీ చేతి పనిముట్టు తగిలితే అది అపవిత్రం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","అంతేకాదు, నా బలిపీఠం సమీపించేటప్పుడు మీ నగ్నత్వం కనిపించకూడదు కాబట్టి మెట్ల మీదుగా ఎక్కకూడదు.” ");
INSERT INTO tel2017_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","నువ్వు ఈ న్యాయ నిర్ణయాలు వాళ్ళు పాటించేలా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","మీరు హెబ్రీవాడైన వ్యక్తిని దాసుడుగా కొనుక్కున్న పక్షంలో ఆరు సంవత్సరాలపాటు మీకు దాసుడుగా ఉండి, ఏడో సంవత్సరంలో మీకు ఏమీ చెల్లించకుండానే మీ నుండి విడుదల పొందవచ్చు, ");
INSERT INTO tel2017_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ఆ దాసుడు ఒంటరిగా వస్తే ఒంటరిగా వెళ్లవచ్చు. భార్యతో కలసి వస్తే వాడి భార్యను కూడా తీసుకుని వెళ్ళవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ఒకవేళ వాడి యజమాని అతనికి భార్యగా ఒక స్త్రీని అప్పగించినప్పుడు ఆమెకు ఆ దాసుడి ద్వారా కొడుకులు గానీ, కూతుళ్ళు గానీ పుట్టినట్టయితే ఆ భార్య, పిల్లలు ఆమె యజమానికి సొంతం అవుతారు, వాడు ఒంటరిగానే వెళ్లిపోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","అయితే ఆ దాసుడు “నేను నా యజమానిని, నా భార్య పిల్లలను ప్రేమిస్తున్నాను, వాళ్ళను విడిచిపెట్టి విడుదల పొందను” అని తేటగా చెబితే ");
INSERT INTO tel2017_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","వాడి యజమాని అతణ్ణి న్యాయాధిపతి దగ్గరకి తీసుకు రావాలి. తరువాత ఆ యజమాని వాణ్ణి తలుపు దగ్గరికి గానీ, గుమ్మం దగ్గరికి గానీ తీసుకువచ్చి వాడి చెవిని సన్నని కదురుతో గుచ్చాలి. అప్పటి నుంచి వాడు ఎల్లకాలం ఆ యజమానికి దాసుడుగా ఉండిపోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ఒకడు తన కూతురిని దాసిగా అమ్మేస్తే దాసులుగా ఉండే పురుషులు స్వతంత్రంగా వెళ్లిపోయినట్టు ఆమె వెళ్ళిపోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ఆమెను భార్యగా ఉంచుకోదలచే ఆమె యజమానికి ఆమె నచ్చక పోతే వెల ఇచ్చి ఆమెను విడిపించడానికి ఆమె బంధువులకు అవకాశం ఇవ్వాలి. యజమాని ఆమె పట్ల అన్యాయం జరిగించిన కారణంగా ఆమెను విదేశీయులకు అమ్మే హక్కు అతనికి ఉండదు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","యజమాని తన కొడుక్కి ఆమెను ఇస్తే తన కూతుళ్ళ పట్ల ఎలా వ్యవహరిస్తాడో అదే విధంగా ఆమె పట్ల కూడా వ్యవహరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ఆ కొడుకు మరొకామెను చేసుకున్నా మొదటి ఆమెకు తిండి, బట్ట, సంసార ధర్మం విషయంలో ఏమీ తక్కువ చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ఈ మూడు విషయాల్లో ఏది తక్కువ చేసినా వెల ఏమీ చెల్లించకుండా ఆమె విడుదల పొందవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","ఒక వ్యక్తిని చనిపోయేలా కొట్టిన వాడికి తప్పకుండా మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","అయితే ఉద్దేశపూర్వకంగా కాక, అనుకోకుండా వాడి ద్వారా ఆ హత్య జరిగితే వాడు పారిపోవడానికి ఒక స్థలం మీకు నిర్ణయిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","అయితే ఒకడు తన పొరుగువాడిపై కోపంతో, కుయుక్తితో వాణ్ణి చంపేసి నా బలిపీఠం దగ్గర ఆశ్రయం పొందాలని చూస్తే వాణ్ణి బయటకు లాగి చంపాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","తన తండ్రిని, తల్లిని కొట్టేవాడు తప్పకుండా మరణశిక్షకు అర్హుడు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ఎవడైనా ఒక వ్యక్తిని దొంగిలించి అమ్మినా, తన దగ్గర అక్రమంగా ఉంచుకొన్నా వాడు తప్పకుండా మరణశిక్షకు అర్హుడు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","తన తండ్రిని, తల్లిని దూషించేవాడు తప్పక మరణశిక్ష పొందుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ఎవరి మధ్యనైనా గొడవ జరిగినప్పుడు ఒకడు మరొకడిని రాయితో కొట్టి గానీ, పిడికిలితో గుద్దిగానీ చనిపోకుండా మంచాన పడేలా చేస్తే, ");
INSERT INTO tel2017_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","తరువాత గాయపడ్డవాడు లేచి తన చేతికర్ర సాయంతో తిరుగుతుంటే అతణ్ణి కొట్టిన వాడికి శిక్ష ఏమీ ఉండదు. అయితే గాయపడిన వ్యక్తి పని చేయలేకపోయిన కాలానికి సరిపడ్డ సొమ్ము కొట్టినవాడు ఇచ్చి, అతణ్ణి పూర్తిగా బాగుచేయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ఎవరైనా ఒకడు తన దాసుణ్ణి, దాసిని చనిపోయేలా కర్రతో కొట్టినప్పుడు అతడు తప్పకుండా శిక్షకు అర్హుడు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","అయితే ఆ దాసులు ఒకటి రెండు రోజులు చనిపోకుండా బతికితే ఆ శిక్ష అతనికి ఉండదు. ఎందుకంటే ఆ దాసులు అతని సొమ్ము. ");
INSERT INTO tel2017_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ఎవరి మధ్యనైనా గొడవ జరిగినప్పుడు గర్భంతో ఉన్న స్త్రీకి దెబ్బ తగిలి ఆమెకు గర్భస్రావం జరిగితే, గర్భస్రావం కాక మరి ఏ ఇతర హానీ కలగకపోతే ఆ స్త్రీ భర్త హాని కలిగించినవాడిపై మోపిన నష్టాన్ని వాడు చెల్లించాలి. అయితే అది న్యాయాధిపతుల నిర్ణయం మేరకు వాళ్ళ సమక్షంలో జరగాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","తీవ్రగాయం కలిగినప్పుడు మీరు విధించ వలసిన శిక్షలు: ప్రాణానికి ప్రాణం, ");
INSERT INTO tel2017_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","కంటికి కన్ను, పంటికి పన్ను, చేతికి చెయ్యి, కాలికి కాలు, ");
INSERT INTO tel2017_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","వాతకు వాత, గాయానికి గాయం, దెబ్బకు దెబ్బ. ");
INSERT INTO tel2017_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ఒకడు తన దాసుణ్ణి గానీ, దాసిని గానీ కొట్టి వాళ్ళ కన్ను పోయేలా చేస్తే ఆ కన్నుకు పరిహారంగా వాళ్ళను విడుదల చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","తన దాసుడి, దాసి దంతం ఊడిపోయేలా కొట్టినప్పుడు ఆ దంతానికి పరిహారంగా వాళ్ళను విడుదల చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ఎవరిదైనా ఎద్దు పురుషుణ్ణి గానీ, స్త్రీని గానీ పొడిచి చంపితే ఆ ఎద్దును కచ్చితంగా రాళ్లతో కొట్టి చంపాలి. అలా చనిపోయిన ఎద్దు మాంసం తినకూడదు. ఈ విషయంలో ఎద్దు యజమానికి దోషం అంటదు. ");
INSERT INTO tel2017_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","అయితే ఆ ఎద్దు ఇతరులను పొడుస్తుంది అని ఇంతకు ముందు దాని యజమానికి తెలిసి కూడా అతడు దాన్ని అదుపు చేయక పోవడం వల్ల దాని ద్వారా పురుషుడు గానీ, స్త్రీ గానీ చనిపోతే ఆ ఎద్దును రాళ్లతో కొట్టి చంపాలి. అప్పుడు దాని యజమానికి మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","మరణశిక్షకు బదులు జరిమానా విధిస్తే అతడు ఆ మొత్తం చెల్లించి తన ప్రాణం దక్కించుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ఆ ఎద్దు చిన్న పిల్లవాణ్ణి గానీ చిన్న పిల్లనుగానీ పొడిచినప్పుడు ఈ నియమం వర్తిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ఎద్దు దాసుణ్ణి గానీ, దాసిని గానీ పొడిచినప్పుడు ఆ దాసుల యజమానికి ఎద్దు యజమాని 30 తులాల వెండి చెల్లించాలి. ఇంకా ఆ ఎద్దును రాళ్లతో కొట్టి చంపాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ఒక గొయ్యి మీద మూత తీసి ఉంచినప్పుడు గానీ, గొయ్యి తవ్వి దానిపై కప్పు ఉంచక పోవడం వల్ల గానీ దానిలో వేరొకరి ఎద్దు గానీ, గాడిద గానీ పడి చనిపోతే ");
INSERT INTO tel2017_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ఆ గొయ్యి ఉన్న స్థలం యజమానులు ఆ నష్టానికి బాధ్యత వహించాలి. వాటి యజమానికి తగిన మొత్తం చెల్లించాలి. అప్పుడు చచ్చిన జంతువు అతని సొంతం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ఒకరి ఎద్దు వేరొకరి ఎద్దును చనిపోయేలా పొడిచినప్పుడు బతికి ఉన్న ఎద్దును అమ్మి దానికి వచ్చిన మొత్తాన్ని ఇద్దరూ పంచుకోవాలి. చచ్చిన ఎద్దు మాంసం కూడా పంచుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","అయితే ఆ ఎద్దు ఇతరులను పొడుస్తుంది అని ఇంతకు ముందు దాని యజమానికి తెలిసి కూడా అతడు దాన్ని అదుపు చేయకపోతే వాడు తప్పకుండా ఎద్దుకు బదులు ఎద్దును ఇవ్వాలి, చనిపోయిన ఎద్దు అతనిది అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ఎవరైనా ఒకడు ఎద్దును గానీ, గొర్రెను గానీ దొంగిలించి వాటిని అమ్మినా, లేదా చంపినా ఒక ఎద్దుకు బదులు ఐదు ఎద్దులు, ఒక గొర్రెకు బదులు నాలుగు గొర్రెలు చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ఎవరైనా దొంగతనం చేస్తూ దొరికిపోతే వాణ్ణి చనిపోయేలా కొట్టినప్పుడు కొట్టిన వాళ్ళ మీద నేరం ఉండదు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","సూర్యుడు ఉదయించిన తరువాత దొంగతనానికి వచ్చిన వాణ్ణి కొట్టిన వ్యక్తి పై హత్యానేరం ఉంటుంది. దొంగిలించిన సొత్తు తిరిగి చెల్లించాలి. దొంగ దగ్గర చెల్లించడానికి ఏమీ లేకపోతే వాడు దొంగతనం చేశాడు కాబట్టి వాణ్ణి బానిసగా అమ్మివేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","దొంగిలించిన ఎద్దు గానీ, గాడిద గానీ, గొర్రె గానీ ఏదైనా సరే, ప్రాణంతో దొరికితే వాడు దానికి రెండు రెట్లు చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ఒకడు తన పశువును మేత మేయడానికి తన పొలం లోకి గానీ, ద్రాక్ష తోటలోకి గానీ వదిలినప్పుడు అది వేరొక వ్యక్తి పొలంలో మేస్తే ఆ పొలం యజమానికి తన పంటలో, ద్రాక్షతోటలో శ్రేష్ఠమైనది తిరిగి చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","నిప్పు రాజుకుని ముళ్ళకంపలు అంటుకోవడం వల్ల వేరొకరి పంట కుప్పలైనా, పొలంలో పైరులైనా, పొలమైనా తగలబడి పోతే నిప్పు అంటించిన వాడు జరిగిన నష్టాన్ని పూడ్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ఒక వ్యక్తి సొమ్మును గానీ, సామాన్లు గానీ జాగ్రత్త చెయ్యమని తన పొరుగు వాడికి అప్పగించినప్పుడు ఆ వ్యక్తి ఇంట్లో దొంగతనం జరిగినట్టయితే ఆ దొంగ దొరికిన పక్షంలో వాడు దానికి రెండు రెట్లు చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ఒకవేళ ఆ దొంగ దొరకని పక్షంలో ఆ ఇంటి యజమాని తన పొరుగువాడి వస్తువులు తీసుకున్నాడో లేదో పరిష్కారం చేసుకోవడానికి న్యాయాధికారుల దగ్గరికి రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ఎద్దులు, గాడిదలు, గొర్రెలు, దుస్తులు వంటి ప్రతి విధమైన వాటి అపహరణ గూర్చిన ఆజ్ఞ ఇదే. పోగొట్టుకున్నవాడు వాటిని చూసి, అవి నావి అని వాదించినప్పుడు ఆ విషయంలో పరిష్కారం కోసం న్యాయాధికారుల దగ్గరికి రావాలి. న్యాయాధిపతి ఎవరి మీద నేరం రుజువు చేస్తాడో వాడు తన పొరుగువాడికి రెండు రెట్లు చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ఒకడు గాడిద, ఎద్దు, గొర్రె, మరి ఏ జంతువునైనా కాపాడమని తన పొరుగు వాడికి అప్పగించినప్పుడు, అది చనిపోయినా, గాయపడినా, లేదా ఎవరూ చూడకుండా ఎవరైనా వాటిని తోలుకు పోయినా, ");
INSERT INTO tel2017_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","అ వ్యక్తి తన పొరుగువాడి సొమ్మును తాను దొంగిలించలేదని యెహోవా నామం పేరట ప్రమాణం చెయ్యాలి. ఆ ప్రమాణం వారిద్దరి మధ్యనే ఉండాలి. ఆస్తి స్వంత దారుడు దానికి సమ్మతించాలి. జరిగిన నష్టపరిహారం చెల్లించనక్కర లేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ఒకవేళ అది నిజంగా అతని దగ్గర నుండి ఎవరైనా దొంగిలిస్తే అతడు స్వంత దారుడికి పరిహారం చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","లేదా ఒకవేళ మృగాలు దాన్ని చీల్చివేస్తే రుజువు కోసం దాన్ని తీసుకురావాలి. అలా చనిపోయినప్పుడు దాని నష్టం చెల్లించనక్కర లేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ఒక వ్యక్తి తన పొరుగువాని దగ్గర ఏదైనా బదులు తీసుకుంటే, దాని యజమాని దాని దగ్గర లేనప్పుడు దానికి హాని కలిగినా, లేదా అది చనిపోయినా ఆ నష్టాన్ని తప్పకుండా పూరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","దాని యజమాని దానితో ఉన్నట్టయితే దాని నష్టం చెల్లించనక్కర లేదు. ఒకవేళ అది కిరాయికి తెచ్చినదైతే దాని కిరాయి డబ్బు యజమానికి చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ఒకడు పెళ్లి నిర్ణయం కాని ఒక కన్యను లోబరచుకుని ఆమెతో తన వాంఛ తీర్చుకుంటే ఆమె కోసం కట్నం ఇచ్చి ఆమెను పెళ్లి చేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ఒకవేళ ఆమె తండ్రి ఆమెను అతనికిచ్చేందుకు నిరాకరిస్తే వాడు కన్యల కట్నం ప్రకారం సొమ్ము చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","మంత్రగత్తెను బతకనివ్వకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","జంతువులతో సంపర్కం చేసే ప్రతి ఒక్కరికీ మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","యెహోవాకు మాత్రమే బలులు అర్పించాలి, వేరొక దేవునికి బలి అర్పించే వాడు శాపానికి గురౌతాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","పరాయి దేశస్థులను పీడించకూడదు. మీరు ఐగుప్తు దేశంలో పరాయివాళ్ళుగా ఉన్నారు గదా. ");
INSERT INTO tel2017_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","విధవరాళ్ళను, తల్లి తండ్రులు లేని పిల్లలను బాధపెట్టకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","వాళ్ళను ఏ కారణంతోనైనా నీవు బాధ పెడితే వాళ్ళు పెట్టే మొర నాకు వినబడుతుంది. నేను వాళ్ళ మొరను తప్పకుండా ఆలకిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","నా కోపాగ్ని రగులుకొంటుంది. నా కత్తివేటుతో నిన్ను హతం చేస్తాను. మీ భార్యలు విధవరాళ్ళు అవుతారు. మీ పిల్లలు దిక్కులేని వాళ్ళవుతారు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","నా ప్రజల్లో మీ దగ్గర ఉండే ఒక పేదవాడికి అప్పుగా సొమ్ము ఇచ్చినప్పుడు వారి పట్ల కఠినంగా ప్రవర్తించ కూడదు. వాళ్ళ దగ్గర వడ్డీ వసూలు చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","మీరు ఒకవేళ ఎప్పుడైనా మీ పొరుగువాడి దుస్తులు తాకట్టు పెట్టుకుంటే సూర్యుడు అస్తమించే సమయానికి వాటిని వాళ్లకు తిరిగి అప్పగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","వాళ్ళు ఏమి కప్పుకుని పండుకుంటారు? వాళ్ళ దేహాలు కప్పుకొనే దుస్తులు అవే కదా. వాళ్ళు నాకు మొర పెట్టినప్పుడు నేను వింటాను. నేను దయగల వాణ్ణి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","నువ్వు దేవుణ్ణి దూషించకూడదు. నీ ప్రజల అధికారుల్లో ఎవరినీ శపించ కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","నీ మొదటి కోత అర్పణలు ఇవ్వడంలో ప్రథమ ఫలాలు ఇవ్వడంలో ఆలస్యం చేయకూడదు. నీ కొడుకుల్లో మొదటివాణ్ణి నాకు ప్రతిష్టించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","అదే విధంగా నీ ఎద్దులు, గొర్రెలు అర్పించాలి. మీరు ప్రతిష్ఠించినవి మొదటి ఏడు రోజులు తమ తల్లి దగ్గర ఉన్న తరువాత ఎనిమిదవ రోజు నాకు ప్రతిష్ఠించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","మీరు నాకు ప్రత్యేకంగా ఉన్న వాళ్ళు గనుక పొలాల్లో మృగాలు చీల్చిన జంతు మాంసం తినకూడదు. దాన్ని కుక్కలకు పారవెయ్యాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","పుకార్లు పుట్టించకూడదు. అన్యాయ సాక్ష్యం చెప్పడానికి దుష్టులతో చేతులు కలప కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","దుష్టకార్యాలు జరిగించే గుంపులతో కలిసి ఉండ కూడదు. న్యాయాన్ని తారుమారు చేసే గుంపుతో చేరి న్యాయం విషయంలో అబద్ద సాక్ష్యం చెప్ప కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ఒక పేదవాడు న్యాయం కోసం పోరాడుతుంటే అతని పట్ల పక్షపాతంగా వ్యవహరించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","నీ శత్రువుకు చెందిన ఎద్దు గానీ, గాడిద గానీ తప్పిపోతే అది నీకు కనబడినప్పుడు నువ్వు తప్పకుండా దాన్ని తోలుకు వచ్చి అతనికి అప్పగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","నీ విరోధి గాడిద బరువు క్రింద పడిపోయి ఉండడం నువ్వు చూస్తే దాని పక్కనుండి దాటిపోకుండా వెంటనే వెళ్లి అతడితో కలసి ఆ గాడిదను విడిపించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","దరిద్రునికి న్యాయం చేసే విషయంలో అన్యాయంగా తీర్పు తీర్చకూడదు ");
INSERT INTO tel2017_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","అబద్ధానికి దూరంగా ఉండు. నీతిమంతుణ్ణి, దోషం లేనివాణ్ణి చంపకూడదు. అలాంటి చెడ్డ పనులు చేసేవాణ్ణి నేను దోషం లేనివాడిగా చూడను. ");
INSERT INTO tel2017_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","లంచాలు తీసుకోవద్దు. చూపు ఉన్నవాణ్ణి లంచం గుడ్డివాడిగా చేస్తుంది. నీతిమంతుల మాటలకు అపార్థాలు పుట్టిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","విదేశీయులను ఇబ్బందుల పాలు చేయకూడదు. మీరు ఐగుప్తు దేశంలో విదేశీయులుగా ఉన్నారు కదా. వాళ్ళ మనస్సు ఎలా ఉంటుందో మీకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ఆరు సంవత్సరాల పాటు నీ భూమిని దున్ని దాని పంట సమకూర్చుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ఏడవ సంవత్సరం నీ భూమిని బీడుగా వదిలి పెట్టాలి. అప్పుడు మిగిలి ఉన్న పంటను నీ ప్రజల్లోని పేదవారు తీసుకున్న తరువాత మిగిలినది అడవి జంతువులు తినవచ్చు. మీకు చెందిన ద్రాక్ష, ఒలీవ తోటల విషయంలో కూడా ఈ విధంగానే చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ఆరు రోజులు నీ పనులు చేసిన తరువాత ఏడవ రోజున నీ ఎద్దులు, గాడిదలు, దాసీ కొడుకులూ, విదేశీయులూ సేద దీర్చుకొనేలా విశ్రాంతి తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","నేను మీతో చెప్పే సంగతులన్నీ జాగ్రత్తగా వినాలి. వేరొక దేవుని పేరు ఉచ్చరింపకూడదు. అది నీ నోటి వెంట రానియ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","సంవత్సరంలో మూడుసార్లు నాకు ఉత్సవం జరిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","పొంగ జేసే పదార్థం లేని రొట్టెల పండగ ఆచరించాలి. నేను మీకు ఆజ్ఞాపించిన ప్రకారం ఐగుప్తు నుండి మీరు బయలుదేరి వచ్చిన ఆబీబు నెలలో నియమిత సమయంలో ఏడు రోజుల పాటు పొంగ జేసే పదార్థం లేని రొట్టెలు తినాలి. నా సన్నిధానంలో ఒక్కడు కూడా ఖాళీ చేతులతో నిలబడకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","మీ పొలాల్లో పండిన తొలి పంటల కోత సమయంలో పండగ ఆచరించాలి. సంవత్సరం చివరలో పొలాల నుండి నీ వ్యవసాయ ఫలాలన్నీ సమకూర్చుకుని జనమంతా సమావేశమై పండగ ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","సంవత్సరంలో మూడు సార్లు పురుషులందరూ ప్రభువైన యెహోవా సన్నిధిలో సమకూడాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","నాకు అర్పించే బలుల రక్తంలో పొంగజేసే పదార్థమేమీ ఉండకూడదు. నా పండగలో అర్పించిన కొవ్వు ఉదయం దాకా నిలవ ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","నీ భూమిలో పండే వాటిలో ప్రథమ ఫలాలు యెహోవా దేవుని మందిరానికి తీసుకురావాలి. మేకపిల్ల మాంసం దాని తల్లిపాలలో కలిపి ఉడకబెట్ట కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","నేను సిద్ధపరచిన దేశానికి మీరు క్షేమంగా చేరుకోవడానికి మార్గంలో మిమ్మల్ని కాపాడుతూ మీకు ముందుగా వెళ్ళడానికి ఒక దూతను పంపిస్తున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ఆయన సన్నిధిలో ఉండి ఆయన మాట జాగ్రత్తగా వినండి. ఆయనకు కోపం వచ్చే పనులు చేయకూడదు. మీరు ఆయనకు వ్యతిరేకంగా ప్రవర్తిస్తే ఆయన క్షమించడు. ఎందుకంటే ఆయనకు నా పేరు పెట్టాను. ");
INSERT INTO tel2017_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","మీరు ఆయనకు లోబడి ఆయన మాటలు జాగ్రత్తగా వింటూ ఉంటే నేను మీ శత్రువులకు శత్రువుగా, మీ విరోధులకు విరోధిగా ఉంటాను. ");
INSERT INTO tel2017_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ఎలాగంటే నా దూత మీకు ముందుగా వెళ్తాడు. అమోరీయులు, హిత్తీయులు, పెరిజ్జీయులు, కనానీయులు, హివ్వీయులు, యెబూసీయులు నివసిస్తున్న దేశానికి మిమ్మల్ని నడిపిస్తాడు. నేను వాళ్ళను హతం చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","మీరు వారి దేవుళ్ళ ఎదుట సాష్టాంగపడ కూడదు, వారికి మొక్క కూడదు. వాళ్ళు చేసే పనులు చేయ కూడదు. వాళ్ళ విగ్రహాలను తుత్తునియలు చేసి వాటిని పూర్తిగా నాశనం చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","మీరు మీ దేవుడైన యెహోవానే ఆరాధించి సేవించాలి. అప్పుడు నువ్వు తినే ఆహారం మీదా, తాగే నీళ్ళ మీదా ఆయన దీవెనలు ఉంటాయి. ఎలాంటి రోగాలూ మీకు సంక్రమించవు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","మీ దేశంలో గర్భస్రావాలు ఉండవు. సంతాన సాఫల్యత లేని వాళ్ళు మీ దేశంలో ఉండరు. మీరు జీవించే రోజుల లెక్క పూర్తి చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","నా పేరును బట్టి ఇతరులు మీకు భయపడేలా చేస్తాను. మీ ప్రయాణంలో మీరు దాటుతున్న సమస్త దేశ ప్రజలను ఓడించి నీ శత్రువులు నీ ఎదుట నుండి పారిపోయేలా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","మీకు ముందుగా పెద్ద పెద్ద కందిరీగలను పంపిస్తాను. అవి హివ్వీయులను, కనానీయులను, హిత్తీయులను మీ ఎదుట నుండి వెళ్ళగొడతాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","అయితే ఒక్క సంవత్సరంలోనే వాళ్ళను వెళ్లగొట్టను. ఎందుకంటే దేశం పాడైపోతుంది. క్రూరమృగాలు విస్తరించి మీకు ప్రమాదకరంగా మారతాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","మీరు వృద్ధి చెంది ఆ దేశాన్ని స్వాధీనం చేసుకునే దాకా వాళ్ళను కొంచెం కొంచెంగా మీ ఎదుట నుండి వెళ్ళగొడతాను. ");
INSERT INTO tel2017_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ఎర్ర సముద్రం నుంచి ఫిలిష్తీయుల సముద్రం దాకా, ఎడారి నుంచి నది దాకా మీకు సరిహద్దులు నియమిస్తాను. ఆ దేశ నివాసులను మీ చేతికి అప్పగిస్తాను. మీరు మీ ఎదుట నుండి వాళ్ళను వెళ్లగొడతారు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","మీరు వాళ్ళతో గానీ, వాళ్ళ దేవుళ్ళతో గానీ ఎలాంటి ఒప్పందాలూ చేసుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","వాళ్ళు మీ దేశంలో నివసించకూడదు. వాళ్ళను ఉండనిస్తే వాళ్ళు మీ చేత నాకు విరోధంగా పాపం చేయిస్తారు. వాళ్ళ దేవుళ్ళను పూజిస్తే అది మీకు ఉరిగా పరిణమిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. “నువ్వు, అహరోను, నాదాబు, అబీహు, ఇశ్రాయేలు ప్రజల పెద్దల్లో 70 మంది యెహోవా దగ్గరికి ఎక్కి వచ్చి దూరాన సాగిలపడండి. ");
INSERT INTO tel2017_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","మోషే ఒక్కడు మాత్రమే యెహోవాను సమీపించాలి. మిగిలినవారు ఆయన సమీపానికి అతనితో కలసి ఎక్కి రాకూడదు.” ");
INSERT INTO tel2017_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","మోషే వచ్చి యెహోవా మాటలను, కట్టుబాట్లను ప్రజలకు వివరించాడు. ప్రజలంతా “యెహోవా చెప్పిన మాటలన్నిటి ప్రకారం చేస్తాం” అని ముక్త కంఠంతో జవాబిచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","మోషే యెహోవా చెప్పిన మాటలన్నిటినీ రాశాడు. అతడు ఉదయాన్నే లేచి ఆ కొండ పాదం దగ్గర బలిపీఠం కట్టాడు. ఇశ్రాయేలు ప్రజల పన్నెండు గోత్రాల ప్రకారం పన్నెండు స్తంభాలు నిలిపాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","తరవాత ఇశ్రాయేలు ప్రజల్లో కొందరు యువకులను పంపినప్పుడు వాళ్ళు వెళ్లి హోమ బలులు అర్పించి యెహోవాకు సమాధానబలులగా కోడెలను వధించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","అప్పుడు మోషే వాటి రక్తంలో సగం పళ్ళెంలో పోశాడు. మిగతా సగం బలిపీఠం మీద కుమ్మరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","తరువాత అతడు నిబంధన గ్రంథం చేతబట్టుకుని ప్రజలకు వినిపించాడు. ప్రజలంతా “యెహోవా చెప్పినవన్నీ చేస్తూ ఆయనకు విధేయులుగా ఉంటాం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","మోషే అప్పుడు రక్తం తీసుకుని ప్రజల మీద చిలకరించాడు. “ఇది నిబంధన రక్తం. ఇదిగో ఈ విషయాలన్నిటి ప్రకారం యెహోవా మీతో చేసిన నిబంధన ఇదే” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ఆ తరువాత మోషే, అహరోను, నాదాబు, అబీహు, ఇశ్రాయేలు ప్రజల పెద్దలు 70 మంది కొంతవరకూ కొండ ఎక్కి వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","అక్కడ వారికి ఇశ్రాయేలీయుల దేవుని ప్రత్యక్షత కలిగింది. ఆయన పాదాల కింద మెరిసిపోతున్న నీలాలు అలికినట్టున్న వేదిక ఉంది. అది ఆకాశమంత నిర్మలంగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ఆయన ఇశ్రాయేలు ప్రజల పెద్దలకు ఎలాంటి హాని కలిగించలేదు. అక్కడ వాళ్ళు దేవుని దర్శనం చేసుకుని అన్న పానాలు పుచ్చుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","అప్పుడు యెహోవా మోషేతో “నువ్వు కొండ ఎక్కి నా దగ్గరికి వచ్చి అక్కడ ఉండు. నేను రాతి పలకలపై రాసిన ఆజ్ఞలనూ, ధర్మశాస్త్రాన్నీ నీకు ఇస్తాను. నువ్వు వాటిని ప్రజలకు బోధించాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","మోషే తన సహాయకుడు యెహోషువను తీసుకుని దేవుని పర్వతం ఎక్కాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","మోషే ఇశ్రాయేలు పెద్దలతో “మేము తిరిగి మీ దగ్గరికి వచ్చేంత వరకూ ఇక్కడే ఉండండి. ఇక్కడ అహరోను, హూరు మీతోనే ఉన్నారు. మీలో ఏవైనా తగాదాలు ఉంటే వాళ్ళ దగ్గరికి వెళ్లి పరిష్కరించుకోండి” అని చెప్పి దేవుని కొండ ఎక్కాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","మోషే కొండ ఎక్కినప్పుడు దేవుని మేఘం ఆ కొండంతా కమ్మివేసింది. ");
INSERT INTO tel2017_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","యెహోవా మహిమా ప్రకాశం సీనాయి కొండపై కమ్ముకుంది. ఆరు రోజులపాటు మేఘం కమ్ముకుని ఉంది. ఏడవ రోజున ఆయన ఆ మేఘంలో నుండి మోషేను పిలిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","యెహోవా మహిమా ప్రకాశం ఆ కొండ శిఖరంపై దహించే మంటల్లాగా ఇశ్రాయేలు ప్రజలకు కనబడింది. ");
INSERT INTO tel2017_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","అప్పుడు మోషే ఆ మేఘంలో ప్రవేశించి కొండ ఎక్కాడు. మోషే ఆ కొండ మీద నలభై పగళ్ళూ, నలభై రాత్రులూ ఉండిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“నాకు ప్రతిష్ఠార్పణ తీసుకు రావాలని ఇశ్రాయేలీయులతో చెప్పు. మనసారా అర్పించే ప్రతి వాడి దగ్గరా దాన్ని తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","మీరు వారి దగ్గర తీసుకోవలసిన అర్పణలు ఇవి. బంగారం, వెండి, ఇత్తడి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","నీలం, ఊదా రక్త వర్ణాల ఉన్ని, సన్నని నార బట్టలు, మేక వెంట్రుకలు. ");
INSERT INTO tel2017_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ఎరుపురంగు వేసిన పొట్టేళ్ల తోళ్లు, సీలు జంతువు చర్మం, తుమ్మ చెక్క. ");
INSERT INTO tel2017_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","మందిరంలో దీపాల కోసం నూనె, అభిషేక తైలం కోసం, పరిమళ ధూపం కోసం సుగంధ ద్రవ్యాలు, ");
INSERT INTO tel2017_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ఏఫోదు కోసం, వక్ష పతకం కోసం గోమేధికాలు, ఇతర రత్నాలు. ");
INSERT INTO tel2017_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","నేను వారి మధ్య నివసించేలా వారు నాకు పరిశుద్ధస్థలాన్ని నిర్మించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","నేను నీకు చూపించే విధంగా మందిరం స్వరూపాన్ని దాని ఉపకరణాలను చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","వారు తుమ్మకర్రతో ఒక మందసం చెయ్యాలి. దాని పొడవు రెండు మూరలున్నర, దాని వెడల్పు మూరెడున్నర, దాని ఎత్తు మూరెడున్నర ");
INSERT INTO tel2017_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","దాని మీద మేలిమి బంగారు రేకు పొదిగించాలి. లోపలా బయటా దానికి బంగారు రేకు పొదిగించాలి. దాని మీద బంగారు అంచు కట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","దానికి నాలుగు బంగారు రింగులు పోత పోసి, ఒక వైపు రెండు, మరొక వైపు రెండు రింగులు ఉండేలా దాని నాలుగు కాళ్లకు వాటిని తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","తుమ్మ చెక్కతో మోతకర్రలు చేసి వాటికి బంగారు రేకు పొదిగించి ");
INSERT INTO tel2017_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","వాటితో ఆ మందసాన్ని మోయడానికి అంచులకు ఉన్న రింగుల్లో ఆ మోతకర్రలను దూర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ఆ మోతకర్రలు ఆ మందసం రింగుల్లోనే ఉండాలి. వాటిని రింగుల్లోనుండి తీయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ఆ మందసంలో నేను నీకివ్వబోయే శాసనాలను ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","నీవు మేలిమి బంగారంతో ప్రాయశ్చిత్త స్థానమైన మూతను చెయ్యాలి. దాని పొడవు రెండు మూరలున్నర. దాని వెడల్పు మూరెడున్నర. ");
INSERT INTO tel2017_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","సాగగొట్టిన బంగారంతో రెండు బంగారు కెరూబు రూపాలను చెయ్యాలి. ప్రాయశ్చిత్త మూత రెండు అంచులతో వాటిని ఏకాండంగా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ఈ కొనలో ఒక కెరూబును ఆ కొనలో ఒక కెరూబును చెయ్యాలి. ప్రాయశ్చిత్త మూతపై దాని రెండు కొనల మీద కెరూబులను దానితో ఏకాండంగా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ఆ కెరూబులు రెక్కలు పైకి విచ్చుకుని ప్రాయశ్చిత్త మూతను తమ రెక్కలతో కప్పుతూ ఉండాలి. వాటి ముఖాలు ఒకదానికొకటి ఎదురెదురుగా ఉండాలి. ఆ కెరూబుల ముఖాలు ప్రాయశ్చిత్త మూత వైపుకి తిరిగి ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","నీవు ఆ మూతను మందసం మీద ఉంచాలి. నేను నీకిచ్చే శాసనాలను ఆ మందసంలో ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","అక్కడ నేను నిన్ను కలుసుకుని ప్రాయశ్చిత్త మూత మీద నుండి, శాసనాలున్న మందసం మీద ఉన్న రెండు కెరూబుల మధ్య నుండి, ఇశ్రాయేలీయుల కోసం ఇచ్చే ఆజ్ఞలన్నిటినీ నీకు తెలియజేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","నీవు తుమ్మచెక్కతో ఒక బల్ల చేయాలి. దాని పొడవు రెండు మూరలు. వెడల్పు ఒక మూర. దాని ఎత్తు మూరెడున్నర. ");
INSERT INTO tel2017_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","మేలిమి బంగారు రేకును దానికి పొదిగించి దానికి బంగారు అంచును చేయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","దానికి చుట్టూ బెత్తెడు చట్రం చేసి దానిపై చుట్టూ బంగారు అంచు పెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","దానికి నాలుగు బంగారు రింగులు చేసి దాని నాలుగు కాళ్లకి ఉండే నాలుగు మూలల్లో ఆ రింగులను తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","బల్లను మోయడానికి చేసిన మోతకర్రలు రింగులకు, చట్రానికి దగ్గరగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ఆ మోతకర్రలను తుమ్మచెక్కతో చేసి వాటి మీద బంగారు రేకు పొదిగించాలి. వాటితో బల్లను మోస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","నీవు దాని పళ్ళేలను, గరిటెలను, గిన్నెలను, పానీయార్పణం కోసం పాత్రలను చేయాలి. మేలిమి బంగారంతో వాటిని చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","నిత్యం నా సన్నిధిలో సన్నిధి రొట్టెలను ఈ బల్ల మీద ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","నీవు మేలిమి బంగారంతో దీపవృక్షాన్ని చేయాలి. సాగగొట్టిన బంగారంతో ఈ దీపవృక్షాన్ని చేయాలి. దాని కాండాన్ని, కొమ్మలను సాగగొట్టిన బంగారంతోనే చెయ్యాలి. దాని కలశాలు, దాని మొగ్గలు, దాని పువ్వులు దానితో ఏకాండంగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","దీప వృక్షం ఒక వైపు నుండి మూడు కొమ్మలు, రెండవ వైపు నుండి మూడు కొమ్మలు, అంటే దాని పార్శ్వాల నుండి ఆరుకొమ్మలు మొలవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ఒక కొమ్మలో బాదం మొగ్గ, పువ్వు రూపాలు ఉన్న మూడు కలశాలు, రెండవ కొమ్మలో బాదం మొగ్గ, పువ్వురూపాలు ఉన్న మూడు కలశాలు, ఈ విధంగా దీపవృక్షం నుండి మొలిచిన కొమ్మల్లో ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","దీపవృక్ష కాండంలో బాదం పువ్వు రూపంలో ఉన్న నాలుగు కలశాలు, వాటి మొగ్గలు, వాటి పువ్వులు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","దీపవృక్ష కాండం నుండి నిగిడే ఆరుకొమ్మలకు దాని రెండేసి కొమ్మల కింద ఏకాండమైన ఒక్కొక్క మొగ్గ చొప్పున ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","వాటి మొగ్గలు, వాటి కొమ్మలు దానితో ఏకాండంగా ఉండాలి. అదంతా ఏకాండంగా సాగగొట్టిన మేలిమి బంగారంతో చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","నీవు దానికి ఏడు దీపాలు చేయాలి. దాని ఎదుటి భాగానికి వెలుగు ప్రసరించేలా దాని దీపాలు వెలిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","దాని పట్టుకారును, పటకారు పళ్ళేన్ని మేలిమి బంగారంతో చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ఆ ఉపకరణాలన్నిటిని 30 కిలోల మేలిమి బంగారంతో చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","కొండ మీద నీకు చూపించిన వాటి నమూనా ప్రకారం వాటిని చేయడానికి జాగ్రత్త పడు.” ");
INSERT INTO tel2017_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“నీవు పది తెరలతో ఒక మందిరాన్ని కట్టాలి. సన్న నారతో, నీల ధూమ్ర రక్త వర్ణాలు కలిపి పేనిన ఉన్నితో కెరూబు ఆధార నమూనాగా వాటిని చెయ్యాలి. అది నేర్పుగల కళాకారుని పనిగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ప్రతి తెర పొడవు 28 మూరలు. వెడల్పు నాలుగు మూరలు. ఆ తెరలన్నిటికీ ఒకటే కొలత. ");
INSERT INTO tel2017_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ఐదు తెరలను ఒక దానితో ఒకటి కలిపి కుట్టాలి. మిగిలిన ఐదు తెరలను కూడా ఒక దానితో ఒకటి కలిపి కుట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","తెరల కూర్పు చివర మొదటి తెర అంచుకి నీలినూలుతో ఉచ్చులు చేయాలి. రెండవ కూర్పులోని బయటి తెర చివర కూడా అలానే చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ఒక తెరలో ఏభై ఉచ్చులు చేసి, అవి ఒకదానికొకటి తగులుకునేలా ఆ రెండవ కూర్పులోని తెర అంచులో ఏభై ఉచ్చులు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ఏభై బంగారు గుండీలను చేసి ఆ గుండీలతో ఆ తెరలను ఒకదానితో ఒకటి కూర్చాలి. అది అంతా ఒకటే మందిరంగా రూపొందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","మందిరం పైకప్పుగా మేకవెంట్రుకలతో తెరలు చెయ్యాలి. అలా పదకొండు తెరలు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ప్రతి తెర పొడవు ముప్ఫై మూరలు, వెడల్పు నాలుగు మూరలు, అలా పదకొండు తెరల కొలత ఒక్కటే. ");
INSERT INTO tel2017_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ఐదు తెరలను ఒకటిగా, ఆరు తెరలను ఒకటిగా ఒక దానికొకటి కూర్చాలి. ఆరవ తెరను గుడారం ఎదుటి భాగాన మడత పెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","తెరల కూర్పుకు బయటున్న తెర అంచున ఏభై ఉచ్చులను, రెండవ కూర్పులోపల తెర అంచున ఏభై ఉచ్చులను చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ఏభై యిత్తడి గుండీలు చేసి ఒకటే గుడారమయ్యేలా ఆ గుండీలను ఆ ఉచ్చులకు తగిలించి కూర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ఆ తెరల్లో మిగిలిన వేలాడే భాగం అంటే మిగిలిన సగం తెర మందిరం వెనక భాగంలో వ్రేలాడుతూ ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","గుడారపు తెరల పొడవులో మిగిలినది ఈ వైపు ఒక మూర, ఆ వైపు ఒక మూర మందిరం పైకప్పుగా ఈ వైపు, ఆ వైపు వేలాడాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ఎర్ర రంగు వేసిన పొట్టేళ్ల తోళ్లతో పై కప్పును చేసి, దాన్ని సీలు జంతువు తోళ్లతో కప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","మందిరానికి తుమ్మ చెక్కతో నిలువు పలకలు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","పలక పొడవు పది మూరలు, వెడల్పు మూరెడున్నర ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ప్రతి పలకలో ఒకదానిలో ఒకటి కూర్చునే విధంగా రెండు కుసులు ఉండాలి. ఆ విధంగా మందిరం పలకలన్నిటికీ చెక్కాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","నీవు మందిరానికి పలకలు చేసేటప్పుడు ఇరవై పలకలు కుడి వైపున, అంటే దక్షిణ దిక్కున చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ఒక్కొక్క పలక కింద దాని రెండు కుసులకు రెండు దిమ్మలను, అంటే ఆ ఇరవై పలకల కింద నలభై వెండి దిమ్మలను చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","మందిరం రెండవ వైపు అంటే ఉత్తర దిక్కున ");
INSERT INTO tel2017_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ఒక్కొక్క పలక కింద రెండు దిమ్మలు చొప్పున ఇరవై పలకలకు నలభై వెండి దిమ్మలు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","పడమర వైపు అంటే మందిరం వెనక వైపు ఆరు పలకలు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ఆ వెనక వైపు మందిరం మూలలకు రెండు పలకలు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","అవి అడుగున దేనికదేగా ఉండాలి గానీ పై భాగంలో మాత్రం ఒకే రింగులో కూర్చుని ఉండాలి. ఆ విధంగా ఆ రెంటికీ ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","పలకలు ఎనిమిది. వాటి వెండి దిమ్మలు పదహారు. ఒక్కొక్క పలక కింద రెండు దిమ్మలుండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","తుమ్మచెక్కతో అడ్డ కర్రలు చెయ్యాలి. మందిరం ఒక వైపు పలకలకు ఐదు అడ్డ కర్రలు, ");
INSERT INTO tel2017_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","మందిరం రెండవ వైపు పలకలకు ఐదు అడ్డ కర్రలు, పడమటి వైపున మందిరం పలకలకు ఐదు అడ్డ కర్రలు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ఆ పలకల మధ్య ఉండే అడ్డ కర్ర ఈ చివరి నుండి ఆ చివరి వరకూ ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ఆ పలకలకు బంగారు రేకు పొదిగించాలి. వాటి అడ్డ కర్రలుండే వాటి రింగులను బంగారంతో చేసి అడ్డ కర్రలకు కూడా బంగారు రేకు పొదిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","కొండ మీద నీకు చూపించిన దాని నమూనా ప్రకారం మందిరాన్ని నిలబెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","నీవు నీల ధూమ్ర రక్త వర్ణాల సన్న నారతో నేసిన ఒక అడ్డ తెరను చెయ్యాలి. అది కళాకారుని నైపుణ్యంతో కెరూబు ఆధార నమూనాగా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","తుమ్మచెక్కతో చేసి బంగారు రేకు పొదిగిన నాలుగు స్తంభాలపై దాన్ని వెయ్యాలి. దాని కొక్కేలు బంగారువి. వాటి దిమ్మలు వెండివి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ఆ అడ్డతెరను ఆ కొక్కేల కింద తగిలించి సాక్ష్యపు మందసం అడ్డ తెర లోపలికి తేవాలి. ఆ అడ్డతెర పరిశుద్ధస్థలాన్ని అతి పరిశుద్ధ స్థలాన్ని వేరు చేస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","అతి పరిశుద్ధ స్థలం లో సాక్ష్యపు మందసం మీద ప్రాయశ్చిత్త మూతను ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","అడ్డతెర బయట బల్లను, ఆ బల్ల ఎదుట దక్షిణం వైపున ఉన్న మందిరం ఉత్తర దిక్కున దీప వృక్షాన్ని ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","నీల ధూమ్ర రక్త వర్ణాలతో పేనిన సన్న నారతో కళాకారుని నైపుణ్యంతో చేసిన తెరను గుడారపు ద్వారం కోసం చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ఆ తెరకు ఐదు స్తంభాలను తుమ్మ చెక్కతో చేసి వాటికి బంగారు రేకు పొదిగించాలి. వాటి కొక్కేలు బంగారువి. వాటికి ఐదు ఇత్తడి దిమ్మలు పోత పోయాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“నీవు తుమ్మచెక్కతో ఐదు మూరల పొడవు ఐదు మూరల వెడల్పు గల బలిపీఠం చెయ్యాలి. ఆ బలిపీఠం నలుచదరంగా ఉండాలి. దాని యెత్తు మూడు మూరలు. ");
INSERT INTO tel2017_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","దాని నాలుగు మూలలా దానికి కొమ్ములు చెయ్యాలి. దాని కొమ్ములు దానితో ఏకాండంగా ఉండాలి. దానికి ఇత్తడి రేకు పొదిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","దాని బూడిద ఎత్తడానికి కుండలను, గరిటెలను, గిన్నెలను, ముళ్ళను, అగ్నిపాత్రలను చెయ్యాలి. ఈ ఉపకారణాలన్నిటినీ ఇత్తడితో చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","దానికి వలలాంటి ఇత్తడి జల్లెడ చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ఆ వల మీద దాని నాలుగు మూలలా నాలుగు ఇత్తడి రింగులు చేసి ఆ వల బలిపీఠం మధ్యకి చేరేలా కిందిభాగంలో బలిపీఠం గట్టు కింద దాన్ని ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","బలిపీఠం కోసం మోతకర్రలను చెయ్యాలి. ఆ మోతకర్రలను తుమ్మచెక్కతో చేసి వాటికి ఇత్తడి రేకు పొదిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ఆ మోతకర్రలను ఆ రింగుల్లో చొప్పించాలి. బలిపీఠం మోయడానికి ఆ మోతకర్రలు దాని రెండువైపులా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","పలకలతో గుల్లగా దాన్ని చెయ్యాలి. కొండ మీద నీకు చూపించిన నమూనా ప్రకారం దాన్ని చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","నీవు మందిరానికి ఆవరణం ఏర్పాటు చెయ్యాలి. కుడివైపున, అంటే దక్షిణ దిక్కున ఆవరణం నూరు మూరల పొడవు ఉండాలి. పేనిన సన్న నార తెరలు ఒక వైపుకు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","దాని ఇరవై స్తంభాలు, వాటి ఇరవై దిమ్మలు ఇత్తడివి. ఆ స్తంభాల కొక్కేలు, వాటి పెండెబద్దలు వెండివి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","అలాగే పొడవులో ఉత్తర దిక్కున నూరు మూరల పొడవు గల తెరలు ఉండాలి. దాని ఇరవై స్తంభాలు, వాటి ఇరవై దిమ్మలు ఇత్తడివి. ఆ స్తంభాల కొక్కేలు, వాటి పెండెబద్దలు వెండివి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","పడమటి దిక్కున ఆవరణం వెడల్పులో ఏభై మూరల తెరలు ఉండాలి. వాటి స్తంభాలు పది. వాటి దిమ్మలు పది. ");
INSERT INTO tel2017_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","తూర్పు వైపున, అంటే తూర్పు దిక్కున ఆవరణం వెడల్పు ఏభై మూరలు. ");
INSERT INTO tel2017_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ఒక వైపు పదిహేను మూరల తెరలుండాలి. వాటి స్తంభాలు మూడు, వాటి దిమ్మలు మూడు. ");
INSERT INTO tel2017_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","రెండవ వైపు పదిహేను మూరల తెరలుండాలి. వాటి స్తంభాలు మూడు, వాటి దిమ్మలు మూడు. ");
INSERT INTO tel2017_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ఆవరణ ద్వారానికి నీల ధూమ్ర రక్త వర్ణాల తెరలు ఇరవై మూడు ఉండాలి. అవి పేనిన సన్ననారతో కళాకారుని పనిగా ఉండాలి. వాటి స్తంభాలు నాలుగు, వాటి దిమ్మలు నాలుగు. ");
INSERT INTO tel2017_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ఆవరణం చుట్టూ ఉన్న స్తంభాలన్నీ వెండి పెండెబద్దలు కలవి. వాటి కొక్కేలు వెండివి. వాటి దిమ్మలు ఇత్తడివి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ఆవరణం పొడవు నూరు మూరలు. దాని వెడల్పు ఏభై మూరలు. దాని ఎత్తు ఐదు మూరలు. అవి పేనిన సన్ననారతో చేశారు. వాటి దిమ్మలు ఇత్తడివి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","మందిరంలో వాడే ఉపకరణాలన్నీ ఆవరణపు మేకులన్నీ ఇత్తడివై యుండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","దీపం నిత్యం వెలుగుతుండేలా ప్రమిదలకు దంచి తీసిన స్వచ్ఛమైన ఒలీవల నూనె తేవాలని ఇశ్రాయేలీయులకు ఆజ్ఞాపించు. ");
INSERT INTO tel2017_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","సాక్ష్యపు మందసం ఎదుట ఉన్న తెర బయట ప్రత్యక్ష గుడారంలో అహరోను, అతని కుమారులు సాయంకాలం మొదలు ఉదయం దాకా యెహోవా సన్నిధిలో దాన్ని సవరిస్తూ ఉండాలి. అది ఇశ్రాయేలీయులకు వారి తరతరాల వరకూ నిత్య శాసనం.” ");
INSERT INTO tel2017_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“నాకు యాజకత్వం చేయడానికి నీ సోదరుడు అహరోనును అతని కొడుకులు నాదాబును, అబీహును, ఎలియాజరును ఈతామారును ఇశ్రాయేలీయుల్లో నుండి నీ దగ్గరికి పిలిపించు. ");
INSERT INTO tel2017_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","అతనికి గౌరవం, వైభవం కలిగేలా నీ సోదరుడు అహరోనుకు ప్రతిష్ఠిత వస్త్రాలు కుట్టించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","అహరోను నాకు యాజక సేవ జరిగించేలా నీవు అతణ్ణి ప్రత్యేక పరచడం కోసం అతని దుస్తులు కుట్టించాలి. నేను జ్ఞానాత్మతో నింపిన నిపుణులు అందరికీ ఆజ్ఞ జారీ చెయ్యి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","వారు కుట్టవలసిన దుస్తులు ఇవి. వక్ష పతకం, ఏఫోదు, నిలువుటంగీ, రంగు దారాలతో కుట్టిన చొక్కా, తల పాగా, నడికట్టు. అతడు నాకు యాజకుడై యుండేలా వారు నీ సోదరుడు అహరోనుకు, అతని కుమారులకు ప్రతిష్ఠిత దుస్తులు కుట్టించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","కళాకారులు బంగారు, నీల, ధూమ్ర, రక్త వర్ణాలు గల నూలును సన్ననారను దీనికి ఉపయోగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","బంగారం నీల ధూమ్ర రక్త వర్ణాల ఏఫోదును పేనిన సన్న నారతో కళాకారుని నైపుణ్యంతో చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","రెండు భుజాలకు సరిపడేలా రెండు పై అంచుల్లో కూర్చిన పట్టీలు దానికి ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ఏఫోదుపై ధరించడానికి పనితనంతో చేసిన నడికట్టు ఏకాండంగా ఉండి, బంగారంతో, నీల, ధూమ్ర, రక్త వర్ణాల నూలుతో, పేనిన సన్ననారతో కుట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","నీవు రెండు లేత పచ్చలను తీసుకుని వాటి మీద ఇశ్రాయేలీయుల పేర్లను అంటే వారి పుట్టుక క్రమం చొప్పున ");
INSERT INTO tel2017_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ఒక రత్నం మీద ఆరు పేర్లు, రెండవ రత్నం మీద తక్కిన ఆరు పేర్లను చెక్కించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ముద్ర మీద చెక్కిన పనిలాగా ఆ రెండు రత్నాలపై ఇశ్రాయేలీయుల పేర్లు చెక్కి బంగారు కుదురుల్లో వాటిని పొదగాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","అప్పుడు ఇశ్రాయేలీయులకు స్మారక సూచకమైన ఆ రెండు రత్నాలను ఏఫోదు భుజాలపై నిలపాలి. ఆ విధంగా అహరోను తన రెండు భుజాలపై యెహోవా సన్నిధిలో జ్ఞాపక సూచనగా ఆ పేర్లను ధరిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","బంగారు కుదురులను తయారు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","మేలిమి బంగారంతో రెండు అల్లిక గొలుసులను చెయ్యాలి. ఆ అల్లిక పనికి అల్లిన గొలుసులను తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","కళాకారుని నైపుణ్యంతో న్యాయనిర్ణయ పతకాన్ని చెయ్యాలి. ఏఫోదు పని లాగా దాన్ని చెయ్యాలి. బంగారంతో, నీల ధూమ్ర రక్త వర్ణాల నూలుతో పేనిన సన్ననారతో దాన్ని చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","నలుచదరంగా ఉన్న ఆ పతకాన్ని మడత పెట్టాలి. దాని పొడవు జానెడు, వెడల్పు జానెడు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","దానిలో నాలుగు వరసల్లో రత్నాలుండేలా రత్నాల కుదుర్లు చెయ్యాలి. మొదటి వరస మాణిక్యం, గోమేధికం, మరకతం. ");
INSERT INTO tel2017_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","రెండో వరస పద్మరాగం, నీలం, వజ్రం. ");
INSERT INTO tel2017_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","మూడవది గారుత్మతం, యష్మురాయి, ఇంద్రనీలం. ");
INSERT INTO tel2017_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","నాలుగవ వరస గరుడ పచ్చ, సులిమాని రాయి, సూర్యకాంతం. వాటిని బంగారు కుదురుల్లో పొదగాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ఆ రత్నాలపై ఇశ్రాయేలీయుల పేర్ల ప్రకారం పన్నెండు పేర్లు ఉండాలి. ముద్ర మీద చెక్కినట్టు వారిలో ఒక్కొక్క పేరు చొప్పున పన్నెండు గోత్రాల పేర్లు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ఆ పతకాన్ని అల్లిక పనిగా పేనిన గొలుసులతో మేలిమి బంగారంతో చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","పతకానికి రెండు బంగారు రింగులు చేసి ");
INSERT INTO tel2017_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ఆ రెండు రింగులను పతకపు రెండు కొసలకు అల్లిన ఆ రెండు బంగారు గొలుసులను తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","అల్లిన ఆ రెండు గొలుసుల కొసలను రెండు కుదురులకు తగిలించి ఏఫోదు ముందు వైపు భుజాలపై కట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","నీవు బంగారంతో రెండు రింగులు చేసి ఏఫోదు ముందు భాగంలో పతకం లోపలి అంచున దాని రెండు కొసలకు వాటిని తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","నీవు రెండు బంగారు రింగులు చేసి ఏఫోదు నమూనా ప్రకారం చేసిన నడికట్టుపై దాని ముందు వైపు కింది భాగంలో ఏఫోదు రెండు భుజాలకు వాటిని తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","అప్పుడు పతకం ఏఫోదు నమూనా ప్రకారం చేసిన నడికట్టుకు పైగా ఉండేలా బిగించాలి. అది ఏఫోదునుండి విడిపోకుండా ఉండేలా వారు దాని రింగులను నీలి దారంతో కట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","ఆ విధంగా అహరోను పరిశుద్ధ స్థలం లోకి వెళ్ళినప్పుడల్లా అతడు తన రొమ్ము మీద న్యాయనిర్ణయ పతకంలోని ఇశ్రాయేలీయుల పేర్లను నిత్యం యెహోవా సన్నిధిలో జ్ఞాపకార్థంగా ధరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","నీవు ఈ న్యాయనిర్ణయ పతకంలో ఊరీము తుమ్మీము అనే వాటిని ఉంచాలి. అహరోను యెహోవా సన్నిధికి వెళ్లినప్పుడల్లా అవి అతని రొమ్ముపై ఉంటాయి. అతడు యెహోవా సన్నిధిలో తన రొమ్ముపై ఇశ్రాయేలీయుల న్యాయనిర్ణయాలను నిత్యం భరిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ఏఫోదు నిలువుటంగీని కేవలం నీలిరంగు దారంతోనే కుట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","దాని మధ్య భాగంలో తల దూర్చడానికి రంధ్రం ఉండాలి. అది చినిగి పోకుండా మెడ కవచం లాగా దాని రంధ్రం చుట్టూ నేతపని గోటు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","దాని అంచుల చుట్టూ నీల ధూమ్ర రక్త వర్ణాల దానిమ్మ కాయ ఆకారాలను, వాటి మధ్యలో బంగారు గంటలను నిలువు టంగీ చుట్టూ తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ఒక్కొక్క బంగారు గంట, దానిమ్మకాయ ఆ నిలువుటంగీ కింది అంచున చుట్టూరా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","సేవ చేసేటప్పుడు అహరోను దాని ధరించాలి. అతడు యెహోవా సన్నిధిలో పరిశుద్ధస్థలం లోకి ప్రవేశించేటప్పుడు అతడు చావకుండేలా వాటి చప్పుడు వినబడుతూ ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","నీవు మేలిమి బంగారు రేకు చేసి ముద్ర చెక్కినట్టు దానిపై ‘యెహోవాకు పరిశుద్ధం’ అనే మాట చెక్కాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","పాగాపై ఉండేలా నీలి దారంతో దాన్ని కట్టాలి. అది పాగా ముందు వైపు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ఇశ్రాయేలీయులు అర్పించే పరిశుద్ధమైన అర్పణలన్నిటిలో వాటిలో ఇమిడి ఉన్న దోషాలను అహరోను భరించేలా అది అహరోను నుదిటిపై ఉండాలి. వారికి యెహోవా సన్నిధిలో ఆమోదం ఉండేలా అది నిత్యం అతని నుదుటిపై ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","సన్న నారతో చొక్కాయిని బుట్టాపనిగా చెయ్యాలి. సన్న నారతో పాగాను నేయాలి. నడికట్టును కూడా బుట్టాపనిగా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","నీవు అహరోను కుమారులకు చొక్కాలు కుట్టించాలి. వారికి నడికట్లు తయారు చెయ్యాలి. వారి ఘనత, వైభవాలు కలిగేలా వారికీ టోపీలు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","నీవు నీ సోదరుడు అహరోనుకు, అతని కుమారులకు వాటిని తొడిగించాలి. వారు నాకు యాజకులయ్యేలా వారికి అభిషేకం చేసి, వారిని ప్రతిష్ఠించి పవిత్రపరచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","వారి నగ్నతను కప్పుకొనేందుకు నీవు వారికి నారతో చేసిన లోదుస్తులు కుట్టించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","వారు ప్రత్యక్ష గుడారంలోకి ప్రవేశించేటప్పుడు గానీ పరిశుద్ధస్థలం లో సేవ చేయడానికి బలిపీఠం దగ్గరికి వచ్చేటప్పుడు గానీ వారు దోషులై చావకుండేలా అహరోను, అతని కుమారులు వాటిని ధరించాలి. ఇది అతనికి, అతని తరువాత అతని సంతానానికి ఎప్పటికీ నిలిచి ఉండే శాసనం.” ");
INSERT INTO tel2017_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“నాకు యాజకులయ్యేలా వాళ్ళను ప్రతిష్ట చేయడానికి నువ్వు ఈ విధంగా చెయ్యి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ఒక కోడెదూడను, లోపం లేని రెండు పొట్టేళ్లను తీసుకో. పొంగకుండా కాల్చిన రొట్టెను, పొంగకుండా వండిన నూనెతో కలిసిన వంటకాలను, నూనె పూసిన పలచని అప్పడాలు తీసుకో. ");
INSERT INTO tel2017_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","వాటిని గోదుమపిండితో చెయ్యాలి. వాటిని ఒక గంపలో ఉంచి ఆ గంపను, ఆ కోడెదూడను, ఆ రెండు పొట్టేళ్లను తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","అహరోనును అతని కొడుకులను సన్నిధి గుడారం గుమ్మం దగ్గరికి తీసుకువచ్చి వాళ్లకు నీళ్లతో స్నానం చేయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","అహరోనుకు దుస్తులు తొడిగి ఏఫోదు నిలువుటంగీని, ఏఫోదు వక్షపతకాన్ని వేసి, అల్లిక పని గల నడికట్టును అతనికి కట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","అతని తలమీద పాగా పెట్టి ఆ పాగా మీద పవిత్ర కిరీటం నిలబెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","తరువాత అభిషేక తైలం తీసుకుని అతని తల మీద పోసి అతణ్ణి అభిషేకించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","తరువాత అతని కొడుకులను రప్పించి వారికి అంగీలు తొడిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","అహరోనుకు, అతని కొడుకులకూ నడికట్లు కట్టి వారికి టోపీలు పెట్టాలి. ఈ విధంగా అహరోనును, అతని కొడుకులను ప్రతిష్టించాలి. యాజకత్వ నిర్వహణ పదవి వారికి చెందుతుంది. ఇది ఎప్పటికీ నిలిచి ఉండే కట్టుబాటు. ");
INSERT INTO tel2017_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","నువ్వు సన్నిధి గుడారం ఎదుటికి ఆ కోడెదూడను తెప్పించాలి. అహరోను, అతని కొడుకులు ఆ కోడెదూడ తలపై తమ చేతులు ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","సన్నిధి గుడారం ద్వారం దగ్గర యెహోవా సన్నిధానంలో ఆ కోడెదూడను వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","వధించిన ఆ కోడెదూడ రక్తంలో కొంచెం తీసుకుని నీ వేలుతో బలిపీఠం కొమ్ముల మీద పూయాలి. మిగిలిన రక్తమంతా బలిపీఠం కింద పారబోయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","దాని పేగులకు, కాలేయానికి, రెండు మూత్రపిండాలకు పట్టిన కొవ్వు అంతటినీ తీసివేసి బలిపీఠంపై కాల్చివెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ఆ దూడ మాంసం, చర్మం, దాని పేడ అంతటినీ శిబిరం బయట కాల్చివెయ్యాలి. అది పాప పరిహారం కోసం అర్పించే బలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","నువ్వు ఆ రెండు పొట్టేళ్లలో ఒకదాన్ని తీసుకోవాలి. అహరోను, అతని కొడుకులు ఆ పొట్టేలు తల మీద తమ చేతులుంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ఆ పొట్టేలును వధించి దాని రక్తం తీసి బలిపీఠం చుట్టూ రక్తాన్ని చల్లాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","తరువాత ఆ పొట్టేలును దాని అవయవాలను దేనికి అది విడదీసి దాని పేగులు, కాళ్ళు కడిగి, దాని అవయవాలను, తలను మొత్తంగా పేర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","పోట్టేలులోని ఆ భాగాలన్నిటినీ బలిపీఠంపై కాల్చివెయ్యాలి. అది యెహోవాకు హోమబలి. అది యెహోవాకు పరిమళం కలిగించే ఇష్టమైన హోమం. ");
INSERT INTO tel2017_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","తరువాత రెండవ పొట్టేలును తీసుకోవాలి. అహరోను, అతని కొడుకులు ఆ పొట్టేలు తల మీద తమ చేతులుంచిన తరువాత ");
INSERT INTO tel2017_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ఆ పొట్టేలును వధించి దాని రక్తంలో కొంచెం తీసుకుని అహరోను కుడి చెవి అంచు మీద, అతని కొడుకుల కుడి చెవుల అంచుల మీద, వాళ్ళ కుడి చెయ్యి, కుడి కాలు బొటన వేళ్ళపై చిలకరించి మిగిలిన రక్తం బలిపీఠం మీద చుట్టూ చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","బలిపీఠంపై ఉన్న రక్తంలో కొంచెం, అభిషేక తైలంలో కొంచెం తీసుకుని అహరోను మీదా, అతని వస్త్రాల మీదా, అతని కొడుకుల మీదా, వాళ్ళ వస్త్రాల మీదా చిలకరించాలి. అప్పుడు అతడూ అతని వస్త్రాలూ, అతని కొడుకులూ వాళ్ళ వస్త్రాలూ పవిత్రం అవుతాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ఆ పొట్టేలు సేవ కోసం ప్రతిష్ఠితమైనది గనక దాని కొవ్వునూ, కొవ్విన తోకనూ, పేగులపై ఉన్న కొవ్వునూ, కాలేయం, రెండు మూత్రపిండాల చుట్టూ ఉన్న కొవ్వునూ, కుడి తొడను వేరు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","వాటితోపాటు యెహోవా ఎదుట ఉన్న పొంగకుండా కాల్చిన గుండ్రని రొట్టెను, నూనెతో వండిన వంటకాలను, ఒక పలచని అప్పడాన్ని తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","అహరోను, అతని కొడుకుల చేతుల్లో వాటినన్నిటినీ ఉంచాలి. కదలించే నైవేద్యంగా యెహోవా సన్నిధిలో వాటిని కదిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","తరువాత వాళ్ళ చేతుల్లోనుంచి వాటిని తీసుకుని బలిపీఠంపై కాల్చివెయ్యాలి. అది యెహోవాకు హోమబలి. అది యెహోవాకు పరిమళం కలిగించే ఇష్టమైన హోమం. ");
INSERT INTO tel2017_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","అహరోను సేవా ప్రతిష్ట కోసం నియమించిన ఆ పొట్టేలు బోరను తీసుకుని యెహోవా సన్నిధిలో కదిలించే అర్పణగా దాన్ని కదిలించాలి. ఆ భాగం నీది అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ప్రతిష్టించిన ఆ పొట్టేలులో అంటే అహరోను, అతని కొడుకులకు చెందిన దానిలో కదిలించే బోరను, ప్రతిష్ఠితమైన తొడను నాకు ప్రతిష్ఠించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ఆ ప్రతిష్టార్పణ అహరోనుది, అతని కొడుకులది అవుతుంది. అది ఇశ్రాయేలు ప్రజలు ఇచ్చిన కానుక. అది నిత్యమూ నిలిచి ఉండే కట్టుబాటు. అది ఇశ్రాయేలు ప్రజలు అర్పించే శాంతి బలుల్లో నుండి యెహోవాకు అర్పించిన కానుక. ");
INSERT INTO tel2017_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","అహరోను ధరించిన ప్రతిష్ఠిత వస్త్రాలు అతని తరువాత అతని కొడుకులకు చెందుతాయి. వాళ్ళ అభిషేకం, ప్రతిష్ట జరిగే సమయంలో వారు ఆ వస్త్రాలను ధరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","అహరోను కొడుకుల్లో అతనికి బదులుగా యాజక వృత్తి ఎవరు చేపడతాడో అతడు పవిత్ర స్థలం లో సేవ చేయడానికి సన్నిధి గుడారంలోకి వెళ్ళే సమయానికి ముందు ఏడు రోజులపాటు ఆ వస్త్రాలు ధరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","నువ్వు ప్రతిష్ట అయిన పొట్టేలును తీసుకుని పవిత్రమైన చోట దాని మాంసం వండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","అహరోను, అతని కొడుకులు సన్నిధి గుడారం గుమ్మం దగ్గర ఆ పొట్టేలు మాంసాన్నీ, గంపలో ఉన్న రొట్టెలనూ తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","వారిని ప్రతిష్ఠ చేయడానికీ, పవిత్రపరచడానికీ వేటి ద్వారా ప్రాయశ్చిత్తం జరిగిందో వాటిని వాళ్ళు తినాలి. అవి పవిత్రమైనవి కాబట్టి యాజకుడు కానివాడు వాటిని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","సేవ కోసం ప్రతిష్ఠి అయిన మాంసంలో గానీ, రొట్టెల్లో గానీ ఉదయం దాకా ఏమైనా మిగిలిపోతే వాటిని కాల్చివెయ్యాలి. అది ప్రతిష్ట అయినది గనక దాన్ని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","నేను నీకు ఆజ్ఞాపించిన విషయాలన్నిటి ప్రకారం నువ్వు అహరోనుకు, అతని కొడుకులకూ జరిగించాలి. ఏడు రోజుల పాటు వాళ్ళను సేవా ప్రతిష్ట కోసం సిద్ధపరచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","వారి పాపాలను కప్పివేయడానికి ప్రతిరోజూ ఒక కోడెదూడను పరిహార బలిగా అర్పించాలి. బలిపీఠానికి ప్రాయశ్చిత్తం చేయడానికి దానికి పాపపరిహార బలి అర్పించి దానికి అభిషేకం చేసి తిరిగి ప్రతిష్ఠించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ఏడు రోజులపాటు బలిపీఠం కోసం ప్రాయశ్చిత్తం చేస్తూ దాన్ని పవిత్రం చెయ్యాలి. ఆ బలిపీఠం అతి పవిత్రంగా ఉంటుంది. బలిపీఠానికి తగిలేదంతా పవిత్రం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","బలిపీఠం మీద ఎప్పుడూ అర్పణలు జరుగుతూ ఉండాలి. ఒక సంవత్సరం లోపు వయసున్న రెండు గొర్రెపిల్లలను ప్రతి రోజూ అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ఉదయం ఒక గొర్రెపిల్ల, సాయంత్రం ఒక గొర్రెపిల్ల అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ఉదయం అర్పించే గొర్రెపిల్లతోబాటు దంచి తీసిన నూనెతో కలిపిన ఒక కిలో పిండిని, పానార్పణగా లీటరు ద్రాక్షరసాన్నీ అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ఉదయం అర్పించినట్టు సాయంత్రం కూడా చెయ్యాలి. యెహోవాకు అర్పణనూ, పానార్పణనూ అర్పించాలి. అది యెహోవాకు హోమబలి. అది యెహోవాకు పరిమళంగా ఉండే ఇష్టమైన హోమం. ");
INSERT INTO tel2017_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ఇది యెహోవా సన్నిధానంలో సన్నిధి గుడారం ద్వారం దగ్గర మీరు తరతరాలకు అర్పించవలసిన హోమబలి. నేను అక్కడకు వచ్చి మిమ్మల్ని కలుసుకుని మీతో మాట్లాడతాను. ");
INSERT INTO tel2017_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","అక్కడ ఇశ్రాయేలు ప్రజలను కలుసుకుంటాను. ఆ స్థలం నా మహిమా ప్రకాశం వల్ల పవిత్రం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","నేను సన్నిధి గుడారాన్ని, బలిపీఠాన్ని పవిత్రం చేస్తాను. నాకు యాజకులుగా ఉండేందుకు అహరోనును, అతని కొడుకులను పరిశుద్ధ పరుస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","నేను ఇశ్రాయేలు ప్రజల మధ్య నివసించి వారికి దేవుడుగా ఉంటాను. ");
INSERT INTO tel2017_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","వాళ్ళ మధ్య నివసించడానికి తమను ఐగుప్తు దేశం నుండి బయటకు రప్పించిన దేవుణ్ణి నేనే అని వాళ్ళు తెలుసుకుంటారు. వాళ్ళ దేవుడైన యెహోవాను నేనే.” ");
INSERT INTO tel2017_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. “ధూపం వేయడానికి తుమ్మకర్రతో మందసాన్ని తయారు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","దాని పొడవు ఒక మూర, వెడల్పు ఒక మూర, ఎత్తు రెండు మూరలు ఉండాలి. అది చదరంగా ఉండాలి. దాని కొమ్ములు దానితో ఏకాండంగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","దాని లోపల, బయటా నాలుగు పక్కలా స్వచ్ఛమైన బంగారం రేకు పొదిగించాలి. దాని అంచును బంగారంతో అలంకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","దానికి బంగారంతో నాలుగు గుండ్రని కొంకీలు తగిలించి, ఒక వైపు రెండు కమ్మీలు, ముందు భాగంలో రెండు గుండ్రని కమ్మీలు ఉండేలా దాని నాలుగు కాళ్లకు వాటిని తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","తుమ్మకర్రతో మందసాన్ని మోసే కర్రలు సిద్ధం చేసి వాటికి బంగారం రేకులు పొదిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","వేదికను శాసనాల పెట్టెకు ముందు ఉన్న తెర బయట, శాసనాలపై ప్రాయశ్చిత్త స్థానం ఎదురుగా ఉంచాలి. అక్కడ నేను నిన్ను కలుసుకుంటాను. ");
INSERT INTO tel2017_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","అహరోను ఆ వేదికపై పరిమళ ద్రవ్యాల ధూపం వెయ్యాలి. అతడు ప్రతిరోజూ ఉదయం దీపాలను సర్దే సమయంలో దాని మీద ధూపం వెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","అలాగే సాయంత్రాలు అహరోను దీపాలు వెలిగించే సమయంలో కూడా వేదికపై ధూపం వెయ్యాలి. యెహోవా సన్నిధిలో మీ తరతరాలకూ నిత్యంగా ఆ ధూపం ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","దాని మీద నిషిద్ధమైన వేరే ధూపాలు వెయ్యకూడదు. హోమాన్ని గానీ, నైవేద్య ద్రవ్యాలను గానీ అర్పించకూడదు. పానార్పణలు అర్పించ కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","అహరోను ఆ వేదిక కొమ్ముల మీద సంవత్సరానికి ఒకసారి ప్రాయశ్చిత్తం చెయ్యాలి. పాప పరిహారార్థబలి రక్తంతో దాని కొమ్ముల కోసం ప్రాయశ్చిత్తం చెయ్యాలి. మీ తరతరాలకూ సంవత్సరానికి ఒకసారి అతడు వేదిక కోసం ప్రాయశ్చిత్తం చెయ్యాలి. అది యెహోవాకు అతి పవిత్రమైనదిగా ఉంటుంది.” ");
INSERT INTO tel2017_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","యెహోవా మోషేతో ఇంకా ఇలా చెప్పాడు, ");
INSERT INTO tel2017_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“నువ్వు ఇశ్రాయేలు ప్రజల సంఖ్య లెక్కబెట్టాలి. వాళ్ళను లెక్కించే సమయానికి తమపై ఎలాంటి కీడు రాకుండా ప్రతి ఒక్కరూ తమ ప్రాణం కోసం విడుదల పరిహార ధనం యెహోవాకు చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","జాబితాలో నమోదు అయిన ప్రతివాడూ అర తులం వెండి చెల్లించాలి. పవిత్ర స్థలం లెక్క చొప్పున పూర్తి బరువు ఇవ్వాలి. యెహోవాకు అర్పణగా దాన్ని చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ఇరవై సంవత్సరాలు, అంతకంటే ఎక్కువ వయస్సు ఉన్నవాళ్ళంతా జన సంఖ్యలో నమోదు కావాలి. జన సంఖ్యలో చేర్చే ప్రతి ఒక్కరూ యెహోవాకు అర్పణ చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","విడుదల పరిహార ధనంగా యెహోవాకు మీరు చెల్లించే అర్పణ ధనవంతుడైనా, పేదవాడైనా సమానంగా ఉండాలి. ఇద్దరూ అర తులం చొప్పున చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ఇశ్రాయేలు ప్రజలు విడుదల పరిహార ధనంగా చెల్లించిన వెండిని సన్నిధి గుడారం సేవ కోసం ఉపయోగించాలి. అది ప్రాయశ్చిత్త పరిహారంగా ప్రజల పక్షంగా యెహోవా సన్నిధానంలో ఇశ్రాయేలు ప్రజలకు జ్ఞాపకార్ధంగా ఉంటుంది.” ");
INSERT INTO tel2017_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","యెహోవా మోషేతో ఇంకా ఇలా అన్నాడు. “నువ్వు ఇత్తడితో ఒక గంగాళం సిద్ధం చేసి ఇత్తడి పీటపై ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","సన్నిధి గుడారానికి, బలిపీఠానికి మధ్యలో ఆ గంగాళం ఉంచి దాన్ని నీళ్లతో నింపాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ఆ నీళ్లతో అహరోను, అతని కొడుకులు తమ కాళ్ళు, చేతులు కడుక్కోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","వాళ్ళు సన్నిధి గుడారం లోపలికి వెళ్ళే సమయంలో చనిపోకుండా ఉండేలా నీళ్ళతో తమను శుభ్రం చేసుకోవాలి. సేవ చేయడానికి బలిపీఠం సమీపించి యెహోవాకు హోమం అర్పించే ముందు వారు నీళ్ళతో శుభ్రం చేసుకోవాలి. అలా చెయ్యని పక్షంలో చనిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","వాళ్ళు చనిపోకుండా ఉండేలా తమ కాళ్ళు, చేతులు కడుక్కోవాలి. ఇది వారికి, అంటే అహరోనుకి, అతని సంతానానికి, తరతరాలకు నిలిచి ఉండే చట్టం.” ");
INSERT INTO tel2017_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","యెహోవా మోషేతో ఇంకా ఇలా చెప్పాడు, ");
INSERT INTO tel2017_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“నువ్వు సుగంధ ద్రవ్యాల్లో ముఖ్యమైన వాటిని తీసుకుని అభిషేకం చెయ్యాలి. పవిత్ర స్థలానికి సంబంధించిన కొలతల ప్రకారం స్వచ్ఛమైన గోపరసం 500 షెకెల్, సుగంధం గల దాల్చిన చెక్క సగం అంటే 250 షెకెల్, ");
INSERT INTO tel2017_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","నిమ్మగడ్డి నూనె 250 షెకెల్, లవంగిపట్ట 500 షెకెల్, మూడు పాళ్ళు ఒలీవ నూనె తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","పరిమళ ద్రవ్యాలు మిళితం చేసే నిపుణుడైన పనివాడి చేత పరిమళ ద్రవ్యం సిద్ధపరచాలి. అది యెహోవాకు ప్రతిష్ఠి అభిషేక తైలం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ఆ తైలంతో నువ్వు సన్నిధి గుడారాన్ని అభిషేకించాలి. దానితోపాటు సాక్ష్యపు గుడారాన్ని, ");
INSERT INTO tel2017_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","సన్నిధి బల్లను, దాని సామగ్రిని, దీపస్తంభాన్ని, దాని సామగ్రిని, ");
INSERT INTO tel2017_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","హోమ బలిపీఠాన్ని, దాని సామగ్రిని, గంగాళాన్ని, దాని పీటను అభిషేకించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","అవన్నీ అతి పవిత్రమైనవిగా ఉండేలా వాటిని పవిత్రపరచాలి. వాటికి తగిలే ప్రతి వస్తువూ పవిత్రం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","అహరోను, అతని కొడుకులు నాకు యాజకులై నాకు సేవ చేసేలా వాళ్ళను అభిషేకించి ప్రతిష్ఠించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","నీవు ఇశ్రాయేలు ప్రజలతో, ‘ఇది మీ తరతరాలకు నాకు పవిత్ర అభిషేక తైలంగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","దాన్ని యాజకులు కాని వాళ్ళ మీద పోయకూడదు. దాని పాళ్ళ ప్రకారం అలాంటి వేరే దాన్ని చెయ్యకూడదు. అది పవిత్రమైనది. దాన్ని మీరు పవిత్రంగా ఎంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","దాని వంటి దాన్ని కలిపే వాణ్ణి గానీ, యాజకుడు కాని వారిపై దాన్ని చల్లే వాణ్ణి గానీ తన ప్రజల్లో లేకుండా చెయ్యాలి’ అని చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","యెహోవా మోషేతో ఇంకా ఇలా చెప్పాడు “నువ్వు జటామాంసి, గోపిచందనం, గంధం, సాంబ్రాణి సమపాళ్ళలో తీసుకుని వాటితో పరిమళ ద్రవ్యాలను, ధూపద్రవ్యం సిద్ధపరచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","పరిమళ ద్రవ్యాల నిపుణుడైన పనివాడు దాన్ని కలపాలి. దానికి ఉప్పు కలపాలి. ఆ ధూప మిబాధం స్వచ్ఛమైనదిగా, పవిత్రంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","దానిలో కొంచెం పొడి తీసి నేను నిన్ను కలుసుకొనే సన్నిధి గుడారంలో శాసనాల మందసం ఎదుట ఉంచాలి. మీరు దాన్ని పరిశుద్ధమైనదిగా భావించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","నీవు చేయవలసిన ఆ ధూప ద్రవ్యాల వంటి ధూపాలను మీ కోసం కలుపుకోకూడదు. అది కేవలం యెహోవాకు ప్రత్యేకమైనది అని భావించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","దాని వాసన చూద్దామని అలాంటి దాన్ని తయారు చేసేవాణ్ణి ప్రజల్లో లేకుండా చెయ్యాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు, ");
INSERT INTO tel2017_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“యూదా గోత్రానికి చెందిన బెసలేలును నేను నియమించుకున్నాను. అతడు ఊరీ కొడుకు, హూరు మనుమడు. ");
INSERT INTO tel2017_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","అతనికి నేను అన్ని రకాల పనులు చెయ్యడానికి తెలివితేటలు, సమస్త జ్ఞానం, నేర్పరితనం ప్రసాదించాను. అతణ్ణి నా ఆత్మతో నింపాను. ");
INSERT INTO tel2017_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","అతడు బంగారంతో, వెండితో, ఇత్తడితో వివిధ రకాల ఆకృతులు నైపుణ్యంగా తయారు చేయగల నేర్పరి. రత్నాలు సానబెట్టి పొదగడంలో, చెక్కను కోసి నునుపు చేయడంలో నిపుణుడు. ");
INSERT INTO tel2017_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","నేను ప్రసాదించిన సమస్త జ్ఞానం, వివేకాలతో అతడు పనులు జరిగిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","దాను గోత్రానికి చెందిన అహీసామాకు కొడుకు అహోలీయాబు అతనికి సహాయంగా ఉంటాడు. నేను నీకు ఆజ్ఞాపించినవన్నీ తయారు చేయగల నిపుణులందరి హృదయాల్లో నా జ్ఞానం ఉంచుతాను. ");
INSERT INTO tel2017_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","నేను నీకు ఆజ్ఞాపించిన ప్రకారం వాళ్ళు సన్నిధి గుడారం, సాక్ష్యపు మందసం, దాని మీద ఉన్న కరుణాపీఠాన్ని, గుడారపు సామగ్రిని తయారు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","సన్నిధి బల్ల, దాని సామగ్రి, నిర్మలమైన దీపవృక్షం, దాని సామగ్రి తయారు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ధూపవేదిక, దహన బలిపీఠం, దాని సామగ్రి, గంగాళం, దాని పీట, ");
INSERT INTO tel2017_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","యాజక ధర్మం నెరవేర్చే అహరోనుకు, అతని కొడుకులకు ప్రతిష్టించిన దుస్తులు సిద్ధం చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","పరిశుద్ధ స్థలం కోసం అభిషేక తైలాన్ని, సుగంధ ధూప ద్రవ్యాలను సిద్ధం చెయ్యాలి. ఇవన్నీ నేను నీకు ఆజ్ఞాపించినట్టు జరగాలి.” ");
INSERT INTO tel2017_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","యెహోవా మోషేతో ఇలా చెప్పాడు. “నువ్వు ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పు. మీరు నేను నియమించిన విశ్రాంతి దినాన్ని కచ్చితంగా ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","మిమ్మల్ని పవిత్రంగా చేసే యెహోవాను నేనే అని మీరు తెలుసుకునేలా విశ్రాంతి దినం నాకు, మీకు, మీ తరతరాలకు ఒక చిహ్నంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","అందువల్ల మీరు విశ్రాంతి దినాన్ని కచ్చితంగా ఆచరించాలి. అది మీకు పవిత్రమైనది. ఆ దినాన్ని అపవిత్రం చేసే వాణ్ణి ప్రజల్లో లేకుండా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ఆరు రోజులు పని చేసిన తరువాత యెహోవాకు ప్రతిష్ఠితమైన ఏడవ రోజును విశ్రాంతి దినంగా పాటించాలి. విశ్రాంతి దినాన పని చేసే ప్రతివాడికీ తప్పకుండా మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ఇశ్రాయేలు ప్రజలు తమ తరతరాలు విశ్రాంతి దిన ఆచారం పాటించి ఆ దినాన్ని ఆచరించాలి. ఇది శాశ్వత కాలం నిలిచి ఉండే నియమం. ");
INSERT INTO tel2017_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","నాకు, ఇశ్రాయేలు ప్రజలకు మధ్య అది శాశ్వతంగా ఒక గుర్తుగా ఉంటుంది. ఎందుకంటే, యెహోవా ఆరు రోజులు భూమి ఆకాశాలను సృష్టి చేసి ఏడవ దినాన విశ్రాంతి తీసుకున్నాడు.” ");
INSERT INTO tel2017_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ఆయన సీనాయి కొండ మీద మోషేతో మాట్లాడడం ముగించిన తరువాత ఆయన తన వేలితో రాసిన శాసనాలు ఉన్న రెండు పలకలను మోషేకు అందించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","మోషే కొండ దిగి రావడం ఆలస్యం కావడం చూసిన ప్రజలు అహరోను దగ్గరికి వచ్చారు. “లే, మా ముందుండి మమ్మల్ని నడిపించడానికి మా కోసం ఒక దేవుణ్ణి సిద్ధం చెయ్యి. ఐగుప్తు నుండి మమ్మల్ని బయటకు తీసుకు వచ్చిన మోషే అనే వాడు ఏమయ్యాడో మాకు తెలియడం లేదు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","అప్పుడు అహరోను “మీ భార్యల, కొడుకుల, కూతుళ్ళ చెవులకు ఉన్న బంగారు పోగులు తీసి నా దగ్గరికి తీసుకు రండి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ప్రజలంతా తమ చెవులకున్న బంగారు పోగులు తీసి అహరోను దగ్గరికి తెచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","అతడు వాటిని తీసుకుని దూడ రూపం అచ్చుతో పోత పోసి బంగారం దూడను తయారు చేయించాడు. అప్పుడు ప్రజలు “ఓ ఇశ్రాయేలూ, ఐగుప్తు దేశం నుండి నిన్ను రప్పించిన నీ దేవుడు ఇదే” అని కేకలు వేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","అహరోను దాన్ని చూసి దాని ఎదుట ఒక బలిపీఠం కట్టించాడు. తరువాత అహరోను “రేపు యెహోవాకు పండగ జరుగుతుంది” అని చాటింపు వేయించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","తరువాతి రోజు ప్రజలు ఉదయాన్నే లేచి హోమబలులు, శాంతిబలులు సమర్పించారు. తరువాత ప్రజలు తినడానికి, తాగడానికి కూర్చున్నారు. నాట్యం చేయడం మొదలు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","అప్పుడు యెహోవా మోషేతో ఇలా అన్నాడు. “కొండ దిగి వెళ్ళు. ఐగుప్తు దేశం నుండి నువ్వు తీసుకు వచ్చిన నీ ప్రజలు చెడిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","వాళ్ళు పాటించాలని నేను నియమించిన ఉపదేశాల నుండి అప్పుడే తప్పిపోయారు. వాళ్ళ కోసం పోత పోసిన దూడ విగ్రహం తయారు చేసుకుని దానికి సాగిలపడి బలులు అర్పించి ‘ఓ ఇశ్రాయేలూ, ఐగుప్తు దేశం నుండి నిన్ను రప్పించిన నీ దేవుడు ఇదే’ అని చెప్పుకుంటున్నారు.” ");
INSERT INTO tel2017_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","యెహోవా ఇంకా ఇలా అన్నాడు. “నేను ఈ ప్రజలను గమనిస్తున్నాను. వాళ్ళు కఠిన హృదయులయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","నువ్వు చూస్తూ ఉండు, నా కోపం వారి మీద రగులుకునేలా చేస్తాను. వాళ్ళను దహించివేసి నిన్ను గొప్ప జనంగా చేస్తాను.” ");
INSERT INTO tel2017_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","అందుకు మోషే తన దేవుడైన యెహోవాను బతిమిలాడాడు. “యెహోవా, నీ ప్రజల మీద నీ కోపం ఎందుకు రగులుకోవాలి? నీ బలిష్టమైన చెయ్యి చాపి ఐగుప్తు దేశం నుండి వీళ్ళను బయటకు రప్పించావు కదా. ");
INSERT INTO tel2017_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ఐగుప్తీయులు ‘వాళ్ళ దేవుడు వాళ్ళకు కీడు కలిగించి భూమిపై లేకుండా నశింపజేసి కొండల్లో చనిపోయేలా చేయడానికి వాళ్ళను తీసుకు వెళ్ళాడు’ అని ఎందుకు చెప్పుకోవాలి? నీ కోపాగ్ని నుండి మళ్లుకుని వాళ్లకు కీడు చెయ్యకు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","నీ సేవకులైన అబ్రాహాము, ఇస్సాకు, యాకోబులను జ్ఞాపకం చేసుకో. ఆకాశంలో ఉండే నక్షత్రాలవలే మీ సంతానాన్ని అభివృద్ధి పరచి నేను చెప్పిన ఈ భూమి అంతటినీ మీ సంతానానికి ఇస్తాననీ, వాళ్ళు శాశ్వతంగా దాన్ని స్వాధీనం చేసుకుంటారనీ, దానికి నువ్వే సాక్ష్యం అనీ వాళ్ళతో ఒప్పందం చేశావు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","అప్పుడు యెహోవా పరితపించి తన ప్రజలకు చేస్తానని చెప్పిన కీడు చెయ్యలేదు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","దేవుడు తన స్వహస్తాలతో రాసి ఇచ్చిన రెండు పలకలు మోషే చేతిలో ఉన్నాయి. ఆ పలకలపై రెండువైపులా దేవుడు నియమించిన ఆజ్ఞలు రాసి ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ఆ పలకలు దేవుడు తయారు చేశాడు. ఆ పలకలు పట్టుకుని మోషే కొండ దిగి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","శిబిరంలో ప్రజలు వేస్తున్న కేకల శబ్దం యెహోషువకు వినబడింది. “మన శిబిరంలో యుద్ధ ధ్వని వినబడుతోంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","మోషే “అది జయ ధ్వని కాదు, అపజయ ధ్వని కాదు, సంగీత వాయిద్యాల శబ్దం నాకు వినబడుతోంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","అతడు శిబిరం చేరుకున్నప్పుడు ప్రజలు చేసుకున్న ఆ దూడ, నాట్యం చేస్తున్న ప్రజలు కనిపించారు. మోషే కోపం రగులుకుంది. అతడు తన చేతుల్లో ఉన్న పలకలను కొండ కింది భాగానికి విసిరేసి వాటిని పగలగొట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ప్రజలు తయారు చేసుకున్న ఆ దూడను తీసుకుని అగ్నితో కాల్చి పొడి చేశాడు. ఆ పొడిని నీళ్లలో కలిపి ఇశ్రాయేలు ప్రజల చేత తాగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","అప్పుడు మోషే “ఈ ప్రజల మీదికి ఈ గొప్ప అపరాధం వచ్చేలా చేయడానికి వీళ్ళు నిన్ను ఎలా ప్రేరేపించారు?” అని అహరోనును అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","అహరోను “నా ప్రభూ, నీ కోపం రగులుకోనియ్యకు. ఈ ప్రజలు దుర్మార్గులు అనే విషయం నీకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","వాళ్ళు ‘మా ముందుండి మమ్మల్ని నడిపించడానికి ఒక దేవుణ్ణి సిద్ధం చెయ్యి. ఐగుప్తు దేశం నుండి మమ్మల్ని తీసుకు వచ్చిన మోషే ఏమయ్యాడో మాకు తెలియడం లేదు’ అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","అప్పుడు నేను ఎవరి దగ్గర బంగారం ఉన్నదో వాళ్ళంతా దాన్ని ఊడదీసి తీసుకు రండి అని చెప్పాను. వాళ్ళు తెచ్చిన దాన్ని అగ్నిలో వేస్తే ఈ దూడ అయ్యింది” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ప్రజలు తమ శత్రువుల ఎదుట నవ్వులపాలు కావడానికి అహరోను కారకుడయ్యాడు. ప్రజలు విచ్చలవిడితనంగా తిరగడం మోషే గమనించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","అప్పుడు మోషే శిబిరం ద్వారం దగ్గర నిలబడి “యెహోవా పక్షంగా ఉన్నవాళ్ళంతా నా దగ్గరికి రండి” అన్నాడు. లేవీయులంతా అతని దగ్గరికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","అతడు వాళ్ళను చూసి “మీలో ప్రతి ఒక్కరూ మీ కత్తులు నడుముకు కట్టుకోండి, శిబిరంలో గుమ్మం నుండి గుమ్మానికి వెళ్తూ ప్రతి ఒక్కరూ తమ సోదరుణ్ణి, తమ స్నేహితుణ్ణి, తమ పొరుగువాణ్ణి సంహరించండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","లేవీయులు మోషే మాట ప్రకారం చేసారు. ఆ రోజున ప్రజల్లో సుమారు మూడు వేల మంది హతమయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","మోషే లేవీయులతో “మిమ్మల్ని మీరు యెహోవాకు ప్రతిష్ట చేసుకోండి. మీలో ప్రతి ఒక్కరూ మీ కొడుకులనూ, సోదరులనూ చంపి యెహోవా ఆశీర్వాదాలు పొందారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","మరుసటి రోజు మోషే ప్రజలతో “మీరు గొప్ప పాపం చేశారు. నేను యెహోవా దగ్గరికి కొండ ఎక్కి వెళ్తాను. ఒకవేళ మీరు చేసిన పాపం కోసం ఏదైనా ప్రాయశ్చిత్తం చేయగలనేమో” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","మోషే యెహోవా కొండకు మళ్ళీ వెళ్ళాడు. “అయ్యో, ఈ ప్రజలు ఎంతో పాపం చేశారు. వాళ్ళు తమ కోసం బంగారు దేవుణ్ణి చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","అయ్యో, వాళ్ళు చేసిన పాపాన్ని పరిహరించు, లేని పక్షంలో నువ్వు రాసిన నీ గ్రంథంలో నుండి నా పేరు తొలగించు” అని బతిమాలుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","అందుకు యెహోవా “నాకు విరోధంగా ఎవరు పాపం చేస్తారో వాళ్ళ పేర్లు మాత్రమే నా గ్రంథంలో నుండి తొలగిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","నువ్వు వెళ్లి నేను నీతో చెప్పిన చోటికి ప్రజలను నడిపించు. నా దూతను నీకు ముందుగా పంపుతున్నాను. నేను శిక్షించే రోజున వాళ్ళ పాపం విషయంలో వాళ్ళకు శిక్ష రప్పిస్తాను” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ప్రజలు అహరోను చేత చేయించిన దూడను బట్టి యెహోవా వాళ్ళను బాధలకు గురి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. “నీవూ ఐగుప్తు దేశం నుండి బయటకు తీసుకు వచ్చిన ప్రజలూ బయలుదేరి, నేను అబ్రాహాము, ఇస్సాకు, యాకోబుల సంతానానికి ఇస్తానని చెప్పిన పాలు తేనెలు ప్రవహించే దేశానికి వెళ్ళండి. ");
INSERT INTO tel2017_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","నేను నీకు ముందుగా దూతను పంపుతాను. ఆ దూత కనానీయులను, అమోరీయులను, హిత్తీయులను, పెరిజ్జీయులను, హివ్వీయులను, యెబూసీయులను అక్కడినుండి వెళ్ళగొడతాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","మీరు నాకు అవిధేయులయ్యారు కనుక నేను మీతో కలసి రాను. ఒకవేళ మార్గమధ్యంలో మిమ్మల్ని చంపేస్తానేమో.” ");
INSERT INTO tel2017_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ఆ దుర్వార్త విని ప్రజలు దుఃఖించారు. ధరించిన ఆభరణాలన్నీ పక్కనబెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","అప్పుడు యెహోవా మోషేతో “నీవు ఇశ్రాయేలు ప్రజలతో ‘మీరు అవిధేయులైన ప్రజలు. ఒక్క క్షణం నేను మీ మధ్యకు వచ్చినా మిమ్మల్ని హతం చేస్తాను. మీరు ధరించుకొన్న ఆభరణాలన్నీ తీసివెయ్యండి. అప్పుడు మిమ్మల్ని ఏం చెయ్యాలో చూస్తాను’ అని చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ఇశ్రాయేలు ప్రజలు హోరేబు కొండ దగ్గర తమ నగలు తీసివేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","అప్పుడు మోషే శిబిరం బయటకు వెళ్లి అక్కడ ఒక గుడారం వేశాడు. దానికి సన్నిధి గుడారం అని పేరు పెట్టాడు. యెహోవాను కనుగొనాలనుకున్న ప్రతివాడూ శిబిరం బయట ఉన్న సన్నిధి గుడారానికి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","మోషే ఆ గుడారానికి వెళ్తూ ఉన్నప్పుడల్లా తమ గుడారాల్లో ఉన్న ప్రజలు లేచి నిలబడి అతడు గుడారం లోకి వెళ్ళేదాకా అతని వైపు నిదానంగా చూస్తూ ఉండేవాళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","మోషే ఆ గుడారంలోకి వెళ్ళినప్పుడు స్తంభం లాంటి మేఘం దిగి వచ్చి ఆ గుడారం ద్వారం దగ్గర నిలిచేది. అప్పుడు యెహోవా మోషేతో మాట్లాడుతూ ఉండేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ఆ మేఘస్తంభం ఆ గుడారం ద్వారాన నిలవడం చూసిన ప్రజలందరూ తమ తమ గుడారాల ద్వారాల్లో లేచి నిలబడి నమస్కారం చేసేవారు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ఒక వ్యక్తి తన స్నేహితునితో మాట్లాడుతున్నట్టు యెహోవా మోషేతో ముఖాముఖీగా మాట్లాడేవాడు. తరువాత అతడు శిబిరంలోకి తిరిగి వచ్చేవాడు. అయితే మోషే సేవకుడు, నూను కొడుకు అయిన యెహోషువ అనే యువకుడు గుడారం నుండి బయటకు వచ్చేవాడు కాదు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","మోషే యెహోవాతో ఇలా చెప్పాడు. “ఈ ప్రజలను వెంటబెట్టుకుని వెళ్ళమని నాకు చెబుతున్నావు గానీ నాతో ఎవరిని పంపుతున్నావో అది నాకు చెప్పలేదు. అదీగాక ‘నిన్ను నీ పేరుతో ఎరుగుదును. నిన్ను నేను కరుణించాను’ అని నాతో చెప్పావు కదా. ");
INSERT INTO tel2017_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","అందువల్ల నాపై నీ దయ ఉంటే నీ విధానాలు నేను గ్రహించగలిగేలా దయచేసి నీ మార్గాలు నాకు చూపించు. అప్పుడు నేను నీ గురించి తెలుసుకుంటాను. అయ్యా, చూడు, ఈ జనమంతా నీ ప్రజలే గదా.” ");
INSERT INTO tel2017_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","అందుకు ఆయన “నా సన్నిధి నీకు తోడుగా వస్తుంది. నేను నీకు నెమ్మది కలుగజేస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","మోషే “నీ సన్నిధి మాతో రాని పక్షంలో ఇక్కడ నుండి మమ్మల్ని తీసుకు వెళ్ళకు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","నా పట్ల, నీ ప్రజల పట్ల నువ్వు దయ చూపిస్తున్నావని మాకు దేని వల్ల తెలుస్తుంది? నువ్వు మాతో కలసి రావడం వల్లనే కదా. ఆ విధంగా మేము, అంటే నేను, నీ ప్రజలు భూమి మీద ఉన్న ప్రజల్లో నుండి ప్రత్యేకంగా గుర్తింపు పొందుతాం” అని ఆయనతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","అప్పుడు యెహోవా “నీవు చెప్పినట్టు చేస్తాను. నీ మీద నాకు దయ కలిగింది. నీ పేరును బట్టి నిన్ను తెలుసుకున్నాను” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","మోషే “దయచేసి నీ మహిమను నాకు చూపించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ఆయన “నా మంచితనమంతా నీ ఎదుట నుండి దాటిపోయేలా చేస్తాను. యెహోవా అనే నా పేరును నీ ఎదుట ప్రకటిస్తాను. నాకు ఎవరిమీద కరుణ చూపాలని ఉందో వాళ్ళను కరుణిస్తాను, ఎవరి మీద జాలిపడాలో వారిపట్ల జాలి చూపిస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ఆయన ఇంకా “నువ్వు నా ముఖాన్ని చూడలేవు. నన్ను చూసిన ఏ మనిషీ బతకడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","యెహోవా “ఇదిగో నాకు దగ్గరలో ఒక చోటు ఉంది. నువ్వు ఆ బండ మీద నిలబడు. ");
INSERT INTO tel2017_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","నా మహిమ నిన్ను దాటి వెళ్ళే సమయంలో ఆ బండ సందులో నిన్ను దాచి ఉంచి, నిన్ను దాటి వెళ్ళే వరకూ నా చేత్తో నిన్ను కప్పుతాను. ");
INSERT INTO tel2017_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","నేను నా చెయ్యి తీసివేసిన తరువాత నా వీపును మాత్రం నువ్వు చూడగలవు గానీ నా ముఖ దర్శనం నీకు కలగదు” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","యెహోవా మోషేతో “మొదటి పలకల్లాంటి రాతి పలకలు మరో రెండు చెక్కు. నువ్వు పగలగొట్టిన మొదటి పలకల మీద ఉన్న మాటలు నేను ఆ పలకల మీద రాస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","తెల్లవారేటప్పటికి నువ్వు సిద్ధపడి సీనాయి కొండ ఎక్కి దాని శిఖరం మీద నా సన్నిధిలో నిలిచి ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ఏ మనిషీ నీతోబాటు ఈ కొండ దగ్గరికి రాకూడదు, ఏ మనిషీ ఈ కొండ మీద ఎక్కడా కనబడకూడదు. ఈ కొండ పరిసరాల్లో గొర్రెలు గానీ, ఎద్దులుగానీ మేత మేయకూడదు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","కాబట్టి మోషే మొదటి పలకల్లాంటి రెండు రాతి పలకలు చెక్కాడు. తనకు యెహోవా ఆజ్ఞాపించినట్టు ఉదయాన్నే తొందరగా లేచి ఆ రెండు రాతి పలకలను చేత పట్టుకుని సీనాయి కొండ ఎక్కాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","యెహోవా మేఘం నుండి దిగి అక్కడ మోషే దగ్గర నిలిచి యెహోవా తనను వెల్లడి చేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","యెహోవా అతని ఎదురుగా అతణ్ణి దాటి వెళ్తూ “యెహోవా కనికరం, దయ, దీర్ఘశాంతం, అమితమైన కృప, సత్యం గల దేవుడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ఆయన వేలాది మందికి తన కృప చూపిస్తాడు. అతిక్రమాలు, అపరాధాలు, పాపాలు క్షమిస్తాడు. అయితే దోషులను ఏమాత్రం శిక్షించకుండా ఉండడు. తండ్రుల దోష ఫలితం మూడు నాలుగు తరాలదాకా వారి సంతానం మీదికి రప్పించేవాడు” అని ప్రకటించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","మోషే వెంటనే నేలకు తల వంచి సాష్టాంగపడి నమస్కరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“ప్రభూ, నా మీద నీకు దయ ఉంటే నా మనవి ఆలకించు. దయచేసి నా ప్రభువు మా మధ్య మాతో ఉండి మాతో కలసి ప్రయాణించాలి. ఈ ప్రజలు మాటకు లోబడేవాళ్ళు కారు. మా అపరాధాలను, పాపాలను క్షమించు. మమ్మల్ని నీ సొత్తుగా స్వీకరించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","అందుకు ఆయన “ఇదిగో, నేను ఒక ఒడంబడిక చేస్తున్నాను. ఇంతవరకూ భూమిపై ఎక్కడైనా, ఏ ప్రజల్లోనైనా ఇంత వరకూ చేయని అద్భుత కార్యాలు నీ ప్రజలందరి ఎదుట చేస్తాను. నువ్వు నాయకత్వం వహించి నడిపిస్తున్న ఆ ప్రజలంతా యెహోవా చేసే పనులు చూస్తారు. నేను నీ పట్ల చేయబోయే కార్యాలు భయం కలిగిస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ఇప్పుడు నేను నీకు ఆజ్ఞాపించినవన్నీ పాటించు. నేను మీ ఎదుట నుండి అమోరీయులను, కనానీయులను, హిత్తీయులను, పెరిజ్జీయులను, హివ్వీయులను, యెబూసీయులను వెళ్ళగొడతాను. ");
INSERT INTO tel2017_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","మీరు వెళ్లబోయే ఆ పరదేశపు నివాసులతో ఎలాంటి ఒప్పందాలు చేసుకోకుండా జాగ్రత్త వహించాలి. అలా గనక చేసుకుంటే అవి మీకు ఉరిగా మారవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","అందువల్ల మీరు వాళ్ళ బలిపీఠాలను విరగగొట్టాలి, వాళ్ళ దేవుళ్ళ ప్రతిమలను పగలగొట్టాలి, వాళ్ళ దేవతా స్తంభాలను పడదోయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","మీరు వేరొక దేవునికి మొక్కకూడదు. నేను ‘రోషం గల దేవుడు’ అనే పేరున్న యెహోవాను. నేను రోషం గల దేవుణ్ణి. ");
INSERT INTO tel2017_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ఆ దేశాల్లో నివసించే ప్రజలతో ఎలాంటి ఒప్పందాలు చేసుకోకుండా ఉండేలా జాగ్రత్త వహించాలి. ఆ ప్రజలు ఇతరుల దేవుళ్ళ విషయం వ్యభిచారుల్లా ప్రవర్తిస్తారు. వాళ్ళ దేవుళ్ళకు అర్పించిన నైవేద్యాలు తినమని ఎవరైనా నిన్ను ప్రేరేపించినప్పుడు వాటి విషయం జాగ్రత్త వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","మీ కొడుకులకు వాళ్ళ కూతుళ్ళను పెళ్లి చేసుకోకూడదు. అలా గనక చేస్తే వాళ్ళ కూతుళ్ళు తమ తమ దేవుళ్ళను పూజిస్తూ మీ కొడుకులు కూడా వాళ్ళ దేవుళ్ళను పూజించేలా ప్రలోభ పెడతారేమో. ");
INSERT INTO tel2017_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","పోత పోసిన దేవుళ్ళ విగ్రహాలను తయారు చేసుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","పొంగజేసే పిండి లేని రొట్టెల పండగ ఆచరించాలి. నేను మీకు ఆజ్ఞాపించిన ప్రకారం ఐగుప్తునుండి మీరు బయలుదేరి వచ్చిన ఆబీబు నెలలో నియమించిన సమయంలో ఏడు రోజులపాటు పొంగజేసే పిండి లేని రొట్టెలు తినాలి. మీరు అబీబు నెలలో ఐగుప్టులో నుండి బయలుదేరి వచ్చారు గదా. ");
INSERT INTO tel2017_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","జంతువుల్లో మొదట పుట్టిన ప్రతి పిల్ల నాది. నీ పశువుల్లో మొదటిగా పుట్టిన ప్రతి మగది, అది దూడ గానీ, గొర్రెపిల్ల గానీ అది నాకు చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","గాడిదను విడిపించాలంటే దానికి బదులు గొర్రెపిల్లను అర్పించాలి. గాడిదను విమోచించకపోతే దాని మెడ విరగగొట్టాలి. మీ సంతానంలో పెద్ద కొడుకుని వెల చెల్లించి విడిపించాలి. నా సన్నిధానంలో ఒక్కడు కూడా ఖాళీ చేతులతో కనిపించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ఆరు రోజులు మీ పనులు చేసుకున్న తరువాత ఏడవ రోజున విశ్రాంతి తీసుకోవాలి. అది పొలం దున్నే కాలమైనా, కోత కోసే కాలమైనా. ");
INSERT INTO tel2017_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","మీ పొలాల్లో పండిన గోదుమల తొలి పంటల కోత సమయంలో వారాల పండగ ఆచరించాలి. సంవత్సరం ముగింపులో పొలాలనుండి నీ వ్యవసాయ ఫలాన్ని కూర్చుకుని జనమంతా సమకూడి పండగ ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","సంవత్సరంలో మూడుసార్లు పురుషులంతా ఇశ్రాయేలియుల దేవుడు, ప్రభువు అయిన యెహోవా సముఖంలో కనబడాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","మీరు సంవత్సరంలో మూడు సార్లు మీ దేవుడైన యెహోవా సన్నిధానంలో సమకూడడానికి వెళ్ళినప్పుడు ఎవ్వరూ నీ భూమిని స్వాధీనం చేసుకోరు. ఎందుకంటే నీ ఎదుట నుండి నీ శత్రువులను వెళ్లగొట్టి నీ సరిహద్దులు విస్తరించేలా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","నాకు అర్పించే బలుల రక్తంలో పొంగజేసే పదార్థమేమీ ఉండకూడదు. పస్కా పండగలో అర్పించిన ఎలాటి మాంసమైనా ఉదయం దాకా నిలవ ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","నీ భూమిలో పండే వాటిలో ప్రథమ ఫలాల్లో శ్రేష్ఠమైన వాటిని దేవుడైన యెహోవా మందిరానికి తీసుకురావాలి. మేకపిల్ల మాంసం దాని తల్లిపాలలో కలిపి ఉడకబెట్టకూడదు.” ");
INSERT INTO tel2017_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","యెహోవా మోషేతో ఇంకా చెప్పాడు “ఇప్పుడు పలికిన మాటలు రాసి ఉంచు. ఎందుకంటే ఈ మాటలను బట్టి నేను నీతో, ఇశ్రాయేలు ప్రజలతో ఒప్పందం చేసుకుంటున్నాను.” ");
INSERT INTO tel2017_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","మోషే నలభై రాత్రింబగళ్ళు యెహోవా దగ్గరే ఉండిపోయాడు. అతడు భోజనం చెయ్యలేదు, నీళ్ళు తాగలేదు. ఆ సమయంలో దేవుడు చెప్పిన శాసనాలను, అంటే పది ఆజ్ఞలను ఆ పలకల మీద రాశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","మోషే సీనాయి కొండ దిగే సమయానికి ఆజ్ఞలు రాసి ఉన్న ఆ రెండు పలకలు మోషే చేతిలో ఉన్నాయి. అతడు ఆయనతో మాట్లాడుతున్న సమయంలో అతని ముఖం వెలుగుతో ప్రకాశించిన సంగతి మోషేకు తెలియలేదు. అతడు కొండ దిగి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","అహరోను, ఇశ్రాయేలు ప్రజలు మోషేకు ఎదురు వచ్చారు. ప్రకాశిస్తున్న అతని ముఖం చూసి అతణ్ణి సమీపించడానికి భయపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","మోషే వాళ్ళను పిలిచాడు. అహరోను, సమాజంలోని పెద్దలంతా అతని దగ్గరికి వచ్చినప్పుడు మోషే వాళ్ళతో మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","అ తరువాత ఇశ్రాయేలు ప్రజలందరూ అతన్ని సమీపించినప్పుడు సీనాయి కొండ మీద యెహోవా తనతో చెప్పిన విషయాలన్నీ వాళ్లకు ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","మోషే వాళ్ళతో ఆ విషయాలు చెప్పడం ముగించిన తరువాత తన ముఖం మీద ముసుగు వేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","కానీ మోషే యెహోవాతో మాట్లాడడానికి ఆయన సన్నిధానం లోకి వెళ్ళినప్పుడల్లా ముసుగు తీసివేసి బయటకు వచ్చేదాకా ముసుగు లేకుండా ఉన్నాడు. అతడు బయటికి వచ్చినప్పుడల్లా యెహోవా తనకు ఆజ్ఞాపించిన విషయాలన్నీ ప్రజలకు చెప్పేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ఇశ్రాయేలు ప్రజలు మోషే ముఖం చూసినప్పుడు అది కాంతిమయమై ప్రకాశిస్తూ ఉంది, మోషే ఆయనతో మాట్లాడడానికి లోపలికి వెళ్ళేవరకూ తన ముఖాన్ని ముసుగుతో కప్పుకునేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","మోషే ఇశ్రాయేలు ప్రజల సమాజమంతటినీ సమకూర్చి ఇలా చెప్పాడు. “యెహోవా ఆజ్ఞాపించినట్టు మీరు జరిగించవలసిన నియమాలు ఇవి. ");
INSERT INTO tel2017_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","మొదటి ఆరు రోజులు మీరు పని చెయ్యాలి. ఏడవ రోజు మీకు పరిశుద్ధమైనది. అది యెహోవా నియమించిన విశ్రాంతి దినం. ఆ రోజు పని చేసే ప్రతివాడూ మరణ శిక్షకు పాత్రుడు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","విశ్రాంతి దినాన మీరు మీ ఇళ్ళలో ఎలాంటి వంటకాలు వండుకోకూడదు.” ");
INSERT INTO tel2017_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","మోషే ఇశ్రాయేలు ప్రజల సమాజమంతటితో ఇంకా ఇలా చెప్పాడు. “యెహోవా ఆజ్ఞాపించినది ఏమిటంటే, ");
INSERT INTO tel2017_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","మీలో మీరు యెహోవా కోసం అర్పణలు, కానుకలు పోగుచేయండి. ఎలాగంటే, యెహోవా సేవ కోసం కానుకలు ఇవ్వాలనే మనసు కలిగిన ప్రతివాడూ బంగారం, వెండి, ఇత్తడి లోహాలు, ");
INSERT INTO tel2017_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","నీలం, ఊదా, ఎర్రరంగు నూలు, సన్నని నార, మేక వెంట్రుకలు, ఎర్ర రంగు వేసిన పొట్టేళ్ల తోళ్లు, డాల్ఫిన్ తోళ్లు, తుమ్మకర్ర, ");
INSERT INTO tel2017_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","దీపాలు వెలిగించడానికి నూనె, ");
INSERT INTO tel2017_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","అభిషేక తైలం, పరిమళ ద్రవ్య ధూపం వేయడానికి సుగంధ ద్రవ్యాలు, ");
INSERT INTO tel2017_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ఏఫోదు కోసం, వక్షపతకం కోసం లేత పచ్చలు, చెక్కిన రత్నాలు తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","ఇంకా, నైపుణ్యం, జ్ఞానం ఉన్నవాళ్ళు వచ్చి యెహోవా ఆజ్ఞాపించినట్టు ఈ పనులు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ఆ పనులేవంటే, ఆయన నివాసం, నివాస మందిరం ఉండే గుడారం, దాని పైకప్పు, కొలుకులు, పలకలు, అడ్డ కర్రలు, స్తంభాలు, దిమ్మలు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","మందసం పెట్టె, దాన్ని మోసే కర్రలు, కరుణా పీఠం మూత, దాన్ని మూసి ఉంచే తెర, ");
INSERT INTO tel2017_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","సన్నిధి బల్ల, దాన్ని మోసే కర్రలు, దానిలోని సామగ్రి, సన్నిధి రొట్టెలు, ");
INSERT INTO tel2017_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","వెలుగు కోసం దీప స్థంభం, దాని సామగ్రి, దానిలో ఉండాల్సిన దీపాలు, దీపాలకు నూనె. ");
INSERT INTO tel2017_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ధూపవేదిక, దాన్ని మోసే కర్రలు, అభిషేక తైలం, పరిమళ ద్రవ్య ధూపం వేయడానికి సుగంధ ద్రవ్యాలు, మందిరం ద్వారానికి తెర. ");
INSERT INTO tel2017_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","బలులు అర్పించే దహన బలిపీఠం, దానికి ఉండే ఇత్తడి జల్లెడ, దాన్ని మోసే కర్రలు, దాని సామగ్రి, గంగాళం, దాని పీట. ");
INSERT INTO tel2017_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ఆవరణపు తెరలు, దాని స్తంభాలు, వాటి దిమ్మలు, ప్రవేశ ద్వారానికి తెర. ");
INSERT INTO tel2017_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","నివాస మందిరం కోసం, ఆవరణ కోసం మేకులు, వాటికి తాళ్లు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","పవిత్ర స్థలం లో సేవ చేయడానికి నేసిన వస్త్రాలు, అంటే, యాజకుడుగా సేవ చెయ్యడానికి అహరోనుకు, అతని కొడుకులకూ పవిత్ర వస్త్రాలు అనేవి.” ");
INSERT INTO tel2017_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ఇశ్రాయేలు ప్రజల సమూహమంతా మోషే ఎదుట నుండి వెళ్ళిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","తరువాత ఎవరి హృదయం వాళ్ళను ప్రేరేపించినట్టు వాళ్ళంతా సన్నిధి గుడారం కోసం, దానిలోని సేవ అంతటికోసం, పవిత్ర వస్త్రాల కోసం అర్పణలు తెచ్చి యెహోవాకు సమర్పించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","తమ హృదయాల్లో ప్రేరణ పొందిన స్త్రీలు, పురుషులు యెహోవాకు బంగారం సమర్పించిన ప్రతి ఒక్కరూ పైట పిన్నులు, పోగులు, ఉంగరాలు, కంకణాలు, వివిధ రకాల బంగారం వస్తువులు తీసుకువచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ఇంకా, నీలం, ఊదా, ఎర్ర రంగు దారాలు, సన్నని నార, మేక వెంట్రుకలు, ఎర్ర రంగు వేసిన పొట్టేళ్ల తోళ్లు, డాల్ఫిన్ తోళ్లు వీటిలో ఏవేవి ఎవరి దగ్గర ఉంటే వాళ్ళు తీసుకువచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","వెండి, ఇత్తడి సమర్పించిన ప్రతి ఒక్కరూ యెహోవాకు కానుకలు తెచ్చారు. సేవలో ఏ పని కోసమైనా ఉపయోగపడే తుమ్మకర్ర ఎవరి దగ్గర ఉన్నదో వాళ్ళు దాన్ని తెచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","నైపుణ్యం గల స్త్రీలు తమ చేతులతో వడికిన నీలం, ఊదా, ఎర్ర రంగు దారాలు, సన్నని నార, నూలు తీసుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","నేర్పు గల స్త్రీలు తమ జ్ఞానహృదయంతో ప్రేరణ పొంది మేక వెంట్రుకలు వడికారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","నాయకులు ఏఫోదు కోసం, వక్షపతకం కోసం లేత పచ్చలు, వెలగల రాళ్ళూ రత్నాలు, ");
INSERT INTO tel2017_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","అభిషేక తైలం, పరిమళ ద్రవ్య ధూపం వేయడానికి సుగంధ ద్రవ్యాలు తీసుకువచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","మోషేను చెయ్యమని యెహోవా ఆజ్ఞాపించిన పనులన్నిటి కోసం ఇశ్రాయేలు ప్రజల్లో తమ మనస్సులలో నిర్ణయించుకున్న పురుషులు, స్త్రీలు తమ ప్రేరణను బట్టి వాళ్ళంతా తమ ఇష్టపూర్వకంగా యెహోవాకు కానుకలు అర్పించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","మోషే ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పాడు, ");
INSERT INTO tel2017_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","“వినండి, ఊరు కొడుకు, హూరు మనుమడు బెసలేలును యెహోవా ప్రత్యేకంగా పిలుచుకున్నాడు. అతడు బంగారంతో, వెండితో, ఇత్తడితో వివిధ రకాల ఆకృతులు నైపుణ్యంగా తయారు చేయగల నేర్పరి. ");
INSERT INTO tel2017_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","రత్నాలు సానబెట్టి పొదగడంలో, చెక్కలను కోసి నునుపు చేయడంలో నిపుణుడు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","అతనికి ఆయన అన్ని రకాల పనులు చెయ్యడానికి తెలివితేటలు, జ్ఞానం, నైపుణ్యం ప్రసాదించాడు. అతణ్ణి దేవుడు తన ఆత్మతో నింపాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","అతడు, దాను గోత్రానికి చెందిన అహీసామాకు కొడుకు అహోలీయాబు ఇతరులకు ఈ పనులు నేర్పించడానికి సామర్ధ్యం కలిగినవాళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","వాళ్ళు ఆ విధమైన ఎలాంటి పని అయినా చేయడానికి దేవుడు వాళ్ళకు సామర్ధ్యం ఇచ్చాడు. చెక్కేవాళ్ళ పనిగానీ, చిత్రకారుల పనిగానీ నీలం ఊదా ఎర్ర రంగు సన్నని నార దారాలతో బుటాపని గానీ, నేతపని గానీ వాళ్లకు బాగా తెలుసు. వాళ్ళు అలాంటి పనులు చెయ్యగలరు, చేయించగలరు.” ");
INSERT INTO tel2017_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","మోషే “పవిత్ర స్థలం లో జరిగే సేవ కోసం అన్నిరకాల పనులు చేయడానికి బెసలేలు, అహోలీయాబు మొదలైన ప్రతిభావంతులను నియమించాము. ఈ పనులు చేయడానికి యెహోవా వాళ్లకు జ్ఞానం, వివేకం ప్రసాదించాడు. వీళ్ళు యెహోవా ఆజ్ఞాపించినట్టు పనులు జరిగిస్తారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","బెసలేలు, అహోలీయాబులతో పాటు యెహోవా ఎవరి హృదయాల్లో జ్ఞాన వివేకాలు ఉంచి ఆ పని చేయడానికి ప్రేరేపణ కలిగించాడో వాళ్ళందరినీ మోషే పిలిపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","వాళ్ళు వచ్చి పవిత్ర స్థలం లో సేవ జరగడానికి, పవిత్ర స్థలం కట్టించడానికి ఇశ్రాయేలు ప్రజలు తీసుకువచ్చిన సామగ్రి అంతటినీ మోషే దగ్గర నుండి తీసుకున్నారు. అయితే ఇశ్రాయేలు ప్రజలు ఇంకా ప్రతిరోజూ మనస్ఫూర్తిగా మోషే దగ్గరికి కానుకలు తెస్తూనే ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","అప్పుడు పవిత్ర స్థలానికి చెందిన వేరు వేరు పనులు చేసే నిపుణులందరూ తాము చేస్తున్న పని వదిలిపెట్టి మోషే దగ్గరికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“సేవ జరిగించడానికి యెహోవా చేయమని చెప్పిన పని కోసం ప్రజలు కావలసిన దానికంటే చాలా ఎక్కువగా తీసుకు వస్తున్నారు” అని మోషేతో చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","మోషే “ఇక నుండి ఏ పురుషుడు గానీ, స్త్రీ గానీ పవిత్ర స్థలం పని కోసం ఎలాంటి కానుకలూ తేవద్దు” అని ప్రకటించాడు. శిబిరం అంతటా ఈ విషయం చాటింపు వేయించారు. ఆ పని మొత్తం జరిగించడానికి సరిపోయినంత సామగ్రి జమ అయింది. అంతకంటే ఎక్కువగానే సమకూడింది. ");
INSERT INTO tel2017_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ఇక ప్రజలు కానుకలు తేవడం మానుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ఆ పని చేసినవాళ్ళలో నిపుణులైన వారంతా నీలం, ఊదా, ఎర్రని రంగులతో నేసిన సన్నని దారాలతో దైవ సన్నిధి గుడారం కోసం కెరూబు నమూనాతో పది తెరలు చేశారు. ఇది అత్యంత నైపుణ్యం గల బెసలేలు చేతి పని. ");
INSERT INTO tel2017_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ఒక్కొక్క తెర పొడవు 28 మూరలు, వెడల్పు నాలుగు మూరలు. ఆ తెరలన్నిటి కొలతలు ఒక్కటే. ");
INSERT INTO tel2017_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ఐదు తెరలు చొప్పున రెండు జతలుగా ఒక దానితో ఒకటి కూర్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ఒక తెరల కూర్పు చివరి తెర అంచున నీలం రంగు నూలుతో ఉంగరాలు చేశారు. రెండవ కూర్పు బయటి తెర అంచుకు కూడా అదే విధంగా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","మొదటి కూర్పులో ఒక తెరకు ఏభై ఉంగరాలు, రెండవ కూర్పులో ఉన్న తెర అంచుకు ఏభై ఉంగరాలు చేశారు. అవి ఒకదానికొకటి ఎదురెదురుగా ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ఏభై బంగారు గుండీలను సిద్ధం చేసి ఆ గుండీలతో ఆ రెండు తెరలను ఒక దానితో ఒకటి కలిపినప్పుడు అది దైవ సన్నిధి మందిరంగా నిలిచింది. ");
INSERT INTO tel2017_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","దైవ సన్నిధి మందిరం పైకప్పుగా మేక వెంట్రుకలతో పదకొండు తెరలు సిద్ధం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ఒక్కో తెర పొడవు ముప్ఫై మూరలు, వెడల్పు నాలుగు మూరలు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ఆ పదకొండు తెరల కొలతలు ఒక్కటే. ఐదు తెరలను ఒక కూర్పుగా, ఆరు తెరలను ఒక కూర్పుగా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","మొదటి కూర్పులో బయటి తెర అంచుకు ఏభై ఉంగరాలు, రెండవ కూర్పులో బయటి తెర అంచుకు ఏభై ఉంగరాలు ఏర్పాటు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","వాటిని ఒక గుడారంగా కలపడానికి ఏభై యిత్తడి గుండీలు ఉపయోగించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ఎర్ర రంగు వేసిన పొట్టేళ్ల తోళ్లతో గుడారం కప్పునూ, గండుచేప తోళ్ళతో దానికి పైకప్పునూ సిద్ధం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","దైవ నివాసమైన మందిరం కోసం తుమ్మ కర్రతో నిలువు పలకలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ఒక్కో పలక పొడవు పది మూరలు, వెడల్పు మూరన్నర. ");
INSERT INTO tel2017_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ప్రతి పలకకు ఒకదాని కొకటి సమానమైన నిడివిలో రెండు కుసులు చేశారు. అదే విధంగా పలకలన్నిటికి అమర్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","మందిరానికి దక్షిణం దిక్కున, అంటే కుడివైపున ఇరవై పలకలు ఉండేలా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ఒక్కొక్క పలక చొప్పున ఇరవై పలకల కింద రెండు కుసులకు రెండు దిమ్మలు, మొత్తం నలభై వెండి దిమ్మలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","మందిరం రెండవ వైపు, అంటే ఉత్తరం వైపు ఇరవై పలకలను వాటి నలభై వెండి దిమ్మలను, ");
INSERT INTO tel2017_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ఒక్కో పలక కింద రెండు దిమ్మలను చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","పడమటి దిక్కున మందిరం వెనక ఆరు పలకలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","వెనుక వైపు మందిరం మూలలకు రెండు పలకలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ఆ పలకలు కింది భాగంలో నిలిపి మొదటి ఉంగరం దాకా ఒకదానితో ఒకటి అంచు దాకా కలిపారు. అలా రెండు మూలల్లో ఆ రెండు పలకలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ఎనిమిది పలకలు ఉన్నాయి. వాటికి అమర్చిన వెండి దిమ్మలు పదహారు. ప్రతి పలక అడుగునా రెండు దిమ్మలు ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","తుమ్మకర్రతో వాటికి అడ్డకర్రలు చేశారు. మందిరం ఒకవైపు పలకలకు ఐదు అడ్డకర్రలు, ");
INSERT INTO tel2017_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","రెండో వైపు పలకలకు ఐదు అడ్డకర్రలు, పడమటి వైపు మందిరం వెనుక వైపు పలకలకు ఐదు అడ్డకర్రలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","పలకల మధ్యలో ఉన్న ముఖ్యమైన అడ్డకర్ర ఈ అంచు నుండి ఆ అంచు వరకూ కలిసి ఉండేలా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ఆ పలకలకు బంగారు రేకులు పొదిగించారు. వాటి అడ్డకర్రలు ఉండే గుండ్రని కమ్మీలు బంగారంతో చేసి అడ్డకర్రలకు బంగారు రేకులు పొదిగించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","నీలం ఊదా ఎర్రని రంగులు గల సన్నని నారతో పేని అడ్డతెరను సిద్ధం చేశారు. కెరూబు రూపాలను నైపుణ్యం గల పనితనంతో చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","దాని కోసం తుమ్మకర్రతో నాలుగు స్తంభాలు సిద్ధం చేసి వాటికి బంగారు రేకులు పొదిగించారు. వాటి బంగారపు కొక్కేల కోసం నాలుగు వెండి దిమ్మలు పోతపోశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","గుడారం ద్వారం కోసం నీలం, ఊదా, ఎర్ర రంగుల దారాలతో పేనిన సన్నని నారతో, అడ్డ తెరను నేయించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","దాని ఐదు స్తంభాలూ, వాటి కొక్కేలూ తయారు చేశారు. ఆ స్థంభాలకూ, వాటి కొక్కేలకూ, వాటి పెండె బద్దలకూ బంగారం రేకులు పొదిగించారు. వాటికి ఉన్న ఐదు దిమ్మలు ఇత్తడివి. ");
INSERT INTO tel2017_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","బెసలేలు తుమ్మకర్రతో మందసాన్ని తయారుచేశాడు. దాని పొడవు రెండు మూరలు, దాని వెడల్పు, ఎత్తు మూరన్నర, ");
INSERT INTO tel2017_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","దాని లోపల, బయటా స్వచ్ఛమైన బంగారం రేకు పొదిగించాడు. దాని చుట్టూ బంగారంతో అలంకరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","దానికి బంగారంతో నాలుగు గుండ్రని కొంకీలు చేసి, ఒక పక్క రెండు కమ్మీలు, ముందు భాగంలో రెండు గుండ్రని కమ్మీలు ఉండేలా దాని నాలుగు కాళ్లకు వాటిని తగిలించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","అతడు తుమ్మకర్రతో మందసాన్ని మోసే కర్రలు సిద్ధం చేసి వాటికి బంగారం రేకులు పొదిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","మందసాన్ని మోయడానికి వీలుగా దాని చుట్టూ ఉన్న గుండ్రని కమ్మీలలో ఆ మోసే కర్రలు ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","అతడు స్వచ్ఛమైన బంగారంతో కరుణా స్థానం మూత చేశాడు. దాని పొడవు, వెడల్పు మూరన్నర. ");
INSERT INTO tel2017_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","బంగారంతో రెండు కెరూబు ఆకారాలను చేశాడు. కరుణా స్థానం రెండు అంచులను బంగారు రేకులతో అలంకరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","రెండు కొనలకు రెండు కెరూబు ఆకారాలను జత చేసి, అవి కరుణా స్థానం మూతకు ఏకాండంగా నిలిచేలా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ఆ రెండు కెరూబులు పైకి రెక్కలు విప్పి, కరుణా స్థానాన్ని వాటి రెక్కలతో కప్పాయి. కెరూబుల ముఖాలు కరుణా స్థానాన్ని కప్పుతూ ఒక దానికొకటి ఎదురెదురుగా నిలిచాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","అతడు తుమ్మకర్రతో బల్ల తయారు చేశాడు. దాని పొడవు రెండు మూరలు, వెడల్పు ఒక మూర, ఎత్తు మూరన్నర. ");
INSERT INTO tel2017_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","అతడు దాని పైన స్వచ్ఛమైన బంగారంతో రేకు పొదిగించి, దాని చుట్టూ బంగారంతో అలంకరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","దాని చుట్టూ బెత్తెడు బద్దె చేసి దాని బద్దె పైన చుట్టూ బంగారు రేకు అమర్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","బల్ల కోసం బంగారంతో నాలుగు గుండ్రని కమ్మీలు పోతపోసి బల్ల నాలుగు కాళ్ళ మూలలకు వాటిని బిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","బల్లను మోసేందుకు వీలుగా గుండ్రని కమ్మీలు దాని బద్దెకు దగ్గరగా ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","బల్లను మోసే కర్రలను తుమ్మకర్రతో చేయించి వాటికి బంగారం రేకులు పొదిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","బల్లమీద ఉండే సామగ్రి, అంటే దాని పాత్రలు, ధూపం వేసే కలశాలు, గిన్నెలు, పానీయ అర్పణకు పాత్రలు స్వచ్ఛమైన బంగారంతో చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","అతడు దీప స్తంభాన్ని స్వచ్ఛమైన బంగారంతో చేశాడు. దాన్నీ, దాని అడుగు భాగాన్నీ, నిలువు భాగాన్నీ బంగారు రేకుతో అలంకరించాడు. దాని కలశాలు, మొగ్గలు, పువ్వులు ఏకాండంగా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","దీపవృక్షం రెండు వైపుల నుండి మూడేసి కొమ్మల చొప్పున ఆరు కొమ్మలు బయలుదేరాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","దీపవృక్షం నుండి బయలు దేరిన ఆరు కొమ్మలకు ఒక్కో కొమ్మకు బాదం ఆకారంలో పువ్వులు, మొగ్గలు ఉన్నాయి. ఆ విధంగా దీపవృక్షం నుండి బయలు దేరిన ఆరు కొమ్మలకు ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","దీపవృక్షంలో బాదం రూపంలో మొగ్గలు, పువ్వులు ఉన్న నాలుగు కలశాలు ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","దీపవృక్షం నుండి బయలు దేరిన ఆరు కొమ్మలలో రెండేసి కొమ్మల కింద ఒక్కో పువ్వు మొగ్గ ఏకాండంగా ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","వాటి మొగ్గలు, కొమ్మలు ఏకాండంగా ఉన్నాయి. ఏకాండంగా ఉన్న అవన్నీ స్వచ్ఛమైన బంగారంతో అలంకరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","దానికి ఏడు దీపాలు, దాని కత్తెరలు, కత్తెర చిప్పలు, దాని పట్టుకారులు మేలిమి బంగారంతో చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","దీపవృక్షం, దాని సామగ్రి అంతటినీ 35 కిలోల మేలిమి బంగారంతో చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","అతడు తుమ్మకర్రతో ధూపవేదికను చేశాడు. దాని పొడవు, వెడల్పు ఒక మూర. అది చదరంగా ఉంది. దాని ఎత్తు రెండు మూరలు, దాని కొమ్ములు మలుపులు లేకుండా ఏకాండంగా ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","దాని కప్పుకు, నాలుగు పక్కలకు, దాని కొమ్ములకు స్వచ్ఛమైన బంగారు రేకులు పొదిగించి దానికి పై అంచు చుట్టూ బంగారం అలంకరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ఆ అలంకారం కింద వేదికకు రెండు గుండ్రని బంగారపు కమ్మీలను చేసి దాని రెండు పక్కలా రెండు మూలల్లో బంగారం అలంకారం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","దాన్ని మోసే కర్రలను తుమ్మకర్రతో చేసి వాటికి బంగారం రేకులు తొడిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","పవిత్ర అభిషేక తైలాన్నీ, స్వచ్ఛమైన పరిమళ ధూపద్రవ్యాన్ని నిపుణుడైన పనివాడితో చేయించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","అతడు తుమ్మకర్రతో హోమ బలిపీఠం తయారుచేశాడు. దాని పొడవు, వెడల్పు ఐదు మూరలు. ఎత్తు మూడు మూరలు, దాన్ని చతురస్రంగా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","దాని నాలుగు మూలలా ఏకాండంగా నాలుగు కొమ్ములు చేశాడు. దానికి ఇత్తడి రేకు పొదిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","బలిపీఠం సంబంధిత సామగ్రి అంటే, బూడిద ఎత్తే గిన్నెలూ, గరిటెలు, పళ్ళేలూ, ముళ్ళూ, నిప్పులు వేసే పళ్ళాలు అన్నీ కంచుతో చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","బలిపీఠానికి ఇత్తడి జల్లెడను దాని అంచుల కింద దాని మధ్య భాగం వరకూ లోతుగా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ఆ ఇత్తడి జల్లెడ నాలుగు మూలల్లో దాని మోతకర్రలు ఉంచే నాలుగు గుండ్రని కొంకీలు పోతపోశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ఆ మోతకర్రలను తుమ్మకర్రతో చేశాడు. వాటికి రాగిరేకులు పొదిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ఆ బలిపీఠం మోసేందుకు దాని నాలుగు వైపులా గుండ్రని కొంకీల్లో మోసే కర్రలు చొప్పించాడు. బలిపీఠాన్ని పలకలతో గుల్లగా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","గంగాళాన్నీ, పీటనూ ఇత్తడితో చేశాడు. వాటిని చెయ్యడానికి సన్నిధి గుడారం ద్వారం దగ్గర సేవించడానికి వచ్చిన స్త్రీల అద్దాలను ఉపయోగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","అప్పుడు అతడు ప్రహరీ నిర్మించాడు. ప్రహరీ కుడి వైపున, అంటే దక్షిణం దిక్కున 100 మూరల పొడవు ఉన్న నారతో నేసిన సన్నని తెరలు ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ఆ తెరల స్తంభాలు ఇరవై, వాటి ఇత్తడి దిమ్మలు ఇరవై. ఆ స్తంభాల కొక్కేలు, పెండెబద్దలు వెండితో చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ఉత్తర దిక్కున ఉన్న తెరల పొడవు 100 మూరలు. వాటి స్తంభాలు ఇరవై. వాటి ఇత్తడి దిమ్మలు ఇరవై. ఆ స్తంభాల కొక్కేలు, వాటి పెండెబద్దలు వెండితో చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","పడమటి దిక్కున తెరల పొడవు ఏభై మూరలు. వాటి స్తంభాలు పది, వాటి దిమ్మలు పది, ఆ స్తంభాల కొక్కేలు, వాటి పెండె బద్దలు వెండితో చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","తూర్పువైపు అంటే ఉదయం దిక్కున వాటి పొడవు ఏభై మూరలు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ద్వారం ఒక వైపు తెరల పొడవు పదిహేను మూరలు. వాటి స్తంభాలు మూడు, వాటి దిమ్మలు మూడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ఆ విధంగా రెండవ వైపున అంటే రెండు వైపులా ఆవరణ ద్వారానికి పదిహేను మూరల పొడవైన తెరలు ఉన్నాయి. వాటి స్తంభాలు మూడు, వాటి దిమ్మలు మూడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ప్రహరీ చుట్టూ ఉన్న తెరలన్నీ సన్నని నారతో నేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","స్తంభాల దిమ్మలు రాగివి, వాటి కొక్కేలు, వాటి పెండెబద్దలు వెండితో చేశారు. వాటి పైభాగాలకు వెండి రేకులు పొదిగించారు. ప్రహరీలోని స్తంభాలన్నీ వెండి రేకులతో కూర్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ప్రహరీ ద్వారంలో ఉంచిన తెర నీలం ఊదా ఎర్రని రంగు గలది. అది సన్నని నారతో నేసి అల్లిక పని చేసి ఉంది. దాని పొడవు ఇరవై మూరలు. దాని వెడల్పు ప్రహరీ తెరలతో సరిగా ఐదు మూరలు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","వాటి స్తంభాలు నాలుగు, వాటి ఇత్తడి దిమ్మలు నాలుగు. వాటి కొక్కేలు వెండితో చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","వాటి పైభాగాలకు వెండి రేకు పొదిగించారు. వాటి పెండె బద్దలు వెండివి, మందిరానికి, మందిరం చుట్టూ ఉన్న ప్రహరీకీ కొట్టిన మేకులన్నీ ఇత్తడివి. ");
INSERT INTO tel2017_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","మందిరం సామాను మొత్తం, అంటే శాసనాల గుడార మందిరం సామగ్రి మొత్తం ఇదే. యాజకుడైన అహరోను కొడుకు ఈతామారు లేవీ గోత్రికుల చేత మోషే ఆజ్ఞ ప్రకారం ఆ వస్తువులు లెక్క పెట్టించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","యూదా గోత్రికుడు హూరు మనుమడు, ఊరీ కొడుకు బెసలేలు యెహోవా మోషేకు ఆజ్ఞాపించినదంతా పూర్తి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","దాను గోత్రికుడు అహీసామాకు కొడుకు అహోలీయాబు అతనికి సహాయకుడుగా ఉన్నాడు. ఇతడు చెక్కడంలో నేర్పు గలవాడు. నిపుణత గల పనివాడు, నీలం ఊదా ఎర్ర రంగుల సన్నని నారతో అల్లిక పని చేయడంలో నేర్పరి. ");
INSERT INTO tel2017_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","పవిత్ర స్థలాన్ని పూర్తి స్థాయిలో నిర్మించే పని అంతటిలో ఉపయోగించిన బంగారం పవిత్ర స్థలం తులం కొలత ప్రకారం సుమారు 29 తలాంతులు, 730 షెకెల్. ");
INSERT INTO tel2017_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","జాబితాలో చేరినవారి సమాజపు ప్రజలు ఇచ్చిన వెండి పవిత్ర స్థలం తులం కొలత ప్రకారం 100 తలాంతులు, 1, 775 షెకెల్. ");
INSERT INTO tel2017_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ఇరవై సంవత్సరాలు పైబడి లెక్కలో చేరినవారు 6,03,550 మంది. వీరి అర్పణ ఒక్కొక్కటి అర తులం. ");
INSERT INTO tel2017_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","అడ్డతెరల కోసం, ఆరాధన గుడారం కోసం దిమ్మలు పోత పోయడంలో ఒక్కో దిమ్మకు నాలుగు మణుగుల వెండి ఉపయోగించారు. అంటే ఒక దిమ్మకు నాలుగు మణుగుల చొప్పున నూరు దిమ్మలు పోతపోశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","1, 575 తులాల వెండితో అతడు స్తంభాలకు కొక్కేలు చేసి, వాటిని స్తంభాల పైభాగాలకు తొడిగించి వాటిని పెండెబద్దలతో కట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","అర్పించిన ఇత్తడి మొత్తం 280 మణుగుల 2, 400 తులాలు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","అతడు ఆ ఇత్తడితో సన్నిధి గుడారం ద్వారం కోసం దిమ్మలు, బలిపీఠం, జల్లెడ, బలిపీఠం సామగ్రి చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ఇంకా ప్రహరీ చుట్టూ ఉన్న దిమ్మలు, ప్రహరీ ద్వారం దిమ్మలు, దైవ నివాసం మేకులు, ప్రహరీ చుట్టూ వాడిన మేకులన్నిటినీ ఆ ఇత్తడితో చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","యెహోవా మోషేకు ఇచ్చిన ఆజ్ఞ ప్రకారం పవిత్ర స్థలం లో నిలిచి చేసే సేవ కోసం నీలం ఊదా ఎర్రని రంగుల సేవా వస్త్రాలు అంటే ప్రతిష్ఠిత వస్త్రాలు కుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","అతడు బంగారంతో, నీలం ఊదా ఎర్ర రంగుల దారాలతో పేనిన సన్నని నారతో ఏఫోదు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ఏఫోదు కోసం నీలం ఊదా ఎర్ర రంగుల దారాలతో, సన్నని నారతో నేర్పుగల పనివారు నేయడానికి బంగారాన్ని రేకులుగా కొట్టి దాన్ని తీగెలుగా కత్తిరించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ఏఫోదుకు రెండు భుజ ఖండాలు చేసి రెండు అంచులలో నిలబెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","దానికి బంగారంతో నీలం ఊదా ఎర్ర రంగుల సన్నని నారతో పేనిన అందమైన అల్లిక ఏకాండంగా రెండు వైపులా కుట్టారు. అలా చేయమని యెహోవా మోషేకు ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","బంగారు అంచులలో పొదిగిన లేత పచ్చలు సిద్ధం చేశారు. ఇశ్రాయేలు కొడుకుల పేర్లు శాశ్వతంగా ఉండేలా ముద్రల రూపంలో చెక్కారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","అవి ఇశ్రాయేలు ప్రజల జ్ఞాపకార్ధంగా ఉండేలా ఆ ముద్రలను ఏఫోదు భుజాల మీద ఉంచారు. అలా చేయమని యెహోవా మోషేకు ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","అతడు బంగారంతోనూ నీలం ఊదా ఎర్ర దారాలతోను పేనిన సన్న నారతో ఏఫోదును చేసినట్టు నైపుణ్యంగా ఒక వక్షపతకం తయారుచేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","దాని పొడవు ఒక జాన, వెడల్పు ఒక జాన. ఆ పతకాన్ని మడత పెట్టినప్పుడు అది చదరంగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","వారు దానిలో నాలుగు వరుసలుగా రత్నాలు పొదిగారు. మొదటి వరుసలో మాణిక్యం, గోమేధికం, మరకతం ఉన్న రత్నాలు, ");
INSERT INTO tel2017_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","రెండవ వరుసలో పద్మరాగం, నీలం, సూర్యకాంత మణులు ఉన్న రత్నాలు, ");
INSERT INTO tel2017_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","మూడవ వరుసలో గారుత్మతకం, యష్మురాయి, ఇంద్రనీలాల రత్నాలు, ");
INSERT INTO tel2017_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","నాలుగవ వరుసలో ఎర్ర రంగు రాయి, సులిమాని రాయి, సూర్యకాంతాలు ఉన్న రత్నాలు క్రమ పద్ధతిలో పొదిగించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ఇశ్రాయేలు కొడుకులు పన్నెండు మంది పేర్ల ప్రకారం ఆ రత్నాలు పన్నెండు. ఆ రత్నాలపై ముద్రపై చెక్కిన విధంగా పన్నెండు గోత్రాల పేర్లు ఒక్కొక్కదాని మీద ఒక్కొక్క పేరు చెక్కారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","వక్షపతకం కోసం దారాలు అల్లినట్టు స్వచ్ఛమైన బంగారంతో గొలుసులు అల్లారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","వారు రెండు బంగారు అంచులు, రెండు బంగారు గుండ్రని కొంకీలు చేసి వక్షపతకం రెండు అంచులకు బిగించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","అల్లిన ఆ రెండు బంగారు గొలుసులను వక్షపతకం అంచులలో ఉన్న రెండు గుండ్రని కొంకీలలో వేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","అల్లిన ఆ రెండు గొలుసుల అంచులు ఆ రెండు అంచులకు తగిలించి ఏఫోదు భుజఖండాలపై దాని ఎదురుగా ఉంచారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","బంగారంతో రెండు గుండ్రని కొంకీలు చేసి ఏఫోదు ఎదురుగా ఉన్న వక్షపతకం లోపలి అంచు రెండు కొనలకు తగిలించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","బంగారంతో మరో రెండు గుండ్రని కొంకీలు ఏఫోదు అల్లిక పైగా దాని రెండవ కూర్పు దగ్గర దాని ఎదురుగా, ఏఫోదు రెండు భుజఖండాలకు కింది భాగంలో వేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","వక్షపతకం ఏఫోదు అల్లిక కట్టు మీద ఉండేలా, ఏఫోదు నుండి విడిపోకుండా ఉండేలా ఆ పతకాన్ని దాని గుండ్రని కొంకీలకూ ఏఫోదు కొంకీలకూ నీలం రంగు దారంతో కట్టారు. అలా చేయమని యెహోవా మోషేకు ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","అతడు ఏఫోదు అంగీ కేవలం నీలం రంగు దారంతో అల్లిక పనిగా చేశాడు. ఆ అంగీ మధ్య ఉన్న రంధ్రాన్ని మూసి ఉంచే కవచం ఏర్పాటు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ఆ రంధ్రం చిరిగి పోకుండా ఉండేందుకు రంధ్రం చుట్టూ కవచం ఉంచారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","అంగీ అంచుల మీద నీలం ఊదా ఎర్రని రంగుల గల నూలుతో పేని దానిమ్మ పండ్ల ఆకారాలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","స్వచ్ఛమైన బంగారంతో గంటలు చేసి ఆ దానిమ్మపండ్ల ఆకారాల మధ్యలో, అంటే అంగీ అంచుల మీద చుట్టూ ఉన్న దానిమ్మ పండ్లవంటి వాటి మధ్యలో ఆ గంటలను పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","యెహోవా మోషేకు ఆజ్ఞాపించినట్టు సేవ జరిగించడానికి ఒక్కొక్క గంటను ఒక్కొక్క దానిమ్మ పండు వంటి ఆకారాన్ని అంగీ అంచుల మీద చుట్టూ తగిలించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","యెహోవా మోషేకు ఆజ్ఞాపించినట్టు అహరోనుకు, అతని కొడుకులకు సన్నని నారతో అల్లిక పని చేసి అంగీలు నేశారు. సన్నని నారతో తలపాగాలను చేసారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","సన్నని నారతో టోపీలు, చొక్కాలు నేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","నీలం, ఊదా, ఎర్ర రంగులతో పేనిన సన్నని నారతో నడికట్టును అల్లిక పనిగా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","స్వచ్ఛమైన బంగారంతో కిరీటం వంటి ఆకారంలో ఒక రేకు తయారు చేసి యెహోవా మోషేకు ఆజ్ఞాపించిన విధంగా దాని మీద “యెహోవాకు పవిత్రం” అని చెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ఆ ముద్రను తలపాగాకు అంటుకుని ఉండేలా నీలం రంగు దారంతో కట్టారు. ఇదంతా యెహోవా మోషేకు ఆజ్ఞాపించినట్టు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ఈ విధంగా సన్నిధి గుడారం అనే దైవ నివాసం పని పూర్తిగా ముగించారు. యెహోవా మోషేకు ఆజ్ఞాపించిన విధంగా ఆ ప్రజలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","దైవ నివాసాన్ని, దానిలో సామగ్రి మొత్తాన్నీ అంటే, దాని కొక్కేలు, పలకలు, అడ్డకర్రలు, స్తంభాలు, దిమ్మలు, ");
INSERT INTO tel2017_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ఎర్ర రంగు వేసిన పొట్టేళ్ల తోళ్ల పైకప్పు, గండుచేప తోళ్ల పైకప్పు, పైకప్పు తెర, ");
INSERT INTO tel2017_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","శాసనాల పెట్టె, దాన్ని మోసే కర్రలు, కరుణాపీఠం, ");
INSERT INTO tel2017_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","సన్నిధి బల్ల, దాని సామగ్రి, సన్నిధి రొట్టెలు, ");
INSERT INTO tel2017_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","పవిత్ర దీపవృక్షం, దాని దీపాలు, దీపాల వరుస, వాటి సామాను, దీపాలు వెలిగించేందుకు నూనె, ");
INSERT INTO tel2017_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","బంగారం వేదిక, అభిషేక తైలం, పరిమళ ధూప ద్రవ్యం, వేదిక ద్వారానికి తెర, ");
INSERT INTO tel2017_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ఇత్తడి బలిపీఠం, దాని ఇత్తడి జల్లెడ, దాన్ని మోసే కర్రలు, దాని సామగ్రి మొత్తం, గంగాళం, దాని పీట, ");
INSERT INTO tel2017_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ప్రహరీ తెరలు, దాని స్తంభాలు, దాని దిమ్మలు, ప్రహరీ ద్వారానికి తెర, దాని తాళ్ళు, మేకులు, సన్నిధి గుడారం మందిర సేవ కోసం కావలసిన సామగ్రి అంతా, ");
INSERT INTO tel2017_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","పవిత్ర స్థలం లో సేవ చేసే యాజకుడైన అహరోనుకూ, అతని కొడుకులకూ యాజక పరిచర్య పవిత్ర వస్త్రాలు సిద్ధం చేసి వాటన్నిటినీ మోషే దగ్గరికి తీసుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","యెహోవా మోషేకు ఆజ్ఞాపించినట్లు ఇశ్రాయేలు ప్రజలు పనులన్నీ పూర్తిచేశారు. ");
INSERT INTO tel2017_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","వాళ్ళు చేసిన పని అంతా మోషే పరిశీలించాడు. యెహోవా ఆజ్ఞాపించినట్టే వాళ్ళు ఆ పనులు పూర్తి చేశారు కనుక మోషే వాళ్ళను దీవించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“మొదటి నెల మొదటి రోజున నువ్వు సన్నిధి గుడారం ఉన్న మందిరాన్ని నిలబెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","అక్కడ శాసనాల పెట్టెను నిలబెట్టి దాన్ని అడ్డ తెరతో మూసి ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","బల్లను లోపలికి తెచ్చి దాని మీద ఉంచవలసిన వాటిని క్రమంగా ఉంచాలి. దీప స్తంభాన్ని లోపలికి తెచ్చి దాని దీపాలు వెలిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","శాసనాల పెట్టె ఎదురుగా బంగారు ధూపవేదికను ఉంచి, మందిర ద్వారానికి తెర తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","సన్నిధి గుడారం ఉన్న మందిరం ద్వారం ఎదురుగా హోమ బలిపీఠం ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","సన్నిధి గుడారం, హోమ బలిపీఠం మధ్యలో ఒక గంగాళం పెట్టి, దాన్ని నీళ్ళతో నింపాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","తెరల చుట్టూ ప్రహరీ నిలబెట్టి, ప్రహరీ ద్వారానికి తెర తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","అభిషేక తైలం తీసుకుని దైవ నివాసాన్నీ, అందులోని వాటన్నిటినీ అభిషేకించాలి. దానినీ, దానిలోని సామగ్రి అంతటినీ ప్రతిష్టించాలి. అప్పుడు అది పవిత్రం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","హోమ బలిపీఠాన్ని అభిషేకించి, దాన్ని ప్రతిష్ఠించాలి. అప్పుడు ఆ పీఠం పవిత్రం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","గంగాళాన్ని, దాని పీటను అభిషేకించి, వాటిని ప్రతిష్ఠించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","తరువాత అహరోనును, అతని కొడుకులను సన్నిధి గుడారం ద్వారం దగ్గరికి వెంటబెట్టుకుని తీసుకువచ్చి నీళ్లతో స్నానం చేయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","అతనికి పవిత్ర వస్త్రాలు తొడిగి అతడు నాకు యాజకుడుగా సేవ జరిగించడానికి అతన్ని అభిషేకించి ప్రతిష్ఠించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","తరువాత అతని కొడుకులను తీసుకువచ్చి వాళ్లకు చొక్కాలు తొడిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","వాళ్ళు కూడా నాకు యాజకులుగా ఉండేలా వాళ్ళ తండ్రిని అభిషేకించినట్టు వాళ్ళను అభిషేకించి ప్రతిష్టించు. వారి అభిషేకం తరతరాలకు నిత్యమూ నిలిచే యాజకత్వ చిహ్నంగా ఉంటుంది.” ");
INSERT INTO tel2017_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","మోషే ఆ విధంగా చేశాడు. యెహోవా అతనికి ఆజ్ఞాపించినదంతా జరిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","రెండవ సంవత్సరం మొదటి నెల మొదటి రోజున దైవ నివాస మందిరం నిలబెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","యెహోవా మోషేకు ఆజ్ఞాపించినట్టు దైవ నివాస మందిరం నిలబెట్టి దాని దిమ్మలు వేసి, దాని పలకలను నిలబెట్టి దాని అడ్డకర్రలు అమర్చి, స్తంభాలను నిలిపాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","యెహోవా మందిరం పైన గుడారం పరిచాడు. గుడారానికి పైకప్పు వేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","యెహోవా అతనికి ఆజ్ఞాపించినట్టు శాసనాలను మందసంలో ఉంచాడు. మందసాన్ని మోసే కర్రలను పెట్టెకు దూర్చి దానిపైన కరుణా స్థానం మూత ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","మందసాన్ని యెహోవా మందిరంలోకి తెచ్చి అడ్డతెర వేలాడదీసి శాసనాల పెట్టెను కప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","సన్నిధి గుడారంలో, దైవ సన్నిధి మందిరం ఉత్తర దిక్కున, అడ్డతెరకు బయట బల్లను ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","యెహోవా సన్నిధి ఎదుట బల్ల మీద రొట్టెలను క్రమంగా పేర్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","యెహోవా మోషేకు ఆజ్ఞాపించినట్టు అతడు సన్నిధి గుడారంలో మందిరానికి దక్షిణం వైపున బల్ల ఎదుట దీపస్తంభం ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","యెహోవా సన్నిధానంలో దీపాలు వెలిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","యెహోవా మోషేకు ఆజ్ఞాపించినట్టు అతడు సన్నిధి గుడారంలో అడ్డతెర ఎదుట బంగారు ధూపవేదిక ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ధూపవేదిక మీద పరిమళ ద్రవ్యాలను కాల్చి ధూపం వేశాడు. యెహోవా మోషేకు ఆజ్ఞాపించినదంతా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","మందిర ద్వారానికి తెర ఏర్పాటు చేశాడు. అతడు దైవ సన్నిధి గుడారం ద్వారం దగ్గర హోమపీఠం ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","యెహోవా హోమ బలిపీఠం మీద హోమబలి అర్పించి నైవేద్యం సమర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","యెహోవా అతనికి ఆజ్ఞాపించినట్టు దైవసన్నిధి గుడారానికి, హోమ పీఠానికి మధ్య గంగాళం ఉంచి శుభ్రపరచుకోవడానికి దానిలో నీళ్లు పోయించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","అక్కడ మోషే, అహరోను, అతని కొడుకులు తమ కాళ్ళు, చేతులు కడుక్కున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","వాళ్ళు యెహోవా గుడారం లోపలికి ప్రవేశించినప్పుడు, హోమపీఠం చెంతకు వచ్చినప్పుడు తమ కాళ్ళు, చేతులు కడుక్కున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","మోషే మందిరానికి, హోమపీఠానికి చుట్టూ ప్రహరీ ఏర్పాటు చేశాడు. ఆవరణ ద్వారం తెర వేశాడు. ఈ విధంగా మోషే పని మొత్తం ముగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","అప్పుడు మేఘం యెహోవా సన్నిధి గుడారాన్ని కమ్ముకుంది. దైవ నివాసం యెహోవా మహిమా ప్రకాశంతో నిండింది. ");
INSERT INTO tel2017_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ఆ మేఘం యెహోవా సన్నిధి గుడారంపై నిలిచి ఉండడం వల్ల మందిరం యెహోవా తేజస్సుతో నిండిపోయింది. అందువల్ల మోషే యెహోవా సన్నిధి గుడారం లోపలి వెళ్ళలేక పోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","మేఘం మందిరం మీద నుండి పైకి వెళ్ళే సమయంలో ఇశ్రాయేలు ప్రజలు ప్రయాణం చేసేవాళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ఆ మేఘం పైకి వెళ్ళకపోతే అది వెళ్ళే రోజు దాకా ప్రయాణం ఆపివేసే వాళ్ళు. ఇది వాళ్ళు ప్రయాణం చేసే పద్ధతి. ");
INSERT INTO tel2017_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ఇశ్రాయేలు ప్రజలందరి సమక్షంలో పగటివేళ యెహోవా మేఘం దైవనివాసం మీద ఉండేది. రాత్రి సమయాల్లో మేఘంలో అగ్ని స్థంభం ఉండేది. ప్రజల ప్రయాణాలన్నిటిలో ఈ విధంగా జరిగింది.");
INSERT INTO tel2017_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","యెహోవా మోషేని పిలిచి ప్రత్యక్ష గుడారం నుండి అతనితో ఇలా అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“నువ్వు ఇశ్రాయేలు ప్రజలతో మాట్లాడి ఇలా చెప్పు. మీలో ఎవరైనా యెహోవాకు అర్పణ తేవాలంటే దాన్ని తన పశువుల్లో నుండి గానీ, మేకల, గొర్రెల మందల్లో నుండి గానీ తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ఒకవేళ అతడు దహనబలిగా పశువుల్లో నుండి ఒక దాన్ని అర్పించాలనుకుంటే లోపం లేని మగ పశువును తీసుకు రావాలి. యెహోవా సమక్షంలో అది అంగీకారం పొందాలంటే దాన్ని ప్రత్యక్ష గుడారం ద్వారం దగ్గర అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","దహనబలిగా అర్పించే పశువు తల మీద అతడు తన చెయ్యి ఉంచాలి. అప్పుడు అతనికి ప్రాయశ్చిత్తం కలగడానికి అతని పక్షంగా అది ఆమోదం పొందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","తరువాత అతడు యెహోవా సమక్షంలో ఆ కోడె దూడని వధించాలి. యాజకులైన అహరోను కొడుకులు దాని రక్తాన్ని తీసుకు వచ్చి ప్రత్యక్ష గుడారం ప్రవేశద్వారం దగ్గర ఉన్న బలిపీఠం పైన చిలకరిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","తరువాత అతడు దహనబలి పశువు చర్మాన్ని ఒలిచి దాన్ని ముక్కలుగా కోయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","తరువాత యాజకుడైన అహరోను కొడుకులు బలిపీఠం పైన కట్టెలు పేర్చి మంట పెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","అప్పుడు యాజకులైన అహరోను కొడుకులు ఆ పశువు శరీర భాగాలనూ, తలనూ, కొవ్వునూ ఒక పద్ధతి ప్రకారం ఆ కట్టెలపైన పేర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","కానీ దాని లోపలి భాగాలనూ, కాళ్ళనూ నీళ్ళతో కడగాలి. అప్పుడు యాజకుడు అన్నిటినీ తీసుకుని యెహోవా బలిపీఠం పైన దహనబలిగా దహించాలి. అప్పుడు అది నాకు కమ్మని సువాసననిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","గొర్రెల, మేకల మందల్లో నుండి దేనినైనా దహనబలిగా అర్పించాలనుకుంటే లోపం లేని పోతును తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","బలిపీఠం ఉత్తరం వైపు యెహోవా సమక్షంలో దాన్ని వధించాలి. యాజకులైన అహరోను కొడుకులు బలిపీఠం అన్ని వైపులా దాని రక్తాన్ని చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","అప్పుడు దాన్ని తలా, కొవ్వుతో పాటు ఏ భాగానికి ఆ భాగంగా ముక్కలు చేయాలి. తరువాత వాటిని బలిపీఠంపై ఉన్న మంటపై అమర్చిన కట్టెలపై ఒక పద్ధతిలో పేర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","దాని లోపలి భాగాలనూ, కాళ్ళనూ నీళ్ళతో కడగాలి. అప్పుడు యాజకుడు అన్నిటినీ తీసుకుని బలిపీఠం పై దహించాలి. ఇది దహనబలి. ఇది యెహోవాకు కమ్మని సువాసన కలుగజేస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ఒక వ్యక్తి యెహోవాకు దహనబలిగా పక్షిని అర్పించాలనుకుంటే ఒక గువ్వని గానీ పావురం పిల్లని గానీ తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","యాజకుడు దాన్ని బలిపీఠం దగ్గరికి తీసుకువచ్చి దాని తలను చేతితో తుంచివేయాలి. తరువాత దాన్ని బలిపీఠం పైన కాల్చాలి. ఆ పక్షి రక్తాన్ని బలిపీఠం పక్కనే పిండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","తరువాత దాని పొట్ట తీసివేసి బలిపీఠం తూర్పు వైపున బూడిద పోసే చోట పారెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","అతడు దాని రెక్కల సందులో చీల్చాలి గానీ రెండు ముక్కలుగా చేయకూడదు. యాజకుడు దాన్ని బలిపీఠం పైన ఉన్న కట్టెలపై కాల్చాలి. ఇది దహనబలి, అంటే ఇది యెహోవాకు కమ్మని సువాసనను కలుగజేస్తుంది.” ");
INSERT INTO tel2017_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ఎవరైనా ఒక వ్యక్తి యెహోవాకు ధాన్య నైవేద్యం అర్పించాలంటే ఆ అర్పణ సన్నని గోదుమ పిండి అయి ఉండాలి. అతడు దాని మీద నూనె పోసి, సాంబ్రాణి వేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","అతడు దాన్ని యాజకులైన అహరోను కొడుకుల దగ్గరికి తీసుకు రావాలి. అప్పుడు యాజకుడు తన చేతి నిండుగా నూనే, సాంబ్రాణీ కలిసిన సన్నని పిండిని తీసుకుంటాడు. అప్పుడు యాజకుడు యెహోవా మంచితనం గూర్చి కృతజ్ఞతాపూర్వకంగా స్మరించడానికై ఆ అర్పణని బలిపీఠం పైన వేసి కాల్చాలి. అది యెహోవా కోసం కమ్మని సువాసనను కలుగజేస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ఆ నైవేద్యంలో మిగిలింది అహరోనుకూ, అతని కొడుకులకూ చెందుతుంది. యెహోవాకి అర్పించే దహన బలులన్నిటిలో ఇది అతి పరిశుద్ధం. ");
INSERT INTO tel2017_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","మీరు పొయ్యిలో కాల్చిన నైవేద్యం అర్పించాలంటే పొంగజేసే పదార్ధం లేకుండా సన్నని పిండితో, నూనె కలిపి చేసిన మెత్తని చపాతీ అయి ఉండాలి. లేదా సన్నని పిండితో, నూనె రాసి చేసిన అప్పడంలా గట్టిగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ఒకవేళ నీ అర్పణ పెనం మీద కాల్చిన నైవేద్యమైతే అది పొంగజేసే పదార్ధం లేకుండా సన్నని పిండితో, నూనె రాసి చేసినదై ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","అది నైవేద్యం, కాబట్టి దాన్ని నువ్వు ముక్కలు చేసి వాటి పైన నూనె పోయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ఒకవేళ నీ నైవేద్యం వంట పాత్రలో వండినదైతే దాన్ని సన్నని పిండీ, నూనే కలిపి తయారు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ఈ పదార్ధాలతో చేసిన నైవేద్యాన్ని యెహోవా దగ్గరికి తీసుకురావాలి. దాన్ని యాజకుడికి అందించాలి. అతడు దాన్ని బలిపీఠం దగ్గరికి తీసుకు వస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","తరువాత యాజకుడు యెహోవా మంచితనం గూర్చి కృతజ్ఞతాపూర్వకంగా స్మరించుకోడానికి ఆ నైవేద్యంలో కొంత భాగం తీసుకుని బలిపీఠంపై దహించాలి. అది అగ్నితో చేసిన అర్పణ. అది యెహోవా కోసం కమ్మని సువాసనను కలుగజేస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ఆ నైవేద్యంలో మిగిలిన భాగం అహరోనుకీ, అతని కొడుకులకీ చెందుతుంది. యెహోవాకి అర్పించే దహన బలులన్నిటిలో ఇది అతి పరిశుద్ధం. ");
INSERT INTO tel2017_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","మీరు యెహోవాకి సమర్పించే ఏ నైవేద్యం లోనూ పొంగజేసే పదార్ధం ఉండకూడదు. ఎందుకంటే తేనెనూ, పొంగజేసే పదార్ధం దేనినైనా నైవేద్యంగా బలిపీఠం పైన దహించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","వాటిని ప్రథమఫలంగా యెహోవాకి సమర్పించవచ్చు. కానీ బలిపీఠం పైన కమ్మని సువాసన కలగజేయడానికి వాటిని వాడకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","నువ్వు అర్పించే ప్రతి నైవేద్యానికీ ఉప్పు కలపాలి. నీ దేవుని నిబంధన ఉప్పు లేకుండా నీ నైవేద్యం ఉండకూడదు. నీ నైవేద్యాలన్నిటితో పాటు ఉప్పు కూడా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","నువ్వు యెహోవాకి ప్రథమ ఫలం నైవేద్యాన్ని అర్పించాలంటే పచ్చని కంకుల్లోని కొత్త ధాన్యాన్ని వేయించి పిండి చేసి అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","తరువాత దానిపై నూనె, సాంబ్రాణి పోయాలి. ఇదీ నైవేద్యమే. ");
INSERT INTO tel2017_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","తరువాత యాజకుడు యెహోవా మంచితనం గూర్చి కృతజ్ఞతాపూర్వకంగా స్మరించడానికై పిండీ, నూనే, సాంబ్రాణిల్లో కొంత భాగం తీసుకుని వాటిని దహిస్తాడు. అది యెహోవా కోసం అగ్నితో చేసిన అర్పణ. ");
INSERT INTO tel2017_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ఎవరైనా ఒక మంద లోని పశువుల్లో నుండి ఒక మగదాన్ని గానీ ఆడదాన్ని గానీ శాంతిబలిగా అర్పించాలనుకుంటే, అతడు లోపం లేని దాన్ని యెహోవా సన్నిధిలో అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","అతడు తాను అర్పించబోయే పశువు తలపై తన చేతిని ఉంచాలి. తరువాత ప్రత్యక్ష గుడారం ద్వారం దగ్గర దాన్ని వధించాలి. అప్పుడు యాజకులైన అహరోను కొడుకులు బలిపీఠం చుట్టూ దాని రక్తాన్ని చిలకరిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","అతడు ఆ పశువు లోపలి భాగాలకు అంటి ఉన్న కొవ్వునూ, మూత్రపిండాలనూ, వాటిపైన కొవ్వునూ, మూత్రపిండాల దగ్గర కాలేయాన్ని అంటి ఉన్న కొవ్వునూ వేరు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","వాటిని యెహోవాకు శాంతి బలి అర్పణగా దహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","అహరోను కొడుకులు వాటిని బలిపీఠం మీద నిప్పులపై పేర్చిన కట్టెల పైన ఉన్న దహనబలి తో పాటు దహిస్తారు. అది యెహోవా కోసం కమ్మని సువాసనను కలుగజేస్తుంది. అది అగ్నితో చేసిన అర్పణగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","ఎవరైనా ఒక గొర్రెల లేక మేకల మందలో నుండి ఒక మగదాన్ని గానీ ఆడదాన్ని గానీ శాంతిబలిగా యెహోవాకు అర్పించదలిస్తే, అతడు లోపం లేని దాన్ని అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","తన అర్పణ కోసం గొర్రె పిల్లని అర్పించాలనుకుంటే దాన్ని యెహోవా సన్నిధికి తీసుకుని రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","తాను అర్పించబోయే దాని తల మీద అతడు తన చేతినుంచాలి. తరువాత దాన్ని ప్రత్యక్ష గుడారం ఎదుట వధించాలి. అప్పుడు అహరోను కొడుకులు బలిపీఠం చుట్టూ దాని రక్తాన్ని చిలకరిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ఆ వ్యక్తి శాంతిబలి అర్పణను దహనబలి అర్పణగా యెహోవాకు అర్పిస్తాడు. ఆ బలి పశువు కొవ్వునూ, వెన్నెముక చివర వరకూ ఉండే కొవ్వు పట్టిన తోకనంతా, దాని అంతర్భాగాలకి పట్టి ఉన్న కొవ్వునూ, వాటి దగ్గరలో కనిపించే కొవ్వునూ తీసి వేరు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","అలాగే రెండు మూత్ర పిండాలనూ, వాటితో ఉన్న కొవ్వునూ, మూత్రపిండాల దగ్గర కాలేయాన్ని అంటి ఉన్న కొవ్వునూ కూడా వేరు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","వీటన్నిటినీ యాజకుడు బలిపీఠం పైన ఆహారంగా కాలుస్తాడు. ఇది యెహోవాకి అర్పించే దహనబలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","అతడు అర్పించేది మేక అయితే దాన్ని యెహోవా ఎదుట అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ఆ వ్యక్తి దాని తల మీద చెయ్యి ఉంచి ప్రత్యక్ష గుడారం ఎదుట దాన్ని వధించాలి. అప్పుడు అహరోను కొడుకులు బలిపీఠం చుట్టూ దాని రక్తాన్ని చిలకరిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","తన అర్పణను దహనబలిగా యెహోవాకు అర్పిస్తాడు. అతడు దాని అంతర్భాగాలకు పట్టి ఉన్న కొవ్వునూ, వాటి దగ్గరలో కనిపించే కొవ్వునూ తీసి వేరు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","అలాగే రెండు మూత్ర పిండాలనూ, వాటితో ఉన్న కొవ్వును, మూత్రపిండాల దగ్గర కాలేయాన్ని అంటి ఉన్న కొవ్వును కూడా వేరు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","వీటన్నిటినీ యాజకుడు కమ్మని సువాసన వచ్చేలా బలిపీఠం పైన ఆహారంగా కాలుస్తాడు. కొవ్వు అంతా యెహోవాకే చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","మీరు రక్తాన్ని గానీ కొవ్వుని గానీ తినకూడదు. మీరు నివాసముండే ప్రతిచోటా, మీ తరతరాల్లో ఇది మీకు శాశ్వతమైన శాసనం.” ");
INSERT INTO tel2017_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","యెహోవా మోషేతో ఇంకా ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“నువ్వు ఇశ్రాయేలు ప్రజలకు ఇలా చెప్పు, చేయకూడదని యెహోవా ఆజ్ఞాపించిన విషయాల్లో దేనినైనా పొరపాటున ఎవరైనా చేస్తే, మీరిలా చేయండి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","నేరం ప్రజల పైకి వచ్చేలా ఒకవేళ అభిషేకం పొందిన యాజకుడే అలాంటి పాపం చేస్తే, అతడు తన పాపం కోసం బలిగా లోపం లేని కోడెదూడని యెహోవాకు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","అతడు ఆ కోడెని ప్రత్యక్ష గుడారపు ద్వారం దగ్గర యెహోవా సమక్షంలోకి తీసుకురావాలి. ఆ కోడె తలపైన తన చెయ్యి ఉంచి, తరువాత యెహోవా ఎదుట దాన్ని వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","అభిషేకం పొందిన యాజకుడు ఆ కోడె రక్తం కొంచెం ప్రత్యక్ష గుడారానికి తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","తరువాత ఆ యాజకుడు తన వేలు ఆ రక్తంలో ముంచి అతి పరిశుద్ధ స్థలం తెరల ఎదుట యెహోవా సమక్షంలో ఏడుసార్లు ఆ రక్తాన్ని చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","తరువాత యాజకుడు ప్రత్యక్ష గుడారంలో యెహోవా సమక్షంలో ఉన్న సుగంధ ధూపవేదిక పైని కొమ్ములకు ఆ రక్తాన్ని కొంచెం పూయాలి. మిగిలిన ఆ కోడె రక్తాన్ని ప్రత్యక్ష గుడారం ద్వారం దగ్గర ఉన్న దహన బలిపీఠం అడుగు భాగంలో పారబోయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","తరువాత అతడు పాపం కోసం బలి అర్పణ చేసిన ఆ కోడెదూడ కొవ్వు అంతా కోసి వేరు చేయాలి. దాని అంతర్భాగాలను కప్పి ఉన్న కొవ్వునూ, దాని అంతర్భాగాలను అంటి ఉన్న కొవ్వునూ వేరు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","అలాగే దాని రెండు మూత్ర పిండాలనూ, వాటిపై పేరుకుని ఉన్న కొవ్వునూ, దాని మూత్రపిండాలకు దగ్గర కాలేయం పైన ఉన్న కొవ్వునూ కోసి వేరు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","శాంతిబలి కోసం వధించే ఎద్దు నుండి తీసినట్టే యాజకుడు దీని నుండి కూడా తీయాలి. తరువాత యాజకుడు వీటిని దహన బలిపీఠం పైన దహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","అతడు ఆ కోడె దూడలో ఇంకా మిగిలి ఉన్న భాగాలైన దాని చర్మం, మాంసం, తల, కాళ్ళు, దాని అంతర్భాగాలూ, పేడ, మిగిలిన భాగాలన్నిటినీ శిబిరం బయటకు తీసుకుపోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","బూడిదను పారేసే శుద్ధమైన చోటికి తీసుకుపోయి అక్కడ బూడిద పారబోసే చోట కట్టెల పైన వాటిని దహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ఇశ్రాయేలు సమాజమంతా పొరపాటుగా తెలియకుండా పాపం చేస్తే, చేయకూడదని యెహోవా ఆజ్ఞాపించిన వాటిని అవగాహన లేకుండా చేసి దోషులైతే ");
INSERT INTO tel2017_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","తరువాత వారు చేసిన పాపం వారికి తెలిసినప్పుడు, సమాజం ఒక కోడెదూడని పాపం కోసం బలిగా అర్పించాలి. దాన్ని ప్రత్యక్ష గుడారం ద్వారం దగ్గరికి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","సమాజానికి పెద్దలుగా ఉన్నవాళ్ళు యెహోవా సమక్షంలో దాని తలపై తమ చేతులుంచాలి. ఆ తరువాత యెహోవా సన్నిధిలో దాన్ని వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","అప్పుడు అభిషేకం పొందిన యాజకుడు ఆ కోడె రక్తంలో కొంత ప్రత్యక్ష గుడారానికి తీసుకుని రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","తరువాత యాజకుడు ఆ రక్తంలో తన వేలును ముంచి తెరల ఎదుట యెహోవా సమక్షంలో ఏడు సార్లు చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","తరువాత యాజకుడు ప్రత్యక్ష గుడారంలో యెహోవా సమక్షంలో ఉన్న సుగంధ ధూపవేదిక పైని కొమ్ములకు ఆ రక్తాన్ని కొంచెం పూయాలి. మిగిలిన ఆ కోడె రక్తాన్ని ప్రత్యక్ష గుడారం ద్వారం దగ్గర ఉన్న దహన బలిపీఠం అడుగు భాగంలో కుమ్మరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","తరువాత దాని కొవ్వు అంతటినీ తీసి దహన బలిపీఠం పైన దహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ఈ విధంగా అతడు ఆ కోడెకి చేయాలి. పాపం కోసం బలి ఇచ్చే పశువుకు చేసినట్టుగానే దీనికీ చేయాలి. ఇలా యాజకుడు ప్రజల కోసం పరిహారం చేసినప్పుడు వారికి క్షమాపణ కలుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ఆ కోడెను శిబిరం బయటకు తీసుకుని వెళ్ళి మొదటి కోడెను దహించినట్టుగానే దీన్నీ దహించాలి. ఇది సమాజ పాపం కోసం చేసే బలి అర్పణ. ");
INSERT INTO tel2017_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","ఒక అధికారి పాపం చేయాలనే ఉద్దేశం లేకుండా చేయకూడదని యెహోవా ఆజ్ఞాపించిన వాటిని పాపం చేయాలని కాకుండా పొరపాటున చేస్తే దోషి అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","తరువాత తాను చేసిన పాపం అతనికి తెలిస్తే అప్పుడు అతడు ఒక మగ మేకని తన అర్పణగా తీసుకురావాలి. అది లోపం లేనిదిగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","అతడు ఆ మేక తలపై చెయ్యి ఉంచి దాన్ని యెహోవా సమక్షంలో దహనబలి అర్పించే చోట వధించాలి. ఇది పాపం కోసం చేసే బలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","పాపం కోసం వధించిన దాని రక్తాన్ని యాజకుడు వేలితో తీసుకుని దహన బలిపీఠం పైని కొమ్ములకు పూయాలి. మిగిలిన రక్తాన్ని దహన బలిపీఠం అడుగు భాగంలో పారబోయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","దాని కొవ్వునంతా వేదిక పైన దహించాలి. శాంతిబలికి అర్పించిన పశువు కొవ్వును చేసినట్టుగానే చేయాలి. ఇలా యాజకుడు ఆ అధికారి పాపం విషయంలో పరిహారం చేయాలి. అప్పుడు ఆ అధికారికి క్షమాపణ కలుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","సామాన్య ప్రజల్లో ఎవరైనా ఒకరు పాపం చేయాలనే ఉద్దేశం లేకుండా చేయకూడదని యెహోవా ఆజ్ఞాపించిన వాటిని పాపం చేయాలని కాకుండా పొరపాటున చేస్తే దోషి అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","తరువాత తాను చేసిన పాపం అతనికి తెలిస్తే అప్పుడు అతడు ఒక ఆడ మేకను బలి అర్పణగా తీసుకుని రావాలి. ఆ మేక లోపం లేనిదై ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","పాపం కోసం బలి కాబోయే పశువు తలపైన అతడు తన చేతులుంచాలి. తరువాత దాన్ని దహనబలి అర్పించే చోట వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","దాని రక్తాన్ని యాజకుడు వేలితో తీసుకుని దహన బలిపీఠం పైని కొమ్ములకు పూయాలి. మిగిలిన రక్తాన్ని దహన బలిపీఠం అడుగు భాగంలో పారబోయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","తరువాత శాంతిబలి పశువు కొవ్వును వేరు చేసినట్టే దీని కొవ్వు అంతా తీయాలి. యాజకుడు ఆ కొవ్వును యెహోవాకు కమ్మని సువాసనగా బలిపీఠం పైన దహించాలి. ఈ విధంగా యాజకుడు ఆ వ్యక్తి కోసం పరిహారం చేస్తాడు. అప్పుడు ఆ వ్యక్తికి క్షమాపణ కలుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ఎవరైనా ఒక వ్యక్తి పాపం కోసం బలి అర్పణగా లోపం లేని ఒక ఆడగొర్రెను తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","అతడు పాపం కోసం బలి అర్పణ కాబోయే దాని తలపై తన చెయ్యి ఉంచాలి. తరువాత దాన్ని దహనబలి అర్పించే చోట వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","అప్పుడు దాని రక్తాన్ని యాజకుడు వేలితో తీసుకుని దహన బలిపీఠం పైని కొమ్ములకు పూయాలి. మిగిలిన రక్తాన్ని దహన బలిపీఠం అడుగు భాగంలో పారబోయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","తరువాత శాంతిబలి పశువు క్రొవ్వుని వేరు చేసినట్టే దీని కొవ్వు అంతా తీయాలి. యాజకుడు యెహోవాకు దహనబలి అర్పించే చోట బలిపీఠం పైన దాన్ని దహించాలి. ఈ విధంగా యాజకుడు ఆ వ్యక్తి పాపం కోసం పరిహారం చేస్తాడు. అప్పుడు ఆ వ్యక్తికి క్షమాపణ కలుగుతుంది.” ");
INSERT INTO tel2017_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ఒక వ్యక్తి తాను చూసిన దాన్ని గానీ, విన్న దాన్ని గానీ సాక్ష్యం చెప్పాల్సిన అవసరం వచ్చినప్పుడు సాక్ష్యం చెప్పకుండా పాపం చేస్తే దానికి ఆ వ్యక్తే బాధ్యత వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ఇంకా ఒక వ్యక్తి దేవుడు అపవిత్రమని నిర్దేశించిన ఏ అశుద్ధ జంతువు కళేబరాన్ని గానీ, పశువు కళేబరాన్ని గానీ, పాకే జంతు కళేబరాన్ని గానీ తెలియక తాకితే ఆ వ్యక్తి అపవిత్రుడూ, అపరాధీ అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ఒక వ్యక్తిని అపవిత్రం చేసిన వాటిని అది ఏదైనా సరే, తాకిన వ్యక్తి ఆ అపవిత్రతను తాకానని తెలుసుకున్న తరువాత అపరాధి అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","అలాగే ఎవరైనా తెలియకుండా తొందరపడి మంచైనా, చెడైనా చేస్తానని ఒట్టు పెట్టి ప్రమాణం చేసినా, తెలియకుండా తొందరపడి ఏదైనా చేస్తానని ఒట్టు పెట్టి ప్రమాణం చేసినా ఆ తరువాత తెలుసుకుని చేయకుండా ఉంటే ఆ విషయంలో అతడు అపరాధి అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","వీటిలో ఏ విషయంలోనైనా అతడు అపరాధి అయితే తాను ఎలాంటి పాపం చేశాడో దాన్ని ఒప్పుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","తాను చేసిన అపరాధం కోసం బలి అర్పణను యెహోవా సమక్షంలోకి తీసుకురావాలి. దానికోసం తన మందలోనుండి ఆడమేకనైనా, ఆడగొర్రెనైనా పాపం కోసం బలిగా అర్పించాలి. అతని పాపం కోసం యాజకుడు పరిహారం చేస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","ఒకవేళ అతనికి గొర్రెని తెచ్చే స్తోమత లేకపోతే తన పాపం కోసం అపరాధ బలి అర్పణగా రెండు గువ్వలను గానీ, రెండు పావురం పిల్లలను గానీ తీసుకు రావచ్చు. వాటిలో ఒకటి పాపం కోసం చేసే అర్పణ, మరొకటి దహనబలి కోసం. ");
INSERT INTO tel2017_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","అతడు వాటిని యాజకుడి దగ్గరికి తీసుకురావాలి. యాజకుడు మొదట ఒకదాన్ని పాపం కోసం బలిగా అర్పిస్తాడు. అతడు దాని తలను తుంచి వేస్తాడు కానీ పూర్తిగా వేరు చేయడు. ");
INSERT INTO tel2017_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","అతడు కొంత రక్తాన్ని బలిపీఠం పక్కన చిలకరించాలి. మిగిలిన రక్తాన్ని బలిపీఠం అడుగున కుమ్మరించాలి. ఇది పాపం కోసం చేసే బలి. ");
INSERT INTO tel2017_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","తరువాత ఆదేశాల్లో చెప్పినట్టు రెండో పక్షిని దహనబలిగా అర్పించాలి. అతడు చేసిన పాపం కోసం యాజకుడు పరిహారం చేస్తాడు. అప్పుడు అతనికి క్షమాపణ కలుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ఒకవేళ అతనికి రెండు గువ్వలను, రెండు పావురం పిల్లలను కొని తెచ్చే స్తోమతు లేకపోతే, అతడు తన పాపం కోసం అర్పణగా ఒక కిలో సన్నని గోదుమ పిండిని తీసుకురావాలి. అది పాపం కోసం చేసే అర్పణ కాబట్టి దాని మీద నూనె పోయకూడదు, ఎలాంటి సాంబ్రాణి వేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","అతడు యాజకుని దగ్గరికి దాన్ని తీసుకురావాలి. అప్పుడు యాజకుడు యెహోవా మంచితనం గూర్చి కృతజ్ఞతాపూర్వకంగా జ్ఞాపకం చేసుకోడానికి దానిలో నుండి ఒక గుప్పెడు స్మృతి చిహ్నంగా తీసి యెహోవాకి దహనబలి అర్పించే చోట దహించాలి. అది పాపం కోసం చేసే బలి అర్పణ. ");
INSERT INTO tel2017_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","పైన చెప్పిన వాటిలో అతడు చేసిన పాపాన్ని యాజకుడు కప్పివేస్తాడు. అప్పుడు అతనికి క్షమాపణ కలుగుతుంది. నైవేద్యం అర్పణలో మిగిలినది యాజకునికి చెందినట్టుగా ఇక్కడ కూడా అర్పణ చేయగా మిగిలినది యాజకునికి చెందుతుంది.” ");
INSERT INTO tel2017_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","తరువాత యెహోవా మోషేకు ఇంకా ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ఒక వ్యక్తి యెహోవాకు అర్పితమైన వాటిని ముందు పొరపాటుగా ఆయనకు చెల్లించకుండా తెలియక ఆజ్ఞను అతిక్రమించి పాపం చేస్తే, అప్పుడు అతడు తన అపరాధ బలి అర్పణను యెహోవా దగ్గరికి తీసుకు రావాలి. అతడు తన అపరాధ బలిగా మందలో నుండి లోపం లేని పొట్టేలును తీసుకురావాలి. ఆ పొట్టేలు విలువను ప్రత్యక్ష గుడారంలో చెలామణీ అయ్యే వెండితో నిర్ణయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","పరిశుద్ధమైన వస్తువు విషయంలో తాను చేసిన తప్పుకు నష్ట పరిహారం చెల్లించాలి. దానికి ఐదో వంతు చేర్చి దాన్ని యాజకుడికి ఇవ్వాలి. అప్పుడు యాజకుడు అపరాధ బలి అర్పణ అయిన పొట్టేలుతో అతని కోసం పరిహారం చేస్తాడు. అప్పుడు ఆ వ్యక్తికి క్షమాపణ కలుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ఎవరైనా చేయకూడదని యెహోవా ఆజ్ఞాపించిన దాన్ని చేసి పాపం చేస్తే, అది పొరపాటుగా చేసినా అపరాధి అవుతాడు. దానికి శిక్ష పొందుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","అతడు తన అపరాధ బలి అర్పణగా మందలో నుండి లోపం లేని పొట్టేలును తీసుకు రావాలి. దాని ప్రస్తుత వెల నిర్ణయం జరగాలి. దాన్ని అపరాధ బలి అర్పణగా యాజకుడి దగ్గరికి తీసుకురావాలి. అప్పుడు యాజకుడు పొరపాటుగా ఆ వ్యక్తి చేసిన పాపం కోసం పరిహారం చేస్తాడు. అప్పుడు అతనికి క్షమాపణ కలుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","అది అపరాధబలి. అతడు నిజంగానే యెహోవా ఎదుట దోషి అయ్యాడు.” ");
INSERT INTO tel2017_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","యెహోవా మోషేతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ఒక వ్యక్తి తన పొరుగున ఉన్నవాడు తనకు అప్పగించిన దాని విషయంలో అతణ్ణి మోసం చేసినా, వంచించినా, దోచుకున్నా, లేక తన పొరుగున ఉన్నవాణ్ణి పీడించినా ");
INSERT INTO tel2017_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","అతడు పోగొట్టుకున్న వస్తువు తనకు దొరికినా దాని విషయం అబద్ధం చెప్పినా, ఒట్టు పెట్టి మరీ అబద్ధం చెప్పినా, ఇంకా ఇలాంటి విషయాల్లో పాపం చేస్తే అది యెహోవాకి వ్యతిరేకంగా ఆయన ఆజ్ఞలను ఉల్లంఘించి చేసిన పాపం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ఇలా పాపం చేసినవాడు అపరాధి. కాబట్టి అలాంటివాడు తను ఇతరుల దగ్గర దోచుకున్నదీ, పీడించి సంపాదించిందీ, లేక తనకు అప్పగించినదీ, తనకు దొరికినదీ తిరిగి ఇచ్చివేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","తాను దేని గురించైతే అబద్ధ ప్రమాణం చేసాడో దాన్ని పూర్తిగా చెల్లించాలి. ఇంకా అది ఎవరికి చెందుతుందో వారికి దానిలో ఐదో వంతు తప్పక చెల్లించాలి. దాన్ని అపరాధ బలి అర్పించే రోజున చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","తరువాత అతడు తన అపరాధబలి అర్పణను యెహోవా దగ్గరికి తీసుకుని రావాలి. అపరాధబలిగా మందలోని లోపం లేని పోట్టేలును యాజకుడి దగ్గరికి తీసుకుని రావాలి. దాని విలువను ప్రస్తుత వెల ప్రకారం నిర్థారించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","యాజకుడు యెహోవా సమక్షంలో అతని పాపం కోసం పరిహారం చేస్తాడు. అప్పుడు అతడు ఏ ఏ విషయాల్లో అపరాధి అయ్యాడో ఆ విషయాల్లో క్షమాపణ పొందుతాడు.” ");
INSERT INTO tel2017_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ఇంకా యెహోవా మోషేతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“నువ్వు అహరోనుకీ, అతని కొడుకులకీ ఇలా ఆదేశించు, ఇది దహనబలికి సంబంధించిన చట్టం. దహనబలి అర్పణ బలిపీఠం పైన నిప్పులపై రాత్రంతా, తెల్లవారే వరకూ ఉండాలి. బలిపీఠం పైన అగ్ని మండుతూనే ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","యాజకుడు నారతో చేసిన బట్టలు వేసుకోవాలి. అతని లోదుస్తులు కూడా నారతో చేసినవే అయి ఉండాలి. అతడు దహనబలి అర్పణ పూర్తిగా కాలిపోయిన తరువాత బూడిద తీసి బలిపీఠం పక్కనే ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","తరువాత అతడు తన బట్టలు మార్చుకుని శిబిరం బయట ఉన్న పవిత్ర స్థలానికి ఆ బూడిద తీసుకు వెళ్ళాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","బలిపీఠం పైన అగ్ని మండుతూనే ఉండాలి. అది ఆరిపోకూడదు. ప్రతి ఉదయం యాజకుడు దాని పైన కట్టెలు వేస్తూ ఉండాలి. దాని పైన దహనబలి అర్పణని ఉంచాలి. శాంతిబలి పశువు కొవ్వును దాని పైన దహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","బలిపీఠం పైన అగ్ని ఎప్పటికీ మండుతూనే ఉండాలి. అది ఆరిపోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ఇక నైవేద్య అర్పణ గూర్చిన చట్టం ఇది. దీన్ని అహరోను కొడుకులు యెహోవా సమక్షంలో బలిపీఠం ఎదుట అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","యాజకుడు నైవేద్య అర్పణ నుండి గుప్పెడు పిండినీ, కొంత నూనెనూ, దాని పైనున్న సాంబ్రాణినూ తీసి వాటిని యెహోవా మంచితనాన్ని స్మరించుకోడానికి బలిపీఠం పైన దహించాలి. అది ఆయనకు కమ్మని సువాసనను కలుగజేస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","అర్పించగా మిగిలిన దాన్ని అహరోనూ, అతని కుమారులూ భుజించాలి. పరిశుద్ధ స్థలం లో దాన్ని తినాలి. పొంగజేసే పదార్ధం లేకుండా దాన్ని తినాలి. ప్రత్యక్ష గుడారం ఆవరణలో దాన్ని తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","దాని తయారీలో పొంగజేసే పదార్ధం కలపకూడదు. నాకు అర్పించే దహనబలుల్లో వాళ్ళ భాగంగా దాన్ని నేను ఇచ్చాను. పాపం కోసం చేసే బలి అర్పణగానూ, అపరాధం కోసం చేసే బలి అర్పణ గానూ ఇచ్చాను. అది అతి పరిశుద్ధం. ");
INSERT INTO tel2017_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","మీ రాబోయే అన్ని తరాల్లోనూ అహరోను వారసుడైన ప్రతివాడూ యెహోవాకు దహనబలిగా అర్పించిన దానిలోనుండి దాన్ని తన భాగంగా భావించి తిన వచ్చు. వాటికి తగిలిన ప్రతిదీ పవిత్రం అవుతుంది.” ");
INSERT INTO tel2017_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ఇంకా యెహోవా మోషేతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“అహరోనుకూ, అతని కొడుకులకూ ఒక్కొక్కరికీ అభిషేకం జరిగిన రోజున వాళ్ళు చెల్లించాల్సిన అర్పణ ఇది. మామూలు నైవేద్య అర్పణలాగే వాళ్ళు సుమారు ఒక కిలో సన్నని గోదుమ పిండిని ఉదయం సగం, సాయంత్రం సగం అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","దాన్ని నూనెతో పెనం పైన కాల్చాలి. అది చక్కగా కాలిన తరువాత తీసుకురావాలి. దాన్ని ముక్కలు చేసి యెహోవాకు కమ్మని సువాసనగా నైవేద్య అర్పణ చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","యాజకుని కొడుకుల్లో, అభిషేకం పొంది అతడి స్థానంలో కొత్తగా యాజకుడైన వ్యక్తి అలాగే అర్పించాలి. ఆజ్ఞ ప్రకారం దాన్ని యెహోవా కోసం పూర్తిగా దహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","యాజకుడు అర్పించే ప్రతి నైవేద్యాన్నూ పూర్తిగా దహించాలి. దాన్ని తినకూడదు.” ");
INSERT INTO tel2017_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ఇంకా యెహోవా మోషేతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“నువ్వు అహరోనుతోనూ, అతని కొడుకులతోనూ మాట్లాడి ఇలా చెప్పు, పాపం కోసం చేసే అర్పణ చట్టం ఇది. దహనబలి అర్పణ పశువుని వధించిన చోటే పాపం కోసం చేసే బలి అర్పణ పశువునూ యెహోవా సమక్షంలో వధించాలి. అది అతి పరిశుద్ధం. ");
INSERT INTO tel2017_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ప్రత్యక్ష గుడారం ఆవరణలోని పరిశుద్ధ స్థలం లో దాన్ని తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","దాని మాంసానికి తగిలిన ప్రతిదీ పరిశుద్ధం అవుతుంది. దాని రక్తం బట్టల పైన చిందితే రక్తం చిమ్మిన ప్రాంతాన్ని పరిశుద్ధ స్థలం లో శుభ్రం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","దాన్ని మట్టి కుండలో ఉడకబెడితే, ఆ కుండని పగలగొట్టాలి. ఒకవేళ ఇత్తడి పాత్రలో ఉడకబెడితే దాన్ని తోమి నీళ్ళతో శుభ్రం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","అది అతి పరిశుద్ధమైనది కాబట్టి యాజకుడి కుటుంబంలో ప్రతి మగవాడూ దాన్ని కొంచెం తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","కానీ పాపం కోసమైన బలి అర్పణ చేసిన పశువు రక్తం పరిహారం కోసం ప్రత్యక్ష గుడారం లోకి తీసుకు రావడం జరిగితే, ఆ పశువు మాంసం తినకూడదు. దాన్ని పూర్తిగా కాల్చి వేయాలి.” ");
INSERT INTO tel2017_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“అపరాధం కోసం చేసే బలి అర్పణ సంగతులు. అది ఎంతో పరిశుద్ధం. ");
INSERT INTO tel2017_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","దహనబలి కోసం పశువులను వధించే స్థలం లోనే అపరాధబలి పశువులను కూడా వధించాలి. దాని రక్తాన్ని బలిపీఠం చుట్టూ అన్ని వైపులా చిమ్మాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","దాని కొవ్వు పట్టిన తోకనూ, దాని అంతర్భాగాల్లోని కొవ్వునూ, ");
INSERT INTO tel2017_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","రెండు మూత్ర పిండాలనూ, వాటి పైని కొవ్వునూ, కాలేయం పైన పేరుకున్న కొవ్వునూ, ఇలా దానిలోని కొవ్వు అంతటినీ తీసి అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","యాజకుడు యెహోవాకి దహనబలిగా వీటిని బలిపీఠం పైన దహించాలి. అది అపరాధం కోసం చేసే బలి. యాజకుడి కుటుంబంలో ప్రతి మగవాడూ దీన్ని తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ఇది అతి పరిశుద్ధం. కాబట్టి పరిశుద్ధ స్థలం లోనే దీన్ని తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","పాపం కోసం చేసే బలి అపరాధం కోసం చేసే బలిలానే ఉంటుంది. ఈ రెంటికీ పాటించాల్సిన చట్టం ఒకటే. ఆ బలుల్లో మిగిలిన మాంసం వాటితో పరిహారం చేసే యాజకుడికే దక్కుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","దహనబలి పశువు చర్మం ఆ దహనబలిని అర్పించిన యాజకుడికి చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","పొయ్యి మీద కుండలోనైనా, పెనం మీదనైనా వండిన లేదా కాల్చిన నైవేద్యం అంతా యాజకుడికే చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","అది పొడి నైవేద్యమైనా, నూనె కలిపినది అయినా అదంతా అహరోను సంతానం వాళ్ళు సమానంగా పంచుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","ప్రజలు యెహోవాకు అర్పించే శాంతి బలిని గూర్చిన చట్టం ఇది. ");
INSERT INTO tel2017_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ఎవరైనా కృతఙ్ఞత అర్పణగా దాన్ని అర్పించదలిస్తే దానితో పాటు పొంగజేసే పదార్ధం లేకుండా నూనె కలిపి చేసిన రొట్టెలూ, పొంగజేసే పదార్ధం లేకుండా నూనె రాసి చేసిన అప్పడాలూ, సన్నని పిండిలో నూనె బాగా కలిపి చేసిన రొట్టెలూ అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","వీటితో పాటు కృతజ్ఞతలు చెల్లించడానికి శాంతిబలి అర్పణ సమయంలో పొంగజేసే పదార్ధంతో చేసిన రొట్టెను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ఈ వేరు వేరు అర్పణల్లో నుండి ఒక దాన్ని యెహోవాకి అర్పించాలి. శాంతిబలి కోసం బలిపీఠం పైన రక్తాన్ని చిలకరించిన యాజకునికి అది చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","కృతజ్ఞతలు చెల్లించే ఉద్దేశ్యంతో శాంతిబలిని అర్పించే వ్యక్తి బలిపశువు మాంసాన్ని బలి అర్పించే రోజే తినాలి. దాంట్లో దేన్నీ తరువాత రోజు కోసం ఉంచుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","అయితే మొక్కు చెల్లించడం కోసం గానీ, స్వేచ్ఛార్పణ చెల్లించడం కోసం గానీ బలి ఇస్తే ఆ పశువు మాంసాన్ని బలి అర్పణ రోజే తినాలి. కానీ ఏదన్నా మిగిలితే దాన్ని రెండోరోజు కూడా తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","మూడో రోజుకి ఇంకా మిగిలి ఉన్న మాంసాన్ని కాల్చి వేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ఎవరన్నా శాంతిబలి పశువు మాంసాన్ని ఏ కొంచెమైనా మూడోరోజు కూడా తింటే ఆ బలి అంగీకారానికి నోచుకోదు. ఆ బలి అర్పణ తెచ్చిన వాడి లెక్కలోకి రాదు. అది అసహ్యకరంగా ఉంటుంది. అలా తినేవాడు తన అపరాధాన్ని మోస్తూనే ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","అపవిత్రమైన దానికి తగిలిన మాంసాన్ని తిన కూడదు. దాన్ని కాల్చివేయాలి. మిగిలిన మాంసం పవిత్రులైన వాళ్ళు తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","యెహోవాకు అర్పించే శాంతిబలి పశువు మాంసాన్ని ఎవరైనా అపవిత్రుడిగా ఉండి కొంచెం తిన్నా అలాంటి వాడు ప్రజల్లో లేకుండా పోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","మనుష్యుల అపవిత్రతనైనా, ఏదన్నా జంతువు అపవిత్రతనైనా, లేదా అపవిత్రమైన, అసహ్యకరమైన వస్తువునైనా తాకి దాని తరువాత ఎవరైనా యెహోవాకి అర్పించే శాంతిబలి పశువు మాంసం తింటే అలాంటి వాడు ప్రజల్లో లేకుండా పోవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ఇంకా యెహోవా మోషేతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“నువ్వు ఇశ్రాయేలు ప్రజలకు ఇలా చెప్పు, ఎద్దు కొవ్వును గానీ, గొర్రె కొవ్వును గానీ, మేక కొవ్వును గానీ మీరు తిన కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","అర్పణం కాకుండా సాధారణంగా చనిపోయిన పశువు కొవ్వునూ, అడవి మృగాలు చీల్చి వేసిన పశువు కొవ్వునూ ఇతర విషయాలకు ఉపయోగించవచ్చు గానీ ఎట్టి పరిస్థితుల్లోనూ తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","యెహోవాకి దహనబలిగా ప్రజలు అర్పించే పశువుల కొవ్వుని తినేవాడు ప్రజల్లో లేకుండా పోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","అలాగే పక్షి రక్తం గానీ, జంతువు రక్తం గానీ మీ ఇళ్ళల్లో తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ఎవడు రక్తాన్ని తింటాడో వాడు ప్రజల్లో లేకుండా పోవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ఇంకా యెహోవా మోషేతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“నువ్వు ఇశ్రాయేలు ప్రజలకు ఇలా చెప్పు, యెహోవాకి శాంతిబలి పశువును అర్పించే వాడు దానిలో ఒక భాగాన్ని ప్రత్యేకంగా యెహోవా సమక్షంలోకి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","యెహోవాకు దహనబలిగా అర్పించే వాటిని అతడు స్వయంగా తీసుకు రావాలి. అతడు రొమ్ము భాగాన్నీ, దానితో ఉన్న కొవ్వునీ తీసుకురావాలి. యెహోవా సమక్షంలో అర్పణగా పైకెత్తి కదిలించడానికి రొమ్ము భాగాన్ని తీసుకుని రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","యాజకుడు బలిపీఠం పైన ఆ కొవ్వుని దహించాలి. కానీ రొమ్ము భాగం అహరోనుకీ అతని వారసులకీ చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","శాంతిబలి పశువుల కుడి తొడ భాగాన్ని యాజకుడికి ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","అహరోను వారసుల్లో శాంతిబలి పశువు రక్తాన్నీ, కొవ్వునూ అర్పించే యాజకుడికి ఆ పశువు కుడి తొడ భాగం చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ఎందుకంటే నా ఎదుట పైకి లేపి కదిలించిన రొమ్ము భాగాన్నీ, తొడనూ నేను స్వీకరించాను. వాటిని నేను యాజకుడైన అహరోనుకీ, అతని వారసులకీ ఇచ్చాను. ఇశ్రాయేలు ప్రజలు అర్పించే శాంతి బలులన్నిటిలో ఇవి వారి వంతుగా ఉంటాయి. ఇది నా ప్రజలైన ఇశ్రాయేల్ వారు అనుసరించవలసిన శాశ్వత నియమం. ");
INSERT INTO tel2017_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ఇది యాజకులుగా యెహోవాకి సేవ చేయడానికి వీరిని మోషే నియమించిన రోజు నుండి అహరోనుకూ అతని వారసులకూ యెహోవాకు అర్పించే దహనబలుల్లో ఏర్పాటైన వాటా. ");
INSERT INTO tel2017_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","వారిని యాజకులుగా యెహోవా అభిషేకం చేసిన రోజున వారికి ఇశ్రాయేలు ప్రజలు ఇవ్వాలని యెహోవా ఖాయం చేసిన వాటా. ఇది అన్ని తరాల్లో వారి వాటాగా ఉంటుంది.” ");
INSERT INTO tel2017_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ఇవి దహనబలిని గూర్చీ, అపరాధం కోసం చేసే బలిని గూర్చీ, నైవేద్య అర్పణ బలిని గూర్చీ, పాపం కోసం చేసే బలిని గూర్చీ, ప్రతిష్టార్పణ బలిని గూర్చీ, శాంతిబలిని గూర్చీ వివరించే చట్టం. ");
INSERT INTO tel2017_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ఈ ఆజ్ఞలను యెహోవా సీనాయి పర్వతం పైన మోషేకి ఇచ్చాడు. ఇశ్రాయేలు ప్రజలకు సీనాయి అరణ్యంలో యెహోవాకు అర్పణలు చెల్లించాలని ఆదేశించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","యెహోవా మోషేకు ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“నువ్వు అహరోనును, అతని కొడుకులను తీసుకు రా. వాళ్ళతో పాటు వాళ్ళ బట్టలూ, అభిషేకం చేయడానికి నూనే, పాపం కోసం బలి అర్పించడానికి ఒక ఎద్దూ, రెండు పొట్టేళ్ళూ, పొంగజేసే పదార్ధం లేకుండా చేసిన ఒక బుట్టెడు రొట్టెలూ తీసుకు రా. ");
INSERT INTO tel2017_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","సమాజంలో ప్రజలందర్నీ ప్రత్యక్ష గుడారం ప్రవేశ ద్వారం దగ్గరికి సమకూర్చు.” ");
INSERT INTO tel2017_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","మోషే యెహోవా తనకు ఆదేశించినట్టుగా చేశాడు. సమాజంలో ప్రజలందరూ ప్రత్యక్ష గుడారం ప్రవేశ ద్వారం దగ్గరికి చేరుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","అప్పుడు మోషే వాళ్ళందరితో “ఇలా చేయమని యెహోవా ఆజ్ఞాపించాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","తరువాత మోషే అహరోనునూ, అతని కొడుకులనూ తీసుకు వచ్చి వాళ్లకి స్నానం చేయించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","తరువాత అహరోనుకు చొక్కా తొడిగి, అతనికి నడికట్టు కట్టాడు. అంగీ ధరింపజేసి ఏఫోదుని వేశాడు. అందంగా అల్లిన నడికట్టుని ఏఫోదు పైగా వేసి బిగించి కట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","అతనికి వక్షపతకం కట్టి దానిలో ఊరీమును, తుమ్మీమును ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","అతనికి తలపాగా పెట్టాడు. ఆ పాగా ముందు భాగంలో పరిశుద్ధ కిరీటంలా బంగారు రేకుని ఉంచాడు. యెహోవా తనకు ఆజ్ఞాపించినట్లుగా మోషే ఇదంతా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","తరువాత మోషే అభిషేకం చేయడానికి నూనె తీసుకున్నాడు. దానితో మందిరాన్నీ, మందిరంలో ఉన్న సమస్తాన్నీ అభిషేకించి వాటినన్నిటినీ శుద్ధీకరణం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","తరువాత ఆ నూనెలో కొంత బలిపీఠంపై ఏడుసార్లు చిలకరించాడు. బలిపీఠం దానికి సంబంధించిన పాత్రలను, గంగాళాన్నీ, దాని పీటనూ శుద్ధీకరణం చేసి వాటిని అభిషేకించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","తరువాత అతడు ఆ అభిషేకం చేసే నూనెలో కొంత తీసి అహరోనుని ప్రతిష్టించడానికి అతని తల పైన పోసి అభిషేకించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","తరువాత మోషే యెహోవా తనకు ఆదేశించిన విధంగా అహరోను కొడుకులను తీసుకు వచ్చి వారికి పొడవాటి చొక్కాలు వేశాడు. వారికి నడికట్లు కట్టి, వారి తలల చుట్టూ నార బట్టలు కట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ఆ తరువాత మోషే పాపం కోసం బలి అర్పణ చేయడానికి ఒక కోడెదూడని తీసుకు వచ్చాడు. అహరోనూ అతని కొడుకులూ పాపం కోసం బలి అర్పణ కాబోతున్న ఆ కోడె దూడ తలపై తమ చేతులుంచారు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","మోషే దాన్ని వధించాడు. దాని రక్తాన్ని తీసి తన వేలితో బలిపీఠం కొమ్ములకి పూసి బలిపీఠాన్ని శుద్ధీకరించాడు. మిగిలిన రక్తాన్ని బలిపీఠం అడుగు భాగంలో కుమ్మరించాడు. మోషే దాని కోసం పరిహారం చేసి దాన్ని ప్రతిష్టించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","అప్పుడు మోషే దాని లోపలి భాగాలపై ఉన్న కొవ్వునంతా తీసి వేరు చేశాడు. కాలేయం పైనున్న కొవ్వును తీశాడు. మూత్రపిండాలనూ వాటిపైని కొవ్వునూ తీసి అంతా బలిపీఠంపై దహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","అయితే యెహోవా తనకు ఆజ్ఞాపించినట్టుగా మోషే ఆ కోడె దూడనూ, దాని చర్మాన్నీ, మాంసాన్నీ, పేడనూ శిబిరం బయట పూర్తిగా కాల్చివేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ఆ తరువాత మోషే దహనబలిగా ఒక పొట్టేలును తీసుకు వచ్చాడు. అహరోనూ, అతని కొడుకులూ ఆ పొట్టేలు తలపైన తమ చేతులుంచారు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","అప్పుడు మోషే దాన్ని వధించిన తరువాత దాని రక్తాన్ని బలిపీఠం చుట్టూ చల్లాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","అతడు ఆ పొట్టేలును ముక్కలుగా చేసాడు. దాని తలనూ, ఆ ముక్కలనూ, కొవ్వునూ దహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","అతడు దాని లోపలి భాగాలనూ, కాళ్ళనూ నీళ్ళతో కడిగి ఆ మొత్తం పొట్టేలును బలిపీఠంపై దహించాడు. అది దహనబలి. కమ్మటి సువాసనను అది కలగజేసింది. అది యెహోవా మోషేకి ఆజ్ఞాపించినట్టు అగ్నితో యెహోవాకు చేసిన బలి. ");
INSERT INTO tel2017_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ఆ తరువాత మోషే రెండో పొట్టేలుని తీసుకు వచ్చాడు. ఇది అహరోనుని సేవకై ప్రతిష్టించడం కోసం. ప్రతిష్ట కోసమైన ఈ పొట్టేలు తల పైన అహరోనూ, అతని కొడుకులూ తమ చేతులుంచారు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","మోషే దాన్ని వధించి దాని రక్తంలో కొంత తీసి, అహరోను కుడి చెవి తమ్మె పైనా, కుడిచేతి బొటన వేలి పైనా, కుడికాలి బొటన వేలి పైనా పూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","మోషే అహరోను కొడుకులను కూడా తీసుకు వచ్చి కొంత రక్తాన్ని వారి కుడి చెవి తమ్మెల పైనా, కుడి చేతుల బొటనవేళ్ళ పైనా, కుడి కాళ్ళ బొటన వేళ్ళ పైనా పూసాడు. తరువాత మిగిలిన రక్తాన్ని బలిపీఠంకి అన్ని వైపులా చిమ్మాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","తరువాత మోషే దాని కొవ్వునూ, కొవ్వు పట్టిన దాని తోకనూ, దాని అంతర్భాగాల పైని కొవ్వునూ, కాలేయం పైని కొవ్వునూ, రెండు మూత్ర పిండాలనూ, వాటి పైని కొవ్వునూ, కుడి తొడ భాగాన్నీ వేరు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","యెహోవా సమక్షంలో పొంగజేసే పదార్ధం లేకుండా చేసిన రొట్టెలతో ఉన్న బుట్టలో నుండి ఒక రొట్టెనూ, నూనె రాసి చేసిన ఒక రొట్టెనూ, ఒక అప్పడాన్నీ తీసి వాటిని కొవ్వు పైనా, కుడి తొడ భాగం పైనా పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","వాటిని అహరోను చేతుల్లోనూ, అతని కొడుకుల చేతుల్లోనూ ఉంచి వాటిని యెహోవా సన్నిధిలో అర్పణగా పైకి ఎత్తి అటూఇటూ కదిలించి చూపాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","తరువాత మోషే వాటిని వాళ్ళ చేతుల నుంచి తీసుకుని దహనబలిగా బలిపీఠం పైన దహించాడు. అవి ప్రతిష్టార్పణలు. అవి కమ్మటి సువాసన కలుగజేసాయి. అది యెహోవాకు అర్పించిన దహనబలి. ");
INSERT INTO tel2017_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","తరువాత మోషే దాని రొమ్ము భాగాన్ని తీసుకుని దాన్ని కదలిక అర్పణగా యెహోవా సమక్షంలో పైకెత్తి కదిలించాడు. యాజకుణ్ణి ప్రతిష్టించే పనిలో యెహోవా మోషేకు ఆజ్ఞాపించినట్టు పొట్టేలులో అది మోషే వంతు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","తరువాత మోషే అభిషేకానికి ఉపయోగించే నూనెలో కొంత, బలిపీఠం పైని రక్తంలో కొంత తీసుకుని వాటిని అహరోను పైనా అతని బట్టల పైనా, అతని కొడుకుల పైనా, వాళ్ళ బట్టల పైనా చిలకరించాడు. ఆ విధంగా మోషే అహరోనునూ, అతని బట్టలనూ, అతని కొడుకులనూ, వాళ్ళ బట్టలనూ అభిషేకించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ఆ తరువాత మోషే అహరోనుతోనూ, అతని కొడుకులతోనూ ఇలా చెప్పాడు. “ప్రత్యక్ష గుడారం ప్రవేశ ద్వారం దగ్గర ఆ మాంసాన్ని వండండి. దాన్నీ, బుట్టలో సేవా ప్రతిష్ట కోసం ఉంచిన రొట్టెనూ మీరు తినాలి. అహరోనూ, అతని కొడుకులూ దాన్ని తినాలి అని నేను ఆజ్ఞాపించినట్టు మీరు వాటిని తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","మీరు తినగా మిగిలిన మాంసాన్నీ, రొట్టెనూ కాల్చివేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","మీ ప్రతిష్ఠ రోజులు ముగిసే వరకూ అంటే ఏడు రోజులు మీరు ప్రత్యక్ష గుడారం ప్రవేశ ద్వారం నుండి బయటకు వెళ్ళకూడదు. ఆ ఏడు రోజులూ యెహోవా మిమ్మల్ని ప్రతిష్ట చేస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ఈ రోజు ఎలా జరిగిందో మీ కోసం పరిహారం చేయడానికి అలాగే జరగాలని యెహోవా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","మీరు ప్రత్యక్ష గుడారం ద్వారం దగ్గర ఏడు రోజులు రాత్రింబగళ్ళు నిలిచి యెహోవా ఆజ్ఞలను పాటిస్తూ ఉండాలి. ఎందుకంటే యెహోవా నాకు అలా ఆజ్ఞ ఇచ్చాడు.” ");
INSERT INTO tel2017_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","కాబట్టి యెహోవా మోషే ద్వారా ఆజ్ఞాపించినవన్నీ అహరోనూ, అతని కొడుకులూ చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ఎనిమిదో రోజు మోషే అహరోనునూ, అతని కొడుకులనూ, ఇశ్రాయేలు ప్రజల్లో పెద్దలనూ పిలిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","అహరోనుతో ఇలా అన్నాడు. “పాపం కోసం బలి అర్పణగా మందలో నుండి లోపం లేని ఒక దూడనీ, దహనబలి కోసం లోపం లేని ఒక పొట్టేలునూ యెహోవా సమక్షంలోకి తీసుకు రా. ");
INSERT INTO tel2017_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","నువ్వు ఇశ్రాయేలు ప్రజలతో మాట్లాడి ఇలా చెప్పాలి. యెహోవాకి అర్పించడానికి పాపం కోసం బలిగా లోపం లేని మేకపోతునూ, దహనబలి కోసం ఒక్క సంవత్సరం వయసున్న లోపం లేని ఒక దూడనూ, ఒక గొర్రెపిల్లనూ, తీసుకు రండి. ");
INSERT INTO tel2017_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","అలాగే యెహోవాకి శాంతిబలి అర్పించడానికి ఒక ఎద్దునూ, ఒక పొట్టేలునూ, నూనె కలిపిన నైవేద్యాన్నీ తీసుకు రండి. ఎందుకంటే ఈ రోజు మీకు యెహోవా దర్శనమిస్తాడు” ");
INSERT INTO tel2017_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","కాబట్టి వాళ్ళు మోషే ఆజ్ఞాపించిన వాటన్నిటినీ ప్రత్యక్ష గుడారం దగ్గరికి తీసుకు వచ్చారు. ఇశ్రాయేలు సమాజమంతా వచ్చి యెహోవా సమక్షంలో నిల్చున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","అప్పుడు మోషే ఇలా అన్నాడు. “యెహోవా మీకు ఆజ్ఞాపించింది ఇదే. మీరిది చేస్తే ఆయన తేజస్సు మీకు కనిపిస్తుంది.” ");
INSERT INTO tel2017_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","తరువాత మోషే అహరోనుకి ఇలా చెప్పాడు. “బలిపీఠం దగ్గరికి రా, యెహోవా ఆజ్ఞాపించినట్టు నీ పాపం కోసం అర్పించాల్సిన బలినీ, నీ కోసం దహనబలినీ అర్పించి నీ కోసం, ప్రజల కోసం పరిహారం చెయ్యి. ప్రజల కోసం బలి అర్పించి వాళ్ళ కోసం పరిహారం చెయ్యి.” ");
INSERT INTO tel2017_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","కాబట్టి అహరోను బలిపీఠం దగ్గరికి వెళ్ళాడు. తన పాపాల కోసం బలి అర్పణగా దూడను వధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","అతని కొడుకులు దాని రక్తాన్ని అతని దగ్గరికి తీసుకు వచ్చారు. అహరోను ఆ రక్తంలో తన వేలు ముంచి బలిపీఠపు కొమ్ముల పైన పూశాడు. మిగిలిన రక్తాన్ని బలిపీఠం అడుగు భాగంలో కుమ్మరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","అయితే యెహోవా మోషేకి ఆజ్ఞాపించినట్టు దహనబలిగా దాని కొవ్వునూ, మూత్రపిండాలనూ, కాలేయం పైన పేరుకున్న కొవ్వునూ, బలిపీఠం పైన దహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","దాని మాంసాన్నీ, చర్మాన్నీ శిబిరం బయట పూర్తిగా కాల్చివేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ఆ తరువాత అహరోను దహనబలి పశువును వధించాడు. అతని కొడుకులు దాని రక్తాన్ని అతనికి అందించారు. ఆ రక్తాన్ని అహరోను బలిపీఠం అన్ని వైపులా చిమ్మాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","తరువాత వాళ్ళు అతనికి దహనబలి పశువును ముక్కలు చేసి ఆ ముక్కలనూ, తలనూ ఇచ్చారు. అతడు వాటిని బలిపీఠం పైన దహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","దాని అంతర్భాగాలనూ, కాళ్ళనూ నీళ్ళతో కడిగి బలిపీఠం పై ఉన్న దహనబలి అర్పణలపై ఉంచి వాటిని కూడా దహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","తరువాత అహరోను ప్రజల కోసం బలి అర్పించాడు. మేకను పట్టుకుని ప్రజల పాపం కోసం బలి అర్పణగా దాన్ని వధించాడు. మొదటి మేకను వధించినట్టుగానే దీన్ని కూడా పాపాల కోసం వధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","తరువాత యెహోవా ఆజ్ఞాపించినట్టుగా దహనబలి జంతువును అర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","దాని తరువాత నైవేద్యాన్ని తెచ్చి దానిలోనుంచి ఒక పిడికెడు తీసి బలిపీఠంపై దాన్ని ఉదయం చెల్లించాల్సిన దహనబలితో పాటు దహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","తరువాత ప్రజల కోసం అర్పించాల్సిన శాంతిబలి అర్పణగా ఎద్దునూ, పోట్టేలునూ వధించాడు. అహరోను కొడుకులు వాటి రక్తాన్ని అతనికి అందించారు. దాన్ని అతడు బలిపీఠం చుట్టూ చిమ్మాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","అయితే వాళ్ళు ఆ ఎద్దు కొవ్వునూ, పొట్టేలు కొవ్వునూ, కొవ్వుపట్టిన తోకనూ, వాటి అంతర్భాగాల్లోని కొవ్వునూ, మూత్రపిండాలనూ, కాలేయం పై అంటి ఉన్న కొవ్వునూ అతని కిచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","వాళ్ళు వీటిని ఆ పశువుల రొమ్ము భాగం పైన ఉంచారు. అప్పుడు అహరోను ఆ కొవ్వును బలిపీఠంపై దహించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","మోషే ఆజ్ఞాపించినట్టు అహరోను రొమ్ము భాగాన్నీ, కుడి తొడ భాగాన్నీ యెహోవా సమక్షంలో పైకెత్తి అర్పణగా ఆయనకు అర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ఆ తరువాత అహరోను పాపం కోసం బలినీ, దహనబలినీ, శాంతిబలినీ అర్పించి, తన చేతులను ప్రజల వైపు ఎత్తి వాళ్ళను దీవించాడు. తరువాత దిగి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","మోషే, అహరోనులు ప్రత్యక్ష గుడారం లోపలికి వెళ్ళారు. తిరిగి వచ్చి ప్రజలను దీవించారు. అప్పుడు యెహోవా మహిమ తేజం ప్రజలందరికీ కన్పించింది. ");
INSERT INTO tel2017_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","యెహోవా సమక్షం లోనుండి అగ్నిజ్వాలలు బయలుదేరి బలిపీఠం పైన ఉన్న దహనబలి సామగ్రినీ, కొవ్వునీ కాల్చి వేశాయి. అది చూసి ప్రజలంతా ఉత్సాహంగా కేకలు పెట్టారు. సాష్టాంగ నమస్కారం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","నాదాబు అబీహులు అహరోను కొడుకులు. వీళ్ళు తమ ధూపం వేసే పాత్రల్లో నిప్పులు ఉంచి వాటిపై ధూప ద్రవ్యాన్ని వేశారు. యెహోవా ఆదేశించని వేరే అగ్నిని ఆయన సమక్షంలోకి తీసుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","దాంతో యెహోవా సమక్షంలో నుండి మంటలు వచ్చి వాళ్ళని కాల్చి వేశాయి. యెహోవా సమక్షంలోనే వాళ్ళు చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","అప్పుడు మోషే అహరోనుతో “నాకు సమీపంగా ఉన్నవారికి నా పవిత్రతని చూపిస్తాను. ప్రజలందరి ముందూ నేను మహిమ పొందుతాను అని యెహోవా చెప్పిన మాటకి అర్థం ఇదే” అన్నాడు. అహరోను ఏమీ మాట్లాడకుండా ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","అప్పుడు మోషే అహరోను బాబాయి ఉజ్జీయేలు కొడుకులు మీషాయేలునూ, ఎల్సాఫానునూ పిలిపించి వాళ్ళకిలా చెప్పాడు. “మీరు ఇక్కడికి రండి. ప్రత్యక్ష గుడారం ఎదుట నుండి మీ సోదరులను శిబిరం బయటకు తీసుకుపొండి.” ");
INSERT INTO tel2017_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","వాళ్ళింకా యాజకుల అంగీలు వేసుకునే ఉన్నారు. అలాగే మోషే ఆదేశించినట్టు వాళ్ళు వచ్చి శిబిరం బయటకు వీళ్ళని మోసుకు వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","అప్పుడు మోషే అహరోనుతో అతని కొడుకులైన ఎలియాజరు, ఈతామారులతో “మీరు చావకుండా ఉండాలన్నా, యెహోవా ఈ సమాజం పైన కోపగించుకోకుండా ఉండాలన్నా మీరు మీ తలల పైని జుట్టు విరబోసుకోకూడదు. మీ బట్టలు చింపుకోకూడదు. అయితే యెహోవా వారిని కాల్చివేసినందుకు వారి కోసం మీ సోదరులు, ఇశ్రాయేలు సమాజమంతా ఏడవవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","యెహోవా అభిషేకపు నూనె మీపైన ఉంది. కాబట్టి మీరు మాత్రం ప్రత్యక్ష గుడారం నుండి బయటకి వెళ్ళకూడదు. ఒకవేళ వెళ్తే మీరు చనిపోతారు” అని చెప్పాడు. వాళ్ళు మోషే మాట ప్రకారం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","తరువాత యెహోవా అహరోనుతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“నువ్వూ నీతో ఉండే నీ కొడుకులూ ప్రత్యక్ష గుడారంలోకి ప్రవేశించే సమయంలో ద్రాక్ష మద్యాన్ని గానీ, ఇంకే మత్తు పానీయాలు గానీ తాగవద్దు. అలా చేస్తే మీరు చనిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","మీ రాబోయే తరాల్లో ఇది మీకు శాశ్వతమైన శాసనం. ప్రతిష్ట చేసిన దాన్ని లౌకికమైన దాని నుండీ, పవిత్రమైన దాన్ని అపవిత్రమైన దాని నుండీ వేరు చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","యెహోవా మోషే ద్వారా ఆదేశించిన శాసనాలను ఇశ్రాయేలు ప్రజలందరికీ మీరు బోధించాలి.” ");
INSERT INTO tel2017_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","అప్పుడు మోషే అహరోనుతోనూ, మిగిలి ఉన్న అతని కొడుకులు ఎలియాజరు ఈతామారులతోనూ మాట్లాడాడు. “యెహోవాకు అర్పించిన దహనబలి నుండి మిగిలిన నైవేద్యాన్ని తీసుకుని పొంగజేసే పదార్ధం లేకుండా దాన్ని తినండి. ఎందుకంటే అది అతి పరిశుద్ధమైంది. ");
INSERT INTO tel2017_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","దాన్ని మీరు ఒక పరిశుద్ధ స్థలం లో తినాలి. ఎందుకంటే యెహోవాకు చేసిన దహనబలి అర్పణల్లో అది నీకూ, నీ కొడుకులకూ రావాల్సిన భాగం. మీకు ఈ సంగతి చెప్పాలనే ఆజ్ఞ నేను పొందాను. ");
INSERT INTO tel2017_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","తరువాత కదలిక అర్పణగా పైకెత్తిన రొమ్ము భాగాన్నీ, యెహోవాకు ప్రతిష్ట చేసిన తొడ భాగాన్నీ దేవుడు అంగీకరించిన ఒక పవిత్రమైన స్థలంలో మీరు తినాలి. వీటినీ నువ్వూ, నీ కొడుకులూ, నీ కూతుళ్ళూ తినాలి. ఎందుకంటే అవి ఇశ్రాయేలు ప్రజలు అర్పించే శాంతిబలుల్లో నీకూ, నీ కొడుకులకూ రావాల్సిన భాగం. ");
INSERT INTO tel2017_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","కదలిక అర్పణగా పైకెత్తిన రొమ్ము భాగాన్నీ, యెహోవాకు ప్రతిష్ట చేసిన తొడ భాగాన్నీ దహనబలిగా అర్పించిన కొవ్వుతో పాటు వాళ్ళు తీసుకురావాలి. వాటిని యెహోవా ఎదుట పైకెత్తి కదిలించే అర్పణగా తీసుకు రావాలి. యెహోవా ఆజ్ఞాపించినట్టు అవి శాశ్వతంగా నీకూ నీ కొడుకులకూ చెందిన భాగం. ఇది ఎప్పటికీ నిలిచి ఉండే చట్టం.” ");
INSERT INTO tel2017_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","అప్పుడు మోషే పాపం కోసం బలి కావాల్సిన మేకను గూర్చి అడిగాడు. కానీ అది అప్పటికే దహనమైపోయిందని తెలుసుకున్నాడు. కాబట్టి అతడు తక్కిన అహరోను కొడుకులు ఎలియాజరు, ఈతామారులపై కోప్పడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“మీరు పాపం కోసం బలి అయిన పశువు మాంసాన్ని పవిత్ర స్థలం లో ఎందుకు తినలేదు? అది అతి పరిశుద్ధం కదా. సమాజం పాపాలను తీసివేయడానికీ, ఆయన ఎదుట పరిహారం చేయడానికీ యెహోవా దాన్ని మీకు ఇచ్చాడు కదా. ");
INSERT INTO tel2017_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","చూడండి, దాని రక్తాన్ని పరిశుద్ధ స్థలం లోకి తీసుకు రాలేదు. నేను ఆజ్ఞాపించినట్టే మీరు దాని మాంసాన్ని పరిశుద్ధ స్థలం లో కచ్చితంగా తినాల్సిందే” అని మందలించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","అప్పుడు అహరోను మోషేతో “చూడు, ఈ రోజు వీళ్ళు పాపం కోసం తమ బలులూ, దహన బలులూ యెహోవా ఎదుట అర్పించారు. అయినా ఈ రోజే నాకు ఈ విపత్తు జరిగింది. పాపం కోసం చేసిన బలిమాంసం నేను తింటే యెహోవా దృష్టికి అది సరైనదవుతుందా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","మోషే ఆ మాట విని ఒప్పుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ఆ తరువాత యెహోవా మోషే అహరోనులతో ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“మీరు ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పండి. భూమి పై ఉన్న జంతువులన్నిటిలో మీరు తినదగ్గవి ఇవి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","చీలిన డెక్కలు ఉండి ఏ జంతువు అయితే నెమరు వేస్తుందో ఆ జంతువుని మీరు ఆహారంగా తీసుకోవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","అయితే జంతువుల్లో కొన్ని నెమరు వేస్తాయి. కొన్నిటికి చీలిన డెక్కలుంటాయి. ఇలాంటి వాటిని మీరు ఆహారంగా తీసుకోకూడదు. ఒంటె లాంటి జంతువులు నెమరు వేస్తాయి. కానీ దానికి చీలిన డెక్కలుండవు. కాబట్టి ఒంటెను మీరు అపవిత్రంగా ఎంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","పొట్టి కుందేలు నెమరు వేస్తుంది, కానీ దానికి చీలిన డెక్కలు లేవు. కాబట్టి దాన్ని కూడా మీరు అపవిత్రంగా ఎంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","అలాగే కుందేలు నెమరు వేస్తుంది. కానీ దానికి చీలిన డెక్కలు లేవు. కాబట్టి దాన్ని కూడా మీరు అపవిత్రంగా ఎంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ఇక పందికి చీలిన డెక్కలు ఉన్నాయి. కానీ అది నెమరు వేయదు కాబట్టి దాన్ని మీరు అపవిత్రంగా ఎంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","వీటి మాంసాన్ని మీరు తినకూడదు. వాటి కళేబరాలను అంటుకోకూడదు. అవి మీకు అపవిత్రం. ");
INSERT INTO tel2017_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","జలచరాల్లో వీటిని తినవచ్చు. సముద్రంలోనైనా, నదిలో నైనా నీటిలో నివసించే అన్ని రకాల జీవుల్లో రెక్కలూ, పొలుసులూ ఉన్న వాటిని మీరు తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","సముద్రంలోనైనా, నదిలో నైనా నీటిలో కదిలే అన్ని రకాల జీవుల్లోనూ, జల జంతువుల్లోనూ రెక్కలూ, పొలుసులూ లేని వాటిని మీరు అసహ్యించుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","అవి మీకు అసహ్యం కాబట్టి వాటి మాంసం మీరు తినకూడదు. వాటి కళేబరాలను అసహ్యించుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","నీళ్లలో దేనికి రెక్కలూ, పొలుసులూ ఉండవో అది మీకు అసహ్యం. ");
INSERT INTO tel2017_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","పక్షుల్లో మీరు అసహ్యించుకోవాల్సినవీ, తినకూడనివీ ఏవంటే, గద్ద, రాబందు, ");
INSERT INTO tel2017_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","గరుడ పక్షి, డేగ జాతిలో ప్రతి పక్షీ, ");
INSERT INTO tel2017_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","కాకి జాతిలోని ప్రతి పక్షీ, ");
INSERT INTO tel2017_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","కొమ్ముల గుడ్లగూబ, తీతువు పిట్ట, సముద్రపు కొంగ, గద్ద జాతిలో అన్ని పక్షులూ. ");
INSERT INTO tel2017_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ఇంకా పైగిడి కంటె, గుడ్లగూబ, సముద్రపు డేగ, ");
INSERT INTO tel2017_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","తెల్ల గుడ్లగూబ, క్షేత గుడ్లగూబ, సముద్రపు రాబందు, ");
INSERT INTO tel2017_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","కొక్కిరాయి, అన్ని రకాల కొంగలు, కుకుడు గువ్వ, గబ్బిలం. ");
INSERT INTO tel2017_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","రెక్కలు ఉండి నాలుగుకాళ్లతో నడిచే జీవులన్నీ మీకు అసహ్యంగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","అయితే రెక్కలు ఉండి నలుగు కాళ్ళతో నడిచే, ఎగరగలిగే జీవులు, నేలపై గంతులు వేయడానికి తొడలు గల పురుగులన్నిటినీ మీరు తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","అన్ని రకాల మిడతలను మీరు తినవచ్చు. ఆకు మిడత, కీచురాయి, గడ్డి మిడత ఇలా అన్ని రకాల మిడతలను మీరు తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","అయితే నాలుగు కాళ్లు గల ఎగిరే తక్కిన జీవులన్నీ మీకు అసహ్యంగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","వీటిలో దేని కళేబరాన్ని అయినా మీరు తాకితే మీరు సాయంత్రం వరకూ అపవిత్రంగా ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ఎవరైనా వాటి కళేబరాల్లో దేన్ని అయినా మోస్తే అలాంటి వాడు తన బట్టలు ఉతుక్కోవాలి. వాడు సాయంకాలం వరకూ అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","రెండు డెక్కలు గల అన్ని జంతువుల్లో డెక్కలు పూర్తిగా చీలకుండా ఉండి నెమరు వేయకుండా ఉన్నవి మీకు అపవిత్రం. వాటి కళేబరాలు మీరు ముట్టుకోకూడదు. అలాటి వాటిని తాకిన వాడు అపవిత్రుడు అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","నాలుగు కాళ్లపై నడిచే జంతువుల్లో ఏవి తమ పంజాపై నడుస్తాయో అవి మీకు అపవిత్రం. వాటి కళేబరాలు ముట్టుకున్న వాడు సాయంకాలం వరకూ అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ఎవరైనా వాటి కళేబరాల్లో దేన్ని అయినా మోస్తే అలాంటి వాడు తన బట్టలు ఉతుక్కోవాలి. వాడు సాయంకాలం వరకూ అపవిత్రంగా ఉంటాడు. ఈ జంతువులు మీకు అపవిత్రమైనవి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","నేలపైన పాకే జంతువుల్లో మీకు అపవిత్రమైనవి ఇవి. ముంగిస, ఎలుక, బల్లి జాతికి చెందిన ప్రతి జీవీ, ");
INSERT INTO tel2017_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","తొండ, ఉడుము, బల్లి, తొండ, చిట్టి ఉడుము, ఊసరవెల్లి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","పాకే జీవులన్నిటిలో ఇవి మీకు అపవిత్రం. ఇవి చచ్చిన తరువాత వీటిని ముట్టుకునేవాడు సాయంకాలం వరకూ అపవిత్రుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ఒకవేళ అవి చనిపోయిన తరువాత వాటి కళేబరాలు దేని పైన పడతాయో అవి చెక్క వస్తువులైనా, వస్త్రంతో చేసినవైనా, చర్మంతో చేసినవైనా, గోనె గుడ్డతో చేసినవైనా అవి అపవిత్రం అవుతాయి. ఆ వస్తువు ఏదైనా, దేనికోసం వాడుతున్నా అపవిత్రం అయినప్పుడు దాన్ని నీళ్ళలో ఉంచాలి. సాయంకాలం వరకూ అది అపవిత్రంగా ఉంటుంది. తరువాత అది పవిత్రం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","వీటిలో ఏ జంతువైనా ఏదైనా మట్టిపాత్ర పైన గానీ, మట్టిపాత్రలో గానీ పడితే, ఆ పాత్రలో ఉన్నది ఏదైనా అపవిత్రం అవుతుంది. అప్పుడు మీరు ఆ మట్టిపాత్రను పగలగొట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","పవిత్రమూ తినదగినదీ అయిన ఏ ఆహారంలోనైనా ఆ అపవిత్రం అయిన ఆ మట్టిపాత్రలోని నీళ్ళు పడితే ఆ ఆహారం అపవిత్రం అవుతుంది. అలాంటి పాత్ర లోంచి ఏ పానీయం తాగినా అది అపవిత్రం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","వాటి కళేబరాల్లో ఏ కొంచెమన్నా దేనిపైనన్నా పడితే అది అపవిత్రం అవుతుంది. అది పొయ్యి అయినా, వంటపాత్ర అయినా దాన్ని ముక్కలుగా పగలగొట్టాలి. అది అపవిత్రం, అది మీకు అపవిత్రంగానే ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","నీళ్ళు చేదుకునే పెద్ద తొట్టిలో గానీ, ఊటలో గానీ అలాంటి కళేబరం పడినా ఆ నీళ్ళు అపవిత్రం కావు. అయితే ఆ నీటిలో పడిన కళేబరాన్ని ఎవరైనా ముట్టుకుంటే వాళ్ళు అపవిత్రం అవుతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ఆ కళేబరాల్లో ఏదో ఒక భాగం నాటేందుకు సిద్ధంగా ఉన్న విత్తనాలపై పడినా ఆ విత్తనాలు అపవిత్రం కావు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","కానీ నానబెట్టిన విత్తనాలపైన అపవిత్రమైన కళేబరం పడితే అవి మీకు అపవిత్రం అవుతాయి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","మీరు తిన దగ్గ జంతువుల్లో ఏదన్నా చస్తే దాని కళేబరాన్ని ముట్టుకునే వాడు ఆ సాయంత్రం వరకూ అపవిత్రుడిగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ఆ కళేబరములోనుండి దేనినైనా తినేవాడు తన బట్టలు ఉతుక్కోవాలి. అతడు సాయంత్రం వరకూ అపవిత్రుడిగా ఉంటాడు. దాని కళేబరాన్ని మోసేవాడు తన బట్టలు ఉతుక్కోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","నేలమీద పాకే జీవులన్నీ అసహ్యం. వాటిని మీరు తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","నేలపై పాకే అన్ని జంతువులు, అంటే తమ పొట్టతో పాకే జీవులైనా, నాలుగు కాళ్ళపై నడిచేవైనా, అనేకమైన కాళ్ళు ఉన్నవైనా ఇవన్నీ మీరు తినకూడదు. ఇవి మీకు అసహ్యంగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ఇలా పాకే జీవులను తిని మిమ్మల్ని మీరు అపవిత్రం చేసుకోకూడదు. వాటి ద్వారా మీరు అపవిత్రం కాకూడదు. అశుద్ధం కాకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ఎందుకంటే నేను యెహోవాని. మీ దేవుణ్ణి. నేను పరిశుద్ధుణ్ణి. కాబట్టి మీరు కూడా పరిశుద్ధంగా ఉండేలా శుద్ధీకరణ చేసుకోండి. నేలపైన పాకే జీవుల మూలంగా మిమ్మల్ని మీరు మలినం చేసుకోవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","మీకు దేవుడిగా ఉండటానికి మిమ్మల్ని ఐగుప్తుదేశంలో నుండి బయటకు తీసుకు వచ్చిన యెహోవాను నేను. కాబట్టి మీరు పరిశుద్ధులుగా ఉండాలి. ఎందుకంటే నేను పరిశుద్ధుణ్ణి.” ");
INSERT INTO tel2017_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","ఇది జంతువులూ, పక్షులూ, నీళ్ళలో నివసించే ప్రాణులూ, నేలపైన పాకే జీవులను గూర్చిన శాసనం. ");
INSERT INTO tel2017_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ఏది తినాలో, ఏది తినకూడదో, ఏది పవిత్రమో, ఏది అపవిత్రమో తెలియజేయడం దీని ఉద్దేశం. ");
INSERT INTO tel2017_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“నువ్వు ఇశ్రాయేలు ప్రజలకి ఇలా చెప్పు. ఒక స్త్రీ గర్భవతిగా ఉండి ఒక మగ పిల్లాణ్ణి కంటే ఆమె ఏడు రోజులు అశుద్ధంగా ఉంటుంది. తాను బహిష్టు రోజుల్లో ఉన్నట్టే అశుద్ధంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ఎనిమిదో రోజున ఆ పిల్లాడికి సున్నతి చేయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ఆమె తన రక్తస్రావం నుండి శుద్ధి జరగడానికి ముప్ఫై మూడు రోజులు పడుతుంది. తన రక్తశుద్ధి రోజులు పూర్తయే వరకూ ఆమె పరిశుద్ధమైన దాన్ని దేన్నీ ముట్టుకోకూడదు. పరిశుద్ధ స్థలం లో ప్రవేశింపకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ఆమె ఒకవేళ ఆడపిల్లని కంటే ఆమె రెండు వారాలు అశుద్ధంగా ఉంటుంది. తాను బహిష్టు రోజుల్లో ఉన్నట్టే అశుద్ధంగా ఉంటుంది. ఆమె రక్తశుద్ధికి అరవై ఆరు రోజులు పడుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","కొడుకైనా, కూతురైనా వాళ్ళ కోసం ఆమె శుద్ధి రోజులు పూర్తయ్యాక ఆమె ఒక సంవత్సరం వయస్సున్న గొర్రె పిల్లని దహనబలిగా తీసుకురావాలి. అలాగే పాపం కోసం అర్పణగా ఒక గువ్వనుగానీ, ఒక తెల్ల పావురం పిల్లని గానీ తీసుకు రావాలి. వీటిని ప్రత్యక్ష గుడారం ద్వారం దగ్గరికి తెచ్చి యాజకుడికి ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","అప్పుడు అతడు యెహోవా సమక్షంలో వాటిని అర్పించి ఆమె కోసం పరిహారం చేస్తాడు. అప్పుడామె తన రక్తస్రావం విషయంలో ఆమెకు శుద్ధి కలుగుతుంది. ఇది మగపిల్లాణ్ణి గానీ ఆడ పిల్లను గానీ కనినప్పుడు స్త్రీ విషయంలో విధించిన చట్టం. ");
INSERT INTO tel2017_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ఆమెకు ఒకవేళ గొర్రె పిల్లని తీసుకువచ్చే స్తోమత లేకపోతే, ఆమె రెండు తెల్ల గువ్వలనైనా రెండు పావురం పిల్లలనైనా తీసుకు రావాలి. వాటిలో ఒకటి దహనబలిగా, మరొకటి పాపంకోసం బలి అర్పణగా తీసుకు రావాలి. యాజకుడు ఆమె కోసం పరిహారం చేస్తాడు. అప్పుడామె శుద్ధురాలు అవుతుంది.” ");
INSERT INTO tel2017_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","యెహోవా మోషే అహరోనులకు ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ఒక వ్యక్తి చర్మం పైన వాపు గానీ, ఎండిన పొక్కు గానీ, నిగనిగలాడే మచ్చ గానీ ఉండి అది చర్మ వ్యాధిగా మారితే అతణ్ణి ప్రధాన యాజకుడైన అహరోను దగ్గరికి గానీ, యాజకులైన అతని కొడుకుల దగ్గరికి గానీ తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","అప్పుడు ఆ యాజకుడు అతని చర్మంపై ఉన్న వ్యాధిని పరీక్ష చేస్తాడు. వ్యాధి మచ్చ ఉన్న ప్రాంతంపైన వెంట్రుకలు తెల్లగా మారి, ఆ మచ్చ చర్మంలో లోతుగా ఉన్నట్టు కన్పిస్తే అది అంటువ్యాధి. యాజకుడు అతణ్ణి పరీక్ష చేసిన తరువాత అతణ్ణి అశుద్ధుడని నిర్థారించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ఒకవేళ నిగనిగలాడే మచ్చ చర్మం పైన తెల్లగా కన్పించి, అది లోతుగా లేకుండా, అక్కడి చర్మం పై వెంట్రుకలు తెల్లగా మారకుండా ఉంటే యాజకుడు ఆ వ్యక్తిని ఏడు రోజులు వేరుగా, ఒంటరిగా ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ఏడో రోజు యాజకుడు అతణ్ణి తిరిగి పరీక్షించాలి. తన దృష్టిలో వ్యాధి ముదరకుండా, ఆ మచ్చ వ్యాపించకుండా ఉందేమో చూడాలి. ఆ మచ్చ చర్మంపై వ్యాపించకుండా ఉంటే యాజకుడు మరో ఏడు రోజులు అతణ్ణి వేరుగా ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ఏడో రోజు యాజకుడు అతణ్ణి రెండోసారి పరీక్షించాలి. వ్యాధి తగ్గి ఆ మచ్చ చర్మం పైన వ్యాపించకుండా ఉంటే అతణ్ణి శుద్ధుడని ప్రకటించాలి. అది పొక్కు మాత్రమే. అతడు తన బట్టలు ఉతుక్కోవాలి. అప్పుడు శుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","అయితే అతడు తన శుద్ధి కోసం యాజకుడికి కన్పించిన తరువాత ఆ మచ్చ చర్మంపైన వ్యాపిస్తే యాజకుడికి మరో సారి కనిపించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","అప్పుడు ఆ మచ్చ చర్మం పైన ఇంకా వ్యాపించి ఉంటే యాజకుడు అతణ్ణి అశుద్ధుడని నిర్థారించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","ఎవరికైనా చర్మంపైన పొడలా కన్పిస్తే అతణ్ణి యాజకుడి దగ్గరకి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","యాజకుడు ఏదన్నా వాపు చర్మంపైన తెల్లగా కన్పిస్తుందేమో చూడాలి. అక్కడి వెంట్రుకలు తెల్లగా మారి, ఆ వాపు రేగి పుండులా కన్పిస్తుందేమో చూడాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ఈ సూచనలు కన్పిస్తే అది తీవ్రమైన చర్మవ్యాధి. యాజకుడు అతణ్ణి అశుద్ధుడని నిర్థారించాలి. అతడు అప్పటికే అశుద్ధుడు కాబట్టి అతణ్ణి వేరుగా ఉంచకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ఆ చర్మ వ్యాధి మరింత తీవ్రమై ఆ వ్యక్తి తలనుండి కాలి వరకూ వ్యాపిస్తే, అలా యాజకుడికి కూడా అనిపిస్తే, అప్పుడు యాజకుడు వ్యాధి ఆ వ్యక్తి శరీరమంతా వ్యాపించిందేమో పరీక్ష చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ఆ చర్మ వ్యాధి అతని శరీరమంతా వ్యాపిస్తే యాజకుడు అతణ్ణి శుద్ధుడని ప్రకటించాలి. ఒళ్ళంతా తెల్లబారితే అతడు శుద్ధుడు. ");
INSERT INTO tel2017_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ఒకవేళ అతని ఒంటిపై చర్మం రేగి పుండు అయితే అతడు అశుద్ధుడు. ");
INSERT INTO tel2017_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","యాజకుడు చర్మంపై పచ్చి పుండు చూసి అతణ్ణి అశుద్ధుడని నిర్థారించాలి. ఎందుకంటే రేగిన చర్మం, పచ్చి పుండు అశుద్ధమే. అది అంటువ్యాధి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","అయితే ఒకవేళ ఆ పుండు ఎండిపోయి చర్మం తిరిగి తెల్లగా కన్పిస్తే ఆ వ్యక్తి యాజకుడి దగ్గరికి వెళ్ళాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","యాజకుడు అతని చర్మం తెల్లగా మారిందేమో చూస్తాడు. అది తెల్లబారితే ఆ వ్యక్తి శుద్ధుడని ప్రకటిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ఒక వ్యక్తి చర్మం పైన పుండు వచ్చి అది మానిపోతే ");
INSERT INTO tel2017_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ఆ పుండు ఉన్న ప్రాంతంలో తెల్లని వాపుగానీ, నిగనిగలాడే మచ్చ గానీ, తెలుపుతో కూడిన ఎర్రని మచ్చ గానీ కన్పిస్తే దాన్ని యాజకుడికి చూపించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ఆ మచ్చ చర్మంలో లోతుగా ఉండి ఆ ప్రాంతంలో వెంట్రుకలు తెల్లగా కన్పిస్తున్నాయో లేదో యాజకుడు పరీక్షిస్తాడు. ఒకవేళ అలా ఉంటే అతణ్ణి అశుద్ధుడని ప్రకటించాలి. పుండు ఉన్నచోటే అది కన్పిస్తే అది అంటురోగం. ");
INSERT INTO tel2017_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","యాజకుడు పరీక్షించినప్పుడు ఆ మచ్చపైన వెంట్రుకలు తెల్లగా మారకుండా, అది చర్మం పైన లోతుగా కాకుండా మానిపోతున్నట్టు కన్పిస్తే అతణ్ణి ఏడు రోజులపాటు వేరుగా, ఒంటరిగా ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","తరువాత అది చర్మం అంతటా వ్యాపిస్తే యాజకుడు అతణ్ణి అశుద్ధుడని నిర్థారించాలి. అది ఒక అంటు వ్యాధి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","నిగనిగలాడే మచ్చ అలాగే ఉండిపోయి వ్యాపించకుండా ఉంటే అది పుండు మానిన మచ్చ. యాజకుడు అతణ్ణి శుద్ధుడని ప్రకటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","చర్మంపైన కాలిన గాయమై ఆ కాలిన చోట నిగనిగలాడే తెల్లని మచ్చ కానీ, తెలుపుతో కూడిన ఎర్రని మచ్చగానీ ఉంటే యాజకుడు దాన్ని పరీక్షించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ఆ మచ్చ చర్మంలో లోతుగా ఉండి ఆ ప్రాంతంలో వెంట్రుకలు తెల్లగా కన్పిస్తున్నాయో లేదో యాజకుడు పరీక్షిస్తాడు. అలా ఉంటే అది అంటువ్యాధి. అది కాలిన గాయంలోనుండి బయటకు వచ్చింది. అప్పుడు యాజకుడు ఆ వ్యక్తిని అశుద్ధుడని నిర్థారించాలి. అది అంటువ్యాధి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","అయితే యాజకుడు దాన్ని పరీక్షించినప్పుడు నిగనిగలాడే మచ్చలో తెల్లని వెంట్రుకలు లేకపోయినా, మచ్చ లోతుగా లేకుండా గాయం మానినట్టు కన్పిస్తున్నా అతణ్ణి ఏడు రోజులు ఒంటరిగా, వేరుగా ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ఏడో రోజు యాజకుడు అతణ్ణి పరీక్షించినప్పుడు ఆ వ్యాధి చర్మం అంతా వ్యాపిస్తే అతణ్ణి అశుద్ధుడని నిర్థారించాలి. అది అంటువ్యాధి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","అయితే నిగనిగలాడే మచ్చ చర్మం అంతా వ్యాపించకుండా అలాగే ఉండి మానినట్టు కన్పిస్తే అది కాలిన గాయం వల్ల కలిగిన వాపు. యాజకుడు అతణ్ణి శుద్ధుడుగా నిర్థారించాలి. అది కేవలం కాలడం మూలాన కలిగిన మచ్చ మాత్రమే. ");
INSERT INTO tel2017_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","మగవాళ్ళకైనా, ఆడవాళ్లకైనా తలలో గానీ, గడ్డంలో గానీ ఏదన్నా అంటువ్యాధి వస్తే యాజకుడు దాన్ని పరీక్షించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","అది చర్మంలో లోతుగా ఉన్నట్టు కన్పించినా, లేదా దానిపై వెంట్రుకలు పసుపు పచ్చగా మారినా ఆ వ్యక్తిని యాజకుడు అశుద్ధుడనీ, అశుద్ధురాలనీ నిర్థారించాలి. తలలో లేదా గడ్డంలో అది దురద పుట్టించే ఒక అంటువ్యాది. ");
INSERT INTO tel2017_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ఏదైనా మచ్చ దురద పుట్టేదిగా ఉన్నప్పుడు యాజకుడు ఆ మచ్చని పరీక్షించాలి. ఆ మచ్చ చర్మంలో లోతుగా లేకపోయినా, దానిపై నల్ల వెంట్రుకలు లేకపోయినా యాజకుడు ఆ దురద మచ్చ వ్యాధి ఉన్న వ్యక్తిని ఏడు రోజుల పాటు ఒంటరిగా, వేరుగా ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ఏడో రోజు యాజకుడు ఆ మచ్చ వ్యాపించిందేమో చూడాలి. వ్యాధి మచ్చ ఉన్న ప్రాంతంలో పసుపు పచ్చ వెంట్రుకలు లేకపోయినా, ఆ మచ్చ కేవలం చర్మం పైన మాత్రమే కన్పిస్తున్నా అతనికి జుట్టు కత్తిరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","వ్యాధి మచ్చ ఉన్నచోట మాత్రం జుట్టు కత్తిరించకూడదు. యాజకుడు ఆ మచ్చ ఉన్న వ్యక్తిని మరో ఏడు రోజులు ఒంటరిగా, వేరుగా ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ఏడో రోజు యాజకుడు ఆ మచ్చ వ్యాపించిందేమో చూడాలి. ఆ మచ్చ కేవలం చర్మం పైన మాత్రమే కనిపిస్తూ ఉంటే యాజకుడు అతణ్ణి శుద్ధుడిగా నిర్థారించాలి. ఆ వ్యక్తి తన బట్టలు ఉతుక్కోవాలి. తరువాత అతడు శుద్ధుడు అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ఒకవేళ అతడు శుద్ధుడని నిర్ధారించిన తరువాత ఆ వ్యాధి మచ్చ ఎక్కువగా వ్యాపిస్తే యాజకుడు తిరిగి అతణ్ణి పరీక్షించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ఒకవేళ ఆ వ్యాధి చర్మంపైన వ్యాపిస్తే యాజకుడు పసుపుపచ్చ వెంట్రుకల కోసం వెదకాల్సిన పని లేదు. అతడు అశుద్ధుడే. ");
INSERT INTO tel2017_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","అయితే ఆ దురద వ్యాధి వ్యాప్తి నిలిచిపోయిందనీ, ఆ వ్యాధి మచ్చలో నల్ల వెంట్రుకలు మొలుస్తున్నాయనీ యాజకుడికి అన్పిస్తే ఆ వ్యాధి నయం అయినట్టే. అతడు శుద్ధుడే. యాజకుడు అతడు శుద్ధుడని నిర్థారించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","మగవాళ్ళకైనా, ఆడవాళ్లకైనా చర్మం పైన నిగనిగలాడే తెల్లని మచ్చలు ఏర్పడితే యాజకుడు వాళ్ళని పరీక్షించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ఆ నిగనిగలాడే మచ్చలు అస్పష్టంగా ఉంటే చర్మం లోనుండి వచ్చిన పొక్కు మాత్రమే. వాళ్ళు శుద్ధులే అవుతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","మగవాడి తల వెంట్రుకలు రాలిపోతే అతనిది బట్టతల. అయినా అతడు శుద్ధుడే. ");
INSERT INTO tel2017_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ముఖం వైపు ఉన్న జుట్టు రాలిపోతే అతడిది బోడి నొసలు. అతడు శుద్ధుడే. ");
INSERT INTO tel2017_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","అయితే ఒక వ్యక్తి బట్టతలపై గానీ, నొసటిపైన గానీ ఎరుపు చాయలో తెల్లని మచ్చ ఏర్పడితే అది అంటువ్యాధి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","అతని బట్టతలపై గానీ నొసటిపై గానీ వ్యాధి వచ్చిన ప్రాంతంలో ఏర్పడిన వాపు చర్మంలో అంటువ్యాధిని సూచిస్తుందేమో యాజకుడు పరీక్షించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ఆ వాపు అలా సూచిస్తుంటే అతనికి వచ్చింది అంటువ్యాధి. అతడు అశుద్ధుడు. అతని తలపై ఉన్న వ్యాధి కారణంగా యాజకుడు అతణ్ణి అశుద్ధుడుగా ప్రకటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","ఆ అంటువ్యాధి ఉన్న వ్యక్తి బట్టలను చించివేయాలి. అతడు తన తలని విరబోసుకోవాలి. అతడు తన కింది పెదవిని కప్పుకుని ‘అశుద్ధుణ్ణి! అశుద్ధుణ్ణి!’ అని కేకలు పెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ఆ అంటువ్యాధి ఉన్నన్ని రోజులూ అతడు అశుద్ధుడుగానే ఉంటాడు. అతనికి అంటురోగం వచ్చి అశుద్ధుడుగా ఉన్నాడు కాబట్టి అతడు ఒంటరిగానే ఉండాలి. శిబిరం బయట అతడు నివసించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","ఏదైనా బట్టలకు బూజు పడితే అది ఉన్ని అయినా నార బట్టలైనా, ");
INSERT INTO tel2017_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","లేదా నారతో వెంట్రుకలతో తోలుతో చేసిన పడుగైనా, పేక అయినా, వస్తువైనా ");
INSERT INTO tel2017_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","వాటిపైన పచ్చని లేదా ఎర్రని మాలిన్యం ఏర్పడి, వ్యాపిస్తే అది బూజు, తెగులు. దాన్ని యాజకుడికి చూపించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","యాజకుడు ఆ తెగులు కోసం ఆ వస్తువుని పరీక్షించాలి. ఆ తెగులు పట్టిన దాన్ని ఏడురోజుల పాటు వేరుగా ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ఏడో రోజు తిరిగి ఆ తెగులు కోసం పరీక్షించాలి. నారతోనో వెంట్రుకలతోనో, తోలుతోనో చేసిన పడుగైనా, పేక అయినా, వస్తువైనా వాటిపైన ఆ తెగులు వ్యాపించినట్టు కన్పిస్తే అది హానికరమైన తెగులు. అది అశుద్ధం. ");
INSERT INTO tel2017_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","కాబట్టి అతడు నారతోనో వెంట్రుకలతోనో, తోలుతోనో చేసిన పడుగైనా, పేక అయినా, వస్తువైనా హానికరమైన తెగులు కన్పించిన దాన్ని మంట పెట్టి కాల్చేయాలి. ఎందుకంటే అది వ్యాధికి దారితీస్తుంది. దాన్ని సంపూర్ణంగా తగలబెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","అయితే యాజకుడు పరీక్షించినప్పుడు నారతో వెంట్రుకలతో, తోలుతో చేసిన పడుగైనా, పేక అయినా, వస్తువైనా వాటిపైన ఆ తెగులు వ్యాపించకపొతే ");
INSERT INTO tel2017_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","యాజకుడు ఆ తెగులు పట్టిన దాన్ని ఉతకమని ఆజ్ఞాపించాలి. దాన్ని మరో ఏడు రోజులు విడిగా ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ఆ తరువాత తెగులు పట్టిన ఆ వస్తువుని యాజకుడు పరీక్షించాలి. ఆ తెగులు రంగు మారకపోయినా, వ్యాపించక పోయినా అలాగే ఉంటే అది అశుద్ధం. దాన్ని మంట పెట్టి కాల్చేయాలి. ఆ తెగులు ఎక్కడ పట్టినా, ఆ వస్తువుని సంపూర్ణంగా కాల్చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ఒకవేళ ఆ బట్టని ఉతికిన తరువాత యాజకుడు దాన్ని పరీక్షించినప్పుడు ఆ తెగులు అస్పష్టంగా కన్పిస్తే అది బట్టలైనా, పడుగైనా, పేక అయినా, తోలు అయినా దాన్ని యాజకుడు చించివేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ఆ తరువాత ఆ తెగులు నారతో వెంట్రుకలతో తోలుతో చేసిన పడుగులోనో, పేకలోనో, వస్తువుపైనో, బట్టలపైనో ఇంకా కన్పిస్తే అది వ్యాపిస్తుందని అర్థం. అప్పుడు ఆ తెగులును పూర్తిగా కాల్చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","నారతోనో వెంట్రుకలతోనో, తోలుతోనో చేసిన పడుగైనా, పేక అయినా, వస్తువైనా, బట్టలైనా ఉతికిన తరువాత తెగులు కన్పించకుంటే ఆ వస్తువునో, బట్టనో రెండోసారి ఉతికించాలి. అప్పుడు అది శుద్ధం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ఉన్ని బట్టల పైనో, నార బట్టలపైనో, పడుగుపైనో, పేకపైనో తోలు వస్తువులపైనో బూజూ, తెగులూ కన్పించినప్పుడు వాటిని అశుద్ధం అనో శుద్ధం అనో ప్రకటించడానికి ఉద్దేశించిన చట్టం ఇది.” ");
INSERT INTO tel2017_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","యెహోవా మోషేకి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“చర్మవ్యాధి ఉన్న వ్యక్తి శుద్ధీకరణ జరిగే రోజుకి సంబంధించిన చట్టం ఇది. అతణ్ణి యాజకుడి దగ్గరికి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","చర్మానికి కలిగిన అంటురోగం మానిందీ లేనిదీ పరీక్షించడానికి యాజకుడు శిబిరం బయటకు వెళ్ళాలి. యాజకుడు అతణ్ణి చూసినప్పుడు అతని చర్మవ్యాధి నయం అయితే ");
INSERT INTO tel2017_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","శుద్ధీకరణ కావాలని కోరే ఆ వ్యక్తిని యాజకుడు జీవించి ఉన్న, లోపం లేని రెండు పక్షులనూ, దేవదారు కర్రనూ, ఎర్రని నూలునూ, హిస్సోపు చెట్టు రెమ్మనూ తీసుకు రమ్మని ఆదేశించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","తరువాత యాజకుడు ఆరెండు పక్షుల్లో ఒకదాన్ని పారే నీటిపైన, ఒక మట్టి పాత్రలో చంపమని ఆదేశించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","అప్పుడు యాజకుడు బతికి ఉన్న రెండో పక్షినీ, దేవదారు కర్రనూ, ఎర్రని నూలునూ, హిస్సోపు రెమ్మనూ తీసుకుని వాటిని పారే నీటిపైన, ఒక మట్టి పాత్రలో చనిపోయిన పక్షి రక్తంలో ముంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","చర్మవ్యాధి నయమై శుద్ధీకరణ కోసం చూసే వ్యక్తి పైన యాజకుడు ఆ నీళ్ళని ఏడు సార్లు చిలకరించాలి. తరువాత యాజకుడు అతడు శుద్ధుడని ప్రకటించాలి. అప్పుడు యాజకుడు జీవించి ఉన్న రెండో పక్షిని ఎగిరి పోయేట్టు బయట మైదానంలో వదిలి వేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","అప్పుడు శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి తన బట్టలు ఉతుక్కోవాలి. తన జుట్టు కత్తెర వేసుకోవాలి. నీళ్ళతో స్నానం చేయాలి. అప్పుడు అతడు శుద్ధుడు అవుతాడు. తరువాత అతడు శిబిరంలోకి వచ్చి తన గుడారం బయట ఏడు రోజులు ఉండిపోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ఏడో రోజున అతడు తన తలపై జుట్టునంతా క్షౌరం చేసుకోవాలి. తరువాత తన గడ్డాన్నీ, కనుబొమలను కూడా క్షౌరం చేసుకోవాలి. తన జుట్టు అంతా క్షౌరం చేసుకున్న తరువాత తన బట్టలు ఉతుక్కుని నీళ్ళతో స్నానం చేయాలి. అప్పుడు అతడు శుద్ధుడవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ఎనిమిదో రోజు అతడు లోపం లేని రెండు మగ గొర్రె పిల్లలనూ, ఏడాది వయస్సున్న లోపం లేని ఒక ఆడ గొర్రె పిల్లనూ యాజకుడి దగ్గరికి తీసుకురావాలి. వాటితో పాటు నైవేద్యం కోసం నూనె కలిసిన మూడు కిలోల మెత్తని పిండినీ, అర లీటరు నూనెనూ తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","శుద్ధీకరణ చేసే యాజకుడు శుద్ధీకరణ కోసం వచ్చిన వ్యక్తినీ ఈ సామగ్రినీ ప్రత్యక్ష గుడారం ద్వారం దగ్గరఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","యాజకుడు వాటిలో ఒక మగ గొర్రెపిల్లనూ, నూనెనూ తీసుకుని వాటిని అపరాధం కోసం చేసే బలిగా అర్పిస్తాడు. వాటిని యెహోవా సమక్షంలో కదలించే అర్పణగా పైకెత్తి కదిలిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","పాపం కోసం బలి పశువునూ, దహనబలి పశువునూ వధించే పరిశుద్ధ స్థలం లోనే ఈ మగ గొర్రెపిల్లని వధించాలి. పాపం కోసం చేసే అర్పణలాగే అపరాధం కోసం చేసే అర్పణ కూడా యాజకుడికే చెందుతుంది. ఎందుకంటే అది అతి పరిశుద్ధం. ");
INSERT INTO tel2017_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","తరువాత యాజకుడు అపరాధం కోసం బలిగా వధించిన పశువు రక్తాన్ని కొంచెం తీసుకుని శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి కుడిచెవి తమ్మె పైనా, కుడిచేతి బొటన వేలిపైనా, కుడి కాలి బొటన వేలిపైనా పూయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","తరువాత యాజకుడు అరలీటరు నూనె లో కొంచం తన ఎడమ అరచేతిలో పోసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ఎడమ చేతిలో ఉన్న నూనెలో తన కుడి చేతి వేలుని ముంచి యెహోవా సమక్షంలో ఏడు సార్లు చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","తరువాత యాజకుడు తన అరచేతిలో మిగిలిన నూనెలో కొంచెం తీసుకుని శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి కుడిచెవి తమ్మె పైన, కుడిచేతి బొటన వేలిపైన, కుడి కాలి బొటన వేలిపైన ఉన్న అపరాధ బలిగా వధించిన పశువు రక్తంపై పూయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","మిగిలిన నూనెని శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి తలపైన రాయాలి. ఆ విధంగా యాజకుడు యెహోవా సమక్షంలో ఆ వ్యక్తి కోసం పరిహారం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","అప్పుడు యాజకుడు శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి పాపం కోసం బలిని అర్పించి పరిహారం చేయాలి. ఆ తరువాత యాజకుడు దహనబలి పశువును వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","యాజకుడు దహనబలినీ, నైవేద్యాన్నీ బలిపీఠం పైన అర్పించాలి. ఆవిధంగా యాజకుడు ఆ వ్యక్తి కోసం పరిహారం చేయాలి. అప్పుడు అతడు శుద్ధుడవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","అయితే ఆ వ్యక్తి పేదవాడై ఈ అర్పణలన్నీ చెల్లించే స్తోమత అతనికి లేకపోతే తన పరిహారం కోసం అతడు యెహోవా ఎదుట కదలిక అర్పణగా ఒక మగ గొర్రె పిల్లనూ, నూనెతో కలిపిన కిలో గోదుమ పిండినీ, అర లీటరు నూనెనూ తీసుకుని రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","వీటితో పాటు తన స్తోమతుకు తగినట్టు రెండు గువ్వలను గానీ రెండు తెల్ల పావురాలను గానీ తీసుకు రావాలి. వాటిలో ఒకటి పాపం కోసం బలి అర్పణగా మరొకటి దహనబలి అర్పణగా తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ఎనిమిదో రోజు అతడు తన శుద్ధీకరణ కోసం వాటిని ప్రత్యక్ష గుడారం ద్వారం దగ్గర యెహోవా సమక్షంలో యాజకుడి దగ్గరికి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","అప్పుడు యాజకుడు అపరాధం కోసం బలి అర్పణకై తెచ్చిన గొర్రెపిల్లనూ నూనెనూ తీసుకుని కదలిక అర్పణగా యెహోవా సమక్షంలో వాటిని కదిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","తరువాత అతడు అపరాధం కోసం బలి అర్పణగా తెచ్చిన గొర్రెపిల్లని వధించాలి. అపరాధం కోసం బలిగా వధించిన పశువు రక్తాన్ని కొంచెం తీసుకుని శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి కుడిచెవి తమ్మెపైన, కుడిచేతి బొటన వేలిపైన, కుడి కాలి బొటన వేలిపైన పూయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","తరువాత యాజకుడు అరలీటరు నూనెలో కొంచం తన ఎడమ అరచేతిలో పోసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ఎడమ చేతిలో ఉన్న నూనెలో తన కుడి చేతి వేలుని ముంచి యెహోవా సమక్షంలో ఏడు సార్లు చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","తరువాత యాజకుడు తన అరచేతిలో మిగిలిన నూనెలో కొంచెం తీసుకుని శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి కుడిచెవి తమ్మెపైన, కుడిచేతి బొటన వేలిపైన, కుడి కాలి బొటన వేలిపైన అపరాధ బలిగా వధించిన పశువు రక్తంపై పూయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","మిగిలిన నూనెని శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి తలపైన యెహోవా సమక్షంలో రాయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","తరువాత అతడు తన స్తోమత కొద్దీ తెచ్చిన రెండు గువ్వల్లో, లేదా రెండు తెల్లని పావురం పిల్లల్లో ఒక దాన్ని పాపం కోసం బలిగా మరో దాన్ని దహనబలిగా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","తానర్పించే నైవేద్యంతో పాటుగా వీటిని అర్పించాలి. తరువాత శుద్ధీకరణ కోసం వచ్చిన వ్యక్తి కోసం యాజకుడు యెహోవా సమక్షంలో పరిహారం చేయాలి. ఆ విధంగా యాజకుడు అతని పాపాలు కప్పివేస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","చర్మంలో వచ్చిన అంటువ్యాధి శుద్ధీకరణ కోసం నిర్ధారించిన బలులు సమర్పించుకోలేని వ్యక్తి విషయంలో విధించిన చట్టం ఇది.” ");
INSERT INTO tel2017_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","తరువాత యెహోవా, మోషే అహరోనులతో ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“నేను మీకు వారసత్వంగా ఇచ్చే కనాను దేశంలో మీరు ప్రవేశించిన తరువాత ఏదైనా ఇంట్లో నేను బూజునూ, తెగులునూ కలిగిస్తే, ");
INSERT INTO tel2017_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ఆ యింటి యజమాని యాజకుడి దగ్గరికి వచ్చి, ‘నా ఇంట్లో బూజు వంటిదేదో ఉన్నట్టు నాకన్పిస్తుంది’ అని చెప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","అప్పుడు ఆ ఇంట్లో ఉన్నదంతా అశుద్ధం కాకుండా ఉండటానికి యాజకుడు వెళ్ళి ఆ ఇంటిని చూడాలి. దానికి ఎదుట యాజకుడు వాళ్ళని ఆ ఇల్లు ఖాళీ చేయమని ఆదేశించాలి. ఆ తరువాత యాజకుడు ఆ ఇంటిని చూడటానికి వెళ్ళాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","అతడు ఆ బూజుని చూడాలి. అది ఇంటి గోడల పైన పాకిందేమో చూడాలి. అది ఇంటి గోడలపైన ఎర్ర గీతలా గానీ, పచ్చ గీతలా గానీ ఉండి గోడ పగుళ్ళలో ఉంటే ");
INSERT INTO tel2017_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","యాజకుడు ఆ ఇంట్లో నుండి బయటకు వెళ్ళి ఆ ఇంటిని ఏడు రోజులపాటు మూసి ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ఏడో రోజు యాజకుడు తిరిగి వచ్చి మళ్ళీ పరీక్షించాలి. గోడపైన బూజు వ్యాపించిందేమో పరిశీలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ఒకవేళ అది వ్యాపిస్తే, ఆ బూజు పట్టిన రాళ్ళను గోడలోంచి తీసి పట్టణం బయట ఉన్న ఒక అశుద్ధమైన ప్రాంతంలో పారవేయమని యాజకుడు ఆదేశించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ఆ తరువాత ఆ యింటి లోపల చుట్టూ గోడలను గీకించాలి. అలా గీకించిన తరువాత మాలిన్యం అంటిన పెళ్లలను పట్టణం బయట ఉన్న ఒక అశుద్ధమైన ప్రాంతంలో పారవేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","వేరే రాళ్ళను తెచ్చి తీసివేసిన రాళ్ళ స్థానంలో చేర్చాలి. అలాగే కొత్త అడుసు తెచ్చి ఆ ఇంటి గోడలకు పూయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","అతడు ఆ రాళ్లను ఊడదీసి, ఆ ఇల్లు గీకించి, కొత్త అడుసు పూసిన తరువాత మళ్ళీ బూజు కన్పిస్తే యాజకుడు వచ్చి చూడాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ఆ ఇల్లంతా బూజు వ్యాపించిందేమో యాజకుడు పరీక్షించాలి. ఒకవేళ బూజు కన్పిస్తే అది హానికరం. ఆ ఇల్లు అశుద్ధం. ");
INSERT INTO tel2017_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","కాబట్టి ఆ ఇంటిని కూల్చి వేయాలి. ఆ ఇంటి రాళ్ళనూ, కలపనూ, అడుసునూ తీసి పట్టణం బయట ఉన్న అశుద్ధమైన ప్రాంతంలోకి మోసుకు వెళ్ళి పారవేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","దీనికి తోడు ఆ ఇల్లు మూసి ఉన్న సమయంలో ఎవరైనా దానిలో ప్రవేశిస్తే వాళ్ళు సాయంత్రం వరకూ అశుద్ధంగా ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ఆ ఇంట్లో నిద్రించేవాడు తన బట్టలు ఉతుక్కోవాలి. అలాగే ఆ ఇంట్లో భోజనం చేసేవాడు కూడా తన బట్టలు ఉతుక్కోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","ఒకవేళ యాజకుడు కొత్త అడుసు పూసిన తరువాత ఆ ఇంట్లో బూజు వ్యాపించేదేమో పరీక్షించడానికి వచ్చినప్పుడు, బూజు కన్పించకుంటే ఆ ఇంటిని శుద్ధమైనది గా ప్రకటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","అప్పుడు యాజకుడు ఆ యింటిని శుద్ధీకరణ చేయడానికి రెండు పక్షులనూ, ఒక దేవదారు కర్రనూ, ఎర్రని నూలునూ, హిస్సోపు రెమ్మనూ తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","పారే నీళ్ళపైన ఒక మట్టి పాత్రలో ఒక పక్షిని వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ఆ దేవదారు కర్రనూ, హిస్సోపు రెమ్మనూ, ఎర్రని నూలునూ, బతికి ఉన్న పక్షినీ తీసుకుని చనిపోయిన పక్షి రక్తంలోనూ, పారే నీళ్ళలోనూ వాటిని ముంచాలి. వాటితో ఆ ఇంటిపైన ఏడు సార్లు చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ఆ విధంగా పక్షి రక్తంతో, పారే నీళ్ళతో, బతికి ఉన్న పక్షితో, దేవదారు కర్రతో, హిస్సోపు రెమ్మతో, ఎర్రని నూలుతో ఆ ఇంటిని శుద్ధి చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","అయితే బతికి ఉన్న పక్షిని పట్టణం బయట మైదానాల్లో వదిలివేయాలి. ఈ విధంగా ఆ ఇంటి కోసం పరిహారం చేయాలి. అప్పుడు ఆ ఇల్లు శుద్ధి అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","అన్ని రకాల చర్మ సంబంధిత అంటు వ్యాధులకూ, పొక్కులకూ ");
INSERT INTO tel2017_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","వస్త్రంలో గానీ, ఇంట్లోగానీ ఏర్పడిన బూజూ, ");
INSERT INTO tel2017_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","వాపూ, చర్మం రేగి కలిగే మచ్చలూ, నిగనిగలాడే మచ్చలూ వీటికి సంబంధించిన చట్టం ఇది. ");
INSERT INTO tel2017_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","వీటిలో దేని మూలంగా ఒక వ్యక్తి ఎప్పుడు అశుద్ధుడు అవుతాడో, ఎప్పుడు శుద్ధుడు అవుతాడో ఈ చట్టం వివరిస్తుంది. ఇది చర్మానికి కలిగే అంటువ్యాధులకూ తెగులూ, బూజులకు సంబంధించిన చట్టం.” ");
INSERT INTO tel2017_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","యెహోవా మోషే అహరోనులతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“మీరు ఇశ్రాయేలు ప్రజలకు ఇలా చెప్పండి. ఎవరైనా ఒక వ్యక్తి శరీరంలో ఎక్కడన్నా ఏదన్నా స్రావం జరుగుతుంటే ఆ స్రావం కారణంగా అతడు అశుద్ధుడు అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","అతని అశుద్ధతకు కారణం రోగ కారకమైన స్రావమే. అతని శరీరంలో ఆ స్రావాలు కారినా, నిలిచి పోయినా అది అశుద్ధమే. ");
INSERT INTO tel2017_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","అతడు పడుకునే పడకా, కూర్చునే ప్రతిదీ అశుద్ధమే అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","అతని పడకని తాకే ఎవడైనా తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడు గానే ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","శరీరంలో స్రావం అవుతున్న వాడు కూర్చున్న దానిపై ఎవరైనా కూర్చుంటే అలాంటి వాడు తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. వాడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","రోగ కారకమైన స్రావం అవుతున్న వాణ్ణి తాకిన వాడు తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","అలాంటి స్రావం జరిగే వాడు ఎవరైనా శుద్ధుడి పైన ఉమ్మి వేస్తే అతడు తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","స్రావం జరిగేవాడు జీను పై కూర్చుంటే అదీ అశుద్ధం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","అతడు కూర్చున్న ఏ వస్తువునైనా తాకితే, ఆ తాకినవాడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ఆ వస్తువులను మోసేవాడు తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","స్రావం జరిగే వాడు నీళ్ళతో చేతులు కడుక్కోకుండా ఎవరినైనా తాకితే అతడు తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","స్రావం జరిగే వాడు తాకిన మట్టిపాత్రను పగలగొట్టాలి. అది చెక్క పాత్ర అయితే దాన్ని నీళ్ళతో కడగాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","స్రావం జరిగే వాడు స్రావం మానిన తరువాత శుద్ధుడు కావడానికి ఏడు రోజులు లెక్క పెట్టుకోవాలి. ఆ తరువాత తన బట్టలు ఉతుక్కోవాలి. పారే నీటిలో స్నానం చేయాలి. అప్పుడు అతడు శుద్ధుడు అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ఎనిమిదో రోజు అతడు రెండు గువ్వలను గానీ రెండు పావురం పిల్లలను గానీ తీసుకుని ప్రత్యక్ష గుడారం ద్వారం దగ్గర యెహోవా సమక్షంలోకి తీసుకు రావాలి. అక్కడ యాజకుడికి వాటిని ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","యాజకుడు వాటిలో ఒక దాన్ని పాపం కోసం బలిగా రెండోదాన్ని దహనబలిగా అర్పించాలి. స్రావం జరిగే వాడి విషయంలో యాజకుడు ఇలా యెహోవా సమక్షంలో పరిహారం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ఒక వ్యక్తికి అప్రయత్నంగా వీర్యస్కలనం జరిగితే అతడు నీళ్ళలో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","అతని వీర్యం ఏదన్నా బట్టలపైనో, తోలు వస్తువు పైనో పడితే ఆ బట్టనీ, తోలునూ నీళ్ళతో ఉతకాలి. అవి సాయంత్రం వరకూ అశుద్ధమై ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","స్త్రీ పురుష సంపర్కంలో వీర్యస్కలనమైతే వాళ్ళిద్దరూ స్నానం చేయాలి. వాళ్ళు సాయంత్రం వరకూ అశుద్ధులుగా ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","ఒక స్త్రీ శరీరంలో బహిష్టు సమయంలో రక్తస్రావం జరిగితే ఆమె అశుద్ధత ఏడు రోజులుంటుంది. ఆ సమయంలో ఆమెని తాకిన వాళ్ళు ఆ రోజు సాయంత్రం వరకూ అశుద్ధులుగా ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ఆ సమయంలో ఆమె పండుకున్న ప్రతిదీ అశుద్ధంగా ఉంటుంది. ఆమె దేనిపైన కూర్చుంటుందో అది అశుద్ధంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ఆమె మంచాన్ని తాకిన ప్రతి వాడూ తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ఆమె దేనిపైన కూర్చుంటుందో దాన్ని తాకితే అతడు తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ఆమె మంచాన్నీ లేదా ఆమె కూర్చున్నదాన్నీ తాకితే ఆ వ్యక్తి సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ఒక వ్యక్తి స్త్రీతో సంభోగించినప్పుడు ఆమె అశుచి అతనికి తగిలితే అతడు ఏడు రోజులు అశుద్ధుడుగా ఉంటాడు. అతడు పండుకునే ప్రతి పడకా అశుద్ధమవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ఒక స్త్రీకి తన బహిష్టు సమయంలో కాకుండా అనేకరోజులు రక్త స్రావం జరుగుతూ ఉన్నా, లేదా బహిష్టు సమయం దాటిన తరువాత కూడా స్రావం జరుగుతూనే ఉన్నా స్రావం జరిగినన్ని రోజులూ ఆమెకు బహిష్టు సమయం లానే ఉంటుంది. ఆమె అశుద్ధురాలుగానే ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ఆమెకు స్రావం జరుగుతున్న రోజులన్నీ ఆమె పండుకునే మంచం ఆమె బహిష్టు సమయంలో పండుకునే మంచం లాగే ఉంటుంది. ఆమె దేని పైన కూర్చుంటుందో ఆమె బహిష్టు సమయంలో జరిగినట్టే అది అశుద్ధం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","వీటిని ముట్టుకునే వాడు అశుద్ధుడు. అతడు తన బట్టలు ఉతుక్కోవాలి. నీళ్ళతో స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ఆమె స్రావం నిలిచిపోయి ఆమె శుద్ధురాలైతే దానికి ఏడు రోజులు పడుతుంది. ఆమె ఆ ఏడు రోజులను లెక్క పెట్టుకోవాలి. అవి గడచిన తరువాత ఆమె శుద్ధురాలు అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ఎనిమిదో రోజు ఆమె రెండు గువ్వలను గానీ రెండు పావురం పిల్లలను గానీ తీసుకుని ప్రత్యక్ష గుడారం ద్వారంలో యెహోవా సమక్షంలోకి తీసుకు రావాలి. అక్కడ యాజకుడికి వాటిని ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","యాజకుడు వాటిలో ఒక దాన్ని పాపం కోసం బలిగా రెండోదాన్ని దహనబలిగా అర్పించాలి. ఆమెకు జరిగిన మలినకరమైన రక్త స్రావం విషయంలో యాజకుడు ఇలా యెహోవా సమక్షంలో పరిహారం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","నేను ఇశ్రాయేలు ప్రజల మధ్య నివసిస్తున్నాను. తమ అశుద్ధతతో వాళ్ళు నా నివాస స్థలాన్ని పాడు చేయకూడదు. వాళ్ళు తమ అశుద్ధతతో నా నివాస స్థలాన్ని పాడు చేసి చనిపోకుండా మీరు వారి అశుద్ధతని వాళ్ళకి దూరం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","శరీరంలో స్రావం జరిగే వాణ్ణి గూర్చీ, వీర్యస్కలనమై అశుద్ధుడయ్యే వాణ్ణి గూర్చీ, ");
INSERT INTO tel2017_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","బహిష్టుగా ఉన్న స్త్రీ గూర్చీ, స్రావం జరిగే స్త్రీ పురుషులను గూర్చీ, అశుద్ధంగా ఉన్న స్త్రీతో సంభోగించే వాణ్ని గూర్చీ విధించిన నిబంధనలు ఇవి.” ");
INSERT INTO tel2017_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","అహరోను ఇద్దరు కొడుకులూ యెహోవా సమక్షంలోకి వెళ్ళి చనిపోయిన తరువాత యెహోవా మోషేతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“నువ్వు నీ సోదరుడైన అహరోనుతో మాట్లాడి ఇలా చెప్పు, అతడు పరిహార స్థానమైన నిబంధన మందసం మూత ముందున్న తెరల్లో ఉన్న అతి పవిత్ర స్థలం లోకి అన్ని సమయాల్లో ప్రవేశించకూడదు. అతడు ప్రవేశిస్తే చనిపోతాడు. ఎందుకంటే నేను నిబంధన మందసం మూత పైన మేఘంలో కనిపిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","అతడు పాపం కోసం బలిగా ఒక కోడె దూడనూ, దహనబలిగా ఒక పొట్టేలునూ తీసుకుని పవిత్ర స్థలం లోకి రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","అతడు ప్రతిష్ట చేసిన సన్న నార చొక్కాయి వేసుకోవాలి. సన్న నారతో చేసిన లోదుస్తులు ధరించాలి. సన్న నారతో చేసిన నడికట్టు కట్టుకుని, సన్న నారతో చేసిన తలపాగా ధరించాలి. ఇవన్నీ ప్రతిష్ట చేసిన పవిత్ర వస్త్రాలు. కాబట్టి స్నానం చేసి వీటిని ధరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","అతడు ఇశ్రాయేలు సమాజం నుండి పాపం కోసం బలిగా రెండు మేక పోతులనూ దహనబలిగా ఒక పొట్టేలునూ తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","తరువాత అహరోను పాపం కోసం బలిగా కోడెదూడని మొదట తన కోసం అర్పించి తనకూ తన కుటుంబానికీ పరిహారం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ఆ తరువాత ఆ రెండు మేకపోతులను తీసుకుని వచ్చి ప్రత్యక్ష గుడారం ద్వారం దగ్గర యెహోవా సమక్షంలో ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","అప్పుడు అహరోను రెండు చీటీలు వేయాలి. ఒకటి యెహోవా కోసం రెండోది విడిచి పెట్టబోయే మేక కోసం వేయాలి. ఆరెండు చీటీలను ఆ రెండు మేకల పైన వేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","యెహోవా కోసం రాసిన చీటీ ఏ మేక పైన పడుతుందో ఆ మేకని తెచ్చి పాపం కోసం బలిగా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ఏ మేకమీద ‘విడిచి పెట్టాలి’ అనే చీటీ పడుతుందో ఆ మేకని యెహోవా సమక్షంలోకి ప్రాణంతో తీసుకుని రావాలి. దాని మూలంగా ప్రజల పాపాలకు పరిహారం కలిగేలా దాన్ని అడవిలో వదిలిపెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","అప్పుడు అహరోను పాపం కోసం బలిగా కోడెదూడని తీసుకు వచ్చి తన కోసం, తన కుటుంబం కోసం పరిహారం చేసుకోవాలి. దాని కోసం అహరోను ముందు తన పాపంకోసం బలిగా ఆ కోడె దూడని వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ఆ తరువాత అహరోను యెహోవా సమక్షంలో ఉన్న ధూపం వేసే పళ్ళెం తీసుకుని దాన్ని బలిపీఠం పైన ఉన్ననిప్పులతో పూర్తిగా నింపి, రెండు గుప్పిళ్ళలో పరిమళ ధూపం పొడిని తీసుకుని వాటిని తెరల లోపలికి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","యెహోవా సమక్షంలో నిబంధన ఆజ్ఞల మందసం పైన ఉన్న మూత పైగా ధూమం కమ్ముకునేలా సాంబ్రాణిని నిప్పులపై వేయాలి. అతనికి మరణం రాకుండా ఉండాలంటే ఇలా చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","తరువాత అతడు ఆ కోడె దూడ రక్తంలో కొంత తీసుకుని దాన్ని ఆ మూత పైన తూర్పు వైపున తన వేలితో చిలకరించాలి. కొంత రక్తం తీసుకుని తన వేలితో ఆ మూత పైన ఏడు సార్లు చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","అప్పుడు ప్రజలర్పించే పాపం కోసం బలిగా మేకని వధించాలి. దాని రక్తాన్ని అడ్డతెర లోపలికి తీసుకు రావాలి. కోడె దూడ రక్తంతో చేసినట్టే మేక రక్తంతోనూ చేయాలి. దాని రక్తాన్ని మందసం మూత ఎదుటా దాని పైనా చిలకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ఈ విధంగా ఇశ్రాయేలు ప్రజలందరి అశుద్ధమైన పనులను బట్టీ, వారి తిరుగుబాటును బట్టీ, వారందరి పాపాలన్నిటిని బట్టీ పరిశుద్ధ స్థలానికి పరిహారం చేయాలి. వారి అశుద్ధమైన పనుల మధ్యలో ప్రత్యక్ష గుడారంలో యెహోవా వారి మధ్యలో నివసిస్తున్నాడు కాబట్టి ప్రత్యక్ష గుడారం కోసం కూడా పరిహారం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","అతి పవిత్ర స్థలం లో పరిహారం చేయడానికి అహరోను ప్రవేశించినప్పుడు ప్రత్యక్ష గుడారంలో ఎవరూ ఉండకూడదు. అతడు తన కోసం, తన కుటుంబం కోసం, ఇంకా ప్రజలందరి కోసం పరిహారం చేయడం ముగించి బయటకి వచ్చేంత వరకూ ప్రత్యక్ష గుడారంలో ఎవరూ ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","తరువాత అతడు బయట యెహోవా సమక్షంలో ఉన్న బలిపీఠం దగ్గరికి వెళ్ళి దానికోసం పరిహారం చేయాలి. అతడు ఆ కోడె దూడ రక్తంలో కొంత, మేక రక్తంలో కొంత తీసుకుని బలిపీఠం కొమ్ములకు పూయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ఆ రక్తాన్ని ఏడు సార్లు తన వేలితో బలిపీఠంపై చిలకరించాలి. అలా దాన్ని పవిత్ర పరచి ఇశ్రాయేలు ప్రజలు చేసే అశుద్ధ పనుల నుండి దాన్ని శుద్ధీకరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","అతడు అతి పవిత్ర స్థలానికీ, ప్రత్యక్ష గుడారానికీ, బలిపీఠంకీ పరిహారం చేసి ముగించిన తరువాత బతికి ఉన్న మేకని తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","అప్పుడు అహరోను బతికి ఉన్న ఆ మేక తలపైన తన రెండు చేతులూ ఉంచి ఇశ్రాయేలు ప్రజల దుర్మార్గాలన్నటినీ, వారి తిరుగుబాటు అంతటినీ, వారి పాపాలన్నిటినీ ఒప్పుకోవాలి. ఆ విధంగా ఆ పాపాన్నంతా ఆ మేక పైన మోపి దాన్ని అడవిలోకి తోలుకుని వెళ్ళడానికి సిద్ధపడిన వ్యక్తితో పంపించి వేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ఆ మేక ప్రజల దుర్మార్గాలన్నిటినీ తన పై వేసుకుని ఎవరూ లేని ప్రాంతానికి వెళ్ళాలి. ఆ వ్యక్తి దాన్ని అడవిలోకి తీసుకు వెళ్ళి అక్కడ దాన్ని విడిచిపెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","తరువాత అహరోను ప్రత్యక్ష గుడారంలోకి తిరిగి వచ్చి అతి పవిత్ర స్థలం లోకి వెళ్లే ముందు తాను ధరించిన నార వస్త్రాలను తీసి వాటిని అక్కడే ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","అతడు పవిత్ర స్థలం లో స్నానం చేసి తిరిగి తన సాధారణ బట్టలు వేసుకుని బయటకు రావాలి. అప్పుడు తన కొరకూ, ప్రజల కొరకూ దహనబలులు అర్పించి తన కోసం, ప్రజల కోసం పరిహారం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","పాపం కోసం చేసే బలి పశువు కొవ్వుని బలిపీఠం పైన దహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","విడిచిపెట్టే మేకని వదిలి వచ్చిన వ్యక్తి తన బట్టలు ఉతుక్కుని స్నానం చేయాలి. ఆ తరువాత అతడు శిబిరంలోకి రావచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","పవిత్ర స్థలం లో పాపాల కోసం బలి చేసిన ఏ కోడె దూడ రక్తం, ఏ మేక రక్తం అతి పవిత్ర స్థలం లోకి తెచ్చారో ఆ కోడె దూడ, మేకల కళేబరాలను ఒకవ్యక్తి శిబిరం బయటకు తీసుకువెళ్ళాలి. అక్కడ వాటి చర్మాలనూ, మాంసాన్నీ, పేడనూ మంట పెట్టి కాల్చి వేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","వాటిని కాల్చిన వ్యక్తి తన బట్టలు ఉతుక్కుని స్నానం చేసి తిరిగి శిబిరంలోకి రావచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","మీరు ఏడో నెల పదో రోజున ఉపవాసం ఉండాలి. ఆ రోజు ఎలాంటి పనీ చేయకూడదు. స్థానిక ప్రజలకీ, మీ మధ్య నివసిస్తున్న విదేశీయులకీ ఇది వర్తిస్తుంది. ఇది మీకు నా శాశ్వతమైన శాసనం. ");
INSERT INTO tel2017_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ఎందుకంటే ఆ రోజు యెహోవా సమక్షంలో మిమ్మల్ని పవిత్రులుగా చేయడానికై మీ పాపాలకు శుద్ధీకరణ చేసేందుకు మీ కోసం పరిహారం జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","అది మీకు మహా విశ్రాంతి దినం. ఆ రోజు మీరు ఉపవాసం ఉండాలి. ఎలాంటి పనీ చేయకూడదు. ఇది మీకు నా శాశ్వతమైన శాసనం. ");
INSERT INTO tel2017_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","తన తండ్రి స్థానంలో ప్రతిష్ఠి జరిగి యాజకుడిగా అభిషేకం పొందిన వ్యక్తి పరిహారం చేసుకుని ప్రతిష్ఠి చేసిన నార బట్టలు వేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","అతడు అతి పవిత్ర స్థలానికి పరిహారం చేయాలి. ప్రత్యక్ష గుడారానికీ, బలిపీఠంకీ పరిహారం చేయాలి. యాజకుల కొరకూ, సమాజంలోని ప్రజలందరి కొరకూ పరిహారం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ఇశ్రాయేలు ప్రజల పాపాలన్నిటి కోసం సంవత్సరానికి ఒకసారి పరిహారం చేయాలి. ఇది మీకు శాశ్వతమైన శాసనం.” యెహోవా ఆదేశించిన ప్రకారం మోషే చేసాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","యెహోవా మోషేతో మాట్లాడి ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“నువ్వు అహరోనుతోనూ, అతని కొడుకులతోనూ, ఇశ్రాయేలు సమాజమంతటితోనూ ఇలా చెప్పు. ఇది యెహోవా ఆజ్ఞాపించిన మాట ");
INSERT INTO tel2017_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ఇశ్రాయేలు ప్రజల్లో ఎవరైనా బలి అర్పించడానికై ఒక ఎద్దుని గానీ, మేకని గానీ, గొర్రె పిల్లని గానీ పట్టుకుని శిబిరం లోపలైనా, బయటైనా చంపి, ");
INSERT INTO tel2017_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","దాన్ని యెహోవాకి అర్పించడానికి ప్రత్యక్ష గుడారం ద్వారం దగ్గరికి దాన్ని తీసుకు రాకపోతే అతడు రక్తం విషయంలో అపరాధి అవుతాడు. అతడు రక్తం చిందించాడు, కాబట్టి అలాంటి వాడు ప్రజల్లో లేకుండా పోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ఈ ఆదేశం వెనుక ఉన్న ఉద్దేశం ఇది. ఇశ్రాయేలు ప్రజలు ఇక పైన బలి అర్పించాలంటే బలి పశువులను ప్రత్యక్ష గుడారం ద్వారం దగ్గర యెహోవాకి శాంతిబలి అర్పణ చేయడానికి యాజకుని దగ్గరికి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","యాజకుడు ప్రత్యక్ష గుడారం ద్వారం దగ్గర ఉన్న యెహోవా బలిపీఠం పైన రక్తాన్ని చిమ్మాలి. యెహోవాకి కమ్మని సువాసన కలిగేట్టు కొవ్వుని దహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ఏ విగ్రహాలకు వాళ్ళు ఇంతకు ముందు వేశ్యల్లా ప్రవర్తించారో ఆ మేక రూపంలో ఉన్న విగ్రహాలకు ఇంతకు ముందులాగా బలులు అర్పించకూడదు. ఇది వాళ్ళ రాబోయే తరాలన్నిటికీ శాశ్వతమైన చట్టం. ");
INSERT INTO tel2017_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","నువ్వు వాళ్లకి ఇంకా ఇలా చెప్పు. ఇశ్రాయేలు జాతి వాడైనా, మీతో కలసి నివసించే విదేశీయుడైనా దహనబలిని గానీ, మరింకేదైనా బలి అర్పణ గానీ చేసి ");
INSERT INTO tel2017_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","దాన్ని ప్రత్యక్ష గుడారం దగ్గరికి యెహోవాకు అర్పించడానికి తీసుకు రాకపోతే ఆ వ్యక్తిని ప్రజల్లో లేకుండా చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ఇశ్రాయేలు జాతి వాడైనా, మీతో కలసి నివసించే విదేశీయుడైనా ఏరక్తాన్ని ఆహారంగా తీసుకుంటే నేను అలాంటి వాడికి విరోధంగా ఉంటాను. రక్తాన్నైనా ఆహారంగా తీసుకునే వాణ్ణి మనుషుల్లో లేకుండా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ఒక జంతువుకి ప్రాణం దాని రక్తమే. మీ ప్రాణాల కోసం పరిహారం చేయడానికి నేను రక్తాన్ని ఇచ్చాను. ఎందుకంటే రక్తమే పరిహారం చేస్తుంది. ప్రాణానికి పరిహారం చేసేది రక్తమే. ");
INSERT INTO tel2017_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","కాబట్టి ఇశ్రాయేలు ప్రజలైన మీలో ఎవరూ రక్తాన్ని ఆహారంగా తీసుకోకూడదని ఆదేశించాను. మీ మధ్య నివసించే ఏ విదేశీయుడూ రక్తాన్ని ఆహారంగా తీసుకోకూడదని ఆదేశించాను. ");
INSERT INTO tel2017_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","అలాగే ఇశ్రాయేలు ప్రజల్లో ఎవరైనా లేదా మీ మధ్య నివసించే ఏ విదేశీయుడైనా తినదగిన జంతువునో, పక్షినో వేటాడి చంపితే దాని రక్తాన్ని పారబోసి మట్టితో కప్పాలి. ఎందుకంటే ప్రతి ప్రాణికీ దాని రక్తమూ, ప్రాణమూ ఒక్కటే. రక్తం, ప్రాణంతో కలసి ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","కాబట్టి నేను ఇశ్రాయేలు ప్రజలకి ‘మీరు జంతువు రక్తాన్నీ ఆహారంగా తీసుకోకూడదు. ఎందుకంటే జీవులన్నిటికీ ప్రాణం వాటి రక్తంలోనే ఉంటుంది. దాన్ని తినేవాడు ప్రజల్లో లేకుండా తీసివేస్తాను’ అని ఆదేశించాను. ");
INSERT INTO tel2017_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","స్థానికుడైనా, మీ మధ్యలో నివసించే విదేశీయుడైనా చనిపోయిన జంతువునో లేదా మృగాలు చీల్చివేసిన జంతువునో ఆహారంగా తీసుకుంటే, అతడు తన బట్టలు ఉతుక్కోవాలి. స్నానం చేయాలి. అతడు సాయంత్రం వరకూ అశుద్ధుడుగా ఉంటాడు. తరువాత అతడు శుద్ధుడు అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ఒకవేళ అతడు బట్టలు ఉతుక్కోకుండా, స్నానం చేయకుండా ఉంటే అపరాధిగా ఉండిపోతాడు.” ");
INSERT INTO tel2017_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“నేను మీ దేవుడైన యెహోవాను అని నీవు ఇశ్రాయేలీయులతో చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","మీరు నివసించిన ఐగుప్తు దేశాచారాల ప్రకారం మీరు చేయకూడదు. నేను మిమ్మల్ని రప్పిస్తున్న కనాను దేశాచారాల ప్రకారం మీరు చేయకూడదు. వారి మతాచారాలను అనుసరించ కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","మీరు నా విధులను పాటించాలి. నా చట్టాల ప్రకారం నడుచుకుంటూ వాటిని ఆచరించాలి. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","మీరు నా చట్టాలను నా విధులను ఆచరించాలి. వాటిని పాటించే వాడు వాటి వలన జీవిస్తాడు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","మీలో ఎవరూ తమ రక్తసంబంధులతో లైంగిక సంబంధం పెట్టుకోకూడదు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","నీ తండ్రికి గౌరవదాయకం గా ఉన్న నీ తల్లితో లైంగిక సంబంధం పెట్టుకోకూడదు ఆమె నీ తల్లి. ఆమెతో లైంగిక సంబంధం పెట్టుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","నీ తండ్రి భార్యతో లైంగిక సంబంధం పెట్టుకోకూడదు. అలా చేసి నీ తండ్రిని అగౌరవ పరచకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","నీ సోదరితో అంటే ఇంట్లో పుట్టినా బయట పుట్టినా నీ తండ్రి కుమార్తెతోనైనా నీ తల్లి కుమార్తెతోనైనా లైంగిక సంబంధం పెట్టుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","నీ కుమారుడి కుమార్తెతో గానీ కుమార్తె కుమార్తెతోగానీ లైంగిక సంబంధం పెట్టుకోకూడదు. అది నీ గౌరవమే. ");
INSERT INTO tel2017_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","నీ తండ్రికి పుట్టిన నీ తండ్రి భార్య కుమార్తె నీ సోదరి. ఆమెతో లైంగిక సంబంధం పెట్టుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","నీ తండ్రి సోదరితో లైంగిక సంబంధం పెట్టుకోకూడదు. ఆమె నీ తండ్రి రక్తసంబంధి. ");
INSERT INTO tel2017_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","నీ తల్లి సోదరితో లైంగిక సంబంధం పెట్టుకోకూడదు. ఆమె నీ తల్లి రక్తసంబంధి. ");
INSERT INTO tel2017_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","నీ తండ్రి సోదరుని భార్యతో లైంగిక సంబంధం పెట్టుకోవడం ద్వారా అతనిని అగౌరవ పరచ కూడదు. అంటే అతని భార్యను ఆ ఉద్దేశంతో సమీపించ కూడదు. ఆమె నీ పినతల్లి. ");
INSERT INTO tel2017_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","నీ కోడలితో లైంగిక సంబంధం పెట్టుకోకూడదు. ఆమె నీ కుమారుడి భార్య. ఆమెతో లైంగిక సంబంధం పెట్టుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","నీ సోదరుని భార్యతో లైంగిక సంబంధం పెట్టుకో కూడదు. అది నీ సోదరుని గౌరవం. ");
INSERT INTO tel2017_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ఒక స్త్రీతోనూ ఆమె కూతురితోనూ లైంగిక సంబంధం పెట్టుకోకూడదు. నీకు లైంగిక సంబంధం ఉన్న స్త్రీ కుమారుడి కూతురుతోగానీ ఆమె కూతురు కూతురుతో గానీ లైంగిక సంబంధం పెట్టుకునేందుకు వారిని చేర దీయకూడదు. వారు ఆమె రక్తసంబంధులు. అది దుర్మార్గం. ");
INSERT INTO tel2017_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","నీ భార్య బతికి ఉండగానే ఆమెను బాధించాలని ఆమె సోదరితో లైంగిక సంబంధం పెట్టుకోవాలని ఆమెను పెళ్లాడకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","ఋతుస్రావం వలన స్త్రీ బయట ఉన్నప్పుడు ఆమెతో లైంగిక సంబంధం పెట్టుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","నీ పొరుగువాడి భార్యతో లైంగిక సంబంధం పెట్టుకుని ఆమె మూలంగా అపవిత్రం కాకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","నీవు నీ సంతానాన్ని మోలెకు దేవుడి కోసం అగ్నిగుండంలో ఎంత మాత్రం అర్పించకూడదు. నీ దేవుని నామాన్ని అపవిత్ర పరచకూడదు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","స్త్రీతో లైంగిక సంబంధం ఉన్నట్టు పురుషునితో ఉండకూడదు. అది అసహ్యం. ");
INSERT INTO tel2017_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ఏ జంతువుతోనూ లైంగిక సంబంధం పెట్టుకుని దాని వలన అపవిత్రం కాకూడదు. ఏ స్త్రీ కూడా జంతువుతో లైంగిక సంబంధం పెట్టుకోకూడదు. అది భ్రష్టత్వం. ");
INSERT INTO tel2017_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","వీటిలో దేనివలనా మీరు అపవిత్రులు కాకూడదు. నేను మీ ఎదుటి నుండి వెళ్ల గొట్టబోతున్న జాతులు ఇలాంటి పనులు చేసి భ్రష్టులయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ఆ దేశం అపవిత్రమై పోయింది. గనక నేను దానిపై దాని దోష శిక్షను విధిస్తున్నాను. ఆ దేశం తనలో నివసిస్తున్న వారిని బయటికి కక్కివేస్తున్నది. ");
INSERT INTO tel2017_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","కాబట్టి ఆ దేశంలో మీకంటే ముందు అక్కడ నివసించిన ప్రజలను ఆ దేశం కక్కివేసిన ప్రకారం మీ అపవిత్రతను బట్టి మిమ్మల్ని కక్కి వేయకుండేలా ");
INSERT INTO tel2017_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","మీరు గానీ మీలో నివసించే పరదేశి గాని యీ అసహ్యమైన క్రియల్లో దేన్నీ చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","నా చట్టాలను, నా విధులను ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","అలాటి అసహ్యమైన పనుల్లో దేనినైనా చేసేవారు ప్రజల్లో లేకుండా పోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","కాబట్టి మీకంటే ముందుగా అక్కడ నివసించిన వాళ్ళు పాటించిన అసహ్యమైన ఆచారాల్లో దేనినైనా పాటించి అపవిత్రులై పోకుండా నేను మీకు విధించిన నియమాలను అనుసరించి నడుచుకోవాలి. నేను మీ దేవుణ్ణి. యెహోవాను.” ");
INSERT INTO tel2017_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","యెహోవా మోషేకు ఇంకా ఇలా ఆజ్ఞాపించాడు. ఇశ్రాయేలీయుల సమాజమంతటితో ఇలా చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“మీరు పరిశుద్ధంగా ఉండాలి. ఎందుకంటే మీ దేవుడైన యెహోవా అనే నేను పరిశుద్ధుడిని. ");
INSERT INTO tel2017_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","మీలో ప్రతివాడూ తన తల్లిని తన తండ్రిని గౌరవించాలి. నేను నియమించిన విశ్రాంతి దినాలను ఆచరించాలి. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","మీరు పనికిమాలిన దేవుళ్ళ వైపు తిరగకూడదు. మీరు పోత విగ్రహాలను చేసుకోకూడదు. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","మీరు యెహోవాకు సమాధాన బలి అర్పించేటప్పుడు అది అంగీకారయోగ్యమయ్యేలా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","మీరు బలిమాంసాన్ని బలి అర్పించిన రోజైనా, మరునాడైనా దాన్ని తినాలి. మూడో రోజు దాకా మిగిలి ఉన్న దాన్ని పూర్తిగా కాల్చివేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","మూడో రోజున దానిలో కొంచెం తిన్నా సరే, అది అసహ్యం. అది ఆమోదం కాదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","మూడో రోజున దాన్ని తినేవాడు తన దోషశిక్షను భరిస్తాడు. వాడు యెహోవాకు పరిశుద్ధమైన దాన్ని అపవిత్ర పరిచాడు కదా. వాడిని ప్రజల్లో లేకుండా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","మీరు మీ పొలం పంట కోసేటప్పుడు నీ పొలం మూలల్లొ పూర్తిగా కోయకూడదు. నీ కోతలో పరిగె ఏరుకోకూడదు. నీ పండ్ల చెట్ల పరిగెను సమకూర్చుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","నీ ద్రాక్ష తోటలో పండ్లన్నిటినీ సేకరించుకో కూడదు. ద్రాక్ష తోటలో రాలిన పండ్లను ఏరుకోకూడదు. పేదలకు, పరదేశులకు వాటిని విడిచిపెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","నేను మీ దేవుడైన యెహోవాను. మీరు దొంగతనం చేయకూడదు. అబద్ధం ఆడకూడదు. ఒకడినొకడు దగా చెయ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","నా నామం పేరిట అబద్ధంగా ఒట్టు పెట్టుకోకూడదు. నీ దేవుని పేరును అపవిత్ర పరచకూడదు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","నీ పొరుగు వాణ్ణి పీడించకూడదు. అతణ్ణి దోచుకోకూడదు. కూలివాడి కూలీ డబ్బు మరునాటి వరకూ నీ దగ్గర ఉంచుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","చెవిటివాణ్ణి తిట్ట కూడదు. గుడ్డివాడి దారిలో అడ్డంకులు వేయకూడదు. నీ దేవునికి భయపడాలి. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","అన్యాయ తీర్పు తీర్చకూడదు. బీదవాడని పక్షపాతం చూపకూడదు. గొప్పవాడని అభిమానం చూపకూడదు. నీ పొరుగువాడి పట్ల న్యాయంగా ప్రవర్తించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","నీ ప్రజల మధ్య కొండేలు చెబుతూ ఇంటింటికి తిరగకూడదు. ఎవరికైనా ప్రాణ హాని కలిగించేది ఏదీ చెయ్యవద్దు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","నీ హృదయంలో నీ సోదరుణ్ణి అసహ్యించుకోకూడదు. నీ పొరుగువాడి పాపం నీ మీదికి రాకుండేలా నీవు తప్పకుండా అతణ్ణి గద్దించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","పగ సాధించ వద్దు. ఎవరిమీదా కక్ష పెట్టుకోవద్దు. నిన్ను నీవు ప్రేమించుకున్నట్టే నీ సాటి మనిషిని ప్రేమించాలి. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","మీరు నా శాసనాలను పాటించాలి. నీ జంతువులకు ఇతర జాతి జంతువులతో సంపర్కం చేయకూడదు. నీ పొలంలో వేరు వేరు జాతుల విత్తనాలు చల్లకూడదు. రెండు రకాల దారాలతో నేసిన బట్టలు ధరించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ఒక బానిస పిల్లలు ఒకడితో నిశ్చితార్థం జరిగాక ఆమెను వెల ఇచ్చి విడిపించకుండా, లేదా ఆమెకు విముక్తి కలగక ముందు ఎవరైనా ఆమెతో లైంగిక సంబంధం పెట్టుకుంటే అలాటి వాణ్ణి శిక్షించాలి. ఆమెకు విడుదల కలగలేదు గనక వారికి మరణశిక్ష విధించ కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","అతడు అపరాధ పరిహార బలిని, అంటే అపరాధ పరిహార బలిగా ఒక పొట్టేలును ప్రత్యక్ష గుడార ద్వారానికి యెహోవా సన్నిధికి తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","అప్పుడు యాజకుడు అతడు చేసిన పాపాన్నిబట్టి పాప పరిహార బలిగా ఆ పొట్టేలు మూలంగా యెహోవా సన్నిధిలో అతని కోసం ప్రాయశ్చిత్తం చేయాలి. ఈ విధంగా అతడు చేసిన పాపం విషయమై అతనికి క్షమాపణ కలుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","మీరు ఆ దేశానికి వచ్చి తినడానికి రకరకాల చెట్లు నాటినప్పుడు వాటి పండ్లను నిషేధంగా ఎంచాలి. మూడు సంవత్సరాల పాటు అవి మీకు అపవిత్రంగా ఉండాలి. వాటిని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","నాలుగో సంవత్సరంలో వాటి పండ్లన్నీ యెహోవాకు ప్రతిష్ఠితమైన స్తుతి అర్పణలుగా ఉంటాయి. ఐదో సంవత్సరంలో వాటి పండ్లను తినొచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","రక్తం కలిసి ఉన్న మాంసం తినకూడదు. శకునాలు చూడకూడదు. మంత్ర ప్రయోగం ద్వారా ఇతరులను వశపరచుకోడానికి చూడకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","విగ్రహ పూజలు చేసే ఇతర జనాల్లాగా మీ తల పక్క భాగాలు గానీ నీ గడ్డం అంచులు గానీ గుండ్రంగా గొరిగించుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","చచ్చిన వారి కోసం మీ దేహాన్ని గాయపరచుకోకూడదు. ఒంటిపై పచ్చబొట్లు పొడిపించుకోకూడదు. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","నీ కూతురిని వేశ్యగా చేసి ఆమెను హీనపరచకూడదు. అలా చేస్తే మీ దేశం వ్యభిచారంలో పడిపోతుంది. మీ ప్రాంతం కాముకత్వంతో నిండిపోతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","నేను నియమించిన విశ్రాంతి దినాలను మీరు ఆచరించాలి. నా పరిశుద్ధ మందిరాన్ని గౌరవించాలి. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","చచ్చిన ఆత్మలతో మాట్లాడుతామని చెప్పే వారి దగ్గరికి సోదె చెప్పేవారి దగ్గరికి పోకూడదు. అలా చేస్తే వారివలన మీరు అపవిత్రులౌతారు. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","తల నెరసిన ముసలివాడి ఎదుట లేచి నిలబడి అతని ముఖాన్ని గౌరవించాలి. నీ దేవునికి భయపడాలి. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","మీ దేశంలో పరదేశి ఎవరైనా మీ మధ్య నివసించేటప్పుడు అతణ్ణి బాధ పెట్టకూడదు, ");
INSERT INTO tel2017_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","మీ మధ్య నివసించే పరదేశిని మీలో పుట్టినవాడి లాగానే ఎంచాలి. నిన్ను నీవు ప్రేమించుకున్నట్టే అతణ్ణి ప్రేమించాలి. ఐగుప్తులో మీరు పరదేశులుగా ఉన్నారు గదా. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","కొలతలోగాని తూనికలోగాని పరిమాణంలో గాని మీరు అన్యాయం చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","న్యాయమైన త్రాసులు న్యాయమైన బరువులు, న్యాయమైన కొల పాత్రలు న్యాయమైన పడి మీకుండాలి. నేను ఐగుప్తులోనుండి మిమ్మల్ని రప్పించిన మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","మీరు నా శాసనాలన్నిటిని నా విధులన్నిటిని పాటించాలి. నేను యెహోవాను.” ");
INSERT INTO tel2017_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. “నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ఇశ్రాయేలీయుల్లో గానీ ఇశ్రాయేలు ప్రజల్లో నివసించే పరదేశుల్లోగాని ఎవరైనా తన పిల్లలను మోలెకు దేవుడికి ఇస్తే వాడికి తప్పకుండా మరణ శిక్ష విధించాలి. ప్రజలు వాణ్ణి రాళ్లతో కొట్టి చంపాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","అతడు తన సంతానాన్ని మోలెకుకు ఇచ్చి నా పరిశుద్ధ స్థలాన్ని అపవిత్రపరచి నా పవిత్ర నామాన్ని కలుషితం చేశాడు గనక నేను అతనికి శత్రువునై ప్రజల్లో అతడు లేకుండా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ఆ వ్యక్తి తన సంతానాన్ని మోలెకుకు ఇస్తుండగా మీ దేశ ప్రజలు చూసి కూడా కళ్ళు మూసుకుంటే, వాణ్ణి చంపక పొతే ");
INSERT INTO tel2017_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","అప్పుడు నేనే వాడికి, వాడి వంశానికి విరోధినై వాణ్ణి ప్రజల్లో లేకుండా చేస్తాను. మోలెకుతో వేశ్యరికం చెయ్యడానికి వాడి వెంటబడి వ్యభిచారం చేసే వారందరినీ ప్రజల్లో లేకుండా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","చచ్చిన వారితో మాట్లాడుతామని చెప్పేవారితో సోదె చెప్పే వారితో వేశ్యరికం చెయ్యడానికి వారివైపు తిరిగే వారికి నేను విరోధినై ప్రజల్లో వాణ్ణి లేకుండా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","కాబట్టి మిమ్మల్ని మీరు దేవునికి ప్రతిష్టించుకుని పవిత్రంగా ఉండండి. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","మీరు నా శాసనాలను పాటించి వాటి ప్రకారం చెయ్యాలి. నేను మిమ్మల్ని పవిత్ర పరచే యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","ఎవడు తన తండ్రినిగానీ తన తల్లినిగానీ దూషిస్తాడో వాడికి మరణశిక్ష విధించాలి. వాడు తన తండ్రినో తల్లినో దుర్భాషలాడాడు గనక అతడు దోషి, మరణ శిక్షకు పాత్రుడు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","వేరొకడి భార్యతో వ్యభిచరించిన వాడికి, అంటే తన పొరుగు వాడి భార్యతో లైంగిక సంబంధం పెట్టుకున్న వాడికి-ఆ వ్యభిచారికి, వ్యభిచారిణికి మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","తన తండ్రి భార్యతో లైంగిక సంబంధం కోసం ఆమెతో పండుకున్న వాడు తన తండ్రి గౌరవాన్ని భంగపరిచాడు. వారిద్దరికీ మరణశిక్ష విధించాలి. వారు తమ శిక్షకు తామే కారకులు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ఒకడు తన కోడలితో లైంగిక సంబంధం పెట్టుకుంటే వారిద్దరికీ మరణశిక్ష విధించాలి. వారు వరసలు తప్పారు. వారు దోషులు. మరణ శిక్షకు పాత్రులు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ఒకడు స్త్రీతో పెట్టుకున్నట్టు పురుషుడితో లైంగిక సంబంధం పెట్టుకుంటే వారిద్దరూ అసహ్య కార్యం చేశారు గనక వారికి మరణశిక్ష విధించాలి. వారు దోషులు, మరణ శిక్షకు పాత్రులు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ఒకడు స్త్రీని పెళ్ళాడి ఆమె తల్లిని కూడా పెళ్లాడితే అది దుర్మార్గం. అతణ్ణి, ఆ స్త్రీలను సజీవ దహనం చెయ్యాలి. ఆ విధంగా మీ మధ్యనుండి దుర్మార్గత తొలిగిపోతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ఎవరైనా జంతువుతో లైంగిక సంబంధం పెట్టుకుంటే వాడికి తప్పక మరణ శిక్ష విధించాలి. ఆ జంతువును చంపాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","జంతువుతో ఒక స్త్రీ లైంగికంగా కలవడం కోసం దాని దగ్గరికి పోతే ఆ స్త్రీని ఆ జంతువును చంపాలి. ఆమెకు దానికి తప్పక మరణ శిక్ష పడాలి. వారు దోషులు, మరణ శిక్షకు పాత్రులు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ఒకడు తన సోదరితో, అంటే తన తండ్రి కుమార్తెతో గానీ తన తల్లి కుమార్తెతో గానీ లైంగిక సంబంధం పెట్టుకుంటే అది సిగ్గుచేటు. తమ జాతి వారి సమక్షంలో వారిని ప్రజల్లో లేకుండా చెయ్యాలి. వాడు తన సోదరితో లైంగిక సంబంధం పెట్టుకున్నాడు. తన దోష శిక్షను తాను భరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ఒక స్త్రీ ఋతుస్రావం సమయంలో ఆమెతో లైంగిక సంబంధం పెట్టుకుంటే ఆమె రక్త స్రావాన్ని, రక్తధారను బట్టబయలు చేసాడు. ప్రజల్లో నుండి వారిద్దరినీ లేకుండా చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","నీ తల్లి సోదరితో గాని నీ తండ్రి సోదరితో గానీ లైంగిక సంబంధం పెట్టుకోకూడదు. ఎందుకంటే అలా చేస్తే నీవు నీ దగ్గర బంధువును హీన పరిచావు. నీ దోషశిక్షను భరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","బాబాయి భార్యతో గానీ మేనమామ భార్యతో గానీ లైంగిక సంబంధం పెట్టుకున్నవాడు తన దగ్గర బంధువును హీనపరిచాడు. వారు తమ పాపశిక్షను భరించాలి. వారు పిల్లలు లేకుండా చనిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ఒకడు తన సోదరుని భార్యను పెళ్లాడితే అది అశుద్ధం. ఎందుకంటే వాడు తన సోదరుని వివాహబంధాన్ని మీరాడు. వారు సంతాన హీనులుగా ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","కాబట్టి మీరు నివసించాలని నేను ఏ దేశానికి మిమ్మల్ని తీసుకు పోతున్నానో ఆ దేశం మిమ్మల్ని కక్కివేయకుండేలా మీరు నా శాసనాలన్నిటిని, నా విధులన్నిటిని పాటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","నేను మీ ఎదుట నుండి వెళ్లగొడుతున్న జాతుల ఆచారాల ప్రకారం నడుచుకోకూడదు. వారు అలాటి క్రియలన్నీ చేశారు కాబట్టి నేను వారిని అసహ్యించుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","నేను మీతో చెప్పాను. మీరు వారి భూమిని వారసత్వంగా పొందుతారు. పాలు తేనెలు ప్రవహించే ఆ దేశాన్ని మీరు స్వాధీన పరచుకునేందుకై మీకిస్తాను. జాతుల్లో నుండి మిమ్మల్ని వేరు చేసిన మీ దేవుడైన యెహోవాను నేనే. ");
INSERT INTO tel2017_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","కాబట్టి మీరు శుద్ధ జంతువులకు, అశుద్ధ జంతువులకు, శుద్ధ పక్షులకు, అశుద్ధ పక్షులకు అంతరం తెలుసుకోవాలి. అశుద్ధమైనదని నేను మీకు వేరు చేసి చెప్పిన ఏ జంతువు మూలంగా గానీ ఏ పక్షి మూలంగా గానీ, నేల మీద పాకే దేని మూలంగా గానీ మిమ్మల్ని మీరు అపవిత్ర పరచుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","మీరు నాకు పరిశుద్ధులై ఉండాలి. ఎందుకంటే యెహోవా అనే నేను పరిశుద్ధుడిని. మీరు నావారై ఉండేలా అన్య జనుల్లో నుండి మిమ్మల్ని వేరు చేశాను. ");
INSERT INTO tel2017_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","పురుషుడుగానీ స్త్రీగానీ పూనకం వచ్చి చచ్చిన వారితో, ఆత్మలతో మాట్లాడే వాళ్ళు ఉంటే వారికి తప్పక మరణ శిక్ష విధించాలి. ప్రజలు వారిని రాళ్లతో కొట్టాలి. వారు దోషులు, మరణ పాత్రులు.” ");
INSERT INTO tel2017_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","యెహోవా మోషేతో ఇలా అన్నాడు. “యాజకులైన అహరోను కొడుకులతో ఇలా చెప్పు. మీలో ఎవరూ మీ ప్రజల్లో శవాన్ని ముట్టుకుని తనను అపవిత్రం చేసుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","అయితే తన రక్త సంబంధులు, అంటే తల్లి, తండ్రి, కొడుకు, కూతురు, సోదరుడు, ");
INSERT INTO tel2017_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","తన ఇంట్లో నివసిస్తున్న పెండ్లి కానీ కన్య అయిన సోదరి గానీ చనిపోతే ఆ శవాన్ని తాకడం వల్ల తనను అపవిత్ర పరచుకోవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","యాజకుడు తన భార్య తరుపు బంధువుల కోసం తనను అపవిత్ర పరచుకుని మైల పడకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","యాజకులు బోడిగుండు చేసుకోకూడదు. గడ్డం పక్కలను క్షవరం చేసుకో కూడదు. కత్తితో శరీరాన్ని గాట్లు పెట్టుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","వారు తమ దేవునికి ప్రతిష్ఠితమైనవారుగా ఉండాలి. తమ దేవుని నామాన్ని అప్రదిష్ట పాలు చెయ్యకూడదు. ఎందుకంటే వారు తమ దేవునికి ‘నైవేద్యం’ అంటే యెహోవాకు హోమద్రవ్యాలు అర్పించే వారు. కాబట్టి వారు పవిత్రంగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","వారు వేశ్యను గానీ చెడిపోయిన దాన్ని గానీ పెళ్లాడకూడదు. భర్త విడాకులు ఇచ్చిన స్త్రీని పెళ్లి చేసుకోకూడదు. ఎందుకంటే యాజకుడు తన దేవునికి ప్రతిష్ఠితుడు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","అతడు నీ దేవుడికి ‘నైవేద్యం’ అర్పించే వాడు గనక నీవు అతణ్ణి పరిశుద్ధపరచాలి. మిమ్మల్ని పరిశుద్ధ పరిచే యెహోవా అనే నేను పవిత్రుణ్ణి గనక అతడు మీ దృష్టికి పవిత్రుడుగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","యాజకుని కూతురు వేశ్యగా తనను అపవిత్రపరచు కున్నట్టైతే ఆమె తన తండ్రికి అప్రదిష్ట తీసుకువస్తుంది. ఆమెను సజీవ దహనం చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","సోదరుల్లో ప్రధాన యాజకుడు కావడానికి ఎవరి తలమీద అభిషేక తైలం పోస్తారో, ప్రధాన యాజక దుస్తులు ధరించడానికి ఎవరు ప్రతిష్ట అవుతారో అతడు తన జుట్టు విరబోసుకోకూడదు. తన బట్టలు చింపుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","అతడు శవం ఉన్న చోటికి పోకూడదు. తన తండ్రి శవం మూలంగా గానీ తన తల్లి శవం మూలంగా గానీ మైల పడకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ప్రధానయాజకుడు పరిశుద్ధమందిరాన్ని విడిచి వెళ్లకూడదు. తన దేవుని పరిశుద్ధ మందిరాన్ని మైల పడేలా చెయ్యకూడదు. ఎందుకంటే తన దేవుని అభిషేక తైలం వల్ల అతడు ప్రధాన యాజకునిగా అభిషేకం పొందాడు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","అతడు కన్యను మాత్రమే పెళ్ళాడాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","వితంతువును గానీ విడాకులు తీసుకున్న స్త్రీని గానీ వేశ్యను గానీ అలాటి వారిని కాక తన ప్రజల్లోని కన్యనే పెళ్లాడాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","అతడు ఈ నియమాలు పాటించాలి. యెహోవా అనే నేను అతణ్ణి పవిత్రపరిచే వాణ్ణి గనక అతడు తన ప్రజల్లో తన సంతానాన్ని అపవిత్ర పరచకూడదు.” ");
INSERT INTO tel2017_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“నీవు అహరోనుతో ఇలా చెప్పు. నీ సంతానంలో ఎవరికైనా కళంకమేదైనా కలిగితే అతడు తన దేవుడికి నైవేద్యం అర్పించడానికి సమీపించ కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ఎందుకంటే ఎవరిలో కళంకం ఉంటుందో, అంటే వాడు గుడ్డి వాడైనా, కుంటివాడైనా, వికృత రూపి అయినా, ");
INSERT INTO tel2017_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","కాలు గానీ చెయ్యి గానీ అవిటితనం ఉన్నా, ");
INSERT INTO tel2017_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","గూనివాడైనా, మరుగుజ్జువాడైనా, కంటి దోషం లేక జబ్బు ఉన్నవాడైనా, గజ్జి, పక్కు ఉన్నవాడైనా వృషణాలు నలిగినవాడైనా అలాంటివాడు సమీపించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","యాజకుడైన అహరోను సంతానంలో అవిటితనం గలవారెవరూ యెహోవాకు హోమద్రవ్యాలు అర్పించడానికి దగ్గరికి రాకూడదు. అతడు అవిటి వాడు. అలాటి వాడు తన దేవునికి నైవేద్యం పెట్టడానికి దగ్గరికి రాకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","అతి పరిశుద్ధమైనవిగాని, పరిశుద్ధమైనవిగాని, తన దేవునికి అర్పించే ఏ ఆహార వస్తువులైనా అతడు తినొచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","మొత్తం మీద అతడు అవిటితనం గలవాడు గనక అడ్డతెర ఎదుటికి అతడు రాకూడదు. బలిపీఠం సమీపించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","నా పరిశుద్ధ స్థలాలను అపవిత్రపరచకూడదు. వారిని పరిశుద్ధ పరిచే యెహోవాను నేనే అని వారితో చెప్పు.” మోషే ఈ విధంగా అహరోనుతో, అతని కొడుకుల తో ఇశ్రాయేలీయులందరితో ఈ విషయాలు చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“అహరోనుతో అతని కొడుకులతో ఇది చెప్పు. వారు ఇశ్రాయేలీయులు నాకు ప్రతిష్ఠించే వాటిని ప్రత్యేకమైనవిగా భావించాలి. వారు నా పరిశుద్ధ నామాన్ని అపవిత్ర పరచకూడదు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","నీవు వారితో ఇలా చెప్పు. మీ తరతరాలకు మీ సంతతి వారందరిలో ఒకడు అపవిత్రంగా ఉండి ఇశ్రాయేలీయులు యెహోవాకు ప్రతిష్ఠించే వాటిని సమీపిస్తే అలాంటి వాణ్ణి నా సన్నిధిలో ఉండకుండాా దూరంగా కొట్టివేస్తాను. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","అహరోను సంతానంలో ఎవరికైనా కుష్టువ్యాధి గానీ, శరీరం నుండి రసి లాంటిది కారడం గానీ ఉంటే అలాటి వాడు పవిత్రుడయ్యే వరకూ ప్రతిష్ఠితమైన వాటిలో దేనినీ తినకూడదు. శవాన్ని తాకడం వల్లా, అపవిత్రమైన దేనినైనా ముట్టుకోవడం వల్లా, వీర్యస్కలనం చేసిన వాణ్ణి తాకడం వల్లా, ");
INSERT INTO tel2017_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","అపవిత్రమైన పురుగును, లేక ఏదో ఒక అపవిత్రత మూలంగా అపవిత్రుడైపోయిన మనిషిని ముట్టుకోవడం వల్లా, అలాటి అపవిత్రత తగిలినవాడు సాయంత్రం వరకూ అపవిత్రుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","అతడు నీళ్లతో తన ఒళ్ళు కడుక్కునే వరకూ ప్రతిష్ఠితమైన వాటిని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","సూర్యుడు అస్తమించినప్పుడు అతడు పవిత్రుడౌతాడు. ఆ తరువాత అతడు ప్రతిష్ఠితమైన వాటిని తినవచ్చు. అవి అతనికి ఆహారమే గదా. ");
INSERT INTO tel2017_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","అతడు చచ్చిన జంతువును గానీ, మృగాలు చీల్చిన వాటిని గాని తిని దాని వలన తనను అపవిత్ర పరచుకోకూడదు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","కాబట్టి నేను విధించిన నియమాన్ని మీరి, దాని పాపదోషం తనపై వేసుకుని దాని వలన చావకుండేలా చూసుకోవాలి. నేను వారిని పరిశుద్ధ పరిచే యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","ప్రతిష్ఠితమైన దాన్ని యూదులు కాని వారు తినకూడదు. యాజకుని ఇంట్లో నివసించే అన్యుడు గాని, సేవకుడు గాని ప్రతిష్ఠితమైన దాన్ని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","అయితే యాజకుడు తన డబ్బుతో కొనుక్కున్న వాడు, అతని ఇంట్లో పుట్టినవాడు అతడు తినే ఆహారం తినవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","యాజకుని కుమార్తెను అన్యునికి ఇచ్చి పెళ్లి చేస్తే ఆమె ప్రతిష్ఠితమైన అర్పణల్లో దేనినీ తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","యాజకుని కుమార్తెల్లో వితంతువుగానీ, విడాకులు తీసుకున్నది గానీ పిల్లలు పుట్టక పోవడం వల్ల ఆమె తన బాల్యప్రాయంలో వలె తన తండ్రి యింటికి తిరిగి చేరితే తన తండ్రి ఆహారాన్ని తినవచ్చు. అన్యుడు మాత్రం దాన్ని తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ఒకడు పొరబాటున ప్రతిష్ఠితమైన దాన్ని తింటే వాడు ఆ ప్రతిష్ఠితమైన దాని విలువలో ఐదో వంతు కలిపి యాజకునికి తిరిగి ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ఇశ్రాయేలీయులు ప్రతిష్ఠితమైన వాటిని తినడం వలన అపరాధాన్ని భరించకుండా ఉండాలంటే తాము యెహోవాకు ప్రతిష్ఠించే పరిశుద్ధ వస్తువులను అపవిత్ర పరచకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","నేను అర్పణలను పరిశుద్ధ పరచే యెహోవానని చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“నీవు అహరోనుతో, అతని కొడుకులతో, ఇశ్రాయేలీయులందరితో ఇలా చెప్పు. ఇశ్రాయేలీయుల కుటుంబాల్లో గానీ ఇశ్రాయేలీయుల్లో నివసించే పరదేశుల్లోగాని యెహోవాకు దహన బలి అర్పించదలిస్తే అది స్వేచ్ఛార్పణగానివ్వండి, మొక్కుబడి గానివ్వండి ");
INSERT INTO tel2017_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ఆ అర్పణ దేవుడు అంగీకరించేలా ఆవుల్లో నుండి గానీ, గొర్రె మేకల్లో నుండి గానీ దోషంలేని మగదాన్ని అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","కళంకం ఉన్న దాన్ని అర్పించ కూడదు. అది అంగీకారం కాదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ఒకడు మొక్కుబడిగా స్వేచ్ఛార్పణంగా అర్పించడానికి శాంతి బలిగా ఆవునైనా గొర్రెనైనా మేకనైనా యెహోవాకు తెస్తే ఆయన దాన్ని అంగీకరించేలా అది దోషం లేనిదై ఉండాలి. దానిలో కళంకమేదీ ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","గుడ్డిదాన్ని గానీ కుంటిదాన్ని గానీ, పాడైపోయిన దాన్ని గానీ, గడ్డలు, గజ్జి, కురుపులు ఉన్న దాన్ని గానీ యెహోవాకు అర్పించకూడదు. అలాంటివి దేన్నీ బలివేదికపై యెహోవాకు హోమం చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","అంగవైకల్యం గల కోడెదూడనైనా గొర్రెల మేకల మందలోని దాన్నైనా స్వేచ్ఛార్పణంగా అర్పించవచ్చు గానీ మొక్కుబడిగా మాత్రం అది అంగీకారం కాదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","గాయపడిన, నలిగిన, మృగాలు చీల్చిన, వృషణాలు చితక గొట్టిన జంతువును యెహోవాకు అర్పించకూడదు. మీ దేశంలో అలాంటివి అర్పించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","విదేశీయుల దగ్గర నుండి అలాటి వాటిని తీసుకుని మీ దేవుడికి నైవేద్యంగా అర్పించకూడదు. అవి లోపం గలవి, వాటికి కళంకం ఉంది. మీ పక్షంగా దేవుడు వాటిని అంగీకరించడు, అని చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","యెహోవా మోషేకు ఇంకా ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“దూడగాని, గొర్రెపిల్లగాని, మేకపిల్లగాని పుట్టినప్పుడు అది ఏడు రోజులు దాని తల్లితో ఉండాలి. ఎనిమిదవ రోజు మొదలు అది యెహోవాకు హోమంగా అంగీకారమే. ");
INSERT INTO tel2017_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","అయితే అది ఆవైనా గొర్రె మేకలైనా మీరు దాన్ని, దాని పిల్లను ఒక్క నాడే వధించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","మీరు కృతజ్ఞత బలిగా ఒక పశువును వధించినప్పుడు అది మీ కోసం అంగీకారం అయ్యేలా దాన్ని అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ఆనాడే దాని తినెయ్యాలి. మరుసటి రోజు దాకా దానిలో కొంచెమైనా మిగల్చకూడదు. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","మీరు నా ఆజ్ఞలను అనుసరిస్తూ వాటి ప్రకారం నడుచుకోవాలి. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","నా పరిశుద్ధ నామాన్ని అపవిత్రపరచకూడదు, నేను ఇశ్రాయేలీయుల్లో నన్ను పరిశుద్ధునిగా చేసుకుంటాను. నేను మిమ్మల్ని పరిశుద్ధ పరిచే యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","నేను మీకు దేవుడనై ఉండేలా ఐగుప్తు దేశంలోనుండి మిమ్మల్ని రప్పించిన యెహోవాను అని చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు. మీరు చాటించ వలసిన యెహోవా నియామక కాలాలు ఇవే. ఈ కాలాల్లో మీరు పరిశుద్ధ సమూహాలుగా సమకూడాలి. నా నియామక కాలాలు ఇవి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ఆరు రోజులు పనిచెయ్యాలి. వారంలో ఏడవ రోజు విశ్రాంతి దినం. అది పరిశుద్ధ సంఘ దినం. అందులో మీరు ఏ పనీ చేయకూడదు. మీ ఇళ్ళన్నిటిలో అది యెహోవా నియమించిన విశ్రాంతి దినం. ");
INSERT INTO tel2017_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","ఇవి యెహోవా నియామక కాలాలు. వాటిని బట్టి మీరు చాటించవలసిన పరిశుద్ధ సంఘ దినాలు ఇవి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","మొదటి నెల పద్నాలుగో రోజు సాయంత్రం యెహోవా పస్కా పండగ జరుగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ఆ నెల పదిహేనో రోజున యెహోవాకు పొంగని రొట్టెల పండగ జరుగుతుంది. ఏడు రోజుల పాటు మీరు పొంగని వంటకాలే తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","మొదటి రోజున మీరు పరిశుద్ధ సంఘంగా సమకూడాలి. అందులో మీరు జీవనోపాధికి సంబంధించిన ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ఏడు రోజులు మీరు యెహోవాకు హోమ బలి చేయాలి. ఏడవ రోజున పరిశుద్ధ సంఘంగా సమకూడాలి. అందులో మీరు జీవనోపాధికి సంబంధించిన ఏ పనీ చేయకూడదని వారితో చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు ");
INSERT INTO tel2017_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు. నేను మీకు ఇస్తున్న దేశానికి మీరు వచ్చి దాని పంట కోసేటప్పుడు మీ మొదటి పంటలో ఒక పనను యాజకుని దగ్గరికి తేవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","యెహోవా మిమ్మల్ని అంగీకరించేలా అతడు యెహోవా సన్నిధిలో ఆ పనను కదిలించాలి. విశ్రాంతి రోజుకు మరుసటి రోజున యాజకుడు దాన్ని కదిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","మీరు ఆ పనను అర్పించే రోజున నిర్దోషమైన ఏడాది పొట్టేలును యెహోవాకు దహనబలిగా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","దాని నైవేద్యం నూనెతో కలిసిన పది వంతుల గోదుమపిండి రెండు భాగాలు. అది యెహోవాకు పరిమళ హోమం. దాని పానార్పణం ఒక లీటర్ ద్రాక్షారసం. ");
INSERT INTO tel2017_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","మీరు మీ దేవునికి అర్పణం తెచ్చేదాకా ఆ దినమంతా మీరు రొట్టె, పేలాలు, పచ్చని వెన్నులు, మొదలైనవి ఏమీ తినకూడదు. ఇది మీ తరతరాలకు మీ నివాసాలన్నిటిలో నిత్య శాసనం. ");
INSERT INTO tel2017_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","మీరు విశ్రాంతి రోజుకు మరునాడు మొదలు, అంటే కదిలించే పనను మీరు తెచ్చిన దినం మొదలు కుని ఏడు వారాలు లెక్కించాలి. లెక్కకు తక్కువ కాకుండా ఏడు వారాలు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ఏడవ విశ్రాంతి దినం మరుసటి దినం వరకూ మీరు ఏభై రోజులు లెక్కించి యెహోవాకు కొత్త పండ్లతో నైవేద్యం అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","మీరు మీ ఇళ్ళలో నుండి తూములో రెండేసి పదివంతుల పిండితో చేసిన రెండు రొట్టెలను కదిలించే అర్పణంగా తేవాలి. వాటిని గోదుమపిండితో చేసి పొంగేలా కాల్చాలి. అవి యెహోవాకు ప్రథమఫలాల అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","మీరు ఆ రొట్టెలతో నిర్దోషమైన ఏడాది మగ గొర్రెపిల్లలు ఏడింటిని, ఒక కోడెదూడను రెండు పెద్ద పొట్టేళ్లను అర్పించాలి. అవి వారి నైవేద్యాలతోను వారి పానార్పణాలతోను దహనబలిగా యెహోవాకు పరిమళ హోమం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","అప్పుడు మీరు మేకల్లో ఒక పోతును పాపపరిహార బలిగా అర్పించి రెండు ఏడాది వయసున్న గొర్రెపిల్లలను శాంతి బలిగా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","యాజకుడు ప్రథమఫలాల రొట్టెలతో ఆ రెండు పొట్టేళ్లను యెహోవా సన్నిధిని కదిలించాలి. అవి యెహోవాకు ప్రతిష్ఠించిన భాగాలు. అవి యాజకునివి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ఆ రోజే మీరు పరిశుద్ధ సమూహంగా సమకూడాలని చాటించాలి. అ రోజున మీరు జీవనోపాధి కోసం ఏ పనీ చేయకూడదు. ఇది మీ నివాసాలన్నిటిలో మీ తరతరాలకు నిత్య శాసనం. ");
INSERT INTO tel2017_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","మీరు మీ పంటపొలం కోసేటప్పుడు పొలం అంచుల్లో పూర్తిగా కోయకూడదు. నీ కోతలో రాలిన పరిగెను ఏరుకొనకూడదు. పేదవారికి, పరదేశులకు వాటిని విడిచిపెట్టాలి. నేను మీ దేవుడనైన యెహోవాను.” ");
INSERT INTO tel2017_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు. ఏడో నెల మొదటి రోజు మీకు విశ్రాంతి దినం. అందులో జ్ఞాపకార్థ కొమ్ము బూరధ్వని వినబడినప్పుడు మీరు పరిశుద్ధ సమూహంగా సమకూడాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ఆ రోజున మీరు జీవనోపాధి కోసం పని చేయడం మాని యెహోవాకు హోమం చేయాలి.” ");
INSERT INTO tel2017_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ఈ ఏడో నెల పదవ రోజు పాపానికి ప్రాయశ్చిత్తం చేసే రోజు. అ రోజున మీరు పరిశుద్ధ సంఘంగా సమకూడాలి. మిమ్మల్ని మీరు దుఃఖపరచుకుని యెహోవాకు హోమం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ఆ రోజున మీరు ఏ పనీ చేయకూడదు. మీ దేవుడైన యెహోవా సన్నిధిలో మీరు మీ కోసం ప్రాయశ్చిత్తం చేసుకోడానికి అది ప్రాయశ్చిత్త దినం. ");
INSERT INTO tel2017_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ఆ రోజున తనను దుఃఖపరుచుకోకుండా ఉండే ప్రతివాణ్ణి తన ప్రజల్లో లేకుండా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ఆ రోజున ఏ పని అయినా చేసే ప్రతివాణ్ణి తన ప్రజల్లో ఉండకుండాా నాశనం చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ఆ రోజున మీరు ఏ పనీ చేయకూడదు. అది మీ నివాసాలన్నిటిలో మీ తరతరాలకు నిత్య శాసనం. ");
INSERT INTO tel2017_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","అది మీకు మహా విశ్రాంతి దినం. అ రోజున మిమ్మల్ని మీరు దుఃఖపరచుకోవాలి. ఆ నెల తొమ్మిదో రోజు సాయంత్రం మొదలు మరుసటి సాయంత్రం వరకూ మీరు విశ్రాంతి దినంగా ఆచరించాలి.” ");
INSERT INTO tel2017_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు. ఈ ఏడో నెల పదిహేనో దినం మొదలు ఏడు దినాలు యెహోవాకు పర్ణశాలల పండగ జరపాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","వాటిలో మొదటి రోజున మీరు పరిశుద్ధసంఘంగా సమకూడాలి. అందులో మీరు జీవనోపాధి కోసం ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ఏడు రోజులు మీరు యెహోవాకు హోమం చేయాలి. ఎనిమిదో రోజున పరిశుద్ధ సంఘంగా సమకూడి యెహోవాకు హోమబలి అర్పించాలి. అది మీకు వ్రతదినం. అందులో మీరు జీవనోపాధి కోసం ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","ఇవి యెహోవా నియామక పండగలు. ఆయనకు హోమ బలులు, దహన బలులు, నైవేద్యాలు, పానీయార్పణలు అర్పించడానికి పరిశుద్ధ సంఘ దినాలుగా మీరు చాటించవలసిన రోజులు ఇవే. ఏ అర్పణ రోజున ఆ అర్పణ తేవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","యెహోవా నియమించిన విశ్రాంతి దినాలకు, మీరు కానుకలు ఇచ్చే రోజులకు, మీ మొక్కుబడి రోజులకు, మీరు యెహోవాకు స్వేచ్ఛార్పణలిచ్చే రోజులకు ఇవి అదనం. ");
INSERT INTO tel2017_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","అయితే ఏడో నెల పదిహేనో రోజున మీరు పంట సమకూర్చుకునేటప్పుడు ఏడు రోజులు యెహోవాకు ఉత్సవం చెయ్యాలి. మొదటిరోజు, ఎనిమిదవ రోజు విశ్రాంతి దినాలు. ");
INSERT INTO tel2017_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","మొదటి రోజున మీరు దబ్బ కాయలు, ఈత మట్టలు, గొంజి చెట్ల కొమ్మలు, కాలవల ఒడ్డున ఉండే నిరవంజి చెట్ల కొమ్మలు తెచ్చి ఏడు రోజులు మీ దేవుడైన యెహోవా సన్నిధిలో ఉత్సవం చేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","అలా మీరు ఏటేటా ఏడు రోజులు యెహోవాకు పండగగా ఆచరించాలి. ఇది మీ తరతరాలకు నిత్యమైన శాసనం. ఏడవ నెలలో దాన్ని ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","నేను ఐగుప్తులోనుండి ఇశ్రాయేలీయులను రప్పించినప్పుడు వారు పర్ణశాలలో నివసించేలా చేసానని మీ ప్రజలకు తెలిసేలా ఏడు రోజులు మీరు పర్ణశాలల్లో నివసించాలి. ఇశ్రాయేలీయుల్లో పుట్టిన వారంతా పర్ణశాలల్లో నివసించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","నేను మీ దేవుడైన యెహోవాను.” ");
INSERT INTO tel2017_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ఈ విధంగా మోషే ఇశ్రాయేలీయులకు యెహోవా నియామక కాలాలను తెలియపరిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“దీపం ఎప్పుడూ వెలుగుతూ ఉండేలా ప్రమిదల కోసం దంచి తీసిన స్వచ్ఛమైన ఒలీవ నూనె తేవాలని ఇశ్రాయేలీయులకు ఆజ్ఞాపించు. ");
INSERT INTO tel2017_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ప్రత్యక్ష గుడారంలో శాసనాల అడ్డతెర బయట అహరోను సాయంత్రం నుండి ఉదయం దాకా అది వెలుగుతూ ఉండేలా యెహోవా సన్నిధిలో దాన్ని చూసుకుంటూ ఉండాలి. ఇది మీ తరతరాలకు నిత్యమైన శాసనం. ");
INSERT INTO tel2017_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","అతడు నిర్మలమైన దీపవృక్షం మీద ప్రమిదలను యెహోవా సన్నిధిలో నిత్యం చూసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","నీవు గోదుమ పిండి తీసుకుని దానితో పన్నెండు రొట్టెలు చెయ్యాలి. ఒక్కొక్క రొట్టెకు రెండు కిలోల పిండి వాడాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","యెహోవా సన్నిధిలో నిర్మలమైన బల్లమీద ఆరేసి రొట్టెలున్న రెండు దొంతులుగా వాటిని ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ఒక్కొక్క దొంతి మీద స్వచ్ఛమైన సాంబ్రాణి ఉంచాలి. అది యెహోవా కోసం పరిమళ హోమం. ");
INSERT INTO tel2017_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","యాజకుడు ప్రతి విశ్రాంతి దినాన నిత్య నిబంధన ప్రకారం ఇశ్రాయేలీయుల పక్షంగా ఆ రొట్టెలు బల్లపై పెడుతూ ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ఈ అర్పణ అహరోనుకు అతని సంతానానికి. వారు పరిశుద్ధస్థలం లో దాన్ని తినాలి. నిత్య శాసనం చొప్పున యెహోవాకు చేసే హోమాల్లో అది అతి పవిత్రం.” ");
INSERT INTO tel2017_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ఒక ఇశ్రాయేలు జాతి స్త్రీకి ఐగుప్తు పురుషుడికి పుట్టిన ఒకడు ఇశ్రాయేలీయులతో కలిసి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ఆ ఇశ్రాయేలీయురాలి కొడుక్కి ఒక ఇశ్రాయేలీయుడికి శిబిరంలో గొడవ జరిగింది. ఆ ఇశ్రాయేలీయురాలి కొడుకు యెహోవా నామాన్ని దూషించి శపించాడు. ప్రజలు మోషే దగ్గరికి వాణ్ణి తీసుకొచ్చారు. వాడి తల్లి పేరు షెలోమీతు. ఆమె దాను గోత్రికుడు దిబ్రీ కూతురు. ");
INSERT INTO tel2017_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","యెహోవా ఏమి చెబుతాడో తెలిసేదాకా వాణ్ణి కావలిలో ఉంచారు. ");
INSERT INTO tel2017_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","అప్పుడు యెహోవా మోషేకు ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“శపించిన వాణ్ణి శిబిరం బయటికి తీసుకురా. వాడు పలికిన శాపనార్థాలు విన్న వారంతా వాని తల మీద చేతులుంచిన తరవాత ప్రజలంతా రాళ్లతో వాణ్ణి చావగొట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు. తన దేవుణ్ణి శపించేవాడు తన పాపశిక్షను భరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","యెహోవా నామాన్ని దూషించేవాడికి మరణశిక్ష విధించాలి. ప్రజలంతా రాళ్లతో అలాటి వాణ్ణి చావ గొట్టాలి. పరదేశిగాని స్వదేశిగాని యెహోవా నామాన్ని దూషిస్తే వాడికి మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","ఎవడైనా హత్య చేసినట్టయితే వాడికి మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","జంతువు ప్రాణం తీసినవాడు ప్రాణానికి ప్రాణమిచ్చి దాని నష్టపరిహారం చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ఒకడు తన సాటి మనిషిని గాయపరిస్తే వాడు చేసినట్టే వాడికీ చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ఎముక విరగ్గొడితే వాడి ఎముక విరగ్గొట్టాలి. కంటికి కన్ను, పంటికి పన్ను. ఒకడు వేరొకడికి గాయం చేస్తే వాడికి అదే చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","జంతువును చావగొట్టినవాడు దాని నష్టపరిహారం ఇచ్చుకోవాలి. హత్య చేసినవాడికి మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","మీరు పక్షపాతం లేకుండా తీర్పు తీర్చాలి. మీలో నివసించే పరదేశికి మీరు చేసినట్టే మీ స్వజాతివారికీ చెయ్యాలి. నేను మీ దేవుడినైన యెహోవానని వారితో చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","కాబట్టి మోషే ఇశ్రాయేలీయులతో “దేవుణ్ణి శాపనార్థాలు పెట్టిన వాణ్ణి శిబిరం బయటికి తీసుకుపోయి రాళ్లతో చావగొట్టండి” అని చెప్పాడు. యెహోవా మోషేకు ఆజ్ఞాపించినట్టు ఇశ్రాయేలీయులు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","యెహోవా సీనాయికొండ మీద మోషేకు ఇలా చెప్పాడు ");
INSERT INTO tel2017_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు. నేను మీకిస్తున్న దేశానికి మీరు వచ్చిన తరువాత ఆ భూమి కూడా యెహోవా పేరట విశ్రాంతి కాలాన్ని పాటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ఆరు సంవత్సరాలు నీ పొలంలో విత్తనాలు చల్లాలి. ఆరు సంవత్సరాలు నీ పండ్ల తోటను సాగుచేసి దాని పండ్లు సమకూర్చుకోవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ఏడవ సంవత్సరం భూమికి మహా విశ్రాంతి కాలం, అంటే అది యెహోవా పేరట విశ్రాంతి సంవత్సరంగా ఉండాలి. ఆ సంవత్సరం నీ పొలంలో విత్తనాలు చల్ల కూడదు. నీ పండ్ల తోటను బాగు చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","బీడుగా వదిలిన చేలో దానంతట అదే పండిన పంట కోత కోసం ఏర్పాట్లు చేసుకోకూడదు. బాగు చేయని నీ చెట్ల పండ్లు ఏరుకోకూడదు. అది భూమికి విశ్రాంతి సంవత్సరం. ");
INSERT INTO tel2017_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","అప్పుడు భూమి విశ్రాంతి సంవత్సరంలో దానంతట అదే పండిన పంట నీకు, నీ సేవకుడికి, నీ దాసికి, నీ జీతగాడికి, నీతో నివసిస్తున్న పరదేశికి ఆహారంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","నీ పశువులకు, నీ దేశంలోని జంతువులకు దాని పంట అంతా మేతగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","ఏడు విశ్రాంతి సంవత్సరాలను, అంటే ఏడేసి సంవత్సరాలను లెక్క బెట్టాలి. ఆ ఏడు విశ్రాంతి సంవత్సరాల కాలం మొత్తం 49 సంవత్సరాలు అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ఏడో నెల పదవ రోజు మీ దేశమంతటా కొమ్ము బూర ఊదాలి. ప్రాయశ్చిత్త దినాన మీ దేశమంతటా ఆ బూర ఊదాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","మీరు ఆ సంవత్సరాన్ని, అంటే ఏభైయవ సంవత్సరాన్ని పరిశుద్ధ పరచి మీ దేశంలో ఉన్న వారందరికి విడుదల కలిగిందని చాటించాలి. అది మీకు సునాదం. అప్పుడు మీలో ప్రతివాడూ తన ఆస్తిని తిరిగి సొంతం చేసుకోవాలి. ప్రతివాడూ తన కుటుంబానికి తిరిగి రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ఆ సంవత్సరం, అంటే ఏభైయవ సంవత్సరం మీకు సునాద కాలం. ఆ సంవత్సరంలో మీరు విత్తనాలు చల్ల కూడదు, కోత ఏర్పాట్లు చేసుకోకూడదు. బీడుగా వదిలిన చేలో దానంతట అదే పండిన పంట తినవచ్చు. బాగు చేయని ద్రాక్ష తోటలో పండ్లు ఏరుకోవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","అది సునాద కాలం. అది మీకు పవిత్రం. చేలో దానంతట అదే పండిన పంటను మీరు తింటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ఆ సునాద సంవత్సరం మీలో ప్రతి వాడు తన ఆస్తిని తిరిగి పొందాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","నీవు నీ పొరుగు వాడికి అమ్మిన దాని విషయంలో గానీ నీ పొరుగు వాడి దగ్గర నీవు కొనుక్కున్న దాని విషయంలో గానీ మీరు ఒకరినొకరు బాధించుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","సునాద సంవత్సరం అయిన తరువాత జరిగిన సంవత్సరాల లెక్క ప్రకారం నీ పొరుగు వాడి దగ్గర నీవు దాన్ని కొనాలి. పంటల లెక్క చొప్పున అతడు నీకు దాన్ని అమ్మాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ఆ సంవత్సరాల లెక్క పెరిగిన కొద్దీ దాని వెల పెంచాలి. ఆ సంవత్సరాల లెక్క తగ్గిన కొద్దీ దాని వెల తగ్గించాలి. ఎందుకంటే పంటవచ్చిన సంవత్సరాల లెక్క చొప్పున అతడు దాని ఖరీదు కట్టాలి గదా. ");
INSERT INTO tel2017_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","మీరు ఒకరి నొకరు బాధించుకో కుండా నీ దేవునికి భయపడాలి. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","కాబట్టి మీరు నా శాసనాలను నా విధులను పాటించి వాటి ననుసరించి నడుచుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","అప్పుడు మీరు ఆ దేశంలో సురక్షితంగా నివసిస్తారు. ఆ భూమి సస్యశ్యామలంగా ఉంటుంది. మీరు తృప్తిగా తిని దానిలో సురక్షితంగా నివసిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ఏడవ సంవత్సరంలో మేము ఏమి తింటాము? మేము విత్తనాలు చల్లకూడదు, పంట కూర్చుకోకూడదు గదా అనుకుంటారేమో. ");
INSERT INTO tel2017_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","నేను ఆరో సంవత్సరం నా దీవెన మీకు కలిగేలా ఆజ్ఞాపిస్తాను. ఆ సంవత్సరం మూడేళ్ళకు సరిపడిన పంట పండుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","మీరు ఎనిమిదో సంవత్సరాన విత్తనాలు చల్లి తొమ్మిదో సంవత్సరం వరకూ పాత పంట తింటారు. కొత్త పంట వచ్చేదాకా పాత దాన్ని తింటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","భూమిని శాశ్వతంగా వేరొకడికి అమ్మకూడదు. ఎందుకంటే భూమి నాది. మీరు నా దగ్గర తాత్కాలికంగా నివసిస్తున్న పరదేశులు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","నీవు కొనుక్కునే ఆస్తి అంతటి విషయంలో విడుదల హక్కును గుర్తించాలి. నీవు ఎవరినుంచి ఆస్తి కొన్నావో ఆ కుటుంబం దాన్ని తిరిగి కొనుక్కునే సదుపాయం కల్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","నీ సోదరుడు పేదరికం వల్ల తన ఆస్తిలో కొంత అమ్ముకుంటే అతని సమీప బంధువు దాన్ని విడిపించడానికి ఎదుటికి వచ్చి తన సోదరుడు అమ్మినదాన్ని విడిపిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","అయితే ఒకడు సమీప బంధువు లేకపోయినా తన ఆస్తిని విడిపించుకోడానికి కావలసిన డబ్బు తానే సంపాదించుకుంటే ");
INSERT INTO tel2017_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","దాన్ని అమ్మిన సమయం నుండి గడచిన సంవత్సరాలు లెక్కబెట్టాలి. తన ఆస్తి కొనుక్కున్న వాడికి ఆ డబ్బు ఇచ్చి అతడు తన ఆస్తిని దక్కించుకుంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","అతనికి దాని తిరిగి కొనుక్కునేందుకు కావలసిన డబ్బు దొరక్క పోతే అతడు అమ్మిన ఆస్తి సునాద సంవత్సరం వరకూ కొన్న వాడి స్వాధీనంలో ఉండాలి. సునాద సంవత్సరంలో అది విడుదల అవుతుంది. అప్పుడతడు తన ఆస్తిని తిరిగి పొందుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ఎవరైనా ప్రాకారం ఉన్న ఊరిలోని తన సొంతిల్లు అమ్మితే దాన్ని అమ్మిన రోజు మొదలుకుని సంవత్సరంలోగా దాన్ని విడిపించుకోవచ్చు. ఆ సంవత్సరమంతా దాన్ని విడిపించుకునే అవకాశం అతనికి ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","అయితే ఆ సంవత్సరం నిండే లోగా దాన్ని విడిపించుకోకపోతే ప్రాకారం ఉన్న ఊళ్ళోని ఆ ఇల్లు కొనుక్కున్న వాడికే తరతరాలకు ఉండిపోతుంది. అది సునాద సంవత్సరంలో మొదటి యజమాని ఆధీనంలోకి తిరిగి రాదు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ప్రాకారం లేని గ్రామాల్లోని ఇళ్ళను మాత్రం దేశంలోని పొలాలతో సమానంగా ఎంచాలి. వాటిని తిరిగి విడిపించుకోవచ్చు. అవి సునాదకాలంలో విడుదల అవుతాయి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","అయితే లేవీయుల పట్టణాల్లోని ఇళ్ళను వారు ఎప్పుడైనా విడిపించుకోవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","లేవీయుల పట్టణాల్లోని ఇళ్ళు ఇశ్రాయేలీయుల మధ్య నివసిస్తున్న ఆ లేవీయుల ఆస్తి గనక ఎవరైనా లేవీయుల దగ్గర ఇల్లు కొనుక్కున్నారనుకోండి. అది లేవీయులకు పిత్రార్జితంగా వచ్చిన పట్టణంలో అమ్మిన ఇల్లు. అది సునాద సంవత్సరంలో విడుదల అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","లేవీయులు తమ పట్టణ ప్రాంతం భూములను అమ్ముకోకూడదు. అవి వారికి శాశ్వత ఆస్తి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","నీ జాతివాడు ఎవరైనా పేదవాడై తనను పోషించుకోలేని స్థితిలో నీ దగ్గరికి వస్తే నీవు ఒక పరదేశికి, నీ దగ్గర నివసిస్తున్న బయటి వ్యక్తికి సహాయం చేసినట్టే అతనికి సహాయం చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","అతని దగ్గర వడ్డీ తీసుకోకూడదు. అతని వలన లాభం పొందాలని చూడకూడదు. నీ సోదరుడు నీ మూలంగా బ్రతకాలి. ఆ విధంగా నీ దేవుణ్ణి నీవు గౌరవించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","డబ్బు ఇచ్చి వడ్డీ తీసుకోకూడదు. నీ దగ్గరున్న ఆహారపదార్థాలను లాభం వేసుకుని అతనికి అమ్మకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","నేను యెహోవాను. మీకు దేవుడుగా ఉండడానికి ఐగుప్తులోనుండి మిమ్మల్ని రప్పించి, మీకు కనాను దేశాన్ని ఇచ్చిన వాణ్ణి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","నీ స్వజాతి వాడు పేదవాడై తనను నీకు అమ్మేసుకుంటే వాడిచేత బానిసలా ఊడిగం చేయించుకో కూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","వాడు సేవకునిలాగా పరదేశిలాగా నీ దగ్గర ఉండి సునాద సంవత్సరం వరకూ నీ దగ్గర సేవకుడుగా పని చేస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","అప్పుడతడు తన పూర్వీకుల ఆస్తిని మళ్లీ అనుభవించేలా తన పిల్లలతో సహా నీ దగ్గర నుండి బయలు దేరి తన వంశం వారి దగ్గరికి తిరిగి వెళ్ళాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ఎందుకంటే వారు నాకే సేవకులు. నేను ఐగుప్తులో నుండి వారిని రప్పించాను. బానిసలను అమ్మినట్టు వాళ్ళను అమ్మకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","నీ దేవునికి భయపడి అలాటి వాణ్ణి కఠినంగా చూడకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","మీ చుట్టుపక్కల ఉన్న జాతుల్లోనించి దాస దాసీలను కొనుక్కోవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","మీ మధ్య నివసించే పరదేశులను నీ దేశంలో వారికి పుట్టిన పరాయి వారిని కొనవచ్చు. వారు మీ ఆస్తి అవుతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","అలాటి బానిసలను మీ తరవాత మీ సంతానానికి కూడా ఆస్తిగా సంపాదించుకోవచ్చు. వారు శాశ్వతంగా మీకు బానిసలౌతారు. కానీ మీ సోదర ఇశ్రాయేలీయులతో కఠినమైన చాకిరీ చేయించుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","పరదేశిగానీ మీ దగ్గర తాత్కాలికంగా నివసించేవాడు గాని ధనికుడై, నీ సాటి ఇశ్రాయేలీయుల్లో ఒకడు పేదవాడై ఆ పరదేశికైనా ఆ పరదేశి కుటుంబంలో ఎవరికైనా తనను అమ్ముకున్నాడనుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","నీ సాటి ఇశ్రాయేలీయుల్లో ఒకడు అమ్ముడుబోయిన తరువాత అతణ్ణి విడిపించ వచ్చు. అతడి బంధువుల్లో ఎవరైనా అతణ్ణి విడిపించవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","అతని బాబాయిగాని బాబాయి కొడుకు గాని అతని వంశంలోని రక్తసంబంధిగాని అతణ్ణి విడిపించవచ్చు. అవసరమైన విడుదల వెల అతనికి దొరికితే అతడు తనను తాను విడిపించుకోవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","అప్పుడు అతడు తనను కొనుక్కున్న వాడితో బేరమాడాలి. తాను అమ్ముడుబోయిన సంవత్సరం నుండి సునాద సంవత్సరం వరకూ సంవత్సరాలు లెక్క బెట్టాలి. తనను కొనుక్కున్న వాడి దగ్గర ఎంతకాలం పనిచేశాడు అనే దాన్ని బట్టి అతని విడుదల వెల లెక్కగట్టాలి. ఆ వెలను జీతానికి పెట్టుకున్న సేవకునికి ఇచ్చే దాని ప్రకారం లెక్కించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","సునాద సంవత్సరానికి ఇంకా చాలా సంవత్సరాలు మిగిలి ఉంటే, ఆ సంవత్సరాల లెక్క ప్రకారం తన విడుదల వెల తిరిగి చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","సునాద సంవత్సరానికి ఇక కొద్ది కాలమే ఉంటే కొన్న వాడితో లెక్క చూసుకుని మిగిలిన సంవత్సరాల లెక్కచొప్పున చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","సంవత్సరాల లెక్క ప్రకారం జీతంపై పని చేసే వాడి లాగా వాడతని దగ్గర పని చెయ్యాలి. అతని చేత కఠినంగా సేవ చేయించకుండా మీరు చూసుకుంటూ ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","అతడు ఈ విధంగా విడుదల పొందకపోతే సునాద సంవత్సరంలో అతడు తన పిల్లలతో సహా విడుదల పొందుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ఎందుకంటే ఇశ్రాయేలీయులు నాకే దాసులు. నేను ఐగుప్తుదేశంలో నుండి రప్పించిన నా దాసులే. నేను మీ దేవుడైన యెహోవాను.” ");
INSERT INTO tel2017_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“మీరు విగ్రహాలను చేసుకోకూడదు. చెక్కిన ప్రతిమను గానీ దేవతా రాతి స్తంభాన్ని గానీ నిలబెట్టకూడదు. మీ దేశంలో మీరు మొక్కడానికి చెక్కిన రాతి బొమ్మను నిలబెట్టకూడదు. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","నేను నియమించిన విశ్రాంతి దినాలను మీరు ఆచరించాలి. నా పరిశుద్ధ మందిరాన్ని పవిత్రంగా చూడాలి. నేను యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","మీరు నా శాసనాలను బట్టి నడుచుకుంటూ నా ఆజ్ఞలను పాటిస్తూ వాటిని అనుసరించి ప్రవర్తించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","వర్షాకాలంలో మీకు వర్షం ఇస్తాను. మీ భూమి పంటలనిస్తుంది. మీ పొలాల్లో చెట్లు ఫలిస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","మీ ద్రాక్ష పండ్లకాలం వరకూ మీ పంట నూర్పు కొనసాగుతుంది. మీరు తృప్తిగా తిని మీ దేశంలో నిర్భయంగా నివసిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ఆ దేశంలో నేను మీకు క్షేమం కలిగిస్తాను. మీరు పండుకొనేటప్పుడు ఎవరూ మిమ్మల్ని భయపెట్టరు. ఆ దేశంలో క్రూరమృగాలు లేకుండా చేస్తాను. మీ దేశంలోకి ఖడ్గం రాదు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","మీరు మీ శత్రువులను తరుముతారు. వారు మీ ఎదుట కత్తివాత కూలుతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","మీలో ఐదుగురు వంద మందిని తరుముతారు. వంద మంది పదివేల మందిని తరుముతారు, మీ శత్రువులు మీ ఎదుట కత్తివాత కూలిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ఎందుకంటే నేను మిమ్మల్ని కరుణించి మీకు సంతానమిచ్చి మిమ్మల్ని విస్తరింపజేసి మీతో నేను చేసిన నిబంధనను స్థిరపరుస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","మీరు చాలా కాలం నిలవ ఉన్న పాత ధాన్యం తింటారు. కొత్తది వచ్చినా పాతది మిగిలి ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","నా మందిరాన్ని మీ మధ్య ఉంచుతాను. మీ విషయం నా మనస్సు అసహ్యపడదు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","నేను మీ మధ్య సంచరిస్తాను. మీకు దేవుడినై ఉంటాను. మీరు నాకు ప్రజలై ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","మీరు ఐగుప్తీయులకు దాసులు కాకుండ వారి దేశంలోనుండి మిమ్మల్ని రప్పించాను. నేను మీ దేవుడైన యెహోవాను. నేను మీ కాడి అడ్డకొయ్యలు విరగగొట్టి మిమ్మల్ని తలెత్తుకుని నడిచేలా చేశాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","ఒకవేళ మీరు నా మాట వినకుండా నా ఆజ్ఞలన్నిటినీ అనుసరించకుండా ");
INSERT INTO tel2017_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","నా శాసనాలను నిరాకరిస్తూ, నా ఆజ్ఞలన్నిటినీ నిరాకరిస్తూ నా నిబంధనను ఉల్లంఘిస్తూ నా తీర్పులను త్రోసిపుచ్చుతూ ఉంటారేమో. ");
INSERT INTO tel2017_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","అలాగైతే నేను మీకు చేసేది ఇదే. మీమీదికి భయం రప్పిస్తాను. మీకు జ్వరం కలిగించి మీ కళ్ళు దెబ్బ తిని ప్రాణాలు నీరసించి పోయేలా చేస్తాను. మీరు చల్లిన విత్తనాలు వ్యర్థమైపోతాయి. మీ శత్రువులు వాటి పంటను తింటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","మీ నుండి ముఖం తిప్పేసుకుంటాను. మీ శత్రువులు మిమ్మల్ని లోబరచుకుంటారు. మిమ్మల్ని ద్వేషించేవారు మిమ్మల్ని పరిపాలిస్తారు. ఎవరూ తరమకపోయినా మీరు పారిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","నా ఆజ్ఞలు పాటించకపోతే నేను మీ పాపాలను బట్టి మరి ఏడంతలుగా మిమ్మల్ని దండిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","మీ బల గర్వాన్ని భంగపరచి, ఆకాశాన్ని ఇనుములాగా భూమిని ఇత్తడిలాగా చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","మీ భూమి ఫలించదు. మీ దేశంలోని చెట్లు ఫలించవు. మీ బలం వృథాగా ఇంకి పోతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","మీరు నా మాట వినకుండా నాకు విరోధంగా నడిస్తే నేను మీ పాపాలను బట్టి మరి ఏడంతలుగా మిమ్మల్ని బాధిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","మీ మధ్యకు క్రూరమృగాలను పంపిస్తాను. అవి మీ పిల్లలను ఎత్తుకుపోతాయి. మీ పశువులను నాశనం చేస్తాయి. మిమ్మల్ని కొద్ది మందిగా చేస్తాయి. మీ దారులు నిర్మానుష్యమై పోతాయి. ");
INSERT INTO tel2017_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","ఇంత చేసినా మీరు నాకు విరోధంగా నడుస్తూ ఉంటే ");
INSERT INTO tel2017_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","నేను కూడా మీపై కోపంగా నడుచు కుంటాను. నేనే మీ పాపాలను బట్టి ఇంకా ఏడంతలుగా మిమ్మల్ని దండిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","మీ మీదికి కత్తి రప్పిస్తాను. అది నా నిబంధన విషయం ప్రతి దండన చేస్తుంది. మీరు మీ పట్టణాల్లో సమకూడి ఉండగా మీ మధ్యకు తెగులు రప్పిస్తాను. మీరు శత్రువుల వశమైపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","నేను మీ ఆహారాన్ని, అంటే మీ ప్రాణాధారం తీసేసిన తరువాత పదిమంది స్త్రీలు ఒక్క పొయ్యిలోనే మీకు రొట్టెలు చేసి కొలత ప్రకారం మీకు ఇస్తారు. మీరు తింటారు గాని తృప్తి పొందరు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","నేను ఇలా చేసిన తరువాత కూడా మీరు నా మాట వినక నాకు విరోధంగా నడిస్తే ");
INSERT INTO tel2017_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","నేను కోపపడి మీకు విరోధంగా నడుస్తాను. నేనే మీ పాపాలను బట్టి ఏడంతలుగా మిమ్మల్ని దండిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","మీరు మీ కొడుకుల మాంసం తింటారు, మీ కుమార్తెల మాంసం తింటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","నేను మీ ఉన్నత స్థలాలను పాడు చేస్తాను. మీ విగ్రహాలను ధ్వంసం చేస్తాను. మీ విగ్రహాల శవాలపై మీ శవాలను పడవేయిస్తాను. నా మనస్సులో మిమ్మల్ని అసహ్యించు కుంటాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","నేను మీ ఊళ్ళను పాడు చేస్తాను. మీ పరిశుద్ధ స్థలాలను పాడుచేస్తాను. మీ సువాసన గల అర్పణలును వాసన చూడను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","నేనే మీ దేశాన్ని పాడు చేసిన తరువాత దానిలో నివసించే మీ శత్రువులు దాన్ని చూసి ఆశ్చర్యపడతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","జనాల్లోకి మిమ్మల్ని చెదరగొట్టి కత్తి దూసి మీ వెంటబడి తరుముతాను. మీ దేశం పాడైపోతుంది, మీ ఊళ్లు పాడుబడిపోతాయి. ");
INSERT INTO tel2017_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","మీరు మీ శత్రువుల దేశంలో ఉండగా మీ దేశం పాడుబడి ఉన్న కాలమంతా అది తన విశ్రాంతి కాలాలను అనుభవిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","అది పాడై ఉండే దినాలన్నీ విశ్రాంతి తీసుకుంటుంది. మీరు దానిలో నివసించినప్పుడు అది విశ్రాంతి కాలంలో పొందలేకపోయిన విశ్రాంతిని అది పాడై ఉన్న దినాల్లో అనుభవిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","మీలో మిగిలినవారు తమ శత్రువుల దేశాల్లో ఉండగా వారి హృదయాల్లో అధైర్యం పుట్టిస్తాను. గాలికి కొట్టుకుపోతున్న ఆకు చప్పుడుకు వారు పారిపోతారు. ఖడ్గం నుండి తప్పించుకోడానికి పారిపోతున్నట్టు వారు ఆ చప్పుడు విని పారిపోతారు. తరుమేవాడు ఎవరూ లేకుండానే పడిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","తరిమేవాడు ఎవరూ లేకుండానే వారు కత్తిని చూసినట్టుగా ఒకడి మీద ఒకడు పడతారు. మీ శత్రువుల ఎదుట మీరు నిలవలేక పోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","మీరు జనంగా ఉండకుండాా నశించి పోతారు. మీ శత్రువుల దేశం మిమ్మల్ని తినేస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","మీలో మిగిలినవారు మీ శత్రువుల దేశాల్లో తమ దోషాలను బట్టి క్షీణించిపోతారు. వారు తమ మీదికి వచ్చిన తమ తండ్రుల దోషాలను బట్టి క్షీణించిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","వారు నాకు విరోధంగా చేసిన తిరుగుబాటును, తమ దోషాన్ని, తమ తండ్రుల దోషాన్ని ఒప్పుకుని, తాము నాకు విరోధంగా నడిచామని, ");
INSERT INTO tel2017_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","నేను వారికి విరోధంగా నడిచానని, తమ శత్రువుల దేశంలోకి తమ్మును రప్పించాననీ ఒప్పుకుంటే, అంటే లోబడని తమ హృదయాలు లొంగి తాము చేసిన దోషానికి ప్రతి దండన అనుభవించామని ఒప్పుకుంటే, ");
INSERT INTO tel2017_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","నేను యాకోబుతో చేసిన నా నిబంధనను జ్ఞాపకం చేసుకుంటాను. నేను ఇస్సాకుతో చేసిన నా నిబంధనను నేను అబ్రాహాముతో చేసిన నా నిబంధనను జ్ఞాపకం చేసుకుంటాను. ఆ దేశాన్ని కూడా జ్ఞాపకం చేసుకుంటాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","తమ దేశాన్ని వారు విడిచిపెట్టి పోగా పాడైపోయిన వారి దేశం తన విశ్రాంతి దినాలను అనుభవిస్తుంది. వారు నా తీర్పులను తిరస్కరించి నా శాసనాలను అసహ్యించుకున్నారు. ఆ కారణం చేతనే వారు తమ పైకి వచ్చిన దోషశిక్ష న్యాయమని ఒప్పుకొంటారు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","అయితే వారు తమ శత్రువుల దేశంలో ఉన్నప్పుడు వారిని నిరాకరించను. నా నిబంధనను భంగపరచి వారిని బొత్తిగా నశింపజేయడానికి వారిపై అసహ్యపడను. ఎందుకంటే నేను వారి దేవుడైన యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","నేను వారికి దేవుడనై ఉండేలా వారి పూర్వికులను వివిధ జాతులు చూస్తుండగా ఐగుప్తులో నుండి రప్పించి వారితో చేసిన నిబంధనను ఆ పూర్వికులను బట్టి జ్ఞాపకం చేసుకుంటాను. నేను యెహోవాను, అని చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","యెహోవా మోషే ద్వారా సీనాయి కొండ మీద తనకు, ఇశ్రాయేలీయులకును మధ్య నియమించిన శాసనాలు, తీర్పులు, ఆజ్ఞలు ఇవే. ");
INSERT INTO tel2017_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“నీవు ఇశ్రాయేలీయులతో ఇలా చెప్పు. ఎవరన్నా విశేషమైన మ్రొక్కుబడి చేస్తే నీవు నిర్ణయించిన వెల చొప్పున వారు యెహోవాకు దాన్ని చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","నీవు నిర్ణయించవలసిన వెల ఇది. ఇరవై ఏళ్ళు మొదలు అరవై ఏళ్ల వయస్సు వరకూ పురుషుడికి పరిశుద్ధ స్థలం తులం లెక్క ప్రకారం ఏభై తులాల వెండి నిర్ణయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","స్త్రీకి ముప్ఫై తులాలు నిర్ణయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ఐదేళ్ళు మొదలు ఇరవై ఏళ్ల లోపలి వయస్సు గల పురుషుడికి ఇరవై తులాల వెలను, స్త్రీకి పది తులాల వెలను నిర్ణయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ఒక నెల మొదలు ఐదేళ్ళ లోపు వయస్సుగల పురుషుడికి ఐదు తులాల వెండి వెలను స్త్రీకి మూడు తులాల వెండి వెలను నిర్ణయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","అరవై ఏళ్ల వయసు దాటిన పురుషుడికి పదిహేను తులాల వెలను స్త్రీకి పది తులాల వెలను నిర్ణయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ఎవరైనా నీవు నిర్ణయించిన వెల చెల్లించలేనంత పేద వాడైతే అతడు యాజకుని ఎదుటికి రావాలి. అప్పుడు యాజకుడు అతని వెల నిర్ణయిస్తాడు. మొక్కుకున్న వాడి తాహతు చొప్పున వాడికి వెలను నిర్ణయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","యెహోవాకు అర్పణంగా అర్పించే పశువుల్లో ప్రతిదాన్నీ యెహోవాకు ప్రతిష్ఠితంగా ఎంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","దాన్ని మార్చకూడదు. చెడ్డదానికి బదులు మంచిదాన్ని గానీ మంచిదానికి బదులు చెడ్డదాన్ని గానీ ఒక దానికి బదులు మరొక దాన్నిగానీ ఇయ్యకూడదు. మొక్కుకున్న జంతువుకు బదులు వేరొక జంతువును మారిస్తే అదీ దానికి బదులుగా ఇచ్చినదీ కూడా ప్రతిష్ఠితం అయిపోతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ప్రజలు యెహోవాకు అర్పించకూడని అపవిత్ర జంతువుల్లో ఒకదాన్ని తెస్తే ఆ జంతువును యాజకుని ఎదుట నిలబెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","అది మంచిదైనా చెడ్డదైనా యాజకుడు దాని వెలను నిర్ణయించాలి. యాజకుడివైన నీవు నిర్ణయించిన వెల ఖాయం. ");
INSERT INTO tel2017_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","అయితే ఎవరైనా అలాటి జంతువును విడిపించుకోవాలనుకుంటే నీవు నిర్ణయించిన వెలలో ఐదో వంతు దానితో కలపాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","ఎవరైనా తన ఇల్లు యెహోవాకు సమర్పించడానికి దాన్ని ప్రతిష్ఠించినట్టయితే అది మంచిదైనా చెడ్డదైనా యాజకుడు దాని వెల నిర్ణయించాలి. యాజకుడు నిర్ణయించిన వెల ఖాయం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","తన ఇల్లు దేవునికి అర్పించిన వాడు దాన్ని విడిపించుకోవాలనుకుంటే అతడు నీవు నిర్ణయించిన వెలలో ఐదో వంతు దానితో కలపాలి. అప్పుడు ఆ ఇల్లు అతనిదవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","ఒకడు తన పిత్రార్జితమైన పొలంలో కొంత యెహోవాకు ప్రతిష్ఠించినట్టయితే దానిలో చల్లే విత్తనాల కొలత చొప్పున దాని వెల నిర్ణయించాలి. పది తూముల బార్లీ విత్తనాలకు ఏభై తులాల వెండి నిర్ణయించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","అతడు సునాద సంవత్సరం మొదలు తన పొలాన్ని ప్రతిష్ఠించినట్టయితే నీవు నిర్ణయించే వెల ఖాయం. ");
INSERT INTO tel2017_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","సునాద సంవత్సరమైన తరువాత ఒకడు తన పొలాన్ని ప్రతిష్ఠించినట్టయితే యాజకుడు మిగిలిన సంవత్సరాల లెక్క చొప్పున, అంటే మరుసటి సునాద సంవత్సరం వరకూ ఉన్న సంవత్సరాలను బట్టి వెలను నిర్ణయించాలి. నీవు నిర్ణయించిన వెలలో దాని అంచనాను తగ్గించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","పొలాన్ని ప్రతిష్ఠించినవాడు దాన్ని విడిపించుకోవాలనుకుంటే నీవు నిర్ణయించిన వెలలో ఐదో వంతును అతడు దానితో కలపాలి. అప్పుడు అది అతనిదవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","అతడు ఆ పొలాన్ని విడిపించకపోతే లేదా దాన్ని వేరొకడికి అమ్మితే ఇక ఎన్నటికీ దాన్ని విడిపించడం వీలు కాదు. ");
INSERT INTO tel2017_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ఆ పొలం సునాద సంవత్సరంలో విడుదల అయితే అది ప్రతిష్ఠించిన పొలం లాగానే యెహోవాకు ప్రతిష్ఠితం అవుతుంది. ఆ ఆస్తి యాజకునిది అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ఒకడు తాను కొన్న పొలాన్ని, అంటే తన ఆస్తిలో చేరని దాన్ని యెహోవాకు ప్రతిష్ఠించినట్టయితే ");
INSERT INTO tel2017_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","యాజకుడు సునాద సంవత్సరం వరకూ నిర్ణయించిన వెల చొప్పున అతనికి నియమించాలి. ఆ రోజునే నీవు నిర్ణయించిన వెల చొప్పున యెహోవాకు ప్రతిష్ఠితంగా దాని చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","సునాద సంవత్సరంలో ఆ భూమి ఎవరి పిత్రార్జితమో వాడికి, అంటే ఆ పొలాన్ని అమ్మిన వాడికి అది తిరిగి రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","నీ వెలలన్నీ పరిశుద్ధ స్థలం వెల చొప్పున నిర్ణయించాలి. ఒక తులం ఇరవై చిన్నాలు. ");
INSERT INTO tel2017_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","జంతువుల్లో తొలిపిల్ల యెహోవాది గనక ఎవరూ దాన్ని ప్రతిష్ఠించకూడదు. అది ఎద్దు అయినా గొర్రెమేకల మందలోనిదైనా యెహోవాదే. ");
INSERT INTO tel2017_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","అది అపవిత్ర జంతువైతే వాడు నీవు నిర్ణయించే వెలలో ఐదో వంతు దానితో కలిపి దాని విడిపించవచ్చు. దాని విడిపించకపోతే నీవు నిర్ణయించిన వెలకు దాని అమ్మాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","అయితే మనుషుల్లోగాని జంతువుల్లోగాని సొంత పొలంలోగాని తనకు కలిగినవాటన్నిటిలో దేనినైనా ఒకడు యెహోవాకు ప్రతిష్టించినట్టయితే ప్రతిష్ఠించిన దాన్ని అమ్మకూడదు, విడిపించ కూడదు. ప్రతిష్ఠించిన ప్రతిదీ యెహోవాకు అతి పరిశుద్ధంగా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","మనుషులు ప్రతిష్ఠించే వాటిలో దేనినైనా విడిపించకుండా చంపి వేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","ధాన్యంలో, చెట్ల కాయల్లో, భూమి ఫలమంతటిలో పదవ వంతు యెహోవా స్వంతం. అది యెహోవాకు ప్రతిష్ఠితం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ఒకడు తాను చెల్లించవలసిన దశమభాగాల్లో దేనినైనా విడిపించుకోవాలి అనుకుంటే దానిలో ఐదో వంతును దానితో కలపాలి. ");
INSERT INTO tel2017_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ఆవుల్లోగాని, గొర్రె మేకల్లోగాని, కాపరి కర్రతో తోలే వాటన్నిటిలో దశమభాగం ప్రతిష్ఠితం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","అది మంచిదో చెడ్డదో పరీక్ష చెయ్యకూడదు, దాన్ని మార్చకూడదు. దాని మారిస్తే అదీ దానికి బదులుగా ఇచ్చినది కూడా ప్రతిష్ఠితాలు అవుతాయి. అలాటి దాన్ని విడిపించ కూడదు అని చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ఇవి యెహోవా సీనాయి కొండ మీద ఇశ్రాయేలీయుల కోసం మోషేకు ఇచ్చిన ఆజ్ఞలు.");
INSERT INTO tel2017_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","యెహోవా సీనాయి అరణ్యంలో ఉన్న సన్నిధి గుడారంలో నుండి మోషేతో మాట్లాడాడు. ఇది ఇశ్రాయేలు ప్రజలు ఐగుప్తు దేశం నుండి బయటకు వచ్చిన రెండో సంవత్సరం రెండో నెల మొదటి తేదీన జరిగింది. యెహోవా మోషేతో ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ఇశ్రాయేలు ప్రజల జనాభా లెక్కలు వారి వారి వంశాల ప్రకారం, పూర్వీకుల కుటుంబాల ప్రకారం రాయించు. వారి పేర్లు రాయించు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ఇశ్రాయేలు రాజ్యం కోసం సైనికులుగా యుద్ధానికి వెళ్ళగలిగిన వారు, ఇరవై ఇంకా ఆ పై వయసున్న పురుషులందరినీ లెక్కపెట్టు. ఒక్కో దళంలో ఎంతమంది పురుషులున్నారో నువ్వూ, అహరోనూ కలసి నమోదు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","మీతో కలసి సేవ చేయడానికి ఒక్కో గోత్రం నుండి ఒక వ్యక్తి గోత్ర నాయకుడిగా ఉండాలి. అతడు తన తెగలో ప్రముఖుడై ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","మీతో కలసి పోరాటాల్లో పాల్గొనే నాయకులు వీరు. రూబేను గోత్రం నుండి షెదేయూరు కొడుకు ఏలీసూరు, ");
INSERT INTO tel2017_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","షిమ్యోను గోత్రం నుండి సూరీషద్దాయి కొడుకు షెలుమీయేలు, ");
INSERT INTO tel2017_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","యూదా గోత్రం నుండి అమ్మీనాదాబు కొడుకు నయస్సోను, ");
INSERT INTO tel2017_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ఇశ్శాఖారు గోత్రం నుండి సూయారు కొడుకు నెతనేలు ");
INSERT INTO tel2017_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","జెబూలూను గోత్రం నుండి హేలోను కొడుకు ఏలీయాబు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","యోసేపు సంతానమైన ఎఫ్రాయిము గోత్రం నుండి అమీహూదు కొడుకు ఎలీషామాయు, మనష్షే గోత్రం నుండి పెదాసూరు కొడుకు గమలీయేలు, ");
INSERT INTO tel2017_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","బెన్యామీను గోత్రం నుండి గిద్యోనీ కొడుకు అబీదాను, ");
INSERT INTO tel2017_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","దాను గోత్రం నుండి అమీషద్దాయి కొడుకు అహీయెజెరు, ");
INSERT INTO tel2017_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ఆషేరు గోత్రం నుండి ఒక్రాను కొడుకు పగీయేలు, ");
INSERT INTO tel2017_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","గాదు గోత్రం నుండి దెయూవేలు కొడుకు ఎలాసాపు ");
INSERT INTO tel2017_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","నఫ్తాలి గోత్రం నుండి ఏనాను కొడుకు అహీర.” ");
INSERT INTO tel2017_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","వీళ్ళంతా ప్రజల్లోనుండి నియమితులయ్యారు. వీరు తమ పూర్వీకుల గోత్రాలకు నాయకులుగానూ, ఇశ్రాయేలు ప్రజల తెగలకు పెద్దలుగానూ ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ఈ పేర్లతో ఉన్న వ్యక్తులను మోషే అహరోనులు పిలిచారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","వీళ్ళతో పాటు ఇశ్రాయేలు ప్రజల్లో పురుషులందరినీ రెండో నెల మొదటి రోజున సమావేశపర్చారు. ఇరవై ఏళ్ళూ ఆ పై వయసున్న వారు తమ తమ వంశాలనూ, పూర్వీకుల కుటుంబాలనూ తమ తెగల పెద్దల పేర్లనూ తెలియజేసారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","అప్పుడు యెహోవా తనకాజ్ఞాపించినట్టుగా సీనాయి అరణ్యంలో మోషే వారి సంఖ్య నమోదు చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ఇశ్రాయేలు మొదటి కొడుకు రూబేను సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","అలా రూబేను గోత్రం నుండి 46, 500 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","షిమ్యోను సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","అలా షిమ్యోను గోత్రం నుండి 59, 300 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","గాదు సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","అలా గాదు గోత్రం నుండి 45, 650 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","యూదా సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాల, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","అలా యూదా గోత్రం నుండి 74, 600 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ఇశ్శాఖారు సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","అలా ఇశ్శాఖారు గోత్రం నుండి 54, 400 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","జెబూలూను సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","అలా జెబూలూను గోత్రం నుండి 57, 400 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","యోసేపు కొడుకుల్లో ఒకడైన ఎఫ్రాయిము సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","అలా ఎఫ్రాయిము గోత్రం నుండి 40, 500 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","మనష్షే సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","అలా మనష్షే గోత్రం నుండి 32, 200 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","బెన్యామీను సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","అలా బెన్యామీను గోత్రం నుండి 35, 400 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","దాను సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","అలా దాను గోత్రం నుండి 62, 700 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ఆషేరు సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","అలా ఆషేరు గోత్రం నుండి 41, 500 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","నఫ్తాలి సంతానం వివరాలు ఇవి. వారిలో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధానికి వెళ్ళే సామర్థ్యం ఉన్నవారు తమ తమ వంశాలూ, పూర్వీకుల కుటుంబాల ప్రకారం పేర్లు నమోదు చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","అలా నఫ్తాలి గోత్రం నుండి 53, 400 మందిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ఇశ్రాయేలులోని పన్నెండు గోత్రాలకు నాయకత్వం వహించిన వారితో పాటు వీరందర్నీ మోషే అహరోనులు లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ఆ విధంగా ఇశ్రాయేలు ప్రజల్లో ఇరవై ఏళ్ళూ అంతకంటే ఎక్కువ వయస్సుండి, యుద్ధాలకు వెళ్ళగలిగే వారిందర్నీ వారి వారి పూర్వీకుల కుటుంబాల ప్రకారం లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","వారింతా కలసి 6,03,550 మంది అయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","కాని లేవీ వారసులను వారు లెక్కించలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ఎందుకంటే యెహోవా మోషేకి ఇంతకు ముందే ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“లేవీ గోత్రికులను ఇశ్రాయేలు జనసంఖ్యలో చేర్చకూడదు. వారిని నమోదు చేయవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","వాళ్లకు నిబంధన శాసనాల గుడారం బాధ్యతలు అప్పగించు. శాసనాల గుడారం లోని అలంకరణలూ, వస్తువులన్నిటినీ వారు చూసుకోవాలి. లేవీయులే గుడారాన్ని మోసుకుంటూ వెళ్ళాలి. దానిలో ఉన్న వస్తువులను వారే మోయాలి. దాని చుట్టూ వారు తమ గుడారాలు వేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","గుడారాన్ని మరో స్థలానికి తరలించాల్సి వస్తే లేవీయులే దాన్ని ఊడదీయాలి. తిరిగి గుడారాన్ని నిలపాలన్నా లేవీయులే దాన్ని నిలపాలి. ఎవరన్నా పరాయి వ్యక్తి గుడారాన్ని సమీపిస్తే వాడికి మరణ శిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ఇశ్రాయేలు ప్రజలు వారి వారి సైనిక దళానికి చెందిన జెండా ఎక్కడ నాటారో అక్కడే తమ గుడారాలు వేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","నా కోపం ఇశ్రాయేలు ప్రజలపైకి రాకుండా ఉండాలంటే లేవీయులు నిబంధన శాసనాల గుడారం చుట్టూ తమ నివాసాలు ఏర్పాటు చేసుకోవాలి. నిబంధన శాసనాల గుడారాన్ని వారే జాగ్రత్తగా చూసుకోవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ఇశ్రాయేలు ప్రజలు ఈ ఆజ్ఞల ప్రకారం అన్నీ చేసారు. యెహోవా మోషేకు ఆజ్ఞాపించిన వాటన్నిటినీ ఇశ్రాయేలు ప్రజలు నెరవేర్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","యెహోవా మరోసారి మోషే, అహరోనులతో మాట్లాడాడు. ఆయన ఇలా అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ఇశ్రాయేలు ప్రజల్లో ప్రతి ఒక్కరూ సైన్యంలో తమ దళానికి చెందిన పతాకం చుట్టూ, తన గోత్రాన్ని సూచించే చిన్నజెండా చుట్టూ తమ గుడారాలు వేసుకోవాలి. సన్నిధి గుడారానికి అభిముఖంగా వారి గుడారాలు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","యూదా శిబిరానికి చెందిన వారు తమ సైనిక దళంతో యూదా పతాకం చుట్టూ తమ గుడారాలు వేసుకోవాలి. ఇవి సన్నిధి గుడారానికి తూర్పు దిక్కున సూర్యుడు ఉదయించే వైపున ఉండాలి. యూదా సైనిక దళానికి అమ్మీనాదాబు కొడుకు నయస్సోను నాయకత్వం వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","యూదా దళంలో నమోదైన వారు 74, 600 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","యూదా గోత్రం సమీపంలో ఇశ్శాఖారు గోత్రం వారు తమ శిబిరం ఏర్పాటు చేసుకోవాలి. సూయారు కొడుకు నెతనేలు ఇశ్శాఖారు గోత్రం వారి నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","నెతనేలుతో ఉన్న సైన్యంలో 54, 400 మంది పురుషులు నమోదయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ఇశ్శాఖారు గోత్రం వారి తరువాత జెబూలూను గోత్రం వారుండాలి. హేలోను కొడుకు ఏలీయాబు జెబూలూను గోత్రం వారి నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","అతని దళంలో నమోదైన వారు 57, 400 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","యూదా వారితో కలసి శిబిరం ఏర్పాటు చేసుకున్న వారు మొత్తం లెక్కిస్తే 1, 86, 400 మంది పురుషులు ఉన్నారు. వీరు మొదటగా శిబిరం నుండి కదిలి వెళ్ళాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","దక్షిణ దిక్కున రూబేను దళం తమ పతాకం చుట్టూ గుడారాలు వేసుకోవాలి. షెదేయూరు కొడుకు ఏలీసూరు రూబేను సైనిక దళాలకు నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","అతని సైన్యంలో నమోదైన వారు 46, 500 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","రూబేను గోత్రం వారి పక్కనే షిమ్యోను గోత్రం వారు తమ గుడారాలు వేసుకోవాలి. సూరీషద్దాయి కొడుకు షెలుమీయేలు షిమ్యోను గోత్రం వాళ్లకు నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","అతని దళంలో నమోదైన వారు 59, 300 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","తరువాత గాదు గోత్రం ఉండాలి. రగూయేలు కుమారుడు ఏలీయాసాపు గాదు గోత్రానికి నాయకత్వం వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","అతని సైన్యంలో నమోదైన వారు 45, 650 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","కాబట్టి రూబేను గోత్రం వారితో కలసి శిబిరం ఏర్పాటు చేసుకున్న వారి మొత్తం లెక్కిస్తే 1, 51, 450 మంది పురుషులు ఉన్నారు. వీళ్ళంతా రెండో వరుసలో ముందుకు నడవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","సన్నిధి గుడారం శిబిరం నుండి మిగిలిన గోత్రాలన్నిటి మధ్యలో లేవీయులతో కలసి ముందుకు కదలాలి. వారు శిబిరంలోకి ఏ క్రమంలో వచ్చారో అదే క్రమంలో శిబిరం నుండి బయటకు వెళ్ళాలి. ప్రతి ఒక్కడూ తన స్థానంలో ఉండాలి. తన పతాకం దగ్గరే ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ఎఫ్రాయిము గోత్రం సన్నిధి గుడారానికి పడమటి వైపున ఉండాలి. అమీహూదు కొడుకు ఎలీషామా ఎఫ్రాయిము సైన్యాలకు నాయకత్వం వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ఎఫ్రాయిము సైన్యంగా నమోదైన వారు 40, 500 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","మనష్షే గోత్రం వారు ఎఫ్రాయిము గోత్రం వారి పక్కనే ఉండాలి. పెదాసూరు కొడుకు గమలీయేలు మనష్షే సైన్యాలకు నాయకుడుగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","అతని సైన్యంగా నమోదైన వారు 32, 200 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","మనష్షే గోత్రం వాళ్లకు దగ్గర్లోనే బెన్యామీను గోత్రం వారుండాలి. గిద్యోనీ కొడుకు అబీదాను బెన్యామీను సైన్యాలకు నాయకుడుగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","అతని సైన్యంగా నమోదైన వారు 35, 400 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","కాబట్టి ఎఫ్రాయిము గోత్రం వారితో కలసి శిబిరం ఏర్పాటు చేసుకున్న వారి మొత్తం లెక్కిస్తే 1,08,100 మంది పురుషులు ఉన్నారు. వారింతా మూడో వరుసలో శిబిరం నుండి కదలాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","దాను శిబిరానికి చెందిన వారు తమ సైనిక దళంతో దాను పతాకం చుట్టూ తమ గుడారాలు వేసుకోవాలి. సన్నిధి గుడారానికి ఉత్తరం వైపున తమ గుడారాలు వేసుకోవాలి. అమీషదాయి కొడుకు అహీయెజెరు దాను గోత్రానికి నాయకత్వం వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","దాను గోత్రానికి చెందిన సైన్యంగా నమోదైన వారు 62, 700 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","అతనికి దగ్గరలోనే ఆషేరు గోత్రం వారు ఉండాలి. ఒక్రాను కొడుకు పగీయేలు ఆషేరు సైన్యానికి నాయకుడుగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","అతని సైన్యంగా 41, 500 మంది పురుషులు నమోదయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ఆషేరు గోత్రం వాళ్లకు దగ్గరలోనే నఫ్తాలి గోత్రం వారుండాలి. ఏనాను కొడుకు అహీర నఫ్తాలి గోత్రం వాళ్లకు నాయకుడిగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","నఫ్తాలి గోత్రం వారి సైన్యంగా నమోదైన వారు 53, 400 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","కాబట్టి దాను గోత్రం వారితో కలసి శిబిరం ఏర్పాటు చేసుకున్న వారు మొత్తం లెక్కిస్తే 1, 57, 600 మంది పురుషులు ఉన్నారు. వీరు తమ ధ్వజాల ప్రకారం చివరి బృందంగా నడవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ఇశ్రాయేలు ప్రజల్లో తమ తమ పూర్వీకుల కుటుంబాల ప్రకారం మోషే, అహరోనులు వీళ్ళను లెక్కించారు. వీరు మొత్తం 6,03,550 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","అయితే యెహోవా మోషేకి ఆజ్ఞాపించిన ప్రకారం లేవీయుల సంఖ్య లెక్కపెట్టలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ఈ విధంగా ఇశ్రాయేలు ప్రజలు మోషేకి యెహోవా ఆజ్ఞాపించినదంతా చేసారు. వారు తమ తమ ధ్వజాల దగ్గర గుడారాలు వేసుకున్నారు. శిబిరం నుండి బయటకు వెళ్ళినప్పుడు తమ పూర్వీకుల కుటుంబాల క్రమంలో వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","యెహోవా సీనాయి కొండపైన మోషేతో మాట్లాడిన నాటికి అహరోను మోషేల సంతానం వివరాలు ఇవి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","అహరోను పెద్ద కొడుకు నాదాబు. ఆ తరువాత అబీహు, ఎలియాజరు, ఈతామారు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ఈ పేర్లు కలిగిన అహరోను కొడుకులు యాజకులుగా పనిచేయడానికి అభిషేకం పొందారు. వారిని యాజకులుగా ప్రతిష్టించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","కాని నాదాబు, అబీహు సీనాయి అరణ్యంలో దేవునికి అంగీకారం కాని అగ్నిని అర్పించినప్పుడు యెహోవా సమక్షంలో పడి చనిపోయారు. నాదాబు, అబీహులకు పిల్లలు లేరు. కాబట్టి ఎలియాజరు, ఈతామారు మాత్రమే తమ తండ్రి అయిన అహరోనుతో కలసి యాజక సేవ జరిగించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","తరువాత యెహోవా మోషేతో ఇలా చెప్పాడు. “నువ్వు లేవీ గోత్రం వారిని తీసుకుని రా. ");
INSERT INTO tel2017_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","వారిని అహరోను ఎదుట నిలబెట్టు. వారు అతనికి సహాయకులుగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","వారు సన్నిధి గుడారం ఎదుట అహరోను తరపునా, సమాజమంతటి తరపునా బాధ్యతలు నిర్వర్తించాలి. వారు దేవుని మందిరంలో పరిచర్య చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","సన్నిధి గుడారంలోని అలంకరణలూ, వస్తువుల విషయమై వారు జాగ్రత్త తీసుకోవాలి. ఇశ్రాయేలు గోత్రాల ప్రజలు మందిరంలో సేవ చేస్తున్నప్పుడు వాళ్లకి సహాయం చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","కాబట్టి నువ్వు లేవీయులను అహరోనుకూ అతని కొడుకులకూ అప్పగించు. ఇశ్రాయేలు ప్రజలకి సేవ చేయడంలో వారు అహరోనుకి సాయంగా ఉండాలి. వారు సంపూర్ణంగా అతనికి స్వాధీనం అయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","నువ్వు అహరోనునూ అతని కొడుకులను యాజకులుగా నియమించు. ఆ పరిచర్య చేయడానికి పరాయి వాడు ఎవడన్నా సమీపిస్తే వాడికి మరణ శిక్ష విధించాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","యెహోవా మోషేతో ఇంకా మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ఇశ్రాయేలు ప్రజల్లో నుండి నేను లేవీయులను ఎన్నుకున్నాను. ఇశ్రాయేలు ప్రజల్లో నుండి ప్రతి మొదటి మగ సంతానాన్ని తీసుకోడానికి బదులుగా నేను లేవీయులను తీసుకున్నాను. వారు నా వారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","మొదటి సంతానం నాకు చెందుతుంది. ఐగుప్తు దేశంలో నేను వారి మొదటి సంతానాన్ని సంహరించినప్పుడు ఇశ్రాయేలులో మనుషుల్లోనూ, పశువుల్లోనూ మొదటి సంతానాన్ని నా కోసం నేను ప్రత్యేక పరచుకున్నాను. వారు నా వారు. అవి నావి. నేనే యెహోవాను.” ");
INSERT INTO tel2017_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","సీనాయి అరణ్యంలో యెహోవా మోషేకు ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“లేవీ వంశానికి చెందిన వాళ్లందర్నీ లెక్కించు. వారి వారి పూర్వీకుల కుటుంబాల ప్రకారం, వారి వంశాల ప్రకారం లెక్కించు. లేవీ వంశానికి చెందిన వాళ్లందర్నీ లెక్కించు. వారి పూర్వీకుల కుటుంబాల ప్రకారం, వారి వంశాల ప్రకారం లెక్కించు. ఒక నెల వయసున్న పిల్లల నుండి పురుషులందరినీ లెక్కపెట్టు.” ");
INSERT INTO tel2017_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","మోషే యెహోవా తనకు ఆదేశించిన ప్రకారం ఆయన చెప్పినట్టే వారిని లెక్కించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","లేవీకి గెర్షోను, కహాతు, మెరారి అనే కొడుకులున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","గెర్షోను కొడుకుల పేర్లు లిబ్నీ, షిమీ. ఈ పేర్లతో పిలిచే తెగలకు వీరే వంశకర్తలు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","కహాతు కొడుకుల పేర్లు అమ్రాము, ఇస్హారు, హెబ్రోను, ఉజ్జీయేలు. ఈ పేర్లతో పిలిచే తెగలకు వీరే వంశకర్తలు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","మెరారి కొడుకుల పేర్లు మాహలి, మూషి. ఈ పేర్లతో పిలిచే తెగలకు వీరే వంశకర్తలు. ఇవి లేవీ వంశానికి చెందిన తెగలు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","గెర్షోను వంశస్తులు లిబ్నీయులు, షిమీయులు. గెర్షోనీయుల తెగలు అంటే వీరే. ");
INSERT INTO tel2017_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","వీళ్ళలో ఒక నెల వయసున్న మగ పిల్లల నుండి లెక్క పెడితే మొత్తం 7, 500 మంది ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","గెర్షోనీయుల తెగలు దేవుని మందిరానికి పడమటి దిశగా అంటే వెనుక వైపున గుడారాలు వేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","గెర్షోనీయుల తెగలకు లాయేలు కుమారుడు ఎలీయాసాపు నాయకత్వం వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","గెర్షోను వంశం వారు సన్నిధి గుడారంలో మందిరానికీ, పైకప్పుగా ఉన్న తెరలకు బాధ్యత వహించాలి. ఇంకా గుడారానికీ, పైకప్పుకీ, సన్నిధి గుడారం ప్రవేశద్వారం దగ్గర ఉండే తెరలకీ బాధ్యత వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","మందిరమూ, బలిపీఠమూ ఉండే ఆవరణ అడ్డతెరలకూ, ఆవరణ ద్వారం దగ్గర ఉండే తెరలకూ వారు బాధ్యత వహించాలి. సన్నిధి గుడారం లోని తాళ్లకీ దానిలో ఉన్న సమస్తానికీ వారు బాధ్యత వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","కహాతు నుండి అమ్రామీయులు, ఇస్హారీయులు, హెబ్రోనీయులు, ఉజ్జీయేలీయులు అనే తెగలు కలిగాయి. ఇవి కహాతీయుల తెగలు ");
INSERT INTO tel2017_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","వీళ్ళలో ఒక నెల వయసున్న మగ పిల్లల నుండి లెక్క పెడితే మొత్తం 8, 600 మంది ఉన్నారు. వీరు పరిశుద్ధ స్థలం బాధ్యత తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","కహాతు వంశస్తులు మందిరం దక్షిణం వైపున తమ గుడారాలు వేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","కహాతీయుల తెగలకు ఉజ్జీయేలు కొడుకు ఎలీషాపాను నాయకత్వం వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","వీరు మందసం, బల్ల, దీపస్తంభం, వేదికలు, పరిశుద్ధ స్థలంలోని వస్తువులు, పరిశుద్ధస్థలం తెర ఇంకా పరిశుద్ధస్థలంలో ఉన్న వాటి విషయమై బాధ్యత వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","లేవీయులను నడిపించే వారందరికీ యాజకుడైన అహరోను కొడుకు ఎలియాజరు నాయకత్వం వహించాలి. అతడు పరిశుద్ధస్థలం బాధ్యత తీసుకున్న వారిని పర్యవేక్షించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","మెరారి నుండి రెండు తెగలు కలిగాయి. అవి మహలీయులు, మూషీయులు. ఇవి మెరారి తెగలు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","వీళ్ళలో ఒక నెల వయసున్న మగ పిల్లల నుండి లెక్క పెడితే మొత్తం 6, 200 మంది ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","మెరారీ తెగలకు అబీహాయిలు కొడుకు సూరీయేలు నాయకత్వం వహించాలి. వారు మందిరానికి ఉత్తరం వైపున తమ గుడారాలు వేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","మెరారి వంశస్తులు మందిరపు పలకలకూ, దాని అడ్డకర్రలకూ, దాని స్తంభాలకూ, దాని మూలాలకూ, దాని స్థిర సామగ్రికీ, ఇంకా దానికి సంబంధిన వాటన్నిటికీ, ");
INSERT INTO tel2017_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","అంటే దాని చుట్టూ ఉన్న ఆవరణ స్తంభాలకీ, వాటి దిమ్మలకీ, మేకులకీ, తాళ్లకీ బాధ్యత వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","మోషే, అహరోనూ, అతని కొడుకులూ మందిరానికి తూర్పు వైపున సూర్యోదయ దిశగా సన్నిధి గుడారానికి ఎదురుగా తమ గుడారాలు వేసుకోవాలి. ఇశ్రాయేలు ప్రజలు చేయాల్సిన పనులకూ, పరిశుద్ధ స్థలంలో నెరవేర్చాల్సిన విధులకూ వారు బాధ్యత వహించాలి. పరాయి వాడు ఎవడైనా పరిశుద్ధ స్థలాన్ని సమీపిస్తే వాడికి మరణ శిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","యెహోవా తమకు ఆదేశించినట్లు మోషే అహరోనులు లేవీ వంశంలో ఒక నెల వయసున్న మగ బిడ్డ నుండి అందర్నీ లెక్కించారు. వారు 22,000 మంది అయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","తరువాత యెహోవా మోషేతో ఇలా చెప్పాడు “ఇశ్రాయేలు ప్రజల్లో మొదటి సంతానం అయిన పురుషులను ఒక నెల, ఆ పై వయసున్న వారిందర్నీ లెక్క పెట్టు. వారి పేర్లు రాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","నేనే యెహోవాను. ఇశ్రాయేలు ప్రజల్లో మొదటి సంతానానికి బదులుగా నాకోసం లేవీ జాతి వారిని వేరు చెయ్యి. అలాగే ఇశ్రాయేలు ప్రజలకు చెందిన పశువుల్లో మొదటి సంతానానికి బదులుగా లేవీ జాతి వారి పశువులను నాకోసం తీసుకోవాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","యెహోవా తనకు ఆదేశించిన విధంగా మోషే ఇశ్రాయేలు ప్రజల్లో మొదటి సంతానాన్ని లెక్కపెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ఒక నెల, ఆ పై వయసున్న మొదటి మగ సంతానాన్ని లెక్కించాడు. వారి సంఖ్య 22, 273 అయింది. ");
INSERT INTO tel2017_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","తరువాత యెహోవా మోషేకి ఇలా ఆదేశించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ఇశ్రాయేలు ప్రజల్లో మొదటి సంతానం అయిన 22, 273 మందిలో ప్రతివాడికి బదులుగా నువ్వు లేవీ జాతి వారిని వారి పశువులకి బదులుగా లేవీ జాతి వారి పశువులను తీసుకో. లేవీ జాతి వారు నా వారుగా ఉంటారు. నేనే యెహోవాను. ");
INSERT INTO tel2017_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ఇశ్రాయేలు ప్రజల్లో మొదటి పుట్టినవారు లేవీ జాతి వారి కంటే 273 మంది ఎక్కువ అయ్యారు. వారిని విడిపించడం కోసం ఒక్కొక్కరి దగ్గర ఐదేసి తులాల వెండి తీసుకో. ");
INSERT INTO tel2017_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","పరిశుద్ధ స్థలంలో ప్రమాణమైన తులం బరువులో అది ఉండాలి. ఒక తులం 20 చిన్నాలు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ఎక్కువైన వారిని విడిపించడానికి సేకరించిన ఆ ధనాన్ని అహరోనుకూ అతని కొడుకులకూ ఇవ్వాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","కాబట్టి మోషే లేవీ జాతివారి కంటే ఎక్కువగా ఉన్న వారి దగ్గర ఆ విడుదల సొమ్మును సేకరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ఇశ్రాయేలు ప్రజల పెద్ద కొడుకుల దగ్గర ఆ సొమ్మును సేకరించాడు. పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం ప్రకారం 1, 365 తులాలు సేకరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","మోషే తనకు యెహోవా ఆదేశించినట్లు ఆ విడుదల సొమ్మును అహరోనుకీ అతని కొడుకులకీ ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","యెహోవా మోషే అహరోనులతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“లేవీ గోత్రం ప్రజల్లోని కహాతు వంశస్తుల్లో పురుషులను వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం లెక్క పెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","వారిలో ముప్ఫై ఏళ్ల వయస్సు నుండి యాభై ఏళ్ల వరకూ ఉన్న వారిని లెక్క పెట్టు. వీరు సన్నిధి గుడారంలో సేవలో చేరాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","సన్నిధి గుడారంలో నా కోసం జరగాల్సిన అతి పరిశుద్ధమైన పరిచర్యలకు కహాతు వంశస్తులు బాధ్యత తీసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ప్రజలు ప్రయాణానికి సిద్ధమైనప్పుడు అహరోనూ, అతని కుమారులూ గుడారంలోకి వెళ్ళాలి. అక్కడ పరిశుద్ధ స్థలానికీ అతి పరిశుద్ధ స్థలానికీ మధ్యలో ఉన్న అడ్డ తెరలను దించాలి. ఆ తెరలతో నిబంధన శాసనాలున్న మందసం పెట్టెను కప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","దానిపైన డాల్ఫిన్ చర్మాన్ని కప్పాలి. ఇంకా దానిపైన నీలం రంగు బట్ట పరచాలి. దాన్ని మోసుకు వెళ్ళడానికి పెట్టెకు ఉన్న రింగుల్లో కర్రలు దూర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","సన్నిధి బల్ల పైన నీలం రంగు బట్టను పరచి దాని పైన గిన్నెలను, గరిటెలను, పాత్రలను, నీళ్ళు పోయడానికి కలశాలను ఉంచాలి. దాని పైన రొట్టె ప్రతినిత్యం ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","దాని పైన ఎర్రటి బట్టను పరచాలి. తిరిగి దాని పైన డాల్ఫిన్ చర్మాన్ని కప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","తరువాత వారు నీలం రంగు బట్టను తీసుకుని దానితో ఏడు దీపాల స్తంభాన్నీ, దాని దీపాలను, కత్తెరనూ కత్తెర పళ్ళాలను, దీపాల్లో పోసే నూనె పాత్రలనూ కప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ఏడు దీపాల స్తంభాన్నీ, దానికి సంబంధించిన పరికరాలన్నిటినీ గండుచేప చర్మంలో చుట్టి మోసుకు వెళ్ళడానికి వీలుగా కర్రల పైన ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","తరువాత బంగారు బలిపీఠం పైన నీలం రంగు బట్ట పరచాలి. దాన్ని గండుచేప చర్మంలో చుట్టి దానికున్న రింగుల్లో కర్రలు దూర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","తరువాత పరిశుద్ధ స్థలంలో సేవకు ఉపయోగించే పరికరాలన్నిటి పైనా నీలం రంగు బట్ట పరచాలి. దాన్ని గండుచేప చర్మంలో చుట్టి మోసుకు వెళ్ళడానికి వీలుగా కర్రల పైన ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","బలిపీఠం పైన బూడిదను తీసివేసి దానిపై ఊదా రంగు బట్ట పరచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","బలిపీఠం దగ్గర సేవకై ఉపయోగించే పరికరాలన్నిటినీ మోసుకు వెళ్ళడానికి వీలుగా కర్రలపైన ఉంచాలి. ఈ పరికరాలేవంటే నిప్పు తెచ్చే పాత్రలూ, ముళ్ళ గరిటెలూ, పారలూ, గిన్నెలూ. బలిపీఠాన్ని గండుచేప చర్మంలో చుట్టి మోసుకు వెళ్ళడానికి వీలుగా దానికున్న రింగుల్లో కర్రలు దూర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","అహరోనూ అతని కొడుకులూ పరిశుద్ధ స్థలాన్నీ, దానికి సంబంధించిన పరికరాలన్నిటినీ సంపూర్ణంగా కప్పిన తరువాత ప్రజలు ప్రయాణం మొదలు పెట్టినప్పుడు కహాతు వంశస్తులు పరిశుద్ధ స్థలాన్ని మోయడానికి ముందుకు రావాలి. అయితే వారు పరిశుద్ధ పరికరాలను ముట్టుకుంటే చనిపోతారు. సన్నిధి గుడారంలోని పరికరాలను మోసుకు వెళ్ళడం కహతు వంశస్తుల బాధ్యత. ");
INSERT INTO tel2017_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","యాజకుడు అహరోను కొడుకు ఎలియాజరు దీపాల్లో నూనె ఉందో లేదో చూసుకోవాలి. అలాగే అతడు పర్యవేక్షించాల్సిన బాధ్యతలు, పరిమళ సాంబ్రాణి, నైవేద్యం, అభిషేకానికి వాడే నూనె, మొత్తం మందిరం, దానిలోనివన్నీ, పరిశుద్ధ పరికరాలు, వస్తువులు-వీటన్నిటికీ అతడు బాధ్యత వహించాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","తరువాత యెహోవా మోషే, అహరోనులతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“మీరు కహాతు తెగ వారిని లేవీ గోత్రం నుండి వేరు కానీయవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","వారు పరిశుద్ధమైన వాటిని సమీపించి చావకుండా వారిని పరిరక్షించండి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","వారు పరిశుద్ధ స్థలంలోకి ఒక్క క్షణం కూడా వెళ్ళడానికి వీల్లేదు. అలా వెళ్తే వారు చనిపోతారు. అహరోనూ, అతని కొడుకులూ లోపలికి వెళ్ళాలి. ఆ తరువాత కహాతు వారిలో ఒక్కొక్కరికీ వారు చేయాల్సిన పనినీ, వారి ప్రత్యేక విధులను అప్పగించాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","తరువాత యెహోవా మోషే, అహరోనులతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“గెర్షోను వంశస్తులను కూడా వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం లెక్కించండి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","వారిల్లో ముప్ఫై ఏళ్ల నుండి యాభై ఏళ్ల వయసున్న వారిని లెక్కించండి. సన్నిధి గుడారంలో సేవ చేయడానికి ఈ వయస్సులో ఉన్న వారినందర్నీ లెక్కపెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","గెర్షోను తెగల వారు చేయాల్సిన సేవలూ, వారు మోయాల్సిన బరువులూ ఇవి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","వారు సన్నిధి గుడారాన్నీ, మందిరం తెరలను, దాని పైకప్పునూ దాని పైన కప్పి ఉన్న గండుచేప చర్మాన్నీ, సన్నిధి గుడారం ప్రవేశం దగ్గర ఉన్న తెరలనూ మోసుకు వెళ్ళాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","మందిరానికీ, బలిపీఠానికీ సమీపంగా ఉండే ఆవరణలోని తెరలను, ఆవరణ ద్వారం దగ్గర ఉండే తెరలను వాటి తాళ్లనూ, వాటి సేవకి సంబంధించిన పరికరాలన్నిటినీ వారు మోసుకు వెళ్ళాలి. వీటితో చేయాల్సిన పనులన్నీ వారు చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","గెర్షోను తెగల ప్రజలు చేయాల్సిన సేవల విషయంలో, వారు మోయాల్సిన బరువుల విషయంలో వారిని అహరోనూ అతడి కొడుకులూ నిర్దేశించాలి. వారి బాధ్యతలను వాళ్లకు మీరు అప్పగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","సన్నిధి గుడారం దగ్గర గెర్షోను తెగల ప్రజలు జరిగించాల్సిన సేవ ఇది. యాజకుడు అహరోను కొడుకు ఈతామారు చేతి కింద వారు తమ సేవ జరిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","మెరారి వంశస్తులను వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం లెక్కించండి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","వారిల్లో ముప్ఫై ఏళ్ల నుండి యాభై ఏళ్ల వయసున్న వారిని లెక్కించండి. సన్నిధి గుడారంలో సేవ చేయడానికి ఈ వయస్సులో ఉన్న వారినందర్నీ లెక్కపెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","సన్నిధి గుడారంలో వారు తమ బాధ్యతగా జరిగించాల్సిన సేవలు ఇవి. వారు మందిరం చట్రాన్నీ, దాని అడ్డ కర్రలను, స్తంభాలను, దాని దిమ్మలను చూసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","వీటితో పాటు మందిరం చుట్టూ ఉన్న ఆవరణలోని స్తంభాలను, వాటి దిమ్మలను, మేకులను, వాటి తాళ్లనూ, వాటికి సంబంధించిన సామగ్రినీ జాగ్రత్తగా చూసుకోవాలి. వారు మోసుకు వెళ్ళాల్సిన బరువులను పేర్ల వరుసలో రాసి ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","మెరారి తెగల ప్రజలు సన్నిధి గుడారంలో యాజకుడు అహరోను కొడుకు ఈతామారు చేతికింద చేయాల్సిన సేవ ఇది.” ");
INSERT INTO tel2017_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","అప్పుడు మోషే, అహరోనూ, సమాజంలోని నాయకులూ కహాతు తెగల ప్రజలను వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","వారిల్లో ముప్ఫై ఏళ్ళు నుండి యాభై ఏళ్ల వయసున్న వారిని సన్నిధి గుడారంలో సేవ చేయడానికి చేరే వారిందర్నీ లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","వారి తెగల ప్రకారం 2 750 మంది మగ వారిని లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","కహాతు తెగల ప్రజల్లో నుండి సన్నిధి గుడారంలో సేవ చేయడానికి మోషే, అహరోనులు వీరిని లెక్కించారు. మోషే ద్వారా యెహోవా పలికిన ఆజ్ఞకు లోబడి వారు ఈ పని చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","గెర్షోను తెగల ప్రజలను వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","వారిల్లో ముప్ఫై ఏళ్ళు నుండి యాభై ఏళ్ల వయసున్న వారిని, సన్నిధి గుడారంలో సేవ చేయడానికి చేరే వారందర్నీ లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం 2, 630 మంది పురుషులను లెక్కపెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","గెర్షోను తెగల ప్రజల్లోనుండి సన్నిధి గుడారంలో సేవ చేయడానికి మోషే, అహరోనులు వీళ్ళను లెక్కించారు. మోషే ద్వారా యెహోవా పలికిన ఆజ్ఞకు లోబడి వారు ఈ పని చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","మెరారి తెగల ప్రజలను వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","వారిల్లో ముప్ఫై ఏళ్ళు నుండి యాభై ఏళ్ల వయసున్న వారిని, సన్నిధి గుడారంలో సేవ చేయడానికి చేరే వారిందర్నీ లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం 3 200 మంది పురుషులను లెక్కపెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","మెరారి తెగల ప్రజల్లోనుండి సన్నిధి గుడారంలో సేవ చేయడానికి మోషే, అహరోనులు వీరిని లెక్కించారు. మోషే ద్వారా యెహోవా పలికిన ఆజ్ఞకు లోబడి వారు ఈ పని చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ఈ విధంగా మోషే, అహరోనూ, ఇశ్రాయేలు ప్రజల నాయకులూ లేవీ గోత్రం వారిందర్నీ వారి తెగల ప్రకారం, వారి పూర్వీకుల కుటుంబాల ప్రకారం లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","వారిల్లో ముప్ఫై ఏళ్ళు నుండి యాభై ఏళ్ల వయసున్న వారిని, మందిరంలో సేవ చేయడానికి చేరే వారిందర్నీ, సన్నిధి గుడారంలో బరువులు మోసే వారిని లెక్కించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","అలా మొత్తం 8, 580 మంది మగ వారిని లెక్క పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","యెహోవా ఇచ్చిన ఆజ్ఞ ప్రకారం మోషే వారిని లెక్కించాడు. వారిలో ప్రతి ఒక్కడూ తాను చేసే సేవల ప్రకారం, మోసే బరువుల ప్రకారం నమోదయ్యారు. ఈ విధంగా మోషే ద్వారా యెహోవా పలికిన ఆజ్ఞకు విధేయత చూపారు. ");
INSERT INTO tel2017_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","తరువాత యెహోవా మోషేతో మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ఇశ్రాయేలు ప్రజలకి ఇలా ఆజ్ఞాపించు. చర్మంలో అంటువ్యాధి కలిగిన వాణ్ణీ, శరీరంలో నుండి స్రావం అవుతున్న వాణ్ణీ, శవాన్ని ముట్టుకుని అపవిత్రుడైన వాణ్ణి శిబిరంలో నుండి బయటికి పంపివేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","వారు ఆడవారైనా మగవారైనా శిబిరం నుండి బయటకు పంపించి వేయాలి. వారు శిబిరాన్ని కలుషితం చేయడానికి వీల్లేదు. ఎందుకంటే నేను శిబిరంలో వారి మధ్య నివసిస్తున్నాను.” ");
INSERT INTO tel2017_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ఇశ్రాయేలు ప్రజలు అలాగే చేశారు. యెహోవా మోషేకి ఆజ్ఞాపించినట్లు అలాంటి వారిని శిబిరం బయటకు వెళ్ళగొట్టారు. ఇశ్రాయేలు ప్రజలు యెహోవాకు విధేయత చూపారు. ");
INSERT INTO tel2017_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","యెహోవా మరోసారి మోషేతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. “ఇశ్రాయేలు ప్రజలకి ఇలా చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","పురుషుడు గానీ స్త్రీ గానీ ఏదన్నా పాపం చేసి నాకు ద్రోహం చేస్తే ఆ వ్యక్తి అపరాధి అవుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","అప్పుడు అతడు తాను చేసిన పాపాన్ని ఒప్పుకోవాలి. తాను చేసిన పాపం వల్ల కలిగిన నష్టాన్ని అతడు చెల్లించాలి. ఆ రుసుముకి అదనంగా దానిలో ఐదో వంతు కలిపి చెల్లించాలి. తాను ఎవరికి విరోధంగా పాపం చేసాడో వారికి దాన్ని చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ఆ అపరాధ చెల్లింపుని తీసుకోడానికి ఆ వ్యక్తికి దగ్గర బంధువు ఎవరూ లేకుంటే అతడు ఆ సొమ్మును యాజకుడి ద్వారా నాకు చెల్లించాలి. దాంతోపాటు ఒక పొట్టేలును తన పరిహారం కోసం అర్పించాలి. ఆ సొమ్ముతో పాటు పొట్టేలు కూడా యాజకునిదవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ఇశ్రాయేలు ప్రజలు యాజకునికి సమర్పించేదీ, నా కోసం ప్రతిష్టించినదీ ఏదైనా యాజకునికే చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ప్రతిష్టిత వస్తువులు ఎవరి దగ్గర ఉన్నా అవి యాజకునికే చెందుతాయి. యాజకునికి ఇచ్చింది యాజకునికే చెందుతుంది.” ");
INSERT INTO tel2017_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","యెహోవా మళ్ళీ మోషేతో మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ఇశ్రాయేలు ప్రజలతో మాట్లాడి వారికి ఇలా చెప్పు. ఎవరైనా ఒకడి భార్య దారి తప్పి అతడికి ద్రోహం చేసినప్పుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","అంటే వేరే వ్యక్తి ఆమెతో సంబంధం పెట్టుకున్నాడనుకోండి. అప్పుడు ఆమె అపవిత్రం అయినట్టే. ఆ విషయాన్ని ఆమె భర్త చూడకపోయినా, అతనికి తెలియక పోయినా, ఆ కార్యం చేస్తుండగా ఎవరూ పట్టుకోకపోయినా, ఆమెకు వ్యతిరేకంగా సాక్ష్యం చెప్పడానికి ఎవరూ ముందుకు రాకపోయినా ఆమె పట్టుబడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","కానీ ఆ భర్త మనస్సులో రోషం పుట్టి తన భార్య అపవిత్రమైన సంగతి గ్రహిస్తే, లేదా ఆమె అపవిత్రం కాకపోయినా అలాంటిదే అనుమానం అతని మనస్సులో కలిగితే అతడు చేయాల్సింది ఇది.” ");
INSERT INTO tel2017_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","అలాంటి విషయంలో ఆ వ్యక్తి తన భార్యను యాజకుడి దగ్గరికి తీసుకురావాలి. ఆమెతో పాటు తూమెడు యవల పిండిలో పదో వంతు కూడా తీసుకు రావాలి. దానిమీద నూనె పోయకూడదు. సాంబ్రాణి వేయకూడదు. ఎందుకంటే అది రోషాన్ని సూచించే నైవేద్యం. పాపాన్ని సూచించడానికి చేస్తున్న నైవేద్యం. ");
INSERT INTO tel2017_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","యాజకుడు ఆమెను యెహోవా సమక్షానికి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","తరువాత యాజకుడు మట్టికుండలో పవిత్రజలం తీసుకోవాలి. మందిరం నేలపైనుండి కొంత ధూళి తీసుకుని ఆ నీళ్ళలో కలపాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","తరువాత యాజకుడు యెహోవా సమక్షంలో ఆ స్త్రీని నిలబెట్టాలి. ఆ స్త్రీ తలపై ముసుగుని తీసి ఆమె జుట్టు జడలు విప్పాలి. రోషం కారణంగా చేసిన నైవేద్యాన్ని అంటే పాపానికి సూచనగా ఉన్న నైవేద్యాన్ని యాజకుడు ఆమె చేతుల్లో ఉంచాలి. ఇది రోషం కారణంగా చేసిన నైవేద్యం. ఆ సమయంలో శాపాన్ని కలిగించే చేదు నీళ్ళు యాజకుడి చేతిలో ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","అప్పుడు యాజకుడు ఆ స్త్రీతో ఒట్టు పెట్టించి ఇలా చెప్పాలి. “ఏ పురుషుడూ నీతో లైంగికంగా కలవక పొతే, నువ్వు దారి తప్పి అపవిత్ర కార్యం చేయకపోతే శాపాన్ని కలిగించే ఈ చేదు నీళ్ళు నీపై ప్రభావం చూపించవు. ");
INSERT INTO tel2017_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","కానీ భర్త ఆధీనంలో ఉన్న నువ్వు దారి తప్పి ఉంటే, అపవిత్రురాలివైతే, వేరే వ్యక్తి నీతో సంబంధం పెట్టుకుంటే” ");
INSERT INTO tel2017_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ఇక్కడ యాజకుడు ఆమె పైకి శాపం వచ్చేట్లు ఆమెతో ఒట్టు పెట్టించాలి. తరువాత తన మాటలు కొనసాగించాలి. “యెహోవా నీ ప్రజల్లో అందరికీ తెలిసేలా నిన్ను శాపానికి గురిచేస్తాడు గాక. నీ తొడలు బలహీనమై నీ కడుపు ఉబ్బిపోతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","శాపాన్ని కలిగించే ఈ నీళ్ళు నీ కడుపులోకి వెళ్లి నీ పొత్తికడుపు ఉబ్బిపోయేలా చేసి నీ తొడలను బలహీనం చేస్తాయి.” యాజకుడు ఇలా చెప్పిన తరువాత ఆ స్త్రీ “నేను దోషినైతే అలాగే జరగాలి” అని చెప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","యాజకుడు అప్పుడు ఆ శాపాలను ఒక పత్రం పైన రాయాలి. రాసిన ఆ శాపాలను చేదు నీళ్ళతో తుడిచి వేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","తరువాత యాజకుడు శాపాన్ని కలిగించే ఆ చేదు నీళ్ళని ఆమెతో తాగించాలి. శాపాన్ని కలిగించే ఆ నీళ్ళు ఆమెలో చేదును పుట్టిస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","తరువాత యాజకుడు రోషం కారణంగా అర్పించిన నైవేద్యాన్ని ఆమె చేతిలోనుండి తీసుకుని యెహోవా సమక్షంలో పైకి ఎత్తి, ఊపి దాన్ని బలిపీఠం దగ్గరకి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","తరువాత యాజకుడు ఆ నైవేద్యంలో నుండి ఓ గుప్పెడు తీసి బలిపీఠం పైన దాన్ని దహించాలి. ఆ తరువాత ఆ నీళ్ళను ఆమెకు తాగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","యాజకుడు ఆమెకు ఆ నీళ్లు త్రాగించినప్పుడు ఒకవేళ ఆమె అపవిత్రురాలై తన భర్తకి ద్రోహం చేసి ఉంటే శాపం కలుగజేసే ఆ నీళ్ళు ఆమె కడుపులోకి వెళ్ళి చేదు అవుతాయి. ఆమె పొత్తి కడుపు వాచి ఉబ్బుతుంది. ఆమె తొడలు బలహీనం అవుతాయి. ఆమె తన ప్రజల్లో శాపగ్రస్తురాలవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ఒకవేళ ఆ స్త్రీ అపవిత్రం కాకుండా పవిత్రంగా ఉంటే విడుదల పొందుతుంది. ఆమె సంతానం పొందడానికి యోగ్యురాలవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","అనుమానం గురించిన చట్టం ఇది. భర్త ఆధీనంలో ఉన్న ఏ స్త్రీ అయినా దారి తప్పి అపవిత్రురాలైనప్పుడు పాటించాల్సిన చట్టం ఇది. ");
INSERT INTO tel2017_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ఒకవేళ భర్తకు తన భార్యపై అనుమానం కలిగినా ఇదే చట్టం పాటించాలి. అతడు ఆమెను యెహోవా సమక్షంలోకి తీసుకు రావాలి. ఈ అనుమానం గురించిన చట్టం వివరించిన వాటన్నిటినీ యాజకుడు ఆమె విషయంలో జరిగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","అప్పుడు ఆ వ్యక్తి తన భార్యను యాజకుడి దగ్గరకి తీసుకు వచ్చిన నేరం నుండి విముక్తుడవుతాడు. ఆ స్త్రీ ఏదన్నా అపరాధం చేస్తే ఆ శిక్ష భరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","తరువాత యెహోవా మోషేతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ఇశ్రాయేలు ప్రజలతో మాట్లాడి ఇలా చెప్పు. ఎవరన్నా స్త్రీ గానీ పురుషుడు గానీ తనను యెహోవా కోసం ప్రత్యేకపరచుకుని నాజీరు కావడానికి మొక్కుకుంటే ఆ వ్యక్తి ద్రాక్షారసాన్ని గానీ మత్తు కలిగించే పానీయాలు గానీ తీసుకోకూడదు. పులిసిన ద్రాక్షారసం గానీ మద్యాన్ని గానీ తీసుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ఎలాంటి ద్రాక్షారసాన్నీ తాగకూడదు. ద్రాక్షాపళ్ళు పండినవైనా, ఎండినవైనా తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","నా కోసం అతడు ప్రత్యేకంగా ఉన్న రోజుల్లో ద్రాక్ష తీగల నుండి తీసిన దేనినీ తినకూడదు. అవి పచ్చి కాయలైనా, పైన ఉండే తోలు అయినా తినకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","అతడు ప్రత్యేకంగా ఉండాలని మొక్కుకున్న రోజుల్లో మంగలి కత్తి అతడి తలని తాకకూడదు. యెహోవాకు ప్రత్యేకంగా ఉండాలని మొక్కుకున్న రోజులు పూర్తయే వరకూ జుట్టు పెరగనియ్యాలి. దేవుని కోసం అతడు ప్రత్యేకంగా ఉండాలి. తలపై జుట్టు పొడుగ్గా పెరగనియ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","అతడు తనను యెహోవాకు ప్రత్యేకించుకున్న రోజుల్లో మృతదేహాన్ని సమీపించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","తన తండ్రి, తల్లి, సోదరుడు, సోదరి, వీరిలో ఎవరు మరణించినా అతడు వారిని తాకి తనను అపవిత్రం చేసుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","అతడు ప్రత్యేకంగా ఉన్న రోజుల్లో పవిత్రంగా ఉంటాడు. యెహోవా కోసం ప్రత్యేకంగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ఎవరైనా అతని పక్కనే అకస్మాత్తుగా పడి చనిపోతే, దానివల్ల ప్రత్యేకంగా ఉండే వ్యక్తి అపవిత్రుడైతే అతడు తాను పవిత్రం అయ్యాక అంటే ఏడు రోజుల తరువాత తన తల జుట్టుని కత్తిరించుకోవాలి. అంటే ఏడో రోజున కత్తిరించుకోవాలన్నమాట. ");
INSERT INTO tel2017_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ఎనిమిదో రోజున అతడు రెండు గువ్వలను గానీ లేదా రెండు పావురం పిల్లలను గానీ పట్టుకుని వాటిని సన్నిధి గుడారం ద్వారం దగ్గర ఉన్న యాజకుడి దగ్గరికి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","అప్పుడు యాజకుడు ఒకదాన్ని పాపం కోసం చేసే బలిగా. రెండో దాన్ని దహనబలిగా అర్పించాలి. ఆ వ్యక్తి మృతదేహాన్ని తాకి పాపం చేసాడు కాబట్టి ఇవి అతని కోసం పరిహారం అవుతాయి. ఆ రోజునే అతడు తనను తను పవిత్రం చేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","తరువాత అతడు తిరిగి నాజీరుగా ఉండే కాలాన్ని ప్రతిష్టించాలి. అతడు అపరాధ బలిగా ఒక ఏడాది వయసున్న మగ గొర్రె పిల్లని తీసుకురావాలి. అతడు అపవిత్రుడు కాకముందు మొక్కుకున్న రోజులు లెక్కలోకి రాకూడదు. ఎందుకంటే అతడు యెహోవా కోసం ప్రత్యేకంగా ఉండి అపవిత్రం అయ్యాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","నాజీరుగా ఉండటానికి మొక్కుకుని ఆ నాజీరుగా ఉండే సమయం ముగిసిన తరువాత అతడు చేయాల్సిన దాని గురించిన చట్టం ఇది. అతణ్ణి సన్నిధి గుడారం ద్వారం దగ్గరకి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","అతడు తన అర్పణ యెహోవాకు అర్పించాలి. ఒక ఏడాది వయసున్న లోపరహితమైన ఒక మగ గొర్రెపిల్లని దహనబలిగా అర్పించాలి. అలాగే ఒక ఏడాది వయసున్న లోపరహితమైన ఆడ గొర్రెపిల్లను పాపం కోసం చేసే అర్పణగా తీసుకురావాలి. అతడింకా లోపరహితమైన ఒక పొట్టేలును శాంతి బలిగా తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","అలాగే అతడు తన నైవేద్య అర్పణ, పానార్పణలతో పాటు పొంగజేసే పదార్ధం లేకుండా చేసిన గంపెడు రొట్టెలూ, సన్నని గోదుమ పిండితో నూనె రాసి చేసిన వంటకాలూ, పొంగజేసే పదార్ధం లేకుండా నూనె రాసి చేసిన అప్పడాలూ యెహోవా దగ్గరకి తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","అప్పుడు యాజకుడు యెహోవా సమక్షంలోకి వాటిని తెచ్చి అతడి కోసం దహనబలినీ, పాపం కోసం చేసే బలినీ అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","పొంగజేసే పదార్ధం లేకుండా చేసిన రొట్టెల గంపతో పాటు ఆ పొట్టేలును యెహోవాకు శాంతి బలిగా అర్పించాలి. అతని నైవేద్యాన్ని పానార్పణతో కలిపి అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","అప్పుడా నాజీరు సన్నిధి గుడారం ద్వారం దగ్గర తన ప్రత్యేకతను సూచించే తల జుట్టు కత్తిరించుకోవాలి. ఆ జుట్టును శాంతిబలి అర్పణ సామగ్రి కింద ఉన్న మంటలో పడవేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","అప్పుడు యాజకుడు ఉడికిన పొట్టేలు జబ్బనీ గంపలోనుండి పొంగని పదార్ధంతో చేసిన ఒక రొట్టెనూ పొంగని పదార్ధంతో చేసిన ఒక అప్పడాన్నీ తీసుకోవాలి. యాజకుడు వాటిని ప్రత్యేకతను సూచించే తన తల వెండ్రుకలు కత్తిరించుకున్న నాజీరు చేతుల్లో ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","తరువాత యాజకుడు యెహోవా సమక్షంలో పైకెత్తి కదిల్చే అర్పణ గా వాటిని కదిలించాలి. వాటిని యెహోవాకు అర్పించాలి. అది పవిత్ర ఆహారం. పైకెత్తి కదిలించిన రొమ్ము భాగం, తొడ భాగంతో కలిపి ఇది యాజకునికి చెందుతుంది. దాని తరువాత ఆ నాజీరు ద్రాక్షారసం తాగవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","మొక్కుకున్న నాజీరును గురించిన ఉపదేశం ఇది. తనను యెహోవా కోసం ప్రత్యేకించుకోడానికి అతడు అర్పించాల్సిన వాటిని గురించిన ఉపదేశం ఇది. తాను నాజీరు కావడానికి మొక్కుకున్న దంతా అతడు నెరవేర్చాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","యెహోవా మళ్ళీ మోషేతో మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“అహరోనుకూ అతని కొడుకులకూ ఇలా చెప్పు. మీరు ఇశ్రాయేలు ప్రజలను ఈ విధంగా దీవించాలి. మీరు వారితో ఇలా చెప్పాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","యెహోవా మిమ్మల్ని దీవించి సంరక్షిస్తాడు గాక! ");
INSERT INTO tel2017_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","యెహోవా మీపై తన వెలుగు ప్రకాశింప చేస్తాడు గాక! మిమ్మల్ని కరుణిస్తాడు గాక! ");
INSERT INTO tel2017_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","యెహోవా మిమ్మల్ని కన్నులారా చూసి మీకు శాంతి ప్రసాదించు గాక! ");
INSERT INTO tel2017_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ఈ విధంగా వారు ఇశ్రాయేలు ప్రజలకి నా నామాన్ని ఉచ్చరిస్తూ ఉండాలి. నేను అప్పుడు వారిని దీవిస్తాను.” ");
INSERT INTO tel2017_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","మోషే దేవుని మందిర నిర్మాణం ముగించిన రోజునే దాన్ని దానిలోని అలంకరణలతో సహా యెహోవా సేవ కోసం అభిషేకించి పవిత్ర పరిచాడు. బలిపీఠాన్ని, అక్కడ పాత్రలను అభిషేకించి పవిత్ర పరిచాడు. వాటన్నిటినీ అభిషేకించి పవిత్ర పరిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ఆ రోజునే ఇశ్రాయేలు ప్రజల నాయకులు, తమ పూర్వీకుల కుటుంబాల పెద్దలు బలులు అర్పించారు. వీరు తమ తమ గోత్రాల ప్రజలను నడిపిస్తున్నవారు. జనాభా లెక్కలను పర్యవేక్షించింది వీరే. ");
INSERT INTO tel2017_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","వీరు తమ అర్పణలను యెహోవా సమక్షంలోకి తీసుకు వచ్చారు. వీరు ఆరు గూడు బళ్ళూ, పన్నెండు ఎద్దులను తీసుకు వచ్చారు. ఇద్దరు నాయకులకు ఒక బండినీ, ఒక్కొక్కరికీ ఒక ఎద్దునీ తీసుకు వచ్చారు. వీటిని మందిరం ఎదుటికి వారు తీసుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","అప్పుడు యెహోవా మోషేతో మాట్లాడాడు. ఆయన ఇలా అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“వారి దగ్గర నుండి ఈ కానుకలు స్వీకరించు. వాటిని సన్నిధి గుడారంలో సేవకై ఉపయోగించు. ఈ కానుకలను లేవీ వారికప్పగించు. వారిలో ప్రతి వాడి సేవకు తగినట్టుగా వాటిని వాళ్లకివ్వు.” ");
INSERT INTO tel2017_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","మోషే ఆ బళ్లనూ ఎద్దులను తీసుకుని వాటిని లేవీ వారికి ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","వాటిలో గెర్షోను వంశం వారికి వారు చేసే సేవ ప్రకారం రెండు బళ్లనూ నాలుగు ఎద్దులను ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","యాజకుడు అహరోను కొడుకు ఈతామారు పర్యవేక్షణ లో పనిచేసే మెరారి వంశస్తులకి వారు చేసే సేవను బట్టి నాలుగు బళ్లనూ ఎనిమిది ఎద్దులనూ ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","అయితే కహాతు వాళ్లకి ఏమీ ఇవ్వలేదు. ఎందుకంటే వారి సేవ అంతా మందిరంలోని సామగ్రికీ వస్తువులకీ సంబంధించింది. వాటిని వారు తమ భుజాలపై మోసుకు వెళ్ళాలి. కాబట్టి వారికి బళ్ళు ఇవ్వలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","మోషే బలిపీఠాన్ని అభిషేకించిన రోజున ఆ నాయకులు బలిపీఠాన్ని ప్రతిష్టించడానికి సామగ్రిని తీసుకు వచ్చారు. బలిపీఠం ఎదుట తాము తెచ్చిన అర్పణలను సమర్పించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","యెహోవా మోషేకి “బలిపీఠం అభిషేకం కోసం అర్పణలు తీసుకు రావడానికి ప్రతి నాయకుడికీ ఒక్కో రోజు కేటాయించు” అని ఆదేశించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","మొదటి రోజు అర్పణం తెచ్చింది యూదా గోత్రం వాడూ, అమ్మీనాదాబు కొడుకు నయస్సోను. ");
INSERT INTO tel2017_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ, 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండా నూనెతో కలిపిన మెత్తని పిండిని నైవేద్య అర్పణగా ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","వీటితో పాటు పది తులాల బరువున్న పాత్రను సాంబ్రాణితో నింపి అర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ఇంకా అతడు దహనబలిగా ఒక చిన్న కోడెనూ ఒక పొట్టేలునూ ఒక ఏడాది వయసున్న గొర్రె పిల్లనూ ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","పాపం కోసం బలిగా ఒక మేక పోతును ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","రెండు ఎద్దులను, ఐదు పొట్టేళ్లనూ ఐదు మేకపోతులను, ఒక ఏడాది వయసున్న ఐదు గొర్రె పిల్లలను శాంతిబలిగా సమర్పించాడు. ఇవి అమ్మీనాదాబు కొడుకు నయస్సోను తెచ్చిన అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","రెండో రోజు అర్పణం తెచ్చింది ఇశ్శాఖారు వంశంలో నాయకుడూ, సూయారు కొడుకూ అయిన నెతనేలు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండా నూనెతో కలిపిన సన్నని పిండిని నైవేద్య అర్పణగా ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","అతడింకా సాంబ్రాణి తో నిండి ఉన్న పది తులాల బంగారు పాత్రను ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","దహన బలిగా ఒక చిన్న కోడెనూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న గొర్రె పిల్లనూ ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","పాపం కోసం చేసే బలిగా ఒక మేకపోతును ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","అలాగే అతడు శాంతిబలిగా రెండు ఎద్దులను, ఐదు పోట్టేళ్ళనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు గొర్రె పిల్లలను తీసుకు వచ్చాడు. ఇది సూయారు కొడుకు నెతనేలు తెచ్చిన అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","మూడో రోజు జెబూలూను వంశస్తులకు నాయకుడూ హేలోను కొడుకూ అయిన ఏలీయాబు తన అర్పణ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ఇంకా సాంబ్రాణి తో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ఇంకా దహనబలిగా ఒక కోడెనూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న ఒక మగ గొర్రెపిల్లనూ ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","పాపం కోసం చేసే బలిగా ఒక మేకపోతును ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","శాంతి బలిగా రెండు ఎద్దులను, ఐదు పోట్టేళ్ళనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను తీసుకు వచ్చాడు. ఇది హేలోను కొడుకు ఏలీయాబు తెచ్చిన అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","నాలుగో రోజు రూబేను వంశస్తుల నాయకుడూ, షెదేయూరు కొడుకూ అయిన ఏలీసూరు తన అర్పణ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండా నూనెతో కలిపిన మెత్తని పిండిని నైవేద్య అర్పణగా ఉంచాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ఇంకా సాంబ్రాణితో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","అతడు దహనబలిగా ఒక ఎద్దునూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న ఒక మగ గొర్రెపిల్లనూ తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","పాపం కోసం చేసే బలిగా ఒక మేకపోతును తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్ళనూ ఐదు మేకపోతులను, ఐదు మగ గొర్రెపిల్లలను శాంతిబలి అర్పణగా తీసుకువచ్చాడు. ఇది షెదేయూరు కొడుకు ఏలీసూరు అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ఐదో రోజు షిమ్యోను వంశస్తుల నాయకుడూ, సూరీషదాయి కొడుకూ అయిన షెలుమీయేలు తన అర్పణం తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెను, 70 తులాల బరువున్న వెండి పాత్రను, సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ఇంకా సాంబ్రాణితో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ఇతడు దహనబలిగా ఒక కోడెనూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న ఒక గొర్రె పిల్లనూ తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ఒక మేకపోతును పాపం కోసం చేసే బలిగా ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్లనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను శాంతిబలిగా ఇచ్చాడు. ఇది సూరీషదాయి కొడుకు షెలుమీయేలు అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ఆరో రోజు గాదు వంశస్తులకు నాయకుడూ, దెయూవేలు కొడుకు ఎలీయాసాపా తన అర్పణ తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ఇంకా సాంబ్రాణితో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","అతడు దహనబలిగా ఒక చిన్న కోడెను, ఒక పొట్టేలును, ఒక సంవత్సరం వయసున్న ఒక గొర్రెపిల్లను తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","పాపం కోసం చేసే బలిగా ఒక మేకపోతును తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్లనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను శాంతిబలిగా ఇచ్చాడు. ఇది దెయూవేలు కొడుకు ఎలీయాసాపా అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ఏడో రోజు ఎఫ్రాయిము వంశస్తులకు నాయకుడూ, అమీహూదు కొడుకూ అయిన ఎలీషామా తన అర్పణ తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ఇంకా సాంబ్రాణి తో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","అతడు దహనబలిగా ఒక చిన్న కోడెను, ఒక పొట్టేలును, ఒక సంవత్సరం వయసున్న ఒక గొర్రెపిల్లను తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","పాపం కోసం చేసే బలిగా ఒక మేకపోతును తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్లనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను శాంతిబలిగా ఇచ్చాడు. ఇది అమీహూదు కొడుకు ఎలీషామా అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ఎనిమిదో రోజు మనష్శే వంశస్తుల నాయకుడూ, పెదాసూరు కొడుకూ అయిన గమలీయేలు తన అర్పణ తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ఇంకా సాంబ్రాణి తో నిండి ఉన్న పది తులాల బంగారు పాత్ర ఒకదాన్ని తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","అతడు దహనబలిగా ఒక చిన్న కోడెనూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న ఒక గొర్రెపిల్లనూ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","పాపం కోసం చేసే బలిగా ఒక మేకపోతును తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్లనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను శాంతిబలిగా ఇచ్చాడు. ఇది పెదాసూరు కొడుకు గమలీయేలు అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","తొమ్మిదో రోజు బెన్యామీను వంశస్తులకి నాయకుడూ, గిద్యోనీ కొడుకూ అయిన అబీదాను తన అర్పణ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ఇంకా సాంబ్రాణి తో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","అతడు దహనబలిగా ఒక చిన్న కోడెనూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న ఒక గొర్రెపిల్లనూ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","పాపం కోసం చేసే బలిగా ఒక మేకపోతును తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్లనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను శాంతిబలిగా ఇచ్చాడు. ఇది గిద్యోనీ కొడుకు అబీదాను అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","పదో రోజు దాను వంశస్తులకి నాయకుడూ, అమీషదాయి కొడుకూ అయిన అహీయెజెరు తన అర్పణ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ఇంకా సాంబ్రాణి తో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","అతడు దహనబలిగా ఒక చిన్న కోడెనూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న ఒక గొర్రెపిల్లనూ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","పాపం కోసం చేసే బలిగా ఒక మేకపోతును తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్లను, ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను శాంతిబలిగా ఇచ్చాడు. ఇది అమీషదాయి కొడుకు అహీయెజెరు అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","పదకొండో రోజు ఆషేరు వంశస్తుల నాయకుడూ, ఒక్రాను కొడుకూ అయిన పగీయేలు తన అర్పణ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ఇంకా సాంబ్రాణి తో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","అతడు దహనబలిగా ఒక చిన్న కోడెనూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న ఒక గొర్రెపిల్లనూ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","పాపం కోసం చేసే బలిగా ఒక మేకపోతును తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్లనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను శాంతిబలిగా ఇచ్చాడు. ఇది ఒక్రాను కొడుకు పగీయేలు అర్పణం. ");
INSERT INTO tel2017_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","పన్నెండో రోజు నఫ్తాలీ వంశస్తులకి నాయకుడూ, ఏనాను కొడుకూ అయిన అహీరా. ");
INSERT INTO tel2017_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","అతడు పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం 130 తులాల బరువున్న వెండి గిన్నెనూ 70 తులాల బరువున్న వెండి పళ్ళేన్నీ సమర్పించాడు. ఈ రెంటి నిండుగా నైవేద్య అర్పణ కోసం నూనె కలిపిన మెత్తని గోదుమ పిండిని తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ఇంకా సాంబ్రాణి తో నిండి ఉన్న పది తులాల బంగారు పాత్రను తీసుకువచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","అతడు దహనబలిగా ఒక చిన్న కోడెనూ ఒక పొట్టేలునూ ఒక సంవత్సరం వయసున్న ఒక గొర్రెపిల్లనూ తీసుకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","పాపం కోసం చేసే బలిగా ఒక మేకపోతును తెచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ఇంకా రెండు ఎద్దులను, ఐదు పొట్టేళ్లనూ ఐదు మేకపోతులను, ఒక సంవత్సరం వయసున్న ఐదు మగ గొర్రె పిల్లలను శాంతిబలిగా ఇచ్చాడు. ఇది ఏనాను కొడుకు అహీరా అర్పణం. బలిపీఠాన్ని అభిషేకించిన రోజున ఇశ్రాయేలీయుల ప్రధానులు అర్పించిన ప్రతిష్ఠార్పణలు ఇవి. వెండి గిన్నెలు పన్నెండు, వెండి ప్రోక్షణపాత్రలు పన్నెండు, బంగారు ధూపార్తులు పన్నెండు, ప్రతి వెండి గిన్నె నూట ముప్ఫై తులాల బరువు ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","మోషే బలిపీఠాన్ని అభిషేకించిన రోజున ఇశ్రాయేలు నాయకులు వీటన్నిటినీ ప్రతిష్టించారు. వారు పన్నెండు వెండి గిన్నెలను, పన్నెండు వెండి పాత్రలను, పన్నెండు బంగారు పాత్రలను ప్రతిష్టించారు. ప్రతి ప్రోక్షణపాత్ర డెబ్భై తులాల బరువున్నది. ఆ ఉపకరణాల వెండి అంతా పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం రెండు వేల నాలుగువందల తులాల బరువు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ప్రతి వెండి గిన్నే 130 తులాలు, ప్రతి పాత్రా 70 తులాల బరువైనవి. పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం మొత్తం వెండి పాత్రలన్నీ 2, 400 తులాల బరువు ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","సాంబ్రాణితో నిండిన బంగారు పాత్రలు పన్నెండు ఉన్నాయి. పరిశుద్ధ స్థలంలో చెలామణీ అయ్యే తులం బరువు ప్రకారం ఒక్కొక్కటి పది తులాల బరువుంది. మొత్తం బంగారం 120 తులాలుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","దహనబలి కింద వారు పన్నెండు ఎద్దులను, పన్నెండు పొట్టేళ్లనూ ఒక సంవత్సరం వయసున్న పన్నెండు మగ గొర్రెలను ప్రతిష్టించారు. తమ నైవేద్య అర్పణ అర్పించారు. పాపం కోసం బలిగా పన్నెండు మేకపోతులను అర్పించారు. పశువులన్నీ పన్నెండు కోడెలు, పొట్టేళ్లు పన్నెండు, ఏడాది గొర్రెపిల్లలు పన్నెండు, వాటి నైవేద్యాలు పాపపరిహారం కోసం మగ మేక పిల్లలు పన్నెండు, సమాధానబలి పశువులు ఇరవై నాలుగు కోడెలు, ");
INSERT INTO tel2017_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","వారి పశువులన్నిటిలో నుండి 24 ఎద్దులను, 60 పొట్టేళ్లనూ 60 మేకపోతులను, ఒక సంవత్సరం వయసున్న 60 మగ గొర్రె పిల్లలను శాంతిబలిగా అర్పించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","యెహోవాతో మాట్లాడడానికి మోషే సన్నిధి గుడారంలోకి వెళ్ళినప్పుడు అతడు దేవుని స్వరం తనతో మాట్లాడడం విన్నాడు. నిబంధన మందసం శాసనాల పెట్టె పైన ఉన్న పరిహార స్థానం నుండి ఇద్దరు కెరూబుల మధ్యలోనుండి దేవుడు అతనితో మాట్లాడాడు. యెహోవా అతనితో మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","తరువాత యెహోవా మోషేతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“నువ్వు అహరోనుతో మాట్లాడి ఇలా చెప్పు. దీపాలను వెలిగించినప్పుడు ఆ ఏడు దీపాల వెలుగు ఏడు దీపాల స్తంభానికి ఎదురుగా పడేలా చూడు.” ");
INSERT INTO tel2017_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","అహరోను అలాగే చేశాడు. మోషేకి యెహోవా ఆజ్ఞాపించినట్టే దీపాల కాంతి ఆ ఏడు దీపాల స్తంభానికి ఎదురుగా పడేలా వాటిని వెలిగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","దాని అడుగు నుండి పైన పువ్వుల వరకూ ఆ దీప స్తంభాన్ని సాగగొట్టిన బంగారంతో చేశారు. దాన్ని ఎలా చేయాలో యెహోవా మోషేకి చూపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","యెహోవా మళ్ళీ మోషేతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ఇశ్రాయేలు ప్రజల్లోనుండి లేవీ వారిని వేరు చెయ్యి. తరువాత వారిని పవిత్రం చెయ్యి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","వారిని పవిత్రం చేయడానికి ఇలా చెయ్యి. పరిహారం కోసం వారిపై పవిత్రజలాన్ని చిలకరించు. వారిల్లో ప్రతి ఒక్కడూ మంగలి కత్తితో తన శరీరం పై ఉన్న జుట్టు అంతటినీ నున్నగా కత్తిరించుకుని, తన బట్టలు ఉతుక్కుని, తనను పవిత్రం చేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","తరువాత వారు ఒక కోడెదూడను, దాని నైవేద్య అర్పణగా నూనె కలిపిన సన్నని గోదుమ పిండినీ తీసుకు రావాలి. పాపాల కోసం చేసే బలిగా మరో కోడెని తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","తరువాత నువ్వు వారిని సన్నిధి గుడారం ఎదుటకి తీసుకు రావాలి. ఇశ్రాయేలు సమాజాన్నంతా సమావేశ పరచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","లేవీ వారిని యెహోవా నైన నా ఎదుట నిలబెట్టు. అప్పుడు ఇశ్రాయేలు ప్రజలు లేవీ వారిపైన తమ చేతులుంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","లేవీ వారిని అహరోను నా ఎదుట సమర్పించాలి. ఇశ్రాయేలు ప్రజల తరపున వారిని కదలిక అర్పణగా నా ఎదుట కదిలించాలి. లేవీ వారు నాకు సేవ చేయడానికి అతడు ఈ విధంగా చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","లేవీ వారు ఆ కోడెదూడల తలలపై తమ చేతులుంచాలి. లేవీ వారి కోసం పరిహారం చేయడానికి పాపం కోసం అర్పణగా ఒక ఎద్దునూ దహనబలిగా మరొక ఎద్దునూ నువ్వు నాకు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","వారిని అహరోను ఎదుటా, అతని కొడుకుల ఎదుటా హాజరు పరచి నాకు కదలిక అర్పణగా నా ఎదుట నిలబెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ఈ విధంగా నువ్వు ఇశ్రాయేలు ప్రజల నుండి లేవీ వారిని వేరు చేయాలి. లేవీ వంశం వారు నాకు చెందిన వారుగా ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ఇదంతా అయ్యాక లేవీ వారు సేవ చేయడానికి సన్నిధి గుడారంలోకి వెళ్ళాలి. నువ్వు వారిని పవిత్ర పరచాలి. వారిని నాకు కదలిక అర్పణ గా నా ఎదుట వారిని ఎత్తి పట్టుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ఇలా తప్పకుండా చెయ్యి. ఎందుకంటే ఇశ్రాయేలు ప్రజల్లోనుండి వీరు సంపూర్ణంగా నా వారు. ఇశ్రాయేలు సంతానంలో గర్భం నుండి బయటకు వచ్చే ప్రతి మొదటి మగ పసికందు స్థానాన్ని వీరు తీసుకుంటారు. లేవీ వారిని నేను తీసుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ఎందుకంటే ఇశ్రాయేలు ప్రజల్లో ప్రతి మొదటి సంతానం నాదే. ఇది మనుషులకీ, పశువులకీ వర్తిస్తుంది. ఈజిప్టులో మొదటి సంతానాన్ని నేను సంహరించినప్పుడు వీరిని నాకోసం ప్రత్యేకించుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","మొదటి సంతానానికి బదులుగా నేను ఇశ్రాయేలు ప్రజల్లో నుండి లేవీ వారిని తీసుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","వారిని అహరోనుకీ అతని కొడుకులకీ ఒక బహుమానంగా ఇచ్చాను. సన్నిధి గుడారంలో ఇశ్రాయేలు ప్రజల కోసం పనిచేయడానికి వారిని ఇశ్రాయేలు ప్రజల్లో నుండి తీసుకున్నాను. ఇశ్రాయేలు ప్రజలు పరిశుద్ధ స్థలాన్ని సమీపించినప్పుడు వాళ్లకి ఎలాంటి తెగులు హాని చేయకుండా వారి కోసం పరిహారం చేయడానికి నేను వీరిని నియమించాను.” ");
INSERT INTO tel2017_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","అప్పుడు మోషే, అహరోనూ, ఇశ్రాయేలు సమాజమంతా అలాగే చేశారు. లేవీ వారి విషయంలో యెహోవా మోషేకి ఆదేశించింది అంతా అమలు చేశారు. ఇశ్రాయేలు ప్రజలు లేవీ వాళ్లకి ఇదంతా చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","లేవీ వారు తమ బట్టలు ఉతుక్కుని పవిత్రం అయ్యారు. వారిని పవిత్రం చేయడానికి అహరోను వారిని యెహోవా ఎదుట సమర్పించి వారి కోసం పరిహారం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","తరువాత లేవీ వారు అహరోను ఎదుటా, అతని కొడుకుల ఎదుటా సన్నిధి గుడారంలో తమ సేవ చేయడానికి వెళ్ళారు. లేవీ వారిని గురించి యెహోవా మోషేకి ఆదేశించిన దాని ప్రకారం ఇది జరిగింది. లేవీ వాళ్లకందరికీ ఇలాగే జరిగించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","యెహోవా తిరిగి మోషేతో మాట్లాడాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ఇరవై ఐదు సంవత్సరాలు, అంతకంటే ఎక్కువ వయసున్న లేవీ వాళ్లందరికీ ఇలాగే చేయాలి. వారు సన్నిధి గుడారంలో సేవ చేయడం కోసం చేరాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","అయితే వాళ్లకి యాభై ఏళ్ళు వచ్చాక ఈ విధంగా చేసే సేవ నుండి విరమించాలి. వారు అక్కడితో ఆగిపోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","సన్నిధి గుడారంలో పని చేసే తమ సోదరులకు వారు సహాయం చేయవచ్చు గానీ సేవ నుండి మానుకోవాలి. ఈ విషయాలన్నిటిలో నువ్వు వాళ్లకి మార్గ దర్శనం చేయాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","యెహోవా సీనాయి అరణ్యంలో మోషేతో మాట్లాడాడు. ఇది వారు ఐగుప్తు దేశం నుండి బయటకు వచ్చిన రెండో సంవత్సరం మొదటి నెలలో జరిగింది. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ప్రతి సంవత్సరం ఇశ్రాయేలు ప్రజలు పస్కా పండగను దానికి నిర్ధారించిన తేదీల్లో ఆచరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","దాన్ని నిర్ధారించిన కాలం ఈ నెల పద్నాలుగో రోజు. ఆ రోజు సాయంత్రం మీరు పస్కా జరుపుకోవాలి. దాన్ని ఆచరించాలి. దానికి సంబంధించిన నియమాలను, ఆదేశాలను తప్పక పాటించాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","కాబట్టి మోషే పస్కా పండగను ఆచరించాలని ఇశ్రాయేలు ప్రజలకి చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","దాంతో సీనాయి అరణ్యంలో ఆ మొదటి నెలలో పద్నాలుగో రోజు సాయంత్రం వారు పస్కా ఆచరించారు. యెహోవా మోషేకి ఆజ్ఞాపించిన వాటికి ఇశ్రాయేలు ప్రజలు విధేయులయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","కొంతమంది చనిపోయిన వ్యక్తి శరీరాన్ని తాకి అపవిత్రులయ్యారు. కాబట్టి ఆ రోజు వారు పస్కా ఆచరించలేక పోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ఆ వ్యక్తులు మోషే దగ్గరకి వచ్చి “మేము చనిపోయిన వ్యక్తి కారణంగానే కదా అపవిత్రులమయ్యాం. ఈ సంవత్సరంలో నిర్ధారించిన రోజున యెహోవాకు బలి అర్పించకుండా మమ్మల్ని ఎందుకు దూరం చేస్తున్నారు?” అని అడిగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","దానికి మోషే “కాస్త ఆగండి. మీ గురించి యెహోవా ఏం చెబుతాడో విందాం.” అని జవాబిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","అప్పుడు యెహోవా మోషేతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“నువ్వు ఇశ్రాయేలు ప్రజలకి ఇలా చెప్పు. ‘మీలో ఎవరైనా లేదా మీ సంతానంలో ఎవరైనా శవాన్ని తాకి అపవిత్రుడైనా, లేదా దూర ప్రయాణంలో ఉన్నా ఆ వ్యక్తి పస్కాను ఆచరించ వచ్చు.’ ");
INSERT INTO tel2017_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","వారు రెండో నెల పద్నాలుగో రోజున సాయంత్రం పస్కా ఆచరించాలి. పొంగజేసే పదార్ధం లేకుండా చేసిన రొట్టెలు, చేదు ఆకు కూరలతో తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","మర్నాటి ఉదయానికి దానిలో దేన్నీ మిగల్చకూడదు. దాని ఎముకల్లో దేన్నీ విరగ్గొట్టకూడదు. పస్కాకి సంబంధించిన నియమాలన్నిటినీ వారు పాటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","అయితే పవిత్రంగా ఉండీ, ప్రయాణమేదీ చేయని వాడు ఒకవేళ పస్కాను ఆచరించకపోతే ఆ వ్యక్తిని సమాజంలో లేకుండా చేయాలి. ఎందుకంటే ఆ వ్యక్తి సంవత్సరంలో నిర్ధారించిన రోజున యెహోవాకు అవసరమైన బలి అర్పణ అర్పించలేదు. ఆ వ్యక్తి తన పాపాన్ని భరించాల్సిందే. ");
INSERT INTO tel2017_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","మీ మధ్య నివసించే విదేశీయుడు ఎవరైనా యెహోవా గౌరవం కోసం పస్కాని ఆచరించాలనుకుంటే అతడు ఆయన ఆదేశాలను అనుసరించాలి. నియమాలను అనుసరించే పస్కా ఆచరించాలి. పస్కా అనుసరించే విషయంలో మీ దేశంలో పుట్టిన వాడికీ మీ మధ్య నివసించే విదేశీయుడికీ ఒకే విధానం ఉండాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","మందిరాన్ని నిలబెట్టిన రోజున మేఘం నిబంధన శాసనాల గుడారాన్ని కమ్ముకుంది. సాయంత్రానికి మేఘం మందిరం పైగా కనిపించింది. అది మర్నాటి ఉదయం వరకూ అగ్నిలా కనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","అది ఎల్లప్పుడూ అలాగే కనిపించింది. మేఘం మందిరాన్ని కమ్మి రాత్రిలో అగ్నిలా కనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","గుడారం పైనుండి ఆ మేఘం పైకి వెళ్ళిపోయినప్పుడు ఇశ్రాయేలు ప్రజలు ప్రయాణం సాగించేవారు. ఆ మేఘం ఆగినప్పుడు ఇశ్రాయేలు ప్రజలు నిలిచి గుడారాలు వేసుకునేవారు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","యెహోవా ఆదేశాల ప్రకారం ఇశ్రాయేలు ప్రజలు ప్రయాణం సాగించారు. ఆయన ఆదేశాల ప్రకారం గుడారాలు వేసుకుని నిలిచి పోయారు. మందిరం పైన మేఘం నిలిచినప్పుడు తమ శిబిరంలో ఉండే వారు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ఆ మేఘం ఒకవేళ ఎక్కువ రోజులు మందిరం పైన ఉండిపోతే యెహోవా ఆదేశాలను బట్టి ఇశ్రాయేలు ప్రజలు ప్రయాణం చేసేవారు కాదు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","కొన్నిసార్లు మేఘం కొన్ని రోజులు మాత్రమే మందిరం పైన నిలిచి ఉంటే వారు కూడా నిలిచిపోయే వారు. యెహోవా ఆదేశాల మేరకు గుడారాలు వేసుకుని తిరిగి ఆయన ఆదేశాల ప్రకారం ప్రయాణమయ్యే వారు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","కొన్నిసార్లు మేఘం సాయంత్రం నుండి మర్నాటి ఉదయం వరకూ ఉండేది. అప్పుడు ఉదయం మేఘం వెళ్ళగానే ప్రయాణం మొదలు పెట్టేవారు. ఒకవేళ మేఘం ఒక పగలూ ఒక రాత్రీ ఉంటే ఆ మేఘం వెళ్ళిన తరువాత మాత్రమే ప్రయాణం చేసేవారు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ఆ మేఘం రెండు రోజులు గానీ, ఒక నెల గానీ, లేదా ఒక సంవత్సరం గానీ మందిరం పైన నిలిచి పొతే ఇశ్రాయేలు ప్రజలు ప్రయాణం చేయకుండా తమ గుడారాల్లో ఉండి పోయారు. ఆ మేఘం వెళ్లి పోయిన తరువాత మాత్రమే ప్రయాణం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","యెహోవా ఆదేశాలకు విధేయులై వారు తమ గుడారాలు వేసుకున్నారు. యెహోవా ఆదేశాలకు విధేయులై ప్రయాణం చేశారు. యెహోవా మోషే ద్వారా తమకిచ్చిన ఆదేశాలకు వారు విధేయులయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","యెహోవా మోషేతో మాట్లాడాడు. ఆయన ఇలా అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“రెండు వెండి బాకాలు చేయించు. వెండిని సాగగొట్టి వాటిని చేయించాలి. సమాజాన్ని సమావేశం కోసం పిలవడానికీ, సేనలను తరలించడానికీ ఆ బాకాలను ఉపయోగించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","సన్నిధి గుడారం ఎదుట నీ దగ్గరికి సమాజమంతా సమావేశం కావడానికి యాజకులు ఆ బాకాలు ఊదాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","యాజకులు ఒకే బాకా ఊదితే ఇశ్రాయేలు సమాజంలో నాయకులూ, తెగల పెద్దలు నీ దగ్గరకి రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","మీరు పెద్ద శబ్దంతో వాటిని ఊదితే అది సంకేతంగా భావించి తూర్పు వైపున ఉన్న సేనలు ప్రయాణం ప్రారంభించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","మీరు రెండో సారి పెద్ద శబ్దంతో వాటిని ఊదితే అది సంకేతంగా భావించి దక్షిణం వైపున సైన్యాలు ప్రయాణం మొదలు పెట్టాలి. వారి ప్రయాణం ప్రారంభించినప్పుడు పెద్ద శబ్దంతో ఊదాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","సమాజం సమావేశంగా కూడినప్పుడు బాకాలు ఊదాలి గానీ పెద్ద శబ్దం చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","యాజకులైన అహరోను కొడుకులు ఆ బాకాలు ఊదాలి. మీ తరతరాల్లో మీ సంతానానికి అది నిత్యమైన నియమంగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","మిమ్మల్ని బాధించే శత్రువుకి వ్యతిరేకంగా మీ దేశంలో యుద్ధానికి బయలు దేరే సమయంలో ఆ బాకాలు పదేపదే పెద్ద శబ్దంతో ఊదాలి. అప్పుడు మీ దేవుడైన యెహోవా అనే నేను మిమ్మల్ని జ్ఞాపకం చేసుకుని శత్రువుల నుండి మిమ్మల్ని రక్షిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","మీ పండగల సమయంలోనూ, నెల ప్రారంభంలోనూ మీరు వేడుకలు చేసుకునేటప్పుడు మీరు అర్పించే దహన బలుల గౌరవార్ధం, మీ శాంతి బలుల గౌరవార్ధం మీరు బాకాలు ఊదాలి. ఇవి మీకు మీ దేవుడినైన నన్ను జ్ఞాపకం చేస్తాయి. నేనే యెహోవాను. మీ దేవుణ్ణి.” ");
INSERT INTO tel2017_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","రెండో సంవత్సరం రెండో నెల ఇరవయ్యో రోజున శాసనాల గుడారం పైనుండి మేఘం వెళ్లి పోయింది. ");
INSERT INTO tel2017_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","కాబట్టి ఇశ్రాయేలు ప్రజలు సీనాయి అరణ్యంలో తమ ప్రయాణం సాగించారు. మేఘం తిరిగి పారాను అరణ్యంలో నిలిచింది. ");
INSERT INTO tel2017_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","యెహోవా మోషేకి ఇచ్చిన ఆదేశాలను బట్టి వారు తమ మొదటి ప్రయాణం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","యూదా గోత్రం వారి ధ్వజం కింద ఉన్న సైన్యం మొదట శిబిరం బయటికి కదిలింది. అమ్మీనాదాబు కొడుకు నయస్సోను ఆ సైన్యానికి నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ఇశ్శాఖారు గోత్రం సైన్యాన్ని సూయారు కొడుకు నెతనేలు నడిపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","జెబూలూను గోత్రం సైన్యానికి హేలోను కొడుకు ఏలీయాబు నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","గెర్షోను, మెరారి తెగలవారు తమ బాధ్యత ప్రకారం మందిరాన్ని విప్పి దాన్ని మోస్తూ ముందుకు సాగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","తరువాత రూబేను గోత్రం ధ్వజం కింద ఉన్న సైన్యం ముందుకు కదిలింది. ఆ సైన్యానికి నాయకుడు షెదేయూరు కొడుకు ఏలీసూరు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","షిమ్యోను గోత్రం సైన్యానికి సూరీషదాయి కొడుకు షెలుమీయేలు నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","గాదు గోత్రం సైన్యానికి దెయూవేలు కొడుకు ఎలీయాసాపు నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","కహాతు తెగవారు ప్రయాణమయ్యారు. వారు పరిశుద్ధ స్థలంలోని పరిశుద్ధ పరికరాలను మోస్తూ వెళ్ళారు. తరువాతి శిబిరంలో కహాతు తెగవారు వచ్చేలోగా ఇతరులు మందిరాన్ని నిలబెడుతూ ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ఎఫ్రాయీము గోత్రం వారి ధ్వజం కింద వారి సేనలు కదిలాయి. ఈ సైన్యానికి అమీహూదు కొడుకు ఎలీషామా నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","మనష్శే గోత్రం సైన్యానికి పెదాసూరు కొడుకు గమలీయేలు నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","బెన్యామీను గోత్రం సైన్యానికి గిద్యోనీ కొడుకు అబీదాను నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","చివర్లో దాను గోత్రపు సైన్యాలు తమ ధ్వజం కింద కదిలాయి. ఈ సైన్యానికి నాయకుడు అమీషదాయి కొడుకు అహీయెజెరు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ఆషేరు గోత్రం సైన్యానికి ఒక్రాను కొడుకు పగీయేలు నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","నఫ్తాలి గోత్రం సేనలకి ఏనాను కొడుకు అహీరా నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ఈ విధంగా ఇశ్రాయేలు సైన్యాలు ముందుకు ప్రయాణం చేసాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","మోషే హోబాబుతో మాట్లాడాడు. ఈ హోబాబు మోషే భార్యకు తండ్రి అయిన రెవూయేలు కొడుకు. ఇతడు మిద్యాను ప్రాంతం వాడు. మోషే హోబాబుతో “యెహోవా మాకు చూపించిన దేశానికి మేము వెళ్తున్నాం. దాన్ని మీకు ఇస్తానని యెహోవా మాకు చెప్పాడు. నువ్వు మాతో రా. మా వల్ల మీకు మేలు కలుగుతుంది. ఇశ్రాయేలు ప్రజలకి మేలు చేస్తానని యెహోవా ప్రమాణం చేశాడు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","దానికి అతడు “నేను రాను. నేను నా స్వదేశానికీ, నా సొంత ప్రజల దగ్గరకీ వెళ్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","అప్పుడు మోషే ఇలా జవాబిచ్చాడు. “నువ్వు మమ్మల్ని దయచేసి విడిచి పెట్టవద్దు. అరణ్యంలో ఎలా నివసించాలో నీకు బాగా తెలుసు. నువ్వు మా కోసం కనిపెట్టుకుని ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","నువ్వు మాతో వస్తే యెహోవా మాకు చేసిన మేలుని మేము నీకు చేస్తాం.” ");
INSERT INTO tel2017_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","వారు యెహోవా కొండ దగ్గర నుండి మూడు రోజులు ప్రయాణం చేశారు. వారి విశ్రాంతి స్థలం కోసం చేసిన మూడు రోజుల ప్రయాణంలో యెహోవా నిబంధన శాసనాల పెట్టె వాళ్లకి ముందుగా కదిలింది. ");
INSERT INTO tel2017_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","వారు తాము మజిలీ చేసిన స్థలం నుండి ప్రయాణం చేసినప్పుడు యెహోవా మేఘం పగటివేళ వారి మీద ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","నిబంధన పెట్టె ప్రయాణం కోసం లేచినప్పుడల్లా మోషే “యెహోవా, లే, నీ శత్రువులను చెదరగొట్టు. నిన్ను ద్వేషించే వారిని నీ ఎదుటనుండి తరిమి కొట్టు” అనేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","నిబంధన పెట్టె ఆగినప్పుడు మోషే “యెహోవా లక్షలాది మంది ఇశ్రాయేలు ప్రజల దగ్గరికి తిరిగి రా” అనేవాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ప్రజలు యెహోవా వింటుండగా తమ సమస్యల గురించి ఫిర్యాదు చేయడం మొదలు పెట్టారు. వారి మాటలు విని యెహోవా ఆగ్రహించాడు. దాంతో వారి మధ్యలో మంటలు రేగి శిబిరం ఒక వైపున అంచుల్లో కాలిపోవడం మొదలయింది. ");
INSERT INTO tel2017_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","అప్పుడు ప్రజలు గట్టిగా కేకలు పెట్టి మోషేను బతిమాలారు. కాబట్టి మోషే యెహోవాకు ప్రార్ధించాడు. అప్పుడు ఆ మంటలు చల్లారాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","యెహోవా అగ్ని వారి మధ్యలో రగిలింది కాబట్టి ఆ స్థలానికి “తబేరా” అనే పేరు వచ్చింది. ");
INSERT INTO tel2017_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","కొంతమంది విదేశీయులు ఇశ్రాయేలు ప్రజల మధ్య వారితో కలసి నివసిస్తున్నారు. వారు తినడానికి ఇంకా మంచి ఆహారం కోరుకున్నారు. దాంతో ఇశ్రాయేలు ప్రజలు ఫిర్యాదు చేస్తూ “తినడానికి మాకు మాంసం ఎవరిస్తారు? ");
INSERT INTO tel2017_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ఐగుప్తులో మేము స్వేచ్ఛగా ఆరగించిన చేపలూ, కీర దోస కాయలూ, కర్బూజాలూ, ఆకు కూరలూ, ఉల్లి పాయలూ, వెల్లుల్లీ మాకు గుర్తుకు వస్తున్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ఇప్పుడు మేము బలహీనులమయ్యాం. తినడానికి ఈ మన్నా తప్పించి మాకేం కన్పించడం లేదు” అని చెప్పుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ఆ మన్నా కొత్తిమీర గింజల్లా ఉంటుంది. చూడ్డానికి గుగ్గిలంలా ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ప్రజలు శిబిరం మైదానంలో నడుస్తూ మన్నాని సేకరించేవారు. తిరగలిలో విసిరి గానీ రోట్లో దంచి గానీ దాన్ని పిండి చేసి పెనం పైన కాల్చి రొట్టెలు చేసే వారు. దాని రుచి తాజా ఒలీవ నూనె రుచిలా ఉండేది. ");
INSERT INTO tel2017_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","రాత్రి వేళల్లో శిబిరం పైన మంచు కురిసినప్పుడు దాంతో పాటే మన్నా కూడా ఆ మంచు పైన పడేది. ");
INSERT INTO tel2017_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ప్రజలు వారి కుటుంబాలతో కలసి ఎవరి గుమ్మం ఎదుట వారు కూర్చుని ఏడుస్తుండగా మోషే విన్నాడు. యెహోవా భీకర కోపం రగిలి పోయింది. వారు ఏడవడం, ఫిర్యాదు చేయడం మోషే దృష్టిలో తప్పుగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","అప్పుడు మోషే యెహోవాతో ఇలా అన్నాడు. “నేను నీ సేవకుణ్ణి. నాపై ఇంత నిర్దయగా వ్యవహరించావెందుకు? నాపై ఇంత కోపంగా ఉన్నావెందుకు? ఈ ప్రజల భారాన్ని నాపై మోపావు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ఈ జనాన్నంతా నేను కన్నానా? ‘తండ్రి తన బిడ్డని గుండెకి హత్తుకున్నట్టుగా వీరిని హత్తుకో’ అని నువ్వు నాతో చెప్పడానికి నేనేమన్నా వారిని నా గర్భంలో మోసానా? వారి పూర్వీకులకి నువ్వు ఇస్తానని ప్రమాణం చేసిన దేశానికి నేను వారిని మోసుకు వెళ్ళాలా? ");
INSERT INTO tel2017_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ఇంతమంది ప్రజలకి మాంసం నేను ఎక్కడ నుండి తేవాలి? వారు నన్ను చూసి ఏడుస్తున్నారు. ‘మేము తినడానికి మాంసం ఇవ్వు’ అంటున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ఈ ప్రజలందరి భారం మోయడం నా ఒక్కడి వల్ల కాదు. వీళ్ళ భారం నా శక్తికి మించింది. ");
INSERT INTO tel2017_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","నువ్వు నాతో ఇలా వ్యవహరించదలిస్తే నన్ను ఇప్పుడే చంపెయ్యి. నా మీద నీకు దయ కలిగితే నన్ను చంపి నా బాధ తీసెయ్యి.” ");
INSERT INTO tel2017_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","అప్పుడు యెహోవా మోషేతో ఇలా అన్నాడు. “ఇశ్రాయేలు ప్రజల్లో పెద్దలు 70 మందిని నాదగ్గరికి తీసుకురా. వారు ప్రజల్లో పెద్దలనీ అధిపతులనీ స్పష్టంగా గుర్తించి తీసుకురా. వారిని సన్నిధి గుడారం దగ్గరికి తీసుకుని రా. వారిని నీతో కూడా నిలబెట్టు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","అక్కడ నేను దిగి నీతో మాట్లాడతాను. తరువాత నీ మీద ఉన్న ఆత్మలో కొంత వారి పైన ఉంచుతాను. వారు నీతో కలసి ప్రజల భారాన్ని మోస్తారు. నువ్వు ఒంటరిగా ఈ భారం మోయాల్సిన అవసరం లేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","నువ్వు ప్రజలకుఇలా చెప్పు. రేపటికి మిమ్మల్ని మీరు పవిత్రం చేసుకోండి. యెహోవా రాకకై సిద్ధపడండి. యెహోవా వింటుండగా మీరు ఏడ్చారు కాబట్టి మీరు కచ్చితంగా మాంసం తింటారు. ‘మాకు మాంసం ఎవరు పెడతారు? మాకు ఐగుప్తులోనే బాగుంది’ అన్నారు గదా. అందుకని యెహోవా మీకు మాంసం ఇస్తాడు. మీరు దాన్ని తింటారు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ఒక్క రోజు కాదు, రెండు రోజులు కాదు, ఐదు రోజులు కాదు, పది రోజులు కాదు, ఇరవై రోజులు కాదు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ఒక నెల రోజులు మీరు మాంసం తింటారు. అది మీ ముక్కు పుటాల్లోంచి బయటకు వచ్చి మీకు అసహ్యం పుట్టే వరకూ తింటారు. మీరు మీ మధ్య ఉన్న యెహోవాను తిరస్కరించారు కాబట్టి అది మీకు వెగటు పుట్టిస్తుంది. ఆయన ముందు మీరు ఏడ్చారు. ‘ఐగుప్తు నుండి ఎందుకు వచ్చాం?’ అన్నారు.” ");
INSERT INTO tel2017_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","దానికి మోషే “నేను ఆరు లక్షలమంది జనంతో ఉన్నాను. నువ్వేమో ‘ఒక నెల అంతా వాళ్లకి మాంసం ఇస్తాను’ అంటున్నావు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ఇప్పుడు వారిని తృప్తి పరచడానికి గొర్రెలను, పశువులను చంపాలా? సముద్రంలో ఉన్న చేపలన్నిటినీ వారి కోసం పట్టాలా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","అప్పుడు యెహోవా మోషేతో “నా బాహుబలానికి శక్తి తగ్గిందా? నా మాట నిజమో కాదో నువ్వు ఇప్పుడే చూస్తావు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","మోషే బయటికి వచ్చి యెహోవా మాటలు ప్రజలకు చెప్పాడు. ప్రజల్లోనుండి 70 మంది పెద్దలను గుడారం చుట్టూ నిలబెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","అప్పుడు యెహోవా మేఘంలో దిగాడు. అతనితో మాట్లాడాడు. అతని పైన ఉన్న ఆత్మలో ఒక భాగాన్ని పెద్దల పైన ఉంచాడు. ఆత్మ వారిపై ఉన్నప్పుడు వారు ప్రవచనం చెప్పారు. వారంతా ఆ సందర్భంలోనే ప్రవచించారు, ఆ తరువాత ఎప్పుడూ ప్రవచనం చెప్పలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ఆ మనుషుల్లో ఇద్దరు శిబిరంలో ఉండిపోయారు. వారి పేర్లు ఎల్దాదు, మేదాదు. ఆత్మ వారిపై కూడా నిలిచాడు. వారి పేర్లు పెద్దల జాబితాలో ఉన్నాయి కానీ వారు గుడారం దగ్గరకి వెళ్ళలేదు. అయినా వారి శిబిరంలోనే వారు ప్రవచించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","అప్పుడు శిబిరంలో ఒక యువకుడు మోషే దగ్గరికి పరుగెత్తుకుంటూ వచ్చి “ఎల్దాదు, మేదాదులు శిబిరంలో ప్రవచిస్తున్నారు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","మోషే సహాయకుడూ, తాను ఎన్నుకున్న వారిలో ఒకడూ, నూను కొడుకూ అయిన యెహోషువ “మోషే, నా యజమానీ, వారిని ఆపు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","దానికి మోషే “నా కోసం నీకు రోషం వచ్చిందా? అసలు యెహోవా ప్రజలందరూ ప్రవక్తలు కావాలని కోరుకుంటున్నాను. దాని కోసం యెహోవా తన ఆత్మని అందరి పైనా ఉంచుతాడు గాక” అని అతనితో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","అప్పుడు మోషే, ఇశ్రాయేలు పెద్దలంతా శిబిరంలోకి వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","అప్పుడు యెహోవా దగ్గరనుండి వాయువు బయల్దేరింది. అది సముద్రం నుండి పూరేడు పిట్టలను తీసుకు వచ్చి శిబిరంలో అంతటా పడవేసింది. ఈ వైపునుండి ఆ వైపుకీ, ఆ వైపునుండి ఈ వైపుకీ ఒక రోజు ప్రయాణమంత దూరం వరకూ అవి వచ్చి పడ్డాయి. అవి భూమికి రెండు మూరల ఎత్తున పడ్డాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","కాబట్టి ప్రజలు ఉదయాన్నే లేచి ఆ రోజంతా వాటిని సేకరించారు. ఆ రాత్రీ మరుసటి రోజు అంతా వాటిని సేకరించారు. నూరు తూముల పిట్టల కంటే తక్కువ సేకరించినవాడు లేడు. తరువాత వారు వాటిని శిబిరం చుట్టూ తమ కోసం పరచి ఉంచారు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ఆ మాంసం వారి పళ్ళ మధ్య ఉండగానే, వారు దాన్ని నములుతూ ఉన్నప్పుడే యెహోవా వారిపై ఆగ్రహించాడు. పెద్ద రోగంతో ఆయన వారిని బాధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","మాంసం కోసం అతిగా ఆశ పడిన వారిని ప్రజలు ఒక స్థలంలో పాతిపెట్టారు. అందుకే ఆ స్థలానికి “కిబ్రోతు హత్తావా” అనే పేరు కలిగింది. ");
INSERT INTO tel2017_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ప్రజలు కిబ్రోతు హత్తావా నుండి హజేరోతుకి ప్రయాణమై వెళ్ళారు. అక్కడ నివసించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","మోషే కూషు దేశానికి చెందిన ఒక స్త్రీని పెళ్ళి చేసుకున్నాడు. అందుకని మిర్యాము, అహరోనులు మోషేకి వ్యతిరేకంగా మాట్లాడారు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“యెహోవా కేవలం మోషేతోనే మాట్లాడాడా? మాతో ఆయన మాట్లాడలేదా?” అని చెప్పుకున్నారు. వాళ్ల మాటలు యెహోవా విన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","మోషే ఎంతో సాధుగుణం గలవాడు. భూమిపైన ఉన్నవారందరిలో ఎంతో సాత్వికుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","వెంటనే యెహోవా మోషే, అహరోను, మిర్యాములతో మాట్లాడాడు. “మీరు ముగ్గురూ ఉన్న పళంగా సన్నిధి గుడారం దగ్గరకి రండి” అన్నాడు. ఆ ముగ్గురూ అక్కడికి వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","అప్పుడు యెహోవా మేఘస్తంభంలో దిగి వచ్చాడు. గుడారం ద్వారం దగ్గర నుండి అహరోను, మిర్యాములను పిలిచాడు. వారిద్దరూ అక్కడికి వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","యెహోవా ఇలా అన్నాడు. “మీరు ఇప్పుడు నా మాటలు వినండి. మీ మధ్య నా ప్రవక్త ఎవరన్నా ఉంటే, నేను అతనికి స్వప్నాల ద్వారా దర్శనం ఇస్తాను. కలల ద్వారా అతనితో మాట్లాడతాను. ");
INSERT INTO tel2017_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","నా సేవకుడు మోషే అలాంటి వాడు కాదు. అతడు నా ఇల్లంతటిలో నమ్మకమైనవాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","నేను అతనితో స్వప్నాల్లోనో, నిగూఢమైన రీతిలోనో మాట్లాడను. ముఖాముఖీగా మాట్లాడతాను. అతడు నా స్వరూపాన్ని చూస్తాడు. అలాంటప్పుడు నా సేవకుడైన మోషేకి వ్యతిరేకంగా మాట్లాడడానికి మీరెందుకు భయపడలేదు?” ");
INSERT INTO tel2017_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","యెహోవా వారిపై తీవ్రంగా ఆగ్రహించి అక్కడనుండి వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","గుడారం పైనుండి మేఘం పైకి వెళ్ళిపోయింది. అప్పుడు అకస్మాత్తుగా మిర్యాముకు కుష్టు వ్యాధి సోకింది. ఆమె మంచులా తెల్లగా కన్పించింది. అహరోను ఆమెని చూశాడు. ఆమెకి కుష్టువ్యాధి ఉండడం చూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","అప్పుడు అహరోను మోషేతో ఇలా అన్నాడు. “అయ్యో నా ప్రభూ, మేము చేసిన పాపానికి శిక్ష మాకు వేయవద్దు. మేము తెలివి తక్కువగా మాట్లాడి పాపం చేశాం. ");
INSERT INTO tel2017_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","తన తల్లి గర్భంలోంచి బయటకి వచ్చేటప్పటికే సగం మాంసం పోగొట్టుకున్న మృతశిశువులా ఆమెని ఉండనీయకు.” ");
INSERT INTO tel2017_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","కాబట్టి మోషే యెహోవాకు మొర పెట్టాడు. “దేవా, దయచేసి ఈమెను బాగు చెయ్యి” అని ప్రార్ధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","అప్పుడు యెహోవా మోషేతో “ఆమె తండ్రి ఆమె ముఖంపై ఉమ్మి వేస్తే ఆ అవమానం ఆమె ఏడు రోజులు భరిస్తుంది కదా. ఆ ఏడు రోజులూ ఆమెని శిబిరం బయట ప్రత్యేకంగా ఉంచు. ఆ తరువాత ఆమెని తిరిగి శిబిరంలోకి తీసుకు రా” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","కాబట్టి మిర్యాము ఏడు రోజులు శిబిరం బయటే గడిపింది. మిర్యాము తిరిగి శిబిరంలోకి వచ్చే వరకూ ప్రయాణం చేయకుండా ప్రజలు నిలిచిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ఆ తరువాత ప్రజలు హజేరోతు నుండి ప్రయాణం చేసి పారాను అరణ్యంలో ఆగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ఆ తరువాత యెహోవా మోషేతో మాట్లాడాడు. ఆయన ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","నేను ఇశ్రాయేలు ప్రజలకి ఇస్తున్న కనాను దేశాన్ని పరీక్షించడానికి కొంతమందిని పంపించు. తమ పూర్వీకుల గోత్రాల ప్రకారం ఒక్కో గోత్రం నుండి ఒక్కో వ్యక్తిని మీరు పంపించాలి. వారిల్లో ప్రతి వాడూ తమ ప్రజల్లో నాయకుడై ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","మోషే యెహోవా ఆజ్ఞకు విధేయులయ్యేలా వారిని పారాను అరణ్యం నుండి పంపించాడు. వెళ్ళిన వారంతా ఇశ్రాయేలు ప్రజల్లో నాయకులు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","వారి పేర్లు ఇవి. రూబేను గోత్రం నుండి జక్కూరు కొడుకు షమ్మూయ, ");
INSERT INTO tel2017_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","షిమ్యోను గోత్రం నుండి హోరీ కొడుకు షాపాతు, ");
INSERT INTO tel2017_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","యూదా గోత్రం నుండి యెఫున్నె కొడుకు కాలేబు, ");
INSERT INTO tel2017_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ఇశ్శాఖారు గోత్రం నుండి యోసేపు కొడుకు ఇగాలు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ఎఫ్రాయిము గోత్రం నుండి నూను కుమారుడు హోషేయ. ");
INSERT INTO tel2017_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","బెన్యామీను గోత్రం నుండి రాఫు కొడుకు పల్తీ, ");
INSERT INTO tel2017_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","జెబూలూను గోత్రం నుండి సోరీ కొడుకు గదీయేలు, ");
INSERT INTO tel2017_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","యోసేపు గోత్రం నుండి అంటే మనష్షే గోత్రం నుండి సూసీ కొడుకు గదీ, ");
INSERT INTO tel2017_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","దాను గోత్రం నుండి గెమలి కొడుకు అమ్మీయేలు, ");
INSERT INTO tel2017_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ఆషేరు గోత్రం నుండి మిఖాయేలు కొడుకు సెతూరు, ");
INSERT INTO tel2017_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","నఫ్తాలి గోత్రం నుండి వాపెసీ కొడుకు నహబీ, ");
INSERT INTO tel2017_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","గాదు గోత్రం నుండి మాకీ కొడుకు గెయువేలు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ఆ దేశాన్ని పరీక్షించడానికి మోషే పంపిన వ్యక్తుల పేర్లు ఇవి. నూను కొడుకు హోషేయకి మోషే యెహోషువ అనే పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","వారిని కనాను దేశాన్ని చూసి పరీక్షించడానికి మోషే పంపించాడు. అప్పుడు వాళ్లతో ఇలా చెప్పాడు. “మీరు దక్షిణం వైపు నుండి ప్రవేశించి పర్వత ప్రాంతంలోకి ఎక్కి వెళ్ళండి. ");
INSERT INTO tel2017_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ఆ దేశం ఎలాంటిదో పరీక్షించండి. అక్కడ నివసించే ప్రజలను పరిశీలించండి. ఆ ప్రజలు బలవంతులా లేక బలహీనులా అన్నది చూడండి. అక్కడి ప్రజల జనాభా కొద్దిమందే ఉన్నారా లేక అధికంగా ఉన్నారా అనేది చూడండి. ");
INSERT INTO tel2017_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","వారు నివసించే నేల ఎలాంటిదో చూడండి. అది మంచిదా, చెడ్డదా? ఎలాంటి పట్టణాలు అక్కడ ఉన్నాయి? వారి నివాసాలు శిబిరాల్లా ఉన్నాయా లేక ప్రాకారాలున్న కోటల్లో నివసిస్తున్నారా? ");
INSERT INTO tel2017_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","అక్కడి భూమి లక్షణం ఎలాంటిదో చూడండి. అది సారవంతమైనదా లేక నిస్సారమైనదా? అక్కడ చెట్లు ఉన్నాయో లేవో చూడండి. ధైర్యంగా ఉండండి. అక్కడి భూమి మీద పండే ఉత్పత్తుల్లో ఏవైనా రకాలు తీసుకు రండి.” అది ద్రాక్ష పళ్ళు పక్వానికి వచ్చే కాలం. ");
INSERT INTO tel2017_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","కాబట్టి ఆ వ్యక్తులు బయల్దేరి వెళ్ళారు. వారు లెబో హమాతు అనే ప్రాంతానికి దగ్గరగా సీను అరణ్యం నుండి రెహోబు వరకూ వెళ్లి సంచారం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","వారు దక్షిణం వైపు నుండి ప్రయాణం చేసి హెబ్రోనుకి వచ్చారు. అక్కడ అనాకు వంశం వారు అయిన అహీమాను, షేషయి, తల్మయి అనే తెగల ప్రజలు ఉన్నారు. ఆ హెబ్రోను పట్టణాన్ని ఐగుప్తులో ఉన్న సోయను పట్టణం కంటే ఏడేళ్ళు ముందుగా కట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","వారు ఎష్కోలు లోయ చేరుకున్నారు. అక్కడ ద్రాక్ష గుత్తులు ఉన్న ఒక కొమ్మను కోశారు. దాన్ని ఒక కర్రకి కట్టి ఇద్దరు వ్యక్తులు మోశారు. అక్కడనుంచే కొన్ని దానిమ్మ పళ్ళనూ కొన్ని అంజూరు పళ్ళనూ తీసుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ఇశ్రాయేలు ప్రజలు ఆ ప్రాంతంలో కోసిన ద్రాక్ష గెలను బట్టి ఆ ప్రాంతానికి “ఎష్కోలు లోయ” అనే పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","వారు ఆ దేశంలో నలభై రోజుల పాటు సంచరించి, పరీక్షించి తిరిగి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","పారాను అరణ్యంలో కాదేషులో ఉన్న మోషే అహరోనుల దగ్గరికీ, ఇశ్రాయేలు ప్రజలందరి దగ్గరికీ వచ్చారు. ఆ దేశం గురించిన సమాచారం తెలియజేశారు. అలాగే తాము తెచ్చిన ఆ ప్రాంతం పళ్ళు చూపించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","వారు మోషేకి ఇలా చెప్పారు. “నువ్వు మమ్మల్ని పంపించిన దేశానికి మేము వెళ్లాం. అక్కడ పాలు తేనెలు ప్రవహిస్తున్నాయి అన్నది నిజమే. ఆ దేశం పళ్ళు ఇవి. ");
INSERT INTO tel2017_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","కానీ అక్కడ నివసిస్తున్న ప్రజలు చాలా బలవంతులు. అక్కడి పట్టణాలు పెద్దవి. అవన్నీ బ్రమ్హాండమైన ప్రాకారాలు ఉన్న పట్టణాలు. అక్కడ మేము అనాకు వంశం వారిని చూశాం. ");
INSERT INTO tel2017_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","దక్షిణ ప్రాంతంలో అమాలేకు ప్రజలు నివసిస్తున్నారు. కొండ ప్రాంతంలో హిత్తీ, యెబూసీ, అమోరీ తెగల వారు నివసిస్తున్నారు. ఇక సముద్రం సమీపంలోనూ, యొర్దాను నదీ ప్రాంతంలోనూ కనాను ప్రజలు నివసిస్తున్నారు.” ");
INSERT INTO tel2017_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","అప్పుడు కాలేబు మోషే చుట్టూ చేరిన జనాన్ని ఉత్సాహపరచడానికి ప్రయత్నం చేశాడు. “మనం దానిపై దాడి చేసి స్వాధీనం చేసుకుందాం. దాన్ని జయించడానికి మనకున్న బలం సరిపోతుంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","కాని అతనితో వెళ్ళిన మిగతా వారు “అక్కడి ప్రజలపై మనం దాడి చేయలేం. ఎందుకంటే వారు మనకన్నా బలవంతులు.” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ఈ విధంగా వారు తాము వెళ్లి చూసి వచ్చిన ప్రాంతం గురించి ఇశ్రాయేలు ప్రజలకు నిరుత్సాహ పరిచే నివేదిక ఇచ్చారు. “మేము చూసి వచ్చిన ఆ దేశం తన నివాసుల్నే మింగివేసే దేశం. మేము చూసిన ప్రజలంతా ఆజానుబాహులు. ");
INSERT INTO tel2017_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","అక్కడ మేము నెఫీలీ ప్రజలను చూశాం. వారు అనాకు వంశం వాడైన నెఫీలీ తెగ వారు. వారి ఎదుట మా దృష్టికి మేము మిడతల్లాగా ఉన్నాం. వారి దృష్టికీ అలాగే ఉన్నాం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ఆ రాత్రి ప్రజలందరూ పెద్దగా కేకలు పెట్టి ఏడ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ఇశ్రాయేలీయులందరూ మోషే అహరోనులకు వ్యతిరేకంగా గొడవ చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ఆ సమాజమంతా వారితో “ఈ అరణ్యంలో చనిపోవడం కన్నా మేము ఐగుప్తులో చనిపోతే బాగుండేది! మేము కత్తివాత చావాలని యెహోవా మమ్మల్ని ఈ ప్రదేశానికి తీసుకొచ్చాడా? మా భార్యలు, మా చిన్న పిల్లలు బాధల పాలౌతారు. మళ్ళీ ఐగుప్తు తిరిగి వెళ్ళడం మాకు మేలు కాదా?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","వారు “మనం ఇంకొక నాయకుణ్ణి ఎంపిక చేసుకుని ఐగుప్తుకు తిరిగి వెళ్దాం పదండి” అని ఒకరితో ఒకరు చెప్పుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","అప్పుడు మోషే, అహరోను ఇశ్రాయేలు ప్రజల సమావేశం ఎదుట సాగిలపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","అప్పుడు, ఆ ప్రదేశాన్ని పరిశీలించి చూసిన వారిలో నూను కొడుకు యెహోషువ, యెఫున్నె కొడుకు కాలేబు బట్టలు చింపుకుని, ");
INSERT INTO tel2017_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ఇశ్రాయేలీయుల సర్వజన సమూహంతో మాట్లాడుతూ “మేము సంచారం చేసి పరిశీలించి చూసిన ప్రదేశం ఎంతో మంచి ప్రదేశం. ");
INSERT INTO tel2017_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","యెహోవా మనలను బట్టి ఆనందిస్తే, ఆ ప్రదేశంలో మనలను చేర్చి, దాన్ని మనకు ఇస్తాడు. అది పాలు తేనెలు ప్రవహించే ప్రదేశం. ");
INSERT INTO tel2017_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","కాబట్టి, మీరు యెహోవా మీద తిరగబడవద్దు. ఆ దేశ ప్రజలకు భయపడవద్దు. వారు మనకు అన్నం తిన్నంత తేలిక. యెహోవా మనతో ఉన్నాడు గనక వారి భద్రత ఇక వారి పై నుండి తొలిగిపోతుంది. వాళ్లకు భయపడవద్దు” అన్నారు. కాని, ఆ సమూహం, వారిని రాళ్లతో కొట్టి చంపాలన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","అప్పుడు సన్నిధి గుడారంలో యెహోవా మహిమ ఇశ్రాయేలీయులందరికీ కనబడింది. ");
INSERT INTO tel2017_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","యెహోవా మోషేతో “ఎంతకాలం ఈ ప్రజలు నన్ను కించపరుస్తారు? నా శక్తిని చూపించే సూచనలన్నీ నేను వారి మధ్య జరిగించినా, నన్ను ఇంకెంతకాలం నమ్మకుండా ఉంటారు? ");
INSERT INTO tel2017_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","నేను వారి మీద తెగులుపంపిస్తాను. వారికి వారసత్వ హక్కు లేకుండా చేస్తాను. ఈ జనం కంటే మరింత గొప్ప బలమైన జనాంగాన్ని నీ వంశం ద్వారా పుట్టిస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","మోషే యెహోవాతో “అలా చేస్తే ఐగుప్తీయులు దాని గురించి వింటారు. ఎందుకంటే నీ బలంతో నువ్వు ఈ జనాన్ని ఐగుప్తీయుల్లో నుంచి రప్పించావు. వారు ఈ దేశ వాసులతో ఈ విషయం చెప్తారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","యెహోవా అనే నువ్వు ఈ ప్రజల మధ్య ఉన్నావనీ, యెహోవా అనే నువ్వు ముఖాముఖిగా కనిపించినవాడివనీ, నీ మేఘం వారి మీద నిలిచి ఉన్నదనీ, నువ్వు పగలు మేఘస్తంభంలోనూ, రాత్రి అగ్నిస్తంభంలోనూ వారి ముందు నడుస్తున్నావనీ, వారు విని ఉన్నారు గదా. ");
INSERT INTO tel2017_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","కాబట్టి నువ్వు ఒక్క దెబ్బతో ఈ ప్రజలను చంపితే నీ కీర్తిని గురించి విన్న ప్రజలు ");
INSERT INTO tel2017_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘ప్రమాణ పూర్వకంగా తాను ఈ ప్రజలకిచ్చిన దేశంలో వారినిచేర్చడానికి శక్తిలేక, యెహోవా వారిని అరణ్యంలో చంపేశాడు’ అని చెప్పుకుంటారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","‘యెహోవా దీర్ఘశాంతుడు, నిబంధన నమ్మకత్వం సమృద్ధిగా కలిగినవాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","దోషం, అతిక్రమం పరిహరించేవాడు. అపరాధిని నిరపరాధిగా ఎంచకుండా, మూడు నాలుగు తరాల వరకూ తండ్రుల దోషాన్ని కొడుకుల మీదికి తెచ్చే వాడిగా ఉన్నాడు’ అని నువ్వు చెప్పిన మాట ప్రకారం నా ప్రభువు బలానికి ఘనత కలుగు గాక. ");
INSERT INTO tel2017_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ఐగుప్తులోనుంచి వచ్చింది మొదలు ఇంతవరకూ నువ్వు ఈ ప్రజల పాపం పరిహరించినట్టు నీ గొప్ప నిబంధన నమ్మకత్వాన్నిబట్టి ఈ ప్రజల పాపాన్ని దయచేసి క్షమించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","యెహోవా “నీ కోరిక ప్రకారం నేను క్షమించాను. ");
INSERT INTO tel2017_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","కాని, నా జీవంతో తోడు, భూమి అంతా నిండి ఉన్న యెహోవా మహిమ తోడు, ");
INSERT INTO tel2017_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ఐగుప్తులో, అరణ్యంలో నేను చేసిన సూచనలనూ, నా మహిమను చూసిన ఈ మనుషులందరూ, ఈ పదిసార్లు నా మాట వినకుండా నన్ను పరీక్షకు గురి చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","కాబట్టి వారి పితరులకు ప్రమాణ పూర్వకంగా నేనిచ్చిన దేశాన్ని వారు చూడనే చూడరు. నన్ను పట్టించుకోని వారిలో ఎవరూ దాన్ని చూడరు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","నా సేవకుడైన కాలేబు వీళ్ళ లాంటి వాడు కాదు. అతడు పూర్ణమనస్సుతో నన్ను అనుసరించిన కారణంగా అతడు పరిశీలించడానికి వెళ్ళిన దేశంలో అతన్ని ప్రవేశపెడతాను. ");
INSERT INTO tel2017_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","అతని సంతానం దాన్ని స్వాధీనం చేసుకుంటుంది. అమాలేకీయులు, కనానీయులు ఆ లోయలో నివాసం ఉంటున్నారు. రేపు మీరు తిరిగి ఎర్రసముద్రం మార్గంలో అరణ్యంలోకి ప్రయాణమై వెళ్ళండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ఇంకా యెహోవా మోషే అహరోనులతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“నాకు విరోధంగా నన్ను విమర్శించే ఈ చెడ్డ సమాజాన్ని నేనెంత వరకూ సహించాలి? ఇశ్రాయేలీయులు నాకు విరోధంగా చేస్తున్న విమర్శలు నేను విన్నాను. ");
INSERT INTO tel2017_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","నువ్వు వారితో, యెహోవా చెప్పేదేమంటే, నేను జీవంతో ఉన్నట్టు, మీరు నాతో చెప్పినట్టు నేను కచ్చితంగా మీపట్ల చేస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","మీ శవాలు ఈ అరణ్యంలోనే రాలిపోతాయి. మీ పూర్తి లెక్క ప్రకారం మీలో లెక్కకు వచ్చిన వారందరూ, అంటే, ఇరవై సంవత్సరాలు మొదలు ఆ పైవయస్సు కలిగి, నాకు విరోధంగా విమర్శించిన వారిందరూ రాలిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","యెఫున్నె కొడుకు కాలేబు, నూను కొడుకు యెహోషువ తప్ప మీకు నివాసంగా ఇస్తానని నేను ప్రమాణం చేసిన దేశంలో కచ్చితంగా మీలో ఎవరూ ప్రవేశించరు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","కాని, బందీలౌతారని మీరు చెప్పిన మీ పిల్లలను నేను ఆ దేశం లోపలికి రప్పిస్తాను. మీరు తృణీకరించిన దేశాన్ని వారు అనుభవిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","మీ విషయంలో మాత్రం, మీ శవాలు ఈ అరణ్యంలో రాలిపోతాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","మీ పిల్లలు ఈ అరణ్యంలో నలభై సంవత్సరాలు తిరుగులాడతారు. ఈ అరణ్యం మీ శరీరాలను చంపే వరకూ మీ తిరుగుబాటు వల్ల వచ్చిన పర్యవసానాలను వారు భరించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","మీరు ఆ ప్రదేశాన్ని సంచారం చేసి చూసిన నలభై రోజుల లెక్క ప్రకారం రోజుకు ఒక సంవత్సరం ప్రకారం నలభై సంవత్సరాలు మీ పాపశిక్షను భరించి, నేను మీకు శత్రువైతే ఎలా ఉంటుందో మీరు తెలుసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","నేను, యెహోవాను మాట్లాడాను. నాకు విరోధంగా సమకూడిన ఈ దుర్మార్గపు సమాజం పట్ల నేను దీన్ని కచ్చితంగా జరిగిస్తాను. ఈ అరణ్యంలో వారు నాశనం అయిపోతారు. ఇక్కడే చనిపోతారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","మోషే పంపినప్పుడు ఆ దేశంలో సంచారం చేసి చూడడానికి వెళ్లి తిరిగి వచ్చి ఆ దేశం గురించి చెడ్డ సమాచారం చెప్పడం వల్ల సమాజం అంతా అతని మీద తిరుగుబాటు చేసిన మనుషులు, ");
INSERT INTO tel2017_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","అంటే ఆ దేశం గురించి చెడ్డ సమాచారం చెప్పిన మనుషులు యెహోవా సన్నిధిలో తెగులు వల్ల చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","అయితే ఆ దేశం సంచారం చేసి చూసిన మనుషుల్లో నూను కొడుకు యెహోషువ, యెఫున్నె కొడుకు కాలేబు బ్రతికారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","మోషే ఇశ్రాయేలీయులందరితో ఆ మాటలు చెప్పినప్పుడు ఆ ప్రజలు చాలా దుఃఖపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","వారు ఉదయాన లేచి ఆ కొండ శిఖరం ఎక్కి “మనం నిజంగా పాపం చేశాం. చూడండి, మనం ఇక్కడ ఉన్నాం. యెహోవా మనకు వాగ్దానం చేసిన స్థలానికి వెళ్దాం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","కాని మోషే “మీరు యెహోవా ఆజ్ఞను ఎందుకు అతిక్రమిస్తున్నారు? ");
INSERT INTO tel2017_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","దాన్ని మీరు సాధించ లేరు. యెహోవా మీ మధ్య లేడు కాబట్టి మీ శత్రువుల ఎదుట మీరు హతం అవుతారు. మీరు వెళ్ళవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ఎందుకంటే, అమాలేకీయులు, కనానీయులు మీకంటే ముందుగా అక్కడికి చేరారు. మీరు ఖడ్గం చేత చనిపోతారు. మీరు యెహోవాను అనుసరించ లేదు గనక ఇంక యెహోవా మీకు తోడుగా ఉండడు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","కాని వారు మూర్ఖంగా ఆ కొండ కొన మీదకు ఎక్కి వెళ్ళారు. కాని, యెహోవా నిబంధన మందసం గానీ, మోషే గానీ శిబిరం నుంచి బయటకు వెళ్ళలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","అప్పుడు ఆ కొండ మీద నివాసం ఉన్న అమాలేకీయులు, కనానీయులు దిగి వచ్చి వారిపై దాడి చేసి, హోర్మా వరకూ వారిని తరిమి హతం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","తరువాత యెహోవా మోషేతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“నువ్వు ఇశ్రాయేలీయులతో చెప్పు, ‘యెహోవా మీకిస్తున్న ఆ ప్రదేశంలోకి మీరు వెళ్ళినప్పుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","యెహోవాకు ఇష్టమైన సువాసన కలిగేలా మందలోని పశువుల్లో, దహనబలిగానైనా, బలిగానైనా తెచ్చి, మొక్కుబడి చెల్లించడానికి గాని, స్వేచ్ఛార్పణగా గాని, నియామక కాలంలో అర్పించేదిగా గాని, దేనినైనా మీరు అర్పించాలనుకున్నారనుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","యెహోవాకు ఆ అర్పణ అర్పించే వాడు ముప్పావు నూనెతో కలిపిన రెండున్నర కిలోల పిండిని నైవేద్యంగా తేవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ఒక్కొక్క గొర్రెపిల్లతో పాటు దహనబలి మీద గాని, బలి మీద గాని పొయ్యడానికి ముప్పావు లీటర్ల ద్రాక్షారసం పానార్పణగా సిద్ధం చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","పొట్టేలుతో పాటు ఒక పడి నూనెతో కలిపిన నాలుగు లీటర్ల పిండిని నైవేద్యంగా సిద్ధం చెయ్యాలి ");
INSERT INTO tel2017_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ఒక లీటరు ద్రాక్షారసం పానార్పణగా తేవాలి. అది యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2017_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","మొక్కుబడి చెల్లించడానికైనా, యెహోవాకు సమాధానబలి అర్పించడానికైనా, నువ్వు దహనబలిగానైనా, బలిగానైనా లేత దున్నపోతును సిద్ధం చేస్తే, ");
INSERT INTO tel2017_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","దానితో పాటు, లీటరున్నర నూనె కలిపిన ఏడున్నర కిలోల గోదుమపిండిని నైవేద్యంగా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ఇంకా, యెహోవాకు ఇష్టమైన సువాసన కలిగిన దహన బలిగా మీరు తేవలసినవి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","లీటరున్నర ద్రాక్షారసం పానీయార్పణగా తేవాలి. ఒక్కొక్క కోడెతోపాటు, ఒక్కొక్క పొట్టేలుతోపాటు, గొర్రెల్లోనైనా, మేకల్లోనైనా ఒక్కొక్క పిల్లతో పాటు ఆ విధంగా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","మీరు సిద్ధపరిచే వాటి లెక్కను బట్టి వాటి లెక్కలో ప్రతి దానికీ ఆ విధంగా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","దేశంలో పుట్టిన వారందరూ యెహోవాకు ఇష్టమైన సువాసన కలిగిన దహనబలి అర్పణ తెచ్చేటప్పుడు ఆ విధంగానే చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","మీ దగ్గర నివాసం ఉన్న పరదేశిగాని, మీ తరతరాల్లో మీ మధ్య ఉన్నవాడు ఎవడైనా గాని యెహోవాకు ఇష్టమైన సువాసన కలిగిన దహనబలి అర్పించాలని అనుకున్నప్పుడు, మీరు చేసినట్టే అతడు కూడా చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","సమాజానికి, అంటే మీకూ, మీలో నివాసం ఉన్న పరదేశికీ ఒకే కట్టడ. అది మీ తరతరాలకు ఉండే శాశ్వతమైన కట్టుబాటు. యెహోవా సన్నిధిలో మీరున్నట్టే పరదేశి కూడా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","మీకూ, మీ దగ్గర నివాసం ఉండే పరదేశికీ ఒకే ఏర్పాటు, ఒకే న్యాయవిధి ఉండాలి’” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","యెహోవా మోషేతో మళ్ళీ మాట్లాడుతూ “ఇశ్రాయేలీయులతో ఇలా చెప్పు, ");
INSERT INTO tel2017_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","నేను మిమ్మల్ని తీసుకెళ్తున్న దేశంలో మీరు ప్రవేశించిన తరువాత ");
INSERT INTO tel2017_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","మీరు ఆ దేశపు ఆహారం తిన్నప్పుడు యెహోవాకు ప్రతిష్ట అర్పణ అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","మీరు మీ మొదటి పిండిముద్ద రొట్టెను ప్రతిష్టార్పణగా అర్పించాలి. కళ్లపు అర్పణలా దాన్ని అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","మీ తరతరాలకు మీ మొదటి పిండిముద్దలోనుంచి ప్రతిష్ఠార్పణను యెహోవాకు అర్పించాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“యెహోవా మోషేతో చెప్పిన ఈ ఆజ్ఞలన్నిట్లో, అంటే ");
INSERT INTO tel2017_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","యెహోవా ఆజ్ఞాపించిన రోజు మొదలుకుని ఆ తరువాత మీ తరతరాలకు యెహోవా మోషే ద్వారా మీకు ఆజ్ఞాపించిన వాటిలో పొరపాటున దేనినైనా మీరు చెయ్యనప్పుడు, అది సమాజానికి తెలియజేస్తే, ");
INSERT INTO tel2017_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","సమాజమంతా యెహోవాకు ఇష్టమైన సువాసనగా ఉండడానికి దహనబలిగా ఒక లేత దున్నపోతును ఆజ్ఞప్రకారం దాని నైవేద్యాన్ని, దాని పానీయార్పణను, పాపపరిహారార్థబలిగా ఒక మేకపిల్లను సిద్ధం చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","యాజకుడు ఇశ్రాయేలీయుల సర్వసమాజం కోసం ప్రాయశ్చిత్తం చెయ్యాలి. తెలియక దాన్ని చేశారు గనక క్షమాపణ దొరుకుతుంది. వారు పొరపాటున చేసిన పాపాలను బట్టి తమ అర్పణ, అంటే యెహోవాకు చెందవలసిన దహనబలి, పాపపరిహారార్థబలి యెహోవా సన్నిధికి తీసుకు రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","అప్పుడు ఇశ్రాయేలీయుల సర్వసమాజానికి గాని, వారి మధ్య నివాసం ఉంటున్న పరదేశికి గాని, క్షమాపణ దొరుకుతుంది. ఎందుకంటే, ప్రజలందరూ తెలియక దాన్ని చెయ్యడం జరిగింది. ");
INSERT INTO tel2017_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ఒకడు పొరపాటున పాపం చేస్తే, అతడు పాపపరిహారార్థ బలిగా ఒక సంవత్సరం వయస్సు ఉన్న ఆడమేక పిల్లను తీసుకురావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","పొరపాటుగా యెహోవా సన్నిధిలో దాన్ని చేశాడు గనక తెలియక పాపం చేసిన అతని కోసం యాజకుడు ప్రాయశ్చిత్తం చేస్తాడు. అతని కోసం ప్రాయశ్చిత్తం చేయడం వల్ల అతడు క్షమాపణ పొందుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ఇశ్రాయేలీయుల్లో పుట్టినవాడు గాని వారి మధ్య నివాసం ఉంటున్న పరదేశి గాని పొరపాటున ఎవరైనా పాపం చేస్తే, అతనికీ, మీకూ ఒక్కటే చట్టం ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","కాని, దేశంలో పుట్టినవాడు గాని పరదేశి గాని ఎవరైనా కావాలని పాపం చేస్తే, ");
INSERT INTO tel2017_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","అతడు యెహోవాను తృణీకరించిన వాడు గనక అలాంటి వాడు కచ్చితంగా ప్రజల్లో ఉండకుండాా కొట్టివేయాలి. అతని పాపం అతని మీద ఉంటుంది. అతడు యెహోవా మాటను అలక్ష్యం చేసి ఆయన ఆజ్ఞను అతిక్రమించిన కారణంగా అతడు తన ప్రజల్లో లేకుండా పోతాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ఇశ్రాయేలీయులు అరణ్యంలో ఉన్నప్పుడు ఒకడు విశ్రాంతి దినాన కట్టెలు ఏరడం గమనించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","అతడు కట్టెలు ఏరడం చూసిన వారు మోషే అహారోనుల దగ్గరికి, సమాజం ఎదుటికి అతన్ని తీసుకొచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","అతని పట్ల ఏం చెయ్యాలో అది వాళ్లకు తెలియ లేదు గనక అతన్ని అదుపులోకి తీసుకుని ఉంచారు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","తరువాత యెహోవా మోషేతో “ఆ వ్యక్తికి మరణ శిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","సర్వసమాజం శిబిరం బయట అతన్ని రాళ్లతో కొట్టి చంపాలి” అన్నాడు. కాబట్టి యెహోవా మోషేకు ఆజ్ఞాపించినట్టు సర్వ సమాజం శిబిరం బయటకు అతన్ని తీసుకెళ్ళి, రాళ్లతో కొట్టి చంపారు. ");
INSERT INTO tel2017_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ఇంకా యెహోవా మోషేతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“నువ్వు ఇశ్రాయేలీయులతో ఇలా చెప్పు, వారు తమ తరతరాలకు తమ బట్టల అంచులకు కుచ్చులు చేసుకుని, అంచుల కుచ్చుల మీద నీలిరంగు దారం తగిలించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","మీరు నా ఆజ్ఞలన్నిటినీ జ్ఞాపకం చేసుకుని, మీ దేవునికి ప్రతిష్ఠితులై ఉండేలా ఇదివరకు కోరిన వాటిని బట్టి, చూసిన వాటిని బట్టి ఆధ్యాత్మిక వ్యభిచారం చెయ్యకుండా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","మీరు నా కోసం ప్రత్యేకపరచిన వారు గనక, మీరు పవిత్రులుగా ఉండేందుకు యెహోవా ఆజ్ఞలన్నిటినీ జ్ఞాపకం చేసుకుని వాటిని అనుసరించడానికి జాగ్రత్త తీసుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","నేను మీకు దేవుడుగా ఉండాలని ఐగుప్తు దేశంలో నుంచి మిమ్మల్ని రప్పించిన మీ దేవుడనైన యెహోవాను. మీ దేవుడనైన యెహోవాను నేనే.” ");
INSERT INTO tel2017_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","లేవీ మునిమనవడు, కహాతు మనవడు, ఇస్హారు కొడుకు కోరహు, రూబేనీయుల్లో ఏలీయాబు కొడుకులు దాతాను, అబీరాము, పేలెతు కొడుకు ఓనుతో కలిసి ");
INSERT INTO tel2017_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ఇశ్రాయేలీయుల్లో పేరు పొందిన 250 మంది నాయకులతో సహా మోషే మీద తిరుగుబాటుగా లేచి ");
INSERT INTO tel2017_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","మోషే అహరోనులకు విరోధంగా సమకూడారు. “మీరు చాలా ఎక్కువ అధికారం చలాయిస్తున్నారు. ఈ సమాజంలో ఉన్న వారిందరూ పవిత్రులే. అందరూ యెహోవా కోసం ప్రత్యేకించిన వారే. యెహోవా వారి మధ్య ఉన్నాడు. యెహోవా సమాజం మీద మిమ్మల్ని మీరు ఎందుకు గొప్ప చేసుకుంటున్నారు?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","మోషే ఆ మాట విన్నప్పుడు, సాగిలపడ్డాడు. ఆ తరువాత అతడు కోరహుతో, అతని గుంపుతో, ");
INSERT INTO tel2017_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","“ఆయన వారు ఎవరో యెహోవా కోసం ప్రత్యేకించిన వారెవరో రేపు యెహోవా తెలియజేసి అతన్ని తన సన్నిధికి రానిస్తాడు. ఆయన తాను ఏర్పరచుకున్నవాణ్ణి తన దగ్గరికి చేర్చుకుంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","కోరహు, నువ్వూ నీ గుంపూ ఇలా చెయ్యండి, మీరు ధూపార్తులు తీసుకుని వాటిలో నిప్పు ఉంచి రేపు యెహోవా సన్నిధిలో వాటి మీద ధూపసాంబ్రాణి వెయ్యండి. ");
INSERT INTO tel2017_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","అప్పుడు యెహోవా ఎవరిని ఏర్పాటు చేసుకుంటాడో అతనే పవిత్రుడు. లేవీ కొడుకులారా, మీరు చాలా దూరం వెళ్ళారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ఇంకా మోషే కోరహుతో “లేవీ కొడుకులారా వినండి, ");
INSERT INTO tel2017_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","తన మందిరసేవ చెయ్యడానికి యెహోవా మిమ్మల్ని తన దగ్గరికి చేర్చుకోవడం చిన్న విషయమా? మీరు సమాజం ఎదుట నిలబడి వారు చెయ్యవలసిన సేవ చేసేలా ఇశ్రాయేలీయుల దేవుడు ఇశ్రాయేలీయుల సమాజంలోనుంచి మిమ్మల్ని ప్రత్యేక పరచుకోవడం మీకు తక్కువగా కనిపిస్తున్నదా? ");
INSERT INTO tel2017_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ఆయన నిన్నూ, నీతో లేవీయులైన నీ గోత్రం వారిందర్నీ చేర్చుకున్నాడు గదా. ఇప్పుడు మీరు యాజకత్వం కూడా కోరుతున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","దీని కోసం నువ్వూ, నీ గుంపూ యెహోవాకు విరోధంగా పోగయ్యారు. మీరు అహరోనును ఎందుకు విమర్శిస్తున్నారు? అతడు కేవలం యెహోవాకు లోబడినవాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","మోషే అప్పుడు ఏలీయాబు కొడుకులు దాతాను అబీరాములను పిలిపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","కాని వారు “మేము రాము, ఈ అరణ్యంలో మమ్మల్ని చంపాలని పాలు తేనెలు ప్రవహించే దేశంలో నుంచి మమ్మల్ని తీసుకు రావడం చాలదనట్టు, మామీద ప్రభుత్వం చెయ్యడానికి నీకు అధికారం కావాలా? ");
INSERT INTO tel2017_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","అంతేకాదు, నువ్వు పాలు తేనెలు ప్రవహించే దేశం లోకి మమ్మల్ని తీసుకు రాలేదు. పొలాలు, ద్రాక్షతోటలు ఉన్న స్వాస్థ్యం మాకివ్వలేదు. మమ్మల్ని శుష్క ప్రియాలతో గుడ్డివారుగా చేస్తావా? మేము రాము” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","అందుకు మోషే పట్టరాని కోపంతో, యెహోవాకు చెప్తూ “నువ్వు వారి నైవేద్యాన్ని గుర్తించ వద్దు. ఒక్క గాడిదనైనా నేను వారి దగ్గర తీసుకోలేదు. వారిలో ఎవరికీ నేను హాని చెయ్యలేదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","అప్పుడు మోషే కోరహుతో “నువ్వూ, నీ గుంపూ, అంటే నువ్వూ, నీ వారూ, అహరోను, రేపు యెహోవా సన్నిధిలో నిలబడాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","మీలో ప్రతివాడూ తన ధూపార్తిని తీసుకుని వాటి మీద ధూప సాంబ్రాణి వేసి, ఒక్కొక్కడు తన ధూపార్తిని పట్టుకుని 250 ధూపార్తులను యెహోవా సన్నిధికి తేవాలి. నువ్వూ, అహరోను ఒక్కొక్కడు తన ధూపార్తిని తేవాలి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","కాబట్టి వారిల్లో ప్రతివాడూ తన ధూపార్తిని తీసుకుని వాటిలో నిప్పు ఉంచి వాటి మీద ధూప సాంబ్రాణి వేసినప్పుడు, వారూ, మోషే అహరోనులూ సన్నిధి గుడారం ద్వారం దగ్గర నిలబడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","కోరహు సన్నిధి గుడారం ద్వారం దగ్గరికి తన సమాజాన్ని వాళ్లకు విరోధంగా పోగు చేసినప్పుడు, యెహోవా మహిమ సమాజమంతటికీ కనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","అప్పుడు యెహోవా “మీరు ఈ సమాజంలోనుంచి అవతలికి వెళ్ళండి. ");
INSERT INTO tel2017_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","తక్షణమే నేను వారిని కాల్చేస్తాను” అని మోషే అహరోనులతో చెప్పినప్పుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","వారు సాగిలపడి “దేవా, సమస్త మానవాళి ఆత్మలకు దేవా, ఈ ఒక్కడు పాపం చేసినందుకు ఈ సమాజం అంతటి మీద నువ్వు కోపం చూపిస్తావా?” అని యెహోవాను వేడుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","అప్పుడు యెహోవా మోషేకు జవాబిస్తూ, ");
INSERT INTO tel2017_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“సమాజమంతటితో చెప్పు, కోరహు, దాతాను, అబీరాముల గుడారాల చుట్టుపట్ల నుంచి వెళ్ళి పొండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","అప్పుడు మోషే లేచి, దాతాను అబీరాముల దగ్గరికి వెళ్ళినప్పుడు ఇశ్రాయేలీయుల పెద్దలు అతని వెంట వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","అతడు “ఈ దుష్టుల గుడారాల దగ్గర నుంచి వెళ్ళి పొండి. మీరు వారి పాపాలన్నిట్లో పాలివారై నాశనం కాకుండా ఉండేలా వాళ్లకు కలిగినది ఏదీ ముట్టుకోకండి” అని ఆ సమాజంతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","కాబట్టి వారు కోరహు, దాతాను, అబీరాముల గుడారాల దగ్గర నుంచి ఇటు అటు లేచి వెళ్ళిపోయారు. దాతాను, అబీరాము, వారి భార్యలు, వారి కొడుకులు, వారి పసిపిల్లలు తమ గుడారాల ద్వారం దగ్గర నిలబడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","అప్పుడు మోషే “ఈ కార్యాలన్నీ చెయ్యడానికి యెహోవా నన్ను పంపాడనీ, నా అంతట నేనే వాటిని చెయ్యలేదనీ దీనివల్ల మీరు తెలుసుకుంటారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","మనుషులందరికీ వచ్చే చావు లాంటి చావు వీళ్ళకు వస్తే ప్రతి మనిషికీ కలిగేదే వీళ్ళకూ కలిగితే, యెహోవా నన్ను పంపలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","కాని, యెహోవా ఒక అద్భుతం చేసి, వారు ప్రాణాలతోనే పాతాళంలోకి కుంగిపోయేలా భూమి తన నోరు తెరచి వారిని, వాళ్లకు కలిగిన సమస్తాన్నీ మింగేస్తే, వారు యెహోవాను అలక్ష్యం చేశారని మీకు తెలుస్తుంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","మోషే ఆ మాటలన్నీ చెప్పిన వెంటనే వారి కింద ఉన్న నేల తెరుచుకుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","భూమి తన నోరు తెరిచి వారిని, వారి కుటుంబాలను, కోరహు సంబంధులందర్నీ, వాళ్లకు చెందిన వాటన్నిటినీ మింగేసింది. ");
INSERT INTO tel2017_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","వారూ, వారి సంబంధులందరూ ప్రాణాలతో పాతాళంలోకి కుంగిపోయారు. భూమి వారిని మింగేసింది. వారు సమాజంలో ఉండకుండాా నాశనం అయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","వారి చుట్టూ ఉన్న ఇశ్రాయేలీయులందరూ వారి కేకలు విని “భూమి మనలను కూడా మింగేస్తుందేమో” అనుకుంటూ పారిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","అప్పుడు యెహోవా దగ్గర నుంచి అగ్ని బయలుదేరి, ధూపార్పణ తెచ్చిన ఆ 250 మందిని కాల్చేసింది. ");
INSERT INTO tel2017_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","అప్పుడు యెహోవా మోషేతో “నువ్వు యాజకుడైన అహరోను కొడుకు ఎలియాజరుతో చెప్పు, ఆ అగ్ని మధ్యలోనుంచి ఆ ధూపార్తులను ఎత్తు, అవి ప్రతిష్ఠితమైనవి. ");
INSERT INTO tel2017_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","ఆ నిప్పుని దూరంగా చల్లు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","పాపం చేసి తమ ప్రాణాలకు ముప్పు తెచ్చుకున్న వీళ్ళ ధూపార్తులను తీసుకుని బలిపీఠానికి కప్పుగా వెడల్పైన రేకులు చెయ్యాలి. వారు యెహోవా సన్నిధికి వాటిని తెచ్చిన కారణంగా అవి ప్రతిష్ఠితం అయ్యాయి. అవి ఇశ్రాయేలీయులకు గుర్తుగా ఉంటాయి.” ");
INSERT INTO tel2017_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","అహరోను సంతాన సంబంధి కాని అన్యుడు ఎవరూ యెహోవా సన్నిధిలో ధూపం అర్పించడానికి వచ్చి, ");
INSERT INTO tel2017_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","కోరహులా, అతని గుంపులా అయపోకుండా ఇశ్రాయేలీయులకు జ్ఞాపికగా ఉండడానికి కాలిపోయినవారు అర్పించిన ఇత్తడి ధూపార్తులను యాజకుడైన ఎలియాజరు తీసి యెహోవా మోషే ద్వారా తనతో చెప్పినట్టు వాటితో బలిపీఠానికి కప్పుగా వెడల్పైన రేకులు చెయ్యించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","తరువాత రోజు ఇశ్రాయేలీయుల సమాజమంతా మోషే అహరోనులను విమర్శిస్తూ “మీరు యెహోవా ప్రజలను చంపారు” అని చెప్పి, ");
INSERT INTO tel2017_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","సమాజమంతా మోషే అహరోనులకు విరోధంగా సమకూడారు. వారు సన్నిధి గుడారం వైపు తిరిగి చూసినప్పుడు, ఆ మేఘం దాన్ని కమ్మింది. యెహోవా మహిమ కూడా కనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","మోషే అహరోనులు సన్నిధి గుడారం ఎదుటికి వచ్చినప్పుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","యెహోవా మోషేతో “మీరు ఈ సమాజం మధ్య నుంచి వెళ్ళి పొండి, ");
INSERT INTO tel2017_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","తక్షణమే నేను వారిని నాశనం చేస్తాను” అని చెప్పినప్పుడు, వారు సాగిలపడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","అప్పుడు మోషే “నువ్వు ధూపార్తిని తీసుకుని బలిపీఠపు నిప్పులతో నింపి ధూపం వేసి త్వరగా సమాజం దగ్గరికి వెళ్లి వారి కోసం ప్రాయశ్చిత్తం చెయ్యి, ఎందుకంటే, యెహోవా సన్నిధిలోనుంచి కోపం బయలుదేరింది. తెగులు మొదలయ్యింది” అని అహరోనుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","మోషే చెప్పినట్టు అహరోను వాటిని తీసుకుని సమాజం మధ్యకు పరుగెత్తి వెళ్ళినప్పుడు ప్రజల్లో తెగులు మొదలై పాకిపోతూ ఉంది. కాబట్టి అతడు ధూపం వేసి ఆ ప్రజల కోసం ప్రాయశ్చిత్తం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","అతడు చనిపోయిన వారికీ, బతికున్న వారికీ మధ్య నిలబడినప్పుడు తెగులు ఆగింది. ");
INSERT INTO tel2017_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","కోరహు తిరుగుబాటులో చనిపోయిన వారు కాకుండా 14, 700 మంది ఆ తెగులు వల్ల చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ఆ తెగులు ఆగినప్పుడు అహరోను సన్నిధి గుడారపు ద్వారం దగ్గర ఉన్న మోషే దగ్గరికి తిరిగి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","యెహోవా మోషేతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“నువ్వు ఇశ్రాయేలీయులతో మాట్లాడు, వారి దగ్గర ఒక్కొక్క పితరుల వంశానికి ఒక్కొక్క చేతికర్ర చొప్పున, అంటే ప్రతి వంశానికి చెందిన వారి నాయకుని దగ్గరనుంచి తమ తమ వంశాల ప్రకారం 12 చేతికర్రలు తీసుకుని ఎవరి చేతికర్ర మీద వారి పేరు రాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","లేవీ చేతికర్ర మీద అహరోను పేరు రాయాలి. ఎందుకంటే ఒక్కొక్క పితరుల వంశాల నాయకునికి ఒక్క చేతికర్రే ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","నేను మిమ్మల్ని కలుసుకునే సన్నిధి గుడారంలోని నిబంధన శాసనాల ముందు వాటిని ఉంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","అప్పుడు నేను ఎవరిని ఏర్పరచుకుంటానో, అతని కర్ర చిగురిస్తుంది. ఇశ్రాయేలీయులు మీకు విరోధంగా చేస్తున్న ఫిర్యాదులు నాకు వినిపించకుండా ఆపేస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","కాబట్టి మోషే ఇశ్రాయేలీయులతో చెప్పినప్పుడు వారి నాయకులందరూ తమ తమ పితరుల వంశాల్లో ఒక్కొక్క నాయకునికి ఒక్కొక్క కర్ర ప్రకారం 12 కర్రలు అతనికిచ్చారు. అహరోను కర్ర కూడా వారి కర్రల మధ్యలో ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","మోషే, వారి కర్రలను నిబంధన శాసనాల గుడారంలో యెహోవా సన్నిధిలో పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","తరువాత రోజు మోషే నిబంధన శాసనాల గుడారంలోకి వెళ్లి చూసినప్పుడు లేవీ వంశానికి చెందిన అహరోను కర్ర మొగ్గ తొడిగి ఉంది. అది మొగ్గలు తొడిగి, పూలు పూసి, పండిన బాదం కాయలు కాసింది. ");
INSERT INTO tel2017_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","మోషే యెహోవా సన్నిధిలోనుంచి ఆ కర్రలన్నీ ఇశ్రాయేలీయులందరి ఎదుటకు తెచ్చినప్పుడు వారు వాటిని చూసి ఒక్కొక్కరూ ఎవరి కర్ర వారు తీసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","అప్పుడు యెహోవా మోషేతో “అహరోను కర్రను నిబంధన శాసనాల ఎదుట శాశ్వతంగా ఉంచు. అలా చేస్తే, అది తిరుగుబాటు చేసిన వారి అపరాధానికి గుర్తుగానూ, నాకు విరోధంగా సణిగి ఎవ్వరూ చనిపోకుండా ఉండడానికీ వీలౌతుంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","అప్పుడు యెహోవా మోషేకు ఆజ్ఞాపించినట్టు, అతడు కచ్చితంగా అలాగే చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","అయితే ఇశ్రాయేలీయులు మోషేతో “మేము ఇక్కడ చనిపోతాం. మేమందరం నశించిపోతాం! ");
INSERT INTO tel2017_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","యెహోవా మందిరాన్ని సమీపించిన ప్రతిఒక్కరూ చనిపోతారు. మేమందరం చావాల్సిందేనా?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","యెహోవా అహరోనుతో “పవిత్ర స్థలంలో సేవలో జరిగే పాపాలకు నువ్వూ, నీ కొడుకులూ, నీ వంశం జవాబుదారులు. నువ్వూ, నీ కొడుకులూ మీ యాజకత్వపు పాపాలకు జవాబుదారులు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ఇంకా, నీ తండ్రి గోత్రం, అంటే లేవీ వంశస్తులైన నీ సహోదరులను నువ్వు దగ్గరికి తీసుకు రావాలి. నువ్వూ నీ కొడుకులూ నిబంధన శాసనాల గుడారం ఎదుట పరిచర్య చేస్తున్నప్పుడు వారు నీతో కలిసి నీకు సాయం చేస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","వారు నీకూ, గుడారం అంతటికీ సేవ చెయ్యాలి. కాని వారూ, మీరూ చనిపోకుండా ఉండాలంటే వారు పవిత్ర స్థలపు ఉపకరణాల దగ్గరకైనా, బలిపీఠం దగ్గరకైనా రాకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","వారు నీతో కలిసి సన్నిధి గుడారంలోని సేవంతటి విషయంలో శ్రద్ధ వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ఒక బయటి వాడు మీ దగ్గరికి రాకూడదు. ఇకముందు ఇశ్రాయేలీయుల మీదకి నా కోపం రాకుండా ఉండాలంటే మీరు పవిత్రస్థలం పట్ల, బలిపీఠం పట్ల బాధ్యత వహించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","చూడండి, ఇశ్రాయేలీయుల మధ్య నుంచి లేవీయులైన మీ సహోదరులను నేనే ఎంపిక చేసుకున్నాను. సన్నిధి గుడారపు సేవ చెయ్యడానికి వారిని యెహోవా కోసం మీకు ఒక బహుమానంగా ఇచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","కాని నువ్వూ, నీ కొడుకులు మాత్రమే బలిపీఠానికీ, అడ్డతెర లోపల ఉన్న వాటికీ సంబంధించిన పనులన్నిటి విషయంలో యాజకత్వం జరుపుతూ సేవ చెయ్యగలరు. కేవలం మీరు మాత్రమే ఈ బాధ్యతలు చేపట్టగలరు. ఈ యాజకత్వాన్ని మీకు ఒక బహుమానంగా ఇస్తున్నాను. వేరే ఎవరైనా దాన్ని సమీపిస్తే అతనికి మరణ శిక్ష విధించాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ఇంకా యెహోవా అహరోనుతో “చూడు, ఇశ్రాయేలీయులు నాకు తెచ్చే కానుకలు, పవిత్ర అర్పణల బాధ్యత నీకిచ్చాను. ఈ అర్పణల్లో నీకూ, నీ కొడుకులకూ శాశ్వతంగా భాగం దక్కుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","అతి పవిత్రమైన వాటిలో అగ్నిలో పూర్తిగా కాలనివి నీకు చెందుతాయి. వారి నైవేద్యాలన్నిట్లో, వారి పాప పరిహారార్థ బలులన్నిట్లో, వారి అపరాధ పరిహారార్థ బలులన్నిట్లో, వారు నాకు చెల్లించే పవిత్ర అర్పణలన్నీ నీకు, నీ కొడుకులకూ చెందుతాయి. మీరు వాటిని అతి పవిత్రమైనవిగా ఎంచి తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","మీలో ప్రతి మగవాడు ఈ అర్పణలు తినాలి. అవి నాకు ప్రత్యేకించిన అర్పణలుగా మీరు పరిగణించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","ఇంకా వారి దానాల్లో ప్రతిష్టించిందీ, ఇశ్రాయేలీయులు అల్లాడించే అర్పణలన్నీ నీకు చెందుతాయి. నీకూ, నీ కొడుకులకూ, నీ కూతుళ్ళకూ శాశ్వతమైన భాగంగా నేను మీకిచ్చాను. నీ ఇంట్లో ఆచారరీతిగా శుచిగా ఉన్నవారు ఈ అర్పణల్లో దేనినైనా తినొచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","వారు యెహోవాకు అర్పించే మొదటి ఫలాలు, అంటే, నూనెలో ప్రశస్తమైనది, ద్రాక్షారసం, ధాన్యాల్లో ప్రశస్తమైనవన్నీ నీకిచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","వారు తమ దేశపు పంటలన్నిట్లో యెహోవాకు తెచ్చే మొదటి ఫలాలు నీకు చెందుతాయి. నీ ఇంట్లో ఆచారరీతిగా శుచిగా ఉన్నవారు ఈ అర్పణల్లో దేనినైనా తినొచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ఇశ్రాయేలీయులు ప్రతిష్ట చేసిన ప్రతిదీ నీకు చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","మనుష్యుల్లోగాని, పశువుల్లోగాని, వారు యెహోవాకు అర్పించే ప్రాణులన్నిట్లో ప్రతి తొలిచూలు నీకు చెందుతుంది. అయితే, ప్రజలు తొలిచూలు మగబిడ్డను వెల చెల్లించి తిరిగి సంపాదించుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","అపవిత్ర పశువుల తొలిచూలు మగపిల్లను వెల చెల్లించి మళ్ళీ కొనుక్కోవాలి. వెల చెల్లించి మళ్ళీ కొనుక్కోవాల్సిన వాటిని పుట్టిన నెల రోజులకు నువ్వు నియమించిన వెల ప్రకారం పవిత్ర మందిరపు తూకంతో ఐదు తులాల వెండి ఇచ్చి వాటిని తిరిగి కొనుక్కోవాలి. అంటే 55 గ్రాములు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","కాని ఆవు తొలి చూలుని, గొర్రె తొలి చూలుని, మేక తొలి చూలుని విడిపించకూడదు. అవి ప్రతిష్ఠితమైనవి. వాటి రక్తం నువ్వు బలిపీఠం మీద పోసి, యెహోవాకు ఇష్టమైన సువాసన కలిగేలా వాటి కొవ్వును కాల్చాలి. కాని వాటి మాంసం నీకు చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","అల్లాడించే అర్పణగా ఉన్న బోర, కుడి జబ్బ, నీదైనట్టు అది కూడా నీకు చెందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ఇశ్రాయేలీయులు యెహోవాకు ప్రతిష్ఠించే పవిత్రమైన ప్రతిష్ఠార్పణలన్నీ నేను నీకూ, నీ కొడుకులకూ, నీ కూతుళ్ళకూ శాశ్వతమైన భాగంగా ఇచ్చాను. అది నీకూ, నీతో పాటు నీ సంతానానికీ యెహోవా సన్నిధిలో స్థిరమైన శాశ్వత నిబంధన” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ఇంకా యెహోవా అహరోనుతో “ప్రజల భూమిలో నీకు స్వాస్థ్యం ఉండకూడదు. వారి మధ్య నీకు ఆస్తిగాని భాగం గాని ఉండకూడదు. ఇశ్రాయేలీయుల మధ్య నీ భాగం, నీ స్వాస్థ్యం నేనే. ");
INSERT INTO tel2017_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","చూడు, లేవీయులు చేసే సేవకు, అంటే, సన్నిధి గుడారపు సేవకు ప్రతిగా నేను ఇశ్రాయేలీయుల పదోవంతును వాళ్లకు వారసత్వంగా ఇచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ఇశ్రాయేలీయులు ఇకముందు సన్నిధి గుడారం దగ్గరికి రాకూడదు. అలా చేస్తే ఆ పాపం కారణంగా చనిపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","అయితే లేవీయులు సన్నిధి గుడారం సేవ చేసి, వారి సేవలో పాపాలకు వారే జవాబుదారులుగా ఉంటారు. మీ ప్రజల తరతరాలకు ఇది శాశ్వతమైన శాసనం. ఇశ్రాయేలీయుల మధ్య వాళ్లకు ఏ స్వాస్థ్యం ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","అయితే ఇశ్రాయేలీయులు యెహోవాకు ప్రతిష్ఠార్పణగా అర్పించే పదోవంతు భాగాలు నేను లేవీయులకు స్వాస్థ్యంగా ఇచ్చాను. అందుచేత వారు ఇశ్రాయేలీయుల మధ్య స్వాస్థ్యం సంపాదించకూడదని వారితో చెప్పాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ఇంకా యెహోవా మోషేతో, ");
INSERT INTO tel2017_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“నువ్వు లేవీయులతో ఇలా చెప్పు, ‘నేను ఇశ్రాయేలీయుల ద్వారా మీకు స్వాస్థ్యంగా ఇప్పించిన పదోవంతు భాగాలు మీరు వారి దగ్గర తీసుకున్నప్పుడు మీరు దానిలో, అంటే ఆ పదోవంతు భాగంలో పదోవంతు భాగం యెహోవాకు ప్రతిష్ఠార్పణగా చెల్లించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","మీకు వచ్చే ప్రతిష్ఠార్పణను కళ్లపు పంటలా, ద్రాక్షల తొట్టి ఫలంలా ఎంచాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ఆ విధంగా మీరు ఇశ్రాయేలీయుల దగ్గర పొందిన మీ పదోవంతు భాగాలు అన్నిట్లోనుంచి మీరు ప్రతిష్ఠార్పణ యెహోవాకు చెల్లించాలి. దానిలోనుంచి మీరు యెహోవాకు ప్రతిష్ఠించే అర్పణ యాజకుడైన అహరోనుకు ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","మీరు పొందిన బహుమానాల్లో ప్రశస్తమైన వాటిలోనుంచి యెహోవాకు శ్రేష్ఠమైన అర్పణ ఇవ్వాలి.’ ");
INSERT INTO tel2017_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ఇంకా నువ్వు వారితో, మీరు పొందిన వాటిలో నుంచి ప్రశస్తభాగం అర్పించినప్పుడు, లేవీయులు దాన్ని కళ్ళం నుంచీ, ద్రాక్షగానుగ నుంచీ వచ్చిన ఫలంలా పరిగణించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","మీరూ, మీ కుటుంబాలూ ఏ స్థలంలోనైనా వాటిని తినొచ్చు. ఎందుకంటే సన్నిధి గుడారంలో మీరు చేసే సేవకు అది మీకు జీతం. ");
INSERT INTO tel2017_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","మీరు పొందిన వాటిలోనుంచి ప్రశస్తమైనవి యెహోవాకు అర్పించి ఉంటే, దాన్ని తిని, తాగినందుకు మీకు ఏ పాపశిక్ష ఉండదు. మీరు చనిపోకుండా ఉండాలంటే ఇశ్రాయేలీయుల ప్రతిష్ఠితమైన వాటిని అపవిత్రం చెయ్యకూడదని చెప్పు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","యెహోవా మోషే అహరోనులతో, ");
INSERT INTO tel2017_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“యెహోవా ఆజ్ఞాపించిన ధర్మశాస్త్ర విధి ఏదంటే, ఇశ్రాయేలీయులు కళంకం లేనిదీ, మచ్చ లేనిదీ, ఎప్పుడూ కాడి మోయ్యని ఎర్ర ఆవును నీ దగ్గరికి తీసుకురావాలని వారితో చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","మీరు యాజకుడైన ఎలియాజరుకు దాన్ని అప్పగించాలి. ఒకడు పాళెం బయటికి దాన్ని తోలుకెళ్ళి అతని ఎదుట దాన్ని వధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","యాజకుడైన ఎలియాజరు దాని రక్తం కొంచెం వేలితో తీసి, సన్నిధి గుడారం ఎదుట ఆ రక్తాన్ని ఏడుసార్లు చిమ్మాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","అతని కళ్ళ ఎదుట ఒకడు ఆ ఆవును కాల్చాలి. దాని చర్మం, మాంసం, రక్తం, పేడతో సహా కాల్చెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ఇంకా ఆ యాజకుడు దేవదారు కర్ర, హిస్సోపు, ఎర్రరంగు నూలు తీసుకుని, ఆ ఆవును కాలుస్తున్న మంటల్లో వాటిని వెయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","అప్పుడు ఆ యాజకుడు తన బట్టలు ఉతుకుకుని, నీళ్లతో తలస్నానం చేసిన తరువాత పాలెంలో ప్రవేశించి సాయంకాలం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","దాన్ని కాల్చినవాడు నీళ్లతో తన బట్టలు ఉతుకుకుని నీళ్లతో తలస్నానం చేసి సాయంకాలం వరకూ అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","ఇంకా శుద్ధుడైనవాడు ఒకడు ఆ ఆవు బూడిదను పోగు చేసి పాలెం బయట ఒక శుద్ధమైన స్థలంలో పెట్టాలి. ఆ బూడిదను ఇశ్రాయేలీయుల సమాజం కోసం భద్రం చెయ్యాలి. ఆ బూడిద పాపపరిహారార్ధ అర్పణ నుంచి వచ్చింది గనక, పాపం నుంచి శుద్ధీకరణ కోసం వారు ఆ బూడిదను నీళ్ళతో కలుపుతారు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ఆ ఆవు బూడిదను పోగు చేసిన వాడు తన బట్టలు ఉతుక్కుని, సాయంకాలం వరకూ అశుద్ధుడుగా ఉంటాడు. ఇది ఇశ్రాయేలీయులకూ, వారిల్లో నివాసం ఉంటున్న పరదేశులకూ శాశ్వతమైన శాసనం. ");
INSERT INTO tel2017_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","మానవ శవాన్ని ముట్టుకున్నవాడు ఏడు రోజులు అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","అతడు మూడో రోజు ఆ నీళ్ళతో పాపశుద్ధి చేసుకుని, ఏడో రోజు శుద్ధుడౌతాడు. అయితే అతడు మూడో రోజు పాపశుద్ధి చేసుకోకపోతే ఏడో రోజు శుద్ధుడు కాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","మనిషి శవాన్ని ముట్టుకున్నవాడు ఆ విధంగా పాపశుద్ధి చేసుకోకపోతే అతడు యెహోవా మందిరాన్ని అపవిత్రం చేసినవాడౌతాడు. పాపపరిహార జలం అతని మీద చల్ల లేదు గనక ఆ వ్యక్తిని ఇశ్రాయేలీయుల్లో లేకుండా చెయ్యాలి. అతడు అశుద్ధుడుగానే ఉండిపోతాడు. అతని అశుద్ధత అతని మీద ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","ఎవరైనా ఒక గుడారంలో చనిపోతే, దాని గురించిన చట్టం ఇది. ఆ గుడారంలో ప్రవేశించే ప్రతివాడూ, ఆ గుడారంలో ఉన్నవారూ ఏడు రోజులు అశుద్ధంగా ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","మూత వేయకుండా తెరచి ఉన్న పాత్రలన్నీ అశుద్ధం ఔతాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","గుడారం బయట కత్తితో నరికిన వాడినైనా, శవాన్నైనా, మనిషి ఎముకనైనా, సమాధినైనా ముట్టుకున్నవాడు ఏడు రోజులు అశుద్ధుడుగా ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","అశుద్ధుడైన వ్యక్తి కోసం, పాప పరిహారార్థమైన కాలిన బూడిద కొంచెం తీసుకుని ఒక కూజాలో ఉన్న మంచినీళ్ళతో కలపాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","తరువాత ఒక శుద్ధుడు హిస్సోపు తీసుకుని ఆ నీళ్ళల్లో ముంచి, ఆ గుడారం మీద, దానిలోని ఉపకరణాలు అన్నిటి మీదా, అక్కడున్న మనుషుల మీదా చల్లాలి. ఎముకనుగాని, కత్తితో నరికిన వాణ్ణి గాని, శవాన్నిగాని, సమాధినిగాని ముట్టుకున్న వాడి మీద కూడా దాన్ని చల్లాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","మూడో రోజు, ఏడో రోజూ, శుద్ధుడు అశుద్ధుని మీద దాన్ని చల్లాలి. ఏడో రోజు అతడు పాపశుద్ధి చేసుకుని, తన బట్టలు ఉతుక్కుని నీళ్లతో స్నానం చేసి, సాయంకాలానికి శుద్ధుడౌతాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ఎవరైనా అశుద్ధుడుగానే ఉండి పాపశుద్ధి చేసుకోడానికి నిరాకరిస్తే, అతడు యెహోవా పరిశుద్ధ స్థలాన్ని అశుద్ధం చేశాడు గనక అలాంటి వాణ్ణి సమాజంలో లేకుండా చేయాలి. పాపపరిహార జలం అతని మీద చల్ల లేదు గనక అతడు అశుద్ధుడుగానే ఉంటాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ఈ పరిస్థితులకు సంబంధించిన శాశ్వతమైన శాసనం ఏదంటే-పాపపరిహార జలం చల్లేవాడు తన బట్టలు ఉతుక్కోవాలి. పాపపరిహార జలం ముట్టుకున్నవాడు సాయంకాలం వరకూ అశుద్ధుడుగా ఉంటాడు. అశుద్ధుడు ముట్టుకున్నదంతా అశుద్ధం ");
INSERT INTO tel2017_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","దాన్ని ముట్టుకున్న వారిందరూ సాయంకాలం వరకూ అశుద్ధులుగా ఉంటారు.” ");
INSERT INTO tel2017_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","మొదటి నెలలో ఇశ్రాయేలీయుల సమాజమంతా సీను అనే నిర్జన బీడు ప్రాంతానికి వెళ్ళారు. వారు కాదేషులో శిబిరం వేసుకున్నారు. అక్కడ మిర్యాము చనిపోయింది. ఆమెను అక్కడ పాతిపెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ఆ సమాజానికి నీళ్లు లేనందువల్ల వారు మోషే అహరోనులకు విరోధంగా పోగయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ప్రజలు మోషేను విమర్శిస్తూ “మా తోటి ఇశ్రాయేలీయులు యెహోవా ముంగిట్లో చనిపోయినప్పుడు మేము కూడా చనిపోతే బాగుండేది! ");
INSERT INTO tel2017_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","మేమూ మా పశువులూ చనిపోడానికి యెహోవా సమాజాన్ని ఈ నిర్జన బీడు ప్రాంతంలోకి ఎందుకు తీసుకొచ్చావు? ");
INSERT INTO tel2017_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ఈ భయంకరమైన ప్రాంతానికి మమ్మల్ని తీసుకు రావడానికి ఐగుప్తులోనుంచి మమ్మల్ని ఎందుకు రప్పించావు? ఈ ప్రాంతంలో గింజలు లేవు, అంజూరాలు లేవు, ద్రాక్షలు లేవు, దానిమ్మలు లేవు, తాగడానికి నీళ్ళే లేవు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","అప్పుడు మోషే అహరోనులు సమాజం ఎదుట నుంచి సన్నిధి గుడారపు ద్వారం లోకి వెళ్లి సాగిలపడినప్పుడు, యెహోవా మహిమ వాళ్లకు కనిపించింది. ");
INSERT INTO tel2017_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","అప్పుడు యెహోవా మోషేతో, ");
INSERT INTO tel2017_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“నువ్వు నీ కర్ర తీసుకుని, నువ్వూ, నీ సహోదరుడు అహరోను, ఈ సమాజం అంతట్నీటిని చేర్చి, వారి కళ్ళఎదుట ఆ బండతో మాట్లాడి, నీళ్ళు ప్రవహించమని దానికి ఆజ్ఞాపించు. నువ్వు వారి కోసం బండలోనుంచి నీళ్ళు రప్పించి, ఈ సమాజం, వారి పశువులూ తాగడానికి ఇవ్వాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","యెహోవా అతనికి ఆజ్ఞాపించినట్టు, మోషే ఆయన సన్నిధిలోనుంచి ఆ కర్ర తీసుకెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","తరువాత మోషే అహరోనులు ఆ బండ ఎదుట సమాజాన్ని సమకూర్చినప్పుడు అతడు వారితో “తిరుగుబాటు జనాంగమా, వినండి. మేము ఈ బండలోనుంచి మీకోసం నీళ్ళు రప్పించాలా?” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","అప్పుడు మోషే తన చెయ్యెత్తి రెండుసార్లు తన కర్రతో ఆ బండను కొట్టినప్పుడు నీళ్లు సమృద్ధిగా ప్రవహించాయి. ఆ సమాజం, పశువులూ తాగాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","అప్పుడు యెహోవా మోషే అహరోనులతో “మీరు ఇశ్రాయేలీయుల దృష్టిలో నన్ను నమ్మలేదు, నా పవిత్రత నిలబెట్టలేదు గనక, నేను ఈ సమాజానికి ఇచ్చిన దేశంలోకి మీరు వారిని తీసుకెళ్లలేరు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ఈ నీళ్ళ ప్రాంతానికి మెరీబా అని పేరు. ఎందుకంటే ఇశ్రాయేలీయులు యెహోవాతో వాదించినప్పుడు ఆయన వారి మధ్య తన పవిత్రత చూపించుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","మోషే కాదేషు నుంచి ఎదోము రాజు దగ్గరికి రాయబారులను పంపించి “నీ సహోదరుడు ఇశ్రాయేలు అడుగుతున్నది ఏమంటే, మాకొచ్చిన కష్టమంతా నీకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","మా పితరులు ఐగుప్తుకు వెళ్ళారు. మేము చాలా రోజులు ఐగుప్తులో ఉన్నాం. ఐగుప్తీయులు మమ్మల్ని, మా పితరులను బాధల పాలు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","మేము యెహోవాకు మొర్రపెట్టినప్పుడు ఆయన మా మొర విని, ఒక దూతను పంపించి ఐగుప్తులోనుంచి మమ్మల్ని రప్పించాడు. చూడు, మేము నీ సరిహద్దుల చివర ఉన్న కాదేషు పట్టణంలో ఉన్నాం. ");
INSERT INTO tel2017_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","మమ్మల్ని నీ దేశం గుండా దాటి వెళ్లనివ్వు. పొలాల్లోనుంచైనా, ద్రాక్షతోటల్లోనుంచైనా మేము వెళ్ళం. బావుల్లో నీళ్లు తాగం. రాజ మార్గంలో నడిచి వెళ్ళిపోతాం. నీ సరిహద్దులు దాటే వరకూ కుడివైపుకైనా. ఎడమవైపుకైనా తిరుగకుండా వెళ్ళిపోతాం” అని చెప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","కాని ఎదోము రాజు “నువ్వు నా దేశంలోగుండా వెళ్లకూడదు. అలా వెళ్తే, నేను ఖడ్గంతో నీ మీద దాడి చేస్తాను” అని జవాబిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","అప్పుడు ఇశ్రాయేలీయులు అతనితో “మేము రాజమార్గంలోనే వెళ్తాం. మేము గాని, మా పశువులుగాని నీ నీళ్లు తాగితే, దాని ఖర్చు చెల్లిస్తాం. కేవలం మమ్మల్ని కాలినడకతో వెళ్లనివ్వు అంతే” అన్నారు. అప్పుడు అతడు “నువ్వు రాకూడదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","అప్పుడు ఎదోము రాజు అనేకమంది సైన్యంతో, మహా బలంతో బయలుదేరి, వారి మీదకు వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ఎదోము రాజు ఇశ్రాయేలును తన సరిహద్దుల్లో గుండా దాటి వెళ్ళడానికి అనుమతించలేదు గనక ఇశ్రాయేలీయులు అతని దగ్గరనుంచి తిరిగి వెళ్ళిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","అప్పుడు ఇశ్రాయేలీయుల సమాజమంతా కాదేషులోనుంచి ప్రయాణం చేసి హోరు కొండకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","యెహోవా ఎదోము పొలిమేరల దగ్గరున్న హోరు కొండ దగ్గర మోషే అహరోనులతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“మీరిద్దరూ మెరీబా నీళ్ళ దగ్గర నా మాటలకు ఎదురు తిరిగారు గనక నేను ఇశ్రాయేలు ప్రజలకు ఇచ్చిన దేశంలో అహరోను ప్రవేశించకుండా, తన పితరులతో చేరిపోతాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","నువ్వు అహరోను, అతని కొడుకు ఎలియాజరును తీసుకుని హోరు కొండెక్కి, ");
INSERT INTO tel2017_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","అహరోను వస్త్రాలు తీసి అతని కొడుకు ఎలియాజరుకు తొడిగించు. అహరోను తన పితరులతో చేరి అక్కడ చనిపోతాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","యెహోవా ఆజ్ఞాపించినట్టు మోషే చేశాడు. సమాజమంతా చూస్తూ ఉన్నప్పుడు వారు హోరు కొండ ఎక్కారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","మోషే అహరోను వస్త్రాలు తీసి, అతని కొడుకు ఎలియాజరుకు తొడిగించాడు. అహరోను కొండశిఖరం మీద చనిపోయాడు. తరువాత మోషే, ఎలియాజరు ఆ కొండ దిగి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","అహరోను చనిపోయాడని సమాజమంతా గ్రహించినప్పుడు, ఇశ్రాయేలీయుల కుటుంబాలన్నీ అహరోను కోసం ముప్ఫై రోజులు శోకించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ఇశ్రాయేలీయులు అతారీం మార్గంలో వస్తున్నారని దక్షిణం వైపు నివాసం ఉన్న కనానీయుడైన అరాదు రాజు విని, అతడు ఇశ్రాయేలీయులతో యుద్ధం చేసి వారిల్లో కొంతమందిని బందీలుగా పట్టుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ఇశ్రాయేలీయులు యెహోవాకు మొక్కుకుని “నువ్వు మాకు ఈ జనం మీద జయం ఇస్తే, మేము నీ పేరట వారి పట్టణాలు పూర్తిగా నాశనం చేస్తాం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","యెహోవా ఇశ్రాయేలీయుల స్వరం విని, ఆ కనానీయుల మీద వాళ్లకు జయం ఇచ్చాడు. అప్పుడు వారు ఆ కనానీయులను, వారి పట్టణాలను పూర్తిగా నాశనం చేశారు. ఆ చోటికి “హోర్మా” అని పేరు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ఆ తరువాత వారు ఎదోము చుట్టూ తిరిగి వెళ్లాలని, హోరు కొండనుంచి ఎర్ర సముద్రం దారిలో ప్రయాణం చేశారు. ఆ ప్రయాణంలో అలసటతో ప్రజలు సహనం కోల్పోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","అప్పుడు ప్రజలు దేవునికి, మోషేకి విరోధంగా మాట్లాడుతూ “ఈ నిర్జన బీడు ప్రాంతంలో చావడానికి ఐగుప్తులోనుంచి మీరు మమ్మల్ని ఎందుకు రప్పించారు? ఇక్కడ ఆహారం లేదు, నీళ్లు లేవు, ఈ నికృష్టమైన భోజనం మాకు అసహ్యం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","అప్పుడు యెహోవా ప్రజల్లోకి విషసర్పాలు పంపించాడు. అవి ప్రజలను కాటువేసినప్పుడు ఇశ్రాయేలీయుల్లో చాలామంది చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","కాబట్టి ప్రజలు మోషే దగ్గరికి వచ్చి “మేము యెహోవాకు, నీకు విరోధంగా మాట్లాడి పాపం చేశాం. యెహోవా మా మధ్యనుంచి ఈ సర్పాలు తొలగించేలా ఆయనకు ప్రార్ధించండి” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","మోషే ప్రజల కోసం ప్రార్థన చేసినప్పుడు యెహోవా “పాము ఆకారం చేయించి స్థంభం మీద పెట్టు. అప్పుడు పాము కాటేసిన ప్రతి వాడు దానివైపు చూసి బతుకుతాడు” అని మోషేకు చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","కాబట్టి మోషే, ఇత్తడి పాము ఒకటి చేయించి, స్థంభం మీద దాన్ని పెట్టాడు. అప్పుడు పాము కాటు తిన్న ప్రతివాడూ ఆ ఇత్తడి పాము వైపు చూసినప్పుడు అతడు బతికాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","తరువాత ఇశ్రాయేలీయులు ప్రయాణం చేసి ఓబోతులో శిబిరం వేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ఓబోతులోనుంచి వారు ప్రయాణం చేసి తూర్పు వైపు, అంటే మోయాబుకు ఎదురుగా ఉన్న బంజరు భూమి ఈయ్యె అబారీము దగ్గర శిబిరం వేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","అక్కడనుంచి వారు ప్రయాణం చేసి, జెరెదు లోయలో శిబిరం వేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","అక్కడనుంచి వారు ప్రయాణం చేసి బంజరు భూమిలో అర్నోను నది అవతల శిబిరం వేసుకున్నారు. ఆ నది అమోరీయుల దేశ సరిహద్దులనుంచి ప్రవహిస్తుంది. అర్నోను నది మోయాబుకు, అమోరీయులకు మధ్య ఉన్న మోయాబు సరిహద్దు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ఆ కారణంగా యెహోవా యుద్ధాల గ్రంథంలో “సుఫాలో ఉన్న వాహేబు, అర్నోను లోయలు, ఆరు అనే స్థలం వరకూ ఉన్న అర్నోను లోయలు, ");
INSERT INTO tel2017_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","మోయాబు సరిహద్దుకు దగ్గరగా ఉన్న పల్లపు లోయలు” అని రాసి ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","అక్కడనుంచి వారు బెయేరుకు వెళ్ళారు. అక్కడ ఉన్న బావి దగ్గర యెహోవా మోషేతో “ప్రజలను సమకూర్చు. నేను వాళ్లకు నీళ్ళు ఇస్తాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","అప్పుడు ఇశ్రాయేలీయులు ఈ పాట పాడారు. “బావీ, పైకి ఉబుకు! ఆ బావిని కీర్తించండి. నాయకులు దాన్ని తవ్వారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","వారు తమ అధికార దండంతో, చేతికర్రలతో ప్రజల నాయకులు దాన్ని తవ్వారు.” ");
INSERT INTO tel2017_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","వారు ఆ ఎడారిలోనుంచి మత్తానుకూ, మత్తాను నుంచి నహలీయేలుకూ, నహలీయేలు నుంచి బామోతుకూ, ");
INSERT INTO tel2017_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","మోయాబు దేశంలోని లోయలో ఉన్న బామోతు నుంచి ఎడారికి ఎదురుగా ఉన్న పిస్గా కొండ దగ్గరికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ఇశ్రాయేలీయులు అమోరీయుల రాజైన సీహోను దగ్గరికి రాయబారులను పంపించి “మమ్మల్ని నీ దేశం గుండా వెళ్లనివ్వు, ");
INSERT INTO tel2017_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","మేము పొలాల్లోకైనా, ద్రాక్షతోటల్లోకైనా వెళ్ళం. బావుల్లో నీళ్లు తాగం. మేము నీ సరిహద్దులు దాటే వరకూ రాజమార్గంలోనే నడిచి వెళ్తాం” అని అతనితో చెప్పించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","కాని, సీహోను ఇశ్రాయేలీయులను తన సరిహద్దుల గుండా వెళ్ళనివ్వ లేదు. ఇంకా సీహోను తన జనమంతా సమకూర్చుకుని ఇశ్రాయేలీయుల మీద దాడి చెయ్యడానికి ఎడారిలోకి వెళ్లి, యాహజుకు వచ్చి ఇశ్రాయేలీయులతో యుద్ధం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ఇశ్రాయేలీయులు అతన్ని కత్తితో హతం చేసి, అతని దేశం అర్నోను మొదలు యబ్బోకు వరకూ, అంటే అమ్మోనీయుల దేశం వరకూ స్వాధీనం చేసుకున్నారు. ఇప్పుడు అమ్మోనీయుల సరిహద్దు బలోపేతం అయ్యింది. ");
INSERT INTO tel2017_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ఇశ్రాయేలీయులు ఆ పట్టాణాలన్నీ స్వాధీనం చేసుకున్నారు. ఇశ్రాయేలీయులు అమోరీయుల పట్టాణాలన్నిట్లో, హెష్బోనులో, దాని పల్లెలన్నిట్లో శిబిరం వేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","హెష్బోను, అమోరీయుల రాజైన సీహోను పట్టణం. అతడు అంతకు మునుపు మోయాబు రాజుతో యుద్ధం చేసి అర్నోను వరకూ అతని దేశమంతా స్వాధీనం చేసుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","కాబట్టి సామెతలు పలికే వారు “హెష్బోనుకు రండి. సీహోను పట్టణం కట్టాలి, దాన్ని స్థాపించాలి, ");
INSERT INTO tel2017_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","హెష్బోను నుంచి అగ్ని బయలువెళ్ళింది, సీహోను పట్టణంనుంచి జ్వాలలు బయలువెళ్ళాయి, అది మోయాబుకు ఆనుకున్న ఆర్ దేశాన్ని కాల్చేసింది, అర్నోను కొండ ప్రదేశాలను కాల్చేసింది. ");
INSERT INTO tel2017_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","మోయాబూ, నీకు బాధ, కెమోషు ప్రజలారా, మీరు నశించారు. తన కొడుకులను పలాయనం అయ్యేలా, తన కూతుళ్ళను అమోరీయులరాజైన సీహోనుకు బందీలుగా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","కాని మేము సీహోనును జయించాం. హెష్బోను దీబోను వరకూ నాశనం అయ్యింది. నోఫహు వరకూ దాన్ని పాడు చేశాం. అగ్నితో మేదెబా వరకూ తగల బెట్టాం” అంటారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","కాబట్టి ఇశ్రాయేలీయులు అమోరీయుల దేశంలో నివాసం ఉండడం ఆరంభించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","అప్పుడు, యాజెరు దేశాన్ని సంచారం చేసి చూడడానికి మోషే మనుషులను పంపినప్పుడు వారు దాని గ్రామాలు స్వాధీనం చేసుకుని అక్కడున్న అమోరీయులను తోలివేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","వారు తిరిగి బాషాను మార్గంలో ముందుకు వెళ్లినప్పుడు బాషాను రాజైన ఓగు, అతని జనమంతా ఎద్రెయీలో యుద్ధం చెయ్యడానికి బయలుదేరారు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","యెహోవా మోషేతో “అతనికి భయపడొద్దు. నేను అతని మీద, అతని జనం మీద, అతని దేశం మీద నీకు విజయం ఇచ్చాను. నువ్వు హెష్బోనులో నివాసం ఉన్న అమోరీయుల రాజైన సీహోనుకు చేసినట్టు ఇతనికి కూడా చేస్తావు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","కాబట్టి వారు అతన్ని, అతని కొడుకులను, ఒక్కడు కూడా మిగలకుండా అతని జనం అంతటినీ హతం చేసి అతని దేశాన్ని స్వాధీనం చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","తరువాత ఇశ్రాయేలీయులు ప్రయాణం చేసి యెరికోకు ఎదురుగా యొర్దాను తీరంలో ఉన్న మోయాబు మైదానాల్లో శిబిరం వేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","సిప్పోరు కొడుకు బాలాకు ఇశ్రాయేలీయులు అమోరీయు పట్ల చేసిందంతా చూశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ప్రజలు ఎక్కువగా ఉన్న కారణంగా మోయాబీయులు వారిని చూసి చాలా కంగారుపడ్డారు. మోయాబీయులు ఇశ్రాయేలీయులను చూసి భయభ్రాంతులకు లోనయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","మోయాబీయులు మిద్యాను పెద్దలతో “ఒక ఎద్దు పొలంలో ఉన్న పచ్చిగడ్డి తినేసినట్టు ఈ జనసమూహహం ఇప్పుడు మన చుట్టూ ఉన్నదంతా తినేస్తారు” అన్నారు. ఆ కాలంలో సిప్పోరు కొడుకు బాలాకు మోయాబీయులకు రాజు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","కాబట్టి అతడు బెయోరు కొడుకు బిలామును పిలవడానికి అతని ప్రజల దేశంలో ఉన్న నది దగ్గర ఉన్న పెతోరుకు ఇలా కబురంపారు. “చూడు, ఒక జాతి ఐగుప్తులోనుంచి వచ్చింది. వారు ఈ ప్రదేశమంతా కమ్మి, ఇప్పుడు నాకు ఎదురు గుండా శిబిరం వేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","కాబట్టి నువ్వు దయచేసి వచ్చి నా కోసం ఈ జనాన్ని శపించు. వారు నాకంటే చాలా బలవంతులు. ఒకవేళ నేను వారి మీద దాడి చేసి వారిని ఈ ప్రదేశం నుంచి తరమగలుగుతానేమో. ఎందుకంటే నువ్వు దీవించినవాడికి దీవెన, శపించిన వాడికి శాపం కలుగుతాయని నాకు తెలుసు” అని అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","కాబట్టి మోయాబు పెద్దలు, మిద్యాను పెద్దలు భవిష్యవాణి చెప్పడానికి ఇచ్చే చెల్లింపు తీసుకుని బిలాము దగ్గరికి వచ్చి బాలాకు మాటలు అతనితో చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","అతడు వారితో “ఈ రాత్రి ఇక్కడే ఉండండి. యెహోవా నాకు చెప్పిన మాటలు నేను మళ్ళీ వచ్చి మీతో చెప్తాను” అన్నాడు. అప్పుడు మోయాబు నాయకులు ఆ రాత్రి బిలాము దగ్గర ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","దేవుడు బిలాము దగ్గరికి వచ్చి “నీ దగ్గరున్న ఈ మనుషులు ఎవరు?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","బిలాము దేవునితో “సిప్పోరు కొడుకు బాలాకు అనే మోయాబు రాజు వార్త పంపించి, ");
INSERT INTO tel2017_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘చూడు, ఒక జాతి ఐగుప్తునుంచి బయలుదేరి వచ్చింది. వారు ఈ ప్రదేశమంతా కమ్మి ఉన్నారు. నువ్వు వెంటనే వచ్చి నా కోసం వారిని శపించు. ఒకవేళ నేను వారి మీద దాడి చేసి వారిని ఈ ప్రదేశం నుంచి తరమగలుగుతానేమో’ అని వీళ్ళతో నాకు వార్త పంపించాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","దేవుడు బిలాముకు జవాబిస్తూ “నువ్వు వారితో వెళ్లకూడదు. ఆ ప్రజలను శపించకూడదు. వారు ఆశీర్వాదం పొందిన వారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","కాబట్టి బిలాము ఉదయాన లేచి, బాలాకు నాయకులతో “మీరు మీ స్వదేశానికి వెళ్ళి పొండి. మీతో వెళ్ళడానికి యెహోవా నాకు అనుమతి ఇవ్వలేదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","కాబట్టి మోయాబు నాయకులు లేచి బాలాకు దగ్గరికి వెళ్లి “బిలాము మాతో రావడానికి నిరాకరించాడు” అని చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","బాలాకు వారికంటే ఘనత కలిగిన ఇంకా ఎక్కువ మంది నాయకులను మళ్ళీ పంపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","వారు బిలాము దగ్గరికి వచ్చి అతనితో “సిప్పోరు కొడుకు బాలాకు, ‘నువ్వు నా దగ్గరికి రావడానికి దయచేసి ఏదీ నిన్ను ఆపనివ్వకు, ");
INSERT INTO tel2017_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ఎందుకంటే, నేను నిన్ను చాలా గొప్పవాణ్ణి చేస్తాను. నువ్వు నాతో ఏం చెప్పినా చేస్తాను. కాబట్టి నువ్వు దయచేసి వచ్చి, నా కోసం ఈ జనాన్ని శపించు’ అని చెప్పమన్నాడు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","బిలాము జవాబిస్తూ “బాలాకు తన రాజమందిరమంత వెండి బంగారాలు నాకిచ్చినా, నేను చెయ్యాల్సిన పని చిన్నదైనా పెద్దదైనా, నేను నా దేవుడైన యెహోవా నోటి మాట మీరలేను. ");
INSERT INTO tel2017_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","కాబట్టి మీరు దయచేసి ఈ రాత్రి కూడా ఇక్కడ ఉండండి. యెహోవా నాతో ఇంకేం చెప్తాడో నేను తెలుసుకుంటాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ఆ రాత్రి దేవుడు బిలాము దగ్గరికి వచ్చి “ఆ మనుషులు నిన్ను పిలిపించారు గనక నువ్వు లేచి వారితో వెళ్ళు. కాని కేవలం నేను నీతో చెప్పినట్టే నువ్వు చెయ్యాలి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ఉదయాన బిలాము లేచి తన గాడిదకు గంత కట్టి మోయాబు నాయకులతోపాటు వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","అతడు వెళ్తూ ఉన్నప్పుడు, దేవుని కోపం రగులుకుంది. యెహోవా దూత అతనికి విరోధంగా దారిలో అడ్డంగా నిలిచి ఉన్నాడు. అతడు తన గాడిద ఎక్కి వెళ్తూ ఉన్నప్పుడు, అతని పనివారు ఇద్దరు అతనితోపాటు ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","యెహోవా దూత కత్తి దూసి, దారిలో నిలిచి ఉండడం ఆ గాడిద చూసింది గనక అది దారి మళ్ళి పొలంలోకి వెళ్ళింది. బిలాము గాడిదను దారిలోకి మళ్ళించాలని దాన్ని కొట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","యెహోవా దూత అటూ ఇటూ గోడలున్న ద్రాక్షతోటల సందులో నిలిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","గాడిద యెహోవా దూతను చూసి గోడ మీద పడి బిలాము కాలును గోడకు అదిమింది గనక అతడు మళ్ళీ దాన్ని కొట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","యెహోవా దూత ముందుకు వెళ్లి, కుడికైనా ఎడమకైనా తిరగడానికి దారిలేని ఇరుకు ప్రాంతంలో నిలిచినప్పుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ఆ గాడిద యెహోవా దూతను చూసి బిలాముతోబాటు కింద పడిపోయింది గనక బిలాము మండిపడ్డాడు. తన చేతి కర్రతో గాడిదను కొట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","అప్పుడు యెహోవా ఆ గాడిద నోరు తెరిచాడు. అది “నువ్వు నన్ను మూడుసార్లు కొట్టావు. నేను ఏమి చేశాను?” అని బిలాముతో అంది. ");
INSERT INTO tel2017_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","బిలాము “నువ్వు నన్ను ఒక వెర్రివాణ్ణి చేశావు. నా చేతిలో కత్తి ఉంటే నిన్ను చంపేసే వాణ్ణి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ఆ గాడిద “ఈ రోజు వరకూ నీ జీవితమంతా నువ్వు స్వారీ చేసిన నేను నీదాన్ని కాదా? నేనెప్పుడైనా నీ పట్ల ఈవిధంగా చేశానా?” అని బిలాముతో అంది. బిలాము “లేదు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","అప్పుడు యెహోవా బిలాము కళ్ళు తెరిచాడు గనక దూసిన కత్తి చేత్తో పట్టుకుని దారిలో నిలిచి ఉన్న యెహోవా దూతను అతడు చూసి తల వంచి సాష్టాంగ నమస్కారం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","యెహోవా దూత “నీ గాడిదను మూడుసార్లు ఎందుకు కొట్టావు? చూడు, నా దృష్టిలో నువ్వు దుర్మార్గమైన పనులు చేశావు గనక నేను నీకు విరోధిగా వచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ఆ గాడిద నన్ను చూసి ఈ మూడుసార్లు నా ఎదుట నుంచి పక్కకు వెళ్ళింది. అది నా ఎదుట నుంచి పక్కకు వెళ్ళకపోతే కచ్చితంగా అప్పుడే నేను నిన్ను చంపి దాని ప్రాణం రక్షించి ఉండేవాణ్ణి” అని అతనితో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","అందుకు బిలాము “నేను పాపం చేశాను. నువ్వు నాకు ఎదురుగా దారిలో నిలుచుని ఉన్నావని నాకు తెలియలేదు. కాబట్టి ఈ పని నీ దృష్టికి చెడ్డదైతే నేను ఎక్కడనుంచి వచ్చానో అక్కడికి వెళ్ళిపోతాను” అని యెహోవా దూతతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","యెహోవా దూత “నువ్వు ఆ మనుషులతోపాటు వెళ్ళు. కాని, నేను నీతో చెప్పే మాటలేగాని, ఇంకేమీ పలకొద్దు” అని బిలాముతో చెప్పాడు. అప్పుడు బిలాము బాలాకు అధికారులతో పాటు వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","బిలాము వచ్చాడని బాలాకు విని, ఆ సరిహద్దు చివర ఉన్న అర్నోను తీరంలో అతన్ని కలుసుకోడానికి మోయాబు పట్టణం వరకూ వెళ్ళినప్పుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","బాలాకు బిలాముతో “నిన్ను పిలవడానికి నేను నీ దగ్గరికి రాయబారులను పంపాను గదా! నువ్వెందుకు నా దగ్గరికి రాలేదు? నిన్ను గొప్పవాణ్ణి చేసే సామర్థ్యం నాకు లేదా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","అప్పుడు బిలాము “చూడు, నేను నీ దగ్గరికి వచ్చాను. నాకిష్టమొచ్చింది చెప్పడానికి నాకు శక్తి ఉందా? దేవుడు నా నోట పలికించే మాటే పలకగలను గదా” అని బాలాకుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","అప్పుడు బిలాము బాలాకుతో పాటు వెళ్ళాడు. వారు కిర్యత్‌ హుజోతుకు వచ్చినప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","బాలాకు ఎడ్లు, గొర్రెలు బలిగా అర్పించి, కొంతభాగం బిలాముకు, అతని దగ్గరున్న నాయకులకు పంపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","బాలాకు ఆ తరువాత రోజు బిలామును బయలుకు చెందిన ఎత్తైన స్థలాల దగ్గరికి తీసుకు వెళ్ళాడు. అక్కడనుంచి బిలాము ఇశ్రాయేలీయుల శిబిరంలో కొంత భాగమే చూడగలిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","అప్పుడు బిలాము బాలాకుతో “ఇక్కడ నా కోసం ఏడు బలిపీఠాలు కట్టించి, ఏడు దున్నపోతులను, ఏడు పొట్టేళ్లను సిద్ధం చెయ్యి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","బిలాము చెప్పినట్టు బాలాకు చేసినప్పుడు, బాలాకు, బిలాము ప్రతి బలిపీఠం మీద ఒక దున్నపోతునూ ఒక పొట్టేలునూ దహనబలిగా అర్పించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ఇంకా బిలాము బాలాకుతో “బలిపీఠం మీద నీ దహనబలి దగ్గర నిలిచి ఉండు. ఒకవేళ నన్ను కలవడానికి యెహోవా వస్తాడేమో. ఆయన నాకు ఏమి చూపిస్తాడో అది నీకు తెలియజేస్తాను” అని చెప్పి చెట్లు లేని కొండ ఎక్కి వెళ్ళాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","దేవుడు బిలామును కలుసుకున్నప్పుడు, బిలాము ఆయనతో “నేను ఏడు బలిపీఠాలు కట్టి, ప్రతి దాని మీద ఒక దున్నపోతు, ఒక పొట్టేలును అర్పించాను” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","యెహోవా ఒక వార్త బిలాము నోట ఉంచి “నువ్వు బాలాకు దగ్గరికి తిరిగి వెళ్లి అతనితో మాట్లాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","అతడు బాలాకు దగ్గరికి తిరిగి వెళ్లినప్పుడు అతడు మోయాబు నాయకులందరితో తన దహనబలి దగ్గర నిలబడి ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","అప్పుడు బిలాము ప్రవచనరీతిగా, “అరాము నుంచి బాలాకు, తూర్పు పర్వతాల నుంచి మోయాబురాజు నన్ను రప్పించి, ‘వచ్చి, నాకోసం యాకోబును శపించు’ అన్నాడు, ‘వచ్చి ఇశ్రాయేలును వ్యతిరేకించు’ అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","దేవుడు శపించనివారిని నేనెలా శపించను? దేవుడు వ్యతిరేకించని వారిని నేనెలా వ్యతిరేకించను? ");
INSERT INTO tel2017_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","రాతిబండల మీద నుంచి ఆయన్ని చూస్తున్నాను. కొండలపై నుండి ఆయన్ని కనుగొన్నాను. చూడు, ఒంటిగా నివసించే జనం ఒకటి ఉంది. వారు ఒక సాధారణ జనంగా తమను తాము ఎంచుకోరు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","యాకోబు రేణువులను ఎవరు లెక్కించ గలరు? ఇశ్రాయేలులో నాల్గోవంతునైనా ఎవరు లేక్కించ గలరు? నీతిమంతుల మరణం లాంటి మరణం నాకు రానివ్వండి. నా జీవిత అంతం ఆయన జనంలా ఉండనివ్వండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","బాలాకు బిలాముతో “నువ్వు నాకు ఏం చేశావు? నా శత్రువులను శపించడానికి నిన్ను రప్పించాను. కాని నువ్వు వారిని దీవించావు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","బిలాము జవాబిస్తూ “యెహోవా నా నోట ఉంచినదే నేను జాగ్రత్తగా పలకాలి కదా?” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","అప్పుడు బాలాకు అతనితో “దయచేసి నాతోపాటు ఇంకొక చోటికి రా. అక్కడనుంచి వారిని చూడొచ్చు. చివర ఉన్న వారిని మాత్రమే నువ్వు చూడ గలుగుతావు. వారందరూ నీకు కనిపించరు. అక్కడ నుంచి నా కోసం వారిని శపించాలి” అని చెప్పి ");
INSERT INTO tel2017_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","పిస్గా కొండపైన ఉన్న కాపలావారి పొలానికి అతన్ని తీసుకెళ్ళి, ఏడు బలిపీఠాలు కట్టించి, ప్రతి బలిపీఠం మీద ఒక దున్నపోతును, ఒక పొట్టేలును అర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","అప్పుడు బిలాము బాలాకుతో “నువ్వు ఇక్కడ నీ దహనబలి దగ్గర నిలిచి ఉండు. నేను అక్కడ యెహోవాను కలుసుకుంటాను” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","యెహోవా బిలామును కలుసుకుని ఒక వార్త అతని నోట ఉంచి “నువ్వు బాలాకు దగ్గరికి తిరిగి వెళ్లి నా వార్త అతనికి అందించు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","అతడు బాలాకు దగ్గరికి వెళ్లినప్పుడు అతడు తన దహనబలి దగ్గర నిలిచి ఉన్నాడు. మోయాబు నాయకులు కూడా అతని దగ్గర ఉన్నారు. బాలాకు “యెహోవా ఏం చెప్పాడు?” అని అడిగాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","బిలాము ప్రవచనంగా “బాలాకూ, లేచి విను. సిప్పోరు కుమారుడా, ఆలకించు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","అబద్ధమాడడానికి దేవుడు మనిషి కాదు. మనస్సు మార్చుకోడానికి ఆయన మానవుడు కాదు. ఆయన వాగ్దానం చేసి కార్యం చెయ్యకుండా ఉంటాడా? ఆయన మాట ఇచ్చి నెరవేర్చకుండా ఉంటాడా? ");
INSERT INTO tel2017_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","చూడు, దీవించమని నాకు ఆజ్ఞ వచ్చింది. దేవుడు దీవెన ఇచ్చాడు. నేను దాన్ని మార్చలేను. ");
INSERT INTO tel2017_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ఆయన యాకోబులో కష్టం గాని, దోషం గాని కనుగొనలేదు. వారి దేవుడైన యెహోవా వాళ్లకు తోడుగా ఉన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","అడవిదున్న బలం లాంటి బలంతో దేవుడు వారిని ఐగుప్తులోనుంచి తీసుకొచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","యాకోబుకు వ్యతిరేకంగా ఏ మంత్రం పనిచెయ్యదు. ఏ శకునం హాని చెయ్యదు. దానికి బదులుగా యాకోబు గురించీ, ఇశ్రాయేలు గురించీ ‘దేవుడు ఏం చేశాడో చూడు’ అని చెప్పుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","చూడు, ఆ ప్రజలు ఆడసింహంలా లేస్తారు, ఆ జాతి సింహంలా బయటకు వచ్చి వేటాడుతుంది. చంపిన దాన్ని తిని, దాని రక్తం తాగే వరకూ అది పండుకోదు” అని పలికాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","అప్పుడు బాలాకు బిలాముతో “వారిని శపించడం గాని, ఆశీర్వదించడం గాని ఏదీ చెయ్యొద్దు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","కాని బిలాము “యెహోవా నాకు చెప్పిందంతా నేను చెయ్యాలని నేను నీతో చెప్పలేదా?” అని బాలాకుకు జవాబిచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","బాలాకు బిలాముతో “నువ్వు దయచేసి రా, నేను ఇంకొక చోటికి నిన్ను తీసుకెళ్తాను. అక్కడ నుంచి నా కోసం నువ్వు వారిని శపించడం దేవుని దృష్టికి అనుకూలంగా ఉంటుందేమో” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","బాలాకు ఎడారికి ఎదురుగా ఉన్న పెయోరు శిఖరానికి బిలామును తీసుకు పోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","బిలాము “ఇక్కడ నాకు ఏడు బలిపీఠాలు కట్టించి, ఏడు దున్నపోతులను, ఏడు పొట్టేళ్లను సిద్ధం చెయ్యి” అని బాలాకుతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","బిలాము చెప్పినట్టు బాలాకు చేసి, ప్రతి బలిపీఠం మీద ఒక దున్నపోతును, ఒక పొట్టేలును అర్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ఇశ్రాయేలీయులను దీవించడం యెహోవా దృష్టికి మంచిదని బిలాము తెలుసుకున్నప్పుడు అతడు ఇంతకు ముందు లాగా శకునం చూడడానికి వెళ్ళకుండా ఎడారి వైపు తన ముఖాన్ని తిప్పుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","బిలాము కళ్ళెత్తి ఇశ్రాయేలీయులు తమ తమ గోత్రాల ప్రకారం శిబిరంలో ఉండడం చూసినప్పుడు, దేవుని ఆత్మ అతని మీదికి దిగి వచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","అతడు ఇలా ప్రవచించాడు. “బెయోరు కొడుకు బిలాముకు పలుకబోతున్నాడు. కళ్ళు బాగా తెరుచుకున్నవాడు పలకబోతున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","అతడు దేవుని మాటలు మాట్లాడతాడు, దేవుని మాటలు వింటాడు. అతడు సర్వశక్తుని దగ్గర నుంచి వచ్చే దర్శనం చూస్తాడు, ఆయన ఎదుట అతడు తన కళ్ళు తెరిచి వంగి నమస్కరిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","యాకోబూ, నీ గుడారాలు ఎంతో అందంగా ఉన్నాయి. ఇశ్రాయేలూ, నీ నివాసస్థలాలు ఎంత రమ్యంగా ఉన్నాయి! ");
INSERT INTO tel2017_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","అవి లోయలు వ్యాపించినట్టు, నదీతీరంలో తోటల్లా, యెహోవా నాటిన అగరు చెట్లలా నీళ్ళ దగ్గరున్న దేవదారు వృక్షాల్లా ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","అతడు నీరు తోడుకునే చేదల నుండి నీళ్ళు కారుతాయి. అతడు నాటిన విత్తనానికి సమృద్ధిగా నీళ్ళు అందుతాయి. వారి రాజు అగగు కంటే గొప్పవాడౌతాడు. వారి రాజ్యం ఘనత పొందుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","దేవుడు ఐగుప్తులోనుంచి అతన్ని రప్పించాడు. అతనికి అడవిదున్నకు ఉన్నంత బలం ఉంది. అతడు తనకు విరోధంగా పోరాడే వారిని మింగేస్తాడు. వారి ఎముకలు విరిచేస్తాడు. తన బాణాలతో వారిని చంపేస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","అతడు సింహంలా, ఆడ సింహంలా పొంచి ఉంటాడు. అతని విశ్రాంతికి భంగం కలిగించేవాడెవడు? అతన్ని దీవించే ప్రతివాడికీ దీవెన వస్తుంది గాక, అతన్ని శపించే ప్రతివాడికీ శాపం వస్తుంది గాక” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","అప్పుడు బాలాకు కోపం బిలాము మీద రగిలింది గనక అతడు తన చేతులు చరిచి బిలాముతో “నా శత్రువులను శపించడానికి నిన్ను పిలిపించాను కాని నీవు ఈ మూడుసార్లు వారిని దీవించావు. కాబట్టి నువ్వు ఇప్పుడు నీ స్థలానికి తొందరగా వెళ్లు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","నేను నిన్ను ఎంతో గొప్పవాణ్ణి చేస్తానని చెప్పాను గాని, నీకు అది దక్కకుండా యెహోవా నిన్ను ఆటంకపరిచాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","అందుకు బిలాము బాలాకుతో “బాలాకు తన రాజమందిరమంత వెండి బంగారాలు నాకిచ్చినా నా ఇష్టప్రకారం మేలైనా కీడైనా చెయ్యడానికి యెహోవా చెప్పిన మాట మీరలేను, ");
INSERT INTO tel2017_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","యెహోవా ఏం చెప్తాడో అదే పలుకుతానని నువ్వు నా దగ్గరికి పంపించిన నీ వర్తమానికులతో నేను చెప్పలేదా? ");
INSERT INTO tel2017_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","కాబట్టి, చూడు, నేను నా ప్రజల దగ్గరికి వెళ్తున్నాను. కాని, ముందు రోజుల్లో ఈ ప్రజలు నీ ప్రజలకు ఏం చేస్తారో, ఆ హెచ్చరిక నీకు నేనివ్వాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","బిలాము ప్రవచనం చెప్పాడు. “బెయోరు కొడుకు బిలాము మాట్లాడుతున్నాడు, కనువిప్పు కలిగినవాడు మాట్లాడుతున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ఇది దేవుని వాక్కులను విన్నవాడి ప్రవచనం. మహాన్నతుని జ్ఞానం తెలిసినవాడి ప్రవచనం. సర్వశక్తుని దర్శనాలు చూసినవాడి ప్రవచనం. ఆయన ఎదుట తెరిచిన కళ్ళతో అతడు వంగి నమస్కారం చేస్తున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","నేను ఆయన్ని చూస్తున్నాను, కాని ఇప్పుడు ఆయన ఇక్కడ లేడు. నేను ఆయన్ని గమనిస్తున్నాను కాని ఆయన ఇప్పుడు సమీపంగా లేడు. ఒక నక్షత్రం యాకోబులో ఉదయిస్తుంది. రాజదండం ఇశ్రాయేలులోనుంచి వస్తుంది. అతడు మోయాబు నాయకులను పడగొడతాడు. అతడు షేతు వంశస్తులందరినీ నాశనం చేస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ఎదోము, శేయీరు, ఇశ్రాయేలు శత్రువులు స్వాధీనం అవుతారు. వారిని ఇశ్రాయేలీయులు తమ బలం చేత జయిస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","యాకోబు సంతానంలోనుంచి రాజ్యాధికారం వస్తుంది. అతడు వారి పట్టణాల్లో మిగిలిన వారిని నాశనం చేస్తారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ఇంకా బిలాము అమాలేకీయులవైపు చూసి ప్రవచనం చెప్తూ, “ఒకప్పుడు అమాలేకు దేశాల్లో గొప్ప దేశం. కాని దాని అంతం నాశనమే” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","తరువాత బిలాము కేనీయులవైపు చూసి ప్రవచనం చెప్తూ, “నువ్వు నివాసం ఉన్న స్థలం బలమైనది. నీ గూడు బండరాళ్ళల్లో ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","కాని అష్షూరు నిన్ను బందీగా పట్టుకున్నప్పుడు కయీను నాశనమౌతుంది” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","అప్పుడు అతడు ప్రవచనంగా చెప్తూ “అయ్యో! దేవుడు ఇలా చేసినప్పుడు ఎవరు బతుకుతారు? ");
INSERT INTO tel2017_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","కిత్తీము తీరం నుంచి ఓడలు వస్తాయి. అవి అష్షూరు, ఏబెరుల మీద దాడి చేస్తాయి. కిత్తీయులు కూడా నాశనమౌతారు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","అప్పుడు బిలాము లేచి తన ఇంటికి తిరిగి వెళ్ళిపోయాడు. బాలాకు కూడా వెళ్ళిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ఇశ్రాయేలీయులు షిత్తీములో ఉన్నప్పుడు ప్రజలు మోయాబు స్త్రీలతో వ్యభిచారం చెయ్యడం మొదలు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ఆ స్త్రీలు తమ దేవుళ్ళ బలులకు ప్రజలను ఆహ్వానించినప్పుడు వీరు భోజనం చేసి వారి దేవుళ్ళకు నమస్కారం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ఇశ్రాయేలీయులు బయల్పెయోరును ఆరాధించిన కారణంగా యెహోవా కోపం వారి మీద రగులుకుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","అప్పుడు యెహోవా మోషేతో “నువ్వు ప్రజల నాయకులందర్నీ చంపి, నా ఎదుట, పట్టపగలు వారిని వేలాడదియ్యి. అప్పుడు నా కోపాగ్ని ఇశ్రాయేలీయుల మీద నుంచి తొలిగి పోతుంది” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","కాబట్టి మోషే ఇశ్రాయేలీయుల నాయకులతో “మీలో ప్రతివాడూ, బయల్పెయోరును ఆరాధించే వారితో కలిసిన వారిని చంపాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","అప్పుడు మోషే కళ్ళ ఎదుట, సన్నిధి గుడారం ద్వారం దగ్గర, ఏడుస్తూ ఉన్న ఇశ్రాయేలీయుల సమాజం అంతటి కళ్ళ ఎదుట, ఇశ్రాయేలీయుల్లో ఒకడు తన కుటుంబికుల మధ్యకు ఒక మిద్యాను స్త్రీని తీసుకొచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","యాజకుడైన అహరోను మనవడు, ఎలియాజరు కొడుకు ఫీనెహాసు అది చూసి, ");
INSERT INTO tel2017_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","సమాజం నుంచి లేచి, ఈటె చేత్తో పట్టుకుని ఆ ఇశ్రాయేలీయుడి వెంట ఆ గుడారంలోకి వెళ్లి ఆ ఇద్దరినీ, అంటే ఆ ఇశ్రాయేలీయుణ్ణీ, ఆ స్త్రీనీ, కడుపులో గుండా దూసుకు పోయేలా పొడిచాడు. అప్పుడు ఇశ్రాయేలీయుల్లోకి దేవుడు పంపించిన తెగులు ఆగిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ఆ తెగులు వల్ల 24 వేల మంది చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","అప్పుడు యెహోవా మోషేతో “యాజకుడైన అహరోను మనవడూ, ఎలియాజరు కొడుకూ అయిన ఫీనెహాసు, ");
INSERT INTO tel2017_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","వారి మధ్య నేను సహించలేనిదాన్ని తానూ సహించకపోవడం వల్ల ఇశ్రాయేలీయుల మీద నుంచి నా కోపం మళ్ళించాడు గనక నేను సహించలేకపోయినా ఇశ్రాయేలీయులను నాశనం చెయ్యలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","కాబట్టి నువ్వు అతనితో ఇలా అను, చూడు, నేను ఫినెహాసుకు నా సమాధాన నిబంధన చేస్తున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","అది శాశ్వతమైన యాజక నిబంధనగా అతనికీ, అతని సంతానానికీ ఉంటుంది. ఎందుకంటే అతడు తన దేవుని విషయంలో ఆసక్తి కలిగిన వాడుగా ఇశ్రాయేలీయుల కోసం ప్రాయశ్చిత్తం చేశాడు” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ఫినెహాసు చంపినవాడి పేరు జిమ్రీ. అతడు షిమ్యోనీయుల్లో తన పితరుల వంశానికి నాయకుడైన సాలూ కొడుకు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ఫినెహాసు చంపిన స్త్రీ పేరు కొజ్బీ, ఆమె సూరు కూతురు. అతడు మిద్యానీయుల్లో ఒక గోత్రానికీ, కుటుంబానికీ నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ఇంకా యెహోవా మోషేతో “మిద్యానీయులను శత్రువులుగా భావించి వారి మీద దాడి చెయ్యండి. ");
INSERT INTO tel2017_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","వారు మిమ్మల్ని మోసం చేసి మిమ్మల్ని శత్రువులుగా ఎంచారు. ");
INSERT INTO tel2017_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","పెయోరు విషయంలో, తెగులు రోజున చంపిన తమ సహోదరి, మిద్యాను నాయకుని కూతురు కొజ్బీ విషయంలో, మిమ్మల్ని దుర్మార్గంలోకి నడిపించారు.” ");
INSERT INTO tel2017_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ఆ తెగులు పోయిన తరువాత యెహోవా మోషేతో, యాజకుడైన అహరోను కొడుకు ఎలియాజరుతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“మీరు ఇశ్రాయేలీయుల సమాజమంతట్లో 20 సంవత్సరాలు మొదలుకుని ఆ పై వయస్సు ఉన్న ఇశ్రాయేలీయుల్లో యుద్ధం చెయ్యగల సామర్థ్యం ఉన్న వారిని, తమ పితరుల కుటుంబాల ప్రకారం లెక్కపెట్టండి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","కాబట్టి మోషే, యాజకుడైన ఎలియాజరు యెరికో దగ్గర యోర్దాను తీరంలో మోయాబు మైదానాల్లో సమాజమంతటితో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“20 సంవత్సరాలు, ఆ పై వయస్సు కలిగి, ఐగుప్తులోనుంచి బయటకు వచ్చిన వారిని లెక్కపెట్టమని యెహోవా ఆజ్ఞ ఇచ్చాడు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ఇశ్రాయేలు పెద్దకొడుకు రూబేను. రూబేను కొడుకు హనోకు నుంచి హనోకీయులు హనోకు వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","పల్లువీయులు పల్లు వంశస్థులు. హెస్రోనీయులు హెస్రోను వంశస్థులు, కర్మీయులు కర్మీ వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","వీరు రూబేనీయుల వంశస్థులు. వారిల్లో లెక్కకు వచ్చినవారు 43, 730 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","పల్లు కొడుకు ఏలీయాబు. ఏలీయాబు కొడుకులు నెమూయేలు, దాతాను, అబీరాము. ");
INSERT INTO tel2017_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","కోరహు, అతని సమాజం యెహోవాకు విరోధంగా వాదించినప్పుడు సమాజంలో మోషే అహరోనులకు విరోధంగా వాదించిన దాతాను అబీరాములు వీరే. ");
INSERT INTO tel2017_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ఆ సమాజం వారు చనిపోయినప్పుడు అగ్ని 250 మందిని కాల్చేసినందువల్ల, భూమి తన నోరు తెరచి వారిని, కోరహును మింగేసినందువల్ల, వారు ఒక హెచ్చరికగా అయ్యారు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","అయితే కోరహు కొడుకులు చనిపోలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","షిమ్యోను కొడుకుల వంశంలో నెమూయేలీయులు నెమూయేలు వంశస్థులు, యామీనీయులు యామీను వంశస్థులు, యాకీనీయులు యాకీను వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","జెరహీయులు జెరహు వంశస్థులు, షావూలీయులు షావూలు వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ఇవి షిమ్యోనీయుల వంశాలు. వారు 22, 200 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","గాదు కొడుకుల వంశాల్లో సెపోనీయులు సెపోను వంశస్థులు, హగ్గీయులు హగ్గీ వంశస్థులు, షూనీయులు షూనీ వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ఓజనీయులు ఓజని వంశస్థులు, ఏరీయులు ఏరీ వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ఆరోదీయులు ఆరోదు వంశస్థులు, అరేలీయులు అరేలీ వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","వీరు గాదీయుల వంశస్థులు. రాసిన వారి లెక్క ప్రకారం వీరు 40, 500 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","యూదా కొడుకులు ఏరు, ఓనాను. ఏరు, ఓనాను, కనాను ప్రదేశంలో చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","యూదావారి వంశాల్లో షేలాహీయులు షేలా వంశస్థులు, పెరెసీయులు పెరెసు వంశస్థులు, జెరహీయులు జెరహు వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","పెరెసీయుల్లో హెస్రోనీయులు హెస్రోను వంశస్థులు, హామూలీయులు హామూలు వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","వీరు యూదా వంశస్థులు. రాసిన వారి లెక్క ప్రకారం వీరు 76, 500 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ఇశ్శాఖారు కొడుకుల వంశస్థుల్లో తోలాహీయులు తోలా వంశస్థులు, పువ్వీయులు పువ్వా వంశస్థులు, యాషూబీయులు యాషూబు వంశస్థులు, షిమ్రోనీయులు షిమ్రోను వంశస్థులు. వీరు ఇశ్శాఖారీయుల వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","రాసిన వారి లెక్క ప్రకారం వీరు 64, 300 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","జెబూలూను కొడుకుల వంశస్థుల్లో సెరెదీయులు సెరెదు వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ఏలోనీయులు ఏలోను వంశస్థులు, యహలేలీయులు యహలేలు వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","రాసిన వారి లెక్క ప్రకారం వీరు 60, 500 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","యోసేపు వంశస్థులు అతని కొడుకులు మనష్షే, ఎఫ్రాయిము. ");
INSERT INTO tel2017_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","మనష్షే కొడుకుల్లో మాకీరీయులు మాకీరు వంశస్థులు. మాకీరు గిలాదుకు తండ్రి. గిలాదీయులు గిలాదు వంశస్థులు. వీరు గిలాదు కొడుకులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ఈజరీయులు ఈజరు వంశస్థులు, హెలకీయులు హెలకు వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","అశ్రీయేలీయులు అశ్రీయేలు వంశస్థులు, షెకెమీయులు షెకెము వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","షెమీదాయీయులు షెమీదా వంశస్థులు, హెపెరీయులు హెపెరు వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","హెపెరు కొడుకు సెలోపెహాదుకు కూతుళ్ళేగాని కొడుకులు పుట్టలేదు. సెలోపెహాదు కూతుళ్ళ పేర్లు మహలా, నోయా, హొగ్లా, మిల్కా, తిర్సా. ");
INSERT INTO tel2017_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","వీరు మనష్షీయుల వంశస్థులు. రాసిన వారి లెక్క ప్రకారం వీరు 52, 700 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ఇవి ఎఫ్రాయిము కొడుకుల వంశాలు-షూతలహీయులు షూతలహు వంశస్థులు, బేకరీయులు బేకరు వంశస్థులు, తహనీయులు తహను వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","షూతలహు వంశస్థుడు ఏరాను. అతని వంశం ఏరాను వంశం. ");
INSERT INTO tel2017_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","వీరు ఎఫ్రాయిమీయుల వంశస్థులు. రాసిన వారి లెక్క ప్రకారం వీరు 32, 500 మంది పురుషులు. వీరు యోసేపు కొడుకుల వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","బెన్యామీను కొడుకుల వంశాల్లో బెలీయులు బెల వంశస్థులు, అష్బేలీయులు అష్బేల వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","అహీరామీయులు అహీరాము వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","షూఫామీయులు షూపఫాము వంశస్థులు. బెల కొడుకులు ఆర్దు, నయమాను. ఆర్దీయులు ఆర్దు వంశస్థులు, నయమానీయులు నయమాను వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","వీరు బెన్యామీనీయుల వంశస్థులు. రాసిన వారి లెక్క ప్రకారం వీరు 45, 600 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","దాను కొడుకుల వంశాల్లో షూహామీయులు షూహాము వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","రాసిన వారి లెక్క ప్రకారం వీరు 64, 400 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ఆషేరు కొడుకుల వంశాల్లో యిమ్నీయులు యిమ్నా వంశస్థులు, ఇష్వీయులు ఇష్వీ వంశస్థులు, బెరీయులు బెరీయా వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","బెరీయానీయుల్లో హెబెరీయులు హెబెరు వంశస్థులు, మల్కీయేలీయులు మల్కీయేలు వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ఆషేరు కూతురు పేరు శెరహు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","రాసిన వారి లెక్క ప్రకారం వీరు 53, 400 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","నఫ్తాలీ కొడుకుల వంశాల్లో యహసయేలీయులు యహసయేలు వంశస్థులు, గూనీయులు గూనీ వంశస్థులు, ");
INSERT INTO tel2017_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","యేసెరీయులు యేసెరు వంశస్థులు, షిల్లేమీయులు షిల్లేము వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","వీరు నఫ్తాలీయుల వంశస్థులు. రాసిన వారి లెక్క ప్రకారం వీరు 45, 400 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ఇశ్రాయేలీయుల్లో లెక్కకు వచ్చినవారు 6,01,730 మంది పురుషులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","యెహోవా మోషేతో “వీళ్ళ పేర్ల లెక్క ప్రకారం ఆ దేశాన్ని వీళ్ళకు స్వాస్థ్యంగా పంచిపెట్టాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","తమ తమ లెక్క ప్రకారం ఆ స్వాస్థ్యం వాళ్లకు ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ఎక్కువమంది ఉన్న వంశాలకు ఎక్కువ స్వాస్థ్యం, తక్కువమంది ఉన్నవారికి తక్కువ స్వాస్థ్యం ఇవ్వాలి. తమ తమ లెక్కను బట్టి వివిధ గోత్రాలకు స్వాస్థ్యం ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","చీటీలు వేసి ఆ భూమిని పంచిపెట్టాలి. వారు తమ తమ పితరుల గోత్రాల జనాభా లెక్క ప్రకారం స్వాస్థ్యం పొందాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ఎక్కువ మందికైనా తక్కువ మందికైనా చీటీలు వేసి, ఎవరి స్వాస్థ్యం వారికి పంచిపెట్టాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","వీరు తమ తమ వంశాల్లో లెక్కకు వచ్చిన లేవీయులు. గెర్షోనీయులు గెర్షోను వంశస్థులు, కహాతీయులు కహాతు వంశస్థులు, మెరారీయులు మెరారి వంశస్థులు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","లేవీయుల వంశాలు ఏవంటే, లిబ్నీయుల వంశం, హెబ్రోనీయుల వంశం, మహలీయుల వంశం, మూషీయుల వంశం, కోరహీయుల వంశం. ");
INSERT INTO tel2017_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","కహాతు అమ్రాము తండ్రి. అమ్రాము భార్య పేరు యోకెబెదు. ఆమె లేవీ కూతురు. ఆమె ఐగుప్తులో లేవీకి పుట్టింది. ఆమె అమ్రామువల్ల అహరోను, మోషే, వీళ్ళ సహోదరి మిర్యాములను కన్నది. ");
INSERT INTO tel2017_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","అహరోనుకు నాదాబు, అబీహు, ఎలియాజరు, ఈతామారు పుట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","నాదాబు అబీహులు యెహోవా సన్నిధిలో అంగీకారం కాని అగ్ని అర్పణ చేసినప్పుడు చనిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","వారిల్లో నెల మొదలుకొని పై వయస్సు కలిగి లెక్కకు వచ్చిన వాళ్లందరూ 23,000 మంది పురుషులు. వారు ఇశ్రాయేలీయుల్లో లెక్కకు రాని వారు గనక ఇశ్రాయేలీయుల్లో వాళ్లకు స్వాస్థ్యం దక్కలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","యెరికో ప్రాంతాల్లో యొర్దాను దగ్గరున్న మోయాబు మైదానాల్లో మోషే, యాజకుడైన ఎలియాజరు, ఇశ్రాయేలీయుల జనాభా లెక్కపెట్టినప్పుడు లెక్కకు వచ్చిన వారు వీరు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","మోషే అహరోనులు సీనాయి ఎడారిలో ఇశ్రాయేలీయుల జనాభా లెక్కపెట్టినప్పుడు లెక్కకు వచ్చిన వారిలో ఒక్కడైనా వీళ్ళల్లో లేడు. ");
INSERT INTO tel2017_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ఎందుకంటే వారు కచ్చితంగా ఎడారిలో చనిపోతారని యెహోవా వారి గురించి చెప్పాడు. యెపున్నె కొడుకు కాలేబు, నూను కొడుకు యెహోషువ తప్ప వారిల్లో ఒక్కడైనా మిగల్లేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","అప్పుడు యోసేపు కొడుకు మనష్షే వంశస్థుల్లో సెలోపెహాదు కూతుళ్ళు వచ్చారు. సెలోపెహాదు హెసెరుకు కొడుకు, గిలాదుకు మనవడు, మాకీరుకు మునిమనవడు. అతని కూతుళ్ళ పేర్లు మహలా, నోయా, హొగ్లా, మిల్కా, తిర్సా. ");
INSERT INTO tel2017_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","వారు సన్నిధి గుడారం ద్వారం దగ్గర, మోషే ఎదుట, యాజకుడైన ఎలియాజరు ఎదుట, నాయకుల ఎదుట, సమాజమంతటి ఎదుట నిలిచి “మా తండ్రి ఎడారిలో చనిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","అతడు కోరహు గుంపులో, అంటే యెహోవాకు విరోధంగా కూడినవారి గుంపులో లేడు. తన పాపాన్నిబట్టి, తన సొంత పాపాన్నిబట్టి చనిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","అతనికి కొడుకులు పుట్టలేదు. అతనికి కొడుకులు లేనంత మాత్రాన మా తండ్రి పేరు అతని వంశంలోనుంచి తీసెయ్యాలా? మా తండ్రి సహోదరులతో పాటు మాకు కూడా స్వాస్థ్యం ఇవ్వండి” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","అప్పుడు మోషే వారి కోసం యెహోవా సన్నిధిలో అడిగాడు, ");
INSERT INTO tel2017_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","యెహోవా మోషేతో “సెలోపెహాదు కూతుళ్ళు చెప్పింది నిజమే. ");
INSERT INTO tel2017_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","కచ్చితంగా వారి తండ్రి సహోదరులతో పాటు వారసత్వం వారి ఆధీనం చేసి, వారి తండ్రి స్వాస్థ్యం వాళ్లకు వచ్చేలా చూడు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ఇంకా నువ్వు ఇశ్రాయేలీయులతో, ఇలా చెప్పు. ఒకడు కొడుకు పుట్టకుండా చనిపోతే మీరు అతని భూస్వాస్థ్యం అతని కూతుళ్ళకు వచ్చేలా చూడాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","అతనికి కూతుళ్ళు లేకపోతే అతని అన్నదమ్ములకు అతని స్వాస్థ్యం ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","అతనికి అన్నదమ్ములు లేకపోతే అతని భూస్వాస్థ్యం అతని తండ్రి అన్నదమ్ములకు ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","అతని తండ్రికి అన్నదమ్ములు లేకపోతే అతని కుటుంబంలో అతని సమీప బంధువుకు అతని స్వాస్థ్యం ఇవ్వాలి. వాడు దాన్ని స్వాధీనం చేసుకుంటాడు. యెహోవా నాకు ఆజ్ఞాపించినట్టు ఇది ఇశ్రాయేలీయులకు విధించిన శాసనం” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ఇంకా యెహోవా మోషేతో “నువ్వు ఈ అబారీము కొండెక్కి నేను ఇశ్రాయేలీయులకు ఇచ్చిన దేశాన్ని చూడు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","నువ్వు దాన్ని చూసిన తరువాత, నీ సహోదరుడు అహరోను చేరినట్టు నువ్వు కూడా నీ సొంతవారితో చేరిపోతావు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ఎందుకంటే, సీను ఎడారిలో సమాజం వాదించినప్పుడు ఆ నీళ్ల దగ్గర వారి కళ్ళ ఎదుట నన్ను ఘనపరచకుండా, నా మీద మీరు తిరగబడ్డారు” అన్నాడు. ఆ నీళ్లు సీను ఎడారిలో కాదేషులో ఉన్న మెరీబా నీళ్ళు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","అప్పుడు మోషే యెహోవాతో “యెహోవా, సమస్త మానవుల ఆత్మలకు దేవా, సమాజం కాపరి లేని గొర్రెల్లా ఉండకుండాా ఈ సమాజం మీద యెహోవా ఒకణ్ణి నియమించు గాక. ");
INSERT INTO tel2017_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","అతడు వారి ముందు వస్తూ, పోతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","వాళ్లకు నాయకుడుగా ఉండడానికి సమర్థుడుగా ఉండాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","అందుకు యెహోవా మోషేతో “నూను కొడుకు యెహోషువలో నా ఆత్మ నివసిస్తూ ఉంది. నువ్వు అతన్ని తీసుకుని అతని మీద నీ చెయ్యి పెట్టి ");
INSERT INTO tel2017_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","యాజకుడైన ఎలియాజరు ఎదుట, సమాజమంతటి ఎదుట, అతని నిలబెట్టి, వారి కళ్ళ ఎదుట అతనికి ఆజ్ఞ ఇవ్వు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ఇశ్రాయేలీయుల సమాజమంతా అతని మాట వినేలా నీ అధికారంలో కొంత అతని మీద పెట్టు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","యాజకుడైన ఎలియాజరు ఎదుట అతడు నిలిచినప్పుడు అతడు యెహోవా సన్నిధిలో ఊరీము నిర్ణయం ద్వారా అతని కోసం అడగాలి. అతడు, అతనితోపాటు ఇశ్రాయేలీయులందరూ, అంటే, సమాజమంతా ప్రతి పని అతని మాట ప్రకారం చెయ్యాలి” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","యెహోవా మోషేకు ఆజ్ఞాపించినట్టు అతడు చేశాడు. అతడు యెహోషువను తీసుకుని యాజకుడైన ఎలియాజరు ఎదుట, సమాజమంతటి ఎదుట అతన్ని నిలబెట్టి, ");
INSERT INTO tel2017_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","అతని మీద తన చేతులు పెట్టి, యెహోవా మోషే ద్వారా ఆజ్ఞాపించినట్టు అతనికి ఆజ్ఞ ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","యెహోవా మోషేతో మాట్లాడుతూ, ");
INSERT INTO tel2017_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“నువ్వు ఇశ్రాయేలీయులకు ఆజ్ఞాపించి వారితో చెప్పు. నాకు ఇష్టమైన సువాసనగా మీరు దహనబలి అర్పణగా నాకు అర్పించే ఆహారం నియామక కాలంలో నా దగ్గరికి తేవడానికి జాగ్రత్త పడాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ఇంకా నువ్వు వాళ్లకు ఈ విధంగా ఆజ్ఞాపించు. మీరు యెహోవాకు నిత్యం జరిగే దహనబలిగా ప్రతి రోజూ ఏ దోషం లేని ఒక సంవత్సరం వయస్సు ఉన్న రెండు మగ గొర్రెపిల్లలను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","వాటిలో ఒక గొర్రెపిల్లను ఉదయాన, రెండోదాన్ని సాయంకాలం అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","మెత్తగా దంచిన ఒక కిలో పిండిని ఒక లీటరు నూనెతో కలిపి పదోవంతు నైవేద్యంగా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","అది యెహోవాకు ఇష్టమైన సువాసన ఇచ్చే అగ్ని అర్పణగా సీనాయి కొండ మీద నియమించిన నిత్యం జరిగే దహనబలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ఆ మొదటి గొర్రెపిల్లతో అర్పించాల్సిన పానార్పణ ముప్పావు లీటరు. పవిత్రస్థలంలో యెహోవాకు మద్యం పానార్పణగా పొయ్యాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ఉదయ నైవేద్యం, దాని పానార్పణ అర్పించినట్టే యెహోవాకు ఇష్టమైన సువాసన ఇచ్చే అగ్ని అర్పణగా ఆ రెండో గొర్రెపిల్లను సాయంకాలం అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","విశ్రాంతి రోజున ఒక సంవత్సరం వయస్సు ఉండి, ఏ దోషం లేని రెండు గొర్రెపిల్లలను నైవేద్యంగాను, దానితో పాటు పానార్పణ, నూనెతో కలిపిన నాలుగున్నర లీటర్ల పిండిలో రెండు పదోవంతులు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","నిత్యం జరిగే దహనబలీ, దాని పానార్పణ కాకుండా, ఇది ప్రతి విశ్రాంతి రోజు చెయ్యాల్సిన దహనబలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","ప్రతినెల మొదటి రోజు యెహోవాకు దహన బలి అర్పించాలి. రెండు లేగదూడలు, ఒక పొట్టేలు, ఏ దోషం లేని ఒక సంవత్సరం వయస్సు ఉన్న ఏడు గొర్రెపిల్లలు అర్పించాలి. వాటిలో ప్రతి లేగ దూడతో ");
INSERT INTO tel2017_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","నూనెతో కలిపిన నాలుగున్నర లీటర్ల పిండిలో మూడు పదోవంతులు నైవేద్యంగా అర్పించాలి. ఒక్కొక్క పొట్టేలుతో, నూనెతో కలిపిన నాలుగున్నర లీటర్ల పిండిలో రెండు పదోవంతులు నైవేద్యంగా అర్పించాలి. ఒక్కొక్క గొర్రెపిల్లతో నూనెతో కలిపిన నాలుగున్నర లీటర్ల పిండిలో ఒక్క పదో వంతు నైవేద్యంగా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","అది యెహోవాకు ఇష్టమైన సువాసన ఇచ్చే దహనబలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","వాటి పానార్పణలు ఒక్కొక్క దున్నపోతుతో ఒక లీటరు ద్రాక్షారసం, పొట్టేలుతో ఒక లీటరు, గొర్రెపిల్లతో ముప్పావు లీటరు ఉండాలి. ఇది సంవత్సరంలో ప్రతినెలా జరగాల్సిన దహనబలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","నిత్యం జరిగే దహనబలీ, దాని పానార్పణ కాకుండా ఒక మేక పిల్లను పాపపరిహారార్థబలిగా యెహోవాకు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","మొదటి నెల 14 వ రోజు యెహోవా పస్కాపండగ వస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ఆ నెల 15 వ రోజు పండగ జరుగుతుంది. ఏడు రోజులు పొంగని రొట్టెలే తినాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","మొదటి రోజు పవిత్ర సంఘం సమకూడాలి. ఆ రోజు మీరు జీవనోపాధికి సంబంధించిన పనులేమీ చెయ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","అయితే, యెహోవాకు దహనబలిగా మీరు రెండు లేగదూడలు, ఒక పొట్టేలు, ఒక సంవత్సరం వయస్సు ఉన్న ఏడు మగ గొర్రెపిల్లలు అర్పించాలి. అవి మీ మందల్లో ఏ దోషం లేనివిగా ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","వాటి నైవేద్యం నూనెతో కలిపిన గోదుమపిండి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ఒక్కొక్క దున్నపోతుతో నూనెతో కలిపిన ఆరు లీటర్ల మెత్తని పిండి, పొట్టేలుతో నూనెతో కలిపిన నాలుగు లీటర్ల మెత్తని పిండి, ఆ ఏడు గొర్రెపిల్లల్లో ఒక్కొక్క గొర్రెపిల్లతో నూనెతో కలిపిన రెండు లీటర్ల మెత్తని పిండి అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","మీకు ప్రాయశ్చిత్తం కలగడానికి పాపపరిహారార్థబలిగా ఒక మేకను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ఉదయాన మీరు నిత్యం అర్పించే దహనబలి కాకుండా వీటిని మీరు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ఆ విధంగానే, ఆ ఏడు రోజుల్లో ప్రతిరోజూ యెహోవాకు ఇష్టమైన సువాసన ఇచ్చే పదార్థం ఆహారంగా అర్పించాలి. నిత్యం జరిగే దహనబలి, దాని పానార్పణ కాకుండా దాన్ని కూడా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ఏడో రోజు పవిత్ర సంఘం సమకూడాలి. ఆ రోజు మీరు జీవనోపాధికి సంబంధించిన పనులేమీ చెయ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","ఇంకా, ప్రథమ ఫలాలు అర్పించే రోజు, అంటే, వారాల పండగరోజు మీరు యెహోవాకు కొత్త పంటలో నైవేద్యం తెచ్చినప్పుడు మీరు పవిత్ర సంఘంగా సమకూడాలి. ఆ రోజు మీరు జీవనోపాధికి సంబంధించిన పనులేమీ చెయ్యకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","యెహోవాకు ఇష్టమైన సువాసన ఇచ్చే దహనబలిగా మీరు రెండు దున్నపోతు దూడలు, ఒక పొట్టేలు, ఒక సంవత్సరం వయస్సు ఉన్న ఏడు మగ గొర్రెపిల్లలను, వాటికి నైవేద్యంగా ప్రతి దున్నపోతు దూడతో ");
INSERT INTO tel2017_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","నూనెతో కలిపిన ఆరు కిలోల మెత్తని పిండిలో మూడు పదో వంతులు, ప్రతి పొట్టేలుతో రెండు పదో వంతులు, ");
INSERT INTO tel2017_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ఆ ఏడు గొర్రెపిల్లల్లో ఒక్కొక్క పిల్లతో ఒక్కొక్క పదో వంతు, ");
INSERT INTO tel2017_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","మీ కోసం ప్రాయశ్చిత్తం చెయ్యడానికి ఒక మేకపిల్ల, అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","నిత్యం జరిగే దహనబలి, దాని నైవేద్యం కాకుండా వాటినీ, వాటి పానార్పణను అర్పించాలి. అవి ఏ దోషం లేనివిగా ఉండాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","ఏడో నెల మొదటి రోజు మీరు పరిశుద్ధ సమాజంగా సమావేశం కావాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ఆ రోజు మీ జీవనోపాధి కోసం ఏ పనీ చేయకూడదు. అది మీరు బాకానాదం చేసే రోజు. ");
INSERT INTO tel2017_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ఏ లోపం లేని ఒక కోడె, ఒక పొట్టేలు, ఒక సంవత్సరం వయసున్న ఏడు మగ గొర్రె పిల్లలను యెహోవాకు ఇష్టమైన సువాసన గల దహనబలిగా అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","వాటి వాటి పద్ధతి ప్రకారం దహనబలిని, దాని నైవేద్యాన్ని, వాటి పానార్పణలు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","వాటి నైవేద్యం నూనెతో కలిపిన గోదుమపిండి, ప్రతి కోడెతో ఆరున్నర కిలోలు, పొట్టేలుతో నాలుగున్నర కిలోలు, ఏడు గొర్రె పిల్లలతో ఒక్కొక్క దానికి రెండుంబావు కిలోలు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","అలాగే మీ కోసం ప్రాయశ్చిత్తం చేయడానికి పాపపరిహార బలిగా ఒక మేకపిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","ఈ ఏడో నెల పదో రోజు మీరు పరిశుద్ధ సమాజంగా సమకూడాలి. అప్పుడు మిమ్మల్ని మీరు అదుపులో పెట్టుకోవాలి, ఆహారం తీసుకోకూడదు. పనులేమీ చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ప్రాయశ్చిత్తం కోసం పాపపరిహార బలి, నిత్యమైన దహనబలి, దాని నైవేద్యం, వాటి వాటి పానార్పణలు కాక, ఒక కోడెదూడ, ఒక పొట్టేలు, ఒక సంవత్సరం వయసున్న ఏడు మగ గొర్రెపిల్లలను యెహోవాకు ఇష్టమైన సువాసనగల దహనబలిగా అర్పించాలి. వాటిలో ఏలోపమూ ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","వాటి నైవేద్యం నూనెతో కలిపిన గోదుమపిండి, ప్రతి కోడెతో ఆరున్నర కిలోలు, పొట్టేలుతో నాలుగున్నర కిలోలు, ");
INSERT INTO tel2017_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ఏడు గొర్రె పిల్లలతో ఒక్కొక్క దానికి రెండుంబావు కిలోలు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","అలాగే మీ కోసం ప్రాయశ్చిత్తం చేయడానికి పాపపరిహార బలిగా ఒక మేకపిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","ఆ తరవాత ఏడో నెల 15 వ రోజున మీరు పరిశుద్ధ సమాజంగా సమావేశం కావాలి. అప్పుడు మీరు జీవనోపాధి కోసం పనులేమీ చేయకూడదు. ఏడు రోజులు యెహోవాకు పండగ జరపాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","దహనబలి, దాని నైవేద్యం, దాని పానార్పణ, కాకుండా, యెహోవాకు ఇష్టమైన సువాసనగల దహనబలిగా 13 కోడెలూ రెండు పొట్టేళ్ళు, ఒక సంవత్సరం వయసున్న 14 గొర్రె పిల్లలను అర్పించాలి. వాటిలో ఏ లోపమూ ఉండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","నైవేద్యంగా ప్రతి కోడెతో ఆరున్నర కిలోలు, ప్రతి పొట్టేలుతో నాలుగున్నర కిలోలు ");
INSERT INTO tel2017_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ప్రతి గొర్రె పిల్లతో రెండుంబావు కిలోలు నూనెతో కలిపిన గోదుమ పిండి తేవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","అలాగే పాపపరిహార బలిగా ఒక మేక పిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","రెండో రోజు దహనబలి దాని నైవేద్యం, వాటి పానార్పణలు కాక ఏ లోపం లేని 12 కోడెలను, రెండు పొట్టేళ్ళను, ఒక సంవత్సరం వయసున్న 14 గొర్రెపిల్లలను ");
INSERT INTO tel2017_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","వాటి వాటి లెక్క ప్రకారం వాటి వాటి నైవేద్యం, ");
INSERT INTO tel2017_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","పానార్పణలతోబాటు పాపపరిహార బలిగా ఒక మేకపిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","మూడో రోజు నిత్యమైన దహనబలి దాని నైవేద్యం, దాని పానార్పణలు కాక ఏ లోపం లేని 11 కోడెలను, రెండు పొట్టేళ్లను, ఒక సంవత్సరం వయసున్న 14 గొర్రెపిల్లలను ");
INSERT INTO tel2017_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","వాటి వాటి లెక్క ప్రకారం వాటి నైవేద్యం, పానార్పణలను ");
INSERT INTO tel2017_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","పాపపరిహార బలిగా ఒక మేకపిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","నాలుగో రోజు నిత్యమైన దహనబలి దాని నైవేద్యం, పానార్పణ కాక ఏ లోపం లేని 10 కోడెలను రెండు పొట్టేళ్లను ఒక సంవత్సరం వయసున్న 14 గొర్రెపిల్లలను వాటి వాటి లెక్క ప్రకారం ");
INSERT INTO tel2017_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","వాటి నైవేద్యం, పానార్పణలను, ");
INSERT INTO tel2017_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","పాప పరిహార బలిగా ఒక మేకపిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","అయిదో రోజు నిత్యమైన దహనబలి, దాని నైవేద్యం, పానార్పణ కాక ఏ లోపం లేని తొమ్మిది కోడెలను, రెండు పొట్టేళ్లను ఒక సంవత్సరం వయసున్న 14 గొర్రెపిల్లలను ");
INSERT INTO tel2017_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","వాటి వాటి లెక్క ప్రకారం, వాటి నైవేద్యం, పానార్పణను, ");
INSERT INTO tel2017_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","అలాగే పాపపరిహార బలిగా ఒక మేకపిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","ఆరో రోజు నిత్యమైన దహనబలి, దాని నైవేద్యం, పానార్పణ కాక ఏ లోపం లేని ఎనిమిది కోడెలను, రెండు పొట్టేళ్లను ఒక సంవత్సరం వయసున్న 14 గొర్రెపిల్లలను, వాటి వాటి లెక్క ప్రకారం, ");
INSERT INTO tel2017_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","వాటి నైవేద్యం, పానార్పణను ");
INSERT INTO tel2017_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","పాపపరిహార బలిగా ఒక మేక పిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","ఏడో రోజు నిత్యమైన దహనబలి, దాని నైవేద్యం, పానార్పణ కాక ఏ లోపం లేని ఏడు కోడెలను, రెండు పొట్టేళ్లను ఒక సంవత్సరం వయసున్న 14 గొర్రె పిల్లలను వాటి వాటి లెక్క ప్రకారం, ");
INSERT INTO tel2017_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","వాటి వాటి నైవేద్యం, పానార్పణలను, ");
INSERT INTO tel2017_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","పాపపరిహార బలిగా ఒక మేక పిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ఎనిమిదో రోజు మీకు ప్రత్యేకమైన రోజు. ఆ రోజు మీరు జీవనోపాధి కోసం ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ఆ రోజు నిత్యమైన దహనబలి, దాని నైవేద్యం, పానార్పణ కాక మీరు యెహోవాకు ఇష్టమైన సువాసనగల దహనబలిగా ఏ లోపం లేని నిర్దోషమైన ఒక కోడెను ఒక పొట్టేలును ఒక సంవత్సరం వయసున్న ఏడు గొర్రెపిల్లలను వాటి వాటి లెక్క ప్రకారం ");
INSERT INTO tel2017_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","వాటితో వాటి వాటి నైవేద్యం, పానార్పణను ");
INSERT INTO tel2017_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","పాపపరిహార బలిగా ఒక మేకపిల్లను అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","మీ మొక్కుబళ్ళు, మీ స్వేచ్ఛార్పణలు మీ దహనబలులు, మీ నైవేద్యాలు, మీ పానార్పణలు, మీ సమాధాన బలులు కాక వీటిని నియమిత సమయాల్లో యెహోవాకు అర్పించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","యెహోవా తనకు ఆజ్ఞాపించిన దాన్నంతా మోషే ఇశ్రాయేలీయులతో పూర్తిగా వివరించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","మోషే ఇశ్రాయేలు గోత్రాల నాయకులతో ఇలా అన్నాడు, ");
INSERT INTO tel2017_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“ఇది యెహోవా ఆజ్ఞ. ఒకడు యెహోవాకు మొక్కుకుంటే లేక ప్రమాణం చేసి ఉంటే, అతడు మాట తప్పకూడదు. తన నోటినుండి వచ్చిన దానంతటినీ అతడు నెరవేర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","తన తండ్రి ఇంట్లో ఉన్న ఒక స్త్రీ యెహోవాకు చేసిన మొక్కుబడి గురించి ఆమె తండ్రి ఎరిగి, ఏమీ మాట్లాడకపోతే ఆమె మొక్కుబడి నిలిచి ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ఆమె ప్రమాణాలు అన్నీ నిలిచి ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","అయితే ఆమె చేసిన ప్రమాణాలను ఆమె తండ్రి విని వాటి విషయంలో ఆక్షేపణ తెలిపి ఉంటే, ఆమె మొక్కుబడులు, ప్రమాణాలు, ఏవీ నిలబడవు. ");
INSERT INTO tel2017_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","ఆమె తండ్రి దానికి ఆక్షేపణ తెలిపాడు కాబట్టి యెహోవా ఆమెను క్షమిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ఆమె వివాహిత అయితే, ఆమె మొక్కుబడులు, తొందరపాటులో చేసిన ప్రమాణాలు ఆమె భర్త ఎరిగి ఏమీ మాట్లాడకపోతే, ఆమె మొక్కుబడులు, ప్రమాణాలు ఆమెపై నిలిచి ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","అయితే ఆమె మొక్కుబడులు, తొందరపాటులో చేసిన ప్రమాణాలు ఆమె భర్త విని వాటి విషయంలో ఆక్షేపణ తెలిపి ఉంటే, అతడు ఆమె మొక్కుబడులను, తొందరపాటుగా చేసిన ప్రమాణాలను రద్దు చేసిన వాడవుతాడు. యెహోవా ఆమెను క్షమిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","వితంతువు గాని విడాకులు ఇచ్చిన స్త్రీ గాని చేసిన మొక్కుబడులు అన్నీ ఆమె మీద నిలిచి ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","ఆమె తన భర్త ఇంట్లో ఉన్నప్పుడు మొక్కుబడులు, ప్రమాణాలు చేసి ఉంటే, ");
INSERT INTO tel2017_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","వాటిని గురించి ఆమె భర్త విని ఏ ఆక్షేపణా చేయకుండా ఉంటే, ఆమె మొక్కుబడులు, ప్రమాణాలు, అన్నీ నిలిచి ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ఆమె భర్త వాటి గురించి విన్న రోజునే వాటిని పూర్తిగా రద్దు చేసి ఉంటే, ఆమె మొక్కుబడులు, ప్రమాణాలు గురించిన ఆమె మాటలు ఏవీ నిలబడవు. ఆమె భర్త వాటిని రద్దుచేశాడు కాబట్టి యెహోవా ఆమెను క్షమిస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ఒక స్త్రీ చేసిన ప్రతి మొక్కుబడిని, ప్రమాణపూర్వకంగా తన మీద మోపుకొన్న ప్రతి బాధ్యతను ఆమె భర్త స్థిరపరచవచ్చు, రద్దు చేయవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","అలా కాక ఆమె భర్త ఎప్పటికప్పుడు దాని విషయం మౌనంగా ఉంటూ వస్తే, అతడు ఆమె చేసిన మొక్కుబడులనూ ప్రమాణాలనూ స్థిరపరచిన వాడవుతాడు. అతడు వాటిని విన్న రోజు మౌనంగా ఉండడం ద్వారా వాటిని స్థిరపరిచాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","అతడు వాటిని గురించి విన్న చాలా కాలం తరువాత వాటిని రద్దుచేస్తే, అతడు ఆమె దోషశిక్షను తానే భరిస్తాడు.” ");
INSERT INTO tel2017_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ఇవి భర్తను గూర్చీ భార్యను గూర్చీ, తండ్రిని గూర్చీ బాల్యంలో తన తండ్రి ఇంట్లో ఉన్న కుమార్తెను గూర్చీ యెహోవా మోషేకిచ్చిన ఆజ్ఞలు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","యెహోవా “మిద్యానీయులు ఇశ్రాయేలీయులకు చేసిన దానికి ప్రతీకారం తీర్చుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","ఆ తరవాత నీవు చనిపోయి నీ పూర్వీకుల దగ్గరికి చేరుకుంటావు” అని మోషేకు చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","అప్పుడు మోషే “మీలో కొందరు యుద్ధానికి సిద్ధపడి మిద్యానీయుల మీదికి పోయి వారికి యెహోవా విధించిన ప్రతిదండన చేయండి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ఇశ్రాయేలీయుల ప్రతి గోత్రం నుండి వెయ్యిమంది చొప్పున యుద్ధానికి పంపండి” అని ప్రజలతో అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ఆ విధంగా గోత్రానికి వెయ్యి మంది చొప్పున, ఇశ్రాయేలీయుల మొత్తం సైన్యంలో నుండి పన్నెండు వేల మంది యుద్ధ వీరులను సిద్ధం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","మోషే వారిని, యాజకుడైన ఎలియాజరు కుమారుడు ఫీనెహాసుతో పంపించాడు. అతనికి పరిశుద్ధమైన కొన్ని వస్తువులు, యుద్ధంలో ఊదటానికి బాకాలు పంపాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","యెహోవా మోషేకు ఆజ్ఞాపించినట్టే ఇశ్రాయేలీయులు మిద్యానీయులతో యుద్ధం చేసి మగవారందరినీ చంపేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","వారు కాక మిద్యాను రాజులు, ఎవీ, రేకెము, సూరు, హూరు, రేబ అనే ఐదుగుర్ని చంపారు. బెయోరు కొడుకు బిలామును కత్తితో చంపేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","వారు మిద్యాను స్త్రీలను, వారి చిన్నపిల్లలను చెరపట్టుకుని, వారి పశువులు, గొర్రెలు, మేకలు అన్నిటిని, వారి సమస్తాన్ని దోచుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","వారి పట్టణాలు, కోటలు అన్నిటిని తగలబెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","వారు మనుషులను గాని పశువులను గాని మిద్యానీయుల ఆస్తి అంతటినీ కొల్లగొట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","తరువాత వారు దానంతటినీ, చెరపట్టిన వారిని మోయాబు మైదానాల్లో యెరికో దగ్గర యొర్దాను పక్కన విడిది చేసి ఉన్న మోషే, యాజకుడు ఎలియాజరు దగ్గరికి, ఇశ్రాయేలీయుల సమాజం దగ్గరికి తీసుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","అప్పుడు మోషే, యాజకుడు ఎలియాజరు, సమాజ నాయకులంతా విడిది బయటికి వారికి ఎదురు వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","అప్పుడు మోషే యుద్ధం నుండి వచ్చిన సహస్రాధిపతులు, శతాధిపతుల పైన కోపపడ్డాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","అతడు వారితో “మీరు మిద్యాను స్త్రీలను ఎందుకు బతకనిచ్చారు? ");
INSERT INTO tel2017_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","బిలాము సలహా ప్రకారం పెయోరు విషయంలో ఇశ్రాయేలు ప్రజలు యెహోవాకు ఎదురు తిరిగేలా చేసింది వారే కదా! అందుచేత యెహోవా మన సమాజంలో తెగులు పుట్టించాడు కదా. ");
INSERT INTO tel2017_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","కాబట్టి మీరు మగ పిల్లలందరినీ మగవారితో సంబంధం ఉన్న ప్రతి స్త్రీనీ చంపండి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","మగవారితో సంబంధం లేని ప్రతి ఆడపిల్లను మీ కోసం బతకనీయండి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","మీరు ఏడు రోజులు విడిది బయట ఉండాలి. మీలో మనిషిని చంపిన ప్రతివాడూ, చనిపోయిన వారిని తాకిన ప్రతివాడూ, మీరు, మీరు చెరగా పట్టుకొచ్చిన వారు, మూడో రోజున, ఏడో రోజున మిమ్మల్ని మీరు శుద్ధి చేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","మీరు మీ వస్త్రాలను, చర్మంతో, మేక వెండ్రుకలతో చేసిన వస్తువులను, చెక్కతో చేసిన వస్తువులను అన్నిటినీ శుద్ధి చేయాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","అప్పుడు యాజకుడు ఎలియాజరు యుద్ధానికి వెళ్ళిన సైనికులతో “యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు, ");
INSERT INTO tel2017_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","‘అగ్నితో చెడిపోని బంగారు, వెండి, ఇత్తడి, ఇనుము, తగరం, సీసం, వీటితో చేసిన వస్తువులన్నిటినీ ");
INSERT INTO tel2017_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","మంటల్లో వేసి తీయడం ద్వారా శుద్ధి చేయాలి. వాటిని పాపపరిహార జలంతో కూడా శుద్ధి చేయాలి. అగ్నితో చెడిపోయే ప్రతి వస్తువును నీళ్లలో వేసి తీయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ఏడో రోజు మీరు మీ బట్టలు ఉతుక్కొని శుద్ధి అయిన తరవాత విడిదిలోకి రావచ్చు.’” అన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","యెహోవా మోషేకు ఇంకా ఇలా ఆజ్ఞాపించాడు, ");
INSERT INTO tel2017_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“నువ్వూ యాజకుడు ఎలియాజరు సమాజంలోని పూర్వీకుల వంశాల నాయకులు మీరు చెరగా పట్టుకున్న మనుషులను, పశువులను లెక్కబెట్టి రెండు భాగాలు చేయండి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","సైన్యంగా యుద్ధానికి వెళ్ళిన వారికి సగం, మిగిలిన సర్వసమాజానికి సగం పంచిపెట్టండి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","యుద్ధానికి వెళ్ళిన సైనికులపై యెహోవా కోసం పన్ను వేసి, ఆ మనుషుల్లో, పశువుల్లో, గాడిదల్లో, గొర్రె మేకల్లో ఐదు వందలకు ఒకటి చొప్పున వారి సగభాగంలో నుండి తీసుకుని ");
INSERT INTO tel2017_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","యెహోవాకు అర్పణగా యాజకుడు ఎలియాజరుకు ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","అదే విధంగా మిగిలిన ఇశ్రాయేలీయుల సగంలో నుండి మనుషుల్లో, పశువుల్లో, గాడిదల్లో, గొర్రె మేకల్లో, అన్ని రకాల జంతువుల్లోనుండి 50 కి ఒకటి చొప్పున తీసుకుని యెహోవా మందిరాన్ని కాపాడే లేవీయులకు ఇవ్వాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","యెహోవా మోషేకు ఆజ్ఞాపించిన విధంగా మోషే, యాజకుడు ఎలియాజరు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ఆ సైనికులు దోచుకున్నది గాక మిగిలింది ");
INSERT INTO tel2017_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","6, 75,000 గొర్రెలు లేక మేకలు, ");
INSERT INTO tel2017_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","72,000 పశువులు, 61,000 గాడిదలు, ");
INSERT INTO tel2017_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","32,000 మంది మగవారితో సంబంధం లేని స్త్రీలు ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","అందులో సగం యుద్ధానికి వెళ్ళిన వారి వంతు, గొర్రె మేకలు 3, 37, 500. వాటిలో యెహోవాకు చెందిన పన్ను 675. పశువుల్లో సగం 36,000. ");
INSERT INTO tel2017_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","వాటిలో యెహోవా పన్ను 72. ");
INSERT INTO tel2017_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","గాడిదల్లో సగం 30, 500. ");
INSERT INTO tel2017_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","వాటిలో యెహోవా పన్ను 61. ");
INSERT INTO tel2017_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","మనుషుల్లో సగం 16,000 మంది. వారిలో యెహోవా పన్ను 32 మంది. ");
INSERT INTO tel2017_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","యెహోవా మోషేకు ఆజ్ఞాపించిన విధంగా అతడు యెహోవాకు చెందాల్సిన అర్పణను యాజకుడు ఎలియాజరుకు ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","మోషే సైనికుల నుండి తీసుకుని ఇశ్రాయేలీయులకు ఇచ్చిన సగంలో నుండి లేవీయులకు ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","3, 37, 500 గొర్రె మేకలు, ");
INSERT INTO tel2017_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 పశువులు, 30, 500 గాడిదలు, ");
INSERT INTO tel2017_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","16,000 మంది మనుషులు సమాజానికి రావలసిన సగం. ");
INSERT INTO tel2017_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","మోషే ఆ సగం నుండి మనుషుల్లో, జంతువుల్లో, ");
INSERT INTO tel2017_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","50 కి ఒకటి చొప్పున తీసి, యెహోవా తనకు ఆజ్ఞాపించిన విధంగా యెహోవా మందిరాన్ని కాపాడే లేవీయులకు ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","అప్పుడు సైన్యంలో వేలమందికి, వందల మందికి అధిపతులు మోషే దగ్గరికి వచ్చి ");
INSERT INTO tel2017_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“నీ సేవకులైన మేము మా కింద ఉన్న సైనికులందరినీ లెక్కపెట్టాం. మొత్తానికి ఒక్కడు కూడా తగ్గలేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","కాబట్టి యెహోవా సన్నిధిలో మా కోసం ప్రాయశ్చిత్తం కలిగేలా మాలో ప్రతి ఒక్కడికి దొరికిన బంగారు నగలు, గొలుసులు, కడియాలు, ఉంగరాలు, పోగులు, పతకాలు యెహోవాకు అర్పణ తెచ్చాం” అని చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","మోషే, యాజకుడు ఎలియాజరు ఆ బంగారు నగలను వారి నుండి తీసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","వేలమందికి, వందల మందికి అధిపతులైన నాయకులు యెహోవాకు అర్పించిన బంగారం మొత్తం 16, 750 తులాలు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ఆ సైనికుల్లో ప్రతివాడూ తన మట్టుకు తాను దోపుడు సొమ్ము తెచ్చుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","అప్పుడు మోషే, యాజకుడు ఎలియాజరు వేలమందికి, వందల మందికి అధిపతుల దగ్గర తీసుకున్న బంగారాన్ని ఇశ్రాయేలీయులకు జ్ఞాపకార్థంగా ప్రత్యక్ష గుడారంలో ఉంచారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","రూబేనీయులకు, గాదీయులకు, పశువులు అతి విస్తారంగా ఉండడం వలన యాజెరు, గిలాదు ప్రాంతాలు మందలకు తగిన స్థలమని వారు గ్రహించారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","వారు మోషేతో, యాజకుడు ఎలియాజరుతో సమాజ నాయకులతో ");
INSERT INTO tel2017_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“అతారోతు, దీబోను, యాజెరు, నిమ్రా, హెష్బోను, ఏలాలే, షెబాము, నెబో, బెయోను అనే ప్రాంతాలు, ");
INSERT INTO tel2017_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","అంటే ఇశ్రాయేలు ప్రజలందరి ఎదుట యెహోవా జయించిన దేశం పశువుల మందలకు అనువైంది. మీ సేవకులైన మాకు మందలు ఉన్నాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","కాబట్టి మా మీద మీకు దయ కలిగితే, మమ్మల్ని యొర్దాను నది దాటించవద్దు. మాకు ఈ దేశాన్ని వారసత్వంగా ఇవ్వండి” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","అప్పుడు మోషే గాదీయులకు, రూబేనీయులకు ఇలా జవాబిచ్చాడు. “మీ సోదరులు యుద్ధాలు చేస్తూ ఉంటే మీరు ఇక్కడే ఉండిపోవచ్చా? ");
INSERT INTO tel2017_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","యెహోవా ఇశ్రాయేలు ప్రజలకు ఇచ్చిన దేశానికి వెళ్ళకుండా మీరు వారి హృదయాలను ఎందుకు నిరుత్సాహ పరుస్తున్నారు? ");
INSERT INTO tel2017_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ఆ దేశాన్ని చూసి రావడానికి కాదేషు బర్నేయలో నేను మీ తండ్రులను పంపినప్పుడు వారు కూడా ఇలాగే చేశారు కదా. ");
INSERT INTO tel2017_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","వారు ఎష్కోలు లోయలోకి వెళ్లి ఆ దేశాన్ని చూసి ఇశ్రాయేలు ప్రజలను అధైర్యపరిచారు కాబట్టి యెహోవా తమకిచ్చిన దేశంలో ప్రవేశించలేకపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ఆ రోజు యెహోవా కోపం తెచ్చుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","ఇరవై సంవత్సరాలకు మించి, ఐగుప్తుదేశం నుండి వచ్చిన మనుషుల్లో యెహోవాను పూర్ణ మనస్సుతో అనుసరించిన కెనెజీయుడు, యెఫున్నె కొడుకు కాలేబు, నూను కొడుకు యెహోషువ తప్ప ");
INSERT INTO tel2017_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","మరి ఎవ్వడూ పూర్ణమనస్సుతో నన్ను అనుసరించలేదు కాబట్టి నేను అబ్రాహాము, ఇస్సాకు, యాకోబులకు ఇస్తానని ప్రమాణం చేసిన దేశాన్ని మరి ఎవరూ చూడనే చూడరు, అని శపథం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","అప్పుడు ఇశ్రాయేలు ప్రజల మీద యెహోవా కోపం రగులుకోవడం వల్ల ఆయన దృష్ఠికి చెడుతనం చూపిన ఆ తరం వారంతా నాశనం అయ్యే వరకూ వారిని అరణ్యంలో తిరిగేలా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ఇప్పుడు ఇశ్రాయేలు ప్రజల మీద యెహోవాకు మరింత కోపం పుట్టించేలా ఆ పాపుల పిల్లలైన మీరు వారి స్థానంలో బయలుదేరారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","మీరు ఆయన్ని అనుసరించకుండా వెనక్కి తగ్గిపోతే ఆయన ఈ ప్రజలందరినీ ఈ అడవిలోనే నిలిపివేస్తాడు. ఆ విధంగా మీరు ఈ ప్రజలందరి నాశనానికి కారకులౌతారు.” ");
INSERT INTO tel2017_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","అందుకు వారు అతనితో “మేము ఇక్కడ మా పశువుల కోసం దొడ్లూ, మా పిల్లల కోసం ఊరులూ కట్టుకుంటాం. ");
INSERT INTO tel2017_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ఇశ్రాయేలు ప్రజలను వారివారి స్థలాలకు చేర్చే వరకూ మేము యుద్ధానికి సిద్ధపడి వారి ముందు సాగిపోతాం. అయితే మా పిల్లలు ఈ ప్రాంత ప్రజల భయం వలన ప్రాకారాలున్న ఊర్లలో నివసించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ఇశ్రాయేలీయుల్లో ప్రతివాడూ తన తన వారసత్వాన్ని పొందేవరకూ మా ఇళ్ళకు తిరిగి రాము. ");
INSERT INTO tel2017_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","తూర్పున యొర్దాను ఇవతల మాకు వారసత్వం దొరికింది కాబట్టి ఇక యొర్దాను అవతల వారితో వారసత్వం అడగం” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","అప్పుడు మోషే వారితో “మీరు మీ మాట మీద నిలబడి యెహోవా సన్నిధిలో యుద్ధానికి సిద్ధపడి యెహోవా తన ఎదుటనుండి తన శత్రువులను వెళ్లగొట్టే వరకూ ");
INSERT INTO tel2017_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","యెహోవా సన్నిధిలో మీరంతా యొర్దాను అవతలికి వెళ్ళి ");
INSERT INTO tel2017_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ఆ దేశాన్ని జయించిన తరవాత మీరు తిరిగి రావచ్చు. మీరు యెహోవా దృష్టికీ ఇశ్రాయేలీయుల దృష్టికీ నిర్దోషులుగా ఉంటారు. అప్పుడు ఈ దేశం యెహోవా సన్నిధిలో మీకు వారసత్వం అవుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","మీరు అలా చేయకపోతే యెహోవా దృష్టికి పాపం చేసిన వారవుతారు కాబట్టి మీ పాపం మిమ్మల్ని పట్టుకొంటుందని తెలుసుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","మీరు మీ పిల్లల కోసం ఊర్లను, మీ పశువుల కోసం దొడ్లను కట్టుకుని మీరు చెప్పిన ప్రకారం చేయండి అన్నాడు.” ");
INSERT INTO tel2017_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","అందుకు గాదీయులు, రూబేనీయులు మోషేతో “మా యజమానివి నువ్వు ఆజ్ఞాపించినట్టు నీ సేవకులైన మేము చేస్తాం. ");
INSERT INTO tel2017_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","మా పిల్లలు, భార్యలు, మా ఆవుల మందలు గిలాదు ఊళ్ళలో ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","నీ సేవకులైన మేము, అంటే మా సైన్యంలో ప్రతి యోధుడు మా యజమానివి నువ్వు చెప్పినట్టు యెహోవా సన్నిధిలో యుద్ధం చేయడానికి యొర్దాను అవతలికి వస్తాము” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","కాబట్టి మోషే వారిని గురించి యాజకుడైన ఎలియాజరుకు, నూను కుమారుడు యెహోషువకు, ఇశ్రాయేలు గోత్రాల్లో పూర్వీకుల వంశాల నాయకులకు ఇలా ఆజ్ఞాపించాడు, ");
INSERT INTO tel2017_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“గాదీయులు, రూబేనీయులు అందరూ యెహోవా సన్నిధిలో యుద్ధానికి సిద్దపడి మీతో కూడా యొర్దాను అవతలికి వస్తే, ఆ దేశాన్ని మీరు జయించిన తరవాత మీరు గిలాదు దేశాన్ని వారికి వారసత్వంగా ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","కాని వారు యుద్ధానికి సిద్ధపడి మీతో కలిసి అవతలకి రాకపోతే వారు కనాను దేశంలో మీ మధ్యనే వారసత్వం పొందుతారు” ");
INSERT INTO tel2017_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","దానికి గాదీయులు, రూబేనీయులు “యెహోవా నీ సేవకులైన మాతో చెప్పినట్టే చేస్తాం. ");
INSERT INTO tel2017_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","మేము యెహోవా సన్నిధిలో యుద్ధానికి సిద్ధపడి నది దాటి కనాను దేశంలోకి వెళ్తాం. అప్పుడు యొర్దాను ఇవతల మేము వారసత్వం పొందుతాం” అని జవాబిచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","అప్పుడు మోషే వారికి, అంటే గాదీయులకు, రూబేనీయులకు, యోసేపు కుమారుడు మనష్షే అర్థగోత్రం వారికి, అమోరీయుల రాజైన సీహోను రాజ్యాన్ని, బాషాను రాజైన ఓగు రాజ్యాన్ని, వాటి ఊళ్ళన్నిటినీ ఆ దేశాల చుట్టూ ఉన్న గ్రామాలనూ ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","గాదీయులు దీబోను, అతారోతు, అరోయేరు, అత్రోతు, షోపాను, ");
INSERT INTO tel2017_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","యాజెరు, యొగ్బెహ, బేత్నిమ్రా, బేత్హారాను ");
INSERT INTO tel2017_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","అనే ఊళ్ళలో ప్రాకారాలు, పశువుల దొడ్లు కట్టుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","రూబేనీయులు హెష్బోను, ఏలాలే, కిర్యతాయిము, నెబో, బయల్మెయోను, ");
INSERT INTO tel2017_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","షిబ్మా అనే ఊళ్లు కట్టి, వాటికి కొత్త పేర్లు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","మనష్షే సంతానం అయిన మాకీరీయులు గిలాదుపై దండెత్తి దాన్ని ఆక్రమించి దానిలోని అమోరీయులను వెళ్లగొట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","మోషే మనష్షే కొడుకు మాకీరుకు గిలాదును ఇచ్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","అతని సంతానం అక్కడ నివసించింది. మనష్షే కొడుకు యాయీరు వెళ్లి అక్కడి గ్రామాలను ఆక్రమించి వాటికి యాయీరు గ్రామాలు అని పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","నోబహు వెళ్లి కెనాతును దాని గ్రామాలను ఆక్రమించి దానికి నోబహు అని తన పేరు పెట్టాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","మోషే అహరోనుల నాయకత్వంలో తమ తమ సేనల ప్రకారం ఐగుప్తుదేశం నుండి ఇశ్రాయేలీయులు చేసిన ప్రయాణాలు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","యెహోవా ఆజ్ఞాపించిన ప్రకారం, మోషే వారు ప్రయాణించిన మార్గాల వివరాలను రాశాడు. ఇవి వారి ప్రయాణ మార్గాల వివరాలు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","మొదటి నెల 15 వ రోజున వారు రామెసేసు నుండి పస్కా పండగ మరునాడు ఇశ్రాయేలీయులు జయోత్సాహంతో బయలుదేరారు. అప్పుడు ఐగుప్తీయులు తమ మధ్య యెహోవా హతం చేసిన మొదటి సంతానాలను పాతిపెట్టుకుంటూ వారిని చూస్తూ ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ఆ విధంగా ఐగుప్తీయుల దేవుళ్ళకు యెహోవా తీర్పు తీర్చాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ఇశ్రాయేలీయులు రామెసేసు నుండి సుక్కోతుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","సుక్కోతు నుండి అడవి చివరిలో ఉన్న ఏతాముకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ఏతాము నుండి బయల్సెఫోను ఎదుట ఉన్న పీహహీరోతు వైపు తిరిగి మిగ్దోలు దగ్గర ఆగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","పీహహీరోతు నుండి సముద్రం మధ్య నుండి అరణ్యంలోకి వెళ్ళి ఏతాము అరణ్యంలో మూడు రోజుల ప్రయాణం చేసి మారాకు వచ్చారు. మారా నుండి ఏలీముకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ఏలీములో 12 నీటిబుగ్గలు, 70 ఈతచెట్లు ఉన్నాయి. వారక్కడ ఆగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ఏలీము నుండి వారు ఎర్ర సముద్రం దగ్గరికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","అక్కడినుండి సీను అరణ్యంలో ఆగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","సీను అరణ్యం నుండి దోపకాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","దోపకా నుండి ఆలూషుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ఆలూషు నుండి రెఫీదీముకు వచ్చారు. అక్కడ వారికి తాగడానికి నీళ్లు లేవు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","రెఫీదీము నుండి సీనాయి అరణ్యంలో ఆగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","అక్కడి నుండి కిబ్రోతు హత్తావాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","కిబ్రోతు హత్తావా నుండి హజేరోతు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","హజేరోతు నుండి రిత్మా వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","రిత్మా నుండి రిమ్మోను పారెసుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","రిమ్మోను పారెసు నుండి లిబ్నాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","లిబ్నాలో నుండి రీసాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","రీసా నుండి కెహేలాతాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","కెహేలాతా నుండి బయలుదేరి షాపెరు కొండ దగ్గర ఆగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","షాపెరు కొండ దగ్గర నుండి హరాదాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","హరాదా నుండి మకెలోతుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","మకెలోతు నుండి తాహతుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","తాహతు నుండి తారహుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","తారహు నుండి మిత్కాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","మిత్కా నుండి హష్మోనాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","హష్మోనా నుండి మొసేరోతుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","మొసేరోతు నుండి బెనేయాకానుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","బెనేయాకాను నుండి హోర్‌హగ్గిద్గాదుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","హోర్‌హగ్గిద్గాదు నుండి యొత్బాతాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","యొత్బాతా నుండి ఎబ్రోనాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ఎబ్రోనా నుండి ఎసోన్గెబెరుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ఎసోన్గెబెరు నుండి కాదేషు అని పిలిచే సీను అరణ్యానికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","కాదేషు నుండి ఎదోము దేశం అంచులో ఉన్న హోరు కొండ దగ్గర ఆగారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","యెహోవా ఆజ్ఞ ప్రకారం యాజకుడు అహరోను హోరు కొండ ఎక్కి అక్కడ చనిపోయాడు. అది ఇశ్రాయేలీయులు ఐగుప్తు దేశం నుండి వచ్చిన 40 వ సంవత్సరం అయిదో నెల మొదటి రోజు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","అహరోను 123 సంవత్సరాల వయసులో హోరు కొండమీద చనిపోయాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","అప్పుడు కనాను దేశపు దక్షిణాన నివసించే అరాదు రాజైన కనానీయుడు ఇశ్రాయేలీయులు వచ్చిన సంగతి విన్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","వారు హోరు కొండ నుండి సల్మానాకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","సల్మానాలో నుండి పూనోనుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","పూనోనులో నుండి ఓబోతుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ఓబోతు నుండి మోయాబు పొలిమేర దగ్గర ఉన్న ఈయ్యె అబారీముకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ఈయ్యె అబారీము నుండి దీబోను గాదుకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","దీబోను గాదు నుండి అల్మోను దిబ్లాతాయిముకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","అల్మోను దిబ్లాతాయిము నుండి నెబో ఎదురుగా ఉన్న అబారీము కొండలకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","అబారీము కొండల నుండి యెరికో దగ్గర యొర్దానుకు దగ్గరగా ఉన్న మోయాబు మైదానాలకు వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","వారు మోయాబు మైదానాల్లో బెత్యేషీమోతు మొదలు ఆబేలు షిత్తీము వరకూ యొర్దాను దగ్గర విడిది చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","యెరికో దగ్గర, అంటే యొర్దానుకు పక్కనే ఉన్న మోయాబు మైదానాల్లో యెహోవా మోషేకు ఇలా ఆజ్ఞాపించాడు, ");
INSERT INTO tel2017_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“నువ్వు ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పు, ‘మీరు యొర్దానును దాటి కనాను దేశాన్ని చేరిన తరువాత ");
INSERT INTO tel2017_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ఆ దేశ ప్రజలందరినీ మీ ఎదుట నుండి వెళ్లగొట్టి, వారి ప్రతిమలన్నిటినీ ధ్వంసం చేసి వారి పోత విగ్రహాలన్నిటిని పగలగొట్టి వారి ఉన్నత ప్రదేశాల్లో ఉన్న వారి పూజా స్థలాలను పాడుచేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ఆ దేశాన్ని స్వాధీనం చేసుకుని దానిలో నివసించాలి. ఎందుకంటే ఆ దేశాన్ని మీకు వారసత్వంగా నేను మీ స్వాధీనం చేశాను. ");
INSERT INTO tel2017_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","మీరు మీ వంశాల ప్రకారం చీట్లు వేసి ఆ దేశాన్ని వారసత్వంగా పంచుకోవాలి. ఎక్కువ మందికి ఎక్కువ, తక్కువ మందికి తక్కువ వారసత్వం ఇవ్వాలి. చీటీ ప్రకారం ఎవరికి ఏ స్థలం వస్తుందో ఆ స్థలమే అతడు తీసుకోవాలి. మీ తండ్రుల గోత్రాల ప్రకారం మీరు వారసత్వం పొందాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","అయితే మీరు మీ ఎదుట నుండి ఆ దేశ ప్రజలను వెళ్లగొట్టకపోతే, మీరు ఎవరిని ఉండనిచ్చారో వారు మీ కళ్ళలో ముళ్ళుగా, మీ పక్కలో శూలాలుగా ఉండి, మీరు నివసించే ఆ దేశంలో వారు మిమ్మల్ని బాధలకు గురిచేస్తారు. ");
INSERT INTO tel2017_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","అంతేగాక నేను వారికి ఏం చేయాలనుకున్నానో దానినే మీకు కూడా చేస్తాను.’” ");
INSERT INTO tel2017_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు. “నువ్వు ఇశ్రాయేలీయులతో చెప్పు, ");
INSERT INTO tel2017_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","‘కనాను దేశంలో, అంటే ఏ దేశాన్ని మీరు చీట్లు వేసి వారసత్వంగా పంచుకోబోతున్నారో ఆ దేశంలో మీరు ప్రవేశిస్తున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","మీ దక్షిణపు సరిహద్దు సీను అరణ్యం మొదలు ఎదోము సరిహద్దు వరకూ, అంటే, ఉప్పు సముద్రం తూర్పు తీరం వరకూ ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","మీ సరిహద్దు దక్షిణం మొదలు అక్రబ్బీము కనుమ దగ్గర తిరిగి సీను వరకూ వ్యాపిస్తుంది. అది దక్షిణం నుండి కాదేషు బర్నేయ వరకూ వ్యాపించి, అక్కడ నుండి హసరద్దారు వరకూ పోయి, అక్కడ నుండి అస్మోను వరకూ కొనసాగుతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","అస్మోను నుండి ఐగుప్తు నది వరకూ సరిహద్దు తిరిగి సముద్రం వరకూ వ్యాపిస్తుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","మీకు పడమటి సరిహద్దుగా మహాసముద్రం ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","మీ ఉత్తరపు సరిహద్దును మహాసముద్రం నుండి హోరు కొండ దాకా, ");
INSERT INTO tel2017_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","హోరు కొండ నుండి హమాతుకు వెళ్ళే దారి వరకూ ఏర్పాటు చేసుకోవాలి. ఆ సరిహద్దు సెదాదు వరకూ, ");
INSERT INTO tel2017_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","అక్కడ నుండి జిప్రోను వరకూ వ్యాపిస్తుంది. దాని అంచు హసరేనాను దగ్గర ఉంటుంది. అది మీకు ఉత్తరపు సరిహద్దు. ");
INSERT INTO tel2017_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","తూర్పు సరిహద్దు హసరేనాను నుండి షెపాము వరకూ మీరు లెక్కించుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","అది షెపాము నుండి అయీనుకు తూర్పున రిబ్లా వరకూ ఉంటుంది. ఆ సరిహద్దు దిగి తూర్పున కిన్నెరెతు సముద్రపు ఒడ్డును తాకుతూ ఉంటుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","అది యొర్దాను నది వరకూ దిగి ఉప్పు సముద్రం వరకూ వ్యాపిస్తుంది. ఆ దేశం చుట్టూ ఉన్న సరిహద్దుల మధ్య ఉన్న ప్రాంతమంతా మీ దేశం’ అని వారితో చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","మోషే ఇశ్రాయేలీయులతో “ఇది మీరు చీట్లు వేసుకుని పొందే దేశం. తొమ్మిది గోత్రాలకు, ఒక అర్థ గోత్రానికి ఇవ్వమని యెహోవా ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ఎందుకంటే తమ పూర్వీకుల కుటుంబాల ప్రకారం రూబేనీయులు, గాదీయులు తమ వారసత్వాలను పొందారు. ");
INSERT INTO tel2017_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","అలాగే మనష్షే అర్థగోత్రం కూడా వారసత్వం పొందింది. ఆ రెండు గోత్రాలు, అర్థ గోత్రం, సూర్యోదయం దిక్కున, అంటే తూర్పున యెరికో దగ్గర యొర్దాను అవతల తమ తమ వారసత్వాలను పొందారు” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","అప్పుడు యెహోవా మోషేతో ఇలా చెప్పాడు, ");
INSERT INTO tel2017_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ఆ దేశాన్నిమీకు వారసత్వంగా పంచి పెట్టాల్సిన వ్యక్తులు ఎవరంటే, యాజకుడు ఎలియాజరు, నూను కొడుకు యెహోషువ. ");
INSERT INTO tel2017_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","వారు కాక ఆ దేశాన్ని మీకు పంచిపెట్టడానికి ప్రతి గోత్రం నుండి ఒక్క నాయకుణ్ణి ఎన్నుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","వారెవరంటే, యూదా గోత్రంలో యెఫున్నె కొడుకు కాలేబు, ");
INSERT INTO tel2017_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","షిమ్యోను గోత్రంలో అమీహూదు కొడుకు షెమూయేలు, ");
INSERT INTO tel2017_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","బెన్యామీను గోత్రంలో కిస్లోను కొడుకు ఎలీదాదు. ");
INSERT INTO tel2017_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","దాను గోత్రంలో యొగ్లి కొడుకు బుక్కీ నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","యోసేపు కొడుకుల్లో ఏఫోదు కొడుకు హన్నీయేలు, మనష్షే గోత్ర నాయకుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ఎఫ్రాయిము గోత్రంలో షిప్తాను కొడుకు కెమూయేలు నాయకుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","జెబూలూను గోత్రంలో పర్నాకు కొడుకు ఎలీషాపాను నాయకుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ఇశ్శాఖారీయుల గోత్రంలో అజాను కొడుకు పల్తీయేలు నాయకుడు, ");
INSERT INTO tel2017_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ఆషేరీయుల గోత్రంలో షెలోమి కొడుకు అహీహూదు నాయకుడు. ");
INSERT INTO tel2017_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","నఫ్తాలీయుల గోత్రంలో అమీహూదు కొడుకు పెదహేలు నాయకుడు.” ");
INSERT INTO tel2017_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","వీరంతా కనాను దేశంలో ఇశ్రాయేలీయులకు వారి వారి వారసత్వాలను పంచిపెట్టడానికి యెహోవా ఆజ్ఞాపించినవారు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","యెరికో దగ్గర యొర్దానుకు సమీపంలోని మోయాబు మైదానాల్లో యెహోవా మోషేకు ఈ విధంగా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“తాము పొందే వారసత్వాల్లో లేవీయులు నివసించడానికి వారికి పట్టణాలను ఇవ్వాలని ఇశ్రాయేలీయులకు ఆజ్ఞాపించు. ఆ పట్టణాల చుట్టూ ఉన్న పల్లెలను కూడా లేవీయులకు ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","అవి వారి నివాసానికి వారి పట్టణాలవుతాయి. వాటి పొలాలు వారి పశువులకు, మందలకు, వారి ఆలమందలకు ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","మీరు లేవీయులకిచ్చే పట్టణాల గోడ మొదలుకుని చుట్టూ వెయ్యి మూరలు, ");
INSERT INTO tel2017_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ఆ పట్టణాల బయట నుండి తూర్పున రెండు వేల మూరలు, దక్షిణాన రెండు వేల మూరలు, పడమర రెండు వేల మూరలు, ఉత్తరాన రెండు వేల మూరలు కొలవాలి. ఆ మధ్యలో పట్టణాలుండాలి. అవి వారి పట్టణాలకు పల్లెలుగా ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","మీరు లేవీయులకు ఇచ్చే పట్టణాల్లో ఆరు ఆశ్రయపురాలుండాలి. హత్య చేసినవాడు వాటిలోకి పారిపోగలిగేందుకు వీలుగా వాటిని నియమించాలి. అవి గాక 42 పట్టణాలను కూడా ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","వాటి పల్లెలతో కలిపి మీరు లేవీయులకు ఇవ్వాల్సిన పట్టణాలన్నీ నలభై ఎనిమిది. ");
INSERT INTO tel2017_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","మీరిచ్చే పట్టణాలు ఇశ్రాయేలీయుల వారసత్వంలో నుండే ఇవ్వాలి. ఎక్కువ భూమి ఉన్నవారు ఎక్కువగా, తక్కువ భూమి ఉన్నవారు తక్కువగా ఇవ్వాలి. ప్రతి గోత్రం తాను పొందే వారసత్వం ప్రకారం తన తన పట్టణాల్లో కొన్నిటిని లేవీయులకు ఇవ్వాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","యెహోవా ఇంకా మోషేకు ఇలా ఆజ్ఞాపించాడు. “నువ్వు ఇశ్రాయేలీయులతో చెప్పు, ");
INSERT INTO tel2017_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","మీరు యొర్దాను దాటి కనాను దేశంలోకి వెళ్లిన తరవాత ");
INSERT INTO tel2017_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ఆశ్రయపురాలుగా ఉండటానికి పట్టణాలను ఎన్నిక చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","పొరబాటున ఎవరినైనా చంపినవాడు వాటిలోకి పారిపోవచ్చు. తీర్పు కోసం నరహంతకుడు సమాజం ఎదుట నిలిచే వరకూ వాడు మరణశిక్ష పొందకూడదు కాబట్టి ప్రతికారం తీర్చుకునేవాడి నుండి అవి మీకు ఆశ్రయం కల్పిస్తాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","మీరు ఆరు పట్టణాలను ఆశ్రయ పురాలుగా ఇవ్వాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","వాటిలో యొర్దాను ఇవతల మూడు పట్టణాలు, కనాను దేశంలో మూడు పట్టణాలు ఇవ్వాలి. అవి మీకు ఆశ్రయపురాలుగా ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ఎవరినైనా పొరబాటున చంపిన వాడు వాటిలోకి పారిపోయేలా ఆ ఆరు పట్టణాలు ఇశ్రాయేలీయులకు, పరదేశులకు, మీ మధ్య నివసించే ఎవరికైనా ఆశ్రయంగా ఉంటాయి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","ఒకడు చనిపోయేలా ఇనుప ఆయుధంతో కొట్టినవాడు నరహంతకుడు. వాడికి తప్పకుండా మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ఒకడు చనిపోయేలా రాతితో కొట్టినప్పుడు ఆ కొట్టినవాడు నరహంతకుడు. వాడికి తప్పకుండా మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","అలాగే ఒకడు చనిపోయేలా మరొకడు చేతి కర్రతో కొడితే కొట్టినవాడు నరహంతకుడు. వాడు తప్పకుండా మరణశిక్ష పొందాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","హత్య విషయంలో ప్రతికారం తీర్చుకునే వాడు తానే స్వయంగా ఆ నరహంతకుణ్ణి చంపాలి. వాణ్ణి కలిసినప్పుడు చంపవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ఎవరైనా చనిపోయేలా పగపట్టి పొడిచినా, లేక పొంచి ఉండి వాడి మీద దేనినైనా విసిరినా, లేక వైరంతో చేతితో కొట్టినా, కొట్టినవాడు నరహంతకుడు. అతణ్ణి తప్పకుండా చంపాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ప్రతికారం తీర్చుకునేవాడు ఆ నరహంతకుణ్ణి కలిసినప్పుడు వాడిని చంపవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","అయితే పగ ఏమీ లేకుండా వాడిని పొడిచినా, పొంచి ఉండకుండాా వాడిమీద ఏ ఆయుధమైనా విసిరినా ఒకడు చనిపోయేలా వాడిమీద రాయి విసిరినా, ");
INSERT INTO tel2017_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","దెబ్బతిన్న వాడు చనిపోతే ఆ కొట్టినవాడు వాడి మీద పగపట్ట లేదు, వాడికి హాని చేసే ఉద్దేశం లేదు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","కాబట్టి సమాజం ఈ నియమాల ప్రకారం కొట్టిన వాడికీ ప్రతికారం తీర్చుకునే వాడికీ మధ్య తీర్పుతీర్చాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ఆ విధంగా చేసి సమాజం నరహత్య విషయంలో ప్రతికారం తీర్చుకునే వాడి చేతి నుండి ఆ నరహంతకుణ్ణి కాపాడాలి. సమాజం మొదట పారిపోయిన ఆశ్రయపురానికి వాణ్ణి మళ్ళీ పంపించాలి. వాడు పవిత్ర తైలంతో అభిషేకం పొందిన ప్రధాన యాజకుడు చనిపోయే వరకూ అక్కడే నివసించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","అయితే అతడు ఎప్పుడైనా తన ఆశ్రయపురం సరిహద్దు దాటి వెళితే ");
INSERT INTO tel2017_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","నరహత్య విషయంలో ప్రతికారం తీర్చుకునేవాడు ఆశ్రయపురం సరిహద్దు బయట అతణ్ణి చూసి చంపినప్పటికీ వాడి మీద హత్యాదోషం ఉండదు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ఎందుకంటే, ప్రధాన యాజకుడు చనిపోయే వరకూ అతడు ఆశ్రయపురంలోనే నివసించాలి. ఆ ప్రధాన యాజకుడు చనిపోయిన తరువాత ఆ నరహంతకుడు తన వారసత్వం ఉన్న దేశానికి తిరిగి వెళ్లవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","ఇవి మీరు నివాసముండే స్థలాలన్నిటిలో అన్ని తరాలకు మీకు విధించిన కట్టడ. ");
INSERT INTO tel2017_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","ఎవరైనా ఒకణ్ణి చంపితే సాక్షుల నోటి మాట వలన ఆ నరహంతకుడికి మరణశిక్ష విధించాలి. ఒక్క సాక్షిమాట మీద ఎవరికీ మరణశిక్ష విధించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","హత్యా దోషంతో చావుకు తగిన నరహంతకుని ప్రాణం కోసం మీరు విమోచన ధనాన్ని అంగీకరించక తప్పకుండా వాడికి మరణశిక్ష విధించాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ఆశ్రయపురానికి పారిపోయిన వాడు యాజకుడు చనిపోక ముందుగా తన స్వంత ఊరిలో నివసించేలా చేయడానికి వాడి దగ్గర విమోచన ధనాన్ని అంగీకరించకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","మీరు జీవించే దేశాన్ని అపవిత్రం చేయకూడదు. నరహత్య దేశాన్ని అపవిత్రపరుస్తుంది. దేశంలో చిందిన రక్తం కోసం ప్రాయశ్చిత్తం ఆ చిందించిన వాడి రక్తం వల్లనే కలుగుతుంది గాని మరి దేనివల్లా జరగదు. ");
INSERT INTO tel2017_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","కాబట్టి మీరు జీవించే దేశాన్ని అపవిత్రం చేయవద్దు. ఎందుకంటే నేను దానిలో నివసిస్తున్నాను. నిజంగా యెహోవా అనే నేను ఇశ్రాయేలీయుల మధ్య నివసిస్తున్నాను.” ");
INSERT INTO tel2017_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","యోసేపు కొడుకుల వంశాల్లో మాకీరు కొడుకు, మనష్షే మనమడు అయిన గిలాదు వంశం పెద్దలు వచ్చి మోషేతో, ఇశ్రాయేలీయుల పూర్వీకుల కుటుంబాల నాయకులతో ఇలా అన్నారు, ");
INSERT INTO tel2017_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“ఈ దేశాన్ని చీటీల ప్రకారం ఇశ్రాయేలీయులకు వారసత్వంగా ఇవ్వాలని యెహోవా మా ఏలికవైన నీకు ఆజ్ఞాపించాడు. మా సోదరుడు సెలోపెహాదు వారసత్వాన్ని అతని కూతుళ్ళకు ఇవ్వాలని కూడా యెహోవా నీకు ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","అయితే వారు ఇశ్రాయేలీయుల్లో ఇతర గోత్రాల వారిని ఎవరిని పెళ్లి చేసుకున్నా వారి వారసత్వం మా పూర్వీకుల వారసత్వం నుండి తీసి, వారు చేసుకున్న గోత్రపు వారసత్వంతో కలిసిపోయి, మా గోత్రానికి వచ్చిన చీటీల ప్రకారం లభించిన వారసత్వం నుండి వేరైపోతుంది. ");
INSERT INTO tel2017_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","కాబట్టి ఇశ్రాయేలీయులకు సునాద సంవత్సరం వచ్చినప్పుడు వారి వంతు వారు పెళ్లి చేసుకున్న గోత్రపు వారసత్వంతో కలిసిపోతుంది కాబట్టి ఆ మేరకు మా పూర్వీకుల గోత్ర వారసత్వం తగ్గిపోతుంది.” ");
INSERT INTO tel2017_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","అప్పుడు మోషే యెహోవా మాట ప్రకారం ఇశ్రాయేలీయులకు ఇలా ఆజ్ఞాపించాడు. “యోసేపు కొడుకుల గోత్రికులు చెప్పింది న్యాయంగానే ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","యెహోవా సెలోపెహాదు కూతుళ్ళ గురించి చెప్పింది ఏమిటంటే, వారు తమకు ఇష్టమైన వారిని వివాహం చేసుకోవచ్చు గాని, తమ తండ్రి గోత్ర వంశాల్లోనే చేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ఇశ్రాయేలీయుల వారసత్వం ఒక గోత్రం నుండి వేరొక గోత్రంలోకి వెళ్ళకూడదు. ఇశ్రాయేలీయుల్లో ప్రతి ఒక్కడూ తన పూర్వీకుల గోత్ర వారసత్వానికి కట్టుబడి ఉండాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ఇశ్రాయేలీయులకు వారి పూర్వీకుల వారసత్వం కలిగేలా ఇశ్రాయేలీయుల గోత్రాల్లో వారసత్వం ఉన్న ప్రతి యువతీ తన తండ్రి గోత్రంలోనే వివాహం చేసుకోవాలి. ");
INSERT INTO tel2017_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","వారసత్వం ఒక గోత్రం నుండి మరొక గోత్రానికి వెళ్ళకూడదు. ఇశ్రాయేలీయుల గోత్రాలు వారి వారి వారసత్వాల్లోనే నిలిచి ఉండాలి.” ");
INSERT INTO tel2017_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","యెహోవా మోషేకు ఆజ్ఞాపించిన విధంగా సెలోపెహాదు కూతుళ్ళు చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","మహలా, తిర్సా, హొగ్లా, మిల్కా, నోయా అనే సెలోపెహాదు కూతుళ్ళు తమ తండ్రి సోదరుని కొడుకులను వివాహం చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","అంటే యోసేపు కొడుకులైన మనష్షీయులను వివాహం చేసుకోవడం వలన వారి వారసత్వం వారి తండ్రి గోత్రంలోనే ఉండిపోయింది. ");
INSERT INTO tel2017_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ఇవి యెరికో దగ్గర యొర్దానుకు సమీపంగా ఉన్న మోయాబు మైదానాల్లో యెహోవా మోషే ద్వారా ఇశ్రాయేలీయులకు ఆజ్ఞాపించిన విధులు, ఆజ్ఞలు.");
INSERT INTO tel2017_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","యొర్దాను నదికి తూర్పున ఉన్న ఎడారిలో, అంటే పారాను, తోపెలు, లాబాను, హజేరోతు, దీజాహాబు అనే ప్రదేశాల మధ్య సూపుకు ఎదురుగా ఉన్న ఆరాబా ఎడారిలో మోషే, ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","హోరేబు నుండి శేయీరు ఎడారి దారిలో కాదేషు బర్నేయ వరకూ ప్రయాణ సమయం 11 రోజులు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","4","హెష్బోనులో నివసించిన అమోరీయుల రాజు సీహోనునూ అష్తారోతులో నివసించిన బాషాను రాజు ఓగునూ ఎద్రెయీలో చంపిన తరువాత 40 వ సంవత్సరంలో 11 వ నెల మొదటి రోజున మోషే యెహోవా తనకు ఆజ్ఞాపించినదంతా ఇశ్రాయేలు ప్రజలకు బోధించాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","యొర్దాను ఇవతల ఉన్న మోయాబు దేశంలో మోషే ఈ ధర్మశాస్త్రాన్ని ప్రకటించడం మొదలుపెట్టి ఇలా అన్నాడు, ");
INSERT INTO tel2017_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“మన దేవుడు యెహోవా హోరేబులో మనకిలా చెప్పాడు, ఈ కొండ దగ్గర మీరు నివసించింది చాలు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","మీరు బయలుదేరి అమోరీయుల కొండ ప్రాంతానికీ అరాబా లోయలో దక్షిణ దిక్కున సముద్రతీరంలో ఉన్న స్థలాలన్నిటికీ కనాను దేశానికీ లెబానోనుకూ యూఫ్రటీసు మహానది వరకూ వెళ్ళండి. ");
INSERT INTO tel2017_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ఇదిగో, ఆ దేశాన్ని మీకు అప్పగించాను. మీరు వెళ్లి, యెహోవా మీ పూర్వీకులు అబ్రాహాము, ఇస్సాకు, యాకోబులకూ, వారి సంతానానికీ ఇస్తానని నేను వాగ్దానం చేసిన దేశాన్ని స్వాధీనం చేసుకోండి.” ");
INSERT INTO tel2017_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ఆ సమయంలో, నేను మీతో “నేను ఒక్కడినే మిమ్మల్ని మోయలేను. ");
INSERT INTO tel2017_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","యెహోవా దేవుడు మిమ్మల్ని విస్తరింపజేశాడు కనుక ఈ రోజు మీరు ఆకాశంలో నక్షత్రాల్లాగా విస్తరించారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","మీ పూర్వీకుల దేవుడు యెహోవా మీ జనసంఖ్యను వెయ్యి రెట్లు ఎక్కువ చేసి, తాను మీతో చెప్పినట్టు మిమ్మల్ని ఆశీర్వదిస్తాడు గాక. ");
INSERT INTO tel2017_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","నేనొక్కడినే మీ కష్టాన్ని, భారాన్ని, మీ వివాదాలను ఎలా తీర్చగలను? ");
INSERT INTO tel2017_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","జ్ఞానం, తెలివి కలిగి మీ గోత్రాల్లో పేరు పొందిన మనుషులను ఎన్నుకోండి. వారిని మీకు నాయకులుగా నియమిస్తాను” అని చెప్పాను. ");
INSERT INTO tel2017_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","అప్పుడు మీరు “నీ మాట ప్రకారం చేయడం మంచిది” అని నాకు జవాబిచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","కాబట్టి నేను మీ గోత్రాల్లో పేరు పొంది, తెలివీ జ్ఞానమూ కలిగిన వారిని పిలిచి, మీ గోత్రాలకు వెయ్యి మందికి ఒకడు, వంద మందికి ఒకడు, యాభై మందికి ఒకడు, పది మందికి ఒకడు చొప్పున వారిని మీ మీద న్యాయాధికారులుగా నియమించాను. ");
INSERT INTO tel2017_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","అప్పుడు నేను వారితో “మీ సోదరుల వివాదాలు తీర్చి, ప్రతివాడికీ వాడి సోదరుడికీ వాడి దగ్గర ఉన్న పరదేశికీ న్యాయం ప్రకారం తీర్పు తీర్చండి. ");
INSERT INTO tel2017_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","అలా చేసేటప్పుడు తక్కువ, ఎక్కువ అనే పక్షపాతం లేకుండా వినాలి. న్యాయపు తీర్పు దేవునిది కాబట్టి మీరు మనుషుల ముఖం చూసి భయపడవద్దు. మీకు కష్టమైన వివాదాన్ని నా దగ్గరికి తీసుకు రండి. దాన్ని నేను విచారిస్తాను” అని ఆజ్ఞాపించాను. ");
INSERT INTO tel2017_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","అలాగే మీరు చేయాల్సిన పనులన్నిటిని గూర్చి మీకు ఆజ్ఞాపించాను. ");
INSERT INTO tel2017_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","మనం హోరేబు నుండి ప్రయాణించి యెహోవా దేవుడు మనకి ఆజ్ఞాపించినట్టు మీరు చూసిన ఘోరమైన ఎడారి ప్రాంతం నుండి వచ్చి, అమోరీయుల కొండ ప్రాంతం మార్గంలో కాదేషు బర్నేయ చేరాం. ");
INSERT INTO tel2017_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","అప్పుడు నేను “మన దేవుడైన యెహోవా మనకిస్తున్న అమోరీయుల కొండ ప్రాంతానికి వచ్చాం. ");
INSERT INTO tel2017_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ఇదిగో, మీ దేవుడు యెహోవా ఈ దేశాన్ని మీకు అప్పగించాడు. మీ పూర్వీకుల దేవుడైన యెహోవా మీతో చెప్పినట్టు దాన్ని స్వాధీనం చేసుకోండి. భయపడవద్దు, నిరుత్సాహం వద్దు” అని మీతో చెప్పాను. ");
INSERT INTO tel2017_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","అప్పుడు మీరంతా నా దగ్గరికి వచ్చి “ముందుగా మన మనుషులను పంపుదాం, వాళ్ళు మన కోసం ఈ దేశాన్ని పరిశీలించి తిరిగి వచ్చి దానిలో మనం వెళ్ళాల్సిన మార్గం గురించీ మనం చేరాల్సిన పట్టణాలను గురించీ మనకు సమాచారం తెస్తారు” అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ఆ మాట అంగీకరించి ఒక్కొక్క గోత్రానికి ఒక్కరు చొప్పున పన్నెండు మందిని పంపాను. ");
INSERT INTO tel2017_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","వాళ్ళు ఆ కొండ ప్రదేశానికి వెళ్ళి ఎష్కోలు లోయకు వచ్చి దాన్ని పరిశీలించారు. ఆ దేశంలో దొరికే పండ్లు కొన్నిటిని మన దగ్గరికి తెచ్చి, ");
INSERT INTO tel2017_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","“మన దేవుడు యెహోవా మనకిస్తున్న దేశం మంచిది” అని మనకు చెప్పారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","అయితే మీరు వెళ్లడానికి ఇష్టపడలేదు. మీ దేవుడైన యెహోవా మాటకు తిరగబడ్డారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","మీ గుడారాల్లో సణుక్కుంటూ “యెహోవా మన మీద పగబట్టి మనలను చంపడానికి, అమోరీయులకు అప్పగించడానికి ఐగుప్తు దేశం నుండి మనలను రప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","మనమెక్కడికి వెళ్లగలం? అక్కడి ప్రజలు మన కంటే బలిష్ఠులు, ఎత్తయినవారు. ఆ పట్టణాలు గొప్పవి, ఆకాశాన్నంటే ప్రాకారాలతో ఉన్నాయి. అక్కడ అనాకీయులను చూశాం” అని మన సోదరులు చెప్పి మా హృదయాలు కరిగిపోయేలా చేశారు అని అన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","అప్పుడు నేను మీతో “దిగులు పడొద్దు, భయపడొద్దు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","మీకు ముందు నడుస్తున్న మీ యెహోవా దేవుడు మీరు చూస్తుండగా ");
INSERT INTO tel2017_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ఐగుప్తులో, అరణ్యంలో చేసినట్టు మీ పక్షంగా యుద్ధం చేస్తాడు. మీరు ఇక్కడికి వచ్చేవరకూ దారిలో మీ యెహోవా దేవుడు ఒక తండ్రి తన కొడుకుని ఎత్తుకున్నట్టు మిమ్మల్ని ఎత్తుకుని వచ్చాడని మీకు తెలుసు” అన్నాను. ");
INSERT INTO tel2017_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","అయితే మీకు దారి చూపించి మీ గుడారాలకు స్థలం సిద్ధపరిచేలా ");
INSERT INTO tel2017_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","రాత్రి అగ్నిలో, పగలు మేఘంలో మీ ముందు నడిచిన మీ యెహోవా దేవుని మీద మీరు విశ్వాసముంచలేదు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","కాబట్టి యెహోవా మీ మాటలు విని, ");
INSERT INTO tel2017_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","బాగా కోపం తెచ్చుకుని “నేను మీ పూర్వీకులకు ఇస్తానని వాగ్దానం చేసిన ఈ మంచి దేశాన్ని ఈ చెడ్డతరంలో ");
INSERT INTO tel2017_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","యెఫున్నె కొడుకు కాలేబు తప్ప మరెవరూ చూడడు. అతడు పూర్ణమనస్సుతో యెహోవాను అనుసరించాడు కాబట్టి కేవలం అతడు మాత్రమే దాన్ని చూస్తాడు. అతడు అడుగుపెట్టిన భూమిని నేను అతనికీ అతని సంతానానికీ ఇస్తాను” అని ప్రమాణం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","అంతేగాక యెహోవా మిమ్మల్ని బట్టి నా మీద కోపపడి “నీ సేవకుడు, నూను కొడుకు యెహోషువ దానిలో అడుగు పెడతాడు గాని నువ్వు అడుగు పెట్టవు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","అతడే దాన్ని ఇశ్రాయేలీయులకు స్వాధీనం చేస్తాడు. కాబట్టి అతణ్ణి ప్రోత్సహించు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","అయితే మంచీ చెడూ తెలియని మీ కొడుకులు, అంటే అన్యాయానికి గురౌతారు అని మీరు చెప్పే మీ పిల్లలు దానిలో అడుగు పెడతారు. దాన్ని వారికిస్తాను. వారు దాన్ని స్వాధీనం చేసుకుంటారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","మీరు మాత్రం వెనక్కి ఎర్రసముద్రం వైపుకు తిరిగి ఎడారిలోకి ప్రయాణించండి” అని చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","అందుకు మీరు “మేము యెహోవాకు విరోధంగా పాపం చేశాం. మా యెహోవా దేవుడు మాకాజ్ఞాపించిన ప్రకారం మేము వెళ్ళి యుద్ధం చేస్తాం” అని నాతో చెప్పి, మీ ఆయుధాలతో ఆ కొండ ప్రాంతానికి బయలుదేరారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","అప్పుడు యెహోవా నాతో ఇలా అన్నాడు “యుద్ధానికి వెళ్లొద్దు. నేను మీతో ఉండను కాబట్టి మీరు వెళ్లినా మీ శత్రువుల చేతిలో ఓడిపోతారని వారితో చెప్పు.” ");
INSERT INTO tel2017_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ఆ మాటలు నేను మీతో చెప్పినా మీరు వినకుండా యెహోవా మాటకు ఎదురు తిరిగి మూర్ఖంగా ఆ కొండ ప్రాంతానికి వెళ్ళారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","అప్పుడు అక్కడ ఉన్న అమోరీయులు మీకెదురు వచ్చి, కందిరీగల్లాగా మిమ్మల్ని హోర్మా వరకూ తరిమి శేయీరులో మిమ్మల్ని హతం చేశారు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","తరువాత మీరు తిరిగి వచ్చి యెహోవా సన్నిధిలో ఏడ్చారు. అయినా యెహోవా మిమ్మల్ని లెక్కచేయలేదు, మీ మాట వినలేదు. ");
INSERT INTO tel2017_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","కాబట్టి మీరు కాదేషులో చాలా రోజులు ఉండిపోయారు. అక్కడ ఎన్ని రోజులు నివసించారో మీకు తెలుసు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","అప్పుడు యెహోవా నాతో చెప్పిన విధంగా మనం తిరిగి ఎర్రసముద్రం దారిలో ఎడారి గుండా చాలా రోజులు శేయీరు కొండ చుట్టూ తిరిగాం. ");
INSERT INTO tel2017_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","యెహోవా నాకు ఇలా చెప్పాడు. “మీరు ఈ కొండ చుట్టూ తిరిగింది చాలు, ");
INSERT INTO tel2017_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","ఉత్తరం వైపుకు వెళ్ళండి. నువ్వు ప్రజలతో ఇలా చెప్పు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","‘శేయీరులో నివసించే ఏశావు సంతానమైన మీ సోదరుల సరిహద్దులు దాటి వెళ్లబోతున్నారు, వారు మీకు భయపడతారు. కాబట్టి మీరు జాగ్రత్తగా ఉండండి. ");
INSERT INTO tel2017_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","వారితో కలహం పెట్టుకోవద్దు. ఎందుకంటే ఏశావుకు శేయీరును స్వాస్థ్యంగా ఇచ్చింది నేనే. వారి భూమిలోనిది ఒక్క అడుగైనా మీకియ్యను. ");
INSERT INTO tel2017_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","మీరు డబ్బులిచ్చి వారి దగ్గర ఆహారం కొని తినవచ్చు. డబ్బులిచ్చి నీళ్లు కొని తాగవచ్చు.’ ");
INSERT INTO tel2017_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ఎందుకంటే మీ చేతి పని అంతటినీ మీ యెహోవా దేవుడు ఆశీర్వదించాడు. ఈ గొప్ప ఎడారిలో నువ్వు ఈ నలభై సంవత్సరాలు తిరిగిన సంగతి ఆయనకు తెలుసు. ఆయన మీకు తోడుగా ఉన్నాడు, మీకేమీ తక్కువ కాదు.” ");
INSERT INTO tel2017_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","అప్పుడు శేయీరులో నివసించే ఏశావు సంతానమైన మన సోదరులను విడిచి, ఏలతు, ఎసోన్గెబెరు, అరాబా దారిలో మనం ప్రయాణించాం. ");
INSERT INTO tel2017_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","మనం తిరిగి మోయాబు ఎడారి మార్గంలో వెళుతుండగా యెహోవా నాతో ఇలా అన్నాడు. “మోయాబీయులను బాధ పెట్టవద్దు. వారితో యుద్ధం చేయొద్దు. లోతు సంతానానికి ఆర్ దేశాన్ని స్వాస్థ్యంగా ఇచ్చాను. వారి భూమిలో దేనినీ నీ స్వంతానికి ఇవ్వను.” ");
INSERT INTO tel2017_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","గతంలో ఏమీయులు ఆ ప్రాంతాల్లో ఉండేవారు. వారు అనాకీయుల్లాగా పొడవైనవారు, బలవంతులైన గొప్ప ప్రజ. అనాకీయుల్లాగా వారిని కూడా “రెఫాయీయులు” అని పిలిచారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","మోయాబీయులు వారికి “ఏమీయులు” పేరు పెట్టారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","పూర్వకాలంలో హోరీయులు శేయీరులో నివసించారు. ఇశ్రాయేలీయులు యెహోవా తమకిచ్చిన స్వాస్థ్యమైన దేశంలో చేసినట్టు ఏశావు సంతానం హోరీయుల దేశాన్ని స్వాధీనం చేసుకుని వారిని చంపి వారి దేశంలో నివసించారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“ఇప్పుడు మీరు లేచి జెరెదు వాగు దాటండి” అని యెహోవా ఆజ్ఞాపించగా మనం జెరెదు వాగు దాటాం. ");
INSERT INTO tel2017_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","మనం కాదేషు బర్నేయ నుండి బయలుదేరి జెరెదు వాగు దాటే వరకూ మనం ప్రయాణించిన కాలం 38 సంవత్సరాలు. యెహోవా వారితో శపథం చేసినట్టు అప్పటికి ఆ తరంలో యుద్ధం చేయగల మనుషులందరూ గతించిపోయారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","అంతే కాదు, వారు గతించే వరకూ ఆ తరం వారిని చంపడానికి యెహోవా హస్తం వారికి విరోధంగా ఉంది. ");
INSERT INTO tel2017_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ఈ విధంగా సైనికులైన వారంతా చనిపోయి గతించిన తరువాత యెహోవా నాకు ఇలా చెప్పాడు, ");
INSERT INTO tel2017_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","“ఈ రోజు నువ్వు మోయాబుకు సరిహద్దుగా ఉన్న ఆర్ దేశాన్ని దాటబోతున్నావు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","అమ్మోనీయుల పక్కగా వెళ్ళేటప్పుడు వారిని బాధించవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","వారితో యుద్ధం చేయొద్దు. ఎందుకంటే లోతు సంతానానికి దాన్ని స్వాస్థ్యంగా ఇచ్చాను. కాబట్టి వారి దేశంలో భూమిని నీకు ఏ మాత్రం ఇవ్వను.” ");
INSERT INTO tel2017_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","దాన్ని కూడా రెఫాయీయుల దేశం అని పిలిచారు. పూర్వం రెఫాయీయులు అందులో నివసించారు. అమ్మోనీయులు వారిని “జంజుమీయులు” అనేవారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","వారు అనాకీయుల్లాగా పొడవైన వారు, బలవంతులైన గొప్ప ప్రజలు. అయితే యెహోవా అమ్మోనీయుల ఎదుట నుండి వారిని వెళ్లగొట్టడం వలన అమ్మోనీయులు వారి దేశాన్ని స్వాధీనం చేసుకుని అక్కడ నివసించారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ఆయన శేయీరులో నివసించే ఏశావు సంతానం కోసం వారి ఎదుట నుండి హోరీయులను నశింపజేశాడు కాబట్టి వారు హోరీయుల దేశాన్ని స్వాధీనం చేసుకుని ఈ రోజు వరకూ అక్కడ నివసిస్తున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","గాజా వరకూ ఉన్న గ్రామాల్లో నివసించిన ఆవీయులను కఫ్తోరు నుండి వచ్చిన కఫ్తోరీయులు నాశనం చేసి అక్కడ నివసించారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“మీరు బయలుదేరి అర్నోను లోయ దాటండి. ఇదిగో అమోరీయుడు, హెష్బోను రాజు అయిన సీహోనునూ అతని దేశాన్నీ మీ చేతికి అప్పగించాను. అతనితో యుద్ధం చేసి దాన్ని ఆక్రమించుకోండి. ");
INSERT INTO tel2017_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ఈ రోజు ఆకాశం కింద ఉన్న జాతుల ప్రజలందరికీ నువ్వంటే భయం పుట్టించడం మొదలు పెడుతున్నాను. వారు మీ గురించిన సమాచారం విని నీ ఎదుట వణకి, కలవరపడతారు” అని యెహోవా నాతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","అప్పుడు నేను కెదేమోతు ఎడారిలో నుండి హెష్బోను రాజు సీహోను దగ్గరికి దూతలను పంపి ");
INSERT INTO tel2017_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“మమ్మల్ని నీ దేశం గుండా వెళ్ళనివ్వు. కుడి, ఎడమలకు తిరగకుండా దారిలోనే నడిచిపోతాము. ");
INSERT INTO tel2017_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","నా దగ్గర సొమ్ము తీసుకుని తినడానికి ఆహార పదార్థాలు, తాగడానికి నీరు ఇవ్వు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","శేయీరులో ఏశావు సంతానమూ ఆర్ లో మోయాబీయులూ నాకు చేసినట్టు, మా దేవుడు యెహోవా మాకిస్తున్న దేశానికి వెళ్ళడానికి యొర్దాను నది దాటేవరకూ కాలి నడకతోనే మమ్మల్ని వెళ్లనివ్వు” అని శాంతికరమైన మాటలు పలికించాను. ");
INSERT INTO tel2017_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","అయితే హెష్బోను రాజు సీహోను మనం తన దేశం గుండా వెళ్లడానికి ఒప్పుకోలేదు. ఎందుకంటే ఈ రోజు జరిగినట్టుగా మన చేతికి అతణ్ణి అప్పగించడం కోసం మీ యెహోవా దేవుడు అతని మనస్సును కఠినపరచి అతని హృదయాన్ని బండబారిపోయేలా చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","అప్పుడు యెహోవా “చూడు, సీహోనును అతని దేశాన్ని నీకు అప్పగిస్తున్నాను. అతని దేశాన్ని స్వాధీనం చేసుకోవడం మొదలు పెట్టు” అని నాతో చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","సీహోనూ అతని ప్రజలంతా యాహసులో మనతో యుద్ధం చేయడానికి వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","మన యెహోవా దేవుడు అతణ్ణి మనకప్పగించాడు కాబట్టి మనం అతన్నీ అతని కొడుకులనూ అతని ప్రజలందరినీ చంపివేశాం. ");
INSERT INTO tel2017_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","అప్పుడున్న అతని పట్టణాలనూ, వాటిలోని స్త్రీ పురుషులనూ పిల్లలనూ ఏదీ మిగలకుండా నాశనం చేశాం. ");
INSERT INTO tel2017_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","కేవలం పశువులనూ ఆ పట్టణాల ఆస్తినీ దోచుకున్నాం. ");
INSERT INTO tel2017_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","అర్నోను ఏటిలోయ ఒడ్డున ఉన్న అరోయేరు, ఆ లోయలో ఉన్న పట్టణం మొదలుపెట్టి గిలాదు వరకూ మనకు లొంగిపోని పట్టణం ఒక్కటి కూడా లేదు. మన దేవుడు అన్నిటినీ మనకి అప్పగించాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","అయితే అమ్మోనీయుల దేశానికైనా, యబ్బోకు నది లోయలోని ఏ ప్రాంతానికైనా ఆ కొండప్రాంతంలోని పట్టణాలకైనా మన యెహోవా దేవుడు వెళ్ళవద్దని చెప్పిన మరే స్థలానికైనా మీరు వెళ్ళలేదు. ");
INSERT INTO tel2017_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","మనం తిరిగి బాషాను దారిలో వెళ్తుండగా బాషాను రాజు ఓగు, అతని ప్రజలంతా ఎద్రెయీలో మనతో యుద్ధం చేయడానికి ఎదురుగా వచ్చారు. ");
INSERT INTO tel2017_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","యెహోవా నాతో ఇలా అన్నాడు. “అతనికి భయపడ వద్దు. అతన్నీ అతని ప్రజలనూ అతని దేశాన్నీ నీ చేతికి అప్పగించాను. హెష్బోనులో అమోరీయుల రాజు సీహోనుకు చేసినట్టే ఇతనికి కూడా చేయాలి.” ");
INSERT INTO tel2017_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ఆ విధంగా మన దేవుడు యెహోవా బాషాను రాజు ఓగును, అతని ప్రజలందరినీ మన చేతికి అప్పగించాడు. అతనికి ఎవ్వరూ మిగలకుండా అందరినీ హతం చేశాం. ");
INSERT INTO tel2017_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ఆ కాలంలో అతని పట్టణాలన్నీ స్వాధీనం చేసుకున్నాం. మన స్వాధీనంలోకి రాని పట్టణం ఒక్కటీ లేదు. బాషానులో ఓగు రాజ్యం అర్గోబు ప్రాంతంలో ఉన్న 60 పట్టణాలు ఆక్రమించుకున్నాం. ");
INSERT INTO tel2017_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ఆ పట్టణాలన్నీ గొప్ప ప్రాకారాలు, ద్వారాలు, గడియలతో ఉన్న దుర్గాలు. అవిగాక ప్రాకారాలు లేని ఇంకా చాలా పట్టణాలు స్వాధీనం చేసుకున్నాం. ");
INSERT INTO tel2017_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","మనం హెష్బోను రాజు సీహోనుకు చేసినట్టు వాటిని నిర్మూలం చేశాం. ప్రతి పట్టణంలోని స్త్రీ పురుషులనూ పిల్లలనూ నాశనం చేశాం. ");
INSERT INTO tel2017_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","వారి పశువులనూ ఆ పట్టణాల ఆస్తినీ దోచుకున్నాం. ");
INSERT INTO tel2017_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ఆ కాలంలో అర్నోను లోయ నుండి హెర్మోను కొండ వరకూ, యొర్దాను అవతల ఉన్న దేశాన్ని ఇద్దరు అమోరీయుల రాజుల దగ్గర నుండి స్వాధీనం చేసుకున్నాం. ");
INSERT INTO tel2017_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","సీదోనీయులు హెర్మోనును “షిర్యోను” అనేవారు. అమోరీయులు దాన్ని “శెనీరు” అనేవారు. ");
INSERT INTO tel2017_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","మైదానంలోని పట్టాణాలన్నిటిని, బాషానులోని ఓగు రాజ్య పట్టణాలైన సల్కా, ఎద్రెయీ అనేవాటి వరకూ గిలాదు అంతటినీ బాషానునూ ఆక్రమించాం. ");
INSERT INTO tel2017_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","రెఫాయీయులలో బాషాను రాజు ఓగు మాత్రం మిగిలాడు. అతనిది ఇనుప మంచం. అది అమ్మోనీయుల రబ్బాలో ఉంది గదా? దాని పొడవు తొమ్మిది మూరలు, వెడల్పు నాలుగు మూరలు. ");
INSERT INTO tel2017_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","అర్నోను లోయలో ఉన్న అరోయేరు పట్టణం నుండి గిలాదు కొండ ప్రాంతంలో సగమూ మనం అప్పుడు స్వాధీనం చేసుకొన్న దేశమూ దాని పట్టణాలూ రూబేనీయులకు, గాదీయులకు ఇచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ఓగు రాజుకు చెందిన బాషాను అంతటినీ, గిలాదులో మిగిలిన రెఫాయీయుల దేశమని పిలిచే బాషానునూ, అర్గోబు ప్రాంతమంతా మనష్షే అర్థ గోత్రానికి ఇచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","మనష్షే కొడుకు యాయీరు గెషూరీయుల, మాయాకాతీయుల సరిహద్దుల వరకూ అర్గోబు ప్రాంతాన్ని పట్టుకుని, తన పేరును బట్టి వాటికి యాయీరు బాషాను గ్రామాలు అని పేరు పెట్టాడు. ఈ రోజు వరకూ వాటి పేరు అదే. ");
INSERT INTO tel2017_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","మాకీరీయులకు గిలాదును ఇచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","గిలాదు నుండి అర్నోను లోయ మధ్య వరకూ, యబ్బోకు నది వరకూ, అమ్మోనీయుల పడమటి సరిహద్దు వరకూ రూబేనీయులకూ గాదీయులకూ ఇచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ఇవి కాక, కిన్నెరెతు నుండి తూర్పున పిస్గా కొండ వాలుల కింద, ఉప్పు సముద్రం అని పిలిచే అరాబా సముద్రం దాకా వ్యాపించిన అరాబా ప్రాంతాన్ని, యొర్దాను లోయ మధ్యభూమిని, రూబేనీయులకూ గాదీయులకూ ఇచ్చాను. ");
INSERT INTO tel2017_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","అప్పుడు నేను మీతో “మీరు స్వాధీనం చేసుకోడానికి మీ దేవుడు యెహోవా ఈ దేశాన్ని మీకిచ్చాడు. మీలో యుద్ధవీరులంతా సిద్ధపడి మీ సోదరులైన ఇశ్రాయేలు ప్రజలతో కలిసి నది దాటి రావాలి. ");
INSERT INTO tel2017_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","యెహోవా మీకు విశ్రాంతినిచ్చినట్టు మీ సోదరులకు కూడా విశ్రాంతినిచ్చే వరకూ నేను మీకిచ్చిన పట్టణాల్లో నివసించాలి. ");
INSERT INTO tel2017_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","అంటే మీ యెహోవా దేవుడు యొర్దాను అవతల వారికి ఇస్తున్న దేశాన్ని వారు స్వాధీనం చేసుకునే వరకూ, మీ భార్యలు, మీ పిల్లలు, మీ మందలు నేను మీకిచ్చిన పట్టణాల్లో నివసించాలి. ఆ తరువాత మీరు మీ స్వాస్థ్యాలకు తిరిగి రావాలి అని మీకు ఆజ్ఞాపించాను. మీ మందలు చాలా ఎక్కువని నాకు తెలుసు” అన్నాను. ");
INSERT INTO tel2017_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ఆ సమయంలో నేను యెహోషువకు ఇలా ఆజ్ఞాపించాను. “మీ యెహోవా దేవుడు ఈ ఇద్దరు రాజులకు చేసినదంతా నువ్వు కళ్ళారా చూశావు గదా. నువ్వు వెళ్తున్న రాజ్యాలన్నిటికీ యెహోవా అదే విధంగా చేస్తాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","మీ యెహోవా దేవుడు మీ పక్షంగా యుద్ధం చేస్తాడు కాబట్టి వారికి భయపడ వద్దు.” ");
INSERT INTO tel2017_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ఆ రోజుల్లో నేను “యెహోవా, ప్రభూ, నీ మహిమనూ, నీ బాహుబలాన్నీ నీ దాసునికి చూపించడం ప్రారంభించావు. ");
INSERT INTO tel2017_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","ఆకాశంలో గాని, భూమిపై గాని నువ్వు చేసే పనులు చేయగల దేవుడెవడు? నీ అంత పరాక్రమం చూపగల దేవుడెవడు? ");
INSERT INTO tel2017_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","నేను అవతలికి వెళ్లి యొర్దాను అవతల ఉన్న ఈ మంచి దేశాన్ని, ఆ మంచి కొండ ప్రాంతాన్ని, ఆ లెబానోనును చూసేలా అనుగ్రహించు” అని యెహోవాను బతిమాలుకున్నాను. ");
INSERT INTO tel2017_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","యెహోవా మీ కారణంగా నా మీద కోపపడి నా మనవి వినలేదు. ఆయన నాతో ఇలా అన్నాడు. “చాలు. ఇంక ఈ సంగతిని గూర్చి నాతో మాట్లాడవద్దు. ");
INSERT INTO tel2017_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","నువ్వు ఈ యొర్దాను దాటకూడదు. అయితే, పిస్గా కొండ ఎక్కి పడమటి వైపు, ఉత్తరం వైపు, దక్షిణం వైపు, తూర్పు వైపు తేరి చూడు. ");
INSERT INTO tel2017_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","నీకు బదులుగా యెహోషువకు ఆజ్ఞాపించి, అతణ్ణి ప్రోత్సహించి, బలపరచు. అతడు ఈ ప్రజలను నడిపించి, నది దాటి, నువ్వు చూడబోయే దేశాన్ని వారు స్వాధీనపరచుకొనేలా చేస్తాడు.” ");
INSERT INTO tel2017_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ఆ సమయంలో మనం బేత్పయోరు ఎదుట ఉన్న లోయలో ఉన్నాం. ");
INSERT INTO tel2017_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","కాబట్టి ఇశ్రాయేలు ప్రజలారా, మీరు జీవించి మీ పూర్వీకుల దేవుడైన యెహోవా మీకిస్తున్న దేశంలో ప్రవేశించి దాన్ని స్వాధీనం చేసుకోవడానికి పాటించాల్సిన నియమాలు, కట్టడలు నేను మీకు బోధిస్తున్నాను. వినండి. ");
INSERT INTO tel2017_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","యెహోవా దేవుడు ఇచ్చిన ఆజ్ఞలను మీకందిస్తున్నాను. వాటిని పాటించడంలో నేను మీకు ఆజ్ఞాపించిన మాటతో దేనినీ కలపకూడదు, దానిలో నుండి దేనినీ తీసివేయకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","బయల్పెయోరు విషయంలో యెహోవా చేసినదాన్ని మీరు కళ్ళారా చూశారు కదా. బయల్పెయోరును వెంబడించిన ప్రతి పురుషుడినీ మీ యెహోవా దేవుడు మీ మధ్య ఉండకుండాా నాశనం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","యెహోవా దేవుణ్ణి హత్తుకొన్న మీరంతా ఈ రోజు వరకూ జీవించి ఉన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","యెహోవా దేవుడు నాకు ఆజ్ఞాపించిన విధంగా మీరు స్వాధీనం చేసుకోబోయే దేశంలో మీరు పాటించాల్సిన కట్టడలను, విధులను మీకు నేర్పాను. ");
INSERT INTO tel2017_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ఈ కట్టడలన్నిటినీ మీరు అంగీకరించి వాటిని అనుసరించాలి. వాటిని గూర్చి విన్న ప్రజల దృష్టికి అదే మీ జ్ఞానం, అదే మీ వివేకం. వారు మిమ్మల్ని చూసి “నిజంగా ఈ గొప్ప జాతి జ్ఞానం, వివేచన గల ప్రజలు” అని చెప్పుకుంటారు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","ఎందుకంటే మనం ఆయనకు మొర పెట్టిన ప్రతిసారీ మన యెహోవా దేవుడు మనకు సమీపంగా ఉన్నట్టు మరి ఏ గొప్ప జాతికి ఏ దేవుడు సమీపంగా ఉన్నాడు? ");
INSERT INTO tel2017_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ఈ రోజు నేను మీకు అప్పగిస్తున్న ఈ ధర్మశాస్త్రమంతటిలో ఉన్న కట్టడలు, నీతివిధులు కలిగి ఉన్న గొప్ప జనమేది? ");
INSERT INTO tel2017_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","అయితే మీరు జాగ్రత్తపడాలి. మీరు కళ్ళారా చూసిన వాటిని మరచిపోకుండా ఉండేలా, అవి మీ జీవితమంతా మీ హృదయాల్లో నుండి తొలగిపోకుండేలా, మీ మనస్సును బహు జాగ్రత్తగా కాపాడుకోండి. మీ కొడుకులకు, వారి కొడుకులకు వాటిని నేర్పించండి. ");
INSERT INTO tel2017_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","మీరు హోరేబులో మీ యెహోవా దేవుని సన్నిధిలో నిలబడి ఉన్నప్పుడు ఆయన, “నా దగ్గరికి ప్రజలను సమావేశపరచు. వారు ఆ దేశంలో నివసించే రోజులన్నీ నాకు భయపడడం నేర్చుకుని, తమ పిల్లలకు నేర్పేలా వారికి నా మాటలు వినిపిస్తాను అని ఆయన నాతో చెప్పాడు.” ");
INSERT INTO tel2017_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","అప్పుడు మీరు దగ్గరకి వచ్చి ఆ కొండ కింద నిలబడ్డారు. చీకటి, మేఘం, గాఢాంధకారం కమ్మి ఆ కొండ ఆకాశం వరకూ అగ్నితో మండుతుండగా ");
INSERT INTO tel2017_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","యెహోవా ఆ అగ్నిలో నుండి మీతో మాట్లాడాడు. మీరు ఆ మాటలు విన్నారు గాని ఏ రూపాన్నీ చూడలేదు, స్వరం మాత్రమే విన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","మీరు పాటించడానికి ఆయన విధించిన నిబంధనను, అంటే పది ఆజ్ఞలను మీకు తెలిపే రెండు రాతి పలకల మీద వాటిని రాశాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","అప్పుడు మీరు నది దాటి స్వాధీనం చేసుకోబోయే దేశంలో పాటించాల్సిన కట్టడలు, విధులను మీకు నేర్పమని యెహోవా నాకు ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","హోరేబులో యెహోవా అగ్నిజ్వాలల్లో నుండి మీతో మాట్లాడిన రోజు మీరు ఏ స్వరూపాన్నీ చూడలేదు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","కాబట్టి మీరు భూమి మీద ఉన్న ఏ జంతువు గాని, ");
INSERT INTO tel2017_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ఆకాశంలో ఎగిరే రెక్కలున్న ఏ పక్షి గాని, ");
INSERT INTO tel2017_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","నేలమీద పాకే ఏ పురుగు గాని, భూమి కింద ఉన్న నీళ్లలో ఏ చేప గాని, ఆడదైనా మగదైనా ఎలాటి ప్రతిమను ఏ స్వరూపంలోనైనా విగ్రహాన్ని మీ కోసం చేసుకుని చెడిపోకుండేలా జాగ్రత్త పడండి. ");
INSERT INTO tel2017_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ఆకాశం వైపు చూసి సూర్య చంద్ర నక్షత్రాలను, ఇంకా ఆకాశ సైన్యాలను చూసి మైమరచిపోయి మీ యెహోవా దేవుడు ఆకాశమంతటి కింద ఉన్న మనుషులందరి కోసం ఏర్పాటు చేసిన వాటికి నమస్కరించి, వాటిని పూజించకుండేలా మీరు ఎంతో జాగ్రత్త వహించండి. ");
INSERT INTO tel2017_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","యెహోవా మిమ్మల్ని తీసుకుని ఈ రోజులాగా మీరు తనకు స్వంత ప్రజలుగా ఉండడానికి, ఇనపకొలిమి లాంటి ఐగుప్తు దేశంలో నుండి మిమ్మల్ని రప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","యెహోవా మిమ్మల్ని బట్టి నా మీద కోపపడి, నేను ఈ యొర్దాను దాటకూడదనీ మీ యెహోవా దేవుడు స్వాస్థ్యంగా మీకిస్తున్న ఈ మంచి దేశంలో ప్రవేశింపకూడదనీ ఆజ్ఞాపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","కాబట్టి నేను ఈ యొర్దాను దాటకుండా ఈ దేశంలోనే చనిపోతాను. మీరు దాటి ఆ మంచి దేశాన్ని స్వాధీనం చేసుకుంటారు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","మీ దేవుడు యెహోవా మీకు ఏర్పరచిన నిబంధనను మరచి, మీ దేవుడైన యెహోవా మీకు ఆజ్ఞాపించిన ప్రకారం ఎలాంటి రూపంతోనైనా విగ్రహాన్ని చేసుకోకుండేలా జాగ్రత్తపడండి. ");
INSERT INTO tel2017_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ఎందుకంటే మీ దేవుడు యెహోవా దహించే అగ్ని, రోషం గల దేవుడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","మీరు పిల్లలను, వారు తమ పిల్లలను కని ఆ దేశంలో చాలా కాలం నివసించిన తరువాత మీరు చెడిపోయి, ఎలాంటి రూపంతోనైనా విగ్రహాలు చేసుకుని మీ యెహోవా దేవునికి కోపం పుట్టించి, ఆయన ఎదుట చెడు జరిగినప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","మీరు ఈ యొర్దాను దాటి స్వాధీనం చేసుకోబోయే దేశంలో ఉండకుండాా త్వరలోనే పూర్తిగా నాశనమై పోతారని భూమ్యాకాశాలను మీమీద సాక్షులుగా ఉంచుతున్నాను. ఆ దేశంలో ఎక్కువ రోజులు నిలబడకుండా మీరు పూర్తిగా నాశనమైపోతారు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","అంతేగాక యెహోవా మిమ్మల్ని వివిధ జాతుల మధ్యకు చెదరగొడతాడు. ఆయన మిమ్మల్ని ఎక్కడికి తోలివేస్తాడో అక్కడి ప్రజల్లో మీరు కొద్దిమందిగా మిగిలి ఉంటారు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","అక్కడ మీరు మనుష్యులు చేతితో చేసిన కర్ర, రాతి దేవుళ్ళను పూజిస్తారు. అవి చూడవు, వినవు, తినవు, వాసన చూడవు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","అయితే అక్కడ నుండి మీ దేవుడు యెహోవాను మీ పూర్ణహృదయంతో, పూర్ణాత్మతో వెతికితే, ఆయన మీకు ప్రత్యక్షమౌతాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ఈ సంగతులన్నీ జరిగి మీకు బాధ కలిగినప్పుడు చివరి రోజుల్లో మీరు మీ యెహోవా దేవుని వైపు చూసి ఆయన మాటకు లోబడినప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","మీ దేవుడు యెహోవా కనికరం గలవాడు కాబట్టి మీ చెయ్యి విడవడు, మిమ్మల్ని నాశనం చేయడు. తాను మీ పూర్వీకులతో చేసిన నిబంధన వాగ్దానాన్ని మరచిపోడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","దేవుడు భూమి మీద మానవుణ్ణి సృష్టించింది మొదలు, మీ కంటే ముందటి రోజుల్లో ఆకాశం ఈ దిక్కు నుండి ఆ దిక్కు వరకూ ఇలాటి గొప్ప కార్యం జరిగిందా? దీనిలాంటి వార్త వినబడిందా? అని అడుగు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","మీలా దేవుని స్వరం అగ్నిలో నుండి మాట్లాడడం విని మరి ఏ ప్రజలైనా జీవించారా? ");
INSERT INTO tel2017_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","మీ యెహోవా దేవుడు ఐగుప్తులో మా కళ్ళ ఎదుట చేసిన వాటన్నిటి ప్రకారం ఏ దేవుడైనా సరే, కష్టాలు, సూచక క్రియలు, మహత్కార్యాలు, యుద్ధం, బాహుబలం, చాచిన చేయి, మహా భయంకర కార్యాలు, వీటన్నిటితో ఎప్పుడైనా వచ్చి ఒక ప్రజలోనుండి తనకోసం ఒక జాతి ప్రజని తీసుకోడానికి ప్రయత్నించాడా? ");
INSERT INTO tel2017_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","అయితే యెహోవాయే దేవుడనీ, ఆయన తప్ప మరొకడు లేడనీ మీరు తెలుసుకొనేలా అది మీకు చూపించాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","మీకు బోధించడానికి ఆయన ఆకాశం నుండి తన స్వరాన్ని వినిపించాడు. భూమి మీద తన గొప్ప అగ్నిని మీకు చూపినప్పుడు ఆ అగ్నిలో నుండి ఆయన మాటలు మీరు విన్నారు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","ఆయన మీ పూర్వీకుల్ని ప్రేమించాడు కాబట్టి వారి తరువాత వారి సంతానాన్ని ఏర్పరచుకున్నాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","మీకంటే బలమైన గొప్ప జాతుల ప్రజలను మీ ఎదుట నుండి వెళ్లగొట్టి మిమ్మల్ని ప్రవేశపెట్టి ఆయన ఈ రోజు జరుగుతున్నట్టు వారి దేశాన్ని మీకు స్వాస్థ్యంగా ఇవ్వడానికి మీకు తోడుగా ఉండి ఐగుప్తు నుండి తన మహాబలంతో మిమ్మల్ని బయటికి రప్పించాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","కాబట్టి, పైన ఆకాశంలో, కింద భూమిపైనా యెహోవాయే దేవుడనీ, మరొక దేవుడు లేడనీ ఈరోజు గ్రహించండి. ");
INSERT INTO tel2017_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","అంతే గాక మీకు, మీ తరువాత మీ సంతానానికి సుఖశాంతులు కలగడానికి మీ యెహోవా దేవుడు ఎప్పటికీ మీకిస్తున్న దేశంలో మీకు దీర్ఘాయువు కలిగేలా నేను మీకాజ్ఞాపిస్తున్న ఆయన కట్టడలను, ఆజ్ఞలను మీరు పాటించాలి. ");
INSERT INTO tel2017_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ఎవరైనా ఉద్దేశపూర్వకంగా కాక, అనాలోచితంగా తన పొరుగువాణ్ణి చంపినప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","అతడు పారిపోడానికి మోషే తూర్పు దిక్కున, యొర్దాను ఇవతల మూడు పట్టణాలను ఎన్నిక చేశాడు. అలాటి వ్యక్తి ఎవరైనా ఉంటే అతడు పారిపోయి ఆ పట్టణాల్లో ప్రవేశించి జీవించవచ్చు. ");
INSERT INTO tel2017_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","అవేవంటే, రూబేనీయులకు మైదాన దేశపు ఎడారిలోని బేసెరు, గాదీయులకు గిలాదులో ఉన్న రామోతు, మనష్షీయులకు బాషానులో ఉన్న గోలాను. ");
INSERT INTO tel2017_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ఇదీ మోషే ఇశ్రాయేలీయులకు ఇచ్చిన ధర్మశాస్త్రం. ");
INSERT INTO tel2017_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ఇశ్రాయేలీయులు ఐగుప్తు నుండి బయటికి వస్తున్నప్పుడు ");
INSERT INTO tel2017_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","యొర్దాను ఇవతల బేత్పయోరు ఎదుటి లోయలో హెష్బోనులో, సీహోను రాజుగా పాలించే అమోరీయుల దేశంలో ");
INSERT INTO tel2017_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","మోషే ఇశ్రాయేలు ప్రజలకు నియమించిన శాసనాలు, కట్టడలు, న్యాయ విధులు ఇవి. ");
INSERT INTO tel2017_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","మోషే, ఇశ్రాయేలీయులు ఐగుప్తు నుండి వస్తూ ఆ సీహోనును చంపి అతని దేశాన్నీ యొర్దాను ఇవతల తూర్పు దిక్కున ఉన్న బాషాను రాజు ఓగు పాలించే దేశాన్నీ అర్నోను లోయలో ఉన్న అరోయేరు మొదలు హెర్మోను అనే సీయోను కొండ వరకూ ఉన్న అమోరీయుల ఇద్దరు రాజుల దేశాన్ని, ");
INSERT INTO tel2017_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","పిస్గా ఊటలకు కిందుగా అరాబా సముద్రం వరకూ తూర్పు దిక్కున యొర్దాను అవతల ఆరాబా ప్రదేశమంతటినీ స్వాధీనం చేసుకున్నారు. ");
INSERT INTO tel2017_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","మోషే ఇశ్రాయేలు ప్రజలందరినీ పిలిపించి ఇలా చెప్పాడు, “ఇశ్రాయేలు ప్రజలారా, నేను మీకు ఈ రోజు చెబుతున్న కట్టడలను, విధులను విని నేర్చుకుని వాటిని పాటించండి. ");
INSERT INTO tel2017_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","మన దేవుడు యెహోవా హోరేబులో మనతో ఒప్పందం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ఆయన మన పూర్వీకులతో కాదు, ఈ రోజు, ఇక్కడ జీవించి ఉన్న మనతోనే ఈ ఒప్పందం చేశాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","యెహోవా ఆ కొండ మీద అగ్నిలో నుండి ముఖాముఖిగా మీతో మాటలాడినప్పుడు మీరు ఆ అగ్నికి భయపడి ఆ కొండ ఎక్కలేదు. ");
INSERT INTO tel2017_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","కాబట్టి యెహోవా మాట మీకు తెలపడానికి నేను యెహోవాకూ మీకూ మధ్య నిలబడి ఉన్నప్పుడు యెహోవా ఇలా చెప్పాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘బానిసల గృహమైన ఐగుప్తు దేశంలో నుండి నిన్ను రప్పించిన నీ దేవుడనైన యెహోవాను నేనే. ");
INSERT INTO tel2017_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","నేను తప్ప వేరొక దేవుడు నీకుండకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","పైన ఉన్న ఆకాశంలో గాని, కింద ఉన్న భూమిపైనే గాని, భూమి కింద ఉన్న నీళ్లలోనే గాని ఉండే దేని పోలికలోనైనా విగ్రహాన్ని చేసుకోకూడదు. ");
INSERT INTO tel2017_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","వాటికి నమస్కరించకూడదు, వాటిని పూజింపకూడదు. మీ దేవుడైన యెహోవా అనే నేను రోషం గల దేవుణ్ణి. నన్ను ద్వేషించేవారి విషయంలో మూడు నాలుగు తరాల వరకూ తండ్రులు చేసిన దోషాన్ని కొడుకులపైకి రప్పిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","నన్ను ప్రేమించి నా ఆజ్ఞలు పాటించే వారి విషయంలో వెయ్యి తరాల వరకూ కరుణిస్తాను. ");
INSERT INTO tel2017_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","మీ దేవుడు యెహోవా పేరును అనవసరంగా పలకకూడదు, యెహోవా తన పేరును అనవసరంగా పలికేవాణ్ణి దోషిగా ఎంచుతాడు. ");
INSERT INTO tel2017_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","మీ యెహోవా దేవుడు మీకు ఆజ్ఞాపించినట్టు విశ్రాంతి దినాన్ని పరిశుద్ధంగా ఆచరించండి. ");
INSERT INTO tel2017_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ఆరు రోజులు మీరు కష్టపడి మీ పని చేయాలి. ");
INSERT INTO tel2017_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ఏడో రోజు మీ యెహోవా దేవునికి విశ్రాంతి దినం. ఆ రోజు మీరు, మీ కొడుకు, కూతురు, దాసుడు లేక దాసి, మీ ఎద్దు లేక గాడిద, మీ పశువుల్లో ఏదైనా సరే, మీ ఇంట్లో ఉన్న పరదేశితో సహా, ఏ పనీ చేయకూడదు. ఎందుకంటే మీకులాగా మీ దాసుడు, మీ దాసి కూడా విశ్రాంతి తీస